-- MySQL dump 10.13  Distrib 8.0.27, for Linux (x86_64)
--
-- Host: localhost    Database: condor
-- ------------------------------------------------------
-- Server version	8.0.27-0ubuntu0.20.04.1

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `Act`
--

DROP TABLE IF EXISTS `Act`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Act` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `title` varchar(64) DEFAULT NULL,
  `dateCreated` datetime DEFAULT NULL,
  `comments` mediumtext,
  `globalDisplayID` mediumint unsigned DEFAULT NULL,
  `displayID` mediumint unsigned DEFAULT NULL,
  `patientID` char(36) NOT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastAccessed` datetime NOT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Work_Patient` (`patientID`,`ownerID`),
  CONSTRAINT `fk_Act_Patient` FOREIGN KEY (`patientID`) REFERENCES `condor_patient_local`.`Patient` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Act`
--

LOCK TABLES `Act` WRITE;
/*!40000 ALTER TABLE `Act` DISABLE KEYS */;
INSERT INTO `Act` VALUES (1,'ef74541b-0f15-45e6-8b3a-a4aea68e4c21','','2022-01-03 16:39:18','',9,1,'7e877e30-84fb-4571-8971-9362793c192c','','',NULL,'2022-01-03 16:39:18','2022-01-03 16:39:27','2022-01-03 15:39:27','2022-01-03 16:39:18');
/*!40000 ALTER TABLE `Act` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AddressInfo`
--

DROP TABLE IF EXISTS `AddressInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AddressInfo` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `line_0` varchar(255) DEFAULT NULL,
  `line_1` varchar(255) DEFAULT NULL,
  `line_2` varchar(255) DEFAULT NULL,
  `detail` varchar(255) DEFAULT NULL,
  `cityName` varchar(255) DEFAULT NULL,
  `cityState` varchar(255) DEFAULT NULL,
  `cityZip` varchar(25) DEFAULT NULL,
  `countryName` varchar(255) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_AddressInfo_Professional` (`ownerID`),
  CONSTRAINT `fk_AddressInfo_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AddressInfo`
--

LOCK TABLES `AddressInfo` WRITE;
/*!40000 ALTER TABLE `AddressInfo` DISABLE KEYS */;
INSERT INTO `AddressInfo` VALUES (1,1,'Condor Labge','','',NULL,'Labege','','31670','France',NULL,NULL,'2019-02-04 14:27:24'),(3,1,'137 rue garance','','',NULL,'Labège','','31670','France',NULL,NULL,'2019-02-11 08:11:43'),(4,1,'137 rue garance','','',NULL,'labege','','31670','France',NULL,NULL,'2019-02-11 08:22:17'),(6,1,'','','',NULL,'Villiers sur marne','','','France',NULL,NULL,'2019-02-14 16:21:05'),(17,1,'','','',NULL,'Villenouvelle','','','France',NULL,NULL,'2019-04-30 07:42:46'),(19,1,'','','',NULL,'','','','',NULL,NULL,'2019-06-12 16:19:39'),(20,1,'','','',NULL,'','','','',NULL,NULL,'2019-06-12 16:34:57'),(21,1,'','','',NULL,'','','','',NULL,NULL,'2019-06-12 16:37:27'),(22,1,'','','',NULL,'Toulouse','','','France',NULL,NULL,'2019-06-12 16:44:40'),(26,1,'','','',NULL,'MERIGNAC','','','France',NULL,NULL,'2019-07-22 15:42:44'),(27,1,'','','',NULL,'','','','',NULL,NULL,'2019-08-06 13:04:19'),(28,1,'','','',NULL,'','','','',NULL,NULL,'2019-08-07 13:23:31'),(29,1,'','','',NULL,'MERIGNAC','','','France',NULL,NULL,'2019-08-29 16:20:47'),(31,1,'89 rue du Marquis de Sallmard','','',NULL,'TRAMOYES','','01390','France',NULL,NULL,'2019-11-12 08:51:58'),(35,1,'','','',NULL,'Toulouse','','','France',NULL,NULL,'2019-11-26 13:29:29'),(43,1,'avenue de Fleury','','',NULL,'Salles d\'Aude','','11110','France',NULL,NULL,'2020-01-30 09:23:49'),(50,1,'17, av de Fleury','','',NULL,'salles d\'aude','','11110','France',NULL,NULL,'2020-09-16 08:10:26'),(53,1,'','','',NULL,'Toulouse','','','France',NULL,NULL,'2020-10-21 14:37:51'),(54,1,'','','',NULL,'CHAMBERY','','','France',NULL,NULL,'2020-11-03 10:02:47');
/*!40000 ALTER TABLE `AddressInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Assistant`
--

DROP TABLE IF EXISTS `Assistant`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Assistant` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `patientRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'READ_ONLY',
  `actRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'READ_ONLY',
  `discussionRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'READ_ONLY',
  `credentialsID` mediumint unsigned DEFAULT NULL,
  `personInfoID` mediumint unsigned DEFAULT NULL,
  `phoneInfoID` mediumint unsigned DEFAULT NULL,
  `addressInfoID` mediumint unsigned DEFAULT NULL,
  `officeID` char(36) DEFAULT NULL,
  `tempPassword` varchar(32) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `lastConnection` timestamp NULL DEFAULT NULL,
  `firstConnection` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Assistant_Professional` (`ownerID`),
  KEY `fk_Assistant_Credentials` (`credentialsID`,`ownerID`),
  KEY `fk_Assistant_PersonInfo` (`personInfoID`,`ownerID`),
  KEY `fk_Assistant_PhoneInfo` (`phoneInfoID`,`ownerID`),
  KEY `fk_Assistant_AddressInfo` (`addressInfoID`,`ownerID`),
  KEY `fk_Assistant_Office` (`officeID`,`ownerID`),
  CONSTRAINT `fk_Assistant_AddressInfo` FOREIGN KEY (`addressInfoID`, `ownerID`) REFERENCES `AddressInfo` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Assistant_Credentials` FOREIGN KEY (`credentialsID`, `ownerID`) REFERENCES `Credentials` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Assistant_Office` FOREIGN KEY (`officeID`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Assistant_PersonInfo` FOREIGN KEY (`personInfoID`, `ownerID`) REFERENCES `PersonInfo` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Assistant_PhoneInfo` FOREIGN KEY (`phoneInfoID`, `ownerID`) REFERENCES `PhoneInfo` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Assistant_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Assistant`
--

LOCK TABLES `Assistant` WRITE;
/*!40000 ALTER TABLE `Assistant` DISABLE KEYS */;
/*!40000 ALTER TABLE `Assistant` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `Assistant_AFTER_DELETE` AFTER DELETE ON `Assistant` FOR EACH ROW BEGIN
	DELETE FROM PersonInfo  WHERE ownerID = OLD.ownerID AND id = OLD.personInfoID;
	DELETE FROM AddressInfo WHERE ownerID = OLD.ownerID AND id = OLD.addressInfoID;
	DELETE FROM PhoneInfo   WHERE ownerID = OLD.ownerID AND id = OLD.phoneInfoID;
	DELETE FROM Credentials WHERE ownerID = OLD.ownerID AND id = OLD.credentialsID;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `CircleOrder`
--

DROP TABLE IF EXISTS `CircleOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CircleOrder` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `actID` char(36) NOT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `title` varchar(64) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `status` enum('not_sent','waiting_wow_api','sending_wow_api','sending_circle_api','sent','cancelled') NOT NULL DEFAULT 'waiting_wow_api',
  `createdAt` datetime NOT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `json` text NOT NULL,
  `metadata` text NOT NULL,
  `localDisplayID` int unsigned DEFAULT NULL,
  `globalDisplayID` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_CircleOrder_Act` (`actID`,`ownerID`),
  CONSTRAINT `fk_CircleOrder_Act` FOREIGN KEY (`actID`, `ownerID`) REFERENCES `Act` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CircleOrder`
--

LOCK TABLES `CircleOrder` WRITE;
/*!40000 ALTER TABLE `CircleOrder` DISABLE KEYS */;
/*!40000 ALTER TABLE `CircleOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CircleOrderFile`
--

DROP TABLE IF EXISTS `CircleOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CircleOrderFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `orderID` char(36) NOT NULL,
  `fileID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`orderID`,`fileID`),
  KEY `fk_CircleOrderFile_CircleOrder` (`orderID`,`ownerID`),
  KEY `fk_CircleOrderFile_CondorFile` (`fileID`,`ownerID`),
  CONSTRAINT `fk_CircleOrderFile_CircleOrder` FOREIGN KEY (`orderID`, `ownerID`) REFERENCES `CircleOrder` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_CircleOrderFile_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CircleOrderFile`
--

LOCK TABLES `CircleOrderFile` WRITE;
/*!40000 ALTER TABLE `CircleOrderFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `CircleOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CondorFile`
--

DROP TABLE IF EXISTS `CondorFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CondorFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `path` text NOT NULL,
  `type` varchar(250) NOT NULL,
  `tag` varchar(250) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `originalName` varchar(100) DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `status` enum('CREATED','UPDATED','SYNCED','ERROR') DEFAULT NULL,
  `originalID` char(36) NOT NULL,
  `version` mediumint NOT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `metadata` text,
  PRIMARY KEY (`id`,`ownerID`),
  UNIQUE KEY `un_CondorFile_version` (`ownerID`,`originalID`,`version`),
  KEY `fk_CondorFile_Professional` (`ownerID`),
  KEY `fk_CondorFile_CondorFile` (`originalID`,`ownerID`),
  CONSTRAINT `fk_CondorFile_CondorFile` FOREIGN KEY (`originalID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_CondorFile_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CondorFile`
--

LOCK TABLES `CondorFile` WRITE;
/*!40000 ALTER TABLE `CondorFile` DISABLE KEYS */;
INSERT INTO `CondorFile` VALUES (1,'00949f49-2112-438f-a7cf-16567daf4658','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/00949f49-2112-438f-a7cf-16567daf4658.ply','PLY','PATIENT_a74b5bab-833a-4688-9466-2d4387e03c1d_ACT_18373db8-e00e-4f9c-baa9-68dac1d07ec2_SESS_482c9666-2b00-482a-94c3-66b01abb0503_BOSC_3f8bcc46-2ed9-40ad-99e2-cf987d1e14b8_PLY_','2020-11-07 09:57:45','2019-11-27 07:49:38','00949f49-2112-438f-a7cf-16567daf4658.ply','2020-11-07 10:57:45','SYNCED','00949f49-2112-438f-a7cf-16567daf4658',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 8.59.1.1.3\",\"modelMatrix\":\"0.992011,-0.116597,0.0481618,0,0.126152,0.916871,-0.378726,0,-1.73578e-10,0.381776,0.924255,0,15.0566,-8.02708,-19.7293,1\",\"title\":\"MAXILLAIRE PLY\"}'),(1,'00d868a3-e0c3-4d2d-8272-33b916f8e95e','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_7a6abf78-0493-467d-acf2-d8e624ad83fc/00d868a3-e0c3-4d2d-8272-33b916f8e95e.pdf','PDF','PATIENT_9f5c962b-3b08-45cf-98a9-8cdf5f0b3659_ACT_7482d5bd-25bf-450b-87d7-32326dc39cff_PROST_99d3894c-dd1b-4217-a77f-20554599ea89_PDF_','2019-11-25 17:00:03','2019-08-07 16:17:01','00d868a3-e0c3-4d2d-8272-33b916f8e95e.pdf','2019-11-25 18:00:03','SYNCED','00d868a3-e0c3-4d2d-8272-33b916f8e95e',0,'2019-09-09 14:05:40','','','{\"displayTitle\":\"BRIDGE SUR IMPLANT 7.3.2 BRIDGE SUR IMPLANT\",\"title\":\"Bridge sur Implant PDF\"}'),(1,'01321d34-981b-40e8-a74b-74691e06af94','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/01321d34-981b-40e8-a74b-74691e06af94.m','MATRX','PATIENT_6f54be3b-4604-426e-bf44-c0e09a217e80_ACT_94abec74-d6a4-4c4c-9da3-d674e05be9ba_SESS_94ee1c4b-bea6-487f-bf39-53570bfa5420_OCC_94ee1c4b-bea6-487f-bf39-535migraoccl_TOMA__MATRX_','2020-11-07 09:57:45','2019-06-06 10:03:45','01321d34-981b-40e8-a74b-74691e06af94.m','2020-11-07 10:57:45','SYNCED','01321d34-981b-40e8-a74b-74691e06af94',0,NULL,'','','{\"displayTitle\":\"Mandibule Occlusion 3.2.1.4.4\",\"title\":\"Matrice Transfo. Maxillaire MATRIX\"}'),(1,'028e56ca-9fd2-4eb4-92f8-25a8c2a00335','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_7a6abf78-0493-467d-acf2-d8e624ad83fc/028e56ca-9fd2-4eb4-92f8-25a8c2a00335.png','SNAPS','PATIENT_78842f97-ec97-49a7-8b6a-776d8f202e61_ACT_c7b31f13-4f61-44ed-995f-df2d228aed8c_SESS_cceb8198-3858-4357-8764-efc37edcbf8f_BOSC_6d8c6d91-9ae3-42f3-8679-22dec20d9b8f_SNAPS_','2021-06-14 14:15:33','2021-06-14 16:12:10','028e56ca-9fd2-4eb4-92f8-25a8c2a00335.png','2021-06-14 16:15:33','SYNCED','028e56ca-9fd2-4eb4-92f8-25a8c2a00335',0,NULL,'','','{\"displayTitle\":\"Mandibule 11.7.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1,'04767e57-c063-4280-bcea-6129cbd9d95a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_1e220661-7864-4e58-b9a0-adf6a924e40d/04767e57-c063-4280-bcea-6129cbd9d95a.stl','STL','PATIENT_6ffa3f1d-c48d-4158-b8c5-3d98e2d9dd4f_ACT_5f66ec30-8d44-4400-87d7-2bb86bdc5667_SESS_0c142631-f8b2-452a-a29f-b7adabaa8326_TOSC_84acc7ca-6d29-4e98-8ed8-8e9a0ec3f18d_STL_','2020-10-20 16:30:57','2019-06-12 18:16:33','04767e57-c063-4280-bcea-6129cbd9d95a.stl','2020-10-20 18:30:57','SYNCED','04767e57-c063-4280-bcea-6129cbd9d95a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 5.2.1.1.1\",\"modelMatrix\":\"-0.729505,-0.662886,0.168537,0,0.683975,-0.707012,0.179756,0,8.31046e-9,0.246407,0.969166,0,20.2767,6.26126,-25.6904,1\",\"title\":\"MAXILLAIRE STL\"}'),(1,'06d41446-0480-43ac-ad4a-41bfaf8745ad','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_7a6abf78-0493-467d-acf2-d8e624ad83fc/06d41446-0480-43ac-ad4a-41bfaf8745ad.json','JSON','PATIENT_64c1dc43-bea0-4698-b4a9-13c60ca492cc_ACT_5f66ec30-8d44-4400-87d7-2bb86bdc5667_PROST_1f8edd79-4b6f-4585-b4cb-31f85ef92d4f_JSON_','2019-11-25 17:00:03','2019-06-12 18:46:10','06d41446-0480-43ac-ad4a-41bfaf8745ad.json','2019-11-25 18:00:03','SYNCED','06d41446-0480-43ac-ad4a-41bfaf8745ad',0,NULL,'','','{\"displayTitle\":\"INLAY ONLAY 5.1.1 INLAY ONLAY\",\"title\":\"Inlay/Onlay JSON\"}'),(1,'07d4e99e-7817-425e-9888-6f9de3226805','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3296fbec-fc91-45de-9488-4f4f7a526b6e/07d4e99e-7817-425e-9888-6f9de3226805.png','SNAPS','PATIENT_7fec6224-9b40-43c3-90fa-e233535601b6_ACT_5c92cc6a-0b07-4817-bc97-999b47664e60_SESS_f9840640-e501-4b3a-8cd3-e2ad32249c33_TOSC_ab2c92fd-107f-4eb2-ae40-4b08f4f42ca8_SNAPS_','2020-11-07 09:57:45','2019-11-26 13:39:07','07d4e99e-7817-425e-9888-6f9de3226805.png','2020-11-07 10:57:45','SYNCED','07d4e99e-7817-425e-9888-6f9de3226805',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 8.55.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(1,'0fac9836-d7ba-4ef6-bcc8-0b582f6f5b69','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_39edd03b-189b-4cd8-b553-4fa5e59235ec/0fac9836-d7ba-4ef6-bcc8-0b582f6f5b69.png','SNAPS','PATIENT_fc5594bc-603f-4ecf-a370-d763ac33006d_ACT_bdfb331a-b542-4e39-9d1e-33bc8bb90aed_SESS_83e62b66-c8c2-49a0-ab0b-0dccf296d880_TOSC_e2845a2d-28ec-441f-9ca3-07a4f02804eb_SNAPS_','2020-11-07 09:57:48','2020-09-17 17:46:22','0fac9836-d7ba-4ef6-bcc8-0b582f6f5b69.png','2020-11-07 10:57:48','SYNCED','0fac9836-d7ba-4ef6-bcc8-0b582f6f5b69',0,NULL,'','','{\"displayTitle\":\"Maxillaire 11.1.1.1.9\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1,'10849da0-1050-11ea-96ce-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3296fbec-fc91-45de-9488-4f4f7a526b6e/10849da0-1050-11ea-96ce-96e674358d3a.png','SNAPS','PATIENT_7fec6224-9b40-43c3-90fa-e233535601b6_ACT_5c92cc6a-0b07-4817-bc97-999b47664e60_SESS_f9840640-e501-4b3a-8cd3-e2ad32249c33_TOSC_ab2c92fd-107f-4eb2-ae40-4b08f4f42ca8_SNAPS_','2020-10-20 16:30:57','2019-11-26 13:39:07','10849da0-1050-11ea-96ce-96e674358d3a.png','2020-10-20 18:30:57','SYNCED','10849da0-1050-11ea-96ce-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 8.55.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(1,'10863c63-1050-11ea-96ce-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3296fbec-fc91-45de-9488-4f4f7a526b6e/10863c63-1050-11ea-96ce-96e674358d3a.ply','PLY','PATIENT_7fec6224-9b40-43c3-90fa-e233535601b6_ACT_5c92cc6a-0b07-4817-bc97-999b47664e60_SESS_f9840640-e501-4b3a-8cd3-e2ad32249c33_TOSC_ab2c92fd-107f-4eb2-ae40-4b08f4f42ca8_PLY_','2020-10-20 16:30:58','2019-11-26 13:39:07','10863c63-1050-11ea-96ce-96e674358d3a.ply','2020-10-20 18:30:58','SYNCED','10863c63-1050-11ea-96ce-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 8.55.1.1.1\",\"modelMatrix\":\"0.872946,-0.479139,0.0916051,0,0.487817,0.857416,-0.163927,0,9.28475e-10,0.187786,0.98221,0,9.7526,-10.0712,-27.9672,1\",\"title\":\"MAXILLAIRE PLY\"}'),(1,'1087a7c1-1050-11ea-96ce-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3296fbec-fc91-45de-9488-4f4f7a526b6e/1087a7c1-1050-11ea-96ce-96e674358d3a.pdf','PDF','PATIENT_7fec6224-9b40-43c3-90fa-e233535601b6_ACT_5c92cc6a-0b07-4817-bc97-999b47664e60_PROST_056e763d-88fa-40da-8cdb-f2fb9912a1f3_PDF_','2020-09-14 14:58:20','2019-11-26 14:24:31','1087a7c1-1050-11ea-96ce-96e674358d3a.pdf','2020-09-14 16:58:20','SYNCED','1087a7c1-1050-11ea-96ce-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"COURONNE 8.55.1.1 COURONNE\",\"title\":\"Couronne PDF\"}'),(1,'108946c1-1050-11ea-96ce-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3296fbec-fc91-45de-9488-4f4f7a526b6e/108946c1-1050-11ea-96ce-96e674358d3a.json','JSON','PATIENT_7fec6224-9b40-43c3-90fa-e233535601b6_ACT_5c92cc6a-0b07-4817-bc97-999b47664e60_PROST_056e763d-88fa-40da-8cdb-f2fb9912a1f3_JSON_','2020-09-14 14:58:20','2019-11-26 14:24:31','108946c1-1050-11ea-96ce-96e674358d3a.json','2020-09-14 16:58:20','SYNCED','108946c1-1050-11ea-96ce-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"COURONNE 8.55.1.1 COURONNE\",\"title\":\"Couronne JSON\"}'),(1,'1315936d-c363-4301-b8d0-62b15029c222','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_7a6abf78-0493-467d-acf2-d8e624ad83fc/1315936d-c363-4301-b8d0-62b15029c222.zip','ZIP','PATIENT_78842f97-ec97-49a7-8b6a-776d8f202e61_ACT_c7b31f13-4f61-44ed-995f-df2d228aed8c_SESS_cceb8198-3858-4357-8764-efc37edcbf8f_OCC_45d7248e-d60c-48d5-9f2a-3cc5aaea3aca_TOPLY__ZIP_','2021-06-14 14:30:28','2021-06-14 16:30:22','1315936d-c363-4301-b8d0-62b15029c222.zip','2021-06-14 16:30:28','SYNCED','1315936d-c363-4301-b8d0-62b15029c222',0,NULL,'','','{\"displayTitle\":\"Maxillaire 11.7.1.1.2 Occlusion 1\",\"modelMatrix\":\"-0.999905,-0.0132502,0.00371127,0,0.0137602,-0.96285,0.269685,0,9.22008e-11,0.269711,0.962941,0,-7.66698,-31.4043,-20.1633,1\",\"referenceScanID\":\"11.7.1.1.2\",\"title\":\"Maxillaire 11.7.1.1.2 Occlusion 1\"}'),(1,'13861d2d-7322-4e2d-bc82-e2c013ce7a5a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/13861d2d-7322-4e2d-bc82-e2c013ce7a5a.png','SCREENS','PATIENT_7fec6224-9b40-43c3-90fa-e233535601b6_ACT_5c92cc6a-0b07-4817-bc97-999b47664e60_SESS_f9840640-e501-4b3a-8cd3-e2ad32249c33_TOSC_ab2c92fd-107f-4eb2-ae40-4b08f4f42ca8_SCREENS_','2020-10-20 16:30:58','2019-11-26 15:58:50','13861d2d-7322-4e2d-bc82-e2c013ce7a5a.png','2020-10-20 18:30:58','SYNCED','13861d2d-7322-4e2d-bc82-e2c013ce7a5a',0,NULL,'','','{\"displayTitle\":\"Screenshot 8.55.1.1.1 MAXILLAIRE 3\",\"scanFileId\":\"b4a3a43f-41bb-4780-afd3-c3f736199be1\",\"scanFileType\":\"PLY\",\"scanPosition\":\"1,0,0,0,0,-1,1.22465e-16,0,0,-1.22465e-16,-1,0,0,0,0,1\",\"title\":\"MAXILLAIRE 3\"}'),(1,'13dbf97a-6239-46a8-856d-f1e125cdcde0','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_7a6abf78-0493-467d-acf2-d8e624ad83fc/13dbf97a-6239-46a8-856d-f1e125cdcde0.m','MATRX','PATIENT_78842f97-ec97-49a7-8b6a-776d8f202e61_ACT_c7b31f13-4f61-44ed-995f-df2d228aed8c_SESS_cceb8198-3858-4357-8764-efc37edcbf8f_OCC_5e232b66-e878-40a9-81c0-0005877fb5bf_TOMA__MATRX_','2021-06-14 14:31:36','2021-06-14 16:31:28','13dbf97a-6239-46a8-856d-f1e125cdcde0.m','2021-06-14 16:31:36','SYNCED','13dbf97a-6239-46a8-856d-f1e125cdcde0',0,NULL,'','','{\"displayTitle\":\"Matrice Transfo. Maxillaire 11.7.1.1.2 Occlusion 2\",\"referenceScanID\":\"11.7.1.1.2\",\"title\":\"Matrice Transfo. Maxillaire 11.7.1.1.2 Occlusion 2\"}'),(1,'13f44cb4-d435-41c0-ae45-122b4949147b','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/13f44cb4-d435-41c0-ae45-122b4949147b.json','JSON','PATIENT_7907dfb3-1b78-4cbf-ad42-25c9b7b739d5_ACT_86ce6e3a-d2a4-4280-ae4b-d238bd053895_PROST_57aa8cf8-15ed-4fb1-a7da-4171ffb1bdf6_JSON_','2019-11-26 17:19:06','2019-11-26 18:19:06','13f44cb4-d435-41c0-ae45-122b4949147b.json','2019-11-26 18:19:06','SYNCED','13f44cb4-d435-41c0-ae45-122b4949147b',0,NULL,'','','{\"displayTitle\":\"INLAY ONLAY 8.1.1.1 INLAY ONLAY\",\"title\":\"Inlay/Onlay JSON\"}'),(1,'141b2582-1df5-4a7d-89cf-ccbab45f4155','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/141b2582-1df5-4a7d-89cf-ccbab45f4155.png','SNAPS','PATIENT_a74b5bab-833a-4688-9466-2d4387e03c1d_ACT_18373db8-e00e-4f9c-baa9-68dac1d07ec2_SESS_482c9666-2b00-482a-94c3-66b01abb0503_BOSC_ab2f81fc-4f2a-4837-98e2-18be13aaab29_SNAPS_','2020-11-07 09:57:50','2019-11-27 07:44:45','141b2582-1df5-4a7d-89cf-ccbab45f4155.png','2020-11-07 10:57:50','SYNCED','141b2582-1df5-4a7d-89cf-ccbab45f4155',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 8.59.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(1,'160bbb01-17ff-4718-947a-dd4f81e8c894','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/160bbb01-17ff-4718-947a-dd4f81e8c894.json','JSON','PATIENT_7fec6224-9b40-43c3-90fa-e233535601b6_ACT_5c92cc6a-0b07-4817-bc97-999b47664e60_PROST_61fbccd0-b247-4bf5-b093-f3ab41f039f7_JSON_','2019-11-26 15:57:09','2019-11-26 16:57:08','160bbb01-17ff-4718-947a-dd4f81e8c894.json','2019-11-26 16:57:09','SYNCED','160bbb01-17ff-4718-947a-dd4f81e8c894',0,NULL,'','','{\"displayTitle\":\"FACETTE 8.55.1.5 FACETTE\",\"title\":\"Facette JSON\"}'),(1,'175d0ba4-b3e6-4854-a614-023a725d109b','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_7a6abf78-0493-467d-acf2-d8e624ad83fc/175d0ba4-b3e6-4854-a614-023a725d109b.zip','ZIP','PATIENT_78842f97-ec97-49a7-8b6a-776d8f202e61_ACT_c7b31f13-4f61-44ed-995f-df2d228aed8c_SESS_cceb8198-3858-4357-8764-efc37edcbf8f_RISC_1b169fde-0d96-46d4-afa5-b79f241f5575_ZIP_','2021-06-14 14:28:34','2021-06-14 16:28:33','175d0ba4-b3e6-4854-a614-023a725d109b.zip','2021-06-14 16:28:34','SYNCED','175d0ba4-b3e6-4854-a614-023a725d109b',0,NULL,'','','{\"displayTitle\":\"Mordu posterieur droit 11.7.1.1.2\",\"modelMatrix\":\"0.9904,0.0955507,0.0958701,0,-0.0542203,0.9154,-0.395297,0,-0.127246,0.391098,0.913548,0,-17.0082,-20.1993,-13.6086,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1,'18189f00-7e7d-49e1-8151-de39bf0132fe','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/18189f00-7e7d-49e1-8151-de39bf0132fe.png','SCREENS','PATIENT_7fec6224-9b40-43c3-90fa-e233535601b6_ACT_5c92cc6a-0b07-4817-bc97-999b47664e60_SESS_f9840640-e501-4b3a-8cd3-e2ad32249c33_TOSC_ab2c92fd-107f-4eb2-ae40-4b08f4f42ca8_SCREENS_','2020-10-20 16:30:58','2019-11-26 15:47:18','18189f00-7e7d-49e1-8151-de39bf0132fe.png','2020-10-20 18:30:58','SYNCED','18189f00-7e7d-49e1-8151-de39bf0132fe',0,NULL,'','','{\"displayTitle\":\"Screenshot 8.55.1.1.1 MAXILLAIRE 2\",\"scanFileId\":\"b4a3a43f-41bb-4780-afd3-c3f736199be1\",\"scanFileType\":\"PLY\",\"scanPosition\":\"0.998849,0.0412672,0.0244643,0,0.0137367,-0.734623,0.678336,0,0.0459651,-0.677219,-0.734344,0,0,0,0,1\",\"title\":\"MAXILLAIRE 2\"}'),(1,'192a0c10-fe5d-43bf-ad68-58d57ba23432','','ZIP','PATIENT_78842f97-ec97-49a7-8b6a-776d8f202e61_ACT_c7b31f13-4f61-44ed-995f-df2d228aed8c_SESS_cceb8198-3858-4357-8764-efc37edcbf8f_TOSC_1b4721aa-af54-40da-a758-ffb23b6a1af9_ZIP_','2021-06-14 13:59:25','2021-06-14 15:56:45','','2021-06-14 15:59:25','SYNCED','192a0c10-fe5d-43bf-ad68-58d57ba23432',0,NULL,'','','{\"displayTitle\":\"Maxillaire 11.7.1.1.1\",\"modelMatrix\":\"-0.957416,0.282143,-0.0612373,0,-0.288712,-0.935632,0.203073,0,1.82867e-9,0.212105,0.977247,0,-15.6363,-30.7518,-22.0525,1\",\"title\":\"Maxillaire ZIP\"}'),(1,'19cf3b9a-8103-493a-add8-799541ed5110','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_c96239ca-4da5-41fa-b243-e09fcb750abd/19cf3b9a-8103-493a-add8-799541ed5110.pdf','PDF','PATIENT_64c1dc43-bea0-4698-b4a9-13c60ca492cc_ACT_4782d962-93f8-43ba-a78f-3ea7bae2af06_PROST_b7491db8-0cb2-472b-a36e-8ae60408ef8b_PDF_','2019-11-25 17:00:03','2019-06-12 17:54:17','19cf3b9a-8103-493a-add8-799541ed5110.pdf','2019-11-25 18:00:03','SYNCED','19cf3b9a-8103-493a-add8-799541ed5110',0,NULL,'','','{\"displayTitle\":\"COURONNE SUR IMPLANT 5.1.1 COURONNE SUR IMPLANT\",\"title\":\"Couronne sur Implant PDF\"}'),(1,'1b60cbaf-3697-43bd-8356-b24f9de49a5d','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_7a6abf78-0493-467d-acf2-d8e624ad83fc/1b60cbaf-3697-43bd-8356-b24f9de49a5d.png','SNAPS','PATIENT_78842f97-ec97-49a7-8b6a-776d8f202e61_ACT_c7b31f13-4f61-44ed-995f-df2d228aed8c_SESS_cceb8198-3858-4357-8764-efc37edcbf8f_FRSC_a7f7b44b-e00f-4476-8eb5-7e7caf65845a_SNAPS_','2021-06-14 14:27:51','2021-06-14 16:27:47','1b60cbaf-3697-43bd-8356-b24f9de49a5d.png','2021-06-14 16:27:51','SYNCED','1b60cbaf-3697-43bd-8356-b24f9de49a5d',0,NULL,'','','{\"displayTitle\":\"Mordu anterieur 11.7.1.1.2\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1,'1e1ece48-093f-423d-bb99-c29c44607531','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/1e1ece48-093f-423d-bb99-c29c44607531.png','SNAPS','PATIENT_d9bfe450-05c7-401c-995e-10be4eba5be5_ACT_68618536-aec2-462e-b599-c206849953af_SESS_62692c3b-0c98-4ac5-9ed4-2907dd8e212f_TOSC_095206f4-b770-4084-8462-7a6b17880d77_SNAPS_','2020-11-07 09:57:51','2019-11-26 14:56:00','1e1ece48-093f-423d-bb99-c29c44607531.png','2020-11-07 10:57:51','SYNCED','1e1ece48-093f-423d-bb99-c29c44607531',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 8.56.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(1,'1e5d50db-3a34-48be-9cc3-4ea85d82a5fa','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_7a6abf78-0493-467d-acf2-d8e624ad83fc/1e5d50db-3a34-48be-9cc3-4ea85d82a5fa.zip','ZIP','PATIENT_78842f97-ec97-49a7-8b6a-776d8f202e61_ACT_c7b31f13-4f61-44ed-995f-df2d228aed8c_SESS_cceb8198-3858-4357-8764-efc37edcbf8f_FRSC_8fcfb199-cfc9-441b-88bd-674065e0d26b_ZIP_','2021-06-14 14:27:41','2021-06-14 16:26:43','1e5d50db-3a34-48be-9cc3-4ea85d82a5fa.zip','2021-06-14 16:27:41','SYNCED','1e5d50db-3a34-48be-9cc3-4ea85d82a5fa',0,NULL,'','','{\"displayTitle\":\"Mordu anterieur 11.7.1.1.1\",\"modelMatrix\":\"0.79477,0.122262,0.593495,0,0.0112902,0.975205,-0.209322,0,-0.606823,0.184907,0.77724,0,13.9737,-2.3731,-31.7395,1\",\"title\":\"Mordu anterieur ZIP\"}'),(1,'1e70139f-3cc4-4a06-9ddb-72c90003e32f','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_c96239ca-4da5-41fa-b243-e09fcb750abd/1e70139f-3cc4-4a06-9ddb-72c90003e32f.json','JSON','PATIENT_a74b5bab-833a-4688-9466-2d4387e03c1d_ACT_18373db8-e00e-4f9c-baa9-68dac1d07ec2_PROST_cb108a6c-b733-4aa5-a265-4a1b66b5bb75_JSON_','2020-11-07 09:57:52','2020-09-15 10:25:04','1e70139f-3cc4-4a06-9ddb-72c90003e32f.json','2020-11-07 10:57:52','SYNCED','1e70139f-3cc4-4a06-9ddb-72c90003e32f',0,NULL,'','','{\"displayTitle\":\"COURONNE 8.59.1.9.9 COURONNE\",\"title\":\"Couronne JSON\"}'),(1,'21676af8-1320-42e8-9f34-63a455f0b05f','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/21676af8-1320-42e8-9f34-63a455f0b05f.json','JSON','PATIENT_7fec6224-9b40-43c3-90fa-e233535601b6_ACT_5c92cc6a-0b07-4817-bc97-999b47664e60_PROST_b655a8d6-f80f-4b44-8bc2-aa2fe933fc54_JSON_','2020-09-14 14:58:20','2019-11-26 14:32:46','21676af8-1320-42e8-9f34-63a455f0b05f.json','2020-09-14 16:58:20','SYNCED','21676af8-1320-42e8-9f34-63a455f0b05f',0,NULL,'','','{\"displayTitle\":\"INLAY ONLAY 8.55.1.2 INLAY ONLAY\",\"title\":\"Inlay/Onlay JSON\"}'),(1,'222973a9-29e4-4dea-91c0-9d860952fe34','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_7a6abf78-0493-467d-acf2-d8e624ad83fc/222973a9-29e4-4dea-91c0-9d860952fe34.zip','ZIP','PATIENT_78842f97-ec97-49a7-8b6a-776d8f202e61_ACT_c7b31f13-4f61-44ed-995f-df2d228aed8c_SESS_cceb8198-3858-4357-8764-efc37edcbf8f_OCC_45d7248e-d60c-48d5-9f2a-3cc5aaea3aca_BOPLY__ZIP_','2021-06-14 14:30:26','2021-06-14 16:30:22','222973a9-29e4-4dea-91c0-9d860952fe34.zip','2021-06-14 16:30:26','SYNCED','222973a9-29e4-4dea-91c0-9d860952fe34',0,NULL,'','','{\"displayTitle\":\"Mandibule 11.7.1.1.2 Occlusion 1\",\"modelMatrix\":\"0.996284,-0.0855673,0.00978113,0,0.0861245,0.989838,-0.113148,0,-5.50591e-10,0.11357,0.99353,0,-21.1434,11.2593,-22.3189,1\",\"referenceScanID\":\"11.7.1.1.2\",\"title\":\"Mandibule 11.7.1.1.2 Occlusion 1\"}'),(1,'22bb764c-129b-4230-8497-b6401cf04733','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_39edd03b-189b-4cd8-b553-4fa5e59235ec/22bb764c-129b-4230-8497-b6401cf04733.pdf','PDF','PATIENT_392ed6a5-fcff-466b-9677-a1aa24771b54_ACT_bc7415da-45a9-4dfa-a4f6-330b9e5f33b0_PROST_2e43389a-0785-4c6a-a481-204442bba3d2_PDF_','2020-10-20 16:30:59','2020-07-20 14:29:29','22bb764c-129b-4230-8497-b6401cf04733.pdf','2020-10-20 18:30:59','SYNCED','22bb764c-129b-4230-8497-b6401cf04733',0,NULL,'','','{\"displayTitle\":\"COURONNE 10.2.1.1 COURONNE\",\"title\":\"Couronne PDF\"}'),(1,'2383bba0-87fe-481a-bbcb-d1540b6805a2','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/2383bba0-87fe-481a-bbcb-d1540b6805a2.png','SNAPS','PATIENT_a74b5bab-833a-4688-9466-2d4387e03c1d_ACT_18373db8-e00e-4f9c-baa9-68dac1d07ec2_SESS_482c9666-2b00-482a-94c3-66b01abb0503_TOSC_f9a6cad6-67cc-41e0-8a41-1a930cf7dfba_SNAPS_','2020-11-07 09:57:53','2019-11-27 07:49:51','2383bba0-87fe-481a-bbcb-d1540b6805a2.png','2020-11-07 10:57:53','SYNCED','2383bba0-87fe-481a-bbcb-d1540b6805a2',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 8.59.1.1.4\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(1,'24938b5d-f0cf-40ab-b3c8-0910dd7c1212','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_7a6abf78-0493-467d-acf2-d8e624ad83fc/24938b5d-f0cf-40ab-b3c8-0910dd7c1212.png','SNAPS','PATIENT_78842f97-ec97-49a7-8b6a-776d8f202e61_ACT_c7b31f13-4f61-44ed-995f-df2d228aed8c_SESS_cceb8198-3858-4357-8764-efc37edcbf8f_RISC_c1ffbf8c-9166-4820-b5d8-2a8332e41f18_SNAPS_','2021-06-14 14:19:31','2021-06-14 16:18:36','24938b5d-f0cf-40ab-b3c8-0910dd7c1212.png','2021-06-14 16:19:31','SYNCED','24938b5d-f0cf-40ab-b3c8-0910dd7c1212',0,NULL,'','','{\"displayTitle\":\"Mordu posterieur droit 11.7.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1,'2ea89171-654f-401d-a8a8-c368a1991b44','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/2ea89171-654f-401d-a8a8-c368a1991b44.png','SNAPS','PATIENT_6f54be3b-4604-426e-bf44-c0e09a217e80_ACT_94abec74-d6a4-4c4c-9da3-d674e05be9ba_SESS_94ee1c4b-bea6-487f-bf39-53570bfa5420_RISC_7710c402-baef-4829-a485-61f299cfeca2_SNAPS_','2020-11-07 09:57:55','2019-06-06 10:03:31','2ea89171-654f-401d-a8a8-c368a1991b44.png','2020-11-07 10:57:55','SYNCED','2ea89171-654f-401d-a8a8-c368a1991b44',0,NULL,'','','{\"displayTitle\":\"Mordu posterieur droit 0\",\"title\":\"MORDU_POSTERIEUR_DROIT SNAPSHOT\"}'),(1,'31957f90-bb27-434a-9544-ae72ec8e7ca4','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/31957f90-bb27-434a-9544-ae72ec8e7ca4.ply','PLY','PATIENT_d9bfe450-05c7-401c-995e-10be4eba5be5_ACT_68618536-aec2-462e-b599-c206849953af_SESS_62692c3b-0c98-4ac5-9ed4-2907dd8e212f_TOSC_095206f4-b770-4084-8462-7a6b17880d77_PLY_','2020-11-07 09:57:57','2019-11-26 14:56:00','31957f90-bb27-434a-9544-ae72ec8e7ca4.ply','2020-11-07 10:57:57','SYNCED','31957f90-bb27-434a-9544-ae72ec8e7ca4',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 8.56.1.1.1\",\"modelMatrix\":\"0.90494,-0.420881,0.0627834,0,0.425538,0.895037,-0.133514,0,-6.11416e-10,0.147539,0.989056,0,-0.534257,0.579992,-14.9925,1\",\"title\":\"MAXILLAIRE PLY\"}'),(1,'31c143d3-5616-4584-9786-40571935a48f','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_7a6abf78-0493-467d-acf2-d8e624ad83fc/31c143d3-5616-4584-9786-40571935a48f.zip','ZIP','PATIENT_78842f97-ec97-49a7-8b6a-776d8f202e61_ACT_c7b31f13-4f61-44ed-995f-df2d228aed8c_SESS_cceb8198-3858-4357-8764-efc37edcbf8f_OCC_5e232b66-e878-40a9-81c0-0005877fb5bf_TOPLY__ZIP_','2021-06-14 14:31:42','2021-06-14 16:31:28','31c143d3-5616-4584-9786-40571935a48f.zip','2021-06-14 16:31:42','SYNCED','31c143d3-5616-4584-9786-40571935a48f',0,NULL,'','','{\"displayTitle\":\"Maxillaire 11.7.1.1.2 Occlusion 2\",\"modelMatrix\":\"-0.999905,-0.0132502,0.00371127,0,0.0137602,-0.96285,0.269685,0,9.22008e-11,0.269711,0.962941,0,-7.66698,-31.4043,-20.1633,1\",\"referenceScanID\":\"11.7.1.1.2\",\"title\":\"Maxillaire 11.7.1.1.2 Occlusion 2\"}'),(1,'324d2d94-a373-48d0-9a2a-6093e91dd65b','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_7a6abf78-0493-467d-acf2-d8e624ad83fc/324d2d94-a373-48d0-9a2a-6093e91dd65b.json','JSON','PATIENT_9f5c962b-3b08-45cf-98a9-8cdf5f0b3659_ACT_29fbc46f-2df2-4b38-bd76-82dec3035b1b_PROST_bcb7a620-4df2-44bc-99aa-34c315924974_JSON_','2019-11-25 17:00:03','2019-08-06 13:59:21','324d2d94-a373-48d0-9a2a-6093e91dd65b.json','2019-11-25 18:00:03','SYNCED','324d2d94-a373-48d0-9a2a-6093e91dd65b',0,'2019-09-09 14:05:41','','','{\"displayTitle\":\"INLAY ONLAY 7.3.1 INLAY ONLAY\",\"title\":\"Inlay/Onlay JSON\"}'),(1,'33302343-3bb1-4e08-ae84-2b6b550e21fe','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_7a6abf78-0493-467d-acf2-d8e624ad83fc/33302343-3bb1-4e08-ae84-2b6b550e21fe.png','SNAPS','PATIENT_78842f97-ec97-49a7-8b6a-776d8f202e61_ACT_c7b31f13-4f61-44ed-995f-df2d228aed8c_SESS_cceb8198-3858-4357-8764-efc37edcbf8f_RISC_1b169fde-0d96-46d4-afa5-b79f241f5575_SNAPS_','2021-06-14 14:28:34','2021-06-14 16:28:33','33302343-3bb1-4e08-ae84-2b6b550e21fe.png','2021-06-14 16:28:34','SYNCED','33302343-3bb1-4e08-ae84-2b6b550e21fe',0,NULL,'','','{\"displayTitle\":\"Mordu posterieur droit 11.7.1.1.2\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1,'334e3796-2c05-4f64-b13f-f1990ab701b2','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/334e3796-2c05-4f64-b13f-f1990ab701b2.ply','PLY','PATIENT_7fec6224-9b40-43c3-90fa-e233535601b6_ACT_5c92cc6a-0b07-4817-bc97-999b47664e60_SESS_f9840640-e501-4b3a-8cd3-e2ad32249c33_TOSC_1ab959f6-83d4-4805-822a-0c00edce5a5b_PLY_','2020-11-07 09:57:57','2019-11-26 16:40:28','334e3796-2c05-4f64-b13f-f1990ab701b2.ply','2020-11-07 10:57:57','SYNCED','334e3796-2c05-4f64-b13f-f1990ab701b2',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 8.55.1.1.2\",\"modelMatrix\":\"-0.807132,-0.589565,0.0308376,0,0.590371,-0.80603,0.0421599,0,3.30266e-9,0.0522342,0.998635,0,-14.5221,-8.90108,-24.3958,1\",\"title\":\"MAXILLAIRE PLY\"}'),(1,'3510e4d3-d145-4b43-9962-37f436a70ca7','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_7a6abf78-0493-467d-acf2-d8e624ad83fc/3510e4d3-d145-4b43-9962-37f436a70ca7.m','MATRX','PATIENT_78842f97-ec97-49a7-8b6a-776d8f202e61_ACT_c7b31f13-4f61-44ed-995f-df2d228aed8c_SESS_cceb8198-3858-4357-8764-efc37edcbf8f_OCC_45d7248e-d60c-48d5-9f2a-3cc5aaea3aca_BOMA__MATRX_','2021-06-14 14:30:28','2021-06-14 16:30:22','3510e4d3-d145-4b43-9962-37f436a70ca7.m','2021-06-14 16:30:28','SYNCED','3510e4d3-d145-4b43-9962-37f436a70ca7',0,NULL,'','','{\"displayTitle\":\"Matrice Transfo. Mandibule 11.7.1.1.2 Occlusion 1\",\"referenceScanID\":\"11.7.1.1.2\",\"title\":\"Matrice Transfo. Mandibule 11.7.1.1.2 Occlusion 1\"}'),(1,'356bae49-0db7-4a21-aaf7-b0af18a2cc93','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_7a6abf78-0493-467d-acf2-d8e624ad83fc/356bae49-0db7-4a21-aaf7-b0af18a2cc93.png','SNAPS','PATIENT_78842f97-ec97-49a7-8b6a-776d8f202e61_ACT_c7b31f13-4f61-44ed-995f-df2d228aed8c_SESS_cceb8198-3858-4357-8764-efc37edcbf8f_OCC_45d7248e-d60c-48d5-9f2a-3cc5aaea3aca_SNAPO__SNAPS_','2021-06-14 14:30:26','2021-06-14 16:30:22','356bae49-0db7-4a21-aaf7-b0af18a2cc93.png','2021-06-14 16:30:26','SYNCED','356bae49-0db7-4a21-aaf7-b0af18a2cc93',0,NULL,'','','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1,'35dad331-33de-11eb-973a-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_82ca34c0-5553-470e-9bed-5b7e9bedc4d9/35dad331-33de-11eb-973a-96e674358d3a.ply','PLY','PATIENT_20db9968-3a56-48e4-9a0b-1e0c97633cda_ACT_ae7f5446-27c2-475b-9c90-29261d7478b9_SESS_d593215e-c6bd-4ca8-8f71-2d9f7c70d912_TOSC_cb539b59-5dc3-49fb-8c4e-3a554b96eee6_PLY_','2020-11-30 08:29:28','2020-11-30 09:29:24','35dad331-33de-11eb-973a-96e674358d3a.ply','2020-11-30 09:29:28','SYNCED','35dad331-33de-11eb-973a-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.17.3.3.1\",\"modelMatrix\":\"0.787925,0.611344,-0.0737045,0,-0.615771,0.782261,-0.0943105,0,-1.76976e-9,0.119695,0.992811,0,-27.8201,-8.48808,-17.0182,1\",\"title\":\"Maxillaire PLY\"}'),(1,'35dc7207-33de-11eb-973a-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_82ca34c0-5553-470e-9bed-5b7e9bedc4d9/35dc7207-33de-11eb-973a-96e674358d3a.png','SNAPS','PATIENT_20db9968-3a56-48e4-9a0b-1e0c97633cda_ACT_ae7f5446-27c2-475b-9c90-29261d7478b9_SESS_d593215e-c6bd-4ca8-8f71-2d9f7c70d912_TOSC_cb539b59-5dc3-49fb-8c4e-3a554b96eee6_SNAPS_','2020-11-30 08:29:26','2020-11-30 09:29:24','35dc7207-33de-11eb-973a-96e674358d3a.png','2020-11-30 09:29:26','SYNCED','35dc7207-33de-11eb-973a-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.17.3.3.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1,'36de5259-9328-483c-8c59-aad3134d4b2b','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_39edd03b-189b-4cd8-b553-4fa5e59235ec/36de5259-9328-483c-8c59-aad3134d4b2b.pdf','PDF','PATIENT_fc5594bc-603f-4ecf-a370-d763ac33006d_ACT_bdfb331a-b542-4e39-9d1e-33bc8bb90aed_PROST_f2192709-5947-4789-b255-0d7e11707a32_PDF_','2020-11-07 09:57:58','2020-09-29 10:56:36','36de5259-9328-483c-8c59-aad3134d4b2b.pdf','2020-11-07 10:57:58','SYNCED','36de5259-9328-483c-8c59-aad3134d4b2b',0,NULL,'','','{\"displayTitle\":\"COURONNE 11.1.1.9.9 COURONNE\",\"title\":\"Couronne PDF\"}'),(1,'3ac1dbee-6513-43bd-a084-122da32ec6db','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_7a6abf78-0493-467d-acf2-d8e624ad83fc/3ac1dbee-6513-43bd-a084-122da32ec6db.png','SNAPS','PATIENT_78842f97-ec97-49a7-8b6a-776d8f202e61_ACT_c7b31f13-4f61-44ed-995f-df2d228aed8c_SESS_cceb8198-3858-4357-8764-efc37edcbf8f_FRSC_8fcfb199-cfc9-441b-88bd-674065e0d26b_SNAPS_','2021-06-14 14:27:41','2021-06-14 16:26:42','3ac1dbee-6513-43bd-a084-122da32ec6db.png','2021-06-14 16:27:41','SYNCED','3ac1dbee-6513-43bd-a084-122da32ec6db',0,NULL,'','','{\"displayTitle\":\"Mordu anterieur 11.7.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1,'3ba1534e-38f1-4042-957e-167813bd2860','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_c96239ca-4da5-41fa-b243-e09fcb750abd/3ba1534e-38f1-4042-957e-167813bd2860.pdf','PDF','PATIENT_64c1dc43-bea0-4698-b4a9-13c60ca492cc_ACT_4782d962-93f8-43ba-a78f-3ea7bae2af06_PROST_c6611bce-b540-4e7a-8586-cf72a1c2f773_PDF_','2019-11-25 17:00:03','2019-06-12 17:41:36','3ba1534e-38f1-4042-957e-167813bd2860.pdf','2019-11-25 18:00:03','SYNCED','3ba1534e-38f1-4042-957e-167813bd2860',0,NULL,'','','{\"displayTitle\":\"COURONNE 5.1.1 COURONNE\",\"title\":\"Couronne PDF\"}'),(1,'3c6394ef-9b51-4c78-b14b-14c28ed74da4','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_c96239ca-4da5-41fa-b243-e09fcb750abd/3c6394ef-9b51-4c78-b14b-14c28ed74da4.json','JSON','PATIENT_64c1dc43-bea0-4698-b4a9-13c60ca492cc_ACT_4782d962-93f8-43ba-a78f-3ea7bae2af06_PROST_b7491db8-0cb2-472b-a36e-8ae60408ef8b_JSON_','2019-11-25 17:00:03','2019-06-12 17:54:17','3c6394ef-9b51-4c78-b14b-14c28ed74da4.json','2019-11-25 18:00:03','SYNCED','3c6394ef-9b51-4c78-b14b-14c28ed74da4',0,NULL,'','','{\"displayTitle\":\"COURONNE SUR IMPLANT 5.1.1 COURONNE SUR IMPLANT\",\"title\":\"Couronne sur Implant JSON\"}'),(1,'3cba2a9d-7323-4c56-937f-158cfc5ee1c0','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/3cba2a9d-7323-4c56-937f-158cfc5ee1c0.ply','PLY','PATIENT_a74b5bab-833a-4688-9466-2d4387e03c1d_ACT_18373db8-e00e-4f9c-baa9-68dac1d07ec2_SESS_482c9666-2b00-482a-94c3-66b01abb0503_TOSC_f9a6cad6-67cc-41e0-8a41-1a930cf7dfba_PLY_','2020-11-07 09:57:59','2019-11-27 07:49:51','3cba2a9d-7323-4c56-937f-158cfc5ee1c0.ply','2020-11-07 10:57:59','SYNCED','3cba2a9d-7323-4c56-937f-158cfc5ee1c0',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 8.59.1.1.4\",\"modelMatrix\":\"0.504558,0.856529,-0.108533,0,-0.863378,0.500555,-0.0634266,0,-1.65906e-9,0.125707,0.992067,0,-2.75317,-14.3652,-18.013,1\",\"title\":\"MANDIBULE PLY\"}'),(1,'3ea0622c-6df6-4cad-8d6f-c4f7776da872','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/3ea0622c-6df6-4cad-8d6f-c4f7776da872.pdf','PDF','PATIENT_d9bfe450-05c7-401c-995e-10be4eba5be5_ACT_68618536-aec2-462e-b599-c206849953af_PROST_bfe61f9c-378c-4051-bc79-c68797c55834_PDF_','2019-11-26 14:02:37','2019-11-26 15:02:36','3ea0622c-6df6-4cad-8d6f-c4f7776da872.pdf','2019-11-26 15:02:37','SYNCED','3ea0622c-6df6-4cad-8d6f-c4f7776da872',0,NULL,'','','{\"displayTitle\":\"BRIDGE SUR IMPLANT 8.56.1.1 BRIDGE SUR IMPLANT\",\"title\":\"Bridge sur Implant PDF\"}'),(1,'40763224-3c07-4cb5-a069-00c19cffaa42','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_39edd03b-189b-4cd8-b553-4fa5e59235ec/40763224-3c07-4cb5-a069-00c19cffaa42.json','JSON','PATIENT_64c1dc43-bea0-4698-b4a9-13c60ca492cc_ACT_4782d962-93f8-43ba-a78f-3ea7bae2af06_PROST_167159e8-06ff-4e62-94b7-5bdfbf411ab4_JSON_','2019-11-25 17:00:03','2019-06-12 17:55:24','40763224-3c07-4cb5-a069-00c19cffaa42.json','2019-11-25 18:00:03','SYNCED','40763224-3c07-4cb5-a069-00c19cffaa42',0,NULL,'','','{\"displayTitle\":\"BRIDGE 5.1.1 BRIDGE\",\"title\":\"Bridge JSON\"}'),(1,'43867f66-35af-48cd-9429-8b5f51289a02','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_7a6abf78-0493-467d-acf2-d8e624ad83fc/43867f66-35af-48cd-9429-8b5f51289a02.zip','ZIP','PATIENT_78842f97-ec97-49a7-8b6a-776d8f202e61_ACT_c7b31f13-4f61-44ed-995f-df2d228aed8c_SESS_cceb8198-3858-4357-8764-efc37edcbf8f_LESC_f32bf4e5-af69-4a55-ba61-08f3a924eae1_ZIP_','2021-06-14 14:28:11','2021-06-14 16:28:10','43867f66-35af-48cd-9429-8b5f51289a02.zip','2021-06-14 16:28:11','SYNCED','43867f66-35af-48cd-9429-8b5f51289a02',0,NULL,'','','{\"displayTitle\":\"Mordu posterieur gauche 11.7.1.1.2\",\"modelMatrix\":\"0.981929,-0.117876,-0.140039,0,0.090989,0.960362,-0.25358,0,0.166523,0.253469,0.957252,0,21.2931,-9.52958,-21.8191,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1,'450d7db4-e5ee-4fe9-88a6-b65e00b032df','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/450d7db4-e5ee-4fe9-88a6-b65e00b032df.png','SNAPS','PATIENT_7fec6224-9b40-43c3-90fa-e233535601b6_ACT_5c92cc6a-0b07-4817-bc97-999b47664e60_SESS_f9840640-e501-4b3a-8cd3-e2ad32249c33_TOSC_1ab959f6-83d4-4805-822a-0c00edce5a5b_SNAPS_','2020-11-07 09:58:01','2019-11-26 16:40:28','450d7db4-e5ee-4fe9-88a6-b65e00b032df.png','2020-11-07 10:58:01','SYNCED','450d7db4-e5ee-4fe9-88a6-b65e00b032df',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 8.55.1.1.2\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(1,'4663ec95-2c27-4b4e-a90e-da0f950f1024','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_1e220661-7864-4e58-b9a0-adf6a924e40d/4663ec95-2c27-4b4e-a90e-da0f950f1024.pdf','PDF','PATIENT_64c1dc43-bea0-4698-b4a9-13c60ca492cc_ACT_5f66ec30-8d44-4400-87d7-2bb86bdc5667_PROST_605dd0f0-e078-462b-8125-2140f727bbe2_PDF_','2019-11-25 17:00:03','2019-06-12 18:57:58','4663ec95-2c27-4b4e-a90e-da0f950f1024.pdf','2019-11-25 18:00:03','SYNCED','4663ec95-2c27-4b4e-a90e-da0f950f1024',0,NULL,'','','{\"displayTitle\":\"INLAY CORE 5.1.1 INLAY CORE\",\"title\":\"Inlay Core PDF\"}'),(1,'46acec7d-25db-4d26-a0cf-75453ee9bd1c','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_39edd03b-189b-4cd8-b553-4fa5e59235ec/46acec7d-25db-4d26-a0cf-75453ee9bd1c.json','JSON','PATIENT_64c1dc43-bea0-4698-b4a9-13c60ca492cc_ACT_4782d962-93f8-43ba-a78f-3ea7bae2af06_PROST_075936e7-cb02-44fd-95e4-9fddad8c9d05_JSON_','2019-11-25 17:00:03','2019-06-12 17:48:15','46acec7d-25db-4d26-a0cf-75453ee9bd1c.json','2019-11-25 18:00:03','SYNCED','46acec7d-25db-4d26-a0cf-75453ee9bd1c',0,NULL,'','','{\"displayTitle\":\"COURONNE SUR IMPLANT 5.1.1 COURONNE SUR IMPLANT\",\"title\":\"Couronne sur Implant JSON\"}'),(1,'49786fd5-0993-4fa4-bb8c-44d67e6de75a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/49786fd5-0993-4fa4-bb8c-44d67e6de75a.pdf','PDF','PATIENT_7907dfb3-1b78-4cbf-ad42-25c9b7b739d5_ACT_86ce6e3a-d2a4-4280-ae4b-d238bd053895_PROST_ada1ff53-380e-4df2-bce6-e076e75ff0ac_PDF_','2019-11-26 17:20:40','2019-11-26 18:20:39','49786fd5-0993-4fa4-bb8c-44d67e6de75a.pdf','2019-11-26 18:20:40','SYNCED','49786fd5-0993-4fa4-bb8c-44d67e6de75a',0,NULL,'','','{\"displayTitle\":\"BRIDGE 8.1.1.2 BRIDGE\",\"title\":\"Bridge PDF\"}'),(1,'4a225108-35af-43c6-9f71-1ddeed71b876','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_7a6abf78-0493-467d-acf2-d8e624ad83fc/4a225108-35af-43c6-9f71-1ddeed71b876.zip','ZIP','PATIENT_78842f97-ec97-49a7-8b6a-776d8f202e61_ACT_c7b31f13-4f61-44ed-995f-df2d228aed8c_SESS_cceb8198-3858-4357-8764-efc37edcbf8f_LESC_2f3d8ad2-6e17-4203-9928-1d5f57d42368_ZIP_','2021-06-14 14:24:31','2021-06-14 16:22:57','4a225108-35af-43c6-9f71-1ddeed71b876.zip','2021-06-14 16:24:31','SYNCED','4a225108-35af-43c6-9f71-1ddeed71b876',0,NULL,'','','{\"displayTitle\":\"Mordu posterieur gauche 11.7.1.1.1\",\"modelMatrix\":\"-0.981929,0.117876,0.140039,0,-0.090989,-0.960362,0.25358,0,0.166523,0.253469,0.957252,0,21.2931,-9.52958,-21.8191,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1,'4df7e3f5-875b-4738-b110-e94a26f14d47','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/4df7e3f5-875b-4738-b110-e94a26f14d47.png','SNAPS','PATIENT_d9bfe450-05c7-401c-995e-10be4eba5be5_ACT_68618536-aec2-462e-b599-c206849953af_SESS_62692c3b-0c98-4ac5-9ed4-2907dd8e212f_BOSC_d0ac284a-cb2c-4427-84d3-696c92342238_SNAPS_','2020-11-07 09:58:02','2019-11-26 14:58:38','4df7e3f5-875b-4738-b110-e94a26f14d47.png','2020-11-07 10:58:02','SYNCED','4df7e3f5-875b-4738-b110-e94a26f14d47',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 8.56.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(1,'4f0a31a1-c3be-4f85-b51a-ec70d12375b7','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_7a6abf78-0493-467d-acf2-d8e624ad83fc/4f0a31a1-c3be-4f85-b51a-ec70d12375b7.png','SNAPS','PATIENT_78842f97-ec97-49a7-8b6a-776d8f202e61_ACT_c7b31f13-4f61-44ed-995f-df2d228aed8c_SESS_cceb8198-3858-4357-8764-efc37edcbf8f_LESC_f32bf4e5-af69-4a55-ba61-08f3a924eae1_SNAPS_','2021-06-14 14:28:03','2021-06-14 16:27:58','4f0a31a1-c3be-4f85-b51a-ec70d12375b7.png','2021-06-14 16:28:03','SYNCED','4f0a31a1-c3be-4f85-b51a-ec70d12375b7',0,NULL,'','','{\"displayTitle\":\"Mordu posterieur gauche 11.7.1.1.2\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1,'5007b5eb-3459-4d54-b368-6252c49b04fa','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_7a6abf78-0493-467d-acf2-d8e624ad83fc/5007b5eb-3459-4d54-b368-6252c49b04fa.m','MATRX','PATIENT_78842f97-ec97-49a7-8b6a-776d8f202e61_ACT_c7b31f13-4f61-44ed-995f-df2d228aed8c_SESS_cceb8198-3858-4357-8764-efc37edcbf8f_OCC_5e232b66-e878-40a9-81c0-0005877fb5bf_BOMA__MATRX_','2021-06-14 14:31:45','2021-06-14 16:31:28','5007b5eb-3459-4d54-b368-6252c49b04fa.m','2021-06-14 16:31:45','SYNCED','5007b5eb-3459-4d54-b368-6252c49b04fa',0,NULL,'','','{\"displayTitle\":\"Matrice Transfo. Mandibule 11.7.1.1.2 Occlusion 2\",\"referenceScanID\":\"11.7.1.1.2\",\"title\":\"Matrice Transfo. Mandibule 11.7.1.1.2 Occlusion 2\"}'),(1,'50a23e88-e035-4521-a4d9-932a19651a5a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_7a6abf78-0493-467d-acf2-d8e624ad83fc/50a23e88-e035-4521-a4d9-932a19651a5a.zip','ZIP','PATIENT_78842f97-ec97-49a7-8b6a-776d8f202e61_ACT_c7b31f13-4f61-44ed-995f-df2d228aed8c_SESS_cceb8198-3858-4357-8764-efc37edcbf8f_TOSC_b3b59b8b-a1b8-4797-a207-5460c7c95667_ZIP_','2021-06-14 14:29:10','2021-06-14 16:29:08','50a23e88-e035-4521-a4d9-932a19651a5a.zip','2021-06-14 16:29:10','SYNCED','50a23e88-e035-4521-a4d9-932a19651a5a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 11.7.1.1.2\",\"modelMatrix\":\"-0.999905,-0.0132502,0.00371127,0,0.0137602,-0.96285,0.269685,0,9.22008e-11,0.269711,0.962941,0,-7.66698,-31.4043,-20.1633,1\",\"title\":\"Maxillaire ZIP\"}'),(1,'51ecce30-4107-4a3b-92c1-da4df4c0f132','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/51ecce30-4107-4a3b-92c1-da4df4c0f132.m','MATRX','PATIENT_6f54be3b-4604-426e-bf44-c0e09a217e80_ACT_94abec74-d6a4-4c4c-9da3-d674e05be9ba_SESS_94ee1c4b-bea6-487f-bf39-53570bfa5420_OCC_94ee1c4b-bea6-487f-bf39-535migraoccl_BOMA__MATRX_','2020-11-07 09:58:02','2019-06-06 10:03:45','51ecce30-4107-4a3b-92c1-da4df4c0f132.m','2020-11-07 10:58:02','SYNCED','51ecce30-4107-4a3b-92c1-da4df4c0f132',0,NULL,'','','{\"displayTitle\":\"Mandibule Occlusion 3.2.1.4.4\",\"title\":\"Matrice Transfo. Mandibule MATRIX\"}'),(1,'5354bf8f-74c4-42b2-a829-6822ae8979e2','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/5354bf8f-74c4-42b2-a829-6822ae8979e2.png','SNAPS','PATIENT_7fec6224-9b40-43c3-90fa-e233535601b6_ACT_5c92cc6a-0b07-4817-bc97-999b47664e60_SESS_f9840640-e501-4b3a-8cd3-e2ad32249c33_BOSC_73fb055f-6fab-4748-a059-d5260616fcd1_SNAPS_','2020-11-07 09:58:03','2019-11-26 16:43:06','5354bf8f-74c4-42b2-a829-6822ae8979e2.png','2020-11-07 10:58:03','SYNCED','5354bf8f-74c4-42b2-a829-6822ae8979e2',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 8.55.1.1.2\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(1,'53765288-b295-4062-a45d-c4d6d3d7d08b','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/53765288-b295-4062-a45d-c4d6d3d7d08b.png','SNAPS','PATIENT_6f54be3b-4604-426e-bf44-c0e09a217e80_ACT_94abec74-d6a4-4c4c-9da3-d674e05be9ba_SESS_94ee1c4b-bea6-487f-bf39-53570bfa5420_TOSC_46068a8d-b89c-4eab-a62e-cbfb93e9dd6c_SNAPS_','2020-11-07 09:58:03','2019-06-06 10:00:13','53765288-b295-4062-a45d-c4d6d3d7d08b.png','2020-11-07 10:58:03','SYNCED','53765288-b295-4062-a45d-c4d6d3d7d08b',0,NULL,'','','{\"displayTitle\":\"Maxillaire 0\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(1,'5396ca0e-bfce-49b1-9309-5f65706e2472','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/5396ca0e-bfce-49b1-9309-5f65706e2472.json','JSON','PATIENT_7907dfb3-1b78-4cbf-ad42-25c9b7b739d5_ACT_86ce6e3a-d2a4-4280-ae4b-d238bd053895_PROST_ada1ff53-380e-4df2-bce6-e076e75ff0ac_JSON_','2019-11-26 17:20:39','2019-11-26 18:20:39','5396ca0e-bfce-49b1-9309-5f65706e2472.json','2019-11-26 18:20:39','SYNCED','5396ca0e-bfce-49b1-9309-5f65706e2472',0,NULL,'','','{\"displayTitle\":\"BRIDGE 8.1.1.2 BRIDGE\",\"title\":\"Bridge JSON\"}'),(1,'55779603-cdb3-4ad1-abdb-65bf1d88edcc','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_c96239ca-4da5-41fa-b243-e09fcb750abd/55779603-cdb3-4ad1-abdb-65bf1d88edcc.json','JSON','PATIENT_64c1dc43-bea0-4698-b4a9-13c60ca492cc_ACT_4782d962-93f8-43ba-a78f-3ea7bae2af06_PROST_c6611bce-b540-4e7a-8586-cf72a1c2f773_JSON_','2019-11-25 17:00:03','2019-06-12 17:41:36','55779603-cdb3-4ad1-abdb-65bf1d88edcc.json','2019-11-25 18:00:03','SYNCED','55779603-cdb3-4ad1-abdb-65bf1d88edcc',0,NULL,'','','{\"displayTitle\":\"COURONNE 5.1.1 COURONNE\",\"title\":\"Couronne JSON\"}'),(1,'5b7c3a03-9f0d-49d3-b859-ed9692ce8fb6','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/5b7c3a03-9f0d-49d3-b859-ed9692ce8fb6.ply','PLY','PATIENT_7fec6224-9b40-43c3-90fa-e233535601b6_ACT_5c92cc6a-0b07-4817-bc97-999b47664e60_SESS_f9840640-e501-4b3a-8cd3-e2ad32249c33_BOSC_a7d1c9b3-6e25-43cc-ac70-cea73214d183_PLY_','2020-11-07 09:58:05','2019-11-26 16:48:03','5b7c3a03-9f0d-49d3-b859-ed9692ce8fb6.ply','2020-11-07 10:58:05','SYNCED','5b7c3a03-9f0d-49d3-b859-ed9692ce8fb6',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 8.55.1.1.4\",\"modelMatrix\":\"-0.993891,-0.10948,0.0139325,0,0.110363,-0.98594,0.125472,0,5.04106e-10,0.126243,0.991999,0,-1.47882,0.634358,-24.9829,1\",\"title\":\"MANDIBULE PLY\"}'),(1,'60041b81-623a-4084-ae12-f077ad960471','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/60041b81-623a-4084-ae12-f077ad960471.ply','PLY','PATIENT_6f54be3b-4604-426e-bf44-c0e09a217e80_ACT_94abec74-d6a4-4c4c-9da3-d674e05be9ba_SESS_94ee1c4b-bea6-487f-bf39-53570bfa5420_OCC_94ee1c4b-bea6-487f-bf39-535migraoccl_TOPLY__PLY_','2020-11-07 09:58:06','2019-06-06 10:03:45','60041b81-623a-4084-ae12-f077ad960471.ply','2020-11-07 10:58:06','SYNCED','60041b81-623a-4084-ae12-f077ad960471',0,NULL,'','','{\"displayTitle\":\"Mandibule Occlusion 3.2.1.4.4\",\"title\":\"Maxillaire Occlusion PLY\"}'),(1,'63ec36f9-53cb-4124-9e6f-138c27f76edb','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_1e220661-7864-4e58-b9a0-adf6a924e40d/63ec36f9-53cb-4124-9e6f-138c27f76edb.stl','STL','PATIENT_6ffa3f1d-c48d-4158-b8c5-3d98e2d9dd4f_ACT_5f66ec30-8d44-4400-87d7-2bb86bdc5667_SESS_0c142631-f8b2-452a-a29f-b7adabaa8326_BOSC_452894f3-ec03-42b7-b4c4-48c6762a0d3f_STL_','2020-10-21 13:33:03','2019-06-12 18:17:10','63ec36f9-53cb-4124-9e6f-138c27f76edb.stl','2020-10-21 15:33:03','SYNCED','63ec36f9-53cb-4124-9e6f-138c27f76edb',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 5.2.1.1.1\",\"modelMatrix\":\"0.686908,0.723704,-0.066408,0,-0.726745,0.684034,-0.0627679,0,1.22705e-9,0.0913774,0.995816,0,-12.3655,-10.348,-16.7031,1\",\"title\":\"MANDIBULE STL\"}'),(1,'66e5afde-c729-4325-8fc8-bd15b4fde66e','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_7a6abf78-0493-467d-acf2-d8e624ad83fc/66e5afde-c729-4325-8fc8-bd15b4fde66e.png','SNAPS','PATIENT_78842f97-ec97-49a7-8b6a-776d8f202e61_ACT_c7b31f13-4f61-44ed-995f-df2d228aed8c_SESS_cceb8198-3858-4357-8764-efc37edcbf8f_LESC_2f3d8ad2-6e17-4203-9928-1d5f57d42368_SNAPS_','2021-06-14 14:24:31','2021-06-14 16:22:55','66e5afde-c729-4325-8fc8-bd15b4fde66e.png','2021-06-14 16:24:31','SYNCED','66e5afde-c729-4325-8fc8-bd15b4fde66e',0,NULL,'','','{\"displayTitle\":\"Mordu posterieur gauche 11.7.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1,'6e0ff98c-e62f-4aa3-8d7d-2ad9e7d55c24','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/6e0ff98c-e62f-4aa3-8d7d-2ad9e7d55c24.ply','PLY','PATIENT_6f54be3b-4604-426e-bf44-c0e09a217e80_ACT_94abec74-d6a4-4c4c-9da3-d674e05be9ba_SESS_94ee1c4b-bea6-487f-bf39-53570bfa5420_TOSC_46068a8d-b89c-4eab-a62e-cbfb93e9dd6c_PLY_','2020-11-07 09:58:09','2019-06-06 10:00:13','6e0ff98c-e62f-4aa3-8d7d-2ad9e7d55c24.ply','2020-11-07 10:58:09','SYNCED','6e0ff98c-e62f-4aa3-8d7d-2ad9e7d55c24',0,NULL,'','','{\"displayTitle\":\"Maxillaire 0\",\"modelMatrix\":\"-0.368193,-0.898559,0.238799,0,0.929749,-0.355842,0.0945677,0,-1.42566e-9,0.256843,0.966453,0,7.31137,12.4313,-19.4252,1\",\"title\":\"MAXILLAIRE PLY\"}'),(1,'6e9af76d-eac8-4fe8-876f-bf21ab0e9ff8','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/6e9af76d-eac8-4fe8-876f-bf21ab0e9ff8.ply','PLY','PATIENT_d9bfe450-05c7-401c-995e-10be4eba5be5_ACT_68618536-aec2-462e-b599-c206849953af_SESS_62692c3b-0c98-4ac5-9ed4-2907dd8e212f_BOSC_d0ac284a-cb2c-4427-84d3-696c92342238_PLY_','2020-11-07 09:58:09','2019-11-26 14:58:38','6e9af76d-eac8-4fe8-876f-bf21ab0e9ff8.ply','2020-11-07 10:58:09','SYNCED','6e9af76d-eac8-4fe8-876f-bf21ab0e9ff8',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 8.56.1.1.1\",\"modelMatrix\":\"0.99414,-0.10743,0.0120582,0,0.108104,0.987936,-0.110888,0,-5.08484e-10,0.111542,0.99376,0,15.2324,-9.00673,-27.6161,1\",\"title\":\"MANDIBULE PLY\"}'),(1,'72428541-af45-4cf0-be15-cd0274461ceb','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/72428541-af45-4cf0-be15-cd0274461ceb.pdf','PDF','PATIENT_a74b5bab-833a-4688-9466-2d4387e03c1d_ACT_18373db8-e00e-4f9c-baa9-68dac1d07ec2_PROST_77dc6c87-efd8-47c3-b217-ddaf94bf0750_PDF_','2019-11-27 06:55:24','2019-11-27 07:55:24','72428541-af45-4cf0-be15-cd0274461ceb.pdf','2019-11-27 07:55:24','SYNCED','72428541-af45-4cf0-be15-cd0274461ceb',0,NULL,'','','{\"displayTitle\":\"AMOVIBLE SUR IMPLANT 8.59.1.1 AMOVIBLE SUR IMPLANT\",\"title\":\"Amovible sur Implant PDF\"}'),(1,'7377e6d6-9d2a-4b52-a633-01294cf03971','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_39edd03b-189b-4cd8-b553-4fa5e59235ec/7377e6d6-9d2a-4b52-a633-01294cf03971.pdf','PDF','PATIENT_64c1dc43-bea0-4698-b4a9-13c60ca492cc_ACT_4782d962-93f8-43ba-a78f-3ea7bae2af06_PROST_075936e7-cb02-44fd-95e4-9fddad8c9d05_PDF_','2019-11-25 17:00:03','2019-06-12 17:48:15','7377e6d6-9d2a-4b52-a633-01294cf03971.pdf','2019-11-25 18:00:03','SYNCED','7377e6d6-9d2a-4b52-a633-01294cf03971',0,NULL,'','','{\"displayTitle\":\"COURONNE SUR IMPLANT 5.1.1 COURONNE SUR IMPLANT\",\"title\":\"Couronne sur Implant PDF\"}'),(1,'75d2f76b-87db-4b1f-a58d-21da7ddedf9c','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_39edd03b-189b-4cd8-b553-4fa5e59235ec/75d2f76b-87db-4b1f-a58d-21da7ddedf9c.pdf','PDF','PATIENT_64c1dc43-bea0-4698-b4a9-13c60ca492cc_ACT_4782d962-93f8-43ba-a78f-3ea7bae2af06_PROST_981ef3b6-f108-4bac-a351-55a54cfa9cbe_PDF_','2019-11-25 17:00:03','2019-06-12 17:42:37','75d2f76b-87db-4b1f-a58d-21da7ddedf9c.pdf','2019-11-25 18:00:03','SYNCED','75d2f76b-87db-4b1f-a58d-21da7ddedf9c',0,NULL,'','','{\"displayTitle\":\"INLAY ONLAY 5.1.1 INLAY ONLAY\",\"title\":\"Inlay/Onlay PDF\"}'),(1,'7d026df6-f58f-466d-8a4c-e6d87741a603','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_7a6abf78-0493-467d-acf2-d8e624ad83fc/7d026df6-f58f-466d-8a4c-e6d87741a603.png','SNAPS','PATIENT_78842f97-ec97-49a7-8b6a-776d8f202e61_ACT_c7b31f13-4f61-44ed-995f-df2d228aed8c_SESS_cceb8198-3858-4357-8764-efc37edcbf8f_BOSC_1cd4f6aa-3184-489c-b1cd-8825b124355d_SNAPS_','2021-06-14 14:28:47','2021-06-14 16:28:46','7d026df6-f58f-466d-8a4c-e6d87741a603.png','2021-06-14 16:28:47','SYNCED','7d026df6-f58f-466d-8a4c-e6d87741a603',0,NULL,'','','{\"displayTitle\":\"Mandibule 11.7.1.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(1,'8251a9a2-4b94-408c-b149-3e1f8e468989','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_7a6abf78-0493-467d-acf2-d8e624ad83fc/8251a9a2-4b94-408c-b149-3e1f8e468989.m','MATRX','PATIENT_78842f97-ec97-49a7-8b6a-776d8f202e61_ACT_c7b31f13-4f61-44ed-995f-df2d228aed8c_SESS_cceb8198-3858-4357-8764-efc37edcbf8f_OCC_45d7248e-d60c-48d5-9f2a-3cc5aaea3aca_TOMA__MATRX_','2021-06-14 14:30:27','2021-06-14 16:30:22','8251a9a2-4b94-408c-b149-3e1f8e468989.m','2021-06-14 16:30:27','SYNCED','8251a9a2-4b94-408c-b149-3e1f8e468989',0,NULL,'','','{\"displayTitle\":\"Matrice Transfo. Maxillaire 11.7.1.1.2 Occlusion 1\",\"referenceScanID\":\"11.7.1.1.2\",\"title\":\"Matrice Transfo. Maxillaire 11.7.1.1.2 Occlusion 1\"}'),(1,'84457a7a-8bbd-4128-ab5a-88c427c6287a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3296fbec-fc91-45de-9488-4f4f7a526b6e/84457a7a-8bbd-4128-ab5a-88c427c6287a.ply','PLY','PATIENT_ed5bcddc-a157-429f-b179-a4a60485e849_ACT_6a685e00-13b0-4ce1-b5d1-eceffaab76dc_SESS_31692a95-aa62-42ed-93d2-f312ae629c57_BOSC_0a50e289-eba0-4bb8-80f6-6363c3e21941_PLY_','2020-11-07 09:58:14','2020-03-11 14:29:18','84457a7a-8bbd-4128-ab5a-88c427c6287a.ply','2020-11-07 10:58:14','SYNCED','84457a7a-8bbd-4128-ab5a-88c427c6287a',0,NULL,'','','{\"displayTitle\":\"Mandibule 6.22.1.1.1\",\"modelMatrix\":\"0.765085,0.594259,-0.247992,0,-0.643929,0.706071,-0.294652,0,-1.52237e-8,0.385123,0.922865,0,-10.4161,-15.0182,-17.3072,1\",\"title\":\"Mandibule PLY\"}'),(1,'897d7eb5-0acc-4e1e-ad77-325ac8a285c6','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_1e220661-7864-4e58-b9a0-adf6a924e40d/897d7eb5-0acc-4e1e-ad77-325ac8a285c6.ply','PLY','PATIENT_6ffa3f1d-c48d-4158-b8c5-3d98e2d9dd4f_ACT_5f66ec30-8d44-4400-87d7-2bb86bdc5667_SESS_0c142631-f8b2-452a-a29f-b7adabaa8326_TOSC_84acc7ca-6d29-4e98-8ed8-8e9a0ec3f18d_PLY_','2020-11-07 09:58:15','2019-06-12 18:16:33','897d7eb5-0acc-4e1e-ad77-325ac8a285c6.ply','2020-11-07 10:58:15','SYNCED','897d7eb5-0acc-4e1e-ad77-325ac8a285c6',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 5.2.1.1.1\",\"modelMatrix\":\"-0.729505,-0.662886,0.168537,0,0.683975,-0.707012,0.179756,0,8.31046e-9,0.246407,0.969166,0,20.2767,6.26126,-25.6904,1\",\"title\":\"MAXILLAIRE PLY\"}'),(1,'8c8f836f-9c38-4162-a2a1-c7208ec1c0fb','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/8c8f836f-9c38-4162-a2a1-c7208ec1c0fb.ply','PLY','PATIENT_6f54be3b-4604-426e-bf44-c0e09a217e80_ACT_94abec74-d6a4-4c4c-9da3-d674e05be9ba_SESS_94ee1c4b-bea6-487f-bf39-53570bfa5420_RISC_7710c402-baef-4829-a485-61f299cfeca2_PLY_','2020-11-07 09:58:16','2019-06-06 10:03:31','8c8f836f-9c38-4162-a2a1-c7208ec1c0fb.ply','2020-11-07 10:58:16','SYNCED','8c8f836f-9c38-4162-a2a1-c7208ec1c0fb',0,NULL,'','','{\"displayTitle\":\"Mordu posterieur droit 0\",\"modelMatrix\":\"0.997512,-0.00518125,-0.070404,0,0.0106957,0.996942,0.0775426,0,0.0696765,-0.0779763,0.9945,0,-16.2973,-2.08689,-21.8673,1\",\"title\":\"MORDU_POSTERIEUR_DROIT PLY\"}'),(1,'8cb63af7-07d3-4452-9f1a-24c2e8ecd328','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_39edd03b-189b-4cd8-b553-4fa5e59235ec/8cb63af7-07d3-4452-9f1a-24c2e8ecd328.pdf','PDF','PATIENT_64c1dc43-bea0-4698-b4a9-13c60ca492cc_ACT_4782d962-93f8-43ba-a78f-3ea7bae2af06_PROST_167159e8-06ff-4e62-94b7-5bdfbf411ab4_PDF_','2019-11-25 17:00:03','2019-06-12 17:55:24','8cb63af7-07d3-4452-9f1a-24c2e8ecd328.pdf','2019-11-25 18:00:03','SYNCED','8cb63af7-07d3-4452-9f1a-24c2e8ecd328',0,NULL,'','','{\"displayTitle\":\"BRIDGE 5.1.1 BRIDGE\",\"title\":\"Bridge PDF\"}'),(1,'8d8924ef-cbf3-45e5-bba0-a01024f00cbd','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_1e220661-7864-4e58-b9a0-adf6a924e40d/8d8924ef-cbf3-45e5-bba0-a01024f00cbd.ply','PLY','PATIENT_6ffa3f1d-c48d-4158-b8c5-3d98e2d9dd4f_ACT_5f66ec30-8d44-4400-87d7-2bb86bdc5667_SESS_0c142631-f8b2-452a-a29f-b7adabaa8326_BOSC_452894f3-ec03-42b7-b4c4-48c6762a0d3f_PLY_','2020-11-07 09:58:16','2019-06-12 18:17:10','8d8924ef-cbf3-45e5-bba0-a01024f00cbd.ply','2020-11-07 10:58:16','SYNCED','8d8924ef-cbf3-45e5-bba0-a01024f00cbd',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 5.2.1.1.1\",\"modelMatrix\":\"0.686908,0.723704,-0.066408,0,-0.726745,0.684034,-0.0627679,0,1.22705e-9,0.0913774,0.995816,0,-12.3655,-10.348,-16.7031,1\",\"title\":\"MANDIBULE PLY\"}'),(1,'8f50610e-153f-45fa-9782-2b4e65287c01','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_39edd03b-189b-4cd8-b553-4fa5e59235ec/8f50610e-153f-45fa-9782-2b4e65287c01.json','JSON','PATIENT_64c1dc43-bea0-4698-b4a9-13c60ca492cc_ACT_4782d962-93f8-43ba-a78f-3ea7bae2af06_PROST_981ef3b6-f108-4bac-a351-55a54cfa9cbe_JSON_','2019-11-25 17:00:03','2019-06-12 17:42:37','8f50610e-153f-45fa-9782-2b4e65287c01.json','2019-11-25 18:00:03','SYNCED','8f50610e-153f-45fa-9782-2b4e65287c01',0,NULL,'','','{\"displayTitle\":\"INLAY ONLAY 5.1.1 INLAY ONLAY\",\"title\":\"Inlay/Onlay JSON\"}'),(1,'909566f5-8c35-4cb4-be86-7864f27c7429','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_7a6abf78-0493-467d-acf2-d8e624ad83fc/909566f5-8c35-4cb4-be86-7864f27c7429.zip','ZIP','PATIENT_78842f97-ec97-49a7-8b6a-776d8f202e61_ACT_c7b31f13-4f61-44ed-995f-df2d228aed8c_SESS_cceb8198-3858-4357-8764-efc37edcbf8f_FRSC_a7f7b44b-e00f-4476-8eb5-7e7caf65845a_ZIP_','2021-06-14 14:27:52','2021-06-14 16:27:47','909566f5-8c35-4cb4-be86-7864f27c7429.zip','2021-06-14 16:27:52','SYNCED','909566f5-8c35-4cb4-be86-7864f27c7429',0,NULL,'','','{\"displayTitle\":\"Mordu anterieur 11.7.1.1.2\",\"modelMatrix\":\"0.79477,0.122262,0.593495,0,0.0112902,0.975205,-0.209322,0,-0.606823,0.184907,0.77724,0,13.9737,-2.3731,-31.7395,1\",\"title\":\"Mordu anterieur ZIP\"}'),(1,'934114b7-8c84-48c9-b87a-d4d5de17b7c6','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_7a6abf78-0493-467d-acf2-d8e624ad83fc/934114b7-8c84-48c9-b87a-d4d5de17b7c6.png','SNAPS','PATIENT_78842f97-ec97-49a7-8b6a-776d8f202e61_ACT_c7b31f13-4f61-44ed-995f-df2d228aed8c_SESS_cceb8198-3858-4357-8764-efc37edcbf8f_OCC_5e232b66-e878-40a9-81c0-0005877fb5bf_SNAPO__SNAPS_','2021-06-14 14:31:36','2021-06-14 16:31:28','934114b7-8c84-48c9-b87a-d4d5de17b7c6.png','2021-06-14 16:31:36','SYNCED','934114b7-8c84-48c9-b87a-d4d5de17b7c6',0,NULL,'','','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1,'964147ac-4166-43b0-b2c3-db434042373a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/964147ac-4166-43b0-b2c3-db434042373a.png','SNAPS','PATIENT_6f54be3b-4604-426e-bf44-c0e09a217e80_ACT_94abec74-d6a4-4c4c-9da3-d674e05be9ba_SESS_94ee1c4b-bea6-487f-bf39-53570bfa5420_OCC_94ee1c4b-bea6-487f-bf39-535migraoccl_SNAPO__SNAPS_','2020-11-07 09:58:17','2019-06-06 10:03:45','964147ac-4166-43b0-b2c3-db434042373a.png','2020-11-07 10:58:17','SYNCED','964147ac-4166-43b0-b2c3-db434042373a',0,NULL,'','','{\"displayTitle\":\"Mandibule Occlusion 3.2.1.4.4\",\"title\":\"Snapshot SNAPSHOT\"}'),(1,'96f40545-33de-11eb-973a-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_82ca34c0-5553-470e-9bed-5b7e9bedc4d9/96f40545-33de-11eb-973a-96e674358d3a.pdf','PDF','PATIENT_20db9968-3a56-48e4-9a0b-1e0c97633cda_ACT_ae7f5446-27c2-475b-9c90-29261d7478b9_PROST_be83a3aa-f70c-44bc-97be-8a383a1bc2b4_PDF_','2020-12-01 14:07:37','2020-12-01 15:07:37','96f40545-33de-11eb-973a-96e674358d3a.pdf','2020-12-01 15:07:37','SYNCED','96f40545-33de-11eb-973a-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"BRIDGE 1.17.3.1 BRIDGE\",\"title\":\"Bridge PDF\"}'),(1,'96f96a4a-33de-11eb-973a-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_82ca34c0-5553-470e-9bed-5b7e9bedc4d9/96f96a4a-33de-11eb-973a-96e674358d3a.ply','PLY','PATIENT_20db9968-3a56-48e4-9a0b-1e0c97633cda_ACT_ae7f5446-27c2-475b-9c90-29261d7478b9_SESS_3dcd1001-1472-485f-8f29-5144928dc6e5_TOSC_2faee35b-e20e-461a-beb5-32b0b1d990f5_PLY_','2020-11-30 08:38:03','2020-11-30 09:37:56','96f96a4a-33de-11eb-973a-96e674358d3a.ply','2020-11-30 09:38:03','SYNCED','96f96a4a-33de-11eb-973a-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.17.3.6.1\",\"modelMatrix\":\"0.0467803,0.963449,-0.263776,0,-0.998905,0.0451198,-0.012353,0,5.91448e-10,0.264065,0.964505,0,-13.9666,-30.0605,-14.7766,1\",\"title\":\"Maxillaire PLY\"}'),(1,'96fa85e2-33de-11eb-973a-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_82ca34c0-5553-470e-9bed-5b7e9bedc4d9/96fa85e2-33de-11eb-973a-96e674358d3a.png','SNAPS','PATIENT_20db9968-3a56-48e4-9a0b-1e0c97633cda_ACT_ae7f5446-27c2-475b-9c90-29261d7478b9_SESS_3dcd1001-1472-485f-8f29-5144928dc6e5_TOSC_2faee35b-e20e-461a-beb5-32b0b1d990f5_SNAPS_','2020-11-30 08:37:58','2020-11-30 09:37:56','96fa85e2-33de-11eb-973a-96e674358d3a.png','2020-11-30 09:37:58','SYNCED','96fa85e2-33de-11eb-973a-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.17.3.6.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1,'9701eb13-33de-11eb-973a-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_82ca34c0-5553-470e-9bed-5b7e9bedc4d9/9701eb13-33de-11eb-973a-96e674358d3a.json','JSON','PATIENT_20db9968-3a56-48e4-9a0b-1e0c97633cda_ACT_ae7f5446-27c2-475b-9c90-29261d7478b9_PROST_be83a3aa-f70c-44bc-97be-8a383a1bc2b4_JSON_','2020-12-01 14:07:37','2020-12-01 15:07:37','9701eb13-33de-11eb-973a-96e674358d3a.json','2020-12-01 15:07:37','SYNCED','9701eb13-33de-11eb-973a-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"BRIDGE 1.17.3.1 BRIDGE\",\"title\":\"Bridge JSON\"}'),(1,'99670342-6f6e-46e9-8d35-3adf4203f7f4','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/99670342-6f6e-46e9-8d35-3adf4203f7f4.ply','PLY','PATIENT_a74b5bab-833a-4688-9466-2d4387e03c1d_ACT_18373db8-e00e-4f9c-baa9-68dac1d07ec2_SESS_482c9666-2b00-482a-94c3-66b01abb0503_TOSC_1867e952-05b2-4589-a730-ce347d97ccc1_PLY_','2020-11-07 09:58:18','2019-11-27 07:41:50','99670342-6f6e-46e9-8d35-3adf4203f7f4.ply','2020-11-07 10:58:18','SYNCED','99670342-6f6e-46e9-8d35-3adf4203f7f4',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 8.59.1.1.1\",\"modelMatrix\":\"0.896589,-0.414605,0.155661,0,0.442863,0.83938,-0.31514,0,-7.96802e-9,0.351488,0.936193,0,10.6873,-14.1412,-24.464,1\",\"title\":\"MAXILLAIRE PLY\"}'),(1,'9a996f4e-b1a1-4c04-bd14-65f4db0892da','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/9a996f4e-b1a1-4c04-bd14-65f4db0892da.pdf','PDF','PATIENT_7907dfb3-1b78-4cbf-ad42-25c9b7b739d5_ACT_86ce6e3a-d2a4-4280-ae4b-d238bd053895_PROST_57aa8cf8-15ed-4fb1-a7da-4171ffb1bdf6_PDF_','2019-11-26 17:19:07','2019-11-26 18:19:06','9a996f4e-b1a1-4c04-bd14-65f4db0892da.pdf','2019-11-26 18:19:07','SYNCED','9a996f4e-b1a1-4c04-bd14-65f4db0892da',0,NULL,'','','{\"displayTitle\":\"INLAY ONLAY 8.1.1.1 INLAY ONLAY\",\"title\":\"Inlay/Onlay PDF\"}'),(1,'9af5eaec-2e22-4a17-a9e4-1b4a4cdb7537','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/9af5eaec-2e22-4a17-a9e4-1b4a4cdb7537.ply','PLY','PATIENT_eccc0474-69f5-4755-8f43-a50133b7e35e_ACT_86ce6e3a-d2a4-4280-ae4b-d238bd053895_SESS_467b1648-82ba-4dcc-9934-9635f3b4a7f8_TOSC_82d93a1c-e443-4349-83d9-6f75747ee0b8_PLY_','2020-11-07 09:58:19','2019-11-26 18:18:09','9af5eaec-2e22-4a17-a9e4-1b4a4cdb7537.ply','2020-11-07 10:58:19','SYNCED','9af5eaec-2e22-4a17-a9e4-1b4a4cdb7537',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 8.1.1.1.1\",\"modelMatrix\":\"-0.964178,-0.26429,0.0226024,0,0.265255,-0.960672,0.0821576,0,-3.6308e-10,0.0852099,0.996363,0,-5.77449,-5.51129,-16.879,1\",\"title\":\"MAXILLAIRE PLY\"}'),(1,'9cff83a2-65ca-4fd4-a2ae-c3c4cb737307','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3296fbec-fc91-45de-9488-4f4f7a526b6e/9cff83a2-65ca-4fd4-a2ae-c3c4cb737307.json','JSON','PATIENT_ed5bcddc-a157-429f-b179-a4a60485e849_ACT_6a685e00-13b0-4ce1-b5d1-eceffaab76dc_PROST_d2808000-ba2e-4b72-9675-7ec6a91decb0_JSON_','2020-03-11 13:47:17','2020-03-11 14:47:17','9cff83a2-65ca-4fd4-a2ae-c3c4cb737307.json','2020-03-11 14:47:17','SYNCED','9cff83a2-65ca-4fd4-a2ae-c3c4cb737307',0,NULL,'','','{\"displayTitle\":\"COURONNE 6.22.1.1 COURONNE\",\"title\":\"Couronne JSON\"}'),(1,'9d936069-774d-4701-b445-d931dd522618','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_c96239ca-4da5-41fa-b243-e09fcb750abd/9d936069-774d-4701-b445-d931dd522618.pdf','PDF','PATIENT_a74b5bab-833a-4688-9466-2d4387e03c1d_ACT_18373db8-e00e-4f9c-baa9-68dac1d07ec2_PROST_cb108a6c-b733-4aa5-a265-4a1b66b5bb75_PDF_','2020-11-07 09:58:20','2020-09-15 10:25:04','9d936069-774d-4701-b445-d931dd522618.pdf','2020-11-07 10:58:20','SYNCED','9d936069-774d-4701-b445-d931dd522618',0,NULL,'','','{\"displayTitle\":\"COURONNE 8.59.1.9.9 COURONNE\",\"title\":\"Couronne PDF\"}'),(1,'9fcc99f0-3a47-4c9a-89d2-667877abadd2','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/9fcc99f0-3a47-4c9a-89d2-667877abadd2.ply','PLY','PATIENT_6f54be3b-4604-426e-bf44-c0e09a217e80_ACT_94abec74-d6a4-4c4c-9da3-d674e05be9ba_SESS_94ee1c4b-bea6-487f-bf39-53570bfa5420_BOSC_ee467d7d-918b-4143-903b-62bbd1c8d3ec_PLY_','2020-11-07 09:58:20','2019-06-06 10:01:28','9fcc99f0-3a47-4c9a-89d2-667877abadd2.ply','2020-11-07 10:58:20','SYNCED','9fcc99f0-3a47-4c9a-89d2-667877abadd2',0,NULL,'','','{\"displayTitle\":\"Mandibule 0\",\"modelMatrix\":\"0.496582,-0.85331,0.158959,0,0.86799,0.488184,-0.0909414,0,-3.63989e-9,0.183135,0.983088,0,-6.73367,15.3435,-23.795,1\",\"title\":\"MANDIBULE PLY\"}'),(1,'a44d6a6d-99a8-4bef-bba2-5930d7c14146','','SNAPS','PATIENT_78842f97-ec97-49a7-8b6a-776d8f202e61_ACT_c7b31f13-4f61-44ed-995f-df2d228aed8c_SESS_cceb8198-3858-4357-8764-efc37edcbf8f_TOSC_1b4721aa-af54-40da-a758-ffb23b6a1af9_SNAPS_','2021-06-14 13:59:25','2021-06-14 15:56:44','','2021-06-14 15:59:25','SYNCED','a44d6a6d-99a8-4bef-bba2-5930d7c14146',0,NULL,'','','{\"displayTitle\":\"Maxillaire 11.7.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1,'a4da6ae7-e6b1-4233-b4b7-16ab46a3a583','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/a4da6ae7-e6b1-4233-b4b7-16ab46a3a583.ply','PLY','PATIENT_a74b5bab-833a-4688-9466-2d4387e03c1d_ACT_18373db8-e00e-4f9c-baa9-68dac1d07ec2_SESS_482c9666-2b00-482a-94c3-66b01abb0503_BOSC_ab2f81fc-4f2a-4837-98e2-18be13aaab29_PLY_','2020-11-07 09:58:21','2019-11-27 07:44:45','a4da6ae7-e6b1-4233-b4b7-16ab46a3a583.ply','2020-11-07 10:58:21','SYNCED','a4da6ae7-e6b1-4233-b4b7-16ab46a3a583',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 8.59.1.1.1\",\"modelMatrix\":\"0.900578,-0.423478,0.0981073,0,0.434694,0.877342,-0.203254,0,-7.33621e-10,0.225693,0.974199,0,22.3712,-11.745,-26.6417,1\",\"title\":\"MANDIBULE PLY\"}'),(1,'a7c50e99-43ea-4e22-8f05-a92f9129705e','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_39edd03b-189b-4cd8-b553-4fa5e59235ec/a7c50e99-43ea-4e22-8f05-a92f9129705e.ply','PLY','PATIENT_fc5594bc-603f-4ecf-a370-d763ac33006d_ACT_bdfb331a-b542-4e39-9d1e-33bc8bb90aed_SESS_83e62b66-c8c2-49a0-ab0b-0dccf296d880_TOSC_0edca99b-de95-42a5-93cd-054792bd338b_PLY_','2020-11-07 09:58:22','2020-09-17 17:43:56','a7c50e99-43ea-4e22-8f05-a92f9129705e.ply','2020-11-07 10:58:22','SYNCED','a7c50e99-43ea-4e22-8f05-a92f9129705e',0,NULL,'','','{\"displayTitle\":\"Maxillaire 11.1.1.1.8\",\"modelMatrix\":\"0.999599,0.0281011,-0.00355809,0,-0.0283254,0.991681,-0.125564,0,-8.0181e-11,0.125615,0.992079,0,16.128,-21.2526,-13.1256,1\",\"title\":\"Maxillaire PLY\"}'),(1,'a8359b48-d764-484a-b9e5-92e2f666a117','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/a8359b48-d764-484a-b9e5-92e2f666a117.png','SNAPS','PATIENT_6f54be3b-4604-426e-bf44-c0e09a217e80_ACT_94abec74-d6a4-4c4c-9da3-d674e05be9ba_SESS_94ee1c4b-bea6-487f-bf39-53570bfa5420_BOSC_ee467d7d-918b-4143-903b-62bbd1c8d3ec_SNAPS_','2020-11-07 09:58:22','2019-06-06 10:01:28','a8359b48-d764-484a-b9e5-92e2f666a117.png','2020-11-07 10:58:22','SYNCED','a8359b48-d764-484a-b9e5-92e2f666a117',0,NULL,'','','{\"displayTitle\":\"Mandibule 0\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(1,'a83fb03c-717f-4bd4-95fa-a4309b2566e3','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_7a6abf78-0493-467d-acf2-d8e624ad83fc/a83fb03c-717f-4bd4-95fa-a4309b2566e3.pdf','PDF','PATIENT_64c1dc43-bea0-4698-b4a9-13c60ca492cc_ACT_5f66ec30-8d44-4400-87d7-2bb86bdc5667_PROST_1f8edd79-4b6f-4585-b4cb-31f85ef92d4f_PDF_','2019-11-25 17:00:03','2019-06-12 18:46:10','a83fb03c-717f-4bd4-95fa-a4309b2566e3.pdf','2019-11-25 18:00:03','SYNCED','a83fb03c-717f-4bd4-95fa-a4309b2566e3',0,NULL,'','','{\"displayTitle\":\"INLAY ONLAY 5.1.1 INLAY ONLAY\",\"title\":\"Inlay/Onlay PDF\"}'),(1,'ad6e9ee0-12ed-4af8-8b56-3b472e76f840','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_1e220661-7864-4e58-b9a0-adf6a924e40d/ad6e9ee0-12ed-4af8-8b56-3b472e76f840.png','SNAPS','PATIENT_6ffa3f1d-c48d-4158-b8c5-3d98e2d9dd4f_ACT_5f66ec30-8d44-4400-87d7-2bb86bdc5667_SESS_0c142631-f8b2-452a-a29f-b7adabaa8326_TOSC_84acc7ca-6d29-4e98-8ed8-8e9a0ec3f18d_SNAPS_','2020-11-07 09:58:23','2019-06-12 18:16:33','ad6e9ee0-12ed-4af8-8b56-3b472e76f840.png','2020-11-07 10:58:23','SYNCED','ad6e9ee0-12ed-4af8-8b56-3b472e76f840',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 5.2.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(1,'b0011d4f-6ad0-4afd-a6b0-ce433db49361','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/b0011d4f-6ad0-4afd-a6b0-ce433db49361.json','JSON','PATIENT_a74b5bab-833a-4688-9466-2d4387e03c1d_ACT_18373db8-e00e-4f9c-baa9-68dac1d07ec2_PROST_77dc6c87-efd8-47c3-b217-ddaf94bf0750_JSON_','2019-11-27 06:55:24','2019-11-27 07:55:24','b0011d4f-6ad0-4afd-a6b0-ce433db49361.json','2019-11-27 07:55:24','SYNCED','b0011d4f-6ad0-4afd-a6b0-ce433db49361',0,NULL,'','','{\"displayTitle\":\"AMOVIBLE SUR IMPLANT 8.59.1.1 AMOVIBLE SUR IMPLANT\",\"title\":\"Amovible sur Implant JSON\"}'),(1,'b4a3a43f-41bb-4780-afd3-c3f736199be1','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3296fbec-fc91-45de-9488-4f4f7a526b6e/b4a3a43f-41bb-4780-afd3-c3f736199be1.ply','PLY','PATIENT_7fec6224-9b40-43c3-90fa-e233535601b6_ACT_5c92cc6a-0b07-4817-bc97-999b47664e60_SESS_f9840640-e501-4b3a-8cd3-e2ad32249c33_TOSC_ab2c92fd-107f-4eb2-ae40-4b08f4f42ca8_PLY_','2020-11-07 09:58:24','2019-11-26 13:39:07','b4a3a43f-41bb-4780-afd3-c3f736199be1.ply','2020-11-07 10:58:24','SYNCED','b4a3a43f-41bb-4780-afd3-c3f736199be1',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 8.55.1.1.1\",\"modelMatrix\":\"0.872946,-0.479139,0.0916051,0,0.487817,0.857416,-0.163927,0,9.28475e-10,0.187786,0.98221,0,9.7526,-10.0712,-27.9672,1\",\"title\":\"MAXILLAIRE PLY\"}'),(1,'b699290f-d6fe-401e-a793-6b18604533c8','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/b699290f-d6fe-401e-a793-6b18604533c8.png','SCREENS','PATIENT_a74b5bab-833a-4688-9466-2d4387e03c1d_ACT_18373db8-e00e-4f9c-baa9-68dac1d07ec2_SESS_482c9666-2b00-482a-94c3-66b01abb0503_BOSC_7b924a15-9098-47d3-8ddc-1351ea91a34d_SCREENS_','2020-11-07 09:58:24','2019-11-27 07:48:49','b699290f-d6fe-401e-a793-6b18604533c8.png','2020-11-07 10:58:24','SYNCED','b699290f-d6fe-401e-a793-6b18604533c8',0,NULL,'','','{\"displayTitle\":\"Screenshot 8.59.1.1.3 MANDIBULE 1\",\"scanFileId\":\"f84ff04e-75d8-4176-98ed-63f9b3383b57\",\"scanFileType\":\"PLY\",\"scanPosition\":\"1,0,0,0,0,-1,1.22465e-16,0,0,-1.22465e-16,-1,0,0,0,0,1\",\"title\":\"MANDIBULE 1\"}'),(1,'b7f8a07e-149d-11ec-9774-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_d3abcf6c-a9db-4e4d-8828-5653ef9c3d86/b7f8a07e-149d-11ec-9774-96e674358d3a.png','SNAPS','PATIENT_878fca2f-20d8-4cf6-8b37-dae3bf861142_ACT_c30897d5-edd5-4356-b976-1a4a7305ba50_SESS_98ded955-0675-4fad-a78d-2e0362de1368_LESC_b2d2e84e-0322-4196-aa28-b8bef1ed526c_SNAPS_','2021-09-10 13:20:41','2021-09-10 15:20:38','b7f8a07e-149d-11ec-9774-96e674358d3a.png','2021-09-10 15:20:41','SYNCED','b7f8a07e-149d-11ec-9774-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Mordu posterieur gauche 2.137.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1,'b7fd587e-4d00-441f-a2ff-e3da14d90796','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_7a6abf78-0493-467d-acf2-d8e624ad83fc/b7fd587e-4d00-441f-a2ff-e3da14d90796.zip','ZIP','PATIENT_78842f97-ec97-49a7-8b6a-776d8f202e61_ACT_c7b31f13-4f61-44ed-995f-df2d228aed8c_SESS_cceb8198-3858-4357-8764-efc37edcbf8f_RISC_c1ffbf8c-9166-4820-b5d8-2a8332e41f18_ZIP_','2021-06-14 14:19:31','2021-06-14 16:18:37','b7fd587e-4d00-441f-a2ff-e3da14d90796.zip','2021-06-14 16:19:31','SYNCED','b7fd587e-4d00-441f-a2ff-e3da14d90796',0,NULL,'','','{\"displayTitle\":\"Mordu posterieur droit 11.7.1.1.1\",\"modelMatrix\":\"0.9904,0.0955507,0.0958701,0,-0.0542203,0.9154,-0.395297,0,-0.127246,0.391098,0.913548,0,-17.0082,-20.1993,-13.6086,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1,'b8194216-149d-11ec-9774-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_d3abcf6c-a9db-4e4d-8828-5653ef9c3d86/b8194216-149d-11ec-9774-96e674358d3a.png','SNAPS','PATIENT_878fca2f-20d8-4cf6-8b37-dae3bf861142_ACT_c30897d5-edd5-4356-b976-1a4a7305ba50_SESS_98ded955-0675-4fad-a78d-2e0362de1368_RISC_bb07a835-179b-4978-8e41-ac860caf1605_SNAPS_','2021-09-10 13:20:10','2021-09-10 15:20:07','b8194216-149d-11ec-9774-96e674358d3a.png','2021-09-10 15:20:10','SYNCED','b8194216-149d-11ec-9774-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Mordu posterieur droit 2.137.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1,'b81bdcca-149d-11ec-9774-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_d3abcf6c-a9db-4e4d-8828-5653ef9c3d86/b81bdcca-149d-11ec-9774-96e674358d3a.png','SNAPS','PATIENT_878fca2f-20d8-4cf6-8b37-dae3bf861142_ACT_c30897d5-edd5-4356-b976-1a4a7305ba50_SESS_98ded955-0675-4fad-a78d-2e0362de1368_TOSC_71231a4d-24c3-4a9f-bf63-bdce606bdfc6_SNAPS_','2021-09-10 13:37:48','2021-09-10 15:37:40','b81bdcca-149d-11ec-9774-96e674358d3a.png','2021-09-10 15:37:48','SYNCED','b81bdcca-149d-11ec-9774-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 2.137.1.1.6\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1,'b81d62da-149d-11ec-9774-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_d3abcf6c-a9db-4e4d-8828-5653ef9c3d86/b81d62da-149d-11ec-9774-96e674358d3a.zip','ZIP','PATIENT_878fca2f-20d8-4cf6-8b37-dae3bf861142_ACT_c30897d5-edd5-4356-b976-1a4a7305ba50_SESS_98ded955-0675-4fad-a78d-2e0362de1368_FRSC_c2504fda-e351-46bb-9c96-091d6b9a25a5_ZIP_','2021-09-10 13:22:14','2021-09-10 15:22:12','b81d62da-149d-11ec-9774-96e674358d3a.zip','2021-09-10 15:22:14','SYNCED','b81d62da-149d-11ec-9774-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Mordu anterieur 2.137.1.1.1\",\"modelMatrix\":\"0.907555,-0.0914191,0.406148,0,-0.0172242,0.973336,0.221713,0,-0.419796,-0.210843,0.886573,0,-3.42339,13.3112,-20.9623,1\",\"title\":\"Mordu anterieur ZIP\"}'),(1,'b8213bce-149d-11ec-9774-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_d3abcf6c-a9db-4e4d-8828-5653ef9c3d86/b8213bce-149d-11ec-9774-96e674358d3a.zip','ZIP','PATIENT_878fca2f-20d8-4cf6-8b37-dae3bf861142_ACT_c30897d5-edd5-4356-b976-1a4a7305ba50_SESS_98ded955-0675-4fad-a78d-2e0362de1368_OCC_9a20c9e1-e610-4fa5-9739-d7b2ba6887fe_TOPLY__ZIP_','2021-09-10 13:24:31','2021-09-10 15:24:23','b8213bce-149d-11ec-9774-96e674358d3a.zip','2021-09-10 15:24:31','SYNCED','b8213bce-149d-11ec-9774-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 2.137.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.999971,0.0074459,-0.00130143,0,-0.00755878,0.985038,-0.17217,0,1.15656e-11,0.172175,0.985066,0,-23.8036,12.6128,-19.2052,1\",\"referenceScanID\":\"2.137.1.1.1\",\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":10,\"socleIsFullArch\":true,\"socleThickness\":-1,\"socleType\":4,\"title\":\"Maxillaire 2.137.1.1.1 Occlusion 1\"}'),(1,'b822b472-149d-11ec-9774-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_d3abcf6c-a9db-4e4d-8828-5653ef9c3d86/b822b472-149d-11ec-9774-96e674358d3a.png','SNAPS','PATIENT_878fca2f-20d8-4cf6-8b37-dae3bf861142_ACT_c30897d5-edd5-4356-b976-1a4a7305ba50_SESS_98ded955-0675-4fad-a78d-2e0362de1368_TOSC_0a7c6195-2007-4dbf-904b-9b1e54929050_SNAPS_','2021-09-10 13:15:53','2021-09-10 15:12:30','b822b472-149d-11ec-9774-96e674358d3a.png','2021-09-10 15:15:53','SYNCED','b822b472-149d-11ec-9774-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 2.137.1.1.4\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1,'b8264c34-149d-11ec-9774-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_d3abcf6c-a9db-4e4d-8828-5653ef9c3d86/b8264c34-149d-11ec-9774-96e674358d3a.zip','ZIP','PATIENT_878fca2f-20d8-4cf6-8b37-dae3bf861142_ACT_c30897d5-edd5-4356-b976-1a4a7305ba50_SESS_98ded955-0675-4fad-a78d-2e0362de1368_LESC_b2d2e84e-0322-4196-aa28-b8bef1ed526c_ZIP_','2021-09-10 13:20:41','2021-09-10 15:20:39','b8264c34-149d-11ec-9774-96e674358d3a.zip','2021-09-10 15:20:41','SYNCED','b8264c34-149d-11ec-9774-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Mordu posterieur gauche 2.137.1.1.1\",\"modelMatrix\":\"-0.994401,0.101201,-0.0237385,0,-0.101826,-0.993448,-0.0547966,0,-0.0283236,-0.0531388,0.998216,0,11.5244,0.438746,-16.0397,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1,'b828ddea-149d-11ec-9774-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_d3abcf6c-a9db-4e4d-8828-5653ef9c3d86/b828ddea-149d-11ec-9774-96e674358d3a.zip','ZIP','PATIENT_878fca2f-20d8-4cf6-8b37-dae3bf861142_ACT_c30897d5-edd5-4356-b976-1a4a7305ba50_SESS_98ded955-0675-4fad-a78d-2e0362de1368_TOSC_5a89def5-ed45-4e2b-a5e5-4b562201b713_ZIP_','2021-09-10 13:15:56','2021-09-10 15:15:52','b828ddea-149d-11ec-9774-96e674358d3a.zip','2021-09-10 15:15:56','SYNCED','b828ddea-149d-11ec-9774-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 2.137.1.1.5\",\"modelMatrix\":\"0.353876,0.923016,-0.151041,0,-0.935292,0.349231,-0.0571475,0,2.83096e-9,0.16149,0.986874,0,-20.3297,-24.555,-15.6828,1\",\"title\":\"Maxillaire ZIP\"}'),(1,'b82a0a26-149d-11ec-9774-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_d3abcf6c-a9db-4e4d-8828-5653ef9c3d86/b82a0a26-149d-11ec-9774-96e674358d3a.png','SNAPS','PATIENT_878fca2f-20d8-4cf6-8b37-dae3bf861142_ACT_c30897d5-edd5-4356-b976-1a4a7305ba50_SESS_98ded955-0675-4fad-a78d-2e0362de1368_BOSC_556139f9-c2d1-4659-ba4e-112439b15e87_SNAPS_','2021-09-10 13:19:24','2021-09-10 15:19:18','b82a0a26-149d-11ec-9774-96e674358d3a.png','2021-09-10 15:19:24','SYNCED','b82a0a26-149d-11ec-9774-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Mandibule 2.137.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1,'b82b88be-149d-11ec-9774-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_d3abcf6c-a9db-4e4d-8828-5653ef9c3d86/b82b88be-149d-11ec-9774-96e674358d3a.png','SNAPS','PATIENT_878fca2f-20d8-4cf6-8b37-dae3bf861142_ACT_c30897d5-edd5-4356-b976-1a4a7305ba50_SESS_98ded955-0675-4fad-a78d-2e0362de1368_TOSC_5a89def5-ed45-4e2b-a5e5-4b562201b713_SNAPS_','2021-09-10 13:15:56','2021-09-10 15:15:50','b82b88be-149d-11ec-9774-96e674358d3a.png','2021-09-10 15:15:56','SYNCED','b82b88be-149d-11ec-9774-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 2.137.1.1.5\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1,'b82d3b2e-149d-11ec-9774-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_d3abcf6c-a9db-4e4d-8828-5653ef9c3d86/b82d3b2e-149d-11ec-9774-96e674358d3a.zip','ZIP','PATIENT_878fca2f-20d8-4cf6-8b37-dae3bf861142_ACT_c30897d5-edd5-4356-b976-1a4a7305ba50_SESS_98ded955-0675-4fad-a78d-2e0362de1368_TOSC_486ef0cc-520d-4c0f-9efb-19697b4c5f2e_ZIP_','2021-09-10 12:59:35','2021-09-10 14:59:31','b82d3b2e-149d-11ec-9774-96e674358d3a.zip','2021-09-10 14:59:35','SYNCED','b82d3b2e-149d-11ec-9774-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 2.137.1.1.2\",\"modelMatrix\":\"0.722694,0.679879,-0.124414,0,-0.691169,0.710889,-0.130088,0,-7.84109e-10,0.180005,0.983666,0,-28.0143,-11.448,-15.5128,1\",\"title\":\"Maxillaire ZIP\"}'),(1,'b82ea9e1-149d-11ec-9774-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_d3abcf6c-a9db-4e4d-8828-5653ef9c3d86/b82ea9e1-149d-11ec-9774-96e674358d3a.png','SNAPS','PATIENT_878fca2f-20d8-4cf6-8b37-dae3bf861142_ACT_c30897d5-edd5-4356-b976-1a4a7305ba50_SESS_98ded955-0675-4fad-a78d-2e0362de1368_TOSC_afef9387-d95a-4cca-969e-f3cf5b60f814_SNAPS_','2021-09-10 12:56:14','2021-09-10 14:56:07','b82ea9e1-149d-11ec-9774-96e674358d3a.png','2021-09-10 14:56:14','SYNCED','b82ea9e1-149d-11ec-9774-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 2.137.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1,'b830260f-149d-11ec-9774-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_d3abcf6c-a9db-4e4d-8828-5653ef9c3d86/b830260f-149d-11ec-9774-96e674358d3a.m','MATRX','PATIENT_878fca2f-20d8-4cf6-8b37-dae3bf861142_ACT_c30897d5-edd5-4356-b976-1a4a7305ba50_SESS_98ded955-0675-4fad-a78d-2e0362de1368_OCC_9a20c9e1-e610-4fa5-9739-d7b2ba6887fe_TOMA__MATRX_','2021-09-10 13:22:55','2021-09-10 15:22:50','b830260f-149d-11ec-9774-96e674358d3a.m','2021-09-10 15:22:55','SYNCED','b830260f-149d-11ec-9774-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Matrice Transfo. Maxillaire 2.137.1.1.1 Occlusion 1\",\"referenceScanID\":\"2.137.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 2.137.1.1.1 Occlusion 1\"}'),(1,'b83220f1-149d-11ec-9774-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_d3abcf6c-a9db-4e4d-8828-5653ef9c3d86/b83220f1-149d-11ec-9774-96e674358d3a.png','SNAPS','PATIENT_878fca2f-20d8-4cf6-8b37-dae3bf861142_ACT_c30897d5-edd5-4356-b976-1a4a7305ba50_SESS_98ded955-0675-4fad-a78d-2e0362de1368_FRSC_c2504fda-e351-46bb-9c96-091d6b9a25a5_SNAPS_','2021-09-10 13:22:16','2021-09-10 15:22:11','b83220f1-149d-11ec-9774-96e674358d3a.png','2021-09-10 15:22:16','SYNCED','b83220f1-149d-11ec-9774-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Mordu anterieur 2.137.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1,'b833672b-149d-11ec-9774-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_d3abcf6c-a9db-4e4d-8828-5653ef9c3d86/b833672b-149d-11ec-9774-96e674358d3a.zip','ZIP','PATIENT_878fca2f-20d8-4cf6-8b37-dae3bf861142_ACT_c30897d5-edd5-4356-b976-1a4a7305ba50_SESS_98ded955-0675-4fad-a78d-2e0362de1368_OCC_9a20c9e1-e610-4fa5-9739-d7b2ba6887fe_BOPLY__ZIP_','2021-09-10 13:24:35','2021-09-10 15:24:23','b833672b-149d-11ec-9774-96e674358d3a.zip','2021-09-10 15:24:35','SYNCED','b833672b-149d-11ec-9774-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Mandibule 2.137.1.1.1 Occlusion 1\",\"modelMatrix\":\"-0.21445,0.965059,-0.150575,0,-0.976735,-0.211886,0.0330598,0,1.1754e-9,0.154161,0.988046,0,19.1681,-23.2661,-15.3441,1\",\"referenceScanID\":\"2.137.1.1.1\",\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":10,\"socleIsFullArch\":true,\"socleThickness\":-1,\"socleType\":4,\"title\":\"Mandibule 2.137.1.1.1 Occlusion 1\"}'),(1,'b834eced-149d-11ec-9774-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_d3abcf6c-a9db-4e4d-8828-5653ef9c3d86/b834eced-149d-11ec-9774-96e674358d3a.png','SNAPS','PATIENT_878fca2f-20d8-4cf6-8b37-dae3bf861142_ACT_c30897d5-edd5-4356-b976-1a4a7305ba50_SESS_98ded955-0675-4fad-a78d-2e0362de1368_BOSC_616fdf78-ceb4-405e-b31d-1d57b672595f_SNAPS_','2021-09-10 13:24:48','2021-09-10 15:24:47','b834eced-149d-11ec-9774-96e674358d3a.png','2021-09-10 15:24:48','SYNCED','b834eced-149d-11ec-9774-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Mandibule 2.137.1.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(1,'b8368b57-149d-11ec-9774-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_d3abcf6c-a9db-4e4d-8828-5653ef9c3d86/b8368b57-149d-11ec-9774-96e674358d3a.m','MATRX','PATIENT_878fca2f-20d8-4cf6-8b37-dae3bf861142_ACT_c30897d5-edd5-4356-b976-1a4a7305ba50_SESS_98ded955-0675-4fad-a78d-2e0362de1368_OCC_9a20c9e1-e610-4fa5-9739-d7b2ba6887fe_BOMA__MATRX_','2021-09-10 13:22:55','2021-09-10 15:22:50','b8368b57-149d-11ec-9774-96e674358d3a.m','2021-09-10 15:22:55','SYNCED','b8368b57-149d-11ec-9774-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Matrice Transfo. Mandibule 2.137.1.1.1 Occlusion 1\",\"referenceScanID\":\"2.137.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 2.137.1.1.1 Occlusion 1\"}'),(1,'b837dfff-149d-11ec-9774-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_d3abcf6c-a9db-4e4d-8828-5653ef9c3d86/b837dfff-149d-11ec-9774-96e674358d3a.zip','ZIP','PATIENT_878fca2f-20d8-4cf6-8b37-dae3bf861142_ACT_c30897d5-edd5-4356-b976-1a4a7305ba50_SESS_98ded955-0675-4fad-a78d-2e0362de1368_TOSC_71231a4d-24c3-4a9f-bf63-bdce606bdfc6_ZIP_','2021-09-10 13:37:48','2021-09-10 15:37:42','b837dfff-149d-11ec-9774-96e674358d3a.zip','2021-09-10 15:37:48','SYNCED','b837dfff-149d-11ec-9774-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 2.137.1.1.6\",\"modelMatrix\":\"0.914584,0.39016,-0.106353,0,-0.404395,0.882389,-0.240528,0,-5.15165e-9,0.262992,0.964798,0,-29.1801,-1.44547,-16.1573,1\",\"title\":\"Maxillaire ZIP\"}'),(1,'b839b390-149d-11ec-9774-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_d3abcf6c-a9db-4e4d-8828-5653ef9c3d86/b839b390-149d-11ec-9774-96e674358d3a.png','SNAPS','PATIENT_878fca2f-20d8-4cf6-8b37-dae3bf861142_ACT_c30897d5-edd5-4356-b976-1a4a7305ba50_SESS_98ded955-0675-4fad-a78d-2e0362de1368_TOSC_b4b42deb-898f-45ec-a92c-9e302517d67d_SNAPS_','2021-09-10 13:09:25','2021-09-10 15:09:18','b839b390-149d-11ec-9774-96e674358d3a.png','2021-09-10 15:09:25','SYNCED','b839b390-149d-11ec-9774-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 2.137.1.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1,'b83c151d-149d-11ec-9774-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_d3abcf6c-a9db-4e4d-8828-5653ef9c3d86/b83c151d-149d-11ec-9774-96e674358d3a.zip','ZIP','PATIENT_878fca2f-20d8-4cf6-8b37-dae3bf861142_ACT_c30897d5-edd5-4356-b976-1a4a7305ba50_SESS_98ded955-0675-4fad-a78d-2e0362de1368_RISC_bb07a835-179b-4978-8e41-ac860caf1605_ZIP_','2021-09-10 13:20:10','2021-09-10 15:20:07','b83c151d-149d-11ec-9774-96e674358d3a.zip','2021-09-10 15:20:10','SYNCED','b83c151d-149d-11ec-9774-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Mordu posterieur droit 2.137.1.1.1\",\"modelMatrix\":\"0.988743,0.111682,-0.0894095,0,-0.118694,0.993492,-0.0122408,0,0.0913488,0.023033,0.995928,0,-2.85223,-4.47615,-17.402,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1,'b83d5753-149d-11ec-9774-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_d3abcf6c-a9db-4e4d-8828-5653ef9c3d86/b83d5753-149d-11ec-9774-96e674358d3a.png','SNAPS','PATIENT_878fca2f-20d8-4cf6-8b37-dae3bf861142_ACT_c30897d5-edd5-4356-b976-1a4a7305ba50_SESS_98ded955-0675-4fad-a78d-2e0362de1368_TOSC_486ef0cc-520d-4c0f-9efb-19697b4c5f2e_SNAPS_','2021-09-10 12:59:37','2021-09-10 14:59:29','b83d5753-149d-11ec-9774-96e674358d3a.png','2021-09-10 14:59:37','SYNCED','b83d5753-149d-11ec-9774-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 2.137.1.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1,'b83eae31-149d-11ec-9774-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_d3abcf6c-a9db-4e4d-8828-5653ef9c3d86/b83eae31-149d-11ec-9774-96e674358d3a.png','SNAPS','PATIENT_878fca2f-20d8-4cf6-8b37-dae3bf861142_ACT_c30897d5-edd5-4356-b976-1a4a7305ba50_SESS_98ded955-0675-4fad-a78d-2e0362de1368_OCC_9a20c9e1-e610-4fa5-9739-d7b2ba6887fe_SNAPO__SNAPS_','2021-09-10 13:22:54','2021-09-10 15:22:50','b83eae31-149d-11ec-9774-96e674358d3a.png','2021-09-10 15:22:54','SYNCED','b83eae31-149d-11ec-9774-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1,'b83ff744-149d-11ec-9774-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_d3abcf6c-a9db-4e4d-8828-5653ef9c3d86/b83ff744-149d-11ec-9774-96e674358d3a.zip','ZIP','PATIENT_878fca2f-20d8-4cf6-8b37-dae3bf861142_ACT_c30897d5-edd5-4356-b976-1a4a7305ba50_SESS_98ded955-0675-4fad-a78d-2e0362de1368_BOSC_616fdf78-ceb4-405e-b31d-1d57b672595f_ZIP_','2021-09-10 13:24:50','2021-09-10 15:24:47','b83ff744-149d-11ec-9774-96e674358d3a.zip','2021-09-10 15:24:50','SYNCED','b83ff744-149d-11ec-9774-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Mandibule 2.137.1.1.2\",\"modelMatrix\":\"-0.21445,0.965059,-0.150575,0,-0.976735,-0.211886,0.0330598,0,1.1754e-9,0.154161,0.988046,0,19.1681,-23.2661,-15.3441,1\",\"title\":\"Mandibule ZIP\"}'),(1,'b841bee1-149d-11ec-9774-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_d3abcf6c-a9db-4e4d-8828-5653ef9c3d86/b841bee1-149d-11ec-9774-96e674358d3a.zip','ZIP','PATIENT_878fca2f-20d8-4cf6-8b37-dae3bf861142_ACT_c30897d5-edd5-4356-b976-1a4a7305ba50_SESS_98ded955-0675-4fad-a78d-2e0362de1368_TOSC_afef9387-d95a-4cca-969e-f3cf5b60f814_ZIP_','2021-09-10 12:56:13','2021-09-10 14:56:08','b841bee1-149d-11ec-9774-96e674358d3a.zip','2021-09-10 14:56:13','SYNCED','b841bee1-149d-11ec-9774-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 2.137.1.1.1\",\"modelMatrix\":\"0.999971,0.0074459,-0.00130143,0,-0.00755878,0.985038,-0.17217,0,1.15656e-11,0.172175,0.985066,0,-23.8036,12.6128,-19.2052,1\",\"title\":\"Maxillaire ZIP\"}'),(1,'b844d949-149d-11ec-9774-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_d3abcf6c-a9db-4e4d-8828-5653ef9c3d86/b844d949-149d-11ec-9774-96e674358d3a.zip','ZIP','PATIENT_878fca2f-20d8-4cf6-8b37-dae3bf861142_ACT_c30897d5-edd5-4356-b976-1a4a7305ba50_SESS_98ded955-0675-4fad-a78d-2e0362de1368_TOSC_0a7c6195-2007-4dbf-904b-9b1e54929050_ZIP_','2021-09-10 13:12:41','2021-09-10 15:12:31','b844d949-149d-11ec-9774-96e674358d3a.zip','2021-09-10 15:12:41','SYNCED','b844d949-149d-11ec-9774-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 2.137.1.1.4\",\"modelMatrix\":\"0.902826,0.420022,-0.0921243,0,-0.430006,0.881863,-0.193421,0,2.41694e-9,0.214239,0.976781,0,-30.691,0.122139,-15.3475,1\",\"title\":\"Maxillaire ZIP\"}'),(1,'b8468022-149d-11ec-9774-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_d3abcf6c-a9db-4e4d-8828-5653ef9c3d86/b8468022-149d-11ec-9774-96e674358d3a.zip','ZIP','PATIENT_878fca2f-20d8-4cf6-8b37-dae3bf861142_ACT_c30897d5-edd5-4356-b976-1a4a7305ba50_SESS_98ded955-0675-4fad-a78d-2e0362de1368_BOSC_556139f9-c2d1-4659-ba4e-112439b15e87_ZIP_','2021-09-10 13:19:24','2021-09-10 15:19:19','b8468022-149d-11ec-9774-96e674358d3a.zip','2021-09-10 15:19:24','SYNCED','b8468022-149d-11ec-9774-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Mandibule 2.137.1.1.1\",\"modelMatrix\":\"-0.21445,0.965059,-0.150575,0,-0.976735,-0.211886,0.0330598,0,1.1754e-9,0.154161,0.988046,0,19.1681,-23.2661,-15.3441,1\",\"title\":\"Mandibule ZIP\"}'),(1,'b8496f39-149d-11ec-9774-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_d3abcf6c-a9db-4e4d-8828-5653ef9c3d86/b8496f39-149d-11ec-9774-96e674358d3a.zip','ZIP','PATIENT_878fca2f-20d8-4cf6-8b37-dae3bf861142_ACT_c30897d5-edd5-4356-b976-1a4a7305ba50_SESS_98ded955-0675-4fad-a78d-2e0362de1368_TOSC_b4b42deb-898f-45ec-a92c-9e302517d67d_ZIP_','2021-09-10 13:09:25','2021-09-10 15:09:19','b8496f39-149d-11ec-9774-96e674358d3a.zip','2021-09-10 15:09:25','SYNCED','b8496f39-149d-11ec-9774-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 2.137.1.1.3\",\"modelMatrix\":\"0.82587,0.554299,-0.103403,0,-0.563861,0.811864,-0.151451,0,2.29939e-9,0.183384,0.983041,0,-30.0055,-4.10393,-15.8758,1\",\"title\":\"Maxillaire ZIP\"}'),(1,'badf266e-7ea1-43ca-b4de-2ce3ba82d49b','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/badf266e-7ea1-43ca-b4de-2ce3ba82d49b.png','SNAPS','PATIENT_7fec6224-9b40-43c3-90fa-e233535601b6_ACT_5c92cc6a-0b07-4817-bc97-999b47664e60_SESS_f9840640-e501-4b3a-8cd3-e2ad32249c33_BOSC_a7d1c9b3-6e25-43cc-ac70-cea73214d183_SNAPS_','2020-11-07 09:58:24','2019-11-26 16:48:03','badf266e-7ea1-43ca-b4de-2ce3ba82d49b.png','2020-11-07 10:58:24','SYNCED','badf266e-7ea1-43ca-b4de-2ce3ba82d49b',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 8.55.1.1.4\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(1,'be33cc76-cdea-4815-8c6d-396807e5c1bd','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/be33cc76-cdea-4815-8c6d-396807e5c1bd.json','JSON','PATIENT_6f54be3b-4604-426e-bf44-c0e09a217e80_ACT_94abec74-d6a4-4c4c-9da3-d674e05be9ba_PROST_0c7afa20-f759-498d-bb8c-94dd1826b34a_JSON_','2019-11-26 14:24:37','2019-11-26 15:24:36','be33cc76-cdea-4815-8c6d-396807e5c1bd.json','2019-11-26 15:24:37','SYNCED','be33cc76-cdea-4815-8c6d-396807e5c1bd',0,NULL,'','','{\"displayTitle\":\"INLAY ONLAY 3.2.1.8.8 INLAY ONLAY\",\"title\":\"Inlay/Onlay JSON\"}'),(1,'c137e216-950d-4a32-9b10-78b14813f605','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/c137e216-950d-4a32-9b10-78b14813f605.ply','PLY','PATIENT_7fec6224-9b40-43c3-90fa-e233535601b6_ACT_5c92cc6a-0b07-4817-bc97-999b47664e60_SESS_f9840640-e501-4b3a-8cd3-e2ad32249c33_BOSC_73fb055f-6fab-4748-a059-d5260616fcd1_PLY_','2020-11-07 09:58:25','2019-11-26 16:43:06','c137e216-950d-4a32-9b10-78b14813f605.ply','2020-11-07 10:58:25','SYNCED','c137e216-950d-4a32-9b10-78b14813f605',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 8.55.1.1.2\",\"modelMatrix\":\"0.92139,-0.387676,0.0273392,0,0.388639,0.919108,-0.0648161,0,-2.79161e-10,0.0703459,0.997523,0,12.5492,-10.3328,-18.2674,1\",\"title\":\"MANDIBULE PLY\"}'),(1,'c2dbf4ee-8096-49bd-8d5f-47a57c43908e','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/c2dbf4ee-8096-49bd-8d5f-47a57c43908e.json','JSON','PATIENT_d9bfe450-05c7-401c-995e-10be4eba5be5_ACT_68618536-aec2-462e-b599-c206849953af_PROST_bfe61f9c-378c-4051-bc79-c68797c55834_JSON_','2019-11-26 14:02:37','2019-11-26 15:02:36','c2dbf4ee-8096-49bd-8d5f-47a57c43908e.json','2019-11-26 15:02:37','SYNCED','c2dbf4ee-8096-49bd-8d5f-47a57c43908e',0,NULL,'','','{\"displayTitle\":\"BRIDGE SUR IMPLANT 8.56.1.1 BRIDGE SUR IMPLANT\",\"title\":\"Bridge sur Implant JSON\"}'),(1,'c7b50281-2246-44b0-a9e9-f158d544276f','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_39edd03b-189b-4cd8-b553-4fa5e59235ec/c7b50281-2246-44b0-a9e9-f158d544276f.png','SNAPS','PATIENT_392ed6a5-fcff-466b-9677-a1aa24771b54_ACT_bc7415da-45a9-4dfa-a4f6-330b9e5f33b0_SESS_0fefe186-95eb-4ed5-a9bb-0505c1fa4e3d_BOSC_9750760f-01e3-4dfd-9211-ee6864c55242_SNAPS_','2020-10-21 13:33:06','2020-07-20 14:28:26','c7b50281-2246-44b0-a9e9-f158d544276f.png','2020-10-21 15:33:06','SYNCED','c7b50281-2246-44b0-a9e9-f158d544276f',0,NULL,'','','{\"displayTitle\":\"Mandibule 10.2.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1,'c9d7e198-e774-4b90-baf2-3228d984d2c2','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3296fbec-fc91-45de-9488-4f4f7a526b6e/c9d7e198-e774-4b90-baf2-3228d984d2c2.pdf','PDF','PATIENT_ed5bcddc-a157-429f-b179-a4a60485e849_ACT_6a685e00-13b0-4ce1-b5d1-eceffaab76dc_PROST_d2808000-ba2e-4b72-9675-7ec6a91decb0_PDF_','2020-03-11 13:47:18','2020-03-11 14:47:17','c9d7e198-e774-4b90-baf2-3228d984d2c2.pdf','2020-03-11 14:47:18','SYNCED','c9d7e198-e774-4b90-baf2-3228d984d2c2',0,NULL,'','','{\"displayTitle\":\"COURONNE 6.22.1.1 COURONNE\",\"title\":\"Couronne PDF\"}'),(1,'ce0d698d-639e-11ea-96ce-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3296fbec-fc91-45de-9488-4f4f7a526b6e/ce0d698d-639e-11ea-96ce-96e674358d3a.ply','PLY','PATIENT_ed5bcddc-a157-429f-b179-a4a60485e849_ACT_6a685e00-13b0-4ce1-b5d1-eceffaab76dc_SESS_31692a95-aa62-42ed-93d2-f312ae629c57_BOSC_0a50e289-eba0-4bb8-80f6-6363c3e21941_PLY_','2020-10-21 13:33:07','2020-03-11 14:29:18','ce0d698d-639e-11ea-96ce-96e674358d3a.ply','2020-10-21 15:33:07','SYNCED','ce0d698d-639e-11ea-96ce-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Mandibule 6.22.1.1.1\",\"modelMatrix\":\"0.765085,0.594259,-0.247992,0,-0.643929,0.706071,-0.294652,0,-1.52237e-8,0.385123,0.922865,0,-10.4161,-15.0182,-17.3072,1\",\"title\":\"Mandibule PLY\"}'),(1,'ce0f00bf-639e-11ea-96ce-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3296fbec-fc91-45de-9488-4f4f7a526b6e/ce0f00bf-639e-11ea-96ce-96e674358d3a.json','JSON','PATIENT_ed5bcddc-a157-429f-b179-a4a60485e849_ACT_6a685e00-13b0-4ce1-b5d1-eceffaab76dc_PROST_d2808000-ba2e-4b72-9675-7ec6a91decb0_JSON_','2020-10-21 13:33:07','2020-03-11 14:47:17','ce0f00bf-639e-11ea-96ce-96e674358d3a.json','2020-10-21 15:33:07','SYNCED','ce0f00bf-639e-11ea-96ce-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"COURONNE 6.22.1.1 COURONNE\",\"title\":\"Couronne JSON\"}'),(1,'ce107277-639e-11ea-96ce-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3296fbec-fc91-45de-9488-4f4f7a526b6e/ce107277-639e-11ea-96ce-96e674358d3a.pdf','PDF','PATIENT_ed5bcddc-a157-429f-b179-a4a60485e849_ACT_6a685e00-13b0-4ce1-b5d1-eceffaab76dc_PROST_d2808000-ba2e-4b72-9675-7ec6a91decb0_PDF_','2020-10-21 13:33:07','2020-03-11 14:47:17','ce107277-639e-11ea-96ce-96e674358d3a.pdf','2020-10-21 15:33:07','SYNCED','ce107277-639e-11ea-96ce-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"COURONNE 6.22.1.1 COURONNE\",\"title\":\"Couronne PDF\"}'),(1,'ce11f18a-639e-11ea-96ce-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3296fbec-fc91-45de-9488-4f4f7a526b6e/ce11f18a-639e-11ea-96ce-96e674358d3a.png','SNAPS','PATIENT_ed5bcddc-a157-429f-b179-a4a60485e849_ACT_6a685e00-13b0-4ce1-b5d1-eceffaab76dc_SESS_31692a95-aa62-42ed-93d2-f312ae629c57_BOSC_0a50e289-eba0-4bb8-80f6-6363c3e21941_SNAPS_','2020-10-21 13:33:07','2020-03-11 14:29:18','ce11f18a-639e-11ea-96ce-96e674358d3a.png','2020-10-21 15:33:07','SYNCED','ce11f18a-639e-11ea-96ce-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Mandibule 6.22.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1,'cf7a56d5-d334-4075-aa73-6f814dd1935d','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/cf7a56d5-d334-4075-aa73-6f814dd1935d.png','SNAPS','PATIENT_eccc0474-69f5-4755-8f43-a50133b7e35e_ACT_86ce6e3a-d2a4-4280-ae4b-d238bd053895_SESS_467b1648-82ba-4dcc-9934-9635f3b4a7f8_TOSC_82d93a1c-e443-4349-83d9-6f75747ee0b8_SNAPS_','2020-10-21 13:33:07','2019-11-26 18:18:09','cf7a56d5-d334-4075-aa73-6f814dd1935d.png','2020-10-21 15:33:07','SYNCED','cf7a56d5-d334-4075-aa73-6f814dd1935d',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 8.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(1,'d12e9220-7e1d-492a-8c7d-d3e7eb1527df','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_39edd03b-189b-4cd8-b553-4fa5e59235ec/d12e9220-7e1d-492a-8c7d-d3e7eb1527df.ply','PLY','PATIENT_fc5594bc-603f-4ecf-a370-d763ac33006d_ACT_bdfb331a-b542-4e39-9d1e-33bc8bb90aed_SESS_83e62b66-c8c2-49a0-ab0b-0dccf296d880_TOSC_e2845a2d-28ec-441f-9ca3-07a4f02804eb_PLY_','2020-10-21 13:33:08','2020-09-17 17:46:22','d12e9220-7e1d-492a-8c7d-d3e7eb1527df.ply','2020-10-21 15:33:08','SYNCED','d12e9220-7e1d-492a-8c7d-d3e7eb1527df',0,NULL,'','','{\"displayTitle\":\"Maxillaire 11.1.1.1.9\",\"modelMatrix\":\"0.996966,0.0771206,-0.0105083,0,-0.0778333,0.987838,-0.134601,0,-1.02526e-9,0.135011,0.990844,0,15.4167,-25.2746,-12.0361,1\",\"title\":\"Maxillaire PLY\"}'),(1,'d1cb9b15-26cf-49f0-a96d-f691dcb05c62','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3296fbec-fc91-45de-9488-4f4f7a526b6e/d1cb9b15-26cf-49f0-a96d-f691dcb05c62.pdf','PDF','PATIENT_7fec6224-9b40-43c3-90fa-e233535601b6_ACT_5c92cc6a-0b07-4817-bc97-999b47664e60_PROST_056e763d-88fa-40da-8cdb-f2fb9912a1f3_PDF_','2020-09-14 14:58:20','2019-11-26 14:24:31','d1cb9b15-26cf-49f0-a96d-f691dcb05c62.pdf','2020-09-14 16:58:20','SYNCED','d1cb9b15-26cf-49f0-a96d-f691dcb05c62',0,NULL,'','','{\"displayTitle\":\"COURONNE 8.55.1.1 COURONNE\",\"title\":\"Couronne PDF\"}'),(1,'d2c15040-7c88-4c26-a90a-ca5a6784e4b0','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3296fbec-fc91-45de-9488-4f4f7a526b6e/d2c15040-7c88-4c26-a90a-ca5a6784e4b0.png','SNAPS','PATIENT_ed5bcddc-a157-429f-b179-a4a60485e849_ACT_6a685e00-13b0-4ce1-b5d1-eceffaab76dc_SESS_31692a95-aa62-42ed-93d2-f312ae629c57_BOSC_0a50e289-eba0-4bb8-80f6-6363c3e21941_SNAPS_','2020-10-21 13:33:08','2020-03-11 14:29:18','d2c15040-7c88-4c26-a90a-ca5a6784e4b0.png','2020-10-21 15:33:08','SYNCED','d2c15040-7c88-4c26-a90a-ca5a6784e4b0',0,NULL,'','','{\"displayTitle\":\"Mandibule 6.22.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1,'d3465ac8-b877-4ecb-a929-76da5d7a4996','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/d3465ac8-b877-4ecb-a929-76da5d7a4996.ply','PLY','PATIENT_6f54be3b-4604-426e-bf44-c0e09a217e80_ACT_94abec74-d6a4-4c4c-9da3-d674e05be9ba_SESS_94ee1c4b-bea6-487f-bf39-53570bfa5420_OCC_94ee1c4b-bea6-487f-bf39-535migraoccl_BOPLY__PLY_','2020-10-21 13:33:08','2019-06-06 10:03:45','d3465ac8-b877-4ecb-a929-76da5d7a4996.ply','2020-10-21 15:33:08','SYNCED','d3465ac8-b877-4ecb-a929-76da5d7a4996',0,NULL,'','','{\"displayTitle\":\"Mandibule Occlusion 3.2.1.1\",\"title\":\"Mandibule Occlusion PLY\"}'),(1,'d4150236-b82c-4908-adf8-69f0d41b5961','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/d4150236-b82c-4908-adf8-69f0d41b5961.png','SCREENS','PATIENT_a74b5bab-833a-4688-9466-2d4387e03c1d_ACT_18373db8-e00e-4f9c-baa9-68dac1d07ec2_SESS_482c9666-2b00-482a-94c3-66b01abb0503_TOSC_1867e952-05b2-4589-a730-ce347d97ccc1_SCREENS_','2020-10-21 13:33:08','2019-11-27 07:42:00','d4150236-b82c-4908-adf8-69f0d41b5961.png','2020-10-21 15:33:08','SYNCED','d4150236-b82c-4908-adf8-69f0d41b5961',0,NULL,'','','{\"displayTitle\":\"Screenshot 8.59.1.1.1 MAXILLAIRE 2\",\"scanFileId\":\"99670342-6f6e-46e9-8d35-3adf4203f7f4\",\"scanFileType\":\"PLY\",\"scanPosition\":\"1,0,0,0,0,-1,1.22465e-16,0,0,-1.22465e-16,-1,0,0,0,0,1\",\"title\":\"MAXILLAIRE 2\"}'),(1,'d50bcce4-149d-11ec-9774-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_d3abcf6c-a9db-4e4d-8828-5653ef9c3d86/d50bcce4-149d-11ec-9774-96e674358d3a.zip','ZIP','PATIENT_878fca2f-20d8-4cf6-8b37-dae3bf861142_ACT_c30897d5-edd5-4356-b976-1a4a7305ba50_SESS_85648583-fd8e-4577-be60-2d36e0fed1a2_TOSC_922ed81d-137d-4a36-b378-73207bd4f5d9_ZIP_','2021-09-13 08:36:55','2021-09-13 10:36:50','d50bcce4-149d-11ec-9774-96e674358d3a.zip','2021-09-13 10:36:55','SYNCED','d50bcce4-149d-11ec-9774-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 2.137.1.3.2\",\"modelMatrix\":\"0.634738,0.757384,-0.153226,0,-0.772728,0.622133,-0.125864,0,-1.76752e-9,0.198293,0.980143,0,-26.5355,-13.8897,-14.719,1\",\"title\":\"Maxillaire ZIP\"}'),(1,'d50d535b-149d-11ec-9774-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_d3abcf6c-a9db-4e4d-8828-5653ef9c3d86/d50d535b-149d-11ec-9774-96e674358d3a.pdf','PDF','PATIENT_878fca2f-20d8-4cf6-8b37-dae3bf861142_ACT_c30897d5-edd5-4356-b976-1a4a7305ba50_PROST_68094fcf-181d-4848-af56-396f37c97a89_PDF_','2021-09-13 14:21:05','2021-09-13 16:21:04','d50d535b-149d-11ec-9774-96e674358d3a.pdf','2021-09-13 16:21:05','SYNCED','d50d535b-149d-11ec-9774-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"COMMANDE 2.137.1.3 COURONNE\",\"title\":\"Couronne PDF\"}'),(1,'d50ee537-149d-11ec-9774-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_d3abcf6c-a9db-4e4d-8828-5653ef9c3d86/d50ee537-149d-11ec-9774-96e674358d3a.zip','ZIP','PATIENT_878fca2f-20d8-4cf6-8b37-dae3bf861142_ACT_c30897d5-edd5-4356-b976-1a4a7305ba50_SESS_85648583-fd8e-4577-be60-2d36e0fed1a2_TOSC_95120fce-045f-4aa0-b4d9-ff4a04d7753d_ZIP_','2021-09-13 08:33:04','2021-09-13 10:32:54','d50ee537-149d-11ec-9774-96e674358d3a.zip','2021-09-13 10:33:04','SYNCED','d50ee537-149d-11ec-9774-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 2.137.1.3.1\",\"modelMatrix\":\"0.99975,0.0221829,-0.0029072,0,-0.0223726,0.991273,-0.129912,0,-1.14938e-10,0.129945,0.991521,0,-23.3223,10.2111,-18.3784,1\",\"title\":\"Maxillaire ZIP\"}'),(1,'d5109937-149d-11ec-9774-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_d3abcf6c-a9db-4e4d-8828-5653ef9c3d86/d5109937-149d-11ec-9774-96e674358d3a.png','SNAPS','PATIENT_878fca2f-20d8-4cf6-8b37-dae3bf861142_ACT_c30897d5-edd5-4356-b976-1a4a7305ba50_SESS_85648583-fd8e-4577-be60-2d36e0fed1a2_TOSC_922ed81d-137d-4a36-b378-73207bd4f5d9_SNAPS_','2021-09-13 08:36:56','2021-09-13 10:36:48','d5109937-149d-11ec-9774-96e674358d3a.png','2021-09-13 10:36:56','SYNCED','d5109937-149d-11ec-9774-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 2.137.1.3.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1,'d511ff28-149d-11ec-9774-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_d3abcf6c-a9db-4e4d-8828-5653ef9c3d86/d511ff28-149d-11ec-9774-96e674358d3a.png','SNAPS','PATIENT_878fca2f-20d8-4cf6-8b37-dae3bf861142_ACT_c30897d5-edd5-4356-b976-1a4a7305ba50_SESS_85648583-fd8e-4577-be60-2d36e0fed1a2_TOSC_95120fce-045f-4aa0-b4d9-ff4a04d7753d_SNAPS_','2021-09-13 08:33:04','2021-09-13 10:32:53','d511ff28-149d-11ec-9774-96e674358d3a.png','2021-09-13 10:33:04','SYNCED','d511ff28-149d-11ec-9774-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 2.137.1.3.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1,'d5672a29-7aba-4b16-bb23-9233b1f99319','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_7a6abf78-0493-467d-acf2-d8e624ad83fc/d5672a29-7aba-4b16-bb23-9233b1f99319.png','SNAPS','PATIENT_78842f97-ec97-49a7-8b6a-776d8f202e61_ACT_c7b31f13-4f61-44ed-995f-df2d228aed8c_SESS_cceb8198-3858-4357-8764-efc37edcbf8f_TOSC_b3b59b8b-a1b8-4797-a207-5460c7c95667_SNAPS_','2021-06-14 14:29:09','2021-06-14 16:29:08','d5672a29-7aba-4b16-bb23-9233b1f99319.png','2021-06-14 16:29:09','SYNCED','d5672a29-7aba-4b16-bb23-9233b1f99319',0,NULL,'','','{\"displayTitle\":\"Maxillaire 11.7.1.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1,'d7162c50-77cc-4860-b149-a92c05c1fc03','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_7a6abf78-0493-467d-acf2-d8e624ad83fc/d7162c50-77cc-4860-b149-a92c05c1fc03.zip','ZIP','PATIENT_78842f97-ec97-49a7-8b6a-776d8f202e61_ACT_c7b31f13-4f61-44ed-995f-df2d228aed8c_SESS_cceb8198-3858-4357-8764-efc37edcbf8f_TOSC_1b4721aa-af54-40da-a758-ffb23b6a1af9_ZIP_','2021-06-14 14:05:57','2021-06-14 16:02:47','d7162c50-77cc-4860-b149-a92c05c1fc03.zip','2021-06-14 16:05:57','SYNCED','192a0c10-fe5d-43bf-ad68-58d57ba23432',1,NULL,'','','{\"displayTitle\":\"Maxillaire 11.7.1.1.1\",\"modelMatrix\":\"-0.999905,-0.0132502,0.00371127,0,0.0137602,-0.96285,0.269685,0,9.22008e-11,0.269711,0.962941,0,-7.66698,-31.4043,-20.1633,1\",\"title\":\"Maxillaire ZIP\"}'),(1,'d9b59b09-1474-11ec-9774-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_82ca34c0-5553-470e-9bed-5b7e9bedc4d9/d9b59b09-1474-11ec-9774-96e674358d3a.pdf','PDF','PATIENT_8f156fa4-6c5d-4d4b-8d9c-4a29b6061d59_ACT_2afab0ac-5da3-455b-8425-718c88dec869_PROST_65b28ceb-2d97-4376-9821-df374905078e_PDF_','2021-09-13 09:27:43','2021-09-13 11:27:42','d9b59b09-1474-11ec-9774-96e674358d3a.pdf','2021-09-13 11:27:43','SYNCED','d9b59b09-1474-11ec-9774-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"COMMANDE 1.47.2.1 COURONNE\",\"title\":\"Couronne PDF\"}'),(1,'d9b7477e-1474-11ec-9774-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_82ca34c0-5553-470e-9bed-5b7e9bedc4d9/d9b7477e-1474-11ec-9774-96e674358d3a.png','SNAPS','PATIENT_8f156fa4-6c5d-4d4b-8d9c-4a29b6061d59_ACT_2afab0ac-5da3-455b-8425-718c88dec869_SESS_30422177-5e79-41b6-a57c-c28938f1c1ca_TOSC_5dd8e9e1-9667-4ac4-b9a8-ffe54b40bccc_SNAPS_','2021-09-03 12:04:43','2021-09-03 14:04:35','d9b7477e-1474-11ec-9774-96e674358d3a.png','2021-09-03 14:04:43','SYNCED','d9b7477e-1474-11ec-9774-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.47.2.2.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1,'d9b8f3ca-1474-11ec-9774-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_82ca34c0-5553-470e-9bed-5b7e9bedc4d9/d9b8f3ca-1474-11ec-9774-96e674358d3a.zip','ZIP','PATIENT_8f156fa4-6c5d-4d4b-8d9c-4a29b6061d59_ACT_2afab0ac-5da3-455b-8425-718c88dec869_SESS_30422177-5e79-41b6-a57c-c28938f1c1ca_TOSC_5dd8e9e1-9667-4ac4-b9a8-ffe54b40bccc_ZIP_','2021-09-03 12:04:42','2021-09-03 14:04:36','d9b8f3ca-1474-11ec-9774-96e674358d3a.zip','2021-09-03 14:04:42','SYNCED','d9b8f3ca-1474-11ec-9774-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.47.2.2.1\",\"modelMatrix\":\"0.198699,0.947727,-0.249665,0,-0.980061,0.192144,-0.0506176,0,-1.03554e-9,0.254745,0.967008,0,-24.9846,-20.163,-15.9387,1\",\"title\":\"Maxillaire ZIP\"}'),(1,'db4f45f9-cbb2-4d49-86f3-d47bf41c866d','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_7a6abf78-0493-467d-acf2-d8e624ad83fc/db4f45f9-cbb2-4d49-86f3-d47bf41c866d.zip','ZIP','PATIENT_78842f97-ec97-49a7-8b6a-776d8f202e61_ACT_c7b31f13-4f61-44ed-995f-df2d228aed8c_SESS_cceb8198-3858-4357-8764-efc37edcbf8f_BOSC_1cd4f6aa-3184-489c-b1cd-8825b124355d_ZIP_','2021-06-14 14:28:49','2021-06-14 16:28:46','db4f45f9-cbb2-4d49-86f3-d47bf41c866d.zip','2021-06-14 16:28:49','SYNCED','db4f45f9-cbb2-4d49-86f3-d47bf41c866d',0,NULL,'','','{\"displayTitle\":\"Mandibule 11.7.1.1.2\",\"modelMatrix\":\"0.996284,-0.0855673,0.00978113,0,0.0861245,0.989838,-0.113148,0,-5.50591e-10,0.11357,0.99353,0,-21.1434,11.2593,-22.3189,1\",\"title\":\"Mandibule ZIP\"}'),(1,'dc5f3e69-8284-414b-9703-0f203d7bf2df','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3296fbec-fc91-45de-9488-4f4f7a526b6e/dc5f3e69-8284-414b-9703-0f203d7bf2df.json','JSON','PATIENT_7fec6224-9b40-43c3-90fa-e233535601b6_ACT_5c92cc6a-0b07-4817-bc97-999b47664e60_PROST_056e763d-88fa-40da-8cdb-f2fb9912a1f3_JSON_','2020-09-14 14:58:20','2019-11-26 14:24:31','dc5f3e69-8284-414b-9703-0f203d7bf2df.json','2020-09-14 16:58:20','SYNCED','dc5f3e69-8284-414b-9703-0f203d7bf2df',0,NULL,'','','{\"displayTitle\":\"COURONNE 8.55.1.1 COURONNE\",\"title\":\"Couronne JSON\"}'),(1,'de0d8010-bb87-442f-9e42-172731282136','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_39edd03b-189b-4cd8-b553-4fa5e59235ec/de0d8010-bb87-442f-9e42-172731282136.json','JSON','PATIENT_64c1dc43-bea0-4698-b4a9-13c60ca492cc_ACT_4782d962-93f8-43ba-a78f-3ea7bae2af06_PROST_cf9cdb05-ed20-4054-a5d7-6858e2405bf2_JSON_','2019-11-25 17:00:03','2019-06-12 17:47:05','de0d8010-bb87-442f-9e42-172731282136.json','2019-11-25 18:00:03','SYNCED','de0d8010-bb87-442f-9e42-172731282136',0,NULL,'','','{\"displayTitle\":\"AMOVIBLE 5.1.1 AMOVIBLE\",\"title\":\"Amovible JSON\"}'),(1,'deae2324-492d-46a7-be42-925a3b1ba688','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_7a6abf78-0493-467d-acf2-d8e624ad83fc/deae2324-492d-46a7-be42-925a3b1ba688.pdf','PDF','PATIENT_9f5c962b-3b08-45cf-98a9-8cdf5f0b3659_ACT_29fbc46f-2df2-4b38-bd76-82dec3035b1b_PROST_bcb7a620-4df2-44bc-99aa-34c315924974_PDF_','2019-11-25 17:00:03','2019-08-06 13:59:21','deae2324-492d-46a7-be42-925a3b1ba688.pdf','2019-11-25 18:00:03','SYNCED','deae2324-492d-46a7-be42-925a3b1ba688',0,'2019-09-09 14:05:43','','','{\"displayTitle\":\"INLAY ONLAY 7.3.1 INLAY ONLAY\",\"title\":\"Inlay/Onlay PDF\"}'),(1,'df6f2dc6-de60-43c3-a7bb-e06c5335636a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/df6f2dc6-de60-43c3-a7bb-e06c5335636a.png','SCREENS','PATIENT_a74b5bab-833a-4688-9466-2d4387e03c1d_ACT_18373db8-e00e-4f9c-baa9-68dac1d07ec2_SESS_482c9666-2b00-482a-94c3-66b01abb0503_TOSC_1867e952-05b2-4589-a730-ce347d97ccc1_SCREENS_','2020-10-21 13:33:08','2019-11-27 07:41:57','df6f2dc6-de60-43c3-a7bb-e06c5335636a.png','2020-10-21 15:33:08','SYNCED','df6f2dc6-de60-43c3-a7bb-e06c5335636a',0,NULL,'','','{\"displayTitle\":\"Screenshot 8.59.1.1.1 MAXILLAIRE 1\",\"scanFileId\":\"99670342-6f6e-46e9-8d35-3adf4203f7f4\",\"scanFileType\":\"PLY\",\"scanPosition\":\"1,0,0,0,0,-1,1.22465e-16,0,0,-1.22465e-16,-1,0,0,0,0,1\",\"title\":\"MAXILLAIRE 1\"}'),(1,'e1251369-7408-4850-a9d5-8b350b4741df','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_39edd03b-189b-4cd8-b553-4fa5e59235ec/e1251369-7408-4850-a9d5-8b350b4741df.pdf','PDF','PATIENT_64c1dc43-bea0-4698-b4a9-13c60ca492cc_ACT_4782d962-93f8-43ba-a78f-3ea7bae2af06_PROST_cf9cdb05-ed20-4054-a5d7-6858e2405bf2_PDF_','2019-11-25 17:00:03','2019-06-12 17:47:05','e1251369-7408-4850-a9d5-8b350b4741df.pdf','2019-11-25 18:00:03','SYNCED','e1251369-7408-4850-a9d5-8b350b4741df',0,NULL,'','','{\"displayTitle\":\"AMOVIBLE 5.1.1 AMOVIBLE\",\"title\":\"Amovible PDF\"}'),(1,'e189b1bb-3cd5-49b0-a7a9-5f6124688584','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/e189b1bb-3cd5-49b0-a7a9-5f6124688584.pdf','PDF','PATIENT_7fec6224-9b40-43c3-90fa-e233535601b6_ACT_5c92cc6a-0b07-4817-bc97-999b47664e60_PROST_b655a8d6-f80f-4b44-8bc2-aa2fe933fc54_PDF_','2020-09-14 14:58:20','2019-11-26 14:32:46','e189b1bb-3cd5-49b0-a7a9-5f6124688584.pdf','2020-09-14 16:58:20','SYNCED','e189b1bb-3cd5-49b0-a7a9-5f6124688584',0,NULL,'','','{\"displayTitle\":\"INLAY ONLAY 8.55.1.2 INLAY ONLAY\",\"title\":\"Inlay/Onlay PDF\"}'),(1,'e2c207f8-d63a-4b68-ba23-b85ab9ac9733','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_39edd03b-189b-4cd8-b553-4fa5e59235ec/e2c207f8-d63a-4b68-ba23-b85ab9ac9733.json','JSON','PATIENT_392ed6a5-fcff-466b-9677-a1aa24771b54_ACT_bc7415da-45a9-4dfa-a4f6-330b9e5f33b0_PROST_2e43389a-0785-4c6a-a481-204442bba3d2_JSON_','2020-10-21 13:33:09','2020-07-20 14:29:29','e2c207f8-d63a-4b68-ba23-b85ab9ac9733.json','2020-10-21 15:33:09','SYNCED','e2c207f8-d63a-4b68-ba23-b85ab9ac9733',0,NULL,'','','{\"displayTitle\":\"COURONNE 10.2.1.1 COURONNE\",\"title\":\"Couronne JSON\"}'),(1,'e2c2b0c3-cc7d-4726-b1e7-394a3d116153','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/e2c2b0c3-cc7d-4726-b1e7-394a3d116153.pdf','PDF','PATIENT_7fec6224-9b40-43c3-90fa-e233535601b6_ACT_5c92cc6a-0b07-4817-bc97-999b47664e60_PROST_61fbccd0-b247-4bf5-b093-f3ab41f039f7_PDF_','2019-11-26 15:57:09','2019-11-26 16:57:08','e2c2b0c3-cc7d-4726-b1e7-394a3d116153.pdf','2019-11-26 16:57:09','SYNCED','e2c2b0c3-cc7d-4726-b1e7-394a3d116153',0,NULL,'','','{\"displayTitle\":\"FACETTE 8.55.1.5 FACETTE\",\"title\":\"Facette PDF\"}'),(1,'e52eb2e5-65fa-4080-9cae-4831a3eb3c77','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/e52eb2e5-65fa-4080-9cae-4831a3eb3c77.ply','PLY','PATIENT_7fec6224-9b40-43c3-90fa-e233535601b6_ACT_5c92cc6a-0b07-4817-bc97-999b47664e60_SESS_f9840640-e501-4b3a-8cd3-e2ad32249c33_BOSC_e3e1b759-5480-4664-8a8a-ca265fa7846e_PLY_','2020-10-21 13:33:09','2019-11-26 16:44:06','e52eb2e5-65fa-4080-9cae-4831a3eb3c77.ply','2020-10-21 15:33:09','SYNCED','e52eb2e5-65fa-4080-9cae-4831a3eb3c77',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 8.55.1.1.3\",\"modelMatrix\":\"0.998006,0.0606528,-0.0174669,0,-0.0631178,0.95903,-0.276184,0,-1.01641e-9,0.276736,0.960946,0,17.6903,-7.82104,-19.8546,1\",\"title\":\"MANDIBULE PLY\"}'),(1,'e60c5885-6dfd-4101-8fd1-2ff1b07dc8ff','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_39edd03b-189b-4cd8-b553-4fa5e59235ec/e60c5885-6dfd-4101-8fd1-2ff1b07dc8ff.png','SNAPS','PATIENT_fc5594bc-603f-4ecf-a370-d763ac33006d_ACT_bdfb331a-b542-4e39-9d1e-33bc8bb90aed_SESS_83e62b66-c8c2-49a0-ab0b-0dccf296d880_TOSC_0edca99b-de95-42a5-93cd-054792bd338b_SNAPS_','2020-10-21 13:33:09','2020-09-17 17:43:56','e60c5885-6dfd-4101-8fd1-2ff1b07dc8ff.png','2020-10-21 15:33:09','SYNCED','e60c5885-6dfd-4101-8fd1-2ff1b07dc8ff',0,NULL,'','','{\"displayTitle\":\"Maxillaire 11.1.1.1.8\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1,'e619dbad-adce-4f7e-b837-ca7fd7666495','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/e619dbad-adce-4f7e-b837-ca7fd7666495.png','SNAPS','PATIENT_a74b5bab-833a-4688-9466-2d4387e03c1d_ACT_18373db8-e00e-4f9c-baa9-68dac1d07ec2_SESS_482c9666-2b00-482a-94c3-66b01abb0503_BOSC_7b924a15-9098-47d3-8ddc-1351ea91a34d_SNAPS_','2020-10-21 13:33:09','2019-11-27 07:48:42','e619dbad-adce-4f7e-b837-ca7fd7666495.png','2020-10-21 15:33:09','SYNCED','e619dbad-adce-4f7e-b837-ca7fd7666495',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 8.59.1.1.3\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(1,'e6f1d054-57c5-4117-976d-e13f15b011d0','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_39edd03b-189b-4cd8-b553-4fa5e59235ec/e6f1d054-57c5-4117-976d-e13f15b011d0.ply','PLY','PATIENT_392ed6a5-fcff-466b-9677-a1aa24771b54_ACT_bc7415da-45a9-4dfa-a4f6-330b9e5f33b0_SESS_0fefe186-95eb-4ed5-a9bb-0505c1fa4e3d_BOSC_9750760f-01e3-4dfd-9211-ee6864c55242_PLY_','2020-10-21 13:33:09','2020-07-20 14:28:26','e6f1d054-57c5-4117-976d-e13f15b011d0.ply','2020-10-21 15:33:09','SYNCED','e6f1d054-57c5-4117-976d-e13f15b011d0',0,NULL,'','','{\"displayTitle\":\"Mandibule 10.2.1.1.1\",\"modelMatrix\":\"0.765085,0.594259,-0.247992,0,-0.643929,0.706071,-0.294652,0,-1.52237e-8,0.385123,0.922865,0,-10.4161,-15.0182,-17.3072,1\",\"title\":\"Mandibule PLY\"}'),(1,'ef7d0499-dc5c-42d3-abbd-909439dee43a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_39edd03b-189b-4cd8-b553-4fa5e59235ec/ef7d0499-dc5c-42d3-abbd-909439dee43a.json','JSON','PATIENT_fc5594bc-603f-4ecf-a370-d763ac33006d_ACT_bdfb331a-b542-4e39-9d1e-33bc8bb90aed_PROST_f2192709-5947-4789-b255-0d7e11707a32_JSON_','2020-10-21 13:33:09','2020-09-29 10:56:36','ef7d0499-dc5c-42d3-abbd-909439dee43a.json','2020-10-21 15:33:09','SYNCED','ef7d0499-dc5c-42d3-abbd-909439dee43a',0,NULL,'','','{\"displayTitle\":\"COURONNE 11.1.1.1 COURONNE\",\"title\":\"Couronne JSON\"}'),(1,'f039af80-149d-11ec-9774-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_d3abcf6c-a9db-4e4d-8828-5653ef9c3d86/f039af80-149d-11ec-9774-96e674358d3a.pdf','PDF','PATIENT_878fca2f-20d8-4cf6-8b37-dae3bf861142_ACT_c30897d5-edd5-4356-b976-1a4a7305ba50_PROST_dbae734a-d83a-4f3a-9f71-084acc2ec051_PDF_','2021-09-13 14:21:50','2021-09-13 16:21:47','f039af80-149d-11ec-9774-96e674358d3a.pdf','2021-09-13 16:21:50','SYNCED','f039af80-149d-11ec-9774-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"COMMANDE 2.137.1.4 COURONNE\",\"title\":\"Couronne PDF\"}'),(1,'f1159414-a4d8-4adb-bf40-52342b3d5c35','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/f1159414-a4d8-4adb-bf40-52342b3d5c35.png','SNAPS','PATIENT_7fec6224-9b40-43c3-90fa-e233535601b6_ACT_5c92cc6a-0b07-4817-bc97-999b47664e60_SESS_f9840640-e501-4b3a-8cd3-e2ad32249c33_BOSC_e3e1b759-5480-4664-8a8a-ca265fa7846e_SNAPS_','2020-10-21 13:33:10','2019-11-26 16:44:06','f1159414-a4d8-4adb-bf40-52342b3d5c35.png','2020-10-21 15:33:10','SYNCED','f1159414-a4d8-4adb-bf40-52342b3d5c35',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 8.55.1.1.3\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(1,'f222fe44-ede2-4bd6-b444-633492738f11','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_7a6abf78-0493-467d-acf2-d8e624ad83fc/f222fe44-ede2-4bd6-b444-633492738f11.json','JSON','PATIENT_9f5c962b-3b08-45cf-98a9-8cdf5f0b3659_ACT_7482d5bd-25bf-450b-87d7-32326dc39cff_PROST_99d3894c-dd1b-4217-a77f-20554599ea89_JSON_','2019-11-25 17:00:03','2019-08-07 16:17:01','f222fe44-ede2-4bd6-b444-633492738f11.json','2019-11-25 18:00:03','SYNCED','f222fe44-ede2-4bd6-b444-633492738f11',0,'2019-09-09 14:05:43','','','{\"displayTitle\":\"BRIDGE SUR IMPLANT 7.3.2 BRIDGE SUR IMPLANT\",\"title\":\"Bridge sur Implant JSON\"}'),(1,'f4b8a19f-eba0-4417-a57a-89fa1c6eab26','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/f4b8a19f-eba0-4417-a57a-89fa1c6eab26.png','SNAPS','PATIENT_a74b5bab-833a-4688-9466-2d4387e03c1d_ACT_18373db8-e00e-4f9c-baa9-68dac1d07ec2_SESS_482c9666-2b00-482a-94c3-66b01abb0503_TOSC_1867e952-05b2-4589-a730-ce347d97ccc1_SNAPS_','2020-10-21 13:33:10','2019-11-27 07:41:50','f4b8a19f-eba0-4417-a57a-89fa1c6eab26.png','2020-10-21 15:33:10','SYNCED','f4b8a19f-eba0-4417-a57a-89fa1c6eab26',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 8.59.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(1,'f5f89539-34c3-11eb-973a-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_82ca34c0-5553-470e-9bed-5b7e9bedc4d9/f5f89539-34c3-11eb-973a-96e674358d3a.ply','PLY','PATIENT_20db9968-3a56-48e4-9a0b-1e0c97633cda_ACT_ae7f5446-27c2-475b-9c90-29261d7478b9_SESS_d593215e-c6bd-4ca8-8f71-2d9f7c70d912_TOSC_cb539b59-5dc3-49fb-8c4e-3a554b96eee6_PLY_','2020-11-30 08:29:28','2020-11-30 09:29:24','f5f89539-34c3-11eb-973a-96e674358d3a.ply','2020-11-30 09:29:28','SYNCED','f5f89539-34c3-11eb-973a-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.17.3.3.1\",\"modelMatrix\":\"0.787925,0.611344,-0.0737045,0,-0.615771,0.782261,-0.0943105,0,-1.76976e-9,0.119695,0.992811,0,-27.8201,-8.48808,-17.0182,1\",\"title\":\"Maxillaire PLY\"}'),(1,'f5f9e9dc-34c3-11eb-973a-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_82ca34c0-5553-470e-9bed-5b7e9bedc4d9/f5f9e9dc-34c3-11eb-973a-96e674358d3a.png','SNAPS','PATIENT_20db9968-3a56-48e4-9a0b-1e0c97633cda_ACT_ae7f5446-27c2-475b-9c90-29261d7478b9_SESS_d593215e-c6bd-4ca8-8f71-2d9f7c70d912_TOSC_cb539b59-5dc3-49fb-8c4e-3a554b96eee6_SNAPS_','2020-11-30 08:29:26','2020-11-30 09:29:24','f5f9e9dc-34c3-11eb-973a-96e674358d3a.png','2020-11-30 09:29:26','SYNCED','f5f9e9dc-34c3-11eb-973a-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.17.3.3.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1,'f601e6f7-34c3-11eb-973a-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_82ca34c0-5553-470e-9bed-5b7e9bedc4d9/f601e6f7-34c3-11eb-973a-96e674358d3a.json','JSON','PATIENT_5fc5f4e3-2e4a-48e4-a31c-31b9703839e4_ACT_3c25cea0-61bc-4cc8-9cf3-21d813eac964_PROST_5e57d669-a0fa-474a-a65a-c28b47c6279b_JSON_','2020-10-12 14:15:36','2020-10-12 16:15:35','f601e6f7-34c3-11eb-973a-96e674358d3a.json','2020-10-12 16:15:36','SYNCED','f601e6f7-34c3-11eb-973a-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"COURONNE 1.11.1.1 COURONNE\",\"title\":\"Couronne JSON\"}'),(1,'f6039070-34c3-11eb-973a-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_82ca34c0-5553-470e-9bed-5b7e9bedc4d9/f6039070-34c3-11eb-973a-96e674358d3a.ply','PLY','PATIENT_5fc5f4e3-2e4a-48e4-a31c-31b9703839e4_ACT_3c25cea0-61bc-4cc8-9cf3-21d813eac964_SESS_4d647740-47c2-445d-84f4-c90298e7c3ec_TOSC_53d45257-fb72-4547-b0b9-eebf7af51d85_PLY_','2020-10-12 10:05:54','2020-10-12 12:05:50','f6039070-34c3-11eb-973a-96e674358d3a.ply','2020-10-12 12:05:54','SYNCED','f6039070-34c3-11eb-973a-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.11.1.4.1\",\"modelMatrix\":\"-0.452502,0.874614,-0.174045,0,-0.891763,-0.4438,0.0883144,0,1.35893e-9,0.195169,0.98077,0,-0.893949,9.79826,-20.7124,1\",\"title\":\"Maxillaire PLY\"}'),(1,'f60513c1-34c3-11eb-973a-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_82ca34c0-5553-470e-9bed-5b7e9bedc4d9/f60513c1-34c3-11eb-973a-96e674358d3a.pdf','PDF','PATIENT_5fc5f4e3-2e4a-48e4-a31c-31b9703839e4_ACT_3c25cea0-61bc-4cc8-9cf3-21d813eac964_PROST_5e57d669-a0fa-474a-a65a-c28b47c6279b_PDF_','2020-10-12 14:15:36','2020-10-12 16:15:35','f60513c1-34c3-11eb-973a-96e674358d3a.pdf','2020-10-12 16:15:36','SYNCED','f60513c1-34c3-11eb-973a-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"COURONNE 1.11.1.1 COURONNE\",\"title\":\"Couronne PDF\"}'),(1,'f606b2d5-34c3-11eb-973a-96e674358d3a','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_82ca34c0-5553-470e-9bed-5b7e9bedc4d9/f606b2d5-34c3-11eb-973a-96e674358d3a.png','SNAPS','PATIENT_5fc5f4e3-2e4a-48e4-a31c-31b9703839e4_ACT_3c25cea0-61bc-4cc8-9cf3-21d813eac964_SESS_4d647740-47c2-445d-84f4-c90298e7c3ec_TOSC_53d45257-fb72-4547-b0b9-eebf7af51d85_SNAPS_','2020-10-12 10:05:53','2020-10-12 12:05:50','f606b2d5-34c3-11eb-973a-96e674358d3a.png','2020-10-12 12:05:53','SYNCED','f606b2d5-34c3-11eb-973a-96e674358d3a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.11.1.4.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1,'f61a6164-f96b-4403-b45c-bd7649df9255','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_7a6abf78-0493-467d-acf2-d8e624ad83fc/f61a6164-f96b-4403-b45c-bd7649df9255.zip','ZIP','PATIENT_78842f97-ec97-49a7-8b6a-776d8f202e61_ACT_c7b31f13-4f61-44ed-995f-df2d228aed8c_SESS_cceb8198-3858-4357-8764-efc37edcbf8f_OCC_5e232b66-e878-40a9-81c0-0005877fb5bf_BOPLY__ZIP_','2021-06-14 14:31:36','2021-06-14 16:31:28','f61a6164-f96b-4403-b45c-bd7649df9255.zip','2021-06-14 16:31:36','SYNCED','f61a6164-f96b-4403-b45c-bd7649df9255',0,NULL,'','','{\"displayTitle\":\"Mandibule 11.7.1.1.2 Occlusion 2\",\"modelMatrix\":\"0.996284,-0.0855673,0.00978113,0,0.0861245,0.989838,-0.113148,0,-5.50591e-10,0.11357,0.99353,0,-21.1434,11.2593,-22.3189,1\",\"referenceScanID\":\"11.7.1.1.2\",\"title\":\"Mandibule 11.7.1.1.2 Occlusion 2\"}'),(1,'f66cea56-42b0-41df-bab8-cceb869bc846','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/f66cea56-42b0-41df-bab8-cceb869bc846.pdf','PDF','PATIENT_6f54be3b-4604-426e-bf44-c0e09a217e80_ACT_94abec74-d6a4-4c4c-9da3-d674e05be9ba_PROST_0c7afa20-f759-498d-bb8c-94dd1826b34a_PDF_','2019-11-26 14:24:37','2019-11-26 15:24:36','f66cea56-42b0-41df-bab8-cceb869bc846.pdf','2019-11-26 15:24:37','SYNCED','f66cea56-42b0-41df-bab8-cceb869bc846',0,NULL,'','','{\"displayTitle\":\"INLAY ONLAY 3.2.1.8.8 INLAY ONLAY\",\"title\":\"Inlay/Onlay PDF\"}'),(1,'f70a23af-1ebb-48b7-ba02-af5e6cf0a956','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_1e220661-7864-4e58-b9a0-adf6a924e40d/f70a23af-1ebb-48b7-ba02-af5e6cf0a956.png','SNAPS','PATIENT_6ffa3f1d-c48d-4158-b8c5-3d98e2d9dd4f_ACT_5f66ec30-8d44-4400-87d7-2bb86bdc5667_SESS_0c142631-f8b2-452a-a29f-b7adabaa8326_BOSC_452894f3-ec03-42b7-b4c4-48c6762a0d3f_SNAPS_','2020-10-21 13:33:10','2019-06-12 18:17:10','f70a23af-1ebb-48b7-ba02-af5e6cf0a956.png','2020-10-21 15:33:10','SYNCED','f70a23af-1ebb-48b7-ba02-af5e6cf0a956',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 5.2.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(1,'f762d7d9-d5ac-4f8f-8d4b-c3639463fb5f','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_1e220661-7864-4e58-b9a0-adf6a924e40d/f762d7d9-d5ac-4f8f-8d4b-c3639463fb5f.json','JSON','PATIENT_64c1dc43-bea0-4698-b4a9-13c60ca492cc_ACT_5f66ec30-8d44-4400-87d7-2bb86bdc5667_PROST_605dd0f0-e078-462b-8125-2140f727bbe2_JSON_','2019-11-25 17:00:03','2019-06-12 18:57:58','f762d7d9-d5ac-4f8f-8d4b-c3639463fb5f.json','2019-11-25 18:00:03','SYNCED','f762d7d9-d5ac-4f8f-8d4b-c3639463fb5f',0,NULL,'','','{\"displayTitle\":\"INLAY CORE 5.1.1 INLAY CORE\",\"title\":\"Inlay Core JSON\"}'),(1,'f84ff04e-75d8-4176-98ed-63f9b3383b57','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/f84ff04e-75d8-4176-98ed-63f9b3383b57.ply','PLY','PATIENT_a74b5bab-833a-4688-9466-2d4387e03c1d_ACT_18373db8-e00e-4f9c-baa9-68dac1d07ec2_SESS_482c9666-2b00-482a-94c3-66b01abb0503_BOSC_7b924a15-9098-47d3-8ddc-1351ea91a34d_PLY_','2020-10-21 13:33:10','2019-11-27 07:48:42','f84ff04e-75d8-4176-98ed-63f9b3383b57.ply','2020-10-21 15:33:10','SYNCED','f84ff04e-75d8-4176-98ed-63f9b3383b57',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 8.59.1.1.3\",\"modelMatrix\":\"0.995568,0.0890581,-0.0302031,0,-0.0940403,0.942824,-0.319749,0,1.65043e-9,0.321172,0.947021,0,15.6726,-1.48313,-22.3006,1\",\"title\":\"MANDIBULE PLY\"}'),(1,'fb0d60a8-5cf5-49dc-8104-d3d60e45ee2b','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_7a6abf78-0493-467d-acf2-d8e624ad83fc/fb0d60a8-5cf5-49dc-8104-d3d60e45ee2b.png','SNAPS','PATIENT_78842f97-ec97-49a7-8b6a-776d8f202e61_ACT_c7b31f13-4f61-44ed-995f-df2d228aed8c_SESS_cceb8198-3858-4357-8764-efc37edcbf8f_TOSC_1b4721aa-af54-40da-a758-ffb23b6a1af9_SNAPS_','2021-06-14 14:05:57','2021-06-14 16:02:45','fb0d60a8-5cf5-49dc-8104-d3d60e45ee2b.png','2021-06-14 16:05:57','SYNCED','a44d6a6d-99a8-4bef-bba2-5930d7c14146',1,NULL,'','','{\"displayTitle\":\"Maxillaire 11.7.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1,'fcfe7063-3bf7-4303-ab31-a6444d887c33','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_7a6abf78-0493-467d-acf2-d8e624ad83fc/fcfe7063-3bf7-4303-ab31-a6444d887c33.zip','ZIP','PATIENT_78842f97-ec97-49a7-8b6a-776d8f202e61_ACT_c7b31f13-4f61-44ed-995f-df2d228aed8c_SESS_cceb8198-3858-4357-8764-efc37edcbf8f_BOSC_6d8c6d91-9ae3-42f3-8679-22dec20d9b8f_ZIP_','2021-06-14 14:15:33','2021-06-14 16:12:12','fcfe7063-3bf7-4303-ab31-a6444d887c33.zip','2021-06-14 16:15:33','SYNCED','fcfe7063-3bf7-4303-ab31-a6444d887c33',0,NULL,'','','{\"displayTitle\":\"Mandibule 11.7.1.1.1\",\"modelMatrix\":\"0.996284,-0.0855673,0.00978113,0,0.0861245,0.989838,-0.113148,0,-5.50591e-10,0.11357,0.99353,0,-21.1434,11.2593,-22.3189,1\",\"title\":\"Mandibule ZIP\"}'),(1,'fee5320b-dbd2-488c-bcc3-77bce4985902','/var/.data/2022/1ac0d2f9-8c99-4537-8eec-18a05630ecb2/discussion_3e3e6088-e3b5-4004-a58f-c314a2dd70b1/fee5320b-dbd2-488c-bcc3-77bce4985902.png','SNAPS','PATIENT_a74b5bab-833a-4688-9466-2d4387e03c1d_ACT_18373db8-e00e-4f9c-baa9-68dac1d07ec2_SESS_482c9666-2b00-482a-94c3-66b01abb0503_BOSC_3f8bcc46-2ed9-40ad-99e2-cf987d1e14b8_SNAPS_','2020-10-21 13:33:10','2019-11-27 07:49:38','fee5320b-dbd2-488c-bcc3-77bce4985902.png','2020-10-21 15:33:10','SYNCED','fee5320b-dbd2-488c-bcc3-77bce4985902',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 8.59.1.1.3\",\"title\":\"MAXILLAIRE SNAPSHOT\"}');
/*!40000 ALTER TABLE `CondorFile` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `CondorFile_BEFORE_DELETE` BEFORE DELETE ON `CondorFile` FOR EACH ROW BEGIN
  UPDATE Session SET mandibuleOcclusionPlyID = NULL
  WHERE ownerID = OLD.ownerID AND mandibuleOcclusionPlyID = OLD.id;

  UPDATE Session SET mandibuleOcclusionStlID = NULL
  WHERE ownerID = OLD.ownerID AND mandibuleOcclusionStlID = OLD.id;

  UPDATE Session SET maxillaireOcclusionPlyID = NULL
  WHERE ownerID = OLD.ownerID AND maxillaireOcclusionPlyID = OLD.id;

  UPDATE Session SET maxillaireOcclusionStlID = NULL
  WHERE ownerID = OLD.ownerID AND maxillaireOcclusionStlID = OLD.id;

  UPDATE Session SET mandibuleOcclusionPointContactID = NULL
  WHERE ownerID = OLD.ownerID AND mandibuleOcclusionPointContactID = OLD.id;

  UPDATE Session SET maxillaireOcclusionPointContactID = NULL
  WHERE ownerID = OLD.ownerID AND maxillaireOcclusionPointContactID = OLD.id;

  UPDATE Session SET matrixTransformationMandibuleID = NULL
  WHERE ownerID = OLD.ownerID AND matrixTransformationMandibuleID = OLD.id;

  UPDATE Session SET matrixTransformationMaxillaireID = NULL
  WHERE ownerID = OLD.ownerID AND matrixTransformationMaxillaireID = OLD.id;

  UPDATE Session SET snapshotID = NULL
  WHERE ownerID = OLD.ownerID AND snapshotID = OLD.id;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `Config`
--

DROP TABLE IF EXISTS `Config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Config` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `fullRetrieve` tinyint(1) DEFAULT '0',
  `syncEnabled` tinyint(1) DEFAULT '1',
  `showOcclusionScan` tinyint(1) DEFAULT '1',
  `showOpenStlWarning` tinyint(1) DEFAULT '1',
  `showMarginLinesWarning` tinyint(1) DEFAULT '1',
  `showDeleteConfirmation` tinyint(1) DEFAULT '1',
  `showSyncInfo` tinyint(1) DEFAULT '1',
  `downloadAtFullRetrieve` tinyint(1) DEFAULT '1',
  `lagSound` tinyint(1) DEFAULT '0',
  `lostSound` tinyint(1) DEFAULT '0',
  `emailNotifications` tinyint(1) DEFAULT '1',
  `logout` mediumint DEFAULT '10',
  `language` varchar(2) DEFAULT NULL,
  `flipMaxillaryH` tinyint(1) DEFAULT '0',
  `flipMaxillaryV` tinyint(1) DEFAULT '0',
  `flipMandibleH` tinyint(1) DEFAULT '0',
  `flipMandibleV` tinyint(1) DEFAULT '0',
  `showFlipPopupMaxillary` tinyint(1) DEFAULT '1',
  `showFlipPopupMandible` tinyint(1) DEFAULT '1',
  `enableUserSharing` tinyint(1) DEFAULT '1',
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `diagnosticMode` tinyint(1) DEFAULT '0',
  `repairMode` tinyint(1) DEFAULT '0',
  `lostTrackingRectangle` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Config_Professional` (`ownerID`),
  CONSTRAINT `fk_Config_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Config`
--

LOCK TABLES `Config` WRITE;
/*!40000 ALTER TABLE `Config` DISABLE KEYS */;
INSERT INTO `Config` VALUES (1,1,0,1,1,1,1,1,0,0,0,0,1,99,'fr',0,0,0,0,1,1,0,'2022-01-03 16:39:26','2022-01-03 15:39:26','2022-01-03 16:39:25',0,0,0),(3,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2020-11-07 10:57:47','2020-11-07 09:57:47','2020-11-07 10:57:47',0,0,0),(4,1,0,1,1,1,1,1,0,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2020-10-19 04:03:30','2020-10-19 02:03:30','2019-08-29 12:17:46',0,0,0),(6,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2020-10-19 04:03:30','2020-10-19 02:03:30','2019-02-12 15:44:07',0,0,0),(17,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2020-10-19 04:03:30','2020-10-19 02:03:30','2019-04-30 09:28:19',0,0,0),(19,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2020-10-19 04:03:30','2020-10-19 02:03:30','2019-06-12 18:19:39',0,0,0),(20,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2020-10-19 04:03:30','2020-10-19 02:03:30','2019-06-12 18:34:57',0,0,0),(21,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2020-10-19 04:03:30','2020-10-19 02:03:30','2019-06-12 18:37:27',0,0,0),(22,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2020-10-19 04:03:30','2020-10-19 02:03:30','2019-06-12 18:43:13',0,0,0),(26,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2020-10-19 04:03:30','2020-10-19 02:03:30','2019-07-22 16:58:50',0,0,0),(27,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2020-10-19 04:03:30','2020-10-19 02:03:30','2019-08-06 15:04:19',0,0,0),(28,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2020-10-19 04:03:30','2020-10-19 02:03:30','2019-08-07 15:23:31',0,0,0),(29,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2020-10-19 04:03:30','2020-10-19 02:03:30','2019-08-29 12:18:04',0,0,0),(31,1,0,1,1,1,0,1,1,1,1,0,1,120,'fr',0,0,0,0,1,1,0,'2021-12-02 14:48:08','2021-12-02 13:48:08','2021-11-26 15:24:05',0,0,1),(35,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2020-10-19 04:03:30','2020-10-19 02:03:30','2019-11-26 14:27:59',0,0,0),(43,1,0,1,1,1,1,1,1,1,0,1,1,30,'fr',0,0,0,0,1,1,0,'2021-09-23 10:25:51','2021-09-23 08:25:51','2021-09-23 10:25:51',0,0,1),(50,1,0,1,1,1,1,1,1,1,0,1,1,10,'fr',0,0,0,0,1,1,0,'2022-01-03 11:42:56','2022-01-03 10:42:56','2021-12-21 16:21:52',0,0,1),(53,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2020-10-21 16:23:04','2020-10-21 14:23:04','2020-10-21 16:23:04',0,0,1),(54,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2020-11-03 10:40:57','2020-11-03 09:40:57','2020-11-03 10:40:57',0,0,1);
/*!40000 ALTER TABLE `Config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Contact`
--

DROP TABLE IF EXISTS `Contact`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Contact` (
  `ownerID` mediumint unsigned NOT NULL DEFAULT '0',
  `id` char(36) NOT NULL,
  `comments` text,
  `professionalID` mediumint unsigned NOT NULL,
  `officeID` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `status` enum('invitationSent','invitationReceived','accepted','rejected') DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  UNIQUE KEY `unique_contact_pro` (`ownerID`,`professionalID`),
  KEY `fk_Contact_Professionnal` (`ownerID`),
  KEY `fk_Contact_RefersTo` (`professionalID`),
  KEY `fk_Contact_Office` (`officeID`,`ownerID`),
  CONSTRAINT `fk_Contact_Office` FOREIGN KEY (`officeID`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Contact_Professionnal` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Contact_RefersTo` FOREIGN KEY (`professionalID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Contact`
--

LOCK TABLES `Contact` WRITE;
/*!40000 ALTER TABLE `Contact` DISABLE KEYS */;
INSERT INTO `Contact` VALUES (1,'04af87b6-71b0-49c0-a27e-b8268cc01ce0','',31,NULL,NULL,'2021-12-28 10:42:55','2021-12-28 09:42:55','2021-09-13 12:16:30','accepted'),(1,'2e4eeaa8-896b-43c5-a35f-d06db96e108f','',1,NULL,NULL,'2022-01-04 09:53:29','2022-01-04 08:53:29','2019-02-04 15:27:24','accepted'),(1,'3997f1f0-e02d-4e30-a502-ea0ec078d8d1','',6,NULL,NULL,'2020-11-17 10:05:30','2020-11-17 09:05:30','2020-11-17 10:05:30','accepted'),(1,'3e96c479-0236-4fc5-8264-698da150a87d','',19,NULL,NULL,'2019-06-12 18:45:38','2019-06-12 16:45:38','2019-06-12 18:45:38','rejected'),(1,'3ebd2928-4454-4f06-aef5-dfe3f6ee701d','',35,NULL,NULL,'2019-11-26 14:36:42','2019-11-26 13:36:42','2019-11-26 14:30:38','accepted'),(1,'4b2276fc-1159-4a91-89e5-5ee96c136f33','',27,NULL,NULL,'2019-09-09 14:17:39','2019-09-09 12:17:39','2019-09-09 14:17:39','invitationSent'),(1,'540f1c04-3bb6-47f1-ab74-4dbcacc707a7','',17,NULL,NULL,'2021-05-19 09:13:40','2021-05-19 07:13:40','2019-06-12 18:57:41','accepted'),(1,'54ee3e1b-9fb9-4557-a4ac-c3b3e12a4b54','',3,NULL,NULL,'2021-06-09 10:09:49','2021-06-09 08:09:49','2019-06-12 17:47:27','accepted'),(1,'6cf3ef04-2dfb-4131-9613-5433fefcb47e','',50,NULL,NULL,'2022-01-03 15:00:50','2022-01-03 14:00:50','2020-10-12 16:15:22','accepted'),(1,'6ea6aaa4-9b97-4061-ba63-80aaeecc8945','',28,NULL,NULL,'2019-09-09 14:16:51','2019-09-09 12:16:51','2019-09-09 14:16:51','rejected'),(1,'7aac7c2c-9b67-41f6-9a41-54e70fd3be94','',4,NULL,NULL,'2021-05-19 09:13:55','2021-05-19 07:13:55','2019-06-12 17:41:15','accepted'),(1,'7d4a1852-3828-426b-af12-84b2ab2444f4','',29,NULL,NULL,'2020-11-17 10:05:31','2020-11-17 09:05:31','2020-11-17 10:05:31','accepted'),(1,'829dfa85-5738-45e0-aa77-f1a8d790b7fa','',54,NULL,NULL,'2020-11-17 10:05:31','2020-11-17 09:05:31','2020-11-17 10:05:31','accepted'),(1,'a9911f40-6e1f-4abd-80b3-3b022363a048','',20,NULL,NULL,'2019-11-26 14:26:52','2019-11-26 13:26:52','2019-11-26 14:26:52','invitationSent'),(1,'c0718890-dcf4-43d2-9410-f99ef75bb851','',22,NULL,NULL,'2021-09-13 16:12:29','2021-09-13 14:12:29','2019-06-12 18:44:52','accepted'),(1,'c387c3a4-d8ee-4a8d-a2e9-f9a1fe11aba0','',53,NULL,NULL,'2020-10-21 16:38:25','2020-10-21 14:38:25','2020-10-21 16:38:25','accepted'),(1,'ca694a18-d4cc-4262-818d-a1849afbe02f','',21,NULL,NULL,'2019-06-12 18:45:41','2019-06-12 16:45:41','2019-06-12 18:45:41','rejected'),(1,'de630b02-e507-4758-96c1-72fb9c79d9f8','',26,NULL,NULL,'2020-11-17 10:05:31','2020-11-17 09:05:31','2020-11-17 10:05:31','accepted'),(1,'f0bd321c-cf51-4d8f-9350-8dabb4e19065','',43,NULL,NULL,'2022-01-03 15:01:10','2022-01-03 14:01:10','2021-09-13 16:19:18','accepted');
/*!40000 ALTER TABLE `Contact` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ContactNotification`
--

DROP TABLE IF EXISTS `ContactNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ContactNotification` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `contactID` char(36) DEFAULT NULL,
  `rescueDisplayName` varchar(50) DEFAULT NULL,
  `event` enum('received','received_to_accepted','received_to_rejected','sent_to_accepted','sent_to_rejected','activation_timeout') NOT NULL DEFAULT 'received',
  `unread` tinyint(1) NOT NULL DEFAULT '1',
  `createdAt` datetime NOT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_ContactNotification_Professional` (`ownerID`),
  KEY `fk_ContactNotification_Contact` (`contactID`,`ownerID`),
  CONSTRAINT `fk_ContactNotification_Contact` FOREIGN KEY (`contactID`, `ownerID`) REFERENCES `Contact` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_ContactNotification_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ContactNotification`
--

LOCK TABLES `ContactNotification` WRITE;
/*!40000 ALTER TABLE `ContactNotification` DISABLE KEYS */;
INSERT INTO `ContactNotification` VALUES (1,'9089f454-7e29-4d9a-ae9f-0b10d65f3158','c387c3a4-d8ee-4a8d-a2e9-f9a1fe11aba0','Aleck VINCENT','sent_to_accepted',0,'2020-10-21 16:38:25',NULL,'2020-12-01 15:07:39','2020-10-21 16:38:25','2020-12-01 14:07:39'),(1,'bc047057-3bd0-4de3-b8e3-81ddd2e8a704','04af87b6-71b0-49c0-a27e-b8268cc01ce0','LAURENT GRODZKI','received_to_accepted',0,'2021-09-13 12:16:20',NULL,'2021-09-13 12:16:51','2021-09-13 12:16:30','2021-09-13 10:16:51'),(1,'e6ca790a-3554-4ac3-8f15-13f07dcb68f3','f0bd321c-cf51-4d8f-9350-8dabb4e19065','sabine caserta','received_to_accepted',0,'2021-09-13 16:15:55',NULL,'2021-09-13 16:19:18','2021-09-13 16:19:18','2021-09-13 14:19:18');
/*!40000 ALTER TABLE `ContactNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Credentials`
--

DROP TABLE IF EXISTS `Credentials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Credentials` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` mediumint unsigned NOT NULL,
  `login` varchar(64) NOT NULL,
  `password` varchar(1024) NOT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`ownerID`),
  UNIQUE KEY `un_Login` (`login`),
  KEY `fk_Credentials_Professional` (`ownerID`),
  CONSTRAINT `fk_Credentials_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Credentials`
--

LOCK TABLES `Credentials` WRITE;
/*!40000 ALTER TABLE `Credentials` DISABLE KEYS */;
INSERT INTO `Credentials` VALUES (1,1,'j.nave','29a2c02a04ebfb0a366bf2c7b19b97155e8436c3ccb378852224b528fe070d75',NULL,'2022-01-03 15:39:09');
/*!40000 ALTER TABLE `Credentials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Discussion`
--

DROP TABLE IF EXISTS `Discussion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Discussion` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `selfImplied` tinyint(1) NOT NULL DEFAULT '0',
  `officeID` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Discussion_Professional` (`ownerID`),
  KEY `fk_Discussion_Office` (`officeID`,`ownerID`),
  CONSTRAINT `fk_Discussion_Office` FOREIGN KEY (`officeID`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Discussion_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Discussion`
--

LOCK TABLES `Discussion` WRITE;
/*!40000 ALTER TABLE `Discussion` DISABLE KEYS */;
INSERT INTO `Discussion` VALUES (1,'1e220661-7864-4e58-b9a0-adf6a924e40d',0,NULL,NULL,'2019-10-09 11:45:20','2019-10-09 09:45:20','2019-06-12 17:45:31'),(17,'1e220661-7864-4e58-b9a0-adf6a924e40d',0,NULL,NULL,NULL,'2022-01-03 15:39:17','2022-01-03 16:39:17'),(1,'3296fbec-fc91-45de-9488-4f4f7a526b6e',1,NULL,NULL,'2020-03-13 17:20:19','2020-03-13 16:20:19','2019-11-26 14:24:31'),(1,'39edd03b-189b-4cd8-b553-4fa5e59235ec',0,NULL,NULL,'2021-01-04 11:04:13','2021-01-04 10:04:13','2019-04-03 19:51:33'),(3,'39edd03b-189b-4cd8-b553-4fa5e59235ec',0,NULL,NULL,NULL,'2022-01-03 15:39:17','2022-01-03 16:39:17'),(1,'3e3e6088-e3b5-4004-a58f-c314a2dd70b1',0,NULL,NULL,'2019-11-27 17:30:36','2019-11-27 16:30:36','2019-11-26 14:31:21'),(35,'3e3e6088-e3b5-4004-a58f-c314a2dd70b1',0,NULL,NULL,NULL,'2022-01-03 15:39:17','2022-01-03 16:39:17'),(1,'7a6abf78-0493-467d-acf2-d8e624ad83fc',0,NULL,NULL,'2021-09-13 11:25:10','2021-09-13 09:25:10','2019-06-12 18:46:10'),(22,'7a6abf78-0493-467d-acf2-d8e624ad83fc',0,NULL,NULL,NULL,'2022-01-03 15:39:17','2022-01-03 16:39:17'),(1,'82ca34c0-5553-470e-9bed-5b7e9bedc4d9',0,NULL,NULL,'2021-09-13 11:28:01','2021-09-13 09:28:01','2020-10-12 16:15:35'),(50,'82ca34c0-5553-470e-9bed-5b7e9bedc4d9',0,NULL,NULL,NULL,'2022-01-03 15:39:17','2022-01-03 16:39:17'),(1,'b47ae547-86a7-4c5c-b72f-624874f4c8c5',0,NULL,NULL,'2021-09-14 19:05:12','2021-09-14 17:05:12','2021-09-13 12:12:41'),(31,'b47ae547-86a7-4c5c-b72f-624874f4c8c5',0,NULL,NULL,NULL,'2022-01-03 15:39:17','2022-01-03 16:39:17'),(1,'c96239ca-4da5-41fa-b243-e09fcb750abd',0,NULL,NULL,'2020-12-10 10:49:22','2020-12-10 09:49:22','2019-06-12 17:41:36'),(4,'c96239ca-4da5-41fa-b243-e09fcb750abd',0,NULL,NULL,NULL,'2022-01-03 15:39:17','2022-01-03 16:39:17'),(1,'d3abcf6c-a9db-4e4d-8828-5653ef9c3d86',0,NULL,NULL,'2021-09-13 16:22:07','2021-09-13 14:22:07','2021-09-13 16:19:30'),(43,'d3abcf6c-a9db-4e4d-8828-5653ef9c3d86',0,NULL,NULL,NULL,'2022-01-03 15:39:17','2022-01-03 16:39:17');
/*!40000 ALTER TABLE `Discussion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Licence`
--

DROP TABLE IF EXISTS `Licence`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Licence` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `reference` varchar(45) DEFAULT NULL,
  `installKey` varchar(45) DEFAULT NULL,
  `activationDate` datetime DEFAULT NULL,
  `professionalID` mediumint unsigned NOT NULL,
  `cameraReference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`,`professionalID`),
  KEY `fk_Licence_Professional` (`professionalID`),
  CONSTRAINT `fk_Licence_Professional` FOREIGN KEY (`professionalID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Licence`
--

LOCK TABLES `Licence` WRITE;
/*!40000 ALTER TABLE `Licence` DISABLE KEYS */;
/*!40000 ALTER TABLE `Licence` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `MessageStatus`
--

DROP TABLE IF EXISTS `MessageStatus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `MessageStatus` (
  `ownerID` mediumint unsigned NOT NULL,
  `sentMessageID` char(36) NOT NULL,
  `contactID` char(36) NOT NULL,
  `status` enum('undelivered','delivered','transmitted') NOT NULL DEFAULT 'undelivered',
  `bcc` tinyint(1) NOT NULL DEFAULT '0',
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`sentMessageID`,`contactID`),
  KEY `fk_MessageStatus_SentMessage` (`sentMessageID`,`ownerID`),
  KEY `fk_MessageStatus_Contact` (`contactID`,`ownerID`),
  CONSTRAINT `fk_MessageStatus_Contact` FOREIGN KEY (`contactID`, `ownerID`) REFERENCES `Contact` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_MessageStatus_SentMessage` FOREIGN KEY (`sentMessageID`, `ownerID`) REFERENCES `SentMessage` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `MessageStatus`
--

LOCK TABLES `MessageStatus` WRITE;
/*!40000 ALTER TABLE `MessageStatus` DISABLE KEYS */;
INSERT INTO `MessageStatus` VALUES (1,'0c942d7a-6fb5-43cf-a802-052c7f80b387','54ee3e1b-9fb9-4557-a4ac-c3b3e12a4b54','transmitted',0,'2019-06-12 15:49:22'),(1,'0e05e910-0cc5-4fd4-96f1-d4e298ccbc4c','7aac7c2c-9b67-41f6-9a41-54e70fd3be94','transmitted',0,'2020-12-10 09:47:46'),(1,'101339aa-86de-4fb3-adae-6dc44fdd8d61','7aac7c2c-9b67-41f6-9a41-54e70fd3be94','transmitted',0,'2019-08-29 10:17:45'),(1,'108c3067-e2b8-4fe8-b145-2b3155e7e15a','6cf3ef04-2dfb-4131-9613-5433fefcb47e','transmitted',0,'2020-12-01 14:05:16'),(1,'1502d93c-a9fa-4096-979b-eceaac0502e6','54ee3e1b-9fb9-4557-a4ac-c3b3e12a4b54','transmitted',0,'2019-04-03 09:48:42'),(1,'16a21a42-d5a2-4370-9391-68a30516601b','54ee3e1b-9fb9-4557-a4ac-c3b3e12a4b54','transmitted',0,'2021-01-04 10:04:11'),(1,'288e6127-d407-407a-9284-fb09da7d5193','c0718890-dcf4-43d2-9410-f99ef75bb851','transmitted',0,'2021-08-24 08:37:06'),(1,'392b0c89-9c7f-47e2-938a-752c926b6b25','04af87b6-71b0-49c0-a27e-b8268cc01ce0','transmitted',0,'2021-09-13 10:12:43'),(1,'3fe5199e-6ffe-4ea8-a795-b9aeca9e1800','2e4eeaa8-896b-43c5-a35f-d06db96e108f','transmitted',0,'2020-03-11 13:47:19'),(1,'5a31b6fe-83ec-4b7c-88c2-66801ebc08f9','04af87b6-71b0-49c0-a27e-b8268cc01ce0','transmitted',0,'2021-09-14 17:05:12'),(1,'5a6f6f6e-b8b2-4b64-8ffd-89fca24060c6','c0718890-dcf4-43d2-9410-f99ef75bb851','delivered',0,'2021-09-13 09:22:42'),(1,'5b9d7ac8-d6f0-4ad6-b793-485d935a67e2','3ebd2928-4454-4f06-aef5-dfe3f6ee701d','transmitted',0,'2019-11-27 07:00:28'),(1,'6824c1c5-373b-4a49-93cf-4cba69bffc5e','6cf3ef04-2dfb-4131-9613-5433fefcb47e','transmitted',0,'2020-12-01 14:05:54'),(1,'6a85852a-9d31-4863-b5ba-c2095a5a6774','54ee3e1b-9fb9-4557-a4ac-c3b3e12a4b54','transmitted',0,'2019-05-22 15:38:49'),(1,'6c1effc4-83b4-4434-afc2-2aafa42842e5','3ebd2928-4454-4f06-aef5-dfe3f6ee701d','transmitted',0,'2019-11-27 07:00:28'),(1,'6c5d43c3-7a19-47fe-b855-2759fb64f716','3ebd2928-4454-4f06-aef5-dfe3f6ee701d','transmitted',0,'2019-11-26 14:24:39'),(1,'721e0966-27f8-4c91-a6ee-4da1e5e5f3e3','c0718890-dcf4-43d2-9410-f99ef75bb851','delivered',0,'2021-09-13 09:25:10'),(1,'752bf1c7-b7e4-4e36-bbf0-27f02064f3ba','2e4eeaa8-896b-43c5-a35f-d06db96e108f','transmitted',0,'2019-11-26 13:24:34'),(1,'7840af82-ad7b-4086-8e4b-54f75f073c07','54ee3e1b-9fb9-4557-a4ac-c3b3e12a4b54','transmitted',0,'2019-06-12 16:47:51'),(1,'8367b46f-0354-4dd1-9505-02911509cf14','6cf3ef04-2dfb-4131-9613-5433fefcb47e','transmitted',0,'2021-09-13 09:25:50'),(1,'87b19da2-e3b9-4859-8d9f-7ba3791adc02','3ebd2928-4454-4f06-aef5-dfe3f6ee701d','transmitted',0,'2019-11-27 07:00:28'),(1,'9f145309-dee9-44f1-8623-48d461ba64df','3ebd2928-4454-4f06-aef5-dfe3f6ee701d','delivered',0,'2019-11-27 16:30:36'),(1,'a12a1f66-85ad-4891-ae0c-f17e464c1943','3ebd2928-4454-4f06-aef5-dfe3f6ee701d','transmitted',0,'2019-11-26 14:04:32'),(1,'aaa2e4aa-2659-44b3-9721-2396faa915c0','54ee3e1b-9fb9-4557-a4ac-c3b3e12a4b54','transmitted',0,'2019-06-12 15:43:06'),(1,'b2b86dff-18bc-4daa-a2a4-be2967a12db6','540f1c04-3bb6-47f1-ab74-4dbcacc707a7','transmitted',0,'2019-06-13 07:26:22'),(1,'bc9b9a32-0036-413c-af6e-db94d08209ac','c0718890-dcf4-43d2-9410-f99ef75bb851','delivered',0,'2021-09-13 09:21:32'),(1,'bed2294b-041c-4b05-8e6c-022f3aeda7c5','54ee3e1b-9fb9-4557-a4ac-c3b3e12a4b54','transmitted',0,'2020-08-26 08:35:54'),(1,'c08ba604-d58d-46c2-8c14-c0acdce96582','7aac7c2c-9b67-41f6-9a41-54e70fd3be94','transmitted',0,'2019-08-29 10:17:45'),(1,'c1d2fc8a-7720-4738-9cb2-b32ddff28fd9','3ebd2928-4454-4f06-aef5-dfe3f6ee701d','transmitted',0,'2019-11-26 13:32:51'),(1,'c1d963ee-f382-40a7-939a-6344da7bd4fe','6cf3ef04-2dfb-4131-9613-5433fefcb47e','transmitted',0,'2020-12-10 15:44:12'),(1,'c34660b3-a141-4805-8f88-75295495458c','c0718890-dcf4-43d2-9410-f99ef75bb851','transmitted',0,'2021-08-24 08:37:06'),(1,'c627fb8b-46e5-4641-af94-1ae862082418','540f1c04-3bb6-47f1-ab74-4dbcacc707a7','transmitted',0,'2019-10-09 09:45:20'),(1,'c76d36b3-d2a5-419c-afd9-92c99e87e37b','3ebd2928-4454-4f06-aef5-dfe3f6ee701d','transmitted',0,'2019-11-26 15:54:23'),(1,'ded925c9-f5a3-49b1-a6f1-34630f63ba03','3ebd2928-4454-4f06-aef5-dfe3f6ee701d','transmitted',0,'2019-11-27 07:00:28'),(1,'eb124025-4abd-4b5e-b00e-91ea9bdb8a75','54ee3e1b-9fb9-4557-a4ac-c3b3e12a4b54','transmitted',0,'2019-06-06 08:27:57'),(1,'eebae158-466f-45dc-9779-e26080aa156b','54ee3e1b-9fb9-4557-a4ac-c3b3e12a4b54','transmitted',0,'2019-06-12 16:47:51'),(1,'fa2449a7-de33-4026-aa63-d3575a79e2d8','54ee3e1b-9fb9-4557-a4ac-c3b3e12a4b54','transmitted',0,'2021-01-04 10:04:11'),(1,'fef5bd39-4ccd-4ca3-bc6f-4c35e61cdafc','c0718890-dcf4-43d2-9410-f99ef75bb851','transmitted',0,'2021-08-24 08:37:06'),(1,'ffda89b0-5657-457b-8b38-c1326dca740c','3ebd2928-4454-4f06-aef5-dfe3f6ee701d','transmitted',0,'2019-11-26 13:31:35');
/*!40000 ALTER TABLE `MessageStatus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Occlusion`
--

DROP TABLE IF EXISTS `Occlusion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Occlusion` (
  `ownerID` mediumint unsigned NOT NULL DEFAULT '0',
  `id` char(36) NOT NULL,
  `sessionID` char(36) DEFAULT NULL,
  `occlusionType` enum('UNKNOWN','HEMI_ARCADE_POSTERIEUR_DROIT','HEMI_ARCADE_POSTERIEUR_GAUCHE','HEMI_ARCADE_ANTERIEUR','ARCADE_COMPLETE_ANTERIEUR','ARCADE_COMPLETE') DEFAULT 'HEMI_ARCADE_POSTERIEUR_DROIT',
  `deletedAt` datetime DEFAULT NULL,
  `createdAt` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `topScanID` char(36) DEFAULT NULL,
  `bottomScanID` char(36) DEFAULT NULL,
  `anteriorBiteScanID` char(36) DEFAULT NULL,
  `rightBiteScanID` char(36) DEFAULT NULL,
  `leftBiteScanID` char(36) DEFAULT NULL,
  `snapshotID` char(36) DEFAULT NULL,
  `mandibuleOcclusionPlyID` char(36) DEFAULT NULL,
  `maxillaireOcclusionPlyID` char(36) DEFAULT NULL,
  `matrixTransformationMandibuleID` char(36) DEFAULT NULL,
  `matrixTransformationMaxillaireID` char(36) DEFAULT NULL,
  `globalDisplayID` mediumint unsigned DEFAULT NULL,
  `displayID` mediumint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Occlusion_Session` (`sessionID`,`ownerID`),
  KEY `fk_Occlusion_topScan` (`topScanID`,`ownerID`),
  KEY `fk_Occlusion_bottomScan` (`bottomScanID`,`ownerID`),
  KEY `fk_Occlusion_anteriorBiteScanID` (`anteriorBiteScanID`,`ownerID`),
  KEY `fk_Occlusion_rightBiteScanID` (`rightBiteScanID`,`ownerID`),
  KEY `fk_Occlusion_leftBiteScanID` (`leftBiteScanID`,`ownerID`),
  KEY `fk_Occlusion_CondorFile_snapshot` (`snapshotID`,`ownerID`),
  KEY `fk_Occlusion_CondorFile_mandibulePly` (`mandibuleOcclusionPlyID`,`ownerID`),
  KEY `fk_Occlusion_CondorFile_matrixTransformationMandibule` (`matrixTransformationMandibuleID`,`ownerID`),
  KEY `fk_Occlusion_CondorFile_maxillairePly` (`maxillaireOcclusionPlyID`,`ownerID`),
  KEY `fk_Occlusion_CondorFile_matrixTransformationMaxillaire` (`matrixTransformationMaxillaireID`,`ownerID`),
  CONSTRAINT `fk_Occlusion_anteriorBiteScanID` FOREIGN KEY (`anteriorBiteScanID`, `ownerID`) REFERENCES `Scan` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_bottomScan` FOREIGN KEY (`bottomScanID`, `ownerID`) REFERENCES `Scan` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_CondorFile_mandibulePly` FOREIGN KEY (`mandibuleOcclusionPlyID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_CondorFile_matrixTransformationMandibule` FOREIGN KEY (`matrixTransformationMandibuleID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_CondorFile_matrixTransformationMaxillaire` FOREIGN KEY (`matrixTransformationMaxillaireID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_CondorFile_maxillairePly` FOREIGN KEY (`maxillaireOcclusionPlyID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_CondorFile_snapshot` FOREIGN KEY (`snapshotID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_leftBiteScanID` FOREIGN KEY (`leftBiteScanID`, `ownerID`) REFERENCES `Scan` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_rightBiteScanID` FOREIGN KEY (`rightBiteScanID`, `ownerID`) REFERENCES `Scan` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_Session` FOREIGN KEY (`sessionID`, `ownerID`) REFERENCES `Session` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_topScan` FOREIGN KEY (`topScanID`, `ownerID`) REFERENCES `Scan` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Occlusion`
--

LOCK TABLES `Occlusion` WRITE;
/*!40000 ALTER TABLE `Occlusion` DISABLE KEYS */;
/*!40000 ALTER TABLE `Occlusion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `OcclusionFile`
--

DROP TABLE IF EXISTS `OcclusionFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `OcclusionFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `fileID` char(36) NOT NULL,
  `occlusionID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `occlusionType` enum('OCCLUSION_RESULT','MANDIBULE_PLY','MAXILLAIRE_PLY','LEFT_BITE','RIGHT_BITE','ANTERIOR_BITE','SCREENSHOT','LIFI','MANDIBULE_MATRIX','MAXILLAIRE_MATRIX') DEFAULT 'OCCLUSION_RESULT',
  PRIMARY KEY (`fileID`,`occlusionID`,`ownerID`),
  KEY `fk_OcclusionFile_CondorFile` (`fileID`,`ownerID`),
  KEY `fk_OcclusionFile_Occlusion` (`occlusionID`,`ownerID`),
  CONSTRAINT `fk_OcclusionFile_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_OcclusionFile_Occlusion` FOREIGN KEY (`occlusionID`, `ownerID`) REFERENCES `Occlusion` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `OcclusionFile`
--

LOCK TABLES `OcclusionFile` WRITE;
/*!40000 ALTER TABLE `OcclusionFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `OcclusionFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Office`
--

DROP TABLE IF EXISTS `Office`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Office` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `mainPhone` varchar(45) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `cityName` varchar(255) DEFAULT NULL,
  `cityZip` varchar(25) DEFAULT NULL,
  `address` text,
  `country` varchar(75) DEFAULT NULL,
  `reassignedTo` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Office_Professional_idx` (`ownerID`),
  KEY `fk_Office_Office_reassignedTo` (`reassignedTo`,`ownerID`),
  CONSTRAINT `fk_Office_Office_reassignedTo` FOREIGN KEY (`reassignedTo`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Office_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Office`
--

LOCK TABLES `Office` WRITE;
/*!40000 ALTER TABLE `Office` DISABLE KEYS */;
INSERT INTO `Office` VALUES (26,'056e7425-4d30-4be5-b405-714399817608','0664143389','Cabinet (default)','','MERIGNAC','','','France',NULL,NULL,'2019-07-22 17:42:44','2019-07-22 15:42:44','2019-07-22 16:58:50'),(54,'06c4c19f-4e77-42b6-99bd-13dab736c32f','0479261566','Cabinet (default)','','CHAMBERY','','','France',NULL,NULL,'2020-11-03 11:02:47','2020-11-03 10:02:47','2020-11-03 10:40:57'),(6,'14f3c437-6582-44b9-b00e-4dbc844bb8cc','0669985229','LABORATOIRE LDA','www.laboratoirelda.com','Villiers sur marne','94350','1 RUE DE LA FRATERNITE','France',NULL,NULL,'2019-06-13 07:58:13','2019-06-13 05:58:13','2019-06-13 07:58:13'),(1,'1d091bc1-ae93-4de0-8911-77bbe17ed20b','0908070605','Couanouz Dental','','Labege','31670','Condor Labge','France',NULL,NULL,'2020-10-21 15:33:11','2020-10-21 13:33:11','2019-02-04 15:27:24'),(29,'25f378dd-6737-4dfa-b38f-52e39737a0b3','0664864059','Cabinet (default)','','MERIGNAC','','','France',NULL,NULL,'2019-08-29 18:20:47','2019-08-29 16:20:47','2019-08-29 12:18:04'),(28,'45cce63a-ce19-40c0-966a-1d92cca4ed58','','Cabinet (default)','','','','','',NULL,NULL,'2019-08-07 15:23:31','2019-08-07 13:23:31','2019-08-07 15:23:31'),(4,'46ced030-be32-4f07-9d0f-59f8f4b3ce01','598745632','LabegeTest','','labege','31670','137 rue garance','France',NULL,NULL,'2019-02-11 09:22:17','2019-02-11 08:22:17','2019-02-11 09:22:17'),(19,'5553fdc9-9cbd-4af8-975b-19dbdf73b27c','','Cabinet (default)','','','','','',NULL,NULL,'2019-06-12 18:19:39','2019-06-12 16:19:39','2019-06-12 18:19:39'),(50,'700f6658-a9a2-4f83-ae8e-ad1a1047ba87','645636587','caserta','','salles d\'aude','11110','17, av de Fleury','France',NULL,NULL,'2020-09-16 10:10:26','2020-09-16 08:10:26','2020-09-16 10:10:26'),(31,'74b0555b-54eb-4bb8-8a8f-5e92f90f6337','616753215','BDRI','','TRAMOYES','01390','89 rue du Marquis de Sallmard','France',NULL,NULL,'2021-11-10 10:46:59','2021-11-10 09:46:59','2019-11-12 09:51:58'),(20,'87a517ee-caa4-4821-b421-f74200cce3aa','','Cabinet (default)','','','','','',NULL,NULL,'2019-06-12 18:34:57','2019-06-12 16:34:57','2019-06-12 18:34:57'),(22,'8ba92b66-de90-4606-80f5-eb969b1bbadc','0645024712','Cabinet (default)','','Toulouse','','','France',NULL,NULL,'2019-06-12 18:44:40','2019-06-12 16:44:40','2019-06-12 18:43:13'),(27,'972e0f85-280d-4833-986e-1997910baa56','','Cabinet (default)','','','','','',NULL,NULL,'2019-08-06 15:04:19','2019-08-06 13:04:19','2019-08-06 15:04:19'),(21,'9769cb91-54ba-4ca1-b264-0ad4489bc2f2','','Cabinet (default)','','','','','',NULL,NULL,'2019-06-12 18:37:27','2019-06-12 16:37:27','2019-06-12 18:37:27'),(3,'ac68e062-943b-4575-94ff-74a0ce14e003','5123456789','Labege','','Labège','31670','137 rue garance','France',NULL,NULL,'2020-11-03 10:33:04','2020-11-03 09:33:04','2019-02-11 09:11:43'),(35,'aed962f3-8689-41bc-8569-4380681f2d76','0645024712','Cabinet (default)','','Toulouse','','','France',NULL,NULL,'2019-11-26 14:29:29','2019-11-26 13:29:29','2019-11-26 14:27:59'),(17,'bc48fce4-e3a6-495f-8199-024209ef58a3','0674342369','Cabinet (default)','','Toulouse - Labege','','scan4all','France',NULL,NULL,'2020-09-23 18:18:26','2020-09-23 16:18:26','2020-09-23 18:18:26'),(43,'c30af8aa-6b73-4f9d-ab27-d95be7a1de78','0645636587','maison','','Salles d\'Aude','11110','avenue de Fleury','France',NULL,NULL,'2020-01-30 10:23:49','2020-01-30 09:23:49','2020-01-30 10:23:49'),(53,'c4d3308d-a7dd-4c37-a26d-e0498342b171','0659135332','Cabinet (default)','','Toulouse','','','France',NULL,NULL,'2020-10-21 16:37:51','2020-10-21 14:37:51','2020-10-21 16:23:04');
/*!40000 ALTER TABLE `Office` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `Office_BEFORE_DELETE` BEFORE DELETE ON `Office` FOR EACH ROW BEGIN		
  UPDATE Assistant SET officeID = NULL 
  WHERE ownerID = OLD.ownerID AND officeID = OLD.id;

  UPDATE Contact SET officeID = NULL 
  WHERE ownerID = OLD.ownerID AND officeID = OLD.id;

  UPDATE Discussion SET officeID = NULL 
  WHERE ownerID = OLD.ownerID AND officeID = OLD.id;

  UPDATE Patient SET officeID = NULL 
  WHERE ownerID = OLD.ownerID AND officeID = OLD.id;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `PersonInfo`
--

DROP TABLE IF EXISTS `PersonInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PersonInfo` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `firstName` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `sex` enum('M','F') DEFAULT NULL,
  `birthDate` date DEFAULT NULL,
  `salutation` varchar(45) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `picturePath` varchar(255) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_PersonInfo_Professional` (`ownerID`),
  CONSTRAINT `fk_PersonInfo_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PersonInfo`
--

LOCK TABLES `PersonInfo` WRITE;
/*!40000 ALTER TABLE `PersonInfo` DISABLE KEYS */;
INSERT INTO `PersonInfo` VALUES (1,1,'John','Couanouz','jonathan.nave@condorscan.pro','',NULL,'','','',NULL,NULL,'2021-04-01 12:11:38'),(3,1,'Chapuzot','Julien','julien.chapuzot@jc2l.fr','',NULL,'','','',NULL,NULL,'2020-11-30 14:40:38'),(4,1,'condor','labege','julien.chapuzot@jc2l.fr','',NULL,'','','',NULL,NULL,'2019-02-11 08:22:17'),(6,1,'Jeff','Farbiarz','cfao@laboratoirelda.com','',NULL,'','','',NULL,NULL,'2019-02-14 16:21:05'),(17,1,'veronique','Querbes','veronique.querbes@condorscan.pro','',NULL,'','','',NULL,NULL,'2019-04-30 07:42:46'),(19,1,'','','thomas.besson@condorscan.pro','',NULL,'','','',NULL,NULL,'2019-06-12 16:19:39'),(20,1,'','','john@couanouz.net','',NULL,'','','',NULL,NULL,'2019-06-12 16:34:57'),(21,1,'','','buy@couanouz.net','',NULL,'','','',NULL,NULL,'2019-06-12 16:37:27'),(22,1,'jonathan','nave','jonathan.nave@couanouz.net','',NULL,'','','',NULL,NULL,'2019-06-12 16:44:40'),(26,1,'LABEL DENT','LABORATOIRE','label.dent@orange.fr','',NULL,'','','',NULL,NULL,'2019-07-22 15:42:44'),(27,1,'','','muriel.limondin@condorscan.pro','',NULL,'','','',NULL,NULL,'2019-08-06 13:04:19'),(28,1,'','','muriel.limondin@outlook.fr','',NULL,'','','',NULL,NULL,'2019-08-07 13:23:31'),(29,1,'DENTAL CUB','LABORATOIRE','cfao@dentalcub.fr','',NULL,'','','',NULL,NULL,'2019-08-29 16:20:47'),(31,1,'LAURENT','GRODZKI','l.grodzki@biotech-dental.com','',NULL,'','','',NULL,NULL,'2019-11-12 08:51:58'),(35,1,'Couanouz','Poubelle','poubelle@couanouz.net','',NULL,'','','',NULL,NULL,'2019-11-26 13:29:29'),(43,1,'sabine','caserta','sabine.caserta@scan4all.fr','',NULL,'','','',NULL,NULL,'2020-11-13 15:33:22'),(50,1,'sab','caserta','sabinecaserta@live.fr','',NULL,'','','',NULL,NULL,'2021-05-11 13:45:27'),(53,1,'Aleck','VINCENT','aleck.vincent@scan4all.fr','',NULL,'','','',NULL,NULL,'2020-10-21 14:37:51'),(54,1,'BY AXE ORTHO','SMILERS LAB','axe-ortho@outlook.fr','',NULL,'','','',NULL,NULL,'2020-11-03 10:02:47');
/*!40000 ALTER TABLE `PersonInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PhoneInfo`
--

DROP TABLE IF EXISTS `PhoneInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PhoneInfo` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `mainPhone` varchar(45) DEFAULT NULL,
  `cellular` varchar(45) DEFAULT NULL,
  `fax` varchar(45) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_PhoneInfo_Professional` (`ownerID`),
  CONSTRAINT `fk_PhoneInfo_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PhoneInfo`
--

LOCK TABLES `PhoneInfo` WRITE;
/*!40000 ALTER TABLE `PhoneInfo` DISABLE KEYS */;
INSERT INTO `PhoneInfo` VALUES (1,1,'0908070605','','',NULL,NULL,'2021-04-01 12:11:38'),(3,1,'5123456789','','',NULL,NULL,'2019-02-11 08:11:43'),(4,1,'598745632','','',NULL,NULL,'2019-02-11 08:22:16'),(6,1,'0669985229','','',NULL,NULL,'2019-02-14 16:21:05'),(17,1,'0674342369','','',NULL,NULL,'2019-04-30 07:42:46'),(19,1,'','','',NULL,NULL,'2019-06-12 16:19:39'),(20,1,'','','',NULL,NULL,'2019-06-12 16:34:57'),(21,1,'','','',NULL,NULL,'2019-06-12 16:37:27'),(22,1,'0645024712','','',NULL,NULL,'2019-06-12 16:44:40'),(26,1,'0664143389','','',NULL,NULL,'2019-07-22 15:42:44'),(27,1,'','','',NULL,NULL,'2019-08-06 13:04:19'),(28,1,'','','',NULL,NULL,'2019-08-07 13:23:31'),(29,1,'0664864059','','',NULL,NULL,'2019-08-29 16:20:47'),(31,1,'616753215','','',NULL,NULL,'2019-11-12 08:51:57'),(35,1,'0645024712','','',NULL,NULL,'2019-11-26 13:29:29'),(43,1,'0645636587','','',NULL,NULL,'2020-01-30 09:23:49'),(50,1,'645636587','','',NULL,NULL,'2020-09-16 08:10:25'),(53,1,'0659135332','','',NULL,NULL,'2020-10-21 14:37:51'),(54,1,'0479261566','','',NULL,NULL,'2020-11-03 10:02:47');
/*!40000 ALTER TABLE `PhoneInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Professional`
--

DROP TABLE IF EXISTS `Professional`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Professional` (
  `id` mediumint unsigned NOT NULL,
  `UUID` char(36) NOT NULL,
  `credentialsID` mediumint unsigned DEFAULT NULL,
  `comments` text,
  `status` enum('created','confirmed') NOT NULL DEFAULT 'created',
  `accessCode` varchar(45) DEFAULT NULL,
  `personInfoID` mediumint unsigned DEFAULT NULL,
  `phoneInfoID` mediumint unsigned DEFAULT NULL,
  `addressInfoID` mediumint unsigned DEFAULT NULL,
  `configID` mediumint unsigned DEFAULT NULL,
  `syncInfoID` mediumint unsigned DEFAULT NULL,
  `surgeryName` varchar(255) DEFAULT NULL,
  `type` enum('Undefined','Prothesist','Dentist','Demo','Other') NOT NULL DEFAULT 'Undefined',
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastConnection` timestamp NULL DEFAULT NULL,
  `lastConnectionChecked` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `limitedContactID` char(36) DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `directoryVisible` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `fk_Professional_Credentials` (`credentialsID`,`id`),
  KEY `fk_Professional_PersonInfo` (`personInfoID`,`id`),
  KEY `fk_Professional_PhoneInfo` (`phoneInfoID`,`id`),
  KEY `fk_Professional_AddressInfo` (`addressInfoID`,`id`),
  KEY `fk_Professional_Config` (`configID`,`id`),
  KEY `fk_Professional_SyncInfo` (`syncInfoID`,`id`),
  CONSTRAINT `fk_Professional_AddressInfo` FOREIGN KEY (`addressInfoID`, `id`) REFERENCES `AddressInfo` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Professional_Config` FOREIGN KEY (`configID`, `id`) REFERENCES `Config` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Professional_Credentials` FOREIGN KEY (`credentialsID`, `id`) REFERENCES `Credentials` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Professional_PersonInfo` FOREIGN KEY (`personInfoID`, `id`) REFERENCES `PersonInfo` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Professional_PhoneInfo` FOREIGN KEY (`phoneInfoID`, `id`) REFERENCES `PhoneInfo` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Professional_SyncInfo` FOREIGN KEY (`syncInfoID`, `id`) REFERENCES `SyncInfo` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Professional`
--

LOCK TABLES `Professional` WRITE;
/*!40000 ALTER TABLE `Professional` DISABLE KEYS */;
INSERT INTO `Professional` VALUES (1,'1ac0d2f9-8c99-4537-8eec-18a05630ecb2',1,'','confirmed',NULL,1,1,1,1,1,'','Dentist',NULL,'2022-01-04 09:53:39',NULL,'2022-01-03 15:39:09','2022-01-04 08:53:39',NULL,'2022-01-03 16:39:09',1),(3,'5cca24cf-3a0b-4d63-b0d3-30b81c4dadf0',NULL,'','confirmed',NULL,1,1,1,1,1,'','Prothesist',NULL,'2021-06-09 10:09:49',NULL,NULL,'2022-01-03 15:39:11',NULL,'2020-11-30 15:40:38',1),(4,'40cc281a-be8c-42a1-b93b-84cdb8bf8ab6',NULL,'','confirmed',NULL,1,1,1,1,1,'','Dentist',NULL,'2021-05-19 09:13:55',NULL,NULL,'2022-01-03 15:39:11',NULL,'2019-08-29 12:17:44',1),(6,'f609877c-97ba-4492-b9d6-fb60b0fede74',NULL,'','confirmed',NULL,1,1,1,1,1,'','Other',NULL,'2020-07-16 09:38:35',NULL,NULL,'2022-01-03 15:39:10',NULL,'2019-02-12 15:44:07',1),(17,'90fd5c69-6739-473b-82b2-f4454a783e3a',NULL,'','confirmed',NULL,1,1,1,1,1,'','Other',NULL,'2021-05-19 09:13:40',NULL,NULL,'2022-01-03 15:39:11',NULL,'2019-04-30 09:28:19',1),(19,'e253dfa5-5a63-4937-8f67-55855a88ad7b',NULL,'','created','9095dc15',1,1,1,1,1,'','Other',NULL,'2019-06-12 18:19:39',NULL,NULL,'2022-01-03 15:39:15',NULL,'2019-06-12 18:19:39',1),(20,'ef59c7ab-354e-4d95-b857-9b16018aabfa',NULL,'','created','e216875e',1,1,1,1,1,'','Other',NULL,'2019-06-12 18:34:58',NULL,NULL,'2022-01-03 15:39:16',NULL,'2019-06-12 18:34:57',1),(21,'ebbb0359-1eb8-4463-8aac-12761da6f0a2',NULL,'','created','d4353108',1,1,1,1,1,'','Other',NULL,'2019-06-12 18:37:27',NULL,NULL,'2022-01-03 15:39:16',NULL,'2019-06-12 18:37:27',1),(22,'c1ede782-ed8f-4aaf-8ff8-10c1de71a2bb',NULL,'','confirmed',NULL,1,1,1,1,1,'','Other',NULL,'2021-09-13 16:12:29',NULL,NULL,'2022-01-03 15:39:11',NULL,'2019-06-12 18:43:13',1),(26,'97530b9f-ee28-4a36-9a28-c1cc3f091933',NULL,'','confirmed',NULL,1,1,1,1,1,'','Undefined',NULL,'2020-09-22 16:57:05',NULL,NULL,'2022-01-03 15:39:11',NULL,'2019-07-22 16:58:50',1),(27,'0bd2d1d6-d0b0-4f4c-8475-974919f4e71a',NULL,'','created','ce34ae5b',1,1,1,1,1,'','Undefined',NULL,'2020-04-29 16:46:01',NULL,NULL,'2022-01-03 15:39:58',NULL,'2019-08-06 15:04:19',1),(28,'64d853c2-04db-44e0-8e0a-57555b49e8cc',NULL,'','created','bf364705',1,1,1,1,1,'','Undefined',NULL,'2020-04-29 16:46:01',NULL,NULL,'2022-01-03 15:39:16',NULL,'2019-08-07 15:23:31',1),(29,'5fa43384-772e-4d75-9cba-01e24464fb95',NULL,'','confirmed',NULL,1,1,1,1,1,'','Prothesist',NULL,'2020-09-22 16:57:19',NULL,NULL,'2022-01-03 15:39:11',NULL,'2019-08-29 12:18:04',1),(31,'e88a0467-9776-4e7e-84de-ae72644fd063',NULL,'','confirmed',NULL,1,1,1,1,1,'','Dentist',NULL,'2021-12-28 10:42:55',NULL,NULL,'2022-01-03 15:39:11',NULL,'2021-12-28 10:23:34',1),(35,'f19b0c47-467b-426e-8d13-0b7d610180a8',NULL,'','confirmed',NULL,1,1,1,1,1,'','Undefined',NULL,'2020-04-29 16:46:01',NULL,NULL,'2022-01-03 15:39:10',NULL,'2019-11-26 14:27:59',1),(43,'bc3e2d0a-26aa-48be-b468-e19f6eb834ca',NULL,'','confirmed',NULL,1,1,1,1,1,'','Dentist',NULL,'2022-01-03 15:01:10',NULL,NULL,'2022-01-03 15:39:26',NULL,'2022-01-03 15:01:06',1),(50,'f381d7d1-a7cc-44dc-9823-7906cbfc5557',NULL,'','confirmed',NULL,1,1,1,1,1,'','Dentist',NULL,'2022-01-03 15:00:50',NULL,NULL,'2022-01-03 15:39:11',NULL,'2022-01-03 15:00:09',1),(53,'e84ad521-9264-4e2d-b45c-3529640c5a75',NULL,'','confirmed',NULL,1,1,1,1,1,'','Undefined',NULL,'2020-10-21 16:37:58',NULL,NULL,'2022-01-03 15:39:10',NULL,'2020-10-21 16:23:04',1),(54,'f2d04ec3-0682-4e47-9628-907da095f4b6',NULL,'','confirmed',NULL,1,1,1,1,1,'','Undefined',NULL,'2020-11-03 11:03:03',NULL,NULL,'2022-01-03 15:39:11',NULL,'2020-11-03 10:40:57',1);
/*!40000 ALTER TABLE `Professional` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProfessionalPatient`
--

DROP TABLE IF EXISTS `ProfessionalPatient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProfessionalPatient` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `ownerID` mediumint unsigned NOT NULL DEFAULT '0',
  `patientID` char(36) DEFAULT NULL,
  `officeID` char(36) DEFAULT NULL,
  `enablePatientSharing` tinyint(1) DEFAULT '0',
  `pinned` tinyint(1) NOT NULL DEFAULT '0',
  `theme` enum('NONE','ADULT','BOY','GIRL','BABY') DEFAULT 'NONE',
  PRIMARY KEY (`id`),
  KEY `unique_Patient_Pro` (`ownerID`,`patientID`),
  CONSTRAINT `fk_Patient_Pro` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProfessionalPatient`
--

LOCK TABLES `ProfessionalPatient` WRITE;
/*!40000 ALTER TABLE `ProfessionalPatient` DISABLE KEYS */;
INSERT INTO `ProfessionalPatient` VALUES (1,1,'7e877e30-84fb-4571-8971-9362793c192c','1d091bc1-ae93-4de0-8911-77bbe17ed20b',0,0,'NONE');
/*!40000 ALTER TABLE `ProfessionalPatient` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrder`
--

DROP TABLE IF EXISTS `ProstheticOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticOrder` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `currentDeliveryDate` datetime DEFAULT NULL,
  `previousDeliveryDate` datetime DEFAULT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `title` varchar(64) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `status` enum('not_sent','sent','date_validated','date_edited','validated','cancelled') NOT NULL DEFAULT 'sent',
  `unread` tinyint(1) DEFAULT '0',
  `createdAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `actID` char(36) NOT NULL,
  `localDisplayID` mediumint unsigned DEFAULT NULL,
  `globalDisplayID` mediumint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `idx_Order_Work` (`ownerID`),
  KEY `fk_Order_Act` (`actID`,`ownerID`),
  CONSTRAINT `fk_Order_Act` FOREIGN KEY (`actID`, `ownerID`) REFERENCES `Act` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrder`
--

LOCK TABLES `ProstheticOrder` WRITE;
/*!40000 ALTER TABLE `ProstheticOrder` DISABLE KEYS */;
/*!40000 ALTER TABLE `ProstheticOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrderFile`
--

DROP TABLE IF EXISTS `ProstheticOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticOrderFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `orderID` char(36) NOT NULL,
  `fileID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`orderID`,`fileID`),
  KEY `fk_ProstheticOrderFile_ProstheticOrder` (`orderID`,`ownerID`),
  KEY `fk_ProstheticOrderFile_CondorFile` (`fileID`,`ownerID`),
  CONSTRAINT `fk_ProstheticOrderFile_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_ProstheticOrderFile_ProstheticOrder` FOREIGN KEY (`orderID`, `ownerID`) REFERENCES `ProstheticOrder` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrderFile`
--

LOCK TABLES `ProstheticOrderFile` WRITE;
/*!40000 ALTER TABLE `ProstheticOrderFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `ProstheticOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrderRecipient`
--

DROP TABLE IF EXISTS `ProstheticOrderRecipient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticOrderRecipient` (
  `ownerID` mediumint unsigned NOT NULL,
  `orderID` char(36) NOT NULL,
  `recipientID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`orderID`,`recipientID`),
  KEY `fk_ProstheticOrderRecipient_ProstheticOrder` (`orderID`,`ownerID`),
  KEY `fk_ProstheticOrderRecipient_Contact` (`recipientID`,`ownerID`),
  CONSTRAINT `fk_ProstheticOrderRecipient_Contact` FOREIGN KEY (`recipientID`, `ownerID`) REFERENCES `Contact` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_ProstheticOrderRecipient_ProstheticOrder` FOREIGN KEY (`orderID`, `ownerID`) REFERENCES `ProstheticOrder` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrderRecipient`
--

LOCK TABLES `ProstheticOrderRecipient` WRITE;
/*!40000 ALTER TABLE `ProstheticOrderRecipient` DISABLE KEYS */;
/*!40000 ALTER TABLE `ProstheticOrderRecipient` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticSheet`
--

DROP TABLE IF EXISTS `ProstheticSheet`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticSheet` (
  `id` char(36) NOT NULL,
  `ownerID` mediumint unsigned NOT NULL,
  `orderID` char(36) NOT NULL,
  `json` text NOT NULL,
  `pdfFileID` char(36) DEFAULT NULL,
  `dateCreated` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_ProstheticSheet_ProstheticOrder` (`orderID`),
  KEY `fk_ProstheticSheet_CondorFile` (`pdfFileID`),
  CONSTRAINT `fk_ProstheticSheet_CondorFile` FOREIGN KEY (`pdfFileID`) REFERENCES `CondorFile` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_ProstheticSheet_ProstheticOrder` FOREIGN KEY (`orderID`) REFERENCES `ProstheticOrder` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticSheet`
--

LOCK TABLES `ProstheticSheet` WRITE;
/*!40000 ALTER TABLE `ProstheticSheet` DISABLE KEYS */;
/*!40000 ALTER TABLE `ProstheticSheet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ReceivedAttachment`
--

DROP TABLE IF EXISTS `ReceivedAttachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ReceivedAttachment` (
  `ownerID` mediumint unsigned NOT NULL,
  `receivedMessageID` char(36) NOT NULL,
  `fileID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`fileID`,`receivedMessageID`),
  KEY `fk_ReceivedAttachment_ReceivedMessage` (`receivedMessageID`,`ownerID`),
  KEY `fk_ReceivedAttachment_CondorFile` (`fileID`,`ownerID`),
  CONSTRAINT `fk_ReceivedAttachment_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_ReceivedAttachment_ReceivedMessage` FOREIGN KEY (`receivedMessageID`, `ownerID`) REFERENCES `ReceivedMessage` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ReceivedAttachment`
--

LOCK TABLES `ReceivedAttachment` WRITE;
/*!40000 ALTER TABLE `ReceivedAttachment` DISABLE KEYS */;
INSERT INTO `ReceivedAttachment` VALUES (1,'107ea75a-1050-11ea-96ce-96e674358d3a','10849da0-1050-11ea-96ce-96e674358d3a','2022-01-03 15:39:24'),(1,'107ea75a-1050-11ea-96ce-96e674358d3a','10863c63-1050-11ea-96ce-96e674358d3a','2022-01-03 15:39:24'),(1,'107ea75a-1050-11ea-96ce-96e674358d3a','1087a7c1-1050-11ea-96ce-96e674358d3a','2022-01-03 15:39:24'),(1,'107ea75a-1050-11ea-96ce-96e674358d3a','108946c1-1050-11ea-96ce-96e674358d3a','2022-01-03 15:39:24'),(1,'35c87a9c-33de-11eb-973a-96e674358d3a','35dad331-33de-11eb-973a-96e674358d3a','2022-01-03 15:39:24'),(1,'35c87a9c-33de-11eb-973a-96e674358d3a','35dc7207-33de-11eb-973a-96e674358d3a','2022-01-03 15:39:24'),(1,'91a7f039-33de-11eb-973a-96e674358d3a','96f40545-33de-11eb-973a-96e674358d3a','2022-01-03 15:39:24'),(1,'91a7f039-33de-11eb-973a-96e674358d3a','96f96a4a-33de-11eb-973a-96e674358d3a','2022-01-03 15:39:24'),(1,'91a7f039-33de-11eb-973a-96e674358d3a','96fa85e2-33de-11eb-973a-96e674358d3a','2022-01-03 15:39:24'),(1,'91a7f039-33de-11eb-973a-96e674358d3a','9701eb13-33de-11eb-973a-96e674358d3a','2022-01-03 15:39:24'),(1,'b7f25afc-149d-11ec-9774-96e674358d3a','b7f8a07e-149d-11ec-9774-96e674358d3a','2022-01-03 15:39:27'),(1,'b7f25afc-149d-11ec-9774-96e674358d3a','b8194216-149d-11ec-9774-96e674358d3a','2022-01-03 15:39:27'),(1,'b7f25afc-149d-11ec-9774-96e674358d3a','b81bdcca-149d-11ec-9774-96e674358d3a','2022-01-03 15:39:27'),(1,'b7f25afc-149d-11ec-9774-96e674358d3a','b81d62da-149d-11ec-9774-96e674358d3a','2022-01-03 15:39:27'),(1,'b7f25afc-149d-11ec-9774-96e674358d3a','b8213bce-149d-11ec-9774-96e674358d3a','2022-01-03 15:39:27'),(1,'b7f25afc-149d-11ec-9774-96e674358d3a','b822b472-149d-11ec-9774-96e674358d3a','2022-01-03 15:39:27'),(1,'b7f25afc-149d-11ec-9774-96e674358d3a','b8264c34-149d-11ec-9774-96e674358d3a','2022-01-03 15:39:27'),(1,'b7f25afc-149d-11ec-9774-96e674358d3a','b828ddea-149d-11ec-9774-96e674358d3a','2022-01-03 15:39:27'),(1,'b7f25afc-149d-11ec-9774-96e674358d3a','b82a0a26-149d-11ec-9774-96e674358d3a','2022-01-03 15:39:27'),(1,'b7f25afc-149d-11ec-9774-96e674358d3a','b82b88be-149d-11ec-9774-96e674358d3a','2022-01-03 15:39:27'),(1,'b7f25afc-149d-11ec-9774-96e674358d3a','b82d3b2e-149d-11ec-9774-96e674358d3a','2022-01-03 15:39:27'),(1,'b7f25afc-149d-11ec-9774-96e674358d3a','b82ea9e1-149d-11ec-9774-96e674358d3a','2022-01-03 15:39:27'),(1,'b7f25afc-149d-11ec-9774-96e674358d3a','b830260f-149d-11ec-9774-96e674358d3a','2022-01-03 15:39:27'),(1,'b7f25afc-149d-11ec-9774-96e674358d3a','b83220f1-149d-11ec-9774-96e674358d3a','2022-01-03 15:39:27'),(1,'b7f25afc-149d-11ec-9774-96e674358d3a','b833672b-149d-11ec-9774-96e674358d3a','2022-01-03 15:39:27'),(1,'b7f25afc-149d-11ec-9774-96e674358d3a','b834eced-149d-11ec-9774-96e674358d3a','2022-01-03 15:39:27'),(1,'b7f25afc-149d-11ec-9774-96e674358d3a','b8368b57-149d-11ec-9774-96e674358d3a','2022-01-03 15:39:27'),(1,'b7f25afc-149d-11ec-9774-96e674358d3a','b837dfff-149d-11ec-9774-96e674358d3a','2022-01-03 15:39:27'),(1,'b7f25afc-149d-11ec-9774-96e674358d3a','b839b390-149d-11ec-9774-96e674358d3a','2022-01-03 15:39:27'),(1,'b7f25afc-149d-11ec-9774-96e674358d3a','b83c151d-149d-11ec-9774-96e674358d3a','2022-01-03 15:39:27'),(1,'b7f25afc-149d-11ec-9774-96e674358d3a','b83d5753-149d-11ec-9774-96e674358d3a','2022-01-03 15:39:27'),(1,'b7f25afc-149d-11ec-9774-96e674358d3a','b83eae31-149d-11ec-9774-96e674358d3a','2022-01-03 15:39:27'),(1,'b7f25afc-149d-11ec-9774-96e674358d3a','b83ff744-149d-11ec-9774-96e674358d3a','2022-01-03 15:39:27'),(1,'b7f25afc-149d-11ec-9774-96e674358d3a','b841bee1-149d-11ec-9774-96e674358d3a','2022-01-03 15:39:27'),(1,'b7f25afc-149d-11ec-9774-96e674358d3a','b844d949-149d-11ec-9774-96e674358d3a','2022-01-03 15:39:27'),(1,'b7f25afc-149d-11ec-9774-96e674358d3a','b8468022-149d-11ec-9774-96e674358d3a','2022-01-03 15:39:27'),(1,'b7f25afc-149d-11ec-9774-96e674358d3a','b8496f39-149d-11ec-9774-96e674358d3a','2022-01-03 15:39:27'),(1,'ce086464-639e-11ea-96ce-96e674358d3a','ce0d698d-639e-11ea-96ce-96e674358d3a','2022-01-03 15:39:24'),(1,'ce086464-639e-11ea-96ce-96e674358d3a','ce0f00bf-639e-11ea-96ce-96e674358d3a','2022-01-03 15:39:24'),(1,'ce086464-639e-11ea-96ce-96e674358d3a','ce107277-639e-11ea-96ce-96e674358d3a','2022-01-03 15:39:24'),(1,'ce086464-639e-11ea-96ce-96e674358d3a','ce11f18a-639e-11ea-96ce-96e674358d3a','2022-01-03 15:39:24'),(1,'d504d56b-149d-11ec-9774-96e674358d3a','d50bcce4-149d-11ec-9774-96e674358d3a','2022-01-03 15:39:27'),(1,'d504d56b-149d-11ec-9774-96e674358d3a','d50d535b-149d-11ec-9774-96e674358d3a','2022-01-03 15:39:27'),(1,'d504d56b-149d-11ec-9774-96e674358d3a','d50ee537-149d-11ec-9774-96e674358d3a','2022-01-03 15:39:27'),(1,'d504d56b-149d-11ec-9774-96e674358d3a','d5109937-149d-11ec-9774-96e674358d3a','2022-01-03 15:39:27'),(1,'d504d56b-149d-11ec-9774-96e674358d3a','d511ff28-149d-11ec-9774-96e674358d3a','2022-01-03 15:39:27'),(1,'d9b1e382-1474-11ec-9774-96e674358d3a','d9b59b09-1474-11ec-9774-96e674358d3a','2022-01-03 15:39:26'),(1,'d9b1e382-1474-11ec-9774-96e674358d3a','d9b7477e-1474-11ec-9774-96e674358d3a','2022-01-03 15:39:26'),(1,'d9b1e382-1474-11ec-9774-96e674358d3a','d9b8f3ca-1474-11ec-9774-96e674358d3a','2022-01-03 15:39:26'),(1,'f035685a-149d-11ec-9774-96e674358d3a','f039af80-149d-11ec-9774-96e674358d3a','2022-01-03 15:39:27'),(1,'e2d464c8-34c3-11eb-973a-96e674358d3a','f5f89539-34c3-11eb-973a-96e674358d3a','2022-01-03 15:39:24'),(1,'e2d464c8-34c3-11eb-973a-96e674358d3a','f5f9e9dc-34c3-11eb-973a-96e674358d3a','2022-01-03 15:39:24'),(1,'e2d6ba5d-34c3-11eb-973a-96e674358d3a','f601e6f7-34c3-11eb-973a-96e674358d3a','2022-01-03 15:39:24'),(1,'e2d6ba5d-34c3-11eb-973a-96e674358d3a','f6039070-34c3-11eb-973a-96e674358d3a','2022-01-03 15:39:24'),(1,'e2d6ba5d-34c3-11eb-973a-96e674358d3a','f60513c1-34c3-11eb-973a-96e674358d3a','2022-01-03 15:39:24'),(1,'e2d6ba5d-34c3-11eb-973a-96e674358d3a','f606b2d5-34c3-11eb-973a-96e674358d3a','2022-01-03 15:39:25');
/*!40000 ALTER TABLE `ReceivedAttachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ReceivedMessage`
--

DROP TABLE IF EXISTS `ReceivedMessage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ReceivedMessage` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `created` datetime DEFAULT NULL,
  `messageTransmitted` tinyint(1) NOT NULL DEFAULT '0',
  `messageSubject` varchar(45) NOT NULL,
  `body` text,
  `fromID` mediumint unsigned NOT NULL,
  `originMessageID` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `discussionID` char(36) NOT NULL,
  `readStatus` enum('Read','Unread') DEFAULT 'Unread',
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_ReceivedMessage_Discussion` (`discussionID`,`ownerID`),
  CONSTRAINT `fk_ReceivedMessage_Discussion` FOREIGN KEY (`discussionID`, `ownerID`) REFERENCES `Discussion` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ReceivedMessage`
--

LOCK TABLES `ReceivedMessage` WRITE;
/*!40000 ALTER TABLE `ReceivedMessage` DISABLE KEYS */;
INSERT INTO `ReceivedMessage` VALUES (1,'107ea75a-1050-11ea-96ce-96e674358d3a','2019-11-26 14:24:33',1,'#','Commande n° 8.55.1.1',1,NULL,NULL,'2019-11-26 14:24:41','2019-11-26 13:24:41','2019-11-26 14:24:32','3296fbec-fc91-45de-9488-4f4f7a526b6e','Read'),(1,'12a47d5d-ffa3-11e9-96ce-96e674358d3a','2019-11-05 09:05:55',1,'#','Il y a un problème avec les dates ? CAD ?\n',3,NULL,NULL,'2019-11-05 09:06:01','2019-11-05 08:06:01','2019-11-05 09:05:55','39edd03b-189b-4cd8-b553-4fa5e59235ec','Read'),(1,'35c87a9c-33de-11eb-973a-96e674358d3a','2020-12-01 15:03:39',1,'#','essai pour envoi le 01/12/2020 avec fichier',50,NULL,NULL,'2020-12-01 15:05:10','2020-12-01 14:05:10','2020-12-01 15:03:39','82ca34c0-5553-470e-9bed-5b7e9bedc4d9','Read'),(1,'424d3db6-0c8f-11ea-96ce-96e674358d3a','2019-11-21 19:46:50',1,'#','T\'as intérêt à accepter ma nouvelle date. Sans ça, je change de prothésiste ! Compris ?',3,NULL,NULL,'2019-11-21 19:47:22','2019-11-21 18:47:22','2019-11-21 19:46:50','39edd03b-189b-4cd8-b553-4fa5e59235ec','Read'),(1,'4cee7da2-33de-11eb-973a-96e674358d3a','2020-12-01 15:05:42',1,'#','sans fichier nvel essai\n',50,NULL,NULL,'2020-12-01 15:05:43','2020-12-01 14:05:43','2020-12-01 15:05:42','82ca34c0-5553-470e-9bed-5b7e9bedc4d9','Read'),(1,'663b631c-5605-11e9-8d87-b22b7c193920','2019-04-03 05:43:59',1,'#','Merci à toi',3,NULL,NULL,'2019-05-22 17:38:02','2019-05-22 15:38:02','2019-04-03 05:43:59','39edd03b-189b-4cd8-b553-4fa5e59235ec','Read'),(1,'690300e1-7ca7-11e9-944c-96e674358d3a','2019-05-23 01:36:57',1,'#','Hey, what\'s up doc ?',3,NULL,NULL,'2019-05-22 17:38:05','2019-05-22 15:38:05','2019-05-23 01:36:57','39edd03b-189b-4cd8-b553-4fa5e59235ec','Read'),(1,'8f6cf185-8dac-11e9-944c-96e674358d3a','2019-06-13 09:26:29',1,'Réponse depuis le web','coucou',17,NULL,NULL,'2019-06-24 15:37:12','2019-06-24 13:37:12','2019-06-13 09:26:29','1e220661-7864-4e58-b9a0-adf6a924e40d','Read'),(1,'91a7f039-33de-11eb-973a-96e674358d3a','2020-12-01 15:07:37',1,'#','Commande n° 1.17.3.1',50,NULL,NULL,'2020-12-01 15:08:03','2020-12-01 14:08:03','2020-12-01 15:07:37','82ca34c0-5553-470e-9bed-5b7e9bedc4d9','Read'),(1,'a0f3aeaa-55f5-11e9-8d87-b22b7c193920','2019-04-03 19:51:38',1,'#','Salut',3,NULL,NULL,'2019-04-03 11:48:33','2019-04-03 09:48:33','2019-04-03 19:51:38','39edd03b-189b-4cd8-b553-4fa5e59235ec','Read'),(1,'b0258184-3afe-11eb-973a-96e674358d3a','2020-12-10 16:45:11',1,'#','je ne sais pas si je dois repondre',50,NULL,NULL,'2021-02-13 11:09:12','2021-02-13 10:09:12','2020-12-10 16:45:11','82ca34c0-5553-470e-9bed-5b7e9bedc4d9','Read'),(1,'b7f25afc-149d-11ec-9774-96e674358d3a','2021-09-13 16:20:14',1,'#','essai envoi fichier sans commande',43,NULL,NULL,'2021-09-13 16:20:48','2021-09-13 14:20:48','2021-09-13 16:20:14','d3abcf6c-a9db-4e4d-8828-5653ef9c3d86','Read'),(1,'bd4ff491-55f5-11e9-8d87-b22b7c193920','2019-04-03 19:52:26',1,'#',':)',3,NULL,NULL,'2019-04-03 11:49:15','2019-04-03 09:49:15','2019-04-03 19:52:26','39edd03b-189b-4cd8-b553-4fa5e59235ec','Read'),(1,'ce086464-639e-11ea-96ce-96e674358d3a','2020-03-11 14:47:18',1,'#','Commande n° 6.22.1.1',1,NULL,NULL,'2020-03-13 17:20:19','2020-03-13 16:20:19','2020-03-11 14:47:17','3296fbec-fc91-45de-9488-4f4f7a526b6e','Read'),(1,'d504d56b-149d-11ec-9774-96e674358d3a','2021-09-13 16:21:05',1,'#','Commande n° 2.137.1.3',43,NULL,NULL,'2021-09-13 16:21:07','2021-09-13 14:21:07','2021-09-13 16:21:05','d3abcf6c-a9db-4e4d-8828-5653ef9c3d86','Read'),(1,'d60d854a-8834-11e9-944c-96e674358d3a','2019-06-06 10:26:52',1,'#','Hi Tom',3,NULL,NULL,'2019-06-06 10:27:43','2019-06-06 08:27:43','2019-06-06 10:26:52','39edd03b-189b-4cd8-b553-4fa5e59235ec','Read'),(1,'d9b1e382-1474-11ec-9774-96e674358d3a','2021-09-13 11:27:43',1,'#','Commande n° 1.47.2.1',50,NULL,NULL,'2021-09-13 11:27:46','2021-09-13 09:27:46','2021-09-13 11:27:43','82ca34c0-5553-470e-9bed-5b7e9bedc4d9','Read'),(1,'de432335-149d-11ec-9774-96e674358d3a','2021-09-13 16:21:20',1,'#','envoi d\'une commande avec fichier',43,NULL,NULL,'2021-09-13 16:21:31','2021-09-13 14:21:31','2021-09-13 16:21:20','d3abcf6c-a9db-4e4d-8828-5653ef9c3d86','Read'),(1,'dec416b2-157d-11ec-9774-96e674358d3a','2021-09-14 19:04:48',1,'#','test\n',31,NULL,NULL,'2021-09-14 19:05:06','2021-09-14 17:05:06','2021-09-14 19:04:48','b47ae547-86a7-4c5c-b72f-624874f4c8c5','Read'),(1,'e294509b-1474-11ec-9774-96e674358d3a','2021-09-13 11:27:58',1,'#','envoi d\'une commande pour verif',50,NULL,NULL,'2021-09-13 11:28:01','2021-09-13 09:28:01','2021-09-13 11:27:58','82ca34c0-5553-470e-9bed-5b7e9bedc4d9','Read'),(1,'e2d464c8-34c3-11eb-973a-96e674358d3a','2020-11-30 15:20:05',1,'#','essai le 30/11 pour reception o,k dans ri\n',50,NULL,NULL,'2020-12-02 18:31:41','2020-12-02 17:31:41','2020-11-30 15:20:05','82ca34c0-5553-470e-9bed-5b7e9bedc4d9','Read'),(1,'e2d6ba5d-34c3-11eb-973a-96e674358d3a','2020-10-12 16:15:35',1,'#','Commande n° 1.11.1.1',50,NULL,NULL,'2020-12-02 18:31:41','2020-12-02 17:31:41','2020-10-12 16:15:35','82ca34c0-5553-470e-9bed-5b7e9bedc4d9','Read'),(1,'f035685a-149d-11ec-9774-96e674358d3a','2021-09-13 16:21:48',1,'#','Commande n° 2.137.1.4',43,NULL,NULL,'2021-09-13 16:21:51','2021-09-13 14:21:51','2021-09-13 16:21:48','d3abcf6c-a9db-4e4d-8828-5653ef9c3d86','Read'),(1,'f8fe7ee3-149d-11ec-9774-96e674358d3a','2021-09-13 16:22:05',1,'#','et une commande sans fichier associé\n',43,NULL,NULL,'2021-09-13 16:22:07','2021-09-13 14:22:07','2021-09-13 16:22:05','d3abcf6c-a9db-4e4d-8828-5653ef9c3d86','Read'),(1,'f9e90378-3acc-11eb-973a-96e674358d3a','2020-12-10 10:49:20',1,'Réponse depuis le web','test 2\n',4,NULL,NULL,'2020-12-10 10:49:22','2020-12-10 09:49:22','2020-12-10 10:49:20','c96239ca-4da5-41fa-b243-e09fcb750abd','Read');
/*!40000 ALTER TABLE `ReceivedMessage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Scan`
--

DROP TABLE IF EXISTS `Scan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Scan` (
  `ownerID` mediumint unsigned NOT NULL DEFAULT '0',
  `id` char(36) NOT NULL,
  `scanType` enum('MAXILLAIRE','MANDIBULE','MORDU_ANTERIEUR','MORDU_POSTERIEUR_GAUCHE','MORDU_POSTERIEUR_DROIT') DEFAULT 'MAXILLAIRE',
  `comments` mediumtext,
  `cameraX` decimal(10,0) DEFAULT NULL,
  `cameraY` decimal(10,0) DEFAULT NULL,
  `cameraZ` decimal(10,0) DEFAULT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `validated` tinyint(1) NOT NULL DEFAULT '0',
  `status` enum('in_progress','none') NOT NULL DEFAULT 'in_progress',
  `dateCreated` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `sessionID` char(36) DEFAULT NULL,
  `displayID` mediumint unsigned DEFAULT NULL,
  `globalDisplayID` mediumint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Scan_Work` (`ownerID`),
  KEY `fk_Scan_Session` (`sessionID`,`ownerID`),
  CONSTRAINT `fk_Scan_Session` FOREIGN KEY (`sessionID`, `ownerID`) REFERENCES `Session` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Scan`
--

LOCK TABLES `Scan` WRITE;
/*!40000 ALTER TABLE `Scan` DISABLE KEYS */;
/*!40000 ALTER TABLE `Scan` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `Scan_AFTER_UPDATE` AFTER UPDATE ON `Scan` FOR EACH ROW BEGIN
    IF NEW.deletedAt IS NOT NULL THEN
      UPDATE Occlusion SET topScanID = NULL
	  WHERE topScanID = new.id;

	  UPDATE Occlusion SET bottomScanID = NULL
	  WHERE bottomScanID = new.id;

	  UPDATE Occlusion SET leftBiteScanID = NULL
	  WHERE leftBiteScanID = new.id;

	  UPDATE Occlusion SET rightBiteScanID = NULL
	  WHERE rightBiteScanID = new.id;

	  UPDATE Occlusion SET anteriorBiteScanID = NULL
	  WHERE anteriorBiteScanID = new.id;
    END IF;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `Scan_BEFORE_DELETE` BEFORE DELETE ON `Scan` FOR EACH ROW BEGIN
  UPDATE Occlusion SET topScanID = NULL
  WHERE topScanID = OLD.id;

  UPDATE Occlusion SET bottomScanID = NULL
  WHERE bottomScanID = OLD.id;

  UPDATE Occlusion SET leftBiteScanID = NULL
  WHERE leftBiteScanID = OLD.id;

  UPDATE Occlusion SET rightBiteScanID = NULL
  WHERE rightBiteScanID = OLD.id;

  UPDATE Occlusion SET anteriorBiteScanID = NULL
  WHERE anteriorBiteScanID = OLD.id;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `ScanFile`
--

DROP TABLE IF EXISTS `ScanFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ScanFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `fileID` char(36) NOT NULL,
  `scanID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`fileID`,`scanID`,`ownerID`),
  KEY `fk_ScanFile_Scan` (`scanID`,`ownerID`),
  KEY `fk_ScanFile_CondorFile` (`fileID`,`ownerID`),
  CONSTRAINT `fk_ScanFile_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_ScanFile_Scan` FOREIGN KEY (`scanID`, `ownerID`) REFERENCES `Scan` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ScanFile`
--

LOCK TABLES `ScanFile` WRITE;
/*!40000 ALTER TABLE `ScanFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `ScanFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SentAttachment`
--

DROP TABLE IF EXISTS `SentAttachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SentAttachment` (
  `ownerID` mediumint unsigned NOT NULL DEFAULT '0',
  `sentMessageID` char(36) NOT NULL,
  `fileID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`sentMessageID`,`fileID`),
  KEY `fk_SentAttachment_SentMessage` (`sentMessageID`,`ownerID`),
  KEY `fk_SentAttachment_CondorFile` (`fileID`,`ownerID`),
  CONSTRAINT `fk_SentAttachment_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_SentAttachment_SentMessage` FOREIGN KEY (`sentMessageID`, `ownerID`) REFERENCES `SentMessage` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SentAttachment`
--

LOCK TABLES `SentAttachment` WRITE;
/*!40000 ALTER TABLE `SentAttachment` DISABLE KEYS */;
INSERT INTO `SentAttachment` VALUES (1,'0c942d7a-6fb5-43cf-a802-052c7f80b387','46acec7d-25db-4d26-a0cf-75453ee9bd1c','2022-01-03 15:39:23'),(1,'0c942d7a-6fb5-43cf-a802-052c7f80b387','7377e6d6-9d2a-4b52-a633-01294cf03971','2022-01-03 15:39:23'),(1,'0e05e910-0cc5-4fd4-96f1-d4e298ccbc4c','00949f49-2112-438f-a7cf-16567daf4658','2022-01-03 15:39:25'),(1,'0e05e910-0cc5-4fd4-96f1-d4e298ccbc4c','1e70139f-3cc4-4a06-9ddb-72c90003e32f','2022-01-03 15:39:25'),(1,'0e05e910-0cc5-4fd4-96f1-d4e298ccbc4c','3cba2a9d-7323-4c56-937f-158cfc5ee1c0','2022-01-03 15:39:25'),(1,'0e05e910-0cc5-4fd4-96f1-d4e298ccbc4c','99670342-6f6e-46e9-8d35-3adf4203f7f4','2022-01-03 15:39:25'),(1,'0e05e910-0cc5-4fd4-96f1-d4e298ccbc4c','9d936069-774d-4701-b445-d931dd522618','2022-01-03 15:39:25'),(1,'0e05e910-0cc5-4fd4-96f1-d4e298ccbc4c','a4da6ae7-e6b1-4233-b4b7-16ab46a3a583','2022-01-03 15:39:25'),(1,'0e05e910-0cc5-4fd4-96f1-d4e298ccbc4c','b699290f-d6fe-401e-a793-6b18604533c8','2022-01-03 15:39:25'),(1,'0e05e910-0cc5-4fd4-96f1-d4e298ccbc4c','d4150236-b82c-4908-adf8-69f0d41b5961','2022-01-03 15:39:25'),(1,'0e05e910-0cc5-4fd4-96f1-d4e298ccbc4c','df6f2dc6-de60-43c3-a7bb-e06c5335636a','2022-01-03 15:39:25'),(1,'0e05e910-0cc5-4fd4-96f1-d4e298ccbc4c','f84ff04e-75d8-4176-98ed-63f9b3383b57','2022-01-03 15:39:25'),(1,'101339aa-86de-4fb3-adae-6dc44fdd8d61','19cf3b9a-8103-493a-add8-799541ed5110','2022-01-03 15:39:23'),(1,'101339aa-86de-4fb3-adae-6dc44fdd8d61','3c6394ef-9b51-4c78-b14b-14c28ed74da4','2022-01-03 15:39:23'),(1,'288e6127-d407-407a-9284-fb09da7d5193','04767e57-c063-4280-bcea-6129cbd9d95a','2022-01-03 15:39:25'),(1,'288e6127-d407-407a-9284-fb09da7d5193','06d41446-0480-43ac-ad4a-41bfaf8745ad','2022-01-03 15:39:25'),(1,'288e6127-d407-407a-9284-fb09da7d5193','63ec36f9-53cb-4124-9e6f-138c27f76edb','2022-01-03 15:39:25'),(1,'288e6127-d407-407a-9284-fb09da7d5193','897d7eb5-0acc-4e1e-ad77-325ac8a285c6','2022-01-03 15:39:25'),(1,'288e6127-d407-407a-9284-fb09da7d5193','8d8924ef-cbf3-45e5-bba0-a01024f00cbd','2022-01-03 15:39:25'),(1,'288e6127-d407-407a-9284-fb09da7d5193','a83fb03c-717f-4bd4-95fa-a4309b2566e3','2022-01-03 15:39:25'),(1,'288e6127-d407-407a-9284-fb09da7d5193','ad6e9ee0-12ed-4af8-8b56-3b472e76f840','2022-01-03 15:39:25'),(1,'288e6127-d407-407a-9284-fb09da7d5193','f70a23af-1ebb-48b7-ba02-af5e6cf0a956','2022-01-03 15:39:25'),(1,'3fe5199e-6ffe-4ea8-a795-b9aeca9e1800','84457a7a-8bbd-4128-ab5a-88c427c6287a','2022-01-03 15:39:24'),(1,'3fe5199e-6ffe-4ea8-a795-b9aeca9e1800','9cff83a2-65ca-4fd4-a2ae-c3c4cb737307','2022-01-03 15:39:24'),(1,'3fe5199e-6ffe-4ea8-a795-b9aeca9e1800','c9d7e198-e774-4b90-baf2-3228d984d2c2','2022-01-03 15:39:24'),(1,'3fe5199e-6ffe-4ea8-a795-b9aeca9e1800','d2c15040-7c88-4c26-a90a-ca5a6784e4b0','2022-01-03 15:39:24'),(1,'5a6f6f6e-b8b2-4b64-8ffd-89fca24060c6','028e56ca-9fd2-4eb4-92f8-25a8c2a00335','2022-01-03 15:39:26'),(1,'5a6f6f6e-b8b2-4b64-8ffd-89fca24060c6','1315936d-c363-4301-b8d0-62b15029c222','2022-01-03 15:39:26'),(1,'5a6f6f6e-b8b2-4b64-8ffd-89fca24060c6','13dbf97a-6239-46a8-856d-f1e125cdcde0','2022-01-03 15:39:26'),(1,'5a6f6f6e-b8b2-4b64-8ffd-89fca24060c6','175d0ba4-b3e6-4854-a614-023a725d109b','2022-01-03 15:39:26'),(1,'5a6f6f6e-b8b2-4b64-8ffd-89fca24060c6','1b60cbaf-3697-43bd-8356-b24f9de49a5d','2022-01-03 15:39:26'),(1,'5a6f6f6e-b8b2-4b64-8ffd-89fca24060c6','1e5d50db-3a34-48be-9cc3-4ea85d82a5fa','2022-01-03 15:39:26'),(1,'5a6f6f6e-b8b2-4b64-8ffd-89fca24060c6','222973a9-29e4-4dea-91c0-9d860952fe34','2022-01-03 15:39:26'),(1,'5a6f6f6e-b8b2-4b64-8ffd-89fca24060c6','24938b5d-f0cf-40ab-b3c8-0910dd7c1212','2022-01-03 15:39:26'),(1,'5a6f6f6e-b8b2-4b64-8ffd-89fca24060c6','31c143d3-5616-4584-9786-40571935a48f','2022-01-03 15:39:26'),(1,'5a6f6f6e-b8b2-4b64-8ffd-89fca24060c6','33302343-3bb1-4e08-ae84-2b6b550e21fe','2022-01-03 15:39:26'),(1,'5a6f6f6e-b8b2-4b64-8ffd-89fca24060c6','3510e4d3-d145-4b43-9962-37f436a70ca7','2022-01-03 15:39:26'),(1,'5a6f6f6e-b8b2-4b64-8ffd-89fca24060c6','356bae49-0db7-4a21-aaf7-b0af18a2cc93','2022-01-03 15:39:26'),(1,'5a6f6f6e-b8b2-4b64-8ffd-89fca24060c6','3ac1dbee-6513-43bd-a084-122da32ec6db','2022-01-03 15:39:26'),(1,'5a6f6f6e-b8b2-4b64-8ffd-89fca24060c6','43867f66-35af-48cd-9429-8b5f51289a02','2022-01-03 15:39:26'),(1,'5a6f6f6e-b8b2-4b64-8ffd-89fca24060c6','4a225108-35af-43c6-9f71-1ddeed71b876','2022-01-03 15:39:26'),(1,'5a6f6f6e-b8b2-4b64-8ffd-89fca24060c6','4f0a31a1-c3be-4f85-b51a-ec70d12375b7','2022-01-03 15:39:26'),(1,'5a6f6f6e-b8b2-4b64-8ffd-89fca24060c6','5007b5eb-3459-4d54-b368-6252c49b04fa','2022-01-03 15:39:26'),(1,'5a6f6f6e-b8b2-4b64-8ffd-89fca24060c6','50a23e88-e035-4521-a4d9-932a19651a5a','2022-01-03 15:39:26'),(1,'5a6f6f6e-b8b2-4b64-8ffd-89fca24060c6','66e5afde-c729-4325-8fc8-bd15b4fde66e','2022-01-03 15:39:26'),(1,'5a6f6f6e-b8b2-4b64-8ffd-89fca24060c6','7d026df6-f58f-466d-8a4c-e6d87741a603','2022-01-03 15:39:26'),(1,'5a6f6f6e-b8b2-4b64-8ffd-89fca24060c6','8251a9a2-4b94-408c-b149-3e1f8e468989','2022-01-03 15:39:26'),(1,'5a6f6f6e-b8b2-4b64-8ffd-89fca24060c6','909566f5-8c35-4cb4-be86-7864f27c7429','2022-01-03 15:39:26'),(1,'5a6f6f6e-b8b2-4b64-8ffd-89fca24060c6','934114b7-8c84-48c9-b87a-d4d5de17b7c6','2022-01-03 15:39:26'),(1,'5a6f6f6e-b8b2-4b64-8ffd-89fca24060c6','b7fd587e-4d00-441f-a2ff-e3da14d90796','2022-01-03 15:39:26'),(1,'5a6f6f6e-b8b2-4b64-8ffd-89fca24060c6','d5672a29-7aba-4b16-bb23-9233b1f99319','2022-01-03 15:39:26'),(1,'5a6f6f6e-b8b2-4b64-8ffd-89fca24060c6','d7162c50-77cc-4860-b149-a92c05c1fc03','2022-01-03 15:39:26'),(1,'5a6f6f6e-b8b2-4b64-8ffd-89fca24060c6','db4f45f9-cbb2-4d49-86f3-d47bf41c866d','2022-01-03 15:39:26'),(1,'5a6f6f6e-b8b2-4b64-8ffd-89fca24060c6','f61a6164-f96b-4403-b45c-bd7649df9255','2022-01-03 15:39:26'),(1,'5a6f6f6e-b8b2-4b64-8ffd-89fca24060c6','fb0d60a8-5cf5-49dc-8104-d3d60e45ee2b','2022-01-03 15:39:26'),(1,'5a6f6f6e-b8b2-4b64-8ffd-89fca24060c6','fcfe7063-3bf7-4303-ab31-a6444d887c33','2022-01-03 15:39:26'),(1,'5b9d7ac8-d6f0-4ad6-b793-485d935a67e2','07d4e99e-7817-425e-9888-6f9de3226805','2022-01-03 15:39:24'),(1,'5b9d7ac8-d6f0-4ad6-b793-485d935a67e2','13861d2d-7322-4e2d-bc82-e2c013ce7a5a','2022-01-03 15:39:24'),(1,'5b9d7ac8-d6f0-4ad6-b793-485d935a67e2','160bbb01-17ff-4718-947a-dd4f81e8c894','2022-01-03 15:39:24'),(1,'5b9d7ac8-d6f0-4ad6-b793-485d935a67e2','18189f00-7e7d-49e1-8151-de39bf0132fe','2022-01-03 15:39:24'),(1,'5b9d7ac8-d6f0-4ad6-b793-485d935a67e2','334e3796-2c05-4f64-b13f-f1990ab701b2','2022-01-03 15:39:24'),(1,'5b9d7ac8-d6f0-4ad6-b793-485d935a67e2','450d7db4-e5ee-4fe9-88a6-b65e00b032df','2022-01-03 15:39:24'),(1,'5b9d7ac8-d6f0-4ad6-b793-485d935a67e2','5354bf8f-74c4-42b2-a829-6822ae8979e2','2022-01-03 15:39:24'),(1,'5b9d7ac8-d6f0-4ad6-b793-485d935a67e2','5b7c3a03-9f0d-49d3-b859-ed9692ce8fb6','2022-01-03 15:39:24'),(1,'5b9d7ac8-d6f0-4ad6-b793-485d935a67e2','b4a3a43f-41bb-4780-afd3-c3f736199be1','2022-01-03 15:39:24'),(1,'5b9d7ac8-d6f0-4ad6-b793-485d935a67e2','badf266e-7ea1-43ca-b4de-2ce3ba82d49b','2022-01-03 15:39:24'),(1,'5b9d7ac8-d6f0-4ad6-b793-485d935a67e2','c137e216-950d-4a32-9b10-78b14813f605','2022-01-03 15:39:24'),(1,'5b9d7ac8-d6f0-4ad6-b793-485d935a67e2','e2c2b0c3-cc7d-4726-b1e7-394a3d116153','2022-01-03 15:39:24'),(1,'5b9d7ac8-d6f0-4ad6-b793-485d935a67e2','e52eb2e5-65fa-4080-9cae-4831a3eb3c77','2022-01-03 15:39:24'),(1,'5b9d7ac8-d6f0-4ad6-b793-485d935a67e2','f1159414-a4d8-4adb-bf40-52342b3d5c35','2022-01-03 15:39:24'),(1,'6c1effc4-83b4-4434-afc2-2aafa42842e5','13f44cb4-d435-41c0-ae45-122b4949147b','2022-01-03 15:39:24'),(1,'6c1effc4-83b4-4434-afc2-2aafa42842e5','9a996f4e-b1a1-4c04-bd14-65f4db0892da','2022-01-03 15:39:24'),(1,'6c1effc4-83b4-4434-afc2-2aafa42842e5','9af5eaec-2e22-4a17-a9e4-1b4a4cdb7537','2022-01-03 15:39:24'),(1,'6c1effc4-83b4-4434-afc2-2aafa42842e5','cf7a56d5-d334-4075-aa73-6f814dd1935d','2022-01-03 15:39:24'),(1,'6c5d43c3-7a19-47fe-b855-2759fb64f716','01321d34-981b-40e8-a74b-74691e06af94','2022-01-03 15:39:24'),(1,'6c5d43c3-7a19-47fe-b855-2759fb64f716','2ea89171-654f-401d-a8a8-c368a1991b44','2022-01-03 15:39:24'),(1,'6c5d43c3-7a19-47fe-b855-2759fb64f716','51ecce30-4107-4a3b-92c1-da4df4c0f132','2022-01-03 15:39:24'),(1,'6c5d43c3-7a19-47fe-b855-2759fb64f716','53765288-b295-4062-a45d-c4d6d3d7d08b','2022-01-03 15:39:24'),(1,'6c5d43c3-7a19-47fe-b855-2759fb64f716','60041b81-623a-4084-ae12-f077ad960471','2022-01-03 15:39:24'),(1,'6c5d43c3-7a19-47fe-b855-2759fb64f716','6e0ff98c-e62f-4aa3-8d7d-2ad9e7d55c24','2022-01-03 15:39:24'),(1,'6c5d43c3-7a19-47fe-b855-2759fb64f716','8c8f836f-9c38-4162-a2a1-c7208ec1c0fb','2022-01-03 15:39:24'),(1,'6c5d43c3-7a19-47fe-b855-2759fb64f716','964147ac-4166-43b0-b2c3-db434042373a','2022-01-03 15:39:24'),(1,'6c5d43c3-7a19-47fe-b855-2759fb64f716','9fcc99f0-3a47-4c9a-89d2-667877abadd2','2022-01-03 15:39:24'),(1,'6c5d43c3-7a19-47fe-b855-2759fb64f716','a8359b48-d764-484a-b9e5-92e2f666a117','2022-01-03 15:39:24'),(1,'6c5d43c3-7a19-47fe-b855-2759fb64f716','be33cc76-cdea-4815-8c6d-396807e5c1bd','2022-01-03 15:39:24'),(1,'6c5d43c3-7a19-47fe-b855-2759fb64f716','d3465ac8-b877-4ecb-a929-76da5d7a4996','2022-01-03 15:39:24'),(1,'6c5d43c3-7a19-47fe-b855-2759fb64f716','f66cea56-42b0-41df-bab8-cceb869bc846','2022-01-03 15:39:24'),(1,'721e0966-27f8-4c91-a6ee-4da1e5e5f3e3','24938b5d-f0cf-40ab-b3c8-0910dd7c1212','2022-01-03 15:39:26'),(1,'721e0966-27f8-4c91-a6ee-4da1e5e5f3e3','b7fd587e-4d00-441f-a2ff-e3da14d90796','2022-01-03 15:39:26'),(1,'752bf1c7-b7e4-4e36-bbf0-27f02064f3ba','07d4e99e-7817-425e-9888-6f9de3226805','2022-01-03 15:39:23'),(1,'752bf1c7-b7e4-4e36-bbf0-27f02064f3ba','b4a3a43f-41bb-4780-afd3-c3f736199be1','2022-01-03 15:39:23'),(1,'752bf1c7-b7e4-4e36-bbf0-27f02064f3ba','d1cb9b15-26cf-49f0-a96d-f691dcb05c62','2022-01-03 15:39:23'),(1,'752bf1c7-b7e4-4e36-bbf0-27f02064f3ba','dc5f3e69-8284-414b-9703-0f203d7bf2df','2022-01-03 15:39:23'),(1,'7840af82-ad7b-4086-8e4b-54f75f073c07','de0d8010-bb87-442f-9e42-172731282136','2022-01-03 15:39:23'),(1,'7840af82-ad7b-4086-8e4b-54f75f073c07','e1251369-7408-4850-a9d5-8b350b4741df','2022-01-03 15:39:23'),(1,'8367b46f-0354-4dd1-9505-02911509cf14','028e56ca-9fd2-4eb4-92f8-25a8c2a00335','2022-01-03 15:39:26'),(1,'8367b46f-0354-4dd1-9505-02911509cf14','1315936d-c363-4301-b8d0-62b15029c222','2022-01-03 15:39:26'),(1,'8367b46f-0354-4dd1-9505-02911509cf14','13dbf97a-6239-46a8-856d-f1e125cdcde0','2022-01-03 15:39:26'),(1,'8367b46f-0354-4dd1-9505-02911509cf14','175d0ba4-b3e6-4854-a614-023a725d109b','2022-01-03 15:39:26'),(1,'8367b46f-0354-4dd1-9505-02911509cf14','1b60cbaf-3697-43bd-8356-b24f9de49a5d','2022-01-03 15:39:26'),(1,'8367b46f-0354-4dd1-9505-02911509cf14','1e5d50db-3a34-48be-9cc3-4ea85d82a5fa','2022-01-03 15:39:26'),(1,'8367b46f-0354-4dd1-9505-02911509cf14','222973a9-29e4-4dea-91c0-9d860952fe34','2022-01-03 15:39:26'),(1,'8367b46f-0354-4dd1-9505-02911509cf14','24938b5d-f0cf-40ab-b3c8-0910dd7c1212','2022-01-03 15:39:26'),(1,'8367b46f-0354-4dd1-9505-02911509cf14','31c143d3-5616-4584-9786-40571935a48f','2022-01-03 15:39:26'),(1,'8367b46f-0354-4dd1-9505-02911509cf14','33302343-3bb1-4e08-ae84-2b6b550e21fe','2022-01-03 15:39:26'),(1,'8367b46f-0354-4dd1-9505-02911509cf14','3510e4d3-d145-4b43-9962-37f436a70ca7','2022-01-03 15:39:26'),(1,'8367b46f-0354-4dd1-9505-02911509cf14','356bae49-0db7-4a21-aaf7-b0af18a2cc93','2022-01-03 15:39:26'),(1,'8367b46f-0354-4dd1-9505-02911509cf14','3ac1dbee-6513-43bd-a084-122da32ec6db','2022-01-03 15:39:26'),(1,'8367b46f-0354-4dd1-9505-02911509cf14','43867f66-35af-48cd-9429-8b5f51289a02','2022-01-03 15:39:26'),(1,'8367b46f-0354-4dd1-9505-02911509cf14','4a225108-35af-43c6-9f71-1ddeed71b876','2022-01-03 15:39:26'),(1,'8367b46f-0354-4dd1-9505-02911509cf14','4f0a31a1-c3be-4f85-b51a-ec70d12375b7','2022-01-03 15:39:26'),(1,'8367b46f-0354-4dd1-9505-02911509cf14','5007b5eb-3459-4d54-b368-6252c49b04fa','2022-01-03 15:39:26'),(1,'8367b46f-0354-4dd1-9505-02911509cf14','50a23e88-e035-4521-a4d9-932a19651a5a','2022-01-03 15:39:26'),(1,'8367b46f-0354-4dd1-9505-02911509cf14','66e5afde-c729-4325-8fc8-bd15b4fde66e','2022-01-03 15:39:26'),(1,'8367b46f-0354-4dd1-9505-02911509cf14','7d026df6-f58f-466d-8a4c-e6d87741a603','2022-01-03 15:39:26'),(1,'8367b46f-0354-4dd1-9505-02911509cf14','8251a9a2-4b94-408c-b149-3e1f8e468989','2022-01-03 15:39:26'),(1,'8367b46f-0354-4dd1-9505-02911509cf14','909566f5-8c35-4cb4-be86-7864f27c7429','2022-01-03 15:39:26'),(1,'8367b46f-0354-4dd1-9505-02911509cf14','934114b7-8c84-48c9-b87a-d4d5de17b7c6','2022-01-03 15:39:26'),(1,'8367b46f-0354-4dd1-9505-02911509cf14','b7fd587e-4d00-441f-a2ff-e3da14d90796','2022-01-03 15:39:26'),(1,'8367b46f-0354-4dd1-9505-02911509cf14','d5672a29-7aba-4b16-bb23-9233b1f99319','2022-01-03 15:39:26'),(1,'8367b46f-0354-4dd1-9505-02911509cf14','d7162c50-77cc-4860-b149-a92c05c1fc03','2022-01-03 15:39:26'),(1,'8367b46f-0354-4dd1-9505-02911509cf14','db4f45f9-cbb2-4d49-86f3-d47bf41c866d','2022-01-03 15:39:26'),(1,'8367b46f-0354-4dd1-9505-02911509cf14','f61a6164-f96b-4403-b45c-bd7649df9255','2022-01-03 15:39:26'),(1,'8367b46f-0354-4dd1-9505-02911509cf14','fb0d60a8-5cf5-49dc-8104-d3d60e45ee2b','2022-01-03 15:39:26'),(1,'8367b46f-0354-4dd1-9505-02911509cf14','fcfe7063-3bf7-4303-ab31-a6444d887c33','2022-01-03 15:39:26'),(1,'87b19da2-e3b9-4859-8d9f-7ba3791adc02','49786fd5-0993-4fa4-bb8c-44d67e6de75a','2022-01-03 15:39:24'),(1,'87b19da2-e3b9-4859-8d9f-7ba3791adc02','5396ca0e-bfce-49b1-9309-5f65706e2472','2022-01-03 15:39:24'),(1,'87b19da2-e3b9-4859-8d9f-7ba3791adc02','9af5eaec-2e22-4a17-a9e4-1b4a4cdb7537','2022-01-03 15:39:24'),(1,'87b19da2-e3b9-4859-8d9f-7ba3791adc02','cf7a56d5-d334-4075-aa73-6f814dd1935d','2022-01-03 15:39:24'),(1,'9f145309-dee9-44f1-8623-48d461ba64df','00949f49-2112-438f-a7cf-16567daf4658','2022-01-03 15:39:24'),(1,'9f145309-dee9-44f1-8623-48d461ba64df','141b2582-1df5-4a7d-89cf-ccbab45f4155','2022-01-03 15:39:24'),(1,'9f145309-dee9-44f1-8623-48d461ba64df','2383bba0-87fe-481a-bbcb-d1540b6805a2','2022-01-03 15:39:24'),(1,'9f145309-dee9-44f1-8623-48d461ba64df','3cba2a9d-7323-4c56-937f-158cfc5ee1c0','2022-01-03 15:39:24'),(1,'9f145309-dee9-44f1-8623-48d461ba64df','99670342-6f6e-46e9-8d35-3adf4203f7f4','2022-01-03 15:39:24'),(1,'9f145309-dee9-44f1-8623-48d461ba64df','a4da6ae7-e6b1-4233-b4b7-16ab46a3a583','2022-01-03 15:39:24'),(1,'9f145309-dee9-44f1-8623-48d461ba64df','b699290f-d6fe-401e-a793-6b18604533c8','2022-01-03 15:39:24'),(1,'9f145309-dee9-44f1-8623-48d461ba64df','d4150236-b82c-4908-adf8-69f0d41b5961','2022-01-03 15:39:24'),(1,'9f145309-dee9-44f1-8623-48d461ba64df','df6f2dc6-de60-43c3-a7bb-e06c5335636a','2022-01-03 15:39:24'),(1,'9f145309-dee9-44f1-8623-48d461ba64df','e619dbad-adce-4f7e-b837-ca7fd7666495','2022-01-03 15:39:24'),(1,'9f145309-dee9-44f1-8623-48d461ba64df','f4b8a19f-eba0-4417-a57a-89fa1c6eab26','2022-01-03 15:39:24'),(1,'9f145309-dee9-44f1-8623-48d461ba64df','f84ff04e-75d8-4176-98ed-63f9b3383b57','2022-01-03 15:39:24'),(1,'9f145309-dee9-44f1-8623-48d461ba64df','fee5320b-dbd2-488c-bcc3-77bce4985902','2022-01-03 15:39:24'),(1,'a12a1f66-85ad-4891-ae0c-f17e464c1943','1e1ece48-093f-423d-bb99-c29c44607531','2022-01-03 15:39:24'),(1,'a12a1f66-85ad-4891-ae0c-f17e464c1943','31957f90-bb27-434a-9544-ae72ec8e7ca4','2022-01-03 15:39:24'),(1,'a12a1f66-85ad-4891-ae0c-f17e464c1943','3ea0622c-6df6-4cad-8d6f-c4f7776da872','2022-01-03 15:39:24'),(1,'a12a1f66-85ad-4891-ae0c-f17e464c1943','4df7e3f5-875b-4738-b110-e94a26f14d47','2022-01-03 15:39:24'),(1,'a12a1f66-85ad-4891-ae0c-f17e464c1943','6e9af76d-eac8-4fe8-876f-bf21ab0e9ff8','2022-01-03 15:39:24'),(1,'a12a1f66-85ad-4891-ae0c-f17e464c1943','c2dbf4ee-8096-49bd-8d5f-47a57c43908e','2022-01-03 15:39:24'),(1,'aaa2e4aa-2659-44b3-9721-2396faa915c0','75d2f76b-87db-4b1f-a58d-21da7ddedf9c','2022-01-03 15:39:23'),(1,'aaa2e4aa-2659-44b3-9721-2396faa915c0','8f50610e-153f-45fa-9782-2b4e65287c01','2022-01-03 15:39:23'),(1,'b2b86dff-18bc-4daa-a2a4-be2967a12db6','04767e57-c063-4280-bcea-6129cbd9d95a','2022-01-03 15:39:23'),(1,'b2b86dff-18bc-4daa-a2a4-be2967a12db6','4663ec95-2c27-4b4e-a90e-da0f950f1024','2022-01-03 15:39:23'),(1,'b2b86dff-18bc-4daa-a2a4-be2967a12db6','63ec36f9-53cb-4124-9e6f-138c27f76edb','2022-01-03 15:39:23'),(1,'b2b86dff-18bc-4daa-a2a4-be2967a12db6','897d7eb5-0acc-4e1e-ad77-325ac8a285c6','2022-01-03 15:39:23'),(1,'b2b86dff-18bc-4daa-a2a4-be2967a12db6','8d8924ef-cbf3-45e5-bba0-a01024f00cbd','2022-01-03 15:39:23'),(1,'b2b86dff-18bc-4daa-a2a4-be2967a12db6','ad6e9ee0-12ed-4af8-8b56-3b472e76f840','2022-01-03 15:39:23'),(1,'b2b86dff-18bc-4daa-a2a4-be2967a12db6','f70a23af-1ebb-48b7-ba02-af5e6cf0a956','2022-01-03 15:39:23'),(1,'b2b86dff-18bc-4daa-a2a4-be2967a12db6','f762d7d9-d5ac-4f8f-8d4b-c3639463fb5f','2022-01-03 15:39:23'),(1,'bc9b9a32-0036-413c-af6e-db94d08209ac','028e56ca-9fd2-4eb4-92f8-25a8c2a00335','2022-01-03 15:39:26'),(1,'bc9b9a32-0036-413c-af6e-db94d08209ac','fcfe7063-3bf7-4303-ab31-a6444d887c33','2022-01-03 15:39:26'),(1,'bed2294b-041c-4b05-8e6c-022f3aeda7c5','22bb764c-129b-4230-8497-b6401cf04733','2022-01-03 15:39:24'),(1,'bed2294b-041c-4b05-8e6c-022f3aeda7c5','c7b50281-2246-44b0-a9e9-f158d544276f','2022-01-03 15:39:24'),(1,'bed2294b-041c-4b05-8e6c-022f3aeda7c5','e2c207f8-d63a-4b68-ba23-b85ab9ac9733','2022-01-03 15:39:24'),(1,'bed2294b-041c-4b05-8e6c-022f3aeda7c5','e6f1d054-57c5-4117-976d-e13f15b011d0','2022-01-03 15:39:24'),(1,'c08ba604-d58d-46c2-8c14-c0acdce96582','3ba1534e-38f1-4042-957e-167813bd2860','2022-01-03 15:39:23'),(1,'c08ba604-d58d-46c2-8c14-c0acdce96582','55779603-cdb3-4ad1-abdb-65bf1d88edcc','2022-01-03 15:39:23'),(1,'c1d2fc8a-7720-4738-9cb2-b32ddff28fd9','07d4e99e-7817-425e-9888-6f9de3226805','2022-01-03 15:39:24'),(1,'c1d2fc8a-7720-4738-9cb2-b32ddff28fd9','21676af8-1320-42e8-9f34-63a455f0b05f','2022-01-03 15:39:24'),(1,'c1d2fc8a-7720-4738-9cb2-b32ddff28fd9','b4a3a43f-41bb-4780-afd3-c3f736199be1','2022-01-03 15:39:24'),(1,'c1d2fc8a-7720-4738-9cb2-b32ddff28fd9','e189b1bb-3cd5-49b0-a7a9-5f6124688584','2022-01-03 15:39:24'),(1,'c34660b3-a141-4805-8f88-75295495458c','324d2d94-a373-48d0-9a2a-6093e91dd65b','2022-01-03 15:39:25'),(1,'c34660b3-a141-4805-8f88-75295495458c','deae2324-492d-46a7-be42-925a3b1ba688','2022-01-03 15:39:25'),(1,'c76d36b3-d2a5-419c-afd9-92c99e87e37b','07d4e99e-7817-425e-9888-6f9de3226805','2022-01-03 15:39:24'),(1,'c76d36b3-d2a5-419c-afd9-92c99e87e37b','13861d2d-7322-4e2d-bc82-e2c013ce7a5a','2022-01-03 15:39:24'),(1,'c76d36b3-d2a5-419c-afd9-92c99e87e37b','18189f00-7e7d-49e1-8151-de39bf0132fe','2022-01-03 15:39:24'),(1,'c76d36b3-d2a5-419c-afd9-92c99e87e37b','334e3796-2c05-4f64-b13f-f1990ab701b2','2022-01-03 15:39:24'),(1,'c76d36b3-d2a5-419c-afd9-92c99e87e37b','450d7db4-e5ee-4fe9-88a6-b65e00b032df','2022-01-03 15:39:24'),(1,'c76d36b3-d2a5-419c-afd9-92c99e87e37b','5354bf8f-74c4-42b2-a829-6822ae8979e2','2022-01-03 15:39:24'),(1,'c76d36b3-d2a5-419c-afd9-92c99e87e37b','5b7c3a03-9f0d-49d3-b859-ed9692ce8fb6','2022-01-03 15:39:24'),(1,'c76d36b3-d2a5-419c-afd9-92c99e87e37b','b4a3a43f-41bb-4780-afd3-c3f736199be1','2022-01-03 15:39:24'),(1,'c76d36b3-d2a5-419c-afd9-92c99e87e37b','badf266e-7ea1-43ca-b4de-2ce3ba82d49b','2022-01-03 15:39:24'),(1,'c76d36b3-d2a5-419c-afd9-92c99e87e37b','c137e216-950d-4a32-9b10-78b14813f605','2022-01-03 15:39:24'),(1,'c76d36b3-d2a5-419c-afd9-92c99e87e37b','e52eb2e5-65fa-4080-9cae-4831a3eb3c77','2022-01-03 15:39:24'),(1,'c76d36b3-d2a5-419c-afd9-92c99e87e37b','f1159414-a4d8-4adb-bf40-52342b3d5c35','2022-01-03 15:39:24'),(1,'ded925c9-f5a3-49b1-a6f1-34630f63ba03','00949f49-2112-438f-a7cf-16567daf4658','2022-01-03 15:39:24'),(1,'ded925c9-f5a3-49b1-a6f1-34630f63ba03','141b2582-1df5-4a7d-89cf-ccbab45f4155','2022-01-03 15:39:24'),(1,'ded925c9-f5a3-49b1-a6f1-34630f63ba03','2383bba0-87fe-481a-bbcb-d1540b6805a2','2022-01-03 15:39:24'),(1,'ded925c9-f5a3-49b1-a6f1-34630f63ba03','3cba2a9d-7323-4c56-937f-158cfc5ee1c0','2022-01-03 15:39:24'),(1,'ded925c9-f5a3-49b1-a6f1-34630f63ba03','72428541-af45-4cf0-be15-cd0274461ceb','2022-01-03 15:39:24'),(1,'ded925c9-f5a3-49b1-a6f1-34630f63ba03','99670342-6f6e-46e9-8d35-3adf4203f7f4','2022-01-03 15:39:24'),(1,'ded925c9-f5a3-49b1-a6f1-34630f63ba03','a4da6ae7-e6b1-4233-b4b7-16ab46a3a583','2022-01-03 15:39:24'),(1,'ded925c9-f5a3-49b1-a6f1-34630f63ba03','b0011d4f-6ad0-4afd-a6b0-ce433db49361','2022-01-03 15:39:24'),(1,'ded925c9-f5a3-49b1-a6f1-34630f63ba03','b699290f-d6fe-401e-a793-6b18604533c8','2022-01-03 15:39:24'),(1,'ded925c9-f5a3-49b1-a6f1-34630f63ba03','d4150236-b82c-4908-adf8-69f0d41b5961','2022-01-03 15:39:24'),(1,'ded925c9-f5a3-49b1-a6f1-34630f63ba03','df6f2dc6-de60-43c3-a7bb-e06c5335636a','2022-01-03 15:39:24'),(1,'ded925c9-f5a3-49b1-a6f1-34630f63ba03','e619dbad-adce-4f7e-b837-ca7fd7666495','2022-01-03 15:39:24'),(1,'ded925c9-f5a3-49b1-a6f1-34630f63ba03','f4b8a19f-eba0-4417-a57a-89fa1c6eab26','2022-01-03 15:39:24'),(1,'ded925c9-f5a3-49b1-a6f1-34630f63ba03','f84ff04e-75d8-4176-98ed-63f9b3383b57','2022-01-03 15:39:24'),(1,'ded925c9-f5a3-49b1-a6f1-34630f63ba03','fee5320b-dbd2-488c-bcc3-77bce4985902','2022-01-03 15:39:24'),(1,'eebae158-466f-45dc-9779-e26080aa156b','40763224-3c07-4cb5-a069-00c19cffaa42','2022-01-03 15:39:23'),(1,'eebae158-466f-45dc-9779-e26080aa156b','8cb63af7-07d3-4452-9f1a-24c2e8ecd328','2022-01-03 15:39:23'),(1,'fa2449a7-de33-4026-aa63-d3575a79e2d8','0fac9836-d7ba-4ef6-bcc8-0b582f6f5b69','2022-01-03 15:39:25'),(1,'fa2449a7-de33-4026-aa63-d3575a79e2d8','36de5259-9328-483c-8c59-aad3134d4b2b','2022-01-03 15:39:25'),(1,'fa2449a7-de33-4026-aa63-d3575a79e2d8','a7c50e99-43ea-4e22-8f05-a92f9129705e','2022-01-03 15:39:25'),(1,'fa2449a7-de33-4026-aa63-d3575a79e2d8','d12e9220-7e1d-492a-8c7d-d3e7eb1527df','2022-01-03 15:39:25'),(1,'fa2449a7-de33-4026-aa63-d3575a79e2d8','e60c5885-6dfd-4101-8fd1-2ff1b07dc8ff','2022-01-03 15:39:25'),(1,'fa2449a7-de33-4026-aa63-d3575a79e2d8','ef7d0499-dc5c-42d3-abbd-909439dee43a','2022-01-03 15:39:25'),(1,'fef5bd39-4ccd-4ca3-bc6f-4c35e61cdafc','00d868a3-e0c3-4d2d-8272-33b916f8e95e','2022-01-03 15:39:25'),(1,'fef5bd39-4ccd-4ca3-bc6f-4c35e61cdafc','f222fe44-ede2-4bd6-b444-633492738f11','2022-01-03 15:39:25'),(1,'ffda89b0-5657-457b-8b38-c1326dca740c','07d4e99e-7817-425e-9888-6f9de3226805','2022-01-03 15:39:24'),(1,'ffda89b0-5657-457b-8b38-c1326dca740c','b4a3a43f-41bb-4780-afd3-c3f736199be1','2022-01-03 15:39:24');
/*!40000 ALTER TABLE `SentAttachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SentMessage`
--

DROP TABLE IF EXISTS `SentMessage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SentMessage` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `created` datetime DEFAULT NULL,
  `subject` varchar(45) NOT NULL,
  `body` text,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `discussionID` char(36) NOT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_SentMessage_Discussion` (`discussionID`,`ownerID`),
  CONSTRAINT `fk_SentMessage_Discussion` FOREIGN KEY (`discussionID`, `ownerID`) REFERENCES `Discussion` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SentMessage`
--

LOCK TABLES `SentMessage` WRITE;
/*!40000 ALTER TABLE `SentMessage` DISABLE KEYS */;
INSERT INTO `SentMessage` VALUES (1,'0c942d7a-6fb5-43cf-a802-052c7f80b387','2019-06-12 17:48:15','#','Commande n° 5.1.1.5',NULL,'2019-06-12 17:49:22','2019-06-12 15:49:22','2019-06-12 17:48:15','39edd03b-189b-4cd8-b553-4fa5e59235ec'),(1,'0e05e910-0cc5-4fd4-96f1-d4e298ccbc4c','2020-09-15 10:25:04','#','Commande n° 8.59.1.2',NULL,'2020-12-10 10:47:46','2020-12-10 09:47:46','2020-09-15 10:25:04','c96239ca-4da5-41fa-b243-e09fcb750abd'),(1,'101339aa-86de-4fb3-adae-6dc44fdd8d61','2019-06-12 17:54:17','#','Commande n° 5.1.1.7',NULL,'2019-08-29 12:17:45','2019-08-29 10:17:45','2019-06-12 17:54:17','c96239ca-4da5-41fa-b243-e09fcb750abd'),(1,'108c3067-e2b8-4fe8-b145-2b3155e7e15a','2020-12-01 15:05:15','Réponse depuis le web','hello\n',NULL,'2020-12-01 15:05:16','2020-12-01 14:05:16','2020-12-01 15:05:15','82ca34c0-5553-470e-9bed-5b7e9bedc4d9'),(1,'1502d93c-a9fa-4096-979b-eceaac0502e6','2019-04-03 11:48:41','Réponse depuis le web','Bonjour mon amis\n',NULL,'2019-04-03 11:48:42','2019-04-03 09:48:42','2019-04-03 11:48:41','39edd03b-189b-4cd8-b553-4fa5e59235ec'),(1,'16a21a42-d5a2-4370-9391-68a30516601b','2020-12-01 09:32:54','Réponse depuis le web','test\n',NULL,'2021-01-04 11:04:11','2021-01-04 10:04:11','2020-12-01 09:32:54','39edd03b-189b-4cd8-b553-4fa5e59235ec'),(1,'288e6127-d407-407a-9284-fb09da7d5193','2019-06-12 18:46:10','#','Commande n° 5.1.1.1',NULL,'2021-08-24 10:37:06','2021-08-24 08:37:06','2019-06-12 18:46:10','7a6abf78-0493-467d-acf2-d8e624ad83fc'),(1,'392b0c89-9c7f-47e2-938a-752c926b6b25','2021-09-13 12:12:41','#','test\n',NULL,'2021-09-13 12:12:43','2021-09-13 10:12:43','2021-09-13 12:12:41','b47ae547-86a7-4c5c-b72f-624874f4c8c5'),(1,'3fe5199e-6ffe-4ea8-a795-b9aeca9e1800','2020-03-11 14:47:17','#','Commande n° 6.22.1.1',NULL,'2020-03-11 14:47:19','2020-03-11 13:47:19','2020-03-11 14:47:17','3296fbec-fc91-45de-9488-4f4f7a526b6e'),(1,'5a31b6fe-83ec-4b7c-88c2-66801ebc08f9','2021-09-14 19:05:11','#','bien recu\n',NULL,'2021-09-14 19:05:12','2021-09-14 17:05:12','2021-09-14 19:05:11','b47ae547-86a7-4c5c-b72f-624874f4c8c5'),(1,'5a6f6f6e-b8b2-4b64-8ffd-89fca24060c6','2021-09-13 11:22:42','#','TEST ENVOI FICHIER\n',NULL,'2021-09-13 11:22:42','2021-09-13 09:22:42','2021-09-13 11:22:42','7a6abf78-0493-467d-acf2-d8e624ad83fc'),(1,'5b9d7ac8-d6f0-4ad6-b793-485d935a67e2','2019-11-26 16:57:08','#','Commande n° 8.55.1.5',NULL,'2019-11-27 08:00:28','2019-11-27 07:00:28','2019-11-26 16:57:08','3e3e6088-e3b5-4004-a58f-c314a2dd70b1'),(1,'6824c1c5-373b-4a49-93cf-4cba69bffc5e','2020-12-01 15:05:53','Réponse depuis le web','bien recu\n',NULL,'2020-12-01 15:05:54','2020-12-01 14:05:54','2020-12-01 15:05:53','82ca34c0-5553-470e-9bed-5b7e9bedc4d9'),(1,'6a85852a-9d31-4863-b5ba-c2095a5a6774','2019-05-22 17:38:48','Réponse depuis le web','hello\nit\'s me',NULL,'2019-05-22 17:38:49','2019-05-22 15:38:49','2019-05-22 17:38:48','39edd03b-189b-4cd8-b553-4fa5e59235ec'),(1,'6c1effc4-83b4-4434-afc2-2aafa42842e5','2019-11-26 18:19:06','#','Commande n° 8.1.1.1',NULL,'2019-11-27 08:00:28','2019-11-27 07:00:28','2019-11-26 18:19:06','3e3e6088-e3b5-4004-a58f-c314a2dd70b1'),(1,'6c5d43c3-7a19-47fe-b855-2759fb64f716','2019-11-26 15:24:36','#','Commande n° 3.2.1.1',NULL,'2019-11-26 15:24:39','2019-11-26 14:24:39','2019-11-26 15:24:36','3e3e6088-e3b5-4004-a58f-c314a2dd70b1'),(1,'721e0966-27f8-4c91-a6ee-4da1e5e5f3e3','2021-09-13 11:25:10','#','TEST2',NULL,'2021-09-13 11:25:10','2021-09-13 09:25:10','2021-09-13 11:25:10','7a6abf78-0493-467d-acf2-d8e624ad83fc'),(1,'752bf1c7-b7e4-4e36-bbf0-27f02064f3ba','2019-11-26 14:24:32','#','Commande n° 8.55.1.1',NULL,'2019-11-26 14:24:34','2019-11-26 13:24:34','2019-11-26 14:24:32','3296fbec-fc91-45de-9488-4f4f7a526b6e'),(1,'7840af82-ad7b-4086-8e4b-54f75f073c07','2019-06-12 17:47:05','#','Commande n° 5.1.1.4',NULL,'2019-06-12 18:47:51','2019-06-12 16:47:51','2019-06-12 17:47:05','39edd03b-189b-4cd8-b553-4fa5e59235ec'),(1,'8367b46f-0354-4dd1-9505-02911509cf14','2021-09-13 11:25:48','#','TEST ENVOI',NULL,'2021-09-13 11:25:50','2021-09-13 09:25:50','2021-09-13 11:25:48','82ca34c0-5553-470e-9bed-5b7e9bedc4d9'),(1,'87b19da2-e3b9-4859-8d9f-7ba3791adc02','2019-11-26 18:20:39','#','Commande n° 8.1.1.2',NULL,'2019-11-27 08:00:28','2019-11-27 07:00:28','2019-11-26 18:20:39','3e3e6088-e3b5-4004-a58f-c314a2dd70b1'),(1,'9f145309-dee9-44f1-8623-48d461ba64df','2019-11-27 17:30:36','#','#',NULL,'2019-11-27 17:30:36','2019-11-27 16:30:36','2019-11-27 17:30:36','3e3e6088-e3b5-4004-a58f-c314a2dd70b1'),(1,'a12a1f66-85ad-4891-ae0c-f17e464c1943','2019-11-26 15:02:37','#','Commande n° 8.56.1.1',NULL,'2019-11-26 15:04:32','2019-11-26 14:04:32','2019-11-26 15:02:37','3e3e6088-e3b5-4004-a58f-c314a2dd70b1'),(1,'aaa2e4aa-2659-44b3-9721-2396faa915c0','2019-06-12 17:42:37','#','Commande n° 5.1.1.2',NULL,'2019-06-12 17:43:06','2019-06-12 15:43:06','2019-06-12 17:42:37','39edd03b-189b-4cd8-b553-4fa5e59235ec'),(1,'b2b86dff-18bc-4daa-a2a4-be2967a12db6','2019-06-12 18:57:58','#','Commande n° 5.1.1.2',NULL,'2019-06-13 09:26:22','2019-06-13 07:26:22','2019-06-12 18:57:58','1e220661-7864-4e58-b9a0-adf6a924e40d'),(1,'bc9b9a32-0036-413c-af6e-db94d08209ac','2021-09-13 11:21:32','#','#',NULL,'2021-09-13 11:21:32','2021-09-13 09:21:32','2021-09-13 11:21:32','7a6abf78-0493-467d-acf2-d8e624ad83fc'),(1,'bed2294b-041c-4b05-8e6c-022f3aeda7c5','2020-07-20 14:29:29','#','Commande n° 10.2.1.1',NULL,'2020-08-26 10:35:54','2020-08-26 08:35:54','2020-07-20 14:29:29','39edd03b-189b-4cd8-b553-4fa5e59235ec'),(1,'c08ba604-d58d-46c2-8c14-c0acdce96582','2019-06-12 17:41:36','#','Commande n° 5.1.1.1',NULL,'2019-08-29 12:17:45','2019-08-29 10:17:45','2019-06-12 17:41:36','c96239ca-4da5-41fa-b243-e09fcb750abd'),(1,'c1d2fc8a-7720-4738-9cb2-b32ddff28fd9','2019-11-26 14:32:47','#','Commande n° 8.55.1.2',NULL,'2019-11-26 14:32:51','2019-11-26 13:32:51','2019-11-26 14:32:47','3e3e6088-e3b5-4004-a58f-c314a2dd70b1'),(1,'c1d963ee-f382-40a7-939a-6344da7bd4fe','2020-12-10 10:40:42','Réponse depuis le web','test\n',NULL,'2020-12-10 16:44:12','2020-12-10 15:44:12','2020-12-10 10:40:42','82ca34c0-5553-470e-9bed-5b7e9bedc4d9'),(1,'c34660b3-a141-4805-8f88-75295495458c','2019-08-06 13:59:21','#','Commande n° 7.3.1.1',NULL,'2021-08-24 10:37:06','2021-08-24 08:37:06','2019-08-06 13:59:21','7a6abf78-0493-467d-acf2-d8e624ad83fc'),(1,'c627fb8b-46e5-4641-af94-1ae862082418','2019-06-24 15:54:32','#','hello, peux tu me dire quand as tu envoyé le \"coucou\"?  Car moi il me dit qu\'il a été envoyé il y a 14min (nous somme actuellement le 24/06/2019 il est 15h54)',NULL,'2019-10-09 11:45:20','2019-10-09 09:45:20','2019-06-24 15:54:32','1e220661-7864-4e58-b9a0-adf6a924e40d'),(1,'c76d36b3-d2a5-419c-afd9-92c99e87e37b','2019-11-26 16:54:06','#','#',NULL,'2019-11-26 16:54:23','2019-11-26 15:54:23','2019-11-26 16:54:06','3e3e6088-e3b5-4004-a58f-c314a2dd70b1'),(1,'ded925c9-f5a3-49b1-a6f1-34630f63ba03','2019-11-27 07:55:24','#','Commande n° 8.59.1.1',NULL,'2019-11-27 08:00:28','2019-11-27 07:00:28','2019-11-27 07:55:24','3e3e6088-e3b5-4004-a58f-c314a2dd70b1'),(1,'eb124025-4abd-4b5e-b00e-91ea9bdb8a75','2019-06-06 10:27:56','#','yo :) ça va?',NULL,'2019-06-06 10:27:57','2019-06-06 08:27:57','2019-06-06 10:27:56','39edd03b-189b-4cd8-b553-4fa5e59235ec'),(1,'eebae158-466f-45dc-9779-e26080aa156b','2019-06-12 17:55:24','#','Commande n° 5.1.1.6',NULL,'2019-06-12 18:47:51','2019-06-12 16:47:51','2019-06-12 17:55:24','39edd03b-189b-4cd8-b553-4fa5e59235ec'),(1,'fa2449a7-de33-4026-aa63-d3575a79e2d8','2020-09-29 10:56:36','#','Commande n° 11.1.1.1',NULL,'2021-01-04 11:04:11','2021-01-04 10:04:11','2020-09-29 10:56:36','39edd03b-189b-4cd8-b553-4fa5e59235ec'),(1,'fef5bd39-4ccd-4ca3-bc6f-4c35e61cdafc','2019-08-07 16:17:01','#','Commande n° 7.3.2.2',NULL,'2021-08-24 10:37:06','2021-08-24 08:37:06','2019-08-07 16:17:01','7a6abf78-0493-467d-acf2-d8e624ad83fc'),(1,'ffda89b0-5657-457b-8b38-c1326dca740c','2019-11-26 14:31:21','#','#',NULL,'2019-11-26 14:31:35','2019-11-26 13:31:35','2019-11-26 14:31:21','3e3e6088-e3b5-4004-a58f-c314a2dd70b1');
/*!40000 ALTER TABLE `SentMessage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SentOrderNotification`
--

DROP TABLE IF EXISTS `SentOrderNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SentOrderNotification` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `orderID` char(36) DEFAULT NULL,
  `recipientID` char(36) DEFAULT NULL,
  `rescueData` text,
  `deliveryDate` datetime DEFAULT NULL,
  `event` enum('edited','validated','cancelled') NOT NULL DEFAULT 'edited',
  `unread` tinyint(1) NOT NULL DEFAULT '1',
  `createdAt` datetime NOT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_SentOrderNotification_Professional` (`ownerID`),
  KEY `fk_SentOrderNotification_Contact` (`recipientID`,`ownerID`),
  KEY `fk_SentOrderNotification_ProstheticOrder` (`orderID`,`ownerID`),
  CONSTRAINT `fk_SentOrderNotification_Contact` FOREIGN KEY (`recipientID`, `ownerID`) REFERENCES `Contact` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_SentOrderNotification_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_SentOrderNotification_ProstheticOrder` FOREIGN KEY (`orderID`, `ownerID`) REFERENCES `ProstheticOrder` (`id`, `ownerID`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SentOrderNotification`
--

LOCK TABLES `SentOrderNotification` WRITE;
/*!40000 ALTER TABLE `SentOrderNotification` DISABLE KEYS */;
/*!40000 ALTER TABLE `SentOrderNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Session`
--

DROP TABLE IF EXISTS `Session`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Session` (
  `ownerID` mediumint unsigned NOT NULL DEFAULT '0',
  `id` char(36) NOT NULL,
  `comments` mediumtext,
  `actID` char(36) NOT NULL,
  `globalDisplayID` mediumint unsigned DEFAULT NULL,
  `displayID` mediumint unsigned DEFAULT NULL,
  `mandibuleOcclusionPlyID` char(36) DEFAULT NULL,
  `maxillaireOcclusionPlyID` char(36) DEFAULT NULL,
  `matrixTransformationMandibuleID` char(36) DEFAULT NULL,
  `matrixTransformationMaxillaireID` char(36) DEFAULT NULL,
  `snapshotID` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `createdAt` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Occlusion_Work` (`actID`,`ownerID`),
  KEY `fk_Session_CondorFile_mandibulePly` (`mandibuleOcclusionPlyID`,`ownerID`),
  KEY `fk_Session_CondorFile_matrixTransformationMandibule` (`matrixTransformationMandibuleID`,`ownerID`),
  KEY `fk_Session_CondorFile_maxillairePly` (`maxillaireOcclusionPlyID`,`ownerID`),
  KEY `fk_Session_CondorFile_matrixTransformationMaxillaire` (`matrixTransformationMaxillaireID`,`ownerID`),
  KEY `fk_Session_CondorFile_maxillairePointContact` (`ownerID`),
  KEY `fk_Session_CondorFile_snapshot` (`snapshotID`,`ownerID`),
  CONSTRAINT `fk_Session_Act` FOREIGN KEY (`actID`, `ownerID`) REFERENCES `Act` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Session_CondorFile_mandibulePly` FOREIGN KEY (`mandibuleOcclusionPlyID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Session_CondorFile_matrixTransformationMandibule` FOREIGN KEY (`matrixTransformationMandibuleID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Session_CondorFile_matrixTransformationMaxillaire` FOREIGN KEY (`matrixTransformationMaxillaireID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Session_CondorFile_maxillairePly` FOREIGN KEY (`maxillaireOcclusionPlyID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Session_CondorFile_snapshot` FOREIGN KEY (`snapshotID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Session`
--

LOCK TABLES `Session` WRITE;
/*!40000 ALTER TABLE `Session` DISABLE KEYS */;
INSERT INTO `Session` VALUES (1,'7640d31d-0aef-46d3-a43a-3eff200a4ba6','Sous dossier 1','ef74541b-0f15-45e6-8b3a-a4aea68e4c21',9,1,NULL,NULL,NULL,NULL,NULL,NULL,'2022-01-03 16:39:27','2022-01-03 15:39:27','2022-01-03 16:39:18','2022-01-03 16:39:18');
/*!40000 ALTER TABLE `Session` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SharedOffices`
--

DROP TABLE IF EXISTS `SharedOffices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SharedOffices` (
  `ownerID` mediumint unsigned NOT NULL,
  `office1ID` char(36) NOT NULL,
  `office2ID` char(36) NOT NULL,
  `sharedDataType` enum('ALL','CONTACTS') NOT NULL DEFAULT 'CONTACTS',
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  PRIMARY KEY (`office1ID`,`office2ID`,`ownerID`),
  KEY `fk_SharedOffices_Office_1` (`office1ID`,`ownerID`),
  KEY `fk_SharedOffices_Office_2` (`office2ID`,`ownerID`),
  CONSTRAINT `fk_SharedOffices_Office_1` FOREIGN KEY (`office1ID`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_SharedOffices_Office_2` FOREIGN KEY (`office2ID`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SharedOffices`
--

LOCK TABLES `SharedOffices` WRITE;
/*!40000 ALTER TABLE `SharedOffices` DISABLE KEYS */;
/*!40000 ALTER TABLE `SharedOffices` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `SharedOffices_BEFORE_INSERT` BEFORE INSERT ON `SharedOffices` FOR EACH ROW BEGIN
    IF EXISTS (
		SELECT 1 FROM SharedOffices WHERE
		(office1ID=NEW.office2ID AND office2ID=NEW.office1ID)
		OR
		(office1ID=NEW.office1ID AND office2ID=NEW.office2ID)
	) THEN
        SIGNAL SQLSTATE '45000' SET MESSAGE_TEXT = 'Try to insert an existing pair of keys';
    END IF;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `SmilersOrder`
--

DROP TABLE IF EXISTS `SmilersOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SmilersOrder` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `actID` char(36) NOT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `title` varchar(64) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `status` enum('not_sent','waiting_wow_api','sending_wow_api','sending_smilers_api','sent','cancelled') NOT NULL DEFAULT 'waiting_wow_api',
  `createdAt` datetime NOT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `json` text NOT NULL,
  `metadata` text NOT NULL,
  `tag` varchar(250) DEFAULT NULL,
  `localDisplayID` int unsigned DEFAULT NULL,
  `globalDisplayID` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_SmilersOrder_Act` (`actID`,`ownerID`),
  CONSTRAINT `fk_SmilersOrder_Act` FOREIGN KEY (`actID`, `ownerID`) REFERENCES `Act` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SmilersOrder`
--

LOCK TABLES `SmilersOrder` WRITE;
/*!40000 ALTER TABLE `SmilersOrder` DISABLE KEYS */;
/*!40000 ALTER TABLE `SmilersOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SmilersOrderFile`
--

DROP TABLE IF EXISTS `SmilersOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SmilersOrderFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `orderID` char(36) NOT NULL,
  `fileID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`orderID`,`fileID`),
  KEY `fk_SmilersOrderFile_SmilersOrder` (`orderID`,`ownerID`),
  KEY `fk_SmilersOrderFile_CondorFile` (`fileID`,`ownerID`),
  CONSTRAINT `fk_SmilersOrderFile_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_SmilersOrderFile_SmilersOrder` FOREIGN KEY (`orderID`, `ownerID`) REFERENCES `SmilersOrder` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SmilersOrderFile`
--

LOCK TABLES `SmilersOrderFile` WRITE;
/*!40000 ALTER TABLE `SmilersOrderFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `SmilersOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SyncInfo`
--

DROP TABLE IF EXISTS `SyncInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SyncInfo` (
  `id` mediumint unsigned NOT NULL,
  `ownerID` mediumint unsigned NOT NULL,
  `patientsLastRetrieved` datetime DEFAULT NULL,
  `actsLastRetrieved` datetime DEFAULT NULL,
  `sessionsLastRetrieved` datetime DEFAULT NULL,
  `scansLastRetrieved` datetime DEFAULT NULL,
  `ordersLastRetrieved` datetime DEFAULT NULL,
  `assistantsLastRetrieved` datetime DEFAULT NULL,
  `contactsLastRetrieved` datetime DEFAULT NULL,
  `discussionsLastRetrieved` datetime DEFAULT NULL,
  `messagesLastRetrieved` datetime DEFAULT NULL,
  `notificationsLastRetrieved` datetime DEFAULT NULL,
  `occlusionsLastRetrieved` datetime DEFAULT NULL,
  `circleordersLastRetrieved` datetime DEFAULT NULL,
  `smilersordersLastRetrieved` datetime DEFAULT NULL,
  `prostheticSheetsLastRetrieved` datetime DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `idx_SyncInfo_Professional` (`ownerID`),
  CONSTRAINT `fk_SyncInfo_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SyncInfo`
--

LOCK TABLES `SyncInfo` WRITE;
/*!40000 ALTER TABLE `SyncInfo` DISABLE KEYS */;
INSERT INTO `SyncInfo` VALUES (1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,17,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,22,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,26,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,27,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,28,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,29,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,31,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,35,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,43,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,53,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,54,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `SyncInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SystemNotification`
--

DROP TABLE IF EXISTS `SystemNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SystemNotification` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `event` enum('no_connection_for_x_days') NOT NULL DEFAULT 'no_connection_for_x_days',
  `unread` tinyint(1) NOT NULL DEFAULT '1',
  `createdAt` datetime NOT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_SystemNotification_Professional` (`ownerID`),
  CONSTRAINT `fk_SystemNotification_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SystemNotification`
--

LOCK TABLES `SystemNotification` WRITE;
/*!40000 ALTER TABLE `SystemNotification` DISABLE KEYS */;
/*!40000 ALTER TABLE `SystemNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Token`
--

DROP TABLE IF EXISTS `Token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Token` (
  `id` char(36) NOT NULL,
  `ownerID` mediumint unsigned NOT NULL,
  `created` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `token` char(41) NOT NULL,
  `credentialsId` mediumint unsigned NOT NULL,
  `context` varchar(40) DEFAULT NULL,
  `device` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  UNIQUE KEY `un_Token` (`token`),
  KEY `fk_Token_Credentials` (`credentialsId`,`ownerID`),
  CONSTRAINT `fk_Token_Credentials` FOREIGN KEY (`credentialsId`, `ownerID`) REFERENCES `Credentials` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Token`
--

LOCK TABLES `Token` WRITE;
/*!40000 ALTER TABLE `Token` DISABLE KEYS */;
INSERT INTO `Token` VALUES ('acd6e08d-79f6-4a9c-8404-5e1640a59fd7',1,NULL,'2022-01-03 15:39:09','c10e9489d3d77662642aaf798c25aef67fb95e2d',1,NULL,NULL);
/*!40000 ALTER TABLE `Token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ToothInfo`
--

DROP TABLE IF EXISTS `ToothInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ToothInfo` (
  `ownerID` mediumint unsigned NOT NULL,
  `toothNumber` tinyint unsigned NOT NULL,
  `prostheticSheetID` char(36) NOT NULL,
  `toothColor` tinytext,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`toothNumber`,`prostheticSheetID`),
  KEY `idx_ToothInfo_Order` (`ownerID`),
  KEY `fk_ToothInfo_ProstheticSheet` (`prostheticSheetID`),
  CONSTRAINT `fk_ToothInfo_ProstheticSheet` FOREIGN KEY (`prostheticSheetID`) REFERENCES `ProstheticSheet` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ToothInfo`
--

LOCK TABLES `ToothInfo` WRITE;
/*!40000 ALTER TABLE `ToothInfo` DISABLE KEYS */;
/*!40000 ALTER TABLE `ToothInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `__db_version__`
--

DROP TABLE IF EXISTS `__db_version__`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `__db_version__` (
  `id` int NOT NULL AUTO_INCREMENT,
  `version_major` int NOT NULL DEFAULT '0',
  `version_minor` int NOT NULL DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `migration_file` varchar(1024) DEFAULT NULL,
  `commit` varchar(255) DEFAULT NULL,
  `version_core` varchar(255) DEFAULT NULL,
  `version_IHM` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `__db_version__`
--

LOCK TABLES `__db_version__` WRITE;
/*!40000 ALTER TABLE `__db_version__` DISABLE KEYS */;
INSERT INTO `__db_version__` VALUES (1,1,15,'v1.15','','','1.9.0','2.0.4'),(2,1,18,'v1.18','migration_fileconstraint_local','','1.9.0','2.0.4'),(3,1,19,'v1.19','migration_fileconstraint_local','','1.9.0','2.0.4'),(4,1,20,'v1.20','migration_globalDisplayID_local','','1.9','2.0.4'),(5,1,21,'v1.21','migration_config_show_open_stl_warning_local','','1.9','2.0.4'),(6,1,22,'v1.22','migration_resetcontact_local','','1.9','2.0.4'),(7,1,23,'v1.23','migration_token_context_device_local','','1.9','2.0.4'),(8,1,24,'v1.24','migration_config_lag_and_lost_sound_local','','1.9','2.0.4'),(9,1,25,'v1.25','migration_fix_unset_scan_creator_local','','1.9.0','2.0.4'),(10,1,26,'v1.26','migration_fix_wrong_original_files_local','','1.9.0','2.0.4'),(11,1,27,'v1.27','migration_occlusion_display_id_local','','1.9','2.0.4'),(12,1,28,'v1.28','migration_selfdiscussions_local','','1.9','2.0.4'),(13,1,29,'v1.29','migration_config_show_delete_confirmation_local','','1.9','2.0.4'),(14,1,30,'v1.30','migration_config_email_notifications_local','','1.9','2.0.4'),(15,1,31,'v1.31','migration_config_last_synced_local','','1.9','2.0.4'),(16,1,32,'v1.32','migration_lastmodified_local','','1.9','2.0.4'),(17,1,33,'v1.33','migration_config_add_fields_flip_local','','1.9','2.0.4'),(18,1,34,'v1.34','migration_unread_local','','1.9','2.0.4'),(19,1,35,'v1.35','migration_work_last_accessed_local','','1.9','2.0.4'),(20,1,36,'v1.36','migration_config_show_sync_info_local','','1.9','2.0.4'),(21,1,37,'v1.37','migration_config_clean_deprecated_fields_local','','1.9','2.0.4'),(22,1,38,'v1.38','migration_act_refonte_local','','1.9','2.0.4'),(23,1,39,'v1.39','migration_fix_duplicate_screenshot_path_local','','1.9','2.0.4'),(24,1,40,'v1.40','migration_rework_local','','1.9.0','2.0.4'),(25,1,41,'v1.41','migration_sync_info_local','','1.9.0','1.1-3'),(26,1,42,'v1.42','migration_config_popup_flip','','1.9','2.0.4'),(27,1,43,'v1.43','migration_mark_contacts_invisible_local','','1.9','3.2.1'),(28,1,44,'v1.44','migration_config_show_margin_lines_warning_local','','1.9','2.0.4'),(29,1,45,'v1.45','migration_contact_invitation_local','','1.9','2.3.0'),(30,1,46,'v1.46','migration_received_order_local','','1.9','3.3.0'),(31,1,47,'v1.47','migration_merge_discussions_local','','1.9','3.3.1'),(32,1,48,'v1.48','migration_office_rename_email_local','','1.9','3.3.1'),(33,1,49,'v1.49','migration_contact_cannot_reject_self_local','','1.9','3.3.1'),(34,1,50,'v1.50','migration_discussion_deletedat_not_null_local','','1.9','3.3.1'),(35,1,51,'v1.51','migration_reset_condor_file_trigger_local','','1.9','3.3.1'),(36,1,52,'v1.52','migration_system_notification_local','','1.9','2.3.0'),(37,1,53,'v1.53','migration_add_last_connection_checked_professional_local','','1.9','3.4.0'),(38,1,54,'v1.54','migration_endless_scans_local','','1.9','3.4.0'),(39,1,55,'v1.55','migration_rename_act_session_local','','1.9','3.4.0'),(40,1,56,'v1.56','migration_sessionId_local','','1.9','3.4.0'),(41,1,57,'v1.57','migration_session_created_at_local','','1.9','3.4.0'),(42,1,58,'v1.58','migration_order_display_id_local','','1.9','3.4.0'),(43,1,59,'v1.59','migration_pin_patient_local','','1.9','1.0.0'),(44,1,60,'v1.60','migration_enable_upload_local','','3.4.0','1.0.1'),(45,1,61,'v1.61','migration_remove_occlusion_contact_local','','3.4.1','1.1.0'),(46,1,62,'v1.62','migration_scanid_local','','3.4.1','1.1.0'),(47,1,63,'v1.63','migration_circleorder_local','','3.4.1','1.1.0'),(48,1,64,'v1.64','migration_smilersorder_local','','4.1.0','2.1.0'),(49,1,65,'v1.65','migration_demo_professional','','4.1.0','2.1.0'),(50,1,66,'v1.66','migration_tracking_rectangle','','4.1.0','2.1.1'),(51,1,67,'v1.67','migration_fix_status_circle_smilers','','4.1.0','2.1.1'),(52,1,68,'v1.68','migration_remove_scansID_session_local','','4.2.0','2.1.1'),(53,1,69,'v1.69','migration_externalize_occlusion_local','','4.2.0','2.1.1'),(54,1,70,'v1.70','migration_scan_occlusion_trigger_local','','4.2.0','2.1.1'),(55,1,74,'v1.74','migration_fix_xxxinfo_local','','4.3.0','2.2.3'),(56,1,71,'v1.71','migration_add_date_created_scan_local','','4.2.0','2.1.1'),(57,1,72,'v1.72','migration_scan_status_local','','4.2.0','2.1.1'),(58,1,73,'v1.73','migration_remove_patient_personnal_data_local','','4.2.0','2.1.1'),(59,1,75,'v1.75','migration_add_displayid_occlusion_local','','4.3.0','2.3.3'),(60,1,76,'v1.76','migration_add_table_ProstheticSheet_local','','4.4.0','2.3.4'),(61,1,77,'v1.77','migration_status_smilers_circle_local','','4.2.0','2.4.0'),(62,1,78,'v1.78','migration_condor_local_1.78_patient_theme','','4.4.0','2.4.0'),(63,1,79,'v1.79','migration_condor_local_1.79_fix_order_recipient','','4.5.0','2.4.4'),(64,1,80,'v1.80','migration_condor_local_1.80_fix_order','','4.5.0','2.4.4'),(65,1,81,'v1.81','migration_condor_local_1.81_fix_theme_null','','4.5.0','2.4.4');
/*!40000 ALTER TABLE `__db_version__` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping routines for database 'condor'
--
/*!50003 DROP FUNCTION IF EXISTS `generateid` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `generateid`(maxchars int) RETURNS char(36) CHARSET utf8mb3
BEGIN

  DECLARE AllChars char(16);
  DECLARE currentStr CHAR(36);
  DECLARE p1 int;
  
  SET AllChars = 'abcdef0123456789'; 
  SET currentStr = '';
  SET p1 = 0;

  charLoop: LOOP
  
    IF p1 < maxchars THEN
	  SET currentStr = CONCAT(currentStr, substring(AllChars, (RAND()*15)+1, 1));
	  SET p1 = p1 + 1;
      
      ITERATE charLoop;
    END IF;
    
    LEAVE charLoop;
    
  END LOOP charLoop;
  
  RETURN currentStr;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `drop_fk_if_exists` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `drop_fk_if_exists`(in theTable varchar(128), in theFKName varchar(128) )
BEGIN
 IF((SELECT COUNT(*) AS fk_exists
     FROM information_schema.table_constraints
     WHERE TABLE_SCHEMA = DATABASE() AND table_name = theTable AND constraint_name = theFKName AND constraint_type = 'FOREIGN KEY') > 0)
 THEN
   SET @s = CONCAT('ALTER TABLE ', theTable, ' DROP FOREIGN KEY ' , theFKName);
   PREPARE stmt FROM @s;
   EXECUTE stmt;
 END IF;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `drop_index_if_exists` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `drop_index_if_exists`(in theTable varchar(128), in theIndexName varchar(128) )
BEGIN
 IF((SELECT COUNT(*) AS index_exists
     FROM information_schema.statistics
     WHERE TABLE_SCHEMA = DATABASE() and table_name = theTable AND index_name = theIndexName) > 0)
 THEN
   SET @s = CONCAT('DROP INDEX ' , theIndexName , ' ON ' , theTable);
   PREPARE stmt FROM @s;
   EXECUTE stmt;
 END IF;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `fixOrderFrom176` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `fixOrderFrom176`()
    NO SQL
BEGIN
    SET @script_ok = (SELECT COUNT(*) FROM __db_version__ WHERE version_major = '1' AND version_minor = '76');

	IF (@script_ok = 0) THEN
        SET @count_bad_date = (SELECT COUNT(*) FROM ProstheticOrder WHERE createdAt IS NULL);
        IF (@count_bad_date > 0) THEN
            CALL `script176`();
        ELSE
            SET @count_bad_toothinfo = (SELECT COUNT(*) FROM ToothInfo WHERE prostheticSheetID = '');
            IF (@count_bad_toothinfo > 0) THEN
                DELETE FROM ToothInfo WHERE prostheticSheetID = '';

                ALTER TABLE ToothInfo ADD PRIMARY KEY (ownerID, toothNumber, prostheticSheetID);
                ALTER TABLE ToothInfo DROP COLUMN orderID;

                INSERT INTO `__db_version__`(`version_major`, `version_minor`, `title`, `commit`, `migration_file`, `version_core`, `version_IHM`) VALUES
                    (1, 76, 'v1.76', '', 'migration_condor_local_1.76_add_table_ProstheticSheet_from_180', '4.4.0', '2.3.4');
            END IF;
        END IF;
    END IF;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `FixOrderRecipient` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `FixOrderRecipient`()
    NO SQL
BEGIN
    DECLARE CurOrderOwnerID MEDIUMINT(8) UNSIGNED;
    DECLARE CurOrderUuid CHAR(36);
    DECLARE CurOrderId VARCHAR(255);

    DECLARE NbRecipient INT(8);
    DECLARE DID CHAR(36);
    DECLARE RecipientOwnerId MEDIUMINT(8) UNSIGNED;
    DECLARE RecipientContactId CHAR(36);

    DECLARE exit_loop BOOLEAN DEFAULT FALSE;

    DECLARE CUR CURSOR FOR
        SELECT ownerId, uuid, id
        FROM DebugOrderData
        WHERE id IS NOT NULL;

    DECLARE CONTINUE HANDLER FOR NOT FOUND SET exit_loop = TRUE;

    OPEN CUR;
    read_loop: LOOP
        FETCH CUR INTO CurOrderOwnerID, CurOrderUuid, CurOrderId;

        
        
        IF exit_loop THEN
            CLOSE CUR;
            LEAVE read_loop;
        END IF;

        SET NbRecipient = (SELECT COUNT(*) FROM ProstheticOrderRecipient WHERE orderID = CurOrderUuid);

        IF NbRecipient = 0 THEN
            SET DID = (SELECT discussionID FROM SentMessage WHERE LOCATE(CurOrderId, body) > 0);

            IF DID IS NOT NULL THEN
                SET RecipientOwnerId = (SELECT ownerID FROM Discussion WHERE id = DID AND ownerID != CurOrderOwnerID);

                IF RecipientOwnerId IS NOT NULL THEN
                    SET RecipientContactId = (SELECT id FROM Contact WHERE ownerID = CurOrderOwnerID AND professionalID = RecipientOwnerId);

                    IF RecipientContactId IS NOT NULL THEN
                        INSERT INTO ProstheticOrderRecipient VALUES (CurOrderOwnerID, CurOrderUuid , RecipientContactId, NOW());
                    END IF;
                END IF;
            END IF;
        END IF;
    END LOOP;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `getUsedScansForOcclusion` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `getUsedScansForOcclusion`()
    NO SQL
BLOCK1: BEGIN

  DECLARE CurFileID CHAR(36);
  DECLARE CurFileMetadata TEXT;
  DECLARE CurOwnerID MEDIUMINT(8) UNSIGNED;
  DECLARE CurFileTag TEXT;
  
  DECLARE exit_loop BOOLEAN DEFAULT FALSE;

  DECLARE read_sessionid TEXT;

  DECLARE CUR CURSOR FOR
          SELECT CondorFile.id, CondorFile.metadata, CondorFile.ownerID, CondorFile.tag
          FROM CondorFile WHERE tag LIKE '%_OCC_%' AND metadata LIKE '%"referenceScanID":"%' AND deletedAt IS NULL;
          
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET exit_loop = TRUE;

  OPEN CUR;
  read_loop: LOOP

	  FETCH CUR INTO CurFileID, CurFileMetadata, CurOwnerID, CurFileTag;

		IF exit_loop THEN
			CLOSE CUR;
			LEAVE read_loop;
		END IF;
		
    
		SET @refScanDelimiter = SUBSTRING_INDEX(CurFileMetadata, '"referenceScanID":"', -1); 
		SET @refScanID = SUBSTRING_INDEX(@refScanDelimiter, ':', 1);
        
		SET @actDelemiter = SUBSTRING_INDEX(CurFileTag, '_ACT_', -1); 
        SET @curActID = SUBSTRING_INDEX(@actDelemiter, '_', 1);
		SET @sessionDelemiter = SUBSTRING_INDEX(CurFileTag, '_SESS_', -1); 
        SET @curSessionID = SUBSTRING_INDEX(@sessionDelemiter, '_', 1);
        
        
        
		IF @curActID is NOT NULL AND @curSessionID is NOT NULL THEN
        
			SET @actOwnerID = (SELECT ownerID FROM Act WHERE id = @curActID);
			SET @sessionOwnerID = (SELECT ownerID FROM Session WHERE id = @curSessionID);
            
            
            IF @actOwnerID = CurOwnerID AND @sessionOwnerID = CurOwnerID THEN
            
				SET @scanNo = SUBSTRING_INDEX(@refScanID,'.',-1);
				SET @scanType = '';
				SET @findTopScan = CurFileTag LIKE '%_TOPLY_%';
				SET @findBottomScan = CurFileTag LIKE '%_BOPLY_%';
				
				IF @findTopScan > 0 THEN
					SET @scanType = 'MAXILLAIRE';
				ELSEIF @findBottomScan > 0 THEN
					SET @scanType = 'MANDIBULE';
				ELSE 
					ITERATE read_loop;
				END IF;
                 
                SET @scanID = (SELECT id FROM Scan WHERE ownerID = CurOwnerID AND sessionID = @curSessionID AND displayID = @scanNo AND scanType = @scanType AND deletedAt IS NULL );
				SET @occlusionID =  SUBSTRING_INDEX(SUBSTRING_INDEX(CurFileTag, '_OCC_', -1), '_', 1); 
				
				IF @occlusionID IS NULL THEN 
					ITERATE read_loop;
				END IF;
	
				IF @findTopScan > 0 THEN
					UPDATE Occlusion SET topScanID = @scanID WHERE id = @occlusionID;
				ELSEIF @findBottomScan > 0 THEN
					UPDATE Occlusion SET bottomScanID = @scanID WHERE id = @occlusionID;
				END IF; 
                
            END IF;
		
        END IF;
         
  END LOOP;

END BLOCK1 ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `migrateLifiOcclusionFiles` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `migrateLifiOcclusionFiles`()
    NO SQL
BEGIN

  DECLARE CurOwnerID MEDIUMINT(8) UNSIGNED;
  DECLARE CurFilePath TEXT;
  DECLARE CurFileID CHAR(36);
  DECLARE CurFileTag VARCHAR(250);
  DECLARE CurFileType VARCHAR(250);
  DECLARE CurFileMetadata TEXT;
  
  DECLARE exit_loop BOOLEAN DEFAULT FALSE;
  
  DECLARE read_sessionid TEXT;

  
  DECLARE CUR CURSOR FOR
          SELECT CondorFile.ownerID, CondorFile.id, CondorFile.tag, CondorFile.path, CondorFile.type, CondorFile.metadata
          FROM CondorFile
	  WHERE type LIKE '%LIFI%' AND metadata LIKE '%"isOcclusionMarginLine":true%' AND id NOT IN (SELECT fileID FROM ReceivedAttachment);

  DECLARE CONTINUE HANDLER FOR NOT FOUND SET exit_loop = TRUE;
  
  OPEN CUR;
  read_loop: LOOP

  FETCH CUR INTO CurOwnerID, CurFileID, CurFileTag, CurFilePath, CurFileType, CurFileMetadata;

	
	
	IF exit_loop THEN
		CLOSE CUR;
		LEAVE read_loop;
	END IF;
		
	SET @sessionDelimiter = SUBSTRING_INDEX(CurFileTag, '_SESS_', -1);
        SET @curSessionID = SUBSTRING_INDEX(@sessionDelimiter, '_', 1);
        
	SELECT ownerID, id INTO @occlusionOwnerID, @occlusionID FROM Occlusion WHERE sessionID = @curSessionID;
      
	
        
	IF @occlusionID IS NOT NULL AND @occlusionOwnerID = CurOwnerID THEN

		SET @pleft = SUBSTRING_INDEX(CurFileTag, @curSessionID, 1);
		SET @newTag = CONCAT(@pleft, @curSessionID, '_OCC_', @occlusionID, '_', CurFileType, 'O_', CurFileType, '_');
            
		SET @filename = SUBSTRING_INDEX(CurFilePath, '/', -1);
		SET @scanPath = SUBSTRING_INDEX(CurFilePath, '/', -2);
		SET @sessionPath = SUBSTRING_INDEX(CurFilePath, @scanPath, 1);
		SET @newFilePath = CONCAT(@sessionPath, 'computedocclusion_', @occlusionID, '/', @filename);

		UPDATE CondorFile SET tag = @newTag, path = @newFilePath WHERE id = CurFileID;
             
		
		INSERT INTO OcclusionFile(ownerID, fileID, occlusionID, lastUpdated)
		VALUES (CurOwnerID, CurFileID, @occlusionID, CURRENT_TIMESTAMP);

		
		SET @scanID = (SELECT scanID FROM ScanFile WHERE fileID = CurFileID);

		IF @scanID IS NOT NULL THEN
			SET @scanType = (SELECT scanType FROM Scan WHERE id = @scanID);

			IF @scanType is not NULL THEN
				SET @currentMetadata = SUBSTRING_INDEX(CurFileMetadata, '}', 1);
				SET @lifiScanType = CONCAT('"lifi_scan_type":"', @scanType, '"');
				SET @newMetadata = CONCAT(@currentMetadata, ',', @lifiScanType, '}');

				UPDATE CondorFile SET metadata = @newMetadata WHERE id = CurFileID;
			END IF;

		END IF;

            
            DELETE FROM ScanFile WHERE fileID = CurFileID;

	END IF;

  END LOOP;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `migrateOcclusions` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `migrateOcclusions`()
    NO SQL
BEGIN
  DECLARE CurOwnerID MEDIUMINT(8) UNSIGNED;
  DECLARE CurSessionID CHAR(36);
  DECLARE CurMandibuleOcclusionPlyID CHAR(36);
  DECLARE CurMaxillaireOcclusionPlyID CHAR(36);
  DECLARE CurMatrixTransformationMandibuleID CHAR(36);
  DECLARE CurMatrixTransformationMaxillaireID CHAR(36);
  DECLARE CurSnapshotID CHAR(36);
  
  
  DECLARE TopScanID CHAR(36);
  DECLARE BottomScanID CHAR(36);
  DECLARE CheckIntegrity BOOLEAN DEFAULT FALSE;

  DECLARE NewOcclusionID CHAR(36);
  DECLARE exit_loop BOOLEAN DEFAULT FALSE;

  
  DECLARE CUR CURSOR FOR
          SELECT Session.ownerID, Session.id, Session.mandibuleOcclusionPlyID, Session.maxillaireOcclusionPlyID,
					Session.matrixTransformationMandibuleID, Session.matrixTransformationMaxillaireID, Session.snapshotID
          FROM Session WHERE deletedAt IS NULL AND mandibuleOcclusionPlyID IS NOT NULL AND maxillaireOcclusionPlyID IS NOT NULL AND
					matrixTransformationMandibuleID IS NOT NULL AND matrixTransformationMaxillaireID IS NOT NULL AND snapshotID IS NOT NULL;
          
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET exit_loop = TRUE;

  OPEN CUR;
  read_loop: LOOP

  FETCH CUR INTO CurOwnerID, CurSessionID, CurMandibuleOcclusionPlyID, CurMaxillaireOcclusionPlyID,
					CurMatrixTransformationMandibuleID, CurMatrixTransformationMaxillaireID, CurSnapshotID;

    
    
    IF exit_loop THEN
	CLOSE CUR;
	LEAVE read_loop;
    END IF;

	SET TopScanID = (SELECT scanID from ScanFile WHERE fileID = CurMaxillaireOcclusionPlyID);
    SET BottomScanID = (SELECT scanID from ScanFile WHERE fileID = CurMandibuleOcclusionPlyID);

    
	
	

	
	
    
    SET NewOcclusionID = concat(left(CurSessionID, length(CurSessionID) - 9), 'migraoccl');
	
	INSERT INTO Occlusion(ownerID, id, sessionID, occlusionType, deletedAt, createdAt, lastSynced, lastModified, lastUpdated, topScanID, bottomScanID, 
							anteriorBiteScanID, rightBiteScanID, leftBiteScanID, snapshotID, mandibuleOcclusionPlyID, maxillaireOcclusionPlyID, matrixTransformationMandibuleID, 
							matrixTransformationMaxillaireID)
							VALUES (CurOwnerID, NewOcclusionID, CurSessionID, NULL, NULL, CURRENT_TIMESTAMP, NULL, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP, TopScanID, BottomScanID,
							NULL, NULL, NULL, CurSnapshotID, CurMandibuleOcclusionPlyID, CurMaxillaireOcclusionPlyID, CurMatrixTransformationMandibuleID,
							CurMatrixTransformationMaxillaireID);
	
	
	INSERT INTO OcclusionFile(ownerID, fileID, occlusionID, lastUpdated)
							VALUES (CurOwnerID, CurMandibuleOcclusionPlyID, NewOcclusionID, CURRENT_TIMESTAMP);
	INSERT INTO OcclusionFile(ownerID, fileID, occlusionID, lastUpdated)
							VALUES (CurOwnerID, CurMaxillaireOcclusionPlyID, NewOcclusionID, CURRENT_TIMESTAMP);
	INSERT INTO OcclusionFile(ownerID, fileID, occlusionID, lastUpdated)
							VALUES (CurOwnerID, CurMatrixTransformationMandibuleID, NewOcclusionID, CURRENT_TIMESTAMP);
	INSERT INTO OcclusionFile(ownerID, fileID, occlusionID, lastUpdated)
							VALUES (CurOwnerID, CurMatrixTransformationMaxillaireID, NewOcclusionID, CURRENT_TIMESTAMP);
	INSERT INTO OcclusionFile(ownerID, fileID, occlusionID, lastUpdated)
							VALUES (CurOwnerID, CurSnapshotID, NewOcclusionID, CURRENT_TIMESTAMP);          
    


  END LOOP;
  
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `script176` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `script176`()
    NO SQL
BEGIN
    
    DROP TABLE IF EXISTS `ProstheticSheet`;
    CREATE TABLE `ProstheticSheet` (
        `id` char(36) NOT NULL,
        `ownerID` mediumint(8) unsigned NOT NULL,
        `orderID` char(36) NOT NULL,
        `json` TEXT NOT NULL,
        `pdfFileID` char(36) DEFAULT NULL,
        `dateCreated` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
        `deletedAt` datetime DEFAULT NULL,
        `lastSynced` datetime DEFAULT NULL,
        `lastModified` datetime NOT NULL,
        `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`,`ownerID`),
        CONSTRAINT `fk_ProstheticSheet_ProstheticOrder` FOREIGN KEY (`orderID`) REFERENCES `ProstheticOrder` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
        CONSTRAINT `fk_ProstheticSheet_CondorFile` FOREIGN KEY (`pdfFileID`) REFERENCES `CondorFile` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

    
    UPDATE ProstheticOrder SET createdAt = lastUpdated WHERE createdAt IS NULL;

    
    INSERT INTO ProstheticSheet (id, ownerID, orderID, json, dateCreated, deletedAt, lastSynced, lastModified, lastUpdated)
    SELECT
        PO.id as id,
        PO.ownerID,
        PO.id as orderID,
        CONCAT('{"sheetTitle":"', PO.title, '",', RIGHT(PO.json, LENGTH(PO.json)-1)), 
        PO.createdAt as dateCreated,
        PO.deletedAt,
        PO.lastSynced,
        PO.lastModified,
        PO.lastUpdated
    FROM ProstheticOrder AS PO;

    CREATE TEMPORARY TABLE PDF_ID_TMP
    SELECT POF1.orderID, POF1.fileID, CF1.version, T.maxVersion
    FROM ProstheticOrderFile AS POF1
    INNER JOIN CondorFile AS CF1 ON POF1.fileID = CF1.id
    INNER JOIN (
        SELECT POF2.orderID, MAX(CF2.version) AS maxVersion
        FROM ProstheticOrderFile AS POF2
        INNER JOIN CondorFile AS CF2 ON POF2.fileID = CF2.id
        WHERE CF2.type = 'PDF'
        GROUP BY POF2.orderID
    ) T ON POF1.orderID = T.orderID
    WHERE CF1.type = 'PDF' AND CF1.version = T.maxVersion;

    UPDATE ProstheticSheet AS PS
    INNER JOIN PDF_ID_TMP AS PDF ON PDF.orderID = PS.orderID
    SET PS.pdfFileID = PDF.fileID;

    DROP TEMPORARY TABLE PDF_ID_TMP;

    
    
    

    ALTER TABLE SyncInfo ADD prostheticSheetsLastRetrieved DATETIME NULL AFTER smilersordersLastRetrieved;

    ALTER TABLE ProstheticOrder DROP COLUMN json;

    ALTER TABLE ToothInfo ADD prostheticSheetID char(36) NOT NULL AFTER toothNumber;

    UPDATE ToothInfo AS TI
    INNER JOIN ProstheticSheet AS PS on TI.orderID = PS.orderID
    SET TI.prostheticSheetID = PS.id;

    
    
    

    
    ALTER TABLE ToothInfo DROP FOREIGN KEY fk_ToothInfo_Order;

    
    ALTER TABLE ToothInfo ADD CONSTRAINT `fk_ToothInfo_ProstheticSheet` FOREIGN KEY (`prostheticSheetID`) REFERENCES `ProstheticSheet` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

    ALTER TABLE ToothInfo DROP PRIMARY KEY;
    ALTER TABLE ToothInfo ADD PRIMARY KEY (ownerID, toothNumber, prostheticSheetID);

    ALTER TABLE ToothInfo DROP COLUMN orderID;

    
    
    

    INSERT INTO `__db_version__`(`version_major`, `version_minor`, `title`, `commit`, `migration_file`, `version_core`, `version_IHM`) VALUES
    (1, 76, 'v1.76', '', 'migration_condor_local_1.76_add_table_ProstheticSheet_from_180', '4.4.0', '2.3.4');

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `updateOcclusionsCondorFilesTag` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `updateOcclusionsCondorFilesTag`()
    NO SQL
BEGIN

  DECLARE CurFilePath TEXT;
  DECLARE CurFileID CHAR(36);
  DECLARE CurFileTag VARCHAR(250);
  DECLARE exit_loop BOOLEAN DEFAULT FALSE;
  
  DECLARE read_sessionid TEXT;

  
  DECLARE CUR CURSOR FOR
          SELECT CondorFile.id, CondorFile.tag, CondorFile.path
          FROM CondorFile 
	  WHERE tag REGEXP '_TOMA_|_BOMA_|_TOPLY_|_BOPLY_|_SNAPO_' AND id NOT IN (SELECT fileID FROM ReceivedAttachment);

  DECLARE CONTINUE HANDLER FOR NOT FOUND SET exit_loop = TRUE;

  OPEN CUR;
  read_loop: LOOP

  FETCH CUR INTO CurFileID, CurFileTag, CurFilePath;

	
	
	IF exit_loop THEN
		CLOSE CUR;
		LEAVE read_loop;
	END IF;
		
        SET @sessionDelimiter = SUBSTRING_INDEX(CurFileTag, '_SESS_', -1); 
        SET @curSessionID = SUBSTRING_INDEX(@sessionDelimiter, '_', 1);
        
        
	Set @occlusionID = (SELECT id FROM Occlusion WHERE sessionID = @curSessionID AND deletedAt IS NULL);
      
	IF @occlusionID is not NULL THEN

		SET @pleft = SUBSTRING_INDEX(CurFileTag, @curSessionID, 1); 
		SET @pright = SUBSTRING_INDEX(CurFileTag, @curSessionID, -1); 
		SET @newTag = CONCAT(@pleft, @curSessionID, '_OCC_', @occlusionID, @pright);

		SET @filename = SUBSTRING_INDEX(CurFilePath, '/', -1);
		SET @sessionPath = SUBSTRING_INDEX(CurFilePath, @filename, 1);
		SET @newFilePath = CONCAT(@sessionPath, 'computedocclusion_', @occlusionID, '/', @filename);

		UPDATE CondorFile SET tag = @newTag, path = @newFilePath WHERE id = CurFileID;
        END IF;
        
  END LOOP;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `updateScanDisplayID` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `updateScanDisplayID`()
    NO SQL
BEGIN
  DECLARE CurOwnerID MEDIUMINT(8) UNSIGNED;
  DECLARE CurID CHAR(36);
  DECLARE CurSessionID CHAR(36);
  DECLARE CurLastSync DATETIME;

  DECLARE CurScanType
  ENUM('MAXILLAIRE', 'MANDIBULE', 'MORDU_ANTERIEUR', 'MORDU_POSTERIEUR_GAUCHE', 'MORDU_POSTERIEUR_DROIT');

  DECLARE CurNbSyncScan INT;
  DECLARE CurMaxDisplayID INT;

  DECLARE exit_loop BOOLEAN DEFAULT FALSE;

  DECLARE CUR CURSOR FOR
          SELECT Scan.ownerID, Scan.id, Scan.sessionID, Scan.scanType, Scan.lastSynced
          FROM Scan;

  DECLARE CONTINUE HANDLER FOR NOT FOUND SET exit_loop = TRUE;

  OPEN CUR;
  read_loop: LOOP

  FETCH CUR INTO CurOwnerID, CurID, CurSessionID, CurScanType, CurLastSync;

    
    
    IF exit_loop THEN
	CLOSE CUR;
	LEAVE read_loop;
    END IF;

    IF CurLastSync IS NULL THEN

	SET CurNbSyncScan = (SELECT COUNT(*)
				FROM Scan
				WHERE ownerID = CurOwnerID AND sessionID = CurSessionID AND scanType = CurScanType AND lastSynced IS NOT NULL);


	SET CurMaxDisplayID = (SELECT MAX(displayID)
				FROM Scan
				WHERE ownerID = CurOwnerID AND sessionID = CurSessionID AND scanType = CurScanType);

    	IF CurMaxDisplayID IS NULL OR CurMaxDisplayID = 0 THEN
		
        	SET CurMaxDisplayID = CurNbSyncScan;
    	END IF;

    	UPDATE Scan
    	SET displayID = (CurMaxDisplayID + 1)
    	WHERE ownerID = CurOwnerID AND id = CurID;

    END IF;

  END LOOP;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2022-01-04 12:46:02
