-- MySQL dump 10.13  Distrib 8.0.30, for Linux (x86_64)
--
-- Host: localhost    Database: condor_client_local
-- ------------------------------------------------------
-- Server version	8.0.30-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `Camera`
--

DROP TABLE IF EXISTS `Camera`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Camera` (
  `reference` char(13) NOT NULL,
  PRIMARY KEY (`reference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Camera`
--

LOCK TABLES `Camera` WRITE;
/*!40000 ALTER TABLE `Camera` DISABLE KEYS */;
INSERT INTO `Camera` VALUES ('1530010CR0267'),('1530010CR0295'),('1536010CR1615'),('1918020WO0318'),('1928021WO0705'),('2005021WO1323'),('2049022WO1716'),('2049022WO1800'),('2118022WO2142'),('2118022WO2521');
/*!40000 ALTER TABLE `Camera` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CameraAccess`
--

DROP TABLE IF EXISTS `CameraAccess`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CameraAccess` (
  `professionalID` mediumint unsigned NOT NULL,
  `computerMac` char(17) NOT NULL,
  `cameraReference` char(13) NOT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`professionalID`,`computerMac`,`cameraReference`),
  KEY `fk_CameraAccess_Professional_idx` (`professionalID`),
  KEY `fk_CameraAccess_Computer_idx` (`computerMac`),
  KEY `fk_CameraAccess_Camera_idx` (`cameraReference`),
  CONSTRAINT `fk_CameraAccess_Camera` FOREIGN KEY (`cameraReference`) REFERENCES `Camera` (`reference`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_CameraAccess_Computer` FOREIGN KEY (`computerMac`) REFERENCES `Computer` (`mac`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_CameraAccess_Professional` FOREIGN KEY (`professionalID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CameraAccess`
--

LOCK TABLES `CameraAccess` WRITE;
/*!40000 ALTER TABLE `CameraAccess` DISABLE KEYS */;
INSERT INTO `CameraAccess` VALUES (59,'00:d8:61:08:36:d5','1530010CR0267','2022-03-29 10:10:26','2022-03-29 08:10:26'),(59,'00:d8:61:08:36:d5','1530010CR0295','2021-10-28 10:15:10','2021-10-28 08:15:10'),(59,'00:d8:61:08:36:d5','1536010CR1615','2022-04-05 11:12:59','2022-04-05 09:12:59'),(59,'00:d8:61:08:36:d5','1918020WO0318','2021-11-10 09:36:35','2021-11-10 08:36:35'),(59,'00:d8:61:08:36:d5','1928021WO0705','2022-06-08 16:39:30','2022-06-08 14:39:30'),(59,'00:d8:61:08:36:d5','2005021WO1323','2021-10-28 10:17:30','2021-10-28 08:17:30'),(59,'00:d8:61:08:36:d5','2049022WO1716','2021-10-15 10:38:11','2021-10-15 08:38:11'),(59,'00:d8:61:08:36:d5','2049022WO1800','2022-05-25 10:37:00','2022-05-25 08:37:00'),(59,'00:d8:61:08:36:d5','2118022WO2142','2022-06-16 14:58:07','2022-06-16 12:58:07'),(59,'00:d8:61:08:36:d5','2118022WO2521',NULL,'2022-07-06 12:59:33');
/*!40000 ALTER TABLE `CameraAccess` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Computer`
--

DROP TABLE IF EXISTS `Computer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Computer` (
  `mac` char(17) NOT NULL,
  `condorVersionID` varchar(16) DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastSynced` datetime DEFAULT NULL,
  `graphicsCard` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`mac`),
  KEY `fk_Computer_CondorVersion_idx` (`condorVersionID`),
  CONSTRAINT `fk_Computer_CondorVersion` FOREIGN KEY (`condorVersionID`) REFERENCES `CondorVersion` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Computer`
--

LOCK TABLES `Computer` WRITE;
/*!40000 ALTER TABLE `Computer` DISABLE KEYS */;
INSERT INTO `Computer` VALUES ('00:d8:61:08:36:d5','v3.0.1','2022-03-25 15:01:03','2022-03-25 16:01:03','NVIDIA GeForce RTX 2070 with Max-Q Design');
/*!40000 ALTER TABLE `Computer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CondorVersion`
--

DROP TABLE IF EXISTS `CondorVersion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CondorVersion` (
  `id` varchar(16) NOT NULL,
  `db_version` varchar(10) DEFAULT NULL,
  `ihm_version` varchar(10) DEFAULT NULL,
  `core_version` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CondorVersion`
--

LOCK TABLES `CondorVersion` WRITE;
/*!40000 ALTER TABLE `CondorVersion` DISABLE KEYS */;
INSERT INTO `CondorVersion` VALUES ('v2.4.4',NULL,NULL,NULL),('v3.0.1',NULL,NULL,NULL);
/*!40000 ALTER TABLE `CondorVersion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `License`
--

DROP TABLE IF EXISTS `License`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `License` (
  `number` char(23) NOT NULL,
  `professionalID` mediumint unsigned DEFAULT NULL,
  `enabled` enum('NONE','SOFTWARE','WEB','ALL') NOT NULL DEFAULT 'ALL',
  `licenseType` enum('PROD','DEMO') NOT NULL DEFAULT 'PROD',
  PRIMARY KEY (`number`),
  UNIQUE KEY `uq_professional` (`professionalID`),
  KEY `fk_License_Professional_idx` (`professionalID`),
  CONSTRAINT `fk_License_Professional` FOREIGN KEY (`professionalID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `License`
--

LOCK TABLES `License` WRITE;
/*!40000 ALTER TABLE `License` DISABLE KEYS */;
INSERT INTO `License` VALUES ('XYDDFLNKKXU8Z2MY6F8UK9J',59,'ALL','PROD');
/*!40000 ALTER TABLE `License` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `LicenseAccess`
--

DROP TABLE IF EXISTS `LicenseAccess`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LicenseAccess` (
  `professionalID` mediumint unsigned NOT NULL,
  `licenseNumber` char(23) NOT NULL,
  `computerMac` char(17) NOT NULL,
  `condorVersionID` varchar(16) NOT NULL,
  `globalID` mediumint unsigned DEFAULT NULL,
  `status` enum('VALID','REPAIR') NOT NULL DEFAULT 'VALID',
  `activationDate` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`professionalID`,`licenseNumber`,`computerMac`),
  KEY `fk_LicenseAccess_Computer_idx` (`computerMac`),
  KEY `fk_LicenseAccess_License_idx` (`licenseNumber`),
  KEY `fk_LicenseAccess_CondorVersion_idx` (`condorVersionID`),
  CONSTRAINT `fk_LicenseAccess_Computer` FOREIGN KEY (`computerMac`) REFERENCES `Computer` (`mac`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_LicenseAccess_CondorVersion` FOREIGN KEY (`condorVersionID`) REFERENCES `CondorVersion` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_LicenseAccess_License` FOREIGN KEY (`licenseNumber`) REFERENCES `License` (`number`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_LicenseAccess_Professional` FOREIGN KEY (`professionalID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LicenseAccess`
--

LOCK TABLES `LicenseAccess` WRITE;
/*!40000 ALTER TABLE `LicenseAccess` DISABLE KEYS */;
INSERT INTO `LicenseAccess` VALUES (59,'XYDDFLNKKXU8Z2MY6F8UK9J','00:d8:61:08:36:d5','v3.0.1',1,'VALID','2021-10-15 00:00:00','2022-03-02 17:01:01','2022-03-02 16:01:01');
/*!40000 ALTER TABLE `LicenseAccess` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Professional`
--

DROP TABLE IF EXISTS `Professional`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Professional` (
  `id` mediumint unsigned NOT NULL,
  `firstName` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `mainPhone` varchar(45) DEFAULT NULL,
  `country` varchar(75) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Professional`
--

LOCK TABLES `Professional` WRITE;
/*!40000 ALTER TABLE `Professional` DISABLE KEYS */;
INSERT INTO `Professional` VALUES (59,'SABINE','CASERTA','0645636587','France');
/*!40000 ALTER TABLE `Professional` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `__db_version__`
--

DROP TABLE IF EXISTS `__db_version__`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `__db_version__` (
  `id` int NOT NULL AUTO_INCREMENT,
  `version_major` int NOT NULL DEFAULT '0',
  `version_minor` int NOT NULL DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `migration_file` varchar(1024) DEFAULT NULL,
  `commit` varchar(255) DEFAULT NULL,
  `version_core` varchar(255) DEFAULT NULL,
  `version_IHM` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `__db_version__`
--

LOCK TABLES `__db_version__` WRITE;
/*!40000 ALTER TABLE `__db_version__` DISABLE KEYS */;
INSERT INTO `__db_version__` VALUES (1,1,9,'v1.9','migration_demo_professional','','4.1.0','2.1.1'),(2,1,10,'v1.10','migration_condor_client_local_1.10_fix_wow_data','','5.0.0','3.0.1'),(3,1,11,'v1.11','migration_condor_client_local_1.11_update_country','','5.0.0','3.0.1');
/*!40000 ALTER TABLE `__db_version__` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping routines for database 'condor_client_local'
--
/*!50003 DROP PROCEDURE IF EXISTS `createUser` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `createUser`()
    NO SQL
BEGIN

	DECLARE UserExists INT;

	SET UserExists = (SELECT EXISTS(SELECT 1 FROM `mysql`.user WHERE user = 'CondorCliLocal'));

	IF UserExists = 0 THEN
		CREATE USER 'CondorCliLocal'@'localhost' IDENTIFIED BY 'tKzCcv25wtmCeBbY6ZivVHZu';
	END IF;
	
	GRANT ALL PRIVILEGES ON condor_client_local.* TO 'CondorCliLocal'@'localhost';

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2022-09-20 10:45:35
