-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: wow_client
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `Camera`
--

DROP TABLE IF EXISTS `Camera`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Camera` (
  `reference` char(13) NOT NULL,
  PRIMARY KEY (`reference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Camera`
--

LOCK TABLES `Camera` WRITE;
/*!40000 ALTER TABLE `Camera` DISABLE KEYS */;
INSERT INTO `Camera` VALUES ('1530010CR0267'),('1530010CR0295'),('1536010CR1615'),('1918020WO0318'),('1928021WO0705'),('2005021WO1323'),('2049022WO1716'),('2049022WO1800'),('2118022WO1963'),('2118022WO1986'),('2118022WO2142'),('2118022WO2211'),('2118022WO2365'),('2118022WO2371'),('2118022WO2410'),('2118022WO2521');
/*!40000 ALTER TABLE `Camera` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CameraAccess`
--

DROP TABLE IF EXISTS `CameraAccess`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CameraAccess` (
  `professionalId` mediumint unsigned NOT NULL,
  `computerMac` char(17) NOT NULL,
  `cameraReference` char(13) NOT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`professionalId`,`computerMac`,`cameraReference`),
  KEY `computerMac` (`computerMac`),
  KEY `cameraReference` (`cameraReference`),
  CONSTRAINT `CameraAccess_ibfk_1` FOREIGN KEY (`professionalId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `CameraAccess_ibfk_2` FOREIGN KEY (`computerMac`) REFERENCES `Computer` (`mac`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `CameraAccess_ibfk_3` FOREIGN KEY (`cameraReference`) REFERENCES `Camera` (`reference`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CameraAccess`
--

LOCK TABLES `CameraAccess` WRITE;
/*!40000 ALTER TABLE `CameraAccess` DISABLE KEYS */;
INSERT INTO `CameraAccess` VALUES (59,'00:d8:61:08:36:d5','1530010CR0267','2022-03-29 08:10:26.000','2022-03-29 10:10:26.000'),(59,'00:d8:61:08:36:d5','1530010CR0295','2021-10-28 08:15:10.000','2021-10-28 10:15:10.000'),(59,'00:d8:61:08:36:d5','1536010CR1615','2022-04-05 09:12:59.000','2022-04-05 11:12:59.000'),(59,'00:d8:61:08:36:d5','1918020WO0318','2021-11-10 08:36:35.000','2021-11-10 09:36:35.000'),(59,'00:d8:61:08:36:d5','1928021WO0705','2022-06-08 14:39:30.000','2022-06-08 16:39:30.000'),(59,'00:d8:61:08:36:d5','2005021WO1323','2021-10-28 08:17:30.000','2021-10-28 10:17:30.000'),(59,'00:d8:61:08:36:d5','2049022WO1716','2021-10-15 08:38:11.000','2021-10-15 10:38:11.000'),(59,'00:d8:61:08:36:d5','2049022WO1800','2022-05-25 08:37:00.000','2022-05-25 10:37:00.000'),(59,'00:d8:61:08:36:d5','2118022WO1963','2023-01-11 10:12:57.674','2023-01-11 11:12:57.676'),(59,'00:d8:61:08:36:d5','2118022WO1986','2022-12-12 16:42:58.361','2022-12-12 17:42:58.363'),(59,'00:d8:61:08:36:d5','2118022WO2142','2022-06-16 12:58:07.000','2022-06-16 14:58:07.000'),(59,'00:d8:61:08:36:d5','2118022WO2211','2022-11-29 09:54:54.736','2022-11-29 10:54:54.775'),(59,'00:d8:61:08:36:d5','2118022WO2365','2023-01-30 10:24:52.624','2023-01-30 11:24:52.662'),(59,'00:d8:61:08:36:d5','2118022WO2371','2023-01-30 10:33:36.332','2023-01-30 11:33:36.371'),(59,'00:d8:61:08:36:d5','2118022WO2410','2023-03-21 08:34:08.096','2023-03-21 09:34:09.271'),(59,'00:d8:61:08:36:d5','2118022WO2521','2022-07-06 12:59:33.000',NULL);
/*!40000 ALTER TABLE `CameraAccess` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Computer`
--

DROP TABLE IF EXISTS `Computer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Computer` (
  `mac` char(76) NOT NULL,
  `condorVersionId` varchar(16) DEFAULT NULL,
  `graphicsCard` varchar(50) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`mac`),
  KEY `condorVersionId` (`condorVersionId`),
  CONSTRAINT `Computer_ibfk_1` FOREIGN KEY (`condorVersionId`) REFERENCES `CondorVersion` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Computer`
--

LOCK TABLES `Computer` WRITE;
/*!40000 ALTER TABLE `Computer` DISABLE KEYS */;
INSERT INTO `Computer` VALUES ('00:d8:61:08:36:d5','v4.0.0','NVIDIA GeForce RTX 2070 with Max-Q Design','2023-03-31 07:17:54.054','2023-03-21 09:34:09.271');
/*!40000 ALTER TABLE `Computer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CondorVersion`
--

DROP TABLE IF EXISTS `CondorVersion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CondorVersion` (
  `id` varchar(16) NOT NULL,
  `dbVersion` varchar(10) DEFAULT NULL,
  `ihmVersion` varchar(10) DEFAULT NULL,
  `coreVersion` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CondorVersion`
--

LOCK TABLES `CondorVersion` WRITE;
/*!40000 ALTER TABLE `CondorVersion` DISABLE KEYS */;
INSERT INTO `CondorVersion` VALUES ('v2.4.4',NULL,NULL,NULL),('v3.0.1',NULL,NULL,NULL),('v3.2.1','','',''),('v4.0.0','','','');
/*!40000 ALTER TABLE `CondorVersion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `License`
--

DROP TABLE IF EXISTS `License`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `License` (
  `number` char(23) NOT NULL,
  `professionalId` mediumint unsigned NOT NULL,
  `enabled` enum('NONE','SOFTWARE','WEB','ALL') NOT NULL DEFAULT 'ALL',
  `licenseType` enum('PROD','DEMO') NOT NULL DEFAULT 'PROD',
  PRIMARY KEY (`number`),
  KEY `professionalId` (`professionalId`),
  CONSTRAINT `License_ibfk_1` FOREIGN KEY (`professionalId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `License`
--

LOCK TABLES `License` WRITE;
/*!40000 ALTER TABLE `License` DISABLE KEYS */;
INSERT INTO `License` VALUES ('XYDDFLNKKXU8Z2MY6F8UK9J',59,'ALL','PROD');
/*!40000 ALTER TABLE `License` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `LicenseAccess`
--

DROP TABLE IF EXISTS `LicenseAccess`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LicenseAccess` (
  `professionalId` mediumint unsigned NOT NULL,
  `licenseNumber` char(23) NOT NULL,
  `computerMac` char(17) NOT NULL,
  `condorVersionId` varchar(16) NOT NULL,
  `globalId` mediumint unsigned DEFAULT NULL,
  `status` enum('VALID','REPAIR') NOT NULL DEFAULT 'VALID',
  `activationDate` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`professionalId`,`licenseNumber`,`computerMac`),
  KEY `licenseNumber` (`licenseNumber`),
  KEY `computerMac` (`computerMac`),
  KEY `condorVersionId` (`condorVersionId`),
  CONSTRAINT `LicenseAccess_ibfk_1` FOREIGN KEY (`professionalId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `LicenseAccess_ibfk_2` FOREIGN KEY (`licenseNumber`) REFERENCES `License` (`number`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `LicenseAccess_ibfk_3` FOREIGN KEY (`computerMac`) REFERENCES `Computer` (`mac`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `LicenseAccess_ibfk_4` FOREIGN KEY (`condorVersionId`) REFERENCES `CondorVersion` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LicenseAccess`
--

LOCK TABLES `LicenseAccess` WRITE;
/*!40000 ALTER TABLE `LicenseAccess` DISABLE KEYS */;
INSERT INTO `LicenseAccess` VALUES (59,'XYDDFLNKKXU8Z2MY6F8UK9J','00:d8:61:08:36:d5','v4.0.0',2,'VALID','2022-03-25 15:58:49.000','2023-03-07 12:44:51.664','2023-03-07 13:44:51.664');
/*!40000 ALTER TABLE `LicenseAccess` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Professional`
--

DROP TABLE IF EXISTS `Professional`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Professional` (
  `id` mediumint unsigned NOT NULL,
  `firstName` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `mainPhone` varchar(45) DEFAULT NULL,
  `country` varchar(75) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Professional`
--

LOCK TABLES `Professional` WRITE;
/*!40000 ALTER TABLE `Professional` DISABLE KEYS */;
INSERT INTO `Professional` VALUES (59,'SABINE','CASERTA','0645636587','France');
/*!40000 ALTER TABLE `Professional` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `__db_version__`
--

DROP TABLE IF EXISTS `__db_version__`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `__db_version__` (
  `id` int NOT NULL AUTO_INCREMENT,
  `versionMajor` int NOT NULL,
  `versionMinor` int NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `migrationFile` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `__db_version__`
--

LOCK TABLES `__db_version__` WRITE;
/*!40000 ALTER TABLE `__db_version__` DISABLE KEYS */;
INSERT INTO `__db_version__` VALUES (1,1,0,'v1.0','migration_wow_client_1.0_create_wow_client_from_condor');
/*!40000 ALTER TABLE `__db_version__` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping routines for database 'wow_client'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-03-31 10:00:20
