-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: wow_patient
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `AddressInfo`
--

DROP TABLE IF EXISTS `AddressInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AddressInfo` (
  `uuid` varchar(36) NOT NULL,
  `line0` varchar(255) DEFAULT NULL,
  `line1` varchar(255) DEFAULT NULL,
  `line2` varchar(255) DEFAULT NULL,
  `detail` varchar(255) DEFAULT NULL,
  `cityName` varchar(255) DEFAULT NULL,
  `cityState` varchar(255) DEFAULT NULL,
  `cityZip` varchar(255) DEFAULT NULL,
  `countryName` varchar(255) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AddressInfo`
--

LOCK TABLES `AddressInfo` WRITE;
/*!40000 ALTER TABLE `AddressInfo` DISABLE KEYS */;
INSERT INTO `AddressInfo` VALUES ('41a360f9-4716-11ee-bfe6-a86daa000811','','','','','','','','','2023-08-30 09:19:01.119','2023-08-30 11:19:01.123'),('41a38212-4716-11ee-bfe6-a86daa000811','','','','','','','','','2023-08-30 09:19:01.119','2023-08-30 11:19:01.123'),('7ce03390-4709-11ee-bfe6-a86daa000811','','','','','','','','','2023-08-30 07:47:37.046','2023-08-30 09:47:37.053'),('7ce038e8-4709-11ee-bfe6-a86daa000811','','','','','','','','','2023-08-30 07:47:37.048','2023-08-30 09:47:37.053'),('d4573175-4715-11ee-bfe6-a86daa000811','','','','','','','','','2023-08-30 09:15:57.749','2023-08-30 11:15:57.762'),('d45752f8-4715-11ee-bfe6-a86daa000811','','','','','','','','','2023-08-30 09:15:57.752','2023-08-30 11:15:57.762');
/*!40000 ALTER TABLE `AddressInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `EmergencyContact`
--

DROP TABLE IF EXISTS `EmergencyContact`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `EmergencyContact` (
  `uuid` varchar(36) NOT NULL,
  `personInfoId` varchar(36) NOT NULL,
  `phoneInfoId` varchar(36) NOT NULL,
  `addressInfoId` varchar(36) NOT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `personInfoId` (`personInfoId`),
  UNIQUE KEY `phoneInfoId` (`phoneInfoId`),
  UNIQUE KEY `addressInfoId` (`addressInfoId`),
  CONSTRAINT `EmergencyContact_ibfk_1` FOREIGN KEY (`personInfoId`) REFERENCES `PersonInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `EmergencyContact_ibfk_2` FOREIGN KEY (`phoneInfoId`) REFERENCES `PhoneInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `EmergencyContact_ibfk_3` FOREIGN KEY (`addressInfoId`) REFERENCES `AddressInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `EmergencyContact`
--

LOCK TABLES `EmergencyContact` WRITE;
/*!40000 ALTER TABLE `EmergencyContact` DISABLE KEYS */;
INSERT INTO `EmergencyContact` VALUES ('41a369b3-4716-11ee-bfe6-a86daa000811','41a371c3-4716-11ee-bfe6-a86daa000811','41a379b6-4716-11ee-bfe6-a86daa000811','41a38212-4716-11ee-bfe6-a86daa000811','2023-08-30 09:19:01.119','2023-08-30 11:19:01.123'),('7ce03530-4709-11ee-bfe6-a86daa000811','7ce03691-4709-11ee-bfe6-a86daa000811','7ce037e3-4709-11ee-bfe6-a86daa000811','7ce038e8-4709-11ee-bfe6-a86daa000811','2023-08-30 07:47:37.048','2023-08-30 09:47:37.053'),('d4573bc6-4715-11ee-bfe6-a86daa000811','d457429a-4715-11ee-bfe6-a86daa000811','d4574c10-4715-11ee-bfe6-a86daa000811','d45752f8-4715-11ee-bfe6-a86daa000811','2023-08-30 09:15:57.753','2023-08-30 11:15:57.762');
/*!40000 ALTER TABLE `EmergencyContact` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Patient`
--

DROP TABLE IF EXISTS `Patient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Patient` (
  `uuid` varchar(36) NOT NULL,
  `personInfoId` varchar(36) NOT NULL,
  `phoneInfoId` varchar(36) NOT NULL,
  `addressInfoId` varchar(36) NOT NULL,
  `emergencyContactId` varchar(36) NOT NULL,
  `practitionerId` varchar(36) NOT NULL,
  `displayId` mediumint unsigned DEFAULT NULL,
  `globalId` mediumint unsigned DEFAULT NULL,
  `socialSecurity` varchar(255) DEFAULT NULL,
  `allergies` varchar(255) DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `comments` text,
  `privateComments` text,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `personInfoId` (`personInfoId`),
  UNIQUE KEY `phoneInfoId` (`phoneInfoId`),
  UNIQUE KEY `addressInfoId` (`addressInfoId`),
  UNIQUE KEY `emergencyContactId` (`emergencyContactId`),
  UNIQUE KEY `practitionerId` (`practitionerId`),
  CONSTRAINT `Patient_ibfk_1` FOREIGN KEY (`personInfoId`) REFERENCES `PersonInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Patient_ibfk_2` FOREIGN KEY (`phoneInfoId`) REFERENCES `PhoneInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Patient_ibfk_3` FOREIGN KEY (`addressInfoId`) REFERENCES `AddressInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Patient_ibfk_4` FOREIGN KEY (`emergencyContactId`) REFERENCES `EmergencyContact` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Patient_ibfk_5` FOREIGN KEY (`practitionerId`) REFERENCES `Practitioner` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Patient`
--

LOCK TABLES `Patient` WRITE;
/*!40000 ALTER TABLE `Patient` DISABLE KEYS */;
INSERT INTO `Patient` VALUES ('41a34220-4716-11ee-bfe6-a86daa000811','41a34e5a-4716-11ee-bfe6-a86daa000811','41a35714-4716-11ee-bfe6-a86daa000811','41a360f9-4716-11ee-bfe6-a86daa000811','41a369b3-4716-11ee-bfe6-a86daa000811','41a38d1e-4716-11ee-bfe6-a86daa000811',3,1,'','',0,'','',NULL,'2023-08-30 11:19:01.117','2023-08-30 09:19:01.120','2023-08-30 11:19:01.123'),('7ce01fa7-4709-11ee-bfe6-a86daa000811','7ce028b7-4709-11ee-bfe6-a86daa000811','7ce02f98-4709-11ee-bfe6-a86daa000811','7ce03390-4709-11ee-bfe6-a86daa000811','7ce03530-4709-11ee-bfe6-a86daa000811','7ce03b2d-4709-11ee-bfe6-a86daa000811',1,1,'','',0,'','',NULL,'2023-08-30 09:47:37.041','2023-08-30 07:47:37.050','2023-08-30 09:47:37.053'),('d4570ca2-4715-11ee-bfe6-a86daa000811','d4571b77-4715-11ee-bfe6-a86daa000811','d4572669-4715-11ee-bfe6-a86daa000811','d4573175-4715-11ee-bfe6-a86daa000811','d4573bc6-4715-11ee-bfe6-a86daa000811','d4575c30-4715-11ee-bfe6-a86daa000811',2,1,'','',0,'','',NULL,'2023-08-30 11:15:57.746','2023-08-30 09:15:57.756','2023-08-30 11:15:57.762');
/*!40000 ALTER TABLE `Patient` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PersonInfo`
--

DROP TABLE IF EXISTS `PersonInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PersonInfo` (
  `uuid` varchar(36) NOT NULL,
  `firstname` varchar(64) NOT NULL,
  `lastname` varchar(64) NOT NULL,
  `birthdate` datetime(3) DEFAULT NULL,
  `sex` enum('M','F') DEFAULT 'M',
  `email` varchar(255) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PersonInfo`
--

LOCK TABLES `PersonInfo` WRITE;
/*!40000 ALTER TABLE `PersonInfo` DISABLE KEYS */;
INSERT INTO `PersonInfo` VALUES ('41a34e5a-4716-11ee-bfe6-a86daa000811','jhkjgjhjk','hgjgj;','2023-08-04 00:00:00.000','M','','2023-08-30 09:19:01.118','2023-08-30 11:19:01.123'),('41a371c3-4716-11ee-bfe6-a86daa000811','','',NULL,'M','','2023-08-30 09:19:01.119','2023-08-30 11:19:01.123'),('7ce028b7-4709-11ee-bfe6-a86daa000811','-','ref1313','2023-08-09 00:00:00.000','M','','2023-08-30 07:47:37.041','2023-08-30 09:47:37.053'),('7ce03691-4709-11ee-bfe6-a86daa000811','','',NULL,'M','','2023-08-30 07:47:37.047','2023-08-30 09:47:37.053'),('d4571b77-4715-11ee-bfe6-a86daa000811','hjgjk','jgjh','2023-08-03 00:00:00.000','M','','2023-08-30 09:15:57.747','2023-08-30 11:15:57.762'),('d457429a-4715-11ee-bfe6-a86daa000811','','',NULL,'M','','2023-08-30 09:15:57.750','2023-08-30 11:15:57.762');
/*!40000 ALTER TABLE `PersonInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PhoneInfo`
--

DROP TABLE IF EXISTS `PhoneInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PhoneInfo` (
  `uuid` varchar(36) NOT NULL,
  `phone` varchar(45) DEFAULT NULL,
  `cellular` varchar(45) DEFAULT NULL,
  `fax` varchar(45) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PhoneInfo`
--

LOCK TABLES `PhoneInfo` WRITE;
/*!40000 ALTER TABLE `PhoneInfo` DISABLE KEYS */;
INSERT INTO `PhoneInfo` VALUES ('41a35714-4716-11ee-bfe6-a86daa000811','','','','2023-08-30 09:19:01.118','2023-08-30 11:19:01.123'),('41a379b6-4716-11ee-bfe6-a86daa000811','','','','2023-08-30 09:19:01.119','2023-08-30 11:19:01.123'),('41a39572-4716-11ee-bfe6-a86daa000811','','','','2023-08-30 09:19:01.120','2023-08-30 11:19:01.123'),('7ce02f98-4709-11ee-bfe6-a86daa000811','','','','2023-08-30 07:47:37.044','2023-08-30 09:47:37.053'),('7ce037e3-4709-11ee-bfe6-a86daa000811','','','','2023-08-30 07:47:37.047','2023-08-30 09:47:37.053'),('7ce03c37-4709-11ee-bfe6-a86daa000811','','','','2023-08-30 07:47:37.049','2023-08-30 09:47:37.053'),('d4572669-4715-11ee-bfe6-a86daa000811','','','','2023-08-30 09:15:57.748','2023-08-30 11:15:57.762'),('d4574c10-4715-11ee-bfe6-a86daa000811','','','','2023-08-30 09:15:57.751','2023-08-30 11:15:57.762'),('d4576235-4715-11ee-bfe6-a86daa000811','','','','2023-08-30 09:15:57.754','2023-08-30 11:15:57.762');
/*!40000 ALTER TABLE `PhoneInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Practitioner`
--

DROP TABLE IF EXISTS `Practitioner`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Practitioner` (
  `uuid` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `phoneInfoId` varchar(36) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `phoneInfoId` (`phoneInfoId`),
  CONSTRAINT `Practitioner_ibfk_1` FOREIGN KEY (`phoneInfoId`) REFERENCES `PhoneInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Practitioner`
--

LOCK TABLES `Practitioner` WRITE;
/*!40000 ALTER TABLE `Practitioner` DISABLE KEYS */;
INSERT INTO `Practitioner` VALUES ('41a38d1e-4716-11ee-bfe6-a86daa000811','','41a39572-4716-11ee-bfe6-a86daa000811','2023-08-30 09:19:01.120','2023-08-30 11:19:01.123'),('7ce03b2d-4709-11ee-bfe6-a86daa000811','','7ce03c37-4709-11ee-bfe6-a86daa000811','2023-08-30 07:47:37.049','2023-08-30 09:47:37.053'),('d4575c30-4715-11ee-bfe6-a86daa000811','','d4576235-4715-11ee-bfe6-a86daa000811','2023-08-30 09:15:57.755','2023-08-30 11:15:57.762');
/*!40000 ALTER TABLE `Practitioner` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `__db_version__`
--

DROP TABLE IF EXISTS `__db_version__`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `__db_version__` (
  `id` int NOT NULL AUTO_INCREMENT,
  `versionMajor` int NOT NULL,
  `versionMinor` int NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `migrationFile` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `__db_version__`
--

LOCK TABLES `__db_version__` WRITE;
/*!40000 ALTER TABLE `__db_version__` DISABLE KEYS */;
INSERT INTO `__db_version__` VALUES (1,1,0,'v1.0','migration_wow_patient_1.0_create_wow_patient');
/*!40000 ALTER TABLE `__db_version__` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping routines for database 'wow_patient'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-08-30 11:58:58
