-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: wow_application
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `Act`
--

DROP TABLE IF EXISTS `Act`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Act` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `patientId` varchar(36) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `displayId` mediumint unsigned DEFAULT NULL,
  `workflow` enum('FREE','WORKFLOW_1','WORKFLOW_2','WORKFLOW_3') NOT NULL DEFAULT 'FREE',
  `comments` text,
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastAccessed` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `patientId` (`patientId`),
  CONSTRAINT `Act_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Act_ibfk_2` FOREIGN KEY (`patientId`) REFERENCES `wow_patient`.`Patient` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Act`
--

LOCK TABLES `Act` WRITE;
/*!40000 ALTER TABLE `Act` DISABLE KEYS */;
INSERT INTO `Act` VALUES ('28b852b9-4711-11ee-bfe6-a86daa000811',196,'7ce01fa7-4709-11ee-bfe6-a86daa000811','Acte Couronne sur implant',2,'FREE','',0,'2023-08-30 10:42:31.824',NULL,'2023-08-30 11:14:37.889','2023-08-30 10:42:31.827','2023-08-30 09:14:37.889','2023-08-30 11:14:37.893'),('94108410-4709-11ee-bfe6-a86daa000811',196,'7ce01fa7-4709-11ee-bfe6-a86daa000811','Acte Couronne',1,'FREE','',0,'2023-08-30 09:48:15.945',NULL,'2023-08-30 11:17:59.052','2023-08-30 09:48:15.947','2023-08-30 09:17:59.053','2023-08-30 11:17:59.055'),('99062442-4716-11ee-bfe6-a86daa000811',196,'7ce01fa7-4709-11ee-bfe6-a86daa000811','Acte Couronne',4,'FREE','',0,'2023-08-30 11:21:27.723',NULL,'2023-08-30 11:21:27.756','2023-08-30 11:21:27.726','2023-08-30 09:21:27.756','2023-08-30 11:21:27.759'),('a0f72d78-4717-11ee-bfe6-a86daa000811',196,'7ce01fa7-4709-11ee-bfe6-a86daa000811','scandirect',6,'FREE','',0,'2023-08-30 11:28:50.543',NULL,'2023-08-30 11:32:40.711','2023-08-30 11:32:40.422','2023-08-30 09:32:40.712','2023-08-30 11:32:40.714'),('c588c3d6-4716-11ee-bfe6-a86daa000811',196,'7ce01fa7-4709-11ee-bfe6-a86daa000811','Acte Facette',5,'FREE','',0,'2023-08-30 11:22:42.399',NULL,'2023-08-30 11:25:32.995','2023-08-30 11:22:42.401','2023-08-30 09:25:32.996','2023-08-30 11:25:59.465'),('c7a7cd85-4713-11ee-bfe6-a86daa000811',196,'7ce01fa7-4709-11ee-bfe6-a86daa000811','Acte Couronne sur implant',3,'WORKFLOW_3','',0,'2023-08-30 11:01:17.467',NULL,'2023-08-30 11:14:28.272','2023-08-30 11:01:17.468','2023-08-30 09:14:28.272','2023-08-30 11:14:28.275'),('dcec7c3f-4715-11ee-bfe6-a86daa000811',196,'d4570ca2-4715-11ee-bfe6-a86daa000811','Acte Autre',1,'FREE','',0,'2023-08-30 11:16:12.143',NULL,'2023-08-30 11:17:34.986','2023-08-30 11:16:12.145','2023-08-30 09:17:34.986','2023-08-30 11:17:34.989');
/*!40000 ALTER TABLE `Act` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AddressInfo`
--

DROP TABLE IF EXISTS `AddressInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AddressInfo` (
  `uuid` varchar(36) NOT NULL,
  `line0` varchar(255) DEFAULT NULL,
  `line1` varchar(255) DEFAULT NULL,
  `line2` varchar(255) DEFAULT NULL,
  `detail` varchar(255) DEFAULT NULL,
  `cityName` varchar(255) DEFAULT NULL,
  `cityState` varchar(255) DEFAULT NULL,
  `cityZip` varchar(255) DEFAULT NULL,
  `countryName` varchar(255) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AddressInfo`
--

LOCK TABLES `AddressInfo` WRITE;
/*!40000 ALTER TABLE `AddressInfo` DISABLE KEYS */;
INSERT INTO `AddressInfo` VALUES ('788c2a28-99ac-4471-9592-8f7a0bf6a283','','','','','gffkfkghk','','','','2023-08-30 08:09:58.914','2023-08-30 10:11:40.738'),('abb5439e-7294-44cc-ad81-6be468ca8dac','djfgdgf','','','','ddshjhqs','','111110','France','2023-08-30 07:46:40.040','2023-08-30 09:46:41.016');
/*!40000 ALTER TABLE `AddressInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Assistant`
--

DROP TABLE IF EXISTS `Assistant`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Assistant` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `credentialsId` varchar(36) DEFAULT NULL,
  `personInfoId` varchar(36) NOT NULL,
  `phoneInfoId` varchar(36) NOT NULL,
  `addressInfoId` varchar(36) NOT NULL,
  `officeId` varchar(36) DEFAULT NULL,
  `patientRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'READ_ONLY',
  `actRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'NOTHING',
  `discussionRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'NOTHING',
  `tempPassword` varchar(32) DEFAULT NULL,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `credentialsId` (`credentialsId`),
  KEY `personInfoId` (`personInfoId`),
  KEY `phoneInfoId` (`phoneInfoId`),
  KEY `addressInfoId` (`addressInfoId`),
  KEY `officeId` (`officeId`),
  CONSTRAINT `Assistant_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_2` FOREIGN KEY (`credentialsId`) REFERENCES `Credentials` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_3` FOREIGN KEY (`personInfoId`) REFERENCES `PersonInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_4` FOREIGN KEY (`phoneInfoId`) REFERENCES `PhoneInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_5` FOREIGN KEY (`addressInfoId`) REFERENCES `AddressInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_6` FOREIGN KEY (`officeId`) REFERENCES `Office` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Assistant`
--

LOCK TABLES `Assistant` WRITE;
/*!40000 ALTER TABLE `Assistant` DISABLE KEYS */;
/*!40000 ALTER TABLE `Assistant` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CircleOrder`
--

DROP TABLE IF EXISTS `CircleOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CircleOrder` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `actId` varchar(36) NOT NULL,
  `title` varchar(64) DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `createdById` varchar(36) DEFAULT NULL,
  `updatedById` varchar(36) DEFAULT NULL,
  `displayId` mediumint unsigned DEFAULT NULL,
  `json` text NOT NULL,
  `metadata` text NOT NULL,
  `status` enum('NOT_SENT','WAITING_WOW_API','SENDING_WOW_API','SENDING_CIRCLE_API','SENT','CANCELLED','DELIVERY') NOT NULL DEFAULT 'NOT_SENT',
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `actId` (`actId`),
  CONSTRAINT `CircleOrder_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `CircleOrder_ibfk_2` FOREIGN KEY (`actId`) REFERENCES `Act` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CircleOrder`
--

LOCK TABLES `CircleOrder` WRITE;
/*!40000 ALTER TABLE `CircleOrder` DISABLE KEYS */;
/*!40000 ALTER TABLE `CircleOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CircleOrderFile`
--

DROP TABLE IF EXISTS `CircleOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CircleOrderFile` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('FORM','SCAN') NOT NULL,
  PRIMARY KEY (`orderId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `CircleOrderFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `CircleOrderFile_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `CircleOrder` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `CircleOrderFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CircleOrderFile`
--

LOCK TABLES `CircleOrderFile` WRITE;
/*!40000 ALTER TABLE `CircleOrderFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `CircleOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Config`
--

DROP TABLE IF EXISTS `Config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Config` (
  `id` mediumint unsigned NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `fullRetrieve` tinyint(1) DEFAULT '0',
  `syncEnabled` tinyint(1) DEFAULT '1',
  `showOcclusionScan` tinyint(1) DEFAULT '1',
  `showOpenStlWarning` tinyint(1) DEFAULT '1',
  `showMarginLinesWarning` tinyint(1) DEFAULT '1',
  `showDeleteConfirmation` tinyint(1) DEFAULT '1',
  `showSyncInfo` tinyint(1) DEFAULT '1',
  `downloadAtFullRetrieve` tinyint(1) DEFAULT '1',
  `lagSound` tinyint(1) DEFAULT '0',
  `lostSound` tinyint(1) DEFAULT '0',
  `emailNotifications` tinyint(1) DEFAULT '1',
  `logout` mediumint DEFAULT '10',
  `language` varchar(2) DEFAULT NULL,
  `diagnosticMode` tinyint(1) DEFAULT '0',
  `repairMode` tinyint(1) DEFAULT '0',
  `flipMaxillaryH` tinyint(1) DEFAULT '0',
  `flipMaxillaryV` tinyint(1) DEFAULT '0',
  `flipMandibleH` tinyint(1) DEFAULT '0',
  `flipMandibleV` tinyint(1) DEFAULT '0',
  `showFlipPopupMaxillary` tinyint(1) DEFAULT '1',
  `showFlipPopupMandible` tinyint(1) DEFAULT '1',
  `enableUserSharing` tinyint(1) DEFAULT '0',
  `lostTrackingRectangle` tinyint(1) DEFAULT '1',
  `showAllPatients` tinyint(1) DEFAULT '0',
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  PRIMARY KEY (`id`,`ownerId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Config`
--

LOCK TABLES `Config` WRITE;
/*!40000 ALTER TABLE `Config` DISABLE KEYS */;
INSERT INTO `Config` VALUES (1,196,0,1,1,1,1,1,1,1,0,0,1,10,'FR',0,0,0,0,0,0,1,1,0,1,1,'2023-08-30 09:46:35.000','2023-08-30 10:13:14.561','2023-08-30 08:13:14.558'),(1,197,0,1,1,1,1,1,1,1,0,0,1,10,'FR',0,0,0,0,0,0,1,1,0,1,0,'2023-08-30 09:54:37.000','2023-08-30 10:11:40.738','2023-08-30 07:54:38.679');
/*!40000 ALTER TABLE `Config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Contact`
--

DROP TABLE IF EXISTS `Contact`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Contact` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `professionalId` mediumint unsigned NOT NULL COMMENT 'Le professionnel contact',
  `officeId` varchar(36) DEFAULT NULL,
  `status` enum('INVITATIONSENT','INVITATIONRECEIVED','ACCEPTED','REJECTED') NOT NULL DEFAULT 'INVITATIONSENT',
  `comments` text,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `uniqueContactPro` (`ownerId`,`professionalId`),
  KEY `professionalId` (`professionalId`),
  KEY `officeId` (`officeId`),
  CONSTRAINT `Contact_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Contact_ibfk_2` FOREIGN KEY (`professionalId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Contact_ibfk_3` FOREIGN KEY (`officeId`) REFERENCES `Office` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Contact`
--

LOCK TABLES `Contact` WRITE;
/*!40000 ALTER TABLE `Contact` DISABLE KEYS */;
INSERT INTO `Contact` VALUES ('10dd3a70-5f65-40aa-94e6-f193d9feebad',196,196,NULL,'ACCEPTED','',NULL,'2023-08-30 09:46:35.000','2023-08-30 07:46:41.016','2023-08-30 09:46:41.016'),('6d038bac-e819-45db-8313-aba6d0d4ec3a',196,197,NULL,'ACCEPTED','',NULL,'2023-08-30 10:10:47.000','2023-08-30 08:11:40.738','2023-08-30 10:11:40.738');
/*!40000 ALTER TABLE `Contact` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ContactNotification`
--

DROP TABLE IF EXISTS `ContactNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ContactNotification` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `contactId` varchar(36) DEFAULT NULL,
  `rescueDisplayName` varchar(50) DEFAULT NULL,
  `event` enum('RECEIVED','RECEIVED_TO_ACCEPTED','RECEIVED_TO_REJECTED','SENT_TO_ACCEPTED','SENT_TO_REJECTED','ACTIVATION_TIMEOUT') NOT NULL DEFAULT 'RECEIVED',
  `unread` tinyint(1) NOT NULL DEFAULT '1',
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `contactId` (`contactId`),
  CONSTRAINT `ContactNotification_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ContactNotification_ibfk_2` FOREIGN KEY (`contactId`) REFERENCES `Contact` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ContactNotification`
--

LOCK TABLES `ContactNotification` WRITE;
/*!40000 ALTER TABLE `ContactNotification` DISABLE KEYS */;
INSERT INTO `ContactNotification` VALUES ('da95d478-d178-4dbe-9d00-481f7e973604',196,'6d038bac-e819-45db-8313-aba6d0d4ec3a','ghjgkhg gfdgfjgf','SENT_TO_ACCEPTED',0,'2023-08-30 10:10:47.000',NULL,'2023-08-30 08:11:03.041','2023-08-30 10:11:03.041');
/*!40000 ALTER TABLE `ContactNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Credentials`
--

DROP TABLE IF EXISTS `Credentials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Credentials` (
  `uuid` varchar(36) NOT NULL,
  `login` varchar(255) NOT NULL,
  `password` varchar(100) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `login` (`login`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Credentials`
--

LOCK TABLES `Credentials` WRITE;
/*!40000 ALTER TABLE `Credentials` DISABLE KEYS */;
INSERT INTO `Credentials` VALUES ('0431a905-6a1e-4ecc-94c4-1a09e295a24c','viptest',NULL,'2023-08-30 08:09:58.912','2023-08-30 10:11:40.738'),('956d7fd1-bffd-4500-8156-2db75591d0a0','sabine','b0e3df5eccd7d2844837d97c6baad27a09945a8bdcc3c2afd2a4f73578446111','2023-08-30 07:46:40.037','2023-08-30 09:46:41.016');
/*!40000 ALTER TABLE `Credentials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Discussion`
--

DROP TABLE IF EXISTS `Discussion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Discussion` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `selfImplied` tinyint(1) NOT NULL DEFAULT '0',
  `officeId` varchar(36) DEFAULT NULL,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`,`ownerId`),
  KEY `ownerId` (`ownerId`),
  KEY `officeId` (`officeId`),
  CONSTRAINT `Discussion_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Discussion_ibfk_2` FOREIGN KEY (`officeId`) REFERENCES `Office` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Discussion`
--

LOCK TABLES `Discussion` WRITE;
/*!40000 ALTER TABLE `Discussion` DISABLE KEYS */;
INSERT INTO `Discussion` VALUES ('e9aee9e9-470c-11ee-bfe6-a86daa000811',196,0,NULL,NULL,'2023-08-30 10:12:08.080','2023-08-30 09:33:26.693','2023-08-30 11:33:26.693'),('e9aee9e9-470c-11ee-bfe6-a86daa000811',197,0,NULL,NULL,'2023-08-30 10:12:08.080','2023-08-30 08:12:08.080',NULL);
/*!40000 ALTER TABLE `Discussion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `File`
--

DROP TABLE IF EXISTS `File`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `File` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `path` text,
  `tag` text,
  `originalName` text NOT NULL,
  `originalId` varchar(36) NOT NULL,
  `metadata` text,
  `type` enum('BIN','JSON','PDF','PLY','STL','PNG','XYZ','ZIP') NOT NULL,
  `version` mediumint unsigned DEFAULT '0',
  `status` enum('CREATED','UPDATED','SYNCED','ERROR') DEFAULT 'CREATED',
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `version` (`originalId`,`version`),
  CONSTRAINT `File_ibfk_1` FOREIGN KEY (`originalId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `File`
--

LOCK TABLES `File` WRITE;
/*!40000 ALTER TABLE `File` DISABLE KEYS */;
INSERT INTO `File` VALUES ('014de352-4718-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_a0f72d78-4717-11ee-bfe6-a86daa000811/occlusion_a0f77fda-4717-11ee-bfe6-a86daa000811/scan_a27d60d7-4717-11ee-bfe6-a86daa000811/014de352-4718-11ee-bfe6-a86daa000811.xyz','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_a0f72d78-4717-11ee-bfe6-a86daa000811_SESS_a0f77fda-4717-11ee-bfe6-a86daa000811_TOSC_a27d60d7-4717-11ee-bfe6-a86daa000811_LIFI','014de352-4718-11ee-bfe6-a86daa000811.xyz','014de352-4718-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.6.1.1 Ligne de finition 1\",\"title\":\"1\",\"toothNumber\":1,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 11:31:32.000','2023-08-30 09:33:26.345','2023-08-30 11:33:26.345'),('014dea28-4718-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_a0f72d78-4717-11ee-bfe6-a86daa000811/occlusion_a0f77fda-4717-11ee-bfe6-a86daa000811/scan_a27d60d7-4717-11ee-bfe6-a86daa000811/014dea28-4718-11ee-bfe6-a86daa000811.bin','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_a0f72d78-4717-11ee-bfe6-a86daa000811_SESS_a0f77fda-4717-11ee-bfe6-a86daa000811_TOSC_a27d60d7-4717-11ee-bfe6-a86daa000811_LIFIM','014dea28-4718-11ee-bfe6-a86daa000811.bin','014dea28-4718-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.6.1.1 Ligne de finition métadonnées 1\",\"title\":\"1\",\"toothNumber\":1,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 11:31:32.000','2023-08-30 09:33:26.349','2023-08-30 11:33:26.349'),('05dbe774-4713-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/scan_f4877908-4712-11ee-bfe6-a86daa000811/05dbe774-4713-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_BOSC_f4877908-4712-11ee-bfe6-a86daa000811_MODEL','05dbe774-4713-11ee-bfe6-a86daa000811.zip','f4879c4b-4712-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule scanbody 1.1.2.1.3\",\"modelMatrix\":\"-0.409402,0.900441,-0.146959,0,-0.912354,-0.404056,0.0659451,0,6.03451e-09,0.161077,0.986942,0,10.1898,-19.9483,-17.5344,1\",\"scanBodies\":[{\"position\":\"9.76708,6,0,0,2.78072,0,6,0,21.3364,0,0,6,1,0,0,0\",\"reference\":\"KECESCANP\",\"tid\":47}]}','ZIP',1,'SYNCED',0,NULL,'2023-08-30 10:55:52.331','2023-08-30 08:55:52.389','2023-08-30 10:55:52.554'),('0d4d5214-4715-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/scan_d709480e-4714-11ee-bfe6-a86daa000811/0d4d5214-4715-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_BOSC_d709480e-4714-11ee-bfe6-a86daa000811_MODEL','0d4d5214-4715-11ee-bfe6-a86daa000811.zip','d709695b-4714-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule scanbody 1.1.3.1.3\",\"modelMatrix\":\"-0.884595,0.46175,-0.0654155,0,-0.46636,-0.875849,0.12408,0,-8.38836e-11,0.140268,0.990113,0,17.3367,-10.6666,-15.5246,1\",\"scanBodies\":[{\"position\":\"10.3631,6,0,0,2.10359,0,6,0,20.0179,0,0,6,1,0,0,0\",\"reference\":\"KECESCANP\",\"tid\":47}]}','ZIP',2,'SYNCED',0,NULL,'2023-08-30 11:10:23.812','2023-08-30 09:10:24.448','2023-08-30 11:10:28.423'),('0d4d7785-4715-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/scan_d709480e-4714-11ee-bfe6-a86daa000811/0d4d7785-4715-11ee-bfe6-a86daa000811.png','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_BOSC_d709480e-4714-11ee-bfe6-a86daa000811_SNAPS','0d4d7785-4715-11ee-bfe6-a86daa000811.png','d70f810d-4714-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule scanbody 1.1.3.1.3 Snapshot\"}','PNG',1,'SYNCED',0,NULL,'2023-08-30 11:10:23.813','2023-08-30 09:10:24.450','2023-08-30 11:11:16.674'),('0e658e5a-470a-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_94108410-4709-11ee-bfe6-a86daa000811/occlusion_9411ecbc-4709-11ee-bfe6-a86daa000811/scan_ddb8b416-4709-11ee-bfe6-a86daa000811/0e658e5a-470a-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_94108410-4709-11ee-bfe6-a86daa000811_SESS_9411ecbc-4709-11ee-bfe6-a86daa000811_BOSC_ddb8b416-4709-11ee-bfe6-a86daa000811_MODEL','0e658e5a-470a-11ee-bfe6-a86daa000811.zip','0e658e5a-470a-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.1.1.1\",\"modelMatrix\":\"-0.809032,0.574992,-0.121868,0,-0.587765,-0.79145,0.167746,0,-4.06461e-09,0.207342,0.978268,0,22.3948,-18.518,-15.8746,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 09:51:44.000','2023-08-30 08:39:12.037','2023-08-30 10:39:12.037'),('0e65a514-470a-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_94108410-4709-11ee-bfe6-a86daa000811/occlusion_9411ecbc-4709-11ee-bfe6-a86daa000811/scan_ddb8b416-4709-11ee-bfe6-a86daa000811/0e65a514-470a-11ee-bfe6-a86daa000811.png','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_94108410-4709-11ee-bfe6-a86daa000811_SESS_9411ecbc-4709-11ee-bfe6-a86daa000811_BOSC_ddb8b416-4709-11ee-bfe6-a86daa000811_SNAPS','0e65a514-470a-11ee-bfe6-a86daa000811.png','0e65a514-470a-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 09:51:44.000','2023-08-30 08:39:12.042','2023-08-30 10:39:12.042'),('13054d2a-4714-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/scan_f5703840-4713-11ee-bfe6-a86daa000811/13054d2a-4714-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_BOSC_f5703840-4713-11ee-bfe6-a86daa000811_MODEL','13054d2a-4714-11ee-bfe6-a86daa000811.zip','13054d2a-4714-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule pre-scan 1.1.3.1.1\",\"modelMatrix\":\"-0.713152,0.693282,-0.103797,0,-0.701009,-0.705292,0.105595,0,-3.83699e-09,0.148068,0.988977,0,14.4127,-15.8463,-14.6529,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 11:03:23.909','2023-08-30 09:03:24.166','2023-08-30 11:03:26.286'),('1305657a-4714-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/scan_f5703840-4713-11ee-bfe6-a86daa000811/1305657a-4714-11ee-bfe6-a86daa000811.png','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_BOSC_f5703840-4713-11ee-bfe6-a86daa000811_SNAPS','1305657a-4714-11ee-bfe6-a86daa000811.png','1305657a-4714-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule pre-scan 1.1.3.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 11:03:23.910','2023-08-30 09:03:24.167','2023-08-30 11:03:28.046'),('14f1ba3f-4717-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c588c3d6-4716-11ee-bfe6-a86daa000811/occlusion_c589e5b6-4716-11ee-bfe6-a86daa000811/scan_fcb9257d-4716-11ee-bfe6-a86daa000811/14f1ba3f-4717-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c588c3d6-4716-11ee-bfe6-a86daa000811_SESS_c589e5b6-4716-11ee-bfe6-a86daa000811_BOSC_fcb9257d-4716-11ee-bfe6-a86daa000811_MODEL','14f1ba3f-4717-11ee-bfe6-a86daa000811.zip','14f1ba3f-4717-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.5.1.1\",\"modelMatrix\":\"-0.875479,0.476246,-0.0820169,0,-0.483256,-0.862778,0.148584,0,-7.60182e-09,0.169717,0.985493,0,16.5273,-7.76453,-15.6336,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 11:24:58.000','2023-08-30 09:27:21.828','2023-08-30 11:27:21.828'),('14f1d27f-4717-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c588c3d6-4716-11ee-bfe6-a86daa000811/occlusion_c589e5b6-4716-11ee-bfe6-a86daa000811/scan_fcb9257d-4716-11ee-bfe6-a86daa000811/14f1d27f-4717-11ee-bfe6-a86daa000811.png','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c588c3d6-4716-11ee-bfe6-a86daa000811_SESS_c589e5b6-4716-11ee-bfe6-a86daa000811_BOSC_fcb9257d-4716-11ee-bfe6-a86daa000811_SNAPS','14f1d27f-4717-11ee-bfe6-a86daa000811.png','14f1d27f-4717-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.5.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 11:24:58.000','2023-08-30 09:27:21.832','2023-08-30 11:27:21.832'),('18fd2b01-4714-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/scan_c98c9fb7-4713-11ee-bfe6-a86daa000811/18fd2b01-4714-11ee-bfe6-a86daa000811.xyz','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_TOSC_c98c9fb7-4713-11ee-bfe6-a86daa000811_LIFI','18fd2b01-4714-11ee-bfe6-a86daa000811.xyz','18fd2b01-4714-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire pre-scan 1.1.3.1.1 Ligne de finition 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 11:03:33.922','2023-08-30 09:03:33.927','2023-08-30 11:03:33.934'),('18fd31b8-4714-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/scan_c98c9fb7-4713-11ee-bfe6-a86daa000811/18fd31b8-4714-11ee-bfe6-a86daa000811.bin','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_TOSC_c98c9fb7-4713-11ee-bfe6-a86daa000811_LIFIM','18fd31b8-4714-11ee-bfe6-a86daa000811.bin','18fd31b8-4714-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire pre-scan 1.1.3.1.1 Ligne de finition métadonnées 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 11:03:33.922','2023-08-30 09:03:33.928','2023-08-30 11:03:34.202'),('1b7fb9c1-4718-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_a0f72d78-4717-11ee-bfe6-a86daa000811/occlusion_a0f77fda-4717-11ee-bfe6-a86daa000811/scan_038d534c-4718-11ee-bfe6-a86daa000811/1b7fb9c1-4718-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_a0f72d78-4717-11ee-bfe6-a86daa000811_SESS_a0f77fda-4717-11ee-bfe6-a86daa000811_LESC_038d534c-4718-11ee-bfe6-a86daa000811_MODEL','1b7fb9c1-4718-11ee-bfe6-a86daa000811.zip','1b7fb9c1-4718-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mordu gauche 1.1.6.1.1\",\"modelMatrix\":\"-0.999818,0.00598761,0.0175379,0,-0.00313341,-0.984427,0.175725,0,0.0188109,0.175691,0.984283,0,9.41499,-7.13872,-19.191,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 11:32:45.000','2023-08-30 09:33:26.352','2023-08-30 11:33:26.352'),('1b7fd125-4718-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_a0f72d78-4717-11ee-bfe6-a86daa000811/occlusion_a0f77fda-4717-11ee-bfe6-a86daa000811/scan_038d534c-4718-11ee-bfe6-a86daa000811/1b7fd125-4718-11ee-bfe6-a86daa000811.png','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_a0f72d78-4717-11ee-bfe6-a86daa000811_SESS_a0f77fda-4717-11ee-bfe6-a86daa000811_LESC_038d534c-4718-11ee-bfe6-a86daa000811_SNAPS','1b7fd125-4718-11ee-bfe6-a86daa000811.png','1b7fd125-4718-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mordu gauche 1.1.6.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 11:32:45.000','2023-08-30 09:33:26.355','2023-08-30 11:33:26.355'),('1fdc68df-4718-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_a0f72d78-4717-11ee-bfe6-a86daa000811/occlusion_a0f77fda-4717-11ee-bfe6-a86daa000811/computedocclusion_1db40f03-4718-11ee-bfe6-a86daa000811/1fdc68df-4718-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_a0f72d78-4717-11ee-bfe6-a86daa000811_SESS_a0f77fda-4717-11ee-bfe6-a86daa000811_OCC_1db40f03-4718-11ee-bfe6-a86daa000811_TOPLY','1fdc68df-4718-11ee-bfe6-a86daa000811.zip','1fdc68df-4718-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.6.1.1 Maxillaire\",\"modelMatrix\":\"0.975251,0.211526,-0.0643608,0,-0.221101,0.933018,-0.283888,0,1.08095e-10,0.291092,0.956695,0,-15.2467,-6.79388,-15.5769,1\",\"occlusionMatrix\":\"-0.947232,0.319774,-0.0224238,0,0.0781778,0.162603,-0.98359,0,-0.31088,-0.933439,-0.179022,0,18.9612,7.1641,2.06084,1\",\"occlusionType\":2,\"referenceScanId\":\"a27d60d7-4717-11ee-bfe6-a86daa000811\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 11:32:42.000','2023-08-30 09:33:26.358','2023-08-30 11:33:26.358'),('1ff793b5-4718-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_a0f72d78-4717-11ee-bfe6-a86daa000811/occlusion_a0f77fda-4717-11ee-bfe6-a86daa000811/computedocclusion_1db40f03-4718-11ee-bfe6-a86daa000811/1ff793b5-4718-11ee-bfe6-a86daa000811.xyz','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_a0f72d78-4717-11ee-bfe6-a86daa000811_SESS_a0f77fda-4717-11ee-bfe6-a86daa000811_OCC_1db40f03-4718-11ee-bfe6-a86daa000811_LIFIO','1ff793b5-4718-11ee-bfe6-a86daa000811.xyz','1ff793b5-4718-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.6.1.1 Ligne de finition Maxillaire 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MAXILLAIRE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"a27d60d7-4717-11ee-bfe6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 11:32:42.000','2023-08-30 09:33:26.364','2023-08-30 11:33:26.364'),('1ff79a2c-4718-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_a0f72d78-4717-11ee-bfe6-a86daa000811/occlusion_a0f77fda-4717-11ee-bfe6-a86daa000811/computedocclusion_1db40f03-4718-11ee-bfe6-a86daa000811/1ff79a2c-4718-11ee-bfe6-a86daa000811.bin','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_a0f72d78-4717-11ee-bfe6-a86daa000811_SESS_a0f77fda-4717-11ee-bfe6-a86daa000811_OCC_1db40f03-4718-11ee-bfe6-a86daa000811_LIFIMO','1ff79a2c-4718-11ee-bfe6-a86daa000811.bin','1ff79a2c-4718-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.6.1.1 Ligne de finition métadonnées Maxillaire 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MAXILLAIRE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"a27d60d7-4717-11ee-bfe6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 11:32:42.000','2023-08-30 09:33:26.368','2023-08-30 11:33:26.368'),('1ff7ece3-4718-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_a0f72d78-4717-11ee-bfe6-a86daa000811/occlusion_a0f77fda-4717-11ee-bfe6-a86daa000811/computedocclusion_1db40f03-4718-11ee-bfe6-a86daa000811/1ff7ece3-4718-11ee-bfe6-a86daa000811.xyz','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_a0f72d78-4717-11ee-bfe6-a86daa000811_SESS_a0f77fda-4717-11ee-bfe6-a86daa000811_OCC_1db40f03-4718-11ee-bfe6-a86daa000811_LIFIO','1ff7ece3-4718-11ee-bfe6-a86daa000811.xyz','1ff7ece3-4718-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.6.1.1 Ligne de finition Maxillaire 1\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MAXILLAIRE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"a27d60d7-4717-11ee-bfe6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"1\",\"toothNumber\":1001,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 11:32:42.000','2023-08-30 09:33:26.371','2023-08-30 11:33:26.371'),('1ff7f30d-4718-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_a0f72d78-4717-11ee-bfe6-a86daa000811/occlusion_a0f77fda-4717-11ee-bfe6-a86daa000811/computedocclusion_1db40f03-4718-11ee-bfe6-a86daa000811/1ff7f30d-4718-11ee-bfe6-a86daa000811.bin','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_a0f72d78-4717-11ee-bfe6-a86daa000811_SESS_a0f77fda-4717-11ee-bfe6-a86daa000811_OCC_1db40f03-4718-11ee-bfe6-a86daa000811_LIFIMO','1ff7f30d-4718-11ee-bfe6-a86daa000811.bin','1ff7f30d-4718-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.6.1.1 Ligne de finition métadonnées Maxillaire 1\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MAXILLAIRE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"a27d60d7-4717-11ee-bfe6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"1\",\"toothNumber\":1001,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 11:32:42.000','2023-08-30 09:33:26.374','2023-08-30 11:33:26.374'),('1ff833ca-4718-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_a0f72d78-4717-11ee-bfe6-a86daa000811/occlusion_a0f77fda-4717-11ee-bfe6-a86daa000811/computedocclusion_1db40f03-4718-11ee-bfe6-a86daa000811/1ff833ca-4718-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_a0f72d78-4717-11ee-bfe6-a86daa000811_SESS_a0f77fda-4717-11ee-bfe6-a86daa000811_OCC_1db40f03-4718-11ee-bfe6-a86daa000811_BOPLY','1ff833ca-4718-11ee-bfe6-a86daa000811.zip','1ff833ca-4718-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.6.1.1 Mandibule\",\"modelMatrix\":\"0.0327161,0.998269,-0.0488692,0,-0.999465,0.032677,-0.00159967,0,1.04619e-10,0.0488954,0.998804,0,3.50834,-16.1792,-19.0378,1\",\"occlusionMatrix\":\"-0.983256,0.163753,-0.0799523,0,-0.0621356,0.111179,0.991856,0,0.171309,0.980217,-0.0991416,0,12.7602,-18.5205,-0.950808,1\",\"occlusionType\":2,\"referenceScanId\":\"cf8c0f8e-4717-11ee-bfe6-a86daa000811\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 11:32:43.000','2023-08-30 09:33:26.377','2023-08-30 11:33:26.377'),('2013924f-4718-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_a0f72d78-4717-11ee-bfe6-a86daa000811/occlusion_a0f77fda-4717-11ee-bfe6-a86daa000811/computedocclusion_1db40f03-4718-11ee-bfe6-a86daa000811/2013924f-4718-11ee-bfe6-a86daa000811.xyz','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_a0f72d78-4717-11ee-bfe6-a86daa000811_SESS_a0f77fda-4717-11ee-bfe6-a86daa000811_OCC_1db40f03-4718-11ee-bfe6-a86daa000811_LIFIO','2013924f-4718-11ee-bfe6-a86daa000811.xyz','2013924f-4718-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.6.1.1 Ligne de finition Mandibule 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MANDIBULE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"cf8c0f8e-4717-11ee-bfe6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 11:32:43.000','2023-08-30 09:33:26.381','2023-08-30 11:33:26.381'),('201398ef-4718-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_a0f72d78-4717-11ee-bfe6-a86daa000811/occlusion_a0f77fda-4717-11ee-bfe6-a86daa000811/computedocclusion_1db40f03-4718-11ee-bfe6-a86daa000811/201398ef-4718-11ee-bfe6-a86daa000811.bin','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_a0f72d78-4717-11ee-bfe6-a86daa000811_SESS_a0f77fda-4717-11ee-bfe6-a86daa000811_OCC_1db40f03-4718-11ee-bfe6-a86daa000811_LIFIMO','201398ef-4718-11ee-bfe6-a86daa000811.bin','201398ef-4718-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.6.1.1 Ligne de finition métadonnées Mandibule 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MANDIBULE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"cf8c0f8e-4717-11ee-bfe6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 11:32:43.000','2023-08-30 09:33:26.384','2023-08-30 11:33:26.384'),('2013d4ed-4718-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_a0f72d78-4717-11ee-bfe6-a86daa000811/occlusion_a0f77fda-4717-11ee-bfe6-a86daa000811/computedocclusion_1db40f03-4718-11ee-bfe6-a86daa000811/2013d4ed-4718-11ee-bfe6-a86daa000811.xyz','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_a0f72d78-4717-11ee-bfe6-a86daa000811_SESS_a0f77fda-4717-11ee-bfe6-a86daa000811_OCC_1db40f03-4718-11ee-bfe6-a86daa000811_LIFIO','2013d4ed-4718-11ee-bfe6-a86daa000811.xyz','2013d4ed-4718-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.6.1.1 Ligne de finition Mandibule 1\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MANDIBULE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"cf8c0f8e-4717-11ee-bfe6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"1\",\"toothNumber\":1001,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 11:32:43.000','2023-08-30 09:33:26.388','2023-08-30 11:33:26.388'),('2013d727-4718-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_a0f72d78-4717-11ee-bfe6-a86daa000811/occlusion_a0f77fda-4717-11ee-bfe6-a86daa000811/computedocclusion_1db40f03-4718-11ee-bfe6-a86daa000811/2013d727-4718-11ee-bfe6-a86daa000811.bin','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_a0f72d78-4717-11ee-bfe6-a86daa000811_SESS_a0f77fda-4717-11ee-bfe6-a86daa000811_OCC_1db40f03-4718-11ee-bfe6-a86daa000811_LIFIMO','2013d727-4718-11ee-bfe6-a86daa000811.bin','2013d727-4718-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.6.1.1 Ligne de finition métadonnées Mandibule 1\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MANDIBULE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"cf8c0f8e-4717-11ee-bfe6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"1\",\"toothNumber\":1001,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 11:32:43.000','2023-08-30 09:33:26.392','2023-08-30 11:33:26.392'),('20507804-4718-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_a0f72d78-4717-11ee-bfe6-a86daa000811/occlusion_a0f77fda-4717-11ee-bfe6-a86daa000811/computedocclusion_1db40f03-4718-11ee-bfe6-a86daa000811/20507804-4718-11ee-bfe6-a86daa000811.png','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_a0f72d78-4717-11ee-bfe6-a86daa000811_SESS_a0f77fda-4717-11ee-bfe6-a86daa000811_OCC_1db40f03-4718-11ee-bfe6-a86daa000811_SNAPO','20507804-4718-11ee-bfe6-a86daa000811.png','20507804-4718-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.6.1.1 Snapshot\",\"occlusionType\":2}','PNG',0,'SYNCED',0,NULL,'2023-08-30 11:32:44.000','2023-08-30 09:33:26.396','2023-08-30 11:33:26.396'),('20eaffbb-470a-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_94108410-4709-11ee-bfe6-a86daa000811/occlusion_9411ecbc-4709-11ee-bfe6-a86daa000811/scan_ddb8b416-4709-11ee-bfe6-a86daa000811/20eaffbb-470a-11ee-bfe6-a86daa000811.xyz','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_94108410-4709-11ee-bfe6-a86daa000811_SESS_9411ecbc-4709-11ee-bfe6-a86daa000811_BOSC_ddb8b416-4709-11ee-bfe6-a86daa000811_LIFI','20eaffbb-470a-11ee-bfe6-a86daa000811.xyz','20eaffbb-470a-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.1.1.1 Ligne de finition 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 09:52:12.258','2023-08-30 07:52:12.261','2023-08-30 09:52:12.270'),('20eb0492-470a-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_94108410-4709-11ee-bfe6-a86daa000811/occlusion_9411ecbc-4709-11ee-bfe6-a86daa000811/scan_ddb8b416-4709-11ee-bfe6-a86daa000811/20eb0492-470a-11ee-bfe6-a86daa000811.bin','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_94108410-4709-11ee-bfe6-a86daa000811_SESS_9411ecbc-4709-11ee-bfe6-a86daa000811_BOSC_ddb8b416-4709-11ee-bfe6-a86daa000811_LIFIM','20eb0492-470a-11ee-bfe6-a86daa000811.bin','20eb0492-470a-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.1.1.1 Ligne de finition métadonnées 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 09:52:12.258','2023-08-30 07:52:12.261','2023-08-30 09:52:12.409'),('22086add-4714-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/scan_22084bd2-4714-11ee-bfe6-a86daa000811/22086add-4714-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_TOSC_22084bd2-4714-11ee-bfe6-a86daa000811_MODEL','22086add-4714-11ee-bfe6-a86daa000811.zip','22086add-4714-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.3.1.2\",\"modelMatrix\":\"0.647083,0.74661,-0.154459,0,-0.76242,0.633664,-0.131092,0,-4.69452e-10,0.20259,0.979264,0,-11.1795,-17.6012,-14.4686,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 11:03:49.095','2023-08-30 09:05:10.227','2023-08-30 11:05:12.111'),('220e9272-4714-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/scan_22084bd2-4714-11ee-bfe6-a86daa000811/220e9272-4714-11ee-bfe6-a86daa000811.png','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_TOSC_22084bd2-4714-11ee-bfe6-a86daa000811_SNAPS','220e9272-4714-11ee-bfe6-a86daa000811.png','220e9272-4714-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.3.1.2 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 11:03:49.136','2023-08-30 09:05:10.228','2023-08-30 11:05:14.908'),('2773e00a-4714-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/scan_22084bd2-4714-11ee-bfe6-a86daa000811/2773e00a-4714-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_TOSC_22084bd2-4714-11ee-bfe6-a86daa000811_MODEL','2773e00a-4714-11ee-bfe6-a86daa000811.zip','22086add-4714-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.3.1.2\",\"modelMatrix\":\"0.647083,0.74661,-0.154459,0,-0.76242,0.633664,-0.131092,0,-4.69452e-10,0.20259,0.979264,0,-11.1795,-17.6012,-14.4686,1\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2023-08-30 11:03:58.188','2023-08-30 09:05:10.228','2023-08-30 11:05:12.921'),('2b814969-4715-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/scan_10ba483c-4715-11ee-bfe6-a86daa000811/2b814969-4715-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_RISC_10ba483c-4715-11ee-bfe6-a86daa000811_MODEL','2b814969-4715-11ee-bfe6-a86daa000811.zip','2b814969-4715-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mordu droit 1.1.3.1.1\",\"modelMatrix\":\"0.999787,-0.0132943,0.0151595,0,0.0132587,0.999798,0.0155361,0,-0.0158135,-0.0150536,0.999765,0,5.0645,-2.12457,-21.9252,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 11:11:14.484','2023-08-30 09:11:14.725','2023-08-30 11:11:16.854'),('2b817103-4715-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/scan_10ba483c-4715-11ee-bfe6-a86daa000811/2b817103-4715-11ee-bfe6-a86daa000811.png','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_RISC_10ba483c-4715-11ee-bfe6-a86daa000811_SNAPS','2b817103-4715-11ee-bfe6-a86daa000811.png','2b817103-4715-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mordu droit 1.1.3.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 11:11:14.485','2023-08-30 09:11:14.725','2023-08-30 11:11:17.824'),('39ab1d77-4715-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/computedocclusion_370bbb23-4715-11ee-bfe6-a86daa000811/39ab1d77-4715-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_OCC_370bbb23-4715-11ee-bfe6-a86daa000811_TOPRE','39ab1d77-4715-11ee-bfe6-a86daa000811.zip','39ab1d77-4715-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.3.1.1 Maxillaire pre-scan\",\"modelMatrix\":\"0.647083,0.74661,-0.154459,0,-0.76242,0.633664,-0.131092,0,-4.69452e-10,0.20259,0.979264,0,-11.1795,-17.6012,-14.4686,1\",\"occlusionMatrix\":\"0.965656,0.24004,-0.0994816,0,0.0768721,0.101802,0.991832,0,0.248207,-0.965411,0.0798548,0,-22.9606,9.06449,-0.833836,1\",\"occlusionType\":1,\"referenceScanId\":\"c98c9fb7-4713-11ee-bfe6-a86daa000811\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 11:11:42.000','2023-08-30 09:12:44.835','2023-08-30 11:12:44.835'),('39c6835e-4715-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/computedocclusion_370bbb23-4715-11ee-bfe6-a86daa000811/39c6835e-4715-11ee-bfe6-a86daa000811.xyz','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_OCC_370bbb23-4715-11ee-bfe6-a86daa000811_LIFIO','39c6835e-4715-11ee-bfe6-a86daa000811.xyz','39c6835e-4715-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.3.1.1 Ligne de finition Maxillaire pre-scan 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MAXILLAIRE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"c98c9fb7-4713-11ee-bfe6-a86daa000811\",\"referenceScanIsPreScan\":true,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 11:11:42.000','2023-08-30 09:12:44.838','2023-08-30 11:12:44.838'),('39c689b6-4715-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/computedocclusion_370bbb23-4715-11ee-bfe6-a86daa000811/39c689b6-4715-11ee-bfe6-a86daa000811.bin','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_OCC_370bbb23-4715-11ee-bfe6-a86daa000811_LIFIMO','39c689b6-4715-11ee-bfe6-a86daa000811.bin','39c689b6-4715-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.3.1.1 Ligne de finition métadonnées Maxillaire pre-scan 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MAXILLAIRE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"c98c9fb7-4713-11ee-bfe6-a86daa000811\",\"referenceScanIsPreScan\":true,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 11:11:42.000','2023-08-30 09:12:44.842','2023-08-30 11:12:44.842'),('39c6e5de-4715-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/computedocclusion_370bbb23-4715-11ee-bfe6-a86daa000811/39c6e5de-4715-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_OCC_370bbb23-4715-11ee-bfe6-a86daa000811_BOPRE','39c6e5de-4715-11ee-bfe6-a86daa000811.zip','39c6e5de-4715-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.3.1.1 Mandibule pre-scan\",\"modelMatrix\":\"-0.713152,0.693282,-0.103797,0,-0.701009,-0.705292,0.105595,0,-3.83699e-09,0.148068,0.988977,0,14.4127,-15.8463,-14.6529,1\",\"occlusionMatrix\":\"0.973659,0.00997288,-0.227796,0,-0.227954,0.0656111,-0.971459,0,0.00525766,0.997795,0.066156,0,-18.1145,-12.8081,4.3708,1\",\"occlusionType\":1,\"referenceScanId\":\"f5703840-4713-11ee-bfe6-a86daa000811\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 11:11:43.000','2023-08-30 09:12:44.846','2023-08-30 11:12:44.846'),('3a16950d-4715-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/computedocclusion_370bbb23-4715-11ee-bfe6-a86daa000811/3a16950d-4715-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_OCC_370bbb23-4715-11ee-bfe6-a86daa000811_TOPLY','3a16950d-4715-11ee-bfe6-a86daa000811.zip','3a16950d-4715-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.3.1.1 Maxillaire\",\"modelMatrix\":\"0.125146,0.977559,-0.16946,0,-0.992138,0.123307,-0.0213754,0,4.62197e-10,0.170803,0.985305,0,-1.46702,-21.2295,-15.1936,1\",\"occlusionMatrix\":\"0.966054,0.237592,-0.101487,0,0.0758017,0.114871,0.990487,0,0.24699,-0.964552,0.0929628,0,-22.8931,9.23285,-1.15309,1\",\"occlusionType\":1,\"referenceScanId\":\"22084bd2-4714-11ee-bfe6-a86daa000811\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 11:11:44.000','2023-08-30 09:12:44.850','2023-08-30 11:12:44.850'),('3a30cc69-4715-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/computedocclusion_370bbb23-4715-11ee-bfe6-a86daa000811/3a30cc69-4715-11ee-bfe6-a86daa000811.xyz','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_OCC_370bbb23-4715-11ee-bfe6-a86daa000811_LIFIO','3a30cc69-4715-11ee-bfe6-a86daa000811.xyz','3a30cc69-4715-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.3.1.1 Ligne de finition Maxillaire 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MAXILLAIRE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"22084bd2-4714-11ee-bfe6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 11:11:44.000','2023-08-30 09:12:44.853','2023-08-30 11:12:44.853'),('3a30d21c-4715-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/computedocclusion_370bbb23-4715-11ee-bfe6-a86daa000811/3a30d21c-4715-11ee-bfe6-a86daa000811.bin','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_OCC_370bbb23-4715-11ee-bfe6-a86daa000811_LIFIMO','3a30d21c-4715-11ee-bfe6-a86daa000811.bin','3a30d21c-4715-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.3.1.1 Ligne de finition métadonnées Maxillaire 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MAXILLAIRE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"22084bd2-4714-11ee-bfe6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 11:11:44.000','2023-08-30 09:12:44.857','2023-08-30 11:12:44.857'),('3a5d4663-4715-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/computedocclusion_370bbb23-4715-11ee-bfe6-a86daa000811/3a5d4663-4715-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_OCC_370bbb23-4715-11ee-bfe6-a86daa000811_BOPLY','3a5d4663-4715-11ee-bfe6-a86daa000811.zip','3a5d4663-4715-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.3.1.1 Mandibule\",\"modelMatrix\":\"-0.641978,0.756998,-0.121732,0,-0.766723,-0.633835,0.101926,0,5.64993e-09,0.158769,0.987316,0,13.0036,-16.9969,-14.3543,1\",\"occlusionMatrix\":\"0.974543,0.00365913,-0.224182,0,-0.224183,0.0322715,-0.974013,0,0.00367059,0.999474,0.0322705,0,-18.1044,-12.6519,4.86735,1\",\"occlusionType\":1,\"referenceScanId\":\"a3974508-4714-11ee-bfe6-a86daa000811\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 11:11:45.000','2023-08-30 09:12:44.860','2023-08-30 11:12:44.860'),('3a753395-4715-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/computedocclusion_370bbb23-4715-11ee-bfe6-a86daa000811/3a753395-4715-11ee-bfe6-a86daa000811.xyz','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_OCC_370bbb23-4715-11ee-bfe6-a86daa000811_LIFIO','3a753395-4715-11ee-bfe6-a86daa000811.xyz','3a753395-4715-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.3.1.1 Ligne de finition Mandibule 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MANDIBULE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"a3974508-4714-11ee-bfe6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 11:11:45.000','2023-08-30 09:12:44.864','2023-08-30 11:12:44.864'),('3a75389e-4715-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/computedocclusion_370bbb23-4715-11ee-bfe6-a86daa000811/3a75389e-4715-11ee-bfe6-a86daa000811.bin','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_OCC_370bbb23-4715-11ee-bfe6-a86daa000811_LIFIMO','3a75389e-4715-11ee-bfe6-a86daa000811.bin','3a75389e-4715-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.3.1.1 Ligne de finition métadonnées Mandibule 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MANDIBULE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"a3974508-4714-11ee-bfe6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 11:11:45.000','2023-08-30 09:12:44.867','2023-08-30 11:12:44.867'),('3aab0524-4715-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/computedocclusion_370bbb23-4715-11ee-bfe6-a86daa000811/3aab0524-4715-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_OCC_370bbb23-4715-11ee-bfe6-a86daa000811_TOSB','3aab0524-4715-11ee-bfe6-a86daa000811.zip','3aab0524-4715-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.3.1.1 Maxillaire scanbody\",\"modelMatrix\":\"0.529357,0.827389,-0.187642,0,-0.848399,0.516247,-0.117079,0,1.105e-08,0.221172,0.975235,0,-8.58468,-18.9914,-14.3956,1\",\"occlusionMatrix\":\"0.965051,0.237378,-0.111073,0,0.0775771,0.146081,0.986228,0,0.250334,-0.960372,0.122562,0,-22.7458,9.03755,-1.56973,1\",\"occlusionType\":1,\"referenceScanId\":\"57bf381a-4714-11ee-bfe6-a86daa000811\",\"scanBodies\":[{\"position\":\"8.34159,6,0,0,-1.54851,0,6,0,22.2151,0,0,6,1,0,0,0\",\"reference\":\"KECESCANP\",\"tid\":17}]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 11:11:46.000','2023-08-30 09:12:44.871','2023-08-30 11:12:44.871'),('3ada50a1-4717-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c588c3d6-4716-11ee-bfe6-a86daa000811/occlusion_c589e5b6-4716-11ee-bfe6-a86daa000811/scan_19ab91b2-4717-11ee-bfe6-a86daa000811/3ada50a1-4717-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c588c3d6-4716-11ee-bfe6-a86daa000811_SESS_c589e5b6-4716-11ee-bfe6-a86daa000811_LESC_19ab91b2-4717-11ee-bfe6-a86daa000811_MODEL','3ada50a1-4717-11ee-bfe6-a86daa000811.zip','3ada50a1-4717-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mordu gauche 1.1.5.1.1\",\"modelMatrix\":\"-0.999566,-0.0208149,-0.0212319,0,0.020387,-0.99966,0.0161009,0,-0.0212891,0.0157314,0.999645,0,2.712,-3.61166,-17.5584,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 11:26:02.000','2023-08-30 09:27:21.835','2023-08-30 11:27:21.835'),('3ada6922-4717-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c588c3d6-4716-11ee-bfe6-a86daa000811/occlusion_c589e5b6-4716-11ee-bfe6-a86daa000811/scan_19ab91b2-4717-11ee-bfe6-a86daa000811/3ada6922-4717-11ee-bfe6-a86daa000811.png','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c588c3d6-4716-11ee-bfe6-a86daa000811_SESS_c589e5b6-4716-11ee-bfe6-a86daa000811_LESC_19ab91b2-4717-11ee-bfe6-a86daa000811_SNAPS','3ada6922-4717-11ee-bfe6-a86daa000811.png','3ada6922-4717-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mordu gauche 1.1.5.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 11:26:02.000','2023-08-30 09:27:21.838','2023-08-30 11:27:21.838'),('3ae88db9-4715-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/computedocclusion_370bbb23-4715-11ee-bfe6-a86daa000811/3ae88db9-4715-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_OCC_370bbb23-4715-11ee-bfe6-a86daa000811_BOSB','3ae88db9-4715-11ee-bfe6-a86daa000811.zip','3ae88db9-4715-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.3.1.1 Mandibule scanbody\",\"modelMatrix\":\"-0.884595,0.46175,-0.0654155,0,-0.46636,-0.875849,0.12408,0,-8.38836e-11,0.140268,0.990113,0,17.3367,-10.6666,-15.5246,1\",\"occlusionMatrix\":\"0.974099,0.00905413,-0.225949,0,-0.22611,0.0523149,-0.972697,0,0.00301356,0.99859,0.0530072,0,-18.0673,-12.679,4.54205,1\",\"occlusionType\":1,\"referenceScanId\":\"d709480e-4714-11ee-bfe6-a86daa000811\",\"scanBodies\":[{\"position\":\"10.3631,6,0,0,2.10359,0,6,0,20.0179,0,0,6,1,0,0,0\",\"reference\":\"KECESCANP\",\"tid\":47}]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 11:11:47.000','2023-08-30 09:12:44.874','2023-08-30 11:12:44.874'),('3ba46ed3-4715-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/computedocclusion_370bbb23-4715-11ee-bfe6-a86daa000811/3ba46ed3-4715-11ee-bfe6-a86daa000811.png','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_OCC_370bbb23-4715-11ee-bfe6-a86daa000811_SNAPO','3ba46ed3-4715-11ee-bfe6-a86daa000811.png','3ba46ed3-4715-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.3.1.1 Snapshot\",\"occlusionType\":1}','PNG',0,'SYNCED',0,NULL,'2023-08-30 11:11:47.000','2023-08-30 09:12:44.878','2023-08-30 11:12:44.878'),('3fb541ba-4713-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/scan_f4877908-4712-11ee-bfe6-a86daa000811/3fb541ba-4713-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_BOSC_f4877908-4712-11ee-bfe6-a86daa000811_MODEL','3fb541ba-4713-11ee-bfe6-a86daa000811.zip','f4879c4b-4712-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule scanbody 1.1.2.1.3\",\"modelMatrix\":\"-0.380353,0.910375,-0.162942,0,-0.924842,-0.374403,0.067012,0,2.05237e-09,0.176184,0.984357,0,9.3316,-19.9741,-17.0672,1\",\"scanBodies\":[{\"position\":\"9.76708,6,0,0,2.78072,0,6,0,21.3364,0,0,6,1,0,0,0\",\"reference\":\"KECESCANP\",\"tid\":47}]}','ZIP',2,'SYNCED',0,NULL,'2023-08-30 10:57:36.000','2023-08-30 08:59:16.449','2023-08-30 10:59:16.449'),('3fb55e57-4713-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/scan_f4877908-4712-11ee-bfe6-a86daa000811/3fb55e57-4713-11ee-bfe6-a86daa000811.png','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_BOSC_f4877908-4712-11ee-bfe6-a86daa000811_SNAPS','3fb55e57-4713-11ee-bfe6-a86daa000811.png','f48e421b-4712-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule scanbody 1.1.2.1.3 Snapshot\"}','PNG',1,'SYNCED',0,NULL,'2023-08-30 10:57:36.000','2023-08-30 08:59:16.456','2023-08-30 10:59:16.456'),('428f2cc6-4718-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_a0f72d78-4717-11ee-bfe6-a86daa000811/order_404ce5fb-4718-11ee-bfe6-a86daa000811/428f2cc6-4718-11ee-bfe6-a86daa000811.pdf','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_a0f72d78-4717-11ee-bfe6-a86daa000811_PROST_404ce5fb-4718-11ee-bfe6-a86daa000811_FORM','428f2cc6-4718-11ee-bfe6-a86daa000811.pdf','428f2cc6-4718-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Commande 1.1.6.1 Couronne\",\"title\":\"Couronne\"}','PDF',0,'SYNCED',0,NULL,'2023-08-30 11:33:23.000','2023-08-30 09:33:26.400','2023-08-30 11:33:26.400'),('42ed82b0-4718-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_a0f72d78-4717-11ee-bfe6-a86daa000811/order_404ce5fb-4718-11ee-bfe6-a86daa000811/42ed82b0-4718-11ee-bfe6-a86daa000811.pdf','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_a0f72d78-4717-11ee-bfe6-a86daa000811_PROST_404ce5fb-4718-11ee-bfe6-a86daa000811_FORM','42ed82b0-4718-11ee-bfe6-a86daa000811.pdf','42ed82b0-4718-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Commande 1.1.6.1 Couronne\",\"title\":\"Couronne\"}','PDF',0,'SYNCED',0,NULL,'2023-08-30 11:33:23.000','2023-08-30 09:33:26.404','2023-08-30 11:33:26.404'),('473cc8ba-470a-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_94108410-4709-11ee-bfe6-a86daa000811/occlusion_9411ecbc-4709-11ee-bfe6-a86daa000811/scan_29e45423-470a-11ee-bfe6-a86daa000811/473cc8ba-470a-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_94108410-4709-11ee-bfe6-a86daa000811_SESS_9411ecbc-4709-11ee-bfe6-a86daa000811_RISC_29e45423-470a-11ee-bfe6-a86daa000811_MODEL','473cc8ba-470a-11ee-bfe6-a86daa000811.zip','473cc8ba-470a-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mordu droit 1.1.1.1.1\",\"modelMatrix\":\"0.999276,-0.0361552,0.0139208,0,0.0358984,0.996825,-0.0708029,0,-0.0127186,0.0709493,0.997394,0,-5.62121,-7.47021,-16.261,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 09:53:19.000','2023-08-30 08:39:12.046','2023-08-30 10:39:12.046'),('473cddfc-470a-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_94108410-4709-11ee-bfe6-a86daa000811/occlusion_9411ecbc-4709-11ee-bfe6-a86daa000811/scan_29e45423-470a-11ee-bfe6-a86daa000811/473cddfc-470a-11ee-bfe6-a86daa000811.png','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_94108410-4709-11ee-bfe6-a86daa000811_SESS_9411ecbc-4709-11ee-bfe6-a86daa000811_RISC_29e45423-470a-11ee-bfe6-a86daa000811_SNAPS','473cddfc-470a-11ee-bfe6-a86daa000811.png','473cddfc-470a-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mordu droit 1.1.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 09:53:19.000','2023-08-30 08:39:12.050','2023-08-30 10:39:12.050'),('4f2156ce-4713-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/computedocclusion_4b957ea0-4713-11ee-bfe6-a86daa000811/4f2156ce-4713-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_OCC_4b957ea0-4713-11ee-bfe6-a86daa000811_TOPRE','4f2156ce-4713-11ee-bfe6-a86daa000811.zip','4f2156ce-4713-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.2.1.1 Maxillaire pre-scan\",\"modelMatrix\":\"0.189853,0.979669,-0.0648368,0,-0.981813,0.189438,-0.0125375,0,6.71197e-10,0.0660378,0.997817,0,-8.26577,-24.6072,-16.2003,1\",\"occlusionMatrix\":\"0.994321,0.0654057,0.0839659,0,-0.096148,0.213629,0.972172,0,0.0456479,-0.974725,0.218704,0,-24.278,13.1575,-2.50894,1\",\"occlusionType\":1,\"referenceScanId\":\"29fbd842-4711-11ee-bfe6-a86daa000811\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 10:57:57.000','2023-08-30 08:59:16.459','2023-08-30 10:59:16.459'),('4f4b7bb9-4713-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/computedocclusion_4b957ea0-4713-11ee-bfe6-a86daa000811/4f4b7bb9-4713-11ee-bfe6-a86daa000811.xyz','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_OCC_4b957ea0-4713-11ee-bfe6-a86daa000811_LIFIO','4f4b7bb9-4713-11ee-bfe6-a86daa000811.xyz','4f4b7bb9-4713-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.2.1.1 Ligne de finition Maxillaire 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MAXILLAIRE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"29fbd842-4711-11ee-bfe6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 10:57:57.000','2023-08-30 08:59:16.462','2023-08-30 10:59:16.462'),('4f4b8104-4713-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/computedocclusion_4b957ea0-4713-11ee-bfe6-a86daa000811/4f4b8104-4713-11ee-bfe6-a86daa000811.bin','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_OCC_4b957ea0-4713-11ee-bfe6-a86daa000811_LIFIMO','4f4b8104-4713-11ee-bfe6-a86daa000811.bin','4f4b8104-4713-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.2.1.1 Ligne de finition métadonnées Maxillaire 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MAXILLAIRE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"29fbd842-4711-11ee-bfe6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 10:57:57.000','2023-08-30 08:59:16.466','2023-08-30 10:59:16.466'),('4f4bfc45-4713-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/computedocclusion_4b957ea0-4713-11ee-bfe6-a86daa000811/4f4bfc45-4713-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_OCC_4b957ea0-4713-11ee-bfe6-a86daa000811_BOPRE','4f4bfc45-4713-11ee-bfe6-a86daa000811.zip','4f4bfc45-4713-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.2.1.1 Mandibule pre-scan\",\"modelMatrix\":\"-0.447168,0.886774,-0.116929,0,-0.89445,-0.44333,0.0584568,0,-2.52717e-09,0.130727,0.991418,0,10.811,-18.3152,-17.9512,1\",\"occlusionMatrix\":\"0.988718,-0.117464,-0.0929462,0,-0.098418,-0.0416625,-0.994273,0,0.112919,0.992202,-0.052752,0,-22.91,-12.5322,5.62919,1\",\"occlusionType\":1,\"referenceScanId\":\"64dba54e-4712-11ee-bfe6-a86daa000811\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 10:57:58.000','2023-08-30 08:59:16.469','2023-08-30 10:59:16.469'),('4f51891d-470a-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_94108410-4709-11ee-bfe6-a86daa000811/occlusion_9411ecbc-4709-11ee-bfe6-a86daa000811/computedocclusion_4bddb249-470a-11ee-bfe6-a86daa000811/4f51891d-470a-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_94108410-4709-11ee-bfe6-a86daa000811_SESS_9411ecbc-4709-11ee-bfe6-a86daa000811_OCC_4bddb249-470a-11ee-bfe6-a86daa000811_TOPLY','4f51891d-470a-11ee-bfe6-a86daa000811.zip','4f51891d-470a-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.1.1.1 Maxillaire\",\"modelMatrix\":\"-0.0757858,0.972558,-0.21997,0,-0.997124,-0.0739187,0.0167187,0,9.42286e-10,0.220604,0.975363,0,3.34696,-23.8901,-16.2781,1\",\"occlusionMatrix\":\"0.935294,0.348746,0.0599943,0,-0.141484,0.21314,0.966721,0,0.324353,-0.912659,0.248691,0,-27.044,7.63512,-9.06101,1\",\"occlusionType\":1,\"referenceScanId\":\"978d31c9-4709-11ee-bfe6-a86daa000811\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 09:53:32.000','2023-08-30 08:39:12.054','2023-08-30 10:39:12.054'),('4f674de1-4717-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c588c3d6-4716-11ee-bfe6-a86daa000811/occlusion_c589e5b6-4716-11ee-bfe6-a86daa000811/computedocclusion_4b839b32-4717-11ee-bfe6-a86daa000811/4f674de1-4717-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c588c3d6-4716-11ee-bfe6-a86daa000811_SESS_c589e5b6-4716-11ee-bfe6-a86daa000811_OCC_4b839b32-4717-11ee-bfe6-a86daa000811_TOPLY','4f674de1-4717-11ee-bfe6-a86daa000811.zip','4f674de1-4717-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.5.1.1 Maxillaire\",\"modelMatrix\":\"0.917947,0.390606,-0.069279,0,-0.396702,0.903841,-0.160308,0,2.55916e-09,0.174637,0.984633,0,-17.3382,-7.21651,-17.8042,1\",\"occlusionMatrix\":\"-0.993861,0.0379708,-0.103938,0,0.106306,0.0668386,-0.992087,0,-0.0307231,-0.997043,-0.0704649,0,16.9153,14.6578,-0.0753994,1\",\"occlusionType\":2,\"referenceScanId\":\"c9e996cb-4716-11ee-bfe6-a86daa000811\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 11:26:36.000','2023-08-30 09:27:21.841','2023-08-30 11:27:21.841'),('4f6bdc64-4713-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/computedocclusion_4b957ea0-4713-11ee-bfe6-a86daa000811/4f6bdc64-4713-11ee-bfe6-a86daa000811.xyz','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_OCC_4b957ea0-4713-11ee-bfe6-a86daa000811_LIFIO','4f6bdc64-4713-11ee-bfe6-a86daa000811.xyz','4f6bdc64-4713-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.2.1.1 Ligne de finition Mandibule 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MANDIBULE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"64dba54e-4712-11ee-bfe6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 10:57:58.000','2023-08-30 08:59:16.472','2023-08-30 10:59:16.472'),('4f6bdff0-4713-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/computedocclusion_4b957ea0-4713-11ee-bfe6-a86daa000811/4f6bdff0-4713-11ee-bfe6-a86daa000811.bin','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_OCC_4b957ea0-4713-11ee-bfe6-a86daa000811_LIFIMO','4f6bdff0-4713-11ee-bfe6-a86daa000811.bin','4f6bdff0-4713-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.2.1.1 Ligne de finition métadonnées Mandibule 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MANDIBULE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"64dba54e-4712-11ee-bfe6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 10:57:58.000','2023-08-30 08:59:16.474','2023-08-30 10:59:16.474'),('4f7c4187-470a-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_94108410-4709-11ee-bfe6-a86daa000811/occlusion_9411ecbc-4709-11ee-bfe6-a86daa000811/computedocclusion_4bddb249-470a-11ee-bfe6-a86daa000811/4f7c4187-470a-11ee-bfe6-a86daa000811.xyz','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_94108410-4709-11ee-bfe6-a86daa000811_SESS_9411ecbc-4709-11ee-bfe6-a86daa000811_OCC_4bddb249-470a-11ee-bfe6-a86daa000811_LIFIO','4f7c4187-470a-11ee-bfe6-a86daa000811.xyz','4f7c4187-470a-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.1.1.1 Ligne de finition Maxillaire 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MAXILLAIRE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"978d31c9-4709-11ee-bfe6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 09:53:32.000','2023-08-30 08:39:12.057','2023-08-30 10:39:12.057'),('4f7c4840-470a-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_94108410-4709-11ee-bfe6-a86daa000811/occlusion_9411ecbc-4709-11ee-bfe6-a86daa000811/computedocclusion_4bddb249-470a-11ee-bfe6-a86daa000811/4f7c4840-470a-11ee-bfe6-a86daa000811.bin','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_94108410-4709-11ee-bfe6-a86daa000811_SESS_9411ecbc-4709-11ee-bfe6-a86daa000811_OCC_4bddb249-470a-11ee-bfe6-a86daa000811_LIFIMO','4f7c4840-470a-11ee-bfe6-a86daa000811.bin','4f7c4840-470a-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.1.1.1 Ligne de finition métadonnées Maxillaire 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MAXILLAIRE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"978d31c9-4709-11ee-bfe6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 09:53:32.000','2023-08-30 08:39:12.061','2023-08-30 10:39:12.061'),('4f7c8df6-470a-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_94108410-4709-11ee-bfe6-a86daa000811/occlusion_9411ecbc-4709-11ee-bfe6-a86daa000811/computedocclusion_4bddb249-470a-11ee-bfe6-a86daa000811/4f7c8df6-470a-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_94108410-4709-11ee-bfe6-a86daa000811_SESS_9411ecbc-4709-11ee-bfe6-a86daa000811_OCC_4bddb249-470a-11ee-bfe6-a86daa000811_BOPLY','4f7c8df6-470a-11ee-bfe6-a86daa000811.zip','4f7c8df6-470a-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.1.1.1 Mandibule\",\"modelMatrix\":\"-0.809032,0.574992,-0.121868,0,-0.587765,-0.79145,0.167746,0,-4.06461e-09,0.207342,0.978268,0,22.3948,-18.518,-15.8746,1\",\"occlusionMatrix\":\"0.998498,-0.0296649,0.0461157,0,0.0460273,-0.00365332,-0.998935,0,0.0298018,0.999555,-0.00228392,0,-25.7815,-14.3925,0.777437,1\",\"occlusionType\":1,\"referenceScanId\":\"ddb8b416-4709-11ee-bfe6-a86daa000811\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 09:53:35.000','2023-08-30 08:39:12.064','2023-08-30 10:39:12.064'),('4f826c6b-4717-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c588c3d6-4716-11ee-bfe6-a86daa000811/occlusion_c589e5b6-4716-11ee-bfe6-a86daa000811/computedocclusion_4b839b32-4717-11ee-bfe6-a86daa000811/4f826c6b-4717-11ee-bfe6-a86daa000811.xyz','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c588c3d6-4716-11ee-bfe6-a86daa000811_SESS_c589e5b6-4716-11ee-bfe6-a86daa000811_OCC_4b839b32-4717-11ee-bfe6-a86daa000811_LIFIO','4f826c6b-4717-11ee-bfe6-a86daa000811.xyz','4f826c6b-4717-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.5.1.1 Ligne de finition Maxillaire 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MAXILLAIRE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"c9e996cb-4716-11ee-bfe6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 11:26:37.000','2023-08-30 09:27:21.845','2023-08-30 11:27:21.845'),('4f8270ca-4717-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c588c3d6-4716-11ee-bfe6-a86daa000811/occlusion_c589e5b6-4716-11ee-bfe6-a86daa000811/computedocclusion_4b839b32-4717-11ee-bfe6-a86daa000811/4f8270ca-4717-11ee-bfe6-a86daa000811.bin','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c588c3d6-4716-11ee-bfe6-a86daa000811_SESS_c589e5b6-4716-11ee-bfe6-a86daa000811_OCC_4b839b32-4717-11ee-bfe6-a86daa000811_LIFIMO','4f8270ca-4717-11ee-bfe6-a86daa000811.bin','4f8270ca-4717-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.5.1.1 Ligne de finition métadonnées Maxillaire 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MAXILLAIRE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"c9e996cb-4716-11ee-bfe6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 11:26:37.000','2023-08-30 09:27:21.848','2023-08-30 11:27:21.848'),('4f82ccb6-4717-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c588c3d6-4716-11ee-bfe6-a86daa000811/occlusion_c589e5b6-4716-11ee-bfe6-a86daa000811/computedocclusion_4b839b32-4717-11ee-bfe6-a86daa000811/4f82ccb6-4717-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c588c3d6-4716-11ee-bfe6-a86daa000811_SESS_c589e5b6-4716-11ee-bfe6-a86daa000811_OCC_4b839b32-4717-11ee-bfe6-a86daa000811_BOPLY','4f82ccb6-4717-11ee-bfe6-a86daa000811.zip','4f82ccb6-4717-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.5.1.1 Mandibule\",\"modelMatrix\":\"-0.875479,0.476246,-0.0820169,0,-0.483256,-0.862778,0.148584,0,-7.60182e-09,0.169717,0.985493,0,16.5273,-7.76453,-15.6336,1\",\"occlusionMatrix\":\"-0.995616,-0.0898431,-0.0261111,0,-0.0415621,0.17467,0.98375,0,-0.0838224,0.980521,-0.177639,0,20.2025,-11.0346,-0.17024,1\",\"occlusionType\":2,\"referenceScanId\":\"fcb9257d-4716-11ee-bfe6-a86daa000811\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 11:26:38.000','2023-08-30 09:27:21.853','2023-08-30 11:27:21.853'),('4fa9239c-470a-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_94108410-4709-11ee-bfe6-a86daa000811/occlusion_9411ecbc-4709-11ee-bfe6-a86daa000811/computedocclusion_4bddb249-470a-11ee-bfe6-a86daa000811/4fa9239c-470a-11ee-bfe6-a86daa000811.xyz','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_94108410-4709-11ee-bfe6-a86daa000811_SESS_9411ecbc-4709-11ee-bfe6-a86daa000811_OCC_4bddb249-470a-11ee-bfe6-a86daa000811_LIFIO','4fa9239c-470a-11ee-bfe6-a86daa000811.xyz','4fa9239c-470a-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.1.1.1 Ligne de finition Mandibule 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MANDIBULE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"ddb8b416-4709-11ee-bfe6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 09:53:35.000','2023-08-30 08:39:12.068','2023-08-30 10:39:12.068'),('4fa92977-470a-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_94108410-4709-11ee-bfe6-a86daa000811/occlusion_9411ecbc-4709-11ee-bfe6-a86daa000811/computedocclusion_4bddb249-470a-11ee-bfe6-a86daa000811/4fa92977-470a-11ee-bfe6-a86daa000811.bin','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_94108410-4709-11ee-bfe6-a86daa000811_SESS_9411ecbc-4709-11ee-bfe6-a86daa000811_OCC_4bddb249-470a-11ee-bfe6-a86daa000811_LIFIMO','4fa92977-470a-11ee-bfe6-a86daa000811.bin','4fa92977-470a-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.1.1.1 Ligne de finition métadonnées Mandibule 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MANDIBULE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"ddb8b416-4709-11ee-bfe6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 09:53:36.000','2023-08-30 08:39:12.071','2023-08-30 10:39:12.071'),('4fb4073e-4713-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/computedocclusion_4b957ea0-4713-11ee-bfe6-a86daa000811/4fb4073e-4713-11ee-bfe6-a86daa000811.png','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_OCC_4b957ea0-4713-11ee-bfe6-a86daa000811_SNAPO','4fb4073e-4713-11ee-bfe6-a86daa000811.png','4fb4073e-4713-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.2.1.1 Snapshot\",\"occlusionType\":1}','PNG',0,'SYNCED',0,NULL,'2023-08-30 10:57:58.000','2023-08-30 08:59:16.478','2023-08-30 10:59:16.478'),('4fd6f395-4717-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c588c3d6-4716-11ee-bfe6-a86daa000811/occlusion_c589e5b6-4716-11ee-bfe6-a86daa000811/computedocclusion_4b839b32-4717-11ee-bfe6-a86daa000811/4fd6f395-4717-11ee-bfe6-a86daa000811.png','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c588c3d6-4716-11ee-bfe6-a86daa000811_SESS_c589e5b6-4716-11ee-bfe6-a86daa000811_OCC_4b839b32-4717-11ee-bfe6-a86daa000811_SNAPO','4fd6f395-4717-11ee-bfe6-a86daa000811.png','4fd6f395-4717-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.5.1.1 Snapshot\",\"occlusionType\":2}','PNG',0,'SYNCED',0,NULL,'2023-08-30 11:26:38.000','2023-08-30 09:27:21.857','2023-08-30 11:27:21.857'),('4ff6737a-470a-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_94108410-4709-11ee-bfe6-a86daa000811/occlusion_9411ecbc-4709-11ee-bfe6-a86daa000811/computedocclusion_4bddb249-470a-11ee-bfe6-a86daa000811/4ff6737a-470a-11ee-bfe6-a86daa000811.png','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_94108410-4709-11ee-bfe6-a86daa000811_SESS_9411ecbc-4709-11ee-bfe6-a86daa000811_OCC_4bddb249-470a-11ee-bfe6-a86daa000811_SNAPO','4ff6737a-470a-11ee-bfe6-a86daa000811.png','4ff6737a-470a-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.1.1.1 Snapshot\",\"occlusionType\":1}','PNG',0,'SYNCED',0,NULL,'2023-08-30 09:53:36.000','2023-08-30 08:39:12.075','2023-08-30 10:39:12.075'),('52114939-4714-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/scan_22084bd2-4714-11ee-bfe6-a86daa000811/52114939-4714-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_TOSC_22084bd2-4714-11ee-bfe6-a86daa000811_MODEL','52114939-4714-11ee-bfe6-a86daa000811.zip','22086add-4714-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.3.1.2\",\"modelMatrix\":\"0.125146,0.977559,-0.16946,0,-0.992138,0.123307,-0.0213754,0,4.62197e-10,0.170803,0.985305,0,-1.46702,-21.2295,-15.1936,1\",\"scanBodies\":[]}','ZIP',2,'SYNCED',0,NULL,'2023-08-30 11:05:09.684','2023-08-30 09:05:10.228','2023-08-30 11:05:14.098'),('52115f0c-4714-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/scan_22084bd2-4714-11ee-bfe6-a86daa000811/52115f0c-4714-11ee-bfe6-a86daa000811.png','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_TOSC_22084bd2-4714-11ee-bfe6-a86daa000811_SNAPS','52115f0c-4714-11ee-bfe6-a86daa000811.png','220e9272-4714-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.3.1.2 Snapshot\"}','PNG',1,'SYNCED',0,NULL,'2023-08-30 11:05:09.685','2023-08-30 09:05:10.229','2023-08-30 11:05:15.013'),('544f0e3a-4712-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/scan_de5dfda1-4711-11ee-bfe6-a86daa000811/544f0e3a-4712-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_TOSC_de5dfda1-4711-11ee-bfe6-a86daa000811_MODEL','544f0e3a-4712-11ee-bfe6-a86daa000811.zip','de5e212b-4711-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire scanbody 1.1.2.1.3\",\"modelMatrix\":\"0.720602,0.690336,-0.0645598,0,-0.693349,0.717472,-0.0670974,0,-4.6345e-09,0.093113,0.995656,0,-19.6515,-15.5225,-16.3779,1\",\"scanBodies\":[{\"position\":\"12.4666,6,0,0,-2.39693,0,6,0,19.2857,0,0,6,1,0,0,0\",\"reference\":\"K30PSCANP\",\"tid\":17}]}','ZIP',2,'SYNCED',0,NULL,'2023-08-30 10:51:01.000','2023-08-30 08:59:16.485','2023-08-30 10:59:16.485'),('544f3fbb-4712-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/scan_de5dfda1-4711-11ee-bfe6-a86daa000811/544f3fbb-4712-11ee-bfe6-a86daa000811.png','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_TOSC_de5dfda1-4711-11ee-bfe6-a86daa000811_SNAPS','544f3fbb-4712-11ee-bfe6-a86daa000811.png','de663fe2-4711-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire scanbody 1.1.2.1.3 Snapshot\"}','PNG',1,'SYNCED',0,NULL,'2023-08-30 10:51:01.000','2023-08-30 08:59:16.492','2023-08-30 10:59:16.492'),('54d5b99b-4715-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/scan_f5703840-4713-11ee-bfe6-a86daa000811/54d5b99b-4715-11ee-bfe6-a86daa000811.xyz','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_BOSC_f5703840-4713-11ee-bfe6-a86daa000811_LIFI','54d5b99b-4715-11ee-bfe6-a86daa000811.xyz','54d5b99b-4715-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule pre-scan 1.1.3.1.1 Ligne de finition 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 11:12:23.824','2023-08-30 09:12:23.827','2023-08-30 11:12:23.860'),('54d5bec8-4715-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/scan_f5703840-4713-11ee-bfe6-a86daa000811/54d5bec8-4715-11ee-bfe6-a86daa000811.bin','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_BOSC_f5703840-4713-11ee-bfe6-a86daa000811_LIFIM','54d5bec8-4715-11ee-bfe6-a86daa000811.bin','54d5bec8-4715-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule pre-scan 1.1.3.1.1 Ligne de finition métadonnées 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 11:12:23.824','2023-08-30 09:12:23.828','2023-08-30 11:12:24.298'),('54d9092d-4715-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/computedocclusion_370bbb23-4715-11ee-bfe6-a86daa000811/54d9092d-4715-11ee-bfe6-a86daa000811.xyz','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_OCC_370bbb23-4715-11ee-bfe6-a86daa000811_LIFIO','54d9092d-4715-11ee-bfe6-a86daa000811.xyz','54d9092d-4715-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.3.1.1 Ligne de finition Mandibule pre-scan 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MANDIBULE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"f5703840-4713-11ee-bfe6-a86daa000811\",\"referenceScanIsPreScan\":true,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 11:12:24.000','2023-08-30 09:12:44.881','2023-08-30 11:12:44.881'),('54d90bb3-4715-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/computedocclusion_370bbb23-4715-11ee-bfe6-a86daa000811/54d90bb3-4715-11ee-bfe6-a86daa000811.bin','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_OCC_370bbb23-4715-11ee-bfe6-a86daa000811_LIFIMO','54d90bb3-4715-11ee-bfe6-a86daa000811.bin','54d90bb3-4715-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.3.1.1 Ligne de finition métadonnées Mandibule pre-scan 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MANDIBULE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"f5703840-4713-11ee-bfe6-a86daa000811\",\"referenceScanIsPreScan\":true,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 11:12:25.000','2023-08-30 09:12:44.885','2023-08-30 11:12:44.885'),('557f540b-4713-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/computedocclusion_4b957ea0-4713-11ee-bfe6-a86daa000811/557f540b-4713-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_OCC_4b957ea0-4713-11ee-bfe6-a86daa000811_BOPLY','557f540b-4713-11ee-bfe6-a86daa000811.zip','557f540b-4713-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.2.1.1 Mandibule\",\"modelMatrix\":\"-0.409402,0.900441,-0.146959,0,-0.912354,-0.404056,0.0659451,0,6.03451e-09,0.161077,0.986942,0,10.1898,-19.9483,-17.5344,1\",\"occlusionMatrix\":\"0.989673,-0.109811,-0.092159,0,-0.0971865,-0.0413349,-0.99441,0,0.105388,0.993093,-0.0515791,0,-22.7664,-12.5683,5.59704,1\",\"occlusionType\":1,\"referenceScanId\":\"b5ac3d30-4712-11ee-bfe6-a86daa000811\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 10:58:07.000','2023-08-30 08:59:16.495','2023-08-30 10:59:16.495'),('559ab1a3-4713-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/computedocclusion_4b957ea0-4713-11ee-bfe6-a86daa000811/559ab1a3-4713-11ee-bfe6-a86daa000811.xyz','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_OCC_4b957ea0-4713-11ee-bfe6-a86daa000811_LIFIO','559ab1a3-4713-11ee-bfe6-a86daa000811.xyz','559ab1a3-4713-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.2.1.1 Ligne de finition Mandibule 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MANDIBULE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"b5ac3d30-4712-11ee-bfe6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 10:58:07.000','2023-08-30 08:59:16.498','2023-08-30 10:59:16.498'),('559ab8f8-4713-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/computedocclusion_4b957ea0-4713-11ee-bfe6-a86daa000811/559ab8f8-4713-11ee-bfe6-a86daa000811.bin','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_OCC_4b957ea0-4713-11ee-bfe6-a86daa000811_LIFIMO','559ab8f8-4713-11ee-bfe6-a86daa000811.bin','559ab8f8-4713-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.2.1.1 Ligne de finition métadonnées Mandibule 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MANDIBULE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"b5ac3d30-4712-11ee-bfe6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 10:58:07.000','2023-08-30 08:59:16.501','2023-08-30 10:59:16.501'),('57bf5ba5-4714-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/scan_57bf381a-4714-11ee-bfe6-a86daa000811/57bf5ba5-4714-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_TOSC_57bf381a-4714-11ee-bfe6-a86daa000811_MODEL','57bf5ba5-4714-11ee-bfe6-a86daa000811.zip','57bf5ba5-4714-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.3.1.3\",\"modelMatrix\":\"0.125146,0.977559,-0.16946,0,-0.992138,0.123307,-0.0213754,0,4.62197e-10,0.170803,0.985305,0,-1.46702,-21.2295,-15.1936,1\",\"scanBodies\":[{\"position\":\"8.34159,6,0,0,-1.54851,0,6,0,22.2151,0,0,6,1,0,0,0\",\"reference\":\"KECESCANP\",\"tid\":17}]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 11:05:19.214','2023-08-30 09:07:22.416','2023-08-30 11:07:25.384'),('57c53e7b-4714-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/scan_57bf381a-4714-11ee-bfe6-a86daa000811/57c53e7b-4714-11ee-bfe6-a86daa000811.png','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_TOSC_57bf381a-4714-11ee-bfe6-a86daa000811_SNAPS','57c53e7b-4714-11ee-bfe6-a86daa000811.png','57c53e7b-4714-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.3.1.3 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 11:05:19.252','2023-08-30 09:07:22.417','2023-08-30 11:07:30.124'),('5998ed51-4713-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/computedocclusion_4b957ea0-4713-11ee-bfe6-a86daa000811/5998ed51-4713-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_OCC_4b957ea0-4713-11ee-bfe6-a86daa000811_BOSB','5998ed51-4713-11ee-bfe6-a86daa000811.zip','5998ed51-4713-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.2.1.1 Mandibule scanbody\",\"modelMatrix\":\"-0.380353,0.910375,-0.162942,0,-0.924842,-0.374403,0.067012,0,2.05237e-09,0.176184,0.984357,0,9.3316,-19.9741,-17.0672,1\",\"occlusionMatrix\":\"0.98961,-0.103365,-0.10001,0,-0.104252,-0.0364644,-0.993887,0,0.0990865,0.993978,-0.0468613,0,-22.6654,-12.716,5.641,1\",\"occlusionType\":1,\"referenceScanId\":\"f4877908-4712-11ee-bfe6-a86daa000811\",\"scanBodies\":[{\"position\":\"9.76708,6,0,0,2.78072,0,6,0,21.3364,0,0,6,1,0,0,0\",\"reference\":\"KECESCANP\",\"tid\":47}]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 10:58:14.000','2023-08-30 08:59:16.505','2023-08-30 10:59:16.505'),('5c5e63c7-4712-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/scan_29fbd842-4711-11ee-bfe6-a86daa000811/5c5e63c7-4712-11ee-bfe6-a86daa000811.xyz','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_TOSC_29fbd842-4711-11ee-bfe6-a86daa000811_LIFI','5c5e63c7-4712-11ee-bfe6-a86daa000811.xyz','5c5e63c7-4712-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.2.1.1 Ligne de finition 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 10:51:08.000','2023-08-30 08:59:16.508','2023-08-30 10:59:16.508'),('5c5e6923-4712-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/scan_29fbd842-4711-11ee-bfe6-a86daa000811/5c5e6923-4712-11ee-bfe6-a86daa000811.bin','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_TOSC_29fbd842-4711-11ee-bfe6-a86daa000811_LIFIM','5c5e6923-4712-11ee-bfe6-a86daa000811.bin','5c5e6923-4712-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.2.1.1 Ligne de finition métadonnées 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 10:51:08.000','2023-08-30 08:59:16.511','2023-08-30 10:59:16.511'),('5cd37d0e-4717-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c588c3d6-4716-11ee-bfe6-a86daa000811/occlusion_c589e5b6-4716-11ee-bfe6-a86daa000811/scan_fcb9257d-4716-11ee-bfe6-a86daa000811/5cd37d0e-4717-11ee-bfe6-a86daa000811.png','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c588c3d6-4716-11ee-bfe6-a86daa000811_SESS_c589e5b6-4716-11ee-bfe6-a86daa000811_BOSC_fcb9257d-4716-11ee-bfe6-a86daa000811_SCREENS','5cd37d0e-4717-11ee-bfe6-a86daa000811.png','5cd37d0e-4717-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.5.1.1 Capture d\'écran 1\",\"title\":\"1\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 11:26:56.225','2023-08-30 09:26:56.291','2023-08-30 11:26:56.306'),('5f183485-4713-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/computedocclusion_4b957ea0-4713-11ee-bfe6-a86daa000811/5f183485-4713-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_OCC_4b957ea0-4713-11ee-bfe6-a86daa000811_TOPLY','5f183485-4713-11ee-bfe6-a86daa000811.zip','5f183485-4713-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.2.1.1 Maxillaire\",\"modelMatrix\":\"0.635277,0.77038,-0.0542015,0,-0.772285,0.63371,-0.0445859,0,-8.20249e-10,0.0701834,0.997534,0,-19.0629,-18.3955,-17.2773,1\",\"occlusionMatrix\":\"0.994877,0.0617611,0.0800674,0,-0.091613,0.215329,0.972235,0,0.0428057,-0.974588,0.219883,0,-24.0609,13.2734,-2.44794,1\",\"occlusionType\":1,\"referenceScanId\":\"79ca2646-4711-11ee-bfe6-a86daa000811\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 10:58:24.000','2023-08-30 08:59:16.514','2023-08-30 10:59:16.514'),('5f3b3763-4713-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/computedocclusion_4b957ea0-4713-11ee-bfe6-a86daa000811/5f3b3763-4713-11ee-bfe6-a86daa000811.xyz','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_OCC_4b957ea0-4713-11ee-bfe6-a86daa000811_LIFIO','5f3b3763-4713-11ee-bfe6-a86daa000811.xyz','5f3b3763-4713-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.2.1.1 Ligne de finition Maxillaire 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MAXILLAIRE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"79ca2646-4711-11ee-bfe6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 10:58:24.000','2023-08-30 08:59:16.517','2023-08-30 10:59:16.517'),('5f3b3dac-4713-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/computedocclusion_4b957ea0-4713-11ee-bfe6-a86daa000811/5f3b3dac-4713-11ee-bfe6-a86daa000811.bin','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_OCC_4b957ea0-4713-11ee-bfe6-a86daa000811_LIFIMO','5f3b3dac-4713-11ee-bfe6-a86daa000811.bin','5f3b3dac-4713-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.2.1.1 Ligne de finition métadonnées Maxillaire 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"MAXILLAIRE\",\"referenceScanHasScanBody\":false,\"referenceScanId\":\"79ca2646-4711-11ee-bfe6-a86daa000811\",\"referenceScanIsPreScan\":false,\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 10:58:24.000','2023-08-30 08:59:16.521','2023-08-30 10:59:16.521'),('5f7a5af2-4715-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/order_c7a92194-4713-11ee-bfe6-a86daa000811/5f7a5af2-4715-11ee-bfe6-a86daa000811.pdf','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_PROST_c7a92194-4713-11ee-bfe6-a86daa000811_FORM','5f7a5af2-4715-11ee-bfe6-a86daa000811.pdf','5f7a5af2-4715-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Commande 1.1.3.1 Couronne sur implant\",\"title\":\"Couronne sur implant\"}','PDF',0,'SYNCED',0,NULL,'2023-08-30 11:12:41.680','2023-08-30 09:12:42.297','2023-08-30 11:12:42.419'),('5fc0dd4c-4717-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c588c3d6-4716-11ee-bfe6-a86daa000811/occlusion_c589e5b6-4716-11ee-bfe6-a86daa000811/scan_c9e996cb-4716-11ee-bfe6-a86daa000811/5fc0dd4c-4717-11ee-bfe6-a86daa000811.png','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c588c3d6-4716-11ee-bfe6-a86daa000811_SESS_c589e5b6-4716-11ee-bfe6-a86daa000811_TOSC_c9e996cb-4716-11ee-bfe6-a86daa000811_SCREENS','5fc0dd4c-4717-11ee-bfe6-a86daa000811.png','5fc0dd4c-4717-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.5.1.1 Capture d\'écran 1\",\"title\":\"1\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 11:27:01.135','2023-08-30 09:27:01.197','2023-08-30 11:27:01.213'),('5fcd3ac4-4712-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/scan_79ca2646-4711-11ee-bfe6-a86daa000811/5fcd3ac4-4712-11ee-bfe6-a86daa000811.xyz','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_TOSC_79ca2646-4711-11ee-bfe6-a86daa000811_LIFI','5fcd3ac4-4712-11ee-bfe6-a86daa000811.xyz','5fcd3ac4-4712-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.2.1.2 Ligne de finition 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 10:51:14.000','2023-08-30 08:59:16.524','2023-08-30 10:59:16.524'),('5fcd3ff6-4712-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/scan_79ca2646-4711-11ee-bfe6-a86daa000811/5fcd3ff6-4712-11ee-bfe6-a86daa000811.bin','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_TOSC_79ca2646-4711-11ee-bfe6-a86daa000811_LIFIM','5fcd3ff6-4712-11ee-bfe6-a86daa000811.bin','5fcd3ff6-4712-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.2.1.2 Ligne de finition métadonnées 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 10:51:14.000','2023-08-30 08:59:16.527','2023-08-30 10:59:16.527'),('601256c0-4711-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/scan_29fbd842-4711-11ee-bfe6-a86daa000811/601256c0-4711-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_TOSC_29fbd842-4711-11ee-bfe6-a86daa000811_MODEL','601256c0-4711-11ee-bfe6-a86daa000811.zip','601256c0-4711-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.2.1.1\",\"modelMatrix\":\"0.189853,0.979669,-0.0648368,0,-0.981813,0.189438,-0.0125375,0,6.71197e-10,0.0660378,0.997817,0,-8.26577,-24.6072,-16.2003,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 10:44:09.000','2023-08-30 08:59:16.530','2023-08-30 10:59:16.530'),('60126fc7-4711-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/scan_29fbd842-4711-11ee-bfe6-a86daa000811/60126fc7-4711-11ee-bfe6-a86daa000811.png','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_TOSC_29fbd842-4711-11ee-bfe6-a86daa000811_SNAPS','60126fc7-4711-11ee-bfe6-a86daa000811.png','60126fc7-4711-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.2.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 10:44:10.000','2023-08-30 08:59:16.533','2023-08-30 10:59:16.533'),('601350b9-4714-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/scan_57bf381a-4714-11ee-bfe6-a86daa000811/601350b9-4714-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_TOSC_57bf381a-4714-11ee-bfe6-a86daa000811_MODEL','601350b9-4714-11ee-bfe6-a86daa000811.zip','57bf5ba5-4714-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire scanbody 1.1.3.1.3\",\"modelMatrix\":\"0.125146,0.977559,-0.16946,0,-0.992138,0.123307,-0.0213754,0,4.62197e-10,0.170803,0.985305,0,-1.46702,-21.2295,-15.1936,1\",\"scanBodies\":[{\"position\":\"8.34159,6,0,0,-1.54851,0,6,0,22.2151,0,0,6,1,0,0,0\",\"reference\":\"KECESCANP\",\"tid\":17}]}','ZIP',1,'SYNCED',0,NULL,'2023-08-30 11:05:33.186','2023-08-30 09:07:22.416','2023-08-30 11:07:26.433'),('6557d3c6-4713-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/computedocclusion_4b957ea0-4713-11ee-bfe6-a86daa000811/6557d3c6-4713-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_OCC_4b957ea0-4713-11ee-bfe6-a86daa000811_TOSB','6557d3c6-4713-11ee-bfe6-a86daa000811.zip','6557d3c6-4713-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Occlusion 1.1.2.1.1 Maxillaire scanbody\",\"modelMatrix\":\"0.720602,0.690336,-0.0645598,0,-0.693349,0.717472,-0.0670974,0,-4.6345e-09,0.093113,0.995656,0,-19.6515,-15.5225,-16.3779,1\",\"occlusionMatrix\":\"0.994754,0.0603476,0.0826282,0,-0.0943034,0.227397,0.969226,0,0.0397013,-0.971931,0.231895,0,-23.9273,13.0875,-2.68835,1\",\"occlusionType\":1,\"referenceScanId\":\"de5dfda1-4711-11ee-bfe6-a86daa000811\",\"scanBodies\":[{\"position\":\"12.4666,6,0,0,-2.39693,0,6,0,19.2857,0,0,6,1,0,0,0\",\"reference\":\"K30PSCANP\",\"tid\":17}]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 10:58:35.000','2023-08-30 08:59:16.536','2023-08-30 10:59:16.536'),('6a4033f8-4717-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c588c3d6-4716-11ee-bfe6-a86daa000811/order_c58b4ec0-4716-11ee-bfe6-a86daa000811/6a4033f8-4717-11ee-bfe6-a86daa000811.pdf','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c588c3d6-4716-11ee-bfe6-a86daa000811_PROST_c58b4ec0-4716-11ee-bfe6-a86daa000811_FORM','6a4033f8-4717-11ee-bfe6-a86daa000811.pdf','6a4033f8-4717-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Commande 1.1.5.1 Facette\",\"title\":\"Facette\"}','PDF',0,'SYNCED',0,NULL,'2023-08-30 11:27:18.747','2023-08-30 09:27:19.389','2023-08-30 11:27:19.629'),('6dded3e3-4715-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/order_6ddc44d3-4715-11ee-bfe6-a86daa000811/6dded3e3-4715-11ee-bfe6-a86daa000811.pdf','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_PROST_6ddc44d3-4715-11ee-bfe6-a86daa000811_FORM','6dded3e3-4715-11ee-bfe6-a86daa000811.pdf','6dded3e3-4715-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Commande 1.1.2.2 Couronne sur implant\",\"title\":\"Couronne sur implant\"}','PDF',0,'SYNCED',0,NULL,'2023-08-30 11:13:05.827','2023-08-30 09:13:06.439','2023-08-30 11:13:06.502'),('79ca4b91-4711-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/scan_79ca2646-4711-11ee-bfe6-a86daa000811/79ca4b91-4711-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_TOSC_79ca2646-4711-11ee-bfe6-a86daa000811_MODEL','79ca4b91-4711-11ee-bfe6-a86daa000811.zip','79ca4b91-4711-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.2.1.2\",\"modelMatrix\":\"0.189853,0.979669,-0.0648368,0,-0.981813,0.189438,-0.0125375,0,6.71197e-10,0.0660378,0.997817,0,-8.26577,-24.6072,-16.2003,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 10:44:50.000','2023-08-30 08:59:16.557','2023-08-30 10:59:16.557'),('79d2c7d2-4711-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/scan_79ca2646-4711-11ee-bfe6-a86daa000811/79d2c7d2-4711-11ee-bfe6-a86daa000811.png','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_TOSC_79ca2646-4711-11ee-bfe6-a86daa000811_SNAPS','79d2c7d2-4711-11ee-bfe6-a86daa000811.png','79d2c7d2-4711-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.2.1.2 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 10:44:50.000','2023-08-30 08:59:16.561','2023-08-30 10:59:16.561'),('7b984e54-4713-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/order_28bb3c55-4711-11ee-bfe6-a86daa000811/7b984e54-4713-11ee-bfe6-a86daa000811.pdf','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_PROST_28bb3c55-4711-11ee-bfe6-a86daa000811_FORM','7b984e54-4713-11ee-bfe6-a86daa000811.pdf','7b984e54-4713-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Commande 1.1.2.1 Couronne sur implant\",\"title\":\"Couronne sur implant\"}','PDF',0,'SYNCED',0,NULL,'2023-08-30 10:59:11.000','2023-08-30 08:59:16.539','2023-08-30 10:59:16.539'),('840d6721-4711-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/scan_79ca2646-4711-11ee-bfe6-a86daa000811/840d6721-4711-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_TOSC_79ca2646-4711-11ee-bfe6-a86daa000811_MODEL','840d6721-4711-11ee-bfe6-a86daa000811.zip','79ca4b91-4711-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.2.1.2\",\"modelMatrix\":\"0.189853,0.979669,-0.0648368,0,-0.981813,0.189438,-0.0125375,0,6.71197e-10,0.0660378,0.997817,0,-8.26577,-24.6072,-16.2003,1\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2023-08-30 10:45:05.055','2023-08-30 08:45:05.126','2023-08-30 10:46:35.674'),('8c22f707-4712-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/scan_64dba54e-4712-11ee-bfe6-a86daa000811/8c22f707-4712-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_BOSC_64dba54e-4712-11ee-bfe6-a86daa000811_MODEL','8c22f707-4712-11ee-bfe6-a86daa000811.zip','8c22f707-4712-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.2.1.1\",\"modelMatrix\":\"-0.447168,0.886774,-0.116929,0,-0.89445,-0.44333,0.0584568,0,-2.52717e-09,0.130727,0.991418,0,10.811,-18.3152,-17.9512,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 10:52:31.000','2023-08-30 08:59:16.542','2023-08-30 10:59:16.542'),('8c230d37-4712-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/scan_64dba54e-4712-11ee-bfe6-a86daa000811/8c230d37-4712-11ee-bfe6-a86daa000811.png','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_BOSC_64dba54e-4712-11ee-bfe6-a86daa000811_SNAPS','8c230d37-4712-11ee-bfe6-a86daa000811.png','8c230d37-4712-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.2.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 10:52:31.000','2023-08-30 08:59:16.546','2023-08-30 10:59:16.546'),('a0a9b3c6-4714-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/scan_57bf381a-4714-11ee-bfe6-a86daa000811/a0a9b3c6-4714-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_TOSC_57bf381a-4714-11ee-bfe6-a86daa000811_MODEL','a0a9b3c6-4714-11ee-bfe6-a86daa000811.zip','57bf5ba5-4714-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire scanbody 1.1.3.1.3\",\"modelMatrix\":\"0.529357,0.827389,-0.187642,0,-0.848399,0.516247,-0.117079,0,1.105e-08,0.221172,0.975235,0,-8.58468,-18.9914,-14.3956,1\",\"scanBodies\":[{\"position\":\"8.34159,6,0,0,-1.54851,0,6,0,22.2151,0,0,6,1,0,0,0\",\"reference\":\"KECESCANP\",\"tid\":17}]}','ZIP',2,'SYNCED',0,NULL,'2023-08-30 11:07:21.546','2023-08-30 09:07:22.416','2023-08-30 11:07:28.546'),('a0a9dea8-4714-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/scan_57bf381a-4714-11ee-bfe6-a86daa000811/a0a9dea8-4714-11ee-bfe6-a86daa000811.png','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_TOSC_57bf381a-4714-11ee-bfe6-a86daa000811_SNAPS','a0a9dea8-4714-11ee-bfe6-a86daa000811.png','57c53e7b-4714-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire scanbody 1.1.3.1.3 Snapshot\"}','PNG',1,'SYNCED',0,NULL,'2023-08-30 11:07:21.546','2023-08-30 09:07:22.417','2023-08-30 11:07:30.221'),('a39776ef-4714-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/scan_a3974508-4714-11ee-bfe6-a86daa000811/a39776ef-4714-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_BOSC_a3974508-4714-11ee-bfe6-a86daa000811_MODEL','a39776ef-4714-11ee-bfe6-a86daa000811.zip','a39776ef-4714-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.3.1.2\",\"modelMatrix\":\"-0.713152,0.693282,-0.103797,0,-0.701009,-0.705292,0.105595,0,-3.83699e-09,0.148068,0.988977,0,14.4127,-15.8463,-14.6529,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 11:07:26.459','2023-08-30 09:08:29.915','2023-08-30 11:08:32.018'),('a39dcfa8-4714-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/scan_a3974508-4714-11ee-bfe6-a86daa000811/a39dcfa8-4714-11ee-bfe6-a86daa000811.png','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_BOSC_a3974508-4714-11ee-bfe6-a86daa000811_SNAPS','a39dcfa8-4714-11ee-bfe6-a86daa000811.png','a39dcfa8-4714-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.3.1.2 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 11:07:26.501','2023-08-30 09:08:29.919','2023-08-30 11:08:35.499'),('aab3ff42-4714-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/scan_a3974508-4714-11ee-bfe6-a86daa000811/aab3ff42-4714-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_BOSC_a3974508-4714-11ee-bfe6-a86daa000811_MODEL','aab3ff42-4714-11ee-bfe6-a86daa000811.zip','a39776ef-4714-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.3.1.2\",\"modelMatrix\":\"-0.713152,0.693282,-0.103797,0,-0.701009,-0.705292,0.105595,0,-3.83699e-09,0.148068,0.988977,0,14.4127,-15.8463,-14.6529,1\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2023-08-30 11:07:38.390','2023-08-30 09:08:29.916','2023-08-30 11:08:33.162'),('ac976331-4710-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_94108410-4709-11ee-bfe6-a86daa000811/order_94134d72-4709-11ee-bfe6-a86daa000811/ac976331-4710-11ee-bfe6-a86daa000811.pdf','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_94108410-4709-11ee-bfe6-a86daa000811_PROST_94134d72-4709-11ee-bfe6-a86daa000811_FORM','ac976331-4710-11ee-bfe6-a86daa000811.pdf','ac976331-4710-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Commande 1.1.1.1 Couronne\",\"title\":\"Couronne\"}','PDF',0,'SYNCED',0,NULL,'2023-08-30 10:39:05.000','2023-08-30 08:39:12.078','2023-08-30 10:39:12.078'),('ad6eec8c-4716-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_99062442-4716-11ee-bfe6-a86daa000811/order_99088262-4716-11ee-bfe6-a86daa000811/ad6eec8c-4716-11ee-bfe6-a86daa000811.pdf','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_99062442-4716-11ee-bfe6-a86daa000811_PROST_99088262-4716-11ee-bfe6-a86daa000811_FORM','ad6eec8c-4716-11ee-bfe6-a86daa000811.pdf','ad6eec8c-4716-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Commande 1.1.4.1 Couronne\",\"title\":\"Couronne\"}','PDF',0,'SYNCED',0,NULL,'2023-08-30 11:22:03.000','2023-08-30 09:22:04.822','2023-08-30 11:22:04.822'),('b2229610-4712-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/scan_8fb5e92d-4712-11ee-bfe6-a86daa000811/b2229610-4712-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_RISC_8fb5e92d-4712-11ee-bfe6-a86daa000811_MODEL','b2229610-4712-11ee-bfe6-a86daa000811.zip','b2229610-4712-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mordu droit 1.1.2.1.1\",\"modelMatrix\":\"0.999908,0.00309985,-0.0132643,0,-0.00327092,0.999586,-0.0286355,0,0.013144,0.028621,0.999502,0,3.18497,-3.4604,-19.8501,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 10:53:35.000','2023-08-30 08:59:16.550','2023-08-30 10:59:16.550'),('b222b05b-4712-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/scan_8fb5e92d-4712-11ee-bfe6-a86daa000811/b222b05b-4712-11ee-bfe6-a86daa000811.png','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_RISC_8fb5e92d-4712-11ee-bfe6-a86daa000811_SNAPS','b222b05b-4712-11ee-bfe6-a86daa000811.png','b222b05b-4712-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mordu droit 1.1.2.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 10:53:35.000','2023-08-30 08:59:16.553','2023-08-30 10:59:16.553'),('b5ac644f-4712-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/scan_b5ac3d30-4712-11ee-bfe6-a86daa000811/b5ac644f-4712-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_BOSC_b5ac3d30-4712-11ee-bfe6-a86daa000811_MODEL','b5ac644f-4712-11ee-bfe6-a86daa000811.zip','b5ac644f-4712-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.2.1.2\",\"modelMatrix\":\"-0.447168,0.886774,-0.116929,0,-0.89445,-0.44333,0.0584568,0,-2.52717e-09,0.130727,0.991418,0,10.811,-18.3152,-17.9512,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 10:53:39.000','2023-08-30 08:59:16.567','2023-08-30 10:59:16.567'),('b5b3751e-4712-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/scan_b5ac3d30-4712-11ee-bfe6-a86daa000811/b5b3751e-4712-11ee-bfe6-a86daa000811.png','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_BOSC_b5ac3d30-4712-11ee-bfe6-a86daa000811_SNAPS','b5b3751e-4712-11ee-bfe6-a86daa000811.png','b5b3751e-4712-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.2.1.2 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 10:53:39.000','2023-08-30 08:59:16.574','2023-08-30 10:59:16.574'),('b801ed81-4711-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/scan_79ca2646-4711-11ee-bfe6-a86daa000811/b801ed81-4711-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_TOSC_79ca2646-4711-11ee-bfe6-a86daa000811_MODEL','b801ed81-4711-11ee-bfe6-a86daa000811.zip','79ca4b91-4711-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.2.1.2\",\"modelMatrix\":\"0.635277,0.77038,-0.0542015,0,-0.772285,0.63371,-0.0445859,0,-8.20249e-10,0.0701834,0.997534,0,-19.0629,-18.3955,-17.2773,1\",\"scanBodies\":[]}','ZIP',2,'CREATED',0,NULL,'2023-08-30 10:46:32.221','2023-08-30 08:47:32.082','2023-08-30 10:47:32.087'),('b802029b-4711-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/scan_79ca2646-4711-11ee-bfe6-a86daa000811/b802029b-4711-11ee-bfe6-a86daa000811.png','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_TOSC_79ca2646-4711-11ee-bfe6-a86daa000811_SNAPS','b802029b-4711-11ee-bfe6-a86daa000811.png','79d2c7d2-4711-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.2.1.2 Snapshot\"}','PNG',1,'SYNCED',0,NULL,'2023-08-30 10:46:38.000','2023-08-30 08:59:16.564','2023-08-30 10:59:16.564'),('bb514d27-4717-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_a0f72d78-4717-11ee-bfe6-a86daa000811/occlusion_a0f77fda-4717-11ee-bfe6-a86daa000811/scan_a27d60d7-4717-11ee-bfe6-a86daa000811/bb514d27-4717-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_a0f72d78-4717-11ee-bfe6-a86daa000811_SESS_a0f77fda-4717-11ee-bfe6-a86daa000811_TOSC_a27d60d7-4717-11ee-bfe6-a86daa000811_MODEL','bb514d27-4717-11ee-bfe6-a86daa000811.zip','bb514d27-4717-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.6.1.1\",\"modelMatrix\":\"0.975251,0.211526,-0.0643608,0,-0.221101,0.933018,-0.283888,0,1.08095e-10,0.291092,0.956695,0,-15.2467,-6.79388,-15.5769,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 11:32:47.000','2023-08-30 09:33:26.408','2023-08-30 11:33:26.408'),('bb517432-4717-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_a0f72d78-4717-11ee-bfe6-a86daa000811/occlusion_a0f77fda-4717-11ee-bfe6-a86daa000811/scan_a27d60d7-4717-11ee-bfe6-a86daa000811/bb517432-4717-11ee-bfe6-a86daa000811.png','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_a0f72d78-4717-11ee-bfe6-a86daa000811_SESS_a0f77fda-4717-11ee-bfe6-a86daa000811_TOSC_a27d60d7-4717-11ee-bfe6-a86daa000811_SNAPS','bb517432-4717-11ee-bfe6-a86daa000811.png','bb517432-4717-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.6.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 11:32:47.000','2023-08-30 09:33:26.412','2023-08-30 11:33:26.412'),('bfb50ded-4712-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/scan_b5ac3d30-4712-11ee-bfe6-a86daa000811/bfb50ded-4712-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_BOSC_b5ac3d30-4712-11ee-bfe6-a86daa000811_MODEL','bfb50ded-4712-11ee-bfe6-a86daa000811.zip','b5ac644f-4712-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.2.1.2\",\"modelMatrix\":\"-0.447168,0.886774,-0.116929,0,-0.89445,-0.44333,0.0584568,0,-2.52717e-09,0.130727,0.991418,0,10.811,-18.3152,-17.9512,1\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2023-08-30 10:53:54.636','2023-08-30 08:53:54.696','2023-08-30 10:54:59.293'),('c927afc9-4714-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/scan_a3974508-4714-11ee-bfe6-a86daa000811/c927afc9-4714-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_BOSC_a3974508-4714-11ee-bfe6-a86daa000811_MODEL','c927afc9-4714-11ee-bfe6-a86daa000811.zip','a39776ef-4714-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.3.1.2\",\"modelMatrix\":\"-0.641978,0.756998,-0.121732,0,-0.766723,-0.633835,0.101926,0,5.64993e-09,0.158769,0.987316,0,13.0036,-16.9969,-14.3543,1\",\"scanBodies\":[]}','ZIP',2,'SYNCED',0,NULL,'2023-08-30 11:08:29.480','2023-08-30 09:08:29.916','2023-08-30 11:08:34.021'),('c927c536-4714-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/scan_a3974508-4714-11ee-bfe6-a86daa000811/c927c536-4714-11ee-bfe6-a86daa000811.png','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_BOSC_a3974508-4714-11ee-bfe6-a86daa000811_SNAPS','c927c536-4714-11ee-bfe6-a86daa000811.png','a39dcfa8-4714-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.3.1.2 Snapshot\"}','PNG',1,'SYNCED',0,NULL,'2023-08-30 11:08:29.480','2023-08-30 09:08:29.919','2023-08-30 11:08:35.606'),('ccfc6b34-4717-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_a0f72d78-4717-11ee-bfe6-a86daa000811/occlusion_a0f77fda-4717-11ee-bfe6-a86daa000811/scan_a27d60d7-4717-11ee-bfe6-a86daa000811/ccfc6b34-4717-11ee-bfe6-a86daa000811.xyz','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_a0f72d78-4717-11ee-bfe6-a86daa000811_SESS_a0f77fda-4717-11ee-bfe6-a86daa000811_TOSC_a27d60d7-4717-11ee-bfe6-a86daa000811_LIFI','ccfc6b34-4717-11ee-bfe6-a86daa000811.xyz','ccfc6b34-4717-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.6.1.1 Ligne de finition 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 11:30:04.000','2023-08-30 09:33:26.415','2023-08-30 11:33:26.415'),('ccfc70eb-4717-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_a0f72d78-4717-11ee-bfe6-a86daa000811/occlusion_a0f77fda-4717-11ee-bfe6-a86daa000811/scan_a27d60d7-4717-11ee-bfe6-a86daa000811/ccfc70eb-4717-11ee-bfe6-a86daa000811.bin','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_a0f72d78-4717-11ee-bfe6-a86daa000811_SESS_a0f77fda-4717-11ee-bfe6-a86daa000811_TOSC_a27d60d7-4717-11ee-bfe6-a86daa000811_LIFIM','ccfc70eb-4717-11ee-bfe6-a86daa000811.bin','ccfc70eb-4717-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.6.1.1 Ligne de finition métadonnées 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 11:30:04.000','2023-08-30 09:33:26.419','2023-08-30 11:33:26.419'),('d04975f8-4714-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/scan_a3974508-4714-11ee-bfe6-a86daa000811/d04975f8-4714-11ee-bfe6-a86daa000811.xyz','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_BOSC_a3974508-4714-11ee-bfe6-a86daa000811_LIFI','d04975f8-4714-11ee-bfe6-a86daa000811.xyz','d04975f8-4714-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.3.1.2 Ligne de finition 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 11:08:41.445','2023-08-30 09:08:41.450','2023-08-30 11:08:41.457'),('d0497b98-4714-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/scan_a3974508-4714-11ee-bfe6-a86daa000811/d0497b98-4714-11ee-bfe6-a86daa000811.bin','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_BOSC_a3974508-4714-11ee-bfe6-a86daa000811_LIFIM','d0497b98-4714-11ee-bfe6-a86daa000811.bin','d0497b98-4714-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.3.1.2 Ligne de finition métadonnées 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 11:08:41.445','2023-08-30 09:08:41.451','2023-08-30 11:08:41.763'),('d4d5e74d-4714-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/scan_22084bd2-4714-11ee-bfe6-a86daa000811/d4d5e74d-4714-11ee-bfe6-a86daa000811.xyz','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_TOSC_22084bd2-4714-11ee-bfe6-a86daa000811_LIFI','d4d5e74d-4714-11ee-bfe6-a86daa000811.xyz','d4d5e74d-4714-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.3.1.2 Ligne de finition 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 11:08:49.077','2023-08-30 09:08:49.079','2023-08-30 11:08:49.086'),('d4d5eac4-4714-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/scan_22084bd2-4714-11ee-bfe6-a86daa000811/d4d5eac4-4714-11ee-bfe6-a86daa000811.bin','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_TOSC_22084bd2-4714-11ee-bfe6-a86daa000811_LIFIM','d4d5eac4-4714-11ee-bfe6-a86daa000811.bin','d4d5eac4-4714-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.3.1.2 Ligne de finition métadonnées 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 11:08:49.077','2023-08-30 09:08:49.080','2023-08-30 11:08:49.291'),('d5425abd-4709-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_94108410-4709-11ee-bfe6-a86daa000811/occlusion_9411ecbc-4709-11ee-bfe6-a86daa000811/scan_978d31c9-4709-11ee-bfe6-a86daa000811/d5425abd-4709-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_94108410-4709-11ee-bfe6-a86daa000811_SESS_9411ecbc-4709-11ee-bfe6-a86daa000811_TOSC_978d31c9-4709-11ee-bfe6-a86daa000811_MODEL','d5425abd-4709-11ee-bfe6-a86daa000811.zip','d5425abd-4709-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.1.1.1\",\"modelMatrix\":\"-0.0757858,0.972558,-0.21997,0,-0.997124,-0.0739187,0.0167187,0,9.42286e-10,0.220604,0.975363,0,3.34696,-23.8901,-16.2781,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 09:50:11.000','2023-08-30 08:39:12.082','2023-08-30 10:39:12.082'),('d54273bc-4709-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_94108410-4709-11ee-bfe6-a86daa000811/occlusion_9411ecbc-4709-11ee-bfe6-a86daa000811/scan_978d31c9-4709-11ee-bfe6-a86daa000811/d54273bc-4709-11ee-bfe6-a86daa000811.png','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_94108410-4709-11ee-bfe6-a86daa000811_SESS_9411ecbc-4709-11ee-bfe6-a86daa000811_TOSC_978d31c9-4709-11ee-bfe6-a86daa000811_SNAPS','d54273bc-4709-11ee-bfe6-a86daa000811.png','d54273bc-4709-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 09:50:11.000','2023-08-30 08:39:12.085','2023-08-30 10:39:12.085'),('d709695b-4714-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/scan_d709480e-4714-11ee-bfe6-a86daa000811/d709695b-4714-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_BOSC_d709480e-4714-11ee-bfe6-a86daa000811_MODEL','d709695b-4714-11ee-bfe6-a86daa000811.zip','d709695b-4714-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.3.1.3\",\"modelMatrix\":\"-0.641978,0.756998,-0.121732,0,-0.766723,-0.633835,0.101926,0,5.64993e-09,0.158769,0.987316,0,13.0036,-16.9969,-14.3543,1\",\"scanBodies\":[{\"position\":\"10.3631,6,0,0,2.10359,0,6,0,20.0179,0,0,6,1,0,0,0\",\"reference\":\"KECESCANP\",\"tid\":47}]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 11:08:52.770','2023-08-30 09:10:24.447','2023-08-30 11:10:26.553'),('d70f810d-4714-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/scan_d709480e-4714-11ee-bfe6-a86daa000811/d70f810d-4714-11ee-bfe6-a86daa000811.png','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_BOSC_d709480e-4714-11ee-bfe6-a86daa000811_SNAPS','d70f810d-4714-11ee-bfe6-a86daa000811.png','d70f810d-4714-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.3.1.3 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 11:08:52.810','2023-08-30 09:10:24.449','2023-08-30 11:11:16.569'),('dbed38ba-4709-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_94108410-4709-11ee-bfe6-a86daa000811/occlusion_9411ecbc-4709-11ee-bfe6-a86daa000811/scan_978d31c9-4709-11ee-bfe6-a86daa000811/dbed38ba-4709-11ee-bfe6-a86daa000811.xyz','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_94108410-4709-11ee-bfe6-a86daa000811_SESS_9411ecbc-4709-11ee-bfe6-a86daa000811_TOSC_978d31c9-4709-11ee-bfe6-a86daa000811_LIFI','dbed38ba-4709-11ee-bfe6-a86daa000811.xyz','dbed38ba-4709-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.1.1.1 Ligne de finition 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 09:50:16.509','2023-08-30 07:50:16.513','2023-08-30 09:50:16.520'),('dbed3f00-4709-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_94108410-4709-11ee-bfe6-a86daa000811/occlusion_9411ecbc-4709-11ee-bfe6-a86daa000811/scan_978d31c9-4709-11ee-bfe6-a86daa000811/dbed3f00-4709-11ee-bfe6-a86daa000811.bin','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_94108410-4709-11ee-bfe6-a86daa000811_SESS_9411ecbc-4709-11ee-bfe6-a86daa000811_TOSC_978d31c9-4709-11ee-bfe6-a86daa000811_LIFIM','dbed3f00-4709-11ee-bfe6-a86daa000811.bin','dbed3f00-4709-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.1.1.1 Ligne de finition métadonnées 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 09:50:16.510','2023-08-30 07:50:16.514','2023-08-30 09:50:16.678'),('de5e212b-4711-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/scan_de5dfda1-4711-11ee-bfe6-a86daa000811/de5e212b-4711-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_TOSC_de5dfda1-4711-11ee-bfe6-a86daa000811_MODEL','de5e212b-4711-11ee-bfe6-a86daa000811.zip','de5e212b-4711-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.2.1.3\",\"modelMatrix\":\"0.635277,0.77038,-0.0542015,0,-0.772285,0.63371,-0.0445859,0,-8.20249e-10,0.0701834,0.997534,0,-19.0629,-18.3955,-17.2773,1\",\"scanBodies\":[{\"position\":\"12.4666,6,0,0,-2.39693,0,6,0,19.2857,0,0,6,1,0,0,0\",\"reference\":\"K30PSCANP\",\"tid\":17}]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 10:47:36.000','2023-08-30 08:59:16.482','2023-08-30 10:59:16.482'),('de663fe2-4711-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/scan_de5dfda1-4711-11ee-bfe6-a86daa000811/de663fe2-4711-11ee-bfe6-a86daa000811.png','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_TOSC_de5dfda1-4711-11ee-bfe6-a86daa000811_SNAPS','de663fe2-4711-11ee-bfe6-a86daa000811.png','de663fe2-4711-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.2.1.3 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 10:47:39.000','2023-08-30 08:59:16.489','2023-08-30 10:59:16.489'),('dfb550cc-4714-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/scan_d709480e-4714-11ee-bfe6-a86daa000811/dfb550cc-4714-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_BOSC_d709480e-4714-11ee-bfe6-a86daa000811_MODEL','dfb550cc-4714-11ee-bfe6-a86daa000811.zip','d709695b-4714-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule scanbody 1.1.3.1.3\",\"modelMatrix\":\"-0.641978,0.756998,-0.121732,0,-0.766723,-0.633835,0.101926,0,5.64993e-09,0.158769,0.987316,0,13.0036,-16.9969,-14.3543,1\",\"scanBodies\":[{\"position\":\"10.3631,6,0,0,2.10359,0,6,0,20.0179,0,0,6,1,0,0,0\",\"reference\":\"KECESCANP\",\"tid\":47}]}','ZIP',1,'SYNCED',0,NULL,'2023-08-30 11:09:07.318','2023-08-30 09:10:24.448','2023-08-30 11:10:27.288'),('e45fa630-4712-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/scan_b5ac3d30-4712-11ee-bfe6-a86daa000811/e45fa630-4712-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_BOSC_b5ac3d30-4712-11ee-bfe6-a86daa000811_MODEL','e45fa630-4712-11ee-bfe6-a86daa000811.zip','b5ac644f-4712-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.2.1.2\",\"modelMatrix\":\"-0.409402,0.900441,-0.146959,0,-0.912354,-0.404056,0.0659451,0,6.03451e-09,0.161077,0.986942,0,10.1898,-19.9483,-17.5344,1\",\"scanBodies\":[]}','ZIP',2,'SYNCED',0,NULL,'2023-08-30 10:55:02.000','2023-08-30 08:59:16.571','2023-08-30 10:59:16.571'),('e45fbb59-4712-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/scan_b5ac3d30-4712-11ee-bfe6-a86daa000811/e45fbb59-4712-11ee-bfe6-a86daa000811.png','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_BOSC_b5ac3d30-4712-11ee-bfe6-a86daa000811_SNAPS','e45fbb59-4712-11ee-bfe6-a86daa000811.png','b5b3751e-4712-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.2.1.2 Snapshot\"}','PNG',1,'SYNCED',0,NULL,'2023-08-30 10:55:02.000','2023-08-30 08:59:16.577','2023-08-30 10:59:16.577'),('e73e82b6-4711-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/scan_de5dfda1-4711-11ee-bfe6-a86daa000811/e73e82b6-4711-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_TOSC_de5dfda1-4711-11ee-bfe6-a86daa000811_MODEL','e73e82b6-4711-11ee-bfe6-a86daa000811.zip','de5e212b-4711-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire scanbody 1.1.2.1.3\",\"modelMatrix\":\"0.635277,0.77038,-0.0542015,0,-0.772285,0.63371,-0.0445859,0,-8.20249e-10,0.0701834,0.997534,0,-19.0629,-18.3955,-17.2773,1\",\"scanBodies\":[{\"position\":\"12.4666,6,0,0,-2.39693,0,6,0,19.2857,0,0,6,1,0,0,0\",\"reference\":\"K30PSCANP\",\"tid\":17}]}','ZIP',1,'SYNCED',0,NULL,'2023-08-30 10:47:51.471','2023-08-30 08:47:51.541','2023-08-30 10:50:58.262'),('ebcaf2e8-4712-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/scan_64dba54e-4712-11ee-bfe6-a86daa000811/ebcaf2e8-4712-11ee-bfe6-a86daa000811.xyz','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_BOSC_64dba54e-4712-11ee-bfe6-a86daa000811_LIFI','ebcaf2e8-4712-11ee-bfe6-a86daa000811.xyz','ebcaf2e8-4712-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.2.1.1 Ligne de finition 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 10:55:08.599','2023-08-30 08:55:08.604','2023-08-30 10:55:08.611'),('ebcaf8ff-4712-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/scan_64dba54e-4712-11ee-bfe6-a86daa000811/ebcaf8ff-4712-11ee-bfe6-a86daa000811.bin','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_BOSC_64dba54e-4712-11ee-bfe6-a86daa000811_LIFIM','ebcaf8ff-4712-11ee-bfe6-a86daa000811.bin','ebcaf8ff-4712-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.2.1.1 Ligne de finition métadonnées 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 10:55:08.599','2023-08-30 08:55:08.604','2023-08-30 10:55:08.827'),('ef5efa77-4713-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/scan_c98c9fb7-4713-11ee-bfe6-a86daa000811/ef5efa77-4713-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_TOSC_c98c9fb7-4713-11ee-bfe6-a86daa000811_MODEL','ef5efa77-4713-11ee-bfe6-a86daa000811.zip','ef5efa77-4713-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire pre-scan 1.1.3.1.1\",\"modelMatrix\":\"0.647083,0.74661,-0.154459,0,-0.76242,0.633664,-0.131092,0,-4.69452e-10,0.20259,0.979264,0,-11.1795,-17.6012,-14.4686,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 11:02:24.099','2023-08-30 09:02:24.446','2023-08-30 11:02:26.110'),('ef5f1152-4713-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c7a7cd85-4713-11ee-bfe6-a86daa000811/occlusion_c7a8830f-4713-11ee-bfe6-a86daa000811/scan_c98c9fb7-4713-11ee-bfe6-a86daa000811/ef5f1152-4713-11ee-bfe6-a86daa000811.png','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c7a7cd85-4713-11ee-bfe6-a86daa000811_SESS_c7a8830f-4713-11ee-bfe6-a86daa000811_TOSC_c98c9fb7-4713-11ee-bfe6-a86daa000811_SNAPS','ef5f1152-4713-11ee-bfe6-a86daa000811.png','ef5f1152-4713-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire pre-scan 1.1.3.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 11:02:24.100','2023-08-30 09:02:24.446','2023-08-30 11:02:27.516'),('ef71f4e5-4712-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/scan_b5ac3d30-4712-11ee-bfe6-a86daa000811/ef71f4e5-4712-11ee-bfe6-a86daa000811.xyz','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_BOSC_b5ac3d30-4712-11ee-bfe6-a86daa000811_LIFI','ef71f4e5-4712-11ee-bfe6-a86daa000811.xyz','ef71f4e5-4712-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.2.1.2 Ligne de finition 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 10:55:15.000','2023-08-30 08:59:16.582','2023-08-30 10:59:16.582'),('ef71f80d-4712-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/scan_b5ac3d30-4712-11ee-bfe6-a86daa000811/ef71f80d-4712-11ee-bfe6-a86daa000811.bin','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_BOSC_b5ac3d30-4712-11ee-bfe6-a86daa000811_LIFIM','ef71f80d-4712-11ee-bfe6-a86daa000811.bin','ef71f80d-4712-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.2.1.2 Ligne de finition métadonnées 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 10:55:15.000','2023-08-30 08:59:16.586','2023-08-30 10:59:16.586'),('f12116be-4716-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c588c3d6-4716-11ee-bfe6-a86daa000811/occlusion_c589e5b6-4716-11ee-bfe6-a86daa000811/scan_c9e996cb-4716-11ee-bfe6-a86daa000811/f12116be-4716-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c588c3d6-4716-11ee-bfe6-a86daa000811_SESS_c589e5b6-4716-11ee-bfe6-a86daa000811_TOSC_c9e996cb-4716-11ee-bfe6-a86daa000811_MODEL','f12116be-4716-11ee-bfe6-a86daa000811.zip','f12116be-4716-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.5.1.1\",\"modelMatrix\":\"0.917947,0.390606,-0.069279,0,-0.396702,0.903841,-0.160308,0,2.55916e-09,0.174637,0.984633,0,-17.3382,-7.21651,-17.8042,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 11:23:58.000','2023-08-30 09:27:21.865','2023-08-30 11:27:21.865'),('f1212eaf-4716-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c588c3d6-4716-11ee-bfe6-a86daa000811/occlusion_c589e5b6-4716-11ee-bfe6-a86daa000811/scan_c9e996cb-4716-11ee-bfe6-a86daa000811/f1212eaf-4716-11ee-bfe6-a86daa000811.png','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c588c3d6-4716-11ee-bfe6-a86daa000811_SESS_c589e5b6-4716-11ee-bfe6-a86daa000811_TOSC_c9e996cb-4716-11ee-bfe6-a86daa000811_SNAPS','f1212eaf-4716-11ee-bfe6-a86daa000811.png','f1212eaf-4716-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.5.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 11:23:58.000','2023-08-30 09:27:21.870','2023-08-30 11:27:21.870'),('f147aef1-4717-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_a0f72d78-4717-11ee-bfe6-a86daa000811/occlusion_a0f77fda-4717-11ee-bfe6-a86daa000811/scan_cf8c0f8e-4717-11ee-bfe6-a86daa000811/f147aef1-4717-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_a0f72d78-4717-11ee-bfe6-a86daa000811_SESS_a0f77fda-4717-11ee-bfe6-a86daa000811_BOSC_cf8c0f8e-4717-11ee-bfe6-a86daa000811_MODEL','f147aef1-4717-11ee-bfe6-a86daa000811.zip','f147aef1-4717-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.6.1.1\",\"modelMatrix\":\"0.0327161,0.998269,-0.0488692,0,-0.999465,0.032677,-0.00159967,0,1.04619e-10,0.0488954,0.998804,0,3.50834,-16.1792,-19.0378,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 11:32:49.000','2023-08-30 09:33:26.423','2023-08-30 11:33:26.423'),('f147c789-4717-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_a0f72d78-4717-11ee-bfe6-a86daa000811/occlusion_a0f77fda-4717-11ee-bfe6-a86daa000811/scan_cf8c0f8e-4717-11ee-bfe6-a86daa000811/f147c789-4717-11ee-bfe6-a86daa000811.png','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_a0f72d78-4717-11ee-bfe6-a86daa000811_SESS_a0f77fda-4717-11ee-bfe6-a86daa000811_BOSC_cf8c0f8e-4717-11ee-bfe6-a86daa000811_SNAPS','f147c789-4717-11ee-bfe6-a86daa000811.png','f147c789-4717-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.6.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 11:32:49.000','2023-08-30 09:33:26.427','2023-08-30 11:33:26.427'),('f4879c4b-4712-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/scan_f4877908-4712-11ee-bfe6-a86daa000811/f4879c4b-4712-11ee-bfe6-a86daa000811.zip','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_BOSC_f4877908-4712-11ee-bfe6-a86daa000811_MODEL','f4879c4b-4712-11ee-bfe6-a86daa000811.zip','f4879c4b-4712-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.2.1.3\",\"modelMatrix\":\"-0.409402,0.900441,-0.146959,0,-0.912354,-0.404056,0.0659451,0,6.03451e-09,0.161077,0.986942,0,10.1898,-19.9483,-17.5344,1\",\"scanBodies\":[{\"position\":\"9.76708,6,0,0,2.78072,0,6,0,21.3364,0,0,6,1,0,0,0\",\"reference\":\"KECESCANP\",\"tid\":47}]}','ZIP',0,'SYNCED',0,NULL,'2023-08-30 10:55:23.257','2023-08-30 08:55:52.388','2023-08-30 10:55:52.393'),('f48e421b-4712-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/scan_f4877908-4712-11ee-bfe6-a86daa000811/f48e421b-4712-11ee-bfe6-a86daa000811.png','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_BOSC_f4877908-4712-11ee-bfe6-a86daa000811_SNAPS','f48e421b-4712-11ee-bfe6-a86daa000811.png','f48e421b-4712-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.2.1.3 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-08-30 10:55:25.000','2023-08-30 08:59:16.454','2023-08-30 10:59:16.454'),('f48e5405-4712-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/scan_f4877908-4712-11ee-bfe6-a86daa000811/f48e5405-4712-11ee-bfe6-a86daa000811.xyz','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_BOSC_f4877908-4712-11ee-bfe6-a86daa000811_LIFI','f48e5405-4712-11ee-bfe6-a86daa000811.xyz','f48e5405-4712-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.2.1.3 Ligne de finition 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,'2023-08-30 10:55:56.866','2023-08-30 10:55:23.301','2023-08-30 08:55:56.866','2023-08-30 10:57:30.172'),('f48e616a-4712-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_28b852b9-4711-11ee-bfe6-a86daa000811/occlusion_28b9b3ca-4711-11ee-bfe6-a86daa000811/scan_f4877908-4712-11ee-bfe6-a86daa000811/f48e616a-4712-11ee-bfe6-a86daa000811.bin','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_28b852b9-4711-11ee-bfe6-a86daa000811_SESS_28b9b3ca-4711-11ee-bfe6-a86daa000811_BOSC_f4877908-4712-11ee-bfe6-a86daa000811_LIFIM','f48e616a-4712-11ee-bfe6-a86daa000811.bin','f48e616a-4712-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.2.1.3 Ligne de finition métadonnées 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,'2023-08-30 10:55:56.866','2023-08-30 10:55:23.301','2023-08-30 08:55:56.867','2023-08-30 10:57:30.172'),('f4fad758-4717-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_a0f72d78-4717-11ee-bfe6-a86daa000811/occlusion_a0f77fda-4717-11ee-bfe6-a86daa000811/scan_cf8c0f8e-4717-11ee-bfe6-a86daa000811/f4fad758-4717-11ee-bfe6-a86daa000811.xyz','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_a0f72d78-4717-11ee-bfe6-a86daa000811_SESS_a0f77fda-4717-11ee-bfe6-a86daa000811_BOSC_cf8c0f8e-4717-11ee-bfe6-a86daa000811_LIFI','f4fad758-4717-11ee-bfe6-a86daa000811.xyz','f4fad758-4717-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.6.1.1 Ligne de finition 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 11:31:11.000','2023-08-30 09:33:26.430','2023-08-30 11:33:26.430'),('f4fadf46-4717-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_a0f72d78-4717-11ee-bfe6-a86daa000811/occlusion_a0f77fda-4717-11ee-bfe6-a86daa000811/scan_cf8c0f8e-4717-11ee-bfe6-a86daa000811/f4fadf46-4717-11ee-bfe6-a86daa000811.bin','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_a0f72d78-4717-11ee-bfe6-a86daa000811_SESS_a0f77fda-4717-11ee-bfe6-a86daa000811_BOSC_cf8c0f8e-4717-11ee-bfe6-a86daa000811_LIFIM','f4fadf46-4717-11ee-bfe6-a86daa000811.bin','f4fadf46-4717-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.6.1.1 Ligne de finition métadonnées 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 11:31:11.000','2023-08-30 09:33:26.434','2023-08-30 11:33:26.434'),('fa4a5d2b-4716-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c588c3d6-4716-11ee-bfe6-a86daa000811/occlusion_c589e5b6-4716-11ee-bfe6-a86daa000811/scan_c9e996cb-4716-11ee-bfe6-a86daa000811/fa4a5d2b-4716-11ee-bfe6-a86daa000811.xyz','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c588c3d6-4716-11ee-bfe6-a86daa000811_SESS_c589e5b6-4716-11ee-bfe6-a86daa000811_TOSC_c9e996cb-4716-11ee-bfe6-a86daa000811_LIFI','fa4a5d2b-4716-11ee-bfe6-a86daa000811.xyz','fa4a5d2b-4716-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.5.1.1 Ligne de finition 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 11:24:11.000','2023-08-30 09:27:21.876','2023-08-30 11:27:21.876'),('fa4a653e-4716-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_c588c3d6-4716-11ee-bfe6-a86daa000811/occlusion_c589e5b6-4716-11ee-bfe6-a86daa000811/scan_c9e996cb-4716-11ee-bfe6-a86daa000811/fa4a653e-4716-11ee-bfe6-a86daa000811.bin','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_c588c3d6-4716-11ee-bfe6-a86daa000811_SESS_c589e5b6-4716-11ee-bfe6-a86daa000811_TOSC_c9e996cb-4716-11ee-bfe6-a86daa000811_LIFIM','fa4a653e-4716-11ee-bfe6-a86daa000811.bin','fa4a653e-4716-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Maxillaire 1.1.5.1.1 Ligne de finition métadonnées 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 11:24:11.000','2023-08-30 09:27:21.882','2023-08-30 11:27:21.882'),('fd53a313-4717-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_a0f72d78-4717-11ee-bfe6-a86daa000811/occlusion_a0f77fda-4717-11ee-bfe6-a86daa000811/scan_cf8c0f8e-4717-11ee-bfe6-a86daa000811/fd53a313-4717-11ee-bfe6-a86daa000811.xyz','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_a0f72d78-4717-11ee-bfe6-a86daa000811_SESS_a0f77fda-4717-11ee-bfe6-a86daa000811_BOSC_cf8c0f8e-4717-11ee-bfe6-a86daa000811_LIFI','fd53a313-4717-11ee-bfe6-a86daa000811.xyz','fd53a313-4717-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.6.1.1 Ligne de finition 1\",\"title\":\"1\",\"toothNumber\":1,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2023-08-30 11:31:25.000','2023-08-30 09:33:26.444','2023-08-30 11:33:26.444'),('fd53aa08-4717-11ee-bfe6-a86daa000811',196,'/var/.data/2023/196/7ce01fa7-4709-11ee-bfe6-a86daa000811/session_a0f72d78-4717-11ee-bfe6-a86daa000811/occlusion_a0f77fda-4717-11ee-bfe6-a86daa000811/scan_cf8c0f8e-4717-11ee-bfe6-a86daa000811/fd53aa08-4717-11ee-bfe6-a86daa000811.bin','PATIENT_7ce01fa7-4709-11ee-bfe6-a86daa000811_ACT_a0f72d78-4717-11ee-bfe6-a86daa000811_SESS_a0f77fda-4717-11ee-bfe6-a86daa000811_BOSC_cf8c0f8e-4717-11ee-bfe6-a86daa000811_LIFIM','fd53aa08-4717-11ee-bfe6-a86daa000811.bin','fd53aa08-4717-11ee-bfe6-a86daa000811','{\"displayTitle\":\"Mandibule 1.1.6.1.1 Ligne de finition métadonnées 1\",\"title\":\"1\",\"toothNumber\":1,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2023-08-30 11:31:25.000','2023-08-30 09:33:26.447','2023-08-30 11:33:26.447');
/*!40000 ALTER TABLE `File` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `MessageStatus`
--

DROP TABLE IF EXISTS `MessageStatus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `MessageStatus` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `sentMessageId` varchar(36) NOT NULL,
  `contactId` varchar(36) NOT NULL,
  `status` enum('UNDELIVERED','DELIVERED','TRANSMITTED') NOT NULL DEFAULT 'UNDELIVERED',
  `bcc` tinyint(1) NOT NULL DEFAULT '0',
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  PRIMARY KEY (`sentMessageId`,`contactId`),
  KEY `ownerId` (`ownerId`),
  KEY `contactId` (`contactId`),
  CONSTRAINT `MessageStatus_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `MessageStatus_ibfk_2` FOREIGN KEY (`sentMessageId`) REFERENCES `SentMessage` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `MessageStatus_ibfk_3` FOREIGN KEY (`contactId`) REFERENCES `Contact` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `MessageStatus`
--

LOCK TABLES `MessageStatus` WRITE;
/*!40000 ALTER TABLE `MessageStatus` DISABLE KEYS */;
INSERT INTO `MessageStatus` VALUES (196,'434f208f-4718-11ee-bfe6-a86daa000811','6d038bac-e819-45db-8313-aba6d0d4ec3a','DELIVERED',0,'2023-08-30 09:33:27.340'),(196,'5fdfa238-4715-11ee-bfe6-a86daa000811','6d038bac-e819-45db-8313-aba6d0d4ec3a','TRANSMITTED',0,'2023-08-30 09:26:08.187'),(196,'6aa60301-4717-11ee-bfe6-a86daa000811','6d038bac-e819-45db-8313-aba6d0d4ec3a','TRANSMITTED',0,'2023-08-30 09:27:26.214'),(196,'6e429d26-4715-11ee-bfe6-a86daa000811','6d038bac-e819-45db-8313-aba6d0d4ec3a','TRANSMITTED',0,'2023-08-30 09:26:08.245'),(196,'7bfe5eb6-4713-11ee-bfe6-a86daa000811','6d038bac-e819-45db-8313-aba6d0d4ec3a','DELIVERED',0,'2023-08-30 08:59:16.667'),(196,'ad0189dd-4710-11ee-bfe6-a86daa000811','6d038bac-e819-45db-8313-aba6d0d4ec3a','TRANSMITTED',0,'2023-08-30 08:39:20.175'),(196,'addcbbc3-4716-11ee-bfe6-a86daa000811','6d038bac-e819-45db-8313-aba6d0d4ec3a','TRANSMITTED',0,'2023-08-30 09:26:08.273'),(196,'ce6d37ad-4710-11ee-bfe6-a86daa000811','6d038bac-e819-45db-8313-aba6d0d4ec3a','TRANSMITTED',0,'2023-08-30 08:40:02.029'),(196,'e9af6a2f-470c-11ee-bfe6-a86daa000811','6d038bac-e819-45db-8313-aba6d0d4ec3a','TRANSMITTED',0,'2023-08-30 08:12:16.996'),(196,'fc343a40-4710-11ee-bfe6-a86daa000811','6d038bac-e819-45db-8313-aba6d0d4ec3a','TRANSMITTED',0,'2023-08-30 08:41:24.348');
/*!40000 ALTER TABLE `MessageStatus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Occlusion`
--

DROP TABLE IF EXISTS `Occlusion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Occlusion` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `sessionId` varchar(36) DEFAULT NULL,
  `occlusionType` enum('UNKNOWN','HEMI_ARCADE_POSTERIEUR_DROIT','HEMI_ARCADE_POSTERIEUR_GAUCHE','HEMI_ARCADE_ANTERIEUR','ARCADE_COMPLETE_ANTERIEUR','ARCADE_COMPLETE') DEFAULT 'UNKNOWN',
  `displayId` mediumint unsigned DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `comments` text,
  `topScanId` varchar(36) DEFAULT NULL,
  `bottomScanId` varchar(36) DEFAULT NULL,
  `anteriorBiteScanId` varchar(36) DEFAULT NULL,
  `rightBiteScanId` varchar(36) DEFAULT NULL,
  `leftBiteScanId` varchar(36) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `sessionId` (`sessionId`),
  KEY `topScanId` (`topScanId`),
  KEY `bottomScanId` (`bottomScanId`),
  KEY `anteriorBiteScanId` (`anteriorBiteScanId`),
  KEY `rightBiteScanId` (`rightBiteScanId`),
  KEY `leftBiteScanId` (`leftBiteScanId`),
  CONSTRAINT `Occlusion_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_2` FOREIGN KEY (`sessionId`) REFERENCES `Session` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_3` FOREIGN KEY (`topScanId`) REFERENCES `Scan` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_4` FOREIGN KEY (`bottomScanId`) REFERENCES `Scan` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_5` FOREIGN KEY (`anteriorBiteScanId`) REFERENCES `Scan` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_6` FOREIGN KEY (`rightBiteScanId`) REFERENCES `Scan` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_7` FOREIGN KEY (`leftBiteScanId`) REFERENCES `Scan` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Occlusion`
--

LOCK TABLES `Occlusion` WRITE;
/*!40000 ALTER TABLE `Occlusion` DISABLE KEYS */;
INSERT INTO `Occlusion` VALUES ('1db40f03-4718-11ee-bfe6-a86daa000811',196,'a0f77fda-4717-11ee-bfe6-a86daa000811','HEMI_ARCADE_POSTERIEUR_GAUCHE',1,0,'','a27d60d7-4717-11ee-bfe6-a86daa000811','cf8c0f8e-4717-11ee-bfe6-a86daa000811',NULL,NULL,'038d534c-4718-11ee-bfe6-a86daa000811','2023-08-30 11:32:19.819',NULL,'2023-08-30 11:32:40.554','2023-08-30 09:32:40.554','2023-08-30 11:32:40.563'),('370bbb23-4715-11ee-bfe6-a86daa000811',196,'c7a8830f-4713-11ee-bfe6-a86daa000811','HEMI_ARCADE_POSTERIEUR_DROIT',1,0,'','c98c9fb7-4713-11ee-bfe6-a86daa000811','f5703840-4713-11ee-bfe6-a86daa000811',NULL,'10ba483c-4715-11ee-bfe6-a86daa000811',NULL,'2023-08-30 11:11:33.846',NULL,'2023-08-30 11:12:23.847','2023-08-30 09:12:23.847','2023-08-30 11:12:23.855'),('4b839b32-4717-11ee-bfe6-a86daa000811',196,'c589e5b6-4716-11ee-bfe6-a86daa000811','HEMI_ARCADE_POSTERIEUR_GAUCHE',1,0,'','c9e996cb-4716-11ee-bfe6-a86daa000811','fcb9257d-4716-11ee-bfe6-a86daa000811',NULL,NULL,'19ab91b2-4717-11ee-bfe6-a86daa000811','2023-08-30 11:26:27.180',NULL,'2023-08-30 11:26:34.439','2023-08-30 09:26:34.439','2023-08-30 11:26:34.445'),('4b957ea0-4713-11ee-bfe6-a86daa000811',196,'28b9b3ca-4711-11ee-bfe6-a86daa000811','HEMI_ARCADE_POSTERIEUR_DROIT',1,0,'','29fbd842-4711-11ee-bfe6-a86daa000811','64dba54e-4712-11ee-bfe6-a86daa000811',NULL,'8fb5e92d-4712-11ee-bfe6-a86daa000811',NULL,'2023-08-30 10:57:49.310',NULL,'2023-08-30 10:58:32.758','2023-08-30 08:58:32.759','2023-08-30 10:58:32.767'),('4bddb249-470a-11ee-bfe6-a86daa000811',196,'9411ecbc-4709-11ee-bfe6-a86daa000811','HEMI_ARCADE_POSTERIEUR_DROIT',1,0,'','978d31c9-4709-11ee-bfe6-a86daa000811','ddb8b416-4709-11ee-bfe6-a86daa000811',NULL,'29e45423-470a-11ee-bfe6-a86daa000811',NULL,'2023-08-30 09:53:24.313',NULL,'2023-08-30 09:53:31.188','2023-08-30 07:53:31.188','2023-08-30 09:53:31.196');
/*!40000 ALTER TABLE `Occlusion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `OcclusionFile`
--

DROP TABLE IF EXISTS `OcclusionFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `OcclusionFile` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `occlusionId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('RESULT','MANDIBLE','MAXILLARY','MANDIBLE_SB','MAXILLARY_SB','MANDIBLE_PRE','MAXILLARY_PRE','LIFI','LIFIMETA','SNAPSHOT','SCREENSHOT') DEFAULT 'RESULT',
  PRIMARY KEY (`occlusionId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `OcclusionFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `OcclusionFile_ibfk_2` FOREIGN KEY (`occlusionId`) REFERENCES `Occlusion` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `OcclusionFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `OcclusionFile`
--

LOCK TABLES `OcclusionFile` WRITE;
/*!40000 ALTER TABLE `OcclusionFile` DISABLE KEYS */;
INSERT INTO `OcclusionFile` VALUES (196,'1db40f03-4718-11ee-bfe6-a86daa000811','1fdc68df-4718-11ee-bfe6-a86daa000811','MAXILLARY'),(196,'1db40f03-4718-11ee-bfe6-a86daa000811','1ff793b5-4718-11ee-bfe6-a86daa000811','LIFI'),(196,'1db40f03-4718-11ee-bfe6-a86daa000811','1ff79a2c-4718-11ee-bfe6-a86daa000811','LIFIMETA'),(196,'1db40f03-4718-11ee-bfe6-a86daa000811','1ff7ece3-4718-11ee-bfe6-a86daa000811','LIFI'),(196,'1db40f03-4718-11ee-bfe6-a86daa000811','1ff7f30d-4718-11ee-bfe6-a86daa000811','LIFIMETA'),(196,'1db40f03-4718-11ee-bfe6-a86daa000811','1ff833ca-4718-11ee-bfe6-a86daa000811','MANDIBLE'),(196,'1db40f03-4718-11ee-bfe6-a86daa000811','2013924f-4718-11ee-bfe6-a86daa000811','LIFI'),(196,'1db40f03-4718-11ee-bfe6-a86daa000811','201398ef-4718-11ee-bfe6-a86daa000811','LIFIMETA'),(196,'1db40f03-4718-11ee-bfe6-a86daa000811','2013d4ed-4718-11ee-bfe6-a86daa000811','LIFI'),(196,'1db40f03-4718-11ee-bfe6-a86daa000811','2013d727-4718-11ee-bfe6-a86daa000811','LIFIMETA'),(196,'1db40f03-4718-11ee-bfe6-a86daa000811','20507804-4718-11ee-bfe6-a86daa000811','SNAPSHOT'),(196,'370bbb23-4715-11ee-bfe6-a86daa000811','39ab1d77-4715-11ee-bfe6-a86daa000811','MAXILLARY_PRE'),(196,'370bbb23-4715-11ee-bfe6-a86daa000811','39c6835e-4715-11ee-bfe6-a86daa000811','LIFI'),(196,'370bbb23-4715-11ee-bfe6-a86daa000811','39c689b6-4715-11ee-bfe6-a86daa000811','LIFIMETA'),(196,'370bbb23-4715-11ee-bfe6-a86daa000811','39c6e5de-4715-11ee-bfe6-a86daa000811','MANDIBLE_PRE'),(196,'370bbb23-4715-11ee-bfe6-a86daa000811','3a16950d-4715-11ee-bfe6-a86daa000811','MAXILLARY'),(196,'370bbb23-4715-11ee-bfe6-a86daa000811','3a30cc69-4715-11ee-bfe6-a86daa000811','LIFI'),(196,'370bbb23-4715-11ee-bfe6-a86daa000811','3a30d21c-4715-11ee-bfe6-a86daa000811','LIFIMETA'),(196,'370bbb23-4715-11ee-bfe6-a86daa000811','3a5d4663-4715-11ee-bfe6-a86daa000811','MANDIBLE'),(196,'370bbb23-4715-11ee-bfe6-a86daa000811','3a753395-4715-11ee-bfe6-a86daa000811','LIFI'),(196,'370bbb23-4715-11ee-bfe6-a86daa000811','3a75389e-4715-11ee-bfe6-a86daa000811','LIFIMETA'),(196,'370bbb23-4715-11ee-bfe6-a86daa000811','3aab0524-4715-11ee-bfe6-a86daa000811','MAXILLARY_SB'),(196,'370bbb23-4715-11ee-bfe6-a86daa000811','3ae88db9-4715-11ee-bfe6-a86daa000811','MANDIBLE_SB'),(196,'370bbb23-4715-11ee-bfe6-a86daa000811','3ba46ed3-4715-11ee-bfe6-a86daa000811','SNAPSHOT'),(196,'370bbb23-4715-11ee-bfe6-a86daa000811','54d9092d-4715-11ee-bfe6-a86daa000811','LIFI'),(196,'370bbb23-4715-11ee-bfe6-a86daa000811','54d90bb3-4715-11ee-bfe6-a86daa000811','LIFIMETA'),(196,'4b839b32-4717-11ee-bfe6-a86daa000811','4f674de1-4717-11ee-bfe6-a86daa000811','MAXILLARY'),(196,'4b839b32-4717-11ee-bfe6-a86daa000811','4f826c6b-4717-11ee-bfe6-a86daa000811','LIFI'),(196,'4b839b32-4717-11ee-bfe6-a86daa000811','4f8270ca-4717-11ee-bfe6-a86daa000811','LIFIMETA'),(196,'4b839b32-4717-11ee-bfe6-a86daa000811','4f82ccb6-4717-11ee-bfe6-a86daa000811','MANDIBLE'),(196,'4b839b32-4717-11ee-bfe6-a86daa000811','4fd6f395-4717-11ee-bfe6-a86daa000811','SNAPSHOT'),(196,'4b957ea0-4713-11ee-bfe6-a86daa000811','4f2156ce-4713-11ee-bfe6-a86daa000811','MAXILLARY_PRE'),(196,'4b957ea0-4713-11ee-bfe6-a86daa000811','4f4b7bb9-4713-11ee-bfe6-a86daa000811','LIFI'),(196,'4b957ea0-4713-11ee-bfe6-a86daa000811','4f4b8104-4713-11ee-bfe6-a86daa000811','LIFIMETA'),(196,'4b957ea0-4713-11ee-bfe6-a86daa000811','4f4bfc45-4713-11ee-bfe6-a86daa000811','MANDIBLE_PRE'),(196,'4b957ea0-4713-11ee-bfe6-a86daa000811','4f6bdc64-4713-11ee-bfe6-a86daa000811','LIFI'),(196,'4b957ea0-4713-11ee-bfe6-a86daa000811','4f6bdff0-4713-11ee-bfe6-a86daa000811','LIFIMETA'),(196,'4b957ea0-4713-11ee-bfe6-a86daa000811','4fb4073e-4713-11ee-bfe6-a86daa000811','SNAPSHOT'),(196,'4b957ea0-4713-11ee-bfe6-a86daa000811','557f540b-4713-11ee-bfe6-a86daa000811','MANDIBLE'),(196,'4b957ea0-4713-11ee-bfe6-a86daa000811','559ab1a3-4713-11ee-bfe6-a86daa000811','LIFI'),(196,'4b957ea0-4713-11ee-bfe6-a86daa000811','559ab8f8-4713-11ee-bfe6-a86daa000811','LIFIMETA'),(196,'4b957ea0-4713-11ee-bfe6-a86daa000811','5998ed51-4713-11ee-bfe6-a86daa000811','MANDIBLE_SB'),(196,'4b957ea0-4713-11ee-bfe6-a86daa000811','5f183485-4713-11ee-bfe6-a86daa000811','MAXILLARY'),(196,'4b957ea0-4713-11ee-bfe6-a86daa000811','5f3b3763-4713-11ee-bfe6-a86daa000811','LIFI'),(196,'4b957ea0-4713-11ee-bfe6-a86daa000811','5f3b3dac-4713-11ee-bfe6-a86daa000811','LIFIMETA'),(196,'4b957ea0-4713-11ee-bfe6-a86daa000811','6557d3c6-4713-11ee-bfe6-a86daa000811','MAXILLARY_SB'),(196,'4bddb249-470a-11ee-bfe6-a86daa000811','4f51891d-470a-11ee-bfe6-a86daa000811','MAXILLARY'),(196,'4bddb249-470a-11ee-bfe6-a86daa000811','4f7c4187-470a-11ee-bfe6-a86daa000811','LIFI'),(196,'4bddb249-470a-11ee-bfe6-a86daa000811','4f7c4840-470a-11ee-bfe6-a86daa000811','LIFIMETA'),(196,'4bddb249-470a-11ee-bfe6-a86daa000811','4f7c8df6-470a-11ee-bfe6-a86daa000811','MANDIBLE'),(196,'4bddb249-470a-11ee-bfe6-a86daa000811','4fa9239c-470a-11ee-bfe6-a86daa000811','LIFI'),(196,'4bddb249-470a-11ee-bfe6-a86daa000811','4fa92977-470a-11ee-bfe6-a86daa000811','LIFIMETA'),(196,'4bddb249-470a-11ee-bfe6-a86daa000811','4ff6737a-470a-11ee-bfe6-a86daa000811','SNAPSHOT');
/*!40000 ALTER TABLE `OcclusionFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Office`
--

DROP TABLE IF EXISTS `Office`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Office` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `mainPhone` varchar(45) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `cityName` varchar(255) DEFAULT NULL,
  `cityZip` varchar(25) DEFAULT NULL,
  `address` text,
  `country` varchar(75) DEFAULT NULL,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  CONSTRAINT `Office_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Office`
--

LOCK TABLES `Office` WRITE;
/*!40000 ALTER TABLE `Office` DISABLE KEYS */;
INSERT INTO `Office` VALUES ('ac3764c4-87c9-4e39-847c-ca29fc0894ee',196,'6789056','faux vip','','ddshjhqs','111110','djfgdgf','France',NULL,'2023-08-30 09:46:35.000','2023-08-30 07:46:40.048','2023-08-30 09:46:40.048'),('ea6598fc-947e-4db9-b23b-6f744fa179f7',197,'123456','','','gffkfkghk','','','France',NULL,'2023-08-30 09:54:37.000','2023-08-30 08:09:58.920','2023-08-30 10:09:58.920');
/*!40000 ALTER TABLE `Office` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PersonInfo`
--

DROP TABLE IF EXISTS `PersonInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PersonInfo` (
  `uuid` varchar(36) NOT NULL,
  `firstname` varchar(64) NOT NULL,
  `lastname` varchar(64) NOT NULL,
  `email` varchar(255) NOT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PersonInfo`
--

LOCK TABLES `PersonInfo` WRITE;
/*!40000 ALTER TABLE `PersonInfo` DISABLE KEYS */;
INSERT INTO `PersonInfo` VALUES ('03249213-8873-4739-a730-2c243f562e6e','sabine','caserta','sabine.caserta@scan4all.fr','2023-08-30 07:46:40.038','2023-08-30 09:46:41.016'),('d34aacad-36fc-4984-86c9-d5c27e4a97ba','sabine','viptest','gamajesas@hotmail.fr','2023-08-30 08:11:40.731','2023-08-30 10:11:40.738');
/*!40000 ALTER TABLE `PersonInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PhoneInfo`
--

DROP TABLE IF EXISTS `PhoneInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PhoneInfo` (
  `uuid` varchar(36) NOT NULL,
  `phone` varchar(45) DEFAULT NULL,
  `cellular` varchar(45) DEFAULT NULL,
  `fax` varchar(45) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PhoneInfo`
--

LOCK TABLES `PhoneInfo` WRITE;
/*!40000 ALTER TABLE `PhoneInfo` DISABLE KEYS */;
INSERT INTO `PhoneInfo` VALUES ('53cd564b-81df-4a5a-9559-1cf8b494641c','6789056','','','2023-08-30 07:46:40.039','2023-08-30 09:46:41.016'),('6a3a755f-288a-44ea-9e4a-83989d3c8f7d','123456','','','2023-08-30 08:09:58.913','2023-08-30 10:11:40.738');
/*!40000 ALTER TABLE `PhoneInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Professional`
--

DROP TABLE IF EXISTS `Professional`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Professional` (
  `uuid` varchar(36) NOT NULL,
  `id` mediumint unsigned NOT NULL,
  `credentialsId` varchar(36) DEFAULT NULL,
  `personInfoId` varchar(36) NOT NULL,
  `phoneInfoId` varchar(36) NOT NULL,
  `addressInfoId` varchar(36) NOT NULL,
  `configId` mediumint unsigned DEFAULT NULL,
  `syncInfoId` mediumint unsigned DEFAULT NULL,
  `surgeryName` varchar(255) DEFAULT NULL,
  `comments` text,
  `type` enum('UNDEFINED','PROTHESIST','DENTIST','DEMO','OTHER') NOT NULL DEFAULT 'UNDEFINED',
  `limitedContactId` varchar(36) DEFAULT NULL,
  `directoryVisible` tinyint(1) NOT NULL DEFAULT '1',
  `statusGalaxy` tinyint(1) DEFAULT '0',
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  UNIQUE KEY `personInfoId` (`personInfoId`),
  UNIQUE KEY `phoneInfoId` (`phoneInfoId`),
  UNIQUE KEY `addressInfoId` (`addressInfoId`),
  UNIQUE KEY `credentialsId` (`credentialsId`),
  KEY `syncInfoId` (`syncInfoId`,`id`),
  KEY `configId` (`configId`,`id`),
  CONSTRAINT `Professional_ibfk_1` FOREIGN KEY (`credentialsId`) REFERENCES `Credentials` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_2` FOREIGN KEY (`personInfoId`) REFERENCES `PersonInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_3` FOREIGN KEY (`phoneInfoId`) REFERENCES `PhoneInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_4` FOREIGN KEY (`addressInfoId`) REFERENCES `AddressInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_5` FOREIGN KEY (`syncInfoId`, `id`) REFERENCES `SyncInfo` (`id`, `ownerId`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_6` FOREIGN KEY (`configId`, `id`) REFERENCES `Config` (`id`, `ownerId`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Professional`
--

LOCK TABLES `Professional` WRITE;
/*!40000 ALTER TABLE `Professional` DISABLE KEYS */;
INSERT INTO `Professional` VALUES ('39bdf5a7-54ab-41f0-96fa-df9fa92bcce7',196,'956d7fd1-bffd-4500-8156-2db75591d0a0','03249213-8873-4739-a730-2c243f562e6e','53cd564b-81df-4a5a-9559-1cf8b494641c','abb5439e-7294-44cc-ad81-6be468ca8dac',1,1,'','','DENTIST',NULL,1,0,NULL,'2023-08-30 09:46:33.000','2023-08-30 07:46:41.010','2023-08-30 09:46:41.016'),('53375c07-a429-412a-8a5c-115e22568140',197,'0431a905-6a1e-4ecc-94c4-1a09e295a24c','d34aacad-36fc-4984-86c9-d5c27e4a97ba','6a3a755f-288a-44ea-9e4a-83989d3c8f7d','788c2a28-99ac-4471-9592-8f7a0bf6a283',1,1,'','','PROTHESIST',NULL,1,0,NULL,'2023-08-30 10:11:39.000','2023-08-30 08:11:40.732','2023-08-30 10:11:40.738');
/*!40000 ALTER TABLE `Professional` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProfessionalEnvInfos`
--

DROP TABLE IF EXISTS `ProfessionalEnvInfos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProfessionalEnvInfos` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `accessCode` varchar(45) DEFAULT NULL,
  `status` enum('CREATED','CONFIRMED','BLOCKED') NOT NULL DEFAULT 'CREATED',
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`ownerId`),
  CONSTRAINT `ProfessionalEnvInfos_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProfessionalEnvInfos`
--

LOCK TABLES `ProfessionalEnvInfos` WRITE;
/*!40000 ALTER TABLE `ProfessionalEnvInfos` DISABLE KEYS */;
INSERT INTO `ProfessionalEnvInfos` VALUES (196,'','CONFIRMED','2023-08-30 07:46:40.047','2023-08-30 09:46:40.047'),(197,'ff90f872','CREATED','2023-08-30 07:54:38.683','2023-08-30 09:54:38.683');
/*!40000 ALTER TABLE `ProfessionalEnvInfos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProfessionalPatient`
--

DROP TABLE IF EXISTS `ProfessionalPatient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProfessionalPatient` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `patientId` varchar(36) NOT NULL,
  `officeId` varchar(36) DEFAULT NULL,
  `enablePatientSharing` tinyint(1) DEFAULT '0',
  `pinned` tinyint(1) NOT NULL DEFAULT '0',
  `theme` enum('NONE','ADULT','BOY','GIRL','BABY') DEFAULT 'NONE',
  PRIMARY KEY (`ownerId`,`patientId`),
  KEY `patientId` (`patientId`),
  KEY `officeId` (`officeId`),
  CONSTRAINT `ProfessionalPatient_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ProfessionalPatient_ibfk_2` FOREIGN KEY (`patientId`) REFERENCES `wow_patient`.`Patient` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ProfessionalPatient_ibfk_3` FOREIGN KEY (`officeId`) REFERENCES `Office` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProfessionalPatient`
--

LOCK TABLES `ProfessionalPatient` WRITE;
/*!40000 ALTER TABLE `ProfessionalPatient` DISABLE KEYS */;
INSERT INTO `ProfessionalPatient` VALUES (196,'41a34220-4716-11ee-bfe6-a86daa000811','ac3764c4-87c9-4e39-847c-ca29fc0894ee',0,0,'NONE'),(196,'7ce01fa7-4709-11ee-bfe6-a86daa000811','ac3764c4-87c9-4e39-847c-ca29fc0894ee',0,0,'NONE'),(196,'d4570ca2-4715-11ee-bfe6-a86daa000811','ac3764c4-87c9-4e39-847c-ca29fc0894ee',0,0,'NONE');
/*!40000 ALTER TABLE `ProfessionalPatient` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrder`
--

DROP TABLE IF EXISTS `ProstheticOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticOrder` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `actId` varchar(36) NOT NULL,
  `title` varchar(64) DEFAULT NULL,
  `status` enum('NOT_SENT','SENT','DATE_VALIDATED','DATE_EDITED','VALIDATED','CANCELLED','DELIVERY') NOT NULL DEFAULT 'NOT_SENT',
  `unread` tinyint(1) DEFAULT '0',
  `currentDeliveryDate` datetime(3) DEFAULT NULL,
  `previousDeliveryDate` datetime(3) DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `displayId` mediumint unsigned DEFAULT NULL,
  `createdById` varchar(36) DEFAULT NULL,
  `updatedById` varchar(36) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `actId` (`actId`),
  CONSTRAINT `ProstheticOrder_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrder_ibfk_2` FOREIGN KEY (`actId`) REFERENCES `Act` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrder`
--

LOCK TABLES `ProstheticOrder` WRITE;
/*!40000 ALTER TABLE `ProstheticOrder` DISABLE KEYS */;
INSERT INTO `ProstheticOrder` VALUES ('28bb3c55-4711-11ee-bfe6-a86daa000811',196,'28b852b9-4711-11ee-bfe6-a86daa000811','Commande n° 1.1.2.1','CANCELLED',0,'2023-09-02 00:00:00.000','2023-09-03 00:00:00.000',0,1,'39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','2023-08-30 10:42:31.000',NULL,'2023-08-30 11:12:57.060','2023-08-30 09:12:57.061','2023-08-30 11:12:57.133'),('404ce5fb-4718-11ee-bfe6-a86daa000811',196,'a0f72d78-4717-11ee-bfe6-a86daa000811','Commande n° 1.1.6.1','SENT',0,'2023-09-01 00:00:00.000',NULL,0,1,'39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','2023-08-30 11:33:17.000',NULL,'2023-08-30 11:33:22.000','2023-08-30 09:33:26.454','2023-08-30 11:33:26.454'),('6ddc44d3-4715-11ee-bfe6-a86daa000811',196,'28b852b9-4711-11ee-bfe6-a86daa000811','Commande n° 1.1.2.2','DATE_VALIDATED',0,'2023-09-02 00:00:00.000',NULL,0,2,'39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','2023-08-30 11:13:05.000',NULL,'2023-08-30 11:14:57.000','2023-08-30 09:14:58.956','2023-08-30 11:14:58.956'),('94134d72-4709-11ee-bfe6-a86daa000811',196,'94108410-4709-11ee-bfe6-a86daa000811','Commande n° 1.1.1.1','DATE_VALIDATED',0,'2023-09-03 00:00:00.000',NULL,0,1,'39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','2023-08-30 09:48:15.000',NULL,'2023-08-30 10:40:50.000','2023-08-30 08:40:51.839','2023-08-30 10:40:51.839'),('99088262-4716-11ee-bfe6-a86daa000811',196,'99062442-4716-11ee-bfe6-a86daa000811','Commande n° 1.1.4.1','CANCELLED',0,'2023-09-02 00:00:00.000',NULL,0,1,'39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','2023-08-30 11:21:27.000',NULL,'2023-08-30 11:22:19.000','2023-08-30 09:22:20.840','2023-08-30 11:22:20.840'),('c58b4ec0-4716-11ee-bfe6-a86daa000811',196,'c588c3d6-4716-11ee-bfe6-a86daa000811','Commande n° 1.1.5.1','DATE_VALIDATED',0,'2023-09-01 00:00:00.000',NULL,0,1,'39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','2023-08-30 11:22:42.000',NULL,'2023-08-30 11:27:49.000','2023-08-30 09:27:51.851','2023-08-30 11:27:51.851'),('c7a92194-4713-11ee-bfe6-a86daa000811',196,'c7a7cd85-4713-11ee-bfe6-a86daa000811','Commande n° 1.1.3.1','DATE_VALIDATED',0,'2023-09-01 00:00:00.000',NULL,0,1,'39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','2023-08-30 11:01:17.000',NULL,'2023-08-30 11:14:24.000','2023-08-30 09:14:24.953','2023-08-30 11:14:24.953'),('dcef31a2-4715-11ee-bfe6-a86daa000811',196,'dcec7c3f-4715-11ee-bfe6-a86daa000811','Commande n° 1.2.1.1','NOT_SENT',1,NULL,NULL,1,1,'39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','2023-08-30 11:16:12.161',NULL,'2023-08-30 11:16:12.165','2023-08-30 09:16:12.165',NULL);
/*!40000 ALTER TABLE `ProstheticOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrderFile`
--

DROP TABLE IF EXISTS `ProstheticOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticOrderFile` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('FORM','SCAN') NOT NULL,
  PRIMARY KEY (`orderId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `ProstheticOrderFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrderFile_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `ProstheticOrder` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrderFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrderFile`
--

LOCK TABLES `ProstheticOrderFile` WRITE;
/*!40000 ALTER TABLE `ProstheticOrderFile` DISABLE KEYS */;
INSERT INTO `ProstheticOrderFile` VALUES (196,'28bb3c55-4711-11ee-bfe6-a86daa000811','3fb541ba-4713-11ee-bfe6-a86daa000811','SCAN'),(196,'28bb3c55-4711-11ee-bfe6-a86daa000811','3fb55e57-4713-11ee-bfe6-a86daa000811','SCAN'),(196,'28bb3c55-4711-11ee-bfe6-a86daa000811','4f2156ce-4713-11ee-bfe6-a86daa000811','SCAN'),(196,'28bb3c55-4711-11ee-bfe6-a86daa000811','4f4b7bb9-4713-11ee-bfe6-a86daa000811','SCAN'),(196,'28bb3c55-4711-11ee-bfe6-a86daa000811','4f4b8104-4713-11ee-bfe6-a86daa000811','SCAN'),(196,'28bb3c55-4711-11ee-bfe6-a86daa000811','4f4bfc45-4713-11ee-bfe6-a86daa000811','SCAN'),(196,'28bb3c55-4711-11ee-bfe6-a86daa000811','4f6bdc64-4713-11ee-bfe6-a86daa000811','SCAN'),(196,'28bb3c55-4711-11ee-bfe6-a86daa000811','4f6bdff0-4713-11ee-bfe6-a86daa000811','SCAN'),(196,'28bb3c55-4711-11ee-bfe6-a86daa000811','4fb4073e-4713-11ee-bfe6-a86daa000811','SCAN'),(196,'28bb3c55-4711-11ee-bfe6-a86daa000811','544f0e3a-4712-11ee-bfe6-a86daa000811','SCAN'),(196,'28bb3c55-4711-11ee-bfe6-a86daa000811','544f3fbb-4712-11ee-bfe6-a86daa000811','SCAN'),(196,'28bb3c55-4711-11ee-bfe6-a86daa000811','557f540b-4713-11ee-bfe6-a86daa000811','SCAN'),(196,'28bb3c55-4711-11ee-bfe6-a86daa000811','559ab1a3-4713-11ee-bfe6-a86daa000811','SCAN'),(196,'28bb3c55-4711-11ee-bfe6-a86daa000811','559ab8f8-4713-11ee-bfe6-a86daa000811','SCAN'),(196,'28bb3c55-4711-11ee-bfe6-a86daa000811','5998ed51-4713-11ee-bfe6-a86daa000811','SCAN'),(196,'28bb3c55-4711-11ee-bfe6-a86daa000811','5c5e63c7-4712-11ee-bfe6-a86daa000811','SCAN'),(196,'28bb3c55-4711-11ee-bfe6-a86daa000811','5c5e6923-4712-11ee-bfe6-a86daa000811','SCAN'),(196,'28bb3c55-4711-11ee-bfe6-a86daa000811','5f183485-4713-11ee-bfe6-a86daa000811','SCAN'),(196,'28bb3c55-4711-11ee-bfe6-a86daa000811','5f3b3763-4713-11ee-bfe6-a86daa000811','SCAN'),(196,'28bb3c55-4711-11ee-bfe6-a86daa000811','5f3b3dac-4713-11ee-bfe6-a86daa000811','SCAN'),(196,'28bb3c55-4711-11ee-bfe6-a86daa000811','5fcd3ac4-4712-11ee-bfe6-a86daa000811','SCAN'),(196,'28bb3c55-4711-11ee-bfe6-a86daa000811','5fcd3ff6-4712-11ee-bfe6-a86daa000811','SCAN'),(196,'28bb3c55-4711-11ee-bfe6-a86daa000811','601256c0-4711-11ee-bfe6-a86daa000811','SCAN'),(196,'28bb3c55-4711-11ee-bfe6-a86daa000811','60126fc7-4711-11ee-bfe6-a86daa000811','SCAN'),(196,'28bb3c55-4711-11ee-bfe6-a86daa000811','6557d3c6-4713-11ee-bfe6-a86daa000811','SCAN'),(196,'28bb3c55-4711-11ee-bfe6-a86daa000811','7b984e54-4713-11ee-bfe6-a86daa000811','FORM'),(196,'28bb3c55-4711-11ee-bfe6-a86daa000811','8c22f707-4712-11ee-bfe6-a86daa000811','SCAN'),(196,'28bb3c55-4711-11ee-bfe6-a86daa000811','8c230d37-4712-11ee-bfe6-a86daa000811','SCAN'),(196,'28bb3c55-4711-11ee-bfe6-a86daa000811','b2229610-4712-11ee-bfe6-a86daa000811','SCAN'),(196,'28bb3c55-4711-11ee-bfe6-a86daa000811','b222b05b-4712-11ee-bfe6-a86daa000811','SCAN'),(196,'28bb3c55-4711-11ee-bfe6-a86daa000811','b801ed81-4711-11ee-bfe6-a86daa000811','SCAN'),(196,'28bb3c55-4711-11ee-bfe6-a86daa000811','b802029b-4711-11ee-bfe6-a86daa000811','SCAN'),(196,'28bb3c55-4711-11ee-bfe6-a86daa000811','e45fa630-4712-11ee-bfe6-a86daa000811','SCAN'),(196,'28bb3c55-4711-11ee-bfe6-a86daa000811','e45fbb59-4712-11ee-bfe6-a86daa000811','SCAN'),(196,'28bb3c55-4711-11ee-bfe6-a86daa000811','ebcaf2e8-4712-11ee-bfe6-a86daa000811','SCAN'),(196,'28bb3c55-4711-11ee-bfe6-a86daa000811','ebcaf8ff-4712-11ee-bfe6-a86daa000811','SCAN'),(196,'28bb3c55-4711-11ee-bfe6-a86daa000811','ef71f4e5-4712-11ee-bfe6-a86daa000811','SCAN'),(196,'28bb3c55-4711-11ee-bfe6-a86daa000811','ef71f80d-4712-11ee-bfe6-a86daa000811','SCAN'),(196,'404ce5fb-4718-11ee-bfe6-a86daa000811','014de352-4718-11ee-bfe6-a86daa000811','SCAN'),(196,'404ce5fb-4718-11ee-bfe6-a86daa000811','014dea28-4718-11ee-bfe6-a86daa000811','SCAN'),(196,'404ce5fb-4718-11ee-bfe6-a86daa000811','1b7fb9c1-4718-11ee-bfe6-a86daa000811','SCAN'),(196,'404ce5fb-4718-11ee-bfe6-a86daa000811','1b7fd125-4718-11ee-bfe6-a86daa000811','SCAN'),(196,'404ce5fb-4718-11ee-bfe6-a86daa000811','1fdc68df-4718-11ee-bfe6-a86daa000811','SCAN'),(196,'404ce5fb-4718-11ee-bfe6-a86daa000811','1ff793b5-4718-11ee-bfe6-a86daa000811','SCAN'),(196,'404ce5fb-4718-11ee-bfe6-a86daa000811','1ff79a2c-4718-11ee-bfe6-a86daa000811','SCAN'),(196,'404ce5fb-4718-11ee-bfe6-a86daa000811','1ff7ece3-4718-11ee-bfe6-a86daa000811','SCAN'),(196,'404ce5fb-4718-11ee-bfe6-a86daa000811','1ff7f30d-4718-11ee-bfe6-a86daa000811','SCAN'),(196,'404ce5fb-4718-11ee-bfe6-a86daa000811','1ff833ca-4718-11ee-bfe6-a86daa000811','SCAN'),(196,'404ce5fb-4718-11ee-bfe6-a86daa000811','2013924f-4718-11ee-bfe6-a86daa000811','SCAN'),(196,'404ce5fb-4718-11ee-bfe6-a86daa000811','201398ef-4718-11ee-bfe6-a86daa000811','SCAN'),(196,'404ce5fb-4718-11ee-bfe6-a86daa000811','2013d4ed-4718-11ee-bfe6-a86daa000811','SCAN'),(196,'404ce5fb-4718-11ee-bfe6-a86daa000811','2013d727-4718-11ee-bfe6-a86daa000811','SCAN'),(196,'404ce5fb-4718-11ee-bfe6-a86daa000811','20507804-4718-11ee-bfe6-a86daa000811','SCAN'),(196,'404ce5fb-4718-11ee-bfe6-a86daa000811','428f2cc6-4718-11ee-bfe6-a86daa000811','FORM'),(196,'404ce5fb-4718-11ee-bfe6-a86daa000811','42ed82b0-4718-11ee-bfe6-a86daa000811','FORM'),(196,'404ce5fb-4718-11ee-bfe6-a86daa000811','bb514d27-4717-11ee-bfe6-a86daa000811','SCAN'),(196,'404ce5fb-4718-11ee-bfe6-a86daa000811','bb517432-4717-11ee-bfe6-a86daa000811','SCAN'),(196,'404ce5fb-4718-11ee-bfe6-a86daa000811','ccfc6b34-4717-11ee-bfe6-a86daa000811','SCAN'),(196,'404ce5fb-4718-11ee-bfe6-a86daa000811','ccfc70eb-4717-11ee-bfe6-a86daa000811','SCAN'),(196,'404ce5fb-4718-11ee-bfe6-a86daa000811','f147aef1-4717-11ee-bfe6-a86daa000811','SCAN'),(196,'404ce5fb-4718-11ee-bfe6-a86daa000811','f147c789-4717-11ee-bfe6-a86daa000811','SCAN'),(196,'404ce5fb-4718-11ee-bfe6-a86daa000811','f4fad758-4717-11ee-bfe6-a86daa000811','SCAN'),(196,'404ce5fb-4718-11ee-bfe6-a86daa000811','f4fadf46-4717-11ee-bfe6-a86daa000811','SCAN'),(196,'404ce5fb-4718-11ee-bfe6-a86daa000811','fd53a313-4717-11ee-bfe6-a86daa000811','SCAN'),(196,'404ce5fb-4718-11ee-bfe6-a86daa000811','fd53aa08-4717-11ee-bfe6-a86daa000811','SCAN'),(196,'6ddc44d3-4715-11ee-bfe6-a86daa000811','3fb541ba-4713-11ee-bfe6-a86daa000811','SCAN'),(196,'6ddc44d3-4715-11ee-bfe6-a86daa000811','3fb55e57-4713-11ee-bfe6-a86daa000811','SCAN'),(196,'6ddc44d3-4715-11ee-bfe6-a86daa000811','4f2156ce-4713-11ee-bfe6-a86daa000811','SCAN'),(196,'6ddc44d3-4715-11ee-bfe6-a86daa000811','4f4b7bb9-4713-11ee-bfe6-a86daa000811','SCAN'),(196,'6ddc44d3-4715-11ee-bfe6-a86daa000811','4f4b8104-4713-11ee-bfe6-a86daa000811','SCAN'),(196,'6ddc44d3-4715-11ee-bfe6-a86daa000811','4f4bfc45-4713-11ee-bfe6-a86daa000811','SCAN'),(196,'6ddc44d3-4715-11ee-bfe6-a86daa000811','4f6bdc64-4713-11ee-bfe6-a86daa000811','SCAN'),(196,'6ddc44d3-4715-11ee-bfe6-a86daa000811','4f6bdff0-4713-11ee-bfe6-a86daa000811','SCAN'),(196,'6ddc44d3-4715-11ee-bfe6-a86daa000811','4fb4073e-4713-11ee-bfe6-a86daa000811','SCAN'),(196,'6ddc44d3-4715-11ee-bfe6-a86daa000811','544f0e3a-4712-11ee-bfe6-a86daa000811','SCAN'),(196,'6ddc44d3-4715-11ee-bfe6-a86daa000811','544f3fbb-4712-11ee-bfe6-a86daa000811','SCAN'),(196,'6ddc44d3-4715-11ee-bfe6-a86daa000811','557f540b-4713-11ee-bfe6-a86daa000811','SCAN'),(196,'6ddc44d3-4715-11ee-bfe6-a86daa000811','559ab1a3-4713-11ee-bfe6-a86daa000811','SCAN'),(196,'6ddc44d3-4715-11ee-bfe6-a86daa000811','559ab8f8-4713-11ee-bfe6-a86daa000811','SCAN'),(196,'6ddc44d3-4715-11ee-bfe6-a86daa000811','5998ed51-4713-11ee-bfe6-a86daa000811','SCAN'),(196,'6ddc44d3-4715-11ee-bfe6-a86daa000811','5c5e63c7-4712-11ee-bfe6-a86daa000811','SCAN'),(196,'6ddc44d3-4715-11ee-bfe6-a86daa000811','5c5e6923-4712-11ee-bfe6-a86daa000811','SCAN'),(196,'6ddc44d3-4715-11ee-bfe6-a86daa000811','5f183485-4713-11ee-bfe6-a86daa000811','SCAN'),(196,'6ddc44d3-4715-11ee-bfe6-a86daa000811','5f3b3763-4713-11ee-bfe6-a86daa000811','SCAN'),(196,'6ddc44d3-4715-11ee-bfe6-a86daa000811','5f3b3dac-4713-11ee-bfe6-a86daa000811','SCAN'),(196,'6ddc44d3-4715-11ee-bfe6-a86daa000811','5fcd3ac4-4712-11ee-bfe6-a86daa000811','SCAN'),(196,'6ddc44d3-4715-11ee-bfe6-a86daa000811','5fcd3ff6-4712-11ee-bfe6-a86daa000811','SCAN'),(196,'6ddc44d3-4715-11ee-bfe6-a86daa000811','601256c0-4711-11ee-bfe6-a86daa000811','SCAN'),(196,'6ddc44d3-4715-11ee-bfe6-a86daa000811','60126fc7-4711-11ee-bfe6-a86daa000811','SCAN'),(196,'6ddc44d3-4715-11ee-bfe6-a86daa000811','6557d3c6-4713-11ee-bfe6-a86daa000811','SCAN'),(196,'6ddc44d3-4715-11ee-bfe6-a86daa000811','6dded3e3-4715-11ee-bfe6-a86daa000811','FORM'),(196,'6ddc44d3-4715-11ee-bfe6-a86daa000811','8c22f707-4712-11ee-bfe6-a86daa000811','SCAN'),(196,'6ddc44d3-4715-11ee-bfe6-a86daa000811','8c230d37-4712-11ee-bfe6-a86daa000811','SCAN'),(196,'6ddc44d3-4715-11ee-bfe6-a86daa000811','b2229610-4712-11ee-bfe6-a86daa000811','SCAN'),(196,'6ddc44d3-4715-11ee-bfe6-a86daa000811','b222b05b-4712-11ee-bfe6-a86daa000811','SCAN'),(196,'6ddc44d3-4715-11ee-bfe6-a86daa000811','b801ed81-4711-11ee-bfe6-a86daa000811','SCAN'),(196,'6ddc44d3-4715-11ee-bfe6-a86daa000811','b802029b-4711-11ee-bfe6-a86daa000811','SCAN'),(196,'6ddc44d3-4715-11ee-bfe6-a86daa000811','e45fa630-4712-11ee-bfe6-a86daa000811','SCAN'),(196,'6ddc44d3-4715-11ee-bfe6-a86daa000811','e45fbb59-4712-11ee-bfe6-a86daa000811','SCAN'),(196,'6ddc44d3-4715-11ee-bfe6-a86daa000811','ebcaf2e8-4712-11ee-bfe6-a86daa000811','SCAN'),(196,'6ddc44d3-4715-11ee-bfe6-a86daa000811','ebcaf8ff-4712-11ee-bfe6-a86daa000811','SCAN'),(196,'6ddc44d3-4715-11ee-bfe6-a86daa000811','ef71f4e5-4712-11ee-bfe6-a86daa000811','SCAN'),(196,'6ddc44d3-4715-11ee-bfe6-a86daa000811','ef71f80d-4712-11ee-bfe6-a86daa000811','SCAN'),(196,'94134d72-4709-11ee-bfe6-a86daa000811','0e658e5a-470a-11ee-bfe6-a86daa000811','SCAN'),(196,'94134d72-4709-11ee-bfe6-a86daa000811','0e65a514-470a-11ee-bfe6-a86daa000811','SCAN'),(196,'94134d72-4709-11ee-bfe6-a86daa000811','20eaffbb-470a-11ee-bfe6-a86daa000811','SCAN'),(196,'94134d72-4709-11ee-bfe6-a86daa000811','20eb0492-470a-11ee-bfe6-a86daa000811','SCAN'),(196,'94134d72-4709-11ee-bfe6-a86daa000811','473cc8ba-470a-11ee-bfe6-a86daa000811','SCAN'),(196,'94134d72-4709-11ee-bfe6-a86daa000811','473cddfc-470a-11ee-bfe6-a86daa000811','SCAN'),(196,'94134d72-4709-11ee-bfe6-a86daa000811','4f51891d-470a-11ee-bfe6-a86daa000811','SCAN'),(196,'94134d72-4709-11ee-bfe6-a86daa000811','4f7c4187-470a-11ee-bfe6-a86daa000811','SCAN'),(196,'94134d72-4709-11ee-bfe6-a86daa000811','4f7c4840-470a-11ee-bfe6-a86daa000811','SCAN'),(196,'94134d72-4709-11ee-bfe6-a86daa000811','4f7c8df6-470a-11ee-bfe6-a86daa000811','SCAN'),(196,'94134d72-4709-11ee-bfe6-a86daa000811','4fa9239c-470a-11ee-bfe6-a86daa000811','SCAN'),(196,'94134d72-4709-11ee-bfe6-a86daa000811','4fa92977-470a-11ee-bfe6-a86daa000811','SCAN'),(196,'94134d72-4709-11ee-bfe6-a86daa000811','4ff6737a-470a-11ee-bfe6-a86daa000811','SCAN'),(196,'94134d72-4709-11ee-bfe6-a86daa000811','ac976331-4710-11ee-bfe6-a86daa000811','FORM'),(196,'94134d72-4709-11ee-bfe6-a86daa000811','d5425abd-4709-11ee-bfe6-a86daa000811','SCAN'),(196,'94134d72-4709-11ee-bfe6-a86daa000811','d54273bc-4709-11ee-bfe6-a86daa000811','SCAN'),(196,'94134d72-4709-11ee-bfe6-a86daa000811','dbed38ba-4709-11ee-bfe6-a86daa000811','SCAN'),(196,'94134d72-4709-11ee-bfe6-a86daa000811','dbed3f00-4709-11ee-bfe6-a86daa000811','SCAN'),(196,'99088262-4716-11ee-bfe6-a86daa000811','4f2156ce-4713-11ee-bfe6-a86daa000811','SCAN'),(196,'99088262-4716-11ee-bfe6-a86daa000811','4f4bfc45-4713-11ee-bfe6-a86daa000811','SCAN'),(196,'99088262-4716-11ee-bfe6-a86daa000811','557f540b-4713-11ee-bfe6-a86daa000811','SCAN'),(196,'99088262-4716-11ee-bfe6-a86daa000811','5998ed51-4713-11ee-bfe6-a86daa000811','SCAN'),(196,'99088262-4716-11ee-bfe6-a86daa000811','5f183485-4713-11ee-bfe6-a86daa000811','SCAN'),(196,'99088262-4716-11ee-bfe6-a86daa000811','601256c0-4711-11ee-bfe6-a86daa000811','SCAN'),(196,'99088262-4716-11ee-bfe6-a86daa000811','60126fc7-4711-11ee-bfe6-a86daa000811','SCAN'),(196,'99088262-4716-11ee-bfe6-a86daa000811','6557d3c6-4713-11ee-bfe6-a86daa000811','SCAN'),(196,'99088262-4716-11ee-bfe6-a86daa000811','ad6eec8c-4716-11ee-bfe6-a86daa000811','FORM'),(196,'99088262-4716-11ee-bfe6-a86daa000811','e45fa630-4712-11ee-bfe6-a86daa000811','SCAN'),(196,'99088262-4716-11ee-bfe6-a86daa000811','e45fbb59-4712-11ee-bfe6-a86daa000811','SCAN'),(196,'c58b4ec0-4716-11ee-bfe6-a86daa000811','14f1ba3f-4717-11ee-bfe6-a86daa000811','SCAN'),(196,'c58b4ec0-4716-11ee-bfe6-a86daa000811','14f1d27f-4717-11ee-bfe6-a86daa000811','SCAN'),(196,'c58b4ec0-4716-11ee-bfe6-a86daa000811','3ada50a1-4717-11ee-bfe6-a86daa000811','SCAN'),(196,'c58b4ec0-4716-11ee-bfe6-a86daa000811','3ada6922-4717-11ee-bfe6-a86daa000811','SCAN'),(196,'c58b4ec0-4716-11ee-bfe6-a86daa000811','4f674de1-4717-11ee-bfe6-a86daa000811','SCAN'),(196,'c58b4ec0-4716-11ee-bfe6-a86daa000811','4f826c6b-4717-11ee-bfe6-a86daa000811','SCAN'),(196,'c58b4ec0-4716-11ee-bfe6-a86daa000811','4f8270ca-4717-11ee-bfe6-a86daa000811','SCAN'),(196,'c58b4ec0-4716-11ee-bfe6-a86daa000811','4f82ccb6-4717-11ee-bfe6-a86daa000811','SCAN'),(196,'c58b4ec0-4716-11ee-bfe6-a86daa000811','4fd6f395-4717-11ee-bfe6-a86daa000811','SCAN'),(196,'c58b4ec0-4716-11ee-bfe6-a86daa000811','5cd37d0e-4717-11ee-bfe6-a86daa000811','SCAN'),(196,'c58b4ec0-4716-11ee-bfe6-a86daa000811','5fc0dd4c-4717-11ee-bfe6-a86daa000811','SCAN'),(196,'c58b4ec0-4716-11ee-bfe6-a86daa000811','6a4033f8-4717-11ee-bfe6-a86daa000811','FORM'),(196,'c58b4ec0-4716-11ee-bfe6-a86daa000811','f12116be-4716-11ee-bfe6-a86daa000811','SCAN'),(196,'c58b4ec0-4716-11ee-bfe6-a86daa000811','f1212eaf-4716-11ee-bfe6-a86daa000811','SCAN'),(196,'c58b4ec0-4716-11ee-bfe6-a86daa000811','fa4a5d2b-4716-11ee-bfe6-a86daa000811','SCAN'),(196,'c58b4ec0-4716-11ee-bfe6-a86daa000811','fa4a653e-4716-11ee-bfe6-a86daa000811','SCAN'),(196,'c7a92194-4713-11ee-bfe6-a86daa000811','39ab1d77-4715-11ee-bfe6-a86daa000811','SCAN'),(196,'c7a92194-4713-11ee-bfe6-a86daa000811','39c6835e-4715-11ee-bfe6-a86daa000811','SCAN'),(196,'c7a92194-4713-11ee-bfe6-a86daa000811','39c689b6-4715-11ee-bfe6-a86daa000811','SCAN'),(196,'c7a92194-4713-11ee-bfe6-a86daa000811','39c6e5de-4715-11ee-bfe6-a86daa000811','SCAN'),(196,'c7a92194-4713-11ee-bfe6-a86daa000811','3a16950d-4715-11ee-bfe6-a86daa000811','SCAN'),(196,'c7a92194-4713-11ee-bfe6-a86daa000811','3a30cc69-4715-11ee-bfe6-a86daa000811','SCAN'),(196,'c7a92194-4713-11ee-bfe6-a86daa000811','3a30d21c-4715-11ee-bfe6-a86daa000811','SCAN'),(196,'c7a92194-4713-11ee-bfe6-a86daa000811','3a5d4663-4715-11ee-bfe6-a86daa000811','SCAN'),(196,'c7a92194-4713-11ee-bfe6-a86daa000811','3a753395-4715-11ee-bfe6-a86daa000811','SCAN'),(196,'c7a92194-4713-11ee-bfe6-a86daa000811','3a75389e-4715-11ee-bfe6-a86daa000811','SCAN'),(196,'c7a92194-4713-11ee-bfe6-a86daa000811','3aab0524-4715-11ee-bfe6-a86daa000811','SCAN'),(196,'c7a92194-4713-11ee-bfe6-a86daa000811','3ae88db9-4715-11ee-bfe6-a86daa000811','SCAN'),(196,'c7a92194-4713-11ee-bfe6-a86daa000811','3ba46ed3-4715-11ee-bfe6-a86daa000811','SCAN'),(196,'c7a92194-4713-11ee-bfe6-a86daa000811','54d9092d-4715-11ee-bfe6-a86daa000811','SCAN'),(196,'c7a92194-4713-11ee-bfe6-a86daa000811','54d90bb3-4715-11ee-bfe6-a86daa000811','SCAN'),(196,'c7a92194-4713-11ee-bfe6-a86daa000811','5f7a5af2-4715-11ee-bfe6-a86daa000811','FORM');
/*!40000 ALTER TABLE `ProstheticOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrderRecipient`
--

DROP TABLE IF EXISTS `ProstheticOrderRecipient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticOrderRecipient` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `recipientId` varchar(36) NOT NULL,
  PRIMARY KEY (`orderId`,`recipientId`),
  KEY `ownerId` (`ownerId`),
  KEY `recipientId` (`recipientId`),
  CONSTRAINT `ProstheticOrderRecipient_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrderRecipient_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `ProstheticOrder` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrderRecipient_ibfk_3` FOREIGN KEY (`recipientId`) REFERENCES `Contact` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrderRecipient`
--

LOCK TABLES `ProstheticOrderRecipient` WRITE;
/*!40000 ALTER TABLE `ProstheticOrderRecipient` DISABLE KEYS */;
INSERT INTO `ProstheticOrderRecipient` VALUES (196,'28bb3c55-4711-11ee-bfe6-a86daa000811','6d038bac-e819-45db-8313-aba6d0d4ec3a'),(196,'404ce5fb-4718-11ee-bfe6-a86daa000811','6d038bac-e819-45db-8313-aba6d0d4ec3a'),(196,'6ddc44d3-4715-11ee-bfe6-a86daa000811','6d038bac-e819-45db-8313-aba6d0d4ec3a'),(196,'94134d72-4709-11ee-bfe6-a86daa000811','6d038bac-e819-45db-8313-aba6d0d4ec3a'),(196,'99088262-4716-11ee-bfe6-a86daa000811','6d038bac-e819-45db-8313-aba6d0d4ec3a'),(196,'c58b4ec0-4716-11ee-bfe6-a86daa000811','6d038bac-e819-45db-8313-aba6d0d4ec3a'),(196,'c7a92194-4713-11ee-bfe6-a86daa000811','6d038bac-e819-45db-8313-aba6d0d4ec3a');
/*!40000 ALTER TABLE `ProstheticOrderRecipient` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticSheet`
--

DROP TABLE IF EXISTS `ProstheticSheet`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticSheet` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `json` text NOT NULL,
  `pdfFileId` varchar(36) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `orderId` (`orderId`),
  KEY `pdfFileId` (`pdfFileId`),
  CONSTRAINT `ProstheticSheet_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ProstheticSheet_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `ProstheticOrder` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ProstheticSheet_ibfk_3` FOREIGN KEY (`pdfFileId`) REFERENCES `File` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticSheet`
--

LOCK TABLES `ProstheticSheet` WRITE;
/*!40000 ALTER TABLE `ProstheticSheet` DISABLE KEYS */;
INSERT INTO `ProstheticSheet` VALUES ('28bb9e12-4711-11ee-bfe6-a86daa000811',196,'28bb3c55-4711-11ee-bfe6-a86daa000811','{\n    \"v2\": {\n        \"brandScanBody\": \"Biotech Dental\",\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"refImplant\": \"\",\n        \"refScanBody\": \"K30PSCANP\",\n        \"selectedTeeth\": [\n            17\n        ],\n        \"sheetTitle\": \"Couronne sur implant\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 1,\n        \"usePrePreparation\": false\n    }\n}\n','7b984e54-4713-11ee-bfe6-a86daa000811','2023-08-30 10:42:12.000',NULL,'2023-08-30 10:59:15.000','2023-08-30 08:59:16.598','2023-08-30 11:02:26.974'),('404d58a4-4718-11ee-bfe6-a86daa000811',196,'404ce5fb-4718-11ee-bfe6-a86daa000811','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            26\n        ],\n        \"sheetTitle\": \"Couronne\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 0,\n        \"usePrePreparation\": false\n    }\n}\n','428f2cc6-4718-11ee-bfe6-a86daa000811','2023-08-30 11:33:10.588',NULL,'2023-08-30 11:33:21.654','2023-08-30 09:33:22.886','2023-08-30 11:33:26.188'),('404d7486-4718-11ee-bfe6-a86daa000811',196,'404ce5fb-4718-11ee-bfe6-a86daa000811','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            37\n        ],\n        \"sheetTitle\": \"Couronne\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 0,\n        \"usePrePreparation\": false\n    }\n}\n','42ed82b0-4718-11ee-bfe6-a86daa000811','2023-08-30 11:33:15.154',NULL,'2023-08-30 11:33:22.271','2023-08-30 09:33:22.886','2023-08-30 11:33:26.188'),('6ddcae47-4715-11ee-bfe6-a86daa000811',196,'6ddc44d3-4715-11ee-bfe6-a86daa000811','{\n    \"v2\": {\n        \"brandScanBody\": \"Biotech Dental\",\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"refImplant\": \"\",\n        \"refScanBody\": \"K30PSCANP\",\n        \"selectedTeeth\": [\n            17\n        ],\n        \"sheetTitle\": \"Couronne sur implant\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 1,\n        \"usePrePreparation\": false\n    }\n}\n','6dded3e3-4715-11ee-bfe6-a86daa000811','2023-08-30 11:13:05.000',NULL,'2023-08-30 11:13:10.000','2023-08-30 09:14:58.962','2023-08-30 11:14:58.956'),('9413b35a-4709-11ee-bfe6-a86daa000811',196,'94134d72-4709-11ee-bfe6-a86daa000811','{\n    \"v2\": {\n        \"comment\": \"test envoi commande lifi sur mx et md\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            17\n        ],\n        \"sheetTitle\": \"Couronne\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 0,\n        \"usePrePreparation\": false\n    }\n}\n','ac976331-4710-11ee-bfe6-a86daa000811','2023-08-30 09:47:47.000',NULL,'2023-08-30 10:39:16.000','2023-08-30 08:39:18.000','2023-08-30 10:40:51.839'),('9908e382-4716-11ee-bfe6-a86daa000811',196,'99088262-4716-11ee-bfe6-a86daa000811','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            16\n        ],\n        \"sheetTitle\": \"Couronne\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 0,\n        \"usePrePreparation\": false\n    }\n}\n','ad6eec8c-4716-11ee-bfe6-a86daa000811','2023-08-30 11:21:22.000',NULL,'2023-08-30 11:22:04.000','2023-08-30 09:22:20.842','2023-08-30 11:22:20.840'),('c58ba858-4716-11ee-bfe6-a86daa000811',196,'c58b4ec0-4716-11ee-bfe6-a86daa000811','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            25\n        ],\n        \"sheetTitle\": \"Facette\",\n        \"specificTint\": \"\",\n        \"type\": 6,\n        \"usePrePreparation\": false\n    }\n}\n','6a4033f8-4717-11ee-bfe6-a86daa000811','2023-08-30 11:22:36.000',NULL,'2023-08-30 11:27:22.000','2023-08-30 09:27:51.854','2023-08-30 11:27:51.851'),('c7a937b9-4713-11ee-bfe6-a86daa000811',196,'c7a92194-4713-11ee-bfe6-a86daa000811','{\n    \"v2\": {\n        \"brandScanBody\": \"Biotech Dental\",\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"refImplant\": \"\",\n        \"refScanBody\": \"KECESCANP\",\n        \"selectedTeeth\": [\n            17,\n            47\n        ],\n        \"sheetTitle\": \"Couronne sur implant\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 1,\n        \"usePrePreparation\": true\n    }\n}\n','5f7a5af2-4715-11ee-bfe6-a86daa000811','2023-08-30 11:00:53.000',NULL,'2023-08-30 11:12:44.000','2023-08-30 09:14:24.955','2023-08-30 11:14:24.953'),('dcef9f69-4715-11ee-bfe6-a86daa000811',196,'dcef31a2-4715-11ee-bfe6-a86daa000811','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"Autre\",\n        \"type\": 12,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-08-30 11:16:06.003',NULL,'2023-08-30 11:16:12.164','2023-08-30 09:16:12.166',NULL);
/*!40000 ALTER TABLE `ProstheticSheet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ReceivedAttachment`
--

DROP TABLE IF EXISTS `ReceivedAttachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ReceivedAttachment` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `receivedMessageId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  PRIMARY KEY (`receivedMessageId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `ReceivedAttachment_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ReceivedAttachment_ibfk_2` FOREIGN KEY (`receivedMessageId`) REFERENCES `ReceivedMessage` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ReceivedAttachment_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ReceivedAttachment`
--

LOCK TABLES `ReceivedAttachment` WRITE;
/*!40000 ALTER TABLE `ReceivedAttachment` DISABLE KEYS */;
/*!40000 ALTER TABLE `ReceivedAttachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ReceivedMessage`
--

DROP TABLE IF EXISTS `ReceivedMessage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ReceivedMessage` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `messageTransmitted` tinyint(1) NOT NULL DEFAULT '0',
  `messageSubject` varchar(45) NOT NULL,
  `body` text,
  `fromId` mediumint unsigned NOT NULL,
  `originMessageId` varchar(36) DEFAULT NULL,
  `discussionId` varchar(36) NOT NULL,
  `readStatus` enum('READ','UNREAD') DEFAULT 'UNREAD',
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `fromId` (`fromId`),
  KEY `discussionId` (`discussionId`,`ownerId`),
  CONSTRAINT `ReceivedMessage_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ReceivedMessage_ibfk_2` FOREIGN KEY (`fromId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ReceivedMessage_ibfk_3` FOREIGN KEY (`discussionId`, `ownerId`) REFERENCES `Discussion` (`uuid`, `ownerId`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ReceivedMessage`
--

LOCK TABLES `ReceivedMessage` WRITE;
/*!40000 ALTER TABLE `ReceivedMessage` DISABLE KEYS */;
INSERT INTO `ReceivedMessage` VALUES ('0a39483a-4711-11ee-9077-6ec2958327c0',196,1,'Réponse depuis le web','ok bien reçu les 2 (avec et sans fichier)',197,'82ced6fb-c405-433d-82ba-a1b0dffa5ae7','e9aee9e9-470c-11ee-bfe6-a86daa000811','READ','2023-08-30 10:41:40.000',NULL,'2023-08-30 10:41:40.000','2023-08-30 08:41:42.219','2023-08-30 10:41:42.222'),('f10333cc-470c-11ee-9077-6ec2958327c0',196,1,'Réponse depuis le web','ok',197,'6d5e4be3-75e6-4329-8824-a26e18f3663d','e9aee9e9-470c-11ee-bfe6-a86daa000811','READ','2023-08-30 10:12:20.000',NULL,'2023-08-30 10:12:20.000','2023-08-30 08:12:21.197','2023-08-30 10:12:21.199');
/*!40000 ALTER TABLE `ReceivedMessage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Scan`
--

DROP TABLE IF EXISTS `Scan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Scan` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL,
  `sessionId` varchar(36) NOT NULL,
  `type` enum('MAXILLAIRE','MANDIBULE','MORDU_ANTERIEUR','MORDU_POSTERIEUR_GAUCHE','MORDU_POSTERIEUR_DROIT') NOT NULL,
  `label` enum('PRE_PREPARATION','SCAN','SCANBODY') NOT NULL DEFAULT 'SCAN',
  `validated` tinyint(1) NOT NULL DEFAULT '0',
  `status` enum('IN_PROGRESS','NONE') NOT NULL DEFAULT 'IN_PROGRESS',
  `displayId` mediumint unsigned DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `comments` text,
  `createdById` varchar(36) DEFAULT NULL,
  `updatedById` varchar(36) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `sessionId` (`sessionId`),
  CONSTRAINT `Scan_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Scan_ibfk_2` FOREIGN KEY (`sessionId`) REFERENCES `Session` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Scan`
--

LOCK TABLES `Scan` WRITE;
/*!40000 ALTER TABLE `Scan` DISABLE KEYS */;
INSERT INTO `Scan` VALUES ('038d534c-4718-11ee-bfe6-a86daa000811',196,'a0f77fda-4717-11ee-bfe6-a86daa000811','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','2023-08-30 11:31:35.944',NULL,'2023-08-30 11:32:40.600','2023-08-30 09:32:40.600','2023-08-30 11:32:40.605'),('10ba483c-4715-11ee-bfe6-a86daa000811',196,'c7a8830f-4713-11ee-bfe6-a86daa000811','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','2023-08-30 11:10:29.559',NULL,'2023-08-30 11:11:14.724','2023-08-30 09:11:14.724','2023-08-30 11:11:14.731'),('19ab91b2-4717-11ee-bfe6-a86daa000811',196,'c589e5b6-4716-11ee-bfe6-a86daa000811','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','2023-08-30 11:25:03.555',NULL,'2023-08-30 11:25:59.461','2023-08-30 09:25:59.462','2023-08-30 11:25:59.466'),('22084bd2-4714-11ee-bfe6-a86daa000811',196,'c7a8830f-4713-11ee-bfe6-a86daa000811','MAXILLAIRE','SCAN',1,'NONE',2,0,'{\"referenceScanId\":\"c98c9fb7-4713-11ee-bfe6-a86daa000811\"}','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','2023-08-30 11:03:49.095',NULL,'2023-08-30 11:08:49.078','2023-08-30 09:08:49.078','2023-08-30 11:08:49.085'),('29e45423-470a-11ee-bfe6-a86daa000811',196,'9411ecbc-4709-11ee-bfe6-a86daa000811','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','2023-08-30 09:52:27.313',NULL,'2023-08-30 09:53:16.761','2023-08-30 07:53:16.761','2023-08-30 09:53:16.765'),('29fbd842-4711-11ee-bfe6-a86daa000811',196,'28b9b3ca-4711-11ee-bfe6-a86daa000811','MAXILLAIRE','SCAN',1,'NONE',1,0,'','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','2023-08-30 10:42:33.945',NULL,'2023-08-30 10:51:07.980','2023-08-30 08:51:07.980','2023-08-30 10:51:07.986'),('57bf381a-4714-11ee-bfe6-a86daa000811',196,'c7a8830f-4713-11ee-bfe6-a86daa000811','MAXILLAIRE','SCANBODY',1,'NONE',3,0,'{\"referenceScanId\":\"22084bd2-4714-11ee-bfe6-a86daa000811\"}','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','2023-08-30 11:05:19.213',NULL,'2023-08-30 11:07:22.415','2023-08-30 09:07:22.415','2023-08-30 11:07:22.425'),('64dba54e-4712-11ee-bfe6-a86daa000811',196,'28b9b3ca-4711-11ee-bfe6-a86daa000811','MANDIBULE','SCAN',1,'NONE',1,0,'','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','2023-08-30 10:51:22.216',NULL,'2023-08-30 10:55:08.602','2023-08-30 08:55:08.603','2023-08-30 10:55:08.608'),('79ca2646-4711-11ee-bfe6-a86daa000811',196,'28b9b3ca-4711-11ee-bfe6-a86daa000811','MAXILLAIRE','SCAN',1,'NONE',2,0,'{\"referenceScanId\":\"29fbd842-4711-11ee-bfe6-a86daa000811\"}','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','2023-08-30 10:44:47.837',NULL,'2023-08-30 10:51:13.737','2023-08-30 08:51:13.738','2023-08-30 10:51:13.743'),('8fb5e92d-4712-11ee-bfe6-a86daa000811',196,'28b9b3ca-4711-11ee-bfe6-a86daa000811','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','2023-08-30 10:52:34.111',NULL,'2023-08-30 10:53:32.191','2023-08-30 08:53:32.191','2023-08-30 10:53:32.195'),('978d31c9-4709-11ee-bfe6-a86daa000811',196,'9411ecbc-4709-11ee-bfe6-a86daa000811','MAXILLAIRE','SCAN',1,'NONE',1,0,'','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','2023-08-30 09:48:21.795',NULL,'2023-08-30 09:50:16.512','2023-08-30 07:50:16.512','2023-08-30 09:50:16.518'),('a27d60d7-4717-11ee-bfe6-a86daa000811',196,'a0f77fda-4717-11ee-bfe6-a86daa000811','MAXILLAIRE','SCAN',1,'NONE',1,0,'','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','2023-08-30 11:28:53.101',NULL,'2023-08-30 11:32:40.642','2023-08-30 09:32:40.642','2023-08-30 11:32:40.650'),('a3974508-4714-11ee-bfe6-a86daa000811',196,'c7a8830f-4713-11ee-bfe6-a86daa000811','MANDIBULE','SCAN',1,'NONE',2,0,'{\"referenceScanId\":\"f5703840-4713-11ee-bfe6-a86daa000811\"}','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','2023-08-30 11:07:26.458',NULL,'2023-08-30 11:08:41.449','2023-08-30 09:08:41.449','2023-08-30 11:08:41.456'),('b5ac3d30-4712-11ee-bfe6-a86daa000811',196,'28b9b3ca-4711-11ee-bfe6-a86daa000811','MANDIBULE','SCAN',1,'NONE',2,0,'{\"referenceScanId\":\"64dba54e-4712-11ee-bfe6-a86daa000811\"}','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','2023-08-30 10:53:37.801',NULL,'2023-08-30 10:55:14.729','2023-08-30 08:55:14.730','2023-08-30 10:55:14.735'),('c98c9fb7-4713-11ee-bfe6-a86daa000811',196,'c7a8830f-4713-11ee-bfe6-a86daa000811','MAXILLAIRE','PRE_PREPARATION',1,'NONE',1,0,'','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','2023-08-30 11:01:20.645',NULL,'2023-08-30 11:03:33.926','2023-08-30 09:03:33.926','2023-08-30 11:03:33.932'),('c9e996cb-4716-11ee-bfe6-a86daa000811',196,'c589e5b6-4716-11ee-bfe6-a86daa000811','MAXILLAIRE','SCAN',1,'NONE',1,0,'','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','2023-08-30 11:22:49.744',NULL,'2023-08-30 11:27:01.195','2023-08-30 09:27:01.196','2023-08-30 11:27:01.201'),('cf8c0f8e-4717-11ee-bfe6-a86daa000811',196,'a0f77fda-4717-11ee-bfe6-a86daa000811','MANDIBULE','SCAN',1,'NONE',1,0,'','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','2023-08-30 11:30:08.694',NULL,'2023-08-30 11:32:40.697','2023-08-30 09:32:40.697','2023-08-30 11:32:40.704'),('d709480e-4714-11ee-bfe6-a86daa000811',196,'c7a8830f-4713-11ee-bfe6-a86daa000811','MANDIBULE','SCANBODY',1,'NONE',3,0,'{\"referenceScanId\":\"a3974508-4714-11ee-bfe6-a86daa000811\"}','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','2023-08-30 11:08:52.769',NULL,'2023-08-30 11:10:24.447','2023-08-30 09:10:24.447','2023-08-30 11:11:14.731'),('ddb8b416-4709-11ee-bfe6-a86daa000811',196,'9411ecbc-4709-11ee-bfe6-a86daa000811','MANDIBULE','SCAN',1,'NONE',1,0,'','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','2023-08-30 09:50:19.521',NULL,'2023-08-30 09:52:12.259','2023-08-30 07:52:12.260','2023-08-30 09:52:12.268'),('de5dfda1-4711-11ee-bfe6-a86daa000811',196,'28b9b3ca-4711-11ee-bfe6-a86daa000811','MAXILLAIRE','SCANBODY',1,'NONE',3,0,'{\"referenceScanId\":\"79ca2646-4711-11ee-bfe6-a86daa000811\"}','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','2023-08-30 10:47:36.578',NULL,'2023-08-30 10:50:55.601','2023-08-30 08:50:55.601','2023-08-30 10:50:55.610'),('f4877908-4712-11ee-bfe6-a86daa000811',196,'28b9b3ca-4711-11ee-bfe6-a86daa000811','MANDIBULE','SCANBODY',1,'NONE',3,0,'{\"referenceScanId\":\"b5ac3d30-4712-11ee-bfe6-a86daa000811\"}','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','2023-08-30 10:55:23.256',NULL,'2023-08-30 10:57:30.167','2023-08-30 08:57:30.168','2023-08-30 10:57:30.178'),('f5703840-4713-11ee-bfe6-a86daa000811',196,'c7a8830f-4713-11ee-bfe6-a86daa000811','MANDIBULE','PRE_PREPARATION',1,'NONE',1,0,'','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','2023-08-30 11:02:34.279',NULL,'2023-08-30 11:12:23.826','2023-08-30 09:12:23.826','2023-08-30 11:12:23.834'),('fcb9257d-4716-11ee-bfe6-a86daa000811',196,'c589e5b6-4716-11ee-bfe6-a86daa000811','MANDIBULE','SCAN',1,'NONE',1,0,'','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','39bdf5a7-54ab-41f0-96fa-df9fa92bcce7','2023-08-30 11:24:14.991',NULL,'2023-08-30 11:26:56.289','2023-08-30 09:26:56.290','2023-08-30 11:26:56.294');
/*!40000 ALTER TABLE `Scan` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ScanFile`
--

DROP TABLE IF EXISTS `ScanFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ScanFile` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `scanId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('MODEL','SNAPSHOT','SCREENSHOT','LIFI','LIFIMETA') NOT NULL,
  PRIMARY KEY (`scanId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `ScanFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ScanFile_ibfk_2` FOREIGN KEY (`scanId`) REFERENCES `Scan` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ScanFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ScanFile`
--

LOCK TABLES `ScanFile` WRITE;
/*!40000 ALTER TABLE `ScanFile` DISABLE KEYS */;
INSERT INTO `ScanFile` VALUES (196,'038d534c-4718-11ee-bfe6-a86daa000811','1b7fb9c1-4718-11ee-bfe6-a86daa000811','MODEL'),(196,'038d534c-4718-11ee-bfe6-a86daa000811','1b7fd125-4718-11ee-bfe6-a86daa000811','SNAPSHOT'),(196,'10ba483c-4715-11ee-bfe6-a86daa000811','2b814969-4715-11ee-bfe6-a86daa000811','MODEL'),(196,'10ba483c-4715-11ee-bfe6-a86daa000811','2b817103-4715-11ee-bfe6-a86daa000811','SNAPSHOT'),(196,'19ab91b2-4717-11ee-bfe6-a86daa000811','3ada50a1-4717-11ee-bfe6-a86daa000811','MODEL'),(196,'19ab91b2-4717-11ee-bfe6-a86daa000811','3ada6922-4717-11ee-bfe6-a86daa000811','SNAPSHOT'),(196,'22084bd2-4714-11ee-bfe6-a86daa000811','52114939-4714-11ee-bfe6-a86daa000811','MODEL'),(196,'22084bd2-4714-11ee-bfe6-a86daa000811','52115f0c-4714-11ee-bfe6-a86daa000811','SNAPSHOT'),(196,'22084bd2-4714-11ee-bfe6-a86daa000811','d4d5e74d-4714-11ee-bfe6-a86daa000811','LIFI'),(196,'22084bd2-4714-11ee-bfe6-a86daa000811','d4d5eac4-4714-11ee-bfe6-a86daa000811','LIFIMETA'),(196,'29e45423-470a-11ee-bfe6-a86daa000811','473cc8ba-470a-11ee-bfe6-a86daa000811','MODEL'),(196,'29e45423-470a-11ee-bfe6-a86daa000811','473cddfc-470a-11ee-bfe6-a86daa000811','SNAPSHOT'),(196,'29fbd842-4711-11ee-bfe6-a86daa000811','5c5e63c7-4712-11ee-bfe6-a86daa000811','LIFI'),(196,'29fbd842-4711-11ee-bfe6-a86daa000811','5c5e6923-4712-11ee-bfe6-a86daa000811','LIFIMETA'),(196,'29fbd842-4711-11ee-bfe6-a86daa000811','601256c0-4711-11ee-bfe6-a86daa000811','MODEL'),(196,'29fbd842-4711-11ee-bfe6-a86daa000811','60126fc7-4711-11ee-bfe6-a86daa000811','SNAPSHOT'),(196,'57bf381a-4714-11ee-bfe6-a86daa000811','a0a9b3c6-4714-11ee-bfe6-a86daa000811','MODEL'),(196,'57bf381a-4714-11ee-bfe6-a86daa000811','a0a9dea8-4714-11ee-bfe6-a86daa000811','SNAPSHOT'),(196,'64dba54e-4712-11ee-bfe6-a86daa000811','8c22f707-4712-11ee-bfe6-a86daa000811','MODEL'),(196,'64dba54e-4712-11ee-bfe6-a86daa000811','8c230d37-4712-11ee-bfe6-a86daa000811','SNAPSHOT'),(196,'64dba54e-4712-11ee-bfe6-a86daa000811','ebcaf2e8-4712-11ee-bfe6-a86daa000811','LIFI'),(196,'64dba54e-4712-11ee-bfe6-a86daa000811','ebcaf8ff-4712-11ee-bfe6-a86daa000811','LIFIMETA'),(196,'79ca2646-4711-11ee-bfe6-a86daa000811','5fcd3ac4-4712-11ee-bfe6-a86daa000811','LIFI'),(196,'79ca2646-4711-11ee-bfe6-a86daa000811','5fcd3ff6-4712-11ee-bfe6-a86daa000811','LIFIMETA'),(196,'79ca2646-4711-11ee-bfe6-a86daa000811','79ca4b91-4711-11ee-bfe6-a86daa000811','MODEL'),(196,'79ca2646-4711-11ee-bfe6-a86daa000811','79d2c7d2-4711-11ee-bfe6-a86daa000811','SNAPSHOT'),(196,'79ca2646-4711-11ee-bfe6-a86daa000811','840d6721-4711-11ee-bfe6-a86daa000811','MODEL'),(196,'79ca2646-4711-11ee-bfe6-a86daa000811','b801ed81-4711-11ee-bfe6-a86daa000811','MODEL'),(196,'79ca2646-4711-11ee-bfe6-a86daa000811','b802029b-4711-11ee-bfe6-a86daa000811','SNAPSHOT'),(196,'8fb5e92d-4712-11ee-bfe6-a86daa000811','b2229610-4712-11ee-bfe6-a86daa000811','MODEL'),(196,'8fb5e92d-4712-11ee-bfe6-a86daa000811','b222b05b-4712-11ee-bfe6-a86daa000811','SNAPSHOT'),(196,'978d31c9-4709-11ee-bfe6-a86daa000811','d5425abd-4709-11ee-bfe6-a86daa000811','MODEL'),(196,'978d31c9-4709-11ee-bfe6-a86daa000811','d54273bc-4709-11ee-bfe6-a86daa000811','SNAPSHOT'),(196,'978d31c9-4709-11ee-bfe6-a86daa000811','dbed38ba-4709-11ee-bfe6-a86daa000811','LIFI'),(196,'978d31c9-4709-11ee-bfe6-a86daa000811','dbed3f00-4709-11ee-bfe6-a86daa000811','LIFIMETA'),(196,'a27d60d7-4717-11ee-bfe6-a86daa000811','014de352-4718-11ee-bfe6-a86daa000811','LIFI'),(196,'a27d60d7-4717-11ee-bfe6-a86daa000811','014dea28-4718-11ee-bfe6-a86daa000811','LIFIMETA'),(196,'a27d60d7-4717-11ee-bfe6-a86daa000811','bb514d27-4717-11ee-bfe6-a86daa000811','MODEL'),(196,'a27d60d7-4717-11ee-bfe6-a86daa000811','bb517432-4717-11ee-bfe6-a86daa000811','SNAPSHOT'),(196,'a27d60d7-4717-11ee-bfe6-a86daa000811','ccfc6b34-4717-11ee-bfe6-a86daa000811','LIFI'),(196,'a27d60d7-4717-11ee-bfe6-a86daa000811','ccfc70eb-4717-11ee-bfe6-a86daa000811','LIFIMETA'),(196,'a3974508-4714-11ee-bfe6-a86daa000811','c927afc9-4714-11ee-bfe6-a86daa000811','MODEL'),(196,'a3974508-4714-11ee-bfe6-a86daa000811','c927c536-4714-11ee-bfe6-a86daa000811','SNAPSHOT'),(196,'a3974508-4714-11ee-bfe6-a86daa000811','d04975f8-4714-11ee-bfe6-a86daa000811','LIFI'),(196,'a3974508-4714-11ee-bfe6-a86daa000811','d0497b98-4714-11ee-bfe6-a86daa000811','LIFIMETA'),(196,'b5ac3d30-4712-11ee-bfe6-a86daa000811','b5ac644f-4712-11ee-bfe6-a86daa000811','MODEL'),(196,'b5ac3d30-4712-11ee-bfe6-a86daa000811','b5b3751e-4712-11ee-bfe6-a86daa000811','SNAPSHOT'),(196,'b5ac3d30-4712-11ee-bfe6-a86daa000811','bfb50ded-4712-11ee-bfe6-a86daa000811','MODEL'),(196,'b5ac3d30-4712-11ee-bfe6-a86daa000811','e45fa630-4712-11ee-bfe6-a86daa000811','MODEL'),(196,'b5ac3d30-4712-11ee-bfe6-a86daa000811','e45fbb59-4712-11ee-bfe6-a86daa000811','SNAPSHOT'),(196,'b5ac3d30-4712-11ee-bfe6-a86daa000811','ef71f4e5-4712-11ee-bfe6-a86daa000811','LIFI'),(196,'b5ac3d30-4712-11ee-bfe6-a86daa000811','ef71f80d-4712-11ee-bfe6-a86daa000811','LIFIMETA'),(196,'c98c9fb7-4713-11ee-bfe6-a86daa000811','18fd2b01-4714-11ee-bfe6-a86daa000811','LIFI'),(196,'c98c9fb7-4713-11ee-bfe6-a86daa000811','18fd31b8-4714-11ee-bfe6-a86daa000811','LIFIMETA'),(196,'c98c9fb7-4713-11ee-bfe6-a86daa000811','ef5efa77-4713-11ee-bfe6-a86daa000811','MODEL'),(196,'c98c9fb7-4713-11ee-bfe6-a86daa000811','ef5f1152-4713-11ee-bfe6-a86daa000811','SNAPSHOT'),(196,'c9e996cb-4716-11ee-bfe6-a86daa000811','5fc0dd4c-4717-11ee-bfe6-a86daa000811','SCREENSHOT'),(196,'c9e996cb-4716-11ee-bfe6-a86daa000811','f12116be-4716-11ee-bfe6-a86daa000811','MODEL'),(196,'c9e996cb-4716-11ee-bfe6-a86daa000811','f1212eaf-4716-11ee-bfe6-a86daa000811','SNAPSHOT'),(196,'c9e996cb-4716-11ee-bfe6-a86daa000811','fa4a5d2b-4716-11ee-bfe6-a86daa000811','LIFI'),(196,'c9e996cb-4716-11ee-bfe6-a86daa000811','fa4a653e-4716-11ee-bfe6-a86daa000811','LIFIMETA'),(196,'cf8c0f8e-4717-11ee-bfe6-a86daa000811','f147aef1-4717-11ee-bfe6-a86daa000811','MODEL'),(196,'cf8c0f8e-4717-11ee-bfe6-a86daa000811','f147c789-4717-11ee-bfe6-a86daa000811','SNAPSHOT'),(196,'cf8c0f8e-4717-11ee-bfe6-a86daa000811','f4fad758-4717-11ee-bfe6-a86daa000811','LIFI'),(196,'cf8c0f8e-4717-11ee-bfe6-a86daa000811','f4fadf46-4717-11ee-bfe6-a86daa000811','LIFIMETA'),(196,'cf8c0f8e-4717-11ee-bfe6-a86daa000811','fd53a313-4717-11ee-bfe6-a86daa000811','LIFI'),(196,'cf8c0f8e-4717-11ee-bfe6-a86daa000811','fd53aa08-4717-11ee-bfe6-a86daa000811','LIFIMETA'),(196,'d709480e-4714-11ee-bfe6-a86daa000811','0d4d5214-4715-11ee-bfe6-a86daa000811','MODEL'),(196,'d709480e-4714-11ee-bfe6-a86daa000811','0d4d7785-4715-11ee-bfe6-a86daa000811','SNAPSHOT'),(196,'ddb8b416-4709-11ee-bfe6-a86daa000811','0e658e5a-470a-11ee-bfe6-a86daa000811','MODEL'),(196,'ddb8b416-4709-11ee-bfe6-a86daa000811','0e65a514-470a-11ee-bfe6-a86daa000811','SNAPSHOT'),(196,'ddb8b416-4709-11ee-bfe6-a86daa000811','20eaffbb-470a-11ee-bfe6-a86daa000811','LIFI'),(196,'ddb8b416-4709-11ee-bfe6-a86daa000811','20eb0492-470a-11ee-bfe6-a86daa000811','LIFIMETA'),(196,'de5dfda1-4711-11ee-bfe6-a86daa000811','544f0e3a-4712-11ee-bfe6-a86daa000811','MODEL'),(196,'de5dfda1-4711-11ee-bfe6-a86daa000811','544f3fbb-4712-11ee-bfe6-a86daa000811','SNAPSHOT'),(196,'de5dfda1-4711-11ee-bfe6-a86daa000811','de5e212b-4711-11ee-bfe6-a86daa000811','MODEL'),(196,'de5dfda1-4711-11ee-bfe6-a86daa000811','de663fe2-4711-11ee-bfe6-a86daa000811','SNAPSHOT'),(196,'de5dfda1-4711-11ee-bfe6-a86daa000811','e73e82b6-4711-11ee-bfe6-a86daa000811','MODEL'),(196,'f4877908-4712-11ee-bfe6-a86daa000811','05dbe774-4713-11ee-bfe6-a86daa000811','MODEL'),(196,'f4877908-4712-11ee-bfe6-a86daa000811','3fb541ba-4713-11ee-bfe6-a86daa000811','MODEL'),(196,'f4877908-4712-11ee-bfe6-a86daa000811','3fb55e57-4713-11ee-bfe6-a86daa000811','SNAPSHOT'),(196,'f4877908-4712-11ee-bfe6-a86daa000811','f4879c4b-4712-11ee-bfe6-a86daa000811','MODEL'),(196,'f4877908-4712-11ee-bfe6-a86daa000811','f48e421b-4712-11ee-bfe6-a86daa000811','SNAPSHOT'),(196,'f4877908-4712-11ee-bfe6-a86daa000811','f48e5405-4712-11ee-bfe6-a86daa000811','LIFI'),(196,'f4877908-4712-11ee-bfe6-a86daa000811','f48e616a-4712-11ee-bfe6-a86daa000811','LIFIMETA'),(196,'f5703840-4713-11ee-bfe6-a86daa000811','13054d2a-4714-11ee-bfe6-a86daa000811','MODEL'),(196,'f5703840-4713-11ee-bfe6-a86daa000811','1305657a-4714-11ee-bfe6-a86daa000811','SNAPSHOT'),(196,'f5703840-4713-11ee-bfe6-a86daa000811','54d5b99b-4715-11ee-bfe6-a86daa000811','LIFI'),(196,'f5703840-4713-11ee-bfe6-a86daa000811','54d5bec8-4715-11ee-bfe6-a86daa000811','LIFIMETA'),(196,'fcb9257d-4716-11ee-bfe6-a86daa000811','14f1ba3f-4717-11ee-bfe6-a86daa000811','MODEL'),(196,'fcb9257d-4716-11ee-bfe6-a86daa000811','14f1d27f-4717-11ee-bfe6-a86daa000811','SNAPSHOT'),(196,'fcb9257d-4716-11ee-bfe6-a86daa000811','5cd37d0e-4717-11ee-bfe6-a86daa000811','SCREENSHOT');
/*!40000 ALTER TABLE `ScanFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SentAttachment`
--

DROP TABLE IF EXISTS `SentAttachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SentAttachment` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `sentMessageId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  PRIMARY KEY (`sentMessageId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `SentAttachment_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `SentAttachment_ibfk_2` FOREIGN KEY (`sentMessageId`) REFERENCES `SentMessage` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `SentAttachment_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SentAttachment`
--

LOCK TABLES `SentAttachment` WRITE;
/*!40000 ALTER TABLE `SentAttachment` DISABLE KEYS */;
INSERT INTO `SentAttachment` VALUES (196,'434f208f-4718-11ee-bfe6-a86daa000811','014de352-4718-11ee-bfe6-a86daa000811'),(196,'434f208f-4718-11ee-bfe6-a86daa000811','014dea28-4718-11ee-bfe6-a86daa000811'),(196,'434f208f-4718-11ee-bfe6-a86daa000811','1b7fb9c1-4718-11ee-bfe6-a86daa000811'),(196,'434f208f-4718-11ee-bfe6-a86daa000811','1b7fd125-4718-11ee-bfe6-a86daa000811'),(196,'434f208f-4718-11ee-bfe6-a86daa000811','1fdc68df-4718-11ee-bfe6-a86daa000811'),(196,'434f208f-4718-11ee-bfe6-a86daa000811','1ff793b5-4718-11ee-bfe6-a86daa000811'),(196,'434f208f-4718-11ee-bfe6-a86daa000811','1ff79a2c-4718-11ee-bfe6-a86daa000811'),(196,'434f208f-4718-11ee-bfe6-a86daa000811','1ff7ece3-4718-11ee-bfe6-a86daa000811'),(196,'434f208f-4718-11ee-bfe6-a86daa000811','1ff7f30d-4718-11ee-bfe6-a86daa000811'),(196,'434f208f-4718-11ee-bfe6-a86daa000811','1ff833ca-4718-11ee-bfe6-a86daa000811'),(196,'434f208f-4718-11ee-bfe6-a86daa000811','2013924f-4718-11ee-bfe6-a86daa000811'),(196,'434f208f-4718-11ee-bfe6-a86daa000811','201398ef-4718-11ee-bfe6-a86daa000811'),(196,'434f208f-4718-11ee-bfe6-a86daa000811','2013d4ed-4718-11ee-bfe6-a86daa000811'),(196,'434f208f-4718-11ee-bfe6-a86daa000811','2013d727-4718-11ee-bfe6-a86daa000811'),(196,'434f208f-4718-11ee-bfe6-a86daa000811','20507804-4718-11ee-bfe6-a86daa000811'),(196,'434f208f-4718-11ee-bfe6-a86daa000811','428f2cc6-4718-11ee-bfe6-a86daa000811'),(196,'434f208f-4718-11ee-bfe6-a86daa000811','42ed82b0-4718-11ee-bfe6-a86daa000811'),(196,'434f208f-4718-11ee-bfe6-a86daa000811','bb514d27-4717-11ee-bfe6-a86daa000811'),(196,'434f208f-4718-11ee-bfe6-a86daa000811','bb517432-4717-11ee-bfe6-a86daa000811'),(196,'434f208f-4718-11ee-bfe6-a86daa000811','ccfc6b34-4717-11ee-bfe6-a86daa000811'),(196,'434f208f-4718-11ee-bfe6-a86daa000811','ccfc70eb-4717-11ee-bfe6-a86daa000811'),(196,'434f208f-4718-11ee-bfe6-a86daa000811','f147aef1-4717-11ee-bfe6-a86daa000811'),(196,'434f208f-4718-11ee-bfe6-a86daa000811','f147c789-4717-11ee-bfe6-a86daa000811'),(196,'434f208f-4718-11ee-bfe6-a86daa000811','f4fad758-4717-11ee-bfe6-a86daa000811'),(196,'434f208f-4718-11ee-bfe6-a86daa000811','f4fadf46-4717-11ee-bfe6-a86daa000811'),(196,'434f208f-4718-11ee-bfe6-a86daa000811','fd53a313-4717-11ee-bfe6-a86daa000811'),(196,'434f208f-4718-11ee-bfe6-a86daa000811','fd53aa08-4717-11ee-bfe6-a86daa000811'),(196,'5fdfa238-4715-11ee-bfe6-a86daa000811','39ab1d77-4715-11ee-bfe6-a86daa000811'),(196,'5fdfa238-4715-11ee-bfe6-a86daa000811','39c6835e-4715-11ee-bfe6-a86daa000811'),(196,'5fdfa238-4715-11ee-bfe6-a86daa000811','39c689b6-4715-11ee-bfe6-a86daa000811'),(196,'5fdfa238-4715-11ee-bfe6-a86daa000811','39c6e5de-4715-11ee-bfe6-a86daa000811'),(196,'5fdfa238-4715-11ee-bfe6-a86daa000811','3a16950d-4715-11ee-bfe6-a86daa000811'),(196,'5fdfa238-4715-11ee-bfe6-a86daa000811','3a30cc69-4715-11ee-bfe6-a86daa000811'),(196,'5fdfa238-4715-11ee-bfe6-a86daa000811','3a30d21c-4715-11ee-bfe6-a86daa000811'),(196,'5fdfa238-4715-11ee-bfe6-a86daa000811','3a5d4663-4715-11ee-bfe6-a86daa000811'),(196,'5fdfa238-4715-11ee-bfe6-a86daa000811','3a753395-4715-11ee-bfe6-a86daa000811'),(196,'5fdfa238-4715-11ee-bfe6-a86daa000811','3a75389e-4715-11ee-bfe6-a86daa000811'),(196,'5fdfa238-4715-11ee-bfe6-a86daa000811','3aab0524-4715-11ee-bfe6-a86daa000811'),(196,'5fdfa238-4715-11ee-bfe6-a86daa000811','3ae88db9-4715-11ee-bfe6-a86daa000811'),(196,'5fdfa238-4715-11ee-bfe6-a86daa000811','3ba46ed3-4715-11ee-bfe6-a86daa000811'),(196,'5fdfa238-4715-11ee-bfe6-a86daa000811','54d9092d-4715-11ee-bfe6-a86daa000811'),(196,'5fdfa238-4715-11ee-bfe6-a86daa000811','54d90bb3-4715-11ee-bfe6-a86daa000811'),(196,'5fdfa238-4715-11ee-bfe6-a86daa000811','5f7a5af2-4715-11ee-bfe6-a86daa000811'),(196,'6aa60301-4717-11ee-bfe6-a86daa000811','14f1ba3f-4717-11ee-bfe6-a86daa000811'),(196,'6aa60301-4717-11ee-bfe6-a86daa000811','14f1d27f-4717-11ee-bfe6-a86daa000811'),(196,'6aa60301-4717-11ee-bfe6-a86daa000811','3ada50a1-4717-11ee-bfe6-a86daa000811'),(196,'6aa60301-4717-11ee-bfe6-a86daa000811','3ada6922-4717-11ee-bfe6-a86daa000811'),(196,'6aa60301-4717-11ee-bfe6-a86daa000811','4f674de1-4717-11ee-bfe6-a86daa000811'),(196,'6aa60301-4717-11ee-bfe6-a86daa000811','4f826c6b-4717-11ee-bfe6-a86daa000811'),(196,'6aa60301-4717-11ee-bfe6-a86daa000811','4f8270ca-4717-11ee-bfe6-a86daa000811'),(196,'6aa60301-4717-11ee-bfe6-a86daa000811','4f82ccb6-4717-11ee-bfe6-a86daa000811'),(196,'6aa60301-4717-11ee-bfe6-a86daa000811','4fd6f395-4717-11ee-bfe6-a86daa000811'),(196,'6aa60301-4717-11ee-bfe6-a86daa000811','5cd37d0e-4717-11ee-bfe6-a86daa000811'),(196,'6aa60301-4717-11ee-bfe6-a86daa000811','5fc0dd4c-4717-11ee-bfe6-a86daa000811'),(196,'6aa60301-4717-11ee-bfe6-a86daa000811','6a4033f8-4717-11ee-bfe6-a86daa000811'),(196,'6aa60301-4717-11ee-bfe6-a86daa000811','f12116be-4716-11ee-bfe6-a86daa000811'),(196,'6aa60301-4717-11ee-bfe6-a86daa000811','f1212eaf-4716-11ee-bfe6-a86daa000811'),(196,'6aa60301-4717-11ee-bfe6-a86daa000811','fa4a5d2b-4716-11ee-bfe6-a86daa000811'),(196,'6aa60301-4717-11ee-bfe6-a86daa000811','fa4a653e-4716-11ee-bfe6-a86daa000811'),(196,'6e429d26-4715-11ee-bfe6-a86daa000811','3fb541ba-4713-11ee-bfe6-a86daa000811'),(196,'6e429d26-4715-11ee-bfe6-a86daa000811','3fb55e57-4713-11ee-bfe6-a86daa000811'),(196,'6e429d26-4715-11ee-bfe6-a86daa000811','4f2156ce-4713-11ee-bfe6-a86daa000811'),(196,'6e429d26-4715-11ee-bfe6-a86daa000811','4f4b7bb9-4713-11ee-bfe6-a86daa000811'),(196,'6e429d26-4715-11ee-bfe6-a86daa000811','4f4b8104-4713-11ee-bfe6-a86daa000811'),(196,'6e429d26-4715-11ee-bfe6-a86daa000811','4f4bfc45-4713-11ee-bfe6-a86daa000811'),(196,'6e429d26-4715-11ee-bfe6-a86daa000811','4f6bdc64-4713-11ee-bfe6-a86daa000811'),(196,'6e429d26-4715-11ee-bfe6-a86daa000811','4f6bdff0-4713-11ee-bfe6-a86daa000811'),(196,'6e429d26-4715-11ee-bfe6-a86daa000811','4fb4073e-4713-11ee-bfe6-a86daa000811'),(196,'6e429d26-4715-11ee-bfe6-a86daa000811','544f0e3a-4712-11ee-bfe6-a86daa000811'),(196,'6e429d26-4715-11ee-bfe6-a86daa000811','544f3fbb-4712-11ee-bfe6-a86daa000811'),(196,'6e429d26-4715-11ee-bfe6-a86daa000811','557f540b-4713-11ee-bfe6-a86daa000811'),(196,'6e429d26-4715-11ee-bfe6-a86daa000811','559ab1a3-4713-11ee-bfe6-a86daa000811'),(196,'6e429d26-4715-11ee-bfe6-a86daa000811','559ab8f8-4713-11ee-bfe6-a86daa000811'),(196,'6e429d26-4715-11ee-bfe6-a86daa000811','5998ed51-4713-11ee-bfe6-a86daa000811'),(196,'6e429d26-4715-11ee-bfe6-a86daa000811','5c5e63c7-4712-11ee-bfe6-a86daa000811'),(196,'6e429d26-4715-11ee-bfe6-a86daa000811','5c5e6923-4712-11ee-bfe6-a86daa000811'),(196,'6e429d26-4715-11ee-bfe6-a86daa000811','5f183485-4713-11ee-bfe6-a86daa000811'),(196,'6e429d26-4715-11ee-bfe6-a86daa000811','5f3b3763-4713-11ee-bfe6-a86daa000811'),(196,'6e429d26-4715-11ee-bfe6-a86daa000811','5f3b3dac-4713-11ee-bfe6-a86daa000811'),(196,'6e429d26-4715-11ee-bfe6-a86daa000811','5fcd3ac4-4712-11ee-bfe6-a86daa000811'),(196,'6e429d26-4715-11ee-bfe6-a86daa000811','5fcd3ff6-4712-11ee-bfe6-a86daa000811'),(196,'6e429d26-4715-11ee-bfe6-a86daa000811','601256c0-4711-11ee-bfe6-a86daa000811'),(196,'6e429d26-4715-11ee-bfe6-a86daa000811','60126fc7-4711-11ee-bfe6-a86daa000811'),(196,'6e429d26-4715-11ee-bfe6-a86daa000811','6557d3c6-4713-11ee-bfe6-a86daa000811'),(196,'6e429d26-4715-11ee-bfe6-a86daa000811','6dded3e3-4715-11ee-bfe6-a86daa000811'),(196,'6e429d26-4715-11ee-bfe6-a86daa000811','8c22f707-4712-11ee-bfe6-a86daa000811'),(196,'6e429d26-4715-11ee-bfe6-a86daa000811','8c230d37-4712-11ee-bfe6-a86daa000811'),(196,'6e429d26-4715-11ee-bfe6-a86daa000811','b2229610-4712-11ee-bfe6-a86daa000811'),(196,'6e429d26-4715-11ee-bfe6-a86daa000811','b222b05b-4712-11ee-bfe6-a86daa000811'),(196,'6e429d26-4715-11ee-bfe6-a86daa000811','b801ed81-4711-11ee-bfe6-a86daa000811'),(196,'6e429d26-4715-11ee-bfe6-a86daa000811','b802029b-4711-11ee-bfe6-a86daa000811'),(196,'6e429d26-4715-11ee-bfe6-a86daa000811','e45fa630-4712-11ee-bfe6-a86daa000811'),(196,'6e429d26-4715-11ee-bfe6-a86daa000811','e45fbb59-4712-11ee-bfe6-a86daa000811'),(196,'6e429d26-4715-11ee-bfe6-a86daa000811','ebcaf2e8-4712-11ee-bfe6-a86daa000811'),(196,'6e429d26-4715-11ee-bfe6-a86daa000811','ebcaf8ff-4712-11ee-bfe6-a86daa000811'),(196,'6e429d26-4715-11ee-bfe6-a86daa000811','ef71f4e5-4712-11ee-bfe6-a86daa000811'),(196,'6e429d26-4715-11ee-bfe6-a86daa000811','ef71f80d-4712-11ee-bfe6-a86daa000811'),(196,'7bfe5eb6-4713-11ee-bfe6-a86daa000811','3fb541ba-4713-11ee-bfe6-a86daa000811'),(196,'7bfe5eb6-4713-11ee-bfe6-a86daa000811','3fb55e57-4713-11ee-bfe6-a86daa000811'),(196,'7bfe5eb6-4713-11ee-bfe6-a86daa000811','4f2156ce-4713-11ee-bfe6-a86daa000811'),(196,'7bfe5eb6-4713-11ee-bfe6-a86daa000811','4f4b7bb9-4713-11ee-bfe6-a86daa000811'),(196,'7bfe5eb6-4713-11ee-bfe6-a86daa000811','4f4b8104-4713-11ee-bfe6-a86daa000811'),(196,'7bfe5eb6-4713-11ee-bfe6-a86daa000811','4f4bfc45-4713-11ee-bfe6-a86daa000811'),(196,'7bfe5eb6-4713-11ee-bfe6-a86daa000811','4f6bdc64-4713-11ee-bfe6-a86daa000811'),(196,'7bfe5eb6-4713-11ee-bfe6-a86daa000811','4f6bdff0-4713-11ee-bfe6-a86daa000811'),(196,'7bfe5eb6-4713-11ee-bfe6-a86daa000811','4fb4073e-4713-11ee-bfe6-a86daa000811'),(196,'7bfe5eb6-4713-11ee-bfe6-a86daa000811','544f0e3a-4712-11ee-bfe6-a86daa000811'),(196,'7bfe5eb6-4713-11ee-bfe6-a86daa000811','544f3fbb-4712-11ee-bfe6-a86daa000811'),(196,'7bfe5eb6-4713-11ee-bfe6-a86daa000811','557f540b-4713-11ee-bfe6-a86daa000811'),(196,'7bfe5eb6-4713-11ee-bfe6-a86daa000811','559ab1a3-4713-11ee-bfe6-a86daa000811'),(196,'7bfe5eb6-4713-11ee-bfe6-a86daa000811','559ab8f8-4713-11ee-bfe6-a86daa000811'),(196,'7bfe5eb6-4713-11ee-bfe6-a86daa000811','5998ed51-4713-11ee-bfe6-a86daa000811'),(196,'7bfe5eb6-4713-11ee-bfe6-a86daa000811','5c5e63c7-4712-11ee-bfe6-a86daa000811'),(196,'7bfe5eb6-4713-11ee-bfe6-a86daa000811','5c5e6923-4712-11ee-bfe6-a86daa000811'),(196,'7bfe5eb6-4713-11ee-bfe6-a86daa000811','5f183485-4713-11ee-bfe6-a86daa000811'),(196,'7bfe5eb6-4713-11ee-bfe6-a86daa000811','5f3b3763-4713-11ee-bfe6-a86daa000811'),(196,'7bfe5eb6-4713-11ee-bfe6-a86daa000811','5f3b3dac-4713-11ee-bfe6-a86daa000811'),(196,'7bfe5eb6-4713-11ee-bfe6-a86daa000811','5fcd3ac4-4712-11ee-bfe6-a86daa000811'),(196,'7bfe5eb6-4713-11ee-bfe6-a86daa000811','5fcd3ff6-4712-11ee-bfe6-a86daa000811'),(196,'7bfe5eb6-4713-11ee-bfe6-a86daa000811','601256c0-4711-11ee-bfe6-a86daa000811'),(196,'7bfe5eb6-4713-11ee-bfe6-a86daa000811','60126fc7-4711-11ee-bfe6-a86daa000811'),(196,'7bfe5eb6-4713-11ee-bfe6-a86daa000811','6557d3c6-4713-11ee-bfe6-a86daa000811'),(196,'7bfe5eb6-4713-11ee-bfe6-a86daa000811','7b984e54-4713-11ee-bfe6-a86daa000811'),(196,'7bfe5eb6-4713-11ee-bfe6-a86daa000811','8c22f707-4712-11ee-bfe6-a86daa000811'),(196,'7bfe5eb6-4713-11ee-bfe6-a86daa000811','8c230d37-4712-11ee-bfe6-a86daa000811'),(196,'7bfe5eb6-4713-11ee-bfe6-a86daa000811','b2229610-4712-11ee-bfe6-a86daa000811'),(196,'7bfe5eb6-4713-11ee-bfe6-a86daa000811','b222b05b-4712-11ee-bfe6-a86daa000811'),(196,'7bfe5eb6-4713-11ee-bfe6-a86daa000811','b801ed81-4711-11ee-bfe6-a86daa000811'),(196,'7bfe5eb6-4713-11ee-bfe6-a86daa000811','b802029b-4711-11ee-bfe6-a86daa000811'),(196,'7bfe5eb6-4713-11ee-bfe6-a86daa000811','e45fa630-4712-11ee-bfe6-a86daa000811'),(196,'7bfe5eb6-4713-11ee-bfe6-a86daa000811','e45fbb59-4712-11ee-bfe6-a86daa000811'),(196,'7bfe5eb6-4713-11ee-bfe6-a86daa000811','ebcaf2e8-4712-11ee-bfe6-a86daa000811'),(196,'7bfe5eb6-4713-11ee-bfe6-a86daa000811','ebcaf8ff-4712-11ee-bfe6-a86daa000811'),(196,'7bfe5eb6-4713-11ee-bfe6-a86daa000811','ef71f4e5-4712-11ee-bfe6-a86daa000811'),(196,'7bfe5eb6-4713-11ee-bfe6-a86daa000811','ef71f80d-4712-11ee-bfe6-a86daa000811'),(196,'ad0189dd-4710-11ee-bfe6-a86daa000811','0e658e5a-470a-11ee-bfe6-a86daa000811'),(196,'ad0189dd-4710-11ee-bfe6-a86daa000811','0e65a514-470a-11ee-bfe6-a86daa000811'),(196,'ad0189dd-4710-11ee-bfe6-a86daa000811','20eaffbb-470a-11ee-bfe6-a86daa000811'),(196,'ad0189dd-4710-11ee-bfe6-a86daa000811','20eb0492-470a-11ee-bfe6-a86daa000811'),(196,'ad0189dd-4710-11ee-bfe6-a86daa000811','473cc8ba-470a-11ee-bfe6-a86daa000811'),(196,'ad0189dd-4710-11ee-bfe6-a86daa000811','473cddfc-470a-11ee-bfe6-a86daa000811'),(196,'ad0189dd-4710-11ee-bfe6-a86daa000811','4f51891d-470a-11ee-bfe6-a86daa000811'),(196,'ad0189dd-4710-11ee-bfe6-a86daa000811','4f7c4187-470a-11ee-bfe6-a86daa000811'),(196,'ad0189dd-4710-11ee-bfe6-a86daa000811','4f7c4840-470a-11ee-bfe6-a86daa000811'),(196,'ad0189dd-4710-11ee-bfe6-a86daa000811','4f7c8df6-470a-11ee-bfe6-a86daa000811'),(196,'ad0189dd-4710-11ee-bfe6-a86daa000811','4fa9239c-470a-11ee-bfe6-a86daa000811'),(196,'ad0189dd-4710-11ee-bfe6-a86daa000811','4fa92977-470a-11ee-bfe6-a86daa000811'),(196,'ad0189dd-4710-11ee-bfe6-a86daa000811','4ff6737a-470a-11ee-bfe6-a86daa000811'),(196,'ad0189dd-4710-11ee-bfe6-a86daa000811','ac976331-4710-11ee-bfe6-a86daa000811'),(196,'ad0189dd-4710-11ee-bfe6-a86daa000811','d5425abd-4709-11ee-bfe6-a86daa000811'),(196,'ad0189dd-4710-11ee-bfe6-a86daa000811','d54273bc-4709-11ee-bfe6-a86daa000811'),(196,'ad0189dd-4710-11ee-bfe6-a86daa000811','dbed38ba-4709-11ee-bfe6-a86daa000811'),(196,'ad0189dd-4710-11ee-bfe6-a86daa000811','dbed3f00-4709-11ee-bfe6-a86daa000811'),(196,'addcbbc3-4716-11ee-bfe6-a86daa000811','4f2156ce-4713-11ee-bfe6-a86daa000811'),(196,'addcbbc3-4716-11ee-bfe6-a86daa000811','4f4bfc45-4713-11ee-bfe6-a86daa000811'),(196,'addcbbc3-4716-11ee-bfe6-a86daa000811','557f540b-4713-11ee-bfe6-a86daa000811'),(196,'addcbbc3-4716-11ee-bfe6-a86daa000811','5998ed51-4713-11ee-bfe6-a86daa000811'),(196,'addcbbc3-4716-11ee-bfe6-a86daa000811','5f183485-4713-11ee-bfe6-a86daa000811'),(196,'addcbbc3-4716-11ee-bfe6-a86daa000811','601256c0-4711-11ee-bfe6-a86daa000811'),(196,'addcbbc3-4716-11ee-bfe6-a86daa000811','60126fc7-4711-11ee-bfe6-a86daa000811'),(196,'addcbbc3-4716-11ee-bfe6-a86daa000811','6557d3c6-4713-11ee-bfe6-a86daa000811'),(196,'addcbbc3-4716-11ee-bfe6-a86daa000811','ad6eec8c-4716-11ee-bfe6-a86daa000811'),(196,'addcbbc3-4716-11ee-bfe6-a86daa000811','e45fa630-4712-11ee-bfe6-a86daa000811'),(196,'addcbbc3-4716-11ee-bfe6-a86daa000811','e45fbb59-4712-11ee-bfe6-a86daa000811'),(196,'fc343a40-4710-11ee-bfe6-a86daa000811','0e658e5a-470a-11ee-bfe6-a86daa000811'),(196,'fc343a40-4710-11ee-bfe6-a86daa000811','0e65a514-470a-11ee-bfe6-a86daa000811'),(196,'fc343a40-4710-11ee-bfe6-a86daa000811','20eaffbb-470a-11ee-bfe6-a86daa000811'),(196,'fc343a40-4710-11ee-bfe6-a86daa000811','20eb0492-470a-11ee-bfe6-a86daa000811'),(196,'fc343a40-4710-11ee-bfe6-a86daa000811','473cc8ba-470a-11ee-bfe6-a86daa000811'),(196,'fc343a40-4710-11ee-bfe6-a86daa000811','473cddfc-470a-11ee-bfe6-a86daa000811'),(196,'fc343a40-4710-11ee-bfe6-a86daa000811','4f51891d-470a-11ee-bfe6-a86daa000811'),(196,'fc343a40-4710-11ee-bfe6-a86daa000811','4f7c4187-470a-11ee-bfe6-a86daa000811'),(196,'fc343a40-4710-11ee-bfe6-a86daa000811','4f7c4840-470a-11ee-bfe6-a86daa000811'),(196,'fc343a40-4710-11ee-bfe6-a86daa000811','4f7c8df6-470a-11ee-bfe6-a86daa000811'),(196,'fc343a40-4710-11ee-bfe6-a86daa000811','4fa9239c-470a-11ee-bfe6-a86daa000811'),(196,'fc343a40-4710-11ee-bfe6-a86daa000811','4fa92977-470a-11ee-bfe6-a86daa000811'),(196,'fc343a40-4710-11ee-bfe6-a86daa000811','4ff6737a-470a-11ee-bfe6-a86daa000811'),(196,'fc343a40-4710-11ee-bfe6-a86daa000811','d5425abd-4709-11ee-bfe6-a86daa000811'),(196,'fc343a40-4710-11ee-bfe6-a86daa000811','d54273bc-4709-11ee-bfe6-a86daa000811'),(196,'fc343a40-4710-11ee-bfe6-a86daa000811','dbed38ba-4709-11ee-bfe6-a86daa000811'),(196,'fc343a40-4710-11ee-bfe6-a86daa000811','dbed3f00-4709-11ee-bfe6-a86daa000811');
/*!40000 ALTER TABLE `SentAttachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SentMessage`
--

DROP TABLE IF EXISTS `SentMessage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SentMessage` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `discussionId` varchar(36) NOT NULL,
  `subject` varchar(45) NOT NULL,
  `body` text,
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `discussionId` (`discussionId`,`ownerId`),
  CONSTRAINT `SentMessage_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `SentMessage_ibfk_2` FOREIGN KEY (`discussionId`, `ownerId`) REFERENCES `Discussion` (`uuid`, `ownerId`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SentMessage`
--

LOCK TABLES `SentMessage` WRITE;
/*!40000 ALTER TABLE `SentMessage` DISABLE KEYS */;
INSERT INTO `SentMessage` VALUES ('434f208f-4718-11ee-bfe6-a86daa000811',196,'e9aee9e9-470c-11ee-bfe6-a86daa000811','#','Commande n° 1.1.6.1','2023-08-30 11:33:26.000',NULL,'2023-08-30 11:33:26.000','2023-08-30 09:33:28.695','2023-08-30 11:33:28.695'),('5fdfa238-4715-11ee-bfe6-a86daa000811',196,'e9aee9e9-470c-11ee-bfe6-a86daa000811','#','Commande n° 1.1.3.1','2023-08-30 11:12:45.000',NULL,'2023-08-30 11:12:45.000','2023-08-30 09:26:08.187','2023-08-30 11:26:08.187'),('6aa60301-4717-11ee-bfe6-a86daa000811',196,'e9aee9e9-470c-11ee-bfe6-a86daa000811','#','Commande n° 1.1.5.1','2023-08-30 11:27:23.000',NULL,'2023-08-30 11:27:23.000','2023-08-30 09:27:26.214','2023-08-30 11:27:26.214'),('6e429d26-4715-11ee-bfe6-a86daa000811',196,'e9aee9e9-470c-11ee-bfe6-a86daa000811','#','Commande n° 1.1.2.2','2023-08-30 11:13:10.000',NULL,'2023-08-30 11:13:10.000','2023-08-30 09:26:08.245','2023-08-30 11:26:08.245'),('7bfe5eb6-4713-11ee-bfe6-a86daa000811',196,'e9aee9e9-470c-11ee-bfe6-a86daa000811','#','Commande n° 1.1.2.1','2023-08-30 10:59:15.000',NULL,'2023-08-30 10:59:15.000','2023-08-30 08:59:16.982','2023-08-30 10:59:16.982'),('ad0189dd-4710-11ee-bfe6-a86daa000811',196,'e9aee9e9-470c-11ee-bfe6-a86daa000811','#','Commande n° 1.1.1.1','2023-08-30 10:39:17.000',NULL,'2023-08-30 10:39:17.000','2023-08-30 08:39:20.175','2023-08-30 10:39:20.175'),('addcbbc3-4716-11ee-bfe6-a86daa000811',196,'e9aee9e9-470c-11ee-bfe6-a86daa000811','#','Commande n° 1.1.4.1','2023-08-30 11:22:04.000',NULL,'2023-08-30 11:22:04.000','2023-08-30 09:26:08.272','2023-08-30 11:26:08.272'),('ce6d37ad-4710-11ee-bfe6-a86daa000811',196,'e9aee9e9-470c-11ee-bfe6-a86daa000811','#','discussion sans fichier\n','2023-08-30 10:40:00.000',NULL,'2023-08-30 10:40:00.000','2023-08-30 08:40:02.029','2023-08-30 10:40:02.029'),('e9af6a2f-470c-11ee-bfe6-a86daa000811',196,'e9aee9e9-470c-11ee-bfe6-a86daa000811','#','envoi simple via discussion sans pièce jointe','2023-08-30 10:12:09.000',NULL,'2023-08-30 10:12:09.000','2023-08-30 08:12:16.995','2023-08-30 10:12:16.995'),('fc343a40-4710-11ee-bfe6-a86daa000811',196,'e9aee9e9-470c-11ee-bfe6-a86daa000811','#','avec fichier','2023-08-30 10:41:17.000',NULL,'2023-08-30 10:41:17.000','2023-08-30 08:41:24.347','2023-08-30 10:41:24.347');
/*!40000 ALTER TABLE `SentMessage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SentOrderNotification`
--

DROP TABLE IF EXISTS `SentOrderNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SentOrderNotification` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `recipientId` varchar(36) DEFAULT NULL,
  `rescueData` text,
  `deliveryDate` datetime(3) DEFAULT NULL,
  `event` enum('EDITED','VALIDATED','CANCELLED') NOT NULL DEFAULT 'EDITED',
  `unread` tinyint(1) NOT NULL DEFAULT '1',
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `orderId` (`orderId`),
  KEY `recipientId` (`recipientId`),
  CONSTRAINT `SentOrderNotification_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `SentOrderNotification_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `ProstheticOrder` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `SentOrderNotification_ibfk_3` FOREIGN KEY (`recipientId`) REFERENCES `Contact` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SentOrderNotification`
--

LOCK TABLES `SentOrderNotification` WRITE;
/*!40000 ALTER TABLE `SentOrderNotification` DISABLE KEYS */;
INSERT INTO `SentOrderNotification` VALUES ('2ec14215-5d07-4282-ace1-29c46ca14bf2',196,'6ddc44d3-4715-11ee-bfe6-a86daa000811','6d038bac-e819-45db-8313-aba6d0d4ec3a','{\"recipientDisplayName\":\"sabine viptest\",\"patientDisplayID\":\"1.1\",\"orderTitle\":\"Commande n\\u00b0 1.1.2.2\"}','2023-09-02 00:00:00.000','VALIDATED',1,'2023-08-30 11:14:57.000',NULL,'2023-08-30 09:14:59.433','2023-08-30 11:14:59.433'),('7322b852-092b-44d4-af46-ad0b238565fa',196,'c58b4ec0-4716-11ee-bfe6-a86daa000811','6d038bac-e819-45db-8313-aba6d0d4ec3a','{\"recipientDisplayName\":\"sabine viptest\",\"patientDisplayID\":\"1.1\",\"orderTitle\":\"Commande n\\u00b0 1.1.5.1\"}','2023-09-01 00:00:00.000','VALIDATED',1,'2023-08-30 11:27:49.000',NULL,'2023-08-30 09:27:50.367','2023-08-30 11:27:50.367'),('c682cdfe-1897-4944-bae7-356ff2bd921f',196,'28bb3c55-4711-11ee-bfe6-a86daa000811','6d038bac-e819-45db-8313-aba6d0d4ec3a','{\"recipientDisplayName\":\"sabine viptest\",\"patientDisplayID\":\"1.1\",\"orderTitle\":\"Commande n\\u00b0 1.1.2.1\"}','2023-09-02 00:00:00.000','EDITED',1,'2023-08-30 11:01:59.000',NULL,'2023-08-30 09:02:27.598','2023-08-30 11:02:27.598'),('d76c6ca8-39ee-4de1-bf6b-421ef8c4e0b2',196,'c7a92194-4713-11ee-bfe6-a86daa000811','6d038bac-e819-45db-8313-aba6d0d4ec3a','{\"recipientDisplayName\":\"sabine viptest\",\"patientDisplayID\":\"1.1\",\"orderTitle\":\"Commande n\\u00b0 1.1.3.1\"}','2023-09-01 00:00:00.000','VALIDATED',1,'2023-08-30 11:14:24.000',NULL,'2023-08-30 09:14:25.306','2023-08-30 11:14:25.306'),('de3ef9ae-9caf-405a-a9c2-ee1d6315c518',196,'99088262-4716-11ee-bfe6-a86daa000811','6d038bac-e819-45db-8313-aba6d0d4ec3a','{\"recipientDisplayName\":\"sabine viptest\",\"patientDisplayID\":\"1.1\",\"orderTitle\":\"Commande n\\u00b0 1.1.4.1\"}','2023-09-02 00:00:00.000','CANCELLED',1,'2023-08-30 11:22:19.000',NULL,'2023-08-30 09:22:21.205','2023-08-30 11:22:21.205'),('df04a1b6-c2d0-476d-b0ea-ef115dae2025',196,'94134d72-4709-11ee-bfe6-a86daa000811','6d038bac-e819-45db-8313-aba6d0d4ec3a','{\"recipientDisplayName\":\"sabine viptest\",\"patientDisplayID\":\"1.1\",\"orderTitle\":\"Commande n\\u00b0 1.1.1.1\"}','2023-09-03 00:00:00.000','VALIDATED',1,'2023-08-30 10:40:50.000',NULL,'2023-08-30 08:40:52.601','2023-08-30 10:40:52.601');
/*!40000 ALTER TABLE `SentOrderNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Session`
--

DROP TABLE IF EXISTS `Session`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Session` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL,
  `actId` varchar(36) NOT NULL,
  `displayId` mediumint unsigned DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `comments` text,
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `actId` (`actId`),
  CONSTRAINT `Session_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Session_ibfk_2` FOREIGN KEY (`actId`) REFERENCES `Act` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Session`
--

LOCK TABLES `Session` WRITE;
/*!40000 ALTER TABLE `Session` DISABLE KEYS */;
INSERT INTO `Session` VALUES ('28b9b3ca-4711-11ee-bfe6-a86daa000811',196,'28b852b9-4711-11ee-bfe6-a86daa000811',1,0,'','2023-08-30 10:42:31.833',NULL,'2023-08-30 10:42:31.837','2023-08-30 08:42:31.837','2023-08-30 10:42:31.843'),('9411ecbc-4709-11ee-bfe6-a86daa000811',196,'94108410-4709-11ee-bfe6-a86daa000811',1,0,'','2023-08-30 09:48:15.954',NULL,'2023-08-30 09:48:15.957','2023-08-30 07:48:15.957','2023-08-30 09:48:15.963'),('99075aea-4716-11ee-bfe6-a86daa000811',196,'99062442-4716-11ee-bfe6-a86daa000811',1,0,'','2023-08-30 11:21:27.731',NULL,'2023-08-30 11:21:27.733','2023-08-30 09:21:27.733','2023-08-30 11:21:27.738'),('a0f77fda-4717-11ee-bfe6-a86daa000811',196,'a0f72d78-4717-11ee-bfe6-a86daa000811',1,0,'','2023-08-30 11:28:50.545',NULL,'2023-08-30 11:28:50.546','2023-08-30 09:32:40.445','2023-08-30 11:32:40.703'),('c589e5b6-4716-11ee-bfe6-a86daa000811',196,'c588c3d6-4716-11ee-bfe6-a86daa000811',1,0,'','2023-08-30 11:22:42.406',NULL,'2023-08-30 11:22:42.409','2023-08-30 09:22:42.408','2023-08-30 11:22:42.415'),('c7a8830f-4713-11ee-bfe6-a86daa000811',196,'c7a7cd85-4713-11ee-bfe6-a86daa000811',1,0,'{\"occlusionType\":1}','2023-08-30 11:01:17.472',NULL,'2023-08-30 11:01:17.473','2023-08-30 09:10:29.556','2023-08-30 11:11:14.731'),('dcede3af-4715-11ee-bfe6-a86daa000811',196,'dcec7c3f-4715-11ee-bfe6-a86daa000811',1,0,'','2023-08-30 11:16:12.152',NULL,'2023-08-30 11:16:12.155','2023-08-30 09:16:12.155','2023-08-30 11:16:12.161');
/*!40000 ALTER TABLE `Session` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SmilersOrder`
--

DROP TABLE IF EXISTS `SmilersOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SmilersOrder` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `actId` varchar(36) NOT NULL,
  `title` varchar(64) DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `createdById` varchar(36) DEFAULT NULL,
  `updatedById` varchar(36) DEFAULT NULL,
  `displayId` mediumint unsigned DEFAULT NULL,
  `json` text NOT NULL,
  `metadata` text NOT NULL,
  `status` enum('NOT_SENT','WAITING_WOW_API','SENDING_WOW_API','SENDING_SMILERS_API','SENT','CANCELLED','DELIVERY') NOT NULL DEFAULT 'NOT_SENT',
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `actId` (`actId`),
  CONSTRAINT `SmilersOrder_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `SmilersOrder_ibfk_2` FOREIGN KEY (`actId`) REFERENCES `Act` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SmilersOrder`
--

LOCK TABLES `SmilersOrder` WRITE;
/*!40000 ALTER TABLE `SmilersOrder` DISABLE KEYS */;
/*!40000 ALTER TABLE `SmilersOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SmilersOrderFile`
--

DROP TABLE IF EXISTS `SmilersOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SmilersOrderFile` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('FORM','SCAN') NOT NULL,
  PRIMARY KEY (`orderId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `SmilersOrderFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `SmilersOrderFile_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `SmilersOrder` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `SmilersOrderFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SmilersOrderFile`
--

LOCK TABLES `SmilersOrderFile` WRITE;
/*!40000 ALTER TABLE `SmilersOrderFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `SmilersOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SyncInfo`
--

DROP TABLE IF EXISTS `SyncInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SyncInfo` (
  `id` mediumint unsigned NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `patientsLastRetrieved` datetime(3) DEFAULT NULL,
  `actsLastRetrieved` datetime(3) DEFAULT NULL,
  `sessionsLastRetrieved` datetime(3) DEFAULT NULL,
  `scansLastRetrieved` datetime(3) DEFAULT NULL,
  `ordersLastRetrieved` datetime(3) DEFAULT NULL,
  `assistantsLastRetrieved` datetime(3) DEFAULT NULL,
  `contactsLastRetrieved` datetime(3) DEFAULT NULL,
  `discussionsLastRetrieved` datetime(3) DEFAULT NULL,
  `messagesLastRetrieved` datetime(3) DEFAULT NULL,
  `notificationsLastRetrieved` datetime(3) DEFAULT NULL,
  `occlusionsLastRetrieved` datetime(3) DEFAULT NULL,
  `circleordersLastRetrieved` datetime(3) DEFAULT NULL,
  `smilersordersLastRetrieved` datetime(3) DEFAULT NULL,
  `prostheticSheetsLastRetrieved` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  PRIMARY KEY (`id`,`ownerId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SyncInfo`
--

LOCK TABLES `SyncInfo` WRITE;
/*!40000 ALTER TABLE `SyncInfo` DISABLE KEYS */;
INSERT INTO `SyncInfo` VALUES (1,196,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-08-30 07:46:40.041'),(1,197,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-08-30 07:54:38.678');
/*!40000 ALTER TABLE `SyncInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SystemNotification`
--

DROP TABLE IF EXISTS `SystemNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SystemNotification` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `event` enum('NO_CONNECTION_FOR_X_DAYS') NOT NULL DEFAULT 'NO_CONNECTION_FOR_X_DAYS',
  `unread` tinyint(1) NOT NULL DEFAULT '1',
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  CONSTRAINT `SystemNotification_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SystemNotification`
--

LOCK TABLES `SystemNotification` WRITE;
/*!40000 ALTER TABLE `SystemNotification` DISABLE KEYS */;
/*!40000 ALTER TABLE `SystemNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Token`
--

DROP TABLE IF EXISTS `Token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Token` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `credentialsId` varchar(36) DEFAULT NULL,
  `token` char(200) NOT NULL,
  `context` char(40) DEFAULT NULL,
  `device` char(255) DEFAULT NULL,
  `created` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `token` (`token`),
  KEY `credentialsId` (`credentialsId`),
  CONSTRAINT `Token_ibfk_1` FOREIGN KEY (`credentialsId`) REFERENCES `Credentials` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Token`
--

LOCK TABLES `Token` WRITE;
/*!40000 ALTER TABLE `Token` DISABLE KEYS */;
INSERT INTO `Token` VALUES ('0dd91dea-470d-11ee-bfe6-a86daa000811',196,'956d7fd1-bffd-4500-8156-2db75591d0a0','8d92772b53f0bdc7bdd7dae23a6bc20e02eadc9e','software','CondorScan','2023-08-30 10:13:08.754','2023-08-30 08:13:08.754'),('59a6b7b2-4709-11ee-bfe6-a86daa000811',196,'956d7fd1-bffd-4500-8156-2db75591d0a0','c74350d74948ab0475a8f9ed48801a5a75c72f0d','software','CondorScan','2023-08-30 09:46:37.943','2023-08-30 07:46:40.050'),('a09349d2-4710-11ee-bfe6-a86daa000811',196,'956d7fd1-bffd-4500-8156-2db75591d0a0','20f3c630a9f31d890e47d7e08719d2434ac23d41','software','CondorScan','2023-08-30 10:38:43.412','2023-08-30 08:38:43.412'),('af90200a-470c-11ee-bfe6-a86daa000811',196,'956d7fd1-bffd-4500-8156-2db75591d0a0','445116a423f1475523a21cb5bc8657c8c2471f46','software','CondorScan','2023-08-30 10:10:30.570','2023-08-30 08:10:30.570');
/*!40000 ALTER TABLE `Token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `__db_version__`
--

DROP TABLE IF EXISTS `__db_version__`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `__db_version__` (
  `id` int NOT NULL AUTO_INCREMENT,
  `versionMajor` int NOT NULL,
  `versionMinor` int NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `migrationFile` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `__db_version__`
--

LOCK TABLES `__db_version__` WRITE;
/*!40000 ALTER TABLE `__db_version__` DISABLE KEYS */;
INSERT INTO `__db_version__` VALUES (1,1,0,'v1.0','migration_wow_application_1.0_create_wow_application'),(2,1,1,'v1.1','migration_wow_application_1.1_occlusion_pap'),(3,1,2,'v1.2','migration_wow_application_1.2_occlusion_pre_preparation'),(4,1,3,'v1.3','migration_wow_application_1.3_occlusion_rework'),(5,1,4,'v1.4','migration_wow_application_1.4_scan_label'),(6,1,5,'v1.5','migration_wow_application_1.5_order_delivery'),(7,1,6,'v1.6','migration_wow_application_1.6_sheet_json'),(8,1,7,'v1.7','migration_wow_application_1.7_config_patient_list');
/*!40000 ALTER TABLE `__db_version__` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping routines for database 'wow_application'
--
/*!50003 DROP FUNCTION IF EXISTS `fileMetadataToLabel` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `fileMetadataToLabel`(metadata TEXT) RETURNS text CHARSET utf8mb4
    NO SQL
BEGIN
    IF metadata LIKE '%scanBodies%' THEN RETURN 'SCANBODY'; END IF;

    RETURN 'SCAN';
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewOcclusionFileType` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewOcclusionFileType`(oldType TEXT) RETURNS text CHARSET utf8mb4
    NO SQL
BEGIN
    IF oldType = 'OCCLUSION_RESULT' THEN RETURN 'RESULT'; END IF;

    IF oldType = 'MANDIBULE_PLY' THEN RETURN 'MANDIBLE'; END IF;

    IF oldType = 'MAXILLAIRE_PLY' THEN RETURN 'MAXILLARY'; END IF;

    IF oldType = 'MANDIBULE_MATRIX' THEN RETURN 'MANDIBLE_MATRIX'; END IF;

    IF oldType = 'MAXILLAIRE_MATRIX' THEN RETURN 'MAXILLARY_MATRIX'; END IF;

    IF oldType = 'LIFIMETA' THEN RETURN 'LIFIMETA'; END IF;

    IF oldType = 'LIFI' THEN RETURN 'LIFI'; END IF;

    IF oldType = 'SNAPSHOT' THEN RETURN 'SNAPSHOT'; END IF;

    IF oldType = 'SCREENSHOT' THEN RETURN 'SCREENSHOT'; END IF;

    
    IF oldType = 'LEFT_BITE' THEN RETURN 'RESULT'; END IF;
    IF oldType = 'RIGHT_BITE' THEN RETURN 'RESULT'; END IF;
    IF oldType = 'ANTERIOR_BITE' THEN RETURN 'RESULT'; END IF;

    RETURN oldType;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewProstheticContactPoint` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewProstheticContactPoint`(old TEXT) RETURNS int
    NO SQL
BEGIN
    IF old = '2' THEN RETURN 0; END IF;
    IF old = '3' THEN RETURN 1; END IF;
    IF old = '4' THEN RETURN 2; END IF;
    RETURN 1;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewProstheticCrownOrBridgeSubType` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewProstheticCrownOrBridgeSubType`(old TEXT) RETURNS int
    NO SQL
BEGIN
    IF old = '1' THEN RETURN 0; END IF;
    IF old = '2' THEN RETURN 1; END IF;
    IF old = '3' THEN RETURN 2; END IF;
    RETURN 0;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewProstheticGouttiereSubType` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewProstheticGouttiereSubType`(old TEXT) RETURNS int
    NO SQL
BEGIN
    IF old = '1' THEN RETURN 1; END IF;
    IF old = '2' THEN RETURN 2; END IF;
    IF old = '3' THEN RETURN 3; END IF;
    IF old = '4' THEN RETURN 0; END IF;
    IF old = '5' THEN RETURN 4; END IF;
    IF old = '6' THEN RETURN 5; END IF;
    IF old = '7' THEN RETURN 6; END IF;
    RETURN 0;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewProstheticImplantCrownSubType` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewProstheticImplantCrownSubType`(old TEXT) RETURNS int
    NO SQL
BEGIN
    IF old = '1' THEN RETURN 0; END IF;
    IF old = '2' THEN RETURN 1; END IF;
    IF old = '3' THEN RETURN 0; END IF;
    IF old = '4' THEN RETURN 1; END IF;
    RETURN 2;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewProstheticInlayOnlaySubType` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewProstheticInlayOnlaySubType`(old TEXT) RETURNS int
    NO SQL
BEGIN
    IF old = '1' THEN RETURN 0; END IF;
    IF old = '2' THEN RETURN 1; END IF;
    RETURN 2;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `scanMetadataToLabel` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `scanMetadataToLabel`(metadata TEXT) RETURNS text CHARSET utf8mb4
    NO SQL
BEGIN
    IF metadata LIKE '%"isPrePreparation":true%' THEN RETURN 'PRE_PREPARATION'; END IF;

    RETURN 'SCAN';
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-08-30 12:23:00
