-- MariaDB dump 10.19  Distrib 10.6.16-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: localhost    Database: iris_application
-- ------------------------------------------------------
-- Server version	10.6.16-MariaDB-0ubuntu0.22.04.1

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `Act`
--

DROP TABLE IF EXISTS `Act`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Act` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `patientId` varchar(36) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `displayId` mediumint(8) unsigned DEFAULT NULL,
  `pcId` mediumint(8) unsigned DEFAULT NULL,
  `workflow` enum('FREE','WORKFLOW_1','WORKFLOW_2','WORKFLOW_3','ANALYSE') NOT NULL DEFAULT 'FREE',
  `comments` text DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT 0,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastAccessed` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `patientId` (`patientId`),
  CONSTRAINT `Act_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `Act_ibfk_2` FOREIGN KEY (`patientId`) REFERENCES `iris_patient`.`Patient` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Act`
--

LOCK TABLES `Act` WRITE;
/*!40000 ALTER TABLE `Act` DISABLE KEYS */;
INSERT INTO `Act` VALUES ('00fde810-297d-11ef-8e16-d517f37fa2ad',11,'b4934f39-2960-11ef-8e16-d517f37fa2ad','Ordini 2.1',1,1,'WORKFLOW_3','{\"type\":\"ORDER\"}',0,'2024-06-13 14:03:53.606','2024-06-13 14:08:57.936','2024-06-13 14:08:14.147','2024-06-13 14:08:57.936','2024-06-13 12:08:57.937','2024-06-13 14:08:57.947'),('08eb58c6-2980-11ef-8e16-d517f37fa2ad',11,'269e882c-2961-11ef-8e16-d517f37fa2ad','Ordini 5.5',5,1,'WORKFLOW_1','{\"type\":\"ORDER\"}',0,'2024-06-13 14:25:35.397',NULL,'2024-06-20 12:20:17.850','2024-06-13 14:52:49.955','2024-06-20 10:20:17.850','2024-06-20 12:20:17.860'),('0bcc91ed-23e9-11ef-8dde-d415e84cc4f5',3,'907398e3-23e7-11ef-8dde-d415e84cc4f5','Commande 2.2',2,1,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-06 11:42:10.408',NULL,'2024-06-06 11:42:51.705','2024-06-06 11:42:51.580','2024-06-06 09:42:51.705','2024-06-06 11:42:51.715'),('0be66d2e-273b-11ef-8e16-d517f37fa1ab',2,'f6d6ceba-273a-11ef-8e16-d517f37fa1ab','Commande 10.1',1,2,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-10 17:06:42.798','2024-06-10 17:07:19.480','2024-06-10 17:06:43.023','2024-06-10 17:07:19.480','2024-06-10 15:07:19.481','2024-06-10 17:07:19.484'),('0d1289f0-289a-11ef-8e16-d517f37fa2ad',5,'f373c86a-2899-11ef-8e16-d517f37fa2ad','Commande 1.1',1,1,'WORKFLOW_1','{\"type\":\"ORDER\"}',0,'2024-06-12 10:59:18.116',NULL,'2024-06-12 15:30:19.260','2024-06-12 11:20:00.465','2024-06-12 13:30:19.260','2024-06-12 15:30:19.270'),('118f12a1-28bb-11ef-8e16-d517f37fa2ad',5,'09f7c5e2-28bb-11ef-8e16-d517f37fa2ad','Commande 3.1',1,1,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-12 14:55:39.036',NULL,'2024-06-12 16:14:53.482','2024-06-12 14:57:11.411','2024-06-12 14:14:53.483','2024-06-12 16:14:53.493'),('15f71dc7-2e4b-11ef-8deb-d515ea58f6cb',2,'115617bc-2e4b-11ef-8deb-d515ea58f6cb','Order 17.1',1,2,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-19 16:49:10.416',NULL,'2024-06-19 16:57:04.214','2024-06-19 16:56:24.965','2024-06-19 14:57:04.215','2024-06-19 16:57:04.224'),('164199d1-2e43-11ef-8deb-d515ea58f6cb',2,'4382037a-2735-11ef-8e16-d517f37fa1ab','Order 6.5',5,2,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-19 15:51:54.930',NULL,'2024-06-19 16:01:54.104','2024-06-19 15:54:05.651','2024-06-19 14:01:54.104','2024-06-19 16:01:54.113'),('1b9240f4-2e0d-11ef-8deb-d515ea58f6cb',2,'172f299e-2e0d-11ef-8deb-d515ea58f6cb','Ordini 15.1',1,2,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-19 09:25:31.024',NULL,'2024-06-19 09:26:30.188','2024-06-19 09:26:43.273','2024-06-19 07:26:43.273','2024-06-19 12:49:09.404'),('1cb775ae-271f-11ef-8e16-d517f37fa1ab',2,'a1ace9b5-2271-11ef-8d76-d310d2ec2c14','Commande 2.2',2,2,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-10 13:46:45.000',NULL,'2024-06-17 16:38:11.672','2024-06-11 10:45:13.251','2024-06-17 14:38:11.673','2024-06-17 16:38:11.682'),('35920e04-2984-11ef-8e16-d517f37fa2ad',11,'269e882c-2961-11ef-8e16-d517f37fa2ad','Analisi 5.6',6,1,'ANALYSE','{\"type\":\"ANALYSE\"}',0,'2024-06-13 14:55:28.296',NULL,'2024-06-13 16:01:29.025','2024-06-13 14:55:28.296','2024-06-13 14:01:29.027','2024-06-13 16:01:29.039'),('3654e763-2e35-11ef-8deb-d515ea58f6cb',2,'309e7124-2e35-11ef-8deb-d515ea58f6cb','Ordini 16.1',1,2,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-19 14:12:35.790',NULL,'2024-06-19 14:50:35.068','2024-06-19 14:22:30.286','2024-06-19 12:50:35.069','2024-06-19 14:50:35.078'),('391a9e5e-297f-11ef-8e16-d517f37fa2ad',11,'269e882c-2961-11ef-8e16-d517f37fa2ad','Analisi 5.4',4,1,'ANALYSE','{\"type\":\"ANALYSE\"}',0,'2024-06-13 14:19:46.740',NULL,'2024-06-13 14:19:46.785','2024-06-13 14:19:46.741','2024-06-13 12:19:55.180','2024-06-13 14:19:55.703'),('46997caf-27cb-11ef-8e37-d519fa9d22d2',2,'3573ee42-27cb-11ef-8e37-d519fa9d22d2','Commande 13.1',1,2,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-11 10:19:08.808',NULL,'2024-06-11 10:35:43.649','2024-06-11 10:20:19.186','2024-06-11 08:35:43.650','2024-06-11 10:35:43.659'),('4704a021-2963-11ef-8e16-d517f37fa2ad',11,'269e882c-2961-11ef-8e16-d517f37fa2ad','Ordini 5.1',1,1,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-13 10:59:44.176',NULL,'2024-06-20 11:11:06.165','2024-06-13 11:56:20.978','2024-06-20 09:11:06.165','2024-06-20 11:11:06.174'),('4ba13230-2987-11ef-8e16-d517f37fa2ad',11,'0fedc3b4-2961-11ef-8e16-d517f37fa2ad','Ordini 4.1',1,1,'WORKFLOW_2','{\"type\":\"ORDER\"}',0,'2024-06-13 15:17:33.795',NULL,'2024-06-14 11:28:27.741','2024-06-13 15:22:46.017','2024-06-14 09:28:27.741','2024-06-14 11:28:27.751'),('5467faec-2740-11ef-8e09-d517f1736dc8',2,'ce57500b-227c-11ef-8d76-d310d2ec2c14','Analyse 3.2',2,2,'ANALYSE','{\"type\":\"ANALYSE\"}',0,'2024-06-10 17:44:31.926',NULL,'2024-06-10 17:44:31.976','2024-06-10 17:44:31.927','2024-06-10 15:44:40.050','2024-06-10 17:44:40.413'),('54ecb28b-273a-11ef-8e16-d517f37fa1ab',2,'520a1417-2735-11ef-8e16-d517f37fa1ab','Commande 7.1',1,2,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-10 17:01:35.816',NULL,'2024-06-17 16:36:44.418','2024-06-10 17:02:16.540','2024-06-17 14:36:44.418','2024-06-17 16:36:44.420'),('58f22a30-298a-11ef-8e16-d517f37fa2ad',2,'5062e053-298a-11ef-8e16-d517f37fa2ad','Commande 14.1',1,2,'WORKFLOW_3','{\"type\":\"ORDER\"}',0,'2024-06-13 15:39:24.626',NULL,'2024-06-17 16:49:07.865','2024-06-13 15:40:18.578','2024-06-17 14:49:07.866','2024-06-17 16:49:07.875'),('5f1d39de-273f-11ef-8e09-d517f1736dc8',2,'b8993188-273d-11ef-8e09-d517f1736dc8','Direct scan 11.2',2,2,'FREE','{\"type\":\"DIRECT_SCAN\"}',0,'2024-06-10 17:37:40.394',NULL,'2024-06-11 10:11:39.409','2024-06-10 17:38:47.280','2024-06-11 08:11:39.409','2024-06-11 10:11:39.419'),('5f30ec6f-27f1-11ef-8e37-d519fa9d22d2',2,'b8993188-273d-11ef-8e09-d517f1736dc8','Commande 11.3',3,2,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-11 14:51:50.941',NULL,'2024-06-11 14:51:51.138','2024-06-11 14:51:50.944','2024-06-11 12:51:51.138','2024-06-11 14:51:51.149'),('5f4774a2-28bf-11ef-8e16-d517f37fa2ad',5,'09f7c5e2-28bb-11ef-8e16-d517f37fa2ad','Commande 3.2',2,1,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-12 15:26:27.415',NULL,'2024-06-12 18:00:03.949','2024-06-12 18:00:03.806','2024-06-12 16:00:03.949','2024-06-12 18:00:03.952'),('627cfe1c-289b-11ef-8e16-d517f37fa2ad',5,'f373c86a-2899-11ef-8e16-d517f37fa2ad','Commande 1.2',2,1,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-12 11:08:50.917',NULL,'2024-06-12 17:55:18.204','2024-06-12 13:40:00.814','2024-06-12 15:55:18.204','2024-06-12 17:55:18.213'),('62b97c61-226c-11ef-8d76-d310d2ec2c14',2,'dc803a78-225a-11ef-8f1f-d8242c71b430','Commande 1.1',1,2,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-04 14:17:17.000',NULL,'2024-06-19 12:50:09.067','2024-06-19 12:50:36.310','2024-06-19 10:50:36.310','2024-06-19 12:50:36.312'),('6872058e-28c3-11ef-8e16-d517f37fa2ad',5,'82c4f551-28bf-11ef-8e16-d517f37fa2ad','Direct scan 4.2',2,1,'FREE','{\"type\":\"DIRECT_SCAN\"}',0,'2024-06-12 15:55:20.781',NULL,'2024-06-12 16:45:46.880','2024-06-12 16:37:28.932','2024-06-12 14:45:46.880','2024-06-12 16:45:46.890'),('68af0333-2e42-11ef-8deb-d515ea58f6cb',2,'4382037a-2735-11ef-8e16-d517f37fa1ab','Order 6.4',4,2,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-19 15:47:03.724',NULL,'2024-06-19 15:48:19.034','2024-06-19 15:50:02.135','2024-06-19 13:50:02.136','2024-06-19 15:50:02.137'),('6a002ae5-28c9-11ef-8e16-d517f37fa2ad',5,'a9fa9552-28c9-11ef-8e16-d517f37fa2ad','Commande 5.1',1,1,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-12 16:38:20.370',NULL,'2024-06-12 16:40:14.421','2024-06-12 16:43:44.657','2024-06-12 14:43:44.657','2024-06-12 16:43:44.662'),('72b8db7f-2a20-11ef-8f1c-d8242c6fa8fd',11,'eb10a1b6-2960-11ef-8e16-d517f37fa2ad','Ordini 3.1',1,1,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-14 09:33:53.901','2024-06-14 10:38:35.943','2024-06-14 10:38:26.755','2024-06-14 10:38:35.943','2024-06-14 08:38:35.943','2024-06-14 10:38:35.951'),('78ba832e-2255-11ef-8e3f-d619fca54465',3,'6220e0d7-2255-11ef-8e3f-d619fca54465','Commande 1.1',1,1,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-04 11:33:16.482',NULL,'2024-06-06 11:13:41.385','2024-06-04 12:10:13.366','2024-06-06 09:13:41.385','2024-06-06 11:13:41.394'),('80d26da8-27cb-11ef-8e37-d519fa9d22d2',2,'3573ee42-27cb-11ef-8e37-d519fa9d22d2','Commande 13.2',2,2,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-11 10:20:46.489',NULL,'2024-06-19 15:37:25.289','2024-06-11 10:21:25.750','2024-06-19 13:37:25.289','2024-06-19 15:37:25.299'),('834ecb64-2343-11ef-8f85-d92942ce45ec',3,'834afe1e-2343-11ef-8f85-d92942ce45ec','Direct scan',1,1,'FREE','{\"type\":\"DIRECT_SCAN\"}',1,'2024-06-05 15:57:15.416',NULL,'2024-06-05 15:57:15.572','2024-06-05 15:57:15.418','2024-06-05 13:57:15.572',NULL),('84822f83-2cbb-11ef-8e27-d518f78fe3c8',2,'a1ace9b5-2271-11ef-8d76-d310d2ec2c14','Scan 2.5',5,2,'FREE','{\"type\":\"IMPORTED_SCANS\"}',0,'2024-06-17 17:08:56.540',NULL,'2024-06-17 17:08:56.794','2024-06-17 17:08:56.654','2024-06-17 15:08:56.795','2024-06-17 17:08:56.804'),('8598ee4a-2e40-11ef-8deb-d515ea58f6cb',2,'4382037a-2735-11ef-8e16-d517f37fa1ab','Order 6.3',3,2,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-19 15:33:33.240',NULL,'2024-06-19 17:07:42.426','2024-06-19 16:02:30.563','2024-06-19 15:07:42.426','2024-06-19 17:07:42.435'),('8c10fdc0-2735-11ef-8e16-d517f37fa1ab',2,'312c74c3-2735-11ef-8e16-d517f37fa1ab','Commande 5.1',1,2,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-10 16:27:20.845','2024-06-11 10:08:19.600','2024-06-11 10:02:52.365','2024-06-11 10:08:19.600','2024-06-11 08:08:19.600','2024-06-11 10:08:19.602'),('8d07a312-2a29-11ef-8f1c-d8242c6fa8fd',11,'eb10a1b6-2960-11ef-8e16-d517f37fa2ad','Ordini 3.2',2,1,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-14 10:39:03.508',NULL,'2024-06-19 10:47:38.339','2024-06-14 11:22:39.576','2024-06-19 08:47:38.339','2024-06-19 11:30:07.300'),('8d2006e5-23eb-11ef-8dde-d415e84cc4f5',3,'907398e3-23e7-11ef-8dde-d415e84cc4f5','Commande 2.3',3,1,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-06 12:00:06.374',NULL,'2024-06-06 14:27:49.424','2024-06-06 12:00:06.377','2024-06-06 12:27:49.424','2024-06-06 14:27:49.434'),('8e81ab09-296b-11ef-8e16-d517f37fa2ad',11,'9cd27370-2960-11ef-8e16-d517f37fa2ad','Ordini 1.1',1,1,'WORKFLOW_2','{\"type\":\"ORDER\"}',0,'2024-06-13 11:59:00.087',NULL,'2024-06-14 11:25:15.304','2024-06-13 12:37:10.064','2024-06-14 09:25:15.305','2024-06-14 11:25:15.314'),('8f6c8859-2740-11ef-8e09-d517f1736dc8',2,'8f5ceea7-2740-11ef-8e09-d517f1736dc8','Scan 12.1',1,2,'FREE','{\"type\":\"IMPORTED_SCANS\"}',0,'2024-06-10 17:46:10.941',NULL,'2024-06-19 16:13:43.935','2024-06-19 16:15:02.150','2024-06-19 14:15:02.150','2024-06-19 16:15:02.152'),('917767fe-23fa-11ef-8dde-d415e84cc4f5',2,'520a1417-2735-11ef-8e16-d517f37fa1ab','Commande 7.2',2,2,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-06 13:47:36.109','2024-06-11 10:15:33.810','2024-06-11 10:15:24.952','2024-06-11 10:15:33.810','2024-06-11 08:15:33.810','2024-06-11 10:15:33.815'),('9573b888-2e29-11ef-8deb-d515ea58f6cb',2,'520a1417-2735-11ef-8e16-d517f37fa1ab','Commande 7.4',4,2,'WORKFLOW_2','{\"type\":\"ORDER\"}',0,'2024-06-19 12:49:21.414',NULL,'2024-06-19 12:53:51.220','2024-06-19 12:49:52.902','2024-06-19 10:53:51.220','2024-06-19 12:53:51.230'),('96aedcf6-23e7-11ef-8dde-d415e84cc4f5',3,'907398e3-23e7-11ef-8dde-d415e84cc4f5','Commande 2.1',1,1,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-06 11:31:44.423',NULL,'2024-06-06 11:38:45.370','2024-06-06 11:33:22.322','2024-06-06 09:38:45.370','2024-06-06 11:38:45.382'),('9c9bb412-28ba-11ef-8e16-d517f37fa2ad',5,'a49d8d6e-28b9-11ef-8e16-d517f37fa2ad','Commande 2.1',1,1,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-12 14:52:22.825','2024-06-12 14:54:09.706','2024-06-12 14:53:47.165','2024-06-12 14:54:09.706','2024-06-12 12:54:09.706','2024-06-12 14:54:09.716'),('a1ebbaf4-298a-11ef-8e16-d517f37fa2ad',2,'5062e053-298a-11ef-8e16-d517f37fa2ad','Commande 14.2',2,2,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-13 15:41:27.058',NULL,'2024-06-13 15:44:48.922','2024-06-13 15:45:02.746','2024-06-13 13:45:02.747','2024-06-13 15:45:02.754'),('a3cf95b8-2720-11ef-8e16-d517f37fa1ab',2,'a1ace9b5-2271-11ef-8d76-d310d2ec2c14','Analyse 2.3',3,2,'ANALYSE','{\"type\":\"ANALYSE\"}',0,'2024-06-10 13:57:41.000',NULL,'2024-06-17 16:36:54.055','2024-06-10 13:57:41.000','2024-06-17 14:36:54.056','2024-06-17 16:36:54.059'),('a4139c9d-2279-11ef-8d76-d310d2ec2c14',2,'dc803a78-225a-11ef-8f1f-d8242c71b430','Commande 1.3',3,2,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-04 15:52:11.000',NULL,'2024-06-19 17:05:16.169','2024-06-04 15:53:15.000','2024-06-19 15:05:16.169','2024-06-19 17:05:16.178'),('a8885309-2984-11ef-8e16-d517f37fa2ad',11,'269e882c-2961-11ef-8e16-d517f37fa2ad','Direct scan 5.7',7,1,'FREE','{\"type\":\"DIRECT_SCAN\"}',0,'2024-06-13 14:58:41.170',NULL,'2024-06-13 16:02:29.722','2024-06-13 15:05:35.543','2024-06-13 14:02:29.722','2024-06-13 16:02:29.732'),('af857ecd-27f1-11ef-8e37-d519fa9d22d2',2,'309e7124-2e35-11ef-8deb-d515ea58f6cb','Direct scan 16.4',4,2,'FREE','{\"type\":\"DIRECT_SCAN\"}',0,'2024-06-11 14:54:05.713',NULL,'2024-06-19 15:19:00.670','2024-06-19 15:19:00.563','2024-06-19 13:19:00.670','2024-06-19 15:19:00.680'),('afa6cb0d-2271-11ef-8d76-d310d2ec2c14',2,'a1ace9b5-2271-11ef-8d76-d310d2ec2c14','Commande 2.1',1,2,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-04 14:55:14.000',NULL,'2024-06-17 17:42:56.166','2024-06-04 14:57:24.000','2024-06-17 15:42:56.166','2024-06-17 17:42:56.176'),('b6e836ab-2fa5-11ef-8e5c-d61b03bfb54e',2,'b6e444c5-2fa5-11ef-8e5c-d61b03bfb54e','Direct scan',1,2,'FREE','{\"type\":\"DIRECT_SCAN\"}',1,'2024-06-21 10:10:26.365',NULL,'2024-06-21 10:10:26.562','2024-06-21 10:10:26.368','2024-06-21 08:10:26.563',NULL),('b7e3a050-2e0c-11ef-8deb-d515ea58f6cb',11,'b7e05748-2e0c-11ef-8deb-d515ea58f6cb','Direct scan',1,1,'FREE','{\"type\":\"DIRECT_SCAN\"}',1,'2024-06-19 09:22:43.785',NULL,'2024-06-19 09:23:14.425','2024-06-19 09:23:40.584','2024-06-19 07:23:40.585',NULL),('bafa1a93-273a-11ef-8e16-d517f37fa1ab',2,'b6f9b0de-273a-11ef-8e16-d517f37fa1ab','Commande 9.1',1,2,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-10 17:04:27.031','2024-06-10 17:05:41.508','2024-06-10 17:04:46.609','2024-06-10 17:05:41.508','2024-06-10 15:05:41.509','2024-06-10 17:05:41.510'),('be9a8e99-2735-11ef-8e16-d517f37fa1ab',2,'4382037a-2735-11ef-8e16-d517f37fa1ab','Commande 6.1',1,2,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-10 16:28:45.632',NULL,'2024-06-19 15:37:45.174','2024-06-19 09:28:40.405','2024-06-19 13:37:45.174','2024-06-19 15:37:45.184'),('c425e233-28d3-11ef-8e16-d517f37fa2ad',5,'82c4f551-28bf-11ef-8e16-d517f37fa2ad','Analyse 4.3',3,1,'ANALYSE','{\"type\":\"ANALYSE\"}',0,'2024-06-12 17:52:26.580',NULL,'2024-06-12 18:01:18.962','2024-06-12 17:52:26.580','2024-06-12 16:01:18.962','2024-06-12 18:01:18.964'),('c88615a1-2e3c-11ef-8deb-d515ea58f6cb',2,'309e7124-2e35-11ef-8deb-d515ea58f6cb','Order 16.3',3,2,'WORKFLOW_2','{\"type\":\"ORDER\"}',0,'2024-06-19 15:06:47.536',NULL,'2024-06-19 17:08:49.771','2024-06-19 17:08:49.642','2024-06-19 15:08:49.772','2024-06-19 17:08:49.777'),('cc35f9a3-297d-11ef-8e16-d517f37fa2ad',11,'269e882c-2961-11ef-8e16-d517f37fa2ad','Ordini 5.2',2,1,'WORKFLOW_1','{\"type\":\"ORDER\"}',0,'2024-06-13 14:09:34.551',NULL,'2024-06-20 14:47:35.565','2024-06-13 14:14:52.315','2024-06-20 12:47:35.565','2024-06-20 14:47:35.574'),('d5b85a1b-297e-11ef-8e16-d517f37fa2ad',11,'269e882c-2961-11ef-8e16-d517f37fa2ad','Analisi 5.3',3,1,'ANALYSE','{\"type\":\"ANALYSE\"}',0,'2024-06-13 14:17:00.002','2024-06-13 14:19:41.417','2024-06-13 14:17:00.050','2024-06-13 14:19:41.417','2024-06-13 12:19:41.419','2024-06-13 14:19:41.431'),('d703d726-298d-11ef-8e16-d517f37fa2ad',11,'9cd27370-2960-11ef-8e16-d517f37fa2ad','Ordini 1.2',2,1,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-13 16:04:24.625',NULL,'2024-06-19 12:25:10.393','2024-06-13 16:28:35.764','2024-06-19 10:25:10.393','2024-06-19 12:25:10.402'),('da1f6873-2e3a-11ef-8deb-d515ea58f6cb',2,'309e7124-2e35-11ef-8deb-d515ea58f6cb','Order 16.2',2,2,'WORKFLOW_2','{\"type\":\"ORDER\"}',0,'2024-06-19 14:52:58.069',NULL,'2024-06-19 14:58:23.750','2024-06-19 15:02:13.861','2024-06-19 13:02:13.861','2024-06-19 15:02:13.865'),('da355fe4-227c-11ef-8d76-d310d2ec2c14',2,'ce57500b-227c-11ef-8d76-d310d2ec2c14','Commande 3.1',1,2,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-04 16:15:10.000',NULL,'2024-06-19 09:40:31.930','2024-06-19 09:40:40.519','2024-06-19 07:40:40.520','2024-06-19 12:49:09.405'),('dd7db4ad-2e0d-11ef-8deb-d515ea58f6cb',2,'4382037a-2735-11ef-8e16-d517f37fa1ab','Analyse 6.2',2,2,'ANALYSE','{\"type\":\"ANALYSE\"}',0,'2024-06-19 09:30:56.367',NULL,'2024-06-19 09:30:56.412','2024-06-19 09:30:56.368','2024-06-19 07:30:59.302','2024-06-19 12:49:09.405'),('ddffc633-2e4d-11ef-8deb-d515ea58f6cb',2,'115617bc-2e4b-11ef-8deb-d515ea58f6cb','Order 17.3',3,2,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-19 17:09:05.010',NULL,'2024-06-19 17:45:31.390','2024-06-19 17:09:05.011','2024-06-19 15:45:31.391','2024-06-19 17:45:31.400'),('eab5fbfa-273c-11ef-8e16-d517f37fa1ab',2,'b8993188-273d-11ef-8e09-d517f1736dc8','Direct scan 11.1',1,2,'FREE','{\"type\":\"DIRECT_SCAN\"}',0,'2024-06-10 17:20:06.109',NULL,'2024-06-11 10:11:45.002','2024-06-10 17:25:51.739','2024-06-11 08:11:45.003','2024-06-11 10:11:45.013'),('eadc6274-27ca-11ef-8e37-d519fa9d22d2',2,'520a1417-2735-11ef-8e16-d517f37fa1ab','Commande 7.3',3,2,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-11 10:16:34.896',NULL,'2024-06-11 10:16:51.019','2024-06-11 10:17:19.462','2024-06-11 08:17:19.462','2024-06-11 10:17:19.465'),('eb7d58ee-2fa4-11ef-8e5c-d61b03bfb54e',2,'e67ea834-2fa4-11ef-8e5c-d61b03bfb54e','Order 18.1',1,2,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-21 10:04:45.087',NULL,'2024-06-21 10:06:31.004','2024-06-21 10:04:45.090','2024-06-21 08:06:31.004','2024-06-21 10:06:31.013'),('f2606f1c-2272-11ef-8d76-d310d2ec2c14',2,'dc803a78-225a-11ef-8f1f-d8242c71b430','Commande 1.2',2,2,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-04 15:04:15.979',NULL,'2024-06-17 16:39:51.313','2024-06-10 17:30:17.562','2024-06-17 14:39:51.313','2024-06-17 16:39:51.323'),('f2fea4e5-2731-11ef-8e16-d517f37fa1ab',2,'f3e99d3d-272f-11ef-8e16-d517f37fa1ab','Commande 4.2',2,2,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-10 16:01:35.000',NULL,'2024-06-10 16:02:32.000','2024-06-10 16:02:32.000','2024-06-10 14:02:37.000','2024-06-10 16:02:37.000'),('f3d1c83f-27d1-11ef-8e37-d519fa9d22d2',2,'a1ace9b5-2271-11ef-8d76-d310d2ec2c14','Commande 2.4',4,2,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-11 11:06:56.403',NULL,'2024-06-17 16:39:42.733','2024-06-11 11:06:56.404','2024-06-17 14:39:42.733','2024-06-17 16:39:42.743'),('f8ed0986-2e4c-11ef-8deb-d515ea58f6cb',2,'115617bc-2e4b-11ef-8deb-d515ea58f6cb','Direct scan 17.2',2,2,'FREE','{\"type\":\"DIRECT_SCAN\"}',0,'2024-06-19 17:02:40.689',NULL,'2024-06-19 17:03:49.237','2024-06-19 17:03:49.132','2024-06-19 15:03:49.237','2024-06-19 17:03:49.247'),('fe71f582-28bf-11ef-8e16-d517f37fa2ad',5,'82c4f551-28bf-11ef-8e16-d517f37fa2ad','Commande 4.1',1,1,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-12 15:30:54.452','2024-06-12 17:57:47.321','2024-06-12 16:45:09.304','2024-06-12 17:57:47.322','2024-06-12 15:57:47.322','2024-06-12 17:57:47.324'),('ff43b7ab-272f-11ef-8e16-d517f37fa1ab',2,'f3e99d3d-272f-11ef-8e16-d517f37fa1ab','Commande 4.1',1,2,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-10 15:47:37.000',NULL,'2024-06-10 15:48:24.000','2024-06-10 15:48:24.000','2024-06-10 13:48:26.000','2024-06-10 15:48:26.000');
/*!40000 ALTER TABLE `Act` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AddressInfo`
--

DROP TABLE IF EXISTS `AddressInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `AddressInfo` (
  `uuid` varchar(36) NOT NULL,
  `line0` varchar(255) DEFAULT NULL,
  `line1` varchar(255) DEFAULT NULL,
  `line2` varchar(255) DEFAULT NULL,
  `detail` varchar(255) DEFAULT NULL,
  `cityName` varchar(255) DEFAULT NULL,
  `cityState` varchar(255) DEFAULT NULL,
  `cityZip` varchar(255) DEFAULT NULL,
  `countryName` varchar(255) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AddressInfo`
--

LOCK TABLES `AddressInfo` WRITE;
/*!40000 ALTER TABLE `AddressInfo` DISABLE KEYS */;
INSERT INTO `AddressInfo` VALUES ('09d83830-5ef8-49ee-8a40-4089336cd88e','jbguy','','','','Ffgjh','','456','France','2024-06-12 09:50:50.563','2024-06-13 09:38:49.000'),('21c830ed-6a00-476f-a24f-e721cd2543d8','','','','','','','','','2024-06-04 12:15:38.000','2024-06-04 14:18:32.000'),('4caacc66-8838-11ec-89bc-2e174fce41cd','Route du test','','','','Toulouse','','31100','France','2024-06-03 15:04:56.000','2024-06-03 17:04:56.000'),('500b8a2a-af0c-40fb-ae0b-51f88f080fd3','','','','','','','','','2024-06-06 11:35:54.000','2024-06-06 13:35:54.000'),('5440e4c6-0dfa-455e-b4bc-20352f964660','','','','','labege','','','','2024-06-06 08:55:07.000','2024-06-06 10:55:07.000'),('7780848c-b087-4217-b3a5-e8cb992abbae','rue de Garance','','','','labège','','31670','France','2024-06-04 08:35:34.000','2024-06-13 10:47:51.000'),('8486e918-5618-46d8-8447-05ed7b508018','','','','','','','','','2024-06-12 10:03:15.711','2024-06-12 12:03:48.889'),('8b9099a7-67d1-4aca-aca7-5842f0768d4a','rue guarance','','','','Labège','','34670','France','2024-06-20 07:50:49.000','2024-06-20 11:27:46.000'),('94e607d4-dbbd-43f6-9902-9d0d590bbc8e','','','','','','','','','2024-06-04 12:32:17.000','2024-06-04 14:35:11.000'),('9e59686f-6b72-4c58-b004-da11a3b48afd','rue Garance','','','','Labège','','31670','France','2024-06-13 08:39:15.701','2024-06-20 14:19:39.000'),('a22123da-17c2-438f-97f9-9845680a644b','av. de Fleury','','','','salles d\'aude','','11110','France','2024-06-04 08:40:39.728','2024-06-13 10:54:45.000'),('a521e3a9-ad56-413f-990f-60c7817d6962','hbgdsfdsfvkds','','','','dfdgfg','','1111','United States of America','2024-06-04 09:28:57.814','2024-06-12 12:06:46.000'),('b625ed42-6f59-4c23-bfe5-3740f8716d69','','','','','','','','','2024-06-06 10:16:54.000','2024-06-06 12:16:55.000'),('b80e9030-b10a-4682-8fd0-28bff28b0c5f','','','','','gjygh','','','','2024-06-12 09:24:19.000','2024-06-12 11:24:19.000'),('c8db9302-3511-4c3f-b38d-de29e76d9f03','djfhgjfdhg','','','','sdfdsgsd','','11111','France','2024-06-04 09:24:55.000','2024-06-18 15:19:14.000'),('ecf22fc9-bdc8-44a6-aa69-c0d55825ca0e','','','','','','','','','2024-06-14 09:34:06.467','2024-06-19 11:30:07.298');
/*!40000 ALTER TABLE `AddressInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Analyse`
--

DROP TABLE IF EXISTS `Analyse`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Analyse` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `actId` varchar(36) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `type` enum('METERING','COMPARE') NOT NULL DEFAULT 'METERING',
  `displayId` mediumint(8) unsigned DEFAULT NULL,
  `pcId` mediumint(8) unsigned DEFAULT NULL,
  `comments` text DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `actId` (`actId`),
  CONSTRAINT `Analyse_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `Analyse_ibfk_2` FOREIGN KEY (`actId`) REFERENCES `Act` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Analyse`
--

LOCK TABLES `Analyse` WRITE;
/*!40000 ALTER TABLE `Analyse` DISABLE KEYS */;
INSERT INTO `Analyse` VALUES ('3596b1fd-2984-11ef-8e16-d517f37fa2ad',11,'35920e04-2984-11ef-8e16-d517f37fa2ad','','COMPARE',1,1,'{\"referenceScanId\":\"cd2aac3c-297d-11ef-8e16-d517f37fa2ad\"}','2024-06-13 14:55:28.326',NULL,'2024-06-13 12:56:12.196','2024-06-13 14:56:12.691'),('3921a3cd-297f-11ef-8e16-d517f37fa2ad',11,'391a9e5e-297f-11ef-8e16-d517f37fa2ad','','METERING',1,1,'{\"referenceScanId\":\"cd2aac3c-297d-11ef-8e16-d517f37fa2ad\"}','2024-06-13 14:19:46.786',NULL,'2024-06-13 12:19:55.191','2024-06-13 14:19:55.704'),('546fc1fa-2740-11ef-8e09-d517f1736dc8',2,'5467faec-2740-11ef-8e09-d517f1736dc8','','METERING',1,2,'{\"referenceScanId\":\"e0f66733-227c-11ef-8d76-d310d2ec2c14\"}','2024-06-10 17:44:31.977',NULL,'2024-06-10 15:44:40.060','2024-06-10 17:44:40.415'),('a3d2f769-2720-11ef-8e16-d517f37fa1ab',2,'a3cf95b8-2720-11ef-8e16-d517f37fa1ab','','COMPARE',1,2,'{\"referenceScanId\":\"1db1e2d3-271f-11ef-8e16-d517f37fa1ab\"}','2024-06-10 13:57:41.000',NULL,'2024-06-10 13:34:34.000','2024-06-10 15:34:34.000'),('c42f4bd1-28d3-11ef-8e16-d517f37fa2ad',5,'c425e233-28d3-11ef-8e16-d517f37fa2ad','Measurment 1','METERING',1,1,'{\"referenceScanId\":\"e57cd1ee-28c5-11ef-8e16-d517f37fa2ad\"}','2024-06-12 17:52:26.641',NULL,'2024-06-12 15:52:40.035','2024-06-12 17:52:40.587'),('d5c01f5d-297e-11ef-8e16-d517f37fa2ad',11,'d5b85a1b-297e-11ef-8e16-d517f37fa2ad','','COMPARE',1,1,'{\"referenceScanId\":\"47f95341-2963-11ef-8e16-d517f37fa2ad\"}','2024-06-13 14:17:00.053','2024-06-13 14:18:43.216','2024-06-13 12:18:43.216','2024-06-13 14:18:43.241'),('dd84e0d1-2e0d-11ef-8deb-d515ea58f6cb',2,'dd7db4ad-2e0d-11ef-8deb-d515ea58f6cb','','METERING',1,2,'{\"referenceScanId\":\"7b212ac0-2e0d-11ef-8deb-d515ea58f6cb\"}','2024-06-19 09:30:56.414',NULL,'2024-06-19 07:30:59.307','2024-06-19 12:49:52.918'),('e411249a-2e0d-11ef-8deb-d515ea58f6cb',2,'dd7db4ad-2e0d-11ef-8deb-d515ea58f6cb','','COMPARE',2,2,'{\"referenceScanId\":\"7b212ac0-2e0d-11ef-8deb-d515ea58f6cb\"}','2024-06-19 09:31:07.400',NULL,'2024-06-19 07:31:32.118','2024-06-19 12:49:52.918');
/*!40000 ALTER TABLE `Analyse` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AnalyseFile`
--

DROP TABLE IF EXISTS `AnalyseFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `AnalyseFile` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `analyseId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('TRANSFORMATION','SNAPSHOT','SCREENSHOT','METERING','RESULT') NOT NULL,
  PRIMARY KEY (`analyseId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `AnalyseFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `AnalyseFile_ibfk_2` FOREIGN KEY (`analyseId`) REFERENCES `Analyse` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `AnalyseFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AnalyseFile`
--

LOCK TABLES `AnalyseFile` WRITE;
/*!40000 ALTER TABLE `AnalyseFile` DISABLE KEYS */;
INSERT INTO `AnalyseFile` VALUES (11,'3596b1fd-2984-11ef-8e16-d517f37fa2ad','4fbc922f-2984-11ef-8e16-d517f37fa2ad','TRANSFORMATION'),(11,'3596b1fd-2984-11ef-8e16-d517f37fa2ad','50033512-2984-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(11,'3596b1fd-2984-11ef-8e16-d517f37fa2ad','872b9301-2984-11ef-8e16-d517f37fa2ad','TRANSFORMATION'),(11,'3596b1fd-2984-11ef-8e16-d517f37fa2ad','8782624a-2984-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(11,'3921a3cd-297f-11ef-8e16-d517f37fa2ad','3e23e6e9-297f-11ef-8e16-d517f37fa2ad','TRANSFORMATION'),(11,'3921a3cd-297f-11ef-8e16-d517f37fa2ad','3e7066a0-297f-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(11,'3921a3cd-297f-11ef-8e16-d517f37fa2ad','4833ab27-297f-11ef-8e16-d517f37fa2ad','SCREENSHOT'),(11,'3921a3cd-297f-11ef-8e16-d517f37fa2ad','4ec99c8e-297f-11ef-8e16-d517f37fa2ad','SCREENSHOT'),(11,'3921a3cd-297f-11ef-8e16-d517f37fa2ad','ee793ddb-297f-11ef-8e16-d517f37fa2ad','SCREENSHOT'),(11,'3921a3cd-297f-11ef-8e16-d517f37fa2ad','ef9a6543-297f-11ef-8e16-d517f37fa2ad','METERING'),(2,'546fc1fa-2740-11ef-8e09-d517f1736dc8','5940b0ad-2740-11ef-8e09-d517f1736dc8','TRANSFORMATION'),(2,'546fc1fa-2740-11ef-8e09-d517f1736dc8','5974ba96-2740-11ef-8e09-d517f1736dc8','SNAPSHOT'),(2,'a3d2f769-2720-11ef-8e16-d517f37fa1ab','39b26fd2-2721-11ef-8e16-d517f37fa1ab','METERING'),(2,'a3d2f769-2720-11ef-8e16-d517f37fa1ab','c2deb6fb-2720-11ef-8e16-d517f37fa1ab','TRANSFORMATION'),(2,'a3d2f769-2720-11ef-8e16-d517f37fa1ab','c32e1621-2720-11ef-8e16-d517f37fa1ab','SNAPSHOT'),(5,'c42f4bd1-28d3-11ef-8e16-d517f37fa2ad','cc2aab6f-28d3-11ef-8e16-d517f37fa2ad','TRANSFORMATION'),(5,'c42f4bd1-28d3-11ef-8e16-d517f37fa2ad','cc7d5d28-28d3-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(11,'d5c01f5d-297e-11ef-8e16-d517f37fa2ad','0bf0e3fa-297f-11ef-8e16-d517f37fa2ad','TRANSFORMATION'),(11,'d5c01f5d-297e-11ef-8e16-d517f37fa2ad','0c4e0406-297f-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(2,'dd84e0d1-2e0d-11ef-8deb-d515ea58f6cb','df3e0119-2e0d-11ef-8deb-d515ea58f6cb','TRANSFORMATION'),(2,'dd84e0d1-2e0d-11ef-8deb-d515ea58f6cb','df790a58-2e0d-11ef-8deb-d515ea58f6cb','SNAPSHOT'),(2,'e411249a-2e0d-11ef-8deb-d515ea58f6cb','f2ccaed8-2e0d-11ef-8deb-d515ea58f6cb','TRANSFORMATION'),(2,'e411249a-2e0d-11ef-8deb-d515ea58f6cb','f31f7ba6-2e0d-11ef-8deb-d515ea58f6cb','SNAPSHOT');
/*!40000 ALTER TABLE `AnalyseFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AnalyseScan`
--

DROP TABLE IF EXISTS `AnalyseScan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `AnalyseScan` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `analyseId` varchar(36) NOT NULL,
  `scanId` varchar(36) NOT NULL,
  PRIMARY KEY (`analyseId`,`scanId`),
  KEY `ownerId` (`ownerId`),
  KEY `scanId` (`scanId`),
  CONSTRAINT `AnalyseScan_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `AnalyseScan_ibfk_2` FOREIGN KEY (`analyseId`) REFERENCES `Analyse` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `AnalyseScan_ibfk_3` FOREIGN KEY (`scanId`) REFERENCES `Scan` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AnalyseScan`
--

LOCK TABLES `AnalyseScan` WRITE;
/*!40000 ALTER TABLE `AnalyseScan` DISABLE KEYS */;
INSERT INTO `AnalyseScan` VALUES (2,'546fc1fa-2740-11ef-8e09-d517f1736dc8','e0f66733-227c-11ef-8d76-d310d2ec2c14'),(2,'a3d2f769-2720-11ef-8e16-d517f37fa1ab','1db1e2d3-271f-11ef-8e16-d517f37fa1ab'),(2,'a3d2f769-2720-11ef-8e16-d517f37fa1ab','424c596f-2720-11ef-8e16-d517f37fa1ab'),(2,'dd84e0d1-2e0d-11ef-8deb-d515ea58f6cb','7b212ac0-2e0d-11ef-8deb-d515ea58f6cb'),(2,'e411249a-2e0d-11ef-8deb-d515ea58f6cb','7b212ac0-2e0d-11ef-8deb-d515ea58f6cb'),(2,'e411249a-2e0d-11ef-8deb-d515ea58f6cb','bfa3d876-2735-11ef-8e16-d517f37fa1ab'),(5,'c42f4bd1-28d3-11ef-8e16-d517f37fa2ad','e57cd1ee-28c5-11ef-8e16-d517f37fa2ad'),(11,'3596b1fd-2984-11ef-8e16-d517f37fa2ad','099d82e1-2980-11ef-8e16-d517f37fa2ad'),(11,'3596b1fd-2984-11ef-8e16-d517f37fa2ad','cd2aac3c-297d-11ef-8e16-d517f37fa2ad'),(11,'3921a3cd-297f-11ef-8e16-d517f37fa2ad','cd2aac3c-297d-11ef-8e16-d517f37fa2ad'),(11,'d5c01f5d-297e-11ef-8e16-d517f37fa2ad','47f95341-2963-11ef-8e16-d517f37fa2ad'),(11,'d5c01f5d-297e-11ef-8e16-d517f37fa2ad','cd2aac3c-297d-11ef-8e16-d517f37fa2ad');
/*!40000 ALTER TABLE `AnalyseScan` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Assistant`
--

DROP TABLE IF EXISTS `Assistant`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Assistant` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `credentialsId` varchar(36) DEFAULT NULL,
  `personInfoId` varchar(36) NOT NULL,
  `phoneInfoId` varchar(36) NOT NULL,
  `addressInfoId` varchar(36) NOT NULL,
  `officeId` varchar(36) DEFAULT NULL,
  `patientRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'READ_ONLY',
  `actRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'NOTHING',
  `discussionRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'NOTHING',
  `tempPassword` varchar(32) DEFAULT NULL,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `credentialsId` (`credentialsId`),
  KEY `personInfoId` (`personInfoId`),
  KEY `phoneInfoId` (`phoneInfoId`),
  KEY `addressInfoId` (`addressInfoId`),
  KEY `officeId` (`officeId`),
  CONSTRAINT `Assistant_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_2` FOREIGN KEY (`credentialsId`) REFERENCES `Credentials` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_3` FOREIGN KEY (`personInfoId`) REFERENCES `PersonInfo` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_4` FOREIGN KEY (`phoneInfoId`) REFERENCES `PhoneInfo` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_5` FOREIGN KEY (`addressInfoId`) REFERENCES `AddressInfo` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_6` FOREIGN KEY (`officeId`) REFERENCES `Office` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Assistant`
--

LOCK TABLES `Assistant` WRITE;
/*!40000 ALTER TABLE `Assistant` DISABLE KEYS */;
INSERT INTO `Assistant` VALUES ('278341b0-226c-11ef-8f1f-d8242c71b430',2,'b6ffbf80-89c9-494d-b7aa-c32d17187d3e','ea8bca69-75b7-4877-8406-eca77b86cb2f','a8b2657e-dca8-42a8-a6cd-7b3dfcdacfac','21c830ed-6a00-476f-a24f-e721cd2543d8','1851efb6-58e7-4b73-b221-a63ec0947b77','READ_ONLY','NOTHING','NOTHING','wi6nx9Y2',NULL,'2024-06-04 14:15:38.000','2024-06-04 12:18:32.000','2024-06-04 14:18:32.000'),('3d155cb6-2a31-11ef-8f1c-d8242c6fa8fd',11,'95e1b195-3a24-4f05-9546-b8660fff20fe','e1fdc45a-71cd-4786-91aa-24b8c296e795','181dec75-7fb5-4d17-8bd9-d6a9f0c0881d','ecf22fc9-bdc8-44a6-aa69-c0d55825ca0e','b01f8f4e-2948-4022-b79e-b9e2986b47ea','READ_WRITE','READ_ONLY','NOTHING','',NULL,'2024-06-19 10:18:47.216','2024-06-19 08:18:47.216','2024-06-19 11:30:07.298'),('7af0c969-226e-11ef-8f1f-d8242c71b430',2,'52a4fd68-0b4c-451c-8ba7-97e0083d1392','8bb7d06d-0faf-4fbe-9a3e-bf2a50402277','8caa4c94-c597-4679-ba07-d658d15edbb0','94e607d4-dbbd-43f6-9902-9d0d590bbc8e','1851efb6-58e7-4b73-b221-a63ec0947b77','READ_ONLY','NOTHING','NOTHING','WPh9isP9',NULL,'2024-06-04 14:32:17.000','2024-06-04 12:35:11.000','2024-06-04 14:35:11.000'),('fb6063a4-28a2-11ef-8e16-d517f37fa2ad',5,'9efecb15-ce6e-4f75-936f-8ca618cb191f','08ea5eaa-7ae4-4bfb-b7b0-4672e82009b2','db262193-346e-4bf6-9240-112d28c9e66d','8486e918-5618-46d8-8447-05ed7b508018','4a6b3695-fa93-4a3f-9378-90bb33d7f846','READ_ONLY','READ_ONLY','NOTHING','',NULL,'2024-06-12 12:03:48.886','2024-06-12 10:03:48.887','2024-06-12 12:03:48.889');
/*!40000 ALTER TABLE `Assistant` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CircleOrder`
--

DROP TABLE IF EXISTS `CircleOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `CircleOrder` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `actId` varchar(36) NOT NULL,
  `title` varchar(64) DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT 0,
  `createdById` varchar(36) DEFAULT NULL,
  `updatedById` varchar(36) DEFAULT NULL,
  `displayId` mediumint(8) unsigned DEFAULT NULL,
  `pcId` mediumint(8) unsigned DEFAULT NULL,
  `json` text NOT NULL,
  `metadata` text NOT NULL,
  `status` enum('NOT_SENT','WAITING_WOW_API','SENDING_WOW_API','SENDING_CIRCLE_API','SENT','CANCELLED','DELIVERY') NOT NULL DEFAULT 'NOT_SENT',
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `actId` (`actId`),
  CONSTRAINT `CircleOrder_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `CircleOrder_ibfk_2` FOREIGN KEY (`actId`) REFERENCES `Act` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CircleOrder`
--

LOCK TABLES `CircleOrder` WRITE;
/*!40000 ALTER TABLE `CircleOrder` DISABLE KEYS */;
/*!40000 ALTER TABLE `CircleOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CircleOrderFile`
--

DROP TABLE IF EXISTS `CircleOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `CircleOrderFile` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('FORM','SCAN') NOT NULL,
  PRIMARY KEY (`orderId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `CircleOrderFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `CircleOrderFile_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `CircleOrder` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `CircleOrderFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CircleOrderFile`
--

LOCK TABLES `CircleOrderFile` WRITE;
/*!40000 ALTER TABLE `CircleOrderFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `CircleOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Config`
--

DROP TABLE IF EXISTS `Config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Config` (
  `id` mediumint(8) unsigned NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `options` text DEFAULT NULL COMMENT 'Software configuration values as json',
  `syncEnabled` tinyint(1) DEFAULT 1,
  `showOpenStlWarning` tinyint(1) DEFAULT 1,
  `emailNotifications` tinyint(1) DEFAULT 1,
  `logout` mediumint(8) DEFAULT 10,
  `language` varchar(2) DEFAULT NULL,
  `customColorLut` text DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  PRIMARY KEY (`id`,`ownerId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Config`
--

LOCK TABLES `Config` WRITE;
/*!40000 ALTER TABLE `Config` DISABLE KEYS */;
INSERT INTO `Config` VALUES (1,1,'',1,1,1,10,'FR',NULL,'2024-06-03 17:04:56.000','2024-06-03 17:04:56.000','2024-06-03 15:04:56.000'),(1,2,'{\"ordersTableColumnsConfig\":{\"filtering\":[true,true,true,true,true,false],\"sorting\":[{\"order\":1,\"role\":\"fullDisplayId\"},{\"order\":1,\"role\":\"orderDetails\"},{\"order\":1,\"role\":\"recipientSortName\"},{\"order\":1,\"role\":\"patientSortName\"},{\"order\":1,\"role\":\"internalStatusText\"},{\"order\":1,\"role\":\"lastModified\"}]},\"showAllPatients\":true,\"trackingFlipMaxillary\":false,\"trackingLostIndicator\":false}',1,1,1,10,'UK',NULL,'2024-06-04 10:35:34.000','2024-06-13 10:47:51.000','2024-06-21 08:04:05.460'),(1,3,'{\"ordersTableColumnsConfig\":{\"filtering\":[true,true,true,true,false,false],\"sorting\":[{\"order\":1,\"role\":\"internalStatusText\"},{\"order\":0,\"role\":\"patientSortName\"},{\"order\":0,\"role\":\"recipientSortName\"},{\"order\":0,\"role\":\"orderDetails\"},{\"order\":0,\"role\":\"fullDisplayId\"},{\"order\":1,\"role\":\"lastModified\"}]},\"showAllPatients\":true}',1,1,1,10,'UK',NULL,'2024-06-04 10:40:35.000','2024-06-13 10:54:45.000','2024-06-20 09:26:25.202'),(1,4,'{\"ordersTableColumnsConfig\":{\"filtering\":[true,true,true,true,false,false],\"sorting\":[{\"order\":1,\"role\":\"internalStatusText\"},{\"order\":0,\"role\":\"patientSortName\"},{\"order\":0,\"role\":\"recipientSortName\"},{\"order\":0,\"role\":\"orderDetails\"},{\"order\":0,\"role\":\"fullDisplayId\"},{\"order\":1,\"role\":\"lastModified\"}]},\"showAllPatients\":true,\"showNotificationDeleteConfirmation\":true,\"trackingFlipMandible\":false,\"trackingFlipMaxillary\":false,\"trackingLagSound\":true,\"trackingLostSound\":true}',1,1,1,30,'FR',NULL,'2024-06-04 11:24:55.000','2024-06-18 15:19:14.000','2024-06-19 10:45:04.000'),(1,5,'{\"ordersTableColumnsConfig\":{\"filtering\":[true,true,false,true,false,false],\"sorting\":[{\"order\":1,\"role\":\"patientSortName\"},{\"order\":0,\"role\":\"recipientSortName\"},{\"order\":0,\"role\":\"orderDetails\"},{\"order\":1,\"role\":\"fullDisplayId\"},{\"order\":0,\"role\":\"internalStatusText\"},{\"order\":1,\"role\":\"lastModified\"}]},\"showAllPatients\":true}',1,1,1,30,'FR',NULL,'2024-06-04 11:28:55.000','2024-06-12 12:06:46.000','2024-06-13 08:22:12.060'),(1,6,'',1,1,1,10,'FR',NULL,'2024-06-06 10:47:25.000','2024-06-06 10:55:07.000','2024-06-06 08:47:25.000'),(1,7,'',1,1,1,10,'FR',NULL,'2024-06-06 12:16:54.000','2024-06-06 12:16:55.000','2024-06-06 10:16:54.000'),(1,8,'',1,1,1,10,'FR',NULL,'2024-06-06 13:35:54.000','2024-06-06 13:35:54.000','2024-06-06 11:35:54.000'),(1,9,'',1,1,1,10,'FR',NULL,'2024-06-12 11:21:59.000','2024-06-12 11:24:19.000','2024-06-12 09:21:59.000'),(1,10,'',1,1,1,10,'FR',NULL,'2024-06-12 11:50:49.000','2024-06-13 09:38:49.000','2024-06-12 09:50:50.568'),(1,11,'{\"ordersTableColumnsConfig\":{\"filtering\":[true,true,true,true,true,false],\"sorting\":[{\"order\":1,\"role\":\"internalStatusText\"},{\"order\":0,\"role\":\"patientSortName\"},{\"order\":0,\"role\":\"recipientSortName\"},{\"order\":0,\"role\":\"orderDetails\"},{\"order\":0,\"role\":\"fullDisplayId\"},{\"order\":1,\"role\":\"lastModified\"}]},\"showAllPatients\":true,\"trackingLostIndicator\":false}',1,1,1,10,'IT',NULL,'2024-06-13 10:39:12.000','2024-06-20 14:19:39.000','2024-06-20 12:47:55.238'),(1,12,'{\"ordersTableColumnsConfig\":{\"filtering\":[true,true,true,true,true,false],\"sorting\":[{\"order\":1,\"role\":\"internalStatusText\"},{\"order\":0,\"role\":\"patientSortName\"},{\"order\":0,\"role\":\"recipientSortName\"},{\"order\":0,\"role\":\"orderDetails\"},{\"order\":0,\"role\":\"fullDisplayId\"},{\"order\":1,\"role\":\"lastModified\"}]},\"showAllPatients\":true,\"trackingLostIndicator\":false}',1,1,1,10,'FR',NULL,'2024-06-20 09:50:49.000','2024-06-20 11:27:46.000','2024-06-20 11:26:24.000');
/*!40000 ALTER TABLE `Config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Contact`
--

DROP TABLE IF EXISTS `Contact`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Contact` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `professionalId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel contact',
  `officeId` varchar(36) DEFAULT NULL,
  `status` enum('INVITATIONSENT','INVITATIONRECEIVED','ACCEPTED','REJECTED') NOT NULL DEFAULT 'INVITATIONSENT',
  `comments` text DEFAULT NULL,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `uniqueContactPro` (`ownerId`,`professionalId`),
  KEY `professionalId` (`professionalId`),
  KEY `officeId` (`officeId`),
  CONSTRAINT `Contact_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `Contact_ibfk_2` FOREIGN KEY (`professionalId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `Contact_ibfk_3` FOREIGN KEY (`officeId`) REFERENCES `Office` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Contact`
--

LOCK TABLES `Contact` WRITE;
/*!40000 ALTER TABLE `Contact` DISABLE KEYS */;
INSERT INTO `Contact` VALUES ('0a2963fd-83d3-4097-855c-d014d51f230e',2,12,NULL,'ACCEPTED','',NULL,'2024-06-20 11:22:51.000','2024-06-20 09:27:46.000','2024-06-20 11:27:46.000'),('277ab19c-36e7-41ed-89b9-4dda2501e936',3,12,NULL,'ACCEPTED','',NULL,'2024-06-20 11:27:59.000','2024-06-20 09:27:59.000','2024-06-20 11:27:59.000'),('4ed4ce00-4b30-4601-95bb-ede535f19c6b',2,4,NULL,'ACCEPTED','',NULL,'2024-06-04 13:59:28.000','2024-06-18 13:19:14.000','2024-06-18 15:19:14.000'),('57a94929-f9c0-438e-b77e-c2432d03181d',2,2,NULL,'ACCEPTED','',NULL,'2024-06-04 10:35:34.000','2024-06-13 08:47:51.000','2024-06-13 10:47:51.000'),('5817ca50-da74-40f6-a56f-d00bb8140a84',3,3,NULL,'ACCEPTED','',NULL,'2024-06-04 10:40:35.000','2024-06-13 08:54:45.000','2024-06-13 10:54:45.000'),('7c2adbb8-f64b-4654-bf3e-bed35e01c424',11,2,NULL,'ACCEPTED','',NULL,'2024-06-13 11:18:04.000','2024-06-13 09:18:04.000','2024-06-13 11:18:04.000'),('8a8dc1d0-2120-4582-ae83-b39e52930645',11,1,NULL,'ACCEPTED','',NULL,'2024-06-13 10:39:12.000','2024-06-13 08:39:12.000','2024-06-13 10:39:12.000'),('8bf37f34-a286-425a-b07e-833e7740c824',10,10,NULL,'ACCEPTED','',NULL,'2024-06-12 11:50:49.000','2024-06-12 12:41:31.000','2024-06-12 14:41:31.000'),('8c9211a3-db43-4c11-be57-738bafda56b1',10,5,NULL,'ACCEPTED','',NULL,'2024-06-12 11:52:13.000','2024-06-12 10:06:46.000','2024-06-12 12:06:46.000'),('8fbd79fd-0e86-49b8-9558-3a507eb19750',2,3,NULL,'ACCEPTED','',NULL,'2024-06-04 12:25:41.000','2024-06-13 08:54:45.000','2024-06-13 10:54:45.000'),('98fca350-1328-4c00-87ff-fd100500f576',3,11,NULL,'ACCEPTED','',NULL,'2024-06-13 15:08:39.000','2024-06-19 10:07:01.000','2024-06-19 12:07:01.000'),('a50cb907-4db3-48f3-9808-0ae18d8dccdb',3,6,NULL,'ACCEPTED','',NULL,'2024-06-06 10:55:29.000','2024-06-06 08:55:29.000','2024-06-06 10:55:29.000'),('a664f09d-da86-42d0-b54a-2672898db522',3,2,NULL,'ACCEPTED','',NULL,'2024-06-04 12:25:41.000','2024-06-13 08:47:51.000','2024-06-13 10:47:51.000'),('b3bdb885-0342-4387-8964-ad240409ab44',10,1,NULL,'ACCEPTED','',NULL,'2024-06-12 11:50:49.000','2024-06-12 09:50:49.000','2024-06-12 11:50:49.000'),('b3c37c04-0470-43df-bb61-f33530e663f1',11,3,NULL,'ACCEPTED','',NULL,'2024-06-13 15:08:39.000','2024-06-13 13:08:39.000','2024-06-13 15:08:39.000'),('c46662de-1008-44d2-ae2c-c14f0c94c0d8',11,11,NULL,'ACCEPTED','',NULL,'2024-06-13 10:39:12.000','2024-06-20 12:19:39.000','2024-06-20 14:19:39.000'),('c6d85afc-b282-41b1-9b22-5e1159f3d1c0',5,10,NULL,'INVITATIONSENT','',NULL,'2024-06-13 09:38:47.000','2024-06-13 07:38:49.000','2024-06-13 09:38:49.000'),('c6f88ce8-d6e3-44ca-b07b-c13992c4abb8',5,9,NULL,'ACCEPTED','',NULL,'2024-06-12 11:24:32.000','2024-06-12 09:24:32.000','2024-06-12 11:24:32.000'),('ca42284a-209a-4655-9371-ebd08d5a657d',2,1,NULL,'ACCEPTED','',NULL,'2024-06-04 10:35:34.000','2024-06-04 08:35:34.000','2024-06-04 10:35:34.000'),('ccc73fab-ccfe-4862-b2bd-90f0a1c56566',5,2,NULL,'ACCEPTED','',NULL,'2024-06-10 16:08:58.228','2024-06-10 14:08:58.229','2024-06-10 16:08:58.241'),('ddaf1074-a13e-459d-ab8a-83ce1d832cdc',2,11,NULL,'ACCEPTED','',NULL,'2024-06-13 11:18:04.000','2024-06-20 12:19:39.000','2024-06-20 14:19:39.000'),('f06fd9e4-900c-420e-abcb-d93ab9671678',2,7,NULL,'INVITATIONSENT','',NULL,'2024-06-06 12:16:54.000','2024-06-06 10:16:55.000','2024-06-06 12:16:55.000'),('f59d888e-123c-451a-a8b6-5e46affc6317',5,1,NULL,'ACCEPTED','',NULL,'2024-06-04 11:28:55.000','2024-06-04 09:28:55.000','2024-06-04 11:28:55.000'),('f765045a-2805-40b5-9a87-63af78cc2071',2,5,NULL,'ACCEPTED','',NULL,'2024-06-10 16:08:58.000','2024-06-12 10:06:46.000','2024-06-12 12:06:46.000'),('f91aa56d-809a-4c91-af6a-40c1c34464de',5,5,NULL,'ACCEPTED','',NULL,'2024-06-04 11:28:55.000','2024-06-12 10:06:46.000','2024-06-12 12:06:46.000'),('fd00b931-034c-4d7b-8071-0455da26e33b',2,8,NULL,'REJECTED','',NULL,'2024-06-06 13:38:10.000','2024-06-06 11:38:10.000','2024-06-06 13:38:10.000');
/*!40000 ALTER TABLE `Contact` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ContactNotification`
--

DROP TABLE IF EXISTS `ContactNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ContactNotification` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `contactId` varchar(36) DEFAULT NULL,
  `rescueDisplayName` varchar(50) DEFAULT NULL,
  `event` enum('RECEIVED','RECEIVED_TO_ACCEPTED','RECEIVED_TO_REJECTED','SENT_TO_ACCEPTED','SENT_TO_REJECTED','ACTIVATION_TIMEOUT') NOT NULL DEFAULT 'RECEIVED',
  `unread` tinyint(1) NOT NULL DEFAULT 1,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `contactId` (`contactId`),
  CONSTRAINT `ContactNotification_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `ContactNotification_ibfk_2` FOREIGN KEY (`contactId`) REFERENCES `Contact` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ContactNotification`
--

LOCK TABLES `ContactNotification` WRITE;
/*!40000 ALTER TABLE `ContactNotification` DISABLE KEYS */;
INSERT INTO `ContactNotification` VALUES ('021103e4-aefa-497a-ab4d-38e90c4d2db5',3,'277ab19c-36e7-41ed-89b9-4dda2501e936','simone scalzo','SENT_TO_ACCEPTED',1,'2024-06-20 11:27:59.000',NULL,'2024-06-20 09:27:59.000','2024-06-20 11:27:59.000'),('16bf0d28-5e1f-410a-8195-d234bccb933a',2,'0a2963fd-83d3-4097-855c-d014d51f230e','simone scalzo','RECEIVED_TO_ACCEPTED',0,'2024-06-20 11:22:00.000',NULL,'2024-06-20 09:22:52.000','2024-06-20 11:22:52.000'),('3486d3fb-a61a-459e-9676-385e40310357',2,'ddaf1074-a13e-459d-ab8a-83ce1d832cdc','simone scalzo','RECEIVED_TO_ACCEPTED',0,'2024-06-13 10:47:50.000','2024-06-13 11:38:27.000','2024-06-13 09:38:27.000','2024-06-13 11:38:27.000'),('365f4841-86de-4ec0-8280-b1286a518ed4',5,'ccc73fab-ccfe-4862-b2bd-90f0a1c56566','sabine casertA','RECEIVED_TO_ACCEPTED',0,'2024-06-04 13:58:23.000','2024-06-12 11:42:39.050','2024-06-12 09:42:39.050','2024-06-12 11:42:39.060'),('391b47d4-902a-4033-af1e-8a9111a3c2ac',3,'98fca350-1328-4c00-87ff-fd100500f576','simone scalzo','RECEIVED_TO_ACCEPTED',0,'2024-06-13 10:54:44.000',NULL,'2024-06-13 13:08:39.000','2024-06-13 15:08:39.000'),('4cc1b9f1-3f7e-45e4-9dc1-23dc17ad673d',2,'f765045a-2805-40b5-9a87-63af78cc2071','demo4 demo4env2','SENT_TO_ACCEPTED',0,'2024-06-10 16:08:58.000','2024-06-13 11:38:27.000','2024-06-13 09:38:27.000','2024-06-13 11:38:27.000'),('70e65319-75d9-46ec-abbd-9040e767f5aa',3,'a664f09d-da86-42d0-b54a-2672898db522','sabine casertA','RECEIVED_TO_ACCEPTED',0,'2024-06-04 12:25:07.000',NULL,'2024-06-04 10:25:41.496','2024-06-04 12:25:41.500'),('75ac707e-8f07-45a9-bf2f-e0f220caaa2b',5,'c6d85afc-b282-41b1-9b22-5e1159f3d1c0','User_demo5 Env2','RECEIVED_TO_ACCEPTED',0,'2024-06-12 11:51:24.000','2024-06-12 11:52:16.176','2024-06-12 09:52:16.177','2024-06-12 11:52:16.181'),('7788e8b3-5e37-4cea-a582-ae301cf40d35',10,'8c9211a3-db43-4c11-be57-738bafda56b1','demo4 demo4env2','SENT_TO_ACCEPTED',1,'2024-06-12 11:52:13.000',NULL,'2024-06-12 09:52:13.000','2024-06-12 11:52:13.000'),('78d6b65e-f462-4964-83f6-d652fcd675db',11,'7c2adbb8-f64b-4654-bf3e-bed35e01c424','sabine casertA','SENT_TO_ACCEPTED',1,'2024-06-13 11:18:04.000',NULL,'2024-06-13 09:18:04.000','2024-06-13 11:18:04.000'),('8df36b38-6daf-4ea2-95c4-9ab9cca0cddb',11,'b3c37c04-0470-43df-bb61-f33530e663f1','succursalle Salles d\'aude laboratoire scan4all','SENT_TO_ACCEPTED',1,'2024-06-13 15:08:39.000',NULL,'2024-06-13 13:08:39.000','2024-06-13 15:08:39.000'),('a221ca5b-c1b3-430b-9f1d-d23ba7a235d1',5,'c6f88ce8-d6e3-44ca-b07b-c13992c4abb8','Web User','SENT_TO_ACCEPTED',0,'2024-06-12 11:24:32.000','2024-06-12 11:42:40.000','2024-06-12 09:42:40.000','2024-06-12 11:42:40.000'),('ae5b0efc-c662-47e3-bf0c-e0d37373070b',2,'8fbd79fd-0e86-49b8-9558-3a507eb19750','succursalle Salles d\'aude laboratoire scan4all','SENT_TO_ACCEPTED',0,'2024-06-04 12:25:41.000','2024-06-05 14:12:38.000','2024-06-05 12:12:38.000','2024-06-05 14:12:38.000'),('dde68b2b-58f8-427a-81f2-b97a3cedb316',3,'a50cb907-4db3-48f3-9808-0ae18d8dccdb','client leger','SENT_TO_ACCEPTED',0,'2024-06-06 10:55:29.000',NULL,'2024-06-06 09:04:04.000','2024-06-06 11:04:04.000'),('f4351802-7e0b-42c0-a5b3-f537dfd6bdfe',2,'4ed4ce00-4b30-4601-95bb-ede535f19c6b','demo3 demo3env1','SENT_TO_ACCEPTED',0,'2024-06-04 13:59:28.000','2024-06-05 14:12:37.000','2024-06-05 12:12:37.000','2024-06-05 14:12:37.000');
/*!40000 ALTER TABLE `ContactNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Credentials`
--

DROP TABLE IF EXISTS `Credentials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Credentials` (
  `uuid` varchar(36) NOT NULL,
  `login` varchar(255) NOT NULL,
  `password` varchar(100) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `login` (`login`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Credentials`
--

LOCK TABLES `Credentials` WRITE;
/*!40000 ALTER TABLE `Credentials` DISABLE KEYS */;
INSERT INTO `Credentials` VALUES ('2e995095-88b2-11ec-89bc-2e174fce41cd','biotech',NULL,'2024-06-03 15:04:56.000','2024-06-03 17:04:56.000'),('2f905a47-4c1c-4733-a6c0-6850e9be6b5f','simone-scalzo',NULL,'2024-06-20 07:50:49.000','2024-06-20 11:27:46.000'),('357013df-fab4-4e08-a0b3-25be5d10fb9e','gamajesas@hotmail.fr',NULL,'2024-06-06 08:55:07.000','2024-06-06 10:55:07.000'),('52a4fd68-0b4c-451c-8ba7-97e0083d1392','azerty5@az.fr',NULL,'2024-06-04 12:32:17.000','2024-06-04 14:35:11.000'),('5e4021c3-eb63-4c78-98e3-e52e93179159','test_application',NULL,'2024-06-12 09:24:19.000','2024-06-12 11:24:19.000'),('66d7dc11-0d36-4d25-9823-f7f0c1d1f38a','Simone.Scalzo','73e0b8d5ffc27bb4490f4a70b9221def8ca28bee0dc8794fc8e49ecff9e9ba40','2024-06-13 08:39:15.698','2024-06-20 14:19:39.000'),('7a0e3a28-a28c-4323-92c1-8831f0d6815b','demo3',NULL,'2024-06-04 09:24:55.000','2024-06-18 15:19:14.000'),('83184b42-53a8-43e0-964a-e3b8d3a2acbf','iris','b7c9d95548ee05e8e7bb3d8852f2e7ef43f994d9f5fce8998f94a4226ad3fa49','2024-06-19 14:48:43.521','2024-06-13 10:47:51.000'),('95e1b195-3a24-4f05-9546-b8660fff20fe','assistenti@az.fr','4712398233e607102f4bad18449d24aaa6cf7e6aebde9de38c34051ba908c0f8','2024-06-14 09:36:55.528','2024-06-19 11:30:07.298'),('9efecb15-ce6e-4f75-936f-8ca618cb191f','assist1@mail.com','a7a2cdb20571c16972552d56a1dec593e48edba228f5ff9f0ecbaa875473e7ad','2024-06-12 10:03:48.877','2024-06-12 12:03:48.889'),('adc06de1-bf5d-4b1a-81dc-e5e919328b7c','demo2','3b3d4e9a5ac7cde03a41c782976f5687a7ba7cd84c908cf1c1f7b567cfd0bbc2','2024-06-06 08:45:18.377','2024-06-13 10:54:45.000'),('b35f432d-f5a0-4048-b2dc-1eb3596a89a1','demo4','a601e1e733d5e1f3e3c7ef35a650d41a6a38a51625a1d547050bcc67de50c0a0','2024-06-04 09:28:57.803','2024-06-12 12:06:46.000'),('b6ffbf80-89c9-494d-b7aa-c32d17187d3e','poiu1@az.fr',NULL,'2024-06-04 12:15:38.000','2024-06-04 14:18:32.000'),('e777d5c7-3598-4093-b42c-8342c0d4d52e','demo5','a7a2cdb20571c16972552d56a1dec593e48edba228f5ff9f0ecbaa875473e7ad','2024-06-12 12:43:44.767','2024-06-13 09:38:49.000');
/*!40000 ALTER TABLE `Credentials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Discussion`
--

DROP TABLE IF EXISTS `Discussion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Discussion` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `selfImplied` tinyint(1) NOT NULL DEFAULT 0,
  `officeId` varchar(36) DEFAULT NULL,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`,`ownerId`),
  KEY `ownerId` (`ownerId`),
  KEY `officeId` (`officeId`),
  CONSTRAINT `Discussion_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `Discussion_ibfk_2` FOREIGN KEY (`officeId`) REFERENCES `Office` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Discussion`
--

LOCK TABLES `Discussion` WRITE;
/*!40000 ALTER TABLE `Discussion` DISABLE KEYS */;
INSERT INTO `Discussion` VALUES ('0f3dfe44-225d-11ef-8f1f-d8242c71b430',2,0,NULL,NULL,'2024-06-04 12:27:41.338','2024-06-20 09:38:43.000','2024-06-20 11:38:43.000'),('0f3dfe44-225d-11ef-8f1f-d8242c71b430',3,0,NULL,NULL,'2024-06-04 12:27:41.336','2024-06-20 09:38:43.000','2024-06-20 11:38:43.000'),('1a8fdf3a-296b-11ef-8e16-d517f37fa2ad',2,0,NULL,NULL,'2024-06-13 11:55:45.565','2024-06-17 13:16:57.000','2024-06-17 15:16:57.000'),('1a8fdf3a-296b-11ef-8e16-d517f37fa2ad',11,0,NULL,NULL,'2024-06-13 11:55:45.565','2024-06-17 13:16:57.000','2024-06-17 15:16:57.000'),('3d61afe1-2986-11ef-8e16-d517f37fa2ad',3,0,NULL,NULL,'2024-06-13 15:10:00.394','2024-06-20 09:38:53.000','2024-06-20 11:38:53.000'),('3d61afe1-2986-11ef-8e16-d517f37fa2ad',11,0,NULL,NULL,'2024-06-13 15:10:00.394','2024-06-20 09:38:53.000','2024-06-20 11:38:53.000'),('550eb27a-226b-11ef-8f1f-d8242c71b430',2,0,NULL,NULL,'2024-06-04 14:11:38.784','2024-06-17 15:02:00.000','2024-06-17 17:02:00.000'),('550eb27a-226b-11ef-8f1f-d8242c71b430',4,0,NULL,NULL,'2024-06-04 14:11:38.788','2024-06-04 12:10:47.000',NULL),('82a44e97-2ee8-11ef-8dc9-d414e3397395',2,0,NULL,NULL,'2024-06-21 10:02:59.449','2024-06-21 08:02:59.000','2024-06-21 10:02:59.000'),('82a44e97-2ee8-11ef-8dc9-d414e3397395',12,0,NULL,NULL,'2024-06-21 10:02:59.455','2024-06-20 10:40:01.000',NULL),('88f9012b-28a0-11ef-8e16-d517f37fa2ad',1,0,NULL,NULL,'2024-06-12 11:45:42.980','2024-06-12 09:45:42.980',NULL),('88f9012b-28a0-11ef-8e16-d517f37fa2ad',5,0,NULL,NULL,'2024-06-12 11:45:42.970','2024-06-12 09:45:44.000','2024-06-12 11:45:44.000'),('8e7e9088-2733-11ef-8e16-d517f37fa1ab',2,0,NULL,NULL,'2024-06-10 16:13:05.927','2024-06-19 15:09:55.000','2024-06-19 17:09:55.000'),('8e7e9088-2733-11ef-8e16-d517f37fa1ab',5,0,NULL,NULL,'2024-06-10 16:13:05.941','2024-06-12 09:42:13.000','2024-06-12 11:42:13.000'),('ae662f01-27ca-11ef-8e37-d519fa9d22d2',2,1,NULL,NULL,'2024-06-11 10:14:53.460','2024-06-17 15:46:46.000','2024-06-17 17:46:46.000'),('b8d62e1b-2ee8-11ef-8dc9-d414e3397395',3,0,NULL,NULL,'2024-06-20 11:37:36.618','2024-06-20 09:41:43.000','2024-06-20 11:41:43.000'),('b8d62e1b-2ee8-11ef-8dc9-d414e3397395',12,0,NULL,NULL,'2024-06-20 11:37:36.638','2024-06-20 09:37:36.000',NULL),('be273be5-289d-11ef-8e16-d517f37fa2ad',5,0,NULL,NULL,'2024-06-12 11:25:43.701','2024-06-12 09:46:58.000','2024-06-12 11:46:58.000'),('be273be5-289d-11ef-8e16-d517f37fa2ad',9,0,NULL,NULL,'2024-06-12 11:25:43.701','2024-06-12 09:25:43.701',NULL),('ddab36aa-23e2-11ef-8f8c-d92a43d45e5a',3,0,NULL,NULL,'2024-06-06 11:13:23.472','2024-06-06 09:36:14.000','2024-06-06 11:36:14.000'),('ddab36aa-23e2-11ef-8f8c-d92a43d45e5a',6,0,NULL,NULL,'2024-06-06 11:13:23.487','2024-06-06 09:04:14.000',NULL);
/*!40000 ALTER TABLE `Discussion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `File`
--

DROP TABLE IF EXISTS `File`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `File` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `path` text DEFAULT NULL,
  `tag` text DEFAULT NULL,
  `originalName` text NOT NULL,
  `originalId` varchar(36) NOT NULL,
  `metadata` text DEFAULT NULL,
  `type` enum('BIN','JSON','PDF','PLY','STL','PNG','XYZ','ZIP') NOT NULL,
  `version` mediumint(8) unsigned DEFAULT 0,
  `status` enum('CREATED','UPDATED','SYNCED','ERROR') DEFAULT 'CREATED',
  `anonymous` tinyint(1) NOT NULL DEFAULT 0,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `version` (`originalId`,`version`),
  CONSTRAINT `File_ibfk_1` FOREIGN KEY (`originalId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `File`
--

LOCK TABLES `File` WRITE;
/*!40000 ALTER TABLE `File` DISABLE KEYS */;
INSERT INTO `File` VALUES ('00b3800a-296b-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_4704a021-2963-11ef-8e16-d517f37fa2ad/occlusion_4706df6f-2963-11ef-8e16-d517f37fa2ad/scan_47f95341-2963-11ef-8e16-d517f37fa2ad/00b3800a-296b-11ef-8e16-d517f37fa2ad.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_4704a021-2963-11ef-8e16-d517f37fa2ad_SESS_4706df6f-2963-11ef-8e16-d517f37fa2ad_TOSC_47f95341-2963-11ef-8e16-d517f37fa2ad_MODEL','00b3800a-296b-11ef-8e16-d517f37fa2ad.zip','6487d4c6-2964-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.1 Mascella u1\",\"modelMatrix\":\"0.432825,-0.89967,-0.0570733,0,0.880417,0.43547,-0.187701,0,0.193722,0.0309933,0.980567,0,-23.5715,9.30099,-17.1386,1\",\"scanBodies\":[],\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":3,\"socleIsFullArch\":true,\"socleThickness\":-1,\"socleType\":1}','ZIP',2,'SYNCED',0,NULL,'2024-06-13 11:55:02.177','2024-06-13 09:55:02.304','2024-06-13 11:55:03.286'),('01976f12-298b-11ef-8e16-d517f37fa2ad',2,'/var/.scan4all/iris/data/2024/2/5062e053-298a-11ef-8e16-d517f37fa2ad/session_a1ebbaf4-298a-11ef-8e16-d517f37fa2ad/occlusion_a1ecf57e-298a-11ef-8e16-d517f37fa2ad/scan_d2eec825-298a-11ef-8e16-d517f37fa2ad/01976f12-298b-11ef-8e16-d517f37fa2ad.ply','PATIENT_5062e053-298a-11ef-8e16-d517f37fa2ad_ACT_a1ebbaf4-298a-11ef-8e16-d517f37fa2ad_SESS_a1ecf57e-298a-11ef-8e16-d517f37fa2ad_TOSC_d2eec825-298a-11ef-8e16-d517f37fa2ad_SEG','01976f12-298b-11ef-8e16-d517f37fa2ad.ply','01976f12-298b-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"14.2 Maxillaire u1 Segmentation [pc2]\"}','PLY',0,'CREATED',0,'2024-06-13 15:44:13.446','2024-06-13 15:44:13.447','2024-06-13 13:44:13.447',NULL),('02353824-289c-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/f373c86a-2899-11ef-8e16-d517f37fa2ad/session_627cfe1c-289b-11ef-8e16-d517f37fa2ad/occlusion_627f5b3e-289b-11ef-8e16-d517f37fa2ad/scan_db07e23d-289b-11ef-8e16-d517f37fa2ad/02353824-289c-11ef-8e16-d517f37fa2ad.zip','PATIENT_f373c86a-2899-11ef-8e16-d517f37fa2ad_ACT_627cfe1c-289b-11ef-8e16-d517f37fa2ad_SESS_627f5b3e-289b-11ef-8e16-d517f37fa2ad_TOSC_db07e23d-289b-11ef-8e16-d517f37fa2ad_MODEL','02353824-289c-11ef-8e16-d517f37fa2ad.zip','02353824-289c-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.2 Maxillaire u2\",\"modelMatrix\":\"0.997208,-0.0692111,-0.0280363,0,0.0535633,0.924566,-0.377239,0,0.0520305,0.374684,0.925691,0,5.0195,-8.3319,-11.112,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-12 11:13:22.000','2024-06-12 09:33:46.123','2024-06-12 11:51:36.113'),('02355a6c-289c-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/f373c86a-2899-11ef-8e16-d517f37fa2ad/session_627cfe1c-289b-11ef-8e16-d517f37fa2ad/occlusion_627f5b3e-289b-11ef-8e16-d517f37fa2ad/scan_db07e23d-289b-11ef-8e16-d517f37fa2ad/02355a6c-289c-11ef-8e16-d517f37fa2ad.png','PATIENT_f373c86a-2899-11ef-8e16-d517f37fa2ad_ACT_627cfe1c-289b-11ef-8e16-d517f37fa2ad_SESS_627f5b3e-289b-11ef-8e16-d517f37fa2ad_TOSC_db07e23d-289b-11ef-8e16-d517f37fa2ad_SNAPS','02355a6c-289c-11ef-8e16-d517f37fa2ad.png','02355a6c-289c-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.2 Maxillaire u2 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-12 11:13:22.000','2024-06-12 09:33:46.125','2024-06-12 11:51:36.114'),('026edc4c-2e4c-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/115617bc-2e4b-11ef-8deb-d515ea58f6cb/session_15f71dc7-2e4b-11ef-8deb-d515ea58f6cb/occlusion_15f94c3c-2e4b-11ef-8deb-d515ea58f6cb/scan_1770b226-2e4b-11ef-8deb-d515ea58f6cb/026edc4c-2e4c-11ef-8deb-d515ea58f6cb.ply','PATIENT_115617bc-2e4b-11ef-8deb-d515ea58f6cb_ACT_15f71dc7-2e4b-11ef-8deb-d515ea58f6cb_SESS_15f94c3c-2e4b-11ef-8deb-d515ea58f6cb_TOSC_1770b226-2e4b-11ef-8deb-d515ea58f6cb_SEG','026edc4c-2e4c-11ef-8deb-d515ea58f6cb.ply','026edc4c-2e4c-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"17.1 Maxilla u1 Segmentation [pc2]\"}','PLY',0,'SYNCED',0,NULL,'2024-06-19 16:55:47.143','2024-06-19 14:55:47.162','2024-06-19 16:55:47.546'),('03f2be58-28c6-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/82c4f551-28bf-11ef-8e16-d517f37fa2ad/session_6872058e-28c3-11ef-8e16-d517f37fa2ad/occlusion_6872c415-28c3-11ef-8e16-d517f37fa2ad/scan_e57cd1ee-28c5-11ef-8e16-d517f37fa2ad/03f2be58-28c6-11ef-8e16-d517f37fa2ad.zip','PATIENT_82c4f551-28bf-11ef-8e16-d517f37fa2ad_ACT_6872058e-28c3-11ef-8e16-d517f37fa2ad_SESS_6872c415-28c3-11ef-8e16-d517f37fa2ad_TOSC_e57cd1ee-28c5-11ef-8e16-d517f37fa2ad_MODEL','03f2be58-28c6-11ef-8e16-d517f37fa2ad.zip','03f2be58-28c6-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"4.2 Maxillaire u1\",\"modelMatrix\":\"-0.994396,0.105353,-0.0087768,0,-0.102365,-0.938784,0.328946,0,0.0264161,0.328002,0.944308,0,7.64946,-5.99363,-10.9969,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-12 16:14:00.665','2024-06-12 14:37:28.927','2024-06-12 16:37:29.731'),('03f2d4de-28c6-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/82c4f551-28bf-11ef-8e16-d517f37fa2ad/session_6872058e-28c3-11ef-8e16-d517f37fa2ad/occlusion_6872c415-28c3-11ef-8e16-d517f37fa2ad/scan_e57cd1ee-28c5-11ef-8e16-d517f37fa2ad/03f2d4de-28c6-11ef-8e16-d517f37fa2ad.png','PATIENT_82c4f551-28bf-11ef-8e16-d517f37fa2ad_ACT_6872058e-28c3-11ef-8e16-d517f37fa2ad_SESS_6872c415-28c3-11ef-8e16-d517f37fa2ad_TOSC_e57cd1ee-28c5-11ef-8e16-d517f37fa2ad_SNAPS','03f2d4de-28c6-11ef-8e16-d517f37fa2ad.png','03f2d4de-28c6-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"4.2 Maxillaire u1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-12 16:14:00.665','2024-06-12 14:37:28.928','2024-06-12 16:37:30.176'),('05008ccd-298b-11ef-8e16-d517f37fa2ad',2,'/var/.scan4all/iris/data/2024/2/5062e053-298a-11ef-8e16-d517f37fa2ad/session_a1ebbaf4-298a-11ef-8e16-d517f37fa2ad/occlusion_a1ecf57e-298a-11ef-8e16-d517f37fa2ad/scan_d2eec825-298a-11ef-8e16-d517f37fa2ad/05008ccd-298b-11ef-8e16-d517f37fa2ad.zip','PATIENT_5062e053-298a-11ef-8e16-d517f37fa2ad_ACT_a1ebbaf4-298a-11ef-8e16-d517f37fa2ad_SESS_a1ecf57e-298a-11ef-8e16-d517f37fa2ad_TOSC_d2eec825-298a-11ef-8e16-d517f37fa2ad_MODEL','05008ccd-298b-11ef-8e16-d517f37fa2ad.zip','f29b2b38-298a-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"14.2 Maxillaire u1 [pc2]\",\"modelMatrix\":\"-0.782411,-0.58409,-0.216035,0,0.489244,-0.791133,0.367081,0,-0.385321,0.181514,0.904754,0,6.77223,-0.510493,-10.8625,1\",\"scanBodies\":[{\"position\":\"6.39155,6,0,0,0.701041,0,6,0,9.72581,0,0,6,1,0,0,0\",\"reference\":\"gfhgfdhg\",\"tid\":16}]}','ZIP',1,'SYNCED',0,NULL,'2024-06-13 15:44:13.289','2024-06-13 13:44:13.339','2024-06-13 15:45:00.946'),('05998f46-2988-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/0fedc3b4-2961-11ef-8e16-d517f37fa2ad/session_4ba13230-2987-11ef-8e16-d517f37fa2ad/occlusion_4ba370c1-2987-11ef-8e16-d517f37fa2ad/computedocclusion_c472f797-2987-11ef-8e16-d517f37fa2ad/05998f46-2988-11ef-8e16-d517f37fa2ad.zip','PATIENT_0fedc3b4-2961-11ef-8e16-d517f37fa2ad_ACT_4ba13230-2987-11ef-8e16-d517f37fa2ad_SESS_4ba370c1-2987-11ef-8e16-d517f37fa2ad_OCC_c472f797-2987-11ef-8e16-d517f37fa2ad_TO1','05998f46-2988-11ef-8e16-d517f37fa2ad.zip','fb017cf6-2987-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"4.1 Occlusione o1 Mascella u1\",\"modelMatrix\":\"0.996297,-0.00872078,0.0855323,0,0.0514771,0.85732,-0.512204,0,-0.0688617,0.51471,0.854594,0,-11.595,-8.11386,-10.2324,1\",\"occlusionMatrix\":\"0.942645,0.0619705,-0.327991,0,0.296504,0.295863,0.908044,0,0.153313,-0.95322,0.260516,0,-14.9499,5.92204,-0.879945,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"4.1_u1\",\"referenceScanId\":\"55568e89-2987-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2024-06-13 15:22:47.000','2024-06-13 13:22:47.000','2024-06-13 15:22:47.000'),('05f5f9a0-2e3b-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_da1f6873-2e3a-11ef-8deb-d515ea58f6cb/occlusion_da21a6e4-2e3a-11ef-8deb-d515ea58f6cb/scan_dc038d5b-2e3a-11ef-8deb-d515ea58f6cb/05f5f9a0-2e3b-11ef-8deb-d515ea58f6cb.zip','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_da1f6873-2e3a-11ef-8deb-d515ea58f6cb_SESS_da21a6e4-2e3a-11ef-8deb-d515ea58f6cb_TOSC_dc038d5b-2e3a-11ef-8deb-d515ea58f6cb_MODEL','05f5f9a0-2e3b-11ef-8deb-d515ea58f6cb.zip','05f5f9a0-2e3b-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.2 Maxilla u1 [pc2]\",\"modelMatrix\":\"-0.987665,0.123358,-0.0964428,0,-0.113297,-0.98814,-0.103648,0,-0.108085,-0.0914428,0.989927,0,-2.13191,0.552438,-11.8505,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-19 14:54:11.617','2024-06-19 12:54:12.165','2024-06-19 14:54:24.440'),('05f61e01-2e3b-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_da1f6873-2e3a-11ef-8deb-d515ea58f6cb/occlusion_da21a6e4-2e3a-11ef-8deb-d515ea58f6cb/scan_dc038d5b-2e3a-11ef-8deb-d515ea58f6cb/05f61e01-2e3b-11ef-8deb-d515ea58f6cb.png','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_da1f6873-2e3a-11ef-8deb-d515ea58f6cb_SESS_da21a6e4-2e3a-11ef-8deb-d515ea58f6cb_TOSC_dc038d5b-2e3a-11ef-8deb-d515ea58f6cb_SNAPS','05f61e01-2e3b-11ef-8deb-d515ea58f6cb.png','05f61e01-2e3b-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.2 Maxilla u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-19 14:54:11.618','2024-06-19 12:54:12.166','2024-06-19 14:54:25.901'),('05feb90c-2e3d-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_af857ecd-27f1-11ef-8e37-d519fa9d22d2/occlusion_af864e86-27f1-11ef-8e37-d519fa9d22d2/scan_e16361f9-2e3c-11ef-8deb-d515ea58f6cb/05feb90c-2e3d-11ef-8deb-d515ea58f6cb.zip','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_af857ecd-27f1-11ef-8e37-d519fa9d22d2_SESS_af864e86-27f1-11ef-8e37-d519fa9d22d2_TOSC_e16361f9-2e3c-11ef-8deb-d515ea58f6cb_MODEL','05feb90c-2e3d-11ef-8deb-d515ea58f6cb.zip','05feb90c-2e3d-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.4 Maxilla u1 [pc2]\",\"modelMatrix\":\"0.961723,0.241617,-0.129268,0,-0.251677,0.965425,-0.067927,0,0.108386,0.0978608,0.98928,0,-11.6212,0.502501,-11.7801,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-19 15:08:30.668','2024-06-19 13:19:00.488','2024-06-19 15:19:06.390'),('05fecc31-2e3d-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_af857ecd-27f1-11ef-8e37-d519fa9d22d2/occlusion_af864e86-27f1-11ef-8e37-d519fa9d22d2/scan_e16361f9-2e3c-11ef-8deb-d515ea58f6cb/05fecc31-2e3d-11ef-8deb-d515ea58f6cb.png','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_af857ecd-27f1-11ef-8e37-d519fa9d22d2_SESS_af864e86-27f1-11ef-8e37-d519fa9d22d2_TOSC_e16361f9-2e3c-11ef-8deb-d515ea58f6cb_SNAPS','05fecc31-2e3d-11ef-8deb-d515ea58f6cb.png','05fecc31-2e3d-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.4 Maxilla u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-19 15:08:30.668','2024-06-19 13:19:00.489','2024-06-19 15:19:08.214'),('080061b0-2403-11ef-8dde-d415e84cc4f5',2,'/var/.scan4all/iris/data/2024/2/ce57500b-227c-11ef-8d76-d310d2ec2c14/session_da355fe4-227c-11ef-8d76-d310d2ec2c14/order_da3bcb3f-227c-11ef-8d76-d310d2ec2c14/080061b0-2403-11ef-8dde-d415e84cc4f5.pdf','PATIENT_ce57500b-227c-11ef-8d76-d310d2ec2c14_ACT_da355fe4-227c-11ef-8d76-d310d2ec2c14_PROST_da3bcb3f-227c-11ef-8d76-d310d2ec2c14_FORM','080061b0-2403-11ef-8dde-d415e84cc4f5.pdf','080061b0-2403-11ef-8dde-d415e84cc4f5','{\"displayTitle\":\"3.1 Autre [pc2]\",\"title\":\"Autre\"}','PDF',0,'SYNCED',0,NULL,'2024-06-06 14:48:12.000','2024-06-06 12:48:12.000','2024-06-06 14:48:12.000'),('089e2b2d-296b-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_4704a021-2963-11ef-8e16-d517f37fa2ad/occlusion_4706df6f-2963-11ef-8e16-d517f37fa2ad/scan_47f95341-2963-11ef-8e16-d517f37fa2ad/089e2b2d-296b-11ef-8e16-d517f37fa2ad.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_4704a021-2963-11ef-8e16-d517f37fa2ad_SESS_4706df6f-2963-11ef-8e16-d517f37fa2ad_TOSC_47f95341-2963-11ef-8e16-d517f37fa2ad_MODEL','089e2b2d-296b-11ef-8e16-d517f37fa2ad.zip','6487d4c6-2964-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.1 Mascella u1\",\"modelMatrix\":\"0.432825,-0.89967,-0.0570733,0,0.880417,0.43547,-0.187701,0,0.193722,0.0309933,0.980567,0,-23.5715,9.30099,-17.1386,1\",\"scanBodies\":[],\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":2,\"socleIsFullArch\":true,\"socleThickness\":-1,\"socleType\":1}','ZIP',3,'SYNCED',0,NULL,'2024-06-13 11:55:18.000','2024-06-13 09:55:18.000','2024-06-13 11:55:18.000'),('08ff5fda-2981-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_08eb58c6-2980-11ef-8e16-d517f37fa2ad/occlusion_08ed7a4a-2980-11ef-8e16-d517f37fa2ad/computedocclusion_a4bc6912-2980-11ef-8e16-d517f37fa2ad/08ff5fda-2981-11ef-8e16-d517f37fa2ad.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_OCC_a4bc6912-2980-11ef-8e16-d517f37fa2ad_TO1','08ff5fda-2981-11ef-8e16-d517f37fa2ad.zip','dff96d3d-2980-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.5 Occlusione o1 Mascella u1\",\"modelMatrix\":\"0.0885466,-0.989287,-0.116065,0,0.981849,0.106308,-0.157067,0,0.167723,-0.10005,0.980744,0,7.04315,3.35377,-13.5757,1\",\"occlusionMatrix\":\"-0.171625,0.533856,-0.827981,0,0.982265,0.157301,-0.102183,0,0.0756935,-0.830831,-0.551379,0,5.9597,4.42168,0.971543,1\",\"occlusionType\":3,\"referenceScanFullDisplayId\":\"5.5_u1\",\"referenceScanId\":\"099d82e1-2980-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2024-06-13 14:32:45.025','2024-06-13 12:32:45.235','2024-06-13 14:32:45.779'),('0b0ff7de-296c-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_8e81ab09-296b-11ef-8e16-d517f37fa2ad/occlusion_8e83509f-296b-11ef-8e16-d517f37fa2ad/scan_d8e5d9f0-296b-11ef-8e16-d517f37fa2ad/0b0ff7de-296c-11ef-8e16-d517f37fa2ad.zip','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_SESS_8e83509f-296b-11ef-8e16-d517f37fa2ad_TOSC_d8e5d9f0-296b-11ef-8e16-d517f37fa2ad_MODEL','0b0ff7de-296c-11ef-8e16-d517f37fa2ad.zip','0b0ff7de-296c-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Mascella u1\",\"modelMatrix\":\"-0.955855,0.290811,-0.0420667,0,-0.288148,-0.955728,-0.0596247,0,-0.0575438,-0.0448711,0.997334,0,11.8973,-1.64451,-15.9584,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,'2024-06-13 12:10:56.416','2024-06-13 12:02:29.057','2024-06-13 10:10:56.419','2024-06-13 12:10:56.442'),('0b1013ae-296c-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_8e81ab09-296b-11ef-8e16-d517f37fa2ad/occlusion_8e83509f-296b-11ef-8e16-d517f37fa2ad/scan_d8e5d9f0-296b-11ef-8e16-d517f37fa2ad/0b1013ae-296c-11ef-8e16-d517f37fa2ad.png','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_SESS_8e83509f-296b-11ef-8e16-d517f37fa2ad_TOSC_d8e5d9f0-296b-11ef-8e16-d517f37fa2ad_SNAPS','0b1013ae-296c-11ef-8e16-d517f37fa2ad.png','0b1013ae-296c-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Mascella u1 Snapshot\"}','PNG',0,'SYNCED',0,'2024-06-13 12:10:56.416','2024-06-13 12:02:29.058','2024-06-13 10:10:56.422','2024-06-13 12:10:56.443'),('0bf0e3fa-297f-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_d5b85a1b-297e-11ef-8e16-d517f37fa2ad/analyse_d5c01f5d-297e-11ef-8e16-d517f37fa2ad/0bf0e3fa-297f-11ef-8e16-d517f37fa2ad.json','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_d5b85a1b-297e-11ef-8e16-d517f37fa2ad_ANA_d5c01f5d-297e-11ef-8e16-d517f37fa2ad_TRANS','0bf0e3fa-297f-11ef-8e16-d517f37fa2ad.json','0bf0e3fa-297f-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.3 Analisi c1\"}','JSON',0,'SYNCED',0,'2024-06-13 14:18:43.216','2024-06-13 14:18:30.969','2024-06-13 12:18:43.217','2024-06-13 14:18:43.229'),('0c4e0406-297f-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_d5b85a1b-297e-11ef-8e16-d517f37fa2ad/analyse_d5c01f5d-297e-11ef-8e16-d517f37fa2ad/0c4e0406-297f-11ef-8e16-d517f37fa2ad.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_d5b85a1b-297e-11ef-8e16-d517f37fa2ad_ANA_d5c01f5d-297e-11ef-8e16-d517f37fa2ad_SNAPS','0c4e0406-297f-11ef-8e16-d517f37fa2ad.png','0c4e0406-297f-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.3 Analisi c1\"}','PNG',0,'SYNCED',0,'2024-06-13 14:18:43.216','2024-06-13 14:18:31.580','2024-06-13 12:18:43.218','2024-06-13 14:18:43.229'),('0cbc6058-273d-11ef-8e16-d517f37fa1ab',2,'/var/.scan4all/iris/data/2024/2/b8993188-273d-11ef-8e09-d517f1736dc8/session_eab5fbfa-273c-11ef-8e16-d517f37fa1ab/occlusion_eab758e7-273c-11ef-8e16-d517f37fa1ab/scan_ec642b7f-273c-11ef-8e16-d517f37fa1ab/0cbc6058-273d-11ef-8e16-d517f37fa1ab.zip','PATIENT_b8993188-273d-11ef-8e09-d517f1736dc8_ACT_eab5fbfa-273c-11ef-8e16-d517f37fa1ab_SESS_eab758e7-273c-11ef-8e16-d517f37fa1ab_TOSC_ec642b7f-273c-11ef-8e16-d517f37fa1ab_MODEL','0cbc6058-273d-11ef-8e16-d517f37fa1ab.zip','0cbc6058-273d-11ef-8e16-d517f37fa1ab','{\"displayTitle\":\"11.1 Maxillaire u1 [pc2]\",\"modelMatrix\":\"0.999231,0.0128726,-0.0370301,0,-0.0135729,0.999733,-0.0187224,0,0.0367792,0.0192106,0.999139,0,-8.68311,0.890795,-11.1038,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-10 17:21:03.193','2024-06-10 15:25:51.737','2024-06-10 17:25:56.551'),('0cbc72d3-273d-11ef-8e16-d517f37fa1ab',2,'/var/.scan4all/iris/data/2024/2/b8993188-273d-11ef-8e09-d517f1736dc8/session_eab5fbfa-273c-11ef-8e16-d517f37fa1ab/occlusion_eab758e7-273c-11ef-8e16-d517f37fa1ab/scan_ec642b7f-273c-11ef-8e16-d517f37fa1ab/0cbc72d3-273d-11ef-8e16-d517f37fa1ab.png','PATIENT_b8993188-273d-11ef-8e09-d517f1736dc8_ACT_eab5fbfa-273c-11ef-8e16-d517f37fa1ab_SESS_eab758e7-273c-11ef-8e16-d517f37fa1ab_TOSC_ec642b7f-273c-11ef-8e16-d517f37fa1ab_SNAPS','0cbc72d3-273d-11ef-8e16-d517f37fa1ab.png','0cbc72d3-273d-11ef-8e16-d517f37fa1ab','{\"displayTitle\":\"11.1 Maxillaire u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-10 17:21:03.194','2024-06-10 15:25:51.737','2024-06-10 17:25:57.903'),('0d165e5f-225e-11ef-867c-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_0f3dfe44-225d-11ef-8f1f-d8242c71b430/0d165e5f-225e-11ef-867c-6ec2958327c0.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_SESS_e3868e5f-225a-11ef-8f1f-d8242c71b430_TOSC_e52279ce-225a-11ef-8f1f-d8242c71b430_SCREENS','9484c123-225d-11ef-8f1f-d8242c71b430.png','0d165e5f-225e-11ef-867c-6ec2958327c0','{\"displayTitle\":\"1.1 Maxillaire u1 Capture d\'écran n°16\",\"title\":\"n°16\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 12:32:41.000','2024-06-04 10:32:41.000','2024-06-04 12:32:41.000'),('0d4ea307-2969-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_4704a021-2963-11ef-8e16-d517f37fa2ad/occlusion_4706df6f-2963-11ef-8e16-d517f37fa2ad/scan_e7c571a1-2968-11ef-8e16-d517f37fa2ad/0d4ea307-2969-11ef-8e16-d517f37fa2ad.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_4704a021-2963-11ef-8e16-d517f37fa2ad_SESS_4706df6f-2963-11ef-8e16-d517f37fa2ad_LESC_e7c571a1-2968-11ef-8e16-d517f37fa2ad_MODEL','0d4ea307-2969-11ef-8e16-d517f37fa2ad.zip','0d4ea307-2969-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.1 Morso sinistro bl2\",\"modelMatrix\":\"-0.995932,0.0264902,-0.0870704,0,-0.0305995,-0.998602,0.0433874,0,-0.0847566,0.0457353,0.995257,0,-5.9024,4.08233,-16.7505,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 11:41:04.333','2024-06-13 09:41:04.625','2024-06-13 11:41:48.202'),('0d4eb27a-2969-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_4704a021-2963-11ef-8e16-d517f37fa2ad/occlusion_4706df6f-2963-11ef-8e16-d517f37fa2ad/scan_e7c571a1-2968-11ef-8e16-d517f37fa2ad/0d4eb27a-2969-11ef-8e16-d517f37fa2ad.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_4704a021-2963-11ef-8e16-d517f37fa2ad_SESS_4706df6f-2963-11ef-8e16-d517f37fa2ad_LESC_e7c571a1-2968-11ef-8e16-d517f37fa2ad_SNAPS','0d4eb27a-2969-11ef-8e16-d517f37fa2ad.png','0d4eb27a-2969-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.1 Morso sinistro bl2 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 11:41:04.334','2024-06-13 09:41:04.627','2024-06-13 11:41:49.320'),('0eb7cc4f-2e3b-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_da1f6873-2e3a-11ef-8deb-d515ea58f6cb/occlusion_da21a6e4-2e3a-11ef-8deb-d515ea58f6cb/scan_dc038d5b-2e3a-11ef-8deb-d515ea58f6cb/0eb7cc4f-2e3b-11ef-8deb-d515ea58f6cb.ply','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_da1f6873-2e3a-11ef-8deb-d515ea58f6cb_SESS_da21a6e4-2e3a-11ef-8deb-d515ea58f6cb_TOSC_dc038d5b-2e3a-11ef-8deb-d515ea58f6cb_SEG','0eb7cc4f-2e3b-11ef-8deb-d515ea58f6cb.ply','0eb7cc4f-2e3b-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.2 Maxilla u1 Segmentation [pc2]\"}','PLY',0,'SYNCED',0,NULL,'2024-06-19 14:54:26.309','2024-06-19 12:54:26.325','2024-06-19 14:54:26.898'),('0ed5b8be-225d-11ef-8f1f-d8242c71b430',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_e3862d66-225a-11ef-8f1f-d8242c71b430/order_e3879e0c-225a-11ef-8f1f-d8242c71b430/0ed5b8be-225d-11ef-8f1f-d8242c71b430.pdf','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_PROST_e3879e0c-225a-11ef-8f1f-d8242c71b430_FORM','0ed5b8be-225d-11ef-8f1f-d8242c71b430.pdf','0ed5b8be-225d-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.1 Guide\",\"title\":\"Guide\"}','PDF',0,'SYNCED',0,NULL,'2024-06-04 12:27:35.000','2024-06-04 10:27:35.000','2024-06-04 12:27:35.000'),('0f325523-2981-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_08eb58c6-2980-11ef-8e16-d517f37fa2ad/occlusion_08ed7a4a-2980-11ef-8e16-d517f37fa2ad/computedocclusion_a4bc6912-2980-11ef-8e16-d517f37fa2ad/0f325523-2981-11ef-8e16-d517f37fa2ad.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_OCC_a4bc6912-2980-11ef-8e16-d517f37fa2ad_TO1','0f325523-2981-11ef-8e16-d517f37fa2ad.zip','dff96d3d-2980-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.5 Occlusione o1 Mascella u1\",\"modelMatrix\":\"0.0885466,-0.989287,-0.116065,0,0.981849,0.106308,-0.157067,0,0.167723,-0.10005,0.980744,0,7.04315,3.35377,-13.5757,1\",\"occlusionMatrix\":\"-0.171625,0.533856,-0.827981,0,0.982265,0.157301,-0.102183,0,0.0756935,-0.830831,-0.551379,0,5.9597,4.42168,0.971543,1\",\"occlusionType\":3,\"referenceScanFullDisplayId\":\"5.5_u1\",\"referenceScanId\":\"099d82e1-2980-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[],\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":3,\"socleIsFullArch\":true,\"socleThickness\":-1,\"socleType\":1}','ZIP',2,'SYNCED',0,NULL,'2024-06-13 14:32:55.425','2024-06-13 12:32:55.555','2024-06-13 14:32:56.297'),('0f32911d-2981-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_08eb58c6-2980-11ef-8e16-d517f37fa2ad/occlusion_08ed7a4a-2980-11ef-8e16-d517f37fa2ad/computedocclusion_a4bc6912-2980-11ef-8e16-d517f37fa2ad/0f32911d-2981-11ef-8e16-d517f37fa2ad.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_OCC_a4bc6912-2980-11ef-8e16-d517f37fa2ad_BO1','0f32911d-2981-11ef-8e16-d517f37fa2ad.zip','e01e29be-2980-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.5 Occlusione o1 Mandibola l1\",\"modelMatrix\":\"-0.0691305,-0.980151,-0.185807,0,0.932705,-0.129585,0.336555,0,-0.353953,-0.150036,0.92315,0,-2.52526,5.094,-12.0573,1\",\"occlusionMatrix\":\"-0.726301,-0.0498987,-0.685575,0,-0.669992,0.274454,0.689787,0,0.15374,0.960326,-0.232761,0,3.4774,-11.0063,-1.91383,1\",\"occlusionType\":3,\"referenceScanFullDisplayId\":\"5.5_l1\",\"referenceScanId\":\"4d76036e-2980-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[],\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":3,\"socleIsFullArch\":true,\"socleThickness\":-1,\"socleType\":1}','ZIP',1,'SYNCED',0,NULL,'2024-06-13 14:32:55.426','2024-06-13 12:32:55.556','2024-06-13 14:32:57.109'),('0f949b7b-2e4d-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/115617bc-2e4b-11ef-8deb-d515ea58f6cb/session_f8ed0986-2e4c-11ef-8deb-d515ea58f6cb/occlusion_f8edd977-2e4c-11ef-8deb-d515ea58f6cb/scan_f9e998f8-2e4c-11ef-8deb-d515ea58f6cb/0f949b7b-2e4d-11ef-8deb-d515ea58f6cb.zip','PATIENT_115617bc-2e4b-11ef-8deb-d515ea58f6cb_ACT_f8ed0986-2e4c-11ef-8deb-d515ea58f6cb_SESS_f8edd977-2e4c-11ef-8deb-d515ea58f6cb_TOSC_f9e998f8-2e4c-11ef-8deb-d515ea58f6cb_MODEL','0f949b7b-2e4d-11ef-8deb-d515ea58f6cb.zip','0f949b7b-2e4d-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"17.2 Maxilla u1 [pc2]\",\"modelMatrix\":\"-0.708935,0.701277,-0.074972,0,-0.684023,-0.709576,-0.169157,0,-0.171824,-0.0686385,0.982733,0,-3.14557,5.92013,-12.6975,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-19 17:03:50.000','2024-06-19 15:09:53.000','2024-06-19 17:09:53.000'),('0f94ab65-2e4d-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/115617bc-2e4b-11ef-8deb-d515ea58f6cb/session_f8ed0986-2e4c-11ef-8deb-d515ea58f6cb/occlusion_f8edd977-2e4c-11ef-8deb-d515ea58f6cb/scan_f9e998f8-2e4c-11ef-8deb-d515ea58f6cb/0f94ab65-2e4d-11ef-8deb-d515ea58f6cb.png','PATIENT_115617bc-2e4b-11ef-8deb-d515ea58f6cb_ACT_f8ed0986-2e4c-11ef-8deb-d515ea58f6cb_SESS_f8edd977-2e4c-11ef-8deb-d515ea58f6cb_TOSC_f9e998f8-2e4c-11ef-8deb-d515ea58f6cb_SNAPS','0f94ab65-2e4d-11ef-8deb-d515ea58f6cb.png','0f94ab65-2e4d-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"17.2 Maxilla u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-19 17:03:51.000','2024-06-19 15:09:53.000','2024-06-19 17:09:53.000'),('0fed9cbc-2403-11ef-867c-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_0f3dfe44-225d-11ef-8f1f-d8242c71b430/0fed9cbc-2403-11ef-867c-6ec2958327c0.pdf','PATIENT_ce57500b-227c-11ef-8d76-d310d2ec2c14_ACT_da355fe4-227c-11ef-8d76-d310d2ec2c14_PROST_da3bcb3f-227c-11ef-8d76-d310d2ec2c14_FORM','080061b0-2403-11ef-8dde-d415e84cc4f5.pdf','0fed9cbc-2403-11ef-867c-6ec2958327c0','{\"displayTitle\":\"3.1 Autre [pc2]\",\"title\":\"Autre\"}','PDF',0,'SYNCED',0,NULL,'2024-06-06 14:48:12.000','2024-06-06 12:48:12.000','2024-06-06 14:48:12.000'),('0fef6e20-2403-11ef-867c-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_0f3dfe44-225d-11ef-8f1f-d8242c71b430/0fef6e20-2403-11ef-867c-6ec2958327c0.zip','PATIENT_ce57500b-227c-11ef-8d76-d310d2ec2c14_ACT_da355fe4-227c-11ef-8d76-d310d2ec2c14_SESS_da37d213-227c-11ef-8d76-d310d2ec2c14_TOSC_e0f66733-227c-11ef-8d76-d310d2ec2c14_MODEL','f51d71ce-227c-11ef-8d76-d310d2ec2c14.zip','0fef6e20-2403-11ef-867c-6ec2958327c0','{\"displayTitle\":\"3.1 Maxillaire u1 [pc2]\",\"modelMatrix\":\"-0.590223,0.739255,-0.324251,0,-0.781697,-0.423166,0.458127,0,0.201461,0.523863,0.827636,0,-1.54469,-10.1967,-10.1611,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 16:16:00.000','2024-06-04 14:16:00.000','2024-06-04 16:16:00.000'),('0fefdd19-2403-11ef-867c-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_0f3dfe44-225d-11ef-8f1f-d8242c71b430/0fefdd19-2403-11ef-867c-6ec2958327c0.png','PATIENT_ce57500b-227c-11ef-8d76-d310d2ec2c14_ACT_da355fe4-227c-11ef-8d76-d310d2ec2c14_SESS_da37d213-227c-11ef-8d76-d310d2ec2c14_TOSC_e0f66733-227c-11ef-8d76-d310d2ec2c14_SNAPS','f51d8554-227c-11ef-8d76-d310d2ec2c14.png','0fefdd19-2403-11ef-867c-6ec2958327c0','{\"displayTitle\":\"3.1 Maxillaire u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 16:16:00.000','2024-06-04 14:16:00.000','2024-06-04 16:16:00.000'),('10a0d811-2339-11ef-8f93-d92a45da78c9',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_ef3ba736-2337-11ef-8f93-d92a45da78c9/10a0d811-2339-11ef-8f93-d92a45da78c9.xyz','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_TOSC_ef3ba736-2337-11ef-8f93-d92a45da78c9_LIFI','10a0d811-2339-11ef-8f93-d92a45da78c9.xyz','10a0d811-2339-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Maxillaire u1 Ligne de finition manuelle [pc1]\",\"title\":\"manuelle\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-05 14:42:27.000','2024-06-05 12:42:38.000','2024-06-05 14:42:38.000'),('10a0db7f-2339-11ef-8f93-d92a45da78c9',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_ef3ba736-2337-11ef-8f93-d92a45da78c9/10a0db7f-2339-11ef-8f93-d92a45da78c9.bin','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_TOSC_ef3ba736-2337-11ef-8f93-d92a45da78c9_LIFIM','10a0db7f-2339-11ef-8f93-d92a45da78c9.bin','10a0db7f-2339-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Maxillaire u1 Ligne de finition métadonnées manuelle [pc1]\",\"title\":\"manuelle\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-05 14:42:27.000','2024-06-05 12:42:38.000','2024-06-05 14:42:38.000'),('10a34539-2339-11ef-8f93-d92a45da78c9',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/computedocclusion_a2829ff3-2338-11ef-8f93-d92a45da78c9/10a34539-2339-11ef-8f93-d92a45da78c9.xyz','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_OCC_a2829ff3-2338-11ef-8f93-d92a45da78c9_LIFIO','10a34539-2339-11ef-8f93-d92a45da78c9.xyz','10a34539-2339-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Occlusion o1 Maxillaire u1 Ligne de finition manuelle [pc1]\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY_1\",\"referenceScanFullDisplayId\":\"1.5_u1\",\"referenceScanId\":\"ef3ba736-2337-11ef-8f93-d92a45da78c9\",\"title\":\"manuelle\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-05 14:42:27.000','2024-06-05 12:51:42.000','2024-06-05 14:51:42.000'),('10a347ba-2339-11ef-8f93-d92a45da78c9',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/computedocclusion_a2829ff3-2338-11ef-8f93-d92a45da78c9/10a347ba-2339-11ef-8f93-d92a45da78c9.bin','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_OCC_a2829ff3-2338-11ef-8f93-d92a45da78c9_LIFIMO','10a347ba-2339-11ef-8f93-d92a45da78c9.bin','10a347ba-2339-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Occlusion o1 Maxillaire u1 Ligne de finition métadonnées manuelle [pc1]\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY_1\",\"referenceScanFullDisplayId\":\"1.5_u1\",\"referenceScanId\":\"ef3ba736-2337-11ef-8f93-d92a45da78c9\",\"title\":\"manuelle\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-05 14:42:27.000','2024-06-05 12:51:42.000','2024-06-05 14:51:42.000'),('113e7226-2734-11ef-8e16-d517f37fa1ab',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_a4139c9d-2279-11ef-8d76-d310d2ec2c14/order_a4229655-2279-11ef-8d76-d310d2ec2c14/113e7226-2734-11ef-8e16-d517f37fa1ab.pdf','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_a4139c9d-2279-11ef-8d76-d310d2ec2c14_PROST_a4229655-2279-11ef-8d76-d310d2ec2c14_FORM','113e7226-2734-11ef-8e16-d517f37fa1ab.pdf','d59e4f7d-2279-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.3 Facette [pc2]\",\"title\":\"Facette\"}','PDF',1,'SYNCED',0,NULL,'2024-06-10 16:16:45.286','2024-06-10 14:16:46.025','2024-06-10 16:16:46.032'),('1171b033-225d-11ef-867c-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_0f3dfe44-225d-11ef-8f1f-d8242c71b430/1171b033-225d-11ef-867c-6ec2958327c0.pdf','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_PROST_e3879e0c-225a-11ef-8f1f-d8242c71b430_FORM','0ed5b8be-225d-11ef-8f1f-d8242c71b430.pdf','1171b033-225d-11ef-867c-6ec2958327c0','{\"displayTitle\":\"1.1 Guide\",\"title\":\"Guide\"}','PDF',0,'SYNCED',0,NULL,'2024-06-04 12:27:35.000','2024-06-04 10:27:35.000','2024-06-04 12:27:35.000'),('117372ab-225d-11ef-867c-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_0f3dfe44-225d-11ef-8f1f-d8242c71b430/117372ab-225d-11ef-867c-6ec2958327c0.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_SESS_e3868e5f-225a-11ef-8f1f-d8242c71b430_TOSC_e52279ce-225a-11ef-8f1f-d8242c71b430_MODEL','326e28f0-225b-11ef-8f1f-d8242c71b430.zip','117372ab-225d-11ef-867c-6ec2958327c0','{\"displayTitle\":\"1.1 Maxillaire u1\",\"modelMatrix\":\"0.983821,-0.178562,-0.0145353,0,0.167676,0.946334,-0.276291,0,0.0630904,0.269384,0.960964,0,-18.4738,6.44284,-12.9473,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 12:14:21.000','2024-06-04 10:14:21.000','2024-06-04 12:14:21.000'),('1173c2f4-225d-11ef-867c-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_0f3dfe44-225d-11ef-8f1f-d8242c71b430/1173c2f4-225d-11ef-867c-6ec2958327c0.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_SESS_e3868e5f-225a-11ef-8f1f-d8242c71b430_TOSC_e52279ce-225a-11ef-8f1f-d8242c71b430_SNAPS','326e3f34-225b-11ef-8f1f-d8242c71b430.png','1173c2f4-225d-11ef-867c-6ec2958327c0','{\"displayTitle\":\"1.1 Maxillaire u1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 12:14:21.000','2024-06-04 10:14:21.000','2024-06-04 12:14:21.000'),('1174111e-225d-11ef-867c-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_0f3dfe44-225d-11ef-8f1f-d8242c71b430/1174111e-225d-11ef-867c-6ec2958327c0.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_SESS_e3868e5f-225a-11ef-8f1f-d8242c71b430_BOSC_37ccba29-225b-11ef-8f1f-d8242c71b430_MODEL','6782502c-225b-11ef-8f1f-d8242c71b430.zip','1174111e-225d-11ef-867c-6ec2958327c0','{\"displayTitle\":\"1.1 Mandibule l1\",\"modelMatrix\":\"-0.728037,0.684478,-0.03811,0,-0.685353,-0.725423,0.0636657,0,0.0159319,0.0724698,0.997243,0,9.49558,-10.7,-12.9454,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 12:15:47.000','2024-06-04 10:15:47.000','2024-06-04 12:15:47.000'),('11745799-225d-11ef-867c-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_0f3dfe44-225d-11ef-8f1f-d8242c71b430/11745799-225d-11ef-867c-6ec2958327c0.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_SESS_e3868e5f-225a-11ef-8f1f-d8242c71b430_BOSC_37ccba29-225b-11ef-8f1f-d8242c71b430_SNAPS','67825ce8-225b-11ef-8f1f-d8242c71b430.png','11745799-225d-11ef-867c-6ec2958327c0','{\"displayTitle\":\"1.1 Mandibule l1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 12:15:47.000','2024-06-04 10:15:47.000','2024-06-04 12:15:47.000'),('11749a5a-225d-11ef-867c-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_0f3dfe44-225d-11ef-8f1f-d8242c71b430/11749a5a-225d-11ef-867c-6ec2958327c0.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_SESS_e3868e5f-225a-11ef-8f1f-d8242c71b430_OCC_6ba502f4-225b-11ef-8f1f-d8242c71b430_TO1','e000eb20-225b-11ef-8f1f-d8242c71b430.zip','11749a5a-225d-11ef-867c-6ec2958327c0','{\"displayTitle\":\"1.1 Occlusion o1 Maxillaire u1\",\"modelMatrix\":\"0.983821,-0.178562,-0.0145353,0,0.167676,0.946334,-0.276291,0,0.0630904,0.269384,0.960964,0,-18.4738,6.44284,-12.9473,1\",\"occlusionMatrix\":\"-0.983067,0.0412191,-0.180339,0,0.183184,0.197784,-0.962563,0,-0.00759549,-0.979387,-0.202378,0,17.9497,7.67706,6.6371,1\",\"occlusionType\":2,\"referenceScanFullDisplayId\":\"1.1_u1\",\"referenceScanId\":\"e52279ce-225a-11ef-8f1f-d8242c71b430\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 12:19:09.000','2024-06-04 10:19:09.000','2024-06-04 12:19:09.000'),('117c269a-225d-11ef-867c-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_0f3dfe44-225d-11ef-8f1f-d8242c71b430/117c269a-225d-11ef-867c-6ec2958327c0.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_SESS_e3868e5f-225a-11ef-8f1f-d8242c71b430_OCC_6ba502f4-225b-11ef-8f1f-d8242c71b430_BO1','e01bae07-225b-11ef-8f1f-d8242c71b430.zip','117c269a-225d-11ef-867c-6ec2958327c0','{\"displayTitle\":\"1.1 Occlusion o1 Mandibule l1\",\"modelMatrix\":\"-0.728037,0.684478,-0.03811,0,-0.685353,-0.725423,0.0636657,0,0.0159319,0.0724698,0.997243,0,9.49558,-10.7,-12.9454,1\",\"occlusionMatrix\":\"-0.985853,-0.13039,-0.111741,0,-0.134966,0.214901,0.966923,0,-0.0995888,0.967905,-0.229331,0,6.18786,-8.33646,11.3454,1\",\"occlusionType\":2,\"referenceScanFullDisplayId\":\"1.1_l1\",\"referenceScanId\":\"37ccba29-225b-11ef-8f1f-d8242c71b430\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 12:19:11.000','2024-06-04 10:19:11.000','2024-06-04 12:19:11.000'),('117c6e59-225d-11ef-867c-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_0f3dfe44-225d-11ef-8f1f-d8242c71b430/117c6e59-225d-11ef-867c-6ec2958327c0.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_SESS_e3868e5f-225a-11ef-8f1f-d8242c71b430_OCC_6ba502f4-225b-11ef-8f1f-d8242c71b430_SNAPO','e091c2ff-225b-11ef-8f1f-d8242c71b430.png','117c6e59-225d-11ef-867c-6ec2958327c0','{\"displayTitle\":\"1.1 Occlusion o1\",\"occlusionType\":2}','PNG',0,'SYNCED',0,NULL,'2024-06-04 12:19:11.000','2024-06-04 10:19:11.000','2024-06-04 12:19:11.000'),('145531e1-2a2f-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/order_8d0cbb85-2a29-11ef-8f1c-d8242c6fa8fd/145531e1-2a2f-11ef-8f1c-d8242c6fa8fd.pdf','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_PROST_8d0cbb85-2a29-11ef-8f1c-d8242c6fa8fd_FORM','145531e1-2a2f-11ef-8f1c-d8242c6fa8fd.pdf','145531e1-2a2f-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Corona\",\"title\":\"Corona\"}','PDF',0,'SYNCED',0,NULL,'2024-06-14 11:18:39.000','2024-06-14 09:18:39.000','2024-06-14 11:18:39.000'),('14dbc96b-2732-11ef-8e16-d517f37fa1ab',2,'/var/.scan4all/iris/data/2024/2/f3e99d3d-272f-11ef-8e16-d517f37fa1ab/session_f2fea4e5-2731-11ef-8e16-d517f37fa1ab/occlusion_f300fd64-2731-11ef-8e16-d517f37fa1ab/scan_f516112b-2731-11ef-8e16-d517f37fa1ab/14dbc96b-2732-11ef-8e16-d517f37fa1ab.zip','PATIENT_f3e99d3d-272f-11ef-8e16-d517f37fa1ab_ACT_f2fea4e5-2731-11ef-8e16-d517f37fa1ab_SESS_f300fd64-2731-11ef-8e16-d517f37fa1ab_TOSC_f516112b-2731-11ef-8e16-d517f37fa1ab_MODEL','14dbc96b-2732-11ef-8e16-d517f37fa1ab.zip','14dbc96b-2732-11ef-8e16-d517f37fa1ab','{\"displayTitle\":\"4.2 Maxillaire u1 [pc2]\",\"modelMatrix\":\"-0.794299,-0.59736,-0.110676,0,0.567698,-0.794682,0.214942,0,-0.21635,0.107898,0.970335,0,10.8179,7.55279,-10.8916,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-10 16:02:35.000','2024-06-10 14:02:35.000','2024-06-10 16:02:35.000'),('14dbdff4-2732-11ef-8e16-d517f37fa1ab',2,'/var/.scan4all/iris/data/2024/2/f3e99d3d-272f-11ef-8e16-d517f37fa1ab/session_f2fea4e5-2731-11ef-8e16-d517f37fa1ab/occlusion_f300fd64-2731-11ef-8e16-d517f37fa1ab/scan_f516112b-2731-11ef-8e16-d517f37fa1ab/14dbdff4-2732-11ef-8e16-d517f37fa1ab.png','PATIENT_f3e99d3d-272f-11ef-8e16-d517f37fa1ab_ACT_f2fea4e5-2731-11ef-8e16-d517f37fa1ab_SESS_f300fd64-2731-11ef-8e16-d517f37fa1ab_TOSC_f516112b-2731-11ef-8e16-d517f37fa1ab_SNAPS','14dbdff4-2732-11ef-8e16-d517f37fa1ab.png','14dbdff4-2732-11ef-8e16-d517f37fa1ab','{\"displayTitle\":\"4.2 Maxillaire u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-10 16:02:36.000','2024-06-10 14:02:36.000','2024-06-10 16:02:36.000'),('16f20683-2e3c-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_da1f6873-2e3a-11ef-8deb-d515ea58f6cb/occlusion_da21a6e4-2e3a-11ef-8deb-d515ea58f6cb/computedocclusion_89b4ac38-2e3b-11ef-8deb-d515ea58f6cb/16f20683-2e3c-11ef-8deb-d515ea58f6cb.zip','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_da1f6873-2e3a-11ef-8deb-d515ea58f6cb_SESS_da21a6e4-2e3a-11ef-8deb-d515ea58f6cb_OCC_89b4ac38-2e3b-11ef-8deb-d515ea58f6cb_BO1','16f20683-2e3c-11ef-8deb-d515ea58f6cb.zip','c1a8eaf0-2e3b-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.2 Occlusion o1 Mandible l1 [pc2]\",\"modelMatrix\":\"0.988345,0.152164,-0.00455078,0,-0.132711,0.846578,-0.515455,0,-0.0745809,0.510051,0.856905,0,-6.06382,-8.89201,-8.94358,1\",\"occlusionMatrix\":\"-0.923804,0.358716,-0.129611,0,-0.276308,-0.863518,-0.421951,0,-0.265539,-0.354445,0.897211,0,7.48867,4.08598,-6.51245,1\",\"occlusionType\":2,\"referenceScanFullDisplayId\":\"16.2_l1\",\"referenceScanId\":\"18dce61e-2e3b-11ef-8deb-d515ea58f6cb\",\"scanBodies\":[]}','ZIP',2,'SYNCED',0,NULL,'2024-06-19 15:01:49.609','2024-06-19 13:01:49.765','2024-06-19 15:01:50.330'),('17783f50-2a2f-11ef-bb8b-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_3d61afe1-2986-11ef-8e16-d517f37fa2ad/17783f50-2a2f-11ef-bb8b-6ec2958327c0.pdf','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_PROST_8d0cbb85-2a29-11ef-8f1c-d8242c6fa8fd_FORM','145531e1-2a2f-11ef-8f1c-d8242c6fa8fd.pdf','17783f50-2a2f-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"3.2 Corona\",\"title\":\"Corona\"}','PDF',0,'SYNCED',0,NULL,'2024-06-14 11:18:39.000','2024-06-14 09:18:39.000','2024-06-14 11:18:39.000'),('17788e11-2a2f-11ef-bb8b-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_3d61afe1-2986-11ef-8e16-d517f37fa2ad/17788e11-2a2f-11ef-bb8b-6ec2958327c0.png','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_OCC_e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd_SNAPO','432c5ac7-2a2b-11ef-8f1c-d8242c6fa8fd.png','17788e11-2a2f-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"3.2 Occlusione o1\",\"occlusionType\":1}','PNG',0,'SYNCED',0,NULL,'2024-06-14 10:51:20.000','2024-06-14 08:51:20.000','2024-06-14 10:51:20.000'),('1778cdc2-2a2f-11ef-bb8b-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_3d61afe1-2986-11ef-8e16-d517f37fa2ad/1778cdc2-2a2f-11ef-bb8b-6ec2958327c0.png','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_BOSC_80540c46-2a2a-11ef-8f1c-d8242c6fa8fd_SCREENS','6c69f0d2-2a2c-11ef-8f1c-d8242c6fa8fd.png','1778cdc2-2a2f-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"3.2 Mandibola l1 Screenshot 1\",\"title\":\"1\"}','PNG',0,'SYNCED',0,NULL,'2024-06-14 10:59:37.000','2024-06-14 08:59:37.000','2024-06-14 10:59:37.000'),('17790e23-2a2f-11ef-bb8b-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_3d61afe1-2986-11ef-8e16-d517f37fa2ad/17790e23-2a2f-11ef-bb8b-6ec2958327c0.zip','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_OCC_e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd_BO1','7e31fba5-2a2b-11ef-8f1c-d8242c6fa8fd.zip','17790e23-2a2f-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"3.2 Occlusione o1 Mandibola l1\",\"modelMatrix\":\"-0.934662,0.348207,-0.071824,0,-0.340741,-0.934968,-0.098644,0,-0.101502,-0.0677254,0.992527,0,16.8656,-3.96577,-16.4235,1\",\"occlusionMatrix\":\"0.844369,-0.423985,-0.327577,0,-0.264087,0.202641,-0.942975,0,0.466188,0.882728,0.0591338,0,-22.7792,-5.26712,4.79476,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"3.2_l1\",\"referenceScanId\":\"80540c46-2a2a-11ef-8f1c-d8242c6fa8fd\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-14 10:53:01.000','2024-06-14 08:53:01.000','2024-06-14 10:53:01.000'),('1779a47e-2a2f-11ef-bb8b-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_3d61afe1-2986-11ef-8e16-d517f37fa2ad/1779a47e-2a2f-11ef-bb8b-6ec2958327c0.png','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_BOSC_aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd_SNAPS','aeeb700b-2a2e-11ef-8f1c-d8242c6fa8fd.png','1779a47e-2a2f-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"3.2 Mandibola l2 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-14 11:15:53.000','2024-06-14 09:15:53.000','2024-06-14 11:15:53.000'),('1779e2aa-2a2f-11ef-bb8b-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_3d61afe1-2986-11ef-8e16-d517f37fa2ad/1779e2aa-2a2f-11ef-bb8b-6ec2958327c0.xyz','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_BOSC_aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd_LIFI','aeeb7d77-2a2e-11ef-8f1c-d8242c6fa8fd.xyz','1779e2aa-2a2f-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"3.2 Mandibola l2 Linea di finitura 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-14 11:15:53.000','2024-06-14 09:15:53.000','2024-06-14 11:15:53.000'),('177a30cc-2a2f-11ef-bb8b-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_3d61afe1-2986-11ef-8e16-d517f37fa2ad/177a30cc-2a2f-11ef-bb8b-6ec2958327c0.bin','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_BOSC_aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd_LIFIM','aeeb8932-2a2e-11ef-8f1c-d8242c6fa8fd.bin','177a30cc-2a2f-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"3.2 Mandibola l2 Linea di finitura dei metadati 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-14 11:15:54.000','2024-06-14 09:15:54.000','2024-06-14 11:15:54.000'),('177a7405-2a2f-11ef-bb8b-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_3d61afe1-2986-11ef-8e16-d517f37fa2ad/177a7405-2a2f-11ef-bb8b-6ec2958327c0.zip','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_OCC_e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd_TO1','b5074b88-2a2b-11ef-8f1c-d8242c6fa8fd.zip','177a7405-2a2f-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"3.2 Occlusione o1 Mascella u1\",\"modelMatrix\":\"0.990607,-0.0477183,-0.128143,0,0.0606045,0.993278,0.0986225,0,0.122576,-0.105462,0.98684,0,-17.296,2.00683,-11.2545,1\",\"occlusionMatrix\":\"0.920264,-0.253816,-0.297823,0,0.207076,-0.329916,0.921021,0,-0.332026,-0.909252,-0.25105,0,-15.3539,10.9855,6.91144,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"3.2_u1\",\"referenceScanId\":\"8de1d45c-2a29-11ef-8f1c-d8242c6fa8fd\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-14 10:54:31.000','2024-06-14 08:54:31.000','2024-06-14 10:54:31.000'),('177aab27-2a2f-11ef-bb8b-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_3d61afe1-2986-11ef-8e16-d517f37fa2ad/177aab27-2a2f-11ef-bb8b-6ec2958327c0.zip','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_BOSC_aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd_MODEL','c10a25c6-2a2e-11ef-8f1c-d8242c6fa8fd.zip','177aab27-2a2f-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"3.2 Mandibola l2\",\"modelMatrix\":\"-0.934662,0.348207,-0.071824,0,-0.340741,-0.934968,-0.098644,0,-0.101502,-0.0677254,0.992527,0,16.8656,-3.96577,-16.4235,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-14 11:16:19.000','2024-06-14 09:16:19.000','2024-06-14 11:16:19.000'),('177ae1c6-2a2f-11ef-bb8b-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_3d61afe1-2986-11ef-8e16-d517f37fa2ad/177ae1c6-2a2f-11ef-bb8b-6ec2958327c0.png','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_BOSC_80540c46-2a2a-11ef-8f1c-d8242c6fa8fd_SCREENS','c1a4a542-2a2c-11ef-8f1c-d8242c6fa8fd.png','177ae1c6-2a2f-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"3.2 Mandibola l1 Screenshot 3\",\"title\":\"3\"}','PNG',0,'SYNCED',0,NULL,'2024-06-14 11:02:00.000','2024-06-14 09:02:00.000','2024-06-14 11:02:00.000'),('177b199c-2a2f-11ef-bb8b-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_3d61afe1-2986-11ef-8e16-d517f37fa2ad/177b199c-2a2f-11ef-bb8b-6ec2958327c0.png','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_BOSC_aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd_SCREENS','dc9d5d76-2a2e-11ef-8f1c-d8242c6fa8fd.png','177b199c-2a2f-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"3.2 Mandibola l2 Screenshot 1\",\"title\":\"1\"}','PNG',0,'SYNCED',0,NULL,'2024-06-14 11:17:05.000','2024-06-14 09:17:05.000','2024-06-14 11:17:05.000'),('177b4c35-2a2f-11ef-bb8b-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_3d61afe1-2986-11ef-8e16-d517f37fa2ad/177b4c35-2a2f-11ef-bb8b-6ec2958327c0.zip','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_TOSC_8de1d45c-2a29-11ef-8f1c-d8242c6fa8fd_MODEL','e0f8d71f-2a29-11ef-8f1c-d8242c6fa8fd.zip','177b4c35-2a2f-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"3.2 Mascella u1\",\"modelMatrix\":\"0.990607,-0.0477183,-0.128143,0,0.0606045,0.993278,0.0986225,0,0.122576,-0.105462,0.98684,0,-17.296,2.00683,-11.2545,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-14 10:41:28.000','2024-06-14 08:41:28.000','2024-06-14 10:41:28.000'),('177b8664-2a2f-11ef-bb8b-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_3d61afe1-2986-11ef-8e16-d517f37fa2ad/177b8664-2a2f-11ef-bb8b-6ec2958327c0.png','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_TOSC_8de1d45c-2a29-11ef-8f1c-d8242c6fa8fd_SNAPS','e0f8ef08-2a29-11ef-8f1c-d8242c6fa8fd.png','177b8664-2a2f-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"3.2 Mascella u1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-14 10:41:29.000','2024-06-14 08:41:29.000','2024-06-14 10:41:29.000'),('177bc955-2a2f-11ef-bb8b-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_3d61afe1-2986-11ef-8e16-d517f37fa2ad/177bc955-2a2f-11ef-bb8b-6ec2958327c0.xyz','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_BOSC_80540c46-2a2a-11ef-8f1c-d8242c6fa8fd_LIFI','ef2d44e2-2a2b-11ef-8f1c-d8242c6fa8fd.xyz','177bc955-2a2f-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"3.2 Mandibola l1 Linea di finitura 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-14 10:56:07.000','2024-06-14 08:56:07.000','2024-06-14 10:56:07.000'),('177c0583-2a2f-11ef-bb8b-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_3d61afe1-2986-11ef-8e16-d517f37fa2ad/177c0583-2a2f-11ef-bb8b-6ec2958327c0.bin','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_BOSC_80540c46-2a2a-11ef-8f1c-d8242c6fa8fd_LIFIM','ef2d67d4-2a2b-11ef-8f1c-d8242c6fa8fd.bin','177c0583-2a2f-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"3.2 Mandibola l1 Linea di finitura dei metadati 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-14 10:56:08.000','2024-06-14 08:56:08.000','2024-06-14 10:56:08.000'),('177c3fbd-2a2f-11ef-bb8b-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_3d61afe1-2986-11ef-8e16-d517f37fa2ad/177c3fbd-2a2f-11ef-bb8b-6ec2958327c0.xyz','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_OCC_e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd_LIFIO','ef33f313-2a2b-11ef-8f1c-d8242c6fa8fd.xyz','177c3fbd-2a2f-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"3.2 Occlusione o1 Mandibola l1 Linea di finitura 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MANDIBLE_1\",\"referenceScanFullDisplayId\":\"3.2_l1\",\"referenceScanId\":\"80540c46-2a2a-11ef-8f1c-d8242c6fa8fd\",\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-14 10:56:09.000','2024-06-14 08:56:09.000','2024-06-14 10:56:09.000'),('177d2b5d-2a2f-11ef-bb8b-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_3d61afe1-2986-11ef-8e16-d517f37fa2ad/177d2b5d-2a2f-11ef-bb8b-6ec2958327c0.bin','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_OCC_e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd_LIFIMO','ef341516-2a2b-11ef-8f1c-d8242c6fa8fd.bin','177d2b5d-2a2f-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"3.2 Occlusione o1 Mandibola l1 Linea di finitura dei metadati 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MANDIBLE_1\",\"referenceScanFullDisplayId\":\"3.2_l1\",\"referenceScanId\":\"80540c46-2a2a-11ef-8f1c-d8242c6fa8fd\",\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-14 10:56:09.000','2024-06-14 08:56:09.000','2024-06-14 10:56:09.000'),('18341594-2991-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_d703d726-298d-11ef-8e16-d517f37fa2ad/occlusion_d70636d7-298d-11ef-8e16-d517f37fa2ad/scan_e3221a36-2990-11ef-8e16-d517f37fa2ad/18341594-2991-11ef-8e16-d517f37fa2ad.zip','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_d703d726-298d-11ef-8e16-d517f37fa2ad_SESS_d70636d7-298d-11ef-8e16-d517f37fa2ad_RISC_e3221a36-2990-11ef-8e16-d517f37fa2ad_MODEL','18341594-2991-11ef-8e16-d517f37fa2ad.zip','18341594-2991-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.2 Morso destro br1\",\"modelMatrix\":\"0.996336,0.00122929,0.083002,0,0.00622777,0.999081,-0.042957,0,-0.0854177,0.0429999,0.995627,0,-8.57159,-2.17384,-12.1408,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 16:27:42.483','2024-06-13 14:27:42.915','2024-06-13 16:27:45.957'),('183425ff-2991-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_d703d726-298d-11ef-8e16-d517f37fa2ad/occlusion_d70636d7-298d-11ef-8e16-d517f37fa2ad/scan_e3221a36-2990-11ef-8e16-d517f37fa2ad/183425ff-2991-11ef-8e16-d517f37fa2ad.png','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_d703d726-298d-11ef-8e16-d517f37fa2ad_SESS_d70636d7-298d-11ef-8e16-d517f37fa2ad_RISC_e3221a36-2990-11ef-8e16-d517f37fa2ad_SNAPS','183425ff-2991-11ef-8e16-d517f37fa2ad.png','183425ff-2991-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.2 Morso destro br1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 16:27:42.484','2024-06-13 14:27:42.916','2024-06-13 16:27:46.846'),('18ef19c3-2e4c-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/115617bc-2e4b-11ef-8deb-d515ea58f6cb/session_15f71dc7-2e4b-11ef-8deb-d515ea58f6cb/occlusion_15f94c3c-2e4b-11ef-8deb-d515ea58f6cb/scan_1770b226-2e4b-11ef-8deb-d515ea58f6cb/18ef19c3-2e4c-11ef-8deb-d515ea58f6cb.ply','PATIENT_115617bc-2e4b-11ef-8deb-d515ea58f6cb_ACT_15f71dc7-2e4b-11ef-8deb-d515ea58f6cb_SESS_15f94c3c-2e4b-11ef-8deb-d515ea58f6cb_TOSC_1770b226-2e4b-11ef-8deb-d515ea58f6cb_SEG','18ef19c3-2e4c-11ef-8deb-d515ea58f6cb.ply','026edc4c-2e4c-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"17.1 Maxilla u1 Segmentation [pc2]\"}','PLY',1,'SYNCED',0,NULL,'2024-06-19 16:56:24.893','2024-06-19 14:56:24.953','2024-06-19 16:56:25.445'),('19d016c9-298b-11ef-8e16-d517f37fa2ad',2,'/var/.scan4all/iris/data/2024/2/5062e053-298a-11ef-8e16-d517f37fa2ad/session_a1ebbaf4-298a-11ef-8e16-d517f37fa2ad/occlusion_a1ecf57e-298a-11ef-8e16-d517f37fa2ad/scan_d2eec825-298a-11ef-8e16-d517f37fa2ad/19d016c9-298b-11ef-8e16-d517f37fa2ad.zip','PATIENT_5062e053-298a-11ef-8e16-d517f37fa2ad_ACT_a1ebbaf4-298a-11ef-8e16-d517f37fa2ad_SESS_a1ecf57e-298a-11ef-8e16-d517f37fa2ad_TOSC_d2eec825-298a-11ef-8e16-d517f37fa2ad_MODEL','19d016c9-298b-11ef-8e16-d517f37fa2ad.zip','f29b2b38-298a-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"14.2 Maxillaire u1 [pc2]\",\"modelMatrix\":\"0.975299,-0.145255,-0.166412,0,0.135487,0.988396,-0.0686788,0,0.174457,0.0444356,0.983662,0,-4.61651,-0.104336,-12.1088,1\",\"scanBodies\":[{\"position\":\"6.39155,6,0,0,0.701041,0,6,0,9.72581,0,0,6,1,0,0,0\",\"reference\":\"gfhgfdhg\",\"tid\":16}]}','ZIP',2,'SYNCED',0,NULL,'2024-06-13 15:44:48.203','2024-06-13 13:44:48.792','2024-06-13 15:45:01.578'),('19d03a14-298b-11ef-8e16-d517f37fa2ad',2,'/var/.scan4all/iris/data/2024/2/5062e053-298a-11ef-8e16-d517f37fa2ad/session_a1ebbaf4-298a-11ef-8e16-d517f37fa2ad/occlusion_a1ecf57e-298a-11ef-8e16-d517f37fa2ad/scan_d2eec825-298a-11ef-8e16-d517f37fa2ad/19d03a14-298b-11ef-8e16-d517f37fa2ad.png','PATIENT_5062e053-298a-11ef-8e16-d517f37fa2ad_ACT_a1ebbaf4-298a-11ef-8e16-d517f37fa2ad_SESS_a1ecf57e-298a-11ef-8e16-d517f37fa2ad_TOSC_d2eec825-298a-11ef-8e16-d517f37fa2ad_SNAPS','19d03a14-298b-11ef-8e16-d517f37fa2ad.png','f29b3e20-298a-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"14.2 Maxillaire u1 Snapshot [pc2]\"}','PNG',1,'SYNCED',0,NULL,'2024-06-13 15:44:48.204','2024-06-13 13:44:48.792','2024-06-13 15:45:02.047'),('1a206393-296b-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_4704a021-2963-11ef-8e16-d517f37fa2ad/order_470ab6fc-2963-11ef-8e16-d517f37fa2ad/1a206393-296b-11ef-8e16-d517f37fa2ad.pdf','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_4704a021-2963-11ef-8e16-d517f37fa2ad_PROST_470ab6fc-2963-11ef-8e16-d517f37fa2ad_FORM','1a206393-296b-11ef-8e16-d517f37fa2ad.pdf','1a206393-296b-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.1 Altro\",\"title\":\"Altro\"}','PDF',0,'SYNCED',0,NULL,'2024-06-13 11:55:47.000','2024-06-13 09:55:47.000','2024-06-13 11:55:47.000'),('1a586c71-2981-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_08eb58c6-2980-11ef-8e16-d517f37fa2ad/occlusion_08ed7a4a-2980-11ef-8e16-d517f37fa2ad/computedocclusion_a4bc6912-2980-11ef-8e16-d517f37fa2ad/1a586c71-2981-11ef-8e16-d517f37fa2ad.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_OCC_a4bc6912-2980-11ef-8e16-d517f37fa2ad_TO1','1a586c71-2981-11ef-8e16-d517f37fa2ad.zip','dff96d3d-2980-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.5 Occlusione o1 Mascella u1\",\"modelMatrix\":\"0.0885466,-0.989287,-0.116065,0,0.981849,0.106308,-0.157067,0,0.167723,-0.10005,0.980744,0,7.04315,3.35377,-13.5757,1\",\"occlusionMatrix\":\"-0.171625,0.533856,-0.827981,0,0.982265,0.157301,-0.102183,0,0.0756935,-0.830831,-0.551379,0,5.9597,4.42168,0.971543,1\",\"occlusionType\":3,\"referenceScanFullDisplayId\":\"5.5_u1\",\"referenceScanId\":\"099d82e1-2980-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[],\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":2,\"socleIsFullArch\":true,\"socleThickness\":1,\"socleType\":3}','ZIP',3,'SYNCED',0,NULL,'2024-06-13 14:33:14.129','2024-06-13 12:33:14.261','2024-06-13 14:33:15.149'),('1a58a6a3-2981-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_08eb58c6-2980-11ef-8e16-d517f37fa2ad/occlusion_08ed7a4a-2980-11ef-8e16-d517f37fa2ad/computedocclusion_a4bc6912-2980-11ef-8e16-d517f37fa2ad/1a58a6a3-2981-11ef-8e16-d517f37fa2ad.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_OCC_a4bc6912-2980-11ef-8e16-d517f37fa2ad_BO1','1a58a6a3-2981-11ef-8e16-d517f37fa2ad.zip','e01e29be-2980-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.5 Occlusione o1 Mandibola l1\",\"modelMatrix\":\"-0.0691305,-0.980151,-0.185807,0,0.932705,-0.129585,0.336555,0,-0.353953,-0.150036,0.92315,0,-2.52526,5.094,-12.0573,1\",\"occlusionMatrix\":\"-0.726301,-0.0498987,-0.685575,0,-0.669992,0.274454,0.689787,0,0.15374,0.960326,-0.232761,0,3.4774,-11.0063,-1.91383,1\",\"occlusionType\":3,\"referenceScanFullDisplayId\":\"5.5_l1\",\"referenceScanId\":\"4d76036e-2980-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[],\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":2,\"socleIsFullArch\":true,\"socleThickness\":1,\"socleType\":3}','ZIP',2,'SYNCED',0,NULL,'2024-06-13 14:33:14.131','2024-06-13 12:33:14.261','2024-06-13 14:33:15.751'),('1ad1adb2-233a-11ef-8f93-d92a45da78c9',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_ef3ba736-2337-11ef-8f93-d92a45da78c9/1ad1adb2-233a-11ef-8f93-d92a45da78c9.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_TOSC_ef3ba736-2337-11ef-8f93-d92a45da78c9_SCREENS','1ad1adb2-233a-11ef-8f93-d92a45da78c9.png','1ad1adb2-233a-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Maxillaire u1 Capture d\'écran 1 [pc1]\",\"title\":\"1\"}','PNG',0,'SYNCED',0,NULL,'2024-06-05 14:49:55.000','2024-06-05 12:49:55.000','2024-06-05 14:49:55.000'),('1b66dafd-2269-11ef-8f1f-d8242c71b430',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_757ed4bc-2266-11ef-8f1f-d8242c71b430/occlusion_75806ee1-2266-11ef-8f1f-d8242c71b430/computedocclusion_0b16efeb-2268-11ef-8f1f-d8242c71b430/1b66dafd-2269-11ef-8f1f-d8242c71b430.xyz','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_OCC_0b16efeb-2268-11ef-8f1f-d8242c71b430_LIFIO','1b66dafd-2269-11ef-8f1f-d8242c71b430.xyz','1b66dafd-2269-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.2 Occlusion o1 Maxillaire u1 Ligne de finition auto\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY_1\",\"referenceScanFullDisplayId\":\"1.2_u1\",\"referenceScanId\":\"09768650-2267-11ef-8f1f-d8242c71b430\",\"title\":\"auto\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-04 13:53:49.000','2024-06-04 11:55:50.000','2024-06-04 13:55:50.000'),('1b66de9f-2269-11ef-8f1f-d8242c71b430',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_757ed4bc-2266-11ef-8f1f-d8242c71b430/occlusion_75806ee1-2266-11ef-8f1f-d8242c71b430/computedocclusion_0b16efeb-2268-11ef-8f1f-d8242c71b430/1b66de9f-2269-11ef-8f1f-d8242c71b430.bin','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_OCC_0b16efeb-2268-11ef-8f1f-d8242c71b430_LIFIMO','1b66de9f-2269-11ef-8f1f-d8242c71b430.bin','1b66de9f-2269-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.2 Occlusion o1 Maxillaire u1 Ligne de finition métadonnées auto\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY_1\",\"referenceScanFullDisplayId\":\"1.2_u1\",\"referenceScanId\":\"09768650-2267-11ef-8f1f-d8242c71b430\",\"title\":\"auto\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-04 13:53:49.000','2024-06-04 11:55:49.000','2024-06-04 13:55:49.000'),('1b69c905-2730-11ef-8e16-d517f37fa1ab',2,'/var/.scan4all/iris/data/2024/2/f3e99d3d-272f-11ef-8e16-d517f37fa1ab/session_ff43b7ab-272f-11ef-8e16-d517f37fa1ab/occlusion_ff4617e9-272f-11ef-8e16-d517f37fa1ab/scan_00f317ff-2730-11ef-8e16-d517f37fa1ab/1b69c905-2730-11ef-8e16-d517f37fa1ab.zip','PATIENT_f3e99d3d-272f-11ef-8e16-d517f37fa1ab_ACT_ff43b7ab-272f-11ef-8e16-d517f37fa1ab_SESS_ff4617e9-272f-11ef-8e16-d517f37fa1ab_TOSC_00f317ff-2730-11ef-8e16-d517f37fa1ab_MODEL','1b69c905-2730-11ef-8e16-d517f37fa1ab.zip','1b69c905-2730-11ef-8e16-d517f37fa1ab','{\"displayTitle\":\"4.1 Maxillaire u1 [pc2]\",\"modelMatrix\":\"-0.478319,-0.877922,-0.0215511,0,0.874528,-0.478421,0.0794565,0,-0.0800671,0.0191585,0.996605,0,5.87988,6.57523,-11.3854,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-10 15:48:28.000','2024-06-10 13:48:28.000','2024-06-10 15:48:28.000'),('1b69de98-2730-11ef-8e16-d517f37fa1ab',2,'/var/.scan4all/iris/data/2024/2/f3e99d3d-272f-11ef-8e16-d517f37fa1ab/session_ff43b7ab-272f-11ef-8e16-d517f37fa1ab/occlusion_ff4617e9-272f-11ef-8e16-d517f37fa1ab/scan_00f317ff-2730-11ef-8e16-d517f37fa1ab/1b69de98-2730-11ef-8e16-d517f37fa1ab.png','PATIENT_f3e99d3d-272f-11ef-8e16-d517f37fa1ab_ACT_ff43b7ab-272f-11ef-8e16-d517f37fa1ab_SESS_ff4617e9-272f-11ef-8e16-d517f37fa1ab_TOSC_00f317ff-2730-11ef-8e16-d517f37fa1ab_SNAPS','1b69de98-2730-11ef-8e16-d517f37fa1ab.png','1b69de98-2730-11ef-8e16-d517f37fa1ab','{\"displayTitle\":\"4.1 Maxillaire u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-10 15:48:29.000','2024-06-10 13:48:29.000','2024-06-10 15:48:29.000'),('1b924576-2985-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_a8885309-2984-11ef-8e16-d517f37fa2ad/occlusion_a888b842-2984-11ef-8e16-d517f37fa2ad/scan_de3fd237-2984-11ef-8e16-d517f37fa2ad/1b924576-2985-11ef-8e16-d517f37fa2ad.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_a8885309-2984-11ef-8e16-d517f37fa2ad_SESS_a888b842-2984-11ef-8e16-d517f37fa2ad_TOSC_de3fd237-2984-11ef-8e16-d517f37fa2ad_MODEL','1b924576-2985-11ef-8e16-d517f37fa2ad.zip','de3ffbb4-2984-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.7 Mascella u2\",\"modelMatrix\":\"0.676804,-0.736112,0.00867294,0,0.735905,0.676831,0.0185321,0,-0.0195118,-0.00616012,0.999791,0,-5.57178,10.6847,-13.2414,1\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2024-06-13 15:01:54.173','2024-06-13 13:05:35.403','2024-06-13 15:05:40.967'),('1c9626b7-2279-11ef-8d76-d310d2ec2c14',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/computedocclusion_9ed6352b-2277-11ef-8d76-d310d2ec2c14/1c9626b7-2279-11ef-8d76-d310d2ec2c14.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_OCC_9ed6352b-2277-11ef-8d76-d310d2ec2c14_SCREENO','1c9626b7-2279-11ef-8d76-d310d2ec2c14.png','1c9626b7-2279-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Occlusion o2 Capture d\'écran 1 [pc2]\",\"occlusionType\":5,\"title\":\"1\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 15:48:25.000','2024-06-04 13:48:25.000','2024-06-04 15:48:25.000'),('1d1765b7-2e42-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/4382037a-2735-11ef-8e16-d517f37fa1ab/session_8598ee4a-2e40-11ef-8deb-d515ea58f6cb/occlusion_859bd7ba-2e40-11ef-8deb-d515ea58f6cb/scan_0cf35705-2e42-11ef-8deb-d515ea58f6cb/1d1765b7-2e42-11ef-8deb-d515ea58f6cb.zip','PATIENT_4382037a-2735-11ef-8e16-d517f37fa1ab_ACT_8598ee4a-2e40-11ef-8deb-d515ea58f6cb_SESS_859bd7ba-2e40-11ef-8deb-d515ea58f6cb_BOSC_0cf35705-2e42-11ef-8deb-d515ea58f6cb_MODEL','1d1765b7-2e42-11ef-8deb-d515ea58f6cb.zip','1d1765b7-2e42-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"6.3 Mandible l1 [pc2]\",\"modelMatrix\":\"0.991872,0.127193,-0.00336698,0,-0.127209,0.990738,-0.0474952,0,-0.00270526,0.0475375,0.998866,0,1.56206,0.545778,-12.7178,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-19 15:45:00.000','2024-06-19 13:45:00.000','2024-06-19 15:45:00.000'),('1d1774ff-2e42-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/4382037a-2735-11ef-8e16-d517f37fa1ab/session_8598ee4a-2e40-11ef-8deb-d515ea58f6cb/occlusion_859bd7ba-2e40-11ef-8deb-d515ea58f6cb/scan_0cf35705-2e42-11ef-8deb-d515ea58f6cb/1d1774ff-2e42-11ef-8deb-d515ea58f6cb.png','PATIENT_4382037a-2735-11ef-8e16-d517f37fa1ab_ACT_8598ee4a-2e40-11ef-8deb-d515ea58f6cb_SESS_859bd7ba-2e40-11ef-8deb-d515ea58f6cb_BOSC_0cf35705-2e42-11ef-8deb-d515ea58f6cb_SNAPS','1d1774ff-2e42-11ef-8deb-d515ea58f6cb.png','1d1774ff-2e42-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"6.3 Mandible l1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-19 15:45:00.000','2024-06-19 13:45:00.000','2024-06-19 15:45:00.000'),('1d51af59-2991-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_d703d726-298d-11ef-8e16-d517f37fa2ad/occlusion_d70636d7-298d-11ef-8e16-d517f37fa2ad/computedocclusion_e08676da-2990-11ef-8e16-d517f37fa2ad/1d51af59-2991-11ef-8e16-d517f37fa2ad.zip','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_d703d726-298d-11ef-8e16-d517f37fa2ad_SESS_d70636d7-298d-11ef-8e16-d517f37fa2ad_OCC_e08676da-2990-11ef-8e16-d517f37fa2ad_TO1','1d51af59-2991-11ef-8e16-d517f37fa2ad.zip','1d51af59-2991-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.2 Occlusione o1 Mascella u1\",\"modelMatrix\":\"0.975516,-0.148096,-0.162593,0,0.128141,0.983582,-0.127067,0,0.178742,0.103121,0.978477,0,-16.8719,-1.29266,-12.1772,1\",\"occlusionMatrix\":\"0.98222,0.160147,-0.0981625,0,0.100216,-0.0047738,0.994967,0,0.158874,-0.987087,-0.0207343,0,-15.0924,7.74345,-0.0261059,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.2_u1\",\"referenceScanId\":\"2ed06b9e-298f-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 16:27:51.066','2024-06-13 14:27:51.465','2024-06-13 16:27:52.540'),('1d6db867-2991-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_d703d726-298d-11ef-8e16-d517f37fa2ad/occlusion_d70636d7-298d-11ef-8e16-d517f37fa2ad/computedocclusion_e08676da-2990-11ef-8e16-d517f37fa2ad/1d6db867-2991-11ef-8e16-d517f37fa2ad.zip','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_d703d726-298d-11ef-8e16-d517f37fa2ad_SESS_d70636d7-298d-11ef-8e16-d517f37fa2ad_OCC_e08676da-2990-11ef-8e16-d517f37fa2ad_BO1','1d6db867-2991-11ef-8e16-d517f37fa2ad.zip','1d6db867-2991-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.2 Occlusione o1 Mandibola l1\",\"modelMatrix\":\"0.997996,0.0253681,-0.0579621,0,-0.0223453,0.998386,0.0522168,0,0.0591932,-0.050817,0.996952,0,-12.5419,-0.543902,-13.1251,1\",\"occlusionMatrix\":\"0.99683,-0.0794793,-0.00662431,0,-0.0269223,-0.257144,-0.966008,0,0.0750737,0.963109,-0.258465,0,-13.9285,-7.8758,4.47367,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.2_l1\",\"referenceScanId\":\"99d1c412-2990-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 16:27:51.250','2024-06-13 14:27:51.466','2024-06-13 16:27:53.440'),('1deb7d5b-2991-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_d703d726-298d-11ef-8e16-d517f37fa2ad/occlusion_d70636d7-298d-11ef-8e16-d517f37fa2ad/computedocclusion_e08676da-2990-11ef-8e16-d517f37fa2ad/1deb7d5b-2991-11ef-8e16-d517f37fa2ad.png','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_d703d726-298d-11ef-8e16-d517f37fa2ad_SESS_d70636d7-298d-11ef-8e16-d517f37fa2ad_OCC_e08676da-2990-11ef-8e16-d517f37fa2ad_SNAPO','1deb7d5b-2991-11ef-8e16-d517f37fa2ad.png','1deb7d5b-2991-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.2 Occlusione o1\",\"occlusionType\":1}','PNG',0,'SYNCED',0,NULL,'2024-06-13 16:27:52.074','2024-06-13 14:27:52.076','2024-06-13 16:27:53.955'),('1faa40ce-296a-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_4704a021-2963-11ef-8e16-d517f37fa2ad/occlusion_4706df6f-2963-11ef-8e16-d517f37fa2ad/computedocclusion_9153c588-2968-11ef-8e16-d517f37fa2ad/1faa40ce-296a-11ef-8e16-d517f37fa2ad.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_4704a021-2963-11ef-8e16-d517f37fa2ad_SESS_4706df6f-2963-11ef-8e16-d517f37fa2ad_OCC_9153c588-2968-11ef-8e16-d517f37fa2ad_TO1','1faa40ce-296a-11ef-8e16-d517f37fa2ad.zip','1faa40ce-296a-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.1 Occlusione o1 Mascella u1\",\"modelMatrix\":\"0.432825,-0.89967,-0.0570733,0,0.880417,0.43547,-0.187701,0,0.193722,0.0309933,0.980567,0,-23.5715,9.30099,-17.1386,1\",\"occlusionMatrix\":\"0.432825,0.0570733,-0.89967,0,0.880417,0.187701,0.43547,0,0.193722,-0.980567,0.0309933,0,-23.5715,17.1386,9.30099,1\",\"occlusionType\":5,\"referenceScanFullDisplayId\":\"5.1_u1\",\"referenceScanId\":\"47f95341-2963-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 11:48:50.000','2024-06-13 09:48:50.000','2024-06-13 11:48:50.000'),('1ff1bee2-296a-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_4704a021-2963-11ef-8e16-d517f37fa2ad/occlusion_4706df6f-2963-11ef-8e16-d517f37fa2ad/computedocclusion_9153c588-2968-11ef-8e16-d517f37fa2ad/1ff1bee2-296a-11ef-8e16-d517f37fa2ad.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_4704a021-2963-11ef-8e16-d517f37fa2ad_SESS_4706df6f-2963-11ef-8e16-d517f37fa2ad_OCC_9153c588-2968-11ef-8e16-d517f37fa2ad_BO1','1ff1bee2-296a-11ef-8e16-d517f37fa2ad.zip','1ff1bee2-296a-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.1 Occlusione o1 Mandibola l2\",\"modelMatrix\":\"-0.333428,-0.941176,-0.0548981,0,0.935492,-0.323066,-0.143118,0,0.116963,-0.0990761,0.988182,0,22.6045,17.8478,-19.0898,1\",\"occlusionMatrix\":\"0.580684,0.00521955,-0.814123,0,-0.608116,-0.662091,-0.43799,0,-0.5413,0.749411,-0.381284,0,-23.9511,-12.3846,13.7312,1\",\"occlusionType\":5,\"referenceScanFullDisplayId\":\"5.1_l2\",\"referenceScanId\":\"f3a386e0-2965-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 11:48:51.000','2024-06-13 09:48:51.000','2024-06-13 11:48:51.000'),('1ffb9e9c-2338-11ef-8f93-d92a45da78c9',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_ef3ba736-2337-11ef-8f93-d92a45da78c9/1ffb9e9c-2338-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_TOSC_ef3ba736-2337-11ef-8f93-d92a45da78c9_MODEL','1ffb9e9c-2338-11ef-8f93-d92a45da78c9.zip','1ffb9e9c-2338-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Maxillaire u1 [pc1]\",\"modelMatrix\":\"-0.923468,0.0376561,-0.381824,0,-0.158116,-0.944087,0.289308,0,-0.349581,0.327539,0.877788,0,12.8471,-2.21044,-5.73295,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-05 14:35:47.000','2024-06-05 12:35:47.000','2024-06-05 14:35:47.000'),('1ffbaca6-2338-11ef-8f93-d92a45da78c9',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_ef3ba736-2337-11ef-8f93-d92a45da78c9/1ffbaca6-2338-11ef-8f93-d92a45da78c9.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_TOSC_ef3ba736-2337-11ef-8f93-d92a45da78c9_SNAPS','1ffbaca6-2338-11ef-8f93-d92a45da78c9.png','1ffbaca6-2338-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Maxillaire u1 Snapshot [pc1]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-05 14:35:48.000','2024-06-05 12:35:48.000','2024-06-05 14:35:48.000'),('202d91d6-2984-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_08eb58c6-2980-11ef-8e16-d517f37fa2ad/order_08f4c372-2980-11ef-8e16-d517f37fa2ad/202d91d6-2984-11ef-8e16-d517f37fa2ad.pdf','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_PROST_08f4c372-2980-11ef-8e16-d517f37fa2ad_FORM','202d91d6-2984-11ef-8e16-d517f37fa2ad.pdf','202d91d6-2984-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.5 faccette per i denti 11 e 12\",\"title\":\"faccette per i denti 11 e 12\"}','PDF',0,'SYNCED',0,NULL,'2024-06-13 14:54:54.000','2024-06-13 12:54:54.000','2024-06-13 14:54:54.000'),('204c79d2-2e0f-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/ce57500b-227c-11ef-8d76-d310d2ec2c14/session_da355fe4-227c-11ef-8d76-d310d2ec2c14/occlusion_da37d213-227c-11ef-8d76-d310d2ec2c14/scan_e631c430-2e0e-11ef-8deb-d515ea58f6cb/204c79d2-2e0f-11ef-8deb-d515ea58f6cb.ply','PATIENT_ce57500b-227c-11ef-8d76-d310d2ec2c14_ACT_da355fe4-227c-11ef-8d76-d310d2ec2c14_SESS_da37d213-227c-11ef-8d76-d310d2ec2c14_TOSC_e631c430-2e0e-11ef-8deb-d515ea58f6cb_SEG','204c79d2-2e0f-11ef-8deb-d515ea58f6cb.ply','204c79d2-2e0f-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"3.1 Maxillaire u2 Segmentation [pc2]\"}','PLY',0,'CREATED',0,'2024-06-19 09:40:04.013','2024-06-19 09:40:04.013','2024-06-19 07:40:04.014',NULL),('21107477-296a-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_4704a021-2963-11ef-8e16-d517f37fa2ad/occlusion_4706df6f-2963-11ef-8e16-d517f37fa2ad/computedocclusion_9153c588-2968-11ef-8e16-d517f37fa2ad/21107477-296a-11ef-8e16-d517f37fa2ad.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_4704a021-2963-11ef-8e16-d517f37fa2ad_SESS_4706df6f-2963-11ef-8e16-d517f37fa2ad_OCC_9153c588-2968-11ef-8e16-d517f37fa2ad_SNAPO','21107477-296a-11ef-8e16-d517f37fa2ad.png','21107477-296a-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.1 Occlusione o1\",\"occlusionType\":5}','PNG',0,'SYNCED',0,NULL,'2024-06-13 11:48:51.000','2024-06-13 09:48:51.000','2024-06-13 11:48:51.000'),('22738ca4-298b-11ef-8e16-d517f37fa2ad',2,'/var/.scan4all/iris/data/2024/2/5062e053-298a-11ef-8e16-d517f37fa2ad/session_a1ebbaf4-298a-11ef-8e16-d517f37fa2ad/occlusion_a1ecf57e-298a-11ef-8e16-d517f37fa2ad/scan_d2eec825-298a-11ef-8e16-d517f37fa2ad/22738ca4-298b-11ef-8e16-d517f37fa2ad.zip','PATIENT_5062e053-298a-11ef-8e16-d517f37fa2ad_ACT_a1ebbaf4-298a-11ef-8e16-d517f37fa2ad_SESS_a1ecf57e-298a-11ef-8e16-d517f37fa2ad_TOSC_d2eec825-298a-11ef-8e16-d517f37fa2ad_MODEL','22738ca4-298b-11ef-8e16-d517f37fa2ad.zip','f29b2b38-298a-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"14.2 Maxillaire u1 [pc2]\",\"modelMatrix\":\"0.975299,-0.145255,-0.166412,0,0.135487,0.988396,-0.0686788,0,0.174457,0.0444356,0.983662,0,-4.61651,-0.104336,-12.1088,1\",\"scanBodies\":[{\"position\":\"6.39155,6,0,0,0.701041,0,6,0,9.72581,0,0,6,1,0,0,0\",\"reference\":\"gfhgfdhg\",\"tid\":16}]}','ZIP',3,'SYNCED',0,NULL,'2024-06-13 15:45:02.696','2024-06-13 13:45:02.733','2024-06-13 15:45:02.950'),('22927091-2984-11ef-867c-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_1a8fdf3a-296b-11ef-8e16-d517f37fa2ad/22927091-2984-11ef-867c-6ec2958327c0.pdf','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_PROST_08f4c372-2980-11ef-8e16-d517f37fa2ad_FORM','202d91d6-2984-11ef-8e16-d517f37fa2ad.pdf','22927091-2984-11ef-867c-6ec2958327c0','{\"displayTitle\":\"5.5 faccette per i denti 11 e 12\",\"title\":\"faccette per i denti 11 e 12\"}','PDF',0,'SYNCED',0,NULL,'2024-06-13 14:54:54.000','2024-06-13 12:54:54.000','2024-06-13 14:54:54.000'),('22a0b370-2984-11ef-867c-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_1a8fdf3a-296b-11ef-8e16-d517f37fa2ad/22a0b370-2984-11ef-867c-6ec2958327c0.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_OCC_a4bc6912-2980-11ef-8e16-d517f37fa2ad_TO1','43ea5aab-2981-11ef-8e16-d517f37fa2ad.zip','22a0b370-2984-11ef-867c-6ec2958327c0','{\"displayTitle\":\"5.5 Occlusione o1 Mascella u1\",\"modelMatrix\":\"0.0885466,-0.989287,-0.116065,0,0.981849,0.106308,-0.157067,0,0.167723,-0.10005,0.980744,0,7.04315,3.35377,-13.5757,1\",\"occlusionMatrix\":\"-0.171625,0.533856,-0.827981,0,0.982265,0.157301,-0.102183,0,0.0756935,-0.830831,-0.551379,0,5.9597,4.42168,0.971543,1\",\"occlusionType\":3,\"referenceScanFullDisplayId\":\"5.5_u1\",\"referenceScanId\":\"099d82e1-2980-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[],\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":2,\"socleIsFullArch\":true,\"socleThickness\":1,\"socleType\":4}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 14:34:26.000','2024-06-13 12:34:26.000','2024-06-13 14:34:26.000'),('22ade901-2984-11ef-867c-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_1a8fdf3a-296b-11ef-8e16-d517f37fa2ad/22ade901-2984-11ef-867c-6ec2958327c0.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_OCC_a4bc6912-2980-11ef-8e16-d517f37fa2ad_BO1','43ea9afd-2981-11ef-8e16-d517f37fa2ad.zip','22ade901-2984-11ef-867c-6ec2958327c0','{\"displayTitle\":\"5.5 Occlusione o1 Mandibola l1\",\"modelMatrix\":\"-0.0691305,-0.980151,-0.185807,0,0.932705,-0.129585,0.336555,0,-0.353953,-0.150036,0.92315,0,-2.52526,5.094,-12.0573,1\",\"occlusionMatrix\":\"-0.726301,-0.0498987,-0.685575,0,-0.669992,0.274454,0.689787,0,0.15374,0.960326,-0.232761,0,3.4774,-11.0063,-1.91383,1\",\"occlusionType\":3,\"referenceScanFullDisplayId\":\"5.5_l1\",\"referenceScanId\":\"4d76036e-2980-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[],\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":2,\"socleIsFullArch\":true,\"socleThickness\":1,\"socleType\":4}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 14:34:26.000','2024-06-13 12:34:26.000','2024-06-13 14:34:26.000'),('22ae315a-2984-11ef-867c-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_1a8fdf3a-296b-11ef-8e16-d517f37fa2ad/22ae315a-2984-11ef-867c-6ec2958327c0.json','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_OCC_a4bc6912-2980-11ef-8e16-d517f37fa2ad_METER','7dc312cb-2981-11ef-8e16-d517f37fa2ad.json','22ae315a-2984-11ef-867c-6ec2958327c0','{\"displayTitle\":\"5.5 Occlusione o1\",\"occlusionType\":3}','JSON',0,'SYNCED',0,NULL,'2024-06-13 14:36:02.000','2024-06-13 12:36:02.000','2024-06-13 14:36:02.000'),('22ae75c5-2984-11ef-867c-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_1a8fdf3a-296b-11ef-8e16-d517f37fa2ad/22ae75c5-2984-11ef-867c-6ec2958327c0.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_OCC_a4bc6912-2980-11ef-8e16-d517f37fa2ad_SCREENO','be9062f3-2982-11ef-8e16-d517f37fa2ad.png','22ae75c5-2984-11ef-867c-6ec2958327c0','{\"displayTitle\":\"5.5 Occlusione o1 Screenshot 1\",\"occlusionType\":3,\"title\":\"1\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 14:45:00.000','2024-06-13 12:45:00.000','2024-06-13 14:45:00.000'),('22aeb6c7-2984-11ef-867c-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_1a8fdf3a-296b-11ef-8e16-d517f37fa2ad/22aeb6c7-2984-11ef-867c-6ec2958327c0.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_TOSC_099d82e1-2980-11ef-8e16-d517f37fa2ad_SCREENS','c5e732c1-2983-11ef-8e16-d517f37fa2ad.png','22aeb6c7-2984-11ef-867c-6ec2958327c0','{\"displayTitle\":\"5.5 Mascella u1 Screenshot 1\",\"title\":\"1\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 14:52:22.000','2024-06-13 12:52:22.000','2024-06-13 14:52:22.000'),('22aef86a-2984-11ef-867c-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_1a8fdf3a-296b-11ef-8e16-d517f37fa2ad/22aef86a-2984-11ef-867c-6ec2958327c0.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_OCC_a4bc6912-2980-11ef-8e16-d517f37fa2ad_SNAPO','e09fbf20-2980-11ef-8e16-d517f37fa2ad.png','22aef86a-2984-11ef-867c-6ec2958327c0','{\"displayTitle\":\"5.5 Occlusione o1\",\"occlusionType\":3}','PNG',0,'SYNCED',0,NULL,'2024-06-13 14:31:40.000','2024-06-13 12:31:40.000','2024-06-13 14:31:40.000'),('22b1f5c3-2984-11ef-867c-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_1a8fdf3a-296b-11ef-8e16-d517f37fa2ad/22b1f5c3-2984-11ef-867c-6ec2958327c0.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_OCC_a4bc6912-2980-11ef-8e16-d517f37fa2ad_SCREENO','e3ffe01f-2982-11ef-8e16-d517f37fa2ad.png','22b1f5c3-2984-11ef-867c-6ec2958327c0','{\"displayTitle\":\"5.5 Occlusione o1 Screenshot 3\",\"occlusionType\":3,\"title\":\"3\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 14:46:04.000','2024-06-13 12:46:04.000','2024-06-13 14:46:04.000'),('22ecf343-296b-11ef-867c-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_1a8fdf3a-296b-11ef-8e16-d517f37fa2ad/22ecf343-296b-11ef-867c-6ec2958327c0.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_4704a021-2963-11ef-8e16-d517f37fa2ad_SESS_4706df6f-2963-11ef-8e16-d517f37fa2ad_TOSC_47f95341-2963-11ef-8e16-d517f37fa2ad_MODEL','089e2b2d-296b-11ef-8e16-d517f37fa2ad.zip','22ecf343-296b-11ef-867c-6ec2958327c0','{\"displayTitle\":\"5.1 Mascella u1\",\"modelMatrix\":\"0.432825,-0.89967,-0.0570733,0,0.880417,0.43547,-0.187701,0,0.193722,0.0309933,0.980567,0,-23.5715,9.30099,-17.1386,1\",\"scanBodies\":[],\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":2,\"socleIsFullArch\":true,\"socleThickness\":-1,\"socleType\":1}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 11:55:18.000','2024-06-13 09:55:18.000','2024-06-13 11:55:18.000'),('22f04150-296b-11ef-867c-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_1a8fdf3a-296b-11ef-8e16-d517f37fa2ad/22f04150-296b-11ef-867c-6ec2958327c0.pdf','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_4704a021-2963-11ef-8e16-d517f37fa2ad_PROST_470ab6fc-2963-11ef-8e16-d517f37fa2ad_FORM','1a206393-296b-11ef-8e16-d517f37fa2ad.pdf','22f04150-296b-11ef-867c-6ec2958327c0','{\"displayTitle\":\"5.1 Altro\",\"title\":\"Altro\"}','PDF',0,'SYNCED',0,NULL,'2024-06-13 11:55:47.000','2024-06-13 09:55:47.000','2024-06-13 11:55:47.000'),('22f0827d-296b-11ef-867c-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_1a8fdf3a-296b-11ef-8e16-d517f37fa2ad/22f0827d-296b-11ef-867c-6ec2958327c0.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_4704a021-2963-11ef-8e16-d517f37fa2ad_SESS_4706df6f-2963-11ef-8e16-d517f37fa2ad_OCC_9153c588-2968-11ef-8e16-d517f37fa2ad_SNAPO','21107477-296a-11ef-8e16-d517f37fa2ad.png','22f0827d-296b-11ef-867c-6ec2958327c0','{\"displayTitle\":\"5.1 Occlusione o1\",\"occlusionType\":5}','PNG',0,'SYNCED',0,NULL,'2024-06-13 11:48:51.000','2024-06-13 09:48:51.000','2024-06-13 11:48:51.000'),('22f0d1a2-296b-11ef-867c-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_1a8fdf3a-296b-11ef-8e16-d517f37fa2ad/22f0d1a2-296b-11ef-867c-6ec2958327c0.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_4704a021-2963-11ef-8e16-d517f37fa2ad_SESS_4706df6f-2963-11ef-8e16-d517f37fa2ad_TOSC_47f95341-2963-11ef-8e16-d517f37fa2ad_SNAPS','64880729-2964-11ef-8e16-d517f37fa2ad.png','22f0d1a2-296b-11ef-867c-6ec2958327c0','{\"displayTitle\":\"5.1 Mascella u1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 11:07:55.000','2024-06-13 09:07:55.000','2024-06-13 11:07:55.000'),('22f11528-296b-11ef-867c-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_1a8fdf3a-296b-11ef-8e16-d517f37fa2ad/22f11528-296b-11ef-867c-6ec2958327c0.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_4704a021-2963-11ef-8e16-d517f37fa2ad_SESS_4706df6f-2963-11ef-8e16-d517f37fa2ad_OCC_9153c588-2968-11ef-8e16-d517f37fa2ad_TO1','a8c82bcb-296a-11ef-8e16-d517f37fa2ad.zip','22f11528-296b-11ef-867c-6ec2958327c0','{\"displayTitle\":\"5.1 Occlusione o1 Mascella u1\",\"modelMatrix\":\"0.432825,-0.89967,-0.0570733,0,0.880417,0.43547,-0.187701,0,0.193722,0.0309933,0.980567,0,-23.5715,9.30099,-17.1386,1\",\"occlusionMatrix\":\"0.457763,0.0354936,-0.888366,0,0.863851,0.218564,0.453863,0,0.210273,-0.975177,0.0693891,0,-25.0416,17.0547,6.08757,1\",\"occlusionType\":5,\"referenceScanFullDisplayId\":\"5.1_u1\",\"referenceScanId\":\"47f95341-2963-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 11:52:38.000','2024-06-13 09:52:38.000','2024-06-13 11:52:38.000'),('22f2c0d8-296b-11ef-867c-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_1a8fdf3a-296b-11ef-8e16-d517f37fa2ad/22f2c0d8-296b-11ef-867c-6ec2958327c0.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_4704a021-2963-11ef-8e16-d517f37fa2ad_SESS_4706df6f-2963-11ef-8e16-d517f37fa2ad_OCC_9153c588-2968-11ef-8e16-d517f37fa2ad_BO1','a90adf72-296a-11ef-8e16-d517f37fa2ad.zip','22f2c0d8-296b-11ef-867c-6ec2958327c0','{\"displayTitle\":\"5.1 Occlusione o1 Mandibola l2\",\"modelMatrix\":\"-0.333428,-0.941176,-0.0548981,0,0.935492,-0.323066,-0.143118,0,0.116963,-0.0990761,0.988182,0,22.6045,17.8478,-19.0898,1\",\"occlusionMatrix\":\"0.525605,-0.28243,-0.802491,0,-0.85016,-0.139511,-0.50772,0,0.0314434,0.949097,-0.313429,0,-28.7739,-3.69969,13.2005,1\",\"occlusionType\":5,\"referenceScanFullDisplayId\":\"5.1_l2\",\"referenceScanId\":\"f3a386e0-2965-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 11:52:39.000','2024-06-13 09:52:39.000','2024-06-13 11:52:39.000'),('22f3003b-296b-11ef-867c-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_1a8fdf3a-296b-11ef-8e16-d517f37fa2ad/22f3003b-296b-11ef-867c-6ec2958327c0.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_4704a021-2963-11ef-8e16-d517f37fa2ad_SESS_4706df6f-2963-11ef-8e16-d517f37fa2ad_BOSC_f3a386e0-2965-11ef-8e16-d517f37fa2ad_MODEL','c80e9775-2966-11ef-8e16-d517f37fa2ad.zip','22f3003b-296b-11ef-867c-6ec2958327c0','{\"displayTitle\":\"5.1 Mandibola l2\",\"modelMatrix\":\"-0.333428,-0.941176,-0.0548981,0,0.935492,-0.323066,-0.143118,0,0.116963,-0.0990761,0.988182,0,22.6045,17.8478,-19.0898,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 11:24:54.000','2024-06-13 09:24:54.000','2024-06-13 11:24:54.000'),('22f34008-296b-11ef-867c-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_1a8fdf3a-296b-11ef-8e16-d517f37fa2ad/22f34008-296b-11ef-867c-6ec2958327c0.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_4704a021-2963-11ef-8e16-d517f37fa2ad_SESS_4706df6f-2963-11ef-8e16-d517f37fa2ad_BOSC_f3a386e0-2965-11ef-8e16-d517f37fa2ad_SNAPS','c80fd072-2966-11ef-8e16-d517f37fa2ad.png','22f34008-296b-11ef-867c-6ec2958327c0','{\"displayTitle\":\"5.1 Mandibola l2 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 11:24:55.000','2024-06-13 09:24:55.000','2024-06-13 11:24:55.000'),('23d695ae-2e0f-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/ce57500b-227c-11ef-8d76-d310d2ec2c14/session_da355fe4-227c-11ef-8d76-d310d2ec2c14/occlusion_da37d213-227c-11ef-8d76-d310d2ec2c14/scan_e631c430-2e0e-11ef-8deb-d515ea58f6cb/23d695ae-2e0f-11ef-8deb-d515ea58f6cb.zip','PATIENT_ce57500b-227c-11ef-8d76-d310d2ec2c14_ACT_da355fe4-227c-11ef-8d76-d310d2ec2c14_SESS_da37d213-227c-11ef-8d76-d310d2ec2c14_TOSC_e631c430-2e0e-11ef-8deb-d515ea58f6cb_MODEL','23d695ae-2e0f-11ef-8deb-d515ea58f6cb.zip','f6bd91e1-2e0e-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"3.1 Maxillaire u2 [pc2]\",\"modelMatrix\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"scanBodies\":[{\"position\":\"10.4552,6,0,0,3.27905,0,6,0,12.8519,0,0,6,1,0,0,0\",\"reference\":\"K30PSCANPLG\",\"tid\":16}]}','ZIP',1,'SYNCED',0,NULL,'2024-06-19 09:40:03.887','2024-06-19 07:40:03.927','2024-06-19 12:49:13.206'),('242c6766-23e9-11ef-8dde-d415e84cc4f5',3,'/var/.scan4all/iris/data/2024/3/907398e3-23e7-11ef-8dde-d415e84cc4f5/session_0bcc91ed-23e9-11ef-8dde-d415e84cc4f5/occlusion_0bcebe79-23e9-11ef-8dde-d415e84cc4f5/scan_0d3f3b92-23e9-11ef-8dde-d415e84cc4f5/242c6766-23e9-11ef-8dde-d415e84cc4f5.zip','PATIENT_907398e3-23e7-11ef-8dde-d415e84cc4f5_ACT_0bcc91ed-23e9-11ef-8dde-d415e84cc4f5_SESS_0bcebe79-23e9-11ef-8dde-d415e84cc4f5_TOSC_0d3f3b92-23e9-11ef-8dde-d415e84cc4f5_MODEL','242c6766-23e9-11ef-8dde-d415e84cc4f5.zip','242c6766-23e9-11ef-8dde-d415e84cc4f5','{\"displayTitle\":\"2.2 Maxillaire u1 [pc1]\",\"modelMatrix\":\"-0.98612,0.162098,-0.0359523,0,-0.162664,-0.899746,0.404967,0,0.0332962,0.405194,0.913624,0,8.13953,-5.86615,-13.6249,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-06 11:42:54.000','2024-06-06 09:42:54.000','2024-06-06 11:42:54.000'),('242c7d2a-23e9-11ef-8dde-d415e84cc4f5',3,'/var/.scan4all/iris/data/2024/3/907398e3-23e7-11ef-8dde-d415e84cc4f5/session_0bcc91ed-23e9-11ef-8dde-d415e84cc4f5/occlusion_0bcebe79-23e9-11ef-8dde-d415e84cc4f5/scan_0d3f3b92-23e9-11ef-8dde-d415e84cc4f5/242c7d2a-23e9-11ef-8dde-d415e84cc4f5.png','PATIENT_907398e3-23e7-11ef-8dde-d415e84cc4f5_ACT_0bcc91ed-23e9-11ef-8dde-d415e84cc4f5_SESS_0bcebe79-23e9-11ef-8dde-d415e84cc4f5_TOSC_0d3f3b92-23e9-11ef-8dde-d415e84cc4f5_SNAPS','242c7d2a-23e9-11ef-8dde-d415e84cc4f5.png','242c7d2a-23e9-11ef-8dde-d415e84cc4f5','{\"displayTitle\":\"2.2 Maxillaire u1 Snapshot [pc1]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-06 11:42:55.000','2024-06-06 09:42:55.000','2024-06-06 11:42:55.000'),('24467343-28a0-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/f373c86a-2899-11ef-8e16-d517f37fa2ad/session_627cfe1c-289b-11ef-8e16-d517f37fa2ad/order_0187211b-28a0-11ef-8e16-d517f37fa2ad/24467343-28a0-11ef-8e16-d517f37fa2ad.pdf','PATIENT_f373c86a-2899-11ef-8e16-d517f37fa2ad_ACT_627cfe1c-289b-11ef-8e16-d517f37fa2ad_PROST_0187211b-28a0-11ef-8e16-d517f37fa2ad_FORM','24467343-28a0-11ef-8e16-d517f37fa2ad.pdf','24467343-28a0-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.2 Autre\",\"title\":\"Autre\"}','PDF',0,'SYNCED',0,NULL,'2024-06-12 11:42:56.000','2024-06-12 09:42:56.000','2024-06-12 11:42:56.000'),('25100b3e-2991-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_d703d726-298d-11ef-8e16-d517f37fa2ad/occlusion_d70636d7-298d-11ef-8e16-d517f37fa2ad/computedocclusion_e08676da-2990-11ef-8e16-d517f37fa2ad/25100b3e-2991-11ef-8e16-d517f37fa2ad.zip','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_d703d726-298d-11ef-8e16-d517f37fa2ad_SESS_d70636d7-298d-11ef-8e16-d517f37fa2ad_OCC_e08676da-2990-11ef-8e16-d517f37fa2ad_TO2','25100b3e-2991-11ef-8e16-d517f37fa2ad.zip','25100b3e-2991-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.2 Occlusione o1 Mascella u2\",\"modelMatrix\":\"0.975516,-0.148096,-0.162593,0,0.128141,0.983582,-0.127067,0,0.178742,0.103121,0.978477,0,-16.8719,-1.29266,-12.1772,1\",\"occlusionMatrix\":\"0.98222,0.160147,-0.0981626,0,0.100216,-0.00477391,0.994967,0,0.158874,-0.987087,-0.0207343,0,-15.0925,7.74345,-0.0261046,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.2_u2\",\"referenceScanId\":\"a9e9d6c4-298f-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 16:28:04.058','2024-06-13 14:28:04.208','2024-06-13 16:28:04.911'),('254bffc7-2e3c-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_da1f6873-2e3a-11ef-8deb-d515ea58f6cb/occlusion_da21a6e4-2e3a-11ef-8deb-d515ea58f6cb/computedocclusion_89b4ac38-2e3b-11ef-8deb-d515ea58f6cb/254bffc7-2e3c-11ef-8deb-d515ea58f6cb.zip','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_da1f6873-2e3a-11ef-8deb-d515ea58f6cb_SESS_da21a6e4-2e3a-11ef-8deb-d515ea58f6cb_OCC_89b4ac38-2e3b-11ef-8deb-d515ea58f6cb_BO1','254bffc7-2e3c-11ef-8deb-d515ea58f6cb.zip','c1a8eaf0-2e3b-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.2 Occlusion o1 Mandible l1 [pc2]\",\"modelMatrix\":\"0.988345,0.152164,-0.00455078,0,-0.132711,0.846578,-0.515455,0,-0.0745809,0.510051,0.856905,0,-6.06382,-8.89201,-8.94358,1\",\"occlusionMatrix\":\"-0.923804,0.358716,-0.129611,0,-0.276308,-0.863518,-0.421951,0,-0.265539,-0.354445,0.897211,0,12.249,14.015,-15.2437,1\",\"occlusionType\":2,\"referenceScanFullDisplayId\":\"16.2_l1\",\"referenceScanId\":\"18dce61e-2e3b-11ef-8deb-d515ea58f6cb\",\"scanBodies\":[]}','ZIP',3,'SYNCED',0,NULL,'2024-06-19 15:02:17.000','2024-06-19 13:02:17.000','2024-06-19 15:02:17.000'),('259181e4-2e4c-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/115617bc-2e4b-11ef-8deb-d515ea58f6cb/session_15f71dc7-2e4b-11ef-8deb-d515ea58f6cb/order_15fd7f91-2e4b-11ef-8deb-d515ea58f6cb/259181e4-2e4c-11ef-8deb-d515ea58f6cb.pdf','PATIENT_115617bc-2e4b-11ef-8deb-d515ea58f6cb_ACT_15f71dc7-2e4b-11ef-8deb-d515ea58f6cb_PROST_15fd7f91-2e4b-11ef-8deb-d515ea58f6cb_FORM','259181e4-2e4c-11ef-8deb-d515ea58f6cb.pdf','259181e4-2e4c-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"17.1 Crown [pc2]\",\"title\":\"Crown\"}','PDF',0,'SYNCED',0,NULL,'2024-06-19 16:56:47.000','2024-06-19 14:56:47.000','2024-06-19 16:56:47.000'),('25cc486a-2969-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_4704a021-2963-11ef-8e16-d517f37fa2ad/occlusion_4706df6f-2963-11ef-8e16-d517f37fa2ad/scan_e7c5fece-2968-11ef-8e16-d517f37fa2ad/25cc486a-2969-11ef-8e16-d517f37fa2ad.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_4704a021-2963-11ef-8e16-d517f37fa2ad_SESS_4706df6f-2963-11ef-8e16-d517f37fa2ad_RISC_e7c5fece-2968-11ef-8e16-d517f37fa2ad_MODEL','25cc486a-2969-11ef-8e16-d517f37fa2ad.zip','25cc486a-2969-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.1 Morso destro br2\",\"modelMatrix\":\"0.963686,-0.218539,-0.153694,0,0.219765,0.975027,0.00670429,0,0.151753,-0.0396143,0.988102,0,7.00972,-4.32557,-21.4546,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 11:41:45.422','2024-06-13 09:41:45.655','2024-06-13 11:41:49.632'),('25cc56fd-2969-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_4704a021-2963-11ef-8e16-d517f37fa2ad/occlusion_4706df6f-2963-11ef-8e16-d517f37fa2ad/scan_e7c5fece-2968-11ef-8e16-d517f37fa2ad/25cc56fd-2969-11ef-8e16-d517f37fa2ad.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_4704a021-2963-11ef-8e16-d517f37fa2ad_SESS_4706df6f-2963-11ef-8e16-d517f37fa2ad_RISC_e7c5fece-2968-11ef-8e16-d517f37fa2ad_SNAPS','25cc56fd-2969-11ef-8e16-d517f37fa2ad.png','25cc56fd-2969-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.1 Morso destro br2 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 11:41:45.422','2024-06-13 09:41:45.656','2024-06-13 11:41:50.548'),('26d765c3-289a-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/f373c86a-2899-11ef-8e16-d517f37fa2ad/session_0d1289f0-289a-11ef-8e16-d517f37fa2ad/occlusion_0d14f12a-289a-11ef-8e16-d517f37fa2ad/scan_0e172d2c-289a-11ef-8e16-d517f37fa2ad/26d765c3-289a-11ef-8e16-d517f37fa2ad.zip','PATIENT_f373c86a-2899-11ef-8e16-d517f37fa2ad_ACT_0d1289f0-289a-11ef-8e16-d517f37fa2ad_SESS_0d14f12a-289a-11ef-8e16-d517f37fa2ad_TOSC_0e172d2c-289a-11ef-8e16-d517f37fa2ad_MODEL','26d765c3-289a-11ef-8e16-d517f37fa2ad.zip','26d765c3-289a-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Maxillaire u1\",\"modelMatrix\":\"-0.907543,-0.409663,0.0924252,0,0.407387,-0.912236,-0.0431467,0,0.101989,-0.00150462,0.994784,0,0.619933,-0.682229,-12.3072,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,'2024-06-12 11:01:21.415','2024-06-12 11:00:01.350','2024-06-12 09:01:21.419','2024-06-12 11:01:21.441'),('26d7745b-289a-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/f373c86a-2899-11ef-8e16-d517f37fa2ad/session_0d1289f0-289a-11ef-8e16-d517f37fa2ad/occlusion_0d14f12a-289a-11ef-8e16-d517f37fa2ad/scan_0e172d2c-289a-11ef-8e16-d517f37fa2ad/26d7745b-289a-11ef-8e16-d517f37fa2ad.png','PATIENT_f373c86a-2899-11ef-8e16-d517f37fa2ad_ACT_0d1289f0-289a-11ef-8e16-d517f37fa2ad_SESS_0d14f12a-289a-11ef-8e16-d517f37fa2ad_TOSC_0e172d2c-289a-11ef-8e16-d517f37fa2ad_SNAPS','26d7745b-289a-11ef-8e16-d517f37fa2ad.png','26d7745b-289a-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Maxillaire u1 Snapshot\"}','PNG',0,'CREATED',0,'2024-06-12 11:01:21.415','2024-06-12 11:00:01.350','2024-06-12 09:01:21.421','2024-06-12 11:01:21.442'),('275970f2-2279-11ef-8d76-d310d2ec2c14',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/scan_96d08283-2273-11ef-8d76-d310d2ec2c14/275970f2-2279-11ef-8d76-d310d2ec2c14.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_BOSC_96d08283-2273-11ef-8d76-d310d2ec2c14_MODEL','275970f2-2279-11ef-8d76-d310d2ec2c14.zip','3e218de7-2274-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Mandibule l1 [pc2]\",\"modelMatrix\":\"0.135656,-0.982642,-0.126536,0,0.970104,0.157682,-0.184485,0,0.201235,-0.0977264,0.974656,0,-23.8369,18.6095,-10.139,1\",\"scanBodies\":[],\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":3,\"socleIsFullArch\":true,\"socleThickness\":-1,\"socleType\":1}','ZIP',1,'SYNCED',0,NULL,'2024-06-04 15:48:42.000','2024-06-04 13:48:42.000','2024-06-04 15:48:42.000'),('2a2ce13d-2988-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/0fedc3b4-2961-11ef-8e16-d517f37fa2ad/session_4ba13230-2987-11ef-8e16-d517f37fa2ad/order_4ba706eb-2987-11ef-8e16-d517f37fa2ad/2a2ce13d-2988-11ef-8e16-d517f37fa2ad.pdf','PATIENT_0fedc3b4-2961-11ef-8e16-d517f37fa2ad_ACT_4ba13230-2987-11ef-8e16-d517f37fa2ad_PROST_4ba706eb-2987-11ef-8e16-d517f37fa2ad_FORM','2a2ce13d-2988-11ef-8e16-d517f37fa2ad.pdf','2a2ce13d-2988-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"4.1 Ponte 17-16-15\",\"title\":\"Ponte 17-16-15\"}','PDF',0,'SYNCED',0,NULL,'2024-06-13 15:23:49.000','2024-06-13 13:23:49.000','2024-06-13 15:23:49.000'),('2a69e711-2278-11ef-8d76-d310d2ec2c14',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/scan_9fc7cfd7-2277-11ef-8d76-d310d2ec2c14/2a69e711-2278-11ef-8d76-d310d2ec2c14.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_RISC_9fc7cfd7-2277-11ef-8d76-d310d2ec2c14_MODEL','2a69e711-2278-11ef-8d76-d310d2ec2c14.zip','2a69e711-2278-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Mordu droit br2 [pc2]\",\"modelMatrix\":\"0.999006,0.0257481,0.0345336,0,-0.0251085,0.985872,-0.165142,0,-0.0372378,0.165598,0.985668,0,-5.02286,-5.02958,-9.05471,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 15:41:42.000','2024-06-04 13:41:42.000','2024-06-04 15:41:42.000'),('2a69f41f-2278-11ef-8d76-d310d2ec2c14',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/scan_9fc7cfd7-2277-11ef-8d76-d310d2ec2c14/2a69f41f-2278-11ef-8d76-d310d2ec2c14.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_RISC_9fc7cfd7-2277-11ef-8d76-d310d2ec2c14_SNAPS','2a69f41f-2278-11ef-8d76-d310d2ec2c14.png','2a69f41f-2278-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Mordu droit br2 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 15:41:42.000','2024-06-04 13:41:42.000','2024-06-04 15:41:42.000'),('2b452b17-2e42-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/4382037a-2735-11ef-8e16-d517f37fa1ab/session_8598ee4a-2e40-11ef-8deb-d515ea58f6cb/occlusion_859bd7ba-2e40-11ef-8deb-d515ea58f6cb/scan_86f46641-2e40-11ef-8deb-d515ea58f6cb/2b452b17-2e42-11ef-8deb-d515ea58f6cb.zip','PATIENT_4382037a-2735-11ef-8e16-d517f37fa1ab_ACT_8598ee4a-2e40-11ef-8deb-d515ea58f6cb_SESS_859bd7ba-2e40-11ef-8deb-d515ea58f6cb_TOSC_86f46641-2e40-11ef-8deb-d515ea58f6cb_MODEL','2b452b17-2e42-11ef-8deb-d515ea58f6cb.zip','aa0af9eb-2e40-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"6.3 Maxilla u1 [pc2]\",\"modelMatrix\":\"0.991771,-0.00472581,-0.127936,0,-0.00311808,0.99813,-0.0610415,0,0.127985,0.0609382,0.989902,0,-14.1942,-0.266649,-12.4392,1\",\"scanBodies\":[],\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":3,\"socleIsFullArch\":true,\"socleThickness\":-1,\"socleType\":1}','ZIP',1,'SYNCED',0,NULL,'2024-06-19 15:45:22.000','2024-06-19 13:45:22.000','2024-06-19 15:45:22.000'),('2b9138db-298b-11ef-8e16-d517f37fa2ad',2,'/var/.scan4all/iris/data/2024/2/5062e053-298a-11ef-8e16-d517f37fa2ad/session_58f22a30-298a-11ef-8e16-d517f37fa2ad/occlusion_58f49179-298a-11ef-8e16-d517f37fa2ad/scan_29f5fb35-298b-11ef-8e16-d517f37fa2ad/2b9138db-298b-11ef-8e16-d517f37fa2ad.ply','PATIENT_5062e053-298a-11ef-8e16-d517f37fa2ad_ACT_58f22a30-298a-11ef-8e16-d517f37fa2ad_SESS_58f49179-298a-11ef-8e16-d517f37fa2ad_TOSC_29f5fb35-298b-11ef-8e16-d517f37fa2ad_SEG','2b9138db-298b-11ef-8e16-d517f37fa2ad.ply','2b9138db-298b-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"14.1 Maxillaire u2 Segmentation [pc2]\"}','PLY',0,'CREATED',0,'2024-06-13 15:45:27.036','2024-06-13 15:45:27.036','2024-06-13 13:45:27.036',NULL),('2c87fd80-2988-11ef-867c-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_3d61afe1-2986-11ef-8e16-d517f37fa2ad/2c87fd80-2988-11ef-867c-6ec2958327c0.zip','PATIENT_0fedc3b4-2961-11ef-8e16-d517f37fa2ad_ACT_4ba13230-2987-11ef-8e16-d517f37fa2ad_SESS_4ba370c1-2987-11ef-8e16-d517f37fa2ad_OCC_c472f797-2987-11ef-8e16-d517f37fa2ad_TO1','05998f46-2988-11ef-8e16-d517f37fa2ad.zip','2c87fd80-2988-11ef-867c-6ec2958327c0','{\"displayTitle\":\"4.1 Occlusione o1 Mascella u1\",\"modelMatrix\":\"0.996297,-0.00872078,0.0855323,0,0.0514771,0.85732,-0.512204,0,-0.0688617,0.51471,0.854594,0,-11.595,-8.11386,-10.2324,1\",\"occlusionMatrix\":\"0.942645,0.0619705,-0.327991,0,0.296504,0.295863,0.908044,0,0.153313,-0.95322,0.260516,0,-14.9499,5.92204,-0.879945,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"4.1_u1\",\"referenceScanId\":\"55568e89-2987-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 15:22:47.000','2024-06-13 13:22:47.000','2024-06-13 15:22:47.000'),('2c8aa466-2988-11ef-867c-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_3d61afe1-2986-11ef-8e16-d517f37fa2ad/2c8aa466-2988-11ef-867c-6ec2958327c0.pdf','PATIENT_0fedc3b4-2961-11ef-8e16-d517f37fa2ad_ACT_4ba13230-2987-11ef-8e16-d517f37fa2ad_PROST_4ba706eb-2987-11ef-8e16-d517f37fa2ad_FORM','2a2ce13d-2988-11ef-8e16-d517f37fa2ad.pdf','2c8aa466-2988-11ef-867c-6ec2958327c0','{\"displayTitle\":\"4.1 Ponte 17-16-15\",\"title\":\"Ponte 17-16-15\"}','PDF',0,'SYNCED',0,NULL,'2024-06-13 15:23:49.000','2024-06-13 13:23:49.000','2024-06-13 15:23:49.000'),('2c8ae6d8-2988-11ef-867c-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_3d61afe1-2986-11ef-8e16-d517f37fa2ad/2c8ae6d8-2988-11ef-867c-6ec2958327c0.zip','PATIENT_0fedc3b4-2961-11ef-8e16-d517f37fa2ad_ACT_4ba13230-2987-11ef-8e16-d517f37fa2ad_SESS_4ba370c1-2987-11ef-8e16-d517f37fa2ad_OCC_c472f797-2987-11ef-8e16-d517f37fa2ad_BO1','fb21655b-2987-11ef-8e16-d517f37fa2ad.zip','2c8ae6d8-2988-11ef-867c-6ec2958327c0','{\"displayTitle\":\"4.1 Occlusione o1 Mandibola l1\",\"modelMatrix\":\"-0.967691,-0.234243,0.0932966,0,0.250368,-0.936471,0.24564,0,0.0298301,0.261062,0.964861,0,13.0365,-2.10523,-13.3116,1\",\"occlusionMatrix\":\"0.86452,-0.0216507,-0.502146,0,-0.502229,0.00196047,-0.864737,0,0.0197071,0.999768,-0.00917748,0,-11.7284,-8.59853,4.83777,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"4.1_l1\",\"referenceScanId\":\"879dec53-2987-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 15:22:32.000','2024-06-13 13:22:32.000','2024-06-13 15:22:32.000'),('2c8b2c0c-2988-11ef-867c-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_3d61afe1-2986-11ef-8e16-d517f37fa2ad/2c8b2c0c-2988-11ef-867c-6ec2958327c0.png','PATIENT_0fedc3b4-2961-11ef-8e16-d517f37fa2ad_ACT_4ba13230-2987-11ef-8e16-d517f37fa2ad_SESS_4ba370c1-2987-11ef-8e16-d517f37fa2ad_OCC_c472f797-2987-11ef-8e16-d517f37fa2ad_SNAPO','fbb6d74e-2987-11ef-8e16-d517f37fa2ad.png','2c8b2c0c-2988-11ef-867c-6ec2958327c0','{\"displayTitle\":\"4.1 Occlusione o1\",\"occlusionType\":1}','PNG',0,'SYNCED',0,NULL,'2024-06-13 15:22:32.000','2024-06-13 13:22:32.000','2024-06-13 15:22:32.000'),('2cf3311a-2272-11ef-8d76-d310d2ec2c14',2,'/var/.scan4all/iris/data/2024/2/a1ace9b5-2271-11ef-8d76-d310d2ec2c14/session_afa6cb0d-2271-11ef-8d76-d310d2ec2c14/order_afad1449-2271-11ef-8d76-d310d2ec2c14/2cf3311a-2272-11ef-8d76-d310d2ec2c14.pdf','PATIENT_a1ace9b5-2271-11ef-8d76-d310d2ec2c14_ACT_afa6cb0d-2271-11ef-8d76-d310d2ec2c14_PROST_afad1449-2271-11ef-8d76-d310d2ec2c14_FORM','2cf3311a-2272-11ef-8d76-d310d2ec2c14.pdf','2cf3311a-2272-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"2.1 Facette [pc2]\",\"title\":\"Facette\"}','PDF',0,'SYNCED',0,NULL,'2024-06-04 14:58:44.752','2024-06-04 12:58:45.487','2024-06-04 14:58:45.622'),('2d0cf740-2e0d-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/172f299e-2e0d-11ef-8deb-d515ea58f6cb/session_1b9240f4-2e0d-11ef-8deb-d515ea58f6cb/occlusion_1b9450aa-2e0d-11ef-8deb-d515ea58f6cb/scan_1c95cecd-2e0d-11ef-8deb-d515ea58f6cb/2d0cf740-2e0d-11ef-8deb-d515ea58f6cb.zip','PATIENT_172f299e-2e0d-11ef-8deb-d515ea58f6cb_ACT_1b9240f4-2e0d-11ef-8deb-d515ea58f6cb_SESS_1b9450aa-2e0d-11ef-8deb-d515ea58f6cb_TOSC_1c95cecd-2e0d-11ef-8deb-d515ea58f6cb_MODEL','2d0cf740-2e0d-11ef-8deb-d515ea58f6cb.zip','2d0cf740-2e0d-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"15.1 Mascella u1 [pc2]\",\"modelMatrix\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-19 12:49:16.000','2024-06-19 10:49:16.000','2024-06-19 12:49:16.000'),('2d0d25e8-2e0d-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/172f299e-2e0d-11ef-8deb-d515ea58f6cb/session_1b9240f4-2e0d-11ef-8deb-d515ea58f6cb/occlusion_1b9450aa-2e0d-11ef-8deb-d515ea58f6cb/scan_1c95cecd-2e0d-11ef-8deb-d515ea58f6cb/2d0d25e8-2e0d-11ef-8deb-d515ea58f6cb.png','PATIENT_172f299e-2e0d-11ef-8deb-d515ea58f6cb_ACT_1b9240f4-2e0d-11ef-8deb-d515ea58f6cb_SESS_1b9450aa-2e0d-11ef-8deb-d515ea58f6cb_TOSC_1c95cecd-2e0d-11ef-8deb-d515ea58f6cb_SNAPS','2d0d25e8-2e0d-11ef-8deb-d515ea58f6cb.png','2d0d25e8-2e0d-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"15.1 Mascella u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-19 12:49:12.000','2024-06-19 10:49:12.000','2024-06-19 12:49:12.000'),('2e1492f1-233a-11ef-8f93-d92a45da78c9',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_2e146f3d-233a-11ef-8f93-d92a45da78c9/2e1492f1-233a-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_TOSC_2e146f3d-233a-11ef-8f93-d92a45da78c9_MODEL','2e1492f1-233a-11ef-8f93-d92a45da78c9.zip','2e1492f1-233a-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Maxillaire u2 [pc1]\",\"modelMatrix\":\"-0.923468,0.0376561,-0.381824,0,-0.158116,-0.944087,0.289308,0,-0.349581,0.327539,0.877788,0,12.8471,-2.21044,-5.73295,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-05 14:50:30.000','2024-06-05 12:50:30.000','2024-06-05 14:50:30.000'),('2e19276e-233a-11ef-8f93-d92a45da78c9',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_2e146f3d-233a-11ef-8f93-d92a45da78c9/2e19276e-233a-11ef-8f93-d92a45da78c9.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_TOSC_2e146f3d-233a-11ef-8f93-d92a45da78c9_SNAPS','2e19276e-233a-11ef-8f93-d92a45da78c9.png','2e19276e-233a-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Maxillaire u2 Snapshot [pc1]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-05 14:50:30.000','2024-06-05 12:50:30.000','2024-06-05 14:50:30.000'),('2e90846e-2ef1-11ef-bb8b-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_82a44e97-2ee8-11ef-8dc9-d414e3397395/2e90846e-2ef1-11ef-bb8b-6ec2958327c0.png','PATIENT_0d66331b-2eda-11ef-8de3-d515e950d747_ACT_8ffbf7e3-2eee-11ef-8dc9-d414e3397395_SESS_8ffc5e64-2eee-11ef-8dc9-d414e3397395_TOSC_c5e81c85-2eee-11ef-8dc9-d414e3397395_SNAPS','0711bcdf-2eef-11ef-8dc9-d414e3397395.png','2e90846e-2ef1-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.5 Maxilla u1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-20 12:22:44.000','2024-06-20 10:22:44.000','2024-06-20 12:22:44.000'),('2e90e2b8-296e-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_8e81ab09-296b-11ef-8e16-d517f37fa2ad/occlusion_8e83509f-296b-11ef-8e16-d517f37fa2ad/scan_890595a9-296d-11ef-8e16-d517f37fa2ad/2e90e2b8-296e-11ef-8e16-d517f37fa2ad.xyz','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_SESS_8e83509f-296b-11ef-8e16-d517f37fa2ad_TOSC_890595a9-296d-11ef-8e16-d517f37fa2ad_LIFI','2e90e2b8-296e-11ef-8e16-d517f37fa2ad.xyz','2e90e2b8-296e-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Mascella u3 Linea di finitura 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-13 12:17:47.616','2024-06-13 10:17:47.621','2024-06-13 12:17:47.908'),('2e90eaa9-296e-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_8e81ab09-296b-11ef-8e16-d517f37fa2ad/occlusion_8e83509f-296b-11ef-8e16-d517f37fa2ad/scan_890595a9-296d-11ef-8e16-d517f37fa2ad/2e90eaa9-296e-11ef-8e16-d517f37fa2ad.bin','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_SESS_8e83509f-296b-11ef-8e16-d517f37fa2ad_TOSC_890595a9-296d-11ef-8e16-d517f37fa2ad_LIFIM','2e90eaa9-296e-11ef-8e16-d517f37fa2ad.bin','2e90eaa9-296e-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Mascella u3 Linea di finitura dei metadati 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-13 12:17:47.616','2024-06-13 10:17:47.621','2024-06-13 12:17:48.122'),('2e90f815-2ef1-11ef-bb8b-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_82a44e97-2ee8-11ef-8dc9-d414e3397395/2e90f815-2ef1-11ef-bb8b-6ec2958327c0.zip','PATIENT_0d66331b-2eda-11ef-8de3-d515e950d747_ACT_8ffbf7e3-2eee-11ef-8dc9-d414e3397395_SESS_8ffc5e64-2eee-11ef-8dc9-d414e3397395_OCC_9975ee13-2eef-11ef-8dc9-d414e3397395_TO1','0e07e72d-2ef0-11ef-8dc9-d414e3397395.zip','2e90f815-2ef1-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.5 Occlusion o1 Maxilla u1\",\"modelMatrix\":\"-0.0946771,-0.987991,-0.122106,0,0.973064,-0.0659456,-0.220899,0,0.210194,-0.139732,0.967623,0,7.23058,5.4101,-13.6791,1\",\"occlusionMatrix\":\"0.453313,-0.0839871,-0.888246,0,-0.879467,-0.202604,-0.428859,0,-0.144363,0.975593,-0.165675,0,-9.45051,-10.8485,5.55411,1\",\"occlusionType\":3,\"referenceScanFullDisplayId\":\"1.5_u1\",\"referenceScanId\":\"c5e81c85-2eee-11ef-8dc9-d414e3397395\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-20 12:30:04.000','2024-06-20 10:30:04.000','2024-06-20 12:30:04.000'),('2e9143e7-2ef1-11ef-bb8b-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_82a44e97-2ee8-11ef-8dc9-d414e3397395/2e9143e7-2ef1-11ef-bb8b-6ec2958327c0.pdf','PATIENT_0d66331b-2eda-11ef-8de3-d515e950d747_ACT_8ffbf7e3-2eee-11ef-8dc9-d414e3397395_PROST_8ffd5ce6-2eee-11ef-8dc9-d414e3397395_FORM','2cedeec9-2ef1-11ef-8dc9-d414e3397395.pdf','2e9143e7-2ef1-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.5 Veneer 12-22\",\"title\":\"Veneer 12-22\"}','PDF',0,'SYNCED',0,NULL,'2024-06-20 12:38:05.000','2024-06-20 10:38:05.000','2024-06-20 12:38:05.000'),('2e917c0b-2ef1-11ef-bb8b-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_82a44e97-2ee8-11ef-8dc9-d414e3397395/2e917c0b-2ef1-11ef-bb8b-6ec2958327c0.zip','PATIENT_0d66331b-2eda-11ef-8de3-d515e950d747_ACT_8ffbf7e3-2eee-11ef-8dc9-d414e3397395_SESS_8ffc5e64-2eee-11ef-8dc9-d414e3397395_TOSC_c5e81c85-2eee-11ef-8dc9-d414e3397395_MODEL','4a36a0d0-2eef-11ef-8dc9-d414e3397395.zip','2e917c0b-2ef1-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.5 Maxilla u1\",\"modelMatrix\":\"-0.0946771,-0.987991,-0.122106,0,0.973064,-0.0659456,-0.220899,0,0.210194,-0.139732,0.967623,0,7.23058,5.4101,-13.6791,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-20 12:24:35.000','2024-06-20 10:24:35.000','2024-06-20 12:24:35.000'),('2e91ba31-2ef1-11ef-bb8b-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_82a44e97-2ee8-11ef-8dc9-d414e3397395/2e91ba31-2ef1-11ef-bb8b-6ec2958327c0.png','PATIENT_0d66331b-2eda-11ef-8de3-d515e950d747_ACT_8ffbf7e3-2eee-11ef-8dc9-d414e3397395_SESS_8ffc5e64-2eee-11ef-8dc9-d414e3397395_OCC_9975ee13-2eef-11ef-8dc9-d414e3397395_SCREENO','66700656-2ef0-11ef-8dc9-d414e3397395.png','2e91ba31-2ef1-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.5 Occlusion o1 Screenshot 1\",\"occlusionType\":3,\"title\":\"1\"}','PNG',0,'SYNCED',0,NULL,'2024-06-20 12:32:31.000','2024-06-20 10:32:31.000','2024-06-20 12:32:31.000'),('2e91f327-2ef1-11ef-bb8b-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_82a44e97-2ee8-11ef-8dc9-d414e3397395/2e91f327-2ef1-11ef-bb8b-6ec2958327c0.zip','PATIENT_0d66331b-2eda-11ef-8de3-d515e950d747_ACT_8ffbf7e3-2eee-11ef-8dc9-d414e3397395_SESS_8ffc5e64-2eee-11ef-8dc9-d414e3397395_BOSC_4b02fa16-2eef-11ef-8dc9-d414e3397395_MODEL','83e7ae62-2eef-11ef-8dc9-d414e3397395.zip','2e91f327-2ef1-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.5 Mandible l1\",\"modelMatrix\":\"-0.219319,-0.9725,-0.0783763,0,0.967988,-0.226942,0.107222,0,-0.12206,-0.0523515,0.991141,0,-2.05232,1.39271,-12.3814,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-20 12:26:14.000','2024-06-20 10:26:14.000','2024-06-20 12:26:14.000'),('2e922e08-2ef1-11ef-bb8b-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_82a44e97-2ee8-11ef-8dc9-d414e3397395/2e922e08-2ef1-11ef-bb8b-6ec2958327c0.png','PATIENT_0d66331b-2eda-11ef-8de3-d515e950d747_ACT_8ffbf7e3-2eee-11ef-8dc9-d414e3397395_SESS_8ffc5e64-2eee-11ef-8dc9-d414e3397395_BOSC_4b02fa16-2eef-11ef-8dc9-d414e3397395_SNAPS','83e7bdf4-2eef-11ef-8dc9-d414e3397395.png','2e922e08-2ef1-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.5 Mandible l1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-20 12:26:14.000','2024-06-20 10:26:14.000','2024-06-20 12:26:14.000'),('2e926c06-2ef1-11ef-bb8b-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_82a44e97-2ee8-11ef-8dc9-d414e3397395/2e926c06-2ef1-11ef-bb8b-6ec2958327c0.zip','PATIENT_0d66331b-2eda-11ef-8de3-d515e950d747_ACT_8ffbf7e3-2eee-11ef-8dc9-d414e3397395_SESS_8ffc5e64-2eee-11ef-8dc9-d414e3397395_OCC_9975ee13-2eef-11ef-8dc9-d414e3397395_BO1','ecf35a1b-2eef-11ef-8dc9-d414e3397395.zip','2e926c06-2ef1-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.5 Occlusion o1 Mandible l1\",\"modelMatrix\":\"-0.219319,-0.9725,-0.0783763,0,0.967988,-0.226942,0.107222,0,-0.12206,-0.0523515,0.991141,0,-2.05232,1.39271,-12.3814,1\",\"occlusionMatrix\":\"0.787766,0.297251,-0.540618,0,0.608992,-0.245145,0.753478,0,0.092586,-0.922799,-0.374191,0,-4.32645,6.58068,4.22601,1\",\"occlusionType\":3,\"referenceScanFullDisplayId\":\"1.5_l1\",\"referenceScanId\":\"4b02fa16-2eef-11ef-8dc9-d414e3397395\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-20 12:29:10.000','2024-06-20 10:29:10.000','2024-06-20 12:29:10.000'),('2e92ab5d-2ef1-11ef-bb8b-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_82a44e97-2ee8-11ef-8dc9-d414e3397395/2e92ab5d-2ef1-11ef-bb8b-6ec2958327c0.png','PATIENT_0d66331b-2eda-11ef-8de3-d515e950d747_ACT_8ffbf7e3-2eee-11ef-8dc9-d414e3397395_SESS_8ffc5e64-2eee-11ef-8dc9-d414e3397395_OCC_9975ee13-2eef-11ef-8dc9-d414e3397395_SNAPO','ed7520a8-2eef-11ef-8dc9-d414e3397395.png','2e92ab5d-2ef1-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.5 Occlusion o1\",\"occlusionType\":3}','PNG',0,'SYNCED',0,NULL,'2024-06-20 12:29:10.000','2024-06-20 10:29:10.000','2024-06-20 12:29:10.000'),('2f9a5141-296b-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_4704a021-2963-11ef-8e16-d517f37fa2ad/occlusion_4706df6f-2963-11ef-8e16-d517f37fa2ad/scan_47f95341-2963-11ef-8e16-d517f37fa2ad/2f9a5141-296b-11ef-8e16-d517f37fa2ad.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_4704a021-2963-11ef-8e16-d517f37fa2ad_SESS_4706df6f-2963-11ef-8e16-d517f37fa2ad_TOSC_47f95341-2963-11ef-8e16-d517f37fa2ad_SCREENS','2f9a5141-296b-11ef-8e16-d517f37fa2ad.png','2f9a5141-296b-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.1 Mascella u1 Screenshot 1\",\"title\":\"1\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 11:56:20.865','2024-06-13 09:56:20.966','2024-06-13 11:56:21.237'),('307ab64c-2279-11ef-8d76-d310d2ec2c14',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/order_f26746c9-2272-11ef-8d76-d310d2ec2c14/307ab64c-2279-11ef-8d76-d310d2ec2c14.pdf','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_PROST_f26746c9-2272-11ef-8d76-d310d2ec2c14_FORM','307ab64c-2279-11ef-8d76-d310d2ec2c14.pdf','307ab64c-2279-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Autre [pc2]\",\"title\":\"Autre\"}','PDF',0,'SYNCED',0,NULL,'2024-06-04 15:48:59.000','2024-06-04 13:48:59.000','2024-06-04 15:48:59.000'),('3230f603-2e0d-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/172f299e-2e0d-11ef-8deb-d515ea58f6cb/session_1b9240f4-2e0d-11ef-8deb-d515ea58f6cb/occlusion_1b9450aa-2e0d-11ef-8deb-d515ea58f6cb/scan_1c95cecd-2e0d-11ef-8deb-d515ea58f6cb/3230f603-2e0d-11ef-8deb-d515ea58f6cb.zip','PATIENT_172f299e-2e0d-11ef-8deb-d515ea58f6cb_ACT_1b9240f4-2e0d-11ef-8deb-d515ea58f6cb_SESS_1b9450aa-2e0d-11ef-8deb-d515ea58f6cb_TOSC_1c95cecd-2e0d-11ef-8deb-d515ea58f6cb_MODEL','3230f603-2e0d-11ef-8deb-d515ea58f6cb.zip','2d0cf740-2e0d-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"15.1 Mascella u1 [pc2]\",\"modelMatrix\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"scanBodies\":[],\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":3,\"socleIsFullArch\":true,\"socleThickness\":-1,\"socleType\":1}','ZIP',1,'SYNCED',0,NULL,'2024-06-19 09:26:08.974','2024-06-19 07:26:09.000','2024-06-19 12:49:17.149'),('326e28f0-225b-11ef-8f1f-d8242c71b430',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_e3862d66-225a-11ef-8f1f-d8242c71b430/occlusion_e3868e5f-225a-11ef-8f1f-d8242c71b430/scan_e52279ce-225a-11ef-8f1f-d8242c71b430/326e28f0-225b-11ef-8f1f-d8242c71b430.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_SESS_e3868e5f-225a-11ef-8f1f-d8242c71b430_TOSC_e52279ce-225a-11ef-8f1f-d8242c71b430_MODEL','326e28f0-225b-11ef-8f1f-d8242c71b430.zip','326e28f0-225b-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.1 Maxillaire u1\",\"modelMatrix\":\"0.983821,-0.178562,-0.0145353,0,0.167676,0.946334,-0.276291,0,0.0630904,0.269384,0.960964,0,-18.4738,6.44284,-12.9473,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 12:14:21.000','2024-06-04 10:14:21.000','2024-06-04 12:14:21.000'),('326e3f34-225b-11ef-8f1f-d8242c71b430',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_e3862d66-225a-11ef-8f1f-d8242c71b430/occlusion_e3868e5f-225a-11ef-8f1f-d8242c71b430/scan_e52279ce-225a-11ef-8f1f-d8242c71b430/326e3f34-225b-11ef-8f1f-d8242c71b430.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_SESS_e3868e5f-225a-11ef-8f1f-d8242c71b430_TOSC_e52279ce-225a-11ef-8f1f-d8242c71b430_SNAPS','326e3f34-225b-11ef-8f1f-d8242c71b430.png','326e3f34-225b-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.1 Maxillaire u1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 12:14:21.000','2024-06-04 10:14:21.000','2024-06-04 12:14:21.000'),('32bdfef7-2e42-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/4382037a-2735-11ef-8e16-d517f37fa1ab/session_8598ee4a-2e40-11ef-8deb-d515ea58f6cb/order_22749c4a-2e42-11ef-8deb-d515ea58f6cb/32bdfef7-2e42-11ef-8deb-d515ea58f6cb.pdf','PATIENT_4382037a-2735-11ef-8e16-d517f37fa1ab_ACT_8598ee4a-2e40-11ef-8deb-d515ea58f6cb_PROST_22749c4a-2e42-11ef-8deb-d515ea58f6cb_FORM','32bdfef7-2e42-11ef-8deb-d515ea58f6cb.pdf','32bdfef7-2e42-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"6.3 Crown [pc2]\",\"title\":\"Crown\"}','PDF',0,'SYNCED',0,NULL,'2024-06-19 15:45:34.000','2024-06-19 13:45:34.000','2024-06-19 15:45:34.000'),('3303ef6e-289c-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/f373c86a-2899-11ef-8e16-d517f37fa2ad/session_627cfe1c-289b-11ef-8e16-d517f37fa2ad/occlusion_627f5b3e-289b-11ef-8e16-d517f37fa2ad/scan_1737aea0-289c-11ef-8e16-d517f37fa2ad/3303ef6e-289c-11ef-8e16-d517f37fa2ad.zip','PATIENT_f373c86a-2899-11ef-8e16-d517f37fa2ad_ACT_627cfe1c-289b-11ef-8e16-d517f37fa2ad_SESS_627f5b3e-289b-11ef-8e16-d517f37fa2ad_RISC_1737aea0-289c-11ef-8e16-d517f37fa2ad_MODEL','3303ef6e-289c-11ef-8e16-d517f37fa2ad.zip','3303ef6e-289c-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.2 Mordu droit br1\",\"modelMatrix\":\"0.997429,-0.0534839,-0.0487883,0,0.0478451,0.993975,-0.0984414,0,0.0533619,0.0956706,0.993946,0,-7.86376,-0.980031,-17.0873,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-12 11:14:40.768','2024-06-12 09:14:40.962','2024-06-12 11:14:43.602'),('33040048-289c-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/f373c86a-2899-11ef-8e16-d517f37fa2ad/session_627cfe1c-289b-11ef-8e16-d517f37fa2ad/occlusion_627f5b3e-289b-11ef-8e16-d517f37fa2ad/scan_1737aea0-289c-11ef-8e16-d517f37fa2ad/33040048-289c-11ef-8e16-d517f37fa2ad.png','PATIENT_f373c86a-2899-11ef-8e16-d517f37fa2ad_ACT_627cfe1c-289b-11ef-8e16-d517f37fa2ad_SESS_627f5b3e-289b-11ef-8e16-d517f37fa2ad_RISC_1737aea0-289c-11ef-8e16-d517f37fa2ad_SNAPS','33040048-289c-11ef-8e16-d517f37fa2ad.png','33040048-289c-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.2 Mordu droit br1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-12 11:14:40.768','2024-06-12 09:14:40.963','2024-06-12 11:14:44.409'),('3326d65f-2720-11ef-8e16-d517f37fa1ab',2,'/var/.scan4all/iris/data/2024/2/a1ace9b5-2271-11ef-8d76-d310d2ec2c14/session_1cb775ae-271f-11ef-8e16-d517f37fa1ab/occlusion_1cb90d11-271f-11ef-8e16-d517f37fa1ab/scan_1db1e2d3-271f-11ef-8e16-d517f37fa1ab/3326d65f-2720-11ef-8e16-d517f37fa1ab.zip','PATIENT_a1ace9b5-2271-11ef-8d76-d310d2ec2c14_ACT_1cb775ae-271f-11ef-8e16-d517f37fa1ab_SESS_1cb90d11-271f-11ef-8e16-d517f37fa1ab_TOSC_1db1e2d3-271f-11ef-8e16-d517f37fa1ab_MODEL','3326d65f-2720-11ef-8e16-d517f37fa1ab.zip','3326d65f-2720-11ef-8e16-d517f37fa1ab','{\"displayTitle\":\"2.2 Maxillaire u1 [pc2]\",\"modelMatrix\":\"-0.101025,-0.990067,-0.0977805,0,0.982413,-0.0837627,-0.166879,0,0.157031,-0.11292,0.981117,0,-24.5185,22.6171,-11.9571,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-10 15:34:29.000','2024-06-10 13:34:29.000','2024-06-10 15:34:29.000'),('3326f9f5-2720-11ef-8e16-d517f37fa1ab',2,'/var/.scan4all/iris/data/2024/2/a1ace9b5-2271-11ef-8d76-d310d2ec2c14/session_1cb775ae-271f-11ef-8e16-d517f37fa1ab/occlusion_1cb90d11-271f-11ef-8e16-d517f37fa1ab/scan_1db1e2d3-271f-11ef-8e16-d517f37fa1ab/3326f9f5-2720-11ef-8e16-d517f37fa1ab.png','PATIENT_a1ace9b5-2271-11ef-8d76-d310d2ec2c14_ACT_1cb775ae-271f-11ef-8e16-d517f37fa1ab_SESS_1cb90d11-271f-11ef-8e16-d517f37fa1ab_TOSC_1db1e2d3-271f-11ef-8e16-d517f37fa1ab_SNAPS','3326f9f5-2720-11ef-8e16-d517f37fa1ab.png','3326f9f5-2720-11ef-8e16-d517f37fa1ab','{\"displayTitle\":\"2.2 Maxillaire u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-10 15:34:29.000','2024-06-10 13:34:29.000','2024-06-10 15:34:29.000'),('336ff6af-23e9-11ef-8dde-d415e84cc4f5',3,'/var/.scan4all/iris/data/2024/3/907398e3-23e7-11ef-8dde-d415e84cc4f5/session_0bcc91ed-23e9-11ef-8dde-d415e84cc4f5/order_0bd68b18-23e9-11ef-8dde-d415e84cc4f5/336ff6af-23e9-11ef-8dde-d415e84cc4f5.pdf','PATIENT_907398e3-23e7-11ef-8dde-d415e84cc4f5_ACT_0bcc91ed-23e9-11ef-8dde-d415e84cc4f5_PROST_0bd68b18-23e9-11ef-8dde-d415e84cc4f5_FORM','336ff6af-23e9-11ef-8dde-d415e84cc4f5.pdf','336ff6af-23e9-11ef-8dde-d415e84cc4f5','{\"displayTitle\":\"2.2 Facette [pc1]\",\"title\":\"Facette\"}','PDF',0,'SYNCED',0,NULL,'2024-06-06 11:43:18.000','2024-06-06 09:43:18.000','2024-06-06 11:43:18.000'),('3464d86c-2e0f-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/ce57500b-227c-11ef-8d76-d310d2ec2c14/session_da355fe4-227c-11ef-8d76-d310d2ec2c14/occlusion_da37d213-227c-11ef-8d76-d310d2ec2c14/scan_e631c430-2e0e-11ef-8deb-d515ea58f6cb/3464d86c-2e0f-11ef-8deb-d515ea58f6cb.zip','PATIENT_ce57500b-227c-11ef-8d76-d310d2ec2c14_ACT_da355fe4-227c-11ef-8d76-d310d2ec2c14_SESS_da37d213-227c-11ef-8d76-d310d2ec2c14_TOSC_e631c430-2e0e-11ef-8deb-d515ea58f6cb_MODEL','3464d86c-2e0f-11ef-8deb-d515ea58f6cb.zip','f6bd91e1-2e0e-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"3.1 Maxillaire u2 [pc2]\",\"modelMatrix\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"scanBodies\":[{\"position\":\"10.4552,6,0,0,3.27905,0,6,0,12.8519,0,0,6,1,0,0,0\",\"reference\":\"K30PSCANPLG\",\"tid\":16}]}','ZIP',2,'SYNCED',0,NULL,'2024-06-19 09:40:31.663','2024-06-19 07:40:31.789','2024-06-19 12:49:13.824'),('34652cdb-2e0f-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/ce57500b-227c-11ef-8d76-d310d2ec2c14/session_da355fe4-227c-11ef-8d76-d310d2ec2c14/occlusion_da37d213-227c-11ef-8d76-d310d2ec2c14/scan_e631c430-2e0e-11ef-8deb-d515ea58f6cb/34652cdb-2e0f-11ef-8deb-d515ea58f6cb.png','PATIENT_ce57500b-227c-11ef-8d76-d310d2ec2c14_ACT_da355fe4-227c-11ef-8d76-d310d2ec2c14_SESS_da37d213-227c-11ef-8d76-d310d2ec2c14_TOSC_e631c430-2e0e-11ef-8deb-d515ea58f6cb_SNAPS','34652cdb-2e0f-11ef-8deb-d515ea58f6cb.png','f6bdc013-2e0e-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"3.1 Maxillaire u2 Snapshot [pc2]\"}','PNG',1,'SYNCED',0,NULL,'2024-06-19 09:40:31.665','2024-06-19 07:40:31.789','2024-06-19 12:49:14.997'),('355b14f8-23e9-11ef-867c-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_0f3dfe44-225d-11ef-8f1f-d8242c71b430/355b14f8-23e9-11ef-867c-6ec2958327c0.zip','PATIENT_907398e3-23e7-11ef-8dde-d415e84cc4f5_ACT_0bcc91ed-23e9-11ef-8dde-d415e84cc4f5_SESS_0bcebe79-23e9-11ef-8dde-d415e84cc4f5_TOSC_0d3f3b92-23e9-11ef-8dde-d415e84cc4f5_MODEL','242c6766-23e9-11ef-8dde-d415e84cc4f5.zip','355b14f8-23e9-11ef-867c-6ec2958327c0','{\"displayTitle\":\"2.2 Maxillaire u1 [pc1]\",\"modelMatrix\":\"-0.98612,0.162098,-0.0359523,0,-0.162664,-0.899746,0.404967,0,0.0332962,0.405194,0.913624,0,8.13953,-5.86615,-13.6249,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-06 11:42:54.000','2024-06-06 09:42:54.000','2024-06-06 11:42:54.000'),('355b5fea-23e9-11ef-867c-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_0f3dfe44-225d-11ef-8f1f-d8242c71b430/355b5fea-23e9-11ef-867c-6ec2958327c0.png','PATIENT_907398e3-23e7-11ef-8dde-d415e84cc4f5_ACT_0bcc91ed-23e9-11ef-8dde-d415e84cc4f5_SESS_0bcebe79-23e9-11ef-8dde-d415e84cc4f5_TOSC_0d3f3b92-23e9-11ef-8dde-d415e84cc4f5_SNAPS','242c7d2a-23e9-11ef-8dde-d415e84cc4f5.png','355b5fea-23e9-11ef-867c-6ec2958327c0','{\"displayTitle\":\"2.2 Maxillaire u1 Snapshot [pc1]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-06 11:42:55.000','2024-06-06 09:42:55.000','2024-06-06 11:42:55.000'),('355bb3c0-23e9-11ef-867c-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_0f3dfe44-225d-11ef-8f1f-d8242c71b430/355bb3c0-23e9-11ef-867c-6ec2958327c0.pdf','PATIENT_907398e3-23e7-11ef-8dde-d415e84cc4f5_ACT_0bcc91ed-23e9-11ef-8dde-d415e84cc4f5_PROST_0bd68b18-23e9-11ef-8dde-d415e84cc4f5_FORM','336ff6af-23e9-11ef-8dde-d415e84cc4f5.pdf','355bb3c0-23e9-11ef-867c-6ec2958327c0','{\"displayTitle\":\"2.2 Facette [pc1]\",\"title\":\"Facette\"}','PDF',0,'SYNCED',0,NULL,'2024-06-06 11:43:18.000','2024-06-06 09:43:18.000','2024-06-06 11:43:18.000'),('357385d7-2a2f-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/scan_aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd/357385d7-2a2f-11ef-8f1c-d8242c6fa8fd.png','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_BOSC_aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd_SCREENS','357385d7-2a2f-11ef-8f1c-d8242c6fa8fd.png','357385d7-2a2f-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Mandibola l2 Screenshot 2\",\"title\":\"2\"}','PNG',0,'SYNCED',0,NULL,'2024-06-14 11:19:33.556','2024-06-14 09:19:33.644','2024-06-14 11:19:33.954'),('37e226d3-2991-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_d703d726-298d-11ef-8e16-d517f37fa2ad/occlusion_d70636d7-298d-11ef-8e16-d517f37fa2ad/computedocclusion_e08676da-2990-11ef-8e16-d517f37fa2ad/37e226d3-2991-11ef-8e16-d517f37fa2ad.zip','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_d703d726-298d-11ef-8e16-d517f37fa2ad_SESS_d70636d7-298d-11ef-8e16-d517f37fa2ad_OCC_e08676da-2990-11ef-8e16-d517f37fa2ad_TO1','37e226d3-2991-11ef-8e16-d517f37fa2ad.zip','1d51af59-2991-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.2 Occlusione o1 Mascella u1\",\"modelMatrix\":\"0.975516,-0.148096,-0.162593,0,0.128141,0.983582,-0.127067,0,0.178742,0.103121,0.978477,0,-16.8719,-1.29266,-12.1772,1\",\"occlusionMatrix\":\"0.98222,0.160147,-0.0981625,0,0.100216,-0.0047738,0.994967,0,0.158874,-0.987087,-0.0207343,0,-15.0924,7.74345,-0.0261059,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.2_u1\",\"referenceScanId\":\"2ed06b9e-298f-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[],\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":3,\"socleIsFullArch\":true,\"socleThickness\":-1,\"socleType\":3}','ZIP',1,'SYNCED',0,NULL,'2024-06-13 16:28:35.633','2024-06-13 14:28:35.747','2024-06-13 16:28:36.502'),('37e2527a-2991-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_d703d726-298d-11ef-8e16-d517f37fa2ad/occlusion_d70636d7-298d-11ef-8e16-d517f37fa2ad/computedocclusion_e08676da-2990-11ef-8e16-d517f37fa2ad/37e2527a-2991-11ef-8e16-d517f37fa2ad.zip','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_d703d726-298d-11ef-8e16-d517f37fa2ad_SESS_d70636d7-298d-11ef-8e16-d517f37fa2ad_OCC_e08676da-2990-11ef-8e16-d517f37fa2ad_BO1','37e2527a-2991-11ef-8e16-d517f37fa2ad.zip','1d6db867-2991-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.2 Occlusione o1 Mandibola l1\",\"modelMatrix\":\"0.997996,0.0253681,-0.0579621,0,-0.0223453,0.998386,0.0522168,0,0.0591932,-0.050817,0.996952,0,-12.5419,-0.543902,-13.1251,1\",\"occlusionMatrix\":\"0.99683,-0.0794793,-0.00662431,0,-0.0269223,-0.257144,-0.966008,0,0.0750737,0.963109,-0.258465,0,-13.9285,-7.8758,4.47367,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.2_l1\",\"referenceScanId\":\"99d1c412-2990-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[],\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":3,\"socleIsFullArch\":true,\"socleThickness\":-1,\"socleType\":3}','ZIP',1,'SYNCED',0,NULL,'2024-06-13 16:28:35.635','2024-06-13 14:28:35.756','2024-06-13 16:28:37.268'),('3944017f-2e4b-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/115617bc-2e4b-11ef-8deb-d515ea58f6cb/session_15f71dc7-2e4b-11ef-8deb-d515ea58f6cb/occlusion_15f94c3c-2e4b-11ef-8deb-d515ea58f6cb/scan_1770b226-2e4b-11ef-8deb-d515ea58f6cb/3944017f-2e4b-11ef-8deb-d515ea58f6cb.zip','PATIENT_115617bc-2e4b-11ef-8deb-d515ea58f6cb_ACT_15f71dc7-2e4b-11ef-8deb-d515ea58f6cb_SESS_15f94c3c-2e4b-11ef-8deb-d515ea58f6cb_TOSC_1770b226-2e4b-11ef-8deb-d515ea58f6cb_MODEL','3944017f-2e4b-11ef-8deb-d515ea58f6cb.zip','3944017f-2e4b-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"17.1 Maxilla u1 [pc2]\",\"modelMatrix\":\"0.969737,0.17474,-0.170519,0,-0.235525,0.853535,-0.464764,0,0.0643309,0.49086,0.86886,0,-10.5522,-3.64935,-10.9486,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-19 16:50:13.000','2024-06-19 14:50:13.000','2024-06-19 16:50:13.000'),('394418b6-2e4b-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/115617bc-2e4b-11ef-8deb-d515ea58f6cb/session_15f71dc7-2e4b-11ef-8deb-d515ea58f6cb/occlusion_15f94c3c-2e4b-11ef-8deb-d515ea58f6cb/scan_1770b226-2e4b-11ef-8deb-d515ea58f6cb/394418b6-2e4b-11ef-8deb-d515ea58f6cb.png','PATIENT_115617bc-2e4b-11ef-8deb-d515ea58f6cb_ACT_15f71dc7-2e4b-11ef-8deb-d515ea58f6cb_SESS_15f94c3c-2e4b-11ef-8deb-d515ea58f6cb_TOSC_1770b226-2e4b-11ef-8deb-d515ea58f6cb_SNAPS','394418b6-2e4b-11ef-8deb-d515ea58f6cb.png','394418b6-2e4b-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"17.1 Maxilla u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-19 16:50:13.000','2024-06-19 14:50:13.000','2024-06-19 16:50:13.000'),('39aa600d-2e0f-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/ce57500b-227c-11ef-8d76-d310d2ec2c14/session_da355fe4-227c-11ef-8d76-d310d2ec2c14/occlusion_da37d213-227c-11ef-8d76-d310d2ec2c14/scan_e631c430-2e0e-11ef-8deb-d515ea58f6cb/39aa600d-2e0f-11ef-8deb-d515ea58f6cb.ply','PATIENT_ce57500b-227c-11ef-8d76-d310d2ec2c14_ACT_da355fe4-227c-11ef-8d76-d310d2ec2c14_SESS_da37d213-227c-11ef-8d76-d310d2ec2c14_TOSC_e631c430-2e0e-11ef-8deb-d515ea58f6cb_SEG','39aa600d-2e0f-11ef-8deb-d515ea58f6cb.ply','39aa600d-2e0f-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"3.1 Maxillaire u2 Segmentation [pc2]\"}','PLY',0,'SYNCED',0,NULL,'2024-06-19 09:40:40.507','2024-06-19 07:40:40.510','2024-06-19 12:49:15.241'),('39b26fd2-2721-11ef-8e16-d517f37fa1ab',2,'/var/.scan4all/iris/data/2024/2/a1ace9b5-2271-11ef-8d76-d310d2ec2c14/session_a3cf95b8-2720-11ef-8e16-d517f37fa1ab/analyse_a3d2f769-2720-11ef-8e16-d517f37fa1ab/39b26fd2-2721-11ef-8e16-d517f37fa1ab.json','PATIENT_a1ace9b5-2271-11ef-8d76-d310d2ec2c14_ACT_a3cf95b8-2720-11ef-8e16-d517f37fa1ab_ANA_a3d2f769-2720-11ef-8e16-d517f37fa1ab_METER','39b26fd2-2721-11ef-8e16-d517f37fa1ab.json','39b26fd2-2721-11ef-8e16-d517f37fa1ab','{\"displayTitle\":\"2.3 Analyse c1 [pc2]\"}','JSON',0,'SYNCED',0,NULL,'2024-06-10 15:34:30.000','2024-06-10 13:34:30.000','2024-06-10 15:34:30.000'),('3be30703-233b-11ef-8f93-d92a45da78c9',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_2e146f3d-233a-11ef-8f93-d92a45da78c9/3be30703-233b-11ef-8f93-d92a45da78c9.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_TOSC_2e146f3d-233a-11ef-8f93-d92a45da78c9_SNAPS','3be30703-233b-11ef-8f93-d92a45da78c9.png','2e19276e-233a-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Maxillaire u2 Snapshot [pc1]\"}','PNG',2,'SYNCED',0,NULL,'2024-06-05 14:58:03.000','2024-06-05 12:58:03.000','2024-06-05 14:58:03.000'),('3cf533b7-2986-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_08eb58c6-2980-11ef-8e16-d517f37fa2ad/order_d2cfcd57-2985-11ef-8e16-d517f37fa2ad/3cf533b7-2986-11ef-8e16-d517f37fa2ad.pdf','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_PROST_d2cfcd57-2985-11ef-8e16-d517f37fa2ad_FORM','3cf533b7-2986-11ef-8e16-d517f37fa2ad.pdf','3cf533b7-2986-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.5 faccette per i denti 11 e 12\",\"title\":\"faccette per i denti 11 e 12\"}','PDF',0,'SYNCED',0,NULL,'2024-06-13 15:10:02.000','2024-06-13 13:10:02.000','2024-06-13 15:10:02.000'),('3d69b31d-297d-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/b4934f39-2960-11ef-8e16-d517f37fa2ad/session_00fde810-297d-11ef-8e16-d517f37fa2ad/occlusion_01001128-297d-11ef-8e16-d517f37fa2ad/scan_037dbcf6-297d-11ef-8e16-d517f37fa2ad/3d69b31d-297d-11ef-8e16-d517f37fa2ad.zip','PATIENT_b4934f39-2960-11ef-8e16-d517f37fa2ad_ACT_00fde810-297d-11ef-8e16-d517f37fa2ad_SESS_01001128-297d-11ef-8e16-d517f37fa2ad_TOSC_037dbcf6-297d-11ef-8e16-d517f37fa2ad_MODEL','3d69b31d-297d-11ef-8e16-d517f37fa2ad.zip','3d69b31d-297d-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"2.1 Mascella u1\",\"modelMatrix\":\"0.932577,0.354313,-0.0690168,0,-0.320185,0.723655,-0.611395,0,-0.166681,0.592271,0.78831,0,0.454923,-12.0955,-12.1413,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,'2024-06-13 14:08:56.976','2024-06-13 14:05:34.976','2024-06-13 12:08:56.979','2024-06-13 14:08:56.997'),('3d69da80-297d-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/b4934f39-2960-11ef-8e16-d517f37fa2ad/session_00fde810-297d-11ef-8e16-d517f37fa2ad/occlusion_01001128-297d-11ef-8e16-d517f37fa2ad/scan_037dbcf6-297d-11ef-8e16-d517f37fa2ad/3d69da80-297d-11ef-8e16-d517f37fa2ad.png','PATIENT_b4934f39-2960-11ef-8e16-d517f37fa2ad_ACT_00fde810-297d-11ef-8e16-d517f37fa2ad_SESS_01001128-297d-11ef-8e16-d517f37fa2ad_TOSC_037dbcf6-297d-11ef-8e16-d517f37fa2ad_SNAPS','3d69da80-297d-11ef-8e16-d517f37fa2ad.png','3d69da80-297d-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"2.1 Mascella u1 Snapshot\"}','PNG',0,'SYNCED',0,'2024-06-13 14:08:56.976','2024-06-13 14:05:34.977','2024-06-13 12:08:56.981','2024-06-13 14:08:56.997'),('3e218de7-2274-11ef-8d76-d310d2ec2c14',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/scan_96d08283-2273-11ef-8d76-d310d2ec2c14/3e218de7-2274-11ef-8d76-d310d2ec2c14.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_BOSC_96d08283-2273-11ef-8d76-d310d2ec2c14_MODEL','3e218de7-2274-11ef-8d76-d310d2ec2c14.zip','3e218de7-2274-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Mandibule l1 [pc2]\",\"modelMatrix\":\"0.135656,-0.982642,-0.126536,0,0.970104,0.157682,-0.184485,0,0.201235,-0.0977264,0.974656,0,-23.8369,18.6095,-10.139,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 15:13:36.000','2024-06-04 13:13:36.000','2024-06-04 15:13:36.000'),('3e22c831-2274-11ef-8d76-d310d2ec2c14',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/scan_96d08283-2273-11ef-8d76-d310d2ec2c14/3e22c831-2274-11ef-8d76-d310d2ec2c14.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_BOSC_96d08283-2273-11ef-8d76-d310d2ec2c14_SNAPS','3e22c831-2274-11ef-8d76-d310d2ec2c14.png','3e22c831-2274-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Mandibule l1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 15:13:37.000','2024-06-04 13:13:37.000','2024-06-04 15:13:37.000'),('3e23e6e9-297f-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_391a9e5e-297f-11ef-8e16-d517f37fa2ad/analyse_3921a3cd-297f-11ef-8e16-d517f37fa2ad/3e23e6e9-297f-11ef-8e16-d517f37fa2ad.json','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_391a9e5e-297f-11ef-8e16-d517f37fa2ad_ANA_3921a3cd-297f-11ef-8e16-d517f37fa2ad_TRANS','3e23e6e9-297f-11ef-8e16-d517f37fa2ad.json','3e23e6e9-297f-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.4 Analisi m1\"}','JSON',0,'SYNCED',0,NULL,'2024-06-13 14:19:55.190','2024-06-13 12:19:55.198','2024-06-13 14:19:55.965'),('3e7066a0-297f-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_391a9e5e-297f-11ef-8e16-d517f37fa2ad/analyse_3921a3cd-297f-11ef-8e16-d517f37fa2ad/3e7066a0-297f-11ef-8e16-d517f37fa2ad.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_391a9e5e-297f-11ef-8e16-d517f37fa2ad_ANA_3921a3cd-297f-11ef-8e16-d517f37fa2ad_SNAPS','3e7066a0-297f-11ef-8e16-d517f37fa2ad.png','3e7066a0-297f-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.4 Analisi m1\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 14:19:55.691','2024-06-13 12:19:55.693','2024-06-13 14:19:56.318'),('3ef48adf-289c-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/f373c86a-2899-11ef-8e16-d517f37fa2ad/session_627cfe1c-289b-11ef-8e16-d517f37fa2ad/occlusion_627f5b3e-289b-11ef-8e16-d517f37fa2ad/computedocclusion_16a35458-289c-11ef-8e16-d517f37fa2ad/3ef48adf-289c-11ef-8e16-d517f37fa2ad.zip','PATIENT_f373c86a-2899-11ef-8e16-d517f37fa2ad_ACT_627cfe1c-289b-11ef-8e16-d517f37fa2ad_SESS_627f5b3e-289b-11ef-8e16-d517f37fa2ad_OCC_16a35458-289c-11ef-8e16-d517f37fa2ad_TO1','3ef48adf-289c-11ef-8e16-d517f37fa2ad.zip','3ef48adf-289c-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.2 Occlusion o1 Maxillaire u2\",\"modelMatrix\":\"0.997208,-0.0692111,-0.0280363,0,0.0535633,0.924566,-0.377239,0,0.0520305,0.374684,0.925691,0,5.0195,-8.3319,-11.112,1\",\"occlusionMatrix\":\"0.998693,0.0356115,-0.036422,0,-0.0503102,0.825594,-0.562186,0,0.00938891,0.563152,0.826221,0,9.36231,-12.8073,-6.50252,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.2_u2\",\"referenceScanId\":\"db07e23d-289b-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-12 11:15:03.000','2024-06-12 09:42:56.000','2024-06-12 11:42:56.000'),('3f100ab3-289c-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/f373c86a-2899-11ef-8e16-d517f37fa2ad/session_627cfe1c-289b-11ef-8e16-d517f37fa2ad/occlusion_627f5b3e-289b-11ef-8e16-d517f37fa2ad/computedocclusion_16a35458-289c-11ef-8e16-d517f37fa2ad/3f100ab3-289c-11ef-8e16-d517f37fa2ad.zip','PATIENT_f373c86a-2899-11ef-8e16-d517f37fa2ad_ACT_627cfe1c-289b-11ef-8e16-d517f37fa2ad_SESS_627f5b3e-289b-11ef-8e16-d517f37fa2ad_OCC_16a35458-289c-11ef-8e16-d517f37fa2ad_BO1','3f100ab3-289c-11ef-8e16-d517f37fa2ad.zip','3f100ab3-289c-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.2 Occlusion o1 Mandibule l1\",\"modelMatrix\":\"-0.909549,-0.393315,-0.134253,0,0.358828,-0.906181,0.22378,0,-0.209674,0.155365,0.965349,0,11.4657,-0.465422,-11.5412,1\",\"occlusionMatrix\":\"-0.992659,-0.0243563,-0.118079,0,-0.0377617,-0.865449,0.499681,0,-0.114991,0.500418,0.85813,0,10.1884,-6.12473,-9.09403,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.2_l1\",\"referenceScanId\":\"804316c5-289b-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-12 11:15:04.000','2024-06-12 09:42:56.000','2024-06-12 11:42:56.000'),('3f7b0e6c-289c-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/f373c86a-2899-11ef-8e16-d517f37fa2ad/session_627cfe1c-289b-11ef-8e16-d517f37fa2ad/occlusion_627f5b3e-289b-11ef-8e16-d517f37fa2ad/computedocclusion_16a35458-289c-11ef-8e16-d517f37fa2ad/3f7b0e6c-289c-11ef-8e16-d517f37fa2ad.png','PATIENT_f373c86a-2899-11ef-8e16-d517f37fa2ad_ACT_627cfe1c-289b-11ef-8e16-d517f37fa2ad_SESS_627f5b3e-289b-11ef-8e16-d517f37fa2ad_OCC_16a35458-289c-11ef-8e16-d517f37fa2ad_SNAPO','3f7b0e6c-289c-11ef-8e16-d517f37fa2ad.png','3f7b0e6c-289c-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.2 Occlusion o1\",\"occlusionType\":1}','PNG',0,'SYNCED',0,NULL,'2024-06-12 11:15:04.000','2024-06-12 09:42:56.000','2024-06-12 11:42:56.000'),('3f863fa8-2986-11ef-867c-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_3d61afe1-2986-11ef-8e16-d517f37fa2ad/3f863fa8-2986-11ef-867c-6ec2958327c0.pdf','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_PROST_d2cfcd57-2985-11ef-8e16-d517f37fa2ad_FORM','3cf533b7-2986-11ef-8e16-d517f37fa2ad.pdf','3f863fa8-2986-11ef-867c-6ec2958327c0','{\"displayTitle\":\"5.5 faccette per i denti 11 e 12\",\"title\":\"faccette per i denti 11 e 12\"}','PDF',0,'SYNCED',0,NULL,'2024-06-13 15:10:02.000','2024-06-13 13:10:02.000','2024-06-13 15:10:02.000'),('3f867bd2-2986-11ef-867c-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_3d61afe1-2986-11ef-8e16-d517f37fa2ad/3f867bd2-2986-11ef-867c-6ec2958327c0.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_OCC_a4bc6912-2980-11ef-8e16-d517f37fa2ad_TO1','43ea5aab-2981-11ef-8e16-d517f37fa2ad.zip','3f867bd2-2986-11ef-867c-6ec2958327c0','{\"displayTitle\":\"5.5 Occlusione o1 Mascella u1\",\"modelMatrix\":\"0.0885466,-0.989287,-0.116065,0,0.981849,0.106308,-0.157067,0,0.167723,-0.10005,0.980744,0,7.04315,3.35377,-13.5757,1\",\"occlusionMatrix\":\"-0.171625,0.533856,-0.827981,0,0.982265,0.157301,-0.102183,0,0.0756935,-0.830831,-0.551379,0,5.9597,4.42168,0.971543,1\",\"occlusionType\":3,\"referenceScanFullDisplayId\":\"5.5_u1\",\"referenceScanId\":\"099d82e1-2980-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[],\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":2,\"socleIsFullArch\":true,\"socleThickness\":1,\"socleType\":4}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 14:34:26.000','2024-06-13 12:34:26.000','2024-06-13 14:34:26.000'),('3f86b6ca-2986-11ef-867c-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_3d61afe1-2986-11ef-8e16-d517f37fa2ad/3f86b6ca-2986-11ef-867c-6ec2958327c0.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_OCC_a4bc6912-2980-11ef-8e16-d517f37fa2ad_BO1','43ea9afd-2981-11ef-8e16-d517f37fa2ad.zip','3f86b6ca-2986-11ef-867c-6ec2958327c0','{\"displayTitle\":\"5.5 Occlusione o1 Mandibola l1\",\"modelMatrix\":\"-0.0691305,-0.980151,-0.185807,0,0.932705,-0.129585,0.336555,0,-0.353953,-0.150036,0.92315,0,-2.52526,5.094,-12.0573,1\",\"occlusionMatrix\":\"-0.726301,-0.0498987,-0.685575,0,-0.669992,0.274454,0.689787,0,0.15374,0.960326,-0.232761,0,3.4774,-11.0063,-1.91383,1\",\"occlusionType\":3,\"referenceScanFullDisplayId\":\"5.5_l1\",\"referenceScanId\":\"4d76036e-2980-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[],\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":2,\"socleIsFullArch\":true,\"socleThickness\":1,\"socleType\":4}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 14:34:26.000','2024-06-13 12:34:26.000','2024-06-13 14:34:26.000'),('3f86edf4-2986-11ef-867c-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_3d61afe1-2986-11ef-8e16-d517f37fa2ad/3f86edf4-2986-11ef-867c-6ec2958327c0.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_TOSC_099d82e1-2980-11ef-8e16-d517f37fa2ad_MODEL','45df8951-2980-11ef-8e16-d517f37fa2ad.zip','3f86edf4-2986-11ef-867c-6ec2958327c0','{\"displayTitle\":\"5.5 Mascella u1\",\"modelMatrix\":\"0.0885466,-0.989287,-0.116065,0,0.981849,0.106308,-0.157067,0,0.167723,-0.10005,0.980744,0,7.04315,3.35377,-13.5757,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 14:27:22.000','2024-06-13 12:27:22.000','2024-06-13 14:27:22.000'),('3f871fe7-2986-11ef-867c-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_3d61afe1-2986-11ef-8e16-d517f37fa2ad/3f871fe7-2986-11ef-867c-6ec2958327c0.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_TOSC_099d82e1-2980-11ef-8e16-d517f37fa2ad_SNAPS','45df9f47-2980-11ef-8e16-d517f37fa2ad.png','3f871fe7-2986-11ef-867c-6ec2958327c0','{\"displayTitle\":\"5.5 Mascella u1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 14:27:22.000','2024-06-13 12:27:22.000','2024-06-13 14:27:22.000'),('3f87582b-2986-11ef-867c-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_3d61afe1-2986-11ef-8e16-d517f37fa2ad/3f87582b-2986-11ef-867c-6ec2958327c0.json','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_OCC_a4bc6912-2980-11ef-8e16-d517f37fa2ad_METER','7dc312cb-2981-11ef-8e16-d517f37fa2ad.json','3f87582b-2986-11ef-867c-6ec2958327c0','{\"displayTitle\":\"5.5 Occlusione o1\",\"occlusionType\":3}','JSON',0,'SYNCED',0,NULL,'2024-06-13 14:36:02.000','2024-06-13 12:36:02.000','2024-06-13 14:36:02.000'),('3f87900a-2986-11ef-867c-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_3d61afe1-2986-11ef-8e16-d517f37fa2ad/3f87900a-2986-11ef-867c-6ec2958327c0.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_BOSC_4d76036e-2980-11ef-8e16-d517f37fa2ad_MODEL','9ec5df9b-2980-11ef-8e16-d517f37fa2ad.zip','3f87900a-2986-11ef-867c-6ec2958327c0','{\"displayTitle\":\"5.5 Mandibola l1\",\"modelMatrix\":\"-0.0691305,-0.980151,-0.185807,0,0.932705,-0.129585,0.336555,0,-0.353953,-0.150036,0.92315,0,-2.52526,5.094,-12.0573,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 14:29:51.000','2024-06-13 12:29:51.000','2024-06-13 14:29:51.000'),('3f87c5f4-2986-11ef-867c-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_3d61afe1-2986-11ef-8e16-d517f37fa2ad/3f87c5f4-2986-11ef-867c-6ec2958327c0.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_BOSC_4d76036e-2980-11ef-8e16-d517f37fa2ad_SNAPS','9ec5f3b6-2980-11ef-8e16-d517f37fa2ad.png','3f87c5f4-2986-11ef-867c-6ec2958327c0','{\"displayTitle\":\"5.5 Mandibola l1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 14:29:51.000','2024-06-13 12:29:51.000','2024-06-13 14:29:51.000'),('3f880239-2986-11ef-867c-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_3d61afe1-2986-11ef-8e16-d517f37fa2ad/3f880239-2986-11ef-867c-6ec2958327c0.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_OCC_a4bc6912-2980-11ef-8e16-d517f37fa2ad_SCREENO','be9062f3-2982-11ef-8e16-d517f37fa2ad.png','3f880239-2986-11ef-867c-6ec2958327c0','{\"displayTitle\":\"5.5 Occlusione o1 Screenshot 1\",\"occlusionType\":3,\"title\":\"1\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 14:45:00.000','2024-06-13 12:45:00.000','2024-06-13 14:45:00.000'),('3f884750-2986-11ef-867c-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_3d61afe1-2986-11ef-8e16-d517f37fa2ad/3f884750-2986-11ef-867c-6ec2958327c0.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_TOSC_099d82e1-2980-11ef-8e16-d517f37fa2ad_SCREENS','c5e732c1-2983-11ef-8e16-d517f37fa2ad.png','3f884750-2986-11ef-867c-6ec2958327c0','{\"displayTitle\":\"5.5 Mascella u1 Screenshot 1\",\"title\":\"1\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 14:52:22.000','2024-06-13 12:52:22.000','2024-06-13 14:52:22.000'),('3f88890a-2986-11ef-867c-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_3d61afe1-2986-11ef-8e16-d517f37fa2ad/3f88890a-2986-11ef-867c-6ec2958327c0.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_OCC_a4bc6912-2980-11ef-8e16-d517f37fa2ad_SCREENO','dbaacc35-2982-11ef-8e16-d517f37fa2ad.png','3f88890a-2986-11ef-867c-6ec2958327c0','{\"displayTitle\":\"5.5 Occlusione o1 Screenshot 2\",\"occlusionType\":3,\"title\":\"2\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 14:45:49.000','2024-06-13 12:45:49.000','2024-06-13 14:45:49.000'),('3f8bd75a-2986-11ef-867c-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_3d61afe1-2986-11ef-8e16-d517f37fa2ad/3f8bd75a-2986-11ef-867c-6ec2958327c0.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_OCC_a4bc6912-2980-11ef-8e16-d517f37fa2ad_SNAPO','e09fbf20-2980-11ef-8e16-d517f37fa2ad.png','3f8bd75a-2986-11ef-867c-6ec2958327c0','{\"displayTitle\":\"5.5 Occlusione o1\",\"occlusionType\":3}','PNG',0,'SYNCED',0,NULL,'2024-06-13 14:31:40.000','2024-06-13 12:31:40.000','2024-06-13 14:31:40.000'),('3f8c1b2d-2986-11ef-867c-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_3d61afe1-2986-11ef-8e16-d517f37fa2ad/3f8c1b2d-2986-11ef-867c-6ec2958327c0.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_OCC_a4bc6912-2980-11ef-8e16-d517f37fa2ad_SCREENO','e3ffe01f-2982-11ef-8e16-d517f37fa2ad.png','3f8c1b2d-2986-11ef-867c-6ec2958327c0','{\"displayTitle\":\"5.5 Occlusione o1 Screenshot 3\",\"occlusionType\":3,\"title\":\"3\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 14:46:04.000','2024-06-13 12:46:04.000','2024-06-13 14:46:04.000'),('3fb8c8b6-2970-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_8e81ab09-296b-11ef-8e16-d517f37fa2ad/occlusion_8e83509f-296b-11ef-8e16-d517f37fa2ad/computedocclusion_453321dd-296f-11ef-8e16-d517f37fa2ad/3fb8c8b6-2970-11ef-8e16-d517f37fa2ad.zip','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_SESS_8e83509f-296b-11ef-8e16-d517f37fa2ad_OCC_453321dd-296f-11ef-8e16-d517f37fa2ad_TO1','3fb8c8b6-2970-11ef-8e16-d517f37fa2ad.zip','ea897dcd-296f-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Occlusione o1 Mascella u3\",\"modelMatrix\":\"-0.864017,0.469494,-0.181796,0,-0.39807,-0.858135,-0.324261,0,-0.308244,-0.207799,0.928335,0,19.5091,-2.8713,-9.9809,1\",\"occlusionMatrix\":\"-0.592012,-0.757574,-0.274031,0,-0.802245,0.570287,0.155566,0,0.0373833,0.313175,-0.953131,0,12.5931,9.04976,11.5266,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.1_u3\",\"referenceScanId\":\"890595a9-296d-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2024-06-13 12:32:37.000','2024-06-13 10:32:37.000','2024-06-13 12:32:37.000'),('3fd6a6f4-2970-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_8e81ab09-296b-11ef-8e16-d517f37fa2ad/occlusion_8e83509f-296b-11ef-8e16-d517f37fa2ad/computedocclusion_453321dd-296f-11ef-8e16-d517f37fa2ad/3fd6a6f4-2970-11ef-8e16-d517f37fa2ad.xyz','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_SESS_8e83509f-296b-11ef-8e16-d517f37fa2ad_OCC_453321dd-296f-11ef-8e16-d517f37fa2ad_LIFIO','3fd6a6f4-2970-11ef-8e16-d517f37fa2ad.xyz','eaa64966-296f-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Occlusione o1 Mascella u3 Linea di finitura 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY_1\",\"referenceScanFullDisplayId\":\"1.1_u3\",\"referenceScanId\":\"890595a9-296d-11ef-8e16-d517f37fa2ad\",\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',1,'SYNCED',0,NULL,'2024-06-13 12:32:38.000','2024-06-13 10:32:38.000','2024-06-13 12:32:38.000'),('3fd6b050-2970-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_8e81ab09-296b-11ef-8e16-d517f37fa2ad/occlusion_8e83509f-296b-11ef-8e16-d517f37fa2ad/computedocclusion_453321dd-296f-11ef-8e16-d517f37fa2ad/3fd6b050-2970-11ef-8e16-d517f37fa2ad.bin','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_SESS_8e83509f-296b-11ef-8e16-d517f37fa2ad_OCC_453321dd-296f-11ef-8e16-d517f37fa2ad_LIFIMO','3fd6b050-2970-11ef-8e16-d517f37fa2ad.bin','eaa64ffc-296f-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Occlusione o1 Mascella u3 Linea di finitura dei metadati 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY_1\",\"referenceScanFullDisplayId\":\"1.1_u3\",\"referenceScanId\":\"890595a9-296d-11ef-8e16-d517f37fa2ad\",\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',1,'SYNCED',0,NULL,'2024-06-13 12:32:38.000','2024-06-13 10:32:38.000','2024-06-13 12:32:38.000'),('3fd6f8c6-2970-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_8e81ab09-296b-11ef-8e16-d517f37fa2ad/occlusion_8e83509f-296b-11ef-8e16-d517f37fa2ad/computedocclusion_453321dd-296f-11ef-8e16-d517f37fa2ad/3fd6f8c6-2970-11ef-8e16-d517f37fa2ad.zip','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_SESS_8e83509f-296b-11ef-8e16-d517f37fa2ad_OCC_453321dd-296f-11ef-8e16-d517f37fa2ad_BO1','3fd6f8c6-2970-11ef-8e16-d517f37fa2ad.zip','eaa687f7-296f-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Occlusione o1 Mandibola l1\",\"modelMatrix\":\"0.984561,0.053893,-0.16654,0,-0.0386096,0.994853,0.0936833,0,0.170732,-0.0858068,0.981574,0,-13.0352,1.74882,-13.1088,1\",\"occlusionMatrix\":\"-0.506192,-0.616502,-0.606765,0,0.861199,-0.377548,-0.330655,0,-0.0289709,-0.693108,0.721723,0,9.19123,18.3975,-2.2212,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.1_l1\",\"referenceScanId\":\"e2305601-296e-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2024-06-13 12:32:39.000','2024-06-13 10:32:39.000','2024-06-13 12:32:39.000'),('3fefed07-2a2b-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/scan_ea470b5e-2a2a-11ef-8f1c-d8242c6fa8fd/3fefed07-2a2b-11ef-8f1c-d8242c6fa8fd.zip','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_RISC_ea470b5e-2a2a-11ef-8f1c-d8242c6fa8fd_MODEL','3fefed07-2a2b-11ef-8f1c-d8242c6fa8fd.zip','3fefed07-2a2b-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Morso destro br1\",\"modelMatrix\":\"0.996357,-0.0750821,-0.043972,0,0.0737039,0.996593,-0.0374762,0,0.0430558,0.0341327,0.998336,0,-4.51054,-4.94896,-13.1989,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-14 10:51:13.162','2024-06-14 08:51:13.372','2024-06-14 10:51:16.030'),('3ff003dd-2a2b-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/scan_ea470b5e-2a2a-11ef-8f1c-d8242c6fa8fd/3ff003dd-2a2b-11ef-8f1c-d8242c6fa8fd.png','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_RISC_ea470b5e-2a2a-11ef-8f1c-d8242c6fa8fd_SNAPS','3ff003dd-2a2b-11ef-8f1c-d8242c6fa8fd.png','3ff003dd-2a2b-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Morso destro br1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-14 10:51:13.162','2024-06-14 08:51:13.384','2024-06-14 10:51:16.655'),('4212f31d-2e0d-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/172f299e-2e0d-11ef-8deb-d515ea58f6cb/session_1b9240f4-2e0d-11ef-8deb-d515ea58f6cb/occlusion_1b9450aa-2e0d-11ef-8deb-d515ea58f6cb/scan_1c95cecd-2e0d-11ef-8deb-d515ea58f6cb/4212f31d-2e0d-11ef-8deb-d515ea58f6cb.zip','PATIENT_172f299e-2e0d-11ef-8deb-d515ea58f6cb_ACT_1b9240f4-2e0d-11ef-8deb-d515ea58f6cb_SESS_1b9450aa-2e0d-11ef-8deb-d515ea58f6cb_TOSC_1c95cecd-2e0d-11ef-8deb-d515ea58f6cb_MODEL','4212f31d-2e0d-11ef-8deb-d515ea58f6cb.zip','2d0cf740-2e0d-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"15.1 Maxillaire u1 [pc2]\",\"modelMatrix\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"scanBodies\":[],\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":3,\"socleIsFullArch\":true,\"socleThickness\":-1,\"socleType\":1}','ZIP',2,'SYNCED',0,NULL,'2024-06-19 12:49:18.000','2024-06-19 10:49:18.000','2024-06-19 12:49:18.000'),('423d7c80-2985-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_a8885309-2984-11ef-8e16-d517f37fa2ad/occlusion_a888b842-2984-11ef-8e16-d517f37fa2ad/scan_1d4719f4-2985-11ef-8e16-d517f37fa2ad/423d7c80-2985-11ef-8e16-d517f37fa2ad.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_a8885309-2984-11ef-8e16-d517f37fa2ad_SESS_a888b842-2984-11ef-8e16-d517f37fa2ad_BOSC_1d4719f4-2985-11ef-8e16-d517f37fa2ad_MODEL','423d7c80-2985-11ef-8e16-d517f37fa2ad.zip','423d7c80-2985-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.7 Mandibola l1\",\"modelMatrix\":\"0.959092,0.272161,-0.0779181,0,-0.260339,0.739812,-0.620405,0,-0.111206,0.615311,0.780401,0,-10.6931,-9.10435,-8.84207,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 15:02:59.049','2024-06-13 13:05:35.221','2024-06-13 15:05:36.824'),('423d8b1c-2985-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_a8885309-2984-11ef-8e16-d517f37fa2ad/occlusion_a888b842-2984-11ef-8e16-d517f37fa2ad/scan_1d4719f4-2985-11ef-8e16-d517f37fa2ad/423d8b1c-2985-11ef-8e16-d517f37fa2ad.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_a8885309-2984-11ef-8e16-d517f37fa2ad_SESS_a888b842-2984-11ef-8e16-d517f37fa2ad_BOSC_1d4719f4-2985-11ef-8e16-d517f37fa2ad_SNAPS','423d8b1c-2985-11ef-8e16-d517f37fa2ad.png','423d8b1c-2985-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.7 Mandibola l1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 15:02:59.049','2024-06-13 13:05:35.222','2024-06-13 15:05:37.263'),('4276476e-2a2b-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/computedocclusion_e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd/4276476e-2a2b-11ef-8f1c-d8242c6fa8fd.zip','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_OCC_e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd_TO1','4276476e-2a2b-11ef-8f1c-d8242c6fa8fd.zip','4276476e-2a2b-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Occlusione o1 Mascella u1\",\"modelMatrix\":\"0.990607,-0.0477183,-0.128143,0,0.0606045,0.993278,0.0986225,0,0.122576,-0.105462,0.98684,0,-17.296,2.00683,-11.2545,1\",\"occlusionMatrix\":\"0.924318,-0.29636,-0.240447,0,0.28032,0.0996928,0.954718,0,-0.258969,-0.949862,0.175223,0,-9.9933,16.3242,0.804029,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"3.2_u1\",\"referenceScanId\":\"8de1d45c-2a29-11ef-8f1c-d8242c6fa8fd\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-14 10:51:19.000','2024-06-14 08:51:19.000','2024-06-14 10:51:19.000'),('429a4668-2a2b-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/computedocclusion_e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd/429a4668-2a2b-11ef-8f1c-d8242c6fa8fd.zip','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_OCC_e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd_BO1','429a4668-2a2b-11ef-8f1c-d8242c6fa8fd.zip','429a4668-2a2b-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Occlusione o1 Mandibola l1\",\"modelMatrix\":\"-0.934662,0.348207,-0.071824,0,-0.340741,-0.934968,-0.098644,0,-0.101502,-0.0677254,0.992527,0,16.8656,-3.96577,-16.4235,1\",\"occlusionMatrix\":\"0.846546,-0.413935,-0.334734,0,-0.309491,0.128932,-0.942125,0,0.433136,0.901149,-0.0189629,0,-21.9847,-8.389,6.55854,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"3.2_l1\",\"referenceScanId\":\"80540c46-2a2a-11ef-8f1c-d8242c6fa8fd\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-14 10:51:20.000','2024-06-14 08:51:20.000','2024-06-14 10:51:20.000'),('432c5ac7-2a2b-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/computedocclusion_e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd/432c5ac7-2a2b-11ef-8f1c-d8242c6fa8fd.png','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_OCC_e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd_SNAPO','432c5ac7-2a2b-11ef-8f1c-d8242c6fa8fd.png','432c5ac7-2a2b-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Occlusione o1\",\"occlusionType\":1}','PNG',0,'SYNCED',0,NULL,'2024-06-14 10:51:20.000','2024-06-14 08:51:20.000','2024-06-14 10:51:20.000'),('4343804f-296f-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_8e81ab09-296b-11ef-8e16-d517f37fa2ad/occlusion_8e83509f-296b-11ef-8e16-d517f37fa2ad/scan_e2305601-296e-11ef-8e16-d517f37fa2ad/4343804f-296f-11ef-8e16-d517f37fa2ad.zip','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_SESS_8e83509f-296b-11ef-8e16-d517f37fa2ad_BOSC_e2305601-296e-11ef-8e16-d517f37fa2ad_MODEL','4343804f-296f-11ef-8e16-d517f37fa2ad.zip','4343804f-296f-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Mandibola l1\",\"modelMatrix\":\"0.984561,0.053893,-0.16654,0,-0.0386096,0.994853,0.0936833,0,0.170732,-0.0858068,0.981574,0,-13.0352,1.74882,-13.1088,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 12:25:31.838','2024-06-13 10:25:32.512','2024-06-13 12:26:30.334'),('43438f7c-296f-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_8e81ab09-296b-11ef-8e16-d517f37fa2ad/occlusion_8e83509f-296b-11ef-8e16-d517f37fa2ad/scan_e2305601-296e-11ef-8e16-d517f37fa2ad/43438f7c-296f-11ef-8e16-d517f37fa2ad.png','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_SESS_8e83509f-296b-11ef-8e16-d517f37fa2ad_BOSC_e2305601-296e-11ef-8e16-d517f37fa2ad_SNAPS','43438f7c-296f-11ef-8e16-d517f37fa2ad.png','43438f7c-296f-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Mandibola l1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 12:25:31.838','2024-06-13 10:25:32.513','2024-06-13 12:26:31.536'),('43ea5aab-2981-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_08eb58c6-2980-11ef-8e16-d517f37fa2ad/occlusion_08ed7a4a-2980-11ef-8e16-d517f37fa2ad/computedocclusion_a4bc6912-2980-11ef-8e16-d517f37fa2ad/43ea5aab-2981-11ef-8e16-d517f37fa2ad.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_OCC_a4bc6912-2980-11ef-8e16-d517f37fa2ad_TO1','43ea5aab-2981-11ef-8e16-d517f37fa2ad.zip','dff96d3d-2980-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.5 Occlusione o1 Mascella u1\",\"modelMatrix\":\"0.0885466,-0.989287,-0.116065,0,0.981849,0.106308,-0.157067,0,0.167723,-0.10005,0.980744,0,7.04315,3.35377,-13.5757,1\",\"occlusionMatrix\":\"-0.171625,0.533856,-0.827981,0,0.982265,0.157301,-0.102183,0,0.0756935,-0.830831,-0.551379,0,5.9597,4.42168,0.971543,1\",\"occlusionType\":3,\"referenceScanFullDisplayId\":\"5.5_u1\",\"referenceScanId\":\"099d82e1-2980-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[],\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":2,\"socleIsFullArch\":true,\"socleThickness\":1,\"socleType\":4}','ZIP',4,'SYNCED',0,NULL,'2024-06-13 14:34:26.000','2024-06-13 12:34:26.000','2024-06-13 14:34:26.000'),('43ea9afd-2981-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_08eb58c6-2980-11ef-8e16-d517f37fa2ad/occlusion_08ed7a4a-2980-11ef-8e16-d517f37fa2ad/computedocclusion_a4bc6912-2980-11ef-8e16-d517f37fa2ad/43ea9afd-2981-11ef-8e16-d517f37fa2ad.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_OCC_a4bc6912-2980-11ef-8e16-d517f37fa2ad_BO1','43ea9afd-2981-11ef-8e16-d517f37fa2ad.zip','e01e29be-2980-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.5 Occlusione o1 Mandibola l1\",\"modelMatrix\":\"-0.0691305,-0.980151,-0.185807,0,0.932705,-0.129585,0.336555,0,-0.353953,-0.150036,0.92315,0,-2.52526,5.094,-12.0573,1\",\"occlusionMatrix\":\"-0.726301,-0.0498987,-0.685575,0,-0.669992,0.274454,0.689787,0,0.15374,0.960326,-0.232761,0,3.4774,-11.0063,-1.91383,1\",\"occlusionType\":3,\"referenceScanFullDisplayId\":\"5.5_l1\",\"referenceScanId\":\"4d76036e-2980-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[],\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":2,\"socleIsFullArch\":true,\"socleThickness\":1,\"socleType\":4}','ZIP',3,'SYNCED',0,NULL,'2024-06-13 14:34:26.000','2024-06-13 12:34:26.000','2024-06-13 14:34:26.000'),('451fc815-2e3b-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_da1f6873-2e3a-11ef-8deb-d515ea58f6cb/occlusion_da21a6e4-2e3a-11ef-8deb-d515ea58f6cb/scan_18dce61e-2e3b-11ef-8deb-d515ea58f6cb/451fc815-2e3b-11ef-8deb-d515ea58f6cb.zip','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_da1f6873-2e3a-11ef-8deb-d515ea58f6cb_SESS_da21a6e4-2e3a-11ef-8deb-d515ea58f6cb_BOSC_18dce61e-2e3b-11ef-8deb-d515ea58f6cb_MODEL','451fc815-2e3b-11ef-8deb-d515ea58f6cb.zip','451fc815-2e3b-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.2 Mandible l1 [pc2]\",\"modelMatrix\":\"0.988345,0.152164,-0.00455078,0,-0.132711,0.846578,-0.515455,0,-0.0745809,0.510051,0.856905,0,-6.06382,-8.89201,-8.94358,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-19 14:55:57.588','2024-06-19 12:55:57.964','2024-06-19 14:56:00.033'),('451fd81d-2e3b-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_da1f6873-2e3a-11ef-8deb-d515ea58f6cb/occlusion_da21a6e4-2e3a-11ef-8deb-d515ea58f6cb/scan_18dce61e-2e3b-11ef-8deb-d515ea58f6cb/451fd81d-2e3b-11ef-8deb-d515ea58f6cb.png','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_da1f6873-2e3a-11ef-8deb-d515ea58f6cb_SESS_da21a6e4-2e3a-11ef-8deb-d515ea58f6cb_BOSC_18dce61e-2e3b-11ef-8deb-d515ea58f6cb_SNAPS','451fd81d-2e3b-11ef-8deb-d515ea58f6cb.png','451fd81d-2e3b-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.2 Mandible l1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-19 14:55:57.588','2024-06-19 12:55:57.964','2024-06-19 14:56:00.800'),('45316198-2a2c-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/scan_80540c46-2a2a-11ef-8f1c-d8242c6fa8fd/45316198-2a2c-11ef-8f1c-d8242c6fa8fd.json','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_BOSC_80540c46-2a2a-11ef-8f1c-d8242c6fa8fd_METER','45316198-2a2c-11ef-8f1c-d8242c6fa8fd.json','45316198-2a2c-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Mandibola l1 Misura\"}','JSON',0,'SYNCED',0,NULL,'2024-06-14 10:58:31.476','2024-06-14 08:58:31.481','2024-06-14 10:58:31.863'),('45df8951-2980-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_08eb58c6-2980-11ef-8e16-d517f37fa2ad/occlusion_08ed7a4a-2980-11ef-8e16-d517f37fa2ad/scan_099d82e1-2980-11ef-8e16-d517f37fa2ad/45df8951-2980-11ef-8e16-d517f37fa2ad.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_TOSC_099d82e1-2980-11ef-8e16-d517f37fa2ad_MODEL','45df8951-2980-11ef-8e16-d517f37fa2ad.zip','45df8951-2980-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.5 Mascella u1\",\"modelMatrix\":\"0.0885466,-0.989287,-0.116065,0,0.981849,0.106308,-0.157067,0,0.167723,-0.10005,0.980744,0,7.04315,3.35377,-13.5757,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 14:27:22.000','2024-06-13 12:27:22.000','2024-06-13 14:27:22.000'),('45df9f47-2980-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_08eb58c6-2980-11ef-8e16-d517f37fa2ad/occlusion_08ed7a4a-2980-11ef-8e16-d517f37fa2ad/scan_099d82e1-2980-11ef-8e16-d517f37fa2ad/45df9f47-2980-11ef-8e16-d517f37fa2ad.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_TOSC_099d82e1-2980-11ef-8e16-d517f37fa2ad_SNAPS','45df9f47-2980-11ef-8e16-d517f37fa2ad.png','45df9f47-2980-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.5 Mascella u1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 14:27:22.000','2024-06-13 12:27:22.000','2024-06-13 14:27:22.000'),('46a066cb-2e0d-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/172f299e-2e0d-11ef-8deb-d515ea58f6cb/session_1b9240f4-2e0d-11ef-8deb-d515ea58f6cb/occlusion_1b9450aa-2e0d-11ef-8deb-d515ea58f6cb/scan_1c95cecd-2e0d-11ef-8deb-d515ea58f6cb/46a066cb-2e0d-11ef-8deb-d515ea58f6cb.ply','PATIENT_172f299e-2e0d-11ef-8deb-d515ea58f6cb_ACT_1b9240f4-2e0d-11ef-8deb-d515ea58f6cb_SESS_1b9450aa-2e0d-11ef-8deb-d515ea58f6cb_TOSC_1c95cecd-2e0d-11ef-8deb-d515ea58f6cb_SEG','46a066cb-2e0d-11ef-8deb-d515ea58f6cb.ply','46a066cb-2e0d-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"15.1 Maxillaire u1 Segmentation [pc2]\"}','PLY',0,'SYNCED',0,NULL,'2024-06-19 09:26:43.259','2024-06-19 07:26:43.262','2024-06-19 12:49:18.482'),('4833ab27-297f-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_391a9e5e-297f-11ef-8e16-d517f37fa2ad/analyse_3921a3cd-297f-11ef-8e16-d517f37fa2ad/4833ab27-297f-11ef-8e16-d517f37fa2ad.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_391a9e5e-297f-11ef-8e16-d517f37fa2ad_ANA_3921a3cd-297f-11ef-8e16-d517f37fa2ad_SCREENS','4833ab27-297f-11ef-8e16-d517f37fa2ad.png','4833ab27-297f-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.4 Analisi m1 Screenshot 1\",\"title\":\"1\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 14:20:12.070','2024-06-13 12:20:12.214','2024-06-13 14:20:12.252'),('483e0c64-28bb-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/09f7c5e2-28bb-11ef-8e16-d517f37fa2ad/session_118f12a1-28bb-11ef-8e16-d517f37fa2ad/occlusion_11917a4e-28bb-11ef-8e16-d517f37fa2ad/scan_12fa8aba-28bb-11ef-8e16-d517f37fa2ad/483e0c64-28bb-11ef-8e16-d517f37fa2ad.zip','PATIENT_09f7c5e2-28bb-11ef-8e16-d517f37fa2ad_ACT_118f12a1-28bb-11ef-8e16-d517f37fa2ad_SESS_11917a4e-28bb-11ef-8e16-d517f37fa2ad_BOSC_12fa8aba-28bb-11ef-8e16-d517f37fa2ad_MODEL','483e0c64-28bb-11ef-8e16-d517f37fa2ad.zip','483e0c64-28bb-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"3.1 Mandibule l1\",\"modelMatrix\":\"-0.775495,0.597864,-0.202893,0,-0.500889,-0.778241,-0.378748,0,-0.384339,-0.19209,0.902986,0,16.4262,-4.01591,-9.08821,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-12 14:57:10.779','2024-06-12 12:57:11.409','2024-06-12 14:57:13.355'),('483e1f47-28bb-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/09f7c5e2-28bb-11ef-8e16-d517f37fa2ad/session_118f12a1-28bb-11ef-8e16-d517f37fa2ad/occlusion_11917a4e-28bb-11ef-8e16-d517f37fa2ad/scan_12fa8aba-28bb-11ef-8e16-d517f37fa2ad/483e1f47-28bb-11ef-8e16-d517f37fa2ad.png','PATIENT_09f7c5e2-28bb-11ef-8e16-d517f37fa2ad_ACT_118f12a1-28bb-11ef-8e16-d517f37fa2ad_SESS_11917a4e-28bb-11ef-8e16-d517f37fa2ad_BOSC_12fa8aba-28bb-11ef-8e16-d517f37fa2ad_SNAPS','483e1f47-28bb-11ef-8e16-d517f37fa2ad.png','483e1f47-28bb-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"3.1 Mandibule l1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-12 14:57:10.780','2024-06-12 12:57:11.410','2024-06-12 14:57:16.099'),('48ab0b8c-233a-11ef-8f93-d92a45da78c9',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_23e52d54-2338-11ef-8f93-d92a45da78c9/48ab0b8c-233a-11ef-8f93-d92a45da78c9.xyz','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_BOSC_23e52d54-2338-11ef-8f93-d92a45da78c9_LIFI','48ab0b8c-233a-11ef-8f93-d92a45da78c9.xyz','48ab0b8c-233a-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Mandibule l1 Ligne de finition auto [pc1]\",\"title\":\"auto\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-05 14:51:10.000','2024-06-05 12:51:24.000','2024-06-05 14:51:24.000'),('48ab1080-233a-11ef-8f93-d92a45da78c9',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_23e52d54-2338-11ef-8f93-d92a45da78c9/48ab1080-233a-11ef-8f93-d92a45da78c9.bin','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_BOSC_23e52d54-2338-11ef-8f93-d92a45da78c9_LIFIM','48ab1080-233a-11ef-8f93-d92a45da78c9.bin','48ab1080-233a-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Mandibule l1 Ligne de finition métadonnées auto [pc1]\",\"title\":\"auto\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-05 14:51:10.000','2024-06-05 12:51:25.000','2024-06-05 14:51:25.000'),('48ae5f56-233a-11ef-8f93-d92a45da78c9',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/computedocclusion_a2829ff3-2338-11ef-8f93-d92a45da78c9/48ae5f56-233a-11ef-8f93-d92a45da78c9.xyz','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_OCC_a2829ff3-2338-11ef-8f93-d92a45da78c9_LIFIO','48ae5f56-233a-11ef-8f93-d92a45da78c9.xyz','48ae5f56-233a-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Occlusion o1 Mandibule l1 Ligne de finition auto [pc1]\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MANDIBLE_1\",\"referenceScanFullDisplayId\":\"1.5_l1\",\"referenceScanId\":\"23e52d54-2338-11ef-8f93-d92a45da78c9\",\"title\":\"auto\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-05 14:51:10.000','2024-06-05 12:51:25.000','2024-06-05 14:51:25.000'),('48ae63e5-233a-11ef-8f93-d92a45da78c9',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/computedocclusion_a2829ff3-2338-11ef-8f93-d92a45da78c9/48ae63e5-233a-11ef-8f93-d92a45da78c9.bin','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_OCC_a2829ff3-2338-11ef-8f93-d92a45da78c9_LIFIMO','48ae63e5-233a-11ef-8f93-d92a45da78c9.bin','48ae63e5-233a-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Occlusion o1 Mandibule l1 Ligne de finition métadonnées auto [pc1]\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MANDIBLE_1\",\"referenceScanFullDisplayId\":\"1.5_l1\",\"referenceScanId\":\"23e52d54-2338-11ef-8f93-d92a45da78c9\",\"title\":\"auto\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-05 14:51:10.000','2024-06-05 12:51:24.000','2024-06-05 14:51:24.000'),('4c944e2f-2338-11ef-8f93-d92a45da78c9',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_23e52d54-2338-11ef-8f93-d92a45da78c9/4c944e2f-2338-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_BOSC_23e52d54-2338-11ef-8f93-d92a45da78c9_MODEL','4c944e2f-2338-11ef-8f93-d92a45da78c9.zip','4c944e2f-2338-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Mandibule l1 [pc1]\",\"modelMatrix\":\"0.912405,-0.408985,0.0157505,0,0.408648,0.908152,-0.0909209,0,0.0228815,0.0893931,0.995733,0,-14.1029,6.9381,-10.6228,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-05 14:37:02.000','2024-06-05 12:37:02.000','2024-06-05 14:37:02.000'),('4c9462f1-2338-11ef-8f93-d92a45da78c9',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_23e52d54-2338-11ef-8f93-d92a45da78c9/4c9462f1-2338-11ef-8f93-d92a45da78c9.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_BOSC_23e52d54-2338-11ef-8f93-d92a45da78c9_SNAPS','4c9462f1-2338-11ef-8f93-d92a45da78c9.png','4c9462f1-2338-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Mandibule l1 Snapshot [pc1]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-05 14:37:03.000','2024-06-05 12:37:03.000','2024-06-05 14:37:03.000'),('4d86cd45-2e36-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_3654e763-2e35-11ef-8deb-d515ea58f6cb/occlusion_36556270-2e35-11ef-8deb-d515ea58f6cb/scan_1e568150-2e36-11ef-8deb-d515ea58f6cb/4d86cd45-2e36-11ef-8deb-d515ea58f6cb.zip','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_3654e763-2e35-11ef-8deb-d515ea58f6cb_SESS_36556270-2e35-11ef-8deb-d515ea58f6cb_BOSC_1e568150-2e36-11ef-8deb-d515ea58f6cb_MODEL','4d86cd45-2e36-11ef-8deb-d515ea58f6cb.zip','4d86cd45-2e36-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.1 Mandibola l1 [pc2]\",\"modelMatrix\":\"-0.26757,0.958637,0.097067,0,-0.95222,-0.278477,0.125409,0,0.147252,-0.0588737,0.987345,0,14.9061,-9.96051,-14.8502,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-19 14:20:24.201','2024-06-19 12:20:24.690','2024-06-19 14:20:26.572'),('4d86de52-2e36-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_3654e763-2e35-11ef-8deb-d515ea58f6cb/occlusion_36556270-2e35-11ef-8deb-d515ea58f6cb/scan_1e568150-2e36-11ef-8deb-d515ea58f6cb/4d86de52-2e36-11ef-8deb-d515ea58f6cb.png','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_3654e763-2e35-11ef-8deb-d515ea58f6cb_SESS_36556270-2e35-11ef-8deb-d515ea58f6cb_BOSC_1e568150-2e36-11ef-8deb-d515ea58f6cb_SNAPS','4d86de52-2e36-11ef-8deb-d515ea58f6cb.png','4d86de52-2e36-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.1 Mandibola l1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-19 14:20:24.201','2024-06-19 12:20:24.690','2024-06-19 14:20:28.512'),('4ec99c8e-297f-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_391a9e5e-297f-11ef-8e16-d517f37fa2ad/analyse_3921a3cd-297f-11ef-8e16-d517f37fa2ad/4ec99c8e-297f-11ef-8e16-d517f37fa2ad.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_391a9e5e-297f-11ef-8e16-d517f37fa2ad_ANA_3921a3cd-297f-11ef-8e16-d517f37fa2ad_SCREENS','4ec99c8e-297f-11ef-8e16-d517f37fa2ad.png','4ec99c8e-297f-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.4 Analisi m1 Screenshot 2\",\"title\":\"2\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 14:20:23.119','2024-06-13 12:20:23.238','2024-06-13 14:20:23.278'),('4fbc922f-2984-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_35920e04-2984-11ef-8e16-d517f37fa2ad/analyse_3596b1fd-2984-11ef-8e16-d517f37fa2ad/4fbc922f-2984-11ef-8e16-d517f37fa2ad.json','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_35920e04-2984-11ef-8e16-d517f37fa2ad_ANA_3596b1fd-2984-11ef-8e16-d517f37fa2ad_TRANS','4fbc922f-2984-11ef-8e16-d517f37fa2ad.json','4fbc922f-2984-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.6 Analisi c1\"}','JSON',0,'SYNCED',0,NULL,'2024-06-13 14:56:12.195','2024-06-13 12:56:12.205','2024-06-13 14:56:12.959'),('50033512-2984-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_35920e04-2984-11ef-8e16-d517f37fa2ad/analyse_3596b1fd-2984-11ef-8e16-d517f37fa2ad/50033512-2984-11ef-8e16-d517f37fa2ad.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_35920e04-2984-11ef-8e16-d517f37fa2ad_ANA_3596b1fd-2984-11ef-8e16-d517f37fa2ad_SNAPS','50033512-2984-11ef-8e16-d517f37fa2ad.png','50033512-2984-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.6 Analisi c1\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 14:56:12.658','2024-06-13 12:56:12.660','2024-06-13 14:56:13.199'),('5113bce8-2e46-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/8f5ceea7-2740-11ef-8e09-d517f1736dc8/session_8f6c8859-2740-11ef-8e09-d517f1736dc8/occlusion_8f6cf168-2740-11ef-8e09-d517f1736dc8/scan_8f6d5887-2740-11ef-8e09-d517f1736dc8/5113bce8-2e46-11ef-8deb-d515ea58f6cb.ply','PATIENT_8f5ceea7-2740-11ef-8e09-d517f1736dc8_ACT_8f6c8859-2740-11ef-8e09-d517f1736dc8_SESS_8f6cf168-2740-11ef-8e09-d517f1736dc8_TOSC_8f6d5887-2740-11ef-8e09-d517f1736dc8_SEG','5113bce8-2e46-11ef-8deb-d515ea58f6cb.ply','5113bce8-2e46-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"12.1 Maxilla u1 Segmentation [pc2]\"}','PLY',0,'SYNCED',0,NULL,'2024-06-19 16:15:02.106','2024-06-19 14:15:02.141','2024-06-19 16:15:02.876'),('51e7fbf0-233a-11ef-8f93-d92a45da78c9',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_23e52d54-2338-11ef-8f93-d92a45da78c9/51e7fbf0-233a-11ef-8f93-d92a45da78c9.xyz','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_BOSC_23e52d54-2338-11ef-8f93-d92a45da78c9_LIFI','51e7fbf0-233a-11ef-8f93-d92a45da78c9.xyz','48ab0b8c-233a-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Mandibule l1 Ligne de finition auto [pc1]\",\"title\":\"auto\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',1,'SYNCED',0,NULL,'2024-06-05 14:51:27.000','2024-06-05 12:51:27.000','2024-06-05 14:51:27.000'),('51e81127-233a-11ef-8f93-d92a45da78c9',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_23e52d54-2338-11ef-8f93-d92a45da78c9/51e81127-233a-11ef-8f93-d92a45da78c9.bin','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_BOSC_23e52d54-2338-11ef-8f93-d92a45da78c9_LIFIM','51e81127-233a-11ef-8f93-d92a45da78c9.bin','48ab1080-233a-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Mandibule l1 Ligne de finition métadonnées auto [pc1]\",\"title\":\"auto\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',1,'SYNCED',0,NULL,'2024-06-05 14:51:27.000','2024-06-05 12:51:27.000','2024-06-05 14:51:27.000'),('51ec0746-233a-11ef-8f93-d92a45da78c9',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/computedocclusion_a2829ff3-2338-11ef-8f93-d92a45da78c9/51ec0746-233a-11ef-8f93-d92a45da78c9.xyz','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_OCC_a2829ff3-2338-11ef-8f93-d92a45da78c9_LIFIO','51ec0746-233a-11ef-8f93-d92a45da78c9.xyz','48ae5f56-233a-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Occlusion o1 Mandibule l1 Ligne de finition auto [pc1]\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MANDIBLE_1\",\"referenceScanFullDisplayId\":\"1.5_l1\",\"referenceScanId\":\"23e52d54-2338-11ef-8f93-d92a45da78c9\",\"title\":\"auto\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',1,'SYNCED',0,NULL,'2024-06-05 14:51:28.000','2024-06-05 12:51:28.000','2024-06-05 14:51:28.000'),('51ec1340-233a-11ef-8f93-d92a45da78c9',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/computedocclusion_a2829ff3-2338-11ef-8f93-d92a45da78c9/51ec1340-233a-11ef-8f93-d92a45da78c9.bin','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_OCC_a2829ff3-2338-11ef-8f93-d92a45da78c9_LIFIMO','51ec1340-233a-11ef-8f93-d92a45da78c9.bin','48ae63e5-233a-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Occlusion o1 Mandibule l1 Ligne de finition métadonnées auto [pc1]\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MANDIBLE_1\",\"referenceScanFullDisplayId\":\"1.5_l1\",\"referenceScanId\":\"23e52d54-2338-11ef-8f93-d92a45da78c9\",\"title\":\"auto\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',1,'SYNCED',0,NULL,'2024-06-05 14:51:29.000','2024-06-05 12:51:29.000','2024-06-05 14:51:29.000'),('54a67fcd-226b-11ef-8f1f-d8242c71b430',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_757ed4bc-2266-11ef-8f1f-d8242c71b430/order_7585401e-2266-11ef-8f1f-d8242c71b430/54a67fcd-226b-11ef-8f1f-d8242c71b430.pdf','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_PROST_7585401e-2266-11ef-8f1f-d8242c71b430_FORM','54a67fcd-226b-11ef-8f1f-d8242c71b430.pdf','54a67fcd-226b-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.2 Couronne\",\"title\":\"Couronne\"}','PDF',0,'SYNCED',0,NULL,'2024-06-04 14:09:45.000','2024-06-04 12:09:45.000','2024-06-04 14:09:45.000'),('5715ee44-273e-11ef-8e09-d517f1736dc8',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/scan_01f8eb7b-273e-11ef-8e09-d517f1736dc8/5715ee44-273e-11ef-8e09-d517f1736dc8.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_BOSC_01f8eb7b-273e-11ef-8e09-d517f1736dc8_MODEL','5715ee44-273e-11ef-8e09-d517f1736dc8.zip','5715ee44-273e-11ef-8e09-d517f1736dc8','{\"displayTitle\":\"1.2 Mandibule l2 [pc2]\",\"modelMatrix\":\"0.994171,0.100892,-0.0380221,0,-0.103498,0.794188,-0.598794,0,-0.0302166,0.599239,0.8,0,-0.768087,-9.35939,-13.0752,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-10 17:30:17.428','2024-06-10 15:30:17.550','2024-06-10 17:30:20.923'),('5715faa2-273e-11ef-8e09-d517f1736dc8',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/scan_01f8eb7b-273e-11ef-8e09-d517f1736dc8/5715faa2-273e-11ef-8e09-d517f1736dc8.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_BOSC_01f8eb7b-273e-11ef-8e09-d517f1736dc8_SNAPS','5715faa2-273e-11ef-8e09-d517f1736dc8.png','5715faa2-273e-11ef-8e09-d517f1736dc8','{\"displayTitle\":\"1.2 Mandibule l2 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-10 17:30:17.428','2024-06-10 15:30:17.551','2024-06-10 17:30:22.593'),('58bcb05a-226f-11ef-8f1f-d8242c71b430',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f6cfa4bf-226e-11ef-8f1f-d8242c71b430/occlusion_f6d13d7e-226e-11ef-8f1f-d8242c71b430/scan_24861dc8-226f-11ef-8f1f-d8242c71b430/58bcb05a-226f-11ef-8f1f-d8242c71b430.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f6cfa4bf-226e-11ef-8f1f-d8242c71b430_SESS_f6d13d7e-226e-11ef-8f1f-d8242c71b430_TOSC_24861dc8-226f-11ef-8f1f-d8242c71b430_MODEL','58bcb05a-226f-11ef-8f1f-d8242c71b430.zip','58bcb05a-226f-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.3 Maxillaire u1 [pc1]\",\"modelMatrix\":\"-0.907546,0.40641,-0.105791,0,-0.405009,-0.780419,0.476355,0,0.111034,0.47516,0.872865,0,4.28957,-8.29297,-14.2564,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 14:38:43.000','2024-06-04 12:38:43.000','2024-06-04 14:38:43.000'),('58bcc45d-226f-11ef-8f1f-d8242c71b430',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f6cfa4bf-226e-11ef-8f1f-d8242c71b430/occlusion_f6d13d7e-226e-11ef-8f1f-d8242c71b430/scan_24861dc8-226f-11ef-8f1f-d8242c71b430/58bcc45d-226f-11ef-8f1f-d8242c71b430.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f6cfa4bf-226e-11ef-8f1f-d8242c71b430_SESS_f6d13d7e-226e-11ef-8f1f-d8242c71b430_TOSC_24861dc8-226f-11ef-8f1f-d8242c71b430_SNAPS','58bcc45d-226f-11ef-8f1f-d8242c71b430.png','58bcc45d-226f-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.3 Maxillaire u1 Snapshot [pc1]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 14:38:44.000','2024-06-04 12:38:44.000','2024-06-04 14:38:44.000'),('59191380-233f-11ef-8f93-d92a45da78c9',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_ef3ba736-2337-11ef-8f93-d92a45da78c9/59191380-233f-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_TOSC_ef3ba736-2337-11ef-8f93-d92a45da78c9_MODEL','59191380-233f-11ef-8f93-d92a45da78c9.zip','1ffb9e9c-2338-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Maxillaire u1 [pc1]\",\"modelMatrix\":\"-0.923468,0.0376561,-0.381824,0,-0.158116,-0.944087,0.289308,0,-0.349581,0.327539,0.877788,0,12.8471,-2.21044,-5.73295,1\",\"scanBodies\":[],\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":3,\"socleIsFullArch\":true,\"socleThickness\":-1,\"socleType\":1}','ZIP',2,'SYNCED',0,NULL,'2024-06-05 15:27:28.000','2024-06-05 13:27:28.000','2024-06-05 15:27:28.000'),('5940b0ad-2740-11ef-8e09-d517f1736dc8',2,'/var/.scan4all/iris/data/2024/2/ce57500b-227c-11ef-8d76-d310d2ec2c14/session_5467faec-2740-11ef-8e09-d517f1736dc8/analyse_546fc1fa-2740-11ef-8e09-d517f1736dc8/5940b0ad-2740-11ef-8e09-d517f1736dc8.json','PATIENT_ce57500b-227c-11ef-8d76-d310d2ec2c14_ACT_5467faec-2740-11ef-8e09-d517f1736dc8_ANA_546fc1fa-2740-11ef-8e09-d517f1736dc8_TRANS','5940b0ad-2740-11ef-8e09-d517f1736dc8.json','5940b0ad-2740-11ef-8e09-d517f1736dc8','{\"displayTitle\":\"3.2 Analyse m1 [pc2]\"}','JSON',0,'SYNCED',0,NULL,'2024-06-10 17:44:40.057','2024-06-10 15:44:40.061','2024-06-10 17:44:41.226'),('596c715a-233c-11ef-8f93-d92a45da78c9',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_596c4e98-233c-11ef-8f93-d92a45da78c9/596c715a-233c-11ef-8f93-d92a45da78c9.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_BOSC_596c4e98-233c-11ef-8f93-d92a45da78c9_SNAPS','596c715a-233c-11ef-8f93-d92a45da78c9.png','596c715a-233c-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Mandibule l2 Snapshot [pc1]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-05 15:06:00.000','2024-06-05 13:06:00.000','2024-06-05 15:06:00.000'),('596c8055-233c-11ef-8f93-d92a45da78c9',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_596c4e98-233c-11ef-8f93-d92a45da78c9/596c8055-233c-11ef-8f93-d92a45da78c9.xyz','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_BOSC_596c4e98-233c-11ef-8f93-d92a45da78c9_LIFI','596c8055-233c-11ef-8f93-d92a45da78c9.xyz','596c8055-233c-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Mandibule l2 Ligne de finition auto [pc1]\",\"title\":\"auto\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-05 15:06:00.000','2024-06-05 13:06:00.000','2024-06-05 15:06:00.000'),('596c8c7f-233c-11ef-8f93-d92a45da78c9',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_596c4e98-233c-11ef-8f93-d92a45da78c9/596c8c7f-233c-11ef-8f93-d92a45da78c9.bin','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_BOSC_596c4e98-233c-11ef-8f93-d92a45da78c9_LIFIM','596c8c7f-233c-11ef-8f93-d92a45da78c9.bin','596c8c7f-233c-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Mandibule l2 Ligne de finition métadonnées auto [pc1]\",\"title\":\"auto\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-05 15:06:01.000','2024-06-05 13:06:01.000','2024-06-05 15:06:01.000'),('596cc291-233c-11ef-8f93-d92a45da78c9',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_596c4e98-233c-11ef-8f93-d92a45da78c9/596cc291-233c-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_BOSC_596c4e98-233c-11ef-8f93-d92a45da78c9_MODEL','596cc291-233c-11ef-8f93-d92a45da78c9.zip','596cc291-233c-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Mandibule l2 [pc1]\",\"modelMatrix\":\"0.912405,-0.408985,0.0157505,0,0.408648,0.908152,-0.0909209,0,0.0228815,0.0893931,0.995733,0,-14.1029,6.9381,-10.6228,1\",\"scanBodies\":[],\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":3,\"socleIsFullArch\":true,\"socleThickness\":-1,\"socleType\":3}','ZIP',0,'SYNCED',0,NULL,'2024-06-05 15:06:06.000','2024-06-05 13:06:06.000','2024-06-05 15:06:06.000'),('5974ba96-2740-11ef-8e09-d517f1736dc8',2,'/var/.scan4all/iris/data/2024/2/ce57500b-227c-11ef-8d76-d310d2ec2c14/session_5467faec-2740-11ef-8e09-d517f1736dc8/analyse_546fc1fa-2740-11ef-8e09-d517f1736dc8/5974ba96-2740-11ef-8e09-d517f1736dc8.png','PATIENT_ce57500b-227c-11ef-8d76-d310d2ec2c14_ACT_5467faec-2740-11ef-8e09-d517f1736dc8_ANA_546fc1fa-2740-11ef-8e09-d517f1736dc8_SNAPS','5974ba96-2740-11ef-8e09-d517f1736dc8.png','5974ba96-2740-11ef-8e09-d517f1736dc8','{\"displayTitle\":\"3.2 Analyse m1 [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-10 17:44:40.398','2024-06-10 15:44:40.400','2024-06-10 17:44:41.664'),('5998c3b0-2e0e-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/ce57500b-227c-11ef-8d76-d310d2ec2c14/session_da355fe4-227c-11ef-8d76-d310d2ec2c14/occlusion_da37d213-227c-11ef-8d76-d310d2ec2c14/scan_e0f66733-227c-11ef-8d76-d310d2ec2c14/5998c3b0-2e0e-11ef-8deb-d515ea58f6cb.ply','PATIENT_ce57500b-227c-11ef-8d76-d310d2ec2c14_ACT_da355fe4-227c-11ef-8d76-d310d2ec2c14_SESS_da37d213-227c-11ef-8d76-d310d2ec2c14_TOSC_e0f66733-227c-11ef-8d76-d310d2ec2c14_SEG','5998c3b0-2e0e-11ef-8deb-d515ea58f6cb.ply','5998c3b0-2e0e-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"3.1 Maxillaire u1 Segmentation [pc2]\"}','PLY',0,'CREATED',0,'2024-06-19 09:34:40.192','2024-06-19 09:34:40.192','2024-06-19 07:34:40.193',NULL),('5ac77cab-233a-11ef-8f93-d92a45da78c9',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/computedocclusion_a2829ff3-2338-11ef-8f93-d92a45da78c9/5ac77cab-233a-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_OCC_a2829ff3-2338-11ef-8f93-d92a45da78c9_TO2','5ac77cab-233a-11ef-8f93-d92a45da78c9.zip','5ac77cab-233a-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Occlusion o1 Maxillaire u2 [pc1]\",\"modelMatrix\":\"-0.923468,0.0376561,-0.381824,0,-0.158116,-0.944087,0.289308,0,-0.349581,0.327539,0.877788,0,12.8471,-2.21044,-5.73295,1\",\"occlusionMatrix\":\"0.961831,0.149468,-0.231582,0,0.27256,-0.433127,0.858711,0,0.0250048,-0.888866,-0.457158,0,-15.4994,3.62291,10.3073,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.5_u2\",\"referenceScanId\":\"2e146f3d-233a-11ef-8f93-d92a45da78c9\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-05 14:51:44.000','2024-06-05 12:51:44.000','2024-06-05 14:51:44.000'),('5adbc9bc-2278-11ef-8d76-d310d2ec2c14',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/computedocclusion_9ed6352b-2277-11ef-8d76-d310d2ec2c14/5adbc9bc-2278-11ef-8d76-d310d2ec2c14.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_OCC_9ed6352b-2277-11ef-8d76-d310d2ec2c14_TO1','5adbc9bc-2278-11ef-8d76-d310d2ec2c14.zip','5adbc9bc-2278-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Occlusion o2 Maxillaire u1 [pc2]\",\"modelMatrix\":\"-0.0834467,0.986107,-0.143628,0,-0.981709,-0.1061,-0.158085,0,-0.171128,0.12781,0.976924,0,-17.1278,-28.7907,-11.2181,1\",\"occlusionMatrix\":\"-0.0834467,0.143628,0.986107,0,-0.981709,0.158085,-0.1061,0,-0.171128,-0.976924,0.12781,0,-17.1278,11.2181,-28.7907,1\",\"occlusionType\":5,\"referenceScanFullDisplayId\":\"1.2_u1\",\"referenceScanId\":\"f3b0649e-2272-11ef-8d76-d310d2ec2c14\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 15:43:01.000','2024-06-04 13:43:01.000','2024-06-04 15:43:01.000'),('5b0decc4-2278-11ef-8d76-d310d2ec2c14',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/computedocclusion_9ed6352b-2277-11ef-8d76-d310d2ec2c14/5b0decc4-2278-11ef-8d76-d310d2ec2c14.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_OCC_9ed6352b-2277-11ef-8d76-d310d2ec2c14_BO1','5b0decc4-2278-11ef-8d76-d310d2ec2c14.zip','5b0decc4-2278-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Occlusion o2 Mandibule l1 [pc2]\",\"modelMatrix\":\"0.135656,-0.982642,-0.126536,0,0.970104,0.157682,-0.184485,0,0.201235,-0.0977264,0.974656,0,-23.8369,18.6095,-10.139,1\",\"occlusionMatrix\":\"-0.17691,-0.163102,0.970622,0,0.978966,-0.130988,0.156421,0,0.101627,0.977872,0.182845,0,-18.8406,-1.18887,-25.0133,1\",\"occlusionType\":5,\"referenceScanFullDisplayId\":\"1.2_l1\",\"referenceScanId\":\"96d08283-2273-11ef-8d76-d310d2ec2c14\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 15:43:02.000','2024-06-04 13:43:02.000','2024-06-04 15:43:02.000'),('5b6e5c2b-2e0d-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/4382037a-2735-11ef-8e16-d517f37fa1ab/session_be9a8e99-2735-11ef-8e16-d517f37fa1ab/occlusion_be9c5752-2735-11ef-8e16-d517f37fa1ab/scan_bfa3d876-2735-11ef-8e16-d517f37fa1ab/5b6e5c2b-2e0d-11ef-8deb-d515ea58f6cb.zip','PATIENT_4382037a-2735-11ef-8e16-d517f37fa1ab_ACT_be9a8e99-2735-11ef-8e16-d517f37fa1ab_SESS_be9c5752-2735-11ef-8e16-d517f37fa1ab_TOSC_bfa3d876-2735-11ef-8e16-d517f37fa1ab_MODEL','5b6e5c2b-2e0d-11ef-8deb-d515ea58f6cb.zip','e1412689-2735-11ef-8e16-d517f37fa1ab','{\"displayTitle\":\"6.1 Maxillaire u1 [pc2]\",\"modelMatrix\":\"-0.479814,-0.110653,0.870364,0,-0.0586755,0.993841,0.0940049,0,-0.875406,-0.00596416,-0.483352,0,21.2778,2.84273,-5.93875,1\",\"scanBodies\":[],\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":3,\"socleIsFullArch\":true,\"socleThickness\":-1,\"socleType\":1}','ZIP',1,'SYNCED',0,NULL,'2024-06-19 09:27:18.163','2024-06-19 07:27:18.214','2024-06-19 12:49:18.976'),('5bc001f1-2278-11ef-8d76-d310d2ec2c14',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/computedocclusion_9ed6352b-2277-11ef-8d76-d310d2ec2c14/5bc001f1-2278-11ef-8d76-d310d2ec2c14.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_OCC_9ed6352b-2277-11ef-8d76-d310d2ec2c14_SNAPO','5bc001f1-2278-11ef-8d76-d310d2ec2c14.png','5bc001f1-2278-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Occlusion o2 [pc2]\",\"occlusionType\":5}','PNG',0,'SYNCED',0,NULL,'2024-06-04 15:43:02.000','2024-06-04 13:43:02.000','2024-06-04 15:43:02.000'),('5bd68def-2272-11ef-8d76-d310d2ec2c14',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_62b97c61-226c-11ef-8d76-d310d2ec2c14/occlusion_62bbada3-226c-11ef-8d76-d310d2ec2c14/scan_389889a4-2272-11ef-8d76-d310d2ec2c14/5bd68def-2272-11ef-8d76-d310d2ec2c14.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_62b97c61-226c-11ef-8d76-d310d2ec2c14_SESS_62bbada3-226c-11ef-8d76-d310d2ec2c14_TOSC_389889a4-2272-11ef-8d76-d310d2ec2c14_MODEL','5bd68def-2272-11ef-8d76-d310d2ec2c14.zip','5bd68def-2272-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.1 Maxillaire u1 [pc2]\",\"modelMatrix\":\"0.901424,-0.415146,-0.12284,0,0.404409,0.908712,-0.10342,0,0.154561,0.0435476,0.987023,0,-9.88483,-1.72313,-15.441,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 15:00:06.000','2024-06-04 13:00:06.000','2024-06-04 15:00:06.000'),('5bd6a4c3-2272-11ef-8d76-d310d2ec2c14',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_62b97c61-226c-11ef-8d76-d310d2ec2c14/occlusion_62bbada3-226c-11ef-8d76-d310d2ec2c14/scan_389889a4-2272-11ef-8d76-d310d2ec2c14/5bd6a4c3-2272-11ef-8d76-d310d2ec2c14.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_62b97c61-226c-11ef-8d76-d310d2ec2c14_SESS_62bbada3-226c-11ef-8d76-d310d2ec2c14_TOSC_389889a4-2272-11ef-8d76-d310d2ec2c14_SNAPS','5bd6a4c3-2272-11ef-8d76-d310d2ec2c14.png','5bd6a4c3-2272-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.1 Maxillaire u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 15:00:07.000','2024-06-04 13:00:07.000','2024-06-04 15:00:07.000'),('5c16705b-2e3c-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_da1f6873-2e3a-11ef-8deb-d515ea58f6cb/order_da257486-2e3a-11ef-8deb-d515ea58f6cb/5c16705b-2e3c-11ef-8deb-d515ea58f6cb.pdf','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_da1f6873-2e3a-11ef-8deb-d515ea58f6cb_PROST_da257486-2e3a-11ef-8deb-d515ea58f6cb_FORM','5c16705b-2e3c-11ef-8deb-d515ea58f6cb.pdf','5c16705b-2e3c-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.2 Crown [pc2]\",\"title\":\"Crown\"}','PDF',0,'SYNCED',0,NULL,'2024-06-19 15:03:47.000','2024-06-19 13:03:47.000','2024-06-19 15:03:47.000'),('5f8fef48-233c-11ef-8f93-d92a45da78c9',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/computedocclusion_a2829ff3-2338-11ef-8f93-d92a45da78c9/5f8fef48-233c-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_OCC_a2829ff3-2338-11ef-8f93-d92a45da78c9_BO3','5f8fef48-233c-11ef-8f93-d92a45da78c9.zip','5f8fef48-233c-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Occlusion o1 Mandibule l2 [pc1]\",\"modelMatrix\":\"0.912405,-0.408985,0.0157505,0,0.408648,0.908152,-0.0909209,0,0.0228815,0.0893931,0.995733,0,-14.1029,6.9381,-10.6228,1\",\"occlusionMatrix\":\"0.978507,0.00506089,-0.206415,0,-0.206059,-0.0415388,-0.977659,0,-0.0100391,0.99914,-0.0397965,0,-17.2945,-6.52181,8.79408,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.5_l2\",\"referenceScanId\":\"596c4e98-233c-11ef-8f93-d92a45da78c9\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-05 15:06:12.000','2024-06-05 13:06:12.000','2024-06-05 15:06:12.000'),('5fc0481a-233c-11ef-8f93-d92a45da78c9',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/computedocclusion_a2829ff3-2338-11ef-8f93-d92a45da78c9/5fc0481a-233c-11ef-8f93-d92a45da78c9.xyz','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_OCC_a2829ff3-2338-11ef-8f93-d92a45da78c9_LIFIO','5fc0481a-233c-11ef-8f93-d92a45da78c9.xyz','5fc0481a-233c-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Occlusion o1 Mandibule l2 Ligne de finition auto [pc1]\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MANDIBLE_3\",\"referenceScanFullDisplayId\":\"1.5_l2\",\"referenceScanId\":\"596c4e98-233c-11ef-8f93-d92a45da78c9\",\"title\":\"auto\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-05 15:06:13.000','2024-06-05 13:06:13.000','2024-06-05 15:06:13.000'),('5fc04dc7-233c-11ef-8f93-d92a45da78c9',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/computedocclusion_a2829ff3-2338-11ef-8f93-d92a45da78c9/5fc04dc7-233c-11ef-8f93-d92a45da78c9.bin','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_OCC_a2829ff3-2338-11ef-8f93-d92a45da78c9_LIFIMO','5fc04dc7-233c-11ef-8f93-d92a45da78c9.bin','5fc04dc7-233c-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Occlusion o1 Mandibule l2 Ligne de finition métadonnées auto [pc1]\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MANDIBLE_3\",\"referenceScanFullDisplayId\":\"1.5_l2\",\"referenceScanId\":\"596c4e98-233c-11ef-8f93-d92a45da78c9\",\"title\":\"auto\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-05 15:06:13.000','2024-06-05 13:06:13.000','2024-06-05 15:06:13.000'),('5fe3c6fc-233b-11ef-8f93-d92a45da78c9',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_2e146f3d-233a-11ef-8f93-d92a45da78c9/5fe3c6fc-233b-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_TOSC_2e146f3d-233a-11ef-8f93-d92a45da78c9_MODEL','5fe3c6fc-233b-11ef-8f93-d92a45da78c9.zip','2e1492f1-233a-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Maxillaire u2 [pc1]\",\"modelMatrix\":\"0.989237,-0.120037,-0.0836717,0,0.114747,0.991239,-0.0654089,0,0.0907902,0.0551039,0.994344,0,-9.57663,-0.954263,-9.009,1\",\"scanBodies\":[]}','ZIP',5,'SYNCED',0,NULL,'2024-06-05 14:59:00.000','2024-06-05 12:59:00.000','2024-06-05 14:59:00.000'),('613c6795-2278-11ef-8d76-d310d2ec2c14',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/computedocclusion_9ed6352b-2277-11ef-8d76-d310d2ec2c14/613c6795-2278-11ef-8d76-d310d2ec2c14.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_OCC_9ed6352b-2277-11ef-8d76-d310d2ec2c14_BO1','613c6795-2278-11ef-8d76-d310d2ec2c14.zip','5b0decc4-2278-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Occlusion o2 Mandibule l1 [pc2]\",\"modelMatrix\":\"0.135656,-0.982642,-0.126536,0,0.970104,0.157682,-0.184485,0,0.201235,-0.0977264,0.974656,0,-23.8369,18.6095,-10.139,1\",\"occlusionMatrix\":\"-0.177722,-0.165589,0.970054,0,0.976211,-0.154065,0.152557,0,0.124189,0.974083,0.189032,0,-19.034,-0.222657,-25.1768,1\",\"occlusionType\":5,\"referenceScanFullDisplayId\":\"1.2_l1\",\"referenceScanId\":\"96d08283-2273-11ef-8d76-d310d2ec2c14\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2024-06-04 15:43:11.000','2024-06-04 13:43:11.000','2024-06-04 15:43:11.000'),('62387fc2-2e36-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_3654e763-2e35-11ef-8deb-d515ea58f6cb/occlusion_36556270-2e35-11ef-8deb-d515ea58f6cb/scan_1e568150-2e36-11ef-8deb-d515ea58f6cb/62387fc2-2e36-11ef-8deb-d515ea58f6cb.ply','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_3654e763-2e35-11ef-8deb-d515ea58f6cb_SESS_36556270-2e35-11ef-8deb-d515ea58f6cb_BOSC_1e568150-2e36-11ef-8deb-d515ea58f6cb_SEG','62387fc2-2e36-11ef-8deb-d515ea58f6cb.ply','62387fc2-2e36-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.1 Mandibola l1 Segmentazione [pc2]\"}','PLY',0,'SYNCED',0,NULL,'2024-06-19 14:20:58.920','2024-06-19 12:20:58.947','2024-06-19 14:20:59.385'),('62490a02-2e4b-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/115617bc-2e4b-11ef-8deb-d515ea58f6cb/session_15f71dc7-2e4b-11ef-8deb-d515ea58f6cb/occlusion_15f94c3c-2e4b-11ef-8deb-d515ea58f6cb/scan_4155dabe-2e4b-11ef-8deb-d515ea58f6cb/62490a02-2e4b-11ef-8deb-d515ea58f6cb.zip','PATIENT_115617bc-2e4b-11ef-8deb-d515ea58f6cb_ACT_15f71dc7-2e4b-11ef-8deb-d515ea58f6cb_SESS_15f94c3c-2e4b-11ef-8deb-d515ea58f6cb_BOSC_4155dabe-2e4b-11ef-8deb-d515ea58f6cb_MODEL','62490a02-2e4b-11ef-8deb-d515ea58f6cb.zip','62490a02-2e4b-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"17.1 Mandible l1 [pc2]\",\"modelMatrix\":\"0.997464,0.0588169,0.0400726,0,-0.0389825,0.92259,-0.383808,0,-0.059545,0.381273,0.922543,0,7.78707,3.45972,-13.4277,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-19 16:51:21.000','2024-06-19 14:51:21.000','2024-06-19 16:51:21.000'),('624917e7-2e4b-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/115617bc-2e4b-11ef-8deb-d515ea58f6cb/session_15f71dc7-2e4b-11ef-8deb-d515ea58f6cb/occlusion_15f94c3c-2e4b-11ef-8deb-d515ea58f6cb/scan_4155dabe-2e4b-11ef-8deb-d515ea58f6cb/624917e7-2e4b-11ef-8deb-d515ea58f6cb.png','PATIENT_115617bc-2e4b-11ef-8deb-d515ea58f6cb_ACT_15f71dc7-2e4b-11ef-8deb-d515ea58f6cb_SESS_15f94c3c-2e4b-11ef-8deb-d515ea58f6cb_BOSC_4155dabe-2e4b-11ef-8deb-d515ea58f6cb_SNAPS','624917e7-2e4b-11ef-8deb-d515ea58f6cb.png','624917e7-2e4b-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"17.1 Mandible l1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-19 16:51:22.000','2024-06-19 14:51:22.000','2024-06-19 16:51:22.000'),('62cceaa8-2e0e-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/ce57500b-227c-11ef-8d76-d310d2ec2c14/session_da355fe4-227c-11ef-8d76-d310d2ec2c14/occlusion_da37d213-227c-11ef-8d76-d310d2ec2c14/scan_e0f66733-227c-11ef-8d76-d310d2ec2c14/62cceaa8-2e0e-11ef-8deb-d515ea58f6cb.zip','PATIENT_ce57500b-227c-11ef-8d76-d310d2ec2c14_ACT_da355fe4-227c-11ef-8d76-d310d2ec2c14_SESS_da37d213-227c-11ef-8d76-d310d2ec2c14_TOSC_e0f66733-227c-11ef-8d76-d310d2ec2c14_MODEL','62cceaa8-2e0e-11ef-8deb-d515ea58f6cb.zip','f51d71ce-227c-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"3.1 Maxillaire u1 [pc2]\",\"modelMatrix\":\"-0.590223,0.739255,-0.324251,0,-0.781697,-0.423166,0.458127,0,0.201461,0.523863,0.827636,0,-1.54469,-10.1967,-10.1611,1\",\"scanBodies\":[{\"position\":\"4.62786,6,0,0,-4.60181,0,6,0,8.70585,0,0,6,1,0,0,0\",\"reference\":\"K30PSCANPLG\",\"tid\":14}]}','ZIP',1,'SYNCED',0,NULL,'2024-06-19 09:34:40.024','2024-06-19 07:34:40.081','2024-06-19 12:49:19.871'),('639f7d1c-2e43-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/4382037a-2735-11ef-8e16-d517f37fa1ab/session_164199d1-2e43-11ef-8deb-d515ea58f6cb/occlusion_1643d04c-2e43-11ef-8deb-d515ea58f6cb/scan_1793bd69-2e43-11ef-8deb-d515ea58f6cb/639f7d1c-2e43-11ef-8deb-d515ea58f6cb.zip','PATIENT_4382037a-2735-11ef-8e16-d517f37fa1ab_ACT_164199d1-2e43-11ef-8deb-d515ea58f6cb_SESS_1643d04c-2e43-11ef-8deb-d515ea58f6cb_TOSC_1793bd69-2e43-11ef-8deb-d515ea58f6cb_MODEL','639f7d1c-2e43-11ef-8deb-d515ea58f6cb.zip','639f7d1c-2e43-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"6.5 Maxilla u1 [pc2]\",\"modelMatrix\":\"-0.393408,-0.919196,-0.0175964,0,0.913623,-0.388744,-0.11904,0,0.10258,-0.0629077,0.992734,0,14.69,4.11726,-13.7656,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-19 15:54:10.000','2024-06-19 13:54:10.000','2024-06-19 15:54:10.000'),('639fcb29-2e43-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/4382037a-2735-11ef-8e16-d517f37fa1ab/session_164199d1-2e43-11ef-8deb-d515ea58f6cb/occlusion_1643d04c-2e43-11ef-8deb-d515ea58f6cb/scan_1793bd69-2e43-11ef-8deb-d515ea58f6cb/639fcb29-2e43-11ef-8deb-d515ea58f6cb.png','PATIENT_4382037a-2735-11ef-8e16-d517f37fa1ab_ACT_164199d1-2e43-11ef-8deb-d515ea58f6cb_SESS_1643d04c-2e43-11ef-8deb-d515ea58f6cb_TOSC_1793bd69-2e43-11ef-8deb-d515ea58f6cb_SNAPS','639fcb29-2e43-11ef-8deb-d515ea58f6cb.png','639fcb29-2e43-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"6.5 Maxilla u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-19 15:54:11.000','2024-06-19 13:54:11.000','2024-06-19 15:54:11.000'),('6461ca85-2269-11ef-8f1f-d8242c71b430',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_757ed4bc-2266-11ef-8f1f-d8242c71b430/occlusion_75806ee1-2266-11ef-8f1f-d8242c71b430/computedocclusion_0b16efeb-2268-11ef-8f1f-d8242c71b430/6461ca85-2269-11ef-8f1f-d8242c71b430.xyz','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_OCC_0b16efeb-2268-11ef-8f1f-d8242c71b430_LIFIO','6461ca85-2269-11ef-8f1f-d8242c71b430.xyz','1b66dafd-2269-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.2 Occlusion o1 Maxillaire u1 Ligne de finition auto\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY_1\",\"referenceScanFullDisplayId\":\"1.2_u1\",\"referenceScanId\":\"09768650-2267-11ef-8f1f-d8242c71b430\",\"title\":\"auto\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',1,'SYNCED',0,NULL,'2024-06-04 13:55:53.000','2024-06-04 11:55:53.000','2024-06-04 13:55:53.000'),('6461d309-2269-11ef-8f1f-d8242c71b430',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_757ed4bc-2266-11ef-8f1f-d8242c71b430/occlusion_75806ee1-2266-11ef-8f1f-d8242c71b430/computedocclusion_0b16efeb-2268-11ef-8f1f-d8242c71b430/6461d309-2269-11ef-8f1f-d8242c71b430.bin','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_OCC_0b16efeb-2268-11ef-8f1f-d8242c71b430_LIFIMO','6461d309-2269-11ef-8f1f-d8242c71b430.bin','1b66de9f-2269-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.2 Occlusion o1 Maxillaire u1 Ligne de finition métadonnées auto\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY_1\",\"referenceScanFullDisplayId\":\"1.2_u1\",\"referenceScanId\":\"09768650-2267-11ef-8f1f-d8242c71b430\",\"title\":\"auto\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',1,'SYNCED',0,NULL,'2024-06-04 13:55:53.000','2024-06-04 11:55:53.000','2024-06-04 13:55:53.000'),('6487d4c6-2964-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_4704a021-2963-11ef-8e16-d517f37fa2ad/occlusion_4706df6f-2963-11ef-8e16-d517f37fa2ad/scan_47f95341-2963-11ef-8e16-d517f37fa2ad/6487d4c6-2964-11ef-8e16-d517f37fa2ad.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_4704a021-2963-11ef-8e16-d517f37fa2ad_SESS_4706df6f-2963-11ef-8e16-d517f37fa2ad_TOSC_47f95341-2963-11ef-8e16-d517f37fa2ad_MODEL','6487d4c6-2964-11ef-8e16-d517f37fa2ad.zip','6487d4c6-2964-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.1 Mascella u1\",\"modelMatrix\":\"0.432825,-0.89967,-0.0570733,0,0.880417,0.43547,-0.187701,0,0.193722,0.0309933,0.980567,0,-23.5715,9.30099,-17.1386,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 11:07:54.000','2024-06-13 09:07:54.000','2024-06-13 11:07:54.000'),('64880729-2964-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_4704a021-2963-11ef-8e16-d517f37fa2ad/occlusion_4706df6f-2963-11ef-8e16-d517f37fa2ad/scan_47f95341-2963-11ef-8e16-d517f37fa2ad/64880729-2964-11ef-8e16-d517f37fa2ad.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_4704a021-2963-11ef-8e16-d517f37fa2ad_SESS_4706df6f-2963-11ef-8e16-d517f37fa2ad_TOSC_47f95341-2963-11ef-8e16-d517f37fa2ad_SNAPS','64880729-2964-11ef-8e16-d517f37fa2ad.png','64880729-2964-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.1 Mascella u1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 11:07:55.000','2024-06-13 09:07:55.000','2024-06-13 11:07:55.000'),('64ad4973-296f-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_8e81ab09-296b-11ef-8e16-d517f37fa2ad/occlusion_8e83509f-296b-11ef-8e16-d517f37fa2ad/scan_45dedff3-296f-11ef-8e16-d517f37fa2ad/64ad4973-296f-11ef-8e16-d517f37fa2ad.zip','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_SESS_8e83509f-296b-11ef-8e16-d517f37fa2ad_RISC_45dedff3-296f-11ef-8e16-d517f37fa2ad_MODEL','64ad4973-296f-11ef-8e16-d517f37fa2ad.zip','64ad4973-296f-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Morso destro br1\",\"modelMatrix\":\"0.994703,-0.0919525,-0.0440604,0,0.0896301,0.993497,-0.0718281,0,0.0503254,0.0671531,0.996444,0,-1.00093,4.41228,-15.857,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 12:26:27.896','2024-06-13 10:26:28.209','2024-06-13 12:26:33.070'),('64ad5fec-296f-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_8e81ab09-296b-11ef-8e16-d517f37fa2ad/occlusion_8e83509f-296b-11ef-8e16-d517f37fa2ad/scan_45dedff3-296f-11ef-8e16-d517f37fa2ad/64ad5fec-296f-11ef-8e16-d517f37fa2ad.png','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_SESS_8e83509f-296b-11ef-8e16-d517f37fa2ad_RISC_45dedff3-296f-11ef-8e16-d517f37fa2ad_SNAPS','64ad5fec-296f-11ef-8e16-d517f37fa2ad.png','64ad5fec-296f-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Morso destro br1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 12:26:27.896','2024-06-13 10:26:28.210','2024-06-13 12:26:33.367'),('66bc3d46-2272-11ef-8d76-d310d2ec2c14',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_62b97c61-226c-11ef-8d76-d310d2ec2c14/order_62bf4a87-226c-11ef-8d76-d310d2ec2c14/66bc3d46-2272-11ef-8d76-d310d2ec2c14.pdf','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_62b97c61-226c-11ef-8d76-d310d2ec2c14_PROST_62bf4a87-226c-11ef-8d76-d310d2ec2c14_FORM','66bc3d46-2272-11ef-8d76-d310d2ec2c14.pdf','66bc3d46-2272-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.1 fait sous env2 [pc2]\",\"title\":\"fait sous env2\"}','PDF',0,'SYNCED',0,NULL,'2024-06-04 15:00:21.700','2024-06-04 13:00:22.480','2024-06-04 15:00:22.615'),('672ce220-2a29-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_72b8db7f-2a20-11ef-8f1c-d8242c6fa8fd/occlusion_72bbb4c0-2a20-11ef-8f1c-d8242c6fa8fd/scan_ef33e0e4-2a28-11ef-8f1c-d8242c6fa8fd/672ce220-2a29-11ef-8f1c-d8242c6fa8fd.ply','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_72b8db7f-2a20-11ef-8f1c-d8242c6fa8fd_SESS_72bbb4c0-2a20-11ef-8f1c-d8242c6fa8fd_TOSC_ef33e0e4-2a28-11ef-8f1c-d8242c6fa8fd_SEG','672ce220-2a29-11ef-8f1c-d8242c6fa8fd.ply','672ce220-2a29-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.1 Mascella u3 Segmentazione\"}','PLY',0,'SYNCED',0,'2024-06-14 10:38:33.383','2024-06-14 10:37:59.999','2024-06-14 08:38:33.384','2024-06-14 10:38:33.413'),('6751aadf-2e36-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_3654e763-2e35-11ef-8deb-d515ea58f6cb/occlusion_36556270-2e35-11ef-8deb-d515ea58f6cb/scan_1e568150-2e36-11ef-8deb-d515ea58f6cb/6751aadf-2e36-11ef-8deb-d515ea58f6cb.xyz','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_3654e763-2e35-11ef-8deb-d515ea58f6cb_SESS_36556270-2e35-11ef-8deb-d515ea58f6cb_BOSC_1e568150-2e36-11ef-8deb-d515ea58f6cb_LIFI','6751aadf-2e36-11ef-8deb-d515ea58f6cb.xyz','6751aadf-2e36-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.1 Mandibola l1 Linea di finitura 0 [pc2]\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-19 14:21:07.474','2024-06-19 12:21:07.480','2024-06-19 14:21:07.772'),('6751bb01-2e36-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_3654e763-2e35-11ef-8deb-d515ea58f6cb/occlusion_36556270-2e35-11ef-8deb-d515ea58f6cb/scan_1e568150-2e36-11ef-8deb-d515ea58f6cb/6751bb01-2e36-11ef-8deb-d515ea58f6cb.bin','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_3654e763-2e35-11ef-8deb-d515ea58f6cb_SESS_36556270-2e35-11ef-8deb-d515ea58f6cb_BOSC_1e568150-2e36-11ef-8deb-d515ea58f6cb_LIFIM','6751bb01-2e36-11ef-8deb-d515ea58f6cb.bin','6751bb01-2e36-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.1 Mandibola l1 Linea di finitura dei metadati 0 [pc2]\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-19 14:21:07.474','2024-06-19 12:21:07.482','2024-06-19 14:21:07.993'),('6782502c-225b-11ef-8f1f-d8242c71b430',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_e3862d66-225a-11ef-8f1f-d8242c71b430/occlusion_e3868e5f-225a-11ef-8f1f-d8242c71b430/scan_37ccba29-225b-11ef-8f1f-d8242c71b430/6782502c-225b-11ef-8f1f-d8242c71b430.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_SESS_e3868e5f-225a-11ef-8f1f-d8242c71b430_BOSC_37ccba29-225b-11ef-8f1f-d8242c71b430_MODEL','6782502c-225b-11ef-8f1f-d8242c71b430.zip','6782502c-225b-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.1 Mandibule l1\",\"modelMatrix\":\"-0.728037,0.684478,-0.03811,0,-0.685353,-0.725423,0.0636657,0,0.0159319,0.0724698,0.997243,0,9.49558,-10.7,-12.9454,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 12:15:47.000','2024-06-04 10:15:47.000','2024-06-04 12:15:47.000'),('67825ce8-225b-11ef-8f1f-d8242c71b430',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_e3862d66-225a-11ef-8f1f-d8242c71b430/occlusion_e3868e5f-225a-11ef-8f1f-d8242c71b430/scan_37ccba29-225b-11ef-8f1f-d8242c71b430/67825ce8-225b-11ef-8f1f-d8242c71b430.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_SESS_e3868e5f-225a-11ef-8f1f-d8242c71b430_BOSC_37ccba29-225b-11ef-8f1f-d8242c71b430_SNAPS','67825ce8-225b-11ef-8f1f-d8242c71b430.png','67825ce8-225b-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.1 Mandibule l1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 12:15:47.000','2024-06-04 10:15:47.000','2024-06-04 12:15:47.000'),('68583fe2-296d-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_8e81ab09-296b-11ef-8e16-d517f37fa2ad/occlusion_8e83509f-296b-11ef-8e16-d517f37fa2ad/scan_3e566183-296d-11ef-8e16-d517f37fa2ad/68583fe2-296d-11ef-8e16-d517f37fa2ad.zip','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_SESS_8e83509f-296b-11ef-8e16-d517f37fa2ad_TOSC_3e566183-296d-11ef-8e16-d517f37fa2ad_MODEL','68583fe2-296d-11ef-8e16-d517f37fa2ad.zip','68583fe2-296d-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Mascella u2\",\"modelMatrix\":\"0.977833,0.199781,-0.0626841,0,-0.206197,0.866746,-0.454131,0,-0.0363956,0.456989,0.888727,0,17.9213,-1.83545,-14.643,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,'2024-06-13 12:12:27.918','2024-06-13 12:12:15.056','2024-06-13 10:12:27.919','2024-06-13 12:12:27.933'),('68584e1d-296d-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_8e81ab09-296b-11ef-8e16-d517f37fa2ad/occlusion_8e83509f-296b-11ef-8e16-d517f37fa2ad/scan_3e566183-296d-11ef-8e16-d517f37fa2ad/68584e1d-296d-11ef-8e16-d517f37fa2ad.png','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_SESS_8e83509f-296b-11ef-8e16-d517f37fa2ad_TOSC_3e566183-296d-11ef-8e16-d517f37fa2ad_SNAPS','68584e1d-296d-11ef-8e16-d517f37fa2ad.png','68584e1d-296d-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Mascella u2 Snapshot\"}','PNG',0,'CREATED',0,'2024-06-13 12:12:27.918','2024-06-13 12:12:15.056','2024-06-13 10:12:27.919','2024-06-13 12:12:27.934'),('68c717db-2e36-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_3654e763-2e35-11ef-8deb-d515ea58f6cb/occlusion_36556270-2e35-11ef-8deb-d515ea58f6cb/scan_1e568150-2e36-11ef-8deb-d515ea58f6cb/68c717db-2e36-11ef-8deb-d515ea58f6cb.xyz','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_3654e763-2e35-11ef-8deb-d515ea58f6cb_SESS_36556270-2e35-11ef-8deb-d515ea58f6cb_BOSC_1e568150-2e36-11ef-8deb-d515ea58f6cb_LIFI','68c717db-2e36-11ef-8deb-d515ea58f6cb.xyz','68c717db-2e36-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.1 Mandibola l1 Linea di finitura 1 [pc2]\",\"title\":\"1\",\"toothNumber\":1,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-19 14:21:09.921','2024-06-19 12:21:09.924','2024-06-19 14:21:10.292'),('68c71c8f-2e36-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_3654e763-2e35-11ef-8deb-d515ea58f6cb/occlusion_36556270-2e35-11ef-8deb-d515ea58f6cb/scan_1e568150-2e36-11ef-8deb-d515ea58f6cb/68c71c8f-2e36-11ef-8deb-d515ea58f6cb.bin','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_3654e763-2e35-11ef-8deb-d515ea58f6cb_SESS_36556270-2e35-11ef-8deb-d515ea58f6cb_BOSC_1e568150-2e36-11ef-8deb-d515ea58f6cb_LIFIM','68c71c8f-2e36-11ef-8deb-d515ea58f6cb.bin','68c71c8f-2e36-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.1 Mandibola l1 Linea di finitura dei metadati 1 [pc2]\",\"title\":\"1\",\"toothNumber\":1,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-19 14:21:09.921','2024-06-19 12:21:09.925','2024-06-19 14:21:10.743'),('6bce082f-296e-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_8e81ab09-296b-11ef-8e16-d517f37fa2ad/occlusion_8e83509f-296b-11ef-8e16-d517f37fa2ad/scan_890595a9-296d-11ef-8e16-d517f37fa2ad/6bce082f-296e-11ef-8e16-d517f37fa2ad.xyz','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_SESS_8e83509f-296b-11ef-8e16-d517f37fa2ad_TOSC_890595a9-296d-11ef-8e16-d517f37fa2ad_LIFI','6bce082f-296e-11ef-8e16-d517f37fa2ad.xyz','2e90e2b8-296e-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Mascella u3 Linea di finitura 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',1,'SYNCED',0,NULL,'2024-06-13 12:19:30.358','2024-06-13 10:19:30.362','2024-06-13 12:19:30.634'),('6bce11f4-296e-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_8e81ab09-296b-11ef-8e16-d517f37fa2ad/occlusion_8e83509f-296b-11ef-8e16-d517f37fa2ad/scan_890595a9-296d-11ef-8e16-d517f37fa2ad/6bce11f4-296e-11ef-8e16-d517f37fa2ad.bin','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_SESS_8e83509f-296b-11ef-8e16-d517f37fa2ad_TOSC_890595a9-296d-11ef-8e16-d517f37fa2ad_LIFIM','6bce11f4-296e-11ef-8e16-d517f37fa2ad.bin','2e90eaa9-296e-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Mascella u3 Linea di finitura dei metadati 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',1,'SYNCED',0,NULL,'2024-06-13 12:19:30.358','2024-06-13 10:19:30.367','2024-06-13 12:19:30.870'),('6c69f0d2-2a2c-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/scan_80540c46-2a2a-11ef-8f1c-d8242c6fa8fd/6c69f0d2-2a2c-11ef-8f1c-d8242c6fa8fd.png','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_BOSC_80540c46-2a2a-11ef-8f1c-d8242c6fa8fd_SCREENS','6c69f0d2-2a2c-11ef-8f1c-d8242c6fa8fd.png','6c69f0d2-2a2c-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Mandibola l1 Screenshot 1\",\"title\":\"1\"}','PNG',0,'SYNCED',0,NULL,'2024-06-14 10:59:37.278','2024-06-14 08:59:37.355','2024-06-14 10:59:37.768'),('6cab3c6f-298f-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_d703d726-298d-11ef-8e16-d517f37fa2ad/occlusion_d70636d7-298d-11ef-8e16-d517f37fa2ad/scan_2ed06b9e-298f-11ef-8e16-d517f37fa2ad/6cab3c6f-298f-11ef-8e16-d517f37fa2ad.zip','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_d703d726-298d-11ef-8e16-d517f37fa2ad_SESS_d70636d7-298d-11ef-8e16-d517f37fa2ad_TOSC_2ed06b9e-298f-11ef-8e16-d517f37fa2ad_MODEL','6cab3c6f-298f-11ef-8e16-d517f37fa2ad.zip','6cab3c6f-298f-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.2 Mascella u1\",\"modelMatrix\":\"0.975516,-0.148096,-0.162593,0,0.128141,0.983582,-0.127067,0,0.178742,0.103121,0.978477,0,-16.8719,-1.29266,-12.1772,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 16:15:45.199','2024-06-13 14:15:46.134','2024-06-13 16:15:48.359'),('6cab55f9-298f-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_d703d726-298d-11ef-8e16-d517f37fa2ad/occlusion_d70636d7-298d-11ef-8e16-d517f37fa2ad/scan_2ed06b9e-298f-11ef-8e16-d517f37fa2ad/6cab55f9-298f-11ef-8e16-d517f37fa2ad.png','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_d703d726-298d-11ef-8e16-d517f37fa2ad_SESS_d70636d7-298d-11ef-8e16-d517f37fa2ad_TOSC_2ed06b9e-298f-11ef-8e16-d517f37fa2ad_SNAPS','6cab55f9-298f-11ef-8e16-d517f37fa2ad.png','6cab55f9-298f-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.2 Mascella u1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 16:15:45.200','2024-06-13 14:15:46.143','2024-06-13 16:15:48.957'),('6d07ca5e-273a-11ef-8e16-d517f37fa1ab',2,'/var/.scan4all/iris/data/2024/2/520a1417-2735-11ef-8e16-d517f37fa1ab/session_54ecb28b-273a-11ef-8e16-d517f37fa1ab/occlusion_54eefd9c-273a-11ef-8e16-d517f37fa1ab/scan_56147bb3-273a-11ef-8e16-d517f37fa1ab/6d07ca5e-273a-11ef-8e16-d517f37fa1ab.zip','PATIENT_520a1417-2735-11ef-8e16-d517f37fa1ab_ACT_54ecb28b-273a-11ef-8e16-d517f37fa1ab_SESS_54eefd9c-273a-11ef-8e16-d517f37fa1ab_TOSC_56147bb3-273a-11ef-8e16-d517f37fa1ab_MODEL','6d07ca5e-273a-11ef-8e16-d517f37fa1ab.zip','6d07ca5e-273a-11ef-8e16-d517f37fa1ab','{\"displayTitle\":\"7.1 Maxillaire u1 [pc2]\",\"modelMatrix\":\"0.990806,-0.0240651,-0.133136,0,0.0214817,0.999553,-0.0208071,0,0.133578,0.0177558,0.990879,0,-4.06322,0.101113,-12.3306,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-10 17:02:16.258','2024-06-10 15:02:16.534','2024-06-10 17:02:19.083'),('6d07d7f7-273a-11ef-8e16-d517f37fa1ab',2,'/var/.scan4all/iris/data/2024/2/520a1417-2735-11ef-8e16-d517f37fa1ab/session_54ecb28b-273a-11ef-8e16-d517f37fa1ab/occlusion_54eefd9c-273a-11ef-8e16-d517f37fa1ab/scan_56147bb3-273a-11ef-8e16-d517f37fa1ab/6d07d7f7-273a-11ef-8e16-d517f37fa1ab.png','PATIENT_520a1417-2735-11ef-8e16-d517f37fa1ab_ACT_54ecb28b-273a-11ef-8e16-d517f37fa1ab_SESS_54eefd9c-273a-11ef-8e16-d517f37fa1ab_TOSC_56147bb3-273a-11ef-8e16-d517f37fa1ab_SNAPS','6d07d7f7-273a-11ef-8e16-d517f37fa1ab.png','6d07d7f7-273a-11ef-8e16-d517f37fa1ab','{\"displayTitle\":\"7.1 Maxillaire u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-10 17:02:16.259','2024-06-10 15:02:16.535','2024-06-10 17:02:21.169'),('6d75c326-233f-11ef-8f93-d92a45da78c9',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/order_b19eef4f-2336-11ef-8f93-d92a45da78c9/6d75c326-233f-11ef-8f93-d92a45da78c9.pdf','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_PROST_b19eef4f-2336-11ef-8f93-d92a45da78c9_FORM','6d75c326-233f-11ef-8f93-d92a45da78c9.pdf','6d75c326-233f-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Facette [pc1]\",\"title\":\"Facette\"}','PDF',0,'SYNCED',0,NULL,'2024-06-05 15:28:02.000','2024-06-05 13:28:02.000','2024-06-05 15:28:02.000'),('6e99d7a2-2274-11ef-8d76-d310d2ec2c14',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/scan_4501387b-2274-11ef-8d76-d310d2ec2c14/6e99d7a2-2274-11ef-8d76-d310d2ec2c14.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_LESC_4501387b-2274-11ef-8d76-d310d2ec2c14_MODEL','6e99d7a2-2274-11ef-8d76-d310d2ec2c14.zip','6e99d7a2-2274-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Mordu gauche bl1 [pc2]\",\"modelMatrix\":\"-0.998816,0.0403782,0.0195032,0,-0.0430572,-0.999181,0.00208862,0,0.0230753,0.00628218,0.999826,0,7.12513,-3.06097,-12.6228,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 15:16:11.000','2024-06-04 13:16:11.000','2024-06-04 15:16:11.000'),('6e99ed86-2274-11ef-8d76-d310d2ec2c14',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/scan_4501387b-2274-11ef-8d76-d310d2ec2c14/6e99ed86-2274-11ef-8d76-d310d2ec2c14.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_LESC_4501387b-2274-11ef-8d76-d310d2ec2c14_SNAPS','6e99ed86-2274-11ef-8d76-d310d2ec2c14.png','6e99ed86-2274-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Mordu gauche bl1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 15:16:11.000','2024-06-04 13:16:11.000','2024-06-04 15:16:11.000'),('6f42baa5-28a0-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/f373c86a-2899-11ef-8e16-d517f37fa2ad/session_0d1289f0-289a-11ef-8e16-d517f37fa2ad/order_e387023b-289f-11ef-8e16-d517f37fa2ad/6f42baa5-28a0-11ef-8e16-d517f37fa2ad.pdf','PATIENT_f373c86a-2899-11ef-8e16-d517f37fa2ad_ACT_0d1289f0-289a-11ef-8e16-d517f37fa2ad_PROST_e387023b-289f-11ef-8e16-d517f37fa2ad_FORM','6f42baa5-28a0-11ef-8e16-d517f37fa2ad.pdf','6f42baa5-28a0-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Guide\",\"title\":\"Guide\"}','PDF',0,'SYNCED',0,NULL,'2024-06-12 11:45:01.000','2024-06-12 09:45:01.000','2024-06-12 11:45:01.000'),('6fd045fb-2e3d-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_af857ecd-27f1-11ef-8e37-d519fa9d22d2/occlusion_af864e86-27f1-11ef-8e37-d519fa9d22d2/scan_3447447c-2e3d-11ef-8deb-d515ea58f6cb/6fd045fb-2e3d-11ef-8deb-d515ea58f6cb.zip','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_af857ecd-27f1-11ef-8e37-d519fa9d22d2_SESS_af864e86-27f1-11ef-8e37-d519fa9d22d2_BOSC_3447447c-2e3d-11ef-8deb-d515ea58f6cb_MODEL','6fd045fb-2e3d-11ef-8deb-d515ea58f6cb.zip','6fd045fb-2e3d-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.4 Mandible l1 [pc2]\",\"modelMatrix\":\"0.974595,-0.188287,-0.121294,0,0.179816,0.980646,-0.0774588,0,0.133531,0.0536805,0.98959,0,-17.8383,2.10993,-10.7575,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-19 15:11:28.202','2024-06-19 13:19:00.381','2024-06-19 15:19:01.598'),('6fd05373-2e3d-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_af857ecd-27f1-11ef-8e37-d519fa9d22d2/occlusion_af864e86-27f1-11ef-8e37-d519fa9d22d2/scan_3447447c-2e3d-11ef-8deb-d515ea58f6cb/6fd05373-2e3d-11ef-8deb-d515ea58f6cb.png','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_af857ecd-27f1-11ef-8e37-d519fa9d22d2_SESS_af864e86-27f1-11ef-8e37-d519fa9d22d2_BOSC_3447447c-2e3d-11ef-8deb-d515ea58f6cb_SNAPS','6fd05373-2e3d-11ef-8deb-d515ea58f6cb.png','6fd05373-2e3d-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.4 Mandible l1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-19 15:11:28.202','2024-06-19 13:19:00.382','2024-06-19 15:19:03.558'),('705bde7d-27cb-11ef-8e37-d519fa9d22d2',2,'/var/.scan4all/iris/data/2024/2/3573ee42-27cb-11ef-8e37-d519fa9d22d2/session_46997caf-27cb-11ef-8e37-d519fa9d22d2/occlusion_469bda30-27cb-11ef-8e37-d519fa9d22d2/scan_479072c7-27cb-11ef-8e37-d519fa9d22d2/705bde7d-27cb-11ef-8e37-d519fa9d22d2.zip','PATIENT_3573ee42-27cb-11ef-8e37-d519fa9d22d2_ACT_46997caf-27cb-11ef-8e37-d519fa9d22d2_SESS_469bda30-27cb-11ef-8e37-d519fa9d22d2_TOSC_479072c7-27cb-11ef-8e37-d519fa9d22d2_MODEL','705bde7d-27cb-11ef-8e37-d519fa9d22d2.zip','705bde7d-27cb-11ef-8e37-d519fa9d22d2','{\"displayTitle\":\"13.1 Maxillaire u1 [pc2]\",\"modelMatrix\":\"0.87087,0.475507,-0.124416,0,-0.452476,0.676732,-0.580775,0,-0.191966,0.562074,0.804501,0,4.02446,-6.35338,-10.8268,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-11 10:20:18.869','2024-06-11 08:20:19.181','2024-06-11 10:20:22.021'),('705bfbda-27cb-11ef-8e37-d519fa9d22d2',2,'/var/.scan4all/iris/data/2024/2/3573ee42-27cb-11ef-8e37-d519fa9d22d2/session_46997caf-27cb-11ef-8e37-d519fa9d22d2/occlusion_469bda30-27cb-11ef-8e37-d519fa9d22d2/scan_479072c7-27cb-11ef-8e37-d519fa9d22d2/705bfbda-27cb-11ef-8e37-d519fa9d22d2.png','PATIENT_3573ee42-27cb-11ef-8e37-d519fa9d22d2_ACT_46997caf-27cb-11ef-8e37-d519fa9d22d2_SESS_469bda30-27cb-11ef-8e37-d519fa9d22d2_TOSC_479072c7-27cb-11ef-8e37-d519fa9d22d2_SNAPS','705bfbda-27cb-11ef-8e37-d519fa9d22d2.png','705bfbda-27cb-11ef-8e37-d519fa9d22d2','{\"displayTitle\":\"13.1 Maxillaire u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-11 10:20:18.869','2024-06-11 08:20:19.182','2024-06-11 10:20:24.064'),('717ad3ef-2985-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_a8885309-2984-11ef-8e16-d517f37fa2ad/occlusion_a888b842-2984-11ef-8e16-d517f37fa2ad/scan_4a3afb31-2985-11ef-8e16-d517f37fa2ad/717ad3ef-2985-11ef-8e16-d517f37fa2ad.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_a8885309-2984-11ef-8e16-d517f37fa2ad_SESS_a888b842-2984-11ef-8e16-d517f37fa2ad_LESC_4a3afb31-2985-11ef-8e16-d517f37fa2ad_MODEL','717ad3ef-2985-11ef-8e16-d517f37fa2ad.zip','717ad3ef-2985-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.7 Morso sinistro bl1\",\"modelMatrix\":\"-0.99422,-0.0444996,-0.100417,0,0.0287617,-0.995443,0.090216,0,-0.103667,0.0846314,0.990848,0,6.91584,-1.85261,-8.59192,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 15:04:18.303','2024-06-13 13:05:35.251','2024-06-13 15:05:38.110'),('717ae8bb-2985-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_a8885309-2984-11ef-8e16-d517f37fa2ad/occlusion_a888b842-2984-11ef-8e16-d517f37fa2ad/scan_4a3afb31-2985-11ef-8e16-d517f37fa2ad/717ae8bb-2985-11ef-8e16-d517f37fa2ad.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_a8885309-2984-11ef-8e16-d517f37fa2ad_SESS_a888b842-2984-11ef-8e16-d517f37fa2ad_LESC_4a3afb31-2985-11ef-8e16-d517f37fa2ad_SNAPS','717ae8bb-2985-11ef-8e16-d517f37fa2ad.png','717ae8bb-2985-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.7 Morso sinistro bl1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 15:04:18.304','2024-06-13 13:05:35.251','2024-06-13 15:05:38.733'),('719a9003-233b-11ef-8f93-d92a45da78c9',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_2e146f3d-233a-11ef-8f93-d92a45da78c9/719a9003-233b-11ef-8f93-d92a45da78c9.xyz','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_TOSC_2e146f3d-233a-11ef-8f93-d92a45da78c9_LIFI','719a9003-233b-11ef-8f93-d92a45da78c9.xyz','719a9003-233b-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Maxillaire u2 Ligne de finition 0 [pc1]\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-05 14:59:29.000','2024-06-05 12:59:29.000','2024-06-05 14:59:29.000'),('719a949c-233b-11ef-8f93-d92a45da78c9',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_2e146f3d-233a-11ef-8f93-d92a45da78c9/719a949c-233b-11ef-8f93-d92a45da78c9.bin','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_TOSC_2e146f3d-233a-11ef-8f93-d92a45da78c9_LIFIM','719a949c-233b-11ef-8f93-d92a45da78c9.bin','719a949c-233b-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Maxillaire u2 Ligne de finition métadonnées 0 [pc1]\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-05 14:59:30.000','2024-06-05 12:59:30.000','2024-06-05 14:59:30.000'),('71a237c5-233b-11ef-8f93-d92a45da78c9',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/computedocclusion_a2829ff3-2338-11ef-8f93-d92a45da78c9/71a237c5-233b-11ef-8f93-d92a45da78c9.xyz','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_OCC_a2829ff3-2338-11ef-8f93-d92a45da78c9_LIFIO','71a237c5-233b-11ef-8f93-d92a45da78c9.xyz','71a237c5-233b-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Occlusion o1 Maxillaire u2 Ligne de finition 0 [pc1]\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY_2\",\"referenceScanFullDisplayId\":\"1.5_u2\",\"referenceScanId\":\"2e146f3d-233a-11ef-8f93-d92a45da78c9\",\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-05 14:59:31.000','2024-06-05 12:59:31.000','2024-06-05 14:59:31.000'),('71a23b4a-233b-11ef-8f93-d92a45da78c9',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/computedocclusion_a2829ff3-2338-11ef-8f93-d92a45da78c9/71a23b4a-233b-11ef-8f93-d92a45da78c9.bin','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_OCC_a2829ff3-2338-11ef-8f93-d92a45da78c9_LIFIMO','71a23b4a-233b-11ef-8f93-d92a45da78c9.bin','71a23b4a-233b-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Occlusion o1 Maxillaire u2 Ligne de finition métadonnées 0 [pc1]\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY_2\",\"referenceScanFullDisplayId\":\"1.5_u2\",\"referenceScanId\":\"2e146f3d-233a-11ef-8f93-d92a45da78c9\",\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-05 14:59:31.000','2024-06-05 12:59:31.000','2024-06-05 14:59:31.000'),('72b9a13e-2ef1-11ef-bb8b-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_82a44e97-2ee8-11ef-8dc9-d414e3397395/72b9a13e-2ef1-11ef-bb8b-6ec2958327c0.png','PATIENT_0d66331b-2eda-11ef-8de3-d515e950d747_ACT_8ffbf7e3-2eee-11ef-8dc9-d414e3397395_SESS_8ffc5e64-2eee-11ef-8dc9-d414e3397395_TOSC_c5e81c85-2eee-11ef-8dc9-d414e3397395_SCREENS','1ced91f4-2ef1-11ef-8dc9-d414e3397395.png','72b9a13e-2ef1-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.5 Maxilla u1 Screenshot 1\",\"title\":\"1\"}','PNG',0,'SYNCED',0,NULL,'2024-06-20 12:37:38.000','2024-06-20 10:37:38.000','2024-06-20 12:37:38.000'),('7362837c-2e0e-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/ce57500b-227c-11ef-8d76-d310d2ec2c14/session_da355fe4-227c-11ef-8d76-d310d2ec2c14/occlusion_da37d213-227c-11ef-8d76-d310d2ec2c14/scan_e0f66733-227c-11ef-8d76-d310d2ec2c14/7362837c-2e0e-11ef-8deb-d515ea58f6cb.zip','PATIENT_ce57500b-227c-11ef-8d76-d310d2ec2c14_ACT_da355fe4-227c-11ef-8d76-d310d2ec2c14_SESS_da37d213-227c-11ef-8d76-d310d2ec2c14_TOSC_e0f66733-227c-11ef-8d76-d310d2ec2c14_MODEL','7362837c-2e0e-11ef-8deb-d515ea58f6cb.zip','f51d71ce-227c-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"3.1 Maxillaire u1 [pc2]\",\"modelMatrix\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"scanBodies\":[{\"position\":\"4.62786,6,0,0,-4.60181,0,6,0,8.70585,0,0,6,1,0,0,0\",\"reference\":\"K30PSCANPLG\",\"tid\":14}]}','ZIP',2,'SYNCED',0,NULL,'2024-06-19 09:35:07.848','2024-06-19 07:35:07.951','2024-06-19 12:49:20.461'),('7363094e-2e0e-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/ce57500b-227c-11ef-8d76-d310d2ec2c14/session_da355fe4-227c-11ef-8d76-d310d2ec2c14/occlusion_da37d213-227c-11ef-8d76-d310d2ec2c14/scan_e0f66733-227c-11ef-8d76-d310d2ec2c14/7363094e-2e0e-11ef-8deb-d515ea58f6cb.png','PATIENT_ce57500b-227c-11ef-8d76-d310d2ec2c14_ACT_da355fe4-227c-11ef-8d76-d310d2ec2c14_SESS_da37d213-227c-11ef-8d76-d310d2ec2c14_TOSC_e0f66733-227c-11ef-8d76-d310d2ec2c14_SNAPS','7363094e-2e0e-11ef-8deb-d515ea58f6cb.png','f51d8554-227c-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"3.1 Maxillaire u1 Snapshot [pc2]\"}','PNG',1,'SYNCED',0,NULL,'2024-06-19 09:35:07.851','2024-06-19 07:35:07.952','2024-06-19 12:49:21.073'),('73b17774-2720-11ef-8e16-d517f37fa1ab',2,'/var/.scan4all/iris/data/2024/2/a1ace9b5-2271-11ef-8d76-d310d2ec2c14/session_1cb775ae-271f-11ef-8e16-d517f37fa1ab/occlusion_1cb90d11-271f-11ef-8e16-d517f37fa1ab/scan_424c596f-2720-11ef-8e16-d517f37fa1ab/73b17774-2720-11ef-8e16-d517f37fa1ab.zip','PATIENT_a1ace9b5-2271-11ef-8d76-d310d2ec2c14_ACT_1cb775ae-271f-11ef-8e16-d517f37fa1ab_SESS_1cb90d11-271f-11ef-8e16-d517f37fa1ab_TOSC_424c596f-2720-11ef-8e16-d517f37fa1ab_MODEL','73b17774-2720-11ef-8e16-d517f37fa1ab.zip','73b17774-2720-11ef-8e16-d517f37fa1ab','{\"displayTitle\":\"2.2 Maxillaire u2 [pc2]\",\"modelMatrix\":\"-0.630539,-0.775209,-0.0383597,0,0.768978,-0.63065,0.104661,0,-0.105326,0.0364953,0.993768,0,9.39433,12.4536,-12.9982,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-10 15:34:31.000','2024-06-10 13:34:31.000','2024-06-10 15:34:31.000'),('73b18674-2720-11ef-8e16-d517f37fa1ab',2,'/var/.scan4all/iris/data/2024/2/a1ace9b5-2271-11ef-8d76-d310d2ec2c14/session_1cb775ae-271f-11ef-8e16-d517f37fa1ab/occlusion_1cb90d11-271f-11ef-8e16-d517f37fa1ab/scan_424c596f-2720-11ef-8e16-d517f37fa1ab/73b18674-2720-11ef-8e16-d517f37fa1ab.png','PATIENT_a1ace9b5-2271-11ef-8d76-d310d2ec2c14_ACT_1cb775ae-271f-11ef-8e16-d517f37fa1ab_SESS_1cb90d11-271f-11ef-8e16-d517f37fa1ab_TOSC_424c596f-2720-11ef-8e16-d517f37fa1ab_SNAPS','73b18674-2720-11ef-8e16-d517f37fa1ab.png','73b18674-2720-11ef-8e16-d517f37fa1ab','{\"displayTitle\":\"2.2 Maxillaire u2 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-10 15:34:32.000','2024-06-10 13:34:32.000','2024-06-10 15:34:32.000'),('74b221fa-2985-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_a8885309-2984-11ef-8e16-d517f37fa2ad/occlusion_a888b842-2984-11ef-8e16-d517f37fa2ad/computedocclusion_456d151a-2985-11ef-8e16-d517f37fa2ad/74b221fa-2985-11ef-8e16-d517f37fa2ad.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_a8885309-2984-11ef-8e16-d517f37fa2ad_SESS_a888b842-2984-11ef-8e16-d517f37fa2ad_OCC_456d151a-2985-11ef-8e16-d517f37fa2ad_TO1','74b221fa-2985-11ef-8e16-d517f37fa2ad.zip','74b221fa-2985-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.7 Occlusione o1 Mascella u2\",\"modelMatrix\":\"0.676804,-0.736112,0.00867294,0,0.735905,0.676831,0.0185321,0,-0.0195118,-0.00616012,0.999791,0,-5.57178,10.6847,-13.2414,1\",\"occlusionMatrix\":\"-0.990106,0.0188069,-0.139195,0,0.139836,0.225332,-0.964209,0,0.0132319,-0.974107,-0.225727,0,11.3097,10.0348,2.87822,1\",\"occlusionType\":2,\"referenceScanFullDisplayId\":\"7.1_u2\",\"referenceScanId\":\"de3fd237-2984-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 15:04:23.699','2024-06-13 13:05:35.530','2024-06-13 15:05:42.206'),('74cbc798-2985-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_a8885309-2984-11ef-8e16-d517f37fa2ad/occlusion_a888b842-2984-11ef-8e16-d517f37fa2ad/computedocclusion_456d151a-2985-11ef-8e16-d517f37fa2ad/74cbc798-2985-11ef-8e16-d517f37fa2ad.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_a8885309-2984-11ef-8e16-d517f37fa2ad_SESS_a888b842-2984-11ef-8e16-d517f37fa2ad_OCC_456d151a-2985-11ef-8e16-d517f37fa2ad_BO1','74cbc798-2985-11ef-8e16-d517f37fa2ad.zip','74cbc798-2985-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.7 Occlusione o1 Mandibola l1\",\"modelMatrix\":\"0.959092,0.272161,-0.0779181,0,-0.260339,0.739812,-0.620405,0,-0.111206,0.615311,0.780401,0,-10.6931,-9.10435,-8.84207,1\",\"occlusionMatrix\":\"-0.985837,-0.112646,-0.124328,0,-0.0581593,-0.465661,0.883053,0,-0.157368,0.87777,0.45251,0,14.384,-5.38711,-3.52715,1\",\"occlusionType\":2,\"referenceScanFullDisplayId\":\"7.1_l1\",\"referenceScanId\":\"1d4719f4-2985-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 15:04:23.867','2024-06-13 13:05:35.531','2024-06-13 15:05:43.023'),('74d6b1c3-226f-11ef-8f1f-d8242c71b430',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f6cfa4bf-226e-11ef-8f1f-d8242c71b430/order_f6d25816-226e-11ef-8f1f-d8242c71b430/74d6b1c3-226f-11ef-8f1f-d8242c71b430.pdf','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f6cfa4bf-226e-11ef-8f1f-d8242c71b430_PROST_f6d25816-226e-11ef-8f1f-d8242c71b430_FORM','74d6b1c3-226f-11ef-8f1f-d8242c71b430.pdf','74d6b1c3-226f-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.3 Couronne [pc1]\",\"title\":\"Couronne\"}','PDF',0,'SYNCED',0,NULL,'2024-06-04 14:39:17.000','2024-06-04 12:39:17.000','2024-06-04 14:39:17.000'),('753bf031-2985-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_a8885309-2984-11ef-8e16-d517f37fa2ad/occlusion_a888b842-2984-11ef-8e16-d517f37fa2ad/computedocclusion_456d151a-2985-11ef-8e16-d517f37fa2ad/753bf031-2985-11ef-8e16-d517f37fa2ad.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_a8885309-2984-11ef-8e16-d517f37fa2ad_SESS_a888b842-2984-11ef-8e16-d517f37fa2ad_OCC_456d151a-2985-11ef-8e16-d517f37fa2ad_SNAPO','753bf031-2985-11ef-8e16-d517f37fa2ad.png','753bf031-2985-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.7 Occlusione o1\",\"occlusionType\":2}','PNG',0,'SYNCED',0,NULL,'2024-06-13 15:04:24.602','2024-06-13 13:05:35.530','2024-06-13 15:05:41.900'),('765dccd0-2965-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_4704a021-2963-11ef-8e16-d517f37fa2ad/occlusion_4706df6f-2963-11ef-8e16-d517f37fa2ad/scan_c5a22d2e-2964-11ef-8e16-d517f37fa2ad/765dccd0-2965-11ef-8e16-d517f37fa2ad.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_4704a021-2963-11ef-8e16-d517f37fa2ad_SESS_4706df6f-2963-11ef-8e16-d517f37fa2ad_BOSC_c5a22d2e-2964-11ef-8e16-d517f37fa2ad_MODEL','765dccd0-2965-11ef-8e16-d517f37fa2ad.zip','765dccd0-2965-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.1 Mandibola l1\",\"modelMatrix\":\"0.327181,-0.933436,-0.147142,0,0.917149,0.351178,-0.188447,0,0.227576,-0.0732951,0.970998,0,-28.8195,15.0926,-11.5479,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,'2024-06-13 11:18:50.266','2024-06-13 11:15:22.607','2024-06-13 09:18:50.270','2024-06-13 11:18:50.296'),('765f104c-2965-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_4704a021-2963-11ef-8e16-d517f37fa2ad/occlusion_4706df6f-2963-11ef-8e16-d517f37fa2ad/scan_c5a22d2e-2964-11ef-8e16-d517f37fa2ad/765f104c-2965-11ef-8e16-d517f37fa2ad.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_4704a021-2963-11ef-8e16-d517f37fa2ad_SESS_4706df6f-2963-11ef-8e16-d517f37fa2ad_BOSC_c5a22d2e-2964-11ef-8e16-d517f37fa2ad_SNAPS','765f104c-2965-11ef-8e16-d517f37fa2ad.png','765f104c-2965-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.1 Mandibola l1 Snapshot\"}','PNG',0,'CREATED',0,'2024-06-13 11:18:50.266','2024-06-13 11:15:22.615','2024-06-13 09:18:50.273','2024-06-13 11:18:50.298'),('76d290b9-273c-11ef-8e16-d517f37fa1ab',2,'/var/.scan4all/iris/data/2024/2/520a1417-2735-11ef-8e16-d517f37fa1ab/session_917767fe-23fa-11ef-8dde-d415e84cc4f5/occlusion_91784208-23fa-11ef-8dde-d415e84cc4f5/scan_6b394d9c-273c-11ef-8e16-d517f37fa1ab/76d290b9-273c-11ef-8e16-d517f37fa1ab.zip','PATIENT_520a1417-2735-11ef-8e16-d517f37fa1ab_ACT_917767fe-23fa-11ef-8dde-d415e84cc4f5_SESS_91784208-23fa-11ef-8dde-d415e84cc4f5_TOSC_6b394d9c-273c-11ef-8e16-d517f37fa1ab_MODEL','76d290b9-273c-11ef-8e16-d517f37fa1ab.zip','76d290b9-273c-11ef-8e16-d517f37fa1ab','{\"displayTitle\":\"7.2 Maxillaire u1 [pc2]\",\"modelMatrix\":\"-0.218201,0.935678,-0.277299,0,-0.958042,-0.259493,-0.121732,0,-0.185859,0.239102,0.953041,0,5.39353,-7.32203,-11.0012,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,'2024-06-11 10:15:35.000','2024-06-10 17:17:04.000','2024-06-11 08:15:35.000','2024-06-11 10:15:35.000'),('76d2a559-273c-11ef-8e16-d517f37fa1ab',2,'/var/.scan4all/iris/data/2024/2/520a1417-2735-11ef-8e16-d517f37fa1ab/session_917767fe-23fa-11ef-8dde-d415e84cc4f5/occlusion_91784208-23fa-11ef-8dde-d415e84cc4f5/scan_6b394d9c-273c-11ef-8e16-d517f37fa1ab/76d2a559-273c-11ef-8e16-d517f37fa1ab.png','PATIENT_520a1417-2735-11ef-8e16-d517f37fa1ab_ACT_917767fe-23fa-11ef-8dde-d415e84cc4f5_SESS_91784208-23fa-11ef-8dde-d415e84cc4f5_TOSC_6b394d9c-273c-11ef-8e16-d517f37fa1ab_SNAPS','76d2a559-273c-11ef-8e16-d517f37fa1ab.png','76d2a559-273c-11ef-8e16-d517f37fa1ab','{\"displayTitle\":\"7.2 Maxillaire u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,'2024-06-11 10:15:35.000','2024-06-10 17:17:05.000','2024-06-11 08:15:35.000','2024-06-11 10:15:35.000'),('776de714-2a2c-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/scan_80540c46-2a2a-11ef-8f1c-d8242c6fa8fd/776de714-2a2c-11ef-8f1c-d8242c6fa8fd.png','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_BOSC_80540c46-2a2a-11ef-8f1c-d8242c6fa8fd_SCREENS','776de714-2a2c-11ef-8f1c-d8242c6fa8fd.png','776de714-2a2c-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Mandibola l1 Screenshot 2\",\"title\":\"2\"}','PNG',0,'SYNCED',0,NULL,'2024-06-14 10:59:55.759','2024-06-14 08:59:56.010','2024-06-14 10:59:56.321'),('77a5910f-2983-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_08eb58c6-2980-11ef-8e16-d517f37fa2ad/occlusion_08ed7a4a-2980-11ef-8e16-d517f37fa2ad/scan_099d82e1-2980-11ef-8e16-d517f37fa2ad/77a5910f-2983-11ef-8e16-d517f37fa2ad.ply','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_TOSC_099d82e1-2980-11ef-8e16-d517f37fa2ad_SEG','77a5910f-2983-11ef-8e16-d517f37fa2ad.ply','ff215bde-2982-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.5 Mascella u1 Segmentazione\"}','PLY',1,'SYNCED',0,NULL,'2024-06-13 14:50:09.657','2024-06-13 12:50:09.708','2024-06-13 14:50:09.952'),('78e2643a-298a-11ef-8e16-d517f37fa2ad',2,'/var/.scan4all/iris/data/2024/2/5062e053-298a-11ef-8e16-d517f37fa2ad/session_58f22a30-298a-11ef-8e16-d517f37fa2ad/occlusion_58f49179-298a-11ef-8e16-d517f37fa2ad/scan_5aea484e-298a-11ef-8e16-d517f37fa2ad/78e2643a-298a-11ef-8e16-d517f37fa2ad.zip','PATIENT_5062e053-298a-11ef-8e16-d517f37fa2ad_ACT_58f22a30-298a-11ef-8e16-d517f37fa2ad_SESS_58f49179-298a-11ef-8e16-d517f37fa2ad_TOSC_5aea484e-298a-11ef-8e16-d517f37fa2ad_MODEL','78e2643a-298a-11ef-8e16-d517f37fa2ad.zip','78e2643a-298a-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"14.1 Maxillaire u1 [pc2]\",\"modelMatrix\":\"0.984776,-0.168759,0.0416783,0,0.171685,0.906717,-0.385213,0,0.0272176,0.386504,0.921886,0,-4.32838,-3.53646,-10.4492,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 15:40:18.210','2024-06-13 13:40:18.574','2024-06-13 15:40:20.892'),('78e27dbb-298a-11ef-8e16-d517f37fa2ad',2,'/var/.scan4all/iris/data/2024/2/5062e053-298a-11ef-8e16-d517f37fa2ad/session_58f22a30-298a-11ef-8e16-d517f37fa2ad/occlusion_58f49179-298a-11ef-8e16-d517f37fa2ad/scan_5aea484e-298a-11ef-8e16-d517f37fa2ad/78e27dbb-298a-11ef-8e16-d517f37fa2ad.png','PATIENT_5062e053-298a-11ef-8e16-d517f37fa2ad_ACT_58f22a30-298a-11ef-8e16-d517f37fa2ad_SESS_58f49179-298a-11ef-8e16-d517f37fa2ad_TOSC_5aea484e-298a-11ef-8e16-d517f37fa2ad_SNAPS','78e27dbb-298a-11ef-8e16-d517f37fa2ad.png','78e27dbb-298a-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"14.1 Maxillaire u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 15:40:18.211','2024-06-13 13:40:18.575','2024-06-13 15:40:21.580'),('79cb66b6-2cba-11ef-bb8b-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_550eb27a-226b-11ef-8f1f-d8242c71b430/79cb66b6-2cba-11ef-bb8b-6ec2958327c0.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_521cc4b4-2a2d-11ef-8fb0-da2b4bf5ebbb_SESS_521e34c0-2a2d-11ef-8fb0-da2b4bf5ebbb_OCC_9a211178-2a2d-11ef-8fb0-da2b4bf5ebbb_TO1','9f7381e8-2a33-11ef-8fb0-da2b4bf5ebbb.zip','79cb66b6-2cba-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.15 Occlusion o1 Maxillaire u1\",\"modelMatrix\":\"-0.889789,-0.423083,-0.171104,0,0.345811,-0.869705,0.352175,0,-0.297809,0.254192,0.920161,0,11.9655,6.21683,-13.8863,1\",\"occlusionMatrix\":\"-0.884074,0.42828,0.187605,0,-0.13088,0.159297,-0.978448,0,-0.448842,-0.88961,-0.0848887,0,14.4848,3.49253,6.74187,1\",\"occlusionType\":2,\"referenceScanFullDisplayId\":\"1.15_u1\",\"referenceScanId\":\"537a90d6-2a2d-11ef-8fb0-da2b4bf5ebbb\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-14 11:51:10.000','2024-06-14 09:51:10.000','2024-06-14 11:51:10.000'),('79cc071e-2cba-11ef-bb8b-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_550eb27a-226b-11ef-8f1f-d8242c71b430/79cc071e-2cba-11ef-bb8b-6ec2958327c0.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_521cc4b4-2a2d-11ef-8fb0-da2b4bf5ebbb_SESS_521e34c0-2a2d-11ef-8fb0-da2b4bf5ebbb_OCC_9a211178-2a2d-11ef-8fb0-da2b4bf5ebbb_BO1','e9a60a39-2a2d-11ef-8fb0-da2b4bf5ebbb.zip','79cc071e-2cba-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.15 Occlusion o1 Mandibule l1\",\"modelMatrix\":\"-0.878949,-0.40333,-0.254507,0,0.291084,-0.876413,0.383627,0,-0.377781,0.263106,0.887726,0,15.6373,0.394049,-6.74282,1\",\"occlusionMatrix\":\"-0.958237,-0.123258,0.258164,0,0.285373,-0.349674,0.892376,0,-0.0193057,0.928734,0.370175,0,11.1086,-6.86618,-0.278046,1\",\"occlusionType\":2,\"referenceScanFullDisplayId\":\"1.15_l1\",\"referenceScanId\":\"7ddf36e7-2a2d-11ef-8fb0-da2b4bf5ebbb\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-14 11:10:18.000','2024-06-14 09:10:18.000','2024-06-14 11:10:18.000'),('79cc4cbf-2cba-11ef-bb8b-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_550eb27a-226b-11ef-8f1f-d8242c71b430/79cc4cbf-2cba-11ef-bb8b-6ec2958327c0.png','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_521cc4b4-2a2d-11ef-8fb0-da2b4bf5ebbb_SESS_521e34c0-2a2d-11ef-8fb0-da2b4bf5ebbb_OCC_9a211178-2a2d-11ef-8fb0-da2b4bf5ebbb_SNAPO','ea0ed256-2a2d-11ef-8fb0-da2b4bf5ebbb.png','79cc4cbf-2cba-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.15 Occlusion o1\",\"occlusionType\":2}','PNG',0,'SYNCED',0,NULL,'2024-06-14 11:10:18.000','2024-06-14 09:10:18.000','2024-06-14 11:10:18.000'),('7b2155d2-2e0d-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/4382037a-2735-11ef-8e16-d517f37fa1ab/session_be9a8e99-2735-11ef-8e16-d517f37fa1ab/occlusion_be9c5752-2735-11ef-8e16-d517f37fa1ab/scan_7b212ac0-2e0d-11ef-8deb-d515ea58f6cb/7b2155d2-2e0d-11ef-8deb-d515ea58f6cb.png','PATIENT_4382037a-2735-11ef-8e16-d517f37fa1ab_ACT_be9a8e99-2735-11ef-8e16-d517f37fa1ab_SESS_be9c5752-2735-11ef-8e16-d517f37fa1ab_TOSC_7b212ac0-2e0d-11ef-8deb-d515ea58f6cb_SNAPS','7b2155d2-2e0d-11ef-8deb-d515ea58f6cb.png','7b2155d2-2e0d-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"6.1 Maxillaire u2 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-19 09:28:11.345','2024-06-19 07:28:13.857','2024-06-19 12:49:21.322'),('7b216adc-2e0d-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/4382037a-2735-11ef-8e16-d517f37fa1ab/session_be9a8e99-2735-11ef-8e16-d517f37fa1ab/occlusion_be9c5752-2735-11ef-8e16-d517f37fa1ab/scan_7b212ac0-2e0d-11ef-8deb-d515ea58f6cb/7b216adc-2e0d-11ef-8deb-d515ea58f6cb.xyz','PATIENT_4382037a-2735-11ef-8e16-d517f37fa1ab_ACT_be9a8e99-2735-11ef-8e16-d517f37fa1ab_SESS_be9c5752-2735-11ef-8e16-d517f37fa1ab_TOSC_7b212ac0-2e0d-11ef-8deb-d515ea58f6cb_LIFI','7b216adc-2e0d-11ef-8deb-d515ea58f6cb.xyz','7b216adc-2e0d-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"6.1 Maxillaire u2 Ligne de finition 0 [pc2]\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-19 09:28:11.346','2024-06-19 07:28:13.858','2024-06-19 12:49:21.712'),('7b217790-2e0d-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/4382037a-2735-11ef-8e16-d517f37fa1ab/session_be9a8e99-2735-11ef-8e16-d517f37fa1ab/occlusion_be9c5752-2735-11ef-8e16-d517f37fa1ab/scan_7b212ac0-2e0d-11ef-8deb-d515ea58f6cb/7b217790-2e0d-11ef-8deb-d515ea58f6cb.bin','PATIENT_4382037a-2735-11ef-8e16-d517f37fa1ab_ACT_be9a8e99-2735-11ef-8e16-d517f37fa1ab_SESS_be9c5752-2735-11ef-8e16-d517f37fa1ab_TOSC_7b212ac0-2e0d-11ef-8deb-d515ea58f6cb_LIFIM','7b217790-2e0d-11ef-8deb-d515ea58f6cb.bin','7b217790-2e0d-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"6.1 Maxillaire u2 Ligne de finition métadonnées 0 [pc2]\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-19 09:28:11.346','2024-06-19 07:28:13.858','2024-06-19 12:49:22.176'),('7b2184f3-2e0d-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/4382037a-2735-11ef-8e16-d517f37fa1ab/session_be9a8e99-2735-11ef-8e16-d517f37fa1ab/occlusion_be9c5752-2735-11ef-8e16-d517f37fa1ab/scan_7b212ac0-2e0d-11ef-8deb-d515ea58f6cb/7b2184f3-2e0d-11ef-8deb-d515ea58f6cb.zip','PATIENT_4382037a-2735-11ef-8e16-d517f37fa1ab_ACT_be9a8e99-2735-11ef-8e16-d517f37fa1ab_SESS_be9c5752-2735-11ef-8e16-d517f37fa1ab_TOSC_7b212ac0-2e0d-11ef-8deb-d515ea58f6cb_MODEL','7b2184f3-2e0d-11ef-8deb-d515ea58f6cb.zip','7b2184f3-2e0d-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"6.1 Maxillaire u2 [pc2]\",\"modelMatrix\":\"-0.479814,-0.110653,0.870364,0,-0.0586755,0.993841,0.0940049,0,-0.875406,-0.00596416,-0.483352,0,21.2778,2.84273,-5.93875,1\",\"scanBodies\":[],\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":3,\"socleIsFullArch\":true,\"socleThickness\":-1,\"socleType\":1}','ZIP',0,'SYNCED',0,NULL,'2024-06-19 09:28:11.346','2024-06-19 07:28:13.859','2024-06-19 12:49:22.664'),('7cf2dff1-298a-11ef-8e16-d517f37fa2ad',2,'/var/.scan4all/iris/data/2024/2/5062e053-298a-11ef-8e16-d517f37fa2ad/session_58f22a30-298a-11ef-8e16-d517f37fa2ad/occlusion_58f49179-298a-11ef-8e16-d517f37fa2ad/scan_7b2ae451-298a-11ef-8e16-d517f37fa2ad/7cf2dff1-298a-11ef-8e16-d517f37fa2ad.ply','PATIENT_5062e053-298a-11ef-8e16-d517f37fa2ad_ACT_58f22a30-298a-11ef-8e16-d517f37fa2ad_SESS_58f49179-298a-11ef-8e16-d517f37fa2ad_TOSC_7b2ae451-298a-11ef-8e16-d517f37fa2ad_SEG','7cf2dff1-298a-11ef-8e16-d517f37fa2ad.ply','7cf2dff1-298a-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"14.1 Maxillaire u2 Segmentation [pc2]\"}','PLY',0,'CREATED',0,'2024-06-13 15:40:28.991','2024-06-13 15:40:28.992','2024-06-13 13:40:28.993',NULL),('7d5421bb-2969-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_4704a021-2963-11ef-8e16-d517f37fa2ad/occlusion_4706df6f-2963-11ef-8e16-d517f37fa2ad/scan_366c0b70-2969-11ef-8e16-d517f37fa2ad/7d5421bb-2969-11ef-8e16-d517f37fa2ad.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_4704a021-2963-11ef-8e16-d517f37fa2ad_SESS_4706df6f-2963-11ef-8e16-d517f37fa2ad_LESC_366c0b70-2969-11ef-8e16-d517f37fa2ad_MODEL','7d5421bb-2969-11ef-8e16-d517f37fa2ad.zip','7d5421bb-2969-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.1 Morso sinistro bl3\",\"modelMatrix\":\"-0.997979,0.0619012,0.0101785,0,-0.0624953,-0.933809,-0.351882,0,-0.0115734,-0.352378,0.93599,0,8.08208,8.15185,-9.54893,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 11:44:12.274','2024-06-13 09:44:12.818','2024-06-13 11:46:14.848'),('7d556dfa-2969-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_4704a021-2963-11ef-8e16-d517f37fa2ad/occlusion_4706df6f-2963-11ef-8e16-d517f37fa2ad/scan_366c0b70-2969-11ef-8e16-d517f37fa2ad/7d556dfa-2969-11ef-8e16-d517f37fa2ad.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_4704a021-2963-11ef-8e16-d517f37fa2ad_SESS_4706df6f-2963-11ef-8e16-d517f37fa2ad_LESC_366c0b70-2969-11ef-8e16-d517f37fa2ad_SNAPS','7d556dfa-2969-11ef-8e16-d517f37fa2ad.png','7d556dfa-2969-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.1 Morso sinistro bl3 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 11:44:12.283','2024-06-13 09:44:12.818','2024-06-13 11:46:15.974'),('7d7bc15f-289b-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/f373c86a-2899-11ef-8e16-d517f37fa2ad/session_627cfe1c-289b-11ef-8e16-d517f37fa2ad/occlusion_627f5b3e-289b-11ef-8e16-d517f37fa2ad/scan_634550b6-289b-11ef-8e16-d517f37fa2ad/7d7bc15f-289b-11ef-8e16-d517f37fa2ad.zip','PATIENT_f373c86a-2899-11ef-8e16-d517f37fa2ad_ACT_627cfe1c-289b-11ef-8e16-d517f37fa2ad_SESS_627f5b3e-289b-11ef-8e16-d517f37fa2ad_TOSC_634550b6-289b-11ef-8e16-d517f37fa2ad_MODEL','7d7bc15f-289b-11ef-8e16-d517f37fa2ad.zip','7d7bc15f-289b-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.2 Maxillaire u1\",\"modelMatrix\":\"-0.895294,-0.390239,0.214854,0,0.445475,-0.784282,0.431803,0,2.53238e-08,0.482302,0.876005,0,4.12371,-5.83256,-14.6041,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,'2024-06-12 11:10:28.451','2024-06-12 11:09:36.207','2024-06-12 09:10:28.453','2024-06-12 11:10:28.484'),('7d7bd46a-289b-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/f373c86a-2899-11ef-8e16-d517f37fa2ad/session_627cfe1c-289b-11ef-8e16-d517f37fa2ad/occlusion_627f5b3e-289b-11ef-8e16-d517f37fa2ad/scan_634550b6-289b-11ef-8e16-d517f37fa2ad/7d7bd46a-289b-11ef-8e16-d517f37fa2ad.png','PATIENT_f373c86a-2899-11ef-8e16-d517f37fa2ad_ACT_627cfe1c-289b-11ef-8e16-d517f37fa2ad_SESS_627f5b3e-289b-11ef-8e16-d517f37fa2ad_TOSC_634550b6-289b-11ef-8e16-d517f37fa2ad_SNAPS','7d7bd46a-289b-11ef-8e16-d517f37fa2ad.png','7d7bd46a-289b-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.2 Maxillaire u1 Snapshot\"}','PNG',0,'SYNCED',0,'2024-06-12 11:10:28.451','2024-06-12 11:09:36.208','2024-06-12 09:10:28.453','2024-06-12 11:10:28.485'),('7dc312cb-2981-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_08eb58c6-2980-11ef-8e16-d517f37fa2ad/occlusion_08ed7a4a-2980-11ef-8e16-d517f37fa2ad/computedocclusion_a4bc6912-2980-11ef-8e16-d517f37fa2ad/7dc312cb-2981-11ef-8e16-d517f37fa2ad.json','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_OCC_a4bc6912-2980-11ef-8e16-d517f37fa2ad_METER','7dc312cb-2981-11ef-8e16-d517f37fa2ad.json','7dc312cb-2981-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.5 Occlusione o1\",\"occlusionType\":3}','JSON',0,'SYNCED',0,NULL,'2024-06-13 14:36:02.000','2024-06-13 12:36:02.000','2024-06-13 14:36:02.000'),('7e144ea9-2a2b-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/computedocclusion_e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd/7e144ea9-2a2b-11ef-8f1c-d8242c6fa8fd.zip','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_OCC_e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd_TO1','7e144ea9-2a2b-11ef-8f1c-d8242c6fa8fd.zip','4276476e-2a2b-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Occlusione o1 Mascella u1\",\"modelMatrix\":\"0.990607,-0.0477183,-0.128143,0,0.0606045,0.993278,0.0986225,0,0.122576,-0.105462,0.98684,0,-17.296,2.00683,-11.2545,1\",\"occlusionMatrix\":\"0.958119,-0.174805,-0.226845,0,0.174544,-0.271551,0.946467,0,-0.227047,-0.946419,-0.229667,0,-15.7822,10.1985,5.34235,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"3.2_u1\",\"referenceScanId\":\"8de1d45c-2a29-11ef-8f1c-d8242c6fa8fd\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2024-06-14 10:52:57.419','2024-06-14 08:52:57.782','2024-06-14 10:52:58.637'),('7e31fba5-2a2b-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/computedocclusion_e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd/7e31fba5-2a2b-11ef-8f1c-d8242c6fa8fd.zip','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_OCC_e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd_BO1','7e31fba5-2a2b-11ef-8f1c-d8242c6fa8fd.zip','429a4668-2a2b-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Occlusione o1 Mandibola l1\",\"modelMatrix\":\"-0.934662,0.348207,-0.071824,0,-0.340741,-0.934968,-0.098644,0,-0.101502,-0.0677254,0.992527,0,16.8656,-3.96577,-16.4235,1\",\"occlusionMatrix\":\"0.844369,-0.423985,-0.327577,0,-0.264087,0.202641,-0.942975,0,0.466188,0.882728,0.0591338,0,-22.7792,-5.26712,4.79476,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"3.2_l1\",\"referenceScanId\":\"80540c46-2a2a-11ef-8f1c-d8242c6fa8fd\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2024-06-14 10:53:01.000','2024-06-14 08:53:01.000','2024-06-14 10:53:01.000'),('7ed3d80e-273f-11ef-8e09-d517f1736dc8',2,'/var/.scan4all/iris/data/2024/2/b8993188-273d-11ef-8e09-d517f1736dc8/session_5f1d39de-273f-11ef-8e09-d517f1736dc8/occlusion_5f1e0aab-273f-11ef-8e09-d517f1736dc8/scan_60553760-273f-11ef-8e09-d517f1736dc8/7ed3d80e-273f-11ef-8e09-d517f1736dc8.zip','PATIENT_b8993188-273d-11ef-8e09-d517f1736dc8_ACT_5f1d39de-273f-11ef-8e09-d517f1736dc8_SESS_5f1e0aab-273f-11ef-8e09-d517f1736dc8_TOSC_60553760-273f-11ef-8e09-d517f1736dc8_MODEL','7ed3d80e-273f-11ef-8e09-d517f1736dc8.zip','7ed3d80e-273f-11ef-8e09-d517f1736dc8','{\"displayTitle\":\"11.2 Maxillaire u1 [pc2]\",\"modelMatrix\":\"-0.813024,0.579102,-0.0602769,0,-0.580951,-0.800018,0.149891,0,0.0385796,0.156883,0.986863,0,11.769,-6.24715,-10.7627,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-10 17:38:33.601','2024-06-10 15:38:47.278','2024-06-10 17:38:48.308'),('7ed3ea61-273f-11ef-8e09-d517f1736dc8',2,'/var/.scan4all/iris/data/2024/2/b8993188-273d-11ef-8e09-d517f1736dc8/session_5f1d39de-273f-11ef-8e09-d517f1736dc8/occlusion_5f1e0aab-273f-11ef-8e09-d517f1736dc8/scan_60553760-273f-11ef-8e09-d517f1736dc8/7ed3ea61-273f-11ef-8e09-d517f1736dc8.png','PATIENT_b8993188-273d-11ef-8e09-d517f1736dc8_ACT_5f1d39de-273f-11ef-8e09-d517f1736dc8_SESS_5f1e0aab-273f-11ef-8e09-d517f1736dc8_TOSC_60553760-273f-11ef-8e09-d517f1736dc8_SNAPS','7ed3ea61-273f-11ef-8e09-d517f1736dc8.png','7ed3ea61-273f-11ef-8e09-d517f1736dc8','{\"displayTitle\":\"11.2 Maxillaire u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-10 17:38:33.601','2024-06-10 15:38:47.279','2024-06-10 17:38:50.178'),('7f0190db-289a-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/f373c86a-2899-11ef-8e16-d517f37fa2ad/session_0d1289f0-289a-11ef-8e16-d517f37fa2ad/occlusion_0d14f12a-289a-11ef-8e16-d517f37fa2ad/scan_5781b86f-289a-11ef-8e16-d517f37fa2ad/7f0190db-289a-11ef-8e16-d517f37fa2ad.zip','PATIENT_f373c86a-2899-11ef-8e16-d517f37fa2ad_ACT_0d1289f0-289a-11ef-8e16-d517f37fa2ad_SESS_0d14f12a-289a-11ef-8e16-d517f37fa2ad_TOSC_5781b86f-289a-11ef-8e16-d517f37fa2ad_MODEL','7f0190db-289a-11ef-8e16-d517f37fa2ad.zip','7f0190db-289a-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Maxillaire u2\",\"modelMatrix\":\"0.913022,-0.367317,0.177397,0,0.407911,0.82216,-0.397065,0,-1.75828e-09,0.434891,0.900483,0,-7.36214,-2.38053,-21.4033,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-12 11:02:32.000','2024-06-12 09:02:32.000','2024-06-12 11:02:32.000'),('7f01a3ee-289a-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/f373c86a-2899-11ef-8e16-d517f37fa2ad/session_0d1289f0-289a-11ef-8e16-d517f37fa2ad/occlusion_0d14f12a-289a-11ef-8e16-d517f37fa2ad/scan_5781b86f-289a-11ef-8e16-d517f37fa2ad/7f01a3ee-289a-11ef-8e16-d517f37fa2ad.png','PATIENT_f373c86a-2899-11ef-8e16-d517f37fa2ad_ACT_0d1289f0-289a-11ef-8e16-d517f37fa2ad_SESS_0d14f12a-289a-11ef-8e16-d517f37fa2ad_TOSC_5781b86f-289a-11ef-8e16-d517f37fa2ad_SNAPS','7f01a3ee-289a-11ef-8e16-d517f37fa2ad.png','7f01a3ee-289a-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Maxillaire u2 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-12 11:02:33.000','2024-06-12 09:02:33.000','2024-06-12 11:02:33.000'),('7ffd4d6c-28b0-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/f373c86a-2899-11ef-8e16-d517f37fa2ad/session_627cfe1c-289b-11ef-8e16-d517f37fa2ad/occlusion_627f5b3e-289b-11ef-8e16-d517f37fa2ad/scan_53323287-28af-11ef-8e16-d517f37fa2ad/7ffd4d6c-28b0-11ef-8e16-d517f37fa2ad.zip','PATIENT_f373c86a-2899-11ef-8e16-d517f37fa2ad_ACT_627cfe1c-289b-11ef-8e16-d517f37fa2ad_SESS_627f5b3e-289b-11ef-8e16-d517f37fa2ad_BOSC_53323287-28af-11ef-8e16-d517f37fa2ad_MODEL','7ffd4d6c-28b0-11ef-8e16-d517f37fa2ad.zip','7ffd4d6c-28b0-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.2 Mandibule l2\",\"modelMatrix\":\"-0.933581,-0.279382,-0.224436,0,0.194167,-0.920727,0.338467,0,-0.301206,0.272409,0.913821,0,18.488,2.00134,-7.39287,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-12 13:39:59.843','2024-06-12 11:40:00.800','2024-06-12 13:40:12.993'),('7ffd6d38-28b0-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/f373c86a-2899-11ef-8e16-d517f37fa2ad/session_627cfe1c-289b-11ef-8e16-d517f37fa2ad/occlusion_627f5b3e-289b-11ef-8e16-d517f37fa2ad/scan_53323287-28af-11ef-8e16-d517f37fa2ad/7ffd6d38-28b0-11ef-8e16-d517f37fa2ad.png','PATIENT_f373c86a-2899-11ef-8e16-d517f37fa2ad_ACT_627cfe1c-289b-11ef-8e16-d517f37fa2ad_SESS_627f5b3e-289b-11ef-8e16-d517f37fa2ad_BOSC_53323287-28af-11ef-8e16-d517f37fa2ad_SNAPS','7ffd6d38-28b0-11ef-8e16-d517f37fa2ad.png','7ffd6d38-28b0-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.2 Mandibule l2 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-12 13:39:59.844','2024-06-12 11:40:00.801','2024-06-12 13:40:14.017'),('80c3e23d-2e35-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_3654e763-2e35-11ef-8deb-d515ea58f6cb/occlusion_36556270-2e35-11ef-8deb-d515ea58f6cb/scan_3754a3a0-2e35-11ef-8deb-d515ea58f6cb/80c3e23d-2e35-11ef-8deb-d515ea58f6cb.zip','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_3654e763-2e35-11ef-8deb-d515ea58f6cb_SESS_36556270-2e35-11ef-8deb-d515ea58f6cb_TOSC_3754a3a0-2e35-11ef-8deb-d515ea58f6cb_MODEL','80c3e23d-2e35-11ef-8deb-d515ea58f6cb.zip','80c3e23d-2e35-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.1 Mascella u1 [pc2]\",\"modelMatrix\":\"0.869326,0.488065,-0.0778742,0,-0.47763,0.789114,-0.386224,0,-0.127051,0.37295,0.919112,0,-7.07756,-7.49141,-9.92149,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-19 14:14:40.668','2024-06-19 12:14:41.293','2024-06-19 14:14:44.106'),('80c3fca2-2e35-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_3654e763-2e35-11ef-8deb-d515ea58f6cb/occlusion_36556270-2e35-11ef-8deb-d515ea58f6cb/scan_3754a3a0-2e35-11ef-8deb-d515ea58f6cb/80c3fca2-2e35-11ef-8deb-d515ea58f6cb.png','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_3654e763-2e35-11ef-8deb-d515ea58f6cb_SESS_36556270-2e35-11ef-8deb-d515ea58f6cb_TOSC_3754a3a0-2e35-11ef-8deb-d515ea58f6cb_SNAPS','80c3fca2-2e35-11ef-8deb-d515ea58f6cb.png','80c3fca2-2e35-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.1 Mascella u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-19 14:14:40.669','2024-06-19 12:14:41.294','2024-06-19 14:14:45.289'),('8103b4c6-2269-11ef-8f1f-d8242c71b430',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_757ed4bc-2266-11ef-8f1f-d8242c71b430/occlusion_75806ee1-2266-11ef-8f1f-d8242c71b430/computedocclusion_0b16efeb-2268-11ef-8f1f-d8242c71b430/8103b4c6-2269-11ef-8f1f-d8242c71b430.xyz','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_OCC_0b16efeb-2268-11ef-8f1f-d8242c71b430_LIFIO','8103b4c6-2269-11ef-8f1f-d8242c71b430.xyz','8103b4c6-2269-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.2 Occlusion o1 Maxillaire u1 Ligne de finition 1\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY_1\",\"referenceScanFullDisplayId\":\"1.2_u1\",\"referenceScanId\":\"09768650-2267-11ef-8f1f-d8242c71b430\",\"title\":\"1\",\"toothNumber\":1001,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-04 13:56:41.000','2024-06-04 11:56:41.000','2024-06-04 13:56:41.000'),('8103b848-2269-11ef-8f1f-d8242c71b430',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_757ed4bc-2266-11ef-8f1f-d8242c71b430/occlusion_75806ee1-2266-11ef-8f1f-d8242c71b430/computedocclusion_0b16efeb-2268-11ef-8f1f-d8242c71b430/8103b848-2269-11ef-8f1f-d8242c71b430.bin','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_OCC_0b16efeb-2268-11ef-8f1f-d8242c71b430_LIFIMO','8103b848-2269-11ef-8f1f-d8242c71b430.bin','8103b848-2269-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.2 Occlusion o1 Maxillaire u1 Ligne de finition métadonnées 1\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY_1\",\"referenceScanFullDisplayId\":\"1.2_u1\",\"referenceScanId\":\"09768650-2267-11ef-8f1f-d8242c71b430\",\"title\":\"1\",\"toothNumber\":1001,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-04 13:56:41.000','2024-06-04 11:56:41.000','2024-06-04 13:56:41.000'),('83c9791c-2987-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/0fedc3b4-2961-11ef-8e16-d517f37fa2ad/session_4ba13230-2987-11ef-8e16-d517f37fa2ad/occlusion_4ba370c1-2987-11ef-8e16-d517f37fa2ad/scan_55568e89-2987-11ef-8e16-d517f37fa2ad/83c9791c-2987-11ef-8e16-d517f37fa2ad.zip','PATIENT_0fedc3b4-2961-11ef-8e16-d517f37fa2ad_ACT_4ba13230-2987-11ef-8e16-d517f37fa2ad_SESS_4ba370c1-2987-11ef-8e16-d517f37fa2ad_TOSC_55568e89-2987-11ef-8e16-d517f37fa2ad_MODEL','83c9791c-2987-11ef-8e16-d517f37fa2ad.zip','83c9791c-2987-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"4.1 Mascella u1\",\"modelMatrix\":\"0.996297,-0.00872078,0.0855323,0,0.0514771,0.85732,-0.512204,0,-0.0688617,0.51471,0.854594,0,-11.595,-8.11386,-10.2324,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 15:19:08.011','2024-06-13 13:19:08.633','2024-06-13 15:19:10.597'),('83c98a29-2987-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/0fedc3b4-2961-11ef-8e16-d517f37fa2ad/session_4ba13230-2987-11ef-8e16-d517f37fa2ad/occlusion_4ba370c1-2987-11ef-8e16-d517f37fa2ad/scan_55568e89-2987-11ef-8e16-d517f37fa2ad/83c98a29-2987-11ef-8e16-d517f37fa2ad.png','PATIENT_0fedc3b4-2961-11ef-8e16-d517f37fa2ad_ACT_4ba13230-2987-11ef-8e16-d517f37fa2ad_SESS_4ba370c1-2987-11ef-8e16-d517f37fa2ad_TOSC_55568e89-2987-11ef-8e16-d517f37fa2ad_SNAPS','83c98a29-2987-11ef-8e16-d517f37fa2ad.png','83c98a29-2987-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"4.1 Mascella u1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 15:19:08.012','2024-06-13 13:19:08.634','2024-06-13 15:19:11.369'),('84250955-2ee8-11ef-bb8b-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_82a44e97-2ee8-11ef-8dc9-d414e3397395/84250955-2ee8-11ef-bb8b-6ec2958327c0.png','PATIENT_0d66331b-2eda-11ef-8de3-d515e950d747_ACT_9a8959c0-2edd-11ef-8de3-d515e950d747_SESS_9a8a5a9c-2edd-11ef-8de3-d515e950d747_OCC_4eace0e6-2ee5-11ef-8dc9-d414e3397395_SCREENO','0b495fe1-2ee6-11ef-8dc9-d414e3397395.png','84250955-2ee8-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.1 Occlusion o1 Screenshot 1\",\"occlusionType\":2,\"title\":\"1\"}','PNG',0,'SYNCED',0,NULL,'2024-06-20 11:18:23.000','2024-06-20 09:18:23.000','2024-06-20 11:18:23.000'),('84255147-2ee8-11ef-bb8b-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_82a44e97-2ee8-11ef-8dc9-d414e3397395/84255147-2ee8-11ef-bb8b-6ec2958327c0.png','PATIENT_0d66331b-2eda-11ef-8de3-d515e950d747_ACT_9a8959c0-2edd-11ef-8de3-d515e950d747_SESS_9a8a5a9c-2edd-11ef-8de3-d515e950d747_TOSC_efafa8a6-2ee4-11ef-8dc9-d414e3397395_SCREENS','155e9236-2ee8-11ef-8dc9-d414e3397395.png','84255147-2ee8-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.1 Maxilla u1 Screenshot 2\",\"title\":\"2\"}','PNG',0,'SYNCED',0,NULL,'2024-06-20 11:32:59.000','2024-06-20 09:32:59.000','2024-06-20 11:32:59.000'),('84259467-2ee8-11ef-bb8b-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_82a44e97-2ee8-11ef-8dc9-d414e3397395/84259467-2ee8-11ef-bb8b-6ec2958327c0.png','PATIENT_0d66331b-2eda-11ef-8de3-d515e950d747_ACT_9a8959c0-2edd-11ef-8de3-d515e950d747_SESS_9a8a5a9c-2edd-11ef-8de3-d515e950d747_OCC_4eace0e6-2ee5-11ef-8dc9-d414e3397395_SNAPO','763b241a-2ee5-11ef-8dc9-d414e3397395.png','84259467-2ee8-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.1 Occlusion o1\",\"occlusionType\":2}','PNG',0,'SYNCED',0,NULL,'2024-06-20 11:14:14.000','2024-06-20 09:14:14.000','2024-06-20 11:14:14.000'),('8425da8f-2ee8-11ef-bb8b-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_82a44e97-2ee8-11ef-8dc9-d414e3397395/8425da8f-2ee8-11ef-bb8b-6ec2958327c0.zip','PATIENT_0d66331b-2eda-11ef-8de3-d515e950d747_ACT_9a8959c0-2edd-11ef-8de3-d515e950d747_SESS_9a8a5a9c-2edd-11ef-8de3-d515e950d747_OCC_4eace0e6-2ee5-11ef-8dc9-d414e3397395_TO1','7e981dac-2ee5-11ef-8dc9-d414e3397395.zip','8425da8f-2ee8-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.1 Occlusion o1 Maxilla u1\",\"modelMatrix\":\"0.472136,0.878125,0.0773602,0,-0.793392,0.461541,-0.396874,0,-0.38421,0.126001,0.914607,0,2.78486,1.94837,-12.4512,1\",\"occlusionMatrix\":\"-0.974235,-0.0712844,-0.213987,0,0.178518,0.336163,-0.924728,0,0.137853,-0.939106,-0.314775,0,-3.23436,8.78515,0.532737,1\",\"occlusionType\":2,\"referenceScanFullDisplayId\":\"1.1_u1\",\"referenceScanId\":\"efafa8a6-2ee4-11ef-8dc9-d414e3397395\",\"scanBodies\":[],\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":3,\"socleIsFullArch\":true,\"socleThickness\":1,\"socleType\":3}','ZIP',0,'SYNCED',0,NULL,'2024-06-20 11:14:28.000','2024-06-20 09:14:28.000','2024-06-20 11:14:28.000'),('84261829-2ee8-11ef-bb8b-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_82a44e97-2ee8-11ef-8dc9-d414e3397395/84261829-2ee8-11ef-bb8b-6ec2958327c0.zip','PATIENT_0d66331b-2eda-11ef-8de3-d515e950d747_ACT_9a8959c0-2edd-11ef-8de3-d515e950d747_SESS_9a8a5a9c-2edd-11ef-8de3-d515e950d747_OCC_4eace0e6-2ee5-11ef-8dc9-d414e3397395_BO1','7e983dec-2ee5-11ef-8dc9-d414e3397395.zip','84261829-2ee8-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.1 Occlusion o1 Mandible l1\",\"modelMatrix\":\"0.90883,-0.414032,0.0510396,0,0.414593,0.882875,-0.220555,0,0.0462551,0.221608,0.974038,0,-3.57283,2.38013,-12.2636,1\",\"occlusionMatrix\":\"-0.996501,-0.0496922,-0.0672998,0,-0.0690546,0.0344822,0.997022,0,-0.0472233,0.998174,-0.0377907,0,5.46924,-6.85076,3.49288,1\",\"occlusionType\":2,\"referenceScanFullDisplayId\":\"1.1_l1\",\"referenceScanId\":\"2b76d979-2ee5-11ef-8dc9-d414e3397395\",\"scanBodies\":[],\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":3,\"socleIsFullArch\":true,\"socleThickness\":1,\"socleType\":3}','ZIP',0,'SYNCED',0,NULL,'2024-06-20 11:14:29.000','2024-06-20 09:14:29.000','2024-06-20 11:14:29.000'),('842973df-2ee8-11ef-bb8b-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_82a44e97-2ee8-11ef-8dc9-d414e3397395/842973df-2ee8-11ef-bb8b-6ec2958327c0.pdf','PATIENT_0d66331b-2eda-11ef-8de3-d515e950d747_ACT_9a8959c0-2edd-11ef-8de3-d515e950d747_PROST_9a8dd9c0-2edd-11ef-8de3-d515e950d747_FORM','8230b105-2ee8-11ef-8dc9-d414e3397395.pdf','842973df-2ee8-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.1 Crown\",\"title\":\"Crown\"}','PDF',0,'SYNCED',0,NULL,'2024-06-20 11:36:03.000','2024-06-20 09:36:03.000','2024-06-20 11:36:03.000'),('8429be0d-2ee8-11ef-bb8b-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_82a44e97-2ee8-11ef-8dc9-d414e3397395/8429be0d-2ee8-11ef-bb8b-6ec2958327c0.xyz','PATIENT_0d66331b-2eda-11ef-8de3-d515e950d747_ACT_9a8959c0-2edd-11ef-8de3-d515e950d747_SESS_9a8a5a9c-2edd-11ef-8de3-d515e950d747_OCC_4eace0e6-2ee5-11ef-8dc9-d414e3397395_LIFIO','999f2a74-2ee5-11ef-8dc9-d414e3397395.xyz','8429be0d-2ee8-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.1 Occlusion o1 Maxilla u1 Finishing line 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY_1\",\"referenceScanFullDisplayId\":\"1.1_u1\",\"referenceScanId\":\"efafa8a6-2ee4-11ef-8dc9-d414e3397395\",\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-20 11:15:13.000','2024-06-20 09:15:13.000','2024-06-20 11:15:13.000'),('842bb5a1-2ee8-11ef-bb8b-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_82a44e97-2ee8-11ef-8dc9-d414e3397395/842bb5a1-2ee8-11ef-bb8b-6ec2958327c0.bin','PATIENT_0d66331b-2eda-11ef-8de3-d515e950d747_ACT_9a8959c0-2edd-11ef-8de3-d515e950d747_SESS_9a8a5a9c-2edd-11ef-8de3-d515e950d747_OCC_4eace0e6-2ee5-11ef-8dc9-d414e3397395_LIFIMO','999f2dfa-2ee5-11ef-8dc9-d414e3397395.bin','842bb5a1-2ee8-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.1 Occlusion o1 Maxilla u1 Metadata finishing line 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY_1\",\"referenceScanFullDisplayId\":\"1.1_u1\",\"referenceScanId\":\"efafa8a6-2ee4-11ef-8dc9-d414e3397395\",\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-20 11:15:13.000','2024-06-20 09:15:13.000','2024-06-20 11:15:13.000'),('842bff38-2ee8-11ef-bb8b-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_82a44e97-2ee8-11ef-8dc9-d414e3397395/842bff38-2ee8-11ef-bb8b-6ec2958327c0.png','PATIENT_0d66331b-2eda-11ef-8de3-d515e950d747_ACT_9a8959c0-2edd-11ef-8de3-d515e950d747_SESS_9a8a5a9c-2edd-11ef-8de3-d515e950d747_TOSC_efafa8a6-2ee4-11ef-8dc9-d414e3397395_SCREENS','b6800e55-2ee7-11ef-8dc9-d414e3397395.png','842bff38-2ee8-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.1 Maxilla u1 Screenshot 1\",\"title\":\"1\"}','PNG',0,'SYNCED',0,NULL,'2024-06-20 11:30:20.000','2024-06-20 09:30:20.000','2024-06-20 11:30:20.000'),('842c426e-2ee8-11ef-bb8b-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_82a44e97-2ee8-11ef-8dc9-d414e3397395/842c426e-2ee8-11ef-bb8b-6ec2958327c0.zip','PATIENT_0d66331b-2eda-11ef-8de3-d515e950d747_ACT_9a8959c0-2edd-11ef-8de3-d515e950d747_SESS_9a8a5a9c-2edd-11ef-8de3-d515e950d747_OCC_4eace0e6-2ee5-11ef-8dc9-d414e3397395_TO2','e69b549f-2ee5-11ef-8dc9-d414e3397395.zip','842c426e-2ee8-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.1 Occlusion o1 Maxilla u2\",\"modelMatrix\":\"0.472136,0.878125,0.0773602,0,-0.793392,0.461541,-0.396874,0,-0.38421,0.126001,0.914607,0,2.78486,1.94837,-12.4512,1\",\"occlusionMatrix\":\"-0.974235,-0.0712842,-0.213986,0,0.178517,0.336165,-0.924727,0,0.137853,-0.939106,-0.314777,0,-3.23437,8.78516,0.532764,1\",\"occlusionType\":2,\"referenceScanFullDisplayId\":\"1.1_u2\",\"referenceScanId\":\"a7e9085c-2ee5-11ef-8dc9-d414e3397395\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-20 11:17:22.000','2024-06-20 09:17:22.000','2024-06-20 11:17:22.000'),('848da4d1-2cbb-11ef-8e27-d518f78fe3c8',2,'/var/.scan4all/iris/data/2024/2/a1ace9b5-2271-11ef-8d76-d310d2ec2c14/session_84822f83-2cbb-11ef-8e27-d518f78fe3c8/occlusion_848cc83f-2cbb-11ef-8e27-d518f78fe3c8/scan_848d93a0-2cbb-11ef-8e27-d518f78fe3c8/848da4d1-2cbb-11ef-8e27-d518f78fe3c8.zip','PATIENT_a1ace9b5-2271-11ef-8d76-d310d2ec2c14_ACT_84822f83-2cbb-11ef-8e27-d518f78fe3c8_SESS_848cc83f-2cbb-11ef-8e27-d518f78fe3c8_BOSC_848d93a0-2cbb-11ef-8e27-d518f78fe3c8_MODEL','848da4d1-2cbb-11ef-8e27-d518f78fe3c8.zip','848da4d1-2cbb-11ef-8e27-d518f78fe3c8','{\"displayTitle\":\"2.5 Mandibule l1 [pc2]\",\"modelMatrix\":\"-0.878949,-0.40333,-0.254507,0,0.291084,-0.876413,0.383627,0,-0.377781,0.263106,0.887726,0,15.6373,0.394049,-6.74282,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-17 17:08:56.615','2024-06-17 15:08:56.650','2024-06-17 17:08:57.460'),('8492bebe-2cbb-11ef-8e27-d518f78fe3c8',2,'/var/.scan4all/iris/data/2024/2/a1ace9b5-2271-11ef-8d76-d310d2ec2c14/session_84822f83-2cbb-11ef-8e27-d518f78fe3c8/occlusion_848cc83f-2cbb-11ef-8e27-d518f78fe3c8/scan_848d93a0-2cbb-11ef-8e27-d518f78fe3c8/8492bebe-2cbb-11ef-8e27-d518f78fe3c8.png','PATIENT_a1ace9b5-2271-11ef-8d76-d310d2ec2c14_ACT_84822f83-2cbb-11ef-8e27-d518f78fe3c8_SESS_848cc83f-2cbb-11ef-8e27-d518f78fe3c8_BOSC_848d93a0-2cbb-11ef-8e27-d518f78fe3c8_SNAPS','8492bebe-2cbb-11ef-8e27-d518f78fe3c8.png','8492bebe-2cbb-11ef-8e27-d518f78fe3c8','{\"displayTitle\":\"2.5 Mandibule l1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-17 17:08:56.649','2024-06-17 15:08:56.650','2024-06-17 17:08:59.373'),('84af3b89-233b-11ef-8f93-d92a45da78c9',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_23e52d54-2338-11ef-8f93-d92a45da78c9/84af3b89-233b-11ef-8f93-d92a45da78c9.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_BOSC_23e52d54-2338-11ef-8f93-d92a45da78c9_SCREENS','84af3b89-233b-11ef-8f93-d92a45da78c9.png','84af3b89-233b-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Mandibule l1 Capture d\'écran 1 [pc1]\",\"title\":\"1\"}','PNG',0,'SYNCED',0,NULL,'2024-06-05 15:00:02.000','2024-06-05 13:00:02.000','2024-06-05 15:00:02.000'),('872b9301-2984-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_35920e04-2984-11ef-8e16-d517f37fa2ad/analyse_3596b1fd-2984-11ef-8e16-d517f37fa2ad/872b9301-2984-11ef-8e16-d517f37fa2ad.json','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_35920e04-2984-11ef-8e16-d517f37fa2ad_ANA_3596b1fd-2984-11ef-8e16-d517f37fa2ad_TRANS','872b9301-2984-11ef-8e16-d517f37fa2ad.json','4fbc922f-2984-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.6 Analisi c1\"}','JSON',1,'SYNCED',0,NULL,'2024-06-13 14:57:45.197','2024-06-13 12:57:45.198','2024-06-13 14:57:45.212'),('8782624a-2984-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_35920e04-2984-11ef-8e16-d517f37fa2ad/analyse_3596b1fd-2984-11ef-8e16-d517f37fa2ad/8782624a-2984-11ef-8e16-d517f37fa2ad.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_35920e04-2984-11ef-8e16-d517f37fa2ad_ANA_3596b1fd-2984-11ef-8e16-d517f37fa2ad_SNAPS','8782624a-2984-11ef-8e16-d517f37fa2ad.png','50033512-2984-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.6 Analisi c1\"}','PNG',1,'SYNCED',0,NULL,'2024-06-13 14:57:45.766','2024-06-13 12:57:45.768','2024-06-13 14:57:45.798'),('87d88f9b-2cba-11ef-bb8b-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_550eb27a-226b-11ef-8f1f-d8242c71b430/87d88f9b-2cba-11ef-bb8b-6ec2958327c0.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_521cc4b4-2a2d-11ef-8fb0-da2b4bf5ebbb_SESS_521e34c0-2a2d-11ef-8fb0-da2b4bf5ebbb_BOSC_7ddf36e7-2a2d-11ef-8fb0-da2b4bf5ebbb_MODEL','984c5dc8-2a2d-11ef-8fb0-da2b4bf5ebbb.zip','87d88f9b-2cba-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.15 Mandibule l1\",\"modelMatrix\":\"-0.878949,-0.40333,-0.254507,0,0.291084,-0.876413,0.383627,0,-0.377781,0.263106,0.887726,0,15.6373,0.394049,-6.74282,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-14 11:08:02.000','2024-06-14 09:08:02.000','2024-06-14 11:08:02.000'),('87db7d98-2cba-11ef-bb8b-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_550eb27a-226b-11ef-8f1f-d8242c71b430/87db7d98-2cba-11ef-bb8b-6ec2958327c0.png','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_521cc4b4-2a2d-11ef-8fb0-da2b4bf5ebbb_SESS_521e34c0-2a2d-11ef-8fb0-da2b4bf5ebbb_BOSC_7ddf36e7-2a2d-11ef-8fb0-da2b4bf5ebbb_SNAPS','984c747c-2a2d-11ef-8fb0-da2b4bf5ebbb.png','87db7d98-2cba-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.15 Mandibule l1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-14 11:08:02.000','2024-06-14 09:08:02.000','2024-06-14 11:08:02.000'),('8870875c-297e-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_cc35f9a3-297d-11ef-8e16-d517f37fa2ad/occlusion_cc37a7f7-297d-11ef-8e16-d517f37fa2ad/scan_cd2aac3c-297d-11ef-8e16-d517f37fa2ad/8870875c-297e-11ef-8e16-d517f37fa2ad.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_cc35f9a3-297d-11ef-8e16-d517f37fa2ad_SESS_cc37a7f7-297d-11ef-8e16-d517f37fa2ad_TOSC_cd2aac3c-297d-11ef-8e16-d517f37fa2ad_MODEL','8870875c-297e-11ef-8e16-d517f37fa2ad.zip','8870875c-297e-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.2 Mascella u1\",\"modelMatrix\":\"-0.0956275,0.983936,-0.15075,0,-0.970825,-0.125645,-0.204237,0,-0.219897,0.126821,0.967244,0,-13.057,-28.6755,-11.14,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 14:15:05.000','2024-06-13 12:15:05.000','2024-06-13 14:15:05.000'),('88709f91-297e-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_cc35f9a3-297d-11ef-8e16-d517f37fa2ad/occlusion_cc37a7f7-297d-11ef-8e16-d517f37fa2ad/scan_cd2aac3c-297d-11ef-8e16-d517f37fa2ad/88709f91-297e-11ef-8e16-d517f37fa2ad.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_cc35f9a3-297d-11ef-8e16-d517f37fa2ad_SESS_cc37a7f7-297d-11ef-8e16-d517f37fa2ad_TOSC_cd2aac3c-297d-11ef-8e16-d517f37fa2ad_SNAPS','88709f91-297e-11ef-8e16-d517f37fa2ad.png','88709f91-297e-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.2 Mascella u1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 14:15:06.000','2024-06-13 12:15:06.000','2024-06-13 14:15:06.000'),('8b9c18a2-2985-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_a8885309-2984-11ef-8e16-d517f37fa2ad/occlusion_a888b842-2984-11ef-8e16-d517f37fa2ad/computedocclusion_456d151a-2985-11ef-8e16-d517f37fa2ad/8b9c18a2-2985-11ef-8e16-d517f37fa2ad.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_a8885309-2984-11ef-8e16-d517f37fa2ad_SESS_a888b842-2984-11ef-8e16-d517f37fa2ad_OCC_456d151a-2985-11ef-8e16-d517f37fa2ad_TO1','8b9c18a2-2985-11ef-8e16-d517f37fa2ad.zip','74b221fa-2985-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.7 Occlusione o1 Mascella u2\",\"modelMatrix\":\"0.676804,-0.736112,0.00867294,0,0.735905,0.676831,0.0185321,0,-0.0195118,-0.00616012,0.999791,0,-5.57178,10.6847,-13.2414,1\",\"occlusionMatrix\":\"-0.990244,-0.0271544,-0.136818,0,0.124249,0.274088,-0.953659,0,0.0633954,-0.961328,-0.268033,0,11.375,8.00379,2.50767,1\",\"occlusionType\":2,\"referenceScanFullDisplayId\":\"7.1_u2\",\"referenceScanId\":\"de3fd237-2984-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2024-06-13 15:05:02.142','2024-06-13 13:05:35.530','2024-06-13 15:05:42.607'),('8c08eecf-2278-11ef-8d76-d310d2ec2c14',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/computedocclusion_9ed6352b-2277-11ef-8d76-d310d2ec2c14/8c08eecf-2278-11ef-8d76-d310d2ec2c14.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_OCC_9ed6352b-2277-11ef-8d76-d310d2ec2c14_TO1','8c08eecf-2278-11ef-8d76-d310d2ec2c14.zip','5adbc9bc-2278-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Occlusion o2 Maxillaire u1 [pc2]\",\"modelMatrix\":\"-0.0834467,0.986107,-0.143628,0,-0.981709,-0.1061,-0.158085,0,-0.171128,0.12781,0.976924,0,-17.1278,-28.7907,-11.2181,1\",\"occlusionMatrix\":\"-0.0756181,0.13399,0.988093,0,-0.98681,0.13219,-0.0934457,0,-0.143138,-0.982127,0.122228,0,-17.9384,11.0046,-27.4488,1\",\"occlusionType\":5,\"referenceScanFullDisplayId\":\"1.2_u1\",\"referenceScanId\":\"f3b0649e-2272-11ef-8d76-d310d2ec2c14\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2024-06-04 15:44:22.000','2024-06-04 13:44:22.000','2024-06-04 15:44:22.000'),('8c6c7633-2e0d-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/4382037a-2735-11ef-8e16-d517f37fa1ab/session_be9a8e99-2735-11ef-8e16-d517f37fa1ab/occlusion_be9c5752-2735-11ef-8e16-d517f37fa1ab/scan_7b212ac0-2e0d-11ef-8deb-d515ea58f6cb/8c6c7633-2e0d-11ef-8deb-d515ea58f6cb.json','PATIENT_4382037a-2735-11ef-8e16-d517f37fa1ab_ACT_be9a8e99-2735-11ef-8e16-d517f37fa1ab_SESS_be9c5752-2735-11ef-8e16-d517f37fa1ab_TOSC_7b212ac0-2e0d-11ef-8deb-d515ea58f6cb_METER','8c6c7633-2e0d-11ef-8deb-d515ea58f6cb.json','8c6c7633-2e0d-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"6.1 Maxillaire u2 Mesure [pc2]\"}','JSON',0,'SYNCED',0,NULL,'2024-06-19 09:28:40.359','2024-06-19 07:28:40.393','2024-06-19 12:49:23.648'),('8d1feec9-2a2f-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/scan_aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd/8d1feec9-2a2f-11ef-8f1c-d8242c6fa8fd.png','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_BOSC_aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd_SCREENS','8d1feec9-2a2f-11ef-8f1c-d8242c6fa8fd.png','8d1feec9-2a2f-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Mandibola l2 Screenshot 3\",\"title\":\"3\"}','PNG',0,'SYNCED',0,NULL,'2024-06-14 11:22:01.000','2024-06-14 09:22:01.000','2024-06-14 11:22:01.000'),('8e2e7cc7-2738-11ef-8e16-d517f37fa1ab',2,'/var/.scan4all/iris/data/2024/2/a1ace9b5-2271-11ef-8d76-d310d2ec2c14/session_1cb775ae-271f-11ef-8e16-d517f37fa1ab/order_1cba063b-271f-11ef-8e16-d517f37fa1ab/8e2e7cc7-2738-11ef-8e16-d517f37fa1ab.pdf','PATIENT_a1ace9b5-2271-11ef-8d76-d310d2ec2c14_ACT_1cb775ae-271f-11ef-8e16-d517f37fa1ab_PROST_1cba063b-271f-11ef-8e16-d517f37fa1ab_FORM','8e2e7cc7-2738-11ef-8e16-d517f37fa1ab.pdf','8e2e7cc7-2738-11ef-8e16-d517f37fa1ab','{\"displayTitle\":\"2.2 Facette [pc2]\",\"title\":\"Facette\"}','PDF',0,'SYNCED',0,NULL,'2024-06-10 16:48:54.000','2024-06-10 14:48:54.000','2024-06-10 16:48:54.000'),('8f283140-28c9-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/a9fa9552-28c9-11ef-8e16-d517f37fa2ad/session_6a002ae5-28c9-11ef-8e16-d517f37fa2ad/occlusion_6a00fa35-28c9-11ef-8e16-d517f37fa2ad/scan_6b7e666e-28c9-11ef-8e16-d517f37fa2ad/8f283140-28c9-11ef-8e16-d517f37fa2ad.zip','PATIENT_a9fa9552-28c9-11ef-8e16-d517f37fa2ad_ACT_6a002ae5-28c9-11ef-8e16-d517f37fa2ad_SESS_6a00fa35-28c9-11ef-8e16-d517f37fa2ad_BOSC_6b7e666e-28c9-11ef-8e16-d517f37fa2ad_MODEL','8f283140-28c9-11ef-8e16-d517f37fa2ad.zip','8f283140-28c9-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.1 Mandibule l1\",\"modelMatrix\":\"-0.665352,-0.737931,-0.112979,0,0.66217,-0.653252,0.36714,0,-0.344728,0.169466,0.923279,0,9.85925,8.04115,-7.86443,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-12 16:39:22.708','2024-06-12 14:40:14.294','2024-06-12 16:40:15.035'),('8f28484b-28c9-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/a9fa9552-28c9-11ef-8e16-d517f37fa2ad/session_6a002ae5-28c9-11ef-8e16-d517f37fa2ad/occlusion_6a00fa35-28c9-11ef-8e16-d517f37fa2ad/scan_6b7e666e-28c9-11ef-8e16-d517f37fa2ad/8f28484b-28c9-11ef-8e16-d517f37fa2ad.png','PATIENT_a9fa9552-28c9-11ef-8e16-d517f37fa2ad_ACT_6a002ae5-28c9-11ef-8e16-d517f37fa2ad_SESS_6a00fa35-28c9-11ef-8e16-d517f37fa2ad_BOSC_6b7e666e-28c9-11ef-8e16-d517f37fa2ad_SNAPS','8f28484b-28c9-11ef-8e16-d517f37fa2ad.png','8f28484b-28c9-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.1 Mandibule l1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-12 16:39:22.709','2024-06-12 14:40:14.294','2024-06-12 16:40:15.935'),('8f6d6658-2740-11ef-8e09-d517f1736dc8',2,'/var/.scan4all/iris/data/2024/2/8f5ceea7-2740-11ef-8e09-d517f1736dc8/session_8f6c8859-2740-11ef-8e09-d517f1736dc8/occlusion_8f6cf168-2740-11ef-8e09-d517f1736dc8/scan_8f6d5887-2740-11ef-8e09-d517f1736dc8/8f6d6658-2740-11ef-8e09-d517f1736dc8.zip','PATIENT_8f5ceea7-2740-11ef-8e09-d517f1736dc8_ACT_8f6c8859-2740-11ef-8e09-d517f1736dc8_SESS_8f6cf168-2740-11ef-8e09-d517f1736dc8_TOSC_8f6d5887-2740-11ef-8e09-d517f1736dc8_MODEL','8f6d6658-2740-11ef-8e09-d517f1736dc8.zip','8f6d6658-2740-11ef-8e09-d517f1736dc8','{\"displayTitle\":\"12.1 Maxillaire u1 [pc2]\",\"modelMatrix\":\"0.998773,-0.00202182,-0.0494821,0,0.00445529,0.998783,0.0491187,0,0.0493226,-0.0492789,0.997566,0,1.86586,2.73136,-15.9281,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-10 17:46:10.947','2024-06-10 15:46:10.986','2024-06-10 17:46:12.707'),('8f72ef2a-2740-11ef-8e09-d517f1736dc8',2,'/var/.scan4all/iris/data/2024/2/8f5ceea7-2740-11ef-8e09-d517f1736dc8/session_8f6c8859-2740-11ef-8e09-d517f1736dc8/occlusion_8f6cf168-2740-11ef-8e09-d517f1736dc8/scan_8f6d5887-2740-11ef-8e09-d517f1736dc8/8f72ef2a-2740-11ef-8e09-d517f1736dc8.png','PATIENT_8f5ceea7-2740-11ef-8e09-d517f1736dc8_ACT_8f6c8859-2740-11ef-8e09-d517f1736dc8_SESS_8f6cf168-2740-11ef-8e09-d517f1736dc8_TOSC_8f6d5887-2740-11ef-8e09-d517f1736dc8_SNAPS','8f72ef2a-2740-11ef-8e09-d517f1736dc8.png','8f72ef2a-2740-11ef-8e09-d517f1736dc8','{\"displayTitle\":\"12.1 Maxillaire u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-10 17:46:10.983','2024-06-10 15:46:10.989','2024-06-10 17:46:15.040'),('8f9ceac9-2970-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_8e81ab09-296b-11ef-8e16-d517f37fa2ad/occlusion_8e83509f-296b-11ef-8e16-d517f37fa2ad/computedocclusion_453321dd-296f-11ef-8e16-d517f37fa2ad/8f9ceac9-2970-11ef-8e16-d517f37fa2ad.png','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_SESS_8e83509f-296b-11ef-8e16-d517f37fa2ad_OCC_453321dd-296f-11ef-8e16-d517f37fa2ad_SCREENO','8f9ceac9-2970-11ef-8e16-d517f37fa2ad.png','8f9ceac9-2970-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Occlusione o1 Screenshot 1\",\"occlusionType\":1,\"title\":\"1\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 12:34:51.000','2024-06-13 10:34:51.000','2024-06-13 12:34:51.000'),('9005271a-2273-11ef-8d76-d310d2ec2c14',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/scan_f3b0649e-2272-11ef-8d76-d310d2ec2c14/9005271a-2273-11ef-8d76-d310d2ec2c14.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_TOSC_f3b0649e-2272-11ef-8d76-d310d2ec2c14_MODEL','9005271a-2273-11ef-8d76-d310d2ec2c14.zip','9005271a-2273-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Maxillaire u1 [pc2]\",\"modelMatrix\":\"-0.0834467,0.986107,-0.143628,0,-0.981709,-0.1061,-0.158085,0,-0.171128,0.12781,0.976924,0,-17.1278,-28.7907,-11.2181,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 15:08:45.000','2024-06-04 13:08:45.000','2024-06-04 15:08:45.000'),('90053a20-2273-11ef-8d76-d310d2ec2c14',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/scan_f3b0649e-2272-11ef-8d76-d310d2ec2c14/90053a20-2273-11ef-8d76-d310d2ec2c14.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_TOSC_f3b0649e-2272-11ef-8d76-d310d2ec2c14_SNAPS','90053a20-2273-11ef-8d76-d310d2ec2c14.png','90053a20-2273-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Maxillaire u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 15:08:45.000','2024-06-04 13:08:45.000','2024-06-04 15:08:45.000'),('90d40af7-289b-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/f373c86a-2899-11ef-8e16-d517f37fa2ad/session_627cfe1c-289b-11ef-8e16-d517f37fa2ad/occlusion_627f5b3e-289b-11ef-8e16-d517f37fa2ad/scan_804316c5-289b-11ef-8e16-d517f37fa2ad/90d40af7-289b-11ef-8e16-d517f37fa2ad.zip','PATIENT_f373c86a-2899-11ef-8e16-d517f37fa2ad_ACT_627cfe1c-289b-11ef-8e16-d517f37fa2ad_SESS_627f5b3e-289b-11ef-8e16-d517f37fa2ad_BOSC_804316c5-289b-11ef-8e16-d517f37fa2ad_MODEL','90d40af7-289b-11ef-8e16-d517f37fa2ad.zip','90d40af7-289b-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.2 Mandibule l1\",\"modelMatrix\":\"-0.909549,-0.393315,-0.134253,0,0.358828,-0.906181,0.22378,0,-0.209674,0.155365,0.965349,0,11.4657,-0.465422,-11.5412,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-12 11:10:11.000','2024-06-12 09:39:26.000','2024-06-12 11:39:26.000'),('90d41939-289b-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/f373c86a-2899-11ef-8e16-d517f37fa2ad/session_627cfe1c-289b-11ef-8e16-d517f37fa2ad/occlusion_627f5b3e-289b-11ef-8e16-d517f37fa2ad/scan_804316c5-289b-11ef-8e16-d517f37fa2ad/90d41939-289b-11ef-8e16-d517f37fa2ad.png','PATIENT_f373c86a-2899-11ef-8e16-d517f37fa2ad_ACT_627cfe1c-289b-11ef-8e16-d517f37fa2ad_SESS_627f5b3e-289b-11ef-8e16-d517f37fa2ad_BOSC_804316c5-289b-11ef-8e16-d517f37fa2ad_SNAPS','90d41939-289b-11ef-8e16-d517f37fa2ad.png','90d41939-289b-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.2 Mandibule l1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-12 11:10:12.000','2024-06-12 09:39:26.000','2024-06-12 11:39:26.000'),('911bf499-2e44-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/4382037a-2735-11ef-8e16-d517f37fa1ab/session_8598ee4a-2e40-11ef-8deb-d515ea58f6cb/occlusion_859bd7ba-2e40-11ef-8deb-d515ea58f6cb/scan_0cf35705-2e42-11ef-8deb-d515ea58f6cb/911bf499-2e44-11ef-8deb-d515ea58f6cb.ply','PATIENT_4382037a-2735-11ef-8e16-d517f37fa1ab_ACT_8598ee4a-2e40-11ef-8deb-d515ea58f6cb_SESS_859bd7ba-2e40-11ef-8deb-d515ea58f6cb_BOSC_0cf35705-2e42-11ef-8deb-d515ea58f6cb_SEG','911bf499-2e44-11ef-8deb-d515ea58f6cb.ply','911bf499-2e44-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"6.3 Mandibola l1 Segmentazione [pc2]\"}','PLY',0,'SYNCED',0,NULL,'2024-06-19 16:02:30.540','2024-06-19 14:02:30.551','2024-06-19 16:02:30.971'),('912d936b-2e43-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/4382037a-2735-11ef-8e16-d517f37fa1ab/session_164199d1-2e43-11ef-8deb-d515ea58f6cb/order_164af3dc-2e43-11ef-8deb-d515ea58f6cb/912d936b-2e43-11ef-8deb-d515ea58f6cb.pdf','PATIENT_4382037a-2735-11ef-8e16-d517f37fa1ab_ACT_164199d1-2e43-11ef-8deb-d515ea58f6cb_PROST_164af3dc-2e43-11ef-8deb-d515ea58f6cb_FORM','912d936b-2e43-11ef-8deb-d515ea58f6cb.pdf','912d936b-2e43-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"6.5 Other [pc2]\",\"title\":\"Other\"}','PDF',0,'SYNCED',0,NULL,'2024-06-19 15:55:22.000','2024-06-19 13:55:22.000','2024-06-19 15:55:22.000'),('92bce3d8-2277-11ef-8d76-d310d2ec2c14',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/computedocclusion_43733a85-2274-11ef-8d76-d310d2ec2c14/92bce3d8-2277-11ef-8d76-d310d2ec2c14.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_OCC_43733a85-2274-11ef-8d76-d310d2ec2c14_BO1','92bce3d8-2277-11ef-8d76-d310d2ec2c14.zip','e1cab74d-2274-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Occlusion o1 Mandibule l1 [pc2]\",\"modelMatrix\":\"0.135656,-0.982642,-0.126536,0,0.970104,0.157682,-0.184485,0,0.201235,-0.0977264,0.974656,0,-23.8369,18.6095,-10.139,1\",\"occlusionMatrix\":\"-0.842695,-0.506819,-0.181668,0,0.186223,0.0422226,-0.981598,0,0.505166,-0.861022,0.0587989,0,0.0566292,48.7947,0.295203,1\",\"occlusionType\":5,\"referenceScanFullDisplayId\":\"1.2_l1\",\"referenceScanId\":\"96d08283-2273-11ef-8d76-d310d2ec2c14\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,'2024-06-04 15:37:40.463','2024-06-04 15:37:40.463','2024-06-04 13:37:40.464','2024-06-04 15:37:40.472'),('92d82f66-2985-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_a8885309-2984-11ef-8e16-d517f37fa2ad/occlusion_a888b842-2984-11ef-8e16-d517f37fa2ad/computedocclusion_456d151a-2985-11ef-8e16-d517f37fa2ad/92d82f66-2985-11ef-8e16-d517f37fa2ad.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_a8885309-2984-11ef-8e16-d517f37fa2ad_SESS_a888b842-2984-11ef-8e16-d517f37fa2ad_OCC_456d151a-2985-11ef-8e16-d517f37fa2ad_BO1','92d82f66-2985-11ef-8e16-d517f37fa2ad.zip','74cbc798-2985-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.7 Occlusione o1 Mandibola l1\",\"modelMatrix\":\"0.959092,0.272161,-0.0779181,0,-0.260339,0.739812,-0.620405,0,-0.111206,0.615311,0.780401,0,-10.6931,-9.10435,-8.84207,1\",\"occlusionMatrix\":\"-0.986564,-0.0908028,-0.135919,0,-0.0671007,-0.533271,0.843283,0,-0.149056,0.841065,0.520006,0,14.2415,-5.81863,-4.10972,1\",\"occlusionType\":2,\"referenceScanFullDisplayId\":\"7.1_l1\",\"referenceScanId\":\"1d4719f4-2985-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2024-06-13 15:05:14.280','2024-06-13 13:05:35.531','2024-06-13 15:05:43.883'),('92fde47f-2e36-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_3654e763-2e35-11ef-8deb-d515ea58f6cb/occlusion_36556270-2e35-11ef-8deb-d515ea58f6cb/scan_1e568150-2e36-11ef-8deb-d515ea58f6cb/92fde47f-2e36-11ef-8deb-d515ea58f6cb.ply','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_3654e763-2e35-11ef-8deb-d515ea58f6cb_SESS_36556270-2e35-11ef-8deb-d515ea58f6cb_BOSC_1e568150-2e36-11ef-8deb-d515ea58f6cb_SEG','92fde47f-2e36-11ef-8deb-d515ea58f6cb.ply','62387fc2-2e36-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.1 Mandibola l1 Segmentazione [pc2]\"}','PLY',1,'SYNCED',0,NULL,'2024-06-19 14:22:20.744','2024-06-19 12:22:20.765','2024-06-19 14:22:20.978'),('9484c123-225d-11ef-8f1f-d8242c71b430',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_e3862d66-225a-11ef-8f1f-d8242c71b430/occlusion_e3868e5f-225a-11ef-8f1f-d8242c71b430/scan_e52279ce-225a-11ef-8f1f-d8242c71b430/9484c123-225d-11ef-8f1f-d8242c71b430.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_SESS_e3868e5f-225a-11ef-8f1f-d8242c71b430_TOSC_e52279ce-225a-11ef-8f1f-d8242c71b430_SCREENS','9484c123-225d-11ef-8f1f-d8242c71b430.png','9484c123-225d-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.1 Maxillaire u1 Capture d\'écran n°16\",\"title\":\"n°16\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 12:32:41.000','2024-06-04 10:32:41.000','2024-06-04 12:32:41.000'),('94f64547-2a21-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_72b8db7f-2a20-11ef-8f1c-d8242c6fa8fd/occlusion_72bbb4c0-2a20-11ef-8f1c-d8242c6fa8fd/scan_e97f72f6-2a20-11ef-8f1c-d8242c6fa8fd/94f64547-2a21-11ef-8f1c-d8242c6fa8fd.zip','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_72b8db7f-2a20-11ef-8f1c-d8242c6fa8fd_SESS_72bbb4c0-2a20-11ef-8f1c-d8242c6fa8fd_TOSC_e97f72f6-2a20-11ef-8f1c-d8242c6fa8fd_MODEL','94f64547-2a21-11ef-8f1c-d8242c6fa8fd.zip','94f64547-2a21-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.1 Mascella u1\",\"modelMatrix\":\"-0.797212,0.601462,-0.0519342,0,-0.564391,-0.773074,-0.289516,0,-0.214282,-0.201494,0.955763,0,28.7386,-6.20235,-12.5869,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,'2024-06-14 09:42:34.607','2024-06-14 09:42:00.842','2024-06-14 07:42:34.611','2024-06-14 09:42:34.633'),('94f65e70-2a21-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_72b8db7f-2a20-11ef-8f1c-d8242c6fa8fd/occlusion_72bbb4c0-2a20-11ef-8f1c-d8242c6fa8fd/scan_e97f72f6-2a20-11ef-8f1c-d8242c6fa8fd/94f65e70-2a21-11ef-8f1c-d8242c6fa8fd.png','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_72b8db7f-2a20-11ef-8f1c-d8242c6fa8fd_SESS_72bbb4c0-2a20-11ef-8f1c-d8242c6fa8fd_TOSC_e97f72f6-2a20-11ef-8f1c-d8242c6fa8fd_SNAPS','94f65e70-2a21-11ef-8f1c-d8242c6fa8fd.png','94f65e70-2a21-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.1 Mascella u1 Snapshot\"}','PNG',0,'CREATED',0,'2024-06-14 09:42:34.607','2024-06-14 09:42:00.843','2024-06-14 07:42:34.613','2024-06-14 09:42:34.634'),('953cbc38-2e42-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/4382037a-2735-11ef-8e16-d517f37fa1ab/session_68af0333-2e42-11ef-8deb-d515ea58f6cb/occlusion_68b10ccb-2e42-11ef-8deb-d515ea58f6cb/scan_70f3c64d-2e42-11ef-8deb-d515ea58f6cb/953cbc38-2e42-11ef-8deb-d515ea58f6cb.zip','PATIENT_4382037a-2735-11ef-8e16-d517f37fa1ab_ACT_68af0333-2e42-11ef-8deb-d515ea58f6cb_SESS_68b10ccb-2e42-11ef-8deb-d515ea58f6cb_TOSC_70f3c64d-2e42-11ef-8deb-d515ea58f6cb_MODEL','953cbc38-2e42-11ef-8deb-d515ea58f6cb.zip','953cbc38-2e42-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"6.4 Maxilla u1 [pc2]\",\"modelMatrix\":\"-0.992348,-0.0918829,-0.0824853,0,0.0848748,-0.992777,0.0847908,0,-0.0896804,0.077141,0.992979,0,4.97689,0.487049,-11.0551,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-19 15:48:21.000','2024-06-19 13:48:21.000','2024-06-19 15:48:21.000'),('953ccd86-2e42-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/4382037a-2735-11ef-8e16-d517f37fa1ab/session_68af0333-2e42-11ef-8deb-d515ea58f6cb/occlusion_68b10ccb-2e42-11ef-8deb-d515ea58f6cb/scan_70f3c64d-2e42-11ef-8deb-d515ea58f6cb/953ccd86-2e42-11ef-8deb-d515ea58f6cb.png','PATIENT_4382037a-2735-11ef-8e16-d517f37fa1ab_ACT_68af0333-2e42-11ef-8deb-d515ea58f6cb_SESS_68b10ccb-2e42-11ef-8deb-d515ea58f6cb_TOSC_70f3c64d-2e42-11ef-8deb-d515ea58f6cb_SNAPS','953ccd86-2e42-11ef-8deb-d515ea58f6cb.png','953ccd86-2e42-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"6.4 Maxilla u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-19 15:48:21.000','2024-06-19 13:48:21.000','2024-06-19 15:48:21.000'),('9584d053-2a2e-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/scan_80540c46-2a2a-11ef-8f1c-d8242c6fa8fd/9584d053-2a2e-11ef-8f1c-d8242c6fa8fd.ply','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_BOSC_80540c46-2a2a-11ef-8f1c-d8242c6fa8fd_SEG','9584d053-2a2e-11ef-8f1c-d8242c6fa8fd.ply','9584d053-2a2e-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Mandibola l1 Segmentazione\"}','PLY',0,'SYNCED',0,NULL,'2024-06-14 11:15:05.234','2024-06-14 09:15:05.271','2024-06-14 11:15:05.563'),('95dfa34a-2970-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_8e81ab09-296b-11ef-8e16-d517f37fa2ad/occlusion_8e83509f-296b-11ef-8e16-d517f37fa2ad/computedocclusion_453321dd-296f-11ef-8e16-d517f37fa2ad/95dfa34a-2970-11ef-8e16-d517f37fa2ad.json','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_SESS_8e83509f-296b-11ef-8e16-d517f37fa2ad_OCC_453321dd-296f-11ef-8e16-d517f37fa2ad_METER','95dfa34a-2970-11ef-8e16-d517f37fa2ad.json','95dfa34a-2970-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Occlusione o1\",\"occlusionType\":1}','JSON',0,'SYNCED',0,NULL,'2024-06-13 12:35:01.000','2024-06-13 10:35:01.000','2024-06-13 12:35:01.000'),('961d3bd6-2738-11ef-867c-6ec2958327c0',5,'/var/.scan4all/iris/data/2024/5/discussion_8e7e9088-2733-11ef-8e16-d517f37fa1ab/961d3bd6-2738-11ef-867c-6ec2958327c0.zip','PATIENT_a1ace9b5-2271-11ef-8d76-d310d2ec2c14_ACT_1cb775ae-271f-11ef-8e16-d517f37fa1ab_SESS_1cb90d11-271f-11ef-8e16-d517f37fa1ab_TOSC_1db1e2d3-271f-11ef-8e16-d517f37fa1ab_MODEL','3326d65f-2720-11ef-8e16-d517f37fa1ab.zip','961d3bd6-2738-11ef-867c-6ec2958327c0','{\"displayTitle\":\"2.2 Maxillaire u1 [pc2]\",\"modelMatrix\":\"-0.101025,-0.990067,-0.0977805,0,0.982413,-0.0837627,-0.166879,0,0.157031,-0.11292,0.981117,0,-24.5185,22.6171,-11.9571,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-10 15:34:29.000','2024-06-10 13:34:29.000','2024-06-10 15:34:29.000'),('961d9540-2738-11ef-867c-6ec2958327c0',5,'/var/.scan4all/iris/data/2024/5/discussion_8e7e9088-2733-11ef-8e16-d517f37fa1ab/961d9540-2738-11ef-867c-6ec2958327c0.png','PATIENT_a1ace9b5-2271-11ef-8d76-d310d2ec2c14_ACT_1cb775ae-271f-11ef-8e16-d517f37fa1ab_SESS_1cb90d11-271f-11ef-8e16-d517f37fa1ab_TOSC_1db1e2d3-271f-11ef-8e16-d517f37fa1ab_SNAPS','3326f9f5-2720-11ef-8e16-d517f37fa1ab.png','961d9540-2738-11ef-867c-6ec2958327c0','{\"displayTitle\":\"2.2 Maxillaire u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-10 15:34:29.000','2024-06-10 13:34:29.000','2024-06-10 15:34:29.000'),('961de917-2738-11ef-867c-6ec2958327c0',5,'/var/.scan4all/iris/data/2024/5/discussion_8e7e9088-2733-11ef-8e16-d517f37fa1ab/961de917-2738-11ef-867c-6ec2958327c0.zip','PATIENT_a1ace9b5-2271-11ef-8d76-d310d2ec2c14_ACT_1cb775ae-271f-11ef-8e16-d517f37fa1ab_SESS_1cb90d11-271f-11ef-8e16-d517f37fa1ab_TOSC_424c596f-2720-11ef-8e16-d517f37fa1ab_MODEL','73b17774-2720-11ef-8e16-d517f37fa1ab.zip','961de917-2738-11ef-867c-6ec2958327c0','{\"displayTitle\":\"2.2 Maxillaire u2 [pc2]\",\"modelMatrix\":\"-0.630539,-0.775209,-0.0383597,0,0.768978,-0.63065,0.104661,0,-0.105326,0.0364953,0.993768,0,9.39433,12.4536,-12.9982,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-10 15:34:31.000','2024-06-10 13:34:31.000','2024-06-10 15:34:31.000'),('961ee4a5-2738-11ef-867c-6ec2958327c0',5,'/var/.scan4all/iris/data/2024/5/discussion_8e7e9088-2733-11ef-8e16-d517f37fa1ab/961ee4a5-2738-11ef-867c-6ec2958327c0.png','PATIENT_a1ace9b5-2271-11ef-8d76-d310d2ec2c14_ACT_1cb775ae-271f-11ef-8e16-d517f37fa1ab_SESS_1cb90d11-271f-11ef-8e16-d517f37fa1ab_TOSC_424c596f-2720-11ef-8e16-d517f37fa1ab_SNAPS','73b18674-2720-11ef-8e16-d517f37fa1ab.png','961ee4a5-2738-11ef-867c-6ec2958327c0','{\"displayTitle\":\"2.2 Maxillaire u2 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-10 15:34:32.000','2024-06-10 13:34:32.000','2024-06-10 15:34:32.000'),('961f37ca-2738-11ef-867c-6ec2958327c0',5,'/var/.scan4all/iris/data/2024/5/discussion_8e7e9088-2733-11ef-8e16-d517f37fa1ab/961f37ca-2738-11ef-867c-6ec2958327c0.pdf','PATIENT_a1ace9b5-2271-11ef-8d76-d310d2ec2c14_ACT_1cb775ae-271f-11ef-8e16-d517f37fa1ab_PROST_1cba063b-271f-11ef-8e16-d517f37fa1ab_FORM','8e2e7cc7-2738-11ef-8e16-d517f37fa1ab.pdf','961f37ca-2738-11ef-867c-6ec2958327c0','{\"displayTitle\":\"2.2 Facette [pc2]\",\"title\":\"Facette\"}','PDF',0,'SYNCED',0,NULL,'2024-06-10 16:48:54.000','2024-06-10 14:48:54.000','2024-06-10 16:48:54.000'),('961f7d3f-2738-11ef-867c-6ec2958327c0',5,'/var/.scan4all/iris/data/2024/5/discussion_8e7e9088-2733-11ef-8e16-d517f37fa1ab/961f7d3f-2738-11ef-867c-6ec2958327c0.xyz','PATIENT_a1ace9b5-2271-11ef-8d76-d310d2ec2c14_ACT_1cb775ae-271f-11ef-8e16-d517f37fa1ab_SESS_1cb90d11-271f-11ef-8e16-d517f37fa1ab_TOSC_1db1e2d3-271f-11ef-8e16-d517f37fa1ab_LIFI','e4230834-2737-11ef-8e16-d517f37fa1ab.xyz','961f7d3f-2738-11ef-867c-6ec2958327c0','{\"displayTitle\":\"2.2 Maxillaire u1 Ligne de finition 0 [pc2]\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-10 16:44:08.000','2024-06-10 14:44:08.000','2024-06-10 16:44:08.000'),('961fcfdc-2738-11ef-867c-6ec2958327c0',5,'/var/.scan4all/iris/data/2024/5/discussion_8e7e9088-2733-11ef-8e16-d517f37fa1ab/961fcfdc-2738-11ef-867c-6ec2958327c0.bin','PATIENT_a1ace9b5-2271-11ef-8d76-d310d2ec2c14_ACT_1cb775ae-271f-11ef-8e16-d517f37fa1ab_SESS_1cb90d11-271f-11ef-8e16-d517f37fa1ab_TOSC_1db1e2d3-271f-11ef-8e16-d517f37fa1ab_LIFIM','e42318eb-2737-11ef-8e16-d517f37fa1ab.bin','961fcfdc-2738-11ef-867c-6ec2958327c0','{\"displayTitle\":\"2.2 Maxillaire u1 Ligne de finition métadonnées 0 [pc2]\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-10 16:44:08.000','2024-06-10 14:44:08.000','2024-06-10 16:44:08.000'),('97c7263b-2e4b-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/115617bc-2e4b-11ef-8deb-d515ea58f6cb/session_15f71dc7-2e4b-11ef-8deb-d515ea58f6cb/occlusion_15f94c3c-2e4b-11ef-8deb-d515ea58f6cb/scan_7b449582-2e4b-11ef-8deb-d515ea58f6cb/97c7263b-2e4b-11ef-8deb-d515ea58f6cb.zip','PATIENT_115617bc-2e4b-11ef-8deb-d515ea58f6cb_ACT_15f71dc7-2e4b-11ef-8deb-d515ea58f6cb_SESS_15f94c3c-2e4b-11ef-8deb-d515ea58f6cb_LESC_7b449582-2e4b-11ef-8deb-d515ea58f6cb_MODEL','97c7263b-2e4b-11ef-8deb-d515ea58f6cb.zip','97c7263b-2e4b-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"17.1 Left bite bl1 [pc2]\",\"modelMatrix\":\"-0.98483,0.141205,-0.0828067,0,-0.160668,-0.981397,0.122196,0,-0.0663995,0.130486,0.989056,0,7.97743,-6.81995,-10.3948,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-19 16:52:48.205','2024-06-19 14:52:48.533','2024-06-19 16:52:50.853'),('97c73c0b-2e4b-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/115617bc-2e4b-11ef-8deb-d515ea58f6cb/session_15f71dc7-2e4b-11ef-8deb-d515ea58f6cb/occlusion_15f94c3c-2e4b-11ef-8deb-d515ea58f6cb/scan_7b449582-2e4b-11ef-8deb-d515ea58f6cb/97c73c0b-2e4b-11ef-8deb-d515ea58f6cb.png','PATIENT_115617bc-2e4b-11ef-8deb-d515ea58f6cb_ACT_15f71dc7-2e4b-11ef-8deb-d515ea58f6cb_SESS_15f94c3c-2e4b-11ef-8deb-d515ea58f6cb_LESC_7b449582-2e4b-11ef-8deb-d515ea58f6cb_SNAPS','97c73c0b-2e4b-11ef-8deb-d515ea58f6cb.png','97c73c0b-2e4b-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"17.1 Left bite bl1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-19 16:52:48.206','2024-06-19 14:52:48.533','2024-06-19 16:52:51.672'),('98099d24-27cb-11ef-8e37-d519fa9d22d2',2,'/var/.scan4all/iris/data/2024/2/3573ee42-27cb-11ef-8e37-d519fa9d22d2/session_80d26da8-27cb-11ef-8e37-d519fa9d22d2/occlusion_80d4d06a-27cb-11ef-8e37-d519fa9d22d2/scan_81adf7a6-27cb-11ef-8e37-d519fa9d22d2/98099d24-27cb-11ef-8e37-d519fa9d22d2.zip','PATIENT_3573ee42-27cb-11ef-8e37-d519fa9d22d2_ACT_80d26da8-27cb-11ef-8e37-d519fa9d22d2_SESS_80d4d06a-27cb-11ef-8e37-d519fa9d22d2_TOSC_81adf7a6-27cb-11ef-8e37-d519fa9d22d2_MODEL','98099d24-27cb-11ef-8e37-d519fa9d22d2.zip','98099d24-27cb-11ef-8e37-d519fa9d22d2','{\"displayTitle\":\"13.2 Maxillaire u1 [pc2]\",\"modelMatrix\":\"-0.872238,0.452835,-0.184772,0,-0.478706,-0.713062,0.512233,0,0.100203,0.535241,0.838735,0,1.72597,-5.91108,-12.5484,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-11 10:21:25.438','2024-06-11 08:21:25.736','2024-06-11 10:21:27.542'),('9809acae-27cb-11ef-8e37-d519fa9d22d2',2,'/var/.scan4all/iris/data/2024/2/3573ee42-27cb-11ef-8e37-d519fa9d22d2/session_80d26da8-27cb-11ef-8e37-d519fa9d22d2/occlusion_80d4d06a-27cb-11ef-8e37-d519fa9d22d2/scan_81adf7a6-27cb-11ef-8e37-d519fa9d22d2/9809acae-27cb-11ef-8e37-d519fa9d22d2.png','PATIENT_3573ee42-27cb-11ef-8e37-d519fa9d22d2_ACT_80d26da8-27cb-11ef-8e37-d519fa9d22d2_SESS_80d4d06a-27cb-11ef-8e37-d519fa9d22d2_TOSC_81adf7a6-27cb-11ef-8e37-d519fa9d22d2_SNAPS','9809acae-27cb-11ef-8e37-d519fa9d22d2.png','9809acae-27cb-11ef-8e37-d519fa9d22d2','{\"displayTitle\":\"13.2 Maxillaire u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-11 10:21:25.439','2024-06-11 08:21:25.737','2024-06-11 10:21:28.275'),('98a961ad-2e36-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_3654e763-2e35-11ef-8deb-d515ea58f6cb/occlusion_36556270-2e35-11ef-8deb-d515ea58f6cb/scan_3754a3a0-2e35-11ef-8deb-d515ea58f6cb/98a961ad-2e36-11ef-8deb-d515ea58f6cb.ply','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_3654e763-2e35-11ef-8deb-d515ea58f6cb_SESS_36556270-2e35-11ef-8deb-d515ea58f6cb_TOSC_3754a3a0-2e35-11ef-8deb-d515ea58f6cb_SEG','98a961ad-2e36-11ef-8deb-d515ea58f6cb.ply','98a961ad-2e36-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.1 Mascella u1 Segmentazione [pc2]\"}','PLY',0,'SYNCED',0,NULL,'2024-06-19 14:22:30.257','2024-06-19 12:22:30.277','2024-06-19 14:22:30.651'),('9a5291cb-23eb-11ef-8dde-d415e84cc4f5',3,'/var/.scan4all/iris/data/2024/3/907398e3-23e7-11ef-8dde-d415e84cc4f5/session_8d2006e5-23eb-11ef-8dde-d415e84cc4f5/order_8d24e986-23eb-11ef-8dde-d415e84cc4f5/9a5291cb-23eb-11ef-8dde-d415e84cc4f5.pdf','PATIENT_907398e3-23e7-11ef-8dde-d415e84cc4f5_ACT_8d2006e5-23eb-11ef-8dde-d415e84cc4f5_PROST_8d24e986-23eb-11ef-8dde-d415e84cc4f5_FORM','9a5291cb-23eb-11ef-8dde-d415e84cc4f5.pdf','9a5291cb-23eb-11ef-8dde-d415e84cc4f5','{\"displayTitle\":\"2.3 Autre [pc1]\",\"title\":\"Autre\"}','PDF',0,'SYNCED',0,NULL,'2024-06-06 12:00:28.516','2024-06-06 10:00:29.221','2024-06-06 12:00:29.354'),('9ae521cf-2274-11ef-8d76-d310d2ec2c14',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/scan_4501cd03-2274-11ef-8d76-d310d2ec2c14/9ae521cf-2274-11ef-8d76-d310d2ec2c14.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_RISC_4501cd03-2274-11ef-8d76-d310d2ec2c14_MODEL','9ae521cf-2274-11ef-8d76-d310d2ec2c14.zip','9ae521cf-2274-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Mordu droit br1 [pc2]\",\"modelMatrix\":\"0.995468,0.0888961,0.00108082,0,-0.0954072,0.994225,-0.0595959,0,-0.00219656,0.0604803,0.998233,0,-3.1937,-2.54296,-9.84737,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 15:16:12.000','2024-06-04 13:16:12.000','2024-06-04 15:16:12.000'),('9ae54842-2274-11ef-8d76-d310d2ec2c14',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/scan_4501cd03-2274-11ef-8d76-d310d2ec2c14/9ae54842-2274-11ef-8d76-d310d2ec2c14.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_RISC_4501cd03-2274-11ef-8d76-d310d2ec2c14_SNAPS','9ae54842-2274-11ef-8d76-d310d2ec2c14.png','9ae54842-2274-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Mordu droit br1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 15:16:12.000','2024-06-04 13:16:12.000','2024-06-04 15:16:12.000'),('9c09d1b7-2e3b-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_da1f6873-2e3a-11ef-8deb-d515ea58f6cb/occlusion_da21a6e4-2e3a-11ef-8deb-d515ea58f6cb/scan_8bc7c92e-2e3b-11ef-8deb-d515ea58f6cb/9c09d1b7-2e3b-11ef-8deb-d515ea58f6cb.zip','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_da1f6873-2e3a-11ef-8deb-d515ea58f6cb_SESS_da21a6e4-2e3a-11ef-8deb-d515ea58f6cb_LESC_8bc7c92e-2e3b-11ef-8deb-d515ea58f6cb_MODEL','9c09d1b7-2e3b-11ef-8deb-d515ea58f6cb.zip','9c09d1b7-2e3b-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.2 Left bite bl1 [pc2]\",\"modelMatrix\":\"-0.994046,0.10327,0.0322121,0,-0.0984299,-0.982,0.162456,0,0.0467857,0.158155,0.986192,0,4.90521,-5.21494,-6.90067,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-19 14:58:23.405','2024-06-19 12:58:23.592','2024-06-19 14:58:25.679'),('9c09e417-2e3b-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_da1f6873-2e3a-11ef-8deb-d515ea58f6cb/occlusion_da21a6e4-2e3a-11ef-8deb-d515ea58f6cb/scan_8bc7c92e-2e3b-11ef-8deb-d515ea58f6cb/9c09e417-2e3b-11ef-8deb-d515ea58f6cb.png','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_da1f6873-2e3a-11ef-8deb-d515ea58f6cb_SESS_da21a6e4-2e3a-11ef-8deb-d515ea58f6cb_LESC_8bc7c92e-2e3b-11ef-8deb-d515ea58f6cb_SNAPS','9c09e417-2e3b-11ef-8deb-d515ea58f6cb.png','9c09e417-2e3b-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.2 Left bite bl1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-19 14:58:23.406','2024-06-19 12:58:23.593','2024-06-19 14:58:26.407'),('9c24cd94-27ce-11ef-8e37-d519fa9d22d2',2,'/var/.scan4all/iris/data/2024/2/4382037a-2735-11ef-8e16-d517f37fa1ab/session_be9a8e99-2735-11ef-8e16-d517f37fa1ab/order_be9f95d2-2735-11ef-8e16-d517f37fa1ab/9c24cd94-27ce-11ef-8e37-d519fa9d22d2.pdf','PATIENT_4382037a-2735-11ef-8e16-d517f37fa1ab_ACT_be9a8e99-2735-11ef-8e16-d517f37fa1ab_PROST_be9f95d2-2735-11ef-8e16-d517f37fa1ab_FORM','9c24cd94-27ce-11ef-8e37-d519fa9d22d2.pdf','9c24cd94-27ce-11ef-8e37-d519fa9d22d2','{\"displayTitle\":\"6.1 Autre [pc2]\",\"title\":\"Autre\"}','PDF',0,'SYNCED',0,NULL,'2024-06-11 10:43:02.000','2024-06-11 08:43:02.000','2024-06-11 10:43:02.000'),('9d433d29-297e-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_cc35f9a3-297d-11ef-8e16-d517f37fa2ad/order_cc4112f9-297d-11ef-8e16-d517f37fa2ad/9d433d29-297e-11ef-8e16-d517f37fa2ad.pdf','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_cc35f9a3-297d-11ef-8e16-d517f37fa2ad_PROST_cc4112f9-297d-11ef-8e16-d517f37fa2ad_FORM','9d433d29-297e-11ef-8e16-d517f37fa2ad.pdf','9d433d29-297e-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.2 Altro\",\"title\":\"Altro\"}','PDF',0,'SYNCED',0,NULL,'2024-06-13 14:15:27.000','2024-06-13 12:15:27.000','2024-06-13 14:15:27.000'),('9e27d113-296e-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_8e81ab09-296b-11ef-8e16-d517f37fa2ad/occlusion_8e83509f-296b-11ef-8e16-d517f37fa2ad/scan_890595a9-296d-11ef-8e16-d517f37fa2ad/9e27d113-296e-11ef-8e16-d517f37fa2ad.xyz','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_SESS_8e83509f-296b-11ef-8e16-d517f37fa2ad_TOSC_890595a9-296d-11ef-8e16-d517f37fa2ad_LIFI','9e27d113-296e-11ef-8e16-d517f37fa2ad.xyz','2e90e2b8-296e-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Mascella u3 Linea di finitura 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',2,'SYNCED',0,NULL,'2024-06-13 12:20:54.832','2024-06-13 10:20:54.836','2024-06-13 12:20:55.247'),('9e27e58a-296e-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_8e81ab09-296b-11ef-8e16-d517f37fa2ad/occlusion_8e83509f-296b-11ef-8e16-d517f37fa2ad/scan_890595a9-296d-11ef-8e16-d517f37fa2ad/9e27e58a-296e-11ef-8e16-d517f37fa2ad.bin','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_SESS_8e83509f-296b-11ef-8e16-d517f37fa2ad_TOSC_890595a9-296d-11ef-8e16-d517f37fa2ad_LIFIM','9e27e58a-296e-11ef-8e16-d517f37fa2ad.bin','2e90eaa9-296e-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Mascella u3 Linea di finitura dei metadati 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',2,'SYNCED',0,NULL,'2024-06-13 12:20:54.833','2024-06-13 10:20:54.836','2024-06-13 12:20:55.561'),('9e41d416-2269-11ef-8f1f-d8242c71b430',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_757ed4bc-2266-11ef-8f1f-d8242c71b430/occlusion_75806ee1-2266-11ef-8f1f-d8242c71b430/computedocclusion_0b16efeb-2268-11ef-8f1f-d8242c71b430/9e41d416-2269-11ef-8f1f-d8242c71b430.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_OCC_0b16efeb-2268-11ef-8f1f-d8242c71b430_BO1','9e41d416-2269-11ef-8f1f-d8242c71b430.zip','f379f4d9-2268-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.2 Occlusion o1 Mandibule l1\",\"modelMatrix\":\"0.988582,0.0775562,-0.129192,0,-0.0638786,0.992221,0.106846,0,0.136474,-0.0973735,0.985846,0,-17.8094,0.329057,-12.0411,1\",\"occlusionMatrix\":\"0.967115,-0.162627,-0.195617,0,-0.236852,-0.295065,-0.925664,0,0.0928169,0.941543,-0.323876,0,-16.3387,-5.9884,6.66074,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.2_l1\",\"referenceScanId\":\"b4da925f-2267-11ef-8f1f-d8242c71b430\",\"scanBodies\":[]}','ZIP',2,'SYNCED',0,NULL,'2024-06-04 13:57:30.000','2024-06-04 11:57:30.000','2024-06-04 13:57:30.000'),('9e85e968-27ce-11ef-867c-6ec2958327c0',5,'/var/.scan4all/iris/data/2024/5/discussion_8e7e9088-2733-11ef-8e16-d517f37fa1ab/9e85e968-27ce-11ef-867c-6ec2958327c0.pdf','PATIENT_4382037a-2735-11ef-8e16-d517f37fa1ab_ACT_be9a8e99-2735-11ef-8e16-d517f37fa1ab_PROST_be9f95d2-2735-11ef-8e16-d517f37fa1ab_FORM','9c24cd94-27ce-11ef-8e37-d519fa9d22d2.pdf','9e85e968-27ce-11ef-867c-6ec2958327c0','{\"displayTitle\":\"6.1 Autre [pc2]\",\"title\":\"Autre\"}','PDF',0,'SYNCED',0,NULL,'2024-06-11 10:43:02.000','2024-06-11 08:43:02.000','2024-06-11 10:43:02.000'),('9e8635ca-27ce-11ef-867c-6ec2958327c0',5,'/var/.scan4all/iris/data/2024/5/discussion_8e7e9088-2733-11ef-8e16-d517f37fa1ab/9e8635ca-27ce-11ef-867c-6ec2958327c0.zip','PATIENT_4382037a-2735-11ef-8e16-d517f37fa1ab_ACT_be9a8e99-2735-11ef-8e16-d517f37fa1ab_SESS_be9c5752-2735-11ef-8e16-d517f37fa1ab_TOSC_bfa3d876-2735-11ef-8e16-d517f37fa1ab_MODEL','e1412689-2735-11ef-8e16-d517f37fa1ab.zip','9e8635ca-27ce-11ef-867c-6ec2958327c0','{\"displayTitle\":\"6.1 Maxillaire u1 [pc2]\",\"modelMatrix\":\"-0.479814,-0.110653,0.870364,0,-0.0586755,0.993841,0.0940049,0,-0.875406,-0.00596416,-0.483352,0,21.2778,2.84273,-5.93875,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-10 16:29:47.000','2024-06-10 14:29:47.000','2024-06-10 16:29:47.000'),('9e99428e-27ce-11ef-867c-6ec2958327c0',5,'/var/.scan4all/iris/data/2024/5/discussion_8e7e9088-2733-11ef-8e16-d517f37fa1ab/9e99428e-27ce-11ef-867c-6ec2958327c0.png','PATIENT_4382037a-2735-11ef-8e16-d517f37fa1ab_ACT_be9a8e99-2735-11ef-8e16-d517f37fa1ab_SESS_be9c5752-2735-11ef-8e16-d517f37fa1ab_TOSC_bfa3d876-2735-11ef-8e16-d517f37fa1ab_SNAPS','e1413c8f-2735-11ef-8e16-d517f37fa1ab.png','9e99428e-27ce-11ef-867c-6ec2958327c0','{\"displayTitle\":\"6.1 Maxillaire u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-10 16:29:47.000','2024-06-10 14:29:47.000','2024-06-10 16:29:47.000'),('9e999c8a-27ce-11ef-867c-6ec2958327c0',5,'/var/.scan4all/iris/data/2024/5/discussion_8e7e9088-2733-11ef-8e16-d517f37fa1ab/9e999c8a-27ce-11ef-867c-6ec2958327c0.xyz','PATIENT_4382037a-2735-11ef-8e16-d517f37fa1ab_ACT_be9a8e99-2735-11ef-8e16-d517f37fa1ab_SESS_be9c5752-2735-11ef-8e16-d517f37fa1ab_TOSC_bfa3d876-2735-11ef-8e16-d517f37fa1ab_LIFI','e921fb8b-2735-11ef-8e16-d517f37fa1ab.xyz','9e999c8a-27ce-11ef-867c-6ec2958327c0','{\"displayTitle\":\"6.1 Maxillaire u1 Ligne de finition 0 [pc2]\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-10 16:29:57.000','2024-06-10 14:29:57.000','2024-06-10 16:29:57.000'),('9e99fe68-27ce-11ef-867c-6ec2958327c0',5,'/var/.scan4all/iris/data/2024/5/discussion_8e7e9088-2733-11ef-8e16-d517f37fa1ab/9e99fe68-27ce-11ef-867c-6ec2958327c0.bin','PATIENT_4382037a-2735-11ef-8e16-d517f37fa1ab_ACT_be9a8e99-2735-11ef-8e16-d517f37fa1ab_SESS_be9c5752-2735-11ef-8e16-d517f37fa1ab_TOSC_bfa3d876-2735-11ef-8e16-d517f37fa1ab_LIFIM','e9220178-2735-11ef-8e16-d517f37fa1ab.bin','9e99fe68-27ce-11ef-867c-6ec2958327c0','{\"displayTitle\":\"6.1 Maxillaire u1 Ligne de finition métadonnées 0 [pc2]\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-10 16:29:58.000','2024-06-10 14:29:58.000','2024-06-10 16:29:58.000'),('9ec5df9b-2980-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_08eb58c6-2980-11ef-8e16-d517f37fa2ad/occlusion_08ed7a4a-2980-11ef-8e16-d517f37fa2ad/scan_4d76036e-2980-11ef-8e16-d517f37fa2ad/9ec5df9b-2980-11ef-8e16-d517f37fa2ad.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_BOSC_4d76036e-2980-11ef-8e16-d517f37fa2ad_MODEL','9ec5df9b-2980-11ef-8e16-d517f37fa2ad.zip','9ec5df9b-2980-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.5 Mandibola l1\",\"modelMatrix\":\"-0.0691305,-0.980151,-0.185807,0,0.932705,-0.129585,0.336555,0,-0.353953,-0.150036,0.92315,0,-2.52526,5.094,-12.0573,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 14:29:51.000','2024-06-13 12:29:51.000','2024-06-13 14:29:51.000'),('9ec5f3b6-2980-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_08eb58c6-2980-11ef-8e16-d517f37fa2ad/occlusion_08ed7a4a-2980-11ef-8e16-d517f37fa2ad/scan_4d76036e-2980-11ef-8e16-d517f37fa2ad/9ec5f3b6-2980-11ef-8e16-d517f37fa2ad.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_BOSC_4d76036e-2980-11ef-8e16-d517f37fa2ad_SNAPS','9ec5f3b6-2980-11ef-8e16-d517f37fa2ad.png','9ec5f3b6-2980-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.5 Mandibola l1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 14:29:51.000','2024-06-13 12:29:51.000','2024-06-13 14:29:51.000'),('a0bfc6a3-2e4d-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/4382037a-2735-11ef-8e16-d517f37fa1ab/session_8598ee4a-2e40-11ef-8deb-d515ea58f6cb/order_22749c4a-2e42-11ef-8deb-d515ea58f6cb/a0bfc6a3-2e4d-11ef-8deb-d515ea58f6cb.pdf','PATIENT_4382037a-2735-11ef-8e16-d517f37fa1ab_ACT_8598ee4a-2e40-11ef-8deb-d515ea58f6cb_PROST_22749c4a-2e42-11ef-8deb-d515ea58f6cb_FORM','a0bfc6a3-2e4d-11ef-8deb-d515ea58f6cb.pdf','32bdfef7-2e42-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"6.3 Crown [pc2]\",\"title\":\"Crown\"}','PDF',1,'SYNCED',0,NULL,'2024-06-19 17:07:22.250','2024-06-19 15:07:23.019','2024-06-19 17:07:23.029'),('a1d4880f-2a2f-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/scan_aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd/a1d4880f-2a2f-11ef-8f1c-d8242c6fa8fd.png','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_BOSC_aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd_SCREENS','a1d4880f-2a2f-11ef-8f1c-d8242c6fa8fd.png','a1d4880f-2a2f-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Mandibola l2 Screenshot 4\",\"title\":\"4\"}','PNG',0,'SYNCED',0,NULL,'2024-06-14 11:22:36.000','2024-06-14 09:22:36.000','2024-06-14 11:22:36.000'),('a1f87a69-225a-11ef-8d76-d310d2ec2c14',3,'/var/.scan4all/iris/data/2024/3/6220e0d7-2255-11ef-8e3f-d619fca54465/session_78ba832e-2255-11ef-8e3f-d619fca54465/occlusion_78bc2302-2255-11ef-8e3f-d619fca54465/scan_7dd4df25-225a-11ef-8d76-d310d2ec2c14/a1f87a69-225a-11ef-8d76-d310d2ec2c14.zip','PATIENT_6220e0d7-2255-11ef-8e3f-d619fca54465_ACT_78ba832e-2255-11ef-8e3f-d619fca54465_SESS_78bc2302-2255-11ef-8e3f-d619fca54465_TOSC_7dd4df25-225a-11ef-8d76-d310d2ec2c14_MODEL','a1f87a69-225a-11ef-8d76-d310d2ec2c14.zip','a1f87a69-225a-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.1 Maxillaire u1\",\"modelMatrix\":\"-0.302028,0.91195,-0.277715,0,-0.488179,-0.398181,-0.776616,0,-0.818816,-0.0989856,0.565457,0,12.4108,-4.97741,-8.86751,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 12:10:13.159','2024-06-04 10:10:13.360','2024-06-04 12:10:16.012'),('a1f8912f-225a-11ef-8d76-d310d2ec2c14',3,'/var/.scan4all/iris/data/2024/3/6220e0d7-2255-11ef-8e3f-d619fca54465/session_78ba832e-2255-11ef-8e3f-d619fca54465/occlusion_78bc2302-2255-11ef-8e3f-d619fca54465/scan_7dd4df25-225a-11ef-8d76-d310d2ec2c14/a1f8912f-225a-11ef-8d76-d310d2ec2c14.png','PATIENT_6220e0d7-2255-11ef-8e3f-d619fca54465_ACT_78ba832e-2255-11ef-8e3f-d619fca54465_SESS_78bc2302-2255-11ef-8e3f-d619fca54465_TOSC_7dd4df25-225a-11ef-8d76-d310d2ec2c14_SNAPS','a1f8912f-225a-11ef-8d76-d310d2ec2c14.png','a1f8912f-225a-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.1 Maxillaire u1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 12:10:13.159','2024-06-04 10:10:13.360','2024-06-04 12:10:21.678'),('a1f8fad4-23eb-11ef-867c-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_0f3dfe44-225d-11ef-8f1f-d8242c71b430/a1f8fad4-23eb-11ef-867c-6ec2958327c0.pdf','PATIENT_907398e3-23e7-11ef-8dde-d415e84cc4f5_ACT_8d2006e5-23eb-11ef-8dde-d415e84cc4f5_PROST_8d24e986-23eb-11ef-8dde-d415e84cc4f5_FORM','9a5291cb-23eb-11ef-8dde-d415e84cc4f5.pdf','a1f8fad4-23eb-11ef-867c-6ec2958327c0','{\"displayTitle\":\"2.3 Autre [pc1]\",\"title\":\"Autre\"}','PDF',0,'SYNCED',0,NULL,'2024-06-06 12:00:29.000','2024-06-06 10:00:29.000','2024-06-06 12:00:29.000'),('a1fba852-23eb-11ef-867c-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_0f3dfe44-225d-11ef-8f1f-d8242c71b430/a1fba852-23eb-11ef-867c-6ec2958327c0.zip','PATIENT_907398e3-23e7-11ef-8dde-d415e84cc4f5_ACT_96aedcf6-23e7-11ef-8dde-d415e84cc4f5_SESS_96b19cc6-23e7-11ef-8dde-d415e84cc4f5_TOSC_981faf70-23e7-11ef-8dde-d415e84cc4f5_MODEL','d0ab5861-23e7-11ef-8dde-d415e84cc4f5.zip','a1fba852-23eb-11ef-867c-6ec2958327c0','{\"displayTitle\":\"2.1 Maxillaire u1 [pc1]\",\"modelMatrix\":\"0.998773,-0.00202182,-0.0494821,0,0.00445529,0.998783,0.0491187,0,0.0493226,-0.0492789,0.997566,0,1.86586,2.73136,-15.9281,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-06 11:33:25.000','2024-06-06 09:33:25.000','2024-06-06 11:33:25.000'),('a1fc17b1-23eb-11ef-867c-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_0f3dfe44-225d-11ef-8f1f-d8242c71b430/a1fc17b1-23eb-11ef-867c-6ec2958327c0.png','PATIENT_907398e3-23e7-11ef-8dde-d415e84cc4f5_ACT_96aedcf6-23e7-11ef-8dde-d415e84cc4f5_SESS_96b19cc6-23e7-11ef-8dde-d415e84cc4f5_TOSC_981faf70-23e7-11ef-8dde-d415e84cc4f5_SNAPS','d0ab69d4-23e7-11ef-8dde-d415e84cc4f5.png','a1fc17b1-23eb-11ef-867c-6ec2958327c0','{\"displayTitle\":\"2.1 Maxillaire u1 Snapshot [pc1]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-06 11:33:26.000','2024-06-06 09:33:26.000','2024-06-06 11:33:26.000'),('a21821fc-2735-11ef-8e16-d517f37fa1ab',2,'/var/.scan4all/iris/data/2024/2/312c74c3-2735-11ef-8e16-d517f37fa1ab/session_8c10fdc0-2735-11ef-8e16-d517f37fa1ab/occlusion_8c1214e8-2735-11ef-8e16-d517f37fa1ab/scan_8cf4ef97-2735-11ef-8e16-d517f37fa1ab/a21821fc-2735-11ef-8e16-d517f37fa1ab.zip','PATIENT_312c74c3-2735-11ef-8e16-d517f37fa1ab_ACT_8c10fdc0-2735-11ef-8e16-d517f37fa1ab_SESS_8c1214e8-2735-11ef-8e16-d517f37fa1ab_TOSC_8cf4ef97-2735-11ef-8e16-d517f37fa1ab_MODEL','a21821fc-2735-11ef-8e16-d517f37fa1ab.zip','a21821fc-2735-11ef-8e16-d517f37fa1ab','{\"displayTitle\":\"5.1 Maxillaire u1 [pc2]\",\"modelMatrix\":\"0.985835,-0.147673,-0.0795084,0,0.15153,0.987434,0.0448628,0,0.0718843,-0.0562753,0.995824,0,-2.99398,1.58881,-12.6823,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,'2024-06-11 10:08:21.000','2024-06-10 16:28:02.000','2024-06-11 08:08:21.000','2024-06-11 10:08:21.000'),('a2183657-2735-11ef-8e16-d517f37fa1ab',2,'/var/.scan4all/iris/data/2024/2/312c74c3-2735-11ef-8e16-d517f37fa1ab/session_8c10fdc0-2735-11ef-8e16-d517f37fa1ab/occlusion_8c1214e8-2735-11ef-8e16-d517f37fa1ab/scan_8cf4ef97-2735-11ef-8e16-d517f37fa1ab/a2183657-2735-11ef-8e16-d517f37fa1ab.png','PATIENT_312c74c3-2735-11ef-8e16-d517f37fa1ab_ACT_8c10fdc0-2735-11ef-8e16-d517f37fa1ab_SESS_8c1214e8-2735-11ef-8e16-d517f37fa1ab_TOSC_8cf4ef97-2735-11ef-8e16-d517f37fa1ab_SNAPS','a2183657-2735-11ef-8e16-d517f37fa1ab.png','a2183657-2735-11ef-8e16-d517f37fa1ab','{\"displayTitle\":\"5.1 Maxillaire u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,'2024-06-11 10:08:22.000','2024-06-10 16:28:02.000','2024-06-11 08:08:22.000','2024-06-11 10:08:22.000'),('a2541cd6-28b1-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/8735f5e1-28b1-11ef-8e16-d517f37fa2ad/session_8736853e-28b1-11ef-8e16-d517f37fa2ad/occlusion_87372aa3-28b1-11ef-8e16-d517f37fa2ad/scan_87f7def7-28b1-11ef-8e16-d517f37fa2ad/a2541cd6-28b1-11ef-8e16-d517f37fa2ad.zip','PATIENT_8735f5e1-28b1-11ef-8e16-d517f37fa2ad_ACT_8736853e-28b1-11ef-8e16-d517f37fa2ad_SESS_87372aa3-28b1-11ef-8e16-d517f37fa2ad_TOSC_87f7def7-28b1-11ef-8e16-d517f37fa2ad_MODEL','a2541cd6-28b1-11ef-8e16-d517f37fa2ad.zip','a2541cd6-28b1-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"2.1 Maxillaire u1\",\"modelMatrix\":\"-0.662437,-0.738259,-0.127087,0,0.647414,-0.649552,0.398669,0,-0.37687,0.181815,0.908246,0,14.1407,9.72577,-8.72586,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',1,'2024-06-12 13:48:23.274','2024-06-12 13:48:06.951','2024-06-12 11:48:23.276',NULL),('a2542d62-28b1-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/8735f5e1-28b1-11ef-8e16-d517f37fa2ad/session_8736853e-28b1-11ef-8e16-d517f37fa2ad/occlusion_87372aa3-28b1-11ef-8e16-d517f37fa2ad/scan_87f7def7-28b1-11ef-8e16-d517f37fa2ad/a2542d62-28b1-11ef-8e16-d517f37fa2ad.png','PATIENT_8735f5e1-28b1-11ef-8e16-d517f37fa2ad_ACT_8736853e-28b1-11ef-8e16-d517f37fa2ad_SESS_87372aa3-28b1-11ef-8e16-d517f37fa2ad_TOSC_87f7def7-28b1-11ef-8e16-d517f37fa2ad_SNAPS','a2542d62-28b1-11ef-8e16-d517f37fa2ad.png','a2542d62-28b1-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"2.1 Maxillaire u1 Snapshot\"}','PNG',0,'CREATED',1,'2024-06-12 13:48:23.274','2024-06-12 13:48:06.952','2024-06-12 11:48:23.277',NULL),('a45229a5-2a2f-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/scan_aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd/a45229a5-2a2f-11ef-8f1c-d8242c6fa8fd.json','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_BOSC_aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd_METER','a45229a5-2a2f-11ef-8f1c-d8242c6fa8fd.json','a45229a5-2a2f-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Mandibola l2 Misura\"}','JSON',0,'SYNCED',0,NULL,'2024-06-14 11:22:39.565','2024-06-14 09:22:39.566','2024-06-14 11:22:40.294'),('a51fa049-297e-11ef-867c-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_1a8fdf3a-296b-11ef-8e16-d517f37fa2ad/a51fa049-297e-11ef-867c-6ec2958327c0.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_cc35f9a3-297d-11ef-8e16-d517f37fa2ad_SESS_cc37a7f7-297d-11ef-8e16-d517f37fa2ad_TOSC_cd2aac3c-297d-11ef-8e16-d517f37fa2ad_MODEL','8870875c-297e-11ef-8e16-d517f37fa2ad.zip','a51fa049-297e-11ef-867c-6ec2958327c0','{\"displayTitle\":\"5.2 Mascella u1\",\"modelMatrix\":\"-0.0956275,0.983936,-0.15075,0,-0.970825,-0.125645,-0.204237,0,-0.219897,0.126821,0.967244,0,-13.057,-28.6755,-11.14,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 14:15:05.000','2024-06-13 12:15:05.000','2024-06-13 14:15:05.000'),('a51ff66b-297e-11ef-867c-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_1a8fdf3a-296b-11ef-8e16-d517f37fa2ad/a51ff66b-297e-11ef-867c-6ec2958327c0.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_cc35f9a3-297d-11ef-8e16-d517f37fa2ad_SESS_cc37a7f7-297d-11ef-8e16-d517f37fa2ad_TOSC_cd2aac3c-297d-11ef-8e16-d517f37fa2ad_SNAPS','88709f91-297e-11ef-8e16-d517f37fa2ad.png','a51ff66b-297e-11ef-867c-6ec2958327c0','{\"displayTitle\":\"5.2 Mascella u1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 14:15:06.000','2024-06-13 12:15:06.000','2024-06-13 14:15:06.000'),('a5203d7a-297e-11ef-867c-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_1a8fdf3a-296b-11ef-8e16-d517f37fa2ad/a5203d7a-297e-11ef-867c-6ec2958327c0.pdf','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_cc35f9a3-297d-11ef-8e16-d517f37fa2ad_PROST_cc4112f9-297d-11ef-8e16-d517f37fa2ad_FORM','9d433d29-297e-11ef-8e16-d517f37fa2ad.pdf','a5203d7a-297e-11ef-867c-6ec2958327c0','{\"displayTitle\":\"5.2 Altro\",\"title\":\"Altro\"}','PDF',0,'SYNCED',0,NULL,'2024-06-13 14:15:27.000','2024-06-13 12:15:27.000','2024-06-13 14:15:27.000'),('a6fb3865-289f-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/f373c86a-2899-11ef-8e16-d517f37fa2ad/session_627cfe1c-289b-11ef-8e16-d517f37fa2ad/order_ddb0571c-289e-11ef-8e16-d517f37fa2ad/a6fb3865-289f-11ef-8e16-d517f37fa2ad.pdf','PATIENT_f373c86a-2899-11ef-8e16-d517f37fa2ad_ACT_627cfe1c-289b-11ef-8e16-d517f37fa2ad_PROST_ddb0571c-289e-11ef-8e16-d517f37fa2ad_FORM','a6fb3865-289f-11ef-8e16-d517f37fa2ad.pdf','a6fb3865-289f-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.2 Autre\",\"title\":\"Autre\"}','PDF',0,'SYNCED',0,NULL,'2024-06-12 11:39:26.000','2024-06-12 09:39:26.000','2024-06-12 11:39:26.000'),('a72f121e-273d-11ef-8e09-d517f1736dc8',2,'/var/.scan4all/iris/data/2024/2/b8993188-273d-11ef-8e09-d517f1736dc8/session_eab5fbfa-273c-11ef-8e16-d517f37fa1ab/occlusion_eab758e7-273c-11ef-8e16-d517f37fa1ab/scan_8714aaaa-273d-11ef-8e09-d517f1736dc8/a72f121e-273d-11ef-8e09-d517f1736dc8.zip','PATIENT_b8993188-273d-11ef-8e09-d517f1736dc8_ACT_eab5fbfa-273c-11ef-8e16-d517f37fa1ab_SESS_eab758e7-273c-11ef-8e16-d517f37fa1ab_BOSC_8714aaaa-273d-11ef-8e09-d517f1736dc8_MODEL','a72f121e-273d-11ef-8e09-d517f1736dc8.zip','a72f121e-273d-11ef-8e09-d517f1736dc8','{\"displayTitle\":\"11.1 Mandibule l1 [pc2]\",\"modelMatrix\":\"-0.221995,0.975026,-0.00659317,0,-0.951629,-0.218132,-0.216382,0,-0.212416,-0.0417614,0.976287,0,-1.42268,3.28872,-13.2215,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-10 17:25:22.314','2024-06-10 15:25:51.705','2024-06-10 17:25:53.471'),('a72f3238-273d-11ef-8e09-d517f1736dc8',2,'/var/.scan4all/iris/data/2024/2/b8993188-273d-11ef-8e09-d517f1736dc8/session_eab5fbfa-273c-11ef-8e16-d517f37fa1ab/occlusion_eab758e7-273c-11ef-8e16-d517f37fa1ab/scan_8714aaaa-273d-11ef-8e09-d517f1736dc8/a72f3238-273d-11ef-8e09-d517f1736dc8.png','PATIENT_b8993188-273d-11ef-8e09-d517f1736dc8_ACT_eab5fbfa-273c-11ef-8e16-d517f37fa1ab_SESS_eab758e7-273c-11ef-8e16-d517f37fa1ab_BOSC_8714aaaa-273d-11ef-8e09-d517f1736dc8_SNAPS','a72f3238-273d-11ef-8e09-d517f1736dc8.png','a72f3238-273d-11ef-8e09-d517f1736dc8','{\"displayTitle\":\"11.1 Mandibule l1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-10 17:25:22.315','2024-06-10 15:25:51.705','2024-06-10 17:25:55.563'),('a824cada-2e29-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/520a1417-2735-11ef-8e16-d517f37fa1ab/session_9573b888-2e29-11ef-8deb-d515ea58f6cb/occlusion_9576614e-2e29-11ef-8deb-d515ea58f6cb/scan_97940017-2e29-11ef-8deb-d515ea58f6cb/a824cada-2e29-11ef-8deb-d515ea58f6cb.zip','PATIENT_520a1417-2735-11ef-8e16-d517f37fa1ab_ACT_9573b888-2e29-11ef-8deb-d515ea58f6cb_SESS_9576614e-2e29-11ef-8deb-d515ea58f6cb_TOSC_97940017-2e29-11ef-8deb-d515ea58f6cb_MODEL','a824cada-2e29-11ef-8deb-d515ea58f6cb.zip','a824cada-2e29-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"7.4 Maxillaire u1 [pc2]\",\"modelMatrix\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-19 12:49:52.774','2024-06-19 10:49:52.896','2024-06-19 12:49:53.877'),('a824ff05-2e29-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/520a1417-2735-11ef-8e16-d517f37fa1ab/session_9573b888-2e29-11ef-8deb-d515ea58f6cb/occlusion_9576614e-2e29-11ef-8deb-d515ea58f6cb/scan_97940017-2e29-11ef-8deb-d515ea58f6cb/a824ff05-2e29-11ef-8deb-d515ea58f6cb.png','PATIENT_520a1417-2735-11ef-8e16-d517f37fa1ab_ACT_9573b888-2e29-11ef-8deb-d515ea58f6cb_SESS_9576614e-2e29-11ef-8deb-d515ea58f6cb_TOSC_97940017-2e29-11ef-8deb-d515ea58f6cb_SNAPS','a824ff05-2e29-11ef-8deb-d515ea58f6cb.png','a824ff05-2e29-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"7.4 Maxillaire u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-19 12:49:52.775','2024-06-19 10:49:52.897','2024-06-19 12:49:55.186'),('a84953ba-2278-11ef-8d76-d310d2ec2c14',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/computedocclusion_9ed6352b-2277-11ef-8d76-d310d2ec2c14/a84953ba-2278-11ef-8d76-d310d2ec2c14.json','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_OCC_9ed6352b-2277-11ef-8d76-d310d2ec2c14_METER','a84953ba-2278-11ef-8d76-d310d2ec2c14.json','a84953ba-2278-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Occlusion o2 [pc2]\",\"occlusionType\":5}','JSON',0,'SYNCED',0,NULL,'2024-06-04 15:45:08.657','2024-06-04 13:45:08.667','2024-06-04 15:45:08.973'),('a8c82bcb-296a-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_4704a021-2963-11ef-8e16-d517f37fa2ad/occlusion_4706df6f-2963-11ef-8e16-d517f37fa2ad/computedocclusion_9153c588-2968-11ef-8e16-d517f37fa2ad/a8c82bcb-296a-11ef-8e16-d517f37fa2ad.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_4704a021-2963-11ef-8e16-d517f37fa2ad_SESS_4706df6f-2963-11ef-8e16-d517f37fa2ad_OCC_9153c588-2968-11ef-8e16-d517f37fa2ad_TO1','a8c82bcb-296a-11ef-8e16-d517f37fa2ad.zip','1faa40ce-296a-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.1 Occlusione o1 Mascella u1\",\"modelMatrix\":\"0.432825,-0.89967,-0.0570733,0,0.880417,0.43547,-0.187701,0,0.193722,0.0309933,0.980567,0,-23.5715,9.30099,-17.1386,1\",\"occlusionMatrix\":\"0.457763,0.0354936,-0.888366,0,0.863851,0.218564,0.453863,0,0.210273,-0.975177,0.0693891,0,-25.0416,17.0547,6.08757,1\",\"occlusionType\":5,\"referenceScanFullDisplayId\":\"5.1_u1\",\"referenceScanId\":\"47f95341-2963-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2024-06-13 11:52:38.000','2024-06-13 09:52:38.000','2024-06-13 11:52:38.000'),('a90adf72-296a-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_4704a021-2963-11ef-8e16-d517f37fa2ad/occlusion_4706df6f-2963-11ef-8e16-d517f37fa2ad/computedocclusion_9153c588-2968-11ef-8e16-d517f37fa2ad/a90adf72-296a-11ef-8e16-d517f37fa2ad.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_4704a021-2963-11ef-8e16-d517f37fa2ad_SESS_4706df6f-2963-11ef-8e16-d517f37fa2ad_OCC_9153c588-2968-11ef-8e16-d517f37fa2ad_BO1','a90adf72-296a-11ef-8e16-d517f37fa2ad.zip','1ff1bee2-296a-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.1 Occlusione o1 Mandibola l2\",\"modelMatrix\":\"-0.333428,-0.941176,-0.0548981,0,0.935492,-0.323066,-0.143118,0,0.116963,-0.0990761,0.988182,0,22.6045,17.8478,-19.0898,1\",\"occlusionMatrix\":\"0.525605,-0.28243,-0.802491,0,-0.85016,-0.139511,-0.50772,0,0.0314434,0.949097,-0.313429,0,-28.7739,-3.69969,13.2005,1\",\"occlusionType\":5,\"referenceScanFullDisplayId\":\"5.1_l2\",\"referenceScanId\":\"f3a386e0-2965-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2024-06-13 11:52:39.000','2024-06-13 09:52:39.000','2024-06-13 11:52:39.000'),('a9e9f96d-298f-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_d703d726-298d-11ef-8e16-d517f37fa2ad/occlusion_d70636d7-298d-11ef-8e16-d517f37fa2ad/scan_a9e9d6c4-298f-11ef-8e16-d517f37fa2ad/a9e9f96d-298f-11ef-8e16-d517f37fa2ad.zip','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_d703d726-298d-11ef-8e16-d517f37fa2ad_SESS_d70636d7-298d-11ef-8e16-d517f37fa2ad_TOSC_a9e9d6c4-298f-11ef-8e16-d517f37fa2ad_MODEL','a9e9f96d-298f-11ef-8e16-d517f37fa2ad.zip','a9e9f96d-298f-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.2 Mascella u2\",\"modelMatrix\":\"0.975516,-0.148096,-0.162593,0,0.128141,0.983582,-0.127067,0,0.178742,0.103121,0.978477,0,-16.8719,-1.29266,-12.1772,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 16:17:27.952','2024-06-13 14:17:29.910','2024-06-13 16:17:30.236'),('a9eec273-298f-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_d703d726-298d-11ef-8e16-d517f37fa2ad/occlusion_d70636d7-298d-11ef-8e16-d517f37fa2ad/scan_a9e9d6c4-298f-11ef-8e16-d517f37fa2ad/a9eec273-298f-11ef-8e16-d517f37fa2ad.png','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_d703d726-298d-11ef-8e16-d517f37fa2ad_SESS_d70636d7-298d-11ef-8e16-d517f37fa2ad_TOSC_a9e9d6c4-298f-11ef-8e16-d517f37fa2ad_SNAPS','a9eec273-298f-11ef-8e16-d517f37fa2ad.png','a9eec273-298f-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.2 Mascella u2 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 16:17:27.983','2024-06-13 14:17:29.910','2024-06-13 16:17:31.059'),('aa0af9eb-2e40-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/4382037a-2735-11ef-8e16-d517f37fa1ab/session_8598ee4a-2e40-11ef-8deb-d515ea58f6cb/occlusion_859bd7ba-2e40-11ef-8deb-d515ea58f6cb/scan_86f46641-2e40-11ef-8deb-d515ea58f6cb/aa0af9eb-2e40-11ef-8deb-d515ea58f6cb.zip','PATIENT_4382037a-2735-11ef-8e16-d517f37fa1ab_ACT_8598ee4a-2e40-11ef-8deb-d515ea58f6cb_SESS_859bd7ba-2e40-11ef-8deb-d515ea58f6cb_TOSC_86f46641-2e40-11ef-8deb-d515ea58f6cb_MODEL','aa0af9eb-2e40-11ef-8deb-d515ea58f6cb.zip','aa0af9eb-2e40-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"6.3 Maxilla u1 [pc2]\",\"modelMatrix\":\"0.991771,-0.00472581,-0.127936,0,-0.00311808,0.99813,-0.0610415,0,0.127985,0.0609382,0.989902,0,-14.1942,-0.266649,-12.4392,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-19 15:34:48.000','2024-06-19 13:34:48.000','2024-06-19 15:34:48.000'),('aa0b087d-2e40-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/4382037a-2735-11ef-8e16-d517f37fa1ab/session_8598ee4a-2e40-11ef-8deb-d515ea58f6cb/occlusion_859bd7ba-2e40-11ef-8deb-d515ea58f6cb/scan_86f46641-2e40-11ef-8deb-d515ea58f6cb/aa0b087d-2e40-11ef-8deb-d515ea58f6cb.png','PATIENT_4382037a-2735-11ef-8e16-d517f37fa1ab_ACT_8598ee4a-2e40-11ef-8deb-d515ea58f6cb_SESS_859bd7ba-2e40-11ef-8deb-d515ea58f6cb_TOSC_86f46641-2e40-11ef-8deb-d515ea58f6cb_SNAPS','aa0b087d-2e40-11ef-8deb-d515ea58f6cb.png','aa0b087d-2e40-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"6.3 Maxilla u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-19 15:34:48.000','2024-06-19 13:34:48.000','2024-06-19 15:34:48.000'),('aa7cded3-2a2e-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/scan_80540c46-2a2a-11ef-8f1c-d8242c6fa8fd/aa7cded3-2a2e-11ef-8f1c-d8242c6fa8fd.ply','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_BOSC_80540c46-2a2a-11ef-8f1c-d8242c6fa8fd_SEG','aa7cded3-2a2e-11ef-8f1c-d8242c6fa8fd.ply','9584d053-2a2e-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Mandibola l1 Segmentazione\"}','PLY',1,'SYNCED',0,NULL,'2024-06-14 11:15:40.414','2024-06-14 09:15:40.464','2024-06-14 11:15:40.784'),('adfd6dd3-27ca-11ef-8e37-d519fa9d22d2',2,'/var/.scan4all/iris/data/2024/2/520a1417-2735-11ef-8e16-d517f37fa1ab/session_917767fe-23fa-11ef-8dde-d415e84cc4f5/order_bed2bb1e-273c-11ef-8e16-d517f37fa1ab/adfd6dd3-27ca-11ef-8e37-d519fa9d22d2.pdf','PATIENT_520a1417-2735-11ef-8e16-d517f37fa1ab_ACT_917767fe-23fa-11ef-8dde-d415e84cc4f5_PROST_bed2bb1e-273c-11ef-8e16-d517f37fa1ab_FORM','adfd6dd3-27ca-11ef-8e37-d519fa9d22d2.pdf','adfd6dd3-27ca-11ef-8e37-d519fa9d22d2','{\"displayTitle\":\"7.2 Couronne [pc2]\",\"title\":\"Couronne\"}','PDF',0,'SYNCED',0,'2024-06-11 10:15:34.000','2024-06-11 10:14:54.000','2024-06-11 08:15:34.000','2024-06-11 10:15:34.000'),('aee5f3db-2a2e-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/scan_aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd/aee5f3db-2a2e-11ef-8f1c-d8242c6fa8fd.zip','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_BOSC_aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd_MODEL','aee5f3db-2a2e-11ef-8f1c-d8242c6fa8fd.zip','aee5f3db-2a2e-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Mandibola l2\",\"modelMatrix\":\"-0.934662,0.348207,-0.071824,0,-0.340741,-0.934968,-0.098644,0,-0.101502,-0.0677254,0.992527,0,16.8656,-3.96577,-16.4235,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-14 11:15:53.000','2024-06-14 09:15:53.000','2024-06-14 11:15:53.000'),('aeeb700b-2a2e-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/scan_aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd/aeeb700b-2a2e-11ef-8f1c-d8242c6fa8fd.png','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_BOSC_aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd_SNAPS','aeeb700b-2a2e-11ef-8f1c-d8242c6fa8fd.png','aeeb700b-2a2e-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Mandibola l2 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-14 11:15:53.000','2024-06-14 09:15:53.000','2024-06-14 11:15:53.000'),('aeeb7d77-2a2e-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/scan_aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd/aeeb7d77-2a2e-11ef-8f1c-d8242c6fa8fd.xyz','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_BOSC_aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd_LIFI','aeeb7d77-2a2e-11ef-8f1c-d8242c6fa8fd.xyz','aeeb7d77-2a2e-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Mandibola l2 Linea di finitura 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-14 11:15:53.000','2024-06-14 09:15:53.000','2024-06-14 11:15:53.000'),('aeeb8932-2a2e-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/scan_aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd/aeeb8932-2a2e-11ef-8f1c-d8242c6fa8fd.bin','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_BOSC_aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd_LIFIM','aeeb8932-2a2e-11ef-8f1c-d8242c6fa8fd.bin','aeeb8932-2a2e-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Mandibola l2 Linea di finitura dei metadati 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-14 11:15:54.000','2024-06-14 09:15:54.000','2024-06-14 11:15:54.000'),('aeeb948a-2a2e-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/scan_aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd/aeeb948a-2a2e-11ef-8f1c-d8242c6fa8fd.ply','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_BOSC_aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd_SEG','aeeb948a-2a2e-11ef-8f1c-d8242c6fa8fd.ply','aeeb948a-2a2e-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Mandibola l2 Segmentazione\"}','PLY',0,'SYNCED',0,NULL,'2024-06-14 11:15:47.850','2024-06-14 09:15:51.331','2024-06-14 11:15:54.168'),('afc71293-2987-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/0fedc3b4-2961-11ef-8e16-d517f37fa2ad/session_4ba13230-2987-11ef-8e16-d517f37fa2ad/occlusion_4ba370c1-2987-11ef-8e16-d517f37fa2ad/scan_879dec53-2987-11ef-8e16-d517f37fa2ad/afc71293-2987-11ef-8e16-d517f37fa2ad.zip','PATIENT_0fedc3b4-2961-11ef-8e16-d517f37fa2ad_ACT_4ba13230-2987-11ef-8e16-d517f37fa2ad_SESS_4ba370c1-2987-11ef-8e16-d517f37fa2ad_BOSC_879dec53-2987-11ef-8e16-d517f37fa2ad_MODEL','afc71293-2987-11ef-8e16-d517f37fa2ad.zip','afc71293-2987-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"4.1 Mandibola l1\",\"modelMatrix\":\"-0.967691,-0.234243,0.0932966,0,0.250368,-0.936471,0.24564,0,0.0298301,0.261062,0.964861,0,13.0365,-2.10523,-13.3116,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 15:20:21.815','2024-06-13 13:20:22.326','2024-06-13 15:20:24.320'),('afc73513-2987-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/0fedc3b4-2961-11ef-8e16-d517f37fa2ad/session_4ba13230-2987-11ef-8e16-d517f37fa2ad/occlusion_4ba370c1-2987-11ef-8e16-d517f37fa2ad/scan_879dec53-2987-11ef-8e16-d517f37fa2ad/afc73513-2987-11ef-8e16-d517f37fa2ad.png','PATIENT_0fedc3b4-2961-11ef-8e16-d517f37fa2ad_ACT_4ba13230-2987-11ef-8e16-d517f37fa2ad_SESS_4ba370c1-2987-11ef-8e16-d517f37fa2ad_BOSC_879dec53-2987-11ef-8e16-d517f37fa2ad_SNAPS','afc73513-2987-11ef-8e16-d517f37fa2ad.png','afc73513-2987-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"4.1 Mandibola l1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 15:20:21.816','2024-06-13 13:20:22.326','2024-06-13 15:20:24.764'),('b08fc982-296a-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_4704a021-2963-11ef-8e16-d517f37fa2ad/occlusion_4706df6f-2963-11ef-8e16-d517f37fa2ad/scan_47f95341-2963-11ef-8e16-d517f37fa2ad/b08fc982-296a-11ef-8e16-d517f37fa2ad.ply','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_4704a021-2963-11ef-8e16-d517f37fa2ad_SESS_4706df6f-2963-11ef-8e16-d517f37fa2ad_TOSC_47f95341-2963-11ef-8e16-d517f37fa2ad_SEG','b08fc982-296a-11ef-8e16-d517f37fa2ad.ply','b08fc982-296a-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.1 Mascella u1 Segmentazione\"}','PLY',0,'SYNCED',0,NULL,'2024-06-13 11:52:47.726','2024-06-13 09:52:47.797','2024-06-13 11:52:48.451'),('b0cc95f2-233b-11ef-8f93-d92a45da78c9',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_23e52d54-2338-11ef-8f93-d92a45da78c9/b0cc95f2-233b-11ef-8f93-d92a45da78c9.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_BOSC_23e52d54-2338-11ef-8f93-d92a45da78c9_SCREENS','b0cc95f2-233b-11ef-8f93-d92a45da78c9.png','b0cc95f2-233b-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Mandibule l1 Capture d\'écran 2 [pc1]\",\"title\":\"2\"}','PNG',0,'SYNCED',0,NULL,'2024-06-05 15:01:15.000','2024-06-05 13:01:15.000','2024-06-05 15:01:15.000'),('b5074b88-2a2b-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/computedocclusion_e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd/b5074b88-2a2b-11ef-8f1c-d8242c6fa8fd.zip','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_OCC_e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd_TO1','b5074b88-2a2b-11ef-8f1c-d8242c6fa8fd.zip','4276476e-2a2b-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Occlusione o1 Mascella u1\",\"modelMatrix\":\"0.990607,-0.0477183,-0.128143,0,0.0606045,0.993278,0.0986225,0,0.122576,-0.105462,0.98684,0,-17.296,2.00683,-11.2545,1\",\"occlusionMatrix\":\"0.920264,-0.253816,-0.297823,0,0.207076,-0.329916,0.921021,0,-0.332026,-0.909252,-0.25105,0,-15.3539,10.9855,6.91144,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"3.2_u1\",\"referenceScanId\":\"8de1d45c-2a29-11ef-8f1c-d8242c6fa8fd\",\"scanBodies\":[]}','ZIP',2,'SYNCED',0,NULL,'2024-06-14 10:54:31.000','2024-06-14 08:54:31.000','2024-06-14 10:54:31.000'),('b63c4aa8-27ca-11ef-867c-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_ae662f01-27ca-11ef-8e37-d519fa9d22d2/b63c4aa8-27ca-11ef-867c-6ec2958327c0.zip','PATIENT_520a1417-2735-11ef-8e16-d517f37fa1ab_ACT_917767fe-23fa-11ef-8dde-d415e84cc4f5_SESS_91784208-23fa-11ef-8dde-d415e84cc4f5_TOSC_6b394d9c-273c-11ef-8e16-d517f37fa1ab_MODEL','76d290b9-273c-11ef-8e16-d517f37fa1ab.zip','b63c4aa8-27ca-11ef-867c-6ec2958327c0','{\"displayTitle\":\"7.2 Maxillaire u1 [pc2]\",\"modelMatrix\":\"-0.218201,0.935678,-0.277299,0,-0.958042,-0.259493,-0.121732,0,-0.185859,0.239102,0.953041,0,5.39353,-7.32203,-11.0012,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-10 17:17:04.000','2024-06-10 15:17:04.000','2024-06-10 17:17:04.000'),('b63cb440-27ca-11ef-867c-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_ae662f01-27ca-11ef-8e37-d519fa9d22d2/b63cb440-27ca-11ef-867c-6ec2958327c0.png','PATIENT_520a1417-2735-11ef-8e16-d517f37fa1ab_ACT_917767fe-23fa-11ef-8dde-d415e84cc4f5_SESS_91784208-23fa-11ef-8dde-d415e84cc4f5_TOSC_6b394d9c-273c-11ef-8e16-d517f37fa1ab_SNAPS','76d2a559-273c-11ef-8e16-d517f37fa1ab.png','b63cb440-27ca-11ef-867c-6ec2958327c0','{\"displayTitle\":\"7.2 Maxillaire u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-10 17:17:05.000','2024-06-10 15:17:05.000','2024-06-10 17:17:05.000'),('b63e0a77-27ca-11ef-867c-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_ae662f01-27ca-11ef-8e37-d519fa9d22d2/b63e0a77-27ca-11ef-867c-6ec2958327c0.pdf','PATIENT_520a1417-2735-11ef-8e16-d517f37fa1ab_ACT_917767fe-23fa-11ef-8dde-d415e84cc4f5_PROST_bed2bb1e-273c-11ef-8e16-d517f37fa1ab_FORM','adfd6dd3-27ca-11ef-8e37-d519fa9d22d2.pdf','b63e0a77-27ca-11ef-867c-6ec2958327c0','{\"displayTitle\":\"7.2 Couronne [pc2]\",\"title\":\"Couronne\"}','PDF',0,'SYNCED',0,NULL,'2024-06-11 10:14:54.000','2024-06-11 08:14:54.000','2024-06-11 10:14:54.000'),('b8d4e857-2968-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_4704a021-2963-11ef-8e16-d517f37fa2ad/occlusion_4706df6f-2963-11ef-8e16-d517f37fa2ad/scan_924b1ba0-2968-11ef-8e16-d517f37fa2ad/b8d4e857-2968-11ef-8e16-d517f37fa2ad.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_4704a021-2963-11ef-8e16-d517f37fa2ad_SESS_4706df6f-2963-11ef-8e16-d517f37fa2ad_LESC_924b1ba0-2968-11ef-8e16-d517f37fa2ad_MODEL','b8d4e857-2968-11ef-8e16-d517f37fa2ad.zip','b8d4e857-2968-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.1 Morso sinistro bl1\",\"modelMatrix\":\"-0.998966,0.0265027,-0.037053,0,-0.0175422,-0.972024,-0.233404,0,-0.0419441,-0.233382,0.971674,0,9.55658,-0.859968,-12.5363,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 11:38:42.607','2024-06-13 09:38:42.835','2024-06-13 11:39:26.022'),('b8d50d4d-2968-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_4704a021-2963-11ef-8e16-d517f37fa2ad/occlusion_4706df6f-2963-11ef-8e16-d517f37fa2ad/scan_924b1ba0-2968-11ef-8e16-d517f37fa2ad/b8d50d4d-2968-11ef-8e16-d517f37fa2ad.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_4704a021-2963-11ef-8e16-d517f37fa2ad_SESS_4706df6f-2963-11ef-8e16-d517f37fa2ad_LESC_924b1ba0-2968-11ef-8e16-d517f37fa2ad_SNAPS','b8d50d4d-2968-11ef-8e16-d517f37fa2ad.png','b8d50d4d-2968-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.1 Morso sinistro bl1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 11:38:42.608','2024-06-13 09:38:42.835','2024-06-13 11:39:26.876'),('b90fefbb-2970-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_8e81ab09-296b-11ef-8e16-d517f37fa2ad/occlusion_8e83509f-296b-11ef-8e16-d517f37fa2ad/computedocclusion_453321dd-296f-11ef-8e16-d517f37fa2ad/b90fefbb-2970-11ef-8e16-d517f37fa2ad.json','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_SESS_8e83509f-296b-11ef-8e16-d517f37fa2ad_OCC_453321dd-296f-11ef-8e16-d517f37fa2ad_METER','b90fefbb-2970-11ef-8e16-d517f37fa2ad.json','95dfa34a-2970-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Occlusione o1\",\"occlusionType\":1}','JSON',1,'SYNCED',0,NULL,'2024-06-13 12:35:58.968','2024-06-13 10:35:58.970','2024-06-13 12:35:59.264'),('b91dbada-289a-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/f373c86a-2899-11ef-8e16-d517f37fa2ad/session_0d1289f0-289a-11ef-8e16-d517f37fa2ad/occlusion_0d14f12a-289a-11ef-8e16-d517f37fa2ad/scan_a4a0d8da-289a-11ef-8e16-d517f37fa2ad/b91dbada-289a-11ef-8e16-d517f37fa2ad.zip','PATIENT_f373c86a-2899-11ef-8e16-d517f37fa2ad_ACT_0d1289f0-289a-11ef-8e16-d517f37fa2ad_SESS_0d14f12a-289a-11ef-8e16-d517f37fa2ad_BOSC_a4a0d8da-289a-11ef-8e16-d517f37fa2ad_MODEL','b91dbada-289a-11ef-8e16-d517f37fa2ad.zip','b91dbada-289a-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Mandibule l1\",\"modelMatrix\":\"0.9689,-0.0369733,-0.244677,0,0.0845235,0.978754,0.186805,0,0.232572,-0.201676,0.951439,0,-11.9484,3.92788,-10.1322,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-12 11:04:10.000','2024-06-12 09:04:10.000','2024-06-12 11:04:10.000'),('b91dc908-289a-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/f373c86a-2899-11ef-8e16-d517f37fa2ad/session_0d1289f0-289a-11ef-8e16-d517f37fa2ad/occlusion_0d14f12a-289a-11ef-8e16-d517f37fa2ad/scan_a4a0d8da-289a-11ef-8e16-d517f37fa2ad/b91dc908-289a-11ef-8e16-d517f37fa2ad.png','PATIENT_f373c86a-2899-11ef-8e16-d517f37fa2ad_ACT_0d1289f0-289a-11ef-8e16-d517f37fa2ad_SESS_0d14f12a-289a-11ef-8e16-d517f37fa2ad_BOSC_a4a0d8da-289a-11ef-8e16-d517f37fa2ad_SNAPS','b91dc908-289a-11ef-8e16-d517f37fa2ad.png','b91dc908-289a-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Mandibule l1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-12 11:04:10.000','2024-06-12 09:04:10.000','2024-06-12 11:04:10.000'),('ba5e7db3-2ee8-11ef-bb8b-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_b8d62e1b-2ee8-11ef-8dc9-d414e3397395/ba5e7db3-2ee8-11ef-bb8b-6ec2958327c0.png','PATIENT_0d66331b-2eda-11ef-8de3-d515e950d747_ACT_9a8959c0-2edd-11ef-8de3-d515e950d747_SESS_9a8a5a9c-2edd-11ef-8de3-d515e950d747_OCC_4eace0e6-2ee5-11ef-8dc9-d414e3397395_SCREENO','0b495fe1-2ee6-11ef-8dc9-d414e3397395.png','ba5e7db3-2ee8-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.1 Occlusion o1 Screenshot 1\",\"occlusionType\":2,\"title\":\"1\"}','PNG',0,'SYNCED',0,NULL,'2024-06-20 11:18:23.000','2024-06-20 09:18:23.000','2024-06-20 11:18:23.000'),('ba622ef9-2ee8-11ef-bb8b-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_b8d62e1b-2ee8-11ef-8dc9-d414e3397395/ba622ef9-2ee8-11ef-bb8b-6ec2958327c0.png','PATIENT_0d66331b-2eda-11ef-8de3-d515e950d747_ACT_9a8959c0-2edd-11ef-8de3-d515e950d747_SESS_9a8a5a9c-2edd-11ef-8de3-d515e950d747_TOSC_efafa8a6-2ee4-11ef-8dc9-d414e3397395_SNAPS','14c3c16a-2ee5-11ef-8dc9-d414e3397395.png','ba622ef9-2ee8-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.1 Maxilla u1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-20 11:11:32.000','2024-06-20 09:11:32.000','2024-06-20 11:11:32.000'),('ba627997-2ee8-11ef-bb8b-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_b8d62e1b-2ee8-11ef-8dc9-d414e3397395/ba627997-2ee8-11ef-bb8b-6ec2958327c0.png','PATIENT_0d66331b-2eda-11ef-8de3-d515e950d747_ACT_9a8959c0-2edd-11ef-8de3-d515e950d747_SESS_9a8a5a9c-2edd-11ef-8de3-d515e950d747_TOSC_efafa8a6-2ee4-11ef-8dc9-d414e3397395_SCREENS','155e9236-2ee8-11ef-8dc9-d414e3397395.png','ba627997-2ee8-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.1 Maxilla u1 Screenshot 2\",\"title\":\"2\"}','PNG',0,'SYNCED',0,NULL,'2024-06-20 11:32:59.000','2024-06-20 09:32:59.000','2024-06-20 11:32:59.000'),('ba62c37a-2ee8-11ef-bb8b-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_b8d62e1b-2ee8-11ef-8dc9-d414e3397395/ba62c37a-2ee8-11ef-bb8b-6ec2958327c0.zip','PATIENT_0d66331b-2eda-11ef-8de3-d515e950d747_ACT_9a8959c0-2edd-11ef-8de3-d515e950d747_SESS_9a8a5a9c-2edd-11ef-8de3-d515e950d747_TOSC_efafa8a6-2ee4-11ef-8dc9-d414e3397395_MODEL','2b6cd3da-2ee5-11ef-8dc9-d414e3397395.zip','ba62c37a-2ee8-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.1 Maxilla u1\",\"modelMatrix\":\"0.472136,0.878125,0.0773602,0,-0.793392,0.461541,-0.396874,0,-0.38421,0.126001,0.914607,0,2.78486,1.94837,-12.4512,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-20 11:13:04.000','2024-06-20 09:13:04.000','2024-06-20 11:13:04.000'),('ba6304d5-2ee8-11ef-bb8b-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_b8d62e1b-2ee8-11ef-8dc9-d414e3397395/ba6304d5-2ee8-11ef-bb8b-6ec2958327c0.png','PATIENT_0d66331b-2eda-11ef-8de3-d515e950d747_ACT_9a8959c0-2edd-11ef-8de3-d515e950d747_SESS_9a8a5a9c-2edd-11ef-8de3-d515e950d747_OCC_4eace0e6-2ee5-11ef-8dc9-d414e3397395_SNAPO','763b241a-2ee5-11ef-8dc9-d414e3397395.png','ba6304d5-2ee8-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.1 Occlusion o1\",\"occlusionType\":2}','PNG',0,'SYNCED',0,NULL,'2024-06-20 11:14:14.000','2024-06-20 09:37:34.000','2024-06-20 11:37:34.000'),('ba634a29-2ee8-11ef-bb8b-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_b8d62e1b-2ee8-11ef-8dc9-d414e3397395/ba634a29-2ee8-11ef-bb8b-6ec2958327c0.zip','PATIENT_0d66331b-2eda-11ef-8de3-d515e950d747_ACT_9a8959c0-2edd-11ef-8de3-d515e950d747_SESS_9a8a5a9c-2edd-11ef-8de3-d515e950d747_OCC_4eace0e6-2ee5-11ef-8dc9-d414e3397395_TO1','7e981dac-2ee5-11ef-8dc9-d414e3397395.zip','ba634a29-2ee8-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.1 Occlusion o1 Maxilla u1\",\"modelMatrix\":\"0.472136,0.878125,0.0773602,0,-0.793392,0.461541,-0.396874,0,-0.38421,0.126001,0.914607,0,2.78486,1.94837,-12.4512,1\",\"occlusionMatrix\":\"-0.974235,-0.0712844,-0.213987,0,0.178518,0.336163,-0.924728,0,0.137853,-0.939106,-0.314775,0,-3.23436,8.78515,0.532737,1\",\"occlusionType\":2,\"referenceScanFullDisplayId\":\"1.1_u1\",\"referenceScanId\":\"efafa8a6-2ee4-11ef-8dc9-d414e3397395\",\"scanBodies\":[],\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":3,\"socleIsFullArch\":true,\"socleThickness\":1,\"socleType\":3}','ZIP',0,'SYNCED',0,NULL,'2024-06-20 11:14:28.000','2024-06-20 09:37:34.000','2024-06-20 11:37:34.000'),('ba638ec6-2ee8-11ef-bb8b-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_b8d62e1b-2ee8-11ef-8dc9-d414e3397395/ba638ec6-2ee8-11ef-bb8b-6ec2958327c0.zip','PATIENT_0d66331b-2eda-11ef-8de3-d515e950d747_ACT_9a8959c0-2edd-11ef-8de3-d515e950d747_SESS_9a8a5a9c-2edd-11ef-8de3-d515e950d747_OCC_4eace0e6-2ee5-11ef-8dc9-d414e3397395_BO1','7e983dec-2ee5-11ef-8dc9-d414e3397395.zip','ba638ec6-2ee8-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.1 Occlusion o1 Mandible l1\",\"modelMatrix\":\"0.90883,-0.414032,0.0510396,0,0.414593,0.882875,-0.220555,0,0.0462551,0.221608,0.974038,0,-3.57283,2.38013,-12.2636,1\",\"occlusionMatrix\":\"-0.996501,-0.0496922,-0.0672998,0,-0.0690546,0.0344822,0.997022,0,-0.0472233,0.998174,-0.0377907,0,5.46924,-6.85076,3.49288,1\",\"occlusionType\":2,\"referenceScanFullDisplayId\":\"1.1_l1\",\"referenceScanId\":\"2b76d979-2ee5-11ef-8dc9-d414e3397395\",\"scanBodies\":[],\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":3,\"socleIsFullArch\":true,\"socleThickness\":1,\"socleType\":3}','ZIP',0,'SYNCED',0,NULL,'2024-06-20 11:14:29.000','2024-06-20 09:37:34.000','2024-06-20 11:37:34.000'),('ba63dc6d-2ee8-11ef-bb8b-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_b8d62e1b-2ee8-11ef-8dc9-d414e3397395/ba63dc6d-2ee8-11ef-bb8b-6ec2958327c0.xyz','PATIENT_0d66331b-2eda-11ef-8de3-d515e950d747_ACT_9a8959c0-2edd-11ef-8de3-d515e950d747_SESS_9a8a5a9c-2edd-11ef-8de3-d515e950d747_TOSC_efafa8a6-2ee4-11ef-8dc9-d414e3397395_LIFI','999cf1f1-2ee5-11ef-8dc9-d414e3397395.xyz','ba63dc6d-2ee8-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.1 Maxilla u1 Finishing line 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-20 11:15:13.000','2024-06-20 09:15:13.000','2024-06-20 11:15:13.000'),('ba642178-2ee8-11ef-bb8b-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_b8d62e1b-2ee8-11ef-8dc9-d414e3397395/ba642178-2ee8-11ef-bb8b-6ec2958327c0.bin','PATIENT_0d66331b-2eda-11ef-8de3-d515e950d747_ACT_9a8959c0-2edd-11ef-8de3-d515e950d747_SESS_9a8a5a9c-2edd-11ef-8de3-d515e950d747_TOSC_efafa8a6-2ee4-11ef-8dc9-d414e3397395_LIFIM','999cf72c-2ee5-11ef-8dc9-d414e3397395.bin','ba642178-2ee8-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.1 Maxilla u1 Metadata finishing line 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-20 11:15:13.000','2024-06-20 09:15:13.000','2024-06-20 11:15:13.000'),('ba646775-2ee8-11ef-bb8b-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_b8d62e1b-2ee8-11ef-8dc9-d414e3397395/ba646775-2ee8-11ef-bb8b-6ec2958327c0.xyz','PATIENT_0d66331b-2eda-11ef-8de3-d515e950d747_ACT_9a8959c0-2edd-11ef-8de3-d515e950d747_SESS_9a8a5a9c-2edd-11ef-8de3-d515e950d747_OCC_4eace0e6-2ee5-11ef-8dc9-d414e3397395_LIFIO','999f2a74-2ee5-11ef-8dc9-d414e3397395.xyz','ba646775-2ee8-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.1 Occlusion o1 Maxilla u1 Finishing line 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY_1\",\"referenceScanFullDisplayId\":\"1.1_u1\",\"referenceScanId\":\"efafa8a6-2ee4-11ef-8dc9-d414e3397395\",\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-20 11:15:13.000','2024-06-20 09:15:13.000','2024-06-20 11:15:13.000'),('ba64ace5-2ee8-11ef-bb8b-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_b8d62e1b-2ee8-11ef-8dc9-d414e3397395/ba64ace5-2ee8-11ef-bb8b-6ec2958327c0.bin','PATIENT_0d66331b-2eda-11ef-8de3-d515e950d747_ACT_9a8959c0-2edd-11ef-8de3-d515e950d747_SESS_9a8a5a9c-2edd-11ef-8de3-d515e950d747_OCC_4eace0e6-2ee5-11ef-8dc9-d414e3397395_LIFIMO','999f2dfa-2ee5-11ef-8dc9-d414e3397395.bin','ba64ace5-2ee8-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.1 Occlusion o1 Maxilla u1 Metadata finishing line 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY_1\",\"referenceScanFullDisplayId\":\"1.1_u1\",\"referenceScanId\":\"efafa8a6-2ee4-11ef-8dc9-d414e3397395\",\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-20 11:15:13.000','2024-06-20 09:15:13.000','2024-06-20 11:15:13.000'),('ba64f8f3-2ee8-11ef-bb8b-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_b8d62e1b-2ee8-11ef-8dc9-d414e3397395/ba64f8f3-2ee8-11ef-bb8b-6ec2958327c0.png','PATIENT_0d66331b-2eda-11ef-8de3-d515e950d747_ACT_9a8959c0-2edd-11ef-8de3-d515e950d747_SESS_9a8a5a9c-2edd-11ef-8de3-d515e950d747_TOSC_efafa8a6-2ee4-11ef-8dc9-d414e3397395_SCREENS','b6800e55-2ee7-11ef-8dc9-d414e3397395.png','ba64f8f3-2ee8-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.1 Maxilla u1 Screenshot 1\",\"title\":\"1\"}','PNG',0,'SYNCED',0,NULL,'2024-06-20 11:30:20.000','2024-06-20 09:30:20.000','2024-06-20 11:30:20.000'),('ba654268-2ee8-11ef-bb8b-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_b8d62e1b-2ee8-11ef-8dc9-d414e3397395/ba654268-2ee8-11ef-bb8b-6ec2958327c0.pdf','PATIENT_0d66331b-2eda-11ef-8de3-d515e950d747_ACT_9a8959c0-2edd-11ef-8de3-d515e950d747_PROST_afc82063-2ee8-11ef-8dc9-d414e3397395_FORM','b869af3f-2ee8-11ef-8dc9-d414e3397395.pdf','ba654268-2ee8-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.1 Crown\",\"title\":\"Crown\"}','PDF',0,'SYNCED',0,NULL,'2024-06-20 11:37:34.000','2024-06-20 09:37:34.000','2024-06-20 11:37:34.000'),('ba6586d0-2ee8-11ef-bb8b-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_b8d62e1b-2ee8-11ef-8dc9-d414e3397395/ba6586d0-2ee8-11ef-bb8b-6ec2958327c0.zip','PATIENT_0d66331b-2eda-11ef-8de3-d515e950d747_ACT_9a8959c0-2edd-11ef-8de3-d515e950d747_SESS_9a8a5a9c-2edd-11ef-8de3-d515e950d747_OCC_4eace0e6-2ee5-11ef-8dc9-d414e3397395_TO2','e69b549f-2ee5-11ef-8dc9-d414e3397395.zip','ba6586d0-2ee8-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.1 Occlusion o1 Maxilla u2\",\"modelMatrix\":\"0.472136,0.878125,0.0773602,0,-0.793392,0.461541,-0.396874,0,-0.38421,0.126001,0.914607,0,2.78486,1.94837,-12.4512,1\",\"occlusionMatrix\":\"-0.974235,-0.0712842,-0.213986,0,0.178517,0.336165,-0.924727,0,0.137853,-0.939106,-0.314777,0,-3.23437,8.78516,0.532764,1\",\"occlusionType\":2,\"referenceScanFullDisplayId\":\"1.1_u2\",\"referenceScanId\":\"a7e9085c-2ee5-11ef-8dc9-d414e3397395\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-20 11:17:22.000','2024-06-20 09:17:22.000','2024-06-20 11:17:22.000'),('bdac5d67-28ba-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/a49d8d6e-28b9-11ef-8e16-d517f37fa2ad/session_9c9bb412-28ba-11ef-8e16-d517f37fa2ad/occlusion_9c9dff16-28ba-11ef-8e16-d517f37fa2ad/scan_9d83e262-28ba-11ef-8e16-d517f37fa2ad/bdac5d67-28ba-11ef-8e16-d517f37fa2ad.zip','PATIENT_a49d8d6e-28b9-11ef-8e16-d517f37fa2ad_ACT_9c9bb412-28ba-11ef-8e16-d517f37fa2ad_SESS_9c9dff16-28ba-11ef-8e16-d517f37fa2ad_TOSC_9d83e262-28ba-11ef-8e16-d517f37fa2ad_MODEL','bdac5d67-28ba-11ef-8e16-d517f37fa2ad.zip','bdac5d67-28ba-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"2.1 Maxillaire u1\",\"modelMatrix\":\"-0.647127,-0.754898,-0.106561,0,0.677493,-0.633524,0.373698,0,-0.349613,0.169636,0.921409,0,11.6655,10.4109,-10.6048,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,'2024-06-12 14:54:09.521','2024-06-12 14:53:18.299','2024-06-12 12:54:09.523','2024-06-12 14:54:09.536'),('bdac733c-28ba-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/a49d8d6e-28b9-11ef-8e16-d517f37fa2ad/session_9c9bb412-28ba-11ef-8e16-d517f37fa2ad/occlusion_9c9dff16-28ba-11ef-8e16-d517f37fa2ad/scan_9d83e262-28ba-11ef-8e16-d517f37fa2ad/bdac733c-28ba-11ef-8e16-d517f37fa2ad.png','PATIENT_a49d8d6e-28b9-11ef-8e16-d517f37fa2ad_ACT_9c9bb412-28ba-11ef-8e16-d517f37fa2ad_SESS_9c9dff16-28ba-11ef-8e16-d517f37fa2ad_TOSC_9d83e262-28ba-11ef-8e16-d517f37fa2ad_SNAPS','bdac733c-28ba-11ef-8e16-d517f37fa2ad.png','bdac733c-28ba-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"2.1 Maxillaire u1 Snapshot\"}','PNG',0,'SYNCED',0,'2024-06-12 14:54:09.521','2024-06-12 14:53:18.299','2024-06-12 12:54:09.526','2024-06-12 14:54:09.537'),('bdb51817-289d-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/f373c86a-2899-11ef-8e16-d517f37fa2ad/session_0d1289f0-289a-11ef-8e16-d517f37fa2ad/order_0d191b14-289a-11ef-8e16-d517f37fa2ad/bdb51817-289d-11ef-8e16-d517f37fa2ad.pdf','PATIENT_f373c86a-2899-11ef-8e16-d517f37fa2ad_ACT_0d1289f0-289a-11ef-8e16-d517f37fa2ad_PROST_0d191b14-289a-11ef-8e16-d517f37fa2ad_FORM','bdb51817-289d-11ef-8e16-d517f37fa2ad.pdf','bdb51817-289d-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Guide\",\"title\":\"Guide\"}','PDF',0,'SYNCED',0,NULL,'2024-06-12 11:25:45.000','2024-06-12 09:25:45.000','2024-06-12 11:25:45.000'),('bde80801-2e42-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/4382037a-2735-11ef-8e16-d517f37fa1ab/session_68af0333-2e42-11ef-8deb-d515ea58f6cb/occlusion_68b10ccb-2e42-11ef-8deb-d515ea58f6cb/scan_70f3c64d-2e42-11ef-8deb-d515ea58f6cb/bde80801-2e42-11ef-8deb-d515ea58f6cb.png','PATIENT_4382037a-2735-11ef-8e16-d517f37fa1ab_ACT_68af0333-2e42-11ef-8deb-d515ea58f6cb_SESS_68b10ccb-2e42-11ef-8deb-d515ea58f6cb_TOSC_70f3c64d-2e42-11ef-8deb-d515ea58f6cb_SCREENS','bde80801-2e42-11ef-8deb-d515ea58f6cb.png','bde80801-2e42-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"6.4 Maxilla u1 Screenshot test [pc2]\",\"title\":\"test\"}','PNG',0,'SYNCED',0,NULL,'2024-06-19 15:49:44.082','2024-06-19 13:49:44.083','2024-06-19 15:49:44.095'),('be74e814-2e41-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/4382037a-2735-11ef-8e16-d517f37fa1ab/session_8598ee4a-2e40-11ef-8deb-d515ea58f6cb/occlusion_859bd7ba-2e40-11ef-8deb-d515ea58f6cb/scan_86f46641-2e40-11ef-8deb-d515ea58f6cb/be74e814-2e41-11ef-8deb-d515ea58f6cb.json','PATIENT_4382037a-2735-11ef-8e16-d517f37fa1ab_ACT_8598ee4a-2e40-11ef-8deb-d515ea58f6cb_SESS_859bd7ba-2e40-11ef-8deb-d515ea58f6cb_TOSC_86f46641-2e40-11ef-8deb-d515ea58f6cb_METER','be74e814-2e41-11ef-8deb-d515ea58f6cb.json','be74e814-2e41-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"6.3 Maxilla u1 Measurement [pc2]\"}','JSON',0,'SYNCED',0,NULL,'2024-06-19 15:42:18.130','2024-06-19 13:42:18.142','2024-06-19 15:42:18.627'),('be9062f3-2982-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_08eb58c6-2980-11ef-8e16-d517f37fa2ad/occlusion_08ed7a4a-2980-11ef-8e16-d517f37fa2ad/computedocclusion_a4bc6912-2980-11ef-8e16-d517f37fa2ad/be9062f3-2982-11ef-8e16-d517f37fa2ad.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_OCC_a4bc6912-2980-11ef-8e16-d517f37fa2ad_SCREENO','be9062f3-2982-11ef-8e16-d517f37fa2ad.png','be9062f3-2982-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.5 Occlusione o1 Screenshot 1\",\"occlusionType\":3,\"title\":\"1\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 14:45:00.000','2024-06-13 12:45:00.000','2024-06-13 14:45:00.000'),('bedc779c-2733-11ef-867c-6ec2958327c0',5,'/var/.scan4all/iris/data/2024/5/discussion_8e7e9088-2733-11ef-8e16-d517f37fa1ab/bedc779c-2733-11ef-867c-6ec2958327c0.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_a4139c9d-2279-11ef-8d76-d310d2ec2c14_SESS_a4160b84-2279-11ef-8d76-d310d2ec2c14_TOSC_a6d98df1-2279-11ef-8d76-d310d2ec2c14_MODEL','ca114ae6-2279-11ef-8d76-d310d2ec2c14.zip','bedc779c-2733-11ef-867c-6ec2958327c0','{\"displayTitle\":\"1.3 Maxillaire u1 [pc2]\",\"modelMatrix\":\"-0.418905,0.900302,-0.11822,0,-0.907719,-0.411789,0.0804737,0,0.0237688,0.141021,0.989721,0,6.97337,-8.05933,-15.0874,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 15:53:20.000','2024-06-04 13:53:20.000','2024-06-04 15:53:20.000'),('bee128b6-2733-11ef-867c-6ec2958327c0',5,'/var/.scan4all/iris/data/2024/5/discussion_8e7e9088-2733-11ef-8e16-d517f37fa1ab/bee128b6-2733-11ef-867c-6ec2958327c0.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_a4139c9d-2279-11ef-8d76-d310d2ec2c14_SESS_a4160b84-2279-11ef-8d76-d310d2ec2c14_TOSC_a6d98df1-2279-11ef-8d76-d310d2ec2c14_SNAPS','ca116050-2279-11ef-8d76-d310d2ec2c14.png','bee128b6-2733-11ef-867c-6ec2958327c0','{\"displayTitle\":\"1.3 Maxillaire u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 15:53:20.000','2024-06-04 13:53:20.000','2024-06-04 15:53:20.000'),('bf9e8d51-2e42-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/4382037a-2735-11ef-8e16-d517f37fa1ab/session_68af0333-2e42-11ef-8deb-d515ea58f6cb/occlusion_68b10ccb-2e42-11ef-8deb-d515ea58f6cb/scan_70f3c64d-2e42-11ef-8deb-d515ea58f6cb/bf9e8d51-2e42-11ef-8deb-d515ea58f6cb.json','PATIENT_4382037a-2735-11ef-8e16-d517f37fa1ab_ACT_68af0333-2e42-11ef-8deb-d515ea58f6cb_SESS_68b10ccb-2e42-11ef-8deb-d515ea58f6cb_TOSC_70f3c64d-2e42-11ef-8deb-d515ea58f6cb_METER','bf9e8d51-2e42-11ef-8deb-d515ea58f6cb.json','bf9e8d51-2e42-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"6.4 Maxilla u1 Measurement [pc2]\"}','JSON',0,'SYNCED',0,NULL,'2024-06-19 15:49:29.578','2024-06-19 13:49:29.579','2024-06-19 15:49:30.300'),('c10a25c6-2a2e-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/scan_aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd/c10a25c6-2a2e-11ef-8f1c-d8242c6fa8fd.zip','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_BOSC_aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd_MODEL','c10a25c6-2a2e-11ef-8f1c-d8242c6fa8fd.zip','aee5f3db-2a2e-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Mandibola l2\",\"modelMatrix\":\"-0.934662,0.348207,-0.071824,0,-0.340741,-0.934968,-0.098644,0,-0.101502,-0.0677254,0.992527,0,16.8656,-3.96577,-16.4235,1\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2024-06-14 11:16:19.000','2024-06-14 09:16:19.000','2024-06-14 11:16:19.000'),('c13314ae-289e-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/f373c86a-2899-11ef-8e16-d517f37fa2ad/session_627cfe1c-289b-11ef-8e16-d517f37fa2ad/order_6282c146-289b-11ef-8e16-d517f37fa2ad/c13314ae-289e-11ef-8e16-d517f37fa2ad.pdf','PATIENT_f373c86a-2899-11ef-8e16-d517f37fa2ad_ACT_627cfe1c-289b-11ef-8e16-d517f37fa2ad_PROST_6282c146-289b-11ef-8e16-d517f37fa2ad_FORM','c13314ae-289e-11ef-8e16-d517f37fa2ad.pdf','c13314ae-289e-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.2 Autre\",\"title\":\"Autre\"}','PDF',0,'SYNCED',0,NULL,'2024-06-12 11:33:00.000','2024-06-12 09:33:00.000','2024-06-12 11:33:00.000'),('c191f4f9-2e3b-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_da1f6873-2e3a-11ef-8deb-d515ea58f6cb/occlusion_da21a6e4-2e3a-11ef-8deb-d515ea58f6cb/computedocclusion_89b4ac38-2e3b-11ef-8deb-d515ea58f6cb/c191f4f9-2e3b-11ef-8deb-d515ea58f6cb.zip','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_da1f6873-2e3a-11ef-8deb-d515ea58f6cb_SESS_da21a6e4-2e3a-11ef-8deb-d515ea58f6cb_OCC_89b4ac38-2e3b-11ef-8deb-d515ea58f6cb_TO1','c191f4f9-2e3b-11ef-8deb-d515ea58f6cb.zip','c191f4f9-2e3b-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.2 Occlusion o1 Maxilla u1 [pc2]\",\"modelMatrix\":\"-0.987665,0.123358,-0.0964428,0,-0.113297,-0.98814,-0.103648,0,-0.108085,-0.0914428,0.989927,0,-2.13191,0.552438,-11.8505,1\",\"occlusionMatrix\":\"-0.9973,0.00169271,-0.0715413,0,0.0644086,-0.443846,-0.893759,0,-0.0353509,-0.896103,0.442811,0,0.115475,9.97096,-2.32969,1\",\"occlusionType\":2,\"referenceScanFullDisplayId\":\"16.2_u1\",\"referenceScanId\":\"dc038d5b-2e3a-11ef-8deb-d515ea58f6cb\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-19 14:59:29.000','2024-06-19 12:59:29.000','2024-06-19 14:59:29.000'),('c1a4a542-2a2c-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/scan_80540c46-2a2a-11ef-8f1c-d8242c6fa8fd/c1a4a542-2a2c-11ef-8f1c-d8242c6fa8fd.png','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_BOSC_80540c46-2a2a-11ef-8f1c-d8242c6fa8fd_SCREENS','c1a4a542-2a2c-11ef-8f1c-d8242c6fa8fd.png','c1a4a542-2a2c-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Mandibola l1 Screenshot 3\",\"title\":\"3\"}','PNG',0,'SYNCED',0,NULL,'2024-06-14 11:02:00.269','2024-06-14 09:02:00.329','2024-06-14 11:02:00.588'),('c1a8eaf0-2e3b-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_da1f6873-2e3a-11ef-8deb-d515ea58f6cb/occlusion_da21a6e4-2e3a-11ef-8deb-d515ea58f6cb/computedocclusion_89b4ac38-2e3b-11ef-8deb-d515ea58f6cb/c1a8eaf0-2e3b-11ef-8deb-d515ea58f6cb.zip','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_da1f6873-2e3a-11ef-8deb-d515ea58f6cb_SESS_da21a6e4-2e3a-11ef-8deb-d515ea58f6cb_OCC_89b4ac38-2e3b-11ef-8deb-d515ea58f6cb_BO1','c1a8eaf0-2e3b-11ef-8deb-d515ea58f6cb.zip','c1a8eaf0-2e3b-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.2 Occlusion o1 Mandible l1 [pc2]\",\"modelMatrix\":\"0.988345,0.152164,-0.00455078,0,-0.132711,0.846578,-0.515455,0,-0.0745809,0.510051,0.856905,0,-6.06382,-8.89201,-8.94358,1\",\"occlusionMatrix\":\"-0.93359,0.351143,-0.0631182,0,-0.289799,-0.84929,-0.44132,0,-0.2108,-0.394224,0.895128,0,7.15248,4.36353,-7.26677,1\",\"occlusionType\":2,\"referenceScanFullDisplayId\":\"16.2_l1\",\"referenceScanId\":\"18dce61e-2e3b-11ef-8deb-d515ea58f6cb\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-19 14:59:31.000','2024-06-19 12:59:31.000','2024-06-19 14:59:31.000'),('c20b977f-2e29-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_62b97c61-226c-11ef-8d76-d310d2ec2c14/occlusion_62bbada3-226c-11ef-8d76-d310d2ec2c14/scan_389889a4-2272-11ef-8d76-d310d2ec2c14/c20b977f-2e29-11ef-8deb-d515ea58f6cb.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_62b97c61-226c-11ef-8d76-d310d2ec2c14_SESS_62bbada3-226c-11ef-8d76-d310d2ec2c14_TOSC_389889a4-2272-11ef-8d76-d310d2ec2c14_MODEL','c20b977f-2e29-11ef-8deb-d515ea58f6cb.zip','5bd68def-2272-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.1 Maxillaire u1 [pc2]\",\"modelMatrix\":\"0.901424,-0.415146,-0.12284,0,0.404409,0.908712,-0.10342,0,0.154561,0.0435476,0.987023,0,-9.88483,-1.72313,-15.441,1\",\"scanBodies\":[],\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":3,\"socleIsFullArch\":true,\"socleThickness\":-1,\"socleType\":1}','ZIP',1,'SYNCED',0,NULL,'2024-06-19 12:50:36.229','2024-06-19 10:50:36.298','2024-06-19 12:50:36.759'),('c22f9f80-2e3b-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_da1f6873-2e3a-11ef-8deb-d515ea58f6cb/occlusion_da21a6e4-2e3a-11ef-8deb-d515ea58f6cb/computedocclusion_89b4ac38-2e3b-11ef-8deb-d515ea58f6cb/c22f9f80-2e3b-11ef-8deb-d515ea58f6cb.png','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_da1f6873-2e3a-11ef-8deb-d515ea58f6cb_SESS_da21a6e4-2e3a-11ef-8deb-d515ea58f6cb_OCC_89b4ac38-2e3b-11ef-8deb-d515ea58f6cb_SNAPO','c22f9f80-2e3b-11ef-8deb-d515ea58f6cb.png','c22f9f80-2e3b-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.2 Occlusion o1 [pc2]\",\"occlusionType\":2}','PNG',0,'SYNCED',0,NULL,'2024-06-19 14:59:31.000','2024-06-19 12:59:31.000','2024-06-19 14:59:31.000'),('c2d2d4e4-2964-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_4704a021-2963-11ef-8e16-d517f37fa2ad/occlusion_4706df6f-2963-11ef-8e16-d517f37fa2ad/scan_47f95341-2963-11ef-8e16-d517f37fa2ad/c2d2d4e4-2964-11ef-8e16-d517f37fa2ad.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_4704a021-2963-11ef-8e16-d517f37fa2ad_SESS_4706df6f-2963-11ef-8e16-d517f37fa2ad_TOSC_47f95341-2963-11ef-8e16-d517f37fa2ad_MODEL','c2d2d4e4-2964-11ef-8e16-d517f37fa2ad.zip','6487d4c6-2964-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.1 Mascella u1\",\"modelMatrix\":\"0.432825,-0.89967,-0.0570733,0,0.880417,0.43547,-0.187701,0,0.193722,0.0309933,0.980567,0,-23.5715,9.30099,-17.1386,1\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2024-06-13 11:10:21.384','2024-06-13 09:10:21.502','2024-06-13 11:10:21.776'),('c2deb6fb-2720-11ef-8e16-d517f37fa1ab',2,'/var/.scan4all/iris/data/2024/2/a1ace9b5-2271-11ef-8d76-d310d2ec2c14/session_a3cf95b8-2720-11ef-8e16-d517f37fa1ab/analyse_a3d2f769-2720-11ef-8e16-d517f37fa1ab/c2deb6fb-2720-11ef-8e16-d517f37fa1ab.json','PATIENT_a1ace9b5-2271-11ef-8d76-d310d2ec2c14_ACT_a3cf95b8-2720-11ef-8e16-d517f37fa1ab_ANA_a3d2f769-2720-11ef-8e16-d517f37fa1ab_TRANS','c2deb6fb-2720-11ef-8e16-d517f37fa1ab.json','c2deb6fb-2720-11ef-8e16-d517f37fa1ab','{\"displayTitle\":\"2.3 Analyse c1 [pc2]\"}','JSON',0,'SYNCED',0,NULL,'2024-06-10 15:34:32.000','2024-06-10 13:34:32.000','2024-06-10 15:34:32.000'),('c32e1621-2720-11ef-8e16-d517f37fa1ab',2,'/var/.scan4all/iris/data/2024/2/a1ace9b5-2271-11ef-8d76-d310d2ec2c14/session_a3cf95b8-2720-11ef-8e16-d517f37fa1ab/analyse_a3d2f769-2720-11ef-8e16-d517f37fa1ab/c32e1621-2720-11ef-8e16-d517f37fa1ab.png','PATIENT_a1ace9b5-2271-11ef-8d76-d310d2ec2c14_ACT_a3cf95b8-2720-11ef-8e16-d517f37fa1ab_ANA_a3d2f769-2720-11ef-8e16-d517f37fa1ab_SNAPS','c32e1621-2720-11ef-8e16-d517f37fa1ab.png','c32e1621-2720-11ef-8e16-d517f37fa1ab','{\"displayTitle\":\"2.3 Analyse c1 [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-10 15:34:32.000','2024-06-10 13:34:32.000','2024-06-10 15:34:32.000'),('c4879c59-2969-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_4704a021-2963-11ef-8e16-d517f37fa2ad/occlusion_4706df6f-2963-11ef-8e16-d517f37fa2ad/scan_366c910a-2969-11ef-8e16-d517f37fa2ad/c4879c59-2969-11ef-8e16-d517f37fa2ad.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_4704a021-2963-11ef-8e16-d517f37fa2ad_SESS_4706df6f-2963-11ef-8e16-d517f37fa2ad_RISC_366c910a-2969-11ef-8e16-d517f37fa2ad_MODEL','c4879c59-2969-11ef-8e16-d517f37fa2ad.zip','c4879c59-2969-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.1 Morso destro br3\",\"modelMatrix\":\"0.99966,-0.0198445,-0.0140633,0,0.0189064,0.971361,-0.23287,0,0.0181689,0.236836,0.972417,0,-21.9706,-4.95374,-10.6208,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 11:46:11.730','2024-06-13 09:46:12.349','2024-06-13 11:46:16.278'),('c487b021-2969-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_4704a021-2963-11ef-8e16-d517f37fa2ad/occlusion_4706df6f-2963-11ef-8e16-d517f37fa2ad/scan_366c910a-2969-11ef-8e16-d517f37fa2ad/c487b021-2969-11ef-8e16-d517f37fa2ad.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_4704a021-2963-11ef-8e16-d517f37fa2ad_SESS_4706df6f-2963-11ef-8e16-d517f37fa2ad_RISC_366c910a-2969-11ef-8e16-d517f37fa2ad_SNAPS','c487b021-2969-11ef-8e16-d517f37fa2ad.png','c487b021-2969-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.1 Morso destro br3 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 11:46:11.730','2024-06-13 09:46:12.349','2024-06-13 11:46:17.522'),('c4d47e7b-296d-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_8e81ab09-296b-11ef-8e16-d517f37fa2ad/occlusion_8e83509f-296b-11ef-8e16-d517f37fa2ad/scan_890595a9-296d-11ef-8e16-d517f37fa2ad/c4d47e7b-296d-11ef-8e16-d517f37fa2ad.zip','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_SESS_8e83509f-296b-11ef-8e16-d517f37fa2ad_TOSC_890595a9-296d-11ef-8e16-d517f37fa2ad_MODEL','c4d47e7b-296d-11ef-8e16-d517f37fa2ad.zip','c4d47e7b-296d-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Mascella u3\",\"modelMatrix\":\"-0.864017,0.469494,-0.181796,0,-0.39807,-0.858135,-0.324261,0,-0.308244,-0.207799,0.928335,0,19.5091,-2.8713,-9.9809,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 12:14:50.221','2024-06-13 10:14:51.122','2024-06-13 12:14:53.274'),('c4d49e5a-296d-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_8e81ab09-296b-11ef-8e16-d517f37fa2ad/occlusion_8e83509f-296b-11ef-8e16-d517f37fa2ad/scan_890595a9-296d-11ef-8e16-d517f37fa2ad/c4d49e5a-296d-11ef-8e16-d517f37fa2ad.png','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_SESS_8e83509f-296b-11ef-8e16-d517f37fa2ad_TOSC_890595a9-296d-11ef-8e16-d517f37fa2ad_SNAPS','c4d49e5a-296d-11ef-8e16-d517f37fa2ad.png','c4d49e5a-296d-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Mascella u3 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 12:14:50.221','2024-06-13 10:14:51.122','2024-06-13 12:14:53.782'),('c52419e8-2278-11ef-8d76-d310d2ec2c14',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/scan_c523efdb-2278-11ef-8d76-d310d2ec2c14/c52419e8-2278-11ef-8d76-d310d2ec2c14.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_TOSC_c523efdb-2278-11ef-8d76-d310d2ec2c14_MODEL','c52419e8-2278-11ef-8d76-d310d2ec2c14.zip','c52419e8-2278-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Maxillaire u2 [pc2]\",\"modelMatrix\":\"-0.0834467,0.986107,-0.143628,0,-0.981709,-0.1061,-0.158085,0,-0.171128,0.12781,0.976924,0,-17.1278,-28.7907,-11.2181,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 15:46:10.000','2024-06-04 13:46:10.000','2024-06-04 15:46:10.000'),('c52f1c4e-2278-11ef-8d76-d310d2ec2c14',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/scan_c523efdb-2278-11ef-8d76-d310d2ec2c14/c52f1c4e-2278-11ef-8d76-d310d2ec2c14.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_TOSC_c523efdb-2278-11ef-8d76-d310d2ec2c14_SNAPS','c52f1c4e-2278-11ef-8d76-d310d2ec2c14.png','c52f1c4e-2278-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Maxillaire u2 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 15:46:10.000','2024-06-04 13:46:10.000','2024-06-04 15:46:10.000'),('c5e732c1-2983-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_08eb58c6-2980-11ef-8e16-d517f37fa2ad/occlusion_08ed7a4a-2980-11ef-8e16-d517f37fa2ad/scan_099d82e1-2980-11ef-8e16-d517f37fa2ad/c5e732c1-2983-11ef-8e16-d517f37fa2ad.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_TOSC_099d82e1-2980-11ef-8e16-d517f37fa2ad_SCREENS','c5e732c1-2983-11ef-8e16-d517f37fa2ad.png','c5e732c1-2983-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.5 Mascella u1 Screenshot 1\",\"title\":\"1\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 14:52:22.000','2024-06-13 12:52:22.000','2024-06-13 14:52:22.000'),('c67f739f-273a-11ef-8e16-d517f37fa1ab',2,'/var/.scan4all/iris/data/2024/2/b6f9b0de-273a-11ef-8e16-d517f37fa1ab/session_bafa1a93-273a-11ef-8e16-d517f37fa1ab/occlusion_bafc70fb-273a-11ef-8e16-d517f37fa1ab/scan_bc9cdff9-273a-11ef-8e16-d517f37fa1ab/c67f739f-273a-11ef-8e16-d517f37fa1ab.zip','PATIENT_b6f9b0de-273a-11ef-8e16-d517f37fa1ab_ACT_bafa1a93-273a-11ef-8e16-d517f37fa1ab_SESS_bafc70fb-273a-11ef-8e16-d517f37fa1ab_TOSC_bc9cdff9-273a-11ef-8e16-d517f37fa1ab_MODEL','c67f739f-273a-11ef-8e16-d517f37fa1ab.zip','c67f739f-273a-11ef-8e16-d517f37fa1ab','{\"displayTitle\":\"9.1 Maxillaire u1 [pc2]\",\"modelMatrix\":\"0.464495,0.700895,-0.541286,0,-0.878511,0.441746,-0.181875,0,0.111636,0.560006,0.820933,0,1.92642,-8.93896,-8.4753,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,'2024-06-10 17:05:41.423','2024-06-10 17:04:46.360','2024-06-10 15:05:41.425','2024-06-10 17:05:41.441'),('c67f8036-273a-11ef-8e16-d517f37fa1ab',2,'/var/.scan4all/iris/data/2024/2/b6f9b0de-273a-11ef-8e16-d517f37fa1ab/session_bafa1a93-273a-11ef-8e16-d517f37fa1ab/occlusion_bafc70fb-273a-11ef-8e16-d517f37fa1ab/scan_bc9cdff9-273a-11ef-8e16-d517f37fa1ab/c67f8036-273a-11ef-8e16-d517f37fa1ab.png','PATIENT_b6f9b0de-273a-11ef-8e16-d517f37fa1ab_ACT_bafa1a93-273a-11ef-8e16-d517f37fa1ab_SESS_bafc70fb-273a-11ef-8e16-d517f37fa1ab_TOSC_bc9cdff9-273a-11ef-8e16-d517f37fa1ab_SNAPS','c67f8036-273a-11ef-8e16-d517f37fa1ab.png','c67f8036-273a-11ef-8e16-d517f37fa1ab','{\"displayTitle\":\"9.1 Maxillaire u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,'2024-06-10 17:05:41.423','2024-06-10 17:04:46.360','2024-06-10 15:05:41.428','2024-06-10 17:05:41.442'),('c80e9775-2966-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_4704a021-2963-11ef-8e16-d517f37fa2ad/occlusion_4706df6f-2963-11ef-8e16-d517f37fa2ad/scan_f3a386e0-2965-11ef-8e16-d517f37fa2ad/c80e9775-2966-11ef-8e16-d517f37fa2ad.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_4704a021-2963-11ef-8e16-d517f37fa2ad_SESS_4706df6f-2963-11ef-8e16-d517f37fa2ad_BOSC_f3a386e0-2965-11ef-8e16-d517f37fa2ad_MODEL','c80e9775-2966-11ef-8e16-d517f37fa2ad.zip','c80e9775-2966-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.1 Mandibola l2\",\"modelMatrix\":\"-0.333428,-0.941176,-0.0548981,0,0.935492,-0.323066,-0.143118,0,0.116963,-0.0990761,0.988182,0,22.6045,17.8478,-19.0898,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 11:24:54.000','2024-06-13 09:24:54.000','2024-06-13 11:24:54.000'),('c80fd072-2966-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_4704a021-2963-11ef-8e16-d517f37fa2ad/occlusion_4706df6f-2963-11ef-8e16-d517f37fa2ad/scan_f3a386e0-2965-11ef-8e16-d517f37fa2ad/c80fd072-2966-11ef-8e16-d517f37fa2ad.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_4704a021-2963-11ef-8e16-d517f37fa2ad_SESS_4706df6f-2963-11ef-8e16-d517f37fa2ad_BOSC_f3a386e0-2965-11ef-8e16-d517f37fa2ad_SNAPS','c80fd072-2966-11ef-8e16-d517f37fa2ad.png','c80fd072-2966-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.1 Mandibola l2 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 11:24:55.000','2024-06-13 09:24:55.000','2024-06-13 11:24:55.000'),('c8d1ce3a-2a2c-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/scan_80540c46-2a2a-11ef-8f1c-d8242c6fa8fd/c8d1ce3a-2a2c-11ef-8f1c-d8242c6fa8fd.json','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_BOSC_80540c46-2a2a-11ef-8f1c-d8242c6fa8fd_METER','c8d1ce3a-2a2c-11ef-8f1c-d8242c6fa8fd.json','45316198-2a2c-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Mandibola l1 Misura\"}','JSON',1,'SYNCED',0,NULL,'2024-06-14 11:02:12.309','2024-06-14 09:02:12.313','2024-06-14 11:02:12.704'),('ca00209d-2e0c-11ef-8deb-d515ea58f6cb',11,'/var/.scan4all/iris/data/2024/11/b7e05748-2e0c-11ef-8deb-d515ea58f6cb/session_b7e3a050-2e0c-11ef-8deb-d515ea58f6cb/occlusion_b7e495d3-2e0c-11ef-8deb-d515ea58f6cb/scan_b95b37da-2e0c-11ef-8deb-d515ea58f6cb/ca00209d-2e0c-11ef-8deb-d515ea58f6cb.zip','PATIENT_b7e05748-2e0c-11ef-8deb-d515ea58f6cb_ACT_b7e3a050-2e0c-11ef-8deb-d515ea58f6cb_SESS_b7e495d3-2e0c-11ef-8deb-d515ea58f6cb_TOSC_b95b37da-2e0c-11ef-8deb-d515ea58f6cb_MODEL','ca00209d-2e0c-11ef-8deb-d515ea58f6cb.zip','ca00209d-2e0c-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"7.1 Mascella u1\",\"modelMatrix\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',1,NULL,'2024-06-19 09:23:14.171','2024-06-19 07:23:14.305',NULL),('ca005078-2e0c-11ef-8deb-d515ea58f6cb',11,'/var/.scan4all/iris/data/2024/11/b7e05748-2e0c-11ef-8deb-d515ea58f6cb/session_b7e3a050-2e0c-11ef-8deb-d515ea58f6cb/occlusion_b7e495d3-2e0c-11ef-8deb-d515ea58f6cb/scan_b95b37da-2e0c-11ef-8deb-d515ea58f6cb/ca005078-2e0c-11ef-8deb-d515ea58f6cb.png','PATIENT_b7e05748-2e0c-11ef-8deb-d515ea58f6cb_ACT_b7e3a050-2e0c-11ef-8deb-d515ea58f6cb_SESS_b7e495d3-2e0c-11ef-8deb-d515ea58f6cb_TOSC_b95b37da-2e0c-11ef-8deb-d515ea58f6cb_SNAPS','ca005078-2e0c-11ef-8deb-d515ea58f6cb.png','ca005078-2e0c-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"7.1 Mascella u1 Snapshot\"}','PNG',0,'CREATED',1,NULL,'2024-06-19 09:23:14.172','2024-06-19 07:23:14.306',NULL),('ca082562-2e41-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/4382037a-2735-11ef-8e16-d517f37fa1ab/session_8598ee4a-2e40-11ef-8deb-d515ea58f6cb/order_859f5fed-2e40-11ef-8deb-d515ea58f6cb/ca082562-2e41-11ef-8deb-d515ea58f6cb.pdf','PATIENT_4382037a-2735-11ef-8e16-d517f37fa1ab_ACT_8598ee4a-2e40-11ef-8deb-d515ea58f6cb_PROST_859f5fed-2e40-11ef-8deb-d515ea58f6cb_FORM','ca082562-2e41-11ef-8deb-d515ea58f6cb.pdf','ca082562-2e41-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"6.3 Crown [pc2]\",\"title\":\"Crown\"}','PDF',0,'SYNCED',0,NULL,'2024-06-19 15:42:37.550','2024-06-19 13:42:38.255','2024-06-19 15:42:38.434'),('ca114ae6-2279-11ef-8d76-d310d2ec2c14',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_a4139c9d-2279-11ef-8d76-d310d2ec2c14/occlusion_a4160b84-2279-11ef-8d76-d310d2ec2c14/scan_a6d98df1-2279-11ef-8d76-d310d2ec2c14/ca114ae6-2279-11ef-8d76-d310d2ec2c14.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_a4139c9d-2279-11ef-8d76-d310d2ec2c14_SESS_a4160b84-2279-11ef-8d76-d310d2ec2c14_TOSC_a6d98df1-2279-11ef-8d76-d310d2ec2c14_MODEL','ca114ae6-2279-11ef-8d76-d310d2ec2c14.zip','ca114ae6-2279-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.3 Maxillaire u1 [pc2]\",\"modelMatrix\":\"-0.418905,0.900302,-0.11822,0,-0.907719,-0.411789,0.0804737,0,0.0237688,0.141021,0.989721,0,6.97337,-8.05933,-15.0874,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 15:53:20.000','2024-06-04 13:53:20.000','2024-06-04 15:53:20.000'),('ca116050-2279-11ef-8d76-d310d2ec2c14',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_a4139c9d-2279-11ef-8d76-d310d2ec2c14/occlusion_a4160b84-2279-11ef-8d76-d310d2ec2c14/scan_a6d98df1-2279-11ef-8d76-d310d2ec2c14/ca116050-2279-11ef-8d76-d310d2ec2c14.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_a4139c9d-2279-11ef-8d76-d310d2ec2c14_SESS_a4160b84-2279-11ef-8d76-d310d2ec2c14_TOSC_a6d98df1-2279-11ef-8d76-d310d2ec2c14_SNAPS','ca116050-2279-11ef-8d76-d310d2ec2c14.png','ca116050-2279-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.3 Maxillaire u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 15:53:20.000','2024-06-04 13:53:20.000','2024-06-04 15:53:20.000'),('caccc8fe-2990-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_d703d726-298d-11ef-8e16-d517f37fa2ad/occlusion_d70636d7-298d-11ef-8e16-d517f37fa2ad/scan_99d1c412-2990-11ef-8e16-d517f37fa2ad/caccc8fe-2990-11ef-8e16-d517f37fa2ad.zip','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_d703d726-298d-11ef-8e16-d517f37fa2ad_SESS_d70636d7-298d-11ef-8e16-d517f37fa2ad_BOSC_99d1c412-2990-11ef-8e16-d517f37fa2ad_MODEL','caccc8fe-2990-11ef-8e16-d517f37fa2ad.zip','caccc8fe-2990-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.2 Mandibola l1\",\"modelMatrix\":\"0.997996,0.0253681,-0.0579621,0,-0.0223453,0.998386,0.0522168,0,0.0591932,-0.050817,0.996952,0,-12.5419,-0.543902,-13.1251,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 16:25:32.622','2024-06-13 14:25:33.317','2024-06-13 16:25:35.462'),('caccd68c-2990-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_d703d726-298d-11ef-8e16-d517f37fa2ad/occlusion_d70636d7-298d-11ef-8e16-d517f37fa2ad/scan_99d1c412-2990-11ef-8e16-d517f37fa2ad/caccd68c-2990-11ef-8e16-d517f37fa2ad.png','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_d703d726-298d-11ef-8e16-d517f37fa2ad_SESS_d70636d7-298d-11ef-8e16-d517f37fa2ad_BOSC_99d1c412-2990-11ef-8e16-d517f37fa2ad_SNAPS','caccd68c-2990-11ef-8e16-d517f37fa2ad.png','caccd68c-2990-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.2 Mandibola l1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 16:25:32.622','2024-06-13 14:25:33.321','2024-06-13 16:25:35.968'),('cb1cd7df-298f-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_d703d726-298d-11ef-8e16-d517f37fa2ad/occlusion_d70636d7-298d-11ef-8e16-d517f37fa2ad/scan_a9e9d6c4-298f-11ef-8e16-d517f37fa2ad/cb1cd7df-298f-11ef-8e16-d517f37fa2ad.zip','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_d703d726-298d-11ef-8e16-d517f37fa2ad_SESS_d70636d7-298d-11ef-8e16-d517f37fa2ad_TOSC_a9e9d6c4-298f-11ef-8e16-d517f37fa2ad_MODEL','cb1cd7df-298f-11ef-8e16-d517f37fa2ad.zip','a9e9f96d-298f-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.2 Mascella u2\",\"modelMatrix\":\"0.975516,-0.148096,-0.162593,0,0.128141,0.983582,-0.127067,0,0.178742,0.103121,0.978477,0,-16.8719,-1.29266,-12.1772,1\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2024-06-13 16:18:23.650','2024-06-13 14:18:23.712','2024-06-13 16:18:23.922'),('cc2aab6f-28d3-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/82c4f551-28bf-11ef-8e16-d517f37fa2ad/session_c425e233-28d3-11ef-8e16-d517f37fa2ad/analyse_c42f4bd1-28d3-11ef-8e16-d517f37fa2ad/cc2aab6f-28d3-11ef-8e16-d517f37fa2ad.json','PATIENT_82c4f551-28bf-11ef-8e16-d517f37fa2ad_ACT_c425e233-28d3-11ef-8e16-d517f37fa2ad_ANA_c42f4bd1-28d3-11ef-8e16-d517f37fa2ad_TRANS','cc2aab6f-28d3-11ef-8e16-d517f37fa2ad.json','cc2aab6f-28d3-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"4.3 Analyse m1\"}','JSON',0,'SYNCED',0,NULL,'2024-06-12 17:52:40.033','2024-06-12 15:52:40.036','2024-06-12 17:52:40.974'),('cc7d5d28-28d3-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/82c4f551-28bf-11ef-8e16-d517f37fa2ad/session_c425e233-28d3-11ef-8e16-d517f37fa2ad/analyse_c42f4bd1-28d3-11ef-8e16-d517f37fa2ad/cc7d5d28-28d3-11ef-8e16-d517f37fa2ad.png','PATIENT_82c4f551-28bf-11ef-8e16-d517f37fa2ad_ACT_c425e233-28d3-11ef-8e16-d517f37fa2ad_ANA_c42f4bd1-28d3-11ef-8e16-d517f37fa2ad_SNAPS','cc7d5d28-28d3-11ef-8e16-d517f37fa2ad.png','cc7d5d28-28d3-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"4.3 Analyse m1\"}','PNG',0,'SYNCED',0,NULL,'2024-06-12 17:52:40.575','2024-06-12 15:52:40.577','2024-06-12 17:52:41.183'),('cca14134-2e4b-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/115617bc-2e4b-11ef-8deb-d515ea58f6cb/session_15f71dc7-2e4b-11ef-8deb-d515ea58f6cb/occlusion_15f94c3c-2e4b-11ef-8deb-d515ea58f6cb/computedocclusion_7a7b3c41-2e4b-11ef-8deb-d515ea58f6cb/cca14134-2e4b-11ef-8deb-d515ea58f6cb.zip','PATIENT_115617bc-2e4b-11ef-8deb-d515ea58f6cb_ACT_15f71dc7-2e4b-11ef-8deb-d515ea58f6cb_SESS_15f94c3c-2e4b-11ef-8deb-d515ea58f6cb_OCC_7a7b3c41-2e4b-11ef-8deb-d515ea58f6cb_TO1','cca14134-2e4b-11ef-8deb-d515ea58f6cb.zip','cca14134-2e4b-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"17.1 Occlusion o1 Maxilla u1 [pc2]\",\"modelMatrix\":\"0.969737,0.17474,-0.170519,0,-0.235525,0.853535,-0.464764,0,0.0643309,0.49086,0.86886,0,-10.5522,-3.64935,-10.9486,1\",\"occlusionMatrix\":\"-0.88883,0.0443963,-0.452033,0,0.440372,-0.171984,-0.881545,0,-0.127165,-0.984155,0.136261,0,15.0864,9.07319,3.89339,1\",\"occlusionType\":2,\"referenceScanFullDisplayId\":\"17.1_u1\",\"referenceScanId\":\"1770b226-2e4b-11ef-8deb-d515ea58f6cb\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-19 16:54:21.000','2024-06-19 14:54:21.000','2024-06-19 16:54:21.000'),('ccb950d9-2e4b-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/115617bc-2e4b-11ef-8deb-d515ea58f6cb/session_15f71dc7-2e4b-11ef-8deb-d515ea58f6cb/occlusion_15f94c3c-2e4b-11ef-8deb-d515ea58f6cb/computedocclusion_7a7b3c41-2e4b-11ef-8deb-d515ea58f6cb/ccb950d9-2e4b-11ef-8deb-d515ea58f6cb.zip','PATIENT_115617bc-2e4b-11ef-8deb-d515ea58f6cb_ACT_15f71dc7-2e4b-11ef-8deb-d515ea58f6cb_SESS_15f94c3c-2e4b-11ef-8deb-d515ea58f6cb_OCC_7a7b3c41-2e4b-11ef-8deb-d515ea58f6cb_BO1','ccb950d9-2e4b-11ef-8deb-d515ea58f6cb.zip','ccb950d9-2e4b-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"17.1 Occlusion o1 Mandible l1 [pc2]\",\"modelMatrix\":\"0.997464,0.0588169,0.0400726,0,-0.0389825,0.92259,-0.383808,0,-0.059545,0.381273,0.922543,0,7.78707,3.45972,-13.4277,1\",\"occlusionMatrix\":\"-0.866209,0.490968,-0.0122952,0,-0.478657,-0.825676,0.315359,0,0.143894,0.278071,0.948909,0,-14.8101,-4.53993,-7.21232,1\",\"occlusionType\":2,\"referenceScanFullDisplayId\":\"17.1_l1\",\"referenceScanId\":\"4155dabe-2e4b-11ef-8deb-d515ea58f6cb\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-19 16:54:25.000','2024-06-19 14:54:25.000','2024-06-19 16:54:25.000'),('cd43bf12-2e4b-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/115617bc-2e4b-11ef-8deb-d515ea58f6cb/session_15f71dc7-2e4b-11ef-8deb-d515ea58f6cb/occlusion_15f94c3c-2e4b-11ef-8deb-d515ea58f6cb/computedocclusion_7a7b3c41-2e4b-11ef-8deb-d515ea58f6cb/cd43bf12-2e4b-11ef-8deb-d515ea58f6cb.png','PATIENT_115617bc-2e4b-11ef-8deb-d515ea58f6cb_ACT_15f71dc7-2e4b-11ef-8deb-d515ea58f6cb_SESS_15f94c3c-2e4b-11ef-8deb-d515ea58f6cb_OCC_7a7b3c41-2e4b-11ef-8deb-d515ea58f6cb_SNAPO','cd43bf12-2e4b-11ef-8deb-d515ea58f6cb.png','cd43bf12-2e4b-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"17.1 Occlusion o1 [pc2]\",\"occlusionType\":2}','PNG',0,'SYNCED',0,NULL,'2024-06-19 16:54:25.000','2024-06-19 14:54:25.000','2024-06-19 16:54:25.000'),('ce19c205-289c-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/f373c86a-2899-11ef-8e16-d517f37fa2ad/session_0d1289f0-289a-11ef-8e16-d517f37fa2ad/occlusion_0d14f12a-289a-11ef-8e16-d517f37fa2ad/scan_a0eae524-289c-11ef-8e16-d517f37fa2ad/ce19c205-289c-11ef-8e16-d517f37fa2ad.zip','PATIENT_f373c86a-2899-11ef-8e16-d517f37fa2ad_ACT_0d1289f0-289a-11ef-8e16-d517f37fa2ad_SESS_0d14f12a-289a-11ef-8e16-d517f37fa2ad_RISC_a0eae524-289c-11ef-8e16-d517f37fa2ad_MODEL','ce19c205-289c-11ef-8e16-d517f37fa2ad.zip','ce19c205-289c-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Mordu droit br1\",\"modelMatrix\":\"0.999837,-0.0171827,0.00651016,0,0.0180696,0.970825,-0.238969,0,-0.00112058,0.239172,0.971006,0,-6.31977,0.155692,-16.0373,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-12 11:19:00.957','2024-06-12 09:19:01.222','2024-06-12 11:19:03.792'),('ce19d8cd-289c-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/f373c86a-2899-11ef-8e16-d517f37fa2ad/session_0d1289f0-289a-11ef-8e16-d517f37fa2ad/occlusion_0d14f12a-289a-11ef-8e16-d517f37fa2ad/scan_a0eae524-289c-11ef-8e16-d517f37fa2ad/ce19d8cd-289c-11ef-8e16-d517f37fa2ad.png','PATIENT_f373c86a-2899-11ef-8e16-d517f37fa2ad_ACT_0d1289f0-289a-11ef-8e16-d517f37fa2ad_SESS_0d14f12a-289a-11ef-8e16-d517f37fa2ad_RISC_a0eae524-289c-11ef-8e16-d517f37fa2ad_SNAPS','ce19d8cd-289c-11ef-8e16-d517f37fa2ad.png','ce19d8cd-289c-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Mordu droit br1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-12 11:19:00.958','2024-06-12 09:19:01.223','2024-06-12 11:19:04.925'),('d0ab5861-23e7-11ef-8dde-d415e84cc4f5',3,'/var/.scan4all/iris/data/2024/3/907398e3-23e7-11ef-8dde-d415e84cc4f5/session_96aedcf6-23e7-11ef-8dde-d415e84cc4f5/occlusion_96b19cc6-23e7-11ef-8dde-d415e84cc4f5/scan_981faf70-23e7-11ef-8dde-d415e84cc4f5/d0ab5861-23e7-11ef-8dde-d415e84cc4f5.zip','PATIENT_907398e3-23e7-11ef-8dde-d415e84cc4f5_ACT_96aedcf6-23e7-11ef-8dde-d415e84cc4f5_SESS_96b19cc6-23e7-11ef-8dde-d415e84cc4f5_TOSC_981faf70-23e7-11ef-8dde-d415e84cc4f5_MODEL','d0ab5861-23e7-11ef-8dde-d415e84cc4f5.zip','d0ab5861-23e7-11ef-8dde-d415e84cc4f5','{\"displayTitle\":\"2.1 Maxillaire u1 [pc1]\",\"modelMatrix\":\"0.998773,-0.00202182,-0.0494821,0,0.00445529,0.998783,0.0491187,0,0.0493226,-0.0492789,0.997566,0,1.86586,2.73136,-15.9281,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-06 11:33:25.000','2024-06-06 09:33:25.000','2024-06-06 11:33:25.000'),('d0ab69d4-23e7-11ef-8dde-d415e84cc4f5',3,'/var/.scan4all/iris/data/2024/3/907398e3-23e7-11ef-8dde-d415e84cc4f5/session_96aedcf6-23e7-11ef-8dde-d415e84cc4f5/occlusion_96b19cc6-23e7-11ef-8dde-d415e84cc4f5/scan_981faf70-23e7-11ef-8dde-d415e84cc4f5/d0ab69d4-23e7-11ef-8dde-d415e84cc4f5.png','PATIENT_907398e3-23e7-11ef-8dde-d415e84cc4f5_ACT_96aedcf6-23e7-11ef-8dde-d415e84cc4f5_SESS_96b19cc6-23e7-11ef-8dde-d415e84cc4f5_TOSC_981faf70-23e7-11ef-8dde-d415e84cc4f5_SNAPS','d0ab69d4-23e7-11ef-8dde-d415e84cc4f5.png','d0ab69d4-23e7-11ef-8dde-d415e84cc4f5','{\"displayTitle\":\"2.1 Maxillaire u1 Snapshot [pc1]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-06 11:33:26.000','2024-06-06 09:33:26.000','2024-06-06 11:33:26.000'),('d13398f3-2968-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_4704a021-2963-11ef-8e16-d517f37fa2ad/occlusion_4706df6f-2963-11ef-8e16-d517f37fa2ad/scan_924ba453-2968-11ef-8e16-d517f37fa2ad/d13398f3-2968-11ef-8e16-d517f37fa2ad.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_4704a021-2963-11ef-8e16-d517f37fa2ad_SESS_4706df6f-2963-11ef-8e16-d517f37fa2ad_RISC_924ba453-2968-11ef-8e16-d517f37fa2ad_MODEL','d13398f3-2968-11ef-8e16-d517f37fa2ad.zip','d13398f3-2968-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.1 Morso destro br1\",\"modelMatrix\":\"0.999799,0.0172744,0.0120866,0,-0.0146381,0.983111,-0.182879,0,-0.0137702,0.182192,0.983062,0,-1.30199,-4.18959,-13.8087,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 11:39:23.493','2024-06-13 09:39:23.702','2024-06-13 11:39:27.098'),('d133a753-2968-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_4704a021-2963-11ef-8e16-d517f37fa2ad/occlusion_4706df6f-2963-11ef-8e16-d517f37fa2ad/scan_924ba453-2968-11ef-8e16-d517f37fa2ad/d133a753-2968-11ef-8e16-d517f37fa2ad.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_4704a021-2963-11ef-8e16-d517f37fa2ad_SESS_4706df6f-2963-11ef-8e16-d517f37fa2ad_RISC_924ba453-2968-11ef-8e16-d517f37fa2ad_SNAPS','d133a753-2968-11ef-8e16-d517f37fa2ad.png','d133a753-2968-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.1 Morso destro br1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 11:39:23.493','2024-06-13 09:39:23.702','2024-06-13 11:39:27.911'),('d2783274-2a2c-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/scan_8de1d45c-2a29-11ef-8f1c-d8242c6fa8fd/d2783274-2a2c-11ef-8f1c-d8242c6fa8fd.ply','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_TOSC_8de1d45c-2a29-11ef-8f1c-d8242c6fa8fd_SEG','d2783274-2a2c-11ef-8f1c-d8242c6fa8fd.ply','d2783274-2a2c-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Mascella u1 Segmentazione\"}','PLY',0,'SYNCED',0,NULL,'2024-06-14 11:02:28.499','2024-06-14 09:02:28.518','2024-06-14 11:02:28.934'),('d2ad1a19-2e4b-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/115617bc-2e4b-11ef-8deb-d515ea58f6cb/session_15f71dc7-2e4b-11ef-8deb-d515ea58f6cb/occlusion_15f94c3c-2e4b-11ef-8deb-d515ea58f6cb/computedocclusion_7a7b3c41-2e4b-11ef-8deb-d515ea58f6cb/d2ad1a19-2e4b-11ef-8deb-d515ea58f6cb.zip','PATIENT_115617bc-2e4b-11ef-8deb-d515ea58f6cb_ACT_15f71dc7-2e4b-11ef-8deb-d515ea58f6cb_SESS_15f94c3c-2e4b-11ef-8deb-d515ea58f6cb_OCC_7a7b3c41-2e4b-11ef-8deb-d515ea58f6cb_BO1','d2ad1a19-2e4b-11ef-8deb-d515ea58f6cb.zip','ccb950d9-2e4b-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"17.1 Occlusion o1 Mandible l1 [pc2]\",\"modelMatrix\":\"0.997464,0.0588169,0.0400726,0,-0.0389825,0.92259,-0.383808,0,-0.059545,0.381273,0.922543,0,7.78707,3.45972,-13.4277,1\",\"occlusionMatrix\":\"-0.877863,0.468445,-0.0380253,0,-0.463034,-0.829655,0.328,0,0.121361,0.304513,0.94393,0,-14.4357,-4.63496,-6.66005,1\",\"occlusionType\":2,\"referenceScanFullDisplayId\":\"17.1_l1\",\"referenceScanId\":\"4155dabe-2e4b-11ef-8deb-d515ea58f6cb\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2024-06-19 16:54:29.000','2024-06-19 14:54:29.000','2024-06-19 16:54:29.000'),('d2fc9984-2e42-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/4382037a-2735-11ef-8e16-d517f37fa1ab/session_68af0333-2e42-11ef-8deb-d515ea58f6cb/occlusion_68b10ccb-2e42-11ef-8deb-d515ea58f6cb/scan_70f3c64d-2e42-11ef-8deb-d515ea58f6cb/d2fc9984-2e42-11ef-8deb-d515ea58f6cb.zip','PATIENT_4382037a-2735-11ef-8e16-d517f37fa1ab_ACT_68af0333-2e42-11ef-8deb-d515ea58f6cb_SESS_68b10ccb-2e42-11ef-8deb-d515ea58f6cb_TOSC_70f3c64d-2e42-11ef-8deb-d515ea58f6cb_MODEL','d2fc9984-2e42-11ef-8deb-d515ea58f6cb.zip','953cbc38-2e42-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"6.4 Maxilla u1 [pc2]\",\"modelMatrix\":\"-0.992348,-0.0918829,-0.0824853,0,0.0848748,-0.992777,0.0847908,0,-0.0896804,0.077141,0.992979,0,4.97689,0.487049,-11.0551,1\",\"scanBodies\":[],\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":3,\"socleIsFullArch\":true,\"socleThickness\":-1,\"socleType\":1}','ZIP',1,'SYNCED',0,NULL,'2024-06-19 15:50:03.000','2024-06-19 13:50:03.000','2024-06-19 15:50:03.000'),('d316761c-27c8-11ef-8e37-d519fa9d22d2',2,'/var/.scan4all/iris/data/2024/2/312c74c3-2735-11ef-8e16-d517f37fa1ab/session_8c10fdc0-2735-11ef-8e16-d517f37fa1ab/order_8c15b440-2735-11ef-8e16-d517f37fa1ab/d316761c-27c8-11ef-8e37-d519fa9d22d2.pdf','PATIENT_312c74c3-2735-11ef-8e16-d517f37fa1ab_ACT_8c10fdc0-2735-11ef-8e16-d517f37fa1ab_PROST_8c15b440-2735-11ef-8e16-d517f37fa1ab_FORM','d316761c-27c8-11ef-8e37-d519fa9d22d2.pdf','d316761c-27c8-11ef-8e37-d519fa9d22d2','{\"displayTitle\":\"5.1 Autre [pc2]\",\"title\":\"Autre\"}','PDF',0,'SYNCED',0,'2024-06-11 10:08:20.000','2024-06-11 10:01:38.000','2024-06-11 08:08:20.000','2024-06-11 10:08:20.000'),('d3a8591b-2a2b-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/scan_80540c46-2a2a-11ef-8f1c-d8242c6fa8fd/d3a8591b-2a2b-11ef-8f1c-d8242c6fa8fd.xyz','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_BOSC_80540c46-2a2a-11ef-8f1c-d8242c6fa8fd_LIFI','d3a8591b-2a2b-11ef-8f1c-d8242c6fa8fd.xyz','d3a8591b-2a2b-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Mandibola l1 Linea di finitura 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-14 10:55:20.995','2024-06-14 08:55:21.001','2024-06-14 10:55:21.422'),('d3a86170-2a2b-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/scan_80540c46-2a2a-11ef-8f1c-d8242c6fa8fd/d3a86170-2a2b-11ef-8f1c-d8242c6fa8fd.bin','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_BOSC_80540c46-2a2a-11ef-8f1c-d8242c6fa8fd_LIFIM','d3a86170-2a2b-11ef-8f1c-d8242c6fa8fd.bin','d3a86170-2a2b-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Mandibola l1 Linea di finitura dei metadati 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-14 10:55:20.996','2024-06-14 08:55:21.001','2024-06-14 10:55:21.715'),('d3b1d4dc-2a2b-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/computedocclusion_e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd/d3b1d4dc-2a2b-11ef-8f1c-d8242c6fa8fd.xyz','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_OCC_e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd_LIFIO','d3b1d4dc-2a2b-11ef-8f1c-d8242c6fa8fd.xyz','d3b1d4dc-2a2b-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Occlusione o1 Mandibola l1 Linea di finitura 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MANDIBLE_1\",\"referenceScanFullDisplayId\":\"3.2_l1\",\"referenceScanId\":\"80540c46-2a2a-11ef-8f1c-d8242c6fa8fd\",\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-14 10:55:22.000','2024-06-14 08:55:22.000','2024-06-14 10:55:22.000'),('d3b1e53c-2a2b-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/computedocclusion_e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd/d3b1e53c-2a2b-11ef-8f1c-d8242c6fa8fd.bin','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_OCC_e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd_LIFIMO','d3b1e53c-2a2b-11ef-8f1c-d8242c6fa8fd.bin','d3b1e53c-2a2b-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Occlusione o1 Mandibola l1 Linea di finitura dei metadati 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MANDIBLE_1\",\"referenceScanFullDisplayId\":\"3.2_l1\",\"referenceScanId\":\"80540c46-2a2a-11ef-8f1c-d8242c6fa8fd\",\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-14 10:55:22.000','2024-06-14 08:55:22.000','2024-06-14 10:55:22.000'),('d476e8aa-28d4-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/09f7c5e2-28bb-11ef-8e16-d517f37fa2ad/session_5f4774a2-28bf-11ef-8e16-d517f37fa2ad/occlusion_5f49b09c-28bf-11ef-8e16-d517f37fa2ad/scan_b51b7dbf-28d4-11ef-8e16-d517f37fa2ad/d476e8aa-28d4-11ef-8e16-d517f37fa2ad.zip','PATIENT_09f7c5e2-28bb-11ef-8e16-d517f37fa2ad_ACT_5f4774a2-28bf-11ef-8e16-d517f37fa2ad_SESS_5f49b09c-28bf-11ef-8e16-d517f37fa2ad_TOSC_b51b7dbf-28d4-11ef-8e16-d517f37fa2ad_MODEL','d476e8aa-28d4-11ef-8e16-d517f37fa2ad.zip','d476e8aa-28d4-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"3.2 Maxillaire u1\",\"modelMatrix\":\"-0.521559,0.84967,-0.0776976,0,-0.81071,-0.521901,-0.26527,0,-0.265943,-0.0753637,0.961038,0,11.3619,-9.69905,-10.3718,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-12 18:00:03.451','2024-06-12 16:00:03.802','2024-06-12 18:00:05.992'),('d4770a37-28d4-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/09f7c5e2-28bb-11ef-8e16-d517f37fa2ad/session_5f4774a2-28bf-11ef-8e16-d517f37fa2ad/occlusion_5f49b09c-28bf-11ef-8e16-d517f37fa2ad/scan_b51b7dbf-28d4-11ef-8e16-d517f37fa2ad/d4770a37-28d4-11ef-8e16-d517f37fa2ad.png','PATIENT_09f7c5e2-28bb-11ef-8e16-d517f37fa2ad_ACT_5f4774a2-28bf-11ef-8e16-d517f37fa2ad_SESS_5f49b09c-28bf-11ef-8e16-d517f37fa2ad_TOSC_b51b7dbf-28d4-11ef-8e16-d517f37fa2ad_SNAPS','d4770a37-28d4-11ef-8e16-d517f37fa2ad.png','d4770a37-28d4-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"3.2 Maxillaire u1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-12 18:00:03.452','2024-06-12 16:00:03.803','2024-06-12 18:00:06.601'),('d4b56463-2e4d-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_c88615a1-2e3c-11ef-8deb-d515ea58f6cb/occlusion_c8883bc6-2e3c-11ef-8deb-d515ea58f6cb/scan_c103add9-2e4d-11ef-8deb-d515ea58f6cb/d4b56463-2e4d-11ef-8deb-d515ea58f6cb.zip','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_c88615a1-2e3c-11ef-8deb-d515ea58f6cb_SESS_c8883bc6-2e3c-11ef-8deb-d515ea58f6cb_TOSC_c103add9-2e4d-11ef-8deb-d515ea58f6cb_MODEL','d4b56463-2e4d-11ef-8deb-d515ea58f6cb.zip','d4b56463-2e4d-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.3 Maxilla u1 [pc2]\",\"modelMatrix\":\"-0.977998,0.0330243,-0.205984,0,0.0112945,-0.97756,-0.210353,0,-0.208309,-0.208051,0.955679,0,10.1954,5.47471,-13.4211,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-19 17:08:49.423','2024-06-19 15:08:49.624','2024-06-19 17:08:51.944'),('d4b57109-2e4d-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_c88615a1-2e3c-11ef-8deb-d515ea58f6cb/occlusion_c8883bc6-2e3c-11ef-8deb-d515ea58f6cb/scan_c103add9-2e4d-11ef-8deb-d515ea58f6cb/d4b57109-2e4d-11ef-8deb-d515ea58f6cb.png','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_c88615a1-2e3c-11ef-8deb-d515ea58f6cb_SESS_c8883bc6-2e3c-11ef-8deb-d515ea58f6cb_TOSC_c103add9-2e4d-11ef-8deb-d515ea58f6cb_SNAPS','d4b57109-2e4d-11ef-8deb-d515ea58f6cb.png','d4b57109-2e4d-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.3 Maxilla u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-19 17:08:49.424','2024-06-19 15:08:49.624','2024-06-19 17:08:52.803'),('d549d2e9-2e0c-11ef-8deb-d515ea58f6cb',11,'/var/.scan4all/iris/data/2024/11/b7e05748-2e0c-11ef-8deb-d515ea58f6cb/session_b7e3a050-2e0c-11ef-8deb-d515ea58f6cb/occlusion_b7e495d3-2e0c-11ef-8deb-d515ea58f6cb/scan_b95b37da-2e0c-11ef-8deb-d515ea58f6cb/d549d2e9-2e0c-11ef-8deb-d515ea58f6cb.zip','PATIENT_b7e05748-2e0c-11ef-8deb-d515ea58f6cb_ACT_b7e3a050-2e0c-11ef-8deb-d515ea58f6cb_SESS_b7e495d3-2e0c-11ef-8deb-d515ea58f6cb_TOSC_b95b37da-2e0c-11ef-8deb-d515ea58f6cb_MODEL','d549d2e9-2e0c-11ef-8deb-d515ea58f6cb.zip','ca00209d-2e0c-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"7.1 Mascella u1\",\"modelMatrix\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"scanBodies\":[],\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":3,\"socleIsFullArch\":true,\"socleThickness\":-1,\"socleType\":1}','ZIP',1,'CREATED',1,NULL,'2024-06-19 09:23:33.109','2024-06-19 07:23:33.138',NULL),('d59e4f7d-2279-11ef-8d76-d310d2ec2c14',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_a4139c9d-2279-11ef-8d76-d310d2ec2c14/order_a4229655-2279-11ef-8d76-d310d2ec2c14/d59e4f7d-2279-11ef-8d76-d310d2ec2c14.pdf','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_a4139c9d-2279-11ef-8d76-d310d2ec2c14_PROST_a4229655-2279-11ef-8d76-d310d2ec2c14_FORM','d59e4f7d-2279-11ef-8d76-d310d2ec2c14.pdf','d59e4f7d-2279-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.3 Facette [pc2]\",\"title\":\"Facette\"}','PDF',0,'SYNCED',0,NULL,'2024-06-04 15:53:35.000','2024-06-04 13:53:35.000','2024-06-04 15:53:35.000'),('d5da3062-2984-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_a8885309-2984-11ef-8e16-d517f37fa2ad/occlusion_a888b842-2984-11ef-8e16-d517f37fa2ad/scan_ab40f38e-2984-11ef-8e16-d517f37fa2ad/d5da3062-2984-11ef-8e16-d517f37fa2ad.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_a8885309-2984-11ef-8e16-d517f37fa2ad_SESS_a888b842-2984-11ef-8e16-d517f37fa2ad_TOSC_ab40f38e-2984-11ef-8e16-d517f37fa2ad_MODEL','d5da3062-2984-11ef-8e16-d517f37fa2ad.zip','d5da3062-2984-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.7 Mascella u1\",\"modelMatrix\":\"0.676804,-0.736112,0.00867294,0,0.735905,0.676831,0.0185321,0,-0.0195118,-0.00616012,0.999791,0,-5.57178,10.6847,-13.2414,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 14:59:57.204','2024-06-13 13:05:35.331','2024-06-13 15:05:39.092'),('d5da4016-2984-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_a8885309-2984-11ef-8e16-d517f37fa2ad/occlusion_a888b842-2984-11ef-8e16-d517f37fa2ad/scan_ab40f38e-2984-11ef-8e16-d517f37fa2ad/d5da4016-2984-11ef-8e16-d517f37fa2ad.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_a8885309-2984-11ef-8e16-d517f37fa2ad_SESS_a888b842-2984-11ef-8e16-d517f37fa2ad_TOSC_ab40f38e-2984-11ef-8e16-d517f37fa2ad_SNAPS','d5da4016-2984-11ef-8e16-d517f37fa2ad.png','d5da4016-2984-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.7 Mascella u1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 14:59:57.204','2024-06-13 13:05:35.332','2024-06-13 15:05:39.753'),('d6119db2-233b-11ef-8f93-d92a45da78c9',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_23e52d54-2338-11ef-8f93-d92a45da78c9/d6119db2-233b-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_BOSC_23e52d54-2338-11ef-8f93-d92a45da78c9_MODEL','d6119db2-233b-11ef-8f93-d92a45da78c9.zip','4c944e2f-2338-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Mandibule l1 [pc1]\",\"modelMatrix\":\"0.912405,-0.408985,0.0157505,0,0.408648,0.908152,-0.0909209,0,0.0228815,0.0893931,0.995733,0,-14.1029,6.9381,-10.6228,1\",\"scanBodies\":[],\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":3,\"socleIsFullArch\":true,\"socleThickness\":-1,\"socleType\":3}','ZIP',4,'SYNCED',0,NULL,'2024-06-05 15:02:22.000','2024-06-05 13:02:22.000','2024-06-05 15:02:22.000'),('d72c7af3-2983-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_08eb58c6-2980-11ef-8e16-d517f37fa2ad/occlusion_08ed7a4a-2980-11ef-8e16-d517f37fa2ad/scan_099d82e1-2980-11ef-8e16-d517f37fa2ad/d72c7af3-2983-11ef-8e16-d517f37fa2ad.json','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_TOSC_099d82e1-2980-11ef-8e16-d517f37fa2ad_METER','d72c7af3-2983-11ef-8e16-d517f37fa2ad.json','d72c7af3-2983-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.5 Mascella u1 Misura\"}','JSON',0,'SYNCED',0,NULL,'2024-06-13 14:52:49.924','2024-06-13 12:52:49.940','2024-06-13 14:52:50.197'),('d8355af9-2e42-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/4382037a-2735-11ef-8e16-d517f37fa1ab/session_68af0333-2e42-11ef-8deb-d515ea58f6cb/order_68b5196a-2e42-11ef-8deb-d515ea58f6cb/d8355af9-2e42-11ef-8deb-d515ea58f6cb.pdf','PATIENT_4382037a-2735-11ef-8e16-d517f37fa1ab_ACT_68af0333-2e42-11ef-8deb-d515ea58f6cb_PROST_68b5196a-2e42-11ef-8deb-d515ea58f6cb_FORM','d8355af9-2e42-11ef-8deb-d515ea58f6cb.pdf','d8355af9-2e42-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"6.4 Removable [pc2]\",\"title\":\"Removable\"}','PDF',0,'SYNCED',0,NULL,'2024-06-19 15:50:12.000','2024-06-19 13:50:12.000','2024-06-19 15:50:12.000'),('d893529b-2e3b-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_da1f6873-2e3a-11ef-8deb-d515ea58f6cb/occlusion_da21a6e4-2e3a-11ef-8deb-d515ea58f6cb/computedocclusion_89b4ac38-2e3b-11ef-8deb-d515ea58f6cb/d893529b-2e3b-11ef-8deb-d515ea58f6cb.zip','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_da1f6873-2e3a-11ef-8deb-d515ea58f6cb_SESS_da21a6e4-2e3a-11ef-8deb-d515ea58f6cb_OCC_89b4ac38-2e3b-11ef-8deb-d515ea58f6cb_BO1','d893529b-2e3b-11ef-8deb-d515ea58f6cb.zip','c1a8eaf0-2e3b-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.2 Occlusion o1 Mandible l1 [pc2]\",\"modelMatrix\":\"0.988345,0.152164,-0.00455078,0,-0.132711,0.846578,-0.515455,0,-0.0745809,0.510051,0.856905,0,-6.06382,-8.89201,-8.94358,1\",\"occlusionMatrix\":\"-0.933044,0.349258,-0.0795738,0,-0.280789,-0.850807,-0.444224,0,-0.225084,-0.392643,0.89235,0,7.24967,4.36512,-6.92949,1\",\"occlusionType\":2,\"referenceScanFullDisplayId\":\"16.2_l1\",\"referenceScanId\":\"18dce61e-2e3b-11ef-8deb-d515ea58f6cb\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2024-06-19 15:00:04.970','2024-06-19 13:00:05.126','2024-06-19 15:00:05.684'),('d9951fef-2277-11ef-8d76-d310d2ec2c14',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/scan_9fc70276-2277-11ef-8d76-d310d2ec2c14/d9951fef-2277-11ef-8d76-d310d2ec2c14.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_LESC_9fc70276-2277-11ef-8d76-d310d2ec2c14_MODEL','d9951fef-2277-11ef-8d76-d310d2ec2c14.zip','d9951fef-2277-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Mordu gauche bl2 [pc2]\",\"modelMatrix\":\"-0.999297,0.0318041,0.00950794,0,-0.0336267,-0.99727,0.0679987,0,0.01789,0.0667079,0.997659,0,3.35871,-3.59594,-10.5041,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 15:41:40.000','2024-06-04 13:41:40.000','2024-06-04 15:41:40.000'),('d9952ebe-2277-11ef-8d76-d310d2ec2c14',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/scan_9fc70276-2277-11ef-8d76-d310d2ec2c14/d9952ebe-2277-11ef-8d76-d310d2ec2c14.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_LESC_9fc70276-2277-11ef-8d76-d310d2ec2c14_SNAPS','d9952ebe-2277-11ef-8d76-d310d2ec2c14.png','d9952ebe-2277-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Mordu gauche bl2 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 15:41:40.000','2024-06-04 13:41:40.000','2024-06-04 15:41:40.000'),('d9b89c30-2e0c-11ef-8deb-d515ea58f6cb',11,'/var/.scan4all/iris/data/2024/11/b7e05748-2e0c-11ef-8deb-d515ea58f6cb/session_b7e3a050-2e0c-11ef-8deb-d515ea58f6cb/occlusion_b7e495d3-2e0c-11ef-8deb-d515ea58f6cb/scan_b95b37da-2e0c-11ef-8deb-d515ea58f6cb/d9b89c30-2e0c-11ef-8deb-d515ea58f6cb.zip','PATIENT_b7e05748-2e0c-11ef-8deb-d515ea58f6cb_ACT_b7e3a050-2e0c-11ef-8deb-d515ea58f6cb_SESS_b7e495d3-2e0c-11ef-8deb-d515ea58f6cb_TOSC_b95b37da-2e0c-11ef-8deb-d515ea58f6cb_MODEL','d9b89c30-2e0c-11ef-8deb-d515ea58f6cb.zip','ca00209d-2e0c-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"7.1 Mascella u1\",\"modelMatrix\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"scanBodies\":[],\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":3,\"socleIsFullArch\":true,\"socleThickness\":-1,\"socleType\":3}','ZIP',2,'CREATED',1,NULL,'2024-06-19 09:23:40.546','2024-06-19 07:23:40.573',NULL),('db19bb4a-2a2a-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/scan_80540c46-2a2a-11ef-8f1c-d8242c6fa8fd/db19bb4a-2a2a-11ef-8f1c-d8242c6fa8fd.zip','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_BOSC_80540c46-2a2a-11ef-8f1c-d8242c6fa8fd_MODEL','db19bb4a-2a2a-11ef-8f1c-d8242c6fa8fd.zip','db19bb4a-2a2a-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Mandibola l1\",\"modelMatrix\":\"-0.934662,0.348207,-0.071824,0,-0.340741,-0.934968,-0.098644,0,-0.101502,-0.0677254,0.992527,0,16.8656,-3.96577,-16.4235,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-14 10:48:23.986','2024-06-14 08:48:25.102','2024-06-14 10:48:27.805'),('db19d117-2a2a-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/scan_80540c46-2a2a-11ef-8f1c-d8242c6fa8fd/db19d117-2a2a-11ef-8f1c-d8242c6fa8fd.png','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_BOSC_80540c46-2a2a-11ef-8f1c-d8242c6fa8fd_SNAPS','db19d117-2a2a-11ef-8f1c-d8242c6fa8fd.png','db19d117-2a2a-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Mandibola l1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-14 10:48:23.986','2024-06-14 08:48:25.103','2024-06-14 10:48:30.710'),('db3b031f-2980-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_08eb58c6-2980-11ef-8e16-d517f37fa2ad/occlusion_08ed7a4a-2980-11ef-8e16-d517f37fa2ad/scan_a5b11e9a-2980-11ef-8e16-d517f37fa2ad/db3b031f-2980-11ef-8e16-d517f37fa2ad.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_FRSC_a5b11e9a-2980-11ef-8e16-d517f37fa2ad_MODEL','db3b031f-2980-11ef-8e16-d517f37fa2ad.zip','db3b031f-2980-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.5 Morso anteriore ba1\",\"modelMatrix\":\"0.998929,0.0183989,0.0438781,0,-0.0210714,0.977975,0.205467,0,-0.0417145,-0.208015,0.977682,0,-2.1759,4.40468,-9.36621,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 14:31:28.240','2024-06-13 12:31:28.757','2024-06-13 14:31:30.790'),('db3b175f-2980-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_08eb58c6-2980-11ef-8e16-d517f37fa2ad/occlusion_08ed7a4a-2980-11ef-8e16-d517f37fa2ad/scan_a5b11e9a-2980-11ef-8e16-d517f37fa2ad/db3b175f-2980-11ef-8e16-d517f37fa2ad.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_FRSC_a5b11e9a-2980-11ef-8e16-d517f37fa2ad_SNAPS','db3b175f-2980-11ef-8e16-d517f37fa2ad.png','db3b175f-2980-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.5 Morso anteriore ba1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 14:31:28.241','2024-06-13 12:31:28.758','2024-06-13 14:31:31.782'),('dbaacc35-2982-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_08eb58c6-2980-11ef-8e16-d517f37fa2ad/occlusion_08ed7a4a-2980-11ef-8e16-d517f37fa2ad/computedocclusion_a4bc6912-2980-11ef-8e16-d517f37fa2ad/dbaacc35-2982-11ef-8e16-d517f37fa2ad.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_OCC_a4bc6912-2980-11ef-8e16-d517f37fa2ad_SCREENO','dbaacc35-2982-11ef-8e16-d517f37fa2ad.png','dbaacc35-2982-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.5 Occlusione o1 Screenshot 2\",\"occlusionType\":3,\"title\":\"2\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 14:45:49.000','2024-06-13 12:45:49.000','2024-06-13 14:45:49.000'),('dc0c5167-296f-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_8e81ab09-296b-11ef-8e16-d517f37fa2ad/occlusion_8e83509f-296b-11ef-8e16-d517f37fa2ad/scan_6c4bba69-296f-11ef-8e16-d517f37fa2ad/dc0c5167-296f-11ef-8e16-d517f37fa2ad.zip','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_SESS_8e83509f-296b-11ef-8e16-d517f37fa2ad_RISC_6c4bba69-296f-11ef-8e16-d517f37fa2ad_MODEL','dc0c5167-296f-11ef-8e16-d517f37fa2ad.zip','dc0c5167-296f-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Morso destro br2\",\"modelMatrix\":\"0.998407,-0.01049,0.0522149,0,0.027206,0.983364,-0.182685,0,-0.0499822,0.181497,0.981788,0,3.25738,2.91727,-16.7534,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 12:29:48.167','2024-06-13 10:29:48.481','2024-06-13 12:29:51.001'),('dc0c6082-296f-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_8e81ab09-296b-11ef-8e16-d517f37fa2ad/occlusion_8e83509f-296b-11ef-8e16-d517f37fa2ad/scan_6c4bba69-296f-11ef-8e16-d517f37fa2ad/dc0c6082-296f-11ef-8e16-d517f37fa2ad.png','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_SESS_8e83509f-296b-11ef-8e16-d517f37fa2ad_RISC_6c4bba69-296f-11ef-8e16-d517f37fa2ad_SNAPS','dc0c6082-296f-11ef-8e16-d517f37fa2ad.png','dc0c6082-296f-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Morso destro br2 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 12:29:48.168','2024-06-13 10:29:48.482','2024-06-13 12:29:52.421'),('dc224fd3-27ce-11ef-8e37-d519fa9d22d2',2,'/var/.scan4all/iris/data/2024/2/a1ace9b5-2271-11ef-8d76-d310d2ec2c14/session_1cb775ae-271f-11ef-8e16-d517f37fa1ab/occlusion_1cb90d11-271f-11ef-8e16-d517f37fa1ab/scan_1db1e2d3-271f-11ef-8e16-d517f37fa1ab/dc224fd3-27ce-11ef-8e37-d519fa9d22d2.png','PATIENT_a1ace9b5-2271-11ef-8d76-d310d2ec2c14_ACT_1cb775ae-271f-11ef-8e16-d517f37fa1ab_SESS_1cb90d11-271f-11ef-8e16-d517f37fa1ab_TOSC_1db1e2d3-271f-11ef-8e16-d517f37fa1ab_SCREENS','dc224fd3-27ce-11ef-8e37-d519fa9d22d2.png','dc224fd3-27ce-11ef-8e37-d519fa9d22d2','{\"displayTitle\":\"2.2 Maxillaire u1 Capture d\'écran 1 [pc2]\",\"title\":\"1\"}','PNG',0,'SYNCED',0,NULL,'2024-06-11 10:44:48.175','2024-06-11 08:44:48.292','2024-06-11 10:44:48.729'),('dc9d5d76-2a2e-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/scan_aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd/dc9d5d76-2a2e-11ef-8f1c-d8242c6fa8fd.png','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_BOSC_aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd_SCREENS','dc9d5d76-2a2e-11ef-8f1c-d8242c6fa8fd.png','dc9d5d76-2a2e-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Mandibola l2 Screenshot 1\",\"title\":\"1\"}','PNG',0,'SYNCED',0,NULL,'2024-06-14 11:17:05.000','2024-06-14 09:17:05.000','2024-06-14 11:17:05.000'),('dd2934fd-2986-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_4704a021-2963-11ef-8e16-d517f37fa2ad/order_470ab6fc-2963-11ef-8e16-d517f37fa2ad/dd2934fd-2986-11ef-8e16-d517f37fa2ad.pdf','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_4704a021-2963-11ef-8e16-d517f37fa2ad_PROST_470ab6fc-2963-11ef-8e16-d517f37fa2ad_FORM','dd2934fd-2986-11ef-8e16-d517f37fa2ad.pdf','1a206393-296b-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.1 Altro\",\"title\":\"Altro\"}','PDF',1,'SYNCED',0,NULL,'2024-06-13 15:14:30.000','2024-06-13 13:14:30.000','2024-06-13 15:14:30.000'),('de217b4c-2278-11ef-8d76-d310d2ec2c14',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/scan_c523efdb-2278-11ef-8d76-d310d2ec2c14/de217b4c-2278-11ef-8d76-d310d2ec2c14.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_TOSC_c523efdb-2278-11ef-8d76-d310d2ec2c14_MODEL','de217b4c-2278-11ef-8d76-d310d2ec2c14.zip','c52419e8-2278-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Maxillaire u2 [pc2]\",\"modelMatrix\":\"-0.0834467,0.986107,-0.143628,0,-0.981709,-0.1061,-0.158085,0,-0.171128,0.12781,0.976924,0,-17.1278,-28.7907,-11.2181,1\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2024-06-04 15:46:38.993','2024-06-04 13:46:39.079','2024-06-04 15:46:39.388'),('de3ffbb4-2984-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_a8885309-2984-11ef-8e16-d517f37fa2ad/occlusion_a888b842-2984-11ef-8e16-d517f37fa2ad/scan_de3fd237-2984-11ef-8e16-d517f37fa2ad/de3ffbb4-2984-11ef-8e16-d517f37fa2ad.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_a8885309-2984-11ef-8e16-d517f37fa2ad_SESS_a888b842-2984-11ef-8e16-d517f37fa2ad_TOSC_de3fd237-2984-11ef-8e16-d517f37fa2ad_MODEL','de3ffbb4-2984-11ef-8e16-d517f37fa2ad.zip','de3ffbb4-2984-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.7 Mascella u2\",\"modelMatrix\":\"0.676804,-0.736112,0.00867294,0,0.735905,0.676831,0.0185321,0,-0.0195118,-0.00616012,0.999791,0,-5.57178,10.6847,-13.2414,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 15:00:11.293','2024-06-13 13:05:35.403','2024-06-13 15:05:40.092'),('de45dada-2984-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_a8885309-2984-11ef-8e16-d517f37fa2ad/occlusion_a888b842-2984-11ef-8e16-d517f37fa2ad/scan_de3fd237-2984-11ef-8e16-d517f37fa2ad/de45dada-2984-11ef-8e16-d517f37fa2ad.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_a8885309-2984-11ef-8e16-d517f37fa2ad_SESS_a888b842-2984-11ef-8e16-d517f37fa2ad_TOSC_de3fd237-2984-11ef-8e16-d517f37fa2ad_SNAPS','de45dada-2984-11ef-8e16-d517f37fa2ad.png','de45dada-2984-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.7 Mascella u2 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 15:00:11.331','2024-06-13 13:05:35.403','2024-06-13 15:05:41.487'),('debcb052-27ce-11ef-8e37-d519fa9d22d2',2,'/var/.scan4all/iris/data/2024/2/a1ace9b5-2271-11ef-8d76-d310d2ec2c14/session_1cb775ae-271f-11ef-8e16-d517f37fa1ab/occlusion_1cb90d11-271f-11ef-8e16-d517f37fa1ab/scan_1db1e2d3-271f-11ef-8e16-d517f37fa1ab/debcb052-27ce-11ef-8e37-d519fa9d22d2.png','PATIENT_a1ace9b5-2271-11ef-8d76-d310d2ec2c14_ACT_1cb775ae-271f-11ef-8e16-d517f37fa1ab_SESS_1cb90d11-271f-11ef-8e16-d517f37fa1ab_TOSC_1db1e2d3-271f-11ef-8e16-d517f37fa1ab_SCREENS','debcb052-27ce-11ef-8e37-d519fa9d22d2.png','debcb052-27ce-11ef-8e37-d519fa9d22d2','{\"displayTitle\":\"2.2 Maxillaire u1 Capture d\'écran 2 [pc2]\",\"title\":\"2\"}','PNG',0,'SYNCED',0,NULL,'2024-06-11 10:44:52.542','2024-06-11 08:44:52.632','2024-06-11 10:44:53.027'),('df3e0119-2e0d-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/4382037a-2735-11ef-8e16-d517f37fa1ab/session_dd7db4ad-2e0d-11ef-8deb-d515ea58f6cb/analyse_dd84e0d1-2e0d-11ef-8deb-d515ea58f6cb/df3e0119-2e0d-11ef-8deb-d515ea58f6cb.json','PATIENT_4382037a-2735-11ef-8e16-d517f37fa1ab_ACT_dd7db4ad-2e0d-11ef-8deb-d515ea58f6cb_ANA_dd84e0d1-2e0d-11ef-8deb-d515ea58f6cb_TRANS','df3e0119-2e0d-11ef-8deb-d515ea58f6cb.json','df3e0119-2e0d-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"6.2 Analyse m1 [pc2]\"}','JSON',0,'SYNCED',0,NULL,'2024-06-19 09:30:59.305','2024-06-19 07:30:59.309','2024-06-19 12:49:24.023'),('df790a58-2e0d-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/4382037a-2735-11ef-8e16-d517f37fa1ab/session_dd7db4ad-2e0d-11ef-8deb-d515ea58f6cb/analyse_dd84e0d1-2e0d-11ef-8deb-d515ea58f6cb/df790a58-2e0d-11ef-8deb-d515ea58f6cb.png','PATIENT_4382037a-2735-11ef-8e16-d517f37fa1ab_ACT_dd7db4ad-2e0d-11ef-8deb-d515ea58f6cb_ANA_dd84e0d1-2e0d-11ef-8deb-d515ea58f6cb_SNAPS','df790a58-2e0d-11ef-8deb-d515ea58f6cb.png','df790a58-2e0d-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"6.2 Analyse m1 [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-19 09:30:59.692','2024-06-19 07:30:59.694','2024-06-19 12:49:24.258'),('dff96d3d-2980-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_08eb58c6-2980-11ef-8e16-d517f37fa2ad/occlusion_08ed7a4a-2980-11ef-8e16-d517f37fa2ad/computedocclusion_a4bc6912-2980-11ef-8e16-d517f37fa2ad/dff96d3d-2980-11ef-8e16-d517f37fa2ad.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_OCC_a4bc6912-2980-11ef-8e16-d517f37fa2ad_TO1','dff96d3d-2980-11ef-8e16-d517f37fa2ad.zip','dff96d3d-2980-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.5 Occlusione o1 Mascella u1\",\"modelMatrix\":\"0.0885466,-0.989287,-0.116065,0,0.981849,0.106308,-0.157067,0,0.167723,-0.10005,0.980744,0,7.04315,3.35377,-13.5757,1\",\"occlusionMatrix\":\"0.157494,0.0684631,-0.985147,0,0.971197,0.169975,0.167075,0,0.178888,-0.98308,-0.0397179,0,8.13025,12.5531,4.31027,1\",\"occlusionType\":3,\"referenceScanFullDisplayId\":\"5.5_u1\",\"referenceScanId\":\"099d82e1-2980-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 14:31:39.000','2024-06-13 12:31:39.000','2024-06-13 14:31:39.000'),('e000eb20-225b-11ef-8f1f-d8242c71b430',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_e3862d66-225a-11ef-8f1f-d8242c71b430/occlusion_e3868e5f-225a-11ef-8f1f-d8242c71b430/computedocclusion_6ba502f4-225b-11ef-8f1f-d8242c71b430/e000eb20-225b-11ef-8f1f-d8242c71b430.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_SESS_e3868e5f-225a-11ef-8f1f-d8242c71b430_OCC_6ba502f4-225b-11ef-8f1f-d8242c71b430_TO1','e000eb20-225b-11ef-8f1f-d8242c71b430.zip','e000eb20-225b-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.1 Occlusion o1 Maxillaire u1\",\"modelMatrix\":\"0.983821,-0.178562,-0.0145353,0,0.167676,0.946334,-0.276291,0,0.0630904,0.269384,0.960964,0,-18.4738,6.44284,-12.9473,1\",\"occlusionMatrix\":\"-0.983067,0.0412191,-0.180339,0,0.183184,0.197784,-0.962563,0,-0.00759549,-0.979387,-0.202378,0,17.9497,7.67706,6.6371,1\",\"occlusionType\":2,\"referenceScanFullDisplayId\":\"1.1_u1\",\"referenceScanId\":\"e52279ce-225a-11ef-8f1f-d8242c71b430\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 12:19:09.000','2024-06-04 10:19:09.000','2024-06-04 12:19:09.000'),('e01bae07-225b-11ef-8f1f-d8242c71b430',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_e3862d66-225a-11ef-8f1f-d8242c71b430/occlusion_e3868e5f-225a-11ef-8f1f-d8242c71b430/computedocclusion_6ba502f4-225b-11ef-8f1f-d8242c71b430/e01bae07-225b-11ef-8f1f-d8242c71b430.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_SESS_e3868e5f-225a-11ef-8f1f-d8242c71b430_OCC_6ba502f4-225b-11ef-8f1f-d8242c71b430_BO1','e01bae07-225b-11ef-8f1f-d8242c71b430.zip','e01bae07-225b-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.1 Occlusion o1 Mandibule l1\",\"modelMatrix\":\"-0.728037,0.684478,-0.03811,0,-0.685353,-0.725423,0.0636657,0,0.0159319,0.0724698,0.997243,0,9.49558,-10.7,-12.9454,1\",\"occlusionMatrix\":\"-0.985853,-0.13039,-0.111741,0,-0.134966,0.214901,0.966923,0,-0.0995888,0.967905,-0.229331,0,6.18786,-8.33646,11.3454,1\",\"occlusionType\":2,\"referenceScanFullDisplayId\":\"1.1_l1\",\"referenceScanId\":\"37ccba29-225b-11ef-8f1f-d8242c71b430\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 12:19:11.000','2024-06-04 10:19:11.000','2024-06-04 12:19:11.000'),('e01e29be-2980-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_08eb58c6-2980-11ef-8e16-d517f37fa2ad/occlusion_08ed7a4a-2980-11ef-8e16-d517f37fa2ad/computedocclusion_a4bc6912-2980-11ef-8e16-d517f37fa2ad/e01e29be-2980-11ef-8e16-d517f37fa2ad.zip','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_OCC_a4bc6912-2980-11ef-8e16-d517f37fa2ad_BO1','e01e29be-2980-11ef-8e16-d517f37fa2ad.zip','e01e29be-2980-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.5 Occlusione o1 Mandibola l1\",\"modelMatrix\":\"-0.0691305,-0.980151,-0.185807,0,0.932705,-0.129585,0.336555,0,-0.353953,-0.150036,0.92315,0,-2.52526,5.094,-12.0573,1\",\"occlusionMatrix\":\"-0.726301,-0.0498987,-0.685575,0,-0.669992,0.274454,0.689787,0,0.15374,0.960326,-0.232761,0,3.4774,-11.0063,-1.91383,1\",\"occlusionType\":3,\"referenceScanFullDisplayId\":\"5.5_l1\",\"referenceScanId\":\"4d76036e-2980-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 14:31:40.000','2024-06-13 12:31:40.000','2024-06-13 14:31:40.000'),('e091c2ff-225b-11ef-8f1f-d8242c71b430',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_e3862d66-225a-11ef-8f1f-d8242c71b430/occlusion_e3868e5f-225a-11ef-8f1f-d8242c71b430/computedocclusion_6ba502f4-225b-11ef-8f1f-d8242c71b430/e091c2ff-225b-11ef-8f1f-d8242c71b430.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_SESS_e3868e5f-225a-11ef-8f1f-d8242c71b430_OCC_6ba502f4-225b-11ef-8f1f-d8242c71b430_SNAPO','e091c2ff-225b-11ef-8f1f-d8242c71b430.png','e091c2ff-225b-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.1 Occlusion o1\",\"occlusionType\":2}','PNG',0,'SYNCED',0,NULL,'2024-06-04 12:19:11.000','2024-06-04 10:19:11.000','2024-06-04 12:19:11.000'),('e09fbf20-2980-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_08eb58c6-2980-11ef-8e16-d517f37fa2ad/occlusion_08ed7a4a-2980-11ef-8e16-d517f37fa2ad/computedocclusion_a4bc6912-2980-11ef-8e16-d517f37fa2ad/e09fbf20-2980-11ef-8e16-d517f37fa2ad.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_OCC_a4bc6912-2980-11ef-8e16-d517f37fa2ad_SNAPO','e09fbf20-2980-11ef-8e16-d517f37fa2ad.png','e09fbf20-2980-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.5 Occlusione o1\",\"occlusionType\":3}','PNG',0,'SYNCED',0,NULL,'2024-06-13 14:31:40.000','2024-06-13 12:31:40.000','2024-06-13 14:31:40.000'),('e0f61549-2a2e-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/scan_aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd/e0f61549-2a2e-11ef-8f1c-d8242c6fa8fd.ply','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_BOSC_aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd_SEG','e0f61549-2a2e-11ef-8f1c-d8242c6fa8fd.ply','aeeb948a-2a2e-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Mandibola l2 Segmentazione\"}','PLY',1,'SYNCED',0,NULL,'2024-06-14 11:17:11.806','2024-06-14 09:17:11.875','2024-06-14 11:17:12.511'),('e0f8d71f-2a29-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/scan_8de1d45c-2a29-11ef-8f1c-d8242c6fa8fd/e0f8d71f-2a29-11ef-8f1c-d8242c6fa8fd.zip','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_TOSC_8de1d45c-2a29-11ef-8f1c-d8242c6fa8fd_MODEL','e0f8d71f-2a29-11ef-8f1c-d8242c6fa8fd.zip','e0f8d71f-2a29-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Mascella u1\",\"modelMatrix\":\"0.990607,-0.0477183,-0.128143,0,0.0606045,0.993278,0.0986225,0,0.122576,-0.105462,0.98684,0,-17.296,2.00683,-11.2545,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-14 10:41:28.000','2024-06-14 08:41:28.000','2024-06-14 10:41:28.000'),('e0f8ef08-2a29-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/scan_8de1d45c-2a29-11ef-8f1c-d8242c6fa8fd/e0f8ef08-2a29-11ef-8f1c-d8242c6fa8fd.png','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_TOSC_8de1d45c-2a29-11ef-8f1c-d8242c6fa8fd_SNAPS','e0f8ef08-2a29-11ef-8f1c-d8242c6fa8fd.png','e0f8ef08-2a29-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Mascella u1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-14 10:41:29.000','2024-06-14 08:41:29.000','2024-06-14 10:41:29.000'),('e1412689-2735-11ef-8e16-d517f37fa1ab',2,'/var/.scan4all/iris/data/2024/2/4382037a-2735-11ef-8e16-d517f37fa1ab/session_be9a8e99-2735-11ef-8e16-d517f37fa1ab/occlusion_be9c5752-2735-11ef-8e16-d517f37fa1ab/scan_bfa3d876-2735-11ef-8e16-d517f37fa1ab/e1412689-2735-11ef-8e16-d517f37fa1ab.zip','PATIENT_4382037a-2735-11ef-8e16-d517f37fa1ab_ACT_be9a8e99-2735-11ef-8e16-d517f37fa1ab_SESS_be9c5752-2735-11ef-8e16-d517f37fa1ab_TOSC_bfa3d876-2735-11ef-8e16-d517f37fa1ab_MODEL','e1412689-2735-11ef-8e16-d517f37fa1ab.zip','e1412689-2735-11ef-8e16-d517f37fa1ab','{\"displayTitle\":\"6.1 Maxillaire u1 [pc2]\",\"modelMatrix\":\"-0.479814,-0.110653,0.870364,0,-0.0586755,0.993841,0.0940049,0,-0.875406,-0.00596416,-0.483352,0,21.2778,2.84273,-5.93875,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-10 16:29:47.000','2024-06-10 14:29:47.000','2024-06-10 16:29:47.000'),('e1413c8f-2735-11ef-8e16-d517f37fa1ab',2,'/var/.scan4all/iris/data/2024/2/4382037a-2735-11ef-8e16-d517f37fa1ab/session_be9a8e99-2735-11ef-8e16-d517f37fa1ab/occlusion_be9c5752-2735-11ef-8e16-d517f37fa1ab/scan_bfa3d876-2735-11ef-8e16-d517f37fa1ab/e1413c8f-2735-11ef-8e16-d517f37fa1ab.png','PATIENT_4382037a-2735-11ef-8e16-d517f37fa1ab_ACT_be9a8e99-2735-11ef-8e16-d517f37fa1ab_SESS_be9c5752-2735-11ef-8e16-d517f37fa1ab_TOSC_bfa3d876-2735-11ef-8e16-d517f37fa1ab_SNAPS','e1413c8f-2735-11ef-8e16-d517f37fa1ab.png','e1413c8f-2735-11ef-8e16-d517f37fa1ab','{\"displayTitle\":\"6.1 Maxillaire u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-10 16:29:47.000','2024-06-10 14:29:47.000','2024-06-10 16:29:47.000'),('e198305a-2274-11ef-8d76-d310d2ec2c14',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/computedocclusion_43733a85-2274-11ef-8d76-d310d2ec2c14/e198305a-2274-11ef-8d76-d310d2ec2c14.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_OCC_43733a85-2274-11ef-8d76-d310d2ec2c14_TO1','e198305a-2274-11ef-8d76-d310d2ec2c14.zip','e198305a-2274-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Occlusion o1 Maxillaire u1 [pc2]\",\"modelMatrix\":\"-0.0834467,0.986107,-0.143628,0,-0.981709,-0.1061,-0.158085,0,-0.171128,0.12781,0.976924,0,-17.1278,-28.7907,-11.2181,1\",\"occlusionMatrix\":\"-0.0834467,0.143628,0.986107,0,-0.981709,0.158085,-0.1061,0,-0.171128,-0.976924,0.12781,0,-17.1278,11.2181,-28.7907,1\",\"occlusionType\":5,\"referenceScanFullDisplayId\":\"1.2_u1\",\"referenceScanId\":\"f3b0649e-2272-11ef-8d76-d310d2ec2c14\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 15:18:10.000','2024-06-04 13:18:10.000','2024-06-04 15:18:10.000'),('e1cab74d-2274-11ef-8d76-d310d2ec2c14',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/computedocclusion_43733a85-2274-11ef-8d76-d310d2ec2c14/e1cab74d-2274-11ef-8d76-d310d2ec2c14.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_OCC_43733a85-2274-11ef-8d76-d310d2ec2c14_BO1','e1cab74d-2274-11ef-8d76-d310d2ec2c14.zip','e1cab74d-2274-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Occlusion o1 Mandibule l1 [pc2]\",\"modelMatrix\":\"0.135656,-0.982642,-0.126536,0,0.970104,0.157682,-0.184485,0,0.201235,-0.0977264,0.974656,0,-23.8369,18.6095,-10.139,1\",\"occlusionMatrix\":\"-0.937914,-0.34636,-0.0188404,0,0.0261142,-0.0163346,-0.999524,0,0.345889,-0.937964,0.0243633,0,-19.0636,6.05109,-8.6735,1\",\"occlusionType\":5,\"referenceScanFullDisplayId\":\"1.2_l1\",\"referenceScanId\":\"96d08283-2273-11ef-8d76-d310d2ec2c14\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 15:36:20.000','2024-06-04 13:36:20.000','2024-06-04 15:36:20.000'),('e27ce916-2274-11ef-8d76-d310d2ec2c14',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/computedocclusion_43733a85-2274-11ef-8d76-d310d2ec2c14/e27ce916-2274-11ef-8d76-d310d2ec2c14.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_OCC_43733a85-2274-11ef-8d76-d310d2ec2c14_SNAPO','e27ce916-2274-11ef-8d76-d310d2ec2c14.png','e27ce916-2274-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Occlusion o1 [pc2]\",\"occlusionType\":5}','PNG',0,'SYNCED',0,NULL,'2024-06-04 15:36:20.000','2024-06-04 13:36:20.000','2024-06-04 15:36:20.000'),('e36ba3f8-2970-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_8e81ab09-296b-11ef-8e16-d517f37fa2ad/occlusion_8e83509f-296b-11ef-8e16-d517f37fa2ad/computedocclusion_453321dd-296f-11ef-8e16-d517f37fa2ad/e36ba3f8-2970-11ef-8e16-d517f37fa2ad.json','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_SESS_8e83509f-296b-11ef-8e16-d517f37fa2ad_OCC_453321dd-296f-11ef-8e16-d517f37fa2ad_METER','e36ba3f8-2970-11ef-8e16-d517f37fa2ad.json','95dfa34a-2970-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Occlusione o1\",\"occlusionType\":1}','JSON',2,'SYNCED',0,NULL,'2024-06-13 12:37:11.000','2024-06-13 10:37:11.000','2024-06-13 12:37:11.000'),('e386f28a-2e42-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/4382037a-2735-11ef-8e16-d517f37fa1ab/session_68af0333-2e42-11ef-8deb-d515ea58f6cb/order_68b5196a-2e42-11ef-8deb-d515ea58f6cb/e386f28a-2e42-11ef-8deb-d515ea58f6cb.pdf','PATIENT_4382037a-2735-11ef-8e16-d517f37fa1ab_ACT_68af0333-2e42-11ef-8deb-d515ea58f6cb_PROST_68b5196a-2e42-11ef-8deb-d515ea58f6cb_FORM','e386f28a-2e42-11ef-8deb-d515ea58f6cb.pdf','d8355af9-2e42-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"6.4 Removable [pc2]\",\"title\":\"Removable\"}','PDF',1,'SYNCED',0,NULL,'2024-06-19 15:50:29.821','2024-06-19 13:50:30.567','2024-06-19 15:50:30.573'),('e3f97f75-298f-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_d703d726-298d-11ef-8e16-d517f37fa2ad/occlusion_d70636d7-298d-11ef-8e16-d517f37fa2ad/scan_a9e9d6c4-298f-11ef-8e16-d517f37fa2ad/e3f97f75-298f-11ef-8e16-d517f37fa2ad.png','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_d703d726-298d-11ef-8e16-d517f37fa2ad_SESS_d70636d7-298d-11ef-8e16-d517f37fa2ad_TOSC_a9e9d6c4-298f-11ef-8e16-d517f37fa2ad_SCREENS','e3f97f75-298f-11ef-8e16-d517f37fa2ad.png','e3f97f75-298f-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.2 Mascella u2 Screenshot lato occlusale di 17 gommato\",\"title\":\"lato occlusale di 17 gommato\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 16:21:10.443','2024-06-13 14:21:10.443','2024-06-13 16:21:10.455'),('e3ffe01f-2982-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_08eb58c6-2980-11ef-8e16-d517f37fa2ad/occlusion_08ed7a4a-2980-11ef-8e16-d517f37fa2ad/computedocclusion_a4bc6912-2980-11ef-8e16-d517f37fa2ad/e3ffe01f-2982-11ef-8e16-d517f37fa2ad.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_OCC_a4bc6912-2980-11ef-8e16-d517f37fa2ad_SCREENO','e3ffe01f-2982-11ef-8e16-d517f37fa2ad.png','e3ffe01f-2982-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.5 Occlusione o1 Screenshot 3\",\"occlusionType\":3,\"title\":\"3\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 14:46:04.000','2024-06-13 12:46:04.000','2024-06-13 14:46:04.000'),('e4230834-2737-11ef-8e16-d517f37fa1ab',2,'/var/.scan4all/iris/data/2024/2/a1ace9b5-2271-11ef-8d76-d310d2ec2c14/session_1cb775ae-271f-11ef-8e16-d517f37fa1ab/occlusion_1cb90d11-271f-11ef-8e16-d517f37fa1ab/scan_1db1e2d3-271f-11ef-8e16-d517f37fa1ab/e4230834-2737-11ef-8e16-d517f37fa1ab.xyz','PATIENT_a1ace9b5-2271-11ef-8d76-d310d2ec2c14_ACT_1cb775ae-271f-11ef-8e16-d517f37fa1ab_SESS_1cb90d11-271f-11ef-8e16-d517f37fa1ab_TOSC_1db1e2d3-271f-11ef-8e16-d517f37fa1ab_LIFI','e4230834-2737-11ef-8e16-d517f37fa1ab.xyz','e4230834-2737-11ef-8e16-d517f37fa1ab','{\"displayTitle\":\"2.2 Maxillaire u1 Ligne de finition 0 [pc2]\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-10 16:44:08.000','2024-06-10 14:44:08.000','2024-06-10 16:44:08.000'),('e42318eb-2737-11ef-8e16-d517f37fa1ab',2,'/var/.scan4all/iris/data/2024/2/a1ace9b5-2271-11ef-8d76-d310d2ec2c14/session_1cb775ae-271f-11ef-8e16-d517f37fa1ab/occlusion_1cb90d11-271f-11ef-8e16-d517f37fa1ab/scan_1db1e2d3-271f-11ef-8e16-d517f37fa1ab/e42318eb-2737-11ef-8e16-d517f37fa1ab.bin','PATIENT_a1ace9b5-2271-11ef-8d76-d310d2ec2c14_ACT_1cb775ae-271f-11ef-8e16-d517f37fa1ab_SESS_1cb90d11-271f-11ef-8e16-d517f37fa1ab_TOSC_1db1e2d3-271f-11ef-8e16-d517f37fa1ab_LIFIM','e42318eb-2737-11ef-8e16-d517f37fa1ab.bin','e42318eb-2737-11ef-8e16-d517f37fa1ab','{\"displayTitle\":\"2.2 Maxillaire u1 Ligne de finition métadonnées 0 [pc2]\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-10 16:44:08.000','2024-06-10 14:44:08.000','2024-06-10 16:44:08.000'),('e58acb2d-2e4d-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/115617bc-2e4b-11ef-8deb-d515ea58f6cb/session_ddffc633-2e4d-11ef-8deb-d515ea58f6cb/order_de096a3e-2e4d-11ef-8deb-d515ea58f6cb/e58acb2d-2e4d-11ef-8deb-d515ea58f6cb.pdf','PATIENT_115617bc-2e4b-11ef-8deb-d515ea58f6cb_ACT_ddffc633-2e4d-11ef-8deb-d515ea58f6cb_PROST_de096a3e-2e4d-11ef-8deb-d515ea58f6cb_FORM','e58acb2d-2e4d-11ef-8deb-d515ea58f6cb.pdf','e58acb2d-2e4d-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"17.3 Other [pc2]\",\"title\":\"Other\"}','PDF',0,'SYNCED',0,NULL,'2024-06-19 17:09:17.666','2024-06-19 15:09:18.394','2024-06-19 17:09:18.623'),('e59826d2-2278-11ef-8d76-d310d2ec2c14',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/computedocclusion_9ed6352b-2277-11ef-8d76-d310d2ec2c14/e59826d2-2278-11ef-8d76-d310d2ec2c14.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_OCC_9ed6352b-2277-11ef-8d76-d310d2ec2c14_TO2','e59826d2-2278-11ef-8d76-d310d2ec2c14.zip','e59826d2-2278-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Occlusion o2 Maxillaire u2 [pc2]\",\"modelMatrix\":\"-0.0834467,0.986107,-0.143628,0,-0.981709,-0.1061,-0.158085,0,-0.171128,0.12781,0.976924,0,-17.1278,-28.7907,-11.2181,1\",\"occlusionMatrix\":\"-0.0756177,0.133991,0.988095,0,-0.986811,0.132191,-0.0934454,0,-0.143139,-0.982128,0.122229,0,-17.9384,11.0046,-27.4488,1\",\"occlusionType\":5,\"referenceScanFullDisplayId\":\"1.2_u2\",\"referenceScanId\":\"c523efdb-2278-11ef-8d76-d310d2ec2c14\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 15:46:53.000','2024-06-04 13:46:53.000','2024-06-04 15:46:53.000'),('e5bb1f50-27ce-11ef-8e37-d519fa9d22d2',2,'/var/.scan4all/iris/data/2024/2/a1ace9b5-2271-11ef-8d76-d310d2ec2c14/session_1cb775ae-271f-11ef-8e16-d517f37fa1ab/occlusion_1cb90d11-271f-11ef-8e16-d517f37fa1ab/scan_1db1e2d3-271f-11ef-8e16-d517f37fa1ab/e5bb1f50-27ce-11ef-8e37-d519fa9d22d2.png','PATIENT_a1ace9b5-2271-11ef-8d76-d310d2ec2c14_ACT_1cb775ae-271f-11ef-8e16-d517f37fa1ab_SESS_1cb90d11-271f-11ef-8e16-d517f37fa1ab_TOSC_1db1e2d3-271f-11ef-8e16-d517f37fa1ab_SCREENS','e5bb1f50-27ce-11ef-8e37-d519fa9d22d2.png','e5bb1f50-27ce-11ef-8e37-d519fa9d22d2','{\"displayTitle\":\"2.2 Maxillaire u1 Capture d\'écran 3 [pc2]\",\"title\":\"3\"}','PNG',0,'SYNCED',0,NULL,'2024-06-11 10:45:04.276','2024-06-11 08:45:04.375','2024-06-11 10:45:04.803'),('e6296994-2eed-11ef-bb8b-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_82a44e97-2ee8-11ef-8dc9-d414e3397395/e6296994-2eed-11ef-bb8b-6ec2958327c0.ply','PATIENT_0d66331b-2eda-11ef-8de3-d515e950d747_ACT_ab602c0f-2edd-11ef-8de3-d515e950d747_SESS_ab61603b-2edd-11ef-8de3-d515e950d747_TOSC_75f3f1c2-2eec-11ef-8dc9-d414e3397395_SEG','8871cd28-2eed-11ef-8dc9-d414e3397395.ply','e6296994-2eed-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.2 Maxilla u1 Segmentation\"}','PLY',0,'SYNCED',0,NULL,'2024-06-20 12:12:00.000','2024-06-20 10:12:00.000','2024-06-20 12:12:00.000'),('e629af92-2eed-11ef-bb8b-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_82a44e97-2ee8-11ef-8dc9-d414e3397395/e629af92-2eed-11ef-bb8b-6ec2958327c0.png','PATIENT_0d66331b-2eda-11ef-8de3-d515e950d747_ACT_ab602c0f-2edd-11ef-8de3-d515e950d747_SESS_ab61603b-2edd-11ef-8de3-d515e950d747_TOSC_75f3f1c2-2eec-11ef-8dc9-d414e3397395_SCREENS','c40ffbfa-2eed-11ef-8dc9-d414e3397395.png','e629af92-2eed-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.2 Maxilla u1 Screenshot 2\",\"title\":\"2\"}','PNG',0,'SYNCED',0,NULL,'2024-06-20 12:13:40.000','2024-06-20 10:13:40.000','2024-06-20 12:13:40.000'),('e62a0cee-2eed-11ef-bb8b-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_82a44e97-2ee8-11ef-8dc9-d414e3397395/e62a0cee-2eed-11ef-bb8b-6ec2958327c0.json','PATIENT_0d66331b-2eda-11ef-8de3-d515e950d747_ACT_ab602c0f-2edd-11ef-8de3-d515e950d747_SESS_ab61603b-2edd-11ef-8de3-d515e950d747_TOSC_75f3f1c2-2eec-11ef-8dc9-d414e3397395_METER','c9da35dd-2eed-11ef-8dc9-d414e3397395.json','e62a0cee-2eed-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.2 Maxilla u1 Measurement\"}','JSON',0,'SYNCED',0,NULL,'2024-06-20 12:13:50.000','2024-06-20 10:13:50.000','2024-06-20 12:13:50.000'),('e62a6228-2eed-11ef-bb8b-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_82a44e97-2ee8-11ef-8dc9-d414e3397395/e62a6228-2eed-11ef-bb8b-6ec2958327c0.png','PATIENT_0d66331b-2eda-11ef-8de3-d515e950d747_ACT_ab602c0f-2edd-11ef-8de3-d515e950d747_SESS_ab61603b-2edd-11ef-8de3-d515e950d747_TOSC_75f3f1c2-2eec-11ef-8dc9-d414e3397395_SCREENS','d5aa1fd0-2eed-11ef-8dc9-d414e3397395.png','e62a6228-2eed-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.2 Maxilla u1 Screenshot 3\",\"title\":\"3\"}','PNG',0,'SYNCED',0,NULL,'2024-06-20 12:14:10.000','2024-06-20 10:14:10.000','2024-06-20 12:14:10.000'),('e62ac4a7-2eed-11ef-bb8b-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_82a44e97-2ee8-11ef-8dc9-d414e3397395/e62ac4a7-2eed-11ef-bb8b-6ec2958327c0.pdf','PATIENT_0d66331b-2eda-11ef-8de3-d515e950d747_ACT_ab602c0f-2edd-11ef-8de3-d515e950d747_PROST_ab653d64-2edd-11ef-8de3-d515e950d747_FORM','defa67bd-2eed-11ef-8dc9-d414e3397395.pdf','e62ac4a7-2eed-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.2 Tray\",\"title\":\"Tray\"}','PDF',0,'SYNCED',0,NULL,'2024-06-20 12:14:26.000','2024-06-20 10:14:26.000','2024-06-20 12:14:26.000'),('e62b1ba6-2eed-11ef-bb8b-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_82a44e97-2ee8-11ef-8dc9-d414e3397395/e62b1ba6-2eed-11ef-bb8b-6ec2958327c0.zip','PATIENT_0d66331b-2eda-11ef-8de3-d515e950d747_ACT_ab602c0f-2edd-11ef-8de3-d515e950d747_SESS_ab61603b-2edd-11ef-8de3-d515e950d747_TOSC_75f3f1c2-2eec-11ef-8dc9-d414e3397395_MODEL','f937639d-2eec-11ef-8dc9-d414e3397395.zip','e62b1ba6-2eed-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.2 Maxilla u1\",\"modelMatrix\":\"-0.250647,-0.967986,0.0134137,0,0.923068,-0.243146,-0.298037,0,0.291757,-0.0623204,0.95446,0,20.6469,18.6447,-13.2207,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-20 12:08:05.000','2024-06-20 10:08:05.000','2024-06-20 12:08:05.000'),('e62b626a-2eed-11ef-bb8b-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_82a44e97-2ee8-11ef-8dc9-d414e3397395/e62b626a-2eed-11ef-bb8b-6ec2958327c0.png','PATIENT_0d66331b-2eda-11ef-8de3-d515e950d747_ACT_ab602c0f-2edd-11ef-8de3-d515e950d747_SESS_ab61603b-2edd-11ef-8de3-d515e950d747_TOSC_75f3f1c2-2eec-11ef-8dc9-d414e3397395_SNAPS','f9377888-2eec-11ef-8dc9-d414e3397395.png','e62b626a-2eed-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"1.2 Maxilla u1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-20 12:08:05.000','2024-06-20 10:08:05.000','2024-06-20 12:08:05.000'),('e6a1b524-2e3b-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_da1f6873-2e3a-11ef-8deb-d515ea58f6cb/occlusion_da21a6e4-2e3a-11ef-8deb-d515ea58f6cb/computedocclusion_89b4ac38-2e3b-11ef-8deb-d515ea58f6cb/e6a1b524-2e3b-11ef-8deb-d515ea58f6cb.png','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_da1f6873-2e3a-11ef-8deb-d515ea58f6cb_SESS_da21a6e4-2e3a-11ef-8deb-d515ea58f6cb_OCC_89b4ac38-2e3b-11ef-8deb-d515ea58f6cb_SCREENO','e6a1b524-2e3b-11ef-8deb-d515ea58f6cb.png','e6a1b524-2e3b-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.2 Occlusion o1 Screenshot 1 [pc2]\",\"occlusionType\":2,\"title\":\"1\"}','PNG',0,'SYNCED',0,NULL,'2024-06-19 15:00:29.000','2024-06-19 13:00:29.000','2024-06-19 15:00:29.000'),('e87e5517-27ce-11ef-8e37-d519fa9d22d2',2,'/var/.scan4all/iris/data/2024/2/a1ace9b5-2271-11ef-8d76-d310d2ec2c14/session_1cb775ae-271f-11ef-8e16-d517f37fa1ab/occlusion_1cb90d11-271f-11ef-8e16-d517f37fa1ab/scan_1db1e2d3-271f-11ef-8e16-d517f37fa1ab/e87e5517-27ce-11ef-8e37-d519fa9d22d2.png','PATIENT_a1ace9b5-2271-11ef-8d76-d310d2ec2c14_ACT_1cb775ae-271f-11ef-8e16-d517f37fa1ab_SESS_1cb90d11-271f-11ef-8e16-d517f37fa1ab_TOSC_1db1e2d3-271f-11ef-8e16-d517f37fa1ab_SCREENS','e87e5517-27ce-11ef-8e37-d519fa9d22d2.png','e87e5517-27ce-11ef-8e37-d519fa9d22d2','{\"displayTitle\":\"2.2 Maxillaire u1 Capture d\'écran 4 [pc2]\",\"title\":\"4\"}','PNG',0,'SYNCED',0,NULL,'2024-06-11 10:45:08.911','2024-06-11 08:45:09.027','2024-06-11 10:45:09.524'),('e88dc6fc-2a2e-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/computedocclusion_e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd/e88dc6fc-2a2e-11ef-8f1c-d8242c6fa8fd.zip','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_OCC_e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd_BO3','e88dc6fc-2a2e-11ef-8f1c-d8242c6fa8fd.zip','e88dc6fc-2a2e-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Occlusione o1 Mandibola l2\",\"modelMatrix\":\"-0.934662,0.348207,-0.071824,0,-0.340741,-0.934968,-0.098644,0,-0.101502,-0.0677254,0.992527,0,16.8656,-3.96577,-16.4235,1\",\"occlusionMatrix\":\"0.84437,-0.423987,-0.327576,0,-0.264086,0.202642,-0.942976,0,0.46619,0.882728,0.0591344,0,-22.7793,-5.26709,4.79473,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"3.2_l2\",\"referenceScanId\":\"aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-14 11:17:24.544','2024-06-14 09:17:24.701','2024-06-14 11:17:25.536'),('e8a5635c-2a2e-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/computedocclusion_e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd/e8a5635c-2a2e-11ef-8f1c-d8242c6fa8fd.xyz','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_OCC_e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd_LIFIO','e8a5635c-2a2e-11ef-8f1c-d8242c6fa8fd.xyz','e8a5635c-2a2e-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Occlusione o1 Mandibola l2 Linea di finitura 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MANDIBLE_3\",\"referenceScanFullDisplayId\":\"3.2_l2\",\"referenceScanId\":\"aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd\",\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-14 11:17:24.698','2024-06-14 09:17:24.701','2024-06-14 11:17:26.969'),('e8a568de-2a2e-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/computedocclusion_e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd/e8a568de-2a2e-11ef-8f1c-d8242c6fa8fd.bin','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_OCC_e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd_LIFIMO','e8a568de-2a2e-11ef-8f1c-d8242c6fa8fd.bin','e8a568de-2a2e-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Occlusione o1 Mandibola l2 Linea di finitura dei metadati 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MANDIBLE_3\",\"referenceScanFullDisplayId\":\"3.2_l2\",\"referenceScanId\":\"aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd\",\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-14 11:17:24.698','2024-06-14 09:17:24.701','2024-06-14 11:17:27.435'),('e921fb8b-2735-11ef-8e16-d517f37fa1ab',2,'/var/.scan4all/iris/data/2024/2/4382037a-2735-11ef-8e16-d517f37fa1ab/session_be9a8e99-2735-11ef-8e16-d517f37fa1ab/occlusion_be9c5752-2735-11ef-8e16-d517f37fa1ab/scan_bfa3d876-2735-11ef-8e16-d517f37fa1ab/e921fb8b-2735-11ef-8e16-d517f37fa1ab.xyz','PATIENT_4382037a-2735-11ef-8e16-d517f37fa1ab_ACT_be9a8e99-2735-11ef-8e16-d517f37fa1ab_SESS_be9c5752-2735-11ef-8e16-d517f37fa1ab_TOSC_bfa3d876-2735-11ef-8e16-d517f37fa1ab_LIFI','e921fb8b-2735-11ef-8e16-d517f37fa1ab.xyz','e921fb8b-2735-11ef-8e16-d517f37fa1ab','{\"displayTitle\":\"6.1 Maxillaire u1 Ligne de finition 0 [pc2]\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-10 16:29:57.000','2024-06-10 14:29:57.000','2024-06-10 16:29:57.000'),('e9220178-2735-11ef-8e16-d517f37fa1ab',2,'/var/.scan4all/iris/data/2024/2/4382037a-2735-11ef-8e16-d517f37fa1ab/session_be9a8e99-2735-11ef-8e16-d517f37fa1ab/occlusion_be9c5752-2735-11ef-8e16-d517f37fa1ab/scan_bfa3d876-2735-11ef-8e16-d517f37fa1ab/e9220178-2735-11ef-8e16-d517f37fa1ab.bin','PATIENT_4382037a-2735-11ef-8e16-d517f37fa1ab_ACT_be9a8e99-2735-11ef-8e16-d517f37fa1ab_SESS_be9c5752-2735-11ef-8e16-d517f37fa1ab_TOSC_bfa3d876-2735-11ef-8e16-d517f37fa1ab_LIFIM','e9220178-2735-11ef-8e16-d517f37fa1ab.bin','e9220178-2735-11ef-8e16-d517f37fa1ab','{\"displayTitle\":\"6.1 Maxillaire u1 Ligne de finition métadonnées 0 [pc2]\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-10 16:29:58.000','2024-06-10 14:29:58.000','2024-06-10 16:29:58.000'),('ea897dcd-296f-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_8e81ab09-296b-11ef-8e16-d517f37fa2ad/occlusion_8e83509f-296b-11ef-8e16-d517f37fa2ad/computedocclusion_453321dd-296f-11ef-8e16-d517f37fa2ad/ea897dcd-296f-11ef-8e16-d517f37fa2ad.zip','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_SESS_8e83509f-296b-11ef-8e16-d517f37fa2ad_OCC_453321dd-296f-11ef-8e16-d517f37fa2ad_TO1','ea897dcd-296f-11ef-8e16-d517f37fa2ad.zip','ea897dcd-296f-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Occlusione o1 Mascella u3\",\"modelMatrix\":\"-0.864017,0.469494,-0.181796,0,-0.39807,-0.858135,-0.324261,0,-0.308244,-0.207799,0.928335,0,19.5091,-2.8713,-9.9809,1\",\"occlusionMatrix\":\"-0.394557,-0.328601,-0.857795,0,0.678,-0.729457,-0.032747,0,-0.620239,-0.599976,0.512958,0,10.8554,11.3708,2.89247,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.1_u3\",\"referenceScanId\":\"890595a9-296d-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 12:30:15.000','2024-06-13 10:30:15.000','2024-06-13 12:30:15.000'),('eaa64966-296f-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_8e81ab09-296b-11ef-8e16-d517f37fa2ad/occlusion_8e83509f-296b-11ef-8e16-d517f37fa2ad/computedocclusion_453321dd-296f-11ef-8e16-d517f37fa2ad/eaa64966-296f-11ef-8e16-d517f37fa2ad.xyz','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_SESS_8e83509f-296b-11ef-8e16-d517f37fa2ad_OCC_453321dd-296f-11ef-8e16-d517f37fa2ad_LIFIO','eaa64966-296f-11ef-8e16-d517f37fa2ad.xyz','eaa64966-296f-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Occlusione o1 Mascella u3 Linea di finitura 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY_1\",\"referenceScanFullDisplayId\":\"1.1_u3\",\"referenceScanId\":\"890595a9-296d-11ef-8e16-d517f37fa2ad\",\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-13 12:30:16.000','2024-06-13 10:30:16.000','2024-06-13 12:30:16.000'),('eaa64ffc-296f-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_8e81ab09-296b-11ef-8e16-d517f37fa2ad/occlusion_8e83509f-296b-11ef-8e16-d517f37fa2ad/computedocclusion_453321dd-296f-11ef-8e16-d517f37fa2ad/eaa64ffc-296f-11ef-8e16-d517f37fa2ad.bin','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_SESS_8e83509f-296b-11ef-8e16-d517f37fa2ad_OCC_453321dd-296f-11ef-8e16-d517f37fa2ad_LIFIMO','eaa64ffc-296f-11ef-8e16-d517f37fa2ad.bin','eaa64ffc-296f-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Occlusione o1 Mascella u3 Linea di finitura dei metadati 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY_1\",\"referenceScanFullDisplayId\":\"1.1_u3\",\"referenceScanId\":\"890595a9-296d-11ef-8e16-d517f37fa2ad\",\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-13 12:30:16.000','2024-06-13 10:30:16.000','2024-06-13 12:30:16.000'),('eaa687f7-296f-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_8e81ab09-296b-11ef-8e16-d517f37fa2ad/occlusion_8e83509f-296b-11ef-8e16-d517f37fa2ad/computedocclusion_453321dd-296f-11ef-8e16-d517f37fa2ad/eaa687f7-296f-11ef-8e16-d517f37fa2ad.zip','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_SESS_8e83509f-296b-11ef-8e16-d517f37fa2ad_OCC_453321dd-296f-11ef-8e16-d517f37fa2ad_BO1','eaa687f7-296f-11ef-8e16-d517f37fa2ad.zip','eaa687f7-296f-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Occlusione o1 Mandibola l1\",\"modelMatrix\":\"0.984561,0.053893,-0.16654,0,-0.0386096,0.994853,0.0936833,0,0.170732,-0.0858068,0.981574,0,-13.0352,1.74882,-13.1088,1\",\"occlusionMatrix\":\"-0.545426,-0.777895,-0.31915,0,0.829795,-0.546801,-0.0773739,0,-0.118342,-0.309753,0.944546,0,9.3749,12.9735,-9.31735,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.1_l1\",\"referenceScanId\":\"e2305601-296e-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 12:30:17.000','2024-06-13 10:30:17.000','2024-06-13 12:30:17.000'),('eae398fb-27ca-11ef-8e37-d519fa9d22d2',2,'/var/.scan4all/iris/data/2024/2/520a1417-2735-11ef-8e16-d517f37fa1ab/session_eadc6274-27ca-11ef-8e37-d519fa9d22d2/occlusion_eae1e551-27ca-11ef-8e37-d519fa9d22d2/scan_eae3435c-27ca-11ef-8e37-d519fa9d22d2/eae398fb-27ca-11ef-8e37-d519fa9d22d2.zip','PATIENT_520a1417-2735-11ef-8e16-d517f37fa1ab_ACT_eadc6274-27ca-11ef-8e37-d519fa9d22d2_SESS_eae1e551-27ca-11ef-8e37-d519fa9d22d2_TOSC_eae3435c-27ca-11ef-8e37-d519fa9d22d2_MODEL','eae398fb-27ca-11ef-8e37-d519fa9d22d2.zip','eae398fb-27ca-11ef-8e37-d519fa9d22d2','{\"displayTitle\":\"7.3 Maxillaire u1 [pc2]\",\"modelMatrix\":\"-0.218201,0.935678,-0.277299,0,-0.958042,-0.259493,-0.121732,0,-0.185859,0.239102,0.953041,0,5.39353,-7.32203,-11.0012,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-11 10:16:34.943','2024-06-11 08:16:35.004','2024-06-11 10:16:36.024'),('eaec83ff-27ca-11ef-8e37-d519fa9d22d2',2,'/var/.scan4all/iris/data/2024/2/520a1417-2735-11ef-8e16-d517f37fa1ab/session_eadc6274-27ca-11ef-8e37-d519fa9d22d2/occlusion_eae1e551-27ca-11ef-8e37-d519fa9d22d2/scan_eae3435c-27ca-11ef-8e37-d519fa9d22d2/eaec83ff-27ca-11ef-8e37-d519fa9d22d2.png','PATIENT_520a1417-2735-11ef-8e16-d517f37fa1ab_ACT_eadc6274-27ca-11ef-8e37-d519fa9d22d2_SESS_eae1e551-27ca-11ef-8e37-d519fa9d22d2_TOSC_eae3435c-27ca-11ef-8e37-d519fa9d22d2_SNAPS','eaec83ff-27ca-11ef-8e37-d519fa9d22d2.png','eaec83ff-27ca-11ef-8e37-d519fa9d22d2','{\"displayTitle\":\"7.3 Maxillaire u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-11 10:16:35.002','2024-06-11 08:16:35.005','2024-06-11 10:16:36.630'),('eb03efaf-27ce-11ef-8e37-d519fa9d22d2',2,'/var/.scan4all/iris/data/2024/2/a1ace9b5-2271-11ef-8d76-d310d2ec2c14/session_1cb775ae-271f-11ef-8e16-d517f37fa1ab/occlusion_1cb90d11-271f-11ef-8e16-d517f37fa1ab/scan_1db1e2d3-271f-11ef-8e16-d517f37fa1ab/eb03efaf-27ce-11ef-8e37-d519fa9d22d2.png','PATIENT_a1ace9b5-2271-11ef-8d76-d310d2ec2c14_ACT_1cb775ae-271f-11ef-8e16-d517f37fa1ab_SESS_1cb90d11-271f-11ef-8e16-d517f37fa1ab_TOSC_1db1e2d3-271f-11ef-8e16-d517f37fa1ab_SCREENS','eb03efaf-27ce-11ef-8e37-d519fa9d22d2.png','eb03efaf-27ce-11ef-8e37-d519fa9d22d2','{\"displayTitle\":\"2.2 Maxillaire u1 Capture d\'écran 5 [pc2]\",\"title\":\"5\"}','PNG',0,'SYNCED',0,NULL,'2024-06-11 10:45:13.142','2024-06-11 08:45:13.242','2024-06-11 10:45:13.718'),('eb340ff4-296f-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_8e81ab09-296b-11ef-8e16-d517f37fa2ad/occlusion_8e83509f-296b-11ef-8e16-d517f37fa2ad/computedocclusion_453321dd-296f-11ef-8e16-d517f37fa2ad/eb340ff4-296f-11ef-8e16-d517f37fa2ad.png','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_SESS_8e83509f-296b-11ef-8e16-d517f37fa2ad_OCC_453321dd-296f-11ef-8e16-d517f37fa2ad_SNAPO','eb340ff4-296f-11ef-8e16-d517f37fa2ad.png','eb340ff4-296f-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Occlusione o1\",\"occlusionType\":1}','PNG',0,'SYNCED',0,NULL,'2024-06-13 12:30:17.000','2024-06-13 10:30:17.000','2024-06-13 12:30:17.000'),('ecaf393a-2a2f-11ef-bb8b-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_3d61afe1-2986-11ef-8e16-d517f37fa2ad/ecaf393a-2a2f-11ef-bb8b-6ec2958327c0.png','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_BOSC_aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd_SCREENS','8d1feec9-2a2f-11ef-8f1c-d8242c6fa8fd.png','ecaf393a-2a2f-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"3.2 Mandibola l2 Screenshot 3\",\"title\":\"3\"}','PNG',0,'SYNCED',0,NULL,'2024-06-14 11:22:01.000','2024-06-14 09:22:01.000','2024-06-14 11:22:01.000'),('ecaf7806-2a2f-11ef-bb8b-6ec2958327c0',3,'/var/.scan4all/iris/data/2024/3/discussion_3d61afe1-2986-11ef-8e16-d517f37fa2ad/ecaf7806-2a2f-11ef-bb8b-6ec2958327c0.png','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_BOSC_aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd_SCREENS','a1d4880f-2a2f-11ef-8f1c-d8242c6fa8fd.png','ecaf7806-2a2f-11ef-bb8b-6ec2958327c0','{\"displayTitle\":\"3.2 Mandibola l2 Screenshot 4\",\"title\":\"4\"}','PNG',0,'SYNCED',0,NULL,'2024-06-14 11:22:36.000','2024-06-14 09:22:36.000','2024-06-14 11:22:36.000'),('ecd551db-2e3b-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_da1f6873-2e3a-11ef-8deb-d515ea58f6cb/occlusion_da21a6e4-2e3a-11ef-8deb-d515ea58f6cb/computedocclusion_89b4ac38-2e3b-11ef-8deb-d515ea58f6cb/ecd551db-2e3b-11ef-8deb-d515ea58f6cb.png','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_da1f6873-2e3a-11ef-8deb-d515ea58f6cb_SESS_da21a6e4-2e3a-11ef-8deb-d515ea58f6cb_OCC_89b4ac38-2e3b-11ef-8deb-d515ea58f6cb_SCREENO','ecd551db-2e3b-11ef-8deb-d515ea58f6cb.png','ecd551db-2e3b-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.2 Occlusion o1 Screenshot 2 [pc2]\",\"occlusionType\":2,\"title\":\"2\"}','PNG',0,'SYNCED',0,NULL,'2024-06-19 15:00:40.000','2024-06-19 13:00:40.000','2024-06-19 15:00:40.000'),('ee793ddb-297f-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_391a9e5e-297f-11ef-8e16-d517f37fa2ad/analyse_3921a3cd-297f-11ef-8e16-d517f37fa2ad/ee793ddb-297f-11ef-8e16-d517f37fa2ad.png','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_391a9e5e-297f-11ef-8e16-d517f37fa2ad_ANA_3921a3cd-297f-11ef-8e16-d517f37fa2ad_SCREENS','ee793ddb-297f-11ef-8e16-d517f37fa2ad.png','ee793ddb-297f-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.4 Analisi m1 Screenshot 3\",\"title\":\"3\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 14:24:51.028','2024-06-13 12:24:51.147','2024-06-13 14:24:51.191'),('ee91fd74-2e3b-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_da1f6873-2e3a-11ef-8deb-d515ea58f6cb/occlusion_da21a6e4-2e3a-11ef-8deb-d515ea58f6cb/computedocclusion_89b4ac38-2e3b-11ef-8deb-d515ea58f6cb/ee91fd74-2e3b-11ef-8deb-d515ea58f6cb.png','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_da1f6873-2e3a-11ef-8deb-d515ea58f6cb_SESS_da21a6e4-2e3a-11ef-8deb-d515ea58f6cb_OCC_89b4ac38-2e3b-11ef-8deb-d515ea58f6cb_SCREENO','ee91fd74-2e3b-11ef-8deb-d515ea58f6cb.png','ee91fd74-2e3b-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.2 Occlusion o1 Screenshot 3 [pc2]\",\"occlusionType\":2,\"title\":\"3\"}','PNG',0,'SYNCED',0,NULL,'2024-06-19 15:00:42.000','2024-06-19 13:00:42.000','2024-06-19 15:00:42.000'),('eea0c13a-2e41-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/4382037a-2735-11ef-8e16-d517f37fa1ab/session_8598ee4a-2e40-11ef-8deb-d515ea58f6cb/order_ea2350dd-2e41-11ef-8deb-d515ea58f6cb/eea0c13a-2e41-11ef-8deb-d515ea58f6cb.pdf','PATIENT_4382037a-2735-11ef-8e16-d517f37fa1ab_ACT_8598ee4a-2e40-11ef-8deb-d515ea58f6cb_PROST_ea2350dd-2e41-11ef-8deb-d515ea58f6cb_FORM','eea0c13a-2e41-11ef-8deb-d515ea58f6cb.pdf','eea0c13a-2e41-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"6.3 Crown [pc2]\",\"title\":\"Crown\"}','PDF',0,'SYNCED',0,NULL,'2024-06-19 15:43:40.000','2024-06-19 13:43:40.000','2024-06-19 15:43:40.000'),('ef02a7f3-296d-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_8e81ab09-296b-11ef-8e16-d517f37fa2ad/occlusion_8e83509f-296b-11ef-8e16-d517f37fa2ad/scan_890595a9-296d-11ef-8e16-d517f37fa2ad/ef02a7f3-296d-11ef-8e16-d517f37fa2ad.xyz','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_SESS_8e83509f-296b-11ef-8e16-d517f37fa2ad_TOSC_890595a9-296d-11ef-8e16-d517f37fa2ad_LIFI','ef02a7f3-296d-11ef-8e16-d517f37fa2ad.xyz','ef02a7f3-296d-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Mascella u3 Linea di finitura 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,'2024-06-13 12:16:59.347','2024-06-13 12:16:00.987','2024-06-13 10:16:59.349','2024-06-13 12:16:59.365'),('ef02af4a-296d-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_8e81ab09-296b-11ef-8e16-d517f37fa2ad/occlusion_8e83509f-296b-11ef-8e16-d517f37fa2ad/scan_890595a9-296d-11ef-8e16-d517f37fa2ad/ef02af4a-296d-11ef-8e16-d517f37fa2ad.bin','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_SESS_8e83509f-296b-11ef-8e16-d517f37fa2ad_TOSC_890595a9-296d-11ef-8e16-d517f37fa2ad_LIFIM','ef02af4a-296d-11ef-8e16-d517f37fa2ad.bin','ef02af4a-296d-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Mascella u3 Linea di finitura dei metadati 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,'2024-06-13 12:16:59.347','2024-06-13 12:16:00.988','2024-06-13 10:16:59.350','2024-06-13 12:16:59.366'),('ef2d44e2-2a2b-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/scan_80540c46-2a2a-11ef-8f1c-d8242c6fa8fd/ef2d44e2-2a2b-11ef-8f1c-d8242c6fa8fd.xyz','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_BOSC_80540c46-2a2a-11ef-8f1c-d8242c6fa8fd_LIFI','ef2d44e2-2a2b-11ef-8f1c-d8242c6fa8fd.xyz','d3a8591b-2a2b-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Mandibola l1 Linea di finitura 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',1,'SYNCED',0,NULL,'2024-06-14 10:56:07.165','2024-06-14 08:56:07.172','2024-06-14 10:56:07.754'),('ef2d67d4-2a2b-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/scan_80540c46-2a2a-11ef-8f1c-d8242c6fa8fd/ef2d67d4-2a2b-11ef-8f1c-d8242c6fa8fd.bin','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_BOSC_80540c46-2a2a-11ef-8f1c-d8242c6fa8fd_LIFIM','ef2d67d4-2a2b-11ef-8f1c-d8242c6fa8fd.bin','d3a86170-2a2b-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Mandibola l1 Linea di finitura dei metadati 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',1,'SYNCED',0,NULL,'2024-06-14 10:56:08.000','2024-06-14 08:56:08.000','2024-06-14 10:56:08.000'),('ef33f313-2a2b-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/computedocclusion_e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd/ef33f313-2a2b-11ef-8f1c-d8242c6fa8fd.xyz','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_OCC_e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd_LIFIO','ef33f313-2a2b-11ef-8f1c-d8242c6fa8fd.xyz','d3b1d4dc-2a2b-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Occlusione o1 Mandibola l1 Linea di finitura 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MANDIBLE_1\",\"referenceScanFullDisplayId\":\"3.2_l1\",\"referenceScanId\":\"80540c46-2a2a-11ef-8f1c-d8242c6fa8fd\",\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',1,'SYNCED',0,NULL,'2024-06-14 10:56:09.000','2024-06-14 08:56:09.000','2024-06-14 10:56:09.000'),('ef340569-2a28-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_72b8db7f-2a20-11ef-8f1c-d8242c6fa8fd/occlusion_72bbb4c0-2a20-11ef-8f1c-d8242c6fa8fd/scan_ef33e0e4-2a28-11ef-8f1c-d8242c6fa8fd/ef340569-2a28-11ef-8f1c-d8242c6fa8fd.zip','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_72b8db7f-2a20-11ef-8f1c-d8242c6fa8fd_SESS_72bbb4c0-2a20-11ef-8f1c-d8242c6fa8fd_TOSC_ef33e0e4-2a28-11ef-8f1c-d8242c6fa8fd_MODEL','ef340569-2a28-11ef-8f1c-d8242c6fa8fd.zip','ef340569-2a28-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.1 Mascella u3\",\"modelMatrix\":\"0.0231086,-0.985751,-0.166618,0,0.978657,0.056346,-0.197625,0,0.204197,-0.158495,0.966014,0,-27.1813,23.5788,-10.269,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,'2024-06-14 10:38:33.383','2024-06-14 10:34:38.719','2024-06-14 08:38:33.384','2024-06-14 10:38:33.413'),('ef341516-2a2b-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd/occlusion_8d098374-2a29-11ef-8f1c-d8242c6fa8fd/computedocclusion_e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd/ef341516-2a2b-11ef-8f1c-d8242c6fa8fd.bin','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_8d07a312-2a29-11ef-8f1c-d8242c6fa8fd_SESS_8d098374-2a29-11ef-8f1c-d8242c6fa8fd_OCC_e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd_LIFIMO','ef341516-2a2b-11ef-8f1c-d8242c6fa8fd.bin','d3b1e53c-2a2b-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.2 Occlusione o1 Mandibola l1 Linea di finitura dei metadati 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MANDIBLE_1\",\"referenceScanFullDisplayId\":\"3.2_l1\",\"referenceScanId\":\"80540c46-2a2a-11ef-8f1c-d8242c6fa8fd\",\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',1,'SYNCED',0,NULL,'2024-06-14 10:56:09.000','2024-06-14 08:56:09.000','2024-06-14 10:56:09.000'),('ef43b37e-2a28-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_72b8db7f-2a20-11ef-8f1c-d8242c6fa8fd/occlusion_72bbb4c0-2a20-11ef-8f1c-d8242c6fa8fd/scan_ef33e0e4-2a28-11ef-8f1c-d8242c6fa8fd/ef43b37e-2a28-11ef-8f1c-d8242c6fa8fd.png','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_72b8db7f-2a20-11ef-8f1c-d8242c6fa8fd_SESS_72bbb4c0-2a20-11ef-8f1c-d8242c6fa8fd_TOSC_ef33e0e4-2a28-11ef-8f1c-d8242c6fa8fd_SNAPS','ef43b37e-2a28-11ef-8f1c-d8242c6fa8fd.png','ef43b37e-2a28-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.1 Mascella u3 Snapshot\"}','PNG',0,'SYNCED',0,'2024-06-14 10:38:33.383','2024-06-14 10:34:38.822','2024-06-14 08:38:33.385','2024-06-14 10:38:33.414'),('ef9a6543-297f-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_391a9e5e-297f-11ef-8e16-d517f37fa2ad/analyse_3921a3cd-297f-11ef-8e16-d517f37fa2ad/ef9a6543-297f-11ef-8e16-d517f37fa2ad.json','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_391a9e5e-297f-11ef-8e16-d517f37fa2ad_ANA_3921a3cd-297f-11ef-8e16-d517f37fa2ad_METER','ef9a6543-297f-11ef-8e16-d517f37fa2ad.json','ef9a6543-297f-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.4 Analisi m1\"}','JSON',0,'SYNCED',0,NULL,'2024-06-13 14:24:52.923','2024-06-13 12:24:52.928','2024-06-13 14:24:52.951'),('f00455a1-2e3b-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_da1f6873-2e3a-11ef-8deb-d515ea58f6cb/occlusion_da21a6e4-2e3a-11ef-8deb-d515ea58f6cb/computedocclusion_89b4ac38-2e3b-11ef-8deb-d515ea58f6cb/f00455a1-2e3b-11ef-8deb-d515ea58f6cb.png','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_da1f6873-2e3a-11ef-8deb-d515ea58f6cb_SESS_da21a6e4-2e3a-11ef-8deb-d515ea58f6cb_OCC_89b4ac38-2e3b-11ef-8deb-d515ea58f6cb_SCREENO','f00455a1-2e3b-11ef-8deb-d515ea58f6cb.png','f00455a1-2e3b-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.2 Occlusion o1 Screenshot 4 [pc2]\",\"occlusionType\":2,\"title\":\"4\"}','PNG',0,'SYNCED',0,NULL,'2024-06-19 15:00:45.000','2024-06-19 13:00:45.000','2024-06-19 15:00:45.000'),('f0c1893d-227d-11ef-8f8c-d92a43d45d56',2,'/var/.scan4all/iris/data/2024/2/ce57500b-227c-11ef-8d76-d310d2ec2c14/session_cdf2bb52-227d-11ef-8f8c-d92a43d45d56/occlusion_cdf45240-227d-11ef-8f8c-d92a43d45d56/scan_cf823728-227d-11ef-8f8c-d92a43d45d56/f0c1893d-227d-11ef-8f8c-d92a43d45d56.zip','PATIENT_ce57500b-227c-11ef-8d76-d310d2ec2c14_ACT_cdf2bb52-227d-11ef-8f8c-d92a43d45d56_SESS_cdf45240-227d-11ef-8f8c-d92a43d45d56_TOSC_cf823728-227d-11ef-8f8c-d92a43d45d56_MODEL','f0c1893d-227d-11ef-8f8c-d92a43d45d56.zip','f0c1893d-227d-11ef-8f8c-d92a43d45d56','{\"displayTitle\":\"3.1 Maxillaire u1 [pc1]\",\"modelMatrix\":\"0.982594,0.117836,-0.143611,0,-0.113332,0.992784,0.0391828,0,0.147192,-0.0222251,0.988858,0,-0.00298958,1.98864,-12.9722,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 16:23:03.000','2024-06-04 14:23:03.000','2024-06-04 16:23:03.000'),('f0c1a284-227d-11ef-8f8c-d92a43d45d56',2,'/var/.scan4all/iris/data/2024/2/ce57500b-227c-11ef-8d76-d310d2ec2c14/session_cdf2bb52-227d-11ef-8f8c-d92a43d45d56/occlusion_cdf45240-227d-11ef-8f8c-d92a43d45d56/scan_cf823728-227d-11ef-8f8c-d92a43d45d56/f0c1a284-227d-11ef-8f8c-d92a43d45d56.png','PATIENT_ce57500b-227c-11ef-8d76-d310d2ec2c14_ACT_cdf2bb52-227d-11ef-8f8c-d92a43d45d56_SESS_cdf45240-227d-11ef-8f8c-d92a43d45d56_TOSC_cf823728-227d-11ef-8f8c-d92a43d45d56_SNAPS','f0c1a284-227d-11ef-8f8c-d92a43d45d56.png','f0c1a284-227d-11ef-8f8c-d92a43d45d56','{\"displayTitle\":\"3.1 Maxillaire u1 Snapshot [pc1]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 16:23:03.000','2024-06-04 14:23:03.000','2024-06-04 16:23:03.000'),('f11a7ce4-289c-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/f373c86a-2899-11ef-8e16-d517f37fa2ad/session_0d1289f0-289a-11ef-8e16-d517f37fa2ad/occlusion_0d14f12a-289a-11ef-8e16-d517f37fa2ad/computedocclusion_a03e3cb8-289c-11ef-8e16-d517f37fa2ad/f11a7ce4-289c-11ef-8e16-d517f37fa2ad.zip','PATIENT_f373c86a-2899-11ef-8e16-d517f37fa2ad_ACT_0d1289f0-289a-11ef-8e16-d517f37fa2ad_SESS_0d14f12a-289a-11ef-8e16-d517f37fa2ad_OCC_a03e3cb8-289c-11ef-8e16-d517f37fa2ad_TO1','f11a7ce4-289c-11ef-8e16-d517f37fa2ad.zip','f11a7ce4-289c-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Occlusion o1 Maxillaire u2\",\"modelMatrix\":\"0.913022,-0.367317,0.177397,0,0.407911,0.82216,-0.397065,0,-1.75828e-09,0.434891,0.900483,0,-7.36214,-2.38053,-21.4033,1\",\"occlusionMatrix\":\"0.750969,-0.657407,0.0622299,0,0.642014,0.705214,-0.300171,0,0.154523,0.265506,0.951858,0,-8.83659,2.89551,-21.0498,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.1_u2\",\"referenceScanId\":\"5781b86f-289a-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-12 11:20:01.000','2024-06-12 09:20:01.000','2024-06-12 11:20:01.000'),('f125c583-289c-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/f373c86a-2899-11ef-8e16-d517f37fa2ad/session_0d1289f0-289a-11ef-8e16-d517f37fa2ad/occlusion_0d14f12a-289a-11ef-8e16-d517f37fa2ad/computedocclusion_a03e3cb8-289c-11ef-8e16-d517f37fa2ad/f125c583-289c-11ef-8e16-d517f37fa2ad.zip','PATIENT_f373c86a-2899-11ef-8e16-d517f37fa2ad_ACT_0d1289f0-289a-11ef-8e16-d517f37fa2ad_SESS_0d14f12a-289a-11ef-8e16-d517f37fa2ad_OCC_a03e3cb8-289c-11ef-8e16-d517f37fa2ad_BO1','f125c583-289c-11ef-8e16-d517f37fa2ad.zip','f125c583-289c-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Occlusion o1 Mandibule l1\",\"modelMatrix\":\"0.9689,-0.0369733,-0.244677,0,0.0845235,0.978754,0.186805,0,0.232572,-0.201676,0.951439,0,-11.9484,3.92788,-10.1322,1\",\"occlusionMatrix\":\"0.981774,-0.137627,-0.129927,0,0.119103,0.982877,-0.140424,0,0.148123,0.122529,0.98153,0,-8.65865,3.43796,-12.335,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.1_l1\",\"referenceScanId\":\"a4a0d8da-289a-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-12 11:20:02.000','2024-06-12 09:20:02.000','2024-06-12 11:20:02.000'),('f17e0ce7-2e3b-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_da1f6873-2e3a-11ef-8deb-d515ea58f6cb/occlusion_da21a6e4-2e3a-11ef-8deb-d515ea58f6cb/computedocclusion_89b4ac38-2e3b-11ef-8deb-d515ea58f6cb/f17e0ce7-2e3b-11ef-8deb-d515ea58f6cb.png','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_da1f6873-2e3a-11ef-8deb-d515ea58f6cb_SESS_da21a6e4-2e3a-11ef-8deb-d515ea58f6cb_OCC_89b4ac38-2e3b-11ef-8deb-d515ea58f6cb_SCREENO','f17e0ce7-2e3b-11ef-8deb-d515ea58f6cb.png','f17e0ce7-2e3b-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.2 Occlusion o1 Screenshot 5 [pc2]\",\"occlusionType\":2,\"title\":\"5\"}','PNG',0,'SYNCED',0,NULL,'2024-06-19 15:00:47.000','2024-06-19 13:00:47.000','2024-06-19 15:00:47.000'),('f1901fb9-289c-11ef-8e16-d517f37fa2ad',5,'/var/.scan4all/iris/data/2024/5/f373c86a-2899-11ef-8e16-d517f37fa2ad/session_0d1289f0-289a-11ef-8e16-d517f37fa2ad/occlusion_0d14f12a-289a-11ef-8e16-d517f37fa2ad/computedocclusion_a03e3cb8-289c-11ef-8e16-d517f37fa2ad/f1901fb9-289c-11ef-8e16-d517f37fa2ad.png','PATIENT_f373c86a-2899-11ef-8e16-d517f37fa2ad_ACT_0d1289f0-289a-11ef-8e16-d517f37fa2ad_SESS_0d14f12a-289a-11ef-8e16-d517f37fa2ad_OCC_a03e3cb8-289c-11ef-8e16-d517f37fa2ad_SNAPO','f1901fb9-289c-11ef-8e16-d517f37fa2ad.png','f1901fb9-289c-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Occlusion o1\",\"occlusionType\":1}','PNG',0,'SYNCED',0,NULL,'2024-06-12 11:20:02.000','2024-06-12 09:20:02.000','2024-06-12 11:20:02.000'),('f282de54-296a-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_4704a021-2963-11ef-8e16-d517f37fa2ad/occlusion_4706df6f-2963-11ef-8e16-d517f37fa2ad/scan_47f95341-2963-11ef-8e16-d517f37fa2ad/f282de54-296a-11ef-8e16-d517f37fa2ad.ply','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_4704a021-2963-11ef-8e16-d517f37fa2ad_SESS_4706df6f-2963-11ef-8e16-d517f37fa2ad_TOSC_47f95341-2963-11ef-8e16-d517f37fa2ad_SEG','f282de54-296a-11ef-8e16-d517f37fa2ad.ply','b08fc982-296a-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.1 Mascella u1 Segmentazione\"}','PLY',1,'SYNCED',0,NULL,'2024-06-13 11:54:38.371','2024-06-13 09:54:38.459','2024-06-13 11:54:38.676'),('f29b2b38-298a-11ef-8e16-d517f37fa2ad',2,'/var/.scan4all/iris/data/2024/2/5062e053-298a-11ef-8e16-d517f37fa2ad/session_a1ebbaf4-298a-11ef-8e16-d517f37fa2ad/occlusion_a1ecf57e-298a-11ef-8e16-d517f37fa2ad/scan_d2eec825-298a-11ef-8e16-d517f37fa2ad/f29b2b38-298a-11ef-8e16-d517f37fa2ad.zip','PATIENT_5062e053-298a-11ef-8e16-d517f37fa2ad_ACT_a1ebbaf4-298a-11ef-8e16-d517f37fa2ad_SESS_a1ecf57e-298a-11ef-8e16-d517f37fa2ad_TOSC_d2eec825-298a-11ef-8e16-d517f37fa2ad_MODEL','f29b2b38-298a-11ef-8e16-d517f37fa2ad.zip','f29b2b38-298a-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"14.2 Maxillaire u1 [pc2]\",\"modelMatrix\":\"-0.782411,-0.58409,-0.216035,0,0.489244,-0.791133,0.367081,0,-0.385321,0.181514,0.904754,0,6.77223,-0.510493,-10.8625,1\",\"scanBodies\":[{\"position\":\"6.39155,6,0,0,0.701041,0,6,0,9.72581,0,0,6,1,0,0,0\",\"reference\":\"gfhgfdhg\",\"tid\":16}]}','ZIP',0,'CREATED',0,NULL,'2024-06-13 15:43:42.425','2024-06-13 13:44:13.339','2024-06-13 15:44:48.808'),('f29b3e20-298a-11ef-8e16-d517f37fa2ad',2,'/var/.scan4all/iris/data/2024/2/5062e053-298a-11ef-8e16-d517f37fa2ad/session_a1ebbaf4-298a-11ef-8e16-d517f37fa2ad/occlusion_a1ecf57e-298a-11ef-8e16-d517f37fa2ad/scan_d2eec825-298a-11ef-8e16-d517f37fa2ad/f29b3e20-298a-11ef-8e16-d517f37fa2ad.png','PATIENT_5062e053-298a-11ef-8e16-d517f37fa2ad_ACT_a1ebbaf4-298a-11ef-8e16-d517f37fa2ad_SESS_a1ecf57e-298a-11ef-8e16-d517f37fa2ad_TOSC_d2eec825-298a-11ef-8e16-d517f37fa2ad_SNAPS','f29b3e20-298a-11ef-8e16-d517f37fa2ad.png','f29b3e20-298a-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"14.2 Maxillaire u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 15:43:42.426','2024-06-13 13:43:42.732','2024-06-13 15:43:54.836'),('f2ccaed8-2e0d-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/4382037a-2735-11ef-8e16-d517f37fa1ab/session_dd7db4ad-2e0d-11ef-8deb-d515ea58f6cb/analyse_e411249a-2e0d-11ef-8deb-d515ea58f6cb/f2ccaed8-2e0d-11ef-8deb-d515ea58f6cb.json','PATIENT_4382037a-2735-11ef-8e16-d517f37fa1ab_ACT_dd7db4ad-2e0d-11ef-8deb-d515ea58f6cb_ANA_e411249a-2e0d-11ef-8deb-d515ea58f6cb_TRANS','f2ccaed8-2e0d-11ef-8deb-d515ea58f6cb.json','f2ccaed8-2e0d-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"6.2 Analyse c2 [pc2]\"}','JSON',0,'SYNCED',0,NULL,'2024-06-19 09:31:32.117','2024-06-19 07:31:32.119','2024-06-19 12:49:24.516'),('f31f7ba6-2e0d-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/4382037a-2735-11ef-8e16-d517f37fa1ab/session_dd7db4ad-2e0d-11ef-8deb-d515ea58f6cb/analyse_e411249a-2e0d-11ef-8deb-d515ea58f6cb/f31f7ba6-2e0d-11ef-8deb-d515ea58f6cb.png','PATIENT_4382037a-2735-11ef-8e16-d517f37fa1ab_ACT_dd7db4ad-2e0d-11ef-8deb-d515ea58f6cb_ANA_e411249a-2e0d-11ef-8deb-d515ea58f6cb_SNAPS','f31f7ba6-2e0d-11ef-8deb-d515ea58f6cb.png','f31f7ba6-2e0d-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"6.2 Analyse c2 [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-19 09:31:32.660','2024-06-19 07:31:32.661','2024-06-19 12:49:24.754'),('f3576589-2268-11ef-8f1f-d8242c71b430',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_757ed4bc-2266-11ef-8f1f-d8242c71b430/occlusion_75806ee1-2266-11ef-8f1f-d8242c71b430/computedocclusion_0b16efeb-2268-11ef-8f1f-d8242c71b430/f3576589-2268-11ef-8f1f-d8242c71b430.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_OCC_0b16efeb-2268-11ef-8f1f-d8242c71b430_TO1','f3576589-2268-11ef-8f1f-d8242c71b430.zip','f3576589-2268-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.2 Occlusion o1 Maxillaire u1\",\"modelMatrix\":\"0.970663,-0.222677,0.0907083,0,0.239614,0.864538,-0.441769,0,0.019951,0.450543,0.892532,0,-17.9206,-4.24346,-12.6568,1\",\"occlusionMatrix\":\"0.973794,0.000432278,-0.227448,0,0.222023,0.215288,0.950979,0,0.0493782,-0.976552,0.20955,0,-19.0028,7.7418,-0.229366,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.2_u1\",\"referenceScanId\":\"09768650-2267-11ef-8f1f-d8242c71b430\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 13:52:46.000','2024-06-04 11:52:46.000','2024-06-04 13:52:46.000'),('f379f4d9-2268-11ef-8f1f-d8242c71b430',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_757ed4bc-2266-11ef-8f1f-d8242c71b430/occlusion_75806ee1-2266-11ef-8f1f-d8242c71b430/computedocclusion_0b16efeb-2268-11ef-8f1f-d8242c71b430/f379f4d9-2268-11ef-8f1f-d8242c71b430.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_OCC_0b16efeb-2268-11ef-8f1f-d8242c71b430_BO1','f379f4d9-2268-11ef-8f1f-d8242c71b430.zip','f379f4d9-2268-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.2 Occlusion o1 Mandibule l1\",\"modelMatrix\":\"0.988582,0.0775562,-0.129192,0,-0.0638786,0.992221,0.106846,0,0.136474,-0.0973735,0.985846,0,-17.8094,0.329057,-12.0411,1\",\"occlusionMatrix\":\"0.975316,-0.181035,-0.126528,0,-0.169666,-0.247306,-0.953975,0,0.14141,0.951881,-0.271914,0,-17.0394,-5.36341,4.91459,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.2_l1\",\"referenceScanId\":\"b4da925f-2267-11ef-8f1f-d8242c71b430\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 13:52:47.000','2024-06-04 11:52:47.000','2024-06-04 13:52:47.000'),('f4024e3a-2268-11ef-8f1f-d8242c71b430',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_757ed4bc-2266-11ef-8f1f-d8242c71b430/occlusion_75806ee1-2266-11ef-8f1f-d8242c71b430/computedocclusion_0b16efeb-2268-11ef-8f1f-d8242c71b430/f4024e3a-2268-11ef-8f1f-d8242c71b430.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_OCC_0b16efeb-2268-11ef-8f1f-d8242c71b430_SNAPO','f4024e3a-2268-11ef-8f1f-d8242c71b430.png','f4024e3a-2268-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.2 Occlusion o1\",\"occlusionType\":1}','PNG',0,'SYNCED',0,NULL,'2024-06-04 13:52:48.000','2024-06-04 11:52:48.000','2024-06-04 13:52:48.000'),('f4f2c020-2e3b-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_da1f6873-2e3a-11ef-8deb-d515ea58f6cb/occlusion_da21a6e4-2e3a-11ef-8deb-d515ea58f6cb/computedocclusion_89b4ac38-2e3b-11ef-8deb-d515ea58f6cb/f4f2c020-2e3b-11ef-8deb-d515ea58f6cb.png','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_da1f6873-2e3a-11ef-8deb-d515ea58f6cb_SESS_da21a6e4-2e3a-11ef-8deb-d515ea58f6cb_OCC_89b4ac38-2e3b-11ef-8deb-d515ea58f6cb_SCREENO','f4f2c020-2e3b-11ef-8deb-d515ea58f6cb.png','f4f2c020-2e3b-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.2 Occlusion o1 Screenshot 6 [pc2]\",\"occlusionType\":2,\"title\":\"6\"}','PNG',0,'SYNCED',0,NULL,'2024-06-19 15:00:53.000','2024-06-19 13:00:53.000','2024-06-19 15:00:53.000'),('f51d71ce-227c-11ef-8d76-d310d2ec2c14',2,'/var/.scan4all/iris/data/2024/2/ce57500b-227c-11ef-8d76-d310d2ec2c14/session_da355fe4-227c-11ef-8d76-d310d2ec2c14/occlusion_da37d213-227c-11ef-8d76-d310d2ec2c14/scan_e0f66733-227c-11ef-8d76-d310d2ec2c14/f51d71ce-227c-11ef-8d76-d310d2ec2c14.zip','PATIENT_ce57500b-227c-11ef-8d76-d310d2ec2c14_ACT_da355fe4-227c-11ef-8d76-d310d2ec2c14_SESS_da37d213-227c-11ef-8d76-d310d2ec2c14_TOSC_e0f66733-227c-11ef-8d76-d310d2ec2c14_MODEL','f51d71ce-227c-11ef-8d76-d310d2ec2c14.zip','f51d71ce-227c-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"3.1 Maxillaire u1 [pc2]\",\"modelMatrix\":\"-0.590223,0.739255,-0.324251,0,-0.781697,-0.423166,0.458127,0,0.201461,0.523863,0.827636,0,-1.54469,-10.1967,-10.1611,1\",\"scanBodies\":[{\"position\":\"4.62786,6,0,0,-4.60181,0,6,0,8.70585,0,0,6,1,0,0,0\",\"reference\":\"K30PSCANPLG\",\"tid\":14}]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 16:16:00.000','2024-06-19 07:34:40.081','2024-06-19 12:49:09.415'),('f51d8554-227c-11ef-8d76-d310d2ec2c14',2,'/var/.scan4all/iris/data/2024/2/ce57500b-227c-11ef-8d76-d310d2ec2c14/session_da355fe4-227c-11ef-8d76-d310d2ec2c14/occlusion_da37d213-227c-11ef-8d76-d310d2ec2c14/scan_e0f66733-227c-11ef-8d76-d310d2ec2c14/f51d8554-227c-11ef-8d76-d310d2ec2c14.png','PATIENT_ce57500b-227c-11ef-8d76-d310d2ec2c14_ACT_da355fe4-227c-11ef-8d76-d310d2ec2c14_SESS_da37d213-227c-11ef-8d76-d310d2ec2c14_TOSC_e0f66733-227c-11ef-8d76-d310d2ec2c14_SNAPS','f51d8554-227c-11ef-8d76-d310d2ec2c14.png','f51d8554-227c-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"3.1 Maxillaire u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 16:16:00.000','2024-06-04 14:16:00.000','2024-06-04 16:16:00.000'),('f6bd91e1-2e0e-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/ce57500b-227c-11ef-8d76-d310d2ec2c14/session_da355fe4-227c-11ef-8d76-d310d2ec2c14/occlusion_da37d213-227c-11ef-8d76-d310d2ec2c14/scan_e631c430-2e0e-11ef-8deb-d515ea58f6cb/f6bd91e1-2e0e-11ef-8deb-d515ea58f6cb.zip','PATIENT_ce57500b-227c-11ef-8d76-d310d2ec2c14_ACT_da355fe4-227c-11ef-8d76-d310d2ec2c14_SESS_da37d213-227c-11ef-8d76-d310d2ec2c14_TOSC_e631c430-2e0e-11ef-8deb-d515ea58f6cb_MODEL','f6bd91e1-2e0e-11ef-8deb-d515ea58f6cb.zip','f6bd91e1-2e0e-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"3.1 Maxillaire u2 [pc2]\",\"modelMatrix\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"scanBodies\":[{\"position\":\"10.4552,6,0,0,3.27905,0,6,0,12.8519,0,0,6,1,0,0,0\",\"reference\":\"K30PSCANPLG\",\"tid\":16}]}','ZIP',0,'SYNCED',0,NULL,'2024-06-19 09:38:48.226','2024-06-19 07:40:03.927','2024-06-19 12:49:12.342'),('f6bdc013-2e0e-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/ce57500b-227c-11ef-8d76-d310d2ec2c14/session_da355fe4-227c-11ef-8d76-d310d2ec2c14/occlusion_da37d213-227c-11ef-8d76-d310d2ec2c14/scan_e631c430-2e0e-11ef-8deb-d515ea58f6cb/f6bdc013-2e0e-11ef-8deb-d515ea58f6cb.png','PATIENT_ce57500b-227c-11ef-8d76-d310d2ec2c14_ACT_da355fe4-227c-11ef-8d76-d310d2ec2c14_SESS_da37d213-227c-11ef-8d76-d310d2ec2c14_TOSC_e631c430-2e0e-11ef-8deb-d515ea58f6cb_SNAPS','f6bdc013-2e0e-11ef-8deb-d515ea58f6cb.png','f6bdc013-2e0e-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"3.1 Maxillaire u2 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-19 09:38:48.227','2024-06-19 07:38:48.350','2024-06-19 12:49:14.748'),('f6cef120-2987-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/0fedc3b4-2961-11ef-8e16-d517f37fa2ad/session_4ba13230-2987-11ef-8e16-d517f37fa2ad/occlusion_4ba370c1-2987-11ef-8e16-d517f37fa2ad/scan_c90eb287-2987-11ef-8e16-d517f37fa2ad/f6cef120-2987-11ef-8e16-d517f37fa2ad.zip','PATIENT_0fedc3b4-2961-11ef-8e16-d517f37fa2ad_ACT_4ba13230-2987-11ef-8e16-d517f37fa2ad_SESS_4ba370c1-2987-11ef-8e16-d517f37fa2ad_RISC_c90eb287-2987-11ef-8e16-d517f37fa2ad_MODEL','f6cef120-2987-11ef-8e16-d517f37fa2ad.zip','f6cef120-2987-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"4.1 Morso destro br1\",\"modelMatrix\":\"0.998018,0.0610084,-0.00592279,0,-0.0629588,0.994415,-0.0861418,0,-0.000253759,0.0861361,0.996266,0,-4.55179,-2.64985,-10.8505,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 15:22:20.985','2024-06-13 13:22:21.437','2024-06-13 15:22:23.584'),('f6cf020a-2987-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/0fedc3b4-2961-11ef-8e16-d517f37fa2ad/session_4ba13230-2987-11ef-8e16-d517f37fa2ad/occlusion_4ba370c1-2987-11ef-8e16-d517f37fa2ad/scan_c90eb287-2987-11ef-8e16-d517f37fa2ad/f6cf020a-2987-11ef-8e16-d517f37fa2ad.png','PATIENT_0fedc3b4-2961-11ef-8e16-d517f37fa2ad_ACT_4ba13230-2987-11ef-8e16-d517f37fa2ad_SESS_4ba370c1-2987-11ef-8e16-d517f37fa2ad_RISC_c90eb287-2987-11ef-8e16-d517f37fa2ad_SNAPS','f6cf020a-2987-11ef-8e16-d517f37fa2ad.png','f6cf020a-2987-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"4.1 Morso destro br1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 15:22:20.986','2024-06-13 13:22:21.437','2024-06-13 15:22:24.688'),('f80bcc6d-2e3d-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_af857ecd-27f1-11ef-8e37-d519fa9d22d2/occlusion_af864e86-27f1-11ef-8e37-d519fa9d22d2/scan_d891acce-2e3d-11ef-8deb-d515ea58f6cb/f80bcc6d-2e3d-11ef-8deb-d515ea58f6cb.zip','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_af857ecd-27f1-11ef-8e37-d519fa9d22d2_SESS_af864e86-27f1-11ef-8e37-d519fa9d22d2_LESC_d891acce-2e3d-11ef-8deb-d515ea58f6cb_MODEL','f80bcc6d-2e3d-11ef-8deb-d515ea58f6cb.zip','f80bcc6d-2e3d-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.4 Left bite bl1 [pc2]\",\"modelMatrix\":\"-0.991464,0.12363,0.0113947,0,-0.126424,-0.97222,0.201106,0,0.0329094,0.198878,0.979514,0,5.5145,-6.16834,-10.0691,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-19 15:15:16.762','2024-06-19 13:19:00.438','2024-06-19 15:19:04.268'),('f80bf097-2e3d-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_af857ecd-27f1-11ef-8e37-d519fa9d22d2/occlusion_af864e86-27f1-11ef-8e37-d519fa9d22d2/scan_d891acce-2e3d-11ef-8deb-d515ea58f6cb/f80bf097-2e3d-11ef-8deb-d515ea58f6cb.png','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_af857ecd-27f1-11ef-8e37-d519fa9d22d2_SESS_af864e86-27f1-11ef-8e37-d519fa9d22d2_LESC_d891acce-2e3d-11ef-8deb-d515ea58f6cb_SNAPS','f80bf097-2e3d-11ef-8deb-d515ea58f6cb.png','f80bf097-2e3d-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.4 Left bite bl1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-19 15:15:16.763','2024-06-19 13:19:00.439','2024-06-19 15:19:05.886'),('f9c06fb9-2e4d-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/115617bc-2e4b-11ef-8deb-d515ea58f6cb/session_ddffc633-2e4d-11ef-8deb-d515ea58f6cb/order_f1e7f15b-2e4d-11ef-8deb-d515ea58f6cb/f9c06fb9-2e4d-11ef-8deb-d515ea58f6cb.pdf','PATIENT_115617bc-2e4b-11ef-8deb-d515ea58f6cb_ACT_ddffc633-2e4d-11ef-8deb-d515ea58f6cb_PROST_f1e7f15b-2e4d-11ef-8deb-d515ea58f6cb_FORM','f9c06fb9-2e4d-11ef-8deb-d515ea58f6cb.pdf','f9c06fb9-2e4d-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"17.3 Other [pc2]\",\"title\":\"Other\"}','PDF',0,'SYNCED',0,NULL,'2024-06-19 17:09:53.000','2024-06-19 15:09:53.000','2024-06-19 17:09:53.000'),('fafc415d-23e7-11ef-8dde-d415e84cc4f5',3,'/var/.scan4all/iris/data/2024/3/907398e3-23e7-11ef-8dde-d415e84cc4f5/session_96aedcf6-23e7-11ef-8dde-d415e84cc4f5/order_96b5001d-23e7-11ef-8dde-d415e84cc4f5/fafc415d-23e7-11ef-8dde-d415e84cc4f5.pdf','PATIENT_907398e3-23e7-11ef-8dde-d415e84cc4f5_ACT_96aedcf6-23e7-11ef-8dde-d415e84cc4f5_PROST_96b5001d-23e7-11ef-8dde-d415e84cc4f5_FORM','fafc415d-23e7-11ef-8dde-d415e84cc4f5.pdf','fafc415d-23e7-11ef-8dde-d415e84cc4f5','{\"displayTitle\":\"2.1 Couronne [pc1]\",\"title\":\"Couronne\"}','PDF',0,'SYNCED',0,NULL,'2024-06-06 11:34:32.702','2024-06-06 09:34:33.408','2024-06-06 11:34:33.524'),('fb017cf6-2987-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/0fedc3b4-2961-11ef-8e16-d517f37fa2ad/session_4ba13230-2987-11ef-8e16-d517f37fa2ad/occlusion_4ba370c1-2987-11ef-8e16-d517f37fa2ad/computedocclusion_c472f797-2987-11ef-8e16-d517f37fa2ad/fb017cf6-2987-11ef-8e16-d517f37fa2ad.zip','PATIENT_0fedc3b4-2961-11ef-8e16-d517f37fa2ad_ACT_4ba13230-2987-11ef-8e16-d517f37fa2ad_SESS_4ba370c1-2987-11ef-8e16-d517f37fa2ad_OCC_c472f797-2987-11ef-8e16-d517f37fa2ad_TO1','fb017cf6-2987-11ef-8e16-d517f37fa2ad.zip','fb017cf6-2987-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"4.1 Occlusione o1 Mascella u1\",\"modelMatrix\":\"0.996297,-0.00872078,0.0855323,0,0.0514771,0.85732,-0.512204,0,-0.0688617,0.51471,0.854594,0,-11.595,-8.11386,-10.2324,1\",\"occlusionMatrix\":\"0.942645,0.0619705,-0.327991,0,0.296504,0.295863,0.908044,0,0.153313,-0.95322,0.260516,0,-15.344,5.98042,-0.915341,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"4.1_u1\",\"referenceScanId\":\"55568e89-2987-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 15:22:31.000','2024-06-13 13:22:31.000','2024-06-13 15:22:31.000'),('fb07e2bb-2970-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/9cd27370-2960-11ef-8e16-d517f37fa2ad/session_8e81ab09-296b-11ef-8e16-d517f37fa2ad/order_8e871a0f-296b-11ef-8e16-d517f37fa2ad/fb07e2bb-2970-11ef-8e16-d517f37fa2ad.pdf','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_PROST_8e871a0f-296b-11ef-8e16-d517f37fa2ad_FORM','fb07e2bb-2970-11ef-8e16-d517f37fa2ad.pdf','fb07e2bb-2970-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"1.1 Corona\",\"title\":\"Corona\"}','PDF',0,'SYNCED',0,NULL,'2024-06-13 12:37:51.000','2024-06-13 10:37:51.000','2024-06-13 12:37:51.000'),('fb21655b-2987-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/0fedc3b4-2961-11ef-8e16-d517f37fa2ad/session_4ba13230-2987-11ef-8e16-d517f37fa2ad/occlusion_4ba370c1-2987-11ef-8e16-d517f37fa2ad/computedocclusion_c472f797-2987-11ef-8e16-d517f37fa2ad/fb21655b-2987-11ef-8e16-d517f37fa2ad.zip','PATIENT_0fedc3b4-2961-11ef-8e16-d517f37fa2ad_ACT_4ba13230-2987-11ef-8e16-d517f37fa2ad_SESS_4ba370c1-2987-11ef-8e16-d517f37fa2ad_OCC_c472f797-2987-11ef-8e16-d517f37fa2ad_BO1','fb21655b-2987-11ef-8e16-d517f37fa2ad.zip','fb21655b-2987-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"4.1 Occlusione o1 Mandibola l1\",\"modelMatrix\":\"-0.967691,-0.234243,0.0932966,0,0.250368,-0.936471,0.24564,0,0.0298301,0.261062,0.964861,0,13.0365,-2.10523,-13.3116,1\",\"occlusionMatrix\":\"0.86452,-0.0216507,-0.502146,0,-0.502229,0.00196047,-0.864737,0,0.0197071,0.999768,-0.00917748,0,-11.7284,-8.59853,4.83777,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"4.1_l1\",\"referenceScanId\":\"879dec53-2987-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 15:22:32.000','2024-06-13 13:22:32.000','2024-06-13 15:22:32.000'),('fb4d7f91-2e3d-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_af857ecd-27f1-11ef-8e37-d519fa9d22d2/occlusion_af864e86-27f1-11ef-8e37-d519fa9d22d2/computedocclusion_d7d76f34-2e3d-11ef-8deb-d515ea58f6cb/fb4d7f91-2e3d-11ef-8deb-d515ea58f6cb.zip','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_af857ecd-27f1-11ef-8e37-d519fa9d22d2_SESS_af864e86-27f1-11ef-8e37-d519fa9d22d2_OCC_d7d76f34-2e3d-11ef-8deb-d515ea58f6cb_TO1','fb4d7f91-2e3d-11ef-8deb-d515ea58f6cb.zip','fb4d7f91-2e3d-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.4 Occlusion o1 Maxilla u1 [pc2]\",\"modelMatrix\":\"0.961723,0.241617,-0.129268,0,-0.251677,0.965425,-0.067927,0,0.108386,0.0978608,0.98928,0,-11.6212,0.502501,-11.7801,1\",\"occlusionMatrix\":\"-0.967638,0.113586,-0.225367,0,0.247522,0.252877,-0.935301,0,-0.0492472,-0.960817,-0.272807,0,12.7073,8.79973,2.07084,1\",\"occlusionType\":2,\"referenceScanFullDisplayId\":\"14.1_u1\",\"referenceScanId\":\"e16361f9-2e3c-11ef-8deb-d515ea58f6cb\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-19 15:15:22.226','2024-06-19 13:19:00.559','2024-06-19 15:19:08.834'),('fb71a480-2e3d-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_af857ecd-27f1-11ef-8e37-d519fa9d22d2/occlusion_af864e86-27f1-11ef-8e37-d519fa9d22d2/computedocclusion_d7d76f34-2e3d-11ef-8deb-d515ea58f6cb/fb71a480-2e3d-11ef-8deb-d515ea58f6cb.zip','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_af857ecd-27f1-11ef-8e37-d519fa9d22d2_SESS_af864e86-27f1-11ef-8e37-d519fa9d22d2_OCC_d7d76f34-2e3d-11ef-8deb-d515ea58f6cb_BO1','fb71a480-2e3d-11ef-8deb-d515ea58f6cb.zip','fb71a480-2e3d-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.4 Occlusion o1 Mandible l1 [pc2]\",\"modelMatrix\":\"0.974595,-0.188287,-0.121294,0,0.179816,0.980646,-0.0774588,0,0.133531,0.0536805,0.98959,0,-17.8383,2.10993,-10.7575,1\",\"occlusionMatrix\":\"-0.982526,-0.098094,-0.158253,0,-0.158764,-0.00262189,0.98732,0,-0.0972665,0.995178,-0.0129932,0,15.4049,-6.98259,1.86049,1\",\"occlusionType\":2,\"referenceScanFullDisplayId\":\"14.1_l1\",\"referenceScanId\":\"3447447c-2e3d-11ef-8deb-d515ea58f6cb\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-19 15:15:22.463','2024-06-19 13:19:00.559','2024-06-19 15:19:10.997'),('fbb6d74e-2987-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/0fedc3b4-2961-11ef-8e16-d517f37fa2ad/session_4ba13230-2987-11ef-8e16-d517f37fa2ad/occlusion_4ba370c1-2987-11ef-8e16-d517f37fa2ad/computedocclusion_c472f797-2987-11ef-8e16-d517f37fa2ad/fbb6d74e-2987-11ef-8e16-d517f37fa2ad.png','PATIENT_0fedc3b4-2961-11ef-8e16-d517f37fa2ad_ACT_4ba13230-2987-11ef-8e16-d517f37fa2ad_SESS_4ba370c1-2987-11ef-8e16-d517f37fa2ad_OCC_c472f797-2987-11ef-8e16-d517f37fa2ad_SNAPO','fbb6d74e-2987-11ef-8e16-d517f37fa2ad.png','fbb6d74e-2987-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"4.1 Occlusione o1\",\"occlusionType\":1}','PNG',0,'SYNCED',0,NULL,'2024-06-13 15:22:32.000','2024-06-13 13:22:32.000','2024-06-13 15:22:32.000'),('fc02156d-2e3d-11ef-8deb-d515ea58f6cb',2,'/var/.scan4all/iris/data/2024/2/309e7124-2e35-11ef-8deb-d515ea58f6cb/session_af857ecd-27f1-11ef-8e37-d519fa9d22d2/occlusion_af864e86-27f1-11ef-8e37-d519fa9d22d2/computedocclusion_d7d76f34-2e3d-11ef-8deb-d515ea58f6cb/fc02156d-2e3d-11ef-8deb-d515ea58f6cb.png','PATIENT_309e7124-2e35-11ef-8deb-d515ea58f6cb_ACT_af857ecd-27f1-11ef-8e37-d519fa9d22d2_SESS_af864e86-27f1-11ef-8e37-d519fa9d22d2_OCC_d7d76f34-2e3d-11ef-8deb-d515ea58f6cb_SNAPO','fc02156d-2e3d-11ef-8deb-d515ea58f6cb.png','fc02156d-2e3d-11ef-8deb-d515ea58f6cb','{\"displayTitle\":\"16.4 Occlusion o1 [pc2]\",\"occlusionType\":2}','PNG',0,'SYNCED',0,NULL,'2024-06-19 15:15:23.409','2024-06-19 13:19:00.560','2024-06-19 15:19:12.905'),('fc8f1969-2271-11ef-8d76-d310d2ec2c14',2,'/var/.scan4all/iris/data/2024/2/a1ace9b5-2271-11ef-8d76-d310d2ec2c14/session_afa6cb0d-2271-11ef-8d76-d310d2ec2c14/occlusion_afa8fad1-2271-11ef-8d76-d310d2ec2c14/scan_b17c4dcd-2271-11ef-8d76-d310d2ec2c14/fc8f1969-2271-11ef-8d76-d310d2ec2c14.zip','PATIENT_a1ace9b5-2271-11ef-8d76-d310d2ec2c14_ACT_afa6cb0d-2271-11ef-8d76-d310d2ec2c14_SESS_afa8fad1-2271-11ef-8d76-d310d2ec2c14_TOSC_b17c4dcd-2271-11ef-8d76-d310d2ec2c14_MODEL','fc8f1969-2271-11ef-8d76-d310d2ec2c14.zip','fc8f1969-2271-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"2.1 Maxillaire u1 [pc2]\",\"modelMatrix\":\"-0.666484,0.745051,-0.02644,0,-0.736592,-0.663561,-0.130839,0,-0.115026,-0.0677265,0.991051,0,13.9201,-2.00427,-11.44,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 14:57:27.000','2024-06-04 12:57:27.000','2024-06-04 14:57:27.000'),('fc8f31e9-2271-11ef-8d76-d310d2ec2c14',2,'/var/.scan4all/iris/data/2024/2/a1ace9b5-2271-11ef-8d76-d310d2ec2c14/session_afa6cb0d-2271-11ef-8d76-d310d2ec2c14/occlusion_afa8fad1-2271-11ef-8d76-d310d2ec2c14/scan_b17c4dcd-2271-11ef-8d76-d310d2ec2c14/fc8f31e9-2271-11ef-8d76-d310d2ec2c14.png','PATIENT_a1ace9b5-2271-11ef-8d76-d310d2ec2c14_ACT_afa6cb0d-2271-11ef-8d76-d310d2ec2c14_SESS_afa8fad1-2271-11ef-8d76-d310d2ec2c14_TOSC_b17c4dcd-2271-11ef-8d76-d310d2ec2c14_SNAPS','fc8f31e9-2271-11ef-8d76-d310d2ec2c14.png','fc8f31e9-2271-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"2.1 Maxillaire u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 14:57:27.000','2024-06-04 12:57:27.000','2024-06-04 14:57:27.000'),('fd842fda-2970-11ef-867c-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_1a8fdf3a-296b-11ef-8e16-d517f37fa2ad/fd842fda-2970-11ef-867c-6ec2958327c0.zip','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_SESS_8e83509f-296b-11ef-8e16-d517f37fa2ad_OCC_453321dd-296f-11ef-8e16-d517f37fa2ad_TO1','3fb8c8b6-2970-11ef-8e16-d517f37fa2ad.zip','fd842fda-2970-11ef-867c-6ec2958327c0','{\"displayTitle\":\"1.1 Occlusione o1 Mascella u3\",\"modelMatrix\":\"-0.864017,0.469494,-0.181796,0,-0.39807,-0.858135,-0.324261,0,-0.308244,-0.207799,0.928335,0,19.5091,-2.8713,-9.9809,1\",\"occlusionMatrix\":\"-0.592012,-0.757574,-0.274031,0,-0.802245,0.570287,0.155566,0,0.0373833,0.313175,-0.953131,0,12.5931,9.04976,11.5266,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.1_u3\",\"referenceScanId\":\"890595a9-296d-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 12:32:37.000','2024-06-13 10:32:37.000','2024-06-13 12:32:37.000'),('fd84690a-2970-11ef-867c-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_1a8fdf3a-296b-11ef-8e16-d517f37fa2ad/fd84690a-2970-11ef-867c-6ec2958327c0.xyz','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_SESS_8e83509f-296b-11ef-8e16-d517f37fa2ad_OCC_453321dd-296f-11ef-8e16-d517f37fa2ad_LIFIO','3fd6a6f4-2970-11ef-8e16-d517f37fa2ad.xyz','fd84690a-2970-11ef-867c-6ec2958327c0','{\"displayTitle\":\"1.1 Occlusione o1 Mascella u3 Linea di finitura 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY_1\",\"referenceScanFullDisplayId\":\"1.1_u3\",\"referenceScanId\":\"890595a9-296d-11ef-8e16-d517f37fa2ad\",\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-13 12:32:38.000','2024-06-13 10:32:38.000','2024-06-13 12:32:38.000'),('fd84a61f-2970-11ef-867c-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_1a8fdf3a-296b-11ef-8e16-d517f37fa2ad/fd84a61f-2970-11ef-867c-6ec2958327c0.bin','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_SESS_8e83509f-296b-11ef-8e16-d517f37fa2ad_OCC_453321dd-296f-11ef-8e16-d517f37fa2ad_LIFIMO','3fd6b050-2970-11ef-8e16-d517f37fa2ad.bin','fd84a61f-2970-11ef-867c-6ec2958327c0','{\"displayTitle\":\"1.1 Occlusione o1 Mascella u3 Linea di finitura dei metadati 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY_1\",\"referenceScanFullDisplayId\":\"1.1_u3\",\"referenceScanId\":\"890595a9-296d-11ef-8e16-d517f37fa2ad\",\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-13 12:32:38.000','2024-06-13 10:32:38.000','2024-06-13 12:32:38.000'),('fd84df26-2970-11ef-867c-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_1a8fdf3a-296b-11ef-8e16-d517f37fa2ad/fd84df26-2970-11ef-867c-6ec2958327c0.zip','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_SESS_8e83509f-296b-11ef-8e16-d517f37fa2ad_OCC_453321dd-296f-11ef-8e16-d517f37fa2ad_BO1','3fd6f8c6-2970-11ef-8e16-d517f37fa2ad.zip','fd84df26-2970-11ef-867c-6ec2958327c0','{\"displayTitle\":\"1.1 Occlusione o1 Mandibola l1\",\"modelMatrix\":\"0.984561,0.053893,-0.16654,0,-0.0386096,0.994853,0.0936833,0,0.170732,-0.0858068,0.981574,0,-13.0352,1.74882,-13.1088,1\",\"occlusionMatrix\":\"-0.506192,-0.616502,-0.606765,0,0.861199,-0.377548,-0.330655,0,-0.0289709,-0.693108,0.721723,0,9.19123,18.3975,-2.2212,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.1_l1\",\"referenceScanId\":\"e2305601-296e-11ef-8e16-d517f37fa2ad\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-13 12:32:39.000','2024-06-13 10:32:39.000','2024-06-13 12:32:39.000'),('fd85311c-2970-11ef-867c-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_1a8fdf3a-296b-11ef-8e16-d517f37fa2ad/fd85311c-2970-11ef-867c-6ec2958327c0.png','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_SESS_8e83509f-296b-11ef-8e16-d517f37fa2ad_OCC_453321dd-296f-11ef-8e16-d517f37fa2ad_SCREENO','8f9ceac9-2970-11ef-8e16-d517f37fa2ad.png','fd85311c-2970-11ef-867c-6ec2958327c0','{\"displayTitle\":\"1.1 Occlusione o1 Screenshot 1\",\"occlusionType\":1,\"title\":\"1\"}','PNG',0,'SYNCED',0,NULL,'2024-06-13 12:34:51.000','2024-06-13 10:34:51.000','2024-06-13 12:34:51.000'),('fd856ebc-2970-11ef-867c-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_1a8fdf3a-296b-11ef-8e16-d517f37fa2ad/fd856ebc-2970-11ef-867c-6ec2958327c0.json','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_SESS_8e83509f-296b-11ef-8e16-d517f37fa2ad_OCC_453321dd-296f-11ef-8e16-d517f37fa2ad_METER','e36ba3f8-2970-11ef-8e16-d517f37fa2ad.json','fd856ebc-2970-11ef-867c-6ec2958327c0','{\"displayTitle\":\"1.1 Occlusione o1\",\"occlusionType\":1}','JSON',0,'SYNCED',0,NULL,'2024-06-13 12:37:11.000','2024-06-13 10:37:11.000','2024-06-13 12:37:11.000'),('fd85a7c5-2970-11ef-867c-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_1a8fdf3a-296b-11ef-8e16-d517f37fa2ad/fd85a7c5-2970-11ef-867c-6ec2958327c0.png','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_SESS_8e83509f-296b-11ef-8e16-d517f37fa2ad_OCC_453321dd-296f-11ef-8e16-d517f37fa2ad_SNAPO','eb340ff4-296f-11ef-8e16-d517f37fa2ad.png','fd85a7c5-2970-11ef-867c-6ec2958327c0','{\"displayTitle\":\"1.1 Occlusione o1\",\"occlusionType\":1}','PNG',0,'SYNCED',0,NULL,'2024-06-13 12:30:17.000','2024-06-13 10:30:17.000','2024-06-13 12:30:17.000'),('fd85defa-2970-11ef-867c-6ec2958327c0',2,'/var/.scan4all/iris/data/2024/2/discussion_1a8fdf3a-296b-11ef-8e16-d517f37fa2ad/fd85defa-2970-11ef-867c-6ec2958327c0.pdf','PATIENT_9cd27370-2960-11ef-8e16-d517f37fa2ad_ACT_8e81ab09-296b-11ef-8e16-d517f37fa2ad_PROST_8e871a0f-296b-11ef-8e16-d517f37fa2ad_FORM','fb07e2bb-2970-11ef-8e16-d517f37fa2ad.pdf','fd85defa-2970-11ef-867c-6ec2958327c0','{\"displayTitle\":\"1.1 Corona\",\"title\":\"Corona\"}','PDF',0,'SYNCED',0,NULL,'2024-06-13 12:37:51.000','2024-06-13 10:37:51.000','2024-06-13 12:37:51.000'),('fdd0378f-2338-11ef-8f93-d92a45da78c9',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/computedocclusion_a2829ff3-2338-11ef-8f93-d92a45da78c9/fdd0378f-2338-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_OCC_a2829ff3-2338-11ef-8f93-d92a45da78c9_TO1','fdd0378f-2338-11ef-8f93-d92a45da78c9.zip','fdd0378f-2338-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Occlusion o1 Maxillaire u1 [pc1]\",\"modelMatrix\":\"-0.923468,0.0376561,-0.381824,0,-0.158116,-0.944087,0.289308,0,-0.349581,0.327539,0.877788,0,12.8471,-2.21044,-5.73295,1\",\"occlusionMatrix\":\"0.96183,0.149466,-0.231582,0,0.27256,-0.433127,0.858711,0,0.0250034,-0.888866,-0.457158,0,-15.4993,3.62292,10.3073,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.5_u1\",\"referenceScanId\":\"ef3ba736-2337-11ef-8f93-d92a45da78c9\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-05 14:41:59.000','2024-06-05 12:41:59.000','2024-06-05 14:41:59.000'),('fde62b96-2338-11ef-8f93-d92a45da78c9',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/computedocclusion_a2829ff3-2338-11ef-8f93-d92a45da78c9/fde62b96-2338-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_OCC_a2829ff3-2338-11ef-8f93-d92a45da78c9_BO1','fde62b96-2338-11ef-8f93-d92a45da78c9.zip','fde62b96-2338-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Occlusion o1 Mandibule l1 [pc1]\",\"modelMatrix\":\"0.912405,-0.408985,0.0157505,0,0.408648,0.908152,-0.0909209,0,0.0228815,0.0893931,0.995733,0,-14.1029,6.9381,-10.6228,1\",\"occlusionMatrix\":\"0.978507,0.00506567,-0.206416,0,-0.206059,-0.0415349,-0.977659,0,-0.0100431,0.999139,-0.0397917,0,-17.2944,-6.5218,8.79401,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.5_l1\",\"referenceScanId\":\"23e52d54-2338-11ef-8f93-d92a45da78c9\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-05 14:42:00.000','2024-06-05 12:42:00.000','2024-06-05 14:42:00.000'),('fe5950b5-2338-11ef-8f93-d92a45da78c9',2,'/var/.scan4all/iris/data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/computedocclusion_a2829ff3-2338-11ef-8f93-d92a45da78c9/fe5950b5-2338-11ef-8f93-d92a45da78c9.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_OCC_a2829ff3-2338-11ef-8f93-d92a45da78c9_SNAPO','fe5950b5-2338-11ef-8f93-d92a45da78c9.png','fe5950b5-2338-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Occlusion o1 [pc1]\",\"occlusionType\":1}','PNG',0,'SYNCED',0,NULL,'2024-06-05 14:42:01.000','2024-06-05 12:42:01.000','2024-06-05 14:42:01.000'),('feb3ab65-2a23-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_72b8db7f-2a20-11ef-8f1c-d8242c6fa8fd/occlusion_72bbb4c0-2a20-11ef-8f1c-d8242c6fa8fd/scan_af431dfb-2a22-11ef-8f1c-d8242c6fa8fd/feb3ab65-2a23-11ef-8f1c-d8242c6fa8fd.zip','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_72b8db7f-2a20-11ef-8f1c-d8242c6fa8fd_SESS_72bbb4c0-2a20-11ef-8f1c-d8242c6fa8fd_TOSC_af431dfb-2a22-11ef-8f1c-d8242c6fa8fd_MODEL','feb3ab65-2a23-11ef-8f1c-d8242c6fa8fd.zip','feb3ab65-2a23-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.1 Mascella u2\",\"modelMatrix\":\"0.0231086,-0.985751,-0.166618,0,0.978657,0.056346,-0.197625,0,0.204197,-0.158495,0.966014,0,-27.1813,23.5788,-10.269,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,'2024-06-14 10:38:31.823','2024-06-14 09:59:17.238','2024-06-14 08:38:31.824','2024-06-14 10:38:31.832'),('feb3bc17-2a23-11ef-8f1c-d8242c6fa8fd',11,'/var/.scan4all/iris/data/2024/11/eb10a1b6-2960-11ef-8e16-d517f37fa2ad/session_72b8db7f-2a20-11ef-8f1c-d8242c6fa8fd/occlusion_72bbb4c0-2a20-11ef-8f1c-d8242c6fa8fd/scan_af431dfb-2a22-11ef-8f1c-d8242c6fa8fd/feb3bc17-2a23-11ef-8f1c-d8242c6fa8fd.png','PATIENT_eb10a1b6-2960-11ef-8e16-d517f37fa2ad_ACT_72b8db7f-2a20-11ef-8f1c-d8242c6fa8fd_SESS_72bbb4c0-2a20-11ef-8f1c-d8242c6fa8fd_TOSC_af431dfb-2a22-11ef-8f1c-d8242c6fa8fd_SNAPS','feb3bc17-2a23-11ef-8f1c-d8242c6fa8fd.png','feb3bc17-2a23-11ef-8f1c-d8242c6fa8fd','{\"displayTitle\":\"3.1 Mascella u2 Snapshot\"}','PNG',0,'SYNCED',0,'2024-06-14 10:38:31.823','2024-06-14 09:59:17.238','2024-06-14 08:38:31.825','2024-06-14 10:38:31.832'),('fefc53d6-227d-11ef-8f8c-d92a43d45d56',2,'/var/.scan4all/iris/data/2024/2/ce57500b-227c-11ef-8d76-d310d2ec2c14/session_cdf2bb52-227d-11ef-8f8c-d92a43d45d56/order_cdf680d9-227d-11ef-8f8c-d92a43d45d56/fefc53d6-227d-11ef-8f8c-d92a43d45d56.pdf','PATIENT_ce57500b-227c-11ef-8d76-d310d2ec2c14_ACT_cdf2bb52-227d-11ef-8f8c-d92a43d45d56_PROST_cdf680d9-227d-11ef-8f8c-d92a43d45d56_FORM','fefc53d6-227d-11ef-8f8c-d92a43d45d56.pdf','fefc53d6-227d-11ef-8f8c-d92a43d45d56','{\"displayTitle\":\"3.1 Autre [pc1]\",\"title\":\"Autre\"}','PDF',0,'SYNCED',0,NULL,'2024-06-04 16:23:22.000','2024-06-04 14:23:22.000','2024-06-04 16:23:22.000'),('ff215bde-2982-11ef-8e16-d517f37fa2ad',11,'/var/.scan4all/iris/data/2024/11/269e882c-2961-11ef-8e16-d517f37fa2ad/session_08eb58c6-2980-11ef-8e16-d517f37fa2ad/occlusion_08ed7a4a-2980-11ef-8e16-d517f37fa2ad/scan_099d82e1-2980-11ef-8e16-d517f37fa2ad/ff215bde-2982-11ef-8e16-d517f37fa2ad.ply','PATIENT_269e882c-2961-11ef-8e16-d517f37fa2ad_ACT_08eb58c6-2980-11ef-8e16-d517f37fa2ad_SESS_08ed7a4a-2980-11ef-8e16-d517f37fa2ad_TOSC_099d82e1-2980-11ef-8e16-d517f37fa2ad_SEG','ff215bde-2982-11ef-8e16-d517f37fa2ad.ply','ff215bde-2982-11ef-8e16-d517f37fa2ad','{\"displayTitle\":\"5.5 Mascella u1 Segmentazione\"}','PLY',0,'SYNCED',0,NULL,'2024-06-13 14:46:47.463','2024-06-13 12:46:47.486','2024-06-13 14:46:47.906');
/*!40000 ALTER TABLE `File` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `MessageStatus`
--

DROP TABLE IF EXISTS `MessageStatus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `MessageStatus` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `sentMessageId` varchar(36) NOT NULL,
  `contactId` varchar(36) NOT NULL,
  `status` enum('UNDELIVERED','DELIVERED','TRANSMITTED') NOT NULL DEFAULT 'UNDELIVERED',
  `bcc` tinyint(1) NOT NULL DEFAULT 0,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  PRIMARY KEY (`sentMessageId`,`contactId`),
  KEY `ownerId` (`ownerId`),
  KEY `contactId` (`contactId`),
  CONSTRAINT `MessageStatus_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `MessageStatus_ibfk_2` FOREIGN KEY (`sentMessageId`) REFERENCES `SentMessage` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `MessageStatus_ibfk_3` FOREIGN KEY (`contactId`) REFERENCES `Contact` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `MessageStatus`
--

LOCK TABLES `MessageStatus` WRITE;
/*!40000 ALTER TABLE `MessageStatus` DISABLE KEYS */;
INSERT INTO `MessageStatus` VALUES (2,'0874bbc1-2403-11ef-8dde-d415e84cc4f5','8fbd79fd-0e86-49b8-9558-3a507eb19750','TRANSMITTED',0,'2024-06-07 10:15:21.000'),(2,'0a523b51-6b59-46bf-a2c8-6f51b772db13','f765045a-2805-40b5-9a87-63af78cc2071','DELIVERED',0,'2024-06-19 15:07:23.000'),(2,'0d22759d-225e-11ef-8f1f-d8242c71b430','8fbd79fd-0e86-49b8-9558-3a507eb19750','TRANSMITTED',0,'2024-06-04 10:34:42.000'),(2,'0db3aecb-2cbf-11ef-8e27-d518f78fe3c8','8fbd79fd-0e86-49b8-9558-3a507eb19750','TRANSMITTED',0,'2024-06-20 09:26:29.000'),(2,'0eb44d73-23ea-11ef-8f8c-d92a43d45e5a','8fbd79fd-0e86-49b8-9558-3a507eb19750','TRANSMITTED',0,'2024-06-06 09:49:27.000'),(2,'0f3e4980-225d-11ef-8f1f-d8242c71b430','8fbd79fd-0e86-49b8-9558-3a507eb19750','TRANSMITTED',0,'2024-06-04 10:27:41.000'),(3,'10351862-fb40-4aa9-a4ab-7afe4dba87b9','a664f09d-da86-42d0-b54a-2672898db522','TRANSMITTED',0,'2024-06-04 10:29:25.000'),(11,'14ca16db-2a2f-11ef-8f1c-d8242c6fa8fd','b3c37c04-0470-43df-bb61-f33530e663f1','TRANSMITTED',0,'2024-06-20 09:26:29.000'),(11,'1a9029b2-296b-11ef-8e16-d517f37fa2ad','7c2adbb8-f64b-4654-bf3e-bed35e01c424','TRANSMITTED',0,'2024-06-13 13:38:48.000'),(5,'1ff029c0-b4a6-4bc9-aef0-0d1d79f41259','c6f88ce8-d6e3-44ca-b07b-c13992c4abb8','DELIVERED',0,'2024-06-12 09:40:42.000'),(11,'20a09331-2984-11ef-8e16-d517f37fa2ad','7c2adbb8-f64b-4654-bf3e-bed35e01c424','TRANSMITTED',0,'2024-06-13 13:38:48.000'),(3,'2192fe1a-0490-4bd9-8f2d-363155abc9a2','a664f09d-da86-42d0-b54a-2672898db522','TRANSMITTED',0,'2024-06-06 12:23:37.000'),(5,'24b7ab8b-28a0-11ef-8e16-d517f37fa2ad','c6f88ce8-d6e3-44ca-b07b-c13992c4abb8','DELIVERED',0,'2024-06-12 09:42:58.000'),(2,'2602522e-2e4c-11ef-8deb-d515ea58f6cb','f765045a-2805-40b5-9a87-63af78cc2071','TRANSMITTED',0,'2024-06-19 14:58:04.000'),(11,'2aa35b06-2988-11ef-8e16-d517f37fa2ad','b3c37c04-0470-43df-bb61-f33530e663f1','TRANSMITTED',0,'2024-06-13 13:23:53.000'),(5,'2c4ce7cf-6875-4a7e-99de-470ca57d37cf','ccc73fab-ccfe-4862-b2bd-90f0a1c56566','TRANSMITTED',0,'2024-06-10 14:13:56.000'),(2,'2d654e78-2272-11ef-8d76-d310d2ec2c14','4ed4ce00-4b30-4601-95bb-ede535f19c6b','TRANSMITTED',0,'2024-06-12 12:56:58.000'),(2,'2f604f05-d11c-43d9-bdf9-d43e0306dfda','8fbd79fd-0e86-49b8-9558-3a507eb19750','TRANSMITTED',0,'2024-06-06 09:09:22.000'),(2,'30f0f8e5-2279-11ef-8d76-d310d2ec2c14','4ed4ce00-4b30-4601-95bb-ede535f19c6b','TRANSMITTED',0,'2024-06-12 12:56:58.000'),(2,'33305035-2e42-11ef-8deb-d515ea58f6cb','f765045a-2805-40b5-9a87-63af78cc2071','TRANSMITTED',0,'2024-06-19 14:58:04.000'),(3,'33e44dc1-23e9-11ef-8dde-d415e84cc4f5','a664f09d-da86-42d0-b54a-2672898db522','TRANSMITTED',0,'2024-06-06 09:47:52.000'),(2,'35f75e0f-a626-47c5-9d5b-946f217739af','ddaf1074-a13e-459d-ab8a-83ce1d832cdc','TRANSMITTED',0,'2024-06-13 13:06:47.000'),(11,'3d61fa93-2986-11ef-8e16-d517f37fa2ad','b3c37c04-0470-43df-bb61-f33530e663f1','TRANSMITTED',0,'2024-06-13 13:12:43.000'),(2,'4c1489bb-54c8-4aa3-8017-d140fe974c2f','8fbd79fd-0e86-49b8-9558-3a507eb19750','TRANSMITTED',0,'2024-06-06 10:01:41.000'),(2,'4db93275-aa1c-442f-b2b5-af6c4514bd24','8fbd79fd-0e86-49b8-9558-3a507eb19750','TRANSMITTED',0,'2024-06-06 09:57:25.000'),(2,'506b80e8-8e38-4c1d-aaaa-3a424481b4ca','0a2963fd-83d3-4097-855c-d014d51f230e','TRANSMITTED',0,'2024-06-20 09:37:06.000'),(2,'550f3fc1-226b-11ef-8f1f-d8242c71b430','4ed4ce00-4b30-4601-95bb-ede535f19c6b','TRANSMITTED',0,'2024-06-04 12:10:11.000'),(3,'56f0c51f-23ed-11ef-8dde-d415e84cc4f5','a664f09d-da86-42d0-b54a-2672898db522','TRANSMITTED',0,'2024-06-06 10:16:25.000'),(3,'5701b18b-225e-11ef-8d76-d310d2ec2c14','a664f09d-da86-42d0-b54a-2672898db522','TRANSMITTED',0,'2024-06-04 10:36:47.000'),(3,'59cfafae-e9ce-4a51-be20-09e9860da4b4','a664f09d-da86-42d0-b54a-2672898db522','TRANSMITTED',0,'2024-06-06 12:22:37.000'),(2,'5c02d3d5-23e4-11ef-8dde-d415e84cc4f5','8fbd79fd-0e86-49b8-9558-3a507eb19750','DELIVERED',0,'2024-06-06 09:08:38.186'),(11,'5c613afb-82ec-442d-8d9c-769d176f624d','7c2adbb8-f64b-4654-bf3e-bed35e01c424','TRANSMITTED',0,'2024-06-13 13:38:48.000'),(2,'5c87a655-2e3c-11ef-8deb-d515ea58f6cb','f765045a-2805-40b5-9a87-63af78cc2071','TRANSMITTED',0,'2024-06-19 14:58:04.000'),(3,'62d4940c-225e-11ef-8d76-d310d2ec2c14','a664f09d-da86-42d0-b54a-2672898db522','DELIVERED',0,'2024-06-04 10:37:05.434'),(2,'673530bc-2272-11ef-8d76-d310d2ec2c14','4ed4ce00-4b30-4601-95bb-ede535f19c6b','TRANSMITTED',0,'2024-06-12 12:56:58.000'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','4ed4ce00-4b30-4601-95bb-ede535f19c6b','TRANSMITTED',0,'2024-06-12 12:56:58.000'),(5,'6fb37b74-28a0-11ef-8e16-d517f37fa2ad','c6f88ce8-d6e3-44ca-b07b-c13992c4abb8','DELIVERED',0,'2024-06-12 09:45:03.000'),(2,'75433112-226f-11ef-8f1f-d8242c71b430','4ed4ce00-4b30-4601-95bb-ede535f19c6b','TRANSMITTED',0,'2024-06-12 12:56:58.000'),(2,'792e2a4b-f301-41c9-893e-619fc4a73281','ddaf1074-a13e-459d-ab8a-83ce1d832cdc','TRANSMITTED',0,'2024-06-13 13:15:10.000'),(2,'7c7133c4-869b-4ecf-be8c-a7ba25b96324','8fbd79fd-0e86-49b8-9558-3a507eb19750','TRANSMITTED',0,'2024-06-04 10:29:34.000'),(11,'806e92df-2986-11ef-8e16-d517f37fa2ad','b3c37c04-0470-43df-bb61-f33530e663f1','TRANSMITTED',0,'2024-06-13 13:12:43.000'),(5,'88fb6e51-28a0-11ef-8e16-d517f37fa2ad','f59d888e-123c-451a-a8b6-5e46affc6317','DELIVERED',0,'2024-06-12 09:45:44.000'),(3,'89d9cfe1-7384-4ce3-ae5e-89be13d7ae9d','98fca350-1328-4c00-87ff-fd100500f576','TRANSMITTED',0,'2024-06-13 13:13:00.000'),(2,'8e81ec28-2733-11ef-8e16-d517f37fa1ab','f765045a-2805-40b5-9a87-63af78cc2071','TRANSMITTED',0,'2024-06-10 14:13:38.000'),(2,'8e9d97c9-2738-11ef-8e16-d517f37fa1ab','f765045a-2805-40b5-9a87-63af78cc2071','TRANSMITTED',0,'2024-06-12 07:58:49.000'),(2,'91a29730-2e43-11ef-8deb-d515ea58f6cb','f765045a-2805-40b5-9a87-63af78cc2071','TRANSMITTED',0,'2024-06-19 14:58:04.000'),(3,'96378603-23e4-11ef-8f8c-d92a43d45e5a','a664f09d-da86-42d0-b54a-2672898db522','TRANSMITTED',0,'2024-06-06 09:24:48.000'),(3,'9ac047ea-23eb-11ef-8dde-d415e84cc4f5','a664f09d-da86-42d0-b54a-2672898db522','TRANSMITTED',0,'2024-06-06 10:01:33.000'),(2,'9c944f7a-27ce-11ef-8e37-d519fa9d22d2','f765045a-2805-40b5-9a87-63af78cc2071','TRANSMITTED',0,'2024-06-12 07:58:49.000'),(11,'9db6e18f-297e-11ef-8e16-d517f37fa2ad','7c2adbb8-f64b-4654-bf3e-bed35e01c424','TRANSMITTED',0,'2024-06-13 13:38:48.000'),(3,'9e44f2e9-23e4-11ef-8f8c-d92a43d45e5a','a664f09d-da86-42d0-b54a-2672898db522','TRANSMITTED',0,'2024-06-06 09:24:48.000'),(5,'a7736a88-289f-11ef-8e16-d517f37fa2ad','c6f88ce8-d6e3-44ca-b07b-c13992c4abb8','DELIVERED',0,'2024-06-12 09:39:27.445'),(2,'ae66af70-27ca-11ef-8e37-d519fa9d22d2','57a94929-f9c0-438e-b77e-c2432d03181d','TRANSMITTED',0,'2024-06-11 08:15:09.000'),(2,'b1d82b93-226b-11ef-8d76-d310d2ec2c14','4ed4ce00-4b30-4601-95bb-ede535f19c6b','TRANSMITTED',0,'2024-06-12 12:56:58.000'),(3,'b44b19e6-8bfe-477e-bdc3-5fda6f4b7bd3','98fca350-1328-4c00-87ff-fd100500f576','TRANSMITTED',0,'2024-06-13 13:10:37.000'),(2,'b60e672c-27c9-11ef-8e37-d519fa9d22d2','4ed4ce00-4b30-4601-95bb-ede535f19c6b','TRANSMITTED',0,'2024-06-12 12:56:58.000'),(2,'b7df2f87-2e3c-11ef-8deb-d515ea58f6cb','f765045a-2805-40b5-9a87-63af78cc2071','TRANSMITTED',0,'2024-06-19 14:58:04.000'),(2,'b9efc6fe-27ca-11ef-8e37-d519fa9d22d2','57a94929-f9c0-438e-b77e-c2432d03181d','DELIVERED',0,'2024-06-11 08:15:13.187'),(2,'bb71575b-5b05-40de-9ab4-b7779ee0cf94','0a2963fd-83d3-4097-855c-d014d51f230e','TRANSMITTED',0,'2024-06-20 10:15:58.000'),(3,'bd09e4f5-a92e-41e6-8106-49d6eab12126','277ab19c-36e7-41ed-89b9-4dda2501e936','TRANSMITTED',0,'2024-06-20 09:41:26.000'),(5,'be27ff6b-289d-11ef-8e16-d517f37fa2ad','c6f88ce8-d6e3-44ca-b07b-c13992c4abb8','DELIVERED',0,'2024-06-12 09:25:47.000'),(2,'be91b6bf-2733-11ef-8e16-d517f37fa1ab','f765045a-2805-40b5-9a87-63af78cc2071','TRANSMITTED',0,'2024-06-10 14:14:30.000'),(2,'c0651022-2cc0-11ef-8e27-d518f78fe3c8','57a94929-f9c0-438e-b77e-c2432d03181d','TRANSMITTED',0,'2024-06-17 15:46:25.000'),(5,'c13b3b06-ddd8-4a9e-a735-9592cf516fda','ccc73fab-ccfe-4862-b2bd-90f0a1c56566','TRANSMITTED',0,'2024-06-10 14:15:22.000'),(5,'c1a443f6-289e-11ef-8e16-d517f37fa2ad','c6f88ce8-d6e3-44ca-b07b-c13992c4abb8','DELIVERED',0,'2024-06-12 09:33:01.343'),(2,'c719b05f-2cc0-11ef-8e27-d518f78fe3c8','57a94929-f9c0-438e-b77e-c2432d03181d','TRANSMITTED',0,'2024-06-17 15:46:39.000'),(2,'ca7695c9-2e41-11ef-8deb-d515ea58f6cb','f765045a-2805-40b5-9a87-63af78cc2071','TRANSMITTED',0,'2024-06-19 14:58:04.000'),(2,'d387710c-27c8-11ef-8e37-d519fa9d22d2','4ed4ce00-4b30-4601-95bb-ede535f19c6b','TRANSMITTED',0,'2024-06-12 12:56:58.000'),(2,'d61618a0-2279-11ef-8d76-d310d2ec2c14','4ed4ce00-4b30-4601-95bb-ede535f19c6b','TRANSMITTED',0,'2024-06-12 12:56:58.000'),(2,'d8a6277b-2e42-11ef-8deb-d515ea58f6cb','f765045a-2805-40b5-9a87-63af78cc2071','TRANSMITTED',0,'2024-06-19 14:58:04.000'),(3,'ddab8ff1-23e2-11ef-8f8c-d92a43d45e5a','a50cb907-4db3-48f3-9808-0ae18d8dccdb','TRANSMITTED',0,'2024-06-06 08:58:06.000'),(2,'de9207cc-7b94-4f23-8d11-6fb49d3bd237','4ed4ce00-4b30-4601-95bb-ede535f19c6b','TRANSMITTED',0,'2024-06-12 12:56:58.000'),(2,'e03dc949-f924-4e48-a5fd-e8273bbf6e07','8fbd79fd-0e86-49b8-9558-3a507eb19750','TRANSMITTED',0,'2024-06-06 09:58:24.000'),(2,'e5fbd2ab-2e4d-11ef-8deb-d515ea58f6cb','f765045a-2805-40b5-9a87-63af78cc2071','DELIVERED',0,'2024-06-19 15:09:20.940'),(11,'eba48b0e-2a2f-11ef-8f1c-d8242c6fa8fd','b3c37c04-0470-43df-bb61-f33530e663f1','TRANSMITTED',0,'2024-06-20 09:26:29.000'),(2,'ec59b1ff-79e7-49aa-9888-5b1e722d3d80','8fbd79fd-0e86-49b8-9558-3a507eb19750','TRANSMITTED',0,'2024-06-06 10:02:17.000'),(2,'ee074334-fd31-4f09-a527-2f1a41048adb','ddaf1074-a13e-459d-ab8a-83ce1d832cdc','TRANSMITTED',0,'2024-06-13 13:14:19.000'),(2,'ef1364ca-2e41-11ef-8deb-d515ea58f6cb','f765045a-2805-40b5-9a87-63af78cc2071','TRANSMITTED',0,'2024-06-19 14:58:04.000'),(2,'f084f705-5f7b-4dac-af14-81f4808be17e','ddaf1074-a13e-459d-ab8a-83ce1d832cdc','TRANSMITTED',0,'2024-06-13 13:16:14.000'),(2,'f10a4998-df89-4f58-b94d-d75e40e7a992','f765045a-2805-40b5-9a87-63af78cc2071','TRANSMITTED',0,'2024-06-19 14:58:04.000'),(3,'f352fb85-23e4-11ef-8f8c-d92a43d45e5a','a664f09d-da86-42d0-b54a-2672898db522','TRANSMITTED',0,'2024-06-06 09:24:48.000'),(2,'fa2fabfb-2e4d-11ef-8deb-d515ea58f6cb','f765045a-2805-40b5-9a87-63af78cc2071','DELIVERED',0,'2024-06-19 15:09:55.473'),(2,'fad71f64-8b16-4fc8-94d4-6ae6473112ab','8fbd79fd-0e86-49b8-9558-3a507eb19750','TRANSMITTED',0,'2024-06-06 09:56:28.000'),(3,'fb69a8c0-23e7-11ef-8dde-d415e84cc4f5','a50cb907-4db3-48f3-9808-0ae18d8dccdb','TRANSMITTED',0,'2024-06-06 09:34:37.000'),(11,'fb782cec-2970-11ef-8e16-d517f37fa2ad','7c2adbb8-f64b-4654-bf3e-bed35e01c424','TRANSMITTED',0,'2024-06-13 13:38:48.000'),(5,'fc040a6f-0868-41d5-af3d-0efefc71a692','ccc73fab-ccfe-4862-b2bd-90f0a1c56566','TRANSMITTED',0,'2024-06-10 14:49:13.000'),(2,'ff68612f-227d-11ef-8f8c-d92a43d45d56','4ed4ce00-4b30-4601-95bb-ede535f19c6b','TRANSMITTED',0,'2024-06-12 12:56:58.000');
/*!40000 ALTER TABLE `MessageStatus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Occlusion`
--

DROP TABLE IF EXISTS `Occlusion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Occlusion` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `sessionId` varchar(36) DEFAULT NULL,
  `occlusionType` enum('UNKNOWN','HEMI_ARCADE_POSTERIEUR_DROIT','HEMI_ARCADE_POSTERIEUR_GAUCHE','HEMI_ARCADE_ANTERIEUR','ARCADE_COMPLETE_ANTERIEUR','ARCADE_COMPLETE') DEFAULT 'UNKNOWN',
  `displayId` mediumint(8) unsigned DEFAULT NULL,
  `pcId` mediumint(8) unsigned DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT 0,
  `comments` text DEFAULT NULL,
  `topScanId` varchar(36) DEFAULT NULL,
  `bottomScanId` varchar(36) DEFAULT NULL,
  `anteriorBiteScanId` varchar(36) DEFAULT NULL,
  `rightBiteScanId` varchar(36) DEFAULT NULL,
  `leftBiteScanId` varchar(36) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `sessionId` (`sessionId`),
  KEY `topScanId` (`topScanId`),
  KEY `bottomScanId` (`bottomScanId`),
  KEY `anteriorBiteScanId` (`anteriorBiteScanId`),
  KEY `rightBiteScanId` (`rightBiteScanId`),
  KEY `leftBiteScanId` (`leftBiteScanId`),
  CONSTRAINT `Occlusion_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_2` FOREIGN KEY (`sessionId`) REFERENCES `Session` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_3` FOREIGN KEY (`topScanId`) REFERENCES `Scan` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_4` FOREIGN KEY (`bottomScanId`) REFERENCES `Scan` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_5` FOREIGN KEY (`anteriorBiteScanId`) REFERENCES `Scan` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_6` FOREIGN KEY (`rightBiteScanId`) REFERENCES `Scan` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_7` FOREIGN KEY (`leftBiteScanId`) REFERENCES `Scan` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Occlusion`
--

LOCK TABLES `Occlusion` WRITE;
/*!40000 ALTER TABLE `Occlusion` DISABLE KEYS */;
INSERT INTO `Occlusion` VALUES ('16a35458-289c-11ef-8e16-d517f37fa2ad',5,'627f5b3e-289b-11ef-8e16-d517f37fa2ad','HEMI_ARCADE_POSTERIEUR_DROIT',1,1,0,'','db07e23d-289b-11ef-8e16-d517f37fa2ad','804316c5-289b-11ef-8e16-d517f37fa2ad',NULL,'1737aea0-289c-11ef-8e16-d517f37fa2ad',NULL,'2024-06-12 11:13:53.158',NULL,'2024-06-12 11:15:01.683','2024-06-12 09:15:01.683','2024-06-12 11:15:01.690'),('43733a85-2274-11ef-8d76-d310d2ec2c14',2,'f262aa99-2272-11ef-8d76-d310d2ec2c14','ARCADE_COMPLETE',1,2,0,'','f3b0649e-2272-11ef-8d76-d310d2ec2c14','96d08283-2273-11ef-8d76-d310d2ec2c14',NULL,'4501cd03-2274-11ef-8d76-d310d2ec2c14','4501387b-2274-11ef-8d76-d310d2ec2c14','2024-06-04 15:13:41.000',NULL,'2024-06-04 15:37:40.000','2024-06-04 13:37:41.000','2024-06-04 15:37:41.000'),('453321dd-296f-11ef-8e16-d517f37fa2ad',11,'8e83509f-296b-11ef-8e16-d517f37fa2ad','HEMI_ARCADE_POSTERIEUR_DROIT',1,1,0,'','890595a9-296d-11ef-8e16-d517f37fa2ad','e2305601-296e-11ef-8e16-d517f37fa2ad',NULL,'6c4bba69-296f-11ef-8e16-d517f37fa2ad',NULL,'2024-06-13 12:25:35.086',NULL,'2024-06-13 12:37:10.040','2024-06-13 10:37:10.041','2024-06-13 12:37:10.104'),('456d151a-2985-11ef-8e16-d517f37fa2ad',11,'a888b842-2984-11ef-8e16-d517f37fa2ad','HEMI_ARCADE_POSTERIEUR_GAUCHE',1,1,0,'','de3fd237-2984-11ef-8e16-d517f37fa2ad','1d4719f4-2985-11ef-8e16-d517f37fa2ad',NULL,NULL,'4a3afb31-2985-11ef-8e16-d517f37fa2ad','2024-06-13 15:03:04.394',NULL,'2024-06-13 15:05:35.529','2024-06-13 13:05:35.529','2024-06-13 15:05:35.549'),('7a7b3c41-2e4b-11ef-8deb-d515ea58f6cb',2,'15f94c3c-2e4b-11ef-8deb-d515ea58f6cb','HEMI_ARCADE_POSTERIEUR_GAUCHE',1,2,0,'','1770b226-2e4b-11ef-8deb-d515ea58f6cb','4155dabe-2e4b-11ef-8deb-d515ea58f6cb',NULL,NULL,'7b449582-2e4b-11ef-8deb-d515ea58f6cb','2024-06-19 16:51:59.054',NULL,'2024-06-19 16:54:27.189','2024-06-19 14:54:27.189','2024-06-19 16:54:27.204'),('89b4ac38-2e3b-11ef-8deb-d515ea58f6cb',2,'da21a6e4-2e3a-11ef-8deb-d515ea58f6cb','HEMI_ARCADE_POSTERIEUR_GAUCHE',1,2,0,'','dc038d5b-2e3a-11ef-8deb-d515ea58f6cb','18dce61e-2e3b-11ef-8deb-d515ea58f6cb',NULL,NULL,'8bc7c92e-2e3b-11ef-8deb-d515ea58f6cb','2024-06-19 14:57:52.649',NULL,'2024-06-19 15:02:13.851','2024-06-19 13:02:13.852','2024-06-19 15:02:13.867'),('9153c588-2968-11ef-8e16-d517f37fa2ad',11,'4706df6f-2963-11ef-8e16-d517f37fa2ad','ARCADE_COMPLETE',1,1,0,'','47f95341-2963-11ef-8e16-d517f37fa2ad','f3a386e0-2965-11ef-8e16-d517f37fa2ad',NULL,'366c910a-2969-11ef-8e16-d517f37fa2ad','366c0b70-2969-11ef-8e16-d517f37fa2ad','2024-06-13 11:37:36.329',NULL,'2024-06-13 11:52:35.450','2024-06-13 09:52:35.450','2024-06-13 11:52:35.495'),('9ed6352b-2277-11ef-8d76-d310d2ec2c14',2,'f262aa99-2272-11ef-8d76-d310d2ec2c14','ARCADE_COMPLETE',2,2,0,'','f3b0649e-2272-11ef-8d76-d310d2ec2c14','96d08283-2273-11ef-8d76-d310d2ec2c14',NULL,'9fc7cfd7-2277-11ef-8d76-d310d2ec2c14','9fc70276-2277-11ef-8d76-d310d2ec2c14','2024-06-04 15:37:43.000',NULL,'2024-06-04 15:48:24.000','2024-06-04 13:48:25.000','2024-06-04 15:48:25.000'),('a03e3cb8-289c-11ef-8e16-d517f37fa2ad',5,'0d14f12a-289a-11ef-8e16-d517f37fa2ad','HEMI_ARCADE_POSTERIEUR_DROIT',1,1,0,'','5781b86f-289a-11ef-8e16-d517f37fa2ad','a4a0d8da-289a-11ef-8e16-d517f37fa2ad',NULL,'a0eae524-289c-11ef-8e16-d517f37fa2ad',NULL,'2024-06-12 11:17:44.022',NULL,'2024-06-12 11:20:00.455','2024-06-12 09:20:00.456','2024-06-12 11:20:00.471'),('a4bc6912-2980-11ef-8e16-d517f37fa2ad',11,'08ed7a4a-2980-11ef-8e16-d517f37fa2ad','HEMI_ARCADE_ANTERIEUR',1,1,0,'','099d82e1-2980-11ef-8e16-d517f37fa2ad','4d76036e-2980-11ef-8e16-d517f37fa2ad','a5b11e9a-2980-11ef-8e16-d517f37fa2ad',NULL,NULL,'2024-06-13 14:29:56.814',NULL,'2024-06-13 14:46:02.155','2024-06-13 12:46:02.155','2024-06-13 14:46:02.183'),('c472f797-2987-11ef-8e16-d517f37fa2ad',11,'4ba370c1-2987-11ef-8e16-d517f37fa2ad','HEMI_ARCADE_POSTERIEUR_DROIT',1,1,0,'','55568e89-2987-11ef-8e16-d517f37fa2ad','879dec53-2987-11ef-8e16-d517f37fa2ad',NULL,'c90eb287-2987-11ef-8e16-d517f37fa2ad',NULL,'2024-06-13 15:20:56.496',NULL,'2024-06-13 15:22:46.005','2024-06-13 13:22:46.005','2024-06-13 15:22:46.023'),('d7d76f34-2e3d-11ef-8deb-d515ea58f6cb',2,'af864e86-27f1-11ef-8e37-d519fa9d22d2','HEMI_ARCADE_POSTERIEUR_GAUCHE',1,2,0,'','e16361f9-2e3c-11ef-8deb-d515ea58f6cb','3447447c-2e3d-11ef-8deb-d515ea58f6cb',NULL,NULL,'d891acce-2e3d-11ef-8deb-d515ea58f6cb','2024-06-19 15:14:22.732',NULL,'2024-06-19 15:19:00.558','2024-06-19 13:19:00.558','2024-06-19 15:19:00.566'),('e08676da-2990-11ef-8e16-d517f37fa2ad',11,'d70636d7-298d-11ef-8e16-d517f37fa2ad','HEMI_ARCADE_POSTERIEUR_DROIT',1,1,0,'','2ed06b9e-298f-11ef-8e16-d517f37fa2ad','99d1c412-2990-11ef-8e16-d517f37fa2ad',NULL,'e3221a36-2990-11ef-8e16-d517f37fa2ad',NULL,'2024-06-13 16:26:09.071',NULL,'2024-06-13 16:28:35.746','2024-06-13 14:28:35.746','2024-06-13 16:28:35.772'),('e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd',11,'8d098374-2a29-11ef-8f1c-d8242c6fa8fd','HEMI_ARCADE_POSTERIEUR_DROIT',1,1,0,'','8de1d45c-2a29-11ef-8f1c-d8242c6fa8fd','80540c46-2a2a-11ef-8f1c-d8242c6fa8fd',NULL,'ea470b5e-2a2a-11ef-8f1c-d8242c6fa8fd',NULL,'2024-06-14 10:48:45.098',NULL,'2024-06-14 11:17:24.700','2024-06-14 09:17:24.700','2024-06-14 11:17:24.748');
/*!40000 ALTER TABLE `Occlusion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `OcclusionFile`
--

DROP TABLE IF EXISTS `OcclusionFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `OcclusionFile` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `occlusionId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('RESULT','MANDIBLE_1','MANDIBLE_2','MANDIBLE_3','MANDIBLE_4','MAXILLARY_1','MAXILLARY_2','MAXILLARY_3','MAXILLARY_4','LIFI','LIFIMETA','SNAPSHOT','SCREENSHOT','METERING') NOT NULL DEFAULT 'RESULT',
  PRIMARY KEY (`occlusionId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `OcclusionFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `OcclusionFile_ibfk_2` FOREIGN KEY (`occlusionId`) REFERENCES `Occlusion` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `OcclusionFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `OcclusionFile`
--

LOCK TABLES `OcclusionFile` WRITE;
/*!40000 ALTER TABLE `OcclusionFile` DISABLE KEYS */;
INSERT INTO `OcclusionFile` VALUES (5,'16a35458-289c-11ef-8e16-d517f37fa2ad','3ef48adf-289c-11ef-8e16-d517f37fa2ad','MAXILLARY_1'),(5,'16a35458-289c-11ef-8e16-d517f37fa2ad','3f100ab3-289c-11ef-8e16-d517f37fa2ad','MANDIBLE_1'),(5,'16a35458-289c-11ef-8e16-d517f37fa2ad','3f7b0e6c-289c-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(2,'43733a85-2274-11ef-8d76-d310d2ec2c14','92bce3d8-2277-11ef-8d76-d310d2ec2c14','MANDIBLE_1'),(2,'43733a85-2274-11ef-8d76-d310d2ec2c14','e198305a-2274-11ef-8d76-d310d2ec2c14','MAXILLARY_1'),(2,'43733a85-2274-11ef-8d76-d310d2ec2c14','e1cab74d-2274-11ef-8d76-d310d2ec2c14','MANDIBLE_1'),(2,'43733a85-2274-11ef-8d76-d310d2ec2c14','e27ce916-2274-11ef-8d76-d310d2ec2c14','SNAPSHOT'),(11,'453321dd-296f-11ef-8e16-d517f37fa2ad','3fb8c8b6-2970-11ef-8e16-d517f37fa2ad','MAXILLARY_1'),(11,'453321dd-296f-11ef-8e16-d517f37fa2ad','3fd6a6f4-2970-11ef-8e16-d517f37fa2ad','LIFI'),(11,'453321dd-296f-11ef-8e16-d517f37fa2ad','3fd6b050-2970-11ef-8e16-d517f37fa2ad','LIFIMETA'),(11,'453321dd-296f-11ef-8e16-d517f37fa2ad','3fd6f8c6-2970-11ef-8e16-d517f37fa2ad','MANDIBLE_1'),(11,'453321dd-296f-11ef-8e16-d517f37fa2ad','8f9ceac9-2970-11ef-8e16-d517f37fa2ad','SCREENSHOT'),(11,'453321dd-296f-11ef-8e16-d517f37fa2ad','95dfa34a-2970-11ef-8e16-d517f37fa2ad','METERING'),(11,'453321dd-296f-11ef-8e16-d517f37fa2ad','b90fefbb-2970-11ef-8e16-d517f37fa2ad','METERING'),(11,'453321dd-296f-11ef-8e16-d517f37fa2ad','e36ba3f8-2970-11ef-8e16-d517f37fa2ad','METERING'),(11,'453321dd-296f-11ef-8e16-d517f37fa2ad','ea897dcd-296f-11ef-8e16-d517f37fa2ad','MAXILLARY_1'),(11,'453321dd-296f-11ef-8e16-d517f37fa2ad','eaa64966-296f-11ef-8e16-d517f37fa2ad','LIFI'),(11,'453321dd-296f-11ef-8e16-d517f37fa2ad','eaa64ffc-296f-11ef-8e16-d517f37fa2ad','LIFIMETA'),(11,'453321dd-296f-11ef-8e16-d517f37fa2ad','eaa687f7-296f-11ef-8e16-d517f37fa2ad','MANDIBLE_1'),(11,'453321dd-296f-11ef-8e16-d517f37fa2ad','eb340ff4-296f-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(11,'456d151a-2985-11ef-8e16-d517f37fa2ad','74b221fa-2985-11ef-8e16-d517f37fa2ad','MAXILLARY_1'),(11,'456d151a-2985-11ef-8e16-d517f37fa2ad','74cbc798-2985-11ef-8e16-d517f37fa2ad','MANDIBLE_1'),(11,'456d151a-2985-11ef-8e16-d517f37fa2ad','753bf031-2985-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(11,'456d151a-2985-11ef-8e16-d517f37fa2ad','8b9c18a2-2985-11ef-8e16-d517f37fa2ad','MAXILLARY_1'),(11,'456d151a-2985-11ef-8e16-d517f37fa2ad','92d82f66-2985-11ef-8e16-d517f37fa2ad','MANDIBLE_1'),(2,'7a7b3c41-2e4b-11ef-8deb-d515ea58f6cb','cca14134-2e4b-11ef-8deb-d515ea58f6cb','MAXILLARY_1'),(2,'7a7b3c41-2e4b-11ef-8deb-d515ea58f6cb','ccb950d9-2e4b-11ef-8deb-d515ea58f6cb','MANDIBLE_1'),(2,'7a7b3c41-2e4b-11ef-8deb-d515ea58f6cb','cd43bf12-2e4b-11ef-8deb-d515ea58f6cb','SNAPSHOT'),(2,'7a7b3c41-2e4b-11ef-8deb-d515ea58f6cb','d2ad1a19-2e4b-11ef-8deb-d515ea58f6cb','MANDIBLE_1'),(2,'89b4ac38-2e3b-11ef-8deb-d515ea58f6cb','16f20683-2e3c-11ef-8deb-d515ea58f6cb','MANDIBLE_1'),(2,'89b4ac38-2e3b-11ef-8deb-d515ea58f6cb','254bffc7-2e3c-11ef-8deb-d515ea58f6cb','MANDIBLE_1'),(2,'89b4ac38-2e3b-11ef-8deb-d515ea58f6cb','c191f4f9-2e3b-11ef-8deb-d515ea58f6cb','MAXILLARY_1'),(2,'89b4ac38-2e3b-11ef-8deb-d515ea58f6cb','c1a8eaf0-2e3b-11ef-8deb-d515ea58f6cb','MANDIBLE_1'),(2,'89b4ac38-2e3b-11ef-8deb-d515ea58f6cb','c22f9f80-2e3b-11ef-8deb-d515ea58f6cb','SNAPSHOT'),(2,'89b4ac38-2e3b-11ef-8deb-d515ea58f6cb','d893529b-2e3b-11ef-8deb-d515ea58f6cb','MANDIBLE_1'),(2,'89b4ac38-2e3b-11ef-8deb-d515ea58f6cb','e6a1b524-2e3b-11ef-8deb-d515ea58f6cb','SCREENSHOT'),(2,'89b4ac38-2e3b-11ef-8deb-d515ea58f6cb','ecd551db-2e3b-11ef-8deb-d515ea58f6cb','SCREENSHOT'),(2,'89b4ac38-2e3b-11ef-8deb-d515ea58f6cb','ee91fd74-2e3b-11ef-8deb-d515ea58f6cb','SCREENSHOT'),(2,'89b4ac38-2e3b-11ef-8deb-d515ea58f6cb','f00455a1-2e3b-11ef-8deb-d515ea58f6cb','SCREENSHOT'),(2,'89b4ac38-2e3b-11ef-8deb-d515ea58f6cb','f17e0ce7-2e3b-11ef-8deb-d515ea58f6cb','SCREENSHOT'),(2,'89b4ac38-2e3b-11ef-8deb-d515ea58f6cb','f4f2c020-2e3b-11ef-8deb-d515ea58f6cb','SCREENSHOT'),(11,'9153c588-2968-11ef-8e16-d517f37fa2ad','1faa40ce-296a-11ef-8e16-d517f37fa2ad','MAXILLARY_1'),(11,'9153c588-2968-11ef-8e16-d517f37fa2ad','1ff1bee2-296a-11ef-8e16-d517f37fa2ad','MANDIBLE_1'),(11,'9153c588-2968-11ef-8e16-d517f37fa2ad','21107477-296a-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(11,'9153c588-2968-11ef-8e16-d517f37fa2ad','a8c82bcb-296a-11ef-8e16-d517f37fa2ad','MAXILLARY_1'),(11,'9153c588-2968-11ef-8e16-d517f37fa2ad','a90adf72-296a-11ef-8e16-d517f37fa2ad','MANDIBLE_1'),(2,'9ed6352b-2277-11ef-8d76-d310d2ec2c14','1c9626b7-2279-11ef-8d76-d310d2ec2c14','SCREENSHOT'),(2,'9ed6352b-2277-11ef-8d76-d310d2ec2c14','5adbc9bc-2278-11ef-8d76-d310d2ec2c14','MAXILLARY_1'),(2,'9ed6352b-2277-11ef-8d76-d310d2ec2c14','5b0decc4-2278-11ef-8d76-d310d2ec2c14','MANDIBLE_1'),(2,'9ed6352b-2277-11ef-8d76-d310d2ec2c14','5bc001f1-2278-11ef-8d76-d310d2ec2c14','SNAPSHOT'),(2,'9ed6352b-2277-11ef-8d76-d310d2ec2c14','613c6795-2278-11ef-8d76-d310d2ec2c14','MANDIBLE_1'),(2,'9ed6352b-2277-11ef-8d76-d310d2ec2c14','8c08eecf-2278-11ef-8d76-d310d2ec2c14','MAXILLARY_1'),(2,'9ed6352b-2277-11ef-8d76-d310d2ec2c14','a84953ba-2278-11ef-8d76-d310d2ec2c14','METERING'),(2,'9ed6352b-2277-11ef-8d76-d310d2ec2c14','e59826d2-2278-11ef-8d76-d310d2ec2c14','MAXILLARY_2'),(5,'a03e3cb8-289c-11ef-8e16-d517f37fa2ad','f11a7ce4-289c-11ef-8e16-d517f37fa2ad','MAXILLARY_1'),(5,'a03e3cb8-289c-11ef-8e16-d517f37fa2ad','f125c583-289c-11ef-8e16-d517f37fa2ad','MANDIBLE_1'),(5,'a03e3cb8-289c-11ef-8e16-d517f37fa2ad','f1901fb9-289c-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(11,'a4bc6912-2980-11ef-8e16-d517f37fa2ad','08ff5fda-2981-11ef-8e16-d517f37fa2ad','MAXILLARY_1'),(11,'a4bc6912-2980-11ef-8e16-d517f37fa2ad','0f325523-2981-11ef-8e16-d517f37fa2ad','MAXILLARY_1'),(11,'a4bc6912-2980-11ef-8e16-d517f37fa2ad','0f32911d-2981-11ef-8e16-d517f37fa2ad','MANDIBLE_1'),(11,'a4bc6912-2980-11ef-8e16-d517f37fa2ad','1a586c71-2981-11ef-8e16-d517f37fa2ad','MAXILLARY_1'),(11,'a4bc6912-2980-11ef-8e16-d517f37fa2ad','1a58a6a3-2981-11ef-8e16-d517f37fa2ad','MANDIBLE_1'),(11,'a4bc6912-2980-11ef-8e16-d517f37fa2ad','43ea5aab-2981-11ef-8e16-d517f37fa2ad','MAXILLARY_1'),(11,'a4bc6912-2980-11ef-8e16-d517f37fa2ad','43ea9afd-2981-11ef-8e16-d517f37fa2ad','MANDIBLE_1'),(11,'a4bc6912-2980-11ef-8e16-d517f37fa2ad','7dc312cb-2981-11ef-8e16-d517f37fa2ad','METERING'),(11,'a4bc6912-2980-11ef-8e16-d517f37fa2ad','be9062f3-2982-11ef-8e16-d517f37fa2ad','SCREENSHOT'),(11,'a4bc6912-2980-11ef-8e16-d517f37fa2ad','dbaacc35-2982-11ef-8e16-d517f37fa2ad','SCREENSHOT'),(11,'a4bc6912-2980-11ef-8e16-d517f37fa2ad','dff96d3d-2980-11ef-8e16-d517f37fa2ad','MAXILLARY_1'),(11,'a4bc6912-2980-11ef-8e16-d517f37fa2ad','e01e29be-2980-11ef-8e16-d517f37fa2ad','MANDIBLE_1'),(11,'a4bc6912-2980-11ef-8e16-d517f37fa2ad','e09fbf20-2980-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(11,'a4bc6912-2980-11ef-8e16-d517f37fa2ad','e3ffe01f-2982-11ef-8e16-d517f37fa2ad','SCREENSHOT'),(11,'c472f797-2987-11ef-8e16-d517f37fa2ad','05998f46-2988-11ef-8e16-d517f37fa2ad','MAXILLARY_1'),(11,'c472f797-2987-11ef-8e16-d517f37fa2ad','fb017cf6-2987-11ef-8e16-d517f37fa2ad','MAXILLARY_1'),(11,'c472f797-2987-11ef-8e16-d517f37fa2ad','fb21655b-2987-11ef-8e16-d517f37fa2ad','MANDIBLE_1'),(11,'c472f797-2987-11ef-8e16-d517f37fa2ad','fbb6d74e-2987-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(2,'d7d76f34-2e3d-11ef-8deb-d515ea58f6cb','fb4d7f91-2e3d-11ef-8deb-d515ea58f6cb','MAXILLARY_1'),(2,'d7d76f34-2e3d-11ef-8deb-d515ea58f6cb','fb71a480-2e3d-11ef-8deb-d515ea58f6cb','MANDIBLE_1'),(2,'d7d76f34-2e3d-11ef-8deb-d515ea58f6cb','fc02156d-2e3d-11ef-8deb-d515ea58f6cb','SNAPSHOT'),(11,'e08676da-2990-11ef-8e16-d517f37fa2ad','1d51af59-2991-11ef-8e16-d517f37fa2ad','MAXILLARY_1'),(11,'e08676da-2990-11ef-8e16-d517f37fa2ad','1d6db867-2991-11ef-8e16-d517f37fa2ad','MANDIBLE_1'),(11,'e08676da-2990-11ef-8e16-d517f37fa2ad','1deb7d5b-2991-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(11,'e08676da-2990-11ef-8e16-d517f37fa2ad','25100b3e-2991-11ef-8e16-d517f37fa2ad','MAXILLARY_2'),(11,'e08676da-2990-11ef-8e16-d517f37fa2ad','37e226d3-2991-11ef-8e16-d517f37fa2ad','MAXILLARY_1'),(11,'e08676da-2990-11ef-8e16-d517f37fa2ad','37e2527a-2991-11ef-8e16-d517f37fa2ad','MANDIBLE_1'),(11,'e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd','4276476e-2a2b-11ef-8f1c-d8242c6fa8fd','MAXILLARY_1'),(11,'e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd','429a4668-2a2b-11ef-8f1c-d8242c6fa8fd','MANDIBLE_1'),(11,'e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd','432c5ac7-2a2b-11ef-8f1c-d8242c6fa8fd','SNAPSHOT'),(11,'e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd','7e144ea9-2a2b-11ef-8f1c-d8242c6fa8fd','MAXILLARY_1'),(11,'e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd','7e31fba5-2a2b-11ef-8f1c-d8242c6fa8fd','MANDIBLE_1'),(11,'e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd','b5074b88-2a2b-11ef-8f1c-d8242c6fa8fd','MAXILLARY_1'),(11,'e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd','d3b1d4dc-2a2b-11ef-8f1c-d8242c6fa8fd','LIFI'),(11,'e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd','d3b1e53c-2a2b-11ef-8f1c-d8242c6fa8fd','LIFIMETA'),(11,'e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd','e88dc6fc-2a2e-11ef-8f1c-d8242c6fa8fd','MANDIBLE_3'),(11,'e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd','e8a5635c-2a2e-11ef-8f1c-d8242c6fa8fd','LIFI'),(11,'e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd','e8a568de-2a2e-11ef-8f1c-d8242c6fa8fd','LIFIMETA'),(11,'e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd','ef33f313-2a2b-11ef-8f1c-d8242c6fa8fd','LIFI'),(11,'e7af3395-2a2a-11ef-8f1c-d8242c6fa8fd','ef341516-2a2b-11ef-8f1c-d8242c6fa8fd','LIFIMETA');
/*!40000 ALTER TABLE `OcclusionFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Office`
--

DROP TABLE IF EXISTS `Office`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Office` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `mainPhone` varchar(45) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `cityName` varchar(255) DEFAULT NULL,
  `cityZip` varchar(25) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `country` varchar(75) DEFAULT NULL,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  CONSTRAINT `Office_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Office`
--

LOCK TABLES `Office` WRITE;
/*!40000 ALTER TABLE `Office` DISABLE KEYS */;
INSERT INTO `Office` VALUES ('0022502d-b7d4-4f73-aeee-7fb7bdfc58f5',6,'123456','','','labege','','','France',NULL,'2024-06-06 10:47:25.000','2024-06-06 08:55:07.000','2024-06-06 10:55:07.000'),('1851efb6-58e7-4b73-b221-a63ec0947b77',2,'645636587','iris','','labège','31670','rue de Garance','France',NULL,'2024-06-04 10:35:34.000','2024-06-04 12:11:34.163','2024-06-04 14:11:34.163'),('2b879809-8839-11ec-89bc-2e174fce41cd',1,'0606060606','Biotech-Dental','','Toulouse','31100','Route du test','France',NULL,'2024-06-03 17:04:57.000','2024-06-03 15:04:57.000','2024-06-03 17:04:57.000'),('34e80856-a6f1-482a-8dd1-93fb4628b6a1',9,'65789076','','','gjygh','','','France',NULL,'2024-06-12 11:21:59.000','2024-06-12 09:24:19.000','2024-06-12 11:24:19.000'),('4335ce8d-69c6-4872-ac8f-3965a4c2d00f',10,'98345678','fsd','','Ffgjh','456','jbguy','France',NULL,'2024-06-12 11:50:49.000','2024-06-12 09:50:50.594','2024-06-12 11:50:50.594'),('4a6b3695-fa93-4a3f-9378-90bb33d7f846',5,'6543567543355667787','demo4 envi2','','dfdgfg','1111','hbgdsfdsfvkds','United States of America',NULL,'2024-06-12 12:06:44.000','2024-06-12 10:06:46.000','2024-06-12 12:06:46.000'),('69660fb1-f869-4a6d-ad8d-5934368b7e36',8,'','','','','','','',NULL,'2024-06-06 13:35:54.000','2024-06-06 11:35:54.000','2024-06-06 13:35:54.000'),('91ce098b-1c2e-41df-81e9-7920c88e5fcb',12,'123456789','Scalzo laboratory','','Labège','34670','rue guarance','France',NULL,'2024-06-20 09:50:49.000','2024-06-20 07:50:49.000','2024-06-20 09:50:49.000'),('932f76a3-95ec-4bb5-8f88-ca34a4f3f172',4,'123123','azerty','','sdfdsgsd','11111','djfhgjfdhg','France',NULL,'2024-06-04 11:24:55.000','2024-06-04 09:24:55.000','2024-06-04 11:24:55.000'),('9cc0b042-5013-47eb-92f3-8311f259d8e0',3,'1234567','Laboratoire Scan4all','','salles d\'aude','11110','av. de Fleury','France',NULL,'2024-06-04 10:40:35.000','2024-06-04 08:40:39.764','2024-06-04 10:40:39.764'),('b01f8f4e-2948-4022-b79e-b9e2986b47ea',11,'12345678','SCALZO','','Labège','31670','rue Garance','France',NULL,'2024-06-13 10:39:12.000','2024-06-13 08:39:15.718','2024-06-13 10:39:15.718'),('ff6f0621-4da2-4a18-9852-46415a48170e',7,'','','','','','','',NULL,'2024-06-06 12:16:54.000','2024-06-06 10:16:54.000','2024-06-06 12:16:54.000');
/*!40000 ALTER TABLE `Office` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PersonInfo`
--

DROP TABLE IF EXISTS `PersonInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `PersonInfo` (
  `uuid` varchar(36) NOT NULL,
  `firstname` varchar(64) NOT NULL,
  `lastname` varchar(64) NOT NULL,
  `email` varchar(255) NOT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PersonInfo`
--

LOCK TABLES `PersonInfo` WRITE;
/*!40000 ALTER TABLE `PersonInfo` DISABLE KEYS */;
INSERT INTO `PersonInfo` VALUES ('08ea5eaa-7ae4-4bfb-b7b0-4672e82009b2','Assist1','acc4','assist1@mail.com','2024-06-12 10:03:15.706','2024-06-12 12:03:48.889'),('2ce3a36c-5e54-412a-8e7c-0aa89dba07f8','succursalle Salles d\'aude','laboratoire scan4all','alertes.documentation@scan4all.fr','2024-06-06 12:49:21.000','2024-06-13 10:54:45.000'),('322d8fa4-c617-4f72-9c2e-1733a99f3277','demo4','demo4env2','azerty4@az.fr','2024-06-04 09:28:57.806','2024-06-12 12:06:46.000'),('3e59e29a-8ed6-422a-a6b9-66c5036e5725','sabine','casertA','sabine.caserta@scan4all.fr','2024-06-06 08:24:33.000','2024-06-13 10:47:51.000'),('4114e703-8838-11ec-89bc-2e174fce41cd','Biotech-Dental','LABORATOIRE','lab@biotech-dental.pro','2024-06-03 15:04:56.000','2024-06-03 17:04:56.000'),('750b8eb8-5ce2-437f-82f4-4a47e5fefd5f','demo3','demo3env1','azerty3@az.fr','2024-06-04 09:24:55.000','2024-06-18 15:19:14.000'),('83537036-7322-455c-a4af-7fff1c61122a','','','azerty@scan4all.fr','2024-06-06 11:35:54.000','2024-06-06 13:35:54.000'),('8bb7d06d-0faf-4fbe-9a3e-bf2a50402277','assistant2','IRISassisi','azerty5@az.fr','2024-06-04 12:32:17.000','2024-06-04 14:35:11.000'),('9912c079-ecc5-426a-bf78-e412defe60cd','','','sabine.caserta@live.fr','2024-06-06 10:16:54.000','2024-06-06 12:16:55.000'),('c208b840-b364-4de3-98b1-1562ad5741f2','simone','scalzo','simone.scalzo@test.fr','2024-06-20 07:50:49.000','2024-06-20 11:27:46.000'),('c6949870-aad4-405d-8503-e57cac38673b','client','leger','gamajesas@hotmail.fr','2024-06-06 08:55:07.000','2024-06-06 10:55:07.000'),('d939a5a9-9909-4a42-ac38-ee896b52ab7f','simone','scalzo','tests@ze.fr','2024-06-13 08:39:15.700','2024-06-20 14:19:39.000'),('e1fdc45a-71cd-4786-91aa-24b8c296e795','assitenti','assistenti','assistenti@az.fr','2024-06-14 09:34:06.465','2024-06-19 11:30:07.298'),('ea8bca69-75b7-4877-8406-eca77b86cb2f','assistant1','irisassis1','poiu1@az.fr','2024-06-04 12:15:38.000','2024-06-04 14:18:32.000'),('eb68eb7a-9e4a-43c7-858c-be1959debc3a','Web','User','test.application@scan4all.fr','2024-06-12 09:24:19.000','2024-06-12 11:24:19.000'),('ffec7cdf-8456-406a-843f-776773b00f24','User_demo5','Env2','thi-hai-ha.phung@scan4all.fr','2024-06-12 12:41:34.000','2024-06-13 09:38:49.000');
/*!40000 ALTER TABLE `PersonInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PhoneInfo`
--

DROP TABLE IF EXISTS `PhoneInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `PhoneInfo` (
  `uuid` varchar(36) NOT NULL,
  `phone` varchar(45) DEFAULT NULL,
  `cellular` varchar(45) DEFAULT NULL,
  `fax` varchar(45) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PhoneInfo`
--

LOCK TABLES `PhoneInfo` WRITE;
/*!40000 ALTER TABLE `PhoneInfo` DISABLE KEYS */;
INSERT INTO `PhoneInfo` VALUES ('0bb18e78-11bc-4d5d-8f1e-3b8cd38dc1df','123123','','','2024-06-04 09:24:55.000','2024-06-18 15:19:14.000'),('132c8d8b-90f5-472b-ad0c-584767f83050','','','','2024-06-06 11:35:54.000','2024-06-06 13:35:54.000'),('1464e4c7-4c1f-4415-8f0f-9e1609403e4b','98345678','','','2024-06-12 09:50:50.558','2024-06-13 09:38:49.000'),('181dec75-7fb5-4d17-8bd9-d6a9f0c0881d','123451','','','2024-06-14 09:34:06.467','2024-06-19 11:30:07.298'),('20c3d3f1-dcaa-4a2e-8e37-c50f4a01a441','1234567','','','2024-06-06 12:45:26.000','2024-06-13 10:54:45.000'),('26286661-ce2e-44d4-abe0-ef956962c406','','','','2024-06-06 10:16:54.000','2024-06-06 12:16:55.000'),('47ead308-8838-11ec-89bc-2e174fce41cd','0606060606','','','2024-06-03 15:04:56.000','2024-06-03 17:04:56.000'),('4eb53929-4a5b-4b46-9120-f82742828aa7','12345678','','','2024-06-13 08:39:15.700','2024-06-20 14:19:39.000'),('5006bb20-b217-4f74-9b31-713022d3924c','6456365873','','','2024-06-06 08:24:38.000','2024-06-13 10:47:51.000'),('8caa4c94-c597-4679-ba07-d658d15edbb0','','','','2024-06-04 12:32:17.000','2024-06-04 14:35:11.000'),('a5f7ca50-276b-4d1b-a1a9-377f6edcfc4f','123456','','','2024-06-06 08:55:07.000','2024-06-06 10:55:07.000'),('a8b2657e-dca8-42a8-a6cd-7b3dfcdacfac','','','','2024-06-04 12:15:38.000','2024-06-04 14:18:32.000'),('c212da4b-d5a5-4500-b9b9-e34b0c66fd0b','6543567543355667787','','','2024-06-04 09:28:57.811','2024-06-12 12:06:46.000'),('d8973faa-2f83-4698-9f04-22dd05367345','65789076','','','2024-06-12 09:24:19.000','2024-06-12 11:24:19.000'),('db262193-346e-4bf6-9240-112d28c9e66d','56578888','','','2024-06-12 10:03:15.708','2024-06-12 12:03:48.889'),('e20c4971-b8f0-42e2-be16-89039d50bce2','123456789','','','2024-06-20 07:50:49.000','2024-06-20 11:27:46.000');
/*!40000 ALTER TABLE `PhoneInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Professional`
--

DROP TABLE IF EXISTS `Professional`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Professional` (
  `uuid` varchar(36) NOT NULL,
  `id` mediumint(8) unsigned NOT NULL,
  `credentialsId` varchar(36) DEFAULT NULL,
  `personInfoId` varchar(36) NOT NULL,
  `phoneInfoId` varchar(36) NOT NULL,
  `addressInfoId` varchar(36) NOT NULL,
  `configId` mediumint(8) unsigned DEFAULT NULL,
  `syncInfoId` mediumint(8) unsigned DEFAULT NULL,
  `surgeryName` varchar(255) DEFAULT NULL,
  `comments` text DEFAULT NULL,
  `type` enum('UNDEFINED','PROTHESIST','DENTIST','DEMO','OTHER') NOT NULL DEFAULT 'UNDEFINED',
  `activeComputers` mediumint(8) unsigned DEFAULT NULL,
  `limitedContactId` varchar(36) DEFAULT NULL,
  `directoryVisible` tinyint(1) NOT NULL DEFAULT 1,
  `statusGalaxy` tinyint(1) DEFAULT 0,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  UNIQUE KEY `personInfoId` (`personInfoId`),
  UNIQUE KEY `phoneInfoId` (`phoneInfoId`),
  UNIQUE KEY `addressInfoId` (`addressInfoId`),
  UNIQUE KEY `credentialsId` (`credentialsId`),
  KEY `syncInfoId` (`syncInfoId`,`id`),
  KEY `configId` (`configId`,`id`),
  CONSTRAINT `Professional_ibfk_1` FOREIGN KEY (`credentialsId`) REFERENCES `Credentials` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_2` FOREIGN KEY (`personInfoId`) REFERENCES `PersonInfo` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_3` FOREIGN KEY (`phoneInfoId`) REFERENCES `PhoneInfo` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_4` FOREIGN KEY (`addressInfoId`) REFERENCES `AddressInfo` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_5` FOREIGN KEY (`syncInfoId`, `id`) REFERENCES `SyncInfo` (`id`, `ownerId`) ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_6` FOREIGN KEY (`configId`, `id`) REFERENCES `Config` (`id`, `ownerId`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Professional`
--

LOCK TABLES `Professional` WRITE;
/*!40000 ALTER TABLE `Professional` DISABLE KEYS */;
INSERT INTO `Professional` VALUES ('71b743e8-8838-11ec-89bc-2e174fce41cd',1,'2e995095-88b2-11ec-89bc-2e174fce41cd','4114e703-8838-11ec-89bc-2e174fce41cd','47ead308-8838-11ec-89bc-2e174fce41cd','4caacc66-8838-11ec-89bc-2e174fce41cd',1,1,'','','PROTHESIST',0,NULL,1,0,NULL,'2024-06-03 17:04:56.000','2024-06-03 15:04:56.000','2024-06-03 17:04:56.000'),('4a2ae9c9-fa00-41ed-a598-31b94c8b8955',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','3e59e29a-8ed6-422a-a6b9-66c5036e5725','5006bb20-b217-4f74-9b31-713022d3924c','7780848c-b087-4217-b3a5-e8cb992abbae',1,1,'','','DENTIST',3,NULL,1,0,NULL,'2024-06-06 10:24:38.000','2024-06-13 08:47:51.000','2024-06-13 10:47:51.000'),('8df2a258-8868-49b7-91c2-e2d41d48bffc',3,'adc06de1-bf5d-4b1a-81dc-e5e919328b7c','2ce3a36c-5e54-412a-8e7c-0aa89dba07f8','20c3d3f1-dcaa-4a2e-8e37-c50f4a01a441','a22123da-17c2-438f-97f9-9845680a644b',1,1,'','','DENTIST',2,NULL,1,0,NULL,'2024-06-06 14:49:21.000','2024-06-13 08:54:45.000','2024-06-13 10:54:45.000'),('38094558-549f-40bd-9a81-6301be7324e4',4,'7a0e3a28-a28c-4323-92c1-8831f0d6815b','750b8eb8-5ce2-437f-82f4-4a47e5fefd5f','0bb18e78-11bc-4d5d-8f1e-3b8cd38dc1df','c8db9302-3511-4c3f-b38d-de29e76d9f03',1,1,'','','DENTIST',2,NULL,1,0,NULL,'2024-06-18 15:19:14.000','2024-06-18 13:19:14.000','2024-06-18 15:19:14.000'),('4e72ba02-814f-4116-88da-65f8da1fa385',5,'b35f432d-f5a0-4048-b2dc-1eb3596a89a1','322d8fa4-c617-4f72-9c2e-1733a99f3277','c212da4b-d5a5-4500-b9b9-e34b0c66fd0b','a521e3a9-ad56-413f-990f-60c7817d6962',1,1,'','','DENTIST',1,NULL,1,0,NULL,'2024-06-04 11:28:58.000','2024-06-12 10:06:46.000','2024-06-12 12:06:46.000'),('775748d0-cbb7-4078-a68c-63c2bc78959b',6,'357013df-fab4-4e08-a0b3-25be5d10fb9e','c6949870-aad4-405d-8503-e57cac38673b','a5f7ca50-276b-4d1b-a1a9-377f6edcfc4f','5440e4c6-0dfa-455e-b4bc-20352f964660',1,1,'','','PROTHESIST',2,NULL,1,0,NULL,'2024-06-06 10:47:25.000','2024-06-06 08:55:07.000','2024-06-06 10:55:07.000'),('40a842ef-8aad-4e46-b586-08781f98a720',7,NULL,'9912c079-ecc5-426a-bf78-e412defe60cd','26286661-ce2e-44d4-abe0-ef956962c406','b625ed42-6f59-4c23-bfe5-3740f8716d69',1,1,'','','UNDEFINED',21947,NULL,1,0,NULL,'2024-06-06 12:16:54.000','2024-06-06 10:16:55.000','2024-06-06 12:16:55.000'),('d9bc63ab-c100-4bcf-9b37-bc0c4f091c5c',8,NULL,'83537036-7322-455c-a4af-7fff1c61122a','132c8d8b-90f5-472b-ad0c-584767f83050','500b8a2a-af0c-40fb-ae0b-51f88f080fd3',1,1,'','','UNDEFINED',0,NULL,1,0,NULL,'2024-06-06 13:35:54.000','2024-06-06 11:35:54.000','2024-06-06 13:35:54.000'),('79394d4c-40ca-4966-b8ae-51471aedb8a2',9,'5e4021c3-eb63-4c78-98e3-e52e93179159','eb68eb7a-9e4a-43c7-858c-be1959debc3a','d8973faa-2f83-4698-9f04-22dd05367345','b80e9030-b10a-4682-8fd0-28bff28b0c5f',1,1,'','','PROTHESIST',0,NULL,1,0,NULL,'2024-06-12 11:21:58.000','2024-06-12 09:24:19.000','2024-06-12 11:24:19.000'),('ac6eb009-e729-4bcf-935b-d16a92d3df2c',10,'e777d5c7-3598-4093-b42c-8342c0d4d52e','ffec7cdf-8456-406a-843f-776773b00f24','1464e4c7-4c1f-4415-8f0f-9e1609403e4b','09d83830-5ef8-49ee-8a40-4089336cd88e',1,1,'','','PROTHESIST',1,NULL,1,0,NULL,'2024-06-12 14:41:31.000','2024-06-13 07:38:49.000','2024-06-13 09:38:49.000'),('de198d52-1413-4336-bc67-f6b5586d29fc',11,'66d7dc11-0d36-4d25-9823-f7f0c1d1f38a','d939a5a9-9909-4a42-ac38-ee896b52ab7f','4eb53929-4a5b-4b46-9120-f82742828aa7','9e59686f-6b72-4c58-b004-da11a3b48afd',1,1,'','','DENTIST',3,NULL,1,0,NULL,'2024-06-20 14:19:39.000','2024-06-20 12:19:39.000','2024-06-20 14:19:39.000'),('10482dfb-02bf-4241-972f-2823da6c01ce',12,'2f905a47-4c1c-4733-a6c0-6850e9be6b5f','c208b840-b364-4de3-98b1-1562ad5741f2','e20c4971-b8f0-42e2-be16-89039d50bce2','8b9099a7-67d1-4aca-aca7-5842f0768d4a',1,1,'','','DENTIST',1,NULL,1,0,NULL,'2024-06-20 09:50:51.000','2024-06-20 09:27:46.000','2024-06-20 11:27:46.000');
/*!40000 ALTER TABLE `Professional` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProfessionalEnvInfos`
--

DROP TABLE IF EXISTS `ProfessionalEnvInfos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProfessionalEnvInfos` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `accessCode` varchar(45) DEFAULT NULL,
  `status` enum('CREATED','CONFIRMED','BLOCKED') NOT NULL DEFAULT 'CREATED',
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`ownerId`),
  CONSTRAINT `ProfessionalEnvInfos_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProfessionalEnvInfos`
--

LOCK TABLES `ProfessionalEnvInfos` WRITE;
/*!40000 ALTER TABLE `ProfessionalEnvInfos` DISABLE KEYS */;
INSERT INTO `ProfessionalEnvInfos` VALUES (1,'','CONFIRMED','2024-06-04 09:28:58.696','2024-06-04 11:28:58.696'),(2,'','CONFIRMED','2024-06-04 10:25:11.613','2024-06-04 12:25:11.613'),(3,'','CONFIRMED','2024-06-04 08:40:39.762','2024-06-04 10:40:39.762'),(4,'','CONFIRMED','2024-06-04 12:11:34.991','2024-06-04 14:11:34.991'),(5,'','CONFIRMED','2024-06-04 09:28:57.837','2024-06-04 11:28:57.837'),(6,'','CONFIRMED','2024-06-06 08:55:10.894','2024-06-06 10:55:10.894'),(7,'1df15635','CREATED','2024-06-06 11:35:28.008','2024-06-06 13:35:28.008'),(8,'f2743369','CREATED','2024-06-06 11:35:57.304','2024-06-06 13:35:57.304'),(9,'','CONFIRMED','2024-06-12 09:24:19.645','2024-06-12 11:24:19.645'),(10,'','CONFIRMED','2024-06-12 09:50:50.587','2024-06-12 11:50:50.587'),(11,'','CONFIRMED','2024-06-13 08:39:15.717','2024-06-13 10:39:15.717'),(12,'','CONFIRMED','2024-06-20 09:22:38.861','2024-06-20 11:22:38.861');
/*!40000 ALTER TABLE `ProfessionalEnvInfos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProfessionalPatient`
--

DROP TABLE IF EXISTS `ProfessionalPatient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProfessionalPatient` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `patientId` varchar(36) NOT NULL,
  `officeId` varchar(36) DEFAULT NULL,
  `enablePatientSharing` tinyint(1) DEFAULT 0,
  `pinned` tinyint(1) NOT NULL DEFAULT 0,
  `theme` enum('NONE','ADULT','BOY','GIRL','BABY') DEFAULT 'NONE',
  PRIMARY KEY (`ownerId`,`patientId`),
  KEY `patientId` (`patientId`),
  KEY `officeId` (`officeId`),
  CONSTRAINT `ProfessionalPatient_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `ProfessionalPatient_ibfk_2` FOREIGN KEY (`patientId`) REFERENCES `iris_patient`.`Patient` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `ProfessionalPatient_ibfk_3` FOREIGN KEY (`officeId`) REFERENCES `Office` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProfessionalPatient`
--

LOCK TABLES `ProfessionalPatient` WRITE;
/*!40000 ALTER TABLE `ProfessionalPatient` DISABLE KEYS */;
INSERT INTO `ProfessionalPatient` VALUES (2,'115617bc-2e4b-11ef-8deb-d515ea58f6cb','1851efb6-58e7-4b73-b221-a63ec0947b77',0,0,'NONE'),(2,'172f299e-2e0d-11ef-8deb-d515ea58f6cb','1851efb6-58e7-4b73-b221-a63ec0947b77',0,0,'NONE'),(2,'309e7124-2e35-11ef-8deb-d515ea58f6cb','1851efb6-58e7-4b73-b221-a63ec0947b77',0,0,'NONE'),(2,'312c74c3-2735-11ef-8e16-d517f37fa1ab','1851efb6-58e7-4b73-b221-a63ec0947b77',0,0,'NONE'),(2,'3573ee42-27cb-11ef-8e37-d519fa9d22d2','1851efb6-58e7-4b73-b221-a63ec0947b77',0,0,'NONE'),(2,'4382037a-2735-11ef-8e16-d517f37fa1ab','1851efb6-58e7-4b73-b221-a63ec0947b77',0,0,'NONE'),(2,'5062e053-298a-11ef-8e16-d517f37fa2ad','1851efb6-58e7-4b73-b221-a63ec0947b77',0,0,'NONE'),(2,'520a1417-2735-11ef-8e16-d517f37fa1ab','1851efb6-58e7-4b73-b221-a63ec0947b77',0,0,'NONE'),(2,'791bd8ac-227d-11ef-8f8c-d92a43d45d56','1851efb6-58e7-4b73-b221-a63ec0947b77',0,0,'NONE'),(2,'8ad69496-273a-11ef-8e16-d517f37fa1ab','1851efb6-58e7-4b73-b221-a63ec0947b77',0,0,'NONE'),(2,'8f5ceea7-2740-11ef-8e09-d517f1736dc8','1851efb6-58e7-4b73-b221-a63ec0947b77',0,0,'NONE'),(2,'a1ace9b5-2271-11ef-8d76-d310d2ec2c14','1851efb6-58e7-4b73-b221-a63ec0947b77',0,0,'NONE'),(2,'b6e444c5-2fa5-11ef-8e5c-d61b03bfb54e','1851efb6-58e7-4b73-b221-a63ec0947b77',0,0,'NONE'),(2,'b6f9b0de-273a-11ef-8e16-d517f37fa1ab','1851efb6-58e7-4b73-b221-a63ec0947b77',0,0,'NONE'),(2,'b8993188-273d-11ef-8e09-d517f1736dc8','1851efb6-58e7-4b73-b221-a63ec0947b77',0,0,'NONE'),(2,'ce57500b-227c-11ef-8d76-d310d2ec2c14','1851efb6-58e7-4b73-b221-a63ec0947b77',0,0,'NONE'),(2,'dc803a78-225a-11ef-8f1f-d8242c71b430','1851efb6-58e7-4b73-b221-a63ec0947b77',0,0,'NONE'),(2,'e67ea834-2fa4-11ef-8e5c-d61b03bfb54e','1851efb6-58e7-4b73-b221-a63ec0947b77',0,0,'NONE'),(2,'f3e99d3d-272f-11ef-8e16-d517f37fa1ab','1851efb6-58e7-4b73-b221-a63ec0947b77',0,0,'NONE'),(2,'f6d6ceba-273a-11ef-8e16-d517f37fa1ab','1851efb6-58e7-4b73-b221-a63ec0947b77',0,0,'NONE'),(3,'6220e0d7-2255-11ef-8e3f-d619fca54465','9cc0b042-5013-47eb-92f3-8311f259d8e0',0,0,'NONE'),(3,'834afe1e-2343-11ef-8f85-d92942ce45ec','9cc0b042-5013-47eb-92f3-8311f259d8e0',0,0,'NONE'),(3,'907398e3-23e7-11ef-8dde-d415e84cc4f5','9cc0b042-5013-47eb-92f3-8311f259d8e0',0,0,'NONE'),(5,'09f7c5e2-28bb-11ef-8e16-d517f37fa2ad','4a6b3695-fa93-4a3f-9378-90bb33d7f846',0,0,'NONE'),(5,'82c4f551-28bf-11ef-8e16-d517f37fa2ad','4a6b3695-fa93-4a3f-9378-90bb33d7f846',0,0,'NONE'),(5,'a49d8d6e-28b9-11ef-8e16-d517f37fa2ad','4a6b3695-fa93-4a3f-9378-90bb33d7f846',0,0,'NONE'),(5,'a9fa9552-28c9-11ef-8e16-d517f37fa2ad','4a6b3695-fa93-4a3f-9378-90bb33d7f846',0,0,'NONE'),(5,'f373c86a-2899-11ef-8e16-d517f37fa2ad','4a6b3695-fa93-4a3f-9378-90bb33d7f846',0,0,'NONE'),(11,'0fedc3b4-2961-11ef-8e16-d517f37fa2ad','b01f8f4e-2948-4022-b79e-b9e2986b47ea',0,0,'NONE'),(11,'269e882c-2961-11ef-8e16-d517f37fa2ad','b01f8f4e-2948-4022-b79e-b9e2986b47ea',0,0,'NONE'),(11,'9cd27370-2960-11ef-8e16-d517f37fa2ad','b01f8f4e-2948-4022-b79e-b9e2986b47ea',0,0,'NONE'),(11,'b4934f39-2960-11ef-8e16-d517f37fa2ad','b01f8f4e-2948-4022-b79e-b9e2986b47ea',0,0,'NONE'),(11,'b7e05748-2e0c-11ef-8deb-d515ea58f6cb','b01f8f4e-2948-4022-b79e-b9e2986b47ea',0,0,'NONE'),(11,'d19dfd5f-2974-11ef-8e16-d517f37fa2ad','b01f8f4e-2948-4022-b79e-b9e2986b47ea',0,0,'NONE'),(11,'eb10a1b6-2960-11ef-8e16-d517f37fa2ad','b01f8f4e-2948-4022-b79e-b9e2986b47ea',0,0,'NONE');
/*!40000 ALTER TABLE `ProfessionalPatient` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrder`
--

DROP TABLE IF EXISTS `ProstheticOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProstheticOrder` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `actId` varchar(36) NOT NULL,
  `title` varchar(64) DEFAULT NULL,
  `status` enum('NOT_SENT','SENT','DATE_VALIDATED','DATE_EDITED','VALIDATED','CANCELLED','DELIVERY') NOT NULL DEFAULT 'NOT_SENT',
  `unread` tinyint(1) DEFAULT 0,
  `currentDeliveryDate` datetime(3) DEFAULT NULL,
  `previousDeliveryDate` datetime(3) DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT 0,
  `displayId` mediumint(8) unsigned DEFAULT NULL,
  `pcId` mediumint(8) unsigned DEFAULT NULL,
  `createdById` varchar(36) DEFAULT NULL,
  `updatedById` varchar(36) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `actId` (`actId`),
  CONSTRAINT `ProstheticOrder_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrder_ibfk_2` FOREIGN KEY (`actId`) REFERENCES `Act` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrder`
--

LOCK TABLES `ProstheticOrder` WRITE;
/*!40000 ALTER TABLE `ProstheticOrder` DISABLE KEYS */;
INSERT INTO `ProstheticOrder` VALUES ('01038baa-297d-11ef-8e16-d517f37fa2ad',11,'00fde810-297d-11ef-8e16-d517f37fa2ad','Ordini 2.1','NOT_SENT',1,NULL,NULL,1,1,1,'de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-13 14:03:53.643','2024-06-13 14:08:56.937','2024-06-13 14:08:56.937','2024-06-13 12:08:56.938',NULL),('0187211b-28a0-11ef-8e16-d517f37fa2ad',5,'627cfe1c-289b-11ef-8e16-d517f37fa2ad','Commande 1.2','CANCELLED',0,'2024-06-29 00:00:00.000',NULL,0,3,1,'4e72ba02-814f-4116-88da-65f8da1fa385','4e72ba02-814f-4116-88da-65f8da1fa385','2024-06-12 11:41:55.000',NULL,'2024-06-12 11:46:47.000','2024-06-12 09:46:47.000','2024-06-12 11:46:47.000'),('05654240-27cb-11ef-8e37-d519fa9d22d2',2,'eadc6274-27ca-11ef-8e37-d519fa9d22d2','Commande 7.3','NOT_SENT',1,NULL,NULL,1,1,2,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-11 10:17:19.414',NULL,'2024-06-11 10:17:19.418','2024-06-11 08:17:19.418',NULL),('08f4c372-2980-11ef-8e16-d517f37fa2ad',11,'08eb58c6-2980-11ef-8e16-d517f37fa2ad','Ordini 5.5','CANCELLED',0,'2024-06-14 00:00:00.000',NULL,0,1,1,'de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-13 14:25:35.000',NULL,'2024-06-13 15:06:45.000','2024-06-13 13:06:45.000','2024-06-13 15:06:45.000'),('0bd68b18-23e9-11ef-8dde-d415e84cc4f5',3,'0bcc91ed-23e9-11ef-8dde-d415e84cc4f5','Commande 2.2','DATE_EDITED',0,'2024-06-08 00:00:00.000','2024-06-07 00:00:00.000',0,1,1,'8df2a258-8868-49b7-91c2-e2d41d48bffc','8df2a258-8868-49b7-91c2-e2d41d48bffc','2024-06-06 11:42:10.000',NULL,'2024-06-06 11:58:24.000','2024-06-06 09:58:24.000','2024-06-06 11:58:24.000'),('0bec570d-273b-11ef-8e16-d517f37fa1ab',2,'0be66d2e-273b-11ef-8e16-d517f37fa1ab','Commande 10.1','NOT_SENT',1,NULL,NULL,1,1,2,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-10 17:06:42.836','2024-06-10 17:07:19.449','2024-06-10 17:07:19.449','2024-06-10 15:07:19.450',NULL),('0d191b14-289a-11ef-8e16-d517f37fa2ad',5,'0d1289f0-289a-11ef-8e16-d517f37fa2ad','Commande 1.1','CANCELLED',0,'2024-06-28 00:00:00.000','2024-06-22 00:00:00.000',0,1,1,'4e72ba02-814f-4116-88da-65f8da1fa385','4e72ba02-814f-4116-88da-65f8da1fa385','2024-06-12 10:59:18.000',NULL,'2024-06-12 11:40:41.000','2024-06-12 09:40:43.000','2024-06-12 11:40:43.000'),('1195a226-28bb-11ef-8e16-d517f37fa2ad',5,'118f12a1-28bb-11ef-8e16-d517f37fa2ad','Commande 3.1','NOT_SENT',1,NULL,NULL,1,1,1,'4e72ba02-814f-4116-88da-65f8da1fa385','4e72ba02-814f-4116-88da-65f8da1fa385','2024-06-12 14:55:39.079',NULL,'2024-06-12 14:55:39.084','2024-06-12 12:55:39.085',NULL),('15fd7f91-2e4b-11ef-8deb-d515ea58f6cb',2,'15f71dc7-2e4b-11ef-8deb-d515ea58f6cb','Order 17.1 [pc2]','DATE_VALIDATED',0,'2024-06-20 00:00:00.000',NULL,0,1,2,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-19 16:49:10.000',NULL,'2024-06-19 16:57:59.000','2024-06-19 14:57:59.000','2024-06-19 16:57:59.000'),('164af3dc-2e43-11ef-8deb-d515ea58f6cb',2,'164199d1-2e43-11ef-8deb-d515ea58f6cb','Order 6.5 [pc2]','DATE_VALIDATED',0,'2024-06-21 00:00:00.000',NULL,0,1,2,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-19 15:51:54.000',NULL,'2024-06-19 15:55:43.000','2024-06-19 13:55:43.000','2024-06-19 15:55:43.000'),('1b97a50e-2e0d-11ef-8deb-d515ea58f6cb',2,'1b9240f4-2e0d-11ef-8deb-d515ea58f6cb','Ordini 15.1 [pc2]','NOT_SENT',1,NULL,NULL,1,1,2,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-19 09:25:31.059',NULL,'2024-06-19 09:25:31.065','2024-06-19 07:25:31.066',NULL),('1cba063b-271f-11ef-8e16-d517f37fa1ab',2,'1cb775ae-271f-11ef-8e16-d517f37fa1ab','Commande 2.2','DATE_EDITED',0,'2024-06-12 00:00:00.000','2024-06-11 00:00:00.000',0,1,2,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-10 13:46:45.000',NULL,'2024-06-10 16:49:09.000','2024-06-10 14:49:09.000','2024-06-10 16:49:09.000'),('22749c4a-2e42-11ef-8deb-d515ea58f6cb',2,'8598ee4a-2e40-11ef-8deb-d515ea58f6cb','Order 6.3 [pc2]','VALIDATED',0,'2024-06-21 00:00:00.000','2024-06-23 00:00:00.000',0,3,2,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-19 15:45:05.000',NULL,'2024-06-19 17:07:23.000','2024-06-19 15:07:24.000','2024-06-19 17:07:24.000'),('2b43e016-28ca-11ef-8e16-d517f37fa2ad',5,'6a002ae5-28c9-11ef-8e16-d517f37fa2ad','Commande 5.1','NOT_SENT',1,NULL,NULL,1,1,1,'4e72ba02-814f-4116-88da-65f8da1fa385','4e72ba02-814f-4116-88da-65f8da1fa385','2024-06-12 16:43:44.615',NULL,'2024-06-12 16:43:44.621','2024-06-12 14:43:44.621',NULL),('36573909-2e35-11ef-8deb-d515ea58f6cb',2,'3654e763-2e35-11ef-8deb-d515ea58f6cb','Ordini 16.1 [pc2]','NOT_SENT',1,NULL,NULL,1,1,2,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-19 14:12:35.805',NULL,'2024-06-19 14:12:35.807','2024-06-19 12:12:35.807',NULL),('469fbbe0-27cb-11ef-8e37-d519fa9d22d2',2,'46997caf-27cb-11ef-8e37-d519fa9d22d2','Commande 13.1','NOT_SENT',1,NULL,NULL,1,1,2,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-11 10:19:08.849',NULL,'2024-06-11 10:36:57.015','2024-06-11 08:36:57.015',NULL),('470ab6fc-2963-11ef-8e16-d517f37fa2ad',11,'4704a021-2963-11ef-8e16-d517f37fa2ad','Ordini 5.1','VALIDATED',0,'2024-06-16 00:00:00.000','2024-06-14 00:00:00.000',0,1,1,'de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-13 10:59:44.000',NULL,'2024-06-13 15:14:29.000','2024-06-13 13:14:31.000','2024-06-13 15:14:31.000'),('4ba706eb-2987-11ef-8e16-d517f37fa2ad',11,'4ba13230-2987-11ef-8e16-d517f37fa2ad','Ordini 4.1','SENT',0,'2024-06-23 00:00:00.000',NULL,0,1,1,'de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-13 15:17:33.000',NULL,'2024-06-13 15:23:47.000','2024-06-13 13:23:49.000','2024-06-13 15:23:49.000'),('54f2a3d2-273a-11ef-8e16-d517f37fa1ab',2,'54ecb28b-273a-11ef-8e16-d517f37fa1ab','Commande 7.1','NOT_SENT',1,NULL,NULL,1,1,2,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-10 17:01:35.855',NULL,'2024-06-10 17:01:35.858','2024-06-10 15:01:35.859',NULL),('58f912aa-298a-11ef-8e16-d517f37fa2ad',2,'58f22a30-298a-11ef-8e16-d517f37fa2ad','Commande 14.1','NOT_SENT',1,NULL,NULL,1,1,2,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-13 15:39:24.672',NULL,'2024-06-13 15:39:24.677','2024-06-13 13:39:24.677',NULL),('5f367bea-27f1-11ef-8e37-d519fa9d22d2',2,'5f30ec6f-27f1-11ef-8e37-d519fa9d22d2','Commande 11.3','NOT_SENT',1,NULL,NULL,1,1,2,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-11 14:51:50.978',NULL,'2024-06-11 14:51:50.980','2024-06-11 12:51:50.980',NULL),('5f4d6750-28bf-11ef-8e16-d517f37fa2ad',5,'5f4774a2-28bf-11ef-8e16-d517f37fa2ad','Commande 3.2','NOT_SENT',1,NULL,NULL,1,1,1,'4e72ba02-814f-4116-88da-65f8da1fa385','4e72ba02-814f-4116-88da-65f8da1fa385','2024-06-12 15:26:27.454',NULL,'2024-06-12 17:58:17.945','2024-06-12 15:58:17.946',NULL),('6282c146-289b-11ef-8e16-d517f37fa2ad',5,'627cfe1c-289b-11ef-8e16-d517f37fa2ad','Commande 1.2','CANCELLED',0,'2024-06-14 00:00:00.000',NULL,0,1,1,'4e72ba02-814f-4116-88da-65f8da1fa385','4e72ba02-814f-4116-88da-65f8da1fa385','2024-06-12 11:08:50.000',NULL,'2024-06-12 11:33:20.000','2024-06-12 09:33:20.000','2024-06-12 11:33:20.000'),('62bf4a87-226c-11ef-8d76-d310d2ec2c14',2,'62b97c61-226c-11ef-8d76-d310d2ec2c14','Commande 1.1','SENT',0,'2024-06-05 00:00:00.000',NULL,0,1,2,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-04 14:17:18.000',NULL,'2024-06-04 15:00:22.000','2024-06-04 13:00:23.000','2024-06-04 15:00:23.000'),('68b5196a-2e42-11ef-8deb-d515ea58f6cb',2,'68af0333-2e42-11ef-8deb-d515ea58f6cb','Order 6.4 [pc2]','VALIDATED',0,'2024-06-23 00:00:00.000','2024-06-20 00:00:00.000',0,1,2,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-19 15:47:03.000',NULL,'2024-06-19 15:50:30.000','2024-06-19 13:54:11.000','2024-06-19 15:54:11.000'),('72bf1875-2a20-11ef-8f1c-d8242c6fa8fd',11,'72b8db7f-2a20-11ef-8f1c-d8242c6fa8fd','Ordini 3.1','NOT_SENT',1,NULL,NULL,1,1,1,'de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-14 09:33:53.942','2024-06-14 10:38:31.795','2024-06-14 10:38:31.795','2024-06-14 08:38:31.797',NULL),('78bd1c4c-2255-11ef-8e3f-d619fca54465',3,'78ba832e-2255-11ef-8e3f-d619fca54465','Commande 1.1','NOT_SENT',1,NULL,NULL,1,1,1,'8df2a258-8868-49b7-91c2-e2d41d48bffc','8df2a258-8868-49b7-91c2-e2d41d48bffc','2024-06-04 11:33:16.499',NULL,'2024-06-04 11:33:16.500','2024-06-04 09:33:16.501',NULL),('80d86971-27cb-11ef-8e37-d519fa9d22d2',2,'80d26da8-27cb-11ef-8e37-d519fa9d22d2','Commande 13.2','NOT_SENT',1,NULL,NULL,1,1,2,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-11 10:20:46.528',NULL,'2024-06-11 10:20:46.532','2024-06-11 08:20:46.532',NULL),('859f5fed-2e40-11ef-8deb-d515ea58f6cb',2,'8598ee4a-2e40-11ef-8deb-d515ea58f6cb','Order 6.3 [pc2]','CANCELLED',0,'2024-06-20 00:00:00.000',NULL,0,1,2,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-19 15:33:33.000',NULL,'2024-06-19 15:43:21.000','2024-06-19 13:43:21.000','2024-06-19 15:43:21.000'),('8c15b440-2735-11ef-8e16-d517f37fa1ab',2,'8c10fdc0-2735-11ef-8e16-d517f37fa1ab','Commande 5.1','DATE_VALIDATED',0,'2024-06-12 00:00:00.000',NULL,0,1,2,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-10 16:27:20.000','2024-06-11 10:08:20.000','2024-06-11 10:02:36.000','2024-06-11 08:08:20.000','2024-06-11 10:08:20.000'),('8c703315-28b0-11ef-8e16-d517f37fa2ad',5,'627cfe1c-289b-11ef-8e16-d517f37fa2ad','Commande 1.2','NOT_SENT',1,'2024-06-29 00:00:00.000',NULL,1,4,1,'4e72ba02-814f-4116-88da-65f8da1fa385','4e72ba02-814f-4116-88da-65f8da1fa385','2024-06-12 13:40:20.729',NULL,'2024-06-12 17:55:49.646','2024-06-12 15:55:49.646',NULL),('8d0cbb85-2a29-11ef-8f1c-d8242c6fa8fd',11,'8d07a312-2a29-11ef-8f1c-d8242c6fa8fd','Ordini 3.2','SENT',0,'2024-06-15 00:00:00.000',NULL,0,1,1,'de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-14 10:39:03.000',NULL,'2024-06-14 11:18:38.000','2024-06-14 09:18:40.000','2024-06-14 11:18:40.000'),('8d24e986-23eb-11ef-8dde-d415e84cc4f5',3,'8d2006e5-23eb-11ef-8dde-d415e84cc4f5','Commande 2.3','DATE_VALIDATED',0,'2024-06-07 00:00:00.000',NULL,0,1,1,'8df2a258-8868-49b7-91c2-e2d41d48bffc','8df2a258-8868-49b7-91c2-e2d41d48bffc','2024-06-06 12:00:06.000',NULL,'2024-06-06 12:02:16.000','2024-06-06 10:02:16.000','2024-06-06 12:02:16.000'),('8e871a0f-296b-11ef-8e16-d517f37fa2ad',11,'8e81ab09-296b-11ef-8e16-d517f37fa2ad','Ordini 1.1','CANCELLED',0,'2024-06-14 00:00:00.000',NULL,0,1,1,'de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-13 11:59:00.000',NULL,'2024-06-13 15:16:13.000','2024-06-13 13:16:13.000','2024-06-13 15:16:13.000'),('9579e61c-2e29-11ef-8deb-d515ea58f6cb',2,'9573b888-2e29-11ef-8deb-d515ea58f6cb','Commande 7.4 [pc2]','NOT_SENT',1,NULL,NULL,1,1,2,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-19 12:49:21.455',NULL,'2024-06-19 12:49:21.460','2024-06-19 10:49:21.461',NULL),('96b5001d-23e7-11ef-8dde-d415e84cc4f5',3,'96aedcf6-23e7-11ef-8dde-d415e84cc4f5','Commande 2.1','CANCELLED',0,'2024-06-07 00:00:00.000',NULL,0,1,1,'8df2a258-8868-49b7-91c2-e2d41d48bffc','8df2a258-8868-49b7-91c2-e2d41d48bffc','2024-06-06 11:31:44.000',NULL,'2024-06-06 11:35:19.000','2024-06-06 09:35:19.000','2024-06-06 11:35:19.000'),('9ca1b461-28ba-11ef-8e16-d517f37fa2ad',5,'9c9bb412-28ba-11ef-8e16-d517f37fa2ad','Commande 2.1','NOT_SENT',1,NULL,NULL,1,1,1,'4e72ba02-814f-4116-88da-65f8da1fa385','4e72ba02-814f-4116-88da-65f8da1fa385','2024-06-12 14:52:22.864','2024-06-12 14:54:09.505','2024-06-12 14:54:09.506','2024-06-12 12:54:09.506',NULL),('a1f09971-298a-11ef-8e16-d517f37fa2ad',2,'a1ebbaf4-298a-11ef-8e16-d517f37fa2ad','Commande 14.2','NOT_SENT',1,NULL,NULL,1,1,2,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-13 15:41:27.090',NULL,'2024-06-13 15:41:27.094','2024-06-13 13:41:27.094',NULL),('a4229655-2279-11ef-8d76-d310d2ec2c14',2,'a4139c9d-2279-11ef-8d76-d310d2ec2c14','Commande 1.3','SENT',0,'2024-06-12 00:00:00.000','2024-06-09 00:00:00.000',0,1,2,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-04 15:52:11.000',NULL,'2024-06-10 16:16:46.000','2024-06-10 14:16:47.000','2024-06-10 16:16:47.000'),('afad1449-2271-11ef-8d76-d310d2ec2c14',2,'afa6cb0d-2271-11ef-8d76-d310d2ec2c14','Commande 2.1','SENT',1,'2024-06-05 00:00:00.000',NULL,0,1,2,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-04 14:55:14.578',NULL,'2024-06-04 14:58:45.486','2024-06-04 12:58:45.486','2024-06-04 14:58:45.490'),('bb004dd6-273a-11ef-8e16-d517f37fa1ab',2,'bafa1a93-273a-11ef-8e16-d517f37fa1ab','Commande 9.1','NOT_SENT',1,NULL,NULL,1,1,2,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-10 17:04:27.072','2024-06-10 17:05:41.397','2024-06-10 17:05:41.398','2024-06-10 15:05:41.398',NULL),('be9f95d2-2735-11ef-8e16-d517f37fa1ab',2,'be9a8e99-2735-11ef-8e16-d517f37fa1ab','Commande 6.1','SENT',0,'2024-06-12 00:00:00.000',NULL,0,1,2,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-10 16:28:45.000',NULL,'2024-06-11 10:43:01.000','2024-06-11 08:43:03.000','2024-06-11 10:43:03.000'),('bed2bb1e-273c-11ef-8e16-d517f37fa1ab',2,'917767fe-23fa-11ef-8dde-d415e84cc4f5','Commande 7.2','SENT',0,'2024-06-12 00:00:00.000',NULL,0,1,2,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-10 17:18:52.000','2024-06-11 10:15:34.000','2024-06-11 10:14:53.000','2024-06-11 08:15:34.000','2024-06-11 10:15:34.000'),('c88ceca6-2e3c-11ef-8deb-d515ea58f6cb',2,'c88615a1-2e3c-11ef-8deb-d515ea58f6cb','Order 16.3 [pc2]','NOT_SENT',1,NULL,NULL,1,1,2,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-19 15:06:47.581',NULL,'2024-06-19 15:06:47.586','2024-06-19 13:06:47.586',NULL),('cc4112f9-297d-11ef-8e16-d517f37fa2ad',11,'cc35f9a3-297d-11ef-8e16-d517f37fa2ad','Ordini 5.2','DATE_EDITED',0,'2024-06-16 00:00:00.000','2024-06-15 00:00:00.000',0,1,1,'de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-13 14:09:34.000',NULL,'2024-06-13 15:15:10.000','2024-06-13 13:15:10.000','2024-06-13 15:15:10.000'),('d2cfcd57-2985-11ef-8e16-d517f37fa2ad',11,'08eb58c6-2980-11ef-8e16-d517f37fa2ad','Ordini 5.5','DATE_VALIDATED',0,'2024-06-14 00:00:00.000',NULL,0,2,1,'de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-13 15:07:01.000',NULL,'2024-06-13 15:10:35.000','2024-06-13 13:10:35.000','2024-06-13 15:10:35.000'),('d7104c8e-298d-11ef-8e16-d517f37fa2ad',11,'d703d726-298d-11ef-8e16-d517f37fa2ad','Ordini 1.2','NOT_SENT',1,NULL,NULL,1,1,1,'de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-13 16:04:24.707',NULL,'2024-06-13 16:04:24.708','2024-06-13 14:04:24.708',NULL),('da257486-2e3a-11ef-8deb-d515ea58f6cb',2,'da1f6873-2e3a-11ef-8deb-d515ea58f6cb','Order 16.2 [pc2]','DATE_VALIDATED',0,'2024-06-20 00:00:00.000',NULL,0,1,2,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-19 14:52:58.000',NULL,'2024-06-19 15:05:42.000','2024-06-19 13:05:42.000','2024-06-19 15:05:42.000'),('da3bcb3f-227c-11ef-8d76-d310d2ec2c14',2,'da355fe4-227c-11ef-8d76-d310d2ec2c14','Commande 3.1','SENT',0,'2024-06-07 00:00:00.000',NULL,0,1,2,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-04 16:15:10.000',NULL,'2024-06-06 14:48:11.000','2024-06-06 12:48:13.000','2024-06-06 14:48:13.000'),('ddb0571c-289e-11ef-8e16-d517f37fa2ad',5,'627cfe1c-289b-11ef-8e16-d517f37fa2ad','Commande 1.2','CANCELLED',0,'2024-06-14 00:00:00.000',NULL,0,2,1,'4e72ba02-814f-4116-88da-65f8da1fa385','4e72ba02-814f-4116-88da-65f8da1fa385','2024-06-12 11:33:46.000',NULL,'2024-06-12 11:41:48.000','2024-06-12 09:41:48.000','2024-06-12 11:41:48.000'),('de096a3e-2e4d-11ef-8deb-d515ea58f6cb',2,'ddffc633-2e4d-11ef-8deb-d515ea58f6cb','Order 17.3 [pc2]','CANCELLED',0,'2024-06-20 00:00:00.000',NULL,0,1,2,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-19 17:09:05.000',NULL,'2024-06-19 17:09:28.000','2024-06-19 15:09:28.000','2024-06-19 17:09:28.000'),('e387023b-289f-11ef-8e16-d517f37fa2ad',5,'0d1289f0-289a-11ef-8e16-d517f37fa2ad','Commande 1.1','DATE_VALIDATED',0,'2024-06-30 00:00:00.000',NULL,0,2,1,'4e72ba02-814f-4116-88da-65f8da1fa385','4e72ba02-814f-4116-88da-65f8da1fa385','2024-06-12 11:41:05.000',NULL,'2024-06-12 11:46:38.000','2024-06-12 09:46:38.000','2024-06-12 11:46:38.000'),('ea2350dd-2e41-11ef-8deb-d515ea58f6cb',2,'8598ee4a-2e40-11ef-8deb-d515ea58f6cb','Order 6.3 [pc2]','CANCELLED',0,'2024-06-23 00:00:00.000',NULL,0,2,2,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-19 15:43:31.000',NULL,'2024-06-19 15:44:13.000','2024-06-19 13:44:13.000','2024-06-19 15:44:13.000'),('eb83e66a-2fa4-11ef-8e5c-d61b03bfb54e',2,'eb7d58ee-2fa4-11ef-8e5c-d61b03bfb54e','Order 18.1 [pc2]','NOT_SENT',1,NULL,NULL,1,1,2,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-21 10:04:45.130',NULL,'2024-06-21 10:04:45.136','2024-06-21 08:04:45.136',NULL),('f1e7f15b-2e4d-11ef-8deb-d515ea58f6cb',2,'ddffc633-2e4d-11ef-8deb-d515ea58f6cb','Order 17.3 [pc2]','SENT',0,'2024-06-30 00:00:00.000',NULL,0,2,2,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-19 17:09:38.000',NULL,'2024-06-19 17:09:52.000','2024-06-19 15:09:53.000','2024-06-19 17:09:53.000'),('f26746c9-2272-11ef-8d76-d310d2ec2c14',2,'f2606f1c-2272-11ef-8d76-d310d2ec2c14','Commande 1.2','CANCELLED',0,'2024-06-05 00:00:00.000',NULL,0,1,2,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-04 15:04:16.000',NULL,'2024-06-07 11:31:34.000','2024-06-07 09:31:34.000','2024-06-07 11:31:34.000'),('f30520c9-2731-11ef-8e16-d517f37fa1ab',2,'f2fea4e5-2731-11ef-8e16-d517f37fa1ab','Commande 4.2','NOT_SENT',1,NULL,NULL,1,1,2,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-10 16:01:35.585',NULL,'2024-06-10 16:01:35.588','2024-06-10 14:01:35.589',NULL),('f3d4cf05-27d1-11ef-8e37-d519fa9d22d2',2,'f3d1c83f-27d1-11ef-8e37-d519fa9d22d2','Commande 2.4','NOT_SENT',1,NULL,NULL,1,1,2,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-11 11:06:56.423',NULL,'2024-06-11 11:06:56.424','2024-06-11 09:06:56.424',NULL),('fe784ee0-28bf-11ef-8e16-d517f37fa2ad',5,'fe71f582-28bf-11ef-8e16-d517f37fa2ad','Commande 4.1','NOT_SENT',1,NULL,NULL,1,1,1,'4e72ba02-814f-4116-88da-65f8da1fa385','4e72ba02-814f-4116-88da-65f8da1fa385','2024-06-12 15:30:54.493','2024-06-12 17:57:47.298','2024-06-12 17:57:47.298','2024-06-12 15:57:47.299',NULL),('ff4af3b3-272f-11ef-8e16-d517f37fa1ab',2,'ff43b7ab-272f-11ef-8e16-d517f37fa1ab','Commande 4.1','NOT_SENT',1,NULL,NULL,1,1,2,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-10 15:47:37.182',NULL,'2024-06-10 15:47:37.184','2024-06-10 13:47:37.185',NULL);
/*!40000 ALTER TABLE `ProstheticOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrderFile`
--

DROP TABLE IF EXISTS `ProstheticOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProstheticOrderFile` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('FORM','SCAN') NOT NULL,
  PRIMARY KEY (`orderId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `ProstheticOrderFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrderFile_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `ProstheticOrder` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrderFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrderFile`
--

LOCK TABLES `ProstheticOrderFile` WRITE;
/*!40000 ALTER TABLE `ProstheticOrderFile` DISABLE KEYS */;
INSERT INTO `ProstheticOrderFile` VALUES (5,'0187211b-28a0-11ef-8e16-d517f37fa2ad','24467343-28a0-11ef-8e16-d517f37fa2ad','FORM'),(5,'0187211b-28a0-11ef-8e16-d517f37fa2ad','3ef48adf-289c-11ef-8e16-d517f37fa2ad','SCAN'),(5,'0187211b-28a0-11ef-8e16-d517f37fa2ad','3f100ab3-289c-11ef-8e16-d517f37fa2ad','SCAN'),(5,'0187211b-28a0-11ef-8e16-d517f37fa2ad','3f7b0e6c-289c-11ef-8e16-d517f37fa2ad','SCAN'),(11,'08f4c372-2980-11ef-8e16-d517f37fa2ad','202d91d6-2984-11ef-8e16-d517f37fa2ad','FORM'),(11,'08f4c372-2980-11ef-8e16-d517f37fa2ad','43ea5aab-2981-11ef-8e16-d517f37fa2ad','SCAN'),(11,'08f4c372-2980-11ef-8e16-d517f37fa2ad','43ea9afd-2981-11ef-8e16-d517f37fa2ad','SCAN'),(11,'08f4c372-2980-11ef-8e16-d517f37fa2ad','7dc312cb-2981-11ef-8e16-d517f37fa2ad','SCAN'),(11,'08f4c372-2980-11ef-8e16-d517f37fa2ad','be9062f3-2982-11ef-8e16-d517f37fa2ad','SCAN'),(11,'08f4c372-2980-11ef-8e16-d517f37fa2ad','c5e732c1-2983-11ef-8e16-d517f37fa2ad','SCAN'),(11,'08f4c372-2980-11ef-8e16-d517f37fa2ad','e09fbf20-2980-11ef-8e16-d517f37fa2ad','SCAN'),(11,'08f4c372-2980-11ef-8e16-d517f37fa2ad','e3ffe01f-2982-11ef-8e16-d517f37fa2ad','SCAN'),(3,'0bd68b18-23e9-11ef-8dde-d415e84cc4f5','242c6766-23e9-11ef-8dde-d415e84cc4f5','SCAN'),(3,'0bd68b18-23e9-11ef-8dde-d415e84cc4f5','242c7d2a-23e9-11ef-8dde-d415e84cc4f5','SCAN'),(3,'0bd68b18-23e9-11ef-8dde-d415e84cc4f5','336ff6af-23e9-11ef-8dde-d415e84cc4f5','FORM'),(5,'0d191b14-289a-11ef-8e16-d517f37fa2ad','7f0190db-289a-11ef-8e16-d517f37fa2ad','SCAN'),(5,'0d191b14-289a-11ef-8e16-d517f37fa2ad','7f01a3ee-289a-11ef-8e16-d517f37fa2ad','SCAN'),(5,'0d191b14-289a-11ef-8e16-d517f37fa2ad','b91dbada-289a-11ef-8e16-d517f37fa2ad','SCAN'),(5,'0d191b14-289a-11ef-8e16-d517f37fa2ad','b91dc908-289a-11ef-8e16-d517f37fa2ad','SCAN'),(5,'0d191b14-289a-11ef-8e16-d517f37fa2ad','bdb51817-289d-11ef-8e16-d517f37fa2ad','FORM'),(5,'0d191b14-289a-11ef-8e16-d517f37fa2ad','f11a7ce4-289c-11ef-8e16-d517f37fa2ad','SCAN'),(5,'0d191b14-289a-11ef-8e16-d517f37fa2ad','f125c583-289c-11ef-8e16-d517f37fa2ad','SCAN'),(5,'0d191b14-289a-11ef-8e16-d517f37fa2ad','f1901fb9-289c-11ef-8e16-d517f37fa2ad','SCAN'),(2,'15fd7f91-2e4b-11ef-8deb-d515ea58f6cb','259181e4-2e4c-11ef-8deb-d515ea58f6cb','FORM'),(2,'15fd7f91-2e4b-11ef-8deb-d515ea58f6cb','3944017f-2e4b-11ef-8deb-d515ea58f6cb','SCAN'),(2,'15fd7f91-2e4b-11ef-8deb-d515ea58f6cb','394418b6-2e4b-11ef-8deb-d515ea58f6cb','SCAN'),(2,'15fd7f91-2e4b-11ef-8deb-d515ea58f6cb','62490a02-2e4b-11ef-8deb-d515ea58f6cb','SCAN'),(2,'15fd7f91-2e4b-11ef-8deb-d515ea58f6cb','624917e7-2e4b-11ef-8deb-d515ea58f6cb','SCAN'),(2,'15fd7f91-2e4b-11ef-8deb-d515ea58f6cb','cca14134-2e4b-11ef-8deb-d515ea58f6cb','SCAN'),(2,'15fd7f91-2e4b-11ef-8deb-d515ea58f6cb','cd43bf12-2e4b-11ef-8deb-d515ea58f6cb','SCAN'),(2,'15fd7f91-2e4b-11ef-8deb-d515ea58f6cb','d2ad1a19-2e4b-11ef-8deb-d515ea58f6cb','SCAN'),(2,'164af3dc-2e43-11ef-8deb-d515ea58f6cb','639f7d1c-2e43-11ef-8deb-d515ea58f6cb','SCAN'),(2,'164af3dc-2e43-11ef-8deb-d515ea58f6cb','639fcb29-2e43-11ef-8deb-d515ea58f6cb','SCAN'),(2,'164af3dc-2e43-11ef-8deb-d515ea58f6cb','912d936b-2e43-11ef-8deb-d515ea58f6cb','FORM'),(2,'1cba063b-271f-11ef-8e16-d517f37fa1ab','3326d65f-2720-11ef-8e16-d517f37fa1ab','SCAN'),(2,'1cba063b-271f-11ef-8e16-d517f37fa1ab','3326f9f5-2720-11ef-8e16-d517f37fa1ab','SCAN'),(2,'1cba063b-271f-11ef-8e16-d517f37fa1ab','73b17774-2720-11ef-8e16-d517f37fa1ab','SCAN'),(2,'1cba063b-271f-11ef-8e16-d517f37fa1ab','73b18674-2720-11ef-8e16-d517f37fa1ab','SCAN'),(2,'1cba063b-271f-11ef-8e16-d517f37fa1ab','8e2e7cc7-2738-11ef-8e16-d517f37fa1ab','FORM'),(2,'1cba063b-271f-11ef-8e16-d517f37fa1ab','e4230834-2737-11ef-8e16-d517f37fa1ab','SCAN'),(2,'1cba063b-271f-11ef-8e16-d517f37fa1ab','e42318eb-2737-11ef-8e16-d517f37fa1ab','SCAN'),(2,'22749c4a-2e42-11ef-8deb-d515ea58f6cb','1d1765b7-2e42-11ef-8deb-d515ea58f6cb','SCAN'),(2,'22749c4a-2e42-11ef-8deb-d515ea58f6cb','1d1774ff-2e42-11ef-8deb-d515ea58f6cb','SCAN'),(2,'22749c4a-2e42-11ef-8deb-d515ea58f6cb','2b452b17-2e42-11ef-8deb-d515ea58f6cb','SCAN'),(2,'22749c4a-2e42-11ef-8deb-d515ea58f6cb','a0bfc6a3-2e4d-11ef-8deb-d515ea58f6cb','FORM'),(2,'22749c4a-2e42-11ef-8deb-d515ea58f6cb','aa0b087d-2e40-11ef-8deb-d515ea58f6cb','SCAN'),(11,'470ab6fc-2963-11ef-8e16-d517f37fa2ad','089e2b2d-296b-11ef-8e16-d517f37fa2ad','SCAN'),(11,'470ab6fc-2963-11ef-8e16-d517f37fa2ad','21107477-296a-11ef-8e16-d517f37fa2ad','SCAN'),(11,'470ab6fc-2963-11ef-8e16-d517f37fa2ad','64880729-2964-11ef-8e16-d517f37fa2ad','SCAN'),(11,'470ab6fc-2963-11ef-8e16-d517f37fa2ad','a8c82bcb-296a-11ef-8e16-d517f37fa2ad','SCAN'),(11,'470ab6fc-2963-11ef-8e16-d517f37fa2ad','a90adf72-296a-11ef-8e16-d517f37fa2ad','SCAN'),(11,'470ab6fc-2963-11ef-8e16-d517f37fa2ad','c80e9775-2966-11ef-8e16-d517f37fa2ad','SCAN'),(11,'470ab6fc-2963-11ef-8e16-d517f37fa2ad','c80fd072-2966-11ef-8e16-d517f37fa2ad','SCAN'),(11,'470ab6fc-2963-11ef-8e16-d517f37fa2ad','dd2934fd-2986-11ef-8e16-d517f37fa2ad','FORM'),(11,'4ba706eb-2987-11ef-8e16-d517f37fa2ad','05998f46-2988-11ef-8e16-d517f37fa2ad','SCAN'),(11,'4ba706eb-2987-11ef-8e16-d517f37fa2ad','2a2ce13d-2988-11ef-8e16-d517f37fa2ad','FORM'),(11,'4ba706eb-2987-11ef-8e16-d517f37fa2ad','fb21655b-2987-11ef-8e16-d517f37fa2ad','SCAN'),(11,'4ba706eb-2987-11ef-8e16-d517f37fa2ad','fbb6d74e-2987-11ef-8e16-d517f37fa2ad','SCAN'),(5,'6282c146-289b-11ef-8e16-d517f37fa2ad','02353824-289c-11ef-8e16-d517f37fa2ad','SCAN'),(5,'6282c146-289b-11ef-8e16-d517f37fa2ad','02355a6c-289c-11ef-8e16-d517f37fa2ad','SCAN'),(5,'6282c146-289b-11ef-8e16-d517f37fa2ad','3ef48adf-289c-11ef-8e16-d517f37fa2ad','SCAN'),(5,'6282c146-289b-11ef-8e16-d517f37fa2ad','3f100ab3-289c-11ef-8e16-d517f37fa2ad','SCAN'),(5,'6282c146-289b-11ef-8e16-d517f37fa2ad','3f7b0e6c-289c-11ef-8e16-d517f37fa2ad','SCAN'),(5,'6282c146-289b-11ef-8e16-d517f37fa2ad','90d40af7-289b-11ef-8e16-d517f37fa2ad','SCAN'),(5,'6282c146-289b-11ef-8e16-d517f37fa2ad','90d41939-289b-11ef-8e16-d517f37fa2ad','SCAN'),(5,'6282c146-289b-11ef-8e16-d517f37fa2ad','c13314ae-289e-11ef-8e16-d517f37fa2ad','FORM'),(2,'62bf4a87-226c-11ef-8d76-d310d2ec2c14','5bd68def-2272-11ef-8d76-d310d2ec2c14','SCAN'),(2,'62bf4a87-226c-11ef-8d76-d310d2ec2c14','5bd6a4c3-2272-11ef-8d76-d310d2ec2c14','SCAN'),(2,'62bf4a87-226c-11ef-8d76-d310d2ec2c14','66bc3d46-2272-11ef-8d76-d310d2ec2c14','FORM'),(2,'68b5196a-2e42-11ef-8deb-d515ea58f6cb','953ccd86-2e42-11ef-8deb-d515ea58f6cb','SCAN'),(2,'68b5196a-2e42-11ef-8deb-d515ea58f6cb','bde80801-2e42-11ef-8deb-d515ea58f6cb','SCAN'),(2,'68b5196a-2e42-11ef-8deb-d515ea58f6cb','d2fc9984-2e42-11ef-8deb-d515ea58f6cb','SCAN'),(2,'68b5196a-2e42-11ef-8deb-d515ea58f6cb','e386f28a-2e42-11ef-8deb-d515ea58f6cb','FORM'),(2,'859f5fed-2e40-11ef-8deb-d515ea58f6cb','aa0af9eb-2e40-11ef-8deb-d515ea58f6cb','SCAN'),(2,'859f5fed-2e40-11ef-8deb-d515ea58f6cb','aa0b087d-2e40-11ef-8deb-d515ea58f6cb','SCAN'),(2,'859f5fed-2e40-11ef-8deb-d515ea58f6cb','ca082562-2e41-11ef-8deb-d515ea58f6cb','FORM'),(2,'8c15b440-2735-11ef-8e16-d517f37fa1ab','a21821fc-2735-11ef-8e16-d517f37fa1ab','SCAN'),(2,'8c15b440-2735-11ef-8e16-d517f37fa1ab','a2183657-2735-11ef-8e16-d517f37fa1ab','SCAN'),(2,'8c15b440-2735-11ef-8e16-d517f37fa1ab','d316761c-27c8-11ef-8e37-d519fa9d22d2','FORM'),(5,'8c703315-28b0-11ef-8e16-d517f37fa2ad','3ef48adf-289c-11ef-8e16-d517f37fa2ad','SCAN'),(5,'8c703315-28b0-11ef-8e16-d517f37fa2ad','3f100ab3-289c-11ef-8e16-d517f37fa2ad','SCAN'),(11,'8d0cbb85-2a29-11ef-8f1c-d8242c6fa8fd','145531e1-2a2f-11ef-8f1c-d8242c6fa8fd','FORM'),(11,'8d0cbb85-2a29-11ef-8f1c-d8242c6fa8fd','432c5ac7-2a2b-11ef-8f1c-d8242c6fa8fd','SCAN'),(11,'8d0cbb85-2a29-11ef-8f1c-d8242c6fa8fd','6c69f0d2-2a2c-11ef-8f1c-d8242c6fa8fd','SCAN'),(11,'8d0cbb85-2a29-11ef-8f1c-d8242c6fa8fd','7e31fba5-2a2b-11ef-8f1c-d8242c6fa8fd','SCAN'),(11,'8d0cbb85-2a29-11ef-8f1c-d8242c6fa8fd','aeeb700b-2a2e-11ef-8f1c-d8242c6fa8fd','SCAN'),(11,'8d0cbb85-2a29-11ef-8f1c-d8242c6fa8fd','aeeb7d77-2a2e-11ef-8f1c-d8242c6fa8fd','SCAN'),(11,'8d0cbb85-2a29-11ef-8f1c-d8242c6fa8fd','aeeb8932-2a2e-11ef-8f1c-d8242c6fa8fd','SCAN'),(11,'8d0cbb85-2a29-11ef-8f1c-d8242c6fa8fd','b5074b88-2a2b-11ef-8f1c-d8242c6fa8fd','SCAN'),(11,'8d0cbb85-2a29-11ef-8f1c-d8242c6fa8fd','c10a25c6-2a2e-11ef-8f1c-d8242c6fa8fd','SCAN'),(11,'8d0cbb85-2a29-11ef-8f1c-d8242c6fa8fd','c1a4a542-2a2c-11ef-8f1c-d8242c6fa8fd','SCAN'),(11,'8d0cbb85-2a29-11ef-8f1c-d8242c6fa8fd','dc9d5d76-2a2e-11ef-8f1c-d8242c6fa8fd','SCAN'),(11,'8d0cbb85-2a29-11ef-8f1c-d8242c6fa8fd','e0f8d71f-2a29-11ef-8f1c-d8242c6fa8fd','SCAN'),(11,'8d0cbb85-2a29-11ef-8f1c-d8242c6fa8fd','e0f8ef08-2a29-11ef-8f1c-d8242c6fa8fd','SCAN'),(11,'8d0cbb85-2a29-11ef-8f1c-d8242c6fa8fd','ef2d44e2-2a2b-11ef-8f1c-d8242c6fa8fd','SCAN'),(11,'8d0cbb85-2a29-11ef-8f1c-d8242c6fa8fd','ef2d67d4-2a2b-11ef-8f1c-d8242c6fa8fd','SCAN'),(11,'8d0cbb85-2a29-11ef-8f1c-d8242c6fa8fd','ef33f313-2a2b-11ef-8f1c-d8242c6fa8fd','SCAN'),(11,'8d0cbb85-2a29-11ef-8f1c-d8242c6fa8fd','ef341516-2a2b-11ef-8f1c-d8242c6fa8fd','SCAN'),(3,'8d24e986-23eb-11ef-8dde-d415e84cc4f5','9a5291cb-23eb-11ef-8dde-d415e84cc4f5','FORM'),(3,'8d24e986-23eb-11ef-8dde-d415e84cc4f5','d0ab5861-23e7-11ef-8dde-d415e84cc4f5','SCAN'),(3,'8d24e986-23eb-11ef-8dde-d415e84cc4f5','d0ab69d4-23e7-11ef-8dde-d415e84cc4f5','SCAN'),(11,'8e871a0f-296b-11ef-8e16-d517f37fa2ad','3fb8c8b6-2970-11ef-8e16-d517f37fa2ad','SCAN'),(11,'8e871a0f-296b-11ef-8e16-d517f37fa2ad','3fd6a6f4-2970-11ef-8e16-d517f37fa2ad','SCAN'),(11,'8e871a0f-296b-11ef-8e16-d517f37fa2ad','3fd6b050-2970-11ef-8e16-d517f37fa2ad','SCAN'),(11,'8e871a0f-296b-11ef-8e16-d517f37fa2ad','3fd6f8c6-2970-11ef-8e16-d517f37fa2ad','SCAN'),(11,'8e871a0f-296b-11ef-8e16-d517f37fa2ad','8f9ceac9-2970-11ef-8e16-d517f37fa2ad','SCAN'),(11,'8e871a0f-296b-11ef-8e16-d517f37fa2ad','e36ba3f8-2970-11ef-8e16-d517f37fa2ad','SCAN'),(11,'8e871a0f-296b-11ef-8e16-d517f37fa2ad','eb340ff4-296f-11ef-8e16-d517f37fa2ad','SCAN'),(11,'8e871a0f-296b-11ef-8e16-d517f37fa2ad','fb07e2bb-2970-11ef-8e16-d517f37fa2ad','FORM'),(3,'96b5001d-23e7-11ef-8dde-d415e84cc4f5','d0ab5861-23e7-11ef-8dde-d415e84cc4f5','SCAN'),(3,'96b5001d-23e7-11ef-8dde-d415e84cc4f5','d0ab69d4-23e7-11ef-8dde-d415e84cc4f5','SCAN'),(3,'96b5001d-23e7-11ef-8dde-d415e84cc4f5','fafc415d-23e7-11ef-8dde-d415e84cc4f5','FORM'),(2,'a4229655-2279-11ef-8d76-d310d2ec2c14','113e7226-2734-11ef-8e16-d517f37fa1ab','FORM'),(2,'a4229655-2279-11ef-8d76-d310d2ec2c14','ca114ae6-2279-11ef-8d76-d310d2ec2c14','SCAN'),(2,'a4229655-2279-11ef-8d76-d310d2ec2c14','ca116050-2279-11ef-8d76-d310d2ec2c14','SCAN'),(2,'afad1449-2271-11ef-8d76-d310d2ec2c14','2cf3311a-2272-11ef-8d76-d310d2ec2c14','FORM'),(2,'afad1449-2271-11ef-8d76-d310d2ec2c14','fc8f1969-2271-11ef-8d76-d310d2ec2c14','SCAN'),(2,'afad1449-2271-11ef-8d76-d310d2ec2c14','fc8f31e9-2271-11ef-8d76-d310d2ec2c14','SCAN'),(2,'be9f95d2-2735-11ef-8e16-d517f37fa1ab','9c24cd94-27ce-11ef-8e37-d519fa9d22d2','FORM'),(2,'be9f95d2-2735-11ef-8e16-d517f37fa1ab','e1412689-2735-11ef-8e16-d517f37fa1ab','SCAN'),(2,'be9f95d2-2735-11ef-8e16-d517f37fa1ab','e1413c8f-2735-11ef-8e16-d517f37fa1ab','SCAN'),(2,'be9f95d2-2735-11ef-8e16-d517f37fa1ab','e921fb8b-2735-11ef-8e16-d517f37fa1ab','SCAN'),(2,'be9f95d2-2735-11ef-8e16-d517f37fa1ab','e9220178-2735-11ef-8e16-d517f37fa1ab','SCAN'),(2,'bed2bb1e-273c-11ef-8e16-d517f37fa1ab','76d290b9-273c-11ef-8e16-d517f37fa1ab','SCAN'),(2,'bed2bb1e-273c-11ef-8e16-d517f37fa1ab','76d2a559-273c-11ef-8e16-d517f37fa1ab','SCAN'),(2,'bed2bb1e-273c-11ef-8e16-d517f37fa1ab','adfd6dd3-27ca-11ef-8e37-d519fa9d22d2','FORM'),(11,'cc4112f9-297d-11ef-8e16-d517f37fa2ad','8870875c-297e-11ef-8e16-d517f37fa2ad','SCAN'),(11,'cc4112f9-297d-11ef-8e16-d517f37fa2ad','88709f91-297e-11ef-8e16-d517f37fa2ad','SCAN'),(11,'cc4112f9-297d-11ef-8e16-d517f37fa2ad','9d433d29-297e-11ef-8e16-d517f37fa2ad','FORM'),(11,'d2cfcd57-2985-11ef-8e16-d517f37fa2ad','3cf533b7-2986-11ef-8e16-d517f37fa2ad','FORM'),(11,'d2cfcd57-2985-11ef-8e16-d517f37fa2ad','43ea5aab-2981-11ef-8e16-d517f37fa2ad','SCAN'),(11,'d2cfcd57-2985-11ef-8e16-d517f37fa2ad','43ea9afd-2981-11ef-8e16-d517f37fa2ad','SCAN'),(11,'d2cfcd57-2985-11ef-8e16-d517f37fa2ad','45df8951-2980-11ef-8e16-d517f37fa2ad','SCAN'),(11,'d2cfcd57-2985-11ef-8e16-d517f37fa2ad','45df9f47-2980-11ef-8e16-d517f37fa2ad','SCAN'),(11,'d2cfcd57-2985-11ef-8e16-d517f37fa2ad','7dc312cb-2981-11ef-8e16-d517f37fa2ad','SCAN'),(11,'d2cfcd57-2985-11ef-8e16-d517f37fa2ad','9ec5df9b-2980-11ef-8e16-d517f37fa2ad','SCAN'),(11,'d2cfcd57-2985-11ef-8e16-d517f37fa2ad','9ec5f3b6-2980-11ef-8e16-d517f37fa2ad','SCAN'),(11,'d2cfcd57-2985-11ef-8e16-d517f37fa2ad','be9062f3-2982-11ef-8e16-d517f37fa2ad','SCAN'),(11,'d2cfcd57-2985-11ef-8e16-d517f37fa2ad','c5e732c1-2983-11ef-8e16-d517f37fa2ad','SCAN'),(11,'d2cfcd57-2985-11ef-8e16-d517f37fa2ad','dbaacc35-2982-11ef-8e16-d517f37fa2ad','SCAN'),(11,'d2cfcd57-2985-11ef-8e16-d517f37fa2ad','e09fbf20-2980-11ef-8e16-d517f37fa2ad','SCAN'),(11,'d2cfcd57-2985-11ef-8e16-d517f37fa2ad','e3ffe01f-2982-11ef-8e16-d517f37fa2ad','SCAN'),(2,'da257486-2e3a-11ef-8deb-d515ea58f6cb','254bffc7-2e3c-11ef-8deb-d515ea58f6cb','SCAN'),(2,'da257486-2e3a-11ef-8deb-d515ea58f6cb','5c16705b-2e3c-11ef-8deb-d515ea58f6cb','FORM'),(2,'da257486-2e3a-11ef-8deb-d515ea58f6cb','c191f4f9-2e3b-11ef-8deb-d515ea58f6cb','SCAN'),(2,'da257486-2e3a-11ef-8deb-d515ea58f6cb','c22f9f80-2e3b-11ef-8deb-d515ea58f6cb','SCAN'),(2,'da257486-2e3a-11ef-8deb-d515ea58f6cb','e6a1b524-2e3b-11ef-8deb-d515ea58f6cb','SCAN'),(2,'da257486-2e3a-11ef-8deb-d515ea58f6cb','ecd551db-2e3b-11ef-8deb-d515ea58f6cb','SCAN'),(2,'da257486-2e3a-11ef-8deb-d515ea58f6cb','ee91fd74-2e3b-11ef-8deb-d515ea58f6cb','SCAN'),(2,'da257486-2e3a-11ef-8deb-d515ea58f6cb','f00455a1-2e3b-11ef-8deb-d515ea58f6cb','SCAN'),(2,'da257486-2e3a-11ef-8deb-d515ea58f6cb','f17e0ce7-2e3b-11ef-8deb-d515ea58f6cb','SCAN'),(2,'da257486-2e3a-11ef-8deb-d515ea58f6cb','f4f2c020-2e3b-11ef-8deb-d515ea58f6cb','SCAN'),(2,'da3bcb3f-227c-11ef-8d76-d310d2ec2c14','080061b0-2403-11ef-8dde-d415e84cc4f5','FORM'),(2,'da3bcb3f-227c-11ef-8d76-d310d2ec2c14','f51d71ce-227c-11ef-8d76-d310d2ec2c14','SCAN'),(2,'da3bcb3f-227c-11ef-8d76-d310d2ec2c14','f51d8554-227c-11ef-8d76-d310d2ec2c14','SCAN'),(5,'ddb0571c-289e-11ef-8e16-d517f37fa2ad','90d40af7-289b-11ef-8e16-d517f37fa2ad','SCAN'),(5,'ddb0571c-289e-11ef-8e16-d517f37fa2ad','90d41939-289b-11ef-8e16-d517f37fa2ad','SCAN'),(5,'ddb0571c-289e-11ef-8e16-d517f37fa2ad','a6fb3865-289f-11ef-8e16-d517f37fa2ad','FORM'),(5,'ddb0571c-289e-11ef-8e16-d517f37fa2ad','b91dbada-289a-11ef-8e16-d517f37fa2ad','SCAN'),(5,'ddb0571c-289e-11ef-8e16-d517f37fa2ad','b91dc908-289a-11ef-8e16-d517f37fa2ad','SCAN'),(2,'de096a3e-2e4d-11ef-8deb-d515ea58f6cb','0f949b7b-2e4d-11ef-8deb-d515ea58f6cb','SCAN'),(2,'de096a3e-2e4d-11ef-8deb-d515ea58f6cb','0f94ab65-2e4d-11ef-8deb-d515ea58f6cb','SCAN'),(2,'de096a3e-2e4d-11ef-8deb-d515ea58f6cb','e58acb2d-2e4d-11ef-8deb-d515ea58f6cb','FORM'),(5,'e387023b-289f-11ef-8e16-d517f37fa2ad','6f42baa5-28a0-11ef-8e16-d517f37fa2ad','FORM'),(5,'e387023b-289f-11ef-8e16-d517f37fa2ad','f11a7ce4-289c-11ef-8e16-d517f37fa2ad','SCAN'),(5,'e387023b-289f-11ef-8e16-d517f37fa2ad','f125c583-289c-11ef-8e16-d517f37fa2ad','SCAN'),(5,'e387023b-289f-11ef-8e16-d517f37fa2ad','f1901fb9-289c-11ef-8e16-d517f37fa2ad','SCAN'),(2,'ea2350dd-2e41-11ef-8deb-d515ea58f6cb','aa0af9eb-2e40-11ef-8deb-d515ea58f6cb','SCAN'),(2,'ea2350dd-2e41-11ef-8deb-d515ea58f6cb','aa0b087d-2e40-11ef-8deb-d515ea58f6cb','SCAN'),(2,'ea2350dd-2e41-11ef-8deb-d515ea58f6cb','eea0c13a-2e41-11ef-8deb-d515ea58f6cb','FORM'),(2,'f1e7f15b-2e4d-11ef-8deb-d515ea58f6cb','0f949b7b-2e4d-11ef-8deb-d515ea58f6cb','SCAN'),(2,'f1e7f15b-2e4d-11ef-8deb-d515ea58f6cb','0f94ab65-2e4d-11ef-8deb-d515ea58f6cb','SCAN'),(2,'f1e7f15b-2e4d-11ef-8deb-d515ea58f6cb','f9c06fb9-2e4d-11ef-8deb-d515ea58f6cb','FORM'),(2,'f26746c9-2272-11ef-8d76-d310d2ec2c14','1c9626b7-2279-11ef-8d76-d310d2ec2c14','SCAN'),(2,'f26746c9-2272-11ef-8d76-d310d2ec2c14','275970f2-2279-11ef-8d76-d310d2ec2c14','SCAN'),(2,'f26746c9-2272-11ef-8d76-d310d2ec2c14','307ab64c-2279-11ef-8d76-d310d2ec2c14','FORM'),(2,'f26746c9-2272-11ef-8d76-d310d2ec2c14','3e22c831-2274-11ef-8d76-d310d2ec2c14','SCAN'),(2,'f26746c9-2272-11ef-8d76-d310d2ec2c14','5bc001f1-2278-11ef-8d76-d310d2ec2c14','SCAN'),(2,'f26746c9-2272-11ef-8d76-d310d2ec2c14','613c6795-2278-11ef-8d76-d310d2ec2c14','SCAN'),(2,'f26746c9-2272-11ef-8d76-d310d2ec2c14','8c08eecf-2278-11ef-8d76-d310d2ec2c14','SCAN'),(2,'f26746c9-2272-11ef-8d76-d310d2ec2c14','9005271a-2273-11ef-8d76-d310d2ec2c14','SCAN'),(2,'f26746c9-2272-11ef-8d76-d310d2ec2c14','90053a20-2273-11ef-8d76-d310d2ec2c14','SCAN'),(2,'f26746c9-2272-11ef-8d76-d310d2ec2c14','c52f1c4e-2278-11ef-8d76-d310d2ec2c14','SCAN'),(2,'f26746c9-2272-11ef-8d76-d310d2ec2c14','de217b4c-2278-11ef-8d76-d310d2ec2c14','SCAN'),(2,'f26746c9-2272-11ef-8d76-d310d2ec2c14','e59826d2-2278-11ef-8d76-d310d2ec2c14','SCAN');
/*!40000 ALTER TABLE `ProstheticOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrderRecipient`
--

DROP TABLE IF EXISTS `ProstheticOrderRecipient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProstheticOrderRecipient` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `recipientId` varchar(36) NOT NULL,
  PRIMARY KEY (`orderId`,`recipientId`),
  KEY `ownerId` (`ownerId`),
  KEY `recipientId` (`recipientId`),
  CONSTRAINT `ProstheticOrderRecipient_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrderRecipient_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `ProstheticOrder` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrderRecipient_ibfk_3` FOREIGN KEY (`recipientId`) REFERENCES `Contact` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrderRecipient`
--

LOCK TABLES `ProstheticOrderRecipient` WRITE;
/*!40000 ALTER TABLE `ProstheticOrderRecipient` DISABLE KEYS */;
INSERT INTO `ProstheticOrderRecipient` VALUES (2,'15fd7f91-2e4b-11ef-8deb-d515ea58f6cb','f765045a-2805-40b5-9a87-63af78cc2071'),(2,'164af3dc-2e43-11ef-8deb-d515ea58f6cb','f765045a-2805-40b5-9a87-63af78cc2071'),(2,'1cba063b-271f-11ef-8e16-d517f37fa1ab','f765045a-2805-40b5-9a87-63af78cc2071'),(2,'22749c4a-2e42-11ef-8deb-d515ea58f6cb','f765045a-2805-40b5-9a87-63af78cc2071'),(2,'62bf4a87-226c-11ef-8d76-d310d2ec2c14','4ed4ce00-4b30-4601-95bb-ede535f19c6b'),(2,'68b5196a-2e42-11ef-8deb-d515ea58f6cb','f765045a-2805-40b5-9a87-63af78cc2071'),(2,'859f5fed-2e40-11ef-8deb-d515ea58f6cb','f765045a-2805-40b5-9a87-63af78cc2071'),(2,'8c15b440-2735-11ef-8e16-d517f37fa1ab','4ed4ce00-4b30-4601-95bb-ede535f19c6b'),(2,'a4229655-2279-11ef-8d76-d310d2ec2c14','4ed4ce00-4b30-4601-95bb-ede535f19c6b'),(2,'afad1449-2271-11ef-8d76-d310d2ec2c14','4ed4ce00-4b30-4601-95bb-ede535f19c6b'),(2,'be9f95d2-2735-11ef-8e16-d517f37fa1ab','f765045a-2805-40b5-9a87-63af78cc2071'),(2,'bed2bb1e-273c-11ef-8e16-d517f37fa1ab','57a94929-f9c0-438e-b77e-c2432d03181d'),(2,'da257486-2e3a-11ef-8deb-d515ea58f6cb','f765045a-2805-40b5-9a87-63af78cc2071'),(2,'da3bcb3f-227c-11ef-8d76-d310d2ec2c14','8fbd79fd-0e86-49b8-9558-3a507eb19750'),(2,'de096a3e-2e4d-11ef-8deb-d515ea58f6cb','f765045a-2805-40b5-9a87-63af78cc2071'),(2,'ea2350dd-2e41-11ef-8deb-d515ea58f6cb','f765045a-2805-40b5-9a87-63af78cc2071'),(2,'f1e7f15b-2e4d-11ef-8deb-d515ea58f6cb','f765045a-2805-40b5-9a87-63af78cc2071'),(2,'f26746c9-2272-11ef-8d76-d310d2ec2c14','4ed4ce00-4b30-4601-95bb-ede535f19c6b'),(3,'0bd68b18-23e9-11ef-8dde-d415e84cc4f5','a664f09d-da86-42d0-b54a-2672898db522'),(3,'8d24e986-23eb-11ef-8dde-d415e84cc4f5','a664f09d-da86-42d0-b54a-2672898db522'),(3,'96b5001d-23e7-11ef-8dde-d415e84cc4f5','a50cb907-4db3-48f3-9808-0ae18d8dccdb'),(5,'0187211b-28a0-11ef-8e16-d517f37fa2ad','c6f88ce8-d6e3-44ca-b07b-c13992c4abb8'),(5,'0d191b14-289a-11ef-8e16-d517f37fa2ad','c6f88ce8-d6e3-44ca-b07b-c13992c4abb8'),(5,'6282c146-289b-11ef-8e16-d517f37fa2ad','c6f88ce8-d6e3-44ca-b07b-c13992c4abb8'),(5,'8c703315-28b0-11ef-8e16-d517f37fa2ad','c6f88ce8-d6e3-44ca-b07b-c13992c4abb8'),(5,'ddb0571c-289e-11ef-8e16-d517f37fa2ad','c6f88ce8-d6e3-44ca-b07b-c13992c4abb8'),(5,'e387023b-289f-11ef-8e16-d517f37fa2ad','c6f88ce8-d6e3-44ca-b07b-c13992c4abb8'),(11,'08f4c372-2980-11ef-8e16-d517f37fa2ad','7c2adbb8-f64b-4654-bf3e-bed35e01c424'),(11,'470ab6fc-2963-11ef-8e16-d517f37fa2ad','7c2adbb8-f64b-4654-bf3e-bed35e01c424'),(11,'4ba706eb-2987-11ef-8e16-d517f37fa2ad','b3c37c04-0470-43df-bb61-f33530e663f1'),(11,'8d0cbb85-2a29-11ef-8f1c-d8242c6fa8fd','b3c37c04-0470-43df-bb61-f33530e663f1'),(11,'8e871a0f-296b-11ef-8e16-d517f37fa2ad','7c2adbb8-f64b-4654-bf3e-bed35e01c424'),(11,'cc4112f9-297d-11ef-8e16-d517f37fa2ad','7c2adbb8-f64b-4654-bf3e-bed35e01c424'),(11,'d2cfcd57-2985-11ef-8e16-d517f37fa2ad','b3c37c04-0470-43df-bb61-f33530e663f1');
/*!40000 ALTER TABLE `ProstheticOrderRecipient` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticSheet`
--

DROP TABLE IF EXISTS `ProstheticSheet`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProstheticSheet` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `json` text NOT NULL,
  `pdfFileId` varchar(36) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `orderId` (`orderId`),
  KEY `pdfFileId` (`pdfFileId`),
  CONSTRAINT `ProstheticSheet_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `ProstheticSheet_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `ProstheticOrder` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `ProstheticSheet_ibfk_3` FOREIGN KEY (`pdfFileId`) REFERENCES `File` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticSheet`
--

LOCK TABLES `ProstheticSheet` WRITE;
/*!40000 ALTER TABLE `ProstheticSheet` DISABLE KEYS */;
INSERT INTO `ProstheticSheet` VALUES ('01043ec4-297d-11ef-8e16-d517f37fa2ad',11,'01038baa-297d-11ef-8e16-d517f37fa2ad','{\n    \"v2\": {\n        \"brandScanBody\": \"Biotech Dental\",\n        \"comment\": \"\",\n        \"language\": \"it_IT\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"refImplant\": \"\",\n        \"refScanBody\": \"KPOPSCANP\",\n        \"selectedTeeth\": [\n            17\n        ],\n        \"sheetTitle\": \"Corona su impianto\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 1,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-13 14:01:40.856','2024-06-13 14:08:56.937','2024-06-13 14:03:53.648','2024-06-13 12:08:56.940',NULL),('0187dad0-28a0-11ef-8e16-d517f37fa2ad',5,'0187211b-28a0-11ef-8e16-d517f37fa2ad','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            27\n        ],\n        \"sheetTitle\": \"Autre\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','24467343-28a0-11ef-8e16-d517f37fa2ad','2024-06-12 11:41:55.000',NULL,'2024-06-12 11:42:57.000','2024-06-12 09:42:57.000','2024-06-12 11:42:56.000'),('0565b1d1-27cb-11ef-8e37-d519fa9d22d2',2,'05654240-27cb-11ef-8e37-d519fa9d22d2','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            27\n        ],\n        \"sheetTitle\": \"cmde supprimée puis telechargée via la discussion (reception)\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-11 10:16:56.757',NULL,'2024-06-11 10:17:19.417','2024-06-11 08:17:19.431',NULL),('08f50e63-2980-11ef-8e16-d517f37fa2ad',11,'08f4c372-2980-11ef-8e16-d517f37fa2ad','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"it_IT\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            12,\n            11,\n            21,\n            22\n        ],\n        \"sheetTitle\": \"faccette per i denti 11 e 12\",\n        \"specificTint\": \"\",\n        \"type\": 6,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','202d91d6-2984-11ef-8e16-d517f37fa2ad','2024-06-13 14:25:30.000',NULL,'2024-06-13 14:54:56.000','2024-06-13 12:54:56.000','2024-06-13 14:54:55.000'),('0bd6b363-23e9-11ef-8dde-d415e84cc4f5',3,'0bd68b18-23e9-11ef-8dde-d415e84cc4f5','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            23\n        ],\n        \"sheetTitle\": \"Facette\",\n        \"specificTint\": \"\",\n        \"type\": 6,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','336ff6af-23e9-11ef-8dde-d415e84cc4f5','2024-06-06 11:42:07.000',NULL,'2024-06-06 11:43:19.000','2024-06-06 09:43:19.000','2024-06-06 11:43:18.000'),('0becb7bc-273b-11ef-8e16-d517f37fa1ab',2,'0bec570d-273b-11ef-8e16-d517f37fa1ab','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            26\n        ],\n        \"sheetTitle\": \"Facette\",\n        \"specificTint\": \"\",\n        \"type\": 6,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-10 17:06:09.962','2024-06-10 17:07:19.449','2024-06-10 17:06:42.839','2024-06-10 15:07:19.451',NULL),('0becd06d-273b-11ef-8e16-d517f37fa1ab',2,'0bec570d-273b-11ef-8e16-d517f37fa1ab','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            16,\n            15,\n            14\n        ],\n        \"sheetTitle\": \"Bridge\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 4,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-10 17:06:15.281','2024-06-10 17:07:19.449','2024-06-10 17:06:42.840','2024-06-10 15:07:19.452',NULL),('0becea1a-273b-11ef-8e16-d517f37fa1ab',2,'0bec570d-273b-11ef-8e16-d517f37fa1ab','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            21,\n            22,\n            23\n        ],\n        \"sheetTitle\": \"Autre\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-10 17:06:21.433','2024-06-10 17:07:19.449','2024-06-10 17:06:42.840','2024-06-10 15:07:19.453',NULL),('0bed02df-273b-11ef-8e16-d517f37fa1ab',2,'0bec570d-273b-11ef-8e16-d517f37fa1ab','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            38,\n            37,\n            36,\n            35,\n            34,\n            33,\n            32,\n            31,\n            41,\n            42,\n            43,\n            44,\n            45,\n            46,\n            47,\n            48\n        ],\n        \"sheetTitle\": \"Gouttière\",\n        \"subType\": 0,\n        \"type\": 10,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-10 17:06:27.452','2024-06-10 17:07:19.449','2024-06-10 17:06:42.841','2024-06-10 15:07:19.453',NULL),('0bed1b8a-273b-11ef-8e16-d517f37fa1ab',2,'0bec570d-273b-11ef-8e16-d517f37fa1ab','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            12\n        ],\n        \"sheetTitle\": \"Facette\",\n        \"specificTint\": \"\",\n        \"type\": 6,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-10 17:06:33.860','2024-06-10 17:07:19.449','2024-06-10 17:06:42.842','2024-06-10 15:07:19.454',NULL),('0bed338e-273b-11ef-8e16-d517f37fa1ab',2,'0bec570d-273b-11ef-8e16-d517f37fa1ab','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            27\n        ],\n        \"sheetTitle\": \"Couronne\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 0,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-10 17:06:40.129','2024-06-10 17:07:19.449','2024-06-10 17:06:42.842','2024-06-10 15:07:19.455',NULL),('0d19d364-289a-11ef-8e16-d517f37fa2ad',5,'0d191b14-289a-11ef-8e16-d517f37fa2ad','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"Guide\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','bdb51817-289d-11ef-8e16-d517f37fa2ad','2024-06-12 10:59:15.000',NULL,'2024-06-12 11:25:46.000','2024-06-12 09:40:43.000','2024-06-12 11:40:43.000'),('11965988-28bb-11ef-8e16-d517f37fa2ad',5,'1195a226-28bb-11ef-8e16-d517f37fa2ad','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"Amovible\",\n        \"specificTint\": \"\",\n        \"type\": 7,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-12 14:55:34.320',NULL,'2024-06-12 14:55:39.084','2024-06-12 12:55:39.091',NULL),('15fe3749-2e4b-11ef-8deb-d515ea58f6cb',2,'15fd7f91-2e4b-11ef-8deb-d515ea58f6cb','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"en_US\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            14\n        ],\n        \"sheetTitle\": \"Crown\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 0,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','259181e4-2e4c-11ef-8deb-d515ea58f6cb','2024-06-19 16:49:07.000',NULL,'2024-06-19 16:56:48.000','2024-06-19 14:56:48.000','2024-06-19 16:56:47.000'),('164b388e-2e43-11ef-8deb-d515ea58f6cb',2,'164af3dc-2e43-11ef-8deb-d515ea58f6cb','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"en_GB\",\n        \"selectedTeeth\": [\n            27\n        ],\n        \"sheetTitle\": \"Other\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','912d936b-2e43-11ef-8deb-d515ea58f6cb','2024-06-19 15:51:52.000',NULL,'2024-06-19 15:55:23.000','2024-06-19 13:55:23.000','2024-06-19 15:55:22.000'),('1b98609b-2e0d-11ef-8deb-d515ea58f6cb',2,'1b97a50e-2e0d-11ef-8deb-d515ea58f6cb','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"it_IT\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            26\n        ],\n        \"sheetTitle\": \"Faccetta\",\n        \"specificTint\": \"\",\n        \"type\": 6,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-19 09:25:28.011',NULL,'2024-06-19 09:25:31.064','2024-06-19 07:25:31.067',NULL),('1cba20ce-271f-11ef-8e16-d517f37fa1ab',2,'1cba063b-271f-11ef-8e16-d517f37fa1ab','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            26\n        ],\n        \"sheetTitle\": \"Facette\",\n        \"specificTint\": \"\",\n        \"type\": 6,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','8e2e7cc7-2738-11ef-8e16-d517f37fa1ab','2024-06-10 13:46:42.683',NULL,'2024-06-10 16:48:52.884','2024-06-10 14:48:53.601',NULL),('2274d2f6-2e42-11ef-8deb-d515ea58f6cb',2,'22749c4a-2e42-11ef-8deb-d515ea58f6cb','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"en_GB\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            25\n        ],\n        \"sheetTitle\": \"Crown\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 0,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','a0bfc6a3-2e4d-11ef-8deb-d515ea58f6cb','2024-06-19 15:45:05.000',NULL,'2024-06-19 15:45:35.000','2024-06-19 15:07:24.000','2024-06-19 17:07:24.000'),('2b44b0e4-28ca-11ef-8e16-d517f37fa2ad',5,'2b43e016-28ca-11ef-8e16-d517f37fa2ad','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            24,\n            25,\n            26\n        ],\n        \"sheetTitle\": \"Bridge\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 4,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-12 16:43:43.170',NULL,'2024-06-12 16:43:44.620','2024-06-12 14:43:44.623',NULL),('36577990-2e35-11ef-8deb-d515ea58f6cb',2,'36573909-2e35-11ef-8deb-d515ea58f6cb','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"it_IT\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"Altro\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-19 14:12:31.958',NULL,'2024-06-19 14:12:35.806','2024-06-19 12:12:35.807',NULL),('46a01fb1-27cb-11ef-8e37-d519fa9d22d2',2,'469fbbe0-27cb-11ef-8e37-d519fa9d22d2','{\n    \"v2\": {\n        \"comment\": \"ajout d\'infos en cours d\'acte\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            24\n        ],\n        \"sheetTitle\": \"Autre, chgt dent en cours d\'acte\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-11 10:19:06.807',NULL,'2024-06-11 10:19:08.852','2024-06-11 08:36:57.016',NULL),('470b6f09-2963-11ef-8e16-d517f37fa2ad',11,'470ab6fc-2963-11ef-8e16-d517f37fa2ad','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"it_IT\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"Altro\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','dd2934fd-2986-11ef-8e16-d517f37fa2ad','2024-06-13 10:59:34.000',NULL,'2024-06-13 15:14:31.000','2024-06-13 13:14:31.000','2024-06-13 15:14:31.000'),('4ba7be39-2987-11ef-8e16-d517f37fa2ad',11,'4ba706eb-2987-11ef-8e16-d517f37fa2ad','{\n    \"v2\": {\n        \"comment\": \"test\",\n        \"language\": \"it_IT\",\n        \"prostheticContactPoint\": 2,\n        \"prostheticMaterial\": 2,\n        \"selectedTeeth\": [\n            17,\n            16,\n            15\n        ],\n        \"sheetTitle\": \"Ponte 17-16-15\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 4,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','2a2ce13d-2988-11ef-8e16-d517f37fa2ad','2024-06-13 15:16:49.000',NULL,'2024-06-13 15:23:50.000','2024-06-13 13:23:50.000','2024-06-13 15:23:49.000'),('54f30b51-273a-11ef-8e16-d517f37fa1ab',2,'54f2a3d2-273a-11ef-8e16-d517f37fa1ab','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            26\n        ],\n        \"sheetTitle\": \"Autre\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-10 17:01:34.149',NULL,'2024-06-10 17:01:35.857','2024-06-10 15:01:35.865',NULL),('58f9b117-298a-11ef-8e16-d517f37fa2ad',2,'58f912aa-298a-11ef-8e16-d517f37fa2ad','{\n    \"v2\": {\n        \"brandScanBody\": \"Autre\",\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"refImplant\": \"\",\n        \"refScanBody\": \"hfgh\",\n        \"selectedTeeth\": [\n            16\n        ],\n        \"sheetTitle\": \"Couronne sur implant\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 1,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-13 15:39:14.821',NULL,'2024-06-13 15:39:24.676','2024-06-13 13:39:24.678',NULL),('5f36b93e-27f1-11ef-8e37-d519fa9d22d2',2,'5f367bea-27f1-11ef-8e37-d519fa9d22d2','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            16\n        ],\n        \"sheetTitle\": \"Autre\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-11 14:51:48.761',NULL,'2024-06-11 14:51:50.980','2024-06-11 12:51:50.981',NULL),('5f4e1774-28bf-11ef-8e16-d517f37fa2ad',5,'5f4d6750-28bf-11ef-8e16-d517f37fa2ad','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            28\n        ],\n        \"sheetTitle\": \"Facette\",\n        \"specificTint\": \"\",\n        \"type\": 6,\n        \"usePrePreparation\": false,\n        \"useScanSup\": true\n    }\n}\n',NULL,'2024-06-12 15:26:25.456',NULL,'2024-06-12 15:26:27.459','2024-06-12 15:58:17.947',NULL),('62836a9a-289b-11ef-8e16-d517f37fa2ad',5,'6282c146-289b-11ef-8e16-d517f37fa2ad','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            27\n        ],\n        \"sheetTitle\": \"Autre\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','c13314ae-289e-11ef-8e16-d517f37fa2ad','2024-06-12 11:08:48.000',NULL,'2024-06-12 11:33:01.000','2024-06-12 09:33:01.000','2024-06-12 11:33:00.000'),('62bfac14-226c-11ef-8d76-d310d2ec2c14',2,'62bf4a87-226c-11ef-8d76-d310d2ec2c14','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            16\n        ],\n        \"sheetTitle\": \"fait sous env2\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','66bc3d46-2272-11ef-8d76-d310d2ec2c14','2024-06-04 14:17:12.000',NULL,'2024-06-04 15:00:23.000','2024-06-04 13:00:23.000','2024-06-04 15:00:23.000'),('68b5463b-2e42-11ef-8deb-d515ea58f6cb',2,'68b5196a-2e42-11ef-8deb-d515ea58f6cb','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"en_GB\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            11\n        ],\n        \"sheetTitle\": \"Removable\",\n        \"specificTint\": \"\",\n        \"type\": 7,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','e386f28a-2e42-11ef-8deb-d515ea58f6cb','2024-06-19 15:46:23.000',NULL,'2024-06-19 15:50:13.000','2024-06-19 13:50:32.000','2024-06-19 15:54:11.000'),('72bfd4ee-2a20-11ef-8f1c-d8242c6fa8fd',11,'72bf1875-2a20-11ef-8f1c-d8242c6fa8fd','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"it_IT\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"Bite\",\n        \"subType\": 0,\n        \"type\": 10,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-14 09:33:45.332','2024-06-14 10:38:31.795','2024-06-14 09:33:53.947','2024-06-14 08:38:31.798',NULL),('78bd3516-2255-11ef-8e3f-d619fca54465',3,'78bd1c4c-2255-11ef-8e3f-d619fca54465','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"fait sur env2\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-04 11:32:53.106',NULL,'2024-06-04 11:33:16.500','2024-06-04 09:33:16.501',NULL),('80d8ccdc-27cb-11ef-8e37-d519fa9d22d2',2,'80d86971-27cb-11ef-8e37-d519fa9d22d2','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            27\n        ],\n        \"sheetTitle\": \"Amovible\",\n        \"specificTint\": \"\",\n        \"type\": 7,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-11 10:20:44.915',NULL,'2024-06-11 10:20:46.531','2024-06-11 08:20:46.533',NULL),('85a01bc4-2e40-11ef-8deb-d515ea58f6cb',2,'859f5fed-2e40-11ef-8deb-d515ea58f6cb','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"en_GB\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            25\n        ],\n        \"sheetTitle\": \"Crown\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 0,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','ca082562-2e41-11ef-8deb-d515ea58f6cb','2024-06-19 15:33:31.000',NULL,'2024-06-19 15:42:40.000','2024-06-19 13:42:40.000','2024-06-19 15:42:39.000'),('8c161f30-2735-11ef-8e16-d517f37fa1ab',2,'8c15b440-2735-11ef-8e16-d517f37fa1ab','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            25\n        ],\n        \"sheetTitle\": \"Autre\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','d316761c-27c8-11ef-8e37-d519fa9d22d2','2024-06-10 16:27:17.000','2024-06-11 10:08:24.000','2024-06-11 10:01:40.000','2024-06-11 08:08:24.000','2024-06-11 10:08:20.000'),('8c70efe3-28b0-11ef-8e16-d517f37fa2ad',5,'8c703315-28b0-11ef-8e16-d517f37fa2ad','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            27\n        ],\n        \"sheetTitle\": \"Autre\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-12 13:40:20.728',NULL,'2024-06-12 13:40:20.734','2024-06-12 11:40:20.754',NULL),('8d0d7a54-2a29-11ef-8f1c-d8242c6fa8fd',11,'8d0cbb85-2a29-11ef-8f1c-d8242c6fa8fd','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"it_IT\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            47\n        ],\n        \"sheetTitle\": \"Corona\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 0,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','145531e1-2a2f-11ef-8f1c-d8242c6fa8fd','2024-06-14 10:38:55.000',NULL,'2024-06-14 11:18:41.000','2024-06-14 09:18:41.000','2024-06-14 11:18:40.000'),('8d253467-23eb-11ef-8dde-d415e84cc4f5',3,'8d24e986-23eb-11ef-8dde-d415e84cc4f5','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            16\n        ],\n        \"sheetTitle\": \"Autre\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','9a5291cb-23eb-11ef-8dde-d415e84cc4f5','2024-06-06 12:00:03.833',NULL,'2024-06-06 12:00:28.517','2024-06-06 10:00:29.223',NULL),('8e87bced-296b-11ef-8e16-d517f37fa2ad',11,'8e871a0f-296b-11ef-8e16-d517f37fa2ad','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"it_IT\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            26\n        ],\n        \"sheetTitle\": \"Corona\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 0,\n        \"usePrePreparation\": false,\n        \"useScanSup\": false\n    }\n}\n','fb07e2bb-2970-11ef-8e16-d517f37fa2ad','2024-06-13 11:58:53.000',NULL,'2024-06-13 12:37:53.000','2024-06-13 10:37:53.000','2024-06-13 12:37:52.000'),('957a9074-2e29-11ef-8deb-d515ea58f6cb',2,'9579e61c-2e29-11ef-8deb-d515ea58f6cb','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            15\n        ],\n        \"sheetTitle\": \"Couronne\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 0,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-19 12:49:19.282',NULL,'2024-06-19 12:49:21.460','2024-06-19 10:49:21.462',NULL),('96b55c0e-23e7-11ef-8dde-d415e84cc4f5',3,'96b5001d-23e7-11ef-8dde-d415e84cc4f5','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            16\n        ],\n        \"sheetTitle\": \"Couronne\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 0,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','fafc415d-23e7-11ef-8dde-d415e84cc4f5','2024-06-06 11:31:40.000',NULL,'2024-06-06 11:34:35.000','2024-06-06 09:34:35.000','2024-06-06 11:34:34.000'),('9ca270cc-28ba-11ef-8e16-d517f37fa2ad',5,'9ca1b461-28ba-11ef-8e16-d517f37fa2ad','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            27\n        ],\n        \"sheetTitle\": \"Autre\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-12 14:52:20.374','2024-06-12 14:54:09.505','2024-06-12 14:52:22.869','2024-06-12 12:54:09.508',NULL),('a1f11d47-298a-11ef-8e16-d517f37fa2ad',2,'a1f09971-298a-11ef-8e16-d517f37fa2ad','{\n    \"v2\": {\n        \"brandScanBody\": \"Autre\",\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"refImplant\": \"\",\n        \"refScanBody\": \"gfhgfdhg\",\n        \"selectedTeeth\": [\n            16\n        ],\n        \"sheetTitle\": \"Couronne sur implant\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 1,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-13 15:41:20.183',NULL,'2024-06-13 15:41:27.093','2024-06-13 13:41:27.095',NULL),('a422b539-2279-11ef-8d76-d310d2ec2c14',2,'a4229655-2279-11ef-8d76-d310d2ec2c14','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            11\n        ],\n        \"sheetTitle\": \"Facette\",\n        \"specificTint\": \"\",\n        \"type\": 6,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','113e7226-2734-11ef-8e16-d517f37fa1ab','2024-06-04 15:52:07.000',NULL,'2024-06-04 16:10:55.000','2024-06-10 14:16:48.000','2024-06-10 16:16:47.000'),('afad695f-2271-11ef-8d76-d310d2ec2c14',2,'afad1449-2271-11ef-8d76-d310d2ec2c14','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            16\n        ],\n        \"sheetTitle\": \"Facette\",\n        \"specificTint\": \"\",\n        \"type\": 6,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','2cf3311a-2272-11ef-8d76-d310d2ec2c14','2024-06-04 14:55:09.662',NULL,'2024-06-04 14:58:44.753','2024-06-04 12:58:45.488','2024-06-04 14:58:47.214'),('bb00adeb-273a-11ef-8e16-d517f37fa1ab',2,'bb004dd6-273a-11ef-8e16-d517f37fa1ab','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            26\n        ],\n        \"sheetTitle\": \"Autre\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-10 17:04:25.059','2024-06-10 17:05:41.397','2024-06-10 17:04:27.074','2024-06-10 15:05:41.400',NULL),('be9ff276-2735-11ef-8e16-d517f37fa1ab',2,'be9f95d2-2735-11ef-8e16-d517f37fa1ab','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            27\n        ],\n        \"sheetTitle\": \"Autre\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','9c24cd94-27ce-11ef-8e37-d519fa9d22d2','2024-06-10 16:28:43.000',NULL,'2024-06-11 10:43:04.000','2024-06-11 08:43:04.000','2024-06-11 10:43:03.000'),('bed32cbc-273c-11ef-8e16-d517f37fa1ab',2,'bed2bb1e-273c-11ef-8e16-d517f37fa1ab','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            25\n        ],\n        \"sheetTitle\": \"Couronne\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 0,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','adfd6dd3-27ca-11ef-8e37-d519fa9d22d2','2024-06-10 17:18:50.616','2024-06-11 10:15:33.706','2024-06-11 10:14:52.772','2024-06-11 08:15:33.713',NULL),('c88d7af3-2e3c-11ef-8deb-d515ea58f6cb',2,'c88ceca6-2e3c-11ef-8deb-d515ea58f6cb','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"en_GB\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            26\n        ],\n        \"sheetTitle\": \"Removable\",\n        \"specificTint\": \"\",\n        \"type\": 7,\n        \"usePrePreparation\": false,\n        \"useScanSup\": true\n    }\n}\n',NULL,'2024-06-19 15:06:41.191',NULL,'2024-06-19 15:06:47.585','2024-06-19 13:06:47.594',NULL),('cc4145f0-297d-11ef-8e16-d517f37fa2ad',11,'cc4112f9-297d-11ef-8e16-d517f37fa2ad','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"it_IT\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"Altro\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','9d433d29-297e-11ef-8e16-d517f37fa2ad','2024-06-13 14:09:29.184',NULL,'2024-06-13 14:15:25.283','2024-06-13 12:15:26.025',NULL),('d2d092cd-2985-11ef-8e16-d517f37fa2ad',11,'d2cfcd57-2985-11ef-8e16-d517f37fa2ad','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"it_IT\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            12,\n            11,\n            21,\n            22\n        ],\n        \"sheetTitle\": \"faccette per i denti 11 e 12\",\n        \"specificTint\": \"\",\n        \"type\": 6,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','3cf533b7-2986-11ef-8e16-d517f37fa2ad','2024-06-13 15:07:01.000',NULL,'2024-06-13 15:10:03.000','2024-06-13 13:10:03.000','2024-06-13 15:10:02.000'),('d7108012-298d-11ef-8e16-d517f37fa2ad',11,'d7104c8e-298d-11ef-8e16-d517f37fa2ad','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"it_IT\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"scansione della situazione\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-13 16:04:06.385',NULL,'2024-06-13 16:04:24.708','2024-06-13 14:04:24.709',NULL),('da25dfe6-2e3a-11ef-8deb-d515ea58f6cb',2,'da257486-2e3a-11ef-8deb-d515ea58f6cb','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"en_GB\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            16\n        ],\n        \"sheetTitle\": \"Crown\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 0,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','5c16705b-2e3c-11ef-8deb-d515ea58f6cb','2024-06-19 14:52:55.000',NULL,'2024-06-19 15:03:48.000','2024-06-19 13:03:48.000','2024-06-19 15:03:47.000'),('da3c31e5-227c-11ef-8d76-d310d2ec2c14',2,'da3bcb3f-227c-11ef-8d76-d310d2ec2c14','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            26\n        ],\n        \"sheetTitle\": \"Autre\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','080061b0-2403-11ef-8dde-d415e84cc4f5','2024-06-04 16:15:03.058',NULL,'2024-06-06 14:48:10.953','2024-06-06 12:48:11.666',NULL),('ddb09738-289e-11ef-8e16-d517f37fa2ad',5,'ddb0571c-289e-11ef-8e16-d517f37fa2ad','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            27\n        ],\n        \"sheetTitle\": \"Autre\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','a6fb3865-289f-11ef-8e16-d517f37fa2ad','2024-06-12 11:33:46.000',NULL,'2024-06-12 11:39:27.000','2024-06-12 09:39:27.000','2024-06-12 11:39:26.000'),('de09a40c-2e4d-11ef-8deb-d515ea58f6cb',2,'de096a3e-2e4d-11ef-8deb-d515ea58f6cb','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"en_GB\",\n        \"selectedTeeth\": [\n            27\n        ],\n        \"sheetTitle\": \"Other\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','e58acb2d-2e4d-11ef-8deb-d515ea58f6cb','2024-06-19 17:09:02.000',NULL,'2024-06-19 17:09:20.000','2024-06-19 15:09:20.000','2024-06-19 17:09:19.000'),('e387c17a-289f-11ef-8e16-d517f37fa2ad',5,'e387023b-289f-11ef-8e16-d517f37fa2ad','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"Guide\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','6f42baa5-28a0-11ef-8e16-d517f37fa2ad','2024-06-12 11:41:05.000',NULL,'2024-06-12 11:45:02.000','2024-06-12 09:45:02.000','2024-06-12 11:45:02.000'),('ea241232-2e41-11ef-8deb-d515ea58f6cb',2,'ea2350dd-2e41-11ef-8deb-d515ea58f6cb','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"en_GB\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            25\n        ],\n        \"sheetTitle\": \"Crown\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 0,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','eea0c13a-2e41-11ef-8deb-d515ea58f6cb','2024-06-19 15:43:31.000',NULL,'2024-06-19 15:43:41.000','2024-06-19 13:43:41.000','2024-06-19 15:43:40.000'),('eb84a227-2fa4-11ef-8e5c-d61b03bfb54e',2,'eb83e66a-2fa4-11ef-8e5c-d61b03bfb54e','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"en_GB\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"Other\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-21 10:04:42.511',NULL,'2024-06-21 10:04:45.135','2024-06-21 08:04:45.138',NULL),('f1e82ca7-2e4d-11ef-8deb-d515ea58f6cb',2,'f1e7f15b-2e4d-11ef-8deb-d515ea58f6cb','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"en_GB\",\n        \"selectedTeeth\": [\n            27\n        ],\n        \"sheetTitle\": \"Other\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','f9c06fb9-2e4d-11ef-8deb-d515ea58f6cb','2024-06-19 17:09:38.000',NULL,'2024-06-19 17:09:54.000','2024-06-19 15:09:54.000','2024-06-19 17:09:53.000'),('f267a422-2272-11ef-8d76-d310d2ec2c14',2,'f26746c9-2272-11ef-8d76-d310d2ec2c14','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            14\n        ],\n        \"sheetTitle\": \"Autre\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','307ab64c-2279-11ef-8d76-d310d2ec2c14','2024-06-04 15:03:25.000',NULL,'2024-06-04 16:10:56.000','2024-06-04 14:10:56.000','2024-06-04 16:10:54.000'),('f3057582-2731-11ef-8e16-d517f37fa1ab',2,'f30520c9-2731-11ef-8e16-d517f37fa1ab','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            28\n        ],\n        \"sheetTitle\": \"Autre\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-10 16:01:31.286',NULL,'2024-06-10 16:01:35.588','2024-06-10 14:01:35.591',NULL),('f3d4f049-27d1-11ef-8e37-d519fa9d22d2',2,'f3d4cf05-27d1-11ef-8e37-d519fa9d22d2','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            17\n        ],\n        \"sheetTitle\": \"Autre\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-11 11:06:53.334',NULL,'2024-06-11 11:06:56.424','2024-06-11 09:06:56.425',NULL),('fe78c638-28bf-11ef-8e16-d517f37fa2ad',5,'fe784ee0-28bf-11ef-8e16-d517f37fa2ad','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            27\n        ],\n        \"sheetTitle\": \"Facette\",\n        \"specificTint\": \"\",\n        \"type\": 6,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-12 15:30:48.340','2024-06-12 17:57:47.298','2024-06-12 15:30:54.496','2024-06-12 15:57:47.300',NULL),('fe78d23e-28bf-11ef-8e16-d517f37fa2ad',5,'fe784ee0-28bf-11ef-8e16-d517f37fa2ad','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            23\n        ],\n        \"sheetTitle\": \"Couronne\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 0,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-12 15:30:50.243','2024-06-12 17:57:47.298','2024-06-12 15:30:54.497','2024-06-12 15:57:47.302',NULL),('fe78dc61-28bf-11ef-8e16-d517f37fa2ad',5,'fe784ee0-28bf-11ef-8e16-d517f37fa2ad','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            11\n        ],\n        \"sheetTitle\": \"Autre\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-12 15:30:51.999','2024-06-12 17:57:47.298','2024-06-12 15:30:54.497','2024-06-12 15:57:47.303',NULL),('ff4b3c7d-272f-11ef-8e16-d517f37fa1ab',2,'ff4af3b3-272f-11ef-8e16-d517f37fa1ab','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            25\n        ],\n        \"sheetTitle\": \"Facette\",\n        \"specificTint\": \"\",\n        \"type\": 6,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-10 15:47:31.476',NULL,'2024-06-10 15:47:37.184','2024-06-10 13:47:37.185',NULL);
/*!40000 ALTER TABLE `ProstheticSheet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ReceivedAttachment`
--

DROP TABLE IF EXISTS `ReceivedAttachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ReceivedAttachment` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `receivedMessageId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  PRIMARY KEY (`receivedMessageId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `ReceivedAttachment_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `ReceivedAttachment_ibfk_2` FOREIGN KEY (`receivedMessageId`) REFERENCES `ReceivedMessage` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ReceivedAttachment_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ReceivedAttachment`
--

LOCK TABLES `ReceivedAttachment` WRITE;
/*!40000 ALTER TABLE `ReceivedAttachment` DISABLE KEYS */;
INSERT INTO `ReceivedAttachment` VALUES (2,'2291be68-2984-11ef-867c-6ec2958327c0','22927091-2984-11ef-867c-6ec2958327c0'),(2,'2291be68-2984-11ef-867c-6ec2958327c0','22a0b370-2984-11ef-867c-6ec2958327c0'),(2,'2291be68-2984-11ef-867c-6ec2958327c0','22ade901-2984-11ef-867c-6ec2958327c0'),(2,'2291be68-2984-11ef-867c-6ec2958327c0','22ae315a-2984-11ef-867c-6ec2958327c0'),(2,'2291be68-2984-11ef-867c-6ec2958327c0','22ae75c5-2984-11ef-867c-6ec2958327c0'),(2,'2291be68-2984-11ef-867c-6ec2958327c0','22aeb6c7-2984-11ef-867c-6ec2958327c0'),(2,'2291be68-2984-11ef-867c-6ec2958327c0','22aef86a-2984-11ef-867c-6ec2958327c0'),(2,'2291be68-2984-11ef-867c-6ec2958327c0','22b1f5c3-2984-11ef-867c-6ec2958327c0'),(2,'22c5afed-296b-11ef-867c-6ec2958327c0','22ecf343-296b-11ef-867c-6ec2958327c0'),(2,'22c5afed-296b-11ef-867c-6ec2958327c0','22f04150-296b-11ef-867c-6ec2958327c0'),(2,'22c5afed-296b-11ef-867c-6ec2958327c0','22f0827d-296b-11ef-867c-6ec2958327c0'),(2,'22c5afed-296b-11ef-867c-6ec2958327c0','22f0d1a2-296b-11ef-867c-6ec2958327c0'),(2,'22c5afed-296b-11ef-867c-6ec2958327c0','22f11528-296b-11ef-867c-6ec2958327c0'),(2,'22c5afed-296b-11ef-867c-6ec2958327c0','22f2c0d8-296b-11ef-867c-6ec2958327c0'),(2,'22c5afed-296b-11ef-867c-6ec2958327c0','22f3003b-296b-11ef-867c-6ec2958327c0'),(2,'22c5afed-296b-11ef-867c-6ec2958327c0','22f34008-296b-11ef-867c-6ec2958327c0'),(2,'2e8fba03-2ef1-11ef-bb8b-6ec2958327c0','2e90846e-2ef1-11ef-bb8b-6ec2958327c0'),(2,'2e8fba03-2ef1-11ef-bb8b-6ec2958327c0','2e90f815-2ef1-11ef-bb8b-6ec2958327c0'),(2,'2e8fba03-2ef1-11ef-bb8b-6ec2958327c0','2e9143e7-2ef1-11ef-bb8b-6ec2958327c0'),(2,'2e8fba03-2ef1-11ef-bb8b-6ec2958327c0','2e917c0b-2ef1-11ef-bb8b-6ec2958327c0'),(2,'2e8fba03-2ef1-11ef-bb8b-6ec2958327c0','2e91ba31-2ef1-11ef-bb8b-6ec2958327c0'),(2,'2e8fba03-2ef1-11ef-bb8b-6ec2958327c0','2e91f327-2ef1-11ef-bb8b-6ec2958327c0'),(2,'2e8fba03-2ef1-11ef-bb8b-6ec2958327c0','2e922e08-2ef1-11ef-bb8b-6ec2958327c0'),(2,'2e8fba03-2ef1-11ef-bb8b-6ec2958327c0','2e926c06-2ef1-11ef-bb8b-6ec2958327c0'),(2,'2e8fba03-2ef1-11ef-bb8b-6ec2958327c0','2e92ab5d-2ef1-11ef-bb8b-6ec2958327c0'),(2,'355a78ac-23e9-11ef-867c-6ec2958327c0','355b14f8-23e9-11ef-867c-6ec2958327c0'),(2,'355a78ac-23e9-11ef-867c-6ec2958327c0','355b5fea-23e9-11ef-867c-6ec2958327c0'),(2,'355a78ac-23e9-11ef-867c-6ec2958327c0','355bb3c0-23e9-11ef-867c-6ec2958327c0'),(2,'72b8ceea-2ef1-11ef-bb8b-6ec2958327c0','72b9a13e-2ef1-11ef-bb8b-6ec2958327c0'),(2,'79c4003d-2cba-11ef-bb8b-6ec2958327c0','79cb66b6-2cba-11ef-bb8b-6ec2958327c0'),(2,'79c4003d-2cba-11ef-bb8b-6ec2958327c0','79cc071e-2cba-11ef-bb8b-6ec2958327c0'),(2,'79c4003d-2cba-11ef-bb8b-6ec2958327c0','79cc4cbf-2cba-11ef-bb8b-6ec2958327c0'),(2,'8423e77f-2ee8-11ef-bb8b-6ec2958327c0','84250955-2ee8-11ef-bb8b-6ec2958327c0'),(2,'8423e77f-2ee8-11ef-bb8b-6ec2958327c0','84255147-2ee8-11ef-bb8b-6ec2958327c0'),(2,'8423e77f-2ee8-11ef-bb8b-6ec2958327c0','84259467-2ee8-11ef-bb8b-6ec2958327c0'),(2,'8423e77f-2ee8-11ef-bb8b-6ec2958327c0','8425da8f-2ee8-11ef-bb8b-6ec2958327c0'),(2,'8423e77f-2ee8-11ef-bb8b-6ec2958327c0','84261829-2ee8-11ef-bb8b-6ec2958327c0'),(2,'8423e77f-2ee8-11ef-bb8b-6ec2958327c0','842973df-2ee8-11ef-bb8b-6ec2958327c0'),(2,'8423e77f-2ee8-11ef-bb8b-6ec2958327c0','8429be0d-2ee8-11ef-bb8b-6ec2958327c0'),(2,'8423e77f-2ee8-11ef-bb8b-6ec2958327c0','842bb5a1-2ee8-11ef-bb8b-6ec2958327c0'),(2,'8423e77f-2ee8-11ef-bb8b-6ec2958327c0','842bff38-2ee8-11ef-bb8b-6ec2958327c0'),(2,'8423e77f-2ee8-11ef-bb8b-6ec2958327c0','842c426e-2ee8-11ef-bb8b-6ec2958327c0'),(2,'87d817cd-2cba-11ef-bb8b-6ec2958327c0','87d88f9b-2cba-11ef-bb8b-6ec2958327c0'),(2,'87d817cd-2cba-11ef-bb8b-6ec2958327c0','87db7d98-2cba-11ef-bb8b-6ec2958327c0'),(2,'a1d987bf-23eb-11ef-867c-6ec2958327c0','a1f8fad4-23eb-11ef-867c-6ec2958327c0'),(2,'a1d987bf-23eb-11ef-867c-6ec2958327c0','a1fba852-23eb-11ef-867c-6ec2958327c0'),(2,'a1d987bf-23eb-11ef-867c-6ec2958327c0','a1fc17b1-23eb-11ef-867c-6ec2958327c0'),(2,'a51c72fb-297e-11ef-867c-6ec2958327c0','a51fa049-297e-11ef-867c-6ec2958327c0'),(2,'a51c72fb-297e-11ef-867c-6ec2958327c0','a51ff66b-297e-11ef-867c-6ec2958327c0'),(2,'a51c72fb-297e-11ef-867c-6ec2958327c0','a5203d7a-297e-11ef-867c-6ec2958327c0'),(2,'b6280065-27ca-11ef-867c-6ec2958327c0','b63c4aa8-27ca-11ef-867c-6ec2958327c0'),(2,'b6280065-27ca-11ef-867c-6ec2958327c0','b63cb440-27ca-11ef-867c-6ec2958327c0'),(2,'b6280065-27ca-11ef-867c-6ec2958327c0','b63e0a77-27ca-11ef-867c-6ec2958327c0'),(2,'e628e177-2eed-11ef-bb8b-6ec2958327c0','e6296994-2eed-11ef-bb8b-6ec2958327c0'),(2,'e628e177-2eed-11ef-bb8b-6ec2958327c0','e629af92-2eed-11ef-bb8b-6ec2958327c0'),(2,'e628e177-2eed-11ef-bb8b-6ec2958327c0','e62a0cee-2eed-11ef-bb8b-6ec2958327c0'),(2,'e628e177-2eed-11ef-bb8b-6ec2958327c0','e62a6228-2eed-11ef-bb8b-6ec2958327c0'),(2,'e628e177-2eed-11ef-bb8b-6ec2958327c0','e62ac4a7-2eed-11ef-bb8b-6ec2958327c0'),(2,'e628e177-2eed-11ef-bb8b-6ec2958327c0','e62b1ba6-2eed-11ef-bb8b-6ec2958327c0'),(2,'e628e177-2eed-11ef-bb8b-6ec2958327c0','e62b626a-2eed-11ef-bb8b-6ec2958327c0'),(2,'fd83553d-2970-11ef-867c-6ec2958327c0','fd842fda-2970-11ef-867c-6ec2958327c0'),(2,'fd83553d-2970-11ef-867c-6ec2958327c0','fd84690a-2970-11ef-867c-6ec2958327c0'),(2,'fd83553d-2970-11ef-867c-6ec2958327c0','fd84a61f-2970-11ef-867c-6ec2958327c0'),(2,'fd83553d-2970-11ef-867c-6ec2958327c0','fd84df26-2970-11ef-867c-6ec2958327c0'),(2,'fd83553d-2970-11ef-867c-6ec2958327c0','fd85311c-2970-11ef-867c-6ec2958327c0'),(2,'fd83553d-2970-11ef-867c-6ec2958327c0','fd856ebc-2970-11ef-867c-6ec2958327c0'),(2,'fd83553d-2970-11ef-867c-6ec2958327c0','fd85a7c5-2970-11ef-867c-6ec2958327c0'),(2,'fd83553d-2970-11ef-867c-6ec2958327c0','fd85defa-2970-11ef-867c-6ec2958327c0'),(3,'0d0c6171-225e-11ef-867c-6ec2958327c0','0d165e5f-225e-11ef-867c-6ec2958327c0'),(3,'0fe8b36e-2403-11ef-867c-6ec2958327c0','0fed9cbc-2403-11ef-867c-6ec2958327c0'),(3,'0fe8b36e-2403-11ef-867c-6ec2958327c0','0fef6e20-2403-11ef-867c-6ec2958327c0'),(3,'0fe8b36e-2403-11ef-867c-6ec2958327c0','0fefdd19-2403-11ef-867c-6ec2958327c0'),(3,'116b5d2e-225d-11ef-867c-6ec2958327c0','1171b033-225d-11ef-867c-6ec2958327c0'),(3,'116b5d2e-225d-11ef-867c-6ec2958327c0','117372ab-225d-11ef-867c-6ec2958327c0'),(3,'116b5d2e-225d-11ef-867c-6ec2958327c0','1173c2f4-225d-11ef-867c-6ec2958327c0'),(3,'116b5d2e-225d-11ef-867c-6ec2958327c0','1174111e-225d-11ef-867c-6ec2958327c0'),(3,'116b5d2e-225d-11ef-867c-6ec2958327c0','11745799-225d-11ef-867c-6ec2958327c0'),(3,'116b5d2e-225d-11ef-867c-6ec2958327c0','11749a5a-225d-11ef-867c-6ec2958327c0'),(3,'116b5d2e-225d-11ef-867c-6ec2958327c0','117c269a-225d-11ef-867c-6ec2958327c0'),(3,'116b5d2e-225d-11ef-867c-6ec2958327c0','117c6e59-225d-11ef-867c-6ec2958327c0'),(3,'1775a92f-2a2f-11ef-bb8b-6ec2958327c0','17783f50-2a2f-11ef-bb8b-6ec2958327c0'),(3,'1775a92f-2a2f-11ef-bb8b-6ec2958327c0','17788e11-2a2f-11ef-bb8b-6ec2958327c0'),(3,'1775a92f-2a2f-11ef-bb8b-6ec2958327c0','1778cdc2-2a2f-11ef-bb8b-6ec2958327c0'),(3,'1775a92f-2a2f-11ef-bb8b-6ec2958327c0','17790e23-2a2f-11ef-bb8b-6ec2958327c0'),(3,'1775a92f-2a2f-11ef-bb8b-6ec2958327c0','1779a47e-2a2f-11ef-bb8b-6ec2958327c0'),(3,'1775a92f-2a2f-11ef-bb8b-6ec2958327c0','1779e2aa-2a2f-11ef-bb8b-6ec2958327c0'),(3,'1775a92f-2a2f-11ef-bb8b-6ec2958327c0','177a30cc-2a2f-11ef-bb8b-6ec2958327c0'),(3,'1775a92f-2a2f-11ef-bb8b-6ec2958327c0','177a7405-2a2f-11ef-bb8b-6ec2958327c0'),(3,'1775a92f-2a2f-11ef-bb8b-6ec2958327c0','177aab27-2a2f-11ef-bb8b-6ec2958327c0'),(3,'1775a92f-2a2f-11ef-bb8b-6ec2958327c0','177ae1c6-2a2f-11ef-bb8b-6ec2958327c0'),(3,'1775a92f-2a2f-11ef-bb8b-6ec2958327c0','177b199c-2a2f-11ef-bb8b-6ec2958327c0'),(3,'1775a92f-2a2f-11ef-bb8b-6ec2958327c0','177b4c35-2a2f-11ef-bb8b-6ec2958327c0'),(3,'1775a92f-2a2f-11ef-bb8b-6ec2958327c0','177b8664-2a2f-11ef-bb8b-6ec2958327c0'),(3,'1775a92f-2a2f-11ef-bb8b-6ec2958327c0','177bc955-2a2f-11ef-bb8b-6ec2958327c0'),(3,'1775a92f-2a2f-11ef-bb8b-6ec2958327c0','177c0583-2a2f-11ef-bb8b-6ec2958327c0'),(3,'1775a92f-2a2f-11ef-bb8b-6ec2958327c0','177c3fbd-2a2f-11ef-bb8b-6ec2958327c0'),(3,'1775a92f-2a2f-11ef-bb8b-6ec2958327c0','177d2b5d-2a2f-11ef-bb8b-6ec2958327c0'),(3,'2c660856-2988-11ef-867c-6ec2958327c0','2c87fd80-2988-11ef-867c-6ec2958327c0'),(3,'2c660856-2988-11ef-867c-6ec2958327c0','2c8aa466-2988-11ef-867c-6ec2958327c0'),(3,'2c660856-2988-11ef-867c-6ec2958327c0','2c8ae6d8-2988-11ef-867c-6ec2958327c0'),(3,'2c660856-2988-11ef-867c-6ec2958327c0','2c8b2c0c-2988-11ef-867c-6ec2958327c0'),(3,'3f85c6ed-2986-11ef-867c-6ec2958327c0','3f863fa8-2986-11ef-867c-6ec2958327c0'),(3,'3f85c6ed-2986-11ef-867c-6ec2958327c0','3f867bd2-2986-11ef-867c-6ec2958327c0'),(3,'3f85c6ed-2986-11ef-867c-6ec2958327c0','3f86b6ca-2986-11ef-867c-6ec2958327c0'),(3,'3f85c6ed-2986-11ef-867c-6ec2958327c0','3f86edf4-2986-11ef-867c-6ec2958327c0'),(3,'3f85c6ed-2986-11ef-867c-6ec2958327c0','3f871fe7-2986-11ef-867c-6ec2958327c0'),(3,'3f85c6ed-2986-11ef-867c-6ec2958327c0','3f87582b-2986-11ef-867c-6ec2958327c0'),(3,'3f85c6ed-2986-11ef-867c-6ec2958327c0','3f87900a-2986-11ef-867c-6ec2958327c0'),(3,'3f85c6ed-2986-11ef-867c-6ec2958327c0','3f87c5f4-2986-11ef-867c-6ec2958327c0'),(3,'3f85c6ed-2986-11ef-867c-6ec2958327c0','3f880239-2986-11ef-867c-6ec2958327c0'),(3,'3f85c6ed-2986-11ef-867c-6ec2958327c0','3f884750-2986-11ef-867c-6ec2958327c0'),(3,'3f85c6ed-2986-11ef-867c-6ec2958327c0','3f88890a-2986-11ef-867c-6ec2958327c0'),(3,'3f85c6ed-2986-11ef-867c-6ec2958327c0','3f8bd75a-2986-11ef-867c-6ec2958327c0'),(3,'3f85c6ed-2986-11ef-867c-6ec2958327c0','3f8c1b2d-2986-11ef-867c-6ec2958327c0'),(3,'ba5df9a1-2ee8-11ef-bb8b-6ec2958327c0','ba5e7db3-2ee8-11ef-bb8b-6ec2958327c0'),(3,'ba5df9a1-2ee8-11ef-bb8b-6ec2958327c0','ba622ef9-2ee8-11ef-bb8b-6ec2958327c0'),(3,'ba5df9a1-2ee8-11ef-bb8b-6ec2958327c0','ba627997-2ee8-11ef-bb8b-6ec2958327c0'),(3,'ba5df9a1-2ee8-11ef-bb8b-6ec2958327c0','ba62c37a-2ee8-11ef-bb8b-6ec2958327c0'),(3,'ba5df9a1-2ee8-11ef-bb8b-6ec2958327c0','ba6304d5-2ee8-11ef-bb8b-6ec2958327c0'),(3,'ba5df9a1-2ee8-11ef-bb8b-6ec2958327c0','ba634a29-2ee8-11ef-bb8b-6ec2958327c0'),(3,'ba5df9a1-2ee8-11ef-bb8b-6ec2958327c0','ba638ec6-2ee8-11ef-bb8b-6ec2958327c0'),(3,'ba5df9a1-2ee8-11ef-bb8b-6ec2958327c0','ba63dc6d-2ee8-11ef-bb8b-6ec2958327c0'),(3,'ba5df9a1-2ee8-11ef-bb8b-6ec2958327c0','ba642178-2ee8-11ef-bb8b-6ec2958327c0'),(3,'ba5df9a1-2ee8-11ef-bb8b-6ec2958327c0','ba646775-2ee8-11ef-bb8b-6ec2958327c0'),(3,'ba5df9a1-2ee8-11ef-bb8b-6ec2958327c0','ba64ace5-2ee8-11ef-bb8b-6ec2958327c0'),(3,'ba5df9a1-2ee8-11ef-bb8b-6ec2958327c0','ba64f8f3-2ee8-11ef-bb8b-6ec2958327c0'),(3,'ba5df9a1-2ee8-11ef-bb8b-6ec2958327c0','ba654268-2ee8-11ef-bb8b-6ec2958327c0'),(3,'ba5df9a1-2ee8-11ef-bb8b-6ec2958327c0','ba6586d0-2ee8-11ef-bb8b-6ec2958327c0'),(3,'ecaecc05-2a2f-11ef-bb8b-6ec2958327c0','ecaf393a-2a2f-11ef-bb8b-6ec2958327c0'),(3,'ecaecc05-2a2f-11ef-bb8b-6ec2958327c0','ecaf7806-2a2f-11ef-bb8b-6ec2958327c0'),(5,'961c14ed-2738-11ef-867c-6ec2958327c0','961d3bd6-2738-11ef-867c-6ec2958327c0'),(5,'961c14ed-2738-11ef-867c-6ec2958327c0','961d9540-2738-11ef-867c-6ec2958327c0'),(5,'961c14ed-2738-11ef-867c-6ec2958327c0','961de917-2738-11ef-867c-6ec2958327c0'),(5,'961c14ed-2738-11ef-867c-6ec2958327c0','961ee4a5-2738-11ef-867c-6ec2958327c0'),(5,'961c14ed-2738-11ef-867c-6ec2958327c0','961f37ca-2738-11ef-867c-6ec2958327c0'),(5,'961c14ed-2738-11ef-867c-6ec2958327c0','961f7d3f-2738-11ef-867c-6ec2958327c0'),(5,'961c14ed-2738-11ef-867c-6ec2958327c0','961fcfdc-2738-11ef-867c-6ec2958327c0'),(5,'9e850c8e-27ce-11ef-867c-6ec2958327c0','9e85e968-27ce-11ef-867c-6ec2958327c0'),(5,'9e850c8e-27ce-11ef-867c-6ec2958327c0','9e8635ca-27ce-11ef-867c-6ec2958327c0'),(5,'9e850c8e-27ce-11ef-867c-6ec2958327c0','9e99428e-27ce-11ef-867c-6ec2958327c0'),(5,'9e850c8e-27ce-11ef-867c-6ec2958327c0','9e999c8a-27ce-11ef-867c-6ec2958327c0'),(5,'9e850c8e-27ce-11ef-867c-6ec2958327c0','9e99fe68-27ce-11ef-867c-6ec2958327c0'),(5,'bec15e1a-2733-11ef-867c-6ec2958327c0','bedc779c-2733-11ef-867c-6ec2958327c0'),(5,'bec15e1a-2733-11ef-867c-6ec2958327c0','bee128b6-2733-11ef-867c-6ec2958327c0');
/*!40000 ALTER TABLE `ReceivedAttachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ReceivedMessage`
--

DROP TABLE IF EXISTS `ReceivedMessage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ReceivedMessage` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `messageTransmitted` tinyint(1) NOT NULL DEFAULT 0,
  `subject` varchar(255) DEFAULT NULL,
  `answeredId` varchar(36) DEFAULT NULL COMMENT 'SentMessage uuid or ReceivedMessage originMessageId',
  `body` text DEFAULT NULL,
  `fromId` mediumint(8) unsigned NOT NULL,
  `originMessageId` varchar(36) DEFAULT NULL,
  `discussionId` varchar(36) NOT NULL,
  `readStatus` enum('READ','UNREAD') DEFAULT 'UNREAD',
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `fromId` (`fromId`),
  KEY `discussionId` (`discussionId`,`ownerId`),
  CONSTRAINT `ReceivedMessage_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `ReceivedMessage_ibfk_2` FOREIGN KEY (`fromId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `ReceivedMessage_ibfk_3` FOREIGN KEY (`discussionId`, `ownerId`) REFERENCES `Discussion` (`uuid`, `ownerId`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ReceivedMessage`
--

LOCK TABLES `ReceivedMessage` WRITE;
/*!40000 ALTER TABLE `ReceivedMessage` DISABLE KEYS */;
INSERT INTO `ReceivedMessage` VALUES ('0364aeb9-2e42-11ef-bb8b-6ec2958327c0',2,1,'Order 6.3 [pc2]',NULL,'API_META={\"type\":\"order\",\"key\":\"cancelled\",\"title\":\"Order 6.3 [pc2]\",\"date\":\"2024-06-23T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-19T15:44:13+02:00\",\"orderId\":\"ea2350dd-2e41-11ef-8deb-d515ea58f6cb\"}',5,'82baf8ac-3ec0-4d1a-9b7b-b78aa318299d','8e7e9088-2733-11ef-8e16-d517f37fa1ab','READ','2024-06-19 15:44:13.000',NULL,'2024-06-19 15:44:13.000','2024-06-19 13:44:23.662','2024-06-19 15:44:23.674'),('0d0c6171-225e-11ef-867c-6ec2958327c0',3,1,'Commande 1.1',NULL,'envoi d\'une capture supp',2,'0d22759d-225e-11ef-8f1f-d8242c71b430','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-04 12:34:41.000',NULL,'2024-06-04 12:34:41.000','2024-06-04 10:34:51.927','2024-06-04 12:34:51.941'),('0df69ba3-2cbf-11ef-bb8b-6ec2958327c0',3,1,'0db3aecb-2cbf-11ef-8e27-d518f78fe3c8',NULL,'test nvelle discussion\n',2,'0db3aecb-2cbf-11ef-8e27-d518f78fe3c8','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-17 17:34:15.000',NULL,'2024-06-17 17:34:15.000','2024-06-20 09:38:43.000','2024-06-20 11:38:43.000'),('0f060cb3-23ea-11ef-867c-6ec2958327c0',3,1,'Commande 2.2 [pc1]',NULL,'bien receptionné sur ihm env1 mais obligation de valider la cmde via le web. réponse faite via le filtre de discussion activé',2,'0eb44d73-23ea-11ef-8f8c-d92a43d45e5a','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-06 11:49:24.000',NULL,'2024-06-06 11:49:24.000','2024-06-06 09:49:34.931','2024-06-06 11:49:34.942'),('0fe8b36e-2403-11ef-867c-6ec2958327c0',3,1,'Commande 3.1 [pc2]',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 3.1 [pc2]\",\"date\":\"2024-06-07T00:00:00\",\"orderUpdateTime\":\"2024-06-06T14:48:11\",\"orderId\":\"da3bcb3f-227c-11ef-8d76-d310d2ec2c14\"}',2,'0874bbc1-2403-11ef-8dde-d415e84cc4f5','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-06 14:48:11.000',NULL,'2024-06-06 14:48:11.000','2024-06-10 14:09:50.000','2024-06-10 16:09:50.000'),('116b5d2e-225d-11ef-867c-6ec2958327c0',3,1,'Commande 1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.1\",\"date\":\"2024-06-05T00:00:00\",\"orderUpdateTime\":\"2024-06-04T12:27:35\",\"orderId\":\"e3879e0c-225a-11ef-8f1f-d8242c71b430\"}',2,'0f3e4980-225d-11ef-8f1f-d8242c71b430','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-04 12:27:35.000',NULL,'2024-06-04 12:27:35.000','2024-06-04 10:27:59.942','2024-06-04 12:27:59.962'),('170f370c-23e8-11ef-867c-6ec2958327c0',3,1,'Commande 2.1',NULL,'API_META={\"type\":\"order\",\"key\":\"cancelled\",\"title\":\"Commande 2.1\",\"date\":\"2024-06-07T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-06T11:35:19+02:00\",\"orderId\":\"96b5001d-23e7-11ef-8dde-d415e84cc4f5\"}',6,'e8e0d490-f4d8-4b73-aec7-c871fbf26f95','ddab36aa-23e2-11ef-8f8c-d92a43d45e5a','READ','2024-06-06 11:35:19.000',NULL,'2024-06-06 11:35:19.000','2024-06-06 09:35:29.928','2024-06-06 11:35:29.940'),('1775a92f-2a2f-11ef-bb8b-6ec2958327c0',3,1,'Ordini 3.2',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Ordini 3.2\",\"date\":\"2024-06-15T00:00:00\",\"orderUpdateTime\":\"2024-06-14T11:18:38\",\"orderId\":\"8d0cbb85-2a29-11ef-8f1c-d8242c6fa8fd\"}',11,'14ca16db-2a2f-11ef-8f1c-d8242c6fa8fd','3d61afe1-2986-11ef-8e16-d517f37fa2ad','READ','2024-06-14 11:18:38.000',NULL,'2024-06-14 11:18:38.000','2024-06-20 09:38:53.016','2024-06-20 11:38:53.023'),('1c03505a-2987-11ef-867c-6ec2958327c0',11,1,'Ordini 1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"cancelled\",\"title\":\"Ordini 1.1\",\"date\":\"2024-06-14T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-13T15:16:13+02:00\",\"orderId\":\"8e871a0f-296b-11ef-8e16-d517f37fa2ad\"}',2,'f084f705-5f7b-4dac-af14-81f4808be17e','1a8fdf3a-296b-11ef-8e16-d517f37fa2ad','READ','2024-06-13 15:16:13.000',NULL,'2024-06-13 15:16:13.000','2024-06-13 13:16:23.000','2024-06-13 15:16:23.000'),('2291be68-2984-11ef-867c-6ec2958327c0',2,1,'Ordini 5.5',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Ordini 5.5\",\"date\":\"2024-06-14T00:00:00\",\"orderUpdateTime\":\"2024-06-13T14:54:53\",\"orderId\":\"08f4c372-2980-11ef-8e16-d517f37fa2ad\"}',11,'20a09331-2984-11ef-8e16-d517f37fa2ad','1a8fdf3a-296b-11ef-8e16-d517f37fa2ad','READ','2024-06-13 14:54:53.000',NULL,'2024-06-13 14:54:53.000','2024-06-17 13:16:55.381','2024-06-17 15:16:55.387'),('22c5afed-296b-11ef-867c-6ec2958327c0',2,1,'Ordini 5.1',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Ordini 5.1\",\"date\":\"2024-06-14T00:00:00\",\"orderUpdateTime\":\"2024-06-13T11:55:45\",\"orderId\":\"470ab6fc-2963-11ef-8e16-d517f37fa2ad\"}',11,'1a9029b2-296b-11ef-8e16-d517f37fa2ad','1a8fdf3a-296b-11ef-8e16-d517f37fa2ad','READ','2024-06-13 11:55:45.000',NULL,'2024-06-13 11:55:45.000','2024-06-17 13:16:57.000','2024-06-17 15:16:57.000'),('2ab80fc1-23eb-11ef-867c-6ec2958327c0',3,1,'Commande 1.1',NULL,'test envoi de la page discussion sur le web',2,'4db93275-aa1c-442f-b2b5-af6c4514bd24','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-06 11:57:21.000',NULL,'2024-06-06 11:57:21.000','2024-06-06 09:57:31.930','2024-06-06 11:57:31.941'),('2c660856-2988-11ef-867c-6ec2958327c0',3,1,'Ordini 4.1',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Ordini 4.1\",\"date\":\"2024-06-23T00:00:00\",\"orderUpdateTime\":\"2024-06-13T15:23:47\",\"orderId\":\"4ba706eb-2987-11ef-8e16-d517f37fa2ad\"}',11,'2aa35b06-2988-11ef-8e16-d517f37fa2ad','3d61afe1-2986-11ef-8e16-d517f37fa2ad','READ','2024-06-13 15:23:47.000',NULL,'2024-06-13 15:23:47.000','2024-06-13 13:23:53.000','2024-06-13 15:23:53.000'),('2e8fba03-2ef1-11ef-bb8b-6ec2958327c0',2,1,'Order 1.5',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Order 1.5\",\"date\":\"2024-06-22T00:00:00\",\"orderUpdateTime\":\"2024-06-20T10:38:05\",\"orderId\":\"8ffd5ce6-2eee-11ef-8dc9-d414e3397395\"}',12,'2d5d22eb-2ef1-11ef-8dc9-d414e3397395','82a44e97-2ee8-11ef-8dc9-d414e3397395','UNREAD','2024-06-20 12:38:05.000',NULL,'2024-06-20 12:38:05.000','2024-06-21 08:02:59.000','2024-06-21 10:02:59.000'),('31c11bd1-23e8-11ef-867c-6ec2958327c0',3,1,'Commande 2.1',NULL,'commande refusée par client leger et envoi de ce message via icone du tchat côté web',6,'6bc716cf-d2dc-4793-8776-6a7d195da882','ddab36aa-23e2-11ef-8f8c-d92a43d45e5a','READ','2024-06-06 11:36:04.000',NULL,'2024-06-06 11:36:04.000','2024-06-06 09:36:14.926','2024-06-06 11:36:14.937'),('355a78ac-23e9-11ef-867c-6ec2958327c0',2,1,'Commande 2.2 [pc1]',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 2.2 [pc1]\",\"date\":\"2024-06-07T00:00:00\",\"orderUpdateTime\":\"2024-06-06T11:43:17\",\"orderId\":\"0bd68b18-23e9-11ef-8dde-d415e84cc4f5\"}',3,'33e44dc1-23e9-11ef-8dde-d415e84cc4f5','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-06 11:43:17.000',NULL,'2024-06-06 11:43:17.000','2024-06-06 09:48:09.000','2024-06-06 11:48:09.000'),('3d3071a6-2ee9-11ef-bb8b-6ec2958327c0',3,1,'Order 1.1',NULL,'good morning, \nThe delay is short, but my patient can only come back that day. Thank you in advance',12,'3d53cd14-2ee9-11ef-8dc9-d414e3397395','b8d62e1b-2ee8-11ef-8dc9-d414e3397395','UNREAD','2024-06-20 11:41:16.000',NULL,'2024-06-20 11:41:16.000','2024-06-20 09:41:17.000','2024-06-20 11:41:17.000'),('3f85c6ed-2986-11ef-867c-6ec2958327c0',3,1,'Ordini 5.5',NULL,'API_META={\"type\":\"order\",\"key\":\"resent\",\"title\":\"Ordini 5.5\",\"date\":\"2024-06-14T00:00:00\",\"orderUpdateTime\":\"2024-06-13T15:10:00\",\"orderId\":\"d2cfcd57-2985-11ef-8e16-d517f37fa2ad\"}',11,'3d61fa93-2986-11ef-8e16-d517f37fa2ad','3d61afe1-2986-11ef-8e16-d517f37fa2ad','READ','2024-06-13 15:10:00.000',NULL,'2024-06-13 15:10:00.000','2024-06-13 13:12:44.000','2024-06-13 15:12:44.000'),('4ffecbc2-225d-11ef-867c-6ec2958327c0',2,1,'Commande 1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"edited\",\"title\":\"Commande 1.1\",\"date\":\"2024-06-06T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-04T12:29:24+02:00\",\"orderId\":\"e3879e0c-225a-11ef-8f1f-d8242c71b430\"}',3,'10351862-fb40-4aa9-a4ab-7afe4dba87b9','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-04 12:29:24.000',NULL,'2024-06-04 12:29:24.000','2024-06-04 10:29:35.000','2024-06-04 12:29:35.000'),('50383fde-23eb-11ef-867c-6ec2958327c0',3,1,'Commande 2.2',NULL,'API_META={\"type\":\"order\",\"key\":\"edited\",\"title\":\"Commande 2.2\",\"date\":\"2024-06-08T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-06T11:58:24+02:00\",\"orderId\":\"0bd68b18-23e9-11ef-8dde-d415e84cc4f5\"}',2,'e03dc949-f924-4e48-a5fd-e8273bbf6e07','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-06 11:58:24.000',NULL,'2024-06-06 11:58:24.000','2024-06-06 09:58:35.000','2024-06-06 11:58:35.000'),('518e163d-2e4c-11ef-bb8b-6ec2958327c0',2,1,'Order 17.1 [pc2]',NULL,'API_META={\"type\":\"order\",\"key\":\"validated\",\"title\":\"Order 17.1 [pc2]\",\"date\":\"2024-06-20T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-19T16:57:59+02:00\",\"orderId\":\"15fd7f91-2e4b-11ef-8deb-d515ea58f6cb\"}',5,'1aece6c3-d6b7-440e-aaeb-eae6fc0814b5','8e7e9088-2733-11ef-8e16-d517f37fa1ab','READ','2024-06-19 16:57:59.000',NULL,'2024-06-19 16:57:59.000','2024-06-19 14:58:09.682','2024-06-19 16:58:09.694'),('52634019-2986-11ef-867c-6ec2958327c0',11,1,'Ordini 5.5',NULL,'API_META={\"type\":\"order\",\"key\":\"validated\",\"title\":\"Ordini 5.5\",\"date\":\"2024-06-14T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-13T15:10:35+02:00\",\"orderId\":\"d2cfcd57-2985-11ef-8e16-d517f37fa2ad\"}',3,'b44b19e6-8bfe-477e-bdc3-5fda6f4b7bd3','3d61afe1-2986-11ef-8e16-d517f37fa2ad','READ','2024-06-13 15:10:35.000',NULL,'2024-06-13 15:10:35.000','2024-06-13 13:10:54.000','2024-06-13 15:10:54.000'),('550dc721-225d-11ef-867c-6ec2958327c0',3,1,'Commande 1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"validated\",\"title\":\"Commande 1.1\",\"date\":\"2024-06-06T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-04T12:29:32+02:00\",\"orderId\":\"e3879e0c-225a-11ef-8f1f-d8242c71b430\"}',2,'7c7133c4-869b-4ecf-be8c-a7ba25b96324','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-04 12:29:32.000',NULL,'2024-06-04 12:29:32.000','2024-06-04 10:29:42.913','2024-06-04 12:29:42.924'),('570e51d7-225e-11ef-867c-6ec2958327c0',2,1,'5701b18b-225e-11ef-8d76-d310d2ec2c14',NULL,'bla bla bla',3,'5701b18b-225e-11ef-8d76-d310d2ec2c14','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-04 12:36:45.000',NULL,'2024-06-04 12:36:45.000','2024-06-04 10:36:55.000','2024-06-04 12:36:55.000'),('572c8e2a-23ed-11ef-867c-6ec2958327c0',2,1,'Commande 2.3 [pc1]',NULL,'bla bla\n',3,'56f0c51f-23ed-11ef-8dde-d415e84cc4f5','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-06 12:12:54.000',NULL,'2024-06-06 12:12:54.000','2024-06-06 12:18:51.000','2024-06-06 14:18:51.000'),('5918016e-2e4c-11ef-bb8b-6ec2958327c0',2,1,'Answered in the web client',NULL,'bla bla',5,'ce070499-1028-415b-9e87-d170dfc82a91','8e7e9088-2733-11ef-8e16-d517f37fa1ab','READ','2024-06-19 16:58:11.000',NULL,'2024-06-19 16:58:11.000','2024-06-19 14:58:21.677','2024-06-19 16:58:21.688'),('5c246693-23e4-11ef-867c-6ec2958327c0',3,1,'5c02d3d5-23e4-11ef-8dde-d415e84cc4f5',NULL,'envoi d\'un message via env2',2,'5c02d3d5-23e4-11ef-8dde-d415e84cc4f5','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-06 11:08:37.000',NULL,'2024-06-06 11:08:37.000','2024-06-06 09:09:43.000','2024-06-06 11:09:43.000'),('62cf350a-225e-11ef-867c-6ec2958327c0',2,1,'Commande 1.1','0d22759d-225e-11ef-8f1f-d8242c71b430','bla bla bla',3,'62d4940c-225e-11ef-8d76-d310d2ec2c14','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-04 12:37:05.000',NULL,'2024-06-04 12:37:05.000','2024-06-04 10:37:15.000','2024-06-04 12:37:15.000'),('72b8ceea-2ef1-11ef-bb8b-6ec2958327c0',2,1,'Order 1.5',NULL,'additional measures if required\nhave a nice day',12,'72d001a0-2ef1-11ef-8dc9-d414e3397395','82a44e97-2ee8-11ef-8dc9-d414e3397395','UNREAD','2024-06-20 12:40:02.000',NULL,'2024-06-20 12:40:02.000','2024-06-21 08:02:59.000','2024-06-21 10:02:59.000'),('74d56a26-23e4-11ef-867c-6ec2958327c0',3,1,'Commande 1.1',NULL,'envoi d\'un message via web (env1.ci...)',2,'2f604f05-d11c-43d9-bdf9-d43e0306dfda','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-06 11:09:19.000',NULL,'2024-06-06 11:09:19.000','2024-06-06 09:09:43.000','2024-06-06 11:09:43.000'),('74f683c8-23ff-11ef-867c-6ec2958327c0',2,1,'Réponse depuis le web',NULL,'bla bla via page discussion du web',3,'59cfafae-e9ce-4a51-be20-09e9860da4b4','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-06 14:22:35.000',NULL,'2024-06-06 14:22:35.000','2024-06-06 12:22:45.929','2024-06-06 14:22:45.943'),('79c4003d-2cba-11ef-bb8b-6ec2958327c0',2,1,'Commande 1.3 [pc1]','75433112-226f-11ef-8f1f-d8242c71b430','Réponse de Hai Ha',4,'78297fff-2cba-11ef-8fb0-da2b4bf5ebbb','550eb27a-226b-11ef-8f1f-d8242c71b430','READ','2024-06-17 17:01:26.000',NULL,'2024-06-17 17:01:26.000','2024-06-17 15:01:37.000','2024-06-17 17:01:37.000'),('79d26d16-226b-11ef-867c-6ec2958327c0',2,1,'Commande 1.2',NULL,'demande de précision sur cmde1.2; blabla',4,'79e4936c-226b-11ef-8f1f-d8242c71b430','550eb27a-226b-11ef-8f1f-d8242c71b430','READ','2024-06-04 14:10:47.000',NULL,'2024-06-04 14:10:47.000','2024-06-04 12:11:54.915','2024-06-04 14:11:54.925'),('811ee1e1-2986-11ef-867c-6ec2958327c0',3,1,'Ordini 5.5',NULL,'Salve, \navete bisogno di altri documenti per questo caso?',11,'806e92df-2986-11ef-8e16-d517f37fa2ad','3d61afe1-2986-11ef-8e16-d517f37fa2ad','READ','2024-06-13 15:11:52.000',NULL,'2024-06-13 15:11:52.000','2024-06-13 13:12:44.000','2024-06-13 15:12:44.000'),('8423e77f-2ee8-11ef-bb8b-6ec2958327c0',2,1,'Order 1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Order 1.1\",\"date\":\"2024-06-21T00:00:00\",\"orderUpdateTime\":\"2024-06-20T09:36:03\",\"orderId\":\"9a8dd9c0-2edd-11ef-8de3-d515e950d747\"}',12,'82a48153-2ee8-11ef-8dc9-d414e3397395','82a44e97-2ee8-11ef-8dc9-d414e3397395','UNREAD','2024-06-20 11:36:03.000',NULL,'2024-06-20 11:36:03.000','2024-06-21 08:02:59.000','2024-06-21 10:02:59.000'),('87d817cd-2cba-11ef-bb8b-6ec2958327c0',2,1,'Commande 2.1 [pc2]','2d654e78-2272-11ef-8d76-d310d2ec2c14','Refaire',4,'86457a3d-2cba-11ef-8fb0-da2b4bf5ebbb','550eb27a-226b-11ef-8f1f-d8242c71b430','READ','2024-06-17 17:01:50.000',NULL,'2024-06-17 17:01:50.000','2024-06-17 15:02:00.794','2024-06-17 17:02:00.806'),('8cd2735c-2e4c-11ef-bb8b-6ec2958327c0',2,1,'Réponse depuis le web',NULL,'bla bla uk',5,'1264f3c9-5ecd-4376-b804-f051d49291ff','8e7e9088-2733-11ef-8e16-d517f37fa1ab','READ','2024-06-19 16:59:38.000',NULL,'2024-06-19 16:59:38.000','2024-06-19 14:59:48.681','2024-06-19 16:59:48.693'),('8f2a82bf-2733-11ef-867c-6ec2958327c0',5,1,'8e81ec28-2733-11ef-8e16-d517f37fa1ab',NULL,'1er message d\'envoi sans fichier',2,'8e81ec28-2733-11ef-8e16-d517f37fa1ab','8e7e9088-2733-11ef-8e16-d517f37fa1ab','READ','2024-06-10 16:13:05.000',NULL,'2024-06-10 16:13:05.000','2024-06-10 14:13:39.000','2024-06-10 16:13:39.000'),('93133bb9-2e4c-11ef-bb8b-6ec2958327c0',2,1,'Risposta Web',NULL,'bla bla it',5,'88bd7858-2cb2-4d7c-af4c-fcdd8088a5c5','8e7e9088-2733-11ef-8e16-d517f37fa1ab','READ','2024-06-19 16:59:49.000',NULL,'2024-06-19 16:59:49.000','2024-06-19 14:59:59.677','2024-06-19 16:59:59.687'),('961c14ed-2738-11ef-867c-6ec2958327c0',5,1,'Commande 2.2 [pc2]',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 2.2 [pc2]\",\"date\":\"2024-06-11T00:00:00\",\"orderUpdateTime\":\"2024-06-10T16:48:53\",\"orderId\":\"1cba063b-271f-11ef-8e16-d517f37fa1ab\"}',2,'8e9d97c9-2738-11ef-8e16-d517f37fa1ab','8e7e9088-2733-11ef-8e16-d517f37fa1ab','READ','2024-06-10 16:48:53.000',NULL,'2024-06-10 16:48:53.000','2024-06-12 09:42:13.000','2024-06-12 11:42:13.000'),('9687a4b2-23e4-11ef-867c-6ec2958327c0',2,1,'96378603-23e4-11ef-8f8c-d92a43d45e5a',NULL,'bla bla',3,'96378603-23e4-11ef-8f8c-d92a43d45e5a','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-06 11:10:15.000',NULL,'2024-06-06 11:10:15.000','2024-06-06 09:25:12.000','2024-06-06 11:25:12.000'),('97bd9d38-2e4d-11ef-bb8b-6ec2958327c0',2,1,'Order 6.3 [pc2]',NULL,'API_META={\"type\":\"order\",\"key\":\"edited\",\"title\":\"Order 6.3 [pc2]\",\"date\":\"2024-06-21T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-19T17:07:06+02:00\",\"orderId\":\"22749c4a-2e42-11ef-8deb-d515ea58f6cb\"}',5,'2af6851d-819a-42ce-a2d5-055fbcc5b6c5','8e7e9088-2733-11ef-8e16-d517f37fa1ab','READ','2024-06-19 17:07:06.000',NULL,'2024-06-19 17:07:06.000','2024-06-19 15:07:24.000','2024-06-19 17:07:24.000'),('9850d5ae-2738-11ef-867c-6ec2958327c0',2,1,'Commande 2.2',NULL,'API_META={\"type\":\"order\",\"key\":\"edited\",\"title\":\"Commande 2.2\",\"date\":\"2024-06-12T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-10T16:49:09+02:00\",\"orderId\":\"1cba063b-271f-11ef-8e16-d517f37fa1ab\"}',5,'fc040a6f-0868-41d5-af3d-0efefc71a692','8e7e9088-2733-11ef-8e16-d517f37fa1ab','READ','2024-06-10 16:49:09.000',NULL,'2024-06-10 16:49:09.000','2024-06-10 14:49:47.000','2024-06-10 16:49:47.000'),('995a2659-23ff-11ef-867c-6ec2958327c0',2,1,'Réponse depuis le web',NULL,'bla bla via tchat web de la cmde 2.3',3,'2192fe1a-0490-4bd9-8f2d-363155abc9a2','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-06 14:23:36.000',NULL,'2024-06-06 14:23:36.000','2024-06-06 12:23:46.931','2024-06-06 14:23:46.942'),('9e850c8e-27ce-11ef-867c-6ec2958327c0',5,1,'Commande 6.1 [pc2]',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 6.1 [pc2]\",\"date\":\"2024-06-12T00:00:00\",\"orderUpdateTime\":\"2024-06-11T10:43:01\",\"orderId\":\"be9f95d2-2735-11ef-8e16-d517f37fa1ab\"}',2,'9c944f7a-27ce-11ef-8e37-d519fa9d22d2','8e7e9088-2733-11ef-8e16-d517f37fa1ab','READ','2024-06-11 10:43:01.000',NULL,'2024-06-11 10:43:01.000','2024-06-12 09:42:12.000','2024-06-12 11:42:12.000'),('9e94da22-23e4-11ef-867c-6ec2958327c0',2,1,'Commande 1.1','2f604f05-d11c-43d9-bdf9-d43e0306dfda','bla bla',3,'9e44f2e9-23e4-11ef-8f8c-d92a43d45e5a','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-06 11:10:28.000',NULL,'2024-06-06 11:10:28.000','2024-06-06 09:25:11.000','2024-06-06 11:25:11.000'),('9f06134f-2e43-11ef-bb8b-6ec2958327c0',2,1,'Order 6.5 [pc2]',NULL,'API_META={\"type\":\"order\",\"key\":\"validated\",\"title\":\"Order 6.5 [pc2]\",\"date\":\"2024-06-21T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-19T15:55:43+02:00\",\"orderId\":\"164af3dc-2e43-11ef-8deb-d515ea58f6cb\"}',5,'c505f3cb-5f59-49ae-beab-ea072cdeec62','8e7e9088-2733-11ef-8e16-d517f37fa1ab','READ','2024-06-19 15:55:43.000',NULL,'2024-06-19 15:55:43.000','2024-06-19 13:55:53.671','2024-06-19 15:55:53.685'),('a1d987bf-23eb-11ef-867c-6ec2958327c0',2,1,'Commande 2.3 [pc1]',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 2.3 [pc1]\",\"date\":\"2024-06-07T00:00:00\",\"orderUpdateTime\":\"2024-06-06T12:00:29\",\"orderId\":\"8d24e986-23eb-11ef-8dde-d415e84cc4f5\"}',3,'9ac047ea-23eb-11ef-8dde-d415e84cc4f5','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-06 12:00:29.000',NULL,'2024-06-06 12:00:29.000','2024-06-06 10:01:33.000','2024-06-06 12:01:33.000'),('a23452cc-2e3c-11ef-bb8b-6ec2958327c0',2,1,'Order 16.2 [pc2]',NULL,'API_META={\"type\":\"order\",\"key\":\"validated\",\"title\":\"Order 16.2 [pc2]\",\"date\":\"2024-06-20T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-19T15:05:42+02:00\",\"orderId\":\"da257486-2e3a-11ef-8deb-d515ea58f6cb\"}',5,'6c6ba4cd-912b-4d4d-9f94-25d490087c3e','8e7e9088-2733-11ef-8e16-d517f37fa1ab','READ','2024-06-19 15:05:42.000',NULL,'2024-06-19 15:05:42.000','2024-06-19 13:05:52.654','2024-06-19 15:05:52.668'),('a51c72fb-297e-11ef-867c-6ec2958327c0',2,1,'Ordini 5.2',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Ordini 5.2\",\"date\":\"2024-06-15T00:00:00\",\"orderUpdateTime\":\"2024-06-13T14:15:26\",\"orderId\":\"cc4112f9-297d-11ef-8e16-d517f37fa2ad\"}',11,'9db6e18f-297e-11ef-8e16-d517f37fa2ad','1a8fdf3a-296b-11ef-8e16-d517f37fa2ad','READ','2024-06-13 14:15:26.000',NULL,'2024-06-13 14:15:26.000','2024-06-17 13:16:56.000','2024-06-17 15:16:56.000'),('a87a8b33-2986-11ef-867c-6ec2958327c0',11,1,'Réponse depuis le web',NULL,'no, va tutto bene, grazie ',3,'89d9cfe1-7384-4ce3-ae5e-89be13d7ae9d','3d61afe1-2986-11ef-8e16-d517f37fa2ad','READ','2024-06-13 15:13:00.000',NULL,'2024-06-13 15:13:00.000','2024-06-13 13:13:12.000','2024-06-13 15:13:12.000'),('a9caba3f-28a0-11ef-867c-6ec2958327c0',5,1,'Commande 1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"validated\",\"title\":\"Commande 1.1\",\"date\":\"2024-06-30T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-12T11:46:38+02:00\",\"orderId\":\"e387023b-289f-11ef-8e16-d517f37fa2ad\"}',9,'f59faffd-409c-416a-97eb-8b4f3a998dd6','be273be5-289d-11ef-8e16-d517f37fa2ad','READ','2024-06-12 11:46:38.000',NULL,'2024-06-12 11:46:38.000','2024-06-12 09:46:49.000','2024-06-12 11:46:49.000'),('ac040f77-2733-11ef-867c-6ec2958327c0',2,1,'Réponse depuis le web',NULL,'ok bien reçu, verif web',5,'2c4ce7cf-6875-4a7e-99de-470ca57d37cf','8e7e9088-2733-11ef-8e16-d517f37fa1ab','READ','2024-06-10 16:13:55.000',NULL,'2024-06-10 16:13:55.000','2024-06-10 14:14:06.000','2024-06-10 16:14:06.000'),('afb842b8-28a0-11ef-867c-6ec2958327c0',5,1,'Commande 1.2',NULL,'API_META={\"type\":\"order\",\"key\":\"cancelled\",\"title\":\"Commande 1.2\",\"date\":\"2024-06-29T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-12T11:46:47+02:00\",\"orderId\":\"0187211b-28a0-11ef-8e16-d517f37fa2ad\"}',9,'211a9722-fdfa-4ff5-9d10-8eb8359a03c8','be273be5-289d-11ef-8e16-d517f37fa2ad','READ','2024-06-12 11:46:47.000',NULL,'2024-06-12 11:46:47.000','2024-06-12 09:46:58.000','2024-06-12 11:46:58.000'),('aff5b8e7-24b0-11ef-867c-6ec2958327c0',2,1,'Commande 3.1',NULL,'API_META={\"type\":\"order\",\"key\":\"validated\",\"title\":\"Commande 3.1\",\"date\":\"2024-06-05T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-07T11:31:15+02:00\",\"orderId\":\"cdf680d9-227d-11ef-8f8c-d92a43d45d56\"}',4,'a41db7d3-7303-45b0-8303-b14769b1e4a1','550eb27a-226b-11ef-8f1f-d8242c71b430','READ','2024-06-07 11:31:15.000',NULL,'2024-06-07 11:31:15.000','2024-06-07 09:33:44.000','2024-06-07 11:33:44.000'),('b3261ac7-23e3-11ef-867c-6ec2958327c0',3,1,'Réponse depuis le web',NULL,'verification fait client leger accès adresse web env1.ci... et env2.ci...',6,'e01b5a33-cdcb-4378-86e6-18688bf5e2c7','ddab36aa-23e2-11ef-8f8c-d92a43d45e5a','READ','2024-06-06 11:03:54.000',NULL,'2024-06-06 11:03:54.000','2024-06-06 09:04:14.000','2024-06-06 11:04:14.000'),('b6280065-27ca-11ef-867c-6ec2958327c0',2,1,'Commande 7.2 [pc2]',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 7.2 [pc2]\",\"date\":\"2024-06-12T00:00:00\",\"orderUpdateTime\":\"2024-06-11T10:14:53\",\"orderId\":\"bed2bb1e-273c-11ef-8e16-d517f37fa1ab\"}',2,'ae66af70-27ca-11ef-8e37-d519fa9d22d2','ae662f01-27ca-11ef-8e37-d519fa9d22d2','READ','2024-06-11 10:14:54.000',NULL,'2024-06-11 10:14:53.000','2024-06-11 08:15:14.000','2024-06-11 10:15:14.000'),('b6cb7a0f-24b0-11ef-867c-6ec2958327c0',2,1,'Commande 1.3',NULL,'API_META={\"type\":\"order\",\"key\":\"edited\",\"title\":\"Commande 1.3\",\"date\":\"2024-06-09T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-07T11:31:27+02:00\",\"orderId\":\"a4229655-2279-11ef-8d76-d310d2ec2c14\"}',4,'7d0f691a-9c00-489d-8243-66ee0a86fdd9','550eb27a-226b-11ef-8f1f-d8242c71b430','READ','2024-06-07 11:31:27.000',NULL,'2024-06-07 11:31:27.000','2024-06-07 09:33:43.000','2024-06-07 11:33:43.000'),('ba55d273-27ca-11ef-867c-6ec2958327c0',2,1,'Commande 7.2',NULL,'commande que je vais supprimer via la fiche patient',2,'b9efc6fe-27ca-11ef-8e37-d519fa9d22d2','ae662f01-27ca-11ef-8e37-d519fa9d22d2','READ','2024-06-11 10:15:13.000',NULL,'2024-06-11 10:15:12.000','2024-06-11 08:15:24.000','2024-06-11 10:15:24.000'),('ba5df9a1-2ee8-11ef-bb8b-6ec2958327c0',3,1,'Order 1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"resent\",\"title\":\"Order 1.1\",\"date\":\"2024-06-21T00:00:00\",\"orderUpdateTime\":\"2024-06-20T09:37:34\",\"orderId\":\"afc82063-2ee8-11ef-8dc9-d414e3397395\"}',12,'b8d658c5-2ee8-11ef-8dc9-d414e3397395','b8d62e1b-2ee8-11ef-8dc9-d414e3397395','READ','2024-06-20 11:37:34.000',NULL,'2024-06-20 11:37:34.000','2024-06-20 09:38:42.000','2024-06-20 11:38:42.000'),('bb577816-24b0-11ef-867c-6ec2958327c0',2,1,'Commande 1.2',NULL,'API_META={\"type\":\"order\",\"key\":\"cancelled\",\"title\":\"Commande 1.2\",\"date\":\"2024-06-05T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-07T11:31:34+02:00\",\"orderId\":\"f26746c9-2272-11ef-8d76-d310d2ec2c14\"}',4,'fe6b754c-a512-46f3-9426-e30c1d545798','550eb27a-226b-11ef-8f1f-d8242c71b430','READ','2024-06-07 11:31:34.000',NULL,'2024-06-07 11:31:34.000','2024-06-07 09:33:43.000','2024-06-07 11:33:43.000'),('bec15e1a-2733-11ef-867c-6ec2958327c0',5,1,'be91b6bf-2733-11ef-8e16-d517f37fa1ab',NULL,'avec fichier',2,'be91b6bf-2733-11ef-8e16-d517f37fa1ab','8e7e9088-2733-11ef-8e16-d517f37fa1ab','READ','2024-06-10 16:14:26.000',NULL,'2024-06-10 16:14:26.000','2024-06-10 14:14:30.000','2024-06-10 16:14:30.000'),('c087e55d-2cc0-11ef-bb8b-6ec2958327c0',2,1,'c0651022-2cc0-11ef-8e27-d518f78fe3c8',NULL,'sans sujet',2,'c0651022-2cc0-11ef-8e27-d518f78fe3c8','ae662f01-27ca-11ef-8e37-d519fa9d22d2','READ','2024-06-17 17:46:25.000',NULL,'2024-06-17 17:46:24.000','2024-06-17 15:46:36.000','2024-06-17 17:46:36.000'),('c47e1cc6-23eb-11ef-867c-6ec2958327c0',3,1,'Commande 1.1',NULL,'bla bla',2,'4c1489bb-54c8-4aa3-8017-d140fe974c2f','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-06 12:01:39.000',NULL,'2024-06-06 12:01:39.000','2024-06-06 10:01:49.925','2024-06-06 12:01:49.937'),('c73ecc2b-2cc0-11ef-bb8b-6ec2958327c0',2,1,'c719b05f-2cc0-11ef-8e27-d518f78fe3c8',NULL,'bla bla',2,'c719b05f-2cc0-11ef-8e27-d518f78fe3c8','ae662f01-27ca-11ef-8e37-d519fa9d22d2','READ','2024-06-17 17:46:36.000',NULL,'2024-06-17 17:46:35.000','2024-06-17 15:46:46.772','2024-06-17 17:46:46.782'),('c950b265-2985-11ef-867c-6ec2958327c0',11,1,'Ordini 5.5',NULL,'API_META={\"type\":\"order\",\"key\":\"cancelled\",\"title\":\"Ordini 5.5\",\"date\":\"2024-06-14T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-13T15:06:45+02:00\",\"orderId\":\"08f4c372-2980-11ef-8e16-d517f37fa2ad\"}',2,'35f75e0f-a626-47c5-9d5b-946f217739af','1a8fdf3a-296b-11ef-8e16-d517f37fa2ad','READ','2024-06-13 15:06:45.000',NULL,'2024-06-13 15:06:45.000','2024-06-13 13:06:59.000','2024-06-13 15:06:59.000'),('ca89cb01-289e-11ef-867c-6ec2958327c0',5,1,'Commande 1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"edited\",\"title\":\"Commande 1.1\",\"date\":\"2024-06-28T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-12T11:33:13+02:00\",\"orderId\":\"0d191b14-289a-11ef-8e16-d517f37fa2ad\"}',9,'dbd7fb2c-bfad-4e4d-aa5a-4d5a1c5487b1','be273be5-289d-11ef-8e16-d517f37fa2ad','READ','2024-06-12 11:33:13.000',NULL,'2024-06-12 11:33:13.000','2024-06-12 09:33:29.000','2024-06-12 11:33:29.000'),('ce252bcd-289e-11ef-867c-6ec2958327c0',5,1,'Commande 1.2',NULL,'API_META={\"type\":\"order\",\"key\":\"cancelled\",\"title\":\"Commande 1.2\",\"date\":\"2024-06-14T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-12T11:33:20+02:00\",\"orderId\":\"6282c146-289b-11ef-8e16-d517f37fa2ad\"}',9,'3464711d-f05d-46d3-854a-0d62640fc514','be273be5-289d-11ef-8e16-d517f37fa2ad','READ','2024-06-12 11:33:20.000',NULL,'2024-06-12 11:33:20.000','2024-06-12 09:33:31.000','2024-06-12 11:33:31.000'),('d6b56b78-2986-11ef-867c-6ec2958327c0',11,1,'Ordini 5.1',NULL,'API_META={\"type\":\"order\",\"key\":\"edited\",\"title\":\"Ordini 5.1\",\"date\":\"2024-06-16T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-13T15:14:17+02:00\",\"orderId\":\"470ab6fc-2963-11ef-8e16-d517f37fa2ad\"}',2,'ee074334-fd31-4f09-a527-2f1a41048adb','1a8fdf3a-296b-11ef-8e16-d517f37fa2ad','READ','2024-06-13 15:14:17.000',NULL,'2024-06-13 15:14:17.000','2024-06-13 13:14:29.000','2024-06-13 15:14:29.000'),('dabd2a05-23eb-11ef-867c-6ec2958327c0',3,1,'Commande 2.3',NULL,'API_META={\"type\":\"order\",\"key\":\"validated\",\"title\":\"Commande 2.3\",\"date\":\"2024-06-07T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-06T12:02:16+02:00\",\"orderId\":\"8d24e986-23eb-11ef-8dde-d415e84cc4f5\"}',2,'ec59b1ff-79e7-49aa-9888-5b1e722d3d80','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-06 12:02:16.000',NULL,'2024-06-06 12:02:16.000','2024-06-06 10:02:27.000','2024-06-06 12:02:27.000'),('de752935-2986-11ef-867c-6ec2958327c0',2,1,'Ordini 5.1',NULL,'API_META={\"type\":\"order\",\"key\":\"validated\",\"title\":\"Ordini 5.1\",\"date\":\"2024-06-16T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-13T15:14:29+02:00\",\"orderId\":\"470ab6fc-2963-11ef-8e16-d517f37fa2ad\"}',11,'5c613afb-82ec-442d-8d9c-769d176f624d','1a8fdf3a-296b-11ef-8e16-d517f37fa2ad','READ','2024-06-13 15:14:30.000',NULL,'2024-06-13 15:14:30.000','2024-06-17 13:16:55.318','2024-06-17 15:16:55.327'),('decde8fb-2733-11ef-867c-6ec2958327c0',2,1,'Réponse depuis le web',NULL,'ok via web',5,'c13b3b06-ddd8-4a9e-a735-9592cf516fda','8e7e9088-2733-11ef-8e16-d517f37fa1ab','READ','2024-06-10 16:15:20.000',NULL,'2024-06-10 16:15:20.000','2024-06-10 14:15:31.000','2024-06-10 16:15:31.000'),('dfa4622b-2e42-11ef-bb8b-6ec2958327c0',2,1,'Order 6.4 [pc2]',NULL,'API_META={\"type\":\"order\",\"key\":\"edited\",\"title\":\"Order 6.4 [pc2]\",\"date\":\"2024-06-23T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-19T15:50:22+02:00\",\"orderId\":\"68b5196a-2e42-11ef-8deb-d515ea58f6cb\"}',5,'e438101c-048d-4348-ac15-18c51be0bc4d','8e7e9088-2733-11ef-8e16-d517f37fa1ab','READ','2024-06-19 15:50:22.000',NULL,'2024-06-19 15:50:22.000','2024-06-19 13:50:32.664','2024-06-19 15:50:32.676'),('e4a7c1f3-2e41-11ef-bb8b-6ec2958327c0',2,1,'Order 6.3 [pc2]',NULL,'API_META={\"type\":\"order\",\"key\":\"cancelled\",\"title\":\"Order 6.3 [pc2]\",\"date\":\"2024-06-20T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-19T15:43:21+02:00\",\"orderId\":\"859f5fed-2e40-11ef-8deb-d515ea58f6cb\"}',5,'99834a6e-1b91-4baa-b1d2-d300e1aae3da','8e7e9088-2733-11ef-8e16-d517f37fa1ab','READ','2024-06-19 15:43:21.000',NULL,'2024-06-19 15:43:21.000','2024-06-19 13:43:32.000','2024-06-19 15:43:32.000'),('e628e177-2eed-11ef-bb8b-6ec2958327c0',2,1,'Order 1.2',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Order 1.2\",\"date\":\"2024-06-23T00:00:00\",\"orderUpdateTime\":\"2024-06-20T10:14:26\",\"orderId\":\"ab653d64-2edd-11ef-8de3-d515e950d747\"}',12,'df68ce2f-2eed-11ef-8dc9-d414e3397395','82a44e97-2ee8-11ef-8dc9-d414e3397395','UNREAD','2024-06-20 12:14:26.000',NULL,'2024-06-20 12:14:26.000','2024-06-21 08:02:59.000','2024-06-21 10:02:59.000'),('ec83a561-2e4d-11ef-bb8b-6ec2958327c0',2,1,'Order 17.3 [pc2]',NULL,'API_META={\"type\":\"order\",\"key\":\"cancelled\",\"title\":\"Order 17.3 [pc2]\",\"date\":\"2024-06-20T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-19T17:09:28+02:00\",\"orderId\":\"de096a3e-2e4d-11ef-8deb-d515ea58f6cb\"}',5,'79a2a190-9fdf-4d95-bcd1-563524ad1b92','8e7e9088-2733-11ef-8e16-d517f37fa1ab','READ','2024-06-19 17:09:28.000',NULL,'2024-06-19 17:09:28.000','2024-06-19 15:09:39.000','2024-06-19 17:09:39.000'),('ecaecc05-2a2f-11ef-bb8b-6ec2958327c0',3,1,'Ordini 3.2',NULL,'misure aggiuntive',11,'eba48b0e-2a2f-11ef-8f1c-d8242c6fa8fd','3d61afe1-2986-11ef-8e16-d517f37fa2ad','READ','2024-06-14 11:24:39.000',NULL,'2024-06-14 11:24:39.000','2024-06-20 09:38:53.000','2024-06-20 11:38:53.000'),('ee1e58c0-23e2-11ef-867c-6ec2958327c0',3,1,'Réponse depuis le web',NULL,'bien receptionnée sous cette adresse web',6,'3780be11-022f-4964-b8ea-04a384437849','ddab36aa-23e2-11ef-8f8c-d92a43d45e5a','READ','2024-06-06 10:58:23.000',NULL,'2024-06-06 10:58:23.000','2024-06-06 08:58:36.000','2024-06-06 10:58:36.000'),('f39aca13-23e4-11ef-867c-6ec2958327c0',2,1,'f352fb85-23e4-11ef-8f8c-d92a43d45e5a',NULL,'test envoi texte sous discussion non filtrée',3,'f352fb85-23e4-11ef-8f8c-d92a43d45e5a','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-06 11:12:51.000',NULL,'2024-06-06 11:12:51.000','2024-06-06 09:25:11.000','2024-06-06 11:25:11.000'),('f4e1d5f4-23ea-11ef-867c-6ec2958327c0',3,1,'Commande 2.2 [pc1]',NULL,'réponse via web via le tchat de la cmde',2,'fad71f64-8b16-4fc8-94d4-6ae6473112ab','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-06 11:55:50.000',NULL,'2024-06-06 11:55:50.000','2024-06-06 09:56:45.926','2024-06-06 11:56:45.931'),('f6361962-2986-11ef-867c-6ec2958327c0',11,1,'Ordini 5.2',NULL,'API_META={\"type\":\"order\",\"key\":\"edited\",\"title\":\"Ordini 5.2\",\"date\":\"2024-06-16T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-13T15:15:10+02:00\",\"orderId\":\"cc4112f9-297d-11ef-8e16-d517f37fa2ad\"}',2,'792e2a4b-f301-41c9-893e-619fc4a73281','1a8fdf3a-296b-11ef-8e16-d517f37fa2ad','READ','2024-06-13 15:15:10.000',NULL,'2024-06-13 15:15:10.000','2024-06-13 13:15:20.000','2024-06-13 15:15:20.000'),('f6e94cf3-27c8-11ef-867c-6ec2958327c0',2,1,'Commande 5.1',NULL,'API_META={\"type\":\"order\",\"key\":\"validated\",\"title\":\"Commande 5.1\",\"date\":\"2024-06-12T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-11T10:02:36+02:00\",\"orderId\":\"8c15b440-2735-11ef-8e16-d517f37fa1ab\"}',4,'5996228b-c90a-4f7d-8d74-61a02ab5de03','550eb27a-226b-11ef-8f1f-d8242c71b430','READ','2024-06-11 10:02:36.000',NULL,'2024-06-11 10:02:36.000','2024-06-11 08:03:03.000','2024-06-11 10:03:03.000'),('fd3855a2-289f-11ef-867c-6ec2958327c0',5,1,'Commande 1.2',NULL,'API_META={\"type\":\"order\",\"key\":\"cancelled\",\"title\":\"Commande 1.2\",\"date\":\"2024-06-14T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-12T11:41:48+02:00\",\"orderId\":\"ddb0571c-289e-11ef-8e16-d517f37fa2ad\"}',9,'8c3afa31-0706-4295-bd8f-b942dba3e1c6','be273be5-289d-11ef-8e16-d517f37fa2ad','READ','2024-06-12 11:41:48.000',NULL,'2024-06-12 11:41:48.000','2024-06-12 09:41:57.000','2024-06-12 11:41:57.000'),('fd83553d-2970-11ef-867c-6ec2958327c0',2,1,'Ordini 1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Ordini 1.1\",\"date\":\"2024-06-14T00:00:00\",\"orderUpdateTime\":\"2024-06-13T12:37:50\",\"orderId\":\"8e871a0f-296b-11ef-8e16-d517f37fa2ad\"}',11,'fb782cec-2970-11ef-8e16-d517f37fa2ad','1a8fdf3a-296b-11ef-8e16-d517f37fa2ad','READ','2024-06-13 12:37:50.000',NULL,'2024-06-13 12:37:50.000','2024-06-17 13:16:56.000','2024-06-17 15:16:56.000');
/*!40000 ALTER TABLE `ReceivedMessage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Scan`
--

DROP TABLE IF EXISTS `Scan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Scan` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL,
  `sessionId` varchar(36) NOT NULL,
  `type` enum('MAXILLAIRE','MANDIBULE','MORDU_ANTERIEUR','MORDU_POSTERIEUR_GAUCHE','MORDU_POSTERIEUR_DROIT') NOT NULL,
  `label` enum('PRE_PREPARATION','SCAN','SCANBODY','SCAN_SUP') NOT NULL DEFAULT 'SCAN',
  `validated` tinyint(1) NOT NULL DEFAULT 0,
  `status` enum('IN_PROGRESS','NONE') NOT NULL DEFAULT 'IN_PROGRESS',
  `displayId` mediumint(8) unsigned DEFAULT NULL,
  `pcId` mediumint(8) unsigned DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT 0,
  `comments` text DEFAULT NULL,
  `createdById` varchar(36) DEFAULT NULL,
  `updatedById` varchar(36) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `sessionId` (`sessionId`),
  CONSTRAINT `Scan_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `Scan_ibfk_2` FOREIGN KEY (`sessionId`) REFERENCES `Session` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Scan`
--

LOCK TABLES `Scan` WRITE;
/*!40000 ALTER TABLE `Scan` DISABLE KEYS */;
INSERT INTO `Scan` VALUES ('00f317ff-2730-11ef-8e16-d517f37fa1ab',2,'ff4617e9-272f-11ef-8e16-d517f37fa1ab','MAXILLAIRE','SCAN',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-10 15:47:39.000',NULL,'2024-06-10 15:48:24.000','2024-06-10 13:48:29.000','2024-06-10 15:48:29.000'),('01f8eb7b-273e-11ef-8e09-d517f1736dc8',2,'f262aa99-2272-11ef-8d76-d310d2ec2c14','MANDIBULE','SCAN',1,'NONE',2,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-10 17:27:54.632',NULL,'2024-06-10 17:30:17.550','2024-06-10 15:30:17.550','2024-06-10 17:30:17.565'),('037dbcf6-297d-11ef-8e16-d517f37fa2ad',11,'01001128-297d-11ef-8e16-d517f37fa2ad','MAXILLAIRE','SCAN',1,'NONE',1,1,0,'','de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-13 14:03:57.799','2024-06-13 14:08:56.976','2024-06-13 14:08:56.977','2024-06-13 12:08:56.977','2024-06-13 14:08:56.998'),('099d82e1-2980-11ef-8e16-d517f37fa2ad',11,'08ed7a4a-2980-11ef-8e16-d517f37fa2ad','MAXILLAIRE','SCAN',1,'NONE',1,1,0,'','de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-13 14:25:36.564',NULL,'2024-06-13 14:52:49.938','2024-06-13 12:52:49.939','2024-06-13 14:52:49.973'),('0cf35705-2e42-11ef-8deb-d515ea58f6cb',2,'859bd7ba-2e40-11ef-8deb-d515ea58f6cb','MANDIBULE','SCAN',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-19 15:44:29.821',NULL,'2024-06-19 16:02:30.550','2024-06-19 14:02:30.550','2024-06-19 16:02:30.566'),('0d3f3b92-23e9-11ef-8dde-d415e84cc4f5',3,'0bcebe79-23e9-11ef-8dde-d415e84cc4f5','MAXILLAIRE','SCAN',1,'NONE',1,1,0,'','8df2a258-8868-49b7-91c2-e2d41d48bffc','8df2a258-8868-49b7-91c2-e2d41d48bffc','2024-06-06 11:42:12.837',NULL,'2024-06-06 11:42:51.563','2024-06-06 09:42:51.563','2024-06-06 11:42:51.583'),('0e172d2c-289a-11ef-8e16-d517f37fa2ad',5,'0d14f12a-289a-11ef-8e16-d517f37fa2ad','MAXILLAIRE','SCAN',1,'NONE',1,1,0,'','4e72ba02-814f-4116-88da-65f8da1fa385','4e72ba02-814f-4116-88da-65f8da1fa385','2024-06-12 10:59:19.825','2024-06-12 11:01:21.415','2024-06-12 11:01:21.415','2024-06-12 09:01:21.417','2024-06-12 11:01:21.443'),('12fa8aba-28bb-11ef-8e16-d517f37fa2ad',5,'11917a4e-28bb-11ef-8e16-d517f37fa2ad','MANDIBULE','SCAN',1,'NONE',1,1,0,'','4e72ba02-814f-4116-88da-65f8da1fa385','4e72ba02-814f-4116-88da-65f8da1fa385','2024-06-12 14:55:41.418',NULL,'2024-06-12 14:57:11.396','2024-06-12 12:57:11.396','2024-06-12 14:57:11.414'),('1737aea0-289c-11ef-8e16-d517f37fa2ad',5,'627f5b3e-289b-11ef-8e16-d517f37fa2ad','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,1,0,'','4e72ba02-814f-4116-88da-65f8da1fa385','4e72ba02-814f-4116-88da-65f8da1fa385','2024-06-12 11:13:54.131',NULL,'2024-06-12 11:14:40.950','2024-06-12 09:14:40.950','2024-06-12 11:14:40.967'),('1770b226-2e4b-11ef-8deb-d515ea58f6cb',2,'15f94c3c-2e4b-11ef-8deb-d515ea58f6cb','MAXILLAIRE','SCAN',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-19 16:49:12.890',NULL,'2024-06-19 16:56:24.942','2024-06-19 14:56:24.952','2024-06-19 16:56:24.975'),('1793bd69-2e43-11ef-8deb-d515ea58f6cb',2,'1643d04c-2e43-11ef-8deb-d515ea58f6cb','MAXILLAIRE','SCAN',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-19 15:51:57.146',NULL,'2024-06-19 15:54:05.643','2024-06-19 13:54:05.643','2024-06-19 16:48:43.771'),('18dce61e-2e3b-11ef-8deb-d515ea58f6cb',2,'da21a6e4-2e3a-11ef-8deb-d515ea58f6cb','MANDIBULE','SCAN',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-19 14:54:43.330',NULL,'2024-06-19 14:55:57.963','2024-06-19 12:55:57.963','2024-06-19 14:55:57.981'),('1c95cecd-2e0d-11ef-8deb-d515ea58f6cb',2,'1b9450aa-2e0d-11ef-8deb-d515ea58f6cb','MAXILLAIRE','SCAN',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-19 09:25:32.725',NULL,'2024-06-19 09:26:43.261','2024-06-19 07:26:43.261','2024-06-19 12:49:52.913'),('1d4719f4-2985-11ef-8e16-d517f37fa2ad',11,'a888b842-2984-11ef-8e16-d517f37fa2ad','MANDIBULE','SCAN',1,'NONE',1,1,0,'','de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-13 15:01:57.036',NULL,'2024-06-13 15:05:35.221','2024-06-13 13:05:35.221','2024-06-13 15:05:35.226'),('1db1e2d3-271f-11ef-8e16-d517f37fa1ab',2,'1cb90d11-271f-11ef-8e16-d517f37fa1ab','MAXILLAIRE','SCAN',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-10 13:46:46.000',NULL,'2024-06-11 10:45:13.241','2024-06-11 08:45:13.241','2024-06-11 10:45:13.255'),('1e568150-2e36-11ef-8deb-d515ea58f6cb',2,'36556270-2e35-11ef-8deb-d515ea58f6cb','MANDIBULE','SCAN',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-19 14:19:05.032',NULL,'2024-06-19 14:22:20.764','2024-06-19 12:22:20.765','2024-06-19 14:22:20.771'),('2ed06b9e-298f-11ef-8e16-d517f37fa2ad',11,'d70636d7-298d-11ef-8e16-d517f37fa2ad','MAXILLAIRE','SCAN',1,'NONE',1,1,0,'','de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-13 16:14:01.424',NULL,'2024-06-13 16:15:46.134','2024-06-13 14:15:46.134','2024-06-13 16:15:46.147'),('3447447c-2e3d-11ef-8deb-d515ea58f6cb',2,'af864e86-27f1-11ef-8e37-d519fa9d22d2','MANDIBULE','SCAN',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-19 15:09:48.319',NULL,'2024-06-19 15:19:00.381','2024-06-19 13:19:00.381','2024-06-19 15:19:00.393'),('366c0b70-2969-11ef-8e16-d517f37fa2ad',11,'4706df6f-2963-11ef-8e16-d517f37fa2ad','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',3,1,0,'','de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-13 11:42:13.313',NULL,'2024-06-13 11:44:12.817','2024-06-13 09:44:12.817','2024-06-13 11:46:12.355'),('366c910a-2969-11ef-8e16-d517f37fa2ad',11,'4706df6f-2963-11ef-8e16-d517f37fa2ad','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',3,1,0,'','de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-13 11:42:13.316',NULL,'2024-06-13 11:46:12.348','2024-06-13 09:46:12.348','2024-06-13 11:46:12.356'),('3754a3a0-2e35-11ef-8deb-d515ea58f6cb',2,'36556270-2e35-11ef-8deb-d515ea58f6cb','MAXILLAIRE','SCAN',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-19 14:12:37.466',NULL,'2024-06-19 14:22:30.276','2024-06-19 12:22:30.276','2024-06-19 14:22:30.289'),('389889a4-2272-11ef-8d76-d310d2ec2c14',2,'62bbada3-226c-11ef-8d76-d310d2ec2c14','MAXILLAIRE','SCAN',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-04 14:59:04.000',NULL,'2024-06-19 12:50:36.297','2024-06-19 10:50:36.297','2024-06-19 12:50:36.313'),('3e566183-296d-11ef-8e16-d517f37fa2ad',11,'8e83509f-296b-11ef-8e16-d517f37fa2ad','MAXILLAIRE','SCAN',1,'NONE',2,1,0,'','de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-13 12:11:04.579','2024-06-13 12:12:27.918','2024-06-13 12:12:27.918','2024-06-13 10:12:27.918','2024-06-13 12:12:27.934'),('4155dabe-2e4b-11ef-8deb-d515ea58f6cb',2,'15f94c3c-2e4b-11ef-8deb-d515ea58f6cb','MANDIBULE','SCAN',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-19 16:50:23.179',NULL,'2024-06-19 16:51:18.819','2024-06-19 14:51:18.819','2024-06-19 16:51:18.832'),('424c596f-2720-11ef-8e16-d517f37fa1ab',2,'1cb90d11-271f-11ef-8e16-d517f37fa1ab','MAXILLAIRE','SCAN',1,'NONE',2,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-10 13:54:57.000',NULL,'2024-06-10 13:56:21.000','2024-06-10 13:34:33.000','2024-06-10 15:34:33.000'),('4501387b-2274-11ef-8d76-d310d2ec2c14',2,'f262aa99-2272-11ef-8d76-d310d2ec2c14','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-04 15:13:44.000',NULL,'2024-06-04 15:14:54.000','2024-06-04 13:16:12.000','2024-06-04 15:16:12.000'),('4501cd03-2274-11ef-8d76-d310d2ec2c14',2,'f262aa99-2272-11ef-8d76-d310d2ec2c14','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-04 15:13:44.000',NULL,'2024-06-04 15:16:08.000','2024-06-04 13:16:13.000','2024-06-04 15:16:13.000'),('45dedff3-296f-11ef-8e16-d517f37fa2ad',11,'8e83509f-296b-11ef-8e16-d517f37fa2ad','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,1,0,'','de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-13 12:25:36.212',NULL,'2024-06-13 12:26:28.208','2024-06-13 10:26:28.209','2024-06-13 12:26:28.232'),('479072c7-27cb-11ef-8e37-d519fa9d22d2',2,'469bda30-27cb-11ef-8e37-d519fa9d22d2','MAXILLAIRE','SCAN',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-11 10:19:10.426',NULL,'2024-06-11 10:20:19.180','2024-06-11 08:20:19.181','2024-06-11 10:21:25.745'),('47f95341-2963-11ef-8e16-d517f37fa2ad',11,'4706df6f-2963-11ef-8e16-d517f37fa2ad','MAXILLAIRE','SCAN',1,'NONE',1,1,0,'','de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-13 10:59:45.779',NULL,'2024-06-13 11:56:20.965','2024-06-13 09:56:20.965','2024-06-13 11:56:20.987'),('4a3afb31-2985-11ef-8e16-d517f37fa2ad',11,'a888b842-2984-11ef-8e16-d517f37fa2ad','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,1,0,'','de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-13 15:03:12.454',NULL,'2024-06-13 15:05:35.250','2024-06-13 13:05:35.250','2024-06-13 15:05:35.261'),('4d76036e-2980-11ef-8e16-d517f37fa2ad',11,'08ed7a4a-2980-11ef-8e16-d517f37fa2ad','MANDIBULE','SCAN',1,'NONE',1,1,0,'','de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-13 14:27:30.390',NULL,'2024-06-13 14:29:47.553','2024-06-13 12:29:47.553','2024-06-13 14:29:47.569'),('53323287-28af-11ef-8e16-d517f37fa2ad',5,'627f5b3e-289b-11ef-8e16-d517f37fa2ad','MANDIBULE','SCAN',1,'NONE',2,1,0,'','4e72ba02-814f-4116-88da-65f8da1fa385','4e72ba02-814f-4116-88da-65f8da1fa385','2024-06-12 13:31:35.196',NULL,'2024-06-12 13:40:00.800','2024-06-12 11:40:00.800','2024-06-12 13:40:00.817'),('55568e89-2987-11ef-8e16-d517f37fa2ad',11,'4ba370c1-2987-11ef-8e16-d517f37fa2ad','MAXILLAIRE','SCAN',1,'NONE',1,1,0,'','de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-13 15:17:50.083',NULL,'2024-06-13 15:19:08.621','2024-06-13 13:19:08.621','2024-06-13 15:19:08.639'),('56147bb3-273a-11ef-8e16-d517f37fa1ab',2,'54eefd9c-273a-11ef-8e16-d517f37fa1ab','MAXILLAIRE','SCAN',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-10 17:01:37.754',NULL,'2024-06-10 17:02:16.525','2024-06-10 15:02:16.525','2024-06-10 17:02:16.543'),('5781b86f-289a-11ef-8e16-d517f37fa2ad',5,'0d14f12a-289a-11ef-8e16-d517f37fa2ad','MAXILLAIRE','SCAN',1,'NONE',2,1,0,'','4e72ba02-814f-4116-88da-65f8da1fa385','4e72ba02-814f-4116-88da-65f8da1fa385','2024-06-12 11:01:22.997',NULL,'2024-06-12 11:02:29.339','2024-06-12 09:02:29.339','2024-06-12 11:02:29.365'),('5aea484e-298a-11ef-8e16-d517f37fa2ad',2,'58f49179-298a-11ef-8e16-d517f37fa2ad','MAXILLAIRE','SCAN',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-13 15:39:27.930',NULL,'2024-06-13 15:40:18.572','2024-06-13 13:40:18.573','2024-06-13 15:40:18.593'),('60553760-273f-11ef-8e09-d517f1736dc8',2,'5f1e0aab-273f-11ef-8e09-d517f1736dc8','MAXILLAIRE','SCAN',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-10 17:37:42.439',NULL,'2024-06-10 17:38:47.278','2024-06-10 15:38:47.278','2024-06-10 17:38:47.283'),('634550b6-289b-11ef-8e16-d517f37fa2ad',5,'627f5b3e-289b-11ef-8e16-d517f37fa2ad','MAXILLAIRE','SCAN',1,'NONE',1,1,0,'','4e72ba02-814f-4116-88da-65f8da1fa385','4e72ba02-814f-4116-88da-65f8da1fa385','2024-06-12 11:08:52.230','2024-06-12 11:10:28.451','2024-06-12 11:10:28.451','2024-06-12 09:10:28.452','2024-06-12 11:10:28.485'),('6b394d9c-273c-11ef-8e16-d517f37fa1ab',2,'91784208-23fa-11ef-8dde-d415e84cc4f5','MAXILLAIRE','SCAN',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-10 17:16:32.221','2024-06-11 10:15:33.784','2024-06-11 10:15:33.784','2024-06-11 08:15:33.784','2024-06-11 10:15:33.792'),('6b7e666e-28c9-11ef-8e16-d517f37fa2ad',5,'6a00fa35-28c9-11ef-8e16-d517f37fa2ad','MANDIBULE','SCAN',1,'NONE',1,1,0,'','4e72ba02-814f-4116-88da-65f8da1fa385','4e72ba02-814f-4116-88da-65f8da1fa385','2024-06-12 16:38:22.876',NULL,'2024-06-12 16:40:14.293','2024-06-12 14:40:14.293','2024-06-12 16:40:14.301'),('6c4bba69-296f-11ef-8e16-d517f37fa2ad',11,'8e83509f-296b-11ef-8e16-d517f37fa2ad','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',2,1,0,'','de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-13 12:26:40.678',NULL,'2024-06-13 12:29:48.480','2024-06-13 10:29:48.481','2024-06-13 12:30:13.611'),('70f3c64d-2e42-11ef-8deb-d515ea58f6cb',2,'68b10ccb-2e42-11ef-8deb-d515ea58f6cb','MAXILLAIRE','SCAN',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-19 15:47:17.596',NULL,'2024-06-19 15:50:02.126','2024-06-19 13:50:02.126','2024-06-19 15:50:02.139'),('7b212ac0-2e0d-11ef-8deb-d515ea58f6cb',2,'be9c5752-2735-11ef-8e16-d517f37fa1ab','MAXILLAIRE','SCAN',1,'NONE',2,2,0,'{\"referenceScanId\":\"bfa3d876-2735-11ef-8e16-d517f37fa1ab\"}','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-19 09:28:11.344',NULL,'2024-06-19 09:28:40.392','2024-06-19 07:28:40.393','2024-06-19 12:49:52.914'),('7b449582-2e4b-11ef-8deb-d515ea58f6cb',2,'15f94c3c-2e4b-11ef-8deb-d515ea58f6cb','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-19 16:52:00.374',NULL,'2024-06-19 16:52:48.530','2024-06-19 14:52:48.531','2024-06-19 16:52:48.541'),('7dd4df25-225a-11ef-8d76-d310d2ec2c14',3,'78bc2302-2255-11ef-8e3f-d619fca54465','MAXILLAIRE','SCAN',1,'NONE',1,1,0,'','8df2a258-8868-49b7-91c2-e2d41d48bffc','8df2a258-8868-49b7-91c2-e2d41d48bffc','2024-06-04 12:09:12.528',NULL,'2024-06-04 12:10:13.359','2024-06-04 10:10:13.359','2024-06-04 12:10:13.372'),('804316c5-289b-11ef-8e16-d517f37fa2ad',5,'627f5b3e-289b-11ef-8e16-d517f37fa2ad','MANDIBULE','SCAN',1,'NONE',1,1,0,'','4e72ba02-814f-4116-88da-65f8da1fa385','4e72ba02-814f-4116-88da-65f8da1fa385','2024-06-12 11:09:40.869',NULL,'2024-06-12 11:10:08.771','2024-06-12 09:10:08.771','2024-06-12 11:10:08.795'),('80540c46-2a2a-11ef-8f1c-d8242c6fa8fd',11,'8d098374-2a29-11ef-8f1c-d8242c6fa8fd','MANDIBULE','SCAN',1,'NONE',1,1,0,'','de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-14 10:45:51.695',NULL,'2024-06-14 11:15:40.463','2024-06-14 09:15:40.463','2024-06-14 11:15:40.491'),('81adf7a6-27cb-11ef-8e37-d519fa9d22d2',2,'80d4d06a-27cb-11ef-8e37-d519fa9d22d2','MAXILLAIRE','SCAN',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-11 10:20:47.928',NULL,'2024-06-11 10:21:25.736','2024-06-11 08:21:25.736','2024-06-11 10:21:25.754'),('848d93a0-2cbb-11ef-8e27-d518f78fe3c8',2,'848cc83f-2cbb-11ef-8e27-d518f78fe3c8','MANDIBULE','SCAN',1,'NONE',1,2,0,'{\"imported\":true}','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-17 17:08:56.615',NULL,'2024-06-17 17:08:56.649','2024-06-17 15:08:56.649','2024-06-17 17:08:56.657'),('86f46641-2e40-11ef-8deb-d515ea58f6cb',2,'859bd7ba-2e40-11ef-8deb-d515ea58f6cb','MAXILLAIRE','SCAN',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-19 15:33:35.517',NULL,'2024-06-19 15:45:20.748','2024-06-19 13:45:20.748','2024-06-19 15:45:20.756'),('8714aaaa-273d-11ef-8e09-d517f1736dc8',2,'eab758e7-273c-11ef-8e16-d517f37fa1ab','MANDIBULE','SCAN',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-10 17:24:28.454',NULL,'2024-06-10 17:25:51.704','2024-06-10 15:25:51.704','2024-06-10 17:25:51.709'),('879dec53-2987-11ef-8e16-d517f37fa2ad',11,'4ba370c1-2987-11ef-8e16-d517f37fa2ad','MANDIBULE','SCAN',1,'NONE',1,1,0,'','de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-13 15:19:14.437',NULL,'2024-06-13 15:20:22.325','2024-06-13 13:20:22.325','2024-06-13 15:20:22.332'),('890595a9-296d-11ef-8e16-d517f37fa2ad',11,'8e83509f-296b-11ef-8e16-d517f37fa2ad','MAXILLAIRE','SCAN',1,'NONE',3,1,0,'','de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-13 12:13:09.879',NULL,'2024-06-13 12:20:54.835','2024-06-13 10:20:54.835','2024-06-13 12:20:54.864'),('8bc7c92e-2e3b-11ef-8deb-d515ea58f6cb',2,'da21a6e4-2e3a-11ef-8deb-d515ea58f6cb','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-19 14:57:56.129',NULL,'2024-06-19 14:58:23.592','2024-06-19 12:58:23.592','2024-06-19 14:58:23.604'),('8cf4ef97-2735-11ef-8e16-d517f37fa1ab',2,'8c1214e8-2735-11ef-8e16-d517f37fa1ab','MAXILLAIRE','SCAN',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-10 16:27:22.338','2024-06-11 10:08:19.532','2024-06-11 10:08:19.533','2024-06-11 08:08:19.533','2024-06-11 10:08:19.548'),('8de1d45c-2a29-11ef-8f1c-d8242c6fa8fd',11,'8d098374-2a29-11ef-8f1c-d8242c6fa8fd','MAXILLAIRE','SCAN',1,'NONE',1,1,0,'','de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-14 10:39:04.938',NULL,'2024-06-14 11:02:28.517','2024-06-14 09:02:28.517','2024-06-14 11:02:28.532'),('8f6d5887-2740-11ef-8e09-d517f1736dc8',2,'8f6cf168-2740-11ef-8e09-d517f1736dc8','MAXILLAIRE','SCAN',1,'NONE',1,2,0,'{\"imported\":true}','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-10 17:46:10.947',NULL,'2024-06-19 16:15:02.139','2024-06-19 14:15:02.140','2024-06-19 16:15:02.153'),('924b1ba0-2968-11ef-8e16-d517f37fa2ad',11,'4706df6f-2963-11ef-8e16-d517f37fa2ad','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,1,0,'','de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-13 11:37:37.951',NULL,'2024-06-13 11:38:42.834','2024-06-13 09:38:42.834','2024-06-13 11:39:23.711'),('924ba453-2968-11ef-8e16-d517f37fa2ad',11,'4706df6f-2963-11ef-8e16-d517f37fa2ad','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,1,0,'','de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-13 11:37:37.954',NULL,'2024-06-13 11:39:23.701','2024-06-13 09:39:23.701','2024-06-13 11:39:23.713'),('96d08283-2273-11ef-8d76-d310d2ec2c14',2,'f262aa99-2272-11ef-8d76-d310d2ec2c14','MANDIBULE','SCAN',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-04 15:08:51.000',NULL,'2024-06-04 15:48:41.000','2024-06-04 14:10:52.000','2024-06-04 16:10:52.000'),('97940017-2e29-11ef-8deb-d515ea58f6cb',2,'9576614e-2e29-11ef-8deb-d515ea58f6cb','MAXILLAIRE','SCAN',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-19 12:49:24.981',NULL,'2024-06-19 12:49:52.895','2024-06-19 10:49:52.896','2024-06-19 12:49:52.914'),('981faf70-23e7-11ef-8dde-d415e84cc4f5',3,'96b19cc6-23e7-11ef-8dde-d415e84cc4f5','MAXILLAIRE','SCAN',1,'NONE',1,1,0,'','8df2a258-8868-49b7-91c2-e2d41d48bffc','8df2a258-8868-49b7-91c2-e2d41d48bffc','2024-06-06 11:31:46.840',NULL,'2024-06-06 11:33:22.315','2024-06-06 09:33:22.316','2024-06-06 11:33:22.325'),('99d1c412-2990-11ef-8e16-d517f37fa2ad',11,'d70636d7-298d-11ef-8e16-d517f37fa2ad','MANDIBULE','SCAN',1,'NONE',1,1,0,'','de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-13 16:24:10.446',NULL,'2024-06-13 16:25:33.316','2024-06-13 14:25:33.316','2024-06-13 16:25:33.325'),('9d83e262-28ba-11ef-8e16-d517f37fa2ad',5,'9c9dff16-28ba-11ef-8e16-d517f37fa2ad','MAXILLAIRE','SCAN',1,'NONE',1,1,0,'','4e72ba02-814f-4116-88da-65f8da1fa385','4e72ba02-814f-4116-88da-65f8da1fa385','2024-06-12 14:52:24.347','2024-06-12 14:54:09.521','2024-06-12 14:54:09.521','2024-06-12 12:54:09.522','2024-06-12 14:54:09.538'),('9fc70276-2277-11ef-8d76-d310d2ec2c14',2,'f262aa99-2272-11ef-8d76-d310d2ec2c14','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',2,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-04 15:37:44.000',NULL,'2024-06-04 15:39:22.000','2024-06-04 13:41:41.000','2024-06-04 15:41:41.000'),('9fc7cfd7-2277-11ef-8d76-d310d2ec2c14',2,'f262aa99-2272-11ef-8d76-d310d2ec2c14','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',2,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-04 15:37:44.000',NULL,'2024-06-04 15:41:37.000','2024-06-04 13:41:42.000','2024-06-04 15:41:42.000'),('a0eae524-289c-11ef-8e16-d517f37fa2ad',5,'0d14f12a-289a-11ef-8e16-d517f37fa2ad','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,1,0,'','4e72ba02-814f-4116-88da-65f8da1fa385','4e72ba02-814f-4116-88da-65f8da1fa385','2024-06-12 11:17:45.153',NULL,'2024-06-12 11:19:01.222','2024-06-12 09:19:01.222','2024-06-12 11:19:01.234'),('a4a0d8da-289a-11ef-8e16-d517f37fa2ad',5,'0d14f12a-289a-11ef-8e16-d517f37fa2ad','MANDIBULE','SCAN',1,'NONE',1,1,0,'','4e72ba02-814f-4116-88da-65f8da1fa385','4e72ba02-814f-4116-88da-65f8da1fa385','2024-06-12 11:03:32.385',NULL,'2024-06-12 11:04:06.902','2024-06-12 09:04:06.902','2024-06-12 11:05:47.928'),('a5b11e9a-2980-11ef-8e16-d517f37fa2ad',11,'08ed7a4a-2980-11ef-8e16-d517f37fa2ad','MORDU_ANTERIEUR','SCAN',1,'NONE',1,1,0,'','de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-13 14:29:58.417',NULL,'2024-06-13 14:31:28.756','2024-06-13 12:31:28.757','2024-06-13 14:31:28.773'),('a6d98df1-2279-11ef-8d76-d310d2ec2c14',2,'a4160b84-2279-11ef-8d76-d310d2ec2c14','MAXILLAIRE','SCAN',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-04 15:52:15.000',NULL,'2024-06-04 15:53:15.000','2024-06-04 13:53:21.000','2024-06-04 15:53:21.000'),('a9e9d6c4-298f-11ef-8e16-d517f37fa2ad',11,'d70636d7-298d-11ef-8e16-d517f37fa2ad','MAXILLAIRE','SCAN',1,'NONE',2,1,0,'{\"referenceScanId\":\"2ed06b9e-298f-11ef-8e16-d517f37fa2ad\"}','de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-13 16:17:27.951',NULL,'2024-06-13 16:19:05.445','2024-06-13 14:19:05.446','2024-06-13 16:19:05.465'),('ab40f38e-2984-11ef-8e16-d517f37fa2ad',11,'a888b842-2984-11ef-8e16-d517f37fa2ad','MAXILLAIRE','SCAN',1,'NONE',1,1,0,'','de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-13 14:58:45.735',NULL,'2024-06-13 15:05:35.330','2024-06-13 13:05:35.330','2024-06-13 15:05:35.338'),('aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd',11,'8d098374-2a29-11ef-8f1c-d8242c6fa8fd','MANDIBULE','SCAN',1,'NONE',2,1,0,'{\"referenceScanId\":\"80540c46-2a2a-11ef-8f1c-d8242c6fa8fd\"}','de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-14 11:15:47.813',NULL,'2024-06-14 11:22:39.565','2024-06-14 09:22:39.566','2024-06-14 11:22:39.580'),('af431dfb-2a22-11ef-8f1c-d8242c6fa8fd',11,'72bbb4c0-2a20-11ef-8f1c-d8242c6fa8fd','MAXILLAIRE','SCAN',1,'NONE',2,1,0,'','de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-14 09:49:54.464','2024-06-14 10:38:31.823','2024-06-14 10:38:31.823','2024-06-14 08:38:31.823','2024-06-14 10:38:31.832'),('b17c4dcd-2271-11ef-8d76-d310d2ec2c14',2,'afa8fad1-2271-11ef-8d76-d310d2ec2c14','MAXILLAIRE','SCAN',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-04 14:55:17.000',NULL,'2024-06-04 14:57:24.000','2024-06-04 12:57:27.000','2024-06-04 14:57:27.000'),('b51b7dbf-28d4-11ef-8e16-d517f37fa2ad',5,'5f49b09c-28bf-11ef-8e16-d517f37fa2ad','MAXILLAIRE','SCAN',1,'NONE',1,1,0,'','4e72ba02-814f-4116-88da-65f8da1fa385','4e72ba02-814f-4116-88da-65f8da1fa385','2024-06-12 17:59:10.843',NULL,'2024-06-12 18:00:03.802','2024-06-12 16:00:03.802','2024-06-12 18:00:03.809'),('b95b37da-2e0c-11ef-8deb-d515ea58f6cb',11,'b7e495d3-2e0c-11ef-8deb-d515ea58f6cb','MAXILLAIRE','SCAN',1,'NONE',1,1,1,'','de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-19 09:22:46.247',NULL,'2024-06-19 09:23:40.572','2024-06-19 07:23:40.572',NULL),('bc9cdff9-273a-11ef-8e16-d517f37fa1ab',2,'bafc70fb-273a-11ef-8e16-d517f37fa1ab','MAXILLAIRE','SCAN',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-10 17:04:29.776','2024-06-10 17:05:41.423','2024-06-10 17:05:41.423','2024-06-10 15:05:41.424','2024-06-10 17:05:41.443'),('bfa3d876-2735-11ef-8e16-d517f37fa1ab',2,'be9c5752-2735-11ef-8e16-d517f37fa1ab','MAXILLAIRE','SCAN',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-10 16:28:47.371',NULL,'2024-06-19 09:27:18.212','2024-06-19 07:27:18.212','2024-06-19 12:49:52.914'),('c103add9-2e4d-11ef-8deb-d515ea58f6cb',2,'c8883bc6-2e3c-11ef-8deb-d515ea58f6cb','MAXILLAIRE','SCAN',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-19 17:08:16.382',NULL,'2024-06-19 17:08:49.623','2024-06-19 15:08:49.624','2024-06-19 17:08:49.648'),('c523efdb-2278-11ef-8d76-d310d2ec2c14',2,'f262aa99-2272-11ef-8d76-d310d2ec2c14','MAXILLAIRE','SCAN',1,'NONE',2,2,0,'{\"referenceScanId\":\"f3b0649e-2272-11ef-8d76-d310d2ec2c14\"}','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-04 15:45:57.000',NULL,'2024-06-04 15:46:39.000','2024-06-04 14:10:52.000','2024-06-04 16:10:52.000'),('c5a22d2e-2964-11ef-8e16-d517f37fa2ad',11,'4706df6f-2963-11ef-8e16-d517f37fa2ad','MANDIBULE','SCAN',1,'NONE',1,1,0,'','de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-13 11:10:26.098','2024-06-13 11:18:50.266','2024-06-13 11:18:50.267','2024-06-13 09:18:50.268','2024-06-13 11:18:50.299'),('c90eb287-2987-11ef-8e16-d517f37fa2ad',11,'4ba370c1-2987-11ef-8e16-d517f37fa2ad','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,1,0,'','de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-13 15:21:04.228',NULL,'2024-06-13 15:22:21.436','2024-06-13 13:22:21.436','2024-06-13 15:22:21.442'),('cd2aac3c-297d-11ef-8e16-d517f37fa2ad',11,'cc37a7f7-297d-11ef-8e16-d517f37fa2ad','MAXILLAIRE','SCAN',1,'NONE',1,1,0,'','de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-13 14:09:36.155',NULL,'2024-06-13 14:14:52.311','2024-06-13 12:14:52.311','2024-06-13 14:18:31.594'),('d2eec825-298a-11ef-8e16-d517f37fa2ad',2,'a1ecf57e-298a-11ef-8e16-d517f37fa2ad','MAXILLAIRE','SCANBODY',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-13 15:42:49.286',NULL,'2024-06-13 15:45:02.732','2024-06-13 13:45:02.732','2024-06-13 15:45:02.760'),('d891acce-2e3d-11ef-8deb-d515ea58f6cb',2,'af864e86-27f1-11ef-8e37-d519fa9d22d2','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-19 15:14:23.953',NULL,'2024-06-19 15:19:00.437','2024-06-19 13:19:00.438','2024-06-19 15:19:00.444'),('d8e5d9f0-296b-11ef-8e16-d517f37fa2ad',11,'8e83509f-296b-11ef-8e16-d517f37fa2ad','MAXILLAIRE','SCAN',1,'NONE',1,1,0,'','de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-13 12:01:04.895','2024-06-13 12:10:56.416','2024-06-13 12:10:56.416','2024-06-13 10:10:56.418','2024-06-13 12:10:56.444'),('db07e23d-289b-11ef-8e16-d517f37fa2ad',5,'627f5b3e-289b-11ef-8e16-d517f37fa2ad','MAXILLAIRE','SCAN',1,'NONE',2,1,0,'','4e72ba02-814f-4116-88da-65f8da1fa385','4e72ba02-814f-4116-88da-65f8da1fa385','2024-06-12 11:12:13.154',NULL,'2024-06-12 11:13:19.286','2024-06-12 09:13:19.286','2024-06-12 11:13:19.302'),('dc038d5b-2e3a-11ef-8deb-d515ea58f6cb',2,'da21a6e4-2e3a-11ef-8deb-d515ea58f6cb','MAXILLAIRE','SCAN',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-19 14:53:01.242',NULL,'2024-06-19 14:54:26.324','2024-06-19 12:54:26.324','2024-06-19 14:54:26.336'),('de3fd237-2984-11ef-8e16-d517f37fa2ad',11,'a888b842-2984-11ef-8e16-d517f37fa2ad','MAXILLAIRE','SCAN',1,'NONE',2,1,0,'{\"referenceScanId\":\"ab40f38e-2984-11ef-8e16-d517f37fa2ad\"}','de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-13 15:00:11.292',NULL,'2024-06-13 15:05:35.402','2024-06-13 13:05:35.402','2024-06-13 15:05:35.407'),('e0f66733-227c-11ef-8d76-d310d2ec2c14',2,'da37d213-227c-11ef-8d76-d310d2ec2c14','MAXILLAIRE','SCANBODY',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-04 16:15:21.000',NULL,'2024-06-19 09:35:07.951','2024-06-19 07:35:07.951','2024-06-19 12:49:52.914'),('e16361f9-2e3c-11ef-8deb-d515ea58f6cb',2,'af864e86-27f1-11ef-8e37-d519fa9d22d2','MAXILLAIRE','SCAN',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-19 15:07:29.252',NULL,'2024-06-19 15:19:00.487','2024-06-19 13:19:00.488','2024-06-19 15:19:00.493'),('e2305601-296e-11ef-8e16-d517f37fa2ad',11,'8e83509f-296b-11ef-8e16-d517f37fa2ad','MANDIBULE','SCAN',1,'NONE',1,1,0,'','de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-13 12:22:48.973',NULL,'2024-06-13 12:25:32.503','2024-06-13 10:25:32.503','2024-06-13 12:26:28.226'),('e3221a36-2990-11ef-8e16-d517f37fa2ad',11,'d70636d7-298d-11ef-8e16-d517f37fa2ad','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,1,0,'','de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-13 16:26:13.447',NULL,'2024-06-13 16:27:42.914','2024-06-13 14:27:42.914','2024-06-13 16:27:42.928'),('e57cd1ee-28c5-11ef-8e16-d517f37fa2ad',5,'6872c415-28c3-11ef-8e16-d517f37fa2ad','MAXILLAIRE','SCAN',1,'NONE',1,1,0,'','4e72ba02-814f-4116-88da-65f8da1fa385','4e72ba02-814f-4116-88da-65f8da1fa385','2024-06-12 16:13:09.560',NULL,'2024-06-12 16:37:28.926','2024-06-12 14:37:28.926','2024-06-12 16:37:28.936'),('e631c430-2e0e-11ef-8deb-d515ea58f6cb',2,'da37d213-227c-11ef-8d76-d310d2ec2c14','MAXILLAIRE','SCANBODY',1,'NONE',2,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-19 09:38:20.466',NULL,'2024-06-19 09:40:40.509','2024-06-19 07:40:40.509','2024-06-19 12:49:52.914'),('e7c571a1-2968-11ef-8e16-d517f37fa2ad',11,'4706df6f-2963-11ef-8e16-d517f37fa2ad','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',2,1,0,'','de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-13 11:40:01.359',NULL,'2024-06-13 11:41:04.615','2024-06-13 09:41:04.616','2024-06-13 11:41:45.677'),('e7c5fece-2968-11ef-8e16-d517f37fa2ad',11,'4706df6f-2963-11ef-8e16-d517f37fa2ad','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',2,1,0,'','de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-13 11:40:01.362',NULL,'2024-06-13 11:41:45.653','2024-06-13 09:41:45.654','2024-06-13 11:41:45.677'),('e97f72f6-2a20-11ef-8f1c-d8242c6fa8fd',11,'72bbb4c0-2a20-11ef-8f1c-d8242c6fa8fd','MAXILLAIRE','SCAN',1,'NONE',1,1,0,'','de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-14 09:37:13.173','2024-06-14 09:42:34.607','2024-06-14 09:42:34.608','2024-06-14 07:42:34.609',NULL),('ea470b5e-2a2a-11ef-8f1c-d8242c6fa8fd',11,'8d098374-2a29-11ef-8f1c-d8242c6fa8fd','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,1,0,'','de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-14 10:48:49.449',NULL,'2024-06-14 10:51:13.372','2024-06-14 08:51:13.372','2024-06-14 10:51:13.391'),('eae3435c-27ca-11ef-8e37-d519fa9d22d2',2,'eae1e551-27ca-11ef-8e37-d519fa9d22d2','MAXILLAIRE','SCAN',1,'NONE',1,2,0,'{\"imported\":true}','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-11 10:16:34.941',NULL,'2024-06-11 10:16:35.002','2024-06-11 08:16:35.002','2024-06-11 10:16:35.012'),('ec642b7f-273c-11ef-8e16-d517f37fa1ab',2,'eab758e7-273c-11ef-8e16-d517f37fa1ab','MAXILLAIRE','SCAN',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-10 17:20:08.928',NULL,'2024-06-10 17:25:51.736','2024-06-10 15:25:51.736','2024-06-10 17:25:51.742'),('ef33e0e4-2a28-11ef-8f1c-d8242c6fa8fd',11,'72bbb4c0-2a20-11ef-8f1c-d8242c6fa8fd','MAXILLAIRE','SCAN',1,'NONE',3,1,0,'{\"referenceScanId\":\"af431dfb-2a22-11ef-8f1c-d8242c6fa8fd\"}','de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-14 10:34:38.718','2024-06-14 10:38:33.383','2024-06-14 10:38:33.383','2024-06-14 08:38:33.383','2024-06-14 10:38:33.415'),('f3a386e0-2965-11ef-8e16-d517f37fa2ad',11,'4706df6f-2963-11ef-8e16-d517f37fa2ad','MANDIBULE','SCAN',1,'NONE',2,1,0,'','de198d52-1413-4336-bc67-f6b5586d29fc','de198d52-1413-4336-bc67-f6b5586d29fc','2024-06-13 11:18:52.779',NULL,'2024-06-13 11:24:50.860','2024-06-13 09:24:50.861','2024-06-13 11:24:50.879'),('f3b0649e-2272-11ef-8d76-d310d2ec2c14',2,'f262aa99-2272-11ef-8d76-d310d2ec2c14','MAXILLAIRE','SCAN',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-04 15:04:18.000',NULL,'2024-06-04 15:08:42.000','2024-06-04 13:08:45.000','2024-06-04 15:08:45.000'),('f516112b-2731-11ef-8e16-d517f37fa1ab',2,'f300fd64-2731-11ef-8e16-d517f37fa1ab','MAXILLAIRE','SCAN',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-10 16:01:39.000',NULL,'2024-06-10 16:02:32.000','2024-06-10 14:02:37.000','2024-06-10 16:02:37.000'),('f9e998f8-2e4c-11ef-8deb-d515ea58f6cb',2,'f8edd977-2e4c-11ef-8deb-d515ea58f6cb','MAXILLAIRE','SCAN',1,'NONE',1,2,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-19 17:02:42.344',NULL,'2024-06-19 17:03:49.130','2024-06-19 15:03:49.130','2024-06-19 17:03:49.137');
/*!40000 ALTER TABLE `Scan` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ScanFile`
--

DROP TABLE IF EXISTS `ScanFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ScanFile` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `scanId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('MODEL','SNAPSHOT','SCREENSHOT','LIFI','LIFIMETA','METERING','SEGMENTED') NOT NULL,
  PRIMARY KEY (`scanId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `ScanFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `ScanFile_ibfk_2` FOREIGN KEY (`scanId`) REFERENCES `Scan` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ScanFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ScanFile`
--

LOCK TABLES `ScanFile` WRITE;
/*!40000 ALTER TABLE `ScanFile` DISABLE KEYS */;
INSERT INTO `ScanFile` VALUES (2,'00f317ff-2730-11ef-8e16-d517f37fa1ab','1b69c905-2730-11ef-8e16-d517f37fa1ab','MODEL'),(2,'00f317ff-2730-11ef-8e16-d517f37fa1ab','1b69de98-2730-11ef-8e16-d517f37fa1ab','SNAPSHOT'),(2,'01f8eb7b-273e-11ef-8e09-d517f1736dc8','5715ee44-273e-11ef-8e09-d517f1736dc8','MODEL'),(2,'01f8eb7b-273e-11ef-8e09-d517f1736dc8','5715faa2-273e-11ef-8e09-d517f1736dc8','SNAPSHOT'),(11,'037dbcf6-297d-11ef-8e16-d517f37fa2ad','3d69b31d-297d-11ef-8e16-d517f37fa2ad','MODEL'),(11,'037dbcf6-297d-11ef-8e16-d517f37fa2ad','3d69da80-297d-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(11,'099d82e1-2980-11ef-8e16-d517f37fa2ad','45df8951-2980-11ef-8e16-d517f37fa2ad','MODEL'),(11,'099d82e1-2980-11ef-8e16-d517f37fa2ad','45df9f47-2980-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(11,'099d82e1-2980-11ef-8e16-d517f37fa2ad','77a5910f-2983-11ef-8e16-d517f37fa2ad','SEGMENTED'),(11,'099d82e1-2980-11ef-8e16-d517f37fa2ad','c5e732c1-2983-11ef-8e16-d517f37fa2ad','SCREENSHOT'),(11,'099d82e1-2980-11ef-8e16-d517f37fa2ad','d72c7af3-2983-11ef-8e16-d517f37fa2ad','METERING'),(11,'099d82e1-2980-11ef-8e16-d517f37fa2ad','ff215bde-2982-11ef-8e16-d517f37fa2ad','SEGMENTED'),(2,'0cf35705-2e42-11ef-8deb-d515ea58f6cb','1d1765b7-2e42-11ef-8deb-d515ea58f6cb','MODEL'),(2,'0cf35705-2e42-11ef-8deb-d515ea58f6cb','1d1774ff-2e42-11ef-8deb-d515ea58f6cb','SNAPSHOT'),(2,'0cf35705-2e42-11ef-8deb-d515ea58f6cb','911bf499-2e44-11ef-8deb-d515ea58f6cb','SEGMENTED'),(3,'0d3f3b92-23e9-11ef-8dde-d415e84cc4f5','242c6766-23e9-11ef-8dde-d415e84cc4f5','MODEL'),(3,'0d3f3b92-23e9-11ef-8dde-d415e84cc4f5','242c7d2a-23e9-11ef-8dde-d415e84cc4f5','SNAPSHOT'),(5,'0e172d2c-289a-11ef-8e16-d517f37fa2ad','26d765c3-289a-11ef-8e16-d517f37fa2ad','MODEL'),(5,'0e172d2c-289a-11ef-8e16-d517f37fa2ad','26d7745b-289a-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(5,'12fa8aba-28bb-11ef-8e16-d517f37fa2ad','483e0c64-28bb-11ef-8e16-d517f37fa2ad','MODEL'),(5,'12fa8aba-28bb-11ef-8e16-d517f37fa2ad','483e1f47-28bb-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(5,'1737aea0-289c-11ef-8e16-d517f37fa2ad','3303ef6e-289c-11ef-8e16-d517f37fa2ad','MODEL'),(5,'1737aea0-289c-11ef-8e16-d517f37fa2ad','33040048-289c-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(2,'1770b226-2e4b-11ef-8deb-d515ea58f6cb','026edc4c-2e4c-11ef-8deb-d515ea58f6cb','SEGMENTED'),(2,'1770b226-2e4b-11ef-8deb-d515ea58f6cb','18ef19c3-2e4c-11ef-8deb-d515ea58f6cb','SEGMENTED'),(2,'1770b226-2e4b-11ef-8deb-d515ea58f6cb','3944017f-2e4b-11ef-8deb-d515ea58f6cb','MODEL'),(2,'1770b226-2e4b-11ef-8deb-d515ea58f6cb','394418b6-2e4b-11ef-8deb-d515ea58f6cb','SNAPSHOT'),(2,'1793bd69-2e43-11ef-8deb-d515ea58f6cb','639f7d1c-2e43-11ef-8deb-d515ea58f6cb','MODEL'),(2,'1793bd69-2e43-11ef-8deb-d515ea58f6cb','639fcb29-2e43-11ef-8deb-d515ea58f6cb','SNAPSHOT'),(2,'18dce61e-2e3b-11ef-8deb-d515ea58f6cb','451fc815-2e3b-11ef-8deb-d515ea58f6cb','MODEL'),(2,'18dce61e-2e3b-11ef-8deb-d515ea58f6cb','451fd81d-2e3b-11ef-8deb-d515ea58f6cb','SNAPSHOT'),(2,'1c95cecd-2e0d-11ef-8deb-d515ea58f6cb','2d0cf740-2e0d-11ef-8deb-d515ea58f6cb','MODEL'),(2,'1c95cecd-2e0d-11ef-8deb-d515ea58f6cb','2d0d25e8-2e0d-11ef-8deb-d515ea58f6cb','SNAPSHOT'),(2,'1c95cecd-2e0d-11ef-8deb-d515ea58f6cb','3230f603-2e0d-11ef-8deb-d515ea58f6cb','MODEL'),(2,'1c95cecd-2e0d-11ef-8deb-d515ea58f6cb','4212f31d-2e0d-11ef-8deb-d515ea58f6cb','MODEL'),(2,'1c95cecd-2e0d-11ef-8deb-d515ea58f6cb','46a066cb-2e0d-11ef-8deb-d515ea58f6cb','SEGMENTED'),(11,'1d4719f4-2985-11ef-8e16-d517f37fa2ad','423d7c80-2985-11ef-8e16-d517f37fa2ad','MODEL'),(11,'1d4719f4-2985-11ef-8e16-d517f37fa2ad','423d8b1c-2985-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(2,'1db1e2d3-271f-11ef-8e16-d517f37fa1ab','3326d65f-2720-11ef-8e16-d517f37fa1ab','MODEL'),(2,'1db1e2d3-271f-11ef-8e16-d517f37fa1ab','3326f9f5-2720-11ef-8e16-d517f37fa1ab','SNAPSHOT'),(2,'1db1e2d3-271f-11ef-8e16-d517f37fa1ab','dc224fd3-27ce-11ef-8e37-d519fa9d22d2','SCREENSHOT'),(2,'1db1e2d3-271f-11ef-8e16-d517f37fa1ab','debcb052-27ce-11ef-8e37-d519fa9d22d2','SCREENSHOT'),(2,'1db1e2d3-271f-11ef-8e16-d517f37fa1ab','e4230834-2737-11ef-8e16-d517f37fa1ab','LIFI'),(2,'1db1e2d3-271f-11ef-8e16-d517f37fa1ab','e42318eb-2737-11ef-8e16-d517f37fa1ab','LIFIMETA'),(2,'1db1e2d3-271f-11ef-8e16-d517f37fa1ab','e5bb1f50-27ce-11ef-8e37-d519fa9d22d2','SCREENSHOT'),(2,'1db1e2d3-271f-11ef-8e16-d517f37fa1ab','e87e5517-27ce-11ef-8e37-d519fa9d22d2','SCREENSHOT'),(2,'1db1e2d3-271f-11ef-8e16-d517f37fa1ab','eb03efaf-27ce-11ef-8e37-d519fa9d22d2','SCREENSHOT'),(2,'1e568150-2e36-11ef-8deb-d515ea58f6cb','4d86cd45-2e36-11ef-8deb-d515ea58f6cb','MODEL'),(2,'1e568150-2e36-11ef-8deb-d515ea58f6cb','4d86de52-2e36-11ef-8deb-d515ea58f6cb','SNAPSHOT'),(2,'1e568150-2e36-11ef-8deb-d515ea58f6cb','62387fc2-2e36-11ef-8deb-d515ea58f6cb','SEGMENTED'),(2,'1e568150-2e36-11ef-8deb-d515ea58f6cb','6751aadf-2e36-11ef-8deb-d515ea58f6cb','LIFI'),(2,'1e568150-2e36-11ef-8deb-d515ea58f6cb','6751bb01-2e36-11ef-8deb-d515ea58f6cb','LIFIMETA'),(2,'1e568150-2e36-11ef-8deb-d515ea58f6cb','68c717db-2e36-11ef-8deb-d515ea58f6cb','LIFI'),(2,'1e568150-2e36-11ef-8deb-d515ea58f6cb','68c71c8f-2e36-11ef-8deb-d515ea58f6cb','LIFIMETA'),(2,'1e568150-2e36-11ef-8deb-d515ea58f6cb','92fde47f-2e36-11ef-8deb-d515ea58f6cb','SEGMENTED'),(11,'2ed06b9e-298f-11ef-8e16-d517f37fa2ad','6cab3c6f-298f-11ef-8e16-d517f37fa2ad','MODEL'),(11,'2ed06b9e-298f-11ef-8e16-d517f37fa2ad','6cab55f9-298f-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(2,'3447447c-2e3d-11ef-8deb-d515ea58f6cb','6fd045fb-2e3d-11ef-8deb-d515ea58f6cb','MODEL'),(2,'3447447c-2e3d-11ef-8deb-d515ea58f6cb','6fd05373-2e3d-11ef-8deb-d515ea58f6cb','SNAPSHOT'),(11,'366c0b70-2969-11ef-8e16-d517f37fa2ad','7d5421bb-2969-11ef-8e16-d517f37fa2ad','MODEL'),(11,'366c0b70-2969-11ef-8e16-d517f37fa2ad','7d556dfa-2969-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(11,'366c910a-2969-11ef-8e16-d517f37fa2ad','c4879c59-2969-11ef-8e16-d517f37fa2ad','MODEL'),(11,'366c910a-2969-11ef-8e16-d517f37fa2ad','c487b021-2969-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(2,'3754a3a0-2e35-11ef-8deb-d515ea58f6cb','80c3e23d-2e35-11ef-8deb-d515ea58f6cb','MODEL'),(2,'3754a3a0-2e35-11ef-8deb-d515ea58f6cb','80c3fca2-2e35-11ef-8deb-d515ea58f6cb','SNAPSHOT'),(2,'3754a3a0-2e35-11ef-8deb-d515ea58f6cb','98a961ad-2e36-11ef-8deb-d515ea58f6cb','SEGMENTED'),(2,'389889a4-2272-11ef-8d76-d310d2ec2c14','5bd68def-2272-11ef-8d76-d310d2ec2c14','MODEL'),(2,'389889a4-2272-11ef-8d76-d310d2ec2c14','5bd6a4c3-2272-11ef-8d76-d310d2ec2c14','SNAPSHOT'),(2,'389889a4-2272-11ef-8d76-d310d2ec2c14','c20b977f-2e29-11ef-8deb-d515ea58f6cb','MODEL'),(11,'3e566183-296d-11ef-8e16-d517f37fa2ad','68583fe2-296d-11ef-8e16-d517f37fa2ad','MODEL'),(11,'3e566183-296d-11ef-8e16-d517f37fa2ad','68584e1d-296d-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(2,'4155dabe-2e4b-11ef-8deb-d515ea58f6cb','62490a02-2e4b-11ef-8deb-d515ea58f6cb','MODEL'),(2,'4155dabe-2e4b-11ef-8deb-d515ea58f6cb','624917e7-2e4b-11ef-8deb-d515ea58f6cb','SNAPSHOT'),(2,'424c596f-2720-11ef-8e16-d517f37fa1ab','73b17774-2720-11ef-8e16-d517f37fa1ab','MODEL'),(2,'424c596f-2720-11ef-8e16-d517f37fa1ab','73b18674-2720-11ef-8e16-d517f37fa1ab','SNAPSHOT'),(2,'4501387b-2274-11ef-8d76-d310d2ec2c14','6e99d7a2-2274-11ef-8d76-d310d2ec2c14','MODEL'),(2,'4501387b-2274-11ef-8d76-d310d2ec2c14','6e99ed86-2274-11ef-8d76-d310d2ec2c14','SNAPSHOT'),(2,'4501cd03-2274-11ef-8d76-d310d2ec2c14','9ae521cf-2274-11ef-8d76-d310d2ec2c14','MODEL'),(2,'4501cd03-2274-11ef-8d76-d310d2ec2c14','9ae54842-2274-11ef-8d76-d310d2ec2c14','SNAPSHOT'),(11,'45dedff3-296f-11ef-8e16-d517f37fa2ad','64ad4973-296f-11ef-8e16-d517f37fa2ad','MODEL'),(11,'45dedff3-296f-11ef-8e16-d517f37fa2ad','64ad5fec-296f-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(2,'479072c7-27cb-11ef-8e37-d519fa9d22d2','705bde7d-27cb-11ef-8e37-d519fa9d22d2','MODEL'),(2,'479072c7-27cb-11ef-8e37-d519fa9d22d2','705bfbda-27cb-11ef-8e37-d519fa9d22d2','SNAPSHOT'),(11,'47f95341-2963-11ef-8e16-d517f37fa2ad','00b3800a-296b-11ef-8e16-d517f37fa2ad','MODEL'),(11,'47f95341-2963-11ef-8e16-d517f37fa2ad','089e2b2d-296b-11ef-8e16-d517f37fa2ad','MODEL'),(11,'47f95341-2963-11ef-8e16-d517f37fa2ad','2f9a5141-296b-11ef-8e16-d517f37fa2ad','SCREENSHOT'),(11,'47f95341-2963-11ef-8e16-d517f37fa2ad','6487d4c6-2964-11ef-8e16-d517f37fa2ad','MODEL'),(11,'47f95341-2963-11ef-8e16-d517f37fa2ad','64880729-2964-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(11,'47f95341-2963-11ef-8e16-d517f37fa2ad','b08fc982-296a-11ef-8e16-d517f37fa2ad','SEGMENTED'),(11,'47f95341-2963-11ef-8e16-d517f37fa2ad','c2d2d4e4-2964-11ef-8e16-d517f37fa2ad','MODEL'),(11,'47f95341-2963-11ef-8e16-d517f37fa2ad','f282de54-296a-11ef-8e16-d517f37fa2ad','SEGMENTED'),(11,'4a3afb31-2985-11ef-8e16-d517f37fa2ad','717ad3ef-2985-11ef-8e16-d517f37fa2ad','MODEL'),(11,'4a3afb31-2985-11ef-8e16-d517f37fa2ad','717ae8bb-2985-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(11,'4d76036e-2980-11ef-8e16-d517f37fa2ad','9ec5df9b-2980-11ef-8e16-d517f37fa2ad','MODEL'),(11,'4d76036e-2980-11ef-8e16-d517f37fa2ad','9ec5f3b6-2980-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(5,'53323287-28af-11ef-8e16-d517f37fa2ad','7ffd4d6c-28b0-11ef-8e16-d517f37fa2ad','MODEL'),(5,'53323287-28af-11ef-8e16-d517f37fa2ad','7ffd6d38-28b0-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(11,'55568e89-2987-11ef-8e16-d517f37fa2ad','83c9791c-2987-11ef-8e16-d517f37fa2ad','MODEL'),(11,'55568e89-2987-11ef-8e16-d517f37fa2ad','83c98a29-2987-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(2,'56147bb3-273a-11ef-8e16-d517f37fa1ab','6d07ca5e-273a-11ef-8e16-d517f37fa1ab','MODEL'),(2,'56147bb3-273a-11ef-8e16-d517f37fa1ab','6d07d7f7-273a-11ef-8e16-d517f37fa1ab','SNAPSHOT'),(5,'5781b86f-289a-11ef-8e16-d517f37fa2ad','7f0190db-289a-11ef-8e16-d517f37fa2ad','MODEL'),(5,'5781b86f-289a-11ef-8e16-d517f37fa2ad','7f01a3ee-289a-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(2,'5aea484e-298a-11ef-8e16-d517f37fa2ad','78e2643a-298a-11ef-8e16-d517f37fa2ad','MODEL'),(2,'5aea484e-298a-11ef-8e16-d517f37fa2ad','78e27dbb-298a-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(2,'60553760-273f-11ef-8e09-d517f1736dc8','7ed3d80e-273f-11ef-8e09-d517f1736dc8','MODEL'),(2,'60553760-273f-11ef-8e09-d517f1736dc8','7ed3ea61-273f-11ef-8e09-d517f1736dc8','SNAPSHOT'),(5,'634550b6-289b-11ef-8e16-d517f37fa2ad','7d7bc15f-289b-11ef-8e16-d517f37fa2ad','MODEL'),(5,'634550b6-289b-11ef-8e16-d517f37fa2ad','7d7bd46a-289b-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(2,'6b394d9c-273c-11ef-8e16-d517f37fa1ab','76d290b9-273c-11ef-8e16-d517f37fa1ab','MODEL'),(2,'6b394d9c-273c-11ef-8e16-d517f37fa1ab','76d2a559-273c-11ef-8e16-d517f37fa1ab','SNAPSHOT'),(5,'6b7e666e-28c9-11ef-8e16-d517f37fa2ad','8f283140-28c9-11ef-8e16-d517f37fa2ad','MODEL'),(5,'6b7e666e-28c9-11ef-8e16-d517f37fa2ad','8f28484b-28c9-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(11,'6c4bba69-296f-11ef-8e16-d517f37fa2ad','dc0c5167-296f-11ef-8e16-d517f37fa2ad','MODEL'),(11,'6c4bba69-296f-11ef-8e16-d517f37fa2ad','dc0c6082-296f-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(2,'70f3c64d-2e42-11ef-8deb-d515ea58f6cb','953cbc38-2e42-11ef-8deb-d515ea58f6cb','MODEL'),(2,'70f3c64d-2e42-11ef-8deb-d515ea58f6cb','953ccd86-2e42-11ef-8deb-d515ea58f6cb','SNAPSHOT'),(2,'70f3c64d-2e42-11ef-8deb-d515ea58f6cb','bde80801-2e42-11ef-8deb-d515ea58f6cb','SCREENSHOT'),(2,'70f3c64d-2e42-11ef-8deb-d515ea58f6cb','bf9e8d51-2e42-11ef-8deb-d515ea58f6cb','METERING'),(2,'70f3c64d-2e42-11ef-8deb-d515ea58f6cb','d2fc9984-2e42-11ef-8deb-d515ea58f6cb','MODEL'),(2,'7b212ac0-2e0d-11ef-8deb-d515ea58f6cb','7b2155d2-2e0d-11ef-8deb-d515ea58f6cb','SNAPSHOT'),(2,'7b212ac0-2e0d-11ef-8deb-d515ea58f6cb','7b216adc-2e0d-11ef-8deb-d515ea58f6cb','LIFI'),(2,'7b212ac0-2e0d-11ef-8deb-d515ea58f6cb','7b217790-2e0d-11ef-8deb-d515ea58f6cb','LIFIMETA'),(2,'7b212ac0-2e0d-11ef-8deb-d515ea58f6cb','7b2184f3-2e0d-11ef-8deb-d515ea58f6cb','MODEL'),(2,'7b212ac0-2e0d-11ef-8deb-d515ea58f6cb','8c6c7633-2e0d-11ef-8deb-d515ea58f6cb','METERING'),(2,'7b449582-2e4b-11ef-8deb-d515ea58f6cb','97c7263b-2e4b-11ef-8deb-d515ea58f6cb','MODEL'),(2,'7b449582-2e4b-11ef-8deb-d515ea58f6cb','97c73c0b-2e4b-11ef-8deb-d515ea58f6cb','SNAPSHOT'),(3,'7dd4df25-225a-11ef-8d76-d310d2ec2c14','a1f87a69-225a-11ef-8d76-d310d2ec2c14','MODEL'),(3,'7dd4df25-225a-11ef-8d76-d310d2ec2c14','a1f8912f-225a-11ef-8d76-d310d2ec2c14','SNAPSHOT'),(5,'804316c5-289b-11ef-8e16-d517f37fa2ad','90d40af7-289b-11ef-8e16-d517f37fa2ad','MODEL'),(5,'804316c5-289b-11ef-8e16-d517f37fa2ad','90d41939-289b-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(11,'80540c46-2a2a-11ef-8f1c-d8242c6fa8fd','45316198-2a2c-11ef-8f1c-d8242c6fa8fd','METERING'),(11,'80540c46-2a2a-11ef-8f1c-d8242c6fa8fd','6c69f0d2-2a2c-11ef-8f1c-d8242c6fa8fd','SCREENSHOT'),(11,'80540c46-2a2a-11ef-8f1c-d8242c6fa8fd','776de714-2a2c-11ef-8f1c-d8242c6fa8fd','SCREENSHOT'),(11,'80540c46-2a2a-11ef-8f1c-d8242c6fa8fd','9584d053-2a2e-11ef-8f1c-d8242c6fa8fd','SEGMENTED'),(11,'80540c46-2a2a-11ef-8f1c-d8242c6fa8fd','aa7cded3-2a2e-11ef-8f1c-d8242c6fa8fd','SEGMENTED'),(11,'80540c46-2a2a-11ef-8f1c-d8242c6fa8fd','c1a4a542-2a2c-11ef-8f1c-d8242c6fa8fd','SCREENSHOT'),(11,'80540c46-2a2a-11ef-8f1c-d8242c6fa8fd','c8d1ce3a-2a2c-11ef-8f1c-d8242c6fa8fd','METERING'),(11,'80540c46-2a2a-11ef-8f1c-d8242c6fa8fd','d3a8591b-2a2b-11ef-8f1c-d8242c6fa8fd','LIFI'),(11,'80540c46-2a2a-11ef-8f1c-d8242c6fa8fd','d3a86170-2a2b-11ef-8f1c-d8242c6fa8fd','LIFIMETA'),(11,'80540c46-2a2a-11ef-8f1c-d8242c6fa8fd','db19bb4a-2a2a-11ef-8f1c-d8242c6fa8fd','MODEL'),(11,'80540c46-2a2a-11ef-8f1c-d8242c6fa8fd','db19d117-2a2a-11ef-8f1c-d8242c6fa8fd','SNAPSHOT'),(11,'80540c46-2a2a-11ef-8f1c-d8242c6fa8fd','ef2d44e2-2a2b-11ef-8f1c-d8242c6fa8fd','LIFI'),(11,'80540c46-2a2a-11ef-8f1c-d8242c6fa8fd','ef2d67d4-2a2b-11ef-8f1c-d8242c6fa8fd','LIFIMETA'),(2,'81adf7a6-27cb-11ef-8e37-d519fa9d22d2','98099d24-27cb-11ef-8e37-d519fa9d22d2','MODEL'),(2,'81adf7a6-27cb-11ef-8e37-d519fa9d22d2','9809acae-27cb-11ef-8e37-d519fa9d22d2','SNAPSHOT'),(2,'848d93a0-2cbb-11ef-8e27-d518f78fe3c8','848da4d1-2cbb-11ef-8e27-d518f78fe3c8','MODEL'),(2,'848d93a0-2cbb-11ef-8e27-d518f78fe3c8','8492bebe-2cbb-11ef-8e27-d518f78fe3c8','SNAPSHOT'),(2,'86f46641-2e40-11ef-8deb-d515ea58f6cb','2b452b17-2e42-11ef-8deb-d515ea58f6cb','MODEL'),(2,'86f46641-2e40-11ef-8deb-d515ea58f6cb','aa0af9eb-2e40-11ef-8deb-d515ea58f6cb','MODEL'),(2,'86f46641-2e40-11ef-8deb-d515ea58f6cb','aa0b087d-2e40-11ef-8deb-d515ea58f6cb','SNAPSHOT'),(2,'86f46641-2e40-11ef-8deb-d515ea58f6cb','be74e814-2e41-11ef-8deb-d515ea58f6cb','METERING'),(2,'8714aaaa-273d-11ef-8e09-d517f1736dc8','a72f121e-273d-11ef-8e09-d517f1736dc8','MODEL'),(2,'8714aaaa-273d-11ef-8e09-d517f1736dc8','a72f3238-273d-11ef-8e09-d517f1736dc8','SNAPSHOT'),(11,'879dec53-2987-11ef-8e16-d517f37fa2ad','afc71293-2987-11ef-8e16-d517f37fa2ad','MODEL'),(11,'879dec53-2987-11ef-8e16-d517f37fa2ad','afc73513-2987-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(11,'890595a9-296d-11ef-8e16-d517f37fa2ad','2e90e2b8-296e-11ef-8e16-d517f37fa2ad','LIFI'),(11,'890595a9-296d-11ef-8e16-d517f37fa2ad','2e90eaa9-296e-11ef-8e16-d517f37fa2ad','LIFIMETA'),(11,'890595a9-296d-11ef-8e16-d517f37fa2ad','6bce082f-296e-11ef-8e16-d517f37fa2ad','LIFI'),(11,'890595a9-296d-11ef-8e16-d517f37fa2ad','6bce11f4-296e-11ef-8e16-d517f37fa2ad','LIFIMETA'),(11,'890595a9-296d-11ef-8e16-d517f37fa2ad','9e27d113-296e-11ef-8e16-d517f37fa2ad','LIFI'),(11,'890595a9-296d-11ef-8e16-d517f37fa2ad','9e27e58a-296e-11ef-8e16-d517f37fa2ad','LIFIMETA'),(11,'890595a9-296d-11ef-8e16-d517f37fa2ad','c4d47e7b-296d-11ef-8e16-d517f37fa2ad','MODEL'),(11,'890595a9-296d-11ef-8e16-d517f37fa2ad','c4d49e5a-296d-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(11,'890595a9-296d-11ef-8e16-d517f37fa2ad','ef02a7f3-296d-11ef-8e16-d517f37fa2ad','LIFI'),(11,'890595a9-296d-11ef-8e16-d517f37fa2ad','ef02af4a-296d-11ef-8e16-d517f37fa2ad','LIFIMETA'),(2,'8bc7c92e-2e3b-11ef-8deb-d515ea58f6cb','9c09d1b7-2e3b-11ef-8deb-d515ea58f6cb','MODEL'),(2,'8bc7c92e-2e3b-11ef-8deb-d515ea58f6cb','9c09e417-2e3b-11ef-8deb-d515ea58f6cb','SNAPSHOT'),(2,'8cf4ef97-2735-11ef-8e16-d517f37fa1ab','a21821fc-2735-11ef-8e16-d517f37fa1ab','MODEL'),(2,'8cf4ef97-2735-11ef-8e16-d517f37fa1ab','a2183657-2735-11ef-8e16-d517f37fa1ab','SNAPSHOT'),(11,'8de1d45c-2a29-11ef-8f1c-d8242c6fa8fd','d2783274-2a2c-11ef-8f1c-d8242c6fa8fd','SEGMENTED'),(11,'8de1d45c-2a29-11ef-8f1c-d8242c6fa8fd','e0f8d71f-2a29-11ef-8f1c-d8242c6fa8fd','MODEL'),(11,'8de1d45c-2a29-11ef-8f1c-d8242c6fa8fd','e0f8ef08-2a29-11ef-8f1c-d8242c6fa8fd','SNAPSHOT'),(2,'8f6d5887-2740-11ef-8e09-d517f1736dc8','5113bce8-2e46-11ef-8deb-d515ea58f6cb','SEGMENTED'),(2,'8f6d5887-2740-11ef-8e09-d517f1736dc8','8f6d6658-2740-11ef-8e09-d517f1736dc8','MODEL'),(2,'8f6d5887-2740-11ef-8e09-d517f1736dc8','8f72ef2a-2740-11ef-8e09-d517f1736dc8','SNAPSHOT'),(11,'924b1ba0-2968-11ef-8e16-d517f37fa2ad','b8d4e857-2968-11ef-8e16-d517f37fa2ad','MODEL'),(11,'924b1ba0-2968-11ef-8e16-d517f37fa2ad','b8d50d4d-2968-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(11,'924ba453-2968-11ef-8e16-d517f37fa2ad','d13398f3-2968-11ef-8e16-d517f37fa2ad','MODEL'),(11,'924ba453-2968-11ef-8e16-d517f37fa2ad','d133a753-2968-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(2,'96d08283-2273-11ef-8d76-d310d2ec2c14','275970f2-2279-11ef-8d76-d310d2ec2c14','MODEL'),(2,'96d08283-2273-11ef-8d76-d310d2ec2c14','3e218de7-2274-11ef-8d76-d310d2ec2c14','MODEL'),(2,'96d08283-2273-11ef-8d76-d310d2ec2c14','3e22c831-2274-11ef-8d76-d310d2ec2c14','SNAPSHOT'),(2,'97940017-2e29-11ef-8deb-d515ea58f6cb','a824cada-2e29-11ef-8deb-d515ea58f6cb','MODEL'),(2,'97940017-2e29-11ef-8deb-d515ea58f6cb','a824ff05-2e29-11ef-8deb-d515ea58f6cb','SNAPSHOT'),(3,'981faf70-23e7-11ef-8dde-d415e84cc4f5','d0ab5861-23e7-11ef-8dde-d415e84cc4f5','MODEL'),(3,'981faf70-23e7-11ef-8dde-d415e84cc4f5','d0ab69d4-23e7-11ef-8dde-d415e84cc4f5','SNAPSHOT'),(11,'99d1c412-2990-11ef-8e16-d517f37fa2ad','caccc8fe-2990-11ef-8e16-d517f37fa2ad','MODEL'),(11,'99d1c412-2990-11ef-8e16-d517f37fa2ad','caccd68c-2990-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(5,'9d83e262-28ba-11ef-8e16-d517f37fa2ad','bdac5d67-28ba-11ef-8e16-d517f37fa2ad','MODEL'),(5,'9d83e262-28ba-11ef-8e16-d517f37fa2ad','bdac733c-28ba-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(2,'9fc70276-2277-11ef-8d76-d310d2ec2c14','d9951fef-2277-11ef-8d76-d310d2ec2c14','MODEL'),(2,'9fc70276-2277-11ef-8d76-d310d2ec2c14','d9952ebe-2277-11ef-8d76-d310d2ec2c14','SNAPSHOT'),(2,'9fc7cfd7-2277-11ef-8d76-d310d2ec2c14','2a69e711-2278-11ef-8d76-d310d2ec2c14','MODEL'),(2,'9fc7cfd7-2277-11ef-8d76-d310d2ec2c14','2a69f41f-2278-11ef-8d76-d310d2ec2c14','SNAPSHOT'),(5,'a0eae524-289c-11ef-8e16-d517f37fa2ad','ce19c205-289c-11ef-8e16-d517f37fa2ad','MODEL'),(5,'a0eae524-289c-11ef-8e16-d517f37fa2ad','ce19d8cd-289c-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(5,'a4a0d8da-289a-11ef-8e16-d517f37fa2ad','b91dbada-289a-11ef-8e16-d517f37fa2ad','MODEL'),(5,'a4a0d8da-289a-11ef-8e16-d517f37fa2ad','b91dc908-289a-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(11,'a5b11e9a-2980-11ef-8e16-d517f37fa2ad','db3b031f-2980-11ef-8e16-d517f37fa2ad','MODEL'),(11,'a5b11e9a-2980-11ef-8e16-d517f37fa2ad','db3b175f-2980-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(2,'a6d98df1-2279-11ef-8d76-d310d2ec2c14','ca114ae6-2279-11ef-8d76-d310d2ec2c14','MODEL'),(2,'a6d98df1-2279-11ef-8d76-d310d2ec2c14','ca116050-2279-11ef-8d76-d310d2ec2c14','SNAPSHOT'),(11,'a9e9d6c4-298f-11ef-8e16-d517f37fa2ad','a9e9f96d-298f-11ef-8e16-d517f37fa2ad','MODEL'),(11,'a9e9d6c4-298f-11ef-8e16-d517f37fa2ad','a9eec273-298f-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(11,'a9e9d6c4-298f-11ef-8e16-d517f37fa2ad','cb1cd7df-298f-11ef-8e16-d517f37fa2ad','MODEL'),(11,'a9e9d6c4-298f-11ef-8e16-d517f37fa2ad','e3f97f75-298f-11ef-8e16-d517f37fa2ad','SCREENSHOT'),(11,'ab40f38e-2984-11ef-8e16-d517f37fa2ad','d5da3062-2984-11ef-8e16-d517f37fa2ad','MODEL'),(11,'ab40f38e-2984-11ef-8e16-d517f37fa2ad','d5da4016-2984-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(11,'aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd','357385d7-2a2f-11ef-8f1c-d8242c6fa8fd','SCREENSHOT'),(11,'aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd','8d1feec9-2a2f-11ef-8f1c-d8242c6fa8fd','SCREENSHOT'),(11,'aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd','a1d4880f-2a2f-11ef-8f1c-d8242c6fa8fd','SCREENSHOT'),(11,'aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd','a45229a5-2a2f-11ef-8f1c-d8242c6fa8fd','METERING'),(11,'aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd','aee5f3db-2a2e-11ef-8f1c-d8242c6fa8fd','MODEL'),(11,'aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd','aeeb700b-2a2e-11ef-8f1c-d8242c6fa8fd','SNAPSHOT'),(11,'aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd','aeeb7d77-2a2e-11ef-8f1c-d8242c6fa8fd','LIFI'),(11,'aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd','aeeb8932-2a2e-11ef-8f1c-d8242c6fa8fd','LIFIMETA'),(11,'aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd','aeeb948a-2a2e-11ef-8f1c-d8242c6fa8fd','SEGMENTED'),(11,'aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd','c10a25c6-2a2e-11ef-8f1c-d8242c6fa8fd','MODEL'),(11,'aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd','dc9d5d76-2a2e-11ef-8f1c-d8242c6fa8fd','SCREENSHOT'),(11,'aee5cf84-2a2e-11ef-8f1c-d8242c6fa8fd','e0f61549-2a2e-11ef-8f1c-d8242c6fa8fd','SEGMENTED'),(11,'af431dfb-2a22-11ef-8f1c-d8242c6fa8fd','feb3ab65-2a23-11ef-8f1c-d8242c6fa8fd','MODEL'),(11,'af431dfb-2a22-11ef-8f1c-d8242c6fa8fd','feb3bc17-2a23-11ef-8f1c-d8242c6fa8fd','SNAPSHOT'),(2,'b17c4dcd-2271-11ef-8d76-d310d2ec2c14','fc8f1969-2271-11ef-8d76-d310d2ec2c14','MODEL'),(2,'b17c4dcd-2271-11ef-8d76-d310d2ec2c14','fc8f31e9-2271-11ef-8d76-d310d2ec2c14','SNAPSHOT'),(5,'b51b7dbf-28d4-11ef-8e16-d517f37fa2ad','d476e8aa-28d4-11ef-8e16-d517f37fa2ad','MODEL'),(5,'b51b7dbf-28d4-11ef-8e16-d517f37fa2ad','d4770a37-28d4-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(11,'b95b37da-2e0c-11ef-8deb-d515ea58f6cb','ca00209d-2e0c-11ef-8deb-d515ea58f6cb','MODEL'),(11,'b95b37da-2e0c-11ef-8deb-d515ea58f6cb','ca005078-2e0c-11ef-8deb-d515ea58f6cb','SNAPSHOT'),(11,'b95b37da-2e0c-11ef-8deb-d515ea58f6cb','d549d2e9-2e0c-11ef-8deb-d515ea58f6cb','MODEL'),(11,'b95b37da-2e0c-11ef-8deb-d515ea58f6cb','d9b89c30-2e0c-11ef-8deb-d515ea58f6cb','MODEL'),(2,'bc9cdff9-273a-11ef-8e16-d517f37fa1ab','c67f739f-273a-11ef-8e16-d517f37fa1ab','MODEL'),(2,'bc9cdff9-273a-11ef-8e16-d517f37fa1ab','c67f8036-273a-11ef-8e16-d517f37fa1ab','SNAPSHOT'),(2,'bfa3d876-2735-11ef-8e16-d517f37fa1ab','5b6e5c2b-2e0d-11ef-8deb-d515ea58f6cb','MODEL'),(2,'bfa3d876-2735-11ef-8e16-d517f37fa1ab','e1412689-2735-11ef-8e16-d517f37fa1ab','MODEL'),(2,'bfa3d876-2735-11ef-8e16-d517f37fa1ab','e1413c8f-2735-11ef-8e16-d517f37fa1ab','SNAPSHOT'),(2,'bfa3d876-2735-11ef-8e16-d517f37fa1ab','e921fb8b-2735-11ef-8e16-d517f37fa1ab','LIFI'),(2,'bfa3d876-2735-11ef-8e16-d517f37fa1ab','e9220178-2735-11ef-8e16-d517f37fa1ab','LIFIMETA'),(2,'c103add9-2e4d-11ef-8deb-d515ea58f6cb','d4b56463-2e4d-11ef-8deb-d515ea58f6cb','MODEL'),(2,'c103add9-2e4d-11ef-8deb-d515ea58f6cb','d4b57109-2e4d-11ef-8deb-d515ea58f6cb','SNAPSHOT'),(2,'c523efdb-2278-11ef-8d76-d310d2ec2c14','c52419e8-2278-11ef-8d76-d310d2ec2c14','MODEL'),(2,'c523efdb-2278-11ef-8d76-d310d2ec2c14','c52f1c4e-2278-11ef-8d76-d310d2ec2c14','SNAPSHOT'),(2,'c523efdb-2278-11ef-8d76-d310d2ec2c14','de217b4c-2278-11ef-8d76-d310d2ec2c14','MODEL'),(11,'c5a22d2e-2964-11ef-8e16-d517f37fa2ad','765dccd0-2965-11ef-8e16-d517f37fa2ad','MODEL'),(11,'c5a22d2e-2964-11ef-8e16-d517f37fa2ad','765f104c-2965-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(11,'c90eb287-2987-11ef-8e16-d517f37fa2ad','f6cef120-2987-11ef-8e16-d517f37fa2ad','MODEL'),(11,'c90eb287-2987-11ef-8e16-d517f37fa2ad','f6cf020a-2987-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(11,'cd2aac3c-297d-11ef-8e16-d517f37fa2ad','8870875c-297e-11ef-8e16-d517f37fa2ad','MODEL'),(11,'cd2aac3c-297d-11ef-8e16-d517f37fa2ad','88709f91-297e-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(2,'d2eec825-298a-11ef-8e16-d517f37fa2ad','01976f12-298b-11ef-8e16-d517f37fa2ad','SEGMENTED'),(2,'d2eec825-298a-11ef-8e16-d517f37fa2ad','05008ccd-298b-11ef-8e16-d517f37fa2ad','MODEL'),(2,'d2eec825-298a-11ef-8e16-d517f37fa2ad','19d016c9-298b-11ef-8e16-d517f37fa2ad','MODEL'),(2,'d2eec825-298a-11ef-8e16-d517f37fa2ad','19d03a14-298b-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(2,'d2eec825-298a-11ef-8e16-d517f37fa2ad','22738ca4-298b-11ef-8e16-d517f37fa2ad','MODEL'),(2,'d2eec825-298a-11ef-8e16-d517f37fa2ad','f29b2b38-298a-11ef-8e16-d517f37fa2ad','MODEL'),(2,'d2eec825-298a-11ef-8e16-d517f37fa2ad','f29b3e20-298a-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(2,'d891acce-2e3d-11ef-8deb-d515ea58f6cb','f80bcc6d-2e3d-11ef-8deb-d515ea58f6cb','MODEL'),(2,'d891acce-2e3d-11ef-8deb-d515ea58f6cb','f80bf097-2e3d-11ef-8deb-d515ea58f6cb','SNAPSHOT'),(11,'d8e5d9f0-296b-11ef-8e16-d517f37fa2ad','0b0ff7de-296c-11ef-8e16-d517f37fa2ad','MODEL'),(11,'d8e5d9f0-296b-11ef-8e16-d517f37fa2ad','0b1013ae-296c-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(5,'db07e23d-289b-11ef-8e16-d517f37fa2ad','02353824-289c-11ef-8e16-d517f37fa2ad','MODEL'),(5,'db07e23d-289b-11ef-8e16-d517f37fa2ad','02355a6c-289c-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(2,'dc038d5b-2e3a-11ef-8deb-d515ea58f6cb','05f5f9a0-2e3b-11ef-8deb-d515ea58f6cb','MODEL'),(2,'dc038d5b-2e3a-11ef-8deb-d515ea58f6cb','05f61e01-2e3b-11ef-8deb-d515ea58f6cb','SNAPSHOT'),(2,'dc038d5b-2e3a-11ef-8deb-d515ea58f6cb','0eb7cc4f-2e3b-11ef-8deb-d515ea58f6cb','SEGMENTED'),(11,'de3fd237-2984-11ef-8e16-d517f37fa2ad','1b924576-2985-11ef-8e16-d517f37fa2ad','MODEL'),(11,'de3fd237-2984-11ef-8e16-d517f37fa2ad','de3ffbb4-2984-11ef-8e16-d517f37fa2ad','MODEL'),(11,'de3fd237-2984-11ef-8e16-d517f37fa2ad','de45dada-2984-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(2,'e0f66733-227c-11ef-8d76-d310d2ec2c14','5998c3b0-2e0e-11ef-8deb-d515ea58f6cb','SEGMENTED'),(2,'e0f66733-227c-11ef-8d76-d310d2ec2c14','62cceaa8-2e0e-11ef-8deb-d515ea58f6cb','MODEL'),(2,'e0f66733-227c-11ef-8d76-d310d2ec2c14','7362837c-2e0e-11ef-8deb-d515ea58f6cb','MODEL'),(2,'e0f66733-227c-11ef-8d76-d310d2ec2c14','7363094e-2e0e-11ef-8deb-d515ea58f6cb','SNAPSHOT'),(2,'e0f66733-227c-11ef-8d76-d310d2ec2c14','f51d71ce-227c-11ef-8d76-d310d2ec2c14','MODEL'),(2,'e0f66733-227c-11ef-8d76-d310d2ec2c14','f51d8554-227c-11ef-8d76-d310d2ec2c14','SNAPSHOT'),(2,'e16361f9-2e3c-11ef-8deb-d515ea58f6cb','05feb90c-2e3d-11ef-8deb-d515ea58f6cb','MODEL'),(2,'e16361f9-2e3c-11ef-8deb-d515ea58f6cb','05fecc31-2e3d-11ef-8deb-d515ea58f6cb','SNAPSHOT'),(11,'e2305601-296e-11ef-8e16-d517f37fa2ad','4343804f-296f-11ef-8e16-d517f37fa2ad','MODEL'),(11,'e2305601-296e-11ef-8e16-d517f37fa2ad','43438f7c-296f-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(11,'e3221a36-2990-11ef-8e16-d517f37fa2ad','18341594-2991-11ef-8e16-d517f37fa2ad','MODEL'),(11,'e3221a36-2990-11ef-8e16-d517f37fa2ad','183425ff-2991-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(5,'e57cd1ee-28c5-11ef-8e16-d517f37fa2ad','03f2be58-28c6-11ef-8e16-d517f37fa2ad','MODEL'),(5,'e57cd1ee-28c5-11ef-8e16-d517f37fa2ad','03f2d4de-28c6-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(2,'e631c430-2e0e-11ef-8deb-d515ea58f6cb','204c79d2-2e0f-11ef-8deb-d515ea58f6cb','SEGMENTED'),(2,'e631c430-2e0e-11ef-8deb-d515ea58f6cb','23d695ae-2e0f-11ef-8deb-d515ea58f6cb','MODEL'),(2,'e631c430-2e0e-11ef-8deb-d515ea58f6cb','3464d86c-2e0f-11ef-8deb-d515ea58f6cb','MODEL'),(2,'e631c430-2e0e-11ef-8deb-d515ea58f6cb','34652cdb-2e0f-11ef-8deb-d515ea58f6cb','SNAPSHOT'),(2,'e631c430-2e0e-11ef-8deb-d515ea58f6cb','39aa600d-2e0f-11ef-8deb-d515ea58f6cb','SEGMENTED'),(2,'e631c430-2e0e-11ef-8deb-d515ea58f6cb','f6bd91e1-2e0e-11ef-8deb-d515ea58f6cb','MODEL'),(2,'e631c430-2e0e-11ef-8deb-d515ea58f6cb','f6bdc013-2e0e-11ef-8deb-d515ea58f6cb','SNAPSHOT'),(11,'e7c571a1-2968-11ef-8e16-d517f37fa2ad','0d4ea307-2969-11ef-8e16-d517f37fa2ad','MODEL'),(11,'e7c571a1-2968-11ef-8e16-d517f37fa2ad','0d4eb27a-2969-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(11,'e7c5fece-2968-11ef-8e16-d517f37fa2ad','25cc486a-2969-11ef-8e16-d517f37fa2ad','MODEL'),(11,'e7c5fece-2968-11ef-8e16-d517f37fa2ad','25cc56fd-2969-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(11,'e97f72f6-2a20-11ef-8f1c-d8242c6fa8fd','94f64547-2a21-11ef-8f1c-d8242c6fa8fd','MODEL'),(11,'e97f72f6-2a20-11ef-8f1c-d8242c6fa8fd','94f65e70-2a21-11ef-8f1c-d8242c6fa8fd','SNAPSHOT'),(11,'ea470b5e-2a2a-11ef-8f1c-d8242c6fa8fd','3fefed07-2a2b-11ef-8f1c-d8242c6fa8fd','MODEL'),(11,'ea470b5e-2a2a-11ef-8f1c-d8242c6fa8fd','3ff003dd-2a2b-11ef-8f1c-d8242c6fa8fd','SNAPSHOT'),(2,'eae3435c-27ca-11ef-8e37-d519fa9d22d2','eae398fb-27ca-11ef-8e37-d519fa9d22d2','MODEL'),(2,'eae3435c-27ca-11ef-8e37-d519fa9d22d2','eaec83ff-27ca-11ef-8e37-d519fa9d22d2','SNAPSHOT'),(2,'ec642b7f-273c-11ef-8e16-d517f37fa1ab','0cbc6058-273d-11ef-8e16-d517f37fa1ab','MODEL'),(2,'ec642b7f-273c-11ef-8e16-d517f37fa1ab','0cbc72d3-273d-11ef-8e16-d517f37fa1ab','SNAPSHOT'),(11,'ef33e0e4-2a28-11ef-8f1c-d8242c6fa8fd','672ce220-2a29-11ef-8f1c-d8242c6fa8fd','SEGMENTED'),(11,'ef33e0e4-2a28-11ef-8f1c-d8242c6fa8fd','ef340569-2a28-11ef-8f1c-d8242c6fa8fd','MODEL'),(11,'ef33e0e4-2a28-11ef-8f1c-d8242c6fa8fd','ef43b37e-2a28-11ef-8f1c-d8242c6fa8fd','SNAPSHOT'),(11,'f3a386e0-2965-11ef-8e16-d517f37fa2ad','c80e9775-2966-11ef-8e16-d517f37fa2ad','MODEL'),(11,'f3a386e0-2965-11ef-8e16-d517f37fa2ad','c80fd072-2966-11ef-8e16-d517f37fa2ad','SNAPSHOT'),(2,'f3b0649e-2272-11ef-8d76-d310d2ec2c14','9005271a-2273-11ef-8d76-d310d2ec2c14','MODEL'),(2,'f3b0649e-2272-11ef-8d76-d310d2ec2c14','90053a20-2273-11ef-8d76-d310d2ec2c14','SNAPSHOT'),(2,'f516112b-2731-11ef-8e16-d517f37fa1ab','14dbc96b-2732-11ef-8e16-d517f37fa1ab','MODEL'),(2,'f516112b-2731-11ef-8e16-d517f37fa1ab','14dbdff4-2732-11ef-8e16-d517f37fa1ab','SNAPSHOT'),(2,'f9e998f8-2e4c-11ef-8deb-d515ea58f6cb','0f949b7b-2e4d-11ef-8deb-d515ea58f6cb','MODEL'),(2,'f9e998f8-2e4c-11ef-8deb-d515ea58f6cb','0f94ab65-2e4d-11ef-8deb-d515ea58f6cb','SNAPSHOT');
/*!40000 ALTER TABLE `ScanFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SentAttachment`
--

DROP TABLE IF EXISTS `SentAttachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SentAttachment` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `sentMessageId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  PRIMARY KEY (`sentMessageId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `SentAttachment_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `SentAttachment_ibfk_2` FOREIGN KEY (`sentMessageId`) REFERENCES `SentMessage` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `SentAttachment_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SentAttachment`
--

LOCK TABLES `SentAttachment` WRITE;
/*!40000 ALTER TABLE `SentAttachment` DISABLE KEYS */;
INSERT INTO `SentAttachment` VALUES (2,'0874bbc1-2403-11ef-8dde-d415e84cc4f5','080061b0-2403-11ef-8dde-d415e84cc4f5'),(2,'0874bbc1-2403-11ef-8dde-d415e84cc4f5','f51d71ce-227c-11ef-8d76-d310d2ec2c14'),(2,'0874bbc1-2403-11ef-8dde-d415e84cc4f5','f51d8554-227c-11ef-8d76-d310d2ec2c14'),(2,'0d22759d-225e-11ef-8f1f-d8242c71b430','9484c123-225d-11ef-8f1f-d8242c71b430'),(2,'0f3e4980-225d-11ef-8f1f-d8242c71b430','0ed5b8be-225d-11ef-8f1f-d8242c71b430'),(2,'0f3e4980-225d-11ef-8f1f-d8242c71b430','326e28f0-225b-11ef-8f1f-d8242c71b430'),(2,'0f3e4980-225d-11ef-8f1f-d8242c71b430','326e3f34-225b-11ef-8f1f-d8242c71b430'),(2,'0f3e4980-225d-11ef-8f1f-d8242c71b430','6782502c-225b-11ef-8f1f-d8242c71b430'),(2,'0f3e4980-225d-11ef-8f1f-d8242c71b430','67825ce8-225b-11ef-8f1f-d8242c71b430'),(2,'0f3e4980-225d-11ef-8f1f-d8242c71b430','e000eb20-225b-11ef-8f1f-d8242c71b430'),(2,'0f3e4980-225d-11ef-8f1f-d8242c71b430','e01bae07-225b-11ef-8f1f-d8242c71b430'),(2,'0f3e4980-225d-11ef-8f1f-d8242c71b430','e091c2ff-225b-11ef-8f1f-d8242c71b430'),(2,'2602522e-2e4c-11ef-8deb-d515ea58f6cb','259181e4-2e4c-11ef-8deb-d515ea58f6cb'),(2,'2602522e-2e4c-11ef-8deb-d515ea58f6cb','3944017f-2e4b-11ef-8deb-d515ea58f6cb'),(2,'2602522e-2e4c-11ef-8deb-d515ea58f6cb','394418b6-2e4b-11ef-8deb-d515ea58f6cb'),(2,'2602522e-2e4c-11ef-8deb-d515ea58f6cb','62490a02-2e4b-11ef-8deb-d515ea58f6cb'),(2,'2602522e-2e4c-11ef-8deb-d515ea58f6cb','624917e7-2e4b-11ef-8deb-d515ea58f6cb'),(2,'2602522e-2e4c-11ef-8deb-d515ea58f6cb','cca14134-2e4b-11ef-8deb-d515ea58f6cb'),(2,'2602522e-2e4c-11ef-8deb-d515ea58f6cb','cd43bf12-2e4b-11ef-8deb-d515ea58f6cb'),(2,'2602522e-2e4c-11ef-8deb-d515ea58f6cb','d2ad1a19-2e4b-11ef-8deb-d515ea58f6cb'),(2,'2d654e78-2272-11ef-8d76-d310d2ec2c14','2cf3311a-2272-11ef-8d76-d310d2ec2c14'),(2,'2d654e78-2272-11ef-8d76-d310d2ec2c14','fc8f1969-2271-11ef-8d76-d310d2ec2c14'),(2,'2d654e78-2272-11ef-8d76-d310d2ec2c14','fc8f31e9-2271-11ef-8d76-d310d2ec2c14'),(2,'30f0f8e5-2279-11ef-8d76-d310d2ec2c14','1c9626b7-2279-11ef-8d76-d310d2ec2c14'),(2,'30f0f8e5-2279-11ef-8d76-d310d2ec2c14','275970f2-2279-11ef-8d76-d310d2ec2c14'),(2,'30f0f8e5-2279-11ef-8d76-d310d2ec2c14','307ab64c-2279-11ef-8d76-d310d2ec2c14'),(2,'30f0f8e5-2279-11ef-8d76-d310d2ec2c14','3e22c831-2274-11ef-8d76-d310d2ec2c14'),(2,'30f0f8e5-2279-11ef-8d76-d310d2ec2c14','5bc001f1-2278-11ef-8d76-d310d2ec2c14'),(2,'30f0f8e5-2279-11ef-8d76-d310d2ec2c14','613c6795-2278-11ef-8d76-d310d2ec2c14'),(2,'30f0f8e5-2279-11ef-8d76-d310d2ec2c14','8c08eecf-2278-11ef-8d76-d310d2ec2c14'),(2,'30f0f8e5-2279-11ef-8d76-d310d2ec2c14','9005271a-2273-11ef-8d76-d310d2ec2c14'),(2,'30f0f8e5-2279-11ef-8d76-d310d2ec2c14','90053a20-2273-11ef-8d76-d310d2ec2c14'),(2,'30f0f8e5-2279-11ef-8d76-d310d2ec2c14','c52f1c4e-2278-11ef-8d76-d310d2ec2c14'),(2,'30f0f8e5-2279-11ef-8d76-d310d2ec2c14','de217b4c-2278-11ef-8d76-d310d2ec2c14'),(2,'30f0f8e5-2279-11ef-8d76-d310d2ec2c14','e59826d2-2278-11ef-8d76-d310d2ec2c14'),(2,'33305035-2e42-11ef-8deb-d515ea58f6cb','1d1765b7-2e42-11ef-8deb-d515ea58f6cb'),(2,'33305035-2e42-11ef-8deb-d515ea58f6cb','1d1774ff-2e42-11ef-8deb-d515ea58f6cb'),(2,'33305035-2e42-11ef-8deb-d515ea58f6cb','2b452b17-2e42-11ef-8deb-d515ea58f6cb'),(2,'33305035-2e42-11ef-8deb-d515ea58f6cb','32bdfef7-2e42-11ef-8deb-d515ea58f6cb'),(2,'33305035-2e42-11ef-8deb-d515ea58f6cb','aa0b087d-2e40-11ef-8deb-d515ea58f6cb'),(2,'550f3fc1-226b-11ef-8f1f-d8242c71b430','54a67fcd-226b-11ef-8f1f-d8242c71b430'),(2,'550f3fc1-226b-11ef-8f1f-d8242c71b430','6461ca85-2269-11ef-8f1f-d8242c71b430'),(2,'550f3fc1-226b-11ef-8f1f-d8242c71b430','6461d309-2269-11ef-8f1f-d8242c71b430'),(2,'550f3fc1-226b-11ef-8f1f-d8242c71b430','8103b4c6-2269-11ef-8f1f-d8242c71b430'),(2,'550f3fc1-226b-11ef-8f1f-d8242c71b430','8103b848-2269-11ef-8f1f-d8242c71b430'),(2,'550f3fc1-226b-11ef-8f1f-d8242c71b430','9e41d416-2269-11ef-8f1f-d8242c71b430'),(2,'550f3fc1-226b-11ef-8f1f-d8242c71b430','f3576589-2268-11ef-8f1f-d8242c71b430'),(2,'550f3fc1-226b-11ef-8f1f-d8242c71b430','f4024e3a-2268-11ef-8f1f-d8242c71b430'),(2,'5c87a655-2e3c-11ef-8deb-d515ea58f6cb','254bffc7-2e3c-11ef-8deb-d515ea58f6cb'),(2,'5c87a655-2e3c-11ef-8deb-d515ea58f6cb','5c16705b-2e3c-11ef-8deb-d515ea58f6cb'),(2,'5c87a655-2e3c-11ef-8deb-d515ea58f6cb','c191f4f9-2e3b-11ef-8deb-d515ea58f6cb'),(2,'5c87a655-2e3c-11ef-8deb-d515ea58f6cb','c22f9f80-2e3b-11ef-8deb-d515ea58f6cb'),(2,'5c87a655-2e3c-11ef-8deb-d515ea58f6cb','e6a1b524-2e3b-11ef-8deb-d515ea58f6cb'),(2,'5c87a655-2e3c-11ef-8deb-d515ea58f6cb','ecd551db-2e3b-11ef-8deb-d515ea58f6cb'),(2,'5c87a655-2e3c-11ef-8deb-d515ea58f6cb','ee91fd74-2e3b-11ef-8deb-d515ea58f6cb'),(2,'5c87a655-2e3c-11ef-8deb-d515ea58f6cb','f00455a1-2e3b-11ef-8deb-d515ea58f6cb'),(2,'5c87a655-2e3c-11ef-8deb-d515ea58f6cb','f17e0ce7-2e3b-11ef-8deb-d515ea58f6cb'),(2,'5c87a655-2e3c-11ef-8deb-d515ea58f6cb','f4f2c020-2e3b-11ef-8deb-d515ea58f6cb'),(2,'673530bc-2272-11ef-8d76-d310d2ec2c14','5bd68def-2272-11ef-8d76-d310d2ec2c14'),(2,'673530bc-2272-11ef-8d76-d310d2ec2c14','5bd6a4c3-2272-11ef-8d76-d310d2ec2c14'),(2,'673530bc-2272-11ef-8d76-d310d2ec2c14','66bc3d46-2272-11ef-8d76-d310d2ec2c14'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','10a0d811-2339-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','10a0db7f-2339-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','10a34539-2339-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','10a347ba-2339-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','1ad1adb2-233a-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','1ffbaca6-2338-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','3be30703-233b-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','4c9462f1-2338-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','51e7fbf0-233a-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','51e81127-233a-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','51ec0746-233a-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','51ec1340-233a-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','59191380-233f-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','596c715a-233c-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','596c8055-233c-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','596c8c7f-233c-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','596cc291-233c-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','5ac77cab-233a-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','5f8fef48-233c-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','5fc0481a-233c-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','5fc04dc7-233c-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','5fe3c6fc-233b-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','6d75c326-233f-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','719a9003-233b-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','719a949c-233b-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','71a237c5-233b-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','71a23b4a-233b-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','84af3b89-233b-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','b0cc95f2-233b-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','d6119db2-233b-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','fdd0378f-2338-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','fde62b96-2338-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','fe5950b5-2338-11ef-8f93-d92a45da78c9'),(2,'75433112-226f-11ef-8f1f-d8242c71b430','58bcb05a-226f-11ef-8f1f-d8242c71b430'),(2,'75433112-226f-11ef-8f1f-d8242c71b430','58bcc45d-226f-11ef-8f1f-d8242c71b430'),(2,'75433112-226f-11ef-8f1f-d8242c71b430','74d6b1c3-226f-11ef-8f1f-d8242c71b430'),(2,'8e9d97c9-2738-11ef-8e16-d517f37fa1ab','3326d65f-2720-11ef-8e16-d517f37fa1ab'),(2,'8e9d97c9-2738-11ef-8e16-d517f37fa1ab','3326f9f5-2720-11ef-8e16-d517f37fa1ab'),(2,'8e9d97c9-2738-11ef-8e16-d517f37fa1ab','73b17774-2720-11ef-8e16-d517f37fa1ab'),(2,'8e9d97c9-2738-11ef-8e16-d517f37fa1ab','73b18674-2720-11ef-8e16-d517f37fa1ab'),(2,'8e9d97c9-2738-11ef-8e16-d517f37fa1ab','8e2e7cc7-2738-11ef-8e16-d517f37fa1ab'),(2,'8e9d97c9-2738-11ef-8e16-d517f37fa1ab','e4230834-2737-11ef-8e16-d517f37fa1ab'),(2,'8e9d97c9-2738-11ef-8e16-d517f37fa1ab','e42318eb-2737-11ef-8e16-d517f37fa1ab'),(2,'91a29730-2e43-11ef-8deb-d515ea58f6cb','639f7d1c-2e43-11ef-8deb-d515ea58f6cb'),(2,'91a29730-2e43-11ef-8deb-d515ea58f6cb','639fcb29-2e43-11ef-8deb-d515ea58f6cb'),(2,'91a29730-2e43-11ef-8deb-d515ea58f6cb','912d936b-2e43-11ef-8deb-d515ea58f6cb'),(2,'9c944f7a-27ce-11ef-8e37-d519fa9d22d2','9c24cd94-27ce-11ef-8e37-d519fa9d22d2'),(2,'9c944f7a-27ce-11ef-8e37-d519fa9d22d2','e1412689-2735-11ef-8e16-d517f37fa1ab'),(2,'9c944f7a-27ce-11ef-8e37-d519fa9d22d2','e1413c8f-2735-11ef-8e16-d517f37fa1ab'),(2,'9c944f7a-27ce-11ef-8e37-d519fa9d22d2','e921fb8b-2735-11ef-8e16-d517f37fa1ab'),(2,'9c944f7a-27ce-11ef-8e37-d519fa9d22d2','e9220178-2735-11ef-8e16-d517f37fa1ab'),(2,'ae66af70-27ca-11ef-8e37-d519fa9d22d2','76d290b9-273c-11ef-8e16-d517f37fa1ab'),(2,'ae66af70-27ca-11ef-8e37-d519fa9d22d2','76d2a559-273c-11ef-8e16-d517f37fa1ab'),(2,'ae66af70-27ca-11ef-8e37-d519fa9d22d2','adfd6dd3-27ca-11ef-8e37-d519fa9d22d2'),(2,'b7df2f87-2e3c-11ef-8deb-d515ea58f6cb','2d0d25e8-2e0d-11ef-8deb-d515ea58f6cb'),(2,'b7df2f87-2e3c-11ef-8deb-d515ea58f6cb','4212f31d-2e0d-11ef-8deb-d515ea58f6cb'),(2,'be91b6bf-2733-11ef-8e16-d517f37fa1ab','ca114ae6-2279-11ef-8d76-d310d2ec2c14'),(2,'be91b6bf-2733-11ef-8e16-d517f37fa1ab','ca116050-2279-11ef-8d76-d310d2ec2c14'),(2,'ca7695c9-2e41-11ef-8deb-d515ea58f6cb','aa0af9eb-2e40-11ef-8deb-d515ea58f6cb'),(2,'ca7695c9-2e41-11ef-8deb-d515ea58f6cb','aa0b087d-2e40-11ef-8deb-d515ea58f6cb'),(2,'ca7695c9-2e41-11ef-8deb-d515ea58f6cb','ca082562-2e41-11ef-8deb-d515ea58f6cb'),(2,'d387710c-27c8-11ef-8e37-d519fa9d22d2','a21821fc-2735-11ef-8e16-d517f37fa1ab'),(2,'d387710c-27c8-11ef-8e37-d519fa9d22d2','a2183657-2735-11ef-8e16-d517f37fa1ab'),(2,'d387710c-27c8-11ef-8e37-d519fa9d22d2','d316761c-27c8-11ef-8e37-d519fa9d22d2'),(2,'d61618a0-2279-11ef-8d76-d310d2ec2c14','ca114ae6-2279-11ef-8d76-d310d2ec2c14'),(2,'d61618a0-2279-11ef-8d76-d310d2ec2c14','ca116050-2279-11ef-8d76-d310d2ec2c14'),(2,'d61618a0-2279-11ef-8d76-d310d2ec2c14','d59e4f7d-2279-11ef-8d76-d310d2ec2c14'),(2,'d8a6277b-2e42-11ef-8deb-d515ea58f6cb','953ccd86-2e42-11ef-8deb-d515ea58f6cb'),(2,'d8a6277b-2e42-11ef-8deb-d515ea58f6cb','bde80801-2e42-11ef-8deb-d515ea58f6cb'),(2,'d8a6277b-2e42-11ef-8deb-d515ea58f6cb','d2fc9984-2e42-11ef-8deb-d515ea58f6cb'),(2,'d8a6277b-2e42-11ef-8deb-d515ea58f6cb','d8355af9-2e42-11ef-8deb-d515ea58f6cb'),(2,'e5fbd2ab-2e4d-11ef-8deb-d515ea58f6cb','0f949b7b-2e4d-11ef-8deb-d515ea58f6cb'),(2,'e5fbd2ab-2e4d-11ef-8deb-d515ea58f6cb','0f94ab65-2e4d-11ef-8deb-d515ea58f6cb'),(2,'e5fbd2ab-2e4d-11ef-8deb-d515ea58f6cb','e58acb2d-2e4d-11ef-8deb-d515ea58f6cb'),(2,'ef1364ca-2e41-11ef-8deb-d515ea58f6cb','aa0af9eb-2e40-11ef-8deb-d515ea58f6cb'),(2,'ef1364ca-2e41-11ef-8deb-d515ea58f6cb','aa0b087d-2e40-11ef-8deb-d515ea58f6cb'),(2,'ef1364ca-2e41-11ef-8deb-d515ea58f6cb','eea0c13a-2e41-11ef-8deb-d515ea58f6cb'),(2,'fa2fabfb-2e4d-11ef-8deb-d515ea58f6cb','0f949b7b-2e4d-11ef-8deb-d515ea58f6cb'),(2,'fa2fabfb-2e4d-11ef-8deb-d515ea58f6cb','0f94ab65-2e4d-11ef-8deb-d515ea58f6cb'),(2,'fa2fabfb-2e4d-11ef-8deb-d515ea58f6cb','f9c06fb9-2e4d-11ef-8deb-d515ea58f6cb'),(2,'ff68612f-227d-11ef-8f8c-d92a43d45d56','f0c1893d-227d-11ef-8f8c-d92a43d45d56'),(2,'ff68612f-227d-11ef-8f8c-d92a43d45d56','f0c1a284-227d-11ef-8f8c-d92a43d45d56'),(2,'ff68612f-227d-11ef-8f8c-d92a43d45d56','fefc53d6-227d-11ef-8f8c-d92a43d45d56'),(3,'33e44dc1-23e9-11ef-8dde-d415e84cc4f5','242c6766-23e9-11ef-8dde-d415e84cc4f5'),(3,'33e44dc1-23e9-11ef-8dde-d415e84cc4f5','242c7d2a-23e9-11ef-8dde-d415e84cc4f5'),(3,'33e44dc1-23e9-11ef-8dde-d415e84cc4f5','336ff6af-23e9-11ef-8dde-d415e84cc4f5'),(3,'9ac047ea-23eb-11ef-8dde-d415e84cc4f5','9a5291cb-23eb-11ef-8dde-d415e84cc4f5'),(3,'9ac047ea-23eb-11ef-8dde-d415e84cc4f5','d0ab5861-23e7-11ef-8dde-d415e84cc4f5'),(3,'9ac047ea-23eb-11ef-8dde-d415e84cc4f5','d0ab69d4-23e7-11ef-8dde-d415e84cc4f5'),(3,'fb69a8c0-23e7-11ef-8dde-d415e84cc4f5','d0ab5861-23e7-11ef-8dde-d415e84cc4f5'),(3,'fb69a8c0-23e7-11ef-8dde-d415e84cc4f5','d0ab69d4-23e7-11ef-8dde-d415e84cc4f5'),(3,'fb69a8c0-23e7-11ef-8dde-d415e84cc4f5','fafc415d-23e7-11ef-8dde-d415e84cc4f5'),(5,'24b7ab8b-28a0-11ef-8e16-d517f37fa2ad','24467343-28a0-11ef-8e16-d517f37fa2ad'),(5,'24b7ab8b-28a0-11ef-8e16-d517f37fa2ad','3ef48adf-289c-11ef-8e16-d517f37fa2ad'),(5,'24b7ab8b-28a0-11ef-8e16-d517f37fa2ad','3f100ab3-289c-11ef-8e16-d517f37fa2ad'),(5,'24b7ab8b-28a0-11ef-8e16-d517f37fa2ad','3f7b0e6c-289c-11ef-8e16-d517f37fa2ad'),(5,'6fb37b74-28a0-11ef-8e16-d517f37fa2ad','6f42baa5-28a0-11ef-8e16-d517f37fa2ad'),(5,'6fb37b74-28a0-11ef-8e16-d517f37fa2ad','f11a7ce4-289c-11ef-8e16-d517f37fa2ad'),(5,'6fb37b74-28a0-11ef-8e16-d517f37fa2ad','f125c583-289c-11ef-8e16-d517f37fa2ad'),(5,'6fb37b74-28a0-11ef-8e16-d517f37fa2ad','f1901fb9-289c-11ef-8e16-d517f37fa2ad'),(5,'88fb6e51-28a0-11ef-8e16-d517f37fa2ad','90d40af7-289b-11ef-8e16-d517f37fa2ad'),(5,'88fb6e51-28a0-11ef-8e16-d517f37fa2ad','90d41939-289b-11ef-8e16-d517f37fa2ad'),(5,'a7736a88-289f-11ef-8e16-d517f37fa2ad','90d40af7-289b-11ef-8e16-d517f37fa2ad'),(5,'a7736a88-289f-11ef-8e16-d517f37fa2ad','90d41939-289b-11ef-8e16-d517f37fa2ad'),(5,'a7736a88-289f-11ef-8e16-d517f37fa2ad','a6fb3865-289f-11ef-8e16-d517f37fa2ad'),(5,'a7736a88-289f-11ef-8e16-d517f37fa2ad','b91dbada-289a-11ef-8e16-d517f37fa2ad'),(5,'a7736a88-289f-11ef-8e16-d517f37fa2ad','b91dc908-289a-11ef-8e16-d517f37fa2ad'),(5,'be27ff6b-289d-11ef-8e16-d517f37fa2ad','7f0190db-289a-11ef-8e16-d517f37fa2ad'),(5,'be27ff6b-289d-11ef-8e16-d517f37fa2ad','7f01a3ee-289a-11ef-8e16-d517f37fa2ad'),(5,'be27ff6b-289d-11ef-8e16-d517f37fa2ad','b91dbada-289a-11ef-8e16-d517f37fa2ad'),(5,'be27ff6b-289d-11ef-8e16-d517f37fa2ad','b91dc908-289a-11ef-8e16-d517f37fa2ad'),(5,'be27ff6b-289d-11ef-8e16-d517f37fa2ad','bdb51817-289d-11ef-8e16-d517f37fa2ad'),(5,'be27ff6b-289d-11ef-8e16-d517f37fa2ad','f11a7ce4-289c-11ef-8e16-d517f37fa2ad'),(5,'be27ff6b-289d-11ef-8e16-d517f37fa2ad','f125c583-289c-11ef-8e16-d517f37fa2ad'),(5,'be27ff6b-289d-11ef-8e16-d517f37fa2ad','f1901fb9-289c-11ef-8e16-d517f37fa2ad'),(5,'c1a443f6-289e-11ef-8e16-d517f37fa2ad','02353824-289c-11ef-8e16-d517f37fa2ad'),(5,'c1a443f6-289e-11ef-8e16-d517f37fa2ad','02355a6c-289c-11ef-8e16-d517f37fa2ad'),(5,'c1a443f6-289e-11ef-8e16-d517f37fa2ad','3ef48adf-289c-11ef-8e16-d517f37fa2ad'),(5,'c1a443f6-289e-11ef-8e16-d517f37fa2ad','3f100ab3-289c-11ef-8e16-d517f37fa2ad'),(5,'c1a443f6-289e-11ef-8e16-d517f37fa2ad','3f7b0e6c-289c-11ef-8e16-d517f37fa2ad'),(5,'c1a443f6-289e-11ef-8e16-d517f37fa2ad','90d40af7-289b-11ef-8e16-d517f37fa2ad'),(5,'c1a443f6-289e-11ef-8e16-d517f37fa2ad','90d41939-289b-11ef-8e16-d517f37fa2ad'),(5,'c1a443f6-289e-11ef-8e16-d517f37fa2ad','c13314ae-289e-11ef-8e16-d517f37fa2ad'),(11,'14ca16db-2a2f-11ef-8f1c-d8242c6fa8fd','145531e1-2a2f-11ef-8f1c-d8242c6fa8fd'),(11,'14ca16db-2a2f-11ef-8f1c-d8242c6fa8fd','432c5ac7-2a2b-11ef-8f1c-d8242c6fa8fd'),(11,'14ca16db-2a2f-11ef-8f1c-d8242c6fa8fd','6c69f0d2-2a2c-11ef-8f1c-d8242c6fa8fd'),(11,'14ca16db-2a2f-11ef-8f1c-d8242c6fa8fd','7e31fba5-2a2b-11ef-8f1c-d8242c6fa8fd'),(11,'14ca16db-2a2f-11ef-8f1c-d8242c6fa8fd','aeeb700b-2a2e-11ef-8f1c-d8242c6fa8fd'),(11,'14ca16db-2a2f-11ef-8f1c-d8242c6fa8fd','aeeb7d77-2a2e-11ef-8f1c-d8242c6fa8fd'),(11,'14ca16db-2a2f-11ef-8f1c-d8242c6fa8fd','aeeb8932-2a2e-11ef-8f1c-d8242c6fa8fd'),(11,'14ca16db-2a2f-11ef-8f1c-d8242c6fa8fd','b5074b88-2a2b-11ef-8f1c-d8242c6fa8fd'),(11,'14ca16db-2a2f-11ef-8f1c-d8242c6fa8fd','c10a25c6-2a2e-11ef-8f1c-d8242c6fa8fd'),(11,'14ca16db-2a2f-11ef-8f1c-d8242c6fa8fd','c1a4a542-2a2c-11ef-8f1c-d8242c6fa8fd'),(11,'14ca16db-2a2f-11ef-8f1c-d8242c6fa8fd','dc9d5d76-2a2e-11ef-8f1c-d8242c6fa8fd'),(11,'14ca16db-2a2f-11ef-8f1c-d8242c6fa8fd','e0f8d71f-2a29-11ef-8f1c-d8242c6fa8fd'),(11,'14ca16db-2a2f-11ef-8f1c-d8242c6fa8fd','e0f8ef08-2a29-11ef-8f1c-d8242c6fa8fd'),(11,'14ca16db-2a2f-11ef-8f1c-d8242c6fa8fd','ef2d44e2-2a2b-11ef-8f1c-d8242c6fa8fd'),(11,'14ca16db-2a2f-11ef-8f1c-d8242c6fa8fd','ef2d67d4-2a2b-11ef-8f1c-d8242c6fa8fd'),(11,'14ca16db-2a2f-11ef-8f1c-d8242c6fa8fd','ef33f313-2a2b-11ef-8f1c-d8242c6fa8fd'),(11,'14ca16db-2a2f-11ef-8f1c-d8242c6fa8fd','ef341516-2a2b-11ef-8f1c-d8242c6fa8fd'),(11,'1a9029b2-296b-11ef-8e16-d517f37fa2ad','089e2b2d-296b-11ef-8e16-d517f37fa2ad'),(11,'1a9029b2-296b-11ef-8e16-d517f37fa2ad','1a206393-296b-11ef-8e16-d517f37fa2ad'),(11,'1a9029b2-296b-11ef-8e16-d517f37fa2ad','21107477-296a-11ef-8e16-d517f37fa2ad'),(11,'1a9029b2-296b-11ef-8e16-d517f37fa2ad','64880729-2964-11ef-8e16-d517f37fa2ad'),(11,'1a9029b2-296b-11ef-8e16-d517f37fa2ad','a8c82bcb-296a-11ef-8e16-d517f37fa2ad'),(11,'1a9029b2-296b-11ef-8e16-d517f37fa2ad','a90adf72-296a-11ef-8e16-d517f37fa2ad'),(11,'1a9029b2-296b-11ef-8e16-d517f37fa2ad','c80e9775-2966-11ef-8e16-d517f37fa2ad'),(11,'1a9029b2-296b-11ef-8e16-d517f37fa2ad','c80fd072-2966-11ef-8e16-d517f37fa2ad'),(11,'20a09331-2984-11ef-8e16-d517f37fa2ad','202d91d6-2984-11ef-8e16-d517f37fa2ad'),(11,'20a09331-2984-11ef-8e16-d517f37fa2ad','43ea5aab-2981-11ef-8e16-d517f37fa2ad'),(11,'20a09331-2984-11ef-8e16-d517f37fa2ad','43ea9afd-2981-11ef-8e16-d517f37fa2ad'),(11,'20a09331-2984-11ef-8e16-d517f37fa2ad','7dc312cb-2981-11ef-8e16-d517f37fa2ad'),(11,'20a09331-2984-11ef-8e16-d517f37fa2ad','be9062f3-2982-11ef-8e16-d517f37fa2ad'),(11,'20a09331-2984-11ef-8e16-d517f37fa2ad','c5e732c1-2983-11ef-8e16-d517f37fa2ad'),(11,'20a09331-2984-11ef-8e16-d517f37fa2ad','e09fbf20-2980-11ef-8e16-d517f37fa2ad'),(11,'20a09331-2984-11ef-8e16-d517f37fa2ad','e3ffe01f-2982-11ef-8e16-d517f37fa2ad'),(11,'2aa35b06-2988-11ef-8e16-d517f37fa2ad','05998f46-2988-11ef-8e16-d517f37fa2ad'),(11,'2aa35b06-2988-11ef-8e16-d517f37fa2ad','2a2ce13d-2988-11ef-8e16-d517f37fa2ad'),(11,'2aa35b06-2988-11ef-8e16-d517f37fa2ad','fb21655b-2987-11ef-8e16-d517f37fa2ad'),(11,'2aa35b06-2988-11ef-8e16-d517f37fa2ad','fbb6d74e-2987-11ef-8e16-d517f37fa2ad'),(11,'3d61fa93-2986-11ef-8e16-d517f37fa2ad','3cf533b7-2986-11ef-8e16-d517f37fa2ad'),(11,'3d61fa93-2986-11ef-8e16-d517f37fa2ad','43ea5aab-2981-11ef-8e16-d517f37fa2ad'),(11,'3d61fa93-2986-11ef-8e16-d517f37fa2ad','43ea9afd-2981-11ef-8e16-d517f37fa2ad'),(11,'3d61fa93-2986-11ef-8e16-d517f37fa2ad','45df8951-2980-11ef-8e16-d517f37fa2ad'),(11,'3d61fa93-2986-11ef-8e16-d517f37fa2ad','45df9f47-2980-11ef-8e16-d517f37fa2ad'),(11,'3d61fa93-2986-11ef-8e16-d517f37fa2ad','7dc312cb-2981-11ef-8e16-d517f37fa2ad'),(11,'3d61fa93-2986-11ef-8e16-d517f37fa2ad','9ec5df9b-2980-11ef-8e16-d517f37fa2ad'),(11,'3d61fa93-2986-11ef-8e16-d517f37fa2ad','9ec5f3b6-2980-11ef-8e16-d517f37fa2ad'),(11,'3d61fa93-2986-11ef-8e16-d517f37fa2ad','be9062f3-2982-11ef-8e16-d517f37fa2ad'),(11,'3d61fa93-2986-11ef-8e16-d517f37fa2ad','c5e732c1-2983-11ef-8e16-d517f37fa2ad'),(11,'3d61fa93-2986-11ef-8e16-d517f37fa2ad','dbaacc35-2982-11ef-8e16-d517f37fa2ad'),(11,'3d61fa93-2986-11ef-8e16-d517f37fa2ad','e09fbf20-2980-11ef-8e16-d517f37fa2ad'),(11,'3d61fa93-2986-11ef-8e16-d517f37fa2ad','e3ffe01f-2982-11ef-8e16-d517f37fa2ad'),(11,'9db6e18f-297e-11ef-8e16-d517f37fa2ad','8870875c-297e-11ef-8e16-d517f37fa2ad'),(11,'9db6e18f-297e-11ef-8e16-d517f37fa2ad','88709f91-297e-11ef-8e16-d517f37fa2ad'),(11,'9db6e18f-297e-11ef-8e16-d517f37fa2ad','9d433d29-297e-11ef-8e16-d517f37fa2ad'),(11,'eba48b0e-2a2f-11ef-8f1c-d8242c6fa8fd','8d1feec9-2a2f-11ef-8f1c-d8242c6fa8fd'),(11,'eba48b0e-2a2f-11ef-8f1c-d8242c6fa8fd','a1d4880f-2a2f-11ef-8f1c-d8242c6fa8fd'),(11,'fb782cec-2970-11ef-8e16-d517f37fa2ad','3fb8c8b6-2970-11ef-8e16-d517f37fa2ad'),(11,'fb782cec-2970-11ef-8e16-d517f37fa2ad','3fd6a6f4-2970-11ef-8e16-d517f37fa2ad'),(11,'fb782cec-2970-11ef-8e16-d517f37fa2ad','3fd6b050-2970-11ef-8e16-d517f37fa2ad'),(11,'fb782cec-2970-11ef-8e16-d517f37fa2ad','3fd6f8c6-2970-11ef-8e16-d517f37fa2ad'),(11,'fb782cec-2970-11ef-8e16-d517f37fa2ad','8f9ceac9-2970-11ef-8e16-d517f37fa2ad'),(11,'fb782cec-2970-11ef-8e16-d517f37fa2ad','e36ba3f8-2970-11ef-8e16-d517f37fa2ad'),(11,'fb782cec-2970-11ef-8e16-d517f37fa2ad','eb340ff4-296f-11ef-8e16-d517f37fa2ad'),(11,'fb782cec-2970-11ef-8e16-d517f37fa2ad','fb07e2bb-2970-11ef-8e16-d517f37fa2ad');
/*!40000 ALTER TABLE `SentAttachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SentMessage`
--

DROP TABLE IF EXISTS `SentMessage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SentMessage` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `discussionId` varchar(36) NOT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `answeredId` varchar(36) DEFAULT NULL COMMENT 'SentMessage uuid or ReceivedMessage originMessageId',
  `body` text DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `discussionId` (`discussionId`,`ownerId`),
  CONSTRAINT `SentMessage_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `SentMessage_ibfk_2` FOREIGN KEY (`discussionId`, `ownerId`) REFERENCES `Discussion` (`uuid`, `ownerId`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SentMessage`
--

LOCK TABLES `SentMessage` WRITE;
/*!40000 ALTER TABLE `SentMessage` DISABLE KEYS */;
INSERT INTO `SentMessage` VALUES ('0874bbc1-2403-11ef-8dde-d415e84cc4f5',2,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','Commande 3.1 [pc2]',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 3.1 [pc2]\",\"date\":\"2024-06-07T00:00:00\",\"orderUpdateTime\":\"2024-06-06T14:48:11\",\"orderId\":\"da3bcb3f-227c-11ef-8d76-d310d2ec2c14\"}','2024-06-06 14:48:11.000',NULL,'2024-06-06 14:48:11.000','2024-06-07 10:15:21.000','2024-06-07 12:15:21.000'),('0a523b51-6b59-46bf-a2c8-6f51b772db13',2,'8e7e9088-2733-11ef-8e16-d517f37fa1ab','Order 6.3 [pc2]',NULL,'API_META={\"type\":\"order\",\"key\":\"validated\",\"title\":\"Order 6.3 [pc2]\",\"date\":\"2024-06-21T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-19T17:07:23+02:00\",\"orderId\":\"22749c4a-2e42-11ef-8deb-d515ea58f6cb\"}','2024-06-19 17:07:23.000',NULL,'2024-06-19 17:07:23.000','2024-06-19 15:07:23.000','2024-06-19 17:07:23.000'),('0d22759d-225e-11ef-8f1f-d8242c71b430',2,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','Commande 1.1',NULL,'envoi d\'une capture supp','2024-06-04 12:34:41.000',NULL,'2024-06-04 12:34:41.000','2024-06-04 10:34:42.000','2024-06-04 12:34:42.000'),('0db3aecb-2cbf-11ef-8e27-d518f78fe3c8',2,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','0db3aecb-2cbf-11ef-8e27-d518f78fe3c8',NULL,'test nvelle discussion\n','2024-06-17 17:34:15.000',NULL,'2024-06-17 17:34:15.000','2024-06-20 09:26:29.000','2024-06-20 11:26:29.000'),('0eb44d73-23ea-11ef-8f8c-d92a43d45e5a',2,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','Commande 2.2 [pc1]',NULL,'bien receptionné sur ihm env1 mais obligation de valider la cmde via le web. réponse faite via le filtre de discussion activé','2024-06-06 11:49:24.000',NULL,'2024-06-06 11:49:24.000','2024-06-06 09:49:27.000','2024-06-06 11:49:27.000'),('0f3e4980-225d-11ef-8f1f-d8242c71b430',2,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','Commande 1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.1\",\"date\":\"2024-06-05T00:00:00\",\"orderUpdateTime\":\"2024-06-04T12:27:35\",\"orderId\":\"e3879e0c-225a-11ef-8f1f-d8242c71b430\"}','2024-06-04 12:27:35.000',NULL,'2024-06-04 12:27:35.000','2024-06-04 10:27:41.000','2024-06-04 12:27:41.000'),('10351862-fb40-4aa9-a4ab-7afe4dba87b9',3,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','Commande 1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"edited\",\"title\":\"Commande 1.1\",\"date\":\"2024-06-06T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-04T12:29:24+02:00\",\"orderId\":\"e3879e0c-225a-11ef-8f1f-d8242c71b430\"}','2024-06-04 12:29:24.000',NULL,'2024-06-04 12:29:24.000','2024-06-04 10:29:25.000','2024-06-04 12:29:25.000'),('14ca16db-2a2f-11ef-8f1c-d8242c6fa8fd',11,'3d61afe1-2986-11ef-8e16-d517f37fa2ad','Ordini 3.2',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Ordini 3.2\",\"date\":\"2024-06-15T00:00:00\",\"orderUpdateTime\":\"2024-06-14T11:18:38\",\"orderId\":\"8d0cbb85-2a29-11ef-8f1c-d8242c6fa8fd\"}','2024-06-14 11:18:38.000',NULL,'2024-06-14 11:18:38.000','2024-06-20 09:26:29.000','2024-06-20 11:26:29.000'),('1a9029b2-296b-11ef-8e16-d517f37fa2ad',11,'1a8fdf3a-296b-11ef-8e16-d517f37fa2ad','Ordini 5.1',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Ordini 5.1\",\"date\":\"2024-06-14T00:00:00\",\"orderUpdateTime\":\"2024-06-13T11:55:45\",\"orderId\":\"470ab6fc-2963-11ef-8e16-d517f37fa2ad\"}','2024-06-13 11:55:45.000',NULL,'2024-06-13 11:55:45.000','2024-06-13 13:38:48.000','2024-06-13 15:38:48.000'),('1ff029c0-b4a6-4bc9-aef0-0d1d79f41259',5,'be273be5-289d-11ef-8e16-d517f37fa2ad','Commande 1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"cancelled\",\"title\":\"Commande 1.1\",\"date\":\"2024-06-28T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-12T11:40:41+02:00\",\"orderId\":\"0d191b14-289a-11ef-8e16-d517f37fa2ad\"}','2024-06-12 11:40:42.000',NULL,'2024-06-12 11:40:42.000','2024-06-12 09:40:42.000','2024-06-12 11:40:42.000'),('20a09331-2984-11ef-8e16-d517f37fa2ad',11,'1a8fdf3a-296b-11ef-8e16-d517f37fa2ad','Ordini 5.5',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Ordini 5.5\",\"date\":\"2024-06-14T00:00:00\",\"orderUpdateTime\":\"2024-06-13T14:54:53\",\"orderId\":\"08f4c372-2980-11ef-8e16-d517f37fa2ad\"}','2024-06-13 14:54:53.000',NULL,'2024-06-13 14:54:53.000','2024-06-13 13:38:48.000','2024-06-13 15:38:48.000'),('2192fe1a-0490-4bd9-8f2d-363155abc9a2',3,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','Réponse depuis le web',NULL,'bla bla via tchat web de la cmde 2.3','2024-06-06 14:23:36.000',NULL,'2024-06-06 14:23:36.000','2024-06-06 12:23:37.000','2024-06-06 14:23:37.000'),('24b7ab8b-28a0-11ef-8e16-d517f37fa2ad',5,'be273be5-289d-11ef-8e16-d517f37fa2ad','Commande 1.2',NULL,'API_META={\"type\":\"order\",\"key\":\"resent\",\"title\":\"Commande 1.2\",\"date\":\"2024-06-29T00:00:00\",\"orderUpdateTime\":\"2024-06-12T11:42:54\",\"orderId\":\"0187211b-28a0-11ef-8e16-d517f37fa2ad\"}','2024-06-12 11:42:54.000',NULL,'2024-06-12 11:42:54.000','2024-06-12 09:42:58.000','2024-06-12 11:42:58.000'),('2602522e-2e4c-11ef-8deb-d515ea58f6cb',2,'8e7e9088-2733-11ef-8e16-d517f37fa1ab','Order 17.1 [pc2]',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Order 17.1 [pc2]\",\"date\":\"2024-06-20T00:00:00\",\"orderUpdateTime\":\"2024-06-19T16:56:46\",\"orderId\":\"15fd7f91-2e4b-11ef-8deb-d515ea58f6cb\"}','2024-06-19 16:56:46.000',NULL,'2024-06-19 16:56:46.000','2024-06-19 14:58:04.000','2024-06-19 16:58:04.000'),('2aa35b06-2988-11ef-8e16-d517f37fa2ad',11,'3d61afe1-2986-11ef-8e16-d517f37fa2ad','Ordini 4.1',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Ordini 4.1\",\"date\":\"2024-06-23T00:00:00\",\"orderUpdateTime\":\"2024-06-13T15:23:47\",\"orderId\":\"4ba706eb-2987-11ef-8e16-d517f37fa2ad\"}','2024-06-13 15:23:47.000',NULL,'2024-06-13 15:23:47.000','2024-06-13 13:23:53.000','2024-06-13 15:23:53.000'),('2c4ce7cf-6875-4a7e-99de-470ca57d37cf',5,'8e7e9088-2733-11ef-8e16-d517f37fa1ab','Réponse depuis le web',NULL,'ok bien reçu, verif web','2024-06-10 16:13:55.000',NULL,'2024-06-10 16:13:55.000','2024-06-10 14:13:56.000','2024-06-10 16:13:56.000'),('2d654e78-2272-11ef-8d76-d310d2ec2c14',2,'550eb27a-226b-11ef-8f1f-d8242c71b430','Commande 2.1 [pc2]',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 2.1 [pc2]\",\"date\":\"2024-06-05T00:00:00\",\"orderUpdateTime\":\"2024-06-04T14:58:45\",\"orderId\":\"afad1449-2271-11ef-8d76-d310d2ec2c14\"}','2024-06-04 14:58:45.000',NULL,'2024-06-04 14:58:45.000','2024-06-12 12:56:58.000','2024-06-12 14:56:58.000'),('2f604f05-d11c-43d9-bdf9-d43e0306dfda',2,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','Commande 1.1',NULL,'envoi d\'un message via web (env1.ci...)','2024-06-06 11:09:19.000',NULL,'2024-06-06 11:09:19.000','2024-06-06 09:09:22.000','2024-06-06 11:09:22.000'),('30f0f8e5-2279-11ef-8d76-d310d2ec2c14',2,'550eb27a-226b-11ef-8f1f-d8242c71b430','Commande 1.2 [pc2]',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.2 [pc2]\",\"date\":\"2024-06-05T00:00:00\",\"orderUpdateTime\":\"2024-06-04T15:48:57\",\"orderId\":\"f26746c9-2272-11ef-8d76-d310d2ec2c14\"}','2024-06-04 15:48:57.000',NULL,'2024-06-04 15:48:57.000','2024-06-12 12:56:58.000','2024-06-12 14:56:58.000'),('33305035-2e42-11ef-8deb-d515ea58f6cb',2,'8e7e9088-2733-11ef-8e16-d517f37fa1ab','Order 6.3 [pc2]',NULL,'API_META={\"type\":\"order\",\"key\":\"resent\",\"title\":\"Order 6.3 [pc2]\",\"date\":\"2024-06-23T00:00:00\",\"orderUpdateTime\":\"2024-06-19T15:45:33\",\"orderId\":\"22749c4a-2e42-11ef-8deb-d515ea58f6cb\"}','2024-06-19 15:45:33.000',NULL,'2024-06-19 15:45:33.000','2024-06-19 14:58:04.000','2024-06-19 16:58:04.000'),('33e44dc1-23e9-11ef-8dde-d415e84cc4f5',3,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','Commande 2.2 [pc1]',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 2.2 [pc1]\",\"date\":\"2024-06-07T00:00:00\",\"orderUpdateTime\":\"2024-06-06T11:43:17\",\"orderId\":\"0bd68b18-23e9-11ef-8dde-d415e84cc4f5\"}','2024-06-06 11:43:17.000',NULL,'2024-06-06 11:43:17.000','2024-06-06 09:47:52.000','2024-06-06 11:47:52.000'),('35f75e0f-a626-47c5-9d5b-946f217739af',2,'1a8fdf3a-296b-11ef-8e16-d517f37fa2ad','Ordini 5.5',NULL,'API_META={\"type\":\"order\",\"key\":\"cancelled\",\"title\":\"Ordini 5.5\",\"date\":\"2024-06-14T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-13T15:06:45+02:00\",\"orderId\":\"08f4c372-2980-11ef-8e16-d517f37fa2ad\"}','2024-06-13 15:06:45.000',NULL,'2024-06-13 15:06:45.000','2024-06-13 13:06:47.000','2024-06-13 15:06:47.000'),('3d61fa93-2986-11ef-8e16-d517f37fa2ad',11,'3d61afe1-2986-11ef-8e16-d517f37fa2ad','Ordini 5.5',NULL,'API_META={\"type\":\"order\",\"key\":\"resent\",\"title\":\"Ordini 5.5\",\"date\":\"2024-06-14T00:00:00\",\"orderUpdateTime\":\"2024-06-13T15:10:00\",\"orderId\":\"d2cfcd57-2985-11ef-8e16-d517f37fa2ad\"}','2024-06-13 15:10:00.000',NULL,'2024-06-13 15:10:00.000','2024-06-13 13:12:43.000','2024-06-13 15:12:43.000'),('4c1489bb-54c8-4aa3-8017-d140fe974c2f',2,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','Commande 1.1',NULL,'bla bla','2024-06-06 12:01:39.000',NULL,'2024-06-06 12:01:39.000','2024-06-06 10:01:41.000','2024-06-06 12:01:41.000'),('4db93275-aa1c-442f-b2b5-af6c4514bd24',2,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','Commande 1.1',NULL,'test envoi de la page discussion sur le web','2024-06-06 11:57:21.000',NULL,'2024-06-06 11:57:21.000','2024-06-06 09:57:25.000','2024-06-06 11:57:25.000'),('506b80e8-8e38-4c1d-aaaa-3a424481b4ca',2,'82a44e97-2ee8-11ef-8dc9-d414e3397395','Order 1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"cancelled\",\"title\":\"Order 1.1\",\"date\":\"2024-06-21T02:00:00+02:00\",\"orderUpdateTime\":\"2024-06-20T11:37:05+02:00\",\"orderId\":\"9a8dd9c0-2edd-11ef-8de3-d515e950d747\"}','2024-06-20 11:37:05.000',NULL,'2024-06-20 11:37:05.000','2024-06-20 09:37:06.000','2024-06-20 11:37:06.000'),('550f3fc1-226b-11ef-8f1f-d8242c71b430',2,'550eb27a-226b-11ef-8f1f-d8242c71b430','Commande 1.2',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.2\",\"date\":\"2024-06-05T00:00:00\",\"orderUpdateTime\":\"2024-06-04T14:09:45\",\"orderId\":\"7585401e-2266-11ef-8f1f-d8242c71b430\"}','2024-06-04 14:09:45.000',NULL,'2024-06-04 14:09:45.000','2024-06-04 12:10:11.000','2024-06-04 14:10:11.000'),('56f0c51f-23ed-11ef-8dde-d415e84cc4f5',3,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','Commande 2.3 [pc1]',NULL,'bla bla\n','2024-06-06 12:12:54.000',NULL,'2024-06-06 12:12:54.000','2024-06-06 10:16:25.000','2024-06-06 12:16:25.000'),('5701b18b-225e-11ef-8d76-d310d2ec2c14',3,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','5701b18b-225e-11ef-8d76-d310d2ec2c14',NULL,'bla bla bla','2024-06-04 12:36:45.000',NULL,'2024-06-04 12:36:45.000','2024-06-04 10:36:47.000','2024-06-04 12:36:47.000'),('59cfafae-e9ce-4a51-be20-09e9860da4b4',3,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','Réponse depuis le web',NULL,'bla bla via page discussion du web','2024-06-06 14:22:35.000',NULL,'2024-06-06 14:22:35.000','2024-06-06 12:22:37.000','2024-06-06 14:22:37.000'),('5c02d3d5-23e4-11ef-8dde-d415e84cc4f5',2,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','5c02d3d5-23e4-11ef-8dde-d415e84cc4f5',NULL,'envoi d\'un message via env2','2024-06-06 11:08:37.000',NULL,'2024-06-06 11:08:37.000','2024-06-06 09:08:38.000','2024-06-06 11:08:38.000'),('5c613afb-82ec-442d-8d9c-769d176f624d',11,'1a8fdf3a-296b-11ef-8e16-d517f37fa2ad','Ordini 5.1',NULL,'API_META={\"type\":\"order\",\"key\":\"validated\",\"title\":\"Ordini 5.1\",\"date\":\"2024-06-16T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-13T15:14:29+02:00\",\"orderId\":\"470ab6fc-2963-11ef-8e16-d517f37fa2ad\"}','2024-06-13 15:14:30.000',NULL,'2024-06-13 15:14:30.000','2024-06-13 13:38:48.000','2024-06-13 15:38:48.000'),('5c87a655-2e3c-11ef-8deb-d515ea58f6cb',2,'8e7e9088-2733-11ef-8e16-d517f37fa1ab','Order 16.2 [pc2]',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Order 16.2 [pc2]\",\"date\":\"2024-06-20T00:00:00\",\"orderUpdateTime\":\"2024-06-19T15:03:46\",\"orderId\":\"da257486-2e3a-11ef-8deb-d515ea58f6cb\"}','2024-06-19 15:03:46.000',NULL,'2024-06-19 15:03:46.000','2024-06-19 14:58:04.000','2024-06-19 16:58:04.000'),('62d4940c-225e-11ef-8d76-d310d2ec2c14',3,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','Commande 1.1','0d22759d-225e-11ef-8f1f-d8242c71b430','bla bla bla','2024-06-04 12:37:05.214',NULL,'2024-06-04 12:37:05.215','2024-06-04 10:37:05.215','2024-06-04 12:37:05.230'),('673530bc-2272-11ef-8d76-d310d2ec2c14',2,'550eb27a-226b-11ef-8f1f-d8242c71b430','Commande 1.1 [pc2]',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.1 [pc2]\",\"date\":\"2024-06-05T00:00:00\",\"orderUpdateTime\":\"2024-06-04T15:00:22\",\"orderId\":\"62bf4a87-226c-11ef-8d76-d310d2ec2c14\"}','2024-06-04 15:00:22.000',NULL,'2024-06-04 15:00:22.000','2024-06-12 12:56:58.000','2024-06-12 14:56:58.000'),('6de76022-233f-11ef-8f93-d92a45da78c9',2,'550eb27a-226b-11ef-8f1f-d8242c71b430','Commande 1.5 [pc1]',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.5 [pc1]\",\"date\":\"2024-06-06T00:00:00\",\"orderUpdateTime\":\"2024-06-05T15:28:00\",\"orderId\":\"b19eef4f-2336-11ef-8f93-d92a45da78c9\"}','2024-06-05 15:28:00.000',NULL,'2024-06-05 15:28:00.000','2024-06-12 12:56:58.000','2024-06-12 14:56:58.000'),('6fb37b74-28a0-11ef-8e16-d517f37fa2ad',5,'be273be5-289d-11ef-8e16-d517f37fa2ad','Commande 1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"resent\",\"title\":\"Commande 1.1\",\"date\":\"2024-06-30T00:00:00\",\"orderUpdateTime\":\"2024-06-12T11:45:00\",\"orderId\":\"e387023b-289f-11ef-8e16-d517f37fa2ad\"}','2024-06-12 11:45:00.000',NULL,'2024-06-12 11:45:00.000','2024-06-12 09:45:03.000','2024-06-12 11:45:03.000'),('75433112-226f-11ef-8f1f-d8242c71b430',2,'550eb27a-226b-11ef-8f1f-d8242c71b430','Commande 1.3 [pc1]',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.3 [pc1]\",\"date\":\"2024-06-05T00:00:00\",\"orderUpdateTime\":\"2024-06-04T14:39:17\",\"orderId\":\"f6d25816-226e-11ef-8f1f-d8242c71b430\"}','2024-06-04 14:39:17.000',NULL,'2024-06-04 14:39:17.000','2024-06-12 12:56:58.000','2024-06-12 14:56:58.000'),('792e2a4b-f301-41c9-893e-619fc4a73281',2,'1a8fdf3a-296b-11ef-8e16-d517f37fa2ad','Ordini 5.2',NULL,'API_META={\"type\":\"order\",\"key\":\"edited\",\"title\":\"Ordini 5.2\",\"date\":\"2024-06-16T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-13T15:15:10+02:00\",\"orderId\":\"cc4112f9-297d-11ef-8e16-d517f37fa2ad\"}','2024-06-13 15:15:10.000',NULL,'2024-06-13 15:15:10.000','2024-06-13 13:15:10.000','2024-06-13 15:15:10.000'),('7c7133c4-869b-4ecf-be8c-a7ba25b96324',2,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','Commande 1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"validated\",\"title\":\"Commande 1.1\",\"date\":\"2024-06-06T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-04T12:29:32+02:00\",\"orderId\":\"e3879e0c-225a-11ef-8f1f-d8242c71b430\"}','2024-06-04 12:29:32.000',NULL,'2024-06-04 12:29:32.000','2024-06-04 10:29:34.000','2024-06-04 12:29:34.000'),('806e92df-2986-11ef-8e16-d517f37fa2ad',11,'3d61afe1-2986-11ef-8e16-d517f37fa2ad','Ordini 5.5',NULL,'Salve, \navete bisogno di altri documenti per questo caso?','2024-06-13 15:11:52.000',NULL,'2024-06-13 15:11:52.000','2024-06-13 13:12:43.000','2024-06-13 15:12:43.000'),('88fb6e51-28a0-11ef-8e16-d517f37fa2ad',5,'88f9012b-28a0-11ef-8e16-d517f37fa2ad','88fb6e51-28a0-11ef-8e16-d517f37fa2ad',NULL,'#','2024-06-12 11:45:42.000',NULL,'2024-06-12 11:45:42.000','2024-06-12 09:45:44.000','2024-06-12 11:45:44.000'),('89d9cfe1-7384-4ce3-ae5e-89be13d7ae9d',3,'3d61afe1-2986-11ef-8e16-d517f37fa2ad','Réponse depuis le web',NULL,'no, va tutto bene, grazie ','2024-06-13 15:13:00.000',NULL,'2024-06-13 15:13:00.000','2024-06-13 13:13:00.000','2024-06-13 15:13:00.000'),('8e81ec28-2733-11ef-8e16-d517f37fa1ab',2,'8e7e9088-2733-11ef-8e16-d517f37fa1ab','8e81ec28-2733-11ef-8e16-d517f37fa1ab',NULL,'1er message d\'envoi sans fichier','2024-06-10 16:13:05.000',NULL,'2024-06-10 16:13:05.000','2024-06-10 14:13:38.000','2024-06-10 16:13:38.000'),('8e9d97c9-2738-11ef-8e16-d517f37fa1ab',2,'8e7e9088-2733-11ef-8e16-d517f37fa1ab','Commande 2.2 [pc2]',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 2.2 [pc2]\",\"date\":\"2024-06-11T00:00:00\",\"orderUpdateTime\":\"2024-06-10T16:48:53\",\"orderId\":\"1cba063b-271f-11ef-8e16-d517f37fa1ab\"}','2024-06-10 16:48:53.000',NULL,'2024-06-10 16:48:53.000','2024-06-12 07:58:49.000','2024-06-12 09:58:49.000'),('91a29730-2e43-11ef-8deb-d515ea58f6cb',2,'8e7e9088-2733-11ef-8e16-d517f37fa1ab','Order 6.5 [pc2]',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Order 6.5 [pc2]\",\"date\":\"2024-06-21T00:00:00\",\"orderUpdateTime\":\"2024-06-19T15:55:21\",\"orderId\":\"164af3dc-2e43-11ef-8deb-d515ea58f6cb\"}','2024-06-19 15:55:21.000',NULL,'2024-06-19 15:55:21.000','2024-06-19 14:58:04.000','2024-06-19 16:58:04.000'),('96378603-23e4-11ef-8f8c-d92a43d45e5a',3,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','96378603-23e4-11ef-8f8c-d92a43d45e5a',NULL,'bla bla','2024-06-06 11:10:15.000',NULL,'2024-06-06 11:10:15.000','2024-06-06 09:24:48.000','2024-06-06 11:24:48.000'),('9ac047ea-23eb-11ef-8dde-d415e84cc4f5',3,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','Commande 2.3 [pc1]',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 2.3 [pc1]\",\"date\":\"2024-06-07T00:00:00\",\"orderUpdateTime\":\"2024-06-06T12:00:29\",\"orderId\":\"8d24e986-23eb-11ef-8dde-d415e84cc4f5\"}','2024-06-06 12:00:29.000',NULL,'2024-06-06 12:00:29.000','2024-06-06 10:01:33.000','2024-06-06 12:01:33.000'),('9c944f7a-27ce-11ef-8e37-d519fa9d22d2',2,'8e7e9088-2733-11ef-8e16-d517f37fa1ab','Commande 6.1 [pc2]',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 6.1 [pc2]\",\"date\":\"2024-06-12T00:00:00\",\"orderUpdateTime\":\"2024-06-11T10:43:01\",\"orderId\":\"be9f95d2-2735-11ef-8e16-d517f37fa1ab\"}','2024-06-11 10:43:01.000',NULL,'2024-06-11 10:43:01.000','2024-06-12 07:58:49.000','2024-06-12 09:58:49.000'),('9db6e18f-297e-11ef-8e16-d517f37fa2ad',11,'1a8fdf3a-296b-11ef-8e16-d517f37fa2ad','Ordini 5.2',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Ordini 5.2\",\"date\":\"2024-06-15T00:00:00\",\"orderUpdateTime\":\"2024-06-13T14:15:26\",\"orderId\":\"cc4112f9-297d-11ef-8e16-d517f37fa2ad\"}','2024-06-13 14:15:26.000',NULL,'2024-06-13 14:15:26.000','2024-06-13 13:38:48.000','2024-06-13 15:38:48.000'),('9e44f2e9-23e4-11ef-8f8c-d92a43d45e5a',3,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','Commande 1.1','2f604f05-d11c-43d9-bdf9-d43e0306dfda','bla bla','2024-06-06 11:10:28.000',NULL,'2024-06-06 11:10:28.000','2024-06-06 09:24:48.000','2024-06-06 11:24:48.000'),('a7736a88-289f-11ef-8e16-d517f37fa2ad',5,'be273be5-289d-11ef-8e16-d517f37fa2ad','Commande 1.2',NULL,'API_META={\"type\":\"order\",\"key\":\"resent\",\"title\":\"Commande 1.2\",\"date\":\"2024-06-14T00:00:00\",\"orderUpdateTime\":\"2024-06-12T11:39:24\",\"orderId\":\"ddb0571c-289e-11ef-8e16-d517f37fa2ad\"}','2024-06-12 11:39:24.000',NULL,'2024-06-12 11:39:24.000','2024-06-12 09:39:27.000','2024-06-12 11:39:27.000'),('ae66af70-27ca-11ef-8e37-d519fa9d22d2',2,'ae662f01-27ca-11ef-8e37-d519fa9d22d2','Commande 7.2 [pc2]',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 7.2 [pc2]\",\"date\":\"2024-06-12T00:00:00\",\"orderUpdateTime\":\"2024-06-11T10:14:53\",\"orderId\":\"bed2bb1e-273c-11ef-8e16-d517f37fa1ab\"}','2024-06-11 10:14:53.000',NULL,'2024-06-11 10:14:53.000','2024-06-11 08:15:09.000','2024-06-11 10:15:09.000'),('b1d82b93-226b-11ef-8d76-d310d2ec2c14',2,'550eb27a-226b-11ef-8f1f-d8242c71b430','Commande 1.2','79e4936c-226b-11ef-8f1f-d8242c71b430','réponse faite d\'env2 avt recup des données','2024-06-04 14:12:21.000',NULL,'2024-06-04 14:12:21.000','2024-06-12 12:56:58.000','2024-06-12 14:56:58.000'),('b44b19e6-8bfe-477e-bdc3-5fda6f4b7bd3',3,'3d61afe1-2986-11ef-8e16-d517f37fa2ad','Ordini 5.5',NULL,'API_META={\"type\":\"order\",\"key\":\"validated\",\"title\":\"Ordini 5.5\",\"date\":\"2024-06-14T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-13T15:10:35+02:00\",\"orderId\":\"d2cfcd57-2985-11ef-8e16-d517f37fa2ad\"}','2024-06-13 15:10:35.000',NULL,'2024-06-13 15:10:35.000','2024-06-13 13:10:37.000','2024-06-13 15:10:37.000'),('b60e672c-27c9-11ef-8e37-d519fa9d22d2',2,'550eb27a-226b-11ef-8f1f-d8242c71b430','Commande 5.1',NULL,'ok, message après validation, commande qui va être supprimée via la suppression du patient','2024-06-11 10:07:56.000',NULL,'2024-06-11 10:07:56.000','2024-06-12 12:56:58.000','2024-06-12 14:56:58.000'),('b7df2f87-2e3c-11ef-8deb-d515ea58f6cb',2,'8e7e9088-2733-11ef-8e16-d517f37fa1ab','Order 16.2 [pc2]','6c6ba4cd-912b-4d4d-9f94-25d490087c3e','bla bla bla','2024-06-19 15:06:19.000',NULL,'2024-06-19 15:06:19.000','2024-06-19 14:58:04.000','2024-06-19 16:58:04.000'),('b9efc6fe-27ca-11ef-8e37-d519fa9d22d2',2,'ae662f01-27ca-11ef-8e37-d519fa9d22d2','Commande 7.2',NULL,'commande que je vais supprimer via la fiche patient','2024-06-11 10:15:12.000',NULL,'2024-06-11 10:15:12.000','2024-06-11 08:15:13.000','2024-06-11 10:15:13.000'),('bb71575b-5b05-40de-9ab4-b7779ee0cf94',2,'82a44e97-2ee8-11ef-8dc9-d414e3397395','Order 1.2',NULL,'API_META={\"type\":\"order\",\"key\":\"edited\",\"title\":\"Order 1.2\",\"date\":\"2024-06-24T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-20T12:15:58+02:00\",\"orderId\":\"ab653d64-2edd-11ef-8de3-d515e950d747\"}','2024-06-20 12:15:58.000',NULL,'2024-06-20 12:15:58.000','2024-06-20 10:15:58.000','2024-06-20 12:15:58.000'),('bd09e4f5-a92e-41e6-8106-49d6eab12126',3,'b8d62e1b-2ee8-11ef-8dc9-d414e3397395','Order 1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"validated\",\"title\":\"Order 1.1\",\"date\":\"2024-06-21T02:00:00+02:00\",\"orderUpdateTime\":\"2024-06-20T11:41:25+02:00\",\"orderId\":\"afc82063-2ee8-11ef-8dc9-d414e3397395\"}','2024-06-20 11:41:25.000',NULL,'2024-06-20 11:41:25.000','2024-06-20 09:41:26.000','2024-06-20 11:41:26.000'),('be27ff6b-289d-11ef-8e16-d517f37fa2ad',5,'be273be5-289d-11ef-8e16-d517f37fa2ad','Commande 1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.1\",\"date\":\"2024-06-22T00:00:00\",\"orderUpdateTime\":\"2024-06-12T11:25:43\",\"orderId\":\"0d191b14-289a-11ef-8e16-d517f37fa2ad\"}','2024-06-12 11:25:43.000',NULL,'2024-06-12 11:25:43.000','2024-06-12 09:25:47.000','2024-06-12 11:25:47.000'),('be91b6bf-2733-11ef-8e16-d517f37fa1ab',2,'8e7e9088-2733-11ef-8e16-d517f37fa1ab','be91b6bf-2733-11ef-8e16-d517f37fa1ab',NULL,'avec fichier','2024-06-10 16:14:26.000',NULL,'2024-06-10 16:14:26.000','2024-06-10 14:14:30.000','2024-06-10 16:14:30.000'),('c0651022-2cc0-11ef-8e27-d518f78fe3c8',2,'ae662f01-27ca-11ef-8e37-d519fa9d22d2','c0651022-2cc0-11ef-8e27-d518f78fe3c8',NULL,'sans sujet','2024-06-17 17:46:24.000',NULL,'2024-06-17 17:46:24.000','2024-06-17 15:46:25.000','2024-06-17 17:46:25.000'),('c13b3b06-ddd8-4a9e-a735-9592cf516fda',5,'8e7e9088-2733-11ef-8e16-d517f37fa1ab','Réponse depuis le web',NULL,'ok via web','2024-06-10 16:15:20.000',NULL,'2024-06-10 16:15:20.000','2024-06-10 14:15:22.000','2024-06-10 16:15:22.000'),('c1a443f6-289e-11ef-8e16-d517f37fa2ad',5,'be273be5-289d-11ef-8e16-d517f37fa2ad','Commande 1.2',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.2\",\"date\":\"2024-06-14T00:00:00\",\"orderUpdateTime\":\"2024-06-12T11:32:59\",\"orderId\":\"6282c146-289b-11ef-8e16-d517f37fa2ad\"}','2024-06-12 11:32:59.000',NULL,'2024-06-12 11:32:59.000','2024-06-12 09:33:01.000','2024-06-12 11:33:01.000'),('c719b05f-2cc0-11ef-8e27-d518f78fe3c8',2,'ae662f01-27ca-11ef-8e37-d519fa9d22d2','c719b05f-2cc0-11ef-8e27-d518f78fe3c8',NULL,'bla bla','2024-06-17 17:46:35.000',NULL,'2024-06-17 17:46:35.000','2024-06-17 15:46:39.000','2024-06-17 17:46:39.000'),('ca7695c9-2e41-11ef-8deb-d515ea58f6cb',2,'8e7e9088-2733-11ef-8e16-d517f37fa1ab','Order 6.3 [pc2]',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Order 6.3 [pc2]\",\"date\":\"2024-06-20T00:00:00\",\"orderUpdateTime\":\"2024-06-19T15:42:38\",\"orderId\":\"859f5fed-2e40-11ef-8deb-d515ea58f6cb\"}','2024-06-19 15:42:38.000',NULL,'2024-06-19 15:42:38.000','2024-06-19 14:58:04.000','2024-06-19 16:58:04.000'),('d387710c-27c8-11ef-8e37-d519fa9d22d2',2,'550eb27a-226b-11ef-8f1f-d8242c71b430','Commande 5.1 [pc2]',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 5.1 [pc2]\",\"date\":\"2024-06-12T00:00:00\",\"orderUpdateTime\":\"2024-06-11T10:01:36\",\"orderId\":\"8c15b440-2735-11ef-8e16-d517f37fa1ab\"}','2024-06-11 10:01:36.000',NULL,'2024-06-11 10:01:36.000','2024-06-12 12:56:58.000','2024-06-12 14:56:58.000'),('d61618a0-2279-11ef-8d76-d310d2ec2c14',2,'550eb27a-226b-11ef-8f1f-d8242c71b430','Commande 1.3 [pc2]',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.3 [pc2]\",\"date\":\"2024-06-05T00:00:00\",\"orderUpdateTime\":\"2024-06-04T15:53:34\",\"orderId\":\"a4229655-2279-11ef-8d76-d310d2ec2c14\"}','2024-06-04 15:53:34.000',NULL,'2024-06-04 15:53:34.000','2024-06-12 12:56:58.000','2024-06-12 14:56:58.000'),('d8a6277b-2e42-11ef-8deb-d515ea58f6cb',2,'8e7e9088-2733-11ef-8e16-d517f37fa1ab','Order 6.4 [pc2]',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Order 6.4 [pc2]\",\"date\":\"2024-06-20T00:00:00\",\"orderUpdateTime\":\"2024-06-19T15:50:11\",\"orderId\":\"68b5196a-2e42-11ef-8deb-d515ea58f6cb\"}','2024-06-19 15:50:11.000',NULL,'2024-06-19 15:50:11.000','2024-06-19 14:58:04.000','2024-06-19 16:58:04.000'),('ddab8ff1-23e2-11ef-8f8c-d92a43d45e5a',3,'ddab36aa-23e2-11ef-8f8c-d92a43d45e5a','ddab8ff1-23e2-11ef-8f8c-d92a43d45e5a',NULL,'invitation envoyée sous env2, mail d\'invitation pour env2.ci.wow-scan.pro (et acceptée); ce message envoyée sous env1','2024-06-06 10:57:56.000',NULL,'2024-06-06 10:57:56.000','2024-06-06 08:58:06.000','2024-06-06 10:58:06.000'),('de9207cc-7b94-4f23-8d11-6fb49d3bd237',2,'550eb27a-226b-11ef-8f1f-d8242c71b430','Commande 1.3',NULL,'API_META={\"type\":\"order\",\"key\":\"edited\",\"title\":\"Commande 1.3\",\"date\":\"2024-06-12T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-10T16:16:46+02:00\",\"orderId\":\"a4229655-2279-11ef-8d76-d310d2ec2c14\"}','2024-06-10 16:16:47.000',NULL,'2024-06-10 16:16:47.000','2024-06-12 12:56:58.000','2024-06-12 14:56:58.000'),('e03dc949-f924-4e48-a5fd-e8273bbf6e07',2,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','Commande 2.2',NULL,'API_META={\"type\":\"order\",\"key\":\"edited\",\"title\":\"Commande 2.2\",\"date\":\"2024-06-08T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-06T11:58:24+02:00\",\"orderId\":\"0bd68b18-23e9-11ef-8dde-d415e84cc4f5\"}','2024-06-06 11:58:24.000',NULL,'2024-06-06 11:58:24.000','2024-06-06 09:58:24.000','2024-06-06 11:58:24.000'),('e5fbd2ab-2e4d-11ef-8deb-d515ea58f6cb',2,'8e7e9088-2733-11ef-8e16-d517f37fa1ab','Order 17.3 [pc2]',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Order 17.3 [pc2]\",\"date\":\"2024-06-20T00:00:00\",\"orderUpdateTime\":\"2024-06-19T17:09:18\",\"orderId\":\"de096a3e-2e4d-11ef-8deb-d515ea58f6cb\"}','2024-06-19 17:09:18.000',NULL,'2024-06-19 17:09:18.000','2024-06-19 15:09:20.000','2024-06-19 17:09:20.000'),('eba48b0e-2a2f-11ef-8f1c-d8242c6fa8fd',11,'3d61afe1-2986-11ef-8e16-d517f37fa2ad','Ordini 3.2',NULL,'misure aggiuntive','2024-06-14 11:24:39.000',NULL,'2024-06-14 11:24:39.000','2024-06-20 09:26:29.000','2024-06-20 11:26:29.000'),('ec59b1ff-79e7-49aa-9888-5b1e722d3d80',2,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','Commande 2.3',NULL,'API_META={\"type\":\"order\",\"key\":\"validated\",\"title\":\"Commande 2.3\",\"date\":\"2024-06-07T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-06T12:02:16+02:00\",\"orderId\":\"8d24e986-23eb-11ef-8dde-d415e84cc4f5\"}','2024-06-06 12:02:16.000',NULL,'2024-06-06 12:02:16.000','2024-06-06 10:02:17.000','2024-06-06 12:02:17.000'),('ee074334-fd31-4f09-a527-2f1a41048adb',2,'1a8fdf3a-296b-11ef-8e16-d517f37fa2ad','Ordini 5.1',NULL,'API_META={\"type\":\"order\",\"key\":\"edited\",\"title\":\"Ordini 5.1\",\"date\":\"2024-06-16T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-13T15:14:17+02:00\",\"orderId\":\"470ab6fc-2963-11ef-8e16-d517f37fa2ad\"}','2024-06-13 15:14:17.000',NULL,'2024-06-13 15:14:17.000','2024-06-13 13:14:19.000','2024-06-13 15:14:19.000'),('ef1364ca-2e41-11ef-8deb-d515ea58f6cb',2,'8e7e9088-2733-11ef-8e16-d517f37fa1ab','Order 6.3 [pc2]',NULL,'API_META={\"type\":\"order\",\"key\":\"resent\",\"title\":\"Order 6.3 [pc2]\",\"date\":\"2024-06-23T00:00:00\",\"orderUpdateTime\":\"2024-06-19T15:43:39\",\"orderId\":\"ea2350dd-2e41-11ef-8deb-d515ea58f6cb\"}','2024-06-19 15:43:39.000',NULL,'2024-06-19 15:43:39.000','2024-06-19 14:58:04.000','2024-06-19 16:58:04.000'),('f084f705-5f7b-4dac-af14-81f4808be17e',2,'1a8fdf3a-296b-11ef-8e16-d517f37fa2ad','Ordini 1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"cancelled\",\"title\":\"Ordini 1.1\",\"date\":\"2024-06-14T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-13T15:16:13+02:00\",\"orderId\":\"8e871a0f-296b-11ef-8e16-d517f37fa2ad\"}','2024-06-13 15:16:13.000',NULL,'2024-06-13 15:16:13.000','2024-06-13 13:16:14.000','2024-06-13 15:16:14.000'),('f10a4998-df89-4f58-b94d-d75e40e7a992',2,'8e7e9088-2733-11ef-8e16-d517f37fa1ab','Order 6.4 [pc2]',NULL,'API_META={\"type\":\"order\",\"key\":\"validated\",\"title\":\"Order 6.4 [pc2]\",\"date\":\"2024-06-23T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-19T15:50:30+02:00\",\"orderId\":\"68b5196a-2e42-11ef-8deb-d515ea58f6cb\"}','2024-06-19 15:50:31.000',NULL,'2024-06-19 15:50:31.000','2024-06-19 14:58:04.000','2024-06-19 16:58:04.000'),('f352fb85-23e4-11ef-8f8c-d92a43d45e5a',3,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','f352fb85-23e4-11ef-8f8c-d92a43d45e5a',NULL,'test envoi texte sous discussion non filtrée','2024-06-06 11:12:51.000',NULL,'2024-06-06 11:12:51.000','2024-06-06 09:24:48.000','2024-06-06 11:24:48.000'),('fa2fabfb-2e4d-11ef-8deb-d515ea58f6cb',2,'8e7e9088-2733-11ef-8e16-d517f37fa1ab','Order 17.3 [pc2]',NULL,'API_META={\"type\":\"order\",\"key\":\"resent\",\"title\":\"Order 17.3 [pc2]\",\"date\":\"2024-06-30T00:00:00\",\"orderUpdateTime\":\"2024-06-19T17:09:52\",\"orderId\":\"f1e7f15b-2e4d-11ef-8deb-d515ea58f6cb\"}','2024-06-19 17:09:52.000',NULL,'2024-06-19 17:09:52.000','2024-06-19 15:09:55.000','2024-06-19 17:09:55.000'),('fad71f64-8b16-4fc8-94d4-6ae6473112ab',2,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','Commande 2.2 [pc1]',NULL,'réponse via web via le tchat de la cmde','2024-06-06 11:55:50.000',NULL,'2024-06-06 11:55:50.000','2024-06-06 09:56:28.000','2024-06-06 11:56:28.000'),('fb69a8c0-23e7-11ef-8dde-d415e84cc4f5',3,'ddab36aa-23e2-11ef-8f8c-d92a43d45e5a','Commande 2.1 [pc1]',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 2.1 [pc1]\",\"date\":\"2024-06-07T00:00:00\",\"orderUpdateTime\":\"2024-06-06T11:34:33\",\"orderId\":\"96b5001d-23e7-11ef-8dde-d415e84cc4f5\"}','2024-06-06 11:34:33.000',NULL,'2024-06-06 11:34:33.000','2024-06-06 09:34:37.000','2024-06-06 11:34:37.000'),('fb782cec-2970-11ef-8e16-d517f37fa2ad',11,'1a8fdf3a-296b-11ef-8e16-d517f37fa2ad','Ordini 1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Ordini 1.1\",\"date\":\"2024-06-14T00:00:00\",\"orderUpdateTime\":\"2024-06-13T12:37:50\",\"orderId\":\"8e871a0f-296b-11ef-8e16-d517f37fa2ad\"}','2024-06-13 12:37:50.000',NULL,'2024-06-13 12:37:50.000','2024-06-13 13:38:48.000','2024-06-13 15:38:48.000'),('fc040a6f-0868-41d5-af3d-0efefc71a692',5,'8e7e9088-2733-11ef-8e16-d517f37fa1ab','Commande 2.2',NULL,'API_META={\"type\":\"order\",\"key\":\"edited\",\"title\":\"Commande 2.2\",\"date\":\"2024-06-12T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-10T16:49:09+02:00\",\"orderId\":\"1cba063b-271f-11ef-8e16-d517f37fa1ab\"}','2024-06-10 16:49:09.000',NULL,'2024-06-10 16:49:09.000','2024-06-10 14:49:13.000','2024-06-10 16:49:13.000'),('ff68612f-227d-11ef-8f8c-d92a43d45d56',2,'550eb27a-226b-11ef-8f1f-d8242c71b430','Commande 3.1 [pc1]',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 3.1 [pc1]\",\"date\":\"2024-06-05T00:00:00\",\"orderUpdateTime\":\"2024-06-04T16:23:22\",\"orderId\":\"cdf680d9-227d-11ef-8f8c-d92a43d45d56\"}','2024-06-04 16:23:22.000',NULL,'2024-06-04 16:23:22.000','2024-06-12 12:56:58.000','2024-06-12 14:56:58.000');
/*!40000 ALTER TABLE `SentMessage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SentOrderNotification`
--

DROP TABLE IF EXISTS `SentOrderNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SentOrderNotification` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `recipientId` varchar(36) DEFAULT NULL,
  `rescueData` text DEFAULT NULL,
  `deliveryDate` datetime(3) DEFAULT NULL,
  `event` enum('EDITED','VALIDATED','CANCELLED') NOT NULL DEFAULT 'EDITED',
  `unread` tinyint(1) NOT NULL DEFAULT 1,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `orderId` (`orderId`),
  KEY `recipientId` (`recipientId`),
  CONSTRAINT `SentOrderNotification_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `SentOrderNotification_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `ProstheticOrder` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `SentOrderNotification_ibfk_3` FOREIGN KEY (`recipientId`) REFERENCES `Contact` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SentOrderNotification`
--

LOCK TABLES `SentOrderNotification` WRITE;
/*!40000 ALTER TABLE `SentOrderNotification` DISABLE KEYS */;
INSERT INTO `SentOrderNotification` VALUES ('08e72d97-4e2f-4807-97c6-37b8fe2ea35c',2,'f26746c9-2272-11ef-8d76-d310d2ec2c14','4ed4ce00-4b30-4601-95bb-ede535f19c6b','{\"recipientDisplayName\":\"demo3 demo3env1\",\"patientDisplayID\":\"dc803a78-225a-11ef-8f1f-d8242c71b430\",\"orderTitle\":\"Commande 1.2\"}','2024-06-05 00:00:00.000','CANCELLED',0,'2024-06-07 11:31:34.000','2024-06-13 11:38:27.000','2024-06-13 09:38:27.000','2024-06-13 11:38:27.000'),('090784c3-6d90-4c31-832f-0566b31eca9f',3,'96b5001d-23e7-11ef-8dde-d415e84cc4f5','a50cb907-4db3-48f3-9808-0ae18d8dccdb','{\"recipientDisplayName\":\"client leger\",\"patientDisplayID\":\"907398e3-23e7-11ef-8dde-d415e84cc4f5\",\"orderTitle\":\"Commande 2.1\"}','2024-06-07 00:00:00.000','CANCELLED',0,'2024-06-06 11:35:19.000',NULL,'2024-06-10 12:29:21.000','2024-06-10 14:29:21.000'),('1c79d357-3cfa-4db6-9378-b49aff1609db',5,'6282c146-289b-11ef-8e16-d517f37fa2ad','c6f88ce8-d6e3-44ca-b07b-c13992c4abb8','{\"recipientDisplayName\":\"Web User\",\"patientDisplayID\":\"f373c86a-2899-11ef-8e16-d517f37fa2ad\",\"orderTitle\":\"Commande 1.2\"}','2024-06-14 00:00:00.000','CANCELLED',0,'2024-06-12 11:33:20.000','2024-06-12 11:42:40.000','2024-06-12 09:42:40.000','2024-06-12 11:42:40.000'),('27c8285f-9496-42f5-8bc9-a8d5a8c06573',11,'cc4112f9-297d-11ef-8e16-d517f37fa2ad','7c2adbb8-f64b-4654-bf3e-bed35e01c424','{\"recipientDisplayName\":\"sabine casertA\",\"patientDisplayID\":\"269e882c-2961-11ef-8e16-d517f37fa2ad\",\"orderTitle\":\"Ordini 5.2\"}','2024-06-16 00:00:00.000','EDITED',1,'2024-06-13 15:15:10.000',NULL,'2024-06-13 13:15:10.000','2024-06-13 15:15:10.000'),('35f0fc17-7e88-4f49-96c3-106e7508afdf',5,'0187211b-28a0-11ef-8e16-d517f37fa2ad','c6f88ce8-d6e3-44ca-b07b-c13992c4abb8','{\"recipientDisplayName\":\"Web User\",\"patientDisplayID\":\"f373c86a-2899-11ef-8e16-d517f37fa2ad\",\"orderTitle\":\"Commande 1.2\"}','2024-06-29 00:00:00.000','CANCELLED',1,'2024-06-12 11:46:47.000','2024-06-12 11:51:45.000','2024-06-12 09:51:45.000','2024-06-12 11:51:45.000'),('455ba82d-22bd-4e4c-a2d4-3fd59da46418',2,'68b5196a-2e42-11ef-8deb-d515ea58f6cb','f765045a-2805-40b5-9a87-63af78cc2071','{\"recipientDisplayName\":\"demo4 demo4env2\",\"patientDisplayID\":\"4382037a-2735-11ef-8e16-d517f37fa1ab\",\"orderTitle\":\"Order 6.4 [pc2]\"}','2024-06-23 00:00:00.000','EDITED',0,'2024-06-19 15:50:22.000',NULL,'2024-06-20 09:26:07.000','2024-06-20 11:26:07.000'),('46d9a982-6762-4943-8a85-99bdf010f160',2,'859f5fed-2e40-11ef-8deb-d515ea58f6cb','f765045a-2805-40b5-9a87-63af78cc2071','{\"recipientDisplayName\":\"demo4 demo4env2\",\"patientDisplayID\":\"4382037a-2735-11ef-8e16-d517f37fa1ab\",\"orderTitle\":\"Order 6.3 [pc2]\"}','2024-06-20 00:00:00.000','CANCELLED',0,'2024-06-19 15:43:21.000',NULL,'2024-06-20 09:26:08.000','2024-06-20 11:26:08.000'),('6526c78b-eef2-4401-89fd-dbffda12e635',2,'164af3dc-2e43-11ef-8deb-d515ea58f6cb','f765045a-2805-40b5-9a87-63af78cc2071','{\"recipientDisplayName\":\"demo4 demo4env2\",\"patientDisplayID\":\"4382037a-2735-11ef-8e16-d517f37fa1ab\",\"orderTitle\":\"Order 6.5 [pc2]\"}','2024-06-21 00:00:00.000','VALIDATED',1,'2024-06-19 15:55:43.000',NULL,'2024-06-19 13:55:43.000','2024-06-19 15:55:43.000'),('6c215e28-ae41-449d-9e65-8d117357cd9a',2,'22749c4a-2e42-11ef-8deb-d515ea58f6cb','f765045a-2805-40b5-9a87-63af78cc2071','{\"recipientDisplayName\":\"demo4 demo4env2\",\"patientDisplayID\":\"4382037a-2735-11ef-8e16-d517f37fa1ab\",\"orderTitle\":\"Order 6.3 [pc2]\"}','2024-06-21 00:00:00.000','EDITED',1,'2024-06-19 17:07:06.000',NULL,'2024-06-19 15:07:06.000','2024-06-19 17:07:06.000'),('7ddad21b-4105-491f-8863-bb65c41bc114',11,'8e871a0f-296b-11ef-8e16-d517f37fa2ad','7c2adbb8-f64b-4654-bf3e-bed35e01c424','{\"recipientDisplayName\":\"sabine casertA\",\"patientDisplayID\":\"9cd27370-2960-11ef-8e16-d517f37fa2ad\",\"orderTitle\":\"Ordini 1.1\"}','2024-06-14 00:00:00.000','CANCELLED',1,'2024-06-13 15:16:13.000',NULL,'2024-06-13 13:16:13.000','2024-06-13 15:16:13.000'),('8b0dc846-671e-4a3b-97fc-28ca1e21d3e6',2,'1cba063b-271f-11ef-8e16-d517f37fa1ab','f765045a-2805-40b5-9a87-63af78cc2071','{\"recipientDisplayName\":\"demo4 demo4env2\",\"patientDisplayID\":\"a1ace9b5-2271-11ef-8d76-d310d2ec2c14\",\"orderTitle\":\"Commande 2.2\"}','2024-06-12 00:00:00.000','EDITED',0,'2024-06-10 16:49:09.000','2024-06-13 11:38:27.000','2024-06-13 09:38:27.000','2024-06-13 11:38:27.000'),('96b2b0c3-cb3f-4384-bcd1-fd0b8bf53dbb',2,'ea2350dd-2e41-11ef-8deb-d515ea58f6cb','f765045a-2805-40b5-9a87-63af78cc2071','{\"recipientDisplayName\":\"demo4 demo4env2\",\"patientDisplayID\":\"4382037a-2735-11ef-8e16-d517f37fa1ab\",\"orderTitle\":\"Order 6.3 [pc2]\"}','2024-06-23 00:00:00.000','CANCELLED',0,'2024-06-19 15:44:13.000',NULL,'2024-06-20 09:26:07.000','2024-06-20 11:26:07.000'),('97a97e2e-3b65-4248-8441-c2ba9bdf0750',2,'a4229655-2279-11ef-8d76-d310d2ec2c14','4ed4ce00-4b30-4601-95bb-ede535f19c6b','{\"recipientDisplayName\":\"demo3 demo3env1\",\"patientDisplayID\":\"dc803a78-225a-11ef-8f1f-d8242c71b430\",\"orderTitle\":\"Commande 1.3\"}','2024-06-09 00:00:00.000','EDITED',0,'2024-06-07 11:31:27.000','2024-06-13 11:38:27.000','2024-06-13 09:38:27.000','2024-06-13 11:38:27.000'),('9b8c74a4-b664-4298-ba5f-2825b42ca757',2,'da257486-2e3a-11ef-8deb-d515ea58f6cb','f765045a-2805-40b5-9a87-63af78cc2071','{\"recipientDisplayName\":\"demo4 demo4env2\",\"patientDisplayID\":\"309e7124-2e35-11ef-8deb-d515ea58f6cb\",\"orderTitle\":\"Order 16.2 [pc2]\"}','2024-06-20 00:00:00.000','VALIDATED',0,'2024-06-19 15:05:42.000',NULL,'2024-06-20 09:26:08.000','2024-06-20 11:26:08.000'),('b03e64e3-fcf7-43bd-9ced-14164dcb5ddb',5,'ddb0571c-289e-11ef-8e16-d517f37fa2ad','c6f88ce8-d6e3-44ca-b07b-c13992c4abb8','{\"recipientDisplayName\":\"Web User\",\"patientDisplayID\":\"f373c86a-2899-11ef-8e16-d517f37fa2ad\",\"orderTitle\":\"Commande 1.2\"}','2024-06-14 00:00:00.000','CANCELLED',0,'2024-06-12 11:41:48.000','2024-06-12 11:42:24.000','2024-06-12 09:42:24.000','2024-06-12 11:42:24.000'),('ba1cfa26-7686-43ed-bad4-5e55abf6cdc7',2,'de096a3e-2e4d-11ef-8deb-d515ea58f6cb','f765045a-2805-40b5-9a87-63af78cc2071','{\"recipientDisplayName\":\"demo4 demo4env2\",\"patientDisplayID\":\"115617bc-2e4b-11ef-8deb-d515ea58f6cb\",\"orderTitle\":\"Order 17.3 [pc2]\"}','2024-06-20 00:00:00.000','CANCELLED',0,'2024-06-19 17:09:28.000',NULL,'2024-06-20 09:26:07.000','2024-06-20 11:26:07.000'),('bcd80a78-ca71-40fa-9387-cf061217bfcb',3,'8d24e986-23eb-11ef-8dde-d415e84cc4f5','a664f09d-da86-42d0-b54a-2672898db522','{\"recipientDisplayName\":\"sabine casertA\",\"patientDisplayID\":\"907398e3-23e7-11ef-8dde-d415e84cc4f5\",\"orderTitle\":\"Commande 2.3\"}','2024-06-07 00:00:00.000','VALIDATED',0,'2024-06-06 12:02:16.000',NULL,'2024-06-10 12:29:22.000','2024-06-10 14:29:22.000'),('d0ce03f3-0334-46d8-bf87-c3eaa67418b6',11,'08f4c372-2980-11ef-8e16-d517f37fa2ad','7c2adbb8-f64b-4654-bf3e-bed35e01c424','{\"recipientDisplayName\":\"sabine casertA\",\"patientDisplayID\":\"269e882c-2961-11ef-8e16-d517f37fa2ad\",\"orderTitle\":\"Ordini 5.5\"}','2024-06-14 00:00:00.000','CANCELLED',1,'2024-06-13 15:06:45.000',NULL,'2024-06-13 13:06:45.000','2024-06-13 15:06:45.000'),('d176ee6b-e314-410b-a688-fa489bdc5039',5,'e387023b-289f-11ef-8e16-d517f37fa2ad','c6f88ce8-d6e3-44ca-b07b-c13992c4abb8','{\"recipientDisplayName\":\"Web User\",\"patientDisplayID\":\"f373c86a-2899-11ef-8e16-d517f37fa2ad\",\"orderTitle\":\"Commande 1.1\"}','2024-06-30 00:00:00.000','VALIDATED',1,'2024-06-12 11:46:38.000','2024-06-12 11:51:45.000','2024-06-12 09:51:45.000','2024-06-12 11:51:45.000'),('d6a1282f-85c5-498f-9820-9536dfc06598',3,'0bd68b18-23e9-11ef-8dde-d415e84cc4f5','a664f09d-da86-42d0-b54a-2672898db522','{\"recipientDisplayName\":\"sabine casertA\",\"patientDisplayID\":\"907398e3-23e7-11ef-8dde-d415e84cc4f5\",\"orderTitle\":\"Commande 2.2\"}','2024-06-08 00:00:00.000','EDITED',0,'2024-06-06 11:58:24.000',NULL,'2024-06-10 12:29:22.000','2024-06-10 14:29:22.000'),('e2c44229-77a1-4986-a217-49a9db0916b4',5,'0d191b14-289a-11ef-8e16-d517f37fa2ad','c6f88ce8-d6e3-44ca-b07b-c13992c4abb8','{\"recipientDisplayName\":\"Web User\",\"patientDisplayID\":\"f373c86a-2899-11ef-8e16-d517f37fa2ad\",\"orderTitle\":\"Commande 1.1\"}','2024-06-28 00:00:00.000','EDITED',0,'2024-06-12 11:33:13.000','2024-06-12 11:42:40.000','2024-06-12 09:42:40.000','2024-06-12 11:42:40.000'),('e348ae71-8ecd-40f2-97f0-5ffc8b38df1d',11,'d2cfcd57-2985-11ef-8e16-d517f37fa2ad','b3c37c04-0470-43df-bb61-f33530e663f1','{\"recipientDisplayName\":\"succursalle Salles d\'aude laboratoire scan4all\",\"patientDisplayID\":\"269e882c-2961-11ef-8e16-d517f37fa2ad\",\"orderTitle\":\"Ordini 5.5\"}','2024-06-14 00:00:00.000','VALIDATED',1,'2024-06-13 15:10:35.000',NULL,'2024-06-13 13:10:35.000','2024-06-13 15:10:35.000'),('e93cb54d-d818-4b6b-8f01-9b4671bdc637',11,'470ab6fc-2963-11ef-8e16-d517f37fa2ad','7c2adbb8-f64b-4654-bf3e-bed35e01c424','{\"recipientDisplayName\":\"sabine casertA\",\"patientDisplayID\":\"269e882c-2961-11ef-8e16-d517f37fa2ad\",\"orderTitle\":\"Ordini 5.1\"}','2024-06-16 00:00:00.000','EDITED',1,'2024-06-13 15:14:17.000',NULL,'2024-06-13 13:14:17.000','2024-06-13 15:14:17.000'),('f4c5bcfc-fc12-4cc4-afd7-86f29bdc9265',2,'15fd7f91-2e4b-11ef-8deb-d515ea58f6cb','f765045a-2805-40b5-9a87-63af78cc2071','{\"recipientDisplayName\":\"demo4 demo4env2\",\"patientDisplayID\":\"115617bc-2e4b-11ef-8deb-d515ea58f6cb\",\"orderTitle\":\"Order 17.1 [pc2]\"}','2024-06-20 00:00:00.000','VALIDATED',0,'2024-06-19 16:57:59.000',NULL,'2024-06-20 09:26:07.000','2024-06-20 11:26:07.000'),('f522a240-f2b9-486b-95bb-c94d8251e382',2,'8c15b440-2735-11ef-8e16-d517f37fa1ab','4ed4ce00-4b30-4601-95bb-ede535f19c6b','{\"recipientDisplayName\":\"demo3 demo3env1\",\"patientDisplayID\":\"312c74c3-2735-11ef-8e16-d517f37fa1ab\",\"orderTitle\":\"Commande 5.1\"}','2024-06-12 00:00:00.000','VALIDATED',0,'2024-06-11 10:02:36.000','2024-06-13 11:38:27.000','2024-06-13 09:38:27.000','2024-06-13 11:38:27.000');
/*!40000 ALTER TABLE `SentOrderNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Session`
--

DROP TABLE IF EXISTS `Session`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Session` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL,
  `actId` varchar(36) NOT NULL,
  `displayId` mediumint(8) unsigned DEFAULT NULL,
  `pcId` mediumint(8) unsigned DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT 0,
  `comments` text DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `actId` (`actId`),
  CONSTRAINT `Session_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `Session_ibfk_2` FOREIGN KEY (`actId`) REFERENCES `Act` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Session`
--

LOCK TABLES `Session` WRITE;
/*!40000 ALTER TABLE `Session` DISABLE KEYS */;
INSERT INTO `Session` VALUES ('01001128-297d-11ef-8e16-d517f37fa2ad',11,'00fde810-297d-11ef-8e16-d517f37fa2ad',1,1,0,'','2024-06-13 14:03:53.620','2024-06-13 14:08:57.351','2024-06-13 14:03:53.624','2024-06-13 12:08:57.352','2024-06-13 14:08:57.363'),('08ed7a4a-2980-11ef-8e16-d517f37fa2ad',11,'08eb58c6-2980-11ef-8e16-d517f37fa2ad',1,1,0,'','2024-06-13 14:25:35.411',NULL,'2024-06-13 14:25:35.413','2024-06-13 12:25:35.413','2024-06-13 14:25:35.418'),('0bcebe79-23e9-11ef-8dde-d415e84cc4f5',3,'0bcc91ed-23e9-11ef-8dde-d415e84cc4f5',1,1,0,'','2024-06-06 11:42:10.422',NULL,'2024-06-06 11:42:10.425','2024-06-06 09:42:10.425','2024-06-06 11:42:10.429'),('0be8b738-273b-11ef-8e16-d517f37fa1ab',2,'0be66d2e-273b-11ef-8e16-d517f37fa1ab',1,2,0,'','2024-06-10 17:06:42.813','2024-06-10 17:07:19.475','2024-06-10 17:06:42.815','2024-06-10 15:07:19.476','2024-06-10 17:07:19.480'),('0d14f12a-289a-11ef-8e16-d517f37fa2ad',5,'0d1289f0-289a-11ef-8e16-d517f37fa2ad',1,1,0,'','2024-06-12 10:59:18.132',NULL,'2024-06-12 10:59:18.137','2024-06-12 08:59:18.136','2024-06-12 10:59:18.143'),('11917a4e-28bb-11ef-8e16-d517f37fa2ad',5,'118f12a1-28bb-11ef-8e16-d517f37fa2ad',1,1,0,'','2024-06-12 14:55:39.051',NULL,'2024-06-12 14:55:39.054','2024-06-12 12:55:39.054','2024-06-12 14:55:39.063'),('15f94c3c-2e4b-11ef-8deb-d515ea58f6cb',2,'15f71dc7-2e4b-11ef-8deb-d515ea58f6cb',1,2,0,'','2024-06-19 16:49:10.430',NULL,'2024-06-19 16:49:10.433','2024-06-19 14:49:10.433','2024-06-19 16:49:10.439'),('1643d04c-2e43-11ef-8deb-d515ea58f6cb',2,'164199d1-2e43-11ef-8deb-d515ea58f6cb',1,2,0,'','2024-06-19 15:51:54.945',NULL,'2024-06-19 15:51:54.953','2024-06-19 13:51:54.953','2024-06-19 15:51:54.956'),('1b9450aa-2e0d-11ef-8deb-d515ea58f6cb',2,'1b9240f4-2e0d-11ef-8deb-d515ea58f6cb',1,2,0,'','2024-06-19 09:25:31.038',NULL,'2024-06-19 09:25:31.041','2024-06-19 07:25:31.040','2024-06-19 12:49:09.406'),('1cb90d11-271f-11ef-8e16-d517f37fa1ab',2,'1cb775ae-271f-11ef-8e16-d517f37fa1ab',1,2,0,'','2024-06-10 13:46:45.000',NULL,'2024-06-10 13:46:45.114','2024-06-10 13:34:25.000','2024-06-10 15:34:25.000'),('36556270-2e35-11ef-8deb-d515ea58f6cb',2,'3654e763-2e35-11ef-8deb-d515ea58f6cb',1,2,0,'','2024-06-19 14:12:35.793',NULL,'2024-06-19 14:12:35.796','2024-06-19 12:12:35.796','2024-06-19 14:12:35.798'),('469bda30-27cb-11ef-8e37-d519fa9d22d2',2,'46997caf-27cb-11ef-8e37-d519fa9d22d2',1,2,0,'','2024-06-11 10:19:08.823',NULL,'2024-06-11 10:19:08.827','2024-06-11 08:19:08.826','2024-06-11 10:19:08.832'),('4706df6f-2963-11ef-8e16-d517f37fa2ad',11,'4704a021-2963-11ef-8e16-d517f37fa2ad',1,1,0,'','2024-06-13 10:59:44.191',NULL,'2024-06-13 10:59:44.194','2024-06-13 08:59:44.193','2024-06-13 10:59:44.198'),('4ba370c1-2987-11ef-8e16-d517f37fa2ad',11,'4ba13230-2987-11ef-8e16-d517f37fa2ad',1,1,0,'','2024-06-13 15:17:33.810',NULL,'2024-06-13 15:17:33.813','2024-06-13 13:17:33.813','2024-06-13 15:17:33.817'),('54eefd9c-273a-11ef-8e16-d517f37fa1ab',2,'54ecb28b-273a-11ef-8e16-d517f37fa1ab',1,2,0,'','2024-06-10 17:01:35.831',NULL,'2024-06-10 17:01:35.834','2024-06-10 15:01:35.833','2024-06-10 17:01:35.838'),('58f49179-298a-11ef-8e16-d517f37fa2ad',2,'58f22a30-298a-11ef-8e16-d517f37fa2ad',1,2,0,'','2024-06-13 15:39:24.642',NULL,'2024-06-13 15:39:24.646','2024-06-13 13:39:24.646','2024-06-13 15:39:24.654'),('5f1e0aab-273f-11ef-8e09-d517f1736dc8',2,'5f1d39de-273f-11ef-8e09-d517f1736dc8',1,2,0,'','2024-06-10 17:37:40.400',NULL,'2024-06-10 17:37:40.401','2024-06-10 15:38:47.194','2024-06-10 17:38:47.283'),('5f3317c6-27f1-11ef-8e37-d519fa9d22d2',2,'5f30ec6f-27f1-11ef-8e37-d519fa9d22d2',1,2,0,'','2024-06-11 14:51:50.956',NULL,'2024-06-11 14:51:50.959','2024-06-11 12:51:50.958','2024-06-11 14:51:50.962'),('5f49b09c-28bf-11ef-8e16-d517f37fa2ad',5,'5f4774a2-28bf-11ef-8e16-d517f37fa2ad',1,1,0,'','2024-06-12 15:26:27.430',NULL,'2024-06-12 15:26:27.433','2024-06-12 13:26:27.433','2024-06-12 15:26:27.437'),('627f5b3e-289b-11ef-8e16-d517f37fa2ad',5,'627cfe1c-289b-11ef-8e16-d517f37fa2ad',1,1,0,'','2024-06-12 11:08:50.933',NULL,'2024-06-12 11:08:50.936','2024-06-12 09:08:50.935','2024-06-12 11:08:50.940'),('62bbada3-226c-11ef-8d76-d310d2ec2c14',2,'62b97c61-226c-11ef-8d76-d310d2ec2c14',1,2,0,'','2024-06-04 14:17:18.005',NULL,'2024-06-04 14:17:18.008','2024-06-04 12:17:18.008','2024-06-04 14:17:18.012'),('6872c415-28c3-11ef-8e16-d517f37fa2ad',5,'6872058e-28c3-11ef-8e16-d517f37fa2ad',1,1,0,'','2024-06-12 15:55:20.786',NULL,'2024-06-12 15:55:20.786','2024-06-12 14:37:28.861','2024-06-12 16:37:28.936'),('68b10ccb-2e42-11ef-8deb-d515ea58f6cb',2,'68af0333-2e42-11ef-8deb-d515ea58f6cb',1,2,0,'','2024-06-19 15:47:03.737',NULL,'2024-06-19 15:47:03.739','2024-06-19 13:47:03.739','2024-06-19 15:47:03.743'),('6a00fa35-28c9-11ef-8e16-d517f37fa2ad',5,'6a002ae5-28c9-11ef-8e16-d517f37fa2ad',1,1,0,'','2024-06-12 16:38:20.376',NULL,'2024-06-12 16:38:20.380','2024-06-12 14:40:14.217','2024-06-12 16:40:14.300'),('72bbb4c0-2a20-11ef-8f1c-d8242c6fa8fd',11,'72b8db7f-2a20-11ef-8f1c-d8242c6fa8fd',1,1,0,'','2024-06-14 09:33:53.919','2024-06-14 10:38:34.930','2024-06-14 09:33:53.923','2024-06-14 08:38:34.930','2024-06-14 10:38:34.941'),('78bc2302-2255-11ef-8e3f-d619fca54465',3,'78ba832e-2255-11ef-8e3f-d619fca54465',1,1,0,'','2024-06-04 11:33:16.493',NULL,'2024-06-04 11:33:16.493','2024-06-04 09:33:16.493','2024-06-04 11:33:16.495'),('80d4d06a-27cb-11ef-8e37-d519fa9d22d2',2,'80d26da8-27cb-11ef-8e37-d519fa9d22d2',1,2,0,'','2024-06-11 10:20:46.505',NULL,'2024-06-11 10:20:46.507','2024-06-11 08:20:46.507','2024-06-11 10:20:46.513'),('834fc45d-2343-11ef-8f85-d92942ce45ec',3,'834ecb64-2343-11ef-8f85-d92942ce45ec',1,1,1,'','2024-06-05 15:57:15.422',NULL,'2024-06-05 15:57:15.426','2024-06-05 13:57:15.425',NULL),('848cc83f-2cbb-11ef-8e27-d518f78fe3c8',2,'84822f83-2cbb-11ef-8e27-d518f78fe3c8',1,2,0,'','2024-06-17 17:08:56.610',NULL,'2024-06-17 17:08:56.611','2024-06-17 15:08:56.610','2024-06-17 17:08:56.656'),('859bd7ba-2e40-11ef-8deb-d515ea58f6cb',2,'8598ee4a-2e40-11ef-8deb-d515ea58f6cb',1,2,0,'','2024-06-19 15:33:33.259',NULL,'2024-06-19 15:33:33.262','2024-06-19 13:33:33.261','2024-06-19 15:33:33.266'),('8c1214e8-2735-11ef-8e16-d517f37fa1ab',2,'8c10fdc0-2735-11ef-8e16-d517f37fa1ab',1,2,0,'','2024-06-10 16:27:20.852','2024-06-11 10:08:19.597','2024-06-10 16:27:20.855','2024-06-11 08:08:19.598','2024-06-11 10:08:19.600'),('8d098374-2a29-11ef-8f1c-d8242c6fa8fd',11,'8d07a312-2a29-11ef-8f1c-d8242c6fa8fd',1,1,0,'','2024-06-14 10:39:03.521',NULL,'2024-06-14 10:39:03.524','2024-06-14 08:39:03.523','2024-06-14 10:39:03.529'),('8d21a1cc-23eb-11ef-8dde-d415e84cc4f5',3,'8d2006e5-23eb-11ef-8dde-d415e84cc4f5',1,1,0,'','2024-06-06 12:00:06.385',NULL,'2024-06-06 12:00:06.389','2024-06-06 10:00:06.388','2024-06-06 12:00:06.393'),('8e83509f-296b-11ef-8e16-d517f37fa2ad',11,'8e81ab09-296b-11ef-8e16-d517f37fa2ad',1,1,0,'','2024-06-13 11:59:00.098',NULL,'2024-06-13 11:59:00.103','2024-06-13 09:59:00.102','2024-06-13 11:59:00.106'),('8f6cf168-2740-11ef-8e09-d517f1736dc8',2,'8f6c8859-2740-11ef-8e09-d517f1736dc8',1,2,0,'','2024-06-10 17:46:10.944',NULL,'2024-06-10 17:46:10.945','2024-06-10 15:46:10.945','2024-06-10 17:46:10.998'),('91784208-23fa-11ef-8dde-d415e84cc4f5',2,'917767fe-23fa-11ef-8dde-d415e84cc4f5',1,2,0,'','2024-06-06 13:47:36.114','2024-06-11 10:15:33.807','2024-06-06 13:47:36.118','2024-06-11 08:15:33.807','2024-06-11 10:15:33.809'),('9576614e-2e29-11ef-8deb-d515ea58f6cb',2,'9573b888-2e29-11ef-8deb-d515ea58f6cb',1,2,0,'','2024-06-19 12:49:21.432',NULL,'2024-06-19 12:49:21.435','2024-06-19 10:49:21.434','2024-06-19 12:49:52.906'),('96b19cc6-23e7-11ef-8dde-d415e84cc4f5',3,'96aedcf6-23e7-11ef-8dde-d415e84cc4f5',1,1,0,'','2024-06-06 11:31:44.441',NULL,'2024-06-06 11:31:44.444','2024-06-06 09:31:44.444','2024-06-06 11:31:44.449'),('9c9dff16-28ba-11ef-8e16-d517f37fa2ad',5,'9c9bb412-28ba-11ef-8e16-d517f37fa2ad',1,1,0,'','2024-06-12 14:52:22.840','2024-06-12 14:54:09.696','2024-06-12 14:52:22.843','2024-06-12 12:54:09.696','2024-06-12 14:54:09.706'),('a1ecf57e-298a-11ef-8e16-d517f37fa2ad',2,'a1ebbaf4-298a-11ef-8e16-d517f37fa2ad',1,2,0,'','2024-06-13 15:41:27.066',NULL,'2024-06-13 15:41:27.069','2024-06-13 13:41:27.068','2024-06-13 15:41:27.073'),('a4160b84-2279-11ef-8d76-d310d2ec2c14',2,'a4139c9d-2279-11ef-8d76-d310d2ec2c14',1,2,0,'','2024-06-04 15:52:11.107',NULL,'2024-06-04 15:52:11.110','2024-06-04 13:52:11.110','2024-06-04 15:52:11.116'),('a888b842-2984-11ef-8e16-d517f37fa2ad',11,'a8885309-2984-11ef-8e16-d517f37fa2ad',1,1,0,'','2024-06-13 14:58:41.172',NULL,'2024-06-13 14:58:41.174','2024-06-13 13:05:35.177','2024-06-13 15:05:35.549'),('af864e86-27f1-11ef-8e37-d519fa9d22d2',2,'af857ecd-27f1-11ef-8e37-d519fa9d22d2',1,2,0,'','2024-06-11 14:54:05.719',NULL,'2024-06-11 14:54:05.722','2024-06-19 13:19:00.287','2024-06-19 15:19:00.566'),('afa8fad1-2271-11ef-8d76-d310d2ec2c14',2,'afa6cb0d-2271-11ef-8d76-d310d2ec2c14',1,2,0,'','2024-06-04 14:55:14.551',NULL,'2024-06-04 14:55:14.556','2024-06-04 12:55:14.556','2024-06-04 14:55:14.560'),('b6e92385-2fa5-11ef-8e5c-d61b03bfb54e',2,'b6e836ab-2fa5-11ef-8e5c-d61b03bfb54e',1,2,1,'','2024-06-21 10:10:26.371',NULL,'2024-06-21 10:10:26.374','2024-06-21 08:10:26.374',NULL),('b7e495d3-2e0c-11ef-8deb-d515ea58f6cb',11,'b7e3a050-2e0c-11ef-8deb-d515ea58f6cb',1,1,1,'','2024-06-19 09:22:43.791',NULL,'2024-06-19 09:22:43.795','2024-06-19 07:22:43.795',NULL),('bafc70fb-273a-11ef-8e16-d517f37fa1ab',2,'bafa1a93-273a-11ef-8e16-d517f37fa1ab',1,2,0,'','2024-06-10 17:04:27.046','2024-06-10 17:05:41.505','2024-06-10 17:04:27.049','2024-06-10 15:05:41.506','2024-06-10 17:05:41.508'),('be9c5752-2735-11ef-8e16-d517f37fa1ab',2,'be9a8e99-2735-11ef-8e16-d517f37fa1ab',1,2,0,'','2024-06-10 16:28:45.644',NULL,'2024-06-10 16:28:45.647','2024-06-10 14:28:45.646','2024-06-10 16:28:45.651'),('c8883bc6-2e3c-11ef-8deb-d515ea58f6cb',2,'c88615a1-2e3c-11ef-8deb-d515ea58f6cb',1,2,0,'','2024-06-19 15:06:47.550',NULL,'2024-06-19 15:06:47.552','2024-06-19 13:06:47.552','2024-06-19 15:06:47.556'),('cc37a7f7-297d-11ef-8e16-d517f37fa2ad',11,'cc35f9a3-297d-11ef-8e16-d517f37fa2ad',1,1,0,'','2024-06-13 14:09:34.562',NULL,'2024-06-13 14:09:34.566','2024-06-13 12:09:34.566','2024-06-13 14:09:34.571'),('d70636d7-298d-11ef-8e16-d517f37fa2ad',11,'d703d726-298d-11ef-8e16-d517f37fa2ad',1,1,0,'','2024-06-13 16:04:24.641',NULL,'2024-06-13 16:04:24.644','2024-06-13 14:04:24.643','2024-06-13 16:04:24.652'),('da21a6e4-2e3a-11ef-8deb-d515ea58f6cb',2,'da1f6873-2e3a-11ef-8deb-d515ea58f6cb',1,2,0,'','2024-06-19 14:52:58.084',NULL,'2024-06-19 14:52:58.087','2024-06-19 12:52:58.086','2024-06-19 14:52:58.091'),('da37d213-227c-11ef-8d76-d310d2ec2c14',2,'da355fe4-227c-11ef-8d76-d310d2ec2c14',1,2,0,'','2024-06-04 16:15:10.000',NULL,'2024-06-04 16:15:10.418','2024-06-04 14:15:11.000','2024-06-04 16:15:11.000'),('de016fdd-2e4d-11ef-8deb-d515ea58f6cb',2,'ddffc633-2e4d-11ef-8deb-d515ea58f6cb',1,2,0,'','2024-06-19 17:09:05.021',NULL,'2024-06-19 17:09:05.025','2024-06-19 15:09:05.025','2024-06-19 17:09:05.027'),('eab758e7-273c-11ef-8e16-d517f37fa1ab',2,'eab5fbfa-273c-11ef-8e16-d517f37fa1ab',1,2,0,'','2024-06-10 17:20:06.118',NULL,'2024-06-10 17:20:06.121','2024-06-10 15:25:51.675','2024-06-10 17:25:51.741'),('eae1e551-27ca-11ef-8e37-d519fa9d22d2',2,'eadc6274-27ca-11ef-8e37-d519fa9d22d2',1,2,0,'','2024-06-11 10:16:34.932',NULL,'2024-06-11 10:16:34.935','2024-06-11 08:16:34.935','2024-06-11 10:16:35.011'),('eb7fbaa1-2fa4-11ef-8e5c-d61b03bfb54e',2,'eb7d58ee-2fa4-11ef-8e5c-d61b03bfb54e',1,2,0,'','2024-06-21 10:04:45.103',NULL,'2024-06-21 10:04:45.106','2024-06-21 08:04:45.106','2024-06-21 10:04:45.112'),('f262aa99-2272-11ef-8d76-d310d2ec2c14',2,'f2606f1c-2272-11ef-8d76-d310d2ec2c14',1,2,0,'','2024-06-04 15:04:15.000',NULL,'2024-06-04 15:04:15.999','2024-06-04 13:04:16.000','2024-06-04 15:04:16.000'),('f300fd64-2731-11ef-8e16-d517f37fa1ab',2,'f2fea4e5-2731-11ef-8e16-d517f37fa1ab',1,2,0,'','2024-06-10 16:01:35.000',NULL,'2024-06-10 16:01:35.562','2024-06-10 14:01:36.000','2024-06-10 16:01:36.000'),('f3d35f6d-27d1-11ef-8e37-d519fa9d22d2',2,'f3d1c83f-27d1-11ef-8e37-d519fa9d22d2',1,2,0,'','2024-06-11 11:06:56.413',NULL,'2024-06-11 11:06:56.414','2024-06-11 09:06:56.414','2024-06-11 11:06:56.416'),('f8edd977-2e4c-11ef-8deb-d515ea58f6cb',2,'f8ed0986-2e4c-11ef-8deb-d515ea58f6cb',1,2,0,'','2024-06-19 17:02:40.695',NULL,'2024-06-19 17:02:40.698','2024-06-19 15:03:49.096','2024-06-19 17:03:49.136'),('fe7444eb-28bf-11ef-8e16-d517f37fa2ad',5,'fe71f582-28bf-11ef-8e16-d517f37fa2ad',1,1,0,'','2024-06-12 15:30:54.467','2024-06-12 17:57:47.318','2024-06-12 15:30:54.473','2024-06-12 15:57:47.320','2024-06-12 17:57:47.321'),('ff4617e9-272f-11ef-8e16-d517f37fa1ab',2,'ff43b7ab-272f-11ef-8e16-d517f37fa1ab',1,2,0,'','2024-06-10 15:47:37.000',NULL,'2024-06-10 15:47:37.153','2024-06-10 13:47:38.000','2024-06-10 15:47:38.000');
/*!40000 ALTER TABLE `Session` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SmilersOrder`
--

DROP TABLE IF EXISTS `SmilersOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SmilersOrder` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `actId` varchar(36) NOT NULL,
  `title` varchar(64) DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT 0,
  `createdById` varchar(36) DEFAULT NULL,
  `updatedById` varchar(36) DEFAULT NULL,
  `displayId` mediumint(8) unsigned DEFAULT NULL,
  `pcId` mediumint(8) unsigned DEFAULT NULL,
  `json` text NOT NULL,
  `metadata` text NOT NULL,
  `status` enum('NOT_SENT','WAITING_WOW_API','SENDING_WOW_API','SENDING_SMILERS_API','SENT','CANCELLED','DELIVERY') NOT NULL DEFAULT 'NOT_SENT',
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `actId` (`actId`),
  CONSTRAINT `SmilersOrder_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `SmilersOrder_ibfk_2` FOREIGN KEY (`actId`) REFERENCES `Act` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SmilersOrder`
--

LOCK TABLES `SmilersOrder` WRITE;
/*!40000 ALTER TABLE `SmilersOrder` DISABLE KEYS */;
/*!40000 ALTER TABLE `SmilersOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SmilersOrderFile`
--

DROP TABLE IF EXISTS `SmilersOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SmilersOrderFile` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('FORM','SCAN') NOT NULL,
  PRIMARY KEY (`orderId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `SmilersOrderFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `SmilersOrderFile_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `SmilersOrder` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `SmilersOrderFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SmilersOrderFile`
--

LOCK TABLES `SmilersOrderFile` WRITE;
/*!40000 ALTER TABLE `SmilersOrderFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `SmilersOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SyncInfo`
--

DROP TABLE IF EXISTS `SyncInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SyncInfo` (
  `id` mediumint(8) unsigned NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `directLastRetrieved` text DEFAULT NULL COMMENT 'Direct last retrieved date values as json',
  `autoLastRetrieved` text DEFAULT NULL COMMENT 'Auto last retrieved date values as json',
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  PRIMARY KEY (`id`,`ownerId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SyncInfo`
--

LOCK TABLES `SyncInfo` WRITE;
/*!40000 ALTER TABLE `SyncInfo` DISABLE KEYS */;
INSERT INTO `SyncInfo` VALUES (1,1,NULL,NULL,'2024-06-04 09:28:58.693'),(1,2,'{\"actsDirectLastRetrieved\":\"2024-06-10 16:02:37\",\"analysesDirectLastRetrieved\":\"2024-06-10 15:34:34\",\"assistantsDirectLastRetrieved\":\"2024-06-04 14:35:11\",\"occlusionsDirectLastRetrieved\":\"2024-06-04 15:48:25\",\"patientsDirectLastRetrieved\":\"2024-06-10 16:00:15\",\"scansDirectLastRetrieved\":\"2024-06-10 16:02:37\",\"sessionsDirectLastRetrieved\":\"2024-06-10 16:01:36\"}','{\"contactsAutoLastRetrieved\":\"2024-06-20 14:19:39\",\"discussionsAutoLastRetrieved\":\"2024-06-21 10:02:59\",\"messagesAutoLastRetrieved\":\"2024-06-21 10:02:59\",\"notificationsAutoLastRetrieved\":\"2024-06-20 11:26:08\",\"prostheticOrdersAutoLastRetrieved\":\"2024-06-19 17:09:53\"}','2024-06-21 08:03:02.626'),(1,3,NULL,'{\"contactsAutoLastRetrieved\":\"2024-06-20 11:27:59\",\"discussionsAutoLastRetrieved\":\"2024-06-20 11:41:43\",\"messagesAutoLastRetrieved\":\"2024-06-20 11:41:26\",\"notificationsAutoLastRetrieved\":\"2024-06-20 11:27:59\",\"prostheticOrdersAutoLastRetrieved\":\"2024-06-06 12:02:16\"}','2024-06-20 09:41:44.721'),(1,4,NULL,NULL,'2024-06-04 12:11:34.973'),(1,5,NULL,'{\"contactsAutoLastRetrieved\":\"2024-06-13 09:38:49\",\"discussionsAutoLastRetrieved\":\"2024-06-12 11:46:58\",\"messagesAutoLastRetrieved\":\"2024-06-12 11:46:58\",\"notificationsAutoLastRetrieved\":\"2024-06-12 11:52:16\",\"prostheticOrdersAutoLastRetrieved\":\"2024-06-12 11:46:47\"}','2024-06-13 07:38:49.674'),(1,6,NULL,NULL,'2024-06-06 08:47:26.673'),(1,7,NULL,NULL,'2024-06-06 11:35:27.984'),(1,8,NULL,NULL,'2024-06-06 11:35:57.266'),(1,9,NULL,NULL,'2024-06-12 09:21:59.677'),(1,10,NULL,'{\"contactsAutoLastRetrieved\":\"2024-06-12 14:41:31\",\"notificationsAutoLastRetrieved\":\"2024-06-12 11:52:13\"}','2024-06-12 12:41:31.194'),(1,11,NULL,'{\"contactsAutoLastRetrieved\":\"2024-06-20 14:19:39\",\"discussionsAutoLastRetrieved\":\"2024-06-20 11:38:53\",\"messagesAutoLastRetrieved\":\"2024-06-20 11:26:29\",\"notificationsAutoLastRetrieved\":\"2024-06-13 15:16:13\",\"prostheticOrdersAutoLastRetrieved\":\"2024-06-14 11:18:40\"}','2024-06-20 12:47:22.180'),(1,12,NULL,NULL,'2024-06-20 09:22:38.853');
/*!40000 ALTER TABLE `SyncInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SystemNotification`
--

DROP TABLE IF EXISTS `SystemNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SystemNotification` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `event` enum('NO_CONNECTION_FOR_X_DAYS') NOT NULL DEFAULT 'NO_CONNECTION_FOR_X_DAYS',
  `unread` tinyint(1) NOT NULL DEFAULT 1,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  CONSTRAINT `SystemNotification_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SystemNotification`
--

LOCK TABLES `SystemNotification` WRITE;
/*!40000 ALTER TABLE `SystemNotification` DISABLE KEYS */;
/*!40000 ALTER TABLE `SystemNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Token`
--

DROP TABLE IF EXISTS `Token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Token` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `credentialsId` varchar(36) DEFAULT NULL,
  `token` char(200) NOT NULL,
  `context` char(40) DEFAULT NULL,
  `device` char(255) DEFAULT NULL,
  `created` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `token` (`token`),
  KEY `credentialsId` (`credentialsId`),
  CONSTRAINT `Token_ibfk_1` FOREIGN KEY (`credentialsId`) REFERENCES `Credentials` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Token`
--

LOCK TABLES `Token` WRITE;
/*!40000 ALTER TABLE `Token` DISABLE KEYS */;
INSERT INTO `Token` VALUES ('0136b68b-2d7e-11ef-8dd8-d414e647ae96',11,'66d7dc11-0d36-4d25-9823-f7f0c1d1f38a','a75313e95888f39cfb43d8ca5fc1bfb16f34b1f0','software','CondorScan','2024-06-18 16:21:08.126','2024-06-18 14:21:08.127'),('03f819ee-23e5-11ef-8dde-d415e84cc4f5',3,'adc06de1-bf5d-4b1a-81dc-e5e919328b7c','d1f65488a106dcc7ea90beb9d473c7bf461230d7','software','CondorScan','2024-06-06 11:13:19.285','2024-06-06 09:13:19.285'),('05ef7246-2e4b-11ef-8deb-d515ea58f6cb',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','a567836f3c27505247f0250bfdedbbd639fddaec','software','CondorScan','2024-06-19 16:48:43.522','2024-06-19 14:48:43.522'),('08cf757f-23eb-11ef-8dde-d415e84cc4f5',3,'adc06de1-bf5d-4b1a-81dc-e5e919328b7c','99142f87614545701743e587b95025424ca9fdbd','software','CondorScan','2024-06-06 11:56:24.387','2024-06-06 09:56:24.387'),('09e2c43d-28a3-11ef-8e16-d517f37fa2ad',5,'9efecb15-ce6e-4f75-936f-8ca618cb191f','c111ebb09a113ca385ae840e8a14a7f55952ed4f','software','CondorScan','2024-06-12 12:03:38.241','2024-06-12 10:03:38.241'),('0b98f975-298f-11ef-8e16-d517f37fa2ad',11,'66d7dc11-0d36-4d25-9823-f7f0c1d1f38a','5bef581c9db9569322755c7adedc8a37e7a571ca','software','CondorScan','2024-06-13 16:13:02.341','2024-06-13 14:13:02.341'),('0badb52d-23fb-11ef-8dde-d415e84cc4f5',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','c768c0deeb46eff0c29b6b8aa557b388ec1281bc','software','CondorScan','2024-06-06 13:51:01.147','2024-06-06 11:51:01.147'),('0bf56b88-28b9-11ef-8e16-d517f37fa2ad',10,'e777d5c7-3598-4093-b42c-8342c0d4d52e','69c4bd9fdc00cb07b3419ecd09db18a4cb576712','software','CondorScan','2024-06-12 14:41:10.647','2024-06-12 12:41:10.647'),('0c18e3c0-2733-11ef-8e16-d517f37fa1ab',3,'adc06de1-bf5d-4b1a-81dc-e5e919328b7c','1d951d55ec3bfdbae5eef7c1354e1a81fb3693e3','software','CondorScan','2024-06-10 16:09:27.154','2024-06-10 14:09:27.155'),('0e698d43-2899-11ef-8e16-d517f37fa2ad',5,'b35f432d-f5a0-4048-b2dc-1eb3596a89a1','f816fcd5c791b76601886a42fb92ebfbe8b51f47','software','CondorScan','2024-06-12 10:52:10.868','2024-06-12 08:52:10.868'),('0f892bb4-2725-11ef-8e16-d517f37fa1ab',3,'adc06de1-bf5d-4b1a-81dc-e5e919328b7c','43cb2244e4d196dcc1b338d7ccbbb10f5271f1c9','software','CondorScan','2024-06-10 14:29:19.969','2024-06-10 12:29:19.970'),('10322500-2725-11ef-8e16-d517f37fa1ab',3,'adc06de1-bf5d-4b1a-81dc-e5e919328b7c','d0645ed7dec2ab91e4640e405db78277a1bc45ec','software','CondorScan','2024-06-10 14:29:21.077','2024-06-10 12:29:21.077'),('110a7a8a-2e52-11ef-8deb-d515ea58f6cb',11,'66d7dc11-0d36-4d25-9823-f7f0c1d1f38a','9df253d19e493645706e33e0b95436733051033c','software','CondorScan','2024-06-19 17:39:08.631','2024-06-19 15:39:08.632'),('147c4fa4-2a20-11ef-8f1c-d8242c6fa8fd',11,'66d7dc11-0d36-4d25-9823-f7f0c1d1f38a','ea6bb26b1c1832855c65a8d6bd296f10ebad7aef','software','CondorScan','2024-06-14 09:31:15.798','2024-06-14 07:31:15.798'),('16dfb905-2270-11ef-8d76-d310d2ec2c14',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','75e1178d267bbcc6f70b85c454bb47693f23866d','software','CondorScan','2024-06-04 14:43:48.721','2024-06-04 12:43:48.721'),('1b03fd8b-2cbe-11ef-8e27-d518f78fe3c8',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','ca3cd08590209da84270d3d1654344cc85c90ab4','software','CondorScan','2024-06-17 17:27:28.043','2024-06-17 15:27:28.043'),('1b6fa7df-226d-11ef-8d76-d310d2ec2c14',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','d3e15347b1fa860079ad7ac9d12505be2ed5cf13','software','CondorScan','2024-06-04 14:22:27.885','2024-06-04 12:22:27.886'),('1bc6a7ae-28a3-11ef-8e16-d517f37fa2ad',5,'b35f432d-f5a0-4048-b2dc-1eb3596a89a1','845afc7e925abf986a8618da96208dd614e67f9c','software','CondorScan','2024-06-12 12:04:08.256','2024-06-12 10:04:08.256'),('1bf2b4a4-2255-11ef-8e3f-d619fca54465',3,'adc06de1-bf5d-4b1a-81dc-e5e919328b7c','41f3f065cd7e37a929c8672ddff43bff15361cd2','software','CondorScan','2024-06-04 11:30:40.823','2024-06-04 09:30:40.823'),('1d6fbdf1-2fa5-11ef-8e5c-d61b03bfb54e',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','1c0d4273df8c673abbac77809c255ebb38156d16','software','CondorScan','2024-06-21 10:06:08.884','2024-06-21 08:06:08.884'),('1dd98135-224e-11ef-8e3f-d619fca54465',3,'adc06de1-bf5d-4b1a-81dc-e5e919328b7c','480d968747c48ff58d0a9a33e745366d78aca70f','software','CondorScan','2024-06-04 10:40:37.524','2024-06-04 08:40:39.765'),('1e534776-2edf-11ef-8f13-d8242a668461',11,'66d7dc11-0d36-4d25-9823-f7f0c1d1f38a','449a05ca10b8fc253db2dba5703b9b0189893086','software','CondorScan','2024-06-20 10:28:49.313','2024-06-20 08:28:49.314'),('1e8e559d-2e35-11ef-8deb-d515ea58f6cb',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','c2f525cdbcddac27a5aa69e32980177c060d653c','software','CondorScan','2024-06-19 14:11:55.901','2024-06-19 12:11:55.901'),('1f2e491b-28c6-11ef-8e16-d517f37fa2ad',5,'b35f432d-f5a0-4048-b2dc-1eb3596a89a1','911df765dce0520fb5f4c273c015f855438600ce','software','CondorScan','2024-06-12 16:14:46.353','2024-06-12 14:14:46.353'),('2575b2b2-272e-11ef-8e16-d517f37fa1ab',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','1ea3f9a9287cc51ecc3ed26980b1ebe1fbe83b62','software','CondorScan','2024-06-10 15:34:22.222','2024-06-10 13:34:22.222'),('27390705-23e0-11ef-8dde-d415e84cc4f5',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','4eb3cc9f614962c1041b6234ff12ec1f271b49e6','software','CondorScan','2024-06-06 10:38:30.947','2024-06-06 08:38:30.947'),('2a056ec5-2ee7-11ef-8f13-d8242a668461',3,'adc06de1-bf5d-4b1a-81dc-e5e919328b7c','b35b07c73ec4be636f8200f8eb8d49a898b0ef39','software','CondorScan','2024-06-20 11:26:24.909','2024-06-20 09:26:24.910'),('2b930de3-298f-11ef-8e16-d517f37fa2ad',11,'66d7dc11-0d36-4d25-9823-f7f0c1d1f38a','798857ff51b15a0911ae886e358dac4a6abdf708','software','CondorScan','2024-06-13 16:13:55.989','2024-06-13 14:13:55.989'),('2ba5d31b-2400-11ef-8dde-d415e84cc4f5',3,'adc06de1-bf5d-4b1a-81dc-e5e919328b7c','f92a940659eb0deb0a6e102b87344f5992da6541','software','CondorScan','2024-06-06 14:27:42.266','2024-06-06 12:27:42.266'),('34e8c612-2ef0-11ef-8f13-d8242a668461',11,'66d7dc11-0d36-4d25-9823-f7f0c1d1f38a','aa7079777c4e78237502051b5921f7ea8ebee058','software','CondorScan','2024-06-20 12:31:08.647','2024-06-20 10:31:08.647'),('37684838-28d2-11ef-8e16-d517f37fa2ad',5,'b35f432d-f5a0-4048-b2dc-1eb3596a89a1','0efcba4d9eea094ccc162c6069d0de7e61a3b49f','software','CondorScan','2024-06-12 17:41:20.959','2024-06-12 15:41:20.960'),('38cea7a7-226c-11ef-8d76-d310d2ec2c14',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','34809430528c79cf9822b59c3c23e86663675c6b','software','CondorScan','2024-06-04 14:16:07.665','2024-06-04 12:16:07.666'),('3977a2f4-2ee4-11ef-8f13-d8242a668461',11,'66d7dc11-0d36-4d25-9823-f7f0c1d1f38a','2d89588c51c90b3c45e60a72c422ccccabd85eeb','software','CondorScan','2024-06-20 11:05:22.333','2024-06-20 09:05:22.334'),('3b3c0908-2f03-11ef-8eca-d7201a246591',11,'66d7dc11-0d36-4d25-9823-f7f0c1d1f38a','16aa411aa0312814bb219a0777c7a9cdabb01625','software','CondorScan','2024-06-20 14:47:19.697','2024-06-20 12:47:19.697'),('3f72004c-2733-11ef-8e16-d517f37fa1ab',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','6f83b00c08a47b8a2c461476b92d524ebf3b1363','software','CondorScan','2024-06-10 16:10:53.302','2024-06-10 14:10:53.303'),('3fbe894a-28a1-11ef-8e16-d517f37fa2ad',10,'e777d5c7-3598-4093-b42c-8342c0d4d52e','5da464384bc4fed6577c0f458da25f502d6b63d0','software','CondorScan','2024-06-12 11:50:49.603','2024-06-12 09:50:50.598'),('3ff01800-298a-11ef-8e16-d517f37fa2ad',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','89b97ed302d1a9a891b6830abce489613474cff4','software','CondorScan','2024-06-13 15:38:42.669','2024-06-13 13:38:42.670'),('41b181bd-23e4-11ef-8dde-d415e84cc4f5',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','bf81d03d263219ae96d9cb6e83a900ad32a3dad1','software','CondorScan','2024-06-06 11:07:53.344','2024-06-06 09:07:53.344'),('46ae7c41-2e39-11ef-8deb-d515ea58f6cb',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','acacf0bd1ea792e0c919f4f61d151874209f2282','software','CondorScan','2024-06-19 14:41:41.207','2024-06-19 12:41:41.207'),('48285f69-23f9-11ef-8dde-d415e84cc4f5',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','ae74e177af0dd73dd6eb960450fe172a9234e4c2','software','CondorScan','2024-06-06 13:38:23.621','2024-06-06 11:38:23.621'),('483ca25b-23fe-11ef-8dde-d415e84cc4f5',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','d06c847b6762755e7e4b8969578da5a3bc62a66c','software','CondorScan','2024-06-06 14:14:11.237','2024-06-06 12:14:11.237'),('4eff7ca2-2257-11ef-8e3f-d619fca54465',3,'adc06de1-bf5d-4b1a-81dc-e5e919328b7c','38787bca40258835c23101468275f200014ef48d','software','CondorScan','2024-06-04 11:46:25.464','2024-06-04 09:46:25.464'),('4f1df941-28af-11ef-8e16-d517f37fa2ad',5,'b35f432d-f5a0-4048-b2dc-1eb3596a89a1','54ae6b009bbcc210afb3582770cdc1ebd763e24c','software','CondorScan','2024-06-12 13:31:28.352','2024-06-12 11:31:28.352'),('50ca58f1-2e2c-11ef-8deb-d515ea58f6cb',11,'66d7dc11-0d36-4d25-9823-f7f0c1d1f38a','19ed2b5e10be354f4d4a337e5f2bac93f38de0d8','software','CondorScan','2024-06-19 13:08:54.710','2024-06-19 11:08:54.710'),('530e99bf-298c-11ef-8e16-d517f37fa2ad',11,'66d7dc11-0d36-4d25-9823-f7f0c1d1f38a','1a1a543bef8ed3a71eb96f0a8557368470ebdcff','software','CondorScan','2024-06-13 15:53:33.740','2024-06-13 13:53:33.740'),('57018deb-2402-11ef-8dde-d415e84cc4f5',3,'adc06de1-bf5d-4b1a-81dc-e5e919328b7c','f8ef5f520e3afa83ec419242f8e96067bbc84c75','software','CondorScan','2024-06-06 14:43:14.003','2024-06-06 12:43:14.003'),('599151eb-27f1-11ef-8e37-d519fa9d22d2',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','11981fdddbe26b71972d6e9e4f9ab191110b40a2','software','CondorScan','2024-06-11 14:51:41.507','2024-06-11 12:51:41.507'),('5b53fb40-28a1-11ef-8e16-d517f37fa2ad',5,'b35f432d-f5a0-4048-b2dc-1eb3596a89a1','2f9ec5d8f3dfaea3df7bb1f7be769fb86212dde2','software','CondorScan','2024-06-12 11:51:35.885','2024-06-12 09:51:35.885'),('65e9eb4c-2a31-11ef-8f1c-d8242c6fa8fd',11,'95e1b195-3a24-4f05-9546-b8660fff20fe','6a348f0ed23869daa031bec9f997bc3a37e87a14','software','CondorScan','2024-06-14 11:35:13.856','2024-06-14 09:35:13.857'),('661e7126-28c3-11ef-8e16-d517f37fa2ad',5,'b35f432d-f5a0-4048-b2dc-1eb3596a89a1','82ac94278dfbe18495264e5701026bf9e6ee577d','software','CondorScan','2024-06-12 15:55:16.878','2024-06-12 13:55:16.878'),('67d29f9f-28b9-11ef-8e16-d517f37fa2ad',10,'e777d5c7-3598-4093-b42c-8342c0d4d52e','c358ea28503b0c59984e9ba0131844898fd9110e','software','CondorScan','2024-06-12 14:43:44.769','2024-06-12 12:43:44.769'),('689dbb1a-24b1-11ef-8dff-d516ef6b492c',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','e649e800b247ed2abb916fe744c0da2cd77fe76f','software','CondorScan','2024-06-07 11:36:25.475','2024-06-07 09:36:25.475'),('69db873d-2960-11ef-8e16-d517f37fa2ad',11,'66d7dc11-0d36-4d25-9823-f7f0c1d1f38a','848150cdfd64747582eb70cef06f8c0548c09b57','software','CondorScan','2024-06-13 10:39:14.133','2024-06-13 08:39:15.722'),('6b241148-23e7-11ef-8dde-d415e84cc4f5',3,'adc06de1-bf5d-4b1a-81dc-e5e919328b7c','f16775e227f3c69757d4f8b7d919f15084ba4c7b','software','CondorScan','2024-06-06 11:30:31.371','2024-06-06 09:30:31.371'),('6c7c7a35-2277-11ef-8d76-d310d2ec2c14',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','4125929fe65930e849ec894549e789ee242bf564','software','CondorScan','2024-06-04 15:36:18.832','2024-06-04 13:36:18.833'),('70a48f72-297d-11ef-8e16-d517f37fa2ad',11,'66d7dc11-0d36-4d25-9823-f7f0c1d1f38a','56a01af1a8f1701e1c956644edff6c18cba39f9f','software','CondorScan','2024-06-13 14:07:00.926','2024-06-13 12:07:00.926'),('7460ec4e-225a-11ef-8d76-d310d2ec2c14',3,'adc06de1-bf5d-4b1a-81dc-e5e919328b7c','72f0170cfc5fc4d4cfff7800e13be2c055422f74','software','CondorScan','2024-06-04 12:08:56.668','2024-06-04 10:08:56.669'),('75839c72-27f1-11ef-8e37-d519fa9d22d2',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','e6f1ac11b909aafa7c8b5768e48a3c54350371c2','software','CondorScan','2024-06-11 14:52:28.393','2024-06-11 12:52:28.393'),('796201e9-2271-11ef-8d76-d310d2ec2c14',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','dbdc7afccaf9114963e72b9a10c9dc2c6213a47e','software','CondorScan','2024-06-04 14:53:43.489','2024-06-04 12:53:43.489'),('7ba674ee-273d-11ef-8e09-d517f1736dc8',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','07cc9cd843f24b0e7f3c2989e17390cfd5f61f21','software','CondorScan','2024-06-10 17:24:09.277','2024-06-10 15:24:09.277'),('80eca6b0-296d-11ef-8e16-d517f37fa2ad',11,'66d7dc11-0d36-4d25-9823-f7f0c1d1f38a','997953c87c8324a8a821a418d9c3891914f6d93f','software','CondorScan','2024-06-13 12:12:56.294','2024-06-13 10:12:56.294'),('81268e01-2343-11ef-8f85-d92942ce45ec',3,'adc06de1-bf5d-4b1a-81dc-e5e919328b7c','159509e58f288db8aeed99866eab679bfe50bcde','software','CondorScan','2024-06-05 15:57:11.797','2024-06-05 13:57:11.797'),('81c9ef83-2257-11ef-8e3f-d619fca54465',3,'adc06de1-bf5d-4b1a-81dc-e5e919328b7c','abaa8c5256c58ae03329b31bcffc251cf0a4a366','software','CondorScan','2024-06-04 11:47:50.677','2024-06-04 09:47:50.677'),('81f1fd10-28c2-11ef-8e16-d517f37fa2ad',5,'b35f432d-f5a0-4048-b2dc-1eb3596a89a1','d944e10c39a248be7f0bdac41287c9d95ad1cc4f','software','CondorScan','2024-06-12 15:48:54.066','2024-06-12 13:48:54.066'),('839724a9-28b9-11ef-8e16-d517f37fa2ad',5,'b35f432d-f5a0-4048-b2dc-1eb3596a89a1','6fbb94fa371cffbc1879f07419d05560f9d2871b','software','CondorScan','2024-06-12 14:44:31.355','2024-06-12 12:44:31.356'),('83a19083-2e1e-11ef-8deb-d515ea58f6cb',11,'66d7dc11-0d36-4d25-9823-f7f0c1d1f38a','5ebf52cf50e499cdafb44df3af1f55a68268e252','software','CondorScan','2024-06-19 11:30:07.052','2024-06-19 09:30:07.052'),('83c5545b-27d1-11ef-8e37-d519fa9d22d2',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','9cd6ad7fb204b030efb054640b9cb64b5a4a71f7','software','CondorScan','2024-06-11 11:03:48.417','2024-06-11 09:03:48.417'),('84944d8d-226f-11ef-8d76-d310d2ec2c14',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','50df8dabe548b9cc6dcfb993d9d7e732c1eabe2b','software','CondorScan','2024-06-04 14:39:43.280','2024-06-04 12:39:43.280'),('85d610c5-297c-11ef-8e16-d517f37fa2ad',11,'66d7dc11-0d36-4d25-9823-f7f0c1d1f38a','3fd5f0eb7373f9e528e71e8d17f60530b73fdfe5','software','CondorScan','2024-06-13 14:00:26.985','2024-06-13 12:00:26.986'),('8a5c7c79-2968-11ef-8e16-d517f37fa2ad',11,'66d7dc11-0d36-4d25-9823-f7f0c1d1f38a','e66621807d545d026be13a9a3a150fe6e0c7d5d9','software','CondorScan','2024-06-13 11:37:24.643','2024-06-13 09:37:24.643'),('8db66658-2270-11ef-8d76-d310d2ec2c14',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','732aa59887a4d885b68cc79e92ee409c545646ca','software','CondorScan','2024-06-04 14:47:08.099','2024-06-04 12:47:08.099'),('8e022f6d-2e29-11ef-8deb-d515ea58f6cb',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','7eeaae427d2c522b7c5ec08326aa49c4f07acb44','software','CondorScan','2024-06-19 12:49:08.926','2024-06-19 10:49:08.934'),('8f078ee5-289c-11ef-8e16-d517f37fa2ad',5,'b35f432d-f5a0-4048-b2dc-1eb3596a89a1','1cbcb6dfe5fc8d9aa6807593166a56bbcc3b8424','software','CondorScan','2024-06-12 11:17:15.142','2024-06-12 09:17:15.142'),('9240b707-2e24-11ef-8deb-d515ea58f6cb',11,'66d7dc11-0d36-4d25-9823-f7f0c1d1f38a','e2d83fb660323d3148906d48b4d77d95c023e803','software','CondorScan','2024-06-19 12:13:28.563','2024-06-19 10:13:28.564'),('9342a0a6-298a-11ef-8e16-d517f37fa2ad',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','3cdd2bdffbef09e7d3febf7ed5060340badd5496','software','CondorScan','2024-06-13 15:41:02.461','2024-06-13 13:41:02.461'),('951b6da6-226b-11ef-8d76-d310d2ec2c14',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','73bf0e9314f12c4b8167d8886014290cfd29131e','software','CondorScan','2024-06-04 14:11:33.022','2024-06-04 12:11:34.164'),('97514ca7-2a28-11ef-8f1c-d8242c6fa8fd',11,'66d7dc11-0d36-4d25-9823-f7f0c1d1f38a','63229703e5129814f9a66dfac4655c4d90c3496d','software','CondorScan','2024-06-14 10:32:11.272','2024-06-14 08:32:11.272'),('977ba8a3-2891-11ef-8e16-d517f37fa2ad',5,'b35f432d-f5a0-4048-b2dc-1eb3596a89a1','061d0d1a9b8194eba168f71d0da721a4af8857f6','software','CondorScan','2024-06-12 09:58:44.860','2024-06-12 07:58:44.861'),('a03f9ec1-28c8-11ef-8e16-d517f37fa2ad',5,'b35f432d-f5a0-4048-b2dc-1eb3596a89a1','89989bf6138630cfdb97ca895eb76f90e9bf3948','software','CondorScan','2024-06-12 16:32:41.887','2024-06-12 14:32:41.887'),('a2b635d6-2ee6-11ef-8f13-d8242a668461',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','f1c7457333eafd010e86ab5f98f161b415198fb6','software','CondorScan','2024-06-20 11:22:37.898','2024-06-20 09:22:37.898'),('a79c4826-2cb6-11ef-8e27-d518f78fe3c8',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','2bcedb3fb33db9045ad4f86103bb06234baebe78','software','CondorScan','2024-06-17 16:34:07.948','2024-06-17 14:34:07.948'),('a9de5fb1-2fa4-11ef-8e5c-d61b03bfb54e',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','e66c5fbf71974903e1e0eef023aab670bf9cebf3','software','CondorScan','2024-06-21 10:02:54.993','2024-06-21 08:02:54.994'),('aa92f5e5-2896-11ef-8e16-d517f37fa2ad',5,'b35f432d-f5a0-4048-b2dc-1eb3596a89a1','288df0bf30379d3c68d7d6c369cd8634a260500c','software','CondorScan','2024-06-12 10:35:04.373','2024-06-12 08:35:04.373'),('abbc366b-28ce-11ef-8e16-d517f37fa2ad',5,'b35f432d-f5a0-4048-b2dc-1eb3596a89a1','b0104bb723924754a6db625329e58b881f584eb8','software','CondorScan','2024-06-12 17:15:58.138','2024-06-12 15:15:58.138'),('abd721db-27c8-11ef-8e37-d519fa9d22d2',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','1b1d626f643951682181fe1e9d2efc5741c41f5e','software','CondorScan','2024-06-11 10:00:30.172','2024-06-11 08:00:30.172'),('ac2cf6e8-296b-11ef-8e16-d517f37fa2ad',11,'66d7dc11-0d36-4d25-9823-f7f0c1d1f38a','c7d0c9b6a5defc1cb770c0f51e5d7105e52dc982','software','CondorScan','2024-06-13 11:59:49.864','2024-06-13 09:59:49.864'),('ac4f7eb9-27f1-11ef-8e37-d519fa9d22d2',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','630732acb73a314847a3b595c2f5ab848d37bd8c','software','CondorScan','2024-06-11 14:54:00.326','2024-06-11 12:54:00.327'),('b0e688bc-28d4-11ef-8e16-d517f37fa2ad',5,'b35f432d-f5a0-4048-b2dc-1eb3596a89a1','c69c07259a65aa5c1c4a9233e6eaf1c33e74a626','software','CondorScan','2024-06-12 17:59:03.785','2024-06-12 15:59:03.785'),('b207bcda-23de-11ef-8dde-d415e84cc4f5',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','2ba081dc18e2446e22a832b525060e406d92f18a','software','CondorScan','2024-06-06 10:28:04.833','2024-06-06 08:28:04.847'),('b20c4d17-28be-11ef-8e16-d517f37fa2ad',5,'b35f432d-f5a0-4048-b2dc-1eb3596a89a1','b8646a88a08c3dca2bef1561948eb135f98df5df','software','CondorScan','2024-06-12 15:21:36.782','2024-06-12 13:21:36.782'),('b20d7c6c-23dd-11ef-8dde-d415e84cc4f5',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','ff3a65d404244e62ea65141ffe5109774363a13f','software','CondorScan','2024-06-06 10:20:55.375','2024-06-06 08:20:55.375'),('b3a9279b-2974-11ef-8e16-d517f37fa2ad',11,'66d7dc11-0d36-4d25-9823-f7f0c1d1f38a','d779212a04b39a71fa1cf77fb8bb1d09c84bee01','software','CondorScan','2024-06-13 13:04:27.892','2024-06-13 11:04:27.892'),('b3f3d24b-2fa5-11ef-8e5c-d61b03bfb54e',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','352bce0749c53bc0851ad759b0afc6bb1cb39519','software','CondorScan','2024-06-21 10:10:21.408','2024-06-21 08:10:21.409'),('b5ebe87f-2743-11ef-8e09-d517f1736dc8',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','8c053a09bfde713393fbb641652a43e435b329c1','software','CondorScan','2024-06-10 18:08:44.020','2024-06-10 16:08:44.020'),('b7fdaffe-27c4-11ef-8e37-d519fa9d22d2',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','e2f3aa6ce17d8805292a8749c2b18fb31a1e4592','software','CondorScan','2024-06-11 09:32:12.570','2024-06-11 07:32:12.571'),('bbfb58e1-28c2-11ef-8e16-d517f37fa2ad',5,'b35f432d-f5a0-4048-b2dc-1eb3596a89a1','162102eecdd22355c26c71781346f7737d056059','software','CondorScan','2024-06-12 15:50:31.435','2024-06-12 13:50:31.435'),('bded5c20-225c-11ef-8d76-d310d2ec2c14',3,'adc06de1-bf5d-4b1a-81dc-e5e919328b7c','4e68f8bdbdcfbdbf0030d138ae64fab2118b93da','software','CondorScan','2024-06-04 12:25:19.056','2024-06-04 10:25:19.056'),('c07f18c4-2335-11ef-8f85-d92942ce45ec',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','50a87f14299c683e67b5e1925556d02ce2d38797','software','CondorScan','2024-06-05 14:18:45.119','2024-06-05 12:18:45.119'),('c37fdb76-2ef4-11ef-8f13-d8242a668461',11,'66d7dc11-0d36-4d25-9823-f7f0c1d1f38a','53bbe7fe310435f9bc6d53881df24e097172aa46','software','CondorScan','2024-06-20 13:03:45.861','2024-06-20 11:03:45.861'),('c4faaa9d-2898-11ef-8e16-d517f37fa2ad',3,'adc06de1-bf5d-4b1a-81dc-e5e919328b7c','896d983824ae8b5361353da928a8dda737299857','software','CondorScan','2024-06-12 10:50:07.667','2024-06-12 08:50:07.668'),('c65c9f08-2e3d-11ef-8deb-d515ea58f6cb',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','4f3140f1ea94e07f7ce41c19502c3d8c9c06c36c','software','CondorScan','2024-06-19 15:13:53.406','2024-06-19 13:13:53.406'),('cd0ceb0a-2272-11ef-8d76-d310d2ec2c14',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','f4199eddf528dfa00a6af959f5b3bac9480c804d','software','CondorScan','2024-06-04 15:03:13.356','2024-06-04 13:03:13.357'),('cd88f22e-2cab-11ef-8e27-d518f78fe3c8',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','12451e126a35cc527318c3547e69b5ba780d54ef','software','CondorScan','2024-06-17 15:16:27.110','2024-06-17 13:16:27.111'),('d59d09f3-296b-11ef-8e16-d517f37fa2ad',11,'66d7dc11-0d36-4d25-9823-f7f0c1d1f38a','063bb0597f6a17eac78a7e7300fbc4e93c39ac99','software','CondorScan','2024-06-13 12:00:59.385','2024-06-13 10:00:59.385'),('d65489e4-289b-11ef-8e16-d517f37fa2ad',5,'b35f432d-f5a0-4048-b2dc-1eb3596a89a1','cfe4644d1b285ed6402138bf58f533258aa94012','software','CondorScan','2024-06-12 11:12:05.268','2024-06-12 09:12:05.268'),('de0461f9-2254-11ef-8e3f-d619fca54465',5,'b35f432d-f5a0-4048-b2dc-1eb3596a89a1','8f107529a9ced6b1a9daeb41d4f43f2b3d09f09b','software','CondorScan','2024-06-04 11:28:56.916','2024-06-04 09:28:57.849'),('de0da682-23f8-11ef-8dde-d415e84cc4f5',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','c5d44fe78b29e25c7a76564f4f75b60c8090f6b8','software','CondorScan','2024-06-06 13:35:25.607','2024-06-06 11:35:25.607'),('de63465e-28b6-11ef-8e16-d517f37fa2ad',5,'b35f432d-f5a0-4048-b2dc-1eb3596a89a1','3a872aabe9d1bfda45862feaa467a1510a461399','software','CondorScan','2024-06-12 14:25:35.198','2024-06-12 12:25:35.198'),('e467e733-27ee-11ef-8e37-d519fa9d22d2',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','6fa118690bf17249c2189bf756a4c75d48c27f5e','software','CondorScan','2024-06-11 14:34:05.949','2024-06-11 12:34:05.949'),('e5134099-2731-11ef-8e16-d517f37fa1ab',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','a280bfdcd144a4f5153bbabf734520575c9ee62a','software','CondorScan','2024-06-10 16:01:12.190','2024-06-10 14:01:12.190'),('e8e0950c-2402-11ef-8dde-d415e84cc4f5',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','f5b33592fbbeec1c24a5f3b06f94ce16b797d316','software','CondorScan','2024-06-06 14:47:18.734','2024-06-06 12:47:18.734'),('ebee8574-227e-11ef-8d76-d310d2ec2c14',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','6cb87f38d6109178b201b89cdc2fb8f6fa7415d5','software','CondorScan','2024-06-04 16:29:59.127','2024-06-04 14:29:59.127'),('ef8c61b7-2e52-11ef-8deb-d515ea58f6cb',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','6995b6ef9f64383bf8a4eb5fa2a4611c29e523da','software','CondorScan','2024-06-19 17:45:21.937','2024-06-19 15:45:21.937'),('f3c970da-2732-11ef-8e16-d517f37fa1ab',5,'b35f432d-f5a0-4048-b2dc-1eb3596a89a1','0c755c45f1a7309e759081d630e075478d154a8b','software','CondorScan','2024-06-10 16:08:46.368','2024-06-10 14:08:46.369'),('f54a444d-289a-11ef-8e16-d517f37fa2ad',5,'b35f432d-f5a0-4048-b2dc-1eb3596a89a1','a70591bac52a2ee9e82b32d80518c524d393d225','software','CondorScan','2024-06-12 11:05:47.713','2024-06-12 09:05:47.713'),('f8b97563-2400-11ef-8dde-d415e84cc4f5',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','56003b4ae63fc946dd83edfa43b0039c92d28970','software','CondorScan','2024-06-06 14:33:26.327','2024-06-06 12:33:26.328'),('f967b87c-226f-11ef-8d76-d310d2ec2c14',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','47f43c04f064b1226912b1b383c147fd6cce3a39','software','CondorScan','2024-06-04 14:42:59.281','2024-06-04 12:42:59.281'),('fa644b00-23fa-11ef-8dde-d415e84cc4f5',3,'adc06de1-bf5d-4b1a-81dc-e5e919328b7c','17eecaf6d0d3da042bf527983d73748c8f4df90a','software','CondorScan','2024-06-06 13:50:32.144','2024-06-06 11:50:32.145'),('fbf3f7be-2955-11ef-8e16-d517f37fa2ad',5,'b35f432d-f5a0-4048-b2dc-1eb3596a89a1','cf11bbaf575d419eac990a2cf61cadc3f061645a','software','CondorScan','2024-06-13 09:24:34.780','2024-06-13 07:24:34.780'),('fd7ba11e-2e51-11ef-8deb-d515ea58f6cb',11,'66d7dc11-0d36-4d25-9823-f7f0c1d1f38a','943956d12a978c3427b6458c90f6ab432f99e4ec','software','CondorScan','2024-06-19 17:38:35.818','2024-06-19 15:38:35.819'),('fe59b898-23e0-11ef-8dde-d415e84cc4f5',3,'adc06de1-bf5d-4b1a-81dc-e5e919328b7c','57fa62a9dd550c7158336aa66a9a0fd9c07fad80','software','CondorScan','2024-06-06 10:44:31.871','2024-06-06 08:44:31.871'),('ff5586d1-2eec-11ef-8f13-d8242a668461',11,'66d7dc11-0d36-4d25-9823-f7f0c1d1f38a','635341ad1510c3cb9f4378a8bd5d9e2da604b50b','software','CondorScan','2024-06-20 12:08:10.273','2024-06-20 10:08:10.273');
/*!40000 ALTER TABLE `Token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `__db_version__`
--

DROP TABLE IF EXISTS `__db_version__`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `__db_version__` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `versionMajor` int(11) NOT NULL,
  `versionMinor` int(11) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `migrationFile` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `__db_version__`
--

LOCK TABLES `__db_version__` WRITE;
/*!40000 ALTER TABLE `__db_version__` DISABLE KEYS */;
INSERT INTO `__db_version__` VALUES (1,1,0,'v1.0','iris_application_1.0_create_application'),(2,1,1,'v1.1','iris_application_1.1_occlusion_pap'),(3,1,2,'v1.2','iris_application_1.2_occlusion_pre_preparation'),(4,1,3,'v1.3','iris_application_1.3_occlusion_rework'),(5,1,4,'v1.4','iris_application_1.4_scan_label'),(6,1,5,'v1.5','iris_application_1.5_order_delivery'),(7,1,6,'v1.6','iris_application_1.6_sheet_json'),(8,1,7,'v1.7','iris_application_1.7_config_patient_list'),(9,1,8,'v1.8','iris_application_1.8_metering'),(10,1,9,'v1.9','iris_application_1.9_segmentation'),(11,1,10,'v1.10','iris_application_1.10_analyse'),(12,1,11,'v1.11','iris_application_1.11_messages'),(13,1,12,'v1.12','iris_application_1.12_scan_sup'),(14,1,13,'v1.13','iris_application_1.13_config'),(15,1,14,'v1.14','iris_application_1.14_syncinfo'),(16,1,15,'v1.15','iris_application_1.15_pcid'),(17,1,16,'v1.16','iris_application_1.16_remove_label_occlusion_file');
/*!40000 ALTER TABLE `__db_version__` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping routines for database 'iris_application'
--
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
/*!50003 DROP FUNCTION IF EXISTS `fileMetadataToLabel` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8mb3_general_ci */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `fileMetadataToLabel`(metadata TEXT) RETURNS text CHARSET utf8mb4 COLLATE utf8mb4_general_ci
    NO SQL
BEGIN
    IF metadata LIKE '%scanBodies%' THEN RETURN 'SCANBODY'; END IF;

    RETURN 'SCAN';
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewOcclusionFileType` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8mb3_general_ci */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewOcclusionFileType`(oldType TEXT) RETURNS text CHARSET utf8mb4 COLLATE utf8mb4_general_ci
    NO SQL
BEGIN
    IF oldType = 'MANDIBLE' THEN RETURN 'MANDIBLE_1'; END IF;

    IF oldType = 'MANDIBLE_SB' THEN RETURN 'MANDIBLE_2'; END IF;

    IF oldType = 'MANDIBLE_PRE' THEN RETURN 'MANDIBLE_3'; END IF;

    IF oldType = 'MANDIBLE_SUP' THEN RETURN 'MANDIBLE_4'; END IF;

    IF oldType = 'MAXILLARY' THEN RETURN 'MAXILLARY_1'; END IF;

    IF oldType = 'MAXILLARY_SB' THEN RETURN 'MAXILLARY_2'; END IF;

    IF oldType = 'MAXILLARY_PRE' THEN RETURN 'MAXILLARY_3'; END IF;

    IF oldType = 'MAXILLARY_SUP' THEN RETURN 'MAXILLARY_4'; END IF;

    RETURN oldType;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewProstheticContactPoint` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8mb3_general_ci */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewProstheticContactPoint`(old TEXT) RETURNS int(11)
    NO SQL
BEGIN
    IF old = '2' THEN RETURN 0; END IF;
    IF old = '3' THEN RETURN 1; END IF;
    IF old = '4' THEN RETURN 2; END IF;
    RETURN 1;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewProstheticCrownOrBridgeSubType` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8mb3_general_ci */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewProstheticCrownOrBridgeSubType`(old TEXT) RETURNS int(11)
    NO SQL
BEGIN
    IF old = '1' THEN RETURN 0; END IF;
    IF old = '2' THEN RETURN 1; END IF;
    IF old = '3' THEN RETURN 2; END IF;
    RETURN 0;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewProstheticGouttiereSubType` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8mb3_general_ci */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewProstheticGouttiereSubType`(old TEXT) RETURNS int(11)
    NO SQL
BEGIN
    IF old = '1' THEN RETURN 1; END IF;
    IF old = '2' THEN RETURN 2; END IF;
    IF old = '3' THEN RETURN 3; END IF;
    IF old = '4' THEN RETURN 0; END IF;
    IF old = '5' THEN RETURN 4; END IF;
    IF old = '6' THEN RETURN 5; END IF;
    IF old = '7' THEN RETURN 6; END IF;
    RETURN 0;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewProstheticImplantCrownSubType` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8mb3_general_ci */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewProstheticImplantCrownSubType`(old TEXT) RETURNS int(11)
    NO SQL
BEGIN
    IF old = '1' THEN RETURN 0; END IF;
    IF old = '2' THEN RETURN 1; END IF;
    IF old = '3' THEN RETURN 0; END IF;
    IF old = '4' THEN RETURN 1; END IF;
    RETURN 2;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewProstheticInlayOnlaySubType` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8mb3_general_ci */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewProstheticInlayOnlaySubType`(old TEXT) RETURNS int(11)
    NO SQL
BEGIN
    IF old = '1' THEN RETURN 0; END IF;
    IF old = '2' THEN RETURN 1; END IF;
    RETURN 2;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
/*!50003 DROP FUNCTION IF EXISTS `scanMetadataToLabel` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8mb3_general_ci */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `scanMetadataToLabel`(metadata TEXT) RETURNS text CHARSET utf8mb4 COLLATE utf8mb4_general_ci
    NO SQL
BEGIN
    IF metadata LIKE '%"isPrePreparation":true%' THEN RETURN 'PRE_PREPARATION'; END IF;

    RETURN 'SCAN';
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2024-06-21 10:15:12
