-- MariaDB dump 10.19  Distrib 10.6.16-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: localhost    Database: iris_client
-- ------------------------------------------------------
-- Server version	10.6.16-MariaDB-0ubuntu0.22.04.1

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `Camera`
--

DROP TABLE IF EXISTS `Camera`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Camera` (
  `reference` char(13) NOT NULL,
  PRIMARY KEY (`reference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Camera`
--

LOCK TABLES `Camera` WRITE;
/*!40000 ALTER TABLE `Camera` DISABLE KEYS */;
INSERT INTO `Camera` VALUES ('666'),('Fake');
/*!40000 ALTER TABLE `Camera` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CameraAccess`
--

DROP TABLE IF EXISTS `CameraAccess`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `CameraAccess` (
  `professionalId` mediumint(8) unsigned NOT NULL,
  `computerMac` char(17) NOT NULL,
  `cameraReference` char(13) NOT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`professionalId`,`computerMac`,`cameraReference`),
  KEY `computerMac` (`computerMac`),
  KEY `cameraReference` (`cameraReference`),
  CONSTRAINT `CameraAccess_ibfk_1` FOREIGN KEY (`professionalId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `CameraAccess_ibfk_2` FOREIGN KEY (`computerMac`) REFERENCES `Computer` (`mac`) ON UPDATE CASCADE,
  CONSTRAINT `CameraAccess_ibfk_3` FOREIGN KEY (`cameraReference`) REFERENCES `Camera` (`reference`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CameraAccess`
--

LOCK TABLES `CameraAccess` WRITE;
/*!40000 ALTER TABLE `CameraAccess` DISABLE KEYS */;
INSERT INTO `CameraAccess` VALUES (2,'00:d8:61:09:28:5c','666','2024-06-04 12:11:34.166','2024-06-04 14:11:34.327'),(2,'00:d8:61:09:28:5c','Fake','2024-06-19 07:24:48.360',NULL),(3,'00:d8:61:09:28:5c','666','2024-06-04 10:08:56.969','2024-06-04 12:08:57.488'),(5,'00:d8:61:09:28:5c','666','2024-06-10 14:08:46.863','2024-06-10 16:08:47.234'),(10,'00:d8:61:09:28:5c','666','2024-06-12 09:50:50.603','2024-06-12 11:50:50.755'),(11,'00:d8:61:09:28:5c','666','2024-06-13 08:39:15.725','2024-06-13 10:39:15.887'),(11,'00:d8:61:09:28:5c','Fake','2024-06-19 07:22:40.993','2024-06-19 11:30:07.678');
/*!40000 ALTER TABLE `CameraAccess` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Computer`
--

DROP TABLE IF EXISTS `Computer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Computer` (
  `mac` char(76) NOT NULL,
  `condorVersionId` varchar(16) DEFAULT NULL,
  `graphicsCard` varchar(50) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`mac`),
  KEY `condorVersionId` (`condorVersionId`),
  CONSTRAINT `Computer_ibfk_1` FOREIGN KEY (`condorVersionId`) REFERENCES `CondorVersion` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Computer`
--

LOCK TABLES `Computer` WRITE;
/*!40000 ALTER TABLE `Computer` DISABLE KEYS */;
INSERT INTO `Computer` VALUES ('00:d8:61:09:28:5c','v4.0.1','NVIDIA GeForce RTX 2070 with Max-Q Design','2024-07-19 09:47:04.894','2024-06-19 11:30:07.678');
/*!40000 ALTER TABLE `Computer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CondorVersion`
--

DROP TABLE IF EXISTS `CondorVersion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `CondorVersion` (
  `id` varchar(16) NOT NULL,
  `dbVersion` varchar(10) DEFAULT NULL,
  `ihmVersion` varchar(10) DEFAULT NULL,
  `coreVersion` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CondorVersion`
--

LOCK TABLES `CondorVersion` WRITE;
/*!40000 ALTER TABLE `CondorVersion` DISABLE KEYS */;
INSERT INTO `CondorVersion` VALUES ('v4.0.1','','','');
/*!40000 ALTER TABLE `CondorVersion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `License`
--

DROP TABLE IF EXISTS `License`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `License` (
  `number` char(23) NOT NULL,
  `professionalId` mediumint(8) unsigned NOT NULL,
  `enabled` enum('NONE','SOFTWARE','WEB','ALL') NOT NULL DEFAULT 'ALL',
  `licenseType` enum('PROD','DEMO') NOT NULL DEFAULT 'PROD',
  PRIMARY KEY (`number`),
  KEY `professionalId` (`professionalId`),
  CONSTRAINT `License_ibfk_1` FOREIGN KEY (`professionalId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `License`
--

LOCK TABLES `License` WRITE;
/*!40000 ALTER TABLE `License` DISABLE KEYS */;
INSERT INTO `License` VALUES ('00000000000000000000001',2,'ALL','PROD'),('00000000000000000000002',3,'ALL','PROD'),('00000000000000000000004',5,'ALL','PROD'),('00000000000000000000005',10,'ALL','PROD'),('00000000000000000000020',11,'ALL','PROD');
/*!40000 ALTER TABLE `License` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `LicenseAccess`
--

DROP TABLE IF EXISTS `LicenseAccess`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `LicenseAccess` (
  `professionalId` mediumint(8) unsigned NOT NULL,
  `licenseNumber` char(23) NOT NULL,
  `computerMac` char(17) NOT NULL,
  `condorVersionId` varchar(16) NOT NULL,
  `globalId` mediumint(8) unsigned DEFAULT NULL,
  `status` enum('VALID','REPAIR') NOT NULL DEFAULT 'VALID',
  `activationDate` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`professionalId`,`licenseNumber`,`computerMac`),
  KEY `licenseNumber` (`licenseNumber`),
  KEY `computerMac` (`computerMac`),
  KEY `condorVersionId` (`condorVersionId`),
  CONSTRAINT `LicenseAccess_ibfk_1` FOREIGN KEY (`professionalId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `LicenseAccess_ibfk_2` FOREIGN KEY (`licenseNumber`) REFERENCES `License` (`number`) ON UPDATE CASCADE,
  CONSTRAINT `LicenseAccess_ibfk_3` FOREIGN KEY (`computerMac`) REFERENCES `Computer` (`mac`) ON UPDATE CASCADE,
  CONSTRAINT `LicenseAccess_ibfk_4` FOREIGN KEY (`condorVersionId`) REFERENCES `CondorVersion` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LicenseAccess`
--

LOCK TABLES `LicenseAccess` WRITE;
/*!40000 ALTER TABLE `LicenseAccess` DISABLE KEYS */;
INSERT INTO `LicenseAccess` VALUES (2,'00000000000000000000001','00:d8:61:09:28:5c','v4.0.1',2,'VALID','2024-06-04 14:11:33.000','2024-06-04 12:11:34.151','2024-06-04 14:11:34.151'),(3,'00000000000000000000002','00:d8:61:09:28:5c','v4.0.1',1,'VALID','2024-06-04 10:40:39.000','2024-06-04 08:40:39.708','2024-06-04 10:40:39.708'),(5,'00000000000000000000004','00:d8:61:09:28:5c','v4.0.1',1,'VALID','2024-06-04 11:28:58.000','2024-06-10 14:08:46.845','2024-06-10 16:08:46.845'),(10,'00000000000000000000005','00:d8:61:09:28:5c','v4.0.1',1,'VALID','2024-06-12 11:50:51.000','2024-06-12 12:41:10.840','2024-06-12 14:41:10.840'),(11,'00000000000000000000020','00:d8:61:09:28:5c','v4.0.1',1,'VALID','2024-06-13 10:39:16.000','2024-06-13 09:37:24.911','2024-06-13 11:37:24.911');
/*!40000 ALTER TABLE `LicenseAccess` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Professional`
--

DROP TABLE IF EXISTS `Professional`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Professional` (
  `id` mediumint(8) unsigned NOT NULL,
  `firstName` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `mainPhone` varchar(45) DEFAULT NULL,
  `country` varchar(75) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Professional`
--

LOCK TABLES `Professional` WRITE;
/*!40000 ALTER TABLE `Professional` DISABLE KEYS */;
INSERT INTO `Professional` VALUES (2,'sabine','casertz','645636587','France'),(3,'succursalle Salles d\'aude','laboratoire scan4all','1234567','France'),(5,'demo4','demo4env2','6543567543355667787','United States of America'),(10,'User_demo5','Env2','98345678','France'),(11,'simone','scalzo','12345678','France');
/*!40000 ALTER TABLE `Professional` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `__db_version__`
--

DROP TABLE IF EXISTS `__db_version__`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `__db_version__` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `versionMajor` int(11) NOT NULL,
  `versionMinor` int(11) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `migrationFile` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `__db_version__`
--

LOCK TABLES `__db_version__` WRITE;
/*!40000 ALTER TABLE `__db_version__` DISABLE KEYS */;
INSERT INTO `__db_version__` VALUES (1,1,0,'v1.0','iris_client_1.0_create_client');
/*!40000 ALTER TABLE `__db_version__` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping routines for database 'iris_client'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2024-07-19 14:10:57
