-- MariaDB dump 10.19  Distrib 10.6.16-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: localhost    Database: iris_client
-- ------------------------------------------------------
-- Server version	10.6.16-MariaDB-0ubuntu0.22.04.1

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `Camera`
--

DROP TABLE IF EXISTS `Camera`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Camera` (
  `reference` char(13) NOT NULL,
  PRIMARY KEY (`reference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Camera`
--

LOCK TABLES `Camera` WRITE;
/*!40000 ALTER TABLE `Camera` DISABLE KEYS */;
INSERT INTO `Camera` VALUES ('2118022WO2358'),('2118022WO2371'),('2118022WO2433'),('666'),('Fake');
/*!40000 ALTER TABLE `Camera` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CameraAccess`
--

DROP TABLE IF EXISTS `CameraAccess`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `CameraAccess` (
  `professionalId` mediumint(8) unsigned NOT NULL,
  `computerMac` char(17) NOT NULL,
  `cameraReference` char(13) NOT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`professionalId`,`computerMac`,`cameraReference`),
  KEY `computerMac` (`computerMac`),
  KEY `cameraReference` (`cameraReference`),
  CONSTRAINT `CameraAccess_ibfk_1` FOREIGN KEY (`professionalId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `CameraAccess_ibfk_2` FOREIGN KEY (`computerMac`) REFERENCES `Computer` (`mac`) ON UPDATE CASCADE,
  CONSTRAINT `CameraAccess_ibfk_3` FOREIGN KEY (`cameraReference`) REFERENCES `Camera` (`reference`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CameraAccess`
--

LOCK TABLES `CameraAccess` WRITE;
/*!40000 ALTER TABLE `CameraAccess` DISABLE KEYS */;
INSERT INTO `CameraAccess` VALUES (2,'00:d8:61:09:28:9c','2118022WO2358','2024-03-18 15:19:47.288','2024-03-18 16:19:47.946'),(2,'00:d8:61:09:28:9c','2118022WO2371','2023-10-13 13:49:26.289','2023-10-13 15:49:26.775'),(2,'00:d8:61:09:28:9c','2118022WO2433','2024-02-22 10:38:48.721','2024-02-22 11:38:49.526'),(2,'00:d8:61:09:28:9c','666','2023-10-23 08:54:36.760','2023-10-23 10:54:37.491'),(2,'00:d8:61:09:28:9c','Fake','2023-11-10 09:58:06.463','2023-11-10 10:58:07.224'),(11,'00:d8:61:09:28:9c','2118022WO2358','2024-03-18 15:58:33.448','2024-03-18 16:58:33.762'),(11,'00:d8:61:09:28:9c','2118022WO2371','2024-02-23 14:50:01.425','2024-02-23 15:50:01.616'),(16,'00:d8:61:09:28:9c','2118022WO2358','2024-03-18 16:06:13.054','2024-03-18 17:06:13.245'),(16,'00:d8:61:09:28:9c','2118022WO2371','2024-03-20 15:03:09.614','2024-03-20 16:03:10.105'),(17,'00:d8:61:09:28:9c','2118022WO2371','2024-03-20 14:52:41.751','2024-03-20 15:52:41.913');
/*!40000 ALTER TABLE `CameraAccess` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Computer`
--

DROP TABLE IF EXISTS `Computer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Computer` (
  `mac` char(76) NOT NULL,
  `condorVersionId` varchar(16) DEFAULT NULL,
  `graphicsCard` varchar(50) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`mac`),
  KEY `condorVersionId` (`condorVersionId`),
  CONSTRAINT `Computer_ibfk_1` FOREIGN KEY (`condorVersionId`) REFERENCES `CondorVersion` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Computer`
--

LOCK TABLES `Computer` WRITE;
/*!40000 ALTER TABLE `Computer` DISABLE KEYS */;
INSERT INTO `Computer` VALUES ('00:d8:61:09:28:9c','v4.0.1','NVIDIA GeForce RTX 2070 with Max-Q Design','2024-04-12 08:42:37.424','2024-03-20 16:03:10.105');
/*!40000 ALTER TABLE `Computer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CondorVersion`
--

DROP TABLE IF EXISTS `CondorVersion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `CondorVersion` (
  `id` varchar(16) NOT NULL,
  `dbVersion` varchar(10) DEFAULT NULL,
  `ihmVersion` varchar(10) DEFAULT NULL,
  `coreVersion` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CondorVersion`
--

LOCK TABLES `CondorVersion` WRITE;
/*!40000 ALTER TABLE `CondorVersion` DISABLE KEYS */;
INSERT INTO `CondorVersion` VALUES ('v4.0.1','','','');
/*!40000 ALTER TABLE `CondorVersion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `License`
--

DROP TABLE IF EXISTS `License`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `License` (
  `number` char(23) NOT NULL,
  `professionalId` mediumint(8) unsigned NOT NULL,
  `enabled` enum('NONE','SOFTWARE','WEB','ALL') NOT NULL DEFAULT 'ALL',
  `licenseType` enum('PROD','DEMO') NOT NULL DEFAULT 'PROD',
  PRIMARY KEY (`number`),
  KEY `professionalId` (`professionalId`),
  CONSTRAINT `License_ibfk_1` FOREIGN KEY (`professionalId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `License`
--

LOCK TABLES `License` WRITE;
/*!40000 ALTER TABLE `License` DISABLE KEYS */;
INSERT INTO `License` VALUES ('00000000000000000000001',2,'ALL','PROD'),('00000000000000000000005',11,'ALL','PROD'),('00000000000000000000006',16,'ALL','PROD'),('00000000000000000000007',17,'ALL','PROD'),('00000000000000000000101',13,'ALL','PROD');
/*!40000 ALTER TABLE `License` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `LicenseAccess`
--

DROP TABLE IF EXISTS `LicenseAccess`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `LicenseAccess` (
  `professionalId` mediumint(8) unsigned NOT NULL,
  `licenseNumber` char(23) NOT NULL,
  `computerMac` char(17) NOT NULL,
  `condorVersionId` varchar(16) NOT NULL,
  `globalId` mediumint(8) unsigned DEFAULT NULL,
  `status` enum('VALID','REPAIR') NOT NULL DEFAULT 'VALID',
  `activationDate` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`professionalId`,`licenseNumber`,`computerMac`),
  KEY `licenseNumber` (`licenseNumber`),
  KEY `computerMac` (`computerMac`),
  KEY `condorVersionId` (`condorVersionId`),
  CONSTRAINT `LicenseAccess_ibfk_1` FOREIGN KEY (`professionalId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `LicenseAccess_ibfk_2` FOREIGN KEY (`licenseNumber`) REFERENCES `License` (`number`) ON UPDATE CASCADE,
  CONSTRAINT `LicenseAccess_ibfk_3` FOREIGN KEY (`computerMac`) REFERENCES `Computer` (`mac`) ON UPDATE CASCADE,
  CONSTRAINT `LicenseAccess_ibfk_4` FOREIGN KEY (`condorVersionId`) REFERENCES `CondorVersion` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LicenseAccess`
--

LOCK TABLES `LicenseAccess` WRITE;
/*!40000 ALTER TABLE `LicenseAccess` DISABLE KEYS */;
INSERT INTO `LicenseAccess` VALUES (2,'00000000000000000000001','00:d8:61:09:28:9c','v4.0.1',1,'VALID','2023-10-13 15:41:19.000','2023-10-13 13:41:19.956','2023-10-13 15:41:19.956'),(11,'00000000000000000000005','00:d8:61:09:28:9c','v4.0.1',2,'VALID','2024-02-06 16:46:10.000','2024-02-06 15:46:10.387','2024-02-06 16:46:10.387'),(13,'00000000000000000000101','00:d8:61:09:28:9c','v4.0.1',1,'VALID','2024-02-16 15:35:33.000','2024-02-16 14:35:33.688','2024-02-16 15:35:33.688'),(16,'00000000000000000000006','00:d8:61:09:28:9c','v4.0.1',1,'VALID','2024-03-18 17:06:12.000','2024-03-18 16:06:13.033','2024-03-18 17:06:13.033'),(17,'00000000000000000000007','00:d8:61:09:28:9c','v4.0.1',1,'VALID','2024-03-20 15:52:41.000','2024-03-20 14:52:41.736','2024-03-20 15:52:41.736');
/*!40000 ALTER TABLE `LicenseAccess` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Professional`
--

DROP TABLE IF EXISTS `Professional`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Professional` (
  `id` mediumint(8) unsigned NOT NULL,
  `firstName` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `mainPhone` varchar(45) DEFAULT NULL,
  `country` varchar(75) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Professional`
--

LOCK TABLES `Professional` WRITE;
/*!40000 ALTER TABLE `Professional` DISABLE KEYS */;
INSERT INTO `Professional` VALUES (2,'iris','scan4all','645636587','France'),(11,'sabine','caserta','123456','France'),(13,'samantha','marino','0619482723','France'),(16,'deux','destinataire','123','France'),(17,'t','t','az','France');
/*!40000 ALTER TABLE `Professional` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `__db_version__`
--

DROP TABLE IF EXISTS `__db_version__`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `__db_version__` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `versionMajor` int(11) NOT NULL,
  `versionMinor` int(11) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `migrationFile` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `__db_version__`
--

LOCK TABLES `__db_version__` WRITE;
/*!40000 ALTER TABLE `__db_version__` DISABLE KEYS */;
INSERT INTO `__db_version__` VALUES (1,1,0,'v1.0','migration_db_client_1.0_create_client');
/*!40000 ALTER TABLE `__db_version__` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping routines for database 'iris_client'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2024-04-12 10:43:49
