-- MariaDB dump 10.19  Distrib 10.6.16-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: localhost    Database: iris_application
-- ------------------------------------------------------
-- Server version	10.6.16-MariaDB-0ubuntu0.22.04.1

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `Act`
--

DROP TABLE IF EXISTS `Act`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Act` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `patientId` varchar(36) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `displayId` mediumint(8) unsigned DEFAULT NULL,
  `workflow` enum('FREE','WORKFLOW_1','WORKFLOW_2','WORKFLOW_3','ANALYSE') NOT NULL DEFAULT 'FREE',
  `comments` text DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT 0,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastAccessed` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `patientId` (`patientId`),
  CONSTRAINT `Act_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `Act_ibfk_2` FOREIGN KEY (`patientId`) REFERENCES `iris_patient`.`Patient` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Act`
--

LOCK TABLES `Act` WRITE;
/*!40000 ALTER TABLE `Act` DISABLE KEYS */;
INSERT INTO `Act` VALUES ('1fcf39f6-086d-11ef-8ff6-da2f5a35fe58',3,'00c2d95b-06ed-11ef-90c8-dd3986f53a42','Commande 1.1.5.1',5,'FREE','',0,'2024-05-02 12:17:04.990',NULL,'2024-05-02 12:17:59.727','2024-05-02 12:18:12.159','2024-05-02 10:18:12.160','2024-05-02 12:18:12.162'),('4dd3e575-06ed-11ef-90c8-dd3986f53a42',3,'00c2d95b-06ed-11ef-90c8-dd3986f53a42','Commande 1.1.1.1',1,'FREE','',0,'2024-04-30 14:29:35.452',NULL,'2024-04-30 14:30:35.312','2024-04-30 14:29:35.468','2024-04-30 12:30:35.312','2024-04-30 14:30:35.322'),('58e7015d-0861-11ef-8ff6-da2f5a35fe58',3,'00c2d95b-06ed-11ef-90c8-dd3986f53a42','Commande 1.1.2.1',2,'FREE','',0,'2024-05-02 10:52:46.816',NULL,'2024-05-02 12:10:20.437','2024-05-02 10:52:46.823','2024-05-02 10:10:20.438','2024-05-02 12:10:20.447'),('89504286-086c-11ef-8ff6-da2f5a35fe58',3,'00c2d95b-06ed-11ef-90c8-dd3986f53a42','Analyse 1.1.4',4,'ANALYSE','',0,'2024-05-02 12:12:52.500',NULL,'2024-05-02 12:12:52.524','2024-05-02 12:12:55.589','2024-05-02 10:12:55.589','2024-05-02 12:12:55.591'),('9fff6be0-0868-11ef-8ff6-da2f5a35fe58',3,'00c2d95b-06ed-11ef-90c8-dd3986f53a42','Commande 1.1.3.1',3,'WORKFLOW_1','',0,'2024-05-02 11:44:52.571',NULL,'2024-05-02 12:16:59.880','2024-05-02 11:44:52.588','2024-05-02 10:16:59.881','2024-05-02 12:16:59.890');
/*!40000 ALTER TABLE `Act` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AddressInfo`
--

DROP TABLE IF EXISTS `AddressInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `AddressInfo` (
  `uuid` varchar(36) NOT NULL,
  `line0` varchar(255) DEFAULT NULL,
  `line1` varchar(255) DEFAULT NULL,
  `line2` varchar(255) DEFAULT NULL,
  `detail` varchar(255) DEFAULT NULL,
  `cityName` varchar(255) DEFAULT NULL,
  `cityState` varchar(255) DEFAULT NULL,
  `cityZip` varchar(255) DEFAULT NULL,
  `countryName` varchar(255) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AddressInfo`
--

LOCK TABLES `AddressInfo` WRITE;
/*!40000 ALTER TABLE `AddressInfo` DISABLE KEYS */;
INSERT INTO `AddressInfo` VALUES ('4caacc66-8838-11ec-89bc-2e174fce41cd','Route du test','','','','Toulouse','','31100','France','2024-04-30 12:26:31.655','2024-04-30 14:26:29.000'),('67cbd5eb-5e68-4f9b-9a15-2b1a0dabbcef','site dev','','','','labege','','31670','France','2024-04-30 12:26:30.919','2024-04-30 14:26:29.000'),('a5e85963-fe76-4488-a34e-59cf90eee3e0','137 rue Garance','','','','Labège','','31670','France','2024-04-30 12:34:01.222','2024-04-30 14:37:26.000'),('b920f641-ec66-47f2-b374-25b1f9188d1d','','','','','labege','','','','2024-05-02 09:32:34.143','2024-05-02 11:33:13.000');
/*!40000 ALTER TABLE `AddressInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Analyse`
--

DROP TABLE IF EXISTS `Analyse`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Analyse` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `actId` varchar(36) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `type` enum('METERING','COMPARE') NOT NULL DEFAULT 'METERING',
  `displayId` mediumint(8) unsigned DEFAULT NULL,
  `comments` text DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `actId` (`actId`),
  CONSTRAINT `Analyse_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `Analyse_ibfk_2` FOREIGN KEY (`actId`) REFERENCES `Act` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Analyse`
--

LOCK TABLES `Analyse` WRITE;
/*!40000 ALTER TABLE `Analyse` DISABLE KEYS */;
INSERT INTO `Analyse` VALUES ('895411ef-086c-11ef-8ff6-da2f5a35fe58',3,'89504286-086c-11ef-8ff6-da2f5a35fe58','','METERING',1,'{\"referenceScanId\":\"be43909f-0868-11ef-8ff6-da2f5a35fe58\"}','2024-05-02 12:12:52.525',NULL,'2024-05-02 10:12:55.584','2024-05-02 12:12:55.980');
/*!40000 ALTER TABLE `Analyse` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AnalyseFile`
--

DROP TABLE IF EXISTS `AnalyseFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `AnalyseFile` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `analyseId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('TRANSFORMATION','SNAPSHOT','SCREENSHOT','METERING','RESULT') NOT NULL,
  PRIMARY KEY (`analyseId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `AnalyseFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `AnalyseFile_ibfk_2` FOREIGN KEY (`analyseId`) REFERENCES `Analyse` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `AnalyseFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AnalyseFile`
--

LOCK TABLES `AnalyseFile` WRITE;
/*!40000 ALTER TABLE `AnalyseFile` DISABLE KEYS */;
INSERT INTO `AnalyseFile` VALUES (3,'895411ef-086c-11ef-8ff6-da2f5a35fe58','8b26c5be-086c-11ef-8ff6-da2f5a35fe58','TRANSFORMATION'),(3,'895411ef-086c-11ef-8ff6-da2f5a35fe58','8b60cf5e-086c-11ef-8ff6-da2f5a35fe58','SNAPSHOT'),(3,'895411ef-086c-11ef-8ff6-da2f5a35fe58','fc095480-086c-11ef-8ff6-da2f5a35fe58','METERING');
/*!40000 ALTER TABLE `AnalyseFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AnalyseScan`
--

DROP TABLE IF EXISTS `AnalyseScan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `AnalyseScan` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `analyseId` varchar(36) NOT NULL,
  `scanId` varchar(36) NOT NULL,
  PRIMARY KEY (`analyseId`,`scanId`),
  KEY `ownerId` (`ownerId`),
  KEY `scanId` (`scanId`),
  CONSTRAINT `AnalyseScan_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `AnalyseScan_ibfk_2` FOREIGN KEY (`analyseId`) REFERENCES `Analyse` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `AnalyseScan_ibfk_3` FOREIGN KEY (`scanId`) REFERENCES `Scan` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AnalyseScan`
--

LOCK TABLES `AnalyseScan` WRITE;
/*!40000 ALTER TABLE `AnalyseScan` DISABLE KEYS */;
INSERT INTO `AnalyseScan` VALUES (3,'895411ef-086c-11ef-8ff6-da2f5a35fe58','be43909f-0868-11ef-8ff6-da2f5a35fe58');
/*!40000 ALTER TABLE `AnalyseScan` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Assistant`
--

DROP TABLE IF EXISTS `Assistant`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Assistant` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `credentialsId` varchar(36) DEFAULT NULL,
  `personInfoId` varchar(36) NOT NULL,
  `phoneInfoId` varchar(36) NOT NULL,
  `addressInfoId` varchar(36) NOT NULL,
  `officeId` varchar(36) DEFAULT NULL,
  `patientRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'READ_ONLY',
  `actRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'NOTHING',
  `discussionRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'NOTHING',
  `tempPassword` varchar(32) DEFAULT NULL,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `credentialsId` (`credentialsId`),
  KEY `personInfoId` (`personInfoId`),
  KEY `phoneInfoId` (`phoneInfoId`),
  KEY `addressInfoId` (`addressInfoId`),
  KEY `officeId` (`officeId`),
  CONSTRAINT `Assistant_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_2` FOREIGN KEY (`credentialsId`) REFERENCES `Credentials` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_3` FOREIGN KEY (`personInfoId`) REFERENCES `PersonInfo` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_4` FOREIGN KEY (`phoneInfoId`) REFERENCES `PhoneInfo` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_5` FOREIGN KEY (`addressInfoId`) REFERENCES `AddressInfo` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_6` FOREIGN KEY (`officeId`) REFERENCES `Office` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Assistant`
--

LOCK TABLES `Assistant` WRITE;
/*!40000 ALTER TABLE `Assistant` DISABLE KEYS */;
/*!40000 ALTER TABLE `Assistant` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CircleOrder`
--

DROP TABLE IF EXISTS `CircleOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `CircleOrder` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `actId` varchar(36) NOT NULL,
  `title` varchar(64) DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT 0,
  `createdById` varchar(36) DEFAULT NULL,
  `updatedById` varchar(36) DEFAULT NULL,
  `displayId` mediumint(8) unsigned DEFAULT NULL,
  `json` text NOT NULL,
  `metadata` text NOT NULL,
  `status` enum('NOT_SENT','WAITING_WOW_API','SENDING_WOW_API','SENDING_CIRCLE_API','SENT','CANCELLED','DELIVERY') NOT NULL DEFAULT 'NOT_SENT',
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `actId` (`actId`),
  CONSTRAINT `CircleOrder_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `CircleOrder_ibfk_2` FOREIGN KEY (`actId`) REFERENCES `Act` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CircleOrder`
--

LOCK TABLES `CircleOrder` WRITE;
/*!40000 ALTER TABLE `CircleOrder` DISABLE KEYS */;
/*!40000 ALTER TABLE `CircleOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CircleOrderFile`
--

DROP TABLE IF EXISTS `CircleOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `CircleOrderFile` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('FORM','SCAN') NOT NULL,
  PRIMARY KEY (`orderId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `CircleOrderFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `CircleOrderFile_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `CircleOrder` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `CircleOrderFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CircleOrderFile`
--

LOCK TABLES `CircleOrderFile` WRITE;
/*!40000 ALTER TABLE `CircleOrderFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `CircleOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Config`
--

DROP TABLE IF EXISTS `Config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Config` (
  `id` mediumint(8) unsigned NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `options` text DEFAULT NULL COMMENT 'Software configuration values as json',
  `syncEnabled` tinyint(1) DEFAULT 1,
  `showOpenStlWarning` tinyint(1) DEFAULT 1,
  `emailNotifications` tinyint(1) DEFAULT 1,
  `logout` mediumint(8) DEFAULT 10,
  `language` varchar(2) DEFAULT NULL,
  `customColorLut` text DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  PRIMARY KEY (`id`,`ownerId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Config`
--

LOCK TABLES `Config` WRITE;
/*!40000 ALTER TABLE `Config` DISABLE KEYS */;
INSERT INTO `Config` VALUES (1,1,'',1,1,1,10,'FR',NULL,'2024-04-30 13:44:41.000','2024-04-30 14:26:29.000','2024-04-30 12:26:31.658'),(1,2,'{\"ordersTableColumnsConfig\":{\"filtering\":[true,true,true,true,false,false],\"sorting\":[{\"order\":1,\"role\":\"internalStatusText\"},{\"order\":0,\"role\":\"patientSortName\"},{\"order\":0,\"role\":\"recipientSortName\"},{\"order\":0,\"role\":\"orderDetails\"},{\"order\":0,\"role\":\"fullDisplayId\"},{\"order\":1,\"role\":\"lastModified\"}]},\"showAllPatients\":true}',1,1,1,10,'FR',NULL,'2024-04-30 13:57:19.000','2024-04-30 14:37:26.000','2024-05-02 08:52:26.297'),(1,3,'{\"ordersTableColumnsConfig\":{\"filtering\":[true,true,true,true,false,false],\"sorting\":[{\"order\":1,\"role\":\"internalStatusText\"},{\"order\":0,\"role\":\"patientSortName\"},{\"order\":0,\"role\":\"recipientSortName\"},{\"order\":0,\"role\":\"orderDetails\"},{\"order\":0,\"role\":\"fullDisplayId\"},{\"order\":1,\"role\":\"lastModified\"}]},\"showAllPatients\":true}',1,1,1,10,'FR',NULL,'2024-04-30 14:26:29.000','2024-05-02 12:10:26.095','2024-05-02 10:10:26.093'),(1,4,'',1,1,1,10,'FR',NULL,'2024-05-02 11:30:48.000','2024-05-02 11:33:13.000','2024-05-02 09:30:49.265');
/*!40000 ALTER TABLE `Config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Contact`
--

DROP TABLE IF EXISTS `Contact`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Contact` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `professionalId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel contact',
  `officeId` varchar(36) DEFAULT NULL,
  `status` enum('INVITATIONSENT','INVITATIONRECEIVED','ACCEPTED','REJECTED') NOT NULL DEFAULT 'INVITATIONSENT',
  `comments` text DEFAULT NULL,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `uniqueContactPro` (`ownerId`,`professionalId`),
  KEY `professionalId` (`professionalId`),
  KEY `officeId` (`officeId`),
  CONSTRAINT `Contact_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `Contact_ibfk_2` FOREIGN KEY (`professionalId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `Contact_ibfk_3` FOREIGN KEY (`officeId`) REFERENCES `Office` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Contact`
--

LOCK TABLES `Contact` WRITE;
/*!40000 ALTER TABLE `Contact` DISABLE KEYS */;
INSERT INTO `Contact` VALUES ('0896a903-c587-49ee-a0cf-0c978f2587b2',3,2,NULL,'ACCEPTED','',NULL,'2024-04-30 14:37:26.000','2024-04-30 12:37:26.000','2024-04-30 14:37:26.000'),('8e4a4b16-c567-4bf8-a434-976b627a70ca',3,1,NULL,'ACCEPTED','',NULL,'2024-04-30 14:26:29.000','2024-04-30 12:26:29.000','2024-04-30 14:26:29.000'),('b0bde9dc-5ee2-4fb4-9f7d-b8854feaee30',3,3,NULL,'ACCEPTED','',NULL,'2024-04-30 14:26:29.000','2024-04-30 12:26:29.000','2024-04-30 14:26:29.000'),('b84baf20-3ca6-4653-8341-ac721a404258',3,4,NULL,'ACCEPTED','',NULL,'2024-05-02 11:33:13.000','2024-05-02 09:33:13.000','2024-05-02 11:33:13.000');
/*!40000 ALTER TABLE `Contact` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ContactNotification`
--

DROP TABLE IF EXISTS `ContactNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ContactNotification` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `contactId` varchar(36) DEFAULT NULL,
  `rescueDisplayName` varchar(50) DEFAULT NULL,
  `event` enum('RECEIVED','RECEIVED_TO_ACCEPTED','RECEIVED_TO_REJECTED','SENT_TO_ACCEPTED','SENT_TO_REJECTED','ACTIVATION_TIMEOUT') NOT NULL DEFAULT 'RECEIVED',
  `unread` tinyint(1) NOT NULL DEFAULT 1,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `contactId` (`contactId`),
  CONSTRAINT `ContactNotification_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `ContactNotification_ibfk_2` FOREIGN KEY (`contactId`) REFERENCES `Contact` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ContactNotification`
--

LOCK TABLES `ContactNotification` WRITE;
/*!40000 ALTER TABLE `ContactNotification` DISABLE KEYS */;
INSERT INTO `ContactNotification` VALUES ('4f258a68-41ff-4c59-ae17-f491870eb9bb',3,'0896a903-c587-49ee-a0cf-0c978f2587b2','Félix LEDEE CAUCHI','SENT_TO_ACCEPTED',0,'2024-04-30 14:37:26.000',NULL,'2024-05-02 09:12:55.206','2024-05-02 11:12:55.208'),('79a57263-507d-47f7-a3a4-22d7f574dc12',3,'b84baf20-3ca6-4653-8341-ac721a404258','client leger','SENT_TO_ACCEPTED',0,'2024-05-02 11:33:13.000',NULL,'2024-05-02 09:34:36.657','2024-05-02 11:34:36.659');
/*!40000 ALTER TABLE `ContactNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Credentials`
--

DROP TABLE IF EXISTS `Credentials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Credentials` (
  `uuid` varchar(36) NOT NULL,
  `login` varchar(255) NOT NULL,
  `password` varchar(100) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `login` (`login`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Credentials`
--

LOCK TABLES `Credentials` WRITE;
/*!40000 ALTER TABLE `Credentials` DISABLE KEYS */;
INSERT INTO `Credentials` VALUES ('2e995095-88b2-11ec-89bc-2e174fce41cd','biotech',NULL,'2024-04-30 12:26:31.643','2024-04-30 14:26:29.000'),('494c56b7-3289-46d8-838b-2e68cd18ca5b','demo',NULL,'2024-04-30 12:34:01.218','2024-04-30 14:37:26.000'),('7adcf581-a6db-4672-bc51-9c6d471fa663','iris','b0e3df5eccd7d2844837d97c6baad27a09945a8bdcc3c2afd2a4f73578446111','2024-04-30 12:26:30.918','2024-04-30 14:26:29.000'),('f2d078ea-bb55-4650-a755-6b8c3cc8f5bc','dem',NULL,'2024-05-02 09:32:34.140','2024-05-02 11:33:13.000');
/*!40000 ALTER TABLE `Credentials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Discussion`
--

DROP TABLE IF EXISTS `Discussion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Discussion` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `selfImplied` tinyint(1) NOT NULL DEFAULT 0,
  `officeId` varchar(36) DEFAULT NULL,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`,`ownerId`),
  KEY `ownerId` (`ownerId`),
  KEY `officeId` (`officeId`),
  CONSTRAINT `Discussion_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `Discussion_ibfk_2` FOREIGN KEY (`officeId`) REFERENCES `Office` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Discussion`
--

LOCK TABLES `Discussion` WRITE;
/*!40000 ALTER TABLE `Discussion` DISABLE KEYS */;
INSERT INTO `Discussion` VALUES ('1fed07ce-0867-11ef-8ff6-da2f5a35fe58',3,0,NULL,NULL,'2024-05-02 11:34:08.206','2024-05-02 10:20:31.000','2024-05-02 12:20:31.000'),('1fed07ce-0867-11ef-8ff6-da2f5a35fe58',4,0,NULL,NULL,'2024-05-02 11:34:08.206','2024-05-02 09:34:08.206',NULL),('97b97f39-06ed-11ef-90c8-dd3986f53a42',1,0,NULL,NULL,'2024-04-30 14:31:39.431','2024-04-30 12:31:39.431',NULL),('97b97f39-06ed-11ef-90c8-dd3986f53a42',3,0,NULL,NULL,'2024-04-30 14:31:39.431','2024-04-30 12:32:58.000','2024-04-30 14:32:58.000');
/*!40000 ALTER TABLE `Discussion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `File`
--

DROP TABLE IF EXISTS `File`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `File` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `path` text DEFAULT NULL,
  `tag` text DEFAULT NULL,
  `originalName` text NOT NULL,
  `originalId` varchar(36) NOT NULL,
  `metadata` text DEFAULT NULL,
  `type` enum('BIN','JSON','PDF','PLY','STL','PNG','XYZ','ZIP') NOT NULL,
  `version` mediumint(8) unsigned DEFAULT 0,
  `status` enum('CREATED','UPDATED','SYNCED','ERROR') DEFAULT 'CREATED',
  `anonymous` tinyint(1) NOT NULL DEFAULT 0,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `version` (`originalId`,`version`),
  CONSTRAINT `File_ibfk_1` FOREIGN KEY (`originalId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `File`
--

LOCK TABLES `File` WRITE;
/*!40000 ALTER TABLE `File` DISABLE KEYS */;
INSERT INTO `File` VALUES ('06de7932-0869-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_9fff6be0-0868-11ef-8ff6-da2f5a35fe58/occlusion_a000fd43-0868-11ef-8ff6-da2f5a35fe58/scan_eacd5e79-0868-11ef-8ff6-da2f5a35fe58/06de7932-0869-11ef-8ff6-da2f5a35fe58.zip','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_9fff6be0-0868-11ef-8ff6-da2f5a35fe58_SESS_a000fd43-0868-11ef-8ff6-da2f5a35fe58_BOSC_eacd5e79-0868-11ef-8ff6-da2f5a35fe58_MODEL','06de7932-0869-11ef-8ff6-da2f5a35fe58.zip','06de7932-0869-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Mandibule 1.1.3.1.1\",\"modelMatrix\":\"-0.97878,-0.174408,0.107571,0,0.176364,-0.984285,0.00886413,0,0.104334,0.0276476,0.994158,0,10.9633,2.36245,-21.2611,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-02 11:47:45.160','2024-05-02 09:47:45.466','2024-05-02 11:47:47.963'),('06de8cba-0869-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_9fff6be0-0868-11ef-8ff6-da2f5a35fe58/occlusion_a000fd43-0868-11ef-8ff6-da2f5a35fe58/scan_eacd5e79-0868-11ef-8ff6-da2f5a35fe58/06de8cba-0869-11ef-8ff6-da2f5a35fe58.png','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_9fff6be0-0868-11ef-8ff6-da2f5a35fe58_SESS_a000fd43-0868-11ef-8ff6-da2f5a35fe58_BOSC_eacd5e79-0868-11ef-8ff6-da2f5a35fe58_SNAPS','06de8cba-0869-11ef-8ff6-da2f5a35fe58.png','06de8cba-0869-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Mandibule 1.1.3.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-02 11:47:45.161','2024-05-02 09:47:45.466','2024-05-02 11:47:48.241'),('17764359-0863-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_91249277-0862-11ef-8ff6-da2f5a35fe58/17764359-0863-11ef-8ff6-da2f5a35fe58.zip','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_BOSC_91249277-0862-11ef-8ff6-da2f5a35fe58_MODEL','17764359-0863-11ef-8ff6-da2f5a35fe58.zip','17764359-0863-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Mandibule 1.1.2.1.1\",\"modelMatrix\":\"-0.390176,0.908855,0.147464,0,-0.896018,-0.411662,0.166391,0,0.21193,-0.067209,0.974971,0,23.0061,-12.7793,-21.2754,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-02 11:05:19.000','2024-05-02 09:05:19.000','2024-05-02 11:05:19.000'),('17765260-0863-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_91249277-0862-11ef-8ff6-da2f5a35fe58/17765260-0863-11ef-8ff6-da2f5a35fe58.png','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_BOSC_91249277-0862-11ef-8ff6-da2f5a35fe58_SNAPS','17765260-0863-11ef-8ff6-da2f5a35fe58.png','17765260-0863-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Mandibule 1.1.2.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-02 11:05:19.000','2024-05-02 09:05:19.000','2024-05-02 11:05:19.000'),('1e96d0f1-0863-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_1e96af46-0863-11ef-8ff6-da2f5a35fe58/1e96d0f1-0863-11ef-8ff6-da2f5a35fe58.zip','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_TOSC_1e96af46-0863-11ef-8ff6-da2f5a35fe58_MODEL','1e96d0f1-0863-11ef-8ff6-da2f5a35fe58.zip','1e96d0f1-0863-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Maxillaire 1.1.2.1.2\",\"modelMatrix\":\"0.0444728,-0.991811,-0.11972,0,0.974881,0.0692654,-0.21168,0,0.218239,-0.107299,0.969979,0,-25.3453,27.4041,-20.8016,1\",\"scanBodies\":[{\"position\":\"27.5285,5,0,0,40.8404,0,5.4,0,34.8176,0,0,6.3,1,0,0,0\",\"reference\":\"K30PSCANP\",\"tid\":26}]}','ZIP',0,'SYNCED',0,NULL,'2024-05-02 11:05:27.000','2024-05-02 09:09:56.000','2024-05-02 11:09:56.000'),('1ea66a74-0863-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_1e96af46-0863-11ef-8ff6-da2f5a35fe58/1ea66a74-0863-11ef-8ff6-da2f5a35fe58.png','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_TOSC_1e96af46-0863-11ef-8ff6-da2f5a35fe58_SNAPS','1ea66a74-0863-11ef-8ff6-da2f5a35fe58.png','1ea66a74-0863-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Maxillaire 1.1.2.1.2 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-02 11:05:32.000','2024-05-02 09:05:32.000','2024-05-02 11:05:32.000'),('1f81ed28-0867-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/order_58e7cf64-0861-11ef-8ff6-da2f5a35fe58/1f81ed28-0867-11ef-8ff6-da2f5a35fe58.pdf','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_PROST_58e7cf64-0861-11ef-8ff6-da2f5a35fe58_FORM','1f81ed28-0867-11ef-8ff6-da2f5a35fe58.pdf','1f81ed28-0867-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Commande 1.1.2.1 Facette\",\"title\":\"Facette\"}','PDF',0,'SYNCED',0,NULL,'2024-05-02 11:34:09.000','2024-05-02 09:34:09.000','2024-05-02 11:34:09.000'),('25ab5185-0864-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_59e98ac5-0861-11ef-8ff6-da2f5a35fe58/25ab5185-0864-11ef-8ff6-da2f5a35fe58.xyz','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_TOSC_59e98ac5-0861-11ef-8ff6-da2f5a35fe58_LIFI','25ab5185-0864-11ef-8ff6-da2f5a35fe58.xyz','e0bfa86b-0863-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Maxillaire 1.1.2.1.1 Ligne de finition 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',1,'SYNCED',0,NULL,'2024-05-02 11:12:49.351','2024-05-02 09:12:49.354','2024-05-02 11:12:49.374'),('25ab54c4-0864-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_59e98ac5-0861-11ef-8ff6-da2f5a35fe58/25ab54c4-0864-11ef-8ff6-da2f5a35fe58.bin','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_TOSC_59e98ac5-0861-11ef-8ff6-da2f5a35fe58_LIFIM','25ab54c4-0864-11ef-8ff6-da2f5a35fe58.bin','e0bfadf4-0863-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Maxillaire 1.1.2.1.1 Ligne de finition métadonnées 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',1,'SYNCED',0,NULL,'2024-05-02 11:12:49.351','2024-05-02 09:12:49.364','2024-05-02 11:12:49.635'),('27b8b3c2-0869-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_9fff6be0-0868-11ef-8ff6-da2f5a35fe58/occlusion_a000fd43-0868-11ef-8ff6-da2f5a35fe58/scan_0da7e703-0869-11ef-8ff6-da2f5a35fe58/27b8b3c2-0869-11ef-8ff6-da2f5a35fe58.zip','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_9fff6be0-0868-11ef-8ff6-da2f5a35fe58_SESS_a000fd43-0868-11ef-8ff6-da2f5a35fe58_FRSC_0da7e703-0869-11ef-8ff6-da2f5a35fe58_MODEL','27b8b3c2-0869-11ef-8ff6-da2f5a35fe58.zip','27b8b3c2-0869-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Mordu antérieur 1.1.3.1.1\",\"modelMatrix\":\"0.998862,0.0035764,-0.0485532,0,-0.00186451,0.999186,0.0402755,0,0.0476587,-0.0401872,0.998009,0,2.6593,4.01347,-20.1222,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-02 11:48:40.277','2024-05-02 09:48:40.493','2024-05-02 11:48:42.443'),('27b8c661-0869-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_9fff6be0-0868-11ef-8ff6-da2f5a35fe58/occlusion_a000fd43-0868-11ef-8ff6-da2f5a35fe58/scan_0da7e703-0869-11ef-8ff6-da2f5a35fe58/27b8c661-0869-11ef-8ff6-da2f5a35fe58.png','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_9fff6be0-0868-11ef-8ff6-da2f5a35fe58_SESS_a000fd43-0868-11ef-8ff6-da2f5a35fe58_FRSC_0da7e703-0869-11ef-8ff6-da2f5a35fe58_SNAPS','27b8c661-0869-11ef-8ff6-da2f5a35fe58.png','27b8c661-0869-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Mordu antérieur 1.1.3.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-02 11:48:40.278','2024-05-02 09:48:40.496','2024-05-02 11:48:42.994'),('2aa61e09-0869-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_9fff6be0-0868-11ef-8ff6-da2f5a35fe58/occlusion_a000fd43-0868-11ef-8ff6-da2f5a35fe58/computedocclusion_0cf0848e-0869-11ef-8ff6-da2f5a35fe58/2aa61e09-0869-11ef-8ff6-da2f5a35fe58.zip','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_9fff6be0-0868-11ef-8ff6-da2f5a35fe58_SESS_a000fd43-0868-11ef-8ff6-da2f5a35fe58_OCC_0cf0848e-0869-11ef-8ff6-da2f5a35fe58_TOPLY','2aa61e09-0869-11ef-8ff6-da2f5a35fe58.zip','2aa61e09-0869-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Occlusion 1.1.3.1.1 Maxillaire\",\"modelMatrix\":\"-0.299994,0.953935,-0.00332519,0,-0.913283,-0.288213,-0.287833,0,-0.275532,-0.0833111,0.957675,0,9.09266,-8.61807,-16.7682,1\",\"occlusionMatrix\":\"0.894318,0.179622,-0.409792,0,0.342237,0.315346,0.885116,0,0.288213,-0.93182,0.220547,0,-13.8624,11.5932,-1.27102,1\",\"occlusionType\":3,\"referenceScanId\":\"be43909f-0868-11ef-8ff6-da2f5a35fe58\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-02 11:48:46.000','2024-05-02 09:48:46.000','2024-05-02 11:48:46.000'),('2ac2bcfd-0869-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_9fff6be0-0868-11ef-8ff6-da2f5a35fe58/occlusion_a000fd43-0868-11ef-8ff6-da2f5a35fe58/computedocclusion_0cf0848e-0869-11ef-8ff6-da2f5a35fe58/2ac2bcfd-0869-11ef-8ff6-da2f5a35fe58.zip','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_9fff6be0-0868-11ef-8ff6-da2f5a35fe58_SESS_a000fd43-0868-11ef-8ff6-da2f5a35fe58_OCC_0cf0848e-0869-11ef-8ff6-da2f5a35fe58_BOPLY','2ac2bcfd-0869-11ef-8ff6-da2f5a35fe58.zip','2ac2bcfd-0869-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Occlusion 1.1.3.1.1 Mandibule\",\"modelMatrix\":\"-0.97878,-0.174408,0.107571,0,0.176364,-0.984285,0.00886413,0,0.104334,0.0276476,0.994158,0,10.9633,2.36245,-21.2611,1\",\"occlusionMatrix\":\"0.910352,0.137331,-0.390406,0,-0.361384,-0.195961,-0.911596,0,-0.201694,0.970955,-0.128768,0,-9.86668,-18.0279,9.29767,1\",\"occlusionType\":3,\"referenceScanId\":\"eacd5e79-0868-11ef-8ff6-da2f5a35fe58\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-02 11:48:46.000','2024-05-02 09:48:46.000','2024-05-02 11:48:46.000'),('2b3e9ab9-0869-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_9fff6be0-0868-11ef-8ff6-da2f5a35fe58/occlusion_a000fd43-0868-11ef-8ff6-da2f5a35fe58/computedocclusion_0cf0848e-0869-11ef-8ff6-da2f5a35fe58/2b3e9ab9-0869-11ef-8ff6-da2f5a35fe58.png','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_9fff6be0-0868-11ef-8ff6-da2f5a35fe58_SESS_a000fd43-0868-11ef-8ff6-da2f5a35fe58_OCC_0cf0848e-0869-11ef-8ff6-da2f5a35fe58_SNAPO','2b3e9ab9-0869-11ef-8ff6-da2f5a35fe58.png','2b3e9ab9-0869-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Occlusion 1.1.3.1.1 Snapshot\",\"occlusionType\":3}','PNG',0,'SYNCED',0,NULL,'2024-05-02 11:48:46.188','2024-05-02 09:48:46.191','2024-05-02 11:48:46.885'),('2fbc2cef-0864-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_91249277-0862-11ef-8ff6-da2f5a35fe58/2fbc2cef-0864-11ef-8ff6-da2f5a35fe58.xyz','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_BOSC_91249277-0862-11ef-8ff6-da2f5a35fe58_LIFI','2fbc2cef-0864-11ef-8ff6-da2f5a35fe58.xyz','2fbc2cef-0864-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Mandibule 1.1.2.1.1 Ligne de finition 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-05-02 11:13:06.238','2024-05-02 09:13:06.243','2024-05-02 11:13:06.262'),('2fbc3392-0864-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_91249277-0862-11ef-8ff6-da2f5a35fe58/2fbc3392-0864-11ef-8ff6-da2f5a35fe58.bin','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_BOSC_91249277-0862-11ef-8ff6-da2f5a35fe58_LIFIM','2fbc3392-0864-11ef-8ff6-da2f5a35fe58.bin','2fbc3392-0864-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Mandibule 1.1.2.1.1 Ligne de finition métadonnées 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-05-02 11:13:06.239','2024-05-02 09:13:06.257','2024-05-02 11:13:06.450'),('3102e726-086d-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_1fcf39f6-086d-11ef-8ff6-da2f5a35fe58/occlusion_1fcf8a88-086d-11ef-8ff6-da2f5a35fe58/scan_20b98eb5-086d-11ef-8ff6-da2f5a35fe58/3102e726-086d-11ef-8ff6-da2f5a35fe58.zip','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_1fcf39f6-086d-11ef-8ff6-da2f5a35fe58_SESS_1fcf8a88-086d-11ef-8ff6-da2f5a35fe58_TOSC_20b98eb5-086d-11ef-8ff6-da2f5a35fe58_MODEL','3102e726-086d-11ef-8ff6-da2f5a35fe58.zip','3102e726-086d-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Maxillaire 1.1.5.1.1\",\"modelMatrix\":\"-0.750205,-0.654663,0.0927873,0,0.657972,-0.725289,0.202553,0,-0.0653062,0.213008,0.974865,0,10.396,1.0936,-14.5821,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-02 12:18:00.000','2024-05-02 10:18:00.000','2024-05-02 12:18:00.000'),('3102fb86-086d-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_1fcf39f6-086d-11ef-8ff6-da2f5a35fe58/occlusion_1fcf8a88-086d-11ef-8ff6-da2f5a35fe58/scan_20b98eb5-086d-11ef-8ff6-da2f5a35fe58/3102fb86-086d-11ef-8ff6-da2f5a35fe58.png','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_1fcf39f6-086d-11ef-8ff6-da2f5a35fe58_SESS_1fcf8a88-086d-11ef-8ff6-da2f5a35fe58_TOSC_20b98eb5-086d-11ef-8ff6-da2f5a35fe58_SNAPS','3102fb86-086d-11ef-8ff6-da2f5a35fe58.png','3102fb86-086d-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Maxillaire 1.1.5.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-02 12:18:00.000','2024-05-02 10:18:00.000','2024-05-02 12:18:00.000'),('3163c7c7-0863-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_1e96af46-0863-11ef-8ff6-da2f5a35fe58/3163c7c7-0863-11ef-8ff6-da2f5a35fe58.ply','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_TOSC_1e96af46-0863-11ef-8ff6-da2f5a35fe58_SEG','3163c7c7-0863-11ef-8ff6-da2f5a35fe58.ply','3163c7c7-0863-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Maxillaire scanbody 1.1.2.1.2 Segmentation\"}','PLY',0,'CREATED',0,'2024-05-02 11:06:21.938','2024-05-02 11:06:21.939','2024-05-02 09:06:21.939',NULL),('3202c706-0869-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_9fff6be0-0868-11ef-8ff6-da2f5a35fe58/order_a0015ffe-0868-11ef-8ff6-da2f5a35fe58/3202c706-0869-11ef-8ff6-da2f5a35fe58.pdf','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_9fff6be0-0868-11ef-8ff6-da2f5a35fe58_PROST_a0015ffe-0868-11ef-8ff6-da2f5a35fe58_FORM','3202c706-0869-11ef-8ff6-da2f5a35fe58.pdf','3202c706-0869-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Commande 1.1.3.1 Facette\",\"title\":\"Facette\"}','PDF',0,'SYNCED',0,NULL,'2024-05-02 11:48:57.540','2024-05-02 09:48:58.276','2024-05-02 11:48:58.384'),('33ad43c0-0867-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/order_58e7cf64-0861-11ef-8ff6-da2f5a35fe58/33ad43c0-0867-11ef-8ff6-da2f5a35fe58.pdf','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_PROST_58e7cf64-0861-11ef-8ff6-da2f5a35fe58_FORM','33ad43c0-0867-11ef-8ff6-da2f5a35fe58.pdf','1f81ed28-0867-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Commande 1.1.2.1 Facette\",\"title\":\"Facette\"}','PDF',1,'SYNCED',0,NULL,'2024-05-02 11:34:41.342','2024-05-02 09:34:42.034','2024-05-02 11:34:42.041'),('3ea239fc-0863-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_1e96af46-0863-11ef-8ff6-da2f5a35fe58/3ea239fc-0863-11ef-8ff6-da2f5a35fe58.zip','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_TOSC_1e96af46-0863-11ef-8ff6-da2f5a35fe58_MODEL','3ea239fc-0863-11ef-8ff6-da2f5a35fe58.zip','1e96d0f1-0863-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Maxillaire scanbody 1.1.2.1.2\",\"modelMatrix\":\"0.0444728,-0.991811,-0.11972,0,0.974881,0.0692654,-0.21168,0,0.218239,-0.107299,0.969979,0,-25.3453,27.4041,-20.8016,1\",\"scanBodies\":[{\"position\":\"27.5285,5,0,0,40.8404,0,5.4,0,34.8176,0,0,6.3,1,0,0,0\",\"reference\":\"K30PSCANP\",\"tid\":26}]}','ZIP',1,'SYNCED',0,NULL,'2024-05-02 11:06:21.737','2024-05-02 09:06:21.866','2024-05-02 11:09:57.178'),('4d7752a0-086d-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_1fcf39f6-086d-11ef-8ff6-da2f5a35fe58/order_47d6e672-086d-11ef-8ff6-da2f5a35fe58/4d7752a0-086d-11ef-8ff6-da2f5a35fe58.pdf','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_1fcf39f6-086d-11ef-8ff6-da2f5a35fe58_PROST_47d6e672-086d-11ef-8ff6-da2f5a35fe58_FORM','4d7752a0-086d-11ef-8ff6-da2f5a35fe58.pdf','4d7752a0-086d-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Commande 1.1.5.1 Autre\",\"title\":\"Autre\"}','PDF',0,'SYNCED',0,NULL,'2024-05-02 12:18:21.589','2024-05-02 10:18:22.280','2024-05-02 12:18:22.449'),('6d5ff7a6-0864-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_405b06bd-0864-11ef-8ff6-da2f5a35fe58/6d5ff7a6-0864-11ef-8ff6-da2f5a35fe58.zip','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_LESC_405b06bd-0864-11ef-8ff6-da2f5a35fe58_MODEL','6d5ff7a6-0864-11ef-8ff6-da2f5a35fe58.zip','6d5ff7a6-0864-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Mordu gauche 1.1.2.1.1\",\"modelMatrix\":\"-0.975871,0.17345,0.131192,0,-0.187345,-0.975638,-0.115734,0,0.11224,-0.134382,0.984593,0,16.4421,3.20587,-18.8052,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-02 11:14:49.653','2024-05-02 09:14:49.969','2024-05-02 11:16:08.216'),('6d60184b-0864-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_405b06bd-0864-11ef-8ff6-da2f5a35fe58/6d60184b-0864-11ef-8ff6-da2f5a35fe58.png','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_LESC_405b06bd-0864-11ef-8ff6-da2f5a35fe58_SNAPS','6d60184b-0864-11ef-8ff6-da2f5a35fe58.png','6d60184b-0864-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Mordu gauche 1.1.2.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-02 11:14:49.654','2024-05-02 09:14:49.979','2024-05-02 11:16:09.333'),('714f63b2-06ed-11ef-90c8-dd3986f53a42',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_4dd3e575-06ed-11ef-90c8-dd3986f53a42/occlusion_4dd586c4-06ed-11ef-90c8-dd3986f53a42/scan_57229e01-06ed-11ef-90c8-dd3986f53a42/714f63b2-06ed-11ef-90c8-dd3986f53a42.zip','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_4dd3e575-06ed-11ef-90c8-dd3986f53a42_SESS_4dd586c4-06ed-11ef-90c8-dd3986f53a42_TOSC_57229e01-06ed-11ef-90c8-dd3986f53a42_MODEL','714f63b2-06ed-11ef-90c8-dd3986f53a42.zip','714f63b2-06ed-11ef-90c8-dd3986f53a42','{\"displayTitle\":\"Maxillaire 1.1.1.1.1\",\"modelMatrix\":\"0.966616,0.255909,-0.0128421,0,-0.251929,0.940047,-0.229878,0,-0.0467557,0.225439,0.973135,0,-9.10706,-9.44021,-28.2552,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-04-30 14:30:39.000','2024-04-30 12:30:39.000','2024-04-30 14:30:39.000'),('714f73d7-06ed-11ef-90c8-dd3986f53a42',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_4dd3e575-06ed-11ef-90c8-dd3986f53a42/occlusion_4dd586c4-06ed-11ef-90c8-dd3986f53a42/scan_57229e01-06ed-11ef-90c8-dd3986f53a42/714f73d7-06ed-11ef-90c8-dd3986f53a42.png','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_4dd3e575-06ed-11ef-90c8-dd3986f53a42_SESS_4dd586c4-06ed-11ef-90c8-dd3986f53a42_TOSC_57229e01-06ed-11ef-90c8-dd3986f53a42_SNAPS','714f73d7-06ed-11ef-90c8-dd3986f53a42.png','714f73d7-06ed-11ef-90c8-dd3986f53a42','{\"displayTitle\":\"Maxillaire 1.1.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-04-30 14:30:39.000','2024-04-30 12:30:39.000','2024-04-30 14:30:39.000'),('8b26c5be-086c-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_89504286-086c-11ef-8ff6-da2f5a35fe58/analyse_895411ef-086c-11ef-8ff6-da2f5a35fe58/8b26c5be-086c-11ef-8ff6-da2f5a35fe58.json','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_89504286-086c-11ef-8ff6-da2f5a35fe58_ANA_895411ef-086c-11ef-8ff6-da2f5a35fe58_TRANS','8b26c5be-086c-11ef-8ff6-da2f5a35fe58.json','8b26c5be-086c-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Mesures 1.1.4.1\"}','JSON',0,'SYNCED',0,NULL,'2024-05-02 12:12:55.583','2024-05-02 10:12:55.585','2024-05-02 12:12:55.980'),('8b60cf5e-086c-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_89504286-086c-11ef-8ff6-da2f5a35fe58/analyse_895411ef-086c-11ef-8ff6-da2f5a35fe58/8b60cf5e-086c-11ef-8ff6-da2f5a35fe58.png','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_89504286-086c-11ef-8ff6-da2f5a35fe58_ANA_895411ef-086c-11ef-8ff6-da2f5a35fe58_SNAPS','8b60cf5e-086c-11ef-8ff6-da2f5a35fe58.png','8b60cf5e-086c-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Mesures 1.1.4.1\"}','PNG',0,'SYNCED',0,NULL,'2024-05-02 12:12:55.964','2024-05-02 10:12:55.966','2024-05-02 12:12:56.449'),('97508969-06ed-11ef-90c8-dd3986f53a42',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_4dd3e575-06ed-11ef-90c8-dd3986f53a42/order_4dd5f101-06ed-11ef-90c8-dd3986f53a42/97508969-06ed-11ef-90c8-dd3986f53a42.pdf','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_4dd3e575-06ed-11ef-90c8-dd3986f53a42_PROST_4dd5f101-06ed-11ef-90c8-dd3986f53a42_FORM','97508969-06ed-11ef-90c8-dd3986f53a42.pdf','97508969-06ed-11ef-90c8-dd3986f53a42','{\"displayTitle\":\"Commande 1.1.1.1 Facette\",\"title\":\"Facette\"}','PDF',0,'SYNCED',0,NULL,'2024-04-30 14:31:38.742','2024-04-30 12:31:39.426','2024-04-30 14:31:39.528'),('9a964568-0864-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_405b2abf-0864-11ef-8ff6-da2f5a35fe58/9a964568-0864-11ef-8ff6-da2f5a35fe58.zip','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_RISC_405b2abf-0864-11ef-8ff6-da2f5a35fe58_MODEL','9a964568-0864-11ef-8ff6-da2f5a35fe58.zip','9a964568-0864-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Mordu droit 1.1.2.1.1\",\"modelMatrix\":\"0.999123,0.0262569,0.0381029,0,-0.0260382,0.989632,0.136561,0,-0.0332268,-0.141353,0.989907,0,5.96872,2.32456,-15.2889,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-02 11:16:05.506','2024-05-02 09:16:05.855','2024-05-02 11:16:09.736'),('9a965491-0864-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_405b2abf-0864-11ef-8ff6-da2f5a35fe58/9a965491-0864-11ef-8ff6-da2f5a35fe58.png','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_RISC_405b2abf-0864-11ef-8ff6-da2f5a35fe58_SNAPS','9a965491-0864-11ef-8ff6-da2f5a35fe58.png','9a965491-0864-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Mordu droit 1.1.2.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-02 11:16:05.507','2024-05-02 09:16:05.861','2024-05-02 11:16:11.021'),('a3a69b8b-0864-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/computedocclusion_3966fc97-0864-11ef-8ff6-da2f5a35fe58/a3a69b8b-0864-11ef-8ff6-da2f5a35fe58.zip','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_OCC_3966fc97-0864-11ef-8ff6-da2f5a35fe58_TOPLY','a3a69b8b-0864-11ef-8ff6-da2f5a35fe58.zip','a3a69b8b-0864-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Occlusion 1.1.2.1.1 Maxillaire\",\"modelMatrix\":\"0.0444728,-0.991811,-0.11972,0,0.974881,0.0692654,-0.21168,0,0.218239,-0.107299,0.969979,0,-25.3453,27.4041,-20.8016,1\",\"occlusionMatrix\":\"-0.974894,0.134129,0.177739,0,-0.209705,-0.284655,-0.935412,0,-0.0748715,-0.9492,0.305636,0,31.0933,26.6708,6.74008,1\",\"occlusionType\":5,\"referenceScanId\":\"59e98ac5-0861-11ef-8ff6-da2f5a35fe58\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-02 11:16:27.000','2024-05-02 09:16:27.000','2024-05-02 11:16:27.000'),('a3e32cc1-0864-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/computedocclusion_3966fc97-0864-11ef-8ff6-da2f5a35fe58/a3e32cc1-0864-11ef-8ff6-da2f5a35fe58.xyz','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_OCC_3966fc97-0864-11ef-8ff6-da2f5a35fe58_LIFIO','a3e32cc1-0864-11ef-8ff6-da2f5a35fe58.xyz','a3e32cc1-0864-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Occlusion 1.1.2.1.1 Ligne de finition Maxillaire 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY\",\"referenceScanId\":\"59e98ac5-0861-11ef-8ff6-da2f5a35fe58\",\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-05-02 11:16:28.000','2024-05-02 09:16:28.000','2024-05-02 11:16:28.000'),('a3e332c3-0864-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/computedocclusion_3966fc97-0864-11ef-8ff6-da2f5a35fe58/a3e332c3-0864-11ef-8ff6-da2f5a35fe58.bin','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_OCC_3966fc97-0864-11ef-8ff6-da2f5a35fe58_LIFIMO','a3e332c3-0864-11ef-8ff6-da2f5a35fe58.bin','a3e332c3-0864-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Occlusion 1.1.2.1.1 Ligne de finition métadonnées Maxillaire 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY\",\"referenceScanId\":\"59e98ac5-0861-11ef-8ff6-da2f5a35fe58\",\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-05-02 11:16:28.000','2024-05-02 09:16:28.000','2024-05-02 11:16:28.000'),('a3e37662-0864-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/computedocclusion_3966fc97-0864-11ef-8ff6-da2f5a35fe58/a3e37662-0864-11ef-8ff6-da2f5a35fe58.xyz','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_OCC_3966fc97-0864-11ef-8ff6-da2f5a35fe58_LIFIO','a3e37662-0864-11ef-8ff6-da2f5a35fe58.xyz','a3e37662-0864-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Occlusion 1.1.2.1.1 Ligne de finition Maxillaire 1\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY\",\"referenceScanId\":\"59e98ac5-0861-11ef-8ff6-da2f5a35fe58\",\"title\":\"1\",\"toothNumber\":1001,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-05-02 11:16:28.000','2024-05-02 09:16:28.000','2024-05-02 11:16:28.000'),('a3e37c4f-0864-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/computedocclusion_3966fc97-0864-11ef-8ff6-da2f5a35fe58/a3e37c4f-0864-11ef-8ff6-da2f5a35fe58.bin','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_OCC_3966fc97-0864-11ef-8ff6-da2f5a35fe58_LIFIMO','a3e37c4f-0864-11ef-8ff6-da2f5a35fe58.bin','a3e37c4f-0864-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Occlusion 1.1.2.1.1 Ligne de finition métadonnées Maxillaire 1\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY\",\"referenceScanId\":\"59e98ac5-0861-11ef-8ff6-da2f5a35fe58\",\"title\":\"1\",\"toothNumber\":1001,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-05-02 11:16:28.000','2024-05-02 09:16:28.000','2024-05-02 11:16:28.000'),('a3e3b7e2-0864-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/computedocclusion_3966fc97-0864-11ef-8ff6-da2f5a35fe58/a3e3b7e2-0864-11ef-8ff6-da2f5a35fe58.zip','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_OCC_3966fc97-0864-11ef-8ff6-da2f5a35fe58_BOPLY','a3e3b7e2-0864-11ef-8ff6-da2f5a35fe58.zip','a3e3b7e2-0864-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Occlusion 1.1.2.1.1 Mandibule\",\"modelMatrix\":\"-0.390176,0.908855,0.147464,0,-0.896018,-0.411662,0.166391,0,0.21193,-0.067209,0.974971,0,23.0061,-12.7793,-21.2754,1\",\"occlusionMatrix\":\"-0.674105,0.367234,0.640879,0,0.714195,0.545419,0.438689,0,-0.188446,0.753432,-0.629945,0,5.41862,-27.1499,-17.8681,1\",\"occlusionType\":5,\"referenceScanId\":\"91249277-0862-11ef-8ff6-da2f5a35fe58\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-02 11:16:33.000','2024-05-02 09:16:33.000','2024-05-02 11:16:33.000'),('a413fc36-0864-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/computedocclusion_3966fc97-0864-11ef-8ff6-da2f5a35fe58/a413fc36-0864-11ef-8ff6-da2f5a35fe58.xyz','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_OCC_3966fc97-0864-11ef-8ff6-da2f5a35fe58_LIFIO','a413fc36-0864-11ef-8ff6-da2f5a35fe58.xyz','a413fc36-0864-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Occlusion 1.1.2.1.1 Ligne de finition Mandibule 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MANDIBLE\",\"referenceScanId\":\"91249277-0862-11ef-8ff6-da2f5a35fe58\",\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-05-02 11:16:33.000','2024-05-02 09:16:33.000','2024-05-02 11:16:33.000'),('a414024b-0864-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/computedocclusion_3966fc97-0864-11ef-8ff6-da2f5a35fe58/a414024b-0864-11ef-8ff6-da2f5a35fe58.bin','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_OCC_3966fc97-0864-11ef-8ff6-da2f5a35fe58_LIFIMO','a414024b-0864-11ef-8ff6-da2f5a35fe58.bin','a414024b-0864-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Occlusion 1.1.2.1.1 Ligne de finition métadonnées Mandibule 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MANDIBLE\",\"referenceScanId\":\"91249277-0862-11ef-8ff6-da2f5a35fe58\",\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-05-02 11:16:33.000','2024-05-02 09:16:33.000','2024-05-02 11:16:33.000'),('a4f01daf-0864-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/computedocclusion_3966fc97-0864-11ef-8ff6-da2f5a35fe58/a4f01daf-0864-11ef-8ff6-da2f5a35fe58.png','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_OCC_3966fc97-0864-11ef-8ff6-da2f5a35fe58_SNAPO','a4f01daf-0864-11ef-8ff6-da2f5a35fe58.png','a4f01daf-0864-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Occlusion 1.1.2.1.1 Snapshot\",\"occlusionType\":5}','PNG',0,'SYNCED',0,NULL,'2024-05-02 11:16:33.000','2024-05-02 09:16:33.000','2024-05-02 11:16:33.000'),('bc911890-0863-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_1e96af46-0863-11ef-8ff6-da2f5a35fe58/bc911890-0863-11ef-8ff6-da2f5a35fe58.zip','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_TOSC_1e96af46-0863-11ef-8ff6-da2f5a35fe58_MODEL','bc911890-0863-11ef-8ff6-da2f5a35fe58.zip','1e96d0f1-0863-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Maxillaire scanbody 1.1.2.1.2\",\"modelMatrix\":\"0.0356374,-0.993736,-0.105918,0,0.977155,0.0568693,-0.204779,0,0.20952,-0.0962007,0.973061,0,-25.6493,27.3607,-21.4551,1\",\"scanBodies\":[{\"position\":\"27.5285,5,0,0,40.8404,0,5.4,0,34.8176,0,0,6.3,1,0,0,0\",\"reference\":\"K30PSCANP\",\"tid\":26}]}','ZIP',2,'SYNCED',0,NULL,'2024-05-02 11:10:07.000','2024-05-02 09:10:07.000','2024-05-02 11:10:07.000'),('bc912779-0863-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_1e96af46-0863-11ef-8ff6-da2f5a35fe58/bc912779-0863-11ef-8ff6-da2f5a35fe58.png','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_TOSC_1e96af46-0863-11ef-8ff6-da2f5a35fe58_SNAPS','bc912779-0863-11ef-8ff6-da2f5a35fe58.png','1ea66a74-0863-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Maxillaire scanbody 1.1.2.1.2 Snapshot\"}','PNG',1,'SYNCED',0,NULL,'2024-05-02 11:10:07.000','2024-05-02 09:10:07.000','2024-05-02 11:10:07.000'),('bdd2799d-0864-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/computedocclusion_3966fc97-0864-11ef-8ff6-da2f5a35fe58/bdd2799d-0864-11ef-8ff6-da2f5a35fe58.zip','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_OCC_3966fc97-0864-11ef-8ff6-da2f5a35fe58_TOSB','bdd2799d-0864-11ef-8ff6-da2f5a35fe58.zip','bdd2799d-0864-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Occlusion 1.1.2.1.1 Maxillaire scanbody\",\"modelMatrix\":\"0.0356374,-0.993736,-0.105918,0,0.977155,0.0568693,-0.204779,0,0.20952,-0.0962007,0.973061,0,-25.6493,27.3607,-21.4551,1\",\"occlusionMatrix\":\"-0.975236,0.127023,0.181063,0,-0.210845,-0.286678,-0.934537,0,-0.0668007,-0.949571,0.306362,0,30.856,26.854,6.55269,1\",\"occlusionType\":5,\"referenceScanId\":\"1e96af46-0863-11ef-8ff6-da2f5a35fe58\",\"scanBodies\":[{\"position\":\"27.5285,5,0,0,40.8404,0,5.4,0,34.8176,0,0,6.3,1,0,0,0\",\"reference\":\"K30PSCANP\",\"tid\":26}]}','ZIP',0,'SYNCED',0,NULL,'2024-05-02 11:17:07.000','2024-05-02 09:17:07.000','2024-05-02 11:17:07.000'),('c60f2934-06ed-11ef-90c8-dd3986f53a42',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_4dd3e575-06ed-11ef-90c8-dd3986f53a42/order_4dd5f101-06ed-11ef-90c8-dd3986f53a42/c60f2934-06ed-11ef-90c8-dd3986f53a42.pdf','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_4dd3e575-06ed-11ef-90c8-dd3986f53a42_PROST_4dd5f101-06ed-11ef-90c8-dd3986f53a42_FORM','c60f2934-06ed-11ef-90c8-dd3986f53a42.pdf','97508969-06ed-11ef-90c8-dd3986f53a42','{\"displayTitle\":\"Commande 1.1.1.1 Facette\",\"title\":\"Facette\"}','PDF',1,'SYNCED',0,NULL,'2024-04-30 14:32:58.000','2024-04-30 12:32:58.000','2024-04-30 14:32:58.000'),('d88962f2-0863-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_59e98ac5-0861-11ef-8ff6-da2f5a35fe58/d88962f2-0863-11ef-8ff6-da2f5a35fe58.xyz','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_TOSC_59e98ac5-0861-11ef-8ff6-da2f5a35fe58_LIFI','d88962f2-0863-11ef-8ff6-da2f5a35fe58.xyz','d88962f2-0863-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Maxillaire 1.1.2.1.1 Ligne de finition 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,'2024-05-02 11:10:45.251','2024-05-02 11:10:39.944','2024-05-02 09:10:45.252','2024-05-02 11:10:45.261'),('d88967ff-0863-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_59e98ac5-0861-11ef-8ff6-da2f5a35fe58/d88967ff-0863-11ef-8ff6-da2f5a35fe58.bin','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_TOSC_59e98ac5-0861-11ef-8ff6-da2f5a35fe58_LIFIM','d88967ff-0863-11ef-8ff6-da2f5a35fe58.bin','d88967ff-0863-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Maxillaire 1.1.2.1.1 Ligne de finition métadonnées 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,'2024-05-02 11:10:45.251','2024-05-02 11:10:39.944','2024-05-02 09:10:45.252','2024-05-02 11:10:45.262'),('e0bfa86b-0863-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_59e98ac5-0861-11ef-8ff6-da2f5a35fe58/e0bfa86b-0863-11ef-8ff6-da2f5a35fe58.xyz','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_TOSC_59e98ac5-0861-11ef-8ff6-da2f5a35fe58_LIFI','e0bfa86b-0863-11ef-8ff6-da2f5a35fe58.xyz','e0bfa86b-0863-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Maxillaire 1.1.2.1.1 Ligne de finition 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-05-02 11:10:53.721','2024-05-02 09:10:53.724','2024-05-02 11:10:53.730'),('e0bfadf4-0863-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_59e98ac5-0861-11ef-8ff6-da2f5a35fe58/e0bfadf4-0863-11ef-8ff6-da2f5a35fe58.bin','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_TOSC_59e98ac5-0861-11ef-8ff6-da2f5a35fe58_LIFIM','e0bfadf4-0863-11ef-8ff6-da2f5a35fe58.bin','e0bfadf4-0863-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Maxillaire 1.1.2.1.1 Ligne de finition métadonnées 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-05-02 11:10:54.000','2024-05-02 09:10:54.000','2024-05-02 11:10:54.000'),('e94e0fa3-0868-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_9fff6be0-0868-11ef-8ff6-da2f5a35fe58/occlusion_a000fd43-0868-11ef-8ff6-da2f5a35fe58/scan_be43909f-0868-11ef-8ff6-da2f5a35fe58/e94e0fa3-0868-11ef-8ff6-da2f5a35fe58.zip','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_9fff6be0-0868-11ef-8ff6-da2f5a35fe58_SESS_a000fd43-0868-11ef-8ff6-da2f5a35fe58_TOSC_be43909f-0868-11ef-8ff6-da2f5a35fe58_MODEL','e94e0fa3-0868-11ef-8ff6-da2f5a35fe58.zip','e94e0fa3-0868-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Maxillaire 1.1.3.1.1\",\"modelMatrix\":\"-0.299994,0.953935,-0.00332519,0,-0.913283,-0.288213,-0.287833,0,-0.275532,-0.0833111,0.957675,0,9.09266,-8.61807,-16.7682,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-02 11:46:55.560','2024-05-02 09:46:55.918','2024-05-02 11:47:47.317'),('e94e2f27-0868-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_9fff6be0-0868-11ef-8ff6-da2f5a35fe58/occlusion_a000fd43-0868-11ef-8ff6-da2f5a35fe58/scan_be43909f-0868-11ef-8ff6-da2f5a35fe58/e94e2f27-0868-11ef-8ff6-da2f5a35fe58.png','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_9fff6be0-0868-11ef-8ff6-da2f5a35fe58_SESS_a000fd43-0868-11ef-8ff6-da2f5a35fe58_TOSC_be43909f-0868-11ef-8ff6-da2f5a35fe58_SNAPS','e94e2f27-0868-11ef-8ff6-da2f5a35fe58.png','e94e2f27-0868-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Maxillaire 1.1.3.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-02 11:46:55.561','2024-05-02 09:46:55.919','2024-05-02 11:47:47.612'),('ea71e741-0863-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_59e98ac5-0861-11ef-8ff6-da2f5a35fe58/ea71e741-0863-11ef-8ff6-da2f5a35fe58.xyz','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_TOSC_59e98ac5-0861-11ef-8ff6-da2f5a35fe58_LIFI','ea71e741-0863-11ef-8ff6-da2f5a35fe58.xyz','ea71e741-0863-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Maxillaire 1.1.2.1.1 Ligne de finition 1\",\"title\":\"1\",\"toothNumber\":1,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-05-02 11:11:10.000','2024-05-02 09:11:10.000','2024-05-02 11:11:10.000'),('ea71eca5-0863-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_59e98ac5-0861-11ef-8ff6-da2f5a35fe58/ea71eca5-0863-11ef-8ff6-da2f5a35fe58.bin','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_TOSC_59e98ac5-0861-11ef-8ff6-da2f5a35fe58_LIFIM','ea71eca5-0863-11ef-8ff6-da2f5a35fe58.bin','ea71eca5-0863-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Maxillaire 1.1.2.1.1 Ligne de finition métadonnées 1\",\"title\":\"1\",\"toothNumber\":1,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-05-02 11:11:09.989','2024-05-02 09:11:10.002','2024-05-02 11:11:10.266'),('eb746e19-0861-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_59e98ac5-0861-11ef-8ff6-da2f5a35fe58/eb746e19-0861-11ef-8ff6-da2f5a35fe58.zip','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_TOSC_59e98ac5-0861-11ef-8ff6-da2f5a35fe58_MODEL','eb746e19-0861-11ef-8ff6-da2f5a35fe58.zip','eb746e19-0861-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Maxillaire 1.1.2.1.1\",\"modelMatrix\":\"0.0444728,-0.991811,-0.11972,0,0.974881,0.0692654,-0.21168,0,0.218239,-0.107299,0.969979,0,-25.3453,27.4041,-20.8016,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-02 10:56:56.000','2024-05-02 08:56:56.000','2024-05-02 10:56:56.000'),('eb7485b0-0861-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_59e98ac5-0861-11ef-8ff6-da2f5a35fe58/eb7485b0-0861-11ef-8ff6-da2f5a35fe58.png','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_TOSC_59e98ac5-0861-11ef-8ff6-da2f5a35fe58_SNAPS','eb7485b0-0861-11ef-8ff6-da2f5a35fe58.png','eb7485b0-0861-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Maxillaire 1.1.2.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-02 10:56:56.000','2024-05-02 08:56:56.000','2024-05-02 10:56:56.000'),('fc095480-086c-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_89504286-086c-11ef-8ff6-da2f5a35fe58/analyse_895411ef-086c-11ef-8ff6-da2f5a35fe58/fc095480-086c-11ef-8ff6-da2f5a35fe58.json','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_89504286-086c-11ef-8ff6-da2f5a35fe58_ANA_895411ef-086c-11ef-8ff6-da2f5a35fe58_METER','fc095480-086c-11ef-8ff6-da2f5a35fe58.json','fc095480-086c-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Mesures 1.1.4.1\"}','JSON',0,'SYNCED',0,NULL,'2024-05-02 12:16:04.973','2024-05-02 10:16:04.985','2024-05-02 12:16:04.988');
/*!40000 ALTER TABLE `File` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `MessageStatus`
--

DROP TABLE IF EXISTS `MessageStatus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `MessageStatus` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `sentMessageId` varchar(36) NOT NULL,
  `contactId` varchar(36) NOT NULL,
  `status` enum('UNDELIVERED','DELIVERED','TRANSMITTED') NOT NULL DEFAULT 'UNDELIVERED',
  `bcc` tinyint(1) NOT NULL DEFAULT 0,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  PRIMARY KEY (`sentMessageId`,`contactId`),
  KEY `ownerId` (`ownerId`),
  KEY `contactId` (`contactId`),
  CONSTRAINT `MessageStatus_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `MessageStatus_ibfk_2` FOREIGN KEY (`sentMessageId`) REFERENCES `SentMessage` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `MessageStatus_ibfk_3` FOREIGN KEY (`contactId`) REFERENCES `Contact` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `MessageStatus`
--

LOCK TABLES `MessageStatus` WRITE;
/*!40000 ALTER TABLE `MessageStatus` DISABLE KEYS */;
INSERT INTO `MessageStatus` VALUES (3,'0ab7a78f-a39e-4180-9e24-2f7e3d76ba8f','8e4a4b16-c567-4bf8-a434-976b627a70ca','DELIVERED',0,'2024-04-30 12:32:58.849'),(3,'154baa5a-086c-11ef-8ff6-da2f5a35fe58','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-02 10:09:38.299'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-02 09:34:12.341'),(3,'32745aba-0869-11ef-8ff6-da2f5a35fe58','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-02 09:49:00.153'),(3,'3ffa3b3a-0869-11ef-8ff6-da2f5a35fe58','b84baf20-3ca6-4653-8341-ac721a404258','TRANSMITTED',0,'2024-05-02 09:49:31.738'),(3,'4de24f2b-086d-11ef-8ff6-da2f5a35fe58','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-02 10:18:25.095'),(3,'57c2d78c-086d-11ef-8ff6-da2f5a35fe58','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-02 10:18:39.052'),(3,'6d270b56-0c6a-4586-810b-b2149a940503','b84baf20-3ca6-4653-8341-ac721a404258','TRANSMITTED',0,'2024-05-02 09:35:21.103'),(3,'97b9c350-06ed-11ef-90c8-dd3986f53a42','8e4a4b16-c567-4bf8-a434-976b627a70ca','DELIVERED',0,'2024-04-30 12:31:41.339'),(3,'985a9923-0869-11ef-8ff6-da2f5a35fe58','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-02 09:51:49.480'),(3,'9aa53190-086d-11ef-8ff6-da2f5a35fe58','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-02 10:20:31.279'),(3,'d54e8176-0867-11ef-8ff6-da2f5a35fe58','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-02 09:39:12.736'),(3,'ea731232-0867-11ef-8ff6-da2f5a35fe58','b84baf20-3ca6-4653-8341-ac721a404258','TRANSMITTED',0,'2024-05-02 09:39:55.131');
/*!40000 ALTER TABLE `MessageStatus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Occlusion`
--

DROP TABLE IF EXISTS `Occlusion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Occlusion` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `sessionId` varchar(36) DEFAULT NULL,
  `occlusionType` enum('UNKNOWN','HEMI_ARCADE_POSTERIEUR_DROIT','HEMI_ARCADE_POSTERIEUR_GAUCHE','HEMI_ARCADE_ANTERIEUR','ARCADE_COMPLETE_ANTERIEUR','ARCADE_COMPLETE') DEFAULT 'UNKNOWN',
  `displayId` mediumint(8) unsigned DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT 0,
  `comments` text DEFAULT NULL,
  `topScanId` varchar(36) DEFAULT NULL,
  `bottomScanId` varchar(36) DEFAULT NULL,
  `anteriorBiteScanId` varchar(36) DEFAULT NULL,
  `rightBiteScanId` varchar(36) DEFAULT NULL,
  `leftBiteScanId` varchar(36) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `sessionId` (`sessionId`),
  KEY `topScanId` (`topScanId`),
  KEY `bottomScanId` (`bottomScanId`),
  KEY `anteriorBiteScanId` (`anteriorBiteScanId`),
  KEY `rightBiteScanId` (`rightBiteScanId`),
  KEY `leftBiteScanId` (`leftBiteScanId`),
  CONSTRAINT `Occlusion_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_2` FOREIGN KEY (`sessionId`) REFERENCES `Session` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_3` FOREIGN KEY (`topScanId`) REFERENCES `Scan` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_4` FOREIGN KEY (`bottomScanId`) REFERENCES `Scan` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_5` FOREIGN KEY (`anteriorBiteScanId`) REFERENCES `Scan` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_6` FOREIGN KEY (`rightBiteScanId`) REFERENCES `Scan` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_7` FOREIGN KEY (`leftBiteScanId`) REFERENCES `Scan` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Occlusion`
--

LOCK TABLES `Occlusion` WRITE;
/*!40000 ALTER TABLE `Occlusion` DISABLE KEYS */;
INSERT INTO `Occlusion` VALUES ('0cf0848e-0869-11ef-8ff6-da2f5a35fe58',3,'a000fd43-0868-11ef-8ff6-da2f5a35fe58','HEMI_ARCADE_ANTERIEUR',1,0,'','be43909f-0868-11ef-8ff6-da2f5a35fe58','eacd5e79-0868-11ef-8ff6-da2f5a35fe58','0da7e703-0869-11ef-8ff6-da2f5a35fe58',NULL,NULL,'2024-05-02 11:47:55.345',NULL,'2024-05-02 11:48:46.190','2024-05-02 09:48:46.190','2024-05-02 11:48:46.203'),('3966fc97-0864-11ef-8ff6-da2f5a35fe58',3,'58e77d50-0861-11ef-8ff6-da2f5a35fe58','ARCADE_COMPLETE',1,0,'','59e98ac5-0861-11ef-8ff6-da2f5a35fe58','91249277-0862-11ef-8ff6-da2f5a35fe58',NULL,'405b2abf-0864-11ef-8ff6-da2f5a35fe58','405b06bd-0864-11ef-8ff6-da2f5a35fe58','2024-05-02 11:13:22.457',NULL,'2024-05-02 11:17:05.021','2024-05-02 09:17:05.021','2024-05-02 11:17:05.035');
/*!40000 ALTER TABLE `Occlusion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `OcclusionFile`
--

DROP TABLE IF EXISTS `OcclusionFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `OcclusionFile` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `occlusionId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('RESULT','MANDIBLE','MAXILLARY','MANDIBLE_SB','MAXILLARY_SB','MANDIBLE_PRE','MAXILLARY_PRE','MANDIBLE_SUP','MAXILLARY_SUP','LIFI','LIFIMETA','SNAPSHOT','SCREENSHOT','METERING') NOT NULL DEFAULT 'RESULT',
  PRIMARY KEY (`occlusionId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `OcclusionFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `OcclusionFile_ibfk_2` FOREIGN KEY (`occlusionId`) REFERENCES `Occlusion` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `OcclusionFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `OcclusionFile`
--

LOCK TABLES `OcclusionFile` WRITE;
/*!40000 ALTER TABLE `OcclusionFile` DISABLE KEYS */;
INSERT INTO `OcclusionFile` VALUES (3,'0cf0848e-0869-11ef-8ff6-da2f5a35fe58','2aa61e09-0869-11ef-8ff6-da2f5a35fe58','MAXILLARY'),(3,'0cf0848e-0869-11ef-8ff6-da2f5a35fe58','2ac2bcfd-0869-11ef-8ff6-da2f5a35fe58','MANDIBLE'),(3,'0cf0848e-0869-11ef-8ff6-da2f5a35fe58','2b3e9ab9-0869-11ef-8ff6-da2f5a35fe58','SNAPSHOT'),(3,'3966fc97-0864-11ef-8ff6-da2f5a35fe58','a3a69b8b-0864-11ef-8ff6-da2f5a35fe58','MAXILLARY'),(3,'3966fc97-0864-11ef-8ff6-da2f5a35fe58','a3e32cc1-0864-11ef-8ff6-da2f5a35fe58','LIFI'),(3,'3966fc97-0864-11ef-8ff6-da2f5a35fe58','a3e332c3-0864-11ef-8ff6-da2f5a35fe58','LIFIMETA'),(3,'3966fc97-0864-11ef-8ff6-da2f5a35fe58','a3e37662-0864-11ef-8ff6-da2f5a35fe58','LIFI'),(3,'3966fc97-0864-11ef-8ff6-da2f5a35fe58','a3e37c4f-0864-11ef-8ff6-da2f5a35fe58','LIFIMETA'),(3,'3966fc97-0864-11ef-8ff6-da2f5a35fe58','a3e3b7e2-0864-11ef-8ff6-da2f5a35fe58','MANDIBLE'),(3,'3966fc97-0864-11ef-8ff6-da2f5a35fe58','a413fc36-0864-11ef-8ff6-da2f5a35fe58','LIFI'),(3,'3966fc97-0864-11ef-8ff6-da2f5a35fe58','a414024b-0864-11ef-8ff6-da2f5a35fe58','LIFIMETA'),(3,'3966fc97-0864-11ef-8ff6-da2f5a35fe58','a4f01daf-0864-11ef-8ff6-da2f5a35fe58','SNAPSHOT'),(3,'3966fc97-0864-11ef-8ff6-da2f5a35fe58','bdd2799d-0864-11ef-8ff6-da2f5a35fe58','MAXILLARY_SB');
/*!40000 ALTER TABLE `OcclusionFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Office`
--

DROP TABLE IF EXISTS `Office`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Office` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `mainPhone` varchar(45) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `cityName` varchar(255) DEFAULT NULL,
  `cityZip` varchar(25) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `country` varchar(75) DEFAULT NULL,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  CONSTRAINT `Office_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Office`
--

LOCK TABLES `Office` WRITE;
/*!40000 ALTER TABLE `Office` DISABLE KEYS */;
INSERT INTO `Office` VALUES ('0ac16b23-6842-4c9f-8ae1-c9aebd8f89a6',2,'0606060606','Office','','Labège','31670','137 rue Garance','France',NULL,'2024-04-30 13:57:19.000','2024-04-30 11:57:19.000','2024-04-30 13:57:19.000'),('2b879809-8839-11ec-89bc-2e174fce41cd',1,'0606060606','Biotech-Dental','','Toulouse','31100','Route du test','France',NULL,'2024-04-30 13:44:41.000','2024-04-30 11:44:41.000','2024-04-30 13:44:41.000'),('2d8ca014-6913-4b1a-b659-633a90708e87',3,'1234567','iris','','labege','31670','site dev','France',NULL,'2024-04-30 14:26:29.000','2024-04-30 12:26:30.925','2024-04-30 14:26:30.925'),('ff4e6b8d-9265-4329-8c37-ae1742b98869',4,'123456','','','labege','','','France',NULL,'2024-05-02 11:30:48.000','2024-05-02 09:32:32.000','2024-05-02 11:32:32.000');
/*!40000 ALTER TABLE `Office` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PersonInfo`
--

DROP TABLE IF EXISTS `PersonInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `PersonInfo` (
  `uuid` varchar(36) NOT NULL,
  `firstname` varchar(64) NOT NULL,
  `lastname` varchar(64) NOT NULL,
  `email` varchar(255) NOT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PersonInfo`
--

LOCK TABLES `PersonInfo` WRITE;
/*!40000 ALTER TABLE `PersonInfo` DISABLE KEYS */;
INSERT INTO `PersonInfo` VALUES ('1e8cdf1b-215c-4ac5-b249-3c62bb75f98a','Félix','LEDEE CAUCHI','felix.ledee@scan4all.fr','2024-05-02 08:52:26.296','2024-04-30 14:37:26.000'),('4114e703-8838-11ec-89bc-2e174fce41cd','Biotech-Dental','LABORATOIRE','lab@biotech-dental.pro','2024-04-30 12:26:31.644','2024-04-30 14:26:29.000'),('63c8d5a2-b9f0-4ceb-84d5-287f0dffe537','sabine','Caserta','sabine.caserta@scan4all.fr','2024-04-30 12:26:30.919','2024-04-30 14:26:29.000'),('baee14ff-c898-4c00-a8fc-c3cc04d03c09','client','leger','alertes.documentation@scan4all.fr','2024-05-02 09:32:34.142','2024-05-02 11:33:13.000');
/*!40000 ALTER TABLE `PersonInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PhoneInfo`
--

DROP TABLE IF EXISTS `PhoneInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `PhoneInfo` (
  `uuid` varchar(36) NOT NULL,
  `phone` varchar(45) DEFAULT NULL,
  `cellular` varchar(45) DEFAULT NULL,
  `fax` varchar(45) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PhoneInfo`
--

LOCK TABLES `PhoneInfo` WRITE;
/*!40000 ALTER TABLE `PhoneInfo` DISABLE KEYS */;
INSERT INTO `PhoneInfo` VALUES ('093fd04a-a408-410c-8ef3-58cc4b2a5f3b','1234567','','','2024-04-30 12:26:30.919','2024-04-30 14:26:29.000'),('230961f5-8e72-4729-bdd7-fd502443d733','123456','','','2024-05-02 09:32:34.142','2024-05-02 11:33:13.000'),('47ead308-8838-11ec-89bc-2e174fce41cd','0606060606','','','2024-04-30 12:26:31.652','2024-04-30 14:26:29.000'),('790ceaab-dc21-491f-ac6e-b832ce9aba1e','0606060606','','','2024-04-30 12:34:01.220','2024-04-30 14:37:26.000');
/*!40000 ALTER TABLE `PhoneInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Professional`
--

DROP TABLE IF EXISTS `Professional`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Professional` (
  `uuid` varchar(36) NOT NULL,
  `id` mediumint(8) unsigned NOT NULL,
  `credentialsId` varchar(36) DEFAULT NULL,
  `personInfoId` varchar(36) NOT NULL,
  `phoneInfoId` varchar(36) NOT NULL,
  `addressInfoId` varchar(36) NOT NULL,
  `configId` mediumint(8) unsigned DEFAULT NULL,
  `syncInfoId` mediumint(8) unsigned DEFAULT NULL,
  `surgeryName` varchar(255) DEFAULT NULL,
  `comments` text DEFAULT NULL,
  `type` enum('UNDEFINED','PROTHESIST','DENTIST','DEMO','OTHER') NOT NULL DEFAULT 'UNDEFINED',
  `limitedContactId` varchar(36) DEFAULT NULL,
  `directoryVisible` tinyint(1) NOT NULL DEFAULT 1,
  `statusGalaxy` tinyint(1) DEFAULT 0,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  UNIQUE KEY `personInfoId` (`personInfoId`),
  UNIQUE KEY `phoneInfoId` (`phoneInfoId`),
  UNIQUE KEY `addressInfoId` (`addressInfoId`),
  UNIQUE KEY `credentialsId` (`credentialsId`),
  KEY `syncInfoId` (`syncInfoId`,`id`),
  KEY `configId` (`configId`,`id`),
  CONSTRAINT `Professional_ibfk_1` FOREIGN KEY (`credentialsId`) REFERENCES `Credentials` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_2` FOREIGN KEY (`personInfoId`) REFERENCES `PersonInfo` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_3` FOREIGN KEY (`phoneInfoId`) REFERENCES `PhoneInfo` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_4` FOREIGN KEY (`addressInfoId`) REFERENCES `AddressInfo` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_5` FOREIGN KEY (`syncInfoId`, `id`) REFERENCES `SyncInfo` (`id`, `ownerId`) ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_6` FOREIGN KEY (`configId`, `id`) REFERENCES `Config` (`id`, `ownerId`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Professional`
--

LOCK TABLES `Professional` WRITE;
/*!40000 ALTER TABLE `Professional` DISABLE KEYS */;
INSERT INTO `Professional` VALUES ('71b743e8-8838-11ec-89bc-2e174fce41cd',1,'2e995095-88b2-11ec-89bc-2e174fce41cd','4114e703-8838-11ec-89bc-2e174fce41cd','47ead308-8838-11ec-89bc-2e174fce41cd','4caacc66-8838-11ec-89bc-2e174fce41cd',1,1,'','','PROTHESIST',NULL,1,0,NULL,'2024-04-30 13:44:41.000','2024-04-30 11:44:41.000','2024-04-30 14:26:29.000'),('29ae88de-072b-4bb4-a086-5ff64b936b70',2,'494c56b7-3289-46d8-838b-2e68cd18ca5b','1e8cdf1b-215c-4ac5-b249-3c62bb75f98a','790ceaab-dc21-491f-ac6e-b832ce9aba1e','a5e85963-fe76-4488-a34e-59cf90eee3e0',1,1,'','','DENTIST',NULL,1,0,NULL,'2024-04-30 16:20:51.000','2024-04-30 14:36:08.000','2024-04-30 14:37:26.000'),('dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','63c8d5a2-b9f0-4ceb-84d5-287f0dffe537','093fd04a-a408-410c-8ef3-58cc4b2a5f3b','67cbd5eb-5e68-4f9b-9a15-2b1a0dabbcef',1,1,'','','DENTIST',NULL,1,0,NULL,'2024-04-30 14:26:29.000','2024-04-30 12:26:29.000','2024-04-30 14:26:29.000'),('429bbf37-e15c-4430-af34-41c8f46437a6',4,'f2d078ea-bb55-4650-a755-6b8c3cc8f5bc','baee14ff-c898-4c00-a8fc-c3cc04d03c09','230961f5-8e72-4729-bdd7-fd502443d733','b920f641-ec66-47f2-b374-25b1f9188d1d',1,1,'','','PROTHESIST',NULL,1,0,NULL,'2024-05-02 11:30:47.000','2024-05-02 09:32:32.000','2024-05-02 11:33:13.000');
/*!40000 ALTER TABLE `Professional` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProfessionalEnvInfos`
--

DROP TABLE IF EXISTS `ProfessionalEnvInfos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProfessionalEnvInfos` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `accessCode` varchar(45) DEFAULT NULL,
  `status` enum('CREATED','CONFIRMED','BLOCKED') NOT NULL DEFAULT 'CREATED',
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`ownerId`),
  CONSTRAINT `ProfessionalEnvInfos_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProfessionalEnvInfos`
--

LOCK TABLES `ProfessionalEnvInfos` WRITE;
/*!40000 ALTER TABLE `ProfessionalEnvInfos` DISABLE KEYS */;
INSERT INTO `ProfessionalEnvInfos` VALUES (1,'','CONFIRMED','2024-04-30 12:26:31.663','2024-04-30 14:26:31.663'),(2,'','CONFIRMED','2024-04-30 12:34:01.230','2024-04-30 14:34:01.230'),(3,'','CONFIRMED','2024-04-30 12:26:30.925','2024-04-30 14:26:30.925'),(4,'','CONFIRMED','2024-05-02 09:32:34.146','2024-05-02 11:32:34.146');
/*!40000 ALTER TABLE `ProfessionalEnvInfos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProfessionalPatient`
--

DROP TABLE IF EXISTS `ProfessionalPatient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProfessionalPatient` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `patientId` varchar(36) NOT NULL,
  `officeId` varchar(36) DEFAULT NULL,
  `enablePatientSharing` tinyint(1) DEFAULT 0,
  `pinned` tinyint(1) NOT NULL DEFAULT 0,
  `theme` enum('NONE','ADULT','BOY','GIRL','BABY') DEFAULT 'NONE',
  PRIMARY KEY (`ownerId`,`patientId`),
  KEY `patientId` (`patientId`),
  KEY `officeId` (`officeId`),
  CONSTRAINT `ProfessionalPatient_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `ProfessionalPatient_ibfk_2` FOREIGN KEY (`patientId`) REFERENCES `iris_patient`.`Patient` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `ProfessionalPatient_ibfk_3` FOREIGN KEY (`officeId`) REFERENCES `Office` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProfessionalPatient`
--

LOCK TABLES `ProfessionalPatient` WRITE;
/*!40000 ALTER TABLE `ProfessionalPatient` DISABLE KEYS */;
INSERT INTO `ProfessionalPatient` VALUES (3,'00c2d95b-06ed-11ef-90c8-dd3986f53a42','2d8ca014-6913-4b1a-b659-633a90708e87',0,0,'NONE');
/*!40000 ALTER TABLE `ProfessionalPatient` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrder`
--

DROP TABLE IF EXISTS `ProstheticOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProstheticOrder` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `actId` varchar(36) NOT NULL,
  `title` varchar(64) DEFAULT NULL,
  `status` enum('NOT_SENT','SENT','DATE_VALIDATED','DATE_EDITED','VALIDATED','CANCELLED','DELIVERY') NOT NULL DEFAULT 'NOT_SENT',
  `unread` tinyint(1) DEFAULT 0,
  `currentDeliveryDate` datetime(3) DEFAULT NULL,
  `previousDeliveryDate` datetime(3) DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT 0,
  `displayId` mediumint(8) unsigned DEFAULT NULL,
  `createdById` varchar(36) DEFAULT NULL,
  `updatedById` varchar(36) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `actId` (`actId`),
  CONSTRAINT `ProstheticOrder_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrder_ibfk_2` FOREIGN KEY (`actId`) REFERENCES `Act` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrder`
--

LOCK TABLES `ProstheticOrder` WRITE;
/*!40000 ALTER TABLE `ProstheticOrder` DISABLE KEYS */;
INSERT INTO `ProstheticOrder` VALUES ('47d6e672-086d-11ef-8ff6-da2f5a35fe58',3,'1fcf39f6-086d-11ef-8ff6-da2f5a35fe58','Commande 1.1.5.1','CANCELLED',0,'2024-05-03 00:00:00.000',NULL,0,1,'dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-02 12:18:12.000',NULL,'2024-05-02 12:19:34.000','2024-05-02 10:19:34.000','2024-05-02 12:19:34.000'),('4dd5f101-06ed-11ef-90c8-dd3986f53a42',3,'4dd3e575-06ed-11ef-90c8-dd3986f53a42','Commande 1.1.1.1','VALIDATED',0,'2024-06-14 00:00:00.000','2024-05-31 00:00:00.000',0,1,'dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-04-30 14:29:35.000',NULL,'2024-04-30 14:32:57.000','2024-04-30 12:32:58.000','2024-04-30 14:32:58.000'),('58e7cf64-0861-11ef-8ff6-da2f5a35fe58',3,'58e7015d-0861-11ef-8ff6-da2f5a35fe58','Commande 1.1.2.1','VALIDATED',0,'2024-05-04 00:00:00.000','2024-05-03 00:00:00.000',0,1,'dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-02 10:52:46.000',NULL,'2024-05-02 11:34:42.000','2024-05-02 09:34:43.000','2024-05-02 11:34:43.000'),('a0015ffe-0868-11ef-8ff6-da2f5a35fe58',3,'9fff6be0-0868-11ef-8ff6-da2f5a35fe58','Commande 1.1.3.1','DATE_VALIDATED',0,'2024-05-03 00:00:00.000',NULL,0,1,'dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-02 11:44:52.000',NULL,'2024-05-02 11:49:46.000','2024-05-02 09:49:46.000','2024-05-02 11:49:46.000');
/*!40000 ALTER TABLE `ProstheticOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrderFile`
--

DROP TABLE IF EXISTS `ProstheticOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProstheticOrderFile` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('FORM','SCAN') NOT NULL,
  PRIMARY KEY (`orderId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `ProstheticOrderFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrderFile_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `ProstheticOrder` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrderFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrderFile`
--

LOCK TABLES `ProstheticOrderFile` WRITE;
/*!40000 ALTER TABLE `ProstheticOrderFile` DISABLE KEYS */;
INSERT INTO `ProstheticOrderFile` VALUES (3,'47d6e672-086d-11ef-8ff6-da2f5a35fe58','3102e726-086d-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'47d6e672-086d-11ef-8ff6-da2f5a35fe58','3102fb86-086d-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'47d6e672-086d-11ef-8ff6-da2f5a35fe58','4d7752a0-086d-11ef-8ff6-da2f5a35fe58','FORM'),(3,'4dd5f101-06ed-11ef-90c8-dd3986f53a42','714f63b2-06ed-11ef-90c8-dd3986f53a42','SCAN'),(3,'4dd5f101-06ed-11ef-90c8-dd3986f53a42','714f73d7-06ed-11ef-90c8-dd3986f53a42','SCAN'),(3,'4dd5f101-06ed-11ef-90c8-dd3986f53a42','c60f2934-06ed-11ef-90c8-dd3986f53a42','FORM'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','17764359-0863-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','17765260-0863-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','25ab5185-0864-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','25ab54c4-0864-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','2fbc2cef-0864-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','2fbc3392-0864-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','33ad43c0-0867-11ef-8ff6-da2f5a35fe58','FORM'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','a3a69b8b-0864-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','a3e32cc1-0864-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','a3e332c3-0864-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','a3e37662-0864-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','a3e37c4f-0864-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','a3e3b7e2-0864-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','a413fc36-0864-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','a414024b-0864-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','a4f01daf-0864-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','bc911890-0863-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','bc912779-0863-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','bdd2799d-0864-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','ea71e741-0863-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','ea71eca5-0863-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','eb746e19-0861-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','eb7485b0-0861-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'a0015ffe-0868-11ef-8ff6-da2f5a35fe58','2aa61e09-0869-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'a0015ffe-0868-11ef-8ff6-da2f5a35fe58','2ac2bcfd-0869-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'a0015ffe-0868-11ef-8ff6-da2f5a35fe58','2b3e9ab9-0869-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'a0015ffe-0868-11ef-8ff6-da2f5a35fe58','3202c706-0869-11ef-8ff6-da2f5a35fe58','FORM');
/*!40000 ALTER TABLE `ProstheticOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrderRecipient`
--

DROP TABLE IF EXISTS `ProstheticOrderRecipient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProstheticOrderRecipient` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `recipientId` varchar(36) NOT NULL,
  PRIMARY KEY (`orderId`,`recipientId`),
  KEY `ownerId` (`ownerId`),
  KEY `recipientId` (`recipientId`),
  CONSTRAINT `ProstheticOrderRecipient_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrderRecipient_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `ProstheticOrder` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrderRecipient_ibfk_3` FOREIGN KEY (`recipientId`) REFERENCES `Contact` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrderRecipient`
--

LOCK TABLES `ProstheticOrderRecipient` WRITE;
/*!40000 ALTER TABLE `ProstheticOrderRecipient` DISABLE KEYS */;
INSERT INTO `ProstheticOrderRecipient` VALUES (3,'47d6e672-086d-11ef-8ff6-da2f5a35fe58','b84baf20-3ca6-4653-8341-ac721a404258'),(3,'4dd5f101-06ed-11ef-90c8-dd3986f53a42','8e4a4b16-c567-4bf8-a434-976b627a70ca'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','b84baf20-3ca6-4653-8341-ac721a404258'),(3,'a0015ffe-0868-11ef-8ff6-da2f5a35fe58','b84baf20-3ca6-4653-8341-ac721a404258');
/*!40000 ALTER TABLE `ProstheticOrderRecipient` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticSheet`
--

DROP TABLE IF EXISTS `ProstheticSheet`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProstheticSheet` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `json` text NOT NULL,
  `pdfFileId` varchar(36) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `orderId` (`orderId`),
  KEY `pdfFileId` (`pdfFileId`),
  CONSTRAINT `ProstheticSheet_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `ProstheticSheet_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `ProstheticOrder` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `ProstheticSheet_ibfk_3` FOREIGN KEY (`pdfFileId`) REFERENCES `File` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticSheet`
--

LOCK TABLES `ProstheticSheet` WRITE;
/*!40000 ALTER TABLE `ProstheticSheet` DISABLE KEYS */;
INSERT INTO `ProstheticSheet` VALUES ('47d6fbf5-086d-11ef-8ff6-da2f5a35fe58',3,'47d6e672-086d-11ef-8ff6-da2f5a35fe58','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            26\n        ],\n        \"sheetTitle\": \"Autre\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','4d7752a0-086d-11ef-8ff6-da2f5a35fe58','2024-05-02 12:18:11.000',NULL,'2024-05-02 12:18:24.000','2024-05-02 10:19:34.450','2024-05-02 12:19:34.000'),('4dd60173-06ed-11ef-90c8-dd3986f53a42',3,'4dd5f101-06ed-11ef-90c8-dd3986f53a42','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            11,\n            21\n        ],\n        \"sheetTitle\": \"Facette\",\n        \"specificTint\": \"\",\n        \"type\": 6,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','c60f2934-06ed-11ef-90c8-dd3986f53a42','2024-04-30 14:29:32.000',NULL,'2024-04-30 14:31:41.000','2024-04-30 12:33:01.396','2024-04-30 14:32:58.000'),('58e7df0c-0861-11ef-8ff6-da2f5a35fe58',3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            16\n        ],\n        \"sheetTitle\": \"Facette\",\n        \"specificTint\": \"\",\n        \"type\": 6,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','33ad43c0-0867-11ef-8ff6-da2f5a35fe58','2024-05-02 10:52:44.000',NULL,'2024-05-02 11:34:11.000','2024-05-02 09:34:44.385','2024-05-02 11:34:43.000'),('a00178ff-0868-11ef-8ff6-da2f5a35fe58',3,'a0015ffe-0868-11ef-8ff6-da2f5a35fe58','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            16\n        ],\n        \"sheetTitle\": \"Facette\",\n        \"specificTint\": \"\",\n        \"type\": 6,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','3202c706-0869-11ef-8ff6-da2f5a35fe58','2024-05-02 11:44:47.000',NULL,'2024-05-02 11:48:59.000','2024-05-02 09:49:46.906','2024-05-02 11:49:46.000');
/*!40000 ALTER TABLE `ProstheticSheet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ReceivedAttachment`
--

DROP TABLE IF EXISTS `ReceivedAttachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ReceivedAttachment` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `receivedMessageId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  PRIMARY KEY (`receivedMessageId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `ReceivedAttachment_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `ReceivedAttachment_ibfk_2` FOREIGN KEY (`receivedMessageId`) REFERENCES `ReceivedMessage` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ReceivedAttachment_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ReceivedAttachment`
--

LOCK TABLES `ReceivedAttachment` WRITE;
/*!40000 ALTER TABLE `ReceivedAttachment` DISABLE KEYS */;
/*!40000 ALTER TABLE `ReceivedAttachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ReceivedMessage`
--

DROP TABLE IF EXISTS `ReceivedMessage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ReceivedMessage` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `messageTransmitted` tinyint(1) NOT NULL DEFAULT 0,
  `subject` varchar(255) DEFAULT NULL,
  `answeredId` varchar(36) DEFAULT NULL COMMENT 'SentMessage uuid or ReceivedMessage originMessageId',
  `body` text DEFAULT NULL,
  `fromId` mediumint(8) unsigned NOT NULL,
  `originMessageId` varchar(36) DEFAULT NULL,
  `discussionId` varchar(36) NOT NULL,
  `readStatus` enum('READ','UNREAD') DEFAULT 'UNREAD',
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `fromId` (`fromId`),
  KEY `discussionId` (`discussionId`,`ownerId`),
  CONSTRAINT `ReceivedMessage_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `ReceivedMessage_ibfk_2` FOREIGN KEY (`fromId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `ReceivedMessage_ibfk_3` FOREIGN KEY (`discussionId`, `ownerId`) REFERENCES `Discussion` (`uuid`, `ownerId`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ReceivedMessage`
--

LOCK TABLES `ReceivedMessage` WRITE;
/*!40000 ALTER TABLE `ReceivedMessage` DISABLE KEYS */;
INSERT INTO `ReceivedMessage` VALUES ('2cb4adc7-0867-11ef-8ba8-6ec2958327c0',3,1,'Commande 1.1.2.1',NULL,'API_META={\"type\":\"order\",\"key\":\"edited\",\"title\":\"Commande 1.1.2.1\",\"date\":\"2024-05-04T00:00:00+02:00\",\"orderUpdateTime\":\"2024-05-02T11:34:29+02:00\",\"orderId\":\"58e7cf64-0861-11ef-8ff6-da2f5a35fe58\"}',4,'3e4bfd0c-75a4-4a50-9378-498a688a0d70','1fed07ce-0867-11ef-8ff6-da2f5a35fe58','READ','2024-05-02 11:34:29.000',NULL,'2024-05-02 11:34:29.000','2024-05-02 09:34:32.430','2024-05-02 11:34:32.439'),('4f3cfe4f-0869-11ef-8ba8-6ec2958327c0',3,1,'Commande 1.1.3.1',NULL,'API_META={\"type\":\"order\",\"key\":\"validated\",\"title\":\"Commande 1.1.3.1\",\"date\":\"2024-05-03T00:00:00+02:00\",\"orderUpdateTime\":\"2024-05-02T11:49:46+02:00\",\"orderId\":\"a0015ffe-0868-11ef-8ff6-da2f5a35fe58\"}',4,'2ba2ce00-d1e7-483d-8bae-a4f0690484a7','1fed07ce-0867-11ef-8ff6-da2f5a35fe58','READ','2024-05-02 11:49:46.000',NULL,'2024-05-02 11:49:46.000','2024-05-02 09:49:49.000','2024-05-02 11:49:49.000'),('78d098a5-086d-11ef-8ba8-6ec2958327c0',3,1,'Commande 1.1.5.1',NULL,'API_META={\"type\":\"order\",\"key\":\"cancelled\",\"title\":\"Commande 1.1.5.1\",\"date\":\"2024-05-03T00:00:00+02:00\",\"orderUpdateTime\":\"2024-05-02T12:19:34+02:00\",\"orderId\":\"47d6e672-086d-11ef-8ff6-da2f5a35fe58\"}',4,'aca14a67-aec4-4653-abbd-580eaef4e795','1fed07ce-0867-11ef-8ff6-da2f5a35fe58','READ','2024-05-02 12:19:34.000',NULL,'2024-05-02 12:19:34.000','2024-05-02 10:20:12.975','2024-05-02 12:20:12.984'),('c06eef11-06ed-11ef-8ba8-6ec2958327c0',3,1,'Commande 1.1.1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"edited\",\"title\":\"Commande 1.1.1.1\",\"date\":\"2024-06-14T00:00:00+02:00\",\"orderUpdateTime\":\"2024-04-30T14:32:47+02:00\",\"orderId\":\"4dd5f101-06ed-11ef-90c8-dd3986f53a42\"}',1,'976b65ef-0cc1-4f98-9f52-1b1d40d68714','97b97f39-06ed-11ef-90c8-dd3986f53a42','READ','2024-04-30 14:32:47.000',NULL,'2024-04-30 14:32:47.000','2024-04-30 12:32:53.396','2024-04-30 14:32:53.406'),('f54936ea-086b-11ef-8ba8-6ec2958327c0',3,1,'Réponse depuis le web',NULL,'tes d\'envoi de message du web ',4,'70286606-85d8-4818-9d87-4ced1cde8323','1fed07ce-0867-11ef-8ff6-da2f5a35fe58','READ','2024-05-02 12:08:44.000',NULL,'2024-05-02 12:08:44.000','2024-05-02 10:09:01.842','2024-05-02 12:09:01.852');
/*!40000 ALTER TABLE `ReceivedMessage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Scan`
--

DROP TABLE IF EXISTS `Scan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Scan` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL,
  `sessionId` varchar(36) NOT NULL,
  `type` enum('MAXILLAIRE','MANDIBULE','MORDU_ANTERIEUR','MORDU_POSTERIEUR_GAUCHE','MORDU_POSTERIEUR_DROIT') NOT NULL,
  `label` enum('PRE_PREPARATION','SCAN','SCANBODY','SCAN_SUP') NOT NULL DEFAULT 'SCAN',
  `validated` tinyint(1) NOT NULL DEFAULT 0,
  `status` enum('IN_PROGRESS','NONE') NOT NULL DEFAULT 'IN_PROGRESS',
  `displayId` mediumint(8) unsigned DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT 0,
  `comments` text DEFAULT NULL,
  `createdById` varchar(36) DEFAULT NULL,
  `updatedById` varchar(36) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `sessionId` (`sessionId`),
  CONSTRAINT `Scan_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `Scan_ibfk_2` FOREIGN KEY (`sessionId`) REFERENCES `Session` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Scan`
--

LOCK TABLES `Scan` WRITE;
/*!40000 ALTER TABLE `Scan` DISABLE KEYS */;
INSERT INTO `Scan` VALUES ('0da7e703-0869-11ef-8ff6-da2f5a35fe58',3,'a000fd43-0868-11ef-8ff6-da2f5a35fe58','MORDU_ANTERIEUR','SCAN',1,'NONE',1,0,'','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-02 11:47:56.547',NULL,'2024-05-02 11:48:40.484','2024-05-02 09:48:40.484','2024-05-02 11:48:40.498'),('1e96af46-0863-11ef-8ff6-da2f5a35fe58',3,'58e77d50-0861-11ef-8ff6-da2f5a35fe58','MAXILLAIRE','SCANBODY',1,'NONE',2,0,'{\"referenceScanId\":\"59e98ac5-0861-11ef-8ff6-da2f5a35fe58\"}','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-02 11:05:27.975',NULL,'2024-05-02 11:09:55.021','2024-05-02 09:09:55.021','2024-05-02 11:09:55.034'),('20b98eb5-086d-11ef-8ff6-da2f5a35fe58',3,'1fcf8a88-086d-11ef-8ff6-da2f5a35fe58','MAXILLAIRE','SCAN',1,'NONE',1,0,'','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-02 12:17:06.526',NULL,'2024-05-02 12:17:59.623','2024-05-02 10:17:59.623','2024-05-02 12:17:59.626'),('405b06bd-0864-11ef-8ff6-da2f5a35fe58',3,'58e77d50-0861-11ef-8ff6-da2f5a35fe58','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-02 11:13:34.123',NULL,'2024-05-02 11:14:49.968','2024-05-02 09:14:49.969','2024-05-02 11:16:05.859'),('405b2abf-0864-11ef-8ff6-da2f5a35fe58',3,'58e77d50-0861-11ef-8ff6-da2f5a35fe58','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-02 11:13:34.124',NULL,'2024-05-02 11:16:05.854','2024-05-02 09:16:05.855','2024-05-02 11:16:05.865'),('57229e01-06ed-11ef-90c8-dd3986f53a42',3,'4dd586c4-06ed-11ef-90c8-dd3986f53a42','MAXILLAIRE','SCAN',1,'NONE',1,0,'','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-04-30 14:29:51.067',NULL,'2024-04-30 14:30:35.183','2024-04-30 12:30:35.183','2024-04-30 14:30:35.188'),('59e98ac5-0861-11ef-8ff6-da2f5a35fe58',3,'58e77d50-0861-11ef-8ff6-da2f5a35fe58','MAXILLAIRE','SCAN',1,'NONE',1,0,'','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-02 10:52:48.510',NULL,'2024-05-02 11:12:49.354','2024-05-02 09:12:49.354','2024-05-02 11:12:49.371'),('91249277-0862-11ef-8ff6-da2f5a35fe58',3,'58e77d50-0861-11ef-8ff6-da2f5a35fe58','MANDIBULE','SCAN',1,'NONE',1,0,'','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-02 11:01:30.668',NULL,'2024-05-02 11:13:06.241','2024-05-02 09:13:06.242','2024-05-02 11:13:06.259'),('be43909f-0868-11ef-8ff6-da2f5a35fe58',3,'a000fd43-0868-11ef-8ff6-da2f5a35fe58','MAXILLAIRE','SCAN',1,'NONE',1,0,'','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-02 11:45:43.349',NULL,'2024-05-02 11:46:55.908','2024-05-02 09:46:55.909','2024-05-02 11:47:45.470'),('eacd5e79-0868-11ef-8ff6-da2f5a35fe58',3,'a000fd43-0868-11ef-8ff6-da2f5a35fe58','MANDIBULE','SCAN',1,'NONE',1,0,'','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-02 11:46:58.072',NULL,'2024-05-02 11:47:45.465','2024-05-02 09:47:45.465','2024-05-02 11:47:45.478');
/*!40000 ALTER TABLE `Scan` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ScanFile`
--

DROP TABLE IF EXISTS `ScanFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ScanFile` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `scanId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('MODEL','SNAPSHOT','SCREENSHOT','LIFI','LIFIMETA','METERING','SEGMENTED') NOT NULL,
  PRIMARY KEY (`scanId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `ScanFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `ScanFile_ibfk_2` FOREIGN KEY (`scanId`) REFERENCES `Scan` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ScanFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ScanFile`
--

LOCK TABLES `ScanFile` WRITE;
/*!40000 ALTER TABLE `ScanFile` DISABLE KEYS */;
INSERT INTO `ScanFile` VALUES (3,'0da7e703-0869-11ef-8ff6-da2f5a35fe58','27b8b3c2-0869-11ef-8ff6-da2f5a35fe58','MODEL'),(3,'0da7e703-0869-11ef-8ff6-da2f5a35fe58','27b8c661-0869-11ef-8ff6-da2f5a35fe58','SNAPSHOT'),(3,'1e96af46-0863-11ef-8ff6-da2f5a35fe58','1e96d0f1-0863-11ef-8ff6-da2f5a35fe58','MODEL'),(3,'1e96af46-0863-11ef-8ff6-da2f5a35fe58','1ea66a74-0863-11ef-8ff6-da2f5a35fe58','SNAPSHOT'),(3,'1e96af46-0863-11ef-8ff6-da2f5a35fe58','3163c7c7-0863-11ef-8ff6-da2f5a35fe58','SEGMENTED'),(3,'1e96af46-0863-11ef-8ff6-da2f5a35fe58','3ea239fc-0863-11ef-8ff6-da2f5a35fe58','MODEL'),(3,'1e96af46-0863-11ef-8ff6-da2f5a35fe58','bc911890-0863-11ef-8ff6-da2f5a35fe58','MODEL'),(3,'1e96af46-0863-11ef-8ff6-da2f5a35fe58','bc912779-0863-11ef-8ff6-da2f5a35fe58','SNAPSHOT'),(3,'20b98eb5-086d-11ef-8ff6-da2f5a35fe58','3102e726-086d-11ef-8ff6-da2f5a35fe58','MODEL'),(3,'20b98eb5-086d-11ef-8ff6-da2f5a35fe58','3102fb86-086d-11ef-8ff6-da2f5a35fe58','SNAPSHOT'),(3,'405b06bd-0864-11ef-8ff6-da2f5a35fe58','6d5ff7a6-0864-11ef-8ff6-da2f5a35fe58','MODEL'),(3,'405b06bd-0864-11ef-8ff6-da2f5a35fe58','6d60184b-0864-11ef-8ff6-da2f5a35fe58','SNAPSHOT'),(3,'405b2abf-0864-11ef-8ff6-da2f5a35fe58','9a964568-0864-11ef-8ff6-da2f5a35fe58','MODEL'),(3,'405b2abf-0864-11ef-8ff6-da2f5a35fe58','9a965491-0864-11ef-8ff6-da2f5a35fe58','SNAPSHOT'),(3,'57229e01-06ed-11ef-90c8-dd3986f53a42','714f63b2-06ed-11ef-90c8-dd3986f53a42','MODEL'),(3,'57229e01-06ed-11ef-90c8-dd3986f53a42','714f73d7-06ed-11ef-90c8-dd3986f53a42','SNAPSHOT'),(3,'59e98ac5-0861-11ef-8ff6-da2f5a35fe58','25ab5185-0864-11ef-8ff6-da2f5a35fe58','LIFI'),(3,'59e98ac5-0861-11ef-8ff6-da2f5a35fe58','25ab54c4-0864-11ef-8ff6-da2f5a35fe58','LIFIMETA'),(3,'59e98ac5-0861-11ef-8ff6-da2f5a35fe58','d88962f2-0863-11ef-8ff6-da2f5a35fe58','LIFI'),(3,'59e98ac5-0861-11ef-8ff6-da2f5a35fe58','d88967ff-0863-11ef-8ff6-da2f5a35fe58','LIFIMETA'),(3,'59e98ac5-0861-11ef-8ff6-da2f5a35fe58','e0bfa86b-0863-11ef-8ff6-da2f5a35fe58','LIFI'),(3,'59e98ac5-0861-11ef-8ff6-da2f5a35fe58','e0bfadf4-0863-11ef-8ff6-da2f5a35fe58','LIFIMETA'),(3,'59e98ac5-0861-11ef-8ff6-da2f5a35fe58','ea71e741-0863-11ef-8ff6-da2f5a35fe58','LIFI'),(3,'59e98ac5-0861-11ef-8ff6-da2f5a35fe58','ea71eca5-0863-11ef-8ff6-da2f5a35fe58','LIFIMETA'),(3,'59e98ac5-0861-11ef-8ff6-da2f5a35fe58','eb746e19-0861-11ef-8ff6-da2f5a35fe58','MODEL'),(3,'59e98ac5-0861-11ef-8ff6-da2f5a35fe58','eb7485b0-0861-11ef-8ff6-da2f5a35fe58','SNAPSHOT'),(3,'91249277-0862-11ef-8ff6-da2f5a35fe58','17764359-0863-11ef-8ff6-da2f5a35fe58','MODEL'),(3,'91249277-0862-11ef-8ff6-da2f5a35fe58','17765260-0863-11ef-8ff6-da2f5a35fe58','SNAPSHOT'),(3,'91249277-0862-11ef-8ff6-da2f5a35fe58','2fbc2cef-0864-11ef-8ff6-da2f5a35fe58','LIFI'),(3,'91249277-0862-11ef-8ff6-da2f5a35fe58','2fbc3392-0864-11ef-8ff6-da2f5a35fe58','LIFIMETA'),(3,'be43909f-0868-11ef-8ff6-da2f5a35fe58','e94e0fa3-0868-11ef-8ff6-da2f5a35fe58','MODEL'),(3,'be43909f-0868-11ef-8ff6-da2f5a35fe58','e94e2f27-0868-11ef-8ff6-da2f5a35fe58','SNAPSHOT'),(3,'eacd5e79-0868-11ef-8ff6-da2f5a35fe58','06de7932-0869-11ef-8ff6-da2f5a35fe58','MODEL'),(3,'eacd5e79-0868-11ef-8ff6-da2f5a35fe58','06de8cba-0869-11ef-8ff6-da2f5a35fe58','SNAPSHOT');
/*!40000 ALTER TABLE `ScanFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SentAttachment`
--

DROP TABLE IF EXISTS `SentAttachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SentAttachment` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `sentMessageId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  PRIMARY KEY (`sentMessageId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `SentAttachment_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `SentAttachment_ibfk_2` FOREIGN KEY (`sentMessageId`) REFERENCES `SentMessage` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `SentAttachment_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SentAttachment`
--

LOCK TABLES `SentAttachment` WRITE;
/*!40000 ALTER TABLE `SentAttachment` DISABLE KEYS */;
INSERT INTO `SentAttachment` VALUES (3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','17764359-0863-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','17765260-0863-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','1f81ed28-0867-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','25ab5185-0864-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','25ab54c4-0864-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','2fbc2cef-0864-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','2fbc3392-0864-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','a3a69b8b-0864-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','a3e32cc1-0864-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','a3e332c3-0864-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','a3e37662-0864-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','a3e37c4f-0864-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','a3e3b7e2-0864-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','a413fc36-0864-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','a414024b-0864-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','a4f01daf-0864-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','bc911890-0863-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','bc912779-0863-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','bdd2799d-0864-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','ea71e741-0863-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','ea71eca5-0863-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','eb746e19-0861-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','eb7485b0-0861-11ef-8ff6-da2f5a35fe58'),(3,'32745aba-0869-11ef-8ff6-da2f5a35fe58','2aa61e09-0869-11ef-8ff6-da2f5a35fe58'),(3,'32745aba-0869-11ef-8ff6-da2f5a35fe58','2ac2bcfd-0869-11ef-8ff6-da2f5a35fe58'),(3,'32745aba-0869-11ef-8ff6-da2f5a35fe58','2b3e9ab9-0869-11ef-8ff6-da2f5a35fe58'),(3,'32745aba-0869-11ef-8ff6-da2f5a35fe58','3202c706-0869-11ef-8ff6-da2f5a35fe58'),(3,'4de24f2b-086d-11ef-8ff6-da2f5a35fe58','3102e726-086d-11ef-8ff6-da2f5a35fe58'),(3,'4de24f2b-086d-11ef-8ff6-da2f5a35fe58','3102fb86-086d-11ef-8ff6-da2f5a35fe58'),(3,'4de24f2b-086d-11ef-8ff6-da2f5a35fe58','4d7752a0-086d-11ef-8ff6-da2f5a35fe58'),(3,'97b9c350-06ed-11ef-90c8-dd3986f53a42','714f63b2-06ed-11ef-90c8-dd3986f53a42'),(3,'97b9c350-06ed-11ef-90c8-dd3986f53a42','714f73d7-06ed-11ef-90c8-dd3986f53a42'),(3,'97b9c350-06ed-11ef-90c8-dd3986f53a42','97508969-06ed-11ef-90c8-dd3986f53a42');
/*!40000 ALTER TABLE `SentAttachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SentMessage`
--

DROP TABLE IF EXISTS `SentMessage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SentMessage` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `discussionId` varchar(36) NOT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `answeredId` varchar(36) DEFAULT NULL COMMENT 'SentMessage uuid or ReceivedMessage originMessageId',
  `body` text DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `discussionId` (`discussionId`,`ownerId`),
  CONSTRAINT `SentMessage_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `SentMessage_ibfk_2` FOREIGN KEY (`discussionId`, `ownerId`) REFERENCES `Discussion` (`uuid`, `ownerId`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SentMessage`
--

LOCK TABLES `SentMessage` WRITE;
/*!40000 ALTER TABLE `SentMessage` DISABLE KEYS */;
INSERT INTO `SentMessage` VALUES ('0ab7a78f-a39e-4180-9e24-2f7e3d76ba8f',3,'97b97f39-06ed-11ef-90c8-dd3986f53a42','Commande 1.1.1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"validated\",\"title\":\"Commande 1.1.1.1\",\"date\":\"2024-06-14T00:00:00+02:00\",\"orderUpdateTime\":\"2024-04-30T14:32:57+02:00\",\"orderId\":\"4dd5f101-06ed-11ef-90c8-dd3986f53a42\"}','2024-04-30 14:32:58.000',NULL,'2024-04-30 14:32:58.000','2024-04-30 12:32:58.000','2024-04-30 14:32:58.000'),('154baa5a-086c-11ef-8ff6-da2f5a35fe58',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.1.2.1',NULL,'envoi messag page livraison troisième essai','2024-05-02 12:09:38.000',NULL,'2024-05-02 12:09:38.000','2024-05-02 10:09:38.000','2024-05-02 12:09:38.000'),('1fed5512-0867-11ef-8ff6-da2f5a35fe58',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.1.2.1',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.1.2.1\",\"date\":\"2024-05-03T00:00:00\",\"orderUpdateTime\":\"2024-05-02T11:34:08\",\"orderId\":\"58e7cf64-0861-11ef-8ff6-da2f5a35fe58\"}','2024-05-02 11:34:11.000',NULL,'2024-05-02 11:34:11.000','2024-05-02 09:34:11.000','2024-05-02 11:34:11.000'),('32745aba-0869-11ef-8ff6-da2f5a35fe58',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.1.3.1',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.1.3.1\",\"date\":\"2024-05-03T00:00:00\",\"orderUpdateTime\":\"2024-05-02T11:48:58\",\"orderId\":\"a0015ffe-0868-11ef-8ff6-da2f5a35fe58\"}','2024-05-02 11:49:00.000',NULL,'2024-05-02 11:49:00.000','2024-05-02 09:49:00.000','2024-05-02 11:49:00.000'),('3ffa3b3a-0869-11ef-8ff6-da2f5a35fe58',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.1.3.1',NULL,'envoi message avant reponse destinataire','2024-05-02 11:49:21.000',NULL,'2024-05-02 11:49:21.000','2024-05-02 09:49:21.000','2024-05-02 11:49:21.000'),('4de24f2b-086d-11ef-8ff6-da2f5a35fe58',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.1.5.1',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.1.5.1\",\"date\":\"2024-05-03T00:00:00\",\"orderUpdateTime\":\"2024-05-02T12:18:22\",\"orderId\":\"47d6e672-086d-11ef-8ff6-da2f5a35fe58\"}','2024-05-02 12:18:24.000',NULL,'2024-05-02 12:18:24.000','2024-05-02 10:18:24.000','2024-05-02 12:18:24.000'),('57c2d78c-086d-11ef-8ff6-da2f5a35fe58',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.1.5.1',NULL,'test avt reponse','2024-05-02 12:18:38.861',NULL,'2024-05-02 12:18:38.862','2024-05-02 10:18:38.862','2024-05-02 12:18:38.873'),('6d270b56-0c6a-4586-810b-b2149a940503',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.1.2.1',NULL,'API_META={\"type\":\"order\",\"key\":\"validated\",\"title\":\"Commande 1.1.2.1\",\"date\":\"2024-05-04T00:00:00+02:00\",\"orderUpdateTime\":\"2024-05-02T11:34:42+02:00\",\"orderId\":\"58e7cf64-0861-11ef-8ff6-da2f5a35fe58\"}','2024-05-02 11:34:42.000',NULL,'2024-05-02 11:34:42.000','2024-05-02 09:34:42.000','2024-05-02 11:34:42.000'),('97b9c350-06ed-11ef-90c8-dd3986f53a42',3,'97b97f39-06ed-11ef-90c8-dd3986f53a42','Commande 1.1.1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.1.1.1\",\"date\":\"2024-05-31T00:00:00\",\"orderUpdateTime\":\"2024-04-30T14:31:39\",\"orderId\":\"4dd5f101-06ed-11ef-90c8-dd3986f53a42\"}','2024-04-30 14:31:41.000',NULL,'2024-04-30 14:31:41.000','2024-04-30 12:31:41.000','2024-04-30 14:31:41.000'),('985a9923-0869-11ef-8ff6-da2f5a35fe58',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.1.3.1',NULL,'envoi message après validation cmde par destinataire, fait par la page discussion car non ok niveau page livraison','2024-05-02 11:51:49.243',NULL,'2024-05-02 11:51:49.243','2024-05-02 09:51:49.244','2024-05-02 11:51:49.255'),('9aa53190-086d-11ef-8ff6-da2f5a35fe58',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.1.5.1',NULL,'test après refus via page discussion filtrée','2024-05-02 12:20:31.075',NULL,'2024-05-02 12:20:31.075','2024-05-02 10:20:31.075','2024-05-02 12:20:31.085'),('d54e8176-0867-11ef-8ff6-da2f5a35fe58',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','d54e8176-0867-11ef-8ff6-da2f5a35fe58',NULL,'envoi via page de discussion','2024-05-02 11:39:12.512',NULL,'2024-05-02 11:39:12.512','2024-05-02 09:39:12.512','2024-05-02 11:39:12.523'),('ea731232-0867-11ef-8ff6-da2f5a35fe58',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.1.2.1',NULL,'envoi via discussion filtrée','2024-05-02 11:39:48.000',NULL,'2024-05-02 11:39:48.000','2024-05-02 09:39:48.000','2024-05-02 11:39:48.000');
/*!40000 ALTER TABLE `SentMessage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SentOrderNotification`
--

DROP TABLE IF EXISTS `SentOrderNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SentOrderNotification` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `recipientId` varchar(36) DEFAULT NULL,
  `rescueData` text DEFAULT NULL,
  `deliveryDate` datetime(3) DEFAULT NULL,
  `event` enum('EDITED','VALIDATED','CANCELLED') NOT NULL DEFAULT 'EDITED',
  `unread` tinyint(1) NOT NULL DEFAULT 1,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `orderId` (`orderId`),
  KEY `recipientId` (`recipientId`),
  CONSTRAINT `SentOrderNotification_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `SentOrderNotification_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `ProstheticOrder` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `SentOrderNotification_ibfk_3` FOREIGN KEY (`recipientId`) REFERENCES `Contact` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SentOrderNotification`
--

LOCK TABLES `SentOrderNotification` WRITE;
/*!40000 ALTER TABLE `SentOrderNotification` DISABLE KEYS */;
INSERT INTO `SentOrderNotification` VALUES ('1ec62ecb-1f1c-425a-a4f2-830764849d8a',3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','b84baf20-3ca6-4653-8341-ac721a404258','{\"recipientDisplayName\":\"client leger\",\"patientDisplayID\":\"00c2d95b-06ed-11ef-90c8-dd3986f53a42\",\"orderTitle\":\"Commande 1.1.2.1\"}','2024-05-04 00:00:00.000','EDITED',0,'2024-05-02 11:34:29.000',NULL,'2024-05-02 09:34:36.616','2024-05-02 11:34:36.626'),('29cae408-1dab-47be-8d3a-ddb30f70cf84',3,'47d6e672-086d-11ef-8ff6-da2f5a35fe58','b84baf20-3ca6-4653-8341-ac721a404258','{\"recipientDisplayName\":\"client leger\",\"patientDisplayID\":\"00c2d95b-06ed-11ef-90c8-dd3986f53a42\",\"orderTitle\":\"Commande 1.1.5.1\"}','2024-05-03 00:00:00.000','CANCELLED',0,'2024-05-02 12:19:34.000',NULL,'2024-05-02 10:19:59.000','2024-05-02 12:19:59.000'),('6bda340e-3186-4a4b-bbb4-fe77bb5a5aa1',3,'a0015ffe-0868-11ef-8ff6-da2f5a35fe58','b84baf20-3ca6-4653-8341-ac721a404258','{\"recipientDisplayName\":\"client leger\",\"patientDisplayID\":\"00c2d95b-06ed-11ef-90c8-dd3986f53a42\",\"orderTitle\":\"Commande 1.1.3.1\"}','2024-05-03 00:00:00.000','VALIDATED',0,'2024-05-02 11:49:46.000',NULL,'2024-05-02 10:09:03.394','2024-05-02 12:09:03.404'),('f36e032c-a34b-48fa-8391-783b97e1c1be',3,'4dd5f101-06ed-11ef-90c8-dd3986f53a42','8e4a4b16-c567-4bf8-a434-976b627a70ca','{\"recipientDisplayName\":\"Biotech-Dental LABORATOIRE\",\"patientDisplayID\":\"00c2d95b-06ed-11ef-90c8-dd3986f53a42\",\"orderTitle\":\"Commande 1.1.1.1\"}','2024-06-14 00:00:00.000','EDITED',0,'2024-04-30 14:32:47.000',NULL,'2024-05-02 09:12:54.449','2024-05-02 11:12:54.458');
/*!40000 ALTER TABLE `SentOrderNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Session`
--

DROP TABLE IF EXISTS `Session`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Session` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL,
  `actId` varchar(36) NOT NULL,
  `displayId` mediumint(8) unsigned DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT 0,
  `comments` text DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `actId` (`actId`),
  CONSTRAINT `Session_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `Session_ibfk_2` FOREIGN KEY (`actId`) REFERENCES `Act` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Session`
--

LOCK TABLES `Session` WRITE;
/*!40000 ALTER TABLE `Session` DISABLE KEYS */;
INSERT INTO `Session` VALUES ('1fcf8a88-086d-11ef-8ff6-da2f5a35fe58',3,'1fcf39f6-086d-11ef-8ff6-da2f5a35fe58',1,0,'','2024-05-02 12:17:04.992',NULL,'2024-05-02 12:17:04.993','2024-05-02 10:17:59.596','2024-05-02 12:17:59.625'),('4dd586c4-06ed-11ef-90c8-dd3986f53a42',3,'4dd3e575-06ed-11ef-90c8-dd3986f53a42',1,0,'','2024-04-30 14:29:35.463',NULL,'2024-04-30 14:29:35.463','2024-04-30 12:29:35.463','2024-04-30 14:29:35.465'),('58e77d50-0861-11ef-8ff6-da2f5a35fe58',3,'58e7015d-0861-11ef-8ff6-da2f5a35fe58',1,0,'','2024-05-02 10:52:46.819',NULL,'2024-05-02 10:52:46.819','2024-05-02 08:52:46.819','2024-05-02 10:52:46.821'),('a000fd43-0868-11ef-8ff6-da2f5a35fe58',3,'9fff6be0-0868-11ef-8ff6-da2f5a35fe58',1,0,'','2024-05-02 11:44:52.581',NULL,'2024-05-02 11:44:52.582','2024-05-02 09:44:52.582','2024-05-02 11:44:52.583');
/*!40000 ALTER TABLE `Session` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SmilersOrder`
--

DROP TABLE IF EXISTS `SmilersOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SmilersOrder` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `actId` varchar(36) NOT NULL,
  `title` varchar(64) DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT 0,
  `createdById` varchar(36) DEFAULT NULL,
  `updatedById` varchar(36) DEFAULT NULL,
  `displayId` mediumint(8) unsigned DEFAULT NULL,
  `json` text NOT NULL,
  `metadata` text NOT NULL,
  `status` enum('NOT_SENT','WAITING_WOW_API','SENDING_WOW_API','SENDING_SMILERS_API','SENT','CANCELLED','DELIVERY') NOT NULL DEFAULT 'NOT_SENT',
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `actId` (`actId`),
  CONSTRAINT `SmilersOrder_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `SmilersOrder_ibfk_2` FOREIGN KEY (`actId`) REFERENCES `Act` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SmilersOrder`
--

LOCK TABLES `SmilersOrder` WRITE;
/*!40000 ALTER TABLE `SmilersOrder` DISABLE KEYS */;
/*!40000 ALTER TABLE `SmilersOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SmilersOrderFile`
--

DROP TABLE IF EXISTS `SmilersOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SmilersOrderFile` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('FORM','SCAN') NOT NULL,
  PRIMARY KEY (`orderId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `SmilersOrderFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `SmilersOrderFile_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `SmilersOrder` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `SmilersOrderFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SmilersOrderFile`
--

LOCK TABLES `SmilersOrderFile` WRITE;
/*!40000 ALTER TABLE `SmilersOrderFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `SmilersOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SyncInfo`
--

DROP TABLE IF EXISTS `SyncInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SyncInfo` (
  `id` mediumint(8) unsigned NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `directLastRetrieved` text DEFAULT NULL COMMENT 'Direct last retrieved date values as json',
  `autoLastRetrieved` text DEFAULT NULL COMMENT 'Auto last retrieved date values as json',
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  PRIMARY KEY (`id`,`ownerId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SyncInfo`
--

LOCK TABLES `SyncInfo` WRITE;
/*!40000 ALTER TABLE `SyncInfo` DISABLE KEYS */;
INSERT INTO `SyncInfo` VALUES (1,1,NULL,NULL,'2024-04-30 12:26:31.656'),(1,2,NULL,NULL,'2024-04-30 12:34:01.223'),(1,3,NULL,'{\"contactsAutoLastRetrieved\":\"2024-05-02 11:33:13\",\"discussionsAutoLastRetrieved\":\"2024-05-02 12:20:31\",\"messagesAutoLastRetrieved\":\"2024-05-02 12:19:35\",\"notificationsAutoLastRetrieved\":\"2024-05-02 12:19:59\",\"prostheticOrdersAutoLastRetrieved\":\"2024-05-02 12:19:34\"}','2024-05-02 10:20:33.066'),(1,4,NULL,NULL,'2024-05-02 09:30:49.264');
/*!40000 ALTER TABLE `SyncInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SystemNotification`
--

DROP TABLE IF EXISTS `SystemNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SystemNotification` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `event` enum('NO_CONNECTION_FOR_X_DAYS') NOT NULL DEFAULT 'NO_CONNECTION_FOR_X_DAYS',
  `unread` tinyint(1) NOT NULL DEFAULT 1,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  CONSTRAINT `SystemNotification_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SystemNotification`
--

LOCK TABLES `SystemNotification` WRITE;
/*!40000 ALTER TABLE `SystemNotification` DISABLE KEYS */;
/*!40000 ALTER TABLE `SystemNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Token`
--

DROP TABLE IF EXISTS `Token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Token` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `credentialsId` varchar(36) DEFAULT NULL,
  `token` char(200) NOT NULL,
  `context` char(40) DEFAULT NULL,
  `device` char(255) DEFAULT NULL,
  `created` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `token` (`token`),
  KEY `credentialsId` (`credentialsId`),
  CONSTRAINT `Token_ibfk_1` FOREIGN KEY (`credentialsId`) REFERENCES `Credentials` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Token`
--

LOCK TABLES `Token` WRITE;
/*!40000 ALTER TABLE `Token` DISABLE KEYS */;
INSERT INTO `Token` VALUES ('0ecd5fef-06ed-11ef-90c8-dd3986f53a42',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','2e3122c91b5551c78258347271a1096525a350f6','software','CondorScan','2024-04-30 14:27:49.713','2024-04-30 12:27:49.713'),('2744c352-0868-11ef-8ff6-da2f5a35fe58',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','3e8f53fbacd53dd74e3f9020bf3c6b9733bb9d13','software','CondorScan','2024-05-02 11:41:30.021','2024-05-02 09:41:30.021'),('41abd643-06ed-11ef-90c8-dd3986f53a42',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','a26ff196055f14739be529a497e16249e58ef33a','software','CondorScan','2024-04-30 14:29:15.057','2024-04-30 12:29:15.057'),('4b19d5d5-0861-11ef-8ff6-da2f5a35fe58',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','ba8aa9b4504b70dbfafc6e92e7559d4bc2ffee81','software','CondorScan','2024-05-02 10:52:23.660','2024-05-02 08:52:23.661'),('7f7b7e50-0866-11ef-8ff6-da2f5a35fe58',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','94454303a9b54b2f51bb73e0f4d9946a8158e224','software','CondorScan','2024-05-02 11:29:39.026','2024-05-02 09:29:39.026'),('df720ffe-06ec-11ef-90c8-dd3986f53a42',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','2363d216f1f17c5513f7840be416245b6579cb38','software','CondorScan','2024-04-30 14:26:30.260','2024-04-30 12:26:30.926');
/*!40000 ALTER TABLE `Token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `__db_version__`
--

DROP TABLE IF EXISTS `__db_version__`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `__db_version__` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `versionMajor` int(11) NOT NULL,
  `versionMinor` int(11) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `migrationFile` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `__db_version__`
--

LOCK TABLES `__db_version__` WRITE;
/*!40000 ALTER TABLE `__db_version__` DISABLE KEYS */;
INSERT INTO `__db_version__` VALUES (1,1,0,'v1.0','iris_application_1.0_create_application'),(2,1,1,'v1.1','iris_application_1.1_occlusion_pap'),(3,1,2,'v1.2','iris_application_1.2_occlusion_pre_preparation'),(4,1,3,'v1.3','iris_application_1.3_occlusion_rework'),(5,1,4,'v1.4','iris_application_1.4_scan_label'),(6,1,5,'v1.5','iris_application_1.5_order_delivery'),(7,1,6,'v1.6','iris_application_1.6_sheet_json'),(8,1,7,'v1.7','iris_application_1.7_config_patient_list'),(9,1,8,'v1.8','iris_application_1.8_metering'),(10,1,9,'v1.9','iris_application_1.9_segmentation'),(11,1,10,'v1.10','iris_application_1.10_analyse'),(12,1,11,'v1.11','iris_application_1.11_messages'),(13,1,12,'v1.12','iris_application_1.12_scan_sup'),(14,1,13,'v1.13','iris_application_1.13_config'),(15,1,14,'v1.14','iris_application_1.14_syncinfo');
/*!40000 ALTER TABLE `__db_version__` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping routines for database 'iris_application'
--
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
/*!50003 DROP FUNCTION IF EXISTS `fileMetadataToLabel` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8mb3_general_ci */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `fileMetadataToLabel`(metadata TEXT) RETURNS text CHARSET utf8mb4 COLLATE utf8mb4_general_ci
    NO SQL
BEGIN
    IF metadata LIKE '%scanBodies%' THEN RETURN 'SCANBODY'; END IF;

    RETURN 'SCAN';
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewOcclusionFileType` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8mb3_general_ci */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewOcclusionFileType`(oldType TEXT) RETURNS text CHARSET utf8mb4 COLLATE utf8mb4_general_ci
    NO SQL
BEGIN
    IF oldType = 'OCCLUSION_RESULT' THEN RETURN 'RESULT'; END IF;

    IF oldType = 'MANDIBULE_PLY' THEN RETURN 'MANDIBLE'; END IF;

    IF oldType = 'MAXILLAIRE_PLY' THEN RETURN 'MAXILLARY'; END IF;

    IF oldType = 'MANDIBULE_MATRIX' THEN RETURN 'MANDIBLE_MATRIX'; END IF;

    IF oldType = 'MAXILLAIRE_MATRIX' THEN RETURN 'MAXILLARY_MATRIX'; END IF;

    IF oldType = 'LIFIMETA' THEN RETURN 'LIFIMETA'; END IF;

    IF oldType = 'LIFI' THEN RETURN 'LIFI'; END IF;

    IF oldType = 'SNAPSHOT' THEN RETURN 'SNAPSHOT'; END IF;

    IF oldType = 'SCREENSHOT' THEN RETURN 'SCREENSHOT'; END IF;

    
    IF oldType = 'LEFT_BITE' THEN RETURN 'RESULT'; END IF;
    IF oldType = 'RIGHT_BITE' THEN RETURN 'RESULT'; END IF;
    IF oldType = 'ANTERIOR_BITE' THEN RETURN 'RESULT'; END IF;

    RETURN oldType;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewProstheticContactPoint` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8mb3_general_ci */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewProstheticContactPoint`(old TEXT) RETURNS int(11)
    NO SQL
BEGIN
    IF old = '2' THEN RETURN 0; END IF;
    IF old = '3' THEN RETURN 1; END IF;
    IF old = '4' THEN RETURN 2; END IF;
    RETURN 1;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewProstheticCrownOrBridgeSubType` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8mb3_general_ci */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewProstheticCrownOrBridgeSubType`(old TEXT) RETURNS int(11)
    NO SQL
BEGIN
    IF old = '1' THEN RETURN 0; END IF;
    IF old = '2' THEN RETURN 1; END IF;
    IF old = '3' THEN RETURN 2; END IF;
    RETURN 0;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewProstheticGouttiereSubType` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8mb3_general_ci */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewProstheticGouttiereSubType`(old TEXT) RETURNS int(11)
    NO SQL
BEGIN
    IF old = '1' THEN RETURN 1; END IF;
    IF old = '2' THEN RETURN 2; END IF;
    IF old = '3' THEN RETURN 3; END IF;
    IF old = '4' THEN RETURN 0; END IF;
    IF old = '5' THEN RETURN 4; END IF;
    IF old = '6' THEN RETURN 5; END IF;
    IF old = '7' THEN RETURN 6; END IF;
    RETURN 0;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewProstheticImplantCrownSubType` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8mb3_general_ci */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewProstheticImplantCrownSubType`(old TEXT) RETURNS int(11)
    NO SQL
BEGIN
    IF old = '1' THEN RETURN 0; END IF;
    IF old = '2' THEN RETURN 1; END IF;
    IF old = '3' THEN RETURN 0; END IF;
    IF old = '4' THEN RETURN 1; END IF;
    RETURN 2;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewProstheticInlayOnlaySubType` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8mb3_general_ci */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewProstheticInlayOnlaySubType`(old TEXT) RETURNS int(11)
    NO SQL
BEGIN
    IF old = '1' THEN RETURN 0; END IF;
    IF old = '2' THEN RETURN 1; END IF;
    RETURN 2;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
/*!50003 DROP FUNCTION IF EXISTS `scanMetadataToLabel` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8mb3_general_ci */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `scanMetadataToLabel`(metadata TEXT) RETURNS text CHARSET utf8mb4 COLLATE utf8mb4_general_ci
    NO SQL
BEGIN
    IF metadata LIKE '%"isPrePreparation":true%' THEN RETURN 'PRE_PREPARATION'; END IF;

    RETURN 'SCAN';
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2024-05-02 12:21:49
