-- MariaDB dump 10.19  Distrib 10.6.16-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: localhost    Database: iris_patient
-- ------------------------------------------------------
-- Server version	10.6.16-MariaDB-0ubuntu0.22.04.1

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `AddressInfo`
--

DROP TABLE IF EXISTS `AddressInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `AddressInfo` (
  `uuid` varchar(36) NOT NULL,
  `line0` varchar(255) DEFAULT NULL,
  `line1` varchar(255) DEFAULT NULL,
  `line2` varchar(255) DEFAULT NULL,
  `detail` varchar(255) DEFAULT NULL,
  `cityName` varchar(255) DEFAULT NULL,
  `cityState` varchar(255) DEFAULT NULL,
  `cityZip` varchar(255) DEFAULT NULL,
  `countryName` varchar(255) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AddressInfo`
--

LOCK TABLES `AddressInfo` WRITE;
/*!40000 ALTER TABLE `AddressInfo` DISABLE KEYS */;
INSERT INTO `AddressInfo` VALUES ('00c2e83a-06ed-11ef-90c8-dd3986f53a42','','','','','','','','','2024-04-30 12:27:26.158','2024-04-30 14:27:26.172'),('00c2f682-06ed-11ef-90c8-dd3986f53a42','','','','','','','','','2024-04-30 12:27:26.168','2024-04-30 14:27:26.172'),('21d16612-0943-11ef-8f65-d9283bb1c6cd','cbvcbvcb','','','','cbvcb','','xbcvbvc','','2024-05-03 12:24:39.091','2024-05-03 14:24:44.203'),('21d17156-0943-11ef-8f65-d9283bb1c6cd','dvxcvxcvbcx','','','','cbcxbcvb','','xcbxcb','','2024-05-03 12:24:23.559','2024-05-03 14:24:44.203'),('bbee5e48-094f-11ef-8f65-d9283bb1c6cd','','','','','','','','','2024-05-03 13:19:13.824','2024-05-03 15:34:28.138'),('bbee6ca9-094f-11ef-8f65-d9283bb1c6cd','','','','','','','','','2024-05-03 13:19:13.832','2024-05-03 15:34:28.138');
/*!40000 ALTER TABLE `AddressInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `EmergencyContact`
--

DROP TABLE IF EXISTS `EmergencyContact`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `EmergencyContact` (
  `uuid` varchar(36) NOT NULL,
  `personInfoId` varchar(36) NOT NULL,
  `phoneInfoId` varchar(36) NOT NULL,
  `addressInfoId` varchar(36) NOT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `personInfoId` (`personInfoId`),
  UNIQUE KEY `phoneInfoId` (`phoneInfoId`),
  UNIQUE KEY `addressInfoId` (`addressInfoId`),
  CONSTRAINT `EmergencyContact_ibfk_1` FOREIGN KEY (`personInfoId`) REFERENCES `PersonInfo` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `EmergencyContact_ibfk_2` FOREIGN KEY (`phoneInfoId`) REFERENCES `PhoneInfo` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `EmergencyContact_ibfk_3` FOREIGN KEY (`addressInfoId`) REFERENCES `AddressInfo` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `EmergencyContact`
--

LOCK TABLES `EmergencyContact` WRITE;
/*!40000 ALTER TABLE `EmergencyContact` DISABLE KEYS */;
INSERT INTO `EmergencyContact` VALUES ('00c2eca5-06ed-11ef-90c8-dd3986f53a42','00c2f0fb-06ed-11ef-90c8-dd3986f53a42','00c2f555-06ed-11ef-90c8-dd3986f53a42','00c2f682-06ed-11ef-90c8-dd3986f53a42','2024-04-30 12:27:26.169','2024-04-30 14:27:26.172'),('21d16ac3-0943-11ef-8f65-d9283bb1c6cd','21d16d99-0943-11ef-8f65-d9283bb1c6cd','21d17056-0943-11ef-8f65-d9283bb1c6cd','21d17156-0943-11ef-8f65-d9283bb1c6cd','2024-05-03 12:24:17.242','2024-05-03 14:24:44.203'),('bbee62a2-094f-11ef-8f65-d9283bb1c6cd','bbee6709-094f-11ef-8f65-d9283bb1c6cd','bbee6b76-094f-11ef-8f65-d9283bb1c6cd','bbee6ca9-094f-11ef-8f65-d9283bb1c6cd','2024-05-03 13:34:28.128','2024-05-03 15:34:28.138');
/*!40000 ALTER TABLE `EmergencyContact` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Patient`
--

DROP TABLE IF EXISTS `Patient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Patient` (
  `uuid` varchar(36) NOT NULL,
  `personInfoId` varchar(36) NOT NULL,
  `phoneInfoId` varchar(36) NOT NULL,
  `addressInfoId` varchar(36) NOT NULL,
  `emergencyContactId` varchar(36) NOT NULL,
  `practitionerId` varchar(36) NOT NULL,
  `displayId` mediumint(8) unsigned DEFAULT NULL,
  `globalId` mediumint(8) unsigned DEFAULT NULL,
  `socialSecurity` varchar(255) DEFAULT NULL,
  `allergies` varchar(255) DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT 0,
  `comments` text DEFAULT NULL,
  `privateComments` text DEFAULT NULL,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `personInfoId` (`personInfoId`),
  UNIQUE KEY `phoneInfoId` (`phoneInfoId`),
  UNIQUE KEY `addressInfoId` (`addressInfoId`),
  UNIQUE KEY `emergencyContactId` (`emergencyContactId`),
  UNIQUE KEY `practitionerId` (`practitionerId`),
  CONSTRAINT `Patient_ibfk_1` FOREIGN KEY (`personInfoId`) REFERENCES `PersonInfo` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Patient_ibfk_2` FOREIGN KEY (`phoneInfoId`) REFERENCES `PhoneInfo` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Patient_ibfk_3` FOREIGN KEY (`addressInfoId`) REFERENCES `AddressInfo` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Patient_ibfk_4` FOREIGN KEY (`emergencyContactId`) REFERENCES `EmergencyContact` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Patient_ibfk_5` FOREIGN KEY (`practitionerId`) REFERENCES `Practitioner` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Patient`
--

LOCK TABLES `Patient` WRITE;
/*!40000 ALTER TABLE `Patient` DISABLE KEYS */;
INSERT INTO `Patient` VALUES ('00c2d95b-06ed-11ef-90c8-dd3986f53a42','00c2dee3-06ed-11ef-90c8-dd3986f53a42','00c2e377-06ed-11ef-90c8-dd3986f53a42','00c2e83a-06ed-11ef-90c8-dd3986f53a42','00c2eca5-06ed-11ef-90c8-dd3986f53a42','00c2f8fc-06ed-11ef-90c8-dd3986f53a42',1,1,'','',0,'','',NULL,'2024-04-30 14:27:26.157','2024-04-30 12:27:26.170','2024-04-30 14:27:26.172'),('21d1572e-0943-11ef-8f65-d9283bb1c6cd','21d15cc0-0943-11ef-8f65-d9283bb1c6cd','21d16173-0943-11ef-8f65-d9283bb1c6cd','21d16612-0943-11ef-8f65-d9283bb1c6cd','21d16ac3-0943-11ef-8f65-d9283bb1c6cd','21d17304-0943-11ef-8f65-d9283bb1c6cd',2,1,'xbcxbc','cxbcxb',0,'xcbcxbcvb','',NULL,'2024-05-03 14:24:44.200','2024-05-03 12:24:44.201','2024-05-03 14:24:44.203'),('bbee50d8-094f-11ef-8f65-d9283bb1c6cd','bbee5582-094f-11ef-8f65-d9283bb1c6cd','bbee59e5-094f-11ef-8f65-d9283bb1c6cd','bbee5e48-094f-11ef-8f65-d9283bb1c6cd','bbee62a2-094f-11ef-8f65-d9283bb1c6cd','bbee6e35-094f-11ef-8f65-d9283bb1c6cd',1,1,'','',0,'','',NULL,'2024-05-03 15:34:28.127','2024-05-03 13:34:28.128','2024-05-03 15:34:28.138');
/*!40000 ALTER TABLE `Patient` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PersonInfo`
--

DROP TABLE IF EXISTS `PersonInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `PersonInfo` (
  `uuid` varchar(36) NOT NULL,
  `firstname` varchar(64) NOT NULL,
  `lastname` varchar(64) NOT NULL,
  `birthdate` datetime(3) DEFAULT NULL,
  `sex` enum('M','F') DEFAULT 'M',
  `email` varchar(255) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PersonInfo`
--

LOCK TABLES `PersonInfo` WRITE;
/*!40000 ALTER TABLE `PersonInfo` DISABLE KEYS */;
INSERT INTO `PersonInfo` VALUES ('00c2dee3-06ed-11ef-90c8-dd3986f53a42','msi pam wow','ref125','2024-04-30 00:00:00.000','F','','2024-04-30 12:27:26.157','2024-04-30 14:27:26.172'),('00c2f0fb-06ed-11ef-90c8-dd3986f53a42','','',NULL,'M','','2024-04-30 12:27:26.158','2024-04-30 14:27:26.172'),('21d15cc0-0943-11ef-8f65-d9283bb1c6cd','msi pam wow','ref126','2024-05-03 00:00:00.000','F','cbvcb','2024-05-03 12:24:40.674','2024-05-03 14:24:44.203'),('21d16d99-0943-11ef-8f65-d9283bb1c6cd','cxbvcxbcx','vxbcbvcx',NULL,'M','','2024-05-03 12:24:20.683','2024-05-03 14:24:44.203'),('bbee5582-094f-11ef-8f65-d9283bb1c6cd','msi pam wow','ref126','2024-05-03 00:00:00.000','M','','2024-05-03 13:34:28.127','2024-05-03 15:34:28.138'),('bbee6709-094f-11ef-8f65-d9283bb1c6cd','','',NULL,'M','','2024-05-03 13:19:13.824','2024-05-03 15:34:28.138');
/*!40000 ALTER TABLE `PersonInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PhoneInfo`
--

DROP TABLE IF EXISTS `PhoneInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `PhoneInfo` (
  `uuid` varchar(36) NOT NULL,
  `phone` varchar(45) DEFAULT NULL,
  `cellular` varchar(45) DEFAULT NULL,
  `fax` varchar(45) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PhoneInfo`
--

LOCK TABLES `PhoneInfo` WRITE;
/*!40000 ALTER TABLE `PhoneInfo` DISABLE KEYS */;
INSERT INTO `PhoneInfo` VALUES ('00c2e377-06ed-11ef-90c8-dd3986f53a42','','','','2024-04-30 12:27:26.157','2024-04-30 14:27:26.172'),('00c2f555-06ed-11ef-90c8-dd3986f53a42','','','','2024-04-30 12:27:26.158','2024-04-30 14:27:26.172'),('00c2fa8d-06ed-11ef-90c8-dd3986f53a42','','','','2024-04-30 12:27:26.170','2024-04-30 14:27:26.172'),('21d16173-0943-11ef-8f65-d9283bb1c6cd','cbvcb','cbvcbcvb','','2024-05-03 12:24:44.201','2024-05-03 14:24:44.203'),('21d17056-0943-11ef-8f65-d9283bb1c6cd','xcbcxb','','','2024-05-03 12:24:25.114','2024-05-03 14:24:44.203'),('21d17424-0943-11ef-8f65-d9283bb1c6cd','xbcxbcv','','','2024-05-03 12:24:27.989','2024-05-03 14:24:44.203'),('bbee59e5-094f-11ef-8f65-d9283bb1c6cd','','','','2024-05-03 13:19:13.823','2024-05-03 15:34:28.138'),('bbee6b76-094f-11ef-8f65-d9283bb1c6cd','','','','2024-05-03 13:19:13.824','2024-05-03 15:34:28.138'),('bbee6f2b-094f-11ef-8f65-d9283bb1c6cd','','','','2024-05-03 13:19:13.834','2024-05-03 15:34:28.138');
/*!40000 ALTER TABLE `PhoneInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Practitioner`
--

DROP TABLE IF EXISTS `Practitioner`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Practitioner` (
  `uuid` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `phoneInfoId` varchar(36) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `phoneInfoId` (`phoneInfoId`),
  CONSTRAINT `Practitioner_ibfk_1` FOREIGN KEY (`phoneInfoId`) REFERENCES `PhoneInfo` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Practitioner`
--

LOCK TABLES `Practitioner` WRITE;
/*!40000 ALTER TABLE `Practitioner` DISABLE KEYS */;
INSERT INTO `Practitioner` VALUES ('00c2f8fc-06ed-11ef-90c8-dd3986f53a42','','00c2fa8d-06ed-11ef-90c8-dd3986f53a42','2024-04-30 12:27:26.170','2024-04-30 14:27:26.172'),('21d17304-0943-11ef-8f65-d9283bb1c6cd','cxbxbc','21d17424-0943-11ef-8f65-d9283bb1c6cd','2024-05-03 12:24:26.781','2024-05-03 14:24:44.203'),('bbee6e35-094f-11ef-8f65-d9283bb1c6cd','','bbee6f2b-094f-11ef-8f65-d9283bb1c6cd','2024-05-03 13:34:28.128','2024-05-03 15:34:28.138');
/*!40000 ALTER TABLE `Practitioner` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `__db_version__`
--

DROP TABLE IF EXISTS `__db_version__`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `__db_version__` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `versionMajor` int(11) NOT NULL,
  `versionMinor` int(11) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `migrationFile` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `__db_version__`
--

LOCK TABLES `__db_version__` WRITE;
/*!40000 ALTER TABLE `__db_version__` DISABLE KEYS */;
INSERT INTO `__db_version__` VALUES (1,1,0,'v1.0','iris_patient_1.0_create_patient');
/*!40000 ALTER TABLE `__db_version__` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping routines for database 'iris_patient'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2024-05-13  9:57:21
