-- MariaDB dump 10.19  Distrib 10.6.16-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: localhost    Database: iris_application
-- ------------------------------------------------------
-- Server version	10.6.16-MariaDB-0ubuntu0.22.04.1

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `Act`
--

DROP TABLE IF EXISTS `Act`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Act` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `patientId` varchar(36) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `displayId` mediumint(8) unsigned DEFAULT NULL,
  `workflow` enum('FREE','WORKFLOW_1','WORKFLOW_2','WORKFLOW_3','ANALYSE') NOT NULL DEFAULT 'FREE',
  `comments` text DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT 0,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastAccessed` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `patientId` (`patientId`),
  CONSTRAINT `Act_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `Act_ibfk_2` FOREIGN KEY (`patientId`) REFERENCES `iris_patient`.`Patient` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Act`
--

LOCK TABLES `Act` WRITE;
/*!40000 ALTER TABLE `Act` DISABLE KEYS */;
INSERT INTO `Act` VALUES ('01654717-0952-11ef-8f65-d9283bb1c6cd',3,'21d1572e-0943-11ef-8f65-d9283bb1c6cd','Scans 1.2.4',4,'FREE','{\"type\":\"IMPORTED_SCANS\"}',0,'2024-05-03 15:35:29.358',NULL,'2024-05-03 15:36:07.828','2024-05-03 15:35:29.358','2024-05-03 13:36:07.828','2024-05-03 15:36:07.837'),('0a477976-0952-11ef-8f65-d9283bb1c6cd',3,'21d1572e-0943-11ef-8f65-d9283bb1c6cd','Analyse 1.2.5',5,'ANALYSE','{\"type\":\"ANALYSE\"}',0,'2024-05-03 15:35:44.262',NULL,'2024-05-03 16:20:26.736','2024-05-03 15:35:44.262','2024-05-03 14:20:26.736','2024-05-03 16:20:26.738'),('176ffa22-11fa-11ef-8fe1-da2e5522abf3',3,'118618c7-11fa-11ef-8fe1-da2e5522abf3','Commande 1.5.1.1',1,'FREE','{\"type\":\"ORDER\"}',0,'2024-05-14 15:58:50.448',NULL,'2024-05-22 12:11:42.599','2024-05-14 15:58:50.463','2024-05-22 10:11:42.600','2024-05-22 12:11:42.601'),('1f4547de-1436-11ef-8f1b-d8242b6da0dc',3,'16032a0e-1436-11ef-8f1b-d8242b6da0dc','Commande 1.6.1.1',1,'FREE','{\"type\":\"ORDER\"}',0,'2024-05-17 12:13:35.719',NULL,'2024-05-22 16:03:58.576','2024-05-22 16:04:37.856','2024-05-22 14:04:37.856','2024-05-22 16:04:37.858'),('1fcf39f6-086d-11ef-8ff6-da2f5a35fe58',3,'00c2d95b-06ed-11ef-90c8-dd3986f53a42','Commande 1.1.5.1',5,'FREE','',0,'2024-05-02 12:17:04.990',NULL,'2024-05-14 10:12:44.746','2024-05-02 12:18:12.159','2024-05-14 08:12:44.746','2024-05-14 10:12:44.748'),('233ae18e-113d-11ef-8f8d-d92a44d56471',3,'4ce59675-1136-11ef-8f8d-d92a44d56471','Commande 1.3.2.1',2,'FREE','{\"type\":\"ORDER\"}',0,'2024-05-13 17:26:15.351',NULL,'2024-05-14 10:14:05.693','2024-05-13 17:26:15.371','2024-05-14 08:14:05.694','2024-05-14 10:14:05.703'),('2a532631-11cf-11ef-8f95-d92a45dc80ec',3,'235a3115-11cf-11ef-8f95-d92a45dc80ec','Commande 1.4.1.1',1,'FREE','{\"type\":\"ORDER\"}',0,'2024-05-14 10:51:33.777',NULL,'2024-05-14 11:01:36.641','2024-05-14 11:01:36.506','2024-05-14 09:01:36.641','2024-05-14 11:01:36.651'),('33ac516e-0943-11ef-8f65-d9283bb1c6cd',3,'21d1572e-0943-11ef-8f65-d9283bb1c6cd','Commande 1.2.1.1',1,'FREE','{\"type\":\"ORDER\"}',0,'2024-05-03 13:49:31.259',NULL,'2024-05-03 15:06:12.491','2024-05-03 14:17:06.495','2024-05-03 13:06:12.491','2024-05-03 15:06:12.501'),('3a94919f-1dd2-11ef-8f99-d92a46e09137',15,'de66fe79-1dd1-11ef-8f99-d92a46e09137','Commande 2.3.2.1',2,'FREE','{\"type\":\"ORDER\"}',0,'2024-05-29 17:43:43.492',NULL,'2024-05-29 17:43:43.637','2024-05-29 17:43:43.509','2024-05-29 15:43:43.637','2024-05-29 17:43:43.646'),('419ce9d8-1469-11ef-8f1b-d8242b6da0dc',3,'e7cdc6df-144c-11ef-8f1b-d8242b6da0dc','Commande 1.7.2.1',2,'FREE','{\"type\":\"ORDER\"}',0,'2024-05-17 18:19:37.669',NULL,'2024-05-22 16:03:49.904','2024-05-17 18:19:37.687','2024-05-22 14:03:49.905','2024-05-22 16:03:49.906'),('42c42325-0958-11ef-8f65-d9283bb1c6cd',3,'21d1572e-0943-11ef-8f65-d9283bb1c6cd','Commande 1.2.8.1',8,'FREE','{\"type\":\"ORDER\"}',0,'2024-05-03 16:20:16.012','2024-05-03 16:20:32.412','2024-05-03 16:20:23.417','2024-05-03 16:20:32.412','2024-05-03 14:20:32.412','2024-05-03 16:20:32.413'),('4545f685-0951-11ef-8f65-d9283bb1c6cd',3,'21d1572e-0943-11ef-8f65-d9283bb1c6cd','Direct scan 1.2.3',3,'FREE','{\"type\":\"DIRECT_SCAN\"}',0,'2024-05-03 15:30:13.741',NULL,'2024-05-03 15:31:31.297','2024-05-03 15:31:31.129','2024-05-03 13:31:31.297','2024-05-03 15:31:31.306'),('4dd3e575-06ed-11ef-90c8-dd3986f53a42',3,'00c2d95b-06ed-11ef-90c8-dd3986f53a42','Commande 1.1.1.1',1,'FREE','',0,'2024-04-30 14:29:35.452',NULL,'2024-04-30 14:30:35.312','2024-04-30 14:29:35.468','2024-04-30 12:30:35.312','2024-04-30 14:30:35.322'),('4fc2347a-0952-11ef-8f65-d9283bb1c6cd',3,'21d1572e-0943-11ef-8f65-d9283bb1c6cd','Commande 1.2.6.1',6,'FREE','{\"type\":\"ORDER\"}',0,'2024-05-03 15:37:40.829',NULL,'2024-05-03 16:16:20.312','2024-05-03 15:37:40.847','2024-05-03 14:16:20.312','2024-05-03 16:16:20.322'),('5748a11c-146a-11ef-8f1b-d8242b6da0dc',3,'e7cdc6df-144c-11ef-8f1b-d8242b6da0dc','Commande 1.7.3.1',3,'FREE','{\"type\":\"ORDER\"}',0,'2024-05-17 18:27:23.524',NULL,'2024-05-22 15:58:01.566','2024-05-22 16:00:13.964','2024-05-22 14:00:13.964','2024-05-22 16:00:13.966'),('58e7015d-0861-11ef-8ff6-da2f5a35fe58',3,'00c2d95b-06ed-11ef-90c8-dd3986f53a42','Commande 1.1.2.1',2,'FREE','',0,'2024-05-02 10:52:46.816',NULL,'2024-05-02 12:25:34.456','2024-05-02 10:52:46.823','2024-05-02 10:25:34.456','2024-05-02 12:25:34.466'),('67fc2b93-0953-11ef-8f65-d9283bb1c6cd',3,'21d1572e-0943-11ef-8f65-d9283bb1c6cd','Commande 1.2.7.1',7,'WORKFLOW_1','{\"type\":\"ORDER\"}',0,'2024-05-03 15:45:30.971',NULL,'2024-05-03 16:43:28.160','2024-05-03 15:45:30.987','2024-05-03 14:43:28.161','2024-05-03 16:43:28.162'),('6daf4255-0950-11ef-8f65-d9283bb1c6cd',3,'21d1572e-0943-11ef-8f65-d9283bb1c6cd','Scans 1.2.2',2,'FREE','{\"type\":\"IMPORTED_SCANS\"}',0,'2024-05-03 15:24:12.043',NULL,'2024-05-03 15:36:18.096','2024-05-03 15:24:12.044','2024-05-03 13:36:18.096','2024-05-03 15:36:18.105'),('71b85037-0958-11ef-8f65-d9283bb1c6cd',3,'21d1572e-0943-11ef-8f65-d9283bb1c6cd','Commande 1.2.9.1',9,'FREE','{\"type\":\"ORDER\"}',0,'2024-05-03 16:21:34.787',NULL,'2024-05-03 16:43:05.148','2024-05-03 16:21:34.805','2024-05-03 14:43:05.148','2024-05-03 16:43:05.158'),('7d7b190c-094f-11ef-8f65-d9283bb1c6cd',6,'bbee50d8-094f-11ef-8f65-d9283bb1c6cd','Commande 1.1.1.1',1,'FREE','{\"type\":\"ORDER\"}',0,'2024-05-03 15:17:29.048',NULL,'2024-05-28 14:54:11.574','2024-05-03 15:19:22.053','2024-05-28 12:54:11.574','2024-05-28 14:54:11.583'),('894496db-1cf1-11ef-8f68-d9283cb4d201',6,'8578524d-1cf1-11ef-8f68-d9283cb4d201','Commande 1.2.1.1',1,'FREE','{\"type\":\"ORDER\"}',0,'2024-05-28 14:55:18.744',NULL,'2024-05-28 16:31:51.210','2024-05-28 14:55:18.760','2024-05-28 14:31:51.210','2024-05-28 16:31:51.220'),('89504286-086c-11ef-8ff6-da2f5a35fe58',3,'00c2d95b-06ed-11ef-90c8-dd3986f53a42','Analyse 1.1.4',4,'ANALYSE','',0,'2024-05-02 12:12:52.500',NULL,'2024-05-02 12:12:52.524','2024-05-02 12:12:55.589','2024-05-02 10:12:55.589','2024-05-02 12:12:55.591'),('8afd42f5-146a-11ef-8f1b-d8242b6da0dc',3,'e7cdc6df-144c-11ef-8f1b-d8242b6da0dc','Commande 1.7.4.1',4,'WORKFLOW_2','{\"type\":\"ORDER\"}',0,'2024-05-17 18:28:50.271',NULL,'2024-05-22 12:11:06.173','2024-05-17 18:28:50.278','2024-05-22 10:11:06.173','2024-05-22 12:11:06.183'),('8c5787a0-146d-11ef-8f1b-d8242b6da0dc',3,'e7cdc6df-144c-11ef-8f1b-d8242b6da0dc','Scans 1.7.5',5,'FREE','{\"type\":\"IMPORTED_SCANS\"}',0,'2024-05-17 18:50:21.031',NULL,'2024-05-22 12:23:39.259','2024-05-17 18:50:53.938','2024-05-22 10:23:39.259','2024-05-22 12:23:39.269'),('9fff6be0-0868-11ef-8ff6-da2f5a35fe58',3,'00c2d95b-06ed-11ef-90c8-dd3986f53a42','Commande 1.1.3.1',3,'WORKFLOW_1','',0,'2024-05-02 11:44:52.571',NULL,'2024-05-02 12:25:39.776','2024-05-02 11:44:52.588','2024-05-02 10:25:39.776','2024-05-02 12:25:39.785'),('b1ce9a22-1749-11ef-8f86-d92942cf49fd',3,'e7cdc6df-144c-11ef-8f1b-d8242b6da0dc','Commande 1.7.6.1',6,'FREE','{\"type\":\"ORDER\"}',0,'2024-05-21 10:11:15.493',NULL,'2024-05-21 14:24:19.743','2024-05-21 14:30:43.992','2024-05-21 12:30:43.992','2024-05-21 14:30:43.994'),('b84ee75e-1f2c-11ef-8f88-d92a43d1501c',3,'654307f6-1f2c-11ef-8f88-d92a43d1501c','Commande 1.8.1.1',1,'FREE','{\"type\":\"ORDER\"}',0,'2024-05-31 11:04:00.297',NULL,'2024-05-31 11:07:27.518','2024-05-31 11:04:00.306','2024-05-31 09:07:27.518','2024-05-31 11:07:27.527'),('bcf58202-113b-11ef-8f8d-d92a44d56471',3,'4ce59675-1136-11ef-8f8d-d92a44d56471','Commande 1.3.1.1',1,'FREE','{\"type\":\"ORDER\"}',0,'2024-05-13 17:16:14.272',NULL,'2024-05-14 10:13:41.314','2024-05-13 17:16:14.290','2024-05-14 08:13:41.314','2024-05-14 10:13:41.324'),('c6ecdf7f-1dc9-11ef-8f99-d92a46e09137',14,'c6dd7b08-1dc9-11ef-8f99-d92a46e09137','Commande 1.1.1.1',1,'FREE','{\"type\":\"ORDER\"}',0,'2024-05-29 16:43:13.481',NULL,'2024-05-29 16:43:13.752','2024-05-29 16:46:31.885','2024-05-29 14:46:31.886','2024-05-29 16:46:31.887'),('d961f6f4-1437-11ef-8f1b-d8242b6da0dc',3,'16032a0e-1436-11ef-8f1b-d8242b6da0dc','Commande 1.6.3.1',3,'FREE','{\"type\":\"ORDER\"}',0,'2024-05-17 12:25:57.460',NULL,'2024-05-17 18:33:59.708','2024-05-17 12:25:57.479','2024-05-17 16:33:59.708','2024-05-17 18:33:59.717'),('d9e0b5cb-1436-11ef-8f1b-d8242b6da0dc',3,'16032a0e-1436-11ef-8f1b-d8242b6da0dc','Commande 1.6.2.1',2,'FREE','{\"type\":\"ORDER\"}',0,'2024-05-17 12:18:48.794',NULL,'2024-05-17 12:18:48.912','2024-05-17 12:18:48.812','2024-05-17 10:18:48.912','2024-05-17 12:18:48.914'),('dd5e304f-19c9-11ef-8fee-da2f582eded0',3,'e7cdc6df-144c-11ef-8f1b-d8242b6da0dc','Commande 1.7.8.1',8,'WORKFLOW_3','{\"type\":\"ORDER\"}',0,'2024-05-24 14:33:46.483',NULL,'2024-05-24 14:33:46.676','2024-05-24 14:33:46.503','2024-05-24 12:33:46.676','2024-05-28 16:35:03.986'),('df80ed21-19cb-11ef-8fee-da2f582eded0',3,'e7cdc6df-144c-11ef-8f1b-d8242b6da0dc','Commande 1.7.9.1',9,'FREE','{\"type\":\"ORDER\"}',0,'2024-05-24 14:48:09.059',NULL,'2024-05-24 14:48:09.250','2024-05-24 14:48:09.075','2024-05-24 12:48:09.250','2024-05-28 16:35:03.986'),('ec1c9685-1dd1-11ef-8f99-d92a46e09137',15,'de66fe79-1dd1-11ef-8f99-d92a46e09137','Commande 2.3.1.1',1,'FREE','{\"type\":\"ORDER\"}',0,'2024-05-29 17:41:31.844',NULL,'2024-05-29 17:44:46.327','2024-05-29 17:42:27.205','2024-05-29 15:44:46.328','2024-05-29 17:44:46.337'),('f0721624-144c-11ef-8f1b-d8242b6da0dc',3,'e7cdc6df-144c-11ef-8f1b-d8242b6da0dc','Commande 1.7.1.1',1,'FREE','{\"type\":\"ORDER\"}',0,'2024-05-17 14:56:55.585',NULL,'2024-05-22 16:01:34.676','2024-05-22 16:00:36.204','2024-05-22 14:01:34.676','2024-05-22 16:01:34.678'),('f5aa8d87-1824-11ef-8f8e-d92a44d6667d',3,'e7cdc6df-144c-11ef-8f1b-d8242b6da0dc','Commande 1.7.7.1',7,'FREE','{\"type\":\"ORDER\"}',0,'2024-05-22 12:20:49.126',NULL,'2024-05-22 16:03:08.312','2024-05-22 16:03:43.756','2024-05-22 14:03:43.756','2024-05-22 16:03:43.758');
/*!40000 ALTER TABLE `Act` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AddressInfo`
--

DROP TABLE IF EXISTS `AddressInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `AddressInfo` (
  `uuid` varchar(36) NOT NULL,
  `line0` varchar(255) DEFAULT NULL,
  `line1` varchar(255) DEFAULT NULL,
  `line2` varchar(255) DEFAULT NULL,
  `detail` varchar(255) DEFAULT NULL,
  `cityName` varchar(255) DEFAULT NULL,
  `cityState` varchar(255) DEFAULT NULL,
  `cityZip` varchar(255) DEFAULT NULL,
  `countryName` varchar(255) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AddressInfo`
--

LOCK TABLES `AddressInfo` WRITE;
/*!40000 ALTER TABLE `AddressInfo` DISABLE KEYS */;
INSERT INTO `AddressInfo` VALUES ('0788e1c4-cb4f-4340-8ad2-2ff803c01013','bla bla','','','','bla bla','','1111','France','2024-05-03 13:13:42.733','2024-05-28 15:51:10.000'),('21025360-b5bf-49b6-9fcb-713fdec1d6b7','','','','','','','','','2024-05-28 12:53:03.254','2024-05-28 14:54:07.240'),('234f4254-42b9-463d-9618-ac68be566f22','azertyuiop','','','','fdsqfdqf','','11154','France','2024-05-28 14:55:40.030','2024-05-29 16:13:20.000'),('2c571305-dd4e-4bcd-baac-ec78eda07e7a','rue des testsss','','','','fdsfdsfds','','23456','United States of America','2024-05-29 14:14:05.016','2024-05-29 16:37:29.000'),('4caacc66-8838-11ec-89bc-2e174fce41cd','Route du test','','','','Toulouse','','31100','France','2024-04-30 12:26:31.655','2024-04-30 13:44:41.000'),('58363558-12f0-4477-a836-a6476e5d243f','dsfdqfdqf','','','','sfdfdsqfs','','fedsqfd','France','2024-05-03 14:24:52.989','2024-05-17 18:23:07.000'),('67cbd5eb-5e68-4f9b-9a15-2b1a0dabbcef','site dev','','','','labege','','31670','France','2024-04-30 12:26:30.919','2024-05-29 16:57:45.000'),('a5e85963-fe76-4488-a34e-59cf90eee3e0','137 rue Garance','','','','Labège','','31670','France','2024-04-30 12:34:01.222','2024-04-30 14:37:26.000'),('b920f641-ec66-47f2-b374-25b1f9188d1d','','','','','labege','','','','2024-05-02 09:32:34.143','2024-05-02 11:33:13.000'),('ce12056e-5597-4850-b65d-d74e282fb653','avenue des tests','','','','brest','','11111','France','2024-05-29 10:22:45.070','2024-05-29 16:13:35.000'),('e24a5255-8e51-4126-be6a-dc7d67216e8e','','','','','','','','','2024-05-29 15:24:35.392','2024-05-29 17:18:57.000');
/*!40000 ALTER TABLE `AddressInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Analyse`
--

DROP TABLE IF EXISTS `Analyse`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Analyse` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `actId` varchar(36) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `type` enum('METERING','COMPARE') NOT NULL DEFAULT 'METERING',
  `displayId` mediumint(8) unsigned DEFAULT NULL,
  `comments` text DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `actId` (`actId`),
  CONSTRAINT `Analyse_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `Analyse_ibfk_2` FOREIGN KEY (`actId`) REFERENCES `Act` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Analyse`
--

LOCK TABLES `Analyse` WRITE;
/*!40000 ALTER TABLE `Analyse` DISABLE KEYS */;
INSERT INTO `Analyse` VALUES ('0a4b0ffa-0952-11ef-8f65-d9283bb1c6cd',3,'0a477976-0952-11ef-8f65-d9283bb1c6cd','','METERING',1,'{\"referenceScanId\":\"01670d72-0952-11ef-8f65-d9283bb1c6cd\"}','2024-05-03 15:35:44.286',NULL,'2024-05-03 13:35:55.263','2024-05-03 15:35:55.638'),('32ad8516-0957-11ef-8f65-d9283bb1c6cd',3,'0a477976-0952-11ef-8f65-d9283bb1c6cd','','COMPARE',2,'{\"referenceScanId\":\"35758d89-0943-11ef-8f65-d9283bb1c6cd\"}','2024-05-03 16:12:39.524',NULL,'2024-05-03 14:15:02.587','2024-05-03 16:15:03.020'),('895411ef-086c-11ef-8ff6-da2f5a35fe58',3,'89504286-086c-11ef-8ff6-da2f5a35fe58','','METERING',1,'{\"referenceScanId\":\"be43909f-0868-11ef-8ff6-da2f5a35fe58\"}','2024-05-02 12:12:52.525',NULL,'2024-05-02 10:12:55.584','2024-05-02 12:12:55.980'),('e0c477cf-0957-11ef-8f65-d9283bb1c6cd',3,'0a477976-0952-11ef-8f65-d9283bb1c6cd','','METERING',3,'{\"referenceScanId\":\"69c3c2e3-0953-11ef-8f65-d9283bb1c6cd\"}','2024-05-03 16:17:31.597',NULL,'2024-05-03 14:17:35.170','2024-05-03 16:17:35.532');
/*!40000 ALTER TABLE `Analyse` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AnalyseFile`
--

DROP TABLE IF EXISTS `AnalyseFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `AnalyseFile` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `analyseId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('TRANSFORMATION','SNAPSHOT','SCREENSHOT','METERING','RESULT') NOT NULL,
  PRIMARY KEY (`analyseId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `AnalyseFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `AnalyseFile_ibfk_2` FOREIGN KEY (`analyseId`) REFERENCES `Analyse` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `AnalyseFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AnalyseFile`
--

LOCK TABLES `AnalyseFile` WRITE;
/*!40000 ALTER TABLE `AnalyseFile` DISABLE KEYS */;
INSERT INTO `AnalyseFile` VALUES (3,'0a4b0ffa-0952-11ef-8f65-d9283bb1c6cd','10d5e323-0952-11ef-8f65-d9283bb1c6cd','TRANSFORMATION'),(3,'0a4b0ffa-0952-11ef-8f65-d9283bb1c6cd','110d8194-0952-11ef-8f65-d9283bb1c6cd','SNAPSHOT'),(3,'0a4b0ffa-0952-11ef-8f65-d9283bb1c6cd','df31bbd6-0957-11ef-8f65-d9283bb1c6cd','SCREENSHOT'),(3,'0a4b0ffa-0952-11ef-8f65-d9283bb1c6cd','e7bf8567-0957-11ef-8f65-d9283bb1c6cd','SCREENSHOT'),(3,'0a4b0ffa-0952-11ef-8f65-d9283bb1c6cd','f41b9ab0-0957-11ef-8f65-d9283bb1c6cd','SCREENSHOT'),(3,'0a4b0ffa-0952-11ef-8f65-d9283bb1c6cd','f974eadb-0957-11ef-8f65-d9283bb1c6cd','SCREENSHOT'),(3,'32ad8516-0957-11ef-8f65-d9283bb1c6cd','87f32b29-0957-11ef-8f65-d9283bb1c6cd','TRANSFORMATION'),(3,'32ad8516-0957-11ef-8f65-d9283bb1c6cd','88334fd2-0957-11ef-8f65-d9283bb1c6cd','SNAPSHOT'),(3,'32ad8516-0957-11ef-8f65-d9283bb1c6cd','ceb4b079-0957-11ef-8f65-d9283bb1c6cd','SCREENSHOT'),(3,'32ad8516-0957-11ef-8f65-d9283bb1c6cd','dc978755-0957-11ef-8f65-d9283bb1c6cd','SCREENSHOT'),(3,'32ad8516-0957-11ef-8f65-d9283bb1c6cd','eb3a6705-0957-11ef-8f65-d9283bb1c6cd','SCREENSHOT'),(3,'895411ef-086c-11ef-8ff6-da2f5a35fe58','8b26c5be-086c-11ef-8ff6-da2f5a35fe58','TRANSFORMATION'),(3,'895411ef-086c-11ef-8ff6-da2f5a35fe58','8b60cf5e-086c-11ef-8ff6-da2f5a35fe58','SNAPSHOT'),(3,'895411ef-086c-11ef-8ff6-da2f5a35fe58','fc095480-086c-11ef-8ff6-da2f5a35fe58','METERING'),(3,'e0c477cf-0957-11ef-8f65-d9283bb1c6cd','e2e58607-0957-11ef-8f65-d9283bb1c6cd','TRANSFORMATION'),(3,'e0c477cf-0957-11ef-8f65-d9283bb1c6cd','e31a6109-0957-11ef-8f65-d9283bb1c6cd','SNAPSHOT'),(3,'e0c477cf-0957-11ef-8f65-d9283bb1c6cd','edd56113-0957-11ef-8f65-d9283bb1c6cd','SCREENSHOT');
/*!40000 ALTER TABLE `AnalyseFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AnalyseScan`
--

DROP TABLE IF EXISTS `AnalyseScan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `AnalyseScan` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `analyseId` varchar(36) NOT NULL,
  `scanId` varchar(36) NOT NULL,
  PRIMARY KEY (`analyseId`,`scanId`),
  KEY `ownerId` (`ownerId`),
  KEY `scanId` (`scanId`),
  CONSTRAINT `AnalyseScan_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `AnalyseScan_ibfk_2` FOREIGN KEY (`analyseId`) REFERENCES `Analyse` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `AnalyseScan_ibfk_3` FOREIGN KEY (`scanId`) REFERENCES `Scan` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AnalyseScan`
--

LOCK TABLES `AnalyseScan` WRITE;
/*!40000 ALTER TABLE `AnalyseScan` DISABLE KEYS */;
INSERT INTO `AnalyseScan` VALUES (3,'0a4b0ffa-0952-11ef-8f65-d9283bb1c6cd','01670d72-0952-11ef-8f65-d9283bb1c6cd'),(3,'32ad8516-0957-11ef-8f65-d9283bb1c6cd','01670d72-0952-11ef-8f65-d9283bb1c6cd'),(3,'32ad8516-0957-11ef-8f65-d9283bb1c6cd','35758d89-0943-11ef-8f65-d9283bb1c6cd'),(3,'895411ef-086c-11ef-8ff6-da2f5a35fe58','be43909f-0868-11ef-8ff6-da2f5a35fe58'),(3,'e0c477cf-0957-11ef-8f65-d9283bb1c6cd','69c3c2e3-0953-11ef-8f65-d9283bb1c6cd');
/*!40000 ALTER TABLE `AnalyseScan` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Assistant`
--

DROP TABLE IF EXISTS `Assistant`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Assistant` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `credentialsId` varchar(36) DEFAULT NULL,
  `personInfoId` varchar(36) NOT NULL,
  `phoneInfoId` varchar(36) NOT NULL,
  `addressInfoId` varchar(36) NOT NULL,
  `officeId` varchar(36) DEFAULT NULL,
  `patientRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'READ_ONLY',
  `actRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'NOTHING',
  `discussionRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'NOTHING',
  `tempPassword` varchar(32) DEFAULT NULL,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `credentialsId` (`credentialsId`),
  KEY `personInfoId` (`personInfoId`),
  KEY `phoneInfoId` (`phoneInfoId`),
  KEY `addressInfoId` (`addressInfoId`),
  KEY `officeId` (`officeId`),
  CONSTRAINT `Assistant_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_2` FOREIGN KEY (`credentialsId`) REFERENCES `Credentials` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_3` FOREIGN KEY (`personInfoId`) REFERENCES `PersonInfo` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_4` FOREIGN KEY (`phoneInfoId`) REFERENCES `PhoneInfo` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_5` FOREIGN KEY (`addressInfoId`) REFERENCES `AddressInfo` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_6` FOREIGN KEY (`officeId`) REFERENCES `Office` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Assistant`
--

LOCK TABLES `Assistant` WRITE;
/*!40000 ALTER TABLE `Assistant` DISABLE KEYS */;
INSERT INTO `Assistant` VALUES ('37b3e41b-1cf1-11ef-8f68-d9283cb4d201',6,'99cf21e2-68af-4565-bb5a-178437f43d80','7196af1e-1e87-48b9-84bd-d9db7a7a907e','f6dc0cc8-623e-43dc-8c77-74e9c435b50f','21025360-b5bf-49b6-9fcb-713fdec1d6b7','3c55d1a1-bd27-463a-be3b-766e5354009e','READ_ONLY','READ_ONLY','NOTHING','',NULL,'2024-05-28 14:54:07.240','2024-05-28 12:54:07.240','2024-05-28 14:54:07.240'),('5dccc071-1dcd-11ef-8e10-d517f279883e',15,'7323ec54-e054-45ae-a7f2-dea3a2f57871','2bb3f96e-e4f0-41fb-8d37-2b18b9378704','c1466cf3-afd0-43ac-99d1-ee9e967db682','e24a5255-8e51-4126-be6a-dc7d67216e8e','287e0ded-97c2-45b8-9ab9-08a0140e339c','READ_ONLY','NOTHING','READ_WRITE','',NULL,'2024-05-29 17:18:56.000','2024-05-29 15:18:57.000','2024-05-29 17:18:57.000');
/*!40000 ALTER TABLE `Assistant` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CircleOrder`
--

DROP TABLE IF EXISTS `CircleOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `CircleOrder` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `actId` varchar(36) NOT NULL,
  `title` varchar(64) DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT 0,
  `createdById` varchar(36) DEFAULT NULL,
  `updatedById` varchar(36) DEFAULT NULL,
  `displayId` mediumint(8) unsigned DEFAULT NULL,
  `json` text NOT NULL,
  `metadata` text NOT NULL,
  `status` enum('NOT_SENT','WAITING_WOW_API','SENDING_WOW_API','SENDING_CIRCLE_API','SENT','CANCELLED','DELIVERY') NOT NULL DEFAULT 'NOT_SENT',
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `actId` (`actId`),
  CONSTRAINT `CircleOrder_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `CircleOrder_ibfk_2` FOREIGN KEY (`actId`) REFERENCES `Act` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CircleOrder`
--

LOCK TABLES `CircleOrder` WRITE;
/*!40000 ALTER TABLE `CircleOrder` DISABLE KEYS */;
/*!40000 ALTER TABLE `CircleOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CircleOrderFile`
--

DROP TABLE IF EXISTS `CircleOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `CircleOrderFile` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('FORM','SCAN') NOT NULL,
  PRIMARY KEY (`orderId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `CircleOrderFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `CircleOrderFile_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `CircleOrder` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `CircleOrderFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CircleOrderFile`
--

LOCK TABLES `CircleOrderFile` WRITE;
/*!40000 ALTER TABLE `CircleOrderFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `CircleOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Config`
--

DROP TABLE IF EXISTS `Config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Config` (
  `id` mediumint(8) unsigned NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `options` text DEFAULT NULL COMMENT 'Software configuration values as json',
  `syncEnabled` tinyint(1) DEFAULT 1,
  `showOpenStlWarning` tinyint(1) DEFAULT 1,
  `emailNotifications` tinyint(1) DEFAULT 1,
  `logout` mediumint(8) DEFAULT 10,
  `language` varchar(2) DEFAULT NULL,
  `customColorLut` text DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  PRIMARY KEY (`id`,`ownerId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Config`
--

LOCK TABLES `Config` WRITE;
/*!40000 ALTER TABLE `Config` DISABLE KEYS */;
INSERT INTO `Config` VALUES (1,1,'',1,1,1,10,'FR',NULL,'2024-04-30 13:44:41.000','2024-04-30 13:44:41.000','2024-04-30 12:26:31.658'),(1,2,'{\"ordersTableColumnsConfig\":{\"filtering\":[true,true,true,true,false,false],\"sorting\":[{\"order\":1,\"role\":\"internalStatusText\"},{\"order\":0,\"role\":\"patientSortName\"},{\"order\":0,\"role\":\"recipientSortName\"},{\"order\":0,\"role\":\"orderDetails\"},{\"order\":0,\"role\":\"fullDisplayId\"},{\"order\":1,\"role\":\"lastModified\"}]},\"showAllPatients\":true}',1,1,1,10,'FR',NULL,'2024-04-30 13:57:19.000','2024-04-30 14:37:26.000','2024-05-02 08:52:26.297'),(1,3,'{\"ordersTableColumnsConfig\":{\"filtering\":[true,true,true,true,true,false],\"sorting\":[{\"order\":1,\"role\":\"internalStatusText\"},{\"order\":0,\"role\":\"patientSortName\"},{\"order\":0,\"role\":\"recipientSortName\"},{\"order\":0,\"role\":\"orderDetails\"},{\"order\":0,\"role\":\"fullDisplayId\"},{\"order\":1,\"role\":\"lastModified\"}]},\"showAllPatients\":true}',1,1,1,10,'FR',NULL,'2024-04-30 14:26:29.000','2024-05-31 11:03:26.805','2024-05-31 09:03:26.803'),(1,4,'',1,1,1,10,'FR',NULL,'2024-05-02 11:30:48.000','2024-05-02 11:33:13.000','2024-05-02 09:30:49.265'),(1,5,'',1,1,1,10,'FR',NULL,'2024-05-03 14:02:50.000','2024-05-17 18:23:07.000','2024-05-03 14:24:52.990'),(1,6,'{\"ordersTableColumnsConfig\":{\"filtering\":[true,true,true,true,true,false],\"sorting\":[{\"order\":0,\"role\":\"patientSortName\"},{\"order\":0,\"role\":\"recipientSortName\"},{\"order\":0,\"role\":\"orderDetails\"},{\"order\":0,\"role\":\"fullDisplayId\"},{\"order\":1,\"role\":\"lastModified\"},{\"order\":1,\"role\":\"internalStatusText\"}]},\"showAllPatients\":true}',1,1,1,10,'FR',NULL,'2024-05-03 15:13:39.000','2024-05-28 15:51:10.000','2024-05-28 12:54:24.693'),(1,13,'{\"showAllPatients\":true}',1,1,1,10,'FR',NULL,'2024-05-28 16:41:52.000','2024-05-29 16:13:20.000','2024-05-28 14:55:40.032'),(1,14,'{\"showAllPatients\":true}',1,1,1,10,'FR',NULL,'2024-05-29 12:22:40.000','2024-05-29 16:13:35.000','2024-05-29 14:56:41.269'),(1,15,'{\"ordersTableColumnsConfig\":{\"filtering\":[true,true,true,true,false,false],\"sorting\":[{\"order\":1,\"role\":\"internalStatusText\"},{\"order\":0,\"role\":\"patientSortName\"},{\"order\":0,\"role\":\"recipientSortName\"},{\"order\":0,\"role\":\"orderDetails\"},{\"order\":0,\"role\":\"fullDisplayId\"},{\"order\":1,\"role\":\"lastModified\"}]},\"showAllPatients\":true}',1,1,1,10,'FR',NULL,'2024-05-29 16:05:14.000','2024-05-29 18:05:50.922','2024-05-29 16:05:50.920');
/*!40000 ALTER TABLE `Config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Contact`
--

DROP TABLE IF EXISTS `Contact`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Contact` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `professionalId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel contact',
  `officeId` varchar(36) DEFAULT NULL,
  `status` enum('INVITATIONSENT','INVITATIONRECEIVED','ACCEPTED','REJECTED') NOT NULL DEFAULT 'INVITATIONSENT',
  `comments` text DEFAULT NULL,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `uniqueContactPro` (`ownerId`,`professionalId`),
  KEY `professionalId` (`professionalId`),
  KEY `officeId` (`officeId`),
  CONSTRAINT `Contact_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `Contact_ibfk_2` FOREIGN KEY (`professionalId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `Contact_ibfk_3` FOREIGN KEY (`officeId`) REFERENCES `Office` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Contact`
--

LOCK TABLES `Contact` WRITE;
/*!40000 ALTER TABLE `Contact` DISABLE KEYS */;
INSERT INTO `Contact` VALUES ('0766ca08-5ada-47b8-baa2-a27549c326da',14,15,NULL,'ACCEPTED','',NULL,'2024-05-29 16:39:54.791','2024-05-29 14:39:54.792','2024-05-29 16:39:54.794'),('0896a903-c587-49ee-a0cf-0c978f2587b2',3,2,NULL,'ACCEPTED','',NULL,'2024-04-30 14:37:26.000','2024-04-30 12:37:26.000','2024-04-30 14:37:26.000'),('17b5bbba-11a7-4b60-81f6-6b6bc9b96838',3,5,NULL,'ACCEPTED','',NULL,'2024-05-17 18:26:24.000','2024-05-17 16:26:24.000','2024-05-17 18:26:24.000'),('1ae8fb0f-2111-4ecf-a290-dcae6e15100e',3,6,NULL,'ACCEPTED','',NULL,'2024-05-03 15:22:06.000','2024-05-28 12:51:11.000','2024-05-28 14:51:11.000'),('25965baf-72ae-4b9a-a037-cdcb57bcb1ac',3,14,NULL,'ACCEPTED','',NULL,'2024-05-29 16:57:57.000','2024-05-29 14:57:57.000','2024-05-29 16:57:57.000'),('5efec4e9-13c5-4f9b-899b-8f000cbe2133',6,1,NULL,'ACCEPTED','',NULL,'2024-05-03 15:13:39.000','2024-05-03 13:13:39.000','2024-05-03 15:13:39.000'),('64f1bdfa-4d4f-4839-a41f-6114e232cb1f',6,5,NULL,'ACCEPTED','',NULL,'2024-05-03 16:28:03.000','2024-05-03 14:28:03.000','2024-05-03 16:28:03.000'),('6c752185-ecab-4039-a782-171f75036a34',15,14,NULL,'ACCEPTED','',NULL,'2024-05-29 16:39:54.000','2024-05-29 14:39:54.000','2024-05-29 16:39:54.000'),('6fab8f26-eed3-4955-b9cd-c7c7a4991dab',3,13,NULL,'ACCEPTED','',NULL,'2024-05-29 16:19:51.104','2024-05-29 14:19:51.105','2024-05-29 16:19:51.115'),('78919a47-1bcf-424a-a1b2-c19063ff242c',6,3,NULL,'ACCEPTED','',NULL,'2024-05-03 15:22:06.000','2024-05-03 13:22:06.000','2024-05-03 15:22:06.000'),('8e4a4b16-c567-4bf8-a434-976b627a70ca',3,1,NULL,'ACCEPTED','',NULL,'2024-04-30 14:26:29.000','2024-04-30 12:26:29.000','2024-04-30 14:26:29.000'),('b0bde9dc-5ee2-4fb4-9f7d-b8854feaee30',3,3,NULL,'ACCEPTED','',NULL,'2024-04-30 14:26:29.000','2024-04-30 12:26:29.000','2024-04-30 14:26:29.000'),('b84baf20-3ca6-4653-8341-ac721a404258',3,4,NULL,'ACCEPTED','',NULL,'2024-05-02 11:33:13.000','2024-05-02 09:33:13.000','2024-05-02 11:33:13.000'),('bd4f86c2-f666-4580-b5f4-4f72b58cbe61',15,3,NULL,'ACCEPTED','',NULL,'2024-05-29 16:19:40.000','2024-05-29 14:19:40.000','2024-05-29 16:19:40.000'),('cc9e29c9-e462-4946-ae93-e885aeecbffa',15,1,NULL,'ACCEPTED','',NULL,'2024-05-29 16:05:15.000','2024-05-29 14:05:15.000','2024-05-29 16:05:15.000'),('d448970a-9a5d-4c17-bce2-b875f1a6784e',15,15,NULL,'ACCEPTED','',NULL,'2024-05-29 16:05:14.000','2024-05-29 14:05:14.000','2024-05-29 16:05:14.000'),('d979de11-85a6-4e74-949d-f6dd46724ed2',14,14,NULL,'ACCEPTED','',NULL,'2024-05-29 12:22:40.000','2024-05-29 10:22:40.000','2024-05-29 12:22:40.000'),('daddb2b8-d52c-4180-b1e0-8f90832457fd',6,6,NULL,'ACCEPTED','',NULL,'2024-05-03 15:13:39.000','2024-05-28 12:51:11.000','2024-05-28 14:51:11.000'),('e248d5a9-259a-4099-8608-118ba5c8da3a',14,3,NULL,'ACCEPTED','',NULL,'2024-05-29 16:57:55.000','2024-05-29 14:57:55.000','2024-05-29 16:57:55.000'),('ed09bdd8-1331-4c59-b52b-b0000e585e7d',15,13,NULL,'ACCEPTED','',NULL,'2024-05-29 16:21:56.000','2024-05-29 14:21:56.000','2024-05-29 16:21:56.000'),('f1ccd396-1522-4c83-a973-28ee16bfe86e',14,1,NULL,'ACCEPTED','',NULL,'2024-05-29 12:22:41.000','2024-05-29 10:22:41.000','2024-05-29 12:22:41.000'),('ff020976-3860-42e7-8763-7a9e69599492',3,15,NULL,'ACCEPTED','',NULL,'2024-05-29 16:19:40.000','2024-05-29 14:19:40.000','2024-05-29 16:19:40.000');
/*!40000 ALTER TABLE `Contact` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ContactNotification`
--

DROP TABLE IF EXISTS `ContactNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ContactNotification` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `contactId` varchar(36) DEFAULT NULL,
  `rescueDisplayName` varchar(50) DEFAULT NULL,
  `event` enum('RECEIVED','RECEIVED_TO_ACCEPTED','RECEIVED_TO_REJECTED','SENT_TO_ACCEPTED','SENT_TO_REJECTED','ACTIVATION_TIMEOUT') NOT NULL DEFAULT 'RECEIVED',
  `unread` tinyint(1) NOT NULL DEFAULT 1,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `contactId` (`contactId`),
  CONSTRAINT `ContactNotification_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `ContactNotification_ibfk_2` FOREIGN KEY (`contactId`) REFERENCES `Contact` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ContactNotification`
--

LOCK TABLES `ContactNotification` WRITE;
/*!40000 ALTER TABLE `ContactNotification` DISABLE KEYS */;
INSERT INTO `ContactNotification` VALUES ('08062979-e305-45b9-bae4-9f7e5197b2a9',15,'ed09bdd8-1331-4c59-b52b-b0000e585e7d','demo20 demo','SENT_TO_ACCEPTED',0,'2024-05-29 16:21:56.000',NULL,'2024-05-29 14:51:08.000','2024-05-29 16:51:08.000'),('1bf24ba1-59fc-4b43-8236-880dd8926cec',3,'17b5bbba-11a7-4b60-81f6-6b6bc9b96838','succursalle Salles d\'Aude Laboratoire scan4all','SENT_TO_ACCEPTED',0,'2024-05-17 18:26:24.000',NULL,'2024-05-21 08:09:53.274','2024-05-21 10:09:53.284'),('32de96a9-ff05-45b6-909a-274f33ceaf89',3,'1ae8fb0f-2111-4ecf-a290-dcae6e15100e','utilisateur3 S4A','RECEIVED_TO_ACCEPTED',0,'2024-05-03 15:21:18.000',NULL,'2024-05-03 13:22:06.000','2024-05-03 15:22:06.000'),('4f258a68-41ff-4c59-ae17-f491870eb9bb',3,'0896a903-c587-49ee-a0cf-0c978f2587b2','Félix LEDEE CAUCHI','SENT_TO_ACCEPTED',0,'2024-04-30 14:37:26.000',NULL,'2024-05-02 09:12:55.206','2024-05-02 11:12:55.208'),('57c81404-1fe0-4d92-b6cf-b1452e439b17',15,'6c752185-ecab-4039-a782-171f75036a34','demo21 demo','SENT_TO_ACCEPTED',0,'2024-05-29 16:39:54.000',NULL,'2024-05-29 14:51:07.000','2024-05-29 16:51:07.000'),('79a57263-507d-47f7-a3a4-22d7f574dc12',3,'b84baf20-3ca6-4653-8341-ac721a404258','client leger','SENT_TO_ACCEPTED',0,'2024-05-02 11:33:13.000',NULL,'2024-05-02 09:34:36.657','2024-05-02 11:34:36.659'),('9a28c13d-c9b9-4997-bdf2-074bc5e0249e',3,'6fab8f26-eed3-4955-b9cd-c7c7a4991dab','demo20 demo','RECEIVED_TO_ACCEPTED',0,'2024-05-28 16:55:38.000',NULL,'2024-05-29 14:19:51.116','2024-05-29 16:19:51.117'),('aeabd440-8beb-49d3-bbcf-096e1ff4694a',14,'e248d5a9-259a-4099-8608-118ba5c8da3a','sabine Caserta','SENT_TO_ACCEPTED',0,'2024-05-29 16:57:55.000',NULL,'2024-05-29 14:58:50.081','2024-05-29 16:58:50.091'),('c87ec076-f297-431e-af64-cdce1ffadcde',3,'25965baf-72ae-4b9a-a037-cdcb57bcb1ac','demo21 demo','RECEIVED_TO_ACCEPTED',0,'2024-05-29 16:57:44.000',NULL,'2024-05-31 09:02:49.404','2024-05-31 11:02:49.414'),('d3c24fee-61f7-4d43-8a5a-3c7a6291547b',6,'78919a47-1bcf-424a-a1b2-c19063ff242c','sabine Caserta','SENT_TO_ACCEPTED',0,'2024-05-03 15:22:06.000',NULL,'2024-05-03 13:22:16.830','2024-05-03 15:22:16.840'),('d663452d-d0bd-4a7e-96bc-65a008b0152c',6,'64f1bdfa-4d4f-4839-a41f-6114e232cb1f','succursalle Salles d\'Aude Laboratoire scan4all','SENT_TO_ACCEPTED',0,'2024-05-03 16:28:03.000',NULL,'2024-05-28 12:42:00.892','2024-05-28 14:42:00.901'),('d6a50e16-0b10-4cbe-a785-645461116e7f',14,'0766ca08-5ada-47b8-baa2-a27549c326da','demo22 demo','RECEIVED_TO_ACCEPTED',0,'2024-05-29 16:13:35.000',NULL,'2024-05-29 14:39:54.795','2024-05-29 16:39:54.796'),('ed968b0a-f083-4ffd-b1fb-b8b3dbac5c07',15,'bd4f86c2-f666-4580-b5f4-4f72b58cbe61','sabine Caserta','SENT_TO_ACCEPTED',0,'2024-05-29 16:19:40.000',NULL,'2024-05-29 14:51:08.000','2024-05-29 16:51:08.000'),('f35a3de7-3fe6-448b-9186-74578d52c788',3,'ff020976-3860-42e7-8763-7a9e69599492','demo22 demo','RECEIVED_TO_ACCEPTED',0,'2024-05-29 16:14:03.000',NULL,'2024-05-29 14:19:40.000','2024-05-29 16:19:40.000');
/*!40000 ALTER TABLE `ContactNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Credentials`
--

DROP TABLE IF EXISTS `Credentials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Credentials` (
  `uuid` varchar(36) NOT NULL,
  `login` varchar(255) NOT NULL,
  `password` varchar(100) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `login` (`login`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Credentials`
--

LOCK TABLES `Credentials` WRITE;
/*!40000 ALTER TABLE `Credentials` DISABLE KEYS */;
INSERT INTO `Credentials` VALUES ('2e995095-88b2-11ec-89bc-2e174fce41cd','biotech',NULL,'2024-04-30 12:26:31.643','2024-04-30 13:44:41.000'),('466cbc9a-1ff6-4044-8fba-678393bc0252','demo21','31da9e363a4b4e3ec680782ae94ef4a4d47dfdce546d046bc7d5884554fb9bef','2024-05-29 10:22:45.068','2024-05-29 16:13:35.000'),('494c56b7-3289-46d8-838b-2e68cd18ca5b','demo',NULL,'2024-04-30 12:34:01.218','2024-04-30 14:37:26.000'),('655eb1b9-6ae7-4293-9737-358c951fbf71','demo20',NULL,'2024-05-28 14:55:40.020','2024-05-29 16:13:20.000'),('7323ec54-e054-45ae-a7f2-dea3a2f57871','assistant1demo22env2@hjgjh.net','8978d633cf50ea33f0c0cae65e5f2701914cf57523473b4d4cfe1dcf45c4d1ec','2024-05-29 15:26:33.861','2024-05-29 17:18:57.000'),('7adcf581-a6db-4672-bc51-9c6d471fa663','iris','b0e3df5eccd7d2844837d97c6baad27a09945a8bdcc3c2afd2a4f73578446111','2024-04-30 12:26:30.918','2024-05-29 16:57:45.000'),('99cf21e2-68af-4565-bb5a-178437f43d80','gamajesa@hotmail.fr','b0e3df5eccd7d2844837d97c6baad27a09945a8bdcc3c2afd2a4f73578446111','2024-05-28 12:54:07.239','2024-05-28 14:54:07.240'),('afdaf315-9060-4a46-b958-9a7c00ce122c','demo3pc2','fab186f924c70d623b912a9d582a6694a0a74aed333d430f4678bc52ae42b8ab','2024-05-28 13:52:34.830','2024-05-28 15:51:10.000'),('bd241e23-6d6c-4ee5-82d6-187dfde89f13','demo22','8978d633cf50ea33f0c0cae65e5f2701914cf57523473b4d4cfe1dcf45c4d1ec','2024-05-29 15:04:10.520','2024-05-29 16:37:29.000'),('f2d078ea-bb55-4650-a755-6b8c3cc8f5bc','dem',NULL,'2024-05-02 09:32:34.140','2024-05-02 11:33:13.000'),('f66ac278-aafe-4a05-b86f-e686f664bda7','utilisateur2',NULL,'2024-05-03 14:24:52.977','2024-05-17 18:23:07.000');
/*!40000 ALTER TABLE `Credentials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Discussion`
--

DROP TABLE IF EXISTS `Discussion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Discussion` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `selfImplied` tinyint(1) NOT NULL DEFAULT 0,
  `officeId` varchar(36) DEFAULT NULL,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`,`ownerId`),
  KEY `ownerId` (`ownerId`),
  KEY `officeId` (`officeId`),
  CONSTRAINT `Discussion_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `Discussion_ibfk_2` FOREIGN KEY (`officeId`) REFERENCES `Office` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Discussion`
--

LOCK TABLES `Discussion` WRITE;
/*!40000 ALTER TABLE `Discussion` DISABLE KEYS */;
INSERT INTO `Discussion` VALUES ('1fed07ce-0867-11ef-8ff6-da2f5a35fe58',3,0,NULL,NULL,'2024-05-02 11:34:08.206','2024-05-17 16:20:25.000','2024-05-17 18:20:25.000'),('1fed07ce-0867-11ef-8ff6-da2f5a35fe58',4,0,NULL,NULL,'2024-05-02 11:34:08.206','2024-05-02 09:34:08.206',NULL),('3b2891c3-0950-11ef-8f65-d9283bb1c6cd',3,0,NULL,NULL,'2024-05-03 15:22:47.277','2024-05-28 13:10:43.000','2024-05-28 15:10:43.000'),('3b2891c3-0950-11ef-8f65-d9283bb1c6cd',6,0,NULL,NULL,'2024-05-03 15:22:47.275','2024-05-28 13:10:43.000','2024-05-28 15:10:43.000'),('497ff0d0-1dd2-11ef-8f99-d92a46e09137',13,0,NULL,NULL,'2024-05-29 17:44:08.523','2024-05-29 15:44:08.523',NULL),('497ff0d0-1dd2-11ef-8f99-d92a46e09137',15,0,NULL,NULL,'2024-05-29 17:44:08.523','2024-05-29 15:58:41.000','2024-05-29 17:58:41.000'),('6f667799-1dc9-11ef-8e10-d517f279883e',14,0,NULL,NULL,'2024-05-29 16:42:20.091','2024-05-29 15:02:45.000','2024-05-29 17:02:45.000'),('6f667799-1dc9-11ef-8e10-d517f279883e',15,0,NULL,NULL,'2024-05-29 16:42:20.100','2024-05-29 15:54:03.000','2024-05-29 17:54:03.000'),('97b97f39-06ed-11ef-90c8-dd3986f53a42',1,0,NULL,NULL,'2024-04-30 14:31:39.431','2024-04-30 12:31:39.431',NULL),('97b97f39-06ed-11ef-90c8-dd3986f53a42',3,0,NULL,NULL,'2024-04-30 14:31:39.431','2024-05-13 07:53:12.000','2024-05-13 09:53:12.000'),('ef5b9a32-1dcb-11ef-8f99-d92a46e09137',3,0,NULL,NULL,'2024-05-29 16:58:40.310','2024-05-29 14:58:40.310',NULL),('ef5b9a32-1dcb-11ef-8f99-d92a46e09137',14,0,NULL,NULL,'2024-05-29 16:58:40.310','2024-05-29 14:58:40.310','2024-05-29 16:58:40.322');
/*!40000 ALTER TABLE `Discussion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `File`
--

DROP TABLE IF EXISTS `File`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `File` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `path` text DEFAULT NULL,
  `tag` text DEFAULT NULL,
  `originalName` text NOT NULL,
  `originalId` varchar(36) NOT NULL,
  `metadata` text DEFAULT NULL,
  `type` enum('BIN','JSON','PDF','PLY','STL','PNG','XYZ','ZIP') NOT NULL,
  `version` mediumint(8) unsigned DEFAULT 0,
  `status` enum('CREATED','UPDATED','SYNCED','ERROR') DEFAULT 'CREATED',
  `anonymous` tinyint(1) NOT NULL DEFAULT 0,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `version` (`originalId`,`version`),
  CONSTRAINT `File_ibfk_1` FOREIGN KEY (`originalId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `File`
--

LOCK TABLES `File` WRITE;
/*!40000 ALTER TABLE `File` DISABLE KEYS */;
INSERT INTO `File` VALUES ('000494bd-1dc5-11ef-8e10-d517f279883e',15,'/var/iris/.data/2024/15/8eb8d841-1dc4-11ef-8e10-d517f279883e/session_97a4fb29-1dc4-11ef-8e10-d517f279883e/occlusion_97a7648b-1dc4-11ef-8e10-d517f279883e/scan_e603f241-1dc4-11ef-8e10-d517f279883e/000494bd-1dc5-11ef-8e10-d517f279883e.zip','PATIENT_8eb8d841-1dc4-11ef-8e10-d517f279883e_ACT_97a4fb29-1dc4-11ef-8e10-d517f279883e_SESS_97a7648b-1dc4-11ef-8e10-d517f279883e_BOSC_e603f241-1dc4-11ef-8e10-d517f279883e_MODEL','000494bd-1dc5-11ef-8e10-d517f279883e.zip','000494bd-1dc5-11ef-8e10-d517f279883e','{\"displayTitle\":\"Mandibule 1.1.1.1.1\",\"modelMatrix\":\"0.989354,-0.138659,-0.0441867,0,0.138295,0.990328,-0.0112196,0,0.045315,0.00498938,0.99896,0,-17.3085,-2.30894,-16.4005,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-29 16:09:09.000','2024-05-29 15:05:50.000','2024-05-29 17:05:50.000'),('0004a3c1-1dc5-11ef-8e10-d517f279883e',15,'/var/iris/.data/2024/15/8eb8d841-1dc4-11ef-8e10-d517f279883e/session_97a4fb29-1dc4-11ef-8e10-d517f279883e/occlusion_97a7648b-1dc4-11ef-8e10-d517f279883e/scan_e603f241-1dc4-11ef-8e10-d517f279883e/0004a3c1-1dc5-11ef-8e10-d517f279883e.png','PATIENT_8eb8d841-1dc4-11ef-8e10-d517f279883e_ACT_97a4fb29-1dc4-11ef-8e10-d517f279883e_SESS_97a7648b-1dc4-11ef-8e10-d517f279883e_BOSC_e603f241-1dc4-11ef-8e10-d517f279883e_SNAPS','0004a3c1-1dc5-11ef-8e10-d517f279883e.png','0004a3c1-1dc5-11ef-8e10-d517f279883e','{\"displayTitle\":\"Mandibule 1.1.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-29 16:09:10.000','2024-05-29 15:05:51.000','2024-05-29 17:05:51.000'),('003281d2-1843-11ef-8f8e-d92a44d6667d',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_f0721624-144c-11ef-8f1b-d8242b6da0dc/occlusion_f073b964-144c-11ef-8f1b-d8242b6da0dc/scan_a404f782-1466-11ef-8f1b-d8242b6da0dc/003281d2-1843-11ef-8f8e-d92a44d6667d.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_f0721624-144c-11ef-8f1b-d8242b6da0dc_SESS_f073b964-144c-11ef-8f1b-d8242b6da0dc_TOSC_a404f782-1466-11ef-8f1b-d8242b6da0dc_SCREENS','003281d2-1843-11ef-8f8e-d92a44d6667d.png','003281d2-1843-11ef-8f8e-d92a44d6667d','{\"displayTitle\":\"Maxillaire 1.7.1.1.1 Capture d\'écran 3\",\"title\":\"3\"}','PNG',0,'SYNCED',0,'2024-05-22 15:56:18.387','2024-05-22 15:56:18.387','2024-05-22 13:56:18.388','2024-05-22 15:56:18.397'),('01671c38-0952-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_01654717-0952-11ef-8f65-d9283bb1c6cd/occlusion_0166be38-0952-11ef-8f65-d9283bb1c6cd/scan_01670d72-0952-11ef-8f65-d9283bb1c6cd/01671c38-0952-11ef-8f65-d9283bb1c6cd.zip','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_01654717-0952-11ef-8f65-d9283bb1c6cd_SESS_0166be38-0952-11ef-8f65-d9283bb1c6cd_TOSC_01670d72-0952-11ef-8f65-d9283bb1c6cd_MODEL','01671c38-0952-11ef-8f65-d9283bb1c6cd.zip','01671c38-0952-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Maxillaire 1.2.4.1.1\",\"modelMatrix\":\"0.911721,-0.408329,0.045069,0,0.404868,0.911703,0.0698595,0,-0.0696153,-0.0454454,0.996538,0,-5.05468,2.73266,-18.4649,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-03 15:35:29.370','2024-05-03 13:35:29.407','2024-05-03 15:35:30.213'),('016c64d3-0952-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_01654717-0952-11ef-8f65-d9283bb1c6cd/occlusion_0166be38-0952-11ef-8f65-d9283bb1c6cd/scan_01670d72-0952-11ef-8f65-d9283bb1c6cd/016c64d3-0952-11ef-8f65-d9283bb1c6cd.png','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_01654717-0952-11ef-8f65-d9283bb1c6cd_SESS_0166be38-0952-11ef-8f65-d9283bb1c6cd_TOSC_01670d72-0952-11ef-8f65-d9283bb1c6cd_SNAPS','016c64d3-0952-11ef-8f65-d9283bb1c6cd.png','016c64d3-0952-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Maxillaire 1.2.4.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-03 15:35:29.405','2024-05-03 13:35:29.407','2024-05-03 15:35:32.305'),('037f4e74-1843-11ef-8f8e-d92a44d6667d',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_f0721624-144c-11ef-8f1b-d8242b6da0dc/occlusion_f073b964-144c-11ef-8f1b-d8242b6da0dc/scan_a404f782-1466-11ef-8f1b-d8242b6da0dc/037f4e74-1843-11ef-8f8e-d92a44d6667d.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_f0721624-144c-11ef-8f1b-d8242b6da0dc_SESS_f073b964-144c-11ef-8f1b-d8242b6da0dc_TOSC_a404f782-1466-11ef-8f1b-d8242b6da0dc_SCREENS','037f4e74-1843-11ef-8f8e-d92a44d6667d.png','037f4e74-1843-11ef-8f8e-d92a44d6667d','{\"displayTitle\":\"Maxillaire 1.7.1.1.1 Capture d\'écran 4\",\"title\":\"4\"}','PNG',0,'SYNCED',0,'2024-05-22 15:56:20.560','2024-05-22 15:56:20.560','2024-05-22 13:56:20.560','2024-05-22 15:56:20.570'),('03a4f7ef-1834-11ef-8f8e-d92a44d6667d',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_f0721624-144c-11ef-8f1b-d8242b6da0dc/occlusion_f073b964-144c-11ef-8f1b-d8242b6da0dc/scan_a404f782-1466-11ef-8f1b-d8242b6da0dc/03a4f7ef-1834-11ef-8f8e-d92a44d6667d.json','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_f0721624-144c-11ef-8f1b-d8242b6da0dc_SESS_f073b964-144c-11ef-8f1b-d8242b6da0dc_TOSC_a404f782-1466-11ef-8f1b-d8242b6da0dc_METER','03a4f7ef-1834-11ef-8f8e-d92a44d6667d.json','03a4f7ef-1834-11ef-8f8e-d92a44d6667d','{\"displayTitle\":\"Maxillaire 1.7.1.1.1 Mesure\"}','JSON',0,'SYNCED',0,NULL,'2024-05-22 14:08:35.035','2024-05-22 12:08:35.048','2024-05-22 14:08:35.129'),('0436cb1e-1844-11ef-8f8e-d92a44d6667d',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_f5aa8d87-1824-11ef-8f8e-d92a44d6667d/occlusion_f5ac369c-1824-11ef-8f8e-d92a44d6667d/scan_e9b9b436-1843-11ef-8f8e-d92a44d6667d/0436cb1e-1844-11ef-8f8e-d92a44d6667d.zip','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_f5aa8d87-1824-11ef-8f8e-d92a44d6667d_SESS_f5ac369c-1824-11ef-8f8e-d92a44d6667d_TOSC_e9b9b436-1843-11ef-8f8e-d92a44d6667d_MODEL','0436cb1e-1844-11ef-8f8e-d92a44d6667d.zip','0436cb1e-1844-11ef-8f8e-d92a44d6667d','{\"displayTitle\":\"Maxillaire 1.7.7.1.2\",\"modelMatrix\":\"-0.971033,0.238334,-0.0170698,0,-0.237982,-0.971056,-0.0203527,0,-0.0214264,-0.0157009,0.999647,0,1.04163,-1.04309,-19.124,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-22 16:03:07.931','2024-05-22 14:03:43.746','2024-05-22 16:03:43.758'),('0436e535-1844-11ef-8f8e-d92a44d6667d',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_f5aa8d87-1824-11ef-8f8e-d92a44d6667d/occlusion_f5ac369c-1824-11ef-8f8e-d92a44d6667d/scan_e9b9b436-1843-11ef-8f8e-d92a44d6667d/0436e535-1844-11ef-8f8e-d92a44d6667d.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_f5aa8d87-1824-11ef-8f8e-d92a44d6667d_SESS_f5ac369c-1824-11ef-8f8e-d92a44d6667d_TOSC_e9b9b436-1843-11ef-8f8e-d92a44d6667d_SNAPS','0436e535-1844-11ef-8f8e-d92a44d6667d.png','0436e535-1844-11ef-8f8e-d92a44d6667d','{\"displayTitle\":\"Maxillaire 1.7.7.1.2 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-22 16:03:07.932','2024-05-22 14:03:43.746','2024-05-22 16:03:43.758'),('069f9819-1843-11ef-8f8e-d92a44d6667d',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_f0721624-144c-11ef-8f1b-d8242b6da0dc/occlusion_f073b964-144c-11ef-8f1b-d8242b6da0dc/scan_a404f782-1466-11ef-8f1b-d8242b6da0dc/069f9819-1843-11ef-8f8e-d92a44d6667d.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_f0721624-144c-11ef-8f1b-d8242b6da0dc_SESS_f073b964-144c-11ef-8f1b-d8242b6da0dc_TOSC_a404f782-1466-11ef-8f1b-d8242b6da0dc_SCREENS','069f9819-1843-11ef-8f8e-d92a44d6667d.png','069f9819-1843-11ef-8f8e-d92a44d6667d','{\"displayTitle\":\"Maxillaire 1.7.1.1.1 Capture d\'écran 5\",\"title\":\"5\"}','PNG',0,'SYNCED',0,'2024-05-22 15:56:22.962','2024-05-22 15:56:22.962','2024-05-22 13:56:22.962','2024-05-22 15:56:22.971'),('06de7932-0869-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_9fff6be0-0868-11ef-8ff6-da2f5a35fe58/occlusion_a000fd43-0868-11ef-8ff6-da2f5a35fe58/scan_eacd5e79-0868-11ef-8ff6-da2f5a35fe58/06de7932-0869-11ef-8ff6-da2f5a35fe58.zip','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_9fff6be0-0868-11ef-8ff6-da2f5a35fe58_SESS_a000fd43-0868-11ef-8ff6-da2f5a35fe58_BOSC_eacd5e79-0868-11ef-8ff6-da2f5a35fe58_MODEL','06de7932-0869-11ef-8ff6-da2f5a35fe58.zip','06de7932-0869-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Mandibule 1.1.3.1.1\",\"modelMatrix\":\"-0.97878,-0.174408,0.107571,0,0.176364,-0.984285,0.00886413,0,0.104334,0.0276476,0.994158,0,10.9633,2.36245,-21.2611,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-02 11:47:45.160','2024-05-02 09:47:45.466','2024-05-02 11:47:47.963'),('06de8cba-0869-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_9fff6be0-0868-11ef-8ff6-da2f5a35fe58/occlusion_a000fd43-0868-11ef-8ff6-da2f5a35fe58/scan_eacd5e79-0868-11ef-8ff6-da2f5a35fe58/06de8cba-0869-11ef-8ff6-da2f5a35fe58.png','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_9fff6be0-0868-11ef-8ff6-da2f5a35fe58_SESS_a000fd43-0868-11ef-8ff6-da2f5a35fe58_BOSC_eacd5e79-0868-11ef-8ff6-da2f5a35fe58_SNAPS','06de8cba-0869-11ef-8ff6-da2f5a35fe58.png','06de8cba-0869-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Mandibule 1.1.3.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-02 11:47:45.161','2024-05-02 09:47:45.466','2024-05-02 11:47:48.241'),('07d305e5-1844-11ef-8f8e-d92a44d6667d',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_f5aa8d87-1824-11ef-8f8e-d92a44d6667d/occlusion_f5ac369c-1824-11ef-8f8e-d92a44d6667d/scan_e9b9b436-1843-11ef-8f8e-d92a44d6667d/07d305e5-1844-11ef-8f8e-d92a44d6667d.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_f5aa8d87-1824-11ef-8f8e-d92a44d6667d_SESS_f5ac369c-1824-11ef-8f8e-d92a44d6667d_TOSC_e9b9b436-1843-11ef-8f8e-d92a44d6667d_SCREENS','07d305e5-1844-11ef-8f8e-d92a44d6667d.png','07d305e5-1844-11ef-8f8e-d92a44d6667d','{\"displayTitle\":\"Maxillaire 1.7.7.1.2 Capture d\'écran 1\",\"title\":\"1\"}','PNG',0,'SYNCED',0,'2024-05-22 16:03:32.954','2024-05-22 16:03:32.955','2024-05-22 14:03:32.955','2024-05-22 16:03:32.964'),('09b43640-1844-11ef-8f8e-d92a44d6667d',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_f5aa8d87-1824-11ef-8f8e-d92a44d6667d/occlusion_f5ac369c-1824-11ef-8f8e-d92a44d6667d/scan_e9b9b436-1843-11ef-8f8e-d92a44d6667d/09b43640-1844-11ef-8f8e-d92a44d6667d.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_f5aa8d87-1824-11ef-8f8e-d92a44d6667d_SESS_f5ac369c-1824-11ef-8f8e-d92a44d6667d_TOSC_e9b9b436-1843-11ef-8f8e-d92a44d6667d_SCREENS','09b43640-1844-11ef-8f8e-d92a44d6667d.png','09b43640-1844-11ef-8f8e-d92a44d6667d','{\"displayTitle\":\"Maxillaire 1.7.7.1.2 Capture d\'écran 2\",\"title\":\"2\"}','PNG',0,'SYNCED',0,'2024-05-22 16:03:35.482','2024-05-22 16:03:35.483','2024-05-22 14:03:35.483','2024-05-22 16:03:35.492'),('0af94c65-1844-11ef-8f8e-d92a44d6667d',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_f5aa8d87-1824-11ef-8f8e-d92a44d6667d/occlusion_f5ac369c-1824-11ef-8f8e-d92a44d6667d/scan_e9b9b436-1843-11ef-8f8e-d92a44d6667d/0af94c65-1844-11ef-8f8e-d92a44d6667d.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_f5aa8d87-1824-11ef-8f8e-d92a44d6667d_SESS_f5ac369c-1824-11ef-8f8e-d92a44d6667d_TOSC_e9b9b436-1843-11ef-8f8e-d92a44d6667d_SCREENS','0af94c65-1844-11ef-8f8e-d92a44d6667d.png','0af94c65-1844-11ef-8f8e-d92a44d6667d','{\"displayTitle\":\"Maxillaire 1.7.7.1.2 Capture d\'écran 3\",\"title\":\"3\"}','PNG',0,'SYNCED',0,'2024-05-22 16:03:30.608','2024-05-22 16:03:30.608','2024-05-22 14:03:30.608','2024-05-22 16:03:30.618'),('0be6f95e-11fe-11ef-8f0c-d823285f66e1',3,'/var/iris/.data/2024/3/118618c7-11fa-11ef-8fe1-da2e5522abf3/session_176ffa22-11fa-11ef-8fe1-da2e5522abf3/occlusion_17719f33-11fa-11ef-8fe1-da2e5522abf3/scan_9317e0a1-11fd-11ef-8f0c-d823285f66e1/0be6f95e-11fe-11ef-8f0c-d823285f66e1.zip','PATIENT_118618c7-11fa-11ef-8fe1-da2e5522abf3_ACT_176ffa22-11fa-11ef-8fe1-da2e5522abf3_SESS_17719f33-11fa-11ef-8fe1-da2e5522abf3_TOSC_9317e0a1-11fd-11ef-8f0c-d823285f66e1_MODEL','0be6f95e-11fe-11ef-8f0c-d823285f66e1.zip','0be6f95e-11fe-11ef-8f0c-d823285f66e1','{\"displayTitle\":\"Maxillaire 1.5.1.1.1\",\"modelMatrix\":\"-0.16396,-0.985286,0.0482646,0,0.966624,-0.170233,-0.191465,0,0.196864,0.0152611,0.980312,0,21.9069,16.3354,-13.5215,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-14 16:27:13.000','2024-05-14 14:27:13.000','2024-05-14 16:27:13.000'),('0be7116f-11fe-11ef-8f0c-d823285f66e1',3,'/var/iris/.data/2024/3/118618c7-11fa-11ef-8fe1-da2e5522abf3/session_176ffa22-11fa-11ef-8fe1-da2e5522abf3/occlusion_17719f33-11fa-11ef-8fe1-da2e5522abf3/scan_9317e0a1-11fd-11ef-8f0c-d823285f66e1/0be7116f-11fe-11ef-8f0c-d823285f66e1.png','PATIENT_118618c7-11fa-11ef-8fe1-da2e5522abf3_ACT_176ffa22-11fa-11ef-8fe1-da2e5522abf3_SESS_17719f33-11fa-11ef-8fe1-da2e5522abf3_TOSC_9317e0a1-11fd-11ef-8f0c-d823285f66e1_SNAPS','0be7116f-11fe-11ef-8f0c-d823285f66e1.png','0be7116f-11fe-11ef-8f0c-d823285f66e1','{\"displayTitle\":\"Maxillaire 1.5.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-14 16:27:13.000','2024-05-14 14:27:13.000','2024-05-14 16:27:13.000'),('0c100533-176d-11ef-8f86-d92942cf49fd',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_b1ce9a22-1749-11ef-8f86-d92942cf49fd/occlusion_b1d043a8-1749-11ef-8f86-d92942cf49fd/scan_e68d77dd-176c-11ef-8f86-d92942cf49fd/0c100533-176d-11ef-8f86-d92942cf49fd.zip','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_b1ce9a22-1749-11ef-8f86-d92942cf49fd_SESS_b1d043a8-1749-11ef-8f86-d92942cf49fd_RISC_e68d77dd-176c-11ef-8f86-d92942cf49fd_MODEL','0c100533-176d-11ef-8f86-d92942cf49fd.zip','0c100533-176d-11ef-8f86-d92942cf49fd','{\"displayTitle\":\"Mordu droit 1.7.6.1.1\",\"modelMatrix\":\"0.996621,-0.0829383,-0.0103322,0,0.0817389,0.996426,0.0128457,0,0.00831359,-0.0162849,0.999868,0,10.4737,0.273425,-17.5373,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-21 14:24:19.302','2024-05-21 12:24:19.617','2024-05-21 14:24:21.504'),('0c1018e1-176d-11ef-8f86-d92942cf49fd',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_b1ce9a22-1749-11ef-8f86-d92942cf49fd/occlusion_b1d043a8-1749-11ef-8f86-d92942cf49fd/scan_e68d77dd-176c-11ef-8f86-d92942cf49fd/0c1018e1-176d-11ef-8f86-d92942cf49fd.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_b1ce9a22-1749-11ef-8f86-d92942cf49fd_SESS_b1d043a8-1749-11ef-8f86-d92942cf49fd_RISC_e68d77dd-176c-11ef-8f86-d92942cf49fd_SNAPS','0c1018e1-176d-11ef-8f86-d92942cf49fd.png','0c1018e1-176d-11ef-8f86-d92942cf49fd','{\"displayTitle\":\"Mordu droit 1.7.6.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-21 14:24:19.303','2024-05-21 12:24:19.617','2024-05-21 14:24:22.657'),('0c4b4c9c-1844-11ef-8f8e-d92a44d6667d',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_f5aa8d87-1824-11ef-8f8e-d92a44d6667d/occlusion_f5ac369c-1824-11ef-8f8e-d92a44d6667d/scan_e9b9b436-1843-11ef-8f8e-d92a44d6667d/0c4b4c9c-1844-11ef-8f8e-d92a44d6667d.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_f5aa8d87-1824-11ef-8f8e-d92a44d6667d_SESS_f5ac369c-1824-11ef-8f8e-d92a44d6667d_TOSC_e9b9b436-1843-11ef-8f8e-d92a44d6667d_SCREENS','0c4b4c9c-1844-11ef-8f8e-d92a44d6667d.png','0c4b4c9c-1844-11ef-8f8e-d92a44d6667d','{\"displayTitle\":\"Maxillaire 1.7.7.1.2 Capture d\'écran 4\",\"title\":\"4\"}','PNG',0,'SYNCED',0,'2024-05-22 16:03:37.793','2024-05-22 16:03:37.794','2024-05-22 14:03:37.794','2024-05-22 16:03:37.803'),('0ceccb78-1dd2-11ef-8f99-d92a46e09137',15,'/var/iris/.data/2024/15/de66fe79-1dd1-11ef-8f99-d92a46e09137/session_ec1c9685-1dd1-11ef-8f99-d92a46e09137/occlusion_ec1e3d64-1dd1-11ef-8f99-d92a46e09137/scan_ee955675-1dd1-11ef-8f99-d92a46e09137/0ceccb78-1dd2-11ef-8f99-d92a46e09137.zip','PATIENT_de66fe79-1dd1-11ef-8f99-d92a46e09137_ACT_ec1c9685-1dd1-11ef-8f99-d92a46e09137_SESS_ec1e3d64-1dd1-11ef-8f99-d92a46e09137_TOSC_ee955675-1dd1-11ef-8f99-d92a46e09137_MODEL','0ceccb78-1dd2-11ef-8f99-d92a46e09137.zip','0ceccb78-1dd2-11ef-8f99-d92a46e09137','{\"displayTitle\":\"Maxillaire 2.3.1.1.1\",\"modelMatrix\":\"0.98765,-0.130591,0.0865637,0,0.15333,0.919201,-0.36271,0,-0.0322029,0.371504,0.927873,0,-13.0143,-3.34129,-13.2544,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-29 17:42:29.000','2024-05-29 15:42:29.000','2024-05-29 17:42:29.000'),('0cece571-1dd2-11ef-8f99-d92a46e09137',15,'/var/iris/.data/2024/15/de66fe79-1dd1-11ef-8f99-d92a46e09137/session_ec1c9685-1dd1-11ef-8f99-d92a46e09137/occlusion_ec1e3d64-1dd1-11ef-8f99-d92a46e09137/scan_ee955675-1dd1-11ef-8f99-d92a46e09137/0cece571-1dd2-11ef-8f99-d92a46e09137.png','PATIENT_de66fe79-1dd1-11ef-8f99-d92a46e09137_ACT_ec1c9685-1dd1-11ef-8f99-d92a46e09137_SESS_ec1e3d64-1dd1-11ef-8f99-d92a46e09137_TOSC_ee955675-1dd1-11ef-8f99-d92a46e09137_SNAPS','0cece571-1dd2-11ef-8f99-d92a46e09137.png','0cece571-1dd2-11ef-8f99-d92a46e09137','{\"displayTitle\":\"Maxillaire 2.3.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-29 17:42:29.000','2024-05-29 15:42:29.000','2024-05-29 17:42:29.000'),('0dc15345-1844-11ef-8f8e-d92a44d6667d',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_f5aa8d87-1824-11ef-8f8e-d92a44d6667d/occlusion_f5ac369c-1824-11ef-8f8e-d92a44d6667d/scan_e9b9b436-1843-11ef-8f8e-d92a44d6667d/0dc15345-1844-11ef-8f8e-d92a44d6667d.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_f5aa8d87-1824-11ef-8f8e-d92a44d6667d_SESS_f5ac369c-1824-11ef-8f8e-d92a44d6667d_TOSC_e9b9b436-1843-11ef-8f8e-d92a44d6667d_SCREENS','0dc15345-1844-11ef-8f8e-d92a44d6667d.png','0dc15345-1844-11ef-8f8e-d92a44d6667d','{\"displayTitle\":\"Maxillaire 1.7.7.1.2 Capture d\'écran 5\",\"title\":\"5\"}','PNG',0,'SYNCED',0,'2024-05-22 16:03:39.842','2024-05-22 16:03:39.842','2024-05-22 14:03:39.843','2024-05-22 16:03:39.852'),('0e958929-1dca-11ef-8f99-d92a46e09137',14,'/var/iris/.data/2024/14/c6dd7b08-1dc9-11ef-8f99-d92a46e09137/session_c6ecdf7f-1dc9-11ef-8f99-d92a46e09137/occlusion_c6ed23a8-1dc9-11ef-8f99-d92a46e09137/scan_e877efd5-1dc9-11ef-8f99-d92a46e09137/0e958929-1dca-11ef-8f99-d92a46e09137.xyz','PATIENT_c6dd7b08-1dc9-11ef-8f99-d92a46e09137_ACT_c6ecdf7f-1dc9-11ef-8f99-d92a46e09137_SESS_c6ed23a8-1dc9-11ef-8f99-d92a46e09137_TOSC_e877efd5-1dc9-11ef-8f99-d92a46e09137_LIFI','0e958929-1dca-11ef-8f99-d92a46e09137.xyz','0e958929-1dca-11ef-8f99-d92a46e09137','{\"displayTitle\":\"Maxillaire 1.1.1.1.2 Ligne de finition créé par demo21\",\"title\":\"créé par demo21\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-05-29 16:45:13.705','2024-05-29 14:45:30.416','2024-05-29 16:45:30.426'),('0e958d91-1dca-11ef-8f99-d92a46e09137',14,'/var/iris/.data/2024/14/c6dd7b08-1dc9-11ef-8f99-d92a46e09137/session_c6ecdf7f-1dc9-11ef-8f99-d92a46e09137/occlusion_c6ed23a8-1dc9-11ef-8f99-d92a46e09137/scan_e877efd5-1dc9-11ef-8f99-d92a46e09137/0e958d91-1dca-11ef-8f99-d92a46e09137.bin','PATIENT_c6dd7b08-1dc9-11ef-8f99-d92a46e09137_ACT_c6ecdf7f-1dc9-11ef-8f99-d92a46e09137_SESS_c6ed23a8-1dc9-11ef-8f99-d92a46e09137_TOSC_e877efd5-1dc9-11ef-8f99-d92a46e09137_LIFIM','0e958d91-1dca-11ef-8f99-d92a46e09137.bin','0e958d91-1dca-11ef-8f99-d92a46e09137','{\"displayTitle\":\"Maxillaire 1.1.1.1.2 Ligne de finition métadonnées créé par demo21\",\"title\":\"créé par demo21\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-05-29 16:45:13.705','2024-05-29 14:45:30.416','2024-05-29 16:45:30.426'),('0fe386e8-176d-11ef-8f86-d92942cf49fd',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_b1ce9a22-1749-11ef-8f86-d92942cf49fd/occlusion_b1d043a8-1749-11ef-8f86-d92942cf49fd/computedocclusion_e3bf7a84-176c-11ef-8f86-d92942cf49fd/0fe386e8-176d-11ef-8f86-d92942cf49fd.zip','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_b1ce9a22-1749-11ef-8f86-d92942cf49fd_SESS_b1d043a8-1749-11ef-8f86-d92942cf49fd_OCC_e3bf7a84-176c-11ef-8f86-d92942cf49fd_TOPLY','0fe386e8-176d-11ef-8f86-d92942cf49fd.zip','0fe386e8-176d-11ef-8f86-d92942cf49fd','{\"displayTitle\":\"Occlusion 1.7.6.1.1 Maxillaire\",\"modelMatrix\":\"0.983594,0.148421,-0.102541,0,-0.180193,0.835416,-0.51924,0,0.008598,0.529198,0.848454,0,13.5602,-14.0966,-17.5164,1\",\"occlusionMatrix\":\"0.986384,-0.00840657,0.164254,0,-0.163897,0.0329737,0.985927,0,-0.0137043,-0.999422,0.0311468,0,14.7546,18.4348,-3.91426,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.7.6.1.1\",\"referenceScanId\":\"b2fd8f6c-1749-11ef-8f86-d92942cf49fd\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-21 14:24:25.721','2024-05-21 12:24:25.996','2024-05-21 14:24:26.682'),('0ff91bc5-176d-11ef-8f86-d92942cf49fd',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_b1ce9a22-1749-11ef-8f86-d92942cf49fd/occlusion_b1d043a8-1749-11ef-8f86-d92942cf49fd/computedocclusion_e3bf7a84-176c-11ef-8f86-d92942cf49fd/0ff91bc5-176d-11ef-8f86-d92942cf49fd.zip','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_b1ce9a22-1749-11ef-8f86-d92942cf49fd_SESS_b1d043a8-1749-11ef-8f86-d92942cf49fd_OCC_e3bf7a84-176c-11ef-8f86-d92942cf49fd_BOPLY','0ff91bc5-176d-11ef-8f86-d92942cf49fd.zip','0ff91bc5-176d-11ef-8f86-d92942cf49fd','{\"displayTitle\":\"Occlusion 1.7.6.1.1 Mandibule\",\"modelMatrix\":\"-0.907406,-0.418344,0.0400261,0,0.418868,-0.892567,0.166955,0,-0.0341189,0.168262,0.985152,0,13.6538,6.2861,-17.1221,1\",\"occlusionMatrix\":\"0.999955,-0.00987827,9.94886e-05,0,-7.71814e-05,-0.0178658,-0.999843,0,0.00987848,0.999795,-0.0178683,0,-16.7876,-11.8188,3.38235,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.7.6.1.1\",\"referenceScanId\":\"a4132a7d-174a-11ef-8f86-d92942cf49fd\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-21 14:24:25.863','2024-05-21 12:24:25.997','2024-05-21 14:24:26.842'),('106d53d3-176d-11ef-8f86-d92942cf49fd',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_b1ce9a22-1749-11ef-8f86-d92942cf49fd/occlusion_b1d043a8-1749-11ef-8f86-d92942cf49fd/computedocclusion_e3bf7a84-176c-11ef-8f86-d92942cf49fd/106d53d3-176d-11ef-8f86-d92942cf49fd.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_b1ce9a22-1749-11ef-8f86-d92942cf49fd_SESS_b1d043a8-1749-11ef-8f86-d92942cf49fd_OCC_e3bf7a84-176c-11ef-8f86-d92942cf49fd_SNAPO','106d53d3-176d-11ef-8f86-d92942cf49fd.png','106d53d3-176d-11ef-8f86-d92942cf49fd','{\"displayTitle\":\"Occlusion 1.7.6.1.1 Snapshot\",\"occlusionType\":1}','PNG',0,'SYNCED',0,NULL,'2024-05-21 14:24:26.624','2024-05-21 12:24:26.627','2024-05-21 14:24:26.986'),('10d5e323-0952-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_0a477976-0952-11ef-8f65-d9283bb1c6cd/analyse_0a4b0ffa-0952-11ef-8f65-d9283bb1c6cd/10d5e323-0952-11ef-8f65-d9283bb1c6cd.json','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_0a477976-0952-11ef-8f65-d9283bb1c6cd_ANA_0a4b0ffa-0952-11ef-8f65-d9283bb1c6cd_TRANS','10d5e323-0952-11ef-8f65-d9283bb1c6cd.json','10d5e323-0952-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Mesures 1.2.5.1\"}','JSON',0,'SYNCED',0,NULL,'2024-05-03 15:35:55.262','2024-05-03 13:35:55.263','2024-05-03 15:35:56.000'),('110d8194-0952-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_0a477976-0952-11ef-8f65-d9283bb1c6cd/analyse_0a4b0ffa-0952-11ef-8f65-d9283bb1c6cd/110d8194-0952-11ef-8f65-d9283bb1c6cd.png','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_0a477976-0952-11ef-8f65-d9283bb1c6cd_ANA_0a4b0ffa-0952-11ef-8f65-d9283bb1c6cd_SNAPS','110d8194-0952-11ef-8f65-d9283bb1c6cd.png','110d8194-0952-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Mesures 1.2.5.1\"}','PNG',0,'SYNCED',0,NULL,'2024-05-03 15:35:55.626','2024-05-03 13:35:55.634','2024-05-03 15:35:56.370'),('119efae7-0953-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_4fc2347a-0952-11ef-8f65-d9283bb1c6cd/occlusion_4fc3d0e6-0952-11ef-8f65-d9283bb1c6cd/scan_f4d296fb-0952-11ef-8f65-d9283bb1c6cd/119efae7-0953-11ef-8f65-d9283bb1c6cd.zip','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_4fc2347a-0952-11ef-8f65-d9283bb1c6cd_SESS_4fc3d0e6-0952-11ef-8f65-d9283bb1c6cd_TOSC_f4d296fb-0952-11ef-8f65-d9283bb1c6cd_MODEL','119efae7-0953-11ef-8f65-d9283bb1c6cd.zip','f4d2b8bb-0952-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Maxillaire 1.2.6.1.2\",\"modelMatrix\":\"0.99937,0.035479,0.000538262,0,-0.0293851,0.836029,-0.547897,0,-0.0198888,0.547536,0.836546,0,-6.86057,-10.0802,-15.6068,1\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2024-05-03 15:43:06.076','2024-05-03 13:43:06.424','2024-05-03 15:43:08.333'),('119f0cfd-0953-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_4fc2347a-0952-11ef-8f65-d9283bb1c6cd/occlusion_4fc3d0e6-0952-11ef-8f65-d9283bb1c6cd/scan_f4d296fb-0952-11ef-8f65-d9283bb1c6cd/119f0cfd-0953-11ef-8f65-d9283bb1c6cd.png','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_4fc2347a-0952-11ef-8f65-d9283bb1c6cd_SESS_4fc3d0e6-0952-11ef-8f65-d9283bb1c6cd_TOSC_f4d296fb-0952-11ef-8f65-d9283bb1c6cd_SNAPS','119f0cfd-0953-11ef-8f65-d9283bb1c6cd.png','f4d8deb1-0952-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Maxillaire 1.2.6.1.2 Snapshot\"}','PNG',1,'SYNCED',0,NULL,'2024-05-03 15:43:06.077','2024-05-03 13:43:06.425','2024-05-03 15:43:10.622'),('131bceae-1437-11ef-8f1b-d8242b6da0dc',3,'/var/iris/.data/2024/3/16032a0e-1436-11ef-8f1b-d8242b6da0dc/session_d9e0b5cb-1436-11ef-8f1b-d8242b6da0dc/order_d9e2b705-1436-11ef-8f1b-d8242b6da0dc/131bceae-1437-11ef-8f1b-d8242b6da0dc.pdf','PATIENT_16032a0e-1436-11ef-8f1b-d8242b6da0dc_ACT_d9e0b5cb-1436-11ef-8f1b-d8242b6da0dc_PROST_d9e2b705-1436-11ef-8f1b-d8242b6da0dc_FORM','131bceae-1437-11ef-8f1b-d8242b6da0dc.pdf','e6255f00-1436-11ef-8f1b-d8242b6da0dc','{\"displayTitle\":\"Commande 1.6.2.1 Autre\",\"title\":\"Autre\"}','PDF',1,'SYNCED',0,NULL,'2024-05-17 12:20:24.812','2024-05-17 10:20:25.493','2024-05-17 12:20:25.497'),('1745752c-0947-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_33ac516e-0943-11ef-8f65-d9283bb1c6cd/order_0e416c0d-0947-11ef-8f65-d9283bb1c6cd/1745752c-0947-11ef-8f65-d9283bb1c6cd.pdf','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_33ac516e-0943-11ef-8f65-d9283bb1c6cd_PROST_0e416c0d-0947-11ef-8f65-d9283bb1c6cd_FORM','1745752c-0947-11ef-8f65-d9283bb1c6cd.pdf','1745752c-0947-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Commande 1.2.1.1 Couronne\",\"title\":\"Couronne\"}','PDF',0,'SYNCED',0,NULL,'2024-05-03 14:17:21.595','2024-05-03 12:17:22.287','2024-05-03 14:17:22.434'),('17764359-0863-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_91249277-0862-11ef-8ff6-da2f5a35fe58/17764359-0863-11ef-8ff6-da2f5a35fe58.zip','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_BOSC_91249277-0862-11ef-8ff6-da2f5a35fe58_MODEL','17764359-0863-11ef-8ff6-da2f5a35fe58.zip','17764359-0863-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Mandibule 1.1.2.1.1\",\"modelMatrix\":\"-0.390176,0.908855,0.147464,0,-0.896018,-0.411662,0.166391,0,0.21193,-0.067209,0.974971,0,23.0061,-12.7793,-21.2754,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-02 11:05:19.000','2024-05-02 09:05:19.000','2024-05-02 11:05:19.000'),('17765260-0863-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_91249277-0862-11ef-8ff6-da2f5a35fe58/17765260-0863-11ef-8ff6-da2f5a35fe58.png','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_BOSC_91249277-0862-11ef-8ff6-da2f5a35fe58_SNAPS','17765260-0863-11ef-8ff6-da2f5a35fe58.png','17765260-0863-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Mandibule 1.1.2.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-02 11:05:19.000','2024-05-02 09:05:19.000','2024-05-02 11:05:19.000'),('187400c0-0954-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_67fc2b93-0953-11ef-8f65-d9283bb1c6cd/order_67fe27de-0953-11ef-8f65-d9283bb1c6cd/187400c0-0954-11ef-8f65-d9283bb1c6cd.pdf','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_67fc2b93-0953-11ef-8f65-d9283bb1c6cd_PROST_67fe27de-0953-11ef-8f65-d9283bb1c6cd_FORM','187400c0-0954-11ef-8f65-d9283bb1c6cd.pdf','187400c0-0954-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Commande 1.2.7.1 wf guidé\",\"title\":\"wf guidé\"}','PDF',0,'SYNCED',0,NULL,'2024-05-03 15:50:28.000','2024-05-03 14:05:33.000','2024-05-03 16:05:33.000'),('19439b6b-146d-11ef-8f1b-d8242b6da0dc',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_5748a11c-146a-11ef-8f1b-d8242b6da0dc/occlusion_574ac047-146a-11ef-8f1b-d8242b6da0dc/computedocclusion_d34c3f5e-146c-11ef-8f1b-d8242b6da0dc/19439b6b-146d-11ef-8f1b-d8242b6da0dc.zip','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_5748a11c-146a-11ef-8f1b-d8242b6da0dc_SESS_574ac047-146a-11ef-8f1b-d8242b6da0dc_OCC_d34c3f5e-146c-11ef-8f1b-d8242b6da0dc_TOPLY','19439b6b-146d-11ef-8f1b-d8242b6da0dc.zip','19439b6b-146d-11ef-8f1b-d8242b6da0dc','{\"displayTitle\":\"Occlusion 1.7.3.1.1 Maxillaire\",\"modelMatrix\":\"0.0571383,-0.99819,-0.0187699,0,0.94814,0.0601422,-0.31211,0,0.312674,3.69602e-05,0.94986,0,8.87629,12.0321,-21.9281,1\",\"occlusionMatrix\":\"-0.680963,-0.0660269,-0.728783,0,0.703685,0.215513,-0.677127,0,0.202789,-0.974271,-0.101916,0,-1.29483,16.5615,7.6538,1\",\"occlusionType\":2,\"referenceScanFullDisplayId\":\"1.7.3.1.1\",\"referenceScanId\":\"ce02f919-146b-11ef-8f1b-d8242b6da0dc\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-17 18:47:07.962','2024-05-17 16:47:08.266','2024-05-17 18:47:09.026'),('195c0d37-146d-11ef-8f1b-d8242b6da0dc',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_5748a11c-146a-11ef-8f1b-d8242b6da0dc/occlusion_574ac047-146a-11ef-8f1b-d8242b6da0dc/computedocclusion_d34c3f5e-146c-11ef-8f1b-d8242b6da0dc/195c0d37-146d-11ef-8f1b-d8242b6da0dc.zip','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_5748a11c-146a-11ef-8f1b-d8242b6da0dc_SESS_574ac047-146a-11ef-8f1b-d8242b6da0dc_OCC_d34c3f5e-146c-11ef-8f1b-d8242b6da0dc_BOPLY','195c0d37-146d-11ef-8f1b-d8242b6da0dc.zip','195c0d37-146d-11ef-8f1b-d8242b6da0dc','{\"displayTitle\":\"Occlusion 1.7.3.1.1 Mandibule\",\"modelMatrix\":\"0.836198,-0.506888,0.209375,0,0.548008,0.757334,-0.355151,0,0.021455,0.411716,0.91106,0,-17.4555,-6.11927,-18.4232,1\",\"occlusionMatrix\":\"-0.636329,-0.074105,-0.767356,0,-0.746275,-0.191748,0.637592,0,-0.19538,0.978657,0.068336,0,20.1354,-13.8223,10.2083,1\",\"occlusionType\":2,\"referenceScanFullDisplayId\":\"1.7.3.1.1\",\"referenceScanId\":\"58c830be-146a-11ef-8f1b-d8242b6da0dc\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-17 18:47:08.122','2024-05-17 16:47:08.275','2024-05-17 18:47:11.140'),('198d6002-1844-11ef-8f8e-d92a44d6667d',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_f5aa8d87-1824-11ef-8f8e-d92a44d6667d/occlusion_f5ac369c-1824-11ef-8f8e-d92a44d6667d/scan_e9b9b436-1843-11ef-8f8e-d92a44d6667d/198d6002-1844-11ef-8f8e-d92a44d6667d.ply','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_f5aa8d87-1824-11ef-8f8e-d92a44d6667d_SESS_f5ac369c-1824-11ef-8f8e-d92a44d6667d_TOSC_e9b9b436-1843-11ef-8f8e-d92a44d6667d_SEG','198d6002-1844-11ef-8f8e-d92a44d6667d.ply','198d6002-1844-11ef-8f8e-d92a44d6667d','{\"displayTitle\":\"Maxillaire 1.7.7.1.2 Segmentation\"}','PLY',0,'SYNCED',0,NULL,'2024-05-22 16:03:43.731','2024-05-22 14:03:43.747','2024-05-22 16:03:44.070'),('19d141c6-146d-11ef-8f1b-d8242b6da0dc',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_5748a11c-146a-11ef-8f1b-d8242b6da0dc/occlusion_574ac047-146a-11ef-8f1b-d8242b6da0dc/computedocclusion_d34c3f5e-146c-11ef-8f1b-d8242b6da0dc/19d141c6-146d-11ef-8f1b-d8242b6da0dc.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_5748a11c-146a-11ef-8f1b-d8242b6da0dc_SESS_574ac047-146a-11ef-8f1b-d8242b6da0dc_OCC_d34c3f5e-146c-11ef-8f1b-d8242b6da0dc_SNAPO','19d141c6-146d-11ef-8f1b-d8242b6da0dc.png','19d141c6-146d-11ef-8f1b-d8242b6da0dc','{\"displayTitle\":\"Occlusion 1.7.3.1.1 Snapshot\",\"occlusionType\":2}','PNG',0,'SYNCED',0,NULL,'2024-05-17 18:47:08.891','2024-05-17 16:47:08.901','2024-05-17 18:47:12.341'),('1a936e32-0954-11ef-8ba8-6ec2958327c0',6,'/var/iris/.data/2024/6/discussion_3b2891c3-0950-11ef-8f65-d9283bb1c6cd/1a936e32-0954-11ef-8ba8-6ec2958327c0.pdf','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_67fc2b93-0953-11ef-8f65-d9283bb1c6cd_PROST_67fe27de-0953-11ef-8f65-d9283bb1c6cd_FORM','187400c0-0954-11ef-8f65-d9283bb1c6cd.pdf','1a936e32-0954-11ef-8ba8-6ec2958327c0','{\"displayTitle\":\"Commande 1.2.7.1 wf guidé\",\"title\":\"wf guidé\"}','PDF',0,'SYNCED',0,NULL,'2024-05-03 15:50:28.000','2024-05-03 13:50:28.000','2024-05-03 15:50:28.000'),('1a9e1bb2-0954-11ef-8ba8-6ec2958327c0',6,'/var/iris/.data/2024/6/discussion_3b2891c3-0950-11ef-8f65-d9283bb1c6cd/1a9e1bb2-0954-11ef-8ba8-6ec2958327c0.zip','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_67fc2b93-0953-11ef-8f65-d9283bb1c6cd_SESS_67fdc886-0953-11ef-8f65-d9283bb1c6cd_OCC_ab083f2a-0953-11ef-8f65-d9283bb1c6cd_TOPLY','d1d98002-0953-11ef-8f65-d9283bb1c6cd.zip','1a9e1bb2-0954-11ef-8ba8-6ec2958327c0','{\"displayTitle\":\"Occlusion 1.2.7.1.1 Maxillaire\",\"modelMatrix\":\"0.999879,0.0145411,-0.00550569,0,-0.0145287,0.999892,0.0022888,0,0.00553838,-0.00220853,0.999982,0,-10.8611,0.221993,-18.0198,1\",\"occlusionMatrix\":\"-0.998214,0.0068079,-0.0593854,0,0.0578072,-0.142861,-0.988053,0,-0.0152104,-0.989721,0.142212,0,8.13233,14.0377,-3.1657,1\",\"occlusionType\":2,\"referenceScanId\":\"69c3c2e3-0953-11ef-8f65-d9283bb1c6cd\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-03 15:48:31.000','2024-05-03 13:48:31.000','2024-05-03 15:48:31.000'),('1a9e6597-0954-11ef-8ba8-6ec2958327c0',6,'/var/iris/.data/2024/6/discussion_3b2891c3-0950-11ef-8f65-d9283bb1c6cd/1a9e6597-0954-11ef-8ba8-6ec2958327c0.zip','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_67fc2b93-0953-11ef-8f65-d9283bb1c6cd_SESS_67fdc886-0953-11ef-8f65-d9283bb1c6cd_OCC_ab083f2a-0953-11ef-8f65-d9283bb1c6cd_BOPLY','d1f26a61-0953-11ef-8f65-d9283bb1c6cd.zip','1a9e6597-0954-11ef-8ba8-6ec2958327c0','{\"displayTitle\":\"Occlusion 1.2.7.1.1 Mandibule\",\"modelMatrix\":\"0.975206,0.219802,-0.0256813,0,-0.218098,0.934959,-0.279792,0,-0.0374879,0.278456,0.959717,0,-4.11951,-8.78935,-16.8342,1\",\"occlusionMatrix\":\"-0.990283,0.0534808,-0.12842,0,-0.121616,0.115364,0.985854,0,0.0675388,0.991887,-0.107739,0,7.58796,-14.9673,1.08742,1\",\"occlusionType\":2,\"referenceScanId\":\"8384e76f-0953-11ef-8f65-d9283bb1c6cd\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-03 15:48:34.000','2024-05-03 13:48:34.000','2024-05-03 15:48:34.000'),('1a9eba83-0954-11ef-8ba8-6ec2958327c0',6,'/var/iris/.data/2024/6/discussion_3b2891c3-0950-11ef-8f65-d9283bb1c6cd/1a9eba83-0954-11ef-8ba8-6ec2958327c0.png','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_67fc2b93-0953-11ef-8f65-d9283bb1c6cd_SESS_67fdc886-0953-11ef-8f65-d9283bb1c6cd_OCC_ab083f2a-0953-11ef-8f65-d9283bb1c6cd_SNAPO','d26c0218-0953-11ef-8f65-d9283bb1c6cd.png','1a9eba83-0954-11ef-8ba8-6ec2958327c0','{\"displayTitle\":\"Occlusion 1.2.7.1.1 Snapshot\",\"occlusionType\":2}','PNG',0,'SYNCED',0,NULL,'2024-05-03 15:48:34.000','2024-05-03 13:48:34.000','2024-05-03 15:48:34.000'),('1cc8ff68-094d-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_33ac516e-0943-11ef-8f65-d9283bb1c6cd/order_0e416c0d-0947-11ef-8f65-d9283bb1c6cd/1cc8ff68-094d-11ef-8f65-d9283bb1c6cd.pdf','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_33ac516e-0943-11ef-8f65-d9283bb1c6cd_PROST_0e416c0d-0947-11ef-8f65-d9283bb1c6cd_FORM','1cc8ff68-094d-11ef-8f65-d9283bb1c6cd.pdf','1745752c-0947-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Commande 1.2.1.1 Couronne\",\"title\":\"Couronne\"}','PDF',1,'SYNCED',0,NULL,'2024-05-03 15:00:29.000','2024-05-03 13:00:29.000','2024-05-03 15:00:29.000'),('1dcd04df-183e-11ef-8f8e-d92a44d6667d',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_f0721624-144c-11ef-8f1b-d8242b6da0dc/occlusion_f073b964-144c-11ef-8f1b-d8242b6da0dc/scan_a404f782-1466-11ef-8f1b-d8242b6da0dc/1dcd04df-183e-11ef-8f8e-d92a44d6667d.json','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_f0721624-144c-11ef-8f1b-d8242b6da0dc_SESS_f073b964-144c-11ef-8f1b-d8242b6da0dc_TOSC_a404f782-1466-11ef-8f1b-d8242b6da0dc_METER','1dcd04df-183e-11ef-8f8e-d92a44d6667d.json','03a4f7ef-1834-11ef-8f8e-d92a44d6667d','{\"displayTitle\":\"Maxillaire 1.7.1.1.1 Mesure\"}','JSON',1,'SYNCED',0,NULL,'2024-05-22 15:20:53.878','2024-05-22 13:20:53.882','2024-05-22 15:20:53.961'),('1e96d0f1-0863-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_1e96af46-0863-11ef-8ff6-da2f5a35fe58/1e96d0f1-0863-11ef-8ff6-da2f5a35fe58.zip','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_TOSC_1e96af46-0863-11ef-8ff6-da2f5a35fe58_MODEL','1e96d0f1-0863-11ef-8ff6-da2f5a35fe58.zip','1e96d0f1-0863-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Maxillaire 1.1.2.1.2\",\"modelMatrix\":\"0.0444728,-0.991811,-0.11972,0,0.974881,0.0692654,-0.21168,0,0.218239,-0.107299,0.969979,0,-25.3453,27.4041,-20.8016,1\",\"scanBodies\":[{\"position\":\"27.5285,5,0,0,40.8404,0,5.4,0,34.8176,0,0,6.3,1,0,0,0\",\"reference\":\"K30PSCANP\",\"tid\":26}]}','ZIP',0,'SYNCED',0,NULL,'2024-05-02 11:05:27.000','2024-05-02 09:09:56.000','2024-05-02 11:09:56.000'),('1ea66a74-0863-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_1e96af46-0863-11ef-8ff6-da2f5a35fe58/1ea66a74-0863-11ef-8ff6-da2f5a35fe58.png','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_TOSC_1e96af46-0863-11ef-8ff6-da2f5a35fe58_SNAPS','1ea66a74-0863-11ef-8ff6-da2f5a35fe58.png','1ea66a74-0863-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Maxillaire 1.1.2.1.2 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-02 11:05:32.000','2024-05-02 09:05:32.000','2024-05-02 11:05:32.000'),('1f81ed28-0867-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/order_58e7cf64-0861-11ef-8ff6-da2f5a35fe58/1f81ed28-0867-11ef-8ff6-da2f5a35fe58.pdf','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_PROST_58e7cf64-0861-11ef-8ff6-da2f5a35fe58_FORM','1f81ed28-0867-11ef-8ff6-da2f5a35fe58.pdf','1f81ed28-0867-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Commande 1.1.2.1 Facette\",\"title\":\"Facette\"}','PDF',0,'SYNCED',0,NULL,'2024-05-02 11:34:09.000','2024-05-02 09:34:09.000','2024-05-02 11:34:09.000'),('20b557de-0954-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_67fc2b93-0953-11ef-8f65-d9283bb1c6cd/occlusion_67fdc886-0953-11ef-8f65-d9283bb1c6cd/computedocclusion_ab083f2a-0953-11ef-8f65-d9283bb1c6cd/20b557de-0954-11ef-8f65-d9283bb1c6cd.png','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_67fc2b93-0953-11ef-8f65-d9283bb1c6cd_SESS_67fdc886-0953-11ef-8f65-d9283bb1c6cd_OCC_ab083f2a-0953-11ef-8f65-d9283bb1c6cd_SCREENO','20b557de-0954-11ef-8f65-d9283bb1c6cd.png','20b557de-0954-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Occlusion 1.2.7.1.1 Capture d\'écran 1\",\"occlusionType\":2,\"title\":\"1\"}','PNG',0,'SYNCED',0,NULL,'2024-05-03 15:50:41.000','2024-05-03 13:50:41.000','2024-05-03 15:50:41.000'),('2312bde5-0953-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_4fc2347a-0952-11ef-8f65-d9283bb1c6cd/occlusion_4fc3d0e6-0952-11ef-8f65-d9283bb1c6cd/computedocclusion_9248b871-0952-11ef-8f65-d9283bb1c6cd/2312bde5-0953-11ef-8f65-d9283bb1c6cd.zip','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_4fc2347a-0952-11ef-8f65-d9283bb1c6cd_SESS_4fc3d0e6-0952-11ef-8f65-d9283bb1c6cd_OCC_9248b871-0952-11ef-8f65-d9283bb1c6cd_TOSB','2312bde5-0953-11ef-8f65-d9283bb1c6cd.zip','2312bde5-0953-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Occlusion 1.2.6.1.1 Maxillaire scanbody\",\"modelMatrix\":\"0.99937,0.035479,0.000538262,0,-0.0293851,0.836029,-0.547897,0,-0.0198888,0.547536,0.836546,0,-6.86057,-10.0802,-15.6068,1\",\"occlusionMatrix\":\"0.986567,-0.0960629,-0.131335,0,0.133703,0.0223172,0.990724,0,-0.0939461,-0.995125,0.0349029,0,-14.078,15.4906,2.96545,1\",\"occlusionType\":1,\"referenceScanId\":\"f4d296fb-0952-11ef-8f65-d9283bb1c6cd\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-03 15:43:35.356','2024-05-03 13:43:35.502','2024-05-03 15:43:35.613'),('2370c2cb-146d-11ef-8f1b-d8242b6da0dc',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_5748a11c-146a-11ef-8f1b-d8242b6da0dc/occlusion_574ac047-146a-11ef-8f1b-d8242b6da0dc/computedocclusion_d34c3f5e-146c-11ef-8f1b-d8242b6da0dc/2370c2cb-146d-11ef-8f1b-d8242b6da0dc.zip','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_5748a11c-146a-11ef-8f1b-d8242b6da0dc_SESS_574ac047-146a-11ef-8f1b-d8242b6da0dc_OCC_d34c3f5e-146c-11ef-8f1b-d8242b6da0dc_BOSB','2370c2cb-146d-11ef-8f1b-d8242b6da0dc.zip','2370c2cb-146d-11ef-8f1b-d8242b6da0dc','{\"displayTitle\":\"Occlusion 1.7.3.1.1 Mandibule scanbody\",\"modelMatrix\":\"0.216912,-0.961673,0.167735,0,0.914657,0.140177,-0.379147,0,0.341103,0.235661,0.910007,0,-27.5796,7.81859,-17.4136,1\",\"occlusionMatrix\":\"-0.637784,-0.0703476,-0.766501,0,-0.744744,-0.196475,0.637942,0,-0.196465,0.977986,0.0745452,0,19.8963,-13.6355,10.0173,1\",\"occlusionType\":2,\"referenceScanFullDisplayId\":\"1.7.3.1.2\",\"referenceScanId\":\"6c005b92-146b-11ef-8f1b-d8242b6da0dc\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-17 18:47:25.035','2024-05-17 16:47:25.196','2024-05-17 18:47:25.781'),('2563eb4a-176d-11ef-8f86-d92942cf49fd',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_b1ce9a22-1749-11ef-8f86-d92942cf49fd/occlusion_b1d043a8-1749-11ef-8f86-d92942cf49fd/computedocclusion_e3bf7a84-176c-11ef-8f86-d92942cf49fd/2563eb4a-176d-11ef-8f86-d92942cf49fd.zip','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_b1ce9a22-1749-11ef-8f86-d92942cf49fd_SESS_b1d043a8-1749-11ef-8f86-d92942cf49fd_OCC_e3bf7a84-176c-11ef-8f86-d92942cf49fd_TOSB','2563eb4a-176d-11ef-8f86-d92942cf49fd.zip','2563eb4a-176d-11ef-8f86-d92942cf49fd','{\"displayTitle\":\"Occlusion 1.7.6.1.1 Maxillaire scanbody\",\"modelMatrix\":\"0.994751,0.0340975,-0.096478,0,-0.0782668,0.860899,-0.50272,0,0.0659163,0.507633,0.859048,0,14.4626,-15.8723,-17.8162,1\",\"occlusionMatrix\":\"0.986187,-0.00147707,0.165636,0,-0.165238,0.061014,0.984366,0,-0.01156,-0.998136,0.0599271,0,14.6671,18.4977,-4.47515,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.7.6.1.2\",\"referenceScanId\":\"e0fd2566-1749-11ef-8f86-d92942cf49fd\",\"scanBodies\":[{\"position\":\"-29.0903,6,0,0,9.12029,0,4.5,0,26.796,0,0,6,1,0,0,0\",\"reference\":\"K30PSCANP\",\"tid\":16}]}','ZIP',0,'SYNCED',0,NULL,'2024-05-21 14:25:01.795','2024-05-21 12:25:01.953','2024-05-21 14:25:02.516'),('25ab5185-0864-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_59e98ac5-0861-11ef-8ff6-da2f5a35fe58/25ab5185-0864-11ef-8ff6-da2f5a35fe58.xyz','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_TOSC_59e98ac5-0861-11ef-8ff6-da2f5a35fe58_LIFI','25ab5185-0864-11ef-8ff6-da2f5a35fe58.xyz','e0bfa86b-0863-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Maxillaire 1.1.2.1.1 Ligne de finition 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',1,'SYNCED',0,NULL,'2024-05-02 11:12:49.351','2024-05-02 09:12:49.354','2024-05-02 11:12:49.374'),('25ab54c4-0864-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_59e98ac5-0861-11ef-8ff6-da2f5a35fe58/25ab54c4-0864-11ef-8ff6-da2f5a35fe58.bin','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_TOSC_59e98ac5-0861-11ef-8ff6-da2f5a35fe58_LIFIM','25ab54c4-0864-11ef-8ff6-da2f5a35fe58.bin','e0bfadf4-0863-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Maxillaire 1.1.2.1.1 Ligne de finition métadonnées 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',1,'SYNCED',0,NULL,'2024-05-02 11:12:49.351','2024-05-02 09:12:49.364','2024-05-02 11:12:49.635'),('27b8b3c2-0869-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_9fff6be0-0868-11ef-8ff6-da2f5a35fe58/occlusion_a000fd43-0868-11ef-8ff6-da2f5a35fe58/scan_0da7e703-0869-11ef-8ff6-da2f5a35fe58/27b8b3c2-0869-11ef-8ff6-da2f5a35fe58.zip','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_9fff6be0-0868-11ef-8ff6-da2f5a35fe58_SESS_a000fd43-0868-11ef-8ff6-da2f5a35fe58_FRSC_0da7e703-0869-11ef-8ff6-da2f5a35fe58_MODEL','27b8b3c2-0869-11ef-8ff6-da2f5a35fe58.zip','27b8b3c2-0869-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Mordu antérieur 1.1.3.1.1\",\"modelMatrix\":\"0.998862,0.0035764,-0.0485532,0,-0.00186451,0.999186,0.0402755,0,0.0476587,-0.0401872,0.998009,0,2.6593,4.01347,-20.1222,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-02 11:48:40.277','2024-05-02 09:48:40.493','2024-05-02 11:48:42.443'),('27b8c661-0869-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_9fff6be0-0868-11ef-8ff6-da2f5a35fe58/occlusion_a000fd43-0868-11ef-8ff6-da2f5a35fe58/scan_0da7e703-0869-11ef-8ff6-da2f5a35fe58/27b8c661-0869-11ef-8ff6-da2f5a35fe58.png','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_9fff6be0-0868-11ef-8ff6-da2f5a35fe58_SESS_a000fd43-0868-11ef-8ff6-da2f5a35fe58_FRSC_0da7e703-0869-11ef-8ff6-da2f5a35fe58_SNAPS','27b8c661-0869-11ef-8ff6-da2f5a35fe58.png','27b8c661-0869-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Mordu antérieur 1.1.3.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-02 11:48:40.278','2024-05-02 09:48:40.496','2024-05-02 11:48:42.994'),('2aa61e09-0869-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_9fff6be0-0868-11ef-8ff6-da2f5a35fe58/occlusion_a000fd43-0868-11ef-8ff6-da2f5a35fe58/computedocclusion_0cf0848e-0869-11ef-8ff6-da2f5a35fe58/2aa61e09-0869-11ef-8ff6-da2f5a35fe58.zip','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_9fff6be0-0868-11ef-8ff6-da2f5a35fe58_SESS_a000fd43-0868-11ef-8ff6-da2f5a35fe58_OCC_0cf0848e-0869-11ef-8ff6-da2f5a35fe58_TOPLY','2aa61e09-0869-11ef-8ff6-da2f5a35fe58.zip','2aa61e09-0869-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Occlusion 1.1.3.1.1 Maxillaire\",\"modelMatrix\":\"-0.299994,0.953935,-0.00332519,0,-0.913283,-0.288213,-0.287833,0,-0.275532,-0.0833111,0.957675,0,9.09266,-8.61807,-16.7682,1\",\"occlusionMatrix\":\"0.894318,0.179622,-0.409792,0,0.342237,0.315346,0.885116,0,0.288213,-0.93182,0.220547,0,-13.8624,11.5932,-1.27102,1\",\"occlusionType\":3,\"referenceScanId\":\"be43909f-0868-11ef-8ff6-da2f5a35fe58\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-02 11:48:46.000','2024-05-02 09:48:46.000','2024-05-02 11:48:46.000'),('2ac2bcfd-0869-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_9fff6be0-0868-11ef-8ff6-da2f5a35fe58/occlusion_a000fd43-0868-11ef-8ff6-da2f5a35fe58/computedocclusion_0cf0848e-0869-11ef-8ff6-da2f5a35fe58/2ac2bcfd-0869-11ef-8ff6-da2f5a35fe58.zip','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_9fff6be0-0868-11ef-8ff6-da2f5a35fe58_SESS_a000fd43-0868-11ef-8ff6-da2f5a35fe58_OCC_0cf0848e-0869-11ef-8ff6-da2f5a35fe58_BOPLY','2ac2bcfd-0869-11ef-8ff6-da2f5a35fe58.zip','2ac2bcfd-0869-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Occlusion 1.1.3.1.1 Mandibule\",\"modelMatrix\":\"-0.97878,-0.174408,0.107571,0,0.176364,-0.984285,0.00886413,0,0.104334,0.0276476,0.994158,0,10.9633,2.36245,-21.2611,1\",\"occlusionMatrix\":\"0.910352,0.137331,-0.390406,0,-0.361384,-0.195961,-0.911596,0,-0.201694,0.970955,-0.128768,0,-9.86668,-18.0279,9.29767,1\",\"occlusionType\":3,\"referenceScanId\":\"eacd5e79-0868-11ef-8ff6-da2f5a35fe58\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-02 11:48:46.000','2024-05-02 09:48:46.000','2024-05-02 11:48:46.000'),('2b2af635-1844-11ef-8f8e-d92a44d6667d',3,'/var/iris/.data/2024/3/16032a0e-1436-11ef-8f1b-d8242b6da0dc/session_1f4547de-1436-11ef-8f1b-d8242b6da0dc/occlusion_1f46ec8a-1436-11ef-8f1b-d8242b6da0dc/scan_214f7b82-1436-11ef-8f1b-d8242b6da0dc/2b2af635-1844-11ef-8f8e-d92a44d6667d.png','PATIENT_16032a0e-1436-11ef-8f1b-d8242b6da0dc_ACT_1f4547de-1436-11ef-8f1b-d8242b6da0dc_SESS_1f46ec8a-1436-11ef-8f1b-d8242b6da0dc_TOSC_214f7b82-1436-11ef-8f1b-d8242b6da0dc_SCREENS','2b2af635-1844-11ef-8f8e-d92a44d6667d.png','2b2af635-1844-11ef-8f8e-d92a44d6667d','{\"displayTitle\":\"Maxillaire 1.6.1.1.1 Capture d\'écran 1\",\"title\":\"1\"}','PNG',0,'SYNCED',0,'2024-05-22 16:04:29.986','2024-05-22 16:04:29.986','2024-05-22 14:04:29.987','2024-05-22 16:04:29.996'),('2b3e9ab9-0869-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_9fff6be0-0868-11ef-8ff6-da2f5a35fe58/occlusion_a000fd43-0868-11ef-8ff6-da2f5a35fe58/computedocclusion_0cf0848e-0869-11ef-8ff6-da2f5a35fe58/2b3e9ab9-0869-11ef-8ff6-da2f5a35fe58.png','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_9fff6be0-0868-11ef-8ff6-da2f5a35fe58_SESS_a000fd43-0868-11ef-8ff6-da2f5a35fe58_OCC_0cf0848e-0869-11ef-8ff6-da2f5a35fe58_SNAPO','2b3e9ab9-0869-11ef-8ff6-da2f5a35fe58.png','2b3e9ab9-0869-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Occlusion 1.1.3.1.1 Snapshot\",\"occlusionType\":3}','PNG',0,'SYNCED',0,NULL,'2024-05-02 11:48:46.188','2024-05-02 09:48:46.191','2024-05-02 11:48:46.885'),('2bf2d463-1dd2-11ef-8f99-d92a46e09137',15,'/var/iris/.data/2024/15/de66fe79-1dd1-11ef-8f99-d92a46e09137/session_ec1c9685-1dd1-11ef-8f99-d92a46e09137/order_ec1e9f7a-1dd1-11ef-8f99-d92a46e09137/2bf2d463-1dd2-11ef-8f99-d92a46e09137.pdf','PATIENT_de66fe79-1dd1-11ef-8f99-d92a46e09137_ACT_ec1c9685-1dd1-11ef-8f99-d92a46e09137_PROST_ec1e9f7a-1dd1-11ef-8f99-d92a46e09137_FORM','2bf2d463-1dd2-11ef-8f99-d92a46e09137.pdf','2bf2d463-1dd2-11ef-8f99-d92a46e09137','{\"displayTitle\":\"Commande 2.3.1.1 Facette\",\"title\":\"Facette\"}','PDF',0,'SYNCED',0,NULL,'2024-05-29 17:43:18.944','2024-05-29 15:43:19.670','2024-05-29 17:43:19.778'),('2cc50615-1844-11ef-8f8e-d92a44d6667d',3,'/var/iris/.data/2024/3/16032a0e-1436-11ef-8f1b-d8242b6da0dc/session_1f4547de-1436-11ef-8f1b-d8242b6da0dc/occlusion_1f46ec8a-1436-11ef-8f1b-d8242b6da0dc/scan_214f7b82-1436-11ef-8f1b-d8242b6da0dc/2cc50615-1844-11ef-8f8e-d92a44d6667d.png','PATIENT_16032a0e-1436-11ef-8f1b-d8242b6da0dc_ACT_1f4547de-1436-11ef-8f1b-d8242b6da0dc_SESS_1f46ec8a-1436-11ef-8f1b-d8242b6da0dc_TOSC_214f7b82-1436-11ef-8f1b-d8242b6da0dc_SCREENS','2cc50615-1844-11ef-8f8e-d92a44d6667d.png','2cc50615-1844-11ef-8f8e-d92a44d6667d','{\"displayTitle\":\"Maxillaire 1.6.1.1.1 Capture d\'écran 2\",\"title\":\"2\"}','PNG',0,'SYNCED',0,'2024-05-22 16:04:31.826','2024-05-22 16:04:31.826','2024-05-22 14:04:31.827','2024-05-22 16:04:31.836'),('2e7c9b07-1844-11ef-8f8e-d92a44d6667d',3,'/var/iris/.data/2024/3/16032a0e-1436-11ef-8f1b-d8242b6da0dc/session_1f4547de-1436-11ef-8f1b-d8242b6da0dc/occlusion_1f46ec8a-1436-11ef-8f1b-d8242b6da0dc/scan_214f7b82-1436-11ef-8f1b-d8242b6da0dc/2e7c9b07-1844-11ef-8f8e-d92a44d6667d.png','PATIENT_16032a0e-1436-11ef-8f1b-d8242b6da0dc_ACT_1f4547de-1436-11ef-8f1b-d8242b6da0dc_SESS_1f46ec8a-1436-11ef-8f1b-d8242b6da0dc_TOSC_214f7b82-1436-11ef-8f1b-d8242b6da0dc_SCREENS','2e7c9b07-1844-11ef-8f8e-d92a44d6667d.png','2e7c9b07-1844-11ef-8f8e-d92a44d6667d','{\"displayTitle\":\"Maxillaire 1.6.1.1.1 Capture d\'écran 3\",\"title\":\"3\"}','PNG',0,'SYNCED',0,'2024-05-22 16:04:33.970','2024-05-22 16:04:33.970','2024-05-22 14:04:33.971','2024-05-22 16:04:33.980'),('2fbc2cef-0864-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_91249277-0862-11ef-8ff6-da2f5a35fe58/2fbc2cef-0864-11ef-8ff6-da2f5a35fe58.xyz','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_BOSC_91249277-0862-11ef-8ff6-da2f5a35fe58_LIFI','2fbc2cef-0864-11ef-8ff6-da2f5a35fe58.xyz','2fbc2cef-0864-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Mandibule 1.1.2.1.1 Ligne de finition 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-05-02 11:13:06.238','2024-05-02 09:13:06.243','2024-05-02 11:13:06.262'),('2fbc3392-0864-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_91249277-0862-11ef-8ff6-da2f5a35fe58/2fbc3392-0864-11ef-8ff6-da2f5a35fe58.bin','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_BOSC_91249277-0862-11ef-8ff6-da2f5a35fe58_LIFIM','2fbc3392-0864-11ef-8ff6-da2f5a35fe58.bin','2fbc3392-0864-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Mandibule 1.1.2.1.1 Ligne de finition métadonnées 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-05-02 11:13:06.239','2024-05-02 09:13:06.257','2024-05-02 11:13:06.450'),('30213ce6-1844-11ef-8f8e-d92a44d6667d',3,'/var/iris/.data/2024/3/16032a0e-1436-11ef-8f1b-d8242b6da0dc/session_1f4547de-1436-11ef-8f1b-d8242b6da0dc/occlusion_1f46ec8a-1436-11ef-8f1b-d8242b6da0dc/scan_214f7b82-1436-11ef-8f1b-d8242b6da0dc/30213ce6-1844-11ef-8f8e-d92a44d6667d.png','PATIENT_16032a0e-1436-11ef-8f1b-d8242b6da0dc_ACT_1f4547de-1436-11ef-8f1b-d8242b6da0dc_SESS_1f46ec8a-1436-11ef-8f1b-d8242b6da0dc_TOSC_214f7b82-1436-11ef-8f1b-d8242b6da0dc_SCREENS','30213ce6-1844-11ef-8f8e-d92a44d6667d.png','30213ce6-1844-11ef-8f8e-d92a44d6667d','{\"displayTitle\":\"Maxillaire 1.6.1.1.1 Capture d\'écran 4\",\"title\":\"4\"}','PNG',0,'SYNCED',0,'2024-05-22 16:04:35.845','2024-05-22 16:04:35.845','2024-05-22 14:04:35.845','2024-05-22 16:04:35.855'),('3102e726-086d-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_1fcf39f6-086d-11ef-8ff6-da2f5a35fe58/occlusion_1fcf8a88-086d-11ef-8ff6-da2f5a35fe58/scan_20b98eb5-086d-11ef-8ff6-da2f5a35fe58/3102e726-086d-11ef-8ff6-da2f5a35fe58.zip','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_1fcf39f6-086d-11ef-8ff6-da2f5a35fe58_SESS_1fcf8a88-086d-11ef-8ff6-da2f5a35fe58_TOSC_20b98eb5-086d-11ef-8ff6-da2f5a35fe58_MODEL','3102e726-086d-11ef-8ff6-da2f5a35fe58.zip','3102e726-086d-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Maxillaire 1.1.5.1.1\",\"modelMatrix\":\"-0.750205,-0.654663,0.0927873,0,0.657972,-0.725289,0.202553,0,-0.0653062,0.213008,0.974865,0,10.396,1.0936,-14.5821,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-02 12:18:00.000','2024-05-02 10:18:00.000','2024-05-02 12:18:00.000'),('3102fb86-086d-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_1fcf39f6-086d-11ef-8ff6-da2f5a35fe58/occlusion_1fcf8a88-086d-11ef-8ff6-da2f5a35fe58/scan_20b98eb5-086d-11ef-8ff6-da2f5a35fe58/3102fb86-086d-11ef-8ff6-da2f5a35fe58.png','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_1fcf39f6-086d-11ef-8ff6-da2f5a35fe58_SESS_1fcf8a88-086d-11ef-8ff6-da2f5a35fe58_TOSC_20b98eb5-086d-11ef-8ff6-da2f5a35fe58_SNAPS','3102fb86-086d-11ef-8ff6-da2f5a35fe58.png','3102fb86-086d-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Maxillaire 1.1.5.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-02 12:18:00.000','2024-05-02 10:18:00.000','2024-05-02 12:18:00.000'),('3163c7c7-0863-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_1e96af46-0863-11ef-8ff6-da2f5a35fe58/3163c7c7-0863-11ef-8ff6-da2f5a35fe58.ply','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_TOSC_1e96af46-0863-11ef-8ff6-da2f5a35fe58_SEG','3163c7c7-0863-11ef-8ff6-da2f5a35fe58.ply','3163c7c7-0863-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Maxillaire scanbody 1.1.2.1.2 Segmentation\"}','PLY',0,'CREATED',0,'2024-05-02 11:06:21.938','2024-05-02 11:06:21.939','2024-05-02 09:06:21.939',NULL),('318da0fb-1844-11ef-8f8e-d92a44d6667d',3,'/var/iris/.data/2024/3/16032a0e-1436-11ef-8f1b-d8242b6da0dc/session_1f4547de-1436-11ef-8f1b-d8242b6da0dc/occlusion_1f46ec8a-1436-11ef-8f1b-d8242b6da0dc/scan_214f7b82-1436-11ef-8f1b-d8242b6da0dc/318da0fb-1844-11ef-8f8e-d92a44d6667d.png','PATIENT_16032a0e-1436-11ef-8f1b-d8242b6da0dc_ACT_1f4547de-1436-11ef-8f1b-d8242b6da0dc_SESS_1f46ec8a-1436-11ef-8f1b-d8242b6da0dc_TOSC_214f7b82-1436-11ef-8f1b-d8242b6da0dc_SCREENS','318da0fb-1844-11ef-8f8e-d92a44d6667d.png','318da0fb-1844-11ef-8f8e-d92a44d6667d','{\"displayTitle\":\"Maxillaire 1.6.1.1.1 Capture d\'écran 5\",\"title\":\"5\"}','PNG',0,'SYNCED',0,'2024-05-22 16:04:37.844','2024-05-22 16:04:37.844','2024-05-22 14:04:37.845','2024-05-22 16:04:37.854'),('3202c706-0869-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_9fff6be0-0868-11ef-8ff6-da2f5a35fe58/order_a0015ffe-0868-11ef-8ff6-da2f5a35fe58/3202c706-0869-11ef-8ff6-da2f5a35fe58.pdf','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_9fff6be0-0868-11ef-8ff6-da2f5a35fe58_PROST_a0015ffe-0868-11ef-8ff6-da2f5a35fe58_FORM','3202c706-0869-11ef-8ff6-da2f5a35fe58.pdf','3202c706-0869-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Commande 1.1.3.1 Facette\",\"title\":\"Facette\"}','PDF',0,'SYNCED',0,NULL,'2024-05-02 11:48:57.540','2024-05-02 09:48:58.276','2024-05-02 11:48:58.384'),('3238bfed-174a-11ef-8f86-d92942cf49fd',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_b1ce9a22-1749-11ef-8f86-d92942cf49fd/occlusion_b1d043a8-1749-11ef-8f86-d92942cf49fd/scan_e0fd2566-1749-11ef-8f86-d92942cf49fd/3238bfed-174a-11ef-8f86-d92942cf49fd.zip','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_b1ce9a22-1749-11ef-8f86-d92942cf49fd_SESS_b1d043a8-1749-11ef-8f86-d92942cf49fd_TOSC_e0fd2566-1749-11ef-8f86-d92942cf49fd_MODEL','3238bfed-174a-11ef-8f86-d92942cf49fd.zip','e0fd50b7-1749-11ef-8f86-d92942cf49fd','{\"displayTitle\":\"Maxillaire scanbody 1.7.6.1.2\",\"modelMatrix\":\"0.994751,0.0340975,-0.096478,0,-0.0782668,0.860899,-0.50272,0,0.0659163,0.507633,0.859048,0,14.4626,-15.8723,-17.8162,1\",\"scanBodies\":[{\"position\":\"-29.0903,6,0,0,9.12029,0,4.5,0,26.796,0,0,6,1,0,0,0\",\"reference\":\"K30PSCANP\",\"tid\":16}]}','ZIP',2,'SYNCED',0,NULL,'2024-05-21 10:14:50.937','2024-05-21 08:14:51.598','2024-05-21 10:14:53.435'),('3238d9b7-174a-11ef-8f86-d92942cf49fd',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_b1ce9a22-1749-11ef-8f86-d92942cf49fd/occlusion_b1d043a8-1749-11ef-8f86-d92942cf49fd/scan_e0fd2566-1749-11ef-8f86-d92942cf49fd/3238d9b7-174a-11ef-8f86-d92942cf49fd.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_b1ce9a22-1749-11ef-8f86-d92942cf49fd_SESS_b1d043a8-1749-11ef-8f86-d92942cf49fd_TOSC_e0fd2566-1749-11ef-8f86-d92942cf49fd_SNAPS','3238d9b7-174a-11ef-8f86-d92942cf49fd.png','e103322a-1749-11ef-8f86-d92942cf49fd','{\"displayTitle\":\"Maxillaire scanbody 1.7.6.1.2 Snapshot\"}','PNG',1,'SYNCED',0,NULL,'2024-05-21 10:14:50.938','2024-05-21 08:14:51.598','2024-05-21 10:14:53.567'),('33ad43c0-0867-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/order_58e7cf64-0861-11ef-8ff6-da2f5a35fe58/33ad43c0-0867-11ef-8ff6-da2f5a35fe58.pdf','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_PROST_58e7cf64-0861-11ef-8ff6-da2f5a35fe58_FORM','33ad43c0-0867-11ef-8ff6-da2f5a35fe58.pdf','1f81ed28-0867-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Commande 1.1.2.1 Facette\",\"title\":\"Facette\"}','PDF',1,'SYNCED',0,NULL,'2024-05-02 11:34:41.342','2024-05-02 09:34:42.034','2024-05-02 11:34:42.041'),('35700320-0954-11ef-8ba8-6ec2958327c0',6,'/var/iris/.data/2024/6/discussion_3b2891c3-0950-11ef-8f65-d9283bb1c6cd/35700320-0954-11ef-8ba8-6ec2958327c0.png','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_67fc2b93-0953-11ef-8f65-d9283bb1c6cd_SESS_67fdc886-0953-11ef-8f65-d9283bb1c6cd_OCC_ab083f2a-0953-11ef-8f65-d9283bb1c6cd_SCREENO','20b557de-0954-11ef-8f65-d9283bb1c6cd.png','35700320-0954-11ef-8ba8-6ec2958327c0','{\"displayTitle\":\"Occlusion 1.2.7.1.1 Capture d\'écran 1\",\"occlusionType\":2,\"title\":\"1\"}','PNG',0,'SYNCED',0,NULL,'2024-05-03 15:50:41.000','2024-05-03 13:50:41.000','2024-05-03 15:50:41.000'),('39436bdb-1438-11ef-8f1b-d8242b6da0dc',3,'/var/iris/.data/2024/3/16032a0e-1436-11ef-8f1b-d8242b6da0dc/session_d961f6f4-1437-11ef-8f1b-d8242b6da0dc/order_d963f904-1437-11ef-8f1b-d8242b6da0dc/39436bdb-1438-11ef-8f1b-d8242b6da0dc.pdf','PATIENT_16032a0e-1436-11ef-8f1b-d8242b6da0dc_ACT_d961f6f4-1437-11ef-8f1b-d8242b6da0dc_PROST_d963f904-1437-11ef-8f1b-d8242b6da0dc_FORM','39436bdb-1438-11ef-8f1b-d8242b6da0dc.pdf','eb0e1462-1437-11ef-8f1b-d8242b6da0dc','{\"displayTitle\":\"Commande 1.6.3.1 Autre\",\"title\":\"Autre\"}','PDF',1,'SYNCED',0,NULL,'2024-05-17 12:28:39.000','2024-05-17 10:28:39.000','2024-05-17 12:28:39.000'),('39676397-113d-11ef-8f8d-d92a44d56471',3,'/var/iris/.data/2024/3/4ce59675-1136-11ef-8f8d-d92a44d56471/session_233ae18e-113d-11ef-8f8d-d92a44d56471/occlusion_233c76c4-113d-11ef-8f8d-d92a44d56471/scan_242b7d3c-113d-11ef-8f8d-d92a44d56471/39676397-113d-11ef-8f8d-d92a44d56471.zip','PATIENT_4ce59675-1136-11ef-8f8d-d92a44d56471_ACT_233ae18e-113d-11ef-8f8d-d92a44d56471_SESS_233c76c4-113d-11ef-8f8d-d92a44d56471_TOSC_242b7d3c-113d-11ef-8f8d-d92a44d56471_MODEL','39676397-113d-11ef-8f8d-d92a44d56471.zip','39676397-113d-11ef-8f8d-d92a44d56471','{\"displayTitle\":\"Maxillaire 1.3.2.1.1\",\"modelMatrix\":\"-0.980136,0.193515,-0.0434312,0,-0.192992,-0.880158,0.433677,0,0.0456967,0.433444,0.900021,0,3.53832,-6.32106,-17.4375,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-13 17:26:56.000','2024-05-13 15:26:56.000','2024-05-13 17:26:56.000'),('39676fab-113d-11ef-8f8d-d92a44d56471',3,'/var/iris/.data/2024/3/4ce59675-1136-11ef-8f8d-d92a44d56471/session_233ae18e-113d-11ef-8f8d-d92a44d56471/occlusion_233c76c4-113d-11ef-8f8d-d92a44d56471/scan_242b7d3c-113d-11ef-8f8d-d92a44d56471/39676fab-113d-11ef-8f8d-d92a44d56471.png','PATIENT_4ce59675-1136-11ef-8f8d-d92a44d56471_ACT_233ae18e-113d-11ef-8f8d-d92a44d56471_SESS_233c76c4-113d-11ef-8f8d-d92a44d56471_TOSC_242b7d3c-113d-11ef-8f8d-d92a44d56471_SNAPS','39676fab-113d-11ef-8f8d-d92a44d56471.png','39676fab-113d-11ef-8f8d-d92a44d56471','{\"displayTitle\":\"Maxillaire 1.3.2.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-13 17:26:57.000','2024-05-13 15:26:57.000','2024-05-13 17:26:57.000'),('3c46656a-0954-11ef-8ba8-6ec2958327c0',6,'/var/iris/.data/2024/6/discussion_3b2891c3-0950-11ef-8f65-d9283bb1c6cd/3c46656a-0954-11ef-8ba8-6ec2958327c0.png','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_67fc2b93-0953-11ef-8f65-d9283bb1c6cd_SESS_67fdc886-0953-11ef-8f65-d9283bb1c6cd_OCC_ab083f2a-0953-11ef-8f65-d9283bb1c6cd_SCREENO','20b557de-0954-11ef-8f65-d9283bb1c6cd.png','3c46656a-0954-11ef-8ba8-6ec2958327c0','{\"displayTitle\":\"Occlusion 1.2.7.1.1 Capture d\'écran 1\",\"occlusionType\":2,\"title\":\"1\"}','PNG',0,'SYNCED',0,NULL,'2024-05-03 15:50:41.000','2024-05-03 13:50:41.000','2024-05-03 15:50:41.000'),('3c611073-1436-11ef-8f1b-d8242b6da0dc',3,'/var/iris/.data/2024/3/16032a0e-1436-11ef-8f1b-d8242b6da0dc/session_1f4547de-1436-11ef-8f1b-d8242b6da0dc/occlusion_1f46ec8a-1436-11ef-8f1b-d8242b6da0dc/scan_214f7b82-1436-11ef-8f1b-d8242b6da0dc/3c611073-1436-11ef-8f1b-d8242b6da0dc.zip','PATIENT_16032a0e-1436-11ef-8f1b-d8242b6da0dc_ACT_1f4547de-1436-11ef-8f1b-d8242b6da0dc_SESS_1f46ec8a-1436-11ef-8f1b-d8242b6da0dc_TOSC_214f7b82-1436-11ef-8f1b-d8242b6da0dc_MODEL','3c611073-1436-11ef-8f1b-d8242b6da0dc.zip','3c611073-1436-11ef-8f1b-d8242b6da0dc','{\"displayTitle\":\"Maxillaire 1.6.1.1.1\",\"modelMatrix\":\"-0.985921,0.0685462,0.152515,0,-0.0624728,-0.997064,0.0442685,0,0.155102,0.0341172,0.987309,0,4.01085,3.56858,-18.7428,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-17 12:14:28.000','2024-05-17 10:17:58.000','2024-05-17 12:17:58.000'),('3c6127b7-1436-11ef-8f1b-d8242b6da0dc',3,'/var/iris/.data/2024/3/16032a0e-1436-11ef-8f1b-d8242b6da0dc/session_1f4547de-1436-11ef-8f1b-d8242b6da0dc/occlusion_1f46ec8a-1436-11ef-8f1b-d8242b6da0dc/scan_214f7b82-1436-11ef-8f1b-d8242b6da0dc/3c6127b7-1436-11ef-8f1b-d8242b6da0dc.png','PATIENT_16032a0e-1436-11ef-8f1b-d8242b6da0dc_ACT_1f4547de-1436-11ef-8f1b-d8242b6da0dc_SESS_1f46ec8a-1436-11ef-8f1b-d8242b6da0dc_TOSC_214f7b82-1436-11ef-8f1b-d8242b6da0dc_SNAPS','3c6127b7-1436-11ef-8f1b-d8242b6da0dc.png','3c6127b7-1436-11ef-8f1b-d8242b6da0dc','{\"displayTitle\":\"Maxillaire 1.6.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-17 12:14:28.000','2024-05-17 10:17:58.000','2024-05-17 12:17:58.000'),('3ea239fc-0863-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_1e96af46-0863-11ef-8ff6-da2f5a35fe58/3ea239fc-0863-11ef-8ff6-da2f5a35fe58.zip','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_TOSC_1e96af46-0863-11ef-8ff6-da2f5a35fe58_MODEL','3ea239fc-0863-11ef-8ff6-da2f5a35fe58.zip','1e96d0f1-0863-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Maxillaire scanbody 1.1.2.1.2\",\"modelMatrix\":\"0.0444728,-0.991811,-0.11972,0,0.974881,0.0692654,-0.21168,0,0.218239,-0.107299,0.969979,0,-25.3453,27.4041,-20.8016,1\",\"scanBodies\":[{\"position\":\"27.5285,5,0,0,40.8404,0,5.4,0,34.8176,0,0,6.3,1,0,0,0\",\"reference\":\"K30PSCANP\",\"tid\":26}]}','ZIP',1,'SYNCED',0,NULL,'2024-05-02 11:06:21.737','2024-05-02 09:06:21.866','2024-05-02 11:09:57.178'),('3f572760-1dc5-11ef-8e10-d517f279883e',15,'/var/iris/.data/2024/15/8eb8d841-1dc4-11ef-8e10-d517f279883e/session_97a4fb29-1dc4-11ef-8e10-d517f279883e/occlusion_97a7648b-1dc4-11ef-8e10-d517f279883e/computedocclusion_0ffde937-1dc5-11ef-8e10-d517f279883e/3f572760-1dc5-11ef-8e10-d517f279883e.zip','PATIENT_8eb8d841-1dc4-11ef-8e10-d517f279883e_ACT_97a4fb29-1dc4-11ef-8e10-d517f279883e_SESS_97a7648b-1dc4-11ef-8e10-d517f279883e_OCC_0ffde937-1dc5-11ef-8e10-d517f279883e_TOPLY','3f572760-1dc5-11ef-8e10-d517f279883e.zip','3f572760-1dc5-11ef-8e10-d517f279883e','{\"displayTitle\":\"Occlusion 1.1.1.1.1 Maxillaire\",\"modelMatrix\":\"0.979412,0.193087,-0.0588964,0,-0.185851,0.748568,-0.636479,0,-0.0788078,0.634321,0.769042,0,-18.6321,-11.2556,-10.2485,1\",\"occlusionMatrix\":\"0.996872,-0.0756274,-0.0231404,0,0.0296807,0.0865358,0.995805,0,-0.0733074,-0.993376,0.088508,0,-17.2672,10.7574,0.804369,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.1.1.1.1\",\"referenceScanId\":\"a6dfd269-1dc4-11ef-8e10-d517f279883e\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-29 16:10:54.000','2024-05-29 15:05:51.000','2024-05-29 17:05:51.000'),('3f7139f8-1dc5-11ef-8e10-d517f279883e',15,'/var/iris/.data/2024/15/8eb8d841-1dc4-11ef-8e10-d517f279883e/session_97a4fb29-1dc4-11ef-8e10-d517f279883e/occlusion_97a7648b-1dc4-11ef-8e10-d517f279883e/computedocclusion_0ffde937-1dc5-11ef-8e10-d517f279883e/3f7139f8-1dc5-11ef-8e10-d517f279883e.zip','PATIENT_8eb8d841-1dc4-11ef-8e10-d517f279883e_ACT_97a4fb29-1dc4-11ef-8e10-d517f279883e_SESS_97a7648b-1dc4-11ef-8e10-d517f279883e_OCC_0ffde937-1dc5-11ef-8e10-d517f279883e_BOPLY','3f7139f8-1dc5-11ef-8e10-d517f279883e.zip','3f7139f8-1dc5-11ef-8e10-d517f279883e','{\"displayTitle\":\"Occlusion 1.1.1.1.1 Mandibule\",\"modelMatrix\":\"0.989354,-0.138659,-0.0441867,0,0.138295,0.990328,-0.0112196,0,0.045315,0.00498938,0.99896,0,-17.3085,-2.30894,-16.4005,1\",\"occlusionMatrix\":\"0.97923,-0.156891,0.128435,0,0.122735,-0.0455304,-0.991399,0,0.161389,0.986565,-0.025327,0,-20.5227,-10.1083,2.79494,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.1.1.1.1\",\"referenceScanId\":\"e603f241-1dc4-11ef-8e10-d517f279883e\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-29 16:10:58.000','2024-05-29 15:05:52.000','2024-05-29 17:05:52.000'),('3febc366-1dc5-11ef-8e10-d517f279883e',15,'/var/iris/.data/2024/15/8eb8d841-1dc4-11ef-8e10-d517f279883e/session_97a4fb29-1dc4-11ef-8e10-d517f279883e/occlusion_97a7648b-1dc4-11ef-8e10-d517f279883e/computedocclusion_0ffde937-1dc5-11ef-8e10-d517f279883e/3febc366-1dc5-11ef-8e10-d517f279883e.png','PATIENT_8eb8d841-1dc4-11ef-8e10-d517f279883e_ACT_97a4fb29-1dc4-11ef-8e10-d517f279883e_SESS_97a7648b-1dc4-11ef-8e10-d517f279883e_OCC_0ffde937-1dc5-11ef-8e10-d517f279883e_SNAPO','3febc366-1dc5-11ef-8e10-d517f279883e.png','3febc366-1dc5-11ef-8e10-d517f279883e','{\"displayTitle\":\"Occlusion 1.1.1.1.1 Snapshot\",\"occlusionType\":1}','PNG',0,'SYNCED',0,NULL,'2024-05-29 16:10:59.000','2024-05-29 15:05:52.000','2024-05-29 17:05:52.000'),('401b4fc2-113d-11ef-8f8d-d92a44d56471',3,'/var/iris/.data/2024/3/4ce59675-1136-11ef-8f8d-d92a44d56471/session_233ae18e-113d-11ef-8f8d-d92a44d56471/order_233cdf71-113d-11ef-8f8d-d92a44d56471/401b4fc2-113d-11ef-8f8d-d92a44d56471.pdf','PATIENT_4ce59675-1136-11ef-8f8d-d92a44d56471_ACT_233ae18e-113d-11ef-8f8d-d92a44d56471_PROST_233cdf71-113d-11ef-8f8d-d92a44d56471_FORM','401b4fc2-113d-11ef-8f8d-d92a44d56471.pdf','401b4fc2-113d-11ef-8f8d-d92a44d56471','{\"displayTitle\":\"Commande 1.3.2.1 Autre\",\"title\":\"Autre\"}','PDF',0,'SYNCED',0,NULL,'2024-05-13 17:27:05.000','2024-05-13 15:27:05.000','2024-05-13 17:27:05.000'),('486e554c-0950-11ef-8f65-d9283bb1c6cd',6,'/var/iris/.data/2024/6/bbee50d8-094f-11ef-8f65-d9283bb1c6cd/session_7d7b190c-094f-11ef-8f65-d9283bb1c6cd/order_c0d437cd-094f-11ef-8f65-d9283bb1c6cd/486e554c-0950-11ef-8f65-d9283bb1c6cd.pdf','PATIENT_bbee50d8-094f-11ef-8f65-d9283bb1c6cd_ACT_7d7b190c-094f-11ef-8f65-d9283bb1c6cd_PROST_c0d437cd-094f-11ef-8f65-d9283bb1c6cd_FORM','486e554c-0950-11ef-8f65-d9283bb1c6cd.pdf','486e554c-0950-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Commande 1.1.1.1 Onlay\",\"title\":\"Onlay\"}','PDF',0,'SYNCED',0,NULL,'2024-05-03 15:23:09.542','2024-05-03 13:23:10.231','2024-05-03 15:23:10.339'),('491138ed-1dd2-11ef-8f99-d92a46e09137',15,'/var/iris/.data/2024/15/de66fe79-1dd1-11ef-8f99-d92a46e09137/session_3a94919f-1dd2-11ef-8f99-d92a46e09137/order_3a968bff-1dd2-11ef-8f99-d92a46e09137/491138ed-1dd2-11ef-8f99-d92a46e09137.pdf','PATIENT_de66fe79-1dd1-11ef-8f99-d92a46e09137_ACT_3a94919f-1dd2-11ef-8f99-d92a46e09137_PROST_3a968bff-1dd2-11ef-8f99-d92a46e09137_FORM','491138ed-1dd2-11ef-8f99-d92a46e09137.pdf','491138ed-1dd2-11ef-8f99-d92a46e09137','{\"displayTitle\":\"Commande 2.3.2.1 Facette\",\"title\":\"Facette\"}','PDF',0,'SYNCED',0,NULL,'2024-05-29 17:44:07.797','2024-05-29 15:44:08.519','2024-05-29 17:44:08.605'),('4aa2192e-0950-11ef-8ba8-6ec2958327c0',3,'/var/iris/.data/2024/3/discussion_3b2891c3-0950-11ef-8f65-d9283bb1c6cd/4aa2192e-0950-11ef-8ba8-6ec2958327c0.pdf','PATIENT_bbee50d8-094f-11ef-8f65-d9283bb1c6cd_ACT_7d7b190c-094f-11ef-8f65-d9283bb1c6cd_PROST_c0d437cd-094f-11ef-8f65-d9283bb1c6cd_FORM','486e554c-0950-11ef-8f65-d9283bb1c6cd.pdf','4aa2192e-0950-11ef-8ba8-6ec2958327c0','{\"displayTitle\":\"Commande 1.1.1.1 Onlay\",\"title\":\"Onlay\"}','PDF',0,'SYNCED',0,NULL,'2024-05-03 15:23:10.000','2024-05-03 13:23:10.000','2024-05-03 15:23:10.000'),('4aa40ab1-0950-11ef-8ba8-6ec2958327c0',3,'/var/iris/.data/2024/3/discussion_3b2891c3-0950-11ef-8f65-d9283bb1c6cd/4aa40ab1-0950-11ef-8ba8-6ec2958327c0.zip','PATIENT_bbee50d8-094f-11ef-8f65-d9283bb1c6cd_ACT_7d7b190c-094f-11ef-8f65-d9283bb1c6cd_SESS_7d7bdba5-094f-11ef-8f65-d9283bb1c6cd_TOSC_7e3b5074-094f-11ef-8f65-d9283bb1c6cd_MODEL','9935aa64-094f-11ef-8f65-d9283bb1c6cd.zip','4aa40ab1-0950-11ef-8ba8-6ec2958327c0','{\"displayTitle\":\"Maxillaire 1.1.1.1.1\",\"modelMatrix\":\"0.911721,-0.408329,0.045069,0,0.404868,0.911703,0.0698595,0,-0.0696153,-0.0454454,0.996538,0,-5.05468,2.73266,-18.4649,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-03 15:19:17.000','2024-05-03 13:19:17.000','2024-05-03 15:19:17.000'),('4aa45915-0950-11ef-8ba8-6ec2958327c0',3,'/var/iris/.data/2024/3/discussion_3b2891c3-0950-11ef-8f65-d9283bb1c6cd/4aa45915-0950-11ef-8ba8-6ec2958327c0.png','PATIENT_bbee50d8-094f-11ef-8f65-d9283bb1c6cd_ACT_7d7b190c-094f-11ef-8f65-d9283bb1c6cd_SESS_7d7bdba5-094f-11ef-8f65-d9283bb1c6cd_TOSC_7e3b5074-094f-11ef-8f65-d9283bb1c6cd_SNAPS','9935cedf-094f-11ef-8f65-d9283bb1c6cd.png','4aa45915-0950-11ef-8ba8-6ec2958327c0','{\"displayTitle\":\"Maxillaire 1.1.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-03 15:19:17.000','2024-05-03 13:19:17.000','2024-05-03 15:19:17.000'),('4b160442-1469-11ef-8f1b-d8242b6da0dc',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_419ce9d8-1469-11ef-8f1b-d8242b6da0dc/order_419edfb4-1469-11ef-8f1b-d8242b6da0dc/4b160442-1469-11ef-8f1b-d8242b6da0dc.pdf','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_419ce9d8-1469-11ef-8f1b-d8242b6da0dc_PROST_419edfb4-1469-11ef-8f1b-d8242b6da0dc_FORM','4b160442-1469-11ef-8f1b-d8242b6da0dc.pdf','4b160442-1469-11ef-8f1b-d8242b6da0dc','{\"displayTitle\":\"Commande 1.7.2.1 Autre\",\"title\":\"Autre\"}','PDF',0,'SYNCED',0,NULL,'2024-05-17 18:19:53.563','2024-05-17 16:19:54.261','2024-05-17 18:19:54.436'),('4d7752a0-086d-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_1fcf39f6-086d-11ef-8ff6-da2f5a35fe58/order_47d6e672-086d-11ef-8ff6-da2f5a35fe58/4d7752a0-086d-11ef-8ff6-da2f5a35fe58.pdf','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_1fcf39f6-086d-11ef-8ff6-da2f5a35fe58_PROST_47d6e672-086d-11ef-8ff6-da2f5a35fe58_FORM','4d7752a0-086d-11ef-8ff6-da2f5a35fe58.pdf','4d7752a0-086d-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Commande 1.1.5.1 Autre\",\"title\":\"Autre\"}','PDF',0,'SYNCED',0,NULL,'2024-05-02 12:18:21.589','2024-05-02 10:18:22.280','2024-05-02 12:18:22.449'),('53799350-1468-11ef-8f1b-d8242b6da0dc',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_f0721624-144c-11ef-8f1b-d8242b6da0dc/occlusion_f073b964-144c-11ef-8f1b-d8242b6da0dc/scan_a404f782-1466-11ef-8f1b-d8242b6da0dc/53799350-1468-11ef-8f1b-d8242b6da0dc.zip','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_f0721624-144c-11ef-8f1b-d8242b6da0dc_SESS_f073b964-144c-11ef-8f1b-d8242b6da0dc_TOSC_a404f782-1466-11ef-8f1b-d8242b6da0dc_MODEL','53799350-1468-11ef-8f1b-d8242b6da0dc.zip','ce611e03-1466-11ef-8f1b-d8242b6da0dc','{\"displayTitle\":\"Maxillaire 1.7.1.1.1\",\"modelMatrix\":\"-0.392288,-0.91905,-0.0381724,0,0.907911,-0.380204,-0.176476,0,0.147677,-0.103887,0.983565,0,18.0031,16.0987,-17.551,1\",\"scanBodies\":[]}','ZIP',2,'SYNCED',0,NULL,'2024-05-17 18:13:02.000','2024-05-17 16:13:02.000','2024-05-17 18:13:02.000'),('5379a891-1468-11ef-8f1b-d8242b6da0dc',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_f0721624-144c-11ef-8f1b-d8242b6da0dc/occlusion_f073b964-144c-11ef-8f1b-d8242b6da0dc/scan_a404f782-1466-11ef-8f1b-d8242b6da0dc/5379a891-1468-11ef-8f1b-d8242b6da0dc.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_f0721624-144c-11ef-8f1b-d8242b6da0dc_SESS_f073b964-144c-11ef-8f1b-d8242b6da0dc_TOSC_a404f782-1466-11ef-8f1b-d8242b6da0dc_SNAPS','5379a891-1468-11ef-8f1b-d8242b6da0dc.png','ce613798-1466-11ef-8f1b-d8242b6da0dc','{\"displayTitle\":\"Maxillaire 1.7.1.1.1 Snapshot\"}','PNG',2,'SYNCED',0,NULL,'2024-05-17 18:13:03.000','2024-05-17 16:13:03.000','2024-05-17 18:13:03.000'),('544fb565-1dcc-11ef-8e10-d517f279883e',15,'/var/iris/.data/2024/15/f6c1a0a8-1dc6-11ef-8e10-d517f279883e/session_1e9e9ed0-1dc7-11ef-8e10-d517f279883e/order_1ea2c192-1dc7-11ef-8e10-d517f279883e/544fb565-1dcc-11ef-8e10-d517f279883e.pdf','PATIENT_f6c1a0a8-1dc6-11ef-8e10-d517f279883e_ACT_1e9e9ed0-1dc7-11ef-8e10-d517f279883e_PROST_1ea2c192-1dc7-11ef-8e10-d517f279883e_FORM','544fb565-1dcc-11ef-8e10-d517f279883e.pdf','544fb565-1dcc-11ef-8e10-d517f279883e','{\"displayTitle\":\"Commande 1.2.1.1 Autre wf guidé\",\"title\":\"Autre wf guidé\"}','PDF',0,'SYNCED',0,NULL,'2024-05-29 17:01:30.000','2024-05-29 15:01:30.000','2024-05-29 17:01:30.000'),('550d8ad7-0943-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_33ac516e-0943-11ef-8f65-d9283bb1c6cd/occlusion_33ac9194-0943-11ef-8f65-d9283bb1c6cd/scan_35758d89-0943-11ef-8f65-d9283bb1c6cd/550d8ad7-0943-11ef-8f65-d9283bb1c6cd.zip','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_33ac516e-0943-11ef-8f65-d9283bb1c6cd_SESS_33ac9194-0943-11ef-8f65-d9283bb1c6cd_TOSC_35758d89-0943-11ef-8f65-d9283bb1c6cd_MODEL','550d8ad7-0943-11ef-8f65-d9283bb1c6cd.zip','550d8ad7-0943-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Maxillaire 1.2.1.1.1\",\"modelMatrix\":\"-0.977448,0.207426,-0.0396203,0,-0.206416,-0.898845,0.386613,0,0.0445811,0.386073,0.92139,0,6.0985,-7.02733,-18.0419,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-03 13:50:47.000','2024-05-03 11:50:47.000','2024-05-03 13:50:47.000'),('550da95b-0943-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_33ac516e-0943-11ef-8f65-d9283bb1c6cd/occlusion_33ac9194-0943-11ef-8f65-d9283bb1c6cd/scan_35758d89-0943-11ef-8f65-d9283bb1c6cd/550da95b-0943-11ef-8f65-d9283bb1c6cd.png','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_33ac516e-0943-11ef-8f65-d9283bb1c6cd_SESS_33ac9194-0943-11ef-8f65-d9283bb1c6cd_TOSC_35758d89-0943-11ef-8f65-d9283bb1c6cd_SNAPS','550da95b-0943-11ef-8f65-d9283bb1c6cd.png','550da95b-0943-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Maxillaire 1.2.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-03 13:50:47.000','2024-05-03 11:50:47.000','2024-05-03 13:50:47.000'),('560d23c3-11cf-11ef-8f95-d92a45dc80ec',3,'/var/iris/.data/2024/3/235a3115-11cf-11ef-8f95-d92a45dc80ec/session_2a532631-11cf-11ef-8f95-d92a45dc80ec/occlusion_2a54d83c-11cf-11ef-8f95-d92a45dc80ec/scan_2bf4c0e1-11cf-11ef-8f95-d92a45dc80ec/560d23c3-11cf-11ef-8f95-d92a45dc80ec.zip','PATIENT_235a3115-11cf-11ef-8f95-d92a45dc80ec_ACT_2a532631-11cf-11ef-8f95-d92a45dc80ec_SESS_2a54d83c-11cf-11ef-8f95-d92a45dc80ec_TOSC_2bf4c0e1-11cf-11ef-8f95-d92a45dc80ec_MODEL','560d23c3-11cf-11ef-8f95-d92a45dc80ec.zip','560d23c3-11cf-11ef-8f95-d92a45dc80ec','{\"displayTitle\":\"Maxillaire 1.4.1.1.1\",\"modelMatrix\":\"0.964589,0.254796,-0.0681657,0,-0.247147,0.782876,-0.570985,0,-0.0921194,0.567613,0.818126,0,-5.98858,-15.5975,-15.1159,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-14 10:52:50.000','2024-05-14 08:52:50.000','2024-05-14 10:52:50.000'),('560d402a-11cf-11ef-8f95-d92a45dc80ec',3,'/var/iris/.data/2024/3/235a3115-11cf-11ef-8f95-d92a45dc80ec/session_2a532631-11cf-11ef-8f95-d92a45dc80ec/occlusion_2a54d83c-11cf-11ef-8f95-d92a45dc80ec/scan_2bf4c0e1-11cf-11ef-8f95-d92a45dc80ec/560d402a-11cf-11ef-8f95-d92a45dc80ec.png','PATIENT_235a3115-11cf-11ef-8f95-d92a45dc80ec_ACT_2a532631-11cf-11ef-8f95-d92a45dc80ec_SESS_2a54d83c-11cf-11ef-8f95-d92a45dc80ec_TOSC_2bf4c0e1-11cf-11ef-8f95-d92a45dc80ec_SNAPS','560d402a-11cf-11ef-8f95-d92a45dc80ec.png','560d402a-11cf-11ef-8f95-d92a45dc80ec','{\"displayTitle\":\"Maxillaire 1.4.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-14 10:52:50.000','2024-05-14 08:52:50.000','2024-05-14 10:52:50.000'),('5664bcc6-1dcc-11ef-867c-6ec2958327c0',14,'/var/iris/.data/2024/14/discussion_6f667799-1dc9-11ef-8e10-d517f279883e/5664bcc6-1dcc-11ef-867c-6ec2958327c0.pdf','PATIENT_f6c1a0a8-1dc6-11ef-8e10-d517f279883e_ACT_1e9e9ed0-1dc7-11ef-8e10-d517f279883e_PROST_1ea2c192-1dc7-11ef-8e10-d517f279883e_FORM','544fb565-1dcc-11ef-8e10-d517f279883e.pdf','5664bcc6-1dcc-11ef-867c-6ec2958327c0','{\"displayTitle\":\"Commande 1.2.1.1 Autre wf guidé\",\"title\":\"Autre wf guidé\"}','PDF',0,'SYNCED',0,NULL,'2024-05-29 17:01:30.000','2024-05-29 15:01:30.000','2024-05-29 17:01:30.000'),('56651581-1dcc-11ef-867c-6ec2958327c0',14,'/var/iris/.data/2024/14/discussion_6f667799-1dc9-11ef-8e10-d517f279883e/56651581-1dcc-11ef-867c-6ec2958327c0.zip','PATIENT_f6c1a0a8-1dc6-11ef-8e10-d517f279883e_ACT_1e9e9ed0-1dc7-11ef-8e10-d517f279883e_SESS_1ea1743d-1dc7-11ef-8e10-d517f279883e_TOSC_39cdad43-1dc7-11ef-8e10-d517f279883e_MODEL','5f5cf463-1dc7-11ef-8e10-d517f279883e.zip','56651581-1dcc-11ef-867c-6ec2958327c0','{\"displayTitle\":\"Maxillaire 1.2.1.1.1\",\"modelMatrix\":\"-0.579686,-0.811189,-0.0770524,0,0.776002,-0.578428,0.251479,0,-0.248566,0.085986,0.964791,0,11.2565,11.2129,-17.4057,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-29 16:26:05.000','2024-05-29 14:26:05.000','2024-05-29 16:26:05.000'),('5665552b-1dcc-11ef-867c-6ec2958327c0',14,'/var/iris/.data/2024/14/discussion_6f667799-1dc9-11ef-8e10-d517f279883e/5665552b-1dcc-11ef-867c-6ec2958327c0.png','PATIENT_f6c1a0a8-1dc6-11ef-8e10-d517f279883e_ACT_1e9e9ed0-1dc7-11ef-8e10-d517f279883e_SESS_1ea1743d-1dc7-11ef-8e10-d517f279883e_TOSC_39cdad43-1dc7-11ef-8e10-d517f279883e_SNAPS','5f5d05e8-1dc7-11ef-8e10-d517f279883e.png','5665552b-1dcc-11ef-867c-6ec2958327c0','{\"displayTitle\":\"Maxillaire 1.2.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-29 16:26:06.000','2024-05-29 14:26:06.000','2024-05-29 16:26:06.000'),('5a21d0db-1467-11ef-8f1b-d8242b6da0dc',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_f0721624-144c-11ef-8f1b-d8242b6da0dc/occlusion_f073b964-144c-11ef-8f1b-d8242b6da0dc/scan_a404f782-1466-11ef-8f1b-d8242b6da0dc/5a21d0db-1467-11ef-8f1b-d8242b6da0dc.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_f0721624-144c-11ef-8f1b-d8242b6da0dc_SESS_f073b964-144c-11ef-8f1b-d8242b6da0dc_TOSC_a404f782-1466-11ef-8f1b-d8242b6da0dc_SCREENS','5a21d0db-1467-11ef-8f1b-d8242b6da0dc.png','5a21d0db-1467-11ef-8f1b-d8242b6da0dc','{\"displayTitle\":\"Maxillaire 1.7.1.1.1 Capture d\'écran 1\",\"title\":\"1\"}','PNG',0,'SYNCED',0,'2024-05-22 15:55:24.467','2024-05-22 15:55:24.467','2024-05-22 13:55:24.468','2024-05-22 15:55:24.470'),('5a776a40-1843-11ef-8f8e-d92a44d6667d',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_5748a11c-146a-11ef-8f1b-d8242b6da0dc/occlusion_574ac047-146a-11ef-8f1b-d8242b6da0dc/scan_ce02f919-146b-11ef-8f1b-d8242b6da0dc/5a776a40-1843-11ef-8f8e-d92a44d6667d.ply','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_5748a11c-146a-11ef-8f1b-d8242b6da0dc_SESS_574ac047-146a-11ef-8f1b-d8242b6da0dc_TOSC_ce02f919-146b-11ef-8f1b-d8242b6da0dc_SEG','5a776a40-1843-11ef-8f8e-d92a44d6667d.ply','5a776a40-1843-11ef-8f8e-d92a44d6667d','{\"displayTitle\":\"Maxillaire 1.7.3.1.1 Segmentation\"}','PLY',0,'SYNCED',0,NULL,'2024-05-22 15:58:23.142','2024-05-22 13:58:23.170','2024-05-22 15:58:23.421'),('5b39c854-176d-11ef-8f86-d92942cf49fd',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_b1ce9a22-1749-11ef-8f86-d92942cf49fd/occlusion_b1d043a8-1749-11ef-8f86-d92942cf49fd/computedocclusion_e3bf7a84-176c-11ef-8f86-d92942cf49fd/5b39c854-176d-11ef-8f86-d92942cf49fd.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_b1ce9a22-1749-11ef-8f86-d92942cf49fd_SESS_b1d043a8-1749-11ef-8f86-d92942cf49fd_OCC_e3bf7a84-176c-11ef-8f86-d92942cf49fd_SCREENO','5b39c854-176d-11ef-8f86-d92942cf49fd.png','5b39c854-176d-11ef-8f86-d92942cf49fd','{\"displayTitle\":\"Occlusion 1.7.6.1.1 Capture d\'écran 1\",\"occlusionType\":1,\"title\":\"1\"}','PNG',0,'SYNCED',0,NULL,'2024-05-21 14:26:32.116','2024-05-21 12:26:32.172','2024-05-21 14:26:32.244'),('5b90aefe-0951-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_4545f685-0951-11ef-8f65-d9283bb1c6cd/occlusion_45464b9d-0951-11ef-8f65-d9283bb1c6cd/scan_46acf99a-0951-11ef-8f65-d9283bb1c6cd/5b90aefe-0951-11ef-8f65-d9283bb1c6cd.zip','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_4545f685-0951-11ef-8f65-d9283bb1c6cd_SESS_45464b9d-0951-11ef-8f65-d9283bb1c6cd_TOSC_46acf99a-0951-11ef-8f65-d9283bb1c6cd_MODEL','5b90aefe-0951-11ef-8f65-d9283bb1c6cd.zip','5b90aefe-0951-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Maxillaire 1.2.3.1.1\",\"modelMatrix\":\"-0.995286,-0.096714,0.0072192,0,0.0907878,-0.902944,0.420059,0,-0.034107,0.418734,0.907468,0,6.67698,-2.76149,-17.6773,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-03 15:30:51.141','2024-05-03 13:31:31.184','2024-05-03 15:31:31.963'),('5b90bdc4-0951-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_4545f685-0951-11ef-8f65-d9283bb1c6cd/occlusion_45464b9d-0951-11ef-8f65-d9283bb1c6cd/scan_46acf99a-0951-11ef-8f65-d9283bb1c6cd/5b90bdc4-0951-11ef-8f65-d9283bb1c6cd.png','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_4545f685-0951-11ef-8f65-d9283bb1c6cd_SESS_45464b9d-0951-11ef-8f65-d9283bb1c6cd_TOSC_46acf99a-0951-11ef-8f65-d9283bb1c6cd_SNAPS','5b90bdc4-0951-11ef-8f65-d9283bb1c6cd.png','5b90bdc4-0951-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Maxillaire 1.2.3.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-03 15:30:51.141','2024-05-03 13:31:31.185','2024-05-03 15:31:34.255'),('5da650e1-1843-11ef-8f8e-d92a44d6667d',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_5748a11c-146a-11ef-8f1b-d8242b6da0dc/occlusion_574ac047-146a-11ef-8f1b-d8242b6da0dc/scan_ce02f919-146b-11ef-8f1b-d8242b6da0dc/5da650e1-1843-11ef-8f8e-d92a44d6667d.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_5748a11c-146a-11ef-8f1b-d8242b6da0dc_SESS_574ac047-146a-11ef-8f1b-d8242b6da0dc_TOSC_ce02f919-146b-11ef-8f1b-d8242b6da0dc_SCREENS','5da650e1-1843-11ef-8f8e-d92a44d6667d.png','5da650e1-1843-11ef-8f8e-d92a44d6667d','{\"displayTitle\":\"Maxillaire 1.7.3.1.1 Capture d\'écran 1\",\"title\":\"1\"}','PNG',0,'SYNCED',0,'2024-05-22 15:59:02.751','2024-05-22 15:59:02.752','2024-05-22 13:59:02.752','2024-05-22 15:59:02.754'),('5e5e77e4-176d-11ef-8f86-d92942cf49fd',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_b1ce9a22-1749-11ef-8f86-d92942cf49fd/occlusion_b1d043a8-1749-11ef-8f86-d92942cf49fd/computedocclusion_e3bf7a84-176c-11ef-8f86-d92942cf49fd/5e5e77e4-176d-11ef-8f86-d92942cf49fd.json','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_b1ce9a22-1749-11ef-8f86-d92942cf49fd_SESS_b1d043a8-1749-11ef-8f86-d92942cf49fd_OCC_e3bf7a84-176c-11ef-8f86-d92942cf49fd_METER','5e5e77e4-176d-11ef-8f86-d92942cf49fd.json','5e5e77e4-176d-11ef-8f86-d92942cf49fd','{\"displayTitle\":\"Occlusion 1.7.6.1.1 Mesure\",\"occlusionType\":1}','JSON',0,'SYNCED',0,NULL,'2024-05-21 14:26:37.389','2024-05-21 12:26:37.390','2024-05-21 14:26:37.523'),('5f5cf463-1dc7-11ef-8e10-d517f279883e',15,'/var/iris/.data/2024/15/f6c1a0a8-1dc6-11ef-8e10-d517f279883e/session_1e9e9ed0-1dc7-11ef-8e10-d517f279883e/occlusion_1ea1743d-1dc7-11ef-8e10-d517f279883e/scan_39cdad43-1dc7-11ef-8e10-d517f279883e/5f5cf463-1dc7-11ef-8e10-d517f279883e.zip','PATIENT_f6c1a0a8-1dc6-11ef-8e10-d517f279883e_ACT_1e9e9ed0-1dc7-11ef-8e10-d517f279883e_SESS_1ea1743d-1dc7-11ef-8e10-d517f279883e_TOSC_39cdad43-1dc7-11ef-8e10-d517f279883e_MODEL','5f5cf463-1dc7-11ef-8e10-d517f279883e.zip','5f5cf463-1dc7-11ef-8e10-d517f279883e','{\"displayTitle\":\"Maxillaire 1.2.1.1.1\",\"modelMatrix\":\"-0.579686,-0.811189,-0.0770524,0,0.776002,-0.578428,0.251479,0,-0.248566,0.085986,0.964791,0,11.2565,11.2129,-17.4057,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-29 16:26:05.000','2024-05-29 15:05:52.000','2024-05-29 17:05:52.000'),('5f5d05e8-1dc7-11ef-8e10-d517f279883e',15,'/var/iris/.data/2024/15/f6c1a0a8-1dc6-11ef-8e10-d517f279883e/session_1e9e9ed0-1dc7-11ef-8e10-d517f279883e/occlusion_1ea1743d-1dc7-11ef-8e10-d517f279883e/scan_39cdad43-1dc7-11ef-8e10-d517f279883e/5f5d05e8-1dc7-11ef-8e10-d517f279883e.png','PATIENT_f6c1a0a8-1dc6-11ef-8e10-d517f279883e_ACT_1e9e9ed0-1dc7-11ef-8e10-d517f279883e_SESS_1ea1743d-1dc7-11ef-8e10-d517f279883e_TOSC_39cdad43-1dc7-11ef-8e10-d517f279883e_SNAPS','5f5d05e8-1dc7-11ef-8e10-d517f279883e.png','5f5d05e8-1dc7-11ef-8e10-d517f279883e','{\"displayTitle\":\"Maxillaire 1.2.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-29 16:26:06.000','2024-05-29 15:05:53.000','2024-05-29 17:05:53.000'),('616d233f-113c-11ef-8f8d-d92a44d56471',3,'/var/iris/.data/2024/3/4ce59675-1136-11ef-8f8d-d92a44d56471/session_bcf58202-113b-11ef-8f8d-d92a44d56471/order_bcf78fbc-113b-11ef-8f8d-d92a44d56471/616d233f-113c-11ef-8f8d-d92a44d56471.pdf','PATIENT_4ce59675-1136-11ef-8f8d-d92a44d56471_ACT_bcf58202-113b-11ef-8f8d-d92a44d56471_PROST_bcf78fbc-113b-11ef-8f8d-d92a44d56471_FORM','616d233f-113c-11ef-8f8d-d92a44d56471.pdf','f3c05df6-113b-11ef-8f8d-d92a44d56471','{\"displayTitle\":\"Commande 1.3.1.1 Couronne\",\"title\":\"Couronne\"}','PDF',1,'SYNCED',0,NULL,'2024-05-13 17:20:51.000','2024-05-13 15:20:51.000','2024-05-13 17:20:51.000'),('621768a1-1843-11ef-8f8e-d92a44d6667d',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_5748a11c-146a-11ef-8f1b-d8242b6da0dc/occlusion_574ac047-146a-11ef-8f1b-d8242b6da0dc/scan_58c830be-146a-11ef-8f1b-d8242b6da0dc/621768a1-1843-11ef-8f8e-d92a44d6667d.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_5748a11c-146a-11ef-8f1b-d8242b6da0dc_SESS_574ac047-146a-11ef-8f1b-d8242b6da0dc_BOSC_58c830be-146a-11ef-8f1b-d8242b6da0dc_SCREENS','621768a1-1843-11ef-8f8e-d92a44d6667d.png','621768a1-1843-11ef-8f8e-d92a44d6667d','{\"displayTitle\":\"Mandibule 1.7.3.1.1 Capture d\'écran 1\",\"title\":\"1\"}','PNG',0,'SYNCED',0,'2024-05-22 15:59:00.994','2024-05-22 15:59:00.994','2024-05-22 13:59:00.994','2024-05-22 15:59:01.004'),('6b8bbed9-1843-11ef-8f8e-d92a44d6667d',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_5748a11c-146a-11ef-8f1b-d8242b6da0dc/occlusion_574ac047-146a-11ef-8f1b-d8242b6da0dc/computedocclusion_d34c3f5e-146c-11ef-8f1b-d8242b6da0dc/6b8bbed9-1843-11ef-8f8e-d92a44d6667d.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_5748a11c-146a-11ef-8f1b-d8242b6da0dc_SESS_574ac047-146a-11ef-8f1b-d8242b6da0dc_OCC_d34c3f5e-146c-11ef-8f1b-d8242b6da0dc_SCREENO','6b8bbed9-1843-11ef-8f8e-d92a44d6667d.png','6b8bbed9-1843-11ef-8f8e-d92a44d6667d','{\"displayTitle\":\"Occlusion 1.7.3.1.1 Capture d\'écran 1\",\"occlusionType\":2,\"title\":\"1\"}','PNG',0,'SYNCED',0,'2024-05-22 15:59:04.632','2024-05-22 15:59:04.632','2024-05-22 13:59:04.632','2024-05-22 15:59:04.642'),('6c00823f-146b-11ef-8f1b-d8242b6da0dc',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_5748a11c-146a-11ef-8f1b-d8242b6da0dc/occlusion_574ac047-146a-11ef-8f1b-d8242b6da0dc/scan_6c005b92-146b-11ef-8f1b-d8242b6da0dc/6c00823f-146b-11ef-8f1b-d8242b6da0dc.zip','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_5748a11c-146a-11ef-8f1b-d8242b6da0dc_SESS_574ac047-146a-11ef-8f1b-d8242b6da0dc_BOSC_6c005b92-146b-11ef-8f1b-d8242b6da0dc_MODEL','6c00823f-146b-11ef-8f1b-d8242b6da0dc.zip','6c00823f-146b-11ef-8f1b-d8242b6da0dc','{\"displayTitle\":\"Mandibule 1.7.3.1.2\",\"modelMatrix\":\"0.836198,-0.506888,0.209375,0,0.548008,0.757334,-0.355151,0,0.021455,0.411716,0.91106,0,-17.4555,-6.11927,-18.4232,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-17 18:35:07.780','2024-05-17 16:35:08.487','2024-05-17 18:35:08.649'),('6c0694b6-146b-11ef-8f1b-d8242b6da0dc',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_5748a11c-146a-11ef-8f1b-d8242b6da0dc/occlusion_574ac047-146a-11ef-8f1b-d8242b6da0dc/scan_6c005b92-146b-11ef-8f1b-d8242b6da0dc/6c0694b6-146b-11ef-8f1b-d8242b6da0dc.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_5748a11c-146a-11ef-8f1b-d8242b6da0dc_SESS_574ac047-146a-11ef-8f1b-d8242b6da0dc_BOSC_6c005b92-146b-11ef-8f1b-d8242b6da0dc_SNAPS','6c0694b6-146b-11ef-8f1b-d8242b6da0dc.png','6c0694b6-146b-11ef-8f1b-d8242b6da0dc','{\"displayTitle\":\"Mandibule 1.7.3.1.2 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-17 18:35:07.820','2024-05-17 16:35:08.489','2024-05-17 18:35:10.786'),('6d5ff7a6-0864-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_405b06bd-0864-11ef-8ff6-da2f5a35fe58/6d5ff7a6-0864-11ef-8ff6-da2f5a35fe58.zip','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_LESC_405b06bd-0864-11ef-8ff6-da2f5a35fe58_MODEL','6d5ff7a6-0864-11ef-8ff6-da2f5a35fe58.zip','6d5ff7a6-0864-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Mordu gauche 1.1.2.1.1\",\"modelMatrix\":\"-0.975871,0.17345,0.131192,0,-0.187345,-0.975638,-0.115734,0,0.11224,-0.134382,0.984593,0,16.4421,3.20587,-18.8052,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-02 11:14:49.653','2024-05-02 09:14:49.969','2024-05-02 11:16:08.216'),('6d60184b-0864-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_405b06bd-0864-11ef-8ff6-da2f5a35fe58/6d60184b-0864-11ef-8ff6-da2f5a35fe58.png','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_LESC_405b06bd-0864-11ef-8ff6-da2f5a35fe58_SNAPS','6d60184b-0864-11ef-8ff6-da2f5a35fe58.png','6d60184b-0864-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Mordu gauche 1.1.2.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-02 11:14:49.654','2024-05-02 09:14:49.979','2024-05-02 11:16:09.333'),('6db19776-0950-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_6daf4255-0950-11ef-8f65-d9283bb1c6cd/occlusion_6db0c544-0950-11ef-8f65-d9283bb1c6cd/scan_6db1877c-0950-11ef-8f65-d9283bb1c6cd/6db19776-0950-11ef-8f65-d9283bb1c6cd.zip','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_6daf4255-0950-11ef-8f65-d9283bb1c6cd_SESS_6db0c544-0950-11ef-8f65-d9283bb1c6cd_TOSC_6db1877c-0950-11ef-8f65-d9283bb1c6cd_MODEL','6db19776-0950-11ef-8f65-d9283bb1c6cd.zip','6db19776-0950-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Maxillaire 1.2.2.1.1\",\"modelMatrix\":\"0.911721,-0.408329,0.045069,0,0.404868,0.911703,0.0698595,0,-0.0696153,-0.0454454,0.996538,0,-5.05468,2.73266,-18.4649,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-03 15:24:12.059','2024-05-03 13:24:12.095','2024-05-03 15:24:13.245'),('6db6e19d-0950-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_6daf4255-0950-11ef-8f65-d9283bb1c6cd/occlusion_6db0c544-0950-11ef-8f65-d9283bb1c6cd/scan_6db1877c-0950-11ef-8f65-d9283bb1c6cd/6db6e19d-0950-11ef-8f65-d9283bb1c6cd.png','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_6daf4255-0950-11ef-8f65-d9283bb1c6cd_SESS_6db0c544-0950-11ef-8f65-d9283bb1c6cd_TOSC_6db1877c-0950-11ef-8f65-d9283bb1c6cd_SNAPS','6db6e19d-0950-11ef-8f65-d9283bb1c6cd.png','6db6e19d-0950-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Maxillaire 1.2.2.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-03 15:24:12.093','2024-05-03 13:24:12.096','2024-05-03 15:24:15.087'),('6ef5ef7b-1dc9-11ef-8e10-d517f279883e',15,'/var/iris/.data/2024/15/8eb8d841-1dc4-11ef-8e10-d517f279883e/session_97a4fb29-1dc4-11ef-8e10-d517f279883e/order_97a8960f-1dc4-11ef-8e10-d517f279883e/6ef5ef7b-1dc9-11ef-8e10-d517f279883e.pdf','PATIENT_8eb8d841-1dc4-11ef-8e10-d517f279883e_ACT_97a4fb29-1dc4-11ef-8e10-d517f279883e_PROST_97a8960f-1dc4-11ef-8e10-d517f279883e_FORM','6ef5ef7b-1dc9-11ef-8e10-d517f279883e.pdf','6ef5ef7b-1dc9-11ef-8e10-d517f279883e','{\"displayTitle\":\"Commande 1.1.1.1 Couronne wf libre\",\"title\":\"Couronne wf libre\"}','PDF',0,'SYNCED',0,NULL,'2024-05-29 16:40:47.000','2024-05-29 15:05:53.000','2024-05-29 17:05:53.000'),('703520a2-0952-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_4fc2347a-0952-11ef-8f65-d9283bb1c6cd/occlusion_4fc3d0e6-0952-11ef-8f65-d9283bb1c6cd/scan_53557eda-0952-11ef-8f65-d9283bb1c6cd/703520a2-0952-11ef-8f65-d9283bb1c6cd.zip','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_4fc2347a-0952-11ef-8f65-d9283bb1c6cd_SESS_4fc3d0e6-0952-11ef-8f65-d9283bb1c6cd_TOSC_53557eda-0952-11ef-8f65-d9283bb1c6cd_MODEL','703520a2-0952-11ef-8f65-d9283bb1c6cd.zip','703520a2-0952-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Maxillaire 1.2.6.1.1\",\"modelMatrix\":\"0.774981,0.631095,0.033522,0,-0.62835,0.77512,-0.0660793,0,-0.0676859,0.0301467,0.997251,0,-4.63707,-4.79452,-18.5136,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-03 15:38:35.270','2024-05-03 13:38:35.537','2024-05-03 15:38:38.436'),('70352ec8-0952-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_4fc2347a-0952-11ef-8f65-d9283bb1c6cd/occlusion_4fc3d0e6-0952-11ef-8f65-d9283bb1c6cd/scan_53557eda-0952-11ef-8f65-d9283bb1c6cd/70352ec8-0952-11ef-8f65-d9283bb1c6cd.png','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_4fc2347a-0952-11ef-8f65-d9283bb1c6cd_SESS_4fc3d0e6-0952-11ef-8f65-d9283bb1c6cd_TOSC_53557eda-0952-11ef-8f65-d9283bb1c6cd_SNAPS','70352ec8-0952-11ef-8f65-d9283bb1c6cd.png','70352ec8-0952-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Maxillaire 1.2.6.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-03 15:38:35.270','2024-05-03 13:38:35.537','2024-05-03 15:38:40.525'),('7047b842-176d-11ef-8f86-d92942cf49fd',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_b1ce9a22-1749-11ef-8f86-d92942cf49fd/occlusion_b1d043a8-1749-11ef-8f86-d92942cf49fd/scan_b2fd8f6c-1749-11ef-8f86-d92942cf49fd/7047b842-176d-11ef-8f86-d92942cf49fd.xyz','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_b1ce9a22-1749-11ef-8f86-d92942cf49fd_SESS_b1d043a8-1749-11ef-8f86-d92942cf49fd_TOSC_b2fd8f6c-1749-11ef-8f86-d92942cf49fd_LIFI','7047b842-176d-11ef-8f86-d92942cf49fd.xyz','7047b842-176d-11ef-8f86-d92942cf49fd','{\"displayTitle\":\"Maxillaire 1.7.6.1.1 Ligne de finition 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-05-21 14:27:07.439','2024-05-21 12:27:07.442','2024-05-21 14:27:07.562'),('7047bd17-176d-11ef-8f86-d92942cf49fd',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_b1ce9a22-1749-11ef-8f86-d92942cf49fd/occlusion_b1d043a8-1749-11ef-8f86-d92942cf49fd/scan_b2fd8f6c-1749-11ef-8f86-d92942cf49fd/7047bd17-176d-11ef-8f86-d92942cf49fd.bin','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_b1ce9a22-1749-11ef-8f86-d92942cf49fd_SESS_b1d043a8-1749-11ef-8f86-d92942cf49fd_TOSC_b2fd8f6c-1749-11ef-8f86-d92942cf49fd_LIFIM','7047bd17-176d-11ef-8f86-d92942cf49fd.bin','7047bd17-176d-11ef-8f86-d92942cf49fd','{\"displayTitle\":\"Maxillaire 1.7.6.1.1 Ligne de finition métadonnées 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-05-21 14:27:07.439','2024-05-21 12:27:07.453','2024-05-21 14:27:07.665'),('704be2c2-176d-11ef-8f86-d92942cf49fd',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_b1ce9a22-1749-11ef-8f86-d92942cf49fd/occlusion_b1d043a8-1749-11ef-8f86-d92942cf49fd/computedocclusion_e3bf7a84-176c-11ef-8f86-d92942cf49fd/704be2c2-176d-11ef-8f86-d92942cf49fd.xyz','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_b1ce9a22-1749-11ef-8f86-d92942cf49fd_SESS_b1d043a8-1749-11ef-8f86-d92942cf49fd_OCC_e3bf7a84-176c-11ef-8f86-d92942cf49fd_LIFIO','704be2c2-176d-11ef-8f86-d92942cf49fd.xyz','704be2c2-176d-11ef-8f86-d92942cf49fd','{\"displayTitle\":\"Occlusion 1.7.6.1.1 Ligne de finition Maxillaire 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY\",\"referenceScanId\":\"b2fd8f6c-1749-11ef-8f86-d92942cf49fd\",\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-05-21 14:27:07.467','2024-05-21 12:27:07.469','2024-05-21 14:27:07.805'),('704be63e-176d-11ef-8f86-d92942cf49fd',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_b1ce9a22-1749-11ef-8f86-d92942cf49fd/occlusion_b1d043a8-1749-11ef-8f86-d92942cf49fd/computedocclusion_e3bf7a84-176c-11ef-8f86-d92942cf49fd/704be63e-176d-11ef-8f86-d92942cf49fd.bin','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_b1ce9a22-1749-11ef-8f86-d92942cf49fd_SESS_b1d043a8-1749-11ef-8f86-d92942cf49fd_OCC_e3bf7a84-176c-11ef-8f86-d92942cf49fd_LIFIMO','704be63e-176d-11ef-8f86-d92942cf49fd.bin','704be63e-176d-11ef-8f86-d92942cf49fd','{\"displayTitle\":\"Occlusion 1.7.6.1.1 Ligne de finition métadonnées Maxillaire 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY\",\"referenceScanId\":\"b2fd8f6c-1749-11ef-8f86-d92942cf49fd\",\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-05-21 14:27:07.467','2024-05-21 12:27:07.469','2024-05-21 14:27:07.881'),('714f63b2-06ed-11ef-90c8-dd3986f53a42',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_4dd3e575-06ed-11ef-90c8-dd3986f53a42/occlusion_4dd586c4-06ed-11ef-90c8-dd3986f53a42/scan_57229e01-06ed-11ef-90c8-dd3986f53a42/714f63b2-06ed-11ef-90c8-dd3986f53a42.zip','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_4dd3e575-06ed-11ef-90c8-dd3986f53a42_SESS_4dd586c4-06ed-11ef-90c8-dd3986f53a42_TOSC_57229e01-06ed-11ef-90c8-dd3986f53a42_MODEL','714f63b2-06ed-11ef-90c8-dd3986f53a42.zip','714f63b2-06ed-11ef-90c8-dd3986f53a42','{\"displayTitle\":\"Maxillaire 1.1.1.1.1\",\"modelMatrix\":\"0.966616,0.255909,-0.0128421,0,-0.251929,0.940047,-0.229878,0,-0.0467557,0.225439,0.973135,0,-9.10706,-9.44021,-28.2552,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-04-30 14:30:39.000','2024-04-30 12:30:39.000','2024-04-30 14:30:39.000'),('714f73d7-06ed-11ef-90c8-dd3986f53a42',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_4dd3e575-06ed-11ef-90c8-dd3986f53a42/occlusion_4dd586c4-06ed-11ef-90c8-dd3986f53a42/scan_57229e01-06ed-11ef-90c8-dd3986f53a42/714f73d7-06ed-11ef-90c8-dd3986f53a42.png','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_4dd3e575-06ed-11ef-90c8-dd3986f53a42_SESS_4dd586c4-06ed-11ef-90c8-dd3986f53a42_TOSC_57229e01-06ed-11ef-90c8-dd3986f53a42_SNAPS','714f73d7-06ed-11ef-90c8-dd3986f53a42.png','714f73d7-06ed-11ef-90c8-dd3986f53a42','{\"displayTitle\":\"Maxillaire 1.1.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-04-30 14:30:39.000','2024-04-30 12:30:39.000','2024-04-30 14:30:39.000'),('71c14042-1dc9-11ef-867c-6ec2958327c0',14,'/var/iris/.data/2024/14/discussion_6f667799-1dc9-11ef-8e10-d517f279883e/71c14042-1dc9-11ef-867c-6ec2958327c0.zip','PATIENT_8eb8d841-1dc4-11ef-8e10-d517f279883e_ACT_97a4fb29-1dc4-11ef-8e10-d517f279883e_SESS_97a7648b-1dc4-11ef-8e10-d517f279883e_BOSC_e603f241-1dc4-11ef-8e10-d517f279883e_MODEL','000494bd-1dc5-11ef-8e10-d517f279883e.zip','71c14042-1dc9-11ef-867c-6ec2958327c0','{\"displayTitle\":\"Mandibule 1.1.1.1.1\",\"modelMatrix\":\"0.989354,-0.138659,-0.0441867,0,0.138295,0.990328,-0.0112196,0,0.045315,0.00498938,0.99896,0,-17.3085,-2.30894,-16.4005,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-29 16:09:09.000','2024-05-29 14:09:09.000','2024-05-29 16:09:09.000'),('71c7d691-1dc9-11ef-867c-6ec2958327c0',14,'/var/iris/.data/2024/14/discussion_6f667799-1dc9-11ef-8e10-d517f279883e/71c7d691-1dc9-11ef-867c-6ec2958327c0.png','PATIENT_8eb8d841-1dc4-11ef-8e10-d517f279883e_ACT_97a4fb29-1dc4-11ef-8e10-d517f279883e_SESS_97a7648b-1dc4-11ef-8e10-d517f279883e_BOSC_e603f241-1dc4-11ef-8e10-d517f279883e_SNAPS','0004a3c1-1dc5-11ef-8e10-d517f279883e.png','71c7d691-1dc9-11ef-867c-6ec2958327c0','{\"displayTitle\":\"Mandibule 1.1.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-29 16:09:10.000','2024-05-29 14:09:10.000','2024-05-29 16:09:10.000'),('71c816ee-1dc9-11ef-867c-6ec2958327c0',14,'/var/iris/.data/2024/14/discussion_6f667799-1dc9-11ef-8e10-d517f279883e/71c816ee-1dc9-11ef-867c-6ec2958327c0.zip','PATIENT_8eb8d841-1dc4-11ef-8e10-d517f279883e_ACT_97a4fb29-1dc4-11ef-8e10-d517f279883e_SESS_97a7648b-1dc4-11ef-8e10-d517f279883e_OCC_0ffde937-1dc5-11ef-8e10-d517f279883e_TOPLY','3f572760-1dc5-11ef-8e10-d517f279883e.zip','71c816ee-1dc9-11ef-867c-6ec2958327c0','{\"displayTitle\":\"Occlusion 1.1.1.1.1 Maxillaire\",\"modelMatrix\":\"0.979412,0.193087,-0.0588964,0,-0.185851,0.748568,-0.636479,0,-0.0788078,0.634321,0.769042,0,-18.6321,-11.2556,-10.2485,1\",\"occlusionMatrix\":\"0.996872,-0.0756274,-0.0231404,0,0.0296807,0.0865358,0.995805,0,-0.0733074,-0.993376,0.088508,0,-17.2672,10.7574,0.804369,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.1.1.1.1\",\"referenceScanId\":\"a6dfd269-1dc4-11ef-8e10-d517f279883e\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-29 16:10:54.000','2024-05-29 14:10:54.000','2024-05-29 16:10:54.000'),('71c85c3d-1dc9-11ef-867c-6ec2958327c0',14,'/var/iris/.data/2024/14/discussion_6f667799-1dc9-11ef-8e10-d517f279883e/71c85c3d-1dc9-11ef-867c-6ec2958327c0.zip','PATIENT_8eb8d841-1dc4-11ef-8e10-d517f279883e_ACT_97a4fb29-1dc4-11ef-8e10-d517f279883e_SESS_97a7648b-1dc4-11ef-8e10-d517f279883e_OCC_0ffde937-1dc5-11ef-8e10-d517f279883e_BOPLY','3f7139f8-1dc5-11ef-8e10-d517f279883e.zip','71c85c3d-1dc9-11ef-867c-6ec2958327c0','{\"displayTitle\":\"Occlusion 1.1.1.1.1 Mandibule\",\"modelMatrix\":\"0.989354,-0.138659,-0.0441867,0,0.138295,0.990328,-0.0112196,0,0.045315,0.00498938,0.99896,0,-17.3085,-2.30894,-16.4005,1\",\"occlusionMatrix\":\"0.97923,-0.156891,0.128435,0,0.122735,-0.0455304,-0.991399,0,0.161389,0.986565,-0.025327,0,-20.5227,-10.1083,2.79494,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.1.1.1.1\",\"referenceScanId\":\"e603f241-1dc4-11ef-8e10-d517f279883e\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-29 16:10:58.000','2024-05-29 14:10:58.000','2024-05-29 16:10:58.000'),('71c8a6d0-1dc9-11ef-867c-6ec2958327c0',14,'/var/iris/.data/2024/14/discussion_6f667799-1dc9-11ef-8e10-d517f279883e/71c8a6d0-1dc9-11ef-867c-6ec2958327c0.png','PATIENT_8eb8d841-1dc4-11ef-8e10-d517f279883e_ACT_97a4fb29-1dc4-11ef-8e10-d517f279883e_SESS_97a7648b-1dc4-11ef-8e10-d517f279883e_OCC_0ffde937-1dc5-11ef-8e10-d517f279883e_SNAPO','3febc366-1dc5-11ef-8e10-d517f279883e.png','71c8a6d0-1dc9-11ef-867c-6ec2958327c0','{\"displayTitle\":\"Occlusion 1.1.1.1.1 Snapshot\",\"occlusionType\":1}','PNG',0,'SYNCED',0,NULL,'2024-05-29 16:10:59.000','2024-05-29 14:10:59.000','2024-05-29 16:10:59.000'),('71c8fa31-1dc9-11ef-867c-6ec2958327c0',14,'/var/iris/.data/2024/14/discussion_6f667799-1dc9-11ef-8e10-d517f279883e/71c8fa31-1dc9-11ef-867c-6ec2958327c0.pdf','PATIENT_8eb8d841-1dc4-11ef-8e10-d517f279883e_ACT_97a4fb29-1dc4-11ef-8e10-d517f279883e_PROST_97a8960f-1dc4-11ef-8e10-d517f279883e_FORM','6ef5ef7b-1dc9-11ef-8e10-d517f279883e.pdf','71c8fa31-1dc9-11ef-867c-6ec2958327c0','{\"displayTitle\":\"Commande 1.1.1.1 Couronne wf libre\",\"title\":\"Couronne wf libre\"}','PDF',0,'SYNCED',0,NULL,'2024-05-29 16:40:47.000','2024-05-29 14:40:47.000','2024-05-29 16:40:47.000'),('71cb8f69-1dc9-11ef-867c-6ec2958327c0',14,'/var/iris/.data/2024/14/discussion_6f667799-1dc9-11ef-8e10-d517f279883e/71cb8f69-1dc9-11ef-867c-6ec2958327c0.zip','PATIENT_8eb8d841-1dc4-11ef-8e10-d517f279883e_ACT_97a4fb29-1dc4-11ef-8e10-d517f279883e_SESS_97a7648b-1dc4-11ef-8e10-d517f279883e_TOSC_a6dfd269-1dc4-11ef-8e10-d517f279883e_MODEL','e3f49fd8-1dc4-11ef-8e10-d517f279883e.zip','71cb8f69-1dc9-11ef-867c-6ec2958327c0','{\"displayTitle\":\"Maxillaire 1.1.1.1.1\",\"modelMatrix\":\"0.979412,0.193087,-0.0588964,0,-0.185851,0.748568,-0.636479,0,-0.0788078,0.634321,0.769042,0,-18.6321,-11.2556,-10.2485,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-29 16:09:06.000','2024-05-29 14:09:06.000','2024-05-29 16:09:06.000'),('71cbdcc5-1dc9-11ef-867c-6ec2958327c0',14,'/var/iris/.data/2024/14/discussion_6f667799-1dc9-11ef-8e10-d517f279883e/71cbdcc5-1dc9-11ef-867c-6ec2958327c0.png','PATIENT_8eb8d841-1dc4-11ef-8e10-d517f279883e_ACT_97a4fb29-1dc4-11ef-8e10-d517f279883e_SESS_97a7648b-1dc4-11ef-8e10-d517f279883e_TOSC_a6dfd269-1dc4-11ef-8e10-d517f279883e_SNAPS','e3f5f8d4-1dc4-11ef-8e10-d517f279883e.png','71cbdcc5-1dc9-11ef-867c-6ec2958327c0','{\"displayTitle\":\"Maxillaire 1.1.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-29 16:09:07.000','2024-05-29 14:09:07.000','2024-05-29 16:09:07.000'),('78e0c630-176d-11ef-8f86-d92942cf49fd',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_b1ce9a22-1749-11ef-8f86-d92942cf49fd/occlusion_b1d043a8-1749-11ef-8f86-d92942cf49fd/scan_b2fd8f6c-1749-11ef-8f86-d92942cf49fd/78e0c630-176d-11ef-8f86-d92942cf49fd.xyz','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_b1ce9a22-1749-11ef-8f86-d92942cf49fd_SESS_b1d043a8-1749-11ef-8f86-d92942cf49fd_TOSC_b2fd8f6c-1749-11ef-8f86-d92942cf49fd_LIFI','78e0c630-176d-11ef-8f86-d92942cf49fd.xyz','7047b842-176d-11ef-8f86-d92942cf49fd','{\"displayTitle\":\"Maxillaire 1.7.6.1.1 Ligne de finition 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',1,'SYNCED',0,NULL,'2024-05-21 14:27:21.864','2024-05-21 12:27:21.867','2024-05-21 14:27:21.941'),('78e0cc57-176d-11ef-8f86-d92942cf49fd',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_b1ce9a22-1749-11ef-8f86-d92942cf49fd/occlusion_b1d043a8-1749-11ef-8f86-d92942cf49fd/scan_b2fd8f6c-1749-11ef-8f86-d92942cf49fd/78e0cc57-176d-11ef-8f86-d92942cf49fd.bin','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_b1ce9a22-1749-11ef-8f86-d92942cf49fd_SESS_b1d043a8-1749-11ef-8f86-d92942cf49fd_TOSC_b2fd8f6c-1749-11ef-8f86-d92942cf49fd_LIFIM','78e0cc57-176d-11ef-8f86-d92942cf49fd.bin','7047bd17-176d-11ef-8f86-d92942cf49fd','{\"displayTitle\":\"Maxillaire 1.7.6.1.1 Ligne de finition métadonnées 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',1,'SYNCED',0,NULL,'2024-05-21 14:27:21.864','2024-05-21 12:27:21.876','2024-05-21 14:27:21.976'),('78e4d99e-176d-11ef-8f86-d92942cf49fd',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_b1ce9a22-1749-11ef-8f86-d92942cf49fd/occlusion_b1d043a8-1749-11ef-8f86-d92942cf49fd/computedocclusion_e3bf7a84-176c-11ef-8f86-d92942cf49fd/78e4d99e-176d-11ef-8f86-d92942cf49fd.xyz','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_b1ce9a22-1749-11ef-8f86-d92942cf49fd_SESS_b1d043a8-1749-11ef-8f86-d92942cf49fd_OCC_e3bf7a84-176c-11ef-8f86-d92942cf49fd_LIFIO','78e4d99e-176d-11ef-8f86-d92942cf49fd.xyz','704be2c2-176d-11ef-8f86-d92942cf49fd','{\"displayTitle\":\"Occlusion 1.7.6.1.1 Ligne de finition Maxillaire 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY\",\"referenceScanId\":\"b2fd8f6c-1749-11ef-8f86-d92942cf49fd\",\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',1,'SYNCED',0,NULL,'2024-05-21 14:27:21.891','2024-05-21 12:27:21.894','2024-05-21 14:27:22.074'),('78e4dd56-176d-11ef-8f86-d92942cf49fd',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_b1ce9a22-1749-11ef-8f86-d92942cf49fd/occlusion_b1d043a8-1749-11ef-8f86-d92942cf49fd/computedocclusion_e3bf7a84-176c-11ef-8f86-d92942cf49fd/78e4dd56-176d-11ef-8f86-d92942cf49fd.bin','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_b1ce9a22-1749-11ef-8f86-d92942cf49fd_SESS_b1d043a8-1749-11ef-8f86-d92942cf49fd_OCC_e3bf7a84-176c-11ef-8f86-d92942cf49fd_LIFIMO','78e4dd56-176d-11ef-8f86-d92942cf49fd.bin','704be63e-176d-11ef-8f86-d92942cf49fd','{\"displayTitle\":\"Occlusion 1.7.6.1.1 Ligne de finition métadonnées Maxillaire 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY\",\"referenceScanId\":\"b2fd8f6c-1749-11ef-8f86-d92942cf49fd\",\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',1,'SYNCED',0,NULL,'2024-05-21 14:27:21.891','2024-05-21 12:27:21.894','2024-05-21 14:27:22.122'),('796f7da8-1843-11ef-8f8e-d92a44d6667d',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_5748a11c-146a-11ef-8f1b-d8242b6da0dc/occlusion_574ac047-146a-11ef-8f1b-d8242b6da0dc/scan_58c830be-146a-11ef-8f1b-d8242b6da0dc/796f7da8-1843-11ef-8f8e-d92a44d6667d.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_5748a11c-146a-11ef-8f1b-d8242b6da0dc_SESS_574ac047-146a-11ef-8f1b-d8242b6da0dc_BOSC_58c830be-146a-11ef-8f1b-d8242b6da0dc_SCREENS','796f7da8-1843-11ef-8f8e-d92a44d6667d.png','796f7da8-1843-11ef-8f8e-d92a44d6667d','{\"displayTitle\":\"Mandibule 1.7.3.1.1 Capture d\'écran 1\",\"title\":\"1\"}','PNG',0,'SYNCED',0,'2024-05-22 15:59:29.440','2024-05-22 15:59:29.440','2024-05-22 13:59:29.440','2024-05-22 15:59:29.450'),('79d18196-146a-11ef-8f1b-d8242b6da0dc',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_5748a11c-146a-11ef-8f1b-d8242b6da0dc/occlusion_574ac047-146a-11ef-8f1b-d8242b6da0dc/scan_58c830be-146a-11ef-8f1b-d8242b6da0dc/79d18196-146a-11ef-8f1b-d8242b6da0dc.zip','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_5748a11c-146a-11ef-8f1b-d8242b6da0dc_SESS_574ac047-146a-11ef-8f1b-d8242b6da0dc_BOSC_58c830be-146a-11ef-8f1b-d8242b6da0dc_MODEL','79d18196-146a-11ef-8f1b-d8242b6da0dc.zip','79d18196-146a-11ef-8f1b-d8242b6da0dc','{\"displayTitle\":\"Mandibule 1.7.3.1.1\",\"modelMatrix\":\"0.836198,-0.506888,0.209375,0,0.548008,0.757334,-0.355151,0,0.021455,0.411716,0.91106,0,-17.4555,-6.11927,-18.4232,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-17 18:28:21.463','2024-05-17 16:28:21.757','2024-05-17 18:28:23.405'),('79d19082-146a-11ef-8f1b-d8242b6da0dc',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_5748a11c-146a-11ef-8f1b-d8242b6da0dc/occlusion_574ac047-146a-11ef-8f1b-d8242b6da0dc/scan_58c830be-146a-11ef-8f1b-d8242b6da0dc/79d19082-146a-11ef-8f1b-d8242b6da0dc.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_5748a11c-146a-11ef-8f1b-d8242b6da0dc_SESS_574ac047-146a-11ef-8f1b-d8242b6da0dc_BOSC_58c830be-146a-11ef-8f1b-d8242b6da0dc_SNAPS','79d19082-146a-11ef-8f1b-d8242b6da0dc.png','79d19082-146a-11ef-8f1b-d8242b6da0dc','{\"displayTitle\":\"Mandibule 1.7.3.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-17 18:28:21.464','2024-05-17 16:28:21.758','2024-05-17 18:28:23.977'),('7cfb78fe-1467-11ef-8f1b-d8242b6da0dc',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_f0721624-144c-11ef-8f1b-d8242b6da0dc/occlusion_f073b964-144c-11ef-8f1b-d8242b6da0dc/scan_a404f782-1466-11ef-8f1b-d8242b6da0dc/7cfb78fe-1467-11ef-8f1b-d8242b6da0dc.xyz','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_f0721624-144c-11ef-8f1b-d8242b6da0dc_SESS_f073b964-144c-11ef-8f1b-d8242b6da0dc_TOSC_a404f782-1466-11ef-8f1b-d8242b6da0dc_LIFI','7cfb78fe-1467-11ef-8f1b-d8242b6da0dc.xyz','7cfb78fe-1467-11ef-8f1b-d8242b6da0dc','{\"displayTitle\":\"Maxillaire 1.7.1.1.1 Ligne de finition 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,'2024-05-17 18:09:59.000','2024-05-17 18:06:58.000','2024-05-17 16:09:59.000','2024-05-17 18:09:59.000'),('7cfb7be6-1467-11ef-8f1b-d8242b6da0dc',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_f0721624-144c-11ef-8f1b-d8242b6da0dc/occlusion_f073b964-144c-11ef-8f1b-d8242b6da0dc/scan_a404f782-1466-11ef-8f1b-d8242b6da0dc/7cfb7be6-1467-11ef-8f1b-d8242b6da0dc.bin','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_f0721624-144c-11ef-8f1b-d8242b6da0dc_SESS_f073b964-144c-11ef-8f1b-d8242b6da0dc_TOSC_a404f782-1466-11ef-8f1b-d8242b6da0dc_LIFIM','7cfb7be6-1467-11ef-8f1b-d8242b6da0dc.bin','7cfb7be6-1467-11ef-8f1b-d8242b6da0dc','{\"displayTitle\":\"Maxillaire 1.7.1.1.1 Ligne de finition métadonnées 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,'2024-05-17 18:09:59.000','2024-05-17 18:06:58.000','2024-05-17 16:09:59.000','2024-05-17 18:09:59.000'),('8208349e-0953-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_67fc2b93-0953-11ef-8f65-d9283bb1c6cd/occlusion_67fdc886-0953-11ef-8f65-d9283bb1c6cd/scan_69c3c2e3-0953-11ef-8f65-d9283bb1c6cd/8208349e-0953-11ef-8f65-d9283bb1c6cd.zip','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_67fc2b93-0953-11ef-8f65-d9283bb1c6cd_SESS_67fdc886-0953-11ef-8f65-d9283bb1c6cd_TOSC_69c3c2e3-0953-11ef-8f65-d9283bb1c6cd_MODEL','8208349e-0953-11ef-8f65-d9283bb1c6cd.zip','8208349e-0953-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Maxillaire 1.2.7.1.1\",\"modelMatrix\":\"0.999879,0.0145411,-0.00550569,0,-0.0145287,0.999892,0.0022888,0,0.00553838,-0.00220853,0.999982,0,-10.8611,0.221993,-18.0198,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-03 15:47:06.000','2024-05-03 13:47:06.000','2024-05-03 15:47:06.000'),('8208421c-0953-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_67fc2b93-0953-11ef-8f65-d9283bb1c6cd/occlusion_67fdc886-0953-11ef-8f65-d9283bb1c6cd/scan_69c3c2e3-0953-11ef-8f65-d9283bb1c6cd/8208421c-0953-11ef-8f65-d9283bb1c6cd.png','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_67fc2b93-0953-11ef-8f65-d9283bb1c6cd_SESS_67fdc886-0953-11ef-8f65-d9283bb1c6cd_TOSC_69c3c2e3-0953-11ef-8f65-d9283bb1c6cd_SNAPS','8208421c-0953-11ef-8f65-d9283bb1c6cd.png','8208421c-0953-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Maxillaire 1.2.7.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-03 15:47:06.000','2024-05-03 13:47:06.000','2024-05-03 15:47:06.000'),('87f32b29-0957-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_0a477976-0952-11ef-8f65-d9283bb1c6cd/analyse_32ad8516-0957-11ef-8f65-d9283bb1c6cd/87f32b29-0957-11ef-8f65-d9283bb1c6cd.json','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_0a477976-0952-11ef-8f65-d9283bb1c6cd_ANA_32ad8516-0957-11ef-8f65-d9283bb1c6cd_TRANS','87f32b29-0957-11ef-8f65-d9283bb1c6cd.json','87f32b29-0957-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Comparaison 1.2.5.2\"}','JSON',0,'SYNCED',0,NULL,'2024-05-03 16:15:02.586','2024-05-03 14:15:02.587','2024-05-03 16:15:03.028'),('88334fd2-0957-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_0a477976-0952-11ef-8f65-d9283bb1c6cd/analyse_32ad8516-0957-11ef-8f65-d9283bb1c6cd/88334fd2-0957-11ef-8f65-d9283bb1c6cd.png','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_0a477976-0952-11ef-8f65-d9283bb1c6cd_ANA_32ad8516-0957-11ef-8f65-d9283bb1c6cd_SNAPS','88334fd2-0957-11ef-8f65-d9283bb1c6cd.png','88334fd2-0957-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Comparaison 1.2.5.2\"}','PNG',0,'SYNCED',0,NULL,'2024-05-03 16:15:03.007','2024-05-03 14:15:03.009','2024-05-03 16:15:03.398'),('890659a3-1843-11ef-8f8e-d92a44d6667d',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_5748a11c-146a-11ef-8f1b-d8242b6da0dc/occlusion_574ac047-146a-11ef-8f1b-d8242b6da0dc/scan_ce02f919-146b-11ef-8f1b-d8242b6da0dc/890659a3-1843-11ef-8f8e-d92a44d6667d.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_5748a11c-146a-11ef-8f1b-d8242b6da0dc_SESS_574ac047-146a-11ef-8f1b-d8242b6da0dc_TOSC_ce02f919-146b-11ef-8f1b-d8242b6da0dc_SCREENS','890659a3-1843-11ef-8f8e-d92a44d6667d.png','890659a3-1843-11ef-8f8e-d92a44d6667d','{\"displayTitle\":\"Maxillaire 1.7.3.1.1 Capture d\'écran 1\",\"title\":\"1\"}','PNG',0,'SYNCED',0,'2024-05-22 16:00:07.099','2024-05-22 16:00:07.099','2024-05-22 14:00:07.099','2024-05-22 16:00:07.109'),('8a49c9a4-11cf-11ef-8f95-d92a45dc80ec',3,'/var/iris/.data/2024/3/235a3115-11cf-11ef-8f95-d92a45dc80ec/session_2a532631-11cf-11ef-8f95-d92a45dc80ec/occlusion_2a54d83c-11cf-11ef-8f95-d92a45dc80ec/scan_2bf4c0e1-11cf-11ef-8f95-d92a45dc80ec/8a49c9a4-11cf-11ef-8f95-d92a45dc80ec.png','PATIENT_235a3115-11cf-11ef-8f95-d92a45dc80ec_ACT_2a532631-11cf-11ef-8f95-d92a45dc80ec_SESS_2a54d83c-11cf-11ef-8f95-d92a45dc80ec_TOSC_2bf4c0e1-11cf-11ef-8f95-d92a45dc80ec_SCREENS','8a49c9a4-11cf-11ef-8f95-d92a45dc80ec.png','8a49c9a4-11cf-11ef-8f95-d92a45dc80ec','{\"displayTitle\":\"Maxillaire 1.4.1.1.1 Capture d\'écran test1\",\"title\":\"test1\"}','PNG',0,'SYNCED',0,NULL,'2024-05-14 10:55:00.267','2024-05-14 08:55:00.267','2024-05-14 10:55:00.269'),('8b206780-1843-11ef-8f8e-d92a44d6667d',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_5748a11c-146a-11ef-8f1b-d8242b6da0dc/occlusion_574ac047-146a-11ef-8f1b-d8242b6da0dc/scan_ce02f919-146b-11ef-8f1b-d8242b6da0dc/8b206780-1843-11ef-8f8e-d92a44d6667d.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_5748a11c-146a-11ef-8f1b-d8242b6da0dc_SESS_574ac047-146a-11ef-8f1b-d8242b6da0dc_TOSC_ce02f919-146b-11ef-8f1b-d8242b6da0dc_SCREENS','8b206780-1843-11ef-8f8e-d92a44d6667d.png','8b206780-1843-11ef-8f8e-d92a44d6667d','{\"displayTitle\":\"Maxillaire 1.7.3.1.1 Capture d\'écran 2\",\"title\":\"2\"}','PNG',0,'SYNCED',0,'2024-05-22 16:00:08.926','2024-05-22 16:00:08.926','2024-05-22 14:00:08.926','2024-05-22 16:00:08.935'),('8b26c5be-086c-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_89504286-086c-11ef-8ff6-da2f5a35fe58/analyse_895411ef-086c-11ef-8ff6-da2f5a35fe58/8b26c5be-086c-11ef-8ff6-da2f5a35fe58.json','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_89504286-086c-11ef-8ff6-da2f5a35fe58_ANA_895411ef-086c-11ef-8ff6-da2f5a35fe58_TRANS','8b26c5be-086c-11ef-8ff6-da2f5a35fe58.json','8b26c5be-086c-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Mesures 1.1.4.1\"}','JSON',0,'SYNCED',0,NULL,'2024-05-02 12:12:55.583','2024-05-02 10:12:55.585','2024-05-02 12:12:55.980'),('8b60cf5e-086c-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_89504286-086c-11ef-8ff6-da2f5a35fe58/analyse_895411ef-086c-11ef-8ff6-da2f5a35fe58/8b60cf5e-086c-11ef-8ff6-da2f5a35fe58.png','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_89504286-086c-11ef-8ff6-da2f5a35fe58_ANA_895411ef-086c-11ef-8ff6-da2f5a35fe58_SNAPS','8b60cf5e-086c-11ef-8ff6-da2f5a35fe58.png','8b60cf5e-086c-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Mesures 1.1.4.1\"}','PNG',0,'SYNCED',0,NULL,'2024-05-02 12:12:55.964','2024-05-02 10:12:55.966','2024-05-02 12:12:56.449'),('8c48de05-1467-11ef-8f1b-d8242b6da0dc',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_f0721624-144c-11ef-8f1b-d8242b6da0dc/order_f0742777-144c-11ef-8f1b-d8242b6da0dc/8c48de05-1467-11ef-8f1b-d8242b6da0dc.pdf','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_f0721624-144c-11ef-8f1b-d8242b6da0dc_PROST_f0742777-144c-11ef-8f1b-d8242b6da0dc_FORM','8c48de05-1467-11ef-8f1b-d8242b6da0dc.pdf','8c48de05-1467-11ef-8f1b-d8242b6da0dc','{\"displayTitle\":\"Commande 1.7.1.1 Guide\",\"title\":\"Guide\"}','PDF',0,'SYNCED',0,NULL,'2024-05-17 18:07:25.000','2024-05-17 16:07:26.170','2024-05-17 18:07:26.172'),('8c59743f-146d-11ef-8f1b-d8242b6da0dc',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_8c5787a0-146d-11ef-8f1b-d8242b6da0dc/occlusion_8c590d83-146d-11ef-8f1b-d8242b6da0dc/scan_8c595f83-146d-11ef-8f1b-d8242b6da0dc/8c59743f-146d-11ef-8f1b-d8242b6da0dc.zip','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_8c5787a0-146d-11ef-8f1b-d8242b6da0dc_SESS_8c590d83-146d-11ef-8f1b-d8242b6da0dc_TOSC_8c595f83-146d-11ef-8f1b-d8242b6da0dc_MODEL','8c59743f-146d-11ef-8f1b-d8242b6da0dc.zip','8c59743f-146d-11ef-8f1b-d8242b6da0dc','{\"displayTitle\":\"Maxillaire 1.7.5.1.1\",\"modelMatrix\":\"0.911721,-0.408329,0.045069,0,0.404868,0.911703,0.0698595,0,-0.0696153,-0.0454454,0.996538,0,-5.05468,2.73266,-18.4649,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-17 18:50:21.043','2024-05-17 16:50:21.082','2024-05-17 18:50:21.553'),('8c5f19ed-146d-11ef-8f1b-d8242b6da0dc',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_8c5787a0-146d-11ef-8f1b-d8242b6da0dc/occlusion_8c590d83-146d-11ef-8f1b-d8242b6da0dc/scan_8c595f83-146d-11ef-8f1b-d8242b6da0dc/8c5f19ed-146d-11ef-8f1b-d8242b6da0dc.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_8c5787a0-146d-11ef-8f1b-d8242b6da0dc_SESS_8c590d83-146d-11ef-8f1b-d8242b6da0dc_TOSC_8c595f83-146d-11ef-8f1b-d8242b6da0dc_SNAPS','8c5f19ed-146d-11ef-8f1b-d8242b6da0dc.png','8c5f19ed-146d-11ef-8f1b-d8242b6da0dc','{\"displayTitle\":\"Maxillaire 1.7.5.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-17 18:50:21.080','2024-05-17 16:50:21.082','2024-05-17 18:50:22.845'),('8d463d2e-1843-11ef-8f8e-d92a44d6667d',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_5748a11c-146a-11ef-8f1b-d8242b6da0dc/occlusion_574ac047-146a-11ef-8f1b-d8242b6da0dc/scan_ce02f919-146b-11ef-8f1b-d8242b6da0dc/8d463d2e-1843-11ef-8f8e-d92a44d6667d.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_5748a11c-146a-11ef-8f1b-d8242b6da0dc_SESS_574ac047-146a-11ef-8f1b-d8242b6da0dc_TOSC_ce02f919-146b-11ef-8f1b-d8242b6da0dc_SCREENS','8d463d2e-1843-11ef-8f8e-d92a44d6667d.png','8d463d2e-1843-11ef-8f8e-d92a44d6667d','{\"displayTitle\":\"Maxillaire 1.7.3.1.1 Capture d\'écran 3\",\"title\":\"3\"}','PNG',0,'SYNCED',0,'2024-05-22 16:00:10.445','2024-05-22 16:00:10.453','2024-05-22 14:00:10.453','2024-05-22 16:00:10.455'),('8f098cf6-1843-11ef-8f8e-d92a44d6667d',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_5748a11c-146a-11ef-8f1b-d8242b6da0dc/occlusion_574ac047-146a-11ef-8f1b-d8242b6da0dc/scan_ce02f919-146b-11ef-8f1b-d8242b6da0dc/8f098cf6-1843-11ef-8f8e-d92a44d6667d.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_5748a11c-146a-11ef-8f1b-d8242b6da0dc_SESS_574ac047-146a-11ef-8f1b-d8242b6da0dc_TOSC_ce02f919-146b-11ef-8f1b-d8242b6da0dc_SCREENS','8f098cf6-1843-11ef-8f8e-d92a44d6667d.png','8f098cf6-1843-11ef-8f8e-d92a44d6667d','{\"displayTitle\":\"Maxillaire 1.7.3.1.1 Capture d\'écran 4\",\"title\":\"4\"}','PNG',0,'SYNCED',0,'2024-05-22 16:00:11.911','2024-05-22 16:00:11.911','2024-05-22 14:00:11.912','2024-05-22 16:00:11.917'),('8f7e3337-11cf-11ef-8f95-d92a45dc80ec',3,'/var/iris/.data/2024/3/235a3115-11cf-11ef-8f95-d92a45dc80ec/session_2a532631-11cf-11ef-8f95-d92a45dc80ec/occlusion_2a54d83c-11cf-11ef-8f95-d92a45dc80ec/scan_2bf4c0e1-11cf-11ef-8f95-d92a45dc80ec/8f7e3337-11cf-11ef-8f95-d92a45dc80ec.png','PATIENT_235a3115-11cf-11ef-8f95-d92a45dc80ec_ACT_2a532631-11cf-11ef-8f95-d92a45dc80ec_SESS_2a54d83c-11cf-11ef-8f95-d92a45dc80ec_TOSC_2bf4c0e1-11cf-11ef-8f95-d92a45dc80ec_SCREENS','8f7e3337-11cf-11ef-8f95-d92a45dc80ec.png','8f7e3337-11cf-11ef-8f95-d92a45dc80ec','{\"displayTitle\":\"Maxillaire 1.4.1.1.1 Capture d\'écran 2\",\"title\":\"2\"}','PNG',0,'SYNCED',0,NULL,'2024-05-14 10:54:23.509','2024-05-14 08:54:23.573','2024-05-14 10:54:23.801'),('8f8b2e60-0952-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_4fc2347a-0952-11ef-8f65-d9283bb1c6cd/occlusion_4fc3d0e6-0952-11ef-8f65-d9283bb1c6cd/scan_7564b229-0952-11ef-8f65-d9283bb1c6cd/8f8b2e60-0952-11ef-8f65-d9283bb1c6cd.zip','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_4fc2347a-0952-11ef-8f65-d9283bb1c6cd_SESS_4fc3d0e6-0952-11ef-8f65-d9283bb1c6cd_BOSC_7564b229-0952-11ef-8f65-d9283bb1c6cd_MODEL','8f8b2e60-0952-11ef-8f65-d9283bb1c6cd.zip','8f8b2e60-0952-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Mandibule 1.2.6.1.1\",\"modelMatrix\":\"-0.579656,-0.811627,-0.0725353,0,0.789557,-0.581437,0.196293,0,-0.201491,0.0565115,0.977859,0,7.961,8.851,-17.9466,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-03 15:39:27.843','2024-05-03 13:39:28.113','2024-05-03 15:39:29.933'),('8f8b46a0-0952-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_4fc2347a-0952-11ef-8f65-d9283bb1c6cd/occlusion_4fc3d0e6-0952-11ef-8f65-d9283bb1c6cd/scan_7564b229-0952-11ef-8f65-d9283bb1c6cd/8f8b46a0-0952-11ef-8f65-d9283bb1c6cd.png','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_4fc2347a-0952-11ef-8f65-d9283bb1c6cd_SESS_4fc3d0e6-0952-11ef-8f65-d9283bb1c6cd_BOSC_7564b229-0952-11ef-8f65-d9283bb1c6cd_SNAPS','8f8b46a0-0952-11ef-8f65-d9283bb1c6cd.png','8f8b46a0-0952-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Mandibule 1.2.6.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-03 15:39:27.843','2024-05-03 13:39:28.120','2024-05-03 15:39:32.496'),('908c31ae-1843-11ef-8f8e-d92a44d6667d',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_5748a11c-146a-11ef-8f1b-d8242b6da0dc/occlusion_574ac047-146a-11ef-8f1b-d8242b6da0dc/scan_ce02f919-146b-11ef-8f1b-d8242b6da0dc/908c31ae-1843-11ef-8f8e-d92a44d6667d.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_5748a11c-146a-11ef-8f1b-d8242b6da0dc_SESS_574ac047-146a-11ef-8f1b-d8242b6da0dc_TOSC_ce02f919-146b-11ef-8f1b-d8242b6da0dc_SCREENS','908c31ae-1843-11ef-8f8e-d92a44d6667d.png','908c31ae-1843-11ef-8f8e-d92a44d6667d','{\"displayTitle\":\"Maxillaire 1.7.3.1.1 Capture d\'écran 5\",\"title\":\"5\"}','PNG',0,'SYNCED',0,'2024-05-22 16:00:13.952','2024-05-22 16:00:13.952','2024-05-22 14:00:13.952','2024-05-22 16:00:13.962'),('916b8d15-11d0-11ef-8f95-d92a45dc80ec',3,'/var/iris/.data/2024/3/235a3115-11cf-11ef-8f95-d92a45dc80ec/session_2a532631-11cf-11ef-8f95-d92a45dc80ec/occlusion_2a54d83c-11cf-11ef-8f95-d92a45dc80ec/scan_65575832-11d0-11ef-8f95-d92a45dc80ec/916b8d15-11d0-11ef-8f95-d92a45dc80ec.zip','PATIENT_235a3115-11cf-11ef-8f95-d92a45dc80ec_ACT_2a532631-11cf-11ef-8f95-d92a45dc80ec_SESS_2a54d83c-11cf-11ef-8f95-d92a45dc80ec_TOSC_65575832-11d0-11ef-8f95-d92a45dc80ec_MODEL','916b8d15-11d0-11ef-8f95-d92a45dc80ec.zip','916b8d15-11d0-11ef-8f95-d92a45dc80ec','{\"displayTitle\":\"Maxillaire 1.4.1.1.2\",\"modelMatrix\":\"-0.998128,-0.0469097,0.0392335,0,0.0598702,-0.880326,0.470576,0,0.0124638,0.472044,0.881487,0,-0.342565,-10.2106,-22.3279,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-14 11:01:36.239','2024-05-14 09:01:36.501','2024-05-14 11:01:38.508'),('916b9ff3-11d0-11ef-8f95-d92a45dc80ec',3,'/var/iris/.data/2024/3/235a3115-11cf-11ef-8f95-d92a45dc80ec/session_2a532631-11cf-11ef-8f95-d92a45dc80ec/occlusion_2a54d83c-11cf-11ef-8f95-d92a45dc80ec/scan_65575832-11d0-11ef-8f95-d92a45dc80ec/916b9ff3-11d0-11ef-8f95-d92a45dc80ec.png','PATIENT_235a3115-11cf-11ef-8f95-d92a45dc80ec_ACT_2a532631-11cf-11ef-8f95-d92a45dc80ec_SESS_2a54d83c-11cf-11ef-8f95-d92a45dc80ec_TOSC_65575832-11d0-11ef-8f95-d92a45dc80ec_SNAPS','916b9ff3-11d0-11ef-8f95-d92a45dc80ec.png','916b9ff3-11d0-11ef-8f95-d92a45dc80ec','{\"displayTitle\":\"Maxillaire 1.4.1.1.2 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-14 11:01:36.239','2024-05-14 09:01:36.503','2024-05-14 11:01:40.693'),('9353afab-11cf-11ef-8f95-d92a45dc80ec',3,'/var/iris/.data/2024/3/235a3115-11cf-11ef-8f95-d92a45dc80ec/session_2a532631-11cf-11ef-8f95-d92a45dc80ec/occlusion_2a54d83c-11cf-11ef-8f95-d92a45dc80ec/scan_2bf4c0e1-11cf-11ef-8f95-d92a45dc80ec/9353afab-11cf-11ef-8f95-d92a45dc80ec.png','PATIENT_235a3115-11cf-11ef-8f95-d92a45dc80ec_ACT_2a532631-11cf-11ef-8f95-d92a45dc80ec_SESS_2a54d83c-11cf-11ef-8f95-d92a45dc80ec_TOSC_2bf4c0e1-11cf-11ef-8f95-d92a45dc80ec_SCREENS','9353afab-11cf-11ef-8f95-d92a45dc80ec.png','9353afab-11cf-11ef-8f95-d92a45dc80ec','{\"displayTitle\":\"Maxillaire 1.4.1.1.1 Capture d\'écran 3\",\"title\":\"3\"}','PNG',0,'SYNCED',0,NULL,'2024-05-14 10:54:29.941','2024-05-14 08:54:29.998','2024-05-14 10:54:30.244'),('94d3f721-1436-11ef-8f1b-d8242b6da0dc',3,'/var/iris/.data/2024/3/16032a0e-1436-11ef-8f1b-d8242b6da0dc/session_1f4547de-1436-11ef-8f1b-d8242b6da0dc/order_1f4743e1-1436-11ef-8f1b-d8242b6da0dc/94d3f721-1436-11ef-8f1b-d8242b6da0dc.pdf','PATIENT_16032a0e-1436-11ef-8f1b-d8242b6da0dc_ACT_1f4547de-1436-11ef-8f1b-d8242b6da0dc_PROST_1f4743e1-1436-11ef-8f1b-d8242b6da0dc_FORM','94d3f721-1436-11ef-8f1b-d8242b6da0dc.pdf','94d3f721-1436-11ef-8f1b-d8242b6da0dc','{\"displayTitle\":\"Commande 1.6.1.1 Couronne\",\"title\":\"Couronne\"}','PDF',0,'SYNCED',0,NULL,'2024-05-17 12:16:52.948','2024-05-17 10:16:53.626','2024-05-17 12:16:53.799'),('97300d09-11cf-11ef-8f95-d92a45dc80ec',3,'/var/iris/.data/2024/3/235a3115-11cf-11ef-8f95-d92a45dc80ec/session_2a532631-11cf-11ef-8f95-d92a45dc80ec/occlusion_2a54d83c-11cf-11ef-8f95-d92a45dc80ec/scan_2bf4c0e1-11cf-11ef-8f95-d92a45dc80ec/97300d09-11cf-11ef-8f95-d92a45dc80ec.png','PATIENT_235a3115-11cf-11ef-8f95-d92a45dc80ec_ACT_2a532631-11cf-11ef-8f95-d92a45dc80ec_SESS_2a54d83c-11cf-11ef-8f95-d92a45dc80ec_TOSC_2bf4c0e1-11cf-11ef-8f95-d92a45dc80ec_SCREENS','97300d09-11cf-11ef-8f95-d92a45dc80ec.png','97300d09-11cf-11ef-8f95-d92a45dc80ec','{\"displayTitle\":\"Maxillaire 1.4.1.1.1 Capture d\'écran 4\",\"title\":\"4\"}','PNG',0,'SYNCED',0,NULL,'2024-05-14 10:54:37.000','2024-05-14 08:54:37.000','2024-05-14 10:54:37.000'),('97508969-06ed-11ef-90c8-dd3986f53a42',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_4dd3e575-06ed-11ef-90c8-dd3986f53a42/order_4dd5f101-06ed-11ef-90c8-dd3986f53a42/97508969-06ed-11ef-90c8-dd3986f53a42.pdf','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_4dd3e575-06ed-11ef-90c8-dd3986f53a42_PROST_4dd5f101-06ed-11ef-90c8-dd3986f53a42_FORM','97508969-06ed-11ef-90c8-dd3986f53a42.pdf','97508969-06ed-11ef-90c8-dd3986f53a42','{\"displayTitle\":\"Commande 1.1.1.1 Facette\",\"title\":\"Facette\"}','PDF',0,'SYNCED',0,NULL,'2024-04-30 14:31:38.742','2024-04-30 12:31:39.426','2024-04-30 14:31:39.528'),('99357a18-146b-11ef-8f1b-d8242b6da0dc',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_5748a11c-146a-11ef-8f1b-d8242b6da0dc/occlusion_574ac047-146a-11ef-8f1b-d8242b6da0dc/scan_6c005b92-146b-11ef-8f1b-d8242b6da0dc/99357a18-146b-11ef-8f1b-d8242b6da0dc.zip','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_5748a11c-146a-11ef-8f1b-d8242b6da0dc_SESS_574ac047-146a-11ef-8f1b-d8242b6da0dc_BOSC_6c005b92-146b-11ef-8f1b-d8242b6da0dc_MODEL','99357a18-146b-11ef-8f1b-d8242b6da0dc.zip','6c00823f-146b-11ef-8f1b-d8242b6da0dc','{\"displayTitle\":\"Mandibule 1.7.3.1.2\",\"modelMatrix\":\"0.216912,-0.961673,0.167735,0,0.914657,0.140177,-0.379147,0,0.341103,0.235661,0.910007,0,-27.5796,7.81859,-17.4136,1\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2024-05-17 18:36:23.625','2024-05-17 16:36:24.198','2024-05-17 18:36:25.791'),('99358b17-146b-11ef-8f1b-d8242b6da0dc',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_5748a11c-146a-11ef-8f1b-d8242b6da0dc/occlusion_574ac047-146a-11ef-8f1b-d8242b6da0dc/scan_6c005b92-146b-11ef-8f1b-d8242b6da0dc/99358b17-146b-11ef-8f1b-d8242b6da0dc.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_5748a11c-146a-11ef-8f1b-d8242b6da0dc_SESS_574ac047-146a-11ef-8f1b-d8242b6da0dc_BOSC_6c005b92-146b-11ef-8f1b-d8242b6da0dc_SNAPS','99358b17-146b-11ef-8f1b-d8242b6da0dc.png','6c0694b6-146b-11ef-8f1b-d8242b6da0dc','{\"displayTitle\":\"Mandibule 1.7.3.1.2 Snapshot\"}','PNG',1,'SYNCED',0,NULL,'2024-05-17 18:36:23.625','2024-05-17 16:36:24.199','2024-05-17 18:36:28.207'),('9935aa64-094f-11ef-8f65-d9283bb1c6cd',6,'/var/iris/.data/2024/6/bbee50d8-094f-11ef-8f65-d9283bb1c6cd/session_7d7b190c-094f-11ef-8f65-d9283bb1c6cd/occlusion_7d7bdba5-094f-11ef-8f65-d9283bb1c6cd/scan_7e3b5074-094f-11ef-8f65-d9283bb1c6cd/9935aa64-094f-11ef-8f65-d9283bb1c6cd.zip','PATIENT_bbee50d8-094f-11ef-8f65-d9283bb1c6cd_ACT_7d7b190c-094f-11ef-8f65-d9283bb1c6cd_SESS_7d7bdba5-094f-11ef-8f65-d9283bb1c6cd_TOSC_7e3b5074-094f-11ef-8f65-d9283bb1c6cd_MODEL','9935aa64-094f-11ef-8f65-d9283bb1c6cd.zip','9935aa64-094f-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Maxillaire 1.1.1.1.1\",\"modelMatrix\":\"0.911721,-0.408329,0.045069,0,0.404868,0.911703,0.0698595,0,-0.0696153,-0.0454454,0.996538,0,-5.05468,2.73266,-18.4649,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-03 15:19:17.000','2024-05-03 13:19:17.000','2024-05-03 15:19:17.000'),('9935cedf-094f-11ef-8f65-d9283bb1c6cd',6,'/var/iris/.data/2024/6/bbee50d8-094f-11ef-8f65-d9283bb1c6cd/session_7d7b190c-094f-11ef-8f65-d9283bb1c6cd/occlusion_7d7bdba5-094f-11ef-8f65-d9283bb1c6cd/scan_7e3b5074-094f-11ef-8f65-d9283bb1c6cd/9935cedf-094f-11ef-8f65-d9283bb1c6cd.png','PATIENT_bbee50d8-094f-11ef-8f65-d9283bb1c6cd_ACT_7d7b190c-094f-11ef-8f65-d9283bb1c6cd_SESS_7d7bdba5-094f-11ef-8f65-d9283bb1c6cd_TOSC_7e3b5074-094f-11ef-8f65-d9283bb1c6cd_SNAPS','9935cedf-094f-11ef-8f65-d9283bb1c6cd.png','9935cedf-094f-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Maxillaire 1.1.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-03 15:19:17.000','2024-05-03 13:19:17.000','2024-05-03 15:19:17.000'),('9a964568-0864-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_405b2abf-0864-11ef-8ff6-da2f5a35fe58/9a964568-0864-11ef-8ff6-da2f5a35fe58.zip','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_RISC_405b2abf-0864-11ef-8ff6-da2f5a35fe58_MODEL','9a964568-0864-11ef-8ff6-da2f5a35fe58.zip','9a964568-0864-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Mordu droit 1.1.2.1.1\",\"modelMatrix\":\"0.999123,0.0262569,0.0381029,0,-0.0260382,0.989632,0.136561,0,-0.0332268,-0.141353,0.989907,0,5.96872,2.32456,-15.2889,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-02 11:16:05.506','2024-05-02 09:16:05.855','2024-05-02 11:16:09.736'),('9a965491-0864-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_405b2abf-0864-11ef-8ff6-da2f5a35fe58/9a965491-0864-11ef-8ff6-da2f5a35fe58.png','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_RISC_405b2abf-0864-11ef-8ff6-da2f5a35fe58_SNAPS','9a965491-0864-11ef-8ff6-da2f5a35fe58.png','9a965491-0864-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Mordu droit 1.1.2.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-02 11:16:05.507','2024-05-02 09:16:05.861','2024-05-02 11:16:11.021'),('9c306613-146c-11ef-8f1b-d8242b6da0dc',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_5748a11c-146a-11ef-8f1b-d8242b6da0dc/occlusion_574ac047-146a-11ef-8f1b-d8242b6da0dc/scan_ce02f919-146b-11ef-8f1b-d8242b6da0dc/9c306613-146c-11ef-8f1b-d8242b6da0dc.zip','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_5748a11c-146a-11ef-8f1b-d8242b6da0dc_SESS_574ac047-146a-11ef-8f1b-d8242b6da0dc_TOSC_ce02f919-146b-11ef-8f1b-d8242b6da0dc_MODEL','9c306613-146c-11ef-8f1b-d8242b6da0dc.zip','9c306613-146c-11ef-8f1b-d8242b6da0dc','{\"displayTitle\":\"Maxillaire 1.7.3.1.1\",\"modelMatrix\":\"0.0571383,-0.99819,-0.0187699,0,0.94814,0.0601422,-0.31211,0,0.312674,3.69602e-05,0.94986,0,8.87629,12.0321,-21.9281,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-17 18:43:38.121','2024-05-17 16:43:38.430','2024-05-17 18:43:40.260'),('9c307424-146c-11ef-8f1b-d8242b6da0dc',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_5748a11c-146a-11ef-8f1b-d8242b6da0dc/occlusion_574ac047-146a-11ef-8f1b-d8242b6da0dc/scan_ce02f919-146b-11ef-8f1b-d8242b6da0dc/9c307424-146c-11ef-8f1b-d8242b6da0dc.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_5748a11c-146a-11ef-8f1b-d8242b6da0dc_SESS_574ac047-146a-11ef-8f1b-d8242b6da0dc_TOSC_ce02f919-146b-11ef-8f1b-d8242b6da0dc_SNAPS','9c307424-146c-11ef-8f1b-d8242b6da0dc.png','9c307424-146c-11ef-8f1b-d8242b6da0dc','{\"displayTitle\":\"Maxillaire 1.7.3.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-17 18:43:38.122','2024-05-17 16:43:38.431','2024-05-17 18:43:40.961'),('9c6dafad-11cf-11ef-8f95-d92a45dc80ec',3,'/var/iris/.data/2024/3/235a3115-11cf-11ef-8f95-d92a45dc80ec/session_2a532631-11cf-11ef-8f95-d92a45dc80ec/occlusion_2a54d83c-11cf-11ef-8f95-d92a45dc80ec/scan_2bf4c0e1-11cf-11ef-8f95-d92a45dc80ec/9c6dafad-11cf-11ef-8f95-d92a45dc80ec.png','PATIENT_235a3115-11cf-11ef-8f95-d92a45dc80ec_ACT_2a532631-11cf-11ef-8f95-d92a45dc80ec_SESS_2a54d83c-11cf-11ef-8f95-d92a45dc80ec_TOSC_2bf4c0e1-11cf-11ef-8f95-d92a45dc80ec_SCREENS','9c6dafad-11cf-11ef-8f95-d92a45dc80ec.png','9c6dafad-11cf-11ef-8f95-d92a45dc80ec','{\"displayTitle\":\"Maxillaire 1.4.1.1.1 Capture d\'écran 5\",\"title\":\"5\"}','PNG',0,'SYNCED',0,NULL,'2024-05-14 10:54:45.211','2024-05-14 08:54:45.269','2024-05-14 10:54:45.512'),('9ddab794-0953-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_67fc2b93-0953-11ef-8f65-d9283bb1c6cd/occlusion_67fdc886-0953-11ef-8f65-d9283bb1c6cd/scan_8384e76f-0953-11ef-8f65-d9283bb1c6cd/9ddab794-0953-11ef-8f65-d9283bb1c6cd.zip','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_67fc2b93-0953-11ef-8f65-d9283bb1c6cd_SESS_67fdc886-0953-11ef-8f65-d9283bb1c6cd_BOSC_8384e76f-0953-11ef-8f65-d9283bb1c6cd_MODEL','9ddab794-0953-11ef-8f65-d9283bb1c6cd.zip','9ddab794-0953-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Mandibule 1.2.7.1.1\",\"modelMatrix\":\"0.975206,0.219802,-0.0256813,0,-0.218098,0.934959,-0.279792,0,-0.0374879,0.278456,0.959717,0,-4.11951,-8.78935,-16.8342,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-03 15:47:01.349','2024-05-03 13:47:01.633','2024-05-03 15:47:06.501'),('9ddac7dd-0953-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_67fc2b93-0953-11ef-8f65-d9283bb1c6cd/occlusion_67fdc886-0953-11ef-8f65-d9283bb1c6cd/scan_8384e76f-0953-11ef-8f65-d9283bb1c6cd/9ddac7dd-0953-11ef-8f65-d9283bb1c6cd.png','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_67fc2b93-0953-11ef-8f65-d9283bb1c6cd_SESS_67fdc886-0953-11ef-8f65-d9283bb1c6cd_BOSC_8384e76f-0953-11ef-8f65-d9283bb1c6cd_SNAPS','9ddac7dd-0953-11ef-8f65-d9283bb1c6cd.png','9ddac7dd-0953-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Mandibule 1.2.7.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-03 15:47:01.349','2024-05-03 13:47:01.633','2024-05-03 15:47:08.651'),('9fed873b-146d-11ef-8f1b-d8242b6da0dc',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_8c5787a0-146d-11ef-8f1b-d8242b6da0dc/occlusion_8c590d83-146d-11ef-8f1b-d8242b6da0dc/scan_9fed5eb3-146d-11ef-8f1b-d8242b6da0dc/9fed873b-146d-11ef-8f1b-d8242b6da0dc.zip','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_8c5787a0-146d-11ef-8f1b-d8242b6da0dc_SESS_8c590d83-146d-11ef-8f1b-d8242b6da0dc_TOSC_9fed5eb3-146d-11ef-8f1b-d8242b6da0dc_MODEL','9fed873b-146d-11ef-8f1b-d8242b6da0dc.zip','9fed873b-146d-11ef-8f1b-d8242b6da0dc','{\"displayTitle\":\"Maxillaire 1.7.5.1.2\",\"modelMatrix\":\"0.911721,-0.408329,0.045069,0,0.404868,0.911703,0.0698595,0,-0.0696153,-0.0454454,0.996538,0,-5.05468,2.73266,-18.4649,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-17 18:50:53.891','2024-05-17 16:50:53.936','2024-05-17 18:50:54.100'),('9ff2e69b-146d-11ef-8f1b-d8242b6da0dc',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_8c5787a0-146d-11ef-8f1b-d8242b6da0dc/occlusion_8c590d83-146d-11ef-8f1b-d8242b6da0dc/scan_9fed5eb3-146d-11ef-8f1b-d8242b6da0dc/9ff2e69b-146d-11ef-8f1b-d8242b6da0dc.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_8c5787a0-146d-11ef-8f1b-d8242b6da0dc_SESS_8c590d83-146d-11ef-8f1b-d8242b6da0dc_TOSC_9fed5eb3-146d-11ef-8f1b-d8242b6da0dc_SNAPS','9ff2e69b-146d-11ef-8f1b-d8242b6da0dc.png','9ff2e69b-146d-11ef-8f1b-d8242b6da0dc','{\"displayTitle\":\"Maxillaire 1.7.5.1.2 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-17 18:50:53.926','2024-05-17 16:50:53.936','2024-05-17 18:50:55.033'),('a2c565cd-1467-11ef-8f1b-d8242b6da0dc',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_f0721624-144c-11ef-8f1b-d8242b6da0dc/occlusion_f073b964-144c-11ef-8f1b-d8242b6da0dc/scan_a404f782-1466-11ef-8f1b-d8242b6da0dc/a2c565cd-1467-11ef-8f1b-d8242b6da0dc.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_f0721624-144c-11ef-8f1b-d8242b6da0dc_SESS_f073b964-144c-11ef-8f1b-d8242b6da0dc_TOSC_a404f782-1466-11ef-8f1b-d8242b6da0dc_SCREENS','a2c565cd-1467-11ef-8f1b-d8242b6da0dc.png','a2c565cd-1467-11ef-8f1b-d8242b6da0dc','{\"displayTitle\":\"Maxillaire 1.7.1.1.1 Capture d\'écran 2\",\"title\":\"2\"}','PNG',0,'SYNCED',0,'2024-05-22 15:55:27.940','2024-05-22 15:55:27.941','2024-05-22 13:55:27.941','2024-05-22 15:55:27.950'),('a3a69b8b-0864-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/computedocclusion_3966fc97-0864-11ef-8ff6-da2f5a35fe58/a3a69b8b-0864-11ef-8ff6-da2f5a35fe58.zip','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_OCC_3966fc97-0864-11ef-8ff6-da2f5a35fe58_TOPLY','a3a69b8b-0864-11ef-8ff6-da2f5a35fe58.zip','a3a69b8b-0864-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Occlusion 1.1.2.1.1 Maxillaire\",\"modelMatrix\":\"0.0444728,-0.991811,-0.11972,0,0.974881,0.0692654,-0.21168,0,0.218239,-0.107299,0.969979,0,-25.3453,27.4041,-20.8016,1\",\"occlusionMatrix\":\"-0.974894,0.134129,0.177739,0,-0.209705,-0.284655,-0.935412,0,-0.0748715,-0.9492,0.305636,0,31.0933,26.6708,6.74008,1\",\"occlusionType\":5,\"referenceScanId\":\"59e98ac5-0861-11ef-8ff6-da2f5a35fe58\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-02 11:16:27.000','2024-05-02 09:16:27.000','2024-05-02 11:16:27.000'),('a3e32cc1-0864-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/computedocclusion_3966fc97-0864-11ef-8ff6-da2f5a35fe58/a3e32cc1-0864-11ef-8ff6-da2f5a35fe58.xyz','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_OCC_3966fc97-0864-11ef-8ff6-da2f5a35fe58_LIFIO','a3e32cc1-0864-11ef-8ff6-da2f5a35fe58.xyz','a3e32cc1-0864-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Occlusion 1.1.2.1.1 Ligne de finition Maxillaire 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY\",\"referenceScanId\":\"59e98ac5-0861-11ef-8ff6-da2f5a35fe58\",\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-05-02 11:16:28.000','2024-05-02 09:16:28.000','2024-05-02 11:16:28.000'),('a3e332c3-0864-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/computedocclusion_3966fc97-0864-11ef-8ff6-da2f5a35fe58/a3e332c3-0864-11ef-8ff6-da2f5a35fe58.bin','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_OCC_3966fc97-0864-11ef-8ff6-da2f5a35fe58_LIFIMO','a3e332c3-0864-11ef-8ff6-da2f5a35fe58.bin','a3e332c3-0864-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Occlusion 1.1.2.1.1 Ligne de finition métadonnées Maxillaire 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY\",\"referenceScanId\":\"59e98ac5-0861-11ef-8ff6-da2f5a35fe58\",\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-05-02 11:16:28.000','2024-05-02 09:16:28.000','2024-05-02 11:16:28.000'),('a3e37662-0864-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/computedocclusion_3966fc97-0864-11ef-8ff6-da2f5a35fe58/a3e37662-0864-11ef-8ff6-da2f5a35fe58.xyz','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_OCC_3966fc97-0864-11ef-8ff6-da2f5a35fe58_LIFIO','a3e37662-0864-11ef-8ff6-da2f5a35fe58.xyz','a3e37662-0864-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Occlusion 1.1.2.1.1 Ligne de finition Maxillaire 1\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY\",\"referenceScanId\":\"59e98ac5-0861-11ef-8ff6-da2f5a35fe58\",\"title\":\"1\",\"toothNumber\":1001,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-05-02 11:16:28.000','2024-05-02 09:16:28.000','2024-05-02 11:16:28.000'),('a3e37c4f-0864-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/computedocclusion_3966fc97-0864-11ef-8ff6-da2f5a35fe58/a3e37c4f-0864-11ef-8ff6-da2f5a35fe58.bin','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_OCC_3966fc97-0864-11ef-8ff6-da2f5a35fe58_LIFIMO','a3e37c4f-0864-11ef-8ff6-da2f5a35fe58.bin','a3e37c4f-0864-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Occlusion 1.1.2.1.1 Ligne de finition métadonnées Maxillaire 1\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY\",\"referenceScanId\":\"59e98ac5-0861-11ef-8ff6-da2f5a35fe58\",\"title\":\"1\",\"toothNumber\":1001,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-05-02 11:16:28.000','2024-05-02 09:16:28.000','2024-05-02 11:16:28.000'),('a3e3b7e2-0864-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/computedocclusion_3966fc97-0864-11ef-8ff6-da2f5a35fe58/a3e3b7e2-0864-11ef-8ff6-da2f5a35fe58.zip','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_OCC_3966fc97-0864-11ef-8ff6-da2f5a35fe58_BOPLY','a3e3b7e2-0864-11ef-8ff6-da2f5a35fe58.zip','a3e3b7e2-0864-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Occlusion 1.1.2.1.1 Mandibule\",\"modelMatrix\":\"-0.390176,0.908855,0.147464,0,-0.896018,-0.411662,0.166391,0,0.21193,-0.067209,0.974971,0,23.0061,-12.7793,-21.2754,1\",\"occlusionMatrix\":\"-0.674105,0.367234,0.640879,0,0.714195,0.545419,0.438689,0,-0.188446,0.753432,-0.629945,0,5.41862,-27.1499,-17.8681,1\",\"occlusionType\":5,\"referenceScanId\":\"91249277-0862-11ef-8ff6-da2f5a35fe58\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-02 11:16:33.000','2024-05-02 09:16:33.000','2024-05-02 11:16:33.000'),('a413fc36-0864-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/computedocclusion_3966fc97-0864-11ef-8ff6-da2f5a35fe58/a413fc36-0864-11ef-8ff6-da2f5a35fe58.xyz','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_OCC_3966fc97-0864-11ef-8ff6-da2f5a35fe58_LIFIO','a413fc36-0864-11ef-8ff6-da2f5a35fe58.xyz','a413fc36-0864-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Occlusion 1.1.2.1.1 Ligne de finition Mandibule 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MANDIBLE\",\"referenceScanId\":\"91249277-0862-11ef-8ff6-da2f5a35fe58\",\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-05-02 11:16:33.000','2024-05-02 09:16:33.000','2024-05-02 11:16:33.000'),('a414024b-0864-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/computedocclusion_3966fc97-0864-11ef-8ff6-da2f5a35fe58/a414024b-0864-11ef-8ff6-da2f5a35fe58.bin','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_OCC_3966fc97-0864-11ef-8ff6-da2f5a35fe58_LIFIMO','a414024b-0864-11ef-8ff6-da2f5a35fe58.bin','a414024b-0864-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Occlusion 1.1.2.1.1 Ligne de finition métadonnées Mandibule 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MANDIBLE\",\"referenceScanId\":\"91249277-0862-11ef-8ff6-da2f5a35fe58\",\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-05-02 11:16:33.000','2024-05-02 09:16:33.000','2024-05-02 11:16:33.000'),('a4f01daf-0864-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/computedocclusion_3966fc97-0864-11ef-8ff6-da2f5a35fe58/a4f01daf-0864-11ef-8ff6-da2f5a35fe58.png','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_OCC_3966fc97-0864-11ef-8ff6-da2f5a35fe58_SNAPO','a4f01daf-0864-11ef-8ff6-da2f5a35fe58.png','a4f01daf-0864-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Occlusion 1.1.2.1.1 Snapshot\",\"occlusionType\":5}','PNG',0,'SYNCED',0,NULL,'2024-05-02 11:16:33.000','2024-05-02 09:16:33.000','2024-05-02 11:16:33.000'),('a517d5ee-1843-11ef-8f8e-d92a44d6667d',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_f0721624-144c-11ef-8f1b-d8242b6da0dc/occlusion_f073b964-144c-11ef-8f1b-d8242b6da0dc/scan_a404f782-1466-11ef-8f1b-d8242b6da0dc/a517d5ee-1843-11ef-8f8e-d92a44d6667d.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_f0721624-144c-11ef-8f1b-d8242b6da0dc_SESS_f073b964-144c-11ef-8f1b-d8242b6da0dc_TOSC_a404f782-1466-11ef-8f1b-d8242b6da0dc_SCREENS','a517d5ee-1843-11ef-8f8e-d92a44d6667d.png','a517d5ee-1843-11ef-8f8e-d92a44d6667d','{\"displayTitle\":\"Maxillaire 1.7.1.1.1 Capture d\'écran 1\",\"title\":\"1\"}','PNG',0,'SYNCED',0,'2024-05-22 16:00:36.191','2024-05-22 16:00:36.191','2024-05-22 14:00:36.192','2024-05-22 16:00:36.201'),('b10594c5-183e-11ef-8f8e-d92a44d6667d',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_f0721624-144c-11ef-8f1b-d8242b6da0dc/occlusion_f073b964-144c-11ef-8f1b-d8242b6da0dc/scan_a404f782-1466-11ef-8f1b-d8242b6da0dc/b10594c5-183e-11ef-8f8e-d92a44d6667d.json','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_f0721624-144c-11ef-8f1b-d8242b6da0dc_SESS_f073b964-144c-11ef-8f1b-d8242b6da0dc_TOSC_a404f782-1466-11ef-8f1b-d8242b6da0dc_METER','b10594c5-183e-11ef-8f8e-d92a44d6667d.json','03a4f7ef-1834-11ef-8f8e-d92a44d6667d','{\"displayTitle\":\"Maxillaire 1.7.1.1.1 Mesure\"}','JSON',2,'SYNCED',0,NULL,'2024-05-22 15:25:00.874','2024-05-22 13:25:00.877','2024-05-22 15:25:00.969'),('b3179c69-0952-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_4fc2347a-0952-11ef-8f65-d9283bb1c6cd/occlusion_4fc3d0e6-0952-11ef-8f65-d9283bb1c6cd/scan_99f71009-0952-11ef-8f65-d9283bb1c6cd/b3179c69-0952-11ef-8f65-d9283bb1c6cd.zip','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_4fc2347a-0952-11ef-8f65-d9283bb1c6cd_SESS_4fc3d0e6-0952-11ef-8f65-d9283bb1c6cd_RISC_99f71009-0952-11ef-8f65-d9283bb1c6cd_MODEL','b3179c69-0952-11ef-8f65-d9283bb1c6cd.zip','b3179c69-0952-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Mordu droit 1.2.6.1.1\",\"modelMatrix\":\"0.998984,-0.0084677,0.0435522,0,0.0121578,0.998921,-0.0452886,0,-0.043434,0.0456896,0.998024,0,-5.29292,-6.153,-15.3705,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-03 15:40:27.483','2024-05-03 13:40:27.695','2024-05-03 15:40:29.902'),('b317b04e-0952-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_4fc2347a-0952-11ef-8f65-d9283bb1c6cd/occlusion_4fc3d0e6-0952-11ef-8f65-d9283bb1c6cd/scan_99f71009-0952-11ef-8f65-d9283bb1c6cd/b317b04e-0952-11ef-8f65-d9283bb1c6cd.png','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_4fc2347a-0952-11ef-8f65-d9283bb1c6cd_SESS_4fc3d0e6-0952-11ef-8f65-d9283bb1c6cd_RISC_99f71009-0952-11ef-8f65-d9283bb1c6cd_SNAPS','b317b04e-0952-11ef-8f65-d9283bb1c6cd.png','b317b04e-0952-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Mordu droit 1.2.6.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-03 15:40:27.484','2024-05-03 13:40:27.696','2024-05-03 15:40:32.227'),('bba3b492-1436-11ef-8f1b-d8242b6da0dc',3,'/var/iris/.data/2024/3/16032a0e-1436-11ef-8f1b-d8242b6da0dc/session_1f4547de-1436-11ef-8f1b-d8242b6da0dc/order_1f4743e1-1436-11ef-8f1b-d8242b6da0dc/bba3b492-1436-11ef-8f1b-d8242b6da0dc.pdf','PATIENT_16032a0e-1436-11ef-8f1b-d8242b6da0dc_ACT_1f4547de-1436-11ef-8f1b-d8242b6da0dc_PROST_1f4743e1-1436-11ef-8f1b-d8242b6da0dc_FORM','bba3b492-1436-11ef-8f1b-d8242b6da0dc.pdf','94d3f721-1436-11ef-8f1b-d8242b6da0dc','{\"displayTitle\":\"Commande 1.6.1.1 Couronne\",\"title\":\"Couronne\"}','PDF',1,'SYNCED',0,NULL,'2024-05-17 12:17:59.000','2024-05-17 10:17:59.000','2024-05-17 12:17:59.000'),('bc911890-0863-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_1e96af46-0863-11ef-8ff6-da2f5a35fe58/bc911890-0863-11ef-8ff6-da2f5a35fe58.zip','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_TOSC_1e96af46-0863-11ef-8ff6-da2f5a35fe58_MODEL','bc911890-0863-11ef-8ff6-da2f5a35fe58.zip','1e96d0f1-0863-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Maxillaire scanbody 1.1.2.1.2\",\"modelMatrix\":\"0.0356374,-0.993736,-0.105918,0,0.977155,0.0568693,-0.204779,0,0.20952,-0.0962007,0.973061,0,-25.6493,27.3607,-21.4551,1\",\"scanBodies\":[{\"position\":\"27.5285,5,0,0,40.8404,0,5.4,0,34.8176,0,0,6.3,1,0,0,0\",\"reference\":\"K30PSCANP\",\"tid\":26}]}','ZIP',2,'SYNCED',0,NULL,'2024-05-02 11:10:07.000','2024-05-02 09:10:07.000','2024-05-02 11:10:07.000'),('bc912779-0863-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_1e96af46-0863-11ef-8ff6-da2f5a35fe58/bc912779-0863-11ef-8ff6-da2f5a35fe58.png','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_TOSC_1e96af46-0863-11ef-8ff6-da2f5a35fe58_SNAPS','bc912779-0863-11ef-8ff6-da2f5a35fe58.png','1ea66a74-0863-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Maxillaire scanbody 1.1.2.1.2 Snapshot\"}','PNG',1,'SYNCED',0,NULL,'2024-05-02 11:10:07.000','2024-05-02 09:10:07.000','2024-05-02 11:10:07.000'),('bdd2799d-0864-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/computedocclusion_3966fc97-0864-11ef-8ff6-da2f5a35fe58/bdd2799d-0864-11ef-8ff6-da2f5a35fe58.zip','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_OCC_3966fc97-0864-11ef-8ff6-da2f5a35fe58_TOSB','bdd2799d-0864-11ef-8ff6-da2f5a35fe58.zip','bdd2799d-0864-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Occlusion 1.1.2.1.1 Maxillaire scanbody\",\"modelMatrix\":\"0.0356374,-0.993736,-0.105918,0,0.977155,0.0568693,-0.204779,0,0.20952,-0.0962007,0.973061,0,-25.6493,27.3607,-21.4551,1\",\"occlusionMatrix\":\"-0.975236,0.127023,0.181063,0,-0.210845,-0.286678,-0.934537,0,-0.0668007,-0.949571,0.306362,0,30.856,26.854,6.55269,1\",\"occlusionType\":5,\"referenceScanId\":\"1e96af46-0863-11ef-8ff6-da2f5a35fe58\",\"scanBodies\":[{\"position\":\"27.5285,5,0,0,40.8404,0,5.4,0,34.8176,0,0,6.3,1,0,0,0\",\"reference\":\"K30PSCANP\",\"tid\":26}]}','ZIP',0,'SYNCED',0,NULL,'2024-05-02 11:17:07.000','2024-05-02 09:17:07.000','2024-05-02 11:17:07.000'),('c369126f-174a-11ef-8f86-d92942cf49fd',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_b1ce9a22-1749-11ef-8f86-d92942cf49fd/occlusion_b1d043a8-1749-11ef-8f86-d92942cf49fd/scan_a4132a7d-174a-11ef-8f86-d92942cf49fd/c369126f-174a-11ef-8f86-d92942cf49fd.zip','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_b1ce9a22-1749-11ef-8f86-d92942cf49fd_SESS_b1d043a8-1749-11ef-8f86-d92942cf49fd_BOSC_a4132a7d-174a-11ef-8f86-d92942cf49fd_MODEL','c369126f-174a-11ef-8f86-d92942cf49fd.zip','c369126f-174a-11ef-8f86-d92942cf49fd','{\"displayTitle\":\"Mandibule 1.7.6.1.1\",\"modelMatrix\":\"-0.907406,-0.418344,0.0400261,0,0.418868,-0.892567,0.166955,0,-0.0341189,0.168262,0.985152,0,13.6538,6.2861,-17.1221,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-21 10:18:54.523','2024-05-21 08:18:54.802','2024-05-21 10:18:56.262'),('c3692577-174a-11ef-8f86-d92942cf49fd',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_b1ce9a22-1749-11ef-8f86-d92942cf49fd/occlusion_b1d043a8-1749-11ef-8f86-d92942cf49fd/scan_a4132a7d-174a-11ef-8f86-d92942cf49fd/c3692577-174a-11ef-8f86-d92942cf49fd.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_b1ce9a22-1749-11ef-8f86-d92942cf49fd_SESS_b1d043a8-1749-11ef-8f86-d92942cf49fd_BOSC_a4132a7d-174a-11ef-8f86-d92942cf49fd_SNAPS','c3692577-174a-11ef-8f86-d92942cf49fd.png','c3692577-174a-11ef-8f86-d92942cf49fd','{\"displayTitle\":\"Mandibule 1.7.6.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-21 10:18:54.524','2024-05-21 08:18:54.804','2024-05-21 10:18:56.423'),('c60f2934-06ed-11ef-90c8-dd3986f53a42',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_4dd3e575-06ed-11ef-90c8-dd3986f53a42/order_4dd5f101-06ed-11ef-90c8-dd3986f53a42/c60f2934-06ed-11ef-90c8-dd3986f53a42.pdf','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_4dd3e575-06ed-11ef-90c8-dd3986f53a42_PROST_4dd5f101-06ed-11ef-90c8-dd3986f53a42_FORM','c60f2934-06ed-11ef-90c8-dd3986f53a42.pdf','97508969-06ed-11ef-90c8-dd3986f53a42','{\"displayTitle\":\"Commande 1.1.1.1 Facette\",\"title\":\"Facette\"}','PDF',1,'SYNCED',0,NULL,'2024-04-30 14:32:58.000','2024-04-30 12:32:58.000','2024-04-30 14:32:58.000'),('c6ed76b0-1dc9-11ef-8f99-d92a46e09137',14,'/var/iris/.data/2024/14/c6dd7b08-1dc9-11ef-8f99-d92a46e09137/session_c6ecdf7f-1dc9-11ef-8f99-d92a46e09137/occlusion_c6ed23a8-1dc9-11ef-8f99-d92a46e09137/scan_c6ed67bf-1dc9-11ef-8f99-d92a46e09137/c6ed76b0-1dc9-11ef-8f99-d92a46e09137.zip','PATIENT_c6dd7b08-1dc9-11ef-8f99-d92a46e09137_ACT_c6ecdf7f-1dc9-11ef-8f99-d92a46e09137_SESS_c6ed23a8-1dc9-11ef-8f99-d92a46e09137_TOSC_c6ed67bf-1dc9-11ef-8f99-d92a46e09137_MODEL','c6ed76b0-1dc9-11ef-8f99-d92a46e09137.zip','c6ed76b0-1dc9-11ef-8f99-d92a46e09137','{\"displayTitle\":\"Maxillaire 1.1.1.1.1\",\"modelMatrix\":\"0.979412,0.193087,-0.0588964,0,-0.185851,0.748568,-0.636479,0,-0.0788078,0.634321,0.769042,0,-18.6321,-11.2556,-10.2485,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-29 16:43:13.485','2024-05-29 14:43:13.517','2024-05-29 16:43:15.005'),('c6f234cd-1dc9-11ef-8f99-d92a46e09137',14,'/var/iris/.data/2024/14/c6dd7b08-1dc9-11ef-8f99-d92a46e09137/session_c6ecdf7f-1dc9-11ef-8f99-d92a46e09137/occlusion_c6ed23a8-1dc9-11ef-8f99-d92a46e09137/scan_c6ed67bf-1dc9-11ef-8f99-d92a46e09137/c6f234cd-1dc9-11ef-8f99-d92a46e09137.png','PATIENT_c6dd7b08-1dc9-11ef-8f99-d92a46e09137_ACT_c6ecdf7f-1dc9-11ef-8f99-d92a46e09137_SESS_c6ed23a8-1dc9-11ef-8f99-d92a46e09137_TOSC_c6ed67bf-1dc9-11ef-8f99-d92a46e09137_SNAPS','c6f234cd-1dc9-11ef-8f99-d92a46e09137.png','c6f234cd-1dc9-11ef-8f99-d92a46e09137','{\"displayTitle\":\"Maxillaire 1.1.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-29 16:43:13.516','2024-05-29 14:43:13.518','2024-05-29 16:43:17.370'),('c6f3ba52-1dc9-11ef-8f99-d92a46e09137',14,'/var/iris/.data/2024/14/c6dd7b08-1dc9-11ef-8f99-d92a46e09137/session_c6ecdf7f-1dc9-11ef-8f99-d92a46e09137/occlusion_c6ed23a8-1dc9-11ef-8f99-d92a46e09137/scan_c6f3aa83-1dc9-11ef-8f99-d92a46e09137/c6f3ba52-1dc9-11ef-8f99-d92a46e09137.zip','PATIENT_c6dd7b08-1dc9-11ef-8f99-d92a46e09137_ACT_c6ecdf7f-1dc9-11ef-8f99-d92a46e09137_SESS_c6ed23a8-1dc9-11ef-8f99-d92a46e09137_BOSC_c6f3aa83-1dc9-11ef-8f99-d92a46e09137_MODEL','c6f3ba52-1dc9-11ef-8f99-d92a46e09137.zip','c6f3ba52-1dc9-11ef-8f99-d92a46e09137','{\"displayTitle\":\"Mandibule 1.1.1.1.1\",\"modelMatrix\":\"0.989354,-0.138659,-0.0441867,0,0.138295,0.990328,-0.0112196,0,0.045315,0.00498938,0.99896,0,-17.3085,-2.30894,-16.4005,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-29 16:43:13.526','2024-05-29 14:43:13.558','2024-05-29 16:43:17.739'),('c6f86b86-1dc9-11ef-8f99-d92a46e09137',14,'/var/iris/.data/2024/14/c6dd7b08-1dc9-11ef-8f99-d92a46e09137/session_c6ecdf7f-1dc9-11ef-8f99-d92a46e09137/occlusion_c6ed23a8-1dc9-11ef-8f99-d92a46e09137/scan_c6f3aa83-1dc9-11ef-8f99-d92a46e09137/c6f86b86-1dc9-11ef-8f99-d92a46e09137.png','PATIENT_c6dd7b08-1dc9-11ef-8f99-d92a46e09137_ACT_c6ecdf7f-1dc9-11ef-8f99-d92a46e09137_SESS_c6ed23a8-1dc9-11ef-8f99-d92a46e09137_BOSC_c6f3aa83-1dc9-11ef-8f99-d92a46e09137_SNAPS','c6f86b86-1dc9-11ef-8f99-d92a46e09137.png','c6f86b86-1dc9-11ef-8f99-d92a46e09137','{\"displayTitle\":\"Mandibule 1.1.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-29 16:43:13.557','2024-05-29 14:43:13.559','2024-05-29 16:43:18.705'),('c6f959d7-1dc9-11ef-8f99-d92a46e09137',14,'/var/iris/.data/2024/14/c6dd7b08-1dc9-11ef-8f99-d92a46e09137/session_c6ecdf7f-1dc9-11ef-8f99-d92a46e09137/occlusion_c6ed23a8-1dc9-11ef-8f99-d92a46e09137/computedocclusion_c6f93b4f-1dc9-11ef-8f99-d92a46e09137/c6f959d7-1dc9-11ef-8f99-d92a46e09137.zip','PATIENT_c6dd7b08-1dc9-11ef-8f99-d92a46e09137_ACT_c6ecdf7f-1dc9-11ef-8f99-d92a46e09137_SESS_c6ed23a8-1dc9-11ef-8f99-d92a46e09137_OCC_c6f93b4f-1dc9-11ef-8f99-d92a46e09137_TOPLY','c6f959d7-1dc9-11ef-8f99-d92a46e09137.zip','c6f959d7-1dc9-11ef-8f99-d92a46e09137','{\"displayTitle\":\"Occlusion 1.1.1.1.1 Maxillaire\",\"modelMatrix\":\"0.979412,0.193087,-0.0588964,0,-0.185851,0.748568,-0.636479,0,-0.0788078,0.634321,0.769042,0,-18.6321,-11.2556,-10.2485,1\",\"occlusionMatrix\":\"0.996872,-0.0756274,-0.0231404,0,0.0296807,0.0865358,0.995805,0,-0.0733074,-0.993376,0.088508,0,-17.2672,10.7574,0.804369,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.1.1.1.1\",\"referenceScanId\":\"a6dfd269-1dc4-11ef-8e10-d517f279883e\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-29 16:43:13.563','2024-05-29 14:43:13.625','2024-05-29 16:43:18.831'),('c6fddf69-1dc9-11ef-8f99-d92a46e09137',14,'/var/iris/.data/2024/14/c6dd7b08-1dc9-11ef-8f99-d92a46e09137/session_c6ecdf7f-1dc9-11ef-8f99-d92a46e09137/occlusion_c6ed23a8-1dc9-11ef-8f99-d92a46e09137/computedocclusion_c6f93b4f-1dc9-11ef-8f99-d92a46e09137/c6fddf69-1dc9-11ef-8f99-d92a46e09137.zip','PATIENT_c6dd7b08-1dc9-11ef-8f99-d92a46e09137_ACT_c6ecdf7f-1dc9-11ef-8f99-d92a46e09137_SESS_c6ed23a8-1dc9-11ef-8f99-d92a46e09137_OCC_c6f93b4f-1dc9-11ef-8f99-d92a46e09137_BOPLY','c6fddf69-1dc9-11ef-8f99-d92a46e09137.zip','c6fddf69-1dc9-11ef-8f99-d92a46e09137','{\"displayTitle\":\"Occlusion 1.1.1.1.1 Mandibule\",\"modelMatrix\":\"0.989354,-0.138659,-0.0441867,0,0.138295,0.990328,-0.0112196,0,0.045315,0.00498938,0.99896,0,-17.3085,-2.30894,-16.4005,1\",\"occlusionMatrix\":\"0.97923,-0.156891,0.128435,0,0.122735,-0.0455304,-0.991399,0,0.161389,0.986565,-0.025327,0,-20.5227,-10.1083,2.79494,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.1.1.1.1\",\"referenceScanId\":\"e603f241-1dc4-11ef-8e10-d517f279883e\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-29 16:43:13.593','2024-05-29 14:43:13.626','2024-05-29 16:43:19.865'),('c7029c5e-1dc9-11ef-8f99-d92a46e09137',14,'/var/iris/.data/2024/14/c6dd7b08-1dc9-11ef-8f99-d92a46e09137/session_c6ecdf7f-1dc9-11ef-8f99-d92a46e09137/occlusion_c6ed23a8-1dc9-11ef-8f99-d92a46e09137/computedocclusion_c6f93b4f-1dc9-11ef-8f99-d92a46e09137/c7029c5e-1dc9-11ef-8f99-d92a46e09137.png','PATIENT_c6dd7b08-1dc9-11ef-8f99-d92a46e09137_ACT_c6ecdf7f-1dc9-11ef-8f99-d92a46e09137_SESS_c6ed23a8-1dc9-11ef-8f99-d92a46e09137_OCC_c6f93b4f-1dc9-11ef-8f99-d92a46e09137_SNAPO','c7029c5e-1dc9-11ef-8f99-d92a46e09137.png','c7029c5e-1dc9-11ef-8f99-d92a46e09137','{\"displayTitle\":\"Occlusion 1.1.1.1.1 Snapshot\",\"occlusionType\":1}','PNG',0,'SYNCED',0,NULL,'2024-05-29 16:43:13.624','2024-05-29 14:43:13.626','2024-05-29 16:43:20.592'),('ce611e03-1466-11ef-8f1b-d8242b6da0dc',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_f0721624-144c-11ef-8f1b-d8242b6da0dc/occlusion_f073b964-144c-11ef-8f1b-d8242b6da0dc/scan_a404f782-1466-11ef-8f1b-d8242b6da0dc/ce611e03-1466-11ef-8f1b-d8242b6da0dc.zip','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_f0721624-144c-11ef-8f1b-d8242b6da0dc_SESS_f073b964-144c-11ef-8f1b-d8242b6da0dc_TOSC_a404f782-1466-11ef-8f1b-d8242b6da0dc_MODEL','ce611e03-1466-11ef-8f1b-d8242b6da0dc.zip','ce611e03-1466-11ef-8f1b-d8242b6da0dc','{\"displayTitle\":\"Maxillaire 1.7.1.1.1\",\"modelMatrix\":\"0.997106,0.0729967,-0.0212224,0,-0.075111,0.989048,-0.127055,0,0.0117154,0.128282,0.991669,0,-18.527,-1.81532,-18.6027,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-17 18:02:08.000','2024-05-17 16:08:02.000','2024-05-17 18:08:02.000'),('ce613798-1466-11ef-8f1b-d8242b6da0dc',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_f0721624-144c-11ef-8f1b-d8242b6da0dc/occlusion_f073b964-144c-11ef-8f1b-d8242b6da0dc/scan_a404f782-1466-11ef-8f1b-d8242b6da0dc/ce613798-1466-11ef-8f1b-d8242b6da0dc.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_f0721624-144c-11ef-8f1b-d8242b6da0dc_SESS_f073b964-144c-11ef-8f1b-d8242b6da0dc_TOSC_a404f782-1466-11ef-8f1b-d8242b6da0dc_SNAPS','ce613798-1466-11ef-8f1b-d8242b6da0dc.png','ce613798-1466-11ef-8f1b-d8242b6da0dc','{\"displayTitle\":\"Maxillaire 1.7.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-17 18:02:09.000','2024-05-17 16:08:02.000','2024-05-17 18:08:02.000'),('ce77d355-0953-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_67fc2b93-0953-11ef-8f65-d9283bb1c6cd/occlusion_67fdc886-0953-11ef-8f65-d9283bb1c6cd/scan_abdf5c98-0953-11ef-8f65-d9283bb1c6cd/ce77d355-0953-11ef-8f65-d9283bb1c6cd.zip','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_67fc2b93-0953-11ef-8f65-d9283bb1c6cd_SESS_67fdc886-0953-11ef-8f65-d9283bb1c6cd_LESC_abdf5c98-0953-11ef-8f65-d9283bb1c6cd_MODEL','ce77d355-0953-11ef-8f65-d9283bb1c6cd.zip','ce77d355-0953-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Mordu gauche 1.2.7.1.1\",\"modelMatrix\":\"-0.999468,0.026809,0.0172465,0,-0.0268922,-0.99963,0.00505065,0,0.0184928,0.00454482,0.999839,0,-9.73812,3.3345,-17.3499,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-03 15:48:22.909','2024-05-03 13:48:23.180','2024-05-03 15:48:26.064'),('ce77e28b-0953-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_67fc2b93-0953-11ef-8f65-d9283bb1c6cd/occlusion_67fdc886-0953-11ef-8f65-d9283bb1c6cd/scan_abdf5c98-0953-11ef-8f65-d9283bb1c6cd/ce77e28b-0953-11ef-8f65-d9283bb1c6cd.png','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_67fc2b93-0953-11ef-8f65-d9283bb1c6cd_SESS_67fdc886-0953-11ef-8f65-d9283bb1c6cd_LESC_abdf5c98-0953-11ef-8f65-d9283bb1c6cd_SNAPS','ce77e28b-0953-11ef-8f65-d9283bb1c6cd.png','ce77e28b-0953-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Mordu gauche 1.2.7.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-03 15:48:22.910','2024-05-03 13:48:23.183','2024-05-03 15:48:28.278'),('ceb4b079-0957-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_0a477976-0952-11ef-8f65-d9283bb1c6cd/analyse_32ad8516-0957-11ef-8f65-d9283bb1c6cd/ceb4b079-0957-11ef-8f65-d9283bb1c6cd.png','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_0a477976-0952-11ef-8f65-d9283bb1c6cd_ANA_32ad8516-0957-11ef-8f65-d9283bb1c6cd_SCREENS','ceb4b079-0957-11ef-8f65-d9283bb1c6cd.png','ceb4b079-0957-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Comparaison 1.2.5.2 Capture d\'écran 1\",\"title\":\"1\"}','PNG',0,'SYNCED',0,NULL,'2024-05-03 16:17:01.295','2024-05-03 14:17:01.363','2024-05-03 16:17:01.392'),('d0c9b40d-1cf1-11ef-8f68-d9283cb4d201',6,'/var/iris/.data/2024/6/8578524d-1cf1-11ef-8f68-d9283cb4d201/session_894496db-1cf1-11ef-8f68-d9283cb4d201/occlusion_89463d55-1cf1-11ef-8f68-d9283cb4d201/scan_994f08c1-1cf1-11ef-8f68-d9283cb4d201/d0c9b40d-1cf1-11ef-8f68-d9283cb4d201.zip','PATIENT_8578524d-1cf1-11ef-8f68-d9283cb4d201_ACT_894496db-1cf1-11ef-8f68-d9283cb4d201_SESS_89463d55-1cf1-11ef-8f68-d9283cb4d201_TOSC_994f08c1-1cf1-11ef-8f68-d9283cb4d201_MODEL','d0c9b40d-1cf1-11ef-8f68-d9283cb4d201.zip','d0c9b40d-1cf1-11ef-8f68-d9283cb4d201','{\"displayTitle\":\"Maxillaire 1.2.1.1.1\",\"modelMatrix\":\"-0.438456,0.89548,-0.0766271,0,-0.820426,-0.433598,-0.372685,0,-0.366957,-0.100539,0.924789,0,15.3421,-3.85399,-15.7501,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-28 14:57:21.000','2024-05-28 12:57:21.000','2024-05-28 14:57:21.000'),('d0c9cbb2-1cf1-11ef-8f68-d9283cb4d201',6,'/var/iris/.data/2024/6/8578524d-1cf1-11ef-8f68-d9283cb4d201/session_894496db-1cf1-11ef-8f68-d9283cb4d201/occlusion_89463d55-1cf1-11ef-8f68-d9283cb4d201/scan_994f08c1-1cf1-11ef-8f68-d9283cb4d201/d0c9cbb2-1cf1-11ef-8f68-d9283cb4d201.png','PATIENT_8578524d-1cf1-11ef-8f68-d9283cb4d201_ACT_894496db-1cf1-11ef-8f68-d9283cb4d201_SESS_89463d55-1cf1-11ef-8f68-d9283cb4d201_TOSC_994f08c1-1cf1-11ef-8f68-d9283cb4d201_SNAPS','d0c9cbb2-1cf1-11ef-8f68-d9283cb4d201.png','d0c9cbb2-1cf1-11ef-8f68-d9283cb4d201','{\"displayTitle\":\"Maxillaire 1.2.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-28 14:57:21.000','2024-05-28 12:57:21.000','2024-05-28 14:57:21.000'),('d1385fb9-0952-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_4fc2347a-0952-11ef-8f65-d9283bb1c6cd/occlusion_4fc3d0e6-0952-11ef-8f65-d9283bb1c6cd/computedocclusion_9248b871-0952-11ef-8f65-d9283bb1c6cd/d1385fb9-0952-11ef-8f65-d9283bb1c6cd.zip','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_4fc2347a-0952-11ef-8f65-d9283bb1c6cd_SESS_4fc3d0e6-0952-11ef-8f65-d9283bb1c6cd_OCC_9248b871-0952-11ef-8f65-d9283bb1c6cd_TOPLY','d1385fb9-0952-11ef-8f65-d9283bb1c6cd.zip','d1385fb9-0952-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Occlusion 1.2.6.1.1 Maxillaire\",\"modelMatrix\":\"0.774981,0.631095,0.033522,0,-0.62835,0.77512,-0.0660793,0,-0.0676859,0.0301467,0.997251,0,-4.63707,-4.79452,-18.5136,1\",\"occlusionMatrix\":\"0.986433,-0.095286,-0.132897,0,0.135468,0.0247565,0.990426,0,-0.0927888,-0.995145,0.0373738,0,-14.1037,15.4034,2.93421,1\",\"occlusionType\":1,\"referenceScanId\":\"53557eda-0952-11ef-8f65-d9283bb1c6cd\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-03 15:41:18.030','2024-05-03 13:41:18.324','2024-05-03 15:41:19.015'),('d14eaa57-0952-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_4fc2347a-0952-11ef-8f65-d9283bb1c6cd/occlusion_4fc3d0e6-0952-11ef-8f65-d9283bb1c6cd/computedocclusion_9248b871-0952-11ef-8f65-d9283bb1c6cd/d14eaa57-0952-11ef-8f65-d9283bb1c6cd.zip','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_4fc2347a-0952-11ef-8f65-d9283bb1c6cd_SESS_4fc3d0e6-0952-11ef-8f65-d9283bb1c6cd_OCC_9248b871-0952-11ef-8f65-d9283bb1c6cd_BOPLY','d14eaa57-0952-11ef-8f65-d9283bb1c6cd.zip','d14eaa57-0952-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Occlusion 1.2.6.1.1 Mandibule\",\"modelMatrix\":\"-0.579656,-0.811627,-0.0725353,0,0.789557,-0.581437,0.196293,0,-0.201491,0.0565115,0.977859,0,7.961,8.851,-17.9466,1\",\"occlusionMatrix\":\"0.995511,-0.051314,-0.0788392,0,-0.0774185,0.0211279,-0.996742,0,0.054504,0.99846,0.0170306,0,-18.2908,-13.6971,5.77329,1\",\"occlusionType\":1,\"referenceScanId\":\"7564b229-0952-11ef-8f65-d9283bb1c6cd\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-03 15:41:18.176','2024-05-03 13:41:18.326','2024-05-03 15:41:21.381'),('d1cb1f63-0952-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_4fc2347a-0952-11ef-8f65-d9283bb1c6cd/occlusion_4fc3d0e6-0952-11ef-8f65-d9283bb1c6cd/computedocclusion_9248b871-0952-11ef-8f65-d9283bb1c6cd/d1cb1f63-0952-11ef-8f65-d9283bb1c6cd.png','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_4fc2347a-0952-11ef-8f65-d9283bb1c6cd_SESS_4fc3d0e6-0952-11ef-8f65-d9283bb1c6cd_OCC_9248b871-0952-11ef-8f65-d9283bb1c6cd_SNAPO','d1cb1f63-0952-11ef-8f65-d9283bb1c6cd.png','d1cb1f63-0952-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Occlusion 1.2.6.1.1 Snapshot\",\"occlusionType\":1}','PNG',0,'SYNCED',0,NULL,'2024-05-03 15:41:18.992','2024-05-03 13:41:18.994','2024-05-03 15:41:23.591'),('d1d98002-0953-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_67fc2b93-0953-11ef-8f65-d9283bb1c6cd/occlusion_67fdc886-0953-11ef-8f65-d9283bb1c6cd/computedocclusion_ab083f2a-0953-11ef-8f65-d9283bb1c6cd/d1d98002-0953-11ef-8f65-d9283bb1c6cd.zip','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_67fc2b93-0953-11ef-8f65-d9283bb1c6cd_SESS_67fdc886-0953-11ef-8f65-d9283bb1c6cd_OCC_ab083f2a-0953-11ef-8f65-d9283bb1c6cd_TOPLY','d1d98002-0953-11ef-8f65-d9283bb1c6cd.zip','d1d98002-0953-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Occlusion 1.2.7.1.1 Maxillaire\",\"modelMatrix\":\"0.999879,0.0145411,-0.00550569,0,-0.0145287,0.999892,0.0022888,0,0.00553838,-0.00220853,0.999982,0,-10.8611,0.221993,-18.0198,1\",\"occlusionMatrix\":\"-0.998214,0.0068079,-0.0593854,0,0.0578072,-0.142861,-0.988053,0,-0.0152104,-0.989721,0.142212,0,8.13233,14.0377,-3.1657,1\",\"occlusionType\":2,\"referenceScanId\":\"69c3c2e3-0953-11ef-8f65-d9283bb1c6cd\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-03 15:48:31.000','2024-05-03 14:05:33.000','2024-05-03 16:05:33.000'),('d1f26a61-0953-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_67fc2b93-0953-11ef-8f65-d9283bb1c6cd/occlusion_67fdc886-0953-11ef-8f65-d9283bb1c6cd/computedocclusion_ab083f2a-0953-11ef-8f65-d9283bb1c6cd/d1f26a61-0953-11ef-8f65-d9283bb1c6cd.zip','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_67fc2b93-0953-11ef-8f65-d9283bb1c6cd_SESS_67fdc886-0953-11ef-8f65-d9283bb1c6cd_OCC_ab083f2a-0953-11ef-8f65-d9283bb1c6cd_BOPLY','d1f26a61-0953-11ef-8f65-d9283bb1c6cd.zip','d1f26a61-0953-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Occlusion 1.2.7.1.1 Mandibule\",\"modelMatrix\":\"0.975206,0.219802,-0.0256813,0,-0.218098,0.934959,-0.279792,0,-0.0374879,0.278456,0.959717,0,-4.11951,-8.78935,-16.8342,1\",\"occlusionMatrix\":\"-0.990283,0.0534808,-0.12842,0,-0.121616,0.115364,0.985854,0,0.0675388,0.991887,-0.107739,0,7.58796,-14.9673,1.08742,1\",\"occlusionType\":2,\"referenceScanId\":\"8384e76f-0953-11ef-8f65-d9283bb1c6cd\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-03 15:48:34.000','2024-05-03 14:05:34.000','2024-05-03 16:05:34.000'),('d26c0218-0953-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_67fc2b93-0953-11ef-8f65-d9283bb1c6cd/occlusion_67fdc886-0953-11ef-8f65-d9283bb1c6cd/computedocclusion_ab083f2a-0953-11ef-8f65-d9283bb1c6cd/d26c0218-0953-11ef-8f65-d9283bb1c6cd.png','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_67fc2b93-0953-11ef-8f65-d9283bb1c6cd_SESS_67fdc886-0953-11ef-8f65-d9283bb1c6cd_OCC_ab083f2a-0953-11ef-8f65-d9283bb1c6cd_SNAPO','d26c0218-0953-11ef-8f65-d9283bb1c6cd.png','d26c0218-0953-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Occlusion 1.2.7.1.1 Snapshot\",\"occlusionType\":2}','PNG',0,'SYNCED',0,NULL,'2024-05-03 15:48:34.000','2024-05-03 14:05:34.000','2024-05-03 16:05:34.000'),('d65d389b-1825-11ef-8f8e-d92a44d6667d',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_f5aa8d87-1824-11ef-8f8e-d92a44d6667d/occlusion_f5ac369c-1824-11ef-8f8e-d92a44d6667d/scan_6aa13fb3-1825-11ef-8f8e-d92a44d6667d/d65d389b-1825-11ef-8f8e-d92a44d6667d.zip','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_f5aa8d87-1824-11ef-8f8e-d92a44d6667d_SESS_f5ac369c-1824-11ef-8f8e-d92a44d6667d_TOSC_6aa13fb3-1825-11ef-8f8e-d92a44d6667d_MODEL','d65d389b-1825-11ef-8f8e-d92a44d6667d.zip','d65d389b-1825-11ef-8f8e-d92a44d6667d','{\"displayTitle\":\"Maxillaire 1.7.7.1.1\",\"modelMatrix\":\"-0.342447,-0.939161,0.0265733,0,0.919438,-0.340806,-0.196173,0,0.193294,-0.0427464,0.980209,0,17.6118,8.81057,-19.7918,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-22 12:27:06.106','2024-05-22 10:27:07.115','2024-05-22 12:27:26.242'),('d65d5317-1825-11ef-8f8e-d92a44d6667d',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_f5aa8d87-1824-11ef-8f8e-d92a44d6667d/occlusion_f5ac369c-1824-11ef-8f8e-d92a44d6667d/scan_6aa13fb3-1825-11ef-8f8e-d92a44d6667d/d65d5317-1825-11ef-8f8e-d92a44d6667d.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_f5aa8d87-1824-11ef-8f8e-d92a44d6667d_SESS_f5ac369c-1824-11ef-8f8e-d92a44d6667d_TOSC_6aa13fb3-1825-11ef-8f8e-d92a44d6667d_SNAPS','d65d5317-1825-11ef-8f8e-d92a44d6667d.png','d65d5317-1825-11ef-8f8e-d92a44d6667d','{\"displayTitle\":\"Maxillaire 1.7.7.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-22 12:27:06.107','2024-05-22 10:27:07.115','2024-05-22 12:27:28.933'),('d88962f2-0863-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_59e98ac5-0861-11ef-8ff6-da2f5a35fe58/d88962f2-0863-11ef-8ff6-da2f5a35fe58.xyz','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_TOSC_59e98ac5-0861-11ef-8ff6-da2f5a35fe58_LIFI','d88962f2-0863-11ef-8ff6-da2f5a35fe58.xyz','d88962f2-0863-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Maxillaire 1.1.2.1.1 Ligne de finition 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,'2024-05-02 11:10:45.251','2024-05-02 11:10:39.944','2024-05-02 09:10:45.252','2024-05-02 11:10:45.261'),('d88967ff-0863-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_59e98ac5-0861-11ef-8ff6-da2f5a35fe58/d88967ff-0863-11ef-8ff6-da2f5a35fe58.bin','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_TOSC_59e98ac5-0861-11ef-8ff6-da2f5a35fe58_LIFIM','d88967ff-0863-11ef-8ff6-da2f5a35fe58.bin','d88967ff-0863-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Maxillaire 1.1.2.1.1 Ligne de finition métadonnées 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,'2024-05-02 11:10:45.251','2024-05-02 11:10:39.944','2024-05-02 09:10:45.252','2024-05-02 11:10:45.262'),('dac26566-1843-11ef-8f8e-d92a44d6667d',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_f5aa8d87-1824-11ef-8f8e-d92a44d6667d/occlusion_f5ac369c-1824-11ef-8f8e-d92a44d6667d/scan_6aa13fb3-1825-11ef-8f8e-d92a44d6667d/dac26566-1843-11ef-8f8e-d92a44d6667d.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_f5aa8d87-1824-11ef-8f8e-d92a44d6667d_SESS_f5ac369c-1824-11ef-8f8e-d92a44d6667d_TOSC_6aa13fb3-1825-11ef-8f8e-d92a44d6667d_SCREENS','dac26566-1843-11ef-8f8e-d92a44d6667d.png','dac26566-1843-11ef-8f8e-d92a44d6667d','{\"displayTitle\":\"Maxillaire 1.7.7.1.1 Capture d\'écran 1\",\"title\":\"1\"}','PNG',0,'SYNCED',0,'2024-05-22 16:02:11.998','2024-05-22 16:02:11.998','2024-05-22 14:02:11.999','2024-05-22 16:02:12.008'),('db87bf87-1749-11ef-8f86-d92942cf49fd',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_b1ce9a22-1749-11ef-8f86-d92942cf49fd/occlusion_b1d043a8-1749-11ef-8f86-d92942cf49fd/scan_b2fd8f6c-1749-11ef-8f86-d92942cf49fd/db87bf87-1749-11ef-8f86-d92942cf49fd.zip','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_b1ce9a22-1749-11ef-8f86-d92942cf49fd_SESS_b1d043a8-1749-11ef-8f86-d92942cf49fd_TOSC_b2fd8f6c-1749-11ef-8f86-d92942cf49fd_MODEL','db87bf87-1749-11ef-8f86-d92942cf49fd.zip','db87bf87-1749-11ef-8f86-d92942cf49fd','{\"displayTitle\":\"Maxillaire 1.7.6.1.1\",\"modelMatrix\":\"0.983594,0.148421,-0.102541,0,-0.180193,0.835416,-0.51924,0,0.008598,0.529198,0.848454,0,13.5602,-14.0966,-17.5164,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-21 10:12:25.493','2024-05-21 08:12:25.843','2024-05-21 10:12:27.552'),('db87d2f4-1749-11ef-8f86-d92942cf49fd',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_b1ce9a22-1749-11ef-8f86-d92942cf49fd/occlusion_b1d043a8-1749-11ef-8f86-d92942cf49fd/scan_b2fd8f6c-1749-11ef-8f86-d92942cf49fd/db87d2f4-1749-11ef-8f86-d92942cf49fd.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_b1ce9a22-1749-11ef-8f86-d92942cf49fd_SESS_b1d043a8-1749-11ef-8f86-d92942cf49fd_TOSC_b2fd8f6c-1749-11ef-8f86-d92942cf49fd_SNAPS','db87d2f4-1749-11ef-8f86-d92942cf49fd.png','db87d2f4-1749-11ef-8f86-d92942cf49fd','{\"displayTitle\":\"Maxillaire 1.7.6.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-21 10:12:25.493','2024-05-21 08:12:25.843','2024-05-21 10:12:28.991'),('dc978755-0957-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_0a477976-0952-11ef-8f65-d9283bb1c6cd/analyse_32ad8516-0957-11ef-8f65-d9283bb1c6cd/dc978755-0957-11ef-8f65-d9283bb1c6cd.png','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_0a477976-0952-11ef-8f65-d9283bb1c6cd_ANA_32ad8516-0957-11ef-8f65-d9283bb1c6cd_SCREENS','dc978755-0957-11ef-8f65-d9283bb1c6cd.png','dc978755-0957-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Comparaison 1.2.5.2 Capture d\'écran 2\",\"title\":\"2\"}','PNG',0,'SYNCED',0,NULL,'2024-05-03 16:17:24.592','2024-05-03 14:17:24.657','2024-05-03 16:17:24.690'),('dcd75868-1843-11ef-8f8e-d92a44d6667d',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_f5aa8d87-1824-11ef-8f8e-d92a44d6667d/occlusion_f5ac369c-1824-11ef-8f8e-d92a44d6667d/scan_6aa13fb3-1825-11ef-8f8e-d92a44d6667d/dcd75868-1843-11ef-8f8e-d92a44d6667d.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_f5aa8d87-1824-11ef-8f8e-d92a44d6667d_SESS_f5ac369c-1824-11ef-8f8e-d92a44d6667d_TOSC_6aa13fb3-1825-11ef-8f8e-d92a44d6667d_SCREENS','dcd75868-1843-11ef-8f8e-d92a44d6667d.png','dcd75868-1843-11ef-8f8e-d92a44d6667d','{\"displayTitle\":\"Maxillaire 1.7.7.1.1 Capture d\'écran 2\",\"title\":\"2\"}','PNG',0,'SYNCED',0,'2024-05-22 16:02:13.659','2024-05-22 16:02:13.659','2024-05-22 14:02:13.659','2024-05-22 16:02:13.669'),('dd1cfe26-0956-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_67fc2b93-0953-11ef-8f65-d9283bb1c6cd/occlusion_67fdc886-0953-11ef-8f65-d9283bb1c6cd/computedocclusion_ab083f2a-0953-11ef-8f65-d9283bb1c6cd/dd1cfe26-0956-11ef-8f65-d9283bb1c6cd.png','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_67fc2b93-0953-11ef-8f65-d9283bb1c6cd_SESS_67fdc886-0953-11ef-8f65-d9283bb1c6cd_OCC_ab083f2a-0953-11ef-8f65-d9283bb1c6cd_SCREENO','dd1cfe26-0956-11ef-8f65-d9283bb1c6cd.png','dd1cfe26-0956-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Occlusion 1.2.7.1.1 Capture d\'écran 2\",\"occlusionType\":2,\"title\":\"2\"}','PNG',0,'SYNCED',0,NULL,'2024-05-03 16:10:15.970','2024-05-03 14:10:16.030','2024-05-03 16:10:16.054'),('ded13a58-1843-11ef-8f8e-d92a44d6667d',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_f5aa8d87-1824-11ef-8f8e-d92a44d6667d/occlusion_f5ac369c-1824-11ef-8f8e-d92a44d6667d/scan_6aa13fb3-1825-11ef-8f8e-d92a44d6667d/ded13a58-1843-11ef-8f8e-d92a44d6667d.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_f5aa8d87-1824-11ef-8f8e-d92a44d6667d_SESS_f5ac369c-1824-11ef-8f8e-d92a44d6667d_TOSC_6aa13fb3-1825-11ef-8f8e-d92a44d6667d_SCREENS','ded13a58-1843-11ef-8f8e-d92a44d6667d.png','ded13a58-1843-11ef-8f8e-d92a44d6667d','{\"displayTitle\":\"Maxillaire 1.7.7.1.1 Capture d\'écran 3\",\"title\":\"3\"}','PNG',0,'SYNCED',0,'2024-05-22 16:02:15.422','2024-05-22 16:02:15.423','2024-05-22 14:02:15.423','2024-05-22 16:02:15.432'),('df31bbd6-0957-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_0a477976-0952-11ef-8f65-d9283bb1c6cd/analyse_0a4b0ffa-0952-11ef-8f65-d9283bb1c6cd/df31bbd6-0957-11ef-8f65-d9283bb1c6cd.png','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_0a477976-0952-11ef-8f65-d9283bb1c6cd_ANA_0a4b0ffa-0952-11ef-8f65-d9283bb1c6cd_SCREENS','df31bbd6-0957-11ef-8f65-d9283bb1c6cd.png','df31bbd6-0957-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Mesures 1.2.5.1 Capture d\'écran 1\",\"title\":\"1\"}','PNG',0,'SYNCED',0,NULL,'2024-05-03 16:17:28.958','2024-05-03 14:17:29.023','2024-05-03 16:17:29.050'),('df977aae-0956-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_67fc2b93-0953-11ef-8f65-d9283bb1c6cd/occlusion_67fdc886-0953-11ef-8f65-d9283bb1c6cd/computedocclusion_ab083f2a-0953-11ef-8f65-d9283bb1c6cd/df977aae-0956-11ef-8f65-d9283bb1c6cd.json','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_67fc2b93-0953-11ef-8f65-d9283bb1c6cd_SESS_67fdc886-0953-11ef-8f65-d9283bb1c6cd_OCC_ab083f2a-0953-11ef-8f65-d9283bb1c6cd_METER','df977aae-0956-11ef-8f65-d9283bb1c6cd.json','df977aae-0956-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Occlusion 1.2.7.1.1 Mesure\",\"occlusionType\":2}','JSON',0,'SYNCED',0,NULL,'2024-05-03 16:10:20.128','2024-05-03 14:10:20.130','2024-05-03 16:10:20.139'),('dfaf3432-1825-11ef-8f8e-d92a44d6667d',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_f5aa8d87-1824-11ef-8f8e-d92a44d6667d/occlusion_f5ac369c-1824-11ef-8f8e-d92a44d6667d/scan_6aa13fb3-1825-11ef-8f8e-d92a44d6667d/dfaf3432-1825-11ef-8f8e-d92a44d6667d.ply','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_f5aa8d87-1824-11ef-8f8e-d92a44d6667d_SESS_f5ac369c-1824-11ef-8f8e-d92a44d6667d_TOSC_6aa13fb3-1825-11ef-8f8e-d92a44d6667d_SEG','dfaf3432-1825-11ef-8f8e-d92a44d6667d.ply','dfaf3432-1825-11ef-8f8e-d92a44d6667d','{\"displayTitle\":\"Maxillaire 1.7.7.1.1 Segmentation\"}','PLY',0,'SYNCED',0,NULL,'2024-05-22 12:27:21.743','2024-05-22 10:27:21.775','2024-05-22 12:27:29.547'),('e0bfa86b-0863-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_59e98ac5-0861-11ef-8ff6-da2f5a35fe58/e0bfa86b-0863-11ef-8ff6-da2f5a35fe58.xyz','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_TOSC_59e98ac5-0861-11ef-8ff6-da2f5a35fe58_LIFI','e0bfa86b-0863-11ef-8ff6-da2f5a35fe58.xyz','e0bfa86b-0863-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Maxillaire 1.1.2.1.1 Ligne de finition 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-05-02 11:10:53.721','2024-05-02 09:10:53.724','2024-05-02 11:10:53.730'),('e0bfadf4-0863-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_59e98ac5-0861-11ef-8ff6-da2f5a35fe58/e0bfadf4-0863-11ef-8ff6-da2f5a35fe58.bin','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_TOSC_59e98ac5-0861-11ef-8ff6-da2f5a35fe58_LIFIM','e0bfadf4-0863-11ef-8ff6-da2f5a35fe58.bin','e0bfadf4-0863-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Maxillaire 1.1.2.1.1 Ligne de finition métadonnées 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-05-02 11:10:54.000','2024-05-02 09:10:54.000','2024-05-02 11:10:54.000'),('e0fd50b7-1749-11ef-8f86-d92942cf49fd',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_b1ce9a22-1749-11ef-8f86-d92942cf49fd/occlusion_b1d043a8-1749-11ef-8f86-d92942cf49fd/scan_e0fd2566-1749-11ef-8f86-d92942cf49fd/e0fd50b7-1749-11ef-8f86-d92942cf49fd.zip','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_b1ce9a22-1749-11ef-8f86-d92942cf49fd_SESS_b1d043a8-1749-11ef-8f86-d92942cf49fd_TOSC_e0fd2566-1749-11ef-8f86-d92942cf49fd_MODEL','e0fd50b7-1749-11ef-8f86-d92942cf49fd.zip','e0fd50b7-1749-11ef-8f86-d92942cf49fd','{\"displayTitle\":\"Maxillaire 1.7.6.1.2\",\"modelMatrix\":\"0.983594,0.148421,-0.102541,0,-0.180193,0.835416,-0.51924,0,0.008598,0.529198,0.848454,0,13.5602,-14.0966,-17.5164,1\",\"scanBodies\":[{\"position\":\"-29.0903,6,0,0,9.12029,0,4.5,0,26.796,0,0,6,1,0,0,0\",\"reference\":\"K30PSCANP\",\"tid\":16}]}','ZIP',0,'SYNCED',0,NULL,'2024-05-21 10:12:34.652','2024-05-21 08:12:54.517','2024-05-21 10:14:51.602'),('e103322a-1749-11ef-8f86-d92942cf49fd',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_b1ce9a22-1749-11ef-8f86-d92942cf49fd/occlusion_b1d043a8-1749-11ef-8f86-d92942cf49fd/scan_e0fd2566-1749-11ef-8f86-d92942cf49fd/e103322a-1749-11ef-8f86-d92942cf49fd.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_b1ce9a22-1749-11ef-8f86-d92942cf49fd_SESS_b1d043a8-1749-11ef-8f86-d92942cf49fd_TOSC_e0fd2566-1749-11ef-8f86-d92942cf49fd_SNAPS','e103322a-1749-11ef-8f86-d92942cf49fd.png','e103322a-1749-11ef-8f86-d92942cf49fd','{\"displayTitle\":\"Maxillaire 1.7.6.1.2 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-21 10:12:34.690','2024-05-21 08:12:35.412','2024-05-21 10:12:36.580'),('e2e58607-0957-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_0a477976-0952-11ef-8f65-d9283bb1c6cd/analyse_e0c477cf-0957-11ef-8f65-d9283bb1c6cd/e2e58607-0957-11ef-8f65-d9283bb1c6cd.json','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_0a477976-0952-11ef-8f65-d9283bb1c6cd_ANA_e0c477cf-0957-11ef-8f65-d9283bb1c6cd_TRANS','e2e58607-0957-11ef-8f65-d9283bb1c6cd.json','e2e58607-0957-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Mesures 1.2.5.3\"}','JSON',0,'SYNCED',0,NULL,'2024-05-03 16:17:35.169','2024-05-03 14:17:35.170','2024-05-03 16:17:35.532'),('e31a6109-0957-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_0a477976-0952-11ef-8f65-d9283bb1c6cd/analyse_e0c477cf-0957-11ef-8f65-d9283bb1c6cd/e31a6109-0957-11ef-8f65-d9283bb1c6cd.png','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_0a477976-0952-11ef-8f65-d9283bb1c6cd_ANA_e0c477cf-0957-11ef-8f65-d9283bb1c6cd_SNAPS','e31a6109-0957-11ef-8f65-d9283bb1c6cd.png','e31a6109-0957-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Mesures 1.2.5.3\"}','PNG',0,'SYNCED',0,NULL,'2024-05-03 16:17:35.516','2024-05-03 14:17:35.518','2024-05-03 16:17:35.886'),('e3f49fd8-1dc4-11ef-8e10-d517f279883e',15,'/var/iris/.data/2024/15/8eb8d841-1dc4-11ef-8e10-d517f279883e/session_97a4fb29-1dc4-11ef-8e10-d517f279883e/occlusion_97a7648b-1dc4-11ef-8e10-d517f279883e/scan_a6dfd269-1dc4-11ef-8e10-d517f279883e/e3f49fd8-1dc4-11ef-8e10-d517f279883e.zip','PATIENT_8eb8d841-1dc4-11ef-8e10-d517f279883e_ACT_97a4fb29-1dc4-11ef-8e10-d517f279883e_SESS_97a7648b-1dc4-11ef-8e10-d517f279883e_TOSC_a6dfd269-1dc4-11ef-8e10-d517f279883e_MODEL','e3f49fd8-1dc4-11ef-8e10-d517f279883e.zip','e3f49fd8-1dc4-11ef-8e10-d517f279883e','{\"displayTitle\":\"Maxillaire 1.1.1.1.1\",\"modelMatrix\":\"0.979412,0.193087,-0.0588964,0,-0.185851,0.748568,-0.636479,0,-0.0788078,0.634321,0.769042,0,-18.6321,-11.2556,-10.2485,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-29 16:09:06.000','2024-05-29 15:05:54.000','2024-05-29 17:05:54.000'),('e3f5f8d4-1dc4-11ef-8e10-d517f279883e',15,'/var/iris/.data/2024/15/8eb8d841-1dc4-11ef-8e10-d517f279883e/session_97a4fb29-1dc4-11ef-8e10-d517f279883e/occlusion_97a7648b-1dc4-11ef-8e10-d517f279883e/scan_a6dfd269-1dc4-11ef-8e10-d517f279883e/e3f5f8d4-1dc4-11ef-8e10-d517f279883e.png','PATIENT_8eb8d841-1dc4-11ef-8e10-d517f279883e_ACT_97a4fb29-1dc4-11ef-8e10-d517f279883e_SESS_97a7648b-1dc4-11ef-8e10-d517f279883e_TOSC_a6dfd269-1dc4-11ef-8e10-d517f279883e_SNAPS','e3f5f8d4-1dc4-11ef-8e10-d517f279883e.png','e3f5f8d4-1dc4-11ef-8e10-d517f279883e','{\"displayTitle\":\"Maxillaire 1.1.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-29 16:09:07.000','2024-05-29 15:05:54.000','2024-05-29 17:05:54.000'),('e6255f00-1436-11ef-8f1b-d8242b6da0dc',3,'/var/iris/.data/2024/3/16032a0e-1436-11ef-8f1b-d8242b6da0dc/session_d9e0b5cb-1436-11ef-8f1b-d8242b6da0dc/order_d9e2b705-1436-11ef-8f1b-d8242b6da0dc/e6255f00-1436-11ef-8f1b-d8242b6da0dc.pdf','PATIENT_16032a0e-1436-11ef-8f1b-d8242b6da0dc_ACT_d9e0b5cb-1436-11ef-8f1b-d8242b6da0dc_PROST_d9e2b705-1436-11ef-8f1b-d8242b6da0dc_FORM','e6255f00-1436-11ef-8f1b-d8242b6da0dc.pdf','e6255f00-1436-11ef-8f1b-d8242b6da0dc','{\"displayTitle\":\"Commande 1.6.2.1 Autre\",\"title\":\"Autre\"}','PDF',0,'SYNCED',0,NULL,'2024-05-17 12:19:09.377','2024-05-17 10:19:10.050','2024-05-17 12:19:10.218'),('e662db00-113b-11ef-8f8d-d92a44d56471',3,'/var/iris/.data/2024/3/4ce59675-1136-11ef-8f8d-d92a44d56471/session_bcf58202-113b-11ef-8f8d-d92a44d56471/occlusion_bcf73039-113b-11ef-8f8d-d92a44d56471/scan_be5151d5-113b-11ef-8f8d-d92a44d56471/e662db00-113b-11ef-8f8d-d92a44d56471.zip','PATIENT_4ce59675-1136-11ef-8f8d-d92a44d56471_ACT_bcf58202-113b-11ef-8f8d-d92a44d56471_SESS_bcf73039-113b-11ef-8f8d-d92a44d56471_TOSC_be5151d5-113b-11ef-8f8d-d92a44d56471_MODEL','e662db00-113b-11ef-8f8d-d92a44d56471.zip','e662db00-113b-11ef-8f8d-d92a44d56471','{\"displayTitle\":\"Maxillaire 1.3.1.1.1\",\"modelMatrix\":\"-0.99978,-0.0209589,0.000194605,0,0.0208589,-0.994012,0.107259,0,-0.00205459,0.107239,0.994231,0,9.79248,-1.75185,-18.6461,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-13 17:17:31.000','2024-05-13 15:17:31.000','2024-05-13 17:17:31.000'),('e662fcef-113b-11ef-8f8d-d92a44d56471',3,'/var/iris/.data/2024/3/4ce59675-1136-11ef-8f8d-d92a44d56471/session_bcf58202-113b-11ef-8f8d-d92a44d56471/occlusion_bcf73039-113b-11ef-8f8d-d92a44d56471/scan_be5151d5-113b-11ef-8f8d-d92a44d56471/e662fcef-113b-11ef-8f8d-d92a44d56471.png','PATIENT_4ce59675-1136-11ef-8f8d-d92a44d56471_ACT_bcf58202-113b-11ef-8f8d-d92a44d56471_SESS_bcf73039-113b-11ef-8f8d-d92a44d56471_TOSC_be5151d5-113b-11ef-8f8d-d92a44d56471_SNAPS','e662fcef-113b-11ef-8f8d-d92a44d56471.png','e662fcef-113b-11ef-8f8d-d92a44d56471','{\"displayTitle\":\"Maxillaire 1.3.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-13 17:17:31.000','2024-05-13 15:17:31.000','2024-05-13 17:17:31.000'),('e727070b-1467-11ef-8f1b-d8242b6da0dc',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_f0721624-144c-11ef-8f1b-d8242b6da0dc/occlusion_f073b964-144c-11ef-8f1b-d8242b6da0dc/scan_a404f782-1466-11ef-8f1b-d8242b6da0dc/e727070b-1467-11ef-8f1b-d8242b6da0dc.zip','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_f0721624-144c-11ef-8f1b-d8242b6da0dc_SESS_f073b964-144c-11ef-8f1b-d8242b6da0dc_TOSC_a404f782-1466-11ef-8f1b-d8242b6da0dc_MODEL','e727070b-1467-11ef-8f1b-d8242b6da0dc.zip','ce611e03-1466-11ef-8f1b-d8242b6da0dc','{\"displayTitle\":\"Maxillaire 1.7.1.1.1\",\"modelMatrix\":\"0.187504,0.982144,-0.0152971,0,-0.974886,0.184168,-0.125215,0,-0.120162,0.0383912,0.992012,0,-6.4891,-19.9291,-18.522,1\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2024-05-17 18:09:56.405','2024-05-17 16:09:57.117','2024-05-17 18:09:59.537'),('e7271556-1467-11ef-8f1b-d8242b6da0dc',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_f0721624-144c-11ef-8f1b-d8242b6da0dc/occlusion_f073b964-144c-11ef-8f1b-d8242b6da0dc/scan_a404f782-1466-11ef-8f1b-d8242b6da0dc/e7271556-1467-11ef-8f1b-d8242b6da0dc.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_f0721624-144c-11ef-8f1b-d8242b6da0dc_SESS_f073b964-144c-11ef-8f1b-d8242b6da0dc_TOSC_a404f782-1466-11ef-8f1b-d8242b6da0dc_SNAPS','e7271556-1467-11ef-8f1b-d8242b6da0dc.png','ce613798-1466-11ef-8f1b-d8242b6da0dc','{\"displayTitle\":\"Maxillaire 1.7.1.1.1 Snapshot\"}','PNG',1,'SYNCED',0,NULL,'2024-05-17 18:09:56.406','2024-05-17 16:09:57.118','2024-05-17 18:10:00.314'),('e7bf8567-0957-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_0a477976-0952-11ef-8f65-d9283bb1c6cd/analyse_0a4b0ffa-0952-11ef-8f65-d9283bb1c6cd/e7bf8567-0957-11ef-8f65-d9283bb1c6cd.png','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_0a477976-0952-11ef-8f65-d9283bb1c6cd_ANA_0a4b0ffa-0952-11ef-8f65-d9283bb1c6cd_SCREENS','e7bf8567-0957-11ef-8f65-d9283bb1c6cd.png','e7bf8567-0957-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Mesures 1.2.5.1 Capture d\'écran 2\",\"title\":\"2\"}','PNG',0,'SYNCED',0,NULL,'2024-05-03 16:17:43.309','2024-05-03 14:17:43.373','2024-05-03 16:17:43.402'),('e8781907-1dc9-11ef-8f99-d92a46e09137',14,'/var/iris/.data/2024/14/c6dd7b08-1dc9-11ef-8f99-d92a46e09137/session_c6ecdf7f-1dc9-11ef-8f99-d92a46e09137/occlusion_c6ed23a8-1dc9-11ef-8f99-d92a46e09137/scan_e877efd5-1dc9-11ef-8f99-d92a46e09137/e8781907-1dc9-11ef-8f99-d92a46e09137.zip','PATIENT_c6dd7b08-1dc9-11ef-8f99-d92a46e09137_ACT_c6ecdf7f-1dc9-11ef-8f99-d92a46e09137_SESS_c6ed23a8-1dc9-11ef-8f99-d92a46e09137_TOSC_e877efd5-1dc9-11ef-8f99-d92a46e09137_MODEL','e8781907-1dc9-11ef-8f99-d92a46e09137.zip','e8781907-1dc9-11ef-8f99-d92a46e09137','{\"displayTitle\":\"Maxillaire 1.1.1.1.2\",\"modelMatrix\":\"0.979412,0.193087,-0.0588964,0,-0.185851,0.748568,-0.636479,0,-0.0788078,0.634321,0.769042,0,-18.6321,-11.2556,-10.2485,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-29 16:44:09.759','2024-05-29 14:44:09.795','2024-05-29 16:44:10.038'),('e87d6c35-1dc9-11ef-8f99-d92a46e09137',14,'/var/iris/.data/2024/14/c6dd7b08-1dc9-11ef-8f99-d92a46e09137/session_c6ecdf7f-1dc9-11ef-8f99-d92a46e09137/occlusion_c6ed23a8-1dc9-11ef-8f99-d92a46e09137/scan_e877efd5-1dc9-11ef-8f99-d92a46e09137/e87d6c35-1dc9-11ef-8f99-d92a46e09137.png','PATIENT_c6dd7b08-1dc9-11ef-8f99-d92a46e09137_ACT_c6ecdf7f-1dc9-11ef-8f99-d92a46e09137_SESS_c6ed23a8-1dc9-11ef-8f99-d92a46e09137_TOSC_e877efd5-1dc9-11ef-8f99-d92a46e09137_SNAPS','e87d6c35-1dc9-11ef-8f99-d92a46e09137.png','e87d6c35-1dc9-11ef-8f99-d92a46e09137','{\"displayTitle\":\"Maxillaire 1.1.1.1.2 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-29 16:44:09.794','2024-05-29 14:44:09.805','2024-05-29 16:44:11.561'),('e94e0fa3-0868-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_9fff6be0-0868-11ef-8ff6-da2f5a35fe58/occlusion_a000fd43-0868-11ef-8ff6-da2f5a35fe58/scan_be43909f-0868-11ef-8ff6-da2f5a35fe58/e94e0fa3-0868-11ef-8ff6-da2f5a35fe58.zip','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_9fff6be0-0868-11ef-8ff6-da2f5a35fe58_SESS_a000fd43-0868-11ef-8ff6-da2f5a35fe58_TOSC_be43909f-0868-11ef-8ff6-da2f5a35fe58_MODEL','e94e0fa3-0868-11ef-8ff6-da2f5a35fe58.zip','e94e0fa3-0868-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Maxillaire 1.1.3.1.1\",\"modelMatrix\":\"-0.299994,0.953935,-0.00332519,0,-0.913283,-0.288213,-0.287833,0,-0.275532,-0.0833111,0.957675,0,9.09266,-8.61807,-16.7682,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-02 11:46:55.560','2024-05-02 09:46:55.918','2024-05-02 11:47:47.317'),('e94e2f27-0868-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_9fff6be0-0868-11ef-8ff6-da2f5a35fe58/occlusion_a000fd43-0868-11ef-8ff6-da2f5a35fe58/scan_be43909f-0868-11ef-8ff6-da2f5a35fe58/e94e2f27-0868-11ef-8ff6-da2f5a35fe58.png','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_9fff6be0-0868-11ef-8ff6-da2f5a35fe58_SESS_a000fd43-0868-11ef-8ff6-da2f5a35fe58_TOSC_be43909f-0868-11ef-8ff6-da2f5a35fe58_SNAPS','e94e2f27-0868-11ef-8ff6-da2f5a35fe58.png','e94e2f27-0868-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Maxillaire 1.1.3.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-02 11:46:55.561','2024-05-02 09:46:55.919','2024-05-02 11:47:47.612'),('ea71e741-0863-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_59e98ac5-0861-11ef-8ff6-da2f5a35fe58/ea71e741-0863-11ef-8ff6-da2f5a35fe58.xyz','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_TOSC_59e98ac5-0861-11ef-8ff6-da2f5a35fe58_LIFI','ea71e741-0863-11ef-8ff6-da2f5a35fe58.xyz','ea71e741-0863-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Maxillaire 1.1.2.1.1 Ligne de finition 1\",\"title\":\"1\",\"toothNumber\":1,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-05-02 11:11:10.000','2024-05-02 09:11:10.000','2024-05-02 11:11:10.000'),('ea71eca5-0863-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_59e98ac5-0861-11ef-8ff6-da2f5a35fe58/ea71eca5-0863-11ef-8ff6-da2f5a35fe58.bin','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_TOSC_59e98ac5-0861-11ef-8ff6-da2f5a35fe58_LIFIM','ea71eca5-0863-11ef-8ff6-da2f5a35fe58.bin','ea71eca5-0863-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Maxillaire 1.1.2.1.1 Ligne de finition métadonnées 1\",\"title\":\"1\",\"toothNumber\":1,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-05-02 11:11:09.989','2024-05-02 09:11:10.002','2024-05-02 11:11:10.266'),('eb0e1462-1437-11ef-8f1b-d8242b6da0dc',3,'/var/iris/.data/2024/3/16032a0e-1436-11ef-8f1b-d8242b6da0dc/session_d961f6f4-1437-11ef-8f1b-d8242b6da0dc/order_d963f904-1437-11ef-8f1b-d8242b6da0dc/eb0e1462-1437-11ef-8f1b-d8242b6da0dc.pdf','PATIENT_16032a0e-1436-11ef-8f1b-d8242b6da0dc_ACT_d961f6f4-1437-11ef-8f1b-d8242b6da0dc_PROST_d963f904-1437-11ef-8f1b-d8242b6da0dc_FORM','eb0e1462-1437-11ef-8f1b-d8242b6da0dc.pdf','eb0e1462-1437-11ef-8f1b-d8242b6da0dc','{\"displayTitle\":\"Commande 1.6.3.1 Autre\",\"title\":\"Autre\"}','PDF',0,'SYNCED',0,NULL,'2024-05-17 12:26:28.000','2024-05-17 10:28:39.000','2024-05-17 12:28:39.000'),('eb3a6705-0957-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_0a477976-0952-11ef-8f65-d9283bb1c6cd/analyse_32ad8516-0957-11ef-8f65-d9283bb1c6cd/eb3a6705-0957-11ef-8f65-d9283bb1c6cd.png','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_0a477976-0952-11ef-8f65-d9283bb1c6cd_ANA_32ad8516-0957-11ef-8f65-d9283bb1c6cd_SCREENS','eb3a6705-0957-11ef-8f65-d9283bb1c6cd.png','eb3a6705-0957-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Comparaison 1.2.5.2 Capture d\'écran 3\",\"title\":\"3\"}','PNG',0,'SYNCED',0,NULL,'2024-05-03 16:17:49.147','2024-05-03 14:17:49.213','2024-05-03 16:17:49.242'),('eb4b66a4-0951-11ef-8ba8-6ec2958327c0',3,'/var/iris/.data/2024/3/discussion_3b2891c3-0950-11ef-8f65-d9283bb1c6cd/eb4b66a4-0951-11ef-8ba8-6ec2958327c0.zip','PATIENT_bbee50d8-094f-11ef-8f65-d9283bb1c6cd_ACT_7d7b190c-094f-11ef-8f65-d9283bb1c6cd_SESS_7d7bdba5-094f-11ef-8f65-d9283bb1c6cd_TOSC_7e3b5074-094f-11ef-8f65-d9283bb1c6cd_MODEL','9935aa64-094f-11ef-8f65-d9283bb1c6cd.zip','eb4b66a4-0951-11ef-8ba8-6ec2958327c0','{\"displayTitle\":\"Maxillaire 1.1.1.1.1\",\"modelMatrix\":\"0.911721,-0.408329,0.045069,0,0.404868,0.911703,0.0698595,0,-0.0696153,-0.0454454,0.996538,0,-5.05468,2.73266,-18.4649,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-03 15:19:17.000','2024-05-03 13:19:17.000','2024-05-03 15:19:17.000'),('eb4ba85c-0951-11ef-8ba8-6ec2958327c0',3,'/var/iris/.data/2024/3/discussion_3b2891c3-0950-11ef-8f65-d9283bb1c6cd/eb4ba85c-0951-11ef-8ba8-6ec2958327c0.png','PATIENT_bbee50d8-094f-11ef-8f65-d9283bb1c6cd_ACT_7d7b190c-094f-11ef-8f65-d9283bb1c6cd_SESS_7d7bdba5-094f-11ef-8f65-d9283bb1c6cd_TOSC_7e3b5074-094f-11ef-8f65-d9283bb1c6cd_SNAPS','9935cedf-094f-11ef-8f65-d9283bb1c6cd.png','eb4ba85c-0951-11ef-8ba8-6ec2958327c0','{\"displayTitle\":\"Maxillaire 1.1.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-03 15:19:17.000','2024-05-03 13:19:17.000','2024-05-03 15:19:17.000'),('eb746e19-0861-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_59e98ac5-0861-11ef-8ff6-da2f5a35fe58/eb746e19-0861-11ef-8ff6-da2f5a35fe58.zip','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_TOSC_59e98ac5-0861-11ef-8ff6-da2f5a35fe58_MODEL','eb746e19-0861-11ef-8ff6-da2f5a35fe58.zip','eb746e19-0861-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Maxillaire 1.1.2.1.1\",\"modelMatrix\":\"0.0444728,-0.991811,-0.11972,0,0.974881,0.0692654,-0.21168,0,0.218239,-0.107299,0.969979,0,-25.3453,27.4041,-20.8016,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-02 10:56:56.000','2024-05-02 08:56:56.000','2024-05-02 10:56:56.000'),('eb7485b0-0861-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_58e7015d-0861-11ef-8ff6-da2f5a35fe58/occlusion_58e77d50-0861-11ef-8ff6-da2f5a35fe58/scan_59e98ac5-0861-11ef-8ff6-da2f5a35fe58/eb7485b0-0861-11ef-8ff6-da2f5a35fe58.png','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_58e7015d-0861-11ef-8ff6-da2f5a35fe58_SESS_58e77d50-0861-11ef-8ff6-da2f5a35fe58_TOSC_59e98ac5-0861-11ef-8ff6-da2f5a35fe58_SNAPS','eb7485b0-0861-11ef-8ff6-da2f5a35fe58.png','eb7485b0-0861-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Maxillaire 1.1.2.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-02 10:56:56.000','2024-05-02 08:56:56.000','2024-05-02 10:56:56.000'),('ec401636-146c-11ef-8f1b-d8242b6da0dc',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_5748a11c-146a-11ef-8f1b-d8242b6da0dc/occlusion_574ac047-146a-11ef-8f1b-d8242b6da0dc/scan_d802a151-146c-11ef-8f1b-d8242b6da0dc/ec401636-146c-11ef-8f1b-d8242b6da0dc.zip','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_5748a11c-146a-11ef-8f1b-d8242b6da0dc_SESS_574ac047-146a-11ef-8f1b-d8242b6da0dc_LESC_d802a151-146c-11ef-8f1b-d8242b6da0dc_MODEL','ec401636-146c-11ef-8f1b-d8242b6da0dc.zip','ec401636-146c-11ef-8f1b-d8242b6da0dc','{\"displayTitle\":\"Mordu gauche 1.7.3.1.1\",\"modelMatrix\":\"-0.999058,0.0436203,-0.00703562,0,-0.0433801,-0.975462,0.214261,0,0.00142106,0.215811,0.976753,0,-4.44865,-10.6182,-15.8908,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-17 18:45:52.442','2024-05-17 16:45:52.634','2024-05-17 18:45:54.436'),('ec40284c-146c-11ef-8f1b-d8242b6da0dc',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_5748a11c-146a-11ef-8f1b-d8242b6da0dc/occlusion_574ac047-146a-11ef-8f1b-d8242b6da0dc/scan_d802a151-146c-11ef-8f1b-d8242b6da0dc/ec40284c-146c-11ef-8f1b-d8242b6da0dc.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_5748a11c-146a-11ef-8f1b-d8242b6da0dc_SESS_574ac047-146a-11ef-8f1b-d8242b6da0dc_LESC_d802a151-146c-11ef-8f1b-d8242b6da0dc_SNAPS','ec40284c-146c-11ef-8f1b-d8242b6da0dc.png','ec40284c-146c-11ef-8f1b-d8242b6da0dc','{\"displayTitle\":\"Mordu gauche 1.7.3.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-17 18:45:52.442','2024-05-17 16:45:52.645','2024-05-17 18:45:55.422'),('eccd0411-1749-11ef-8f86-d92942cf49fd',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_b1ce9a22-1749-11ef-8f86-d92942cf49fd/occlusion_b1d043a8-1749-11ef-8f86-d92942cf49fd/scan_e0fd2566-1749-11ef-8f86-d92942cf49fd/eccd0411-1749-11ef-8f86-d92942cf49fd.zip','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_b1ce9a22-1749-11ef-8f86-d92942cf49fd_SESS_b1d043a8-1749-11ef-8f86-d92942cf49fd_TOSC_e0fd2566-1749-11ef-8f86-d92942cf49fd_MODEL','eccd0411-1749-11ef-8f86-d92942cf49fd.zip','e0fd50b7-1749-11ef-8f86-d92942cf49fd','{\"displayTitle\":\"Maxillaire scanbody 1.7.6.1.2\",\"modelMatrix\":\"0.983594,0.148421,-0.102541,0,-0.180193,0.835416,-0.51924,0,0.008598,0.529198,0.848454,0,13.5602,-14.0966,-17.5164,1\",\"scanBodies\":[{\"position\":\"-29.0903,6,0,0,9.12029,0,4.5,0,26.796,0,0,6,1,0,0,0\",\"reference\":\"K30PSCANP\",\"tid\":16}]}','ZIP',1,'SYNCED',0,NULL,'2024-05-21 10:12:54.468','2024-05-21 08:12:54.517','2024-05-21 10:14:53.211'),('ece2d99e-1cf1-11ef-8f68-d9283cb4d201',6,'/var/iris/.data/2024/6/8578524d-1cf1-11ef-8f68-d9283cb4d201/session_894496db-1cf1-11ef-8f68-d9283cb4d201/order_894691e1-1cf1-11ef-8f68-d9283cb4d201/ece2d99e-1cf1-11ef-8f68-d9283cb4d201.pdf','PATIENT_8578524d-1cf1-11ef-8f68-d9283cb4d201_ACT_894496db-1cf1-11ef-8f68-d9283cb4d201_PROST_894691e1-1cf1-11ef-8f68-d9283cb4d201_FORM','ece2d99e-1cf1-11ef-8f68-d9283cb4d201.pdf','ece2d99e-1cf1-11ef-8f68-d9283cb4d201','{\"displayTitle\":\"Commande 1.2.1.1 Facette\",\"title\":\"Facette\"}','PDF',0,'SYNCED',0,NULL,'2024-05-28 14:58:05.876','2024-05-28 12:58:06.582','2024-05-28 14:58:06.693'),('edd56113-0957-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_0a477976-0952-11ef-8f65-d9283bb1c6cd/analyse_e0c477cf-0957-11ef-8f65-d9283bb1c6cd/edd56113-0957-11ef-8f65-d9283bb1c6cd.png','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_0a477976-0952-11ef-8f65-d9283bb1c6cd_ANA_e0c477cf-0957-11ef-8f65-d9283bb1c6cd_SCREENS','edd56113-0957-11ef-8f65-d9283bb1c6cd.png','edd56113-0957-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Mesures 1.2.5.3 Capture d\'écran 1\",\"title\":\"1\"}','PNG',0,'SYNCED',0,NULL,'2024-05-03 16:17:53.519','2024-05-03 14:17:53.584','2024-05-03 16:17:53.610'),('ee49068e-1cf1-11ef-867c-6ec2958327c0',3,'/var/iris/.data/2024/3/discussion_3b2891c3-0950-11ef-8f65-d9283bb1c6cd/ee49068e-1cf1-11ef-867c-6ec2958327c0.zip','PATIENT_8578524d-1cf1-11ef-8f68-d9283cb4d201_ACT_894496db-1cf1-11ef-8f68-d9283cb4d201_SESS_89463d55-1cf1-11ef-8f68-d9283cb4d201_TOSC_994f08c1-1cf1-11ef-8f68-d9283cb4d201_MODEL','d0c9b40d-1cf1-11ef-8f68-d9283cb4d201.zip','ee49068e-1cf1-11ef-867c-6ec2958327c0','{\"displayTitle\":\"Maxillaire 1.2.1.1.1\",\"modelMatrix\":\"-0.438456,0.89548,-0.0766271,0,-0.820426,-0.433598,-0.372685,0,-0.366957,-0.100539,0.924789,0,15.3421,-3.85399,-15.7501,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-28 14:57:21.000','2024-05-28 12:57:21.000','2024-05-28 14:57:21.000'),('ee4eb1d4-1cf1-11ef-867c-6ec2958327c0',3,'/var/iris/.data/2024/3/discussion_3b2891c3-0950-11ef-8f65-d9283bb1c6cd/ee4eb1d4-1cf1-11ef-867c-6ec2958327c0.png','PATIENT_8578524d-1cf1-11ef-8f68-d9283cb4d201_ACT_894496db-1cf1-11ef-8f68-d9283cb4d201_SESS_89463d55-1cf1-11ef-8f68-d9283cb4d201_TOSC_994f08c1-1cf1-11ef-8f68-d9283cb4d201_SNAPS','d0c9cbb2-1cf1-11ef-8f68-d9283cb4d201.png','ee4eb1d4-1cf1-11ef-867c-6ec2958327c0','{\"displayTitle\":\"Maxillaire 1.2.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-28 14:57:21.000','2024-05-28 12:57:21.000','2024-05-28 14:57:21.000'),('ee4fa2ca-1cf1-11ef-867c-6ec2958327c0',3,'/var/iris/.data/2024/3/discussion_3b2891c3-0950-11ef-8f65-d9283bb1c6cd/ee4fa2ca-1cf1-11ef-867c-6ec2958327c0.pdf','PATIENT_8578524d-1cf1-11ef-8f68-d9283cb4d201_ACT_894496db-1cf1-11ef-8f68-d9283cb4d201_PROST_894691e1-1cf1-11ef-8f68-d9283cb4d201_FORM','ece2d99e-1cf1-11ef-8f68-d9283cb4d201.pdf','ee4fa2ca-1cf1-11ef-867c-6ec2958327c0','{\"displayTitle\":\"Commande 1.2.1.1 Facette\",\"title\":\"Facette\"}','PDF',0,'SYNCED',0,NULL,'2024-05-28 14:58:06.000','2024-05-28 12:58:06.000','2024-05-28 14:58:06.000'),('f1591e3a-176d-11ef-8f86-d92942cf49fd',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_b1ce9a22-1749-11ef-8f86-d92942cf49fd/occlusion_b1d043a8-1749-11ef-8f86-d92942cf49fd/scan_b2fd8f6c-1749-11ef-8f86-d92942cf49fd/f1591e3a-176d-11ef-8f86-d92942cf49fd.json','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_b1ce9a22-1749-11ef-8f86-d92942cf49fd_SESS_b1d043a8-1749-11ef-8f86-d92942cf49fd_TOSC_b2fd8f6c-1749-11ef-8f86-d92942cf49fd_METER','f1591e3a-176d-11ef-8f86-d92942cf49fd.json','f1591e3a-176d-11ef-8f86-d92942cf49fd','{\"displayTitle\":\"Maxillaire 1.7.6.1.1 Mesure\"}','JSON',0,'SYNCED',0,NULL,'2024-05-21 14:30:43.979','2024-05-21 12:30:43.982','2024-05-21 14:30:44.034'),('f3c05df6-113b-11ef-8f8d-d92a44d56471',3,'/var/iris/.data/2024/3/4ce59675-1136-11ef-8f8d-d92a44d56471/session_bcf58202-113b-11ef-8f8d-d92a44d56471/order_bcf78fbc-113b-11ef-8f8d-d92a44d56471/f3c05df6-113b-11ef-8f8d-d92a44d56471.pdf','PATIENT_4ce59675-1136-11ef-8f8d-d92a44d56471_ACT_bcf58202-113b-11ef-8f8d-d92a44d56471_PROST_bcf78fbc-113b-11ef-8f8d-d92a44d56471_FORM','f3c05df6-113b-11ef-8f8d-d92a44d56471.pdf','f3c05df6-113b-11ef-8f8d-d92a44d56471','{\"displayTitle\":\"Commande 1.3.1.1 Couronne\",\"title\":\"Couronne\"}','PDF',0,'SYNCED',0,NULL,'2024-05-13 17:17:47.000','2024-05-13 15:17:47.000','2024-05-13 17:17:47.000'),('f41b9ab0-0957-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_0a477976-0952-11ef-8f65-d9283bb1c6cd/analyse_0a4b0ffa-0952-11ef-8f65-d9283bb1c6cd/f41b9ab0-0957-11ef-8f65-d9283bb1c6cd.png','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_0a477976-0952-11ef-8f65-d9283bb1c6cd_ANA_0a4b0ffa-0952-11ef-8f65-d9283bb1c6cd_SCREENS','f41b9ab0-0957-11ef-8f65-d9283bb1c6cd.png','f41b9ab0-0957-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Mesures 1.2.5.1 Capture d\'écran 3\",\"title\":\"3\"}','PNG',0,'SYNCED',0,NULL,'2024-05-03 16:18:04.045','2024-05-03 14:18:04.111','2024-05-03 16:18:04.137'),('f4305e3b-1dc9-11ef-8f99-d92a46e09137',14,'/var/iris/.data/2024/14/c6dd7b08-1dc9-11ef-8f99-d92a46e09137/session_c6ecdf7f-1dc9-11ef-8f99-d92a46e09137/occlusion_c6ed23a8-1dc9-11ef-8f99-d92a46e09137/scan_e877efd5-1dc9-11ef-8f99-d92a46e09137/f4305e3b-1dc9-11ef-8f99-d92a46e09137.zip','PATIENT_c6dd7b08-1dc9-11ef-8f99-d92a46e09137_ACT_c6ecdf7f-1dc9-11ef-8f99-d92a46e09137_SESS_c6ed23a8-1dc9-11ef-8f99-d92a46e09137_TOSC_e877efd5-1dc9-11ef-8f99-d92a46e09137_MODEL','f4305e3b-1dc9-11ef-8f99-d92a46e09137.zip','e8781907-1dc9-11ef-8f99-d92a46e09137','{\"displayTitle\":\"Maxillaire 1.1.1.1.2\",\"modelMatrix\":\"0.979412,0.193087,-0.0588964,0,-0.185851,0.748568,-0.636479,0,-0.0788078,0.634321,0.769042,0,-18.6321,-11.2556,-10.2485,1\",\"scanBodies\":[],\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":3,\"socleIsFullArch\":false,\"socleThickness\":-1,\"socleType\":3}','ZIP',1,'SYNCED',0,NULL,'2024-05-29 16:44:29.421','2024-05-29 14:44:29.495','2024-05-29 16:44:29.632'),('f49fc51a-1842-11ef-8f8e-d92a44d6667d',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_f0721624-144c-11ef-8f1b-d8242b6da0dc/occlusion_f073b964-144c-11ef-8f1b-d8242b6da0dc/scan_a404f782-1466-11ef-8f1b-d8242b6da0dc/f49fc51a-1842-11ef-8f8e-d92a44d6667d.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_f0721624-144c-11ef-8f1b-d8242b6da0dc_SESS_f073b964-144c-11ef-8f1b-d8242b6da0dc_TOSC_a404f782-1466-11ef-8f1b-d8242b6da0dc_SCREENS','f49fc51a-1842-11ef-8f8e-d92a44d6667d.png','f49fc51a-1842-11ef-8f8e-d92a44d6667d','{\"displayTitle\":\"Maxillaire 1.7.1.1.1 Capture d\'écran 1\",\"title\":\"1\"}','PNG',0,'SYNCED',0,'2024-05-22 15:56:24.941','2024-05-22 15:56:24.941','2024-05-22 13:56:24.941','2024-05-22 15:56:24.951'),('f4d2b8bb-0952-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_4fc2347a-0952-11ef-8f65-d9283bb1c6cd/occlusion_4fc3d0e6-0952-11ef-8f65-d9283bb1c6cd/scan_f4d296fb-0952-11ef-8f65-d9283bb1c6cd/f4d2b8bb-0952-11ef-8f65-d9283bb1c6cd.zip','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_4fc2347a-0952-11ef-8f65-d9283bb1c6cd_SESS_4fc3d0e6-0952-11ef-8f65-d9283bb1c6cd_TOSC_f4d296fb-0952-11ef-8f65-d9283bb1c6cd_MODEL','f4d2b8bb-0952-11ef-8f65-d9283bb1c6cd.zip','f4d2b8bb-0952-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Maxillaire 1.2.6.1.2\",\"modelMatrix\":\"0.774981,0.631095,0.033522,0,-0.62835,0.77512,-0.0660793,0,-0.0676859,0.0301467,0.997251,0,-4.63707,-4.79452,-18.5136,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-05-03 15:42:17.762','2024-05-03 13:42:18.337','2024-05-03 15:42:18.344'),('f4d8deb1-0952-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_4fc2347a-0952-11ef-8f65-d9283bb1c6cd/occlusion_4fc3d0e6-0952-11ef-8f65-d9283bb1c6cd/scan_f4d296fb-0952-11ef-8f65-d9283bb1c6cd/f4d8deb1-0952-11ef-8f65-d9283bb1c6cd.png','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_4fc2347a-0952-11ef-8f65-d9283bb1c6cd_SESS_4fc3d0e6-0952-11ef-8f65-d9283bb1c6cd_TOSC_f4d296fb-0952-11ef-8f65-d9283bb1c6cd_SNAPS','f4d8deb1-0952-11ef-8f65-d9283bb1c6cd.png','f4d8deb1-0952-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Maxillaire 1.2.6.1.2 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-05-03 15:42:17.802','2024-05-03 13:42:18.337','2024-05-03 15:42:21.723'),('f724c29c-1842-11ef-8f8e-d92a44d6667d',3,'/var/iris/.data/2024/3/e7cdc6df-144c-11ef-8f1b-d8242b6da0dc/session_f0721624-144c-11ef-8f1b-d8242b6da0dc/occlusion_f073b964-144c-11ef-8f1b-d8242b6da0dc/scan_a404f782-1466-11ef-8f1b-d8242b6da0dc/f724c29c-1842-11ef-8f8e-d92a44d6667d.png','PATIENT_e7cdc6df-144c-11ef-8f1b-d8242b6da0dc_ACT_f0721624-144c-11ef-8f1b-d8242b6da0dc_SESS_f073b964-144c-11ef-8f1b-d8242b6da0dc_TOSC_a404f782-1466-11ef-8f1b-d8242b6da0dc_SCREENS','f724c29c-1842-11ef-8f8e-d92a44d6667d.png','f724c29c-1842-11ef-8f8e-d92a44d6667d','{\"displayTitle\":\"Maxillaire 1.7.1.1.1 Capture d\'écran 2\",\"title\":\"2\"}','PNG',0,'SYNCED',0,'2024-05-22 15:56:27.100','2024-05-22 15:56:27.101','2024-05-22 13:56:27.101','2024-05-22 15:56:27.111'),('f974eadb-0957-11ef-8f65-d9283bb1c6cd',3,'/var/iris/.data/2024/3/21d1572e-0943-11ef-8f65-d9283bb1c6cd/session_0a477976-0952-11ef-8f65-d9283bb1c6cd/analyse_0a4b0ffa-0952-11ef-8f65-d9283bb1c6cd/f974eadb-0957-11ef-8f65-d9283bb1c6cd.png','PATIENT_21d1572e-0943-11ef-8f65-d9283bb1c6cd_ACT_0a477976-0952-11ef-8f65-d9283bb1c6cd_ANA_0a4b0ffa-0952-11ef-8f65-d9283bb1c6cd_SCREENS','f974eadb-0957-11ef-8f65-d9283bb1c6cd.png','f974eadb-0957-11ef-8f65-d9283bb1c6cd','{\"displayTitle\":\"Mesures 1.2.5.1 Capture d\'écran 4\",\"title\":\"4\"}','PNG',0,'SYNCED',0,NULL,'2024-05-03 16:18:13.019','2024-05-03 14:18:13.084','2024-05-03 16:18:13.105'),('fadb936e-1dc9-11ef-8f99-d92a46e09137',14,'/var/iris/.data/2024/14/c6dd7b08-1dc9-11ef-8f99-d92a46e09137/session_c6ecdf7f-1dc9-11ef-8f99-d92a46e09137/occlusion_c6ed23a8-1dc9-11ef-8f99-d92a46e09137/scan_e877efd5-1dc9-11ef-8f99-d92a46e09137/fadb936e-1dc9-11ef-8f99-d92a46e09137.xyz','PATIENT_c6dd7b08-1dc9-11ef-8f99-d92a46e09137_ACT_c6ecdf7f-1dc9-11ef-8f99-d92a46e09137_SESS_c6ed23a8-1dc9-11ef-8f99-d92a46e09137_TOSC_e877efd5-1dc9-11ef-8f99-d92a46e09137_LIFI','fadb936e-1dc9-11ef-8f99-d92a46e09137.xyz','fadb936e-1dc9-11ef-8f99-d92a46e09137','{\"displayTitle\":\"Maxillaire 1.1.1.1.2 Ligne de finition 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,'2024-05-29 16:44:48.863','2024-05-29 16:44:40.610','2024-05-29 14:44:48.864','2024-05-29 16:44:48.874'),('fadb9840-1dc9-11ef-8f99-d92a46e09137',14,'/var/iris/.data/2024/14/c6dd7b08-1dc9-11ef-8f99-d92a46e09137/session_c6ecdf7f-1dc9-11ef-8f99-d92a46e09137/occlusion_c6ed23a8-1dc9-11ef-8f99-d92a46e09137/scan_e877efd5-1dc9-11ef-8f99-d92a46e09137/fadb9840-1dc9-11ef-8f99-d92a46e09137.bin','PATIENT_c6dd7b08-1dc9-11ef-8f99-d92a46e09137_ACT_c6ecdf7f-1dc9-11ef-8f99-d92a46e09137_SESS_c6ed23a8-1dc9-11ef-8f99-d92a46e09137_TOSC_e877efd5-1dc9-11ef-8f99-d92a46e09137_LIFIM','fadb9840-1dc9-11ef-8f99-d92a46e09137.bin','fadb9840-1dc9-11ef-8f99-d92a46e09137','{\"displayTitle\":\"Maxillaire 1.1.1.1.2 Ligne de finition métadonnées 0\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,'2024-05-29 16:44:48.863','2024-05-29 16:44:40.610','2024-05-29 14:44:48.864','2024-05-29 16:44:48.874'),('fc095480-086c-11ef-8ff6-da2f5a35fe58',3,'/var/iris/.data/2024/3/00c2d95b-06ed-11ef-90c8-dd3986f53a42/session_89504286-086c-11ef-8ff6-da2f5a35fe58/analyse_895411ef-086c-11ef-8ff6-da2f5a35fe58/fc095480-086c-11ef-8ff6-da2f5a35fe58.json','PATIENT_00c2d95b-06ed-11ef-90c8-dd3986f53a42_ACT_89504286-086c-11ef-8ff6-da2f5a35fe58_ANA_895411ef-086c-11ef-8ff6-da2f5a35fe58_METER','fc095480-086c-11ef-8ff6-da2f5a35fe58.json','fc095480-086c-11ef-8ff6-da2f5a35fe58','{\"displayTitle\":\"Mesures 1.1.4.1\"}','JSON',0,'SYNCED',0,NULL,'2024-05-02 12:16:04.973','2024-05-02 10:16:04.985','2024-05-02 12:16:04.988');
/*!40000 ALTER TABLE `File` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `MessageStatus`
--

DROP TABLE IF EXISTS `MessageStatus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `MessageStatus` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `sentMessageId` varchar(36) NOT NULL,
  `contactId` varchar(36) NOT NULL,
  `status` enum('UNDELIVERED','DELIVERED','TRANSMITTED') NOT NULL DEFAULT 'UNDELIVERED',
  `bcc` tinyint(1) NOT NULL DEFAULT 0,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  PRIMARY KEY (`sentMessageId`,`contactId`),
  KEY `ownerId` (`ownerId`),
  KEY `contactId` (`contactId`),
  CONSTRAINT `MessageStatus_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `MessageStatus_ibfk_2` FOREIGN KEY (`sentMessageId`) REFERENCES `SentMessage` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `MessageStatus_ibfk_3` FOREIGN KEY (`contactId`) REFERENCES `Contact` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `MessageStatus`
--

LOCK TABLES `MessageStatus` WRITE;
/*!40000 ALTER TABLE `MessageStatus` DISABLE KEYS */;
INSERT INTO `MessageStatus` VALUES (3,'06afbfbe-113c-11ef-8f8d-d92a44d56471','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-13 15:18:18.212'),(3,'06b68eed-1437-11ef-8f1b-d8242b6da0dc','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-17 10:20:04.136'),(3,'06eb8cdf-1437-11ef-8f1b-d8242b6da0dc','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-17 10:20:04.441'),(3,'080c3ab0-1bc9-454e-a6f9-8c4c167f03df','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-17 10:20:25.934'),(3,'0ab7a78f-a39e-4180-9e24-2f7e3d76ba8f','8e4a4b16-c567-4bf8-a434-976b627a70ca','DELIVERED',0,'2024-04-30 12:32:58.849'),(3,'154baa5a-086c-11ef-8ff6-da2f5a35fe58','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-02 10:09:38.299'),(3,'17b0adf8-0947-11ef-8f65-d9283bb1c6cd','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-03 12:17:26.087'),(3,'18dfb5e3-0954-11ef-8f65-d9283bb1c6cd','1ae8fb0f-2111-4ecf-a290-dcae6e15100e','DELIVERED',0,'2024-05-03 13:50:30.075'),(3,'19aed8ae-1469-11ef-8f1b-d8242b6da0dc','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-17 16:18:30.777'),(3,'1b47fa3f-1437-11ef-8f1b-d8242b6da0dc','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-17 10:20:38.602'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-02 09:34:12.341'),(15,'2c6341b5-1dd2-11ef-8f99-d92a46e09137','6c752185-ecab-4039-a782-171f75036a34','DELIVERED',0,'2024-05-29 15:43:20.950'),(3,'2c749216-1437-11ef-8f1b-d8242b6da0dc','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-17 10:21:07.450'),(3,'32745aba-0869-11ef-8ff6-da2f5a35fe58','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-02 09:49:00.153'),(3,'34ee3417-0954-11ef-8f65-d9283bb1c6cd','1ae8fb0f-2111-4ecf-a290-dcae6e15100e','DELIVERED',0,'2024-05-03 13:51:15.065'),(3,'379f0632-1438-11ef-8f1b-d8242b6da0dc','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-17 10:28:35.736'),(6,'3b292340-0950-11ef-8f65-d9283bb1c6cd','78919a47-1bcf-424a-a1b2-c19063ff242c','DELIVERED',0,'2024-05-03 13:22:48.072'),(3,'3bc07aaf-0954-11ef-8f65-d9283bb1c6cd','1ae8fb0f-2111-4ecf-a290-dcae6e15100e','DELIVERED',0,'2024-05-03 13:51:26.528'),(15,'3c526b33-1dcb-11ef-8e10-d517f279883e','6c752185-ecab-4039-a782-171f75036a34','TRANSMITTED',0,'2024-05-29 15:04:12.904'),(3,'3ffa3b3a-0869-11ef-8ff6-da2f5a35fe58','b84baf20-3ca6-4653-8341-ac721a404258','TRANSMITTED',0,'2024-05-02 09:49:31.738'),(3,'409777ad-113d-11ef-8f8d-d92a44d56471','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-13 15:27:07.097'),(3,'45671074-ce71-4c4d-97a3-f60edaa91b77','b84baf20-3ca6-4653-8341-ac721a404258','TRANSMITTED',0,'2024-05-13 15:21:48.951'),(3,'47778199-1438-11ef-8f1b-d8242b6da0dc','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-17 10:29:02.312'),(6,'48d94f99-0950-11ef-8f65-d9283bb1c6cd','78919a47-1bcf-424a-a1b2-c19063ff242c','TRANSMITTED',0,'2024-05-03 13:34:10.684'),(15,'49805aee-1dd2-11ef-8f99-d92a46e09137','ed09bdd8-1331-4c59-b52b-b0000e585e7d','DELIVERED',0,'2024-05-29 15:44:09.734'),(3,'4b822710-1469-11ef-8f1b-d8242b6da0dc','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-17 16:19:55.866'),(3,'4de24f2b-086d-11ef-8ff6-da2f5a35fe58','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-02 10:18:25.095'),(15,'517d0d0f-1dd4-11ef-8e10-d517f279883e','ed09bdd8-1331-4c59-b52b-b0000e585e7d','DELIVERED',0,'2024-05-29 16:05:51.338'),(15,'54c01682-1dcc-11ef-8e10-d517f279883e','6c752185-ecab-4039-a782-171f75036a34','TRANSMITTED',0,'2024-05-29 15:04:12.913'),(3,'57c2d78c-086d-11ef-8ff6-da2f5a35fe58','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-02 10:18:39.052'),(15,'5959503d-1dd2-11ef-8f99-d92a46e09137','ed09bdd8-1331-4c59-b52b-b0000e585e7d','DELIVERED',0,'2024-05-29 15:44:35.241'),(3,'5e14225d-1469-11ef-8f1b-d8242b6da0dc','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-17 16:20:25.528'),(15,'65b39fb1-1dd2-11ef-8f99-d92a46e09137','6c752185-ecab-4039-a782-171f75036a34','DELIVERED',0,'2024-05-29 15:44:55.917'),(3,'68135cb6-086e-11ef-8ff6-da2f5a35fe58','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-02 10:26:15.953'),(3,'6d270b56-0c6a-4586-810b-b2149a940503','b84baf20-3ca6-4653-8341-ac721a404258','TRANSMITTED',0,'2024-05-02 09:35:21.103'),(15,'6f66c850-1dc9-11ef-8e10-d517f279883e','6c752185-ecab-4039-a782-171f75036a34','TRANSMITTED',0,'2024-05-29 15:04:12.884'),(3,'7c835c86-aa16-429b-bad8-5ee8de4f3075','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-03 13:00:30.893'),(15,'8110e56d-1dcc-11ef-8e10-d517f279883e','6c752185-ecab-4039-a782-171f75036a34','TRANSMITTED',0,'2024-05-29 15:04:12.919'),(15,'8bfc228e-1dc9-11ef-8e10-d517f279883e','6c752185-ecab-4039-a782-171f75036a34','TRANSMITTED',0,'2024-05-29 15:04:12.889'),(3,'8cb3a6c4-1467-11ef-8f1b-d8242b6da0dc','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-17 16:07:26.912'),(3,'953cc15b-1436-11ef-8f1b-d8242b6da0dc','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-17 10:16:55.050'),(3,'97b9c350-06ed-11ef-90c8-dd3986f53a42','8e4a4b16-c567-4bf8-a434-976b627a70ca','DELIVERED',0,'2024-04-30 12:31:41.339'),(3,'985a9923-0869-11ef-8ff6-da2f5a35fe58','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-02 09:51:49.480'),(3,'9aa53190-086d-11ef-8ff6-da2f5a35fe58','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-02 10:20:31.279'),(15,'9b7ecd4a-1dc9-11ef-8e10-d517f279883e','6c752185-ecab-4039-a782-171f75036a34','TRANSMITTED',0,'2024-05-29 15:04:12.893'),(6,'b0b74f75-1cf3-11ef-8f68-d9283cb4d201','78919a47-1bcf-424a-a1b2-c19063ff242c','DELIVERED',0,'2024-05-28 13:10:44.229'),(3,'b96617fb-113d-11ef-8f8d-d92a44d56471','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-13 15:30:27.894'),(3,'c70e8190-0954-11ef-8f65-d9283bb1c6cd','1ae8fb0f-2111-4ecf-a290-dcae6e15100e','TRANSMITTED',0,'2024-05-03 14:05:37.019'),(3,'ccb7c702-1436-11ef-8f1b-d8242b6da0dc','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-17 10:18:26.857'),(3,'ce651eec-25d4-41a0-8016-4e29b837509d','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-17 10:28:39.429'),(3,'d54e8176-0867-11ef-8ff6-da2f5a35fe58','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-02 09:39:12.736'),(14,'dad003d5-1dca-11ef-8f99-d92a46e09137','0766ca08-5ada-47b8-baa2-a27549c326da','DELIVERED',0,'2024-05-29 14:50:56.570'),(3,'e68d94d2-1436-11ef-8f1b-d8242b6da0dc','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-17 10:19:11.147'),(3,'ea731232-0867-11ef-8ff6-da2f5a35fe58','b84baf20-3ca6-4653-8341-ac721a404258','TRANSMITTED',0,'2024-05-02 09:39:55.131'),(6,'eaccaaf0-0951-11ef-8f65-d9283bb1c6cd','78919a47-1bcf-424a-a1b2-c19063ff242c','DELIVERED',0,'2024-05-03 13:34:51.721'),(3,'eb779002-1437-11ef-8f1b-d8242b6da0dc','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-17 10:26:29.096'),(6,'ed509888-1cf1-11ef-8f68-d9283cb4d201','78919a47-1bcf-424a-a1b2-c19063ff242c','DELIVERED',0,'2024-05-28 12:58:08.992'),(14,'ef5d1e0d-1dcb-11ef-8f99-d92a46e09137','e248d5a9-259a-4099-8608-118ba5c8da3a','DELIVERED',0,'2024-05-29 14:58:40.539'),(3,'f32e1637-1436-11ef-8f1b-d8242b6da0dc','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-17 10:19:31.323'),(3,'f42b2ad8-113b-11ef-8f8d-d92a44d56471','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-13 15:17:50.328'),(3,'f7a50be4-a6c8-4e99-8a5e-b63e5c936eed','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-17 10:18:01.164'),(15,'f924ab7b-1dca-11ef-8e10-d517f279883e','6c752185-ecab-4039-a782-171f75036a34','TRANSMITTED',0,'2024-05-29 15:04:12.900'),(3,'fd3a7c7d-1437-11ef-8f1b-d8242b6da0dc','b84baf20-3ca6-4653-8341-ac721a404258','DELIVERED',0,'2024-05-17 10:26:57.699');
/*!40000 ALTER TABLE `MessageStatus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Occlusion`
--

DROP TABLE IF EXISTS `Occlusion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Occlusion` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `sessionId` varchar(36) DEFAULT NULL,
  `occlusionType` enum('UNKNOWN','HEMI_ARCADE_POSTERIEUR_DROIT','HEMI_ARCADE_POSTERIEUR_GAUCHE','HEMI_ARCADE_ANTERIEUR','ARCADE_COMPLETE_ANTERIEUR','ARCADE_COMPLETE') DEFAULT 'UNKNOWN',
  `displayId` mediumint(8) unsigned DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT 0,
  `comments` text DEFAULT NULL,
  `topScanId` varchar(36) DEFAULT NULL,
  `bottomScanId` varchar(36) DEFAULT NULL,
  `anteriorBiteScanId` varchar(36) DEFAULT NULL,
  `rightBiteScanId` varchar(36) DEFAULT NULL,
  `leftBiteScanId` varchar(36) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `sessionId` (`sessionId`),
  KEY `topScanId` (`topScanId`),
  KEY `bottomScanId` (`bottomScanId`),
  KEY `anteriorBiteScanId` (`anteriorBiteScanId`),
  KEY `rightBiteScanId` (`rightBiteScanId`),
  KEY `leftBiteScanId` (`leftBiteScanId`),
  CONSTRAINT `Occlusion_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_2` FOREIGN KEY (`sessionId`) REFERENCES `Session` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_3` FOREIGN KEY (`topScanId`) REFERENCES `Scan` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_4` FOREIGN KEY (`bottomScanId`) REFERENCES `Scan` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_5` FOREIGN KEY (`anteriorBiteScanId`) REFERENCES `Scan` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_6` FOREIGN KEY (`rightBiteScanId`) REFERENCES `Scan` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_7` FOREIGN KEY (`leftBiteScanId`) REFERENCES `Scan` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Occlusion`
--

LOCK TABLES `Occlusion` WRITE;
/*!40000 ALTER TABLE `Occlusion` DISABLE KEYS */;
INSERT INTO `Occlusion` VALUES ('0cf0848e-0869-11ef-8ff6-da2f5a35fe58',3,'a000fd43-0868-11ef-8ff6-da2f5a35fe58','HEMI_ARCADE_ANTERIEUR',1,0,'','be43909f-0868-11ef-8ff6-da2f5a35fe58','eacd5e79-0868-11ef-8ff6-da2f5a35fe58','0da7e703-0869-11ef-8ff6-da2f5a35fe58',NULL,NULL,'2024-05-02 11:47:55.345',NULL,'2024-05-02 11:48:46.190','2024-05-02 09:48:46.190','2024-05-02 11:48:46.203'),('3966fc97-0864-11ef-8ff6-da2f5a35fe58',3,'58e77d50-0861-11ef-8ff6-da2f5a35fe58','ARCADE_COMPLETE',1,0,'','59e98ac5-0861-11ef-8ff6-da2f5a35fe58','91249277-0862-11ef-8ff6-da2f5a35fe58',NULL,'405b2abf-0864-11ef-8ff6-da2f5a35fe58','405b06bd-0864-11ef-8ff6-da2f5a35fe58','2024-05-02 11:13:22.457',NULL,'2024-05-02 11:17:05.021','2024-05-02 09:17:05.021','2024-05-02 11:17:05.035'),('9248b871-0952-11ef-8f65-d9283bb1c6cd',3,'4fc3d0e6-0952-11ef-8f65-d9283bb1c6cd','HEMI_ARCADE_POSTERIEUR_DROIT',1,0,'','53557eda-0952-11ef-8f65-d9283bb1c6cd','7564b229-0952-11ef-8f65-d9283bb1c6cd',NULL,'99f71009-0952-11ef-8f65-d9283bb1c6cd',NULL,'2024-05-03 15:39:32.440',NULL,'2024-05-03 15:43:35.500','2024-05-03 13:43:35.501','2024-05-03 15:43:35.515'),('ab083f2a-0953-11ef-8f65-d9283bb1c6cd',3,'67fdc886-0953-11ef-8f65-d9283bb1c6cd','HEMI_ARCADE_POSTERIEUR_GAUCHE',1,0,'','69c3c2e3-0953-11ef-8f65-d9283bb1c6cd','8384e76f-0953-11ef-8f65-d9283bb1c6cd',NULL,NULL,'abdf5c98-0953-11ef-8f65-d9283bb1c6cd','2024-05-03 15:47:23.458',NULL,'2024-05-03 16:10:20.130','2024-05-03 14:10:20.130','2024-05-03 16:10:20.138'),('c6f93b4f-1dc9-11ef-8f99-d92a46e09137',14,'c6ed23a8-1dc9-11ef-8f99-d92a46e09137','HEMI_ARCADE_POSTERIEUR_DROIT',1,0,'{\"imported\":true}',NULL,NULL,NULL,NULL,NULL,'2024-05-29 16:43:13.562',NULL,'2024-05-29 16:43:13.624','2024-05-29 14:43:13.625','2024-05-29 16:43:13.630'),('d34c3f5e-146c-11ef-8f1b-d8242b6da0dc',3,'574ac047-146a-11ef-8f1b-d8242b6da0dc','HEMI_ARCADE_POSTERIEUR_GAUCHE',1,0,'','ce02f919-146b-11ef-8f1b-d8242b6da0dc','58c830be-146a-11ef-8f1b-d8242b6da0dc',NULL,NULL,'d802a151-146c-11ef-8f1b-d8242b6da0dc','2024-05-17 18:45:10.578',NULL,'2024-05-22 15:59:04.642','2024-05-22 13:59:04.642','2024-05-22 15:59:04.647'),('e3bf7a84-176c-11ef-8f86-d92942cf49fd',3,'b1d043a8-1749-11ef-8f86-d92942cf49fd','HEMI_ARCADE_POSTERIEUR_DROIT',1,0,'','b2fd8f6c-1749-11ef-8f86-d92942cf49fd','a4132a7d-174a-11ef-8f86-d92942cf49fd',NULL,'e68d77dd-176c-11ef-8f86-d92942cf49fd',NULL,'2024-05-21 14:23:11.665',NULL,'2024-05-21 14:27:21.892','2024-05-21 12:27:21.892','2024-05-21 14:27:21.899');
/*!40000 ALTER TABLE `Occlusion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `OcclusionFile`
--

DROP TABLE IF EXISTS `OcclusionFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `OcclusionFile` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `occlusionId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('RESULT','MANDIBLE','MAXILLARY','MANDIBLE_SB','MAXILLARY_SB','MANDIBLE_PRE','MAXILLARY_PRE','MANDIBLE_SUP','MAXILLARY_SUP','LIFI','LIFIMETA','SNAPSHOT','SCREENSHOT','METERING') NOT NULL DEFAULT 'RESULT',
  PRIMARY KEY (`occlusionId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `OcclusionFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `OcclusionFile_ibfk_2` FOREIGN KEY (`occlusionId`) REFERENCES `Occlusion` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `OcclusionFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `OcclusionFile`
--

LOCK TABLES `OcclusionFile` WRITE;
/*!40000 ALTER TABLE `OcclusionFile` DISABLE KEYS */;
INSERT INTO `OcclusionFile` VALUES (3,'0cf0848e-0869-11ef-8ff6-da2f5a35fe58','2aa61e09-0869-11ef-8ff6-da2f5a35fe58','MAXILLARY'),(3,'0cf0848e-0869-11ef-8ff6-da2f5a35fe58','2ac2bcfd-0869-11ef-8ff6-da2f5a35fe58','MANDIBLE'),(3,'0cf0848e-0869-11ef-8ff6-da2f5a35fe58','2b3e9ab9-0869-11ef-8ff6-da2f5a35fe58','SNAPSHOT'),(3,'3966fc97-0864-11ef-8ff6-da2f5a35fe58','a3a69b8b-0864-11ef-8ff6-da2f5a35fe58','MAXILLARY'),(3,'3966fc97-0864-11ef-8ff6-da2f5a35fe58','a3e32cc1-0864-11ef-8ff6-da2f5a35fe58','LIFI'),(3,'3966fc97-0864-11ef-8ff6-da2f5a35fe58','a3e332c3-0864-11ef-8ff6-da2f5a35fe58','LIFIMETA'),(3,'3966fc97-0864-11ef-8ff6-da2f5a35fe58','a3e37662-0864-11ef-8ff6-da2f5a35fe58','LIFI'),(3,'3966fc97-0864-11ef-8ff6-da2f5a35fe58','a3e37c4f-0864-11ef-8ff6-da2f5a35fe58','LIFIMETA'),(3,'3966fc97-0864-11ef-8ff6-da2f5a35fe58','a3e3b7e2-0864-11ef-8ff6-da2f5a35fe58','MANDIBLE'),(3,'3966fc97-0864-11ef-8ff6-da2f5a35fe58','a413fc36-0864-11ef-8ff6-da2f5a35fe58','LIFI'),(3,'3966fc97-0864-11ef-8ff6-da2f5a35fe58','a414024b-0864-11ef-8ff6-da2f5a35fe58','LIFIMETA'),(3,'3966fc97-0864-11ef-8ff6-da2f5a35fe58','a4f01daf-0864-11ef-8ff6-da2f5a35fe58','SNAPSHOT'),(3,'3966fc97-0864-11ef-8ff6-da2f5a35fe58','bdd2799d-0864-11ef-8ff6-da2f5a35fe58','MAXILLARY_SB'),(3,'9248b871-0952-11ef-8f65-d9283bb1c6cd','2312bde5-0953-11ef-8f65-d9283bb1c6cd','MAXILLARY_SB'),(3,'9248b871-0952-11ef-8f65-d9283bb1c6cd','d1385fb9-0952-11ef-8f65-d9283bb1c6cd','MAXILLARY'),(3,'9248b871-0952-11ef-8f65-d9283bb1c6cd','d14eaa57-0952-11ef-8f65-d9283bb1c6cd','MANDIBLE'),(3,'9248b871-0952-11ef-8f65-d9283bb1c6cd','d1cb1f63-0952-11ef-8f65-d9283bb1c6cd','SNAPSHOT'),(3,'ab083f2a-0953-11ef-8f65-d9283bb1c6cd','20b557de-0954-11ef-8f65-d9283bb1c6cd','SCREENSHOT'),(3,'ab083f2a-0953-11ef-8f65-d9283bb1c6cd','d1d98002-0953-11ef-8f65-d9283bb1c6cd','MAXILLARY'),(3,'ab083f2a-0953-11ef-8f65-d9283bb1c6cd','d1f26a61-0953-11ef-8f65-d9283bb1c6cd','MANDIBLE'),(3,'ab083f2a-0953-11ef-8f65-d9283bb1c6cd','d26c0218-0953-11ef-8f65-d9283bb1c6cd','SNAPSHOT'),(3,'ab083f2a-0953-11ef-8f65-d9283bb1c6cd','dd1cfe26-0956-11ef-8f65-d9283bb1c6cd','SCREENSHOT'),(3,'ab083f2a-0953-11ef-8f65-d9283bb1c6cd','df977aae-0956-11ef-8f65-d9283bb1c6cd','METERING'),(14,'c6f93b4f-1dc9-11ef-8f99-d92a46e09137','c6f959d7-1dc9-11ef-8f99-d92a46e09137','MAXILLARY'),(14,'c6f93b4f-1dc9-11ef-8f99-d92a46e09137','c6fddf69-1dc9-11ef-8f99-d92a46e09137','MANDIBLE'),(14,'c6f93b4f-1dc9-11ef-8f99-d92a46e09137','c7029c5e-1dc9-11ef-8f99-d92a46e09137','SNAPSHOT'),(3,'d34c3f5e-146c-11ef-8f1b-d8242b6da0dc','19439b6b-146d-11ef-8f1b-d8242b6da0dc','MAXILLARY'),(3,'d34c3f5e-146c-11ef-8f1b-d8242b6da0dc','195c0d37-146d-11ef-8f1b-d8242b6da0dc','MANDIBLE'),(3,'d34c3f5e-146c-11ef-8f1b-d8242b6da0dc','19d141c6-146d-11ef-8f1b-d8242b6da0dc','SNAPSHOT'),(3,'d34c3f5e-146c-11ef-8f1b-d8242b6da0dc','2370c2cb-146d-11ef-8f1b-d8242b6da0dc','MANDIBLE_SB'),(3,'d34c3f5e-146c-11ef-8f1b-d8242b6da0dc','6b8bbed9-1843-11ef-8f8e-d92a44d6667d','SCREENSHOT'),(3,'e3bf7a84-176c-11ef-8f86-d92942cf49fd','0fe386e8-176d-11ef-8f86-d92942cf49fd','MAXILLARY'),(3,'e3bf7a84-176c-11ef-8f86-d92942cf49fd','0ff91bc5-176d-11ef-8f86-d92942cf49fd','MANDIBLE'),(3,'e3bf7a84-176c-11ef-8f86-d92942cf49fd','106d53d3-176d-11ef-8f86-d92942cf49fd','SNAPSHOT'),(3,'e3bf7a84-176c-11ef-8f86-d92942cf49fd','2563eb4a-176d-11ef-8f86-d92942cf49fd','MAXILLARY_SB'),(3,'e3bf7a84-176c-11ef-8f86-d92942cf49fd','5b39c854-176d-11ef-8f86-d92942cf49fd','SCREENSHOT'),(3,'e3bf7a84-176c-11ef-8f86-d92942cf49fd','5e5e77e4-176d-11ef-8f86-d92942cf49fd','METERING'),(3,'e3bf7a84-176c-11ef-8f86-d92942cf49fd','704be2c2-176d-11ef-8f86-d92942cf49fd','LIFI'),(3,'e3bf7a84-176c-11ef-8f86-d92942cf49fd','704be63e-176d-11ef-8f86-d92942cf49fd','LIFIMETA'),(3,'e3bf7a84-176c-11ef-8f86-d92942cf49fd','78e4d99e-176d-11ef-8f86-d92942cf49fd','LIFI'),(3,'e3bf7a84-176c-11ef-8f86-d92942cf49fd','78e4dd56-176d-11ef-8f86-d92942cf49fd','LIFIMETA');
/*!40000 ALTER TABLE `OcclusionFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Office`
--

DROP TABLE IF EXISTS `Office`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Office` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `mainPhone` varchar(45) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `cityName` varchar(255) DEFAULT NULL,
  `cityZip` varchar(25) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `country` varchar(75) DEFAULT NULL,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  CONSTRAINT `Office_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Office`
--

LOCK TABLES `Office` WRITE;
/*!40000 ALTER TABLE `Office` DISABLE KEYS */;
INSERT INTO `Office` VALUES ('0390c669-d2b0-418c-b667-f3c51880a8a0',14,'123443211234','demo21','','brest','11111','avenue des tests','France',NULL,'2024-05-29 12:22:40.000','2024-05-29 10:22:45.080','2024-05-29 12:22:45.080'),('0ac16b23-6842-4c9f-8ae1-c9aebd8f89a6',2,'0606060606','Office','','Labège','31670','137 rue Garance','France',NULL,'2024-04-30 13:57:19.000','2024-04-30 11:57:19.000','2024-04-30 13:57:19.000'),('287e0ded-97c2-45b8-9ab9-08a0140e339c',15,'1234533455533','demo22','','fdsfdsfds','23456','rue des testsss','United States of America',NULL,'2024-05-29 16:05:14.000','2024-05-29 15:04:10.523','2024-05-29 17:04:10.523'),('2b879809-8839-11ec-89bc-2e174fce41cd',1,'0606060606','Biotech-Dental','','Toulouse','31100','Route du test','France',NULL,'2024-04-30 13:44:41.000','2024-04-30 11:44:41.000','2024-04-30 13:44:41.000'),('2d8ca014-6913-4b1a-b659-633a90708e87',3,'1234567','iris','','labege','31670','site dev','France',NULL,'2024-04-30 14:26:29.000','2024-04-30 12:26:30.925','2024-04-30 14:26:30.925'),('3c55d1a1-bd27-463a-be3b-766e5354009e',6,'0987654321','demo3','','bla blasqfdfdsfqs','1111fsfsqfq','hfgsqhfjghdsqgfhdsjqgfhdsjq','France',NULL,'2024-05-28 14:51:12.228','2024-05-28 12:51:12.228','2024-05-28 14:51:12.230'),('8b4f0379-1a1b-43c7-9a07-4684a35a2202',13,'1234567','demo20','','fdsqfdqf','11154','azertyuiop','France',NULL,'2024-05-28 16:41:52.000','2024-05-28 14:41:52.000','2024-05-28 16:41:52.000'),('c3424a09-cea7-4186-9806-569283aff7d8',5,'fsddfdsqfdsqfdsq','succursalle Salles d\'Aude','','sfdfdsqfs','fedsqfd','dsfdqfdqf','France',NULL,'2024-05-03 14:02:50.000','2024-05-03 12:02:50.000','2024-05-03 14:02:50.000'),('ff4e6b8d-9265-4329-8c37-ae1742b98869',4,'123456','','','labege','','','France',NULL,'2024-05-02 11:30:48.000','2024-05-02 09:32:32.000','2024-05-02 11:32:32.000');
/*!40000 ALTER TABLE `Office` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PersonInfo`
--

DROP TABLE IF EXISTS `PersonInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `PersonInfo` (
  `uuid` varchar(36) NOT NULL,
  `firstname` varchar(64) NOT NULL,
  `lastname` varchar(64) NOT NULL,
  `email` varchar(255) NOT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PersonInfo`
--

LOCK TABLES `PersonInfo` WRITE;
/*!40000 ALTER TABLE `PersonInfo` DISABLE KEYS */;
INSERT INTO `PersonInfo` VALUES ('13ae1ca1-a46e-4834-b4ab-609e4880f1bf','demo22','demo de 2 à 1','demo22@qsdf.net','2024-05-29 14:39:43.652','2024-05-29 16:37:29.000'),('14055cfa-37c1-468f-9644-d18d638ac7ba','demo20','demo','demo20@dfqf.net','2024-05-28 14:55:40.020','2024-05-29 16:13:20.000'),('1e8cdf1b-215c-4ac5-b249-3c62bb75f98a','Félix','LEDEE CAUCHI','felix.ledee@scan4all.fr','2024-05-02 08:52:26.296','2024-04-30 14:37:26.000'),('2bb3f96e-e4f0-41fb-8d37-2b18b9378704','demo22env2','assistant1','assistant1demo22env2@hjgjh.net','2024-05-29 15:24:35.381','2024-05-29 17:18:57.000'),('313033e8-830e-4879-bf9c-1098d2fb9d43','succursalle Salles d\'Aude','Laboratoire scan4all','sabinecaserta@live.fr','2024-05-03 14:24:52.977','2024-05-17 18:23:07.000'),('3725a8d7-3207-4b14-abb7-5f8dddd4d097','demo3pc2','S4Apc2','azerty@scan4all.fr','2024-05-28 13:52:35.170','2024-05-28 15:51:10.000'),('4114e703-8838-11ec-89bc-2e174fce41cd','Biotech-Dental','LABORATOIRE','lab@biotech-dental.pro','2024-04-30 12:26:31.644','2024-04-30 13:44:41.000'),('63c8d5a2-b9f0-4ceb-84d5-287f0dffe537','sabine','Caserta','sabine.caserta@scan4all.fr','2024-04-30 12:26:30.919','2024-05-29 16:57:45.000'),('7196af1e-1e87-48b9-84bd-d9db7a7a907e','assistant1','assistant','gamajesa@hotmail.fr','2024-05-28 12:53:03.252','2024-05-28 14:54:07.240'),('baee14ff-c898-4c00-a8fc-c3cc04d03c09','client','leger','alertes.documentation@scan4all.fr','2024-05-02 09:32:34.142','2024-05-02 11:33:13.000'),('f65b355e-a686-42b9-bfc0-ba0a1c1b17ac','demo21','demo','demo21@fdsf.net','2024-05-29 10:22:45.069','2024-05-29 16:13:35.000');
/*!40000 ALTER TABLE `PersonInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PhoneInfo`
--

DROP TABLE IF EXISTS `PhoneInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `PhoneInfo` (
  `uuid` varchar(36) NOT NULL,
  `phone` varchar(45) DEFAULT NULL,
  `cellular` varchar(45) DEFAULT NULL,
  `fax` varchar(45) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PhoneInfo`
--

LOCK TABLES `PhoneInfo` WRITE;
/*!40000 ALTER TABLE `PhoneInfo` DISABLE KEYS */;
INSERT INTO `PhoneInfo` VALUES ('093fd04a-a408-410c-8ef3-58cc4b2a5f3b','1234567','','','2024-04-30 12:26:30.919','2024-05-29 16:57:45.000'),('230961f5-8e72-4729-bdd7-fd502443d733','123456','','','2024-05-02 09:32:34.142','2024-05-02 11:33:13.000'),('47ead308-8838-11ec-89bc-2e174fce41cd','0606060606','','','2024-04-30 12:26:31.652','2024-04-30 13:44:41.000'),('4ccaba01-0de7-4065-944b-5dff11628526','123123','','','2024-05-03 13:13:42.731','2024-05-28 15:51:10.000'),('58e8de82-6a5a-4e72-a80e-3316ccbf2ebb','123443211234','','','2024-05-29 10:22:45.069','2024-05-29 16:13:35.000'),('755a062b-fac8-4077-b64d-07c49958d038','1234567','','','2024-05-28 14:55:40.029','2024-05-29 16:13:20.000'),('790ceaab-dc21-491f-ac6e-b832ce9aba1e','0606060606','','','2024-04-30 12:34:01.220','2024-04-30 14:37:26.000'),('b64df718-f35d-44f7-86d8-7c09dd16e793','1234533455533','','','2024-05-29 14:14:05.015','2024-05-29 16:37:29.000'),('c1466cf3-afd0-43ac-99d1-ee9e967db682','','','','2024-05-29 15:24:35.390','2024-05-29 17:18:57.000'),('d5eb0151-3a5a-452d-9747-21aebfa2df98','fsddfdsqfdsqfdsq','','','2024-05-03 14:24:52.987','2024-05-17 18:23:07.000'),('f6dc0cc8-623e-43dc-8c77-74e9c435b50f','','','','2024-05-28 12:53:03.253','2024-05-28 14:54:07.240');
/*!40000 ALTER TABLE `PhoneInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Professional`
--

DROP TABLE IF EXISTS `Professional`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Professional` (
  `uuid` varchar(36) NOT NULL,
  `id` mediumint(8) unsigned NOT NULL,
  `credentialsId` varchar(36) DEFAULT NULL,
  `personInfoId` varchar(36) NOT NULL,
  `phoneInfoId` varchar(36) NOT NULL,
  `addressInfoId` varchar(36) NOT NULL,
  `configId` mediumint(8) unsigned DEFAULT NULL,
  `syncInfoId` mediumint(8) unsigned DEFAULT NULL,
  `surgeryName` varchar(255) DEFAULT NULL,
  `comments` text DEFAULT NULL,
  `type` enum('UNDEFINED','PROTHESIST','DENTIST','DEMO','OTHER') NOT NULL DEFAULT 'UNDEFINED',
  `limitedContactId` varchar(36) DEFAULT NULL,
  `directoryVisible` tinyint(1) NOT NULL DEFAULT 1,
  `statusGalaxy` tinyint(1) DEFAULT 0,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  UNIQUE KEY `personInfoId` (`personInfoId`),
  UNIQUE KEY `phoneInfoId` (`phoneInfoId`),
  UNIQUE KEY `addressInfoId` (`addressInfoId`),
  UNIQUE KEY `credentialsId` (`credentialsId`),
  KEY `syncInfoId` (`syncInfoId`,`id`),
  KEY `configId` (`configId`,`id`),
  CONSTRAINT `Professional_ibfk_1` FOREIGN KEY (`credentialsId`) REFERENCES `Credentials` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_2` FOREIGN KEY (`personInfoId`) REFERENCES `PersonInfo` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_3` FOREIGN KEY (`phoneInfoId`) REFERENCES `PhoneInfo` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_4` FOREIGN KEY (`addressInfoId`) REFERENCES `AddressInfo` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_5` FOREIGN KEY (`syncInfoId`, `id`) REFERENCES `SyncInfo` (`id`, `ownerId`) ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_6` FOREIGN KEY (`configId`, `id`) REFERENCES `Config` (`id`, `ownerId`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Professional`
--

LOCK TABLES `Professional` WRITE;
/*!40000 ALTER TABLE `Professional` DISABLE KEYS */;
INSERT INTO `Professional` VALUES ('71b743e8-8838-11ec-89bc-2e174fce41cd',1,'2e995095-88b2-11ec-89bc-2e174fce41cd','4114e703-8838-11ec-89bc-2e174fce41cd','47ead308-8838-11ec-89bc-2e174fce41cd','4caacc66-8838-11ec-89bc-2e174fce41cd',1,1,'','','PROTHESIST',NULL,1,0,NULL,'2024-04-30 13:44:41.000','2024-04-30 11:44:41.000','2024-04-30 13:44:41.000'),('29ae88de-072b-4bb4-a086-5ff64b936b70',2,'494c56b7-3289-46d8-838b-2e68cd18ca5b','1e8cdf1b-215c-4ac5-b249-3c62bb75f98a','790ceaab-dc21-491f-ac6e-b832ce9aba1e','a5e85963-fe76-4488-a34e-59cf90eee3e0',1,1,'','','DENTIST',NULL,1,0,NULL,'2024-04-30 16:20:51.000','2024-04-30 14:36:08.000','2024-04-30 14:37:26.000'),('dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','63c8d5a2-b9f0-4ceb-84d5-287f0dffe537','093fd04a-a408-410c-8ef3-58cc4b2a5f3b','67cbd5eb-5e68-4f9b-9a15-2b1a0dabbcef',1,1,'','','PROTHESIST',NULL,1,0,NULL,'2024-04-30 14:26:29.000','2024-05-29 14:57:45.000','2024-05-29 16:57:45.000'),('429bbf37-e15c-4430-af34-41c8f46437a6',4,'f2d078ea-bb55-4650-a755-6b8c3cc8f5bc','baee14ff-c898-4c00-a8fc-c3cc04d03c09','230961f5-8e72-4729-bdd7-fd502443d733','b920f641-ec66-47f2-b374-25b1f9188d1d',1,1,'','','PROTHESIST',NULL,1,0,NULL,'2024-05-02 11:30:47.000','2024-05-02 09:32:32.000','2024-05-02 11:33:13.000'),('bc12031b-ce01-47c7-85b2-de0e61ebc8ee',5,'f66ac278-aafe-4a05-b86f-e686f664bda7','313033e8-830e-4879-bf9c-1098d2fb9d43','d5eb0151-3a5a-452d-9747-21aebfa2df98','58363558-12f0-4477-a836-a6476e5d243f',1,1,'','','PROTHESIST',NULL,1,0,NULL,'2024-05-03 14:02:50.000','2024-05-17 16:23:07.000','2024-05-17 18:23:07.000'),('5e94742e-1a7e-484b-ad67-74101348d108',6,'afdaf315-9060-4a46-b958-9a7c00ce122c','3725a8d7-3207-4b14-abb7-5f8dddd4d097','4ccaba01-0de7-4065-944b-5dff11628526','0788e1c4-cb4f-4340-8ad2-2ff803c01013',1,1,'','','DENTIST',NULL,1,0,NULL,'2024-05-28 15:51:10.000','2024-05-28 13:51:10.000','2024-05-28 15:51:10.000'),('d8b1703e-1bd9-4740-81ba-cbad07f8cabd',13,'655eb1b9-6ae7-4293-9737-358c951fbf71','14055cfa-37c1-468f-9644-d18d638ac7ba','755a062b-fac8-4077-b64d-07c49958d038','234f4254-42b9-463d-9618-ac68be566f22',1,1,'','','DENTIST',NULL,1,0,NULL,'2024-05-28 16:41:51.000','2024-05-29 14:13:20.000','2024-05-29 16:13:20.000'),('15df53c7-ad9e-4f1e-a585-21f844968574',14,'466cbc9a-1ff6-4044-8fba-678393bc0252','f65b355e-a686-42b9-bfc0-ba0a1c1b17ac','58e8de82-6a5a-4e72-a80e-3316ccbf2ebb','ce12056e-5597-4850-b65d-d74e282fb653',1,1,'','','DENTIST',NULL,1,0,NULL,'2024-05-29 12:22:39.000','2024-05-29 14:13:35.000','2024-05-29 16:13:35.000'),('397b4e6f-5e8d-4926-8242-58217e16b7cd',15,'bd241e23-6d6c-4ee5-82d6-187dfde89f13','13ae1ca1-a46e-4834-b4ab-609e4880f1bf','b64df718-f35d-44f7-86d8-7c09dd16e793','2c571305-dd4e-4bcd-baac-ec78eda07e7a',1,1,'','','DENTIST',NULL,1,0,NULL,'2024-05-29 16:37:29.000','2024-05-29 14:37:29.000','2024-05-29 16:37:29.000');
/*!40000 ALTER TABLE `Professional` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProfessionalEnvInfos`
--

DROP TABLE IF EXISTS `ProfessionalEnvInfos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProfessionalEnvInfos` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `accessCode` varchar(45) DEFAULT NULL,
  `status` enum('CREATED','CONFIRMED','BLOCKED') NOT NULL DEFAULT 'CREATED',
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`ownerId`),
  CONSTRAINT `ProfessionalEnvInfos_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProfessionalEnvInfos`
--

LOCK TABLES `ProfessionalEnvInfos` WRITE;
/*!40000 ALTER TABLE `ProfessionalEnvInfos` DISABLE KEYS */;
INSERT INTO `ProfessionalEnvInfos` VALUES (1,'','CONFIRMED','2024-04-30 12:26:31.663','2024-04-30 14:26:31.663'),(2,'','CONFIRMED','2024-04-30 12:34:01.230','2024-04-30 14:34:01.230'),(3,'','CONFIRMED','2024-04-30 12:26:30.925','2024-04-30 14:26:30.925'),(4,'','CONFIRMED','2024-05-02 09:32:34.146','2024-05-02 11:32:34.146'),(5,'','CONFIRMED','2024-05-03 14:24:52.997','2024-05-03 16:24:52.997'),(6,'','CONFIRMED','2024-05-03 13:13:42.742','2024-05-03 15:13:42.742'),(13,'','CONFIRMED','2024-05-28 14:55:40.039','2024-05-28 16:55:40.039'),(14,'','CONFIRMED','2024-05-29 10:22:45.080','2024-05-29 12:22:45.080'),(15,'','CONFIRMED','2024-05-29 14:14:05.023','2024-05-29 16:14:05.023');
/*!40000 ALTER TABLE `ProfessionalEnvInfos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProfessionalPatient`
--

DROP TABLE IF EXISTS `ProfessionalPatient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProfessionalPatient` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `patientId` varchar(36) NOT NULL,
  `officeId` varchar(36) DEFAULT NULL,
  `enablePatientSharing` tinyint(1) DEFAULT 0,
  `pinned` tinyint(1) NOT NULL DEFAULT 0,
  `theme` enum('NONE','ADULT','BOY','GIRL','BABY') DEFAULT 'NONE',
  PRIMARY KEY (`ownerId`,`patientId`),
  KEY `patientId` (`patientId`),
  KEY `officeId` (`officeId`),
  CONSTRAINT `ProfessionalPatient_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `ProfessionalPatient_ibfk_2` FOREIGN KEY (`patientId`) REFERENCES `iris_patient`.`Patient` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `ProfessionalPatient_ibfk_3` FOREIGN KEY (`officeId`) REFERENCES `Office` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProfessionalPatient`
--

LOCK TABLES `ProfessionalPatient` WRITE;
/*!40000 ALTER TABLE `ProfessionalPatient` DISABLE KEYS */;
INSERT INTO `ProfessionalPatient` VALUES (3,'00c2d95b-06ed-11ef-90c8-dd3986f53a42','2d8ca014-6913-4b1a-b659-633a90708e87',0,0,'NONE'),(3,'118618c7-11fa-11ef-8fe1-da2e5522abf3','2d8ca014-6913-4b1a-b659-633a90708e87',0,0,'NONE'),(3,'16032a0e-1436-11ef-8f1b-d8242b6da0dc','2d8ca014-6913-4b1a-b659-633a90708e87',0,0,'NONE'),(3,'21d1572e-0943-11ef-8f65-d9283bb1c6cd','2d8ca014-6913-4b1a-b659-633a90708e87',0,0,'NONE'),(3,'235a3115-11cf-11ef-8f95-d92a45dc80ec','2d8ca014-6913-4b1a-b659-633a90708e87',0,0,'NONE'),(3,'4ce59675-1136-11ef-8f8d-d92a44d56471','2d8ca014-6913-4b1a-b659-633a90708e87',0,0,'NONE'),(3,'654307f6-1f2c-11ef-8f88-d92a43d1501c','2d8ca014-6913-4b1a-b659-633a90708e87',0,0,'NONE'),(3,'e7cdc6df-144c-11ef-8f1b-d8242b6da0dc','2d8ca014-6913-4b1a-b659-633a90708e87',0,0,'NONE'),(6,'8578524d-1cf1-11ef-8f68-d9283cb4d201','3c55d1a1-bd27-463a-be3b-766e5354009e',0,0,'NONE'),(6,'bbee50d8-094f-11ef-8f65-d9283bb1c6cd','3c55d1a1-bd27-463a-be3b-766e5354009e',0,0,'NONE'),(14,'c6dd7b08-1dc9-11ef-8f99-d92a46e09137','0390c669-d2b0-418c-b667-f3c51880a8a0',0,0,'NONE'),(15,'8eb8d841-1dc4-11ef-8e10-d517f279883e','287e0ded-97c2-45b8-9ab9-08a0140e339c',0,0,'NONE'),(15,'de66fe79-1dd1-11ef-8f99-d92a46e09137','287e0ded-97c2-45b8-9ab9-08a0140e339c',0,0,'NONE'),(15,'f6c1a0a8-1dc6-11ef-8e10-d517f279883e','287e0ded-97c2-45b8-9ab9-08a0140e339c',0,0,'NONE');
/*!40000 ALTER TABLE `ProfessionalPatient` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrder`
--

DROP TABLE IF EXISTS `ProstheticOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProstheticOrder` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `actId` varchar(36) NOT NULL,
  `title` varchar(64) DEFAULT NULL,
  `status` enum('NOT_SENT','SENT','DATE_VALIDATED','DATE_EDITED','VALIDATED','CANCELLED','DELIVERY') NOT NULL DEFAULT 'NOT_SENT',
  `unread` tinyint(1) DEFAULT 0,
  `currentDeliveryDate` datetime(3) DEFAULT NULL,
  `previousDeliveryDate` datetime(3) DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT 0,
  `displayId` mediumint(8) unsigned DEFAULT NULL,
  `createdById` varchar(36) DEFAULT NULL,
  `updatedById` varchar(36) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `actId` (`actId`),
  CONSTRAINT `ProstheticOrder_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrder_ibfk_2` FOREIGN KEY (`actId`) REFERENCES `Act` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrder`
--

LOCK TABLES `ProstheticOrder` WRITE;
/*!40000 ALTER TABLE `ProstheticOrder` DISABLE KEYS */;
INSERT INTO `ProstheticOrder` VALUES ('0e416c0d-0947-11ef-8f65-d9283bb1c6cd',3,'33ac516e-0943-11ef-8f65-d9283bb1c6cd','Commande 1.2.1.1','VALIDATED',0,'2024-05-05 00:00:00.000','2024-05-04 00:00:00.000',0,1,'dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-03 14:17:06.000',NULL,'2024-05-03 15:00:28.000','2024-05-03 13:00:29.000','2024-05-03 15:00:29.000'),('1771f67f-11fa-11ef-8fe1-da2e5522abf3',3,'176ffa22-11fa-11ef-8fe1-da2e5522abf3','Commande 1.5.1.1','NOT_SENT',1,NULL,NULL,1,1,'dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-14 15:58:50.461',NULL,'2024-05-14 15:58:50.462','2024-05-14 13:58:50.462',NULL),('1f4743e1-1436-11ef-8f1b-d8242b6da0dc',3,'1f4547de-1436-11ef-8f1b-d8242b6da0dc','Commande 1.6.1.1','VALIDATED',0,'2024-05-19 00:00:00.000','2024-05-18 00:00:00.000',0,1,'dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-17 12:13:35.000',NULL,'2024-05-17 12:17:58.000','2024-05-17 10:17:59.000','2024-05-17 12:17:59.000'),('233cdf71-113d-11ef-8f8d-d92a44d56471',3,'233ae18e-113d-11ef-8f8d-d92a44d56471','Commande 1.3.2.1','SENT',0,'2024-05-14 00:00:00.000',NULL,0,1,'dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-13 17:26:15.000',NULL,'2024-05-13 17:27:04.000','2024-05-13 15:27:05.000','2024-05-13 17:27:05.000'),('2a5536d8-11cf-11ef-8f95-d92a45dc80ec',3,'2a532631-11cf-11ef-8f95-d92a45dc80ec','Commande 1.4.1.1','NOT_SENT',1,NULL,NULL,1,1,'dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-14 10:51:33.790',NULL,'2024-05-14 10:51:33.791','2024-05-14 08:51:33.791',NULL),('3a968bff-1dd2-11ef-8f99-d92a46e09137',15,'3a94919f-1dd2-11ef-8f99-d92a46e09137','Commande 2.3.2.1','DATE_VALIDATED',0,'2024-05-30 00:00:00.000',NULL,0,1,'397b4e6f-5e8d-4926-8242-58217e16b7cd','397b4e6f-5e8d-4926-8242-58217e16b7cd','2024-05-29 17:43:43.000',NULL,'2024-05-29 17:55:20.000','2024-05-29 15:55:20.000','2024-05-29 17:55:20.000'),('3d2b8fcd-1dca-11ef-8f99-d92a46e09137',14,'c6ecdf7f-1dc9-11ef-8f99-d92a46e09137','Commande 1.1.1.1','NOT_SENT',1,NULL,NULL,1,1,'15df53c7-ad9e-4f1e-a585-21f844968574','15df53c7-ad9e-4f1e-a585-21f844968574','2024-05-29 16:46:31.863',NULL,'2024-05-29 16:46:31.865','2024-05-29 14:46:31.865',NULL),('419edfb4-1469-11ef-8f1b-d8242b6da0dc',3,'419ce9d8-1469-11ef-8f1b-d8242b6da0dc','Commande 1.7.2.1','SENT',1,'2024-05-18 00:00:00.000',NULL,0,1,'dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-17 18:19:37.682',NULL,'2024-05-17 18:19:54.260','2024-05-17 16:19:54.261','2024-05-17 18:19:54.264'),('42c58eea-0958-11ef-8f65-d9283bb1c6cd',3,'42c42325-0958-11ef-8f65-d9283bb1c6cd','Commande 1.2.8.1','NOT_SENT',1,NULL,NULL,1,1,'dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-03 16:20:16.021','2024-05-03 16:20:32.407','2024-05-03 16:20:32.407','2024-05-03 14:20:32.407',NULL),('47d6e672-086d-11ef-8ff6-da2f5a35fe58',3,'1fcf39f6-086d-11ef-8ff6-da2f5a35fe58','Commande 1.1.5.1','CANCELLED',0,'2024-05-03 00:00:00.000',NULL,0,1,'dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-02 12:18:12.000',NULL,'2024-05-02 12:19:34.000','2024-05-02 10:19:34.000','2024-05-02 12:19:34.000'),('4dd5f101-06ed-11ef-90c8-dd3986f53a42',3,'4dd3e575-06ed-11ef-90c8-dd3986f53a42','Commande 1.1.1.1','VALIDATED',0,'2024-06-14 00:00:00.000','2024-05-31 00:00:00.000',0,1,'dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-04-30 14:29:35.000',NULL,'2024-04-30 14:32:57.000','2024-04-30 12:32:58.000','2024-04-30 14:32:58.000'),('4fc42b0a-0952-11ef-8f65-d9283bb1c6cd',3,'4fc2347a-0952-11ef-8f65-d9283bb1c6cd','Commande 1.2.6.1','NOT_SENT',1,NULL,NULL,1,1,'dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-03 15:37:40.842',NULL,'2024-05-03 15:37:40.843','2024-05-03 13:37:40.843',NULL),('574b2236-146a-11ef-8f1b-d8242b6da0dc',3,'5748a11c-146a-11ef-8f1b-d8242b6da0dc','Commande 1.7.3.1','NOT_SENT',1,NULL,NULL,1,1,'dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-17 18:27:23.540',NULL,'2024-05-17 18:27:23.541','2024-05-17 16:27:23.541',NULL),('58e7cf64-0861-11ef-8ff6-da2f5a35fe58',3,'58e7015d-0861-11ef-8ff6-da2f5a35fe58','Commande 1.1.2.1','VALIDATED',0,'2024-05-04 00:00:00.000','2024-05-03 00:00:00.000',0,1,'dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-02 10:52:46.000',NULL,'2024-05-02 11:34:42.000','2024-05-02 09:34:43.000','2024-05-02 11:34:43.000'),('67fe27de-0953-11ef-8f65-d9283bb1c6cd',3,'67fc2b93-0953-11ef-8f65-d9283bb1c6cd','Commande 1.2.7.1','SENT',0,'2024-05-04 00:00:00.000',NULL,0,1,'dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-03 15:45:30.000',NULL,'2024-05-03 15:50:27.000','2024-05-03 13:50:28.000','2024-05-03 15:50:28.000'),('71ba489c-0958-11ef-8f65-d9283bb1c6cd',3,'71b85037-0958-11ef-8f65-d9283bb1c6cd','Commande 1.2.9.1','NOT_SENT',1,NULL,NULL,1,1,'dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-03 16:21:34.800',NULL,'2024-05-03 16:21:34.801','2024-05-03 14:21:34.801',NULL),('894691e1-1cf1-11ef-8f68-d9283cb4d201',6,'894496db-1cf1-11ef-8f68-d9283cb4d201','Commande 1.2.1.1','SENT',1,'2024-05-29 00:00:00.000',NULL,0,1,'5e94742e-1a7e-484b-ad67-74101348d108','5e94742e-1a7e-484b-ad67-74101348d108','2024-05-28 14:55:18.757',NULL,'2024-05-28 14:58:06.582','2024-05-28 12:58:06.582','2024-05-28 14:58:06.585'),('8afe00c0-146a-11ef-8f1b-d8242b6da0dc',3,'8afd42f5-146a-11ef-8f1b-d8242b6da0dc','Commande 1.7.4.1','NOT_SENT',1,NULL,NULL,1,1,'dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-17 18:28:50.276',NULL,'2024-05-17 18:28:50.277','2024-05-17 16:28:50.277',NULL),('a0015ffe-0868-11ef-8ff6-da2f5a35fe58',3,'9fff6be0-0868-11ef-8ff6-da2f5a35fe58','Commande 1.1.3.1','DATE_VALIDATED',0,'2024-05-03 00:00:00.000',NULL,0,1,'dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-02 11:44:52.000',NULL,'2024-05-02 11:49:46.000','2024-05-02 09:49:46.000','2024-05-02 11:49:46.000'),('b1d0afcd-1749-11ef-8f86-d92942cf49fd',3,'b1ce9a22-1749-11ef-8f86-d92942cf49fd','Commande 1.7.6.1','NOT_SENT',1,NULL,NULL,1,1,'dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-21 10:11:15.507',NULL,'2024-05-21 15:00:09.059','2024-05-21 13:00:09.061',NULL),('b84fac03-1f2c-11ef-8f88-d92a43d1501c',3,'b84ee75e-1f2c-11ef-8f88-d92a43d1501c','Commande 1.8.1.1','NOT_SENT',1,NULL,NULL,1,1,'dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-31 11:04:00.302',NULL,'2024-05-31 11:04:00.303','2024-05-31 09:04:00.303',NULL),('bcf78fbc-113b-11ef-8f8d-d92a44d56471',3,'bcf58202-113b-11ef-8f8d-d92a44d56471','Commande 1.3.1.1','VALIDATED',0,'2024-05-15 00:00:00.000','2024-05-14 00:00:00.000',0,1,'dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-13 17:16:14.000',NULL,'2024-05-13 17:20:50.000','2024-05-13 15:20:52.000','2024-05-13 17:20:52.000'),('c0d437cd-094f-11ef-8f65-d9283bb1c6cd',6,'7d7b190c-094f-11ef-8f65-d9283bb1c6cd','Commande 1.1.1.1','SENT',1,'2024-05-04 00:00:00.000',NULL,0,1,'5e94742e-1a7e-484b-ad67-74101348d108','5e94742e-1a7e-484b-ad67-74101348d108','2024-05-03 15:19:22.040',NULL,'2024-05-03 15:23:10.230','2024-05-03 13:23:10.231','2024-05-03 15:23:10.235'),('d963f904-1437-11ef-8f1b-d8242b6da0dc',3,'d961f6f4-1437-11ef-8f1b-d8242b6da0dc','Commande 1.6.3.1','VALIDATED',0,'2024-05-19 00:00:00.000','2024-05-18 00:00:00.000',0,1,'dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-17 12:25:57.000',NULL,'2024-05-17 12:28:38.000','2024-05-17 10:28:39.000','2024-05-17 12:28:39.000'),('d9e2b705-1436-11ef-8f1b-d8242b6da0dc',3,'d9e0b5cb-1436-11ef-8f1b-d8242b6da0dc','Commande 1.6.2.1','VALIDATED',0,'2024-05-19 00:00:00.000','2024-05-18 00:00:00.000',0,1,'dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-17 12:18:48.000',NULL,'2024-05-17 12:20:25.000','2024-05-17 10:20:26.000','2024-05-17 12:20:26.000'),('dd603433-19c9-11ef-8fee-da2f582eded0',3,'dd5e304f-19c9-11ef-8fee-da2f582eded0','Commande 1.7.8.1','NOT_SENT',1,NULL,NULL,1,1,'dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-24 14:33:46.496',NULL,'2024-05-24 14:34:08.575','2024-05-24 12:34:08.575',NULL),('df82cffa-19cb-11ef-8fee-da2f582eded0',3,'df80ed21-19cb-11ef-8fee-da2f582eded0','Commande 1.7.9.1','NOT_SENT',1,NULL,NULL,1,1,'dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-24 14:48:09.072',NULL,'2024-05-24 14:48:09.072','2024-05-24 12:48:09.073',NULL),('ec1e9f7a-1dd1-11ef-8f99-d92a46e09137',15,'ec1c9685-1dd1-11ef-8f99-d92a46e09137','Commande 2.3.1.1','SENT',0,'2024-05-30 00:00:00.000',NULL,0,1,'397b4e6f-5e8d-4926-8242-58217e16b7cd','397b4e6f-5e8d-4926-8242-58217e16b7cd','2024-05-29 17:41:31.000',NULL,'2024-05-29 17:43:19.000','2024-05-29 15:43:20.000','2024-05-29 17:43:20.000'),('f0742777-144c-11ef-8f1b-d8242b6da0dc',3,'f0721624-144c-11ef-8f1b-d8242b6da0dc','Commande 1.7.1.1','SENT',0,'2024-05-18 00:00:00.000',NULL,0,1,'dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-17 14:56:55.000',NULL,'2024-05-17 18:07:24.000','2024-05-17 16:07:25.000','2024-05-17 18:07:25.000'),('f5aca24b-1824-11ef-8f8e-d92a44d6667d',3,'f5aa8d87-1824-11ef-8f8e-d92a44d6667d','Commande 1.7.7.1','NOT_SENT',1,NULL,NULL,1,1,'dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-22 12:20:49.139',NULL,'2024-05-22 12:20:49.140','2024-05-22 10:20:49.140',NULL);
/*!40000 ALTER TABLE `ProstheticOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrderFile`
--

DROP TABLE IF EXISTS `ProstheticOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProstheticOrderFile` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('FORM','SCAN') NOT NULL,
  PRIMARY KEY (`orderId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `ProstheticOrderFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrderFile_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `ProstheticOrder` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrderFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrderFile`
--

LOCK TABLES `ProstheticOrderFile` WRITE;
/*!40000 ALTER TABLE `ProstheticOrderFile` DISABLE KEYS */;
INSERT INTO `ProstheticOrderFile` VALUES (3,'0e416c0d-0947-11ef-8f65-d9283bb1c6cd','1cc8ff68-094d-11ef-8f65-d9283bb1c6cd','FORM'),(3,'0e416c0d-0947-11ef-8f65-d9283bb1c6cd','550d8ad7-0943-11ef-8f65-d9283bb1c6cd','SCAN'),(3,'0e416c0d-0947-11ef-8f65-d9283bb1c6cd','550da95b-0943-11ef-8f65-d9283bb1c6cd','SCAN'),(3,'1f4743e1-1436-11ef-8f1b-d8242b6da0dc','3c611073-1436-11ef-8f1b-d8242b6da0dc','SCAN'),(3,'1f4743e1-1436-11ef-8f1b-d8242b6da0dc','3c6127b7-1436-11ef-8f1b-d8242b6da0dc','SCAN'),(3,'1f4743e1-1436-11ef-8f1b-d8242b6da0dc','bba3b492-1436-11ef-8f1b-d8242b6da0dc','FORM'),(3,'233cdf71-113d-11ef-8f8d-d92a44d56471','39676397-113d-11ef-8f8d-d92a44d56471','SCAN'),(3,'233cdf71-113d-11ef-8f8d-d92a44d56471','39676fab-113d-11ef-8f8d-d92a44d56471','SCAN'),(3,'233cdf71-113d-11ef-8f8d-d92a44d56471','401b4fc2-113d-11ef-8f8d-d92a44d56471','FORM'),(15,'3a968bff-1dd2-11ef-8f99-d92a46e09137','0ceccb78-1dd2-11ef-8f99-d92a46e09137','SCAN'),(15,'3a968bff-1dd2-11ef-8f99-d92a46e09137','0cece571-1dd2-11ef-8f99-d92a46e09137','SCAN'),(15,'3a968bff-1dd2-11ef-8f99-d92a46e09137','491138ed-1dd2-11ef-8f99-d92a46e09137','FORM'),(3,'419edfb4-1469-11ef-8f1b-d8242b6da0dc','4b160442-1469-11ef-8f1b-d8242b6da0dc','FORM'),(3,'419edfb4-1469-11ef-8f1b-d8242b6da0dc','53799350-1468-11ef-8f1b-d8242b6da0dc','SCAN'),(3,'419edfb4-1469-11ef-8f1b-d8242b6da0dc','5379a891-1468-11ef-8f1b-d8242b6da0dc','SCAN'),(3,'47d6e672-086d-11ef-8ff6-da2f5a35fe58','3102e726-086d-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'47d6e672-086d-11ef-8ff6-da2f5a35fe58','3102fb86-086d-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'47d6e672-086d-11ef-8ff6-da2f5a35fe58','4d7752a0-086d-11ef-8ff6-da2f5a35fe58','FORM'),(3,'4dd5f101-06ed-11ef-90c8-dd3986f53a42','714f63b2-06ed-11ef-90c8-dd3986f53a42','SCAN'),(3,'4dd5f101-06ed-11ef-90c8-dd3986f53a42','714f73d7-06ed-11ef-90c8-dd3986f53a42','SCAN'),(3,'4dd5f101-06ed-11ef-90c8-dd3986f53a42','c60f2934-06ed-11ef-90c8-dd3986f53a42','FORM'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','17764359-0863-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','17765260-0863-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','25ab5185-0864-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','25ab54c4-0864-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','2fbc2cef-0864-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','2fbc3392-0864-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','33ad43c0-0867-11ef-8ff6-da2f5a35fe58','FORM'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','a3a69b8b-0864-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','a3e32cc1-0864-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','a3e332c3-0864-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','a3e37662-0864-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','a3e37c4f-0864-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','a3e3b7e2-0864-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','a413fc36-0864-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','a414024b-0864-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','a4f01daf-0864-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','bc911890-0863-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','bc912779-0863-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','bdd2799d-0864-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','ea71e741-0863-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','ea71eca5-0863-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','eb746e19-0861-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','eb7485b0-0861-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'67fe27de-0953-11ef-8f65-d9283bb1c6cd','187400c0-0954-11ef-8f65-d9283bb1c6cd','FORM'),(3,'67fe27de-0953-11ef-8f65-d9283bb1c6cd','d1d98002-0953-11ef-8f65-d9283bb1c6cd','SCAN'),(3,'67fe27de-0953-11ef-8f65-d9283bb1c6cd','d1f26a61-0953-11ef-8f65-d9283bb1c6cd','SCAN'),(3,'67fe27de-0953-11ef-8f65-d9283bb1c6cd','d26c0218-0953-11ef-8f65-d9283bb1c6cd','SCAN'),(6,'894691e1-1cf1-11ef-8f68-d9283cb4d201','d0c9b40d-1cf1-11ef-8f68-d9283cb4d201','SCAN'),(6,'894691e1-1cf1-11ef-8f68-d9283cb4d201','d0c9cbb2-1cf1-11ef-8f68-d9283cb4d201','SCAN'),(6,'894691e1-1cf1-11ef-8f68-d9283cb4d201','ece2d99e-1cf1-11ef-8f68-d9283cb4d201','FORM'),(3,'a0015ffe-0868-11ef-8ff6-da2f5a35fe58','2aa61e09-0869-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'a0015ffe-0868-11ef-8ff6-da2f5a35fe58','2ac2bcfd-0869-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'a0015ffe-0868-11ef-8ff6-da2f5a35fe58','2b3e9ab9-0869-11ef-8ff6-da2f5a35fe58','SCAN'),(3,'a0015ffe-0868-11ef-8ff6-da2f5a35fe58','3202c706-0869-11ef-8ff6-da2f5a35fe58','FORM'),(3,'b1d0afcd-1749-11ef-8f86-d92942cf49fd','0fe386e8-176d-11ef-8f86-d92942cf49fd','SCAN'),(3,'b1d0afcd-1749-11ef-8f86-d92942cf49fd','0ff91bc5-176d-11ef-8f86-d92942cf49fd','SCAN'),(3,'b1d0afcd-1749-11ef-8f86-d92942cf49fd','2563eb4a-176d-11ef-8f86-d92942cf49fd','SCAN'),(3,'bcf78fbc-113b-11ef-8f8d-d92a44d56471','616d233f-113c-11ef-8f8d-d92a44d56471','FORM'),(3,'bcf78fbc-113b-11ef-8f8d-d92a44d56471','e662db00-113b-11ef-8f8d-d92a44d56471','SCAN'),(3,'bcf78fbc-113b-11ef-8f8d-d92a44d56471','e662fcef-113b-11ef-8f8d-d92a44d56471','SCAN'),(6,'c0d437cd-094f-11ef-8f65-d9283bb1c6cd','486e554c-0950-11ef-8f65-d9283bb1c6cd','FORM'),(6,'c0d437cd-094f-11ef-8f65-d9283bb1c6cd','9935aa64-094f-11ef-8f65-d9283bb1c6cd','SCAN'),(6,'c0d437cd-094f-11ef-8f65-d9283bb1c6cd','9935cedf-094f-11ef-8f65-d9283bb1c6cd','SCAN'),(3,'d963f904-1437-11ef-8f1b-d8242b6da0dc','39436bdb-1438-11ef-8f1b-d8242b6da0dc','FORM'),(3,'d963f904-1437-11ef-8f1b-d8242b6da0dc','3c611073-1436-11ef-8f1b-d8242b6da0dc','SCAN'),(3,'d963f904-1437-11ef-8f1b-d8242b6da0dc','3c6127b7-1436-11ef-8f1b-d8242b6da0dc','SCAN'),(3,'d9e2b705-1436-11ef-8f1b-d8242b6da0dc','131bceae-1437-11ef-8f1b-d8242b6da0dc','FORM'),(3,'d9e2b705-1436-11ef-8f1b-d8242b6da0dc','3c611073-1436-11ef-8f1b-d8242b6da0dc','SCAN'),(3,'d9e2b705-1436-11ef-8f1b-d8242b6da0dc','3c6127b7-1436-11ef-8f1b-d8242b6da0dc','SCAN'),(15,'ec1e9f7a-1dd1-11ef-8f99-d92a46e09137','0ceccb78-1dd2-11ef-8f99-d92a46e09137','SCAN'),(15,'ec1e9f7a-1dd1-11ef-8f99-d92a46e09137','0cece571-1dd2-11ef-8f99-d92a46e09137','SCAN'),(15,'ec1e9f7a-1dd1-11ef-8f99-d92a46e09137','2bf2d463-1dd2-11ef-8f99-d92a46e09137','FORM'),(3,'f0742777-144c-11ef-8f1b-d8242b6da0dc','5a21d0db-1467-11ef-8f1b-d8242b6da0dc','SCAN'),(3,'f0742777-144c-11ef-8f1b-d8242b6da0dc','7cfb78fe-1467-11ef-8f1b-d8242b6da0dc','SCAN'),(3,'f0742777-144c-11ef-8f1b-d8242b6da0dc','7cfb7be6-1467-11ef-8f1b-d8242b6da0dc','SCAN'),(3,'f0742777-144c-11ef-8f1b-d8242b6da0dc','8c48de05-1467-11ef-8f1b-d8242b6da0dc','FORM'),(3,'f0742777-144c-11ef-8f1b-d8242b6da0dc','ce611e03-1466-11ef-8f1b-d8242b6da0dc','SCAN'),(3,'f0742777-144c-11ef-8f1b-d8242b6da0dc','ce613798-1466-11ef-8f1b-d8242b6da0dc','SCAN');
/*!40000 ALTER TABLE `ProstheticOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrderRecipient`
--

DROP TABLE IF EXISTS `ProstheticOrderRecipient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProstheticOrderRecipient` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `recipientId` varchar(36) NOT NULL,
  PRIMARY KEY (`orderId`,`recipientId`),
  KEY `ownerId` (`ownerId`),
  KEY `recipientId` (`recipientId`),
  CONSTRAINT `ProstheticOrderRecipient_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrderRecipient_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `ProstheticOrder` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrderRecipient_ibfk_3` FOREIGN KEY (`recipientId`) REFERENCES `Contact` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrderRecipient`
--

LOCK TABLES `ProstheticOrderRecipient` WRITE;
/*!40000 ALTER TABLE `ProstheticOrderRecipient` DISABLE KEYS */;
INSERT INTO `ProstheticOrderRecipient` VALUES (3,'0e416c0d-0947-11ef-8f65-d9283bb1c6cd','b84baf20-3ca6-4653-8341-ac721a404258'),(3,'1f4743e1-1436-11ef-8f1b-d8242b6da0dc','b84baf20-3ca6-4653-8341-ac721a404258'),(3,'233cdf71-113d-11ef-8f8d-d92a44d56471','b84baf20-3ca6-4653-8341-ac721a404258'),(3,'419edfb4-1469-11ef-8f1b-d8242b6da0dc','b84baf20-3ca6-4653-8341-ac721a404258'),(3,'47d6e672-086d-11ef-8ff6-da2f5a35fe58','b84baf20-3ca6-4653-8341-ac721a404258'),(3,'4dd5f101-06ed-11ef-90c8-dd3986f53a42','8e4a4b16-c567-4bf8-a434-976b627a70ca'),(3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','b84baf20-3ca6-4653-8341-ac721a404258'),(3,'67fe27de-0953-11ef-8f65-d9283bb1c6cd','1ae8fb0f-2111-4ecf-a290-dcae6e15100e'),(3,'a0015ffe-0868-11ef-8ff6-da2f5a35fe58','b84baf20-3ca6-4653-8341-ac721a404258'),(3,'bcf78fbc-113b-11ef-8f8d-d92a44d56471','b84baf20-3ca6-4653-8341-ac721a404258'),(3,'d963f904-1437-11ef-8f1b-d8242b6da0dc','b84baf20-3ca6-4653-8341-ac721a404258'),(3,'d9e2b705-1436-11ef-8f1b-d8242b6da0dc','b84baf20-3ca6-4653-8341-ac721a404258'),(3,'f0742777-144c-11ef-8f1b-d8242b6da0dc','b84baf20-3ca6-4653-8341-ac721a404258'),(6,'894691e1-1cf1-11ef-8f68-d9283cb4d201','78919a47-1bcf-424a-a1b2-c19063ff242c'),(6,'c0d437cd-094f-11ef-8f65-d9283bb1c6cd','78919a47-1bcf-424a-a1b2-c19063ff242c'),(15,'3a968bff-1dd2-11ef-8f99-d92a46e09137','ed09bdd8-1331-4c59-b52b-b0000e585e7d'),(15,'ec1e9f7a-1dd1-11ef-8f99-d92a46e09137','6c752185-ecab-4039-a782-171f75036a34');
/*!40000 ALTER TABLE `ProstheticOrderRecipient` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticSheet`
--

DROP TABLE IF EXISTS `ProstheticSheet`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProstheticSheet` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `json` text NOT NULL,
  `pdfFileId` varchar(36) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `orderId` (`orderId`),
  KEY `pdfFileId` (`pdfFileId`),
  CONSTRAINT `ProstheticSheet_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `ProstheticSheet_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `ProstheticOrder` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `ProstheticSheet_ibfk_3` FOREIGN KEY (`pdfFileId`) REFERENCES `File` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticSheet`
--

LOCK TABLES `ProstheticSheet` WRITE;
/*!40000 ALTER TABLE `ProstheticSheet` DISABLE KEYS */;
INSERT INTO `ProstheticSheet` VALUES ('0e4192b0-0947-11ef-8f65-d9283bb1c6cd',3,'0e416c0d-0947-11ef-8f65-d9283bb1c6cd','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            16\n        ],\n        \"sheetTitle\": \"Couronne\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 0,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','1cc8ff68-094d-11ef-8f65-d9283bb1c6cd','2024-05-03 14:17:05.000',NULL,'2024-05-03 14:17:25.000','2024-05-03 13:00:33.013','2024-05-03 15:00:29.000'),('177206b9-11fa-11ef-8fe1-da2e5522abf3',3,'1771f67f-11fa-11ef-8fe1-da2e5522abf3','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"Autre\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-05-14 15:58:46.872',NULL,'2024-05-14 15:58:50.462','2024-05-14 13:58:50.462',NULL),('1f4755a7-1436-11ef-8f1b-d8242b6da0dc',3,'1f4743e1-1436-11ef-8f1b-d8242b6da0dc','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            16\n        ],\n        \"sheetTitle\": \"Couronne\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 0,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','bba3b492-1436-11ef-8f1b-d8242b6da0dc','2024-05-17 12:13:27.000',NULL,'2024-05-17 12:16:54.000','2024-05-17 10:18:00.916','2024-05-17 12:17:59.000'),('233cf51b-113d-11ef-8f8d-d92a44d56471',3,'233cdf71-113d-11ef-8f8d-d92a44d56471','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"Autre\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','401b4fc2-113d-11ef-8f8d-d92a44d56471','2024-05-13 17:26:13.000',NULL,'2024-05-13 17:27:06.000','2024-05-13 15:27:09.369','2024-05-13 17:27:05.000'),('2a5547ff-11cf-11ef-8f95-d92a45dc80ec',3,'2a5536d8-11cf-11ef-8f95-d92a45dc80ec','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"Autre\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-05-14 10:51:29.931',NULL,'2024-05-14 10:51:33.791','2024-05-14 08:51:33.791',NULL),('3a96a212-1dd2-11ef-8f99-d92a46e09137',15,'3a968bff-1dd2-11ef-8f99-d92a46e09137','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            13\n        ],\n        \"sheetTitle\": \"Facette\",\n        \"specificTint\": \"\",\n        \"type\": 6,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','491138ed-1dd2-11ef-8f99-d92a46e09137','2024-05-29 17:43:39.000',NULL,'2024-05-29 17:44:09.000','2024-05-29 16:05:51.058','2024-05-29 17:55:20.000'),('3d2bb2a9-1dca-11ef-8f99-d92a46e09137',14,'3d2b8fcd-1dca-11ef-8f99-d92a46e09137','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            17\n        ],\n        \"sheetTitle\": \"cmde tlchgt créée par demo22\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-05-29 16:45:52.723',NULL,'2024-05-29 16:46:31.864','2024-05-29 14:46:31.865',NULL),('419ef8c7-1469-11ef-8f1b-d8242b6da0dc',3,'419edfb4-1469-11ef-8f1b-d8242b6da0dc','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            26\n        ],\n        \"sheetTitle\": \"Autre\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','4b160442-1469-11ef-8f1b-d8242b6da0dc','2024-05-17 18:19:34.929',NULL,'2024-05-17 18:19:53.563','2024-05-17 16:19:54.262','2024-05-17 18:19:55.384'),('42c59fde-0958-11ef-8f65-d9283bb1c6cd',3,'42c58eea-0958-11ef-8f65-d9283bb1c6cd','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            26\n        ],\n        \"sheetTitle\": \"Facette\",\n        \"specificTint\": \"\",\n        \"type\": 6,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-05-03 16:19:38.248','2024-05-03 16:20:32.407','2024-05-03 16:20:16.022','2024-05-03 14:20:32.407',NULL),('42c5a4f0-0958-11ef-8f65-d9283bb1c6cd',3,'42c58eea-0958-11ef-8f65-d9283bb1c6cd','{\n    \"v2\": {\n        \"brandScanBody\": \"Autre\",\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"refImplant\": \"\",\n        \"refScanBody\": \"vvdvfd\",\n        \"selectedTeeth\": [\n            23\n        ],\n        \"sheetTitle\": \"Couronne sur implant\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 1,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-05-03 16:19:42.520','2024-05-03 16:20:32.407','2024-05-03 16:20:16.022','2024-05-03 14:20:32.407',NULL),('42c5a88a-0958-11ef-8f65-d9283bb1c6cd',3,'42c58eea-0958-11ef-8f65-d9283bb1c6cd','{\n    \"v2\": {\n        \"brandScanBody\": \"Autre\",\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"refImplant\": \"\",\n        \"refScanBody\": \"dgfdgdfg\",\n        \"selectedTeeth\": [\n            15\n        ],\n        \"sheetTitle\": \"Couronne sur implant\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 1,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-05-03 16:19:47.020','2024-05-03 16:20:32.407','2024-05-03 16:20:16.022','2024-05-03 14:20:32.408',NULL),('42c5adcc-0958-11ef-8f65-d9283bb1c6cd',3,'42c58eea-0958-11ef-8f65-d9283bb1c6cd','{\n    \"v2\": {\n        \"brandScanBody\": \"Biotech Dental\",\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"refImplant\": \"\",\n        \"refScanBody\": \"K30PSCANPLG\",\n        \"selectedTeeth\": [\n            44,\n            45,\n            46\n        ],\n        \"sheetTitle\": \"Bridge sur implant\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 5,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-05-03 16:19:53.876','2024-05-03 16:20:32.407','2024-05-03 16:20:16.022','2024-05-03 14:20:32.408',NULL),('47d6fbf5-086d-11ef-8ff6-da2f5a35fe58',3,'47d6e672-086d-11ef-8ff6-da2f5a35fe58','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            26\n        ],\n        \"sheetTitle\": \"Autre\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','4d7752a0-086d-11ef-8ff6-da2f5a35fe58','2024-05-02 12:18:11.000',NULL,'2024-05-02 12:18:24.000','2024-05-02 10:19:34.450','2024-05-02 12:19:34.000'),('4dd60173-06ed-11ef-90c8-dd3986f53a42',3,'4dd5f101-06ed-11ef-90c8-dd3986f53a42','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            11,\n            21\n        ],\n        \"sheetTitle\": \"Facette\",\n        \"specificTint\": \"\",\n        \"type\": 6,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','c60f2934-06ed-11ef-90c8-dd3986f53a42','2024-04-30 14:29:32.000',NULL,'2024-04-30 14:31:41.000','2024-04-30 12:33:01.396','2024-04-30 14:32:58.000'),('4fc43a8e-0952-11ef-8f65-d9283bb1c6cd',3,'4fc42b0a-0952-11ef-8f65-d9283bb1c6cd','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            16\n        ],\n        \"sheetTitle\": \"Couronne sur 16\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 0,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-05-03 15:36:58.602',NULL,'2024-05-03 15:37:40.843','2024-05-03 13:37:40.843',NULL),('4fc44013-0952-11ef-8f65-d9283bb1c6cd',3,'4fc42b0a-0952-11ef-8f65-d9283bb1c6cd','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            25,\n            26,\n            27\n        ],\n        \"sheetTitle\": \"Bridge 24-26\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 4,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-05-03 15:37:13.515',NULL,'2024-05-03 15:37:40.843','2024-05-03 13:37:40.845',NULL),('574b39b2-146a-11ef-8f1b-d8242b6da0dc',3,'574b2236-146a-11ef-8f1b-d8242b6da0dc','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            26\n        ],\n        \"sheetTitle\": \"Autre\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-05-17 18:27:21.003',NULL,'2024-05-17 18:27:23.541','2024-05-17 16:27:23.541',NULL),('58e7df0c-0861-11ef-8ff6-da2f5a35fe58',3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            16\n        ],\n        \"sheetTitle\": \"Facette\",\n        \"specificTint\": \"\",\n        \"type\": 6,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','33ad43c0-0867-11ef-8ff6-da2f5a35fe58','2024-05-02 10:52:44.000',NULL,'2024-05-02 11:34:11.000','2024-05-02 09:34:44.385','2024-05-02 11:34:43.000'),('67fe3e5c-0953-11ef-8f65-d9283bb1c6cd',3,'67fe27de-0953-11ef-8f65-d9283bb1c6cd','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            17\n        ],\n        \"sheetTitle\": \"wf guidé\",\n        \"specificTint\": \"\",\n        \"type\": 6,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','187400c0-0954-11ef-8f65-d9283bb1c6cd','2024-05-03 15:45:17.000',NULL,'2024-05-03 15:50:29.000','2024-05-03 13:50:29.851','2024-05-03 15:50:28.000'),('71ba5957-0958-11ef-8f65-d9283bb1c6cd',3,'71ba489c-0958-11ef-8f65-d9283bb1c6cd','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            26\n        ],\n        \"sheetTitle\": \"Couronne12\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 0,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-05-03 16:20:37.588',NULL,'2024-05-03 16:21:34.801','2024-05-03 14:21:34.802',NULL),('71ba60b3-0958-11ef-8f65-d9283bb1c6cd',3,'71ba489c-0958-11ef-8f65-d9283bb1c6cd','{\n    \"v2\": {\n        \"brandScanBody\": \"Autre\",\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"refImplant\": \"\",\n        \"refScanBody\": \"a\",\n        \"selectedTeeth\": [\n            24\n        ],\n        \"sheetTitle\": \"Couronne sur implant 24\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 1,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-05-03 16:20:44.831',NULL,'2024-05-03 16:21:34.801','2024-05-03 14:21:34.802',NULL),('71ba664e-0958-11ef-8f65-d9283bb1c6cd',3,'71ba489c-0958-11ef-8f65-d9283bb1c6cd','{\n    \"v2\": {\n        \"brandScanBody\": \"Autre\",\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"refImplant\": \"\",\n        \"refScanBody\": \"b\",\n        \"selectedTeeth\": [\n            16\n        ],\n        \"sheetTitle\": \"Couronne sur implant 16\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 1,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-05-03 16:20:53.342',NULL,'2024-05-03 16:21:34.801','2024-05-03 14:21:34.803',NULL),('71ba6bb4-0958-11ef-8f65-d9283bb1c6cd',3,'71ba489c-0958-11ef-8f65-d9283bb1c6cd','{\n    \"v2\": {\n        \"brandScanBody\": \"Autre\",\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"refImplant\": \"\",\n        \"refScanBody\": \"c\",\n        \"selectedTeeth\": [\n            37,\n            36,\n            35\n        ],\n        \"sheetTitle\": \"Bridge sur implant 37-35\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 5,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-05-03 16:21:03.771',NULL,'2024-05-03 16:21:34.801','2024-05-03 14:21:34.803',NULL),('8946abc2-1cf1-11ef-8f68-d9283cb4d201',6,'894691e1-1cf1-11ef-8f68-d9283cb4d201','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            16\n        ],\n        \"sheetTitle\": \"Facette\",\n        \"specificTint\": \"\",\n        \"type\": 6,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','ece2d99e-1cf1-11ef-8f68-d9283cb4d201','2024-05-28 14:55:16.620',NULL,'2024-05-28 14:58:05.876','2024-05-28 12:58:06.583','2024-05-28 14:58:08.095'),('8afe1002-146a-11ef-8f1b-d8242b6da0dc',3,'8afe00c0-146a-11ef-8f1b-d8242b6da0dc','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            26\n        ],\n        \"sheetTitle\": \"Couronne\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 0,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-05-17 18:28:46.118',NULL,'2024-05-17 18:28:50.277','2024-05-17 16:28:50.277',NULL),('a00178ff-0868-11ef-8ff6-da2f5a35fe58',3,'a0015ffe-0868-11ef-8ff6-da2f5a35fe58','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            16\n        ],\n        \"sheetTitle\": \"Facette\",\n        \"specificTint\": \"\",\n        \"type\": 6,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','3202c706-0869-11ef-8ff6-da2f5a35fe58','2024-05-02 11:44:47.000',NULL,'2024-05-02 11:48:59.000','2024-05-02 09:49:46.906','2024-05-02 11:49:46.000'),('b1d0bfea-1749-11ef-8f86-d92942cf49fd',3,'b1d0afcd-1749-11ef-8f86-d92942cf49fd','{\n    \"v2\": {\n        \"brandScanBody\": \"Biotech Dental\",\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"refImplant\": \"\",\n        \"refScanBody\": \"K30PSCANP\",\n        \"selectedTeeth\": [\n            16\n        ],\n        \"sheetTitle\": \"Couronne sur implant\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 1,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-05-21 10:10:48.005',NULL,'2024-05-21 10:11:15.507','2024-05-21 08:11:15.507',NULL),('b84fbb8b-1f2c-11ef-8f88-d92a43d1501c',3,'b84fac03-1f2c-11ef-8f88-d92a43d1501c','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"test typodont\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-05-31 11:03:41.803',NULL,'2024-05-31 11:04:00.303','2024-05-31 09:04:00.303',NULL),('bcf7b328-113b-11ef-8f8d-d92a44d56471',3,'bcf78fbc-113b-11ef-8f8d-d92a44d56471','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            16\n        ],\n        \"sheetTitle\": \"Couronne\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 0,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','616d233f-113c-11ef-8f8d-d92a44d56471','2024-05-13 17:16:11.000',NULL,'2024-05-13 17:17:49.000','2024-05-13 15:20:54.781','2024-05-13 17:20:52.000'),('c0d44a55-094f-11ef-8f65-d9283bb1c6cd',6,'c0d437cd-094f-11ef-8f65-d9283bb1c6cd','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            26\n        ],\n        \"sheetTitle\": \"Onlay\",\n        \"specificTint\": \"\",\n        \"subType\": 1,\n        \"type\": 2,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','486e554c-0950-11ef-8f65-d9283bb1c6cd','2024-05-03 15:19:20.931',NULL,'2024-05-03 15:23:09.542','2024-05-03 13:23:10.233','2024-05-03 15:23:12.041'),('d9640d2f-1437-11ef-8f1b-d8242b6da0dc',3,'d963f904-1437-11ef-8f1b-d8242b6da0dc','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            26\n        ],\n        \"sheetTitle\": \"Autre\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','39436bdb-1438-11ef-8f1b-d8242b6da0dc','2024-05-17 12:25:54.000',NULL,'2024-05-17 12:26:28.000','2024-05-17 10:28:40.885','2024-05-17 12:28:39.000'),('d9e2cbf7-1436-11ef-8f1b-d8242b6da0dc',3,'d9e2b705-1436-11ef-8f1b-d8242b6da0dc','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            26\n        ],\n        \"sheetTitle\": \"Autre\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','131bceae-1437-11ef-8f1b-d8242b6da0dc','2024-05-17 12:18:45.000',NULL,'2024-05-17 12:19:11.000','2024-05-17 10:20:26.863','2024-05-17 12:20:26.000'),('dd605112-19c9-11ef-8fee-da2f582eded0',3,'dd603433-19c9-11ef-8fee-da2f582eded0','{\n    \"v2\": {\n        \"brandScanBody\": \"Biotech Dental\",\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"refImplant\": \"\",\n        \"refScanBody\": \"K30PSCANPLG\",\n        \"selectedTeeth\": [\n            25\n        ],\n        \"sheetTitle\": \"Couronne sur implant\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 1,\n        \"usePrePreparation\": false,\n        \"useScanSup\": true\n    }\n}\n',NULL,'2024-05-24 14:32:55.999',NULL,'2024-05-24 14:33:46.497','2024-05-24 12:34:08.575',NULL),('df82e52e-19cb-11ef-8fee-da2f582eded0',3,'df82cffa-19cb-11ef-8fee-da2f582eded0','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            27\n        ],\n        \"sheetTitle\": \"Pre-scan    Nouveau scan    Autre scan\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-05-24 14:47:08.418',NULL,'2024-05-24 14:48:09.072','2024-05-24 12:48:09.073',NULL),('ec1eb358-1dd1-11ef-8f99-d92a46e09137',15,'ec1e9f7a-1dd1-11ef-8f99-d92a46e09137','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            26\n        ],\n        \"sheetTitle\": \"Facette\",\n        \"specificTint\": \"\",\n        \"type\": 6,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','2bf2d463-1dd2-11ef-8f99-d92a46e09137','2024-05-29 17:41:17.000',NULL,'2024-05-29 17:43:20.000','2024-05-29 15:43:21.524','2024-05-29 17:43:20.000'),('f074391e-144c-11ef-8f1b-d8242b6da0dc',3,'f0742777-144c-11ef-8f1b-d8242b6da0dc','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"Guide\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','8c48de05-1467-11ef-8f1b-d8242b6da0dc','2024-05-17 14:56:50.931',NULL,'2024-05-17 18:07:23.954','2024-05-17 16:07:26.170','2024-05-17 18:07:25.000'),('f5acb6fb-1824-11ef-8f8e-d92a44d6667d',3,'f5aca24b-1824-11ef-8f8e-d92a44d6667d','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            14\n        ],\n        \"sheetTitle\": \"Facette\",\n        \"specificTint\": \"\",\n        \"type\": 6,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-05-22 12:20:45.980',NULL,'2024-05-22 12:20:49.140','2024-05-22 10:20:49.140',NULL);
/*!40000 ALTER TABLE `ProstheticSheet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ReceivedAttachment`
--

DROP TABLE IF EXISTS `ReceivedAttachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ReceivedAttachment` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `receivedMessageId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  PRIMARY KEY (`receivedMessageId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `ReceivedAttachment_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `ReceivedAttachment_ibfk_2` FOREIGN KEY (`receivedMessageId`) REFERENCES `ReceivedMessage` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ReceivedAttachment_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ReceivedAttachment`
--

LOCK TABLES `ReceivedAttachment` WRITE;
/*!40000 ALTER TABLE `ReceivedAttachment` DISABLE KEYS */;
INSERT INTO `ReceivedAttachment` VALUES (3,'4a9bf5c5-0950-11ef-8ba8-6ec2958327c0','4aa2192e-0950-11ef-8ba8-6ec2958327c0'),(3,'4a9bf5c5-0950-11ef-8ba8-6ec2958327c0','4aa40ab1-0950-11ef-8ba8-6ec2958327c0'),(3,'4a9bf5c5-0950-11ef-8ba8-6ec2958327c0','4aa45915-0950-11ef-8ba8-6ec2958327c0'),(3,'eb4a9097-0951-11ef-8ba8-6ec2958327c0','eb4b66a4-0951-11ef-8ba8-6ec2958327c0'),(3,'eb4a9097-0951-11ef-8ba8-6ec2958327c0','eb4ba85c-0951-11ef-8ba8-6ec2958327c0'),(3,'ee3203e4-1cf1-11ef-867c-6ec2958327c0','ee49068e-1cf1-11ef-867c-6ec2958327c0'),(3,'ee3203e4-1cf1-11ef-867c-6ec2958327c0','ee4eb1d4-1cf1-11ef-867c-6ec2958327c0'),(3,'ee3203e4-1cf1-11ef-867c-6ec2958327c0','ee4fa2ca-1cf1-11ef-867c-6ec2958327c0'),(6,'1a929f43-0954-11ef-8ba8-6ec2958327c0','1a936e32-0954-11ef-8ba8-6ec2958327c0'),(6,'1a929f43-0954-11ef-8ba8-6ec2958327c0','1a9e1bb2-0954-11ef-8ba8-6ec2958327c0'),(6,'1a929f43-0954-11ef-8ba8-6ec2958327c0','1a9e6597-0954-11ef-8ba8-6ec2958327c0'),(6,'1a929f43-0954-11ef-8ba8-6ec2958327c0','1a9eba83-0954-11ef-8ba8-6ec2958327c0'),(6,'356c87a7-0954-11ef-8ba8-6ec2958327c0','35700320-0954-11ef-8ba8-6ec2958327c0'),(6,'3c3f5758-0954-11ef-8ba8-6ec2958327c0','3c46656a-0954-11ef-8ba8-6ec2958327c0'),(14,'565bcc49-1dcc-11ef-867c-6ec2958327c0','5664bcc6-1dcc-11ef-867c-6ec2958327c0'),(14,'565bcc49-1dcc-11ef-867c-6ec2958327c0','56651581-1dcc-11ef-867c-6ec2958327c0'),(14,'565bcc49-1dcc-11ef-867c-6ec2958327c0','5665552b-1dcc-11ef-867c-6ec2958327c0'),(14,'71a68bf3-1dc9-11ef-867c-6ec2958327c0','71c14042-1dc9-11ef-867c-6ec2958327c0'),(14,'71a68bf3-1dc9-11ef-867c-6ec2958327c0','71c7d691-1dc9-11ef-867c-6ec2958327c0'),(14,'71a68bf3-1dc9-11ef-867c-6ec2958327c0','71c816ee-1dc9-11ef-867c-6ec2958327c0'),(14,'71a68bf3-1dc9-11ef-867c-6ec2958327c0','71c85c3d-1dc9-11ef-867c-6ec2958327c0'),(14,'71a68bf3-1dc9-11ef-867c-6ec2958327c0','71c8a6d0-1dc9-11ef-867c-6ec2958327c0'),(14,'71a68bf3-1dc9-11ef-867c-6ec2958327c0','71c8fa31-1dc9-11ef-867c-6ec2958327c0'),(14,'71a68bf3-1dc9-11ef-867c-6ec2958327c0','71cb8f69-1dc9-11ef-867c-6ec2958327c0'),(14,'71a68bf3-1dc9-11ef-867c-6ec2958327c0','71cbdcc5-1dc9-11ef-867c-6ec2958327c0');
/*!40000 ALTER TABLE `ReceivedAttachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ReceivedMessage`
--

DROP TABLE IF EXISTS `ReceivedMessage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ReceivedMessage` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `messageTransmitted` tinyint(1) NOT NULL DEFAULT 0,
  `subject` varchar(255) DEFAULT NULL,
  `answeredId` varchar(36) DEFAULT NULL COMMENT 'SentMessage uuid or ReceivedMessage originMessageId',
  `body` text DEFAULT NULL,
  `fromId` mediumint(8) unsigned NOT NULL,
  `originMessageId` varchar(36) DEFAULT NULL,
  `discussionId` varchar(36) NOT NULL,
  `readStatus` enum('READ','UNREAD') DEFAULT 'UNREAD',
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `fromId` (`fromId`),
  KEY `discussionId` (`discussionId`,`ownerId`),
  CONSTRAINT `ReceivedMessage_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `ReceivedMessage_ibfk_2` FOREIGN KEY (`fromId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `ReceivedMessage_ibfk_3` FOREIGN KEY (`discussionId`, `ownerId`) REFERENCES `Discussion` (`uuid`, `ownerId`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ReceivedMessage`
--

LOCK TABLES `ReceivedMessage` WRITE;
/*!40000 ALTER TABLE `ReceivedMessage` DISABLE KEYS */;
INSERT INTO `ReceivedMessage` VALUES ('07279402-1438-11ef-867c-6ec2958327c0',3,1,'Commande 1.6.3.1',NULL,'API_META={\"type\":\"order\",\"key\":\"edited\",\"title\":\"Commande 1.6.3.1\",\"date\":\"2024-05-19T00:00:00+02:00\",\"orderUpdateTime\":\"2024-05-17T12:27:14+02:00\",\"orderId\":\"d963f904-1437-11ef-8f1b-d8242b6da0dc\"}',4,'beca4cc7-756f-482b-8af8-e3d3a7688acf','1fed07ce-0867-11ef-8ff6-da2f5a35fe58','READ','2024-05-17 12:27:14.000',NULL,'2024-05-17 12:27:14.000','2024-05-17 10:27:24.727','2024-05-17 12:27:24.737'),('0fe99a58-094d-11ef-8ba8-6ec2958327c0',3,1,'Commande 1.2.1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"edited\",\"title\":\"Commande 1.2.1.1\",\"date\":\"2024-05-05T00:00:00+02:00\",\"orderUpdateTime\":\"2024-05-03T15:00:05+02:00\",\"orderId\":\"0e416c0d-0947-11ef-8f65-d9283bb1c6cd\"}',4,'05cb71ad-e3d8-49ee-a5f2-cb6697966915','1fed07ce-0867-11ef-8ff6-da2f5a35fe58','READ','2024-05-03 15:00:05.000',NULL,'2024-05-03 15:00:05.000','2024-05-03 13:00:09.000','2024-05-03 15:00:09.000'),('1a929f43-0954-11ef-8ba8-6ec2958327c0',6,1,'Commande 1.2.7.1',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.2.7.1\",\"date\":\"2024-05-04T00:00:00\",\"orderUpdateTime\":\"2024-05-03T15:50:27\",\"orderId\":\"67fe27de-0953-11ef-8f65-d9283bb1c6cd\"}',3,'18dfb5e3-0954-11ef-8f65-d9283bb1c6cd','3b2891c3-0950-11ef-8f65-d9283bb1c6cd','READ','2024-05-03 15:50:29.000',NULL,'2024-05-03 15:50:29.000','2024-05-28 12:41:58.919','2024-05-28 14:41:58.922'),('2cb4adc7-0867-11ef-8ba8-6ec2958327c0',3,1,'Commande 1.1.2.1',NULL,'API_META={\"type\":\"order\",\"key\":\"edited\",\"title\":\"Commande 1.1.2.1\",\"date\":\"2024-05-04T00:00:00+02:00\",\"orderUpdateTime\":\"2024-05-02T11:34:29+02:00\",\"orderId\":\"58e7cf64-0861-11ef-8ff6-da2f5a35fe58\"}',4,'3e4bfd0c-75a4-4a50-9378-498a688a0d70','1fed07ce-0867-11ef-8ff6-da2f5a35fe58','READ','2024-05-02 11:34:29.000',NULL,'2024-05-02 11:34:29.000','2024-05-02 09:34:32.430','2024-05-02 11:34:32.439'),('356c87a7-0954-11ef-8ba8-6ec2958327c0',6,1,'34ee3417-0954-11ef-8f65-d9283bb1c6cd',NULL,'#',3,'34ee3417-0954-11ef-8f65-d9283bb1c6cd','3b2891c3-0950-11ef-8f65-d9283bb1c6cd','READ','2024-05-03 15:51:14.000',NULL,'2024-05-03 15:51:14.000','2024-05-28 12:41:58.911','2024-05-28 14:41:58.913'),('3bd85045-0950-11ef-8ba8-6ec2958327c0',3,1,'3b292340-0950-11ef-8f65-d9283bb1c6cd',NULL,'début de discussion',6,'3b292340-0950-11ef-8f65-d9283bb1c6cd','3b2891c3-0950-11ef-8f65-d9283bb1c6cd','READ','2024-05-03 15:22:47.000',NULL,'2024-05-03 15:22:47.000','2024-05-03 13:24:03.000','2024-05-03 15:24:03.000'),('3c3f5758-0954-11ef-8ba8-6ec2958327c0',6,1,'Commande 1.2.7.1',NULL,'#',3,'3bc07aaf-0954-11ef-8f65-d9283bb1c6cd','3b2891c3-0950-11ef-8f65-d9283bb1c6cd','READ','2024-05-03 15:51:26.000',NULL,'2024-05-03 15:51:26.000','2024-05-28 12:41:58.905','2024-05-28 14:41:58.907'),('3c855a8e-1dcb-11ef-867c-6ec2958327c0',14,1,'Commande 1.1.1.1',NULL,'envoi d\'un message via fil de discussion page discussion',15,'3c526b33-1dcb-11ef-8e10-d517f279883e','6f667799-1dc9-11ef-8e10-d517f279883e','READ','2024-05-29 16:53:39.000',NULL,'2024-05-29 16:53:39.000','2024-05-29 14:53:55.330','2024-05-29 16:53:55.340'),('4a9bf5c5-0950-11ef-8ba8-6ec2958327c0',3,1,'Commande 1.1.1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.1.1.1\",\"date\":\"2024-05-04T00:00:00\",\"orderUpdateTime\":\"2024-05-03T15:23:10\",\"orderId\":\"c0d437cd-094f-11ef-8f65-d9283bb1c6cd\"}',6,'48d94f99-0950-11ef-8f65-d9283bb1c6cd','3b2891c3-0950-11ef-8f65-d9283bb1c6cd','READ','2024-05-03 15:23:12.000',NULL,'2024-05-03 15:23:12.000','2024-05-03 13:24:02.693','2024-05-03 15:24:02.696'),('4f3cfe4f-0869-11ef-8ba8-6ec2958327c0',3,1,'Commande 1.1.3.1',NULL,'API_META={\"type\":\"order\",\"key\":\"validated\",\"title\":\"Commande 1.1.3.1\",\"date\":\"2024-05-03T00:00:00+02:00\",\"orderUpdateTime\":\"2024-05-02T11:49:46+02:00\",\"orderId\":\"a0015ffe-0868-11ef-8ff6-da2f5a35fe58\"}',4,'2ba2ce00-d1e7-483d-8bae-a4f0690484a7','1fed07ce-0867-11ef-8ff6-da2f5a35fe58','READ','2024-05-02 11:49:46.000',NULL,'2024-05-02 11:49:46.000','2024-05-02 09:49:49.000','2024-05-02 11:49:49.000'),('565bcc49-1dcc-11ef-867c-6ec2958327c0',14,1,'Commande 1.2.1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.2.1.1\",\"date\":\"2024-05-30T00:00:00\",\"orderUpdateTime\":\"2024-05-29T17:01:30\",\"orderId\":\"1ea2c192-1dc7-11ef-8e10-d517f279883e\"}',15,'54c01682-1dcc-11ef-8e10-d517f279883e','6f667799-1dc9-11ef-8e10-d517f279883e','READ','2024-05-29 17:01:30.000',NULL,'2024-05-29 17:01:30.000','2024-05-29 15:03:08.351','2024-05-29 17:03:08.354'),('59ce9ad7-113c-11ef-8ba8-6ec2958327c0',3,1,'Commande 1.3.1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"edited\",\"title\":\"Commande 1.3.1.1\",\"date\":\"2024-05-15T00:00:00+02:00\",\"orderUpdateTime\":\"2024-05-13T17:20:37+02:00\",\"orderId\":\"bcf78fbc-113b-11ef-8f8d-d92a44d56471\"}',4,'658c7e59-201c-464f-a49b-84b6895f0ef4','1fed07ce-0867-11ef-8ff6-da2f5a35fe58','READ','2024-05-13 17:20:37.000',NULL,'2024-05-13 17:20:37.000','2024-05-13 15:20:43.000','2024-05-13 17:20:43.000'),('71a68bf3-1dc9-11ef-867c-6ec2958327c0',14,1,'Commande 1.1.1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.1.1.1\",\"date\":\"2024-05-30T00:00:00\",\"orderUpdateTime\":\"2024-05-29T16:40:46\",\"orderId\":\"97a8960f-1dc4-11ef-8e10-d517f279883e\"}',15,'6f66c850-1dc9-11ef-8e10-d517f279883e','6f667799-1dc9-11ef-8e10-d517f279883e','READ','2024-05-29 16:40:46.000',NULL,'2024-05-29 16:40:46.000','2024-05-29 14:42:39.352','2024-05-29 16:42:39.356'),('78d098a5-086d-11ef-8ba8-6ec2958327c0',3,1,'Commande 1.1.5.1',NULL,'API_META={\"type\":\"order\",\"key\":\"cancelled\",\"title\":\"Commande 1.1.5.1\",\"date\":\"2024-05-03T00:00:00+02:00\",\"orderUpdateTime\":\"2024-05-02T12:19:34+02:00\",\"orderId\":\"47d6e672-086d-11ef-8ff6-da2f5a35fe58\"}',4,'aca14a67-aec4-4653-abbd-580eaef4e795','1fed07ce-0867-11ef-8ff6-da2f5a35fe58','READ','2024-05-02 12:19:34.000',NULL,'2024-05-02 12:19:34.000','2024-05-02 10:20:12.975','2024-05-02 12:20:12.984'),('81434548-1dcc-11ef-867c-6ec2958327c0',14,1,'Commande 1.1.1.1',NULL,'remarque sur patient 1 après envoi cmde patient 2 (message envoyé via page livraison)',15,'8110e56d-1dcc-11ef-8e10-d517f279883e','6f667799-1dc9-11ef-8e10-d517f279883e','READ','2024-05-29 17:02:44.000',NULL,'2024-05-29 17:02:44.000','2024-05-29 15:03:08.337','2024-05-29 17:03:08.346'),('8c2a8513-1dc9-11ef-867c-6ec2958327c0',14,1,'Commande 1.1.1.1',NULL,'envoi d\'une cmde de env2 à un env1 uniquement',15,'8bfc228e-1dc9-11ef-8e10-d517f279883e','6f667799-1dc9-11ef-8e10-d517f279883e','READ','2024-05-29 16:41:34.000',NULL,'2024-05-29 16:41:34.000','2024-05-29 14:42:39.339','2024-05-29 16:42:39.340'),('9bd7607e-1dc9-11ef-867c-6ec2958327c0',14,1,'Commande 1.1.1.1',NULL,'cette cmde aura une validation de demo21',15,'9b7ecd4a-1dc9-11ef-8e10-d517f279883e','6f667799-1dc9-11ef-8e10-d517f279883e','READ','2024-05-29 16:42:00.000',NULL,'2024-05-29 16:42:00.000','2024-05-29 14:42:39.327','2024-05-29 16:42:39.337'),('ac038952-1dd3-11ef-867c-6ec2958327c0',15,1,'Commande 1.1.1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"validated\",\"title\":\"Commande 1.1.1.1\",\"date\":\"2024-05-30T00:00:00+02:00\",\"orderUpdateTime\":\"2024-05-29T17:54:03+02:00\",\"orderId\":\"97a8960f-1dc4-11ef-8e10-d517f279883e\"}',14,'392d6e00-235e-4b1f-9a58-90caa24b5d28','6f667799-1dc9-11ef-8e10-d517f279883e','READ','2024-05-29 17:54:03.000',NULL,'2024-05-29 17:54:03.000','2024-05-29 15:57:57.000','2024-05-29 17:57:57.000'),('b08e3a1b-1cf3-11ef-867c-6ec2958327c0',3,1,'Commande 1.2.1.1',NULL,'envoi d\'un message après envoi de la cmde sans validation pour web',6,'b0b74f75-1cf3-11ef-8f68-d9283cb4d201','3b2891c3-0950-11ef-8f65-d9283bb1c6cd','READ','2024-05-28 15:10:43.000',NULL,'2024-05-28 15:10:43.000','2024-05-29 14:14:36.903','2024-05-29 16:14:36.913'),('b0b12b05-1436-11ef-867c-6ec2958327c0',3,1,'Commande 1.6.1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"edited\",\"title\":\"Commande 1.6.1.1\",\"date\":\"2024-05-19T00:00:00+02:00\",\"orderUpdateTime\":\"2024-05-17T12:17:39+02:00\",\"orderId\":\"1f4743e1-1436-11ef-8f1b-d8242b6da0dc\"}',4,'8c5d1d24-787b-45ff-ae0d-5c464b2ca9e7','1fed07ce-0867-11ef-8ff6-da2f5a35fe58','READ','2024-05-17 12:17:39.000',NULL,'2024-05-17 12:17:39.000','2024-05-17 10:17:49.731','2024-05-17 12:17:49.741'),('c06eef11-06ed-11ef-8ba8-6ec2958327c0',3,1,'Commande 1.1.1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"edited\",\"title\":\"Commande 1.1.1.1\",\"date\":\"2024-06-14T00:00:00+02:00\",\"orderUpdateTime\":\"2024-04-30T14:32:47+02:00\",\"orderId\":\"4dd5f101-06ed-11ef-90c8-dd3986f53a42\"}',1,'976b65ef-0cc1-4f98-9f52-1b1d40d68714','97b97f39-06ed-11ef-90c8-dd3986f53a42','READ','2024-04-30 14:32:47.000',NULL,'2024-04-30 14:32:47.000','2024-04-30 12:32:53.396','2024-04-30 14:32:53.406'),('c795604e-0954-11ef-8ba8-6ec2958327c0',6,1,'Commande 1.2.7.1',NULL,'bla bla envoi via accès discussion page cmde',3,'c70e8190-0954-11ef-8f65-d9283bb1c6cd','3b2891c3-0950-11ef-8f65-d9283bb1c6cd','READ','2024-05-03 15:55:20.000',NULL,'2024-05-03 15:55:20.000','2024-05-28 12:41:58.892','2024-05-28 14:41:58.902'),('d8da6dc1-10fd-11ef-8ba8-6ec2958327c0',3,1,'Réponse depuis le web',NULL,'Ca marche très bien !!! :)',1,'1379e3ec-256c-422c-8e84-b7af5e6c9544','97b97f39-06ed-11ef-90c8-dd3986f53a42','READ','2024-05-13 09:53:12.000',NULL,'2024-05-13 09:53:12.000','2024-05-13 15:15:51.064','2024-05-13 17:15:51.073'),('da2d55f1-1dd3-11ef-867c-6ec2958327c0',15,1,'Commande 2.3.2.1',NULL,'API_META={\"type\":\"order\",\"key\":\"validated\",\"title\":\"Commande 2.3.2.1\",\"date\":\"2024-05-30T00:00:00+02:00\",\"orderUpdateTime\":\"2024-05-29T17:55:20+02:00\",\"orderId\":\"3a968bff-1dd2-11ef-8f99-d92a46e09137\"}',13,'db3c9ad3-234f-4d8b-8dfa-1281d618f09a','497ff0d0-1dd2-11ef-8f99-d92a46e09137','READ','2024-05-29 17:55:20.000',NULL,'2024-05-29 17:55:20.000','2024-05-29 15:58:07.000','2024-05-29 17:58:07.000'),('daed8125-1dca-11ef-867c-6ec2958327c0',15,1,'Commande 1.1.1.1',NULL,'réponse via le fil de discussion sélectionné sur page discussion, envoi sans fichier',14,'dad003d5-1dca-11ef-8f99-d92a46e09137','6f667799-1dc9-11ef-8e10-d517f279883e','READ','2024-05-29 16:50:56.000',NULL,'2024-05-29 16:50:56.000','2024-05-29 14:51:06.000','2024-05-29 16:51:06.000'),('eb4a9097-0951-11ef-8ba8-6ec2958327c0',3,1,'eaccaaf0-0951-11ef-8f65-d9283bb1c6cd',NULL,'#',6,'eaccaaf0-0951-11ef-8f65-d9283bb1c6cd','3b2891c3-0950-11ef-8f65-d9283bb1c6cd','READ','2024-05-03 15:34:51.000',NULL,'2024-05-03 15:34:51.000','2024-05-03 13:35:32.000','2024-05-03 15:35:32.000'),('ee3203e4-1cf1-11ef-867c-6ec2958327c0',3,1,'Commande 1.2.1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.2.1.1\",\"date\":\"2024-05-29T00:00:00\",\"orderUpdateTime\":\"2024-05-28T14:58:06\",\"orderId\":\"894691e1-1cf1-11ef-8f68-d9283cb4d201\"}',6,'ed509888-1cf1-11ef-8f68-d9283cb4d201','3b2891c3-0950-11ef-8f65-d9283bb1c6cd','READ','2024-05-28 14:58:06.000',NULL,'2024-05-28 14:58:06.000','2024-05-28 12:58:49.000','2024-05-28 14:58:49.000'),('ef7a9ab0-1dcb-11ef-867c-6ec2958327c0',3,1,'ef5d1e0d-1dcb-11ef-8f99-d92a46e09137',NULL,'bla bla',14,'ef5d1e0d-1dcb-11ef-8f99-d92a46e09137','ef5b9a32-1dcb-11ef-8f99-d92a46e09137','UNREAD','2024-05-29 16:58:40.000',NULL,'2024-05-29 16:58:40.000','2024-05-31 09:00:21.000','2024-05-31 11:00:21.000'),('f54936ea-086b-11ef-8ba8-6ec2958327c0',3,1,'Réponse depuis le web',NULL,'tes d\'envoi de message du web ',4,'70286606-85d8-4818-9d87-4ced1cde8323','1fed07ce-0867-11ef-8ff6-da2f5a35fe58','READ','2024-05-02 12:08:44.000',NULL,'2024-05-02 12:08:44.000','2024-05-02 10:09:01.842','2024-05-02 12:09:01.852'),('f95a2b23-1dca-11ef-867c-6ec2958327c0',14,1,'f924ab7b-1dca-11ef-8e10-d517f279883e',NULL,'envoi d\'un message hors commande et hors fil de discussion',15,'f924ab7b-1dca-11ef-8e10-d517f279883e','6f667799-1dc9-11ef-8e10-d517f279883e','READ','2024-05-29 16:51:47.000',NULL,'2024-05-29 16:51:47.000','2024-05-29 14:51:57.331','2024-05-29 16:51:57.341'),('fcb6a477-1436-11ef-867c-6ec2958327c0',3,1,'Commande 1.6.2.1',NULL,'API_META={\"type\":\"order\",\"key\":\"edited\",\"title\":\"Commande 1.6.2.1\",\"date\":\"2024-05-19T00:00:00+02:00\",\"orderUpdateTime\":\"2024-05-17T12:19:47+02:00\",\"orderId\":\"d9e2b705-1436-11ef-8f1b-d8242b6da0dc\"}',4,'6d1a5493-41fa-48e0-957e-ba52af9510aa','1fed07ce-0867-11ef-8ff6-da2f5a35fe58','READ','2024-05-17 12:19:47.000',NULL,'2024-05-17 12:19:47.000','2024-05-17 10:19:57.726','2024-05-17 12:19:57.735');
/*!40000 ALTER TABLE `ReceivedMessage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Scan`
--

DROP TABLE IF EXISTS `Scan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Scan` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL,
  `sessionId` varchar(36) NOT NULL,
  `type` enum('MAXILLAIRE','MANDIBULE','MORDU_ANTERIEUR','MORDU_POSTERIEUR_GAUCHE','MORDU_POSTERIEUR_DROIT') NOT NULL,
  `label` enum('PRE_PREPARATION','SCAN','SCANBODY','SCAN_SUP') NOT NULL DEFAULT 'SCAN',
  `validated` tinyint(1) NOT NULL DEFAULT 0,
  `status` enum('IN_PROGRESS','NONE') NOT NULL DEFAULT 'IN_PROGRESS',
  `displayId` mediumint(8) unsigned DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT 0,
  `comments` text DEFAULT NULL,
  `createdById` varchar(36) DEFAULT NULL,
  `updatedById` varchar(36) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `sessionId` (`sessionId`),
  CONSTRAINT `Scan_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `Scan_ibfk_2` FOREIGN KEY (`sessionId`) REFERENCES `Session` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Scan`
--

LOCK TABLES `Scan` WRITE;
/*!40000 ALTER TABLE `Scan` DISABLE KEYS */;
INSERT INTO `Scan` VALUES ('01670d72-0952-11ef-8f65-d9283bb1c6cd',3,'0166be38-0952-11ef-8f65-d9283bb1c6cd','MAXILLAIRE','SCAN',1,'NONE',1,0,'{\"imported\":true}','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-03 15:35:29.370',NULL,'2024-05-03 15:35:29.405','2024-05-03 13:35:29.405','2024-05-03 15:35:29.410'),('0da7e703-0869-11ef-8ff6-da2f5a35fe58',3,'a000fd43-0868-11ef-8ff6-da2f5a35fe58','MORDU_ANTERIEUR','SCAN',1,'NONE',1,0,'','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-02 11:47:56.547',NULL,'2024-05-02 11:48:40.484','2024-05-02 09:48:40.484','2024-05-02 11:48:40.498'),('1e96af46-0863-11ef-8ff6-da2f5a35fe58',3,'58e77d50-0861-11ef-8ff6-da2f5a35fe58','MAXILLAIRE','SCANBODY',1,'NONE',2,0,'{\"referenceScanId\":\"59e98ac5-0861-11ef-8ff6-da2f5a35fe58\"}','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-02 11:05:27.975',NULL,'2024-05-02 11:09:55.021','2024-05-02 09:09:55.021','2024-05-02 11:09:55.034'),('20b98eb5-086d-11ef-8ff6-da2f5a35fe58',3,'1fcf8a88-086d-11ef-8ff6-da2f5a35fe58','MAXILLAIRE','SCAN',1,'NONE',1,0,'','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-02 12:17:06.526',NULL,'2024-05-02 12:17:59.623','2024-05-02 10:17:59.623','2024-05-02 12:17:59.626'),('214f7b82-1436-11ef-8f1b-d8242b6da0dc',3,'1f46ec8a-1436-11ef-8f1b-d8242b6da0dc','MAXILLAIRE','SCAN',1,'NONE',1,0,'','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-17 12:13:39.142',NULL,'2024-05-22 16:04:37.854','2024-05-22 14:04:37.854','2024-05-22 16:04:37.858'),('242b7d3c-113d-11ef-8f8d-d92a44d56471',3,'233c76c4-113d-11ef-8f8d-d92a44d56471','MAXILLAIRE','SCAN',1,'NONE',1,0,'','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-13 17:26:16.928',NULL,'2024-05-13 17:26:52.787','2024-05-13 15:26:52.788','2024-05-13 17:26:52.797'),('2bf4c0e1-11cf-11ef-8f95-d92a45dc80ec',3,'2a54d83c-11cf-11ef-8f95-d92a45dc80ec','MAXILLAIRE','SCAN',1,'NONE',1,0,'','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-14 10:51:36.513',NULL,'2024-05-14 10:54:45.268','2024-05-14 08:54:45.268','2024-05-14 10:54:45.282'),('35758d89-0943-11ef-8f65-d9283bb1c6cd',3,'33ac9194-0943-11ef-8f65-d9283bb1c6cd','MAXILLAIRE','SCAN',1,'NONE',1,0,'','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-03 13:49:34.255',NULL,'2024-05-03 13:50:43.562','2024-05-03 11:50:43.562','2024-05-03 13:50:43.565'),('405b06bd-0864-11ef-8ff6-da2f5a35fe58',3,'58e77d50-0861-11ef-8ff6-da2f5a35fe58','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-02 11:13:34.123',NULL,'2024-05-02 11:14:49.968','2024-05-02 09:14:49.969','2024-05-02 11:16:05.859'),('405b2abf-0864-11ef-8ff6-da2f5a35fe58',3,'58e77d50-0861-11ef-8ff6-da2f5a35fe58','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-02 11:13:34.124',NULL,'2024-05-02 11:16:05.854','2024-05-02 09:16:05.855','2024-05-02 11:16:05.865'),('46acf99a-0951-11ef-8f65-d9283bb1c6cd',3,'45464b9d-0951-11ef-8f65-d9283bb1c6cd','MAXILLAIRE','SCAN',1,'NONE',1,0,'','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-03 15:30:16.094',NULL,'2024-05-03 15:31:31.184','2024-05-03 13:31:31.184','2024-05-03 15:31:31.187'),('53557eda-0952-11ef-8f65-d9283bb1c6cd',3,'4fc3d0e6-0952-11ef-8f65-d9283bb1c6cd','MAXILLAIRE','SCAN',1,'NONE',1,0,'','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-03 15:37:46.828',NULL,'2024-05-03 15:38:35.536','2024-05-03 13:38:35.537','2024-05-03 15:38:35.552'),('57229e01-06ed-11ef-90c8-dd3986f53a42',3,'4dd586c4-06ed-11ef-90c8-dd3986f53a42','MAXILLAIRE','SCAN',1,'NONE',1,0,'','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-04-30 14:29:51.067',NULL,'2024-04-30 14:30:35.183','2024-04-30 12:30:35.183','2024-04-30 14:30:35.188'),('58c830be-146a-11ef-8f1b-d8242b6da0dc',3,'574ac047-146a-11ef-8f1b-d8242b6da0dc','MANDIBULE','SCAN',1,'NONE',1,0,'','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-17 18:27:26.037',NULL,'2024-05-22 15:59:29.450','2024-05-22 13:59:29.450','2024-05-22 15:59:29.455'),('59e98ac5-0861-11ef-8ff6-da2f5a35fe58',3,'58e77d50-0861-11ef-8ff6-da2f5a35fe58','MAXILLAIRE','SCAN',1,'NONE',1,0,'','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-02 10:52:48.510',NULL,'2024-05-02 11:12:49.354','2024-05-02 09:12:49.354','2024-05-02 11:12:49.371'),('65575832-11d0-11ef-8f95-d92a45dc80ec',3,'2a54d83c-11cf-11ef-8f95-d92a45dc80ec','MAXILLAIRE','SCAN',1,'NONE',2,0,'','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-14 11:00:22.286',NULL,'2024-05-14 11:01:36.491','2024-05-14 09:01:36.491','2024-05-14 11:01:36.508'),('69c3c2e3-0953-11ef-8f65-d9283bb1c6cd',3,'67fdc886-0953-11ef-8f65-d9283bb1c6cd','MAXILLAIRE','SCAN',1,'NONE',1,0,'','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-03 15:45:33.957',NULL,'2024-05-03 15:46:14.904','2024-05-03 13:46:14.904','2024-05-03 15:47:01.639'),('6aa13fb3-1825-11ef-8f8e-d92a44d6667d',3,'f5ac369c-1824-11ef-8f8e-d92a44d6667d','MAXILLAIRE','SCAN',1,'NONE',1,0,'','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-22 12:24:05.358',NULL,'2024-05-22 16:02:15.433','2024-05-22 14:02:15.433','2024-05-22 16:02:15.437'),('6c005b92-146b-11ef-8f1b-d8242b6da0dc',3,'574ac047-146a-11ef-8f1b-d8242b6da0dc','MANDIBULE','SCAN',1,'NONE',2,0,'{\"referenceScanId\":\"58c830be-146a-11ef-8f1b-d8242b6da0dc\"}','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-17 18:35:07.779',NULL,'2024-05-17 18:36:24.198','2024-05-17 16:36:24.198','2024-05-17 18:36:24.204'),('6db1877c-0950-11ef-8f65-d9283bb1c6cd',3,'6db0c544-0950-11ef-8f65-d9283bb1c6cd','MAXILLAIRE','SCAN',1,'NONE',1,0,'{\"imported\":true}','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-03 15:24:12.058',NULL,'2024-05-03 15:24:12.094','2024-05-03 13:24:12.094','2024-05-03 15:24:12.102'),('7564b229-0952-11ef-8f65-d9283bb1c6cd',3,'4fc3d0e6-0952-11ef-8f65-d9283bb1c6cd','MANDIBULE','SCAN',1,'NONE',1,0,'','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-03 15:38:43.970',NULL,'2024-05-03 15:39:28.100','2024-05-03 13:39:28.100','2024-05-03 15:39:28.124'),('7e3b5074-094f-11ef-8f65-d9283bb1c6cd',6,'7d7bdba5-094f-11ef-8f65-d9283bb1c6cd','MAXILLAIRE','SCAN',1,'NONE',1,0,'','5e94742e-1a7e-484b-ad67-74101348d108','5e94742e-1a7e-484b-ad67-74101348d108','2024-05-03 15:17:30.308',NULL,'2024-05-03 15:19:13.960','2024-05-03 13:19:13.960','2024-05-03 15:19:13.963'),('8384e76f-0953-11ef-8f65-d9283bb1c6cd',3,'67fdc886-0953-11ef-8f65-d9283bb1c6cd','MANDIBULE','SCAN',1,'NONE',1,0,'','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-03 15:46:17.166',NULL,'2024-05-03 15:47:01.632','2024-05-03 13:47:01.632','2024-05-03 15:47:01.639'),('8c595f83-146d-11ef-8f1b-d8242b6da0dc',3,'8c590d83-146d-11ef-8f1b-d8242b6da0dc','MAXILLAIRE','SCAN',1,'NONE',1,0,'{\"imported\":true}','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-17 18:50:21.043',NULL,'2024-05-17 18:50:21.081','2024-05-17 16:50:21.081','2024-05-17 18:50:21.087'),('91249277-0862-11ef-8ff6-da2f5a35fe58',3,'58e77d50-0861-11ef-8ff6-da2f5a35fe58','MANDIBULE','SCAN',1,'NONE',1,0,'','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-02 11:01:30.668',NULL,'2024-05-02 11:13:06.241','2024-05-02 09:13:06.242','2024-05-02 11:13:06.259'),('9317e0a1-11fd-11ef-8f0c-d823285f66e1',3,'17719f33-11fa-11ef-8fe1-da2e5522abf3','MAXILLAIRE','SCAN',1,'NONE',1,0,'','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-14 16:23:46.398',NULL,'2024-05-14 16:27:10.701','2024-05-14 14:27:10.702','2024-05-14 16:27:10.706'),('994f08c1-1cf1-11ef-8f68-d9283cb4d201',6,'89463d55-1cf1-11ef-8f68-d9283cb4d201','MAXILLAIRE','SCAN',1,'NONE',1,0,'','5e94742e-1a7e-484b-ad67-74101348d108','5e94742e-1a7e-484b-ad67-74101348d108','2024-05-28 14:55:45.656',NULL,'2024-05-28 14:57:19.128','2024-05-28 12:57:19.128','2024-05-28 14:57:19.132'),('99f71009-0952-11ef-8f65-d9283bb1c6cd',3,'4fc3d0e6-0952-11ef-8f65-d9283bb1c6cd','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-03 15:39:45.327',NULL,'2024-05-03 15:40:27.694','2024-05-03 13:40:27.695','2024-05-03 15:40:27.711'),('9fed5eb3-146d-11ef-8f1b-d8242b6da0dc',3,'8c590d83-146d-11ef-8f1b-d8242b6da0dc','MAXILLAIRE','SCAN',1,'NONE',2,0,'{\"referenceScanId\":\"8c595f83-146d-11ef-8f1b-d8242b6da0dc\"}','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-17 18:50:53.889',NULL,'2024-05-17 18:50:53.926','2024-05-17 16:50:53.926','2024-05-17 18:50:53.940'),('a404f782-1466-11ef-8f1b-d8242b6da0dc',3,'f073b964-144c-11ef-8f1b-d8242b6da0dc','MAXILLAIRE','SCAN',1,'NONE',1,0,'','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-17 18:00:54.278',NULL,'2024-05-22 16:00:36.202','2024-05-22 14:00:36.202','2024-05-22 16:00:36.207'),('a4132a7d-174a-11ef-8f86-d92942cf49fd',3,'b1d043a8-1749-11ef-8f86-d92942cf49fd','MANDIBULE','SCAN',1,'NONE',1,0,'','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-21 10:18:01.951',NULL,'2024-05-21 10:18:54.793','2024-05-21 08:18:54.793','2024-05-21 10:18:54.808'),('abdf5c98-0953-11ef-8f65-d9283bb1c6cd',3,'67fdc886-0953-11ef-8f65-d9283bb1c6cd','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-03 15:47:24.868',NULL,'2024-05-03 15:48:23.171','2024-05-03 13:48:23.171','2024-05-03 15:48:23.186'),('b2fd8f6c-1749-11ef-8f86-d92942cf49fd',3,'b1d043a8-1749-11ef-8f86-d92942cf49fd','MAXILLAIRE','SCAN',1,'NONE',1,0,'','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-21 10:11:17.478',NULL,'2024-05-21 14:30:43.981','2024-05-21 12:30:43.982','2024-05-21 14:30:43.994'),('be43909f-0868-11ef-8ff6-da2f5a35fe58',3,'a000fd43-0868-11ef-8ff6-da2f5a35fe58','MAXILLAIRE','SCAN',1,'NONE',1,0,'','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-02 11:45:43.349',NULL,'2024-05-02 11:46:55.908','2024-05-02 09:46:55.909','2024-05-02 11:47:45.470'),('be5151d5-113b-11ef-8f8d-d92a44d56471',3,'bcf73039-113b-11ef-8f8d-d92a44d56471','MAXILLAIRE','SCAN',1,'NONE',1,0,'','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-13 17:16:16.551',NULL,'2024-05-13 17:17:24.076','2024-05-13 15:17:24.076','2024-05-13 17:17:24.081'),('c6ed67bf-1dc9-11ef-8f99-d92a46e09137',14,'c6ed23a8-1dc9-11ef-8f99-d92a46e09137','MAXILLAIRE','SCAN',1,'NONE',1,0,'{\"imported\":true}','15df53c7-ad9e-4f1e-a585-21f844968574','15df53c7-ad9e-4f1e-a585-21f844968574','2024-05-29 16:43:13.485',NULL,'2024-05-29 16:43:13.517','2024-05-29 14:43:13.517','2024-05-29 16:43:13.526'),('c6f3aa83-1dc9-11ef-8f99-d92a46e09137',14,'c6ed23a8-1dc9-11ef-8f99-d92a46e09137','MANDIBULE','SCAN',1,'NONE',1,0,'{\"imported\":true}','15df53c7-ad9e-4f1e-a585-21f844968574','15df53c7-ad9e-4f1e-a585-21f844968574','2024-05-29 16:43:13.526',NULL,'2024-05-29 16:43:13.557','2024-05-29 14:43:13.558','2024-05-29 16:43:13.562'),('ce02f919-146b-11ef-8f1b-d8242b6da0dc',3,'574ac047-146a-11ef-8f1b-d8242b6da0dc','MAXILLAIRE','SCAN',1,'NONE',1,0,'','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-17 18:37:52.213',NULL,'2024-05-22 16:00:13.962','2024-05-22 14:00:13.962','2024-05-22 16:00:13.966'),('d802a151-146c-11ef-8f1b-d8242b6da0dc',3,'574ac047-146a-11ef-8f1b-d8242b6da0dc','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-17 18:45:18.485',NULL,'2024-05-17 18:45:52.634','2024-05-17 16:45:52.634','2024-05-17 18:45:52.649'),('e0fd2566-1749-11ef-8f86-d92942cf49fd',3,'b1d043a8-1749-11ef-8f86-d92942cf49fd','MAXILLAIRE','SCANBODY',1,'NONE',2,0,'{\"referenceScanId\":\"b2fd8f6c-1749-11ef-8f86-d92942cf49fd\"}','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-21 10:12:34.651',NULL,'2024-05-21 10:14:51.597','2024-05-21 08:14:51.597','2024-05-21 10:14:51.605'),('e68d77dd-176c-11ef-8f86-d92942cf49fd',3,'b1d043a8-1749-11ef-8f86-d92942cf49fd','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-21 14:23:16.371',NULL,'2024-05-21 14:24:19.616','2024-05-21 12:24:19.616','2024-05-21 14:24:19.629'),('e877efd5-1dc9-11ef-8f99-d92a46e09137',14,'c6ed23a8-1dc9-11ef-8f99-d92a46e09137','MAXILLAIRE','SCAN',1,'NONE',2,0,'{\"referenceScanId\":\"c6ed67bf-1dc9-11ef-8f99-d92a46e09137\"}','15df53c7-ad9e-4f1e-a585-21f844968574','15df53c7-ad9e-4f1e-a585-21f844968574','2024-05-29 16:44:09.758',NULL,'2024-05-29 16:45:13.707','2024-05-29 14:45:13.707','2024-05-29 16:45:13.724'),('e9b9b436-1843-11ef-8f8e-d92a44d6667d',3,'f5ac369c-1824-11ef-8f8e-d92a44d6667d','MAXILLAIRE','SCAN',1,'NONE',2,0,'','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-22 16:02:23.491',NULL,'2024-05-22 16:03:43.745','2024-05-22 14:03:43.745','2024-05-22 16:03:43.759'),('eacd5e79-0868-11ef-8ff6-da2f5a35fe58',3,'a000fd43-0868-11ef-8ff6-da2f5a35fe58','MANDIBULE','SCAN',1,'NONE',1,0,'','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-02 11:46:58.072',NULL,'2024-05-02 11:47:45.465','2024-05-02 09:47:45.465','2024-05-02 11:47:45.478'),('ee955675-1dd1-11ef-8f99-d92a46e09137',15,'ec1e3d64-1dd1-11ef-8f99-d92a46e09137','MAXILLAIRE','SCAN',1,'NONE',1,0,'','397b4e6f-5e8d-4926-8242-58217e16b7cd','397b4e6f-5e8d-4926-8242-58217e16b7cd','2024-05-29 17:41:35.991',NULL,'2024-05-29 17:42:27.190','2024-05-29 15:42:27.190','2024-05-29 17:42:27.208'),('f4d296fb-0952-11ef-8f65-d9283bb1c6cd',3,'4fc3d0e6-0952-11ef-8f65-d9283bb1c6cd','MAXILLAIRE','SCAN',1,'NONE',2,0,'{\"referenceScanId\":\"53557eda-0952-11ef-8f65-d9283bb1c6cd\"}','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','dd3bc7cf-f623-48bf-8a9f-0cc2c4d26575','2024-05-03 15:42:17.761',NULL,'2024-05-03 15:43:06.424','2024-05-03 13:43:06.424','2024-05-03 15:43:06.429');
/*!40000 ALTER TABLE `Scan` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ScanFile`
--

DROP TABLE IF EXISTS `ScanFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ScanFile` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `scanId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('MODEL','SNAPSHOT','SCREENSHOT','LIFI','LIFIMETA','METERING','SEGMENTED') NOT NULL,
  PRIMARY KEY (`scanId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `ScanFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `ScanFile_ibfk_2` FOREIGN KEY (`scanId`) REFERENCES `Scan` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ScanFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ScanFile`
--

LOCK TABLES `ScanFile` WRITE;
/*!40000 ALTER TABLE `ScanFile` DISABLE KEYS */;
INSERT INTO `ScanFile` VALUES (3,'01670d72-0952-11ef-8f65-d9283bb1c6cd','01671c38-0952-11ef-8f65-d9283bb1c6cd','MODEL'),(3,'01670d72-0952-11ef-8f65-d9283bb1c6cd','016c64d3-0952-11ef-8f65-d9283bb1c6cd','SNAPSHOT'),(3,'0da7e703-0869-11ef-8ff6-da2f5a35fe58','27b8b3c2-0869-11ef-8ff6-da2f5a35fe58','MODEL'),(3,'0da7e703-0869-11ef-8ff6-da2f5a35fe58','27b8c661-0869-11ef-8ff6-da2f5a35fe58','SNAPSHOT'),(3,'1e96af46-0863-11ef-8ff6-da2f5a35fe58','1e96d0f1-0863-11ef-8ff6-da2f5a35fe58','MODEL'),(3,'1e96af46-0863-11ef-8ff6-da2f5a35fe58','1ea66a74-0863-11ef-8ff6-da2f5a35fe58','SNAPSHOT'),(3,'1e96af46-0863-11ef-8ff6-da2f5a35fe58','3163c7c7-0863-11ef-8ff6-da2f5a35fe58','SEGMENTED'),(3,'1e96af46-0863-11ef-8ff6-da2f5a35fe58','3ea239fc-0863-11ef-8ff6-da2f5a35fe58','MODEL'),(3,'1e96af46-0863-11ef-8ff6-da2f5a35fe58','bc911890-0863-11ef-8ff6-da2f5a35fe58','MODEL'),(3,'1e96af46-0863-11ef-8ff6-da2f5a35fe58','bc912779-0863-11ef-8ff6-da2f5a35fe58','SNAPSHOT'),(3,'20b98eb5-086d-11ef-8ff6-da2f5a35fe58','3102e726-086d-11ef-8ff6-da2f5a35fe58','MODEL'),(3,'20b98eb5-086d-11ef-8ff6-da2f5a35fe58','3102fb86-086d-11ef-8ff6-da2f5a35fe58','SNAPSHOT'),(3,'214f7b82-1436-11ef-8f1b-d8242b6da0dc','2b2af635-1844-11ef-8f8e-d92a44d6667d','SCREENSHOT'),(3,'214f7b82-1436-11ef-8f1b-d8242b6da0dc','2cc50615-1844-11ef-8f8e-d92a44d6667d','SCREENSHOT'),(3,'214f7b82-1436-11ef-8f1b-d8242b6da0dc','2e7c9b07-1844-11ef-8f8e-d92a44d6667d','SCREENSHOT'),(3,'214f7b82-1436-11ef-8f1b-d8242b6da0dc','30213ce6-1844-11ef-8f8e-d92a44d6667d','SCREENSHOT'),(3,'214f7b82-1436-11ef-8f1b-d8242b6da0dc','318da0fb-1844-11ef-8f8e-d92a44d6667d','SCREENSHOT'),(3,'214f7b82-1436-11ef-8f1b-d8242b6da0dc','3c611073-1436-11ef-8f1b-d8242b6da0dc','MODEL'),(3,'214f7b82-1436-11ef-8f1b-d8242b6da0dc','3c6127b7-1436-11ef-8f1b-d8242b6da0dc','SNAPSHOT'),(3,'242b7d3c-113d-11ef-8f8d-d92a44d56471','39676397-113d-11ef-8f8d-d92a44d56471','MODEL'),(3,'242b7d3c-113d-11ef-8f8d-d92a44d56471','39676fab-113d-11ef-8f8d-d92a44d56471','SNAPSHOT'),(3,'2bf4c0e1-11cf-11ef-8f95-d92a45dc80ec','560d23c3-11cf-11ef-8f95-d92a45dc80ec','MODEL'),(3,'2bf4c0e1-11cf-11ef-8f95-d92a45dc80ec','560d402a-11cf-11ef-8f95-d92a45dc80ec','SNAPSHOT'),(3,'2bf4c0e1-11cf-11ef-8f95-d92a45dc80ec','8a49c9a4-11cf-11ef-8f95-d92a45dc80ec','SCREENSHOT'),(3,'2bf4c0e1-11cf-11ef-8f95-d92a45dc80ec','8f7e3337-11cf-11ef-8f95-d92a45dc80ec','SCREENSHOT'),(3,'2bf4c0e1-11cf-11ef-8f95-d92a45dc80ec','9353afab-11cf-11ef-8f95-d92a45dc80ec','SCREENSHOT'),(3,'2bf4c0e1-11cf-11ef-8f95-d92a45dc80ec','97300d09-11cf-11ef-8f95-d92a45dc80ec','SCREENSHOT'),(3,'2bf4c0e1-11cf-11ef-8f95-d92a45dc80ec','9c6dafad-11cf-11ef-8f95-d92a45dc80ec','SCREENSHOT'),(3,'35758d89-0943-11ef-8f65-d9283bb1c6cd','550d8ad7-0943-11ef-8f65-d9283bb1c6cd','MODEL'),(3,'35758d89-0943-11ef-8f65-d9283bb1c6cd','550da95b-0943-11ef-8f65-d9283bb1c6cd','SNAPSHOT'),(3,'405b06bd-0864-11ef-8ff6-da2f5a35fe58','6d5ff7a6-0864-11ef-8ff6-da2f5a35fe58','MODEL'),(3,'405b06bd-0864-11ef-8ff6-da2f5a35fe58','6d60184b-0864-11ef-8ff6-da2f5a35fe58','SNAPSHOT'),(3,'405b2abf-0864-11ef-8ff6-da2f5a35fe58','9a964568-0864-11ef-8ff6-da2f5a35fe58','MODEL'),(3,'405b2abf-0864-11ef-8ff6-da2f5a35fe58','9a965491-0864-11ef-8ff6-da2f5a35fe58','SNAPSHOT'),(3,'46acf99a-0951-11ef-8f65-d9283bb1c6cd','5b90aefe-0951-11ef-8f65-d9283bb1c6cd','MODEL'),(3,'46acf99a-0951-11ef-8f65-d9283bb1c6cd','5b90bdc4-0951-11ef-8f65-d9283bb1c6cd','SNAPSHOT'),(3,'53557eda-0952-11ef-8f65-d9283bb1c6cd','703520a2-0952-11ef-8f65-d9283bb1c6cd','MODEL'),(3,'53557eda-0952-11ef-8f65-d9283bb1c6cd','70352ec8-0952-11ef-8f65-d9283bb1c6cd','SNAPSHOT'),(3,'57229e01-06ed-11ef-90c8-dd3986f53a42','714f63b2-06ed-11ef-90c8-dd3986f53a42','MODEL'),(3,'57229e01-06ed-11ef-90c8-dd3986f53a42','714f73d7-06ed-11ef-90c8-dd3986f53a42','SNAPSHOT'),(3,'58c830be-146a-11ef-8f1b-d8242b6da0dc','621768a1-1843-11ef-8f8e-d92a44d6667d','SCREENSHOT'),(3,'58c830be-146a-11ef-8f1b-d8242b6da0dc','796f7da8-1843-11ef-8f8e-d92a44d6667d','SCREENSHOT'),(3,'58c830be-146a-11ef-8f1b-d8242b6da0dc','79d18196-146a-11ef-8f1b-d8242b6da0dc','MODEL'),(3,'58c830be-146a-11ef-8f1b-d8242b6da0dc','79d19082-146a-11ef-8f1b-d8242b6da0dc','SNAPSHOT'),(3,'59e98ac5-0861-11ef-8ff6-da2f5a35fe58','25ab5185-0864-11ef-8ff6-da2f5a35fe58','LIFI'),(3,'59e98ac5-0861-11ef-8ff6-da2f5a35fe58','25ab54c4-0864-11ef-8ff6-da2f5a35fe58','LIFIMETA'),(3,'59e98ac5-0861-11ef-8ff6-da2f5a35fe58','d88962f2-0863-11ef-8ff6-da2f5a35fe58','LIFI'),(3,'59e98ac5-0861-11ef-8ff6-da2f5a35fe58','d88967ff-0863-11ef-8ff6-da2f5a35fe58','LIFIMETA'),(3,'59e98ac5-0861-11ef-8ff6-da2f5a35fe58','e0bfa86b-0863-11ef-8ff6-da2f5a35fe58','LIFI'),(3,'59e98ac5-0861-11ef-8ff6-da2f5a35fe58','e0bfadf4-0863-11ef-8ff6-da2f5a35fe58','LIFIMETA'),(3,'59e98ac5-0861-11ef-8ff6-da2f5a35fe58','ea71e741-0863-11ef-8ff6-da2f5a35fe58','LIFI'),(3,'59e98ac5-0861-11ef-8ff6-da2f5a35fe58','ea71eca5-0863-11ef-8ff6-da2f5a35fe58','LIFIMETA'),(3,'59e98ac5-0861-11ef-8ff6-da2f5a35fe58','eb746e19-0861-11ef-8ff6-da2f5a35fe58','MODEL'),(3,'59e98ac5-0861-11ef-8ff6-da2f5a35fe58','eb7485b0-0861-11ef-8ff6-da2f5a35fe58','SNAPSHOT'),(3,'65575832-11d0-11ef-8f95-d92a45dc80ec','916b8d15-11d0-11ef-8f95-d92a45dc80ec','MODEL'),(3,'65575832-11d0-11ef-8f95-d92a45dc80ec','916b9ff3-11d0-11ef-8f95-d92a45dc80ec','SNAPSHOT'),(3,'69c3c2e3-0953-11ef-8f65-d9283bb1c6cd','8208349e-0953-11ef-8f65-d9283bb1c6cd','MODEL'),(3,'69c3c2e3-0953-11ef-8f65-d9283bb1c6cd','8208421c-0953-11ef-8f65-d9283bb1c6cd','SNAPSHOT'),(3,'6aa13fb3-1825-11ef-8f8e-d92a44d6667d','d65d389b-1825-11ef-8f8e-d92a44d6667d','MODEL'),(3,'6aa13fb3-1825-11ef-8f8e-d92a44d6667d','d65d5317-1825-11ef-8f8e-d92a44d6667d','SNAPSHOT'),(3,'6aa13fb3-1825-11ef-8f8e-d92a44d6667d','dac26566-1843-11ef-8f8e-d92a44d6667d','SCREENSHOT'),(3,'6aa13fb3-1825-11ef-8f8e-d92a44d6667d','dcd75868-1843-11ef-8f8e-d92a44d6667d','SCREENSHOT'),(3,'6aa13fb3-1825-11ef-8f8e-d92a44d6667d','ded13a58-1843-11ef-8f8e-d92a44d6667d','SCREENSHOT'),(3,'6aa13fb3-1825-11ef-8f8e-d92a44d6667d','dfaf3432-1825-11ef-8f8e-d92a44d6667d','SEGMENTED'),(3,'6c005b92-146b-11ef-8f1b-d8242b6da0dc','6c00823f-146b-11ef-8f1b-d8242b6da0dc','MODEL'),(3,'6c005b92-146b-11ef-8f1b-d8242b6da0dc','6c0694b6-146b-11ef-8f1b-d8242b6da0dc','SNAPSHOT'),(3,'6c005b92-146b-11ef-8f1b-d8242b6da0dc','99357a18-146b-11ef-8f1b-d8242b6da0dc','MODEL'),(3,'6c005b92-146b-11ef-8f1b-d8242b6da0dc','99358b17-146b-11ef-8f1b-d8242b6da0dc','SNAPSHOT'),(3,'6db1877c-0950-11ef-8f65-d9283bb1c6cd','6db19776-0950-11ef-8f65-d9283bb1c6cd','MODEL'),(3,'6db1877c-0950-11ef-8f65-d9283bb1c6cd','6db6e19d-0950-11ef-8f65-d9283bb1c6cd','SNAPSHOT'),(3,'7564b229-0952-11ef-8f65-d9283bb1c6cd','8f8b2e60-0952-11ef-8f65-d9283bb1c6cd','MODEL'),(3,'7564b229-0952-11ef-8f65-d9283bb1c6cd','8f8b46a0-0952-11ef-8f65-d9283bb1c6cd','SNAPSHOT'),(6,'7e3b5074-094f-11ef-8f65-d9283bb1c6cd','9935aa64-094f-11ef-8f65-d9283bb1c6cd','MODEL'),(6,'7e3b5074-094f-11ef-8f65-d9283bb1c6cd','9935cedf-094f-11ef-8f65-d9283bb1c6cd','SNAPSHOT'),(3,'8384e76f-0953-11ef-8f65-d9283bb1c6cd','9ddab794-0953-11ef-8f65-d9283bb1c6cd','MODEL'),(3,'8384e76f-0953-11ef-8f65-d9283bb1c6cd','9ddac7dd-0953-11ef-8f65-d9283bb1c6cd','SNAPSHOT'),(3,'8c595f83-146d-11ef-8f1b-d8242b6da0dc','8c59743f-146d-11ef-8f1b-d8242b6da0dc','MODEL'),(3,'8c595f83-146d-11ef-8f1b-d8242b6da0dc','8c5f19ed-146d-11ef-8f1b-d8242b6da0dc','SNAPSHOT'),(3,'91249277-0862-11ef-8ff6-da2f5a35fe58','17764359-0863-11ef-8ff6-da2f5a35fe58','MODEL'),(3,'91249277-0862-11ef-8ff6-da2f5a35fe58','17765260-0863-11ef-8ff6-da2f5a35fe58','SNAPSHOT'),(3,'91249277-0862-11ef-8ff6-da2f5a35fe58','2fbc2cef-0864-11ef-8ff6-da2f5a35fe58','LIFI'),(3,'91249277-0862-11ef-8ff6-da2f5a35fe58','2fbc3392-0864-11ef-8ff6-da2f5a35fe58','LIFIMETA'),(3,'9317e0a1-11fd-11ef-8f0c-d823285f66e1','0be6f95e-11fe-11ef-8f0c-d823285f66e1','MODEL'),(3,'9317e0a1-11fd-11ef-8f0c-d823285f66e1','0be7116f-11fe-11ef-8f0c-d823285f66e1','SNAPSHOT'),(6,'994f08c1-1cf1-11ef-8f68-d9283cb4d201','d0c9b40d-1cf1-11ef-8f68-d9283cb4d201','MODEL'),(6,'994f08c1-1cf1-11ef-8f68-d9283cb4d201','d0c9cbb2-1cf1-11ef-8f68-d9283cb4d201','SNAPSHOT'),(3,'99f71009-0952-11ef-8f65-d9283bb1c6cd','b3179c69-0952-11ef-8f65-d9283bb1c6cd','MODEL'),(3,'99f71009-0952-11ef-8f65-d9283bb1c6cd','b317b04e-0952-11ef-8f65-d9283bb1c6cd','SNAPSHOT'),(3,'9fed5eb3-146d-11ef-8f1b-d8242b6da0dc','9fed873b-146d-11ef-8f1b-d8242b6da0dc','MODEL'),(3,'9fed5eb3-146d-11ef-8f1b-d8242b6da0dc','9ff2e69b-146d-11ef-8f1b-d8242b6da0dc','SNAPSHOT'),(3,'a404f782-1466-11ef-8f1b-d8242b6da0dc','003281d2-1843-11ef-8f8e-d92a44d6667d','SCREENSHOT'),(3,'a404f782-1466-11ef-8f1b-d8242b6da0dc','037f4e74-1843-11ef-8f8e-d92a44d6667d','SCREENSHOT'),(3,'a404f782-1466-11ef-8f1b-d8242b6da0dc','03a4f7ef-1834-11ef-8f8e-d92a44d6667d','METERING'),(3,'a404f782-1466-11ef-8f1b-d8242b6da0dc','069f9819-1843-11ef-8f8e-d92a44d6667d','SCREENSHOT'),(3,'a404f782-1466-11ef-8f1b-d8242b6da0dc','1dcd04df-183e-11ef-8f8e-d92a44d6667d','METERING'),(3,'a404f782-1466-11ef-8f1b-d8242b6da0dc','53799350-1468-11ef-8f1b-d8242b6da0dc','MODEL'),(3,'a404f782-1466-11ef-8f1b-d8242b6da0dc','5379a891-1468-11ef-8f1b-d8242b6da0dc','SNAPSHOT'),(3,'a404f782-1466-11ef-8f1b-d8242b6da0dc','5a21d0db-1467-11ef-8f1b-d8242b6da0dc','SCREENSHOT'),(3,'a404f782-1466-11ef-8f1b-d8242b6da0dc','7cfb78fe-1467-11ef-8f1b-d8242b6da0dc','LIFI'),(3,'a404f782-1466-11ef-8f1b-d8242b6da0dc','7cfb7be6-1467-11ef-8f1b-d8242b6da0dc','LIFIMETA'),(3,'a404f782-1466-11ef-8f1b-d8242b6da0dc','a2c565cd-1467-11ef-8f1b-d8242b6da0dc','SCREENSHOT'),(3,'a404f782-1466-11ef-8f1b-d8242b6da0dc','a517d5ee-1843-11ef-8f8e-d92a44d6667d','SCREENSHOT'),(3,'a404f782-1466-11ef-8f1b-d8242b6da0dc','b10594c5-183e-11ef-8f8e-d92a44d6667d','METERING'),(3,'a404f782-1466-11ef-8f1b-d8242b6da0dc','ce611e03-1466-11ef-8f1b-d8242b6da0dc','MODEL'),(3,'a404f782-1466-11ef-8f1b-d8242b6da0dc','ce613798-1466-11ef-8f1b-d8242b6da0dc','SNAPSHOT'),(3,'a404f782-1466-11ef-8f1b-d8242b6da0dc','e727070b-1467-11ef-8f1b-d8242b6da0dc','MODEL'),(3,'a404f782-1466-11ef-8f1b-d8242b6da0dc','e7271556-1467-11ef-8f1b-d8242b6da0dc','SNAPSHOT'),(3,'a404f782-1466-11ef-8f1b-d8242b6da0dc','f49fc51a-1842-11ef-8f8e-d92a44d6667d','SCREENSHOT'),(3,'a404f782-1466-11ef-8f1b-d8242b6da0dc','f724c29c-1842-11ef-8f8e-d92a44d6667d','SCREENSHOT'),(3,'a4132a7d-174a-11ef-8f86-d92942cf49fd','c369126f-174a-11ef-8f86-d92942cf49fd','MODEL'),(3,'a4132a7d-174a-11ef-8f86-d92942cf49fd','c3692577-174a-11ef-8f86-d92942cf49fd','SNAPSHOT'),(3,'abdf5c98-0953-11ef-8f65-d9283bb1c6cd','ce77d355-0953-11ef-8f65-d9283bb1c6cd','MODEL'),(3,'abdf5c98-0953-11ef-8f65-d9283bb1c6cd','ce77e28b-0953-11ef-8f65-d9283bb1c6cd','SNAPSHOT'),(3,'b2fd8f6c-1749-11ef-8f86-d92942cf49fd','7047b842-176d-11ef-8f86-d92942cf49fd','LIFI'),(3,'b2fd8f6c-1749-11ef-8f86-d92942cf49fd','7047bd17-176d-11ef-8f86-d92942cf49fd','LIFIMETA'),(3,'b2fd8f6c-1749-11ef-8f86-d92942cf49fd','78e0c630-176d-11ef-8f86-d92942cf49fd','LIFI'),(3,'b2fd8f6c-1749-11ef-8f86-d92942cf49fd','78e0cc57-176d-11ef-8f86-d92942cf49fd','LIFIMETA'),(3,'b2fd8f6c-1749-11ef-8f86-d92942cf49fd','db87bf87-1749-11ef-8f86-d92942cf49fd','MODEL'),(3,'b2fd8f6c-1749-11ef-8f86-d92942cf49fd','db87d2f4-1749-11ef-8f86-d92942cf49fd','SNAPSHOT'),(3,'b2fd8f6c-1749-11ef-8f86-d92942cf49fd','f1591e3a-176d-11ef-8f86-d92942cf49fd','METERING'),(3,'be43909f-0868-11ef-8ff6-da2f5a35fe58','e94e0fa3-0868-11ef-8ff6-da2f5a35fe58','MODEL'),(3,'be43909f-0868-11ef-8ff6-da2f5a35fe58','e94e2f27-0868-11ef-8ff6-da2f5a35fe58','SNAPSHOT'),(3,'be5151d5-113b-11ef-8f8d-d92a44d56471','e662db00-113b-11ef-8f8d-d92a44d56471','MODEL'),(3,'be5151d5-113b-11ef-8f8d-d92a44d56471','e662fcef-113b-11ef-8f8d-d92a44d56471','SNAPSHOT'),(14,'c6ed67bf-1dc9-11ef-8f99-d92a46e09137','c6ed76b0-1dc9-11ef-8f99-d92a46e09137','MODEL'),(14,'c6ed67bf-1dc9-11ef-8f99-d92a46e09137','c6f234cd-1dc9-11ef-8f99-d92a46e09137','SNAPSHOT'),(14,'c6f3aa83-1dc9-11ef-8f99-d92a46e09137','c6f3ba52-1dc9-11ef-8f99-d92a46e09137','MODEL'),(14,'c6f3aa83-1dc9-11ef-8f99-d92a46e09137','c6f86b86-1dc9-11ef-8f99-d92a46e09137','SNAPSHOT'),(3,'ce02f919-146b-11ef-8f1b-d8242b6da0dc','5a776a40-1843-11ef-8f8e-d92a44d6667d','SEGMENTED'),(3,'ce02f919-146b-11ef-8f1b-d8242b6da0dc','5da650e1-1843-11ef-8f8e-d92a44d6667d','SCREENSHOT'),(3,'ce02f919-146b-11ef-8f1b-d8242b6da0dc','890659a3-1843-11ef-8f8e-d92a44d6667d','SCREENSHOT'),(3,'ce02f919-146b-11ef-8f1b-d8242b6da0dc','8b206780-1843-11ef-8f8e-d92a44d6667d','SCREENSHOT'),(3,'ce02f919-146b-11ef-8f1b-d8242b6da0dc','8d463d2e-1843-11ef-8f8e-d92a44d6667d','SCREENSHOT'),(3,'ce02f919-146b-11ef-8f1b-d8242b6da0dc','8f098cf6-1843-11ef-8f8e-d92a44d6667d','SCREENSHOT'),(3,'ce02f919-146b-11ef-8f1b-d8242b6da0dc','908c31ae-1843-11ef-8f8e-d92a44d6667d','SCREENSHOT'),(3,'ce02f919-146b-11ef-8f1b-d8242b6da0dc','9c306613-146c-11ef-8f1b-d8242b6da0dc','MODEL'),(3,'ce02f919-146b-11ef-8f1b-d8242b6da0dc','9c307424-146c-11ef-8f1b-d8242b6da0dc','SNAPSHOT'),(3,'d802a151-146c-11ef-8f1b-d8242b6da0dc','ec401636-146c-11ef-8f1b-d8242b6da0dc','MODEL'),(3,'d802a151-146c-11ef-8f1b-d8242b6da0dc','ec40284c-146c-11ef-8f1b-d8242b6da0dc','SNAPSHOT'),(3,'e0fd2566-1749-11ef-8f86-d92942cf49fd','3238bfed-174a-11ef-8f86-d92942cf49fd','MODEL'),(3,'e0fd2566-1749-11ef-8f86-d92942cf49fd','3238d9b7-174a-11ef-8f86-d92942cf49fd','SNAPSHOT'),(3,'e0fd2566-1749-11ef-8f86-d92942cf49fd','e0fd50b7-1749-11ef-8f86-d92942cf49fd','MODEL'),(3,'e0fd2566-1749-11ef-8f86-d92942cf49fd','e103322a-1749-11ef-8f86-d92942cf49fd','SNAPSHOT'),(3,'e0fd2566-1749-11ef-8f86-d92942cf49fd','eccd0411-1749-11ef-8f86-d92942cf49fd','MODEL'),(3,'e68d77dd-176c-11ef-8f86-d92942cf49fd','0c100533-176d-11ef-8f86-d92942cf49fd','MODEL'),(3,'e68d77dd-176c-11ef-8f86-d92942cf49fd','0c1018e1-176d-11ef-8f86-d92942cf49fd','SNAPSHOT'),(14,'e877efd5-1dc9-11ef-8f99-d92a46e09137','0e958929-1dca-11ef-8f99-d92a46e09137','LIFI'),(14,'e877efd5-1dc9-11ef-8f99-d92a46e09137','0e958d91-1dca-11ef-8f99-d92a46e09137','LIFIMETA'),(14,'e877efd5-1dc9-11ef-8f99-d92a46e09137','e8781907-1dc9-11ef-8f99-d92a46e09137','MODEL'),(14,'e877efd5-1dc9-11ef-8f99-d92a46e09137','e87d6c35-1dc9-11ef-8f99-d92a46e09137','SNAPSHOT'),(14,'e877efd5-1dc9-11ef-8f99-d92a46e09137','f4305e3b-1dc9-11ef-8f99-d92a46e09137','MODEL'),(14,'e877efd5-1dc9-11ef-8f99-d92a46e09137','fadb936e-1dc9-11ef-8f99-d92a46e09137','LIFI'),(14,'e877efd5-1dc9-11ef-8f99-d92a46e09137','fadb9840-1dc9-11ef-8f99-d92a46e09137','LIFIMETA'),(3,'e9b9b436-1843-11ef-8f8e-d92a44d6667d','0436cb1e-1844-11ef-8f8e-d92a44d6667d','MODEL'),(3,'e9b9b436-1843-11ef-8f8e-d92a44d6667d','0436e535-1844-11ef-8f8e-d92a44d6667d','SNAPSHOT'),(3,'e9b9b436-1843-11ef-8f8e-d92a44d6667d','07d305e5-1844-11ef-8f8e-d92a44d6667d','SCREENSHOT'),(3,'e9b9b436-1843-11ef-8f8e-d92a44d6667d','09b43640-1844-11ef-8f8e-d92a44d6667d','SCREENSHOT'),(3,'e9b9b436-1843-11ef-8f8e-d92a44d6667d','0af94c65-1844-11ef-8f8e-d92a44d6667d','SCREENSHOT'),(3,'e9b9b436-1843-11ef-8f8e-d92a44d6667d','0c4b4c9c-1844-11ef-8f8e-d92a44d6667d','SCREENSHOT'),(3,'e9b9b436-1843-11ef-8f8e-d92a44d6667d','0dc15345-1844-11ef-8f8e-d92a44d6667d','SCREENSHOT'),(3,'e9b9b436-1843-11ef-8f8e-d92a44d6667d','198d6002-1844-11ef-8f8e-d92a44d6667d','SEGMENTED'),(3,'eacd5e79-0868-11ef-8ff6-da2f5a35fe58','06de7932-0869-11ef-8ff6-da2f5a35fe58','MODEL'),(3,'eacd5e79-0868-11ef-8ff6-da2f5a35fe58','06de8cba-0869-11ef-8ff6-da2f5a35fe58','SNAPSHOT'),(15,'ee955675-1dd1-11ef-8f99-d92a46e09137','0ceccb78-1dd2-11ef-8f99-d92a46e09137','MODEL'),(15,'ee955675-1dd1-11ef-8f99-d92a46e09137','0cece571-1dd2-11ef-8f99-d92a46e09137','SNAPSHOT'),(3,'f4d296fb-0952-11ef-8f65-d9283bb1c6cd','119efae7-0953-11ef-8f65-d9283bb1c6cd','MODEL'),(3,'f4d296fb-0952-11ef-8f65-d9283bb1c6cd','119f0cfd-0953-11ef-8f65-d9283bb1c6cd','SNAPSHOT'),(3,'f4d296fb-0952-11ef-8f65-d9283bb1c6cd','f4d2b8bb-0952-11ef-8f65-d9283bb1c6cd','MODEL'),(3,'f4d296fb-0952-11ef-8f65-d9283bb1c6cd','f4d8deb1-0952-11ef-8f65-d9283bb1c6cd','SNAPSHOT');
/*!40000 ALTER TABLE `ScanFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SentAttachment`
--

DROP TABLE IF EXISTS `SentAttachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SentAttachment` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `sentMessageId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  PRIMARY KEY (`sentMessageId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `SentAttachment_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `SentAttachment_ibfk_2` FOREIGN KEY (`sentMessageId`) REFERENCES `SentMessage` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `SentAttachment_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SentAttachment`
--

LOCK TABLES `SentAttachment` WRITE;
/*!40000 ALTER TABLE `SentAttachment` DISABLE KEYS */;
INSERT INTO `SentAttachment` VALUES (3,'17b0adf8-0947-11ef-8f65-d9283bb1c6cd','1745752c-0947-11ef-8f65-d9283bb1c6cd'),(3,'17b0adf8-0947-11ef-8f65-d9283bb1c6cd','550d8ad7-0943-11ef-8f65-d9283bb1c6cd'),(3,'17b0adf8-0947-11ef-8f65-d9283bb1c6cd','550da95b-0943-11ef-8f65-d9283bb1c6cd'),(3,'18dfb5e3-0954-11ef-8f65-d9283bb1c6cd','187400c0-0954-11ef-8f65-d9283bb1c6cd'),(3,'18dfb5e3-0954-11ef-8f65-d9283bb1c6cd','d1d98002-0953-11ef-8f65-d9283bb1c6cd'),(3,'18dfb5e3-0954-11ef-8f65-d9283bb1c6cd','d1f26a61-0953-11ef-8f65-d9283bb1c6cd'),(3,'18dfb5e3-0954-11ef-8f65-d9283bb1c6cd','d26c0218-0953-11ef-8f65-d9283bb1c6cd'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','17764359-0863-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','17765260-0863-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','1f81ed28-0867-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','25ab5185-0864-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','25ab54c4-0864-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','2fbc2cef-0864-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','2fbc3392-0864-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','a3a69b8b-0864-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','a3e32cc1-0864-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','a3e332c3-0864-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','a3e37662-0864-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','a3e37c4f-0864-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','a3e3b7e2-0864-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','a413fc36-0864-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','a414024b-0864-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','a4f01daf-0864-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','bc911890-0863-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','bc912779-0863-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','bdd2799d-0864-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','ea71e741-0863-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','ea71eca5-0863-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','eb746e19-0861-11ef-8ff6-da2f5a35fe58'),(3,'1fed5512-0867-11ef-8ff6-da2f5a35fe58','eb7485b0-0861-11ef-8ff6-da2f5a35fe58'),(3,'2c749216-1437-11ef-8f1b-d8242b6da0dc','20b557de-0954-11ef-8f65-d9283bb1c6cd'),(3,'2c749216-1437-11ef-8f1b-d8242b6da0dc','8208349e-0953-11ef-8f65-d9283bb1c6cd'),(3,'2c749216-1437-11ef-8f1b-d8242b6da0dc','8208421c-0953-11ef-8f65-d9283bb1c6cd'),(3,'32745aba-0869-11ef-8ff6-da2f5a35fe58','2aa61e09-0869-11ef-8ff6-da2f5a35fe58'),(3,'32745aba-0869-11ef-8ff6-da2f5a35fe58','2ac2bcfd-0869-11ef-8ff6-da2f5a35fe58'),(3,'32745aba-0869-11ef-8ff6-da2f5a35fe58','2b3e9ab9-0869-11ef-8ff6-da2f5a35fe58'),(3,'32745aba-0869-11ef-8ff6-da2f5a35fe58','3202c706-0869-11ef-8ff6-da2f5a35fe58'),(3,'34ee3417-0954-11ef-8f65-d9283bb1c6cd','20b557de-0954-11ef-8f65-d9283bb1c6cd'),(3,'379f0632-1438-11ef-8f1b-d8242b6da0dc','0be6f95e-11fe-11ef-8f0c-d823285f66e1'),(3,'379f0632-1438-11ef-8f1b-d8242b6da0dc','0be7116f-11fe-11ef-8f0c-d823285f66e1'),(3,'3bc07aaf-0954-11ef-8f65-d9283bb1c6cd','20b557de-0954-11ef-8f65-d9283bb1c6cd'),(3,'409777ad-113d-11ef-8f8d-d92a44d56471','39676397-113d-11ef-8f8d-d92a44d56471'),(3,'409777ad-113d-11ef-8f8d-d92a44d56471','39676fab-113d-11ef-8f8d-d92a44d56471'),(3,'409777ad-113d-11ef-8f8d-d92a44d56471','401b4fc2-113d-11ef-8f8d-d92a44d56471'),(3,'47778199-1438-11ef-8f1b-d8242b6da0dc','560d23c3-11cf-11ef-8f95-d92a45dc80ec'),(3,'47778199-1438-11ef-8f1b-d8242b6da0dc','560d402a-11cf-11ef-8f95-d92a45dc80ec'),(3,'47778199-1438-11ef-8f1b-d8242b6da0dc','97300d09-11cf-11ef-8f95-d92a45dc80ec'),(3,'4b822710-1469-11ef-8f1b-d8242b6da0dc','4b160442-1469-11ef-8f1b-d8242b6da0dc'),(3,'4b822710-1469-11ef-8f1b-d8242b6da0dc','53799350-1468-11ef-8f1b-d8242b6da0dc'),(3,'4b822710-1469-11ef-8f1b-d8242b6da0dc','5379a891-1468-11ef-8f1b-d8242b6da0dc'),(3,'4de24f2b-086d-11ef-8ff6-da2f5a35fe58','3102e726-086d-11ef-8ff6-da2f5a35fe58'),(3,'4de24f2b-086d-11ef-8ff6-da2f5a35fe58','3102fb86-086d-11ef-8ff6-da2f5a35fe58'),(3,'4de24f2b-086d-11ef-8ff6-da2f5a35fe58','4d7752a0-086d-11ef-8ff6-da2f5a35fe58'),(3,'8cb3a6c4-1467-11ef-8f1b-d8242b6da0dc','5a21d0db-1467-11ef-8f1b-d8242b6da0dc'),(3,'8cb3a6c4-1467-11ef-8f1b-d8242b6da0dc','7cfb78fe-1467-11ef-8f1b-d8242b6da0dc'),(3,'8cb3a6c4-1467-11ef-8f1b-d8242b6da0dc','7cfb7be6-1467-11ef-8f1b-d8242b6da0dc'),(3,'8cb3a6c4-1467-11ef-8f1b-d8242b6da0dc','8c48de05-1467-11ef-8f1b-d8242b6da0dc'),(3,'8cb3a6c4-1467-11ef-8f1b-d8242b6da0dc','ce611e03-1466-11ef-8f1b-d8242b6da0dc'),(3,'8cb3a6c4-1467-11ef-8f1b-d8242b6da0dc','ce613798-1466-11ef-8f1b-d8242b6da0dc'),(3,'953cc15b-1436-11ef-8f1b-d8242b6da0dc','3c611073-1436-11ef-8f1b-d8242b6da0dc'),(3,'953cc15b-1436-11ef-8f1b-d8242b6da0dc','3c6127b7-1436-11ef-8f1b-d8242b6da0dc'),(3,'953cc15b-1436-11ef-8f1b-d8242b6da0dc','94d3f721-1436-11ef-8f1b-d8242b6da0dc'),(3,'97b9c350-06ed-11ef-90c8-dd3986f53a42','714f63b2-06ed-11ef-90c8-dd3986f53a42'),(3,'97b9c350-06ed-11ef-90c8-dd3986f53a42','714f73d7-06ed-11ef-90c8-dd3986f53a42'),(3,'97b9c350-06ed-11ef-90c8-dd3986f53a42','97508969-06ed-11ef-90c8-dd3986f53a42'),(3,'e68d94d2-1436-11ef-8f1b-d8242b6da0dc','3c611073-1436-11ef-8f1b-d8242b6da0dc'),(3,'e68d94d2-1436-11ef-8f1b-d8242b6da0dc','3c6127b7-1436-11ef-8f1b-d8242b6da0dc'),(3,'e68d94d2-1436-11ef-8f1b-d8242b6da0dc','e6255f00-1436-11ef-8f1b-d8242b6da0dc'),(3,'eb779002-1437-11ef-8f1b-d8242b6da0dc','3c611073-1436-11ef-8f1b-d8242b6da0dc'),(3,'eb779002-1437-11ef-8f1b-d8242b6da0dc','3c6127b7-1436-11ef-8f1b-d8242b6da0dc'),(3,'eb779002-1437-11ef-8f1b-d8242b6da0dc','eb0e1462-1437-11ef-8f1b-d8242b6da0dc'),(3,'f42b2ad8-113b-11ef-8f8d-d92a44d56471','e662db00-113b-11ef-8f8d-d92a44d56471'),(3,'f42b2ad8-113b-11ef-8f8d-d92a44d56471','e662fcef-113b-11ef-8f8d-d92a44d56471'),(3,'f42b2ad8-113b-11ef-8f8d-d92a44d56471','f3c05df6-113b-11ef-8f8d-d92a44d56471'),(3,'fd3a7c7d-1437-11ef-8f1b-d8242b6da0dc','3102e726-086d-11ef-8ff6-da2f5a35fe58'),(3,'fd3a7c7d-1437-11ef-8f1b-d8242b6da0dc','3102fb86-086d-11ef-8ff6-da2f5a35fe58'),(6,'48d94f99-0950-11ef-8f65-d9283bb1c6cd','486e554c-0950-11ef-8f65-d9283bb1c6cd'),(6,'48d94f99-0950-11ef-8f65-d9283bb1c6cd','9935aa64-094f-11ef-8f65-d9283bb1c6cd'),(6,'48d94f99-0950-11ef-8f65-d9283bb1c6cd','9935cedf-094f-11ef-8f65-d9283bb1c6cd'),(6,'eaccaaf0-0951-11ef-8f65-d9283bb1c6cd','9935aa64-094f-11ef-8f65-d9283bb1c6cd'),(6,'eaccaaf0-0951-11ef-8f65-d9283bb1c6cd','9935cedf-094f-11ef-8f65-d9283bb1c6cd'),(6,'ed509888-1cf1-11ef-8f68-d9283cb4d201','d0c9b40d-1cf1-11ef-8f68-d9283cb4d201'),(6,'ed509888-1cf1-11ef-8f68-d9283cb4d201','d0c9cbb2-1cf1-11ef-8f68-d9283cb4d201'),(6,'ed509888-1cf1-11ef-8f68-d9283cb4d201','ece2d99e-1cf1-11ef-8f68-d9283cb4d201'),(15,'2c6341b5-1dd2-11ef-8f99-d92a46e09137','0ceccb78-1dd2-11ef-8f99-d92a46e09137'),(15,'2c6341b5-1dd2-11ef-8f99-d92a46e09137','0cece571-1dd2-11ef-8f99-d92a46e09137'),(15,'2c6341b5-1dd2-11ef-8f99-d92a46e09137','2bf2d463-1dd2-11ef-8f99-d92a46e09137'),(15,'49805aee-1dd2-11ef-8f99-d92a46e09137','0ceccb78-1dd2-11ef-8f99-d92a46e09137'),(15,'49805aee-1dd2-11ef-8f99-d92a46e09137','0cece571-1dd2-11ef-8f99-d92a46e09137'),(15,'49805aee-1dd2-11ef-8f99-d92a46e09137','491138ed-1dd2-11ef-8f99-d92a46e09137'),(15,'54c01682-1dcc-11ef-8e10-d517f279883e','544fb565-1dcc-11ef-8e10-d517f279883e'),(15,'54c01682-1dcc-11ef-8e10-d517f279883e','5f5cf463-1dc7-11ef-8e10-d517f279883e'),(15,'54c01682-1dcc-11ef-8e10-d517f279883e','5f5d05e8-1dc7-11ef-8e10-d517f279883e'),(15,'6f66c850-1dc9-11ef-8e10-d517f279883e','000494bd-1dc5-11ef-8e10-d517f279883e'),(15,'6f66c850-1dc9-11ef-8e10-d517f279883e','0004a3c1-1dc5-11ef-8e10-d517f279883e'),(15,'6f66c850-1dc9-11ef-8e10-d517f279883e','3f572760-1dc5-11ef-8e10-d517f279883e'),(15,'6f66c850-1dc9-11ef-8e10-d517f279883e','3f7139f8-1dc5-11ef-8e10-d517f279883e'),(15,'6f66c850-1dc9-11ef-8e10-d517f279883e','3febc366-1dc5-11ef-8e10-d517f279883e'),(15,'6f66c850-1dc9-11ef-8e10-d517f279883e','6ef5ef7b-1dc9-11ef-8e10-d517f279883e'),(15,'6f66c850-1dc9-11ef-8e10-d517f279883e','e3f49fd8-1dc4-11ef-8e10-d517f279883e'),(15,'6f66c850-1dc9-11ef-8e10-d517f279883e','e3f5f8d4-1dc4-11ef-8e10-d517f279883e');
/*!40000 ALTER TABLE `SentAttachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SentMessage`
--

DROP TABLE IF EXISTS `SentMessage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SentMessage` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `discussionId` varchar(36) NOT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `answeredId` varchar(36) DEFAULT NULL COMMENT 'SentMessage uuid or ReceivedMessage originMessageId',
  `body` text DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `discussionId` (`discussionId`,`ownerId`),
  CONSTRAINT `SentMessage_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `SentMessage_ibfk_2` FOREIGN KEY (`discussionId`, `ownerId`) REFERENCES `Discussion` (`uuid`, `ownerId`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SentMessage`
--

LOCK TABLES `SentMessage` WRITE;
/*!40000 ALTER TABLE `SentMessage` DISABLE KEYS */;
INSERT INTO `SentMessage` VALUES ('06afbfbe-113c-11ef-8f8d-d92a44d56471',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.3.1.1',NULL,'message après envoi cmde avt réponse web','2024-05-13 17:18:17.000',NULL,'2024-05-13 17:18:17.000','2024-05-13 15:18:18.000','2024-05-13 17:18:18.000'),('06b68eed-1437-11ef-8f1b-d8242b6da0dc',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.6.2.1',NULL,'envoi message après retour web avant validation c','2024-05-17 12:20:04.015',NULL,'2024-05-17 12:20:04.016','2024-05-17 10:20:04.016','2024-05-17 12:20:04.025'),('06eb8cdf-1437-11ef-8f1b-d8242b6da0dc',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.6.2.1',NULL,'h','2024-05-17 12:20:04.363','2024-05-17 12:20:15.430','2024-05-17 12:20:04.363','2024-05-17 10:20:15.430','2024-05-17 12:20:15.440'),('080c3ab0-1bc9-454e-a6f9-8c4c167f03df',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.6.2.1',NULL,'API_META={\"type\":\"order\",\"key\":\"validated\",\"title\":\"Commande 1.6.2.1\",\"date\":\"2024-05-19T00:00:00+02:00\",\"orderUpdateTime\":\"2024-05-17T12:20:25+02:00\",\"orderId\":\"d9e2b705-1436-11ef-8f1b-d8242b6da0dc\"}','2024-05-17 12:20:25.000',NULL,'2024-05-17 12:20:25.000','2024-05-17 10:20:25.000','2024-05-17 12:20:25.000'),('0ab7a78f-a39e-4180-9e24-2f7e3d76ba8f',3,'97b97f39-06ed-11ef-90c8-dd3986f53a42','Commande 1.1.1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"validated\",\"title\":\"Commande 1.1.1.1\",\"date\":\"2024-06-14T00:00:00+02:00\",\"orderUpdateTime\":\"2024-04-30T14:32:57+02:00\",\"orderId\":\"4dd5f101-06ed-11ef-90c8-dd3986f53a42\"}','2024-04-30 14:32:58.000',NULL,'2024-04-30 14:32:58.000','2024-04-30 12:32:58.000','2024-04-30 14:32:58.000'),('154baa5a-086c-11ef-8ff6-da2f5a35fe58',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.1.2.1',NULL,'envoi messag page livraison troisième essai','2024-05-02 12:09:38.000',NULL,'2024-05-02 12:09:38.000','2024-05-02 10:09:38.000','2024-05-02 12:09:38.000'),('17b0adf8-0947-11ef-8f65-d9283bb1c6cd',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.2.1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.2.1.1\",\"date\":\"2024-05-04T00:00:00\",\"orderUpdateTime\":\"2024-05-03T14:17:22\",\"orderId\":\"0e416c0d-0947-11ef-8f65-d9283bb1c6cd\"}','2024-05-03 14:17:25.000',NULL,'2024-05-03 14:17:25.000','2024-05-03 12:17:25.000','2024-05-03 14:17:25.000'),('18dfb5e3-0954-11ef-8f65-d9283bb1c6cd',3,'3b2891c3-0950-11ef-8f65-d9283bb1c6cd','Commande 1.2.7.1',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.2.7.1\",\"date\":\"2024-05-04T00:00:00\",\"orderUpdateTime\":\"2024-05-03T15:50:27\",\"orderId\":\"67fe27de-0953-11ef-8f65-d9283bb1c6cd\"}','2024-05-03 15:50:29.000',NULL,'2024-05-03 15:50:29.000','2024-05-03 13:50:29.000','2024-05-03 15:50:29.000'),('19aed8ae-1469-11ef-8f1b-d8242b6da0dc',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.7.1.1','8cb3a6c4-1467-11ef-8f1b-d8242b6da0dc','message envoyé via page discussion','2024-05-17 18:18:30.678',NULL,'2024-05-17 18:18:30.678','2024-05-17 16:18:30.678','2024-05-17 18:18:30.688'),('1b47fa3f-1437-11ef-8f1b-d8242b6da0dc',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.6.2.1',NULL,'après validation chgt date','2024-05-17 12:20:38.523',NULL,'2024-05-17 12:20:38.523','2024-05-17 10:20:38.523','2024-05-17 12:20:38.533'),('1fed5512-0867-11ef-8ff6-da2f5a35fe58',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.1.2.1',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.1.2.1\",\"date\":\"2024-05-03T00:00:00\",\"orderUpdateTime\":\"2024-05-02T11:34:08\",\"orderId\":\"58e7cf64-0861-11ef-8ff6-da2f5a35fe58\"}','2024-05-02 11:34:11.000',NULL,'2024-05-02 11:34:11.000','2024-05-02 09:34:11.000','2024-05-02 11:34:11.000'),('2c6341b5-1dd2-11ef-8f99-d92a46e09137',15,'6f667799-1dc9-11ef-8e10-d517f279883e','Commande 2.3.1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 2.3.1.1\",\"date\":\"2024-05-30T00:00:00\",\"orderUpdateTime\":\"2024-05-29T17:43:19\",\"orderId\":\"ec1e9f7a-1dd1-11ef-8f99-d92a46e09137\"}','2024-05-29 17:43:19.000',NULL,'2024-05-29 17:43:19.000','2024-05-29 15:43:20.000','2024-05-29 17:43:20.000'),('2c749216-1437-11ef-8f1b-d8242b6da0dc',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.6.2.1',NULL,'avec envoi de pj','2024-05-17 12:21:07.336',NULL,'2024-05-17 12:21:07.337','2024-05-17 10:21:07.337','2024-05-17 12:21:07.350'),('32745aba-0869-11ef-8ff6-da2f5a35fe58',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.1.3.1',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.1.3.1\",\"date\":\"2024-05-03T00:00:00\",\"orderUpdateTime\":\"2024-05-02T11:48:58\",\"orderId\":\"a0015ffe-0868-11ef-8ff6-da2f5a35fe58\"}','2024-05-02 11:49:00.000',NULL,'2024-05-02 11:49:00.000','2024-05-02 09:49:00.000','2024-05-02 11:49:00.000'),('34ee3417-0954-11ef-8f65-d9283bb1c6cd',3,'3b2891c3-0950-11ef-8f65-d9283bb1c6cd','34ee3417-0954-11ef-8f65-d9283bb1c6cd',NULL,'#','2024-05-03 15:51:14.813',NULL,'2024-05-03 15:51:14.813','2024-05-03 13:51:14.813','2024-05-03 15:51:14.826'),('379f0632-1438-11ef-8f1b-d8242b6da0dc',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.6.3.1',NULL,'message avec pj avant validation chgt date','2024-05-17 12:28:35.566',NULL,'2024-05-17 12:28:35.566','2024-05-17 10:28:35.567','2024-05-17 12:28:35.581'),('3b292340-0950-11ef-8f65-d9283bb1c6cd',6,'3b2891c3-0950-11ef-8f65-d9283bb1c6cd','3b292340-0950-11ef-8f65-d9283bb1c6cd',NULL,'début de discussion','2024-05-03 15:22:47.278',NULL,'2024-05-03 15:22:47.278','2024-05-03 13:22:47.278','2024-05-03 15:22:47.281'),('3bc07aaf-0954-11ef-8f65-d9283bb1c6cd',3,'3b2891c3-0950-11ef-8f65-d9283bb1c6cd','Commande 1.2.7.1',NULL,'#','2024-05-03 15:51:26.257',NULL,'2024-05-03 15:51:26.257','2024-05-03 13:51:26.257','2024-05-03 15:51:26.268'),('3c526b33-1dcb-11ef-8e10-d517f279883e',15,'6f667799-1dc9-11ef-8e10-d517f279883e','Commande 1.1.1.1',NULL,'envoi d\'un message via fil de discussion page discussion','2024-05-29 16:53:39.000',NULL,'2024-05-29 16:53:39.000','2024-05-29 14:53:40.000','2024-05-29 16:53:40.000'),('3ffa3b3a-0869-11ef-8ff6-da2f5a35fe58',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.1.3.1',NULL,'envoi message avant reponse destinataire','2024-05-02 11:49:21.000',NULL,'2024-05-02 11:49:21.000','2024-05-02 09:49:21.000','2024-05-02 11:49:21.000'),('409777ad-113d-11ef-8f8d-d92a44d56471',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.3.2.1',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.3.2.1\",\"date\":\"2024-05-14T00:00:00\",\"orderUpdateTime\":\"2024-05-13T17:27:04\",\"orderId\":\"233cdf71-113d-11ef-8f8d-d92a44d56471\"}','2024-05-13 17:27:04.000',NULL,'2024-05-13 17:27:04.000','2024-05-13 15:27:06.000','2024-05-13 17:27:06.000'),('45671074-ce71-4c4d-97a3-f60edaa91b77',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.3.1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"validated\",\"title\":\"Commande 1.3.1.1\",\"date\":\"2024-05-15T00:00:00+02:00\",\"orderUpdateTime\":\"2024-05-13T17:20:50+02:00\",\"orderId\":\"bcf78fbc-113b-11ef-8f8d-d92a44d56471\"}','2024-05-13 17:20:51.000',NULL,'2024-05-13 17:20:51.000','2024-05-13 15:20:51.000','2024-05-13 17:20:51.000'),('47778199-1438-11ef-8f1b-d8242b6da0dc',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.6.3.1',NULL,'après validation chgt de date','2024-05-17 12:29:02.151',NULL,'2024-05-17 12:29:02.151','2024-05-17 10:29:02.152','2024-05-17 12:29:02.162'),('48d94f99-0950-11ef-8f65-d9283bb1c6cd',6,'3b2891c3-0950-11ef-8f65-d9283bb1c6cd','Commande 1.1.1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.1.1.1\",\"date\":\"2024-05-04T00:00:00\",\"orderUpdateTime\":\"2024-05-03T15:23:10\",\"orderId\":\"c0d437cd-094f-11ef-8f65-d9283bb1c6cd\"}','2024-05-03 15:23:12.000',NULL,'2024-05-03 15:23:12.000','2024-05-03 13:23:12.000','2024-05-03 15:23:12.000'),('49805aee-1dd2-11ef-8f99-d92a46e09137',15,'497ff0d0-1dd2-11ef-8f99-d92a46e09137','Commande 2.3.2.1',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 2.3.2.1\",\"date\":\"2024-05-30T00:00:00\",\"orderUpdateTime\":\"2024-05-29T17:44:08\",\"orderId\":\"3a968bff-1dd2-11ef-8f99-d92a46e09137\"}','2024-05-29 17:44:08.000',NULL,'2024-05-29 17:44:08.000','2024-05-29 15:44:09.000','2024-05-29 17:44:09.000'),('4b822710-1469-11ef-8f1b-d8242b6da0dc',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.7.2.1',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.7.2.1\",\"date\":\"2024-05-18T00:00:00\",\"orderUpdateTime\":\"2024-05-17T18:19:54\",\"orderId\":\"419edfb4-1469-11ef-8f1b-d8242b6da0dc\"}','2024-05-17 18:19:55.000',NULL,'2024-05-17 18:19:55.000','2024-05-17 16:19:55.000','2024-05-17 18:19:55.000'),('4de24f2b-086d-11ef-8ff6-da2f5a35fe58',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.1.5.1',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.1.5.1\",\"date\":\"2024-05-03T00:00:00\",\"orderUpdateTime\":\"2024-05-02T12:18:22\",\"orderId\":\"47d6e672-086d-11ef-8ff6-da2f5a35fe58\"}','2024-05-02 12:18:24.000',NULL,'2024-05-02 12:18:24.000','2024-05-02 10:18:24.000','2024-05-02 12:18:24.000'),('517d0d0f-1dd4-11ef-8e10-d517f279883e',15,'497ff0d0-1dd2-11ef-8f99-d92a46e09137','Commande 2.3.2.1',NULL,'commande non visible sur env2','2024-05-29 17:58:40.000',NULL,'2024-05-29 17:58:40.000','2024-05-29 15:58:41.000','2024-05-29 17:58:41.000'),('54c01682-1dcc-11ef-8e10-d517f279883e',15,'6f667799-1dc9-11ef-8e10-d517f279883e','Commande 1.2.1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.2.1.1\",\"date\":\"2024-05-30T00:00:00\",\"orderUpdateTime\":\"2024-05-29T17:01:30\",\"orderId\":\"1ea2c192-1dc7-11ef-8e10-d517f279883e\"}','2024-05-29 17:01:30.000',NULL,'2024-05-29 17:01:30.000','2024-05-29 15:01:33.000','2024-05-29 17:01:33.000'),('57c2d78c-086d-11ef-8ff6-da2f5a35fe58',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.1.5.1',NULL,'test avt reponse','2024-05-02 12:18:38.861',NULL,'2024-05-02 12:18:38.862','2024-05-02 10:18:38.862','2024-05-02 12:18:38.873'),('5959503d-1dd2-11ef-8f99-d92a46e09137',15,'497ff0d0-1dd2-11ef-8f99-d92a46e09137','Commande 2.3.2.1',NULL,'envoi à env 2','2024-05-29 17:44:35.113',NULL,'2024-05-29 17:44:35.114','2024-05-29 15:44:35.114','2024-05-29 17:44:35.128'),('5e14225d-1469-11ef-8f1b-d8242b6da0dc',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.7.2.1',NULL,'message page livraison après envoi commande','2024-05-17 18:20:25.427',NULL,'2024-05-17 18:20:25.427','2024-05-17 16:20:25.427','2024-05-17 18:20:25.437'),('65b39fb1-1dd2-11ef-8f99-d92a46e09137',15,'6f667799-1dc9-11ef-8e10-d517f279883e','Commande 2.3.1.1',NULL,'envoi à env 1','2024-05-29 17:44:55.838',NULL,'2024-05-29 17:44:55.838','2024-05-29 15:44:55.838','2024-05-29 17:44:55.848'),('68135cb6-086e-11ef-8ff6-da2f5a35fe58',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.1.3.1',NULL,'envoi via page livraison 1/2 heure après','2024-05-02 12:26:15.729',NULL,'2024-05-02 12:26:15.730','2024-05-02 10:26:15.730','2024-05-02 12:26:15.733'),('6d270b56-0c6a-4586-810b-b2149a940503',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.1.2.1',NULL,'API_META={\"type\":\"order\",\"key\":\"validated\",\"title\":\"Commande 1.1.2.1\",\"date\":\"2024-05-04T00:00:00+02:00\",\"orderUpdateTime\":\"2024-05-02T11:34:42+02:00\",\"orderId\":\"58e7cf64-0861-11ef-8ff6-da2f5a35fe58\"}','2024-05-02 11:34:42.000',NULL,'2024-05-02 11:34:42.000','2024-05-02 09:34:42.000','2024-05-02 11:34:42.000'),('6f66c850-1dc9-11ef-8e10-d517f279883e',15,'6f667799-1dc9-11ef-8e10-d517f279883e','Commande 1.1.1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.1.1.1\",\"date\":\"2024-05-30T00:00:00\",\"orderUpdateTime\":\"2024-05-29T16:40:46\",\"orderId\":\"97a8960f-1dc4-11ef-8e10-d517f279883e\"}','2024-05-29 16:40:46.000',NULL,'2024-05-29 16:40:46.000','2024-05-29 14:40:50.000','2024-05-29 16:40:50.000'),('7c835c86-aa16-429b-bad8-5ee8de4f3075',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.2.1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"validated\",\"title\":\"Commande 1.2.1.1\",\"date\":\"2024-05-05T00:00:00+02:00\",\"orderUpdateTime\":\"2024-05-03T15:00:28+02:00\",\"orderId\":\"0e416c0d-0947-11ef-8f65-d9283bb1c6cd\"}','2024-05-03 15:00:29.000',NULL,'2024-05-03 15:00:29.000','2024-05-03 13:00:29.000','2024-05-03 15:00:29.000'),('8110e56d-1dcc-11ef-8e10-d517f279883e',15,'6f667799-1dc9-11ef-8e10-d517f279883e','Commande 1.1.1.1',NULL,'remarque sur patient 1 après envoi cmde patient 2 (message envoyé via page livraison)','2024-05-29 17:02:44.000',NULL,'2024-05-29 17:02:44.000','2024-05-29 15:02:45.000','2024-05-29 17:02:45.000'),('8bfc228e-1dc9-11ef-8e10-d517f279883e',15,'6f667799-1dc9-11ef-8e10-d517f279883e','Commande 1.1.1.1',NULL,'envoi d\'une cmde de env2 à un env1 uniquement','2024-05-29 16:41:34.000',NULL,'2024-05-29 16:41:34.000','2024-05-29 14:41:34.000','2024-05-29 16:41:34.000'),('8cb3a6c4-1467-11ef-8f1b-d8242b6da0dc',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.7.1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.7.1.1\",\"date\":\"2024-05-18T00:00:00\",\"orderUpdateTime\":\"2024-05-17T18:07:24\",\"orderId\":\"f0742777-144c-11ef-8f1b-d8242b6da0dc\"}','2024-05-17 18:07:26.000',NULL,'2024-05-17 18:07:26.000','2024-05-17 16:07:26.000','2024-05-17 18:07:26.000'),('953cc15b-1436-11ef-8f1b-d8242b6da0dc',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.6.1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.6.1.1\",\"date\":\"2024-05-18T00:00:00\",\"orderUpdateTime\":\"2024-05-17T12:16:53\",\"orderId\":\"1f4743e1-1436-11ef-8f1b-d8242b6da0dc\"}','2024-05-17 12:16:53.000',NULL,'2024-05-17 12:16:53.000','2024-05-17 10:16:54.000','2024-05-17 12:16:54.000'),('97b9c350-06ed-11ef-90c8-dd3986f53a42',3,'97b97f39-06ed-11ef-90c8-dd3986f53a42','Commande 1.1.1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.1.1.1\",\"date\":\"2024-05-31T00:00:00\",\"orderUpdateTime\":\"2024-04-30T14:31:39\",\"orderId\":\"4dd5f101-06ed-11ef-90c8-dd3986f53a42\"}','2024-04-30 14:31:41.000',NULL,'2024-04-30 14:31:41.000','2024-04-30 12:31:41.000','2024-04-30 14:31:41.000'),('985a9923-0869-11ef-8ff6-da2f5a35fe58',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.1.3.1',NULL,'envoi message après validation cmde par destinataire, fait par la page discussion car non ok niveau page livraison','2024-05-02 11:51:49.243',NULL,'2024-05-02 11:51:49.243','2024-05-02 09:51:49.244','2024-05-02 11:51:49.255'),('9aa53190-086d-11ef-8ff6-da2f5a35fe58',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.1.5.1',NULL,'test après refus via page discussion filtrée','2024-05-02 12:20:31.075',NULL,'2024-05-02 12:20:31.075','2024-05-02 10:20:31.075','2024-05-02 12:20:31.085'),('9b7ecd4a-1dc9-11ef-8e10-d517f279883e',15,'6f667799-1dc9-11ef-8e10-d517f279883e','Commande 1.1.1.1',NULL,'cette cmde aura une validation de demo21','2024-05-29 16:42:00.000',NULL,'2024-05-29 16:42:00.000','2024-05-29 14:42:01.000','2024-05-29 16:42:01.000'),('b0b74f75-1cf3-11ef-8f68-d9283cb4d201',6,'3b2891c3-0950-11ef-8f65-d9283bb1c6cd','Commande 1.2.1.1',NULL,'envoi d\'un message après envoi de la cmde sans validation pour web','2024-05-28 15:10:43.920',NULL,'2024-05-28 15:10:43.921','2024-05-28 13:10:43.921','2024-05-28 15:10:43.930'),('b96617fb-113d-11ef-8f8d-d92a44d56471',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.3.2.1',NULL,'message avt réponse web via page discussion','2024-05-13 17:30:27.292',NULL,'2024-05-13 17:30:27.293','2024-05-13 15:30:27.293','2024-05-13 17:30:27.306'),('c70e8190-0954-11ef-8f65-d9283bb1c6cd',3,'3b2891c3-0950-11ef-8f65-d9283bb1c6cd','Commande 1.2.7.1',NULL,'bla bla envoi via accès discussion page cmde','2024-05-03 15:55:20.000',NULL,'2024-05-03 15:55:20.000','2024-05-03 13:55:20.000','2024-05-03 15:55:20.000'),('ccb7c702-1436-11ef-8f1b-d8242b6da0dc',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.6.1.1',NULL,'envoi message après chgt date validé','2024-05-17 12:18:26.716',NULL,'2024-05-17 12:18:26.716','2024-05-17 10:18:26.716','2024-05-17 12:18:26.725'),('ce651eec-25d4-41a0-8016-4e29b837509d',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.6.3.1',NULL,'API_META={\"type\":\"order\",\"key\":\"validated\",\"title\":\"Commande 1.6.3.1\",\"date\":\"2024-05-19T00:00:00+02:00\",\"orderUpdateTime\":\"2024-05-17T12:28:38+02:00\",\"orderId\":\"d963f904-1437-11ef-8f1b-d8242b6da0dc\"}','2024-05-17 12:28:39.000',NULL,'2024-05-17 12:28:39.000','2024-05-17 10:28:39.000','2024-05-17 12:28:39.000'),('d54e8176-0867-11ef-8ff6-da2f5a35fe58',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','d54e8176-0867-11ef-8ff6-da2f5a35fe58',NULL,'envoi via page de discussion','2024-05-02 11:39:12.512',NULL,'2024-05-02 11:39:12.512','2024-05-02 09:39:12.512','2024-05-02 11:39:12.523'),('dad003d5-1dca-11ef-8f99-d92a46e09137',14,'6f667799-1dc9-11ef-8e10-d517f279883e','Commande 1.1.1.1',NULL,'réponse via le fil de discussion sélectionné sur page discussion, envoi sans fichier','2024-05-29 16:50:56.344',NULL,'2024-05-29 16:50:56.344','2024-05-29 14:50:56.344','2024-05-29 16:50:56.354'),('e68d94d2-1436-11ef-8f1b-d8242b6da0dc',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.6.2.1',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.6.2.1\",\"date\":\"2024-05-18T00:00:00\",\"orderUpdateTime\":\"2024-05-17T12:19:10\",\"orderId\":\"d9e2b705-1436-11ef-8f1b-d8242b6da0dc\"}','2024-05-17 12:19:10.000',NULL,'2024-05-17 12:19:10.000','2024-05-17 10:19:11.000','2024-05-17 12:19:11.000'),('ea731232-0867-11ef-8ff6-da2f5a35fe58',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.1.2.1',NULL,'envoi via discussion filtrée','2024-05-02 11:39:48.000',NULL,'2024-05-02 11:39:48.000','2024-05-02 09:39:48.000','2024-05-02 11:39:48.000'),('eaccaaf0-0951-11ef-8f65-d9283bb1c6cd',6,'3b2891c3-0950-11ef-8f65-d9283bb1c6cd','eaccaaf0-0951-11ef-8f65-d9283bb1c6cd',NULL,'#','2024-05-03 15:34:51.448',NULL,'2024-05-03 15:34:51.448','2024-05-03 13:34:51.448','2024-05-03 15:34:51.462'),('eb779002-1437-11ef-8f1b-d8242b6da0dc',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.6.3.1',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.6.3.1\",\"date\":\"2024-05-18T00:00:00\",\"orderUpdateTime\":\"2024-05-17T12:26:27\",\"orderId\":\"d963f904-1437-11ef-8f1b-d8242b6da0dc\"}','2024-05-17 12:26:27.000',NULL,'2024-05-17 12:26:27.000','2024-05-17 10:26:29.000','2024-05-17 12:26:29.000'),('ed509888-1cf1-11ef-8f68-d9283cb4d201',6,'3b2891c3-0950-11ef-8f65-d9283bb1c6cd','Commande 1.2.1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.2.1.1\",\"date\":\"2024-05-29T00:00:00\",\"orderUpdateTime\":\"2024-05-28T14:58:06\",\"orderId\":\"894691e1-1cf1-11ef-8f68-d9283cb4d201\"}','2024-05-28 14:58:06.000',NULL,'2024-05-28 14:58:06.000','2024-05-28 12:58:07.000','2024-05-28 14:58:07.000'),('ef5d1e0d-1dcb-11ef-8f99-d92a46e09137',14,'ef5b9a32-1dcb-11ef-8f99-d92a46e09137','ef5d1e0d-1dcb-11ef-8f99-d92a46e09137',NULL,'bla bla','2024-05-29 16:58:40.319',NULL,'2024-05-29 16:58:40.320','2024-05-29 14:58:40.320','2024-05-29 16:58:40.322'),('f32e1637-1436-11ef-8f1b-d8242b6da0dc',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.6.2.1',NULL,'envoi message avant retour web','2024-05-17 12:19:31.244',NULL,'2024-05-17 12:19:31.244','2024-05-17 10:19:31.245','2024-05-17 12:19:31.256'),('f42b2ad8-113b-11ef-8f8d-d92a44d56471',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.3.1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.3.1.1\",\"date\":\"2024-05-14T00:00:00\",\"orderUpdateTime\":\"2024-05-13T17:17:46\",\"orderId\":\"bcf78fbc-113b-11ef-8f8d-d92a44d56471\"}','2024-05-13 17:17:46.000',NULL,'2024-05-13 17:17:46.000','2024-05-13 15:17:49.000','2024-05-13 17:17:49.000'),('f7a50be4-a6c8-4e99-8a5e-b63e5c936eed',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.6.1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"validated\",\"title\":\"Commande 1.6.1.1\",\"date\":\"2024-05-19T00:00:00+02:00\",\"orderUpdateTime\":\"2024-05-17T12:17:58+02:00\",\"orderId\":\"1f4743e1-1436-11ef-8f1b-d8242b6da0dc\"}','2024-05-17 12:17:59.000',NULL,'2024-05-17 12:17:59.000','2024-05-17 10:17:59.000','2024-05-17 12:17:59.000'),('f924ab7b-1dca-11ef-8e10-d517f279883e',15,'6f667799-1dc9-11ef-8e10-d517f279883e','f924ab7b-1dca-11ef-8e10-d517f279883e',NULL,'envoi d\'un message hors commande et hors fil de discussion','2024-05-29 16:51:47.000',NULL,'2024-05-29 16:51:47.000','2024-05-29 14:51:47.000','2024-05-29 16:51:47.000'),('fd3a7c7d-1437-11ef-8f1b-d8242b6da0dc',3,'1fed07ce-0867-11ef-8ff6-da2f5a35fe58','Commande 1.6.3.1',NULL,'message avec pj avant reponse web','2024-05-17 12:26:57.600',NULL,'2024-05-17 12:26:57.600','2024-05-17 10:26:57.600','2024-05-17 12:26:57.610');
/*!40000 ALTER TABLE `SentMessage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SentOrderNotification`
--

DROP TABLE IF EXISTS `SentOrderNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SentOrderNotification` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `recipientId` varchar(36) DEFAULT NULL,
  `rescueData` text DEFAULT NULL,
  `deliveryDate` datetime(3) DEFAULT NULL,
  `event` enum('EDITED','VALIDATED','CANCELLED') NOT NULL DEFAULT 'EDITED',
  `unread` tinyint(1) NOT NULL DEFAULT 1,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `orderId` (`orderId`),
  KEY `recipientId` (`recipientId`),
  CONSTRAINT `SentOrderNotification_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `SentOrderNotification_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `ProstheticOrder` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `SentOrderNotification_ibfk_3` FOREIGN KEY (`recipientId`) REFERENCES `Contact` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SentOrderNotification`
--

LOCK TABLES `SentOrderNotification` WRITE;
/*!40000 ALTER TABLE `SentOrderNotification` DISABLE KEYS */;
INSERT INTO `SentOrderNotification` VALUES ('1ec62ecb-1f1c-425a-a4f2-830764849d8a',3,'58e7cf64-0861-11ef-8ff6-da2f5a35fe58','b84baf20-3ca6-4653-8341-ac721a404258','{\"recipientDisplayName\":\"client leger\",\"patientDisplayID\":\"00c2d95b-06ed-11ef-90c8-dd3986f53a42\",\"orderTitle\":\"Commande 1.1.2.1\"}','2024-05-04 00:00:00.000','EDITED',0,'2024-05-02 11:34:29.000',NULL,'2024-05-02 09:34:36.616','2024-05-02 11:34:36.626'),('299391b6-c674-4785-92f2-910d75135438',3,'d9e2b705-1436-11ef-8f1b-d8242b6da0dc','b84baf20-3ca6-4653-8341-ac721a404258','{\"recipientDisplayName\":\"client leger\",\"patientDisplayID\":\"16032a0e-1436-11ef-8f1b-d8242b6da0dc\",\"orderTitle\":\"Commande 1.6.2.1\"}','2024-05-19 00:00:00.000','EDITED',0,'2024-05-17 12:19:47.000',NULL,'2024-05-17 12:57:01.901','2024-05-17 14:57:01.903'),('29cae408-1dab-47be-8d3a-ddb30f70cf84',3,'47d6e672-086d-11ef-8ff6-da2f5a35fe58','b84baf20-3ca6-4653-8341-ac721a404258','{\"recipientDisplayName\":\"client leger\",\"patientDisplayID\":\"00c2d95b-06ed-11ef-90c8-dd3986f53a42\",\"orderTitle\":\"Commande 1.1.5.1\"}','2024-05-03 00:00:00.000','CANCELLED',0,'2024-05-02 12:19:34.000',NULL,'2024-05-02 10:19:59.000','2024-05-02 12:19:59.000'),('311db9f6-3298-4915-ad86-8d8eac58c9bb',3,'0e416c0d-0947-11ef-8f65-d9283bb1c6cd','b84baf20-3ca6-4653-8341-ac721a404258','{\"recipientDisplayName\":\"client leger\",\"patientDisplayID\":\"21d1572e-0943-11ef-8f65-d9283bb1c6cd\",\"orderTitle\":\"Commande 1.2.1.1\"}','2024-05-05 00:00:00.000','EDITED',0,'2024-05-03 15:00:05.000',NULL,'2024-05-03 13:06:12.000','2024-05-03 15:06:12.000'),('4fadcbf5-7e31-419c-a0cc-2186409f6da5',3,'d963f904-1437-11ef-8f1b-d8242b6da0dc','b84baf20-3ca6-4653-8341-ac721a404258','{\"recipientDisplayName\":\"client leger\",\"patientDisplayID\":\"16032a0e-1436-11ef-8f1b-d8242b6da0dc\",\"orderTitle\":\"Commande 1.6.3.1\"}','2024-05-19 00:00:00.000','EDITED',0,'2024-05-17 12:27:14.000',NULL,'2024-05-17 12:57:01.873','2024-05-17 14:57:01.875'),('6bda340e-3186-4a4b-bbb4-fe77bb5a5aa1',3,'a0015ffe-0868-11ef-8ff6-da2f5a35fe58','b84baf20-3ca6-4653-8341-ac721a404258','{\"recipientDisplayName\":\"client leger\",\"patientDisplayID\":\"00c2d95b-06ed-11ef-90c8-dd3986f53a42\",\"orderTitle\":\"Commande 1.1.3.1\"}','2024-05-03 00:00:00.000','VALIDATED',0,'2024-05-02 11:49:46.000',NULL,'2024-05-02 10:09:03.394','2024-05-02 12:09:03.404'),('a2194066-7888-4095-bd4c-a2d1a2540a6e',15,'3a968bff-1dd2-11ef-8f99-d92a46e09137','ed09bdd8-1331-4c59-b52b-b0000e585e7d','{\"recipientDisplayName\":\"demo20 demo\",\"patientDisplayID\":\"de66fe79-1dd1-11ef-8f99-d92a46e09137\",\"orderTitle\":\"Commande 2.3.2.1\"}','2024-05-30 00:00:00.000','VALIDATED',1,'2024-05-29 17:55:20.000',NULL,'2024-05-29 15:55:20.000','2024-05-29 17:55:20.000'),('b68e17f8-7bab-4ee9-a9b7-9cdd11ca759a',3,'bcf78fbc-113b-11ef-8f8d-d92a44d56471','b84baf20-3ca6-4653-8341-ac721a404258','{\"recipientDisplayName\":\"client leger\",\"patientDisplayID\":\"4ce59675-1136-11ef-8f8d-d92a44d56471\",\"orderTitle\":\"Commande 1.3.1.1\"}','2024-05-15 00:00:00.000','EDITED',0,'2024-05-13 17:20:37.000',NULL,'2024-05-17 12:57:02.000','2024-05-17 14:57:02.000'),('e7a54438-f38a-49e1-9620-dbc6dad3e64b',3,'1f4743e1-1436-11ef-8f1b-d8242b6da0dc','b84baf20-3ca6-4653-8341-ac721a404258','{\"recipientDisplayName\":\"client leger\",\"patientDisplayID\":\"16032a0e-1436-11ef-8f1b-d8242b6da0dc\",\"orderTitle\":\"Commande 1.6.1.1\"}','2024-05-19 00:00:00.000','EDITED',0,'2024-05-17 12:17:39.000',NULL,'2024-05-17 12:57:02.000','2024-05-17 14:57:02.000'),('f36e032c-a34b-48fa-8391-783b97e1c1be',3,'4dd5f101-06ed-11ef-90c8-dd3986f53a42','8e4a4b16-c567-4bf8-a434-976b627a70ca','{\"recipientDisplayName\":\"Biotech-Dental LABORATOIRE\",\"patientDisplayID\":\"00c2d95b-06ed-11ef-90c8-dd3986f53a42\",\"orderTitle\":\"Commande 1.1.1.1\"}','2024-06-14 00:00:00.000','EDITED',0,'2024-04-30 14:32:47.000',NULL,'2024-05-02 09:12:54.449','2024-05-02 11:12:54.458');
/*!40000 ALTER TABLE `SentOrderNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Session`
--

DROP TABLE IF EXISTS `Session`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Session` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL,
  `actId` varchar(36) NOT NULL,
  `displayId` mediumint(8) unsigned DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT 0,
  `comments` text DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `actId` (`actId`),
  CONSTRAINT `Session_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `Session_ibfk_2` FOREIGN KEY (`actId`) REFERENCES `Act` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Session`
--

LOCK TABLES `Session` WRITE;
/*!40000 ALTER TABLE `Session` DISABLE KEYS */;
INSERT INTO `Session` VALUES ('0166be38-0952-11ef-8f65-d9283bb1c6cd',3,'01654717-0952-11ef-8f65-d9283bb1c6cd',1,0,'','2024-05-03 15:35:29.368',NULL,'2024-05-03 15:35:29.368','2024-05-03 13:35:29.368','2024-05-03 15:35:29.409'),('17719f33-11fa-11ef-8fe1-da2e5522abf3',3,'176ffa22-11fa-11ef-8fe1-da2e5522abf3',1,0,'','2024-05-14 15:58:50.459',NULL,'2024-05-14 15:58:50.459','2024-05-14 13:58:50.459','2024-05-14 15:58:50.461'),('1f46ec8a-1436-11ef-8f1b-d8242b6da0dc',3,'1f4547de-1436-11ef-8f1b-d8242b6da0dc',1,0,'','2024-05-17 12:13:35.730',NULL,'2024-05-17 12:13:35.731','2024-05-17 10:13:35.731','2024-05-17 12:13:35.732'),('1fcf8a88-086d-11ef-8ff6-da2f5a35fe58',3,'1fcf39f6-086d-11ef-8ff6-da2f5a35fe58',1,0,'','2024-05-02 12:17:04.992',NULL,'2024-05-02 12:17:04.993','2024-05-02 10:17:59.596','2024-05-02 12:17:59.625'),('233c76c4-113d-11ef-8f8d-d92a44d56471',3,'233ae18e-113d-11ef-8f8d-d92a44d56471',1,0,'','2024-05-13 17:26:15.361',NULL,'2024-05-13 17:26:15.362','2024-05-13 15:26:15.362','2024-05-13 17:26:15.364'),('2a54d83c-11cf-11ef-8f95-d92a45dc80ec',3,'2a532631-11cf-11ef-8f95-d92a45dc80ec',1,0,'','2024-05-14 10:51:33.788',NULL,'2024-05-14 10:51:33.788','2024-05-14 08:51:33.788','2024-05-14 10:51:33.790'),('33ac9194-0943-11ef-8f65-d9283bb1c6cd',3,'33ac516e-0943-11ef-8f65-d9283bb1c6cd',1,0,'','2024-05-03 13:49:31.260',NULL,'2024-05-03 13:49:31.261','2024-05-03 11:50:43.528','2024-05-03 13:50:43.565'),('3a962c85-1dd2-11ef-8f99-d92a46e09137',15,'3a94919f-1dd2-11ef-8f99-d92a46e09137',1,0,'','2024-05-29 17:43:43.503',NULL,'2024-05-29 17:43:43.503','2024-05-29 15:43:43.503','2024-05-29 17:43:43.505'),('419e71c5-1469-11ef-8f1b-d8242b6da0dc',3,'419ce9d8-1469-11ef-8f1b-d8242b6da0dc',1,0,'','2024-05-17 18:19:37.679',NULL,'2024-05-17 18:19:37.680','2024-05-17 16:19:37.680','2024-05-17 18:19:37.682'),('42c52eba-0958-11ef-8f65-d9283bb1c6cd',3,'42c42325-0958-11ef-8f65-d9283bb1c6cd',1,0,'','2024-05-03 16:20:16.019','2024-05-03 16:20:32.410','2024-05-03 16:20:16.020','2024-05-03 14:20:32.410','2024-05-03 16:20:32.412'),('45464b9d-0951-11ef-8f65-d9283bb1c6cd',3,'4545f685-0951-11ef-8f65-d9283bb1c6cd',1,0,'','2024-05-03 15:30:13.743',NULL,'2024-05-03 15:30:13.744','2024-05-03 13:31:31.146','2024-05-03 15:31:31.187'),('4dd586c4-06ed-11ef-90c8-dd3986f53a42',3,'4dd3e575-06ed-11ef-90c8-dd3986f53a42',1,0,'','2024-04-30 14:29:35.463',NULL,'2024-04-30 14:29:35.463','2024-04-30 12:29:35.463','2024-04-30 14:29:35.465'),('4fc3d0e6-0952-11ef-8f65-d9283bb1c6cd',3,'4fc2347a-0952-11ef-8f65-d9283bb1c6cd',1,0,'','2024-05-03 15:37:40.840',NULL,'2024-05-03 15:37:40.840','2024-05-03 13:37:40.840','2024-05-03 15:37:40.842'),('574ac047-146a-11ef-8f1b-d8242b6da0dc',3,'5748a11c-146a-11ef-8f1b-d8242b6da0dc',1,0,'','2024-05-17 18:27:23.538',NULL,'2024-05-17 18:27:23.538','2024-05-17 16:27:23.538','2024-05-17 18:27:23.540'),('58e77d50-0861-11ef-8ff6-da2f5a35fe58',3,'58e7015d-0861-11ef-8ff6-da2f5a35fe58',1,0,'','2024-05-02 10:52:46.819',NULL,'2024-05-02 10:52:46.819','2024-05-02 08:52:46.819','2024-05-02 10:52:46.821'),('67fdc886-0953-11ef-8f65-d9283bb1c6cd',3,'67fc2b93-0953-11ef-8f65-d9283bb1c6cd',1,0,'','2024-05-03 15:45:30.982',NULL,'2024-05-03 15:45:30.983','2024-05-03 13:45:30.982','2024-05-03 15:45:30.984'),('6db0c544-0950-11ef-8f65-d9283bb1c6cd',3,'6daf4255-0950-11ef-8f65-d9283bb1c6cd',1,0,'','2024-05-03 15:24:12.053',NULL,'2024-05-03 15:24:12.055','2024-05-03 13:24:12.055','2024-05-03 15:24:12.102'),('71b9f254-0958-11ef-8f65-d9283bb1c6cd',3,'71b85037-0958-11ef-8f65-d9283bb1c6cd',1,0,'','2024-05-03 16:21:34.798',NULL,'2024-05-03 16:21:34.799','2024-05-03 14:21:34.798','2024-05-03 16:21:34.800'),('7d7bdba5-094f-11ef-8f65-d9283bb1c6cd',6,'7d7b190c-094f-11ef-8f65-d9283bb1c6cd',1,0,'','2024-05-03 15:17:29.053',NULL,'2024-05-03 15:17:29.054','2024-05-03 13:19:13.928','2024-05-03 15:19:13.963'),('89463d55-1cf1-11ef-8f68-d9283cb4d201',6,'894496db-1cf1-11ef-8f68-d9283cb4d201',1,0,'','2024-05-28 14:55:18.755',NULL,'2024-05-28 14:55:18.755','2024-05-28 12:55:18.755','2024-05-28 14:55:18.757'),('8afdb05b-146a-11ef-8f1b-d8242b6da0dc',3,'8afd42f5-146a-11ef-8f1b-d8242b6da0dc',1,0,'','2024-05-17 18:28:50.274',NULL,'2024-05-17 18:28:50.275','2024-05-17 16:28:50.275','2024-05-17 18:28:50.276'),('8c590d83-146d-11ef-8f1b-d8242b6da0dc',3,'8c5787a0-146d-11ef-8f1b-d8242b6da0dc',1,0,'','2024-05-17 18:50:21.041',NULL,'2024-05-17 18:50:21.041','2024-05-17 16:50:21.041','2024-05-17 18:50:21.087'),('a000fd43-0868-11ef-8ff6-da2f5a35fe58',3,'9fff6be0-0868-11ef-8ff6-da2f5a35fe58',1,0,'','2024-05-02 11:44:52.581',NULL,'2024-05-02 11:44:52.582','2024-05-02 09:44:52.582','2024-05-02 11:44:52.583'),('b1d043a8-1749-11ef-8f86-d92942cf49fd',3,'b1ce9a22-1749-11ef-8f86-d92942cf49fd',1,0,'','2024-05-21 10:11:15.504',NULL,'2024-05-21 10:11:15.505','2024-05-21 08:11:15.505','2024-05-21 10:11:15.506'),('b84f566f-1f2c-11ef-8f88-d92a43d1501c',3,'b84ee75e-1f2c-11ef-8f88-d92a43d1501c',1,0,'','2024-05-31 11:04:00.300',NULL,'2024-05-31 11:04:00.301','2024-05-31 09:04:00.301','2024-05-31 11:04:00.302'),('bcf73039-113b-11ef-8f8d-d92a44d56471',3,'bcf58202-113b-11ef-8f8d-d92a44d56471',1,0,'','2024-05-13 17:16:14.283',NULL,'2024-05-13 17:16:14.283','2024-05-13 15:16:14.283','2024-05-13 17:16:14.285'),('c6ed23a8-1dc9-11ef-8f99-d92a46e09137',14,'c6ecdf7f-1dc9-11ef-8f99-d92a46e09137',1,0,'','2024-05-29 16:43:13.483',NULL,'2024-05-29 16:43:13.484','2024-05-29 14:43:13.484','2024-05-29 16:43:13.630'),('d9639405-1437-11ef-8f1b-d8242b6da0dc',3,'d961f6f4-1437-11ef-8f1b-d8242b6da0dc',1,0,'','2024-05-17 12:25:57.471',NULL,'2024-05-17 12:25:57.471','2024-05-17 10:25:57.471','2024-05-17 12:25:57.473'),('d9e25949-1436-11ef-8f1b-d8242b6da0dc',3,'d9e0b5cb-1436-11ef-8f1b-d8242b6da0dc',1,0,'','2024-05-17 12:18:48.805',NULL,'2024-05-17 12:18:48.805','2024-05-17 10:18:48.805','2024-05-17 12:18:48.807'),('dd5fc380-19c9-11ef-8fee-da2f582eded0',3,'dd5e304f-19c9-11ef-8fee-da2f582eded0',1,0,'','2024-05-24 14:33:46.493',NULL,'2024-05-24 14:33:46.495','2024-05-24 12:33:46.495','2024-05-28 16:35:03.987'),('df827803-19cb-11ef-8fee-da2f582eded0',3,'df80ed21-19cb-11ef-8fee-da2f582eded0',1,0,'','2024-05-24 14:48:09.070',NULL,'2024-05-24 14:48:09.070','2024-05-24 12:48:09.070','2024-05-28 16:35:03.987'),('ec1e3d64-1dd1-11ef-8f99-d92a46e09137',15,'ec1c9685-1dd1-11ef-8f99-d92a46e09137',1,0,'','2024-05-29 17:41:31.855',NULL,'2024-05-29 17:41:31.855','2024-05-29 15:41:31.855','2024-05-29 17:41:31.857'),('f073b964-144c-11ef-8f1b-d8242b6da0dc',3,'f0721624-144c-11ef-8f1b-d8242b6da0dc',1,0,'','2024-05-17 14:56:55.596',NULL,'2024-05-17 14:56:55.596','2024-05-17 12:56:55.596','2024-05-17 14:56:55.598'),('f5ac369c-1824-11ef-8f8e-d92a44d6667d',3,'f5aa8d87-1824-11ef-8f8e-d92a44d6667d',1,0,'','2024-05-22 12:20:49.136',NULL,'2024-05-22 12:20:49.137','2024-05-22 10:20:49.137','2024-05-22 12:20:49.139');
/*!40000 ALTER TABLE `Session` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SmilersOrder`
--

DROP TABLE IF EXISTS `SmilersOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SmilersOrder` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `actId` varchar(36) NOT NULL,
  `title` varchar(64) DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT 0,
  `createdById` varchar(36) DEFAULT NULL,
  `updatedById` varchar(36) DEFAULT NULL,
  `displayId` mediumint(8) unsigned DEFAULT NULL,
  `json` text NOT NULL,
  `metadata` text NOT NULL,
  `status` enum('NOT_SENT','WAITING_WOW_API','SENDING_WOW_API','SENDING_SMILERS_API','SENT','CANCELLED','DELIVERY') NOT NULL DEFAULT 'NOT_SENT',
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `actId` (`actId`),
  CONSTRAINT `SmilersOrder_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `SmilersOrder_ibfk_2` FOREIGN KEY (`actId`) REFERENCES `Act` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SmilersOrder`
--

LOCK TABLES `SmilersOrder` WRITE;
/*!40000 ALTER TABLE `SmilersOrder` DISABLE KEYS */;
/*!40000 ALTER TABLE `SmilersOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SmilersOrderFile`
--

DROP TABLE IF EXISTS `SmilersOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SmilersOrderFile` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('FORM','SCAN') NOT NULL,
  PRIMARY KEY (`orderId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `SmilersOrderFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `SmilersOrderFile_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `SmilersOrder` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `SmilersOrderFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SmilersOrderFile`
--

LOCK TABLES `SmilersOrderFile` WRITE;
/*!40000 ALTER TABLE `SmilersOrderFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `SmilersOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SyncInfo`
--

DROP TABLE IF EXISTS `SyncInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SyncInfo` (
  `id` mediumint(8) unsigned NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `directLastRetrieved` text DEFAULT NULL COMMENT 'Direct last retrieved date values as json',
  `autoLastRetrieved` text DEFAULT NULL COMMENT 'Auto last retrieved date values as json',
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  PRIMARY KEY (`id`,`ownerId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SyncInfo`
--

LOCK TABLES `SyncInfo` WRITE;
/*!40000 ALTER TABLE `SyncInfo` DISABLE KEYS */;
INSERT INTO `SyncInfo` VALUES (1,1,NULL,NULL,'2024-04-30 12:26:31.656'),(1,2,NULL,NULL,'2024-04-30 12:34:01.223'),(1,3,NULL,'{\"contactsAutoLastRetrieved\":\"2024-05-29 16:57:57\",\"discussionsAutoLastRetrieved\":\"\",\"messagesAutoLastRetrieved\":\"2024-05-31 11:00:21\",\"notificationsAutoLastRetrieved\":\"2024-05-31 11:02:49\",\"prostheticOrdersAutoLastRetrieved\":\"2024-05-17 18:19:54\"}','2024-05-31 09:07:37.642'),(1,4,NULL,NULL,'2024-05-02 09:30:49.264'),(1,5,NULL,NULL,'2024-05-03 14:24:52.989'),(1,6,NULL,'{\"contactsAutoLastRetrieved\":\"2024-05-28 14:51:11\",\"discussionsAutoLastRetrieved\":\"2024-05-28 15:10:43\",\"messagesAutoLastRetrieved\":\"2024-05-28 15:10:43\",\"notificationsAutoLastRetrieved\":\"2024-05-28 14:42:00\",\"prostheticOrdersAutoLastRetrieved\":\"2024-05-28 14:58:06\"}','2024-05-28 13:10:45.194'),(1,13,NULL,NULL,'2024-05-28 14:55:40.031'),(1,14,NULL,'{\"contactsAutoLastRetrieved\":\"2024-05-29 16:57:55\",\"discussionsAutoLastRetrieved\":\"2024-05-29 17:02:45\",\"messagesAutoLastRetrieved\":\"2024-05-29 17:03:08\",\"notificationsAutoLastRetrieved\":\"2024-05-29 16:58:50\"}','2024-05-29 15:03:10.201'),(1,15,'{\"assistantsDirectLastRetrieved\":\"2024-05-29 17:18:57\",\"patientsDirectLastRetrieved\":\"2024-05-29 16:23:33\"}','{\"contactsAutoLastRetrieved\":\"2024-05-29 16:39:54\",\"discussionsAutoLastRetrieved\":\"2024-05-29 17:58:41\",\"messagesAutoLastRetrieved\":\"2024-05-29 17:58:41\",\"notificationsAutoLastRetrieved\":\"2024-05-29 17:55:20\",\"prostheticOrdersAutoLastRetrieved\":\"2024-05-29 17:55:20\"}','2024-05-29 16:05:51.443');
/*!40000 ALTER TABLE `SyncInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SystemNotification`
--

DROP TABLE IF EXISTS `SystemNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SystemNotification` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `event` enum('NO_CONNECTION_FOR_X_DAYS') NOT NULL DEFAULT 'NO_CONNECTION_FOR_X_DAYS',
  `unread` tinyint(1) NOT NULL DEFAULT 1,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  CONSTRAINT `SystemNotification_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SystemNotification`
--

LOCK TABLES `SystemNotification` WRITE;
/*!40000 ALTER TABLE `SystemNotification` DISABLE KEYS */;
/*!40000 ALTER TABLE `SystemNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Token`
--

DROP TABLE IF EXISTS `Token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Token` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `credentialsId` varchar(36) DEFAULT NULL,
  `token` char(200) NOT NULL,
  `context` char(40) DEFAULT NULL,
  `device` char(255) DEFAULT NULL,
  `created` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `token` (`token`),
  KEY `credentialsId` (`credentialsId`),
  CONSTRAINT `Token_ibfk_1` FOREIGN KEY (`credentialsId`) REFERENCES `Credentials` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Token`
--

LOCK TABLES `Token` WRITE;
/*!40000 ALTER TABLE `Token` DISABLE KEYS */;
INSERT INTO `Token` VALUES ('02535522-11cf-11ef-8f95-d92a45dc80ec',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','76b5fd9b2f651374d0460596afb2e5a84e65789e','software','CondorScan','2024-05-14 10:50:26.669','2024-05-14 08:50:26.669'),('03a99e22-11fa-11ef-8fe1-da2e5522abf3',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','339ac79a96d995cb457c3ca236359361e90d16ee','software','CondorScan','2024-05-14 15:58:17.271','2024-05-14 13:58:17.272'),('0a7f230d-1822-11ef-8f8e-d92a44d6667d',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','1ccaaceea7ab7b7a5b80763a07cd7915c1c5224d','software','CondorScan','2024-05-22 11:59:55.583','2024-05-22 09:59:55.583'),('0b20578f-144d-11ef-8f1b-d8242b6da0dc',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','912fb85a8128bf369320d680b47d54e5d8fa98c1','software','CondorScan','2024-05-17 14:57:40.348','2024-05-17 12:57:40.348'),('0cbc16c2-0943-11ef-8f65-d9283bb1c6cd',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','319e205faa3db035a58ec98e0b3809763bfe19ff','software','CondorScan','2024-05-03 13:48:25.931','2024-05-03 11:48:25.931'),('0deb2510-1436-11ef-8f1b-d8242b6da0dc',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','f9d16124282685bd182017732abbb458a186a4ba','software','CondorScan','2024-05-17 12:13:06.607','2024-05-17 10:13:06.608'),('0ecd5fef-06ed-11ef-90c8-dd3986f53a42',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','2e3122c91b5551c78258347271a1096525a350f6','software','CondorScan','2024-04-30 14:27:49.713','2024-04-30 12:27:49.713'),('198f06f4-094b-11ef-8f65-d9283bb1c6cd',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','61e71716eae0ecee6bab69d1eed8ae954731b07d','software','CondorScan','2024-05-03 14:46:03.420','2024-05-03 12:46:03.420'),('1b8f25c4-1822-11ef-8f8e-d92a44d6667d',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','debb2c4b80046bb52a5e13b1757426f5d4d11235','software','CondorScan','2024-05-22 12:00:24.209','2024-05-22 10:00:24.209'),('25758d95-0946-11ef-8f65-d9283bb1c6cd',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','078c02f9b5650e73126f1b4c6bd42d2e2f2b9372','software','CondorScan','2024-05-03 14:10:35.902','2024-05-03 12:10:35.902'),('2744c352-0868-11ef-8ff6-da2f5a35fe58',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','3e8f53fbacd53dd74e3f9020bf3c6b9733bb9d13','software','CondorScan','2024-05-02 11:41:30.021','2024-05-02 09:41:30.021'),('29d303ac-1135-11ef-8f8d-d92a44d56471',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','76cd40886c8a518c849d4bca537f6bbfc18ffc42','software','CondorScan','2024-05-13 16:29:10.440','2024-05-13 14:29:10.441'),('2edf4f36-1f2d-11ef-8f88-d92a43d1501c',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','6cf91f591513dded90f1af31ba18204c07708254','software','CondorScan','2024-05-31 11:07:19.215','2024-05-31 09:07:19.215'),('33436f89-1f2c-11ef-8f88-d92a43d1501c',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','0f38841b7e0c5b1ca9192be853d495ffe2738313','software','CondorScan','2024-05-31 11:00:17.085','2024-05-31 09:00:17.085'),('34480693-0956-11ef-8f65-d9283bb1c6cd',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','fc5877b80d0de0fdee10dde9abbaf8c678e6edc9','software','CondorScan','2024-05-03 16:05:32.717','2024-05-03 14:05:32.717'),('41abd643-06ed-11ef-90c8-dd3986f53a42',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','a26ff196055f14739be529a497e16249e58ef33a','software','CondorScan','2024-04-30 14:29:15.057','2024-04-30 12:29:15.057'),('49ab4a4c-1dc9-11ef-8f99-d92a46e09137',14,'466cbc9a-1ff6-4044-8fba-678393bc0252','ff562b41d9fd5a15d89b107f218f97b7446d3270','software','CondorScan','2024-05-29 16:39:43.336','2024-05-29 14:39:43.336'),('49bc1f61-1cfe-11ef-8f68-d9283cb4d201',6,'afdaf315-9060-4a46-b958-9a7c00ce122c','a3929d7492dcf4f095c4d27d040b26d4ca083860','software','CondorScan','2024-05-28 16:26:35.611','2024-05-28 14:26:35.611'),('4b19d5d5-0861-11ef-8ff6-da2f5a35fe58',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','ba8aa9b4504b70dbfafc6e92e7559d4bc2ffee81','software','CondorScan','2024-05-02 10:52:23.660','2024-05-02 08:52:23.661'),('4ba90e64-1843-11ef-8f8e-d92a44d6667d',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','37e68dd2abd722c86c1ac90d42d955bf2dea2722','software','CondorScan','2024-05-22 15:57:58.302','2024-05-22 13:57:58.302'),('4c93b5ee-1cf1-11ef-8f68-d9283cb4d201',6,'99cf21e2-68af-4565-bb5a-178437f43d80','1c35390410fb42d7051e9c2485e873693bb36efc','software','CondorScan','2024-05-28 14:53:36.921','2024-05-28 12:53:36.922'),('5033e697-1dd5-11ef-8f99-d92a46e09137',15,'bd241e23-6d6c-4ee5-82d6-187dfde89f13','1efc653b63b5df52ebe46f8a47b730ed88aec600','software','CondorScan','2024-05-29 18:05:48.259','2024-05-29 16:05:48.259'),('5a432ab3-094f-11ef-8f65-d9283bb1c6cd',6,'afdaf315-9060-4a46-b958-9a7c00ce122c','530b90be3232abfca29acbd4a8fa6c3ce93328c1','software','CondorScan','2024-05-03 15:16:29.961','2024-05-03 13:16:29.962'),('5b7e17ef-0950-11ef-8f65-d9283bb1c6cd',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','36c5b2be6fd3b51335d385b510c2406b23eb1398','software','CondorScan','2024-05-03 15:23:41.522','2024-05-03 13:23:41.522'),('61d70a9b-0956-11ef-8f65-d9283bb1c6cd',6,'afdaf315-9060-4a46-b958-9a7c00ce122c','31c8d8e47604df7b429eb6f36f53db1ee5f5d61b','software','CondorScan','2024-05-03 16:06:49.152','2024-05-03 14:06:49.152'),('62c79546-1da5-11ef-8f99-d92a46e09137',14,'466cbc9a-1ff6-4044-8fba-678393bc0252','652b2e8ba46f9f9ab39e04c13fa404de9bf03f50','software','CondorScan','2024-05-29 12:22:43.573','2024-05-29 10:22:45.081'),('6b14e1ca-0883-11ef-8ff6-da2f5a35fe58',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','812b5d8f779bb420a9164190490dc338ee35d5d6','software','CondorScan','2024-05-02 14:56:40.204','2024-05-02 12:56:40.204'),('6c2a0974-1749-11ef-8f86-d92942cf49fd',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','805acf687f294e6303ed350fc9b18e57e9e9c31e','software','CondorScan','2024-05-21 10:09:18.652','2024-05-21 08:09:18.652'),('6fe50e59-095b-11ef-8f65-d9283bb1c6cd',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','ff23fcf21334a2f649d086403c2439f02428ad6e','software','CondorScan','2024-05-03 16:43:00.215','2024-05-03 14:43:00.215'),('74ccfbb9-1dcd-11ef-8f99-d92a46e09137',15,'bd241e23-6d6c-4ee5-82d6-187dfde89f13','ee828401a715786c1654092ba00cb95b037201e0','software','CondorScan','2024-05-29 17:09:33.686','2024-05-29 15:09:33.686'),('780c55ad-11fa-11ef-8f59-d92739a69701',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','87310d6084592485665a8790810945e16b815cd4','software','CondorScan','2024-05-14 16:01:32.534','2024-05-14 14:01:32.534'),('78b888b6-1cff-11ef-8f68-d9283cb4d201',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','1d243e6314fa8fe6e7341ff2ec9e2cb45e3f81e9','software','CondorScan','2024-05-28 16:35:03.937','2024-05-28 14:35:03.937'),('79cd0a6f-1cf1-11ef-8f68-d9283cb4d201',6,'afdaf315-9060-4a46-b958-9a7c00ce122c','25ea181b04876388206a860892ac9a3c8b04db06','software','CondorScan','2024-05-28 14:54:52.795','2024-05-28 12:54:52.795'),('79e7a145-1dcf-11ef-8f99-d92a46e09137',15,'bd241e23-6d6c-4ee5-82d6-187dfde89f13','ceec2a4b5b4bfa3e66ca17a052b04b5f0185731f','software','CondorScan','2024-05-29 17:24:01.243','2024-05-29 15:24:01.243'),('7aca800a-0883-11ef-8ff6-da2f5a35fe58',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','0399e43df453c282ba98daed446ea269e7467332','software','CondorScan','2024-05-02 14:57:06.560','2024-05-02 12:57:06.560'),('7b3cb33d-094f-11ef-8f65-d9283bb1c6cd',6,'afdaf315-9060-4a46-b958-9a7c00ce122c','e36bb1f35bf86dba27f11dd97e31716674745cf7','software','CondorScan','2024-05-03 15:17:25.284','2024-05-03 13:17:25.284'),('7bdb532a-0955-11ef-8f65-d9283bb1c6cd',6,'afdaf315-9060-4a46-b958-9a7c00ce122c','d851ed9991dc38591db50ef3b3ea2f63c0d7d8d6','software','CondorScan','2024-05-03 16:00:23.304','2024-05-03 14:00:23.304'),('7c791558-113b-11ef-8f8d-d92a44d56471',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','4392847a089a1bbbb922387735a488243affb9e2','software','CondorScan','2024-05-13 17:14:26.082','2024-05-13 15:14:26.082'),('7f7b7e50-0866-11ef-8ff6-da2f5a35fe58',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','94454303a9b54b2f51bb73e0f4d9946a8158e224','software','CondorScan','2024-05-02 11:29:39.026','2024-05-02 09:29:39.026'),('82cd68d9-0956-11ef-8f65-d9283bb1c6cd',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','1eb654e9b245219864ccf42f0c290d24d9356265','software','CondorScan','2024-05-03 16:07:44.453','2024-05-03 14:07:44.453'),('87b73089-1831-11ef-8f8e-d92a44d6667d',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','0ebbac6348d6cdbd9a49367f16ec927ce6ad409f','software','CondorScan','2024-05-22 13:50:48.116','2024-05-22 11:50:48.116'),('8955b3ba-1cf9-11ef-8f68-d9283cb4d201',6,'afdaf315-9060-4a46-b958-9a7c00ce122c','fc38f774ae9be42d49ccbe48f963a7fdb99deddc','software','CondorScan','2024-05-28 15:52:34.830','2024-05-28 13:52:34.839'),('8b6fb4d4-11fd-11ef-8f0c-d823285f66e1',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','548ab954c638d12b57c2eac485b60973f8d635f2','software','CondorScan','2024-05-14 16:23:33.552','2024-05-14 14:23:33.552'),('920c23f4-0955-11ef-8f65-d9283bb1c6cd',6,'afdaf315-9060-4a46-b958-9a7c00ce122c','0b5157bfdef067259ddcaa6e097675fd4dcb7d79','software','CondorScan','2024-05-03 16:01:00.534','2024-05-03 14:01:00.534'),('923b266f-1cef-11ef-8f68-d9283cb4d201',6,'afdaf315-9060-4a46-b958-9a7c00ce122c','cc7c91263b7bda1136e8ab9ad257b66494852ee7','software','CondorScan','2024-05-28 14:41:14.788','2024-05-28 12:41:14.788'),('93bd5ab6-0942-11ef-8f65-d9283bb1c6cd',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','6ff29937e6abf7bd9ddb1701b0191863a0036fcd','software','CondorScan','2024-05-03 13:45:02.935','2024-05-03 11:45:02.935'),('99640223-1466-11ef-8f1b-d8242b6da0dc',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','958061eb40ec004e47e4c8dcbc6cdde251971f48','software','CondorScan','2024-05-17 18:00:36.446','2024-05-17 16:00:36.446'),('9e9ca210-1770-11ef-8f86-d92942cf49fd',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','f33c8a5a46ecdc725125221c1cde0eb20b3fb146','software','CondorScan','2024-05-21 14:49:53.661','2024-05-21 12:49:53.661'),('a339cbf3-1dd2-11ef-8f99-d92a46e09137',15,'bd241e23-6d6c-4ee5-82d6-187dfde89f13','c0fa14bf00169f0c7f67a3b740abbdf4630132bd','software','CondorScan','2024-05-29 17:46:39.058','2024-05-29 15:46:39.058'),('a5a6f434-1dc9-11ef-8f99-d92a46e09137',14,'466cbc9a-1ff6-4044-8fba-678393bc0252','d56c4d023578b81c88f7cc58a1570fcec0aaffa7','software','CondorScan','2024-05-29 16:42:17.658','2024-05-29 14:42:17.658'),('b405824a-1dcc-11ef-8f99-d92a46e09137',15,'bd241e23-6d6c-4ee5-82d6-187dfde89f13','d35a24df822d45dc0a3f8f8d5f3c117856a642a5','software','CondorScan','2024-05-29 17:04:10.256','2024-05-29 15:04:10.524'),('b87309b9-11c9-11ef-9047-db336b7f3eb8',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','4e73a0af7672f909cffeeb3da53326d4d9c3d042','software','CondorScan','2024-05-14 10:12:35.242','2024-05-14 08:12:35.242'),('b9f74d89-0955-11ef-8f65-d9283bb1c6cd',6,'afdaf315-9060-4a46-b958-9a7c00ce122c','c3e5a943f55b971f9c98daf000b5abe7c32e8a69','software','CondorScan','2024-05-03 16:02:07.506','2024-05-03 14:02:07.506'),('bd5add03-1dc5-11ef-8f99-d92a46e09137',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','0301b4a18c793e75f94d4eafa72f86e28c468ad3','software','CondorScan','2024-05-29 16:14:19.438','2024-05-29 14:14:19.438'),('c297f593-1dd1-11ef-8f99-d92a46e09137',15,'bd241e23-6d6c-4ee5-82d6-187dfde89f13','43aaaa3d284bb720a7aa71c4034e4da5462b269e','software','CondorScan','2024-05-29 17:40:22.188','2024-05-29 15:40:22.188'),('c6f0c67a-176c-11ef-8f86-d92942cf49fd',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','b7d116f5ee6bd932ae006868cac998c06962a94c','software','CondorScan','2024-05-21 14:22:23.334','2024-05-21 12:22:23.335'),('ca5ebcf6-1843-11ef-8f8e-d92a44d6667d',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','158a4150f9a9ac8eeb6d4268dc0e0872555cc9dd','software','CondorScan','2024-05-22 16:01:30.885','2024-05-22 14:01:30.885'),('cfb6f82a-0951-11ef-8f65-d9283bb1c6cd',6,'afdaf315-9060-4a46-b958-9a7c00ce122c','7b394d6d1ec200751b769b039bddbe6db216fa23','software','CondorScan','2024-05-03 15:34:06.007','2024-05-03 13:34:06.007'),('d4df4dbe-1dcf-11ef-8f99-d92a46e09137',15,'7323ec54-e054-45ae-a7f2-dea3a2f57871','b3486b8b7382f34fa31c3e7e4da562d05698ce07','software','CondorScan','2024-05-29 17:26:33.861','2024-05-29 15:26:33.861'),('d619657d-1dc2-11ef-8f99-d92a46e09137',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','37aa8df9899edc4b2696d020bdb6405b627643f6','software','CondorScan','2024-05-29 15:53:32.462','2024-05-29 13:53:32.462'),('d91a043f-144c-11ef-8f1b-d8242b6da0dc',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','20ed43b9c3e78f569a3441b84351e042c7b04e88','software','CondorScan','2024-05-17 14:56:16.420','2024-05-17 12:56:16.420'),('df720ffe-06ec-11ef-90c8-dd3986f53a42',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','2363d216f1f17c5513f7840be416245b6579cb38','software','CondorScan','2024-04-30 14:26:30.260','2024-04-30 12:26:30.926'),('e258d961-0958-11ef-8f65-d9283bb1c6cd',6,'afdaf315-9060-4a46-b958-9a7c00ce122c','64eb672d3c63166cf1394c1c045e92608206e4e2','software','CondorScan','2024-05-03 16:24:43.744','2024-05-03 14:24:43.744'),('e3036daf-183d-11ef-8f8e-d92a44d6667d',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','0f8bd93b1688072e2e229cb2a3b7fb1e9f42faa9','software','CondorScan','2024-05-22 15:19:15.249','2024-05-22 13:19:15.249'),('e7d2543b-0942-11ef-8f65-d9283bb1c6cd',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','901c82a00f08b4d772cff6929537290940c636ef','software','CondorScan','2024-05-03 13:47:24.001','2024-05-03 11:47:24.001'),('e89dec23-1469-11ef-8f1b-d8242b6da0dc',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','9b490afa39f120d348143410c8fab7ff35a5b3d3','software','CondorScan','2024-05-17 18:24:17.856','2024-05-17 16:24:17.856'),('eb261337-1842-11ef-8f8e-d92a44d6667d',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','42f5744b3b2514f69f068756df1eba55fb52a788','software','CondorScan','2024-05-22 15:55:16.382','2024-05-22 13:55:16.382'),('f022da6e-1f2c-11ef-8f88-d92a43d1501c',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','6e7d66912140281392904ae1c8dfbe5bd3dd435f','software','CondorScan','2024-05-31 11:05:33.961','2024-05-31 09:05:33.961'),('f5ecb3ed-094e-11ef-8f65-d9283bb1c6cd',6,'afdaf315-9060-4a46-b958-9a7c00ce122c','755b45908d0f21c8e7deaa6b3a81de8b1664fb67','software','CondorScan','2024-05-03 15:13:41.621','2024-05-03 13:13:42.742'),('f66263f9-0951-11ef-8f65-d9283bb1c6cd',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','887b137a4e45422ec4d3418d5f2bcb14ae41cde2','software','CondorScan','2024-05-03 15:35:10.884','2024-05-03 13:35:10.884'),('ff7b7059-0942-11ef-8f65-d9283bb1c6cd',3,'7adcf581-a6db-4672-bc51-9c6d471fa663','a8d7d68bf5100ce1427f7fae3f1db2163e057cdf','software','CondorScan','2024-05-03 13:48:03.697','2024-05-03 11:48:03.697');
/*!40000 ALTER TABLE `Token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `__db_version__`
--

DROP TABLE IF EXISTS `__db_version__`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `__db_version__` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `versionMajor` int(11) NOT NULL,
  `versionMinor` int(11) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `migrationFile` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `__db_version__`
--

LOCK TABLES `__db_version__` WRITE;
/*!40000 ALTER TABLE `__db_version__` DISABLE KEYS */;
INSERT INTO `__db_version__` VALUES (1,1,0,'v1.0','iris_application_1.0_create_application'),(2,1,1,'v1.1','iris_application_1.1_occlusion_pap'),(3,1,2,'v1.2','iris_application_1.2_occlusion_pre_preparation'),(4,1,3,'v1.3','iris_application_1.3_occlusion_rework'),(5,1,4,'v1.4','iris_application_1.4_scan_label'),(6,1,5,'v1.5','iris_application_1.5_order_delivery'),(7,1,6,'v1.6','iris_application_1.6_sheet_json'),(8,1,7,'v1.7','iris_application_1.7_config_patient_list'),(9,1,8,'v1.8','iris_application_1.8_metering'),(10,1,9,'v1.9','iris_application_1.9_segmentation'),(11,1,10,'v1.10','iris_application_1.10_analyse'),(12,1,11,'v1.11','iris_application_1.11_messages'),(13,1,12,'v1.12','iris_application_1.12_scan_sup'),(14,1,13,'v1.13','iris_application_1.13_config'),(15,1,14,'v1.14','iris_application_1.14_syncinfo');
/*!40000 ALTER TABLE `__db_version__` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping routines for database 'iris_application'
--
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
/*!50003 DROP FUNCTION IF EXISTS `fileMetadataToLabel` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8mb3_general_ci */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `fileMetadataToLabel`(metadata TEXT) RETURNS text CHARSET utf8mb4 COLLATE utf8mb4_general_ci
    NO SQL
BEGIN
    IF metadata LIKE '%scanBodies%' THEN RETURN 'SCANBODY'; END IF;

    RETURN 'SCAN';
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewOcclusionFileType` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8mb3_general_ci */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewOcclusionFileType`(oldType TEXT) RETURNS text CHARSET utf8mb4 COLLATE utf8mb4_general_ci
    NO SQL
BEGIN
    IF oldType = 'OCCLUSION_RESULT' THEN RETURN 'RESULT'; END IF;

    IF oldType = 'MANDIBULE_PLY' THEN RETURN 'MANDIBLE'; END IF;

    IF oldType = 'MAXILLAIRE_PLY' THEN RETURN 'MAXILLARY'; END IF;

    IF oldType = 'MANDIBULE_MATRIX' THEN RETURN 'MANDIBLE_MATRIX'; END IF;

    IF oldType = 'MAXILLAIRE_MATRIX' THEN RETURN 'MAXILLARY_MATRIX'; END IF;

    IF oldType = 'LIFIMETA' THEN RETURN 'LIFIMETA'; END IF;

    IF oldType = 'LIFI' THEN RETURN 'LIFI'; END IF;

    IF oldType = 'SNAPSHOT' THEN RETURN 'SNAPSHOT'; END IF;

    IF oldType = 'SCREENSHOT' THEN RETURN 'SCREENSHOT'; END IF;

    
    IF oldType = 'LEFT_BITE' THEN RETURN 'RESULT'; END IF;
    IF oldType = 'RIGHT_BITE' THEN RETURN 'RESULT'; END IF;
    IF oldType = 'ANTERIOR_BITE' THEN RETURN 'RESULT'; END IF;

    RETURN oldType;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewProstheticContactPoint` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8mb3_general_ci */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewProstheticContactPoint`(old TEXT) RETURNS int(11)
    NO SQL
BEGIN
    IF old = '2' THEN RETURN 0; END IF;
    IF old = '3' THEN RETURN 1; END IF;
    IF old = '4' THEN RETURN 2; END IF;
    RETURN 1;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewProstheticCrownOrBridgeSubType` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8mb3_general_ci */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewProstheticCrownOrBridgeSubType`(old TEXT) RETURNS int(11)
    NO SQL
BEGIN
    IF old = '1' THEN RETURN 0; END IF;
    IF old = '2' THEN RETURN 1; END IF;
    IF old = '3' THEN RETURN 2; END IF;
    RETURN 0;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewProstheticGouttiereSubType` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8mb3_general_ci */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewProstheticGouttiereSubType`(old TEXT) RETURNS int(11)
    NO SQL
BEGIN
    IF old = '1' THEN RETURN 1; END IF;
    IF old = '2' THEN RETURN 2; END IF;
    IF old = '3' THEN RETURN 3; END IF;
    IF old = '4' THEN RETURN 0; END IF;
    IF old = '5' THEN RETURN 4; END IF;
    IF old = '6' THEN RETURN 5; END IF;
    IF old = '7' THEN RETURN 6; END IF;
    RETURN 0;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewProstheticImplantCrownSubType` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8mb3_general_ci */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewProstheticImplantCrownSubType`(old TEXT) RETURNS int(11)
    NO SQL
BEGIN
    IF old = '1' THEN RETURN 0; END IF;
    IF old = '2' THEN RETURN 1; END IF;
    IF old = '3' THEN RETURN 0; END IF;
    IF old = '4' THEN RETURN 1; END IF;
    RETURN 2;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewProstheticInlayOnlaySubType` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8mb3_general_ci */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewProstheticInlayOnlaySubType`(old TEXT) RETURNS int(11)
    NO SQL
BEGIN
    IF old = '1' THEN RETURN 0; END IF;
    IF old = '2' THEN RETURN 1; END IF;
    RETURN 2;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
/*!50003 DROP FUNCTION IF EXISTS `scanMetadataToLabel` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8mb3_general_ci */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `scanMetadataToLabel`(metadata TEXT) RETURNS text CHARSET utf8mb4 COLLATE utf8mb4_general_ci
    NO SQL
BEGIN
    IF metadata LIKE '%"isPrePreparation":true%' THEN RETURN 'PRE_PREPARATION'; END IF;

    RETURN 'SCAN';
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2024-05-31 11:08:08
