-- MariaDB dump 10.19  Distrib 10.6.16-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: localhost    Database: iris_application
-- ------------------------------------------------------
-- Server version	10.6.16-MariaDB-0ubuntu0.22.04.1

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `Act`
--

DROP TABLE IF EXISTS `Act`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Act` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `patientId` varchar(36) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `displayId` mediumint(8) unsigned DEFAULT NULL,
  `pcId` mediumint(8) unsigned DEFAULT NULL,
  `workflow` enum('FREE','WORKFLOW_1','WORKFLOW_2','WORKFLOW_3','ANALYSE') NOT NULL DEFAULT 'FREE',
  `comments` text DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT 0,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastAccessed` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `patientId` (`patientId`),
  CONSTRAINT `Act_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `Act_ibfk_2` FOREIGN KEY (`patientId`) REFERENCES `iris_patient`.`Patient` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Act`
--

LOCK TABLES `Act` WRITE;
/*!40000 ALTER TABLE `Act` DISABLE KEYS */;
INSERT INTO `Act` VALUES ('0222265c-2990-11ef-8fb0-da2b4bf5ebbb',4,'f8254989-2960-11ef-9161-de41a781935b','Commande 1.9',9,1,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-13 16:19:55.959','2024-06-13 16:20:10.486','2024-06-13 16:19:56.098','2024-06-13 16:20:10.486','2024-06-13 14:20:10.486',NULL),('023e35f2-2990-11ef-8fb0-da2b4bf5ebbb',4,'f8254989-2960-11ef-9161-de41a781935b','Commande 1.10',10,1,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-13 16:19:56.143','2024-06-13 16:20:08.651','2024-06-13 16:19:56.260','2024-06-13 16:20:08.651','2024-06-13 14:20:08.651',NULL),('09ea2f4d-2343-11ef-8f93-d92a45da78c9',2,'dc803a78-225a-11ef-8f1f-d8242c71b430','Commande 1.7',7,1,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-05 15:53:50.000',NULL,'2024-06-05 15:55:02.000','2024-06-05 15:55:21.000','2024-06-05 13:55:22.000','2024-06-05 15:55:22.000'),('11bc8a6c-2973-11ef-9161-de41a781935b',4,'f8254989-2960-11ef-9161-de41a781935b','Commande 1.2',2,1,'WORKFLOW_1','{\"type\":\"ORDER\"}',0,'2024-06-13 12:52:46.732',NULL,'2024-06-13 16:06:40.812','2024-06-13 13:01:55.460','2024-06-13 14:06:40.812',NULL),('1d080326-2990-11ef-8fb0-da2b4bf5ebbb',4,'f8254989-2960-11ef-9161-de41a781935b','Commande 1.11',11,1,'WORKFLOW_2','{\"type\":\"ORDER\"}',0,'2024-06-13 16:20:41.086',NULL,'2024-06-13 16:20:50.877','2024-06-13 16:20:41.087','2024-06-13 14:20:50.878',NULL),('1d30966f-2990-11ef-8fb0-da2b4bf5ebbb',4,'f8254989-2960-11ef-9161-de41a781935b','Commande 1.12',12,1,'WORKFLOW_2','{\"type\":\"ORDER\"}',0,'2024-06-13 16:20:41.354',NULL,'2024-06-13 16:23:44.418','2024-06-13 16:20:41.355','2024-06-13 14:23:44.418',NULL),('3f0f8fd5-2336-11ef-8f93-d92a45da78c9',2,'dc803a78-225a-11ef-8f1f-d8242c71b430','Commande 1.4',4,1,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-05 14:22:16.000','2024-06-05 14:23:37.000','2024-06-05 14:23:18.000','2024-06-05 14:23:34.000','2024-06-05 12:23:37.000','2024-06-05 14:23:37.000'),('43de61ec-2962-11ef-9161-de41a781935b',4,'f8254989-2960-11ef-9161-de41a781935b','Commande 1.1',1,1,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-13 10:52:29.395',NULL,'2024-06-13 15:53:43.210','2024-06-13 15:54:14.213','2024-06-13 13:54:14.213',NULL),('624eaed5-2990-11ef-8fb0-da2b4bf5ebbb',4,'f8254989-2960-11ef-9161-de41a781935b','Commande 1.13',13,1,'WORKFLOW_1','{\"type\":\"ORDER\"}',0,'2024-06-13 16:22:37.312','2024-06-13 16:22:50.598','2024-06-13 16:22:37.449','2024-06-13 16:22:50.598','2024-06-13 14:22:50.598',NULL),('6fa078a0-2987-11ef-8fb0-da2b4bf5ebbb',4,'f8254989-2960-11ef-9161-de41a781935b','Commande 1.3',3,1,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-13 15:18:34.188','2024-06-13 16:20:17.505','2024-06-13 16:17:11.856','2024-06-13 16:20:17.506','2024-06-13 14:20:17.506',NULL),('6fe32775-2987-11ef-8fb0-da2b4bf5ebbb',4,'f8254989-2960-11ef-9161-de41a781935b','Commande 1.4',4,1,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-13 15:18:34.625','2024-06-13 16:20:14.885','2024-06-13 16:17:18.532','2024-06-13 16:20:14.885','2024-06-13 14:20:14.886',NULL),('757ed4bc-2266-11ef-8f1f-d8242c71b430',2,'dc803a78-225a-11ef-8f1f-d8242c71b430','Commande 1.2',2,1,'WORKFLOW_2','{\"type\":\"ORDER\"}',0,'2024-06-04 13:34:52.503',NULL,'2024-06-04 15:02:28.124','2024-06-04 13:57:45.920','2024-06-04 13:02:28.124','2024-06-04 15:02:28.134'),('7eb8397d-2987-11ef-8fb0-da2b4bf5ebbb',4,'f8254989-2960-11ef-9161-de41a781935b','Commande 1.5',5,1,'WORKFLOW_3','{\"type\":\"ORDER\"}',0,'2024-06-13 15:18:59.510',NULL,'2024-06-13 16:23:09.528','2024-06-13 15:22:55.301','2024-06-13 14:23:09.529',NULL),('8c23d690-233c-11ef-8f93-d92a45da78c9',2,'dc803a78-225a-11ef-8f1f-d8242c71b430','Commande 1.6',6,1,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-05 15:07:22.000',NULL,'2024-06-05 15:23:52.000','2024-06-05 15:26:18.000','2024-06-05 13:26:19.000','2024-06-05 15:26:19.000'),('ad326548-298f-11ef-8fb0-da2b4bf5ebbb',4,'f8254989-2960-11ef-9161-de41a781935b','Commande 1.6',6,1,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-13 16:17:33.459','2024-06-13 16:17:52.256','2024-06-13 16:17:33.617','2024-06-13 16:17:52.256','2024-06-13 14:17:52.256',NULL),('ad641506-298f-11ef-8fb0-da2b4bf5ebbb',4,'f8254989-2960-11ef-9161-de41a781935b','Commande 1.7',7,1,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-13 16:17:33.785','2024-06-13 16:17:49.964','2024-06-13 16:17:40.146','2024-06-13 16:17:49.964','2024-06-13 14:17:49.964',NULL),('b19ab46f-2336-11ef-8f93-d92a45da78c9',2,'dc803a78-225a-11ef-8f1f-d8242c71b430','Commande 1.5',5,1,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-05 14:25:28.000',NULL,'2024-06-05 15:26:36.000','2024-06-05 15:27:25.000','2024-06-05 13:27:27.000','2024-06-05 15:27:27.000'),('b651a084-2343-11ef-8f93-d92a45da78c9',2,'dc803a78-225a-11ef-8f1f-d8242c71b430','Direct scan 1.8',8,1,'FREE','{\"type\":\"DIRECT_SCAN\"}',0,'2024-06-05 15:58:40.000',NULL,'2024-06-05 15:59:05.000','2024-06-05 15:59:05.000','2024-06-05 13:59:06.000','2024-06-05 15:59:06.000'),('c32616e0-298f-11ef-8fb0-da2b4bf5ebbb',4,'f8254989-2960-11ef-9161-de41a781935b','Commande 1.8',8,1,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-13 16:18:10.289','2024-06-13 16:19:48.565','2024-06-13 16:18:10.413','2024-06-13 16:19:48.566','2024-06-13 14:19:48.566',NULL),('c81d8cfa-2343-11ef-8f93-d92a45da78c9',2,'c81cfb76-2343-11ef-8f93-d92a45da78c9','Direct scan',1,1,'FREE','{\"type\":\"DIRECT_SCAN\"}',1,'2024-06-05 15:59:09.893',NULL,'2024-06-05 15:59:10.020','2024-06-05 15:59:09.894','2024-06-05 13:59:10.021',NULL),('cdf2bb52-227d-11ef-8f8c-d92a43d45d56',2,'ce57500b-227c-11ef-8d76-d310d2ec2c14','Commande 3.1',1,1,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-04 16:21:59.000',NULL,'2024-06-07 11:51:58.000','2024-06-04 16:22:57.000','2024-06-07 09:51:59.000','2024-06-07 11:51:59.000'),('e3862d66-225a-11ef-8f1f-d8242c71b430',2,'dc803a78-225a-11ef-8f1f-d8242c71b430','Commande 1.1',1,1,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-04 12:12:03.000',NULL,'2024-06-05 14:17:05.000','2024-06-04 12:31:53.000','2024-06-05 12:17:06.000','2024-06-05 14:17:06.000'),('e90de9ef-2897-11ef-8f6f-d9283dbaec71',3,'e90d651d-2897-11ef-8f6f-d9283dbaec71','Direct scan',1,2,'FREE','{\"type\":\"DIRECT_SCAN\"}',1,'2024-06-12 10:43:58.695',NULL,'2024-06-12 10:45:08.376','2024-06-12 10:45:08.263','2024-06-12 08:45:08.377',NULL),('f1fca9ca-2958-11ef-9161-de41a781935b',2,'ecf61c34-2958-11ef-9161-de41a781935b','Commande 5.1',1,1,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-13 09:45:46.550',NULL,'2024-06-13 09:48:34.708','2024-06-13 09:48:34.596','2024-06-13 07:48:34.708',NULL),('f6cfa4bf-226e-11ef-8f1f-d8242c71b430',2,'dc803a78-225a-11ef-8f1f-d8242c71b430','Commande 1.3',3,1,'FREE','{\"type\":\"ORDER\"}',0,'2024-06-04 14:35:45.000',NULL,'2024-06-05 14:24:49.313','2024-06-04 14:38:30.000','2024-06-05 12:24:49.314','2024-06-05 14:24:49.323');
/*!40000 ALTER TABLE `Act` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AddressInfo`
--

DROP TABLE IF EXISTS `AddressInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `AddressInfo` (
  `uuid` varchar(36) NOT NULL,
  `line0` varchar(255) DEFAULT NULL,
  `line1` varchar(255) DEFAULT NULL,
  `line2` varchar(255) DEFAULT NULL,
  `detail` varchar(255) DEFAULT NULL,
  `cityName` varchar(255) DEFAULT NULL,
  `cityState` varchar(255) DEFAULT NULL,
  `cityZip` varchar(255) DEFAULT NULL,
  `countryName` varchar(255) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AddressInfo`
--

LOCK TABLES `AddressInfo` WRITE;
/*!40000 ALTER TABLE `AddressInfo` DISABLE KEYS */;
INSERT INTO `AddressInfo` VALUES ('21c830ed-6a00-476f-a24f-e721cd2543d8','','','','','','','','','2024-06-04 12:15:39.884','2024-06-04 14:18:32.000'),('4caacc66-8838-11ec-89bc-2e174fce41cd','Route du test','','','','Toulouse','','31100','France','2024-06-03 15:04:56.000','2024-06-03 17:04:56.000'),('500b8a2a-af0c-40fb-ae0b-51f88f080fd3','','','','','','','','','2024-06-06 11:35:54.000','2024-06-06 13:35:54.000'),('5440e4c6-0dfa-455e-b4bc-20352f964660','','','','','labege','','','','2024-06-06 08:55:07.000','2024-06-06 10:55:07.000'),('7780848c-b087-4217-b3a5-e8cb992abbae','rue de Garance','','','','labège','','31670','France','2024-06-04 08:35:38.608','2024-06-06 10:24:38.000'),('94e607d4-dbbd-43f6-9902-9d0d590bbc8e','','','','','','','','','2024-06-04 12:32:18.050','2024-06-04 14:35:11.000'),('a22123da-17c2-438f-97f9-9845680a644b','av. de Fleury','','','','salles d\'aude','','11110','France','2024-06-04 08:40:35.000','2024-06-06 14:49:21.000'),('a521e3a9-ad56-413f-990f-60c7817d6962','hbgdsfdsfvkds','','','','dfdgfg','','1111','United States of America','2024-06-04 09:28:55.000','2024-06-04 13:58:23.000'),('b625ed42-6f59-4c23-bfe5-3740f8716d69','','','','','','','','','2024-06-06 10:16:54.000','2024-06-06 12:16:55.000'),('c8db9302-3511-4c3f-b38d-de29e76d9f03','djfhgjfdhg','','','','sdfdsgsd','','11111','France','2024-06-04 09:24:58.728','2024-06-04 13:58:33.000');
/*!40000 ALTER TABLE `AddressInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Analyse`
--

DROP TABLE IF EXISTS `Analyse`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Analyse` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `actId` varchar(36) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `type` enum('METERING','COMPARE') NOT NULL DEFAULT 'METERING',
  `displayId` mediumint(8) unsigned DEFAULT NULL,
  `pcId` mediumint(8) unsigned DEFAULT NULL,
  `comments` text DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `actId` (`actId`),
  CONSTRAINT `Analyse_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `Analyse_ibfk_2` FOREIGN KEY (`actId`) REFERENCES `Act` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Analyse`
--

LOCK TABLES `Analyse` WRITE;
/*!40000 ALTER TABLE `Analyse` DISABLE KEYS */;
/*!40000 ALTER TABLE `Analyse` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AnalyseFile`
--

DROP TABLE IF EXISTS `AnalyseFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `AnalyseFile` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `analyseId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('TRANSFORMATION','SNAPSHOT','SCREENSHOT','METERING','RESULT') NOT NULL,
  PRIMARY KEY (`analyseId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `AnalyseFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `AnalyseFile_ibfk_2` FOREIGN KEY (`analyseId`) REFERENCES `Analyse` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `AnalyseFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AnalyseFile`
--

LOCK TABLES `AnalyseFile` WRITE;
/*!40000 ALTER TABLE `AnalyseFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `AnalyseFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AnalyseScan`
--

DROP TABLE IF EXISTS `AnalyseScan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `AnalyseScan` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `analyseId` varchar(36) NOT NULL,
  `scanId` varchar(36) NOT NULL,
  PRIMARY KEY (`analyseId`,`scanId`),
  KEY `ownerId` (`ownerId`),
  KEY `scanId` (`scanId`),
  CONSTRAINT `AnalyseScan_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `AnalyseScan_ibfk_2` FOREIGN KEY (`analyseId`) REFERENCES `Analyse` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `AnalyseScan_ibfk_3` FOREIGN KEY (`scanId`) REFERENCES `Scan` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AnalyseScan`
--

LOCK TABLES `AnalyseScan` WRITE;
/*!40000 ALTER TABLE `AnalyseScan` DISABLE KEYS */;
/*!40000 ALTER TABLE `AnalyseScan` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Assistant`
--

DROP TABLE IF EXISTS `Assistant`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Assistant` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `credentialsId` varchar(36) DEFAULT NULL,
  `personInfoId` varchar(36) NOT NULL,
  `phoneInfoId` varchar(36) NOT NULL,
  `addressInfoId` varchar(36) NOT NULL,
  `officeId` varchar(36) DEFAULT NULL,
  `patientRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'READ_ONLY',
  `actRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'NOTHING',
  `discussionRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'NOTHING',
  `tempPassword` varchar(32) DEFAULT NULL,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `credentialsId` (`credentialsId`),
  KEY `personInfoId` (`personInfoId`),
  KEY `phoneInfoId` (`phoneInfoId`),
  KEY `addressInfoId` (`addressInfoId`),
  KEY `officeId` (`officeId`),
  CONSTRAINT `Assistant_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_2` FOREIGN KEY (`credentialsId`) REFERENCES `Credentials` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_3` FOREIGN KEY (`personInfoId`) REFERENCES `PersonInfo` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_4` FOREIGN KEY (`phoneInfoId`) REFERENCES `PhoneInfo` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_5` FOREIGN KEY (`addressInfoId`) REFERENCES `AddressInfo` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_6` FOREIGN KEY (`officeId`) REFERENCES `Office` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Assistant`
--

LOCK TABLES `Assistant` WRITE;
/*!40000 ALTER TABLE `Assistant` DISABLE KEYS */;
INSERT INTO `Assistant` VALUES ('278341b0-226c-11ef-8f1f-d8242c71b430',2,'b6ffbf80-89c9-494d-b7aa-c32d17187d3e','ea8bca69-75b7-4877-8406-eca77b86cb2f','a8b2657e-dca8-42a8-a6cd-7b3dfcdacfac','21c830ed-6a00-476f-a24f-e721cd2543d8','1851efb6-58e7-4b73-b221-a63ec0947b77','READ_ONLY','NOTHING','NOTHING','wi6nx9Y2',NULL,'2024-06-04 14:15:38.000','2024-06-04 12:18:32.000','2024-06-04 14:18:32.000'),('7af0c969-226e-11ef-8f1f-d8242c71b430',2,'52a4fd68-0b4c-451c-8ba7-97e0083d1392','8bb7d06d-0faf-4fbe-9a3e-bf2a50402277','8caa4c94-c597-4679-ba07-d658d15edbb0','94e607d4-dbbd-43f6-9902-9d0d590bbc8e','1851efb6-58e7-4b73-b221-a63ec0947b77','READ_ONLY','NOTHING','NOTHING','WPh9isP9',NULL,'2024-06-04 14:32:17.000','2024-06-04 12:35:11.000','2024-06-04 14:35:11.000');
/*!40000 ALTER TABLE `Assistant` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CircleOrder`
--

DROP TABLE IF EXISTS `CircleOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `CircleOrder` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `actId` varchar(36) NOT NULL,
  `title` varchar(64) DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT 0,
  `createdById` varchar(36) DEFAULT NULL,
  `updatedById` varchar(36) DEFAULT NULL,
  `displayId` mediumint(8) unsigned DEFAULT NULL,
  `pcId` mediumint(8) unsigned DEFAULT NULL,
  `json` text NOT NULL,
  `metadata` text NOT NULL,
  `status` enum('NOT_SENT','WAITING_WOW_API','SENDING_WOW_API','SENDING_CIRCLE_API','SENT','CANCELLED','DELIVERY') NOT NULL DEFAULT 'NOT_SENT',
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `actId` (`actId`),
  CONSTRAINT `CircleOrder_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `CircleOrder_ibfk_2` FOREIGN KEY (`actId`) REFERENCES `Act` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CircleOrder`
--

LOCK TABLES `CircleOrder` WRITE;
/*!40000 ALTER TABLE `CircleOrder` DISABLE KEYS */;
/*!40000 ALTER TABLE `CircleOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CircleOrderFile`
--

DROP TABLE IF EXISTS `CircleOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `CircleOrderFile` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('FORM','SCAN') NOT NULL,
  PRIMARY KEY (`orderId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `CircleOrderFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `CircleOrderFile_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `CircleOrder` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `CircleOrderFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CircleOrderFile`
--

LOCK TABLES `CircleOrderFile` WRITE;
/*!40000 ALTER TABLE `CircleOrderFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `CircleOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Config`
--

DROP TABLE IF EXISTS `Config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Config` (
  `id` mediumint(8) unsigned NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `options` text DEFAULT NULL COMMENT 'Software configuration values as json',
  `syncEnabled` tinyint(1) DEFAULT 1,
  `showOpenStlWarning` tinyint(1) DEFAULT 1,
  `emailNotifications` tinyint(1) DEFAULT 1,
  `logout` mediumint(8) DEFAULT 10,
  `language` varchar(2) DEFAULT NULL,
  `customColorLut` text DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  PRIMARY KEY (`id`,`ownerId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Config`
--

LOCK TABLES `Config` WRITE;
/*!40000 ALTER TABLE `Config` DISABLE KEYS */;
INSERT INTO `Config` VALUES (1,1,'',1,1,1,10,'FR',NULL,'2024-06-03 17:04:56.000','2024-06-03 17:04:56.000','2024-06-03 15:04:56.000'),(1,2,'{\"ordersTableColumnsConfig\":{\"filtering\":[true,true,true,true,true,false],\"sorting\":[{\"order\":1,\"role\":\"internalStatusText\"},{\"order\":0,\"role\":\"patientSortName\"},{\"order\":0,\"role\":\"recipientSortName\"},{\"order\":0,\"role\":\"orderDetails\"},{\"order\":0,\"role\":\"fullDisplayId\"},{\"order\":1,\"role\":\"lastModified\"}]},\"showAllPatients\":false,\"trackingLostIndicator\":false}',1,1,1,10,'IT',NULL,'2024-06-04 10:35:34.000','2024-06-06 10:24:38.000','2024-06-13 08:00:49.964'),(1,3,'{\"ordersTableColumnsConfig\":{\"filtering\":[true,true,true,true,false,false],\"sorting\":[{\"order\":1,\"role\":\"internalStatusText\"},{\"order\":0,\"role\":\"patientSortName\"},{\"order\":0,\"role\":\"recipientSortName\"},{\"order\":0,\"role\":\"orderDetails\"},{\"order\":0,\"role\":\"fullDisplayId\"},{\"order\":1,\"role\":\"lastModified\"}]},\"showAllPatients\":true}',1,1,1,10,'FR',NULL,'2024-06-04 10:40:35.000','2024-06-06 14:49:21.000','2024-06-06 09:57:34.000'),(1,4,'{\"ordersTableColumnsConfig\":{\"filtering\":[true,true,true,true,false,false],\"sorting\":[{\"order\":1,\"role\":\"internalStatusText\"},{\"order\":0,\"role\":\"patientSortName\"},{\"order\":0,\"role\":\"recipientSortName\"},{\"order\":0,\"role\":\"orderDetails\"},{\"order\":0,\"role\":\"fullDisplayId\"},{\"order\":1,\"role\":\"lastModified\"}]},\"showAllPatients\":true}',1,1,1,30,'FR',NULL,'2024-06-04 11:24:55.000','2024-06-04 13:58:33.000','2024-06-13 11:10:26.665'),(1,5,'',1,1,1,10,'FR',NULL,'2024-06-04 11:28:55.000','2024-06-04 13:58:23.000','2024-06-04 09:28:55.000'),(1,6,'',1,1,1,10,'FR',NULL,'2024-06-06 10:47:25.000','2024-06-06 10:55:07.000','2024-06-06 08:47:25.000'),(1,7,'',1,1,1,10,'FR',NULL,'2024-06-06 12:16:54.000','2024-06-06 12:16:55.000','2024-06-06 10:16:54.000'),(1,8,'',1,1,1,10,'FR',NULL,'2024-06-06 13:35:54.000','2024-06-06 13:35:54.000','2024-06-06 11:35:54.000');
/*!40000 ALTER TABLE `Config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Contact`
--

DROP TABLE IF EXISTS `Contact`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Contact` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `professionalId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel contact',
  `officeId` varchar(36) DEFAULT NULL,
  `status` enum('INVITATIONSENT','INVITATIONRECEIVED','ACCEPTED','REJECTED') NOT NULL DEFAULT 'INVITATIONSENT',
  `comments` text DEFAULT NULL,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `uniqueContactPro` (`ownerId`,`professionalId`),
  KEY `professionalId` (`professionalId`),
  KEY `officeId` (`officeId`),
  CONSTRAINT `Contact_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `Contact_ibfk_2` FOREIGN KEY (`professionalId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `Contact_ibfk_3` FOREIGN KEY (`officeId`) REFERENCES `Office` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Contact`
--

LOCK TABLES `Contact` WRITE;
/*!40000 ALTER TABLE `Contact` DISABLE KEYS */;
INSERT INTO `Contact` VALUES ('0975b0f3-6f5c-4a07-a97b-8be554bb75ef',4,4,NULL,'ACCEPTED','',NULL,'2024-06-04 11:24:55.000','2024-06-04 11:58:33.000','2024-06-04 13:58:33.000'),('4ed4ce00-4b30-4601-95bb-ede535f19c6b',2,4,NULL,'ACCEPTED','',NULL,'2024-06-04 13:59:28.000','2024-06-04 11:59:28.000','2024-06-04 13:59:28.000'),('57a94929-f9c0-438e-b77e-c2432d03181d',2,2,NULL,'ACCEPTED','',NULL,'2024-06-04 10:35:34.000','2024-06-06 08:24:38.000','2024-06-06 10:24:38.000'),('5817ca50-da74-40f6-a56f-d00bb8140a84',3,3,NULL,'ACCEPTED','',NULL,'2024-06-04 10:40:35.000','2024-06-06 12:49:21.000','2024-06-06 14:49:21.000'),('8fbd79fd-0e86-49b8-9558-3a507eb19750',2,3,NULL,'ACCEPTED','',NULL,'2024-06-04 12:25:41.000','2024-06-06 12:49:21.000','2024-06-06 14:49:21.000'),('a50cb907-4db3-48f3-9808-0ae18d8dccdb',3,6,NULL,'ACCEPTED','',NULL,'2024-06-06 10:55:29.000','2024-06-06 08:55:29.000','2024-06-06 10:55:29.000'),('a664f09d-da86-42d0-b54a-2672898db522',3,2,NULL,'ACCEPTED','',NULL,'2024-06-04 12:25:41.000','2024-06-06 08:24:38.000','2024-06-06 10:24:38.000'),('b7bc1215-7636-4e7b-bbf5-21d4678f824a',4,1,NULL,'ACCEPTED','',NULL,'2024-06-04 11:24:55.000','2024-06-04 09:24:55.000','2024-06-04 11:24:55.000'),('ca42284a-209a-4655-9371-ebd08d5a657d',2,1,NULL,'ACCEPTED','',NULL,'2024-06-04 10:35:34.000','2024-06-04 08:35:34.000','2024-06-04 10:35:34.000'),('d9206ed1-cc31-4eed-85d5-1551b9fec244',4,2,NULL,'ACCEPTED','',NULL,'2024-06-04 13:59:28.000','2024-06-04 12:02:57.000','2024-06-04 14:02:57.000'),('f06fd9e4-900c-420e-abcb-d93ab9671678',2,7,NULL,'INVITATIONSENT','',NULL,'2024-06-06 12:16:54.000','2024-06-06 10:16:55.000','2024-06-06 12:16:55.000'),('f765045a-2805-40b5-9a87-63af78cc2071',2,5,NULL,'INVITATIONSENT','',NULL,'2024-06-04 13:58:23.000','2024-06-04 11:58:23.000','2024-06-04 13:58:23.000'),('fd00b931-034c-4d7b-8071-0455da26e33b',2,8,NULL,'REJECTED','',NULL,'2024-06-06 13:38:10.300','2024-06-06 11:38:10.300','2024-06-06 13:38:10.310');
/*!40000 ALTER TABLE `Contact` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ContactNotification`
--

DROP TABLE IF EXISTS `ContactNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ContactNotification` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `contactId` varchar(36) DEFAULT NULL,
  `rescueDisplayName` varchar(50) DEFAULT NULL,
  `event` enum('RECEIVED','RECEIVED_TO_ACCEPTED','RECEIVED_TO_REJECTED','SENT_TO_ACCEPTED','SENT_TO_REJECTED','ACTIVATION_TIMEOUT') NOT NULL DEFAULT 'RECEIVED',
  `unread` tinyint(1) NOT NULL DEFAULT 1,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `contactId` (`contactId`),
  CONSTRAINT `ContactNotification_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `ContactNotification_ibfk_2` FOREIGN KEY (`contactId`) REFERENCES `Contact` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ContactNotification`
--

LOCK TABLES `ContactNotification` WRITE;
/*!40000 ALTER TABLE `ContactNotification` DISABLE KEYS */;
INSERT INTO `ContactNotification` VALUES ('4b06f52f-6d85-4c47-a377-37eddb80bd1b',4,'d9206ed1-cc31-4eed-85d5-1551b9fec244','sabine casertA','RECEIVED_TO_ACCEPTED',0,'2024-06-04 13:58:32.000',NULL,'2024-06-04 11:59:28.000','2024-06-04 13:59:28.000'),('70e65319-75d9-46ec-abbd-9040e767f5aa',3,'a664f09d-da86-42d0-b54a-2672898db522','sabine casertA','RECEIVED_TO_ACCEPTED',0,'2024-06-04 12:25:07.000',NULL,'2024-06-04 10:25:41.000','2024-06-04 12:25:41.000'),('ae5b0efc-c662-47e3-bf0c-e0d37373070b',2,'8fbd79fd-0e86-49b8-9558-3a507eb19750','succursalle Salles d\'aude laboratoire scan4all','SENT_TO_ACCEPTED',0,'2024-06-04 12:25:41.000','2024-06-05 14:12:38.000','2024-06-05 12:12:38.000','2024-06-05 14:12:38.000'),('dde68b2b-58f8-427a-81f2-b97a3cedb316',3,'a50cb907-4db3-48f3-9808-0ae18d8dccdb','client leger','SENT_TO_ACCEPTED',0,'2024-06-06 10:55:29.000',NULL,'2024-06-06 09:04:04.103','2024-06-06 11:04:04.105'),('f4351802-7e0b-42c0-a5b3-f537dfd6bdfe',2,'4ed4ce00-4b30-4601-95bb-ede535f19c6b','demo3 demo3env1','SENT_TO_ACCEPTED',0,'2024-06-04 13:59:28.000','2024-06-05 14:12:37.242','2024-06-05 12:12:37.243','2024-06-05 14:12:37.252');
/*!40000 ALTER TABLE `ContactNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Credentials`
--

DROP TABLE IF EXISTS `Credentials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Credentials` (
  `uuid` varchar(36) NOT NULL,
  `login` varchar(255) NOT NULL,
  `password` varchar(100) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `login` (`login`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Credentials`
--

LOCK TABLES `Credentials` WRITE;
/*!40000 ALTER TABLE `Credentials` DISABLE KEYS */;
INSERT INTO `Credentials` VALUES ('2e995095-88b2-11ec-89bc-2e174fce41cd','biotech',NULL,'2024-06-03 15:04:56.000','2024-06-03 17:04:56.000'),('357013df-fab4-4e08-a0b3-25be5d10fb9e','gamajesas@hotmail.fr',NULL,'2024-06-06 08:55:07.000','2024-06-06 10:55:07.000'),('52a4fd68-0b4c-451c-8ba7-97e0083d1392','azerty5@az.fr','87dd82aaee8a959f76b998a60f02a001f8f0e5762228f0f70ed88a37bad4efeb','2024-06-04 12:32:18.037','2024-06-04 14:35:11.000'),('7a0e3a28-a28c-4323-92c1-8831f0d6815b','demo3','b814790075abcdcafc7ad21c3d425c2c7a3a4edca31252f7a8b5935f8250e5f8','2024-06-04 09:24:58.725','2024-06-04 13:58:33.000'),('83184b42-53a8-43e0-964a-e3b8d3a2acbf','iris','b7c9d95548ee05e8e7bb3d8852f2e7ef43f994d9f5fce8998f94a4226ad3fa49','2024-06-10 13:58:43.855','2024-06-06 10:24:38.000'),('adc06de1-bf5d-4b1a-81dc-e5e919328b7c','demo2','3b3d4e9a5ac7cde03a41c782976f5687a7ba7cd84c908cf1c1f7b567cfd0bbc2','2024-06-06 08:43:41.000','2024-06-06 14:49:21.000'),('b35f432d-f5a0-4048-b2dc-1eb3596a89a1','demo4',NULL,'2024-06-04 09:28:55.000','2024-06-04 13:58:23.000'),('b6ffbf80-89c9-494d-b7aa-c32d17187d3e','poiu1@az.fr','706dff4756ab3834f2fa133bc49c9b5eef40901585daf37a4c6657aa3b54a434','2024-06-04 12:15:39.879','2024-06-04 14:18:32.000');
/*!40000 ALTER TABLE `Credentials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Discussion`
--

DROP TABLE IF EXISTS `Discussion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Discussion` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `selfImplied` tinyint(1) NOT NULL DEFAULT 0,
  `officeId` varchar(36) DEFAULT NULL,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`,`ownerId`),
  KEY `ownerId` (`ownerId`),
  KEY `officeId` (`officeId`),
  CONSTRAINT `Discussion_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `Discussion_ibfk_2` FOREIGN KEY (`officeId`) REFERENCES `Office` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Discussion`
--

LOCK TABLES `Discussion` WRITE;
/*!40000 ALTER TABLE `Discussion` DISABLE KEYS */;
INSERT INTO `Discussion` VALUES ('0f3dfe44-225d-11ef-8f1f-d8242c71b430',2,0,NULL,NULL,'2024-06-04 12:27:35.480','2024-06-07 10:15:21.000','2024-06-07 12:15:21.000'),('0f3dfe44-225d-11ef-8f1f-d8242c71b430',3,0,NULL,NULL,'2024-06-04 12:27:35.480','2024-06-07 10:15:21.000','2024-06-07 12:15:21.000'),('550eb27a-226b-11ef-8f1f-d8242c71b430',2,0,NULL,NULL,'2024-06-04 14:09:45.565','2024-06-07 09:33:44.000','2024-06-07 11:33:44.000'),('550eb27a-226b-11ef-8f1f-d8242c71b430',4,0,NULL,NULL,'2024-06-04 14:09:45.566','2024-06-04 12:10:47.000','2024-06-04 14:10:47.000'),('ddab36aa-23e2-11ef-8f8c-d92a43d45e5a',3,0,NULL,NULL,'2024-06-06 10:57:56.034','2024-06-06 09:36:14.000','2024-06-06 11:36:14.000'),('ddab36aa-23e2-11ef-8f8c-d92a43d45e5a',6,0,NULL,NULL,'2024-06-06 10:57:56.034','2024-06-06 08:57:56.034',NULL);
/*!40000 ALTER TABLE `Discussion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `File`
--

DROP TABLE IF EXISTS `File`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `File` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `path` text DEFAULT NULL,
  `tag` text DEFAULT NULL,
  `originalName` text NOT NULL,
  `originalId` varchar(36) NOT NULL,
  `metadata` text DEFAULT NULL,
  `type` enum('BIN','JSON','PDF','PLY','STL','PNG','XYZ','ZIP') NOT NULL,
  `version` mediumint(8) unsigned DEFAULT 0,
  `status` enum('CREATED','UPDATED','SYNCED','ERROR') DEFAULT 'CREATED',
  `anonymous` tinyint(1) NOT NULL DEFAULT 0,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `version` (`originalId`,`version`),
  CONSTRAINT `File_ibfk_1` FOREIGN KEY (`originalId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `File`
--

LOCK TABLES `File` WRITE;
/*!40000 ALTER TABLE `File` DISABLE KEYS */;
INSERT INTO `File` VALUES ('026ee82c-2964-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/scan_4cc68cd8-2962-11ef-9161-de41a781935b/026ee82c-2964-11ef-9161-de41a781935b.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_TOSC_4cc68cd8-2962-11ef-9161-de41a781935b_MODEL','026ee82c-2964-11ef-9161-de41a781935b.zip','809c945c-2962-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Maxillaire u1\",\"modelMatrix\":\"-0.872758,0.470809,-0.128964,0,-0.443838,-0.875321,-0.191887,0,-0.203227,-0.110232,0.972907,0,-2.56858,6.47103,-8.11483,1\",\"scanBodies\":[{\"position\":\"2.06903,5.05438,0,0,-0.995382,0,5.77626,0,6.47861,0,0,4,1,0,0,0\",\"reference\":\"K30PSCANPLG\",\"tid\":26}]}','ZIP',2,'CREATED',0,NULL,'2024-06-13 11:04:58.606','2024-06-13 09:40:25.620',NULL),('03eb2fd7-233f-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_8c23d690-233c-11ef-8f93-d92a45da78c9/occlusion_8c257d6d-233c-11ef-8f93-d92a45da78c9/scan_93bdd6ef-233c-11ef-8f93-d92a45da78c9/03eb2fd7-233f-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_8c23d690-233c-11ef-8f93-d92a45da78c9_SESS_8c257d6d-233c-11ef-8f93-d92a45da78c9_TOSC_93bdd6ef-233c-11ef-8f93-d92a45da78c9_MODEL','03eb2fd7-233f-11ef-8f93-d92a45da78c9.zip','acfa30bf-233c-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.6 Maxillaire u1 [pc1]\",\"modelMatrix\":\"0.997697,-0.0584844,0.0343697,0,0.0677866,0.840217,-0.537996,0,0.00258638,0.539087,0.842246,0,-9.2933,-7.87258,-10.443,1\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2024-06-05 15:25:06.000','2024-06-05 13:25:06.000','2024-06-05 15:25:06.000'),('04a9f91f-2976-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/computedocclusion_92d33b38-2963-11ef-9161-de41a781935b/04a9f91f-2976-11ef-9161-de41a781935b.png','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_OCC_92d33b38-2963-11ef-9161-de41a781935b_SCREENO','04a9f91f-2976-11ef-9161-de41a781935b.png','04a9f91f-2976-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Occlusion o1 Capture d\'écran 3\",\"occlusionType\":1,\"title\":\"3\"}','PNG',0,'CREATED',0,NULL,'2024-06-13 13:13:53.290','2024-06-13 11:13:53.376',NULL),('07bca4f6-2969-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/scan_4cc68cd8-2962-11ef-9161-de41a781935b/07bca4f6-2969-11ef-9161-de41a781935b.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_TOSC_4cc68cd8-2962-11ef-9161-de41a781935b_MODEL','07bca4f6-2969-11ef-9161-de41a781935b.zip','809c945c-2962-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Maxillaire u1\",\"modelMatrix\":\"-0.840073,0.531409,-0.109002,0,-0.509977,-0.842143,-0.175265,0,-0.184933,-0.091647,0.978468,0,-3.66908,8.57904,-8.58551,1\",\"scanBodies\":[{\"position\":\"2.06903,5.05438,0,0,-0.995382,0,5.77626,0,6.47861,0,0,4,1,0,0,0\",\"reference\":\"K30PSCANPLG\",\"tid\":26}]}','ZIP',4,'CREATED',0,NULL,'2024-06-13 11:40:54.988','2024-06-13 09:40:55.373',NULL),('07bcc6dd-2969-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/scan_4cc68cd8-2962-11ef-9161-de41a781935b/07bcc6dd-2969-11ef-9161-de41a781935b.png','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_TOSC_4cc68cd8-2962-11ef-9161-de41a781935b_SNAPS','07bcc6dd-2969-11ef-9161-de41a781935b.png','809cb098-2962-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Maxillaire u1 Snapshot\"}','PNG',1,'CREATED',0,NULL,'2024-06-13 11:40:54.989','2024-06-13 09:40:55.374',NULL),('080061b0-2403-11ef-8dde-d415e84cc4f5',2,'/var/iris/.data/2024/2/ce57500b-227c-11ef-8d76-d310d2ec2c14/session_da355fe4-227c-11ef-8d76-d310d2ec2c14/order_da3bcb3f-227c-11ef-8d76-d310d2ec2c14/080061b0-2403-11ef-8dde-d415e84cc4f5.pdf','PATIENT_ce57500b-227c-11ef-8d76-d310d2ec2c14_ACT_da355fe4-227c-11ef-8d76-d310d2ec2c14_PROST_da3bcb3f-227c-11ef-8d76-d310d2ec2c14_FORM','080061b0-2403-11ef-8dde-d415e84cc4f5.pdf','080061b0-2403-11ef-8dde-d415e84cc4f5','{\"displayTitle\":\"3.1 Autre [pc2]\",\"title\":\"Autre\"}','PDF',0,'SYNCED',0,NULL,'2024-06-06 14:48:12.000','2024-06-06 12:48:12.000','2024-06-06 14:48:12.000'),('0b1271da-2988-11ef-8fb0-da2b4bf5ebbb',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_7eb8397d-2987-11ef-8fb0-da2b4bf5ebbb/occlusion_7eb98de9-2987-11ef-8fb0-da2b4bf5ebbb/scan_eec0c27d-2987-11ef-8fb0-da2b4bf5ebbb/0b1271da-2988-11ef-8fb0-da2b4bf5ebbb.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_7eb8397d-2987-11ef-8fb0-da2b4bf5ebbb_SESS_7eb98de9-2987-11ef-8fb0-da2b4bf5ebbb_TOSC_eec0c27d-2987-11ef-8fb0-da2b4bf5ebbb_MODEL','0b1271da-2988-11ef-8fb0-da2b4bf5ebbb.zip','0b1271da-2988-11ef-8fb0-da2b4bf5ebbb','{\"displayTitle\":\"1.5 Maxillaire u1\",\"modelMatrix\":\"-0.990102,0.139413,-0.0161661,0,-0.132311,-0.88878,0.438821,0,0.046809,0.436617,0.898429,0,-7.08259,-4.34357,-12.2019,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2024-06-13 15:22:54.982','2024-06-13 13:22:55.299',NULL),('0b128b86-2988-11ef-8fb0-da2b4bf5ebbb',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_7eb8397d-2987-11ef-8fb0-da2b4bf5ebbb/occlusion_7eb98de9-2987-11ef-8fb0-da2b4bf5ebbb/scan_eec0c27d-2987-11ef-8fb0-da2b4bf5ebbb/0b128b86-2988-11ef-8fb0-da2b4bf5ebbb.png','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_7eb8397d-2987-11ef-8fb0-da2b4bf5ebbb_SESS_7eb98de9-2987-11ef-8fb0-da2b4bf5ebbb_TOSC_eec0c27d-2987-11ef-8fb0-da2b4bf5ebbb_SNAPS','0b128b86-2988-11ef-8fb0-da2b4bf5ebbb.png','0b128b86-2988-11ef-8fb0-da2b4bf5ebbb','{\"displayTitle\":\"1.5 Maxillaire u1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2024-06-13 15:22:54.983','2024-06-13 13:22:55.299',NULL),('0d165e5f-225e-11ef-867c-6ec2958327c0',3,'/var/iris/.data/2024/3/discussion_0f3dfe44-225d-11ef-8f1f-d8242c71b430/0d165e5f-225e-11ef-867c-6ec2958327c0.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_SESS_e3868e5f-225a-11ef-8f1f-d8242c71b430_TOSC_e52279ce-225a-11ef-8f1f-d8242c71b430_SCREENS','9484c123-225d-11ef-8f1f-d8242c71b430.png','0d165e5f-225e-11ef-867c-6ec2958327c0','{\"displayTitle\":\"1.1 Maxillaire u1 Capture d\'écran n°16\",\"title\":\"n°16\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 12:32:41.000','2024-06-04 10:32:41.000','2024-06-04 12:32:41.000'),('0e9a52cd-2988-11ef-8fb0-da2b4bf5ebbb',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_7eb8397d-2987-11ef-8fb0-da2b4bf5ebbb/occlusion_7eb98de9-2987-11ef-8fb0-da2b4bf5ebbb/scan_0d30de55-2988-11ef-8fb0-da2b4bf5ebbb/0e9a52cd-2988-11ef-8fb0-da2b4bf5ebbb.ply','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_7eb8397d-2987-11ef-8fb0-da2b4bf5ebbb_SESS_7eb98de9-2987-11ef-8fb0-da2b4bf5ebbb_TOSC_0d30de55-2988-11ef-8fb0-da2b4bf5ebbb_SEG','0e9a52cd-2988-11ef-8fb0-da2b4bf5ebbb.ply','0e9a52cd-2988-11ef-8fb0-da2b4bf5ebbb','{\"displayTitle\":\"1.5 Maxillaire u2 Segmentation\"}','PLY',0,'CREATED',0,'2024-06-13 15:23:10.277','2024-06-13 15:23:10.278','2024-06-13 13:23:10.278',NULL),('0ed5b8be-225d-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_e3862d66-225a-11ef-8f1f-d8242c71b430/order_e3879e0c-225a-11ef-8f1f-d8242c71b430/0ed5b8be-225d-11ef-8f1f-d8242c71b430.pdf','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_PROST_e3879e0c-225a-11ef-8f1f-d8242c71b430_FORM','0ed5b8be-225d-11ef-8f1f-d8242c71b430.pdf','0ed5b8be-225d-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.1 Guide\",\"title\":\"Guide\"}','PDF',0,'SYNCED',0,NULL,'2024-06-04 12:27:34.796','2024-06-04 10:27:35.476','2024-06-04 12:27:35.655'),('0fed9cbc-2403-11ef-867c-6ec2958327c0',3,'/var/iris/.data/2024/3/discussion_0f3dfe44-225d-11ef-8f1f-d8242c71b430/0fed9cbc-2403-11ef-867c-6ec2958327c0.pdf','PATIENT_ce57500b-227c-11ef-8d76-d310d2ec2c14_ACT_da355fe4-227c-11ef-8d76-d310d2ec2c14_PROST_da3bcb3f-227c-11ef-8d76-d310d2ec2c14_FORM','080061b0-2403-11ef-8dde-d415e84cc4f5.pdf','0fed9cbc-2403-11ef-867c-6ec2958327c0','{\"displayTitle\":\"3.1 Autre [pc2]\",\"title\":\"Autre\"}','PDF',0,'SYNCED',0,NULL,'2024-06-06 14:48:12.000','2024-06-06 12:48:12.000','2024-06-06 14:48:12.000'),('0fef6e20-2403-11ef-867c-6ec2958327c0',3,'/var/iris/.data/2024/3/discussion_0f3dfe44-225d-11ef-8f1f-d8242c71b430/0fef6e20-2403-11ef-867c-6ec2958327c0.zip','PATIENT_ce57500b-227c-11ef-8d76-d310d2ec2c14_ACT_da355fe4-227c-11ef-8d76-d310d2ec2c14_SESS_da37d213-227c-11ef-8d76-d310d2ec2c14_TOSC_e0f66733-227c-11ef-8d76-d310d2ec2c14_MODEL','f51d71ce-227c-11ef-8d76-d310d2ec2c14.zip','0fef6e20-2403-11ef-867c-6ec2958327c0','{\"displayTitle\":\"3.1 Maxillaire u1 [pc2]\",\"modelMatrix\":\"-0.590223,0.739255,-0.324251,0,-0.781697,-0.423166,0.458127,0,0.201461,0.523863,0.827636,0,-1.54469,-10.1967,-10.1611,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 16:16:00.000','2024-06-04 14:16:00.000','2024-06-04 16:16:00.000'),('0fefdd19-2403-11ef-867c-6ec2958327c0',3,'/var/iris/.data/2024/3/discussion_0f3dfe44-225d-11ef-8f1f-d8242c71b430/0fefdd19-2403-11ef-867c-6ec2958327c0.png','PATIENT_ce57500b-227c-11ef-8d76-d310d2ec2c14_ACT_da355fe4-227c-11ef-8d76-d310d2ec2c14_SESS_da37d213-227c-11ef-8d76-d310d2ec2c14_TOSC_e0f66733-227c-11ef-8d76-d310d2ec2c14_SNAPS','f51d8554-227c-11ef-8d76-d310d2ec2c14.png','0fefdd19-2403-11ef-867c-6ec2958327c0','{\"displayTitle\":\"3.1 Maxillaire u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 16:16:00.000','2024-06-04 14:16:00.000','2024-06-04 16:16:00.000'),('10a0d811-2339-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_ef3ba736-2337-11ef-8f93-d92a45da78c9/10a0d811-2339-11ef-8f93-d92a45da78c9.xyz','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_TOSC_ef3ba736-2337-11ef-8f93-d92a45da78c9_LIFI','10a0d811-2339-11ef-8f93-d92a45da78c9.xyz','10a0d811-2339-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Maxillaire u1 Ligne de finition manuelle [pc1]\",\"title\":\"manuelle\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-05 14:42:27.000','2024-06-05 12:42:38.000','2024-06-05 14:42:38.000'),('10a0db7f-2339-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_ef3ba736-2337-11ef-8f93-d92a45da78c9/10a0db7f-2339-11ef-8f93-d92a45da78c9.bin','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_TOSC_ef3ba736-2337-11ef-8f93-d92a45da78c9_LIFIM','10a0db7f-2339-11ef-8f93-d92a45da78c9.bin','10a0db7f-2339-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Maxillaire u1 Ligne de finition métadonnées manuelle [pc1]\",\"title\":\"manuelle\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-05 14:42:27.000','2024-06-05 12:42:38.000','2024-06-05 14:42:38.000'),('10a34539-2339-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/computedocclusion_a2829ff3-2338-11ef-8f93-d92a45da78c9/10a34539-2339-11ef-8f93-d92a45da78c9.xyz','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_OCC_a2829ff3-2338-11ef-8f93-d92a45da78c9_LIFIO','10a34539-2339-11ef-8f93-d92a45da78c9.xyz','10a34539-2339-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Occlusion o1 Maxillaire u1 Ligne de finition manuelle [pc1]\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY_1\",\"referenceScanFullDisplayId\":\"1.5_u1\",\"referenceScanId\":\"ef3ba736-2337-11ef-8f93-d92a45da78c9\",\"title\":\"manuelle\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-05 14:42:27.000','2024-06-05 12:51:42.000','2024-06-05 14:51:42.000'),('10a347ba-2339-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/computedocclusion_a2829ff3-2338-11ef-8f93-d92a45da78c9/10a347ba-2339-11ef-8f93-d92a45da78c9.bin','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_OCC_a2829ff3-2338-11ef-8f93-d92a45da78c9_LIFIMO','10a347ba-2339-11ef-8f93-d92a45da78c9.bin','10a347ba-2339-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Occlusion o1 Maxillaire u1 Ligne de finition métadonnées manuelle [pc1]\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY_1\",\"referenceScanFullDisplayId\":\"1.5_u1\",\"referenceScanId\":\"ef3ba736-2337-11ef-8f93-d92a45da78c9\",\"title\":\"manuelle\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-05 14:42:27.000','2024-06-05 12:51:42.000','2024-06-05 14:51:42.000'),('1171b033-225d-11ef-867c-6ec2958327c0',3,'/var/iris/.data/2024/3/discussion_0f3dfe44-225d-11ef-8f1f-d8242c71b430/1171b033-225d-11ef-867c-6ec2958327c0.pdf','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_PROST_e3879e0c-225a-11ef-8f1f-d8242c71b430_FORM','0ed5b8be-225d-11ef-8f1f-d8242c71b430.pdf','1171b033-225d-11ef-867c-6ec2958327c0','{\"displayTitle\":\"1.1 Guide\",\"title\":\"Guide\"}','PDF',0,'SYNCED',0,NULL,'2024-06-04 12:27:35.000','2024-06-04 10:27:35.000','2024-06-04 12:27:35.000'),('117372ab-225d-11ef-867c-6ec2958327c0',3,'/var/iris/.data/2024/3/discussion_0f3dfe44-225d-11ef-8f1f-d8242c71b430/117372ab-225d-11ef-867c-6ec2958327c0.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_SESS_e3868e5f-225a-11ef-8f1f-d8242c71b430_TOSC_e52279ce-225a-11ef-8f1f-d8242c71b430_MODEL','326e28f0-225b-11ef-8f1f-d8242c71b430.zip','117372ab-225d-11ef-867c-6ec2958327c0','{\"displayTitle\":\"1.1 Maxillaire u1\",\"modelMatrix\":\"0.983821,-0.178562,-0.0145353,0,0.167676,0.946334,-0.276291,0,0.0630904,0.269384,0.960964,0,-18.4738,6.44284,-12.9473,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 12:14:21.000','2024-06-04 10:14:21.000','2024-06-04 12:14:21.000'),('1173c2f4-225d-11ef-867c-6ec2958327c0',3,'/var/iris/.data/2024/3/discussion_0f3dfe44-225d-11ef-8f1f-d8242c71b430/1173c2f4-225d-11ef-867c-6ec2958327c0.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_SESS_e3868e5f-225a-11ef-8f1f-d8242c71b430_TOSC_e52279ce-225a-11ef-8f1f-d8242c71b430_SNAPS','326e3f34-225b-11ef-8f1f-d8242c71b430.png','1173c2f4-225d-11ef-867c-6ec2958327c0','{\"displayTitle\":\"1.1 Maxillaire u1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 12:14:21.000','2024-06-04 10:14:21.000','2024-06-04 12:14:21.000'),('1174111e-225d-11ef-867c-6ec2958327c0',3,'/var/iris/.data/2024/3/discussion_0f3dfe44-225d-11ef-8f1f-d8242c71b430/1174111e-225d-11ef-867c-6ec2958327c0.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_SESS_e3868e5f-225a-11ef-8f1f-d8242c71b430_BOSC_37ccba29-225b-11ef-8f1f-d8242c71b430_MODEL','6782502c-225b-11ef-8f1f-d8242c71b430.zip','1174111e-225d-11ef-867c-6ec2958327c0','{\"displayTitle\":\"1.1 Mandibule l1\",\"modelMatrix\":\"-0.728037,0.684478,-0.03811,0,-0.685353,-0.725423,0.0636657,0,0.0159319,0.0724698,0.997243,0,9.49558,-10.7,-12.9454,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 12:15:47.000','2024-06-04 10:15:47.000','2024-06-04 12:15:47.000'),('11745799-225d-11ef-867c-6ec2958327c0',3,'/var/iris/.data/2024/3/discussion_0f3dfe44-225d-11ef-8f1f-d8242c71b430/11745799-225d-11ef-867c-6ec2958327c0.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_SESS_e3868e5f-225a-11ef-8f1f-d8242c71b430_BOSC_37ccba29-225b-11ef-8f1f-d8242c71b430_SNAPS','67825ce8-225b-11ef-8f1f-d8242c71b430.png','11745799-225d-11ef-867c-6ec2958327c0','{\"displayTitle\":\"1.1 Mandibule l1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 12:15:47.000','2024-06-04 10:15:47.000','2024-06-04 12:15:47.000'),('11749a5a-225d-11ef-867c-6ec2958327c0',3,'/var/iris/.data/2024/3/discussion_0f3dfe44-225d-11ef-8f1f-d8242c71b430/11749a5a-225d-11ef-867c-6ec2958327c0.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_SESS_e3868e5f-225a-11ef-8f1f-d8242c71b430_OCC_6ba502f4-225b-11ef-8f1f-d8242c71b430_TO1','e000eb20-225b-11ef-8f1f-d8242c71b430.zip','11749a5a-225d-11ef-867c-6ec2958327c0','{\"displayTitle\":\"1.1 Occlusion o1 Maxillaire u1\",\"modelMatrix\":\"0.983821,-0.178562,-0.0145353,0,0.167676,0.946334,-0.276291,0,0.0630904,0.269384,0.960964,0,-18.4738,6.44284,-12.9473,1\",\"occlusionMatrix\":\"-0.983067,0.0412191,-0.180339,0,0.183184,0.197784,-0.962563,0,-0.00759549,-0.979387,-0.202378,0,17.9497,7.67706,6.6371,1\",\"occlusionType\":2,\"referenceScanFullDisplayId\":\"1.1_u1\",\"referenceScanId\":\"e52279ce-225a-11ef-8f1f-d8242c71b430\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 12:19:09.000','2024-06-04 10:19:09.000','2024-06-04 12:19:09.000'),('117c269a-225d-11ef-867c-6ec2958327c0',3,'/var/iris/.data/2024/3/discussion_0f3dfe44-225d-11ef-8f1f-d8242c71b430/117c269a-225d-11ef-867c-6ec2958327c0.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_SESS_e3868e5f-225a-11ef-8f1f-d8242c71b430_OCC_6ba502f4-225b-11ef-8f1f-d8242c71b430_BO1','e01bae07-225b-11ef-8f1f-d8242c71b430.zip','117c269a-225d-11ef-867c-6ec2958327c0','{\"displayTitle\":\"1.1 Occlusion o1 Mandibule l1\",\"modelMatrix\":\"-0.728037,0.684478,-0.03811,0,-0.685353,-0.725423,0.0636657,0,0.0159319,0.0724698,0.997243,0,9.49558,-10.7,-12.9454,1\",\"occlusionMatrix\":\"-0.985853,-0.13039,-0.111741,0,-0.134966,0.214901,0.966923,0,-0.0995888,0.967905,-0.229331,0,6.18786,-8.33646,11.3454,1\",\"occlusionType\":2,\"referenceScanFullDisplayId\":\"1.1_l1\",\"referenceScanId\":\"37ccba29-225b-11ef-8f1f-d8242c71b430\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 12:19:11.000','2024-06-04 10:19:11.000','2024-06-04 12:19:11.000'),('117c6e59-225d-11ef-867c-6ec2958327c0',3,'/var/iris/.data/2024/3/discussion_0f3dfe44-225d-11ef-8f1f-d8242c71b430/117c6e59-225d-11ef-867c-6ec2958327c0.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_SESS_e3868e5f-225a-11ef-8f1f-d8242c71b430_OCC_6ba502f4-225b-11ef-8f1f-d8242c71b430_SNAPO','e091c2ff-225b-11ef-8f1f-d8242c71b430.png','117c6e59-225d-11ef-867c-6ec2958327c0','{\"displayTitle\":\"1.1 Occlusion o1\",\"occlusionType\":2}','PNG',0,'SYNCED',0,NULL,'2024-06-04 12:19:11.000','2024-06-04 10:19:11.000','2024-06-04 12:19:11.000'),('1257d8b3-2898-11ef-8f6f-d9283dbaec71',3,'/var/iris/.data/2024/3/e90d651d-2897-11ef-8f6f-d9283dbaec71/session_e90de9ef-2897-11ef-8f6f-d9283dbaec71/occlusion_e90e3796-2897-11ef-8f6f-d9283dbaec71/scan_ea48ab1e-2897-11ef-8f6f-d9283dbaec71/1257d8b3-2898-11ef-8f6f-d9283dbaec71.zip','PATIENT_e90d651d-2897-11ef-8f6f-d9283dbaec71_ACT_e90de9ef-2897-11ef-8f6f-d9283dbaec71_SESS_e90e3796-2897-11ef-8f6f-d9283dbaec71_TOSC_ea48ab1e-2897-11ef-8f6f-d9283dbaec71_MODEL','1257d8b3-2898-11ef-8f6f-d9283dbaec71.zip','1257d8b3-2898-11ef-8f6f-d9283dbaec71','{\"displayTitle\":\"2.1 Maxillaire u1 [pc2]\",\"modelMatrix\":\"0.985137,0.0158763,-0.171035,0,-0.00828288,0.998952,0.0450196,0,0.171571,-0.0429338,0.984236,0,9.47563,-1.42759,-15.6222,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',1,NULL,'2024-06-12 10:45:07.966','2024-06-12 08:45:08.261',NULL),('1257f100-2898-11ef-8f6f-d9283dbaec71',3,'/var/iris/.data/2024/3/e90d651d-2897-11ef-8f6f-d9283dbaec71/session_e90de9ef-2897-11ef-8f6f-d9283dbaec71/occlusion_e90e3796-2897-11ef-8f6f-d9283dbaec71/scan_ea48ab1e-2897-11ef-8f6f-d9283dbaec71/1257f100-2898-11ef-8f6f-d9283dbaec71.png','PATIENT_e90d651d-2897-11ef-8f6f-d9283dbaec71_ACT_e90de9ef-2897-11ef-8f6f-d9283dbaec71_SESS_e90e3796-2897-11ef-8f6f-d9283dbaec71_TOSC_ea48ab1e-2897-11ef-8f6f-d9283dbaec71_SNAPS','1257f100-2898-11ef-8f6f-d9283dbaec71.png','1257f100-2898-11ef-8f6f-d9283dbaec71','{\"displayTitle\":\"2.1 Maxillaire u1 Snapshot [pc2]\"}','PNG',0,'CREATED',1,NULL,'2024-06-12 10:45:07.966','2024-06-12 08:45:08.262',NULL),('12ac60c2-2968-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/computedocclusion_784469a2-2967-11ef-9161-de41a781935b/12ac60c2-2968-11ef-9161-de41a781935b.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_OCC_784469a2-2967-11ef-9161-de41a781935b_BO1','12ac60c2-2968-11ef-9161-de41a781935b.zip','9dbc599e-2967-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Occlusion o3 Mandibule l1\",\"modelMatrix\":\"0.96054,0.0160431,-0.277679,0,-0.0791538,0.972823,-0.217602,0,0.266641,0.230994,0.935705,0,-9.25344,-4.26872,-6.69421,1\",\"occlusionMatrix\":\"-0.855192,0.518382,-0.00749868,0,-0.146509,-0.255509,-0.955693,0,-0.497316,-0.816127,0.294444,0,15.2907,10.377,3.13492,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.1_l1\",\"referenceScanId\":\"b926a968-2962-11ef-9161-de41a781935b\",\"scanBodies\":[]}','ZIP',4,'CREATED',0,'2024-06-13 11:34:38.657','2024-06-13 11:34:38.657','2024-06-13 09:34:38.658',NULL),('1ad1adb2-233a-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_ef3ba736-2337-11ef-8f93-d92a45da78c9/1ad1adb2-233a-11ef-8f93-d92a45da78c9.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_TOSC_ef3ba736-2337-11ef-8f93-d92a45da78c9_SCREENS','1ad1adb2-233a-11ef-8f93-d92a45da78c9.png','1ad1adb2-233a-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Maxillaire u1 Capture d\'écran 1 [pc1]\",\"title\":\"1\"}','PNG',0,'SYNCED',0,NULL,'2024-06-05 14:49:55.000','2024-06-05 12:49:55.000','2024-06-05 14:49:55.000'),('1b63f36c-2269-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_757ed4bc-2266-11ef-8f1f-d8242c71b430/occlusion_75806ee1-2266-11ef-8f1f-d8242c71b430/scan_09768650-2267-11ef-8f1f-d8242c71b430/1b63f36c-2269-11ef-8f1f-d8242c71b430.xyz','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_TOSC_09768650-2267-11ef-8f1f-d8242c71b430_LIFI','1b63f36c-2269-11ef-8f1f-d8242c71b430.xyz','1b63f36c-2269-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.2 Maxillaire u1 Ligne de finition auto\",\"title\":\"auto\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-04 13:53:49.822','2024-06-04 11:55:49.469','2024-06-04 13:55:49.471'),('1b63f931-2269-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_757ed4bc-2266-11ef-8f1f-d8242c71b430/occlusion_75806ee1-2266-11ef-8f1f-d8242c71b430/scan_09768650-2267-11ef-8f1f-d8242c71b430/1b63f931-2269-11ef-8f1f-d8242c71b430.bin','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_TOSC_09768650-2267-11ef-8f1f-d8242c71b430_LIFIM','1b63f931-2269-11ef-8f1f-d8242c71b430.bin','1b63f931-2269-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.2 Maxillaire u1 Ligne de finition métadonnées auto\",\"title\":\"auto\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-04 13:53:49.000','2024-06-04 11:55:50.000','2024-06-04 13:55:50.000'),('1b66dafd-2269-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_757ed4bc-2266-11ef-8f1f-d8242c71b430/occlusion_75806ee1-2266-11ef-8f1f-d8242c71b430/computedocclusion_0b16efeb-2268-11ef-8f1f-d8242c71b430/1b66dafd-2269-11ef-8f1f-d8242c71b430.xyz','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_OCC_0b16efeb-2268-11ef-8f1f-d8242c71b430_LIFIO','1b66dafd-2269-11ef-8f1f-d8242c71b430.xyz','1b66dafd-2269-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.2 Occlusion o1 Maxillaire u1 Ligne de finition auto\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY_1\",\"referenceScanFullDisplayId\":\"1.2_u1\",\"referenceScanId\":\"09768650-2267-11ef-8f1f-d8242c71b430\",\"title\":\"auto\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-04 13:53:49.000','2024-06-04 11:55:50.000','2024-06-04 13:55:50.000'),('1b66de9f-2269-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_757ed4bc-2266-11ef-8f1f-d8242c71b430/occlusion_75806ee1-2266-11ef-8f1f-d8242c71b430/computedocclusion_0b16efeb-2268-11ef-8f1f-d8242c71b430/1b66de9f-2269-11ef-8f1f-d8242c71b430.bin','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_OCC_0b16efeb-2268-11ef-8f1f-d8242c71b430_LIFIMO','1b66de9f-2269-11ef-8f1f-d8242c71b430.bin','1b66de9f-2269-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.2 Occlusion o1 Maxillaire u1 Ligne de finition métadonnées auto\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY_1\",\"referenceScanFullDisplayId\":\"1.2_u1\",\"referenceScanId\":\"09768650-2267-11ef-8f1f-d8242c71b430\",\"title\":\"auto\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-04 13:53:49.841','2024-06-04 11:55:49.479','2024-06-04 13:55:49.481'),('1c9626b7-2279-11ef-8d76-d310d2ec2c14',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/computedocclusion_9ed6352b-2277-11ef-8d76-d310d2ec2c14/1c9626b7-2279-11ef-8d76-d310d2ec2c14.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_OCC_9ed6352b-2277-11ef-8d76-d310d2ec2c14_SCREENO','1c9626b7-2279-11ef-8d76-d310d2ec2c14.png','1c9626b7-2279-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Occlusion o2 Capture d\'écran 1 [pc2]\",\"occlusionType\":5,\"title\":\"1\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 15:48:25.000','2024-06-04 13:48:25.000','2024-06-04 15:48:25.000'),('1f8131a8-2973-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_11bc8a6c-2973-11ef-9161-de41a781935b/occlusion_11be1b4d-2973-11ef-9161-de41a781935b/scan_129f0828-2973-11ef-9161-de41a781935b/1f8131a8-2973-11ef-9161-de41a781935b.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_11bc8a6c-2973-11ef-9161-de41a781935b_SESS_11be1b4d-2973-11ef-9161-de41a781935b_TOSC_129f0828-2973-11ef-9161-de41a781935b_MODEL','1f8131a8-2973-11ef-9161-de41a781935b.zip','1f8131a8-2973-11ef-9161-de41a781935b','{\"displayTitle\":\"1.2 Maxillaire u1\",\"modelMatrix\":\"0.0154815,0.999549,0.0257477,0,-0.702085,0.0292019,-0.711494,0,-0.711924,-0.00706207,0.702221,0,6.8028,5.19037,-2.91295,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2024-06-13 12:53:09.831','2024-06-13 10:53:10.025',NULL),('1f814538-2973-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_11bc8a6c-2973-11ef-9161-de41a781935b/occlusion_11be1b4d-2973-11ef-9161-de41a781935b/scan_129f0828-2973-11ef-9161-de41a781935b/1f814538-2973-11ef-9161-de41a781935b.png','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_11bc8a6c-2973-11ef-9161-de41a781935b_SESS_11be1b4d-2973-11ef-9161-de41a781935b_TOSC_129f0828-2973-11ef-9161-de41a781935b_SNAPS','1f814538-2973-11ef-9161-de41a781935b.png','1f814538-2973-11ef-9161-de41a781935b','{\"displayTitle\":\"1.2 Maxillaire u1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2024-06-13 12:53:09.831','2024-06-13 10:53:10.025',NULL),('1ffb9e9c-2338-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_ef3ba736-2337-11ef-8f93-d92a45da78c9/1ffb9e9c-2338-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_TOSC_ef3ba736-2337-11ef-8f93-d92a45da78c9_MODEL','1ffb9e9c-2338-11ef-8f93-d92a45da78c9.zip','1ffb9e9c-2338-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Maxillaire u1 [pc1]\",\"modelMatrix\":\"-0.923468,0.0376561,-0.381824,0,-0.158116,-0.944087,0.289308,0,-0.349581,0.327539,0.877788,0,12.8471,-2.21044,-5.73295,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-05 14:35:47.000','2024-06-05 12:35:47.000','2024-06-05 14:35:47.000'),('1ffbaca6-2338-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_ef3ba736-2337-11ef-8f93-d92a45da78c9/1ffbaca6-2338-11ef-8f93-d92a45da78c9.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_TOSC_ef3ba736-2337-11ef-8f93-d92a45da78c9_SNAPS','1ffbaca6-2338-11ef-8f93-d92a45da78c9.png','1ffbaca6-2338-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Maxillaire u1 Snapshot [pc1]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-05 14:35:48.000','2024-06-05 12:35:48.000','2024-06-05 14:35:48.000'),('22b133bf-2968-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/computedocclusion_784469a2-2967-11ef-9161-de41a781935b/22b133bf-2968-11ef-9161-de41a781935b.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_OCC_784469a2-2967-11ef-9161-de41a781935b_TO1','22b133bf-2968-11ef-9161-de41a781935b.zip','9da74cf3-2967-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Occlusion o3 Maxillaire u2\",\"modelMatrix\":\"-0.872758,0.470809,-0.128964,0,-0.443838,-0.875321,-0.191887,0,-0.203227,-0.110232,0.972907,0,-2.56858,6.47103,-8.11483,1\",\"occlusionMatrix\":\"0.97099,-0.239094,0.00436749,0,-0.161947,-0.670916,-0.72364,0,0.175945,0.701935,-0.690172,0,2.00518,7.81104,8.76363,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.1_u2\",\"referenceScanId\":\"5a97f8c0-2967-11ef-9161-de41a781935b\",\"scanBodies\":[]}','ZIP',1,'CREATED',0,'2024-06-13 11:34:34.519','2024-06-13 11:34:34.519','2024-06-13 09:34:34.520',NULL),('233f92af-2969-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/scan_4cc68cd8-2962-11ef-9161-de41a781935b/233f92af-2969-11ef-9161-de41a781935b.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_TOSC_4cc68cd8-2962-11ef-9161-de41a781935b_MODEL','233f92af-2969-11ef-9161-de41a781935b.zip','809c945c-2962-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Maxillaire u1\",\"modelMatrix\":\"-0.840073,0.531409,-0.109002,0,-0.509977,-0.842143,-0.175265,0,-0.184933,-0.091647,0.978468,0,-3.66908,8.57904,-8.58551,1\",\"scanBodies\":[{\"position\":\"2.06903,5.05438,0,0,-0.995382,0,5.77626,0,6.47861,0,0,4,1,0,0,0\",\"reference\":\"K30PSCANPLG\",\"tid\":26}]}','ZIP',5,'CREATED',0,NULL,'2024-06-13 11:41:41.144','2024-06-13 09:41:41.180',NULL),('242c6766-23e9-11ef-8dde-d415e84cc4f5',3,'/var/iris/.data/2024/3/907398e3-23e7-11ef-8dde-d415e84cc4f5/session_0bcc91ed-23e9-11ef-8dde-d415e84cc4f5/occlusion_0bcebe79-23e9-11ef-8dde-d415e84cc4f5/scan_0d3f3b92-23e9-11ef-8dde-d415e84cc4f5/242c6766-23e9-11ef-8dde-d415e84cc4f5.zip','PATIENT_907398e3-23e7-11ef-8dde-d415e84cc4f5_ACT_0bcc91ed-23e9-11ef-8dde-d415e84cc4f5_SESS_0bcebe79-23e9-11ef-8dde-d415e84cc4f5_TOSC_0d3f3b92-23e9-11ef-8dde-d415e84cc4f5_MODEL','242c6766-23e9-11ef-8dde-d415e84cc4f5.zip','242c6766-23e9-11ef-8dde-d415e84cc4f5','{\"displayTitle\":\"2.2 Maxillaire u1 [pc1]\",\"modelMatrix\":\"-0.98612,0.162098,-0.0359523,0,-0.162664,-0.899746,0.404967,0,0.0332962,0.405194,0.913624,0,8.13953,-5.86615,-13.6249,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-06 11:42:54.000','2024-06-06 09:42:54.000','2024-06-06 11:42:54.000'),('242c7d2a-23e9-11ef-8dde-d415e84cc4f5',3,'/var/iris/.data/2024/3/907398e3-23e7-11ef-8dde-d415e84cc4f5/session_0bcc91ed-23e9-11ef-8dde-d415e84cc4f5/occlusion_0bcebe79-23e9-11ef-8dde-d415e84cc4f5/scan_0d3f3b92-23e9-11ef-8dde-d415e84cc4f5/242c7d2a-23e9-11ef-8dde-d415e84cc4f5.png','PATIENT_907398e3-23e7-11ef-8dde-d415e84cc4f5_ACT_0bcc91ed-23e9-11ef-8dde-d415e84cc4f5_SESS_0bcebe79-23e9-11ef-8dde-d415e84cc4f5_TOSC_0d3f3b92-23e9-11ef-8dde-d415e84cc4f5_SNAPS','242c7d2a-23e9-11ef-8dde-d415e84cc4f5.png','242c7d2a-23e9-11ef-8dde-d415e84cc4f5','{\"displayTitle\":\"2.2 Maxillaire u1 Snapshot [pc1]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-06 11:42:55.000','2024-06-06 09:42:55.000','2024-06-06 11:42:55.000'),('270a71cb-2976-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/computedocclusion_92d33b38-2963-11ef-9161-de41a781935b/270a71cb-2976-11ef-9161-de41a781935b.json','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_OCC_92d33b38-2963-11ef-9161-de41a781935b_METER','270a71cb-2976-11ef-9161-de41a781935b.json','84059dad-2974-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Occlusion o1\",\"occlusionType\":1}','JSON',2,'CREATED',0,NULL,'2024-06-13 13:14:50.965','2024-06-13 11:14:50.967',NULL),('275970f2-2279-11ef-8d76-d310d2ec2c14',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/scan_96d08283-2273-11ef-8d76-d310d2ec2c14/275970f2-2279-11ef-8d76-d310d2ec2c14.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_BOSC_96d08283-2273-11ef-8d76-d310d2ec2c14_MODEL','275970f2-2279-11ef-8d76-d310d2ec2c14.zip','3e218de7-2274-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Mandibule l1 [pc2]\",\"modelMatrix\":\"0.135656,-0.982642,-0.126536,0,0.970104,0.157682,-0.184485,0,0.201235,-0.0977264,0.974656,0,-23.8369,18.6095,-10.139,1\",\"scanBodies\":[],\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":3,\"socleIsFullArch\":true,\"socleThickness\":-1,\"socleType\":1}','ZIP',1,'SYNCED',0,NULL,'2024-06-04 15:48:42.000','2024-06-04 13:48:42.000','2024-06-04 15:48:42.000'),('29a36c35-2343-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_09ea2f4d-2343-11ef-8f93-d92a45da78c9/occlusion_09ebd700-2343-11ef-8f93-d92a45da78c9/scan_0ab76b82-2343-11ef-8f93-d92a45da78c9/29a36c35-2343-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_09ea2f4d-2343-11ef-8f93-d92a45da78c9_SESS_09ebd700-2343-11ef-8f93-d92a45da78c9_BOSC_0ab76b82-2343-11ef-8f93-d92a45da78c9_MODEL','29a36c35-2343-11ef-8f93-d92a45da78c9.zip','29a36c35-2343-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.7 Mandibule l1 [pc1]\",\"modelMatrix\":\"-0.982683,0.152983,-0.104545,0,-0.159932,-0.985202,0.0616388,0,-0.0935683,0.0772916,0.992608,0,3.96441,0.308408,-12.1362,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-05 15:54:47.000','2024-06-05 13:54:47.000','2024-06-05 15:54:47.000'),('29a3891a-2343-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_09ea2f4d-2343-11ef-8f93-d92a45da78c9/occlusion_09ebd700-2343-11ef-8f93-d92a45da78c9/scan_0ab76b82-2343-11ef-8f93-d92a45da78c9/29a3891a-2343-11ef-8f93-d92a45da78c9.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_09ea2f4d-2343-11ef-8f93-d92a45da78c9_SESS_09ebd700-2343-11ef-8f93-d92a45da78c9_BOSC_0ab76b82-2343-11ef-8f93-d92a45da78c9_SNAPS','29a3891a-2343-11ef-8f93-d92a45da78c9.png','29a3891a-2343-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.7 Mandibule l1 Snapshot [pc1]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-05 15:54:48.000','2024-06-05 13:54:48.000','2024-06-05 15:54:48.000'),('2aaec82c-2268-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_757ed4bc-2266-11ef-8f1f-d8242c71b430/occlusion_75806ee1-2266-11ef-8f1f-d8242c71b430/scan_0cfe6c2e-2268-11ef-8f1f-d8242c71b430/2aaec82c-2268-11ef-8f1f-d8242c71b430.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_LESC_0cfe6c2e-2268-11ef-8f1f-d8242c71b430_MODEL','2aaec82c-2268-11ef-8f1f-d8242c71b430.zip','2aaec82c-2268-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.2 Mordu gauche bl1\",\"modelMatrix\":\"-0.998385,-0.0348991,-0.0505024,0,0.0346529,-0.998235,0.0494801,0,-0.045548,0.048094,0.99752,0,-5.85175,0.300441,-5.79008,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 13:47:08.000','2024-06-04 11:47:08.000','2024-06-04 13:47:08.000'),('2aaed5db-2268-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_757ed4bc-2266-11ef-8f1f-d8242c71b430/occlusion_75806ee1-2266-11ef-8f1f-d8242c71b430/scan_0cfe6c2e-2268-11ef-8f1f-d8242c71b430/2aaed5db-2268-11ef-8f1f-d8242c71b430.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_LESC_0cfe6c2e-2268-11ef-8f1f-d8242c71b430_SNAPS','2aaed5db-2268-11ef-8f1f-d8242c71b430.png','2aaed5db-2268-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.2 Mordu gauche bl1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 13:47:08.000','2024-06-04 11:47:08.000','2024-06-04 13:47:08.000'),('2cf3311a-2272-11ef-8d76-d310d2ec2c14',2,'/var/iris/.data/2024/2/a1ace9b5-2271-11ef-8d76-d310d2ec2c14/session_afa6cb0d-2271-11ef-8d76-d310d2ec2c14/order_afad1449-2271-11ef-8d76-d310d2ec2c14/2cf3311a-2272-11ef-8d76-d310d2ec2c14.pdf','PATIENT_a1ace9b5-2271-11ef-8d76-d310d2ec2c14_ACT_afa6cb0d-2271-11ef-8d76-d310d2ec2c14_PROST_afad1449-2271-11ef-8d76-d310d2ec2c14_FORM','2cf3311a-2272-11ef-8d76-d310d2ec2c14.pdf','2cf3311a-2272-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"2.1 Facette [pc2]\",\"title\":\"Facette\"}','PDF',0,'SYNCED',0,NULL,'2024-06-04 14:58:45.000','2024-06-04 12:58:45.000','2024-06-04 14:58:45.000'),('2e1492f1-233a-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_2e146f3d-233a-11ef-8f93-d92a45da78c9/2e1492f1-233a-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_TOSC_2e146f3d-233a-11ef-8f93-d92a45da78c9_MODEL','2e1492f1-233a-11ef-8f93-d92a45da78c9.zip','2e1492f1-233a-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Maxillaire u2 [pc1]\",\"modelMatrix\":\"-0.923468,0.0376561,-0.381824,0,-0.158116,-0.944087,0.289308,0,-0.349581,0.327539,0.877788,0,12.8471,-2.21044,-5.73295,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-05 14:50:30.000','2024-06-05 12:50:30.000','2024-06-05 14:50:30.000'),('2e19276e-233a-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_2e146f3d-233a-11ef-8f93-d92a45da78c9/2e19276e-233a-11ef-8f93-d92a45da78c9.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_TOSC_2e146f3d-233a-11ef-8f93-d92a45da78c9_SNAPS','2e19276e-233a-11ef-8f93-d92a45da78c9.png','2e19276e-233a-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Maxillaire u2 Snapshot [pc1]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-05 14:50:30.000','2024-06-05 12:50:30.000','2024-06-05 14:50:30.000'),('2e1935ab-233a-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_2e146f3d-233a-11ef-8f93-d92a45da78c9/2e1935ab-233a-11ef-8f93-d92a45da78c9.xyz','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_TOSC_2e146f3d-233a-11ef-8f93-d92a45da78c9_LIFI','2e1935ab-233a-11ef-8f93-d92a45da78c9.xyz','2e1935ab-233a-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Maxillaire u2 Ligne de finition manuelle [pc1]\",\"title\":\"manuelle\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,'2024-06-05 14:52:40.231','2024-06-05 14:50:26.025','2024-06-05 12:52:40.232','2024-06-05 14:52:40.234'),('2e194339-233a-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_2e146f3d-233a-11ef-8f93-d92a45da78c9/2e194339-233a-11ef-8f93-d92a45da78c9.bin','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_TOSC_2e146f3d-233a-11ef-8f93-d92a45da78c9_LIFIM','2e194339-233a-11ef-8f93-d92a45da78c9.bin','2e194339-233a-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Maxillaire u2 Ligne de finition métadonnées manuelle [pc1]\",\"title\":\"manuelle\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,'2024-06-05 14:52:41.000','2024-06-05 14:50:31.000','2024-06-05 12:52:41.000','2024-06-05 14:52:41.000'),('307ab64c-2279-11ef-8d76-d310d2ec2c14',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/order_f26746c9-2272-11ef-8d76-d310d2ec2c14/307ab64c-2279-11ef-8d76-d310d2ec2c14.pdf','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_PROST_f26746c9-2272-11ef-8d76-d310d2ec2c14_FORM','307ab64c-2279-11ef-8d76-d310d2ec2c14.pdf','307ab64c-2279-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Autre [pc2]\",\"title\":\"Autre\"}','PDF',0,'SYNCED',0,NULL,'2024-06-04 15:48:59.000','2024-06-04 13:48:59.000','2024-06-04 15:48:59.000'),('30880f4c-2969-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/scan_4cc68cd8-2962-11ef-9161-de41a781935b/30880f4c-2969-11ef-9161-de41a781935b.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_TOSC_4cc68cd8-2962-11ef-9161-de41a781935b_MODEL','30880f4c-2969-11ef-9161-de41a781935b.zip','809c945c-2962-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Maxillaire u1\",\"modelMatrix\":\"-0.840073,0.531409,-0.109002,0,-0.509977,-0.842143,-0.175265,0,-0.184933,-0.091647,0.978468,0,-3.66908,8.57904,-8.58551,1\",\"scanBodies\":[{\"position\":\"2.06903,5.05438,0,0,-0.995382,0,5.77626,0,6.47861,0,0,4,1,0,0,0\",\"reference\":\"K30PSCANPLG\",\"tid\":26}]}','ZIP',6,'CREATED',0,NULL,'2024-06-13 11:42:03.430','2024-06-13 09:42:03.470',NULL),('310f2987-233f-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_8c23d690-233c-11ef-8f93-d92a45da78c9/occlusion_8c257d6d-233c-11ef-8f93-d92a45da78c9/scan_93bdd6ef-233c-11ef-8f93-d92a45da78c9/310f2987-233f-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_8c23d690-233c-11ef-8f93-d92a45da78c9_SESS_8c257d6d-233c-11ef-8f93-d92a45da78c9_TOSC_93bdd6ef-233c-11ef-8f93-d92a45da78c9_MODEL','310f2987-233f-11ef-8f93-d92a45da78c9.zip','acfa30bf-233c-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.6 Maxillaire u1 [pc1]\",\"modelMatrix\":\"0.997697,-0.0584844,0.0343697,0,0.0677866,0.840217,-0.537996,0,0.00258638,0.539087,0.842246,0,-9.2933,-7.87258,-10.443,1\",\"scanBodies\":[]}','ZIP',2,'SYNCED',0,NULL,'2024-06-05 15:26:21.000','2024-06-05 13:26:21.000','2024-06-05 15:26:21.000'),('326e28f0-225b-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_e3862d66-225a-11ef-8f1f-d8242c71b430/occlusion_e3868e5f-225a-11ef-8f1f-d8242c71b430/scan_e52279ce-225a-11ef-8f1f-d8242c71b430/326e28f0-225b-11ef-8f1f-d8242c71b430.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_SESS_e3868e5f-225a-11ef-8f1f-d8242c71b430_TOSC_e52279ce-225a-11ef-8f1f-d8242c71b430_MODEL','326e28f0-225b-11ef-8f1f-d8242c71b430.zip','326e28f0-225b-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.1 Maxillaire u1\",\"modelMatrix\":\"0.983821,-0.178562,-0.0145353,0,0.167676,0.946334,-0.276291,0,0.0630904,0.269384,0.960964,0,-18.4738,6.44284,-12.9473,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 12:14:21.000','2024-06-04 10:14:21.000','2024-06-04 12:14:21.000'),('326e3f34-225b-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_e3862d66-225a-11ef-8f1f-d8242c71b430/occlusion_e3868e5f-225a-11ef-8f1f-d8242c71b430/scan_e52279ce-225a-11ef-8f1f-d8242c71b430/326e3f34-225b-11ef-8f1f-d8242c71b430.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_SESS_e3868e5f-225a-11ef-8f1f-d8242c71b430_TOSC_e52279ce-225a-11ef-8f1f-d8242c71b430_SNAPS','326e3f34-225b-11ef-8f1f-d8242c71b430.png','326e3f34-225b-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.1 Maxillaire u1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 12:14:21.000','2024-06-04 10:14:21.000','2024-06-04 12:14:21.000'),('336ff6af-23e9-11ef-8dde-d415e84cc4f5',3,'/var/iris/.data/2024/3/907398e3-23e7-11ef-8dde-d415e84cc4f5/session_0bcc91ed-23e9-11ef-8dde-d415e84cc4f5/order_0bd68b18-23e9-11ef-8dde-d415e84cc4f5/336ff6af-23e9-11ef-8dde-d415e84cc4f5.pdf','PATIENT_907398e3-23e7-11ef-8dde-d415e84cc4f5_ACT_0bcc91ed-23e9-11ef-8dde-d415e84cc4f5_PROST_0bd68b18-23e9-11ef-8dde-d415e84cc4f5_FORM','336ff6af-23e9-11ef-8dde-d415e84cc4f5.pdf','336ff6af-23e9-11ef-8dde-d415e84cc4f5','{\"displayTitle\":\"2.2 Facette [pc1]\",\"title\":\"Facette\"}','PDF',0,'SYNCED',0,NULL,'2024-06-06 11:43:18.000','2024-06-06 09:43:18.000','2024-06-06 11:43:18.000'),('355b14f8-23e9-11ef-867c-6ec2958327c0',2,'/var/iris/.data/2024/2/discussion_0f3dfe44-225d-11ef-8f1f-d8242c71b430/355b14f8-23e9-11ef-867c-6ec2958327c0.zip','PATIENT_907398e3-23e7-11ef-8dde-d415e84cc4f5_ACT_0bcc91ed-23e9-11ef-8dde-d415e84cc4f5_SESS_0bcebe79-23e9-11ef-8dde-d415e84cc4f5_TOSC_0d3f3b92-23e9-11ef-8dde-d415e84cc4f5_MODEL','242c6766-23e9-11ef-8dde-d415e84cc4f5.zip','355b14f8-23e9-11ef-867c-6ec2958327c0','{\"displayTitle\":\"2.2 Maxillaire u1 [pc1]\",\"modelMatrix\":\"-0.98612,0.162098,-0.0359523,0,-0.162664,-0.899746,0.404967,0,0.0332962,0.405194,0.913624,0,8.13953,-5.86615,-13.6249,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-06 11:42:54.000','2024-06-06 09:42:54.000','2024-06-06 11:42:54.000'),('355b5fea-23e9-11ef-867c-6ec2958327c0',2,'/var/iris/.data/2024/2/discussion_0f3dfe44-225d-11ef-8f1f-d8242c71b430/355b5fea-23e9-11ef-867c-6ec2958327c0.png','PATIENT_907398e3-23e7-11ef-8dde-d415e84cc4f5_ACT_0bcc91ed-23e9-11ef-8dde-d415e84cc4f5_SESS_0bcebe79-23e9-11ef-8dde-d415e84cc4f5_TOSC_0d3f3b92-23e9-11ef-8dde-d415e84cc4f5_SNAPS','242c7d2a-23e9-11ef-8dde-d415e84cc4f5.png','355b5fea-23e9-11ef-867c-6ec2958327c0','{\"displayTitle\":\"2.2 Maxillaire u1 Snapshot [pc1]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-06 11:42:55.000','2024-06-06 09:42:55.000','2024-06-06 11:42:55.000'),('355bb3c0-23e9-11ef-867c-6ec2958327c0',2,'/var/iris/.data/2024/2/discussion_0f3dfe44-225d-11ef-8f1f-d8242c71b430/355bb3c0-23e9-11ef-867c-6ec2958327c0.pdf','PATIENT_907398e3-23e7-11ef-8dde-d415e84cc4f5_ACT_0bcc91ed-23e9-11ef-8dde-d415e84cc4f5_PROST_0bd68b18-23e9-11ef-8dde-d415e84cc4f5_FORM','336ff6af-23e9-11ef-8dde-d415e84cc4f5.pdf','355bb3c0-23e9-11ef-867c-6ec2958327c0','{\"displayTitle\":\"2.2 Facette [pc1]\",\"title\":\"Facette\"}','PDF',0,'SYNCED',0,NULL,'2024-06-06 11:43:18.000','2024-06-06 09:43:18.000','2024-06-06 11:43:18.000'),('36992ba9-2974-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/scan_b926a968-2962-11ef-9161-de41a781935b/36992ba9-2974-11ef-9161-de41a781935b.png','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_BOSC_b926a968-2962-11ef-9161-de41a781935b_SCREENS','36992ba9-2974-11ef-9161-de41a781935b.png','36992ba9-2974-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Mandibule l1 Capture d\'écran 1\",\"title\":\"1\"}','PNG',0,'CREATED',0,NULL,'2024-06-13 13:00:58.072','2024-06-13 11:00:58.208',NULL),('3976b785-298e-11ef-8fb0-da2b4bf5ebbb',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_6fa078a0-2987-11ef-8fb0-da2b4bf5ebbb/occlusion_6fa1d062-2987-11ef-8fb0-da2b4bf5ebbb/scan_2b917de0-298e-11ef-8fb0-da2b4bf5ebbb/3976b785-298e-11ef-8fb0-da2b4bf5ebbb.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_6fa078a0-2987-11ef-8fb0-da2b4bf5ebbb_SESS_6fa1d062-2987-11ef-8fb0-da2b4bf5ebbb_TOSC_2b917de0-298e-11ef-8fb0-da2b4bf5ebbb_MODEL','3976b785-298e-11ef-8fb0-da2b4bf5ebbb.zip','3976b785-298e-11ef-8fb0-da2b4bf5ebbb','{\"displayTitle\":\"1.3 Maxillaire u1\",\"modelMatrix\":\"-0.809291,-0.550476,-0.205001,0,0.407944,-0.777802,0.478127,0,-0.422647,0.303315,0.854031,0,8.1212,-0.359057,-6.36711,1\",\"scanBodies\":[{\"position\":\"3.5293,6,0,0,-1.01429,0,6,0,6.64951,0,0,6,1,0,0,0\",\"reference\":\"K30PSCANPLG\",\"tid\":25}]}','ZIP',0,'CREATED',0,'2024-06-13 16:20:17.213','2024-06-13 16:07:09.795','2024-06-13 14:20:17.214',NULL),('3976c5ed-298e-11ef-8fb0-da2b4bf5ebbb',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_6fa078a0-2987-11ef-8fb0-da2b4bf5ebbb/occlusion_6fa1d062-2987-11ef-8fb0-da2b4bf5ebbb/scan_2b917de0-298e-11ef-8fb0-da2b4bf5ebbb/3976c5ed-298e-11ef-8fb0-da2b4bf5ebbb.png','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_6fa078a0-2987-11ef-8fb0-da2b4bf5ebbb_SESS_6fa1d062-2987-11ef-8fb0-da2b4bf5ebbb_TOSC_2b917de0-298e-11ef-8fb0-da2b4bf5ebbb_SNAPS','3976c5ed-298e-11ef-8fb0-da2b4bf5ebbb.png','3976c5ed-298e-11ef-8fb0-da2b4bf5ebbb','{\"displayTitle\":\"1.3 Maxillaire u1 Snapshot\"}','PNG',0,'CREATED',0,'2024-06-13 16:20:17.213','2024-06-13 16:07:09.795','2024-06-13 14:20:17.214',NULL),('3ab043fb-2988-11ef-8fb0-da2b4bf5ebbb',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_7eb8397d-2987-11ef-8fb0-da2b4bf5ebbb/occlusion_7eb98de9-2987-11ef-8fb0-da2b4bf5ebbb/scan_32a6b43e-2988-11ef-8fb0-da2b4bf5ebbb/3ab043fb-2988-11ef-8fb0-da2b4bf5ebbb.ply','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_7eb8397d-2987-11ef-8fb0-da2b4bf5ebbb_SESS_7eb98de9-2987-11ef-8fb0-da2b4bf5ebbb_TOSC_32a6b43e-2988-11ef-8fb0-da2b4bf5ebbb_SEG','3ab043fb-2988-11ef-8fb0-da2b4bf5ebbb.ply','3ab043fb-2988-11ef-8fb0-da2b4bf5ebbb','{\"displayTitle\":\"1.5 Maxillaire u2 Segmentation\"}','PLY',0,'CREATED',0,'2024-06-13 15:24:21.774','2024-06-13 15:24:21.775','2024-06-13 13:24:21.775',NULL),('3b43a93e-2973-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_11bc8a6c-2973-11ef-9161-de41a781935b/occlusion_11be1b4d-2973-11ef-9161-de41a781935b/scan_129f0828-2973-11ef-9161-de41a781935b/3b43a93e-2973-11ef-9161-de41a781935b.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_11bc8a6c-2973-11ef-9161-de41a781935b_SESS_11be1b4d-2973-11ef-9161-de41a781935b_TOSC_129f0828-2973-11ef-9161-de41a781935b_MODEL','3b43a93e-2973-11ef-9161-de41a781935b.zip','1f8131a8-2973-11ef-9161-de41a781935b','{\"displayTitle\":\"1.2 Maxillaire u1\",\"modelMatrix\":\"0.0154815,0.999549,0.0257477,0,-0.702085,0.0292019,-0.711494,0,-0.711924,-0.00706207,0.702221,0,6.8028,5.19037,-2.91295,1\",\"scanBodies\":[]}','ZIP',1,'CREATED',0,NULL,'2024-06-13 12:53:56.404','2024-06-13 10:53:56.431',NULL),('3be2f05d-233b-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_2e146f3d-233a-11ef-8f93-d92a45da78c9/3be2f05d-233b-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_TOSC_2e146f3d-233a-11ef-8f93-d92a45da78c9_MODEL','3be2f05d-233b-11ef-8f93-d92a45da78c9.zip','2e1492f1-233a-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Maxillaire u2 [pc1]\",\"modelMatrix\":\"0.989237,-0.120037,-0.0836717,0,0.114747,0.991239,-0.0654089,0,0.0907902,0.0551039,0.994344,0,-9.57663,-0.954263,-9.009,1\",\"scanBodies\":[]}','ZIP',4,'SYNCED',0,NULL,'2024-06-05 14:58:03.000','2024-06-05 12:58:03.000','2024-06-05 14:58:03.000'),('3be30703-233b-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_2e146f3d-233a-11ef-8f93-d92a45da78c9/3be30703-233b-11ef-8f93-d92a45da78c9.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_TOSC_2e146f3d-233a-11ef-8f93-d92a45da78c9_SNAPS','3be30703-233b-11ef-8f93-d92a45da78c9.png','2e19276e-233a-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Maxillaire u2 Snapshot [pc1]\"}','PNG',2,'SYNCED',0,NULL,'2024-06-05 14:58:03.000','2024-06-05 12:58:03.000','2024-06-05 14:58:03.000'),('3d610748-2974-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/scan_b926a968-2962-11ef-9161-de41a781935b/3d610748-2974-11ef-9161-de41a781935b.json','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_BOSC_b926a968-2962-11ef-9161-de41a781935b_METER','3d610748-2974-11ef-9161-de41a781935b.json','3d610748-2974-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Mandibule l1 Mesure\"}','JSON',0,'CREATED',0,'2024-06-13 15:53:14.533','2024-06-13 15:53:14.533','2024-06-13 13:53:14.533',NULL),('3ddcba60-233a-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_2e146f3d-233a-11ef-8f93-d92a45da78c9/3ddcba60-233a-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_TOSC_2e146f3d-233a-11ef-8f93-d92a45da78c9_MODEL','3ddcba60-233a-11ef-8f93-d92a45da78c9.zip','2e1492f1-233a-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Maxillaire u2 [pc1]\",\"modelMatrix\":\"-0.923468,0.0376561,-0.381824,0,-0.158116,-0.944087,0.289308,0,-0.349581,0.327539,0.877788,0,12.8471,-2.21044,-5.73295,1\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2024-06-05 14:50:54.000','2024-06-05 12:50:54.000','2024-06-05 14:50:54.000'),('3e218de7-2274-11ef-8d76-d310d2ec2c14',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/scan_96d08283-2273-11ef-8d76-d310d2ec2c14/3e218de7-2274-11ef-8d76-d310d2ec2c14.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_BOSC_96d08283-2273-11ef-8d76-d310d2ec2c14_MODEL','3e218de7-2274-11ef-8d76-d310d2ec2c14.zip','3e218de7-2274-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Mandibule l1 [pc2]\",\"modelMatrix\":\"0.135656,-0.982642,-0.126536,0,0.970104,0.157682,-0.184485,0,0.201235,-0.0977264,0.974656,0,-23.8369,18.6095,-10.139,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 15:13:36.000','2024-06-04 13:13:36.000','2024-06-04 15:13:36.000'),('3e22c831-2274-11ef-8d76-d310d2ec2c14',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/scan_96d08283-2273-11ef-8d76-d310d2ec2c14/3e22c831-2274-11ef-8d76-d310d2ec2c14.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_BOSC_96d08283-2273-11ef-8d76-d310d2ec2c14_SNAPS','3e22c831-2274-11ef-8d76-d310d2ec2c14.png','3e22c831-2274-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Mandibule l1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 15:13:37.000','2024-06-04 13:13:37.000','2024-06-04 15:13:37.000'),('4045a372-2343-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_09ea2f4d-2343-11ef-8f93-d92a45da78c9/occlusion_09ebd700-2343-11ef-8f93-d92a45da78c9/scan_0ab76b82-2343-11ef-8f93-d92a45da78c9/4045a372-2343-11ef-8f93-d92a45da78c9.json','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_09ea2f4d-2343-11ef-8f93-d92a45da78c9_SESS_09ebd700-2343-11ef-8f93-d92a45da78c9_BOSC_0ab76b82-2343-11ef-8f93-d92a45da78c9_METER','4045a372-2343-11ef-8f93-d92a45da78c9.json','4045a372-2343-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.7 Mandibule l1 Mesure [pc1]\"}','JSON',0,'SYNCED',0,NULL,'2024-06-05 15:55:22.000','2024-06-05 13:55:22.000','2024-06-05 15:55:22.000'),('40985456-2973-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_11bc8a6c-2973-11ef-9161-de41a781935b/occlusion_11be1b4d-2973-11ef-9161-de41a781935b/scan_129f0828-2973-11ef-9161-de41a781935b/40985456-2973-11ef-9161-de41a781935b.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_11bc8a6c-2973-11ef-9161-de41a781935b_SESS_11be1b4d-2973-11ef-9161-de41a781935b_TOSC_129f0828-2973-11ef-9161-de41a781935b_MODEL','40985456-2973-11ef-9161-de41a781935b.zip','1f8131a8-2973-11ef-9161-de41a781935b','{\"displayTitle\":\"1.2 Maxillaire u1\",\"modelMatrix\":\"0.0154815,0.999549,0.0257477,0,-0.702085,0.0292019,-0.711494,0,-0.711924,-0.00706207,0.702221,0,6.8028,5.19037,-2.91295,1\",\"scanBodies\":[]}','ZIP',2,'CREATED',0,NULL,'2024-06-13 12:54:05.347','2024-06-13 10:54:05.374',NULL),('4282f5e8-233a-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_2e146f3d-233a-11ef-8f93-d92a45da78c9/4282f5e8-233a-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_TOSC_2e146f3d-233a-11ef-8f93-d92a45da78c9_MODEL','4282f5e8-233a-11ef-8f93-d92a45da78c9.zip','2e1492f1-233a-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Maxillaire u2 [pc1]\",\"modelMatrix\":\"-0.923468,0.0376561,-0.381824,0,-0.158116,-0.944087,0.289308,0,-0.349581,0.327539,0.877788,0,12.8471,-2.21044,-5.73295,1\",\"scanBodies\":[],\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":3,\"socleIsFullArch\":false,\"socleThickness\":-1,\"socleType\":3}','ZIP',2,'SYNCED',0,NULL,'2024-06-05 14:51:03.000','2024-06-05 12:51:03.000','2024-06-05 14:51:03.000'),('4731d177-2974-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_11bc8a6c-2973-11ef-9161-de41a781935b/occlusion_11be1b4d-2973-11ef-9161-de41a781935b/scan_129f0828-2973-11ef-9161-de41a781935b/4731d177-2974-11ef-9161-de41a781935b.png','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_11bc8a6c-2973-11ef-9161-de41a781935b_SESS_11be1b4d-2973-11ef-9161-de41a781935b_TOSC_129f0828-2973-11ef-9161-de41a781935b_SCREENS','4731d177-2974-11ef-9161-de41a781935b.png','4731d177-2974-11ef-9161-de41a781935b','{\"displayTitle\":\"1.2 Maxillaire u1 Capture d\'écran 1\",\"title\":\"1\"}','PNG',0,'CREATED',0,NULL,'2024-06-13 13:01:25.916','2024-06-13 11:01:25.980',NULL),('48ab0b8c-233a-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_23e52d54-2338-11ef-8f93-d92a45da78c9/48ab0b8c-233a-11ef-8f93-d92a45da78c9.xyz','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_BOSC_23e52d54-2338-11ef-8f93-d92a45da78c9_LIFI','48ab0b8c-233a-11ef-8f93-d92a45da78c9.xyz','48ab0b8c-233a-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Mandibule l1 Ligne de finition auto [pc1]\",\"title\":\"auto\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-05 14:51:10.000','2024-06-05 12:51:24.000','2024-06-05 14:51:24.000'),('48ab1080-233a-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_23e52d54-2338-11ef-8f93-d92a45da78c9/48ab1080-233a-11ef-8f93-d92a45da78c9.bin','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_BOSC_23e52d54-2338-11ef-8f93-d92a45da78c9_LIFIM','48ab1080-233a-11ef-8f93-d92a45da78c9.bin','48ab1080-233a-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Mandibule l1 Ligne de finition métadonnées auto [pc1]\",\"title\":\"auto\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-05 14:51:10.000','2024-06-05 12:51:25.000','2024-06-05 14:51:25.000'),('48ae5f56-233a-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/computedocclusion_a2829ff3-2338-11ef-8f93-d92a45da78c9/48ae5f56-233a-11ef-8f93-d92a45da78c9.xyz','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_OCC_a2829ff3-2338-11ef-8f93-d92a45da78c9_LIFIO','48ae5f56-233a-11ef-8f93-d92a45da78c9.xyz','48ae5f56-233a-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Occlusion o1 Mandibule l1 Ligne de finition auto [pc1]\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MANDIBLE_1\",\"referenceScanFullDisplayId\":\"1.5_l1\",\"referenceScanId\":\"23e52d54-2338-11ef-8f93-d92a45da78c9\",\"title\":\"auto\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-05 14:51:10.000','2024-06-05 12:51:25.000','2024-06-05 14:51:25.000'),('48ae63e5-233a-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/computedocclusion_a2829ff3-2338-11ef-8f93-d92a45da78c9/48ae63e5-233a-11ef-8f93-d92a45da78c9.bin','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_OCC_a2829ff3-2338-11ef-8f93-d92a45da78c9_LIFIMO','48ae63e5-233a-11ef-8f93-d92a45da78c9.bin','48ae63e5-233a-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Occlusion o1 Mandibule l1 Ligne de finition métadonnées auto [pc1]\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MANDIBLE_1\",\"referenceScanFullDisplayId\":\"1.5_l1\",\"referenceScanId\":\"23e52d54-2338-11ef-8f93-d92a45da78c9\",\"title\":\"auto\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-05 14:51:10.000','2024-06-05 12:51:24.000','2024-06-05 14:51:24.000'),('497c2388-2973-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/scan_b926a968-2962-11ef-9161-de41a781935b/497c2388-2973-11ef-9161-de41a781935b.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_BOSC_b926a968-2962-11ef-9161-de41a781935b_MODEL','497c2388-2973-11ef-9161-de41a781935b.zip','d9a1cf93-2962-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Mandibule l1\",\"modelMatrix\":\"0.96054,0.0160431,-0.277679,0,-0.0791538,0.972823,-0.217602,0,0.266641,0.230994,0.935705,0,-9.25344,-4.26872,-6.69421,1\",\"scanBodies\":[]}','ZIP',1,'CREATED',0,NULL,'2024-06-13 12:54:20.262','2024-06-13 10:54:20.301',NULL),('4c944e2f-2338-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_23e52d54-2338-11ef-8f93-d92a45da78c9/4c944e2f-2338-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_BOSC_23e52d54-2338-11ef-8f93-d92a45da78c9_MODEL','4c944e2f-2338-11ef-8f93-d92a45da78c9.zip','4c944e2f-2338-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Mandibule l1 [pc1]\",\"modelMatrix\":\"0.912405,-0.408985,0.0157505,0,0.408648,0.908152,-0.0909209,0,0.0228815,0.0893931,0.995733,0,-14.1029,6.9381,-10.6228,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-05 14:37:02.000','2024-06-05 12:37:02.000','2024-06-05 14:37:02.000'),('4c9462f1-2338-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_23e52d54-2338-11ef-8f93-d92a45da78c9/4c9462f1-2338-11ef-8f93-d92a45da78c9.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_BOSC_23e52d54-2338-11ef-8f93-d92a45da78c9_SNAPS','4c9462f1-2338-11ef-8f93-d92a45da78c9.png','4c9462f1-2338-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Mandibule l1 Snapshot [pc1]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-05 14:37:03.000','2024-06-05 12:37:03.000','2024-06-05 14:37:03.000'),('4df7ad71-233f-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_ef3ba736-2337-11ef-8f93-d92a45da78c9/4df7ad71-233f-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_TOSC_ef3ba736-2337-11ef-8f93-d92a45da78c9_MODEL','4df7ad71-233f-11ef-8f93-d92a45da78c9.zip','1ffb9e9c-2338-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Maxillaire u1 [pc1]\",\"modelMatrix\":\"-0.923468,0.0376561,-0.381824,0,-0.158116,-0.944087,0.289308,0,-0.349581,0.327539,0.877788,0,12.8471,-2.21044,-5.73295,1\",\"scanBodies\":[],\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":3,\"socleIsFullArch\":true,\"socleThickness\":-1,\"socleType\":1}','ZIP',1,'SYNCED',0,NULL,'2024-06-05 15:27:08.000','2024-06-05 13:27:08.000','2024-06-05 15:27:08.000'),('4e2848b7-2973-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/scan_b926a968-2962-11ef-9161-de41a781935b/4e2848b7-2973-11ef-9161-de41a781935b.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_BOSC_b926a968-2962-11ef-9161-de41a781935b_MODEL','4e2848b7-2973-11ef-9161-de41a781935b.zip','d9a1cf93-2962-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Mandibule l1\",\"modelMatrix\":\"0.96054,0.0160431,-0.277679,0,-0.0791538,0.972823,-0.217602,0,0.266641,0.230994,0.935705,0,-9.25344,-4.26872,-6.69421,1\",\"scanBodies\":[]}','ZIP',2,'CREATED',0,NULL,'2024-06-13 12:54:28.101','2024-06-13 10:54:28.140',NULL),('4fb005bd-296d-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/scan_4cc68cd8-2962-11ef-9161-de41a781935b/4fb005bd-296d-11ef-9161-de41a781935b.ply','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_TOSC_4cc68cd8-2962-11ef-9161-de41a781935b_SEG','4fb005bd-296d-11ef-9161-de41a781935b.ply','4fb005bd-296d-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Maxillaire u1 Segmentation\"}','PLY',0,'CREATED',0,NULL,'2024-06-13 12:11:33.689','2024-06-13 10:11:33.705',NULL),('51e7fbf0-233a-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_23e52d54-2338-11ef-8f93-d92a45da78c9/51e7fbf0-233a-11ef-8f93-d92a45da78c9.xyz','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_BOSC_23e52d54-2338-11ef-8f93-d92a45da78c9_LIFI','51e7fbf0-233a-11ef-8f93-d92a45da78c9.xyz','48ab0b8c-233a-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Mandibule l1 Ligne de finition auto [pc1]\",\"title\":\"auto\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',1,'SYNCED',0,NULL,'2024-06-05 14:51:27.000','2024-06-05 12:51:27.000','2024-06-05 14:51:27.000'),('51e81127-233a-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_23e52d54-2338-11ef-8f93-d92a45da78c9/51e81127-233a-11ef-8f93-d92a45da78c9.bin','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_BOSC_23e52d54-2338-11ef-8f93-d92a45da78c9_LIFIM','51e81127-233a-11ef-8f93-d92a45da78c9.bin','48ab1080-233a-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Mandibule l1 Ligne de finition métadonnées auto [pc1]\",\"title\":\"auto\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',1,'SYNCED',0,NULL,'2024-06-05 14:51:27.000','2024-06-05 12:51:27.000','2024-06-05 14:51:27.000'),('51ec0746-233a-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/computedocclusion_a2829ff3-2338-11ef-8f93-d92a45da78c9/51ec0746-233a-11ef-8f93-d92a45da78c9.xyz','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_OCC_a2829ff3-2338-11ef-8f93-d92a45da78c9_LIFIO','51ec0746-233a-11ef-8f93-d92a45da78c9.xyz','48ae5f56-233a-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Occlusion o1 Mandibule l1 Ligne de finition auto [pc1]\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MANDIBLE_1\",\"referenceScanFullDisplayId\":\"1.5_l1\",\"referenceScanId\":\"23e52d54-2338-11ef-8f93-d92a45da78c9\",\"title\":\"auto\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',1,'SYNCED',0,NULL,'2024-06-05 14:51:28.000','2024-06-05 12:51:28.000','2024-06-05 14:51:28.000'),('51ec1340-233a-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/computedocclusion_a2829ff3-2338-11ef-8f93-d92a45da78c9/51ec1340-233a-11ef-8f93-d92a45da78c9.bin','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_OCC_a2829ff3-2338-11ef-8f93-d92a45da78c9_LIFIMO','51ec1340-233a-11ef-8f93-d92a45da78c9.bin','48ae63e5-233a-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Occlusion o1 Mandibule l1 Ligne de finition métadonnées auto [pc1]\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MANDIBLE_1\",\"referenceScanFullDisplayId\":\"1.5_l1\",\"referenceScanId\":\"23e52d54-2338-11ef-8f93-d92a45da78c9\",\"title\":\"auto\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',1,'SYNCED',0,NULL,'2024-06-05 14:51:29.000','2024-06-05 12:51:29.000','2024-06-05 14:51:29.000'),('51fc9f7e-2974-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_11bc8a6c-2973-11ef-9161-de41a781935b/occlusion_11be1b4d-2973-11ef-9161-de41a781935b/scan_129f0828-2973-11ef-9161-de41a781935b/51fc9f7e-2974-11ef-9161-de41a781935b.png','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_11bc8a6c-2973-11ef-9161-de41a781935b_SESS_11be1b4d-2973-11ef-9161-de41a781935b_TOSC_129f0828-2973-11ef-9161-de41a781935b_SCREENS','51fc9f7e-2974-11ef-9161-de41a781935b.png','51fc9f7e-2974-11ef-9161-de41a781935b','{\"displayTitle\":\"1.2 Maxillaire u1 Capture d\'écran 2\",\"title\":\"2\"}','PNG',0,'CREATED',0,NULL,'2024-06-13 13:01:44.023','2024-06-13 11:01:44.085',NULL),('54903c9c-225d-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_e3862d66-225a-11ef-8f1f-d8242c71b430/order_e3879e0c-225a-11ef-8f1f-d8242c71b430/54903c9c-225d-11ef-8f1f-d8242c71b430.pdf','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_PROST_e3879e0c-225a-11ef-8f1f-d8242c71b430_FORM','54903c9c-225d-11ef-8f1f-d8242c71b430.pdf','0ed5b8be-225d-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.1 Guide\",\"title\":\"Guide\"}','PDF',1,'SYNCED',0,NULL,'2024-06-04 12:29:31.781','2024-06-04 10:29:32.490','2024-06-04 12:29:32.497'),('54a67fcd-226b-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_757ed4bc-2266-11ef-8f1f-d8242c71b430/order_7585401e-2266-11ef-8f1f-d8242c71b430/54a67fcd-226b-11ef-8f1f-d8242c71b430.pdf','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_PROST_7585401e-2266-11ef-8f1f-d8242c71b430_FORM','54a67fcd-226b-11ef-8f1f-d8242c71b430.pdf','54a67fcd-226b-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.2 Couronne\",\"title\":\"Couronne\"}','PDF',0,'SYNCED',0,NULL,'2024-06-04 14:09:44.881','2024-06-04 12:09:45.560','2024-06-04 14:09:45.678'),('5600d63e-2959-11ef-9161-de41a781935b',2,'/var/iris/.data/2024/2/ecf61c34-2958-11ef-9161-de41a781935b/session_f1fca9ca-2958-11ef-9161-de41a781935b/occlusion_f1fe313e-2958-11ef-9161-de41a781935b/scan_f364e666-2958-11ef-9161-de41a781935b/5600d63e-2959-11ef-9161-de41a781935b.zip','PATIENT_ecf61c34-2958-11ef-9161-de41a781935b_ACT_f1fca9ca-2958-11ef-9161-de41a781935b_SESS_f1fe313e-2958-11ef-9161-de41a781935b_TOSC_f364e666-2958-11ef-9161-de41a781935b_MODEL','5600d63e-2959-11ef-9161-de41a781935b.zip','5600d63e-2959-11ef-9161-de41a781935b','{\"displayTitle\":\"5.1 Maxillaire u1 [pc1]\",\"modelMatrix\":\"-0.866728,0.49371,-0.0709389,0,-0.48323,-0.866407,-0.125809,0,-0.123575,-0.0747627,0.989515,0,8.80559,-0.18719,-10.6309,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2024-06-13 09:48:34.349','2024-06-13 07:48:34.594',NULL),('5600eecc-2959-11ef-9161-de41a781935b',2,'/var/iris/.data/2024/2/ecf61c34-2958-11ef-9161-de41a781935b/session_f1fca9ca-2958-11ef-9161-de41a781935b/occlusion_f1fe313e-2958-11ef-9161-de41a781935b/scan_f364e666-2958-11ef-9161-de41a781935b/5600eecc-2959-11ef-9161-de41a781935b.png','PATIENT_ecf61c34-2958-11ef-9161-de41a781935b_ACT_f1fca9ca-2958-11ef-9161-de41a781935b_SESS_f1fe313e-2958-11ef-9161-de41a781935b_TOSC_f364e666-2958-11ef-9161-de41a781935b_SNAPS','5600eecc-2959-11ef-9161-de41a781935b.png','5600eecc-2959-11ef-9161-de41a781935b','{\"displayTitle\":\"5.1 Maxillaire u1 Snapshot [pc1]\"}','PNG',0,'CREATED',0,NULL,'2024-06-13 09:48:34.350','2024-06-13 07:48:34.594',NULL),('562de0a9-226b-11ef-867c-6ec2958327c0',4,'/var/iris/.data/2024/4/discussion_550eb27a-226b-11ef-8f1f-d8242c71b430/562de0a9-226b-11ef-867c-6ec2958327c0.pdf','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_PROST_7585401e-2266-11ef-8f1f-d8242c71b430_FORM','54a67fcd-226b-11ef-8f1f-d8242c71b430.pdf','562de0a9-226b-11ef-867c-6ec2958327c0','{\"displayTitle\":\"1.2 Couronne\",\"title\":\"Couronne\"}','PDF',0,'SYNCED',0,NULL,'2024-06-04 14:09:45.000','2024-06-04 12:09:45.000','2024-06-04 14:09:45.000'),('562e4386-226b-11ef-867c-6ec2958327c0',4,'/var/iris/.data/2024/4/discussion_550eb27a-226b-11ef-8f1f-d8242c71b430/562e4386-226b-11ef-867c-6ec2958327c0.xyz','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_OCC_0b16efeb-2268-11ef-8f1f-d8242c71b430_LIFIO','6461ca85-2269-11ef-8f1f-d8242c71b430.xyz','562e4386-226b-11ef-867c-6ec2958327c0','{\"displayTitle\":\"1.2 Occlusion o1 Maxillaire u1 Ligne de finition auto\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY_1\",\"referenceScanFullDisplayId\":\"1.2_u1\",\"referenceScanId\":\"09768650-2267-11ef-8f1f-d8242c71b430\",\"title\":\"auto\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-04 13:55:53.000','2024-06-04 11:55:53.000','2024-06-04 13:55:53.000'),('562e8775-226b-11ef-867c-6ec2958327c0',4,'/var/iris/.data/2024/4/discussion_550eb27a-226b-11ef-8f1f-d8242c71b430/562e8775-226b-11ef-867c-6ec2958327c0.bin','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_OCC_0b16efeb-2268-11ef-8f1f-d8242c71b430_LIFIMO','6461d309-2269-11ef-8f1f-d8242c71b430.bin','562e8775-226b-11ef-867c-6ec2958327c0','{\"displayTitle\":\"1.2 Occlusion o1 Maxillaire u1 Ligne de finition métadonnées auto\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY_1\",\"referenceScanFullDisplayId\":\"1.2_u1\",\"referenceScanId\":\"09768650-2267-11ef-8f1f-d8242c71b430\",\"title\":\"auto\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-04 13:55:53.000','2024-06-04 11:55:53.000','2024-06-04 13:55:53.000'),('562ec5b4-226b-11ef-867c-6ec2958327c0',4,'/var/iris/.data/2024/4/discussion_550eb27a-226b-11ef-8f1f-d8242c71b430/562ec5b4-226b-11ef-867c-6ec2958327c0.xyz','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_OCC_0b16efeb-2268-11ef-8f1f-d8242c71b430_LIFIO','8103b4c6-2269-11ef-8f1f-d8242c71b430.xyz','562ec5b4-226b-11ef-867c-6ec2958327c0','{\"displayTitle\":\"1.2 Occlusion o1 Maxillaire u1 Ligne de finition 1\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY_1\",\"referenceScanFullDisplayId\":\"1.2_u1\",\"referenceScanId\":\"09768650-2267-11ef-8f1f-d8242c71b430\",\"title\":\"1\",\"toothNumber\":1001,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-04 13:56:41.000','2024-06-04 11:56:41.000','2024-06-04 13:56:41.000'),('562f1380-226b-11ef-867c-6ec2958327c0',4,'/var/iris/.data/2024/4/discussion_550eb27a-226b-11ef-8f1f-d8242c71b430/562f1380-226b-11ef-867c-6ec2958327c0.bin','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_OCC_0b16efeb-2268-11ef-8f1f-d8242c71b430_LIFIMO','8103b848-2269-11ef-8f1f-d8242c71b430.bin','562f1380-226b-11ef-867c-6ec2958327c0','{\"displayTitle\":\"1.2 Occlusion o1 Maxillaire u1 Ligne de finition métadonnées 1\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY_1\",\"referenceScanFullDisplayId\":\"1.2_u1\",\"referenceScanId\":\"09768650-2267-11ef-8f1f-d8242c71b430\",\"title\":\"1\",\"toothNumber\":1001,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-04 13:56:41.000','2024-06-04 11:56:41.000','2024-06-04 13:56:41.000'),('562f5f75-226b-11ef-867c-6ec2958327c0',4,'/var/iris/.data/2024/4/discussion_550eb27a-226b-11ef-8f1f-d8242c71b430/562f5f75-226b-11ef-867c-6ec2958327c0.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_OCC_0b16efeb-2268-11ef-8f1f-d8242c71b430_BO1','9e41d416-2269-11ef-8f1f-d8242c71b430.zip','562f5f75-226b-11ef-867c-6ec2958327c0','{\"displayTitle\":\"1.2 Occlusion o1 Mandibule l1\",\"modelMatrix\":\"0.988582,0.0775562,-0.129192,0,-0.0638786,0.992221,0.106846,0,0.136474,-0.0973735,0.985846,0,-17.8094,0.329057,-12.0411,1\",\"occlusionMatrix\":\"0.967115,-0.162627,-0.195617,0,-0.236852,-0.295065,-0.925664,0,0.0928169,0.941543,-0.323876,0,-16.3387,-5.9884,6.66074,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.2_l1\",\"referenceScanId\":\"b4da925f-2267-11ef-8f1f-d8242c71b430\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 13:57:30.000','2024-06-04 11:57:30.000','2024-06-04 13:57:30.000'),('562fafb0-226b-11ef-867c-6ec2958327c0',4,'/var/iris/.data/2024/4/discussion_550eb27a-226b-11ef-8f1f-d8242c71b430/562fafb0-226b-11ef-867c-6ec2958327c0.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_OCC_0b16efeb-2268-11ef-8f1f-d8242c71b430_TO1','f3576589-2268-11ef-8f1f-d8242c71b430.zip','562fafb0-226b-11ef-867c-6ec2958327c0','{\"displayTitle\":\"1.2 Occlusion o1 Maxillaire u1\",\"modelMatrix\":\"0.970663,-0.222677,0.0907083,0,0.239614,0.864538,-0.441769,0,0.019951,0.450543,0.892532,0,-17.9206,-4.24346,-12.6568,1\",\"occlusionMatrix\":\"0.973794,0.000432278,-0.227448,0,0.222023,0.215288,0.950979,0,0.0493782,-0.976552,0.20955,0,-19.0028,7.7418,-0.229366,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.2_u1\",\"referenceScanId\":\"09768650-2267-11ef-8f1f-d8242c71b430\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 13:52:46.000','2024-06-04 11:52:46.000','2024-06-04 13:52:46.000'),('562ffbea-226b-11ef-867c-6ec2958327c0',4,'/var/iris/.data/2024/4/discussion_550eb27a-226b-11ef-8f1f-d8242c71b430/562ffbea-226b-11ef-867c-6ec2958327c0.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_OCC_0b16efeb-2268-11ef-8f1f-d8242c71b430_SNAPO','f4024e3a-2268-11ef-8f1f-d8242c71b430.png','562ffbea-226b-11ef-867c-6ec2958327c0','{\"displayTitle\":\"1.2 Occlusion o1\",\"occlusionType\":1}','PNG',0,'SYNCED',0,NULL,'2024-06-04 13:52:48.000','2024-06-04 11:52:48.000','2024-06-04 13:52:48.000'),('5786e230-2973-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/scan_b926a968-2962-11ef-9161-de41a781935b/5786e230-2973-11ef-9161-de41a781935b.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_BOSC_b926a968-2962-11ef-9161-de41a781935b_MODEL','5786e230-2973-11ef-9161-de41a781935b.zip','d9a1cf93-2962-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Mandibule l1\",\"modelMatrix\":\"0.96054,0.0160431,-0.277679,0,-0.0791538,0.972823,-0.217602,0,0.266641,0.230994,0.935705,0,-9.25344,-4.26872,-6.69421,1\",\"scanBodies\":[]}','ZIP',3,'CREATED',0,NULL,'2024-06-13 12:54:43.821','2024-06-13 10:54:43.859',NULL),('586cd220-298c-11ef-8fb0-da2b4bf5ebbb',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/scan_b926a968-2962-11ef-9161-de41a781935b/586cd220-298c-11ef-8fb0-da2b4bf5ebbb.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_BOSC_b926a968-2962-11ef-9161-de41a781935b_MODEL','586cd220-298c-11ef-8fb0-da2b4bf5ebbb.zip','d9a1cf93-2962-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Mandibule l1\",\"modelMatrix\":\"-0.965965,0.0394655,-0.255646,0,0.0256859,-0.968774,-0.24661,0,-0.257396,-0.244783,0.934788,0,7.99549,3.40222,-6.3837,1\",\"scanBodies\":[]}','ZIP',6,'CREATED',0,NULL,'2024-06-13 15:53:42.746','2024-06-13 13:53:43.071',NULL),('586cf30b-298c-11ef-8fb0-da2b4bf5ebbb',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/scan_b926a968-2962-11ef-9161-de41a781935b/586cf30b-298c-11ef-8fb0-da2b4bf5ebbb.png','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_BOSC_b926a968-2962-11ef-9161-de41a781935b_SNAPS','586cf30b-298c-11ef-8fb0-da2b4bf5ebbb.png','d9a1dff9-2962-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Mandibule l1 Snapshot\"}','PNG',1,'CREATED',0,NULL,'2024-06-13 15:53:42.747','2024-06-13 13:53:43.071',NULL),('58941659-298e-11ef-8fb0-da2b4bf5ebbb',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_6fa078a0-2987-11ef-8fb0-da2b4bf5ebbb/occlusion_6fa1d062-2987-11ef-8fb0-da2b4bf5ebbb/scan_2b917de0-298e-11ef-8fb0-da2b4bf5ebbb/58941659-298e-11ef-8fb0-da2b4bf5ebbb.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_6fa078a0-2987-11ef-8fb0-da2b4bf5ebbb_SESS_6fa1d062-2987-11ef-8fb0-da2b4bf5ebbb_TOSC_2b917de0-298e-11ef-8fb0-da2b4bf5ebbb_MODEL','58941659-298e-11ef-8fb0-da2b4bf5ebbb.zip','3976b785-298e-11ef-8fb0-da2b4bf5ebbb','{\"displayTitle\":\"1.3 Maxillaire u1\",\"modelMatrix\":\"-0.809291,-0.550476,-0.205001,0,0.407944,-0.777802,0.478127,0,-0.422647,0.303315,0.854031,0,8.1212,-0.359057,-6.36711,1\",\"scanBodies\":[{\"position\":\"3.5293,6,0,0,-1.01429,0,6,0,6.64951,0,0,6,1,0,0,0\",\"reference\":\"K30PSCANPLG\",\"tid\":25}]}','ZIP',1,'CREATED',0,'2024-06-13 16:20:17.213','2024-06-13 16:08:01.997','2024-06-13 14:20:17.214',NULL),('58bcb05a-226f-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f6cfa4bf-226e-11ef-8f1f-d8242c71b430/occlusion_f6d13d7e-226e-11ef-8f1f-d8242c71b430/scan_24861dc8-226f-11ef-8f1f-d8242c71b430/58bcb05a-226f-11ef-8f1f-d8242c71b430.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f6cfa4bf-226e-11ef-8f1f-d8242c71b430_SESS_f6d13d7e-226e-11ef-8f1f-d8242c71b430_TOSC_24861dc8-226f-11ef-8f1f-d8242c71b430_MODEL','58bcb05a-226f-11ef-8f1f-d8242c71b430.zip','58bcb05a-226f-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.3 Maxillaire u1 [pc1]\",\"modelMatrix\":\"-0.907546,0.40641,-0.105791,0,-0.405009,-0.780419,0.476355,0,0.111034,0.47516,0.872865,0,4.28957,-8.29297,-14.2564,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 14:38:43.000','2024-06-04 12:38:43.000','2024-06-04 14:38:43.000'),('58bcc45d-226f-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f6cfa4bf-226e-11ef-8f1f-d8242c71b430/occlusion_f6d13d7e-226e-11ef-8f1f-d8242c71b430/scan_24861dc8-226f-11ef-8f1f-d8242c71b430/58bcc45d-226f-11ef-8f1f-d8242c71b430.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f6cfa4bf-226e-11ef-8f1f-d8242c71b430_SESS_f6d13d7e-226e-11ef-8f1f-d8242c71b430_TOSC_24861dc8-226f-11ef-8f1f-d8242c71b430_SNAPS','58bcc45d-226f-11ef-8f1f-d8242c71b430.png','58bcc45d-226f-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.3 Maxillaire u1 Snapshot [pc1]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 14:38:44.000','2024-06-04 12:38:44.000','2024-06-04 14:38:44.000'),('58c2d450-2974-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_11bc8a6c-2973-11ef-9161-de41a781935b/occlusion_11be1b4d-2973-11ef-9161-de41a781935b/scan_129f0828-2973-11ef-9161-de41a781935b/58c2d450-2974-11ef-9161-de41a781935b.png','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_11bc8a6c-2973-11ef-9161-de41a781935b_SESS_11be1b4d-2973-11ef-9161-de41a781935b_TOSC_129f0828-2973-11ef-9161-de41a781935b_SCREENS','58c2d450-2974-11ef-9161-de41a781935b.png','58c2d450-2974-11ef-9161-de41a781935b','{\"displayTitle\":\"1.2 Maxillaire u1 Capture d\'écran 3\",\"title\":\"3\"}','PNG',0,'CREATED',0,NULL,'2024-06-13 13:01:55.388','2024-06-13 11:01:55.451',NULL),('59191380-233f-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_ef3ba736-2337-11ef-8f93-d92a45da78c9/59191380-233f-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_TOSC_ef3ba736-2337-11ef-8f93-d92a45da78c9_MODEL','59191380-233f-11ef-8f93-d92a45da78c9.zip','1ffb9e9c-2338-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Maxillaire u1 [pc1]\",\"modelMatrix\":\"-0.923468,0.0376561,-0.381824,0,-0.158116,-0.944087,0.289308,0,-0.349581,0.327539,0.877788,0,12.8471,-2.21044,-5.73295,1\",\"scanBodies\":[],\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":3,\"socleIsFullArch\":true,\"socleThickness\":-1,\"socleType\":1}','ZIP',2,'SYNCED',0,NULL,'2024-06-05 15:27:28.000','2024-06-05 13:27:28.000','2024-06-05 15:27:28.000'),('596c715a-233c-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_596c4e98-233c-11ef-8f93-d92a45da78c9/596c715a-233c-11ef-8f93-d92a45da78c9.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_BOSC_596c4e98-233c-11ef-8f93-d92a45da78c9_SNAPS','596c715a-233c-11ef-8f93-d92a45da78c9.png','596c715a-233c-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Mandibule l2 Snapshot [pc1]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-05 15:06:00.000','2024-06-05 13:06:00.000','2024-06-05 15:06:00.000'),('596c8055-233c-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_596c4e98-233c-11ef-8f93-d92a45da78c9/596c8055-233c-11ef-8f93-d92a45da78c9.xyz','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_BOSC_596c4e98-233c-11ef-8f93-d92a45da78c9_LIFI','596c8055-233c-11ef-8f93-d92a45da78c9.xyz','596c8055-233c-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Mandibule l2 Ligne de finition auto [pc1]\",\"title\":\"auto\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-05 15:06:00.000','2024-06-05 13:06:00.000','2024-06-05 15:06:00.000'),('596c8c7f-233c-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_596c4e98-233c-11ef-8f93-d92a45da78c9/596c8c7f-233c-11ef-8f93-d92a45da78c9.bin','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_BOSC_596c4e98-233c-11ef-8f93-d92a45da78c9_LIFIM','596c8c7f-233c-11ef-8f93-d92a45da78c9.bin','596c8c7f-233c-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Mandibule l2 Ligne de finition métadonnées auto [pc1]\",\"title\":\"auto\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-05 15:06:01.000','2024-06-05 13:06:01.000','2024-06-05 15:06:01.000'),('596c981e-233c-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_596c4e98-233c-11ef-8f93-d92a45da78c9/596c981e-233c-11ef-8f93-d92a45da78c9.ply','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_BOSC_596c4e98-233c-11ef-8f93-d92a45da78c9_SEG','596c981e-233c-11ef-8f93-d92a45da78c9.ply','596c981e-233c-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Mandibule l2 Segmentation [pc1]\"}','PLY',0,'SYNCED',0,NULL,'2024-06-05 15:06:03.000','2024-06-05 13:06:03.000','2024-06-05 15:06:03.000'),('596cc291-233c-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_596c4e98-233c-11ef-8f93-d92a45da78c9/596cc291-233c-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_BOSC_596c4e98-233c-11ef-8f93-d92a45da78c9_MODEL','596cc291-233c-11ef-8f93-d92a45da78c9.zip','596cc291-233c-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Mandibule l2 [pc1]\",\"modelMatrix\":\"0.912405,-0.408985,0.0157505,0,0.408648,0.908152,-0.0909209,0,0.0228815,0.0893931,0.995733,0,-14.1029,6.9381,-10.6228,1\",\"scanBodies\":[],\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":3,\"socleIsFullArch\":true,\"socleThickness\":-1,\"socleType\":3}','ZIP',0,'SYNCED',0,NULL,'2024-06-05 15:06:06.000','2024-06-05 13:06:06.000','2024-06-05 15:06:06.000'),('5a982332-2967-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/scan_5a97f8c0-2967-11ef-9161-de41a781935b/5a982332-2967-11ef-9161-de41a781935b.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_TOSC_5a97f8c0-2967-11ef-9161-de41a781935b_MODEL','5a982332-2967-11ef-9161-de41a781935b.zip','5a982332-2967-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Maxillaire u2\",\"modelMatrix\":\"-0.872758,0.470809,-0.128964,0,-0.443838,-0.875321,-0.191887,0,-0.203227,-0.110232,0.972907,0,-2.56858,6.47103,-8.11483,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,'2024-06-13 11:39:15.670','2024-06-13 11:28:55.006','2024-06-13 09:39:15.672',NULL),('5a9c97f2-2967-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/scan_5a97f8c0-2967-11ef-9161-de41a781935b/5a9c97f2-2967-11ef-9161-de41a781935b.png','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_TOSC_5a97f8c0-2967-11ef-9161-de41a781935b_SNAPS','5a9c97f2-2967-11ef-9161-de41a781935b.png','5a9c97f2-2967-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Maxillaire u2 Snapshot\"}','PNG',0,'CREATED',0,'2024-06-13 11:39:15.670','2024-06-13 11:28:55.035','2024-06-13 09:39:15.672',NULL),('5ac77cab-233a-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/computedocclusion_a2829ff3-2338-11ef-8f93-d92a45da78c9/5ac77cab-233a-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_OCC_a2829ff3-2338-11ef-8f93-d92a45da78c9_TO2','5ac77cab-233a-11ef-8f93-d92a45da78c9.zip','5ac77cab-233a-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Occlusion o1 Maxillaire u2 [pc1]\",\"modelMatrix\":\"-0.923468,0.0376561,-0.381824,0,-0.158116,-0.944087,0.289308,0,-0.349581,0.327539,0.877788,0,12.8471,-2.21044,-5.73295,1\",\"occlusionMatrix\":\"0.961831,0.149468,-0.231582,0,0.27256,-0.433127,0.858711,0,0.0250048,-0.888866,-0.457158,0,-15.4994,3.62291,10.3073,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.5_u2\",\"referenceScanId\":\"2e146f3d-233a-11ef-8f93-d92a45da78c9\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-05 14:51:44.000','2024-06-05 12:51:44.000','2024-06-05 14:51:44.000'),('5adbc9bc-2278-11ef-8d76-d310d2ec2c14',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/computedocclusion_9ed6352b-2277-11ef-8d76-d310d2ec2c14/5adbc9bc-2278-11ef-8d76-d310d2ec2c14.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_OCC_9ed6352b-2277-11ef-8d76-d310d2ec2c14_TO1','5adbc9bc-2278-11ef-8d76-d310d2ec2c14.zip','5adbc9bc-2278-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Occlusion o2 Maxillaire u1 [pc2]\",\"modelMatrix\":\"-0.0834467,0.986107,-0.143628,0,-0.981709,-0.1061,-0.158085,0,-0.171128,0.12781,0.976924,0,-17.1278,-28.7907,-11.2181,1\",\"occlusionMatrix\":\"-0.0834467,0.143628,0.986107,0,-0.981709,0.158085,-0.1061,0,-0.171128,-0.976924,0.12781,0,-17.1278,11.2181,-28.7907,1\",\"occlusionType\":5,\"referenceScanFullDisplayId\":\"1.2_u1\",\"referenceScanId\":\"f3b0649e-2272-11ef-8d76-d310d2ec2c14\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 15:43:01.000','2024-06-04 13:43:01.000','2024-06-04 15:43:01.000'),('5aea6f60-233a-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/computedocclusion_a2829ff3-2338-11ef-8f93-d92a45da78c9/5aea6f60-233a-11ef-8f93-d92a45da78c9.xyz','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_OCC_a2829ff3-2338-11ef-8f93-d92a45da78c9_LIFIO','5aea6f60-233a-11ef-8f93-d92a45da78c9.xyz','5aea6f60-233a-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Occlusion o1 Maxillaire u2 Ligne de finition manuelle [pc1]\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY_2\",\"referenceScanFullDisplayId\":\"1.5_u2\",\"referenceScanId\":\"2e146f3d-233a-11ef-8f93-d92a45da78c9\",\"title\":\"manuelle\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,'2024-06-05 14:52:42.000','2024-06-05 14:51:44.000','2024-06-05 12:52:42.000','2024-06-05 14:52:42.000'),('5aea74fa-233a-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/computedocclusion_a2829ff3-2338-11ef-8f93-d92a45da78c9/5aea74fa-233a-11ef-8f93-d92a45da78c9.bin','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_OCC_a2829ff3-2338-11ef-8f93-d92a45da78c9_LIFIMO','5aea74fa-233a-11ef-8f93-d92a45da78c9.bin','5aea74fa-233a-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Occlusion o1 Maxillaire u2 Ligne de finition métadonnées manuelle [pc1]\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY_2\",\"referenceScanFullDisplayId\":\"1.5_u2\",\"referenceScanId\":\"2e146f3d-233a-11ef-8f93-d92a45da78c9\",\"title\":\"manuelle\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,'2024-06-05 14:52:43.000','2024-06-05 14:51:45.000','2024-06-05 12:52:43.000','2024-06-05 14:52:43.000'),('5b0decc4-2278-11ef-8d76-d310d2ec2c14',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/computedocclusion_9ed6352b-2277-11ef-8d76-d310d2ec2c14/5b0decc4-2278-11ef-8d76-d310d2ec2c14.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_OCC_9ed6352b-2277-11ef-8d76-d310d2ec2c14_BO1','5b0decc4-2278-11ef-8d76-d310d2ec2c14.zip','5b0decc4-2278-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Occlusion o2 Mandibule l1 [pc2]\",\"modelMatrix\":\"0.135656,-0.982642,-0.126536,0,0.970104,0.157682,-0.184485,0,0.201235,-0.0977264,0.974656,0,-23.8369,18.6095,-10.139,1\",\"occlusionMatrix\":\"-0.17691,-0.163102,0.970622,0,0.978966,-0.130988,0.156421,0,0.101627,0.977872,0.182845,0,-18.8406,-1.18887,-25.0133,1\",\"occlusionType\":5,\"referenceScanFullDisplayId\":\"1.2_l1\",\"referenceScanId\":\"96d08283-2273-11ef-8d76-d310d2ec2c14\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 15:43:02.000','2024-06-04 13:43:02.000','2024-06-04 15:43:02.000'),('5bc001f1-2278-11ef-8d76-d310d2ec2c14',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/computedocclusion_9ed6352b-2277-11ef-8d76-d310d2ec2c14/5bc001f1-2278-11ef-8d76-d310d2ec2c14.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_OCC_9ed6352b-2277-11ef-8d76-d310d2ec2c14_SNAPO','5bc001f1-2278-11ef-8d76-d310d2ec2c14.png','5bc001f1-2278-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Occlusion o2 [pc2]\",\"occlusionType\":5}','PNG',0,'SYNCED',0,NULL,'2024-06-04 15:43:02.000','2024-06-04 13:43:02.000','2024-06-04 15:43:02.000'),('5bd68def-2272-11ef-8d76-d310d2ec2c14',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_62b97c61-226c-11ef-8d76-d310d2ec2c14/occlusion_62bbada3-226c-11ef-8d76-d310d2ec2c14/scan_389889a4-2272-11ef-8d76-d310d2ec2c14/5bd68def-2272-11ef-8d76-d310d2ec2c14.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_62b97c61-226c-11ef-8d76-d310d2ec2c14_SESS_62bbada3-226c-11ef-8d76-d310d2ec2c14_TOSC_389889a4-2272-11ef-8d76-d310d2ec2c14_MODEL','5bd68def-2272-11ef-8d76-d310d2ec2c14.zip','5bd68def-2272-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.1 Maxillaire u1 [pc2]\",\"modelMatrix\":\"0.901424,-0.415146,-0.12284,0,0.404409,0.908712,-0.10342,0,0.154561,0.0435476,0.987023,0,-9.88483,-1.72313,-15.441,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 15:00:06.000','2024-06-04 13:00:06.000','2024-06-04 15:00:06.000'),('5bd6a4c3-2272-11ef-8d76-d310d2ec2c14',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_62b97c61-226c-11ef-8d76-d310d2ec2c14/occlusion_62bbada3-226c-11ef-8d76-d310d2ec2c14/scan_389889a4-2272-11ef-8d76-d310d2ec2c14/5bd6a4c3-2272-11ef-8d76-d310d2ec2c14.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_62b97c61-226c-11ef-8d76-d310d2ec2c14_SESS_62bbada3-226c-11ef-8d76-d310d2ec2c14_TOSC_389889a4-2272-11ef-8d76-d310d2ec2c14_SNAPS','5bd6a4c3-2272-11ef-8d76-d310d2ec2c14.png','5bd6a4c3-2272-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.1 Maxillaire u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 15:00:07.000','2024-06-04 13:00:07.000','2024-06-04 15:00:07.000'),('5d7d44b7-2974-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_11bc8a6c-2973-11ef-9161-de41a781935b/occlusion_11be1b4d-2973-11ef-9161-de41a781935b/scan_129f0828-2973-11ef-9161-de41a781935b/5d7d44b7-2974-11ef-9161-de41a781935b.json','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_11bc8a6c-2973-11ef-9161-de41a781935b_SESS_11be1b4d-2973-11ef-9161-de41a781935b_TOSC_129f0828-2973-11ef-9161-de41a781935b_METER','5d7d44b7-2974-11ef-9161-de41a781935b.json','5d7d44b7-2974-11ef-9161-de41a781935b','{\"displayTitle\":\"1.2 Maxillaire u1 Mesure\"}','JSON',0,'CREATED',0,NULL,'2024-06-13 13:02:03.321','2024-06-13 11:02:03.323',NULL),('5d854a08-2973-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/scan_4cc68cd8-2962-11ef-9161-de41a781935b/5d854a08-2973-11ef-9161-de41a781935b.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_TOSC_4cc68cd8-2962-11ef-9161-de41a781935b_MODEL','5d854a08-2973-11ef-9161-de41a781935b.zip','809c945c-2962-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Maxillaire u1\",\"modelMatrix\":\"-0.840073,0.531409,-0.109002,0,-0.509977,-0.842143,-0.175265,0,-0.184933,-0.091647,0.978468,0,-3.66908,8.57904,-8.58551,1\",\"scanBodies\":[{\"position\":\"2.06903,5.05438,0,0,-0.995382,0,5.77626,0,6.47861,0,0,4,1,0,0,0\",\"reference\":\"K30PSCANPLG\",\"tid\":26}]}','ZIP',7,'CREATED',0,NULL,'2024-06-13 12:54:53.876','2024-06-13 10:54:53.914',NULL),('5f27c5df-296d-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/scan_4cc68cd8-2962-11ef-9161-de41a781935b/5f27c5df-296d-11ef-9161-de41a781935b.ply','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_TOSC_4cc68cd8-2962-11ef-9161-de41a781935b_SEG','5f27c5df-296d-11ef-9161-de41a781935b.ply','4fb005bd-296d-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Maxillaire u1 Segmentation\"}','PLY',1,'CREATED',0,NULL,'2024-06-13 12:11:59.639','2024-06-13 10:11:59.649',NULL),('5f8fef48-233c-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/computedocclusion_a2829ff3-2338-11ef-8f93-d92a45da78c9/5f8fef48-233c-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_OCC_a2829ff3-2338-11ef-8f93-d92a45da78c9_BO3','5f8fef48-233c-11ef-8f93-d92a45da78c9.zip','5f8fef48-233c-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Occlusion o1 Mandibule l2 [pc1]\",\"modelMatrix\":\"0.912405,-0.408985,0.0157505,0,0.408648,0.908152,-0.0909209,0,0.0228815,0.0893931,0.995733,0,-14.1029,6.9381,-10.6228,1\",\"occlusionMatrix\":\"0.978507,0.00506089,-0.206415,0,-0.206059,-0.0415388,-0.977659,0,-0.0100391,0.99914,-0.0397965,0,-17.2945,-6.52181,8.79408,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.5_l2\",\"referenceScanId\":\"596c4e98-233c-11ef-8f93-d92a45da78c9\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-05 15:06:12.000','2024-06-05 13:06:12.000','2024-06-05 15:06:12.000'),('5fc0481a-233c-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/computedocclusion_a2829ff3-2338-11ef-8f93-d92a45da78c9/5fc0481a-233c-11ef-8f93-d92a45da78c9.xyz','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_OCC_a2829ff3-2338-11ef-8f93-d92a45da78c9_LIFIO','5fc0481a-233c-11ef-8f93-d92a45da78c9.xyz','5fc0481a-233c-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Occlusion o1 Mandibule l2 Ligne de finition auto [pc1]\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MANDIBLE_3\",\"referenceScanFullDisplayId\":\"1.5_l2\",\"referenceScanId\":\"596c4e98-233c-11ef-8f93-d92a45da78c9\",\"title\":\"auto\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-05 15:06:13.000','2024-06-05 13:06:13.000','2024-06-05 15:06:13.000'),('5fc04dc7-233c-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/computedocclusion_a2829ff3-2338-11ef-8f93-d92a45da78c9/5fc04dc7-233c-11ef-8f93-d92a45da78c9.bin','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_OCC_a2829ff3-2338-11ef-8f93-d92a45da78c9_LIFIMO','5fc04dc7-233c-11ef-8f93-d92a45da78c9.bin','5fc04dc7-233c-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Occlusion o1 Mandibule l2 Ligne de finition métadonnées auto [pc1]\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MANDIBLE_3\",\"referenceScanFullDisplayId\":\"1.5_l2\",\"referenceScanId\":\"596c4e98-233c-11ef-8f93-d92a45da78c9\",\"title\":\"auto\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-05 15:06:13.000','2024-06-05 13:06:13.000','2024-06-05 15:06:13.000'),('5fc7cd8a-2988-11ef-8fb0-da2b4bf5ebbb',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_7eb8397d-2987-11ef-8fb0-da2b4bf5ebbb/occlusion_7eb98de9-2987-11ef-8fb0-da2b4bf5ebbb/scan_572a1881-2988-11ef-8fb0-da2b4bf5ebbb/5fc7cd8a-2988-11ef-8fb0-da2b4bf5ebbb.ply','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_7eb8397d-2987-11ef-8fb0-da2b4bf5ebbb_SESS_7eb98de9-2987-11ef-8fb0-da2b4bf5ebbb_TOSC_572a1881-2988-11ef-8fb0-da2b4bf5ebbb_SEG','5fc7cd8a-2988-11ef-8fb0-da2b4bf5ebbb.ply','5fc7cd8a-2988-11ef-8fb0-da2b4bf5ebbb','{\"displayTitle\":\"1.5 Maxillaire u2 Segmentation\"}','PLY',0,'CREATED',0,'2024-06-13 15:25:24.687','2024-06-13 15:25:24.687','2024-06-13 13:25:24.688',NULL),('5fe3c6fc-233b-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_2e146f3d-233a-11ef-8f93-d92a45da78c9/5fe3c6fc-233b-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_TOSC_2e146f3d-233a-11ef-8f93-d92a45da78c9_MODEL','5fe3c6fc-233b-11ef-8f93-d92a45da78c9.zip','2e1492f1-233a-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Maxillaire u2 [pc1]\",\"modelMatrix\":\"0.989237,-0.120037,-0.0836717,0,0.114747,0.991239,-0.0654089,0,0.0907902,0.0551039,0.994344,0,-9.57663,-0.954263,-9.009,1\",\"scanBodies\":[]}','ZIP',5,'SYNCED',0,NULL,'2024-06-05 14:59:00.000','2024-06-05 12:59:00.000','2024-06-05 14:59:00.000'),('613c6795-2278-11ef-8d76-d310d2ec2c14',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/computedocclusion_9ed6352b-2277-11ef-8d76-d310d2ec2c14/613c6795-2278-11ef-8d76-d310d2ec2c14.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_OCC_9ed6352b-2277-11ef-8d76-d310d2ec2c14_BO1','613c6795-2278-11ef-8d76-d310d2ec2c14.zip','5b0decc4-2278-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Occlusion o2 Mandibule l1 [pc2]\",\"modelMatrix\":\"0.135656,-0.982642,-0.126536,0,0.970104,0.157682,-0.184485,0,0.201235,-0.0977264,0.974656,0,-23.8369,18.6095,-10.139,1\",\"occlusionMatrix\":\"-0.177722,-0.165589,0.970054,0,0.976211,-0.154065,0.152557,0,0.124189,0.974083,0.189032,0,-19.034,-0.222657,-25.1768,1\",\"occlusionType\":5,\"referenceScanFullDisplayId\":\"1.2_l1\",\"referenceScanId\":\"96d08283-2273-11ef-8d76-d310d2ec2c14\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2024-06-04 15:43:11.000','2024-06-04 13:43:11.000','2024-06-04 15:43:11.000'),('638a6e9c-2336-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_3f0f8fd5-2336-11ef-8f93-d92a45da78c9/occlusion_3f113a7c-2336-11ef-8f93-d92a45da78c9/scan_40c1fc5f-2336-11ef-8f93-d92a45da78c9/638a6e9c-2336-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_3f0f8fd5-2336-11ef-8f93-d92a45da78c9_SESS_3f113a7c-2336-11ef-8f93-d92a45da78c9_TOSC_40c1fc5f-2336-11ef-8f93-d92a45da78c9_MODEL','638a6e9c-2336-11ef-8f93-d92a45da78c9.zip','638a6e9c-2336-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.4 Maxillaire u1 [pc1]\",\"modelMatrix\":\"-0.593379,0.792738,-0.13953,0,-0.673984,-0.584098,-0.452299,0,-0.440054,-0.174344,0.880884,0,11.0737,-4.1733,-8.10623,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,'2024-06-05 14:23:35.000','2024-06-05 14:23:23.000','2024-06-05 12:23:35.000','2024-06-05 14:23:35.000'),('638a8550-2336-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_3f0f8fd5-2336-11ef-8f93-d92a45da78c9/occlusion_3f113a7c-2336-11ef-8f93-d92a45da78c9/scan_40c1fc5f-2336-11ef-8f93-d92a45da78c9/638a8550-2336-11ef-8f93-d92a45da78c9.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_3f0f8fd5-2336-11ef-8f93-d92a45da78c9_SESS_3f113a7c-2336-11ef-8f93-d92a45da78c9_TOSC_40c1fc5f-2336-11ef-8f93-d92a45da78c9_SNAPS','638a8550-2336-11ef-8f93-d92a45da78c9.png','638a8550-2336-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.4 Maxillaire u1 Snapshot [pc1]\"}','PNG',0,'SYNCED',0,'2024-06-05 14:23:36.000','2024-06-05 14:23:24.000','2024-06-05 12:23:36.000','2024-06-05 14:23:36.000'),('645d823e-2269-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_757ed4bc-2266-11ef-8f1f-d8242c71b430/occlusion_75806ee1-2266-11ef-8f1f-d8242c71b430/scan_09768650-2267-11ef-8f1f-d8242c71b430/645d823e-2269-11ef-8f1f-d8242c71b430.xyz','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_TOSC_09768650-2267-11ef-8f1f-d8242c71b430_LIFI','645d823e-2269-11ef-8f1f-d8242c71b430.xyz','1b63f36c-2269-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.2 Maxillaire u1 Ligne de finition auto\",\"title\":\"auto\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',1,'SYNCED',0,NULL,'2024-06-04 13:55:52.253','2024-06-04 11:55:52.256','2024-06-04 13:55:52.499'),('645d9879-2269-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_757ed4bc-2266-11ef-8f1f-d8242c71b430/occlusion_75806ee1-2266-11ef-8f1f-d8242c71b430/scan_09768650-2267-11ef-8f1f-d8242c71b430/645d9879-2269-11ef-8f1f-d8242c71b430.bin','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_TOSC_09768650-2267-11ef-8f1f-d8242c71b430_LIFIM','645d9879-2269-11ef-8f1f-d8242c71b430.bin','1b63f931-2269-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.2 Maxillaire u1 Ligne de finition métadonnées auto\",\"title\":\"auto\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',1,'SYNCED',0,NULL,'2024-06-04 13:55:52.254','2024-06-04 11:55:52.257','2024-06-04 13:55:52.751'),('6461ca85-2269-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_757ed4bc-2266-11ef-8f1f-d8242c71b430/occlusion_75806ee1-2266-11ef-8f1f-d8242c71b430/computedocclusion_0b16efeb-2268-11ef-8f1f-d8242c71b430/6461ca85-2269-11ef-8f1f-d8242c71b430.xyz','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_OCC_0b16efeb-2268-11ef-8f1f-d8242c71b430_LIFIO','6461ca85-2269-11ef-8f1f-d8242c71b430.xyz','1b66dafd-2269-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.2 Occlusion o1 Maxillaire u1 Ligne de finition auto\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY_1\",\"referenceScanFullDisplayId\":\"1.2_u1\",\"referenceScanId\":\"09768650-2267-11ef-8f1f-d8242c71b430\",\"title\":\"auto\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',1,'SYNCED',0,NULL,'2024-06-04 13:55:53.000','2024-06-04 11:55:53.000','2024-06-04 13:55:53.000'),('6461d309-2269-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_757ed4bc-2266-11ef-8f1f-d8242c71b430/occlusion_75806ee1-2266-11ef-8f1f-d8242c71b430/computedocclusion_0b16efeb-2268-11ef-8f1f-d8242c71b430/6461d309-2269-11ef-8f1f-d8242c71b430.bin','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_OCC_0b16efeb-2268-11ef-8f1f-d8242c71b430_LIFIMO','6461d309-2269-11ef-8f1f-d8242c71b430.bin','1b66de9f-2269-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.2 Occlusion o1 Maxillaire u1 Ligne de finition métadonnées auto\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY_1\",\"referenceScanFullDisplayId\":\"1.2_u1\",\"referenceScanId\":\"09768650-2267-11ef-8f1f-d8242c71b430\",\"title\":\"auto\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',1,'SYNCED',0,NULL,'2024-06-04 13:55:53.000','2024-06-04 11:55:53.000','2024-06-04 13:55:53.000'),('66bc3d46-2272-11ef-8d76-d310d2ec2c14',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_62b97c61-226c-11ef-8d76-d310d2ec2c14/order_62bf4a87-226c-11ef-8d76-d310d2ec2c14/66bc3d46-2272-11ef-8d76-d310d2ec2c14.pdf','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_62b97c61-226c-11ef-8d76-d310d2ec2c14_PROST_62bf4a87-226c-11ef-8d76-d310d2ec2c14_FORM','66bc3d46-2272-11ef-8d76-d310d2ec2c14.pdf','66bc3d46-2272-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.1 fait sous env2 [pc2]\",\"title\":\"fait sous env2\"}','PDF',0,'SYNCED',0,NULL,'2024-06-04 15:00:22.000','2024-06-04 13:00:22.000','2024-06-04 15:00:22.000'),('676c8a9b-298c-11ef-8fb0-da2b4bf5ebbb',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/scan_b926a968-2962-11ef-9161-de41a781935b/676c8a9b-298c-11ef-8fb0-da2b4bf5ebbb.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_BOSC_b926a968-2962-11ef-9161-de41a781935b_MODEL','676c8a9b-298c-11ef-8fb0-da2b4bf5ebbb.zip','d9a1cf93-2962-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Mandibule l1\",\"modelMatrix\":\"-0.965965,0.0394655,-0.255646,0,0.0256859,-0.968774,-0.24661,0,-0.257396,-0.244783,0.934788,0,7.99549,3.40222,-6.3837,1\",\"scanBodies\":[]}','ZIP',7,'CREATED',0,NULL,'2024-06-13 15:54:07.910','2024-06-13 13:54:07.947',NULL),('6782502c-225b-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_e3862d66-225a-11ef-8f1f-d8242c71b430/occlusion_e3868e5f-225a-11ef-8f1f-d8242c71b430/scan_37ccba29-225b-11ef-8f1f-d8242c71b430/6782502c-225b-11ef-8f1f-d8242c71b430.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_SESS_e3868e5f-225a-11ef-8f1f-d8242c71b430_BOSC_37ccba29-225b-11ef-8f1f-d8242c71b430_MODEL','6782502c-225b-11ef-8f1f-d8242c71b430.zip','6782502c-225b-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.1 Mandibule l1\",\"modelMatrix\":\"-0.728037,0.684478,-0.03811,0,-0.685353,-0.725423,0.0636657,0,0.0159319,0.0724698,0.997243,0,9.49558,-10.7,-12.9454,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 12:15:47.000','2024-06-04 10:15:47.000','2024-06-04 12:15:47.000'),('67825ce8-225b-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_e3862d66-225a-11ef-8f1f-d8242c71b430/occlusion_e3868e5f-225a-11ef-8f1f-d8242c71b430/scan_37ccba29-225b-11ef-8f1f-d8242c71b430/67825ce8-225b-11ef-8f1f-d8242c71b430.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_SESS_e3868e5f-225a-11ef-8f1f-d8242c71b430_BOSC_37ccba29-225b-11ef-8f1f-d8242c71b430_SNAPS','67825ce8-225b-11ef-8f1f-d8242c71b430.png','67825ce8-225b-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.1 Mandibule l1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 12:15:47.000','2024-06-04 10:15:47.000','2024-06-04 12:15:47.000'),('697a5384-2967-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/computedocclusion_4df68750-2964-11ef-9161-de41a781935b/697a5384-2967-11ef-9161-de41a781935b.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_OCC_4df68750-2964-11ef-9161-de41a781935b_TO2','697a5384-2967-11ef-9161-de41a781935b.zip','697a5384-2967-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Occlusion o2 Maxillaire u2\",\"modelMatrix\":\"-0.872758,0.470809,-0.128964,0,-0.443838,-0.875321,-0.191887,0,-0.203227,-0.110232,0.972907,0,-2.56858,6.47103,-8.11483,1\",\"occlusionMatrix\":\"-0.945775,-0.142635,-0.291854,0,-0.298141,0.0236862,0.954286,0,-0.129054,0.989507,-0.0647556,0,-1.95114,-5.0381,0.906734,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.1_u2\",\"referenceScanId\":\"5a97f8c0-2967-11ef-9161-de41a781935b\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2024-06-13 11:29:19.977','2024-06-13 09:29:20.112',NULL),('6b271fd8-298c-11ef-8fb0-da2b4bf5ebbb',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/scan_b926a968-2962-11ef-9161-de41a781935b/6b271fd8-298c-11ef-8fb0-da2b4bf5ebbb.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_BOSC_b926a968-2962-11ef-9161-de41a781935b_MODEL','6b271fd8-298c-11ef-8fb0-da2b4bf5ebbb.zip','d9a1cf93-2962-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Mandibule l1\",\"modelMatrix\":\"-0.965965,0.0394655,-0.255646,0,0.0256859,-0.968774,-0.24661,0,-0.257396,-0.244783,0.934788,0,7.99549,3.40222,-6.3837,1\",\"scanBodies\":[]}','ZIP',8,'CREATED',0,NULL,'2024-06-13 15:54:14.166','2024-06-13 13:54:14.203',NULL),('6d75c326-233f-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/order_b19eef4f-2336-11ef-8f93-d92a45da78c9/6d75c326-233f-11ef-8f93-d92a45da78c9.pdf','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_PROST_b19eef4f-2336-11ef-8f93-d92a45da78c9_FORM','6d75c326-233f-11ef-8f93-d92a45da78c9.pdf','6d75c326-233f-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Facette [pc1]\",\"title\":\"Facette\"}','PDF',0,'SYNCED',0,NULL,'2024-06-05 15:28:02.000','2024-06-05 13:28:02.000','2024-06-05 15:28:02.000'),('700184ee-2974-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/computedocclusion_92d33b38-2963-11ef-9161-de41a781935b/700184ee-2974-11ef-9161-de41a781935b.png','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_OCC_92d33b38-2963-11ef-9161-de41a781935b_SCREENO','700184ee-2974-11ef-9161-de41a781935b.png','700184ee-2974-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Occlusion o1 Capture d\'écran 1\",\"occlusionType\":1,\"title\":\"1\"}','PNG',0,'CREATED',0,NULL,'2024-06-13 13:02:34.386','2024-06-13 11:02:34.442',NULL),('719a9003-233b-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_2e146f3d-233a-11ef-8f93-d92a45da78c9/719a9003-233b-11ef-8f93-d92a45da78c9.xyz','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_TOSC_2e146f3d-233a-11ef-8f93-d92a45da78c9_LIFI','719a9003-233b-11ef-8f93-d92a45da78c9.xyz','719a9003-233b-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Maxillaire u2 Ligne de finition 0 [pc1]\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-05 14:59:29.000','2024-06-05 12:59:29.000','2024-06-05 14:59:29.000'),('719a949c-233b-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_2e146f3d-233a-11ef-8f93-d92a45da78c9/719a949c-233b-11ef-8f93-d92a45da78c9.bin','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_TOSC_2e146f3d-233a-11ef-8f93-d92a45da78c9_LIFIM','719a949c-233b-11ef-8f93-d92a45da78c9.bin','719a949c-233b-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Maxillaire u2 Ligne de finition métadonnées 0 [pc1]\",\"title\":\"0\",\"toothNumber\":0,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-05 14:59:30.000','2024-06-05 12:59:30.000','2024-06-05 14:59:30.000'),('71a237c5-233b-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/computedocclusion_a2829ff3-2338-11ef-8f93-d92a45da78c9/71a237c5-233b-11ef-8f93-d92a45da78c9.xyz','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_OCC_a2829ff3-2338-11ef-8f93-d92a45da78c9_LIFIO','71a237c5-233b-11ef-8f93-d92a45da78c9.xyz','71a237c5-233b-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Occlusion o1 Maxillaire u2 Ligne de finition 0 [pc1]\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY_2\",\"referenceScanFullDisplayId\":\"1.5_u2\",\"referenceScanId\":\"2e146f3d-233a-11ef-8f93-d92a45da78c9\",\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-05 14:59:31.000','2024-06-05 12:59:31.000','2024-06-05 14:59:31.000'),('71a23b4a-233b-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/computedocclusion_a2829ff3-2338-11ef-8f93-d92a45da78c9/71a23b4a-233b-11ef-8f93-d92a45da78c9.bin','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_OCC_a2829ff3-2338-11ef-8f93-d92a45da78c9_LIFIMO','71a23b4a-233b-11ef-8f93-d92a45da78c9.bin','71a23b4a-233b-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Occlusion o1 Maxillaire u2 Ligne de finition métadonnées 0 [pc1]\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY_2\",\"referenceScanFullDisplayId\":\"1.5_u2\",\"referenceScanId\":\"2e146f3d-233a-11ef-8f93-d92a45da78c9\",\"title\":\"0\",\"toothNumber\":1000,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-05 14:59:31.000','2024-06-05 12:59:31.000','2024-06-05 14:59:31.000'),('7228f8bd-2339-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_ef3ba736-2337-11ef-8f93-d92a45da78c9/7228f8bd-2339-11ef-8f93-d92a45da78c9.json','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_TOSC_ef3ba736-2337-11ef-8f93-d92a45da78c9_METER','7228f8bd-2339-11ef-8f93-d92a45da78c9.json','7228f8bd-2339-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Maxillaire u1 Mesure [pc1]\"}','JSON',0,'SYNCED',0,NULL,'2024-06-05 14:45:11.000','2024-06-05 12:45:11.000','2024-06-05 14:45:11.000'),('74d6b1c3-226f-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f6cfa4bf-226e-11ef-8f1f-d8242c71b430/order_f6d25816-226e-11ef-8f1f-d8242c71b430/74d6b1c3-226f-11ef-8f1f-d8242c71b430.pdf','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f6cfa4bf-226e-11ef-8f1f-d8242c71b430_PROST_f6d25816-226e-11ef-8f1f-d8242c71b430_FORM','74d6b1c3-226f-11ef-8f1f-d8242c71b430.pdf','74d6b1c3-226f-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.3 Couronne [pc1]\",\"title\":\"Couronne\"}','PDF',0,'SYNCED',0,NULL,'2024-06-04 14:39:16.871','2024-06-04 12:39:17.562','2024-06-04 14:39:17.698'),('783ceded-2988-11ef-8fb0-da2b4bf5ebbb',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_7eb8397d-2987-11ef-8fb0-da2b4bf5ebbb/occlusion_7eb98de9-2987-11ef-8fb0-da2b4bf5ebbb/scan_76da1ce2-2988-11ef-8fb0-da2b4bf5ebbb/783ceded-2988-11ef-8fb0-da2b4bf5ebbb.ply','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_7eb8397d-2987-11ef-8fb0-da2b4bf5ebbb_SESS_7eb98de9-2987-11ef-8fb0-da2b4bf5ebbb_TOSC_76da1ce2-2988-11ef-8fb0-da2b4bf5ebbb_SEG','783ceded-2988-11ef-8fb0-da2b4bf5ebbb.ply','783ceded-2988-11ef-8fb0-da2b4bf5ebbb','{\"displayTitle\":\"1.5 Maxillaire u2 Segmentation\"}','PLY',0,'CREATED',0,'2024-06-13 15:26:04.339','2024-06-13 15:26:04.340','2024-06-13 13:26:04.340',NULL),('7930bc95-2267-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_757ed4bc-2266-11ef-8f1f-d8242c71b430/occlusion_75806ee1-2266-11ef-8f1f-d8242c71b430/scan_09768650-2267-11ef-8f1f-d8242c71b430/7930bc95-2267-11ef-8f1f-d8242c71b430.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_TOSC_09768650-2267-11ef-8f1f-d8242c71b430_MODEL','7930bc95-2267-11ef-8f1f-d8242c71b430.zip','7930bc95-2267-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.2 Maxillaire u1\",\"modelMatrix\":\"0.970663,-0.222677,0.0907083,0,0.239614,0.864538,-0.441769,0,0.019951,0.450543,0.892532,0,-17.9206,-4.24346,-12.6568,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 13:42:11.000','2024-06-04 11:42:11.000','2024-06-04 13:42:11.000'),('7930db48-2267-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_757ed4bc-2266-11ef-8f1f-d8242c71b430/occlusion_75806ee1-2266-11ef-8f1f-d8242c71b430/scan_09768650-2267-11ef-8f1f-d8242c71b430/7930db48-2267-11ef-8f1f-d8242c71b430.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_TOSC_09768650-2267-11ef-8f1f-d8242c71b430_SNAPS','7930db48-2267-11ef-8f1f-d8242c71b430.png','7930db48-2267-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.2 Maxillaire u1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 13:42:11.000','2024-06-04 11:42:11.000','2024-06-04 13:42:11.000'),('809c945c-2962-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/scan_4cc68cd8-2962-11ef-9161-de41a781935b/809c945c-2962-11ef-9161-de41a781935b.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_TOSC_4cc68cd8-2962-11ef-9161-de41a781935b_MODEL','809c945c-2962-11ef-9161-de41a781935b.zip','809c945c-2962-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Maxillaire u1\",\"modelMatrix\":\"-0.872758,0.470809,-0.128964,0,-0.443838,-0.875321,-0.191887,0,-0.203227,-0.110232,0.972907,0,-2.56858,6.47103,-8.11483,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2024-06-13 10:54:11.305','2024-06-13 08:54:11.649',NULL),('809cb098-2962-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/scan_4cc68cd8-2962-11ef-9161-de41a781935b/809cb098-2962-11ef-9161-de41a781935b.png','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_TOSC_4cc68cd8-2962-11ef-9161-de41a781935b_SNAPS','809cb098-2962-11ef-9161-de41a781935b.png','809cb098-2962-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Maxillaire u1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2024-06-13 10:54:11.306','2024-06-13 09:04:58.636',NULL),('80ff7e2f-2269-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_757ed4bc-2266-11ef-8f1f-d8242c71b430/occlusion_75806ee1-2266-11ef-8f1f-d8242c71b430/scan_09768650-2267-11ef-8f1f-d8242c71b430/80ff7e2f-2269-11ef-8f1f-d8242c71b430.xyz','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_TOSC_09768650-2267-11ef-8f1f-d8242c71b430_LIFI','80ff7e2f-2269-11ef-8f1f-d8242c71b430.xyz','80ff7e2f-2269-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.2 Maxillaire u1 Ligne de finition 1\",\"title\":\"1\",\"toothNumber\":1,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-04 13:56:40.291','2024-06-04 11:56:40.294','2024-06-04 13:56:40.580'),('80ff8276-2269-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_757ed4bc-2266-11ef-8f1f-d8242c71b430/occlusion_75806ee1-2266-11ef-8f1f-d8242c71b430/scan_09768650-2267-11ef-8f1f-d8242c71b430/80ff8276-2269-11ef-8f1f-d8242c71b430.bin','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_TOSC_09768650-2267-11ef-8f1f-d8242c71b430_LIFIM','80ff8276-2269-11ef-8f1f-d8242c71b430.bin','80ff8276-2269-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.2 Maxillaire u1 Ligne de finition métadonnées 1\",\"title\":\"1\",\"toothNumber\":1,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-04 13:56:40.291','2024-06-04 11:56:40.303','2024-06-04 13:56:40.839'),('8103b4c6-2269-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_757ed4bc-2266-11ef-8f1f-d8242c71b430/occlusion_75806ee1-2266-11ef-8f1f-d8242c71b430/computedocclusion_0b16efeb-2268-11ef-8f1f-d8242c71b430/8103b4c6-2269-11ef-8f1f-d8242c71b430.xyz','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_OCC_0b16efeb-2268-11ef-8f1f-d8242c71b430_LIFIO','8103b4c6-2269-11ef-8f1f-d8242c71b430.xyz','8103b4c6-2269-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.2 Occlusion o1 Maxillaire u1 Ligne de finition 1\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY_1\",\"referenceScanFullDisplayId\":\"1.2_u1\",\"referenceScanId\":\"09768650-2267-11ef-8f1f-d8242c71b430\",\"title\":\"1\",\"toothNumber\":1001,\"versionMarginLine\":1}','XYZ',0,'SYNCED',0,NULL,'2024-06-04 13:56:41.000','2024-06-04 11:56:41.000','2024-06-04 13:56:41.000'),('8103b848-2269-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_757ed4bc-2266-11ef-8f1f-d8242c71b430/occlusion_75806ee1-2266-11ef-8f1f-d8242c71b430/computedocclusion_0b16efeb-2268-11ef-8f1f-d8242c71b430/8103b848-2269-11ef-8f1f-d8242c71b430.bin','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_OCC_0b16efeb-2268-11ef-8f1f-d8242c71b430_LIFIMO','8103b848-2269-11ef-8f1f-d8242c71b430.bin','8103b848-2269-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.2 Occlusion o1 Maxillaire u1 Ligne de finition métadonnées 1\",\"isOcclusionMarginLine\":true,\"lifi_scan_occ_type\":\"MAXILLARY_1\",\"referenceScanFullDisplayId\":\"1.2_u1\",\"referenceScanId\":\"09768650-2267-11ef-8f1f-d8242c71b430\",\"title\":\"1\",\"toothNumber\":1001,\"versionMarginLine\":1}','BIN',0,'SYNCED',0,NULL,'2024-06-04 13:56:41.000','2024-06-04 11:56:41.000','2024-06-04 13:56:41.000'),('84059dad-2974-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/computedocclusion_92d33b38-2963-11ef-9161-de41a781935b/84059dad-2974-11ef-9161-de41a781935b.json','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_OCC_92d33b38-2963-11ef-9161-de41a781935b_METER','84059dad-2974-11ef-9161-de41a781935b.json','84059dad-2974-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Occlusion o1\",\"occlusionType\":1}','JSON',0,'CREATED',0,NULL,'2024-06-13 13:03:07.968','2024-06-13 11:03:07.970',NULL),('84af3b89-233b-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_23e52d54-2338-11ef-8f93-d92a45da78c9/84af3b89-233b-11ef-8f93-d92a45da78c9.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_BOSC_23e52d54-2338-11ef-8f93-d92a45da78c9_SCREENS','84af3b89-233b-11ef-8f93-d92a45da78c9.png','84af3b89-233b-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Mandibule l1 Capture d\'écran 1 [pc1]\",\"title\":\"1\"}','PNG',0,'SYNCED',0,NULL,'2024-06-05 15:00:02.000','2024-06-05 13:00:02.000','2024-06-05 15:00:02.000'),('851d6596-225b-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_e3862d66-225a-11ef-8f1f-d8242c71b430/occlusion_e3868e5f-225a-11ef-8f1f-d8242c71b430/scan_6d6c8ddd-225b-11ef-8f1f-d8242c71b430/851d6596-225b-11ef-8f1f-d8242c71b430.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_SESS_e3868e5f-225a-11ef-8f1f-d8242c71b430_LESC_6d6c8ddd-225b-11ef-8f1f-d8242c71b430_MODEL','851d6596-225b-11ef-8f1f-d8242c71b430.zip','851d6596-225b-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.1 Mordu gauche bl1\",\"modelMatrix\":\"-0.999508,0.0223785,0.0203732,0,-0.0257704,-0.989134,-0.144672,0,0.0179061,-0.145308,0.989271,0,2.83546,2.10173,-5.23239,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 12:16:36.000','2024-06-04 10:16:36.000','2024-06-04 12:16:36.000'),('851d78b9-225b-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_e3862d66-225a-11ef-8f1f-d8242c71b430/occlusion_e3868e5f-225a-11ef-8f1f-d8242c71b430/scan_6d6c8ddd-225b-11ef-8f1f-d8242c71b430/851d78b9-225b-11ef-8f1f-d8242c71b430.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_SESS_e3868e5f-225a-11ef-8f1f-d8242c71b430_LESC_6d6c8ddd-225b-11ef-8f1f-d8242c71b430_SNAPS','851d78b9-225b-11ef-8f1f-d8242c71b430.png','851d78b9-225b-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.1 Mordu gauche bl1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 12:16:36.000','2024-06-04 10:16:36.000','2024-06-04 12:16:36.000'),('8c08eecf-2278-11ef-8d76-d310d2ec2c14',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/computedocclusion_9ed6352b-2277-11ef-8d76-d310d2ec2c14/8c08eecf-2278-11ef-8d76-d310d2ec2c14.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_OCC_9ed6352b-2277-11ef-8d76-d310d2ec2c14_TO1','8c08eecf-2278-11ef-8d76-d310d2ec2c14.zip','5adbc9bc-2278-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Occlusion o2 Maxillaire u1 [pc2]\",\"modelMatrix\":\"-0.0834467,0.986107,-0.143628,0,-0.981709,-0.1061,-0.158085,0,-0.171128,0.12781,0.976924,0,-17.1278,-28.7907,-11.2181,1\",\"occlusionMatrix\":\"-0.0756181,0.13399,0.988093,0,-0.98681,0.13219,-0.0934457,0,-0.143138,-0.982127,0.122228,0,-17.9384,11.0046,-27.4488,1\",\"occlusionType\":5,\"referenceScanFullDisplayId\":\"1.2_u1\",\"referenceScanId\":\"f3b0649e-2272-11ef-8d76-d310d2ec2c14\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2024-06-04 15:44:22.000','2024-06-04 13:44:22.000','2024-06-04 15:44:22.000'),('8da9c330-2269-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_757ed4bc-2266-11ef-8f1f-d8242c71b430/occlusion_75806ee1-2266-11ef-8f1f-d8242c71b430/computedocclusion_0b16efeb-2268-11ef-8f1f-d8242c71b430/8da9c330-2269-11ef-8f1f-d8242c71b430.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_OCC_0b16efeb-2268-11ef-8f1f-d8242c71b430_BO1','8da9c330-2269-11ef-8f1f-d8242c71b430.zip','f379f4d9-2268-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.2 Occlusion o1 Mandibule l1\",\"modelMatrix\":\"0.988582,0.0775562,-0.129192,0,-0.0638786,0.992221,0.106846,0,0.136474,-0.0973735,0.985846,0,-17.8094,0.329057,-12.0411,1\",\"occlusionMatrix\":\"0.967115,-0.162627,-0.195617,0,-0.236852,-0.295065,-0.925664,0,0.0928169,0.941543,-0.323876,0,-16.3387,-5.9884,6.66074,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.2_l1\",\"referenceScanId\":\"b4da925f-2267-11ef-8f1f-d8242c71b430\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,'2024-06-04 13:57:23.068','2024-06-04 13:57:23.069','2024-06-04 11:57:23.069','2024-06-04 13:57:23.078'),('9005271a-2273-11ef-8d76-d310d2ec2c14',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/scan_f3b0649e-2272-11ef-8d76-d310d2ec2c14/9005271a-2273-11ef-8d76-d310d2ec2c14.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_TOSC_f3b0649e-2272-11ef-8d76-d310d2ec2c14_MODEL','9005271a-2273-11ef-8d76-d310d2ec2c14.zip','9005271a-2273-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Maxillaire u1 [pc2]\",\"modelMatrix\":\"-0.0834467,0.986107,-0.143628,0,-0.981709,-0.1061,-0.158085,0,-0.171128,0.12781,0.976924,0,-17.1278,-28.7907,-11.2181,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 15:08:45.000','2024-06-04 13:08:45.000','2024-06-04 15:08:45.000'),('90053a20-2273-11ef-8d76-d310d2ec2c14',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/scan_f3b0649e-2272-11ef-8d76-d310d2ec2c14/90053a20-2273-11ef-8d76-d310d2ec2c14.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_TOSC_f3b0649e-2272-11ef-8d76-d310d2ec2c14_SNAPS','90053a20-2273-11ef-8d76-d310d2ec2c14.png','90053a20-2273-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Maxillaire u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 15:08:45.000','2024-06-04 13:08:45.000','2024-06-04 15:08:45.000'),('903b3627-2965-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/computedocclusion_4df68750-2964-11ef-9161-de41a781935b/903b3627-2965-11ef-9161-de41a781935b.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_OCC_4df68750-2964-11ef-9161-de41a781935b_TO1','903b3627-2965-11ef-9161-de41a781935b.zip','903b3627-2965-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Occlusion o2 Maxillaire u1\",\"modelMatrix\":\"-0.872758,0.470809,-0.128964,0,-0.443838,-0.875321,-0.191887,0,-0.203227,-0.110232,0.972907,0,-2.56858,6.47103,-8.11483,1\",\"occlusionMatrix\":\"-0.945775,-0.142635,-0.291853,0,-0.298141,0.0236844,0.954286,0,-0.129055,0.989507,-0.0647538,0,-1.95113,-5.03807,0.906734,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.1_u1\",\"referenceScanId\":\"4cc68cd8-2962-11ef-9161-de41a781935b\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2024-06-13 11:16:06.001','2024-06-13 09:16:06.296',NULL),('9044fd9c-2988-11ef-8fb0-da2b4bf5ebbb',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_7eb8397d-2987-11ef-8fb0-da2b4bf5ebbb/occlusion_7eb98de9-2987-11ef-8fb0-da2b4bf5ebbb/scan_8ed434a9-2988-11ef-8fb0-da2b4bf5ebbb/9044fd9c-2988-11ef-8fb0-da2b4bf5ebbb.ply','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_7eb8397d-2987-11ef-8fb0-da2b4bf5ebbb_SESS_7eb98de9-2987-11ef-8fb0-da2b4bf5ebbb_TOSC_8ed434a9-2988-11ef-8fb0-da2b4bf5ebbb_SEG','9044fd9c-2988-11ef-8fb0-da2b4bf5ebbb.ply','9044fd9c-2988-11ef-8fb0-da2b4bf5ebbb','{\"displayTitle\":\"1.5 Maxillaire u2 Segmentation\"}','PLY',0,'CREATED',0,'2024-06-13 15:26:41.970','2024-06-13 15:26:41.970','2024-06-13 13:26:41.970',NULL),('9051c4d1-2965-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/computedocclusion_4df68750-2964-11ef-9161-de41a781935b/9051c4d1-2965-11ef-9161-de41a781935b.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_OCC_4df68750-2964-11ef-9161-de41a781935b_BO1','9051c4d1-2965-11ef-9161-de41a781935b.zip','9051c4d1-2965-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Occlusion o2 Mandibule l1\",\"modelMatrix\":\"0.96054,0.0160431,-0.277679,0,-0.0791538,0.972823,-0.217602,0,0.266641,0.230994,0.935705,0,-9.25344,-4.26872,-6.69421,1\",\"occlusionMatrix\":\"0.427788,0.11448,0.896576,0,-0.903735,0.0719521,0.422119,0,-0.0163389,-0.990818,0.134082,0,-11.0191,5.53849,-13.1649,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.1_l1\",\"referenceScanId\":\"b926a968-2962-11ef-9161-de41a781935b\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2024-06-13 11:16:06.148','2024-06-13 09:16:06.297',NULL),('90da0803-2965-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/computedocclusion_4df68750-2964-11ef-9161-de41a781935b/90da0803-2965-11ef-9161-de41a781935b.png','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_OCC_4df68750-2964-11ef-9161-de41a781935b_SNAPO','90da0803-2965-11ef-9161-de41a781935b.png','90da0803-2965-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Occlusion o2\",\"occlusionType\":1}','PNG',0,'CREATED',0,NULL,'2024-06-13 11:16:07.041','2024-06-13 09:16:07.044',NULL),('9484c123-225d-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_e3862d66-225a-11ef-8f1f-d8242c71b430/occlusion_e3868e5f-225a-11ef-8f1f-d8242c71b430/scan_e52279ce-225a-11ef-8f1f-d8242c71b430/9484c123-225d-11ef-8f1f-d8242c71b430.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_SESS_e3868e5f-225a-11ef-8f1f-d8242c71b430_TOSC_e52279ce-225a-11ef-8f1f-d8242c71b430_SCREENS','9484c123-225d-11ef-8f1f-d8242c71b430.png','9484c123-225d-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.1 Maxillaire u1 Capture d\'écran n°16\",\"title\":\"n°16\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 12:32:41.569','2024-06-04 10:32:41.569','2024-06-04 12:32:41.579'),('9a5291cb-23eb-11ef-8dde-d415e84cc4f5',3,'/var/iris/.data/2024/3/907398e3-23e7-11ef-8dde-d415e84cc4f5/session_8d2006e5-23eb-11ef-8dde-d415e84cc4f5/order_8d24e986-23eb-11ef-8dde-d415e84cc4f5/9a5291cb-23eb-11ef-8dde-d415e84cc4f5.pdf','PATIENT_907398e3-23e7-11ef-8dde-d415e84cc4f5_ACT_8d2006e5-23eb-11ef-8dde-d415e84cc4f5_PROST_8d24e986-23eb-11ef-8dde-d415e84cc4f5_FORM','9a5291cb-23eb-11ef-8dde-d415e84cc4f5.pdf','9a5291cb-23eb-11ef-8dde-d415e84cc4f5','{\"displayTitle\":\"2.3 Autre [pc1]\",\"title\":\"Autre\"}','PDF',0,'SYNCED',0,NULL,'2024-06-06 12:00:29.000','2024-06-06 10:00:29.000','2024-06-06 12:00:29.000'),('9b38ec14-2967-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/scan_7b02accf-2967-11ef-9161-de41a781935b/9b38ec14-2967-11ef-9161-de41a781935b.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_RISC_7b02accf-2967-11ef-9161-de41a781935b_MODEL','9b38ec14-2967-11ef-9161-de41a781935b.zip','9b38ec14-2967-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Mordu droit br3\",\"modelMatrix\":\"0.998993,-0.0272533,0.0331776,0,0.0277658,0.99762,0.0644743,0,-0.0353465,-0.0633896,0.997368,0,-10.6922,5.3411,-16.3205,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2024-06-13 11:30:43.434','2024-06-13 09:30:43.666',NULL),('9b38fa58-2967-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/scan_7b02accf-2967-11ef-9161-de41a781935b/9b38fa58-2967-11ef-9161-de41a781935b.png','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_RISC_7b02accf-2967-11ef-9161-de41a781935b_SNAPS','9b38fa58-2967-11ef-9161-de41a781935b.png','9b38fa58-2967-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Mordu droit br3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2024-06-13 11:30:43.434','2024-06-13 09:30:43.667',NULL),('9b610e0d-233e-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_8c23d690-233c-11ef-8f93-d92a45da78c9/occlusion_8c257d6d-233c-11ef-8f93-d92a45da78c9/scan_9b60e5c1-233e-11ef-8f93-d92a45da78c9/9b610e0d-233e-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_8c23d690-233c-11ef-8f93-d92a45da78c9_SESS_8c257d6d-233c-11ef-8f93-d92a45da78c9_BOSC_9b60e5c1-233e-11ef-8f93-d92a45da78c9_MODEL','9b610e0d-233e-11ef-8f93-d92a45da78c9.zip','9b610e0d-233e-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.6 Mandibule l3 [pc1]\",\"modelMatrix\":\"-0.720136,-0.687674,-0.0922383,0,0.657563,-0.718853,0.225522,0,-0.221392,0.101754,0.969862,0,7.84249,5.63311,-11.0618,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-05 15:22:09.000','2024-06-05 13:22:09.000','2024-06-05 15:22:09.000'),('9b65adc6-233e-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_8c23d690-233c-11ef-8f93-d92a45da78c9/occlusion_8c257d6d-233c-11ef-8f93-d92a45da78c9/scan_9b60e5c1-233e-11ef-8f93-d92a45da78c9/9b65adc6-233e-11ef-8f93-d92a45da78c9.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_8c23d690-233c-11ef-8f93-d92a45da78c9_SESS_8c257d6d-233c-11ef-8f93-d92a45da78c9_BOSC_9b60e5c1-233e-11ef-8f93-d92a45da78c9_SNAPS','9b65adc6-233e-11ef-8f93-d92a45da78c9.png','9b65adc6-233e-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.6 Mandibule l3 Snapshot [pc1]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-05 15:22:09.000','2024-06-05 13:22:09.000','2024-06-05 15:22:09.000'),('9c695ea5-233b-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_23e52d54-2338-11ef-8f93-d92a45da78c9/9c695ea5-233b-11ef-8f93-d92a45da78c9.ply','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_BOSC_23e52d54-2338-11ef-8f93-d92a45da78c9_SEG','9c695ea5-233b-11ef-8f93-d92a45da78c9.ply','9c695ea5-233b-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Mandibule l1 Segmentation [pc1]\"}','PLY',0,'SYNCED',0,NULL,'2024-06-05 15:00:41.000','2024-06-05 13:00:41.000','2024-06-05 15:00:41.000'),('9d0b79b6-2268-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_757ed4bc-2266-11ef-8f1f-d8242c71b430/occlusion_75806ee1-2266-11ef-8f1f-d8242c71b430/scan_5982089a-2268-11ef-8f1f-d8242c71b430/9d0b79b6-2268-11ef-8f1f-d8242c71b430.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_LESC_5982089a-2268-11ef-8f1f-d8242c71b430_MODEL','9d0b79b6-2268-11ef-8f1f-d8242c71b430.zip','9d0b79b6-2268-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.2 Mordu gauche bl2\",\"modelMatrix\":\"-0.998779,0.0453186,-0.0274367,0,-0.0464911,-0.995795,0.0800651,0,-0.0177725,0.079631,0.996431,0,-16.6346,-6.34296,-9.79418,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 13:50:21.000','2024-06-04 11:50:21.000','2024-06-04 13:50:21.000'),('9d0cb7bd-2268-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_757ed4bc-2266-11ef-8f1f-d8242c71b430/occlusion_75806ee1-2266-11ef-8f1f-d8242c71b430/scan_5982089a-2268-11ef-8f1f-d8242c71b430/9d0cb7bd-2268-11ef-8f1f-d8242c71b430.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_LESC_5982089a-2268-11ef-8f1f-d8242c71b430_SNAPS','9d0cb7bd-2268-11ef-8f1f-d8242c71b430.png','9d0cb7bd-2268-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.2 Mordu gauche bl2 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 13:50:21.000','2024-06-04 11:50:21.000','2024-06-04 13:50:21.000'),('9da74cf3-2967-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/computedocclusion_784469a2-2967-11ef-9161-de41a781935b/9da74cf3-2967-11ef-9161-de41a781935b.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_OCC_784469a2-2967-11ef-9161-de41a781935b_TO1','9da74cf3-2967-11ef-9161-de41a781935b.zip','9da74cf3-2967-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Occlusion o3 Maxillaire u2\",\"modelMatrix\":\"-0.872758,0.470809,-0.128964,0,-0.443838,-0.875321,-0.191887,0,-0.203227,-0.110232,0.972907,0,-2.56858,6.47103,-8.11483,1\",\"occlusionMatrix\":\"0.981194,-0.114499,-0.155413,0,-0.191551,-0.477846,-0.85731,0,0.023895,0.870952,-0.490792,0,3.19177,-11.6144,3.19615,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.1_u2\",\"referenceScanId\":\"5a97f8c0-2967-11ef-9161-de41a781935b\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,'2024-06-13 11:36:40.806','2024-06-13 11:30:47.513','2024-06-13 09:36:40.807',NULL),('9dbc599e-2967-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/computedocclusion_784469a2-2967-11ef-9161-de41a781935b/9dbc599e-2967-11ef-9161-de41a781935b.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_OCC_784469a2-2967-11ef-9161-de41a781935b_BO1','9dbc599e-2967-11ef-9161-de41a781935b.zip','9dbc599e-2967-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Occlusion o3 Mandibule l1\",\"modelMatrix\":\"0.96054,0.0160431,-0.277679,0,-0.0791538,0.972823,-0.217602,0,0.266641,0.230994,0.935705,0,-9.25344,-4.26872,-6.69421,1\",\"occlusionMatrix\":\"-0.845345,0.501221,-0.185183,0,-0.0354258,-0.398378,-0.916588,0,-0.533171,-0.768203,0.354502,0,15.1406,10.6426,2.34458,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.1_l1\",\"referenceScanId\":\"b926a968-2962-11ef-9161-de41a781935b\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,'2024-06-13 11:36:40.806','2024-06-13 11:30:47.651','2024-06-13 09:36:40.807',NULL),('9e2333cd-2967-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/computedocclusion_784469a2-2967-11ef-9161-de41a781935b/9e2333cd-2967-11ef-9161-de41a781935b.png','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_OCC_784469a2-2967-11ef-9161-de41a781935b_SNAPO','9e2333cd-2967-11ef-9161-de41a781935b.png','9e2333cd-2967-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Occlusion o3\",\"occlusionType\":1}','PNG',0,'CREATED',0,'2024-06-13 11:36:40.806','2024-06-13 11:30:48.325','2024-06-13 09:36:40.807',NULL),('9e41d416-2269-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_757ed4bc-2266-11ef-8f1f-d8242c71b430/occlusion_75806ee1-2266-11ef-8f1f-d8242c71b430/computedocclusion_0b16efeb-2268-11ef-8f1f-d8242c71b430/9e41d416-2269-11ef-8f1f-d8242c71b430.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_OCC_0b16efeb-2268-11ef-8f1f-d8242c71b430_BO1','9e41d416-2269-11ef-8f1f-d8242c71b430.zip','f379f4d9-2268-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.2 Occlusion o1 Mandibule l1\",\"modelMatrix\":\"0.988582,0.0775562,-0.129192,0,-0.0638786,0.992221,0.106846,0,0.136474,-0.0973735,0.985846,0,-17.8094,0.329057,-12.0411,1\",\"occlusionMatrix\":\"0.967115,-0.162627,-0.195617,0,-0.236852,-0.295065,-0.925664,0,0.0928169,0.941543,-0.323876,0,-16.3387,-5.9884,6.66074,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.2_l1\",\"referenceScanId\":\"b4da925f-2267-11ef-8f1f-d8242c71b430\",\"scanBodies\":[]}','ZIP',2,'SYNCED',0,NULL,'2024-06-04 13:57:30.000','2024-06-04 11:57:30.000','2024-06-04 13:57:30.000'),('a1f8fad4-23eb-11ef-867c-6ec2958327c0',2,'/var/iris/.data/2024/2/discussion_0f3dfe44-225d-11ef-8f1f-d8242c71b430/a1f8fad4-23eb-11ef-867c-6ec2958327c0.pdf','PATIENT_907398e3-23e7-11ef-8dde-d415e84cc4f5_ACT_8d2006e5-23eb-11ef-8dde-d415e84cc4f5_PROST_8d24e986-23eb-11ef-8dde-d415e84cc4f5_FORM','9a5291cb-23eb-11ef-8dde-d415e84cc4f5.pdf','a1f8fad4-23eb-11ef-867c-6ec2958327c0','{\"displayTitle\":\"2.3 Autre [pc1]\",\"title\":\"Autre\"}','PDF',0,'SYNCED',0,NULL,'2024-06-06 12:00:29.000','2024-06-06 10:00:29.000','2024-06-06 12:00:29.000'),('a1fba852-23eb-11ef-867c-6ec2958327c0',2,'/var/iris/.data/2024/2/discussion_0f3dfe44-225d-11ef-8f1f-d8242c71b430/a1fba852-23eb-11ef-867c-6ec2958327c0.zip','PATIENT_907398e3-23e7-11ef-8dde-d415e84cc4f5_ACT_96aedcf6-23e7-11ef-8dde-d415e84cc4f5_SESS_96b19cc6-23e7-11ef-8dde-d415e84cc4f5_TOSC_981faf70-23e7-11ef-8dde-d415e84cc4f5_MODEL','d0ab5861-23e7-11ef-8dde-d415e84cc4f5.zip','a1fba852-23eb-11ef-867c-6ec2958327c0','{\"displayTitle\":\"2.1 Maxillaire u1 [pc1]\",\"modelMatrix\":\"0.998773,-0.00202182,-0.0494821,0,0.00445529,0.998783,0.0491187,0,0.0493226,-0.0492789,0.997566,0,1.86586,2.73136,-15.9281,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-06 11:33:25.000','2024-06-06 09:33:25.000','2024-06-06 11:33:25.000'),('a1fc17b1-23eb-11ef-867c-6ec2958327c0',2,'/var/iris/.data/2024/2/discussion_0f3dfe44-225d-11ef-8f1f-d8242c71b430/a1fc17b1-23eb-11ef-867c-6ec2958327c0.png','PATIENT_907398e3-23e7-11ef-8dde-d415e84cc4f5_ACT_96aedcf6-23e7-11ef-8dde-d415e84cc4f5_SESS_96b19cc6-23e7-11ef-8dde-d415e84cc4f5_TOSC_981faf70-23e7-11ef-8dde-d415e84cc4f5_SNAPS','d0ab69d4-23e7-11ef-8dde-d415e84cc4f5.png','a1fc17b1-23eb-11ef-867c-6ec2958327c0','{\"displayTitle\":\"2.1 Maxillaire u1 Snapshot [pc1]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-06 11:33:26.000','2024-06-06 09:33:26.000','2024-06-06 11:33:26.000'),('a214ed06-233a-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_23e52d54-2338-11ef-8f93-d92a45da78c9/a214ed06-233a-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_BOSC_23e52d54-2338-11ef-8f93-d92a45da78c9_MODEL','a214ed06-233a-11ef-8f93-d92a45da78c9.zip','4c944e2f-2338-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Mandibule l1 [pc1]\",\"modelMatrix\":\"0.912405,-0.408985,0.0157505,0,0.408648,0.908152,-0.0909209,0,0.0228815,0.0893931,0.995733,0,-14.1029,6.9381,-10.6228,1\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2024-06-05 14:53:46.000','2024-06-05 12:53:46.000','2024-06-05 14:53:46.000'),('a5fed54d-2269-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_757ed4bc-2266-11ef-8f1f-d8242c71b430/occlusion_75806ee1-2266-11ef-8f1f-d8242c71b430/computedocclusion_0b16efeb-2268-11ef-8f1f-d8242c71b430/a5fed54d-2269-11ef-8f1f-d8242c71b430.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_OCC_0b16efeb-2268-11ef-8f1f-d8242c71b430_BO1','a5fed54d-2269-11ef-8f1f-d8242c71b430.zip','f379f4d9-2268-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.2 Occlusion o1 Mandibule l1\",\"modelMatrix\":\"0.988582,0.0775562,-0.129192,0,-0.0638786,0.992221,0.106846,0,0.136474,-0.0973735,0.985846,0,-17.8094,0.329057,-12.0411,1\",\"occlusionMatrix\":\"0.967115,-0.162627,-0.195617,0,-0.236852,-0.295065,-0.925664,0,0.0928169,0.941543,-0.323876,0,-18.0525,4.52343,9.16761,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.2_l1\",\"referenceScanId\":\"b4da925f-2267-11ef-8f1f-d8242c71b430\",\"scanBodies\":[]}','ZIP',3,'SYNCED',0,'2024-06-04 13:57:45.903','2024-06-04 13:57:45.903','2024-06-04 11:57:45.903','2024-06-04 13:57:45.913'),('a7027d3d-2988-11ef-8fb0-da2b4bf5ebbb',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_7eb8397d-2987-11ef-8fb0-da2b4bf5ebbb/occlusion_7eb98de9-2987-11ef-8fb0-da2b4bf5ebbb/scan_a59fb00b-2988-11ef-8fb0-da2b4bf5ebbb/a7027d3d-2988-11ef-8fb0-da2b4bf5ebbb.ply','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_7eb8397d-2987-11ef-8fb0-da2b4bf5ebbb_SESS_7eb98de9-2987-11ef-8fb0-da2b4bf5ebbb_TOSC_a59fb00b-2988-11ef-8fb0-da2b4bf5ebbb_SEG','a7027d3d-2988-11ef-8fb0-da2b4bf5ebbb.ply','a7027d3d-2988-11ef-8fb0-da2b4bf5ebbb','{\"displayTitle\":\"1.5 Maxillaire u2 Segmentation\"}','PLY',0,'CREATED',0,'2024-06-13 15:27:20.133','2024-06-13 15:27:20.133','2024-06-13 13:27:20.134',NULL),('a9521e0f-225d-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_e3862d66-225a-11ef-8f1f-d8242c71b430/occlusion_e3868e5f-225a-11ef-8f1f-d8242c71b430/scan_e52279ce-225a-11ef-8f1f-d8242c71b430/a9521e0f-225d-11ef-8f1f-d8242c71b430.json','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_SESS_e3868e5f-225a-11ef-8f1f-d8242c71b430_TOSC_e52279ce-225a-11ef-8f1f-d8242c71b430_METER','a9521e0f-225d-11ef-8f1f-d8242c71b430.json','a9521e0f-225d-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.1 Maxillaire u1 Mesure\"}','JSON',0,'SYNCED',0,NULL,'2024-06-04 12:31:54.000','2024-06-04 10:31:54.000','2024-06-04 12:31:54.000'),('acfa30bf-233c-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_8c23d690-233c-11ef-8f93-d92a45da78c9/occlusion_8c257d6d-233c-11ef-8f93-d92a45da78c9/scan_93bdd6ef-233c-11ef-8f93-d92a45da78c9/acfa30bf-233c-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_8c23d690-233c-11ef-8f93-d92a45da78c9_SESS_8c257d6d-233c-11ef-8f93-d92a45da78c9_TOSC_93bdd6ef-233c-11ef-8f93-d92a45da78c9_MODEL','acfa30bf-233c-11ef-8f93-d92a45da78c9.zip','acfa30bf-233c-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.6 Maxillaire u1 [pc1]\",\"modelMatrix\":\"0.997697,-0.0584844,0.0343697,0,0.0677866,0.840217,-0.537996,0,0.00258638,0.539087,0.842246,0,-9.2933,-7.87258,-10.443,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-05 15:08:20.000','2024-06-05 13:08:20.000','2024-06-05 15:08:20.000'),('acfa42a4-233c-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_8c23d690-233c-11ef-8f93-d92a45da78c9/occlusion_8c257d6d-233c-11ef-8f93-d92a45da78c9/scan_93bdd6ef-233c-11ef-8f93-d92a45da78c9/acfa42a4-233c-11ef-8f93-d92a45da78c9.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_8c23d690-233c-11ef-8f93-d92a45da78c9_SESS_8c257d6d-233c-11ef-8f93-d92a45da78c9_TOSC_93bdd6ef-233c-11ef-8f93-d92a45da78c9_SNAPS','acfa42a4-233c-11ef-8f93-d92a45da78c9.png','acfa42a4-233c-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.6 Maxillaire u1 Snapshot [pc1]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-05 15:08:21.000','2024-06-05 13:08:21.000','2024-06-05 15:08:21.000'),('b0cc95f2-233b-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_23e52d54-2338-11ef-8f93-d92a45da78c9/b0cc95f2-233b-11ef-8f93-d92a45da78c9.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_BOSC_23e52d54-2338-11ef-8f93-d92a45da78c9_SCREENS','b0cc95f2-233b-11ef-8f93-d92a45da78c9.png','b0cc95f2-233b-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Mandibule l1 Capture d\'écran 2 [pc1]\",\"title\":\"2\"}','PNG',0,'SYNCED',0,NULL,'2024-06-05 15:01:15.000','2024-06-05 13:01:15.000','2024-06-05 15:01:15.000'),('b1108fe1-2975-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/computedocclusion_92d33b38-2963-11ef-9161-de41a781935b/b1108fe1-2975-11ef-9161-de41a781935b.png','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_OCC_92d33b38-2963-11ef-9161-de41a781935b_SCREENO','b1108fe1-2975-11ef-9161-de41a781935b.png','b1108fe1-2975-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Occlusion o1 Capture d\'écran 2\",\"occlusionType\":1,\"title\":\"2\"}','PNG',0,'CREATED',0,NULL,'2024-06-13 13:11:33.034','2024-06-13 11:11:33.091',NULL),('b325bd9b-233b-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_23e52d54-2338-11ef-8f93-d92a45da78c9/b325bd9b-233b-11ef-8f93-d92a45da78c9.json','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_BOSC_23e52d54-2338-11ef-8f93-d92a45da78c9_METER','b325bd9b-233b-11ef-8f93-d92a45da78c9.json','b325bd9b-233b-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Mandibule l1 Mesure [pc1]\"}','JSON',0,'SYNCED',0,NULL,'2024-06-05 15:01:19.000','2024-06-05 13:01:19.000','2024-06-05 15:01:19.000'),('b48a5fcd-2973-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/scan_b926a968-2962-11ef-9161-de41a781935b/b48a5fcd-2973-11ef-9161-de41a781935b.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_BOSC_b926a968-2962-11ef-9161-de41a781935b_MODEL','b48a5fcd-2973-11ef-9161-de41a781935b.zip','d9a1cf93-2962-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Mandibule l1\",\"modelMatrix\":\"0.96054,0.0160431,-0.277679,0,-0.0791538,0.972823,-0.217602,0,0.266641,0.230994,0.935705,0,-9.25344,-4.26872,-6.69421,1\",\"scanBodies\":[]}','ZIP',4,'CREATED',0,NULL,'2024-06-13 12:57:19.872','2024-06-13 10:57:19.913',NULL),('b737ce47-225b-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_e3862d66-225a-11ef-8f1f-d8242c71b430/occlusion_e3868e5f-225a-11ef-8f1f-d8242c71b430/scan_8e15b6ed-225b-11ef-8f1f-d8242c71b430/b737ce47-225b-11ef-8f1f-d8242c71b430.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_SESS_e3868e5f-225a-11ef-8f1f-d8242c71b430_LESC_8e15b6ed-225b-11ef-8f1f-d8242c71b430_MODEL','b737ce47-225b-11ef-8f1f-d8242c71b430.zip','b737ce47-225b-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.1 Mordu gauche bl2\",\"modelMatrix\":\"-0.996501,0.0721175,0.0341313,0,-0.0709851,-0.991991,0.106021,0,0.0443114,0.103748,0.993781,0,10.5043,-4.13475,-10.0904,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 12:18:01.000','2024-06-04 10:18:01.000','2024-06-04 12:18:01.000'),('b737dc71-225b-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_e3862d66-225a-11ef-8f1f-d8242c71b430/occlusion_e3868e5f-225a-11ef-8f1f-d8242c71b430/scan_8e15b6ed-225b-11ef-8f1f-d8242c71b430/b737dc71-225b-11ef-8f1f-d8242c71b430.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_SESS_e3868e5f-225a-11ef-8f1f-d8242c71b430_LESC_8e15b6ed-225b-11ef-8f1f-d8242c71b430_SNAPS','b737dc71-225b-11ef-8f1f-d8242c71b430.png','b737dc71-225b-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.1 Mordu gauche bl2 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 12:18:01.000','2024-06-04 10:18:01.000','2024-06-04 12:18:01.000'),('b90a3a37-2967-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/computedocclusion_784469a2-2967-11ef-9161-de41a781935b/b90a3a37-2967-11ef-9161-de41a781935b.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_OCC_784469a2-2967-11ef-9161-de41a781935b_BO1','b90a3a37-2967-11ef-9161-de41a781935b.zip','9dbc599e-2967-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Occlusion o3 Mandibule l1\",\"modelMatrix\":\"0.96054,0.0160431,-0.277679,0,-0.0791538,0.972823,-0.217602,0,0.266641,0.230994,0.935705,0,-9.25344,-4.26872,-6.69421,1\",\"occlusionMatrix\":\"-0.855192,0.518382,-0.00749868,0,-0.146509,-0.255509,-0.955693,0,-0.497316,-0.816127,0.294444,0,15.2907,10.377,3.13492,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.1_l1\",\"referenceScanId\":\"b926a968-2962-11ef-9161-de41a781935b\",\"scanBodies\":[]}','ZIP',1,'CREATED',0,'2024-06-13 11:31:52.081','2024-06-13 11:31:52.081','2024-06-13 09:31:52.081',NULL),('bc2209ec-233a-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_23e52d54-2338-11ef-8f93-d92a45da78c9/bc2209ec-233a-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_BOSC_23e52d54-2338-11ef-8f93-d92a45da78c9_MODEL','bc2209ec-233a-11ef-8f93-d92a45da78c9.zip','4c944e2f-2338-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Mandibule l1 [pc1]\",\"modelMatrix\":\"0.912405,-0.408985,0.0157505,0,0.408648,0.908152,-0.0909209,0,0.0228815,0.0893931,0.995733,0,-14.1029,6.9381,-10.6228,1\",\"scanBodies\":[]}','ZIP',2,'SYNCED',0,NULL,'2024-06-05 14:54:25.000','2024-06-05 12:54:25.000','2024-06-05 14:54:25.000'),('be85cce9-2973-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/scan_b926a968-2962-11ef-9161-de41a781935b/be85cce9-2973-11ef-9161-de41a781935b.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_BOSC_b926a968-2962-11ef-9161-de41a781935b_MODEL','be85cce9-2973-11ef-9161-de41a781935b.zip','d9a1cf93-2962-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Mandibule l1\",\"modelMatrix\":\"0.96054,0.0160431,-0.277679,0,-0.0791538,0.972823,-0.217602,0,0.266641,0.230994,0.935705,0,-9.25344,-4.26872,-6.69421,1\",\"scanBodies\":[]}','ZIP',5,'CREATED',0,NULL,'2024-06-13 12:57:36.619','2024-06-13 10:57:36.658',NULL),('bed46607-2967-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/computedocclusion_784469a2-2967-11ef-9161-de41a781935b/bed46607-2967-11ef-9161-de41a781935b.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_OCC_784469a2-2967-11ef-9161-de41a781935b_BO1','bed46607-2967-11ef-9161-de41a781935b.zip','9dbc599e-2967-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Occlusion o3 Mandibule l1\",\"modelMatrix\":\"0.96054,0.0160431,-0.277679,0,-0.0791538,0.972823,-0.217602,0,0.266641,0.230994,0.935705,0,-9.25344,-4.26872,-6.69421,1\",\"occlusionMatrix\":\"-0.855032,0.518645,-0.00788977,0,-0.16898,-0.292878,-0.941153,0,-0.490422,-0.803305,0.338044,0,15.2737,10.3544,2.39858,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.1_l1\",\"referenceScanId\":\"b926a968-2962-11ef-9161-de41a781935b\",\"scanBodies\":[]}','ZIP',2,'CREATED',0,'2024-06-13 11:31:51.033','2024-06-13 11:31:51.033','2024-06-13 09:31:51.033',NULL),('c0b6bacc-2975-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/computedocclusion_92d33b38-2963-11ef-9161-de41a781935b/c0b6bacc-2975-11ef-9161-de41a781935b.json','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_OCC_92d33b38-2963-11ef-9161-de41a781935b_METER','c0b6bacc-2975-11ef-9161-de41a781935b.json','84059dad-2974-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Occlusion o1\",\"occlusionType\":1}','JSON',1,'CREATED',0,NULL,'2024-06-13 13:11:59.288','2024-06-13 11:11:59.291',NULL),('c1ed2983-2343-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b651a084-2343-11ef-8f93-d92a45da78c9/occlusion_b651dff3-2343-11ef-8f93-d92a45da78c9/scan_b70f8ae5-2343-11ef-8f93-d92a45da78c9/c1ed2983-2343-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b651a084-2343-11ef-8f93-d92a45da78c9_SESS_b651dff3-2343-11ef-8f93-d92a45da78c9_TOSC_b70f8ae5-2343-11ef-8f93-d92a45da78c9_MODEL','c1ed2983-2343-11ef-8f93-d92a45da78c9.zip','c1ed2983-2343-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.8 Maxillaire u1 [pc1]\",\"modelMatrix\":\"-0.166866,-0.976032,0.139702,0,0.978367,-0.18148,-0.0993101,0,0.122283,0.120108,0.985201,0,4.6684,-1.56175,-7.05168,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-05 15:59:12.000','2024-06-05 13:59:12.000','2024-06-05 15:59:12.000'),('c1ed3973-2343-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b651a084-2343-11ef-8f93-d92a45da78c9/occlusion_b651dff3-2343-11ef-8f93-d92a45da78c9/scan_b70f8ae5-2343-11ef-8f93-d92a45da78c9/c1ed3973-2343-11ef-8f93-d92a45da78c9.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b651a084-2343-11ef-8f93-d92a45da78c9_SESS_b651dff3-2343-11ef-8f93-d92a45da78c9_TOSC_b70f8ae5-2343-11ef-8f93-d92a45da78c9_SNAPS','c1ed3973-2343-11ef-8f93-d92a45da78c9.png','c1ed3973-2343-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.8 Maxillaire u1 Snapshot [pc1]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-05 15:59:13.000','2024-06-05 13:59:13.000','2024-06-05 15:59:13.000'),('c4963479-233c-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_8c23d690-233c-11ef-8f93-d92a45da78c9/occlusion_8c257d6d-233c-11ef-8f93-d92a45da78c9/scan_af14b2d9-233c-11ef-8f93-d92a45da78c9/c4963479-233c-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_8c23d690-233c-11ef-8f93-d92a45da78c9_SESS_8c257d6d-233c-11ef-8f93-d92a45da78c9_BOSC_af14b2d9-233c-11ef-8f93-d92a45da78c9_MODEL','c4963479-233c-11ef-8f93-d92a45da78c9.zip','c4963479-233c-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.6 Mandibule l1 [pc1]\",\"modelMatrix\":\"0.955904,0.29116,-0.0383868,0,-0.285502,0.890683,-0.353797,0,-0.068821,0.349156,0.934534,0,-9.43775,-6.01247,-12.012,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,'2024-06-05 15:09:19.000','2024-06-05 15:09:03.000','2024-06-05 13:09:19.000','2024-06-05 15:09:19.000'),('c49644bc-233c-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_8c23d690-233c-11ef-8f93-d92a45da78c9/occlusion_8c257d6d-233c-11ef-8f93-d92a45da78c9/scan_af14b2d9-233c-11ef-8f93-d92a45da78c9/c49644bc-233c-11ef-8f93-d92a45da78c9.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_8c23d690-233c-11ef-8f93-d92a45da78c9_SESS_8c257d6d-233c-11ef-8f93-d92a45da78c9_BOSC_af14b2d9-233c-11ef-8f93-d92a45da78c9_SNAPS','c49644bc-233c-11ef-8f93-d92a45da78c9.png','c49644bc-233c-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.6 Mandibule l1 Snapshot [pc1]\"}','PNG',0,'SYNCED',0,'2024-06-05 15:09:19.000','2024-06-05 15:09:03.000','2024-06-05 13:09:19.000','2024-06-05 15:09:19.000'),('c52419e8-2278-11ef-8d76-d310d2ec2c14',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/scan_c523efdb-2278-11ef-8d76-d310d2ec2c14/c52419e8-2278-11ef-8d76-d310d2ec2c14.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_TOSC_c523efdb-2278-11ef-8d76-d310d2ec2c14_MODEL','c52419e8-2278-11ef-8d76-d310d2ec2c14.zip','c52419e8-2278-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Maxillaire u2 [pc2]\",\"modelMatrix\":\"-0.0834467,0.986107,-0.143628,0,-0.981709,-0.1061,-0.158085,0,-0.171128,0.12781,0.976924,0,-17.1278,-28.7907,-11.2181,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 15:46:10.000','2024-06-04 13:46:10.000','2024-06-04 15:46:10.000'),('c52f1c4e-2278-11ef-8d76-d310d2ec2c14',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/scan_c523efdb-2278-11ef-8d76-d310d2ec2c14/c52f1c4e-2278-11ef-8d76-d310d2ec2c14.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_TOSC_c523efdb-2278-11ef-8d76-d310d2ec2c14_SNAPS','c52f1c4e-2278-11ef-8d76-d310d2ec2c14.png','c52f1c4e-2278-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Maxillaire u2 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 15:46:10.000','2024-06-04 13:46:10.000','2024-06-04 15:46:10.000'),('c5ec55db-2967-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/computedocclusion_784469a2-2967-11ef-9161-de41a781935b/c5ec55db-2967-11ef-9161-de41a781935b.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_OCC_784469a2-2967-11ef-9161-de41a781935b_BO1','c5ec55db-2967-11ef-9161-de41a781935b.zip','9dbc599e-2967-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Occlusion o3 Mandibule l1\",\"modelMatrix\":\"0.96054,0.0160431,-0.277679,0,-0.0791538,0.972823,-0.217602,0,0.266641,0.230994,0.935705,0,-9.25344,-4.26872,-6.69421,1\",\"occlusionMatrix\":\"-0.855192,0.518382,-0.00749868,0,-0.146509,-0.255509,-0.955693,0,-0.497316,-0.816127,0.294444,0,15.2907,10.377,3.13492,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.1_l1\",\"referenceScanId\":\"b926a968-2962-11ef-9161-de41a781935b\",\"scanBodies\":[]}','ZIP',3,'CREATED',0,'2024-06-13 11:34:01.450','2024-06-13 11:34:01.450','2024-06-13 09:34:01.450',NULL),('c8ebad34-2338-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_a7dd3d5c-2338-11ef-8f93-d92a45da78c9/c8ebad34-2338-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_RISC_a7dd3d5c-2338-11ef-8f93-d92a45da78c9_MODEL','c8ebad34-2338-11ef-8f93-d92a45da78c9.zip','c8ebad34-2338-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Mordu droit br1 [pc1]\",\"modelMatrix\":\"0.993841,-0.0743606,-0.0790727,0,0.0844963,0.993083,0.0848352,0,0.0717796,-0.0909361,0.993252,0,1.17418,-1.46153,-11.8967,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-05 14:40:30.000','2024-06-05 12:40:30.000','2024-06-05 14:40:30.000'),('c8ebc1b6-2338-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_a7dd3d5c-2338-11ef-8f93-d92a45da78c9/c8ebc1b6-2338-11ef-8f93-d92a45da78c9.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_RISC_a7dd3d5c-2338-11ef-8f93-d92a45da78c9_SNAPS','c8ebc1b6-2338-11ef-8f93-d92a45da78c9.png','c8ebc1b6-2338-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Mordu droit br1 Snapshot [pc1]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-05 14:40:31.000','2024-06-05 12:40:31.000','2024-06-05 14:40:31.000'),('ca114ae6-2279-11ef-8d76-d310d2ec2c14',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_a4139c9d-2279-11ef-8d76-d310d2ec2c14/occlusion_a4160b84-2279-11ef-8d76-d310d2ec2c14/scan_a6d98df1-2279-11ef-8d76-d310d2ec2c14/ca114ae6-2279-11ef-8d76-d310d2ec2c14.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_a4139c9d-2279-11ef-8d76-d310d2ec2c14_SESS_a4160b84-2279-11ef-8d76-d310d2ec2c14_TOSC_a6d98df1-2279-11ef-8d76-d310d2ec2c14_MODEL','ca114ae6-2279-11ef-8d76-d310d2ec2c14.zip','ca114ae6-2279-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.3 Maxillaire u1 [pc2]\",\"modelMatrix\":\"-0.418905,0.900302,-0.11822,0,-0.907719,-0.411789,0.0804737,0,0.0237688,0.141021,0.989721,0,6.97337,-8.05933,-15.0874,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 15:53:20.000','2024-06-04 13:53:20.000','2024-06-04 15:53:20.000'),('ca116050-2279-11ef-8d76-d310d2ec2c14',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_a4139c9d-2279-11ef-8d76-d310d2ec2c14/occlusion_a4160b84-2279-11ef-8d76-d310d2ec2c14/scan_a6d98df1-2279-11ef-8d76-d310d2ec2c14/ca116050-2279-11ef-8d76-d310d2ec2c14.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_a4139c9d-2279-11ef-8d76-d310d2ec2c14_SESS_a4160b84-2279-11ef-8d76-d310d2ec2c14_TOSC_a6d98df1-2279-11ef-8d76-d310d2ec2c14_SNAPS','ca116050-2279-11ef-8d76-d310d2ec2c14.png','ca116050-2279-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.3 Maxillaire u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 15:53:20.000','2024-06-04 13:53:20.000','2024-06-04 15:53:20.000'),('cb4731d4-233b-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_23e52d54-2338-11ef-8f93-d92a45da78c9/cb4731d4-233b-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_BOSC_23e52d54-2338-11ef-8f93-d92a45da78c9_MODEL','cb4731d4-233b-11ef-8f93-d92a45da78c9.zip','4c944e2f-2338-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Mandibule l1 [pc1]\",\"modelMatrix\":\"0.912405,-0.408985,0.0157505,0,0.408648,0.908152,-0.0909209,0,0.0228815,0.0893931,0.995733,0,-14.1029,6.9381,-10.6228,1\",\"scanBodies\":[],\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":3,\"socleIsFullArch\":true,\"socleThickness\":-1,\"socleType\":3}','ZIP',3,'SYNCED',0,NULL,'2024-06-05 15:02:00.000','2024-06-05 13:02:00.000','2024-06-05 15:02:00.000'),('d00dd657-2977-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/scan_4cc68cd8-2962-11ef-9161-de41a781935b/d00dd657-2977-11ef-9161-de41a781935b.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_TOSC_4cc68cd8-2962-11ef-9161-de41a781935b_MODEL','d00dd657-2977-11ef-9161-de41a781935b.zip','809c945c-2962-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Maxillaire u1\",\"modelMatrix\":\"-0.840073,0.531409,-0.109002,0,-0.509977,-0.842143,-0.175265,0,-0.184933,-0.091647,0.978468,0,-3.66908,8.57904,-8.58551,1\",\"scanBodies\":[{\"position\":\"2.06903,5.05438,0,0,-0.995382,0,5.77626,0,6.47861,0,0,4,1,0,0,0\",\"reference\":\"K30PSCANPLG\",\"tid\":26}]}','ZIP',9,'CREATED',0,NULL,'2024-06-13 13:26:44.019','2024-06-13 11:26:44.055',NULL),('d0ab5861-23e7-11ef-8dde-d415e84cc4f5',3,'/var/iris/.data/2024/3/907398e3-23e7-11ef-8dde-d415e84cc4f5/session_96aedcf6-23e7-11ef-8dde-d415e84cc4f5/occlusion_96b19cc6-23e7-11ef-8dde-d415e84cc4f5/scan_981faf70-23e7-11ef-8dde-d415e84cc4f5/d0ab5861-23e7-11ef-8dde-d415e84cc4f5.zip','PATIENT_907398e3-23e7-11ef-8dde-d415e84cc4f5_ACT_96aedcf6-23e7-11ef-8dde-d415e84cc4f5_SESS_96b19cc6-23e7-11ef-8dde-d415e84cc4f5_TOSC_981faf70-23e7-11ef-8dde-d415e84cc4f5_MODEL','d0ab5861-23e7-11ef-8dde-d415e84cc4f5.zip','d0ab5861-23e7-11ef-8dde-d415e84cc4f5','{\"displayTitle\":\"2.1 Maxillaire u1 [pc1]\",\"modelMatrix\":\"0.998773,-0.00202182,-0.0494821,0,0.00445529,0.998783,0.0491187,0,0.0493226,-0.0492789,0.997566,0,1.86586,2.73136,-15.9281,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-06 11:33:25.000','2024-06-06 09:33:25.000','2024-06-06 11:33:25.000'),('d0ab69d4-23e7-11ef-8dde-d415e84cc4f5',3,'/var/iris/.data/2024/3/907398e3-23e7-11ef-8dde-d415e84cc4f5/session_96aedcf6-23e7-11ef-8dde-d415e84cc4f5/occlusion_96b19cc6-23e7-11ef-8dde-d415e84cc4f5/scan_981faf70-23e7-11ef-8dde-d415e84cc4f5/d0ab69d4-23e7-11ef-8dde-d415e84cc4f5.png','PATIENT_907398e3-23e7-11ef-8dde-d415e84cc4f5_ACT_96aedcf6-23e7-11ef-8dde-d415e84cc4f5_SESS_96b19cc6-23e7-11ef-8dde-d415e84cc4f5_TOSC_981faf70-23e7-11ef-8dde-d415e84cc4f5_SNAPS','d0ab69d4-23e7-11ef-8dde-d415e84cc4f5.png','d0ab69d4-23e7-11ef-8dde-d415e84cc4f5','{\"displayTitle\":\"2.1 Maxillaire u1 Snapshot [pc1]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-06 11:33:26.000','2024-06-06 09:33:26.000','2024-06-06 11:33:26.000'),('d59e4f7d-2279-11ef-8d76-d310d2ec2c14',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_a4139c9d-2279-11ef-8d76-d310d2ec2c14/order_a4229655-2279-11ef-8d76-d310d2ec2c14/d59e4f7d-2279-11ef-8d76-d310d2ec2c14.pdf','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_a4139c9d-2279-11ef-8d76-d310d2ec2c14_PROST_a4229655-2279-11ef-8d76-d310d2ec2c14_FORM','d59e4f7d-2279-11ef-8d76-d310d2ec2c14.pdf','d59e4f7d-2279-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.3 Facette [pc2]\",\"title\":\"Facette\"}','PDF',0,'SYNCED',0,NULL,'2024-06-04 15:53:35.000','2024-06-04 13:53:35.000','2024-06-04 15:53:35.000'),('d6119db2-233b-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_23e52d54-2338-11ef-8f93-d92a45da78c9/d6119db2-233b-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_BOSC_23e52d54-2338-11ef-8f93-d92a45da78c9_MODEL','d6119db2-233b-11ef-8f93-d92a45da78c9.zip','4c944e2f-2338-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Mandibule l1 [pc1]\",\"modelMatrix\":\"0.912405,-0.408985,0.0157505,0,0.408648,0.908152,-0.0909209,0,0.0228815,0.0893931,0.995733,0,-14.1029,6.9381,-10.6228,1\",\"scanBodies\":[],\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":3,\"socleIsFullArch\":true,\"socleThickness\":-1,\"socleType\":3}','ZIP',4,'SYNCED',0,NULL,'2024-06-05 15:02:22.000','2024-06-05 13:02:22.000','2024-06-05 15:02:22.000'),('d9a1cf93-2962-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/scan_b926a968-2962-11ef-9161-de41a781935b/d9a1cf93-2962-11ef-9161-de41a781935b.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_BOSC_b926a968-2962-11ef-9161-de41a781935b_MODEL','d9a1cf93-2962-11ef-9161-de41a781935b.zip','d9a1cf93-2962-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Mandibule l1\",\"modelMatrix\":\"0.96054,0.0160431,-0.277679,0,-0.0791538,0.972823,-0.217602,0,0.266641,0.230994,0.935705,0,-9.25344,-4.26872,-6.69421,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2024-06-13 10:56:40.656','2024-06-13 08:56:40.908',NULL),('d9a1dff9-2962-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/scan_b926a968-2962-11ef-9161-de41a781935b/d9a1dff9-2962-11ef-9161-de41a781935b.png','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_BOSC_b926a968-2962-11ef-9161-de41a781935b_SNAPS','d9a1dff9-2962-11ef-9161-de41a781935b.png','d9a1dff9-2962-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Mandibule l1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2024-06-13 10:56:40.657','2024-06-13 08:56:40.909',NULL),('d9c2bf02-233e-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_8c23d690-233c-11ef-8f93-d92a45da78c9/occlusion_8c257d6d-233c-11ef-8f93-d92a45da78c9/scan_aeb8dd17-233e-11ef-8f93-d92a45da78c9/d9c2bf02-233e-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_8c23d690-233c-11ef-8f93-d92a45da78c9_SESS_8c257d6d-233c-11ef-8f93-d92a45da78c9_RISC_aeb8dd17-233e-11ef-8f93-d92a45da78c9_MODEL','d9c2bf02-233e-11ef-8f93-d92a45da78c9.zip','d9c2bf02-233e-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.6 Mordu droit br1 [pc1]\",\"modelMatrix\":\"0.982517,0.00999077,-0.185665,0,0.0229636,0.984454,0.173771,0,0.184752,-0.175357,0.967126,0,-3.3735,2.81901,-10.5673,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-05 15:23:55.000','2024-06-05 13:23:55.000','2024-06-05 15:23:55.000'),('d9c2d5d6-233e-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_8c23d690-233c-11ef-8f93-d92a45da78c9/occlusion_8c257d6d-233c-11ef-8f93-d92a45da78c9/scan_aeb8dd17-233e-11ef-8f93-d92a45da78c9/d9c2d5d6-233e-11ef-8f93-d92a45da78c9.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_8c23d690-233c-11ef-8f93-d92a45da78c9_SESS_8c257d6d-233c-11ef-8f93-d92a45da78c9_RISC_aeb8dd17-233e-11ef-8f93-d92a45da78c9_SNAPS','d9c2d5d6-233e-11ef-8f93-d92a45da78c9.png','d9c2d5d6-233e-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.6 Mordu droit br1 Snapshot [pc1]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-05 15:23:56.000','2024-06-05 13:23:56.000','2024-06-05 15:23:56.000'),('da7b1998-2973-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/scan_4cc68cd8-2962-11ef-9161-de41a781935b/da7b1998-2973-11ef-9161-de41a781935b.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_TOSC_4cc68cd8-2962-11ef-9161-de41a781935b_MODEL','da7b1998-2973-11ef-9161-de41a781935b.zip','809c945c-2962-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Maxillaire u1\",\"modelMatrix\":\"-0.840073,0.531409,-0.109002,0,-0.509977,-0.842143,-0.175265,0,-0.184933,-0.091647,0.978468,0,-3.66908,8.57904,-8.58551,1\",\"scanBodies\":[{\"position\":\"2.06903,5.05438,0,0,-0.995382,0,5.77626,0,6.47861,0,0,4,1,0,0,0\",\"reference\":\"K30PSCANPLG\",\"tid\":26}]}','ZIP',8,'CREATED',0,NULL,'2024-06-13 12:58:23.525','2024-06-13 10:58:23.560',NULL),('dcd82fe7-233e-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_8c23d690-233c-11ef-8f93-d92a45da78c9/occlusion_8c257d6d-233c-11ef-8f93-d92a45da78c9/computedocclusion_aad6386a-233e-11ef-8f93-d92a45da78c9/dcd82fe7-233e-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_8c23d690-233c-11ef-8f93-d92a45da78c9_SESS_8c257d6d-233c-11ef-8f93-d92a45da78c9_OCC_aad6386a-233e-11ef-8f93-d92a45da78c9_TO1','dcd82fe7-233e-11ef-8f93-d92a45da78c9.zip','dcd82fe7-233e-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.6 Occlusion o1 Maxillaire u1 [pc1]\",\"modelMatrix\":\"0.997697,-0.0584844,0.0343697,0,0.0677866,0.840217,-0.537996,0,0.00258638,0.539087,0.842246,0,-9.2933,-7.87258,-10.443,1\",\"occlusionMatrix\":\"0.995891,0.0525088,-0.0738363,0,0.069339,0.0828592,0.994148,0,0.0583194,-0.995181,0.0788764,0,-9.48397,8.72418,-2.02349,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.6_u1\",\"referenceScanId\":\"93bdd6ef-233c-11ef-8f93-d92a45da78c9\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-05 15:24:01.000','2024-06-05 13:24:01.000','2024-06-05 15:24:01.000'),('dcf1877d-233e-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_8c23d690-233c-11ef-8f93-d92a45da78c9/occlusion_8c257d6d-233c-11ef-8f93-d92a45da78c9/computedocclusion_aad6386a-233e-11ef-8f93-d92a45da78c9/dcf1877d-233e-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_8c23d690-233c-11ef-8f93-d92a45da78c9_SESS_8c257d6d-233c-11ef-8f93-d92a45da78c9_OCC_aad6386a-233e-11ef-8f93-d92a45da78c9_BO1','dcf1877d-233e-11ef-8f93-d92a45da78c9.zip','dcf1877d-233e-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.6 Occlusion o1 Mandibule l2 [pc1]\",\"modelMatrix\":\"-0.720136,-0.687674,-0.0922383,0,0.657563,-0.718853,0.225522,0,-0.221392,0.101754,0.969862,0,7.84249,5.63311,-11.0618,1\",\"occlusionMatrix\":\"0.998733,-0.048112,-0.0149122,0,-0.0139447,0.0203732,-0.999699,0,0.0484011,0.998636,0.0196778,0,-9.78922,-7.02222,1.26193,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.6_l2\",\"referenceScanId\":\"d286674d-233c-11ef-8f93-d92a45da78c9\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-05 15:24:02.000','2024-06-05 13:24:02.000','2024-06-05 15:24:02.000'),('dd5ca018-233e-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_8c23d690-233c-11ef-8f93-d92a45da78c9/occlusion_8c257d6d-233c-11ef-8f93-d92a45da78c9/computedocclusion_aad6386a-233e-11ef-8f93-d92a45da78c9/dd5ca018-233e-11ef-8f93-d92a45da78c9.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_8c23d690-233c-11ef-8f93-d92a45da78c9_SESS_8c257d6d-233c-11ef-8f93-d92a45da78c9_OCC_aad6386a-233e-11ef-8f93-d92a45da78c9_SNAPO','dd5ca018-233e-11ef-8f93-d92a45da78c9.png','dd5ca018-233e-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.6 Occlusion o1 [pc1]\",\"occlusionType\":1}','PNG',0,'SYNCED',0,NULL,'2024-06-05 15:24:03.000','2024-06-05 13:24:03.000','2024-06-05 15:24:03.000'),('de217b4c-2278-11ef-8d76-d310d2ec2c14',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/scan_c523efdb-2278-11ef-8d76-d310d2ec2c14/de217b4c-2278-11ef-8d76-d310d2ec2c14.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_TOSC_c523efdb-2278-11ef-8d76-d310d2ec2c14_MODEL','de217b4c-2278-11ef-8d76-d310d2ec2c14.zip','c52419e8-2278-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Maxillaire u2 [pc2]\",\"modelMatrix\":\"-0.0834467,0.986107,-0.143628,0,-0.981709,-0.1061,-0.158085,0,-0.171128,0.12781,0.976924,0,-17.1278,-28.7907,-11.2181,1\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2024-06-04 15:46:39.000','2024-06-04 13:46:39.000','2024-06-04 15:46:39.000'),('e000eb20-225b-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_e3862d66-225a-11ef-8f1f-d8242c71b430/occlusion_e3868e5f-225a-11ef-8f1f-d8242c71b430/computedocclusion_6ba502f4-225b-11ef-8f1f-d8242c71b430/e000eb20-225b-11ef-8f1f-d8242c71b430.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_SESS_e3868e5f-225a-11ef-8f1f-d8242c71b430_OCC_6ba502f4-225b-11ef-8f1f-d8242c71b430_TO1','e000eb20-225b-11ef-8f1f-d8242c71b430.zip','e000eb20-225b-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.1 Occlusion o1 Maxillaire u1\",\"modelMatrix\":\"0.983821,-0.178562,-0.0145353,0,0.167676,0.946334,-0.276291,0,0.0630904,0.269384,0.960964,0,-18.4738,6.44284,-12.9473,1\",\"occlusionMatrix\":\"-0.983067,0.0412191,-0.180339,0,0.183184,0.197784,-0.962563,0,-0.00759549,-0.979387,-0.202378,0,17.9497,7.67706,6.6371,1\",\"occlusionType\":2,\"referenceScanFullDisplayId\":\"1.1_u1\",\"referenceScanId\":\"e52279ce-225a-11ef-8f1f-d8242c71b430\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 12:19:09.000','2024-06-04 10:19:09.000','2024-06-04 12:19:09.000'),('e01bae07-225b-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_e3862d66-225a-11ef-8f1f-d8242c71b430/occlusion_e3868e5f-225a-11ef-8f1f-d8242c71b430/computedocclusion_6ba502f4-225b-11ef-8f1f-d8242c71b430/e01bae07-225b-11ef-8f1f-d8242c71b430.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_SESS_e3868e5f-225a-11ef-8f1f-d8242c71b430_OCC_6ba502f4-225b-11ef-8f1f-d8242c71b430_BO1','e01bae07-225b-11ef-8f1f-d8242c71b430.zip','e01bae07-225b-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.1 Occlusion o1 Mandibule l1\",\"modelMatrix\":\"-0.728037,0.684478,-0.03811,0,-0.685353,-0.725423,0.0636657,0,0.0159319,0.0724698,0.997243,0,9.49558,-10.7,-12.9454,1\",\"occlusionMatrix\":\"-0.985853,-0.13039,-0.111741,0,-0.134966,0.214901,0.966923,0,-0.0995888,0.967905,-0.229331,0,6.18786,-8.33646,11.3454,1\",\"occlusionType\":2,\"referenceScanFullDisplayId\":\"1.1_l1\",\"referenceScanId\":\"37ccba29-225b-11ef-8f1f-d8242c71b430\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 12:19:11.000','2024-06-04 10:19:11.000','2024-06-04 12:19:11.000'),('e091c2ff-225b-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_e3862d66-225a-11ef-8f1f-d8242c71b430/occlusion_e3868e5f-225a-11ef-8f1f-d8242c71b430/computedocclusion_6ba502f4-225b-11ef-8f1f-d8242c71b430/e091c2ff-225b-11ef-8f1f-d8242c71b430.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_e3862d66-225a-11ef-8f1f-d8242c71b430_SESS_e3868e5f-225a-11ef-8f1f-d8242c71b430_OCC_6ba502f4-225b-11ef-8f1f-d8242c71b430_SNAPO','e091c2ff-225b-11ef-8f1f-d8242c71b430.png','e091c2ff-225b-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.1 Occlusion o1\",\"occlusionType\":2}','PNG',0,'SYNCED',0,NULL,'2024-06-04 12:19:11.000','2024-06-04 10:19:11.000','2024-06-04 12:19:11.000'),('e43a35c6-233e-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_8c23d690-233c-11ef-8f93-d92a45da78c9/occlusion_8c257d6d-233c-11ef-8f93-d92a45da78c9/computedocclusion_aad6386a-233e-11ef-8f93-d92a45da78c9/e43a35c6-233e-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_8c23d690-233c-11ef-8f93-d92a45da78c9_SESS_8c257d6d-233c-11ef-8f93-d92a45da78c9_OCC_aad6386a-233e-11ef-8f93-d92a45da78c9_BO3','e43a35c6-233e-11ef-8f93-d92a45da78c9.zip','e43a35c6-233e-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.6 Occlusion o1 Mandibule l3 [pc1]\",\"modelMatrix\":\"-0.720136,-0.687674,-0.0922383,0,0.657563,-0.718853,0.225522,0,-0.221392,0.101754,0.969862,0,7.84249,5.63311,-11.0618,1\",\"occlusionMatrix\":\"0.998734,-0.0481123,-0.0149121,0,-0.0139447,0.0203727,-0.9997,0,0.0484014,0.998637,0.0196778,0,-9.78924,-7.02222,1.26193,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.6_l3\",\"referenceScanId\":\"9b60e5c1-233e-11ef-8f93-d92a45da78c9\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-05 15:24:12.000','2024-06-05 13:24:12.000','2024-06-05 15:24:12.000'),('e59826d2-2278-11ef-8d76-d310d2ec2c14',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_f2606f1c-2272-11ef-8d76-d310d2ec2c14/occlusion_f262aa99-2272-11ef-8d76-d310d2ec2c14/computedocclusion_9ed6352b-2277-11ef-8d76-d310d2ec2c14/e59826d2-2278-11ef-8d76-d310d2ec2c14.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_f2606f1c-2272-11ef-8d76-d310d2ec2c14_SESS_f262aa99-2272-11ef-8d76-d310d2ec2c14_OCC_9ed6352b-2277-11ef-8d76-d310d2ec2c14_TO2','e59826d2-2278-11ef-8d76-d310d2ec2c14.zip','e59826d2-2278-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"1.2 Occlusion o2 Maxillaire u2 [pc2]\",\"modelMatrix\":\"-0.0834467,0.986107,-0.143628,0,-0.981709,-0.1061,-0.158085,0,-0.171128,0.12781,0.976924,0,-17.1278,-28.7907,-11.2181,1\",\"occlusionMatrix\":\"-0.0756177,0.133991,0.988095,0,-0.986811,0.132191,-0.0934454,0,-0.143139,-0.982128,0.122229,0,-17.9384,11.0046,-27.4488,1\",\"occlusionType\":5,\"referenceScanFullDisplayId\":\"1.2_u2\",\"referenceScanId\":\"c523efdb-2278-11ef-8d76-d310d2ec2c14\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 15:46:53.000','2024-06-04 13:46:53.000','2024-06-04 15:46:53.000'),('e5f15957-2964-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/scan_4eb3e0e7-2964-11ef-9161-de41a781935b/e5f15957-2964-11ef-9161-de41a781935b.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_RISC_4eb3e0e7-2964-11ef-9161-de41a781935b_MODEL','e5f15957-2964-11ef-9161-de41a781935b.zip','e5f15957-2964-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Mordu droit br2\",\"modelMatrix\":\"0.988761,0.0825727,0.124614,0,-0.0736134,0.994544,-0.0736084,0,-0.130129,0.0637441,0.989471,0,-14.3018,-0.904839,-17.0965,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2024-06-13 11:11:20.304','2024-06-13 09:11:20.606',NULL),('e5f16789-2964-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/scan_4eb3e0e7-2964-11ef-9161-de41a781935b/e5f16789-2964-11ef-9161-de41a781935b.png','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_RISC_4eb3e0e7-2964-11ef-9161-de41a781935b_SNAPS','e5f16789-2964-11ef-9161-de41a781935b.png','e5f16789-2964-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Mordu droit br2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2024-06-13 11:11:20.304','2024-06-13 09:11:20.606',NULL),('e94ccc3a-2963-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/scan_9398352e-2963-11ef-9161-de41a781935b/e94ccc3a-2963-11ef-9161-de41a781935b.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_RISC_9398352e-2963-11ef-9161-de41a781935b_MODEL','e94ccc3a-2963-11ef-9161-de41a781935b.zip','e94ccc3a-2963-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Mordu droit br1\",\"modelMatrix\":\"0.995743,0.0487168,-0.0786774,0,-0.0321162,0.979668,0.197912,0,0.0863961,-0.194621,0.977057,0,-18.131,3.98401,-14.3332,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2024-06-13 11:04:16.440','2024-06-13 09:04:16.713',NULL),('e94cda01-2963-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/scan_9398352e-2963-11ef-9161-de41a781935b/e94cda01-2963-11ef-9161-de41a781935b.png','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_RISC_9398352e-2963-11ef-9161-de41a781935b_SNAPS','e94cda01-2963-11ef-9161-de41a781935b.png','e94cda01-2963-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Mordu droit br1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2024-06-13 11:04:16.440','2024-06-13 09:04:16.714',NULL),('ec928beb-2963-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/computedocclusion_92d33b38-2963-11ef-9161-de41a781935b/ec928beb-2963-11ef-9161-de41a781935b.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_OCC_92d33b38-2963-11ef-9161-de41a781935b_TO1','ec928beb-2963-11ef-9161-de41a781935b.zip','ec928beb-2963-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Occlusion o1 Maxillaire u1\",\"modelMatrix\":\"-0.872758,0.470809,-0.128964,0,-0.443838,-0.875321,-0.191887,0,-0.203227,-0.110232,0.972907,0,-2.56858,6.47103,-8.11483,1\",\"occlusionMatrix\":\"0.989431,0.00607015,0.144935,0,-0.139837,0.305701,0.941803,0,-0.0385896,-0.952117,0.303313,0,3.84739,4.89398,-2.29938,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.1_u1\",\"referenceScanId\":\"4cc68cd8-2962-11ef-9161-de41a781935b\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2024-06-13 11:04:21.930','2024-06-13 09:04:22.228',NULL),('ecabac14-2963-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/computedocclusion_92d33b38-2963-11ef-9161-de41a781935b/ecabac14-2963-11ef-9161-de41a781935b.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_OCC_92d33b38-2963-11ef-9161-de41a781935b_BO1','ecabac14-2963-11ef-9161-de41a781935b.zip','ecabac14-2963-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Occlusion o1 Mandibule l1\",\"modelMatrix\":\"0.96054,0.0160431,-0.277679,0,-0.0791538,0.972823,-0.217602,0,0.266641,0.230994,0.935705,0,-9.25344,-4.26872,-6.69421,1\",\"occlusionMatrix\":\"0.974257,-0.214459,0.0698442,0,0.129746,0.2796,-0.951327,0,0.184492,0.935874,0.300222,0,-5.23469,-5.90532,-3.93984,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.1_l1\",\"referenceScanId\":\"b926a968-2962-11ef-9161-de41a781935b\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2024-06-13 11:04:22.095','2024-06-13 09:04:22.241',NULL),('ecbfd534-2968-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/scan_4cc68cd8-2962-11ef-9161-de41a781935b/ecbfd534-2968-11ef-9161-de41a781935b.ply','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_TOSC_4cc68cd8-2962-11ef-9161-de41a781935b_SEG','ecbfd534-2968-11ef-9161-de41a781935b.ply','ecbfd534-2968-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Maxillaire u1 Segmentation\"}','PLY',0,'CREATED',0,'2024-06-13 11:40:25.695','2024-06-13 11:40:25.696','2024-06-13 09:40:25.696',NULL),('ed04dd0f-2267-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_757ed4bc-2266-11ef-8f1f-d8242c71b430/occlusion_75806ee1-2266-11ef-8f1f-d8242c71b430/scan_b4da925f-2267-11ef-8f1f-d8242c71b430/ed04dd0f-2267-11ef-8f1f-d8242c71b430.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_BOSC_b4da925f-2267-11ef-8f1f-d8242c71b430_MODEL','ed04dd0f-2267-11ef-8f1f-d8242c71b430.zip','ed04dd0f-2267-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.2 Mandibule l1\",\"modelMatrix\":\"0.988582,0.0775562,-0.129192,0,-0.0638786,0.992221,0.106846,0,0.136474,-0.0973735,0.985846,0,-17.8094,0.329057,-12.0411,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 13:45:25.000','2024-06-04 11:45:25.000','2024-06-04 13:45:25.000'),('ed04eb07-2267-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_757ed4bc-2266-11ef-8f1f-d8242c71b430/occlusion_75806ee1-2266-11ef-8f1f-d8242c71b430/scan_b4da925f-2267-11ef-8f1f-d8242c71b430/ed04eb07-2267-11ef-8f1f-d8242c71b430.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_BOSC_b4da925f-2267-11ef-8f1f-d8242c71b430_SNAPS','ed04eb07-2267-11ef-8f1f-d8242c71b430.png','ed04eb07-2267-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.2 Mandibule l1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 13:45:25.000','2024-06-04 11:45:25.000','2024-06-04 13:45:25.000'),('ed1b89b3-2963-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/computedocclusion_92d33b38-2963-11ef-9161-de41a781935b/ed1b89b3-2963-11ef-9161-de41a781935b.png','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_OCC_92d33b38-2963-11ef-9161-de41a781935b_SNAPO','ed1b89b3-2963-11ef-9161-de41a781935b.png','ed1b89b3-2963-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Occlusion o1\",\"occlusionType\":1}','PNG',0,'CREATED',0,NULL,'2024-06-13 11:04:22.828','2024-06-13 09:04:22.830',NULL),('ed7a2fab-233e-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_8c23d690-233c-11ef-8f93-d92a45da78c9/occlusion_8c257d6d-233c-11ef-8f93-d92a45da78c9/scan_ed7a17d3-233e-11ef-8f93-d92a45da78c9/ed7a2fab-233e-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_8c23d690-233c-11ef-8f93-d92a45da78c9_SESS_8c257d6d-233c-11ef-8f93-d92a45da78c9_TOSC_ed7a17d3-233e-11ef-8f93-d92a45da78c9_MODEL','ed7a2fab-233e-11ef-8f93-d92a45da78c9.zip','ed7a2fab-233e-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.6 Maxillaire u2 [pc1]\",\"modelMatrix\":\"0.997697,-0.0584844,0.0343697,0,0.0677866,0.840217,-0.537996,0,0.00258638,0.539087,0.842246,0,-9.2933,-7.87258,-10.443,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-05 15:24:27.000','2024-06-05 13:24:27.000','2024-06-05 15:24:27.000'),('ed7f61d5-233e-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_8c23d690-233c-11ef-8f93-d92a45da78c9/occlusion_8c257d6d-233c-11ef-8f93-d92a45da78c9/scan_ed7a17d3-233e-11ef-8f93-d92a45da78c9/ed7f61d5-233e-11ef-8f93-d92a45da78c9.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_8c23d690-233c-11ef-8f93-d92a45da78c9_SESS_8c257d6d-233c-11ef-8f93-d92a45da78c9_TOSC_ed7a17d3-233e-11ef-8f93-d92a45da78c9_SNAPS','ed7f61d5-233e-11ef-8f93-d92a45da78c9.png','ed7f61d5-233e-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.6 Maxillaire u2 Snapshot [pc1]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-05 15:24:27.000','2024-06-05 13:24:27.000','2024-06-05 15:24:27.000'),('ef61f104-2268-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_757ed4bc-2266-11ef-8f1f-d8242c71b430/occlusion_75806ee1-2266-11ef-8f1f-d8242c71b430/scan_b9e0ca90-2268-11ef-8f1f-d8242c71b430/ef61f104-2268-11ef-8f1f-d8242c71b430.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_RISC_b9e0ca90-2268-11ef-8f1f-d8242c71b430_MODEL','ef61f104-2268-11ef-8f1f-d8242c71b430.zip','ef61f104-2268-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.2 Mordu droit br1\",\"modelMatrix\":\"0.991752,-0.0286208,-0.124153,0,0.0323433,0.99785,0.0559419,0,0.124081,-0.0590604,0.990687,0,10.0502,3.44334,-13.3063,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 13:52:39.000','2024-06-04 11:52:39.000','2024-06-04 13:52:39.000'),('ef620854-2268-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_757ed4bc-2266-11ef-8f1f-d8242c71b430/occlusion_75806ee1-2266-11ef-8f1f-d8242c71b430/scan_b9e0ca90-2268-11ef-8f1f-d8242c71b430/ef620854-2268-11ef-8f1f-d8242c71b430.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_RISC_b9e0ca90-2268-11ef-8f1f-d8242c71b430_SNAPS','ef620854-2268-11ef-8f1f-d8242c71b430.png','ef620854-2268-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.2 Mordu droit br1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 13:52:39.000','2024-06-04 11:52:39.000','2024-06-04 13:52:39.000'),('efa48c98-233c-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_8c23d690-233c-11ef-8f93-d92a45da78c9/occlusion_8c257d6d-233c-11ef-8f93-d92a45da78c9/scan_d286674d-233c-11ef-8f93-d92a45da78c9/efa48c98-233c-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_8c23d690-233c-11ef-8f93-d92a45da78c9_SESS_8c257d6d-233c-11ef-8f93-d92a45da78c9_BOSC_d286674d-233c-11ef-8f93-d92a45da78c9_MODEL','efa48c98-233c-11ef-8f93-d92a45da78c9.zip','efa48c98-233c-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.6 Mandibule l2 [pc1]\",\"modelMatrix\":\"-0.720136,-0.687674,-0.0922383,0,0.657563,-0.718853,0.225522,0,-0.221392,0.101754,0.969862,0,7.84249,5.63311,-11.0618,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-05 15:10:13.000','2024-06-05 13:10:13.000','2024-06-05 15:10:13.000'),('efa49ef7-233c-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_8c23d690-233c-11ef-8f93-d92a45da78c9/occlusion_8c257d6d-233c-11ef-8f93-d92a45da78c9/scan_d286674d-233c-11ef-8f93-d92a45da78c9/efa49ef7-233c-11ef-8f93-d92a45da78c9.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_8c23d690-233c-11ef-8f93-d92a45da78c9_SESS_8c257d6d-233c-11ef-8f93-d92a45da78c9_BOSC_d286674d-233c-11ef-8f93-d92a45da78c9_SNAPS','efa49ef7-233c-11ef-8f93-d92a45da78c9.png','efa49ef7-233c-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.6 Mandibule l2 Snapshot [pc1]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-05 15:10:13.000','2024-06-05 13:10:13.000','2024-06-05 15:10:13.000'),('efefdbe8-298e-11ef-8fb0-da2b4bf5ebbb',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_6fa078a0-2987-11ef-8fb0-da2b4bf5ebbb/occlusion_6fa1d062-2987-11ef-8fb0-da2b4bf5ebbb/scan_2b917de0-298e-11ef-8fb0-da2b4bf5ebbb/efefdbe8-298e-11ef-8fb0-da2b4bf5ebbb.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_6fa078a0-2987-11ef-8fb0-da2b4bf5ebbb_SESS_6fa1d062-2987-11ef-8fb0-da2b4bf5ebbb_TOSC_2b917de0-298e-11ef-8fb0-da2b4bf5ebbb_MODEL','efefdbe8-298e-11ef-8fb0-da2b4bf5ebbb.zip','3976b785-298e-11ef-8fb0-da2b4bf5ebbb','{\"displayTitle\":\"1.3 Maxillaire u1\",\"modelMatrix\":\"-0.809291,-0.550476,-0.205001,0,0.407944,-0.777802,0.478127,0,-0.422647,0.303315,0.854031,0,8.1212,-0.359057,-6.36711,1\",\"scanBodies\":[{\"position\":\"3.5293,6,0,0,-1.01429,0,6,0,6.64951,0,0,6,1,0,0,0\",\"reference\":\"K30PSCANPLG\",\"tid\":25}]}','ZIP',2,'CREATED',0,'2024-06-13 16:20:17.213','2024-06-13 16:12:15.934','2024-06-13 14:20:17.214',NULL),('f0c1893d-227d-11ef-8f8c-d92a43d45d56',2,'/var/iris/.data/2024/2/ce57500b-227c-11ef-8d76-d310d2ec2c14/session_cdf2bb52-227d-11ef-8f8c-d92a43d45d56/occlusion_cdf45240-227d-11ef-8f8c-d92a43d45d56/scan_cf823728-227d-11ef-8f8c-d92a43d45d56/f0c1893d-227d-11ef-8f8c-d92a43d45d56.zip','PATIENT_ce57500b-227c-11ef-8d76-d310d2ec2c14_ACT_cdf2bb52-227d-11ef-8f8c-d92a43d45d56_SESS_cdf45240-227d-11ef-8f8c-d92a43d45d56_TOSC_cf823728-227d-11ef-8f8c-d92a43d45d56_MODEL','f0c1893d-227d-11ef-8f8c-d92a43d45d56.zip','f0c1893d-227d-11ef-8f8c-d92a43d45d56','{\"displayTitle\":\"3.1 Maxillaire u1 [pc1]\",\"modelMatrix\":\"0.982594,0.117836,-0.143611,0,-0.113332,0.992784,0.0391828,0,0.147192,-0.0222251,0.988858,0,-0.00298958,1.98864,-12.9722,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 16:23:03.000','2024-06-04 14:23:03.000','2024-06-04 16:23:03.000'),('f0c1a284-227d-11ef-8f8c-d92a43d45d56',2,'/var/iris/.data/2024/2/ce57500b-227c-11ef-8d76-d310d2ec2c14/session_cdf2bb52-227d-11ef-8f8c-d92a43d45d56/occlusion_cdf45240-227d-11ef-8f8c-d92a43d45d56/scan_cf823728-227d-11ef-8f8c-d92a43d45d56/f0c1a284-227d-11ef-8f8c-d92a43d45d56.png','PATIENT_ce57500b-227c-11ef-8d76-d310d2ec2c14_ACT_cdf2bb52-227d-11ef-8f8c-d92a43d45d56_SESS_cdf45240-227d-11ef-8f8c-d92a43d45d56_TOSC_cf823728-227d-11ef-8f8c-d92a43d45d56_SNAPS','f0c1a284-227d-11ef-8f8c-d92a43d45d56.png','f0c1a284-227d-11ef-8f8c-d92a43d45d56','{\"displayTitle\":\"3.1 Maxillaire u1 Snapshot [pc1]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 16:23:03.000','2024-06-04 14:23:03.000','2024-06-04 16:23:03.000'),('f1f459c8-233e-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_8c23d690-233c-11ef-8f93-d92a45da78c9/occlusion_8c257d6d-233c-11ef-8f93-d92a45da78c9/computedocclusion_aad6386a-233e-11ef-8f93-d92a45da78c9/f1f459c8-233e-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_8c23d690-233c-11ef-8f93-d92a45da78c9_SESS_8c257d6d-233c-11ef-8f93-d92a45da78c9_OCC_aad6386a-233e-11ef-8f93-d92a45da78c9_TO2','f1f459c8-233e-11ef-8f93-d92a45da78c9.zip','f1f459c8-233e-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.6 Occlusion o1 Maxillaire u2 [pc1]\",\"modelMatrix\":\"0.997697,-0.0584844,0.0343697,0,0.0677866,0.840217,-0.537996,0,0.00258638,0.539087,0.842246,0,-9.2933,-7.87258,-10.443,1\",\"occlusionMatrix\":\"0.995893,0.0525093,-0.0738376,0,0.0693403,0.0828599,0.994149,0,0.0583201,-0.995182,0.0788769,0,-9.484,8.72417,-2.02349,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.6_u2\",\"referenceScanId\":\"ed7a17d3-233e-11ef-8f93-d92a45da78c9\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-05 15:24:36.000','2024-06-05 13:24:36.000','2024-06-05 15:24:36.000'),('f3576589-2268-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_757ed4bc-2266-11ef-8f1f-d8242c71b430/occlusion_75806ee1-2266-11ef-8f1f-d8242c71b430/computedocclusion_0b16efeb-2268-11ef-8f1f-d8242c71b430/f3576589-2268-11ef-8f1f-d8242c71b430.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_OCC_0b16efeb-2268-11ef-8f1f-d8242c71b430_TO1','f3576589-2268-11ef-8f1f-d8242c71b430.zip','f3576589-2268-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.2 Occlusion o1 Maxillaire u1\",\"modelMatrix\":\"0.970663,-0.222677,0.0907083,0,0.239614,0.864538,-0.441769,0,0.019951,0.450543,0.892532,0,-17.9206,-4.24346,-12.6568,1\",\"occlusionMatrix\":\"0.973794,0.000432278,-0.227448,0,0.222023,0.215288,0.950979,0,0.0493782,-0.976552,0.20955,0,-19.0028,7.7418,-0.229366,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.2_u1\",\"referenceScanId\":\"09768650-2267-11ef-8f1f-d8242c71b430\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 13:52:46.000','2024-06-04 11:52:46.000','2024-06-04 13:52:46.000'),('f379f4d9-2268-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_757ed4bc-2266-11ef-8f1f-d8242c71b430/occlusion_75806ee1-2266-11ef-8f1f-d8242c71b430/computedocclusion_0b16efeb-2268-11ef-8f1f-d8242c71b430/f379f4d9-2268-11ef-8f1f-d8242c71b430.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_OCC_0b16efeb-2268-11ef-8f1f-d8242c71b430_BO1','f379f4d9-2268-11ef-8f1f-d8242c71b430.zip','f379f4d9-2268-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.2 Occlusion o1 Mandibule l1\",\"modelMatrix\":\"0.988582,0.0775562,-0.129192,0,-0.0638786,0.992221,0.106846,0,0.136474,-0.0973735,0.985846,0,-17.8094,0.329057,-12.0411,1\",\"occlusionMatrix\":\"0.975316,-0.181035,-0.126528,0,-0.169666,-0.247306,-0.953975,0,0.14141,0.951881,-0.271914,0,-17.0394,-5.36341,4.91459,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.2_l1\",\"referenceScanId\":\"b4da925f-2267-11ef-8f1f-d8242c71b430\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 13:52:47.000','2024-06-04 11:52:47.000','2024-06-04 13:52:47.000'),('f37e8ee9-2989-11ef-8fb0-da2b4bf5ebbb',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_7eb8397d-2987-11ef-8fb0-da2b4bf5ebbb/occlusion_7eb98de9-2987-11ef-8fb0-da2b4bf5ebbb/scan_f222cff6-2989-11ef-8fb0-da2b4bf5ebbb/f37e8ee9-2989-11ef-8fb0-da2b4bf5ebbb.ply','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_7eb8397d-2987-11ef-8fb0-da2b4bf5ebbb_SESS_7eb98de9-2987-11ef-8fb0-da2b4bf5ebbb_TOSC_f222cff6-2989-11ef-8fb0-da2b4bf5ebbb_SEG','f37e8ee9-2989-11ef-8fb0-da2b4bf5ebbb.ply','f37e8ee9-2989-11ef-8fb0-da2b4bf5ebbb','{\"displayTitle\":\"1.5 Maxillaire u2 Segmentation\"}','PLY',0,'CREATED',0,'2024-06-13 15:36:46.251','2024-06-13 15:36:46.252','2024-06-13 13:36:46.252',NULL),('f4024e3a-2268-11ef-8f1f-d8242c71b430',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_757ed4bc-2266-11ef-8f1f-d8242c71b430/occlusion_75806ee1-2266-11ef-8f1f-d8242c71b430/computedocclusion_0b16efeb-2268-11ef-8f1f-d8242c71b430/f4024e3a-2268-11ef-8f1f-d8242c71b430.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_757ed4bc-2266-11ef-8f1f-d8242c71b430_SESS_75806ee1-2266-11ef-8f1f-d8242c71b430_OCC_0b16efeb-2268-11ef-8f1f-d8242c71b430_SNAPO','f4024e3a-2268-11ef-8f1f-d8242c71b430.png','f4024e3a-2268-11ef-8f1f-d8242c71b430','{\"displayTitle\":\"1.2 Occlusion o1\",\"occlusionType\":1}','PNG',0,'SYNCED',0,NULL,'2024-06-04 13:52:48.000','2024-06-04 11:52:48.000','2024-06-04 13:52:48.000'),('f51d71ce-227c-11ef-8d76-d310d2ec2c14',2,'/var/iris/.data/2024/2/ce57500b-227c-11ef-8d76-d310d2ec2c14/session_da355fe4-227c-11ef-8d76-d310d2ec2c14/occlusion_da37d213-227c-11ef-8d76-d310d2ec2c14/scan_e0f66733-227c-11ef-8d76-d310d2ec2c14/f51d71ce-227c-11ef-8d76-d310d2ec2c14.zip','PATIENT_ce57500b-227c-11ef-8d76-d310d2ec2c14_ACT_da355fe4-227c-11ef-8d76-d310d2ec2c14_SESS_da37d213-227c-11ef-8d76-d310d2ec2c14_TOSC_e0f66733-227c-11ef-8d76-d310d2ec2c14_MODEL','f51d71ce-227c-11ef-8d76-d310d2ec2c14.zip','f51d71ce-227c-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"3.1 Maxillaire u1 [pc2]\",\"modelMatrix\":\"-0.590223,0.739255,-0.324251,0,-0.781697,-0.423166,0.458127,0,0.201461,0.523863,0.827636,0,-1.54469,-10.1967,-10.1611,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 16:16:00.000','2024-06-04 14:16:00.000','2024-06-04 16:16:00.000'),('f51d8554-227c-11ef-8d76-d310d2ec2c14',2,'/var/iris/.data/2024/2/ce57500b-227c-11ef-8d76-d310d2ec2c14/session_da355fe4-227c-11ef-8d76-d310d2ec2c14/occlusion_da37d213-227c-11ef-8d76-d310d2ec2c14/scan_e0f66733-227c-11ef-8d76-d310d2ec2c14/f51d8554-227c-11ef-8d76-d310d2ec2c14.png','PATIENT_ce57500b-227c-11ef-8d76-d310d2ec2c14_ACT_da355fe4-227c-11ef-8d76-d310d2ec2c14_SESS_da37d213-227c-11ef-8d76-d310d2ec2c14_TOSC_e0f66733-227c-11ef-8d76-d310d2ec2c14_SNAPS','f51d8554-227c-11ef-8d76-d310d2ec2c14.png','f51d8554-227c-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"3.1 Maxillaire u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 16:16:00.000','2024-06-04 14:16:00.000','2024-06-04 16:16:00.000'),('f6358ad7-2968-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/scan_4cc68cd8-2962-11ef-9161-de41a781935b/f6358ad7-2968-11ef-9161-de41a781935b.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_TOSC_4cc68cd8-2962-11ef-9161-de41a781935b_MODEL','f6358ad7-2968-11ef-9161-de41a781935b.zip','809c945c-2962-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Maxillaire u1\",\"modelMatrix\":\"-0.872758,0.470809,-0.128964,0,-0.443838,-0.875321,-0.191887,0,-0.203227,-0.110232,0.972907,0,-2.56858,6.47103,-8.11483,1\",\"scanBodies\":[{\"position\":\"2.06903,5.05438,0,0,-0.995382,0,5.77626,0,6.47861,0,0,4,1,0,0,0\",\"reference\":\"K30PSCANPLG\",\"tid\":26}]}','ZIP',3,'CREATED',0,NULL,'2024-06-13 11:40:25.581','2024-06-13 09:40:25.620',NULL),('fafc415d-23e7-11ef-8dde-d415e84cc4f5',3,'/var/iris/.data/2024/3/907398e3-23e7-11ef-8dde-d415e84cc4f5/session_96aedcf6-23e7-11ef-8dde-d415e84cc4f5/order_96b5001d-23e7-11ef-8dde-d415e84cc4f5/fafc415d-23e7-11ef-8dde-d415e84cc4f5.pdf','PATIENT_907398e3-23e7-11ef-8dde-d415e84cc4f5_ACT_96aedcf6-23e7-11ef-8dde-d415e84cc4f5_PROST_96b5001d-23e7-11ef-8dde-d415e84cc4f5_FORM','fafc415d-23e7-11ef-8dde-d415e84cc4f5.pdf','fafc415d-23e7-11ef-8dde-d415e84cc4f5','{\"displayTitle\":\"2.1 Couronne [pc1]\",\"title\":\"Couronne\"}','PDF',0,'SYNCED',0,NULL,'2024-06-06 11:34:33.000','2024-06-06 09:34:33.000','2024-06-06 11:34:33.000'),('fc8f1969-2271-11ef-8d76-d310d2ec2c14',2,'/var/iris/.data/2024/2/a1ace9b5-2271-11ef-8d76-d310d2ec2c14/session_afa6cb0d-2271-11ef-8d76-d310d2ec2c14/occlusion_afa8fad1-2271-11ef-8d76-d310d2ec2c14/scan_b17c4dcd-2271-11ef-8d76-d310d2ec2c14/fc8f1969-2271-11ef-8d76-d310d2ec2c14.zip','PATIENT_a1ace9b5-2271-11ef-8d76-d310d2ec2c14_ACT_afa6cb0d-2271-11ef-8d76-d310d2ec2c14_SESS_afa8fad1-2271-11ef-8d76-d310d2ec2c14_TOSC_b17c4dcd-2271-11ef-8d76-d310d2ec2c14_MODEL','fc8f1969-2271-11ef-8d76-d310d2ec2c14.zip','fc8f1969-2271-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"2.1 Maxillaire u1 [pc2]\",\"modelMatrix\":\"-0.666484,0.745051,-0.02644,0,-0.736592,-0.663561,-0.130839,0,-0.115026,-0.0677265,0.991051,0,13.9201,-2.00427,-11.44,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-04 14:57:27.000','2024-06-04 12:57:27.000','2024-06-04 14:57:27.000'),('fc8f31e9-2271-11ef-8d76-d310d2ec2c14',2,'/var/iris/.data/2024/2/a1ace9b5-2271-11ef-8d76-d310d2ec2c14/session_afa6cb0d-2271-11ef-8d76-d310d2ec2c14/occlusion_afa8fad1-2271-11ef-8d76-d310d2ec2c14/scan_b17c4dcd-2271-11ef-8d76-d310d2ec2c14/fc8f31e9-2271-11ef-8d76-d310d2ec2c14.png','PATIENT_a1ace9b5-2271-11ef-8d76-d310d2ec2c14_ACT_afa6cb0d-2271-11ef-8d76-d310d2ec2c14_SESS_afa8fad1-2271-11ef-8d76-d310d2ec2c14_TOSC_b17c4dcd-2271-11ef-8d76-d310d2ec2c14_SNAPS','fc8f31e9-2271-11ef-8d76-d310d2ec2c14.png','fc8f31e9-2271-11ef-8d76-d310d2ec2c14','{\"displayTitle\":\"2.1 Maxillaire u1 Snapshot [pc2]\"}','PNG',0,'SYNCED',0,NULL,'2024-06-04 14:57:27.000','2024-06-04 12:57:27.000','2024-06-04 14:57:27.000'),('fdbb89ae-2963-11ef-9161-de41a781935b',4,'/var/iris/.data/2024/4/f8254989-2960-11ef-9161-de41a781935b/session_43de61ec-2962-11ef-9161-de41a781935b/occlusion_43dfe39a-2962-11ef-9161-de41a781935b/scan_4cc68cd8-2962-11ef-9161-de41a781935b/fdbb89ae-2963-11ef-9161-de41a781935b.zip','PATIENT_f8254989-2960-11ef-9161-de41a781935b_ACT_43de61ec-2962-11ef-9161-de41a781935b_SESS_43dfe39a-2962-11ef-9161-de41a781935b_BOSC_4cc68cd8-2962-11ef-9161-de41a781935b_MODEL','fdbb89ae-2963-11ef-9161-de41a781935b.zip','809c945c-2962-11ef-9161-de41a781935b','{\"displayTitle\":\"1.1 Mandibule l2\",\"modelMatrix\":\"-0.872758,0.470809,-0.128964,0,-0.443838,-0.875321,-0.191887,0,-0.203227,-0.110232,0.972907,0,-2.56858,6.47103,-8.11483,1\",\"scanBodies\":[]}','ZIP',1,'CREATED',0,NULL,'2024-06-13 11:04:50.720','2024-06-13 09:04:50.749',NULL),('fdd0378f-2338-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/computedocclusion_a2829ff3-2338-11ef-8f93-d92a45da78c9/fdd0378f-2338-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_OCC_a2829ff3-2338-11ef-8f93-d92a45da78c9_TO1','fdd0378f-2338-11ef-8f93-d92a45da78c9.zip','fdd0378f-2338-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Occlusion o1 Maxillaire u1 [pc1]\",\"modelMatrix\":\"-0.923468,0.0376561,-0.381824,0,-0.158116,-0.944087,0.289308,0,-0.349581,0.327539,0.877788,0,12.8471,-2.21044,-5.73295,1\",\"occlusionMatrix\":\"0.96183,0.149466,-0.231582,0,0.27256,-0.433127,0.858711,0,0.0250034,-0.888866,-0.457158,0,-15.4993,3.62292,10.3073,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.5_u1\",\"referenceScanId\":\"ef3ba736-2337-11ef-8f93-d92a45da78c9\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-05 14:41:59.000','2024-06-05 12:41:59.000','2024-06-05 14:41:59.000'),('fde62b96-2338-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/computedocclusion_a2829ff3-2338-11ef-8f93-d92a45da78c9/fde62b96-2338-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_OCC_a2829ff3-2338-11ef-8f93-d92a45da78c9_BO1','fde62b96-2338-11ef-8f93-d92a45da78c9.zip','fde62b96-2338-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Occlusion o1 Mandibule l1 [pc1]\",\"modelMatrix\":\"0.912405,-0.408985,0.0157505,0,0.408648,0.908152,-0.0909209,0,0.0228815,0.0893931,0.995733,0,-14.1029,6.9381,-10.6228,1\",\"occlusionMatrix\":\"0.978507,0.00506567,-0.206416,0,-0.206059,-0.0415349,-0.977659,0,-0.0100431,0.999139,-0.0397917,0,-17.2944,-6.5218,8.79401,1\",\"occlusionType\":1,\"referenceScanFullDisplayId\":\"1.5_l1\",\"referenceScanId\":\"23e52d54-2338-11ef-8f93-d92a45da78c9\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2024-06-05 14:42:00.000','2024-06-05 12:42:00.000','2024-06-05 14:42:00.000'),('fe51cb41-233a-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_2e146f3d-233a-11ef-8f93-d92a45da78c9/fe51cb41-233a-11ef-8f93-d92a45da78c9.zip','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_TOSC_2e146f3d-233a-11ef-8f93-d92a45da78c9_MODEL','fe51cb41-233a-11ef-8f93-d92a45da78c9.zip','2e1492f1-233a-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Maxillaire u2 [pc1]\",\"modelMatrix\":\"-0.46768,0.880383,-0.0787487,0,-0.783478,-0.454143,-0.424165,0,-0.409191,-0.136676,0.902154,0,9.14889,-5.25906,-7.65118,1\",\"scanBodies\":[]}','ZIP',3,'SYNCED',0,NULL,'2024-06-05 14:56:21.000','2024-06-05 12:56:21.000','2024-06-05 14:56:21.000'),('fe51ed64-233a-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/scan_2e146f3d-233a-11ef-8f93-d92a45da78c9/fe51ed64-233a-11ef-8f93-d92a45da78c9.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_TOSC_2e146f3d-233a-11ef-8f93-d92a45da78c9_SNAPS','fe51ed64-233a-11ef-8f93-d92a45da78c9.png','2e19276e-233a-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Maxillaire u2 Snapshot [pc1]\"}','PNG',1,'SYNCED',0,NULL,'2024-06-05 14:56:22.000','2024-06-05 12:56:22.000','2024-06-05 14:56:22.000'),('fe5950b5-2338-11ef-8f93-d92a45da78c9',2,'/var/iris/.data/2024/2/dc803a78-225a-11ef-8f1f-d8242c71b430/session_b19ab46f-2336-11ef-8f93-d92a45da78c9/occlusion_b19c6074-2336-11ef-8f93-d92a45da78c9/computedocclusion_a2829ff3-2338-11ef-8f93-d92a45da78c9/fe5950b5-2338-11ef-8f93-d92a45da78c9.png','PATIENT_dc803a78-225a-11ef-8f1f-d8242c71b430_ACT_b19ab46f-2336-11ef-8f93-d92a45da78c9_SESS_b19c6074-2336-11ef-8f93-d92a45da78c9_OCC_a2829ff3-2338-11ef-8f93-d92a45da78c9_SNAPO','fe5950b5-2338-11ef-8f93-d92a45da78c9.png','fe5950b5-2338-11ef-8f93-d92a45da78c9','{\"displayTitle\":\"1.5 Occlusion o1 [pc1]\",\"occlusionType\":1}','PNG',0,'SYNCED',0,NULL,'2024-06-05 14:42:01.000','2024-06-05 12:42:01.000','2024-06-05 14:42:01.000'),('fefc53d6-227d-11ef-8f8c-d92a43d45d56',2,'/var/iris/.data/2024/2/ce57500b-227c-11ef-8d76-d310d2ec2c14/session_cdf2bb52-227d-11ef-8f8c-d92a43d45d56/order_cdf680d9-227d-11ef-8f8c-d92a43d45d56/fefc53d6-227d-11ef-8f8c-d92a43d45d56.pdf','PATIENT_ce57500b-227c-11ef-8d76-d310d2ec2c14_ACT_cdf2bb52-227d-11ef-8f8c-d92a43d45d56_PROST_cdf680d9-227d-11ef-8f8c-d92a43d45d56_FORM','fefc53d6-227d-11ef-8f8c-d92a43d45d56.pdf','fefc53d6-227d-11ef-8f8c-d92a43d45d56','{\"displayTitle\":\"3.1 Autre [pc1]\",\"title\":\"Autre\"}','PDF',0,'SYNCED',0,NULL,'2024-06-04 16:23:21.598','2024-06-04 14:23:22.290','2024-06-04 16:23:22.433');
/*!40000 ALTER TABLE `File` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `MessageStatus`
--

DROP TABLE IF EXISTS `MessageStatus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `MessageStatus` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `sentMessageId` varchar(36) NOT NULL,
  `contactId` varchar(36) NOT NULL,
  `status` enum('UNDELIVERED','DELIVERED','TRANSMITTED') NOT NULL DEFAULT 'UNDELIVERED',
  `bcc` tinyint(1) NOT NULL DEFAULT 0,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  PRIMARY KEY (`sentMessageId`,`contactId`),
  KEY `ownerId` (`ownerId`),
  KEY `contactId` (`contactId`),
  CONSTRAINT `MessageStatus_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `MessageStatus_ibfk_2` FOREIGN KEY (`sentMessageId`) REFERENCES `SentMessage` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `MessageStatus_ibfk_3` FOREIGN KEY (`contactId`) REFERENCES `Contact` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `MessageStatus`
--

LOCK TABLES `MessageStatus` WRITE;
/*!40000 ALTER TABLE `MessageStatus` DISABLE KEYS */;
INSERT INTO `MessageStatus` VALUES (2,'0874bbc1-2403-11ef-8dde-d415e84cc4f5','8fbd79fd-0e86-49b8-9558-3a507eb19750','TRANSMITTED',0,'2024-06-07 10:15:21.000'),(2,'0d22759d-225e-11ef-8f1f-d8242c71b430','8fbd79fd-0e86-49b8-9558-3a507eb19750','TRANSMITTED',0,'2024-06-04 10:34:42.000'),(2,'0eb44d73-23ea-11ef-8f8c-d92a43d45e5a','8fbd79fd-0e86-49b8-9558-3a507eb19750','TRANSMITTED',0,'2024-06-06 09:49:27.000'),(2,'0f3e4980-225d-11ef-8f1f-d8242c71b430','8fbd79fd-0e86-49b8-9558-3a507eb19750','TRANSMITTED',0,'2024-06-04 10:27:41.000'),(3,'10351862-fb40-4aa9-a4ab-7afe4dba87b9','a664f09d-da86-42d0-b54a-2672898db522','TRANSMITTED',0,'2024-06-04 10:29:25.000'),(3,'2192fe1a-0490-4bd9-8f2d-363155abc9a2','a664f09d-da86-42d0-b54a-2672898db522','TRANSMITTED',0,'2024-06-06 12:23:37.000'),(2,'2d654e78-2272-11ef-8d76-d310d2ec2c14','4ed4ce00-4b30-4601-95bb-ede535f19c6b','DELIVERED',0,'2024-06-04 12:58:47.000'),(2,'2f604f05-d11c-43d9-bdf9-d43e0306dfda','8fbd79fd-0e86-49b8-9558-3a507eb19750','TRANSMITTED',0,'2024-06-06 09:09:22.000'),(2,'30f0f8e5-2279-11ef-8d76-d310d2ec2c14','4ed4ce00-4b30-4601-95bb-ede535f19c6b','DELIVERED',0,'2024-06-04 13:48:59.000'),(3,'33e44dc1-23e9-11ef-8dde-d415e84cc4f5','a664f09d-da86-42d0-b54a-2672898db522','TRANSMITTED',0,'2024-06-06 09:47:52.000'),(2,'4c1489bb-54c8-4aa3-8017-d140fe974c2f','8fbd79fd-0e86-49b8-9558-3a507eb19750','TRANSMITTED',0,'2024-06-06 10:01:41.000'),(2,'4db93275-aa1c-442f-b2b5-af6c4514bd24','8fbd79fd-0e86-49b8-9558-3a507eb19750','TRANSMITTED',0,'2024-06-06 09:57:25.000'),(2,'550f3fc1-226b-11ef-8f1f-d8242c71b430','4ed4ce00-4b30-4601-95bb-ede535f19c6b','TRANSMITTED',0,'2024-06-04 12:10:11.000'),(3,'56f0c51f-23ed-11ef-8dde-d415e84cc4f5','a664f09d-da86-42d0-b54a-2672898db522','TRANSMITTED',0,'2024-06-06 10:16:25.000'),(3,'5701b18b-225e-11ef-8d76-d310d2ec2c14','a664f09d-da86-42d0-b54a-2672898db522','TRANSMITTED',0,'2024-06-04 10:36:47.000'),(3,'59cfafae-e9ce-4a51-be20-09e9860da4b4','a664f09d-da86-42d0-b54a-2672898db522','TRANSMITTED',0,'2024-06-06 12:22:37.000'),(2,'5c02d3d5-23e4-11ef-8dde-d415e84cc4f5','8fbd79fd-0e86-49b8-9558-3a507eb19750','TRANSMITTED',0,'2024-06-06 09:08:38.000'),(3,'62d4940c-225e-11ef-8d76-d310d2ec2c14','a664f09d-da86-42d0-b54a-2672898db522','TRANSMITTED',0,'2024-06-04 10:37:05.000'),(2,'673530bc-2272-11ef-8d76-d310d2ec2c14','4ed4ce00-4b30-4601-95bb-ede535f19c6b','DELIVERED',0,'2024-06-04 13:00:24.000'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','4ed4ce00-4b30-4601-95bb-ede535f19c6b','DELIVERED',0,'2024-06-05 13:28:05.782'),(2,'75433112-226f-11ef-8f1f-d8242c71b430','4ed4ce00-4b30-4601-95bb-ede535f19c6b','DELIVERED',0,'2024-06-04 12:39:20.196'),(4,'79e4936c-226b-11ef-8f1f-d8242c71b430','d9206ed1-cc31-4eed-85d5-1551b9fec244','DELIVERED',0,'2024-06-04 12:10:47.630'),(2,'7c7133c4-869b-4ecf-be8c-a7ba25b96324','8fbd79fd-0e86-49b8-9558-3a507eb19750','TRANSMITTED',0,'2024-06-04 10:29:34.000'),(3,'96378603-23e4-11ef-8f8c-d92a43d45e5a','a664f09d-da86-42d0-b54a-2672898db522','TRANSMITTED',0,'2024-06-06 09:24:48.000'),(3,'9ac047ea-23eb-11ef-8dde-d415e84cc4f5','a664f09d-da86-42d0-b54a-2672898db522','TRANSMITTED',0,'2024-06-06 10:01:33.000'),(3,'9e44f2e9-23e4-11ef-8f8c-d92a43d45e5a','a664f09d-da86-42d0-b54a-2672898db522','TRANSMITTED',0,'2024-06-06 09:24:48.000'),(2,'b1d82b93-226b-11ef-8d76-d310d2ec2c14','4ed4ce00-4b30-4601-95bb-ede535f19c6b','DELIVERED',0,'2024-06-04 12:12:21.000'),(2,'d61618a0-2279-11ef-8d76-d310d2ec2c14','4ed4ce00-4b30-4601-95bb-ede535f19c6b','DELIVERED',0,'2024-06-04 13:53:36.000'),(3,'ddab8ff1-23e2-11ef-8f8c-d92a43d45e5a','a50cb907-4db3-48f3-9808-0ae18d8dccdb','TRANSMITTED',0,'2024-06-06 08:58:06.000'),(2,'e03dc949-f924-4e48-a5fd-e8273bbf6e07','8fbd79fd-0e86-49b8-9558-3a507eb19750','TRANSMITTED',0,'2024-06-06 09:58:24.000'),(2,'ec59b1ff-79e7-49aa-9888-5b1e722d3d80','8fbd79fd-0e86-49b8-9558-3a507eb19750','TRANSMITTED',0,'2024-06-06 10:02:17.000'),(3,'f352fb85-23e4-11ef-8f8c-d92a43d45e5a','a664f09d-da86-42d0-b54a-2672898db522','TRANSMITTED',0,'2024-06-06 09:24:48.000'),(2,'fad71f64-8b16-4fc8-94d4-6ae6473112ab','8fbd79fd-0e86-49b8-9558-3a507eb19750','TRANSMITTED',0,'2024-06-06 09:56:28.000'),(3,'fb69a8c0-23e7-11ef-8dde-d415e84cc4f5','a50cb907-4db3-48f3-9808-0ae18d8dccdb','TRANSMITTED',0,'2024-06-06 09:34:37.000'),(2,'ff68612f-227d-11ef-8f8c-d92a43d45d56','4ed4ce00-4b30-4601-95bb-ede535f19c6b','DELIVERED',0,'2024-06-04 14:23:23.743');
/*!40000 ALTER TABLE `MessageStatus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Occlusion`
--

DROP TABLE IF EXISTS `Occlusion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Occlusion` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `sessionId` varchar(36) DEFAULT NULL,
  `occlusionType` enum('UNKNOWN','HEMI_ARCADE_POSTERIEUR_DROIT','HEMI_ARCADE_POSTERIEUR_GAUCHE','HEMI_ARCADE_ANTERIEUR','ARCADE_COMPLETE_ANTERIEUR','ARCADE_COMPLETE') DEFAULT 'UNKNOWN',
  `displayId` mediumint(8) unsigned DEFAULT NULL,
  `pcId` mediumint(8) unsigned DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT 0,
  `comments` text DEFAULT NULL,
  `topScanId` varchar(36) DEFAULT NULL,
  `bottomScanId` varchar(36) DEFAULT NULL,
  `anteriorBiteScanId` varchar(36) DEFAULT NULL,
  `rightBiteScanId` varchar(36) DEFAULT NULL,
  `leftBiteScanId` varchar(36) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `sessionId` (`sessionId`),
  KEY `topScanId` (`topScanId`),
  KEY `bottomScanId` (`bottomScanId`),
  KEY `anteriorBiteScanId` (`anteriorBiteScanId`),
  KEY `rightBiteScanId` (`rightBiteScanId`),
  KEY `leftBiteScanId` (`leftBiteScanId`),
  CONSTRAINT `Occlusion_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_2` FOREIGN KEY (`sessionId`) REFERENCES `Session` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_3` FOREIGN KEY (`topScanId`) REFERENCES `Scan` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_4` FOREIGN KEY (`bottomScanId`) REFERENCES `Scan` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_5` FOREIGN KEY (`anteriorBiteScanId`) REFERENCES `Scan` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_6` FOREIGN KEY (`rightBiteScanId`) REFERENCES `Scan` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_7` FOREIGN KEY (`leftBiteScanId`) REFERENCES `Scan` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Occlusion`
--

LOCK TABLES `Occlusion` WRITE;
/*!40000 ALTER TABLE `Occlusion` DISABLE KEYS */;
INSERT INTO `Occlusion` VALUES ('0b16efeb-2268-11ef-8f1f-d8242c71b430',2,'75806ee1-2266-11ef-8f1f-d8242c71b430','HEMI_ARCADE_POSTERIEUR_DROIT',1,1,0,'','09768650-2267-11ef-8f1f-d8242c71b430','b4da925f-2267-11ef-8f1f-d8242c71b430',NULL,'b9e0ca90-2268-11ef-8f1f-d8242c71b430',NULL,'2024-06-04 13:46:12.000',NULL,'2024-06-04 13:57:45.000','2024-06-04 11:57:46.000','2024-06-04 13:57:46.000'),('4df68750-2964-11ef-9161-de41a781935b',4,'43dfe39a-2962-11ef-9161-de41a781935b','HEMI_ARCADE_POSTERIEUR_DROIT',2,1,0,'','4cc68cd8-2962-11ef-9161-de41a781935b','b926a968-2962-11ef-9161-de41a781935b',NULL,'4eb3e0e7-2964-11ef-9161-de41a781935b',NULL,'2024-06-13 11:07:05.324',NULL,'2024-06-13 11:29:20.111','2024-06-13 09:29:20.111',NULL),('6ba502f4-225b-11ef-8f1f-d8242c71b430',2,'e3868e5f-225a-11ef-8f1f-d8242c71b430','HEMI_ARCADE_POSTERIEUR_GAUCHE',1,1,0,'','e52279ce-225a-11ef-8f1f-d8242c71b430','37ccba29-225b-11ef-8f1f-d8242c71b430',NULL,NULL,'8e15b6ed-225b-11ef-8f1f-d8242c71b430','2024-06-04 12:15:51.000',NULL,'2024-06-04 12:19:07.000','2024-06-04 10:19:12.000','2024-06-04 12:19:12.000'),('784469a2-2967-11ef-9161-de41a781935b',4,'43dfe39a-2962-11ef-9161-de41a781935b','HEMI_ARCADE_POSTERIEUR_DROIT',3,1,0,'','5a97f8c0-2967-11ef-9161-de41a781935b','b926a968-2962-11ef-9161-de41a781935b',NULL,'7b02accf-2967-11ef-9161-de41a781935b',NULL,'2024-06-13 11:29:44.789','2024-06-13 11:36:40.806','2024-06-13 11:36:40.806','2024-06-13 09:36:40.806',NULL),('92d33b38-2963-11ef-9161-de41a781935b',4,'43dfe39a-2962-11ef-9161-de41a781935b','HEMI_ARCADE_POSTERIEUR_DROIT',1,1,0,'','4cc68cd8-2962-11ef-9161-de41a781935b','b926a968-2962-11ef-9161-de41a781935b',NULL,'9398352e-2963-11ef-9161-de41a781935b',NULL,'2024-06-13 11:01:51.359',NULL,'2024-06-13 13:14:50.966','2024-06-13 11:14:50.967',NULL),('a2829ff3-2338-11ef-8f93-d92a45da78c9',2,'b19c6074-2336-11ef-8f93-d92a45da78c9','HEMI_ARCADE_POSTERIEUR_DROIT',1,1,0,'','ef3ba736-2337-11ef-8f93-d92a45da78c9','23e52d54-2338-11ef-8f93-d92a45da78c9',NULL,'a7dd3d5c-2338-11ef-8f93-d92a45da78c9',NULL,'2024-06-05 14:39:22.000',NULL,'2024-06-05 15:06:08.000','2024-06-05 13:06:14.000','2024-06-05 15:06:14.000'),('aad6386a-233e-11ef-8f93-d92a45da78c9',2,'8c257d6d-233c-11ef-8f93-d92a45da78c9','HEMI_ARCADE_POSTERIEUR_DROIT',1,1,0,'','93bdd6ef-233c-11ef-8f93-d92a45da78c9','d286674d-233c-11ef-8f93-d92a45da78c9',NULL,'aeb8dd17-233e-11ef-8f93-d92a45da78c9',NULL,'2024-06-05 15:22:33.000',NULL,'2024-06-05 15:24:32.000','2024-06-05 13:24:36.000','2024-06-05 15:24:36.000');
/*!40000 ALTER TABLE `Occlusion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `OcclusionFile`
--

DROP TABLE IF EXISTS `OcclusionFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `OcclusionFile` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `occlusionId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('RESULT','MANDIBLE_1','MANDIBLE_2','MANDIBLE_3','MANDIBLE_4','MAXILLARY_1','MAXILLARY_2','MAXILLARY_3','MAXILLARY_4','LIFI','LIFIMETA','SNAPSHOT','SCREENSHOT','METERING') NOT NULL DEFAULT 'RESULT',
  PRIMARY KEY (`occlusionId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `OcclusionFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `OcclusionFile_ibfk_2` FOREIGN KEY (`occlusionId`) REFERENCES `Occlusion` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `OcclusionFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `OcclusionFile`
--

LOCK TABLES `OcclusionFile` WRITE;
/*!40000 ALTER TABLE `OcclusionFile` DISABLE KEYS */;
INSERT INTO `OcclusionFile` VALUES (2,'0b16efeb-2268-11ef-8f1f-d8242c71b430','1b66dafd-2269-11ef-8f1f-d8242c71b430','LIFI'),(2,'0b16efeb-2268-11ef-8f1f-d8242c71b430','1b66de9f-2269-11ef-8f1f-d8242c71b430','LIFIMETA'),(2,'0b16efeb-2268-11ef-8f1f-d8242c71b430','6461ca85-2269-11ef-8f1f-d8242c71b430','LIFI'),(2,'0b16efeb-2268-11ef-8f1f-d8242c71b430','6461d309-2269-11ef-8f1f-d8242c71b430','LIFIMETA'),(2,'0b16efeb-2268-11ef-8f1f-d8242c71b430','8103b4c6-2269-11ef-8f1f-d8242c71b430','LIFI'),(2,'0b16efeb-2268-11ef-8f1f-d8242c71b430','8103b848-2269-11ef-8f1f-d8242c71b430','LIFIMETA'),(2,'0b16efeb-2268-11ef-8f1f-d8242c71b430','8da9c330-2269-11ef-8f1f-d8242c71b430','MANDIBLE_1'),(2,'0b16efeb-2268-11ef-8f1f-d8242c71b430','9e41d416-2269-11ef-8f1f-d8242c71b430','MANDIBLE_1'),(2,'0b16efeb-2268-11ef-8f1f-d8242c71b430','a5fed54d-2269-11ef-8f1f-d8242c71b430','MANDIBLE_1'),(2,'0b16efeb-2268-11ef-8f1f-d8242c71b430','f3576589-2268-11ef-8f1f-d8242c71b430','MAXILLARY_1'),(2,'0b16efeb-2268-11ef-8f1f-d8242c71b430','f379f4d9-2268-11ef-8f1f-d8242c71b430','MANDIBLE_1'),(2,'0b16efeb-2268-11ef-8f1f-d8242c71b430','f4024e3a-2268-11ef-8f1f-d8242c71b430','SNAPSHOT'),(4,'4df68750-2964-11ef-9161-de41a781935b','697a5384-2967-11ef-9161-de41a781935b','MAXILLARY_2'),(4,'4df68750-2964-11ef-9161-de41a781935b','903b3627-2965-11ef-9161-de41a781935b','MAXILLARY_1'),(4,'4df68750-2964-11ef-9161-de41a781935b','9051c4d1-2965-11ef-9161-de41a781935b','MANDIBLE_1'),(4,'4df68750-2964-11ef-9161-de41a781935b','90da0803-2965-11ef-9161-de41a781935b','SNAPSHOT'),(2,'6ba502f4-225b-11ef-8f1f-d8242c71b430','e000eb20-225b-11ef-8f1f-d8242c71b430','MAXILLARY_1'),(2,'6ba502f4-225b-11ef-8f1f-d8242c71b430','e01bae07-225b-11ef-8f1f-d8242c71b430','MANDIBLE_1'),(2,'6ba502f4-225b-11ef-8f1f-d8242c71b430','e091c2ff-225b-11ef-8f1f-d8242c71b430','SNAPSHOT'),(4,'784469a2-2967-11ef-9161-de41a781935b','12ac60c2-2968-11ef-9161-de41a781935b','MANDIBLE_1'),(4,'784469a2-2967-11ef-9161-de41a781935b','22b133bf-2968-11ef-9161-de41a781935b','MAXILLARY_1'),(4,'784469a2-2967-11ef-9161-de41a781935b','9da74cf3-2967-11ef-9161-de41a781935b','MAXILLARY_1'),(4,'784469a2-2967-11ef-9161-de41a781935b','9dbc599e-2967-11ef-9161-de41a781935b','MANDIBLE_1'),(4,'784469a2-2967-11ef-9161-de41a781935b','9e2333cd-2967-11ef-9161-de41a781935b','SNAPSHOT'),(4,'784469a2-2967-11ef-9161-de41a781935b','b90a3a37-2967-11ef-9161-de41a781935b','MANDIBLE_1'),(4,'784469a2-2967-11ef-9161-de41a781935b','bed46607-2967-11ef-9161-de41a781935b','MANDIBLE_1'),(4,'784469a2-2967-11ef-9161-de41a781935b','c5ec55db-2967-11ef-9161-de41a781935b','MANDIBLE_1'),(4,'92d33b38-2963-11ef-9161-de41a781935b','04a9f91f-2976-11ef-9161-de41a781935b','SCREENSHOT'),(4,'92d33b38-2963-11ef-9161-de41a781935b','270a71cb-2976-11ef-9161-de41a781935b','METERING'),(4,'92d33b38-2963-11ef-9161-de41a781935b','700184ee-2974-11ef-9161-de41a781935b','SCREENSHOT'),(4,'92d33b38-2963-11ef-9161-de41a781935b','84059dad-2974-11ef-9161-de41a781935b','METERING'),(4,'92d33b38-2963-11ef-9161-de41a781935b','b1108fe1-2975-11ef-9161-de41a781935b','SCREENSHOT'),(4,'92d33b38-2963-11ef-9161-de41a781935b','c0b6bacc-2975-11ef-9161-de41a781935b','METERING'),(4,'92d33b38-2963-11ef-9161-de41a781935b','ec928beb-2963-11ef-9161-de41a781935b','MAXILLARY_1'),(4,'92d33b38-2963-11ef-9161-de41a781935b','ecabac14-2963-11ef-9161-de41a781935b','MANDIBLE_1'),(4,'92d33b38-2963-11ef-9161-de41a781935b','ed1b89b3-2963-11ef-9161-de41a781935b','SNAPSHOT'),(2,'a2829ff3-2338-11ef-8f93-d92a45da78c9','10a34539-2339-11ef-8f93-d92a45da78c9','LIFI'),(2,'a2829ff3-2338-11ef-8f93-d92a45da78c9','10a347ba-2339-11ef-8f93-d92a45da78c9','LIFIMETA'),(2,'a2829ff3-2338-11ef-8f93-d92a45da78c9','48ae5f56-233a-11ef-8f93-d92a45da78c9','LIFI'),(2,'a2829ff3-2338-11ef-8f93-d92a45da78c9','48ae63e5-233a-11ef-8f93-d92a45da78c9','LIFIMETA'),(2,'a2829ff3-2338-11ef-8f93-d92a45da78c9','51ec0746-233a-11ef-8f93-d92a45da78c9','LIFI'),(2,'a2829ff3-2338-11ef-8f93-d92a45da78c9','51ec1340-233a-11ef-8f93-d92a45da78c9','LIFIMETA'),(2,'a2829ff3-2338-11ef-8f93-d92a45da78c9','5ac77cab-233a-11ef-8f93-d92a45da78c9','MAXILLARY_2'),(2,'a2829ff3-2338-11ef-8f93-d92a45da78c9','5aea6f60-233a-11ef-8f93-d92a45da78c9','LIFI'),(2,'a2829ff3-2338-11ef-8f93-d92a45da78c9','5aea74fa-233a-11ef-8f93-d92a45da78c9','LIFIMETA'),(2,'a2829ff3-2338-11ef-8f93-d92a45da78c9','5f8fef48-233c-11ef-8f93-d92a45da78c9','MANDIBLE_3'),(2,'a2829ff3-2338-11ef-8f93-d92a45da78c9','5fc0481a-233c-11ef-8f93-d92a45da78c9','LIFI'),(2,'a2829ff3-2338-11ef-8f93-d92a45da78c9','5fc04dc7-233c-11ef-8f93-d92a45da78c9','LIFIMETA'),(2,'a2829ff3-2338-11ef-8f93-d92a45da78c9','71a237c5-233b-11ef-8f93-d92a45da78c9','LIFI'),(2,'a2829ff3-2338-11ef-8f93-d92a45da78c9','71a23b4a-233b-11ef-8f93-d92a45da78c9','LIFIMETA'),(2,'a2829ff3-2338-11ef-8f93-d92a45da78c9','fdd0378f-2338-11ef-8f93-d92a45da78c9','MAXILLARY_1'),(2,'a2829ff3-2338-11ef-8f93-d92a45da78c9','fde62b96-2338-11ef-8f93-d92a45da78c9','MANDIBLE_1'),(2,'a2829ff3-2338-11ef-8f93-d92a45da78c9','fe5950b5-2338-11ef-8f93-d92a45da78c9','SNAPSHOT'),(2,'aad6386a-233e-11ef-8f93-d92a45da78c9','dcd82fe7-233e-11ef-8f93-d92a45da78c9','MAXILLARY_1'),(2,'aad6386a-233e-11ef-8f93-d92a45da78c9','dcf1877d-233e-11ef-8f93-d92a45da78c9','MANDIBLE_1'),(2,'aad6386a-233e-11ef-8f93-d92a45da78c9','dd5ca018-233e-11ef-8f93-d92a45da78c9','SNAPSHOT'),(2,'aad6386a-233e-11ef-8f93-d92a45da78c9','e43a35c6-233e-11ef-8f93-d92a45da78c9','MANDIBLE_3'),(2,'aad6386a-233e-11ef-8f93-d92a45da78c9','f1f459c8-233e-11ef-8f93-d92a45da78c9','MAXILLARY_2');
/*!40000 ALTER TABLE `OcclusionFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Office`
--

DROP TABLE IF EXISTS `Office`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Office` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `mainPhone` varchar(45) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `cityName` varchar(255) DEFAULT NULL,
  `cityZip` varchar(25) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `country` varchar(75) DEFAULT NULL,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  CONSTRAINT `Office_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Office`
--

LOCK TABLES `Office` WRITE;
/*!40000 ALTER TABLE `Office` DISABLE KEYS */;
INSERT INTO `Office` VALUES ('0022502d-b7d4-4f73-aeee-7fb7bdfc58f5',6,'123456','','','labege','','','France',NULL,'2024-06-06 10:47:25.000','2024-06-06 08:55:07.000','2024-06-06 10:55:07.000'),('1851efb6-58e7-4b73-b221-a63ec0947b77',2,'645636587','iris','','labège','31670','rue de Garance','France',NULL,'2024-06-04 10:35:34.000','2024-06-04 08:35:38.618','2024-06-04 10:35:38.618'),('2b879809-8839-11ec-89bc-2e174fce41cd',1,'0606060606','Biotech-Dental','','Toulouse','31100','Route du test','France',NULL,'2024-06-03 17:04:57.000','2024-06-03 15:04:57.000','2024-06-03 17:04:57.000'),('4a6b3695-fa93-4a3f-9378-90bb33d7f846',5,'6543567543355667787','demo4 envi2','','dfdgfg','1111','hbgdsfdsfvkds','United States of America',NULL,'2024-06-04 11:28:55.000','2024-06-04 09:28:55.000','2024-06-04 11:28:55.000'),('69660fb1-f869-4a6d-ad8d-5934368b7e36',8,'','','','','','','',NULL,'2024-06-06 13:35:54.000','2024-06-06 11:35:54.000','2024-06-06 13:35:54.000'),('932f76a3-95ec-4bb5-8f88-ca34a4f3f172',4,'123123','azerty','','sdfdsgsd','11111','djfhgjfdhg','France',NULL,'2024-06-04 11:24:55.000','2024-06-04 09:24:58.739','2024-06-04 11:24:58.739'),('9cc0b042-5013-47eb-92f3-8311f259d8e0',3,'1234567','Laboratoire Scan4all','','salles d\'aude','11110','av. de Fleury','France',NULL,'2024-06-04 10:40:35.000','2024-06-06 08:41:46.904','2024-06-06 10:41:46.904'),('ff6f0621-4da2-4a18-9852-46415a48170e',7,'','','','','','','',NULL,'2024-06-06 12:16:54.000','2024-06-06 10:16:54.000','2024-06-06 12:16:54.000');
/*!40000 ALTER TABLE `Office` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PersonInfo`
--

DROP TABLE IF EXISTS `PersonInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `PersonInfo` (
  `uuid` varchar(36) NOT NULL,
  `firstname` varchar(64) NOT NULL,
  `lastname` varchar(64) NOT NULL,
  `email` varchar(255) NOT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PersonInfo`
--

LOCK TABLES `PersonInfo` WRITE;
/*!40000 ALTER TABLE `PersonInfo` DISABLE KEYS */;
INSERT INTO `PersonInfo` VALUES ('2ce3a36c-5e54-412a-8e7c-0aa89dba07f8','succursalle Salles d\'aude','laboratoire scan4all','alertes.documentation@scan4all.fr','2024-06-06 12:49:21.000','2024-06-06 14:49:21.000'),('322d8fa4-c617-4f72-9c2e-1733a99f3277','demo4','demo4env2','azerty4@az.fr','2024-06-04 09:28:55.000','2024-06-04 13:58:23.000'),('3e59e29a-8ed6-422a-a6b9-66c5036e5725','sabine','casertA','sabine.caserta@scan4all.fr','2024-06-06 08:24:35.942','2024-06-06 10:24:38.000'),('4114e703-8838-11ec-89bc-2e174fce41cd','Biotech-Dental','LABORATOIRE','lab@biotech-dental.pro','2024-06-03 15:04:56.000','2024-06-03 17:04:56.000'),('750b8eb8-5ce2-437f-82f4-4a47e5fefd5f','demo3','demo3env1','azerty3@az.fr','2024-06-04 09:24:58.727','2024-06-04 13:58:33.000'),('83537036-7322-455c-a4af-7fff1c61122a','','','azerty@scan4all.fr','2024-06-06 11:35:54.000','2024-06-06 13:35:54.000'),('8bb7d06d-0faf-4fbe-9a3e-bf2a50402277','assistant2','IRISassisi','azerty5@az.fr','2024-06-04 12:32:18.047','2024-06-04 14:35:11.000'),('9912c079-ecc5-426a-bf78-e412defe60cd','','','sabine.caserta@live.fr','2024-06-06 10:16:54.000','2024-06-06 12:16:55.000'),('c6949870-aad4-405d-8503-e57cac38673b','client','leger','gamajesas@hotmail.fr','2024-06-06 08:55:07.000','2024-06-06 10:55:07.000'),('ea8bca69-75b7-4877-8406-eca77b86cb2f','assistant1','irisassis1','poiu1@az.fr','2024-06-04 12:15:39.881','2024-06-04 14:18:32.000');
/*!40000 ALTER TABLE `PersonInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PhoneInfo`
--

DROP TABLE IF EXISTS `PhoneInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `PhoneInfo` (
  `uuid` varchar(36) NOT NULL,
  `phone` varchar(45) DEFAULT NULL,
  `cellular` varchar(45) DEFAULT NULL,
  `fax` varchar(45) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PhoneInfo`
--

LOCK TABLES `PhoneInfo` WRITE;
/*!40000 ALTER TABLE `PhoneInfo` DISABLE KEYS */;
INSERT INTO `PhoneInfo` VALUES ('0bb18e78-11bc-4d5d-8f1e-3b8cd38dc1df','123123','','','2024-06-04 09:24:58.727','2024-06-04 13:58:33.000'),('132c8d8b-90f5-472b-ad0c-584767f83050','','','','2024-06-06 11:35:54.000','2024-06-06 13:35:54.000'),('20c3d3f1-dcaa-4a2e-8e37-c50f4a01a441','1234567','','','2024-06-06 12:45:26.000','2024-06-06 14:49:21.000'),('26286661-ce2e-44d4-abe0-ef956962c406','','','','2024-06-06 10:16:54.000','2024-06-06 12:16:55.000'),('47ead308-8838-11ec-89bc-2e174fce41cd','0606060606','','','2024-06-03 15:04:56.000','2024-06-03 17:04:56.000'),('5006bb20-b217-4f74-9b31-713022d3924c','6456365873','','','2024-06-06 08:25:10.437','2024-06-06 10:24:38.000'),('8caa4c94-c597-4679-ba07-d658d15edbb0','','','','2024-06-04 12:32:18.048','2024-06-04 14:35:11.000'),('a5f7ca50-276b-4d1b-a1a9-377f6edcfc4f','123456','','','2024-06-06 08:55:07.000','2024-06-06 10:55:07.000'),('a8b2657e-dca8-42a8-a6cd-7b3dfcdacfac','','','','2024-06-04 12:15:39.882','2024-06-04 14:18:32.000'),('c212da4b-d5a5-4500-b9b9-e34b0c66fd0b','6543567543355667787','','','2024-06-04 09:28:55.000','2024-06-04 13:58:23.000');
/*!40000 ALTER TABLE `PhoneInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Professional`
--

DROP TABLE IF EXISTS `Professional`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Professional` (
  `uuid` varchar(36) NOT NULL,
  `id` mediumint(8) unsigned NOT NULL,
  `credentialsId` varchar(36) DEFAULT NULL,
  `personInfoId` varchar(36) NOT NULL,
  `phoneInfoId` varchar(36) NOT NULL,
  `addressInfoId` varchar(36) NOT NULL,
  `configId` mediumint(8) unsigned DEFAULT NULL,
  `syncInfoId` mediumint(8) unsigned DEFAULT NULL,
  `surgeryName` varchar(255) DEFAULT NULL,
  `comments` text DEFAULT NULL,
  `type` enum('UNDEFINED','PROTHESIST','DENTIST','DEMO','OTHER') NOT NULL DEFAULT 'UNDEFINED',
  `activeComputers` mediumint(8) unsigned DEFAULT NULL,
  `limitedContactId` varchar(36) DEFAULT NULL,
  `directoryVisible` tinyint(1) NOT NULL DEFAULT 1,
  `statusGalaxy` tinyint(1) DEFAULT 0,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  UNIQUE KEY `personInfoId` (`personInfoId`),
  UNIQUE KEY `phoneInfoId` (`phoneInfoId`),
  UNIQUE KEY `addressInfoId` (`addressInfoId`),
  UNIQUE KEY `credentialsId` (`credentialsId`),
  KEY `syncInfoId` (`syncInfoId`,`id`),
  KEY `configId` (`configId`,`id`),
  CONSTRAINT `Professional_ibfk_1` FOREIGN KEY (`credentialsId`) REFERENCES `Credentials` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_2` FOREIGN KEY (`personInfoId`) REFERENCES `PersonInfo` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_3` FOREIGN KEY (`phoneInfoId`) REFERENCES `PhoneInfo` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_4` FOREIGN KEY (`addressInfoId`) REFERENCES `AddressInfo` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_5` FOREIGN KEY (`syncInfoId`, `id`) REFERENCES `SyncInfo` (`id`, `ownerId`) ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_6` FOREIGN KEY (`configId`, `id`) REFERENCES `Config` (`id`, `ownerId`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Professional`
--

LOCK TABLES `Professional` WRITE;
/*!40000 ALTER TABLE `Professional` DISABLE KEYS */;
INSERT INTO `Professional` VALUES ('71b743e8-8838-11ec-89bc-2e174fce41cd',1,'2e995095-88b2-11ec-89bc-2e174fce41cd','4114e703-8838-11ec-89bc-2e174fce41cd','47ead308-8838-11ec-89bc-2e174fce41cd','4caacc66-8838-11ec-89bc-2e174fce41cd',1,1,'','','PROTHESIST',0,NULL,1,0,NULL,'2024-06-03 17:04:56.000','2024-06-03 15:04:56.000','2024-06-03 17:04:56.000'),('4a2ae9c9-fa00-41ed-a598-31b94c8b8955',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','3e59e29a-8ed6-422a-a6b9-66c5036e5725','5006bb20-b217-4f74-9b31-713022d3924c','7780848c-b087-4217-b3a5-e8cb992abbae',1,1,'','','DENTIST',3,NULL,1,0,NULL,'2024-06-06 10:24:38.000','2024-06-06 08:24:38.000','2024-06-06 10:24:38.000'),('8df2a258-8868-49b7-91c2-e2d41d48bffc',3,'adc06de1-bf5d-4b1a-81dc-e5e919328b7c','2ce3a36c-5e54-412a-8e7c-0aa89dba07f8','20c3d3f1-dcaa-4a2e-8e37-c50f4a01a441','a22123da-17c2-438f-97f9-9845680a644b',1,1,'','','DENTIST',2,NULL,1,0,NULL,'2024-06-06 14:49:21.000','2024-06-06 12:49:21.000','2024-06-06 14:49:21.000'),('38094558-549f-40bd-9a81-6301be7324e4',4,'7a0e3a28-a28c-4323-92c1-8831f0d6815b','750b8eb8-5ce2-437f-82f4-4a47e5fefd5f','0bb18e78-11bc-4d5d-8f1e-3b8cd38dc1df','c8db9302-3511-4c3f-b38d-de29e76d9f03',1,1,'','','DENTIST',1,NULL,1,0,NULL,'2024-06-04 11:24:58.000','2024-06-04 11:58:33.000','2024-06-04 13:58:33.000'),('4e72ba02-814f-4116-88da-65f8da1fa385',5,'b35f432d-f5a0-4048-b2dc-1eb3596a89a1','322d8fa4-c617-4f72-9c2e-1733a99f3277','c212da4b-d5a5-4500-b9b9-e34b0c66fd0b','a521e3a9-ad56-413f-990f-60c7817d6962',1,1,'','','DENTIST',1,NULL,1,0,NULL,'2024-06-04 11:28:58.000','2024-06-04 11:58:23.000','2024-06-04 13:58:23.000'),('775748d0-cbb7-4078-a68c-63c2bc78959b',6,'357013df-fab4-4e08-a0b3-25be5d10fb9e','c6949870-aad4-405d-8503-e57cac38673b','a5f7ca50-276b-4d1b-a1a9-377f6edcfc4f','5440e4c6-0dfa-455e-b4bc-20352f964660',1,1,'','','PROTHESIST',32656,NULL,1,0,NULL,'2024-06-06 10:47:25.000','2024-06-06 08:55:07.000','2024-06-06 10:55:07.000'),('40a842ef-8aad-4e46-b586-08781f98a720',7,NULL,'9912c079-ecc5-426a-bf78-e412defe60cd','26286661-ce2e-44d4-abe0-ef956962c406','b625ed42-6f59-4c23-bfe5-3740f8716d69',1,1,'','','UNDEFINED',0,NULL,1,0,NULL,'2024-06-06 12:16:54.000','2024-06-06 10:16:55.000','2024-06-06 12:16:55.000'),('d9bc63ab-c100-4bcf-9b37-bc0c4f091c5c',8,NULL,'83537036-7322-455c-a4af-7fff1c61122a','132c8d8b-90f5-472b-ad0c-584767f83050','500b8a2a-af0c-40fb-ae0b-51f88f080fd3',1,1,'','','UNDEFINED',0,NULL,1,0,NULL,'2024-06-06 13:35:54.000','2024-06-06 11:35:54.000','2024-06-06 13:35:54.000');
/*!40000 ALTER TABLE `Professional` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProfessionalEnvInfos`
--

DROP TABLE IF EXISTS `ProfessionalEnvInfos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProfessionalEnvInfos` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `accessCode` varchar(45) DEFAULT NULL,
  `status` enum('CREATED','CONFIRMED','BLOCKED') NOT NULL DEFAULT 'CREATED',
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`ownerId`),
  CONSTRAINT `ProfessionalEnvInfos_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProfessionalEnvInfos`
--

LOCK TABLES `ProfessionalEnvInfos` WRITE;
/*!40000 ALTER TABLE `ProfessionalEnvInfos` DISABLE KEYS */;
INSERT INTO `ProfessionalEnvInfos` VALUES (1,'','CONFIRMED','2024-06-04 08:35:39.631','2024-06-04 10:35:39.631'),(2,'','CONFIRMED','2024-06-04 08:35:38.618','2024-06-04 10:35:38.618'),(3,'','CONFIRMED','2024-06-04 10:25:08.698','2024-06-04 12:25:08.698'),(4,'','CONFIRMED','2024-06-04 09:24:58.738','2024-06-04 11:24:58.738'),(5,'','CONFIRMED','2024-06-04 11:58:24.312','2024-06-04 13:58:24.312'),(6,'','CONFIRMED','2024-06-06 08:55:48.843','2024-06-06 10:55:48.843'),(7,'1df15635','CREATED','2024-06-06 10:16:55.318','2024-06-06 12:16:55.318'),(8,'f2743369','CREATED','2024-06-06 11:35:57.251','2024-06-06 13:35:57.251');
/*!40000 ALTER TABLE `ProfessionalEnvInfos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProfessionalPatient`
--

DROP TABLE IF EXISTS `ProfessionalPatient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProfessionalPatient` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `patientId` varchar(36) NOT NULL,
  `officeId` varchar(36) DEFAULT NULL,
  `enablePatientSharing` tinyint(1) DEFAULT 0,
  `pinned` tinyint(1) NOT NULL DEFAULT 0,
  `theme` enum('NONE','ADULT','BOY','GIRL','BABY') DEFAULT 'NONE',
  PRIMARY KEY (`ownerId`,`patientId`),
  KEY `patientId` (`patientId`),
  KEY `officeId` (`officeId`),
  CONSTRAINT `ProfessionalPatient_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `ProfessionalPatient_ibfk_2` FOREIGN KEY (`patientId`) REFERENCES `iris_patient`.`Patient` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `ProfessionalPatient_ibfk_3` FOREIGN KEY (`officeId`) REFERENCES `Office` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProfessionalPatient`
--

LOCK TABLES `ProfessionalPatient` WRITE;
/*!40000 ALTER TABLE `ProfessionalPatient` DISABLE KEYS */;
INSERT INTO `ProfessionalPatient` VALUES (2,'791bd8ac-227d-11ef-8f8c-d92a43d45d56','1851efb6-58e7-4b73-b221-a63ec0947b77',0,0,'NONE'),(2,'a1ace9b5-2271-11ef-8d76-d310d2ec2c14','1851efb6-58e7-4b73-b221-a63ec0947b77',0,0,'NONE'),(2,'c81cfb76-2343-11ef-8f93-d92a45da78c9','1851efb6-58e7-4b73-b221-a63ec0947b77',0,0,'NONE'),(2,'ce57500b-227c-11ef-8d76-d310d2ec2c14','1851efb6-58e7-4b73-b221-a63ec0947b77',0,0,'NONE'),(2,'dc803a78-225a-11ef-8f1f-d8242c71b430','1851efb6-58e7-4b73-b221-a63ec0947b77',0,0,'NONE'),(2,'ecf61c34-2958-11ef-9161-de41a781935b','1851efb6-58e7-4b73-b221-a63ec0947b77',0,0,'NONE'),(2,'f3e99d3d-272f-11ef-8e16-d517f37fa1ab','1851efb6-58e7-4b73-b221-a63ec0947b77',0,0,'NONE'),(3,'6220e0d7-2255-11ef-8e3f-d619fca54465','9cc0b042-5013-47eb-92f3-8311f259d8e0',0,0,'NONE'),(3,'e90d651d-2897-11ef-8f6f-d9283dbaec71','9cc0b042-5013-47eb-92f3-8311f259d8e0',0,0,'NONE'),(4,'f8254989-2960-11ef-9161-de41a781935b','932f76a3-95ec-4bb5-8f88-ca34a4f3f172',0,0,'NONE');
/*!40000 ALTER TABLE `ProfessionalPatient` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrder`
--

DROP TABLE IF EXISTS `ProstheticOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProstheticOrder` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `actId` varchar(36) NOT NULL,
  `title` varchar(64) DEFAULT NULL,
  `status` enum('NOT_SENT','SENT','DATE_VALIDATED','DATE_EDITED','VALIDATED','CANCELLED','DELIVERY') NOT NULL DEFAULT 'NOT_SENT',
  `unread` tinyint(1) DEFAULT 0,
  `currentDeliveryDate` datetime(3) DEFAULT NULL,
  `previousDeliveryDate` datetime(3) DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT 0,
  `displayId` mediumint(8) unsigned DEFAULT NULL,
  `pcId` mediumint(8) unsigned DEFAULT NULL,
  `createdById` varchar(36) DEFAULT NULL,
  `updatedById` varchar(36) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `actId` (`actId`),
  CONSTRAINT `ProstheticOrder_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrder_ibfk_2` FOREIGN KEY (`actId`) REFERENCES `Act` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrder`
--

LOCK TABLES `ProstheticOrder` WRITE;
/*!40000 ALTER TABLE `ProstheticOrder` DISABLE KEYS */;
INSERT INTO `ProstheticOrder` VALUES ('02248056-2990-11ef-8fb0-da2b4bf5ebbb',4,'0222265c-2990-11ef-8fb0-da2b4bf5ebbb','Commande 1.9','NOT_SENT',1,NULL,NULL,1,1,1,'38094558-549f-40bd-9a81-6301be7324e4','38094558-549f-40bd-9a81-6301be7324e4','2024-06-13 16:19:55.975','2024-06-13 16:20:10.473','2024-06-13 16:20:10.473','2024-06-13 14:20:10.473',NULL),('023f8d6e-2990-11ef-8fb0-da2b4bf5ebbb',4,'023e35f2-2990-11ef-8fb0-da2b4bf5ebbb','Commande 1.10','NOT_SENT',1,NULL,NULL,1,1,1,'38094558-549f-40bd-9a81-6301be7324e4','38094558-549f-40bd-9a81-6301be7324e4','2024-06-13 16:19:56.152','2024-06-13 16:20:08.636','2024-06-13 16:20:08.636','2024-06-13 14:20:08.637',NULL),('09ee1b7e-2343-11ef-8f93-d92a45da78c9',2,'09ea2f4d-2343-11ef-8f93-d92a45da78c9','Commande 1.7','NOT_SENT',1,NULL,NULL,1,1,1,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-05 15:53:50.815',NULL,'2024-06-05 15:53:50.816','2024-06-05 13:53:50.816',NULL),('11bf1516-2973-11ef-9161-de41a781935b',4,'11bc8a6c-2973-11ef-9161-de41a781935b','Commande 1.2','NOT_SENT',1,NULL,NULL,1,1,1,'38094558-549f-40bd-9a81-6301be7324e4','38094558-549f-40bd-9a81-6301be7324e4','2024-06-13 12:52:46.748',NULL,'2024-06-13 12:52:46.750','2024-06-13 10:52:46.750',NULL),('1d0a7de7-2990-11ef-8fb0-da2b4bf5ebbb',4,'1d080326-2990-11ef-8fb0-da2b4bf5ebbb','Commande 1.11','NOT_SENT',1,NULL,NULL,1,1,1,'38094558-549f-40bd-9a81-6301be7324e4','38094558-549f-40bd-9a81-6301be7324e4','2024-06-13 16:20:41.103',NULL,'2024-06-13 16:20:41.104','2024-06-13 14:20:41.104',NULL),('1d31bcdf-2990-11ef-8fb0-da2b4bf5ebbb',4,'1d30966f-2990-11ef-8fb0-da2b4bf5ebbb','Commande 1.12','NOT_SENT',1,NULL,NULL,1,1,1,'38094558-549f-40bd-9a81-6301be7324e4','38094558-549f-40bd-9a81-6301be7324e4','2024-06-13 16:20:41.360',NULL,'2024-06-13 16:20:41.361','2024-06-13 14:20:41.361',NULL),('3f136589-2336-11ef-8f93-d92a45da78c9',2,'3f0f8fd5-2336-11ef-8f93-d92a45da78c9','Commande 1.4','NOT_SENT',1,NULL,NULL,1,1,1,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-05 14:22:16.521','2024-06-05 14:23:34.795','2024-06-05 14:23:34.796','2024-06-05 12:23:34.796',NULL),('43e25702-2962-11ef-9161-de41a781935b',4,'43de61ec-2962-11ef-9161-de41a781935b','Commande 1.1','NOT_SENT',1,NULL,NULL,1,1,1,'38094558-549f-40bd-9a81-6301be7324e4','38094558-549f-40bd-9a81-6301be7324e4','2024-06-13 10:52:29.421',NULL,'2024-06-13 11:28:26.032','2024-06-13 09:28:26.032',NULL),('62512d88-2990-11ef-8fb0-da2b4bf5ebbb',4,'624eaed5-2990-11ef-8fb0-da2b4bf5ebbb','Commande 1.13','NOT_SENT',1,NULL,NULL,1,1,1,'38094558-549f-40bd-9a81-6301be7324e4','38094558-549f-40bd-9a81-6301be7324e4','2024-06-13 16:22:37.329','2024-06-13 16:22:50.583','2024-06-13 16:22:50.583','2024-06-13 14:22:50.583',NULL),('6fa2e937-2987-11ef-8fb0-da2b4bf5ebbb',4,'6fa078a0-2987-11ef-8fb0-da2b4bf5ebbb','Commande 1.3','NOT_SENT',1,NULL,NULL,1,1,1,'38094558-549f-40bd-9a81-6301be7324e4','38094558-549f-40bd-9a81-6301be7324e4','2024-06-13 15:18:34.204','2024-06-13 16:20:17.202','2024-06-13 16:20:17.202','2024-06-13 14:20:17.202',NULL),('6fe3d6c5-2987-11ef-8fb0-da2b4bf5ebbb',4,'6fe32775-2987-11ef-8fb0-da2b4bf5ebbb','Commande 1.4','NOT_SENT',1,NULL,NULL,1,1,1,'38094558-549f-40bd-9a81-6301be7324e4','38094558-549f-40bd-9a81-6301be7324e4','2024-06-13 15:18:34.630','2024-06-13 16:20:14.873','2024-06-13 16:20:14.873','2024-06-13 14:20:14.873',NULL),('7585401e-2266-11ef-8f1f-d8242c71b430',2,'757ed4bc-2266-11ef-8f1f-d8242c71b430','Commande 1.2','SENT',0,'2024-06-05 00:00:00.000',NULL,0,1,1,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-04 13:34:52.000',NULL,'2024-06-04 14:09:45.000','2024-06-04 12:09:46.000','2024-06-04 14:09:46.000'),('7ebaa0d9-2987-11ef-8fb0-da2b4bf5ebbb',4,'7eb8397d-2987-11ef-8fb0-da2b4bf5ebbb','Commande 1.5','NOT_SENT',1,NULL,NULL,1,1,1,'38094558-549f-40bd-9a81-6301be7324e4','38094558-549f-40bd-9a81-6301be7324e4','2024-06-13 15:18:59.525',NULL,'2024-06-13 15:18:59.527','2024-06-13 13:18:59.527',NULL),('8c269218-233c-11ef-8f93-d92a45da78c9',2,'8c23d690-233c-11ef-8f93-d92a45da78c9','Commande 1.6','NOT_SENT',1,NULL,NULL,1,1,1,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-05 15:07:22.812',NULL,'2024-06-05 15:26:36.700','2024-06-05 13:26:36.701',NULL),('ad34c784-298f-11ef-8fb0-da2b4bf5ebbb',4,'ad326548-298f-11ef-8fb0-da2b4bf5ebbb','Commande 1.6','NOT_SENT',1,NULL,NULL,1,1,1,'38094558-549f-40bd-9a81-6301be7324e4','38094558-549f-40bd-9a81-6301be7324e4','2024-06-13 16:17:33.475','2024-06-13 16:17:52.243','2024-06-13 16:17:52.243','2024-06-13 14:17:52.244',NULL),('ad65dcc5-298f-11ef-8fb0-da2b4bf5ebbb',4,'ad641506-298f-11ef-8fb0-da2b4bf5ebbb','Commande 1.7','NOT_SENT',1,NULL,NULL,1,1,1,'38094558-549f-40bd-9a81-6301be7324e4','38094558-549f-40bd-9a81-6301be7324e4','2024-06-13 16:17:33.797','2024-06-13 16:17:49.949','2024-06-13 16:17:49.949','2024-06-13 14:17:49.950',NULL),('b19eef4f-2336-11ef-8f93-d92a45da78c9',2,'b19ab46f-2336-11ef-8f93-d92a45da78c9','Commande 1.5','SENT',0,'2024-06-06 00:00:00.000',NULL,0,1,1,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-05 14:25:28.000',NULL,'2024-06-05 15:28:00.000','2024-06-05 13:28:02.000','2024-06-05 15:28:02.000'),('c328773a-298f-11ef-8fb0-da2b4bf5ebbb',4,'c32616e0-298f-11ef-8fb0-da2b4bf5ebbb','Commande 1.8','NOT_SENT',1,NULL,NULL,1,1,1,'38094558-549f-40bd-9a81-6301be7324e4','38094558-549f-40bd-9a81-6301be7324e4','2024-06-13 16:18:10.304','2024-06-13 16:19:48.551','2024-06-13 16:19:48.551','2024-06-13 14:19:48.551',NULL),('cdf680d9-227d-11ef-8f8c-d92a43d45d56',2,'cdf2bb52-227d-11ef-8f8c-d92a43d45d56','Commande 3.1','DATE_VALIDATED',0,'2024-06-05 00:00:00.000',NULL,0,1,1,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-04 16:21:59.000',NULL,'2024-06-07 11:31:15.000','2024-06-07 09:31:15.000','2024-06-07 11:31:15.000'),('e3879e0c-225a-11ef-8f1f-d8242c71b430',2,'e3862d66-225a-11ef-8f1f-d8242c71b430','Commande 1.1','VALIDATED',0,'2024-06-06 00:00:00.000','2024-06-05 00:00:00.000',0,1,1,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-04 12:12:03.000',NULL,'2024-06-04 12:29:32.000','2024-06-04 10:29:33.000','2024-06-04 12:29:33.000'),('f1ff350b-2958-11ef-9161-de41a781935b',2,'f1fca9ca-2958-11ef-9161-de41a781935b','Commande 5.1','NOT_SENT',1,NULL,NULL,1,1,1,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-13 09:45:46.567',NULL,'2024-06-13 09:45:46.568','2024-06-13 07:45:46.568',NULL),('f6d25816-226e-11ef-8f1f-d8242c71b430',2,'f6cfa4bf-226e-11ef-8f1f-d8242c71b430','Commande 1.3','SENT',0,'2024-06-05 00:00:00.000',NULL,0,1,1,'4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-04 14:35:45.000',NULL,'2024-06-04 14:39:17.000','2024-06-04 12:39:18.000','2024-06-04 14:39:18.000');
/*!40000 ALTER TABLE `ProstheticOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrderFile`
--

DROP TABLE IF EXISTS `ProstheticOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProstheticOrderFile` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('FORM','SCAN') NOT NULL,
  PRIMARY KEY (`orderId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `ProstheticOrderFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrderFile_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `ProstheticOrder` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrderFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrderFile`
--

LOCK TABLES `ProstheticOrderFile` WRITE;
/*!40000 ALTER TABLE `ProstheticOrderFile` DISABLE KEYS */;
INSERT INTO `ProstheticOrderFile` VALUES (2,'7585401e-2266-11ef-8f1f-d8242c71b430','54a67fcd-226b-11ef-8f1f-d8242c71b430','FORM'),(2,'7585401e-2266-11ef-8f1f-d8242c71b430','6461ca85-2269-11ef-8f1f-d8242c71b430','SCAN'),(2,'7585401e-2266-11ef-8f1f-d8242c71b430','6461d309-2269-11ef-8f1f-d8242c71b430','SCAN'),(2,'7585401e-2266-11ef-8f1f-d8242c71b430','8103b4c6-2269-11ef-8f1f-d8242c71b430','SCAN'),(2,'7585401e-2266-11ef-8f1f-d8242c71b430','8103b848-2269-11ef-8f1f-d8242c71b430','SCAN'),(2,'7585401e-2266-11ef-8f1f-d8242c71b430','9e41d416-2269-11ef-8f1f-d8242c71b430','SCAN'),(2,'7585401e-2266-11ef-8f1f-d8242c71b430','f3576589-2268-11ef-8f1f-d8242c71b430','SCAN'),(2,'7585401e-2266-11ef-8f1f-d8242c71b430','f4024e3a-2268-11ef-8f1f-d8242c71b430','SCAN'),(2,'8c269218-233c-11ef-8f93-d92a45da78c9','310f2987-233f-11ef-8f93-d92a45da78c9','SCAN'),(2,'8c269218-233c-11ef-8f93-d92a45da78c9','9b610e0d-233e-11ef-8f93-d92a45da78c9','SCAN'),(2,'8c269218-233c-11ef-8f93-d92a45da78c9','dcd82fe7-233e-11ef-8f93-d92a45da78c9','SCAN'),(2,'8c269218-233c-11ef-8f93-d92a45da78c9','dcf1877d-233e-11ef-8f93-d92a45da78c9','SCAN'),(2,'8c269218-233c-11ef-8f93-d92a45da78c9','e43a35c6-233e-11ef-8f93-d92a45da78c9','SCAN'),(2,'8c269218-233c-11ef-8f93-d92a45da78c9','ed7a2fab-233e-11ef-8f93-d92a45da78c9','SCAN'),(2,'8c269218-233c-11ef-8f93-d92a45da78c9','efa48c98-233c-11ef-8f93-d92a45da78c9','SCAN'),(2,'8c269218-233c-11ef-8f93-d92a45da78c9','f1f459c8-233e-11ef-8f93-d92a45da78c9','SCAN'),(2,'b19eef4f-2336-11ef-8f93-d92a45da78c9','10a0d811-2339-11ef-8f93-d92a45da78c9','SCAN'),(2,'b19eef4f-2336-11ef-8f93-d92a45da78c9','10a0db7f-2339-11ef-8f93-d92a45da78c9','SCAN'),(2,'b19eef4f-2336-11ef-8f93-d92a45da78c9','10a34539-2339-11ef-8f93-d92a45da78c9','SCAN'),(2,'b19eef4f-2336-11ef-8f93-d92a45da78c9','10a347ba-2339-11ef-8f93-d92a45da78c9','SCAN'),(2,'b19eef4f-2336-11ef-8f93-d92a45da78c9','1ad1adb2-233a-11ef-8f93-d92a45da78c9','SCAN'),(2,'b19eef4f-2336-11ef-8f93-d92a45da78c9','1ffbaca6-2338-11ef-8f93-d92a45da78c9','SCAN'),(2,'b19eef4f-2336-11ef-8f93-d92a45da78c9','3be30703-233b-11ef-8f93-d92a45da78c9','SCAN'),(2,'b19eef4f-2336-11ef-8f93-d92a45da78c9','4c9462f1-2338-11ef-8f93-d92a45da78c9','SCAN'),(2,'b19eef4f-2336-11ef-8f93-d92a45da78c9','51e7fbf0-233a-11ef-8f93-d92a45da78c9','SCAN'),(2,'b19eef4f-2336-11ef-8f93-d92a45da78c9','51e81127-233a-11ef-8f93-d92a45da78c9','SCAN'),(2,'b19eef4f-2336-11ef-8f93-d92a45da78c9','51ec0746-233a-11ef-8f93-d92a45da78c9','SCAN'),(2,'b19eef4f-2336-11ef-8f93-d92a45da78c9','51ec1340-233a-11ef-8f93-d92a45da78c9','SCAN'),(2,'b19eef4f-2336-11ef-8f93-d92a45da78c9','59191380-233f-11ef-8f93-d92a45da78c9','SCAN'),(2,'b19eef4f-2336-11ef-8f93-d92a45da78c9','596c715a-233c-11ef-8f93-d92a45da78c9','SCAN'),(2,'b19eef4f-2336-11ef-8f93-d92a45da78c9','596c8055-233c-11ef-8f93-d92a45da78c9','SCAN'),(2,'b19eef4f-2336-11ef-8f93-d92a45da78c9','596c8c7f-233c-11ef-8f93-d92a45da78c9','SCAN'),(2,'b19eef4f-2336-11ef-8f93-d92a45da78c9','596cc291-233c-11ef-8f93-d92a45da78c9','SCAN'),(2,'b19eef4f-2336-11ef-8f93-d92a45da78c9','5ac77cab-233a-11ef-8f93-d92a45da78c9','SCAN'),(2,'b19eef4f-2336-11ef-8f93-d92a45da78c9','5f8fef48-233c-11ef-8f93-d92a45da78c9','SCAN'),(2,'b19eef4f-2336-11ef-8f93-d92a45da78c9','5fc0481a-233c-11ef-8f93-d92a45da78c9','SCAN'),(2,'b19eef4f-2336-11ef-8f93-d92a45da78c9','5fc04dc7-233c-11ef-8f93-d92a45da78c9','SCAN'),(2,'b19eef4f-2336-11ef-8f93-d92a45da78c9','5fe3c6fc-233b-11ef-8f93-d92a45da78c9','SCAN'),(2,'b19eef4f-2336-11ef-8f93-d92a45da78c9','6d75c326-233f-11ef-8f93-d92a45da78c9','FORM'),(2,'b19eef4f-2336-11ef-8f93-d92a45da78c9','719a9003-233b-11ef-8f93-d92a45da78c9','SCAN'),(2,'b19eef4f-2336-11ef-8f93-d92a45da78c9','719a949c-233b-11ef-8f93-d92a45da78c9','SCAN'),(2,'b19eef4f-2336-11ef-8f93-d92a45da78c9','71a237c5-233b-11ef-8f93-d92a45da78c9','SCAN'),(2,'b19eef4f-2336-11ef-8f93-d92a45da78c9','71a23b4a-233b-11ef-8f93-d92a45da78c9','SCAN'),(2,'b19eef4f-2336-11ef-8f93-d92a45da78c9','84af3b89-233b-11ef-8f93-d92a45da78c9','SCAN'),(2,'b19eef4f-2336-11ef-8f93-d92a45da78c9','b0cc95f2-233b-11ef-8f93-d92a45da78c9','SCAN'),(2,'b19eef4f-2336-11ef-8f93-d92a45da78c9','d6119db2-233b-11ef-8f93-d92a45da78c9','SCAN'),(2,'b19eef4f-2336-11ef-8f93-d92a45da78c9','fdd0378f-2338-11ef-8f93-d92a45da78c9','SCAN'),(2,'b19eef4f-2336-11ef-8f93-d92a45da78c9','fde62b96-2338-11ef-8f93-d92a45da78c9','SCAN'),(2,'b19eef4f-2336-11ef-8f93-d92a45da78c9','fe5950b5-2338-11ef-8f93-d92a45da78c9','SCAN'),(2,'cdf680d9-227d-11ef-8f8c-d92a43d45d56','f0c1893d-227d-11ef-8f8c-d92a43d45d56','SCAN'),(2,'cdf680d9-227d-11ef-8f8c-d92a43d45d56','f0c1a284-227d-11ef-8f8c-d92a43d45d56','SCAN'),(2,'cdf680d9-227d-11ef-8f8c-d92a43d45d56','fefc53d6-227d-11ef-8f8c-d92a43d45d56','FORM'),(2,'e3879e0c-225a-11ef-8f1f-d8242c71b430','326e28f0-225b-11ef-8f1f-d8242c71b430','SCAN'),(2,'e3879e0c-225a-11ef-8f1f-d8242c71b430','326e3f34-225b-11ef-8f1f-d8242c71b430','SCAN'),(2,'e3879e0c-225a-11ef-8f1f-d8242c71b430','54903c9c-225d-11ef-8f1f-d8242c71b430','FORM'),(2,'e3879e0c-225a-11ef-8f1f-d8242c71b430','6782502c-225b-11ef-8f1f-d8242c71b430','SCAN'),(2,'e3879e0c-225a-11ef-8f1f-d8242c71b430','67825ce8-225b-11ef-8f1f-d8242c71b430','SCAN'),(2,'e3879e0c-225a-11ef-8f1f-d8242c71b430','e000eb20-225b-11ef-8f1f-d8242c71b430','SCAN'),(2,'e3879e0c-225a-11ef-8f1f-d8242c71b430','e01bae07-225b-11ef-8f1f-d8242c71b430','SCAN'),(2,'e3879e0c-225a-11ef-8f1f-d8242c71b430','e091c2ff-225b-11ef-8f1f-d8242c71b430','SCAN'),(2,'f6d25816-226e-11ef-8f1f-d8242c71b430','58bcb05a-226f-11ef-8f1f-d8242c71b430','SCAN'),(2,'f6d25816-226e-11ef-8f1f-d8242c71b430','58bcc45d-226f-11ef-8f1f-d8242c71b430','SCAN'),(2,'f6d25816-226e-11ef-8f1f-d8242c71b430','74d6b1c3-226f-11ef-8f1f-d8242c71b430','FORM');
/*!40000 ALTER TABLE `ProstheticOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrderRecipient`
--

DROP TABLE IF EXISTS `ProstheticOrderRecipient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProstheticOrderRecipient` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `recipientId` varchar(36) NOT NULL,
  PRIMARY KEY (`orderId`,`recipientId`),
  KEY `ownerId` (`ownerId`),
  KEY `recipientId` (`recipientId`),
  CONSTRAINT `ProstheticOrderRecipient_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrderRecipient_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `ProstheticOrder` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrderRecipient_ibfk_3` FOREIGN KEY (`recipientId`) REFERENCES `Contact` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrderRecipient`
--

LOCK TABLES `ProstheticOrderRecipient` WRITE;
/*!40000 ALTER TABLE `ProstheticOrderRecipient` DISABLE KEYS */;
INSERT INTO `ProstheticOrderRecipient` VALUES (2,'7585401e-2266-11ef-8f1f-d8242c71b430','4ed4ce00-4b30-4601-95bb-ede535f19c6b'),(2,'b19eef4f-2336-11ef-8f93-d92a45da78c9','4ed4ce00-4b30-4601-95bb-ede535f19c6b'),(2,'cdf680d9-227d-11ef-8f8c-d92a43d45d56','4ed4ce00-4b30-4601-95bb-ede535f19c6b'),(2,'e3879e0c-225a-11ef-8f1f-d8242c71b430','8fbd79fd-0e86-49b8-9558-3a507eb19750'),(2,'f6d25816-226e-11ef-8f1f-d8242c71b430','4ed4ce00-4b30-4601-95bb-ede535f19c6b');
/*!40000 ALTER TABLE `ProstheticOrderRecipient` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticSheet`
--

DROP TABLE IF EXISTS `ProstheticSheet`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProstheticSheet` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `json` text NOT NULL,
  `pdfFileId` varchar(36) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `orderId` (`orderId`),
  KEY `pdfFileId` (`pdfFileId`),
  CONSTRAINT `ProstheticSheet_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `ProstheticSheet_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `ProstheticOrder` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `ProstheticSheet_ibfk_3` FOREIGN KEY (`pdfFileId`) REFERENCES `File` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticSheet`
--

LOCK TABLES `ProstheticSheet` WRITE;
/*!40000 ALTER TABLE `ProstheticSheet` DISABLE KEYS */;
INSERT INTO `ProstheticSheet` VALUES ('0224acbd-2990-11ef-8fb0-da2b4bf5ebbb',4,'02248056-2990-11ef-8fb0-da2b4bf5ebbb','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            27\n        ],\n        \"sheetTitle\": \"Amovible\",\n        \"specificTint\": \"\",\n        \"type\": 7,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-13 16:19:52.111','2024-06-13 16:20:10.473','2024-06-13 16:19:55.976','2024-06-13 14:20:10.474',NULL),('09ee33dc-2343-11ef-8f93-d92a45da78c9',2,'09ee1b7e-2343-11ef-8f93-d92a45da78c9','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            21\n        ],\n        \"sheetTitle\": \"Facette\",\n        \"specificTint\": \"\",\n        \"type\": 6,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-05 15:53:48.412',NULL,'2024-06-05 15:53:50.816','2024-06-05 13:53:50.818',NULL),('11bf457e-2973-11ef-9161-de41a781935b',4,'11bf1516-2973-11ef-9161-de41a781935b','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"Gouttière\",\n        \"subType\": 0,\n        \"type\": 10,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-13 12:52:45.036',NULL,'2024-06-13 12:52:46.750','2024-06-13 10:52:46.750',NULL),('1d0aaaca-2990-11ef-8fb0-da2b4bf5ebbb',4,'1d0a7de7-2990-11ef-8fb0-da2b4bf5ebbb','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            27\n        ],\n        \"sheetTitle\": \"Amovible\",\n        \"specificTint\": \"\",\n        \"type\": 7,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-13 16:20:38.254',NULL,'2024-06-13 16:20:41.104','2024-06-13 14:20:41.104',NULL),('3f137e28-2336-11ef-8f93-d92a45da78c9',2,'3f136589-2336-11ef-8f93-d92a45da78c9','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            26\n        ],\n        \"sheetTitle\": \"Facette\",\n        \"specificTint\": \"\",\n        \"type\": 6,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-05 14:22:12.664','2024-06-05 14:23:34.795','2024-06-05 14:22:16.522','2024-06-05 12:23:34.796',NULL),('43e27e92-2962-11ef-9161-de41a781935b',4,'43e25702-2962-11ef-9161-de41a781935b','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            15,\n            24\n        ],\n        \"sheetTitle\": \"Autre modified\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": true\n    }\n}\n',NULL,'2024-06-13 10:52:26.861',NULL,'2024-06-13 10:52:29.422','2024-06-13 09:28:26.033',NULL),('6251560f-2990-11ef-8fb0-da2b4bf5ebbb',4,'62512d88-2990-11ef-8fb0-da2b4bf5ebbb','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            37\n        ],\n        \"sheetTitle\": \"Autre\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-13 16:22:13.351','2024-06-13 16:22:50.583','2024-06-13 16:22:37.330','2024-06-13 14:22:50.583',NULL),('6fa3162b-2987-11ef-8fb0-da2b4bf5ebbb',4,'6fa2e937-2987-11ef-8fb0-da2b4bf5ebbb','{\n    \"v2\": {\n        \"brandScanBody\": \"Biotech Dental\",\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"refImplant\": \"\",\n        \"refScanBody\": \"K30PSCANPLG\",\n        \"selectedTeeth\": [\n            24,\n            25,\n            26\n        ],\n        \"sheetTitle\": \"Bridge sur implant\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 5,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-13 15:18:29.044','2024-06-13 16:20:17.202','2024-06-13 15:18:34.205','2024-06-13 14:20:17.202',NULL),('75855616-2266-11ef-8f1f-d8242c71b430',2,'7585401e-2266-11ef-8f1f-d8242c71b430','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            17\n        ],\n        \"sheetTitle\": \"Couronne\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 0,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','54a67fcd-226b-11ef-8f1f-d8242c71b430','2024-06-04 13:34:48.000',NULL,'2024-06-04 14:09:46.000','2024-06-04 12:09:46.000','2024-06-04 14:09:46.000'),('7ebad4cb-2987-11ef-8fb0-da2b4bf5ebbb',4,'7ebaa0d9-2987-11ef-8fb0-da2b4bf5ebbb','{\n    \"v2\": {\n        \"brandScanBody\": \"Biotech Dental\",\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"refImplant\": \"\",\n        \"refScanBody\": \"K30PSCANPLG\",\n        \"selectedTeeth\": [\n            14\n        ],\n        \"sheetTitle\": \"Couronne sur implant\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 1,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-13 15:18:53.893',NULL,'2024-06-13 15:18:59.527','2024-06-13 13:18:59.527',NULL),('8c26aa7d-233c-11ef-8f93-d92a45da78c9',2,'8c269218-233c-11ef-8f93-d92a45da78c9','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            15\n        ],\n        \"sheetTitle\": \"Couronne\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 0,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-05 15:07:17.925',NULL,'2024-06-05 15:07:22.812','2024-06-05 13:07:22.813',NULL),('ad34f727-298f-11ef-8fb0-da2b4bf5ebbb',4,'ad34c784-298f-11ef-8fb0-da2b4bf5ebbb','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            28\n        ],\n        \"sheetTitle\": \"Amovible\",\n        \"specificTint\": \"\",\n        \"type\": 7,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-13 16:17:26.697','2024-06-13 16:17:52.243','2024-06-13 16:17:33.476','2024-06-13 14:17:52.244',NULL),('b19f0643-2336-11ef-8f93-d92a45da78c9',2,'b19eef4f-2336-11ef-8f93-d92a45da78c9','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            16\n        ],\n        \"sheetTitle\": \"Facette\",\n        \"specificTint\": \"\",\n        \"type\": 6,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','6d75c326-233f-11ef-8f93-d92a45da78c9','2024-06-05 14:25:26.000',NULL,'2024-06-05 15:28:04.000','2024-06-05 13:28:04.000','2024-06-05 15:28:02.000'),('c328a3f4-298f-11ef-8fb0-da2b4bf5ebbb',4,'c328773a-298f-11ef-8fb0-da2b4bf5ebbb','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            27\n        ],\n        \"sheetTitle\": \"Amovible\",\n        \"specificTint\": \"\",\n        \"type\": 7,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-13 16:17:56.657','2024-06-13 16:19:48.551','2024-06-13 16:18:10.305','2024-06-13 14:19:48.551',NULL),('cdf69648-227d-11ef-8f8c-d92a43d45d56',2,'cdf680d9-227d-11ef-8f8c-d92a43d45d56','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            15\n        ],\n        \"sheetTitle\": \"Autre\",\n        \"type\": 12,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','fefc53d6-227d-11ef-8f8c-d92a43d45d56','2024-06-04 16:21:56.000',NULL,'2024-06-05 14:11:02.000','2024-06-05 12:11:02.000','2024-06-05 14:11:00.000'),('e387c12a-225a-11ef-8f1f-d8242c71b430',2,'e3879e0c-225a-11ef-8f1f-d8242c71b430','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"Guide\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','54903c9c-225d-11ef-8f1f-d8242c71b430','2024-06-04 12:11:58.000',NULL,'2024-06-04 12:27:38.000','2024-06-04 10:29:33.000','2024-06-04 12:29:33.000'),('f1ff63fc-2958-11ef-9161-de41a781935b',2,'f1ff350b-2958-11ef-9161-de41a781935b','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            25\n        ],\n        \"sheetTitle\": \"Facette\",\n        \"specificTint\": \"\",\n        \"type\": 6,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n',NULL,'2024-06-13 09:45:42.322',NULL,'2024-06-13 09:45:46.568','2024-06-13 07:45:46.568',NULL),('f6d26ffb-226e-11ef-8f1f-d8242c71b430',2,'f6d25816-226e-11ef-8f1f-d8242c71b430','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"selectedTeeth\": [\n            11\n        ],\n        \"sheetTitle\": \"Couronne\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 0,\n        \"usePrePreparation\": false,\n        \"useScanSup\": null\n    }\n}\n','74d6b1c3-226f-11ef-8f1f-d8242c71b430','2024-06-04 14:35:34.000',NULL,'2024-06-04 14:39:19.000','2024-06-04 12:39:19.000','2024-06-04 14:39:18.000');
/*!40000 ALTER TABLE `ProstheticSheet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ReceivedAttachment`
--

DROP TABLE IF EXISTS `ReceivedAttachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ReceivedAttachment` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `receivedMessageId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  PRIMARY KEY (`receivedMessageId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `ReceivedAttachment_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `ReceivedAttachment_ibfk_2` FOREIGN KEY (`receivedMessageId`) REFERENCES `ReceivedMessage` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ReceivedAttachment_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ReceivedAttachment`
--

LOCK TABLES `ReceivedAttachment` WRITE;
/*!40000 ALTER TABLE `ReceivedAttachment` DISABLE KEYS */;
INSERT INTO `ReceivedAttachment` VALUES (2,'355a78ac-23e9-11ef-867c-6ec2958327c0','355b14f8-23e9-11ef-867c-6ec2958327c0'),(2,'355a78ac-23e9-11ef-867c-6ec2958327c0','355b5fea-23e9-11ef-867c-6ec2958327c0'),(2,'355a78ac-23e9-11ef-867c-6ec2958327c0','355bb3c0-23e9-11ef-867c-6ec2958327c0'),(2,'a1d987bf-23eb-11ef-867c-6ec2958327c0','a1f8fad4-23eb-11ef-867c-6ec2958327c0'),(2,'a1d987bf-23eb-11ef-867c-6ec2958327c0','a1fba852-23eb-11ef-867c-6ec2958327c0'),(2,'a1d987bf-23eb-11ef-867c-6ec2958327c0','a1fc17b1-23eb-11ef-867c-6ec2958327c0'),(3,'0d0c6171-225e-11ef-867c-6ec2958327c0','0d165e5f-225e-11ef-867c-6ec2958327c0'),(3,'0fe8b36e-2403-11ef-867c-6ec2958327c0','0fed9cbc-2403-11ef-867c-6ec2958327c0'),(3,'0fe8b36e-2403-11ef-867c-6ec2958327c0','0fef6e20-2403-11ef-867c-6ec2958327c0'),(3,'0fe8b36e-2403-11ef-867c-6ec2958327c0','0fefdd19-2403-11ef-867c-6ec2958327c0'),(3,'116b5d2e-225d-11ef-867c-6ec2958327c0','1171b033-225d-11ef-867c-6ec2958327c0'),(3,'116b5d2e-225d-11ef-867c-6ec2958327c0','117372ab-225d-11ef-867c-6ec2958327c0'),(3,'116b5d2e-225d-11ef-867c-6ec2958327c0','1173c2f4-225d-11ef-867c-6ec2958327c0'),(3,'116b5d2e-225d-11ef-867c-6ec2958327c0','1174111e-225d-11ef-867c-6ec2958327c0'),(3,'116b5d2e-225d-11ef-867c-6ec2958327c0','11745799-225d-11ef-867c-6ec2958327c0'),(3,'116b5d2e-225d-11ef-867c-6ec2958327c0','11749a5a-225d-11ef-867c-6ec2958327c0'),(3,'116b5d2e-225d-11ef-867c-6ec2958327c0','117c269a-225d-11ef-867c-6ec2958327c0'),(3,'116b5d2e-225d-11ef-867c-6ec2958327c0','117c6e59-225d-11ef-867c-6ec2958327c0'),(4,'562d4d5b-226b-11ef-867c-6ec2958327c0','562de0a9-226b-11ef-867c-6ec2958327c0'),(4,'562d4d5b-226b-11ef-867c-6ec2958327c0','562e4386-226b-11ef-867c-6ec2958327c0'),(4,'562d4d5b-226b-11ef-867c-6ec2958327c0','562e8775-226b-11ef-867c-6ec2958327c0'),(4,'562d4d5b-226b-11ef-867c-6ec2958327c0','562ec5b4-226b-11ef-867c-6ec2958327c0'),(4,'562d4d5b-226b-11ef-867c-6ec2958327c0','562f1380-226b-11ef-867c-6ec2958327c0'),(4,'562d4d5b-226b-11ef-867c-6ec2958327c0','562f5f75-226b-11ef-867c-6ec2958327c0'),(4,'562d4d5b-226b-11ef-867c-6ec2958327c0','562fafb0-226b-11ef-867c-6ec2958327c0'),(4,'562d4d5b-226b-11ef-867c-6ec2958327c0','562ffbea-226b-11ef-867c-6ec2958327c0');
/*!40000 ALTER TABLE `ReceivedAttachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ReceivedMessage`
--

DROP TABLE IF EXISTS `ReceivedMessage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ReceivedMessage` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `messageTransmitted` tinyint(1) NOT NULL DEFAULT 0,
  `subject` varchar(255) DEFAULT NULL,
  `answeredId` varchar(36) DEFAULT NULL COMMENT 'SentMessage uuid or ReceivedMessage originMessageId',
  `body` text DEFAULT NULL,
  `fromId` mediumint(8) unsigned NOT NULL,
  `originMessageId` varchar(36) DEFAULT NULL,
  `discussionId` varchar(36) NOT NULL,
  `readStatus` enum('READ','UNREAD') DEFAULT 'UNREAD',
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `fromId` (`fromId`),
  KEY `discussionId` (`discussionId`,`ownerId`),
  CONSTRAINT `ReceivedMessage_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `ReceivedMessage_ibfk_2` FOREIGN KEY (`fromId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `ReceivedMessage_ibfk_3` FOREIGN KEY (`discussionId`, `ownerId`) REFERENCES `Discussion` (`uuid`, `ownerId`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ReceivedMessage`
--

LOCK TABLES `ReceivedMessage` WRITE;
/*!40000 ALTER TABLE `ReceivedMessage` DISABLE KEYS */;
INSERT INTO `ReceivedMessage` VALUES ('0d0c6171-225e-11ef-867c-6ec2958327c0',3,1,'Commande 1.1',NULL,'envoi d\'une capture supp',2,'0d22759d-225e-11ef-8f1f-d8242c71b430','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-04 12:34:41.000',NULL,'2024-06-04 12:34:41.000','2024-06-04 10:34:51.000','2024-06-04 12:34:51.000'),('0f060cb3-23ea-11ef-867c-6ec2958327c0',3,1,'Commande 2.2 [pc1]',NULL,'bien receptionné sur ihm env1 mais obligation de valider la cmde via le web. réponse faite via le filtre de discussion activé',2,'0eb44d73-23ea-11ef-8f8c-d92a43d45e5a','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-06 11:49:24.000',NULL,'2024-06-06 11:49:24.000','2024-06-06 09:49:34.000','2024-06-06 11:49:34.000'),('0fe8b36e-2403-11ef-867c-6ec2958327c0',3,1,'Commande 3.1 [pc2]',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 3.1 [pc2]\",\"date\":\"2024-06-07T00:00:00\",\"orderUpdateTime\":\"2024-06-06T14:48:11\",\"orderId\":\"da3bcb3f-227c-11ef-8d76-d310d2ec2c14\"}',2,'0874bbc1-2403-11ef-8dde-d415e84cc4f5','0f3dfe44-225d-11ef-8f1f-d8242c71b430','UNREAD','2024-06-06 14:48:11.000',NULL,'2024-06-06 14:48:11.000','2024-06-07 10:15:21.000','2024-06-07 12:15:21.000'),('116b5d2e-225d-11ef-867c-6ec2958327c0',3,1,'Commande 1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.1\",\"date\":\"2024-06-05T00:00:00\",\"orderUpdateTime\":\"2024-06-04T12:27:35\",\"orderId\":\"e3879e0c-225a-11ef-8f1f-d8242c71b430\"}',2,'0f3e4980-225d-11ef-8f1f-d8242c71b430','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-04 12:27:35.000',NULL,'2024-06-04 12:27:35.000','2024-06-04 10:27:59.000','2024-06-04 12:27:59.000'),('170f370c-23e8-11ef-867c-6ec2958327c0',3,1,'Commande 2.1',NULL,'API_META={\"type\":\"order\",\"key\":\"cancelled\",\"title\":\"Commande 2.1\",\"date\":\"2024-06-07T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-06T11:35:19+02:00\",\"orderId\":\"96b5001d-23e7-11ef-8dde-d415e84cc4f5\"}',6,'e8e0d490-f4d8-4b73-aec7-c871fbf26f95','ddab36aa-23e2-11ef-8f8c-d92a43d45e5a','READ','2024-06-06 11:35:19.000',NULL,'2024-06-06 11:35:19.000','2024-06-06 09:35:29.000','2024-06-06 11:35:29.000'),('2ab80fc1-23eb-11ef-867c-6ec2958327c0',3,1,'Commande 1.1',NULL,'test envoi de la page discussion sur le web',2,'4db93275-aa1c-442f-b2b5-af6c4514bd24','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-06 11:57:21.000',NULL,'2024-06-06 11:57:21.000','2024-06-06 09:57:31.000','2024-06-06 11:57:31.000'),('31c11bd1-23e8-11ef-867c-6ec2958327c0',3,1,'Commande 2.1',NULL,'commande refusée par client leger et envoi de ce message via icone du tchat côté web',6,'6bc716cf-d2dc-4793-8776-6a7d195da882','ddab36aa-23e2-11ef-8f8c-d92a43d45e5a','READ','2024-06-06 11:36:04.000',NULL,'2024-06-06 11:36:04.000','2024-06-06 09:36:14.000','2024-06-06 11:36:14.000'),('355a78ac-23e9-11ef-867c-6ec2958327c0',2,1,'Commande 2.2 [pc1]',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 2.2 [pc1]\",\"date\":\"2024-06-07T00:00:00\",\"orderUpdateTime\":\"2024-06-06T11:43:17\",\"orderId\":\"0bd68b18-23e9-11ef-8dde-d415e84cc4f5\"}',3,'33e44dc1-23e9-11ef-8dde-d415e84cc4f5','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-06 11:43:17.000',NULL,'2024-06-06 11:43:17.000','2024-06-06 09:48:09.000','2024-06-06 11:48:09.000'),('4ffecbc2-225d-11ef-867c-6ec2958327c0',2,1,'Commande 1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"edited\",\"title\":\"Commande 1.1\",\"date\":\"2024-06-06T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-04T12:29:24+02:00\",\"orderId\":\"e3879e0c-225a-11ef-8f1f-d8242c71b430\"}',3,'10351862-fb40-4aa9-a4ab-7afe4dba87b9','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-04 12:29:24.000',NULL,'2024-06-04 12:29:24.000','2024-06-04 10:29:35.982','2024-06-04 12:29:35.984'),('50383fde-23eb-11ef-867c-6ec2958327c0',3,1,'Commande 2.2',NULL,'API_META={\"type\":\"order\",\"key\":\"edited\",\"title\":\"Commande 2.2\",\"date\":\"2024-06-08T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-06T11:58:24+02:00\",\"orderId\":\"0bd68b18-23e9-11ef-8dde-d415e84cc4f5\"}',2,'e03dc949-f924-4e48-a5fd-e8273bbf6e07','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-06 11:58:24.000',NULL,'2024-06-06 11:58:24.000','2024-06-06 09:58:35.000','2024-06-06 11:58:35.000'),('550dc721-225d-11ef-867c-6ec2958327c0',3,1,'Commande 1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"validated\",\"title\":\"Commande 1.1\",\"date\":\"2024-06-06T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-04T12:29:32+02:00\",\"orderId\":\"e3879e0c-225a-11ef-8f1f-d8242c71b430\"}',2,'7c7133c4-869b-4ecf-be8c-a7ba25b96324','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-04 12:29:32.000',NULL,'2024-06-04 12:29:32.000','2024-06-04 10:29:42.000','2024-06-04 12:29:42.000'),('562d4d5b-226b-11ef-867c-6ec2958327c0',4,1,'Commande 1.2',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.2\",\"date\":\"2024-06-05T00:00:00\",\"orderUpdateTime\":\"2024-06-04T14:09:45\",\"orderId\":\"7585401e-2266-11ef-8f1f-d8242c71b430\"}',2,'550f3fc1-226b-11ef-8f1f-d8242c71b430','550eb27a-226b-11ef-8f1f-d8242c71b430','READ','2024-06-04 14:09:45.000',NULL,'2024-06-04 14:09:45.000','2024-06-04 12:10:28.990','2024-06-04 14:10:29.002'),('570e51d7-225e-11ef-867c-6ec2958327c0',2,1,'5701b18b-225e-11ef-8d76-d310d2ec2c14',NULL,'bla bla bla',3,'5701b18b-225e-11ef-8d76-d310d2ec2c14','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-04 12:36:45.000',NULL,'2024-06-04 12:36:45.000','2024-06-04 10:36:55.982','2024-06-04 12:36:55.991'),('572c8e2a-23ed-11ef-867c-6ec2958327c0',2,1,'Commande 2.3 [pc1]',NULL,'bla bla\n',3,'56f0c51f-23ed-11ef-8dde-d415e84cc4f5','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-06 12:12:54.000',NULL,'2024-06-06 12:12:54.000','2024-06-06 12:18:51.000','2024-06-06 14:18:51.000'),('5c246693-23e4-11ef-867c-6ec2958327c0',3,1,'5c02d3d5-23e4-11ef-8dde-d415e84cc4f5',NULL,'envoi d\'un message via env2',2,'5c02d3d5-23e4-11ef-8dde-d415e84cc4f5','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-06 11:08:37.000',NULL,'2024-06-06 11:08:37.000','2024-06-06 09:09:43.000','2024-06-06 11:09:43.000'),('62cf350a-225e-11ef-867c-6ec2958327c0',2,1,'Commande 1.1','0d22759d-225e-11ef-8f1f-d8242c71b430','bla bla bla',3,'62d4940c-225e-11ef-8d76-d310d2ec2c14','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-04 12:37:05.000',NULL,'2024-06-04 12:37:05.000','2024-06-04 10:37:15.979','2024-06-04 12:37:15.989'),('74d56a26-23e4-11ef-867c-6ec2958327c0',3,1,'Commande 1.1',NULL,'envoi d\'un message via web (env1.ci...)',2,'2f604f05-d11c-43d9-bdf9-d43e0306dfda','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-06 11:09:19.000',NULL,'2024-06-06 11:09:19.000','2024-06-06 09:09:43.000','2024-06-06 11:09:43.000'),('74f683c8-23ff-11ef-867c-6ec2958327c0',2,1,'Réponse depuis le web',NULL,'bla bla via page discussion du web',3,'59cfafae-e9ce-4a51-be20-09e9860da4b4','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-06 14:22:35.000',NULL,'2024-06-06 14:22:35.000','2024-06-06 12:22:45.000','2024-06-06 14:22:45.000'),('79d26d16-226b-11ef-867c-6ec2958327c0',2,1,'Commande 1.2',NULL,'demande de précision sur cmde1.2; blabla',4,'79e4936c-226b-11ef-8f1f-d8242c71b430','550eb27a-226b-11ef-8f1f-d8242c71b430','READ','2024-06-04 14:10:47.000',NULL,'2024-06-04 14:10:47.000','2024-06-04 12:11:54.000','2024-06-04 14:11:54.000'),('9687a4b2-23e4-11ef-867c-6ec2958327c0',2,1,'96378603-23e4-11ef-8f8c-d92a43d45e5a',NULL,'bla bla',3,'96378603-23e4-11ef-8f8c-d92a43d45e5a','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-06 11:10:15.000',NULL,'2024-06-06 11:10:15.000','2024-06-06 09:25:12.000','2024-06-06 11:25:12.000'),('995a2659-23ff-11ef-867c-6ec2958327c0',2,1,'Réponse depuis le web',NULL,'bla bla via tchat web de la cmde 2.3',3,'2192fe1a-0490-4bd9-8f2d-363155abc9a2','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-06 14:23:36.000',NULL,'2024-06-06 14:23:36.000','2024-06-06 12:23:46.000','2024-06-06 14:23:46.000'),('9e94da22-23e4-11ef-867c-6ec2958327c0',2,1,'Commande 1.1','2f604f05-d11c-43d9-bdf9-d43e0306dfda','bla bla',3,'9e44f2e9-23e4-11ef-8f8c-d92a43d45e5a','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-06 11:10:28.000',NULL,'2024-06-06 11:10:28.000','2024-06-06 09:25:11.000','2024-06-06 11:25:11.000'),('a1d987bf-23eb-11ef-867c-6ec2958327c0',2,1,'Commande 2.3 [pc1]',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 2.3 [pc1]\",\"date\":\"2024-06-07T00:00:00\",\"orderUpdateTime\":\"2024-06-06T12:00:29\",\"orderId\":\"8d24e986-23eb-11ef-8dde-d415e84cc4f5\"}',3,'9ac047ea-23eb-11ef-8dde-d415e84cc4f5','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-06 12:00:29.000',NULL,'2024-06-06 12:00:29.000','2024-06-06 10:01:33.000','2024-06-06 12:01:33.000'),('aff5b8e7-24b0-11ef-867c-6ec2958327c0',2,1,'Commande 3.1',NULL,'API_META={\"type\":\"order\",\"key\":\"validated\",\"title\":\"Commande 3.1\",\"date\":\"2024-06-05T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-07T11:31:15+02:00\",\"orderId\":\"cdf680d9-227d-11ef-8f8c-d92a43d45d56\"}',4,'a41db7d3-7303-45b0-8303-b14769b1e4a1','550eb27a-226b-11ef-8f1f-d8242c71b430','READ','2024-06-07 11:31:15.000',NULL,'2024-06-07 11:31:15.000','2024-06-07 09:33:44.000','2024-06-07 11:33:44.000'),('b3261ac7-23e3-11ef-867c-6ec2958327c0',3,1,'Réponse depuis le web',NULL,'verification fait client leger accès adresse web env1.ci... et env2.ci...',6,'e01b5a33-cdcb-4378-86e6-18688bf5e2c7','ddab36aa-23e2-11ef-8f8c-d92a43d45e5a','READ','2024-06-06 11:03:54.000',NULL,'2024-06-06 11:03:54.000','2024-06-06 09:04:14.000','2024-06-06 11:04:14.000'),('b6cb7a0f-24b0-11ef-867c-6ec2958327c0',2,1,'Commande 1.3',NULL,'API_META={\"type\":\"order\",\"key\":\"edited\",\"title\":\"Commande 1.3\",\"date\":\"2024-06-09T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-07T11:31:27+02:00\",\"orderId\":\"a4229655-2279-11ef-8d76-d310d2ec2c14\"}',4,'7d0f691a-9c00-489d-8243-66ee0a86fdd9','550eb27a-226b-11ef-8f1f-d8242c71b430','READ','2024-06-07 11:31:27.000',NULL,'2024-06-07 11:31:27.000','2024-06-07 09:33:43.203','2024-06-07 11:33:43.205'),('bb577816-24b0-11ef-867c-6ec2958327c0',2,1,'Commande 1.2',NULL,'API_META={\"type\":\"order\",\"key\":\"cancelled\",\"title\":\"Commande 1.2\",\"date\":\"2024-06-05T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-07T11:31:34+02:00\",\"orderId\":\"f26746c9-2272-11ef-8d76-d310d2ec2c14\"}',4,'fe6b754c-a512-46f3-9426-e30c1d545798','550eb27a-226b-11ef-8f1f-d8242c71b430','READ','2024-06-07 11:31:34.000',NULL,'2024-06-07 11:31:34.000','2024-06-07 09:33:43.177','2024-06-07 11:33:43.186'),('c47e1cc6-23eb-11ef-867c-6ec2958327c0',3,1,'Commande 1.1',NULL,'bla bla',2,'4c1489bb-54c8-4aa3-8017-d140fe974c2f','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-06 12:01:39.000',NULL,'2024-06-06 12:01:39.000','2024-06-06 10:01:49.000','2024-06-06 12:01:49.000'),('dabd2a05-23eb-11ef-867c-6ec2958327c0',3,1,'Commande 2.3',NULL,'API_META={\"type\":\"order\",\"key\":\"validated\",\"title\":\"Commande 2.3\",\"date\":\"2024-06-07T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-06T12:02:16+02:00\",\"orderId\":\"8d24e986-23eb-11ef-8dde-d415e84cc4f5\"}',2,'ec59b1ff-79e7-49aa-9888-5b1e722d3d80','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-06 12:02:16.000',NULL,'2024-06-06 12:02:16.000','2024-06-06 10:02:27.000','2024-06-06 12:02:27.000'),('ee1e58c0-23e2-11ef-867c-6ec2958327c0',3,1,'Réponse depuis le web',NULL,'bien receptionnée sous cette adresse web',6,'3780be11-022f-4964-b8ea-04a384437849','ddab36aa-23e2-11ef-8f8c-d92a43d45e5a','READ','2024-06-06 10:58:23.000',NULL,'2024-06-06 10:58:23.000','2024-06-06 08:58:36.000','2024-06-06 10:58:36.000'),('f39aca13-23e4-11ef-867c-6ec2958327c0',2,1,'f352fb85-23e4-11ef-8f8c-d92a43d45e5a',NULL,'test envoi texte sous discussion non filtrée',3,'f352fb85-23e4-11ef-8f8c-d92a43d45e5a','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-06 11:12:51.000',NULL,'2024-06-06 11:12:51.000','2024-06-06 09:25:11.000','2024-06-06 11:25:11.000'),('f4e1d5f4-23ea-11ef-867c-6ec2958327c0',3,1,'Commande 2.2 [pc1]',NULL,'réponse via web via le tchat de la cmde',2,'fad71f64-8b16-4fc8-94d4-6ae6473112ab','0f3dfe44-225d-11ef-8f1f-d8242c71b430','READ','2024-06-06 11:55:50.000',NULL,'2024-06-06 11:55:50.000','2024-06-06 09:56:45.000','2024-06-06 11:56:45.000');
/*!40000 ALTER TABLE `ReceivedMessage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Scan`
--

DROP TABLE IF EXISTS `Scan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Scan` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL,
  `sessionId` varchar(36) NOT NULL,
  `type` enum('MAXILLAIRE','MANDIBULE','MORDU_ANTERIEUR','MORDU_POSTERIEUR_GAUCHE','MORDU_POSTERIEUR_DROIT') NOT NULL,
  `label` enum('PRE_PREPARATION','SCAN','SCANBODY','SCAN_SUP') NOT NULL DEFAULT 'SCAN',
  `validated` tinyint(1) NOT NULL DEFAULT 0,
  `status` enum('IN_PROGRESS','NONE') NOT NULL DEFAULT 'IN_PROGRESS',
  `displayId` mediumint(8) unsigned DEFAULT NULL,
  `pcId` mediumint(8) unsigned DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT 0,
  `comments` text DEFAULT NULL,
  `createdById` varchar(36) DEFAULT NULL,
  `updatedById` varchar(36) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `sessionId` (`sessionId`),
  CONSTRAINT `Scan_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `Scan_ibfk_2` FOREIGN KEY (`sessionId`) REFERENCES `Session` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Scan`
--

LOCK TABLES `Scan` WRITE;
/*!40000 ALTER TABLE `Scan` DISABLE KEYS */;
INSERT INTO `Scan` VALUES ('09768650-2267-11ef-8f1f-d8242c71b430',2,'75806ee1-2266-11ef-8f1f-d8242c71b430','MAXILLAIRE','SCAN',1,'NONE',1,1,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-04 13:39:00.751',NULL,'2024-06-04 13:56:40.293','2024-06-04 11:56:40.293','2024-06-04 13:56:40.308'),('0ab76b82-2343-11ef-8f93-d92a45da78c9',2,'09ebd700-2343-11ef-8f93-d92a45da78c9','MANDIBULE','SCAN',1,'NONE',1,1,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-05 15:53:52.000',NULL,'2024-06-05 15:55:21.000','2024-06-05 13:55:23.000','2024-06-05 15:55:23.000'),('0cfe6c2e-2268-11ef-8f1f-d8242c71b430',2,'75806ee1-2266-11ef-8f1f-d8242c71b430','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,1,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-04 13:46:16.000',NULL,'2024-06-04 13:47:06.000','2024-06-04 11:47:09.000','2024-06-04 13:47:09.000'),('129f0828-2973-11ef-9161-de41a781935b',4,'11be1b4d-2973-11ef-9161-de41a781935b','MAXILLAIRE','SCAN',1,'NONE',1,1,0,'','38094558-549f-40bd-9a81-6301be7324e4','38094558-549f-40bd-9a81-6301be7324e4','2024-06-13 12:52:48.216',NULL,'2024-06-13 13:02:03.322','2024-06-13 11:02:03.322',NULL),('23e52d54-2338-11ef-8f93-d92a45da78c9',2,'b19c6074-2336-11ef-8f93-d92a45da78c9','MANDIBULE','SCAN',1,'NONE',1,1,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-05 14:35:49.000',NULL,'2024-06-05 15:02:17.000','2024-06-05 13:02:23.000','2024-06-05 15:02:23.000'),('24861dc8-226f-11ef-8f1f-d8242c71b430',2,'f6d13d7e-226e-11ef-8f1f-d8242c71b430','MAXILLAIRE','SCAN',1,'NONE',1,1,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-04 14:37:02.000',NULL,'2024-06-04 14:38:30.000','2024-06-04 12:38:45.000','2024-06-04 14:38:45.000'),('2b917de0-298e-11ef-8fb0-da2b4bf5ebbb',4,'6fa1d062-2987-11ef-8fb0-da2b4bf5ebbb','MAXILLAIRE','SCANBODY',1,'NONE',1,1,0,'','38094558-549f-40bd-9a81-6301be7324e4','38094558-549f-40bd-9a81-6301be7324e4','2024-06-13 16:06:46.482','2024-06-13 16:20:17.213','2024-06-13 16:20:17.213','2024-06-13 14:20:17.214',NULL),('2e146f3d-233a-11ef-8f93-d92a45da78c9',2,'b19c6074-2336-11ef-8f93-d92a45da78c9','MAXILLAIRE','SCAN',1,'NONE',2,1,0,'{\"referenceScanId\":\"ef3ba736-2337-11ef-8f93-d92a45da78c9\"}','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-05 14:50:25.000',NULL,'2024-06-05 14:59:28.000','2024-06-05 12:59:30.000','2024-06-05 14:59:30.000'),('37ccba29-225b-11ef-8f1f-d8242c71b430',2,'e3868e5f-225a-11ef-8f1f-d8242c71b430','MANDIBULE','SCAN',1,'NONE',1,1,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-04 12:14:24.000',NULL,'2024-06-04 12:15:45.000','2024-06-04 10:15:47.000','2024-06-04 12:15:47.000'),('40c1fc5f-2336-11ef-8f93-d92a45da78c9',2,'3f113a7c-2336-11ef-8f93-d92a45da78c9','MAXILLAIRE','SCAN',1,'NONE',1,1,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-05 14:22:19.000','2024-06-05 14:23:36.000','2024-06-05 14:23:18.000','2024-06-05 12:23:36.000','2024-06-05 14:23:36.000'),('4cc68cd8-2962-11ef-9161-de41a781935b',4,'43dfe39a-2962-11ef-9161-de41a781935b','MAXILLAIRE','SCANBODY',1,'NONE',1,1,0,'','38094558-549f-40bd-9a81-6301be7324e4','38094558-549f-40bd-9a81-6301be7324e4','2024-06-13 10:52:44.338',NULL,'2024-06-13 13:26:44.053','2024-06-13 11:26:44.054',NULL),('4eb3e0e7-2964-11ef-9161-de41a781935b',4,'43dfe39a-2962-11ef-9161-de41a781935b','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',2,1,0,'','38094558-549f-40bd-9a81-6301be7324e4','38094558-549f-40bd-9a81-6301be7324e4','2024-06-13 11:07:06.565',NULL,'2024-06-13 11:11:20.605','2024-06-13 09:11:20.605',NULL),('596c4e98-233c-11ef-8f93-d92a45da78c9',2,'b19c6074-2336-11ef-8f93-d92a45da78c9','MANDIBULE','SCAN',1,'NONE',2,1,0,'{\"referenceScanId\":\"23e52d54-2338-11ef-8f93-d92a45da78c9\"}','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-05 15:05:57.000',NULL,'2024-06-05 15:05:59.000','2024-06-05 13:06:07.000','2024-06-05 15:06:07.000'),('5982089a-2268-11ef-8f1f-d8242c71b430',2,'75806ee1-2266-11ef-8f1f-d8242c71b430','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',2,1,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-04 13:48:24.000',NULL,'2024-06-04 13:50:18.000','2024-06-04 11:50:21.000','2024-06-04 13:50:21.000'),('5a97f8c0-2967-11ef-9161-de41a781935b',4,'43dfe39a-2962-11ef-9161-de41a781935b','MAXILLAIRE','SCAN',1,'NONE',2,1,0,'{\"referenceScanId\":\"4cc68cd8-2962-11ef-9161-de41a781935b\"}','38094558-549f-40bd-9a81-6301be7324e4','38094558-549f-40bd-9a81-6301be7324e4','2024-06-13 11:28:55.005','2024-06-13 11:39:15.670','2024-06-13 11:39:15.671','2024-06-13 09:39:15.671',NULL),('6d6c8ddd-225b-11ef-8f1f-d8242c71b430',2,'e3868e5f-225a-11ef-8f1f-d8242c71b430','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,1,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-04 12:15:54.000',NULL,'2024-06-04 12:16:34.000','2024-06-04 10:16:37.000','2024-06-04 12:16:37.000'),('7b02accf-2967-11ef-9161-de41a781935b',4,'43dfe39a-2962-11ef-9161-de41a781935b','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',3,1,0,'','38094558-549f-40bd-9a81-6301be7324e4','38094558-549f-40bd-9a81-6301be7324e4','2024-06-13 11:29:49.391',NULL,'2024-06-13 11:30:43.657','2024-06-13 09:30:43.657',NULL),('8e15b6ed-225b-11ef-8f1f-d8242c71b430',2,'e3868e5f-225a-11ef-8f1f-d8242c71b430','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',2,1,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-04 12:16:49.000',NULL,'2024-06-04 12:17:58.000','2024-06-04 10:18:01.000','2024-06-04 12:18:01.000'),('9398352e-2963-11ef-9161-de41a781935b',4,'43dfe39a-2962-11ef-9161-de41a781935b','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,1,0,'','38094558-549f-40bd-9a81-6301be7324e4','38094558-549f-40bd-9a81-6301be7324e4','2024-06-13 11:01:52.650',NULL,'2024-06-13 11:04:16.703','2024-06-13 09:04:16.704',NULL),('93bdd6ef-233c-11ef-8f93-d92a45da78c9',2,'8c257d6d-233c-11ef-8f93-d92a45da78c9','MAXILLAIRE','SCAN',1,'NONE',1,1,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-05 15:07:35.000',NULL,'2024-06-05 15:26:18.000','2024-06-05 13:26:21.000','2024-06-05 15:26:21.000'),('9b60e5c1-233e-11ef-8f93-d92a45da78c9',2,'8c257d6d-233c-11ef-8f93-d92a45da78c9','MANDIBULE','SCAN',1,'NONE',3,1,0,'{\"referenceScanId\":\"d286674d-233c-11ef-8f93-d92a45da78c9\"}','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-05 15:22:07.000',NULL,'2024-06-05 15:22:08.000','2024-06-05 13:22:10.000','2024-06-05 15:22:10.000'),('a7dd3d5c-2338-11ef-8f93-d92a45da78c9',2,'b19c6074-2336-11ef-8f93-d92a45da78c9','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,1,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-05 14:39:31.000',NULL,'2024-06-05 14:40:27.000','2024-06-05 12:40:31.000','2024-06-05 14:40:31.000'),('aeb8dd17-233e-11ef-8f93-d92a45da78c9',2,'8c257d6d-233c-11ef-8f93-d92a45da78c9','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,1,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-05 15:22:39.000',NULL,'2024-06-05 15:23:52.000','2024-06-05 13:23:56.000','2024-06-05 15:23:56.000'),('af14b2d9-233c-11ef-8f93-d92a45da78c9',2,'8c257d6d-233c-11ef-8f93-d92a45da78c9','MANDIBULE','SCAN',1,'NONE',1,1,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-05 15:08:21.000','2024-06-05 15:09:20.000','2024-06-05 15:08:57.000','2024-06-05 13:09:20.000','2024-06-05 15:09:20.000'),('b4da925f-2267-11ef-8f1f-d8242c71b430',2,'75806ee1-2266-11ef-8f1f-d8242c71b430','MANDIBULE','SCAN',1,'NONE',1,1,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-04 13:43:48.000',NULL,'2024-06-04 13:45:23.000','2024-06-04 11:45:25.000','2024-06-04 13:45:25.000'),('b70f8ae5-2343-11ef-8f93-d92a45da78c9',2,'b651dff3-2343-11ef-8f93-d92a45da78c9','MAXILLAIRE','SCAN',1,'NONE',1,1,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-05 15:58:41.000',NULL,'2024-06-05 15:59:05.000','2024-06-05 13:59:13.000','2024-06-05 15:59:13.000'),('b926a968-2962-11ef-9161-de41a781935b',4,'43dfe39a-2962-11ef-9161-de41a781935b','MANDIBULE','SCAN',1,'NONE',1,1,0,'','38094558-549f-40bd-9a81-6301be7324e4','38094558-549f-40bd-9a81-6301be7324e4','2024-06-13 10:55:46.162',NULL,'2024-06-13 15:54:14.203','2024-06-13 13:54:14.203',NULL),('b9e0ca90-2268-11ef-8f1f-d8242c71b430',2,'75806ee1-2266-11ef-8f1f-d8242c71b430','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,1,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-04 13:51:06.000',NULL,'2024-06-04 13:52:36.000','2024-06-04 11:52:39.000','2024-06-04 13:52:39.000'),('cf823728-227d-11ef-8f8c-d92a43d45d56',2,'cdf45240-227d-11ef-8f8c-d92a43d45d56','MAXILLAIRE','SCAN',1,'NONE',1,1,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-04 16:22:01.000',NULL,'2024-06-04 16:22:57.000','2024-06-04 14:23:03.000','2024-06-04 16:23:03.000'),('d286674d-233c-11ef-8f93-d92a45da78c9',2,'8c257d6d-233c-11ef-8f93-d92a45da78c9','MANDIBULE','SCAN',1,'NONE',2,1,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-05 15:09:20.000',NULL,'2024-06-05 15:10:10.000','2024-06-05 13:10:14.000','2024-06-05 15:10:14.000'),('e52279ce-225a-11ef-8f1f-d8242c71b430',2,'e3868e5f-225a-11ef-8f1f-d8242c71b430','MAXILLAIRE','SCAN',1,'NONE',1,1,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-04 12:12:05.000',NULL,'2024-06-04 12:31:53.000','2024-06-04 10:31:54.000','2024-06-04 12:31:54.000'),('ea48ab1e-2897-11ef-8f6f-d9283dbaec71',3,'e90e3796-2897-11ef-8f6f-d9283dbaec71','MAXILLAIRE','SCAN',1,'NONE',1,2,1,'','8df2a258-8868-49b7-91c2-e2d41d48bffc','8df2a258-8868-49b7-91c2-e2d41d48bffc','2024-06-12 10:44:00.757',NULL,'2024-06-12 10:45:08.261','2024-06-12 08:45:08.261',NULL),('ed7a17d3-233e-11ef-8f93-d92a45da78c9',2,'8c257d6d-233c-11ef-8f93-d92a45da78c9','MAXILLAIRE','SCAN',1,'NONE',2,1,0,'{\"referenceScanId\":\"93bdd6ef-233c-11ef-8f93-d92a45da78c9\"}','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-05 15:24:25.000',NULL,'2024-06-05 15:24:25.000','2024-06-05 13:24:28.000','2024-06-05 15:24:28.000'),('eec0c27d-2987-11ef-8fb0-da2b4bf5ebbb',4,'7eb98de9-2987-11ef-8fb0-da2b4bf5ebbb','MAXILLAIRE','SCAN',1,'NONE',1,1,0,'','38094558-549f-40bd-9a81-6301be7324e4','38094558-549f-40bd-9a81-6301be7324e4','2024-06-13 15:22:07.470',NULL,'2024-06-13 15:22:55.298','2024-06-13 13:22:55.298',NULL),('ef3ba736-2337-11ef-8f93-d92a45da78c9',2,'b19c6074-2336-11ef-8f93-d92a45da78c9','MAXILLAIRE','SCAN',1,'NONE',1,1,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-05 14:34:21.000',NULL,'2024-06-05 15:27:25.000','2024-06-05 13:27:28.000','2024-06-05 15:27:28.000'),('f364e666-2958-11ef-9161-de41a781935b',2,'f1fe313e-2958-11ef-9161-de41a781935b','MAXILLAIRE','SCAN',1,'NONE',1,1,0,'','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','4a2ae9c9-fa00-41ed-a598-31b94c8b8955','2024-06-13 09:45:48.911',NULL,'2024-06-13 09:48:34.593','2024-06-13 07:48:34.593',NULL);
/*!40000 ALTER TABLE `Scan` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ScanFile`
--

DROP TABLE IF EXISTS `ScanFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ScanFile` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `scanId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('MODEL','SNAPSHOT','SCREENSHOT','LIFI','LIFIMETA','METERING','SEGMENTED') NOT NULL,
  PRIMARY KEY (`scanId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `ScanFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `ScanFile_ibfk_2` FOREIGN KEY (`scanId`) REFERENCES `Scan` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ScanFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ScanFile`
--

LOCK TABLES `ScanFile` WRITE;
/*!40000 ALTER TABLE `ScanFile` DISABLE KEYS */;
INSERT INTO `ScanFile` VALUES (2,'09768650-2267-11ef-8f1f-d8242c71b430','1b63f36c-2269-11ef-8f1f-d8242c71b430','LIFI'),(2,'09768650-2267-11ef-8f1f-d8242c71b430','1b63f931-2269-11ef-8f1f-d8242c71b430','LIFIMETA'),(2,'09768650-2267-11ef-8f1f-d8242c71b430','645d823e-2269-11ef-8f1f-d8242c71b430','LIFI'),(2,'09768650-2267-11ef-8f1f-d8242c71b430','645d9879-2269-11ef-8f1f-d8242c71b430','LIFIMETA'),(2,'09768650-2267-11ef-8f1f-d8242c71b430','7930bc95-2267-11ef-8f1f-d8242c71b430','MODEL'),(2,'09768650-2267-11ef-8f1f-d8242c71b430','7930db48-2267-11ef-8f1f-d8242c71b430','SNAPSHOT'),(2,'09768650-2267-11ef-8f1f-d8242c71b430','80ff7e2f-2269-11ef-8f1f-d8242c71b430','LIFI'),(2,'09768650-2267-11ef-8f1f-d8242c71b430','80ff8276-2269-11ef-8f1f-d8242c71b430','LIFIMETA'),(2,'0ab76b82-2343-11ef-8f93-d92a45da78c9','29a36c35-2343-11ef-8f93-d92a45da78c9','MODEL'),(2,'0ab76b82-2343-11ef-8f93-d92a45da78c9','29a3891a-2343-11ef-8f93-d92a45da78c9','SNAPSHOT'),(2,'0ab76b82-2343-11ef-8f93-d92a45da78c9','4045a372-2343-11ef-8f93-d92a45da78c9','METERING'),(2,'0cfe6c2e-2268-11ef-8f1f-d8242c71b430','2aaec82c-2268-11ef-8f1f-d8242c71b430','MODEL'),(2,'0cfe6c2e-2268-11ef-8f1f-d8242c71b430','2aaed5db-2268-11ef-8f1f-d8242c71b430','SNAPSHOT'),(4,'129f0828-2973-11ef-9161-de41a781935b','1f8131a8-2973-11ef-9161-de41a781935b','MODEL'),(4,'129f0828-2973-11ef-9161-de41a781935b','1f814538-2973-11ef-9161-de41a781935b','SNAPSHOT'),(4,'129f0828-2973-11ef-9161-de41a781935b','3b43a93e-2973-11ef-9161-de41a781935b','MODEL'),(4,'129f0828-2973-11ef-9161-de41a781935b','40985456-2973-11ef-9161-de41a781935b','MODEL'),(4,'129f0828-2973-11ef-9161-de41a781935b','4731d177-2974-11ef-9161-de41a781935b','SCREENSHOT'),(4,'129f0828-2973-11ef-9161-de41a781935b','51fc9f7e-2974-11ef-9161-de41a781935b','SCREENSHOT'),(4,'129f0828-2973-11ef-9161-de41a781935b','58c2d450-2974-11ef-9161-de41a781935b','SCREENSHOT'),(4,'129f0828-2973-11ef-9161-de41a781935b','5d7d44b7-2974-11ef-9161-de41a781935b','METERING'),(2,'23e52d54-2338-11ef-8f93-d92a45da78c9','48ab0b8c-233a-11ef-8f93-d92a45da78c9','LIFI'),(2,'23e52d54-2338-11ef-8f93-d92a45da78c9','48ab1080-233a-11ef-8f93-d92a45da78c9','LIFIMETA'),(2,'23e52d54-2338-11ef-8f93-d92a45da78c9','4c944e2f-2338-11ef-8f93-d92a45da78c9','MODEL'),(2,'23e52d54-2338-11ef-8f93-d92a45da78c9','4c9462f1-2338-11ef-8f93-d92a45da78c9','SNAPSHOT'),(2,'23e52d54-2338-11ef-8f93-d92a45da78c9','51e7fbf0-233a-11ef-8f93-d92a45da78c9','LIFI'),(2,'23e52d54-2338-11ef-8f93-d92a45da78c9','51e81127-233a-11ef-8f93-d92a45da78c9','LIFIMETA'),(2,'23e52d54-2338-11ef-8f93-d92a45da78c9','84af3b89-233b-11ef-8f93-d92a45da78c9','SCREENSHOT'),(2,'23e52d54-2338-11ef-8f93-d92a45da78c9','9c695ea5-233b-11ef-8f93-d92a45da78c9','SEGMENTED'),(2,'23e52d54-2338-11ef-8f93-d92a45da78c9','a214ed06-233a-11ef-8f93-d92a45da78c9','MODEL'),(2,'23e52d54-2338-11ef-8f93-d92a45da78c9','b0cc95f2-233b-11ef-8f93-d92a45da78c9','SCREENSHOT'),(2,'23e52d54-2338-11ef-8f93-d92a45da78c9','b325bd9b-233b-11ef-8f93-d92a45da78c9','METERING'),(2,'23e52d54-2338-11ef-8f93-d92a45da78c9','bc2209ec-233a-11ef-8f93-d92a45da78c9','MODEL'),(2,'23e52d54-2338-11ef-8f93-d92a45da78c9','cb4731d4-233b-11ef-8f93-d92a45da78c9','MODEL'),(2,'23e52d54-2338-11ef-8f93-d92a45da78c9','d6119db2-233b-11ef-8f93-d92a45da78c9','MODEL'),(2,'24861dc8-226f-11ef-8f1f-d8242c71b430','58bcb05a-226f-11ef-8f1f-d8242c71b430','MODEL'),(2,'24861dc8-226f-11ef-8f1f-d8242c71b430','58bcc45d-226f-11ef-8f1f-d8242c71b430','SNAPSHOT'),(4,'2b917de0-298e-11ef-8fb0-da2b4bf5ebbb','3976b785-298e-11ef-8fb0-da2b4bf5ebbb','MODEL'),(4,'2b917de0-298e-11ef-8fb0-da2b4bf5ebbb','3976c5ed-298e-11ef-8fb0-da2b4bf5ebbb','SNAPSHOT'),(4,'2b917de0-298e-11ef-8fb0-da2b4bf5ebbb','58941659-298e-11ef-8fb0-da2b4bf5ebbb','MODEL'),(4,'2b917de0-298e-11ef-8fb0-da2b4bf5ebbb','efefdbe8-298e-11ef-8fb0-da2b4bf5ebbb','MODEL'),(2,'2e146f3d-233a-11ef-8f93-d92a45da78c9','2e1492f1-233a-11ef-8f93-d92a45da78c9','MODEL'),(2,'2e146f3d-233a-11ef-8f93-d92a45da78c9','2e19276e-233a-11ef-8f93-d92a45da78c9','SNAPSHOT'),(2,'2e146f3d-233a-11ef-8f93-d92a45da78c9','2e1935ab-233a-11ef-8f93-d92a45da78c9','LIFI'),(2,'2e146f3d-233a-11ef-8f93-d92a45da78c9','2e194339-233a-11ef-8f93-d92a45da78c9','LIFIMETA'),(2,'2e146f3d-233a-11ef-8f93-d92a45da78c9','3be2f05d-233b-11ef-8f93-d92a45da78c9','MODEL'),(2,'2e146f3d-233a-11ef-8f93-d92a45da78c9','3be30703-233b-11ef-8f93-d92a45da78c9','SNAPSHOT'),(2,'2e146f3d-233a-11ef-8f93-d92a45da78c9','3ddcba60-233a-11ef-8f93-d92a45da78c9','MODEL'),(2,'2e146f3d-233a-11ef-8f93-d92a45da78c9','4282f5e8-233a-11ef-8f93-d92a45da78c9','MODEL'),(2,'2e146f3d-233a-11ef-8f93-d92a45da78c9','5fe3c6fc-233b-11ef-8f93-d92a45da78c9','MODEL'),(2,'2e146f3d-233a-11ef-8f93-d92a45da78c9','719a9003-233b-11ef-8f93-d92a45da78c9','LIFI'),(2,'2e146f3d-233a-11ef-8f93-d92a45da78c9','719a949c-233b-11ef-8f93-d92a45da78c9','LIFIMETA'),(2,'2e146f3d-233a-11ef-8f93-d92a45da78c9','fe51cb41-233a-11ef-8f93-d92a45da78c9','MODEL'),(2,'2e146f3d-233a-11ef-8f93-d92a45da78c9','fe51ed64-233a-11ef-8f93-d92a45da78c9','SNAPSHOT'),(2,'37ccba29-225b-11ef-8f1f-d8242c71b430','6782502c-225b-11ef-8f1f-d8242c71b430','MODEL'),(2,'37ccba29-225b-11ef-8f1f-d8242c71b430','67825ce8-225b-11ef-8f1f-d8242c71b430','SNAPSHOT'),(2,'40c1fc5f-2336-11ef-8f93-d92a45da78c9','638a6e9c-2336-11ef-8f93-d92a45da78c9','MODEL'),(2,'40c1fc5f-2336-11ef-8f93-d92a45da78c9','638a8550-2336-11ef-8f93-d92a45da78c9','SNAPSHOT'),(4,'4cc68cd8-2962-11ef-9161-de41a781935b','026ee82c-2964-11ef-9161-de41a781935b','MODEL'),(4,'4cc68cd8-2962-11ef-9161-de41a781935b','07bca4f6-2969-11ef-9161-de41a781935b','MODEL'),(4,'4cc68cd8-2962-11ef-9161-de41a781935b','07bcc6dd-2969-11ef-9161-de41a781935b','SNAPSHOT'),(4,'4cc68cd8-2962-11ef-9161-de41a781935b','233f92af-2969-11ef-9161-de41a781935b','MODEL'),(4,'4cc68cd8-2962-11ef-9161-de41a781935b','30880f4c-2969-11ef-9161-de41a781935b','MODEL'),(4,'4cc68cd8-2962-11ef-9161-de41a781935b','4fb005bd-296d-11ef-9161-de41a781935b','SEGMENTED'),(4,'4cc68cd8-2962-11ef-9161-de41a781935b','5d854a08-2973-11ef-9161-de41a781935b','MODEL'),(4,'4cc68cd8-2962-11ef-9161-de41a781935b','5f27c5df-296d-11ef-9161-de41a781935b','SEGMENTED'),(4,'4cc68cd8-2962-11ef-9161-de41a781935b','809c945c-2962-11ef-9161-de41a781935b','MODEL'),(4,'4cc68cd8-2962-11ef-9161-de41a781935b','809cb098-2962-11ef-9161-de41a781935b','SNAPSHOT'),(4,'4cc68cd8-2962-11ef-9161-de41a781935b','d00dd657-2977-11ef-9161-de41a781935b','MODEL'),(4,'4cc68cd8-2962-11ef-9161-de41a781935b','da7b1998-2973-11ef-9161-de41a781935b','MODEL'),(4,'4cc68cd8-2962-11ef-9161-de41a781935b','ecbfd534-2968-11ef-9161-de41a781935b','SEGMENTED'),(4,'4cc68cd8-2962-11ef-9161-de41a781935b','f6358ad7-2968-11ef-9161-de41a781935b','MODEL'),(4,'4cc68cd8-2962-11ef-9161-de41a781935b','fdbb89ae-2963-11ef-9161-de41a781935b','MODEL'),(4,'4eb3e0e7-2964-11ef-9161-de41a781935b','e5f15957-2964-11ef-9161-de41a781935b','MODEL'),(4,'4eb3e0e7-2964-11ef-9161-de41a781935b','e5f16789-2964-11ef-9161-de41a781935b','SNAPSHOT'),(2,'596c4e98-233c-11ef-8f93-d92a45da78c9','596c715a-233c-11ef-8f93-d92a45da78c9','SNAPSHOT'),(2,'596c4e98-233c-11ef-8f93-d92a45da78c9','596c8055-233c-11ef-8f93-d92a45da78c9','LIFI'),(2,'596c4e98-233c-11ef-8f93-d92a45da78c9','596c8c7f-233c-11ef-8f93-d92a45da78c9','LIFIMETA'),(2,'596c4e98-233c-11ef-8f93-d92a45da78c9','596c981e-233c-11ef-8f93-d92a45da78c9','SEGMENTED'),(2,'596c4e98-233c-11ef-8f93-d92a45da78c9','596cc291-233c-11ef-8f93-d92a45da78c9','MODEL'),(2,'5982089a-2268-11ef-8f1f-d8242c71b430','9d0b79b6-2268-11ef-8f1f-d8242c71b430','MODEL'),(2,'5982089a-2268-11ef-8f1f-d8242c71b430','9d0cb7bd-2268-11ef-8f1f-d8242c71b430','SNAPSHOT'),(4,'5a97f8c0-2967-11ef-9161-de41a781935b','5a982332-2967-11ef-9161-de41a781935b','MODEL'),(4,'5a97f8c0-2967-11ef-9161-de41a781935b','5a9c97f2-2967-11ef-9161-de41a781935b','SNAPSHOT'),(2,'6d6c8ddd-225b-11ef-8f1f-d8242c71b430','851d6596-225b-11ef-8f1f-d8242c71b430','MODEL'),(2,'6d6c8ddd-225b-11ef-8f1f-d8242c71b430','851d78b9-225b-11ef-8f1f-d8242c71b430','SNAPSHOT'),(4,'7b02accf-2967-11ef-9161-de41a781935b','9b38ec14-2967-11ef-9161-de41a781935b','MODEL'),(4,'7b02accf-2967-11ef-9161-de41a781935b','9b38fa58-2967-11ef-9161-de41a781935b','SNAPSHOT'),(2,'8e15b6ed-225b-11ef-8f1f-d8242c71b430','b737ce47-225b-11ef-8f1f-d8242c71b430','MODEL'),(2,'8e15b6ed-225b-11ef-8f1f-d8242c71b430','b737dc71-225b-11ef-8f1f-d8242c71b430','SNAPSHOT'),(4,'9398352e-2963-11ef-9161-de41a781935b','e94ccc3a-2963-11ef-9161-de41a781935b','MODEL'),(4,'9398352e-2963-11ef-9161-de41a781935b','e94cda01-2963-11ef-9161-de41a781935b','SNAPSHOT'),(2,'93bdd6ef-233c-11ef-8f93-d92a45da78c9','03eb2fd7-233f-11ef-8f93-d92a45da78c9','MODEL'),(2,'93bdd6ef-233c-11ef-8f93-d92a45da78c9','310f2987-233f-11ef-8f93-d92a45da78c9','MODEL'),(2,'93bdd6ef-233c-11ef-8f93-d92a45da78c9','acfa30bf-233c-11ef-8f93-d92a45da78c9','MODEL'),(2,'93bdd6ef-233c-11ef-8f93-d92a45da78c9','acfa42a4-233c-11ef-8f93-d92a45da78c9','SNAPSHOT'),(2,'9b60e5c1-233e-11ef-8f93-d92a45da78c9','9b610e0d-233e-11ef-8f93-d92a45da78c9','MODEL'),(2,'9b60e5c1-233e-11ef-8f93-d92a45da78c9','9b65adc6-233e-11ef-8f93-d92a45da78c9','SNAPSHOT'),(2,'a7dd3d5c-2338-11ef-8f93-d92a45da78c9','c8ebad34-2338-11ef-8f93-d92a45da78c9','MODEL'),(2,'a7dd3d5c-2338-11ef-8f93-d92a45da78c9','c8ebc1b6-2338-11ef-8f93-d92a45da78c9','SNAPSHOT'),(2,'aeb8dd17-233e-11ef-8f93-d92a45da78c9','d9c2bf02-233e-11ef-8f93-d92a45da78c9','MODEL'),(2,'aeb8dd17-233e-11ef-8f93-d92a45da78c9','d9c2d5d6-233e-11ef-8f93-d92a45da78c9','SNAPSHOT'),(2,'af14b2d9-233c-11ef-8f93-d92a45da78c9','c4963479-233c-11ef-8f93-d92a45da78c9','MODEL'),(2,'af14b2d9-233c-11ef-8f93-d92a45da78c9','c49644bc-233c-11ef-8f93-d92a45da78c9','SNAPSHOT'),(2,'b4da925f-2267-11ef-8f1f-d8242c71b430','ed04dd0f-2267-11ef-8f1f-d8242c71b430','MODEL'),(2,'b4da925f-2267-11ef-8f1f-d8242c71b430','ed04eb07-2267-11ef-8f1f-d8242c71b430','SNAPSHOT'),(2,'b70f8ae5-2343-11ef-8f93-d92a45da78c9','c1ed2983-2343-11ef-8f93-d92a45da78c9','MODEL'),(2,'b70f8ae5-2343-11ef-8f93-d92a45da78c9','c1ed3973-2343-11ef-8f93-d92a45da78c9','SNAPSHOT'),(4,'b926a968-2962-11ef-9161-de41a781935b','36992ba9-2974-11ef-9161-de41a781935b','SCREENSHOT'),(4,'b926a968-2962-11ef-9161-de41a781935b','3d610748-2974-11ef-9161-de41a781935b','METERING'),(4,'b926a968-2962-11ef-9161-de41a781935b','497c2388-2973-11ef-9161-de41a781935b','MODEL'),(4,'b926a968-2962-11ef-9161-de41a781935b','4e2848b7-2973-11ef-9161-de41a781935b','MODEL'),(4,'b926a968-2962-11ef-9161-de41a781935b','5786e230-2973-11ef-9161-de41a781935b','MODEL'),(4,'b926a968-2962-11ef-9161-de41a781935b','586cd220-298c-11ef-8fb0-da2b4bf5ebbb','MODEL'),(4,'b926a968-2962-11ef-9161-de41a781935b','586cf30b-298c-11ef-8fb0-da2b4bf5ebbb','SNAPSHOT'),(4,'b926a968-2962-11ef-9161-de41a781935b','676c8a9b-298c-11ef-8fb0-da2b4bf5ebbb','MODEL'),(4,'b926a968-2962-11ef-9161-de41a781935b','6b271fd8-298c-11ef-8fb0-da2b4bf5ebbb','MODEL'),(4,'b926a968-2962-11ef-9161-de41a781935b','b48a5fcd-2973-11ef-9161-de41a781935b','MODEL'),(4,'b926a968-2962-11ef-9161-de41a781935b','be85cce9-2973-11ef-9161-de41a781935b','MODEL'),(4,'b926a968-2962-11ef-9161-de41a781935b','d9a1cf93-2962-11ef-9161-de41a781935b','MODEL'),(4,'b926a968-2962-11ef-9161-de41a781935b','d9a1dff9-2962-11ef-9161-de41a781935b','SNAPSHOT'),(2,'b9e0ca90-2268-11ef-8f1f-d8242c71b430','ef61f104-2268-11ef-8f1f-d8242c71b430','MODEL'),(2,'b9e0ca90-2268-11ef-8f1f-d8242c71b430','ef620854-2268-11ef-8f1f-d8242c71b430','SNAPSHOT'),(2,'cf823728-227d-11ef-8f8c-d92a43d45d56','f0c1893d-227d-11ef-8f8c-d92a43d45d56','MODEL'),(2,'cf823728-227d-11ef-8f8c-d92a43d45d56','f0c1a284-227d-11ef-8f8c-d92a43d45d56','SNAPSHOT'),(2,'d286674d-233c-11ef-8f93-d92a45da78c9','efa48c98-233c-11ef-8f93-d92a45da78c9','MODEL'),(2,'d286674d-233c-11ef-8f93-d92a45da78c9','efa49ef7-233c-11ef-8f93-d92a45da78c9','SNAPSHOT'),(2,'e52279ce-225a-11ef-8f1f-d8242c71b430','326e28f0-225b-11ef-8f1f-d8242c71b430','MODEL'),(2,'e52279ce-225a-11ef-8f1f-d8242c71b430','326e3f34-225b-11ef-8f1f-d8242c71b430','SNAPSHOT'),(2,'e52279ce-225a-11ef-8f1f-d8242c71b430','9484c123-225d-11ef-8f1f-d8242c71b430','SCREENSHOT'),(2,'e52279ce-225a-11ef-8f1f-d8242c71b430','a9521e0f-225d-11ef-8f1f-d8242c71b430','METERING'),(3,'ea48ab1e-2897-11ef-8f6f-d9283dbaec71','1257d8b3-2898-11ef-8f6f-d9283dbaec71','MODEL'),(3,'ea48ab1e-2897-11ef-8f6f-d9283dbaec71','1257f100-2898-11ef-8f6f-d9283dbaec71','SNAPSHOT'),(2,'ed7a17d3-233e-11ef-8f93-d92a45da78c9','ed7a2fab-233e-11ef-8f93-d92a45da78c9','MODEL'),(2,'ed7a17d3-233e-11ef-8f93-d92a45da78c9','ed7f61d5-233e-11ef-8f93-d92a45da78c9','SNAPSHOT'),(4,'eec0c27d-2987-11ef-8fb0-da2b4bf5ebbb','0b1271da-2988-11ef-8fb0-da2b4bf5ebbb','MODEL'),(4,'eec0c27d-2987-11ef-8fb0-da2b4bf5ebbb','0b128b86-2988-11ef-8fb0-da2b4bf5ebbb','SNAPSHOT'),(2,'ef3ba736-2337-11ef-8f93-d92a45da78c9','10a0d811-2339-11ef-8f93-d92a45da78c9','LIFI'),(2,'ef3ba736-2337-11ef-8f93-d92a45da78c9','10a0db7f-2339-11ef-8f93-d92a45da78c9','LIFIMETA'),(2,'ef3ba736-2337-11ef-8f93-d92a45da78c9','1ad1adb2-233a-11ef-8f93-d92a45da78c9','SCREENSHOT'),(2,'ef3ba736-2337-11ef-8f93-d92a45da78c9','1ffb9e9c-2338-11ef-8f93-d92a45da78c9','MODEL'),(2,'ef3ba736-2337-11ef-8f93-d92a45da78c9','1ffbaca6-2338-11ef-8f93-d92a45da78c9','SNAPSHOT'),(2,'ef3ba736-2337-11ef-8f93-d92a45da78c9','4df7ad71-233f-11ef-8f93-d92a45da78c9','MODEL'),(2,'ef3ba736-2337-11ef-8f93-d92a45da78c9','59191380-233f-11ef-8f93-d92a45da78c9','MODEL'),(2,'ef3ba736-2337-11ef-8f93-d92a45da78c9','7228f8bd-2339-11ef-8f93-d92a45da78c9','METERING'),(2,'f364e666-2958-11ef-9161-de41a781935b','5600d63e-2959-11ef-9161-de41a781935b','MODEL'),(2,'f364e666-2958-11ef-9161-de41a781935b','5600eecc-2959-11ef-9161-de41a781935b','SNAPSHOT');
/*!40000 ALTER TABLE `ScanFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SentAttachment`
--

DROP TABLE IF EXISTS `SentAttachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SentAttachment` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `sentMessageId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  PRIMARY KEY (`sentMessageId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `SentAttachment_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `SentAttachment_ibfk_2` FOREIGN KEY (`sentMessageId`) REFERENCES `SentMessage` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `SentAttachment_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SentAttachment`
--

LOCK TABLES `SentAttachment` WRITE;
/*!40000 ALTER TABLE `SentAttachment` DISABLE KEYS */;
INSERT INTO `SentAttachment` VALUES (2,'0874bbc1-2403-11ef-8dde-d415e84cc4f5','080061b0-2403-11ef-8dde-d415e84cc4f5'),(2,'0874bbc1-2403-11ef-8dde-d415e84cc4f5','f51d71ce-227c-11ef-8d76-d310d2ec2c14'),(2,'0874bbc1-2403-11ef-8dde-d415e84cc4f5','f51d8554-227c-11ef-8d76-d310d2ec2c14'),(2,'0d22759d-225e-11ef-8f1f-d8242c71b430','9484c123-225d-11ef-8f1f-d8242c71b430'),(2,'0f3e4980-225d-11ef-8f1f-d8242c71b430','0ed5b8be-225d-11ef-8f1f-d8242c71b430'),(2,'0f3e4980-225d-11ef-8f1f-d8242c71b430','326e28f0-225b-11ef-8f1f-d8242c71b430'),(2,'0f3e4980-225d-11ef-8f1f-d8242c71b430','326e3f34-225b-11ef-8f1f-d8242c71b430'),(2,'0f3e4980-225d-11ef-8f1f-d8242c71b430','6782502c-225b-11ef-8f1f-d8242c71b430'),(2,'0f3e4980-225d-11ef-8f1f-d8242c71b430','67825ce8-225b-11ef-8f1f-d8242c71b430'),(2,'0f3e4980-225d-11ef-8f1f-d8242c71b430','e000eb20-225b-11ef-8f1f-d8242c71b430'),(2,'0f3e4980-225d-11ef-8f1f-d8242c71b430','e01bae07-225b-11ef-8f1f-d8242c71b430'),(2,'0f3e4980-225d-11ef-8f1f-d8242c71b430','e091c2ff-225b-11ef-8f1f-d8242c71b430'),(2,'2d654e78-2272-11ef-8d76-d310d2ec2c14','2cf3311a-2272-11ef-8d76-d310d2ec2c14'),(2,'2d654e78-2272-11ef-8d76-d310d2ec2c14','fc8f1969-2271-11ef-8d76-d310d2ec2c14'),(2,'2d654e78-2272-11ef-8d76-d310d2ec2c14','fc8f31e9-2271-11ef-8d76-d310d2ec2c14'),(2,'30f0f8e5-2279-11ef-8d76-d310d2ec2c14','1c9626b7-2279-11ef-8d76-d310d2ec2c14'),(2,'30f0f8e5-2279-11ef-8d76-d310d2ec2c14','275970f2-2279-11ef-8d76-d310d2ec2c14'),(2,'30f0f8e5-2279-11ef-8d76-d310d2ec2c14','307ab64c-2279-11ef-8d76-d310d2ec2c14'),(2,'30f0f8e5-2279-11ef-8d76-d310d2ec2c14','3e22c831-2274-11ef-8d76-d310d2ec2c14'),(2,'30f0f8e5-2279-11ef-8d76-d310d2ec2c14','5bc001f1-2278-11ef-8d76-d310d2ec2c14'),(2,'30f0f8e5-2279-11ef-8d76-d310d2ec2c14','613c6795-2278-11ef-8d76-d310d2ec2c14'),(2,'30f0f8e5-2279-11ef-8d76-d310d2ec2c14','8c08eecf-2278-11ef-8d76-d310d2ec2c14'),(2,'30f0f8e5-2279-11ef-8d76-d310d2ec2c14','9005271a-2273-11ef-8d76-d310d2ec2c14'),(2,'30f0f8e5-2279-11ef-8d76-d310d2ec2c14','90053a20-2273-11ef-8d76-d310d2ec2c14'),(2,'30f0f8e5-2279-11ef-8d76-d310d2ec2c14','c52f1c4e-2278-11ef-8d76-d310d2ec2c14'),(2,'30f0f8e5-2279-11ef-8d76-d310d2ec2c14','de217b4c-2278-11ef-8d76-d310d2ec2c14'),(2,'30f0f8e5-2279-11ef-8d76-d310d2ec2c14','e59826d2-2278-11ef-8d76-d310d2ec2c14'),(2,'550f3fc1-226b-11ef-8f1f-d8242c71b430','54a67fcd-226b-11ef-8f1f-d8242c71b430'),(2,'550f3fc1-226b-11ef-8f1f-d8242c71b430','6461ca85-2269-11ef-8f1f-d8242c71b430'),(2,'550f3fc1-226b-11ef-8f1f-d8242c71b430','6461d309-2269-11ef-8f1f-d8242c71b430'),(2,'550f3fc1-226b-11ef-8f1f-d8242c71b430','8103b4c6-2269-11ef-8f1f-d8242c71b430'),(2,'550f3fc1-226b-11ef-8f1f-d8242c71b430','8103b848-2269-11ef-8f1f-d8242c71b430'),(2,'550f3fc1-226b-11ef-8f1f-d8242c71b430','9e41d416-2269-11ef-8f1f-d8242c71b430'),(2,'550f3fc1-226b-11ef-8f1f-d8242c71b430','f3576589-2268-11ef-8f1f-d8242c71b430'),(2,'550f3fc1-226b-11ef-8f1f-d8242c71b430','f4024e3a-2268-11ef-8f1f-d8242c71b430'),(2,'673530bc-2272-11ef-8d76-d310d2ec2c14','5bd68def-2272-11ef-8d76-d310d2ec2c14'),(2,'673530bc-2272-11ef-8d76-d310d2ec2c14','5bd6a4c3-2272-11ef-8d76-d310d2ec2c14'),(2,'673530bc-2272-11ef-8d76-d310d2ec2c14','66bc3d46-2272-11ef-8d76-d310d2ec2c14'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','10a0d811-2339-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','10a0db7f-2339-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','10a34539-2339-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','10a347ba-2339-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','1ad1adb2-233a-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','1ffbaca6-2338-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','3be30703-233b-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','4c9462f1-2338-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','51e7fbf0-233a-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','51e81127-233a-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','51ec0746-233a-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','51ec1340-233a-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','59191380-233f-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','596c715a-233c-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','596c8055-233c-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','596c8c7f-233c-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','596cc291-233c-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','5ac77cab-233a-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','5f8fef48-233c-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','5fc0481a-233c-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','5fc04dc7-233c-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','5fe3c6fc-233b-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','6d75c326-233f-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','719a9003-233b-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','719a949c-233b-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','71a237c5-233b-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','71a23b4a-233b-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','84af3b89-233b-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','b0cc95f2-233b-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','d6119db2-233b-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','fdd0378f-2338-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','fde62b96-2338-11ef-8f93-d92a45da78c9'),(2,'6de76022-233f-11ef-8f93-d92a45da78c9','fe5950b5-2338-11ef-8f93-d92a45da78c9'),(2,'75433112-226f-11ef-8f1f-d8242c71b430','58bcb05a-226f-11ef-8f1f-d8242c71b430'),(2,'75433112-226f-11ef-8f1f-d8242c71b430','58bcc45d-226f-11ef-8f1f-d8242c71b430'),(2,'75433112-226f-11ef-8f1f-d8242c71b430','74d6b1c3-226f-11ef-8f1f-d8242c71b430'),(2,'d61618a0-2279-11ef-8d76-d310d2ec2c14','ca114ae6-2279-11ef-8d76-d310d2ec2c14'),(2,'d61618a0-2279-11ef-8d76-d310d2ec2c14','ca116050-2279-11ef-8d76-d310d2ec2c14'),(2,'d61618a0-2279-11ef-8d76-d310d2ec2c14','d59e4f7d-2279-11ef-8d76-d310d2ec2c14'),(2,'ff68612f-227d-11ef-8f8c-d92a43d45d56','f0c1893d-227d-11ef-8f8c-d92a43d45d56'),(2,'ff68612f-227d-11ef-8f8c-d92a43d45d56','f0c1a284-227d-11ef-8f8c-d92a43d45d56'),(2,'ff68612f-227d-11ef-8f8c-d92a43d45d56','fefc53d6-227d-11ef-8f8c-d92a43d45d56'),(3,'33e44dc1-23e9-11ef-8dde-d415e84cc4f5','242c6766-23e9-11ef-8dde-d415e84cc4f5'),(3,'33e44dc1-23e9-11ef-8dde-d415e84cc4f5','242c7d2a-23e9-11ef-8dde-d415e84cc4f5'),(3,'33e44dc1-23e9-11ef-8dde-d415e84cc4f5','336ff6af-23e9-11ef-8dde-d415e84cc4f5'),(3,'9ac047ea-23eb-11ef-8dde-d415e84cc4f5','9a5291cb-23eb-11ef-8dde-d415e84cc4f5'),(3,'9ac047ea-23eb-11ef-8dde-d415e84cc4f5','d0ab5861-23e7-11ef-8dde-d415e84cc4f5'),(3,'9ac047ea-23eb-11ef-8dde-d415e84cc4f5','d0ab69d4-23e7-11ef-8dde-d415e84cc4f5'),(3,'fb69a8c0-23e7-11ef-8dde-d415e84cc4f5','d0ab5861-23e7-11ef-8dde-d415e84cc4f5'),(3,'fb69a8c0-23e7-11ef-8dde-d415e84cc4f5','d0ab69d4-23e7-11ef-8dde-d415e84cc4f5'),(3,'fb69a8c0-23e7-11ef-8dde-d415e84cc4f5','fafc415d-23e7-11ef-8dde-d415e84cc4f5');
/*!40000 ALTER TABLE `SentAttachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SentMessage`
--

DROP TABLE IF EXISTS `SentMessage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SentMessage` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `discussionId` varchar(36) NOT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `answeredId` varchar(36) DEFAULT NULL COMMENT 'SentMessage uuid or ReceivedMessage originMessageId',
  `body` text DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `discussionId` (`discussionId`,`ownerId`),
  CONSTRAINT `SentMessage_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `SentMessage_ibfk_2` FOREIGN KEY (`discussionId`, `ownerId`) REFERENCES `Discussion` (`uuid`, `ownerId`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SentMessage`
--

LOCK TABLES `SentMessage` WRITE;
/*!40000 ALTER TABLE `SentMessage` DISABLE KEYS */;
INSERT INTO `SentMessage` VALUES ('0874bbc1-2403-11ef-8dde-d415e84cc4f5',2,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','Commande 3.1 [pc2]',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 3.1 [pc2]\",\"date\":\"2024-06-07T00:00:00\",\"orderUpdateTime\":\"2024-06-06T14:48:11\",\"orderId\":\"da3bcb3f-227c-11ef-8d76-d310d2ec2c14\"}','2024-06-06 14:48:11.000',NULL,'2024-06-06 14:48:11.000','2024-06-07 10:15:21.000','2024-06-07 12:15:21.000'),('0d22759d-225e-11ef-8f1f-d8242c71b430',2,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','Commande 1.1',NULL,'envoi d\'une capture supp','2024-06-04 12:34:41.000',NULL,'2024-06-04 12:34:41.000','2024-06-04 10:34:42.000','2024-06-04 12:34:42.000'),('0eb44d73-23ea-11ef-8f8c-d92a43d45e5a',2,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','Commande 2.2 [pc1]',NULL,'bien receptionné sur ihm env1 mais obligation de valider la cmde via le web. réponse faite via le filtre de discussion activé','2024-06-06 11:49:24.000',NULL,'2024-06-06 11:49:24.000','2024-06-06 09:49:27.000','2024-06-06 11:49:27.000'),('0f3e4980-225d-11ef-8f1f-d8242c71b430',2,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','Commande 1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.1\",\"date\":\"2024-06-05T00:00:00\",\"orderUpdateTime\":\"2024-06-04T12:27:35\",\"orderId\":\"e3879e0c-225a-11ef-8f1f-d8242c71b430\"}','2024-06-04 12:27:35.000',NULL,'2024-06-04 12:27:35.000','2024-06-04 10:27:41.000','2024-06-04 12:27:41.000'),('10351862-fb40-4aa9-a4ab-7afe4dba87b9',3,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','Commande 1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"edited\",\"title\":\"Commande 1.1\",\"date\":\"2024-06-06T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-04T12:29:24+02:00\",\"orderId\":\"e3879e0c-225a-11ef-8f1f-d8242c71b430\"}','2024-06-04 12:29:24.000',NULL,'2024-06-04 12:29:24.000','2024-06-04 10:29:25.000','2024-06-04 12:29:25.000'),('2192fe1a-0490-4bd9-8f2d-363155abc9a2',3,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','Réponse depuis le web',NULL,'bla bla via tchat web de la cmde 2.3','2024-06-06 14:23:36.000',NULL,'2024-06-06 14:23:36.000','2024-06-06 12:23:37.000','2024-06-06 14:23:37.000'),('2d654e78-2272-11ef-8d76-d310d2ec2c14',2,'550eb27a-226b-11ef-8f1f-d8242c71b430','Commande 2.1 [pc2]',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 2.1 [pc2]\",\"date\":\"2024-06-05T00:00:00\",\"orderUpdateTime\":\"2024-06-04T14:58:45\",\"orderId\":\"afad1449-2271-11ef-8d76-d310d2ec2c14\"}','2024-06-04 14:58:45.000',NULL,'2024-06-04 14:58:45.000','2024-06-04 12:58:47.000','2024-06-04 14:58:47.000'),('2f604f05-d11c-43d9-bdf9-d43e0306dfda',2,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','Commande 1.1',NULL,'envoi d\'un message via web (env1.ci...)','2024-06-06 11:09:19.000',NULL,'2024-06-06 11:09:19.000','2024-06-06 09:09:22.000','2024-06-06 11:09:22.000'),('30f0f8e5-2279-11ef-8d76-d310d2ec2c14',2,'550eb27a-226b-11ef-8f1f-d8242c71b430','Commande 1.2 [pc2]',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.2 [pc2]\",\"date\":\"2024-06-05T00:00:00\",\"orderUpdateTime\":\"2024-06-04T15:48:57\",\"orderId\":\"f26746c9-2272-11ef-8d76-d310d2ec2c14\"}','2024-06-04 15:48:57.000',NULL,'2024-06-04 15:48:57.000','2024-06-04 13:48:59.000','2024-06-04 15:48:59.000'),('33e44dc1-23e9-11ef-8dde-d415e84cc4f5',3,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','Commande 2.2 [pc1]',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 2.2 [pc1]\",\"date\":\"2024-06-07T00:00:00\",\"orderUpdateTime\":\"2024-06-06T11:43:17\",\"orderId\":\"0bd68b18-23e9-11ef-8dde-d415e84cc4f5\"}','2024-06-06 11:43:17.000',NULL,'2024-06-06 11:43:17.000','2024-06-06 09:47:52.000','2024-06-06 11:47:52.000'),('4c1489bb-54c8-4aa3-8017-d140fe974c2f',2,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','Commande 1.1',NULL,'bla bla','2024-06-06 12:01:39.000',NULL,'2024-06-06 12:01:39.000','2024-06-06 10:01:41.000','2024-06-06 12:01:41.000'),('4db93275-aa1c-442f-b2b5-af6c4514bd24',2,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','Commande 1.1',NULL,'test envoi de la page discussion sur le web','2024-06-06 11:57:21.000',NULL,'2024-06-06 11:57:21.000','2024-06-06 09:57:25.000','2024-06-06 11:57:25.000'),('550f3fc1-226b-11ef-8f1f-d8242c71b430',2,'550eb27a-226b-11ef-8f1f-d8242c71b430','Commande 1.2',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.2\",\"date\":\"2024-06-05T00:00:00\",\"orderUpdateTime\":\"2024-06-04T14:09:45\",\"orderId\":\"7585401e-2266-11ef-8f1f-d8242c71b430\"}','2024-06-04 14:09:45.000',NULL,'2024-06-04 14:09:45.000','2024-06-04 12:10:11.000','2024-06-04 14:10:11.000'),('56f0c51f-23ed-11ef-8dde-d415e84cc4f5',3,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','Commande 2.3 [pc1]',NULL,'bla bla\n','2024-06-06 12:12:54.000',NULL,'2024-06-06 12:12:54.000','2024-06-06 10:16:25.000','2024-06-06 12:16:25.000'),('5701b18b-225e-11ef-8d76-d310d2ec2c14',3,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','5701b18b-225e-11ef-8d76-d310d2ec2c14',NULL,'bla bla bla','2024-06-04 12:36:45.000',NULL,'2024-06-04 12:36:45.000','2024-06-04 10:36:47.000','2024-06-04 12:36:47.000'),('59cfafae-e9ce-4a51-be20-09e9860da4b4',3,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','Réponse depuis le web',NULL,'bla bla via page discussion du web','2024-06-06 14:22:35.000',NULL,'2024-06-06 14:22:35.000','2024-06-06 12:22:37.000','2024-06-06 14:22:37.000'),('5c02d3d5-23e4-11ef-8dde-d415e84cc4f5',2,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','5c02d3d5-23e4-11ef-8dde-d415e84cc4f5',NULL,'envoi d\'un message via env2','2024-06-06 11:08:37.000',NULL,'2024-06-06 11:08:37.000','2024-06-06 09:08:38.000','2024-06-06 11:08:38.000'),('62d4940c-225e-11ef-8d76-d310d2ec2c14',3,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','Commande 1.1','0d22759d-225e-11ef-8f1f-d8242c71b430','bla bla bla','2024-06-04 12:37:05.000',NULL,'2024-06-04 12:37:05.000','2024-06-04 10:37:05.000','2024-06-04 12:37:05.000'),('673530bc-2272-11ef-8d76-d310d2ec2c14',2,'550eb27a-226b-11ef-8f1f-d8242c71b430','Commande 1.1 [pc2]',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.1 [pc2]\",\"date\":\"2024-06-05T00:00:00\",\"orderUpdateTime\":\"2024-06-04T15:00:22\",\"orderId\":\"62bf4a87-226c-11ef-8d76-d310d2ec2c14\"}','2024-06-04 15:00:22.000',NULL,'2024-06-04 15:00:22.000','2024-06-04 13:00:24.000','2024-06-04 15:00:24.000'),('6de76022-233f-11ef-8f93-d92a45da78c9',2,'550eb27a-226b-11ef-8f1f-d8242c71b430','Commande 1.5 [pc1]',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.5 [pc1]\",\"date\":\"2024-06-06T00:00:00\",\"orderUpdateTime\":\"2024-06-05T15:28:00\",\"orderId\":\"b19eef4f-2336-11ef-8f93-d92a45da78c9\"}','2024-06-05 15:28:00.000',NULL,'2024-06-05 15:28:00.000','2024-06-05 13:28:05.000','2024-06-05 15:28:05.000'),('75433112-226f-11ef-8f1f-d8242c71b430',2,'550eb27a-226b-11ef-8f1f-d8242c71b430','Commande 1.3 [pc1]',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.3 [pc1]\",\"date\":\"2024-06-05T00:00:00\",\"orderUpdateTime\":\"2024-06-04T14:39:17\",\"orderId\":\"f6d25816-226e-11ef-8f1f-d8242c71b430\"}','2024-06-04 14:39:17.000',NULL,'2024-06-04 14:39:17.000','2024-06-04 12:39:19.000','2024-06-04 14:39:19.000'),('79e4936c-226b-11ef-8f1f-d8242c71b430',4,'550eb27a-226b-11ef-8f1f-d8242c71b430','Commande 1.2',NULL,'demande de précision sur cmde1.2; blabla','2024-06-04 14:10:47.364',NULL,'2024-06-04 14:10:47.364','2024-06-04 12:10:47.364','2024-06-04 14:10:47.376'),('7c7133c4-869b-4ecf-be8c-a7ba25b96324',2,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','Commande 1.1',NULL,'API_META={\"type\":\"order\",\"key\":\"validated\",\"title\":\"Commande 1.1\",\"date\":\"2024-06-06T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-04T12:29:32+02:00\",\"orderId\":\"e3879e0c-225a-11ef-8f1f-d8242c71b430\"}','2024-06-04 12:29:32.000',NULL,'2024-06-04 12:29:32.000','2024-06-04 10:29:34.000','2024-06-04 12:29:34.000'),('96378603-23e4-11ef-8f8c-d92a43d45e5a',3,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','96378603-23e4-11ef-8f8c-d92a43d45e5a',NULL,'bla bla','2024-06-06 11:10:15.000',NULL,'2024-06-06 11:10:15.000','2024-06-06 09:24:48.000','2024-06-06 11:24:48.000'),('9ac047ea-23eb-11ef-8dde-d415e84cc4f5',3,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','Commande 2.3 [pc1]',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 2.3 [pc1]\",\"date\":\"2024-06-07T00:00:00\",\"orderUpdateTime\":\"2024-06-06T12:00:29\",\"orderId\":\"8d24e986-23eb-11ef-8dde-d415e84cc4f5\"}','2024-06-06 12:00:29.000',NULL,'2024-06-06 12:00:29.000','2024-06-06 10:01:33.000','2024-06-06 12:01:33.000'),('9e44f2e9-23e4-11ef-8f8c-d92a43d45e5a',3,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','Commande 1.1','2f604f05-d11c-43d9-bdf9-d43e0306dfda','bla bla','2024-06-06 11:10:28.000',NULL,'2024-06-06 11:10:28.000','2024-06-06 09:24:48.000','2024-06-06 11:24:48.000'),('b1d82b93-226b-11ef-8d76-d310d2ec2c14',2,'550eb27a-226b-11ef-8f1f-d8242c71b430','Commande 1.2','79e4936c-226b-11ef-8f1f-d8242c71b430','réponse faite d\'env2 avt recup des données','2024-06-04 14:12:21.000',NULL,'2024-06-04 14:12:21.000','2024-06-04 12:12:21.000','2024-06-04 14:12:21.000'),('d61618a0-2279-11ef-8d76-d310d2ec2c14',2,'550eb27a-226b-11ef-8f1f-d8242c71b430','Commande 1.3 [pc2]',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 1.3 [pc2]\",\"date\":\"2024-06-05T00:00:00\",\"orderUpdateTime\":\"2024-06-04T15:53:34\",\"orderId\":\"a4229655-2279-11ef-8d76-d310d2ec2c14\"}','2024-06-04 15:53:34.000',NULL,'2024-06-04 15:53:34.000','2024-06-04 13:53:36.000','2024-06-04 15:53:36.000'),('ddab8ff1-23e2-11ef-8f8c-d92a43d45e5a',3,'ddab36aa-23e2-11ef-8f8c-d92a43d45e5a','ddab8ff1-23e2-11ef-8f8c-d92a43d45e5a',NULL,'invitation envoyée sous env2, mail d\'invitation pour env2.ci.wow-scan.pro (et acceptée); ce message envoyée sous env1','2024-06-06 10:57:56.000',NULL,'2024-06-06 10:57:56.000','2024-06-06 08:58:06.000','2024-06-06 10:58:06.000'),('e03dc949-f924-4e48-a5fd-e8273bbf6e07',2,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','Commande 2.2',NULL,'API_META={\"type\":\"order\",\"key\":\"edited\",\"title\":\"Commande 2.2\",\"date\":\"2024-06-08T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-06T11:58:24+02:00\",\"orderId\":\"0bd68b18-23e9-11ef-8dde-d415e84cc4f5\"}','2024-06-06 11:58:24.000',NULL,'2024-06-06 11:58:24.000','2024-06-06 09:58:24.000','2024-06-06 11:58:24.000'),('ec59b1ff-79e7-49aa-9888-5b1e722d3d80',2,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','Commande 2.3',NULL,'API_META={\"type\":\"order\",\"key\":\"validated\",\"title\":\"Commande 2.3\",\"date\":\"2024-06-07T00:00:00+02:00\",\"orderUpdateTime\":\"2024-06-06T12:02:16+02:00\",\"orderId\":\"8d24e986-23eb-11ef-8dde-d415e84cc4f5\"}','2024-06-06 12:02:16.000',NULL,'2024-06-06 12:02:16.000','2024-06-06 10:02:17.000','2024-06-06 12:02:17.000'),('f352fb85-23e4-11ef-8f8c-d92a43d45e5a',3,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','f352fb85-23e4-11ef-8f8c-d92a43d45e5a',NULL,'test envoi texte sous discussion non filtrée','2024-06-06 11:12:51.000',NULL,'2024-06-06 11:12:51.000','2024-06-06 09:24:48.000','2024-06-06 11:24:48.000'),('fad71f64-8b16-4fc8-94d4-6ae6473112ab',2,'0f3dfe44-225d-11ef-8f1f-d8242c71b430','Commande 2.2 [pc1]',NULL,'réponse via web via le tchat de la cmde','2024-06-06 11:55:50.000',NULL,'2024-06-06 11:55:50.000','2024-06-06 09:56:28.000','2024-06-06 11:56:28.000'),('fb69a8c0-23e7-11ef-8dde-d415e84cc4f5',3,'ddab36aa-23e2-11ef-8f8c-d92a43d45e5a','Commande 2.1 [pc1]',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 2.1 [pc1]\",\"date\":\"2024-06-07T00:00:00\",\"orderUpdateTime\":\"2024-06-06T11:34:33\",\"orderId\":\"96b5001d-23e7-11ef-8dde-d415e84cc4f5\"}','2024-06-06 11:34:33.000',NULL,'2024-06-06 11:34:33.000','2024-06-06 09:34:37.000','2024-06-06 11:34:37.000'),('ff68612f-227d-11ef-8f8c-d92a43d45d56',2,'550eb27a-226b-11ef-8f1f-d8242c71b430','Commande 3.1 [pc1]',NULL,'API_META={\"type\":\"order\",\"key\":\"created\",\"title\":\"Commande 3.1 [pc1]\",\"date\":\"2024-06-05T00:00:00\",\"orderUpdateTime\":\"2024-06-04T16:23:22\",\"orderId\":\"cdf680d9-227d-11ef-8f8c-d92a43d45d56\"}','2024-06-04 16:23:22.000',NULL,'2024-06-04 16:23:22.000','2024-06-04 14:23:23.000','2024-06-04 16:23:23.000');
/*!40000 ALTER TABLE `SentMessage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SentOrderNotification`
--

DROP TABLE IF EXISTS `SentOrderNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SentOrderNotification` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `recipientId` varchar(36) DEFAULT NULL,
  `rescueData` text DEFAULT NULL,
  `deliveryDate` datetime(3) DEFAULT NULL,
  `event` enum('EDITED','VALIDATED','CANCELLED') NOT NULL DEFAULT 'EDITED',
  `unread` tinyint(1) NOT NULL DEFAULT 1,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `orderId` (`orderId`),
  KEY `recipientId` (`recipientId`),
  CONSTRAINT `SentOrderNotification_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `SentOrderNotification_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `ProstheticOrder` (`uuid`) ON UPDATE CASCADE,
  CONSTRAINT `SentOrderNotification_ibfk_3` FOREIGN KEY (`recipientId`) REFERENCES `Contact` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SentOrderNotification`
--

LOCK TABLES `SentOrderNotification` WRITE;
/*!40000 ALTER TABLE `SentOrderNotification` DISABLE KEYS */;
INSERT INTO `SentOrderNotification` VALUES ('604ca941-0b75-459c-9d11-b2d9326d5985',2,'e3879e0c-225a-11ef-8f1f-d8242c71b430','8fbd79fd-0e86-49b8-9558-3a507eb19750','{\"recipientDisplayName\":\"succursalle Salles d\'aude laboratoire scan4all\",\"patientDisplayID\":\"dc803a78-225a-11ef-8f1f-d8242c71b430\",\"orderTitle\":\"Commande 1.1\"}','2024-06-06 00:00:00.000','EDITED',1,'2024-06-04 12:29:24.000','2024-06-05 14:12:38.000','2024-06-05 12:12:38.000','2024-06-05 14:12:38.000'),('93403d38-96a1-492c-8d90-f1a35b4e9122',2,'cdf680d9-227d-11ef-8f8c-d92a43d45d56','4ed4ce00-4b30-4601-95bb-ede535f19c6b','{\"recipientDisplayName\":\"demo3 demo3env1\",\"patientDisplayID\":\"ce57500b-227c-11ef-8d76-d310d2ec2c14\",\"orderTitle\":\"Commande 3.1\"}','2024-06-05 00:00:00.000','VALIDATED',0,'2024-06-07 11:31:15.000',NULL,'2024-06-07 09:34:10.556','2024-06-07 11:34:10.566');
/*!40000 ALTER TABLE `SentOrderNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Session`
--

DROP TABLE IF EXISTS `Session`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Session` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL,
  `actId` varchar(36) NOT NULL,
  `displayId` mediumint(8) unsigned DEFAULT NULL,
  `pcId` mediumint(8) unsigned DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT 0,
  `comments` text DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `actId` (`actId`),
  CONSTRAINT `Session_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `Session_ibfk_2` FOREIGN KEY (`actId`) REFERENCES `Act` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Session`
--

LOCK TABLES `Session` WRITE;
/*!40000 ALTER TABLE `Session` DISABLE KEYS */;
INSERT INTO `Session` VALUES ('0223b2f4-2990-11ef-8fb0-da2b4bf5ebbb',4,'0222265c-2990-11ef-8fb0-da2b4bf5ebbb',1,1,0,'','2024-06-13 16:19:55.969','2024-06-13 16:20:10.484','2024-06-13 16:19:55.970','2024-06-13 14:20:10.484',NULL),('023e9bbb-2990-11ef-8fb0-da2b4bf5ebbb',4,'023e35f2-2990-11ef-8fb0-da2b4bf5ebbb',1,1,0,'','2024-06-13 16:19:56.146','2024-06-13 16:20:08.649','2024-06-13 16:19:56.147','2024-06-13 14:20:08.650',NULL),('09ebd700-2343-11ef-8f93-d92a45da78c9',2,'09ea2f4d-2343-11ef-8f93-d92a45da78c9',1,1,0,'','2024-06-05 15:53:50.000',NULL,'2024-06-05 15:53:50.801','2024-06-05 13:53:51.000','2024-06-05 15:53:51.000'),('11be1b4d-2973-11ef-9161-de41a781935b',4,'11bc8a6c-2973-11ef-9161-de41a781935b',1,1,0,'','2024-06-13 12:52:46.742',NULL,'2024-06-13 12:52:46.743','2024-06-13 10:52:46.743',NULL),('1d098b21-2990-11ef-8fb0-da2b4bf5ebbb',4,'1d080326-2990-11ef-8fb0-da2b4bf5ebbb',1,1,0,'','2024-06-13 16:20:41.096',NULL,'2024-06-13 16:20:41.098','2024-06-13 14:20:41.098',NULL),('1d31702e-2990-11ef-8fb0-da2b4bf5ebbb',4,'1d30966f-2990-11ef-8fb0-da2b4bf5ebbb',1,1,0,'','2024-06-13 16:20:41.358',NULL,'2024-06-13 16:20:41.359','2024-06-13 14:20:41.359',NULL),('3f113a7c-2336-11ef-8f93-d92a45da78c9',2,'3f0f8fd5-2336-11ef-8f93-d92a45da78c9',1,1,0,'','2024-06-05 14:22:16.000','2024-06-05 14:23:36.000','2024-06-05 14:22:16.508','2024-06-05 12:23:36.000','2024-06-05 14:23:36.000'),('43dfe39a-2962-11ef-9161-de41a781935b',4,'43de61ec-2962-11ef-9161-de41a781935b',1,1,0,'','2024-06-13 10:52:29.405',NULL,'2024-06-13 10:52:29.406','2024-06-13 08:52:29.406',NULL),('62500165-2990-11ef-8fb0-da2b4bf5ebbb',4,'624eaed5-2990-11ef-8fb0-da2b4bf5ebbb',1,1,0,'','2024-06-13 16:22:37.321','2024-06-13 16:22:50.596','2024-06-13 16:22:37.324','2024-06-13 14:22:50.596',NULL),('6fa1d062-2987-11ef-8fb0-da2b4bf5ebbb',4,'6fa078a0-2987-11ef-8fb0-da2b4bf5ebbb',1,1,0,'','2024-06-13 15:18:34.197','2024-06-13 16:20:17.366','2024-06-13 15:18:34.198','2024-06-13 14:20:17.366',NULL),('6fe380f2-2987-11ef-8fb0-da2b4bf5ebbb',4,'6fe32775-2987-11ef-8fb0-da2b4bf5ebbb',1,1,0,'','2024-06-13 15:18:34.627','2024-06-13 16:20:14.884','2024-06-13 15:18:34.629','2024-06-13 14:20:14.884',NULL),('75806ee1-2266-11ef-8f1f-d8242c71b430',2,'757ed4bc-2266-11ef-8f1f-d8242c71b430',1,1,0,'','2024-06-04 13:34:52.513',NULL,'2024-06-04 13:34:52.514','2024-06-04 11:34:52.514','2024-06-04 13:34:52.515'),('7eb98de9-2987-11ef-8fb0-da2b4bf5ebbb',4,'7eb8397d-2987-11ef-8fb0-da2b4bf5ebbb',1,1,0,'','2024-06-13 15:18:59.518',NULL,'2024-06-13 15:18:59.521','2024-06-13 13:18:59.521',NULL),('8c257d6d-233c-11ef-8f93-d92a45da78c9',2,'8c23d690-233c-11ef-8f93-d92a45da78c9',1,1,0,'','2024-06-05 15:07:22.000',NULL,'2024-06-05 15:07:22.805','2024-06-05 13:07:23.000','2024-06-05 15:07:23.000'),('ad33e149-298f-11ef-8fb0-da2b4bf5ebbb',4,'ad326548-298f-11ef-8fb0-da2b4bf5ebbb',1,1,0,'','2024-06-13 16:17:33.469','2024-06-13 16:17:52.254','2024-06-13 16:17:33.470','2024-06-13 14:17:52.254',NULL),('ad659304-298f-11ef-8fb0-da2b4bf5ebbb',4,'ad641506-298f-11ef-8fb0-da2b4bf5ebbb',1,1,0,'','2024-06-13 16:17:33.795','2024-06-13 16:17:49.962','2024-06-13 16:17:33.795','2024-06-13 14:17:49.963',NULL),('b19c6074-2336-11ef-8f93-d92a45da78c9',2,'b19ab46f-2336-11ef-8f93-d92a45da78c9',1,1,0,'','2024-06-05 14:25:28.000',NULL,'2024-06-05 14:25:28.680','2024-06-05 12:25:29.000','2024-06-05 14:25:29.000'),('b651dff3-2343-11ef-8f93-d92a45da78c9',2,'b651a084-2343-11ef-8f93-d92a45da78c9',1,1,0,'','2024-06-05 15:58:40.000',NULL,'2024-06-05 15:58:40.037','2024-06-05 13:59:06.000','2024-06-05 15:59:06.000'),('c327a396-298f-11ef-8fb0-da2b4bf5ebbb',4,'c32616e0-298f-11ef-8fb0-da2b4bf5ebbb',1,1,0,'','2024-06-13 16:18:10.299','2024-06-13 16:19:48.564','2024-06-13 16:18:10.300','2024-06-13 14:19:48.564',NULL),('c81dfd34-2343-11ef-8f93-d92a45da78c9',2,'c81d8cfa-2343-11ef-8f93-d92a45da78c9',1,1,1,'','2024-06-05 15:59:09.896',NULL,'2024-06-05 15:59:09.897','2024-06-05 13:59:09.897',NULL),('cdf45240-227d-11ef-8f8c-d92a43d45d56',2,'cdf2bb52-227d-11ef-8f8c-d92a43d45d56',1,1,0,'','2024-06-04 16:21:59.000',NULL,'2024-06-04 16:21:59.345','2024-06-04 14:22:00.000','2024-06-04 16:22:00.000'),('e3868e5f-225a-11ef-8f1f-d8242c71b430',2,'e3862d66-225a-11ef-8f1f-d8242c71b430',1,1,0,'','2024-06-04 12:12:03.000',NULL,'2024-06-04 12:12:03.142','2024-06-04 10:12:04.000','2024-06-04 12:12:04.000'),('e90e3796-2897-11ef-8f6f-d9283dbaec71',3,'e90de9ef-2897-11ef-8f6f-d9283dbaec71',1,2,1,'','2024-06-12 10:43:58.697',NULL,'2024-06-12 10:43:58.697','2024-06-12 08:43:58.697',NULL),('f1fe313e-2958-11ef-9161-de41a781935b',2,'f1fca9ca-2958-11ef-9161-de41a781935b',1,1,0,'','2024-06-13 09:45:46.560',NULL,'2024-06-13 09:45:46.561','2024-06-13 07:45:46.561',NULL),('f6d13d7e-226e-11ef-8f1f-d8242c71b430',2,'f6cfa4bf-226e-11ef-8f1f-d8242c71b430',1,1,0,'','2024-06-04 14:35:45.000',NULL,'2024-06-04 14:35:45.444','2024-06-04 12:35:46.000','2024-06-04 14:35:46.000');
/*!40000 ALTER TABLE `Session` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SmilersOrder`
--

DROP TABLE IF EXISTS `SmilersOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SmilersOrder` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `actId` varchar(36) NOT NULL,
  `title` varchar(64) DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT 0,
  `createdById` varchar(36) DEFAULT NULL,
  `updatedById` varchar(36) DEFAULT NULL,
  `displayId` mediumint(8) unsigned DEFAULT NULL,
  `pcId` mediumint(8) unsigned DEFAULT NULL,
  `json` text NOT NULL,
  `metadata` text NOT NULL,
  `status` enum('NOT_SENT','WAITING_WOW_API','SENDING_WOW_API','SENDING_SMILERS_API','SENT','CANCELLED','DELIVERY') NOT NULL DEFAULT 'NOT_SENT',
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `actId` (`actId`),
  CONSTRAINT `SmilersOrder_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `SmilersOrder_ibfk_2` FOREIGN KEY (`actId`) REFERENCES `Act` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SmilersOrder`
--

LOCK TABLES `SmilersOrder` WRITE;
/*!40000 ALTER TABLE `SmilersOrder` DISABLE KEYS */;
/*!40000 ALTER TABLE `SmilersOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SmilersOrderFile`
--

DROP TABLE IF EXISTS `SmilersOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SmilersOrderFile` (
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('FORM','SCAN') NOT NULL,
  PRIMARY KEY (`orderId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `SmilersOrderFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `SmilersOrderFile_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `SmilersOrder` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `SmilersOrderFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SmilersOrderFile`
--

LOCK TABLES `SmilersOrderFile` WRITE;
/*!40000 ALTER TABLE `SmilersOrderFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `SmilersOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SyncInfo`
--

DROP TABLE IF EXISTS `SyncInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SyncInfo` (
  `id` mediumint(8) unsigned NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `directLastRetrieved` text DEFAULT NULL COMMENT 'Direct last retrieved date values as json',
  `autoLastRetrieved` text DEFAULT NULL COMMENT 'Auto last retrieved date values as json',
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  PRIMARY KEY (`id`,`ownerId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SyncInfo`
--

LOCK TABLES `SyncInfo` WRITE;
/*!40000 ALTER TABLE `SyncInfo` DISABLE KEYS */;
INSERT INTO `SyncInfo` VALUES (1,1,NULL,NULL,'2024-06-04 08:35:39.624'),(1,2,'{\"actsDirectLastRetrieved\":\"2024-06-07 11:51:59\",\"assistantsDirectLastRetrieved\":\"2024-06-04 14:35:11\",\"occlusionsDirectLastRetrieved\":\"2024-06-05 15:24:36\",\"patientsDirectLastRetrieved\":\"2024-06-10 15:47:18\",\"scansDirectLastRetrieved\":\"2024-06-05 15:59:13\",\"sessionsDirectLastRetrieved\":\"2024-06-05 15:59:06\"}','{\"contactsAutoLastRetrieved\":\"2024-06-06 14:49:21\",\"discussionsAutoLastRetrieved\":\"2024-06-07 12:15:21\",\"messagesAutoLastRetrieved\":\"2024-06-07 12:15:21\",\"notificationsAutoLastRetrieved\":\"2024-06-07 11:34:10\",\"prostheticOrdersAutoLastRetrieved\":\"2024-06-07 11:31:15\"}','2024-06-10 13:58:57.108'),(1,3,'{\"patientsDirectLastRetrieved\":\"2024-06-04 11:32:39\"}','{\"contactsAutoLastRetrieved\":\"2024-06-06 14:49:21\",\"discussionsAutoLastRetrieved\":\"2024-06-07 12:15:21\",\"messagesAutoLastRetrieved\":\"2024-06-07 12:15:21\",\"notificationsAutoLastRetrieved\":\"2024-06-06 11:04:04\"}','2024-06-07 10:15:26.244'),(1,4,NULL,'{\"contactsAutoLastRetrieved\":\"2024-06-04 14:02:57\",\"discussionsAutoLastRetrieved\":\"2024-06-04 14:10:47\",\"messagesAutoLastRetrieved\":\"2024-06-04 14:10:47\",\"notificationsAutoLastRetrieved\":\"2024-06-04 13:59:28\"}','2024-06-04 12:10:48.240'),(1,5,NULL,NULL,'2024-06-04 11:58:24.305'),(1,6,NULL,NULL,'2024-06-06 08:55:48.841'),(1,7,NULL,NULL,'2024-06-06 10:16:55.301'),(1,8,NULL,NULL,'2024-06-06 11:35:57.245');
/*!40000 ALTER TABLE `SyncInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SystemNotification`
--

DROP TABLE IF EXISTS `SystemNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SystemNotification` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `event` enum('NO_CONNECTION_FOR_X_DAYS') NOT NULL DEFAULT 'NO_CONNECTION_FOR_X_DAYS',
  `unread` tinyint(1) NOT NULL DEFAULT 1,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  CONSTRAINT `SystemNotification_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SystemNotification`
--

LOCK TABLES `SystemNotification` WRITE;
/*!40000 ALTER TABLE `SystemNotification` DISABLE KEYS */;
/*!40000 ALTER TABLE `SystemNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Token`
--

DROP TABLE IF EXISTS `Token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Token` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint(8) unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `credentialsId` varchar(36) DEFAULT NULL,
  `token` char(200) NOT NULL,
  `context` char(40) DEFAULT NULL,
  `device` char(255) DEFAULT NULL,
  `created` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT current_timestamp(3) ON UPDATE current_timestamp(3),
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `token` (`token`),
  KEY `credentialsId` (`credentialsId`),
  CONSTRAINT `Token_ibfk_1` FOREIGN KEY (`credentialsId`) REFERENCES `Credentials` (`uuid`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Token`
--

LOCK TABLES `Token` WRITE;
/*!40000 ALTER TABLE `Token` DISABLE KEYS */;
INSERT INTO `Token` VALUES ('031778d3-2267-11ef-8f1f-d8242c71b430',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','71301923f336235d60877b1496f2b0da0d245fac','software','CondorScan','2024-06-04 13:38:50.062','2024-06-04 11:38:50.062'),('16616578-226f-11ef-8f1f-d8242c71b430',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','f17f0a81e5a593ec679bd10ea58f96c1a61c555b','software','CondorScan','2024-06-04 14:36:38.397','2024-06-04 12:36:38.397'),('1d77fcb3-2341-11ef-8f93-d92a45da78c9',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','622bf2b0eff11b3df27007afb852dd24ec071dd3','software','CondorScan','2024-06-05 15:40:04.602','2024-06-05 13:40:04.602'),('1e86ce3f-2336-11ef-8f93-d92a45da78c9',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','b22fcaa238bf1be4c4d7565e67cfefeb10617177','software','CondorScan','2024-06-05 14:21:21.913','2024-06-05 12:21:21.913'),('22f15a79-24b1-11ef-8f75-d9293fbf05d8',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','f00cd761e403586b8978dc1722c04f3f403f9383','software','CondorScan','2024-06-07 11:34:28.704','2024-06-07 09:34:28.704'),('24b9b547-23de-11ef-8f8c-d92a43d45e5a',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','b1880eb54ed883d1063e9ea457c78109d6afb475','software','CondorScan','2024-06-06 10:24:07.763','2024-06-06 08:24:07.763'),('25a76e75-2335-11ef-8f93-d92a45da78c9',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','e9d968c569038c580c33e014d630b238e0249123','software','CondorScan','2024-06-05 14:14:24.374','2024-06-05 12:14:24.374'),('38014d03-23f9-11ef-8f8c-d92a43d45e5a',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','d8273f1d8c921b093f072462746141dd7246b72a','software','CondorScan','2024-06-06 13:37:56.521','2024-06-06 11:37:56.521'),('40278e30-23e0-11ef-8f8c-d92a43d45e5a',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','6f18706d22d190cba17618f60d285ae2e551e4c2','software','CondorScan','2024-06-06 10:39:12.775','2024-06-06 08:39:12.775'),('4f8c484f-2254-11ef-8f1f-d8242c71b430',4,'7a0e3a28-a28c-4323-92c1-8831f0d6815b','d1a2f6c30034e4d4995f8bee258776db80dbec88','software','CondorScan','2024-06-04 11:24:57.890','2024-06-04 09:24:58.741'),('4fc3c8fc-2335-11ef-8f93-d92a45da78c9',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','13dbff3db8e72716cb1372f888daec46d49019e8','software','CondorScan','2024-06-05 14:15:35.024','2024-06-05 12:15:35.024'),('53b764ba-227d-11ef-8f8c-d92a43d45d56',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','fc0364ca3b027a89f6a72dc520379d22be9a9b03','software','CondorScan','2024-06-04 16:18:34.255','2024-06-04 14:18:34.256'),('62f9f52d-226b-11ef-8f1f-d8242c71b430',4,'7a0e3a28-a28c-4323-92c1-8831f0d6815b','5cdda3d6d422ee09a2a546caa09f38fec579ccd1','software','CondorScan','2024-06-04 14:10:08.916','2024-06-04 12:10:08.916'),('6445948f-24b3-11ef-8f75-d9293fbf05d8',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','1d616e4502e6a31af93f79ed33443e374fb1e018','software','CondorScan','2024-06-07 11:50:37.301','2024-06-07 09:50:37.302'),('6a62e985-224d-11ef-8f1f-d8242c71b430',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','d9e410b8b2630d488d83bc2eeb1097e8e48f4955','software','CondorScan','2024-06-04 10:35:36.437','2024-06-04 08:35:38.618'),('6accc5e0-2266-11ef-8f1f-d8242c71b430',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','a4d0ca16daf39c58dbbf845260fa12b3a4c406f9','software','CondorScan','2024-06-04 13:34:34.558','2024-06-04 11:34:34.558'),('8d00161e-2731-11ef-8ffc-db2f5b3b17c2',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','8eac9bedb485c0cc93939f2c9c0a41bbe73365ae','software','CondorScan','2024-06-10 15:58:43.856','2024-06-10 13:58:43.856'),('8eba002d-226c-11ef-8f1f-d8242c71b430',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','9a000a335e7ead84b1b56284ebe8701d0e763964','software','CondorScan','2024-06-04 14:18:31.814','2024-06-04 12:18:31.814'),('902abb9b-23e2-11ef-8f8c-d92a43d45e5a',3,'adc06de1-bf5d-4b1a-81dc-e5e919328b7c','2d33613c159af20afb58488f688ecfff483a3c9e','software','CondorScan','2024-06-06 10:55:46.007','2024-06-06 08:55:46.007'),('9b581b03-23e0-11ef-8f8c-d92a43d45e5a',3,'adc06de1-bf5d-4b1a-81dc-e5e919328b7c','09f20f784174f70995c3e0d99856873a97576811','software','CondorScan','2024-06-06 10:41:45.766','2024-06-06 08:41:46.905'),('9bf21108-23e6-11ef-8f8c-d92a43d45e5a',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','93593af1e37105cdb1baba8cd772144c526caf9a','software','CondorScan','2024-06-06 11:24:43.755','2024-06-06 09:24:43.755'),('9f568e01-2272-11ef-8f1f-d8242c71b430',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','8a64131146f9bb7124fc5cce3b045b5153df4a75','software','CondorScan','2024-06-04 15:01:56.664','2024-06-04 13:01:56.664'),('aa2405a9-2257-11ef-8f1f-d8242c71b430',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','481c7526b08a5196926af891901ae8775d6b46be','software','CondorScan','2024-06-04 11:48:58.376','2024-06-04 09:48:58.376'),('aaf99dfe-2334-11ef-8f93-d92a45da78c9',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','0332ed28facc4c504060017d71b6fee1e1860b49','software','CondorScan','2024-06-05 14:10:58.553','2024-06-05 12:10:58.553'),('af9fa35c-2270-11ef-8f1f-d8242c71b430',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','eff4946ace2364c07ddbeb24fc8b86a8fcfbd66e','software','CondorScan','2024-06-04 14:48:04.993','2024-06-04 12:48:04.993'),('b8bf83b7-225a-11ef-8f1f-d8242c71b430',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','c97054d35f5b8cdb0f4be23cfdf772d49d13f084','software','CondorScan','2024-06-04 12:10:51.373','2024-06-04 10:10:51.373'),('bf9be762-23e0-11ef-8f8c-d92a43d45e5a',3,'adc06de1-bf5d-4b1a-81dc-e5e919328b7c','c6df430f4d349e5181a9d3adb4c668bfd8f4a4fa','software','CondorScan','2024-06-06 10:42:46.608','2024-06-06 08:42:46.608'),('c3570374-23e8-11ef-8f8c-d92a43d45e5a',3,'adc06de1-bf5d-4b1a-81dc-e5e919328b7c','38fb965ef2cbc57fa7b2dbf4429c5ef6cb922477','software','CondorScan','2024-06-06 11:40:08.841','2024-06-06 09:40:08.841'),('cbd516ba-2257-11ef-8f1f-d8242c71b430',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','20bf0c2d34b24ae7e9212862e9b2cca571371e06','software','CondorScan','2024-06-04 11:49:54.901','2024-06-04 09:49:54.901'),('d15f5114-23ed-11ef-8f8c-d92a43d45e5a',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','8e27ac32e6bb3934e9baa9e3d33707a0d8750aee','software','CondorScan','2024-06-06 12:16:19.868','2024-06-06 10:16:19.868'),('d4e8cc18-23e9-11ef-8f8c-d92a43d45e5a',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','5dc04e6248665d26ae4d9aa558bc61c6365fd30d','software','CondorScan','2024-06-06 11:47:47.815','2024-06-06 09:47:47.815'),('d516e4d9-24b6-11ef-8f75-d9293fbf05d8',3,'adc06de1-bf5d-4b1a-81dc-e5e919328b7c','2e62d6abd4e73063d2f6e5c660c9200071b43355','software','CondorScan','2024-06-07 12:15:15.068','2024-06-07 10:15:15.068'),('d99ed645-2270-11ef-8f1f-d8242c71b430',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','5966ed64d70930c78e9106fceff7b6fa0b2b1a98','software','CondorScan','2024-06-04 14:49:15.452','2024-06-04 12:49:15.452'),('e260b4be-226e-11ef-8f1f-d8242c71b430',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','0aff4e7b5b431d0a35f5746689a24ae595e048a4','software','CondorScan','2024-06-04 14:35:11.151','2024-06-04 12:35:11.151'),('e4f86bd9-226b-11ef-8f1f-d8242c71b430',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','e2be9e0ec621dd8b7109ae2cc65191f30f387a9b','software','CondorScan','2024-06-04 14:13:47.010','2024-06-04 12:13:47.010'),('e87162e0-23ff-11ef-8f8c-d92a43d45e5a',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','486b6306bdff4afbc03facf7c448ff7dcf77d9fc','software','CondorScan','2024-06-06 14:25:49.515','2024-06-06 12:25:49.515'),('eda3302f-2274-11ef-8f1f-d8242c71b430',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','7f706f2fa1f660a87357554dd89423119063d0b3','software','CondorScan','2024-06-04 15:18:27.022','2024-06-04 13:18:27.022'),('f58fedd0-24b0-11ef-8f75-d9293fbf05d8',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','e6c1088be0e8407fc4f17563ba7a872951c1e12d','software','CondorScan','2024-06-07 11:33:12.568','2024-06-07 09:33:12.568'),('f9b37781-2342-11ef-8f93-d92a45da78c9',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','b68ca0e8a7adcfe9e742b6c3626e7692fe13a187','software','CondorScan','2024-06-05 15:53:23.587','2024-06-05 13:53:23.587'),('fcc3ac84-226d-11ef-8f1f-d8242c71b430',2,'83184b42-53a8-43e0-964a-e3b8d3a2acbf','c4c1c84bf386c41bd265b1bbdb9b624091d7ed3b','software','CondorScan','2024-06-04 14:28:45.923','2024-06-04 12:28:45.923');
/*!40000 ALTER TABLE `Token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `__db_version__`
--

DROP TABLE IF EXISTS `__db_version__`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `__db_version__` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `versionMajor` int(11) NOT NULL,
  `versionMinor` int(11) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `migrationFile` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `__db_version__`
--

LOCK TABLES `__db_version__` WRITE;
/*!40000 ALTER TABLE `__db_version__` DISABLE KEYS */;
INSERT INTO `__db_version__` VALUES (1,1,0,'v1.0','iris_application_1.0_create_application'),(2,1,1,'v1.1','iris_application_1.1_occlusion_pap'),(3,1,2,'v1.2','iris_application_1.2_occlusion_pre_preparation'),(4,1,3,'v1.3','iris_application_1.3_occlusion_rework'),(5,1,4,'v1.4','iris_application_1.4_scan_label'),(6,1,5,'v1.5','iris_application_1.5_order_delivery'),(7,1,6,'v1.6','iris_application_1.6_sheet_json'),(8,1,7,'v1.7','iris_application_1.7_config_patient_list'),(9,1,8,'v1.8','iris_application_1.8_metering'),(10,1,9,'v1.9','iris_application_1.9_segmentation'),(11,1,10,'v1.10','iris_application_1.10_analyse'),(12,1,11,'v1.11','iris_application_1.11_messages'),(13,1,12,'v1.12','iris_application_1.12_scan_sup'),(14,1,13,'v1.13','iris_application_1.13_config'),(15,1,14,'v1.14','iris_application_1.14_syncinfo'),(16,1,15,'v1.15','iris_application_1.15_pcid'),(17,1,16,'v1.16','iris_application_1.16_remove_label_occlusion_file');
/*!40000 ALTER TABLE `__db_version__` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping routines for database 'iris_application'
--
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
/*!50003 DROP FUNCTION IF EXISTS `fileMetadataToLabel` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8mb3_general_ci */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `fileMetadataToLabel`(metadata TEXT) RETURNS text CHARSET utf8mb4 COLLATE utf8mb4_general_ci
    NO SQL
BEGIN
    IF metadata LIKE '%scanBodies%' THEN RETURN 'SCANBODY'; END IF;

    RETURN 'SCAN';
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewOcclusionFileType` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8mb3_general_ci */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewOcclusionFileType`(oldType TEXT) RETURNS text CHARSET utf8mb4 COLLATE utf8mb4_general_ci
    NO SQL
BEGIN
    IF oldType = 'MANDIBLE' THEN RETURN 'MANDIBLE_1'; END IF;

    IF oldType = 'MANDIBLE_SB' THEN RETURN 'MANDIBLE_2'; END IF;

    IF oldType = 'MANDIBLE_PRE' THEN RETURN 'MANDIBLE_3'; END IF;

    IF oldType = 'MANDIBLE_SUP' THEN RETURN 'MANDIBLE_4'; END IF;

    IF oldType = 'MAXILLARY' THEN RETURN 'MAXILLARY_1'; END IF;

    IF oldType = 'MAXILLARY_SB' THEN RETURN 'MAXILLARY_2'; END IF;

    IF oldType = 'MAXILLARY_PRE' THEN RETURN 'MAXILLARY_3'; END IF;

    IF oldType = 'MAXILLARY_SUP' THEN RETURN 'MAXILLARY_4'; END IF;

    RETURN oldType;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewProstheticContactPoint` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8mb3_general_ci */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewProstheticContactPoint`(old TEXT) RETURNS int(11)
    NO SQL
BEGIN
    IF old = '2' THEN RETURN 0; END IF;
    IF old = '3' THEN RETURN 1; END IF;
    IF old = '4' THEN RETURN 2; END IF;
    RETURN 1;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewProstheticCrownOrBridgeSubType` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8mb3_general_ci */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewProstheticCrownOrBridgeSubType`(old TEXT) RETURNS int(11)
    NO SQL
BEGIN
    IF old = '1' THEN RETURN 0; END IF;
    IF old = '2' THEN RETURN 1; END IF;
    IF old = '3' THEN RETURN 2; END IF;
    RETURN 0;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewProstheticGouttiereSubType` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8mb3_general_ci */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewProstheticGouttiereSubType`(old TEXT) RETURNS int(11)
    NO SQL
BEGIN
    IF old = '1' THEN RETURN 1; END IF;
    IF old = '2' THEN RETURN 2; END IF;
    IF old = '3' THEN RETURN 3; END IF;
    IF old = '4' THEN RETURN 0; END IF;
    IF old = '5' THEN RETURN 4; END IF;
    IF old = '6' THEN RETURN 5; END IF;
    IF old = '7' THEN RETURN 6; END IF;
    RETURN 0;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewProstheticImplantCrownSubType` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8mb3_general_ci */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewProstheticImplantCrownSubType`(old TEXT) RETURNS int(11)
    NO SQL
BEGIN
    IF old = '1' THEN RETURN 0; END IF;
    IF old = '2' THEN RETURN 1; END IF;
    IF old = '3' THEN RETURN 0; END IF;
    IF old = '4' THEN RETURN 1; END IF;
    RETURN 2;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewProstheticInlayOnlaySubType` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8mb3_general_ci */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewProstheticInlayOnlaySubType`(old TEXT) RETURNS int(11)
    NO SQL
BEGIN
    IF old = '1' THEN RETURN 0; END IF;
    IF old = '2' THEN RETURN 1; END IF;
    RETURN 2;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
/*!50003 DROP FUNCTION IF EXISTS `scanMetadataToLabel` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8mb3_general_ci */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `scanMetadataToLabel`(metadata TEXT) RETURNS text CHARSET utf8mb4 COLLATE utf8mb4_general_ci
    NO SQL
BEGIN
    IF metadata LIKE '%"isPrePreparation":true%' THEN RETURN 'PRE_PREPARATION'; END IF;

    RETURN 'SCAN';
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2024-06-13 16:42:47
