-- MySQL dump 10.13  Distrib 8.0.33, for Linux (x86_64)
--
-- Host: localhost    Database: wow_application
-- ------------------------------------------------------
-- Server version	8.0.33-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `Act`
--

DROP TABLE IF EXISTS `Act`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Act` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `patientId` varchar(36) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `displayId` mediumint unsigned DEFAULT NULL,
  `workflow` enum('FREE','WORKFLOW_1','WORKFLOW_2','WORKFLOW_3') NOT NULL DEFAULT 'FREE',
  `comments` text,
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastAccessed` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `patientId` (`patientId`),
  CONSTRAINT `Act_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Act_ibfk_2` FOREIGN KEY (`patientId`) REFERENCES `wow_patient`.`Patient` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Act`
--

LOCK TABLES `Act` WRITE;
/*!40000 ALTER TABLE `Act` DISABLE KEYS */;
INSERT INTO `Act` VALUES ('0628a8e9-1104-11ee-b636-a0510b46b473',11,'f72be411-1103-11ee-b636-a0510b46b473','Acte bouche manip V1',1,'FREE','',0,'2023-06-22 15:52:27.593',NULL,'2023-06-22 16:43:39.180','2023-06-22 16:31:35.275','2023-06-22 14:43:39.180',NULL),('06fff4e1-1ca0-11ee-84c4-a0510b46b473',11,'fef8307a-1c9f-11ee-84c4-a0510b46b473','Acte bouche',1,'FREE','',0,'2023-07-07 10:26:53.284',NULL,'2023-07-21 09:59:38.506','2023-07-07 10:26:53.287','2023-07-21 07:59:38.508',NULL),('08b47e37-1ca8-11ee-997b-a0510b46b473',11,'fef8307a-1c9f-11ee-84c4-a0510b46b473','Acte MANIP V2',2,'FREE','',0,'2023-07-07 11:24:12.119',NULL,'2023-07-21 10:01:47.174','2023-07-07 11:24:12.121','2023-07-21 08:01:47.174',NULL),('1673b758-09e6-11ee-8676-a0510b46b473',11,'e86b5c99-e024-11ed-bb13-00d86184ce3d','Acte recuperation scan intermediaire',7,'FREE','',0,'2023-06-13 14:30:31.887',NULL,'2023-06-13 14:31:08.540','2023-06-13 14:30:31.889','2023-06-13 12:31:08.540',NULL),('1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d',11,'142e7037-15b6-11ee-b3b1-00d86184ce3d','Acte bouche',1,'FREE','',0,'2023-06-28 15:17:24.055',NULL,'2023-06-28 16:26:18.341','2023-06-28 15:17:24.057','2023-06-28 14:26:18.342',NULL),('261265bf-e03f-11ed-bb13-00d86184ce3d',11,'e86b5c99-e024-11ed-bb13-00d86184ce3d','Acte video arcade',4,'FREE','',0,'2023-04-21 14:22:14.465',NULL,'2023-04-24 15:25:19.786','2023-04-21 14:22:14.468','2023-04-24 13:25:19.786',NULL),('319e146c-1a66-11ee-9a4f-a0510b46b473',11,'4ada0d8c-1a49-11ee-9a4f-a0510b46b473','Acte SEQUENCE MANIP V2',3,'FREE','',0,'2023-07-04 14:27:51.649',NULL,'2023-07-04 14:29:03.734','2023-07-04 14:27:51.651','2023-07-04 12:29:03.734',NULL),('3a881645-2abf-11ee-80c8-a0510b46b473',11,'fef8307a-1c9f-11ee-84c4-a0510b46b473','Acte vidéo',7,'FREE','',0,'2023-07-25 09:45:30.418',NULL,'2023-07-25 10:30:45.419','2023-07-25 09:45:30.420','2023-07-25 08:30:45.419',NULL),('3adeac35-10e1-11ee-b636-a0510b46b473',11,'2ff330cd-10e1-11ee-b636-a0510b46b473','Acte bouche en v1',1,'FREE','',0,'2023-06-22 11:43:23.642',NULL,'2023-06-22 12:03:52.281','2023-06-22 11:43:23.645','2023-06-22 10:03:52.281',NULL),('450c29ef-de95-11ed-9cc3-00d86184ce3d',11,'35e16a68-de95-11ed-9cc3-00d86184ce3d','Acte tests x 6',1,'FREE','',0,'2023-04-19 11:33:40.827',NULL,'2023-04-19 12:23:56.819','2023-04-19 11:33:40.829','2023-04-19 10:23:56.820',NULL),('4a5f2876-1cad-11ee-997b-a0510b46b473',11,'4375c5f1-1cad-11ee-997b-a0510b46b473','Acte bouche',1,'FREE','',0,'2023-07-07 12:01:49.773',NULL,'2023-07-07 12:25:39.647','2023-07-07 12:01:49.775','2023-07-07 10:25:39.647',NULL),('4b1c4cb0-1404-11ee-91d8-a0510b46b473',11,'4051490b-1404-11ee-91d8-a0510b46b473','Acte bouche',1,'FREE','',0,'2023-06-26 11:31:56.763',NULL,'2023-06-26 16:33:18.342','2023-06-26 11:31:56.766','2023-06-26 14:33:18.345',NULL),('4de7c46e-26fa-11ee-a98e-a0510b46b473',11,'c69c4cec-26f5-11ee-aa9d-a0510b46b473','Acte bouche apres demarrage',2,'FREE','',0,'2023-07-20 14:38:18.578',NULL,'2023-07-21 10:03:22.346','2023-07-20 14:38:18.580','2023-07-21 08:03:22.346',NULL),('4ff1c1c7-2aeb-11ee-97fa-a0510b46b473',11,'4baca484-2aeb-11ee-97fa-a0510b46b473','Acte Autre',1,'FREE','',0,'2023-07-25 15:01:04.199',NULL,'2023-07-25 15:05:13.802','2023-07-25 15:01:04.201','2023-07-25 13:05:13.803',NULL),('55019e04-0f41-11ee-8712-a0510b46b473',11,'8e5ac874-0f3e-11ee-8712-a0510b46b473','Acte MANIP V2',2,'FREE','',0,'2023-06-20 10:06:16.852',NULL,'2023-06-20 10:17:59.564','2023-06-20 10:06:16.854','2023-06-20 08:17:59.565',NULL),('568bc925-26df-11ee-a836-a0510b46b473',11,'fef8307a-1c9f-11ee-84c4-a0510b46b473','Acte chauffe',3,'FREE','',0,'2023-07-20 11:25:16.663','2023-07-21 10:01:25.465','2023-07-21 10:01:18.572','2023-07-21 10:01:25.465','2023-07-21 08:01:25.467',NULL),('56e1eee3-1a49-11ee-9a4f-a0510b46b473',11,'4ada0d8c-1a49-11ee-9a4f-a0510b46b473','Acte bouche',1,'FREE','',0,'2023-07-04 11:01:18.764',NULL,'2023-07-04 14:21:47.436','2023-07-04 11:01:18.765','2023-07-04 12:21:47.445',NULL),('5a5a69f7-e042-11ed-bb13-00d86184ce3d',11,'e86b5c99-e024-11ed-bb13-00d86184ce3d','Acte video2 arcade',5,'FREE','',0,'2023-04-21 14:45:10.669',NULL,'2023-04-24 15:25:05.728','2023-04-21 14:45:10.671','2023-04-24 13:25:05.729',NULL),('5c74c40a-256f-11ee-91d6-a0510b46b473',11,'49f1e276-256f-11ee-91d6-a0510b46b473','Acte bouche',1,'FREE','',0,'2023-07-18 15:31:11.781',NULL,'2023-07-18 16:21:05.548','2023-07-18 15:31:11.784','2023-07-18 14:21:05.548',NULL),('5f50caeb-14cc-11ee-b3b1-00d86184ce3d',11,'9619fcac-14c3-11ee-b3b1-00d86184ce3d','Acte manip V2',2,'FREE','',0,'2023-06-27 11:24:10.008',NULL,'2023-06-27 11:49:10.596','2023-06-27 11:24:10.010','2023-06-27 09:49:10.597',NULL),('605503de-e34e-11ed-8c5e-00d86184ce3d',11,'971e14b0-e348-11ed-8c5e-00d86184ce3d','Acte video manip V2',3,'FREE','',0,'2023-04-25 11:48:48.149',NULL,'2023-04-25 11:52:56.272','2023-04-25 11:48:48.150','2023-04-25 09:52:56.273',NULL),('61025fcf-dcfe-11ed-8097-00d86184ce3d',11,'59af3050-dcfe-11ed-8097-00d86184ce3d','Acte Guide',1,'FREE','',0,'2023-04-17 11:01:02.570',NULL,'2023-04-19 10:24:02.441','2023-04-17 11:01:02.572','2023-04-19 08:24:02.441','2023-04-19 10:12:34.320'),('62519c59-261f-11ee-8042-a0510b46b473',11,'53d7979d-261f-11ee-8042-a0510b46b473','Acte bouche',1,'FREE','',0,'2023-07-19 12:31:13.042',NULL,'2023-07-21 10:00:24.059','2023-07-19 12:31:13.044','2023-07-21 08:00:24.059',NULL),('63b81b7e-e035-11ed-bb13-00d86184ce3d',11,'e86b5c99-e024-11ed-bb13-00d86184ce3d','Acte video',2,'FREE','',0,'2023-04-21 13:12:22.925',NULL,'2023-04-24 15:25:48.033','2023-04-21 13:12:22.927','2023-04-24 13:25:48.033',NULL),('65b85f32-e01a-11ed-b6c2-00d86184ce3d',11,'5f27680c-e01a-11ed-b6c2-00d86184ce3d','Acte Autre',1,'FREE','',0,'2023-04-21 09:59:09.870',NULL,'2023-04-25 10:05:59.072','2023-04-21 09:59:09.873','2023-04-25 08:05:59.072',NULL),('6897acc6-1035-11ee-895b-a0510b46b473',11,'d75719c6-1032-11ee-895b-a0510b46b473','Acte ref23',2,'FREE','',0,'2023-06-21 15:13:26.914',NULL,'2023-06-21 15:44:36.003','2023-06-21 15:13:26.917','2023-06-21 13:44:36.003',NULL),('68b68f8e-10e4-11ee-b636-a0510b46b473',11,'2ff330cd-10e1-11ee-b636-a0510b46b473','Acte MANIP V2',2,'FREE','',0,'2023-06-22 12:06:09.044',NULL,'2023-06-22 12:12:22.204','2023-06-22 12:06:09.047','2023-06-22 10:12:22.204',NULL),('6e9df503-1587-11ee-b3b1-00d86184ce3d',11,'634153bc-1587-11ee-b3b1-00d86184ce3d','Acte bouche',1,'FREE','',0,'2023-06-28 09:43:11.568',NULL,'2023-06-28 14:10:55.905','2023-06-28 09:43:11.570','2023-06-28 12:10:55.905',NULL),('6eedc44e-4bec-11ee-839e-a0510b46b473',11,'6ee9e4a7-4bec-11ee-839e-a0510b46b473','Direct scan',1,'FREE','',1,'2023-09-05 15:02:14.050',NULL,NULL,'2023-09-05 15:02:14.052','2023-09-05 13:02:14.053',NULL),('6f09f9a8-e03a-11ed-bb13-00d86184ce3d',11,'e86b5c99-e024-11ed-bb13-00d86184ce3d','Acte pour video-hemi',3,'FREE','',0,'2023-04-21 13:48:29.400',NULL,'2023-04-24 15:25:33.917','2023-04-21 13:48:29.401','2023-04-24 13:25:33.918',NULL),('71ba03b6-e350-11ed-8c5e-00d86184ce3d',11,'6175c1d5-e350-11ed-8c5e-00d86184ce3d','Acte precision manip V1',1,'FREE','',0,'2023-04-25 12:03:36.325',NULL,'2023-04-25 12:33:23.341','2023-04-25 12:03:36.327','2023-04-25 10:33:23.341',NULL),('76f916fd-1a76-11ee-8124-a0510b46b473',11,'61e16a70-1a76-11ee-8124-a0510b46b473','Acte bouche',1,'FREE','',0,'2023-07-04 16:24:19.956',NULL,'2023-07-24 17:38:05.122','2023-07-04 16:24:19.958','2023-07-24 15:38:05.122',NULL),('7758b704-1fe8-11ee-b7d5-a0510b46b473',11,'6a143ccb-1fe8-11ee-b7d5-a0510b46b473','Acte Gouttière',1,'FREE','',0,'2023-07-11 14:42:59.024',NULL,'2023-07-11 14:51:26.342','2023-07-11 14:42:59.026','2023-07-11 12:51:26.343',NULL),('77df3b68-1a6c-11ee-af16-a0510b46b473',11,'4ada0d8c-1a49-11ee-9a4f-a0510b46b473','Acte bouche',4,'FREE','',0,'2023-07-04 15:12:46.497',NULL,'2023-07-04 15:59:53.595','2023-07-04 15:12:46.499','2023-07-04 13:59:53.596',NULL),('78d129fc-26e0-11ee-a836-a0510b46b473',11,'fef8307a-1c9f-11ee-84c4-a0510b46b473','Acte bouche-2 essais',4,'FREE','',0,'2023-07-20 11:33:23.656',NULL,'2023-07-21 10:01:26.488','2023-07-20 11:33:23.659','2023-07-21 08:01:26.488',NULL),('853ebc79-e33f-11ed-8c5e-00d86184ce3d',11,'e86b5c99-e024-11ed-bb13-00d86184ce3d','Acte tests precision',6,'FREE','',0,'2023-04-25 10:02:27.628',NULL,'2023-04-25 12:47:16.255','2023-04-25 10:02:27.630','2023-04-25 10:47:16.256',NULL),('858fcc60-de94-11ed-9cc3-00d86184ce3d',11,'e0d449f3-dde9-11ed-aa56-00d86184ce3d','Acte Guide',1,'FREE','',0,'2023-04-19 11:28:19.567',NULL,'2023-06-22 14:15:29.969','2023-04-19 11:28:19.569','2023-06-22 12:15:29.970',NULL),('8b758c52-2ae7-11ee-97fa-a0510b46b473',11,'fef8307a-1c9f-11ee-84c4-a0510b46b473','Acte Autre',9,'FREE','',0,'2023-07-25 14:34:06.061',NULL,'2023-07-25 14:57:51.904','2023-07-25 14:34:06.064','2023-07-25 12:57:51.904',NULL),('8cbad919-10fb-11ee-b636-a0510b46b473',11,'ed94fe78-10f4-11ee-b636-a0510b46b473','Acte manip V2',2,'FREE','',0,'2023-06-22 14:51:47.895',NULL,'2023-06-22 15:00:24.661','2023-06-22 14:51:47.898','2023-06-22 13:00:24.661',NULL),('8d62c238-14f6-11ee-b3b1-00d86184ce3d',11,'8283c62f-14f6-11ee-b3b1-00d86184ce3d','Acte bouche',1,'FREE','',0,'2023-06-27 16:26:06.163',NULL,'2023-06-27 16:38:37.727','2023-06-27 16:26:06.164','2023-06-27 14:38:37.728',NULL),('8f62cd50-26fd-11ee-a98e-a0510b46b473',11,'848c86d9-26fd-11ee-a98e-a0510b46b473','Acte bouche',1,'FREE','',0,'2023-07-20 15:01:36.926',NULL,'2023-07-21 10:02:37.193','2023-07-20 15:01:36.928','2023-07-21 08:02:37.194',NULL),('961b9a11-14c3-11ee-b3b1-00d86184ce3d',11,'9619fcac-14c3-11ee-b3b1-00d86184ce3d','BOUCHE',1,'FREE','',0,'2023-06-27 10:21:16.463',NULL,'2023-06-27 11:29:55.263','2023-06-27 10:45:11.447','2023-06-27 09:29:55.271',NULL),('964f8d9e-0f3e-11ee-8712-a0510b46b473',11,'8e5ac874-0f3e-11ee-8712-a0510b46b473','Acte bouche',1,'FREE','',0,'2023-06-20 09:46:37.925',NULL,'2023-06-20 10:19:07.402','2023-06-20 09:46:37.927','2023-06-20 08:19:07.402',NULL),('976f015a-1bf9-11ee-9323-a0510b46b473',11,'8a8cc548-1bf9-11ee-9323-a0510b46b473','Acte bouche',1,'FREE','',0,'2023-07-06 14:35:29.650',NULL,'2023-07-06 15:28:15.512','2023-07-06 14:35:29.653','2023-07-06 13:28:15.515',NULL),('9f32257c-1a64-11ee-9a4f-a0510b46b473',11,'4ada0d8c-1a49-11ee-9a4f-a0510b46b473','Acte manip V2',2,'FREE','',0,'2023-07-04 14:16:36.498',NULL,'2023-07-04 14:26:05.547','2023-07-04 14:16:36.500','2023-07-04 12:26:05.547',NULL),('a0a47257-1bd8-11ee-9086-a0510b46b473',11,'61e16a70-1a76-11ee-8124-a0510b46b473','Acte bouche ',3,'FREE','',0,'2023-07-06 10:39:31.708',NULL,'2023-07-24 17:38:16.636','2023-07-06 10:39:31.710','2023-07-24 15:38:16.636',NULL),('a0fbda94-e348-11ed-8c5e-00d86184ce3d',11,'971e14b0-e348-11ed-8c5e-00d86184ce3d','Acte precision',1,'FREE','',0,'2023-04-25 11:07:39.636',NULL,'2023-04-25 11:53:05.128','2023-04-25 11:07:39.638','2023-04-25 09:53:05.128',NULL),('a5c8b0b7-e021-11ed-a285-00d86184ce3d',11,'5f27680c-e01a-11ed-b6c2-00d86184ce3d','Acte video',2,'FREE','',0,'2023-04-21 10:51:03.829',NULL,'2023-04-21 10:52:55.691','2023-04-21 10:51:03.831','2023-04-21 08:52:55.692',NULL),('a6b1a4bd-1bcf-11ee-9086-a0510b46b473',11,'8e5ac874-0f3e-11ee-8712-a0510b46b473','Acte bouche',3,'FREE','',0,'2023-07-06 09:35:16.390',NULL,'2023-07-06 09:57:15.970','2023-07-06 09:35:16.393','2023-07-06 07:57:15.970',NULL),('a945b37e-1ccf-11ee-997b-a0510b46b473',11,'4375c5f1-1cad-11ee-997b-a0510b46b473','Acte Couronne sur implant',3,'WORKFLOW_3','',0,'2023-07-07 16:07:51.879',NULL,'2023-07-07 16:11:25.879','2023-07-07 16:07:51.881','2023-07-07 14:11:25.879',NULL),('a9a1083a-4bed-11ee-839e-a0510b46b473',11,'a414a41e-4bed-11ee-839e-a0510b46b473','Acte Guide',1,'FREE','',0,'2023-09-05 15:11:02.030',NULL,'2023-09-05 15:12:02.913','2023-09-05 15:11:02.032','2023-09-05 13:12:02.913',NULL),('ab852a49-262e-11ee-81dd-a0510b46b473',11,'53d7979d-261f-11ee-8042-a0510b46b473','Acte manip V2',2,'FREE','',0,'2023-07-19 14:20:38.304',NULL,'2023-07-19 14:54:28.306','2023-07-19 14:20:38.307','2023-07-19 12:54:28.307',NULL),('aed62174-dd16-11ed-8097-00d86184ce3d',11,'59af3050-dcfe-11ed-8097-00d86184ce3d','Acte Nadège',2,'FREE','',0,'2023-04-17 13:55:01.064',NULL,'2023-04-17 14:04:13.613','2023-04-17 13:55:01.064','2023-04-17 12:04:13.614','2023-04-17 14:05:16.824'),('b144ba33-2a36-11ee-9e90-a0510b46b473',11,'fef8307a-1c9f-11ee-84c4-a0510b46b473','Acte Gouttière',6,'FREE','',0,'2023-07-24 17:28:08.573',NULL,'2023-07-24 18:26:09.859','2023-07-24 17:28:08.576','2023-07-24 16:26:09.860',NULL),('b20f4b8a-df81-11ed-b6c2-00d86184ce3d',11,'ac239c53-df81-11ed-b6c2-00d86184ce3d','Acte Autre',1,'FREE','',0,'2023-04-20 15:46:04.947',NULL,'2023-04-21 10:06:34.818','2023-04-20 15:46:04.950','2023-04-21 08:06:34.818',NULL),('b5fe1002-2ae0-11ee-95bc-a0510b46b473',11,'fef8307a-1c9f-11ee-84c4-a0510b46b473','Acte video',8,'FREE','',0,'2023-07-25 13:45:10.943',NULL,'2023-07-25 14:30:53.728','2023-07-25 13:45:10.945','2023-07-25 12:30:53.728',NULL),('bab223ae-1c09-11ee-a865-a0510b46b473',11,'ae8bd11e-1c05-11ee-9323-a0510b46b473','Acte MANIP v2',2,'FREE','',0,'2023-07-06 16:31:00.758',NULL,'2023-07-06 16:40:24.123','2023-07-06 16:31:00.761','2023-07-06 14:40:24.123',NULL),('bb436bde-1c05-11ee-9323-a0510b46b473',11,'ae8bd11e-1c05-11ee-9323-a0510b46b473','Acte bouche',1,'FREE','',0,'2023-07-06 16:02:23.723',NULL,'2023-07-06 16:39:09.048','2023-07-06 16:02:23.726','2023-07-06 14:39:09.048',NULL),('c28d11f3-2706-11ee-a98e-a0510b46b473',11,'53d7979d-261f-11ee-8042-a0510b46b473','Acte essai 2',3,'FREE','',0,'2023-07-20 16:07:28.237',NULL,'2023-07-21 11:56:48.274','2023-07-20 16:07:28.240','2023-07-21 09:56:48.274',NULL),('c2f3ac91-deba-11ed-9cc3-00d86184ce3d',11,'cf3f0588-deb2-11ed-9cc3-00d86184ce3d','Acte vidéo',2,'FREE','',0,'2023-04-19 16:02:03.438',NULL,'2023-04-19 16:06:33.807','2023-04-19 16:02:03.441','2023-04-19 14:06:33.807',NULL),('c41888b6-15ba-11ee-b3b1-00d86184ce3d',11,'142e7037-15b6-11ee-b3b1-00d86184ce3d','Acte manip V2',2,'FREE','',0,'2023-06-28 15:50:39.310',NULL,'2023-06-28 16:24:09.774','2023-06-28 15:50:39.312','2023-06-28 14:24:09.774',NULL),('c5e67f1c-10d5-11ee-b636-a0510b46b473',11,'bd51960a-10d5-11ee-b636-a0510b46b473','Acte verif bouche',1,'FREE','',0,'2023-06-22 10:21:22.936',NULL,'2023-06-22 10:55:51.437','2023-06-22 10:21:22.938','2023-06-22 08:55:51.437',NULL),('c8578c2f-1a77-11ee-8124-a0510b46b473',11,'61e16a70-1a76-11ee-8124-a0510b46b473','Acte  bouche essai2',2,'FREE','',0,'2023-07-04 16:33:45.967',NULL,'2023-07-24 17:38:08.276','2023-07-04 16:33:45.970','2023-07-24 15:38:08.277',NULL),('ceaea325-1107-11ee-b636-a0510b46b473',11,'f72be411-1103-11ee-b636-a0510b46b473','Acte manipV2',2,'FREE','',0,'2023-06-22 16:19:32.506',NULL,'2023-06-22 16:38:38.984','2023-06-22 16:19:32.508','2023-06-22 14:38:38.984',NULL),('cf31a6d6-26f5-11ee-aa9d-a0510b46b473',11,'c69c4cec-26f5-11ee-aa9d-a0510b46b473','Acte bouche',1,'FREE','',0,'2023-07-20 14:06:08.004',NULL,'2023-07-21 10:03:41.899','2023-07-20 14:06:08.007','2023-07-21 08:03:41.899',NULL),('d30b0955-1bdb-11ee-9086-a0510b46b473',11,'61e16a70-1a76-11ee-8124-a0510b46b473','Acte manip V2',4,'FREE','',0,'2023-07-06 11:02:24.756',NULL,'2023-07-24 17:38:26.456','2023-07-06 11:02:24.759','2023-07-24 15:38:26.456',NULL),('d5081c73-df8b-11ed-b6c2-00d86184ce3d',11,'ce063c89-df8b-11ed-b6c2-00d86184ce3d','Acte Autre',1,'FREE','',0,'2023-04-20 16:58:38.588',NULL,'2023-04-20 17:08:28.074','2023-04-20 16:58:38.590','2023-04-20 15:08:28.075',NULL),('d5ef2d6b-26e3-11ee-a836-a0510b46b473',11,'fef8307a-1c9f-11ee-84c4-a0510b46b473','Acte bouche avec autre coque',5,'FREE','',0,'2023-07-20 11:57:28.371',NULL,'2023-07-21 10:02:09.165','2023-07-20 11:57:28.374','2023-07-21 08:02:09.165',NULL),('d6f9d6f4-e34a-11ed-8c5e-00d86184ce3d',11,'971e14b0-e348-11ed-8c5e-00d86184ce3d','Acte manip V2',2,'FREE','',0,'2023-04-25 11:23:29.213',NULL,'2023-04-25 11:52:47.033','2023-04-25 11:23:29.216','2023-04-25 09:52:47.034',NULL),('d7750b8d-deb2-11ed-9cc3-00d86184ce3d',11,'cf3f0588-deb2-11ed-9cc3-00d86184ce3d','Acte bouche x 6',1,'FREE','',0,'2023-04-19 15:05:21.867',NULL,'2023-04-19 16:08:56.133','2023-04-19 15:05:21.869','2023-04-19 14:08:56.133',NULL),('dfb50528-1cb0-11ee-997b-a0510b46b473',11,'4375c5f1-1cad-11ee-997b-a0510b46b473','Acte MANIP V2',2,'FREE','',0,'2023-07-07 12:27:28.807',NULL,'2023-07-07 12:33:46.929','2023-07-07 12:27:28.809','2023-07-07 10:33:46.929',NULL),('e5c513d4-1032-11ee-895b-a0510b46b473',11,'d75719c6-1032-11ee-895b-a0510b46b473','Acte devel_v2_ph3',1,'FREE','',0,'2023-06-21 14:55:28.437',NULL,'2023-06-21 15:43:27.267','2023-06-21 14:55:28.439','2023-06-21 13:43:27.268',NULL),('ea1c884f-e352-11ed-8c5e-00d86184ce3d',11,'6175c1d5-e350-11ed-8c5e-00d86184ce3d','Acte MANIP V2',2,'FREE','',0,'2023-04-25 12:21:17.291',NULL,'2023-04-25 12:26:02.820','2023-04-25 12:21:17.294','2023-04-25 10:26:02.820',NULL),('ea36dd21-10da-11ee-b636-a0510b46b473',11,'bd51960a-10d5-11ee-b636-a0510b46b473','Acte MANIP V2',2,'FREE','',0,'2023-06-22 10:58:11.344',NULL,'2023-06-22 11:04:52.557','2023-06-22 10:58:11.347','2023-06-22 09:04:52.558',NULL),('ec7935d6-0f72-11ee-8712-a0510b46b473',11,'e4b67639-0f72-11ee-8712-a0510b46b473','Acte bouche',1,'FREE','',0,'2023-06-20 16:01:16.312',NULL,'2023-06-20 16:53:03.199','2023-06-20 16:01:16.313','2023-06-20 14:53:03.200',NULL),('ed85304d-e024-11ed-bb13-00d86184ce3d',11,'e86b5c99-e024-11ed-bb13-00d86184ce3d','Acte Autre',1,'FREE','',0,'2023-04-21 11:14:32.672',NULL,'2023-04-25 10:02:04.262','2023-04-21 11:14:32.675','2023-04-25 08:02:04.262',NULL),('efcc55aa-14e3-11ee-b3b1-00d86184ce3d',11,'f72be411-1103-11ee-b636-a0510b46b473','Acte verif après ref29',3,'FREE','',0,'2023-06-27 14:12:50.834',NULL,'2023-06-27 14:41:30.559','2023-06-27 14:12:50.836','2023-06-27 12:41:30.559',NULL),('f3d790be-df83-11ed-b6c2-00d86184ce3d',11,'ee09109f-df83-11ed-b6c2-00d86184ce3d','Acte Autre',1,'FREE','',0,'2023-04-20 16:02:14.305',NULL,'2023-04-20 16:11:32.198','2023-04-20 16:02:14.305','2023-04-20 14:11:32.199',NULL),('f58279e9-2576-11ee-b81b-a0510b46b473',11,'49f1e276-256f-11ee-91d6-a0510b46b473','Acte redemarrage pc',2,'FREE','',0,'2023-07-18 16:25:35.040',NULL,'2023-07-18 16:45:14.939','2023-07-18 16:25:35.041','2023-07-18 14:45:14.940',NULL),('f8ef8fe7-10f4-11ee-b636-a0510b46b473',11,'ed94fe78-10f4-11ee-b636-a0510b46b473','Acte bouche manip V1',1,'FREE','',0,'2023-06-22 14:04:42.958',NULL,'2023-06-22 14:48:21.212','2023-06-22 14:04:42.960','2023-06-22 12:48:21.212',NULL),('fc5f9260-e353-11ed-8c5e-00d86184ce3d',11,'6175c1d5-e350-11ed-8c5e-00d86184ce3d','Acte VIDEO manip V2',3,'FREE','',0,'2023-04-25 12:28:57.426',NULL,'2023-04-25 12:29:57.149','2023-04-25 12:28:57.429','2023-04-25 10:29:57.149',NULL),('fdea0616-deae-11ed-9cc3-00d86184ce3d',11,'eb12a131-deae-11ed-9cc3-00d86184ce3d','Acte bouche x 6',1,'FREE','',0,'2023-04-19 14:37:48.400',NULL,'2023-04-19 14:43:39.609','2023-04-19 14:37:48.402','2023-04-19 12:43:39.609',NULL),('ff6745bb-1bff-11ee-9323-a0510b46b473',11,'8a8cc548-1bf9-11ee-9323-a0510b46b473','Acte manip V2',2,'FREE','',0,'2023-07-06 15:21:21.063',NULL,'2023-07-06 15:26:59.804','2023-07-06 15:21:21.065','2023-07-06 13:26:59.804',NULL),('ffdb9942-de80-11ed-9cc3-00d86184ce3d',11,'f29210da-de80-11ed-9cc3-00d86184ce3d','Acte Guide',1,'FREE','',0,'2023-04-19 09:08:34.811',NULL,'2023-04-19 10:18:07.126','2023-04-19 09:08:34.813','2023-04-19 08:18:07.126','2023-04-19 10:14:51.270');
/*!40000 ALTER TABLE `Act` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AddressInfo`
--

DROP TABLE IF EXISTS `AddressInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AddressInfo` (
  `uuid` varchar(36) NOT NULL,
  `line0` varchar(255) DEFAULT NULL,
  `line1` varchar(255) DEFAULT NULL,
  `line2` varchar(255) DEFAULT NULL,
  `detail` varchar(255) DEFAULT NULL,
  `cityName` varchar(255) DEFAULT NULL,
  `cityState` varchar(255) DEFAULT NULL,
  `cityZip` varchar(255) DEFAULT NULL,
  `countryName` varchar(255) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AddressInfo`
--

LOCK TABLES `AddressInfo` WRITE;
/*!40000 ALTER TABLE `AddressInfo` DISABLE KEYS */;
INSERT INTO `AddressInfo` VALUES ('1fd355d2-43be-4ef9-a9e2-65df5d36a899','Lebege','','','','labege','','31000','France','2023-04-17 08:59:50.829','2023-04-17 10:59:51.141'),('4caacc66-8838-11ec-89bc-2e174fce41cd','Route du test','','','','Toulouse','','31100','France','2023-04-17 08:59:51.159','2023-04-17 10:59:51.199');
/*!40000 ALTER TABLE `AddressInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Assistant`
--

DROP TABLE IF EXISTS `Assistant`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Assistant` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `credentialsId` varchar(36) DEFAULT NULL,
  `personInfoId` varchar(36) NOT NULL,
  `phoneInfoId` varchar(36) NOT NULL,
  `addressInfoId` varchar(36) NOT NULL,
  `officeId` varchar(36) DEFAULT NULL,
  `patientRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'READ_ONLY',
  `actRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'NOTHING',
  `discussionRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'NOTHING',
  `tempPassword` varchar(32) DEFAULT NULL,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `credentialsId` (`credentialsId`),
  KEY `personInfoId` (`personInfoId`),
  KEY `phoneInfoId` (`phoneInfoId`),
  KEY `addressInfoId` (`addressInfoId`),
  KEY `officeId` (`officeId`),
  CONSTRAINT `Assistant_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_2` FOREIGN KEY (`credentialsId`) REFERENCES `Credentials` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_3` FOREIGN KEY (`personInfoId`) REFERENCES `PersonInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_4` FOREIGN KEY (`phoneInfoId`) REFERENCES `PhoneInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_5` FOREIGN KEY (`addressInfoId`) REFERENCES `AddressInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_6` FOREIGN KEY (`officeId`) REFERENCES `Office` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Assistant`
--

LOCK TABLES `Assistant` WRITE;
/*!40000 ALTER TABLE `Assistant` DISABLE KEYS */;
/*!40000 ALTER TABLE `Assistant` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CircleOrder`
--

DROP TABLE IF EXISTS `CircleOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CircleOrder` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `actId` varchar(36) NOT NULL,
  `title` varchar(64) DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `createdById` varchar(36) DEFAULT NULL,
  `updatedById` varchar(36) DEFAULT NULL,
  `displayId` mediumint unsigned DEFAULT NULL,
  `json` text NOT NULL,
  `metadata` text NOT NULL,
  `status` enum('NOT_SENT','WAITING_WOW_API','SENDING_WOW_API','SENDING_CIRCLE_API','SENT','CANCELLED','DELIVERY') NOT NULL DEFAULT 'NOT_SENT',
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `actId` (`actId`),
  CONSTRAINT `CircleOrder_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `CircleOrder_ibfk_2` FOREIGN KEY (`actId`) REFERENCES `Act` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CircleOrder`
--

LOCK TABLES `CircleOrder` WRITE;
/*!40000 ALTER TABLE `CircleOrder` DISABLE KEYS */;
/*!40000 ALTER TABLE `CircleOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CircleOrderFile`
--

DROP TABLE IF EXISTS `CircleOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CircleOrderFile` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('FORM','SCAN') NOT NULL,
  PRIMARY KEY (`orderId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `CircleOrderFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `CircleOrderFile_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `CircleOrder` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `CircleOrderFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CircleOrderFile`
--

LOCK TABLES `CircleOrderFile` WRITE;
/*!40000 ALTER TABLE `CircleOrderFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `CircleOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Config`
--

DROP TABLE IF EXISTS `Config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Config` (
  `id` mediumint unsigned NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `fullRetrieve` tinyint(1) DEFAULT '0',
  `syncEnabled` tinyint(1) DEFAULT '1',
  `showOcclusionScan` tinyint(1) DEFAULT '1',
  `showOpenStlWarning` tinyint(1) DEFAULT '1',
  `showMarginLinesWarning` tinyint(1) DEFAULT '1',
  `showDeleteConfirmation` tinyint(1) DEFAULT '1',
  `showSyncInfo` tinyint(1) DEFAULT '1',
  `downloadAtFullRetrieve` tinyint(1) DEFAULT '1',
  `lagSound` tinyint(1) DEFAULT '0',
  `lostSound` tinyint(1) DEFAULT '0',
  `emailNotifications` tinyint(1) DEFAULT '1',
  `logout` mediumint DEFAULT '10',
  `language` varchar(2) DEFAULT NULL,
  `diagnosticMode` tinyint(1) DEFAULT '0',
  `repairMode` tinyint(1) DEFAULT '0',
  `flipMaxillaryH` tinyint(1) DEFAULT '0',
  `flipMaxillaryV` tinyint(1) DEFAULT '0',
  `flipMandibleH` tinyint(1) DEFAULT '0',
  `flipMandibleV` tinyint(1) DEFAULT '0',
  `showFlipPopupMaxillary` tinyint(1) DEFAULT '1',
  `showFlipPopupMandible` tinyint(1) DEFAULT '1',
  `enableUserSharing` tinyint(1) DEFAULT '0',
  `lostTrackingRectangle` tinyint(1) DEFAULT '1',
  `showAllPatients` tinyint(1) DEFAULT '0',
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  PRIMARY KEY (`id`,`ownerId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Config`
--

LOCK TABLES `Config` WRITE;
/*!40000 ALTER TABLE `Config` DISABLE KEYS */;
INSERT INTO `Config` VALUES (1,1,0,1,1,1,1,1,1,1,0,0,1,10,'FR',0,0,0,0,0,0,1,1,0,1,0,'2022-09-01 14:34:37.000','2023-04-17 10:59:51.199','2023-04-17 08:59:51.161'),(1,11,0,1,1,1,1,1,1,1,0,0,1,10,'FR',0,0,0,0,0,0,1,1,1,0,1,'2022-12-08 10:16:10.000','2023-04-17 13:54:35.898','2023-06-21 13:01:13.527');
/*!40000 ALTER TABLE `Config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Contact`
--

DROP TABLE IF EXISTS `Contact`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Contact` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `professionalId` mediumint unsigned NOT NULL COMMENT 'Le professionnel contact',
  `officeId` varchar(36) DEFAULT NULL,
  `status` enum('INVITATIONSENT','INVITATIONRECEIVED','ACCEPTED','REJECTED') NOT NULL DEFAULT 'INVITATIONSENT',
  `comments` text,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `uniqueContactPro` (`ownerId`,`professionalId`),
  KEY `professionalId` (`professionalId`),
  KEY `officeId` (`officeId`),
  CONSTRAINT `Contact_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Contact_ibfk_2` FOREIGN KEY (`professionalId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Contact_ibfk_3` FOREIGN KEY (`officeId`) REFERENCES `Office` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Contact`
--

LOCK TABLES `Contact` WRITE;
/*!40000 ALTER TABLE `Contact` DISABLE KEYS */;
INSERT INTO `Contact` VALUES ('629739b4-33e3-4b2f-b277-2dc5a90159b7',11,1,NULL,'ACCEPTED','',NULL,'2022-12-08 10:16:11.000','2023-04-17 08:59:51.199','2023-04-17 10:59:51.199'),('7a50528f-85c6-42c2-b98b-898a151370a7',11,11,NULL,'ACCEPTED','',NULL,'2022-12-08 10:16:10.000','2023-04-17 08:59:51.141','2023-04-17 10:59:51.141');
/*!40000 ALTER TABLE `Contact` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ContactNotification`
--

DROP TABLE IF EXISTS `ContactNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ContactNotification` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `contactId` varchar(36) DEFAULT NULL,
  `rescueDisplayName` varchar(50) DEFAULT NULL,
  `event` enum('RECEIVED','RECEIVED_TO_ACCEPTED','RECEIVED_TO_REJECTED','SENT_TO_ACCEPTED','SENT_TO_REJECTED','ACTIVATION_TIMEOUT') NOT NULL DEFAULT 'RECEIVED',
  `unread` tinyint(1) NOT NULL DEFAULT '1',
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `contactId` (`contactId`),
  CONSTRAINT `ContactNotification_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ContactNotification_ibfk_2` FOREIGN KEY (`contactId`) REFERENCES `Contact` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ContactNotification`
--

LOCK TABLES `ContactNotification` WRITE;
/*!40000 ALTER TABLE `ContactNotification` DISABLE KEYS */;
/*!40000 ALTER TABLE `ContactNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Credentials`
--

DROP TABLE IF EXISTS `Credentials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Credentials` (
  `uuid` varchar(36) NOT NULL,
  `login` varchar(255) NOT NULL,
  `password` varchar(100) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `login` (`login`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Credentials`
--

LOCK TABLES `Credentials` WRITE;
/*!40000 ALTER TABLE `Credentials` DISABLE KEYS */;
INSERT INTO `Credentials` VALUES ('2e995095-88b2-11ec-89bc-2e174fce41cd','biotech',NULL,'2023-04-17 08:59:51.157','2023-04-17 10:59:51.199'),('c6874010-7819-4ad2-8eba-52219ee74012','ilisio','0cfdfafdab3b1bb2adcd9afffb070024567c394e0f59f2f695094a130276f1fd','2023-04-17 08:59:50.827','2023-04-17 10:59:51.141');
/*!40000 ALTER TABLE `Credentials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Discussion`
--

DROP TABLE IF EXISTS `Discussion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Discussion` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `selfImplied` tinyint(1) NOT NULL DEFAULT '0',
  `officeId` varchar(36) DEFAULT NULL,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`,`ownerId`),
  KEY `ownerId` (`ownerId`),
  KEY `officeId` (`officeId`),
  CONSTRAINT `Discussion_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Discussion_ibfk_2` FOREIGN KEY (`officeId`) REFERENCES `Office` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Discussion`
--

LOCK TABLES `Discussion` WRITE;
/*!40000 ALTER TABLE `Discussion` DISABLE KEYS */;
/*!40000 ALTER TABLE `Discussion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `File`
--

DROP TABLE IF EXISTS `File`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `File` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `path` text,
  `tag` text,
  `originalName` text NOT NULL,
  `originalId` varchar(36) NOT NULL,
  `metadata` text,
  `type` enum('BIN','JSON','PDF','PLY','STL','PNG','XYZ','ZIP') NOT NULL,
  `version` mediumint unsigned DEFAULT '0',
  `status` enum('CREATED','UPDATED','SYNCED','ERROR') DEFAULT 'CREATED',
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `version` (`originalId`,`version`),
  CONSTRAINT `File_ibfk_1` FOREIGN KEY (`originalId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `File`
--

LOCK TABLES `File` WRITE;
/*!40000 ALTER TABLE `File` DISABLE KEYS */;
INSERT INTO `File` VALUES ('00060e63-e352-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/6175c1d5-e350-11ed-8c5e-00d86184ce3d/session_71ba03b6-e350-11ed-8c5e-00d86184ce3d/occlusion_71bbf096-e350-11ed-8c5e-00d86184ce3d/scan_b71a45bb-e351-11ed-8c5e-00d86184ce3d/00060e63-e352-11ed-8c5e-00d86184ce3d.zip','PATIENT_6175c1d5-e350-11ed-8c5e-00d86184ce3d_ACT_71ba03b6-e350-11ed-8c5e-00d86184ce3d_SESS_71bbf096-e350-11ed-8c5e-00d86184ce3d_TOSC_b71a45bb-e351-11ed-8c5e-00d86184ce3d_MODEL','00060e63-e352-11ed-8c5e-00d86184ce3d.zip','00060e63-e352-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.13.1.1.5\",\"modelMatrix\":\"0.388472,0.876882,-0.28314,0,-0.921461,0.369678,-0.119367,0,-4.45287e-09,0.307273,0.951621,0,-27.2282,-14.4682,-5.66537,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-25 12:14:44.557','2023-04-25 10:14:45.547',NULL),('000625ae-e352-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/6175c1d5-e350-11ed-8c5e-00d86184ce3d/session_71ba03b6-e350-11ed-8c5e-00d86184ce3d/occlusion_71bbf096-e350-11ed-8c5e-00d86184ce3d/scan_b71a45bb-e351-11ed-8c5e-00d86184ce3d/000625ae-e352-11ed-8c5e-00d86184ce3d.png','PATIENT_6175c1d5-e350-11ed-8c5e-00d86184ce3d_ACT_71ba03b6-e350-11ed-8c5e-00d86184ce3d_SESS_71bbf096-e350-11ed-8c5e-00d86184ce3d_TOSC_b71a45bb-e351-11ed-8c5e-00d86184ce3d_SNAPS','000625ae-e352-11ed-8c5e-00d86184ce3d.png','000625ae-e352-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.13.1.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-25 12:14:44.558','2023-04-25 10:14:45.548',NULL),('00178787-2ae6-11ee-95bc-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_b5fe1002-2ae0-11ee-95bc-a0510b46b473/occlusion_b6012772-2ae0-11ee-95bc-a0510b46b473/scan_ba803508-2ae5-11ee-95bc-a0510b46b473/00178787-2ae6-11ee-95bc-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_b5fe1002-2ae0-11ee-95bc-a0510b46b473_SESS_b6012772-2ae0-11ee-95bc-a0510b46b473_TOSC_ba803508-2ae5-11ee-95bc-a0510b46b473_MODEL','00178787-2ae6-11ee-95bc-a0510b46b473.zip','00178787-2ae6-11ee-95bc-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.8.1.6\",\"modelMatrix\":\"0.332313,0.925894,-0.179691,0,-0.943169,0.326226,-0.0633117,0,4.65219e-09,0.190519,0.981684,0,-28.1404,-13.8513,-9.37918,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-25 14:23:02.745','2023-07-25 12:23:03.414',NULL),('00179dcb-2ae6-11ee-95bc-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_b5fe1002-2ae0-11ee-95bc-a0510b46b473/occlusion_b6012772-2ae0-11ee-95bc-a0510b46b473/scan_ba803508-2ae5-11ee-95bc-a0510b46b473/00179dcb-2ae6-11ee-95bc-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_b5fe1002-2ae0-11ee-95bc-a0510b46b473_SESS_b6012772-2ae0-11ee-95bc-a0510b46b473_TOSC_ba803508-2ae5-11ee-95bc-a0510b46b473_SNAPS','00179dcb-2ae6-11ee-95bc-a0510b46b473.png','00179dcb-2ae6-11ee-95bc-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.8.1.6 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-25 14:23:02.745','2023-07-25 12:23:03.414',NULL),('001f6bb7-0f42-11ee-8712-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_55019e04-0f41-11ee-8712-a0510b46b473/occlusion_550492f3-0f41-11ee-8712-a0510b46b473/scan_b3f8491f-0f41-11ee-8712-a0510b46b473/001f6bb7-0f42-11ee-8712-a0510b46b473.zip','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_55019e04-0f41-11ee-8712-a0510b46b473_SESS_550492f3-0f41-11ee-8712-a0510b46b473_TOSC_b3f8491f-0f41-11ee-8712-a0510b46b473_MODEL','001f6bb7-0f42-11ee-8712-a0510b46b473.zip','001f6bb7-0f42-11ee-8712-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.2.1.2\",\"modelMatrix\":\"0.0512574,0.968245,-0.244694,0,-0.998686,0.049695,-0.0125589,0,6.64354e-11,0.245016,0.969519,0,-23.366,-17.5555,-7.21617,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-20 10:11:03.938','2023-06-20 08:11:04.531',NULL),('001f825f-0f42-11ee-8712-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_55019e04-0f41-11ee-8712-a0510b46b473/occlusion_550492f3-0f41-11ee-8712-a0510b46b473/scan_b3f8491f-0f41-11ee-8712-a0510b46b473/001f825f-0f42-11ee-8712-a0510b46b473.png','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_55019e04-0f41-11ee-8712-a0510b46b473_SESS_550492f3-0f41-11ee-8712-a0510b46b473_TOSC_b3f8491f-0f41-11ee-8712-a0510b46b473_SNAPS','001f825f-0f42-11ee-8712-a0510b46b473.png','001f825f-0f42-11ee-8712-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.2.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-20 10:11:03.938','2023-06-20 08:11:04.531',NULL),('0025d89e-2aec-11ee-97fa-a0510b46b473',11,'/home/scan/.data//2023/11/4baca484-2aeb-11ee-97fa-a0510b46b473/session_4ff1c1c7-2aeb-11ee-97fa-a0510b46b473/occlusion_4ff4b712-2aeb-11ee-97fa-a0510b46b473/scan_c6dde7b7-2aeb-11ee-97fa-a0510b46b473/0025d89e-2aec-11ee-97fa-a0510b46b473.zip','PATIENT_4baca484-2aeb-11ee-97fa-a0510b46b473_ACT_4ff1c1c7-2aeb-11ee-97fa-a0510b46b473_SESS_4ff4b712-2aeb-11ee-97fa-a0510b46b473_TOSC_c6dde7b7-2aeb-11ee-97fa-a0510b46b473_MODEL','0025d89e-2aec-11ee-97fa-a0510b46b473.zip','0025d89e-2aec-11ee-97fa-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.37.1.1.2\",\"modelMatrix\":\"0.765911,0.591137,-0.252859,0,-0.642947,0.704192,-0.301218,0,-4.71676e-10,0.393281,0.919418,0,-32.4044,-0.343248,-10.2149,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-25 15:05:59.819','2023-07-25 13:06:00.336',NULL),('0025f1ad-2aec-11ee-97fa-a0510b46b473',11,'/home/scan/.data//2023/11/4baca484-2aeb-11ee-97fa-a0510b46b473/session_4ff1c1c7-2aeb-11ee-97fa-a0510b46b473/occlusion_4ff4b712-2aeb-11ee-97fa-a0510b46b473/scan_c6dde7b7-2aeb-11ee-97fa-a0510b46b473/0025f1ad-2aec-11ee-97fa-a0510b46b473.png','PATIENT_4baca484-2aeb-11ee-97fa-a0510b46b473_ACT_4ff1c1c7-2aeb-11ee-97fa-a0510b46b473_SESS_4ff4b712-2aeb-11ee-97fa-a0510b46b473_TOSC_c6dde7b7-2aeb-11ee-97fa-a0510b46b473_SNAPS','0025f1ad-2aec-11ee-97fa-a0510b46b473.png','0025f1ad-2aec-11ee-97fa-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.37.1.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-25 15:05:59.819','2023-07-25 13:06:00.339',NULL),('00d2f12b-e028-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_ed85304d-e024-11ed-bb13-00d86184ce3d/occlusion_ed88a64f-e024-11ed-bb13-00d86184ce3d/scan_cdae4ed1-e027-11ed-bb13-00d86184ce3d/00d2f12b-e028-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_ed85304d-e024-11ed-bb13-00d86184ce3d_SESS_ed88a64f-e024-11ed-bb13-00d86184ce3d_TOSC_cdae4ed1-e027-11ed-bb13-00d86184ce3d_MODEL','00d2f12b-e028-11ed-bb13-00d86184ce3d.zip','00d2f12b-e028-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.1.1.3\",\"modelMatrix\":\"-0.837332,0.540347,-0.0830632,0,-0.546694,-0.827611,0.127222,0,-3.21214e-09,0.151937,0.98839,0,5.46468,-31.9844,-6.44276,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 11:36:33.549','2023-04-21 09:36:34.182',NULL),('00d319e0-e028-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_ed85304d-e024-11ed-bb13-00d86184ce3d/occlusion_ed88a64f-e024-11ed-bb13-00d86184ce3d/scan_cdae4ed1-e027-11ed-bb13-00d86184ce3d/00d319e0-e028-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_ed85304d-e024-11ed-bb13-00d86184ce3d_SESS_ed88a64f-e024-11ed-bb13-00d86184ce3d_TOSC_cdae4ed1-e027-11ed-bb13-00d86184ce3d_SNAPS','00d319e0-e028-11ed-bb13-00d86184ce3d.png','00d319e0-e028-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.1.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 11:36:33.550','2023-04-21 09:36:34.182',NULL),('013dd6bf-158b-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/634153bc-1587-11ee-b3b1-00d86184ce3d/session_6e9df503-1587-11ee-b3b1-00d86184ce3d/occlusion_6ea0d9b2-1587-11ee-b3b1-00d86184ce3d/scan_b1511fa4-158a-11ee-b3b1-00d86184ce3d/013dd6bf-158b-11ee-b3b1-00d86184ce3d.zip','PATIENT_634153bc-1587-11ee-b3b1-00d86184ce3d_ACT_6e9df503-1587-11ee-b3b1-00d86184ce3d_SESS_6ea0d9b2-1587-11ee-b3b1-00d86184ce3d_TOSC_b1511fa4-158a-11ee-b3b1-00d86184ce3d_MODEL','013dd6bf-158b-11ee-b3b1-00d86184ce3d.zip','013dd6bf-158b-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.24.1.1.5\",\"modelMatrix\":\"0.571571,0.805258,-0.157691,0,-0.820553,0.560917,-0.109843,0,3.24458e-09,0.192177,0.98136,0,-32.9463,-12.3631,-12.2196,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-28 10:08:46.053','2023-06-28 08:08:46.740',NULL),('013dec16-158b-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/634153bc-1587-11ee-b3b1-00d86184ce3d/session_6e9df503-1587-11ee-b3b1-00d86184ce3d/occlusion_6ea0d9b2-1587-11ee-b3b1-00d86184ce3d/scan_b1511fa4-158a-11ee-b3b1-00d86184ce3d/013dec16-158b-11ee-b3b1-00d86184ce3d.png','PATIENT_634153bc-1587-11ee-b3b1-00d86184ce3d_ACT_6e9df503-1587-11ee-b3b1-00d86184ce3d_SESS_6ea0d9b2-1587-11ee-b3b1-00d86184ce3d_TOSC_b1511fa4-158a-11ee-b3b1-00d86184ce3d_SNAPS','013dec16-158b-11ee-b3b1-00d86184ce3d.png','013dec16-158b-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.24.1.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-28 10:08:46.053','2023-06-28 08:08:46.740',NULL),('02234b3e-1589-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/634153bc-1587-11ee-b3b1-00d86184ce3d/session_6e9df503-1587-11ee-b3b1-00d86184ce3d/occlusion_6ea0d9b2-1587-11ee-b3b1-00d86184ce3d/scan_be77c45b-1588-11ee-b3b1-00d86184ce3d/02234b3e-1589-11ee-b3b1-00d86184ce3d.zip','PATIENT_634153bc-1587-11ee-b3b1-00d86184ce3d_ACT_6e9df503-1587-11ee-b3b1-00d86184ce3d_SESS_6ea0d9b2-1587-11ee-b3b1-00d86184ce3d_TOSC_be77c45b-1588-11ee-b3b1-00d86184ce3d_MODEL','02234b3e-1589-11ee-b3b1-00d86184ce3d.zip','02234b3e-1589-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.24.1.1.2\",\"modelMatrix\":\"0.719087,0.687909,-0.0984602,0,-0.69492,0.711833,-0.101884,0,-2.76761e-09,0.141686,0.989912,0,-9.98043,-14.7631,-17.2895,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-28 09:54:28.563','2023-06-28 07:54:29.174',NULL),('0223607e-1589-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/634153bc-1587-11ee-b3b1-00d86184ce3d/session_6e9df503-1587-11ee-b3b1-00d86184ce3d/occlusion_6ea0d9b2-1587-11ee-b3b1-00d86184ce3d/scan_be77c45b-1588-11ee-b3b1-00d86184ce3d/0223607e-1589-11ee-b3b1-00d86184ce3d.png','PATIENT_634153bc-1587-11ee-b3b1-00d86184ce3d_ACT_6e9df503-1587-11ee-b3b1-00d86184ce3d_SESS_6ea0d9b2-1587-11ee-b3b1-00d86184ce3d_TOSC_be77c45b-1588-11ee-b3b1-00d86184ce3d_SNAPS','0223607e-1589-11ee-b3b1-00d86184ce3d.png','0223607e-1589-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.24.1.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-28 09:54:28.564','2023-06-28 07:54:29.182',NULL),('027ad070-1fe9-11ee-b7d5-a0510b46b473',11,'/home/scan/.data//2023/11/6a143ccb-1fe8-11ee-b7d5-a0510b46b473/session_7758b704-1fe8-11ee-b7d5-a0510b46b473/occlusion_775bad6c-1fe8-11ee-b7d5-a0510b46b473/scan_ce26273d-1fe8-11ee-b7d5-a0510b46b473/027ad070-1fe9-11ee-b7d5-a0510b46b473.zip','PATIENT_6a143ccb-1fe8-11ee-b7d5-a0510b46b473_ACT_7758b704-1fe8-11ee-b7d5-a0510b46b473_SESS_775bad6c-1fe8-11ee-b7d5-a0510b46b473_TOSC_ce26273d-1fe8-11ee-b7d5-a0510b46b473_MODEL','027ad070-1fe9-11ee-b7d5-a0510b46b473.zip','027ad070-1fe9-11ee-b7d5-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.32.1.1.2\",\"modelMatrix\":\"0.77042,0.620548,-0.146195,0,-0.637537,0.74989,-0.176667,0,6.21034e-09,0.229313,0.973353,0,-30.5124,-9.00831,-10.6934,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-11 14:46:52.450','2023-07-11 12:46:54.603',NULL),('027c15e6-1fe9-11ee-b7d5-a0510b46b473',11,'/home/scan/.data//2023/11/6a143ccb-1fe8-11ee-b7d5-a0510b46b473/session_7758b704-1fe8-11ee-b7d5-a0510b46b473/occlusion_775bad6c-1fe8-11ee-b7d5-a0510b46b473/scan_ce26273d-1fe8-11ee-b7d5-a0510b46b473/027c15e6-1fe9-11ee-b7d5-a0510b46b473.png','PATIENT_6a143ccb-1fe8-11ee-b7d5-a0510b46b473_ACT_7758b704-1fe8-11ee-b7d5-a0510b46b473_SESS_775bad6c-1fe8-11ee-b7d5-a0510b46b473_TOSC_ce26273d-1fe8-11ee-b7d5-a0510b46b473_SNAPS','027c15e6-1fe9-11ee-b7d5-a0510b46b473.png','027c15e6-1fe9-11ee-b7d5-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.32.1.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-11 14:46:52.459','2023-07-11 12:46:54.604',NULL),('02a9cbb4-2ae7-11ee-95bc-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_b5fe1002-2ae0-11ee-95bc-a0510b46b473/occlusion_b6012772-2ae0-11ee-95bc-a0510b46b473/scan_c821679d-2ae6-11ee-95bc-a0510b46b473/02a9cbb4-2ae7-11ee-95bc-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_b5fe1002-2ae0-11ee-95bc-a0510b46b473_SESS_b6012772-2ae0-11ee-95bc-a0510b46b473_TOSC_c821679d-2ae6-11ee-95bc-a0510b46b473_MODEL','02a9cbb4-2ae7-11ee-95bc-a0510b46b473.zip','02a9cbb4-2ae7-11ee-95bc-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.8.1.9\",\"modelMatrix\":\"0.975557,0.19282,-0.105396,0,-0.219745,0.856023,-0.467906,0,-1.22728e-10,0.479629,0.877471,0,-27.7644,6.76182,-11.5772,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-25 14:30:16.555','2023-07-25 12:30:17.062',NULL),('02ab0db8-2ae7-11ee-95bc-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_b5fe1002-2ae0-11ee-95bc-a0510b46b473/occlusion_b6012772-2ae0-11ee-95bc-a0510b46b473/scan_c821679d-2ae6-11ee-95bc-a0510b46b473/02ab0db8-2ae7-11ee-95bc-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_b5fe1002-2ae0-11ee-95bc-a0510b46b473_SESS_b6012772-2ae0-11ee-95bc-a0510b46b473_TOSC_c821679d-2ae6-11ee-95bc-a0510b46b473_SNAPS','02ab0db8-2ae7-11ee-95bc-a0510b46b473.png','02ab0db8-2ae7-11ee-95bc-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.8.1.9 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-25 14:30:16.564','2023-07-25 12:30:17.063',NULL),('03263f71-15bf-11ee-a062-a0510b46b473',11,'/home/scan/.data//2023/11/142e7037-15b6-11ee-b3b1-00d86184ce3d/session_c41888b6-15ba-11ee-b3b1-00d86184ce3d/occlusion_c41a4d8e-15ba-11ee-b3b1-00d86184ce3d/scan_d6f58c23-15be-11ee-a062-a0510b46b473/03263f71-15bf-11ee-a062-a0510b46b473.zip','PATIENT_142e7037-15b6-11ee-b3b1-00d86184ce3d_ACT_c41888b6-15ba-11ee-b3b1-00d86184ce3d_SESS_c41a4d8e-15ba-11ee-b3b1-00d86184ce3d_TOSC_d6f58c23-15be-11ee-a062-a0510b46b473_MODEL','03263f71-15bf-11ee-a062-a0510b46b473.zip','03263f71-15bf-11ee-a062-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.25.2.1.3\",\"modelMatrix\":\"0.812399,0.563848,-0.148604,0,-0.583102,0.785574,-0.207041,0,5.38655e-09,0.254851,0.96698,0,-17.4077,7.01325,-5.66122,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-28 16:21:03.084','2023-06-28 14:21:03.560',NULL),('03264efa-15bf-11ee-a062-a0510b46b473',11,'/home/scan/.data//2023/11/142e7037-15b6-11ee-b3b1-00d86184ce3d/session_c41888b6-15ba-11ee-b3b1-00d86184ce3d/occlusion_c41a4d8e-15ba-11ee-b3b1-00d86184ce3d/scan_d6f58c23-15be-11ee-a062-a0510b46b473/03264efa-15bf-11ee-a062-a0510b46b473.png','PATIENT_142e7037-15b6-11ee-b3b1-00d86184ce3d_ACT_c41888b6-15ba-11ee-b3b1-00d86184ce3d_SESS_c41a4d8e-15ba-11ee-b3b1-00d86184ce3d_TOSC_d6f58c23-15be-11ee-a062-a0510b46b473_SNAPS','03264efa-15bf-11ee-a062-a0510b46b473.png','03264efa-15bf-11ee-a062-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.25.2.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-28 16:21:03.084','2023-06-28 14:21:03.560',NULL),('038c0ceb-2a37-11ee-9e90-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_b144ba33-2a36-11ee-9e90-a0510b46b473/occlusion_b147bba1-2a36-11ee-9e90-a0510b46b473/scan_d9d9fbc9-2a36-11ee-9e90-a0510b46b473/038c0ceb-2a37-11ee-9e90-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_b144ba33-2a36-11ee-9e90-a0510b46b473_SESS_b147bba1-2a36-11ee-9e90-a0510b46b473_TOSC_d9d9fbc9-2a36-11ee-9e90-a0510b46b473_MODEL','038c0ceb-2a37-11ee-9e90-a0510b46b473.zip','038c0ceb-2a37-11ee-9e90-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.6.1.1\",\"modelMatrix\":\"0.690107,0.644164,-0.329856,0,-0.723708,0.614257,-0.314541,0,-9.44301e-10,0.455786,0.890089,0,-28.3982,-1.34694,0.0856722,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,'2023-07-24 17:30:48.031','2023-07-24 17:30:26.614','2023-07-24 15:30:48.037',NULL),('038c2739-2a37-11ee-9e90-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_b144ba33-2a36-11ee-9e90-a0510b46b473/occlusion_b147bba1-2a36-11ee-9e90-a0510b46b473/scan_d9d9fbc9-2a36-11ee-9e90-a0510b46b473/038c2739-2a37-11ee-9e90-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_b144ba33-2a36-11ee-9e90-a0510b46b473_SESS_b147bba1-2a36-11ee-9e90-a0510b46b473_TOSC_d9d9fbc9-2a36-11ee-9e90-a0510b46b473_SNAPS','038c2739-2a37-11ee-9e90-a0510b46b473.png','038c2739-2a37-11ee-9e90-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.6.1.1 Snapshot\"}','PNG',0,'CREATED',0,'2023-07-24 17:30:48.031','2023-07-24 17:30:26.614','2023-07-24 15:30:48.041',NULL),('03cc2157-1108-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_ceaea325-1107-11ee-b636-a0510b46b473/occlusion_ceb199a7-1107-11ee-b636-a0510b46b473/scan_cfd38008-1107-11ee-b636-a0510b46b473/03cc2157-1108-11ee-b636-a0510b46b473.zip','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_ceaea325-1107-11ee-b636-a0510b46b473_SESS_ceb199a7-1107-11ee-b636-a0510b46b473_TOSC_cfd38008-1107-11ee-b636-a0510b46b473_MODEL','03cc2157-1108-11ee-b636-a0510b46b473.zip','03cc2157-1108-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.20.2.1.1\",\"modelMatrix\":\"0.946013,0.278877,-0.165188,0,-0.324129,0.81394,-0.482122,0,-5.11005e-09,0.509636,0.86039,0,-25.5596,7.43238,-10.7886,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 16:21:01.618','2023-06-22 14:21:02.090',NULL),('03cc390d-1108-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_ceaea325-1107-11ee-b636-a0510b46b473/occlusion_ceb199a7-1107-11ee-b636-a0510b46b473/scan_cfd38008-1107-11ee-b636-a0510b46b473/03cc390d-1108-11ee-b636-a0510b46b473.png','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_ceaea325-1107-11ee-b636-a0510b46b473_SESS_ceb199a7-1107-11ee-b636-a0510b46b473_TOSC_cfd38008-1107-11ee-b636-a0510b46b473_SNAPS','03cc390d-1108-11ee-b636-a0510b46b473.png','03cc390d-1108-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.20.2.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 16:21:01.619','2023-06-22 14:21:02.090',NULL),('04ab2fe6-2631-11ee-81dd-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_62519c59-261f-11ee-8042-a0510b46b473/occlusion_6253caa6-261f-11ee-8042-a0510b46b473/scan_932036cb-2630-11ee-81dd-a0510b46b473/04ab2fe6-2631-11ee-81dd-a0510b46b473.zip','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_62519c59-261f-11ee-8042-a0510b46b473_SESS_6253caa6-261f-11ee-8042-a0510b46b473_BOSC_932036cb-2630-11ee-81dd-a0510b46b473_MODEL','04ab2fe6-2631-11ee-81dd-a0510b46b473.zip','04ab2fe6-2631-11ee-81dd-a0510b46b473','{\"displayTitle\":\"Mandibule 1.34.1.1.2\",\"modelMatrix\":\"0.644584,0.714089,-0.273108,0,-0.764533,0.602054,-0.230259,0,-1.21994e-08,0.357221,0.93402,0,1.05024,-30.8407,-7.93551,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-19 14:37:26.864','2023-07-19 12:37:27.761',NULL),('04ac6952-2631-11ee-81dd-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_62519c59-261f-11ee-8042-a0510b46b473/occlusion_6253caa6-261f-11ee-8042-a0510b46b473/scan_932036cb-2630-11ee-81dd-a0510b46b473/04ac6952-2631-11ee-81dd-a0510b46b473.png','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_62519c59-261f-11ee-8042-a0510b46b473_SESS_6253caa6-261f-11ee-8042-a0510b46b473_BOSC_932036cb-2630-11ee-81dd-a0510b46b473_SNAPS','04ac6952-2631-11ee-81dd-a0510b46b473.png','04ac6952-2631-11ee-81dd-a0510b46b473','{\"displayTitle\":\"Mandibule 1.34.1.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-19 14:37:26.872','2023-07-19 12:37:27.761',NULL),('053aeb53-1ca1-11ee-84c4-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_06fff4e1-1ca0-11ee-84c4-a0510b46b473/occlusion_0701c127-1ca0-11ee-84c4-a0510b46b473/scan_bf209355-1ca0-11ee-84c4-a0510b46b473/053aeb53-1ca1-11ee-84c4-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_06fff4e1-1ca0-11ee-84c4-a0510b46b473_SESS_0701c127-1ca0-11ee-84c4-a0510b46b473_TOSC_bf209355-1ca0-11ee-84c4-a0510b46b473_MODEL','053aeb53-1ca1-11ee-84c4-a0510b46b473.zip','053aeb53-1ca1-11ee-84c4-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.1.1.3\",\"modelMatrix\":\"0.760856,0.632179,-0.146451,0,-0.648921,0.741226,-0.171713,0,3.53753e-09,0.225684,0.9742,0,-27.9896,4.43196,-8.40338,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-07 10:33:59.812','2023-07-07 08:34:00.464',NULL),('053b1a8c-1ca1-11ee-84c4-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_06fff4e1-1ca0-11ee-84c4-a0510b46b473/occlusion_0701c127-1ca0-11ee-84c4-a0510b46b473/scan_bf209355-1ca0-11ee-84c4-a0510b46b473/053b1a8c-1ca1-11ee-84c4-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_06fff4e1-1ca0-11ee-84c4-a0510b46b473_SESS_0701c127-1ca0-11ee-84c4-a0510b46b473_TOSC_bf209355-1ca0-11ee-84c4-a0510b46b473_SNAPS','053b1a8c-1ca1-11ee-84c4-a0510b46b473.png','053b1a8c-1ca1-11ee-84c4-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.1.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-07 10:33:59.813','2023-07-07 08:34:00.465',NULL),('05666713-26f9-11ee-aa9d-a0510b46b473',11,'/home/scan/.data//2023/11/c69c4cec-26f5-11ee-aa9d-a0510b46b473/session_cf31a6d6-26f5-11ee-aa9d-a0510b46b473/occlusion_cf34c227-26f5-11ee-aa9d-a0510b46b473/scan_c157499b-26f8-11ee-aa9d-a0510b46b473/05666713-26f9-11ee-aa9d-a0510b46b473.zip','PATIENT_c69c4cec-26f5-11ee-aa9d-a0510b46b473_ACT_cf31a6d6-26f5-11ee-aa9d-a0510b46b473_SESS_cf34c227-26f5-11ee-aa9d-a0510b46b473_TOSC_c157499b-26f8-11ee-aa9d-a0510b46b473_MODEL','05666713-26f9-11ee-aa9d-a0510b46b473.zip','05666713-26f9-11ee-aa9d-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.35.1.1.6\",\"modelMatrix\":\"-0.723292,0.689258,-0.0420963,0,-0.690542,-0.721947,0.0440928,0,1.83257e-09,0.0609612,0.99814,0,6.40743,-32.5904,-13.4485,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-20 14:29:07.437','2023-07-20 12:29:08.043',NULL),('05667cfb-26f9-11ee-aa9d-a0510b46b473',11,'/home/scan/.data//2023/11/c69c4cec-26f5-11ee-aa9d-a0510b46b473/session_cf31a6d6-26f5-11ee-aa9d-a0510b46b473/occlusion_cf34c227-26f5-11ee-aa9d-a0510b46b473/scan_c157499b-26f8-11ee-aa9d-a0510b46b473/05667cfb-26f9-11ee-aa9d-a0510b46b473.png','PATIENT_c69c4cec-26f5-11ee-aa9d-a0510b46b473_ACT_cf31a6d6-26f5-11ee-aa9d-a0510b46b473_SESS_cf34c227-26f5-11ee-aa9d-a0510b46b473_TOSC_c157499b-26f8-11ee-aa9d-a0510b46b473_SNAPS','05667cfb-26f9-11ee-aa9d-a0510b46b473.png','05667cfb-26f9-11ee-aa9d-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.35.1.1.6 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-20 14:29:07.437','2023-07-20 12:29:08.046',NULL),('0656b39c-1034-11ee-895b-a0510b46b473',11,'/home/scan/.data//2023/11/d75719c6-1032-11ee-895b-a0510b46b473/session_e5c513d4-1032-11ee-895b-a0510b46b473/occlusion_e5c7f174-1032-11ee-895b-a0510b46b473/scan_bfb2ea1b-1033-11ee-895b-a0510b46b473/0656b39c-1034-11ee-895b-a0510b46b473.zip','PATIENT_d75719c6-1032-11ee-895b-a0510b46b473_ACT_e5c513d4-1032-11ee-895b-a0510b46b473_SESS_e5c7f174-1032-11ee-895b-a0510b46b473_TOSC_bfb2ea1b-1033-11ee-895b-a0510b46b473_MODEL','0656b39c-1034-11ee-895b-a0510b46b473.zip','0656b39c-1034-11ee-895b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.16.1.1.3\",\"modelMatrix\":\"0.797973,0.486466,-0.355795,0,-0.602693,0.644087,-0.471076,0,-3.04011e-09,0.590341,0.807154,0,-30.7882,-10.4458,-7.9045,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-21 15:03:32.575','2023-06-21 13:03:35.499',NULL),('06574d92-1034-11ee-895b-a0510b46b473',11,'/home/scan/.data//2023/11/d75719c6-1032-11ee-895b-a0510b46b473/session_e5c513d4-1032-11ee-895b-a0510b46b473/occlusion_e5c7f174-1032-11ee-895b-a0510b46b473/scan_bfb2ea1b-1033-11ee-895b-a0510b46b473/06574d92-1034-11ee-895b-a0510b46b473.png','PATIENT_d75719c6-1032-11ee-895b-a0510b46b473_ACT_e5c513d4-1032-11ee-895b-a0510b46b473_SESS_e5c7f174-1032-11ee-895b-a0510b46b473_TOSC_bfb2ea1b-1033-11ee-895b-a0510b46b473_SNAPS','06574d92-1034-11ee-895b-a0510b46b473.png','06574d92-1034-11ee-895b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.16.1.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-21 15:03:32.579','2023-06-21 13:03:35.500',NULL),('06c664a9-e03c-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_6f09f9a8-e03a-11ed-bb13-00d86184ce3d/occlusion_6f0c3cda-e03a-11ed-bb13-00d86184ce3d/scan_e77e5f74-e03b-11ed-bb13-00d86184ce3d/06c664a9-e03c-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_6f09f9a8-e03a-11ed-bb13-00d86184ce3d_SESS_6f0c3cda-e03a-11ed-bb13-00d86184ce3d_TOSC_e77e5f74-e03b-11ed-bb13-00d86184ce3d_MODEL','06c664a9-e03c-11ed-bb13-00d86184ce3d.zip','06c664a9-e03c-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.3.1.7\",\"modelMatrix\":\"0.954764,0.253086,-0.156117,0,-0.297364,0.8126,-0.501255,0,4.43724e-09,0.525004,0.8511,0,-14.9956,-4.94049,-9.9188,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 13:59:53.467','2023-04-21 11:59:53.775',NULL),('06c678f7-e03c-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_6f09f9a8-e03a-11ed-bb13-00d86184ce3d/occlusion_6f0c3cda-e03a-11ed-bb13-00d86184ce3d/scan_e77e5f74-e03b-11ed-bb13-00d86184ce3d/06c678f7-e03c-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_6f09f9a8-e03a-11ed-bb13-00d86184ce3d_SESS_6f0c3cda-e03a-11ed-bb13-00d86184ce3d_TOSC_e77e5f74-e03b-11ed-bb13-00d86184ce3d_SNAPS','06c678f7-e03c-11ed-bb13-00d86184ce3d.png','06c678f7-e03c-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.3.1.7 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 13:59:53.468','2023-04-21 11:59:53.775',NULL),('070c9217-e01f-11ed-a285-00d86184ce3d',11,'/home/scan/.data//2023/11/5f27680c-e01a-11ed-b6c2-00d86184ce3d/session_65b85f32-e01a-11ed-b6c2-00d86184ce3d/occlusion_65ba9a94-e01a-11ed-b6c2-00d86184ce3d/scan_cdc7f48a-e01e-11ed-a285-00d86184ce3d/070c9217-e01f-11ed-a285-00d86184ce3d.zip','PATIENT_5f27680c-e01a-11ed-b6c2-00d86184ce3d_ACT_65b85f32-e01a-11ed-b6c2-00d86184ce3d_SESS_65ba9a94-e01a-11ed-b6c2-00d86184ce3d_BOSC_cdc7f48a-e01e-11ed-a285-00d86184ce3d_MODEL','070c9217-e01f-11ed-a285-00d86184ce3d.zip','070c9217-e01f-11ed-a285-00d86184ce3d','{\"displayTitle\":\"Mandibule 1.10.1.1.2\",\"modelMatrix\":\"0.999989,-0.00453803,0.00153613,0,0.00479097,0.947194,-0.320626,0,-9.98166e-11,0.32063,0.947205,0,-4.41581,-15.1844,-10.9558,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 10:32:18.522','2023-04-21 08:32:19.231',NULL),('070d054d-e01f-11ed-a285-00d86184ce3d',11,'/home/scan/.data//2023/11/5f27680c-e01a-11ed-b6c2-00d86184ce3d/session_65b85f32-e01a-11ed-b6c2-00d86184ce3d/occlusion_65ba9a94-e01a-11ed-b6c2-00d86184ce3d/scan_cdc7f48a-e01e-11ed-a285-00d86184ce3d/070d054d-e01f-11ed-a285-00d86184ce3d.png','PATIENT_5f27680c-e01a-11ed-b6c2-00d86184ce3d_ACT_65b85f32-e01a-11ed-b6c2-00d86184ce3d_SESS_65ba9a94-e01a-11ed-b6c2-00d86184ce3d_BOSC_cdc7f48a-e01e-11ed-a285-00d86184ce3d_SNAPS','070d054d-e01f-11ed-a285-00d86184ce3d.png','070d054d-e01f-11ed-a285-00d86184ce3d','{\"displayTitle\":\"Mandibule 1.10.1.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 10:32:18.525','2023-04-21 08:32:19.231',NULL),('085fd4cb-2620-11ee-8042-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_62519c59-261f-11ee-8042-a0510b46b473/occlusion_6253caa6-261f-11ee-8042-a0510b46b473/scan_aaa794d7-261f-11ee-8042-a0510b46b473/085fd4cb-2620-11ee-8042-a0510b46b473.zip','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_62519c59-261f-11ee-8042-a0510b46b473_SESS_6253caa6-261f-11ee-8042-a0510b46b473_TOSC_aaa794d7-261f-11ee-8042-a0510b46b473_MODEL','085fd4cb-2620-11ee-8042-a0510b46b473.zip','085fd4cb-2620-11ee-8042-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.1.1.2\",\"modelMatrix\":\"-0.504146,0.814615,-0.286774,0,-0.863618,-0.47554,0.167408,0,2.86725e-09,0.332061,0.943258,0,-2.5824,-34.7376,-5.65083,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-19 12:35:51.637','2023-07-19 10:35:52.344',NULL),('085fef06-2620-11ee-8042-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_62519c59-261f-11ee-8042-a0510b46b473/occlusion_6253caa6-261f-11ee-8042-a0510b46b473/scan_aaa794d7-261f-11ee-8042-a0510b46b473/085fef06-2620-11ee-8042-a0510b46b473.png','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_62519c59-261f-11ee-8042-a0510b46b473_SESS_6253caa6-261f-11ee-8042-a0510b46b473_TOSC_aaa794d7-261f-11ee-8042-a0510b46b473_SNAPS','085fef06-2620-11ee-8042-a0510b46b473.png','085fef06-2620-11ee-8042-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.1.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-19 12:35:51.637','2023-07-19 10:35:52.346',NULL),('08d4259f-0f78-11ee-9460-a0510b46b473',11,'/home/scan/.data//2023/11/e4b67639-0f72-11ee-8712-a0510b46b473/session_ec7935d6-0f72-11ee-8712-a0510b46b473/occlusion_ec7bd8ad-0f72-11ee-8712-a0510b46b473/scan_aa583e63-0f77-11ee-9460-a0510b46b473/08d4259f-0f78-11ee-9460-a0510b46b473.zip','PATIENT_e4b67639-0f72-11ee-8712-a0510b46b473_ACT_ec7935d6-0f72-11ee-8712-a0510b46b473_SESS_ec7bd8ad-0f72-11ee-8712-a0510b46b473_TOSC_aa583e63-0f77-11ee-9460-a0510b46b473_MODEL','08d4259f-0f78-11ee-9460-a0510b46b473.zip','08d4259f-0f78-11ee-9460-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.15.1.1.5\",\"modelMatrix\":\"0.687084,0.700384,-0.19333,0,-0.726578,0.662315,-0.182822,0,1.23985e-08,0.266084,0.96395,0,-29.8732,-9.3238,-6.45493,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-20 16:37:51.367','2023-06-20 14:37:52.093',NULL),('08d43a19-0f78-11ee-9460-a0510b46b473',11,'/home/scan/.data//2023/11/e4b67639-0f72-11ee-8712-a0510b46b473/session_ec7935d6-0f72-11ee-8712-a0510b46b473/occlusion_ec7bd8ad-0f72-11ee-8712-a0510b46b473/scan_aa583e63-0f77-11ee-9460-a0510b46b473/08d43a19-0f78-11ee-9460-a0510b46b473.png','PATIENT_e4b67639-0f72-11ee-8712-a0510b46b473_ACT_ec7935d6-0f72-11ee-8712-a0510b46b473_SESS_ec7bd8ad-0f72-11ee-8712-a0510b46b473_TOSC_aa583e63-0f77-11ee-9460-a0510b46b473_SNAPS','08d43a19-0f78-11ee-9460-a0510b46b473.png','08d43a19-0f78-11ee-9460-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.15.1.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-20 16:37:51.368','2023-06-20 14:37:52.094',NULL),('0a2cd37a-0f3f-11ee-8712-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_964f8d9e-0f3e-11ee-8712-a0510b46b473/occlusion_965293c3-0f3e-11ee-8712-a0510b46b473/scan_b90c747b-0f3e-11ee-8712-a0510b46b473/0a2cd37a-0f3f-11ee-8712-a0510b46b473.zip','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_964f8d9e-0f3e-11ee-8712-a0510b46b473_SESS_965293c3-0f3e-11ee-8712-a0510b46b473_TOSC_b90c747b-0f3e-11ee-8712-a0510b46b473_MODEL','0a2cd37a-0f3f-11ee-8712-a0510b46b473.zip','0a2cd37a-0f3f-11ee-8712-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.1.1.2\",\"modelMatrix\":\"0.149752,0.967492,-0.203796,0,-0.988724,0.146536,-0.0308669,0,7.24125e-10,0.20612,0.978527,0,-26.8541,-14.5893,-7.06809,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-20 09:49:52.313','2023-06-20 07:49:53.053',NULL),('0a2cebe4-0f3f-11ee-8712-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_964f8d9e-0f3e-11ee-8712-a0510b46b473/occlusion_965293c3-0f3e-11ee-8712-a0510b46b473/scan_b90c747b-0f3e-11ee-8712-a0510b46b473/0a2cebe4-0f3f-11ee-8712-a0510b46b473.png','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_964f8d9e-0f3e-11ee-8712-a0510b46b473_SESS_965293c3-0f3e-11ee-8712-a0510b46b473_TOSC_b90c747b-0f3e-11ee-8712-a0510b46b473_SNAPS','0a2cebe4-0f3f-11ee-8712-a0510b46b473.png','0a2cebe4-0f3f-11ee-8712-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.1.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-20 09:49:52.313','2023-06-20 07:49:53.055',NULL),('0a722861-e022-11ed-a285-00d86184ce3d',11,'/home/scan/.data//2023/11/5f27680c-e01a-11ed-b6c2-00d86184ce3d/session_a5c8b0b7-e021-11ed-a285-00d86184ce3d/occlusion_a5cbd17f-e021-11ed-a285-00d86184ce3d/scan_b8c7133b-e021-11ed-a285-00d86184ce3d/0a722861-e022-11ed-a285-00d86184ce3d.zip','PATIENT_5f27680c-e01a-11ed-b6c2-00d86184ce3d_ACT_a5c8b0b7-e021-11ed-a285-00d86184ce3d_SESS_a5cbd17f-e021-11ed-a285-00d86184ce3d_TOSC_b8c7133b-e021-11ed-a285-00d86184ce3d_MODEL','0a722861-e022-11ed-a285-00d86184ce3d.zip','0a722861-e022-11ed-a285-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.10.2.1.1\",\"modelMatrix\":\"0.0679684,0.956074,-0.285138,0,-0.997688,0.0651334,-0.0194253,0,1.53665e-09,0.285799,0.95829,0,-27.1538,-15.9962,-8.13228,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 10:53:52.711','2023-04-21 08:53:53.693',NULL),('0a72406e-e022-11ed-a285-00d86184ce3d',11,'/home/scan/.data//2023/11/5f27680c-e01a-11ed-b6c2-00d86184ce3d/session_a5c8b0b7-e021-11ed-a285-00d86184ce3d/occlusion_a5cbd17f-e021-11ed-a285-00d86184ce3d/scan_b8c7133b-e021-11ed-a285-00d86184ce3d/0a72406e-e022-11ed-a285-00d86184ce3d.png','PATIENT_5f27680c-e01a-11ed-b6c2-00d86184ce3d_ACT_a5c8b0b7-e021-11ed-a285-00d86184ce3d_SESS_a5cbd17f-e021-11ed-a285-00d86184ce3d_TOSC_b8c7133b-e021-11ed-a285-00d86184ce3d_SNAPS','0a72406e-e022-11ed-a285-00d86184ce3d.png','0a72406e-e022-11ed-a285-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.10.2.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 10:53:52.712','2023-04-21 08:53:53.693',NULL),('0afc6ad7-1c06-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/ae8bd11e-1c05-11ee-9323-a0510b46b473/session_bb436bde-1c05-11ee-9323-a0510b46b473/occlusion_bb465a1e-1c05-11ee-9323-a0510b46b473/scan_befa4fd2-1c05-11ee-9323-a0510b46b473/0afc6ad7-1c06-11ee-9323-a0510b46b473.zip','PATIENT_ae8bd11e-1c05-11ee-9323-a0510b46b473_ACT_bb436bde-1c05-11ee-9323-a0510b46b473_SESS_bb465a1e-1c05-11ee-9323-a0510b46b473_TOSC_befa4fd2-1c05-11ee-9323-a0510b46b473_MODEL','0afc6ad7-1c06-11ee-9323-a0510b46b473.zip','0afc6ad7-1c06-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.29.1.1.1\",\"modelMatrix\":\"0.796727,0.589633,-0.132516,0,-0.60434,0.777337,-0.174701,0,5.09474e-09,0.219274,0.975663,0,-25.5891,3.07585,-12.3722,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 16:04:37.476','2023-07-06 14:04:38.213',NULL),('0afc8567-1c06-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/ae8bd11e-1c05-11ee-9323-a0510b46b473/session_bb436bde-1c05-11ee-9323-a0510b46b473/occlusion_bb465a1e-1c05-11ee-9323-a0510b46b473/scan_befa4fd2-1c05-11ee-9323-a0510b46b473/0afc8567-1c06-11ee-9323-a0510b46b473.png','PATIENT_ae8bd11e-1c05-11ee-9323-a0510b46b473_ACT_bb436bde-1c05-11ee-9323-a0510b46b473_SESS_bb465a1e-1c05-11ee-9323-a0510b46b473_TOSC_befa4fd2-1c05-11ee-9323-a0510b46b473_SNAPS','0afc8567-1c06-11ee-9323-a0510b46b473.png','0afc8567-1c06-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.29.1.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 16:04:37.476','2023-07-06 14:04:38.216',NULL),('0afea51d-2630-11ee-81dd-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_ab852a49-262e-11ee-81dd-a0510b46b473/occlusion_ab88338c-262e-11ee-81dd-a0510b46b473/scan_cd8ef52e-262f-11ee-81dd-a0510b46b473/0afea51d-2630-11ee-81dd-a0510b46b473.zip','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_ab852a49-262e-11ee-81dd-a0510b46b473_SESS_ab88338c-262e-11ee-81dd-a0510b46b473_TOSC_cd8ef52e-262f-11ee-81dd-a0510b46b473_MODEL','0afea51d-2630-11ee-81dd-a0510b46b473.zip','0afea51d-2630-11ee-81dd-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.2.1.4\",\"modelMatrix\":\"0.971449,0.218152,-0.0932566,0,-0.237249,0.893254,-0.381852,0,-6.62503e-09,0.393075,0.919506,0,-30.1862,6.74095,-13.3884,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-19 14:30:27.981','2023-07-19 12:30:28.476',NULL),('0afebc59-2630-11ee-81dd-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_ab852a49-262e-11ee-81dd-a0510b46b473/occlusion_ab88338c-262e-11ee-81dd-a0510b46b473/scan_cd8ef52e-262f-11ee-81dd-a0510b46b473/0afebc59-2630-11ee-81dd-a0510b46b473.png','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_ab852a49-262e-11ee-81dd-a0510b46b473_SESS_ab88338c-262e-11ee-81dd-a0510b46b473_TOSC_cd8ef52e-262f-11ee-81dd-a0510b46b473_SNAPS','0afebc59-2630-11ee-81dd-a0510b46b473.png','0afebc59-2630-11ee-81dd-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.2.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-19 14:30:27.981','2023-07-19 12:30:28.477',NULL),('0b05f16c-1a66-11ee-9a4f-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_9f32257c-1a64-11ee-9a4f-a0510b46b473/occlusion_9f33e64c-1a64-11ee-9a4f-a0510b46b473/scan_cec8a1cb-1a65-11ee-9a4f-a0510b46b473/0b05f16c-1a66-11ee-9a4f-a0510b46b473.zip','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_9f32257c-1a64-11ee-9a4f-a0510b46b473_SESS_9f33e64c-1a64-11ee-9a4f-a0510b46b473_TOSC_cec8a1cb-1a65-11ee-9a4f-a0510b46b473_MODEL','0b05f16c-1a66-11ee-9a4f-a0510b46b473.zip','0b05f16c-1a66-11ee-9a4f-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.2.1.4\",\"modelMatrix\":\"0.802656,0.506252,-0.315361,0,-0.596443,0.681283,-0.424393,0,2.59352e-08,0.528736,0.848786,0,-31.3622,6.40465,-11.4997,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-04 14:26:46.899','2023-07-04 12:26:47.398',NULL),('0b060843-1a66-11ee-9a4f-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_9f32257c-1a64-11ee-9a4f-a0510b46b473/occlusion_9f33e64c-1a64-11ee-9a4f-a0510b46b473/scan_cec8a1cb-1a65-11ee-9a4f-a0510b46b473/0b060843-1a66-11ee-9a4f-a0510b46b473.png','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_9f32257c-1a64-11ee-9a4f-a0510b46b473_SESS_9f33e64c-1a64-11ee-9a4f-a0510b46b473_TOSC_cec8a1cb-1a65-11ee-9a4f-a0510b46b473_SNAPS','0b060843-1a66-11ee-9a4f-a0510b46b473.png','0b060843-1a66-11ee-9a4f-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.2.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-04 14:26:46.899','2023-07-04 12:26:47.401',NULL),('0b65f14c-df83-11ed-b6c2-00d86184ce3d',11,'/home/scan/.data//2023/11/ac239c53-df81-11ed-b6c2-00d86184ce3d/session_b20f4b8a-df81-11ed-b6c2-00d86184ce3d/occlusion_b21241b0-df81-11ed-b6c2-00d86184ce3d/scan_b8479ca6-df82-11ed-b6c2-00d86184ce3d/0b65f14c-df83-11ed-b6c2-00d86184ce3d.zip','PATIENT_ac239c53-df81-11ed-b6c2-00d86184ce3d_ACT_b20f4b8a-df81-11ed-b6c2-00d86184ce3d_SESS_b21241b0-df81-11ed-b6c2-00d86184ce3d_TOSC_b8479ca6-df82-11ed-b6c2-00d86184ce3d_MODEL','0b65f14c-df83-11ed-b6c2-00d86184ce3d.zip','0b65f14c-df83-11ed-b6c2-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.7.1.1.3\",\"modelMatrix\":\"0.56544,0.715874,-0.409637,0,-0.82479,0.490772,-0.280829,0,-1.96749e-11,0.496657,0.867947,0,-26.8943,-10.5133,-3.79327,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-20 15:55:44.329','2023-04-20 13:55:45.209',NULL),('0b660826-df83-11ed-b6c2-00d86184ce3d',11,'/home/scan/.data//2023/11/ac239c53-df81-11ed-b6c2-00d86184ce3d/session_b20f4b8a-df81-11ed-b6c2-00d86184ce3d/occlusion_b21241b0-df81-11ed-b6c2-00d86184ce3d/scan_b8479ca6-df82-11ed-b6c2-00d86184ce3d/0b660826-df83-11ed-b6c2-00d86184ce3d.png','PATIENT_ac239c53-df81-11ed-b6c2-00d86184ce3d_ACT_b20f4b8a-df81-11ed-b6c2-00d86184ce3d_SESS_b21241b0-df81-11ed-b6c2-00d86184ce3d_TOSC_b8479ca6-df82-11ed-b6c2-00d86184ce3d_SNAPS','0b660826-df83-11ed-b6c2-00d86184ce3d.png','0b660826-df83-11ed-b6c2-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.7.1.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-20 15:55:44.329','2023-04-20 13:55:45.209',NULL),('0bc59f0b-10fc-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/ed94fe78-10f4-11ee-b636-a0510b46b473/session_8cbad919-10fb-11ee-b636-a0510b46b473/occlusion_8cbde682-10fb-11ee-b636-a0510b46b473/scan_cf4f6716-10fb-11ee-b636-a0510b46b473/0bc59f0b-10fc-11ee-b636-a0510b46b473.zip','PATIENT_ed94fe78-10f4-11ee-b636-a0510b46b473_ACT_8cbad919-10fb-11ee-b636-a0510b46b473_SESS_8cbde682-10fb-11ee-b636-a0510b46b473_TOSC_cf4f6716-10fb-11ee-b636-a0510b46b473_MODEL','0bc59f0b-10fc-11ee-b636-a0510b46b473.zip','0bc59f0b-10fc-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.19.2.1.2\",\"modelMatrix\":\"0.758469,0.578575,-0.299958,0,-0.651708,0.673355,-0.349097,0,-1.45461e-08,0.460265,0.887782,0,-32.0308,-1.51811,-8.18298,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 14:55:21.036','2023-06-22 12:55:21.609',NULL),('0bc5b6cc-10fc-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/ed94fe78-10f4-11ee-b636-a0510b46b473/session_8cbad919-10fb-11ee-b636-a0510b46b473/occlusion_8cbde682-10fb-11ee-b636-a0510b46b473/scan_cf4f6716-10fb-11ee-b636-a0510b46b473/0bc5b6cc-10fc-11ee-b636-a0510b46b473.png','PATIENT_ed94fe78-10f4-11ee-b636-a0510b46b473_ACT_8cbad919-10fb-11ee-b636-a0510b46b473_SESS_8cbde682-10fb-11ee-b636-a0510b46b473_TOSC_cf4f6716-10fb-11ee-b636-a0510b46b473_SNAPS','0bc5b6cc-10fc-11ee-b636-a0510b46b473.png','0bc5b6cc-10fc-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.19.2.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 14:55:21.037','2023-06-22 12:55:21.609',NULL),('0be51931-1bd2-11ee-9086-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_a6b1a4bd-1bcf-11ee-9086-a0510b46b473/occlusion_a6b491c8-1bcf-11ee-9086-a0510b46b473/scan_a2a88280-1bd1-11ee-9086-a0510b46b473/0be51931-1bd2-11ee-9086-a0510b46b473.zip','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_a6b1a4bd-1bcf-11ee-9086-a0510b46b473_SESS_a6b491c8-1bcf-11ee-9086-a0510b46b473_TOSC_a2a88280-1bd1-11ee-9086-a0510b46b473_MODEL','0be51931-1bd2-11ee-9086-a0510b46b473.zip','0be51931-1bd2-11ee-9086-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.3.1.6\",\"modelMatrix\":\"-0.0569855,0.968811,-0.241158,0,-0.998375,-0.055298,0.0137649,0,2.03049e-10,0.241551,0.970388,0,-19.7171,-22.6219,-8.90303,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 09:52:25.171','2023-07-06 07:52:26.254',NULL),('0be5311d-1bd2-11ee-9086-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_a6b1a4bd-1bcf-11ee-9086-a0510b46b473/occlusion_a6b491c8-1bcf-11ee-9086-a0510b46b473/scan_a2a88280-1bd1-11ee-9086-a0510b46b473/0be5311d-1bd2-11ee-9086-a0510b46b473.png','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_a6b1a4bd-1bcf-11ee-9086-a0510b46b473_SESS_a6b491c8-1bcf-11ee-9086-a0510b46b473_TOSC_a2a88280-1bd1-11ee-9086-a0510b46b473_SNAPS','0be5311d-1bd2-11ee-9086-a0510b46b473.png','0be5311d-1bd2-11ee-9086-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.3.1.6 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 09:52:25.171','2023-07-06 07:52:26.254',NULL),('0c7ae6ab-10d6-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/bd51960a-10d5-11ee-b636-a0510b46b473/session_c5e67f1c-10d5-11ee-b636-a0510b46b473/occlusion_c5e95a7b-10d5-11ee-b636-a0510b46b473/scan_c8b40c9a-10d5-11ee-b636-a0510b46b473/0c7ae6ab-10d6-11ee-b636-a0510b46b473.zip','PATIENT_bd51960a-10d5-11ee-b636-a0510b46b473_ACT_c5e67f1c-10d5-11ee-b636-a0510b46b473_SESS_c5e95a7b-10d5-11ee-b636-a0510b46b473_TOSC_c8b40c9a-10d5-11ee-b636-a0510b46b473_MODEL','0c7ae6ab-10d6-11ee-b636-a0510b46b473.zip','0c7ae6ab-10d6-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.17.1.1.1\",\"modelMatrix\":\"-0.64303,0.739336,-0.199738,0,-0.765841,-0.620775,0.167707,0,-3.62401e-09,0.260808,0.965391,0,-5.26462,-16.718,-11.0402,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 10:23:21.349','2023-06-22 08:23:22.099',NULL),('0c7c38c4-10d6-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/bd51960a-10d5-11ee-b636-a0510b46b473/session_c5e67f1c-10d5-11ee-b636-a0510b46b473/occlusion_c5e95a7b-10d5-11ee-b636-a0510b46b473/scan_c8b40c9a-10d5-11ee-b636-a0510b46b473/0c7c38c4-10d6-11ee-b636-a0510b46b473.png','PATIENT_bd51960a-10d5-11ee-b636-a0510b46b473_ACT_c5e67f1c-10d5-11ee-b636-a0510b46b473_SESS_c5e95a7b-10d5-11ee-b636-a0510b46b473_TOSC_c8b40c9a-10d5-11ee-b636-a0510b46b473_SNAPS','0c7c38c4-10d6-11ee-b636-a0510b46b473.png','0c7c38c4-10d6-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.17.1.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 10:23:21.357','2023-06-22 08:23:22.104',NULL),('0cef79e5-1bd0-11ee-9086-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_a6b1a4bd-1bcf-11ee-9086-a0510b46b473/occlusion_a6b491c8-1bcf-11ee-9086-a0510b46b473/scan_a8606364-1bcf-11ee-9086-a0510b46b473/0cef79e5-1bd0-11ee-9086-a0510b46b473.zip','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_a6b1a4bd-1bcf-11ee-9086-a0510b46b473_SESS_a6b491c8-1bcf-11ee-9086-a0510b46b473_TOSC_a8606364-1bcf-11ee-9086-a0510b46b473_MODEL','0cef79e5-1bd0-11ee-9086-a0510b46b473.zip','0cef79e5-1bd0-11ee-9086-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.3.1.1\",\"modelMatrix\":\"0.514095,0.839767,-0.174637,0,-0.857733,0.503327,-0.104672,0,-3.67608e-09,0.203603,0.979053,0,-26.7851,-8.75375,-10.5486,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 09:38:07.923','2023-07-06 07:38:09.008',NULL),('0cef90b1-1bd0-11ee-9086-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_a6b1a4bd-1bcf-11ee-9086-a0510b46b473/occlusion_a6b491c8-1bcf-11ee-9086-a0510b46b473/scan_a8606364-1bcf-11ee-9086-a0510b46b473/0cef90b1-1bd0-11ee-9086-a0510b46b473.png','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_a6b1a4bd-1bcf-11ee-9086-a0510b46b473_SESS_a6b491c8-1bcf-11ee-9086-a0510b46b473_TOSC_a8606364-1bcf-11ee-9086-a0510b46b473_SNAPS','0cef90b1-1bd0-11ee-9086-a0510b46b473.png','0cef90b1-1bd0-11ee-9086-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.3.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 09:38:07.923','2023-07-06 07:38:09.009',NULL),('0ddb6808-15aa-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/634153bc-1587-11ee-b3b1-00d86184ce3d/session_6e9df503-1587-11ee-b3b1-00d86184ce3d/occlusion_6ea0d9b2-1587-11ee-b3b1-00d86184ce3d/scan_bf36c064-15a9-11ee-b3b1-00d86184ce3d/0ddb6808-15aa-11ee-b3b1-00d86184ce3d.zip','PATIENT_634153bc-1587-11ee-b3b1-00d86184ce3d_ACT_6e9df503-1587-11ee-b3b1-00d86184ce3d_SESS_6ea0d9b2-1587-11ee-b3b1-00d86184ce3d_TOSC_bf36c064-15a9-11ee-b3b1-00d86184ce3d_MODEL','0ddb6808-15aa-11ee-b3b1-00d86184ce3d.zip','0ddb6808-15aa-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.24.1.1.9\",\"modelMatrix\":\"-0.145479,0.970016,-0.194691,0,-0.989361,-0.142635,0.028628,0,-1.72546e-09,0.196784,0.980447,0,-19.2971,-23.5668,-8.68331,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-28 13:51:01.617','2023-06-28 11:51:02.328',NULL),('0ddb7f44-15aa-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/634153bc-1587-11ee-b3b1-00d86184ce3d/session_6e9df503-1587-11ee-b3b1-00d86184ce3d/occlusion_6ea0d9b2-1587-11ee-b3b1-00d86184ce3d/scan_bf36c064-15a9-11ee-b3b1-00d86184ce3d/0ddb7f44-15aa-11ee-b3b1-00d86184ce3d.png','PATIENT_634153bc-1587-11ee-b3b1-00d86184ce3d_ACT_6e9df503-1587-11ee-b3b1-00d86184ce3d_SESS_6ea0d9b2-1587-11ee-b3b1-00d86184ce3d_TOSC_bf36c064-15a9-11ee-b3b1-00d86184ce3d_SNAPS','0ddb7f44-15aa-11ee-b3b1-00d86184ce3d.png','0ddb7f44-15aa-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.24.1.1.9 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-28 13:51:01.617','2023-06-28 11:51:02.329',NULL),('0e8445cc-26e0-11ee-a836-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_568bc925-26df-11ee-a836-a0510b46b473/occlusion_568ed4f8-26df-11ee-a836-a0510b46b473/scan_c26977de-26df-11ee-a836-a0510b46b473/0e8445cc-26e0-11ee-a836-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_568bc925-26df-11ee-a836-a0510b46b473_SESS_568ed4f8-26df-11ee-a836-a0510b46b473_TOSC_c26977de-26df-11ee-a836-a0510b46b473_MODEL','0e8445cc-26e0-11ee-a836-a0510b46b473.zip','0e8445cc-26e0-11ee-a836-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.3.1.1\",\"modelMatrix\":\"-0.955625,0.293831,-0.0210772,0,-0.294586,-0.953176,0.0683734,0,1.01364e-09,0.0715484,0.997437,0,27.7334,10.7134,-15.2209,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,'2023-07-21 10:01:25.427','2023-07-20 11:30:25.314','2023-07-21 08:01:25.432',NULL),('0e845de5-26e0-11ee-a836-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_568bc925-26df-11ee-a836-a0510b46b473/occlusion_568ed4f8-26df-11ee-a836-a0510b46b473/scan_c26977de-26df-11ee-a836-a0510b46b473/0e845de5-26e0-11ee-a836-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_568bc925-26df-11ee-a836-a0510b46b473_SESS_568ed4f8-26df-11ee-a836-a0510b46b473_TOSC_c26977de-26df-11ee-a836-a0510b46b473_SNAPS','0e845de5-26e0-11ee-a836-a0510b46b473.png','0e845de5-26e0-11ee-a836-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.3.1.1 Snapshot\"}','PNG',0,'CREATED',0,'2023-07-21 10:01:25.427','2023-07-20 11:30:25.315','2023-07-21 08:01:25.436',NULL),('0efef8cb-2ae5-11ee-95bc-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_b5fe1002-2ae0-11ee-95bc-a0510b46b473/occlusion_b6012772-2ae0-11ee-95bc-a0510b46b473/scan_cd631c03-2ae4-11ee-95bc-a0510b46b473/0efef8cb-2ae5-11ee-95bc-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_b5fe1002-2ae0-11ee-95bc-a0510b46b473_SESS_b6012772-2ae0-11ee-95bc-a0510b46b473_TOSC_cd631c03-2ae4-11ee-95bc-a0510b46b473_MODEL','0efef8cb-2ae5-11ee-95bc-a0510b46b473.zip','0efef8cb-2ae5-11ee-95bc-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.8.1.3\",\"modelMatrix\":\"0.415959,0.859586,-0.296799,0,-0.909383,0.393182,-0.135758,0,7.21524e-10,0.326374,0.945241,0,-30.6547,-9.88864,-7.74028,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-25 14:16:18.253','2023-07-25 12:16:18.738',NULL),('0f003b10-2ae5-11ee-95bc-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_b5fe1002-2ae0-11ee-95bc-a0510b46b473/occlusion_b6012772-2ae0-11ee-95bc-a0510b46b473/scan_cd631c03-2ae4-11ee-95bc-a0510b46b473/0f003b10-2ae5-11ee-95bc-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_b5fe1002-2ae0-11ee-95bc-a0510b46b473_SESS_b6012772-2ae0-11ee-95bc-a0510b46b473_TOSC_cd631c03-2ae4-11ee-95bc-a0510b46b473_SNAPS','0f003b10-2ae5-11ee-95bc-a0510b46b473.png','0f003b10-2ae5-11ee-95bc-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.8.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-25 14:16:18.261','2023-07-25 12:16:18.739',NULL),('0f5561a4-10fa-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/ed94fe78-10f4-11ee-b636-a0510b46b473/session_f8ef8fe7-10f4-11ee-b636-a0510b46b473/occlusion_f8f2e241-10f4-11ee-b636-a0510b46b473/scan_b2bf6be9-10f9-11ee-b636-a0510b46b473/0f5561a4-10fa-11ee-b636-a0510b46b473.zip','PATIENT_ed94fe78-10f4-11ee-b636-a0510b46b473_ACT_f8ef8fe7-10f4-11ee-b636-a0510b46b473_SESS_f8f2e241-10f4-11ee-b636-a0510b46b473_TOSC_b2bf6be9-10f9-11ee-b636-a0510b46b473_MODEL','0f5561a4-10fa-11ee-b636-a0510b46b473.zip','0f5561a4-10fa-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.19.1.1.4\",\"modelMatrix\":\"0.0486582,0.984858,-0.166397,0,-0.998815,0.0479782,-0.00810616,0,-2.81857e-10,0.166594,0.986026,0,-19.2664,-25.8262,-9.8308,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 14:41:08.018','2023-06-22 12:41:08.817',NULL),('0f5575a0-10fa-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/ed94fe78-10f4-11ee-b636-a0510b46b473/session_f8ef8fe7-10f4-11ee-b636-a0510b46b473/occlusion_f8f2e241-10f4-11ee-b636-a0510b46b473/scan_b2bf6be9-10f9-11ee-b636-a0510b46b473/0f5575a0-10fa-11ee-b636-a0510b46b473.png','PATIENT_ed94fe78-10f4-11ee-b636-a0510b46b473_ACT_f8ef8fe7-10f4-11ee-b636-a0510b46b473_SESS_f8f2e241-10f4-11ee-b636-a0510b46b473_TOSC_b2bf6be9-10f9-11ee-b636-a0510b46b473_SNAPS','0f5575a0-10fa-11ee-b636-a0510b46b473.png','0f5575a0-10fa-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.19.1.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 14:41:08.019','2023-06-22 12:41:08.817',NULL),('10676119-1ca9-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_08b47e37-1ca8-11ee-997b-a0510b46b473/occlusion_08b766f9-1ca8-11ee-997b-a0510b46b473/scan_e2a5f57a-1ca8-11ee-997b-a0510b46b473/10676119-1ca9-11ee-997b-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_08b47e37-1ca8-11ee-997b-a0510b46b473_SESS_08b766f9-1ca8-11ee-997b-a0510b46b473_TOSC_e2a5f57a-1ca8-11ee-997b-a0510b46b473_MODEL','10676119-1ca9-11ee-997b-a0510b46b473.zip','10676119-1ca9-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.2.1.5\",\"modelMatrix\":\"0.728745,0.57358,-0.374081,0,-0.684785,0.610401,-0.398096,0,-1.48644e-08,0.546275,0.837606,0,-26.6611,7.46142,-10.008,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-07 11:31:34.532','2023-07-07 09:31:34.972',NULL),('1067761f-1ca9-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_08b47e37-1ca8-11ee-997b-a0510b46b473/occlusion_08b766f9-1ca8-11ee-997b-a0510b46b473/scan_e2a5f57a-1ca8-11ee-997b-a0510b46b473/1067761f-1ca9-11ee-997b-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_08b47e37-1ca8-11ee-997b-a0510b46b473_SESS_08b766f9-1ca8-11ee-997b-a0510b46b473_TOSC_e2a5f57a-1ca8-11ee-997b-a0510b46b473_SNAPS','1067761f-1ca9-11ee-997b-a0510b46b473.png','1067761f-1ca9-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.2.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-07 11:31:34.533','2023-07-07 09:31:34.975',NULL),('119da0fe-2571-11ee-91d6-a0510b46b473',11,'/home/scan/.data//2023/11/49f1e276-256f-11ee-91d6-a0510b46b473/session_5c74c40a-256f-11ee-91d6-a0510b46b473/occlusion_5c77122f-256f-11ee-91d6-a0510b46b473/scan_b7a97437-2570-11ee-91d6-a0510b46b473/119da0fe-2571-11ee-91d6-a0510b46b473.zip','PATIENT_49f1e276-256f-11ee-91d6-a0510b46b473_ACT_5c74c40a-256f-11ee-91d6-a0510b46b473_SESS_5c77122f-256f-11ee-91d6-a0510b46b473_TOSC_b7a97437-2570-11ee-91d6-a0510b46b473_MODEL','119da0fe-2571-11ee-91d6-a0510b46b473.zip','119da0fe-2571-11ee-91d6-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.33.1.1.4\",\"modelMatrix\":\"0.00770442,0.981758,-0.189977,0,-0.99997,0.0075641,-0.0014637,0,-1.21505e-10,0.189982,0.981788,0,-15.5336,-31.7882,-9.36649,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-18 15:43:25.214','2023-07-18 13:43:26.054',NULL),('119db678-2571-11ee-91d6-a0510b46b473',11,'/home/scan/.data//2023/11/49f1e276-256f-11ee-91d6-a0510b46b473/session_5c74c40a-256f-11ee-91d6-a0510b46b473/occlusion_5c77122f-256f-11ee-91d6-a0510b46b473/scan_b7a97437-2570-11ee-91d6-a0510b46b473/119db678-2571-11ee-91d6-a0510b46b473.png','PATIENT_49f1e276-256f-11ee-91d6-a0510b46b473_ACT_5c74c40a-256f-11ee-91d6-a0510b46b473_SESS_5c77122f-256f-11ee-91d6-a0510b46b473_TOSC_b7a97437-2570-11ee-91d6-a0510b46b473_SNAPS','119db678-2571-11ee-91d6-a0510b46b473.png','119db678-2571-11ee-91d6-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.33.1.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-18 15:43:25.214','2023-07-18 13:43:26.056',NULL),('11ff6ddf-de99-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/35e16a68-de95-11ed-9cc3-00d86184ce3d/session_450c29ef-de95-11ed-9cc3-00d86184ce3d/occlusion_450efda8-de95-11ed-9cc3-00d86184ce3d/scan_ba28b13e-de98-11ed-9cc3-00d86184ce3d/11ff6ddf-de99-11ed-9cc3-00d86184ce3d.zip','PATIENT_35e16a68-de95-11ed-9cc3-00d86184ce3d_ACT_450c29ef-de95-11ed-9cc3-00d86184ce3d_SESS_450efda8-de95-11ed-9cc3-00d86184ce3d_TOSC_ba28b13e-de98-11ed-9cc3-00d86184ce3d_MODEL','11ff6ddf-de99-11ed-9cc3-00d86184ce3d.zip','11ff6ddf-de99-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.4.1.1.5\",\"modelMatrix\":\"0.453082,0.853323,-0.257986,0,-0.891469,0.433695,-0.131119,0,1.01674e-08,0.289394,0.95721,0,-28.2027,-14.0376,-7.03212,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-19 12:00:53.166','2023-04-19 10:00:54.132',NULL),('11ff83ea-de99-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/35e16a68-de95-11ed-9cc3-00d86184ce3d/session_450c29ef-de95-11ed-9cc3-00d86184ce3d/occlusion_450efda8-de95-11ed-9cc3-00d86184ce3d/scan_ba28b13e-de98-11ed-9cc3-00d86184ce3d/11ff83ea-de99-11ed-9cc3-00d86184ce3d.png','PATIENT_35e16a68-de95-11ed-9cc3-00d86184ce3d_ACT_450c29ef-de95-11ed-9cc3-00d86184ce3d_SESS_450efda8-de95-11ed-9cc3-00d86184ce3d_TOSC_ba28b13e-de98-11ed-9cc3-00d86184ce3d_SNAPS','11ff83ea-de99-11ed-9cc3-00d86184ce3d.png','11ff83ea-de99-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.4.1.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-19 12:00:53.167','2023-04-19 10:00:54.132',NULL),('1207244f-1cb1-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/4375c5f1-1cad-11ee-997b-a0510b46b473/session_dfb50528-1cb0-11ee-997b-a0510b46b473/occlusion_dfb7e00f-1cb0-11ee-997b-a0510b46b473/scan_e19b72c1-1cb0-11ee-997b-a0510b46b473/1207244f-1cb1-11ee-997b-a0510b46b473.zip','PATIENT_4375c5f1-1cad-11ee-997b-a0510b46b473_ACT_dfb50528-1cb0-11ee-997b-a0510b46b473_SESS_dfb7e00f-1cb0-11ee-997b-a0510b46b473_TOSC_e19b72c1-1cb0-11ee-997b-a0510b46b473_MODEL','1207244f-1cb1-11ee-997b-a0510b46b473.zip','1207244f-1cb1-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.31.2.1.1\",\"modelMatrix\":\"0.905119,0.402558,-0.136775,0,-0.425159,0.857003,-0.29118,0,-1.82999e-08,0.321703,0.946841,0,-24.5175,8.76861,-11.6095,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-07 12:28:53.231','2023-07-07 10:28:53.703',NULL),('12073b1e-1cb1-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/4375c5f1-1cad-11ee-997b-a0510b46b473/session_dfb50528-1cb0-11ee-997b-a0510b46b473/occlusion_dfb7e00f-1cb0-11ee-997b-a0510b46b473/scan_e19b72c1-1cb0-11ee-997b-a0510b46b473/12073b1e-1cb1-11ee-997b-a0510b46b473.png','PATIENT_4375c5f1-1cad-11ee-997b-a0510b46b473_ACT_dfb50528-1cb0-11ee-997b-a0510b46b473_SESS_dfb7e00f-1cb0-11ee-997b-a0510b46b473_TOSC_e19b72c1-1cb0-11ee-997b-a0510b46b473_SNAPS','12073b1e-1cb1-11ee-997b-a0510b46b473.png','12073b1e-1cb1-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.31.2.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-07 12:28:53.231','2023-07-07 10:28:53.703',NULL),('120d83c7-0f43-11ee-8712-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_55019e04-0f41-11ee-8712-a0510b46b473/occlusion_550492f3-0f41-11ee-8712-a0510b46b473/scan_e24c5c06-0f42-11ee-8712-a0510b46b473/120d83c7-0f43-11ee-8712-a0510b46b473.zip','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_55019e04-0f41-11ee-8712-a0510b46b473_SESS_550492f3-0f41-11ee-8712-a0510b46b473_TOSC_e24c5c06-0f42-11ee-8712-a0510b46b473_MODEL','120d83c7-0f43-11ee-8712-a0510b46b473.zip','120d83c7-0f43-11ee-8712-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.2.1.6\",\"modelMatrix\":\"0.468435,0.759493,-0.451375,0,-0.883498,0.402687,-0.239321,0,6.04162e-10,0.510896,0.859643,0,-17.3756,-0.642733,-6.56619,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-20 10:18:43.516','2023-06-20 08:18:44.002',NULL),('120d98a0-0f43-11ee-8712-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_55019e04-0f41-11ee-8712-a0510b46b473/occlusion_550492f3-0f41-11ee-8712-a0510b46b473/scan_e24c5c06-0f42-11ee-8712-a0510b46b473/120d98a0-0f43-11ee-8712-a0510b46b473.png','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_55019e04-0f41-11ee-8712-a0510b46b473_SESS_550492f3-0f41-11ee-8712-a0510b46b473_TOSC_e24c5c06-0f42-11ee-8712-a0510b46b473_SNAPS','120d98a0-0f43-11ee-8712-a0510b46b473.png','120d98a0-0f43-11ee-8712-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.2.1.6 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-20 10:18:43.517','2023-06-20 08:18:44.006',NULL),('124b968d-10d7-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/bd51960a-10d5-11ee-b636-a0510b46b473/session_c5e67f1c-10d5-11ee-b636-a0510b46b473/occlusion_c5e95a7b-10d5-11ee-b636-a0510b46b473/scan_a0404f8c-10d6-11ee-b636-a0510b46b473/124b968d-10d7-11ee-b636-a0510b46b473.zip','PATIENT_bd51960a-10d5-11ee-b636-a0510b46b473_ACT_c5e67f1c-10d5-11ee-b636-a0510b46b473_SESS_c5e95a7b-10d5-11ee-b636-a0510b46b473_TOSC_a0404f8c-10d6-11ee-b636-a0510b46b473_MODEL','124b968d-10d7-11ee-b636-a0510b46b473.zip','124b968d-10d7-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.17.1.1.3\",\"modelMatrix\":\"0.699983,0.704688,-0.115925,0,-0.71416,0.690699,-0.113624,0,1.76566e-09,0.162324,0.986738,0,-27.9827,-10.491,-11.5465,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 10:30:40.602','2023-06-22 08:30:41.616',NULL),('124bd560-10d7-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/bd51960a-10d5-11ee-b636-a0510b46b473/session_c5e67f1c-10d5-11ee-b636-a0510b46b473/occlusion_c5e95a7b-10d5-11ee-b636-a0510b46b473/scan_a0404f8c-10d6-11ee-b636-a0510b46b473/124bd560-10d7-11ee-b636-a0510b46b473.png','PATIENT_bd51960a-10d5-11ee-b636-a0510b46b473_ACT_c5e67f1c-10d5-11ee-b636-a0510b46b473_SESS_c5e95a7b-10d5-11ee-b636-a0510b46b473_TOSC_a0404f8c-10d6-11ee-b636-a0510b46b473_SNAPS','124bd560-10d7-11ee-b636-a0510b46b473.png','124bd560-10d7-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.17.1.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 10:30:40.603','2023-06-22 08:30:41.617',NULL),('1281f28e-2a3a-11ee-9e90-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_b144ba33-2a36-11ee-9e90-a0510b46b473/occlusion_b147bba1-2a36-11ee-9e90-a0510b46b473/scan_f02043cc-2a39-11ee-9e90-a0510b46b473/1281f28e-2a3a-11ee-9e90-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_b144ba33-2a36-11ee-9e90-a0510b46b473_SESS_b147bba1-2a36-11ee-9e90-a0510b46b473_TOSC_f02043cc-2a39-11ee-9e90-a0510b46b473_MODEL','1281f28e-2a3a-11ee-9e90-a0510b46b473.zip','1281f28e-2a3a-11ee-9e90-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.6.1.5\",\"modelMatrix\":\"0.00429787,0.964379,-0.264491,0,-0.999991,0.00414481,-0.00113676,0,-4.91199e-11,0.264493,0.964387,0,-16.7416,-25.3369,-5.17616,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,'2023-07-24 18:27:21.271','2023-07-24 17:52:20.204','2023-07-24 16:27:21.275',NULL),('1282213c-2a3a-11ee-9e90-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_b144ba33-2a36-11ee-9e90-a0510b46b473/occlusion_b147bba1-2a36-11ee-9e90-a0510b46b473/scan_f02043cc-2a39-11ee-9e90-a0510b46b473/1282213c-2a3a-11ee-9e90-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_b144ba33-2a36-11ee-9e90-a0510b46b473_SESS_b147bba1-2a36-11ee-9e90-a0510b46b473_TOSC_f02043cc-2a39-11ee-9e90-a0510b46b473_SNAPS','1282213c-2a3a-11ee-9e90-a0510b46b473.png','1282213c-2a3a-11ee-9e90-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.6.1.5 Snapshot\"}','PNG',0,'CREATED',0,'2023-07-24 18:27:21.271','2023-07-24 17:52:20.205','2023-07-24 16:27:21.279',NULL),('12a2d8d6-df85-11ed-b6c2-00d86184ce3d',11,'/home/scan/.data//2023/11/ee09109f-df83-11ed-b6c2-00d86184ce3d/session_f3d790be-df83-11ed-b6c2-00d86184ce3d/occlusion_f3d9f61c-df83-11ed-b6c2-00d86184ce3d/scan_c875c3c7-df84-11ed-b6c2-00d86184ce3d/12a2d8d6-df85-11ed-b6c2-00d86184ce3d.zip','PATIENT_ee09109f-df83-11ed-b6c2-00d86184ce3d_ACT_f3d790be-df83-11ed-b6c2-00d86184ce3d_SESS_f3d9f61c-df83-11ed-b6c2-00d86184ce3d_TOSC_c875c3c7-df84-11ed-b6c2-00d86184ce3d_MODEL','12a2d8d6-df85-11ed-b6c2-00d86184ce3d.zip','12a2d8d6-df85-11ed-b6c2-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.8.1.1.3\",\"modelMatrix\":\"0.64255,0.672383,-0.367464,0,-0.766243,0.563842,-0.308145,0,-8.34469e-09,0.479566,0.877506,0,-28.6002,-13.6202,-4.83402,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-20 16:10:15.466','2023-04-20 14:10:16.244',NULL),('12a2e9cf-df85-11ed-b6c2-00d86184ce3d',11,'/home/scan/.data//2023/11/ee09109f-df83-11ed-b6c2-00d86184ce3d/session_f3d790be-df83-11ed-b6c2-00d86184ce3d/occlusion_f3d9f61c-df83-11ed-b6c2-00d86184ce3d/scan_c875c3c7-df84-11ed-b6c2-00d86184ce3d/12a2e9cf-df85-11ed-b6c2-00d86184ce3d.png','PATIENT_ee09109f-df83-11ed-b6c2-00d86184ce3d_ACT_f3d790be-df83-11ed-b6c2-00d86184ce3d_SESS_f3d9f61c-df83-11ed-b6c2-00d86184ce3d_TOSC_c875c3c7-df84-11ed-b6c2-00d86184ce3d_SNAPS','12a2e9cf-df85-11ed-b6c2-00d86184ce3d.png','12a2e9cf-df85-11ed-b6c2-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.8.1.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-20 16:10:15.466','2023-04-20 14:10:16.244',NULL),('12a9a5e5-e02a-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_ed85304d-e024-11ed-bb13-00d86184ce3d/occlusion_ed88a64f-e024-11ed-bb13-00d86184ce3d/scan_e5d64671-e029-11ed-bb13-00d86184ce3d/12a9a5e5-e02a-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_ed85304d-e024-11ed-bb13-00d86184ce3d_SESS_ed88a64f-e024-11ed-bb13-00d86184ce3d_TOSC_e5d64671-e029-11ed-bb13-00d86184ce3d_MODEL','12a9a5e5-e02a-11ed-bb13-00d86184ce3d.zip','12a9a5e5-e02a-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.1.1.5\",\"modelMatrix\":\"-0.19368,0.951419,-0.239351,0,-0.981065,-0.187827,0.0472523,0,-2.39529e-09,0.243971,0.969783,0,-13.2663,-26.5406,-7.95708,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 11:51:22.471','2023-04-21 09:51:23.032',NULL),('12a9bfd7-e02a-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_ed85304d-e024-11ed-bb13-00d86184ce3d/occlusion_ed88a64f-e024-11ed-bb13-00d86184ce3d/scan_e5d64671-e029-11ed-bb13-00d86184ce3d/12a9bfd7-e02a-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_ed85304d-e024-11ed-bb13-00d86184ce3d_SESS_ed88a64f-e024-11ed-bb13-00d86184ce3d_TOSC_e5d64671-e029-11ed-bb13-00d86184ce3d_SNAPS','12a9bfd7-e02a-11ed-bb13-00d86184ce3d.png','12a9bfd7-e02a-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.1.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 11:51:22.471','2023-04-21 09:51:23.033',NULL),('12e41d3b-1ca4-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_06fff4e1-1ca0-11ee-84c4-a0510b46b473/occlusion_0701c127-1ca0-11ee-84c4-a0510b46b473/scan_ba68b485-1ca3-11ee-997b-a0510b46b473/12e41d3b-1ca4-11ee-997b-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_06fff4e1-1ca0-11ee-84c4-a0510b46b473_SESS_0701c127-1ca0-11ee-84c4-a0510b46b473_TOSC_ba68b485-1ca3-11ee-997b-a0510b46b473_MODEL','12e41d3b-1ca4-11ee-997b-a0510b46b473.zip','12e41d3b-1ca4-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.1.1.10\",\"modelMatrix\":\"0.307061,0.930902,-0.197825,0,-0.95169,0.300354,-0.0638279,0,3.65204e-10,0.207867,0.978157,0,-31.3799,-9.72113,-6.81178,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-07 10:55:51.221','2023-07-07 08:55:51.992',NULL),('12e43450-1ca4-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_06fff4e1-1ca0-11ee-84c4-a0510b46b473/occlusion_0701c127-1ca0-11ee-84c4-a0510b46b473/scan_ba68b485-1ca3-11ee-997b-a0510b46b473/12e43450-1ca4-11ee-997b-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_06fff4e1-1ca0-11ee-84c4-a0510b46b473_SESS_0701c127-1ca0-11ee-84c4-a0510b46b473_TOSC_ba68b485-1ca3-11ee-997b-a0510b46b473_SNAPS','12e43450-1ca4-11ee-997b-a0510b46b473.png','12e43450-1ca4-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.1.1.10 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-07 10:55:51.222','2023-07-07 08:55:52.000',NULL),('12f32358-dd04-11ed-8097-00d86184ce3d',11,'/home/scan/.data//2023/11/59af3050-dcfe-11ed-8097-00d86184ce3d/session_61025fcf-dcfe-11ed-8097-00d86184ce3d/occlusion_610548c3-dcfe-11ed-8097-00d86184ce3d/scan_97d8638b-dd03-11ed-8097-00d86184ce3d/12f32358-dd04-11ed-8097-00d86184ce3d.zip','PATIENT_59af3050-dcfe-11ed-8097-00d86184ce3d_ACT_61025fcf-dcfe-11ed-8097-00d86184ce3d_SESS_610548c3-dcfe-11ed-8097-00d86184ce3d_TOSC_97d8638b-dd03-11ed-8097-00d86184ce3d_MODEL','12f32358-dd04-11ed-8097-00d86184ce3d.zip','12f32358-dd04-11ed-8097-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.1.1.1.8\",\"modelMatrix\":\"0.718245,0.647626,-0.254372,0,-0.69579,0.668526,-0.262581,0,2.33635e-08,0.365587,0.930777,0,-28.839,-5.25148,-8.37172,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-04-17 11:41:48.588','2023-04-17 09:41:49.666','2023-04-17 11:41:50.076'),('12f33116-dd04-11ed-8097-00d86184ce3d',11,'/home/scan/.data//2023/11/59af3050-dcfe-11ed-8097-00d86184ce3d/session_61025fcf-dcfe-11ed-8097-00d86184ce3d/occlusion_610548c3-dcfe-11ed-8097-00d86184ce3d/scan_97d8638b-dd03-11ed-8097-00d86184ce3d/12f33116-dd04-11ed-8097-00d86184ce3d.png','PATIENT_59af3050-dcfe-11ed-8097-00d86184ce3d_ACT_61025fcf-dcfe-11ed-8097-00d86184ce3d_SESS_610548c3-dcfe-11ed-8097-00d86184ce3d_TOSC_97d8638b-dd03-11ed-8097-00d86184ce3d_SNAPS','12f33116-dd04-11ed-8097-00d86184ce3d.png','12f33116-dd04-11ed-8097-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.1.1.1.8 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-04-17 11:41:48.588','2023-04-17 09:41:49.668','2023-04-17 11:41:50.230'),('1343aca8-14e8-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_efcc55aa-14e3-11ee-b3b1-00d86184ce3d/occlusion_efcf357e-14e3-11ee-b3b1-00d86184ce3d/scan_b7f2a93d-14e7-11ee-b3b1-00d86184ce3d/1343aca8-14e8-11ee-b3b1-00d86184ce3d.zip','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_efcc55aa-14e3-11ee-b3b1-00d86184ce3d_SESS_efcf357e-14e3-11ee-b3b1-00d86184ce3d_TOSC_b7f2a93d-14e7-11ee-b3b1-00d86184ce3d_MODEL','1343aca8-14e8-11ee-b3b1-00d86184ce3d.zip','1343aca8-14e8-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.20.3.1.8\",\"modelMatrix\":\"0.646443,0.751348,-0.13262,0,-0.762963,0.636602,-0.112366,0,3.95711e-09,0.173823,0.984777,0,-29.378,-10.0093,-11.2239,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-27 14:42:28.323','2023-06-27 12:42:29.164',NULL),('1343c239-14e8-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_efcc55aa-14e3-11ee-b3b1-00d86184ce3d/occlusion_efcf357e-14e3-11ee-b3b1-00d86184ce3d/scan_b7f2a93d-14e7-11ee-b3b1-00d86184ce3d/1343c239-14e8-11ee-b3b1-00d86184ce3d.png','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_efcc55aa-14e3-11ee-b3b1-00d86184ce3d_SESS_efcf357e-14e3-11ee-b3b1-00d86184ce3d_TOSC_b7f2a93d-14e7-11ee-b3b1-00d86184ce3d_SNAPS','1343c239-14e8-11ee-b3b1-00d86184ce3d.png','1343c239-14e8-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.20.3.1.8 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-27 14:42:28.324','2023-06-27 12:42:29.174',NULL),('142de525-e345-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_853ebc79-e33f-11ed-8c5e-00d86184ce3d/occlusion_8541c500-e33f-11ed-8c5e-00d86184ce3d/scan_b9154ae8-e344-11ed-8c5e-00d86184ce3d/142de525-e345-11ed-8c5e-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_853ebc79-e33f-11ed-8c5e-00d86184ce3d_SESS_8541c500-e33f-11ed-8c5e-00d86184ce3d_TOSC_b9154ae8-e344-11ed-8c5e-00d86184ce3d_MODEL','142de525-e345-11ed-8c5e-00d86184ce3d.zip','142de525-e345-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.6.1.8\",\"modelMatrix\":\"0.344782,0.913077,-0.217751,0,-0.938683,0.335377,-0.0799806,0,5.34714e-09,0.231975,0.972722,0,-26.0168,-16.24,-7.98867,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-25 10:42:14.915','2023-04-25 08:42:15.894',NULL),('142dfc62-e345-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_853ebc79-e33f-11ed-8c5e-00d86184ce3d/occlusion_8541c500-e33f-11ed-8c5e-00d86184ce3d/scan_b9154ae8-e344-11ed-8c5e-00d86184ce3d/142dfc62-e345-11ed-8c5e-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_853ebc79-e33f-11ed-8c5e-00d86184ce3d_SESS_8541c500-e33f-11ed-8c5e-00d86184ce3d_TOSC_b9154ae8-e344-11ed-8c5e-00d86184ce3d_SNAPS','142dfc62-e345-11ed-8c5e-00d86184ce3d.png','142dfc62-e345-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.6.1.8 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-25 10:42:14.916','2023-04-25 08:42:15.895',NULL),('14e23216-deae-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/e0d449f3-dde9-11ed-aa56-00d86184ce3d/session_858fcc60-de94-11ed-9cc3-00d86184ce3d/occlusion_85925fd9-de94-11ed-9cc3-00d86184ce3d/scan_fc7714d6-dead-11ed-9cc3-00d86184ce3d/14e23216-deae-11ed-9cc3-00d86184ce3d.zip','PATIENT_e0d449f3-dde9-11ed-aa56-00d86184ce3d_ACT_858fcc60-de94-11ed-9cc3-00d86184ce3d_SESS_85925fd9-de94-11ed-9cc3-00d86184ce3d_TOSC_fc7714d6-dead-11ed-9cc3-00d86184ce3d_MODEL','14e23216-deae-11ed-9cc3-00d86184ce3d.zip','14e23216-deae-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.2.1.1.2\",\"modelMatrix\":\"-0.287773,0.949298,-0.126575,0,-0.957699,-0.285248,0.0380337,0,-5.24256e-10,0.132166,0.991228,0,-8.73195,-24.9465,-9.54304,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-19 14:31:17.439','2023-04-19 12:31:17.635',NULL),('14e24b06-deae-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/e0d449f3-dde9-11ed-aa56-00d86184ce3d/session_858fcc60-de94-11ed-9cc3-00d86184ce3d/occlusion_85925fd9-de94-11ed-9cc3-00d86184ce3d/scan_fc7714d6-dead-11ed-9cc3-00d86184ce3d/14e24b06-deae-11ed-9cc3-00d86184ce3d.png','PATIENT_e0d449f3-dde9-11ed-aa56-00d86184ce3d_ACT_858fcc60-de94-11ed-9cc3-00d86184ce3d_SESS_85925fd9-de94-11ed-9cc3-00d86184ce3d_TOSC_fc7714d6-dead-11ed-9cc3-00d86184ce3d_SNAPS','14e24b06-deae-11ed-9cc3-00d86184ce3d.png','14e24b06-deae-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.2.1.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-19 14:31:17.440','2023-04-19 12:31:17.637',NULL),('154bfece-2ac1-11ee-80c8-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_3a881645-2abf-11ee-80c8-a0510b46b473/occlusion_3a8b3537-2abf-11ee-80c8-a0510b46b473/scan_d74bb56b-2ac0-11ee-80c8-a0510b46b473/154bfece-2ac1-11ee-80c8-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_3a881645-2abf-11ee-80c8-a0510b46b473_SESS_3a8b3537-2abf-11ee-80c8-a0510b46b473_TOSC_d74bb56b-2ac0-11ee-80c8-a0510b46b473_MODEL','154bfece-2ac1-11ee-80c8-a0510b46b473.zip','154bfece-2ac1-11ee-80c8-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.7.1.4\",\"modelMatrix\":\"0.319356,-0.935839,0.14905,0,0.947635,0.315381,-0.0502305,0,1.66655e-09,0.157287,0.987553,0,9.89327,29.7873,-10.7796,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-25 09:58:46.942','2023-07-25 07:58:47.502',NULL),('154c1688-2ac1-11ee-80c8-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_3a881645-2abf-11ee-80c8-a0510b46b473/occlusion_3a8b3537-2abf-11ee-80c8-a0510b46b473/scan_d74bb56b-2ac0-11ee-80c8-a0510b46b473/154c1688-2ac1-11ee-80c8-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_3a881645-2abf-11ee-80c8-a0510b46b473_SESS_3a8b3537-2abf-11ee-80c8-a0510b46b473_TOSC_d74bb56b-2ac0-11ee-80c8-a0510b46b473_SNAPS','154c1688-2ac1-11ee-80c8-a0510b46b473.png','154c1688-2ac1-11ee-80c8-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.7.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-25 09:58:46.942','2023-07-25 07:58:47.503',NULL),('1598b944-0f79-11ee-9460-a0510b46b473',11,'/home/scan/.data//2023/11/e4b67639-0f72-11ee-8712-a0510b46b473/session_ec7935d6-0f72-11ee-8712-a0510b46b473/occlusion_ec7bd8ad-0f72-11ee-8712-a0510b46b473/scan_ae8c6e1d-0f78-11ee-9460-a0510b46b473/1598b944-0f79-11ee-9460-a0510b46b473.zip','PATIENT_e4b67639-0f72-11ee-8712-a0510b46b473_ACT_ec7935d6-0f72-11ee-8712-a0510b46b473_SESS_ec7bd8ad-0f72-11ee-8712-a0510b46b473_TOSC_ae8c6e1d-0f78-11ee-9460-a0510b46b473_MODEL','1598b944-0f79-11ee-9460-a0510b46b473.zip','1598b944-0f79-11ee-9460-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.15.1.1.7\",\"modelMatrix\":\"0.610799,0.739124,-0.283937,0,-0.791786,0.570175,-0.219035,0,1.28318e-08,0.358604,0.93349,0,-28.7185,-0.747886,-9.11347,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-20 16:45:22.285','2023-06-20 14:45:23.100',NULL),('1598cf1c-0f79-11ee-9460-a0510b46b473',11,'/home/scan/.data//2023/11/e4b67639-0f72-11ee-8712-a0510b46b473/session_ec7935d6-0f72-11ee-8712-a0510b46b473/occlusion_ec7bd8ad-0f72-11ee-8712-a0510b46b473/scan_ae8c6e1d-0f78-11ee-9460-a0510b46b473/1598cf1c-0f79-11ee-9460-a0510b46b473.png','PATIENT_e4b67639-0f72-11ee-8712-a0510b46b473_ACT_ec7935d6-0f72-11ee-8712-a0510b46b473_SESS_ec7bd8ad-0f72-11ee-8712-a0510b46b473_TOSC_ae8c6e1d-0f78-11ee-9460-a0510b46b473_SNAPS','1598cf1c-0f79-11ee-9460-a0510b46b473.png','1598cf1c-0f79-11ee-9460-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.15.1.1.7 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-20 16:45:22.286','2023-06-20 14:45:23.100',NULL),('17b9f1bd-2701-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/848c86d9-26fd-11ee-a98e-a0510b46b473/session_8f62cd50-26fd-11ee-a98e-a0510b46b473/occlusion_8f65e2e0-26fd-11ee-a98e-a0510b46b473/scan_bec8f72e-2700-11ee-a98e-a0510b46b473/17b9f1bd-2701-11ee-a98e-a0510b46b473.zip','PATIENT_848c86d9-26fd-11ee-a98e-a0510b46b473_ACT_8f62cd50-26fd-11ee-a98e-a0510b46b473_SESS_8f65e2e0-26fd-11ee-a98e-a0510b46b473_TOSC_bec8f72e-2700-11ee-a98e-a0510b46b473_MODEL','17b9f1bd-2701-11ee-a98e-a0510b46b473.zip','17b9f1bd-2701-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.36.1.1.8\",\"modelMatrix\":\"0.031893,0.945564,-0.323871,0,-0.999491,0.0301722,-0.0103345,0,-1.64638e-10,0.324036,0.946045,0,-22.823,-28.4095,-8.7668,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-20 15:26:54.157','2023-07-20 13:26:54.946',NULL),('17ba0be8-2701-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/848c86d9-26fd-11ee-a98e-a0510b46b473/session_8f62cd50-26fd-11ee-a98e-a0510b46b473/occlusion_8f65e2e0-26fd-11ee-a98e-a0510b46b473/scan_bec8f72e-2700-11ee-a98e-a0510b46b473/17ba0be8-2701-11ee-a98e-a0510b46b473.png','PATIENT_848c86d9-26fd-11ee-a98e-a0510b46b473_ACT_8f62cd50-26fd-11ee-a98e-a0510b46b473_SESS_8f65e2e0-26fd-11ee-a98e-a0510b46b473_TOSC_bec8f72e-2700-11ee-a98e-a0510b46b473_SNAPS','17ba0be8-2701-11ee-a98e-a0510b46b473.png','17ba0be8-2701-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.36.1.1.8 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-20 15:26:54.158','2023-07-20 13:26:54.947',NULL),('184cdec8-1bdc-11ee-9086-a0510b46b473',11,'/home/scan/.data//2023/11/61e16a70-1a76-11ee-8124-a0510b46b473/session_d30b0955-1bdb-11ee-9086-a0510b46b473/occlusion_d30df7f0-1bdb-11ee-9086-a0510b46b473/scan_d41c5a8f-1bdb-11ee-9086-a0510b46b473/184cdec8-1bdc-11ee-9086-a0510b46b473.zip','PATIENT_61e16a70-1a76-11ee-8124-a0510b46b473_ACT_d30b0955-1bdb-11ee-9086-a0510b46b473_SESS_d30df7f0-1bdb-11ee-9086-a0510b46b473_TOSC_d41c5a8f-1bdb-11ee-9086-a0510b46b473_MODEL','184cdec8-1bdc-11ee-9086-a0510b46b473.zip','184cdec8-1bdc-11ee-9086-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.27.4.1.1\",\"modelMatrix\":\"0.845916,0.505433,-0.170185,0,-0.533316,0.801691,-0.269938,0,-1.52258e-08,0.319107,0.947719,0,-29.5363,7.98009,-11.0819,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 11:04:20.951','2023-07-06 09:04:21.366',NULL),('184cf667-1bdc-11ee-9086-a0510b46b473',11,'/home/scan/.data//2023/11/61e16a70-1a76-11ee-8124-a0510b46b473/session_d30b0955-1bdb-11ee-9086-a0510b46b473/occlusion_d30df7f0-1bdb-11ee-9086-a0510b46b473/scan_d41c5a8f-1bdb-11ee-9086-a0510b46b473/184cf667-1bdc-11ee-9086-a0510b46b473.png','PATIENT_61e16a70-1a76-11ee-8124-a0510b46b473_ACT_d30b0955-1bdb-11ee-9086-a0510b46b473_SESS_d30df7f0-1bdb-11ee-9086-a0510b46b473_TOSC_d41c5a8f-1bdb-11ee-9086-a0510b46b473_SNAPS','184cf667-1bdc-11ee-9086-a0510b46b473.png','184cf667-1bdc-11ee-9086-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.27.4.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 11:04:20.951','2023-07-06 09:04:21.374',NULL),('18f6aaa8-2700-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/848c86d9-26fd-11ee-a98e-a0510b46b473/session_8f62cd50-26fd-11ee-a98e-a0510b46b473/occlusion_8f65e2e0-26fd-11ee-a98e-a0510b46b473/scan_b34cd124-26ff-11ee-a98e-a0510b46b473/18f6aaa8-2700-11ee-a98e-a0510b46b473.zip','PATIENT_848c86d9-26fd-11ee-a98e-a0510b46b473_ACT_8f62cd50-26fd-11ee-a98e-a0510b46b473_SESS_8f65e2e0-26fd-11ee-a98e-a0510b46b473_TOSC_b34cd124-26ff-11ee-a98e-a0510b46b473_MODEL','18f6aaa8-2700-11ee-a98e-a0510b46b473.zip','18f6aaa8-2700-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.36.1.1.5\",\"modelMatrix\":\"-0.343933,0.928507,-0.139944,0,-0.938994,-0.340092,0.0512583,0,5.11156e-11,0.149036,0.988832,0,-4.44619,-36.0342,-11.7432,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-20 15:19:46.736','2023-07-20 13:19:47.493',NULL),('18f6c243-2700-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/848c86d9-26fd-11ee-a98e-a0510b46b473/session_8f62cd50-26fd-11ee-a98e-a0510b46b473/occlusion_8f65e2e0-26fd-11ee-a98e-a0510b46b473/scan_b34cd124-26ff-11ee-a98e-a0510b46b473/18f6c243-2700-11ee-a98e-a0510b46b473.png','PATIENT_848c86d9-26fd-11ee-a98e-a0510b46b473_ACT_8f62cd50-26fd-11ee-a98e-a0510b46b473_SESS_8f65e2e0-26fd-11ee-a98e-a0510b46b473_TOSC_b34cd124-26ff-11ee-a98e-a0510b46b473_SNAPS','18f6c243-2700-11ee-a98e-a0510b46b473.png','18f6c243-2700-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.36.1.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-20 15:19:46.737','2023-07-20 13:19:47.494',NULL),('192547a5-10e3-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/2ff330cd-10e1-11ee-b636-a0510b46b473/session_3adeac35-10e1-11ee-b636-a0510b46b473/occlusion_3ae23ec4-10e1-11ee-b636-a0510b46b473/scan_b66a1e03-10e2-11ee-b636-a0510b46b473/192547a5-10e3-11ee-b636-a0510b46b473.zip','PATIENT_2ff330cd-10e1-11ee-b636-a0510b46b473_ACT_3adeac35-10e1-11ee-b636-a0510b46b473_SESS_3ae23ec4-10e1-11ee-b636-a0510b46b473_TOSC_b66a1e03-10e2-11ee-b636-a0510b46b473_MODEL','192547a5-10e3-11ee-b636-a0510b46b473.zip','192547a5-10e3-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.18.1.1.5\",\"modelMatrix\":\"-0.182213,0.968057,-0.172235,0,-0.983259,-0.179395,0.0319178,0,-1.59519e-09,0.175168,0.984539,0,-15.7351,-28.1778,-9.009,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 11:56:46.055','2023-06-22 09:56:46.800',NULL),('19255e77-10e3-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/2ff330cd-10e1-11ee-b636-a0510b46b473/session_3adeac35-10e1-11ee-b636-a0510b46b473/occlusion_3ae23ec4-10e1-11ee-b636-a0510b46b473/scan_b66a1e03-10e2-11ee-b636-a0510b46b473/19255e77-10e3-11ee-b636-a0510b46b473.png','PATIENT_2ff330cd-10e1-11ee-b636-a0510b46b473_ACT_3adeac35-10e1-11ee-b636-a0510b46b473_SESS_3ae23ec4-10e1-11ee-b636-a0510b46b473_TOSC_b66a1e03-10e2-11ee-b636-a0510b46b473_SNAPS','19255e77-10e3-11ee-b636-a0510b46b473.png','19255e77-10e3-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.18.1.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 11:56:46.056','2023-06-22 09:56:46.809',NULL),('196e907d-1a6d-11ee-af16-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_77df3b68-1a6c-11ee-af16-a0510b46b473/occlusion_77e234a6-1a6c-11ee-af16-a0510b46b473/scan_79325a91-1a6c-11ee-af16-a0510b46b473/196e907d-1a6d-11ee-af16-a0510b46b473.zip','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_77df3b68-1a6c-11ee-af16-a0510b46b473_SESS_77e234a6-1a6c-11ee-af16-a0510b46b473_TOSC_79325a91-1a6c-11ee-af16-a0510b46b473_MODEL','196e907d-1a6d-11ee-af16-a0510b46b473.zip','196e907d-1a6d-11ee-af16-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.4.1.1\",\"modelMatrix\":\"-0.344262,0.892075,-0.292721,0,-0.938874,-0.327102,0.107333,0,3.12571e-09,0.311779,0.950155,0,-14.3402,-28.6341,-6.6808,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-04 15:17:17.549','2023-07-04 13:17:21.741',NULL),('196f32c3-1a6d-11ee-af16-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_77df3b68-1a6c-11ee-af16-a0510b46b473/occlusion_77e234a6-1a6c-11ee-af16-a0510b46b473/scan_79325a91-1a6c-11ee-af16-a0510b46b473/196f32c3-1a6d-11ee-af16-a0510b46b473.png','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_77df3b68-1a6c-11ee-af16-a0510b46b473_SESS_77e234a6-1a6c-11ee-af16-a0510b46b473_TOSC_79325a91-1a6c-11ee-af16-a0510b46b473_SNAPS','196f32c3-1a6d-11ee-af16-a0510b46b473.png','196f32c3-1a6d-11ee-af16-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.4.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-04 15:17:17.553','2023-07-04 13:17:21.744',NULL),('1a91a898-de81-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/f29210da-de80-11ed-9cc3-00d86184ce3d/session_ffdb9942-de80-11ed-9cc3-00d86184ce3d/occlusion_ffdebb3e-de80-11ed-9cc3-00d86184ce3d/scan_0247ff51-de81-11ed-9cc3-00d86184ce3d/1a91a898-de81-11ed-9cc3-00d86184ce3d.zip','PATIENT_f29210da-de80-11ed-9cc3-00d86184ce3d_ACT_ffdb9942-de80-11ed-9cc3-00d86184ce3d_SESS_ffdebb3e-de80-11ed-9cc3-00d86184ce3d_TOSC_0247ff51-de81-11ed-9cc3-00d86184ce3d_MODEL','1a91a898-de81-11ed-9cc3-00d86184ce3d.zip','1a91a898-de81-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.3.1.1.1\",\"modelMatrix\":\"0.788184,0.615033,-0.0223461,0,-0.615439,0.787665,-0.0286183,0,-1.03328e-09,0.0363091,0.999341,0,-6.29597,-8.86862,-16.8525,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,'2023-04-19 09:39:14.382','2023-04-19 09:09:19.625','2023-04-19 07:39:14.386','2023-04-19 09:39:14.410'),('1a91beb7-de81-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/f29210da-de80-11ed-9cc3-00d86184ce3d/session_ffdb9942-de80-11ed-9cc3-00d86184ce3d/occlusion_ffdebb3e-de80-11ed-9cc3-00d86184ce3d/scan_0247ff51-de81-11ed-9cc3-00d86184ce3d/1a91beb7-de81-11ed-9cc3-00d86184ce3d.png','PATIENT_f29210da-de80-11ed-9cc3-00d86184ce3d_ACT_ffdb9942-de80-11ed-9cc3-00d86184ce3d_SESS_ffdebb3e-de80-11ed-9cc3-00d86184ce3d_TOSC_0247ff51-de81-11ed-9cc3-00d86184ce3d_SNAPS','1a91beb7-de81-11ed-9cc3-00d86184ce3d.png','1a91beb7-de81-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.3.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,'2023-04-19 09:39:14.382','2023-04-19 09:09:19.626','2023-04-19 07:39:14.389','2023-04-19 09:39:14.411'),('1ac0caa8-deb8-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/cf3f0588-deb2-11ed-9cc3-00d86184ce3d/session_d7750b8d-deb2-11ed-9cc3-00d86184ce3d/occlusion_d7775a50-deb2-11ed-9cc3-00d86184ce3d/scan_c193e4f6-deb7-11ed-9cc3-00d86184ce3d/1ac0caa8-deb8-11ed-9cc3-00d86184ce3d.zip','PATIENT_cf3f0588-deb2-11ed-9cc3-00d86184ce3d_ACT_d7750b8d-deb2-11ed-9cc3-00d86184ce3d_SESS_d7775a50-deb2-11ed-9cc3-00d86184ce3d_TOSC_c193e4f6-deb7-11ed-9cc3-00d86184ce3d_MODEL','1ac0caa8-deb8-11ed-9cc3-00d86184ce3d.zip','1ac0caa8-deb8-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.6.1.1.8\",\"modelMatrix\":\"0.5594,0.821758,-0.10856,0,-0.828898,0.554582,-0.0732639,0,-6.84572e-11,0.130969,0.991387,0,-27.7035,-12.6492,-9.91968,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-19 15:43:02.254','2023-04-19 13:43:03.207',NULL),('1ac0e38f-deb8-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/cf3f0588-deb2-11ed-9cc3-00d86184ce3d/session_d7750b8d-deb2-11ed-9cc3-00d86184ce3d/occlusion_d7775a50-deb2-11ed-9cc3-00d86184ce3d/scan_c193e4f6-deb7-11ed-9cc3-00d86184ce3d/1ac0e38f-deb8-11ed-9cc3-00d86184ce3d.png','PATIENT_cf3f0588-deb2-11ed-9cc3-00d86184ce3d_ACT_d7750b8d-deb2-11ed-9cc3-00d86184ce3d_SESS_d7775a50-deb2-11ed-9cc3-00d86184ce3d_TOSC_c193e4f6-deb7-11ed-9cc3-00d86184ce3d_SNAPS','1ac0e38f-deb8-11ed-9cc3-00d86184ce3d.png','1ac0e38f-deb8-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.6.1.1.8 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-19 15:43:02.255','2023-04-19 13:43:03.209',NULL),('1aeae53b-e01b-11ed-b6c2-00d86184ce3d',11,'/home/scan/.data//2023/11/e0d449f3-dde9-11ed-aa56-00d86184ce3d/session_858fcc60-de94-11ed-9cc3-00d86184ce3d/occlusion_85925fd9-de94-11ed-9cc3-00d86184ce3d/scan_042aff0b-e01b-11ed-b6c2-00d86184ce3d/1aeae53b-e01b-11ed-b6c2-00d86184ce3d.zip','PATIENT_e0d449f3-dde9-11ed-aa56-00d86184ce3d_ACT_858fcc60-de94-11ed-9cc3-00d86184ce3d_SESS_85925fd9-de94-11ed-9cc3-00d86184ce3d_TOSC_042aff0b-e01b-11ed-b6c2-00d86184ce3d_MODEL','1aeae53b-e01b-11ed-b6c2-00d86184ce3d.zip','1aeae53b-e01b-11ed-b6c2-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.2.1.1.8\",\"modelMatrix\":\"-0.869871,0.458709,-0.181413,0,-0.49328,-0.808908,0.319911,0,-9.83348e-09,0.367768,0.929918,0,21.4844,-19.0089,-6.52154,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 10:04:13.869','2023-04-21 08:04:14.094',NULL),('1aeafc27-e01b-11ed-b6c2-00d86184ce3d',11,'/home/scan/.data//2023/11/e0d449f3-dde9-11ed-aa56-00d86184ce3d/session_858fcc60-de94-11ed-9cc3-00d86184ce3d/occlusion_85925fd9-de94-11ed-9cc3-00d86184ce3d/scan_042aff0b-e01b-11ed-b6c2-00d86184ce3d/1aeafc27-e01b-11ed-b6c2-00d86184ce3d.png','PATIENT_e0d449f3-dde9-11ed-aa56-00d86184ce3d_ACT_858fcc60-de94-11ed-9cc3-00d86184ce3d_SESS_85925fd9-de94-11ed-9cc3-00d86184ce3d_TOSC_042aff0b-e01b-11ed-b6c2-00d86184ce3d_SNAPS','1aeafc27-e01b-11ed-b6c2-00d86184ce3d.png','1aeafc27-e01b-11ed-b6c2-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.2.1.1.8 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 10:04:13.870','2023-04-21 08:04:14.095',NULL),('1b13d4e9-e34b-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/971e14b0-e348-11ed-8c5e-00d86184ce3d/session_d6f9d6f4-e34a-11ed-8c5e-00d86184ce3d/occlusion_d6fcc5ab-e34a-11ed-8c5e-00d86184ce3d/scan_d8157298-e34a-11ed-8c5e-00d86184ce3d/1b13d4e9-e34b-11ed-8c5e-00d86184ce3d.zip','PATIENT_971e14b0-e348-11ed-8c5e-00d86184ce3d_ACT_d6f9d6f4-e34a-11ed-8c5e-00d86184ce3d_SESS_d6fcc5ab-e34a-11ed-8c5e-00d86184ce3d_TOSC_d8157298-e34a-11ed-8c5e-00d86184ce3d_MODEL','1b13d4e9-e34b-11ed-8c5e-00d86184ce3d.zip','1b13d4e9-e34b-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.12.2.1.1\",\"modelMatrix\":\"0.402463,0.854802,-0.327624,0,-0.915436,0.375806,-0.144037,0,-1.54866e-08,0.357889,0.933764,0,-31.3957,-8.63013,-4.7747,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-25 11:25:23.469','2023-04-25 09:25:24.100',NULL),('1b14006c-e34b-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/971e14b0-e348-11ed-8c5e-00d86184ce3d/session_d6f9d6f4-e34a-11ed-8c5e-00d86184ce3d/occlusion_d6fcc5ab-e34a-11ed-8c5e-00d86184ce3d/scan_d8157298-e34a-11ed-8c5e-00d86184ce3d/1b14006c-e34b-11ed-8c5e-00d86184ce3d.png','PATIENT_971e14b0-e348-11ed-8c5e-00d86184ce3d_ACT_d6f9d6f4-e34a-11ed-8c5e-00d86184ce3d_SESS_d6fcc5ab-e34a-11ed-8c5e-00d86184ce3d_TOSC_d8157298-e34a-11ed-8c5e-00d86184ce3d_SNAPS','1b14006c-e34b-11ed-8c5e-00d86184ce3d.png','1b14006c-e34b-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.12.2.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-25 11:25:23.470','2023-04-25 09:25:24.100',NULL),('1bad748c-14ca-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/9619fcac-14c3-11ee-b3b1-00d86184ce3d/session_961b9a11-14c3-11ee-b3b1-00d86184ce3d/occlusion_961d56b4-14c3-11ee-b3b1-00d86184ce3d/scan_b9636018-14c9-11ee-b3b1-00d86184ce3d/1bad748c-14ca-11ee-b3b1-00d86184ce3d.zip','PATIENT_9619fcac-14c3-11ee-b3b1-00d86184ce3d_ACT_961b9a11-14c3-11ee-b3b1-00d86184ce3d_SESS_961d56b4-14c3-11ee-b3b1-00d86184ce3d_TOSC_b9636018-14c9-11ee-b3b1-00d86184ce3d_MODEL','1bad748c-14ca-11ee-b3b1-00d86184ce3d.zip','1bad748c-14ca-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.22.1.1.7\",\"modelMatrix\":\"0.667353,0.712474,-0.216842,0,-0.744742,0.638439,-0.194309,0,4.05173e-09,0.291164,0.956673,0,-27.9742,-14.1126,-8.67308,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-27 11:07:57.536','2023-06-27 09:07:58.350',NULL),('1bad8bda-14ca-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/9619fcac-14c3-11ee-b3b1-00d86184ce3d/session_961b9a11-14c3-11ee-b3b1-00d86184ce3d/occlusion_961d56b4-14c3-11ee-b3b1-00d86184ce3d/scan_b9636018-14c9-11ee-b3b1-00d86184ce3d/1bad8bda-14ca-11ee-b3b1-00d86184ce3d.png','PATIENT_9619fcac-14c3-11ee-b3b1-00d86184ce3d_ACT_961b9a11-14c3-11ee-b3b1-00d86184ce3d_SESS_961d56b4-14c3-11ee-b3b1-00d86184ce3d_TOSC_b9636018-14c9-11ee-b3b1-00d86184ce3d_SNAPS','1bad8bda-14ca-11ee-b3b1-00d86184ce3d.png','1bad8bda-14ca-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.22.1.1.7 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-27 11:07:57.537','2023-06-27 09:07:58.351',NULL),('1c19defb-e03d-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_6f09f9a8-e03a-11ed-bb13-00d86184ce3d/occlusion_6f0c3cda-e03a-11ed-bb13-00d86184ce3d/scan_f949f392-e03c-11ed-bb13-00d86184ce3d/1c19defb-e03d-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_6f09f9a8-e03a-11ed-bb13-00d86184ce3d_SESS_6f0c3cda-e03a-11ed-bb13-00d86184ce3d_TOSC_f949f392-e03c-11ed-bb13-00d86184ce3d_MODEL','1c19defb-e03d-11ed-bb13-00d86184ce3d.zip','1c19defb-e03d-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.3.1.12\",\"modelMatrix\":\"0.910629,0.35084,-0.218325,0,-0.413225,0.773151,-0.481126,0,3.66282e-09,0.528345,0.84903,0,-19.501,-9.08195,-7.39478,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 14:07:38.743','2023-04-21 12:07:39.070',NULL),('1c19f552-e03d-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_6f09f9a8-e03a-11ed-bb13-00d86184ce3d/occlusion_6f0c3cda-e03a-11ed-bb13-00d86184ce3d/scan_f949f392-e03c-11ed-bb13-00d86184ce3d/1c19f552-e03d-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_6f09f9a8-e03a-11ed-bb13-00d86184ce3d_SESS_6f0c3cda-e03a-11ed-bb13-00d86184ce3d_TOSC_f949f392-e03c-11ed-bb13-00d86184ce3d_SNAPS','1c19f552-e03d-11ed-bb13-00d86184ce3d.png','1c19f552-e03d-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.3.1.12 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 14:07:38.744','2023-04-21 12:07:39.070',NULL),('1cd56b26-e044-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_5a5a69f7-e042-11ed-bb13-00d86184ce3d/occlusion_5a5d89b2-e042-11ed-bb13-00d86184ce3d/scan_e0750e02-e043-11ed-bb13-00d86184ce3d/1cd56b26-e044-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_5a5a69f7-e042-11ed-bb13-00d86184ce3d_SESS_5a5d89b2-e042-11ed-bb13-00d86184ce3d_TOSC_e0750e02-e043-11ed-bb13-00d86184ce3d_MODEL','1cd56b26-e044-11ed-bb13-00d86184ce3d.zip','1cd56b26-e044-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.5.1.4\",\"modelMatrix\":\"0.455438,0.834137,-0.311115,0,-0.890268,0.426722,-0.159159,0,1.16681e-08,0.349463,0.93695,0,-33.7358,-9.03169,-6.36943,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 14:57:46.450','2023-04-21 12:57:46.988',NULL),('1cd582dc-e044-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_5a5a69f7-e042-11ed-bb13-00d86184ce3d/occlusion_5a5d89b2-e042-11ed-bb13-00d86184ce3d/scan_e0750e02-e043-11ed-bb13-00d86184ce3d/1cd582dc-e044-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_5a5a69f7-e042-11ed-bb13-00d86184ce3d_SESS_5a5d89b2-e042-11ed-bb13-00d86184ce3d_TOSC_e0750e02-e043-11ed-bb13-00d86184ce3d_SNAPS','1cd582dc-e044-11ed-bb13-00d86184ce3d.png','1cd582dc-e044-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.5.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 14:57:46.450','2023-04-21 12:57:46.988',NULL),('1d18ede4-dd18-11ed-8097-00d86184ce3d',11,'/home/scan/.data//2023/11/59af3050-dcfe-11ed-8097-00d86184ce3d/session_aed62174-dd16-11ed-8097-00d86184ce3d/occlusion_aed90f86-dd16-11ed-8097-00d86184ce3d/scan_a3ecafac-dd17-11ed-8097-00d86184ce3d/1d18ede4-dd18-11ed-8097-00d86184ce3d.zip','PATIENT_59af3050-dcfe-11ed-8097-00d86184ce3d_ACT_aed62174-dd16-11ed-8097-00d86184ce3d_SESS_aed90f86-dd16-11ed-8097-00d86184ce3d_TOSC_a3ecafac-dd17-11ed-8097-00d86184ce3d_MODEL','1d18ede4-dd18-11ed-8097-00d86184ce3d.zip','1d18ede4-dd18-11ed-8097-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.1.2.1.3\",\"modelMatrix\":\"-0.115938,0.993051,-0.0202129,0,-0.993256,-0.115914,0.00235936,0,7.20435e-12,0.0203501,0.999793,0,-17.7548,-16.4246,-14.4853,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-04-17 14:05:15.548','2023-04-17 12:05:16.813','2023-04-17 14:05:17.202'),('1d1906d5-dd18-11ed-8097-00d86184ce3d',11,'/home/scan/.data//2023/11/59af3050-dcfe-11ed-8097-00d86184ce3d/session_aed62174-dd16-11ed-8097-00d86184ce3d/occlusion_aed90f86-dd16-11ed-8097-00d86184ce3d/scan_a3ecafac-dd17-11ed-8097-00d86184ce3d/1d1906d5-dd18-11ed-8097-00d86184ce3d.png','PATIENT_59af3050-dcfe-11ed-8097-00d86184ce3d_ACT_aed62174-dd16-11ed-8097-00d86184ce3d_SESS_aed90f86-dd16-11ed-8097-00d86184ce3d_TOSC_a3ecafac-dd17-11ed-8097-00d86184ce3d_SNAPS','1d1906d5-dd18-11ed-8097-00d86184ce3d.png','1d1906d5-dd18-11ed-8097-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.1.2.1.3 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-04-17 14:05:15.548','2023-04-17 12:05:16.814','2023-04-17 14:05:17.321'),('1d56384a-2aea-11ee-97fa-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_8b758c52-2ae7-11ee-97fa-a0510b46b473/occlusion_8b789858-2ae7-11ee-97fa-a0510b46b473/scan_e04138a5-2ae9-11ee-97fa-a0510b46b473/1d56384a-2aea-11ee-97fa-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_8b758c52-2ae7-11ee-97fa-a0510b46b473_SESS_8b789858-2ae7-11ee-97fa-a0510b46b473_TOSC_e04138a5-2ae9-11ee-97fa-a0510b46b473_MODEL','1d56384a-2aea-11ee-97fa-a0510b46b473.zip','1d56384a-2aea-11ee-97fa-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.9.1.5\",\"modelMatrix\":\"0.804376,0.576194,-0.144845,0,-0.594121,0.780105,-0.196104,0,1.23201e-08,0.243797,0.969826,0,-28.1775,-2.23951,-12.7069,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-25 14:52:29.796','2023-07-25 12:52:30.335',NULL),('1d56d178-2aea-11ee-97fa-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_8b758c52-2ae7-11ee-97fa-a0510b46b473/occlusion_8b789858-2ae7-11ee-97fa-a0510b46b473/scan_e04138a5-2ae9-11ee-97fa-a0510b46b473/1d56d178-2aea-11ee-97fa-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_8b758c52-2ae7-11ee-97fa-a0510b46b473_SESS_8b789858-2ae7-11ee-97fa-a0510b46b473_TOSC_e04138a5-2ae9-11ee-97fa-a0510b46b473_SNAPS','1d56d178-2aea-11ee-97fa-a0510b46b473.png','1d56d178-2aea-11ee-97fa-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.9.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-25 14:52:29.800','2023-07-25 12:52:30.335',NULL),('1da727b9-1bd1-11ee-9086-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_a6b1a4bd-1bcf-11ee-9086-a0510b46b473/occlusion_a6b491c8-1bcf-11ee-9086-a0510b46b473/scan_b8637b02-1bd0-11ee-9086-a0510b46b473/1da727b9-1bd1-11ee-9086-a0510b46b473.zip','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_a6b1a4bd-1bcf-11ee-9086-a0510b46b473_SESS_a6b491c8-1bcf-11ee-9086-a0510b46b473_TOSC_b8637b02-1bd0-11ee-9086-a0510b46b473_MODEL','1da727b9-1bd1-11ee-9086-a0510b46b473.zip','1da727b9-1bd1-11ee-9086-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.3.1.4\",\"modelMatrix\":\"0.467495,0.864366,-0.185255,0,-0.883995,0.457114,-0.097971,0,8.87154e-09,0.209566,0.977794,0,-28.0587,-5.51142,-10.3182,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 09:45:45.467','2023-07-06 07:45:46.461',NULL),('1da86a9a-1bd1-11ee-9086-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_a6b1a4bd-1bcf-11ee-9086-a0510b46b473/occlusion_a6b491c8-1bcf-11ee-9086-a0510b46b473/scan_b8637b02-1bd0-11ee-9086-a0510b46b473/1da86a9a-1bd1-11ee-9086-a0510b46b473.png','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_a6b1a4bd-1bcf-11ee-9086-a0510b46b473_SESS_a6b491c8-1bcf-11ee-9086-a0510b46b473_TOSC_b8637b02-1bd0-11ee-9086-a0510b46b473_SNAPS','1da86a9a-1bd1-11ee-9086-a0510b46b473.png','1da86a9a-1bd1-11ee-9086-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.3.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 09:45:45.475','2023-07-06 07:45:46.462',NULL),('1e18631c-15b9-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/142e7037-15b6-11ee-b3b1-00d86184ce3d/session_1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d/occlusion_1ed7780a-15b6-11ee-b3b1-00d86184ce3d/scan_c5c64fa4-15b8-11ee-b3b1-00d86184ce3d/1e18631c-15b9-11ee-b3b1-00d86184ce3d.zip','PATIENT_142e7037-15b6-11ee-b3b1-00d86184ce3d_ACT_1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d_SESS_1ed7780a-15b6-11ee-b3b1-00d86184ce3d_TOSC_c5c64fa4-15b8-11ee-b3b1-00d86184ce3d_MODEL','1e18631c-15b9-11ee-b3b1-00d86184ce3d.zip','1e18631c-15b9-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.25.1.1.8\",\"modelMatrix\":\"-0.501432,0.850223,-0.160268,0,-0.865197,-0.492754,0.0928848,0,3.98268e-09,0.185239,0.982693,0,-8.32149,-28.7917,-8.88839,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-28 15:38:51.311','2023-06-28 13:38:52.116',NULL),('1e187a87-15b9-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/142e7037-15b6-11ee-b3b1-00d86184ce3d/session_1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d/occlusion_1ed7780a-15b6-11ee-b3b1-00d86184ce3d/scan_c5c64fa4-15b8-11ee-b3b1-00d86184ce3d/1e187a87-15b9-11ee-b3b1-00d86184ce3d.png','PATIENT_142e7037-15b6-11ee-b3b1-00d86184ce3d_ACT_1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d_SESS_1ed7780a-15b6-11ee-b3b1-00d86184ce3d_TOSC_c5c64fa4-15b8-11ee-b3b1-00d86184ce3d_SNAPS','1e187a87-15b9-11ee-b3b1-00d86184ce3d.png','1e187a87-15b9-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.25.1.1.8 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-28 15:38:51.311','2023-06-28 13:38:52.117',NULL),('1ea3f2ad-e342-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_853ebc79-e33f-11ed-8c5e-00d86184ce3d/occlusion_8541c500-e33f-11ed-8c5e-00d86184ce3d/scan_52d8ee2b-e341-11ed-8c5e-00d86184ce3d/1ea3f2ad-e342-11ed-8c5e-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_853ebc79-e33f-11ed-8c5e-00d86184ce3d_SESS_8541c500-e33f-11ed-8c5e-00d86184ce3d_TOSC_52d8ee2b-e341-11ed-8c5e-00d86184ce3d_MODEL','1ea3f2ad-e342-11ed-8c5e-00d86184ce3d.zip','1ea3f2ad-e342-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.6.1.3\",\"modelMatrix\":\"0.688192,0.678593,-0.256717,0,-0.725529,0.643671,-0.243506,0,-6.4577e-10,0.353835,0.935308,0,-19.6438,-5.51625,-11.6036,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-25 10:21:03.976','2023-04-25 08:21:04.719',NULL),('1ea53dcc-e342-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_853ebc79-e33f-11ed-8c5e-00d86184ce3d/occlusion_8541c500-e33f-11ed-8c5e-00d86184ce3d/scan_52d8ee2b-e341-11ed-8c5e-00d86184ce3d/1ea53dcc-e342-11ed-8c5e-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_853ebc79-e33f-11ed-8c5e-00d86184ce3d_SESS_8541c500-e33f-11ed-8c5e-00d86184ce3d_TOSC_52d8ee2b-e341-11ed-8c5e-00d86184ce3d_SNAPS','1ea53dcc-e342-11ed-8c5e-00d86184ce3d.png','1ea53dcc-e342-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.6.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-25 10:21:03.984','2023-04-25 08:21:04.719',NULL),('1ef609ba-e01e-11ed-a285-00d86184ce3d',11,'/home/scan/.data//2023/11/5f27680c-e01a-11ed-b6c2-00d86184ce3d/session_65b85f32-e01a-11ed-b6c2-00d86184ce3d/occlusion_65ba9a94-e01a-11ed-b6c2-00d86184ce3d/scan_d8aaf2a8-e01d-11ed-a285-00d86184ce3d/1ef609ba-e01e-11ed-a285-00d86184ce3d.zip','PATIENT_5f27680c-e01a-11ed-b6c2-00d86184ce3d_ACT_65b85f32-e01a-11ed-b6c2-00d86184ce3d_SESS_65ba9a94-e01a-11ed-b6c2-00d86184ce3d_TOSC_d8aaf2a8-e01d-11ed-a285-00d86184ce3d_MODEL','1ef609ba-e01e-11ed-a285-00d86184ce3d.zip','1ef609ba-e01e-11ed-a285-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.10.1.1.4\",\"modelMatrix\":\"0.303209,0.902862,-0.304802,0,-0.952924,0.28728,-0.0969844,0,2.0238e-09,0.31986,0.947465,0,-27.3641,-10.5118,-6.81431,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 10:25:49.143','2023-04-21 08:25:50.062',NULL),('1ef75162-e01e-11ed-a285-00d86184ce3d',11,'/home/scan/.data//2023/11/5f27680c-e01a-11ed-b6c2-00d86184ce3d/session_65b85f32-e01a-11ed-b6c2-00d86184ce3d/occlusion_65ba9a94-e01a-11ed-b6c2-00d86184ce3d/scan_d8aaf2a8-e01d-11ed-a285-00d86184ce3d/1ef75162-e01e-11ed-a285-00d86184ce3d.png','PATIENT_5f27680c-e01a-11ed-b6c2-00d86184ce3d_ACT_65b85f32-e01a-11ed-b6c2-00d86184ce3d_SESS_65ba9a94-e01a-11ed-b6c2-00d86184ce3d_TOSC_d8aaf2a8-e01d-11ed-a285-00d86184ce3d_SNAPS','1ef75162-e01e-11ed-a285-00d86184ce3d.png','1ef75162-e01e-11ed-a285-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.10.1.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 10:25:49.151','2023-04-21 08:25:50.063',NULL),('1f8d6f48-e036-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_63b81b7e-e035-11ed-bb13-00d86184ce3d/occlusion_63bb1989-e035-11ed-bb13-00d86184ce3d/scan_fac817a6-e035-11ed-bb13-00d86184ce3d/1f8d6f48-e036-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_63b81b7e-e035-11ed-bb13-00d86184ce3d_SESS_63bb1989-e035-11ed-bb13-00d86184ce3d_TOSC_fac817a6-e035-11ed-bb13-00d86184ce3d_MODEL','1f8d6f48-e036-11ed-bb13-00d86184ce3d.zip','1f8d6f48-e036-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.2.1.1\",\"modelMatrix\":\"0.871045,0.414159,-0.26411,0,-0.491204,0.734421,-0.468342,0,1.34593e-08,0.537678,0.84315,0,-11.8725,-8.77468,-5.5463,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 13:17:38.057','2023-04-21 11:17:38.402',NULL),('1f8d8888-e036-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_63b81b7e-e035-11ed-bb13-00d86184ce3d/occlusion_63bb1989-e035-11ed-bb13-00d86184ce3d/scan_fac817a6-e035-11ed-bb13-00d86184ce3d/1f8d8888-e036-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_63b81b7e-e035-11ed-bb13-00d86184ce3d_SESS_63bb1989-e035-11ed-bb13-00d86184ce3d_TOSC_fac817a6-e035-11ed-bb13-00d86184ce3d_SNAPS','1f8d8888-e036-11ed-bb13-00d86184ce3d.png','1f8d8888-e036-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.2.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 13:17:38.057','2023-04-21 11:17:38.402',NULL),('20246d3c-dd01-11ed-8097-00d86184ce3d',11,'/home/scan/.data//2023/11/59af3050-dcfe-11ed-8097-00d86184ce3d/session_61025fcf-dcfe-11ed-8097-00d86184ce3d/occlusion_610548c3-dcfe-11ed-8097-00d86184ce3d/scan_bf820900-dd00-11ed-8097-00d86184ce3d/20246d3c-dd01-11ed-8097-00d86184ce3d.zip','PATIENT_59af3050-dcfe-11ed-8097-00d86184ce3d_ACT_61025fcf-dcfe-11ed-8097-00d86184ce3d_SESS_610548c3-dcfe-11ed-8097-00d86184ce3d_TOSC_bf820900-dd00-11ed-8097-00d86184ce3d_MODEL','20246d3c-dd01-11ed-8097-00d86184ce3d.zip','20246d3c-dd01-11ed-8097-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.1.1.1.5\",\"modelMatrix\":\"0.508377,0.852361,-0.122611,0,-0.861135,0.503197,-0.0723845,0,2.53053e-09,0.142383,0.989812,0,-32.3213,-6.44649,-10.3302,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-04-17 11:20:42.231','2023-04-17 09:20:43.418','2023-04-17 11:20:43.894'),('2024e0c9-dd01-11ed-8097-00d86184ce3d',11,'/home/scan/.data//2023/11/59af3050-dcfe-11ed-8097-00d86184ce3d/session_61025fcf-dcfe-11ed-8097-00d86184ce3d/occlusion_610548c3-dcfe-11ed-8097-00d86184ce3d/scan_bf820900-dd00-11ed-8097-00d86184ce3d/2024e0c9-dd01-11ed-8097-00d86184ce3d.png','PATIENT_59af3050-dcfe-11ed-8097-00d86184ce3d_ACT_61025fcf-dcfe-11ed-8097-00d86184ce3d_SESS_610548c3-dcfe-11ed-8097-00d86184ce3d_TOSC_bf820900-dd00-11ed-8097-00d86184ce3d_SNAPS','2024e0c9-dd01-11ed-8097-00d86184ce3d.png','2024e0c9-dd01-11ed-8097-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.1.1.1.5 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-04-17 11:20:42.234','2023-04-17 09:20:43.419','2023-04-17 11:20:44.035'),('2080679a-e01c-11ed-b6c2-00d86184ce3d',11,'/home/scan/.data//2023/11/5f27680c-e01a-11ed-b6c2-00d86184ce3d/session_65b85f32-e01a-11ed-b6c2-00d86184ce3d/occlusion_65ba9a94-e01a-11ed-b6c2-00d86184ce3d/scan_d64e3c45-e01b-11ed-b6c2-00d86184ce3d/2080679a-e01c-11ed-b6c2-00d86184ce3d.zip','PATIENT_5f27680c-e01a-11ed-b6c2-00d86184ce3d_ACT_65b85f32-e01a-11ed-b6c2-00d86184ce3d_SESS_65ba9a94-e01a-11ed-b6c2-00d86184ce3d_TOSC_d64e3c45-e01b-11ed-b6c2-00d86184ce3d_MODEL','2080679a-e01c-11ed-b6c2-00d86184ce3d.zip','2080679a-e01c-11ed-b6c2-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.10.1.1.1\",\"modelMatrix\":\"0.873622,0.467783,-0.134032,0,-0.486606,0.839828,-0.240632,0,3.16535e-09,0.275442,0.961318,0,-28.6157,0.318264,-10.9155,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 10:11:32.734','2023-04-21 08:11:33.575',NULL),('20807eb4-e01c-11ed-b6c2-00d86184ce3d',11,'/home/scan/.data//2023/11/5f27680c-e01a-11ed-b6c2-00d86184ce3d/session_65b85f32-e01a-11ed-b6c2-00d86184ce3d/occlusion_65ba9a94-e01a-11ed-b6c2-00d86184ce3d/scan_d64e3c45-e01b-11ed-b6c2-00d86184ce3d/20807eb4-e01c-11ed-b6c2-00d86184ce3d.png','PATIENT_5f27680c-e01a-11ed-b6c2-00d86184ce3d_ACT_65b85f32-e01a-11ed-b6c2-00d86184ce3d_SESS_65ba9a94-e01a-11ed-b6c2-00d86184ce3d_TOSC_d64e3c45-e01b-11ed-b6c2-00d86184ce3d_SNAPS','20807eb4-e01c-11ed-b6c2-00d86184ce3d.png','20807eb4-e01c-11ed-b6c2-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.10.1.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 10:11:32.735','2023-04-21 08:11:33.576',NULL),('211f0b79-debb-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/cf3f0588-deb2-11ed-9cc3-00d86184ce3d/session_c2f3ac91-deba-11ed-9cc3-00d86184ce3d/occlusion_c2f6aec6-deba-11ed-9cc3-00d86184ce3d/scan_c55a3ee6-deba-11ed-9cc3-00d86184ce3d/211f0b79-debb-11ed-9cc3-00d86184ce3d.zip','PATIENT_cf3f0588-deb2-11ed-9cc3-00d86184ce3d_ACT_c2f3ac91-deba-11ed-9cc3-00d86184ce3d_SESS_c2f6aec6-deba-11ed-9cc3-00d86184ce3d_TOSC_c55a3ee6-deba-11ed-9cc3-00d86184ce3d_MODEL','211f0b79-debb-11ed-9cc3-00d86184ce3d.zip','211f0b79-debb-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.6.2.1.1\",\"modelMatrix\":\"0.838251,0.492834,-0.233345,0,-0.545284,0.757621,-0.358715,0,1.11943e-08,0.427932,0.903811,0,-25.4165,-1.52382,-8.33442,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-19 16:04:41.428','2023-04-19 14:04:42.390',NULL),('211f1ff7-debb-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/cf3f0588-deb2-11ed-9cc3-00d86184ce3d/session_c2f3ac91-deba-11ed-9cc3-00d86184ce3d/occlusion_c2f6aec6-deba-11ed-9cc3-00d86184ce3d/scan_c55a3ee6-deba-11ed-9cc3-00d86184ce3d/211f1ff7-debb-11ed-9cc3-00d86184ce3d.png','PATIENT_cf3f0588-deb2-11ed-9cc3-00d86184ce3d_ACT_c2f3ac91-deba-11ed-9cc3-00d86184ce3d_SESS_c2f6aec6-deba-11ed-9cc3-00d86184ce3d_TOSC_c55a3ee6-deba-11ed-9cc3-00d86184ce3d_SNAPS','211f1ff7-debb-11ed-9cc3-00d86184ce3d.png','211f1ff7-debb-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.6.2.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-19 16:04:41.429','2023-04-19 14:04:42.399',NULL),('212653ed-10e5-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/2ff330cd-10e1-11ee-b636-a0510b46b473/session_68b68f8e-10e4-11ee-b636-a0510b46b473/occlusion_68b97a59-10e4-11ee-b636-a0510b46b473/scan_e96ca140-10e4-11ee-b636-a0510b46b473/212653ed-10e5-11ee-b636-a0510b46b473.zip','PATIENT_2ff330cd-10e1-11ee-b636-a0510b46b473_ACT_68b68f8e-10e4-11ee-b636-a0510b46b473_SESS_68b97a59-10e4-11ee-b636-a0510b46b473_TOSC_e96ca140-10e4-11ee-b636-a0510b46b473_MODEL','212653ed-10e5-11ee-b636-a0510b46b473.zip','212653ed-10e5-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.18.2.1.3\",\"modelMatrix\":\"0.602867,0.669365,-0.434168,0,-0.797841,0.505788,-0.328067,0,1.06774e-08,0.544178,0.83897,0,-30.5897,-2.1977,-6.41055,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 12:11:18.478','2023-06-22 10:11:18.985',NULL),('212667e8-10e5-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/2ff330cd-10e1-11ee-b636-a0510b46b473/session_68b68f8e-10e4-11ee-b636-a0510b46b473/occlusion_68b97a59-10e4-11ee-b636-a0510b46b473/scan_e96ca140-10e4-11ee-b636-a0510b46b473/212667e8-10e5-11ee-b636-a0510b46b473.png','PATIENT_2ff330cd-10e1-11ee-b636-a0510b46b473_ACT_68b68f8e-10e4-11ee-b636-a0510b46b473_SESS_68b97a59-10e4-11ee-b636-a0510b46b473_TOSC_e96ca140-10e4-11ee-b636-a0510b46b473_SNAPS','212667e8-10e5-11ee-b636-a0510b46b473.png','212667e8-10e5-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.18.2.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 12:11:18.478','2023-06-22 10:11:18.985',NULL),('21c47187-262b-11ee-8042-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_62519c59-261f-11ee-8042-a0510b46b473/occlusion_6253caa6-261f-11ee-8042-a0510b46b473/scan_8a251426-262a-11ee-8042-a0510b46b473/21c47187-262b-11ee-8042-a0510b46b473.png','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_62519c59-261f-11ee-8042-a0510b46b473_SESS_6253caa6-261f-11ee-8042-a0510b46b473_TOSC_8a251426-262a-11ee-8042-a0510b46b473_SCREENS','21c47187-262b-11ee-8042-a0510b46b473.png','21c47187-262b-11ee-8042-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.1.1.6 Capture d\'écran 1\",\"title\":\"1\"}','PNG',0,'CREATED',0,NULL,'2023-07-19 13:55:18.703','2023-07-19 11:55:18.854',NULL),('2232c752-dcff-11ed-8097-00d86184ce3d',11,'/home/scan/.data//2023/11/59af3050-dcfe-11ed-8097-00d86184ce3d/session_61025fcf-dcfe-11ed-8097-00d86184ce3d/occlusion_610548c3-dcfe-11ed-8097-00d86184ce3d/scan_c649f563-dcfe-11ed-8097-00d86184ce3d/2232c752-dcff-11ed-8097-00d86184ce3d.zip','PATIENT_59af3050-dcfe-11ed-8097-00d86184ce3d_ACT_61025fcf-dcfe-11ed-8097-00d86184ce3d_SESS_610548c3-dcfe-11ed-8097-00d86184ce3d_TOSC_c649f563-dcfe-11ed-8097-00d86184ce3d_MODEL','2232c752-dcff-11ed-8097-00d86184ce3d.zip','2232c752-dcff-11ed-8097-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.1.1.1.2\",\"modelMatrix\":\"-0.414676,0.825666,-0.382519,0,-0.909969,-0.376258,0.174315,0,-5.84549e-09,0.420364,0.907355,0,-13.6354,-31.3919,-3.69866,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-04-17 11:06:26.687','2023-04-17 09:06:27.787','2023-04-17 11:06:28.204'),('2232e4bb-dcff-11ed-8097-00d86184ce3d',11,'/home/scan/.data//2023/11/59af3050-dcfe-11ed-8097-00d86184ce3d/session_61025fcf-dcfe-11ed-8097-00d86184ce3d/occlusion_610548c3-dcfe-11ed-8097-00d86184ce3d/scan_c649f563-dcfe-11ed-8097-00d86184ce3d/2232e4bb-dcff-11ed-8097-00d86184ce3d.png','PATIENT_59af3050-dcfe-11ed-8097-00d86184ce3d_ACT_61025fcf-dcfe-11ed-8097-00d86184ce3d_SESS_610548c3-dcfe-11ed-8097-00d86184ce3d_TOSC_c649f563-dcfe-11ed-8097-00d86184ce3d_SNAPS','2232e4bb-dcff-11ed-8097-00d86184ce3d.png','2232e4bb-dcff-11ed-8097-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.1.1.1.2 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-04-17 11:06:26.688','2023-04-17 09:06:27.788','2023-04-17 11:06:28.355'),('224c3d52-2ac4-11ee-80c8-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_3a881645-2abf-11ee-80c8-a0510b46b473/occlusion_3a8b3537-2abf-11ee-80c8-a0510b46b473/scan_fc5962b1-2ac3-11ee-80c8-a0510b46b473/224c3d52-2ac4-11ee-80c8-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_3a881645-2abf-11ee-80c8-a0510b46b473_SESS_3a8b3537-2abf-11ee-80c8-a0510b46b473_TOSC_fc5962b1-2ac3-11ee-80c8-a0510b46b473_MODEL','224c3d52-2ac4-11ee-80c8-a0510b46b473.zip','224c3d52-2ac4-11ee-80c8-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.7.1.10\",\"modelMatrix\":\"0.778227,0.598937,-0.188776,0,-0.627983,0.742233,-0.233941,0,-1.12208e-09,0.300608,0.953748,0,-22.0866,-6.22555,-13.7429,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-25 10:20:37.244','2023-07-25 08:20:37.689',NULL),('224c543f-2ac4-11ee-80c8-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_3a881645-2abf-11ee-80c8-a0510b46b473/occlusion_3a8b3537-2abf-11ee-80c8-a0510b46b473/scan_fc5962b1-2ac3-11ee-80c8-a0510b46b473/224c543f-2ac4-11ee-80c8-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_3a881645-2abf-11ee-80c8-a0510b46b473_SESS_3a8b3537-2abf-11ee-80c8-a0510b46b473_TOSC_fc5962b1-2ac3-11ee-80c8-a0510b46b473_SNAPS','224c543f-2ac4-11ee-80c8-a0510b46b473.png','224c543f-2ac4-11ee-80c8-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.7.1.10 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-25 10:20:37.244','2023-07-25 08:20:37.690',NULL),('22effba0-1a77-11ee-8124-a0510b46b473',11,'/home/scan/.data//2023/11/61e16a70-1a76-11ee-8124-a0510b46b473/session_76f916fd-1a76-11ee-8124-a0510b46b473/occlusion_76fc311b-1a76-11ee-8124-a0510b46b473/scan_d7da64d1-1a76-11ee-8124-a0510b46b473/22effba0-1a77-11ee-8124-a0510b46b473.zip','PATIENT_61e16a70-1a76-11ee-8124-a0510b46b473_ACT_76f916fd-1a76-11ee-8124-a0510b46b473_SESS_76fc311b-1a76-11ee-8124-a0510b46b473_TOSC_d7da64d1-1a76-11ee-8124-a0510b46b473_MODEL','22effba0-1a77-11ee-8124-a0510b46b473.zip','22effba0-1a77-11ee-8124-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.27.1.1.2\",\"modelMatrix\":\"-0.567962,0.79949,-0.195536,0,-0.823055,-0.551701,0.134933,0,1.46902e-08,0.237573,0.97137,0,9.74026,-44.8246,-7.62697,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-04 16:29:08.464','2023-07-04 14:29:09.025',NULL),('22f13550-1a77-11ee-8124-a0510b46b473',11,'/home/scan/.data//2023/11/61e16a70-1a76-11ee-8124-a0510b46b473/session_76f916fd-1a76-11ee-8124-a0510b46b473/occlusion_76fc311b-1a76-11ee-8124-a0510b46b473/scan_d7da64d1-1a76-11ee-8124-a0510b46b473/22f13550-1a77-11ee-8124-a0510b46b473.png','PATIENT_61e16a70-1a76-11ee-8124-a0510b46b473_ACT_76f916fd-1a76-11ee-8124-a0510b46b473_SESS_76fc311b-1a76-11ee-8124-a0510b46b473_TOSC_d7da64d1-1a76-11ee-8124-a0510b46b473_SNAPS','22f13550-1a77-11ee-8124-a0510b46b473.png','22f13550-1a77-11ee-8124-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.27.1.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-04 16:29:08.472','2023-07-04 14:29:09.027',NULL),('23377638-26e4-11ee-a836-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_d5ef2d6b-26e3-11ee-a836-a0510b46b473/occlusion_d5f241c9-26e3-11ee-a836-a0510b46b473/scan_dfe543b7-26e3-11ee-a836-a0510b46b473/23377638-26e4-11ee-a836-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_d5ef2d6b-26e3-11ee-a836-a0510b46b473_SESS_d5f241c9-26e3-11ee-a836-a0510b46b473_TOSC_dfe543b7-26e3-11ee-a836-a0510b46b473_MODEL','23377638-26e4-11ee-a836-a0510b46b473.zip','23377638-26e4-11ee-a836-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.5.1.1\",\"modelMatrix\":\"0.434575,0.834386,-0.339034,0,-0.900636,0.402609,-0.163591,0,2.86218e-09,0.376439,0.926441,0,-29.4902,-10.9235,-8.29289,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-20 11:59:38.030','2023-07-20 09:59:38.720',NULL),('233794e7-26e4-11ee-a836-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_d5ef2d6b-26e3-11ee-a836-a0510b46b473/occlusion_d5f241c9-26e3-11ee-a836-a0510b46b473/scan_dfe543b7-26e3-11ee-a836-a0510b46b473/233794e7-26e4-11ee-a836-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_d5ef2d6b-26e3-11ee-a836-a0510b46b473_SESS_d5f241c9-26e3-11ee-a836-a0510b46b473_TOSC_dfe543b7-26e3-11ee-a836-a0510b46b473_SNAPS','233794e7-26e4-11ee-a836-a0510b46b473.png','233794e7-26e4-11ee-a836-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.5.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-20 11:59:38.030','2023-07-20 09:59:38.721',NULL),('234d1508-1105-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_0628a8e9-1104-11ee-b636-a0510b46b473/occlusion_062b833f-1104-11ee-b636-a0510b46b473/scan_ce700eea-1104-11ee-b636-a0510b46b473/234d1508-1105-11ee-b636-a0510b46b473.zip','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_0628a8e9-1104-11ee-b636-a0510b46b473_SESS_062b833f-1104-11ee-b636-a0510b46b473_TOSC_ce700eea-1104-11ee-b636-a0510b46b473_MODEL','234d1508-1105-11ee-b636-a0510b46b473.zip','234d1508-1105-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.20.1.1.2\",\"modelMatrix\":\"0.656206,0.724568,-0.210701,0,-0.754582,0.630105,-0.183232,0,1.61218e-08,0.279229,0.960225,0,-31.0625,-8.56998,-8.65644,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 16:00:25.982','2023-06-22 14:00:26.707',NULL),('234d2b98-1105-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_0628a8e9-1104-11ee-b636-a0510b46b473/occlusion_062b833f-1104-11ee-b636-a0510b46b473/scan_ce700eea-1104-11ee-b636-a0510b46b473/234d2b98-1105-11ee-b636-a0510b46b473.png','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_0628a8e9-1104-11ee-b636-a0510b46b473_SESS_062b833f-1104-11ee-b636-a0510b46b473_TOSC_ce700eea-1104-11ee-b636-a0510b46b473_SNAPS','234d2b98-1105-11ee-b636-a0510b46b473.png','234d2b98-1105-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.20.1.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 16:00:25.983','2023-06-22 14:00:26.708',NULL),('23945ab5-262f-11ee-81dd-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_ab852a49-262e-11ee-81dd-a0510b46b473/occlusion_ab88338c-262e-11ee-81dd-a0510b46b473/scan_ed0b9df3-262e-11ee-81dd-a0510b46b473/23945ab5-262f-11ee-81dd-a0510b46b473.zip','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_ab852a49-262e-11ee-81dd-a0510b46b473_SESS_ab88338c-262e-11ee-81dd-a0510b46b473_TOSC_ed0b9df3-262e-11ee-81dd-a0510b46b473_MODEL','23945ab5-262f-11ee-81dd-a0510b46b473.zip','23945ab5-262f-11ee-81dd-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.2.1.2\",\"modelMatrix\":\"0.555678,0.82321,-0.116395,0,-0.831398,0.550206,-0.0777946,0,-3.83233e-10,0.139999,0.990152,0,-30.132,-12.7025,-11.796,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-19 14:23:59.730','2023-07-19 12:24:00.190',NULL),('23946f33-262f-11ee-81dd-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_ab852a49-262e-11ee-81dd-a0510b46b473/occlusion_ab88338c-262e-11ee-81dd-a0510b46b473/scan_ed0b9df3-262e-11ee-81dd-a0510b46b473/23946f33-262f-11ee-81dd-a0510b46b473.png','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_ab852a49-262e-11ee-81dd-a0510b46b473_SESS_ab88338c-262e-11ee-81dd-a0510b46b473_TOSC_ed0b9df3-262e-11ee-81dd-a0510b46b473_SNAPS','23946f33-262f-11ee-81dd-a0510b46b473.png','23946f33-262f-11ee-81dd-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.2.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-19 14:23:59.731','2023-07-19 12:24:00.190',NULL),('23ed40d2-e040-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_261265bf-e03f-11ed-bb13-00d86184ce3d/occlusion_2615e3c8-e03f-11ed-bb13-00d86184ce3d/scan_edf2b70f-e03f-11ed-bb13-00d86184ce3d/23ed40d2-e040-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_261265bf-e03f-11ed-bb13-00d86184ce3d_SESS_2615e3c8-e03f-11ed-bb13-00d86184ce3d_TOSC_edf2b70f-e03f-11ed-bb13-00d86184ce3d_MODEL','23ed40d2-e040-11ed-bb13-00d86184ce3d.zip','23ed40d2-e040-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.4.1.3\",\"modelMatrix\":\"0.865911,0.356898,-0.35046,0,-0.500198,0.617839,-0.606693,0,-4.25693e-09,0.700641,0.713514,0,-16.5719,1.36166,-15.1596,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 14:29:20.363','2023-04-21 12:29:20.866',NULL),('23ed5827-e040-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_261265bf-e03f-11ed-bb13-00d86184ce3d/occlusion_2615e3c8-e03f-11ed-bb13-00d86184ce3d/scan_edf2b70f-e03f-11ed-bb13-00d86184ce3d/23ed5827-e040-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_261265bf-e03f-11ed-bb13-00d86184ce3d_SESS_2615e3c8-e03f-11ed-bb13-00d86184ce3d_TOSC_edf2b70f-e03f-11ed-bb13-00d86184ce3d_SNAPS','23ed5827-e040-11ed-bb13-00d86184ce3d.png','23ed5827-e040-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.4.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 14:29:20.363','2023-04-21 12:29:20.867',NULL),('23ed6aba-1a62-11ee-9a4f-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_56e1eee3-1a49-11ee-9a4f-a0510b46b473/occlusion_56e449e9-1a49-11ee-9a4f-a0510b46b473/scan_b6caf1b8-1a61-11ee-9a4f-a0510b46b473/23ed6aba-1a62-11ee-9a4f-a0510b46b473.zip','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_56e1eee3-1a49-11ee-9a4f-a0510b46b473_SESS_56e449e9-1a49-11ee-9a4f-a0510b46b473_TOSC_b6caf1b8-1a61-11ee-9a4f-a0510b46b473_MODEL','23ed6aba-1a62-11ee-9a4f-a0510b46b473.zip','23ed6aba-1a62-11ee-9a4f-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.1.1.6\",\"modelMatrix\":\"-0.21863,0.962633,-0.159811,0,-0.975808,-0.215678,0.0358056,0,4.65104e-09,0.163773,0.986498,0,-17.0148,-26.3161,-10.2024,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-04 13:58:50.694','2023-07-04 11:58:51.529',NULL),('23ed8130-1a62-11ee-9a4f-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_56e1eee3-1a49-11ee-9a4f-a0510b46b473/occlusion_56e449e9-1a49-11ee-9a4f-a0510b46b473/scan_b6caf1b8-1a61-11ee-9a4f-a0510b46b473/23ed8130-1a62-11ee-9a4f-a0510b46b473.png','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_56e1eee3-1a49-11ee-9a4f-a0510b46b473_SESS_56e449e9-1a49-11ee-9a4f-a0510b46b473_TOSC_b6caf1b8-1a61-11ee-9a4f-a0510b46b473_SNAPS','23ed8130-1a62-11ee-9a4f-a0510b46b473.png','23ed8130-1a62-11ee-9a4f-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.1.1.6 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-04 13:58:50.694','2023-07-04 11:58:51.532',NULL),('247593da-e03a-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_63b81b7e-e035-11ed-bb13-00d86184ce3d/occlusion_63bb1989-e035-11ed-bb13-00d86184ce3d/scan_0ad8ca97-e03a-11ed-bb13-00d86184ce3d/247593da-e03a-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_63b81b7e-e035-11ed-bb13-00d86184ce3d_SESS_63bb1989-e035-11ed-bb13-00d86184ce3d_TOSC_0ad8ca97-e03a-11ed-bb13-00d86184ce3d_MODEL','247593da-e03a-11ed-bb13-00d86184ce3d.zip','247593da-e03a-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.2.1.8\",\"modelMatrix\":\"0.531425,0.788979,-0.308383,0,-0.847106,0.494959,-0.193462,0,-1.02016e-08,0.364044,0.931382,0,-11.9636,-7.8522,-8.55957,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 13:46:24.276','2023-04-21 11:46:24.481',NULL),('2475a287-e03a-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_63b81b7e-e035-11ed-bb13-00d86184ce3d/occlusion_63bb1989-e035-11ed-bb13-00d86184ce3d/scan_0ad8ca97-e03a-11ed-bb13-00d86184ce3d/2475a287-e03a-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_63b81b7e-e035-11ed-bb13-00d86184ce3d_SESS_63bb1989-e035-11ed-bb13-00d86184ce3d_TOSC_0ad8ca97-e03a-11ed-bb13-00d86184ce3d_SNAPS','2475a287-e03a-11ed-bb13-00d86184ce3d.png','2475a287-e03a-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.2.1.8 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 13:46:24.276','2023-04-21 11:46:24.491',NULL),('24b53628-de88-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/f29210da-de80-11ed-9cc3-00d86184ce3d/session_ffdb9942-de80-11ed-9cc3-00d86184ce3d/occlusion_ffdebb3e-de80-11ed-9cc3-00d86184ce3d/scan_ac1c48eb-de87-11ed-9cc3-00d86184ce3d/24b53628-de88-11ed-9cc3-00d86184ce3d.zip','PATIENT_f29210da-de80-11ed-9cc3-00d86184ce3d_ACT_ffdb9942-de80-11ed-9cc3-00d86184ce3d_SESS_ffdebb3e-de80-11ed-9cc3-00d86184ce3d_TOSC_ac1c48eb-de87-11ed-9cc3-00d86184ce3d_MODEL','24b53628-de88-11ed-9cc3-00d86184ce3d.zip','24b53628-de88-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.3.1.1.6\",\"modelMatrix\":\"0.646635,0.74873,-0.145833,0,-0.7628,0.634708,-0.123624,0,-2.25378e-09,0.191181,0.981555,0,-28.418,-8.0226,-11.0447,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-04-19 09:59:43.112','2023-04-19 07:59:44.168','2023-04-19 09:59:45.794'),('24b54c76-de88-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/f29210da-de80-11ed-9cc3-00d86184ce3d/session_ffdb9942-de80-11ed-9cc3-00d86184ce3d/occlusion_ffdebb3e-de80-11ed-9cc3-00d86184ce3d/scan_ac1c48eb-de87-11ed-9cc3-00d86184ce3d/24b54c76-de88-11ed-9cc3-00d86184ce3d.png','PATIENT_f29210da-de80-11ed-9cc3-00d86184ce3d_ACT_ffdb9942-de80-11ed-9cc3-00d86184ce3d_SESS_ffdebb3e-de80-11ed-9cc3-00d86184ce3d_TOSC_ac1c48eb-de87-11ed-9cc3-00d86184ce3d_SNAPS','24b54c76-de88-11ed-9cc3-00d86184ce3d.png','24b54c76-de88-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.3.1.1.6 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-04-19 09:59:43.113','2023-04-19 07:59:44.169','2023-04-19 09:59:45.953'),('25018ff1-1c0a-11ee-a865-a0510b46b473',11,'/home/scan/.data//2023/11/ae8bd11e-1c05-11ee-9323-a0510b46b473/session_bab223ae-1c09-11ee-a865-a0510b46b473/occlusion_bab539ff-1c09-11ee-a865-a0510b46b473/scan_ed81d973-1c09-11ee-a865-a0510b46b473/25018ff1-1c0a-11ee-a865-a0510b46b473.zip','PATIENT_ae8bd11e-1c05-11ee-9323-a0510b46b473_ACT_bab223ae-1c09-11ee-a865-a0510b46b473_SESS_bab539ff-1c09-11ee-a865-a0510b46b473_TOSC_ed81d973-1c09-11ee-a865-a0510b46b473_MODEL','25018ff1-1c0a-11ee-a865-a0510b46b473.zip','25018ff1-1c0a-11ee-a865-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.29.2.1.2\",\"modelMatrix\":\"0.847722,0.44864,-0.283003,0,-0.530442,0.716991,-0.452279,0,6.24555e-09,0.533523,0.845785,0,-32.5418,5.12892,-5.71808,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 16:33:59.117','2023-07-06 14:33:59.622',NULL),('25019f95-e353-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/6175c1d5-e350-11ed-8c5e-00d86184ce3d/session_ea1c884f-e352-11ed-8c5e-00d86184ce3d/occlusion_ea1f514a-e352-11ed-8c5e-00d86184ce3d/scan_eb2d6131-e352-11ed-8c5e-00d86184ce3d/25019f95-e353-11ed-8c5e-00d86184ce3d.zip','PATIENT_6175c1d5-e350-11ed-8c5e-00d86184ce3d_ACT_ea1c884f-e352-11ed-8c5e-00d86184ce3d_SESS_ea1f514a-e352-11ed-8c5e-00d86184ce3d_TOSC_eb2d6131-e352-11ed-8c5e-00d86184ce3d_MODEL','25019f95-e353-11ed-8c5e-00d86184ce3d.zip','25019f95-e353-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.13.2.1.1\",\"modelMatrix\":\"0.572142,0.714204,-0.403194,0,-0.820154,0.498231,-0.28127,0,2.84443e-09,0.491608,0.870817,0,-29.7,-3.55887,-7.30862,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-25 12:22:56.100','2023-04-25 10:22:56.788',NULL),('2501a6f6-1c0a-11ee-a865-a0510b46b473',11,'/home/scan/.data//2023/11/ae8bd11e-1c05-11ee-9323-a0510b46b473/session_bab223ae-1c09-11ee-a865-a0510b46b473/occlusion_bab539ff-1c09-11ee-a865-a0510b46b473/scan_ed81d973-1c09-11ee-a865-a0510b46b473/2501a6f6-1c0a-11ee-a865-a0510b46b473.png','PATIENT_ae8bd11e-1c05-11ee-9323-a0510b46b473_ACT_bab223ae-1c09-11ee-a865-a0510b46b473_SESS_bab539ff-1c09-11ee-a865-a0510b46b473_TOSC_ed81d973-1c09-11ee-a865-a0510b46b473_SNAPS','2501a6f6-1c0a-11ee-a865-a0510b46b473.png','2501a6f6-1c0a-11ee-a865-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.29.2.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 16:33:59.118','2023-07-06 14:33:59.625',NULL),('2501b92a-e353-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/6175c1d5-e350-11ed-8c5e-00d86184ce3d/session_ea1c884f-e352-11ed-8c5e-00d86184ce3d/occlusion_ea1f514a-e352-11ed-8c5e-00d86184ce3d/scan_eb2d6131-e352-11ed-8c5e-00d86184ce3d/2501b92a-e353-11ed-8c5e-00d86184ce3d.png','PATIENT_6175c1d5-e350-11ed-8c5e-00d86184ce3d_ACT_ea1c884f-e352-11ed-8c5e-00d86184ce3d_SESS_ea1f514a-e352-11ed-8c5e-00d86184ce3d_TOSC_eb2d6131-e352-11ed-8c5e-00d86184ce3d_SNAPS','2501b92a-e353-11ed-8c5e-00d86184ce3d.png','2501b92a-e353-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.13.2.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-25 12:22:56.101','2023-04-25 10:22:56.788',NULL),('25ce33f0-1cae-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/4375c5f1-1cad-11ee-997b-a0510b46b473/session_4a5f2876-1cad-11ee-997b-a0510b46b473/occlusion_4a624109-1cad-11ee-997b-a0510b46b473/scan_e27b524f-1cad-11ee-997b-a0510b46b473/25ce33f0-1cae-11ee-997b-a0510b46b473.zip','PATIENT_4375c5f1-1cad-11ee-997b-a0510b46b473_ACT_4a5f2876-1cad-11ee-997b-a0510b46b473_SESS_4a624109-1cad-11ee-997b-a0510b46b473_TOSC_e27b524f-1cad-11ee-997b-a0510b46b473_MODEL','25ce33f0-1cae-11ee-997b-a0510b46b473.zip','25ce33f0-1cae-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.31.1.1.3\",\"modelMatrix\":\"0.35933,0.8775,-0.31761,0,-0.933211,0.337879,-0.122295,0,8.86262e-09,0.340341,0.940302,0,-29.2218,-11.0812,-8.97817,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-07 12:07:57.922','2023-07-07 10:07:58.589',NULL),('25ce4242-1cae-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/4375c5f1-1cad-11ee-997b-a0510b46b473/session_4a5f2876-1cad-11ee-997b-a0510b46b473/occlusion_4a624109-1cad-11ee-997b-a0510b46b473/scan_e27b524f-1cad-11ee-997b-a0510b46b473/25ce4242-1cae-11ee-997b-a0510b46b473.png','PATIENT_4375c5f1-1cad-11ee-997b-a0510b46b473_ACT_4a5f2876-1cad-11ee-997b-a0510b46b473_SESS_4a624109-1cad-11ee-997b-a0510b46b473_TOSC_e27b524f-1cad-11ee-997b-a0510b46b473_SNAPS','25ce4242-1cae-11ee-997b-a0510b46b473.png','25ce4242-1cae-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.31.1.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-07 12:07:57.922','2023-07-07 10:07:58.590',NULL),('260b18a9-2ac2-11ee-80c8-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_3a881645-2abf-11ee-80c8-a0510b46b473/occlusion_3a8b3537-2abf-11ee-80c8-a0510b46b473/scan_e76a9fb3-2ac1-11ee-80c8-a0510b46b473/260b18a9-2ac2-11ee-80c8-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_3a881645-2abf-11ee-80c8-a0510b46b473_SESS_3a8b3537-2abf-11ee-80c8-a0510b46b473_TOSC_e76a9fb3-2ac1-11ee-80c8-a0510b46b473_MODEL','260b18a9-2ac2-11ee-80c8-a0510b46b473.zip','260b18a9-2ac2-11ee-80c8-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.7.1.7\",\"modelMatrix\":\"0.606475,0.750554,-0.262405,0,-0.795102,0.572495,-0.200153,0,-1.34619e-08,0.330027,0.943971,0,-29.2597,-9.13422,-7.03039,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-25 10:06:24.534','2023-07-25 08:06:25.063',NULL),('260b3f9c-2ac2-11ee-80c8-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_3a881645-2abf-11ee-80c8-a0510b46b473/occlusion_3a8b3537-2abf-11ee-80c8-a0510b46b473/scan_e76a9fb3-2ac1-11ee-80c8-a0510b46b473/260b3f9c-2ac2-11ee-80c8-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_3a881645-2abf-11ee-80c8-a0510b46b473_SESS_3a8b3537-2abf-11ee-80c8-a0510b46b473_TOSC_e76a9fb3-2ac1-11ee-80c8-a0510b46b473_SNAPS','260b3f9c-2ac2-11ee-80c8-a0510b46b473.png','260b3f9c-2ac2-11ee-80c8-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.7.1.7 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-25 10:06:24.535','2023-07-25 08:06:25.064',NULL),('26cd72c2-1a78-11ee-8124-a0510b46b473',11,'/home/scan/.data//2023/11/61e16a70-1a76-11ee-8124-a0510b46b473/session_c8578c2f-1a77-11ee-8124-a0510b46b473/occlusion_c85af2e9-1a77-11ee-8124-a0510b46b473/scan_c9a89237-1a77-11ee-8124-a0510b46b473/26cd72c2-1a78-11ee-8124-a0510b46b473.zip','PATIENT_61e16a70-1a76-11ee-8124-a0510b46b473_ACT_c8578c2f-1a77-11ee-8124-a0510b46b473_SESS_c85af2e9-1a77-11ee-8124-a0510b46b473_TOSC_c9a89237-1a77-11ee-8124-a0510b46b473_MODEL','26cd72c2-1a78-11ee-8124-a0510b46b473.zip','26cd72c2-1a78-11ee-8124-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.27.2.1.1\",\"modelMatrix\":\"0.711705,0.694127,-0.107998,0,-0.702478,0.703244,-0.109416,0,4.40171e-09,0.153738,0.988112,0,-28.0748,-3.7654,-12.4425,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-04 16:36:24.446','2023-07-04 14:36:25.019',NULL),('26cd94f1-1a78-11ee-8124-a0510b46b473',11,'/home/scan/.data//2023/11/61e16a70-1a76-11ee-8124-a0510b46b473/session_c8578c2f-1a77-11ee-8124-a0510b46b473/occlusion_c85af2e9-1a77-11ee-8124-a0510b46b473/scan_c9a89237-1a77-11ee-8124-a0510b46b473/26cd94f1-1a78-11ee-8124-a0510b46b473.png','PATIENT_61e16a70-1a76-11ee-8124-a0510b46b473_ACT_c8578c2f-1a77-11ee-8124-a0510b46b473_SESS_c85af2e9-1a77-11ee-8124-a0510b46b473_TOSC_c9a89237-1a77-11ee-8124-a0510b46b473_SNAPS','26cd94f1-1a78-11ee-8124-a0510b46b473.png','26cd94f1-1a78-11ee-8124-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.27.2.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-04 16:36:24.446','2023-07-04 14:36:25.020',NULL),('271c3478-158d-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/634153bc-1587-11ee-b3b1-00d86184ce3d/session_6e9df503-1587-11ee-b3b1-00d86184ce3d/occlusion_6ea0d9b2-1587-11ee-b3b1-00d86184ce3d/scan_ce20f900-158c-11ee-b3b1-00d86184ce3d/271c3478-158d-11ee-b3b1-00d86184ce3d.zip','PATIENT_634153bc-1587-11ee-b3b1-00d86184ce3d_ACT_6e9df503-1587-11ee-b3b1-00d86184ce3d_SESS_6ea0d9b2-1587-11ee-b3b1-00d86184ce3d_TOSC_ce20f900-158c-11ee-b3b1-00d86184ce3d_MODEL','271c3478-158d-11ee-b3b1-00d86184ce3d.zip','271c3478-158d-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.24.1.1.8\",\"modelMatrix\":\"0.449855,0.877814,-0.16454,0,-0.893102,0.442155,-0.0828786,0,7.7923e-09,0.184234,0.982882,0,-28.5285,-15.0672,-9.03386,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-28 10:24:08.579','2023-06-28 08:24:09.333',NULL),('271c4c35-158d-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/634153bc-1587-11ee-b3b1-00d86184ce3d/session_6e9df503-1587-11ee-b3b1-00d86184ce3d/occlusion_6ea0d9b2-1587-11ee-b3b1-00d86184ce3d/scan_ce20f900-158c-11ee-b3b1-00d86184ce3d/271c4c35-158d-11ee-b3b1-00d86184ce3d.png','PATIENT_634153bc-1587-11ee-b3b1-00d86184ce3d_ACT_6e9df503-1587-11ee-b3b1-00d86184ce3d_SESS_6ea0d9b2-1587-11ee-b3b1-00d86184ce3d_TOSC_ce20f900-158c-11ee-b3b1-00d86184ce3d_SNAPS','271c4c35-158d-11ee-b3b1-00d86184ce3d.png','271c4c35-158d-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.24.1.1.8 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-28 10:24:08.580','2023-06-28 08:24:09.333',NULL),('280a21a2-10db-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/bd51960a-10d5-11ee-b636-a0510b46b473/session_ea36dd21-10da-11ee-b636-a0510b46b473/occlusion_ea39c2be-10da-11ee-b636-a0510b46b473/scan_eb127b00-10da-11ee-b636-a0510b46b473/280a21a2-10db-11ee-b636-a0510b46b473.zip','PATIENT_bd51960a-10d5-11ee-b636-a0510b46b473_ACT_ea36dd21-10da-11ee-b636-a0510b46b473_SESS_ea39c2be-10da-11ee-b636-a0510b46b473_TOSC_eb127b00-10da-11ee-b636-a0510b46b473_MODEL','280a21a2-10db-11ee-b636-a0510b46b473.zip','280a21a2-10db-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.17.2.1.1\",\"modelMatrix\":\"0.67768,0.629442,-0.380202,0,-0.735357,0.580072,-0.350381,0,8.69704e-09,0.51703,0.855967,0,-26.5868,0.654674,-7.97318,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 10:59:55.069','2023-06-22 08:59:55.728',NULL),('280a3104-10db-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/bd51960a-10d5-11ee-b636-a0510b46b473/session_ea36dd21-10da-11ee-b636-a0510b46b473/occlusion_ea39c2be-10da-11ee-b636-a0510b46b473/scan_eb127b00-10da-11ee-b636-a0510b46b473/280a3104-10db-11ee-b636-a0510b46b473.png','PATIENT_bd51960a-10d5-11ee-b636-a0510b46b473_ACT_ea36dd21-10da-11ee-b636-a0510b46b473_SESS_ea39c2be-10da-11ee-b636-a0510b46b473_TOSC_eb127b00-10da-11ee-b636-a0510b46b473_SNAPS','280a3104-10db-11ee-b636-a0510b46b473.png','280a3104-10db-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.17.2.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 10:59:55.070','2023-06-22 08:59:55.738',NULL),('299835b8-1bfe-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/8a8cc548-1bf9-11ee-9323-a0510b46b473/session_976f015a-1bf9-11ee-9323-a0510b46b473/occlusion_97713d19-1bf9-11ee-9323-a0510b46b473/scan_b6e5196d-1bfd-11ee-9323-a0510b46b473/299835b8-1bfe-11ee-9323-a0510b46b473.zip','PATIENT_8a8cc548-1bf9-11ee-9323-a0510b46b473_ACT_976f015a-1bf9-11ee-9323-a0510b46b473_SESS_97713d19-1bf9-11ee-9323-a0510b46b473_TOSC_b6e5196d-1bfd-11ee-9323-a0510b46b473_MODEL','299835b8-1bfe-11ee-9323-a0510b46b473.zip','299835b8-1bfe-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.28.1.1.7\",\"modelMatrix\":\"0.420072,0.875572,-0.238566,0,-0.907491,0.405297,-0.110431,0,5.88731e-09,0.262885,0.964827,0,-27.7757,-14.1754,-8.89761,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 15:08:12.854','2023-07-06 13:08:13.833',NULL),('2998429e-1bfe-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/8a8cc548-1bf9-11ee-9323-a0510b46b473/session_976f015a-1bf9-11ee-9323-a0510b46b473/occlusion_97713d19-1bf9-11ee-9323-a0510b46b473/scan_b6e5196d-1bfd-11ee-9323-a0510b46b473/2998429e-1bfe-11ee-9323-a0510b46b473.png','PATIENT_8a8cc548-1bf9-11ee-9323-a0510b46b473_ACT_976f015a-1bf9-11ee-9323-a0510b46b473_SESS_97713d19-1bf9-11ee-9323-a0510b46b473_TOSC_b6e5196d-1bfd-11ee-9323-a0510b46b473_SNAPS','2998429e-1bfe-11ee-9323-a0510b46b473.png','2998429e-1bfe-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.28.1.1.7 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 15:08:12.855','2023-07-06 13:08:13.834',NULL),('2b49a78a-1033-11ee-895b-a0510b46b473',11,'/home/scan/.data//2023/11/d75719c6-1032-11ee-895b-a0510b46b473/session_e5c513d4-1032-11ee-895b-a0510b46b473/occlusion_e5c7f174-1032-11ee-895b-a0510b46b473/scan_e800b29d-1032-11ee-895b-a0510b46b473/2b49a78a-1033-11ee-895b-a0510b46b473.zip','PATIENT_d75719c6-1032-11ee-895b-a0510b46b473_ACT_e5c513d4-1032-11ee-895b-a0510b46b473_SESS_e5c7f174-1032-11ee-895b-a0510b46b473_TOSC_e800b29d-1032-11ee-895b-a0510b46b473_MODEL','2b49a78a-1033-11ee-895b-a0510b46b473.zip','2b49a78a-1033-11ee-895b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.16.1.1.1\",\"modelMatrix\":\"0.304391,0.925131,-0.226887,0,-0.952547,0.29563,-0.0725029,0,-2.94538e-09,0.23819,0.971218,0,-26.5504,-21.3832,-7.96632,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-21 14:57:25.068','2023-06-21 12:57:25.811',NULL),('2b49c1b7-1033-11ee-895b-a0510b46b473',11,'/home/scan/.data//2023/11/d75719c6-1032-11ee-895b-a0510b46b473/session_e5c513d4-1032-11ee-895b-a0510b46b473/occlusion_e5c7f174-1032-11ee-895b-a0510b46b473/scan_e800b29d-1032-11ee-895b-a0510b46b473/2b49c1b7-1033-11ee-895b-a0510b46b473.png','PATIENT_d75719c6-1032-11ee-895b-a0510b46b473_ACT_e5c513d4-1032-11ee-895b-a0510b46b473_SESS_e5c7f174-1032-11ee-895b-a0510b46b473_TOSC_e800b29d-1032-11ee-895b-a0510b46b473_SNAPS','2b49c1b7-1033-11ee-895b-a0510b46b473.png','2b49c1b7-1033-11ee-895b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.16.1.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-21 14:57:25.069','2023-06-21 12:57:25.813',NULL),('2ba247ae-1cb0-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/4375c5f1-1cad-11ee-997b-a0510b46b473/session_4a5f2876-1cad-11ee-997b-a0510b46b473/occlusion_4a624109-1cad-11ee-997b-a0510b46b473/scan_c6bdaf41-1caf-11ee-997b-a0510b46b473/2ba247ae-1cb0-11ee-997b-a0510b46b473.zip','PATIENT_4375c5f1-1cad-11ee-997b-a0510b46b473_ACT_4a5f2876-1cad-11ee-997b-a0510b46b473_SESS_4a624109-1cad-11ee-997b-a0510b46b473_TOSC_c6bdaf41-1caf-11ee-997b-a0510b46b473_MODEL','2ba247ae-1cb0-11ee-997b-a0510b46b473.zip','2ba247ae-1cb0-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.31.1.1.6\",\"modelMatrix\":\"0.216463,0.95712,-0.192522,0,-0.976291,0.212213,-0.0426859,0,1.09242e-09,0.197197,0.980364,0,-25.3071,-15.504,-8.86344,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-07 12:22:26.694','2023-07-07 10:22:27.438',NULL),('2ba25c84-1cb0-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/4375c5f1-1cad-11ee-997b-a0510b46b473/session_4a5f2876-1cad-11ee-997b-a0510b46b473/occlusion_4a624109-1cad-11ee-997b-a0510b46b473/scan_c6bdaf41-1caf-11ee-997b-a0510b46b473/2ba25c84-1cb0-11ee-997b-a0510b46b473.png','PATIENT_4375c5f1-1cad-11ee-997b-a0510b46b473_ACT_4a5f2876-1cad-11ee-997b-a0510b46b473_SESS_4a624109-1cad-11ee-997b-a0510b46b473_TOSC_c6bdaf41-1caf-11ee-997b-a0510b46b473_SNAPS','2ba25c84-1cb0-11ee-997b-a0510b46b473.png','2ba25c84-1cb0-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.31.1.1.6 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-07 12:22:26.694','2023-07-07 10:22:27.438',NULL),('2bfa7287-e02b-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_ed85304d-e024-11ed-bb13-00d86184ce3d/occlusion_ed88a64f-e024-11ed-bb13-00d86184ce3d/scan_0d97ae6e-e02b-11ed-bb13-00d86184ce3d/2bfa7287-e02b-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_ed85304d-e024-11ed-bb13-00d86184ce3d_SESS_ed88a64f-e024-11ed-bb13-00d86184ce3d_TOSC_0d97ae6e-e02b-11ed-bb13-00d86184ce3d_MODEL','2bfa7287-e02b-11ed-bb13-00d86184ce3d.zip','2bfa7287-e02b-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.1.1.7\",\"modelMatrix\":\"0.837246,0.545723,-0.0347156,0,-0.546826,0.835557,-0.0531531,0,2.40641e-09,0.0634857,0.997983,0,-13.7722,-10.0153,-9.39991,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 11:59:14.440','2023-04-21 09:59:14.719',NULL),('2bfa8a68-e02b-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_ed85304d-e024-11ed-bb13-00d86184ce3d/occlusion_ed88a64f-e024-11ed-bb13-00d86184ce3d/scan_0d97ae6e-e02b-11ed-bb13-00d86184ce3d/2bfa8a68-e02b-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_ed85304d-e024-11ed-bb13-00d86184ce3d_SESS_ed88a64f-e024-11ed-bb13-00d86184ce3d_TOSC_0d97ae6e-e02b-11ed-bb13-00d86184ce3d_SNAPS','2bfa8a68-e02b-11ed-bb13-00d86184ce3d.png','2bfa8a68-e02b-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.1.1.7 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 11:59:14.440','2023-04-21 09:59:14.720',NULL),('2c5c76a9-1ca2-11ee-84c4-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_06fff4e1-1ca0-11ee-84c4-a0510b46b473/occlusion_0701c127-1ca0-11ee-84c4-a0510b46b473/scan_cd07f0fe-1ca1-11ee-84c4-a0510b46b473/2c5c76a9-1ca2-11ee-84c4-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_06fff4e1-1ca0-11ee-84c4-a0510b46b473_SESS_0701c127-1ca0-11ee-84c4-a0510b46b473_TOSC_cd07f0fe-1ca1-11ee-84c4-a0510b46b473_MODEL','2c5c76a9-1ca2-11ee-84c4-a0510b46b473.zip','2c5c76a9-1ca2-11ee-84c4-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.1.1.6\",\"modelMatrix\":\"0.834517,0.540539,-0.106759,0,-0.550981,0.818702,-0.161698,0,6.65323e-10,0.193762,0.981049,0,-30.1947,4.56483,-13.2659,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-07 10:42:14.960','2023-07-07 08:42:15.747',NULL),('2c5ce62c-1ca2-11ee-84c4-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_06fff4e1-1ca0-11ee-84c4-a0510b46b473/occlusion_0701c127-1ca0-11ee-84c4-a0510b46b473/scan_cd07f0fe-1ca1-11ee-84c4-a0510b46b473/2c5ce62c-1ca2-11ee-84c4-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_06fff4e1-1ca0-11ee-84c4-a0510b46b473_SESS_0701c127-1ca0-11ee-84c4-a0510b46b473_TOSC_cd07f0fe-1ca1-11ee-84c4-a0510b46b473_SNAPS','2c5ce62c-1ca2-11ee-84c4-a0510b46b473.png','2c5ce62c-1ca2-11ee-84c4-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.1.1.6 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-07 10:42:14.963','2023-07-07 08:42:15.747',NULL),('2cf1d122-26f7-11ee-aa9d-a0510b46b473',11,'/home/scan/.data//2023/11/c69c4cec-26f5-11ee-aa9d-a0510b46b473/session_cf31a6d6-26f5-11ee-aa9d-a0510b46b473/occlusion_cf34c227-26f5-11ee-aa9d-a0510b46b473/scan_bb51d68b-26f6-11ee-aa9d-a0510b46b473/2cf1d122-26f7-11ee-aa9d-a0510b46b473.zip','PATIENT_c69c4cec-26f5-11ee-aa9d-a0510b46b473_ACT_cf31a6d6-26f5-11ee-aa9d-a0510b46b473_SESS_cf34c227-26f5-11ee-aa9d-a0510b46b473_TOSC_bb51d68b-26f6-11ee-aa9d-a0510b46b473_MODEL','2cf1d122-26f7-11ee-aa9d-a0510b46b473.zip','2cf1d122-26f7-11ee-aa9d-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.35.1.1.3\",\"modelMatrix\":\"0.516923,-0.852879,0.073403,0,0.856032,0.515019,-0.0443251,0,-1.37643e-09,0.085748,0.996317,0,3.3982,18.4114,-14.3282,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-20 14:15:54.788','2023-07-20 12:15:55.747',NULL),('2cf32360-26f7-11ee-aa9d-a0510b46b473',11,'/home/scan/.data//2023/11/c69c4cec-26f5-11ee-aa9d-a0510b46b473/session_cf31a6d6-26f5-11ee-aa9d-a0510b46b473/occlusion_cf34c227-26f5-11ee-aa9d-a0510b46b473/scan_bb51d68b-26f6-11ee-aa9d-a0510b46b473/2cf32360-26f7-11ee-aa9d-a0510b46b473.png','PATIENT_c69c4cec-26f5-11ee-aa9d-a0510b46b473_ACT_cf31a6d6-26f5-11ee-aa9d-a0510b46b473_SESS_cf34c227-26f5-11ee-aa9d-a0510b46b473_TOSC_bb51d68b-26f6-11ee-aa9d-a0510b46b473_SNAPS','2cf32360-26f7-11ee-aa9d-a0510b46b473.png','2cf32360-26f7-11ee-aa9d-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.35.1.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-20 14:15:54.797','2023-07-20 12:15:55.748',NULL),('2f0bf14b-1a73-11ee-9bd8-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_77df3b68-1a6c-11ee-af16-a0510b46b473/occlusion_77e234a6-1a6c-11ee-af16-a0510b46b473/scan_de3de44c-1a72-11ee-9bd8-a0510b46b473/2f0bf14b-1a73-11ee-9bd8-a0510b46b473.zip','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_77df3b68-1a6c-11ee-af16-a0510b46b473_SESS_77e234a6-1a6c-11ee-af16-a0510b46b473_TOSC_de3de44c-1a72-11ee-9bd8-a0510b46b473_MODEL','2f0bf14b-1a73-11ee-9bd8-a0510b46b473.zip','2f0bf14b-1a73-11ee-9bd8-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.4.1.6\",\"modelMatrix\":\"0.0565439,0.9912,-0.119689,0,-0.9984,0.0561361,-0.00677852,0,5.74625e-11,0.119881,0.992788,0,-20.0175,-24.2927,-10.3126,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-04 16:00:50.793','2023-07-04 14:00:51.530',NULL),('2f0c0dca-1a73-11ee-9bd8-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_77df3b68-1a6c-11ee-af16-a0510b46b473/occlusion_77e234a6-1a6c-11ee-af16-a0510b46b473/scan_de3de44c-1a72-11ee-9bd8-a0510b46b473/2f0c0dca-1a73-11ee-9bd8-a0510b46b473.png','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_77df3b68-1a6c-11ee-af16-a0510b46b473_SESS_77e234a6-1a6c-11ee-af16-a0510b46b473_TOSC_de3de44c-1a72-11ee-9bd8-a0510b46b473_SNAPS','2f0c0dca-1a73-11ee-9bd8-a0510b46b473.png','2f0c0dca-1a73-11ee-9bd8-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.4.1.6 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-04 16:00:50.794','2023-07-04 14:00:51.531',NULL),('2f766921-e02e-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_ed85304d-e024-11ed-bb13-00d86184ce3d/occlusion_ed88a64f-e024-11ed-bb13-00d86184ce3d/scan_16f3e3bc-e02e-11ed-bb13-00d86184ce3d/2f766921-e02e-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_ed85304d-e024-11ed-bb13-00d86184ce3d_SESS_ed88a64f-e024-11ed-bb13-00d86184ce3d_TOSC_16f3e3bc-e02e-11ed-bb13-00d86184ce3d_MODEL','2f766921-e02e-11ed-bb13-00d86184ce3d.zip','2f766921-e02e-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.1.1.12\",\"modelMatrix\":\"0.705285,0.699493,-0.11525,0,-0.708924,0.695903,-0.114658,0,3.65266e-09,0.16257,0.986697,0,-12.7092,-6.93193,-10.1142,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 12:20:48.776','2023-04-21 10:20:49.013',NULL),('2f76c04b-e02e-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_ed85304d-e024-11ed-bb13-00d86184ce3d/occlusion_ed88a64f-e024-11ed-bb13-00d86184ce3d/scan_16f3e3bc-e02e-11ed-bb13-00d86184ce3d/2f76c04b-e02e-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_ed85304d-e024-11ed-bb13-00d86184ce3d_SESS_ed88a64f-e024-11ed-bb13-00d86184ce3d_TOSC_16f3e3bc-e02e-11ed-bb13-00d86184ce3d_SNAPS','2f76c04b-e02e-11ed-bb13-00d86184ce3d.png','2f76c04b-e02e-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.1.1.12 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 12:20:48.778','2023-04-21 10:20:49.013',NULL),('2faa6480-1106-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_0628a8e9-1104-11ee-b636-a0510b46b473/occlusion_062b833f-1104-11ee-b636-a0510b46b473/scan_e13059ec-1105-11ee-b636-a0510b46b473/2faa6480-1106-11ee-b636-a0510b46b473.zip','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_0628a8e9-1104-11ee-b636-a0510b46b473_SESS_062b833f-1104-11ee-b636-a0510b46b473_TOSC_e13059ec-1105-11ee-b636-a0510b46b473_MODEL','2faa6480-1106-11ee-b636-a0510b46b473.zip','2faa6480-1106-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.20.1.1.5\",\"modelMatrix\":\"0.396769,0.904458,-0.156625,0,-0.917919,0.39095,-0.0677006,0,4.13296e-09,0.17063,0.985335,0,-25.4872,-22.1962,-10.7192,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 16:07:56.223','2023-06-22 14:07:56.962',NULL),('2faa7adc-1106-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_0628a8e9-1104-11ee-b636-a0510b46b473/occlusion_062b833f-1104-11ee-b636-a0510b46b473/scan_e13059ec-1105-11ee-b636-a0510b46b473/2faa7adc-1106-11ee-b636-a0510b46b473.png','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_0628a8e9-1104-11ee-b636-a0510b46b473_SESS_062b833f-1104-11ee-b636-a0510b46b473_TOSC_e13059ec-1105-11ee-b636-a0510b46b473_SNAPS','2faa7adc-1106-11ee-b636-a0510b46b473.png','2faa7adc-1106-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.20.1.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 16:07:56.224','2023-06-22 14:07:56.963',NULL),('30d54eb3-1ca3-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_06fff4e1-1ca0-11ee-84c4-a0510b46b473/occlusion_0701c127-1ca0-11ee-84c4-a0510b46b473/scan_ebf0d6e6-1ca2-11ee-997b-a0510b46b473/30d54eb3-1ca3-11ee-997b-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_06fff4e1-1ca0-11ee-84c4-a0510b46b473_SESS_0701c127-1ca0-11ee-84c4-a0510b46b473_TOSC_ebf0d6e6-1ca2-11ee-997b-a0510b46b473_MODEL','30d54eb3-1ca3-11ee-997b-a0510b46b473.zip','30d54eb3-1ca3-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.1.1.8\",\"modelMatrix\":\"0.622212,0.772675,-0.125797,0,-0.782849,0.614126,-0.0999844,0,3.55872e-09,0.160692,0.987005,0,-31.8435,-7.95218,-9.64972,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-07 10:49:31.959','2023-07-07 08:49:32.561',NULL),('30d5695d-1ca3-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_06fff4e1-1ca0-11ee-84c4-a0510b46b473/occlusion_0701c127-1ca0-11ee-84c4-a0510b46b473/scan_ebf0d6e6-1ca2-11ee-997b-a0510b46b473/30d5695d-1ca3-11ee-997b-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_06fff4e1-1ca0-11ee-84c4-a0510b46b473_SESS_0701c127-1ca0-11ee-84c4-a0510b46b473_TOSC_ebf0d6e6-1ca2-11ee-997b-a0510b46b473_SNAPS','30d5695d-1ca3-11ee-997b-a0510b46b473.png','30d5695d-1ca3-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.1.1.8 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-07 10:49:31.960','2023-07-07 08:49:32.562',NULL),('31333f4e-1c07-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/ae8bd11e-1c05-11ee-9323-a0510b46b473/session_bb436bde-1c05-11ee-9323-a0510b46b473/occlusion_bb465a1e-1c05-11ee-9323-a0510b46b473/scan_c7c3600f-1c06-11ee-9323-a0510b46b473/31333f4e-1c07-11ee-9323-a0510b46b473.zip','PATIENT_ae8bd11e-1c05-11ee-9323-a0510b46b473_ACT_bb436bde-1c05-11ee-9323-a0510b46b473_SESS_bb465a1e-1c05-11ee-9323-a0510b46b473_TOSC_c7c3600f-1c06-11ee-9323-a0510b46b473_MODEL','31333f4e-1c07-11ee-9323-a0510b46b473.zip','31333f4e-1c07-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.29.1.1.4\",\"modelMatrix\":\"0.930187,0.355634,-0.0909788,0,-0.367087,0.901166,-0.230537,0,8.28899e-09,0.24784,0.968801,0,-32.8677,1.90854,-12.4564,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 16:12:51.085','2023-07-06 14:12:51.843',NULL),('313481bc-1c07-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/ae8bd11e-1c05-11ee-9323-a0510b46b473/session_bb436bde-1c05-11ee-9323-a0510b46b473/occlusion_bb465a1e-1c05-11ee-9323-a0510b46b473/scan_c7c3600f-1c06-11ee-9323-a0510b46b473/313481bc-1c07-11ee-9323-a0510b46b473.png','PATIENT_ae8bd11e-1c05-11ee-9323-a0510b46b473_ACT_bb436bde-1c05-11ee-9323-a0510b46b473_SESS_bb465a1e-1c05-11ee-9323-a0510b46b473_TOSC_c7c3600f-1c06-11ee-9323-a0510b46b473_SNAPS','313481bc-1c07-11ee-9323-a0510b46b473.png','313481bc-1c07-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.29.1.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 16:12:51.093','2023-07-06 14:12:51.843',NULL),('316b16dc-1ca8-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_08b47e37-1ca8-11ee-997b-a0510b46b473/occlusion_08b766f9-1ca8-11ee-997b-a0510b46b473/scan_09a559d7-1ca8-11ee-997b-a0510b46b473/316b16dc-1ca8-11ee-997b-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_08b47e37-1ca8-11ee-997b-a0510b46b473_SESS_08b766f9-1ca8-11ee-997b-a0510b46b473_TOSC_09a559d7-1ca8-11ee-997b-a0510b46b473_MODEL','316b16dc-1ca8-11ee-997b-a0510b46b473.zip','316b16dc-1ca8-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.2.1.1\",\"modelMatrix\":\"0.733622,0.565619,-0.376662,0,-0.679558,0.610618,-0.406629,0,3.64838e-09,0.554276,0.832333,0,-28.6279,5.46461,-10.3931,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-07 11:25:20.425','2023-07-07 09:25:20.802',NULL),('316c5a9b-1ca8-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_08b47e37-1ca8-11ee-997b-a0510b46b473/occlusion_08b766f9-1ca8-11ee-997b-a0510b46b473/scan_09a559d7-1ca8-11ee-997b-a0510b46b473/316c5a9b-1ca8-11ee-997b-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_08b47e37-1ca8-11ee-997b-a0510b46b473_SESS_08b766f9-1ca8-11ee-997b-a0510b46b473_TOSC_09a559d7-1ca8-11ee-997b-a0510b46b473_SNAPS','316c5a9b-1ca8-11ee-997b-a0510b46b473.png','316c5a9b-1ca8-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.2.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-07 11:25:20.433','2023-07-07 09:25:20.802',NULL),('322cdd7e-dd03-11ed-8097-00d86184ce3d',11,'/home/scan/.data//2023/11/59af3050-dcfe-11ed-8097-00d86184ce3d/session_61025fcf-dcfe-11ed-8097-00d86184ce3d/occlusion_610548c3-dcfe-11ed-8097-00d86184ce3d/scan_ea0b0ca6-dd02-11ed-8097-00d86184ce3d/322cdd7e-dd03-11ed-8097-00d86184ce3d.zip','PATIENT_59af3050-dcfe-11ed-8097-00d86184ce3d_ACT_61025fcf-dcfe-11ed-8097-00d86184ce3d_SESS_610548c3-dcfe-11ed-8097-00d86184ce3d_TOSC_ea0b0ca6-dd02-11ed-8097-00d86184ce3d_MODEL','322cdd7e-dd03-11ed-8097-00d86184ce3d.zip','322cdd7e-dd03-11ed-8097-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.1.1.1.6\",\"modelMatrix\":\"-0.000545423,0.969154,-0.246457,0,-1,-0.000528598,0.000134423,0,-5.59884e-13,0.246457,0.969154,0,-26.2541,-17.8803,-6.75991,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-04-17 11:35:31.479','2023-04-17 09:35:32.331','2023-04-17 11:35:32.729'),('322cf38b-dd03-11ed-8097-00d86184ce3d',11,'/home/scan/.data//2023/11/59af3050-dcfe-11ed-8097-00d86184ce3d/session_61025fcf-dcfe-11ed-8097-00d86184ce3d/occlusion_610548c3-dcfe-11ed-8097-00d86184ce3d/scan_ea0b0ca6-dd02-11ed-8097-00d86184ce3d/322cf38b-dd03-11ed-8097-00d86184ce3d.png','PATIENT_59af3050-dcfe-11ed-8097-00d86184ce3d_ACT_61025fcf-dcfe-11ed-8097-00d86184ce3d_SESS_610548c3-dcfe-11ed-8097-00d86184ce3d_TOSC_ea0b0ca6-dd02-11ed-8097-00d86184ce3d_SNAPS','322cf38b-dd03-11ed-8097-00d86184ce3d.png','322cf38b-dd03-11ed-8097-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.1.1.1.6 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-04-17 11:35:31.480','2023-04-17 09:35:32.332','2023-04-17 11:35:32.863'),('3254740e-dd05-11ed-8097-00d86184ce3d',11,'/home/scan/.data//2023/11/59af3050-dcfe-11ed-8097-00d86184ce3d/session_61025fcf-dcfe-11ed-8097-00d86184ce3d/occlusion_610548c3-dcfe-11ed-8097-00d86184ce3d/scan_a86f9827-dd04-11ed-8097-00d86184ce3d/3254740e-dd05-11ed-8097-00d86184ce3d.zip','PATIENT_59af3050-dcfe-11ed-8097-00d86184ce3d_ACT_61025fcf-dcfe-11ed-8097-00d86184ce3d_SESS_610548c3-dcfe-11ed-8097-00d86184ce3d_TOSC_a86f9827-dd04-11ed-8097-00d86184ce3d_MODEL','3254740e-dd05-11ed-8097-00d86184ce3d.zip','3254740e-dd05-11ed-8097-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.1.1.1.10\",\"modelMatrix\":\"-0.432649,0.862094,-0.263834,0,-0.901563,-0.413709,0.12661,0,4.41322e-09,0.29264,0.956223,0,-9.79482,-32.6383,-8.48117,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-04-17 11:49:50.732','2023-04-17 09:49:51.883','2023-04-17 11:49:52.308'),('325487c1-dd05-11ed-8097-00d86184ce3d',11,'/home/scan/.data//2023/11/59af3050-dcfe-11ed-8097-00d86184ce3d/session_61025fcf-dcfe-11ed-8097-00d86184ce3d/occlusion_610548c3-dcfe-11ed-8097-00d86184ce3d/scan_a86f9827-dd04-11ed-8097-00d86184ce3d/325487c1-dd05-11ed-8097-00d86184ce3d.png','PATIENT_59af3050-dcfe-11ed-8097-00d86184ce3d_ACT_61025fcf-dcfe-11ed-8097-00d86184ce3d_SESS_610548c3-dcfe-11ed-8097-00d86184ce3d_TOSC_a86f9827-dd04-11ed-8097-00d86184ce3d_SNAPS','325487c1-dd05-11ed-8097-00d86184ce3d.png','325487c1-dd05-11ed-8097-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.1.1.1.10 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-04-17 11:49:50.732','2023-04-17 09:49:51.883','2023-04-17 11:49:52.454'),('33637ec8-10fb-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/ed94fe78-10f4-11ee-b636-a0510b46b473/session_f8ef8fe7-10f4-11ee-b636-a0510b46b473/occlusion_f8f2e241-10f4-11ee-b636-a0510b46b473/scan_d89c3191-10fa-11ee-b636-a0510b46b473/33637ec8-10fb-11ee-b636-a0510b46b473.zip','PATIENT_ed94fe78-10f4-11ee-b636-a0510b46b473_ACT_f8ef8fe7-10f4-11ee-b636-a0510b46b473_SESS_f8f2e241-10f4-11ee-b636-a0510b46b473_TOSC_d89c3191-10fa-11ee-b636-a0510b46b473_MODEL','33637ec8-10fb-11ee-b636-a0510b46b473.zip','33637ec8-10fb-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.19.1.1.7\",\"modelMatrix\":\"-0.00237663,0.980168,-0.198153,0,-0.999997,-0.00232951,0.000470938,0,-1.80532e-11,0.198154,0.980171,0,-21.1796,-26.549,-6.78938,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 14:49:18.005','2023-06-22 12:49:18.794',NULL),('3364ba73-10fb-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/ed94fe78-10f4-11ee-b636-a0510b46b473/session_f8ef8fe7-10f4-11ee-b636-a0510b46b473/occlusion_f8f2e241-10f4-11ee-b636-a0510b46b473/scan_d89c3191-10fa-11ee-b636-a0510b46b473/3364ba73-10fb-11ee-b636-a0510b46b473.png','PATIENT_ed94fe78-10f4-11ee-b636-a0510b46b473_ACT_f8ef8fe7-10f4-11ee-b636-a0510b46b473_SESS_f8f2e241-10f4-11ee-b636-a0510b46b473_TOSC_d89c3191-10fa-11ee-b636-a0510b46b473_SNAPS','3364ba73-10fb-11ee-b636-a0510b46b473.png','3364ba73-10fb-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.19.1.1.7 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 14:49:18.013','2023-06-22 12:49:18.795',NULL),('34ccb5e1-15b7-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/142e7037-15b6-11ee-b3b1-00d86184ce3d/session_1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d/occlusion_1ed7780a-15b6-11ee-b3b1-00d86184ce3d/scan_dc4c3873-15b6-11ee-b3b1-00d86184ce3d/34ccb5e1-15b7-11ee-b3b1-00d86184ce3d.zip','PATIENT_142e7037-15b6-11ee-b3b1-00d86184ce3d_ACT_1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d_SESS_1ed7780a-15b6-11ee-b3b1-00d86184ce3d_TOSC_dc4c3873-15b6-11ee-b3b1-00d86184ce3d_MODEL','34ccb5e1-15b7-11ee-b3b1-00d86184ce3d.zip','34ccb5e1-15b7-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.25.1.1.3\",\"modelMatrix\":\"0.931904,0.343321,-0.116983,0,-0.362705,0.882103,-0.300567,0,3.19417e-09,0.32253,0.946559,0,-27.2244,8.76213,-13.4325,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-28 15:25:10.409','2023-06-28 13:25:11.050',NULL),('34cd2b4a-15b7-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/142e7037-15b6-11ee-b3b1-00d86184ce3d/session_1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d/occlusion_1ed7780a-15b6-11ee-b3b1-00d86184ce3d/scan_dc4c3873-15b6-11ee-b3b1-00d86184ce3d/34cd2b4a-15b7-11ee-b3b1-00d86184ce3d.png','PATIENT_142e7037-15b6-11ee-b3b1-00d86184ce3d_ACT_1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d_SESS_1ed7780a-15b6-11ee-b3b1-00d86184ce3d_TOSC_dc4c3873-15b6-11ee-b3b1-00d86184ce3d_SNAPS','34cd2b4a-15b7-11ee-b3b1-00d86184ce3d.png','34cd2b4a-15b7-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.25.1.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-28 15:25:10.412','2023-06-28 13:25:11.051',NULL),('36eb6ec6-14c6-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/9619fcac-14c3-11ee-b3b1-00d86184ce3d/session_961b9a11-14c3-11ee-b3b1-00d86184ce3d/occlusion_961d56b4-14c3-11ee-b3b1-00d86184ce3d/scan_bb0f5130-14c5-11ee-b3b1-00d86184ce3d/36eb6ec6-14c6-11ee-b3b1-00d86184ce3d.zip','PATIENT_9619fcac-14c3-11ee-b3b1-00d86184ce3d_ACT_961b9a11-14c3-11ee-b3b1-00d86184ce3d_SESS_961d56b4-14c3-11ee-b3b1-00d86184ce3d_TOSC_bb0f5130-14c5-11ee-b3b1-00d86184ce3d_MODEL','36eb6ec6-14c6-11ee-b3b1-00d86184ce3d.zip','36eb6ec6-14c6-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.22.1.1.1\",\"modelMatrix\":\"0.94599,0.31954,-0.0547401,0,-0.324195,0.932408,-0.15973,0,-1.73527e-09,0.168849,0.985642,0,-29.4705,4.33767,-11.6114,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-27 10:40:05.254','2023-06-27 08:45:11.564',NULL),('36eb8cc6-14c6-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/9619fcac-14c3-11ee-b3b1-00d86184ce3d/session_961b9a11-14c3-11ee-b3b1-00d86184ce3d/occlusion_961d56b4-14c3-11ee-b3b1-00d86184ce3d/scan_bb0f5130-14c5-11ee-b3b1-00d86184ce3d/36eb8cc6-14c6-11ee-b3b1-00d86184ce3d.png','PATIENT_9619fcac-14c3-11ee-b3b1-00d86184ce3d_ACT_961b9a11-14c3-11ee-b3b1-00d86184ce3d_SESS_961d56b4-14c3-11ee-b3b1-00d86184ce3d_TOSC_bb0f5130-14c5-11ee-b3b1-00d86184ce3d_SNAPS','36eb8cc6-14c6-11ee-b3b1-00d86184ce3d.png','36eb8cc6-14c6-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.22.1.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-27 10:40:05.255','2023-06-27 08:45:11.565',NULL),('37140608-0f41-11ee-8712-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_964f8d9e-0f3e-11ee-8712-a0510b46b473/occlusion_965293c3-0f3e-11ee-8712-a0510b46b473/scan_cbd722e6-0f40-11ee-8712-a0510b46b473/37140608-0f41-11ee-8712-a0510b46b473.zip','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_964f8d9e-0f3e-11ee-8712-a0510b46b473_SESS_965293c3-0f3e-11ee-8712-a0510b46b473_TOSC_cbd722e6-0f40-11ee-8712-a0510b46b473_MODEL','37140608-0f41-11ee-8712-a0510b46b473.zip','37140608-0f41-11ee-8712-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.1.1.7\",\"modelMatrix\":\"0.794265,0.593232,-0.131222,0,-0.607572,0.775519,-0.171543,0,-4.79597e-09,0.215977,0.976398,0,-28.1074,-6.11038,-11.1785,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-20 10:05:26.641','2023-06-20 08:05:27.311',NULL),('37141ddc-0f41-11ee-8712-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_964f8d9e-0f3e-11ee-8712-a0510b46b473/occlusion_965293c3-0f3e-11ee-8712-a0510b46b473/scan_cbd722e6-0f40-11ee-8712-a0510b46b473/37141ddc-0f41-11ee-8712-a0510b46b473.png','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_964f8d9e-0f3e-11ee-8712-a0510b46b473_SESS_965293c3-0f3e-11ee-8712-a0510b46b473_TOSC_cbd722e6-0f40-11ee-8712-a0510b46b473_SNAPS','37141ddc-0f41-11ee-8712-a0510b46b473.png','37141ddc-0f41-11ee-8712-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.1.1.7 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-20 10:05:26.642','2023-06-20 08:05:27.319',NULL),('37955fcf-1cd0-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/4375c5f1-1cad-11ee-997b-a0510b46b473/session_a945b37e-1ccf-11ee-997b-a0510b46b473/occlusion_a948c735-1ccf-11ee-997b-a0510b46b473/scan_fff13798-1ccf-11ee-997b-a0510b46b473/37955fcf-1cd0-11ee-997b-a0510b46b473.zip','PATIENT_4375c5f1-1cad-11ee-997b-a0510b46b473_ACT_a945b37e-1ccf-11ee-997b-a0510b46b473_SESS_a948c735-1ccf-11ee-997b-a0510b46b473_BOSC_fff13798-1ccf-11ee-997b-a0510b46b473_MODEL','37955fcf-1cd0-11ee-997b-a0510b46b473.zip','37955fcf-1cd0-11ee-997b-a0510b46b473','{\"displayTitle\":\"Mandibule 1.31.3.1.1\",\"modelMatrix\":\"-0.749062,0.643323,-0.158244,0,-0.662499,-0.72738,0.17892,0,1.69148e-09,0.238859,0.971054,0,-11.0659,6.03214,-14.3176,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-07 16:11:50.637','2023-07-07 14:11:51.125',NULL),('379577b0-1cd0-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/4375c5f1-1cad-11ee-997b-a0510b46b473/session_a945b37e-1ccf-11ee-997b-a0510b46b473/occlusion_a948c735-1ccf-11ee-997b-a0510b46b473/scan_fff13798-1ccf-11ee-997b-a0510b46b473/379577b0-1cd0-11ee-997b-a0510b46b473.png','PATIENT_4375c5f1-1cad-11ee-997b-a0510b46b473_ACT_a945b37e-1ccf-11ee-997b-a0510b46b473_SESS_a948c735-1ccf-11ee-997b-a0510b46b473_BOSC_fff13798-1ccf-11ee-997b-a0510b46b473_SNAPS','379577b0-1cd0-11ee-997b-a0510b46b473.png','379577b0-1cd0-11ee-997b-a0510b46b473','{\"displayTitle\":\"Mandibule 1.31.3.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-07 16:11:50.638','2023-07-07 14:11:51.126',NULL),('381bc9a1-1a61-11ee-9a4f-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_56e1eee3-1a49-11ee-9a4f-a0510b46b473/occlusion_56e449e9-1a49-11ee-9a4f-a0510b46b473/scan_ecaaddb8-1a60-11ee-9a4f-a0510b46b473/381bc9a1-1a61-11ee-9a4f-a0510b46b473.zip','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_56e1eee3-1a49-11ee-9a4f-a0510b46b473_SESS_56e449e9-1a49-11ee-9a4f-a0510b46b473_TOSC_ecaaddb8-1a60-11ee-9a4f-a0510b46b473_MODEL','381bc9a1-1a61-11ee-9a4f-a0510b46b473.zip','381bc9a1-1a61-11ee-9a4f-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.1.1.4\",\"modelMatrix\":\"0.0760124,0.996929,-0.0188182,0,-0.997107,0.0759989,-0.00143457,0,-4.35231e-11,0.0188728,0.999822,0,-21.257,-15.2655,-11.2869,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-04 13:52:15.056','2023-07-04 11:52:15.737',NULL),('381beed0-1a61-11ee-9a4f-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_56e1eee3-1a49-11ee-9a4f-a0510b46b473/occlusion_56e449e9-1a49-11ee-9a4f-a0510b46b473/scan_ecaaddb8-1a60-11ee-9a4f-a0510b46b473/381beed0-1a61-11ee-9a4f-a0510b46b473.png','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_56e1eee3-1a49-11ee-9a4f-a0510b46b473_SESS_56e449e9-1a49-11ee-9a4f-a0510b46b473_TOSC_ecaaddb8-1a60-11ee-9a4f-a0510b46b473_SNAPS','381beed0-1a61-11ee-9a4f-a0510b46b473.png','381beed0-1a61-11ee-9a4f-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.1.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-04 13:52:15.056','2023-07-04 11:52:15.738',NULL),('38273173-2ac0-11ee-80c8-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_3a881645-2abf-11ee-80c8-a0510b46b473/occlusion_3a8b3537-2abf-11ee-80c8-a0510b46b473/scan_bd353ae4-2abf-11ee-80c8-a0510b46b473/38273173-2ac0-11ee-80c8-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_3a881645-2abf-11ee-80c8-a0510b46b473_SESS_3a8b3537-2abf-11ee-80c8-a0510b46b473_TOSC_bd353ae4-2abf-11ee-80c8-a0510b46b473_MODEL','38273173-2ac0-11ee-80c8-a0510b46b473.zip','38273173-2ac0-11ee-80c8-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.7.1.2\",\"modelMatrix\":\"0.79094,0.513216,-0.333201,0,-0.611894,0.663389,-0.430699,0,8.21655e-09,0.544541,0.838735,0,-27.9442,-0.341365,-7.34314,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-25 09:52:35.924','2023-07-25 07:52:36.392',NULL),('38274972-2ac0-11ee-80c8-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_3a881645-2abf-11ee-80c8-a0510b46b473/occlusion_3a8b3537-2abf-11ee-80c8-a0510b46b473/scan_bd353ae4-2abf-11ee-80c8-a0510b46b473/38274972-2ac0-11ee-80c8-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_3a881645-2abf-11ee-80c8-a0510b46b473_SESS_3a8b3537-2abf-11ee-80c8-a0510b46b473_TOSC_bd353ae4-2abf-11ee-80c8-a0510b46b473_SNAPS','38274972-2ac0-11ee-80c8-a0510b46b473.png','38274972-2ac0-11ee-80c8-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.7.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-25 09:52:35.925','2023-07-25 07:52:36.393',NULL),('3879b7b1-deb4-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/cf3f0588-deb2-11ed-9cc3-00d86184ce3d/session_d7750b8d-deb2-11ed-9cc3-00d86184ce3d/occlusion_d7775a50-deb2-11ed-9cc3-00d86184ce3d/scan_e018bc45-deb3-11ed-9cc3-00d86184ce3d/3879b7b1-deb4-11ed-9cc3-00d86184ce3d.zip','PATIENT_cf3f0588-deb2-11ed-9cc3-00d86184ce3d_ACT_d7750b8d-deb2-11ed-9cc3-00d86184ce3d_SESS_d7775a50-deb2-11ed-9cc3-00d86184ce3d_TOSC_e018bc45-deb3-11ed-9cc3-00d86184ce3d_MODEL','3879b7b1-deb4-11ed-9cc3-00d86184ce3d.zip','3879b7b1-deb4-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.6.1.1.3\",\"modelMatrix\":\"-0.180539,0.950114,-0.254342,0,-0.983568,-0.174398,0.0466857,0,-3.4707e-09,0.258591,0.965987,0,-15.6767,-27.9874,-7.44091,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-19 15:15:14.133','2023-04-19 13:15:15.251',NULL),('3879d1cd-deb4-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/cf3f0588-deb2-11ed-9cc3-00d86184ce3d/session_d7750b8d-deb2-11ed-9cc3-00d86184ce3d/occlusion_d7775a50-deb2-11ed-9cc3-00d86184ce3d/scan_e018bc45-deb3-11ed-9cc3-00d86184ce3d/3879d1cd-deb4-11ed-9cc3-00d86184ce3d.png','PATIENT_cf3f0588-deb2-11ed-9cc3-00d86184ce3d_ACT_d7750b8d-deb2-11ed-9cc3-00d86184ce3d_SESS_d7775a50-deb2-11ed-9cc3-00d86184ce3d_TOSC_e018bc45-deb3-11ed-9cc3-00d86184ce3d_SNAPS','3879d1cd-deb4-11ed-9cc3-00d86184ce3d.png','3879d1cd-deb4-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.6.1.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-19 15:15:14.134','2023-04-19 13:15:15.252',NULL),('38c2e3a4-e354-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/6175c1d5-e350-11ed-8c5e-00d86184ce3d/session_fc5f9260-e353-11ed-8c5e-00d86184ce3d/occlusion_fc627ef8-e353-11ed-8c5e-00d86184ce3d/scan_0514e729-e354-11ed-8c5e-00d86184ce3d/38c2e3a4-e354-11ed-8c5e-00d86184ce3d.zip','PATIENT_6175c1d5-e350-11ed-8c5e-00d86184ce3d_ACT_fc5f9260-e353-11ed-8c5e-00d86184ce3d_SESS_fc627ef8-e353-11ed-8c5e-00d86184ce3d_TOSC_0514e729-e354-11ed-8c5e-00d86184ce3d_MODEL','38c2e3a4-e354-11ed-8c5e-00d86184ce3d.zip','38c2e3a4-e354-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.13.3.1.1\",\"modelMatrix\":\"0.385898,0.847409,-0.364665,0,-0.922541,0.35447,-0.152539,0,-1.14108e-08,0.395283,0.918559,0,-26.9066,-15.93,-3.83723,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-25 12:30:38.740','2023-04-25 10:30:39.395',NULL),('38c2fbc2-e354-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/6175c1d5-e350-11ed-8c5e-00d86184ce3d/session_fc5f9260-e353-11ed-8c5e-00d86184ce3d/occlusion_fc627ef8-e353-11ed-8c5e-00d86184ce3d/scan_0514e729-e354-11ed-8c5e-00d86184ce3d/38c2fbc2-e354-11ed-8c5e-00d86184ce3d.png','PATIENT_6175c1d5-e350-11ed-8c5e-00d86184ce3d_ACT_fc5f9260-e353-11ed-8c5e-00d86184ce3d_SESS_fc627ef8-e353-11ed-8c5e-00d86184ce3d_TOSC_0514e729-e354-11ed-8c5e-00d86184ce3d_SNAPS','38c2fbc2-e354-11ed-8c5e-00d86184ce3d.png','38c2fbc2-e354-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.13.3.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-25 12:30:38.741','2023-04-25 10:30:39.396',NULL),('39bf38cb-1bdd-11ee-9086-a0510b46b473',11,'/home/scan/.data//2023/11/61e16a70-1a76-11ee-8124-a0510b46b473/session_d30b0955-1bdb-11ee-9086-a0510b46b473/occlusion_d30df7f0-1bdb-11ee-9086-a0510b46b473/scan_f88cdf50-1bdc-11ee-9086-a0510b46b473/39bf38cb-1bdd-11ee-9086-a0510b46b473.zip','PATIENT_61e16a70-1a76-11ee-8124-a0510b46b473_ACT_d30b0955-1bdb-11ee-9086-a0510b46b473_SESS_d30df7f0-1bdb-11ee-9086-a0510b46b473_TOSC_f88cdf50-1bdc-11ee-9086-a0510b46b473_MODEL','39bf38cb-1bdd-11ee-9086-a0510b46b473.zip','39bf38cb-1bdd-11ee-9086-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.27.4.1.5\",\"modelMatrix\":\"0.80098,0.53863,-0.261361,0,-0.598692,0.720624,-0.349671,0,6.04289e-09,0.436554,0.899678,0,-20.227,8.562,-7.96078,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 11:12:26.562','2023-07-06 09:12:26.998',NULL),('39bf4c3b-1bdd-11ee-9086-a0510b46b473',11,'/home/scan/.data//2023/11/61e16a70-1a76-11ee-8124-a0510b46b473/session_d30b0955-1bdb-11ee-9086-a0510b46b473/occlusion_d30df7f0-1bdb-11ee-9086-a0510b46b473/scan_f88cdf50-1bdc-11ee-9086-a0510b46b473/39bf4c3b-1bdd-11ee-9086-a0510b46b473.png','PATIENT_61e16a70-1a76-11ee-8124-a0510b46b473_ACT_d30b0955-1bdb-11ee-9086-a0510b46b473_SESS_d30df7f0-1bdb-11ee-9086-a0510b46b473_TOSC_f88cdf50-1bdc-11ee-9086-a0510b46b473_SNAPS','39bf4c3b-1bdd-11ee-9086-a0510b46b473.png','39bf4c3b-1bdd-11ee-9086-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.27.4.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 11:12:26.562','2023-07-06 09:12:27.000',NULL),('39e35ddc-1c00-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/8a8cc548-1bf9-11ee-9323-a0510b46b473/session_ff6745bb-1bff-11ee-9323-a0510b46b473/occlusion_ff6924df-1bff-11ee-9323-a0510b46b473/scan_0041c98c-1c00-11ee-9323-a0510b46b473/39e35ddc-1c00-11ee-9323-a0510b46b473.zip','PATIENT_8a8cc548-1bf9-11ee-9323-a0510b46b473_ACT_ff6745bb-1bff-11ee-9323-a0510b46b473_SESS_ff6924df-1bff-11ee-9323-a0510b46b473_TOSC_0041c98c-1c00-11ee-9323-a0510b46b473_MODEL','39e35ddc-1c00-11ee-9323-a0510b46b473.zip','39e35ddc-1c00-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.28.2.1.1\",\"modelMatrix\":\"0.812859,0.462184,-0.354467,0,-0.582461,0.645005,-0.49468,0,-9.76036e-09,0.608568,0.793502,0,-24.539,6.05326,-7.07439,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 15:22:59.184','2023-07-06 13:22:59.715',NULL),('39e375b7-1c00-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/8a8cc548-1bf9-11ee-9323-a0510b46b473/session_ff6745bb-1bff-11ee-9323-a0510b46b473/occlusion_ff6924df-1bff-11ee-9323-a0510b46b473/scan_0041c98c-1c00-11ee-9323-a0510b46b473/39e375b7-1c00-11ee-9323-a0510b46b473.png','PATIENT_8a8cc548-1bf9-11ee-9323-a0510b46b473_ACT_ff6745bb-1bff-11ee-9323-a0510b46b473_SESS_ff6924df-1bff-11ee-9323-a0510b46b473_TOSC_0041c98c-1c00-11ee-9323-a0510b46b473_SNAPS','39e375b7-1c00-11ee-9323-a0510b46b473.png','39e375b7-1c00-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.28.2.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 15:22:59.185','2023-07-06 13:22:59.718',NULL),('3a1e37de-1036-11ee-895b-a0510b46b473',11,'/home/scan/.data//2023/11/d75719c6-1032-11ee-895b-a0510b46b473/session_6897acc6-1035-11ee-895b-a0510b46b473/occlusion_689aa1f3-1035-11ee-895b-a0510b46b473/scan_ffed3d38-1035-11ee-895b-a0510b46b473/3a1e37de-1036-11ee-895b-a0510b46b473.zip','PATIENT_d75719c6-1032-11ee-895b-a0510b46b473_ACT_6897acc6-1035-11ee-895b-a0510b46b473_SESS_689aa1f3-1035-11ee-895b-a0510b46b473_TOSC_ffed3d38-1035-11ee-895b-a0510b46b473_MODEL','3a1e37de-1036-11ee-895b-a0510b46b473.zip','3a1e37de-1036-11ee-895b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.16.2.1.3\",\"modelMatrix\":\"0.610714,0.720837,-0.327753,0,-0.791851,0.555945,-0.252779,0,1.66773e-08,0.413908,0.910319,0,-27.0015,-15.4035,-6.60301,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-21 15:19:18.440','2023-06-21 13:19:19.034',NULL),('3a1f6fba-1036-11ee-895b-a0510b46b473',11,'/home/scan/.data//2023/11/d75719c6-1032-11ee-895b-a0510b46b473/session_6897acc6-1035-11ee-895b-a0510b46b473/occlusion_689aa1f3-1035-11ee-895b-a0510b46b473/scan_ffed3d38-1035-11ee-895b-a0510b46b473/3a1f6fba-1036-11ee-895b-a0510b46b473.png','PATIENT_d75719c6-1032-11ee-895b-a0510b46b473_ACT_6897acc6-1035-11ee-895b-a0510b46b473_SESS_689aa1f3-1035-11ee-895b-a0510b46b473_TOSC_ffed3d38-1035-11ee-895b-a0510b46b473_SNAPS','3a1f6fba-1036-11ee-895b-a0510b46b473.png','3a1f6fba-1036-11ee-895b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.16.2.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-21 15:19:18.448','2023-06-21 13:19:19.037',NULL),('3bcb1a5b-14e4-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_efcc55aa-14e3-11ee-b3b1-00d86184ce3d/occlusion_efcf357e-14e3-11ee-b3b1-00d86184ce3d/scan_f0e2a1e4-14e3-11ee-b3b1-00d86184ce3d/3bcb1a5b-14e4-11ee-b3b1-00d86184ce3d.zip','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_efcc55aa-14e3-11ee-b3b1-00d86184ce3d_SESS_efcf357e-14e3-11ee-b3b1-00d86184ce3d_TOSC_f0e2a1e4-14e3-11ee-b3b1-00d86184ce3d_MODEL','3bcb1a5b-14e4-11ee-b3b1-00d86184ce3d.zip','3bcb1a5b-14e4-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.20.3.1.1\",\"modelMatrix\":\"0.32023,0.931217,-0.174034,0,-0.94734,0.31478,-0.0588289,0,-1.12162e-09,0.183708,0.982981,0,-28.9872,-12.0301,-9.21019,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-27 14:14:58.333','2023-06-27 12:15:01.107',NULL),('3bcc5d28-14e4-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_efcc55aa-14e3-11ee-b3b1-00d86184ce3d/occlusion_efcf357e-14e3-11ee-b3b1-00d86184ce3d/scan_f0e2a1e4-14e3-11ee-b3b1-00d86184ce3d/3bcc5d28-14e4-11ee-b3b1-00d86184ce3d.png','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_efcc55aa-14e3-11ee-b3b1-00d86184ce3d_SESS_efcf357e-14e3-11ee-b3b1-00d86184ce3d_TOSC_f0e2a1e4-14e3-11ee-b3b1-00d86184ce3d_SNAPS','3bcc5d28-14e4-11ee-b3b1-00d86184ce3d.png','3bcc5d28-14e4-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.20.3.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-27 14:14:58.341','2023-06-27 12:15:01.108',NULL),('3bfab95f-270b-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_c28d11f3-2706-11ee-a98e-a0510b46b473/occlusion_c2900beb-2706-11ee-a98e-a0510b46b473/scan_dfcd9da4-270a-11ee-a98e-a0510b46b473/3bfab95f-270b-11ee-a98e-a0510b46b473.zip','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_c28d11f3-2706-11ee-a98e-a0510b46b473_SESS_c2900beb-2706-11ee-a98e-a0510b46b473_TOSC_dfcd9da4-270a-11ee-a98e-a0510b46b473_MODEL','3bfab95f-270b-11ee-a98e-a0510b46b473.zip','3bfab95f-270b-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.3.1.7\",\"modelMatrix\":\"-0.37376,0.918463,-0.129342,0,-0.927525,-0.370108,0.0521203,0,-5.55967e-09,0.139449,0.990229,0,-14.8543,-32.3928,-8.34286,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-20 16:39:29.947','2023-07-20 14:39:30.676',NULL),('3bfad0a2-270b-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_c28d11f3-2706-11ee-a98e-a0510b46b473/occlusion_c2900beb-2706-11ee-a98e-a0510b46b473/scan_dfcd9da4-270a-11ee-a98e-a0510b46b473/3bfad0a2-270b-11ee-a98e-a0510b46b473.png','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_c28d11f3-2706-11ee-a98e-a0510b46b473_SESS_c2900beb-2706-11ee-a98e-a0510b46b473_TOSC_dfcd9da4-270a-11ee-a98e-a0510b46b473_SNAPS','3bfad0a2-270b-11ee-a98e-a0510b46b473.png','3bfad0a2-270b-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.3.1.7 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-20 16:39:29.948','2023-07-20 14:39:30.677',NULL),('3c82c6be-1109-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_ceaea325-1107-11ee-b636-a0510b46b473/occlusion_ceb199a7-1107-11ee-b636-a0510b46b473/scan_02397992-1109-11ee-b636-a0510b46b473/3c82c6be-1109-11ee-b636-a0510b46b473.zip','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_ceaea325-1107-11ee-b636-a0510b46b473_SESS_ceb199a7-1107-11ee-b636-a0510b46b473_TOSC_02397992-1109-11ee-b636-a0510b46b473_MODEL','3c82c6be-1109-11ee-b636-a0510b46b473.zip','3c82c6be-1109-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.20.2.1.5\",\"modelMatrix\":\"0.99766,-0.065855,0.0183922,0,0.0683751,0.960889,-0.26836,0,-4.90609e-10,0.26899,0.963143,0,-29.5332,17.621,-20.2618,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 16:29:46.264','2023-06-22 14:29:46.757',NULL),('3c82dd77-1109-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_ceaea325-1107-11ee-b636-a0510b46b473/occlusion_ceb199a7-1107-11ee-b636-a0510b46b473/scan_02397992-1109-11ee-b636-a0510b46b473/3c82dd77-1109-11ee-b636-a0510b46b473.png','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_ceaea325-1107-11ee-b636-a0510b46b473_SESS_ceb199a7-1107-11ee-b636-a0510b46b473_TOSC_02397992-1109-11ee-b636-a0510b46b473_SNAPS','3c82dd77-1109-11ee-b636-a0510b46b473.png','3c82dd77-1109-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.20.2.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 16:29:46.265','2023-06-22 14:29:46.758',NULL),('3cf8e681-26e5-11ee-a836-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_d5ef2d6b-26e3-11ee-a836-a0510b46b473/occlusion_d5f241c9-26e3-11ee-a836-a0510b46b473/scan_de63c11d-26e4-11ee-a836-a0510b46b473/3cf8e681-26e5-11ee-a836-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_d5ef2d6b-26e3-11ee-a836-a0510b46b473_SESS_d5f241c9-26e3-11ee-a836-a0510b46b473_TOSC_de63c11d-26e4-11ee-a836-a0510b46b473_MODEL','3cf8e681-26e5-11ee-a836-a0510b46b473.zip','3cf8e681-26e5-11ee-a836-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.5.1.4\",\"modelMatrix\":\"-0.0382853,0.975175,-0.218099,0,-0.999267,-0.0373623,0.00835612,0,3.04457e-10,0.218259,0.975891,0,-17.244,-30.0273,-9.72313,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-20 12:07:30.737','2023-07-20 10:07:31.628',NULL),('3cfa2477-26e5-11ee-a836-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_d5ef2d6b-26e3-11ee-a836-a0510b46b473/occlusion_d5f241c9-26e3-11ee-a836-a0510b46b473/scan_de63c11d-26e4-11ee-a836-a0510b46b473/3cfa2477-26e5-11ee-a836-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_d5ef2d6b-26e3-11ee-a836-a0510b46b473_SESS_d5f241c9-26e3-11ee-a836-a0510b46b473_TOSC_de63c11d-26e4-11ee-a836-a0510b46b473_SNAPS','3cfa2477-26e5-11ee-a836-a0510b46b473.png','3cfa2477-26e5-11ee-a836-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.5.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-20 12:07:30.745','2023-07-20 10:07:31.631',NULL),('3d2730e3-2ac5-11ee-80c8-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_3a881645-2abf-11ee-80c8-a0510b46b473/occlusion_3a8b3537-2abf-11ee-80c8-a0510b46b473/scan_02cc4e74-2ac5-11ee-80c8-a0510b46b473/3d2730e3-2ac5-11ee-80c8-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_3a881645-2abf-11ee-80c8-a0510b46b473_SESS_3a8b3537-2abf-11ee-80c8-a0510b46b473_TOSC_02cc4e74-2ac5-11ee-80c8-a0510b46b473_MODEL','3d2730e3-2ac5-11ee-80c8-a0510b46b473.zip','3d2730e3-2ac5-11ee-80c8-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.7.1.14\",\"modelMatrix\":\"0.63926,0.715254,-0.282415,0,-0.768991,0.594589,-0.234771,0,4.15197e-09,0.367255,0.93012,0,-30.9256,-12.8891,-9.66819,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-25 10:28:31.796','2023-07-25 08:28:32.339',NULL),('3d2748d8-2ac5-11ee-80c8-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_3a881645-2abf-11ee-80c8-a0510b46b473/occlusion_3a8b3537-2abf-11ee-80c8-a0510b46b473/scan_02cc4e74-2ac5-11ee-80c8-a0510b46b473/3d2748d8-2ac5-11ee-80c8-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_3a881645-2abf-11ee-80c8-a0510b46b473_SESS_3a8b3537-2abf-11ee-80c8-a0510b46b473_TOSC_02cc4e74-2ac5-11ee-80c8-a0510b46b473_SNAPS','3d2748d8-2ac5-11ee-80c8-a0510b46b473.png','3d2748d8-2ac5-11ee-80c8-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.7.1.14 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-25 10:28:31.797','2023-07-25 08:28:32.342',NULL),('3d965601-e03c-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_6f09f9a8-e03a-11ed-bb13-00d86184ce3d/occlusion_6f0c3cda-e03a-11ed-bb13-00d86184ce3d/scan_28958b14-e03c-11ed-bb13-00d86184ce3d/3d965601-e03c-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_6f09f9a8-e03a-11ed-bb13-00d86184ce3d_SESS_6f0c3cda-e03a-11ed-bb13-00d86184ce3d_TOSC_28958b14-e03c-11ed-bb13-00d86184ce3d_MODEL','3d965601-e03c-11ed-bb13-00d86184ce3d.zip','3d965601-e03c-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.3.1.8\",\"modelMatrix\":\"0.89843,0.349224,-0.266207,0,-0.439117,0.71451,-0.544658,0,-4.55431e-09,0.606233,0.795287,0,-20.8879,-9.26688,-5.08516,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,'2023-04-21 14:03:45.440','2023-04-21 14:01:25.427','2023-04-21 12:03:45.444',NULL),('3d966ba4-e03c-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_6f09f9a8-e03a-11ed-bb13-00d86184ce3d/occlusion_6f0c3cda-e03a-11ed-bb13-00d86184ce3d/scan_28958b14-e03c-11ed-bb13-00d86184ce3d/3d966ba4-e03c-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_6f09f9a8-e03a-11ed-bb13-00d86184ce3d_SESS_6f0c3cda-e03a-11ed-bb13-00d86184ce3d_TOSC_28958b14-e03c-11ed-bb13-00d86184ce3d_SNAPS','3d966ba4-e03c-11ed-bb13-00d86184ce3d.png','3d966ba4-e03c-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.3.1.8 Snapshot\"}','PNG',0,'CREATED',0,'2023-04-21 14:03:45.440','2023-04-21 14:01:25.428','2023-04-21 12:03:45.448',NULL),('3de76b66-1bdb-11ee-9086-a0510b46b473',11,'/home/scan/.data//2023/11/61e16a70-1a76-11ee-8124-a0510b46b473/session_a0a47257-1bd8-11ee-9086-a0510b46b473/occlusion_a0a77bfe-1bd8-11ee-9086-a0510b46b473/scan_bbea6f87-1bda-11ee-9086-a0510b46b473/3de76b66-1bdb-11ee-9086-a0510b46b473.zip','PATIENT_61e16a70-1a76-11ee-8124-a0510b46b473_ACT_a0a47257-1bd8-11ee-9086-a0510b46b473_SESS_a0a77bfe-1bd8-11ee-9086-a0510b46b473_TOSC_bbea6f87-1bda-11ee-9086-a0510b46b473_MODEL','3de76b66-1bdb-11ee-9086-a0510b46b473.zip','3de76b66-1bdb-11ee-9086-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.27.3.1.4\",\"modelMatrix\":\"0.625346,0.778234,-0.0574056,0,-0.780348,0.623651,-0.046003,0,2.57444e-09,0.0735642,0.99729,0,-28.8395,-12.1573,-13.6117,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 10:58:14.542','2023-07-06 08:58:15.100',NULL),('3de77f64-1bdb-11ee-9086-a0510b46b473',11,'/home/scan/.data//2023/11/61e16a70-1a76-11ee-8124-a0510b46b473/session_a0a47257-1bd8-11ee-9086-a0510b46b473/occlusion_a0a77bfe-1bd8-11ee-9086-a0510b46b473/scan_bbea6f87-1bda-11ee-9086-a0510b46b473/3de77f64-1bdb-11ee-9086-a0510b46b473.png','PATIENT_61e16a70-1a76-11ee-8124-a0510b46b473_ACT_a0a47257-1bd8-11ee-9086-a0510b46b473_SESS_a0a77bfe-1bd8-11ee-9086-a0510b46b473_TOSC_bbea6f87-1bda-11ee-9086-a0510b46b473_SNAPS','3de77f64-1bdb-11ee-9086-a0510b46b473.png','3de77f64-1bdb-11ee-9086-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.27.3.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 10:58:14.543','2023-07-06 08:58:15.100',NULL),('3e63bd11-15bf-11ee-a062-a0510b46b473',11,'/home/scan/.data//2023/11/142e7037-15b6-11ee-b3b1-00d86184ce3d/session_c41888b6-15ba-11ee-b3b1-00d86184ce3d/occlusion_c41a4d8e-15ba-11ee-b3b1-00d86184ce3d/scan_0a167497-15bf-11ee-a062-a0510b46b473/3e63bd11-15bf-11ee-a062-a0510b46b473.zip','PATIENT_142e7037-15b6-11ee-b3b1-00d86184ce3d_ACT_c41888b6-15ba-11ee-b3b1-00d86184ce3d_SESS_c41a4d8e-15ba-11ee-b3b1-00d86184ce3d_TOSC_0a167497-15bf-11ee-a062-a0510b46b473_MODEL','3e63bd11-15bf-11ee-a062-a0510b46b473.zip','3e63bd11-15bf-11ee-a062-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.25.2.1.4\",\"modelMatrix\":\"0.851909,0.400451,-0.337476,0,-0.52369,0.651431,-0.548988,0,-9.19333e-09,0.64442,0.764671,0,-27.4588,9.65079,-11.8103,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-28 16:22:42.472','2023-06-28 14:22:42.969',NULL),('3e64fb89-15bf-11ee-a062-a0510b46b473',11,'/home/scan/.data//2023/11/142e7037-15b6-11ee-b3b1-00d86184ce3d/session_c41888b6-15ba-11ee-b3b1-00d86184ce3d/occlusion_c41a4d8e-15ba-11ee-b3b1-00d86184ce3d/scan_0a167497-15bf-11ee-a062-a0510b46b473/3e64fb89-15bf-11ee-a062-a0510b46b473.png','PATIENT_142e7037-15b6-11ee-b3b1-00d86184ce3d_ACT_c41888b6-15ba-11ee-b3b1-00d86184ce3d_SESS_c41a4d8e-15ba-11ee-b3b1-00d86184ce3d_TOSC_0a167497-15bf-11ee-a062-a0510b46b473_SNAPS','3e64fb89-15bf-11ee-a062-a0510b46b473.png','3e64fb89-15bf-11ee-a062-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.25.2.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-28 16:22:42.480','2023-06-28 14:22:42.973',NULL),('3e751133-1107-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_0628a8e9-1104-11ee-b636-a0510b46b473/occlusion_062b833f-1104-11ee-b636-a0510b46b473/scan_edd739be-1106-11ee-b636-a0510b46b473/3e751133-1107-11ee-b636-a0510b46b473.zip','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_0628a8e9-1104-11ee-b636-a0510b46b473_SESS_062b833f-1104-11ee-b636-a0510b46b473_TOSC_edd739be-1106-11ee-b636-a0510b46b473_MODEL','3e751133-1107-11ee-b636-a0510b46b473.zip','3e751133-1107-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.20.1.1.7\",\"modelMatrix\":\"0.398769,0.888236,-0.228081,0,-0.917051,0.386239,-0.0991782,0,2.77283e-09,0.248711,0.968578,0,-25.6659,-16.3907,-8.9617,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 16:15:30.536','2023-06-22 14:15:31.231',NULL),('3e75262a-1107-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_0628a8e9-1104-11ee-b636-a0510b46b473/occlusion_062b833f-1104-11ee-b636-a0510b46b473/scan_edd739be-1106-11ee-b636-a0510b46b473/3e75262a-1107-11ee-b636-a0510b46b473.png','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_0628a8e9-1104-11ee-b636-a0510b46b473_SESS_062b833f-1104-11ee-b636-a0510b46b473_TOSC_edd739be-1106-11ee-b636-a0510b46b473_SNAPS','3e75262a-1107-11ee-b636-a0510b46b473.png','3e75262a-1107-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.20.1.1.7 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 16:15:30.537','2023-06-22 14:15:31.231',NULL),('3e846529-26e1-11ee-a836-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_78d129fc-26e0-11ee-a836-a0510b46b473/occlusion_78d4144f-26e0-11ee-a836-a0510b46b473/scan_ed00995f-26e0-11ee-a836-a0510b46b473/3e846529-26e1-11ee-a836-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_78d129fc-26e0-11ee-a836-a0510b46b473_SESS_78d4144f-26e0-11ee-a836-a0510b46b473_TOSC_ed00995f-26e0-11ee-a836-a0510b46b473_MODEL','3e846529-26e1-11ee-a836-a0510b46b473.zip','3e846529-26e1-11ee-a836-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.4.1.2\",\"modelMatrix\":\"-0.0334954,0.982104,-0.185337,0,-0.999439,-0.0329144,0.00621142,0,-2.37836e-10,0.185441,0.982655,0,-12.4762,-31.424,-10.352,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-20 11:38:55.342','2023-07-20 09:38:56.098',NULL),('3e85c04b-26e1-11ee-a836-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_78d129fc-26e0-11ee-a836-a0510b46b473/occlusion_78d4144f-26e0-11ee-a836-a0510b46b473/scan_ed00995f-26e0-11ee-a836-a0510b46b473/3e85c04b-26e1-11ee-a836-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_78d129fc-26e0-11ee-a836-a0510b46b473_SESS_78d4144f-26e0-11ee-a836-a0510b46b473_TOSC_ed00995f-26e0-11ee-a836-a0510b46b473_SNAPS','3e85c04b-26e1-11ee-a836-a0510b46b473.png','3e85c04b-26e1-11ee-a836-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.4.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-20 11:38:55.351','2023-07-20 09:38:56.101',NULL),('3f48951b-10f9-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/ed94fe78-10f4-11ee-b636-a0510b46b473/session_f8ef8fe7-10f4-11ee-b636-a0510b46b473/occlusion_f8f2e241-10f4-11ee-b636-a0510b46b473/scan_e06072eb-10f8-11ee-b636-a0510b46b473/3f48951b-10f9-11ee-b636-a0510b46b473.zip','PATIENT_ed94fe78-10f4-11ee-b636-a0510b46b473_ACT_f8ef8fe7-10f4-11ee-b636-a0510b46b473_SESS_f8f2e241-10f4-11ee-b636-a0510b46b473_TOSC_e06072eb-10f8-11ee-b636-a0510b46b473_MODEL','3f48951b-10f9-11ee-b636-a0510b46b473.zip','3f48951b-10f9-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.19.1.1.2\",\"modelMatrix\":\"0.629569,0.761667,-0.153317,0,-0.776945,0.617189,-0.124235,0,5.17533e-09,0.197334,0.980336,0,-32.5489,-10.3747,-9.80647,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 14:35:18.968','2023-06-22 12:35:19.802',NULL),('3f48ad17-10f9-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/ed94fe78-10f4-11ee-b636-a0510b46b473/session_f8ef8fe7-10f4-11ee-b636-a0510b46b473/occlusion_f8f2e241-10f4-11ee-b636-a0510b46b473/scan_e06072eb-10f8-11ee-b636-a0510b46b473/3f48ad17-10f9-11ee-b636-a0510b46b473.png','PATIENT_ed94fe78-10f4-11ee-b636-a0510b46b473_ACT_f8ef8fe7-10f4-11ee-b636-a0510b46b473_SESS_f8f2e241-10f4-11ee-b636-a0510b46b473_TOSC_e06072eb-10f8-11ee-b636-a0510b46b473_SNAPS','3f48ad17-10f9-11ee-b636-a0510b46b473.png','3f48ad17-10f9-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.19.1.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 14:35:18.969','2023-06-22 12:35:19.802',NULL),('3fc34950-df7e-11ed-b6c2-00d86184ce3d',11,'/home/scan/.data//2023/11/e0d449f3-dde9-11ed-aa56-00d86184ce3d/session_858fcc60-de94-11ed-9cc3-00d86184ce3d/occlusion_85925fd9-de94-11ed-9cc3-00d86184ce3d/scan_03994d09-df7e-11ed-b6c2-00d86184ce3d/3fc34950-df7e-11ed-b6c2-00d86184ce3d.zip','PATIENT_e0d449f3-dde9-11ed-aa56-00d86184ce3d_ACT_858fcc60-de94-11ed-9cc3-00d86184ce3d_SESS_85925fd9-de94-11ed-9cc3-00d86184ce3d_TOSC_03994d09-df7e-11ed-b6c2-00d86184ce3d_MODEL','3fc34950-df7e-11ed-b6c2-00d86184ce3d.zip','3fc34950-df7e-11ed-b6c2-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.2.1.1.4\",\"modelMatrix\":\"-0.777432,-0.566812,0.272624,0,0.628967,-0.700605,0.336976,0,-4.61498e-11,0.433447,0.901179,0,3.50324,0.917572,-10.0201,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-20 15:21:24.699','2023-04-20 13:21:24.858',NULL),('3fc35b90-df7e-11ed-b6c2-00d86184ce3d',11,'/home/scan/.data//2023/11/e0d449f3-dde9-11ed-aa56-00d86184ce3d/session_858fcc60-de94-11ed-9cc3-00d86184ce3d/occlusion_85925fd9-de94-11ed-9cc3-00d86184ce3d/scan_03994d09-df7e-11ed-b6c2-00d86184ce3d/3fc35b90-df7e-11ed-b6c2-00d86184ce3d.png','PATIENT_e0d449f3-dde9-11ed-aa56-00d86184ce3d_ACT_858fcc60-de94-11ed-9cc3-00d86184ce3d_SESS_85925fd9-de94-11ed-9cc3-00d86184ce3d_TOSC_03994d09-df7e-11ed-b6c2-00d86184ce3d_SNAPS','3fc35b90-df7e-11ed-b6c2-00d86184ce3d.png','3fc35b90-df7e-11ed-b6c2-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.2.1.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-20 15:21:24.699','2023-04-20 13:21:24.859',NULL),('405b2d0c-0f73-11ee-8712-a0510b46b473',11,'/home/scan/.data//2023/11/e4b67639-0f72-11ee-8712-a0510b46b473/session_ec7935d6-0f72-11ee-8712-a0510b46b473/occlusion_ec7bd8ad-0f72-11ee-8712-a0510b46b473/scan_f3727a95-0f72-11ee-8712-a0510b46b473/405b2d0c-0f73-11ee-8712-a0510b46b473.zip','PATIENT_e4b67639-0f72-11ee-8712-a0510b46b473_ACT_ec7935d6-0f72-11ee-8712-a0510b46b473_SESS_ec7bd8ad-0f72-11ee-8712-a0510b46b473_TOSC_f3727a95-0f72-11ee-8712-a0510b46b473_MODEL','405b2d0c-0f73-11ee-8712-a0510b46b473.zip','405b2d0c-0f73-11ee-8712-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.15.1.1.1\",\"modelMatrix\":\"1,0,0,0,0,-1,0,0,0,0,-1,0,14.0924,-0.873093,23.8801,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-20 16:03:37.043','2023-06-20 14:03:37.274',NULL),('405b43ca-0f73-11ee-8712-a0510b46b473',11,'/home/scan/.data//2023/11/e4b67639-0f72-11ee-8712-a0510b46b473/session_ec7935d6-0f72-11ee-8712-a0510b46b473/occlusion_ec7bd8ad-0f72-11ee-8712-a0510b46b473/scan_f3727a95-0f72-11ee-8712-a0510b46b473/405b43ca-0f73-11ee-8712-a0510b46b473.png','PATIENT_e4b67639-0f72-11ee-8712-a0510b46b473_ACT_ec7935d6-0f72-11ee-8712-a0510b46b473_SESS_ec7bd8ad-0f72-11ee-8712-a0510b46b473_TOSC_f3727a95-0f72-11ee-8712-a0510b46b473_SNAPS','405b43ca-0f73-11ee-8712-a0510b46b473.png','405b43ca-0f73-11ee-8712-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.15.1.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-20 16:03:37.044','2023-06-20 14:03:37.275',NULL),('41055b5c-14c9-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/9619fcac-14c3-11ee-b3b1-00d86184ce3d/session_961b9a11-14c3-11ee-b3b1-00d86184ce3d/occlusion_961d56b4-14c3-11ee-b3b1-00d86184ce3d/scan_e8ba80a6-14c8-11ee-b3b1-00d86184ce3d/41055b5c-14c9-11ee-b3b1-00d86184ce3d.zip','PATIENT_9619fcac-14c3-11ee-b3b1-00d86184ce3d_ACT_961b9a11-14c3-11ee-b3b1-00d86184ce3d_SESS_961d56b4-14c3-11ee-b3b1-00d86184ce3d_TOSC_e8ba80a6-14c8-11ee-b3b1-00d86184ce3d_MODEL','41055b5c-14c9-11ee-b3b1-00d86184ce3d.zip','41055b5c-14c9-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.22.1.1.6\",\"modelMatrix\":\"-0.16442,0.969009,-0.18436,0,-0.98639,-0.161523,0.0307307,0,-2.39296e-09,0.186903,0.982378,0,-11.6055,-30.4509,-9.35657,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-27 11:01:50.691','2023-06-27 09:01:51.467',NULL),('41057027-14c9-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/9619fcac-14c3-11ee-b3b1-00d86184ce3d/session_961b9a11-14c3-11ee-b3b1-00d86184ce3d/occlusion_961d56b4-14c3-11ee-b3b1-00d86184ce3d/scan_e8ba80a6-14c8-11ee-b3b1-00d86184ce3d/41057027-14c9-11ee-b3b1-00d86184ce3d.png','PATIENT_9619fcac-14c3-11ee-b3b1-00d86184ce3d_ACT_961b9a11-14c3-11ee-b3b1-00d86184ce3d_SESS_961d56b4-14c3-11ee-b3b1-00d86184ce3d_TOSC_e8ba80a6-14c8-11ee-b3b1-00d86184ce3d_SNAPS','41057027-14c9-11ee-b3b1-00d86184ce3d.png','41057027-14c9-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.22.1.1.6 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-27 11:01:50.692','2023-06-27 09:01:51.470',NULL),('417b44d6-e03a-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_63b81b7e-e035-11ed-bb13-00d86184ce3d/occlusion_63bb1989-e035-11ed-bb13-00d86184ce3d/scan_265e16be-e03a-11ed-bb13-00d86184ce3d/417b44d6-e03a-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_63b81b7e-e035-11ed-bb13-00d86184ce3d_SESS_63bb1989-e035-11ed-bb13-00d86184ce3d_TOSC_265e16be-e03a-11ed-bb13-00d86184ce3d_MODEL','417b44d6-e03a-11ed-bb13-00d86184ce3d.zip','417b44d6-e03a-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.2.1.9\",\"modelMatrix\":\"0.920771,0.303491,-0.245099,0,-0.390103,0.716338,-0.578514,0,-2.04399e-08,0.628293,0.777977,0,-11.4588,-6.41091,-7.4849,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 13:47:12.967','2023-04-21 11:47:13.274',NULL),('417b5bcd-e03a-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_63b81b7e-e035-11ed-bb13-00d86184ce3d/occlusion_63bb1989-e035-11ed-bb13-00d86184ce3d/scan_265e16be-e03a-11ed-bb13-00d86184ce3d/417b5bcd-e03a-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_63b81b7e-e035-11ed-bb13-00d86184ce3d_SESS_63bb1989-e035-11ed-bb13-00d86184ce3d_TOSC_265e16be-e03a-11ed-bb13-00d86184ce3d_SNAPS','417b5bcd-e03a-11ed-bb13-00d86184ce3d.png','417b5bcd-e03a-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.2.1.9 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 13:47:12.968','2023-04-21 11:47:13.274',NULL),('41e1090f-10e2-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/2ff330cd-10e1-11ee-b636-a0510b46b473/session_3adeac35-10e1-11ee-b636-a0510b46b473/occlusion_3ae23ec4-10e1-11ee-b636-a0510b46b473/scan_f7b1fc74-10e1-11ee-b636-a0510b46b473/41e1090f-10e2-11ee-b636-a0510b46b473.zip','PATIENT_2ff330cd-10e1-11ee-b636-a0510b46b473_ACT_3adeac35-10e1-11ee-b636-a0510b46b473_SESS_3ae23ec4-10e1-11ee-b636-a0510b46b473_TOSC_f7b1fc74-10e1-11ee-b636-a0510b46b473_MODEL','41e1090f-10e2-11ee-b636-a0510b46b473.zip','41e1090f-10e2-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.18.1.1.3\",\"modelMatrix\":\"0.337586,0.905986,-0.255392,0,-0.941294,0.324923,-0.0915941,0,-1.19236e-10,0.27132,0.962489,0,-26.1641,-19.9205,-8.35442,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 11:50:44.898','2023-06-22 09:50:45.565',NULL),('41e1208a-10e2-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/2ff330cd-10e1-11ee-b636-a0510b46b473/session_3adeac35-10e1-11ee-b636-a0510b46b473/occlusion_3ae23ec4-10e1-11ee-b636-a0510b46b473/scan_f7b1fc74-10e1-11ee-b636-a0510b46b473/41e1208a-10e2-11ee-b636-a0510b46b473.png','PATIENT_2ff330cd-10e1-11ee-b636-a0510b46b473_ACT_3adeac35-10e1-11ee-b636-a0510b46b473_SESS_3ae23ec4-10e1-11ee-b636-a0510b46b473_TOSC_f7b1fc74-10e1-11ee-b636-a0510b46b473_SNAPS','41e1208a-10e2-11ee-b636-a0510b46b473.png','41e1208a-10e2-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.18.1.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 11:50:44.899','2023-06-22 09:50:45.573',NULL),('42658986-deb5-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/cf3f0588-deb2-11ed-9cc3-00d86184ce3d/session_d7750b8d-deb2-11ed-9cc3-00d86184ce3d/occlusion_d7775a50-deb2-11ed-9cc3-00d86184ce3d/scan_e3f8a959-deb4-11ed-9cc3-00d86184ce3d/42658986-deb5-11ed-9cc3-00d86184ce3d.zip','PATIENT_cf3f0588-deb2-11ed-9cc3-00d86184ce3d_ACT_d7750b8d-deb2-11ed-9cc3-00d86184ce3d_SESS_d7775a50-deb2-11ed-9cc3-00d86184ce3d_TOSC_e3f8a959-deb4-11ed-9cc3-00d86184ce3d_MODEL','42658986-deb5-11ed-9cc3-00d86184ce3d.zip','42658986-deb5-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.6.1.1.5\",\"modelMatrix\":\"0.322916,0.916002,-0.238045,0,-0.946428,0.312535,-0.0812197,0,3.59516e-09,0.25152,0.967852,0,-24.0767,-19.8341,-6.33072,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-19 15:22:40.275','2023-04-19 13:22:41.376',NULL),('4265a1e2-deb5-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/cf3f0588-deb2-11ed-9cc3-00d86184ce3d/session_d7750b8d-deb2-11ed-9cc3-00d86184ce3d/occlusion_d7775a50-deb2-11ed-9cc3-00d86184ce3d/scan_e3f8a959-deb4-11ed-9cc3-00d86184ce3d/4265a1e2-deb5-11ed-9cc3-00d86184ce3d.png','PATIENT_cf3f0588-deb2-11ed-9cc3-00d86184ce3d_ACT_d7750b8d-deb2-11ed-9cc3-00d86184ce3d_SESS_d7775a50-deb2-11ed-9cc3-00d86184ce3d_TOSC_e3f8a959-deb4-11ed-9cc3-00d86184ce3d_SNAPS','4265a1e2-deb5-11ed-9cc3-00d86184ce3d.png','4265a1e2-deb5-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.6.1.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-19 15:22:40.275','2023-04-19 13:22:41.384',NULL),('42e15821-1a71-11ee-acb0-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_77df3b68-1a6c-11ee-af16-a0510b46b473/occlusion_77e234a6-1a6c-11ee-af16-a0510b46b473/scan_f0010098-1a70-11ee-acb0-a0510b46b473/42e15821-1a71-11ee-acb0-a0510b46b473.zip','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_77df3b68-1a6c-11ee-af16-a0510b46b473_SESS_77e234a6-1a6c-11ee-af16-a0510b46b473_TOSC_f0010098-1a70-11ee-acb0-a0510b46b473_MODEL','42e15821-1a71-11ee-acb0-a0510b46b473.zip','42e15821-1a71-11ee-acb0-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.4.1.3\",\"modelMatrix\":\"0.28553,0.946195,-0.152275,0,-0.95837,0.281902,-0.0453679,0,-1.47661e-09,0.15889,0.987296,0,-27.3864,-18.262,-9.28592,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-04 15:47:05.075','2023-07-04 13:47:05.806',NULL),('42e2a1f3-1a71-11ee-acb0-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_77df3b68-1a6c-11ee-af16-a0510b46b473/occlusion_77e234a6-1a6c-11ee-af16-a0510b46b473/scan_f0010098-1a70-11ee-acb0-a0510b46b473/42e2a1f3-1a71-11ee-acb0-a0510b46b473.png','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_77df3b68-1a6c-11ee-af16-a0510b46b473_SESS_77e234a6-1a6c-11ee-af16-a0510b46b473_TOSC_f0010098-1a70-11ee-acb0-a0510b46b473_SNAPS','42e2a1f3-1a71-11ee-acb0-a0510b46b473.png','42e2a1f3-1a71-11ee-acb0-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.4.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-04 15:47:05.084','2023-07-04 13:47:05.807',NULL),('43836ad9-2578-11ee-b81b-a0510b46b473',11,'/home/scan/.data//2023/11/49f1e276-256f-11ee-91d6-a0510b46b473/session_f58279e9-2576-11ee-b81b-a0510b46b473/occlusion_f584e68a-2576-11ee-b81b-a0510b46b473/scan_f9322c32-2577-11ee-b81b-a0510b46b473/43836ad9-2578-11ee-b81b-a0510b46b473.zip','PATIENT_49f1e276-256f-11ee-91d6-a0510b46b473_ACT_f58279e9-2576-11ee-b81b-a0510b46b473_SESS_f584e68a-2576-11ee-b81b-a0510b46b473_TOSC_f9322c32-2577-11ee-b81b-a0510b46b473_MODEL','43836ad9-2578-11ee-b81b-a0510b46b473.zip','43836ad9-2578-11ee-b81b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.33.2.1.2\",\"modelMatrix\":\"0.986023,-0.16267,0.0360278,0,0.166612,0.962694,-0.213216,0,2.24281e-09,0.216238,0.976341,0,-13.3656,13.2155,-18.8813,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-18 16:34:55.405','2023-07-18 14:34:55.602',NULL),('43838204-2578-11ee-b81b-a0510b46b473',11,'/home/scan/.data//2023/11/49f1e276-256f-11ee-91d6-a0510b46b473/session_f58279e9-2576-11ee-b81b-a0510b46b473/occlusion_f584e68a-2576-11ee-b81b-a0510b46b473/scan_f9322c32-2577-11ee-b81b-a0510b46b473/43838204-2578-11ee-b81b-a0510b46b473.png','PATIENT_49f1e276-256f-11ee-91d6-a0510b46b473_ACT_f58279e9-2576-11ee-b81b-a0510b46b473_SESS_f584e68a-2576-11ee-b81b-a0510b46b473_TOSC_f9322c32-2577-11ee-b81b-a0510b46b473_SNAPS','43838204-2578-11ee-b81b-a0510b46b473.png','43838204-2578-11ee-b81b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.33.2.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-18 16:34:55.405','2023-07-18 14:34:55.603',NULL),('43c50d2d-270a-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_c28d11f3-2706-11ee-a98e-a0510b46b473/occlusion_c2900beb-2706-11ee-a98e-a0510b46b473/scan_bf77bf9e-2709-11ee-a98e-a0510b46b473/43c50d2d-270a-11ee-a98e-a0510b46b473.zip','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_c28d11f3-2706-11ee-a98e-a0510b46b473_SESS_c2900beb-2706-11ee-a98e-a0510b46b473_TOSC_bf77bf9e-2709-11ee-a98e-a0510b46b473_MODEL','43c50d2d-270a-11ee-a98e-a0510b46b473.zip','43c50d2d-270a-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.3.1.5\",\"modelMatrix\":\"0.316351,0.945329,-0.0792136,0,-0.948642,0.315246,-0.0264159,0,1.10634e-09,0.083502,0.996508,0,-21.0936,-13.9012,-13.3811,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-20 16:32:33.520','2023-07-20 14:32:34.395',NULL),('43c5258d-270a-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_c28d11f3-2706-11ee-a98e-a0510b46b473/occlusion_c2900beb-2706-11ee-a98e-a0510b46b473/scan_bf77bf9e-2709-11ee-a98e-a0510b46b473/43c5258d-270a-11ee-a98e-a0510b46b473.png','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_c28d11f3-2706-11ee-a98e-a0510b46b473_SESS_c2900beb-2706-11ee-a98e-a0510b46b473_TOSC_bf77bf9e-2709-11ee-a98e-a0510b46b473_SNAPS','43c5258d-270a-11ee-a98e-a0510b46b473.png','43c5258d-270a-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.3.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-20 16:32:33.521','2023-07-20 14:32:34.395',NULL),('43cf087a-1c09-11ee-a865-a0510b46b473',11,'/home/scan/.data//2023/11/ae8bd11e-1c05-11ee-9323-a0510b46b473/session_bb436bde-1c05-11ee-9323-a0510b46b473/occlusion_bb465a1e-1c05-11ee-9323-a0510b46b473/scan_efd84226-1c08-11ee-a865-a0510b46b473/43cf087a-1c09-11ee-a865-a0510b46b473.zip','PATIENT_ae8bd11e-1c05-11ee-9323-a0510b46b473_ACT_bb436bde-1c05-11ee-9323-a0510b46b473_SESS_bb465a1e-1c05-11ee-9323-a0510b46b473_TOSC_efd84226-1c08-11ee-a865-a0510b46b473_MODEL','43cf087a-1c09-11ee-a865-a0510b46b473.zip','43cf087a-1c09-11ee-a865-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.29.1.1.9\",\"modelMatrix\":\"0.284052,0.93553,-0.209997,0,-0.958809,0.277155,-0.0622125,0,9.40555e-09,0.219018,0.975721,0,-30.0252,-14.4981,-9.06948,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 16:27:41.299','2023-07-06 14:27:42.085',NULL),('43cf2e8c-1c09-11ee-a865-a0510b46b473',11,'/home/scan/.data//2023/11/ae8bd11e-1c05-11ee-9323-a0510b46b473/session_bb436bde-1c05-11ee-9323-a0510b46b473/occlusion_bb465a1e-1c05-11ee-9323-a0510b46b473/scan_efd84226-1c08-11ee-a865-a0510b46b473/43cf2e8c-1c09-11ee-a865-a0510b46b473.png','PATIENT_ae8bd11e-1c05-11ee-9323-a0510b46b473_ACT_bb436bde-1c05-11ee-9323-a0510b46b473_SESS_bb465a1e-1c05-11ee-9323-a0510b46b473_TOSC_efd84226-1c08-11ee-a865-a0510b46b473_SNAPS','43cf2e8c-1c09-11ee-a865-a0510b46b473.png','43cf2e8c-1c09-11ee-a865-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.29.1.1.9 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 16:27:41.299','2023-07-06 14:27:42.086',NULL),('4424b120-2703-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/848c86d9-26fd-11ee-a98e-a0510b46b473/session_8f62cd50-26fd-11ee-a98e-a0510b46b473/occlusion_8f65e2e0-26fd-11ee-a98e-a0510b46b473/scan_ba2b24b8-2702-11ee-a98e-a0510b46b473/4424b120-2703-11ee-a98e-a0510b46b473.zip','PATIENT_848c86d9-26fd-11ee-a98e-a0510b46b473_ACT_8f62cd50-26fd-11ee-a98e-a0510b46b473_SESS_8f65e2e0-26fd-11ee-a98e-a0510b46b473_TOSC_ba2b24b8-2702-11ee-a98e-a0510b46b473_MODEL','4424b120-2703-11ee-a98e-a0510b46b473.zip','4424b120-2703-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.36.1.1.11\",\"modelMatrix\":\"0.746132,0.639002,-0.186984,0,-0.665797,0.716104,-0.209545,0,3.80972e-09,0.280842,0.959754,0,-10.0291,-29.9696,-10.8939,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-20 15:42:27.670','2023-07-20 13:42:28.815',NULL),('4424c6fd-2703-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/848c86d9-26fd-11ee-a98e-a0510b46b473/session_8f62cd50-26fd-11ee-a98e-a0510b46b473/occlusion_8f65e2e0-26fd-11ee-a98e-a0510b46b473/scan_ba2b24b8-2702-11ee-a98e-a0510b46b473/4424c6fd-2703-11ee-a98e-a0510b46b473.png','PATIENT_848c86d9-26fd-11ee-a98e-a0510b46b473_ACT_8f62cd50-26fd-11ee-a98e-a0510b46b473_SESS_8f65e2e0-26fd-11ee-a98e-a0510b46b473_TOSC_ba2b24b8-2702-11ee-a98e-a0510b46b473_SNAPS','4424c6fd-2703-11ee-a98e-a0510b46b473.png','4424c6fd-2703-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.36.1.1.11 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-20 15:42:27.671','2023-07-20 13:42:28.824',NULL),('44438559-1108-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_ceaea325-1107-11ee-b636-a0510b46b473/occlusion_ceb199a7-1107-11ee-b636-a0510b46b473/scan_089921e4-1108-11ee-b636-a0510b46b473/44438559-1108-11ee-b636-a0510b46b473.zip','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_ceaea325-1107-11ee-b636-a0510b46b473_SESS_ceb199a7-1107-11ee-b636-a0510b46b473_TOSC_089921e4-1108-11ee-b636-a0510b46b473_MODEL','44438559-1108-11ee-b636-a0510b46b473.zip','44438559-1108-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.20.2.1.2\",\"modelMatrix\":\"0.679431,0.600891,-0.421074,0,-0.733739,0.556416,-0.389909,0,8.33128e-09,0.573875,0.818943,0,-28.5507,-1.59316,-5.3689,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 16:22:49.775','2023-06-22 14:22:50.355',NULL),('44439cdb-1108-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_ceaea325-1107-11ee-b636-a0510b46b473/occlusion_ceb199a7-1107-11ee-b636-a0510b46b473/scan_089921e4-1108-11ee-b636-a0510b46b473/44439cdb-1108-11ee-b636-a0510b46b473.png','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_ceaea325-1107-11ee-b636-a0510b46b473_SESS_ceb199a7-1107-11ee-b636-a0510b46b473_TOSC_089921e4-1108-11ee-b636-a0510b46b473_SNAPS','44439cdb-1108-11ee-b636-a0510b46b473.png','44439cdb-1108-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.20.2.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 16:22:49.775','2023-06-22 14:22:50.356',NULL),('44466f03-2707-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_c28d11f3-2706-11ee-a98e-a0510b46b473/occlusion_c2900beb-2706-11ee-a98e-a0510b46b473/scan_c3c056fb-2706-11ee-a98e-a0510b46b473/44466f03-2707-11ee-a98e-a0510b46b473.zip','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_c28d11f3-2706-11ee-a98e-a0510b46b473_SESS_c2900beb-2706-11ee-a98e-a0510b46b473_TOSC_c3c056fb-2706-11ee-a98e-a0510b46b473_MODEL','44466f03-2707-11ee-a98e-a0510b46b473.zip','44466f03-2707-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.3.1.1\",\"modelMatrix\":\"0.686011,0.707553,-0.169581,0,-0.727591,0.667118,-0.159889,0,-1.26959e-08,0.233071,0.97246,0,0.922362,-34.0353,-9.14215,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-20 16:11:05.878','2023-07-20 14:11:06.859',NULL),('444689b1-2707-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_c28d11f3-2706-11ee-a98e-a0510b46b473/occlusion_c2900beb-2706-11ee-a98e-a0510b46b473/scan_c3c056fb-2706-11ee-a98e-a0510b46b473/444689b1-2707-11ee-a98e-a0510b46b473.png','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_c28d11f3-2706-11ee-a98e-a0510b46b473_SESS_c2900beb-2706-11ee-a98e-a0510b46b473_TOSC_c3c056fb-2706-11ee-a98e-a0510b46b473_SNAPS','444689b1-2707-11ee-a98e-a0510b46b473.png','444689b1-2707-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.3.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-20 16:11:05.879','2023-07-20 14:11:06.860',NULL),('44afed49-e043-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_5a5a69f7-e042-11ed-bb13-00d86184ce3d/occlusion_5a5d89b2-e042-11ed-bb13-00d86184ce3d/scan_f9fc2004-e042-11ed-bb13-00d86184ce3d/44afed49-e043-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_5a5a69f7-e042-11ed-bb13-00d86184ce3d_SESS_5a5d89b2-e042-11ed-bb13-00d86184ce3d_TOSC_f9fc2004-e042-11ed-bb13-00d86184ce3d_MODEL','44afed49-e043-11ed-bb13-00d86184ce3d.zip','44afed49-e043-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.5.1.2\",\"modelMatrix\":\"0.490456,0.835805,-0.246746,0,-0.871466,0.470386,-0.138867,0,-7.83748e-09,0.283139,0.959079,0,-29.9353,-12.8337,-6.77052,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,'2023-04-21 14:52:09.801','2023-04-21 14:51:43.816','2023-04-21 12:52:09.805',NULL),('44b005ef-e043-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_5a5a69f7-e042-11ed-bb13-00d86184ce3d/occlusion_5a5d89b2-e042-11ed-bb13-00d86184ce3d/scan_f9fc2004-e042-11ed-bb13-00d86184ce3d/44b005ef-e043-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_5a5a69f7-e042-11ed-bb13-00d86184ce3d_SESS_5a5d89b2-e042-11ed-bb13-00d86184ce3d_TOSC_f9fc2004-e042-11ed-bb13-00d86184ce3d_SNAPS','44b005ef-e043-11ed-bb13-00d86184ce3d.png','44b005ef-e043-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.5.1.2 Snapshot\"}','PNG',0,'CREATED',0,'2023-04-21 14:52:09.801','2023-04-21 14:51:43.817','2023-04-21 12:52:09.808',NULL),('458c7af6-0f42-11ee-8712-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_55019e04-0f41-11ee-8712-a0510b46b473/occlusion_550492f3-0f41-11ee-8712-a0510b46b473/scan_0655838d-0f42-11ee-8712-a0510b46b473/458c7af6-0f42-11ee-8712-a0510b46b473.zip','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_55019e04-0f41-11ee-8712-a0510b46b473_SESS_550492f3-0f41-11ee-8712-a0510b46b473_TOSC_0655838d-0f42-11ee-8712-a0510b46b473_MODEL','458c7af6-0f42-11ee-8712-a0510b46b473.zip','458c7af6-0f42-11ee-8712-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.2.1.3\",\"modelMatrix\":\"0.00261628,0.970611,-0.240639,0,-0.999997,0.0025394,-0.000629581,0,1.57498e-11,0.24064,0.970614,0,-22.6879,-26.0466,-6.86408,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-20 10:13:00.415','2023-06-20 08:13:00.984',NULL),('458c92b8-0f42-11ee-8712-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_55019e04-0f41-11ee-8712-a0510b46b473/occlusion_550492f3-0f41-11ee-8712-a0510b46b473/scan_0655838d-0f42-11ee-8712-a0510b46b473/458c92b8-0f42-11ee-8712-a0510b46b473.png','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_55019e04-0f41-11ee-8712-a0510b46b473_SESS_550492f3-0f41-11ee-8712-a0510b46b473_TOSC_0655838d-0f42-11ee-8712-a0510b46b473_SNAPS','458c92b8-0f42-11ee-8712-a0510b46b473.png','458c92b8-0f42-11ee-8712-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.2.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-20 10:13:00.416','2023-06-20 08:13:00.984',NULL),('459efa6a-2702-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/848c86d9-26fd-11ee-a98e-a0510b46b473/session_8f62cd50-26fd-11ee-a98e-a0510b46b473/occlusion_8f65e2e0-26fd-11ee-a98e-a0510b46b473/scan_f24e833d-2701-11ee-a98e-a0510b46b473/459efa6a-2702-11ee-a98e-a0510b46b473.zip','PATIENT_848c86d9-26fd-11ee-a98e-a0510b46b473_ACT_8f62cd50-26fd-11ee-a98e-a0510b46b473_SESS_8f65e2e0-26fd-11ee-a98e-a0510b46b473_TOSC_f24e833d-2701-11ee-a98e-a0510b46b473_MODEL','459efa6a-2702-11ee-a98e-a0510b46b473.zip','459efa6a-2702-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.36.1.1.10\",\"modelMatrix\":\"0.541844,0.826584,-0.152195,0,-0.840479,0.532886,-0.0981177,0,5.918e-09,0.181081,0.983468,0,-30.6441,-8.81023,-10.7767,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-20 15:35:20.652','2023-07-20 13:35:21.370',NULL),('459f10c1-2702-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/848c86d9-26fd-11ee-a98e-a0510b46b473/session_8f62cd50-26fd-11ee-a98e-a0510b46b473/occlusion_8f65e2e0-26fd-11ee-a98e-a0510b46b473/scan_f24e833d-2701-11ee-a98e-a0510b46b473/459f10c1-2702-11ee-a98e-a0510b46b473.png','PATIENT_848c86d9-26fd-11ee-a98e-a0510b46b473_ACT_8f62cd50-26fd-11ee-a98e-a0510b46b473_SESS_8f65e2e0-26fd-11ee-a98e-a0510b46b473_TOSC_f24e833d-2701-11ee-a98e-a0510b46b473_SNAPS','459f10c1-2702-11ee-a98e-a0510b46b473.png','459f10c1-2702-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.36.1.1.10 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-20 15:35:20.653','2023-07-20 13:35:21.373',NULL),('45af69f2-e021-11ed-a285-00d86184ce3d',11,'/home/scan/.data//2023/11/5f27680c-e01a-11ed-b6c2-00d86184ce3d/session_65b85f32-e01a-11ed-b6c2-00d86184ce3d/occlusion_65ba9a94-e01a-11ed-b6c2-00d86184ce3d/scan_fa0a5403-e020-11ed-a285-00d86184ce3d/45af69f2-e021-11ed-a285-00d86184ce3d.zip','PATIENT_5f27680c-e01a-11ed-b6c2-00d86184ce3d_ACT_65b85f32-e01a-11ed-b6c2-00d86184ce3d_SESS_65ba9a94-e01a-11ed-b6c2-00d86184ce3d_TOSC_fa0a5403-e020-11ed-a285-00d86184ce3d_MODEL','45af69f2-e021-11ed-a285-00d86184ce3d.zip','45af69f2-e021-11ed-a285-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.10.1.1.9\",\"modelMatrix\":\"0.552053,0.767931,-0.32484,0,-0.833809,0.508435,-0.215071,0,2.42125e-09,0.389585,0.920991,0,-25.2314,-15.6914,-6.31831,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 10:48:22.602','2023-04-21 08:48:23.464',NULL),('45af946c-e021-11ed-a285-00d86184ce3d',11,'/home/scan/.data//2023/11/5f27680c-e01a-11ed-b6c2-00d86184ce3d/session_65b85f32-e01a-11ed-b6c2-00d86184ce3d/occlusion_65ba9a94-e01a-11ed-b6c2-00d86184ce3d/scan_fa0a5403-e020-11ed-a285-00d86184ce3d/45af946c-e021-11ed-a285-00d86184ce3d.png','PATIENT_5f27680c-e01a-11ed-b6c2-00d86184ce3d_ACT_65b85f32-e01a-11ed-b6c2-00d86184ce3d_SESS_65ba9a94-e01a-11ed-b6c2-00d86184ce3d_TOSC_fa0a5403-e020-11ed-a285-00d86184ce3d_SNAPS','45af946c-e021-11ed-a285-00d86184ce3d.png','45af946c-e021-11ed-a285-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.10.1.1.9 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 10:48:22.603','2023-04-21 08:48:23.464',NULL),('45fbe52e-0f7a-11ee-9460-a0510b46b473',11,'/home/scan/.data//2023/11/e4b67639-0f72-11ee-8712-a0510b46b473/session_ec7935d6-0f72-11ee-8712-a0510b46b473/occlusion_ec7bd8ad-0f72-11ee-8712-a0510b46b473/scan_ee57ba7b-0f79-11ee-9460-a0510b46b473/45fbe52e-0f7a-11ee-9460-a0510b46b473.zip','PATIENT_e4b67639-0f72-11ee-8712-a0510b46b473_ACT_ec7935d6-0f72-11ee-8712-a0510b46b473_SESS_ec7bd8ad-0f72-11ee-8712-a0510b46b473_TOSC_ee57ba7b-0f79-11ee-9460-a0510b46b473_MODEL','45fbe52e-0f7a-11ee-9460-a0510b46b473.zip','45fbe52e-0f7a-11ee-9460-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.15.1.1.10\",\"modelMatrix\":\"0.643019,0.744868,-0.178041,0,-0.76585,0.625402,-0.149485,0,-9.54732e-09,0.232474,0.972603,0,-27.9999,1.362,-9.0503,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-20 16:53:52.962','2023-06-20 14:53:53.596',NULL),('45fbf76c-0f7a-11ee-9460-a0510b46b473',11,'/home/scan/.data//2023/11/e4b67639-0f72-11ee-8712-a0510b46b473/session_ec7935d6-0f72-11ee-8712-a0510b46b473/occlusion_ec7bd8ad-0f72-11ee-8712-a0510b46b473/scan_ee57ba7b-0f79-11ee-9460-a0510b46b473/45fbf76c-0f7a-11ee-9460-a0510b46b473.png','PATIENT_e4b67639-0f72-11ee-8712-a0510b46b473_ACT_ec7935d6-0f72-11ee-8712-a0510b46b473_SESS_ec7bd8ad-0f72-11ee-8712-a0510b46b473_TOSC_ee57ba7b-0f79-11ee-9460-a0510b46b473_SNAPS','45fbf76c-0f7a-11ee-9460-a0510b46b473.png','45fbf76c-0f7a-11ee-9460-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.15.1.1.10 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-20 16:53:52.963','2023-06-20 14:53:53.597',NULL),('46a565c5-e356-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_853ebc79-e33f-11ed-8c5e-00d86184ce3d/occlusion_8541c500-e33f-11ed-8c5e-00d86184ce3d/scan_fe3b5b76-e355-11ed-8c5e-00d86184ce3d/46a565c5-e356-11ed-8c5e-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_853ebc79-e33f-11ed-8c5e-00d86184ce3d_SESS_8541c500-e33f-11ed-8c5e-00d86184ce3d_TOSC_fe3b5b76-e355-11ed-8c5e-00d86184ce3d_MODEL','46a565c5-e356-11ed-8c5e-00d86184ce3d.zip','46a565c5-e356-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.6.1.11\",\"modelMatrix\":\"0.645718,0.710964,-0.278528,0,-0.763576,0.601227,-0.235538,0,9.63347e-09,0.364769,0.931098,0,-28.9701,-1.68718,-8.52841,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-25 12:45:21.029','2023-04-25 10:45:21.868',NULL),('46a5dbff-e356-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_853ebc79-e33f-11ed-8c5e-00d86184ce3d/occlusion_8541c500-e33f-11ed-8c5e-00d86184ce3d/scan_fe3b5b76-e355-11ed-8c5e-00d86184ce3d/46a5dbff-e356-11ed-8c5e-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_853ebc79-e33f-11ed-8c5e-00d86184ce3d_SESS_8541c500-e33f-11ed-8c5e-00d86184ce3d_TOSC_fe3b5b76-e355-11ed-8c5e-00d86184ce3d_SNAPS','46a5dbff-e356-11ed-8c5e-00d86184ce3d.png','46a5dbff-e356-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.6.1.11 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-25 12:45:21.032','2023-04-25 10:45:21.869',NULL),('46bee7f8-14e6-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_efcc55aa-14e3-11ee-b3b1-00d86184ce3d/occlusion_efcf357e-14e3-11ee-b3b1-00d86184ce3d/scan_e41e1887-14e5-11ee-b3b1-00d86184ce3d/46bee7f8-14e6-11ee-b3b1-00d86184ce3d.zip','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_efcc55aa-14e3-11ee-b3b1-00d86184ce3d_SESS_efcf357e-14e3-11ee-b3b1-00d86184ce3d_TOSC_e41e1887-14e5-11ee-b3b1-00d86184ce3d_MODEL','46bee7f8-14e6-11ee-b3b1-00d86184ce3d.zip','46bee7f8-14e6-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.20.3.1.5\",\"modelMatrix\":\"-0.247939,0.937302,-0.244932,0,-0.968776,-0.239884,0.0626856,0,1.7232e-09,0.252826,0.967512,0,-13.6957,-30.2939,-8.08513,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-27 14:29:35.701','2023-06-27 12:29:36.525',NULL),('46befec4-14e6-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_efcc55aa-14e3-11ee-b3b1-00d86184ce3d/occlusion_efcf357e-14e3-11ee-b3b1-00d86184ce3d/scan_e41e1887-14e5-11ee-b3b1-00d86184ce3d/46befec4-14e6-11ee-b3b1-00d86184ce3d.png','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_efcc55aa-14e3-11ee-b3b1-00d86184ce3d_SESS_efcf357e-14e3-11ee-b3b1-00d86184ce3d_TOSC_e41e1887-14e5-11ee-b3b1-00d86184ce3d_SNAPS','46befec4-14e6-11ee-b3b1-00d86184ce3d.png','46befec4-14e6-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.20.3.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-27 14:29:35.702','2023-06-27 12:29:36.526',NULL),('476ef37d-e344-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_853ebc79-e33f-11ed-8c5e-00d86184ce3d/occlusion_8541c500-e33f-11ed-8c5e-00d86184ce3d/scan_f084b6d5-e343-11ed-8c5e-00d86184ce3d/476ef37d-e344-11ed-8c5e-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_853ebc79-e33f-11ed-8c5e-00d86184ce3d_SESS_8541c500-e33f-11ed-8c5e-00d86184ce3d_TOSC_f084b6d5-e343-11ed-8c5e-00d86184ce3d_MODEL','476ef37d-e344-11ed-8c5e-00d86184ce3d.zip','476ef37d-e344-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.6.1.6\",\"modelMatrix\":\"0.206965,0.947251,-0.244706,0,-0.978348,0.200386,-0.0517663,0,-1.89552e-10,0.250121,0.968215,0,-23.2259,-18.7309,-8.00295,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-25 10:36:31.408','2023-04-25 08:36:32.313',NULL),('476f08be-e344-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_853ebc79-e33f-11ed-8c5e-00d86184ce3d/occlusion_8541c500-e33f-11ed-8c5e-00d86184ce3d/scan_f084b6d5-e343-11ed-8c5e-00d86184ce3d/476f08be-e344-11ed-8c5e-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_853ebc79-e33f-11ed-8c5e-00d86184ce3d_SESS_8541c500-e33f-11ed-8c5e-00d86184ce3d_TOSC_f084b6d5-e343-11ed-8c5e-00d86184ce3d_SNAPS','476f08be-e344-11ed-8c5e-00d86184ce3d.png','476f08be-e344-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.6.1.6 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-25 10:36:31.409','2023-04-25 08:36:32.314',NULL),('49045d73-e036-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_63b81b7e-e035-11ed-bb13-00d86184ce3d/occlusion_63bb1989-e035-11ed-bb13-00d86184ce3d/scan_280b0576-e036-11ed-bb13-00d86184ce3d/49045d73-e036-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_63b81b7e-e035-11ed-bb13-00d86184ce3d_SESS_63bb1989-e035-11ed-bb13-00d86184ce3d_TOSC_280b0576-e036-11ed-bb13-00d86184ce3d_MODEL','49045d73-e036-11ed-bb13-00d86184ce3d.zip','49045d73-e036-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.2.1.2\",\"modelMatrix\":\"0.63512,0.720195,-0.27918,0,-0.772413,0.592184,-0.229557,0,-1.07058e-08,0.361439,0.932396,0,-14.1574,-11.8187,-7.4609,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 13:18:47.623','2023-04-21 11:18:47.968',NULL),('4904728b-e036-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_63b81b7e-e035-11ed-bb13-00d86184ce3d/occlusion_63bb1989-e035-11ed-bb13-00d86184ce3d/scan_280b0576-e036-11ed-bb13-00d86184ce3d/4904728b-e036-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_63b81b7e-e035-11ed-bb13-00d86184ce3d_SESS_63bb1989-e035-11ed-bb13-00d86184ce3d_TOSC_280b0576-e036-11ed-bb13-00d86184ce3d_SNAPS','4904728b-e036-11ed-bb13-00d86184ce3d.png','4904728b-e036-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.2.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 13:18:47.623','2023-04-21 11:18:47.969',NULL),('49eb2d16-1bd9-11ee-9086-a0510b46b473',11,'/home/scan/.data//2023/11/61e16a70-1a76-11ee-8124-a0510b46b473/session_a0a47257-1bd8-11ee-9086-a0510b46b473/occlusion_a0a77bfe-1bd8-11ee-9086-a0510b46b473/scan_d80a7c31-1bd8-11ee-9086-a0510b46b473/49eb2d16-1bd9-11ee-9086-a0510b46b473.zip','PATIENT_61e16a70-1a76-11ee-8124-a0510b46b473_ACT_a0a47257-1bd8-11ee-9086-a0510b46b473_SESS_a0a77bfe-1bd8-11ee-9086-a0510b46b473_TOSC_d80a7c31-1bd8-11ee-9086-a0510b46b473_MODEL','49eb2d16-1bd9-11ee-9086-a0510b46b473.zip','49eb2d16-1bd9-11ee-9086-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.27.3.1.2\",\"modelMatrix\":\"-0.425938,-0.830966,0.357871,0,0.904752,-0.391201,0.168478,0,-1.93701e-09,0.395546,0.918446,0,98.0755,39.1314,-38.3828,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 10:44:15.706','2023-07-06 08:44:16.464',NULL),('49eb46f9-1bd9-11ee-9086-a0510b46b473',11,'/home/scan/.data//2023/11/61e16a70-1a76-11ee-8124-a0510b46b473/session_a0a47257-1bd8-11ee-9086-a0510b46b473/occlusion_a0a77bfe-1bd8-11ee-9086-a0510b46b473/scan_d80a7c31-1bd8-11ee-9086-a0510b46b473/49eb46f9-1bd9-11ee-9086-a0510b46b473.png','PATIENT_61e16a70-1a76-11ee-8124-a0510b46b473_ACT_a0a47257-1bd8-11ee-9086-a0510b46b473_SESS_a0a77bfe-1bd8-11ee-9086-a0510b46b473_TOSC_d80a7c31-1bd8-11ee-9086-a0510b46b473_SNAPS','49eb46f9-1bd9-11ee-9086-a0510b46b473.png','49eb46f9-1bd9-11ee-9086-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.27.3.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 10:44:15.707','2023-07-06 08:44:16.465',NULL),('4a4fa09a-158a-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/634153bc-1587-11ee-b3b1-00d86184ce3d/session_6e9df503-1587-11ee-b3b1-00d86184ce3d/occlusion_6ea0d9b2-1587-11ee-b3b1-00d86184ce3d/scan_fde4a4c1-1589-11ee-b3b1-00d86184ce3d/4a4fa09a-158a-11ee-b3b1-00d86184ce3d.zip','PATIENT_634153bc-1587-11ee-b3b1-00d86184ce3d_ACT_6e9df503-1587-11ee-b3b1-00d86184ce3d_SESS_6ea0d9b2-1587-11ee-b3b1-00d86184ce3d_TOSC_fde4a4c1-1589-11ee-b3b1-00d86184ce3d_MODEL','4a4fa09a-158a-11ee-b3b1-00d86184ce3d.zip','4a4fa09a-158a-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.24.1.1.3\",\"modelMatrix\":\"0.181077,0.950373,-0.252987,0,-0.983469,0.174983,-0.0465802,0,1.94733e-09,0.25724,0.966348,0,-24.0658,-19.9854,-9.32883,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-28 10:03:39.146','2023-06-28 08:03:39.830',NULL),('4a4fb67c-158a-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/634153bc-1587-11ee-b3b1-00d86184ce3d/session_6e9df503-1587-11ee-b3b1-00d86184ce3d/occlusion_6ea0d9b2-1587-11ee-b3b1-00d86184ce3d/scan_fde4a4c1-1589-11ee-b3b1-00d86184ce3d/4a4fb67c-158a-11ee-b3b1-00d86184ce3d.png','PATIENT_634153bc-1587-11ee-b3b1-00d86184ce3d_ACT_6e9df503-1587-11ee-b3b1-00d86184ce3d_SESS_6ea0d9b2-1587-11ee-b3b1-00d86184ce3d_TOSC_fde4a4c1-1589-11ee-b3b1-00d86184ce3d_SNAPS','4a4fb67c-158a-11ee-b3b1-00d86184ce3d.png','4a4fb67c-158a-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.24.1.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-28 10:03:39.147','2023-06-28 08:03:39.830',NULL),('4ae17f94-df82-11ed-b6c2-00d86184ce3d',11,'/home/scan/.data//2023/11/ac239c53-df81-11ed-b6c2-00d86184ce3d/session_b20f4b8a-df81-11ed-b6c2-00d86184ce3d/occlusion_b21241b0-df81-11ed-b6c2-00d86184ce3d/scan_007b26af-df82-11ed-b6c2-00d86184ce3d/4ae17f94-df82-11ed-b6c2-00d86184ce3d.zip','PATIENT_ac239c53-df81-11ed-b6c2-00d86184ce3d_ACT_b20f4b8a-df81-11ed-b6c2-00d86184ce3d_SESS_b21241b0-df81-11ed-b6c2-00d86184ce3d_TOSC_007b26af-df82-11ed-b6c2-00d86184ce3d_MODEL','4ae17f94-df82-11ed-b6c2-00d86184ce3d.zip','4ae17f94-df82-11ed-b6c2-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.7.1.1.1\",\"modelMatrix\":\"0.381931,0.744177,-0.548023,0,-0.924191,0.307539,-0.226476,0,-8.87919e-09,0.592976,0.80522,0,-22.3769,-16.2991,-12.4116,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-20 15:50:21.338','2023-04-20 13:50:22.172',NULL),('4ae19669-df82-11ed-b6c2-00d86184ce3d',11,'/home/scan/.data//2023/11/ac239c53-df81-11ed-b6c2-00d86184ce3d/session_b20f4b8a-df81-11ed-b6c2-00d86184ce3d/occlusion_b21241b0-df81-11ed-b6c2-00d86184ce3d/scan_007b26af-df82-11ed-b6c2-00d86184ce3d/4ae19669-df82-11ed-b6c2-00d86184ce3d.png','PATIENT_ac239c53-df81-11ed-b6c2-00d86184ce3d_ACT_b20f4b8a-df81-11ed-b6c2-00d86184ce3d_SESS_b21241b0-df81-11ed-b6c2-00d86184ce3d_TOSC_007b26af-df82-11ed-b6c2-00d86184ce3d_SNAPS','4ae19669-df82-11ed-b6c2-00d86184ce3d.png','4ae19669-df82-11ed-b6c2-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.7.1.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-20 15:50:21.339','2023-04-20 13:50:22.172',NULL),('4b641eac-10fc-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/ed94fe78-10f4-11ee-b636-a0510b46b473/session_8cbad919-10fb-11ee-b636-a0510b46b473/occlusion_8cbde682-10fb-11ee-b636-a0510b46b473/scan_1142d295-10fc-11ee-b636-a0510b46b473/4b641eac-10fc-11ee-b636-a0510b46b473.zip','PATIENT_ed94fe78-10f4-11ee-b636-a0510b46b473_ACT_8cbad919-10fb-11ee-b636-a0510b46b473_SESS_8cbde682-10fb-11ee-b636-a0510b46b473_TOSC_1142d295-10fc-11ee-b636-a0510b46b473_MODEL','4b641eac-10fc-11ee-b636-a0510b46b473.zip','4b641eac-10fc-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.19.2.1.3\",\"modelMatrix\":\"0.806767,0.552186,-0.21028,0,-0.59087,0.753949,-0.287114,0,7.95518e-09,0.355882,0.934531,0,-23.0056,3.33775,-9.86417,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 14:57:07.772','2023-06-22 12:57:08.383',NULL),('4b643655-10fc-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/ed94fe78-10f4-11ee-b636-a0510b46b473/session_8cbad919-10fb-11ee-b636-a0510b46b473/occlusion_8cbde682-10fb-11ee-b636-a0510b46b473/scan_1142d295-10fc-11ee-b636-a0510b46b473/4b643655-10fc-11ee-b636-a0510b46b473.png','PATIENT_ed94fe78-10f4-11ee-b636-a0510b46b473_ACT_8cbad919-10fb-11ee-b636-a0510b46b473_SESS_8cbde682-10fb-11ee-b636-a0510b46b473_TOSC_1142d295-10fc-11ee-b636-a0510b46b473_SNAPS','4b643655-10fc-11ee-b636-a0510b46b473.png','4b643655-10fc-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.19.2.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 14:57:07.772','2023-06-22 12:57:08.383',NULL),('4bc1a4f7-2a3e-11ee-9e90-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_b144ba33-2a36-11ee-9e90-a0510b46b473/occlusion_b147bba1-2a36-11ee-9e90-a0510b46b473/scan_16d21737-2a3e-11ee-9e90-a0510b46b473/4bc1a4f7-2a3e-11ee-9e90-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_b144ba33-2a36-11ee-9e90-a0510b46b473_SESS_b147bba1-2a36-11ee-9e90-a0510b46b473_TOSC_16d21737-2a3e-11ee-9e90-a0510b46b473_MODEL','4bc1a4f7-2a3e-11ee-9e90-a0510b46b473.zip','4bc1a4f7-2a3e-11ee-9e90-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.6.1.6\",\"modelMatrix\":\"0.800284,0.552636,-0.232677,0,-0.599621,0.737576,-0.310542,0,-1.45753e-09,0.38804,0.921642,0,-30.4085,3.35041,-6.25014,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,'2023-07-24 18:27:44.658','2023-07-24 18:22:34.238','2023-07-24 16:27:44.663',NULL),('4bc2e508-2a3e-11ee-9e90-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_b144ba33-2a36-11ee-9e90-a0510b46b473/occlusion_b147bba1-2a36-11ee-9e90-a0510b46b473/scan_16d21737-2a3e-11ee-9e90-a0510b46b473/4bc2e508-2a3e-11ee-9e90-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_b144ba33-2a36-11ee-9e90-a0510b46b473_SESS_b147bba1-2a36-11ee-9e90-a0510b46b473_TOSC_16d21737-2a3e-11ee-9e90-a0510b46b473_SNAPS','4bc2e508-2a3e-11ee-9e90-a0510b46b473.png','4bc2e508-2a3e-11ee-9e90-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.6.1.6 Snapshot\"}','PNG',0,'CREATED',0,'2023-07-24 18:27:44.658','2023-07-24 18:22:34.246','2023-07-24 16:27:44.667',NULL),('4cb0d00b-26f6-11ee-aa9d-a0510b46b473',11,'/home/scan/.data//2023/11/c69c4cec-26f5-11ee-aa9d-a0510b46b473/session_cf31a6d6-26f5-11ee-aa9d-a0510b46b473/occlusion_cf34c227-26f5-11ee-aa9d-a0510b46b473/scan_f8dafa3a-26f5-11ee-aa9d-a0510b46b473/4cb0d00b-26f6-11ee-aa9d-a0510b46b473.zip','PATIENT_c69c4cec-26f5-11ee-aa9d-a0510b46b473_ACT_cf31a6d6-26f5-11ee-aa9d-a0510b46b473_SESS_cf34c227-26f5-11ee-aa9d-a0510b46b473_TOSC_f8dafa3a-26f5-11ee-aa9d-a0510b46b473_MODEL','4cb0d00b-26f6-11ee-aa9d-a0510b46b473.zip','4cb0d00b-26f6-11ee-aa9d-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.35.1.1.1\",\"modelMatrix\":\"0.999825,0.0183211,-0.00368483,0,-0.018688,0.980197,-0.197142,0,1.34186e-10,0.197176,0.980368,0,-13.8003,1.04321,-13.5861,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,'2023-07-20 14:10:01.119','2023-07-20 14:09:38.553','2023-07-20 12:10:01.124',NULL),('4cb0eb1f-26f6-11ee-aa9d-a0510b46b473',11,'/home/scan/.data//2023/11/c69c4cec-26f5-11ee-aa9d-a0510b46b473/session_cf31a6d6-26f5-11ee-aa9d-a0510b46b473/occlusion_cf34c227-26f5-11ee-aa9d-a0510b46b473/scan_f8dafa3a-26f5-11ee-aa9d-a0510b46b473/4cb0eb1f-26f6-11ee-aa9d-a0510b46b473.png','PATIENT_c69c4cec-26f5-11ee-aa9d-a0510b46b473_ACT_cf31a6d6-26f5-11ee-aa9d-a0510b46b473_SESS_cf34c227-26f5-11ee-aa9d-a0510b46b473_TOSC_f8dafa3a-26f5-11ee-aa9d-a0510b46b473_SNAPS','4cb0eb1f-26f6-11ee-aa9d-a0510b46b473.png','4cb0eb1f-26f6-11ee-aa9d-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.35.1.1.1 Snapshot\"}','PNG',0,'CREATED',0,'2023-07-20 14:10:01.119','2023-07-20 14:09:38.553','2023-07-20 12:10:01.128',NULL),('4d1a25ad-1a65-11ee-9a4f-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_9f32257c-1a64-11ee-9a4f-a0510b46b473/occlusion_9f33e64c-1a64-11ee-9a4f-a0510b46b473/scan_17a864a7-1a65-11ee-9a4f-a0510b46b473/4d1a25ad-1a65-11ee-9a4f-a0510b46b473.zip','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_9f32257c-1a64-11ee-9a4f-a0510b46b473_SESS_9f33e64c-1a64-11ee-9a4f-a0510b46b473_TOSC_17a864a7-1a65-11ee-9a4f-a0510b46b473_MODEL','4d1a25ad-1a65-11ee-9a4f-a0510b46b473.zip','4d1a25ad-1a65-11ee-9a4f-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.2.1.2\",\"modelMatrix\":\"0.941648,0.299794,-0.153045,0,-0.336599,0.838683,-0.428148,0,-1.06088e-08,0.45468,0.890655,0,-24.5394,16.7212,-14.2573,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-04 14:21:28.264','2023-07-04 12:21:28.733',NULL),('4d1a3bd8-1a65-11ee-9a4f-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_9f32257c-1a64-11ee-9a4f-a0510b46b473/occlusion_9f33e64c-1a64-11ee-9a4f-a0510b46b473/scan_17a864a7-1a65-11ee-9a4f-a0510b46b473/4d1a3bd8-1a65-11ee-9a4f-a0510b46b473.png','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_9f32257c-1a64-11ee-9a4f-a0510b46b473_SESS_9f33e64c-1a64-11ee-9a4f-a0510b46b473_TOSC_17a864a7-1a65-11ee-9a4f-a0510b46b473_SNAPS','4d1a3bd8-1a65-11ee-9a4f-a0510b46b473.png','4d1a3bd8-1a65-11ee-9a4f-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.2.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-04 14:21:28.264','2023-07-04 12:21:28.734',NULL),('4d2b4a6a-e341-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_853ebc79-e33f-11ed-8c5e-00d86184ce3d/occlusion_8541c500-e33f-11ed-8c5e-00d86184ce3d/scan_ef895c1c-e340-11ed-8c5e-00d86184ce3d/4d2b4a6a-e341-11ed-8c5e-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_853ebc79-e33f-11ed-8c5e-00d86184ce3d_SESS_8541c500-e33f-11ed-8c5e-00d86184ce3d_TOSC_ef895c1c-e340-11ed-8c5e-00d86184ce3d_MODEL','4d2b4a6a-e341-11ed-8c5e-00d86184ce3d.zip','4d2b4a6a-e341-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.6.1.2\",\"modelMatrix\":\"-0.264239,0.905317,-0.332533,0,-0.964457,-0.248036,0.0911063,0,8.24183e-10,0.344788,0.93868,0,-16.3825,-27.8253,-5.37365,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-25 10:15:12.541','2023-04-25 08:15:13.562',NULL),('4d2b608e-e341-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_853ebc79-e33f-11ed-8c5e-00d86184ce3d/occlusion_8541c500-e33f-11ed-8c5e-00d86184ce3d/scan_ef895c1c-e340-11ed-8c5e-00d86184ce3d/4d2b608e-e341-11ed-8c5e-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_853ebc79-e33f-11ed-8c5e-00d86184ce3d_SESS_8541c500-e33f-11ed-8c5e-00d86184ce3d_TOSC_ef895c1c-e340-11ed-8c5e-00d86184ce3d_SNAPS','4d2b608e-e341-11ed-8c5e-00d86184ce3d.png','4d2b608e-e341-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.6.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-25 10:15:12.542','2023-04-25 08:15:13.562',NULL),('4d6cb79f-15ba-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/142e7037-15b6-11ee-b3b1-00d86184ce3d/session_1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d/occlusion_1ed7780a-15b6-11ee-b3b1-00d86184ce3d/scan_f8fd7394-15b9-11ee-b3b1-00d86184ce3d/4d6cb79f-15ba-11ee-b3b1-00d86184ce3d.zip','PATIENT_142e7037-15b6-11ee-b3b1-00d86184ce3d_ACT_1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d_SESS_1ed7780a-15b6-11ee-b3b1-00d86184ce3d_TOSC_f8fd7394-15b9-11ee-b3b1-00d86184ce3d_MODEL','4d6cb79f-15ba-11ee-b3b1-00d86184ce3d.zip','4d6cb79f-15ba-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.25.1.1.10\",\"modelMatrix\":\"0.279382,0.930305,-0.237652,0,-0.96018,0.27069,-0.0691494,0,-3.10976e-09,0.247508,0.968886,0,-23.8741,-20.6898,-8.66803,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-28 15:47:20.213','2023-06-28 13:47:21.054',NULL),('4d6cce12-15ba-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/142e7037-15b6-11ee-b3b1-00d86184ce3d/session_1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d/occlusion_1ed7780a-15b6-11ee-b3b1-00d86184ce3d/scan_f8fd7394-15b9-11ee-b3b1-00d86184ce3d/4d6cce12-15ba-11ee-b3b1-00d86184ce3d.png','PATIENT_142e7037-15b6-11ee-b3b1-00d86184ce3d_ACT_1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d_SESS_1ed7780a-15b6-11ee-b3b1-00d86184ce3d_TOSC_f8fd7394-15b9-11ee-b3b1-00d86184ce3d_SNAPS','4d6cce12-15ba-11ee-b3b1-00d86184ce3d.png','4d6cce12-15ba-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.25.1.1.10 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-28 15:47:20.214','2023-06-28 13:47:21.063',NULL),('4da0c1d2-1bfa-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/8a8cc548-1bf9-11ee-9323-a0510b46b473/session_976f015a-1bf9-11ee-9323-a0510b46b473/occlusion_97713d19-1bf9-11ee-9323-a0510b46b473/scan_fac15dec-1bf9-11ee-9323-a0510b46b473/4da0c1d2-1bfa-11ee-9323-a0510b46b473.zip','PATIENT_8a8cc548-1bf9-11ee-9323-a0510b46b473_ACT_976f015a-1bf9-11ee-9323-a0510b46b473_SESS_97713d19-1bf9-11ee-9323-a0510b46b473_TOSC_fac15dec-1bf9-11ee-9323-a0510b46b473_MODEL','4da0c1d2-1bfa-11ee-9323-a0510b46b473.zip','4da0c1d2-1bfa-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.28.1.1.2\",\"modelMatrix\":\"-0.151766,-0.983781,0.0956125,0,0.988417,-0.151054,0.0146807,0,5.58973e-10,0.096733,0.99531,0,24.5162,17.8269,-15.5392,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 14:40:35.322','2023-07-06 12:40:36.013',NULL),('4da2022b-1bfa-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/8a8cc548-1bf9-11ee-9323-a0510b46b473/session_976f015a-1bf9-11ee-9323-a0510b46b473/occlusion_97713d19-1bf9-11ee-9323-a0510b46b473/scan_fac15dec-1bf9-11ee-9323-a0510b46b473/4da2022b-1bfa-11ee-9323-a0510b46b473.png','PATIENT_8a8cc548-1bf9-11ee-9323-a0510b46b473_ACT_976f015a-1bf9-11ee-9323-a0510b46b473_SESS_97713d19-1bf9-11ee-9323-a0510b46b473_TOSC_fac15dec-1bf9-11ee-9323-a0510b46b473_SNAPS','4da2022b-1bfa-11ee-9323-a0510b46b473.png','4da2022b-1bfa-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.28.1.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 14:40:35.330','2023-07-06 12:40:36.014',NULL),('4e1372dd-e010-11ed-b6c2-00d86184ce3d',11,'/home/scan/.data//2023/11/e0d449f3-dde9-11ed-aa56-00d86184ce3d/session_858fcc60-de94-11ed-9cc3-00d86184ce3d/occlusion_85925fd9-de94-11ed-9cc3-00d86184ce3d/scan_06bcfc1b-e010-11ed-b6c2-00d86184ce3d/4e1372dd-e010-11ed-b6c2-00d86184ce3d.zip','PATIENT_e0d449f3-dde9-11ed-aa56-00d86184ce3d_ACT_858fcc60-de94-11ed-9cc3-00d86184ce3d_SESS_85925fd9-de94-11ed-9cc3-00d86184ce3d_BOSC_06bcfc1b-e010-11ed-b6c2-00d86184ce3d_MODEL','4e1372dd-e010-11ed-b6c2-00d86184ce3d.zip','4e1372dd-e010-11ed-b6c2-00d86184ce3d','{\"displayTitle\":\"Mandibule 1.2.1.1.1\",\"modelMatrix\":\"0.859706,0.473957,-0.190449,0,-0.51079,0.797713,-0.320543,0,6.68172e-09,0.372853,0.927891,0,-27.782,-4.94951,-9.41615,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 08:46:55.235','2023-04-21 06:46:55.904',NULL),('4e138845-e010-11ed-b6c2-00d86184ce3d',11,'/home/scan/.data//2023/11/e0d449f3-dde9-11ed-aa56-00d86184ce3d/session_858fcc60-de94-11ed-9cc3-00d86184ce3d/occlusion_85925fd9-de94-11ed-9cc3-00d86184ce3d/scan_06bcfc1b-e010-11ed-b6c2-00d86184ce3d/4e138845-e010-11ed-b6c2-00d86184ce3d.png','PATIENT_e0d449f3-dde9-11ed-aa56-00d86184ce3d_ACT_858fcc60-de94-11ed-9cc3-00d86184ce3d_SESS_85925fd9-de94-11ed-9cc3-00d86184ce3d_BOSC_06bcfc1b-e010-11ed-b6c2-00d86184ce3d_SNAPS','4e138845-e010-11ed-b6c2-00d86184ce3d.png','4e138845-e010-11ed-b6c2-00d86184ce3d','{\"displayTitle\":\"Mandibule 1.2.1.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 08:46:55.235','2023-04-21 06:46:55.905',NULL),('4ed991fb-0f79-11ee-9460-a0510b46b473',11,'/home/scan/.data//2023/11/e4b67639-0f72-11ee-8712-a0510b46b473/session_ec7935d6-0f72-11ee-8712-a0510b46b473/occlusion_ec7bd8ad-0f72-11ee-8712-a0510b46b473/scan_2863b54c-0f79-11ee-9460-a0510b46b473/4ed991fb-0f79-11ee-9460-a0510b46b473.zip','PATIENT_e4b67639-0f72-11ee-8712-a0510b46b473_ACT_ec7935d6-0f72-11ee-8712-a0510b46b473_SESS_ec7bd8ad-0f72-11ee-8712-a0510b46b473_TOSC_2863b54c-0f79-11ee-9460-a0510b46b473_MODEL','4ed991fb-0f79-11ee-9460-a0510b46b473.zip','4ed991fb-0f79-11ee-9460-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.15.1.1.8\",\"modelMatrix\":\"0.557976,-0.813531,0.1638,0,0.829857,0.546999,-0.110135,0,-1.12595e-08,0.197383,0.980326,0,3.99465,21.6867,-10.237,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-20 16:46:58.340','2023-06-20 14:46:58.692',NULL),('4ed9a88c-0f79-11ee-9460-a0510b46b473',11,'/home/scan/.data//2023/11/e4b67639-0f72-11ee-8712-a0510b46b473/session_ec7935d6-0f72-11ee-8712-a0510b46b473/occlusion_ec7bd8ad-0f72-11ee-8712-a0510b46b473/scan_2863b54c-0f79-11ee-9460-a0510b46b473/4ed9a88c-0f79-11ee-9460-a0510b46b473.png','PATIENT_e4b67639-0f72-11ee-8712-a0510b46b473_ACT_ec7935d6-0f72-11ee-8712-a0510b46b473_SESS_ec7bd8ad-0f72-11ee-8712-a0510b46b473_TOSC_2863b54c-0f79-11ee-9460-a0510b46b473_SNAPS','4ed9a88c-0f79-11ee-9460-a0510b46b473.png','4ed9a88c-0f79-11ee-9460-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.15.1.1.8 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-20 16:46:58.341','2023-06-20 14:46:58.693',NULL),('4ee27aad-e349-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/971e14b0-e348-11ed-8c5e-00d86184ce3d/session_a0fbda94-e348-11ed-8c5e-00d86184ce3d/occlusion_a0febadb-e348-11ed-8c5e-00d86184ce3d/scan_01383647-e349-11ed-8c5e-00d86184ce3d/4ee27aad-e349-11ed-8c5e-00d86184ce3d.zip','PATIENT_971e14b0-e348-11ed-8c5e-00d86184ce3d_ACT_a0fbda94-e348-11ed-8c5e-00d86184ce3d_SESS_a0febadb-e348-11ed-8c5e-00d86184ce3d_TOSC_01383647-e349-11ed-8c5e-00d86184ce3d_MODEL','4ee27aad-e349-11ed-8c5e-00d86184ce3d.zip','4ee27aad-e349-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.12.1.1.2\",\"modelMatrix\":\"-0.163596,0.948727,-0.270469,0,-0.986528,-0.157327,0.0448518,0,-3.33961e-09,0.274162,0.961683,0,-19.496,-25.4314,-7.10803,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-25 11:12:31.393','2023-04-25 09:12:32.248',NULL),('4ee29381-e349-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/971e14b0-e348-11ed-8c5e-00d86184ce3d/session_a0fbda94-e348-11ed-8c5e-00d86184ce3d/occlusion_a0febadb-e348-11ed-8c5e-00d86184ce3d/scan_01383647-e349-11ed-8c5e-00d86184ce3d/4ee29381-e349-11ed-8c5e-00d86184ce3d.png','PATIENT_971e14b0-e348-11ed-8c5e-00d86184ce3d_ACT_a0fbda94-e348-11ed-8c5e-00d86184ce3d_SESS_a0febadb-e348-11ed-8c5e-00d86184ce3d_TOSC_01383647-e349-11ed-8c5e-00d86184ce3d_SNAPS','4ee29381-e349-11ed-8c5e-00d86184ce3d.png','4ee29381-e349-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.12.1.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-25 11:12:31.394','2023-04-25 09:12:32.249',NULL),('4f220e48-110b-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_0628a8e9-1104-11ee-b636-a0510b46b473/occlusion_062b833f-1104-11ee-b636-a0510b46b473/scan_fb9b46c5-110a-11ee-b636-a0510b46b473/4f220e48-110b-11ee-b636-a0510b46b473.zip','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_0628a8e9-1104-11ee-b636-a0510b46b473_SESS_062b833f-1104-11ee-b636-a0510b46b473_TOSC_fb9b46c5-110a-11ee-b636-a0510b46b473_MODEL','4f220e48-110b-11ee-b636-a0510b46b473.zip','4f220e48-110b-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.20.1.1.9\",\"modelMatrix\":\"0.228407,0.927931,-0.294575,0,-0.973566,0.217701,-0.0691098,0,3.51111e-09,0.302573,0.953126,0,-26.2679,-13.9355,-10.6817,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 16:44:36.500','2023-06-22 14:44:41.856',NULL),('4f2222e4-110b-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_0628a8e9-1104-11ee-b636-a0510b46b473/occlusion_062b833f-1104-11ee-b636-a0510b46b473/scan_fb9b46c5-110a-11ee-b636-a0510b46b473/4f2222e4-110b-11ee-b636-a0510b46b473.png','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_0628a8e9-1104-11ee-b636-a0510b46b473_SESS_062b833f-1104-11ee-b636-a0510b46b473_TOSC_fb9b46c5-110a-11ee-b636-a0510b46b473_SNAPS','4f2222e4-110b-11ee-b636-a0510b46b473.png','4f2222e4-110b-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.20.1.1.9 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 16:44:36.501','2023-06-22 14:44:41.858',NULL),('4f2e1002-1bd0-11ee-9086-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_a6b1a4bd-1bcf-11ee-9086-a0510b46b473/occlusion_a6b491c8-1bcf-11ee-9086-a0510b46b473/scan_120f2752-1bd0-11ee-9086-a0510b46b473/4f2e1002-1bd0-11ee-9086-a0510b46b473.zip','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_a6b1a4bd-1bcf-11ee-9086-a0510b46b473_SESS_a6b491c8-1bcf-11ee-9086-a0510b46b473_TOSC_120f2752-1bd0-11ee-9086-a0510b46b473_MODEL','4f2e1002-1bd0-11ee-9086-a0510b46b473.zip','4f2e1002-1bd0-11ee-9086-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.3.1.2\",\"modelMatrix\":\"-0.556147,0.825686,-0.0945742,0,-0.831084,-0.552534,0.0632873,0,-5.05067e-09,0.113796,0.993504,0,-10.3748,-29.0516,-7.22434,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 09:39:59.063','2023-07-06 07:39:59.783',NULL),('4f2e27ce-1bd0-11ee-9086-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_a6b1a4bd-1bcf-11ee-9086-a0510b46b473/occlusion_a6b491c8-1bcf-11ee-9086-a0510b46b473/scan_120f2752-1bd0-11ee-9086-a0510b46b473/4f2e27ce-1bd0-11ee-9086-a0510b46b473.png','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_a6b1a4bd-1bcf-11ee-9086-a0510b46b473_SESS_a6b491c8-1bcf-11ee-9086-a0510b46b473_TOSC_120f2752-1bd0-11ee-9086-a0510b46b473_SNAPS','4f2e27ce-1bd0-11ee-9086-a0510b46b473.png','4f2e27ce-1bd0-11ee-9086-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.3.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 09:39:59.063','2023-07-06 07:39:59.792',NULL),('4f8eb88b-de97-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/35e16a68-de95-11ed-9cc3-00d86184ce3d/session_450c29ef-de95-11ed-9cc3-00d86184ce3d/occlusion_450efda8-de95-11ed-9cc3-00d86184ce3d/scan_eff7beb3-de96-11ed-9cc3-00d86184ce3d/4f8eb88b-de97-11ed-9cc3-00d86184ce3d.zip','PATIENT_35e16a68-de95-11ed-9cc3-00d86184ce3d_ACT_450c29ef-de95-11ed-9cc3-00d86184ce3d_SESS_450efda8-de95-11ed-9cc3-00d86184ce3d_TOSC_eff7beb3-de96-11ed-9cc3-00d86184ce3d_MODEL','4f8eb88b-de97-11ed-9cc3-00d86184ce3d.zip','4f8eb88b-de97-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.4.1.1.2\",\"modelMatrix\":\"-0.201055,0.928182,-0.313138,0,-0.97958,-0.190506,0.0642703,0,2.91559e-10,0.319665,0.947531,0,-17.2394,-25.2388,-6.93667,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-19 11:48:17.453','2023-04-19 09:48:18.619',NULL),('4f8ed0b3-de97-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/35e16a68-de95-11ed-9cc3-00d86184ce3d/session_450c29ef-de95-11ed-9cc3-00d86184ce3d/occlusion_450efda8-de95-11ed-9cc3-00d86184ce3d/scan_eff7beb3-de96-11ed-9cc3-00d86184ce3d/4f8ed0b3-de97-11ed-9cc3-00d86184ce3d.png','PATIENT_35e16a68-de95-11ed-9cc3-00d86184ce3d_ACT_450c29ef-de95-11ed-9cc3-00d86184ce3d_SESS_450efda8-de95-11ed-9cc3-00d86184ce3d_TOSC_eff7beb3-de96-11ed-9cc3-00d86184ce3d_SNAPS','4f8ed0b3-de97-11ed-9cc3-00d86184ce3d.png','4f8ed0b3-de97-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.4.1.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-19 11:48:17.454','2023-04-19 09:48:18.619',NULL),('4fb8db2a-10da-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/bd51960a-10d5-11ee-b636-a0510b46b473/session_c5e67f1c-10d5-11ee-b636-a0510b46b473/occlusion_c5e95a7b-10d5-11ee-b636-a0510b46b473/scan_f647fd1c-10d9-11ee-b636-a0510b46b473/4fb8db2a-10da-11ee-b636-a0510b46b473.zip','PATIENT_bd51960a-10d5-11ee-b636-a0510b46b473_ACT_c5e67f1c-10d5-11ee-b636-a0510b46b473_SESS_c5e95a7b-10d5-11ee-b636-a0510b46b473_TOSC_f647fd1c-10d9-11ee-b636-a0510b46b473_MODEL','4fb8db2a-10da-11ee-b636-a0510b46b473.zip','4fb8db2a-10da-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.17.1.1.6\",\"modelMatrix\":\"0.115673,0.9907,-0.0716415,0,-0.993287,0.115372,-0.00834302,0,3.38161e-10,0.0721257,0.997396,0,-17.403,-22.9113,-12.6879,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 10:53:52.149','2023-06-22 08:53:53.115',NULL),('4fb9519f-10da-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/bd51960a-10d5-11ee-b636-a0510b46b473/session_c5e67f1c-10d5-11ee-b636-a0510b46b473/occlusion_c5e95a7b-10d5-11ee-b636-a0510b46b473/scan_f647fd1c-10d9-11ee-b636-a0510b46b473/4fb9519f-10da-11ee-b636-a0510b46b473.png','PATIENT_bd51960a-10d5-11ee-b636-a0510b46b473_ACT_c5e67f1c-10d5-11ee-b636-a0510b46b473_SESS_c5e95a7b-10d5-11ee-b636-a0510b46b473_TOSC_f647fd1c-10d9-11ee-b636-a0510b46b473_SNAPS','4fb9519f-10da-11ee-b636-a0510b46b473.png','4fb9519f-10da-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.17.1.1.6 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 10:53:52.152','2023-06-22 08:53:53.122',NULL),('503b3e53-e020-11ed-a285-00d86184ce3d',11,'/home/scan/.data//2023/11/5f27680c-e01a-11ed-b6c2-00d86184ce3d/session_65b85f32-e01a-11ed-b6c2-00d86184ce3d/occlusion_65ba9a94-e01a-11ed-b6c2-00d86184ce3d/scan_11365db6-e020-11ed-a285-00d86184ce3d/503b3e53-e020-11ed-a285-00d86184ce3d.zip','PATIENT_5f27680c-e01a-11ed-b6c2-00d86184ce3d_ACT_65b85f32-e01a-11ed-b6c2-00d86184ce3d_SESS_65ba9a94-e01a-11ed-b6c2-00d86184ce3d_TOSC_11365db6-e020-11ed-a285-00d86184ce3d_MODEL','503b3e53-e020-11ed-a285-00d86184ce3d.zip','503b3e53-e020-11ed-a285-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.10.1.1.7\",\"modelMatrix\":\"0.695149,0.673109,-0.252374,0,-0.718866,0.650902,-0.244047,0,1.38457e-08,0.351072,0.936348,0,-29.0411,-11.3488,-6.58005,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 10:41:30.799','2023-04-21 08:41:31.639',NULL),('503b56af-e020-11ed-a285-00d86184ce3d',11,'/home/scan/.data//2023/11/5f27680c-e01a-11ed-b6c2-00d86184ce3d/session_65b85f32-e01a-11ed-b6c2-00d86184ce3d/occlusion_65ba9a94-e01a-11ed-b6c2-00d86184ce3d/scan_11365db6-e020-11ed-a285-00d86184ce3d/503b56af-e020-11ed-a285-00d86184ce3d.png','PATIENT_5f27680c-e01a-11ed-b6c2-00d86184ce3d_ACT_65b85f32-e01a-11ed-b6c2-00d86184ce3d_SESS_65ba9a94-e01a-11ed-b6c2-00d86184ce3d_TOSC_11365db6-e020-11ed-a285-00d86184ce3d_SNAPS','503b56af-e020-11ed-a285-00d86184ce3d.png','503b56af-e020-11ed-a285-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.10.1.1.7 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 10:41:30.799','2023-04-21 08:41:31.639',NULL),('506502d8-e028-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_ed85304d-e024-11ed-bb13-00d86184ce3d/occlusion_ed88a64f-e024-11ed-bb13-00d86184ce3d/scan_04c3bf10-e028-11ed-bb13-00d86184ce3d/506502d8-e028-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_ed85304d-e024-11ed-bb13-00d86184ce3d_SESS_ed88a64f-e024-11ed-bb13-00d86184ce3d_TOSC_04c3bf10-e028-11ed-bb13-00d86184ce3d_MODEL','506502d8-e028-11ed-bb13-00d86184ce3d.zip','506502d8-e028-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.1.1.4\",\"modelMatrix\":\"-0.117879,0.976959,-0.17792,0,-0.993028,-0.115971,0.0211202,0,2.75964e-09,0.179169,0.983818,0,-14.0642,-29.7947,-7.61861,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 11:38:47.046','2023-04-21 09:38:47.851',NULL),('50663b68-e028-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_ed85304d-e024-11ed-bb13-00d86184ce3d/occlusion_ed88a64f-e024-11ed-bb13-00d86184ce3d/scan_04c3bf10-e028-11ed-bb13-00d86184ce3d/50663b68-e028-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_ed85304d-e024-11ed-bb13-00d86184ce3d_SESS_ed88a64f-e024-11ed-bb13-00d86184ce3d_TOSC_04c3bf10-e028-11ed-bb13-00d86184ce3d_SNAPS','50663b68-e028-11ed-bb13-00d86184ce3d.png','50663b68-e028-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.1.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 11:38:47.054','2023-04-21 09:38:47.851',NULL),('50f72fcb-14c7-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/9619fcac-14c3-11ee-b3b1-00d86184ce3d/session_961b9a11-14c3-11ee-b3b1-00d86184ce3d/occlusion_961d56b4-14c3-11ee-b3b1-00d86184ce3d/scan_ee67f7e8-14c6-11ee-b3b1-00d86184ce3d/50f72fcb-14c7-11ee-b3b1-00d86184ce3d.zip','PATIENT_9619fcac-14c3-11ee-b3b1-00d86184ce3d_ACT_961b9a11-14c3-11ee-b3b1-00d86184ce3d_SESS_961d56b4-14c3-11ee-b3b1-00d86184ce3d_TOSC_ee67f7e8-14c6-11ee-b3b1-00d86184ce3d_MODEL','50f72fcb-14c7-11ee-b3b1-00d86184ce3d.zip','50f72fcb-14c7-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.22.1.1.3\",\"modelMatrix\":\"0.751923,0.637324,-0.168611,0,-0.659251,0.726914,-0.192313,0,-1.56932e-09,0.255761,0.96674,0,-31.1829,-10.769,-9.6344,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-27 10:47:58.448','2023-06-27 08:47:59.232',NULL),('50f76350-14c7-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/9619fcac-14c3-11ee-b3b1-00d86184ce3d/session_961b9a11-14c3-11ee-b3b1-00d86184ce3d/occlusion_961d56b4-14c3-11ee-b3b1-00d86184ce3d/scan_ee67f7e8-14c6-11ee-b3b1-00d86184ce3d/50f76350-14c7-11ee-b3b1-00d86184ce3d.png','PATIENT_9619fcac-14c3-11ee-b3b1-00d86184ce3d_ACT_961b9a11-14c3-11ee-b3b1-00d86184ce3d_SESS_961d56b4-14c3-11ee-b3b1-00d86184ce3d_TOSC_ee67f7e8-14c6-11ee-b3b1-00d86184ce3d_SNAPS','50f76350-14c7-11ee-b3b1-00d86184ce3d.png','50f76350-14c7-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.22.1.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-27 10:47:58.450','2023-06-27 08:47:59.233',NULL),('512736f3-2709-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_c28d11f3-2706-11ee-a98e-a0510b46b473/occlusion_c2900beb-2706-11ee-a98e-a0510b46b473/scan_f054f70f-2708-11ee-a98e-a0510b46b473/512736f3-2709-11ee-a98e-a0510b46b473.zip','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_c28d11f3-2706-11ee-a98e-a0510b46b473_SESS_c2900beb-2706-11ee-a98e-a0510b46b473_TOSC_f054f70f-2708-11ee-a98e-a0510b46b473_MODEL','512736f3-2709-11ee-a98e-a0510b46b473.zip','512736f3-2709-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.3.1.3\",\"modelMatrix\":\"0.940252,0.339125,-0.0303389,0,-0.340479,0.936512,-0.0837826,0,-2.08932e-09,0.0891066,0.996022,0,-24.7915,9.07286,-13.5702,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-20 16:25:46.477','2023-07-20 14:25:47.247',NULL),('51274f12-2709-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_c28d11f3-2706-11ee-a98e-a0510b46b473/occlusion_c2900beb-2706-11ee-a98e-a0510b46b473/scan_f054f70f-2708-11ee-a98e-a0510b46b473/51274f12-2709-11ee-a98e-a0510b46b473.png','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_c28d11f3-2706-11ee-a98e-a0510b46b473_SESS_c2900beb-2706-11ee-a98e-a0510b46b473_TOSC_f054f70f-2708-11ee-a98e-a0510b46b473_SNAPS','51274f12-2709-11ee-a98e-a0510b46b473.png','51274f12-2709-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.3.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-20 16:25:46.478','2023-07-20 14:25:47.255',NULL),('5179d765-26fe-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/848c86d9-26fd-11ee-a98e-a0510b46b473/session_8f62cd50-26fd-11ee-a98e-a0510b46b473/occlusion_8f65e2e0-26fd-11ee-a98e-a0510b46b473/scan_f211379a-26fd-11ee-a98e-a0510b46b473/5179d765-26fe-11ee-a98e-a0510b46b473.zip','PATIENT_848c86d9-26fd-11ee-a98e-a0510b46b473_ACT_8f62cd50-26fd-11ee-a98e-a0510b46b473_SESS_8f65e2e0-26fd-11ee-a98e-a0510b46b473_TOSC_f211379a-26fd-11ee-a98e-a0510b46b473_MODEL','5179d765-26fe-11ee-a98e-a0510b46b473.zip','5179d765-26fe-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.36.1.1.2\",\"modelMatrix\":\"0.34749,0.919889,-0.181808,0,-0.937684,0.340895,-0.0673751,0,2.99805e-09,0.193891,0.981023,0,-23.6628,-17.2687,-10.3461,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-20 15:07:02.555','2023-07-20 13:07:03.322',NULL),('517b3818-26fe-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/848c86d9-26fd-11ee-a98e-a0510b46b473/session_8f62cd50-26fd-11ee-a98e-a0510b46b473/occlusion_8f65e2e0-26fd-11ee-a98e-a0510b46b473/scan_f211379a-26fd-11ee-a98e-a0510b46b473/517b3818-26fe-11ee-a98e-a0510b46b473.png','PATIENT_848c86d9-26fd-11ee-a98e-a0510b46b473_ACT_8f62cd50-26fd-11ee-a98e-a0510b46b473_SESS_8f65e2e0-26fd-11ee-a98e-a0510b46b473_TOSC_f211379a-26fd-11ee-a98e-a0510b46b473_SNAPS','517b3818-26fe-11ee-a98e-a0510b46b473.png','517b3818-26fe-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.36.1.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-20 15:07:02.564','2023-07-20 13:07:03.323',NULL),('51d9b7fc-df8d-11ed-b6c2-00d86184ce3d',11,'/home/scan/.data//2023/11/ce063c89-df8b-11ed-b6c2-00d86184ce3d/session_d5081c73-df8b-11ed-b6c2-00d86184ce3d/occlusion_d50b8b0c-df8b-11ed-b6c2-00d86184ce3d/scan_08053bdb-df8d-11ed-b6c2-00d86184ce3d/51d9b7fc-df8d-11ed-b6c2-00d86184ce3d.zip','PATIENT_ce063c89-df8b-11ed-b6c2-00d86184ce3d_ACT_d5081c73-df8b-11ed-b6c2-00d86184ce3d_SESS_d50b8b0c-df8b-11ed-b6c2-00d86184ce3d_TOSC_08053bdb-df8d-11ed-b6c2-00d86184ce3d_MODEL','51d9b7fc-df8d-11ed-b6c2-00d86184ce3d.zip','51d9b7fc-df8d-11ed-b6c2-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.9.1.1.3\",\"modelMatrix\":\"0.549878,0.761454,-0.343254,0,-0.835245,0.501297,-0.225979,0,-6.32093e-10,0.410962,0.911652,0,-27.2123,-14.618,-6.57767,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-20 17:09:17.496','2023-04-20 15:09:18.210',NULL),('51d9e158-df8d-11ed-b6c2-00d86184ce3d',11,'/home/scan/.data//2023/11/ce063c89-df8b-11ed-b6c2-00d86184ce3d/session_d5081c73-df8b-11ed-b6c2-00d86184ce3d/occlusion_d50b8b0c-df8b-11ed-b6c2-00d86184ce3d/scan_08053bdb-df8d-11ed-b6c2-00d86184ce3d/51d9e158-df8d-11ed-b6c2-00d86184ce3d.png','PATIENT_ce063c89-df8b-11ed-b6c2-00d86184ce3d_ACT_d5081c73-df8b-11ed-b6c2-00d86184ce3d_SESS_d50b8b0c-df8b-11ed-b6c2-00d86184ce3d_TOSC_08053bdb-df8d-11ed-b6c2-00d86184ce3d_SNAPS','51d9e158-df8d-11ed-b6c2-00d86184ce3d.png','51d9e158-df8d-11ed-b6c2-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.9.1.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-20 17:09:17.497','2023-04-20 15:09:18.211',NULL),('52a89687-e351-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/6175c1d5-e350-11ed-8c5e-00d86184ce3d/session_71ba03b6-e350-11ed-8c5e-00d86184ce3d/occlusion_71bbf096-e350-11ed-8c5e-00d86184ce3d/scan_0385ac49-e351-11ed-8c5e-00d86184ce3d/52a89687-e351-11ed-8c5e-00d86184ce3d.zip','PATIENT_6175c1d5-e350-11ed-8c5e-00d86184ce3d_ACT_71ba03b6-e350-11ed-8c5e-00d86184ce3d_SESS_71bbf096-e350-11ed-8c5e-00d86184ce3d_TOSC_0385ac49-e351-11ed-8c5e-00d86184ce3d_MODEL','52a89687-e351-11ed-8c5e-00d86184ce3d.zip','52a89687-e351-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.13.1.1.3\",\"modelMatrix\":\"0.718456,0.663799,-0.207827,0,-0.695572,0.685637,-0.214665,0,5.65003e-09,0.298786,0.95432,0,-32.3755,2.85205,-6.78815,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-25 12:09:53.699','2023-04-25 10:09:54.696',NULL),('52a8b645-e351-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/6175c1d5-e350-11ed-8c5e-00d86184ce3d/session_71ba03b6-e350-11ed-8c5e-00d86184ce3d/occlusion_71bbf096-e350-11ed-8c5e-00d86184ce3d/scan_0385ac49-e351-11ed-8c5e-00d86184ce3d/52a8b645-e351-11ed-8c5e-00d86184ce3d.png','PATIENT_6175c1d5-e350-11ed-8c5e-00d86184ce3d_ACT_71ba03b6-e350-11ed-8c5e-00d86184ce3d_SESS_71bbf096-e350-11ed-8c5e-00d86184ce3d_TOSC_0385ac49-e351-11ed-8c5e-00d86184ce3d_SNAPS','52a8b645-e351-11ed-8c5e-00d86184ce3d.png','52a8b645-e351-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.13.1.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-25 12:09:53.699','2023-04-25 10:09:54.697',NULL),('532db949-df84-11ed-b6c2-00d86184ce3d',11,'/home/scan/.data//2023/11/ee09109f-df83-11ed-b6c2-00d86184ce3d/session_f3d790be-df83-11ed-b6c2-00d86184ce3d/occlusion_f3d9f61c-df83-11ed-b6c2-00d86184ce3d/scan_f50b91a8-df83-11ed-b6c2-00d86184ce3d/532db949-df84-11ed-b6c2-00d86184ce3d.zip','PATIENT_ee09109f-df83-11ed-b6c2-00d86184ce3d_ACT_f3d790be-df83-11ed-b6c2-00d86184ce3d_SESS_f3d9f61c-df83-11ed-b6c2-00d86184ce3d_TOSC_f50b91a8-df83-11ed-b6c2-00d86184ce3d_MODEL','532db949-df84-11ed-b6c2-00d86184ce3d.zip','532db949-df84-11ed-b6c2-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.8.1.1.1\",\"modelMatrix\":\"0.40454,0.798826,-0.445224,0,-0.91452,0.353362,-0.196945,0,6.35684e-09,0.486838,0.873492,0,-21.0901,-22.4335,-3.96029,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-20 16:04:54.253','2023-04-20 14:04:55.166',NULL),('532dcbb5-df84-11ed-b6c2-00d86184ce3d',11,'/home/scan/.data//2023/11/ee09109f-df83-11ed-b6c2-00d86184ce3d/session_f3d790be-df83-11ed-b6c2-00d86184ce3d/occlusion_f3d9f61c-df83-11ed-b6c2-00d86184ce3d/scan_f50b91a8-df83-11ed-b6c2-00d86184ce3d/532dcbb5-df84-11ed-b6c2-00d86184ce3d.png','PATIENT_ee09109f-df83-11ed-b6c2-00d86184ce3d_ACT_f3d790be-df83-11ed-b6c2-00d86184ce3d_SESS_f3d9f61c-df83-11ed-b6c2-00d86184ce3d_TOSC_f50b91a8-df83-11ed-b6c2-00d86184ce3d_SNAPS','532dcbb5-df84-11ed-b6c2-00d86184ce3d.png','532dcbb5-df84-11ed-b6c2-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.8.1.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-20 16:04:54.254','2023-04-20 14:04:55.166',NULL),('53a76fa9-1bff-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/8a8cc548-1bf9-11ee-9323-a0510b46b473/session_976f015a-1bf9-11ee-9323-a0510b46b473/occlusion_97713d19-1bf9-11ee-9323-a0510b46b473/scan_fb8c1d77-1bfe-11ee-9323-a0510b46b473/53a76fa9-1bff-11ee-9323-a0510b46b473.zip','PATIENT_8a8cc548-1bf9-11ee-9323-a0510b46b473_ACT_976f015a-1bf9-11ee-9323-a0510b46b473_SESS_97713d19-1bf9-11ee-9323-a0510b46b473_TOSC_fb8c1d77-1bfe-11ee-9323-a0510b46b473_MODEL','53a76fa9-1bff-11ee-9323-a0510b46b473.zip','53a76fa9-1bff-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.28.1.1.10\",\"modelMatrix\":\"-0.438962,0.887768,-0.138497,0,-0.898506,-0.433716,0.0676621,0,-4.11432e-09,0.154141,0.988049,0,-5.97594,-32.4081,-9.39951,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 15:16:32.915','2023-07-06 13:16:33.732',NULL),('53a8b1c5-1bff-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/8a8cc548-1bf9-11ee-9323-a0510b46b473/session_976f015a-1bf9-11ee-9323-a0510b46b473/occlusion_97713d19-1bf9-11ee-9323-a0510b46b473/scan_fb8c1d77-1bfe-11ee-9323-a0510b46b473/53a8b1c5-1bff-11ee-9323-a0510b46b473.png','PATIENT_8a8cc548-1bf9-11ee-9323-a0510b46b473_ACT_976f015a-1bf9-11ee-9323-a0510b46b473_SESS_97713d19-1bf9-11ee-9323-a0510b46b473_TOSC_fb8c1d77-1bfe-11ee-9323-a0510b46b473_SNAPS','53a8b1c5-1bff-11ee-9323-a0510b46b473.png','53a8b1c5-1bff-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.28.1.1.10 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 15:16:32.923','2023-07-06 13:16:33.742',NULL),('53c64db0-15b8-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/142e7037-15b6-11ee-b3b1-00d86184ce3d/session_1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d/occlusion_1ed7780a-15b6-11ee-b3b1-00d86184ce3d/scan_ff42d887-15b7-11ee-b3b1-00d86184ce3d/53c64db0-15b8-11ee-b3b1-00d86184ce3d.zip','PATIENT_142e7037-15b6-11ee-b3b1-00d86184ce3d_ACT_1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d_SESS_1ed7780a-15b6-11ee-b3b1-00d86184ce3d_TOSC_ff42d887-15b7-11ee-b3b1-00d86184ce3d_MODEL','53c64db0-15b8-11ee-b3b1-00d86184ce3d.zip','53c64db0-15b8-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.25.1.1.6\",\"modelMatrix\":\"0.412421,0.904005,-0.112622,0,-0.910993,0.409258,-0.0509857,0,3.12436e-09,0.123625,0.992329,0,-29.0196,-16.5321,-9.3904,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-28 15:33:11.873','2023-06-28 13:33:12.688',NULL),('53c6bf87-15b8-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/142e7037-15b6-11ee-b3b1-00d86184ce3d/session_1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d/occlusion_1ed7780a-15b6-11ee-b3b1-00d86184ce3d/scan_ff42d887-15b7-11ee-b3b1-00d86184ce3d/53c6bf87-15b8-11ee-b3b1-00d86184ce3d.png','PATIENT_142e7037-15b6-11ee-b3b1-00d86184ce3d_ACT_1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d_SESS_1ed7780a-15b6-11ee-b3b1-00d86184ce3d_TOSC_ff42d887-15b7-11ee-b3b1-00d86184ce3d_SNAPS','53c6bf87-15b8-11ee-b3b1-00d86184ce3d.png','53c6bf87-15b8-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.25.1.1.6 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-28 15:33:11.876','2023-06-28 13:33:12.688',NULL),('53f83392-e34a-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/971e14b0-e348-11ed-8c5e-00d86184ce3d/session_a0fbda94-e348-11ed-8c5e-00d86184ce3d/occlusion_a0febadb-e348-11ed-8c5e-00d86184ce3d/scan_07ef2822-e34a-11ed-8c5e-00d86184ce3d/53f83392-e34a-11ed-8c5e-00d86184ce3d.zip','PATIENT_971e14b0-e348-11ed-8c5e-00d86184ce3d_ACT_a0fbda94-e348-11ed-8c5e-00d86184ce3d_SESS_a0febadb-e348-11ed-8c5e-00d86184ce3d_TOSC_07ef2822-e34a-11ed-8c5e-00d86184ce3d_MODEL','53f83392-e34a-11ed-8c5e-00d86184ce3d.zip','53f83392-e34a-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.12.1.1.5\",\"modelMatrix\":\"0.126574,0.944544,-0.303013,0,-0.991957,0.120524,-0.0386645,0,8.54142e-10,0.30547,0.952202,0,-26.6122,-20.349,-7.47915,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-25 11:19:49.421','2023-04-25 09:19:50.302',NULL),('53f8ad8e-e34a-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/971e14b0-e348-11ed-8c5e-00d86184ce3d/session_a0fbda94-e348-11ed-8c5e-00d86184ce3d/occlusion_a0febadb-e348-11ed-8c5e-00d86184ce3d/scan_07ef2822-e34a-11ed-8c5e-00d86184ce3d/53f8ad8e-e34a-11ed-8c5e-00d86184ce3d.png','PATIENT_971e14b0-e348-11ed-8c5e-00d86184ce3d_ACT_a0fbda94-e348-11ed-8c5e-00d86184ce3d_SESS_a0febadb-e348-11ed-8c5e-00d86184ce3d_TOSC_07ef2822-e34a-11ed-8c5e-00d86184ce3d_SNAPS','53f8ad8e-e34a-11ed-8c5e-00d86184ce3d.png','53f8ad8e-e34a-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.12.1.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-25 11:19:49.424','2023-04-25 09:19:50.302',NULL),('54256fcf-26e7-11ee-aa9d-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_d5ef2d6b-26e3-11ee-a836-a0510b46b473/occlusion_d5f241c9-26e3-11ee-a836-a0510b46b473/scan_0674de77-26e7-11ee-aa9d-a0510b46b473/54256fcf-26e7-11ee-aa9d-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_d5ef2d6b-26e3-11ee-a836-a0510b46b473_SESS_d5f241c9-26e3-11ee-a836-a0510b46b473_BOSC_0674de77-26e7-11ee-aa9d-a0510b46b473_MODEL','54256fcf-26e7-11ee-aa9d-a0510b46b473.zip','54256fcf-26e7-11ee-aa9d-a0510b46b473','{\"displayTitle\":\"Mandibule 1.30.5.1.3\",\"modelMatrix\":\"0.23616,0.934853,-0.265102,0,-0.971714,0.227201,-0.0644289,0,-4.17864e-10,0.272819,0.962066,0,-22.5284,-26.6693,-9.38841,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-20 12:22:28.610','2023-07-20 10:22:29.313',NULL),('542586a4-26e7-11ee-aa9d-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_d5ef2d6b-26e3-11ee-a836-a0510b46b473/occlusion_d5f241c9-26e3-11ee-a836-a0510b46b473/scan_0674de77-26e7-11ee-aa9d-a0510b46b473/542586a4-26e7-11ee-aa9d-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_d5ef2d6b-26e3-11ee-a836-a0510b46b473_SESS_d5f241c9-26e3-11ee-a836-a0510b46b473_BOSC_0674de77-26e7-11ee-aa9d-a0510b46b473_SNAPS','542586a4-26e7-11ee-aa9d-a0510b46b473.png','542586a4-26e7-11ee-aa9d-a0510b46b473','{\"displayTitle\":\"Mandibule 1.30.5.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-20 12:22:28.611','2023-07-20 10:22:29.321',NULL),('5428a17c-1bdc-11ee-9086-a0510b46b473',11,'/home/scan/.data//2023/11/61e16a70-1a76-11ee-8124-a0510b46b473/session_d30b0955-1bdb-11ee-9086-a0510b46b473/occlusion_d30df7f0-1bdb-11ee-9086-a0510b46b473/scan_20ae1b09-1bdc-11ee-9086-a0510b46b473/5428a17c-1bdc-11ee-9086-a0510b46b473.zip','PATIENT_61e16a70-1a76-11ee-8124-a0510b46b473_ACT_d30b0955-1bdb-11ee-9086-a0510b46b473_SESS_d30df7f0-1bdb-11ee-9086-a0510b46b473_TOSC_20ae1b09-1bdc-11ee-9086-a0510b46b473_MODEL','5428a17c-1bdc-11ee-9086-a0510b46b473.zip','5428a17c-1bdc-11ee-9086-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.27.4.1.2\",\"modelMatrix\":\"0.988862,0.136466,-0.0594128,0,-0.148838,0.906661,-0.394731,0,-2.43385e-09,0.399177,0.916874,0,-24.5204,23.1016,-11.404,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 11:06:01.376','2023-07-06 09:06:01.774',NULL),('5428b776-1bdc-11ee-9086-a0510b46b473',11,'/home/scan/.data//2023/11/61e16a70-1a76-11ee-8124-a0510b46b473/session_d30b0955-1bdb-11ee-9086-a0510b46b473/occlusion_d30df7f0-1bdb-11ee-9086-a0510b46b473/scan_20ae1b09-1bdc-11ee-9086-a0510b46b473/5428b776-1bdc-11ee-9086-a0510b46b473.png','PATIENT_61e16a70-1a76-11ee-8124-a0510b46b473_ACT_d30b0955-1bdb-11ee-9086-a0510b46b473_SESS_d30df7f0-1bdb-11ee-9086-a0510b46b473_TOSC_20ae1b09-1bdc-11ee-9086-a0510b46b473_SNAPS','5428b776-1bdc-11ee-9086-a0510b46b473.png','5428b776-1bdc-11ee-9086-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.27.4.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 11:06:01.377','2023-07-06 09:06:01.777',NULL),('54654071-1caf-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/4375c5f1-1cad-11ee-997b-a0510b46b473/session_4a5f2876-1cad-11ee-997b-a0510b46b473/occlusion_4a624109-1cad-11ee-997b-a0510b46b473/scan_d423eff6-1cae-11ee-997b-a0510b46b473/54654071-1caf-11ee-997b-a0510b46b473.zip','PATIENT_4375c5f1-1cad-11ee-997b-a0510b46b473_ACT_4a5f2876-1cad-11ee-997b-a0510b46b473_SESS_4a624109-1cad-11ee-997b-a0510b46b473_TOSC_d423eff6-1cae-11ee-997b-a0510b46b473_MODEL','54654071-1caf-11ee-997b-a0510b46b473.zip','54654071-1caf-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.31.1.1.4\",\"modelMatrix\":\"0.675696,0.735197,-0.0540399,0,-0.73718,0.673878,-0.0495328,0,-6.30459e-10,0.0733063,0.997309,0,-30.3529,-8.8993,-11.9337,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-07 12:16:25.584','2023-07-07 10:16:26.541',NULL),('54655f44-1caf-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/4375c5f1-1cad-11ee-997b-a0510b46b473/session_4a5f2876-1cad-11ee-997b-a0510b46b473/occlusion_4a624109-1cad-11ee-997b-a0510b46b473/scan_d423eff6-1cae-11ee-997b-a0510b46b473/54655f44-1caf-11ee-997b-a0510b46b473.png','PATIENT_4375c5f1-1cad-11ee-997b-a0510b46b473_ACT_4a5f2876-1cad-11ee-997b-a0510b46b473_SESS_4a624109-1cad-11ee-997b-a0510b46b473_TOSC_d423eff6-1cae-11ee-997b-a0510b46b473_SNAPS','54655f44-1caf-11ee-997b-a0510b46b473.png','54655f44-1caf-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.31.1.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-07 12:16:25.584','2023-07-07 10:16:26.550',NULL),('55967ecc-1a7a-11ee-8124-a0510b46b473',11,'/home/scan/.data//2023/11/61e16a70-1a76-11ee-8124-a0510b46b473/session_c8578c2f-1a77-11ee-8124-a0510b46b473/occlusion_c85af2e9-1a77-11ee-8124-a0510b46b473/scan_f617d778-1a79-11ee-8124-a0510b46b473/55967ecc-1a7a-11ee-8124-a0510b46b473.zip','PATIENT_61e16a70-1a76-11ee-8124-a0510b46b473_ACT_c8578c2f-1a77-11ee-8124-a0510b46b473_SESS_c85af2e9-1a77-11ee-8124-a0510b46b473_TOSC_f617d778-1a79-11ee-8124-a0510b46b473_MODEL','55967ecc-1a7a-11ee-8124-a0510b46b473.zip','55967ecc-1a7a-11ee-8124-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.27.2.1.6\",\"modelMatrix\":\"0.677779,0.719436,-0.151747,0,-0.735266,0.663187,-0.139882,0,-6.33372e-09,0.206384,0.978471,0,-29.5043,-4.97142,-10.7097,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-04 16:52:01.932','2023-07-04 14:52:02.591',NULL),('55968ce0-1a7a-11ee-8124-a0510b46b473',11,'/home/scan/.data//2023/11/61e16a70-1a76-11ee-8124-a0510b46b473/session_c8578c2f-1a77-11ee-8124-a0510b46b473/occlusion_c85af2e9-1a77-11ee-8124-a0510b46b473/scan_f617d778-1a79-11ee-8124-a0510b46b473/55968ce0-1a7a-11ee-8124-a0510b46b473.png','PATIENT_61e16a70-1a76-11ee-8124-a0510b46b473_ACT_c8578c2f-1a77-11ee-8124-a0510b46b473_SESS_c85af2e9-1a77-11ee-8124-a0510b46b473_TOSC_f617d778-1a79-11ee-8124-a0510b46b473_SNAPS','55968ce0-1a7a-11ee-8124-a0510b46b473.png','55968ce0-1a7a-11ee-8124-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.27.2.1.6 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-04 16:52:01.932','2023-07-04 14:52:02.592',NULL),('563ca3ee-2700-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/848c86d9-26fd-11ee-a98e-a0510b46b473/session_8f62cd50-26fd-11ee-a98e-a0510b46b473/occlusion_8f65e2e0-26fd-11ee-a98e-a0510b46b473/scan_288ec454-2700-11ee-a98e-a0510b46b473/563ca3ee-2700-11ee-a98e-a0510b46b473.zip','PATIENT_848c86d9-26fd-11ee-a98e-a0510b46b473_ACT_8f62cd50-26fd-11ee-a98e-a0510b46b473_SESS_8f65e2e0-26fd-11ee-a98e-a0510b46b473_TOSC_288ec454-2700-11ee-a98e-a0510b46b473_MODEL','563ca3ee-2700-11ee-a98e-a0510b46b473.zip','563ca3ee-2700-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.36.1.1.6\",\"modelMatrix\":\"0.0752464,-0.982089,0.172738,0,0.997165,0.0741088,-0.0130349,0,6.91266e-10,0.173229,0.984881,0,9.30939,19.1582,-16.2887,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-20 15:21:29.536','2023-07-20 13:21:29.917',NULL),('563d229f-2700-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/848c86d9-26fd-11ee-a98e-a0510b46b473/session_8f62cd50-26fd-11ee-a98e-a0510b46b473/occlusion_8f65e2e0-26fd-11ee-a98e-a0510b46b473/scan_288ec454-2700-11ee-a98e-a0510b46b473/563d229f-2700-11ee-a98e-a0510b46b473.png','PATIENT_848c86d9-26fd-11ee-a98e-a0510b46b473_ACT_8f62cd50-26fd-11ee-a98e-a0510b46b473_SESS_8f65e2e0-26fd-11ee-a98e-a0510b46b473_TOSC_288ec454-2700-11ee-a98e-a0510b46b473_SNAPS','563d229f-2700-11ee-a98e-a0510b46b473.png','563d229f-2700-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.36.1.1.6 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-20 15:21:29.539','2023-07-20 13:21:29.921',NULL),('56403951-1cb1-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/4375c5f1-1cad-11ee-997b-a0510b46b473/session_dfb50528-1cb0-11ee-997b-a0510b46b473/occlusion_dfb7e00f-1cb0-11ee-997b-a0510b46b473/scan_17cddb0e-1cb1-11ee-997b-a0510b46b473/56403951-1cb1-11ee-997b-a0510b46b473.zip','PATIENT_4375c5f1-1cad-11ee-997b-a0510b46b473_ACT_dfb50528-1cb0-11ee-997b-a0510b46b473_SESS_dfb7e00f-1cb0-11ee-997b-a0510b46b473_TOSC_17cddb0e-1cb1-11ee-997b-a0510b46b473_MODEL','56403951-1cb1-11ee-997b-a0510b46b473.zip','56403951-1cb1-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.31.2.1.2\",\"modelMatrix\":\"0.950781,0.265484,-0.159791,0,-0.309863,0.814611,-0.4903,0,-5.42078e-09,0.515681,0.85678,0,-28.0116,7.22499,-11.3831,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-07 12:30:47.690','2023-07-07 10:30:48.186',NULL),('56405361-1cb1-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/4375c5f1-1cad-11ee-997b-a0510b46b473/session_dfb50528-1cb0-11ee-997b-a0510b46b473/occlusion_dfb7e00f-1cb0-11ee-997b-a0510b46b473/scan_17cddb0e-1cb1-11ee-997b-a0510b46b473/56405361-1cb1-11ee-997b-a0510b46b473.png','PATIENT_4375c5f1-1cad-11ee-997b-a0510b46b473_ACT_dfb50528-1cb0-11ee-997b-a0510b46b473_SESS_dfb7e00f-1cb0-11ee-997b-a0510b46b473_TOSC_17cddb0e-1cb1-11ee-997b-a0510b46b473_SNAPS','56405361-1cb1-11ee-997b-a0510b46b473.png','56405361-1cb1-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.31.2.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-07 12:30:47.691','2023-07-07 10:30:48.188',NULL),('572913ce-e02c-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_ed85304d-e024-11ed-bb13-00d86184ce3d/occlusion_ed88a64f-e024-11ed-bb13-00d86184ce3d/scan_1af0f921-e02c-11ed-bb13-00d86184ce3d/572913ce-e02c-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_ed85304d-e024-11ed-bb13-00d86184ce3d_SESS_ed88a64f-e024-11ed-bb13-00d86184ce3d_TOSC_1af0f921-e02c-11ed-bb13-00d86184ce3d_MODEL','572913ce-e02c-11ed-bb13-00d86184ce3d.zip','572913ce-e02c-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.1.1.10\",\"modelMatrix\":\"0.609528,0.776877,-0.157914,0,-0.792764,0.597313,-0.121415,0,-1.34947e-08,0.199195,0.97996,0,-30.3437,-1.01932,-10.4961,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 12:07:36.384','2023-04-21 10:07:37.057',NULL),('57292d59-e02c-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_ed85304d-e024-11ed-bb13-00d86184ce3d/occlusion_ed88a64f-e024-11ed-bb13-00d86184ce3d/scan_1af0f921-e02c-11ed-bb13-00d86184ce3d/57292d59-e02c-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_ed85304d-e024-11ed-bb13-00d86184ce3d_SESS_ed88a64f-e024-11ed-bb13-00d86184ce3d_TOSC_1af0f921-e02c-11ed-bb13-00d86184ce3d_SNAPS','57292d59-e02c-11ed-bb13-00d86184ce3d.png','57292d59-e02c-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.1.1.10 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 12:07:36.385','2023-04-21 10:07:37.057',NULL),('5749bbff-df8c-11ed-b6c2-00d86184ce3d',11,'/home/scan/.data//2023/11/ce063c89-df8b-11ed-b6c2-00d86184ce3d/session_d5081c73-df8b-11ed-b6c2-00d86184ce3d/occlusion_d50b8b0c-df8b-11ed-b6c2-00d86184ce3d/scan_1a89f0bf-df8c-11ed-b6c2-00d86184ce3d/5749bbff-df8c-11ed-b6c2-00d86184ce3d.zip','PATIENT_ce063c89-df8b-11ed-b6c2-00d86184ce3d_ACT_d5081c73-df8b-11ed-b6c2-00d86184ce3d_SESS_d50b8b0c-df8b-11ed-b6c2-00d86184ce3d_TOSC_1a89f0bf-df8c-11ed-b6c2-00d86184ce3d_MODEL','5749bbff-df8c-11ed-b6c2-00d86184ce3d.zip','5749bbff-df8c-11ed-b6c2-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.9.1.1.1\",\"modelMatrix\":\"0.274041,0.864684,-0.420979,0,-0.961718,0.246391,-0.119958,0,-1.72142e-09,0.437737,0.899103,0,-21.1774,-21.0072,-5.49752,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-20 17:02:17.122','2023-04-20 15:02:17.714',NULL),('5749d8f2-df8c-11ed-b6c2-00d86184ce3d',11,'/home/scan/.data//2023/11/ce063c89-df8b-11ed-b6c2-00d86184ce3d/session_d5081c73-df8b-11ed-b6c2-00d86184ce3d/occlusion_d50b8b0c-df8b-11ed-b6c2-00d86184ce3d/scan_1a89f0bf-df8c-11ed-b6c2-00d86184ce3d/5749d8f2-df8c-11ed-b6c2-00d86184ce3d.png','PATIENT_ce063c89-df8b-11ed-b6c2-00d86184ce3d_ACT_d5081c73-df8b-11ed-b6c2-00d86184ce3d_SESS_d50b8b0c-df8b-11ed-b6c2-00d86184ce3d_TOSC_1a89f0bf-df8c-11ed-b6c2-00d86184ce3d_SNAPS','5749d8f2-df8c-11ed-b6c2-00d86184ce3d.png','5749d8f2-df8c-11ed-b6c2-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.9.1.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-20 17:02:17.122','2023-04-20 15:02:17.715',NULL),('57b97360-2a39-11ee-9e90-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_b144ba33-2a36-11ee-9e90-a0510b46b473/occlusion_b147bba1-2a36-11ee-9e90-a0510b46b473/scan_112daefc-2a39-11ee-9e90-a0510b46b473/57b97360-2a39-11ee-9e90-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_b144ba33-2a36-11ee-9e90-a0510b46b473_SESS_b147bba1-2a36-11ee-9e90-a0510b46b473_TOSC_112daefc-2a39-11ee-9e90-a0510b46b473_MODEL','57b97360-2a39-11ee-9e90-a0510b46b473.zip','57b97360-2a39-11ee-9e90-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.6.1.3\",\"modelMatrix\":\"0.966429,0.183193,-0.180152,0,-0.256933,0.689063,-0.677626,0,-7.96728e-09,0.701165,0.712999,0,-16.8627,9.45787,-11.8839,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-24 17:47:06.833','2023-07-24 15:47:07.399',NULL),('57b98ac3-2a39-11ee-9e90-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_b144ba33-2a36-11ee-9e90-a0510b46b473/occlusion_b147bba1-2a36-11ee-9e90-a0510b46b473/scan_112daefc-2a39-11ee-9e90-a0510b46b473/57b98ac3-2a39-11ee-9e90-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_b144ba33-2a36-11ee-9e90-a0510b46b473_SESS_b147bba1-2a36-11ee-9e90-a0510b46b473_TOSC_112daefc-2a39-11ee-9e90-a0510b46b473_SNAPS','57b98ac3-2a39-11ee-9e90-a0510b46b473.png','57b98ac3-2a39-11ee-9e90-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.6.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-24 17:47:06.834','2023-07-24 15:47:07.402',NULL),('5803d634-2ae1-11ee-95bc-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_b5fe1002-2ae0-11ee-95bc-a0510b46b473/occlusion_b6012772-2ae0-11ee-95bc-a0510b46b473/scan_0f669f5c-2ae1-11ee-95bc-a0510b46b473/5803d634-2ae1-11ee-95bc-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_b5fe1002-2ae0-11ee-95bc-a0510b46b473_SESS_b6012772-2ae0-11ee-95bc-a0510b46b473_TOSC_0f669f5c-2ae1-11ee-95bc-a0510b46b473_MODEL','5803d634-2ae1-11ee-95bc-a0510b46b473.zip','5803d634-2ae1-11ee-95bc-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.8.1.1\",\"modelMatrix\":\"0.256529,0.955953,-0.142642,0,-0.966537,0.25372,-0.0378587,0,2.65675e-09,0.147581,0.98905,0,-24.0455,-20.2252,-9.27945,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-25 13:49:42.771','2023-07-25 11:49:43.293',NULL),('5803ef0b-2ae1-11ee-95bc-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_b5fe1002-2ae0-11ee-95bc-a0510b46b473/occlusion_b6012772-2ae0-11ee-95bc-a0510b46b473/scan_0f669f5c-2ae1-11ee-95bc-a0510b46b473/5803ef0b-2ae1-11ee-95bc-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_b5fe1002-2ae0-11ee-95bc-a0510b46b473_SESS_b6012772-2ae0-11ee-95bc-a0510b46b473_TOSC_0f669f5c-2ae1-11ee-95bc-a0510b46b473_SNAPS','5803ef0b-2ae1-11ee-95bc-a0510b46b473.png','5803ef0b-2ae1-11ee-95bc-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.8.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-25 13:49:42.772','2023-07-25 11:49:43.295',NULL),('594c8223-df7f-11ed-b6c2-00d86184ce3d',11,'/home/scan/.data//2023/11/e0d449f3-dde9-11ed-aa56-00d86184ce3d/session_858fcc60-de94-11ed-9cc3-00d86184ce3d/occlusion_85925fd9-de94-11ed-9cc3-00d86184ce3d/scan_082bb3fc-df7f-11ed-b6c2-00d86184ce3d/594c8223-df7f-11ed-b6c2-00d86184ce3d.zip','PATIENT_e0d449f3-dde9-11ed-aa56-00d86184ce3d_ACT_858fcc60-de94-11ed-9cc3-00d86184ce3d_SESS_85925fd9-de94-11ed-9cc3-00d86184ce3d_TOSC_082bb3fc-df7f-11ed-b6c2-00d86184ce3d_MODEL','594c8223-df7f-11ed-b6c2-00d86184ce3d.zip','594c8223-df7f-11ed-b6c2-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.2.1.1.6\",\"modelMatrix\":\"0.574116,0.762717,-0.297746,0,-0.818774,0.53481,-0.208777,0,1.22311e-09,0.363649,0.931536,0,-25.3383,-13.6578,-7.99415,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-20 15:29:17.038','2023-04-20 13:29:17.767',NULL),('594caf3a-df7f-11ed-b6c2-00d86184ce3d',11,'/home/scan/.data//2023/11/e0d449f3-dde9-11ed-aa56-00d86184ce3d/session_858fcc60-de94-11ed-9cc3-00d86184ce3d/occlusion_85925fd9-de94-11ed-9cc3-00d86184ce3d/scan_082bb3fc-df7f-11ed-b6c2-00d86184ce3d/594caf3a-df7f-11ed-b6c2-00d86184ce3d.png','PATIENT_e0d449f3-dde9-11ed-aa56-00d86184ce3d_ACT_858fcc60-de94-11ed-9cc3-00d86184ce3d_SESS_85925fd9-de94-11ed-9cc3-00d86184ce3d_TOSC_082bb3fc-df7f-11ed-b6c2-00d86184ce3d_SNAPS','594caf3a-df7f-11ed-b6c2-00d86184ce3d.png','594caf3a-df7f-11ed-b6c2-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.2.1.1.6 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-20 15:29:17.039','2023-04-20 13:29:17.776',NULL),('59d72293-e352-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/6175c1d5-e350-11ed-8c5e-00d86184ce3d/session_71ba03b6-e350-11ed-8c5e-00d86184ce3d/occlusion_71bbf096-e350-11ed-8c5e-00d86184ce3d/scan_05b43523-e352-11ed-8c5e-00d86184ce3d/59d72293-e352-11ed-8c5e-00d86184ce3d.zip','PATIENT_6175c1d5-e350-11ed-8c5e-00d86184ce3d_ACT_71ba03b6-e350-11ed-8c5e-00d86184ce3d_SESS_71bbf096-e350-11ed-8c5e-00d86184ce3d_TOSC_05b43523-e352-11ed-8c5e-00d86184ce3d_MODEL','59d72293-e352-11ed-8c5e-00d86184ce3d.zip','59d72293-e352-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.13.1.1.6\",\"modelMatrix\":\"0.184699,0.903503,-0.386741,0,-0.982795,0.169797,-0.0726811,0,7.128e-10,0.393511,0.91932,0,-26.877,-16.7953,-7.07513,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-25 12:17:15.245','2023-04-25 10:17:16.413',NULL),('59d742d6-e352-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/6175c1d5-e350-11ed-8c5e-00d86184ce3d/session_71ba03b6-e350-11ed-8c5e-00d86184ce3d/occlusion_71bbf096-e350-11ed-8c5e-00d86184ce3d/scan_05b43523-e352-11ed-8c5e-00d86184ce3d/59d742d6-e352-11ed-8c5e-00d86184ce3d.png','PATIENT_6175c1d5-e350-11ed-8c5e-00d86184ce3d_ACT_71ba03b6-e350-11ed-8c5e-00d86184ce3d_SESS_71bbf096-e350-11ed-8c5e-00d86184ce3d_TOSC_05b43523-e352-11ed-8c5e-00d86184ce3d_SNAPS','59d742d6-e352-11ed-8c5e-00d86184ce3d.png','59d742d6-e352-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.13.1.1.6 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-25 12:17:15.245','2023-04-25 10:17:16.413',NULL),('5b415200-1bfb-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/8a8cc548-1bf9-11ee-9323-a0510b46b473/session_976f015a-1bf9-11ee-9323-a0510b46b473/occlusion_97713d19-1bf9-11ee-9323-a0510b46b473/scan_c139fea5-1bfa-11ee-9323-a0510b46b473/5b415200-1bfb-11ee-9323-a0510b46b473.zip','PATIENT_8a8cc548-1bf9-11ee-9323-a0510b46b473_ACT_976f015a-1bf9-11ee-9323-a0510b46b473_SESS_97713d19-1bf9-11ee-9323-a0510b46b473_TOSC_c139fea5-1bfa-11ee-9323-a0510b46b473_MODEL','5b415200-1bfb-11ee-9323-a0510b46b473.zip','5b415200-1bfb-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.28.1.1.4\",\"modelMatrix\":\"0.989399,-0.138755,0.0428491,0,0.145221,0.945349,-0.291934,0,4.77643e-10,0.295062,0.955478,0,-17.6892,16.4895,-19.9114,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 14:48:07.681','2023-07-06 12:48:08.125',NULL),('5b41874d-1bfb-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/8a8cc548-1bf9-11ee-9323-a0510b46b473/session_976f015a-1bf9-11ee-9323-a0510b46b473/occlusion_97713d19-1bf9-11ee-9323-a0510b46b473/scan_c139fea5-1bfa-11ee-9323-a0510b46b473/5b41874d-1bfb-11ee-9323-a0510b46b473.png','PATIENT_8a8cc548-1bf9-11ee-9323-a0510b46b473_ACT_976f015a-1bf9-11ee-9323-a0510b46b473_SESS_97713d19-1bf9-11ee-9323-a0510b46b473_TOSC_c139fea5-1bfa-11ee-9323-a0510b46b473_SNAPS','5b41874d-1bfb-11ee-9323-a0510b46b473.png','5b41874d-1bfb-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.28.1.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 14:48:07.682','2023-07-06 12:48:08.126',NULL),('5b63dfab-de89-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/f29210da-de80-11ed-9cc3-00d86184ce3d/session_ffdb9942-de80-11ed-9cc3-00d86184ce3d/occlusion_ffdebb3e-de80-11ed-9cc3-00d86184ce3d/scan_22b678df-de89-11ed-9cc3-00d86184ce3d/5b63dfab-de89-11ed-9cc3-00d86184ce3d.zip','PATIENT_f29210da-de80-11ed-9cc3-00d86184ce3d_ACT_ffdb9942-de80-11ed-9cc3-00d86184ce3d_SESS_ffdebb3e-de80-11ed-9cc3-00d86184ce3d_TOSC_22b678df-de89-11ed-9cc3-00d86184ce3d_MODEL','5b63dfab-de89-11ed-9cc3-00d86184ce3d.zip','5b63dfab-de89-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.3.1.1.7\",\"modelMatrix\":\"0.920963,0.376696,-0.0996292,0,-0.389649,0.89035,-0.235481,0,1.21359e-10,0.25569,0.966759,0,-28.838,5.1236,-13.3038,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-04-19 10:08:24.351','2023-04-19 08:08:24.740','2023-04-19 10:08:26.229'),('5b63f2de-de89-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/f29210da-de80-11ed-9cc3-00d86184ce3d/session_ffdb9942-de80-11ed-9cc3-00d86184ce3d/occlusion_ffdebb3e-de80-11ed-9cc3-00d86184ce3d/scan_22b678df-de89-11ed-9cc3-00d86184ce3d/5b63f2de-de89-11ed-9cc3-00d86184ce3d.png','PATIENT_f29210da-de80-11ed-9cc3-00d86184ce3d_ACT_ffdb9942-de80-11ed-9cc3-00d86184ce3d_SESS_ffdebb3e-de80-11ed-9cc3-00d86184ce3d_TOSC_22b678df-de89-11ed-9cc3-00d86184ce3d_SNAPS','5b63f2de-de89-11ed-9cc3-00d86184ce3d.png','5b63f2de-de89-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.3.1.1.7 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-04-19 10:08:24.351','2023-04-19 08:08:24.741','2023-04-19 10:08:26.345'),('5bf2c9ba-de87-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/f29210da-de80-11ed-9cc3-00d86184ce3d/session_ffdb9942-de80-11ed-9cc3-00d86184ce3d/occlusion_ffdebb3e-de80-11ed-9cc3-00d86184ce3d/scan_0311e969-de87-11ed-9cc3-00d86184ce3d/5bf2c9ba-de87-11ed-9cc3-00d86184ce3d.zip','PATIENT_f29210da-de80-11ed-9cc3-00d86184ce3d_ACT_ffdb9942-de80-11ed-9cc3-00d86184ce3d_SESS_ffdebb3e-de80-11ed-9cc3-00d86184ce3d_TOSC_0311e969-de87-11ed-9cc3-00d86184ce3d_MODEL','5bf2c9ba-de87-11ed-9cc3-00d86184ce3d.zip','5bf2c9ba-de87-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.3.1.1.5\",\"modelMatrix\":\"0.188434,0.953888,-0.233644,0,-0.982086,0.183023,-0.0448295,0,5.73226e-10,0.237906,0.971288,0,-23.03,-23.0287,-8.07545,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-04-19 09:54:06.294','2023-04-19 07:54:07.117','2023-04-19 09:54:08.468'),('5bf2e1fc-de87-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/f29210da-de80-11ed-9cc3-00d86184ce3d/session_ffdb9942-de80-11ed-9cc3-00d86184ce3d/occlusion_ffdebb3e-de80-11ed-9cc3-00d86184ce3d/scan_0311e969-de87-11ed-9cc3-00d86184ce3d/5bf2e1fc-de87-11ed-9cc3-00d86184ce3d.png','PATIENT_f29210da-de80-11ed-9cc3-00d86184ce3d_ACT_ffdb9942-de80-11ed-9cc3-00d86184ce3d_SESS_ffdebb3e-de80-11ed-9cc3-00d86184ce3d_TOSC_0311e969-de87-11ed-9cc3-00d86184ce3d_SNAPS','5bf2e1fc-de87-11ed-9cc3-00d86184ce3d.png','5bf2e1fc-de87-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.3.1.1.5 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-04-19 09:54:06.294','2023-04-19 07:54:07.117','2023-04-19 09:54:08.588'),('5c31f82f-0f40-11ee-8712-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_964f8d9e-0f3e-11ee-8712-a0510b46b473/occlusion_965293c3-0f3e-11ee-8712-a0510b46b473/scan_0acf79e0-0f40-11ee-8712-a0510b46b473/5c31f82f-0f40-11ee-8712-a0510b46b473.zip','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_964f8d9e-0f3e-11ee-8712-a0510b46b473_SESS_965293c3-0f3e-11ee-8712-a0510b46b473_TOSC_0acf79e0-0f40-11ee-8712-a0510b46b473_MODEL','5c31f82f-0f40-11ee-8712-a0510b46b473.zip','5c31f82f-0f40-11ee-8712-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.1.1.5\",\"modelMatrix\":\"0.0207039,0.992778,-0.118166,0,-0.999786,0.0205587,-0.00244701,0,9.20285e-11,0.118191,0.992991,0,-12.536,-29.1119,-12.5088,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-20 09:59:19.416','2023-06-20 07:59:20.163',NULL),('5c3271da-0f40-11ee-8712-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_964f8d9e-0f3e-11ee-8712-a0510b46b473/occlusion_965293c3-0f3e-11ee-8712-a0510b46b473/scan_0acf79e0-0f40-11ee-8712-a0510b46b473/5c3271da-0f40-11ee-8712-a0510b46b473.png','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_964f8d9e-0f3e-11ee-8712-a0510b46b473_SESS_965293c3-0f3e-11ee-8712-a0510b46b473_TOSC_0acf79e0-0f40-11ee-8712-a0510b46b473_SNAPS','5c3271da-0f40-11ee-8712-a0510b46b473.png','5c3271da-0f40-11ee-8712-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.1.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-20 09:59:19.419','2023-06-20 07:59:20.171',NULL),('5dddf010-1ca1-11ee-84c4-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_06fff4e1-1ca0-11ee-84c4-a0510b46b473/occlusion_0701c127-1ca0-11ee-84c4-a0510b46b473/scan_1281e227-1ca1-11ee-84c4-a0510b46b473/5dddf010-1ca1-11ee-84c4-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_06fff4e1-1ca0-11ee-84c4-a0510b46b473_SESS_0701c127-1ca0-11ee-84c4-a0510b46b473_TOSC_1281e227-1ca1-11ee-84c4-a0510b46b473_MODEL','5dddf010-1ca1-11ee-84c4-a0510b46b473.zip','5dddf010-1ca1-11ee-84c4-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.1.1.4\",\"modelMatrix\":\"-0.248341,0.944667,-0.214318,0,-0.968673,-0.242186,0.0549451,0,-1.09798e-09,0.221249,0.975217,0,-16.108,-25.9431,-8.11531,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-07 10:36:28.520','2023-07-07 08:36:29.162',NULL),('5dde73cd-1ca1-11ee-84c4-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_06fff4e1-1ca0-11ee-84c4-a0510b46b473/occlusion_0701c127-1ca0-11ee-84c4-a0510b46b473/scan_1281e227-1ca1-11ee-84c4-a0510b46b473/5dde73cd-1ca1-11ee-84c4-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_06fff4e1-1ca0-11ee-84c4-a0510b46b473_SESS_0701c127-1ca0-11ee-84c4-a0510b46b473_TOSC_1281e227-1ca1-11ee-84c4-a0510b46b473_SNAPS','5dde73cd-1ca1-11ee-84c4-a0510b46b473.png','5dde73cd-1ca1-11ee-84c4-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.1.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-07 10:36:28.523','2023-07-07 08:36:29.162',NULL),('5e14d5dd-e03a-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_63b81b7e-e035-11ed-bb13-00d86184ce3d/occlusion_63bb1989-e035-11ed-bb13-00d86184ce3d/scan_44bdecc8-e03a-11ed-bb13-00d86184ce3d/5e14d5dd-e03a-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_63b81b7e-e035-11ed-bb13-00d86184ce3d_SESS_63bb1989-e035-11ed-bb13-00d86184ce3d_TOSC_44bdecc8-e03a-11ed-bb13-00d86184ce3d_MODEL','5e14d5dd-e03a-11ed-bb13-00d86184ce3d.zip','5e14d5dd-e03a-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.2.1.10\",\"modelMatrix\":\"0.780521,0.597656,-0.18329,0,-0.62513,0.746217,-0.228851,0,-5.4411e-09,0.293202,0.95605,0,-21.5171,-6.77456,-9.59858,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 13:48:00.950','2023-04-21 11:48:01.247',NULL),('5e14edaa-e03a-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_63b81b7e-e035-11ed-bb13-00d86184ce3d/occlusion_63bb1989-e035-11ed-bb13-00d86184ce3d/scan_44bdecc8-e03a-11ed-bb13-00d86184ce3d/5e14edaa-e03a-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_63b81b7e-e035-11ed-bb13-00d86184ce3d_SESS_63bb1989-e035-11ed-bb13-00d86184ce3d_TOSC_44bdecc8-e03a-11ed-bb13-00d86184ce3d_SNAPS','5e14edaa-e03a-11ed-bb13-00d86184ce3d.png','5e14edaa-e03a-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.2.1.10 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 13:48:00.950','2023-04-21 11:48:01.247',NULL),('5e5a93d7-2631-11ee-81dd-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_62519c59-261f-11ee-8042-a0510b46b473/occlusion_6253caa6-261f-11ee-8042-a0510b46b473/scan_0e8a66a1-2631-11ee-81dd-a0510b46b473/5e5a93d7-2631-11ee-81dd-a0510b46b473.zip','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_62519c59-261f-11ee-8042-a0510b46b473_SESS_6253caa6-261f-11ee-8042-a0510b46b473_BOSC_0e8a66a1-2631-11ee-81dd-a0510b46b473_MODEL','5e5a93d7-2631-11ee-81dd-a0510b46b473.zip','5e5a93d7-2631-11ee-81dd-a0510b46b473','{\"displayTitle\":\"Mandibule 1.34.1.1.3\",\"modelMatrix\":\"-0.515632,0.801255,-0.303502,0,-0.85681,-0.482199,0.182649,0,-1.68346e-08,0.354224,0.935161,0,20.8901,-11.6504,-9.953,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-19 14:39:57.331','2023-07-19 12:39:58.016',NULL),('5e5bd645-2631-11ee-81dd-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_62519c59-261f-11ee-8042-a0510b46b473/occlusion_6253caa6-261f-11ee-8042-a0510b46b473/scan_0e8a66a1-2631-11ee-81dd-a0510b46b473/5e5bd645-2631-11ee-81dd-a0510b46b473.png','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_62519c59-261f-11ee-8042-a0510b46b473_SESS_6253caa6-261f-11ee-8042-a0510b46b473_BOSC_0e8a66a1-2631-11ee-81dd-a0510b46b473_SNAPS','5e5bd645-2631-11ee-81dd-a0510b46b473.png','5e5bd645-2631-11ee-81dd-a0510b46b473','{\"displayTitle\":\"Mandibule 1.34.1.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-19 14:39:57.339','2023-07-19 12:39:58.024',NULL),('5f56dc85-1c0a-11ee-a865-a0510b46b473',11,'/home/scan/.data//2023/11/ae8bd11e-1c05-11ee-9323-a0510b46b473/session_bab223ae-1c09-11ee-a865-a0510b46b473/occlusion_bab539ff-1c09-11ee-a865-a0510b46b473/scan_29d886a7-1c0a-11ee-a865-a0510b46b473/5f56dc85-1c0a-11ee-a865-a0510b46b473.zip','PATIENT_ae8bd11e-1c05-11ee-9323-a0510b46b473_ACT_bab223ae-1c09-11ee-a865-a0510b46b473_SESS_bab539ff-1c09-11ee-a865-a0510b46b473_TOSC_29d886a7-1c0a-11ee-a865-a0510b46b473_MODEL','5f56dc85-1c0a-11ee-a865-a0510b46b473.zip','5f56dc85-1c0a-11ee-a865-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.29.2.1.3\",\"modelMatrix\":\"0.878494,0.419679,-0.228292,0,-0.477753,0.771708,-0.419785,0,-8.59419e-10,0.477846,0.878444,0,-22.1608,9.6156,-10.7017,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 16:35:36.984','2023-07-06 14:35:37.519',NULL),('5f56f182-1c0a-11ee-a865-a0510b46b473',11,'/home/scan/.data//2023/11/ae8bd11e-1c05-11ee-9323-a0510b46b473/session_bab223ae-1c09-11ee-a865-a0510b46b473/occlusion_bab539ff-1c09-11ee-a865-a0510b46b473/scan_29d886a7-1c0a-11ee-a865-a0510b46b473/5f56f182-1c0a-11ee-a865-a0510b46b473.png','PATIENT_ae8bd11e-1c05-11ee-9323-a0510b46b473_ACT_bab223ae-1c09-11ee-a865-a0510b46b473_SESS_bab539ff-1c09-11ee-a865-a0510b46b473_TOSC_29d886a7-1c0a-11ee-a865-a0510b46b473_SNAPS','5f56f182-1c0a-11ee-a865-a0510b46b473.png','5f56f182-1c0a-11ee-a865-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.29.2.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 16:35:36.984','2023-07-06 14:35:37.522',NULL),('5f8e1612-e03c-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_6f09f9a8-e03a-11ed-bb13-00d86184ce3d/occlusion_6f0c3cda-e03a-11ed-bb13-00d86184ce3d/scan_40b9e4ef-e03c-11ed-bb13-00d86184ce3d/5f8e1612-e03c-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_6f09f9a8-e03a-11ed-bb13-00d86184ce3d_SESS_6f0c3cda-e03a-11ed-bb13-00d86184ce3d_TOSC_40b9e4ef-e03c-11ed-bb13-00d86184ce3d_MODEL','5f8e1612-e03c-11ed-bb13-00d86184ce3d.zip','5f8e1612-e03c-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.3.1.9\",\"modelMatrix\":\"0.917693,0.28788,-0.273796,0,-0.397289,0.66497,-0.632437,0,-2.364e-09,0.689159,0.72461,0,-21.1027,-9.23412,-6.18877,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,'2023-04-21 14:04:10.924','2023-04-21 14:02:22.416','2023-04-21 12:04:10.928',NULL),('5f8e48b1-e03c-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_6f09f9a8-e03a-11ed-bb13-00d86184ce3d/occlusion_6f0c3cda-e03a-11ed-bb13-00d86184ce3d/scan_40b9e4ef-e03c-11ed-bb13-00d86184ce3d/5f8e48b1-e03c-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_6f09f9a8-e03a-11ed-bb13-00d86184ce3d_SESS_6f0c3cda-e03a-11ed-bb13-00d86184ce3d_TOSC_40b9e4ef-e03c-11ed-bb13-00d86184ce3d_SNAPS','5f8e48b1-e03c-11ed-bb13-00d86184ce3d.png','5f8e48b1-e03c-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.3.1.9 Snapshot\"}','PNG',0,'CREATED',0,'2023-04-21 14:04:10.924','2023-04-21 14:02:22.417','2023-04-21 12:04:10.931',NULL),('6025f1a3-df85-11ed-b6c2-00d86184ce3d',11,'/home/scan/.data//2023/11/ee09109f-df83-11ed-b6c2-00d86184ce3d/session_f3d790be-df83-11ed-b6c2-00d86184ce3d/occlusion_f3d9f61c-df83-11ed-b6c2-00d86184ce3d/scan_1ac586d5-df85-11ed-b6c2-00d86184ce3d/6025f1a3-df85-11ed-b6c2-00d86184ce3d.zip','PATIENT_ee09109f-df83-11ed-b6c2-00d86184ce3d_ACT_f3d790be-df83-11ed-b6c2-00d86184ce3d_SESS_f3d9f61c-df83-11ed-b6c2-00d86184ce3d_TOSC_1ac586d5-df85-11ed-b6c2-00d86184ce3d_MODEL','6025f1a3-df85-11ed-b6c2-00d86184ce3d.zip','6025f1a3-df85-11ed-b6c2-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.8.1.1.4\",\"modelMatrix\":\"0.401311,0.861363,-0.311453,0,-0.915942,0.377398,-0.13646,0,2.59834e-09,0.340036,0.940412,0,-21.4668,-20.0767,-6.42408,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-20 16:12:25.509','2023-04-20 14:12:26.270',NULL),('602608e0-df85-11ed-b6c2-00d86184ce3d',11,'/home/scan/.data//2023/11/ee09109f-df83-11ed-b6c2-00d86184ce3d/session_f3d790be-df83-11ed-b6c2-00d86184ce3d/occlusion_f3d9f61c-df83-11ed-b6c2-00d86184ce3d/scan_1ac586d5-df85-11ed-b6c2-00d86184ce3d/602608e0-df85-11ed-b6c2-00d86184ce3d.png','PATIENT_ee09109f-df83-11ed-b6c2-00d86184ce3d_ACT_f3d790be-df83-11ed-b6c2-00d86184ce3d_SESS_f3d9f61c-df83-11ed-b6c2-00d86184ce3d_TOSC_1ac586d5-df85-11ed-b6c2-00d86184ce3d_SNAPS','602608e0-df85-11ed-b6c2-00d86184ce3d.png','602608e0-df85-11ed-b6c2-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.8.1.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-20 16:12:25.510','2023-04-20 14:12:26.271',NULL),('60bab6c2-e343-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_853ebc79-e33f-11ed-8c5e-00d86184ce3d/occlusion_8541c500-e33f-11ed-8c5e-00d86184ce3d/scan_114be474-e343-11ed-8c5e-00d86184ce3d/60bab6c2-e343-11ed-8c5e-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_853ebc79-e33f-11ed-8c5e-00d86184ce3d_SESS_8541c500-e33f-11ed-8c5e-00d86184ce3d_TOSC_114be474-e343-11ed-8c5e-00d86184ce3d_MODEL','60bab6c2-e343-11ed-8c5e-00d86184ce3d.zip','60bab6c2-e343-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.6.1.4\",\"modelMatrix\":\"-0.00376132,0.970559,-0.240835,0,-0.999993,-0.00365061,0.000905864,0,-2.76729e-12,0.240837,0.970566,0,-20.4386,-21.9976,-7.60345,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-25 10:30:04.351','2023-04-25 08:30:05.274',NULL),('60bacf85-e343-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_853ebc79-e33f-11ed-8c5e-00d86184ce3d/occlusion_8541c500-e33f-11ed-8c5e-00d86184ce3d/scan_114be474-e343-11ed-8c5e-00d86184ce3d/60bacf85-e343-11ed-8c5e-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_853ebc79-e33f-11ed-8c5e-00d86184ce3d_SESS_8541c500-e33f-11ed-8c5e-00d86184ce3d_TOSC_114be474-e343-11ed-8c5e-00d86184ce3d_SNAPS','60bacf85-e343-11ed-8c5e-00d86184ce3d.png','60bacf85-e343-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.6.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-25 10:30:04.352','2023-04-25 08:30:05.275',NULL),('61396cb2-e03f-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_261265bf-e03f-11ed-bb13-00d86184ce3d/occlusion_2615e3c8-e03f-11ed-bb13-00d86184ce3d/scan_2ab9c9fd-e03f-11ed-bb13-00d86184ce3d/61396cb2-e03f-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_261265bf-e03f-11ed-bb13-00d86184ce3d_SESS_2615e3c8-e03f-11ed-bb13-00d86184ce3d_TOSC_2ab9c9fd-e03f-11ed-bb13-00d86184ce3d_MODEL','61396cb2-e03f-11ed-bb13-00d86184ce3d.zip','61396cb2-e03f-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.4.1.1\",\"modelMatrix\":\"0.388844,-0.921092,0.0197402,0,0.921304,0.388754,-0.0083315,0,-6.169e-10,0.0214263,0.99977,0,0.791417,30.4408,-8.10464,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,'2023-04-21 14:40:04.714','2023-04-21 14:23:53.706','2023-04-21 12:40:04.716',NULL),('61398542-e03f-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_261265bf-e03f-11ed-bb13-00d86184ce3d/occlusion_2615e3c8-e03f-11ed-bb13-00d86184ce3d/scan_2ab9c9fd-e03f-11ed-bb13-00d86184ce3d/61398542-e03f-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_261265bf-e03f-11ed-bb13-00d86184ce3d_SESS_2615e3c8-e03f-11ed-bb13-00d86184ce3d_TOSC_2ab9c9fd-e03f-11ed-bb13-00d86184ce3d_SNAPS','61398542-e03f-11ed-bb13-00d86184ce3d.png','61398542-e03f-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.4.1.1 Snapshot\"}','PNG',0,'CREATED',0,'2023-04-21 14:40:04.714','2023-04-21 14:23:53.707','2023-04-21 12:40:04.717',NULL),('61bb936c-10e5-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/2ff330cd-10e1-11ee-b636-a0510b46b473/session_68b68f8e-10e4-11ee-b636-a0510b46b473/occlusion_68b97a59-10e4-11ee-b636-a0510b46b473/scan_2bf8893b-10e5-11ee-b636-a0510b46b473/61bb936c-10e5-11ee-b636-a0510b46b473.zip','PATIENT_2ff330cd-10e1-11ee-b636-a0510b46b473_ACT_68b68f8e-10e4-11ee-b636-a0510b46b473_SESS_68b97a59-10e4-11ee-b636-a0510b46b473_TOSC_2bf8893b-10e5-11ee-b636-a0510b46b473_MODEL','61bb936c-10e5-11ee-b636-a0510b46b473.zip','61bb936c-10e5-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.18.2.1.4\",\"modelMatrix\":\"0.732122,0.587472,-0.344781,0,-0.681174,0.631413,-0.370568,0,-7.92961e-09,0.506157,0.862442,0,-32.0352,-5.03669,-5.60855,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 12:13:06.830','2023-06-22 10:13:07.354',NULL),('61bccd0a-10e5-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/2ff330cd-10e1-11ee-b636-a0510b46b473/session_68b68f8e-10e4-11ee-b636-a0510b46b473/occlusion_68b97a59-10e4-11ee-b636-a0510b46b473/scan_2bf8893b-10e5-11ee-b636-a0510b46b473/61bccd0a-10e5-11ee-b636-a0510b46b473.png','PATIENT_2ff330cd-10e1-11ee-b636-a0510b46b473_ACT_68b68f8e-10e4-11ee-b636-a0510b46b473_SESS_68b97a59-10e4-11ee-b636-a0510b46b473_TOSC_2bf8893b-10e5-11ee-b636-a0510b46b473_SNAPS','61bccd0a-10e5-11ee-b636-a0510b46b473.png','61bccd0a-10e5-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.18.2.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 12:13:06.838','2023-06-22 10:13:07.355',NULL),('623ce9a1-26ff-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/848c86d9-26fd-11ee-a98e-a0510b46b473/session_8f62cd50-26fd-11ee-a98e-a0510b46b473/occlusion_8f65e2e0-26fd-11ee-a98e-a0510b46b473/scan_fef9069f-26fe-11ee-a98e-a0510b46b473/623ce9a1-26ff-11ee-a98e-a0510b46b473.zip','PATIENT_848c86d9-26fd-11ee-a98e-a0510b46b473_ACT_8f62cd50-26fd-11ee-a98e-a0510b46b473_SESS_8f65e2e0-26fd-11ee-a98e-a0510b46b473_TOSC_fef9069f-26fe-11ee-a98e-a0510b46b473_MODEL','623ce9a1-26ff-11ee-a98e-a0510b46b473.zip','623ce9a1-26ff-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.36.1.1.4\",\"modelMatrix\":\"0.229461,0.960951,-0.154664,0,-0.973318,0.226545,-0.0364622,0,3.80798e-09,0.158904,0.987294,0,-26.3329,-21.2417,-8.91203,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-20 15:14:40.174','2023-07-20 13:14:41.064',NULL),('623d00f5-26ff-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/848c86d9-26fd-11ee-a98e-a0510b46b473/session_8f62cd50-26fd-11ee-a98e-a0510b46b473/occlusion_8f65e2e0-26fd-11ee-a98e-a0510b46b473/scan_fef9069f-26fe-11ee-a98e-a0510b46b473/623d00f5-26ff-11ee-a98e-a0510b46b473.png','PATIENT_848c86d9-26fd-11ee-a98e-a0510b46b473_ACT_8f62cd50-26fd-11ee-a98e-a0510b46b473_SESS_8f65e2e0-26fd-11ee-a98e-a0510b46b473_TOSC_fef9069f-26fe-11ee-a98e-a0510b46b473_SNAPS','623d00f5-26ff-11ee-a98e-a0510b46b473.png','623d00f5-26ff-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.36.1.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-20 15:14:40.174','2023-07-20 13:14:41.065',NULL),('6368940f-1ca0-11ee-84c4-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_06fff4e1-1ca0-11ee-84c4-a0510b46b473/occlusion_0701c127-1ca0-11ee-84c4-a0510b46b473/scan_0ca0f60a-1ca0-11ee-84c4-a0510b46b473/6368940f-1ca0-11ee-84c4-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_06fff4e1-1ca0-11ee-84c4-a0510b46b473_SESS_0701c127-1ca0-11ee-84c4-a0510b46b473_TOSC_0ca0f60a-1ca0-11ee-84c4-a0510b46b473_MODEL','6368940f-1ca0-11ee-84c4-a0510b46b473.zip','6368940f-1ca0-11ee-84c4-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.1.1.1\",\"modelMatrix\":\"0.342552,0.890284,-0.300088,0,-0.939499,0.324607,-0.109416,0,4.9734e-09,0.319413,0.947616,0,-26.1085,-16.983,-9.30251,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-07 10:29:28.320','2023-07-07 08:29:29.015',NULL),('6368ae01-1ca0-11ee-84c4-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_06fff4e1-1ca0-11ee-84c4-a0510b46b473/occlusion_0701c127-1ca0-11ee-84c4-a0510b46b473/scan_0ca0f60a-1ca0-11ee-84c4-a0510b46b473/6368ae01-1ca0-11ee-84c4-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_06fff4e1-1ca0-11ee-84c4-a0510b46b473_SESS_0701c127-1ca0-11ee-84c4-a0510b46b473_TOSC_0ca0f60a-1ca0-11ee-84c4-a0510b46b473_SNAPS','6368ae01-1ca0-11ee-84c4-a0510b46b473.png','6368ae01-1ca0-11ee-84c4-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.1.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-07 10:29:28.321','2023-07-07 08:29:29.017',NULL),('6386f188-10fa-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/ed94fe78-10f4-11ee-b636-a0510b46b473/session_f8ef8fe7-10f4-11ee-b636-a0510b46b473/occlusion_f8f2e241-10f4-11ee-b636-a0510b46b473/scan_15171312-10fa-11ee-b636-a0510b46b473/6386f188-10fa-11ee-b636-a0510b46b473.zip','PATIENT_ed94fe78-10f4-11ee-b636-a0510b46b473_ACT_f8ef8fe7-10f4-11ee-b636-a0510b46b473_SESS_f8f2e241-10f4-11ee-b636-a0510b46b473_TOSC_15171312-10fa-11ee-b636-a0510b46b473_MODEL','6386f188-10fa-11ee-b636-a0510b46b473.zip','6386f188-10fa-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.19.1.1.5\",\"modelMatrix\":\"0.560266,0.794933,-0.232775,0,-0.828313,0.537688,-0.157448,0,-3.28716e-09,0.281023,0.959701,0,-21.646,-13.9043,-14.207,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 14:43:29.272','2023-06-22 12:43:30.003',NULL),('638705b1-10fa-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/ed94fe78-10f4-11ee-b636-a0510b46b473/session_f8ef8fe7-10f4-11ee-b636-a0510b46b473/occlusion_f8f2e241-10f4-11ee-b636-a0510b46b473/scan_15171312-10fa-11ee-b636-a0510b46b473/638705b1-10fa-11ee-b636-a0510b46b473.png','PATIENT_ed94fe78-10f4-11ee-b636-a0510b46b473_ACT_f8ef8fe7-10f4-11ee-b636-a0510b46b473_SESS_f8f2e241-10f4-11ee-b636-a0510b46b473_TOSC_15171312-10fa-11ee-b636-a0510b46b473_SNAPS','638705b1-10fa-11ee-b636-a0510b46b473.png','638705b1-10fa-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.19.1.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 14:43:29.272','2023-06-22 12:43:30.004',NULL),('65276446-14cb-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/9619fcac-14c3-11ee-b3b1-00d86184ce3d/session_961b9a11-14c3-11ee-b3b1-00d86184ce3d/occlusion_961d56b4-14c3-11ee-b3b1-00d86184ce3d/scan_f928c87c-14ca-11ee-b3b1-00d86184ce3d/65276446-14cb-11ee-b3b1-00d86184ce3d.zip','PATIENT_9619fcac-14c3-11ee-b3b1-00d86184ce3d_ACT_961b9a11-14c3-11ee-b3b1-00d86184ce3d_SESS_961d56b4-14c3-11ee-b3b1-00d86184ce3d_TOSC_f928c87c-14ca-11ee-b3b1-00d86184ce3d_MODEL','65276446-14cb-11ee-b3b1-00d86184ce3d.zip','65276446-14cb-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.22.1.1.8\",\"modelMatrix\":\"0.286971,0.939876,-0.185149,0,-0.957939,0.28156,-0.0554653,0,-2.14705e-09,0.193279,0.981144,0,-21.9261,-23.0053,-8.16256,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-27 11:17:10.306','2023-06-27 09:17:11.097',NULL),('65277a6d-14cb-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/9619fcac-14c3-11ee-b3b1-00d86184ce3d/session_961b9a11-14c3-11ee-b3b1-00d86184ce3d/occlusion_961d56b4-14c3-11ee-b3b1-00d86184ce3d/scan_f928c87c-14ca-11ee-b3b1-00d86184ce3d/65277a6d-14cb-11ee-b3b1-00d86184ce3d.png','PATIENT_9619fcac-14c3-11ee-b3b1-00d86184ce3d_ACT_961b9a11-14c3-11ee-b3b1-00d86184ce3d_SESS_961d56b4-14c3-11ee-b3b1-00d86184ce3d_TOSC_f928c87c-14ca-11ee-b3b1-00d86184ce3d_SNAPS','65277a6d-14cb-11ee-b3b1-00d86184ce3d.png','65277a6d-14cb-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.22.1.1.8 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-27 11:17:10.306','2023-06-27 09:17:11.105',NULL),('6563dff0-0f3f-11ee-8712-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_964f8d9e-0f3e-11ee-8712-a0510b46b473/occlusion_965293c3-0f3e-11ee-8712-a0510b46b473/scan_1a3cdc6a-0f3f-11ee-8712-a0510b46b473/6563dff0-0f3f-11ee-8712-a0510b46b473.zip','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_964f8d9e-0f3e-11ee-8712-a0510b46b473_SESS_965293c3-0f3e-11ee-8712-a0510b46b473_TOSC_1a3cdc6a-0f3f-11ee-8712-a0510b46b473_MODEL','6563dff0-0f3f-11ee-8712-a0510b46b473.zip','6563dff0-0f3f-11ee-8712-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.1.1.3\",\"modelMatrix\":\"0.312666,0.938457,-0.146763,0,-0.949863,0.308911,-0.0483098,0,2.35854e-10,0.154509,0.987991,0,-25.4862,-18.5785,-9.61656,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-20 09:52:25.346','2023-06-20 07:52:26.052',NULL),('6563f484-0f3f-11ee-8712-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_964f8d9e-0f3e-11ee-8712-a0510b46b473/occlusion_965293c3-0f3e-11ee-8712-a0510b46b473/scan_1a3cdc6a-0f3f-11ee-8712-a0510b46b473/6563f484-0f3f-11ee-8712-a0510b46b473.png','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_964f8d9e-0f3e-11ee-8712-a0510b46b473_SESS_965293c3-0f3e-11ee-8712-a0510b46b473_TOSC_1a3cdc6a-0f3f-11ee-8712-a0510b46b473_SNAPS','6563f484-0f3f-11ee-8712-a0510b46b473.png','6563f484-0f3f-11ee-8712-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.1.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-20 09:52:25.347','2023-06-20 07:52:26.062',NULL),('65cfef85-10db-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/bd51960a-10d5-11ee-b636-a0510b46b473/session_ea36dd21-10da-11ee-b636-a0510b46b473/occlusion_ea39c2be-10da-11ee-b636-a0510b46b473/scan_2da74f58-10db-11ee-b636-a0510b46b473/65cfef85-10db-11ee-b636-a0510b46b473.zip','PATIENT_bd51960a-10d5-11ee-b636-a0510b46b473_ACT_ea36dd21-10da-11ee-b636-a0510b46b473_SESS_ea39c2be-10da-11ee-b636-a0510b46b473_TOSC_2da74f58-10db-11ee-b636-a0510b46b473_MODEL','65cfef85-10db-11ee-b636-a0510b46b473.zip','65cfef85-10db-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.17.2.1.2\",\"modelMatrix\":\"0.643708,0.67153,-0.366997,0,-0.765271,0.564858,-0.3087,0,-8.39404e-09,0.479565,0.877506,0,-22.9011,4.39191,-10.7135,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 11:01:38.707','2023-06-22 09:01:39.323',NULL),('65d1371d-10db-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/bd51960a-10d5-11ee-b636-a0510b46b473/session_ea36dd21-10da-11ee-b636-a0510b46b473/occlusion_ea39c2be-10da-11ee-b636-a0510b46b473/scan_2da74f58-10db-11ee-b636-a0510b46b473/65d1371d-10db-11ee-b636-a0510b46b473.png','PATIENT_bd51960a-10d5-11ee-b636-a0510b46b473_ACT_ea36dd21-10da-11ee-b636-a0510b46b473_SESS_ea39c2be-10da-11ee-b636-a0510b46b473_TOSC_2da74f58-10db-11ee-b636-a0510b46b473_SNAPS','65d1371d-10db-11ee-b636-a0510b46b473.png','65d1371d-10db-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.17.2.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 11:01:38.715','2023-06-22 09:01:39.323',NULL),('66c4b3d9-2ac2-11ee-80c8-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_3a881645-2abf-11ee-80c8-a0510b46b473/occlusion_3a8b3537-2abf-11ee-80c8-a0510b46b473/scan_3a013dab-2ac2-11ee-80c8-a0510b46b473/66c4b3d9-2ac2-11ee-80c8-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_3a881645-2abf-11ee-80c8-a0510b46b473_SESS_3a8b3537-2abf-11ee-80c8-a0510b46b473_TOSC_3a013dab-2ac2-11ee-80c8-a0510b46b473_MODEL','66c4b3d9-2ac2-11ee-80c8-a0510b46b473.zip','66c4b3d9-2ac2-11ee-80c8-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.7.1.8\",\"modelMatrix\":\"0.817383,0.527543,-0.231481,0,-0.576095,0.748496,-0.328433,0,-4.30429e-09,0.401811,0.915723,0,-29.0896,2.08401,-9.74534,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-25 10:08:13.125','2023-07-25 08:08:13.534',NULL),('66c4ccc2-2ac2-11ee-80c8-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_3a881645-2abf-11ee-80c8-a0510b46b473/occlusion_3a8b3537-2abf-11ee-80c8-a0510b46b473/scan_3a013dab-2ac2-11ee-80c8-a0510b46b473/66c4ccc2-2ac2-11ee-80c8-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_3a881645-2abf-11ee-80c8-a0510b46b473_SESS_3a8b3537-2abf-11ee-80c8-a0510b46b473_TOSC_3a013dab-2ac2-11ee-80c8-a0510b46b473_SNAPS','66c4ccc2-2ac2-11ee-80c8-a0510b46b473.png','66c4ccc2-2ac2-11ee-80c8-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.7.1.8 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-25 10:08:13.126','2023-07-25 08:08:13.535',NULL),('67519e2f-de86-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/f29210da-de80-11ed-9cc3-00d86184ce3d/session_ffdb9942-de80-11ed-9cc3-00d86184ce3d/occlusion_ffdebb3e-de80-11ed-9cc3-00d86184ce3d/scan_f3b75c99-de85-11ed-9cc3-00d86184ce3d/67519e2f-de86-11ed-9cc3-00d86184ce3d.zip','PATIENT_f29210da-de80-11ed-9cc3-00d86184ce3d_ACT_ffdb9942-de80-11ed-9cc3-00d86184ce3d_SESS_ffdebb3e-de80-11ed-9cc3-00d86184ce3d_TOSC_f3b75c99-de85-11ed-9cc3-00d86184ce3d_MODEL','67519e2f-de86-11ed-9cc3-00d86184ce3d.zip','67519e2f-de86-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.3.1.1.3\",\"modelMatrix\":\"0.114764,0.946903,-0.300341,0,-0.993393,0.109393,-0.0346974,0,5.30021e-10,0.302338,0.953201,0,-20.9494,-24.5045,-6.80043,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-04-19 09:47:15.874','2023-04-19 07:47:16.747','2023-04-19 09:47:18.314'),('6751b59b-de86-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/f29210da-de80-11ed-9cc3-00d86184ce3d/session_ffdb9942-de80-11ed-9cc3-00d86184ce3d/occlusion_ffdebb3e-de80-11ed-9cc3-00d86184ce3d/scan_f3b75c99-de85-11ed-9cc3-00d86184ce3d/6751b59b-de86-11ed-9cc3-00d86184ce3d.png','PATIENT_f29210da-de80-11ed-9cc3-00d86184ce3d_ACT_ffdb9942-de80-11ed-9cc3-00d86184ce3d_SESS_ffdebb3e-de80-11ed-9cc3-00d86184ce3d_TOSC_f3b75c99-de85-11ed-9cc3-00d86184ce3d_SNAPS','6751b59b-de86-11ed-9cc3-00d86184ce3d.png','6751b59b-de86-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.3.1.1.3 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-04-19 09:47:15.874','2023-04-19 07:47:16.748','2023-04-19 09:47:18.449'),('677d9773-1c06-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/ae8bd11e-1c05-11ee-9323-a0510b46b473/session_bb436bde-1c05-11ee-9323-a0510b46b473/occlusion_bb465a1e-1c05-11ee-9323-a0510b46b473/scan_117e7303-1c06-11ee-9323-a0510b46b473/677d9773-1c06-11ee-9323-a0510b46b473.zip','PATIENT_ae8bd11e-1c05-11ee-9323-a0510b46b473_ACT_bb436bde-1c05-11ee-9323-a0510b46b473_SESS_bb465a1e-1c05-11ee-9323-a0510b46b473_TOSC_117e7303-1c06-11ee-9323-a0510b46b473_MODEL','677d9773-1c06-11ee-9323-a0510b46b473.zip','677d9773-1c06-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.29.1.1.2\",\"modelMatrix\":\"0.376995,0.885132,-0.272793,0,-0.926215,0.360273,-0.111034,0,4.26827e-09,0.294524,0.955644,0,-27.5969,-16.6728,-9.03629,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 16:07:12.673','2023-07-06 14:07:13.439',NULL),('677dace6-1c06-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/ae8bd11e-1c05-11ee-9323-a0510b46b473/session_bb436bde-1c05-11ee-9323-a0510b46b473/occlusion_bb465a1e-1c05-11ee-9323-a0510b46b473/scan_117e7303-1c06-11ee-9323-a0510b46b473/677dace6-1c06-11ee-9323-a0510b46b473.png','PATIENT_ae8bd11e-1c05-11ee-9323-a0510b46b473_ACT_bb436bde-1c05-11ee-9323-a0510b46b473_SESS_bb465a1e-1c05-11ee-9323-a0510b46b473_TOSC_117e7303-1c06-11ee-9323-a0510b46b473_SNAPS','677dace6-1c06-11ee-9323-a0510b46b473.png','677dace6-1c06-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.29.1.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 16:07:12.673','2023-07-06 14:07:13.440',NULL),('67ac722b-e01f-11ed-a285-00d86184ce3d',11,'/home/scan/.data//2023/11/5f27680c-e01a-11ed-b6c2-00d86184ce3d/session_65b85f32-e01a-11ed-b6c2-00d86184ce3d/occlusion_65ba9a94-e01a-11ed-b6c2-00d86184ce3d/scan_20842b51-e01f-11ed-a285-00d86184ce3d/67ac722b-e01f-11ed-a285-00d86184ce3d.zip','PATIENT_5f27680c-e01a-11ed-b6c2-00d86184ce3d_ACT_65b85f32-e01a-11ed-b6c2-00d86184ce3d_SESS_65ba9a94-e01a-11ed-b6c2-00d86184ce3d_TOSC_20842b51-e01f-11ed-a285-00d86184ce3d_MODEL','67ac722b-e01f-11ed-a285-00d86184ce3d.zip','67ac722b-e01f-11ed-a285-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.10.1.1.6\",\"modelMatrix\":\"-0.106522,0.946121,-0.305792,0,-0.99431,-0.101359,0.0327599,0,2.00025e-09,0.307542,0.951535,0,-22.1461,-25.3095,-6.97384,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 10:35:00.631','2023-04-21 08:35:01.614',NULL),('67ac8ae8-e01f-11ed-a285-00d86184ce3d',11,'/home/scan/.data//2023/11/5f27680c-e01a-11ed-b6c2-00d86184ce3d/session_65b85f32-e01a-11ed-b6c2-00d86184ce3d/occlusion_65ba9a94-e01a-11ed-b6c2-00d86184ce3d/scan_20842b51-e01f-11ed-a285-00d86184ce3d/67ac8ae8-e01f-11ed-a285-00d86184ce3d.png','PATIENT_5f27680c-e01a-11ed-b6c2-00d86184ce3d_ACT_65b85f32-e01a-11ed-b6c2-00d86184ce3d_SESS_65ba9a94-e01a-11ed-b6c2-00d86184ce3d_TOSC_20842b51-e01f-11ed-a285-00d86184ce3d_SNAPS','67ac8ae8-e01f-11ed-a285-00d86184ce3d.png','67ac8ae8-e01f-11ed-a285-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.10.1.1.6 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 10:35:00.632','2023-04-21 08:35:01.614',NULL),('69579ee1-262c-11ee-8042-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_62519c59-261f-11ee-8042-a0510b46b473/occlusion_6253caa6-261f-11ee-8042-a0510b46b473/scan_1753b238-262c-11ee-8042-a0510b46b473/69579ee1-262c-11ee-8042-a0510b46b473.zip','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_62519c59-261f-11ee-8042-a0510b46b473_SESS_6253caa6-261f-11ee-8042-a0510b46b473_TOSC_1753b238-262c-11ee-8042-a0510b46b473_MODEL','69579ee1-262c-11ee-8042-a0510b46b473.zip','69579ee1-262c-11ee-8042-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.1.1.9\",\"modelMatrix\":\"0.881549,0.467292,-0.0671539,0,-0.472092,0.872585,-0.125398,0,4.18298e-10,0.142247,0.989831,0,-28.8111,2.56336,-12.3281,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-19 14:04:28.283','2023-07-19 12:04:28.973',NULL),('6957b6b4-262c-11ee-8042-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_62519c59-261f-11ee-8042-a0510b46b473/occlusion_6253caa6-261f-11ee-8042-a0510b46b473/scan_1753b238-262c-11ee-8042-a0510b46b473/6957b6b4-262c-11ee-8042-a0510b46b473.png','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_62519c59-261f-11ee-8042-a0510b46b473_SESS_6253caa6-261f-11ee-8042-a0510b46b473_TOSC_1753b238-262c-11ee-8042-a0510b46b473_SNAPS','6957b6b4-262c-11ee-8042-a0510b46b473.png','6957b6b4-262c-11ee-8042-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.1.1.9 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-19 14:04:28.283','2023-07-19 12:04:28.973',NULL),('6a47b61f-1bd2-11ee-9086-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_a6b1a4bd-1bcf-11ee-9086-a0510b46b473/occlusion_a6b491c8-1bcf-11ee-9086-a0510b46b473/scan_168cd704-1bd2-11ee-9086-a0510b46b473/6a47b61f-1bd2-11ee-9086-a0510b46b473.zip','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_a6b1a4bd-1bcf-11ee-9086-a0510b46b473_SESS_a6b491c8-1bcf-11ee-9086-a0510b46b473_TOSC_168cd704-1bd2-11ee-9086-a0510b46b473_MODEL','6a47b61f-1bd2-11ee-9086-a0510b46b473.zip','6a47b61f-1bd2-11ee-9086-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.3.1.7\",\"modelMatrix\":\"0.631821,0.763985,-0.130876,0,-0.775114,0.62275,-0.106682,0,-2.13427e-09,0.168848,0.985642,0,-28.7867,-5.55117,-9.51923,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 09:55:03.523','2023-07-06 07:55:04.439',NULL),('6a47ce82-1bd2-11ee-9086-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_a6b1a4bd-1bcf-11ee-9086-a0510b46b473/occlusion_a6b491c8-1bcf-11ee-9086-a0510b46b473/scan_168cd704-1bd2-11ee-9086-a0510b46b473/6a47ce82-1bd2-11ee-9086-a0510b46b473.png','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_a6b1a4bd-1bcf-11ee-9086-a0510b46b473_SESS_a6b491c8-1bcf-11ee-9086-a0510b46b473_TOSC_168cd704-1bd2-11ee-9086-a0510b46b473_SNAPS','6a47ce82-1bd2-11ee-9086-a0510b46b473.png','6a47ce82-1bd2-11ee-9086-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.3.1.7 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 09:55:03.523','2023-07-06 07:55:04.448',NULL),('6af17b8a-10d9-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/bd51960a-10d5-11ee-b636-a0510b46b473/session_c5e67f1c-10d5-11ee-b636-a0510b46b473/occlusion_c5e95a7b-10d5-11ee-b636-a0510b46b473/scan_40918071-10d9-11ee-b636-a0510b46b473/6af17b8a-10d9-11ee-b636-a0510b46b473.zip','PATIENT_bd51960a-10d5-11ee-b636-a0510b46b473_ACT_c5e67f1c-10d5-11ee-b636-a0510b46b473_SESS_c5e95a7b-10d5-11ee-b636-a0510b46b473_TOSC_40918071-10d9-11ee-b636-a0510b46b473_MODEL','6af17b8a-10d9-11ee-b636-a0510b46b473.zip','6af17b8a-10d9-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.17.1.1.5\",\"modelMatrix\":\"0.382177,0.917014,-0.114128,0,-0.924089,0.379251,-0.0472002,0,3.85202e-10,0.123503,0.992344,0,-12.2585,-17.079,-11.2175,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 10:47:28.322','2023-06-22 08:47:28.804',NULL),('6af192a2-10d9-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/bd51960a-10d5-11ee-b636-a0510b46b473/session_c5e67f1c-10d5-11ee-b636-a0510b46b473/occlusion_c5e95a7b-10d5-11ee-b636-a0510b46b473/scan_40918071-10d9-11ee-b636-a0510b46b473/6af192a2-10d9-11ee-b636-a0510b46b473.png','PATIENT_bd51960a-10d5-11ee-b636-a0510b46b473_ACT_c5e67f1c-10d5-11ee-b636-a0510b46b473_SESS_c5e95a7b-10d5-11ee-b636-a0510b46b473_TOSC_40918071-10d9-11ee-b636-a0510b46b473_SNAPS','6af192a2-10d9-11ee-b636-a0510b46b473.png','6af192a2-10d9-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.17.1.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 10:47:28.322','2023-06-22 08:47:28.807',NULL),('6b64b1ec-0f76-11ee-9460-a0510b46b473',11,'/home/scan/.data//2023/11/e4b67639-0f72-11ee-8712-a0510b46b473/session_ec7935d6-0f72-11ee-8712-a0510b46b473/occlusion_ec7bd8ad-0f72-11ee-8712-a0510b46b473/scan_f904f6dc-0f75-11ee-9460-a0510b46b473/6b64b1ec-0f76-11ee-9460-a0510b46b473.zip','PATIENT_e4b67639-0f72-11ee-8712-a0510b46b473_ACT_ec7935d6-0f72-11ee-8712-a0510b46b473_SESS_ec7bd8ad-0f72-11ee-8712-a0510b46b473_TOSC_f904f6dc-0f75-11ee-9460-a0510b46b473_MODEL','6b64b1ec-0f76-11ee-9460-a0510b46b473.zip','6b64b1ec-0f76-11ee-9460-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.15.1.1.3\",\"modelMatrix\":\"0.999305,0.0370112,-0.00437163,0,-0.0372685,0.992406,-0.117219,0,-4.20619e-10,0.117301,0.993096,0,-17.4497,11.3205,-13.7324,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-20 16:26:17.738','2023-06-20 14:26:18.583',NULL),('6b64ca01-0f76-11ee-9460-a0510b46b473',11,'/home/scan/.data//2023/11/e4b67639-0f72-11ee-8712-a0510b46b473/session_ec7935d6-0f72-11ee-8712-a0510b46b473/occlusion_ec7bd8ad-0f72-11ee-8712-a0510b46b473/scan_f904f6dc-0f75-11ee-9460-a0510b46b473/6b64ca01-0f76-11ee-9460-a0510b46b473.png','PATIENT_e4b67639-0f72-11ee-8712-a0510b46b473_ACT_ec7935d6-0f72-11ee-8712-a0510b46b473_SESS_ec7bd8ad-0f72-11ee-8712-a0510b46b473_TOSC_f904f6dc-0f75-11ee-9460-a0510b46b473_SNAPS','6b64ca01-0f76-11ee-9460-a0510b46b473.png','6b64ca01-0f76-11ee-9460-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.15.1.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-20 16:26:17.738','2023-06-20 14:26:18.591',NULL),('6c098868-e025-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_ed85304d-e024-11ed-bb13-00d86184ce3d/occlusion_ed88a64f-e024-11ed-bb13-00d86184ce3d/scan_125d5fc5-e025-11ed-bb13-00d86184ce3d/6c098868-e025-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_ed85304d-e024-11ed-bb13-00d86184ce3d_SESS_ed88a64f-e024-11ed-bb13-00d86184ce3d_TOSC_125d5fc5-e025-11ed-bb13-00d86184ce3d_MODEL','6c098868-e025-11ed-bb13-00d86184ce3d.zip','6c098868-e025-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.1.1.1\",\"modelMatrix\":\"-0.334592,0.929491,-0.155226,0,-0.942363,-0.330022,0.0551141,0,4.52432e-09,0.16472,0.98634,0,-11.6419,-28.1717,-7.092,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 11:18:04.933','2023-04-21 09:18:06.009',NULL),('6c09a1d5-e025-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_ed85304d-e024-11ed-bb13-00d86184ce3d/occlusion_ed88a64f-e024-11ed-bb13-00d86184ce3d/scan_125d5fc5-e025-11ed-bb13-00d86184ce3d/6c09a1d5-e025-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_ed85304d-e024-11ed-bb13-00d86184ce3d_SESS_ed88a64f-e024-11ed-bb13-00d86184ce3d_TOSC_125d5fc5-e025-11ed-bb13-00d86184ce3d_SNAPS','6c09a1d5-e025-11ed-bb13-00d86184ce3d.png','6c09a1d5-e025-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.1.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 11:18:04.933','2023-04-21 09:18:06.010',NULL),('6db19b1f-e353-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/6175c1d5-e350-11ed-8c5e-00d86184ce3d/session_ea1c884f-e352-11ed-8c5e-00d86184ce3d/occlusion_ea1f514a-e352-11ed-8c5e-00d86184ce3d/scan_2d9ffc1f-e353-11ed-8c5e-00d86184ce3d/6db19b1f-e353-11ed-8c5e-00d86184ce3d.zip','PATIENT_6175c1d5-e350-11ed-8c5e-00d86184ce3d_ACT_ea1c884f-e352-11ed-8c5e-00d86184ce3d_SESS_ea1f514a-e352-11ed-8c5e-00d86184ce3d_TOSC_2d9ffc1f-e353-11ed-8c5e-00d86184ce3d_MODEL','6db19b1f-e353-11ed-8c5e-00d86184ce3d.zip','6db19b1f-e353-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.13.2.1.2\",\"modelMatrix\":\"0.511226,0.799275,-0.315924,0,-0.859446,0.475434,-0.187922,0,-1.09195e-09,0.36759,0.929988,0,-31.043,-7.46846,-6.3288,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-25 12:24:58.050','2023-04-25 10:24:58.835',NULL),('6db1b504-e353-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/6175c1d5-e350-11ed-8c5e-00d86184ce3d/session_ea1c884f-e352-11ed-8c5e-00d86184ce3d/occlusion_ea1f514a-e352-11ed-8c5e-00d86184ce3d/scan_2d9ffc1f-e353-11ed-8c5e-00d86184ce3d/6db1b504-e353-11ed-8c5e-00d86184ce3d.png','PATIENT_6175c1d5-e350-11ed-8c5e-00d86184ce3d_ACT_ea1c884f-e352-11ed-8c5e-00d86184ce3d_SESS_ea1f514a-e352-11ed-8c5e-00d86184ce3d_TOSC_2d9ffc1f-e353-11ed-8c5e-00d86184ce3d_SNAPS','6db1b504-e353-11ed-8c5e-00d86184ce3d.png','6db1b504-e353-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.13.2.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-25 12:24:58.050','2023-04-25 10:24:58.835',NULL),('6e0c6fa6-e01e-11ed-a285-00d86184ce3d',11,'/home/scan/.data//2023/11/5f27680c-e01a-11ed-b6c2-00d86184ce3d/session_65b85f32-e01a-11ed-b6c2-00d86184ce3d/occlusion_65ba9a94-e01a-11ed-b6c2-00d86184ce3d/scan_2b3c7dd6-e01e-11ed-a285-00d86184ce3d/6e0c6fa6-e01e-11ed-a285-00d86184ce3d.zip','PATIENT_5f27680c-e01a-11ed-b6c2-00d86184ce3d_ACT_65b85f32-e01a-11ed-b6c2-00d86184ce3d_SESS_65ba9a94-e01a-11ed-b6c2-00d86184ce3d_TOSC_2b3c7dd6-e01e-11ed-a285-00d86184ce3d_MODEL','6e0c6fa6-e01e-11ed-a285-00d86184ce3d.zip','6e0c6fa6-e01e-11ed-a285-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.10.1.1.5\",\"modelMatrix\":\"-0.250351,0.887826,-0.38612,0,-0.968155,-0.229579,0.099845,0,-1.47342e-09,0.398821,0.917029,0,-15.4269,-28.4832,-4.99702,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 10:28:01.830','2023-04-21 08:28:02.699',NULL),('6e0c8491-e01e-11ed-a285-00d86184ce3d',11,'/home/scan/.data//2023/11/5f27680c-e01a-11ed-b6c2-00d86184ce3d/session_65b85f32-e01a-11ed-b6c2-00d86184ce3d/occlusion_65ba9a94-e01a-11ed-b6c2-00d86184ce3d/scan_2b3c7dd6-e01e-11ed-a285-00d86184ce3d/6e0c8491-e01e-11ed-a285-00d86184ce3d.png','PATIENT_5f27680c-e01a-11ed-b6c2-00d86184ce3d_ACT_65b85f32-e01a-11ed-b6c2-00d86184ce3d_SESS_65ba9a94-e01a-11ed-b6c2-00d86184ce3d_TOSC_2b3c7dd6-e01e-11ed-a285-00d86184ce3d_SNAPS','6e0c8491-e01e-11ed-a285-00d86184ce3d.png','6e0c8491-e01e-11ed-a285-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.10.1.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 10:28:01.830','2023-04-21 08:28:02.699',NULL),('6e891e60-1ca8-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_08b47e37-1ca8-11ee-997b-a0510b46b473/occlusion_08b766f9-1ca8-11ee-997b-a0510b46b473/scan_375a5159-1ca8-11ee-997b-a0510b46b473/6e891e60-1ca8-11ee-997b-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_08b47e37-1ca8-11ee-997b-a0510b46b473_SESS_08b766f9-1ca8-11ee-997b-a0510b46b473_TOSC_375a5159-1ca8-11ee-997b-a0510b46b473_MODEL','6e891e60-1ca8-11ee-997b-a0510b46b473.zip','6e891e60-1ca8-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.2.1.2\",\"modelMatrix\":\"0.886218,0.422532,-0.189957,0,-0.463268,0.808292,-0.363382,0,1.15192e-08,0.410037,0.912069,0,-30.4342,10.2375,-12.6844,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-07 11:27:02.962','2023-07-07 09:27:03.449',NULL),('6e89388b-1ca8-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_08b47e37-1ca8-11ee-997b-a0510b46b473/occlusion_08b766f9-1ca8-11ee-997b-a0510b46b473/scan_375a5159-1ca8-11ee-997b-a0510b46b473/6e89388b-1ca8-11ee-997b-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_08b47e37-1ca8-11ee-997b-a0510b46b473_SESS_08b766f9-1ca8-11ee-997b-a0510b46b473_TOSC_375a5159-1ca8-11ee-997b-a0510b46b473_SNAPS','6e89388b-1ca8-11ee-997b-a0510b46b473.png','6e89388b-1ca8-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.2.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-07 11:27:02.963','2023-07-07 09:27:03.449',NULL),('6f5c826b-2632-11ee-81dd-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_62519c59-261f-11ee-8042-a0510b46b473/occlusion_6253caa6-261f-11ee-8042-a0510b46b473/scan_e625c518-2631-11ee-81dd-a0510b46b473/6f5c826b-2632-11ee-81dd-a0510b46b473.zip','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_62519c59-261f-11ee-8042-a0510b46b473_SESS_6253caa6-261f-11ee-8042-a0510b46b473_BOSC_e625c518-2631-11ee-81dd-a0510b46b473_MODEL','6f5c826b-2632-11ee-81dd-a0510b46b473.zip','6f5c826b-2632-11ee-81dd-a0510b46b473','{\"displayTitle\":\"Mandibule 1.34.1.1.5\",\"modelMatrix\":\"0.870193,0.482011,-0.102119,0,-0.49271,0.851298,-0.180357,0,-8.40009e-09,0.207261,0.978286,0,-4.84795,-24.5798,-14.5779,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-19 14:47:35.361','2023-07-19 12:47:35.960',NULL),('6f5c95e8-2632-11ee-81dd-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_62519c59-261f-11ee-8042-a0510b46b473/occlusion_6253caa6-261f-11ee-8042-a0510b46b473/scan_e625c518-2631-11ee-81dd-a0510b46b473/6f5c95e8-2632-11ee-81dd-a0510b46b473.png','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_62519c59-261f-11ee-8042-a0510b46b473_SESS_6253caa6-261f-11ee-8042-a0510b46b473_BOSC_e625c518-2631-11ee-81dd-a0510b46b473_SNAPS','6f5c95e8-2632-11ee-81dd-a0510b46b473.png','6f5c95e8-2632-11ee-81dd-a0510b46b473','{\"displayTitle\":\"Mandibule 1.34.1.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-19 14:47:35.362','2023-07-19 12:47:35.963',NULL),('700ec7ca-2578-11ee-b81b-a0510b46b473',11,'/home/scan/.data//2023/11/49f1e276-256f-11ee-91d6-a0510b46b473/session_f58279e9-2576-11ee-b81b-a0510b46b473/occlusion_f584e68a-2576-11ee-b81b-a0510b46b473/scan_5d93ab2a-2578-11ee-b81b-a0510b46b473/700ec7ca-2578-11ee-b81b-a0510b46b473.zip','PATIENT_49f1e276-256f-11ee-91d6-a0510b46b473_ACT_f58279e9-2576-11ee-b81b-a0510b46b473_SESS_f584e68a-2576-11ee-b81b-a0510b46b473_TOSC_5d93ab2a-2578-11ee-b81b-a0510b46b473_MODEL','700ec7ca-2578-11ee-b81b-a0510b46b473.zip','700ec7ca-2578-11ee-b81b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.33.2.1.3\",\"modelMatrix\":\"0.363075,-0.854434,0.371644,0,0.93176,0.332943,-0.144817,0,-1.10364e-09,0.398862,0.917011,0,0.655544,-2.77777,-4.44975,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-18 16:36:10.138','2023-07-18 14:36:10.248',NULL),('700edf11-2578-11ee-b81b-a0510b46b473',11,'/home/scan/.data//2023/11/49f1e276-256f-11ee-91d6-a0510b46b473/session_f58279e9-2576-11ee-b81b-a0510b46b473/occlusion_f584e68a-2576-11ee-b81b-a0510b46b473/scan_5d93ab2a-2578-11ee-b81b-a0510b46b473/700edf11-2578-11ee-b81b-a0510b46b473.png','PATIENT_49f1e276-256f-11ee-91d6-a0510b46b473_ACT_f58279e9-2576-11ee-b81b-a0510b46b473_SESS_f584e68a-2576-11ee-b81b-a0510b46b473_TOSC_5d93ab2a-2578-11ee-b81b-a0510b46b473_SNAPS','700edf11-2578-11ee-b81b-a0510b46b473.png','700edf11-2578-11ee-b81b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.33.2.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-18 16:36:10.139','2023-07-18 14:36:10.251',NULL),('712c59a6-dd17-11ed-8097-00d86184ce3d',11,'/home/scan/.data//2023/11/59af3050-dcfe-11ed-8097-00d86184ce3d/session_aed62174-dd16-11ed-8097-00d86184ce3d/occlusion_aed90f86-dd16-11ed-8097-00d86184ce3d/scan_f93b48d7-dd16-11ed-8097-00d86184ce3d/712c59a6-dd17-11ed-8097-00d86184ce3d.zip','PATIENT_59af3050-dcfe-11ed-8097-00d86184ce3d_ACT_aed62174-dd16-11ed-8097-00d86184ce3d_SESS_aed90f86-dd16-11ed-8097-00d86184ce3d_TOSC_f93b48d7-dd16-11ed-8097-00d86184ce3d_MODEL','712c59a6-dd17-11ed-8097-00d86184ce3d.zip','712c59a6-dd17-11ed-8097-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.1.2.1.2\",\"modelMatrix\":\"0.600297,0.786668,-0.14421,0,-0.799777,0.590458,-0.108241,0,9.25893e-09,0.180313,0.983609,0,-23.7011,-4.70408,-9.65093,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-04-17 14:00:27.107','2023-04-17 12:00:28.197','2023-04-17 14:00:28.580'),('712da277-dd17-11ed-8097-00d86184ce3d',11,'/home/scan/.data//2023/11/59af3050-dcfe-11ed-8097-00d86184ce3d/session_aed62174-dd16-11ed-8097-00d86184ce3d/occlusion_aed90f86-dd16-11ed-8097-00d86184ce3d/scan_f93b48d7-dd16-11ed-8097-00d86184ce3d/712da277-dd17-11ed-8097-00d86184ce3d.png','PATIENT_59af3050-dcfe-11ed-8097-00d86184ce3d_ACT_aed62174-dd16-11ed-8097-00d86184ce3d_SESS_aed90f86-dd16-11ed-8097-00d86184ce3d_TOSC_f93b48d7-dd16-11ed-8097-00d86184ce3d_SNAPS','712da277-dd17-11ed-8097-00d86184ce3d.png','712da277-dd17-11ed-8097-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.1.2.1.2 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-04-17 14:00:27.115','2023-04-17 12:00:28.198','2023-04-17 14:00:28.695'),('713537ab-1033-11ee-895b-a0510b46b473',11,'/home/scan/.data//2023/11/d75719c6-1032-11ee-895b-a0510b46b473/session_e5c513d4-1032-11ee-895b-a0510b46b473/occlusion_e5c7f174-1032-11ee-895b-a0510b46b473/scan_37459e1a-1033-11ee-895b-a0510b46b473/713537ab-1033-11ee-895b-a0510b46b473.zip','PATIENT_d75719c6-1032-11ee-895b-a0510b46b473_ACT_e5c513d4-1032-11ee-895b-a0510b46b473_SESS_e5c7f174-1032-11ee-895b-a0510b46b473_TOSC_37459e1a-1033-11ee-895b-a0510b46b473_MODEL','713537ab-1033-11ee-895b-a0510b46b473.zip','713537ab-1033-11ee-895b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.16.1.1.2\",\"modelMatrix\":\"0.258891,0.90587,-0.335224,0,-0.965907,0.242799,-0.0898498,0,-6.89342e-09,0.347056,0.937844,0,-21.2908,-21.8709,-4.84685,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-21 14:59:22.375','2023-06-21 12:59:23.120',NULL),('7135508c-1033-11ee-895b-a0510b46b473',11,'/home/scan/.data//2023/11/d75719c6-1032-11ee-895b-a0510b46b473/session_e5c513d4-1032-11ee-895b-a0510b46b473/occlusion_e5c7f174-1032-11ee-895b-a0510b46b473/scan_37459e1a-1033-11ee-895b-a0510b46b473/7135508c-1033-11ee-895b-a0510b46b473.png','PATIENT_d75719c6-1032-11ee-895b-a0510b46b473_ACT_e5c513d4-1032-11ee-895b-a0510b46b473_SESS_e5c7f174-1032-11ee-895b-a0510b46b473_TOSC_37459e1a-1033-11ee-895b-a0510b46b473_SNAPS','7135508c-1033-11ee-895b-a0510b46b473.png','7135508c-1033-11ee-895b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.16.1.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-21 14:59:22.376','2023-06-21 12:59:23.129',NULL),('71423219-1a64-11ee-9a4f-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_56e1eee3-1a49-11ee-9a4f-a0510b46b473/occlusion_56e449e9-1a49-11ee-9a4f-a0510b46b473/scan_14008eff-1a64-11ee-9a4f-a0510b46b473/71423219-1a64-11ee-9a4f-a0510b46b473.zip','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_56e1eee3-1a49-11ee-9a4f-a0510b46b473_SESS_56e449e9-1a49-11ee-9a4f-a0510b46b473_TOSC_14008eff-1a64-11ee-9a4f-a0510b46b473_MODEL','71423219-1a64-11ee-9a4f-a0510b46b473.zip','71423219-1a64-11ee-9a4f-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.1.1.10\",\"modelMatrix\":\"0.0297231,0.980562,-0.193945,0,-0.999558,0.0291582,-0.00576719,0,-9.06818e-11,0.194031,0.980995,0,-22.2216,-22.0465,-8.83503,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-04 14:15:19.428','2023-07-04 12:15:20.251',NULL),('7142482c-1a64-11ee-9a4f-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_56e1eee3-1a49-11ee-9a4f-a0510b46b473/occlusion_56e449e9-1a49-11ee-9a4f-a0510b46b473/scan_14008eff-1a64-11ee-9a4f-a0510b46b473/7142482c-1a64-11ee-9a4f-a0510b46b473.png','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_56e1eee3-1a49-11ee-9a4f-a0510b46b473_SESS_56e449e9-1a49-11ee-9a4f-a0510b46b473_TOSC_14008eff-1a64-11ee-9a4f-a0510b46b473_SNAPS','7142482c-1a64-11ee-9a4f-a0510b46b473.png','7142482c-1a64-11ee-9a4f-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.1.1.10 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-04 14:15:19.428','2023-07-04 12:15:20.254',NULL),('71b669eb-14f8-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/8283c62f-14f6-11ee-b3b1-00d86184ce3d/session_8d62c238-14f6-11ee-b3b1-00d86184ce3d/occlusion_8d65509a-14f6-11ee-b3b1-00d86184ce3d/scan_042354a4-14f8-11ee-b3b1-00d86184ce3d/71b669eb-14f8-11ee-b3b1-00d86184ce3d.zip','PATIENT_8283c62f-14f6-11ee-b3b1-00d86184ce3d_ACT_8d62c238-14f6-11ee-b3b1-00d86184ce3d_SESS_8d65509a-14f6-11ee-b3b1-00d86184ce3d_TOSC_042354a4-14f8-11ee-b3b1-00d86184ce3d_MODEL','71b669eb-14f8-11ee-b3b1-00d86184ce3d.zip','71b669eb-14f8-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.23.1.1.2\",\"modelMatrix\":\"0.577366,0.786172,-0.220412,0,-0.816485,0.555931,-0.155861,0,2.05944e-10,0.269952,0.962874,0,-29.4456,-8.24414,-9.78668,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-27 16:39:38.729','2023-06-27 14:39:39.606',NULL),('71b7ab6c-14f8-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/8283c62f-14f6-11ee-b3b1-00d86184ce3d/session_8d62c238-14f6-11ee-b3b1-00d86184ce3d/occlusion_8d65509a-14f6-11ee-b3b1-00d86184ce3d/scan_042354a4-14f8-11ee-b3b1-00d86184ce3d/71b7ab6c-14f8-11ee-b3b1-00d86184ce3d.png','PATIENT_8283c62f-14f6-11ee-b3b1-00d86184ce3d_ACT_8d62c238-14f6-11ee-b3b1-00d86184ce3d_SESS_8d65509a-14f6-11ee-b3b1-00d86184ce3d_TOSC_042354a4-14f8-11ee-b3b1-00d86184ce3d_SNAPS','71b7ab6c-14f8-11ee-b3b1-00d86184ce3d.png','71b7ab6c-14f8-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.23.1.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-27 16:39:38.737','2023-06-27 14:39:39.607',NULL),('71f60692-1c00-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/8a8cc548-1bf9-11ee-9323-a0510b46b473/session_ff6745bb-1bff-11ee-9323-a0510b46b473/occlusion_ff6924df-1bff-11ee-9323-a0510b46b473/scan_3f46983b-1c00-11ee-9323-a0510b46b473/71f60692-1c00-11ee-9323-a0510b46b473.zip','PATIENT_8a8cc548-1bf9-11ee-9323-a0510b46b473_ACT_ff6745bb-1bff-11ee-9323-a0510b46b473_SESS_ff6924df-1bff-11ee-9323-a0510b46b473_TOSC_3f46983b-1c00-11ee-9323-a0510b46b473_MODEL','71f60692-1c00-11ee-9323-a0510b46b473.zip','71f60692-1c00-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.28.2.1.2\",\"modelMatrix\":\"0.961468,0.20469,-0.183523,0,-0.274916,0.715866,-0.641839,0,-1.02267e-08,0.667561,0.744555,0,-31.1255,8.25755,-14.4168,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 15:24:33.259','2023-07-06 13:24:33.701',NULL),('71f61b3e-1c00-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/8a8cc548-1bf9-11ee-9323-a0510b46b473/session_ff6745bb-1bff-11ee-9323-a0510b46b473/occlusion_ff6924df-1bff-11ee-9323-a0510b46b473/scan_3f46983b-1c00-11ee-9323-a0510b46b473/71f61b3e-1c00-11ee-9323-a0510b46b473.png','PATIENT_8a8cc548-1bf9-11ee-9323-a0510b46b473_ACT_ff6745bb-1bff-11ee-9323-a0510b46b473_SESS_ff6924df-1bff-11ee-9323-a0510b46b473_TOSC_3f46983b-1c00-11ee-9323-a0510b46b473_SNAPS','71f61b3e-1c00-11ee-9323-a0510b46b473.png','71f61b3e-1c00-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.28.2.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 15:24:33.259','2023-07-06 13:24:33.704',NULL),('73a588e8-1ca4-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_06fff4e1-1ca0-11ee-84c4-a0510b46b473/occlusion_0701c127-1ca0-11ee-84c4-a0510b46b473/scan_1734b0eb-1ca4-11ee-997b-a0510b46b473/73a588e8-1ca4-11ee-997b-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_06fff4e1-1ca0-11ee-84c4-a0510b46b473_SESS_0701c127-1ca0-11ee-84c4-a0510b46b473_TOSC_1734b0eb-1ca4-11ee-997b-a0510b46b473_MODEL','73a588e8-1ca4-11ee-997b-a0510b46b473.zip','73a588e8-1ca4-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.1.1.11\",\"modelMatrix\":\"0.929047,0.360672,-0.0823838,0,-0.369962,0.90572,-0.206882,0,4.90922e-09,0.222682,0.974891,0,-27.4321,9.89049,-13.4123,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-07 10:58:33.550','2023-07-07 08:58:34.371',NULL),('73a6c660-1ca4-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_06fff4e1-1ca0-11ee-84c4-a0510b46b473/occlusion_0701c127-1ca0-11ee-84c4-a0510b46b473/scan_1734b0eb-1ca4-11ee-997b-a0510b46b473/73a6c660-1ca4-11ee-997b-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_06fff4e1-1ca0-11ee-84c4-a0510b46b473_SESS_0701c127-1ca0-11ee-84c4-a0510b46b473_TOSC_1734b0eb-1ca4-11ee-997b-a0510b46b473_SNAPS','73a6c660-1ca4-11ee-997b-a0510b46b473.png','73a6c660-1ca4-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.1.1.11 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-07 10:58:33.558','2023-07-07 08:58:34.371',NULL),('73e2b189-de9c-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/35e16a68-de95-11ed-9cc3-00d86184ce3d/session_450c29ef-de95-11ed-9cc3-00d86184ce3d/occlusion_450efda8-de95-11ed-9cc3-00d86184ce3d/scan_0bb3f9ba-de9c-11ed-9cc3-00d86184ce3d/73e2b189-de9c-11ed-9cc3-00d86184ce3d.zip','PATIENT_35e16a68-de95-11ed-9cc3-00d86184ce3d_ACT_450c29ef-de95-11ed-9cc3-00d86184ce3d_SESS_450efda8-de95-11ed-9cc3-00d86184ce3d_TOSC_0bb3f9ba-de9c-11ed-9cc3-00d86184ce3d_MODEL','73e2b189-de9c-11ed-9cc3-00d86184ce3d.zip','73e2b189-de9c-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.4.1.1.9\",\"modelMatrix\":\"0.31207,0.93096,-0.189542,0,-0.950059,0.305796,-0.0622597,0,1.44408e-09,0.199506,0.979897,0,-24.5097,-21.4898,-11.6574,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-19 12:25:05.885','2023-04-19 10:25:07.108',NULL),('73e3ed1f-de9c-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/35e16a68-de95-11ed-9cc3-00d86184ce3d/session_450c29ef-de95-11ed-9cc3-00d86184ce3d/occlusion_450efda8-de95-11ed-9cc3-00d86184ce3d/scan_0bb3f9ba-de9c-11ed-9cc3-00d86184ce3d/73e3ed1f-de9c-11ed-9cc3-00d86184ce3d.png','PATIENT_35e16a68-de95-11ed-9cc3-00d86184ce3d_ACT_450c29ef-de95-11ed-9cc3-00d86184ce3d_SESS_450efda8-de95-11ed-9cc3-00d86184ce3d_TOSC_0bb3f9ba-de9c-11ed-9cc3-00d86184ce3d_SNAPS','73e3ed1f-de9c-11ed-9cc3-00d86184ce3d.png','73e3ed1f-de9c-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.4.1.1.9 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-19 12:25:05.893','2023-04-19 10:25:07.109',NULL),('74733a92-262a-11ee-8042-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_62519c59-261f-11ee-8042-a0510b46b473/occlusion_6253caa6-261f-11ee-8042-a0510b46b473/scan_21ce8315-262a-11ee-8042-a0510b46b473/74733a92-262a-11ee-8042-a0510b46b473.zip','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_62519c59-261f-11ee-8042-a0510b46b473_SESS_6253caa6-261f-11ee-8042-a0510b46b473_TOSC_21ce8315-262a-11ee-8042-a0510b46b473_MODEL','74733a92-262a-11ee-8042-a0510b46b473.zip','74733a92-262a-11ee-8042-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.1.1.5\",\"modelMatrix\":\"-0.255883,0.942989,-0.212829,0,-0.966708,-0.249605,0.0563348,0,-8.16943e-10,0.220158,0.975464,0,-9.46797,-27.8071,-8.4875,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-19 13:50:27.925','2023-07-19 11:50:28.569',NULL),('74735269-262a-11ee-8042-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_62519c59-261f-11ee-8042-a0510b46b473/occlusion_6253caa6-261f-11ee-8042-a0510b46b473/scan_21ce8315-262a-11ee-8042-a0510b46b473/74735269-262a-11ee-8042-a0510b46b473.png','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_62519c59-261f-11ee-8042-a0510b46b473_SESS_6253caa6-261f-11ee-8042-a0510b46b473_TOSC_21ce8315-262a-11ee-8042-a0510b46b473_SNAPS','74735269-262a-11ee-8042-a0510b46b473.png','74735269-262a-11ee-8042-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.1.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-19 13:50:27.926','2023-07-19 11:50:28.570',NULL),('74bfe542-de8a-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/f29210da-de80-11ed-9cc3-00d86184ce3d/session_ffdb9942-de80-11ed-9cc3-00d86184ce3d/occlusion_ffdebb3e-de80-11ed-9cc3-00d86184ce3d/scan_42a16325-de8a-11ed-9cc3-00d86184ce3d/74bfe542-de8a-11ed-9cc3-00d86184ce3d.zip','PATIENT_f29210da-de80-11ed-9cc3-00d86184ce3d_ACT_ffdb9942-de80-11ed-9cc3-00d86184ce3d_SESS_ffdebb3e-de80-11ed-9cc3-00d86184ce3d_TOSC_42a16325-de8a-11ed-9cc3-00d86184ce3d_MODEL','74bfe542-de8a-11ed-9cc3-00d86184ce3d.zip','74bfe542-de8a-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.3.1.1.8\",\"modelMatrix\":\"0.579852,-0.80292,0.13817,0,0.814722,0.571452,-0.0983379,0,-1.02572e-08,0.169592,0.985514,0,10.4995,22.7727,-17.9307,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-19 10:16:16.394','2023-04-19 08:16:16.895',NULL),('74c1455d-de8a-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/f29210da-de80-11ed-9cc3-00d86184ce3d/session_ffdb9942-de80-11ed-9cc3-00d86184ce3d/occlusion_ffdebb3e-de80-11ed-9cc3-00d86184ce3d/scan_42a16325-de8a-11ed-9cc3-00d86184ce3d/74c1455d-de8a-11ed-9cc3-00d86184ce3d.png','PATIENT_f29210da-de80-11ed-9cc3-00d86184ce3d_ACT_ffdb9942-de80-11ed-9cc3-00d86184ce3d_SESS_ffdebb3e-de80-11ed-9cc3-00d86184ce3d_TOSC_42a16325-de8a-11ed-9cc3-00d86184ce3d_SNAPS','74c1455d-de8a-11ed-9cc3-00d86184ce3d.png','74c1455d-de8a-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.3.1.1.8 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-19 10:16:16.403','2023-04-19 08:16:16.895',NULL),('74f735d2-1a66-11ee-9a4f-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_319e146c-1a66-11ee-9a4f-a0510b46b473/occlusion_31a0a20e-1a66-11ee-9a4f-a0510b46b473/scan_4133bf78-1a66-11ee-9a4f-a0510b46b473/74f735d2-1a66-11ee-9a4f-a0510b46b473.zip','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_319e146c-1a66-11ee-9a4f-a0510b46b473_SESS_31a0a20e-1a66-11ee-9a4f-a0510b46b473_TOSC_4133bf78-1a66-11ee-9a4f-a0510b46b473_MODEL','74f735d2-1a66-11ee-9a4f-a0510b46b473.zip','74f735d2-1a66-11ee-9a4f-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.3.1.1\",\"modelMatrix\":\"0.877321,0.429452,-0.214193,0,-0.479904,0.785089,-0.39157,0,-5.29613e-09,0.446325,0.894871,0,-33.0278,2.35623,-10.9248,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-04 14:29:44.640','2023-07-04 12:29:46.596',NULL),('74f74ddb-1a66-11ee-9a4f-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_319e146c-1a66-11ee-9a4f-a0510b46b473/occlusion_31a0a20e-1a66-11ee-9a4f-a0510b46b473/scan_4133bf78-1a66-11ee-9a4f-a0510b46b473/74f74ddb-1a66-11ee-9a4f-a0510b46b473.png','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_319e146c-1a66-11ee-9a4f-a0510b46b473_SESS_31a0a20e-1a66-11ee-9a4f-a0510b46b473_TOSC_4133bf78-1a66-11ee-9a4f-a0510b46b473_SNAPS','74f74ddb-1a66-11ee-9a4f-a0510b46b473.png','74f74ddb-1a66-11ee-9a4f-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.3.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-04 14:29:44.641','2023-07-04 12:29:46.596',NULL),('75b99ab6-26e4-11ee-a836-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_d5ef2d6b-26e3-11ee-a836-a0510b46b473/occlusion_d5f241c9-26e3-11ee-a836-a0510b46b473/scan_25a75139-26e4-11ee-a836-a0510b46b473/75b99ab6-26e4-11ee-a836-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_d5ef2d6b-26e3-11ee-a836-a0510b46b473_SESS_d5f241c9-26e3-11ee-a836-a0510b46b473_TOSC_25a75139-26e4-11ee-a836-a0510b46b473_MODEL','75b99ab6-26e4-11ee-a836-a0510b46b473.zip','75b99ab6-26e4-11ee-a836-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.5.1.2\",\"modelMatrix\":\"0.646469,0.741234,-0.180691,0,-0.76294,0.628077,-0.153107,0,-1.11715e-08,0.236835,0.97155,0,-32.4177,-8.60126,-12.4764,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-20 12:01:56.456','2023-07-20 10:01:57.175',NULL),('75b9b18a-26e4-11ee-a836-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_d5ef2d6b-26e3-11ee-a836-a0510b46b473/occlusion_d5f241c9-26e3-11ee-a836-a0510b46b473/scan_25a75139-26e4-11ee-a836-a0510b46b473/75b9b18a-26e4-11ee-a836-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_d5ef2d6b-26e3-11ee-a836-a0510b46b473_SESS_d5f241c9-26e3-11ee-a836-a0510b46b473_TOSC_25a75139-26e4-11ee-a836-a0510b46b473_SNAPS','75b9b18a-26e4-11ee-a836-a0510b46b473.png','75b9b18a-26e4-11ee-a836-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.5.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-20 12:01:56.456','2023-07-20 10:01:57.176',NULL),('76136fce-2ae5-11ee-95bc-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_b5fe1002-2ae0-11ee-95bc-a0510b46b473/occlusion_b6012772-2ae0-11ee-95bc-a0510b46b473/scan_488d704f-2ae5-11ee-95bc-a0510b46b473/76136fce-2ae5-11ee-95bc-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_b5fe1002-2ae0-11ee-95bc-a0510b46b473_SESS_b6012772-2ae0-11ee-95bc-a0510b46b473_TOSC_488d704f-2ae5-11ee-95bc-a0510b46b473_MODEL','76136fce-2ae5-11ee-95bc-a0510b46b473.zip','76136fce-2ae5-11ee-95bc-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.8.1.4\",\"modelMatrix\":\"0.376782,0.914484,-0.147494,0,-0.926302,0.371975,-0.0599945,0,4.28913e-09,0.159228,0.987242,0,-34.1943,-13.1694,-8.17709,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-25 14:19:11.192','2023-07-25 12:19:11.552',NULL),('76138b1e-2ae5-11ee-95bc-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_b5fe1002-2ae0-11ee-95bc-a0510b46b473/occlusion_b6012772-2ae0-11ee-95bc-a0510b46b473/scan_488d704f-2ae5-11ee-95bc-a0510b46b473/76138b1e-2ae5-11ee-95bc-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_b5fe1002-2ae0-11ee-95bc-a0510b46b473_SESS_b6012772-2ae0-11ee-95bc-a0510b46b473_TOSC_488d704f-2ae5-11ee-95bc-a0510b46b473_SNAPS','76138b1e-2ae5-11ee-95bc-a0510b46b473.png','76138b1e-2ae5-11ee-95bc-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.8.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-25 14:19:11.193','2023-07-25 12:19:11.553',NULL),('779b0873-10e3-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/2ff330cd-10e1-11ee-b636-a0510b46b473/session_3adeac35-10e1-11ee-b636-a0510b46b473/occlusion_3ae23ec4-10e1-11ee-b636-a0510b46b473/scan_29414f74-10e3-11ee-b636-a0510b46b473/779b0873-10e3-11ee-b636-a0510b46b473.zip','PATIENT_2ff330cd-10e1-11ee-b636-a0510b46b473_ACT_3adeac35-10e1-11ee-b636-a0510b46b473_SESS_3ae23ec4-10e1-11ee-b636-a0510b46b473_TOSC_29414f74-10e3-11ee-b636-a0510b46b473_MODEL','779b0873-10e3-11ee-b636-a0510b46b473.zip','779b0873-10e3-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.18.1.1.6\",\"modelMatrix\":\"0.148029,0.979018,-0.140042,0,-0.988983,0.146537,-0.0209613,0,-8.13518e-11,0.141602,0.989924,0,-20.0146,-28.1467,-9.7646,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 11:59:24.533','2023-06-22 09:59:25.262',NULL),('779b1dd5-10e3-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/2ff330cd-10e1-11ee-b636-a0510b46b473/session_3adeac35-10e1-11ee-b636-a0510b46b473/occlusion_3ae23ec4-10e1-11ee-b636-a0510b46b473/scan_29414f74-10e3-11ee-b636-a0510b46b473/779b1dd5-10e3-11ee-b636-a0510b46b473.png','PATIENT_2ff330cd-10e1-11ee-b636-a0510b46b473_ACT_3adeac35-10e1-11ee-b636-a0510b46b473_SESS_3ae23ec4-10e1-11ee-b636-a0510b46b473_TOSC_29414f74-10e3-11ee-b636-a0510b46b473_SNAPS','779b1dd5-10e3-11ee-b636-a0510b46b473.png','779b1dd5-10e3-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.18.1.1.6 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 11:59:24.533','2023-06-22 09:59:25.262',NULL),('77cdbb46-e355-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_853ebc79-e33f-11ed-8c5e-00d86184ce3d/occlusion_8541c500-e33f-11ed-8c5e-00d86184ce3d/scan_25d7d863-e355-11ed-8c5e-00d86184ce3d/77cdbb46-e355-11ed-8c5e-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_853ebc79-e33f-11ed-8c5e-00d86184ce3d_SESS_8541c500-e33f-11ed-8c5e-00d86184ce3d_TOSC_25d7d863-e355-11ed-8c5e-00d86184ce3d_MODEL','77cdbb46-e355-11ed-8c5e-00d86184ce3d.zip','77cdbb46-e355-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.6.1.9\",\"modelMatrix\":\"0.757618,0.627112,-0.180956,0,-0.652698,0.727919,-0.210045,0,-1.01743e-08,0.277244,0.9608,0,-26.7689,3.05748,-10.1891,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-25 12:39:34.005','2023-04-25 10:39:34.856',NULL),('77cdca3e-e355-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_853ebc79-e33f-11ed-8c5e-00d86184ce3d/occlusion_8541c500-e33f-11ed-8c5e-00d86184ce3d/scan_25d7d863-e355-11ed-8c5e-00d86184ce3d/77cdca3e-e355-11ed-8c5e-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_853ebc79-e33f-11ed-8c5e-00d86184ce3d_SESS_8541c500-e33f-11ed-8c5e-00d86184ce3d_TOSC_25d7d863-e355-11ed-8c5e-00d86184ce3d_SNAPS','77cdca3e-e355-11ed-8c5e-00d86184ce3d.png','77cdca3e-e355-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.6.1.9 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-25 12:39:34.005','2023-04-25 10:39:34.857',NULL),('7869ef06-dd04-11ed-8097-00d86184ce3d',11,'/home/scan/.data//2023/11/59af3050-dcfe-11ed-8097-00d86184ce3d/session_61025fcf-dcfe-11ed-8097-00d86184ce3d/occlusion_610548c3-dcfe-11ed-8097-00d86184ce3d/scan_2303941b-dd04-11ed-8097-00d86184ce3d/7869ef06-dd04-11ed-8097-00d86184ce3d.zip','PATIENT_59af3050-dcfe-11ed-8097-00d86184ce3d_ACT_61025fcf-dcfe-11ed-8097-00d86184ce3d_SESS_610548c3-dcfe-11ed-8097-00d86184ce3d_TOSC_2303941b-dd04-11ed-8097-00d86184ce3d_MODEL','7869ef06-dd04-11ed-8097-00d86184ce3d.zip','7869ef06-dd04-11ed-8097-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.1.1.1.9\",\"modelMatrix\":\"-0.572386,0.799715,-0.181191,0,-0.819985,-0.558237,0.12648,0,4.17083e-09,0.220969,0.975281,0,-7.56698,-31.0147,-7.73429,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-04-17 11:44:38.817','2023-04-17 09:44:39.743','2023-04-17 11:44:40.158'),('786a0491-dd04-11ed-8097-00d86184ce3d',11,'/home/scan/.data//2023/11/59af3050-dcfe-11ed-8097-00d86184ce3d/session_61025fcf-dcfe-11ed-8097-00d86184ce3d/occlusion_610548c3-dcfe-11ed-8097-00d86184ce3d/scan_2303941b-dd04-11ed-8097-00d86184ce3d/786a0491-dd04-11ed-8097-00d86184ce3d.png','PATIENT_59af3050-dcfe-11ed-8097-00d86184ce3d_ACT_61025fcf-dcfe-11ed-8097-00d86184ce3d_SESS_610548c3-dcfe-11ed-8097-00d86184ce3d_TOSC_2303941b-dd04-11ed-8097-00d86184ce3d_SNAPS','786a0491-dd04-11ed-8097-00d86184ce3d.png','786a0491-dd04-11ed-8097-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.1.1.1.9 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-04-17 11:44:38.817','2023-04-17 09:44:39.744','2023-04-17 11:44:40.284'),('79096dee-dd02-11ed-8097-00d86184ce3d',11,'/home/scan/.data//2023/11/59af3050-dcfe-11ed-8097-00d86184ce3d/session_61025fcf-dcfe-11ed-8097-00d86184ce3d/occlusion_610548c3-dcfe-11ed-8097-00d86184ce3d/scan_ea3dadec-dd01-11ed-8097-00d86184ce3d/79096dee-dd02-11ed-8097-00d86184ce3d.zip','PATIENT_59af3050-dcfe-11ed-8097-00d86184ce3d_ACT_61025fcf-dcfe-11ed-8097-00d86184ce3d_SESS_610548c3-dcfe-11ed-8097-00d86184ce3d_BOSC_ea3dadec-dd01-11ed-8097-00d86184ce3d_MODEL','79096dee-dd02-11ed-8097-00d86184ce3d.zip','79096dee-dd02-11ed-8097-00d86184ce3d','{\"displayTitle\":\"Mandibule 1.1.1.1.2\",\"modelMatrix\":\"0.717071,0.669409,-0.194166,0,-0.697,0.688686,-0.199757,0,1.84571e-08,0.278574,0.960415,0,-34.0046,-0.00123906,-5.28592,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-04-17 11:30:20.868','2023-04-17 09:30:21.942','2023-04-17 11:30:22.259'),('7909f57e-dd02-11ed-8097-00d86184ce3d',11,'/home/scan/.data//2023/11/59af3050-dcfe-11ed-8097-00d86184ce3d/session_61025fcf-dcfe-11ed-8097-00d86184ce3d/occlusion_610548c3-dcfe-11ed-8097-00d86184ce3d/scan_ea3dadec-dd01-11ed-8097-00d86184ce3d/7909f57e-dd02-11ed-8097-00d86184ce3d.png','PATIENT_59af3050-dcfe-11ed-8097-00d86184ce3d_ACT_61025fcf-dcfe-11ed-8097-00d86184ce3d_SESS_610548c3-dcfe-11ed-8097-00d86184ce3d_BOSC_ea3dadec-dd01-11ed-8097-00d86184ce3d_SNAPS','7909f57e-dd02-11ed-8097-00d86184ce3d.png','7909f57e-dd02-11ed-8097-00d86184ce3d','{\"displayTitle\":\"Mandibule 1.1.1.1.2 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-04-17 11:30:20.872','2023-04-17 09:30:21.942','2023-04-17 11:30:22.444'),('7a10057a-1ca2-11ee-84c4-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_06fff4e1-1ca0-11ee-84c4-a0510b46b473/occlusion_0701c127-1ca0-11ee-84c4-a0510b46b473/scan_2fdfbb85-1ca2-11ee-84c4-a0510b46b473/7a10057a-1ca2-11ee-84c4-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_06fff4e1-1ca0-11ee-84c4-a0510b46b473_SESS_0701c127-1ca0-11ee-84c4-a0510b46b473_TOSC_2fdfbb85-1ca2-11ee-84c4-a0510b46b473_MODEL','7a10057a-1ca2-11ee-84c4-a0510b46b473.zip','7a10057a-1ca2-11ee-84c4-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.1.1.7\",\"modelMatrix\":\"0.444803,0.889021,-0.108587,0,-0.895628,0.441522,-0.0539285,0,-4.66793e-09,0.121241,0.992623,0,-26.8492,-10.2233,-11.472,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-07 10:44:25.321','2023-07-07 08:44:25.916',NULL),('7a101ab8-1ca2-11ee-84c4-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_06fff4e1-1ca0-11ee-84c4-a0510b46b473/occlusion_0701c127-1ca0-11ee-84c4-a0510b46b473/scan_2fdfbb85-1ca2-11ee-84c4-a0510b46b473/7a101ab8-1ca2-11ee-84c4-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_06fff4e1-1ca0-11ee-84c4-a0510b46b473_SESS_0701c127-1ca0-11ee-84c4-a0510b46b473_TOSC_2fdfbb85-1ca2-11ee-84c4-a0510b46b473_SNAPS','7a101ab8-1ca2-11ee-84c4-a0510b46b473.png','7a101ab8-1ca2-11ee-84c4-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.1.1.7 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-07 10:44:25.321','2023-07-07 08:44:25.917',NULL),('7a156738-1ca3-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_06fff4e1-1ca0-11ee-84c4-a0510b46b473/occlusion_0701c127-1ca0-11ee-84c4-a0510b46b473/scan_3579b26b-1ca3-11ee-997b-a0510b46b473/7a156738-1ca3-11ee-997b-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_06fff4e1-1ca0-11ee-84c4-a0510b46b473_SESS_0701c127-1ca0-11ee-84c4-a0510b46b473_TOSC_3579b26b-1ca3-11ee-997b-a0510b46b473_MODEL','7a156738-1ca3-11ee-997b-a0510b46b473.zip','7a156738-1ca3-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.1.1.9\",\"modelMatrix\":\"0.246467,0.930244,-0.271844,0,-0.969151,0.236572,-0.0691332,0,-1.9745e-09,0.280497,0.959855,0,-26.7782,-14.9832,-9.47374,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-07 10:51:34.853','2023-07-07 08:51:35.507',NULL),('7a157f8b-1ca3-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_06fff4e1-1ca0-11ee-84c4-a0510b46b473/occlusion_0701c127-1ca0-11ee-84c4-a0510b46b473/scan_3579b26b-1ca3-11ee-997b-a0510b46b473/7a157f8b-1ca3-11ee-997b-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_06fff4e1-1ca0-11ee-84c4-a0510b46b473_SESS_0701c127-1ca0-11ee-84c4-a0510b46b473_TOSC_3579b26b-1ca3-11ee-997b-a0510b46b473_SNAPS','7a157f8b-1ca3-11ee-997b-a0510b46b473.png','7a157f8b-1ca3-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.1.1.9 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-07 10:51:34.854','2023-07-07 08:51:35.507',NULL),('7a38b6c8-15b6-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/142e7037-15b6-11ee-b3b1-00d86184ce3d/session_1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d/occlusion_1ed7780a-15b6-11ee-b3b1-00d86184ce3d/scan_20a8c9f7-15b6-11ee-b3b1-00d86184ce3d/7a38b6c8-15b6-11ee-b3b1-00d86184ce3d.zip','PATIENT_142e7037-15b6-11ee-b3b1-00d86184ce3d_ACT_1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d_SESS_1ed7780a-15b6-11ee-b3b1-00d86184ce3d_TOSC_20a8c9f7-15b6-11ee-b3b1-00d86184ce3d_MODEL','7a38b6c8-15b6-11ee-b3b1-00d86184ce3d.zip','7a38b6c8-15b6-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.25.1.1.1\",\"modelMatrix\":\"0.974615,0.218121,-0.0504849,0,-0.223888,0.949514,-0.219768,0,3.13341e-09,0.225492,0.974245,0,-7.96261,15.1561,-11.8488,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-28 15:19:57.383','2023-06-28 13:19:58.102',NULL),('7a38d09c-15b6-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/142e7037-15b6-11ee-b3b1-00d86184ce3d/session_1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d/occlusion_1ed7780a-15b6-11ee-b3b1-00d86184ce3d/scan_20a8c9f7-15b6-11ee-b3b1-00d86184ce3d/7a38d09c-15b6-11ee-b3b1-00d86184ce3d.png','PATIENT_142e7037-15b6-11ee-b3b1-00d86184ce3d_ACT_1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d_SESS_1ed7780a-15b6-11ee-b3b1-00d86184ce3d_TOSC_20a8c9f7-15b6-11ee-b3b1-00d86184ce3d_SNAPS','7a38d09c-15b6-11ee-b3b1-00d86184ce3d.png','7a38d09c-15b6-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.25.1.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-28 15:19:57.383','2023-06-28 13:19:58.103',NULL),('7af3d4f6-1a62-11ee-9a4f-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_56e1eee3-1a49-11ee-9a4f-a0510b46b473/occlusion_56e449e9-1a49-11ee-9a4f-a0510b46b473/scan_2caf99d1-1a62-11ee-9a4f-a0510b46b473/7af3d4f6-1a62-11ee-9a4f-a0510b46b473.zip','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_56e1eee3-1a49-11ee-9a4f-a0510b46b473_SESS_56e449e9-1a49-11ee-9a4f-a0510b46b473_TOSC_2caf99d1-1a62-11ee-9a4f-a0510b46b473_MODEL','7af3d4f6-1a62-11ee-9a4f-a0510b46b473.zip','7af3d4f6-1a62-11ee-9a4f-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.1.1.7\",\"modelMatrix\":\"-0.09307,0.957093,-0.27443,0,-0.99566,-0.0894649,0.0256525,0,2.37295e-09,0.275627,0.961265,0,-14.0389,-30.2521,-8.0434,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-04 14:01:16.698','2023-07-04 12:01:17.439',NULL),('7af3ee28-1a62-11ee-9a4f-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_56e1eee3-1a49-11ee-9a4f-a0510b46b473/occlusion_56e449e9-1a49-11ee-9a4f-a0510b46b473/scan_2caf99d1-1a62-11ee-9a4f-a0510b46b473/7af3ee28-1a62-11ee-9a4f-a0510b46b473.png','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_56e1eee3-1a49-11ee-9a4f-a0510b46b473_SESS_56e449e9-1a49-11ee-9a4f-a0510b46b473_TOSC_2caf99d1-1a62-11ee-9a4f-a0510b46b473_SNAPS','7af3ee28-1a62-11ee-9a4f-a0510b46b473.png','7af3ee28-1a62-11ee-9a4f-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.1.1.7 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-04 14:01:16.698','2023-07-04 12:01:17.439',NULL),('7c2fb301-deb6-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/cf3f0588-deb2-11ed-9cc3-00d86184ce3d/session_d7750b8d-deb2-11ed-9cc3-00d86184ce3d/occlusion_d7775a50-deb2-11ed-9cc3-00d86184ce3d/scan_64866cf1-deb5-11ed-9cc3-00d86184ce3d/7c2fb301-deb6-11ed-9cc3-00d86184ce3d.zip','PATIENT_cf3f0588-deb2-11ed-9cc3-00d86184ce3d_ACT_d7750b8d-deb2-11ed-9cc3-00d86184ce3d_SESS_d7775a50-deb2-11ed-9cc3-00d86184ce3d_TOSC_64866cf1-deb5-11ed-9cc3-00d86184ce3d_MODEL','7c2fb301-deb6-11ed-9cc3-00d86184ce3d.zip','7c2fb301-deb6-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.6.1.1.6\",\"modelMatrix\":\"0.408084,0.894162,-0.18423,0,-0.912944,0.399689,-0.0823504,0,-7.16465e-10,0.201798,0.979427,0,-31.266,-7.38938,-7.90725,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-19 15:31:26.726','2023-04-19 13:31:27.721',NULL),('7c2fc7c6-deb6-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/cf3f0588-deb2-11ed-9cc3-00d86184ce3d/session_d7750b8d-deb2-11ed-9cc3-00d86184ce3d/occlusion_d7775a50-deb2-11ed-9cc3-00d86184ce3d/scan_64866cf1-deb5-11ed-9cc3-00d86184ce3d/7c2fc7c6-deb6-11ed-9cc3-00d86184ce3d.png','PATIENT_cf3f0588-deb2-11ed-9cc3-00d86184ce3d_ACT_d7750b8d-deb2-11ed-9cc3-00d86184ce3d_SESS_d7775a50-deb2-11ed-9cc3-00d86184ce3d_TOSC_64866cf1-deb5-11ed-9cc3-00d86184ce3d_SNAPS','7c2fc7c6-deb6-11ed-9cc3-00d86184ce3d.png','7c2fc7c6-deb6-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.6.1.1.6 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-19 15:31:26.727','2023-04-19 13:31:27.724',NULL),('7c465d97-deaf-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/eb12a131-deae-11ed-9cc3-00d86184ce3d/session_fdea0616-deae-11ed-9cc3-00d86184ce3d/occlusion_fded0f45-deae-11ed-9cc3-00d86184ce3d/scan_ff8b2038-deae-11ed-9cc3-00d86184ce3d/7c465d97-deaf-11ed-9cc3-00d86184ce3d.zip','PATIENT_eb12a131-deae-11ed-9cc3-00d86184ce3d_ACT_fdea0616-deae-11ed-9cc3-00d86184ce3d_SESS_fded0f45-deae-11ed-9cc3-00d86184ce3d_TOSC_ff8b2038-deae-11ed-9cc3-00d86184ce3d_MODEL','7c465d97-deaf-11ed-9cc3-00d86184ce3d.zip','7c465d97-deaf-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.5.1.1.1\",\"modelMatrix\":\"0.54232,0.804654,-0.241706,0,-0.840172,0.519394,-0.156018,0,4.89376e-10,0.287686,0.957725,0,-25.8951,2.46121,-10.4432,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-19 14:41:20.398','2023-04-19 12:41:21.189',NULL),('7c46742a-deaf-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/eb12a131-deae-11ed-9cc3-00d86184ce3d/session_fdea0616-deae-11ed-9cc3-00d86184ce3d/occlusion_fded0f45-deae-11ed-9cc3-00d86184ce3d/scan_ff8b2038-deae-11ed-9cc3-00d86184ce3d/7c46742a-deaf-11ed-9cc3-00d86184ce3d.png','PATIENT_eb12a131-deae-11ed-9cc3-00d86184ce3d_ACT_fdea0616-deae-11ed-9cc3-00d86184ce3d_SESS_fded0f45-deae-11ed-9cc3-00d86184ce3d_TOSC_ff8b2038-deae-11ed-9cc3-00d86184ce3d_SNAPS','7c46742a-deaf-11ed-9cc3-00d86184ce3d.png','7c46742a-deaf-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.5.1.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-19 14:41:20.398','2023-04-19 12:41:21.198',NULL),('7f14da36-dd08-11ed-8097-00d86184ce3d',11,'/home/scan/.data//2023/11/59af3050-dcfe-11ed-8097-00d86184ce3d/session_61025fcf-dcfe-11ed-8097-00d86184ce3d/occlusion_610548c3-dcfe-11ed-8097-00d86184ce3d/scan_474674d0-dd08-11ed-8097-00d86184ce3d/7f14da36-dd08-11ed-8097-00d86184ce3d.zip','PATIENT_59af3050-dcfe-11ed-8097-00d86184ce3d_ACT_61025fcf-dcfe-11ed-8097-00d86184ce3d_SESS_610548c3-dcfe-11ed-8097-00d86184ce3d_TOSC_474674d0-dd08-11ed-8097-00d86184ce3d_MODEL','7f14da36-dd08-11ed-8097-00d86184ce3d.zip','7f14da36-dd08-11ed-8097-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.1.1.1.13\",\"modelMatrix\":\"0.354777,-0.918088,0.176767,0,0.934951,0.348379,-0.0670762,0,4.11527e-09,0.189066,0.981964,0,15.6369,17.2986,-20.1452,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-04-17 12:13:27.990','2023-04-17 10:13:28.515','2023-04-17 12:13:28.931'),('7f14f38d-dd08-11ed-8097-00d86184ce3d',11,'/home/scan/.data//2023/11/59af3050-dcfe-11ed-8097-00d86184ce3d/session_61025fcf-dcfe-11ed-8097-00d86184ce3d/occlusion_610548c3-dcfe-11ed-8097-00d86184ce3d/scan_474674d0-dd08-11ed-8097-00d86184ce3d/7f14f38d-dd08-11ed-8097-00d86184ce3d.png','PATIENT_59af3050-dcfe-11ed-8097-00d86184ce3d_ACT_61025fcf-dcfe-11ed-8097-00d86184ce3d_SESS_610548c3-dcfe-11ed-8097-00d86184ce3d_TOSC_474674d0-dd08-11ed-8097-00d86184ce3d_SNAPS','7f14f38d-dd08-11ed-8097-00d86184ce3d.png','7f14f38d-dd08-11ed-8097-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.1.1.1.13 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-04-17 12:13:27.991','2023-04-17 10:13:28.516','2023-04-17 12:13:29.043'),('7fc6e2e9-1105-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_0628a8e9-1104-11ee-b636-a0510b46b473/occlusion_062b833f-1104-11ee-b636-a0510b46b473/scan_339f33af-1105-11ee-b636-a0510b46b473/7fc6e2e9-1105-11ee-b636-a0510b46b473.zip','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_0628a8e9-1104-11ee-b636-a0510b46b473_SESS_062b833f-1104-11ee-b636-a0510b46b473_TOSC_339f33af-1105-11ee-b636-a0510b46b473_MODEL','7fc6e2e9-1105-11ee-b636-a0510b46b473.zip','7fc6e2e9-1105-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.20.1.1.3\",\"modelMatrix\":\"0.0630963,0.967029,-0.246727,0,-0.998008,0.0611377,-0.0155986,0,-3.75606e-11,0.247219,0.96896,0,-17.0662,-26.198,-8.29681,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 16:03:01.131','2023-06-22 14:03:01.825',NULL),('7fc6f9bb-1105-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_0628a8e9-1104-11ee-b636-a0510b46b473/occlusion_062b833f-1104-11ee-b636-a0510b46b473/scan_339f33af-1105-11ee-b636-a0510b46b473/7fc6f9bb-1105-11ee-b636-a0510b46b473.png','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_0628a8e9-1104-11ee-b636-a0510b46b473_SESS_062b833f-1104-11ee-b636-a0510b46b473_TOSC_339f33af-1105-11ee-b636-a0510b46b473_SNAPS','7fc6f9bb-1105-11ee-b636-a0510b46b473.png','7fc6f9bb-1105-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.20.1.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 16:03:01.131','2023-06-22 14:03:01.825',NULL),('8006f0eb-1a4c-11ee-9a4f-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_56e1eee3-1a49-11ee-9a4f-a0510b46b473/occlusion_56e449e9-1a49-11ee-9a4f-a0510b46b473/scan_bf6c92d2-1a49-11ee-9a4f-a0510b46b473/8006f0eb-1a4c-11ee-9a4f-a0510b46b473.zip','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_56e1eee3-1a49-11ee-9a4f-a0510b46b473_SESS_56e449e9-1a49-11ee-9a4f-a0510b46b473_TOSC_bf6c92d2-1a49-11ee-9a4f-a0510b46b473_MODEL','8006f0eb-1a4c-11ee-9a4f-a0510b46b473.zip','8006f0eb-1a4c-11ee-9a4f-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.1.1.2\",\"modelMatrix\":\"0.00151233,0.988022,-0.154308,0,-0.999999,0.00149421,-0.000233364,0,4.29687e-12,0.154308,0.988023,0,-11.758,-27.9433,-9.8277,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-04 11:23:56.284','2023-07-04 09:23:56.851',NULL),('80070835-1a4c-11ee-9a4f-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_56e1eee3-1a49-11ee-9a4f-a0510b46b473/occlusion_56e449e9-1a49-11ee-9a4f-a0510b46b473/scan_bf6c92d2-1a49-11ee-9a4f-a0510b46b473/80070835-1a4c-11ee-9a4f-a0510b46b473.png','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_56e1eee3-1a49-11ee-9a4f-a0510b46b473_SESS_56e449e9-1a49-11ee-9a4f-a0510b46b473_TOSC_bf6c92d2-1a49-11ee-9a4f-a0510b46b473_SNAPS','80070835-1a4c-11ee-9a4f-a0510b46b473.png','80070835-1a4c-11ee-9a4f-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.1.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-04 11:23:56.284','2023-07-04 09:23:56.854',NULL),('812f6481-2ac4-11ee-80c8-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_3a881645-2abf-11ee-80c8-a0510b46b473/occlusion_3a8b3537-2abf-11ee-80c8-a0510b46b473/scan_4c414b2c-2ac4-11ee-80c8-a0510b46b473/812f6481-2ac4-11ee-80c8-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_3a881645-2abf-11ee-80c8-a0510b46b473_SESS_3a8b3537-2abf-11ee-80c8-a0510b46b473_TOSC_4c414b2c-2ac4-11ee-80c8-a0510b46b473_MODEL','812f6481-2ac4-11ee-80c8-a0510b46b473.zip','812f6481-2ac4-11ee-80c8-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.7.1.11\",\"modelMatrix\":\"0.761939,0.627679,-0.159584,0,-0.647648,0.738446,-0.187746,0,-4.37683e-09,0.246406,0.969167,0,-28.6507,-2.59836,-9.31534,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-25 10:23:16.438','2023-07-25 08:23:16.942',NULL),('812f791d-2ac4-11ee-80c8-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_3a881645-2abf-11ee-80c8-a0510b46b473/occlusion_3a8b3537-2abf-11ee-80c8-a0510b46b473/scan_4c414b2c-2ac4-11ee-80c8-a0510b46b473/812f791d-2ac4-11ee-80c8-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_3a881645-2abf-11ee-80c8-a0510b46b473_SESS_3a8b3537-2abf-11ee-80c8-a0510b46b473_TOSC_4c414b2c-2ac4-11ee-80c8-a0510b46b473_SNAPS','812f791d-2ac4-11ee-80c8-a0510b46b473.png','812f791d-2ac4-11ee-80c8-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.7.1.11 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-25 10:23:16.439','2023-07-25 08:23:16.943',NULL),('81bcab86-e02b-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_ed85304d-e024-11ed-bb13-00d86184ce3d/occlusion_ed88a64f-e024-11ed-bb13-00d86184ce3d/scan_6d249f21-e02b-11ed-bb13-00d86184ce3d/81bcab86-e02b-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_ed85304d-e024-11ed-bb13-00d86184ce3d_SESS_ed88a64f-e024-11ed-bb13-00d86184ce3d_TOSC_6d249f21-e02b-11ed-bb13-00d86184ce3d_MODEL','81bcab86-e02b-11ed-bb13-00d86184ce3d.zip','81bcab86-e02b-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.1.1.8\",\"modelMatrix\":\"0.702364,0.536342,-0.467998,0,-0.711818,0.529218,-0.461783,0,8.87962e-09,0.657469,0.753481,0,-15.5878,-16.4843,-7.8362,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 12:01:38.319','2023-04-21 10:01:38.584',NULL),('81bcc117-e02b-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_ed85304d-e024-11ed-bb13-00d86184ce3d/occlusion_ed88a64f-e024-11ed-bb13-00d86184ce3d/scan_6d249f21-e02b-11ed-bb13-00d86184ce3d/81bcc117-e02b-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_ed85304d-e024-11ed-bb13-00d86184ce3d_SESS_ed88a64f-e024-11ed-bb13-00d86184ce3d_TOSC_6d249f21-e02b-11ed-bb13-00d86184ce3d_SNAPS','81bcc117-e02b-11ed-bb13-00d86184ce3d.png','81bcc117-e02b-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.1.1.8 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 12:01:38.320','2023-04-21 10:01:38.584',NULL),('83435b5d-2ae6-11ee-95bc-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_b5fe1002-2ae0-11ee-95bc-a0510b46b473/occlusion_b6012772-2ae0-11ee-95bc-a0510b46b473/scan_48497064-2ae6-11ee-95bc-a0510b46b473/83435b5d-2ae6-11ee-95bc-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_b5fe1002-2ae0-11ee-95bc-a0510b46b473_SESS_b6012772-2ae0-11ee-95bc-a0510b46b473_TOSC_48497064-2ae6-11ee-95bc-a0510b46b473_MODEL','83435b5d-2ae6-11ee-95bc-a0510b46b473.zip','83435b5d-2ae6-11ee-95bc-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.8.1.7\",\"modelMatrix\":\"0.465533,0.840251,-0.277953,0,-0.885031,0.441978,-0.146205,0,1.68507e-09,0.31406,0.949403,0,-28.6214,-16.0475,-7.5159,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-25 14:26:42.813','2023-07-25 12:26:43.323',NULL),('83437248-2ae6-11ee-95bc-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_b5fe1002-2ae0-11ee-95bc-a0510b46b473/occlusion_b6012772-2ae0-11ee-95bc-a0510b46b473/scan_48497064-2ae6-11ee-95bc-a0510b46b473/83437248-2ae6-11ee-95bc-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_b5fe1002-2ae0-11ee-95bc-a0510b46b473_SESS_b6012772-2ae0-11ee-95bc-a0510b46b473_TOSC_48497064-2ae6-11ee-95bc-a0510b46b473_SNAPS','83437248-2ae6-11ee-95bc-a0510b46b473.png','83437248-2ae6-11ee-95bc-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.8.1.7 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-25 14:26:42.814','2023-07-25 12:26:43.324',NULL),('843ca287-26f7-11ee-aa9d-a0510b46b473',11,'/home/scan/.data//2023/11/c69c4cec-26f5-11ee-aa9d-a0510b46b473/session_cf31a6d6-26f5-11ee-aa9d-a0510b46b473/occlusion_cf34c227-26f5-11ee-aa9d-a0510b46b473/scan_349dc4a0-26f7-11ee-aa9d-a0510b46b473/843ca287-26f7-11ee-aa9d-a0510b46b473.zip','PATIENT_c69c4cec-26f5-11ee-aa9d-a0510b46b473_ACT_cf31a6d6-26f5-11ee-aa9d-a0510b46b473_SESS_cf34c227-26f5-11ee-aa9d-a0510b46b473_TOSC_349dc4a0-26f7-11ee-aa9d-a0510b46b473_MODEL','843ca287-26f7-11ee-aa9d-a0510b46b473.zip','843ca287-26f7-11ee-aa9d-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.35.1.1.4\",\"modelMatrix\":\"0.396735,0.910954,-0.112982,0,-0.917933,0.393719,-0.0488314,0,7.8073e-10,0.123083,0.992396,0,-29.6438,-17.3158,-8.51977,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-20 14:18:21.240','2023-07-20 12:18:21.913',NULL),('843cb7a2-26f7-11ee-aa9d-a0510b46b473',11,'/home/scan/.data//2023/11/c69c4cec-26f5-11ee-aa9d-a0510b46b473/session_cf31a6d6-26f5-11ee-aa9d-a0510b46b473/occlusion_cf34c227-26f5-11ee-aa9d-a0510b46b473/scan_349dc4a0-26f7-11ee-aa9d-a0510b46b473/843cb7a2-26f7-11ee-aa9d-a0510b46b473.png','PATIENT_c69c4cec-26f5-11ee-aa9d-a0510b46b473_ACT_cf31a6d6-26f5-11ee-aa9d-a0510b46b473_SESS_cf34c227-26f5-11ee-aa9d-a0510b46b473_TOSC_349dc4a0-26f7-11ee-aa9d-a0510b46b473_SNAPS','843cb7a2-26f7-11ee-aa9d-a0510b46b473.png','843cb7a2-26f7-11ee-aa9d-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.35.1.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-20 14:18:21.241','2023-07-20 12:18:21.921',NULL),('847d6cd9-2630-11ee-81dd-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_62519c59-261f-11ee-8042-a0510b46b473/occlusion_6253caa6-261f-11ee-8042-a0510b46b473/scan_42e42822-2630-11ee-81dd-a0510b46b473/847d6cd9-2630-11ee-81dd-a0510b46b473.zip','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_62519c59-261f-11ee-8042-a0510b46b473_SESS_6253caa6-261f-11ee-8042-a0510b46b473_BOSC_42e42822-2630-11ee-81dd-a0510b46b473_MODEL','847d6cd9-2630-11ee-81dd-a0510b46b473.zip','847d6cd9-2630-11ee-81dd-a0510b46b473','{\"displayTitle\":\"Mandibule 1.34.1.1.1\",\"modelMatrix\":\"-0.117156,0.982145,-0.147196,0,-0.993114,-0.115862,0.0173644,0,8.21615e-10,0.148216,0.988955,0,-16.3345,-28.4441,-9.38444,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-19 14:33:51.816','2023-07-19 12:33:52.426',NULL),('847d8435-2630-11ee-81dd-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_62519c59-261f-11ee-8042-a0510b46b473/occlusion_6253caa6-261f-11ee-8042-a0510b46b473/scan_42e42822-2630-11ee-81dd-a0510b46b473/847d8435-2630-11ee-81dd-a0510b46b473.png','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_62519c59-261f-11ee-8042-a0510b46b473_SESS_6253caa6-261f-11ee-8042-a0510b46b473_BOSC_42e42822-2630-11ee-81dd-a0510b46b473_SNAPS','847d8435-2630-11ee-81dd-a0510b46b473.png','847d8435-2630-11ee-81dd-a0510b46b473','{\"displayTitle\":\"Mandibule 1.34.1.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-19 14:33:51.816','2023-07-19 12:33:52.427',NULL),('84bc1da1-e03d-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_6f09f9a8-e03a-11ed-bb13-00d86184ce3d/occlusion_6f0c3cda-e03a-11ed-bb13-00d86184ce3d/scan_67bd6aa9-e03d-11ed-bb13-00d86184ce3d/84bc1da1-e03d-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_6f09f9a8-e03a-11ed-bb13-00d86184ce3d_SESS_6f0c3cda-e03a-11ed-bb13-00d86184ce3d_TOSC_67bd6aa9-e03d-11ed-bb13-00d86184ce3d_MODEL','84bc1da1-e03d-11ed-bb13-00d86184ce3d.zip','84bc1da1-e03d-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.3.1.13\",\"modelMatrix\":\"0.79379,0.517561,-0.319418,0,-0.608192,0.675502,-0.416892,0,2.85336e-08,0.525192,0.850984,0,-17.9684,-12.4197,-5.41349,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 14:10:34.290','2023-04-21 12:10:34.602',NULL),('84bc2e04-e03d-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_6f09f9a8-e03a-11ed-bb13-00d86184ce3d/occlusion_6f0c3cda-e03a-11ed-bb13-00d86184ce3d/scan_67bd6aa9-e03d-11ed-bb13-00d86184ce3d/84bc2e04-e03d-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_6f09f9a8-e03a-11ed-bb13-00d86184ce3d_SESS_6f0c3cda-e03a-11ed-bb13-00d86184ce3d_TOSC_67bd6aa9-e03d-11ed-bb13-00d86184ce3d_SNAPS','84bc2e04-e03d-11ed-bb13-00d86184ce3d.png','84bc2e04-e03d-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.3.1.13 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 14:10:34.290','2023-04-21 12:10:34.602',NULL),('850d8e69-1fe9-11ee-b7d5-a0510b46b473',11,'/home/scan/.data//2023/11/6a143ccb-1fe8-11ee-b7d5-a0510b46b473/session_7758b704-1fe8-11ee-b7d5-a0510b46b473/occlusion_775bad6c-1fe8-11ee-b7d5-a0510b46b473/scan_50e7bd0c-1fe9-11ee-b7d5-a0510b46b473/850d8e69-1fe9-11ee-b7d5-a0510b46b473.zip','PATIENT_6a143ccb-1fe8-11ee-b7d5-a0510b46b473_ACT_7758b704-1fe8-11ee-b7d5-a0510b46b473_SESS_775bad6c-1fe8-11ee-b7d5-a0510b46b473_BOSC_50e7bd0c-1fe9-11ee-b7d5-a0510b46b473_MODEL','850d8e69-1fe9-11ee-b7d5-a0510b46b473.zip','850d8e69-1fe9-11ee-b7d5-a0510b46b473','{\"displayTitle\":\"Mandibule 1.32.1.1.1\",\"modelMatrix\":\"0.869496,0.412922,-0.271057,0,-0.49394,0.726878,-0.477149,0,6.26137e-10,0.548765,0.835977,0,-29.2999,1.0444,-9.10112,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-11 14:50:31.516','2023-07-11 12:50:33.559',NULL),('850db831-1fe9-11ee-b7d5-a0510b46b473',11,'/home/scan/.data//2023/11/6a143ccb-1fe8-11ee-b7d5-a0510b46b473/session_7758b704-1fe8-11ee-b7d5-a0510b46b473/occlusion_775bad6c-1fe8-11ee-b7d5-a0510b46b473/scan_50e7bd0c-1fe9-11ee-b7d5-a0510b46b473/850db831-1fe9-11ee-b7d5-a0510b46b473.png','PATIENT_6a143ccb-1fe8-11ee-b7d5-a0510b46b473_ACT_7758b704-1fe8-11ee-b7d5-a0510b46b473_SESS_775bad6c-1fe8-11ee-b7d5-a0510b46b473_BOSC_50e7bd0c-1fe9-11ee-b7d5-a0510b46b473_SNAPS','850db831-1fe9-11ee-b7d5-a0510b46b473.png','850db831-1fe9-11ee-b7d5-a0510b46b473','{\"displayTitle\":\"Mandibule 1.32.1.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-11 14:50:31.517','2023-07-11 12:50:33.560',NULL),('858f73d4-de98-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/35e16a68-de95-11ed-9cc3-00d86184ce3d/session_450c29ef-de95-11ed-9cc3-00d86184ce3d/occlusion_450efda8-de95-11ed-9cc3-00d86184ce3d/scan_36e57b7e-de98-11ed-9cc3-00d86184ce3d/858f73d4-de98-11ed-9cc3-00d86184ce3d.zip','PATIENT_35e16a68-de95-11ed-9cc3-00d86184ce3d_ACT_450c29ef-de95-11ed-9cc3-00d86184ce3d_SESS_450efda8-de95-11ed-9cc3-00d86184ce3d_TOSC_36e57b7e-de98-11ed-9cc3-00d86184ce3d_MODEL','858f73d4-de98-11ed-9cc3-00d86184ce3d.zip','858f73d4-de98-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.4.1.1.4\",\"modelMatrix\":\"-0.0234184,0.978587,-0.204496,0,-0.999726,-0.0229233,0.00479029,0,5.46212e-11,0.204552,0.978856,0,-20.8767,-19.1993,-7.059,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-19 11:56:57.552','2023-04-19 09:56:58.557',NULL),('858f89dd-de98-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/35e16a68-de95-11ed-9cc3-00d86184ce3d/session_450c29ef-de95-11ed-9cc3-00d86184ce3d/occlusion_450efda8-de95-11ed-9cc3-00d86184ce3d/scan_36e57b7e-de98-11ed-9cc3-00d86184ce3d/858f89dd-de98-11ed-9cc3-00d86184ce3d.png','PATIENT_35e16a68-de95-11ed-9cc3-00d86184ce3d_ACT_450c29ef-de95-11ed-9cc3-00d86184ce3d_SESS_450efda8-de95-11ed-9cc3-00d86184ce3d_TOSC_36e57b7e-de98-11ed-9cc3-00d86184ce3d_SNAPS','858f89dd-de98-11ed-9cc3-00d86184ce3d.png','858f89dd-de98-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.4.1.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-19 11:56:57.552','2023-04-19 09:56:58.557',NULL),('85fbaa7e-debb-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/cf3f0588-deb2-11ed-9cc3-00d86184ce3d/session_c2f3ac91-deba-11ed-9cc3-00d86184ce3d/occlusion_c2f6aec6-deba-11ed-9cc3-00d86184ce3d/scan_3d6b4d06-debb-11ed-9cc3-00d86184ce3d/85fbaa7e-debb-11ed-9cc3-00d86184ce3d.zip','PATIENT_cf3f0588-deb2-11ed-9cc3-00d86184ce3d_ACT_c2f3ac91-deba-11ed-9cc3-00d86184ce3d_SESS_c2f6aec6-deba-11ed-9cc3-00d86184ce3d_TOSC_3d6b4d06-debb-11ed-9cc3-00d86184ce3d_MODEL','85fbaa7e-debb-11ed-9cc3-00d86184ce3d.zip','85fbaa7e-debb-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.6.2.1.2\",\"modelMatrix\":\"0.455163,0.82008,-0.346837,0,-0.890408,0.419212,-0.177298,0,-8.96732e-09,0.389526,0.921016,0,-23.8296,-13.8391,-8.96301,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-19 16:07:30.646','2023-04-19 14:07:31.434',NULL),('85fbbfaa-debb-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/cf3f0588-deb2-11ed-9cc3-00d86184ce3d/session_c2f3ac91-deba-11ed-9cc3-00d86184ce3d/occlusion_c2f6aec6-deba-11ed-9cc3-00d86184ce3d/scan_3d6b4d06-debb-11ed-9cc3-00d86184ce3d/85fbbfaa-debb-11ed-9cc3-00d86184ce3d.png','PATIENT_cf3f0588-deb2-11ed-9cc3-00d86184ce3d_ACT_c2f3ac91-deba-11ed-9cc3-00d86184ce3d_SESS_c2f6aec6-deba-11ed-9cc3-00d86184ce3d_TOSC_3d6b4d06-debb-11ed-9cc3-00d86184ce3d_SNAPS','85fbbfaa-debb-11ed-9cc3-00d86184ce3d.png','85fbbfaa-debb-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.6.2.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-19 16:07:30.647','2023-04-19 14:07:31.442',NULL),('8630d8c4-e03a-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_6f09f9a8-e03a-11ed-bb13-00d86184ce3d/occlusion_6f0c3cda-e03a-11ed-bb13-00d86184ce3d/scan_70de37ee-e03a-11ed-bb13-00d86184ce3d/8630d8c4-e03a-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_6f09f9a8-e03a-11ed-bb13-00d86184ce3d_SESS_6f0c3cda-e03a-11ed-bb13-00d86184ce3d_TOSC_70de37ee-e03a-11ed-bb13-00d86184ce3d_MODEL','8630d8c4-e03a-11ed-bb13-00d86184ce3d.zip','8630d8c4-e03a-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.3.1.1\",\"modelMatrix\":\"0.69234,0.292745,-0.659519,0,-0.721572,0.280886,-0.632801,0,-3.94428e-09,0.914004,0.405705,0,-14.3139,-20.2496,-2.68196,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,'2023-04-21 13:49:17.756','2023-04-21 13:49:08.242','2023-04-21 11:49:17.760',NULL),('8630f1b9-e03a-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_6f09f9a8-e03a-11ed-bb13-00d86184ce3d/occlusion_6f0c3cda-e03a-11ed-bb13-00d86184ce3d/scan_70de37ee-e03a-11ed-bb13-00d86184ce3d/8630f1b9-e03a-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_6f09f9a8-e03a-11ed-bb13-00d86184ce3d_SESS_6f0c3cda-e03a-11ed-bb13-00d86184ce3d_TOSC_70de37ee-e03a-11ed-bb13-00d86184ce3d_SNAPS','8630f1b9-e03a-11ed-bb13-00d86184ce3d.png','8630f1b9-e03a-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.3.1.1 Snapshot\"}','PNG',0,'CREATED',0,'2023-04-21 13:49:17.756','2023-04-21 13:49:08.243','2023-04-21 11:49:17.764',NULL),('868821fc-26fa-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/c69c4cec-26f5-11ee-aa9d-a0510b46b473/session_4de7c46e-26fa-11ee-a98e-a0510b46b473/occlusion_4deac8dd-26fa-11ee-a98e-a0510b46b473/scan_4f5385fc-26fa-11ee-a98e-a0510b46b473/868821fc-26fa-11ee-a98e-a0510b46b473.zip','PATIENT_c69c4cec-26f5-11ee-aa9d-a0510b46b473_ACT_4de7c46e-26fa-11ee-a98e-a0510b46b473_SESS_4deac8dd-26fa-11ee-a98e-a0510b46b473_TOSC_4f5385fc-26fa-11ee-a98e-a0510b46b473_MODEL','868821fc-26fa-11ee-a98e-a0510b46b473.zip','868821fc-26fa-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.35.2.1.1\",\"modelMatrix\":\"-0.285328,-0.949723,0.128894,0,0.95843,-0.282736,0.0383723,0,2.09821e-09,0.134485,0.990916,0,11.394,4.25032,-11.9657,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-20 14:39:53.581','2023-07-20 12:39:54.028',NULL),('86883ba1-26fa-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/c69c4cec-26f5-11ee-aa9d-a0510b46b473/session_4de7c46e-26fa-11ee-a98e-a0510b46b473/occlusion_4deac8dd-26fa-11ee-a98e-a0510b46b473/scan_4f5385fc-26fa-11ee-a98e-a0510b46b473/86883ba1-26fa-11ee-a98e-a0510b46b473.png','PATIENT_c69c4cec-26f5-11ee-aa9d-a0510b46b473_ACT_4de7c46e-26fa-11ee-a98e-a0510b46b473_SESS_4deac8dd-26fa-11ee-a98e-a0510b46b473_TOSC_4f5385fc-26fa-11ee-a98e-a0510b46b473_SNAPS','86883ba1-26fa-11ee-a98e-a0510b46b473.png','86883ba1-26fa-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.35.2.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-20 14:39:53.581','2023-07-20 12:39:54.029',NULL),('86a36f2b-10f6-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/e0d449f3-dde9-11ed-aa56-00d86184ce3d/session_858fcc60-de94-11ed-9cc3-00d86184ce3d/occlusion_85925fd9-de94-11ed-9cc3-00d86184ce3d/scan_6ea74874-10f6-11ee-b636-a0510b46b473/86a36f2b-10f6-11ee-b636-a0510b46b473.zip','PATIENT_e0d449f3-dde9-11ed-aa56-00d86184ce3d_ACT_858fcc60-de94-11ed-9cc3-00d86184ce3d_SESS_85925fd9-de94-11ed-9cc3-00d86184ce3d_TOSC_6ea74874-10f6-11ee-b636-a0510b46b473_MODEL','86a36f2b-10f6-11ee-b636-a0510b46b473.zip','86a36f2b-10f6-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.2.1.1.9\",\"modelMatrix\":\"0.541924,0.819648,-0.185733,0,-0.840428,0.528524,-0.119764,0,3.90139e-09,0.220998,0.975274,0,-1.69943,-10.9724,-9.81301,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 14:15:50.192','2023-06-22 12:15:50.579',NULL),('86a38751-10f6-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/e0d449f3-dde9-11ed-aa56-00d86184ce3d/session_858fcc60-de94-11ed-9cc3-00d86184ce3d/occlusion_85925fd9-de94-11ed-9cc3-00d86184ce3d/scan_6ea74874-10f6-11ee-b636-a0510b46b473/86a38751-10f6-11ee-b636-a0510b46b473.png','PATIENT_e0d449f3-dde9-11ed-aa56-00d86184ce3d_ACT_858fcc60-de94-11ed-9cc3-00d86184ce3d_SESS_85925fd9-de94-11ed-9cc3-00d86184ce3d_TOSC_6ea74874-10f6-11ee-b636-a0510b46b473_SNAPS','86a38751-10f6-11ee-b636-a0510b46b473.png','86a38751-10f6-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.2.1.1.9 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 14:15:50.192','2023-06-22 12:15:50.580',NULL),('876a6be6-2a3e-11ee-9e90-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_b144ba33-2a36-11ee-9e90-a0510b46b473/occlusion_b147bba1-2a36-11ee-9e90-a0510b46b473/scan_4ebf8a4b-2a3e-11ee-9e90-a0510b46b473/876a6be6-2a3e-11ee-9e90-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_b144ba33-2a36-11ee-9e90-a0510b46b473_SESS_b147bba1-2a36-11ee-9e90-a0510b46b473_TOSC_4ebf8a4b-2a3e-11ee-9e90-a0510b46b473_MODEL','876a6be6-2a3e-11ee-9e90-a0510b46b473.zip','876a6be6-2a3e-11ee-9e90-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.6.1.7\",\"modelMatrix\":\"0.85552,0.461914,-0.233925,0,-0.51777,0.763228,-0.386519,0,4.3288e-09,0.451794,0.892122,0,-30.5072,1.94451,-8.31916,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,'2023-07-24 18:24:59.052','2023-07-24 18:24:14.330','2023-07-24 16:24:59.056',NULL),('876a8515-2a3e-11ee-9e90-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_b144ba33-2a36-11ee-9e90-a0510b46b473/occlusion_b147bba1-2a36-11ee-9e90-a0510b46b473/scan_4ebf8a4b-2a3e-11ee-9e90-a0510b46b473/876a8515-2a3e-11ee-9e90-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_b144ba33-2a36-11ee-9e90-a0510b46b473_SESS_b147bba1-2a36-11ee-9e90-a0510b46b473_TOSC_4ebf8a4b-2a3e-11ee-9e90-a0510b46b473_SNAPS','876a8515-2a3e-11ee-9e90-a0510b46b473.png','876a8515-2a3e-11ee-9e90-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.6.1.7 Snapshot\"}','PNG',0,'CREATED',0,'2023-07-24 18:24:59.052','2023-07-24 18:24:14.330','2023-07-24 16:24:59.060',NULL),('87f623e0-2ae9-11ee-97fa-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_8b758c52-2ae7-11ee-97fa-a0510b46b473/occlusion_8b789858-2ae7-11ee-97fa-a0510b46b473/scan_4854d445-2ae9-11ee-97fa-a0510b46b473/87f623e0-2ae9-11ee-97fa-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_8b758c52-2ae7-11ee-97fa-a0510b46b473_SESS_8b789858-2ae7-11ee-97fa-a0510b46b473_TOSC_4854d445-2ae9-11ee-97fa-a0510b46b473_MODEL','87f623e0-2ae9-11ee-97fa-a0510b46b473.zip','87f623e0-2ae9-11ee-97fa-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.9.1.3\",\"modelMatrix\":\"0.739132,0.622357,-0.257596,0,-0.673561,0.682944,-0.282673,0,1.23369e-09,0.382439,0.923981,0,-31.7535,-8.31738,-8.17016,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-25 14:48:19.186','2023-07-25 12:48:19.759',NULL),('87f63946-2ae9-11ee-97fa-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_8b758c52-2ae7-11ee-97fa-a0510b46b473/occlusion_8b789858-2ae7-11ee-97fa-a0510b46b473/scan_4854d445-2ae9-11ee-97fa-a0510b46b473/87f63946-2ae9-11ee-97fa-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_8b758c52-2ae7-11ee-97fa-a0510b46b473_SESS_8b789858-2ae7-11ee-97fa-a0510b46b473_TOSC_4854d445-2ae9-11ee-97fa-a0510b46b473_SNAPS','87f63946-2ae9-11ee-97fa-a0510b46b473.png','87f63946-2ae9-11ee-97fa-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.9.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-25 14:48:19.187','2023-07-25 12:48:19.761',NULL),('88f9f6b0-262b-11ee-8042-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_62519c59-261f-11ee-8042-a0510b46b473/occlusion_6253caa6-261f-11ee-8042-a0510b46b473/scan_237ac86e-262b-11ee-8042-a0510b46b473/88f9f6b0-262b-11ee-8042-a0510b46b473.zip','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_62519c59-261f-11ee-8042-a0510b46b473_SESS_6253caa6-261f-11ee-8042-a0510b46b473_TOSC_237ac86e-262b-11ee-8042-a0510b46b473_MODEL','88f9f6b0-262b-11ee-8042-a0510b46b473.zip','88f9f6b0-262b-11ee-8042-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.1.1.7\",\"modelMatrix\":\"0.04583,0.980958,-0.188737,0,-0.998949,0.0450046,-0.00865891,0,6.0236e-10,0.188935,0.98199,0,-17.3865,-20.9644,-12.7681,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-19 13:58:11.859','2023-07-19 11:58:12.712',NULL),('88fa0e01-262b-11ee-8042-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_62519c59-261f-11ee-8042-a0510b46b473/occlusion_6253caa6-261f-11ee-8042-a0510b46b473/scan_237ac86e-262b-11ee-8042-a0510b46b473/88fa0e01-262b-11ee-8042-a0510b46b473.png','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_62519c59-261f-11ee-8042-a0510b46b473_SESS_6253caa6-261f-11ee-8042-a0510b46b473_TOSC_237ac86e-262b-11ee-8042-a0510b46b473_SNAPS','88fa0e01-262b-11ee-8042-a0510b46b473.png','88fa0e01-262b-11ee-8042-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.1.1.7 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-19 13:58:11.860','2023-07-19 11:58:12.716',NULL),('89315714-10fc-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/ed94fe78-10f4-11ee-b636-a0510b46b473/session_8cbad919-10fb-11ee-b636-a0510b46b473/occlusion_8cbde682-10fb-11ee-b636-a0510b46b473/scan_51038fc0-10fc-11ee-b636-a0510b46b473/89315714-10fc-11ee-b636-a0510b46b473.zip','PATIENT_ed94fe78-10f4-11ee-b636-a0510b46b473_ACT_8cbad919-10fb-11ee-b636-a0510b46b473_SESS_8cbde682-10fb-11ee-b636-a0510b46b473_TOSC_51038fc0-10fc-11ee-b636-a0510b46b473_MODEL','89315714-10fc-11ee-b636-a0510b46b473.zip','89315714-10fc-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.19.2.1.4\",\"modelMatrix\":\"0.63551,0.705505,-0.313671,0,-0.772093,0.580702,-0.258183,0,3.75498e-09,0.406261,0.913757,0,-31.136,0.174388,-8.8874,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 14:58:51.458','2023-06-22 12:58:51.993',NULL),('89316e0e-10fc-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/ed94fe78-10f4-11ee-b636-a0510b46b473/session_8cbad919-10fb-11ee-b636-a0510b46b473/occlusion_8cbde682-10fb-11ee-b636-a0510b46b473/scan_51038fc0-10fc-11ee-b636-a0510b46b473/89316e0e-10fc-11ee-b636-a0510b46b473.png','PATIENT_ed94fe78-10f4-11ee-b636-a0510b46b473_ACT_8cbad919-10fb-11ee-b636-a0510b46b473_SESS_8cbde682-10fb-11ee-b636-a0510b46b473_TOSC_51038fc0-10fc-11ee-b636-a0510b46b473_SNAPS','89316e0e-10fc-11ee-b636-a0510b46b473.png','89316e0e-10fc-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.19.2.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 14:58:51.458','2023-06-22 12:58:51.994',NULL),('8a3e5aba-1a79-11ee-8124-a0510b46b473',11,'/home/scan/.data//2023/11/61e16a70-1a76-11ee-8124-a0510b46b473/session_c8578c2f-1a77-11ee-8124-a0510b46b473/occlusion_c85af2e9-1a77-11ee-8124-a0510b46b473/scan_1babeeef-1a79-11ee-8124-a0510b46b473/8a3e5aba-1a79-11ee-8124-a0510b46b473.zip','PATIENT_61e16a70-1a76-11ee-8124-a0510b46b473_ACT_c8578c2f-1a77-11ee-8124-a0510b46b473_SESS_c85af2e9-1a77-11ee-8124-a0510b46b473_TOSC_1babeeef-1a79-11ee-8124-a0510b46b473_MODEL','8a3e5aba-1a79-11ee-8124-a0510b46b473.zip','8a3e5aba-1a79-11ee-8124-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.27.2.1.4\",\"modelMatrix\":\"0.652458,0.749401,-0.11268,0,-0.757825,0.645205,-0.0970136,0,6.50007e-09,0.148689,0.988884,0,-28.9579,-2.31223,-10.1157,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-04 16:46:20.777','2023-07-04 14:46:21.539',NULL),('8a3e7321-1a79-11ee-8124-a0510b46b473',11,'/home/scan/.data//2023/11/61e16a70-1a76-11ee-8124-a0510b46b473/session_c8578c2f-1a77-11ee-8124-a0510b46b473/occlusion_c85af2e9-1a77-11ee-8124-a0510b46b473/scan_1babeeef-1a79-11ee-8124-a0510b46b473/8a3e7321-1a79-11ee-8124-a0510b46b473.png','PATIENT_61e16a70-1a76-11ee-8124-a0510b46b473_ACT_c8578c2f-1a77-11ee-8124-a0510b46b473_SESS_c85af2e9-1a77-11ee-8124-a0510b46b473_TOSC_1babeeef-1a79-11ee-8124-a0510b46b473_SNAPS','8a3e7321-1a79-11ee-8124-a0510b46b473.png','8a3e7321-1a79-11ee-8124-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.27.2.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-04 16:46:20.777','2023-07-04 14:46:21.539',NULL),('8b5a8b12-10d6-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/bd51960a-10d5-11ee-b636-a0510b46b473/session_c5e67f1c-10d5-11ee-b636-a0510b46b473/occlusion_c5e95a7b-10d5-11ee-b636-a0510b46b473/scan_3ae69f75-10d6-11ee-b636-a0510b46b473/8b5a8b12-10d6-11ee-b636-a0510b46b473.zip','PATIENT_bd51960a-10d5-11ee-b636-a0510b46b473_ACT_c5e67f1c-10d5-11ee-b636-a0510b46b473_SESS_c5e95a7b-10d5-11ee-b636-a0510b46b473_TOSC_3ae69f75-10d6-11ee-b636-a0510b46b473_MODEL','8b5a8b12-10d6-11ee-b636-a0510b46b473.zip','8b5a8b12-10d6-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.17.1.1.2\",\"modelMatrix\":\"0.543345,0.811761,-0.214056,0,-0.83951,0.525386,-0.138541,0,1.98864e-09,0.254977,0.966947,0,-23.7571,-19.4687,-8.10554,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 10:26:54.207','2023-06-22 08:26:55.021',NULL),('8b5bca42-10d6-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/bd51960a-10d5-11ee-b636-a0510b46b473/session_c5e67f1c-10d5-11ee-b636-a0510b46b473/occlusion_c5e95a7b-10d5-11ee-b636-a0510b46b473/scan_3ae69f75-10d6-11ee-b636-a0510b46b473/8b5bca42-10d6-11ee-b636-a0510b46b473.png','PATIENT_bd51960a-10d5-11ee-b636-a0510b46b473_ACT_c5e67f1c-10d5-11ee-b636-a0510b46b473_SESS_c5e95a7b-10d5-11ee-b636-a0510b46b473_TOSC_3ae69f75-10d6-11ee-b636-a0510b46b473_SNAPS','8b5bca42-10d6-11ee-b636-a0510b46b473.png','8b5bca42-10d6-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.17.1.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 10:26:54.215','2023-06-22 08:26:55.030',NULL),('8c27bf64-1bdd-11ee-9086-a0510b46b473',11,'/home/scan/.data//2023/11/61e16a70-1a76-11ee-8124-a0510b46b473/session_d30b0955-1bdb-11ee-9086-a0510b46b473/occlusion_d30df7f0-1bdb-11ee-9086-a0510b46b473/scan_3b9ca1ce-1bdd-11ee-9086-a0510b46b473/8c27bf64-1bdd-11ee-9086-a0510b46b473.zip','PATIENT_61e16a70-1a76-11ee-8124-a0510b46b473_ACT_d30b0955-1bdb-11ee-9086-a0510b46b473_SESS_d30df7f0-1bdb-11ee-9086-a0510b46b473_TOSC_3b9ca1ce-1bdd-11ee-9086-a0510b46b473_MODEL','8c27bf64-1bdd-11ee-9086-a0510b46b473.zip','8c27bf64-1bdd-11ee-9086-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.27.4.1.6\",\"modelMatrix\":\"0.896969,0.3938,-0.200918,0,-0.442093,0.798986,-0.407645,0,-1.05497e-08,0.45447,0.890762,0,-21.606,11.5532,-11.0187,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 11:14:44.820','2023-07-06 09:14:45.353',NULL),('8c27d668-1bdd-11ee-9086-a0510b46b473',11,'/home/scan/.data//2023/11/61e16a70-1a76-11ee-8124-a0510b46b473/session_d30b0955-1bdb-11ee-9086-a0510b46b473/occlusion_d30df7f0-1bdb-11ee-9086-a0510b46b473/scan_3b9ca1ce-1bdd-11ee-9086-a0510b46b473/8c27d668-1bdd-11ee-9086-a0510b46b473.png','PATIENT_61e16a70-1a76-11ee-8124-a0510b46b473_ACT_d30b0955-1bdb-11ee-9086-a0510b46b473_SESS_d30df7f0-1bdb-11ee-9086-a0510b46b473_TOSC_3b9ca1ce-1bdd-11ee-9086-a0510b46b473_SNAPS','8c27d668-1bdd-11ee-9086-a0510b46b473.png','8c27d668-1bdd-11ee-9086-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.27.4.1.6 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 11:14:44.820','2023-07-06 09:14:45.362',NULL),('8cd4d6b7-26e6-11ee-aa9d-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_d5ef2d6b-26e3-11ee-a836-a0510b46b473/occlusion_d5f241c9-26e3-11ee-a836-a0510b46b473/scan_3693c57b-26e6-11ee-aa9d-a0510b46b473/8cd4d6b7-26e6-11ee-aa9d-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_d5ef2d6b-26e3-11ee-a836-a0510b46b473_SESS_d5f241c9-26e3-11ee-a836-a0510b46b473_BOSC_3693c57b-26e6-11ee-aa9d-a0510b46b473_MODEL','8cd4d6b7-26e6-11ee-aa9d-a0510b46b473.zip','8cd4d6b7-26e6-11ee-aa9d-a0510b46b473','{\"displayTitle\":\"Mandibule 1.30.5.1.1\",\"modelMatrix\":\"-0.16897,0.981225,-0.0929905,0,-0.985621,-0.168216,0.0159418,0,-1.58295e-09,0.0943471,0.995539,0,-14.7732,-29.3119,-10.7392,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-20 12:16:54.215','2023-07-20 10:16:54.952',NULL),('8cd4fdf8-26e6-11ee-aa9d-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_d5ef2d6b-26e3-11ee-a836-a0510b46b473/occlusion_d5f241c9-26e3-11ee-a836-a0510b46b473/scan_3693c57b-26e6-11ee-aa9d-a0510b46b473/8cd4fdf8-26e6-11ee-aa9d-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_d5ef2d6b-26e3-11ee-a836-a0510b46b473_SESS_d5f241c9-26e3-11ee-a836-a0510b46b473_BOSC_3693c57b-26e6-11ee-aa9d-a0510b46b473_SNAPS','8cd4fdf8-26e6-11ee-aa9d-a0510b46b473.png','8cd4fdf8-26e6-11ee-aa9d-a0510b46b473','{\"displayTitle\":\"Mandibule 1.30.5.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-20 12:16:54.216','2023-07-20 10:16:54.953',NULL),('8e88f980-262d-11ee-8042-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_62519c59-261f-11ee-8042-a0510b46b473/occlusion_6253caa6-261f-11ee-8042-a0510b46b473/scan_34372189-262d-11ee-8042-a0510b46b473/8e88f980-262d-11ee-8042-a0510b46b473.zip','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_62519c59-261f-11ee-8042-a0510b46b473_SESS_6253caa6-261f-11ee-8042-a0510b46b473_TOSC_34372189-262d-11ee-8042-a0510b46b473_MODEL','8e88f980-262d-11ee-8042-a0510b46b473.zip','8e88f980-262d-11ee-8042-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.1.1.11\",\"modelMatrix\":\"-0.0123065,0.974303,-0.224907,0,-0.999924,-0.0119911,0.00276802,0,3.27037e-11,0.224924,0.974376,0,-16.5295,-30.7365,-8.51657,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-19 14:12:40.179','2023-07-19 12:12:40.959',NULL),('8e890c9b-262d-11ee-8042-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_62519c59-261f-11ee-8042-a0510b46b473/occlusion_6253caa6-261f-11ee-8042-a0510b46b473/scan_34372189-262d-11ee-8042-a0510b46b473/8e890c9b-262d-11ee-8042-a0510b46b473.png','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_62519c59-261f-11ee-8042-a0510b46b473_SESS_6253caa6-261f-11ee-8042-a0510b46b473_TOSC_34372189-262d-11ee-8042-a0510b46b473_SNAPS','8e890c9b-262d-11ee-8042-a0510b46b473.png','8e890c9b-262d-11ee-8042-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.1.1.11 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-19 14:12:40.179','2023-07-19 12:12:40.960',NULL),('8e92fc1a-1cad-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/4375c5f1-1cad-11ee-997b-a0510b46b473/session_4a5f2876-1cad-11ee-997b-a0510b46b473/occlusion_4a624109-1cad-11ee-997b-a0510b46b473/scan_4b836789-1cad-11ee-997b-a0510b46b473/8e92fc1a-1cad-11ee-997b-a0510b46b473.zip','PATIENT_4375c5f1-1cad-11ee-997b-a0510b46b473_ACT_4a5f2876-1cad-11ee-997b-a0510b46b473_SESS_4a624109-1cad-11ee-997b-a0510b46b473_TOSC_4b836789-1cad-11ee-997b-a0510b46b473_MODEL','8e92fc1a-1cad-11ee-997b-a0510b46b473.zip','8e92fc1a-1cad-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.31.1.1.1\",\"modelMatrix\":\"0.789989,0.60453,-0.102283,0,-0.613121,0.778918,-0.131789,0,-2.26406e-09,0.166823,0.985987,0,-32.1997,-5.11064,-12.0245,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-07 12:03:44.198','2023-07-07 10:03:44.767',NULL),('8e93136a-1cad-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/4375c5f1-1cad-11ee-997b-a0510b46b473/session_4a5f2876-1cad-11ee-997b-a0510b46b473/occlusion_4a624109-1cad-11ee-997b-a0510b46b473/scan_4b836789-1cad-11ee-997b-a0510b46b473/8e93136a-1cad-11ee-997b-a0510b46b473.png','PATIENT_4375c5f1-1cad-11ee-997b-a0510b46b473_ACT_4a5f2876-1cad-11ee-997b-a0510b46b473_SESS_4a624109-1cad-11ee-997b-a0510b46b473_TOSC_4b836789-1cad-11ee-997b-a0510b46b473_SNAPS','8e93136a-1cad-11ee-997b-a0510b46b473.png','8e93136a-1cad-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.31.1.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-07 12:03:44.198','2023-07-07 10:03:44.768',NULL),('8ef7ae79-1a72-11ee-9594-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_77df3b68-1a6c-11ee-af16-a0510b46b473/occlusion_77e234a6-1a6c-11ee-af16-a0510b46b473/scan_38d97111-1a72-11ee-9594-a0510b46b473/8ef7ae79-1a72-11ee-9594-a0510b46b473.zip','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_77df3b68-1a6c-11ee-af16-a0510b46b473_SESS_77e234a6-1a6c-11ee-af16-a0510b46b473_TOSC_38d97111-1a72-11ee-9594-a0510b46b473_MODEL','8ef7ae79-1a72-11ee-9594-a0510b46b473.zip','8ef7ae79-1a72-11ee-9594-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.4.1.5\",\"modelMatrix\":\"0.651276,0.75697,-0.0532511,0,-0.758841,0.649671,-0.0457028,0,-4.96554e-10,0.0701742,0.997535,0,-28.9909,-8.20124,-10.8573,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-04 15:56:22.225','2023-07-04 13:56:22.990',NULL),('8ef7c672-1a72-11ee-9594-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_77df3b68-1a6c-11ee-af16-a0510b46b473/occlusion_77e234a6-1a6c-11ee-af16-a0510b46b473/scan_38d97111-1a72-11ee-9594-a0510b46b473/8ef7c672-1a72-11ee-9594-a0510b46b473.png','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_77df3b68-1a6c-11ee-af16-a0510b46b473_SESS_77e234a6-1a6c-11ee-af16-a0510b46b473_TOSC_38d97111-1a72-11ee-9594-a0510b46b473_SNAPS','8ef7c672-1a72-11ee-9594-a0510b46b473.png','8ef7c672-1a72-11ee-9594-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.4.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-04 15:56:22.226','2023-07-04 13:56:22.990',NULL),('8f08547d-de9a-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/35e16a68-de95-11ed-9cc3-00d86184ce3d/session_450c29ef-de95-11ed-9cc3-00d86184ce3d/occlusion_450efda8-de95-11ed-9cc3-00d86184ce3d/scan_da14666c-de99-11ed-9cc3-00d86184ce3d/8f08547d-de9a-11ed-9cc3-00d86184ce3d.zip','PATIENT_35e16a68-de95-11ed-9cc3-00d86184ce3d_ACT_450c29ef-de95-11ed-9cc3-00d86184ce3d_SESS_450efda8-de95-11ed-9cc3-00d86184ce3d_TOSC_da14666c-de99-11ed-9cc3-00d86184ce3d_MODEL','8f08547d-de9a-11ed-9cc3-00d86184ce3d.zip','8f08547d-de9a-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.4.1.1.7\",\"modelMatrix\":\"0.594856,0.770853,-0.227887,0,-0.803832,0.57045,-0.168642,0,1.84004e-08,0.2835,0.958972,0,-28.0983,-10.9811,-10.0831,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-19 12:11:32.437','2023-04-19 10:11:33.471',NULL),('8f086ad7-de9a-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/35e16a68-de95-11ed-9cc3-00d86184ce3d/session_450c29ef-de95-11ed-9cc3-00d86184ce3d/occlusion_450efda8-de95-11ed-9cc3-00d86184ce3d/scan_da14666c-de99-11ed-9cc3-00d86184ce3d/8f086ad7-de9a-11ed-9cc3-00d86184ce3d.png','PATIENT_35e16a68-de95-11ed-9cc3-00d86184ce3d_ACT_450c29ef-de95-11ed-9cc3-00d86184ce3d_SESS_450efda8-de95-11ed-9cc3-00d86184ce3d_TOSC_da14666c-de99-11ed-9cc3-00d86184ce3d_SNAPS','8f086ad7-de9a-11ed-9cc3-00d86184ce3d.png','8f086ad7-de9a-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.4.1.1.7 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-19 12:11:32.437','2023-04-19 10:11:33.471',NULL),('8fefa1e3-10d7-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/bd51960a-10d5-11ee-b636-a0510b46b473/session_c5e67f1c-10d5-11ee-b636-a0510b46b473/occlusion_c5e95a7b-10d5-11ee-b636-a0510b46b473/scan_2dbec3da-10d7-11ee-b636-a0510b46b473/8fefa1e3-10d7-11ee-b636-a0510b46b473.zip','PATIENT_bd51960a-10d5-11ee-b636-a0510b46b473_ACT_c5e67f1c-10d5-11ee-b636-a0510b46b473_SESS_c5e95a7b-10d5-11ee-b636-a0510b46b473_TOSC_2dbec3da-10d7-11ee-b636-a0510b46b473_MODEL','8fefa1e3-10d7-11ee-b636-a0510b46b473.zip','8fefa1e3-10d7-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.17.1.1.4\",\"modelMatrix\":\"0.479007,0.865949,-0.143823,0,-0.877811,0.472534,-0.0784816,0,4.18709e-09,0.163842,0.986486,0,-28.1126,-16.8675,-10.0151,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 10:34:11.392','2023-06-22 08:34:12.280',NULL),('8ff0e4ce-10d7-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/bd51960a-10d5-11ee-b636-a0510b46b473/session_c5e67f1c-10d5-11ee-b636-a0510b46b473/occlusion_c5e95a7b-10d5-11ee-b636-a0510b46b473/scan_2dbec3da-10d7-11ee-b636-a0510b46b473/8ff0e4ce-10d7-11ee-b636-a0510b46b473.png','PATIENT_bd51960a-10d5-11ee-b636-a0510b46b473_ACT_c5e67f1c-10d5-11ee-b636-a0510b46b473_SESS_c5e95a7b-10d5-11ee-b636-a0510b46b473_TOSC_2dbec3da-10d7-11ee-b636-a0510b46b473_SNAPS','8ff0e4ce-10d7-11ee-b636-a0510b46b473.png','8ff0e4ce-10d7-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.17.1.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 10:34:11.400','2023-06-22 08:34:12.281',NULL),('916556b1-15bf-11ee-a062-a0510b46b473',11,'/home/scan/.data//2023/11/142e7037-15b6-11ee-b3b1-00d86184ce3d/session_c41888b6-15ba-11ee-b3b1-00d86184ce3d/occlusion_c41a4d8e-15ba-11ee-b3b1-00d86184ce3d/scan_5062a95e-15bf-11ee-a062-a0510b46b473/916556b1-15bf-11ee-a062-a0510b46b473.zip','PATIENT_142e7037-15b6-11ee-b3b1-00d86184ce3d_ACT_c41888b6-15ba-11ee-b3b1-00d86184ce3d_SESS_c41a4d8e-15ba-11ee-b3b1-00d86184ce3d_TOSC_5062a95e-15bf-11ee-a062-a0510b46b473_MODEL','916556b1-15bf-11ee-a062-a0510b46b473.zip','916556b1-15bf-11ee-a062-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.25.2.1.5\",\"modelMatrix\":\"0.849062,0.489439,-0.198856,0,-0.528294,0.786615,-0.319597,0,4.20551e-10,0.376412,0.926452,0,-31.3226,0.84401,-11.2059,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-28 16:25:01.733','2023-06-28 14:25:02.391',NULL),('91656ce2-15bf-11ee-a062-a0510b46b473',11,'/home/scan/.data//2023/11/142e7037-15b6-11ee-b3b1-00d86184ce3d/session_c41888b6-15ba-11ee-b3b1-00d86184ce3d/occlusion_c41a4d8e-15ba-11ee-b3b1-00d86184ce3d/scan_5062a95e-15bf-11ee-a062-a0510b46b473/91656ce2-15bf-11ee-a062-a0510b46b473.png','PATIENT_142e7037-15b6-11ee-b3b1-00d86184ce3d_ACT_c41888b6-15ba-11ee-b3b1-00d86184ce3d_SESS_c41a4d8e-15ba-11ee-b3b1-00d86184ce3d_TOSC_5062a95e-15bf-11ee-a062-a0510b46b473_SNAPS','91656ce2-15bf-11ee-a062-a0510b46b473.png','91656ce2-15bf-11ee-a062-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.25.2.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-28 16:25:01.734','2023-06-28 14:25:02.392',NULL),('91717ded-1bfe-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/8a8cc548-1bf9-11ee-9323-a0510b46b473/session_976f015a-1bf9-11ee-9323-a0510b46b473/occlusion_97713d19-1bf9-11ee-9323-a0510b46b473/scan_34fbc4ca-1bfe-11ee-9323-a0510b46b473/91717ded-1bfe-11ee-9323-a0510b46b473.zip','PATIENT_8a8cc548-1bf9-11ee-9323-a0510b46b473_ACT_976f015a-1bf9-11ee-9323-a0510b46b473_SESS_97713d19-1bf9-11ee-9323-a0510b46b473_TOSC_34fbc4ca-1bfe-11ee-9323-a0510b46b473_MODEL','91717ded-1bfe-11ee-9323-a0510b46b473.zip','91717ded-1bfe-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.28.1.1.8\",\"modelMatrix\":\"-0.491013,0.859004,-0.144973,0,-0.871152,-0.484167,0.0817121,0,-8.09899e-10,0.166415,0.986056,0,-7.16881,-31.5669,-11.4194,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 15:11:07.084','2023-07-06 13:11:07.879',NULL),('917194db-1bfe-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/8a8cc548-1bf9-11ee-9323-a0510b46b473/session_976f015a-1bf9-11ee-9323-a0510b46b473/occlusion_97713d19-1bf9-11ee-9323-a0510b46b473/scan_34fbc4ca-1bfe-11ee-9323-a0510b46b473/917194db-1bfe-11ee-9323-a0510b46b473.png','PATIENT_8a8cc548-1bf9-11ee-9323-a0510b46b473_ACT_976f015a-1bf9-11ee-9323-a0510b46b473_SESS_97713d19-1bf9-11ee-9323-a0510b46b473_TOSC_34fbc4ca-1bfe-11ee-9323-a0510b46b473_SNAPS','917194db-1bfe-11ee-9323-a0510b46b473.png','917194db-1bfe-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.28.1.1.8 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 15:11:07.084','2023-07-06 13:11:07.882',NULL),('91804714-dd03-11ed-8097-00d86184ce3d',11,'/home/scan/.data//2023/11/59af3050-dcfe-11ed-8097-00d86184ce3d/session_61025fcf-dcfe-11ed-8097-00d86184ce3d/occlusion_610548c3-dcfe-11ed-8097-00d86184ce3d/scan_389d6b03-dd03-11ed-8097-00d86184ce3d/91804714-dd03-11ed-8097-00d86184ce3d.zip','PATIENT_59af3050-dcfe-11ed-8097-00d86184ce3d_ACT_61025fcf-dcfe-11ed-8097-00d86184ce3d_SESS_610548c3-dcfe-11ed-8097-00d86184ce3d_TOSC_389d6b03-dd03-11ed-8097-00d86184ce3d_MODEL','91804714-dd03-11ed-8097-00d86184ce3d.zip','91804714-dd03-11ed-8097-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.1.1.1.7\",\"modelMatrix\":\"0.0811504,0.924718,-0.371901,0,-0.996702,0.0752896,-0.0302798,0,1.25639e-10,0.373131,0.927778,0,-27.4951,-19.5417,-3.49404,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-04-17 11:38:11.409','2023-04-17 09:38:12.570','2023-04-17 11:38:12.972'),('91805d79-dd03-11ed-8097-00d86184ce3d',11,'/home/scan/.data//2023/11/59af3050-dcfe-11ed-8097-00d86184ce3d/session_61025fcf-dcfe-11ed-8097-00d86184ce3d/occlusion_610548c3-dcfe-11ed-8097-00d86184ce3d/scan_389d6b03-dd03-11ed-8097-00d86184ce3d/91805d79-dd03-11ed-8097-00d86184ce3d.png','PATIENT_59af3050-dcfe-11ed-8097-00d86184ce3d_ACT_61025fcf-dcfe-11ed-8097-00d86184ce3d_SESS_610548c3-dcfe-11ed-8097-00d86184ce3d_TOSC_389d6b03-dd03-11ed-8097-00d86184ce3d_SNAPS','91805d79-dd03-11ed-8097-00d86184ce3d.png','91805d79-dd03-11ed-8097-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.1.1.1.7 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-04-17 11:38:11.410','2023-04-17 09:38:12.570','2023-04-17 11:38:13.119'),('919e2af8-110a-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_ceaea325-1107-11ee-b636-a0510b46b473/occlusion_ceb199a7-1107-11ee-b636-a0510b46b473/scan_347289c7-110a-11ee-b636-a0510b46b473/919e2af8-110a-11ee-b636-a0510b46b473.zip','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_ceaea325-1107-11ee-b636-a0510b46b473_SESS_ceb199a7-1107-11ee-b636-a0510b46b473_TOSC_347289c7-110a-11ee-b636-a0510b46b473_MODEL','919e2af8-110a-11ee-b636-a0510b46b473.zip','919e2af8-110a-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.20.2.1.6\",\"modelMatrix\":\"0.649607,0.651575,-0.39174,0,-0.76027,0.556734,-0.334719,0,-6.01864e-09,0.515264,0.857032,0,-29.6135,-8.96198,-3.88127,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 16:39:18.547','2023-06-22 14:39:20.284',NULL),('919e4283-110a-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_ceaea325-1107-11ee-b636-a0510b46b473/occlusion_ceb199a7-1107-11ee-b636-a0510b46b473/scan_347289c7-110a-11ee-b636-a0510b46b473/919e4283-110a-11ee-b636-a0510b46b473.png','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_ceaea325-1107-11ee-b636-a0510b46b473_SESS_ceb199a7-1107-11ee-b636-a0510b46b473_TOSC_347289c7-110a-11ee-b636-a0510b46b473_SNAPS','919e4283-110a-11ee-b636-a0510b46b473.png','919e4283-110a-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.20.2.1.6 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 16:39:18.547','2023-06-22 14:39:20.285',NULL),('91c8b1bf-15b9-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/142e7037-15b6-11ee-b3b1-00d86184ce3d/session_1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d/occlusion_1ed7780a-15b6-11ee-b3b1-00d86184ce3d/scan_25ba4185-15b9-11ee-b3b1-00d86184ce3d/91c8b1bf-15b9-11ee-b3b1-00d86184ce3d.zip','PATIENT_142e7037-15b6-11ee-b3b1-00d86184ce3d_ACT_1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d_SESS_1ed7780a-15b6-11ee-b3b1-00d86184ce3d_TOSC_25ba4185-15b9-11ee-b3b1-00d86184ce3d_MODEL','91c8b1bf-15b9-11ee-b3b1-00d86184ce3d.zip','91c8b1bf-15b9-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.25.1.1.9\",\"modelMatrix\":\"0.637415,0.762218,-0.112811,0,-0.770521,0.630546,-0.0933233,0,-8.83134e-09,0.146409,0.989224,0,-30.2329,-6.71581,-11.2167,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-28 15:42:05.404','2023-06-28 13:42:06.313',NULL),('91c9efed-15b9-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/142e7037-15b6-11ee-b3b1-00d86184ce3d/session_1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d/occlusion_1ed7780a-15b6-11ee-b3b1-00d86184ce3d/scan_25ba4185-15b9-11ee-b3b1-00d86184ce3d/91c9efed-15b9-11ee-b3b1-00d86184ce3d.png','PATIENT_142e7037-15b6-11ee-b3b1-00d86184ce3d_ACT_1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d_SESS_1ed7780a-15b6-11ee-b3b1-00d86184ce3d_TOSC_25ba4185-15b9-11ee-b3b1-00d86184ce3d_SNAPS','91c9efed-15b9-11ee-b3b1-00d86184ce3d.png','91c9efed-15b9-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.25.1.1.9 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-28 15:42:05.412','2023-06-28 13:42:06.314',NULL),('921e2c32-2aea-11ee-97fa-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_8b758c52-2ae7-11ee-97fa-a0510b46b473/occlusion_8b789858-2ae7-11ee-97fa-a0510b46b473/scan_56105016-2aea-11ee-97fa-a0510b46b473/921e2c32-2aea-11ee-97fa-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_8b758c52-2ae7-11ee-97fa-a0510b46b473_SESS_8b789858-2ae7-11ee-97fa-a0510b46b473_TOSC_56105016-2aea-11ee-97fa-a0510b46b473_MODEL','921e2c32-2aea-11ee-97fa-a0510b46b473.zip','921e2c32-2aea-11ee-97fa-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.9.1.6\",\"modelMatrix\":\"0.86996,0.452569,-0.195834,0,-0.493122,0.798417,-0.345487,0,9.76193e-10,0.39713,0.917762,0,-31.0946,0.585811,-10.2373,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-25 14:55:45.723','2023-07-25 12:55:46.265',NULL),('921e448a-2aea-11ee-97fa-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_8b758c52-2ae7-11ee-97fa-a0510b46b473/occlusion_8b789858-2ae7-11ee-97fa-a0510b46b473/scan_56105016-2aea-11ee-97fa-a0510b46b473/921e448a-2aea-11ee-97fa-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_8b758c52-2ae7-11ee-97fa-a0510b46b473_SESS_8b789858-2ae7-11ee-97fa-a0510b46b473_TOSC_56105016-2aea-11ee-97fa-a0510b46b473_SNAPS','921e448a-2aea-11ee-97fa-a0510b46b473.png','921e448a-2aea-11ee-97fa-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.9.1.6 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-25 14:55:45.723','2023-07-25 12:55:46.266',NULL),('9285fbe3-dd05-11ed-8097-00d86184ce3d',11,'/home/scan/.data//2023/11/59af3050-dcfe-11ed-8097-00d86184ce3d/session_61025fcf-dcfe-11ed-8097-00d86184ce3d/occlusion_610548c3-dcfe-11ed-8097-00d86184ce3d/scan_48f0dbce-dd05-11ed-8097-00d86184ce3d/9285fbe3-dd05-11ed-8097-00d86184ce3d.zip','PATIENT_59af3050-dcfe-11ed-8097-00d86184ce3d_ACT_61025fcf-dcfe-11ed-8097-00d86184ce3d_SESS_610548c3-dcfe-11ed-8097-00d86184ce3d_TOSC_48f0dbce-dd05-11ed-8097-00d86184ce3d_MODEL','9285fbe3-dd05-11ed-8097-00d86184ce3d.zip','9285fbe3-dd05-11ed-8097-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.1.1.1.11\",\"modelMatrix\":\"-0.901238,0.429761,-0.0554595,0,-0.433325,-0.893826,0.115346,0,1.32165e-10,0.127986,0.991776,0,13.6749,-25.6297,-9.24645,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-04-17 11:52:32.118','2023-04-17 09:52:32.939','2023-04-17 11:52:33.325'),('9286124c-dd05-11ed-8097-00d86184ce3d',11,'/home/scan/.data//2023/11/59af3050-dcfe-11ed-8097-00d86184ce3d/session_61025fcf-dcfe-11ed-8097-00d86184ce3d/occlusion_610548c3-dcfe-11ed-8097-00d86184ce3d/scan_48f0dbce-dd05-11ed-8097-00d86184ce3d/9286124c-dd05-11ed-8097-00d86184ce3d.png','PATIENT_59af3050-dcfe-11ed-8097-00d86184ce3d_ACT_61025fcf-dcfe-11ed-8097-00d86184ce3d_SESS_610548c3-dcfe-11ed-8097-00d86184ce3d_TOSC_48f0dbce-dd05-11ed-8097-00d86184ce3d_SNAPS','9286124c-dd05-11ed-8097-00d86184ce3d.png','9286124c-dd05-11ed-8097-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.1.1.1.11 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-04-17 11:52:32.118','2023-04-17 09:52:32.939','2023-04-17 11:52:33.453'),('92df8cc0-1108-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_ceaea325-1107-11ee-b636-a0510b46b473/occlusion_ceb199a7-1107-11ee-b636-a0510b46b473/scan_4abfd2f6-1108-11ee-b636-a0510b46b473/92df8cc0-1108-11ee-b636-a0510b46b473.zip','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_ceaea325-1107-11ee-b636-a0510b46b473_SESS_ceb199a7-1107-11ee-b636-a0510b46b473_TOSC_4abfd2f6-1108-11ee-b636-a0510b46b473_MODEL','92df8cc0-1108-11ee-b636-a0510b46b473.zip','92df8cc0-1108-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.20.2.1.3\",\"modelMatrix\":\"0.85195,0.441827,-0.281017,0,-0.523624,0.718865,-0.457222,0,-7.12364e-09,0.536677,0.843788,0,-28.6839,8.86772,-9.74439,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 16:25:01.659','2023-06-22 14:25:02.361',NULL),('92dfa05f-1108-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_ceaea325-1107-11ee-b636-a0510b46b473/occlusion_ceb199a7-1107-11ee-b636-a0510b46b473/scan_4abfd2f6-1108-11ee-b636-a0510b46b473/92dfa05f-1108-11ee-b636-a0510b46b473.png','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_ceaea325-1107-11ee-b636-a0510b46b473_SESS_ceb199a7-1107-11ee-b636-a0510b46b473_TOSC_4abfd2f6-1108-11ee-b636-a0510b46b473_SNAPS','92dfa05f-1108-11ee-b636-a0510b46b473.png','92dfa05f-1108-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.20.2.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 16:25:01.660','2023-06-22 14:25:02.361',NULL),('9364a491-2702-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/848c86d9-26fd-11ee-a98e-a0510b46b473/session_8f62cd50-26fd-11ee-a98e-a0510b46b473/occlusion_8f65e2e0-26fd-11ee-a98e-a0510b46b473/scan_54635134-2702-11ee-a98e-a0510b46b473/9364a491-2702-11ee-a98e-a0510b46b473.zip','PATIENT_848c86d9-26fd-11ee-a98e-a0510b46b473_ACT_8f62cd50-26fd-11ee-a98e-a0510b46b473_SESS_8f65e2e0-26fd-11ee-a98e-a0510b46b473_BOSC_54635134-2702-11ee-a98e-a0510b46b473_MODEL','9364a491-2702-11ee-a98e-a0510b46b473.zip','9364a491-2702-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Mandibule 1.36.1.1.1\",\"modelMatrix\":\"0.758596,0.60831,-0.233432,0,-0.651561,0.70824,-0.271778,0,-8.55445e-09,0.358265,0.93362,0,-4.35862,-28.6659,-12.1643,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,'2023-07-20 15:37:50.694','2023-07-20 15:37:31.132','2023-07-20 13:37:50.711',NULL),('9364b9a8-2702-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/848c86d9-26fd-11ee-a98e-a0510b46b473/session_8f62cd50-26fd-11ee-a98e-a0510b46b473/occlusion_8f65e2e0-26fd-11ee-a98e-a0510b46b473/scan_54635134-2702-11ee-a98e-a0510b46b473/9364b9a8-2702-11ee-a98e-a0510b46b473.png','PATIENT_848c86d9-26fd-11ee-a98e-a0510b46b473_ACT_8f62cd50-26fd-11ee-a98e-a0510b46b473_SESS_8f65e2e0-26fd-11ee-a98e-a0510b46b473_BOSC_54635134-2702-11ee-a98e-a0510b46b473_SNAPS','9364b9a8-2702-11ee-a98e-a0510b46b473.png','9364b9a8-2702-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Mandibule 1.36.1.1.1 Snapshot\"}','PNG',0,'CREATED',0,'2023-07-20 15:37:50.694','2023-07-20 15:37:31.133','2023-07-20 13:37:50.718',NULL),('93f97b8a-0f42-11ee-8712-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_55019e04-0f41-11ee-8712-a0510b46b473/occlusion_550492f3-0f41-11ee-8712-a0510b46b473/scan_5f5fa83b-0f42-11ee-8712-a0510b46b473/93f97b8a-0f42-11ee-8712-a0510b46b473.zip','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_55019e04-0f41-11ee-8712-a0510b46b473_SESS_550492f3-0f41-11ee-8712-a0510b46b473_TOSC_5f5fa83b-0f42-11ee-8712-a0510b46b473_MODEL','93f97b8a-0f42-11ee-8712-a0510b46b473.zip','93f97b8a-0f42-11ee-8712-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.2.1.4\",\"modelMatrix\":\"0.806802,0.496974,-0.31951,0,-0.590821,0.678648,-0.43631,0,1.93463e-08,0.540789,0.841158,0,-19.8412,7.17526,-6.74709,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-20 10:15:11.992','2023-06-20 08:15:12.467',NULL),('93f9932b-0f42-11ee-8712-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_55019e04-0f41-11ee-8712-a0510b46b473/occlusion_550492f3-0f41-11ee-8712-a0510b46b473/scan_5f5fa83b-0f42-11ee-8712-a0510b46b473/93f9932b-0f42-11ee-8712-a0510b46b473.png','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_55019e04-0f41-11ee-8712-a0510b46b473_SESS_550492f3-0f41-11ee-8712-a0510b46b473_TOSC_5f5fa83b-0f42-11ee-8712-a0510b46b473_SNAPS','93f9932b-0f42-11ee-8712-a0510b46b473.png','93f9932b-0f42-11ee-8712-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.2.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-20 10:15:11.992','2023-06-20 08:15:12.470',NULL),('9558c038-158a-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/634153bc-1587-11ee-b3b1-00d86184ce3d/session_6e9df503-1587-11ee-b3b1-00d86184ce3d/occlusion_6ea0d9b2-1587-11ee-b3b1-00d86184ce3d/scan_50156bf7-158a-11ee-b3b1-00d86184ce3d/9558c038-158a-11ee-b3b1-00d86184ce3d.zip','PATIENT_634153bc-1587-11ee-b3b1-00d86184ce3d_ACT_6e9df503-1587-11ee-b3b1-00d86184ce3d_SESS_6ea0d9b2-1587-11ee-b3b1-00d86184ce3d_TOSC_50156bf7-158a-11ee-b3b1-00d86184ce3d_MODEL','9558c038-158a-11ee-b3b1-00d86184ce3d.zip','9558c038-158a-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.24.1.1.4\",\"modelMatrix\":\"0.995152,0.0973049,-0.0142746,0,-0.0983464,0.984614,-0.144442,0,2.43245e-10,0.145146,0.98941,0,-19.1647,18.6289,-12.8582,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-28 10:05:45.035','2023-06-28 08:05:45.656',NULL),('9558d416-158a-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/634153bc-1587-11ee-b3b1-00d86184ce3d/session_6e9df503-1587-11ee-b3b1-00d86184ce3d/occlusion_6ea0d9b2-1587-11ee-b3b1-00d86184ce3d/scan_50156bf7-158a-11ee-b3b1-00d86184ce3d/9558d416-158a-11ee-b3b1-00d86184ce3d.png','PATIENT_634153bc-1587-11ee-b3b1-00d86184ce3d_ACT_6e9df503-1587-11ee-b3b1-00d86184ce3d_SESS_6ea0d9b2-1587-11ee-b3b1-00d86184ce3d_TOSC_50156bf7-158a-11ee-b3b1-00d86184ce3d_SNAPS','9558d416-158a-11ee-b3b1-00d86184ce3d.png','9558d416-158a-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.24.1.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-28 10:05:45.036','2023-06-28 08:05:45.656',NULL),('956b64b3-1cb1-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/4375c5f1-1cad-11ee-997b-a0510b46b473/session_dfb50528-1cb0-11ee-997b-a0510b46b473/occlusion_dfb7e00f-1cb0-11ee-997b-a0510b46b473/scan_63d415ce-1cb1-11ee-997b-a0510b46b473/956b64b3-1cb1-11ee-997b-a0510b46b473.zip','PATIENT_4375c5f1-1cad-11ee-997b-a0510b46b473_ACT_dfb50528-1cb0-11ee-997b-a0510b46b473_SESS_dfb7e00f-1cb0-11ee-997b-a0510b46b473_TOSC_63d415ce-1cb1-11ee-997b-a0510b46b473_MODEL','956b64b3-1cb1-11ee-997b-a0510b46b473.zip','956b64b3-1cb1-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.31.2.1.3\",\"modelMatrix\":\"0.710685,0.592615,-0.379122,0,-0.70351,0.598659,-0.382989,0,8.53065e-09,0.538901,0.842369,0,-29.3117,5.17499,-9.83762,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-07 12:32:33.669','2023-07-07 10:32:34.142',NULL),('956b78be-1cb1-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/4375c5f1-1cad-11ee-997b-a0510b46b473/session_dfb50528-1cb0-11ee-997b-a0510b46b473/occlusion_dfb7e00f-1cb0-11ee-997b-a0510b46b473/scan_63d415ce-1cb1-11ee-997b-a0510b46b473/956b78be-1cb1-11ee-997b-a0510b46b473.png','PATIENT_4375c5f1-1cad-11ee-997b-a0510b46b473_ACT_dfb50528-1cb0-11ee-997b-a0510b46b473_SESS_dfb7e00f-1cb0-11ee-997b-a0510b46b473_TOSC_63d415ce-1cb1-11ee-997b-a0510b46b473_SNAPS','956b78be-1cb1-11ee-997b-a0510b46b473.png','956b78be-1cb1-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.31.2.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-07 12:32:33.670','2023-07-07 10:32:34.148',NULL),('95863857-e041-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_261265bf-e03f-11ed-bb13-00d86184ce3d/occlusion_2615e3c8-e03f-11ed-bb13-00d86184ce3d/scan_5d6835c8-e041-11ed-bb13-00d86184ce3d/95863857-e041-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_261265bf-e03f-11ed-bb13-00d86184ce3d_SESS_2615e3c8-e03f-11ed-bb13-00d86184ce3d_TOSC_5d6835c8-e041-11ed-bb13-00d86184ce3d_MODEL','95863857-e041-11ed-bb13-00d86184ce3d.zip','95863857-e041-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.4.1.6\",\"modelMatrix\":\"0.738776,0.582228,-0.339441,0,-0.67395,0.638231,-0.372091,0,-1.23131e-08,0.503659,0.863903,0,-32.1055,-5.78676,-9.86742,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,'2023-04-21 14:39:57.459','2023-04-21 14:39:40.445','2023-04-21 12:39:57.463',NULL),('95864db7-e041-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_261265bf-e03f-11ed-bb13-00d86184ce3d/occlusion_2615e3c8-e03f-11ed-bb13-00d86184ce3d/scan_5d6835c8-e041-11ed-bb13-00d86184ce3d/95864db7-e041-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_261265bf-e03f-11ed-bb13-00d86184ce3d_SESS_2615e3c8-e03f-11ed-bb13-00d86184ce3d_TOSC_5d6835c8-e041-11ed-bb13-00d86184ce3d_SNAPS','95864db7-e041-11ed-bb13-00d86184ce3d.png','95864db7-e041-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.4.1.6 Snapshot\"}','PNG',0,'CREATED',0,'2023-04-21 14:39:57.459','2023-04-21 14:39:40.445','2023-04-21 12:39:57.467',NULL),('95ac349b-e010-11ed-b6c2-00d86184ce3d',11,'/home/scan/.data//2023/11/e0d449f3-dde9-11ed-aa56-00d86184ce3d/session_858fcc60-de94-11ed-9cc3-00d86184ce3d/occlusion_85925fd9-de94-11ed-9cc3-00d86184ce3d/scan_55708cfc-e010-11ed-b6c2-00d86184ce3d/95ac349b-e010-11ed-b6c2-00d86184ce3d.zip','PATIENT_e0d449f3-dde9-11ed-aa56-00d86184ce3d_ACT_858fcc60-de94-11ed-9cc3-00d86184ce3d_SESS_85925fd9-de94-11ed-9cc3-00d86184ce3d_BOSC_55708cfc-e010-11ed-b6c2-00d86184ce3d_MODEL','95ac349b-e010-11ed-b6c2-00d86184ce3d.zip','95ac349b-e010-11ed-b6c2-00d86184ce3d','{\"displayTitle\":\"Mandibule 1.2.1.1.2\",\"modelMatrix\":\"0.889988,0.432614,-0.144106,0,-0.455984,0.844375,-0.281265,0,-1.02366e-08,0.316032,0.948748,0,-26.9988,1.54562,-11.1031,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 08:48:55.354','2023-04-21 06:48:55.968',NULL),('95ac4896-e010-11ed-b6c2-00d86184ce3d',11,'/home/scan/.data//2023/11/e0d449f3-dde9-11ed-aa56-00d86184ce3d/session_858fcc60-de94-11ed-9cc3-00d86184ce3d/occlusion_85925fd9-de94-11ed-9cc3-00d86184ce3d/scan_55708cfc-e010-11ed-b6c2-00d86184ce3d/95ac4896-e010-11ed-b6c2-00d86184ce3d.png','PATIENT_e0d449f3-dde9-11ed-aa56-00d86184ce3d_ACT_858fcc60-de94-11ed-9cc3-00d86184ce3d_SESS_85925fd9-de94-11ed-9cc3-00d86184ce3d_BOSC_55708cfc-e010-11ed-b6c2-00d86184ce3d_SNAPS','95ac4896-e010-11ed-b6c2-00d86184ce3d.png','95ac4896-e010-11ed-b6c2-00d86184ce3d','{\"displayTitle\":\"Mandibule 1.2.1.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 08:48:55.354','2023-04-21 06:48:55.969',NULL),('960d546d-dd07-11ed-8097-00d86184ce3d',11,'/home/scan/.data//2023/11/59af3050-dcfe-11ed-8097-00d86184ce3d/session_61025fcf-dcfe-11ed-8097-00d86184ce3d/occlusion_610548c3-dcfe-11ed-8097-00d86184ce3d/scan_ec173e64-dd06-11ed-8097-00d86184ce3d/960d546d-dd07-11ed-8097-00d86184ce3d.zip','PATIENT_59af3050-dcfe-11ed-8097-00d86184ce3d_ACT_61025fcf-dcfe-11ed-8097-00d86184ce3d_SESS_610548c3-dcfe-11ed-8097-00d86184ce3d_TOSC_ec173e64-dd06-11ed-8097-00d86184ce3d_MODEL','960d546d-dd07-11ed-8097-00d86184ce3d.zip','960d546d-dd07-11ed-8097-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.1.1.1.12\",\"modelMatrix\":\"0.355043,0.900359,-0.251592,0,-0.93485,0.341943,-0.0955511,0,6.28501e-09,0.269126,0.963105,0,-27.0376,-17.67,-9.75704,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-04-17 12:06:57.032','2023-04-17 10:06:58.696','2023-04-17 12:06:59.054'),('960d6aca-dd07-11ed-8097-00d86184ce3d',11,'/home/scan/.data//2023/11/59af3050-dcfe-11ed-8097-00d86184ce3d/session_61025fcf-dcfe-11ed-8097-00d86184ce3d/occlusion_610548c3-dcfe-11ed-8097-00d86184ce3d/scan_ec173e64-dd06-11ed-8097-00d86184ce3d/960d6aca-dd07-11ed-8097-00d86184ce3d.png','PATIENT_59af3050-dcfe-11ed-8097-00d86184ce3d_ACT_61025fcf-dcfe-11ed-8097-00d86184ce3d_SESS_610548c3-dcfe-11ed-8097-00d86184ce3d_TOSC_ec173e64-dd06-11ed-8097-00d86184ce3d_SNAPS','960d6aca-dd07-11ed-8097-00d86184ce3d.png','960d6aca-dd07-11ed-8097-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.1.1.1.12 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-04-17 12:06:57.032','2023-04-17 10:06:58.697','2023-04-17 12:06:59.182'),('96276406-1a63-11ee-9a4f-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_56e1eee3-1a49-11ee-9a4f-a0510b46b473/occlusion_56e449e9-1a49-11ee-9a4f-a0510b46b473/scan_f84b8d53-1a62-11ee-9a4f-a0510b46b473/96276406-1a63-11ee-9a4f-a0510b46b473.zip','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_56e1eee3-1a49-11ee-9a4f-a0510b46b473_SESS_56e449e9-1a49-11ee-9a4f-a0510b46b473_TOSC_f84b8d53-1a62-11ee-9a4f-a0510b46b473_MODEL','96276406-1a63-11ee-9a4f-a0510b46b473.zip','96276406-1a63-11ee-9a4f-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.1.1.8\",\"modelMatrix\":\"-0.742743,0.628699,-0.23037,0,-0.669576,-0.697399,0.255544,0,-4.7888e-09,0.344054,0.93895,0,3.59376,-36.4553,-4.45049,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-04 14:09:11.831','2023-07-04 12:09:12.927',NULL),('9628a09e-1a63-11ee-9a4f-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_56e1eee3-1a49-11ee-9a4f-a0510b46b473/occlusion_56e449e9-1a49-11ee-9a4f-a0510b46b473/scan_f84b8d53-1a62-11ee-9a4f-a0510b46b473/9628a09e-1a63-11ee-9a4f-a0510b46b473.png','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_56e1eee3-1a49-11ee-9a4f-a0510b46b473_SESS_56e449e9-1a49-11ee-9a4f-a0510b46b473_TOSC_f84b8d53-1a62-11ee-9a4f-a0510b46b473_SNAPS','9628a09e-1a63-11ee-9a4f-a0510b46b473.png','9628a09e-1a63-11ee-9a4f-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.1.1.8 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-04 14:09:11.839','2023-07-04 12:09:12.928',NULL),('964f1327-262f-11ee-81dd-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_ab852a49-262e-11ee-81dd-a0510b46b473/occlusion_ab88338c-262e-11ee-81dd-a0510b46b473/scan_620f86ab-262f-11ee-81dd-a0510b46b473/964f1327-262f-11ee-81dd-a0510b46b473.zip','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_ab852a49-262e-11ee-81dd-a0510b46b473_SESS_ab88338c-262e-11ee-81dd-a0510b46b473_TOSC_620f86ab-262f-11ee-81dd-a0510b46b473_MODEL','964f1327-262f-11ee-81dd-a0510b46b473.zip','964f1327-262f-11ee-81dd-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.2.1.3\",\"modelMatrix\":\"0.820056,0.554743,-0.140599,0,-0.572283,0.794922,-0.201472,0,2.9915e-09,0.245681,0.969351,0,-30.4731,-1.82325,-9.76663,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-19 14:27:12.214','2023-07-19 12:27:12.687',NULL),('964f2a2d-262f-11ee-81dd-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_ab852a49-262e-11ee-81dd-a0510b46b473/occlusion_ab88338c-262e-11ee-81dd-a0510b46b473/scan_620f86ab-262f-11ee-81dd-a0510b46b473/964f2a2d-262f-11ee-81dd-a0510b46b473.png','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_ab852a49-262e-11ee-81dd-a0510b46b473_SESS_ab88338c-262e-11ee-81dd-a0510b46b473_TOSC_620f86ab-262f-11ee-81dd-a0510b46b473_SNAPS','964f2a2d-262f-11ee-81dd-a0510b46b473.png','964f2a2d-262f-11ee-81dd-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.2.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-19 14:27:12.215','2023-07-19 12:27:12.691',NULL),('96ce362f-10e1-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/2ff330cd-10e1-11ee-b636-a0510b46b473/session_3adeac35-10e1-11ee-b636-a0510b46b473/occlusion_3ae23ec4-10e1-11ee-b636-a0510b46b473/scan_47f6b127-10e1-11ee-b636-a0510b46b473/96ce362f-10e1-11ee-b636-a0510b46b473.zip','PATIENT_2ff330cd-10e1-11ee-b636-a0510b46b473_ACT_3adeac35-10e1-11ee-b636-a0510b46b473_SESS_3ae23ec4-10e1-11ee-b636-a0510b46b473_TOSC_47f6b127-10e1-11ee-b636-a0510b46b473_MODEL','96ce362f-10e1-11ee-b636-a0510b46b473.zip','96ce362f-10e1-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.18.1.1.1\",\"modelMatrix\":\"0.913699,0.400077,-0.0713595,0,-0.406392,0.899503,-0.160439,0,-2.04867e-09,0.175593,0.984463,0,-26.4416,8.10265,-12.4638,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 11:45:57.884','2023-06-22 09:45:58.593',NULL),('96ce4ed7-10e1-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/2ff330cd-10e1-11ee-b636-a0510b46b473/session_3adeac35-10e1-11ee-b636-a0510b46b473/occlusion_3ae23ec4-10e1-11ee-b636-a0510b46b473/scan_47f6b127-10e1-11ee-b636-a0510b46b473/96ce4ed7-10e1-11ee-b636-a0510b46b473.png','PATIENT_2ff330cd-10e1-11ee-b636-a0510b46b473_ACT_3adeac35-10e1-11ee-b636-a0510b46b473_SESS_3ae23ec4-10e1-11ee-b636-a0510b46b473_TOSC_47f6b127-10e1-11ee-b636-a0510b46b473_SNAPS','96ce4ed7-10e1-11ee-b636-a0510b46b473.png','96ce4ed7-10e1-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.18.1.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 11:45:57.885','2023-06-22 09:45:58.600',NULL),('96cefd4c-df7e-11ed-b6c2-00d86184ce3d',11,'/home/scan/.data//2023/11/e0d449f3-dde9-11ed-aa56-00d86184ce3d/session_858fcc60-de94-11ed-9cc3-00d86184ce3d/occlusion_85925fd9-de94-11ed-9cc3-00d86184ce3d/scan_463f194b-df7e-11ed-b6c2-00d86184ce3d/96cefd4c-df7e-11ed-b6c2-00d86184ce3d.zip','PATIENT_e0d449f3-dde9-11ed-aa56-00d86184ce3d_ACT_858fcc60-de94-11ed-9cc3-00d86184ce3d_SESS_85925fd9-de94-11ed-9cc3-00d86184ce3d_TOSC_463f194b-df7e-11ed-b6c2-00d86184ce3d_MODEL','96cefd4c-df7e-11ed-b6c2-00d86184ce3d.zip','96cefd4c-df7e-11ed-b6c2-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.2.1.1.5\",\"modelMatrix\":\"-0.95111,0.296088,-0.0878769,0,-0.308853,-0.911798,0.270616,0,9.26982e-09,0.284526,0.958668,0,16.8794,-1.24191,-16.8651,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-20 15:23:50.737','2023-04-20 13:23:51.510',NULL),('96cf1b92-df7e-11ed-b6c2-00d86184ce3d',11,'/home/scan/.data//2023/11/e0d449f3-dde9-11ed-aa56-00d86184ce3d/session_858fcc60-de94-11ed-9cc3-00d86184ce3d/occlusion_85925fd9-de94-11ed-9cc3-00d86184ce3d/scan_463f194b-df7e-11ed-b6c2-00d86184ce3d/96cf1b92-df7e-11ed-b6c2-00d86184ce3d.png','PATIENT_e0d449f3-dde9-11ed-aa56-00d86184ce3d_ACT_858fcc60-de94-11ed-9cc3-00d86184ce3d_SESS_85925fd9-de94-11ed-9cc3-00d86184ce3d_TOSC_463f194b-df7e-11ed-b6c2-00d86184ce3d_SNAPS','96cf1b92-df7e-11ed-b6c2-00d86184ce3d.png','96cf1b92-df7e-11ed-b6c2-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.2.1.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-20 15:23:50.738','2023-04-20 13:23:51.511',NULL),('96e7cad0-1a78-11ee-8124-a0510b46b473',11,'/home/scan/.data//2023/11/61e16a70-1a76-11ee-8124-a0510b46b473/session_c8578c2f-1a77-11ee-8124-a0510b46b473/occlusion_c85af2e9-1a77-11ee-8124-a0510b46b473/scan_30c627d2-1a78-11ee-8124-a0510b46b473/96e7cad0-1a78-11ee-8124-a0510b46b473.zip','PATIENT_61e16a70-1a76-11ee-8124-a0510b46b473_ACT_c8578c2f-1a77-11ee-8124-a0510b46b473_SESS_c85af2e9-1a77-11ee-8124-a0510b46b473_TOSC_30c627d2-1a78-11ee-8124-a0510b46b473_MODEL','96e7cad0-1a78-11ee-8124-a0510b46b473.zip','96e7cad0-1a78-11ee-8124-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.27.2.1.2\",\"modelMatrix\":\"-0.361089,0.927576,-0.0960129,0,-0.932531,-0.35917,0.0371775,0,-2.28936e-09,0.102959,0.994686,0,-11.6373,-29.0425,-11.8232,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-04 16:39:32.523','2023-07-04 14:39:33.130',NULL),('96e90a79-1a78-11ee-8124-a0510b46b473',11,'/home/scan/.data//2023/11/61e16a70-1a76-11ee-8124-a0510b46b473/session_c8578c2f-1a77-11ee-8124-a0510b46b473/occlusion_c85af2e9-1a77-11ee-8124-a0510b46b473/scan_30c627d2-1a78-11ee-8124-a0510b46b473/96e90a79-1a78-11ee-8124-a0510b46b473.png','PATIENT_61e16a70-1a76-11ee-8124-a0510b46b473_ACT_c8578c2f-1a77-11ee-8124-a0510b46b473_SESS_c85af2e9-1a77-11ee-8124-a0510b46b473_TOSC_30c627d2-1a78-11ee-8124-a0510b46b473_SNAPS','96e90a79-1a78-11ee-8124-a0510b46b473.png','96e90a79-1a78-11ee-8124-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.27.2.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-04 16:39:32.531','2023-07-04 14:39:33.130',NULL),('96ec8c33-2ac1-11ee-80c8-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_3a881645-2abf-11ee-80c8-a0510b46b473/occlusion_3a8b3537-2abf-11ee-80c8-a0510b46b473/scan_5d4ad9a4-2ac1-11ee-80c8-a0510b46b473/96ec8c33-2ac1-11ee-80c8-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_3a881645-2abf-11ee-80c8-a0510b46b473_SESS_3a8b3537-2abf-11ee-80c8-a0510b46b473_TOSC_5d4ad9a4-2ac1-11ee-80c8-a0510b46b473_MODEL','96ec8c33-2ac1-11ee-80c8-a0510b46b473.zip','96ec8c33-2ac1-11ee-80c8-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.7.1.5\",\"modelMatrix\":\"0.345337,0.875376,-0.33832,0,-0.938479,0.322116,-0.124493,0,5.04427e-09,0.360498,0.93276,0,-27.2104,-14.9397,-5.5042,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-25 10:02:24.420','2023-07-25 08:02:24.910',NULL),('96eca319-2ac1-11ee-80c8-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_3a881645-2abf-11ee-80c8-a0510b46b473/occlusion_3a8b3537-2abf-11ee-80c8-a0510b46b473/scan_5d4ad9a4-2ac1-11ee-80c8-a0510b46b473/96eca319-2ac1-11ee-80c8-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_3a881645-2abf-11ee-80c8-a0510b46b473_SESS_3a8b3537-2abf-11ee-80c8-a0510b46b473_TOSC_5d4ad9a4-2ac1-11ee-80c8-a0510b46b473_SNAPS','96eca319-2ac1-11ee-80c8-a0510b46b473.png','96eca319-2ac1-11ee-80c8-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.7.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-25 10:02:24.420','2023-07-25 08:02:24.910',NULL),('970476ea-1107-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_0628a8e9-1104-11ee-b636-a0510b46b473/occlusion_062b833f-1104-11ee-b636-a0510b46b473/scan_530a16a3-1107-11ee-b636-a0510b46b473/970476ea-1107-11ee-b636-a0510b46b473.zip','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_0628a8e9-1104-11ee-b636-a0510b46b473_SESS_062b833f-1104-11ee-b636-a0510b46b473_TOSC_530a16a3-1107-11ee-b636-a0510b46b473_MODEL','970476ea-1107-11ee-b636-a0510b46b473.zip','970476ea-1107-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.20.1.1.8\",\"modelMatrix\":\"0.159465,0.957324,-0.241044,0,-0.987204,0.154639,-0.0389364,0,-1.66196e-09,0.244168,0.969733,0,-21.1988,-24.8194,-8.22298,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 16:17:59.116','2023-06-22 14:17:59.835',NULL),('97048dd4-1107-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_0628a8e9-1104-11ee-b636-a0510b46b473/occlusion_062b833f-1104-11ee-b636-a0510b46b473/scan_530a16a3-1107-11ee-b636-a0510b46b473/97048dd4-1107-11ee-b636-a0510b46b473.png','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_0628a8e9-1104-11ee-b636-a0510b46b473_SESS_062b833f-1104-11ee-b636-a0510b46b473_TOSC_530a16a3-1107-11ee-b636-a0510b46b473_SNAPS','97048dd4-1107-11ee-b636-a0510b46b473.png','97048dd4-1107-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.20.1.1.8 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 16:17:59.116','2023-06-22 14:17:59.835',NULL),('9708bc75-1bdc-11ee-9086-a0510b46b473',11,'/home/scan/.data//2023/11/61e16a70-1a76-11ee-8124-a0510b46b473/session_d30b0955-1bdb-11ee-9086-a0510b46b473/occlusion_d30df7f0-1bdb-11ee-9086-a0510b46b473/scan_5c724fe5-1bdc-11ee-9086-a0510b46b473/9708bc75-1bdc-11ee-9086-a0510b46b473.zip','PATIENT_61e16a70-1a76-11ee-8124-a0510b46b473_ACT_d30b0955-1bdb-11ee-9086-a0510b46b473_SESS_d30df7f0-1bdb-11ee-9086-a0510b46b473_TOSC_5c724fe5-1bdc-11ee-9086-a0510b46b473_MODEL','9708bc75-1bdc-11ee-9086-a0510b46b473.zip','9708bc75-1bdc-11ee-9086-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.27.4.1.3\",\"modelMatrix\":\"0.849261,0.492051,-0.191423,0,-0.527974,0.791477,-0.307908,0,3.43242e-09,0.36256,0.93196,0,-27.1764,8.62679,-10.3227,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 11:07:53.575','2023-07-06 09:07:54.015',NULL),('9708d502-1bdc-11ee-9086-a0510b46b473',11,'/home/scan/.data//2023/11/61e16a70-1a76-11ee-8124-a0510b46b473/session_d30b0955-1bdb-11ee-9086-a0510b46b473/occlusion_d30df7f0-1bdb-11ee-9086-a0510b46b473/scan_5c724fe5-1bdc-11ee-9086-a0510b46b473/9708d502-1bdc-11ee-9086-a0510b46b473.png','PATIENT_61e16a70-1a76-11ee-8124-a0510b46b473_ACT_d30b0955-1bdb-11ee-9086-a0510b46b473_SESS_d30df7f0-1bdb-11ee-9086-a0510b46b473_TOSC_5c724fe5-1bdc-11ee-9086-a0510b46b473_SNAPS','9708d502-1bdc-11ee-9086-a0510b46b473.png','9708d502-1bdc-11ee-9086-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.27.4.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 11:07:53.575','2023-07-06 09:07:54.016',NULL),('973f7765-2701-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/848c86d9-26fd-11ee-a98e-a0510b46b473/session_8f62cd50-26fd-11ee-a98e-a0510b46b473/occlusion_8f65e2e0-26fd-11ee-a98e-a0510b46b473/scan_32674cda-2701-11ee-a98e-a0510b46b473/973f7765-2701-11ee-a98e-a0510b46b473.zip','PATIENT_848c86d9-26fd-11ee-a98e-a0510b46b473_ACT_8f62cd50-26fd-11ee-a98e-a0510b46b473_SESS_8f65e2e0-26fd-11ee-a98e-a0510b46b473_TOSC_32674cda-2701-11ee-a98e-a0510b46b473_MODEL','973f7765-2701-11ee-a98e-a0510b46b473.zip','973f7765-2701-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.36.1.1.9\",\"modelMatrix\":\"0.186603,0.965679,-0.180674,0,-0.982435,0.18342,-0.0343171,0,1.03838e-09,0.183904,0.982944,0,-23.3829,-23.1882,-10.7597,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-20 15:30:28.103','2023-07-20 13:30:28.828',NULL),('973f8e0a-2701-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/848c86d9-26fd-11ee-a98e-a0510b46b473/session_8f62cd50-26fd-11ee-a98e-a0510b46b473/occlusion_8f65e2e0-26fd-11ee-a98e-a0510b46b473/scan_32674cda-2701-11ee-a98e-a0510b46b473/973f8e0a-2701-11ee-a98e-a0510b46b473.png','PATIENT_848c86d9-26fd-11ee-a98e-a0510b46b473_ACT_8f62cd50-26fd-11ee-a98e-a0510b46b473_SESS_8f65e2e0-26fd-11ee-a98e-a0510b46b473_TOSC_32674cda-2701-11ee-a98e-a0510b46b473_SNAPS','973f8e0a-2701-11ee-a98e-a0510b46b473.png','973f8e0a-2701-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.36.1.1.9 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-20 15:30:28.103','2023-07-20 13:30:28.837',NULL),('9923bca2-10e4-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/2ff330cd-10e1-11ee-b636-a0510b46b473/session_68b68f8e-10e4-11ee-b636-a0510b46b473/occlusion_68b97a59-10e4-11ee-b636-a0510b46b473/scan_695dc75c-10e4-11ee-b636-a0510b46b473/9923bca2-10e4-11ee-b636-a0510b46b473.zip','PATIENT_2ff330cd-10e1-11ee-b636-a0510b46b473_ACT_68b68f8e-10e4-11ee-b636-a0510b46b473_SESS_68b97a59-10e4-11ee-b636-a0510b46b473_TOSC_695dc75c-10e4-11ee-b636-a0510b46b473_MODEL','9923bca2-10e4-11ee-b636-a0510b46b473.zip','9923bca2-10e4-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.18.2.1.1\",\"modelMatrix\":\"0.656455,0.698414,-0.285105,0,-0.754365,0.607766,-0.248101,0,-6.64524e-09,0.37794,0.92583,0,-28.9751,2.53837,-8.56637,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 12:07:30.290','2023-06-22 10:07:30.776',NULL),('9923d3bb-10e4-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/2ff330cd-10e1-11ee-b636-a0510b46b473/session_68b68f8e-10e4-11ee-b636-a0510b46b473/occlusion_68b97a59-10e4-11ee-b636-a0510b46b473/scan_695dc75c-10e4-11ee-b636-a0510b46b473/9923d3bb-10e4-11ee-b636-a0510b46b473.png','PATIENT_2ff330cd-10e1-11ee-b636-a0510b46b473_ACT_68b68f8e-10e4-11ee-b636-a0510b46b473_SESS_68b97a59-10e4-11ee-b636-a0510b46b473_TOSC_695dc75c-10e4-11ee-b636-a0510b46b473_SNAPS','9923d3bb-10e4-11ee-b636-a0510b46b473.png','9923d3bb-10e4-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.18.2.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 12:07:30.291','2023-06-22 10:07:30.777',NULL),('99594135-256f-11ee-91d6-a0510b46b473',11,'/home/scan/.data//2023/11/49f1e276-256f-11ee-91d6-a0510b46b473/session_5c74c40a-256f-11ee-91d6-a0510b46b473/occlusion_5c77122f-256f-11ee-91d6-a0510b46b473/scan_5df04335-256f-11ee-91d6-a0510b46b473/99594135-256f-11ee-91d6-a0510b46b473.zip','PATIENT_49f1e276-256f-11ee-91d6-a0510b46b473_ACT_5c74c40a-256f-11ee-91d6-a0510b46b473_SESS_5c77122f-256f-11ee-91d6-a0510b46b473_TOSC_5df04335-256f-11ee-91d6-a0510b46b473_MODEL','99594135-256f-11ee-91d6-a0510b46b473.zip','99594135-256f-11ee-91d6-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.33.1.1.1\",\"modelMatrix\":\"-0.829205,0.527409,-0.185091,0,-0.558944,-0.782422,0.274586,0,2.09115e-09,0.331144,0.94358,0,-9.89365,-1.51293,-31.3493,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,'2023-07-18 15:33:06.035','2023-07-18 15:32:53.942','2023-07-18 13:33:06.041',NULL),('99595a84-256f-11ee-91d6-a0510b46b473',11,'/home/scan/.data//2023/11/49f1e276-256f-11ee-91d6-a0510b46b473/session_5c74c40a-256f-11ee-91d6-a0510b46b473/occlusion_5c77122f-256f-11ee-91d6-a0510b46b473/scan_5df04335-256f-11ee-91d6-a0510b46b473/99595a84-256f-11ee-91d6-a0510b46b473.png','PATIENT_49f1e276-256f-11ee-91d6-a0510b46b473_ACT_5c74c40a-256f-11ee-91d6-a0510b46b473_SESS_5c77122f-256f-11ee-91d6-a0510b46b473_TOSC_5df04335-256f-11ee-91d6-a0510b46b473_SNAPS','99595a84-256f-11ee-91d6-a0510b46b473.png','99595a84-256f-11ee-91d6-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.33.1.1.1 Snapshot\"}','PNG',0,'CREATED',0,'2023-07-18 15:33:06.035','2023-07-18 15:32:53.943','2023-07-18 13:33:06.045',NULL),('99c11640-e040-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_261265bf-e03f-11ed-bb13-00d86184ce3d/occlusion_2615e3c8-e03f-11ed-bb13-00d86184ce3d/scan_3cbd6cf4-e040-11ed-bb13-00d86184ce3d/99c11640-e040-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_261265bf-e03f-11ed-bb13-00d86184ce3d_SESS_2615e3c8-e03f-11ed-bb13-00d86184ce3d_TOSC_3cbd6cf4-e040-11ed-bb13-00d86184ce3d_MODEL','99c11640-e040-11ed-bb13-00d86184ce3d.zip','99c11640-e040-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.4.1.4\",\"modelMatrix\":\"0.694358,0.67131,-0.25925,0,-0.71963,0.647734,-0.250146,0,-9.66573e-10,0.360255,0.932854,0,-28.8394,-10.1713,-5.18977,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 14:32:38.045','2023-04-21 12:32:38.991',NULL),('99c12e58-e040-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_261265bf-e03f-11ed-bb13-00d86184ce3d/occlusion_2615e3c8-e03f-11ed-bb13-00d86184ce3d/scan_3cbd6cf4-e040-11ed-bb13-00d86184ce3d/99c12e58-e040-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_261265bf-e03f-11ed-bb13-00d86184ce3d_SESS_2615e3c8-e03f-11ed-bb13-00d86184ce3d_TOSC_3cbd6cf4-e040-11ed-bb13-00d86184ce3d_SNAPS','99c12e58-e040-11ed-bb13-00d86184ce3d.png','99c12e58-e040-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.4.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 14:32:38.045','2023-04-21 12:32:38.991',NULL),('9a73ff50-14e4-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_efcc55aa-14e3-11ee-b3b1-00d86184ce3d/occlusion_efcf357e-14e3-11ee-b3b1-00d86184ce3d/scan_4582d779-14e4-11ee-b3b1-00d86184ce3d/9a73ff50-14e4-11ee-b3b1-00d86184ce3d.zip','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_efcc55aa-14e3-11ee-b3b1-00d86184ce3d_SESS_efcf357e-14e3-11ee-b3b1-00d86184ce3d_TOSC_4582d779-14e4-11ee-b3b1-00d86184ce3d_MODEL','9a73ff50-14e4-11ee-b3b1-00d86184ce3d.zip','9a73ff50-14e4-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.20.3.1.2\",\"modelMatrix\":\"0.65203,0.749491,-0.114546,0,-0.758193,0.644546,-0.0985072,0,5.18704e-09,0.151078,0.988522,0,-33.2003,-4.69077,-8.84299,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-27 14:17:37.145','2023-06-27 12:17:37.885',NULL),('9a741654-14e4-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_efcc55aa-14e3-11ee-b3b1-00d86184ce3d/occlusion_efcf357e-14e3-11ee-b3b1-00d86184ce3d/scan_4582d779-14e4-11ee-b3b1-00d86184ce3d/9a741654-14e4-11ee-b3b1-00d86184ce3d.png','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_efcc55aa-14e3-11ee-b3b1-00d86184ce3d_SESS_efcf357e-14e3-11ee-b3b1-00d86184ce3d_TOSC_4582d779-14e4-11ee-b3b1-00d86184ce3d_SNAPS','9a741654-14e4-11ee-b3b1-00d86184ce3d.png','9a741654-14e4-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.20.3.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-27 14:17:37.146','2023-06-27 12:17:37.886',NULL),('9a868ef7-1c08-11ee-a865-a0510b46b473',11,'/home/scan/.data//2023/11/ae8bd11e-1c05-11ee-9323-a0510b46b473/session_bb436bde-1c05-11ee-9323-a0510b46b473/occlusion_bb465a1e-1c05-11ee-9323-a0510b46b473/scan_47dc7833-1c08-11ee-a865-a0510b46b473/9a868ef7-1c08-11ee-a865-a0510b46b473.zip','PATIENT_ae8bd11e-1c05-11ee-9323-a0510b46b473_ACT_bb436bde-1c05-11ee-9323-a0510b46b473_SESS_bb465a1e-1c05-11ee-9323-a0510b46b473_TOSC_47dc7833-1c08-11ee-a865-a0510b46b473_MODEL','9a868ef7-1c08-11ee-a865-a0510b46b473.zip','9a868ef7-1c08-11ee-a865-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.29.1.1.7\",\"modelMatrix\":\"0.555199,0.805277,-0.208045,0,-0.831718,0.537549,-0.138877,0,-3.69045e-10,0.250139,0.96821,0,-28.2822,-11.4032,-8.93208,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 16:22:57.289','2023-07-06 14:22:58.091',NULL),('9a86a98e-1c08-11ee-a865-a0510b46b473',11,'/home/scan/.data//2023/11/ae8bd11e-1c05-11ee-9323-a0510b46b473/session_bb436bde-1c05-11ee-9323-a0510b46b473/occlusion_bb465a1e-1c05-11ee-9323-a0510b46b473/scan_47dc7833-1c08-11ee-a865-a0510b46b473/9a86a98e-1c08-11ee-a865-a0510b46b473.png','PATIENT_ae8bd11e-1c05-11ee-9323-a0510b46b473_ACT_bb436bde-1c05-11ee-9323-a0510b46b473_SESS_bb465a1e-1c05-11ee-9323-a0510b46b473_TOSC_47dc7833-1c08-11ee-a865-a0510b46b473_SNAPS','9a86a98e-1c08-11ee-a865-a0510b46b473.png','9a86a98e-1c08-11ee-a865-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.29.1.1.7 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 16:22:57.289','2023-07-06 14:22:58.092',NULL),('9a8e8716-2aeb-11ee-97fa-a0510b46b473',11,'/home/scan/.data//2023/11/4baca484-2aeb-11ee-97fa-a0510b46b473/session_4ff1c1c7-2aeb-11ee-97fa-a0510b46b473/occlusion_4ff4b712-2aeb-11ee-97fa-a0510b46b473/scan_50d73e18-2aeb-11ee-97fa-a0510b46b473/9a8e8716-2aeb-11ee-97fa-a0510b46b473.zip','PATIENT_4baca484-2aeb-11ee-97fa-a0510b46b473_ACT_4ff1c1c7-2aeb-11ee-97fa-a0510b46b473_SESS_4ff4b712-2aeb-11ee-97fa-a0510b46b473_TOSC_50d73e18-2aeb-11ee-97fa-a0510b46b473_MODEL','9a8e8716-2aeb-11ee-97fa-a0510b46b473.zip','9a8e8716-2aeb-11ee-97fa-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.37.1.1.1\",\"modelMatrix\":\"0.795726,0.560435,-0.229636,0,-0.605657,0.736313,-0.301702,0,3.09271e-09,0.379153,0.925334,0,-28.7597,-2.64931,-10.1717,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-25 15:03:09.377','2023-07-25 13:03:09.971',NULL),('9a8eaac2-2aeb-11ee-97fa-a0510b46b473',11,'/home/scan/.data//2023/11/4baca484-2aeb-11ee-97fa-a0510b46b473/session_4ff1c1c7-2aeb-11ee-97fa-a0510b46b473/occlusion_4ff4b712-2aeb-11ee-97fa-a0510b46b473/scan_50d73e18-2aeb-11ee-97fa-a0510b46b473/9a8eaac2-2aeb-11ee-97fa-a0510b46b473.png','PATIENT_4baca484-2aeb-11ee-97fa-a0510b46b473_ACT_4ff1c1c7-2aeb-11ee-97fa-a0510b46b473_SESS_4ff4b712-2aeb-11ee-97fa-a0510b46b473_TOSC_50d73e18-2aeb-11ee-97fa-a0510b46b473_SNAPS','9a8eaac2-2aeb-11ee-97fa-a0510b46b473.png','9a8eaac2-2aeb-11ee-97fa-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.37.1.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-25 15:03:09.378','2023-07-25 13:03:09.972',NULL),('9ab3442e-10e2-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/2ff330cd-10e1-11ee-b636-a0510b46b473/session_3adeac35-10e1-11ee-b636-a0510b46b473/occlusion_3ae23ec4-10e1-11ee-b636-a0510b46b473/scan_482a8087-10e2-11ee-b636-a0510b46b473/9ab3442e-10e2-11ee-b636-a0510b46b473.zip','PATIENT_2ff330cd-10e1-11ee-b636-a0510b46b473_ACT_3adeac35-10e1-11ee-b636-a0510b46b473_SESS_3ae23ec4-10e1-11ee-b636-a0510b46b473_TOSC_482a8087-10e2-11ee-b636-a0510b46b473_MODEL','9ab3442e-10e2-11ee-b636-a0510b46b473.zip','9ab3442e-10e2-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.18.1.1.4\",\"modelMatrix\":\"-0.0604216,0.987262,-0.147184,0,-0.998173,-0.0597611,0.00890934,0,5.29958e-11,0.147453,0.989069,0,-12.9887,-29.5578,-9.68122,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 11:53:13.915','2023-06-22 09:53:14.693',NULL),('9ab359c5-10e2-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/2ff330cd-10e1-11ee-b636-a0510b46b473/session_3adeac35-10e1-11ee-b636-a0510b46b473/occlusion_3ae23ec4-10e1-11ee-b636-a0510b46b473/scan_482a8087-10e2-11ee-b636-a0510b46b473/9ab359c5-10e2-11ee-b636-a0510b46b473.png','PATIENT_2ff330cd-10e1-11ee-b636-a0510b46b473_ACT_3adeac35-10e1-11ee-b636-a0510b46b473_SESS_3ae23ec4-10e1-11ee-b636-a0510b46b473_TOSC_482a8087-10e2-11ee-b636-a0510b46b473_SNAPS','9ab359c5-10e2-11ee-b636-a0510b46b473.png','9ab359c5-10e2-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.18.1.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 11:53:13.916','2023-06-22 09:53:14.694',NULL),('9b56721d-1bd1-11ee-9086-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_a6b1a4bd-1bcf-11ee-9086-a0510b46b473/occlusion_a6b491c8-1bcf-11ee-9086-a0510b46b473/scan_4816cca9-1bd1-11ee-9086-a0510b46b473/9b56721d-1bd1-11ee-9086-a0510b46b473.zip','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_a6b1a4bd-1bcf-11ee-9086-a0510b46b473_SESS_a6b491c8-1bcf-11ee-9086-a0510b46b473_TOSC_4816cca9-1bd1-11ee-9086-a0510b46b473_MODEL','9b56721d-1bd1-11ee-9086-a0510b46b473.zip','9b56721d-1bd1-11ee-9086-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.3.1.5\",\"modelMatrix\":\"-0.105274,0.974515,-0.198086,0,-0.994443,-0.103164,0.0209698,0,3.68055e-10,0.199193,0.97996,0,-17.2332,-20.3095,-9.19582,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 09:49:16.331','2023-07-06 07:49:17.339',NULL),('9b5689e5-1bd1-11ee-9086-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_a6b1a4bd-1bcf-11ee-9086-a0510b46b473/occlusion_a6b491c8-1bcf-11ee-9086-a0510b46b473/scan_4816cca9-1bd1-11ee-9086-a0510b46b473/9b5689e5-1bd1-11ee-9086-a0510b46b473.png','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_a6b1a4bd-1bcf-11ee-9086-a0510b46b473_SESS_a6b491c8-1bcf-11ee-9086-a0510b46b473_TOSC_4816cca9-1bd1-11ee-9086-a0510b46b473_SNAPS','9b5689e5-1bd1-11ee-9086-a0510b46b473.png','9b5689e5-1bd1-11ee-9086-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.3.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 09:49:16.331','2023-07-06 07:49:17.342',NULL),('9b955220-2578-11ee-b81b-a0510b46b473',11,'/home/scan/.data//2023/11/49f1e276-256f-11ee-91d6-a0510b46b473/session_f58279e9-2576-11ee-b81b-a0510b46b473/occlusion_f584e68a-2576-11ee-b81b-a0510b46b473/scan_76c59fd3-2578-11ee-b81b-a0510b46b473/9b955220-2578-11ee-b81b-a0510b46b473.zip','PATIENT_49f1e276-256f-11ee-91d6-a0510b46b473_ACT_f58279e9-2576-11ee-b81b-a0510b46b473_SESS_f584e68a-2576-11ee-b81b-a0510b46b473_TOSC_76c59fd3-2578-11ee-b81b-a0510b46b473_MODEL','9b955220-2578-11ee-b81b-a0510b46b473.zip','9b955220-2578-11ee-b81b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.33.2.1.4\",\"modelMatrix\":\"-0.980209,0.190195,-0.0549123,0,-0.197964,-0.941745,0.271896,0,3.68555e-10,0.277386,0.960759,0,59.5734,-12.5788,-26.6923,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-18 16:37:23.162','2023-07-18 14:37:23.350',NULL),('9b95688a-2578-11ee-b81b-a0510b46b473',11,'/home/scan/.data//2023/11/49f1e276-256f-11ee-91d6-a0510b46b473/session_f58279e9-2576-11ee-b81b-a0510b46b473/occlusion_f584e68a-2576-11ee-b81b-a0510b46b473/scan_76c59fd3-2578-11ee-b81b-a0510b46b473/9b95688a-2578-11ee-b81b-a0510b46b473.png','PATIENT_49f1e276-256f-11ee-91d6-a0510b46b473_ACT_f58279e9-2576-11ee-b81b-a0510b46b473_SESS_f584e68a-2576-11ee-b81b-a0510b46b473_TOSC_76c59fd3-2578-11ee-b81b-a0510b46b473_SNAPS','9b95688a-2578-11ee-b81b-a0510b46b473.png','9b95688a-2578-11ee-b81b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.33.2.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-18 16:37:23.162','2023-07-18 14:37:23.359',NULL),('9bd4e32e-e043-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_5a5a69f7-e042-11ed-bb13-00d86184ce3d/occlusion_5a5d89b2-e042-11ed-bb13-00d86184ce3d/scan_5533f819-e043-11ed-bb13-00d86184ce3d/9bd4e32e-e043-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_5a5a69f7-e042-11ed-bb13-00d86184ce3d_SESS_5a5d89b2-e042-11ed-bb13-00d86184ce3d_TOSC_5533f819-e043-11ed-bb13-00d86184ce3d_MODEL','9bd4e32e-e043-11ed-bb13-00d86184ce3d.zip','9bd4e32e-e043-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.5.1.3\",\"modelMatrix\":\"0.355927,0.815375,-0.456596,0,-0.934514,0.31055,-0.173903,0,-1.14854e-08,0.488592,0.872513,0,-26.5024,-13.205,-4.57497,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 14:54:10.020','2023-04-21 12:54:10.646',NULL),('9bd5000e-e043-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_5a5a69f7-e042-11ed-bb13-00d86184ce3d/occlusion_5a5d89b2-e042-11ed-bb13-00d86184ce3d/scan_5533f819-e043-11ed-bb13-00d86184ce3d/9bd5000e-e043-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_5a5a69f7-e042-11ed-bb13-00d86184ce3d_SESS_5a5d89b2-e042-11ed-bb13-00d86184ce3d_TOSC_5533f819-e043-11ed-bb13-00d86184ce3d_SNAPS','9bd5000e-e043-11ed-bb13-00d86184ce3d.png','9bd5000e-e043-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.5.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 14:54:10.021','2023-04-21 12:54:10.647',NULL),('9bd5930c-1c0a-11ee-a865-a0510b46b473',11,'/home/scan/.data//2023/11/ae8bd11e-1c05-11ee-9323-a0510b46b473/session_bab223ae-1c09-11ee-a865-a0510b46b473/occlusion_bab539ff-1c09-11ee-a865-a0510b46b473/scan_644096f1-1c0a-11ee-a865-a0510b46b473/9bd5930c-1c0a-11ee-a865-a0510b46b473.zip','PATIENT_ae8bd11e-1c05-11ee-9323-a0510b46b473_ACT_bab223ae-1c09-11ee-a865-a0510b46b473_SESS_bab539ff-1c09-11ee-a865-a0510b46b473_TOSC_644096f1-1c0a-11ee-a865-a0510b46b473_MODEL','9bd5930c-1c0a-11ee-a865-a0510b46b473.zip','9bd5930c-1c0a-11ee-a865-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.29.2.1.4\",\"modelMatrix\":\"0.902582,0.400401,-0.158194,0,-0.430519,0.83944,-0.331653,0,-1.00778e-08,0.367449,0.930044,0,-30.0454,11.3588,-7.20458,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 16:37:18.478','2023-07-06 14:37:19.006',NULL),('9bd6da98-1c0a-11ee-a865-a0510b46b473',11,'/home/scan/.data//2023/11/ae8bd11e-1c05-11ee-9323-a0510b46b473/session_bab223ae-1c09-11ee-a865-a0510b46b473/occlusion_bab539ff-1c09-11ee-a865-a0510b46b473/scan_644096f1-1c0a-11ee-a865-a0510b46b473/9bd6da98-1c0a-11ee-a865-a0510b46b473.png','PATIENT_ae8bd11e-1c05-11ee-9323-a0510b46b473_ACT_bab223ae-1c09-11ee-a865-a0510b46b473_SESS_bab539ff-1c09-11ee-a865-a0510b46b473_TOSC_644096f1-1c0a-11ee-a865-a0510b46b473_SNAPS','9bd6da98-1c0a-11ee-a865-a0510b46b473.png','9bd6da98-1c0a-11ee-a865-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.29.2.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 16:37:18.486','2023-07-06 14:37:19.006',NULL),('9c559382-1c07-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/ae8bd11e-1c05-11ee-9323-a0510b46b473/session_bb436bde-1c05-11ee-9323-a0510b46b473/occlusion_bb465a1e-1c05-11ee-9323-a0510b46b473/scan_3790bff2-1c07-11ee-9323-a0510b46b473/9c559382-1c07-11ee-9323-a0510b46b473.zip','PATIENT_ae8bd11e-1c05-11ee-9323-a0510b46b473_ACT_bb436bde-1c05-11ee-9323-a0510b46b473_SESS_bb465a1e-1c05-11ee-9323-a0510b46b473_TOSC_3790bff2-1c07-11ee-9323-a0510b46b473_MODEL','9c559382-1c07-11ee-9323-a0510b46b473.zip','9c559382-1c07-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.29.1.1.5\",\"modelMatrix\":\"0.144729,0.939964,-0.309066,0,-0.989471,0.137487,-0.0452067,0,2.38613e-09,0.312355,0.949965,0,-19.7171,-26.6231,-6.98481,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 16:15:50.826','2023-07-06 14:15:51.710',NULL),('9c55afa7-1c07-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/ae8bd11e-1c05-11ee-9323-a0510b46b473/session_bb436bde-1c05-11ee-9323-a0510b46b473/occlusion_bb465a1e-1c05-11ee-9323-a0510b46b473/scan_3790bff2-1c07-11ee-9323-a0510b46b473/9c55afa7-1c07-11ee-9323-a0510b46b473.png','PATIENT_ae8bd11e-1c05-11ee-9323-a0510b46b473_ACT_bb436bde-1c05-11ee-9323-a0510b46b473_SESS_bb465a1e-1c05-11ee-9323-a0510b46b473_TOSC_3790bff2-1c07-11ee-9323-a0510b46b473_SNAPS','9c55afa7-1c07-11ee-9323-a0510b46b473.png','9c55afa7-1c07-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.29.1.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 16:15:50.827','2023-07-06 14:15:51.714',NULL),('9c84d3e1-e34b-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/971e14b0-e348-11ed-8c5e-00d86184ce3d/session_d6f9d6f4-e34a-11ed-8c5e-00d86184ce3d/occlusion_d6fcc5ab-e34a-11ed-8c5e-00d86184ce3d/scan_5c533d2c-e34b-11ed-8c5e-00d86184ce3d/9c84d3e1-e34b-11ed-8c5e-00d86184ce3d.zip','PATIENT_971e14b0-e348-11ed-8c5e-00d86184ce3d_ACT_d6f9d6f4-e34a-11ed-8c5e-00d86184ce3d_SESS_d6fcc5ab-e34a-11ed-8c5e-00d86184ce3d_TOSC_5c533d2c-e34b-11ed-8c5e-00d86184ce3d_MODEL','9c84d3e1-e34b-11ed-8c5e-00d86184ce3d.zip','9c84d3e1-e34b-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.12.2.1.2\",\"modelMatrix\":\"0.63831,0.602139,-0.479571,0,-0.769779,0.499301,-0.397667,0,5.09905e-09,0.622999,0.782223,0,-29.6538,0.666472,-4.44578,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-25 11:29:00.635','2023-04-25 09:29:01.261',NULL),('9c854647-e34b-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/971e14b0-e348-11ed-8c5e-00d86184ce3d/session_d6f9d6f4-e34a-11ed-8c5e-00d86184ce3d/occlusion_d6fcc5ab-e34a-11ed-8c5e-00d86184ce3d/scan_5c533d2c-e34b-11ed-8c5e-00d86184ce3d/9c854647-e34b-11ed-8c5e-00d86184ce3d.png','PATIENT_971e14b0-e348-11ed-8c5e-00d86184ce3d_ACT_d6f9d6f4-e34a-11ed-8c5e-00d86184ce3d_SESS_d6fcc5ab-e34a-11ed-8c5e-00d86184ce3d_TOSC_5c533d2c-e34b-11ed-8c5e-00d86184ce3d_SNAPS','9c854647-e34b-11ed-8c5e-00d86184ce3d.png','9c854647-e34b-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.12.2.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-25 11:29:00.638','2023-04-25 09:29:01.262',NULL),('9c92597d-14cc-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/9619fcac-14c3-11ee-b3b1-00d86184ce3d/session_5f50caeb-14cc-11ee-b3b1-00d86184ce3d/occlusion_5f53d32e-14cc-11ee-b3b1-00d86184ce3d/scan_602f9914-14cc-11ee-b3b1-00d86184ce3d/9c92597d-14cc-11ee-b3b1-00d86184ce3d.zip','PATIENT_9619fcac-14c3-11ee-b3b1-00d86184ce3d_ACT_5f50caeb-14cc-11ee-b3b1-00d86184ce3d_SESS_5f53d32e-14cc-11ee-b3b1-00d86184ce3d_TOSC_602f9914-14cc-11ee-b3b1-00d86184ce3d_MODEL','9c92597d-14cc-11ee-b3b1-00d86184ce3d.zip','9c92597d-14cc-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.22.2.1.1\",\"modelMatrix\":\"0.920855,0.338481,-0.193538,0,-0.389905,0.799404,-0.457086,0,1.19655e-08,0.496371,0.868111,0,-29.0297,2.92313,-9.80125,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-27 11:25:52.778','2023-06-27 09:25:53.232',NULL),('9c927305-14cc-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/9619fcac-14c3-11ee-b3b1-00d86184ce3d/session_5f50caeb-14cc-11ee-b3b1-00d86184ce3d/occlusion_5f53d32e-14cc-11ee-b3b1-00d86184ce3d/scan_602f9914-14cc-11ee-b3b1-00d86184ce3d/9c927305-14cc-11ee-b3b1-00d86184ce3d.png','PATIENT_9619fcac-14c3-11ee-b3b1-00d86184ce3d_ACT_5f50caeb-14cc-11ee-b3b1-00d86184ce3d_SESS_5f53d32e-14cc-11ee-b3b1-00d86184ce3d_TOSC_602f9914-14cc-11ee-b3b1-00d86184ce3d_SNAPS','9c927305-14cc-11ee-b3b1-00d86184ce3d.png','9c927305-14cc-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.22.2.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-27 11:25:52.779','2023-06-27 09:25:53.233',NULL),('9d13a8e9-e02c-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_ed85304d-e024-11ed-bb13-00d86184ce3d/occlusion_ed88a64f-e024-11ed-bb13-00d86184ce3d/scan_77868fcd-e02c-11ed-bb13-00d86184ce3d/9d13a8e9-e02c-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_ed85304d-e024-11ed-bb13-00d86184ce3d_SESS_ed88a64f-e024-11ed-bb13-00d86184ce3d_TOSC_77868fcd-e02c-11ed-bb13-00d86184ce3d_MODEL','9d13a8e9-e02c-11ed-bb13-00d86184ce3d.zip','9d13a8e9-e02c-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.1.1.11\",\"modelMatrix\":\"0.687169,0.625532,-0.369471,0,-0.726498,0.591668,-0.34947,0,-1.45077e-09,0.508565,0.861024,0,-28.5119,-0.0509485,-9.21379,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 12:09:33.684','2023-04-21 10:09:34.226',NULL),('9d13c197-e02c-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_ed85304d-e024-11ed-bb13-00d86184ce3d/occlusion_ed88a64f-e024-11ed-bb13-00d86184ce3d/scan_77868fcd-e02c-11ed-bb13-00d86184ce3d/9d13c197-e02c-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_ed85304d-e024-11ed-bb13-00d86184ce3d_SESS_ed88a64f-e024-11ed-bb13-00d86184ce3d_TOSC_77868fcd-e02c-11ed-bb13-00d86184ce3d_SNAPS','9d13c197-e02c-11ed-bb13-00d86184ce3d.png','9d13c197-e02c-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.1.1.11 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 12:09:33.685','2023-04-21 10:09:34.227',NULL),('9d30b7d7-261f-11ee-8042-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_62519c59-261f-11ee-8042-a0510b46b473/occlusion_6253caa6-261f-11ee-8042-a0510b46b473/scan_63ff2cb1-261f-11ee-8042-a0510b46b473/9d30b7d7-261f-11ee-8042-a0510b46b473.zip','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_62519c59-261f-11ee-8042-a0510b46b473_SESS_6253caa6-261f-11ee-8042-a0510b46b473_TOSC_63ff2cb1-261f-11ee-8042-a0510b46b473_MODEL','9d30b7d7-261f-11ee-8042-a0510b46b473.zip','9d30b7d7-261f-11ee-8042-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.1.1.1\",\"modelMatrix\":\"0.433891,0.835661,-0.336764,0,-0.900966,0.402441,-0.16218,0,-7.20406e-10,0.373781,0.927517,0,-2.0553,-27.4012,-2.78642,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,'2023-07-19 12:33:11.621','2023-07-19 12:32:51.812','2023-07-19 10:33:11.626',NULL),('9d30d223-261f-11ee-8042-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_62519c59-261f-11ee-8042-a0510b46b473/occlusion_6253caa6-261f-11ee-8042-a0510b46b473/scan_63ff2cb1-261f-11ee-8042-a0510b46b473/9d30d223-261f-11ee-8042-a0510b46b473.png','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_62519c59-261f-11ee-8042-a0510b46b473_SESS_6253caa6-261f-11ee-8042-a0510b46b473_TOSC_63ff2cb1-261f-11ee-8042-a0510b46b473_SNAPS','9d30d223-261f-11ee-8042-a0510b46b473.png','9d30d223-261f-11ee-8042-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.1.1.1 Snapshot\"}','PNG',0,'CREATED',0,'2023-07-19 12:33:11.621','2023-07-19 12:32:51.812','2023-07-19 10:33:11.629',NULL),('9d4f6ef5-14cd-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/9619fcac-14c3-11ee-b3b1-00d86184ce3d/session_5f50caeb-14cc-11ee-b3b1-00d86184ce3d/occlusion_5f53d32e-14cc-11ee-b3b1-00d86184ce3d/scan_644b1c1f-14cd-11ee-b3b1-00d86184ce3d/9d4f6ef5-14cd-11ee-b3b1-00d86184ce3d.zip','PATIENT_9619fcac-14c3-11ee-b3b1-00d86184ce3d_ACT_5f50caeb-14cc-11ee-b3b1-00d86184ce3d_SESS_5f53d32e-14cc-11ee-b3b1-00d86184ce3d_TOSC_644b1c1f-14cd-11ee-b3b1-00d86184ce3d_MODEL','9d4f6ef5-14cd-11ee-b3b1-00d86184ce3d.zip','9d4f6ef5-14cd-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.22.2.1.3\",\"modelMatrix\":\"0.946862,0.308783,-0.0900244,0,-0.321639,0.909018,-0.26502,0,-3.81557e-09,0.279893,0.960031,0,-28.9714,5.75462,-10.2226,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-27 11:33:03.514','2023-06-27 09:33:05.222',NULL),('9d4f8460-14cd-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/9619fcac-14c3-11ee-b3b1-00d86184ce3d/session_5f50caeb-14cc-11ee-b3b1-00d86184ce3d/occlusion_5f53d32e-14cc-11ee-b3b1-00d86184ce3d/scan_644b1c1f-14cd-11ee-b3b1-00d86184ce3d/9d4f8460-14cd-11ee-b3b1-00d86184ce3d.png','PATIENT_9619fcac-14c3-11ee-b3b1-00d86184ce3d_ACT_5f50caeb-14cc-11ee-b3b1-00d86184ce3d_SESS_5f53d32e-14cc-11ee-b3b1-00d86184ce3d_TOSC_644b1c1f-14cd-11ee-b3b1-00d86184ce3d_SNAPS','9d4f8460-14cd-11ee-b3b1-00d86184ce3d.png','9d4f8460-14cd-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.22.2.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-27 11:33:03.514','2023-06-27 09:33:05.222',NULL),('9f18069a-26e1-11ee-a836-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_78d129fc-26e0-11ee-a836-a0510b46b473/occlusion_78d4144f-26e0-11ee-a836-a0510b46b473/scan_4bb8140e-26e1-11ee-a836-a0510b46b473/9f18069a-26e1-11ee-a836-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_78d129fc-26e0-11ee-a836-a0510b46b473_SESS_78d4144f-26e0-11ee-a836-a0510b46b473_TOSC_4bb8140e-26e1-11ee-a836-a0510b46b473_MODEL','9f18069a-26e1-11ee-a836-a0510b46b473.zip','9f18069a-26e1-11ee-a836-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.4.1.3\",\"modelMatrix\":\"0.489963,0.857268,-0.158203,0,-0.871743,0.481827,-0.0889177,0,-8.39998e-10,0.181479,0.983395,0,-28.4109,-16.29,-9.65663,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-20 11:41:37.371','2023-07-20 09:41:38.102',NULL),('9f194de5-26e1-11ee-a836-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_78d129fc-26e0-11ee-a836-a0510b46b473/occlusion_78d4144f-26e0-11ee-a836-a0510b46b473/scan_4bb8140e-26e1-11ee-a836-a0510b46b473/9f194de5-26e1-11ee-a836-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_78d129fc-26e0-11ee-a836-a0510b46b473_SESS_78d4144f-26e0-11ee-a836-a0510b46b473_TOSC_4bb8140e-26e1-11ee-a836-a0510b46b473_SNAPS','9f194de5-26e1-11ee-a836-a0510b46b473.png','9f194de5-26e1-11ee-a836-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.4.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-20 11:41:37.379','2023-07-20 09:41:38.102',NULL),('9fa0ca72-1c09-11ee-a865-a0510b46b473',11,'/home/scan/.data//2023/11/ae8bd11e-1c05-11ee-9323-a0510b46b473/session_bb436bde-1c05-11ee-9323-a0510b46b473/occlusion_bb465a1e-1c05-11ee-9323-a0510b46b473/scan_47f46fd5-1c09-11ee-a865-a0510b46b473/9fa0ca72-1c09-11ee-a865-a0510b46b473.zip','PATIENT_ae8bd11e-1c05-11ee-9323-a0510b46b473_ACT_bb436bde-1c05-11ee-9323-a0510b46b473_SESS_bb465a1e-1c05-11ee-9323-a0510b46b473_TOSC_47f46fd5-1c09-11ee-a865-a0510b46b473_MODEL','9fa0ca72-1c09-11ee-a865-a0510b46b473.zip','9fa0ca72-1c09-11ee-a865-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.29.1.1.10\",\"modelMatrix\":\"0.243425,0.931228,-0.271218,0,-0.96992,0.233714,-0.0680687,0,-8.75211e-12,0.279629,0.960108,0,-28.6312,-18.9931,-7.24988,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 16:30:15.346','2023-07-06 14:30:16.199',NULL),('9fa0de6f-1c09-11ee-a865-a0510b46b473',11,'/home/scan/.data//2023/11/ae8bd11e-1c05-11ee-9323-a0510b46b473/session_bb436bde-1c05-11ee-9323-a0510b46b473/occlusion_bb465a1e-1c05-11ee-9323-a0510b46b473/scan_47f46fd5-1c09-11ee-a865-a0510b46b473/9fa0de6f-1c09-11ee-a865-a0510b46b473.png','PATIENT_ae8bd11e-1c05-11ee-9323-a0510b46b473_ACT_bb436bde-1c05-11ee-9323-a0510b46b473_SESS_bb465a1e-1c05-11ee-9323-a0510b46b473_TOSC_47f46fd5-1c09-11ee-a865-a0510b46b473_SNAPS','9fa0de6f-1c09-11ee-a865-a0510b46b473.png','9fa0de6f-1c09-11ee-a865-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.29.1.1.10 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 16:30:15.346','2023-07-06 14:30:16.199',NULL),('a0c5dbd4-1a61-11ee-9a4f-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_56e1eee3-1a49-11ee-9a4f-a0510b46b473/occlusion_56e449e9-1a49-11ee-9a4f-a0510b46b473/scan_41ffc1c9-1a61-11ee-9a4f-a0510b46b473/a0c5dbd4-1a61-11ee-9a4f-a0510b46b473.zip','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_56e1eee3-1a49-11ee-9a4f-a0510b46b473_SESS_56e449e9-1a49-11ee-9a4f-a0510b46b473_TOSC_41ffc1c9-1a61-11ee-9a4f-a0510b46b473_MODEL','a0c5dbd4-1a61-11ee-9a4f-a0510b46b473.zip','a0c5dbd4-1a61-11ee-9a4f-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.1.1.5\",\"modelMatrix\":\"0.838225,0.53609,-0.0999311,0,-0.545325,0.824031,-0.153605,0,6.56699e-09,0.183251,0.983066,0,-33.9732,5.64649,-10.7306,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-04 13:55:10.653','2023-07-04 11:55:11.451',NULL),('a0c5f12b-1a61-11ee-9a4f-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_56e1eee3-1a49-11ee-9a4f-a0510b46b473/occlusion_56e449e9-1a49-11ee-9a4f-a0510b46b473/scan_41ffc1c9-1a61-11ee-9a4f-a0510b46b473/a0c5f12b-1a61-11ee-9a4f-a0510b46b473.png','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_56e1eee3-1a49-11ee-9a4f-a0510b46b473_SESS_56e449e9-1a49-11ee-9a4f-a0510b46b473_TOSC_41ffc1c9-1a61-11ee-9a4f-a0510b46b473_SNAPS','a0c5f12b-1a61-11ee-9a4f-a0510b46b473.png','a0c5f12b-1a61-11ee-9a4f-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.1.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-04 13:55:10.654','2023-07-04 11:55:11.452',NULL),('a0c74bb9-1ca8-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_08b47e37-1ca8-11ee-997b-a0510b46b473/occlusion_08b766f9-1ca8-11ee-997b-a0510b46b473/scan_73724c33-1ca8-11ee-997b-a0510b46b473/a0c74bb9-1ca8-11ee-997b-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_08b47e37-1ca8-11ee-997b-a0510b46b473_SESS_08b766f9-1ca8-11ee-997b-a0510b46b473_TOSC_73724c33-1ca8-11ee-997b-a0510b46b473_MODEL','a0c74bb9-1ca8-11ee-997b-a0510b46b473.zip','a0c74bb9-1ca8-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.2.1.3\",\"modelMatrix\":\"0.705804,0.60273,-0.372234,0,-0.708407,0.600515,-0.370866,0,8.4068e-09,0.525451,0.850824,0,-28.3287,6.76657,-8.07281,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-07 11:28:27.256','2023-07-07 09:28:27.674',NULL),('a0c763a8-1ca8-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_08b47e37-1ca8-11ee-997b-a0510b46b473/occlusion_08b766f9-1ca8-11ee-997b-a0510b46b473/scan_73724c33-1ca8-11ee-997b-a0510b46b473/a0c763a8-1ca8-11ee-997b-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_08b47e37-1ca8-11ee-997b-a0510b46b473_SESS_08b766f9-1ca8-11ee-997b-a0510b46b473_TOSC_73724c33-1ca8-11ee-997b-a0510b46b473_SNAPS','a0c763a8-1ca8-11ee-997b-a0510b46b473.png','a0c763a8-1ca8-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.2.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-07 11:28:27.256','2023-07-07 09:28:27.674',NULL),('a1927885-2570-11ee-91d6-a0510b46b473',11,'/home/scan/.data//2023/11/49f1e276-256f-11ee-91d6-a0510b46b473/session_5c74c40a-256f-11ee-91d6-a0510b46b473/occlusion_5c77122f-256f-11ee-91d6-a0510b46b473/scan_14e08c2e-2570-11ee-91d6-a0510b46b473/a1927885-2570-11ee-91d6-a0510b46b473.zip','PATIENT_49f1e276-256f-11ee-91d6-a0510b46b473_ACT_5c74c40a-256f-11ee-91d6-a0510b46b473_SESS_5c77122f-256f-11ee-91d6-a0510b46b473_TOSC_14e08c2e-2570-11ee-91d6-a0510b46b473_MODEL','a1927885-2570-11ee-91d6-a0510b46b473.zip','a1927885-2570-11ee-91d6-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.33.1.1.3\",\"modelMatrix\":\"-0.69418,0.712934,-0.0991958,0,-0.719802,-0.687557,0.0956649,0,-6.90015e-09,0.13781,0.990459,0,6.95201,-33.146,-10.3964,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-18 15:40:17.236','2023-07-18 13:40:17.995',NULL),('a1928c3a-2570-11ee-91d6-a0510b46b473',11,'/home/scan/.data//2023/11/49f1e276-256f-11ee-91d6-a0510b46b473/session_5c74c40a-256f-11ee-91d6-a0510b46b473/occlusion_5c77122f-256f-11ee-91d6-a0510b46b473/scan_14e08c2e-2570-11ee-91d6-a0510b46b473/a1928c3a-2570-11ee-91d6-a0510b46b473.png','PATIENT_49f1e276-256f-11ee-91d6-a0510b46b473_ACT_5c74c40a-256f-11ee-91d6-a0510b46b473_SESS_5c77122f-256f-11ee-91d6-a0510b46b473_TOSC_14e08c2e-2570-11ee-91d6-a0510b46b473_SNAPS','a1928c3a-2570-11ee-91d6-a0510b46b473.png','a1928c3a-2570-11ee-91d6-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.33.1.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-18 15:40:17.236','2023-07-18 13:40:17.998',NULL),('a1c962eb-26f6-11ee-aa9d-a0510b46b473',11,'/home/scan/.data//2023/11/c69c4cec-26f5-11ee-aa9d-a0510b46b473/session_cf31a6d6-26f5-11ee-aa9d-a0510b46b473/occlusion_cf34c227-26f5-11ee-aa9d-a0510b46b473/scan_5ae77078-26f6-11ee-aa9d-a0510b46b473/a1c962eb-26f6-11ee-aa9d-a0510b46b473.zip','PATIENT_c69c4cec-26f5-11ee-aa9d-a0510b46b473_ACT_cf31a6d6-26f5-11ee-aa9d-a0510b46b473_SESS_cf34c227-26f5-11ee-aa9d-a0510b46b473_TOSC_5ae77078-26f6-11ee-aa9d-a0510b46b473_MODEL','a1c962eb-26f6-11ee-aa9d-a0510b46b473.zip','a1c962eb-26f6-11ee-aa9d-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.35.1.1.2\",\"modelMatrix\":\"0.248209,-0.968704,0.00212836,0,0.968706,0.248209,-0.000545343,0,-1.77375e-12,0.00219711,0.999998,0,14.3546,20.4452,-13.7895,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-20 14:12:01.320','2023-07-20 12:12:01.972',NULL),('a1c977ec-26f6-11ee-aa9d-a0510b46b473',11,'/home/scan/.data//2023/11/c69c4cec-26f5-11ee-aa9d-a0510b46b473/session_cf31a6d6-26f5-11ee-aa9d-a0510b46b473/occlusion_cf34c227-26f5-11ee-aa9d-a0510b46b473/scan_5ae77078-26f6-11ee-aa9d-a0510b46b473/a1c977ec-26f6-11ee-aa9d-a0510b46b473.png','PATIENT_c69c4cec-26f5-11ee-aa9d-a0510b46b473_ACT_cf31a6d6-26f5-11ee-aa9d-a0510b46b473_SESS_cf34c227-26f5-11ee-aa9d-a0510b46b473_TOSC_5ae77078-26f6-11ee-aa9d-a0510b46b473_SNAPS','a1c977ec-26f6-11ee-aa9d-a0510b46b473.png','a1c977ec-26f6-11ee-aa9d-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.35.1.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-20 14:12:01.321','2023-07-20 12:12:01.982',NULL),('a1e35620-1bfd-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/8a8cc548-1bf9-11ee-9323-a0510b46b473/session_976f015a-1bf9-11ee-9323-a0510b46b473/occlusion_97713d19-1bf9-11ee-9323-a0510b46b473/scan_47c015dc-1bfd-11ee-9323-a0510b46b473/a1e35620-1bfd-11ee-9323-a0510b46b473.zip','PATIENT_8a8cc548-1bf9-11ee-9323-a0510b46b473_ACT_976f015a-1bf9-11ee-9323-a0510b46b473_SESS_97713d19-1bf9-11ee-9323-a0510b46b473_TOSC_47c015dc-1bfd-11ee-9323-a0510b46b473_MODEL','a1e35620-1bfd-11ee-9323-a0510b46b473.zip','a1e35620-1bfd-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.28.1.1.6\",\"modelMatrix\":\"-0.59257,0.786544,-0.173808,0,-0.805519,-0.578612,0.12786,0,-7.64761e-09,0.215772,0.976444,0,0.225198,-33.2651,-8.46632,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 15:04:25.177','2023-07-06 13:04:25.949',NULL),('a1e36f88-1bfd-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/8a8cc548-1bf9-11ee-9323-a0510b46b473/session_976f015a-1bf9-11ee-9323-a0510b46b473/occlusion_97713d19-1bf9-11ee-9323-a0510b46b473/scan_47c015dc-1bfd-11ee-9323-a0510b46b473/a1e36f88-1bfd-11ee-9323-a0510b46b473.png','PATIENT_8a8cc548-1bf9-11ee-9323-a0510b46b473_ACT_976f015a-1bf9-11ee-9323-a0510b46b473_SESS_97713d19-1bf9-11ee-9323-a0510b46b473_TOSC_47c015dc-1bfd-11ee-9323-a0510b46b473_SNAPS','a1e36f88-1bfd-11ee-9323-a0510b46b473.png','a1e36f88-1bfd-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.28.1.1.6 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 15:04:25.177','2023-07-06 13:04:25.950',NULL),('a27b7e96-10f9-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/ed94fe78-10f4-11ee-b636-a0510b46b473/session_f8ef8fe7-10f4-11ee-b636-a0510b46b473/occlusion_f8f2e241-10f4-11ee-b636-a0510b46b473/scan_4891c8ec-10f9-11ee-b636-a0510b46b473/a27b7e96-10f9-11ee-b636-a0510b46b473.zip','PATIENT_ed94fe78-10f4-11ee-b636-a0510b46b473_ACT_f8ef8fe7-10f4-11ee-b636-a0510b46b473_SESS_f8f2e241-10f4-11ee-b636-a0510b46b473_TOSC_4891c8ec-10f9-11ee-b636-a0510b46b473_MODEL','a27b7e96-10f9-11ee-b636-a0510b46b473.zip','a27b7e96-10f9-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.19.1.1.3\",\"modelMatrix\":\"0.563724,0.804277,-0.188025,0,-0.825963,0.548923,-0.128328,0,1.13184e-08,0.227644,0.973745,0,-31.0969,-15.3389,-9.72359,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 14:38:05.396','2023-06-22 12:38:06.182',NULL),('a27cbd46-10f9-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/ed94fe78-10f4-11ee-b636-a0510b46b473/session_f8ef8fe7-10f4-11ee-b636-a0510b46b473/occlusion_f8f2e241-10f4-11ee-b636-a0510b46b473/scan_4891c8ec-10f9-11ee-b636-a0510b46b473/a27cbd46-10f9-11ee-b636-a0510b46b473.png','PATIENT_ed94fe78-10f4-11ee-b636-a0510b46b473_ACT_f8ef8fe7-10f4-11ee-b636-a0510b46b473_SESS_f8f2e241-10f4-11ee-b636-a0510b46b473_TOSC_4891c8ec-10f9-11ee-b636-a0510b46b473_SNAPS','a27cbd46-10f9-11ee-b636-a0510b46b473.png','a27cbd46-10f9-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.19.1.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 14:38:05.404','2023-06-22 12:38:06.183',NULL),('a37aae81-2ac5-11ee-80c8-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_3a881645-2abf-11ee-80c8-a0510b46b473/occlusion_3a8b3537-2abf-11ee-80c8-a0510b46b473/scan_67550aab-2ac5-11ee-80c8-a0510b46b473/a37aae81-2ac5-11ee-80c8-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_3a881645-2abf-11ee-80c8-a0510b46b473_SESS_3a8b3537-2abf-11ee-80c8-a0510b46b473_TOSC_67550aab-2ac5-11ee-80c8-a0510b46b473_MODEL','a37aae81-2ac5-11ee-80c8-a0510b46b473.zip','a37aae81-2ac5-11ee-80c8-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.7.1.15\",\"modelMatrix\":\"0.781065,0.600663,-0.17071,0,-0.62445,0.751312,-0.213525,0,-2.01388e-09,0.273377,0.961907,0,-30.8842,-5.5083,-7.88408,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-25 10:31:23.471','2023-07-25 08:31:23.939',NULL),('a37bf310-2ac5-11ee-80c8-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_3a881645-2abf-11ee-80c8-a0510b46b473/occlusion_3a8b3537-2abf-11ee-80c8-a0510b46b473/scan_67550aab-2ac5-11ee-80c8-a0510b46b473/a37bf310-2ac5-11ee-80c8-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_3a881645-2abf-11ee-80c8-a0510b46b473_SESS_3a8b3537-2abf-11ee-80c8-a0510b46b473_TOSC_67550aab-2ac5-11ee-80c8-a0510b46b473_SNAPS','a37bf310-2ac5-11ee-80c8-a0510b46b473.png','a37bf310-2ac5-11ee-80c8-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.7.1.15 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-25 10:31:23.479','2023-07-25 08:31:23.939',NULL),('a43627fc-2621-11ee-8042-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_62519c59-261f-11ee-8042-a0510b46b473/occlusion_6253caa6-261f-11ee-8042-a0510b46b473/scan_41937fc5-2621-11ee-8042-a0510b46b473/a43627fc-2621-11ee-8042-a0510b46b473.zip','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_62519c59-261f-11ee-8042-a0510b46b473_SESS_6253caa6-261f-11ee-8042-a0510b46b473_TOSC_41937fc5-2621-11ee-8042-a0510b46b473_MODEL','a43627fc-2621-11ee-8042-a0510b46b473.zip','a43627fc-2621-11ee-8042-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.1.1.4\",\"modelMatrix\":\"-0.817919,0.574555,-0.0298987,0,-0.575333,-0.816814,0.0425054,0,4.59883e-10,0.0519677,0.998649,0,10.8176,-27.8121,-12.2439,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-19 12:47:22.585','2023-07-19 10:47:23.298',NULL),('a437661c-2621-11ee-8042-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_62519c59-261f-11ee-8042-a0510b46b473/occlusion_6253caa6-261f-11ee-8042-a0510b46b473/scan_41937fc5-2621-11ee-8042-a0510b46b473/a437661c-2621-11ee-8042-a0510b46b473.png','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_62519c59-261f-11ee-8042-a0510b46b473_SESS_6253caa6-261f-11ee-8042-a0510b46b473_TOSC_41937fc5-2621-11ee-8042-a0510b46b473_SNAPS','a437661c-2621-11ee-8042-a0510b46b473.png','a437661c-2621-11ee-8042-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.1.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-19 12:47:22.593','2023-07-19 10:47:23.299',NULL),('a4631bd0-15b7-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/142e7037-15b6-11ee-b3b1-00d86184ce3d/session_1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d/occlusion_1ed7780a-15b6-11ee-b3b1-00d86184ce3d/scan_4d7b2f1f-15b7-11ee-b3b1-00d86184ce3d/a4631bd0-15b7-11ee-b3b1-00d86184ce3d.zip','PATIENT_142e7037-15b6-11ee-b3b1-00d86184ce3d_ACT_1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d_SESS_1ed7780a-15b6-11ee-b3b1-00d86184ce3d_TOSC_4d7b2f1f-15b7-11ee-b3b1-00d86184ce3d_MODEL','a4631bd0-15b7-11ee-b3b1-00d86184ce3d.zip','a4631bd0-15b7-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.25.1.1.4\",\"modelMatrix\":\"0.441686,0.880738,-0.17092,0,-0.89717,0.433596,-0.0841457,0,-1.05383e-09,0.190511,0.981685,0,-28.8381,-14.2295,-9.99185,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-28 15:28:17.622','2023-06-28 13:28:18.439',NULL),('a4639962-15b7-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/142e7037-15b6-11ee-b3b1-00d86184ce3d/session_1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d/occlusion_1ed7780a-15b6-11ee-b3b1-00d86184ce3d/scan_4d7b2f1f-15b7-11ee-b3b1-00d86184ce3d/a4639962-15b7-11ee-b3b1-00d86184ce3d.png','PATIENT_142e7037-15b6-11ee-b3b1-00d86184ce3d_ACT_1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d_SESS_1ed7780a-15b6-11ee-b3b1-00d86184ce3d_TOSC_4d7b2f1f-15b7-11ee-b3b1-00d86184ce3d_SNAPS','a4639962-15b7-11ee-b3b1-00d86184ce3d.png','a4639962-15b7-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.25.1.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-28 15:28:17.625','2023-06-28 13:28:18.440',NULL),('a4f7b2ea-0f77-11ee-9460-a0510b46b473',11,'/home/scan/.data//2023/11/e4b67639-0f72-11ee-8712-a0510b46b473/session_ec7935d6-0f72-11ee-8712-a0510b46b473/occlusion_ec7bd8ad-0f72-11ee-8712-a0510b46b473/scan_3fe37f21-0f77-11ee-9460-a0510b46b473/a4f7b2ea-0f77-11ee-9460-a0510b46b473.zip','PATIENT_e4b67639-0f72-11ee-8712-a0510b46b473_ACT_ec7935d6-0f72-11ee-8712-a0510b46b473_SESS_ec7bd8ad-0f72-11ee-8712-a0510b46b473_TOSC_3fe37f21-0f77-11ee-9460-a0510b46b473_MODEL','a4f7b2ea-0f77-11ee-9460-a0510b46b473.zip','a4f7b2ea-0f77-11ee-9460-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.15.1.1.4\",\"modelMatrix\":\"-0.228418,0.894834,-0.383532,0,-0.973563,-0.209947,0.0899846,0,6.14362e-09,0.393947,0.919133,0,2.68072,-54.7363,-0.6216,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-20 16:35:03.828','2023-06-20 14:35:04.546',NULL),('a4f7e9f0-0f77-11ee-9460-a0510b46b473',11,'/home/scan/.data//2023/11/e4b67639-0f72-11ee-8712-a0510b46b473/session_ec7935d6-0f72-11ee-8712-a0510b46b473/occlusion_ec7bd8ad-0f72-11ee-8712-a0510b46b473/scan_3fe37f21-0f77-11ee-9460-a0510b46b473/a4f7e9f0-0f77-11ee-9460-a0510b46b473.png','PATIENT_e4b67639-0f72-11ee-8712-a0510b46b473_ACT_ec7935d6-0f72-11ee-8712-a0510b46b473_SESS_ec7bd8ad-0f72-11ee-8712-a0510b46b473_TOSC_3fe37f21-0f77-11ee-9460-a0510b46b473_SNAPS','a4f7e9f0-0f77-11ee-9460-a0510b46b473.png','a4f7e9f0-0f77-11ee-9460-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.15.1.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-20 16:35:03.830','2023-06-20 14:35:04.546',NULL),('a577b9b0-e356-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_853ebc79-e33f-11ed-8c5e-00d86184ce3d/occlusion_8541c500-e33f-11ed-8c5e-00d86184ce3d/scan_75255547-e356-11ed-8c5e-00d86184ce3d/a577b9b0-e356-11ed-8c5e-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_853ebc79-e33f-11ed-8c5e-00d86184ce3d_SESS_8541c500-e33f-11ed-8c5e-00d86184ce3d_TOSC_75255547-e356-11ed-8c5e-00d86184ce3d_MODEL','a577b9b0-e356-11ed-8c5e-00d86184ce3d.zip','a577b9b0-e356-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.6.1.12\",\"modelMatrix\":\"0.468987,0.767384,-0.437234,0,-0.883205,0.407485,-0.232173,0,1.05718e-09,0.495053,0.868863,0,-29.5495,-8.99251,-4.2198,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-25 12:48:00.114','2023-04-25 10:48:00.652',NULL),('a5784c50-e356-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_853ebc79-e33f-11ed-8c5e-00d86184ce3d/occlusion_8541c500-e33f-11ed-8c5e-00d86184ce3d/scan_75255547-e356-11ed-8c5e-00d86184ce3d/a5784c50-e356-11ed-8c5e-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_853ebc79-e33f-11ed-8c5e-00d86184ce3d_SESS_8541c500-e33f-11ed-8c5e-00d86184ce3d_TOSC_75255547-e356-11ed-8c5e-00d86184ce3d_SNAPS','a5784c50-e356-11ed-8c5e-00d86184ce3d.png','a5784c50-e356-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.6.1.12 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-25 12:48:00.117','2023-04-25 10:48:00.652',NULL),('a5834a4a-0f78-11ee-9460-a0510b46b473',11,'/home/scan/.data//2023/11/e4b67639-0f72-11ee-8712-a0510b46b473/session_ec7935d6-0f72-11ee-8712-a0510b46b473/occlusion_ec7bd8ad-0f72-11ee-8712-a0510b46b473/scan_2da926ce-0f78-11ee-9460-a0510b46b473/a5834a4a-0f78-11ee-9460-a0510b46b473.zip','PATIENT_e4b67639-0f72-11ee-8712-a0510b46b473_ACT_ec7935d6-0f72-11ee-8712-a0510b46b473_SESS_ec7bd8ad-0f72-11ee-8712-a0510b46b473_TOSC_2da926ce-0f78-11ee-9460-a0510b46b473_MODEL','a5834a4a-0f78-11ee-9460-a0510b46b473.zip','a5834a4a-0f78-11ee-9460-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.15.1.1.6\",\"modelMatrix\":\"0.834849,0.531177,-0.14449,0,-0.550479,0.805577,-0.219131,0,1.31699e-08,0.26248,0.964937,0,-30.395,-0.712483,-10.4147,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-20 16:42:14.240','2023-06-20 14:42:15.219',NULL),('a5836133-0f78-11ee-9460-a0510b46b473',11,'/home/scan/.data//2023/11/e4b67639-0f72-11ee-8712-a0510b46b473/session_ec7935d6-0f72-11ee-8712-a0510b46b473/occlusion_ec7bd8ad-0f72-11ee-8712-a0510b46b473/scan_2da926ce-0f78-11ee-9460-a0510b46b473/a5836133-0f78-11ee-9460-a0510b46b473.png','PATIENT_e4b67639-0f72-11ee-8712-a0510b46b473_ACT_ec7935d6-0f72-11ee-8712-a0510b46b473_SESS_ec7bd8ad-0f72-11ee-8712-a0510b46b473_TOSC_2da926ce-0f78-11ee-9460-a0510b46b473_SNAPS','a5836133-0f78-11ee-9460-a0510b46b473.png','a5836133-0f78-11ee-9460-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.15.1.1.6 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-20 16:42:14.240','2023-06-20 14:42:15.220',NULL),('a5920510-e042-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_5a5a69f7-e042-11ed-bb13-00d86184ce3d/occlusion_5a5d89b2-e042-11ed-bb13-00d86184ce3d/scan_5b28b216-e042-11ed-bb13-00d86184ce3d/a5920510-e042-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_5a5a69f7-e042-11ed-bb13-00d86184ce3d_SESS_5a5d89b2-e042-11ed-bb13-00d86184ce3d_TOSC_5b28b216-e042-11ed-bb13-00d86184ce3d_MODEL','a5920510-e042-11ed-bb13-00d86184ce3d.zip','a5920510-e042-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.5.1.1\",\"modelMatrix\":\"0.165645,0.926535,-0.33778,0,-0.986186,0.155626,-0.0567355,0,7.13908e-09,0.342512,0.939514,0,-27.9356,-15.897,-5.0264,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 14:47:16.862','2023-04-21 12:47:17.474',NULL),('a59216eb-e042-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_5a5a69f7-e042-11ed-bb13-00d86184ce3d/occlusion_5a5d89b2-e042-11ed-bb13-00d86184ce3d/scan_5b28b216-e042-11ed-bb13-00d86184ce3d/a59216eb-e042-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_5a5a69f7-e042-11ed-bb13-00d86184ce3d_SESS_5a5d89b2-e042-11ed-bb13-00d86184ce3d_TOSC_5b28b216-e042-11ed-bb13-00d86184ce3d_SNAPS','a59216eb-e042-11ed-bb13-00d86184ce3d.png','a59216eb-e042-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.5.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 14:47:16.863','2023-04-21 12:47:17.475',NULL),('a606ad5d-1a60-11ee-9a4f-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_56e1eee3-1a49-11ee-9a4f-a0510b46b473/occlusion_56e449e9-1a49-11ee-9a4f-a0510b46b473/scan_5eb8cdd7-1a60-11ee-9a4f-a0510b46b473/a606ad5d-1a60-11ee-9a4f-a0510b46b473.zip','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_56e1eee3-1a49-11ee-9a4f-a0510b46b473_SESS_56e449e9-1a49-11ee-9a4f-a0510b46b473_TOSC_5eb8cdd7-1a60-11ee-9a4f-a0510b46b473_MODEL','a606ad5d-1a60-11ee-9a4f-a0510b46b473.zip','a606ad5d-1a60-11ee-9a4f-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.1.1.3\",\"modelMatrix\":\"-0.855108,0.501498,-0.131492,0,-0.51845,-0.827148,0.216877,0,-5.90324e-09,0.253626,0.967302,0,5.47503,-31.5441,-8.17171,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-04 13:48:09.970','2023-07-04 11:48:10.650',NULL),('a607d2a3-1a60-11ee-9a4f-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_56e1eee3-1a49-11ee-9a4f-a0510b46b473/occlusion_56e449e9-1a49-11ee-9a4f-a0510b46b473/scan_5eb8cdd7-1a60-11ee-9a4f-a0510b46b473/a607d2a3-1a60-11ee-9a4f-a0510b46b473.png','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_56e1eee3-1a49-11ee-9a4f-a0510b46b473_SESS_56e449e9-1a49-11ee-9a4f-a0510b46b473_TOSC_5eb8cdd7-1a60-11ee-9a4f-a0510b46b473_SNAPS','a607d2a3-1a60-11ee-9a4f-a0510b46b473.png','a607d2a3-1a60-11ee-9a4f-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.1.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-04 13:48:09.977','2023-07-04 11:48:10.650',NULL),('a74f3159-e349-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/971e14b0-e348-11ed-8c5e-00d86184ce3d/session_a0fbda94-e348-11ed-8c5e-00d86184ce3d/occlusion_a0febadb-e348-11ed-8c5e-00d86184ce3d/scan_5749fe3e-e349-11ed-8c5e-00d86184ce3d/a74f3159-e349-11ed-8c5e-00d86184ce3d.zip','PATIENT_971e14b0-e348-11ed-8c5e-00d86184ce3d_ACT_a0fbda94-e348-11ed-8c5e-00d86184ce3d_SESS_a0febadb-e348-11ed-8c5e-00d86184ce3d_TOSC_5749fe3e-e349-11ed-8c5e-00d86184ce3d_MODEL','a74f3159-e349-11ed-8c5e-00d86184ce3d.zip','a74f3159-e349-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.12.1.1.3\",\"modelMatrix\":\"0.433103,0.871384,-0.230462,0,-0.901345,0.418706,-0.110739,0,1.0967e-08,0.255687,0.96676,0,-29.1513,-14.3322,-6.79517,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-25 11:14:59.745','2023-04-25 09:15:00.611',NULL),('a74f4a8c-e349-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/971e14b0-e348-11ed-8c5e-00d86184ce3d/session_a0fbda94-e348-11ed-8c5e-00d86184ce3d/occlusion_a0febadb-e348-11ed-8c5e-00d86184ce3d/scan_5749fe3e-e349-11ed-8c5e-00d86184ce3d/a74f4a8c-e349-11ed-8c5e-00d86184ce3d.png','PATIENT_971e14b0-e348-11ed-8c5e-00d86184ce3d_ACT_a0fbda94-e348-11ed-8c5e-00d86184ce3d_SESS_a0febadb-e348-11ed-8c5e-00d86184ce3d_TOSC_5749fe3e-e349-11ed-8c5e-00d86184ce3d_SNAPS','a74f4a8c-e349-11ed-8c5e-00d86184ce3d.png','a74f4a8c-e349-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.12.1.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-25 11:14:59.746','2023-04-25 09:15:00.612',NULL),('a86f3c7f-0f41-11ee-8712-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_55019e04-0f41-11ee-8712-a0510b46b473/occlusion_550492f3-0f41-11ee-8712-a0510b46b473/scan_5608c4ca-0f41-11ee-8712-a0510b46b473/a86f3c7f-0f41-11ee-8712-a0510b46b473.zip','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_55019e04-0f41-11ee-8712-a0510b46b473_SESS_550492f3-0f41-11ee-8712-a0510b46b473_TOSC_5608c4ca-0f41-11ee-8712-a0510b46b473_MODEL','a86f3c7f-0f41-11ee-8712-a0510b46b473.zip','a86f3c7f-0f41-11ee-8712-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.2.1.1\",\"modelMatrix\":\"0.889284,0.37939,-0.255416,0,-0.457355,0.737688,-0.496632,0,8.98559e-09,0.558463,0.82953,0,-28.719,3.96501,-10.115,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-20 10:08:36.821','2023-06-20 08:08:37.407',NULL),('a86f56c6-0f41-11ee-8712-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_55019e04-0f41-11ee-8712-a0510b46b473/occlusion_550492f3-0f41-11ee-8712-a0510b46b473/scan_5608c4ca-0f41-11ee-8712-a0510b46b473/a86f56c6-0f41-11ee-8712-a0510b46b473.png','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_55019e04-0f41-11ee-8712-a0510b46b473_SESS_550492f3-0f41-11ee-8712-a0510b46b473_TOSC_5608c4ca-0f41-11ee-8712-a0510b46b473_SNAPS','a86f56c6-0f41-11ee-8712-a0510b46b473.png','a86f56c6-0f41-11ee-8712-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.2.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-20 10:08:36.822','2023-06-20 08:08:37.407',NULL),('a8cd4428-e03a-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_6f09f9a8-e03a-11ed-bb13-00d86184ce3d/occlusion_6f0c3cda-e03a-11ed-bb13-00d86184ce3d/scan_8ca24c63-e03a-11ed-bb13-00d86184ce3d/a8cd4428-e03a-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_6f09f9a8-e03a-11ed-bb13-00d86184ce3d_SESS_6f0c3cda-e03a-11ed-bb13-00d86184ce3d_TOSC_8ca24c63-e03a-11ed-bb13-00d86184ce3d_MODEL','a8cd4428-e03a-11ed-bb13-00d86184ce3d.zip','a8cd4428-e03a-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.3.1.2\",\"modelMatrix\":\"0.946716,0.273012,-0.17086,0,-0.322069,0.802513,-0.502238,0,-1.078e-08,0.530506,0.847681,0,-14.3271,-2.12206,-8.34287,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,'2023-04-21 13:51:29.438','2023-04-21 13:50:06.310','2023-04-21 11:51:29.443',NULL),('a8cd5ec3-e03a-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_6f09f9a8-e03a-11ed-bb13-00d86184ce3d/occlusion_6f0c3cda-e03a-11ed-bb13-00d86184ce3d/scan_8ca24c63-e03a-11ed-bb13-00d86184ce3d/a8cd5ec3-e03a-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_6f09f9a8-e03a-11ed-bb13-00d86184ce3d_SESS_6f0c3cda-e03a-11ed-bb13-00d86184ce3d_TOSC_8ca24c63-e03a-11ed-bb13-00d86184ce3d_SNAPS','a8cd5ec3-e03a-11ed-bb13-00d86184ce3d.png','a8cd5ec3-e03a-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.3.1.2 Snapshot\"}','PNG',0,'CREATED',0,'2023-04-21 13:51:29.439','2023-04-21 13:50:06.311','2023-04-21 11:51:29.446',NULL),('a8e7f999-1a70-11ee-9a4e-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_77df3b68-1a6c-11ee-af16-a0510b46b473/occlusion_77e234a6-1a6c-11ee-af16-a0510b46b473/scan_5d6d930c-1a70-11ee-9a4e-a0510b46b473/a8e7f999-1a70-11ee-9a4e-a0510b46b473.zip','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_77df3b68-1a6c-11ee-af16-a0510b46b473_SESS_77e234a6-1a6c-11ee-af16-a0510b46b473_TOSC_5d6d930c-1a70-11ee-9a4e-a0510b46b473_MODEL','a8e7f999-1a70-11ee-9a4e-a0510b46b473.zip','a8e7f999-1a70-11ee-9a4e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.4.1.2\",\"modelMatrix\":\"-0.0598078,0.987909,-0.143037,0,-0.99821,-0.0591906,0.00857009,0,6.4762e-10,0.143294,0.98968,0,-16.1461,-26.9356,-8.5074,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-04 15:42:46.749','2023-07-04 13:42:47.373',NULL),('a8e81139-1a70-11ee-9a4e-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_77df3b68-1a6c-11ee-af16-a0510b46b473/occlusion_77e234a6-1a6c-11ee-af16-a0510b46b473/scan_5d6d930c-1a70-11ee-9a4e-a0510b46b473/a8e81139-1a70-11ee-9a4e-a0510b46b473.png','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_77df3b68-1a6c-11ee-af16-a0510b46b473_SESS_77e234a6-1a6c-11ee-af16-a0510b46b473_TOSC_5d6d930c-1a70-11ee-9a4e-a0510b46b473_SNAPS','a8e81139-1a70-11ee-9a4e-a0510b46b473.png','a8e81139-1a70-11ee-9a4e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.4.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-04 15:42:46.750','2023-07-04 13:42:47.374',NULL),('a9fd7844-10db-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/bd51960a-10d5-11ee-b636-a0510b46b473/session_ea36dd21-10da-11ee-b636-a0510b46b473/occlusion_ea39c2be-10da-11ee-b636-a0510b46b473/scan_6aaf129f-10db-11ee-b636-a0510b46b473/a9fd7844-10db-11ee-b636-a0510b46b473.zip','PATIENT_bd51960a-10d5-11ee-b636-a0510b46b473_ACT_ea36dd21-10da-11ee-b636-a0510b46b473_SESS_ea39c2be-10da-11ee-b636-a0510b46b473_TOSC_6aaf129f-10db-11ee-b636-a0510b46b473_MODEL','a9fd7844-10db-11ee-b636-a0510b46b473.zip','a9fd7844-10db-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.17.2.1.3\",\"modelMatrix\":\"0.71443,0.620923,-0.322558,0,-0.699707,0.633989,-0.329345,0,-8.73899e-09,0.46099,0.887405,0,-26.8665,7.36738,-8.95802,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 11:03:33.090','2023-06-22 09:03:33.732',NULL),('a9fd8ff5-10db-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/bd51960a-10d5-11ee-b636-a0510b46b473/session_ea36dd21-10da-11ee-b636-a0510b46b473/occlusion_ea39c2be-10da-11ee-b636-a0510b46b473/scan_6aaf129f-10db-11ee-b636-a0510b46b473/a9fd8ff5-10db-11ee-b636-a0510b46b473.png','PATIENT_bd51960a-10d5-11ee-b636-a0510b46b473_ACT_ea36dd21-10da-11ee-b636-a0510b46b473_SESS_ea39c2be-10da-11ee-b636-a0510b46b473_TOSC_6aaf129f-10db-11ee-b636-a0510b46b473_SNAPS','a9fd8ff5-10db-11ee-b636-a0510b46b473.png','a9fd8ff5-10db-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.17.2.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 11:03:33.091','2023-06-22 09:03:33.741',NULL),('aa5478d7-1a49-11ee-9a4f-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_56e1eee3-1a49-11ee-9a4f-a0510b46b473/occlusion_56e449e9-1a49-11ee-9a4f-a0510b46b473/scan_626e3c07-1a49-11ee-9a4f-a0510b46b473/aa5478d7-1a49-11ee-9a4f-a0510b46b473.zip','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_56e1eee3-1a49-11ee-9a4f-a0510b46b473_SESS_56e449e9-1a49-11ee-9a4f-a0510b46b473_TOSC_626e3c07-1a49-11ee-9a4f-a0510b46b473_MODEL','aa5478d7-1a49-11ee-9a4f-a0510b46b473.zip','aa5478d7-1a49-11ee-9a4f-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.1.1.1\",\"modelMatrix\":\"0.295138,0.941942,-0.160123,0,-0.955455,0.290964,-0.0494617,0,-1.71968e-09,0.167589,0.985857,0,-26.7832,-14.2169,-7.05723,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-04 11:03:38.766','2023-07-04 09:03:39.486',NULL),('aa5492b4-1a49-11ee-9a4f-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_56e1eee3-1a49-11ee-9a4f-a0510b46b473/occlusion_56e449e9-1a49-11ee-9a4f-a0510b46b473/scan_626e3c07-1a49-11ee-9a4f-a0510b46b473/aa5492b4-1a49-11ee-9a4f-a0510b46b473.png','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_56e1eee3-1a49-11ee-9a4f-a0510b46b473_SESS_56e449e9-1a49-11ee-9a4f-a0510b46b473_TOSC_626e3c07-1a49-11ee-9a4f-a0510b46b473_SNAPS','aa5492b4-1a49-11ee-9a4f-a0510b46b473.png','aa5492b4-1a49-11ee-9a4f-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.1.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-04 11:03:38.766','2023-07-04 09:03:39.488',NULL),('aaf7c34b-15b8-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/142e7037-15b6-11ee-b3b1-00d86184ce3d/session_1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d/occlusion_1ed7780a-15b6-11ee-b3b1-00d86184ce3d/scan_5b9d68ab-15b8-11ee-b3b1-00d86184ce3d/aaf7c34b-15b8-11ee-b3b1-00d86184ce3d.zip','PATIENT_142e7037-15b6-11ee-b3b1-00d86184ce3d_ACT_1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d_SESS_1ed7780a-15b6-11ee-b3b1-00d86184ce3d_TOSC_5b9d68ab-15b8-11ee-b3b1-00d86184ce3d_MODEL','aaf7c34b-15b8-11ee-b3b1-00d86184ce3d.zip','aaf7c34b-15b8-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.25.1.1.7\",\"modelMatrix\":\"0.489553,0.86297,-0.124985,0,-0.871974,0.484498,-0.0701705,0,-4.73268e-09,0.143336,0.989674,0,-27.8092,-12.7369,-10.9362,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-28 15:35:38.159','2023-06-28 13:35:38.959',NULL),('aaf7da45-15b8-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/142e7037-15b6-11ee-b3b1-00d86184ce3d/session_1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d/occlusion_1ed7780a-15b6-11ee-b3b1-00d86184ce3d/scan_5b9d68ab-15b8-11ee-b3b1-00d86184ce3d/aaf7da45-15b8-11ee-b3b1-00d86184ce3d.png','PATIENT_142e7037-15b6-11ee-b3b1-00d86184ce3d_ACT_1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d_SESS_1ed7780a-15b6-11ee-b3b1-00d86184ce3d_TOSC_5b9d68ab-15b8-11ee-b3b1-00d86184ce3d_SNAPS','aaf7da45-15b8-11ee-b3b1-00d86184ce3d.png','aaf7da45-15b8-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.25.1.1.7 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-28 15:35:38.160','2023-06-28 13:35:38.963',NULL),('ab414eb6-14c7-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/9619fcac-14c3-11ee-b3b1-00d86184ce3d/session_961b9a11-14c3-11ee-b3b1-00d86184ce3d/occlusion_961d56b4-14c3-11ee-b3b1-00d86184ce3d/scan_581eb6dc-14c7-11ee-b3b1-00d86184ce3d/ab414eb6-14c7-11ee-b3b1-00d86184ce3d.zip','PATIENT_9619fcac-14c3-11ee-b3b1-00d86184ce3d_ACT_961b9a11-14c3-11ee-b3b1-00d86184ce3d_SESS_961d56b4-14c3-11ee-b3b1-00d86184ce3d_TOSC_581eb6dc-14c7-11ee-b3b1-00d86184ce3d_MODEL','ab414eb6-14c7-11ee-b3b1-00d86184ce3d.zip','ab414eb6-14c7-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.22.1.1.4\",\"modelMatrix\":\"0.492937,0.821593,-0.286354,0,-0.870065,0.465475,-0.162234,0,-1.65776e-08,0.329118,0.944289,0,-29.5741,-14.5389,-7.64355,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-27 10:50:29.929','2023-06-27 08:50:30.688',NULL),('ab4285fc-14c7-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/9619fcac-14c3-11ee-b3b1-00d86184ce3d/session_961b9a11-14c3-11ee-b3b1-00d86184ce3d/occlusion_961d56b4-14c3-11ee-b3b1-00d86184ce3d/scan_581eb6dc-14c7-11ee-b3b1-00d86184ce3d/ab4285fc-14c7-11ee-b3b1-00d86184ce3d.png','PATIENT_9619fcac-14c3-11ee-b3b1-00d86184ce3d_ACT_961b9a11-14c3-11ee-b3b1-00d86184ce3d_SESS_961d56b4-14c3-11ee-b3b1-00d86184ce3d_TOSC_581eb6dc-14c7-11ee-b3b1-00d86184ce3d_SNAPS','ab4285fc-14c7-11ee-b3b1-00d86184ce3d.png','ab4285fc-14c7-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.22.1.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-27 10:50:29.937','2023-06-27 08:50:30.697',NULL),('ab509e0f-df8c-11ed-b6c2-00d86184ce3d',11,'/home/scan/.data//2023/11/ce063c89-df8b-11ed-b6c2-00d86184ce3d/session_d5081c73-df8b-11ed-b6c2-00d86184ce3d/occlusion_d50b8b0c-df8b-11ed-b6c2-00d86184ce3d/scan_5f91c0b6-df8c-11ed-b6c2-00d86184ce3d/ab509e0f-df8c-11ed-b6c2-00d86184ce3d.zip','PATIENT_ce063c89-df8b-11ed-b6c2-00d86184ce3d_ACT_d5081c73-df8b-11ed-b6c2-00d86184ce3d_SESS_d50b8b0c-df8b-11ed-b6c2-00d86184ce3d_TOSC_5f91c0b6-df8c-11ed-b6c2-00d86184ce3d_MODEL','ab509e0f-df8c-11ed-b6c2-00d86184ce3d.zip','ab509e0f-df8c-11ed-b6c2-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.9.1.1.2\",\"modelMatrix\":\"0.447669,0.776016,-0.444288,0,-0.894199,0.388503,-0.222427,0,-2.65856e-09,0.496855,0.867833,0,-23.0251,-17.5644,-6.59569,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-20 17:04:38.095','2023-04-20 15:04:38.820',NULL),('ab50b5ab-df8c-11ed-b6c2-00d86184ce3d',11,'/home/scan/.data//2023/11/ce063c89-df8b-11ed-b6c2-00d86184ce3d/session_d5081c73-df8b-11ed-b6c2-00d86184ce3d/occlusion_d50b8b0c-df8b-11ed-b6c2-00d86184ce3d/scan_5f91c0b6-df8c-11ed-b6c2-00d86184ce3d/ab50b5ab-df8c-11ed-b6c2-00d86184ce3d.png','PATIENT_ce063c89-df8b-11ed-b6c2-00d86184ce3d_ACT_d5081c73-df8b-11ed-b6c2-00d86184ce3d_SESS_d50b8b0c-df8b-11ed-b6c2-00d86184ce3d_TOSC_5f91c0b6-df8c-11ed-b6c2-00d86184ce3d_SNAPS','ab50b5ab-df8c-11ed-b6c2-00d86184ce3d.png','ab50b5ab-df8c-11ed-b6c2-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.9.1.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-20 17:04:38.096','2023-04-20 15:04:38.820',NULL),('ac00f627-1bff-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/8a8cc548-1bf9-11ee-9323-a0510b46b473/session_976f015a-1bf9-11ee-9323-a0510b46b473/occlusion_97713d19-1bf9-11ee-9323-a0510b46b473/scan_59748b5e-1bff-11ee-9323-a0510b46b473/ac00f627-1bff-11ee-9323-a0510b46b473.zip','PATIENT_8a8cc548-1bf9-11ee-9323-a0510b46b473_ACT_976f015a-1bf9-11ee-9323-a0510b46b473_SESS_97713d19-1bf9-11ee-9323-a0510b46b473_TOSC_59748b5e-1bff-11ee-9323-a0510b46b473_MODEL','ac00f627-1bff-11ee-9323-a0510b46b473.zip','ac00f627-1bff-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.28.1.1.11\",\"modelMatrix\":\"0.516889,0.830312,-0.208347,0,-0.856052,0.501347,-0.125801,0,-6.96181e-09,0.243381,0.969931,0,-29.7669,-16.7492,-7.88297,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 15:19:01.141','2023-07-06 13:19:01.936',NULL),('ac010d2b-1bff-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/8a8cc548-1bf9-11ee-9323-a0510b46b473/session_976f015a-1bf9-11ee-9323-a0510b46b473/occlusion_97713d19-1bf9-11ee-9323-a0510b46b473/scan_59748b5e-1bff-11ee-9323-a0510b46b473/ac010d2b-1bff-11ee-9323-a0510b46b473.png','PATIENT_8a8cc548-1bf9-11ee-9323-a0510b46b473_ACT_976f015a-1bf9-11ee-9323-a0510b46b473_SESS_97713d19-1bf9-11ee-9323-a0510b46b473_TOSC_59748b5e-1bff-11ee-9323-a0510b46b473_SNAPS','ac010d2b-1bff-11ee-9323-a0510b46b473.png','ac010d2b-1bff-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.28.1.1.11 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 15:19:01.142','2023-07-06 13:19:01.945',NULL),('ac1835eb-1c00-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/8a8cc548-1bf9-11ee-9323-a0510b46b473/session_ff6745bb-1bff-11ee-9323-a0510b46b473/occlusion_ff6924df-1bff-11ee-9323-a0510b46b473/scan_741d1c09-1c00-11ee-9323-a0510b46b473/ac1835eb-1c00-11ee-9323-a0510b46b473.zip','PATIENT_8a8cc548-1bf9-11ee-9323-a0510b46b473_ACT_ff6745bb-1bff-11ee-9323-a0510b46b473_SESS_ff6924df-1bff-11ee-9323-a0510b46b473_TOSC_741d1c09-1c00-11ee-9323-a0510b46b473_MODEL','ac1835eb-1c00-11ee-9323-a0510b46b473.zip','ac1835eb-1c00-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.28.2.1.3\",\"modelMatrix\":\"0.96443,0.220982,-0.145058,0,-0.264338,0.806245,-0.529239,0,4.64771e-09,0.548758,0.835981,0,-25.1571,12.194,-11.5082,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 15:26:10.791','2023-07-06 13:26:11.345',NULL),('ac184d06-1c00-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/8a8cc548-1bf9-11ee-9323-a0510b46b473/session_ff6745bb-1bff-11ee-9323-a0510b46b473/occlusion_ff6924df-1bff-11ee-9323-a0510b46b473/scan_741d1c09-1c00-11ee-9323-a0510b46b473/ac184d06-1c00-11ee-9323-a0510b46b473.png','PATIENT_8a8cc548-1bf9-11ee-9323-a0510b46b473_ACT_ff6745bb-1bff-11ee-9323-a0510b46b473_SESS_ff6924df-1bff-11ee-9323-a0510b46b473_TOSC_741d1c09-1c00-11ee-9323-a0510b46b473_SNAPS','ac184d06-1c00-11ee-9323-a0510b46b473.png','ac184d06-1c00-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.28.2.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 15:26:10.791','2023-07-06 13:26:11.346',NULL),('ac44f1be-1bd0-11ee-9086-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_a6b1a4bd-1bcf-11ee-9086-a0510b46b473/occlusion_a6b491c8-1bcf-11ee-9086-a0510b46b473/scan_53a2d93e-1bd0-11ee-9086-a0510b46b473/ac44f1be-1bd0-11ee-9086-a0510b46b473.zip','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_a6b1a4bd-1bcf-11ee-9086-a0510b46b473_SESS_a6b491c8-1bcf-11ee-9086-a0510b46b473_TOSC_53a2d93e-1bd0-11ee-9086-a0510b46b473_MODEL','ac44f1be-1bd0-11ee-9086-a0510b46b473.zip','ac44f1be-1bd0-11ee-9086-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.3.1.3\",\"modelMatrix\":\"-0.0335677,0.971136,-0.236152,0,-0.999436,-0.0326172,0.00793155,0,7.65129e-11,0.236285,0.971684,0,-21.0149,-22.5579,-7.7158,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 09:42:35.241','2023-07-06 07:42:36.189',NULL),('ac4570ae-1bd0-11ee-9086-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_a6b1a4bd-1bcf-11ee-9086-a0510b46b473/occlusion_a6b491c8-1bcf-11ee-9086-a0510b46b473/scan_53a2d93e-1bd0-11ee-9086-a0510b46b473/ac4570ae-1bd0-11ee-9086-a0510b46b473.png','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_a6b1a4bd-1bcf-11ee-9086-a0510b46b473_SESS_a6b491c8-1bcf-11ee-9086-a0510b46b473_TOSC_53a2d93e-1bd0-11ee-9086-a0510b46b473_SNAPS','ac4570ae-1bd0-11ee-9086-a0510b46b473.png','ac4570ae-1bd0-11ee-9086-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.3.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 09:42:35.244','2023-07-06 07:42:36.189',NULL),('ac839928-2ae8-11ee-97fa-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_8b758c52-2ae7-11ee-97fa-a0510b46b473/occlusion_8b789858-2ae7-11ee-97fa-a0510b46b473/scan_66624caf-2ae8-11ee-97fa-a0510b46b473/ac839928-2ae8-11ee-97fa-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_8b758c52-2ae7-11ee-97fa-a0510b46b473_SESS_8b789858-2ae7-11ee-97fa-a0510b46b473_TOSC_66624caf-2ae8-11ee-97fa-a0510b46b473_MODEL','ac839928-2ae8-11ee-97fa-a0510b46b473.zip','ac839928-2ae8-11ee-97fa-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.9.1.2\",\"modelMatrix\":\"0.538987,0.775606,-0.328525,0,-0.842314,0.496301,-0.210219,0,-1.98917e-09,0.390027,0.920804,0,-30.2592,-12.8933,-6.47595,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-25 14:42:11.014','2023-07-25 12:42:11.575',NULL),('ac83ad30-2ae8-11ee-97fa-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_8b758c52-2ae7-11ee-97fa-a0510b46b473/occlusion_8b789858-2ae7-11ee-97fa-a0510b46b473/scan_66624caf-2ae8-11ee-97fa-a0510b46b473/ac83ad30-2ae8-11ee-97fa-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_8b758c52-2ae7-11ee-97fa-a0510b46b473_SESS_8b789858-2ae7-11ee-97fa-a0510b46b473_TOSC_66624caf-2ae8-11ee-97fa-a0510b46b473_SNAPS','ac83ad30-2ae8-11ee-97fa-a0510b46b473.png','ac83ad30-2ae8-11ee-97fa-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.9.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-25 14:42:11.015','2023-07-25 12:42:11.577',NULL),('ae1f3376-2631-11ee-81dd-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_62519c59-261f-11ee-8042-a0510b46b473/occlusion_6253caa6-261f-11ee-8042-a0510b46b473/scan_6558b252-2631-11ee-81dd-a0510b46b473/ae1f3376-2631-11ee-81dd-a0510b46b473.zip','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_62519c59-261f-11ee-8042-a0510b46b473_SESS_6253caa6-261f-11ee-8042-a0510b46b473_BOSC_6558b252-2631-11ee-81dd-a0510b46b473_MODEL','ae1f3376-2631-11ee-81dd-a0510b46b473.zip','ae1f3376-2631-11ee-81dd-a0510b46b473','{\"displayTitle\":\"Mandibule 1.34.1.1.4\",\"modelMatrix\":\"0.994141,0.103525,-0.0310766,0,-0.108089,0.952167,-0.285825,0,1.10197e-09,0.287509,0.957778,0,-20.9202,-32.8942,-17.2177,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-19 14:42:11.159','2023-07-19 12:42:11.577',NULL),('ae1f4852-2631-11ee-81dd-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_62519c59-261f-11ee-8042-a0510b46b473/occlusion_6253caa6-261f-11ee-8042-a0510b46b473/scan_6558b252-2631-11ee-81dd-a0510b46b473/ae1f4852-2631-11ee-81dd-a0510b46b473.png','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_62519c59-261f-11ee-8042-a0510b46b473_SESS_6253caa6-261f-11ee-8042-a0510b46b473_BOSC_6558b252-2631-11ee-81dd-a0510b46b473_SNAPS','ae1f4852-2631-11ee-81dd-a0510b46b473.png','ae1f4852-2631-11ee-81dd-a0510b46b473','{\"displayTitle\":\"Mandibule 1.34.1.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-19 14:42:11.160','2023-07-19 12:42:11.580',NULL),('ae36f6f9-2ae1-11ee-95bc-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_b5fe1002-2ae0-11ee-95bc-a0510b46b473/occlusion_b6012772-2ae0-11ee-95bc-a0510b46b473/scan_70a7e0a4-2ae1-11ee-95bc-a0510b46b473/ae36f6f9-2ae1-11ee-95bc-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_b5fe1002-2ae0-11ee-95bc-a0510b46b473_SESS_b6012772-2ae0-11ee-95bc-a0510b46b473_TOSC_70a7e0a4-2ae1-11ee-95bc-a0510b46b473_MODEL','ae36f6f9-2ae1-11ee-95bc-a0510b46b473.zip','ae36f6f9-2ae1-11ee-95bc-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.8.1.2\",\"modelMatrix\":\"0.548323,0.811219,-0.203139,0,-0.836267,0.5319,-0.133194,0,-6.58119e-09,0.242911,0.970049,0,-27.2317,-12.9347,-8.21961,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-25 13:52:07.391','2023-07-25 11:52:07.875',NULL),('ae370ef7-2ae1-11ee-95bc-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_b5fe1002-2ae0-11ee-95bc-a0510b46b473/occlusion_b6012772-2ae0-11ee-95bc-a0510b46b473/scan_70a7e0a4-2ae1-11ee-95bc-a0510b46b473/ae370ef7-2ae1-11ee-95bc-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_b5fe1002-2ae0-11ee-95bc-a0510b46b473_SESS_b6012772-2ae0-11ee-95bc-a0510b46b473_TOSC_70a7e0a4-2ae1-11ee-95bc-a0510b46b473_SNAPS','ae370ef7-2ae1-11ee-95bc-a0510b46b473.png','ae370ef7-2ae1-11ee-95bc-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.8.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-25 13:52:07.391','2023-07-25 11:52:07.876',NULL),('af89cb3f-df82-11ed-b6c2-00d86184ce3d',11,'/home/scan/.data//2023/11/ac239c53-df81-11ed-b6c2-00d86184ce3d/session_b20f4b8a-df81-11ed-b6c2-00d86184ce3d/occlusion_b21241b0-df81-11ed-b6c2-00d86184ce3d/scan_5ad1c88c-df82-11ed-b6c2-00d86184ce3d/af89cb3f-df82-11ed-b6c2-00d86184ce3d.zip','PATIENT_ac239c53-df81-11ed-b6c2-00d86184ce3d_ACT_b20f4b8a-df81-11ed-b6c2-00d86184ce3d_SESS_b21241b0-df81-11ed-b6c2-00d86184ce3d_TOSC_5ad1c88c-df82-11ed-b6c2-00d86184ce3d_MODEL','af89cb3f-df82-11ed-b6c2-00d86184ce3d.zip','af89cb3f-df82-11ed-b6c2-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.7.1.1.2\",\"modelMatrix\":\"0.558938,0.785622,-0.265306,0,-0.82921,0.529557,-0.178833,0,4.03121e-09,0.319951,0.947434,0,-26.3758,-14.978,-3.97682,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-20 15:53:10.214','2023-04-20 13:53:11.086',NULL),('af89e2c0-df82-11ed-b6c2-00d86184ce3d',11,'/home/scan/.data//2023/11/ac239c53-df81-11ed-b6c2-00d86184ce3d/session_b20f4b8a-df81-11ed-b6c2-00d86184ce3d/occlusion_b21241b0-df81-11ed-b6c2-00d86184ce3d/scan_5ad1c88c-df82-11ed-b6c2-00d86184ce3d/af89e2c0-df82-11ed-b6c2-00d86184ce3d.png','PATIENT_ac239c53-df81-11ed-b6c2-00d86184ce3d_ACT_b20f4b8a-df81-11ed-b6c2-00d86184ce3d_SESS_b21241b0-df81-11ed-b6c2-00d86184ce3d_TOSC_5ad1c88c-df82-11ed-b6c2-00d86184ce3d_SNAPS','af89e2c0-df82-11ed-b6c2-00d86184ce3d.png','af89e2c0-df82-11ed-b6c2-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.7.1.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-20 15:53:10.214','2023-04-20 13:53:11.087',NULL),('afb02f87-de94-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/e0d449f3-dde9-11ed-aa56-00d86184ce3d/session_858fcc60-de94-11ed-9cc3-00d86184ce3d/occlusion_85925fd9-de94-11ed-9cc3-00d86184ce3d/scan_86c99c00-de94-11ed-9cc3-00d86184ce3d/afb02f87-de94-11ed-9cc3-00d86184ce3d.zip','PATIENT_e0d449f3-dde9-11ed-aa56-00d86184ce3d_ACT_858fcc60-de94-11ed-9cc3-00d86184ce3d_SESS_85925fd9-de94-11ed-9cc3-00d86184ce3d_TOSC_86c99c00-de94-11ed-9cc3-00d86184ce3d_MODEL','afb02f87-de94-11ed-9cc3-00d86184ce3d.zip','afb02f87-de94-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.2.1.1.1\",\"modelMatrix\":\"0.994728,-0.101834,0.012072,0,0.102547,0.987811,-0.117101,0,4.1965e-11,0.117722,0.993047,0,-22.8376,18.6208,-17.5003,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-19 11:29:30.243','2023-04-19 09:29:30.593',NULL),('afb048da-de94-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/e0d449f3-dde9-11ed-aa56-00d86184ce3d/session_858fcc60-de94-11ed-9cc3-00d86184ce3d/occlusion_85925fd9-de94-11ed-9cc3-00d86184ce3d/scan_86c99c00-de94-11ed-9cc3-00d86184ce3d/afb048da-de94-11ed-9cc3-00d86184ce3d.png','PATIENT_e0d449f3-dde9-11ed-aa56-00d86184ce3d_ACT_858fcc60-de94-11ed-9cc3-00d86184ce3d_SESS_85925fd9-de94-11ed-9cc3-00d86184ce3d_TOSC_86c99c00-de94-11ed-9cc3-00d86184ce3d_SNAPS','afb048da-de94-11ed-9cc3-00d86184ce3d.png','afb048da-de94-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.2.1.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-19 11:29:30.244','2023-04-19 09:29:30.594',NULL),('b0183050-0f79-11ee-9460-a0510b46b473',11,'/home/scan/.data//2023/11/e4b67639-0f72-11ee-8712-a0510b46b473/session_ec7935d6-0f72-11ee-8712-a0510b46b473/occlusion_ec7bd8ad-0f72-11ee-8712-a0510b46b473/scan_520b9fb7-0f79-11ee-9460-a0510b46b473/b0183050-0f79-11ee-9460-a0510b46b473.zip','PATIENT_e4b67639-0f72-11ee-8712-a0510b46b473_ACT_ec7935d6-0f72-11ee-8712-a0510b46b473_SESS_ec7bd8ad-0f72-11ee-8712-a0510b46b473_TOSC_520b9fb7-0f79-11ee-9460-a0510b46b473_MODEL','b0183050-0f79-11ee-9460-a0510b46b473.zip','b0183050-0f79-11ee-9460-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.15.1.1.9\",\"modelMatrix\":\"0.653993,0.738392,-0.164531,0,-0.756501,0.638338,-0.142236,0,-4.15602e-09,0.217489,0.976063,0,-31.8489,-1.34864,-9.53148,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-20 16:49:41.489','2023-06-20 14:49:42.222',NULL),('b01844e4-0f79-11ee-9460-a0510b46b473',11,'/home/scan/.data//2023/11/e4b67639-0f72-11ee-8712-a0510b46b473/session_ec7935d6-0f72-11ee-8712-a0510b46b473/occlusion_ec7bd8ad-0f72-11ee-8712-a0510b46b473/scan_520b9fb7-0f79-11ee-9460-a0510b46b473/b01844e4-0f79-11ee-9460-a0510b46b473.png','PATIENT_e4b67639-0f72-11ee-8712-a0510b46b473_ACT_ec7935d6-0f72-11ee-8712-a0510b46b473_SESS_ec7bd8ad-0f72-11ee-8712-a0510b46b473_TOSC_520b9fb7-0f79-11ee-9460-a0510b46b473_SNAPS','b01844e4-0f79-11ee-9460-a0510b46b473.png','b01844e4-0f79-11ee-9460-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.15.1.1.9 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-20 16:49:41.490','2023-06-20 14:49:42.222',NULL),('b09f0ade-2709-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_c28d11f3-2706-11ee-a98e-a0510b46b473/occlusion_c2900beb-2706-11ee-a98e-a0510b46b473/scan_5b0d4628-2709-11ee-a98e-a0510b46b473/b09f0ade-2709-11ee-a98e-a0510b46b473.zip','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_c28d11f3-2706-11ee-a98e-a0510b46b473_SESS_c2900beb-2706-11ee-a98e-a0510b46b473_TOSC_5b0d4628-2709-11ee-a98e-a0510b46b473_MODEL','b09f0ade-2709-11ee-a98e-a0510b46b473.zip','b09f0ade-2709-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.3.1.4\",\"modelMatrix\":\"-0.00252226,0.98098,-0.19409,0,-0.999997,-0.0024743,0.000489548,0,-1.01539e-11,0.194091,0.980984,0,-14.8413,-29.9132,-10.8115,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-20 16:28:26.646','2023-07-20 14:28:27.365',NULL),('b09f2047-2709-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_c28d11f3-2706-11ee-a98e-a0510b46b473/occlusion_c2900beb-2706-11ee-a98e-a0510b46b473/scan_5b0d4628-2709-11ee-a98e-a0510b46b473/b09f2047-2709-11ee-a98e-a0510b46b473.png','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_c28d11f3-2706-11ee-a98e-a0510b46b473_SESS_c2900beb-2706-11ee-a98e-a0510b46b473_TOSC_5b0d4628-2709-11ee-a98e-a0510b46b473_SNAPS','b09f2047-2709-11ee-a98e-a0510b46b473.png','b09f2047-2709-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.3.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-20 16:28:26.647','2023-07-20 14:28:27.366',NULL),('b0b39e26-e344-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_853ebc79-e33f-11ed-8c5e-00d86184ce3d/occlusion_8541c500-e33f-11ed-8c5e-00d86184ce3d/scan_5b9f63fb-e344-11ed-8c5e-00d86184ce3d/b0b39e26-e344-11ed-8c5e-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_853ebc79-e33f-11ed-8c5e-00d86184ce3d_SESS_8541c500-e33f-11ed-8c5e-00d86184ce3d_TOSC_5b9f63fb-e344-11ed-8c5e-00d86184ce3d_MODEL','b0b39e26-e344-11ed-8c5e-00d86184ce3d.zip','b0b39e26-e344-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.6.1.7\",\"modelMatrix\":\"0.181776,0.964881,-0.189638,0,-0.98334,0.178364,-0.0350556,0,-3.87432e-09,0.192851,0.981228,0,-24.7199,-18.8635,-8.82186,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-25 10:39:28.019','2023-04-25 08:39:28.993',NULL),('b0b3b45d-e344-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_853ebc79-e33f-11ed-8c5e-00d86184ce3d/occlusion_8541c500-e33f-11ed-8c5e-00d86184ce3d/scan_5b9f63fb-e344-11ed-8c5e-00d86184ce3d/b0b3b45d-e344-11ed-8c5e-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_853ebc79-e33f-11ed-8c5e-00d86184ce3d_SESS_8541c500-e33f-11ed-8c5e-00d86184ce3d_TOSC_5b9f63fb-e344-11ed-8c5e-00d86184ce3d_SNAPS','b0b3b45d-e344-11ed-8c5e-00d86184ce3d.png','b0b3b45d-e344-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.6.1.7 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-25 10:39:28.020','2023-04-25 08:39:28.994',NULL),('b0e7038c-1106-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_0628a8e9-1104-11ee-b636-a0510b46b473/occlusion_062b833f-1104-11ee-b636-a0510b46b473/scan_5e667c52-1106-11ee-b636-a0510b46b473/b0e7038c-1106-11ee-b636-a0510b46b473.zip','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_0628a8e9-1104-11ee-b636-a0510b46b473_SESS_062b833f-1104-11ee-b636-a0510b46b473_TOSC_5e667c52-1106-11ee-b636-a0510b46b473_MODEL','b0e7038c-1106-11ee-b636-a0510b46b473.zip','b0e7038c-1106-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.20.1.1.6\",\"modelMatrix\":\"0.711218,0.670712,-0.21051,0,-0.702972,0.67858,-0.212979,0,-9.04785e-09,0.299457,0.95411,0,-31.4613,-1.78453,-10.153,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 16:11:33.047','2023-06-22 14:11:33.752',NULL),('b0e71a6e-1106-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_0628a8e9-1104-11ee-b636-a0510b46b473/occlusion_062b833f-1104-11ee-b636-a0510b46b473/scan_5e667c52-1106-11ee-b636-a0510b46b473/b0e71a6e-1106-11ee-b636-a0510b46b473.png','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_0628a8e9-1104-11ee-b636-a0510b46b473_SESS_062b833f-1104-11ee-b636-a0510b46b473_TOSC_5e667c52-1106-11ee-b636-a0510b46b473_SNAPS','b0e71a6e-1106-11ee-b636-a0510b46b473.png','b0e71a6e-1106-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.20.1.1.6 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 16:11:33.047','2023-06-22 14:11:33.753',NULL),('b13466fa-e351-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/6175c1d5-e350-11ed-8c5e-00d86184ce3d/session_71ba03b6-e350-11ed-8c5e-00d86184ce3d/occlusion_71bbf096-e350-11ed-8c5e-00d86184ce3d/scan_56b2e06a-e351-11ed-8c5e-00d86184ce3d/b13466fa-e351-11ed-8c5e-00d86184ce3d.zip','PATIENT_6175c1d5-e350-11ed-8c5e-00d86184ce3d_ACT_71ba03b6-e350-11ed-8c5e-00d86184ce3d_SESS_71bbf096-e350-11ed-8c5e-00d86184ce3d_TOSC_56b2e06a-e351-11ed-8c5e-00d86184ce3d_MODEL','b13466fa-e351-11ed-8c5e-00d86184ce3d.zip','b13466fa-e351-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.13.1.1.4\",\"modelMatrix\":\"0.698903,0.680937,-0.218766,0,-0.715216,0.665406,-0.213776,0,1.20293e-09,0.305874,0.952072,0,-29.6438,-3.49753,-9.14026,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-25 12:12:32.321','2023-04-25 10:12:33.572',NULL),('b13485e4-e351-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/6175c1d5-e350-11ed-8c5e-00d86184ce3d/session_71ba03b6-e350-11ed-8c5e-00d86184ce3d/occlusion_71bbf096-e350-11ed-8c5e-00d86184ce3d/scan_56b2e06a-e351-11ed-8c5e-00d86184ce3d/b13485e4-e351-11ed-8c5e-00d86184ce3d.png','PATIENT_6175c1d5-e350-11ed-8c5e-00d86184ce3d_ACT_71ba03b6-e350-11ed-8c5e-00d86184ce3d_SESS_71bbf096-e350-11ed-8c5e-00d86184ce3d_TOSC_56b2e06a-e351-11ed-8c5e-00d86184ce3d_SNAPS','b13485e4-e351-11ed-8c5e-00d86184ce3d.png','b13485e4-e351-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.13.1.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-25 12:12:32.321','2023-04-25 10:12:33.572',NULL),('b1837956-e353-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/6175c1d5-e350-11ed-8c5e-00d86184ce3d/session_ea1c884f-e352-11ed-8c5e-00d86184ce3d/occlusion_ea1f514a-e352-11ed-8c5e-00d86184ce3d/scan_74f81308-e353-11ed-8c5e-00d86184ce3d/b1837956-e353-11ed-8c5e-00d86184ce3d.zip','PATIENT_6175c1d5-e350-11ed-8c5e-00d86184ce3d_ACT_ea1c884f-e352-11ed-8c5e-00d86184ce3d_SESS_ea1f514a-e352-11ed-8c5e-00d86184ce3d_TOSC_74f81308-e353-11ed-8c5e-00d86184ce3d_MODEL','b1837956-e353-11ed-8c5e-00d86184ce3d.zip','b1837956-e353-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.13.2.1.3\",\"modelMatrix\":\"0.587308,0.738386,-0.331444,0,-0.809364,0.535804,-0.24051,0,-1.80756e-08,0.409512,0.912305,0,-29.2535,-7.83249,-5.31629,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-25 12:26:51.832','2023-04-25 10:26:52.607',NULL),('b1838f26-e353-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/6175c1d5-e350-11ed-8c5e-00d86184ce3d/session_ea1c884f-e352-11ed-8c5e-00d86184ce3d/occlusion_ea1f514a-e352-11ed-8c5e-00d86184ce3d/scan_74f81308-e353-11ed-8c5e-00d86184ce3d/b1838f26-e353-11ed-8c5e-00d86184ce3d.png','PATIENT_6175c1d5-e350-11ed-8c5e-00d86184ce3d_ACT_ea1c884f-e352-11ed-8c5e-00d86184ce3d_SESS_ea1f514a-e352-11ed-8c5e-00d86184ce3d_TOSC_74f81308-e353-11ed-8c5e-00d86184ce3d_SNAPS','b1838f26-e353-11ed-8c5e-00d86184ce3d.png','b1838f26-e353-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.13.2.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-25 12:26:51.833','2023-04-25 10:26:52.608',NULL),('b1c0aaef-1a65-11ee-9a4f-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_9f32257c-1a64-11ee-9a4f-a0510b46b473/occlusion_9f33e64c-1a64-11ee-9a4f-a0510b46b473/scan_799d201d-1a65-11ee-9a4f-a0510b46b473/b1c0aaef-1a65-11ee-9a4f-a0510b46b473.zip','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_9f32257c-1a64-11ee-9a4f-a0510b46b473_SESS_9f33e64c-1a64-11ee-9a4f-a0510b46b473_TOSC_799d201d-1a65-11ee-9a4f-a0510b46b473_MODEL','b1c0aaef-1a65-11ee-9a4f-a0510b46b473.zip','b1c0aaef-1a65-11ee-9a4f-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.2.1.3\",\"modelMatrix\":\"0.802227,0.535805,-0.263334,0,-0.597019,0.719972,-0.353847,0,2.1424e-08,0.441081,0.897467,0,-33.9307,-1.76323,-8.66645,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-04 14:24:17.127','2023-07-04 12:24:17.583',NULL),('b1c1ffd6-1a65-11ee-9a4f-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_9f32257c-1a64-11ee-9a4f-a0510b46b473/occlusion_9f33e64c-1a64-11ee-9a4f-a0510b46b473/scan_799d201d-1a65-11ee-9a4f-a0510b46b473/b1c1ffd6-1a65-11ee-9a4f-a0510b46b473.png','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_9f32257c-1a64-11ee-9a4f-a0510b46b473_SESS_9f33e64c-1a64-11ee-9a4f-a0510b46b473_TOSC_799d201d-1a65-11ee-9a4f-a0510b46b473_SNAPS','b1c1ffd6-1a65-11ee-9a4f-a0510b46b473.png','b1c1ffd6-1a65-11ee-9a4f-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.2.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-04 14:24:17.136','2023-07-04 12:24:17.586',NULL),('b1d7b3d1-1035-11ee-895b-a0510b46b473',11,'/home/scan/.data//2023/11/d75719c6-1032-11ee-895b-a0510b46b473/session_6897acc6-1035-11ee-895b-a0510b46b473/occlusion_689aa1f3-1035-11ee-895b-a0510b46b473/scan_6c1dd994-1035-11ee-895b-a0510b46b473/b1d7b3d1-1035-11ee-895b-a0510b46b473.zip','PATIENT_d75719c6-1032-11ee-895b-a0510b46b473_ACT_6897acc6-1035-11ee-895b-a0510b46b473_SESS_689aa1f3-1035-11ee-895b-a0510b46b473_TOSC_6c1dd994-1035-11ee-895b-a0510b46b473_MODEL','b1d7b3d1-1035-11ee-895b-a0510b46b473.zip','b1d7b3d1-1035-11ee-895b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.16.2.1.1\",\"modelMatrix\":\"-0.00396765,0.989936,-0.141461,0,-0.999992,-0.00392775,0.000561272,0,-2.12043e-12,0.141462,0.989944,0,-19.6565,-27.502,-7.18748,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-21 15:15:29.807','2023-06-21 13:15:30.434',NULL),('b1d82fb0-1035-11ee-895b-a0510b46b473',11,'/home/scan/.data//2023/11/d75719c6-1032-11ee-895b-a0510b46b473/session_6897acc6-1035-11ee-895b-a0510b46b473/occlusion_689aa1f3-1035-11ee-895b-a0510b46b473/scan_6c1dd994-1035-11ee-895b-a0510b46b473/b1d82fb0-1035-11ee-895b-a0510b46b473.png','PATIENT_d75719c6-1032-11ee-895b-a0510b46b473_ACT_6897acc6-1035-11ee-895b-a0510b46b473_SESS_689aa1f3-1035-11ee-895b-a0510b46b473_TOSC_6c1dd994-1035-11ee-895b-a0510b46b473_SNAPS','b1d82fb0-1035-11ee-895b-a0510b46b473.png','b1d82fb0-1035-11ee-895b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.16.2.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-21 15:15:29.811','2023-06-21 13:15:30.436',NULL),('b2c33383-2700-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/848c86d9-26fd-11ee-a98e-a0510b46b473/session_8f62cd50-26fd-11ee-a98e-a0510b46b473/occlusion_8f65e2e0-26fd-11ee-a98e-a0510b46b473/scan_65a537c4-2700-11ee-a98e-a0510b46b473/b2c33383-2700-11ee-a98e-a0510b46b473.zip','PATIENT_848c86d9-26fd-11ee-a98e-a0510b46b473_ACT_8f62cd50-26fd-11ee-a98e-a0510b46b473_SESS_8f65e2e0-26fd-11ee-a98e-a0510b46b473_TOSC_65a537c4-2700-11ee-a98e-a0510b46b473_MODEL','b2c33383-2700-11ee-a98e-a0510b46b473.zip','b2c33383-2700-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.36.1.1.7\",\"modelMatrix\":\"0.171733,0.929894,-0.325275,0,-0.985143,0.162102,-0.056703,0,2.15431e-09,0.330181,0.943918,0,-23.8831,-24.7358,-6.02169,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-20 15:24:04.768','2023-07-20 13:24:05.516',NULL),('b2c48da0-2700-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/848c86d9-26fd-11ee-a98e-a0510b46b473/session_8f62cd50-26fd-11ee-a98e-a0510b46b473/occlusion_8f65e2e0-26fd-11ee-a98e-a0510b46b473/scan_65a537c4-2700-11ee-a98e-a0510b46b473/b2c48da0-2700-11ee-a98e-a0510b46b473.png','PATIENT_848c86d9-26fd-11ee-a98e-a0510b46b473_ACT_8f62cd50-26fd-11ee-a98e-a0510b46b473_SESS_8f65e2e0-26fd-11ee-a98e-a0510b46b473_TOSC_65a537c4-2700-11ee-a98e-a0510b46b473_SNAPS','b2c48da0-2700-11ee-a98e-a0510b46b473.png','b2c48da0-2700-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.36.1.1.7 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-20 15:24:04.777','2023-07-20 13:24:05.524',NULL),('b3eb954f-2ae5-11ee-95bc-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_b5fe1002-2ae0-11ee-95bc-a0510b46b473/occlusion_b6012772-2ae0-11ee-95bc-a0510b46b473/scan_78780086-2ae5-11ee-95bc-a0510b46b473/b3eb954f-2ae5-11ee-95bc-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_b5fe1002-2ae0-11ee-95bc-a0510b46b473_SESS_b6012772-2ae0-11ee-95bc-a0510b46b473_TOSC_78780086-2ae5-11ee-95bc-a0510b46b473_MODEL','b3eb954f-2ae5-11ee-95bc-a0510b46b473.zip','b3eb954f-2ae5-11ee-95bc-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.8.1.5\",\"modelMatrix\":\"0.548216,0.774335,-0.316012,0,-0.836337,0.507575,-0.207145,0,1.63969e-08,0.377853,0.925866,0,-29.822,-8.27086,-6.19128,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-25 14:20:54.950','2023-07-25 12:20:55.397',NULL),('b3ec0a35-2ae5-11ee-95bc-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_b5fe1002-2ae0-11ee-95bc-a0510b46b473/occlusion_b6012772-2ae0-11ee-95bc-a0510b46b473/scan_78780086-2ae5-11ee-95bc-a0510b46b473/b3ec0a35-2ae5-11ee-95bc-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_b5fe1002-2ae0-11ee-95bc-a0510b46b473_SESS_b6012772-2ae0-11ee-95bc-a0510b46b473_TOSC_78780086-2ae5-11ee-95bc-a0510b46b473_SNAPS','b3ec0a35-2ae5-11ee-95bc-a0510b46b473.png','b3ec0a35-2ae5-11ee-95bc-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.8.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-25 14:20:54.953','2023-07-25 12:20:55.398',NULL),('b4215126-14e7-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_efcc55aa-14e3-11ee-b3b1-00d86184ce3d/occlusion_efcf357e-14e3-11ee-b3b1-00d86184ce3d/scan_4d4c0ace-14e7-11ee-b3b1-00d86184ce3d/b4215126-14e7-11ee-b3b1-00d86184ce3d.zip','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_efcc55aa-14e3-11ee-b3b1-00d86184ce3d_SESS_efcf357e-14e3-11ee-b3b1-00d86184ce3d_TOSC_4d4c0ace-14e7-11ee-b3b1-00d86184ce3d_MODEL','b4215126-14e7-11ee-b3b1-00d86184ce3d.zip','b4215126-14e7-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.20.3.1.7\",\"modelMatrix\":\"-0.882975,0.469047,-0.0187169,0,-0.46942,-0.882273,0.0352063,0,1.7966e-09,0.0398724,0.999205,0,11.542,-27.1844,-13.1932,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-27 14:39:48.714','2023-06-27 12:39:49.491',NULL),('b421691e-14e7-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_efcc55aa-14e3-11ee-b3b1-00d86184ce3d/occlusion_efcf357e-14e3-11ee-b3b1-00d86184ce3d/scan_4d4c0ace-14e7-11ee-b3b1-00d86184ce3d/b421691e-14e7-11ee-b3b1-00d86184ce3d.png','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_efcc55aa-14e3-11ee-b3b1-00d86184ce3d_SESS_efcf357e-14e3-11ee-b3b1-00d86184ce3d_TOSC_4d4c0ace-14e7-11ee-b3b1-00d86184ce3d_SNAPS','b421691e-14e7-11ee-b3b1-00d86184ce3d.png','b421691e-14e7-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.20.3.1.7 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-27 14:39:48.715','2023-06-27 12:39:49.492',NULL),('b4557b93-de99-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/35e16a68-de95-11ed-9cc3-00d86184ce3d/session_450c29ef-de95-11ed-9cc3-00d86184ce3d/occlusion_450efda8-de95-11ed-9cc3-00d86184ce3d/scan_5633d33f-de99-11ed-9cc3-00d86184ce3d/b4557b93-de99-11ed-9cc3-00d86184ce3d.zip','PATIENT_35e16a68-de95-11ed-9cc3-00d86184ce3d_ACT_450c29ef-de95-11ed-9cc3-00d86184ce3d_SESS_450efda8-de95-11ed-9cc3-00d86184ce3d_TOSC_5633d33f-de99-11ed-9cc3-00d86184ce3d_MODEL','b4557b93-de99-11ed-9cc3-00d86184ce3d.zip','b4557b93-de99-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.4.1.1.6\",\"modelMatrix\":\"-0.218778,0.927144,-0.304205,0,-0.975775,-0.207875,0.0682059,0,-2.1662e-09,0.311758,0.950162,0,-15.9913,-28.7195,-5.54046,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-19 12:05:25.521','2023-04-19 10:05:26.594',NULL),('b455924c-de99-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/35e16a68-de95-11ed-9cc3-00d86184ce3d/session_450c29ef-de95-11ed-9cc3-00d86184ce3d/occlusion_450efda8-de95-11ed-9cc3-00d86184ce3d/scan_5633d33f-de99-11ed-9cc3-00d86184ce3d/b455924c-de99-11ed-9cc3-00d86184ce3d.png','PATIENT_35e16a68-de95-11ed-9cc3-00d86184ce3d_ACT_450c29ef-de95-11ed-9cc3-00d86184ce3d_SESS_450efda8-de95-11ed-9cc3-00d86184ce3d_TOSC_5633d33f-de99-11ed-9cc3-00d86184ce3d_SNAPS','b455924c-de99-11ed-9cc3-00d86184ce3d.png','b455924c-de99-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.4.1.1.6 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-19 12:05:25.522','2023-04-19 10:05:26.595',NULL),('b5183571-e02b-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_ed85304d-e024-11ed-bb13-00d86184ce3d/occlusion_ed88a64f-e024-11ed-bb13-00d86184ce3d/scan_93b6b24f-e02b-11ed-bb13-00d86184ce3d/b5183571-e02b-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_ed85304d-e024-11ed-bb13-00d86184ce3d_SESS_ed88a64f-e024-11ed-bb13-00d86184ce3d_TOSC_93b6b24f-e02b-11ed-bb13-00d86184ce3d_MODEL','b5183571-e02b-11ed-bb13-00d86184ce3d.zip','b5183571-e02b-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.1.1.9\",\"modelMatrix\":\"0.523498,0.758665,-0.387785,0,-0.852027,0.466135,-0.238261,0,5.82151e-09,0.455133,0.890424,0,-19.1439,-14.3371,-4.74983,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 12:03:04.483','2023-04-21 10:03:04.813',NULL),('b5184dd8-e02b-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_ed85304d-e024-11ed-bb13-00d86184ce3d/occlusion_ed88a64f-e024-11ed-bb13-00d86184ce3d/scan_93b6b24f-e02b-11ed-bb13-00d86184ce3d/b5184dd8-e02b-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_ed85304d-e024-11ed-bb13-00d86184ce3d_SESS_ed88a64f-e024-11ed-bb13-00d86184ce3d_TOSC_93b6b24f-e02b-11ed-bb13-00d86184ce3d_SNAPS','b5184dd8-e02b-11ed-bb13-00d86184ce3d.png','b5184dd8-e02b-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.1.1.9 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 12:03:04.483','2023-04-21 10:03:04.817',NULL),('b5d1405a-0f3e-11ee-8712-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_964f8d9e-0f3e-11ee-8712-a0510b46b473/occlusion_965293c3-0f3e-11ee-8712-a0510b46b473/scan_9bda32fa-0f3e-11ee-8712-a0510b46b473/b5d1405a-0f3e-11ee-8712-a0510b46b473.zip','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_964f8d9e-0f3e-11ee-8712-a0510b46b473_SESS_965293c3-0f3e-11ee-8712-a0510b46b473_TOSC_9bda32fa-0f3e-11ee-8712-a0510b46b473_MODEL','b5d1405a-0f3e-11ee-8712-a0510b46b473.zip','b5d1405a-0f3e-11ee-8712-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.1.1.1\",\"modelMatrix\":\"0.948025,-0.306798,0.0843951,0,0.318195,0.914072,-0.251446,0,-2.48072e-09,0.265231,0.964185,0,7.45578,3.70063,-7.64082,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,'2023-06-20 09:57:00.661','2023-06-20 09:47:30.784','2023-06-20 07:57:00.666',NULL),('b5d159db-0f3e-11ee-8712-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_964f8d9e-0f3e-11ee-8712-a0510b46b473/occlusion_965293c3-0f3e-11ee-8712-a0510b46b473/scan_9bda32fa-0f3e-11ee-8712-a0510b46b473/b5d159db-0f3e-11ee-8712-a0510b46b473.png','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_964f8d9e-0f3e-11ee-8712-a0510b46b473_SESS_965293c3-0f3e-11ee-8712-a0510b46b473_TOSC_9bda32fa-0f3e-11ee-8712-a0510b46b473_SNAPS','b5d159db-0f3e-11ee-8712-a0510b46b473.png','b5d159db-0f3e-11ee-8712-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.1.1.1 Snapshot\"}','PNG',0,'CREATED',0,'2023-06-20 09:57:00.661','2023-06-20 09:47:30.784','2023-06-20 07:57:00.670',NULL),('b5ff5371-e352-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/6175c1d5-e350-11ed-8c5e-00d86184ce3d/session_71ba03b6-e350-11ed-8c5e-00d86184ce3d/occlusion_71bbf096-e350-11ed-8c5e-00d86184ce3d/scan_6c45dfd0-e352-11ed-8c5e-00d86184ce3d/b5ff5371-e352-11ed-8c5e-00d86184ce3d.zip','PATIENT_6175c1d5-e350-11ed-8c5e-00d86184ce3d_ACT_71ba03b6-e350-11ed-8c5e-00d86184ce3d_SESS_71bbf096-e350-11ed-8c5e-00d86184ce3d_TOSC_6c45dfd0-e352-11ed-8c5e-00d86184ce3d_MODEL','b5ff5371-e352-11ed-8c5e-00d86184ce3d.zip','b5ff5371-e352-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.13.1.1.7\",\"modelMatrix\":\"0.559979,0.7629,-0.32312,0,-0.828506,0.515637,-0.218394,0,-1.36314e-08,0.390003,0.920813,0,-32.0497,-4.10649,-10.5496,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-25 12:19:49.858','2023-04-25 10:19:50.833',NULL),('b5ff6af6-e352-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/6175c1d5-e350-11ed-8c5e-00d86184ce3d/session_71ba03b6-e350-11ed-8c5e-00d86184ce3d/occlusion_71bbf096-e350-11ed-8c5e-00d86184ce3d/scan_6c45dfd0-e352-11ed-8c5e-00d86184ce3d/b5ff6af6-e352-11ed-8c5e-00d86184ce3d.png','PATIENT_6175c1d5-e350-11ed-8c5e-00d86184ce3d_ACT_71ba03b6-e350-11ed-8c5e-00d86184ce3d_SESS_71bbf096-e350-11ed-8c5e-00d86184ce3d_TOSC_6c45dfd0-e352-11ed-8c5e-00d86184ce3d_SNAPS','b5ff6af6-e352-11ed-8c5e-00d86184ce3d.png','b5ff6af6-e352-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.13.1.1.7 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-25 12:19:49.859','2023-04-25 10:19:50.834',NULL),('b6491a99-e038-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_63b81b7e-e035-11ed-bb13-00d86184ce3d/occlusion_63bb1989-e035-11ed-bb13-00d86184ce3d/scan_67c4bd75-e038-11ed-bb13-00d86184ce3d/b6491a99-e038-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_63b81b7e-e035-11ed-bb13-00d86184ce3d_SESS_63bb1989-e035-11ed-bb13-00d86184ce3d_TOSC_67c4bd75-e038-11ed-bb13-00d86184ce3d_MODEL','b6491a99-e038-11ed-bb13-00d86184ce3d.zip','b6491a99-e038-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.2.1.6\",\"modelMatrix\":\"0.406266,0.835694,-0.369545,0,-0.913755,0.371559,-0.164304,0,-1.12946e-08,0.404425,0.914571,0,-30.4084,-5.67635,-5.37765,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 13:36:09.938','2023-04-21 11:36:10.651',NULL),('b6493237-e038-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_63b81b7e-e035-11ed-bb13-00d86184ce3d/occlusion_63bb1989-e035-11ed-bb13-00d86184ce3d/scan_67c4bd75-e038-11ed-bb13-00d86184ce3d/b6493237-e038-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_63b81b7e-e035-11ed-bb13-00d86184ce3d_SESS_63bb1989-e035-11ed-bb13-00d86184ce3d_TOSC_67c4bd75-e038-11ed-bb13-00d86184ce3d_SNAPS','b6493237-e038-11ed-bb13-00d86184ce3d.png','b6493237-e038-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.2.1.6 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 13:36:09.939','2023-04-21 11:36:10.651',NULL),('b6b3bbde-270a-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_c28d11f3-2706-11ee-a98e-a0510b46b473/occlusion_c2900beb-2706-11ee-a98e-a0510b46b473/scan_4852c1dc-270a-11ee-a98e-a0510b46b473/b6b3bbde-270a-11ee-a98e-a0510b46b473.zip','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_c28d11f3-2706-11ee-a98e-a0510b46b473_SESS_c2900beb-2706-11ee-a98e-a0510b46b473_TOSC_4852c1dc-270a-11ee-a98e-a0510b46b473_MODEL','b6b3bbde-270a-11ee-a98e-a0510b46b473.zip','b6b3bbde-270a-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.3.1.6\",\"modelMatrix\":\"0.00767357,0.967598,-0.25238,0,-0.99997,0.00742515,-0.00193671,0,6.37496e-11,0.252387,0.967626,0,-17.423,-29.1893,-10.0511,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-20 16:35:46.345','2023-07-20 14:35:47.134',NULL),('b6b4386e-270a-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_c28d11f3-2706-11ee-a98e-a0510b46b473/occlusion_c2900beb-2706-11ee-a98e-a0510b46b473/scan_4852c1dc-270a-11ee-a98e-a0510b46b473/b6b4386e-270a-11ee-a98e-a0510b46b473.png','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_c28d11f3-2706-11ee-a98e-a0510b46b473_SESS_c2900beb-2706-11ee-a98e-a0510b46b473_TOSC_4852c1dc-270a-11ee-a98e-a0510b46b473_SNAPS','b6b4386e-270a-11ee-a98e-a0510b46b473.png','b6b4386e-270a-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.3.1.6 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-20 16:35:46.348','2023-07-20 14:35:47.135',NULL),('b7afa8ba-1ca0-11ee-84c4-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_06fff4e1-1ca0-11ee-84c4-a0510b46b473/occlusion_0701c127-1ca0-11ee-84c4-a0510b46b473/scan_6a385516-1ca0-11ee-84c4-a0510b46b473/b7afa8ba-1ca0-11ee-84c4-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_06fff4e1-1ca0-11ee-84c4-a0510b46b473_SESS_0701c127-1ca0-11ee-84c4-a0510b46b473_TOSC_6a385516-1ca0-11ee-84c4-a0510b46b473_MODEL','b7afa8ba-1ca0-11ee-84c4-a0510b46b473.zip','b7afa8ba-1ca0-11ee-84c4-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.1.1.2\",\"modelMatrix\":\"-0.192984,0.966536,-0.169013,0,-0.981202,-0.1901,0.0332417,0,1.80107e-09,0.172251,0.985053,0,-19.441,-23.5108,-9.50381,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-07 10:31:49.715','2023-07-07 08:31:50.381',NULL),('b7afbaf0-1ca0-11ee-84c4-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_06fff4e1-1ca0-11ee-84c4-a0510b46b473/occlusion_0701c127-1ca0-11ee-84c4-a0510b46b473/scan_6a385516-1ca0-11ee-84c4-a0510b46b473/b7afbaf0-1ca0-11ee-84c4-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_06fff4e1-1ca0-11ee-84c4-a0510b46b473_SESS_0701c127-1ca0-11ee-84c4-a0510b46b473_TOSC_6a385516-1ca0-11ee-84c4-a0510b46b473_SNAPS','b7afbaf0-1ca0-11ee-84c4-a0510b46b473.png','b7afbaf0-1ca0-11ee-84c4-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.1.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-07 10:31:49.715','2023-07-07 08:31:50.383',NULL),('b87f2d82-de97-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/35e16a68-de95-11ed-9cc3-00d86184ce3d/session_450c29ef-de95-11ed-9cc3-00d86184ce3d/occlusion_450efda8-de95-11ed-9cc3-00d86184ce3d/scan_6062d660-de97-11ed-9cc3-00d86184ce3d/b87f2d82-de97-11ed-9cc3-00d86184ce3d.zip','PATIENT_35e16a68-de95-11ed-9cc3-00d86184ce3d_ACT_450c29ef-de95-11ed-9cc3-00d86184ce3d_SESS_450efda8-de95-11ed-9cc3-00d86184ce3d_TOSC_6062d660-de97-11ed-9cc3-00d86184ce3d_MODEL','b87f2d82-de97-11ed-9cc3-00d86184ce3d.zip','b87f2d82-de97-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.4.1.1.3\",\"modelMatrix\":\"0.106042,0.941359,-0.320309,0,-0.994362,0.10039,-0.0341589,0,1.53915e-09,0.322125,0.946697,0,-26.0002,-19.1471,-6.42345,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-19 11:51:13.512','2023-04-19 09:51:14.550',NULL),('b88070f0-de97-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/35e16a68-de95-11ed-9cc3-00d86184ce3d/session_450c29ef-de95-11ed-9cc3-00d86184ce3d/occlusion_450efda8-de95-11ed-9cc3-00d86184ce3d/scan_6062d660-de97-11ed-9cc3-00d86184ce3d/b88070f0-de97-11ed-9cc3-00d86184ce3d.png','PATIENT_35e16a68-de95-11ed-9cc3-00d86184ce3d_ACT_450c29ef-de95-11ed-9cc3-00d86184ce3d_SESS_450efda8-de95-11ed-9cc3-00d86184ce3d_TOSC_6062d660-de97-11ed-9cc3-00d86184ce3d_SNAPS','b88070f0-de97-11ed-9cc3-00d86184ce3d.png','b88070f0-de97-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.4.1.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-19 11:51:13.520','2023-04-19 09:51:14.550',NULL),('b90d8ab4-dd00-11ed-8097-00d86184ce3d',11,'/home/scan/.data//2023/11/59af3050-dcfe-11ed-8097-00d86184ce3d/session_61025fcf-dcfe-11ed-8097-00d86184ce3d/occlusion_610548c3-dcfe-11ed-8097-00d86184ce3d/scan_642fea87-dd00-11ed-8097-00d86184ce3d/b90d8ab4-dd00-11ed-8097-00d86184ce3d.zip','PATIENT_59af3050-dcfe-11ed-8097-00d86184ce3d_ACT_61025fcf-dcfe-11ed-8097-00d86184ce3d_SESS_610548c3-dcfe-11ed-8097-00d86184ce3d_TOSC_642fea87-dd00-11ed-8097-00d86184ce3d_MODEL','b90d8ab4-dd00-11ed-8097-00d86184ce3d.zip','b90d8ab4-dd00-11ed-8097-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.1.1.1.4\",\"modelMatrix\":\"-0.246335,0.939705,-0.237221,0,-0.969185,-0.238842,0.0602937,0,1.10066e-10,0.244763,0.969583,0,-16.8565,-28.8216,-6.43251,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-04-17 11:17:49.276','2023-04-17 09:17:50.255','2023-04-17 11:17:50.636'),('b90ec4cd-dd00-11ed-8097-00d86184ce3d',11,'/home/scan/.data//2023/11/59af3050-dcfe-11ed-8097-00d86184ce3d/session_61025fcf-dcfe-11ed-8097-00d86184ce3d/occlusion_610548c3-dcfe-11ed-8097-00d86184ce3d/scan_642fea87-dd00-11ed-8097-00d86184ce3d/b90ec4cd-dd00-11ed-8097-00d86184ce3d.png','PATIENT_59af3050-dcfe-11ed-8097-00d86184ce3d_ACT_61025fcf-dcfe-11ed-8097-00d86184ce3d_SESS_610548c3-dcfe-11ed-8097-00d86184ce3d_TOSC_642fea87-dd00-11ed-8097-00d86184ce3d_SNAPS','b90ec4cd-dd00-11ed-8097-00d86184ce3d.png','b90ec4cd-dd00-11ed-8097-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.1.1.1.4 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-04-17 11:17:49.284','2023-04-17 09:17:50.255','2023-04-17 11:17:50.826'),('b93dbf5e-2abf-11ee-80c8-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_3a881645-2abf-11ee-80c8-a0510b46b473/occlusion_3a8b3537-2abf-11ee-80c8-a0510b46b473/scan_80977c83-2abf-11ee-80c8-a0510b46b473/b93dbf5e-2abf-11ee-80c8-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_3a881645-2abf-11ee-80c8-a0510b46b473_SESS_3a8b3537-2abf-11ee-80c8-a0510b46b473_TOSC_80977c83-2abf-11ee-80c8-a0510b46b473_MODEL','b93dbf5e-2abf-11ee-80c8-a0510b46b473.zip','b93dbf5e-2abf-11ee-80c8-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.7.1.1\",\"modelMatrix\":\"1,0,0,0,0,-1,0,0,0,0,-1,0,-21.3301,-5.80178,15.6769,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,'2023-07-25 09:49:07.612','2023-07-25 09:49:03.001','2023-07-25 07:49:07.617',NULL),('b93dd86a-2abf-11ee-80c8-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_3a881645-2abf-11ee-80c8-a0510b46b473/occlusion_3a8b3537-2abf-11ee-80c8-a0510b46b473/scan_80977c83-2abf-11ee-80c8-a0510b46b473/b93dd86a-2abf-11ee-80c8-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_3a881645-2abf-11ee-80c8-a0510b46b473_SESS_3a8b3537-2abf-11ee-80c8-a0510b46b473_TOSC_80977c83-2abf-11ee-80c8-a0510b46b473_SNAPS','b93dd86a-2abf-11ee-80c8-a0510b46b473.png','b93dd86a-2abf-11ee-80c8-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.7.1.1 Snapshot\"}','PNG',0,'CREATED',0,'2023-07-25 09:49:07.612','2023-07-25 09:49:03.002','2023-07-25 07:49:07.621',NULL),('ba187774-1bda-11ee-9086-a0510b46b473',11,'/home/scan/.data//2023/11/61e16a70-1a76-11ee-8124-a0510b46b473/session_a0a47257-1bd8-11ee-9086-a0510b46b473/occlusion_a0a77bfe-1bd8-11ee-9086-a0510b46b473/scan_5b848959-1bda-11ee-9086-a0510b46b473/ba187774-1bda-11ee-9086-a0510b46b473.zip','PATIENT_61e16a70-1a76-11ee-8124-a0510b46b473_ACT_a0a47257-1bd8-11ee-9086-a0510b46b473_SESS_a0a77bfe-1bd8-11ee-9086-a0510b46b473_TOSC_5b848959-1bda-11ee-9086-a0510b46b473_MODEL','ba187774-1bda-11ee-9086-a0510b46b473.zip','ba187774-1bda-11ee-9086-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.27.3.1.3\",\"modelMatrix\":\"0.933169,0.357861,-0.033634,0,-0.359438,0.929074,-0.0873202,0,-4.23426e-10,0.0935739,0.995612,0,-26.9631,8.45958,-12.1717,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 10:54:33.405','2023-07-06 08:54:34.010',NULL),('ba189374-1bda-11ee-9086-a0510b46b473',11,'/home/scan/.data//2023/11/61e16a70-1a76-11ee-8124-a0510b46b473/session_a0a47257-1bd8-11ee-9086-a0510b46b473/occlusion_a0a77bfe-1bd8-11ee-9086-a0510b46b473/scan_5b848959-1bda-11ee-9086-a0510b46b473/ba189374-1bda-11ee-9086-a0510b46b473.png','PATIENT_61e16a70-1a76-11ee-8124-a0510b46b473_ACT_a0a47257-1bd8-11ee-9086-a0510b46b473_SESS_a0a77bfe-1bd8-11ee-9086-a0510b46b473_TOSC_5b848959-1bda-11ee-9086-a0510b46b473_SNAPS','ba189374-1bda-11ee-9086-a0510b46b473.png','ba189374-1bda-11ee-9086-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.27.3.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 10:54:33.405','2023-07-06 08:54:34.010',NULL),('ba8ab88c-26fe-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/848c86d9-26fd-11ee-a98e-a0510b46b473/session_8f62cd50-26fd-11ee-a98e-a0510b46b473/occlusion_8f65e2e0-26fd-11ee-a98e-a0510b46b473/scan_5e679fd4-26fe-11ee-a98e-a0510b46b473/ba8ab88c-26fe-11ee-a98e-a0510b46b473.zip','PATIENT_848c86d9-26fd-11ee-a98e-a0510b46b473_ACT_8f62cd50-26fd-11ee-a98e-a0510b46b473_SESS_8f65e2e0-26fd-11ee-a98e-a0510b46b473_TOSC_5e679fd4-26fe-11ee-a98e-a0510b46b473_MODEL','ba8ab88c-26fe-11ee-a98e-a0510b46b473.zip','ba8ab88c-26fe-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.36.1.1.3\",\"modelMatrix\":\"-0.142462,0.968213,-0.205594,0,-0.9898,-0.139355,0.0295912,0,-3.01972e-09,0.207712,0.97819,0,-16.2155,-28.7971,-9.58028,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-20 15:09:58.826','2023-07-20 13:09:59.664',NULL),('ba8c0b6c-26fe-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/848c86d9-26fd-11ee-a98e-a0510b46b473/session_8f62cd50-26fd-11ee-a98e-a0510b46b473/occlusion_8f65e2e0-26fd-11ee-a98e-a0510b46b473/scan_5e679fd4-26fe-11ee-a98e-a0510b46b473/ba8c0b6c-26fe-11ee-a98e-a0510b46b473.png','PATIENT_848c86d9-26fd-11ee-a98e-a0510b46b473_ACT_8f62cd50-26fd-11ee-a98e-a0510b46b473_SESS_8f65e2e0-26fd-11ee-a98e-a0510b46b473_TOSC_5e679fd4-26fe-11ee-a98e-a0510b46b473_SNAPS','ba8c0b6c-26fe-11ee-a98e-a0510b46b473.png','ba8c0b6c-26fe-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.36.1.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-20 15:09:58.835','2023-07-20 13:09:59.665',NULL),('bab607bd-10da-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/bd51960a-10d5-11ee-b636-a0510b46b473/session_c5e67f1c-10d5-11ee-b636-a0510b46b473/occlusion_c5e95a7b-10d5-11ee-b636-a0510b46b473/scan_5737fef3-10da-11ee-b636-a0510b46b473/bab607bd-10da-11ee-b636-a0510b46b473.zip','PATIENT_bd51960a-10d5-11ee-b636-a0510b46b473_ACT_c5e67f1c-10d5-11ee-b636-a0510b46b473_SESS_c5e95a7b-10d5-11ee-b636-a0510b46b473_TOSC_5737fef3-10da-11ee-b636-a0510b46b473_MODEL','bab607bd-10da-11ee-b636-a0510b46b473.zip','bab607bd-10da-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.17.1.1.7\",\"modelMatrix\":\"0.264549,0.955603,-0.12976,0,-0.964372,0.262143,-0.035596,0,-5.79954e-11,0.134553,0.990906,0,-20.5558,-24.0836,-10.0492,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 10:56:51.647','2023-06-22 08:56:52.636',NULL),('bab61b6f-10da-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/bd51960a-10d5-11ee-b636-a0510b46b473/session_c5e67f1c-10d5-11ee-b636-a0510b46b473/occlusion_c5e95a7b-10d5-11ee-b636-a0510b46b473/scan_5737fef3-10da-11ee-b636-a0510b46b473/bab61b6f-10da-11ee-b636-a0510b46b473.png','PATIENT_bd51960a-10d5-11ee-b636-a0510b46b473_ACT_c5e67f1c-10d5-11ee-b636-a0510b46b473_SESS_c5e95a7b-10d5-11ee-b636-a0510b46b473_TOSC_5737fef3-10da-11ee-b636-a0510b46b473_SNAPS','bab61b6f-10da-11ee-b636-a0510b46b473.png','bab61b6f-10da-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.17.1.1.7 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 10:56:51.647','2023-06-22 08:56:52.637',NULL),('baf2f7bf-e34a-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/971e14b0-e348-11ed-8c5e-00d86184ce3d/session_a0fbda94-e348-11ed-8c5e-00d86184ce3d/occlusion_a0febadb-e348-11ed-8c5e-00d86184ce3d/scan_6a0d9a25-e34a-11ed-8c5e-00d86184ce3d/baf2f7bf-e34a-11ed-8c5e-00d86184ce3d.zip','PATIENT_971e14b0-e348-11ed-8c5e-00d86184ce3d_ACT_a0fbda94-e348-11ed-8c5e-00d86184ce3d_SESS_a0febadb-e348-11ed-8c5e-00d86184ce3d_TOSC_6a0d9a25-e34a-11ed-8c5e-00d86184ce3d_MODEL','baf2f7bf-e34a-11ed-8c5e-00d86184ce3d.zip','baf2f7bf-e34a-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.12.1.1.6\",\"modelMatrix\":\"0.255472,0.933922,-0.250048,0,-0.966817,0.24678,-0.0660728,0,-2.9378e-09,0.258631,0.965976,0,-29.6783,-13.5021,-8.11456,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-25 11:22:42.192','2023-04-25 09:22:43.089',NULL),('baf3860f-e34a-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/971e14b0-e348-11ed-8c5e-00d86184ce3d/session_a0fbda94-e348-11ed-8c5e-00d86184ce3d/occlusion_a0febadb-e348-11ed-8c5e-00d86184ce3d/scan_6a0d9a25-e34a-11ed-8c5e-00d86184ce3d/baf3860f-e34a-11ed-8c5e-00d86184ce3d.png','PATIENT_971e14b0-e348-11ed-8c5e-00d86184ce3d_ACT_a0fbda94-e348-11ed-8c5e-00d86184ce3d_SESS_a0febadb-e348-11ed-8c5e-00d86184ce3d_TOSC_6a0d9a25-e34a-11ed-8c5e-00d86184ce3d_SNAPS','baf3860f-e34a-11ed-8c5e-00d86184ce3d.png','baf3860f-e34a-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.12.1.1.6 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-25 11:22:42.196','2023-04-25 09:22:43.092',NULL),('bb34f160-df84-11ed-b6c2-00d86184ce3d',11,'/home/scan/.data//2023/11/ee09109f-df83-11ed-b6c2-00d86184ce3d/session_f3d790be-df83-11ed-b6c2-00d86184ce3d/occlusion_f3d9f61c-df83-11ed-b6c2-00d86184ce3d/scan_5a0453ee-df84-11ed-b6c2-00d86184ce3d/bb34f160-df84-11ed-b6c2-00d86184ce3d.zip','PATIENT_ee09109f-df83-11ed-b6c2-00d86184ce3d_ACT_f3d790be-df83-11ed-b6c2-00d86184ce3d_SESS_f3d9f61c-df83-11ed-b6c2-00d86184ce3d_TOSC_5a0453ee-df84-11ed-b6c2-00d86184ce3d_MODEL','bb34f160-df84-11ed-b6c2-00d86184ce3d.zip','bb34f160-df84-11ed-b6c2-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.8.1.1.2\",\"modelMatrix\":\"0.72475,0.617196,-0.306279,0,-0.689012,0.649209,-0.322166,0,-3.3162e-09,0.44452,0.895769,0,-27.3922,-8.44648,-6.27545,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-20 16:07:48.784','2023-04-20 14:07:49.683',NULL),('bb357731-df84-11ed-b6c2-00d86184ce3d',11,'/home/scan/.data//2023/11/ee09109f-df83-11ed-b6c2-00d86184ce3d/session_f3d790be-df83-11ed-b6c2-00d86184ce3d/occlusion_f3d9f61c-df83-11ed-b6c2-00d86184ce3d/scan_5a0453ee-df84-11ed-b6c2-00d86184ce3d/bb357731-df84-11ed-b6c2-00d86184ce3d.png','PATIENT_ee09109f-df83-11ed-b6c2-00d86184ce3d_ACT_f3d790be-df83-11ed-b6c2-00d86184ce3d_SESS_f3d9f61c-df83-11ed-b6c2-00d86184ce3d_TOSC_5a0453ee-df84-11ed-b6c2-00d86184ce3d_SNAPS','bb357731-df84-11ed-b6c2-00d86184ce3d.png','bb357731-df84-11ed-b6c2-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.8.1.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-20 16:07:48.787','2023-04-20 14:07:49.683',NULL),('bba08fe1-2ac4-11ee-80c8-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_3a881645-2abf-11ee-80c8-a0510b46b473/occlusion_3a8b3537-2abf-11ee-80c8-a0510b46b473/scan_86351fdc-2ac4-11ee-80c8-a0510b46b473/bba08fe1-2ac4-11ee-80c8-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_3a881645-2abf-11ee-80c8-a0510b46b473_SESS_3a8b3537-2abf-11ee-80c8-a0510b46b473_TOSC_86351fdc-2ac4-11ee-80c8-a0510b46b473_MODEL','bba08fe1-2ac4-11ee-80c8-a0510b46b473.zip','bba08fe1-2ac4-11ee-80c8-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.7.1.12\",\"modelMatrix\":\"0.414215,0.872276,-0.259923,0,-0.910179,0.396966,-0.118289,0,-4.09859e-09,0.285573,0.958357,0,-15.5846,0.0490713,-12.0901,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-25 10:24:54.488','2023-07-25 08:24:55.006',NULL),('bba0a80f-2ac4-11ee-80c8-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_3a881645-2abf-11ee-80c8-a0510b46b473/occlusion_3a8b3537-2abf-11ee-80c8-a0510b46b473/scan_86351fdc-2ac4-11ee-80c8-a0510b46b473/bba0a80f-2ac4-11ee-80c8-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_3a881645-2abf-11ee-80c8-a0510b46b473_SESS_3a8b3537-2abf-11ee-80c8-a0510b46b473_TOSC_86351fdc-2ac4-11ee-80c8-a0510b46b473_SNAPS','bba0a80f-2ac4-11ee-80c8-a0510b46b473.png','bba0a80f-2ac4-11ee-80c8-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.7.1.12 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-25 10:24:54.488','2023-07-25 08:24:55.007',NULL),('bcb20940-1bfa-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/8a8cc548-1bf9-11ee-9323-a0510b46b473/session_976f015a-1bf9-11ee-9323-a0510b46b473/occlusion_97713d19-1bf9-11ee-9323-a0510b46b473/scan_67d1c368-1bfa-11ee-9323-a0510b46b473/bcb20940-1bfa-11ee-9323-a0510b46b473.zip','PATIENT_8a8cc548-1bf9-11ee-9323-a0510b46b473_ACT_976f015a-1bf9-11ee-9323-a0510b46b473_SESS_97713d19-1bf9-11ee-9323-a0510b46b473_TOSC_67d1c368-1bfa-11ee-9323-a0510b46b473_MODEL','bcb20940-1bfa-11ee-9323-a0510b46b473.zip','bcb20940-1bfa-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.28.1.1.3\",\"modelMatrix\":\"0.4898,0.867095,-0.0907893,0,-0.871835,0.487137,-0.0510057,0,-2.68658e-10,0.104136,0.994563,0,-26.7212,-2.13908,-10.0147,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 14:43:41.662','2023-07-06 12:43:42.458',NULL),('bcb21c57-1bfa-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/8a8cc548-1bf9-11ee-9323-a0510b46b473/session_976f015a-1bf9-11ee-9323-a0510b46b473/occlusion_97713d19-1bf9-11ee-9323-a0510b46b473/scan_67d1c368-1bfa-11ee-9323-a0510b46b473/bcb21c57-1bfa-11ee-9323-a0510b46b473.png','PATIENT_8a8cc548-1bf9-11ee-9323-a0510b46b473_ACT_976f015a-1bf9-11ee-9323-a0510b46b473_SESS_97713d19-1bf9-11ee-9323-a0510b46b473_TOSC_67d1c368-1bfa-11ee-9323-a0510b46b473_SNAPS','bcb21c57-1bfa-11ee-9323-a0510b46b473.png','bcb21c57-1bfa-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.28.1.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 14:43:41.662','2023-07-06 12:43:42.462',NULL),('bd0fae84-0f40-11ee-8712-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_964f8d9e-0f3e-11ee-8712-a0510b46b473/occlusion_965293c3-0f3e-11ee-8712-a0510b46b473/scan_66b1d8bf-0f40-11ee-8712-a0510b46b473/bd0fae84-0f40-11ee-8712-a0510b46b473.zip','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_964f8d9e-0f3e-11ee-8712-a0510b46b473_SESS_965293c3-0f3e-11ee-8712-a0510b46b473_TOSC_66b1d8bf-0f40-11ee-8712-a0510b46b473_MODEL','bd0fae84-0f40-11ee-8712-a0510b46b473.zip','bd0fae84-0f40-11ee-8712-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.1.1.6\",\"modelMatrix\":\"0.465103,0.836459,-0.289854,0,-0.885257,0.439465,-0.152286,0,-1.14358e-08,0.327424,0.944878,0,-28.3763,-14.0437,-7.71776,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-20 10:02:01.931','2023-06-20 08:02:02.643',NULL),('bd0fc640-0f40-11ee-8712-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_964f8d9e-0f3e-11ee-8712-a0510b46b473/occlusion_965293c3-0f3e-11ee-8712-a0510b46b473/scan_66b1d8bf-0f40-11ee-8712-a0510b46b473/bd0fc640-0f40-11ee-8712-a0510b46b473.png','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_964f8d9e-0f3e-11ee-8712-a0510b46b473_SESS_965293c3-0f3e-11ee-8712-a0510b46b473_TOSC_66b1d8bf-0f40-11ee-8712-a0510b46b473_SNAPS','bd0fc640-0f40-11ee-8712-a0510b46b473.png','bd0fc640-0f40-11ee-8712-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.1.1.6 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-20 10:02:01.931','2023-06-20 08:02:02.651',NULL),('bd5cc690-e350-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/6175c1d5-e350-11ed-8c5e-00d86184ce3d/session_71ba03b6-e350-11ed-8c5e-00d86184ce3d/occlusion_71bbf096-e350-11ed-8c5e-00d86184ce3d/scan_7327c66d-e350-11ed-8c5e-00d86184ce3d/bd5cc690-e350-11ed-8c5e-00d86184ce3d.zip','PATIENT_6175c1d5-e350-11ed-8c5e-00d86184ce3d_ACT_71ba03b6-e350-11ed-8c5e-00d86184ce3d_SESS_71bbf096-e350-11ed-8c5e-00d86184ce3d_TOSC_7327c66d-e350-11ed-8c5e-00d86184ce3d_MODEL','bd5cc690-e350-11ed-8c5e-00d86184ce3d.zip','bd5cc690-e350-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.13.1.1.1\",\"modelMatrix\":\"0.334316,0.902824,-0.270449,0,-0.942461,0.320255,-0.0959353,0,1.14238e-09,0.28696,0.957943,0,-30.2716,-10.9926,-7.92807,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-25 12:05:43.221','2023-04-25 10:05:44.160',NULL),('bd5cd586-e350-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/6175c1d5-e350-11ed-8c5e-00d86184ce3d/session_71ba03b6-e350-11ed-8c5e-00d86184ce3d/occlusion_71bbf096-e350-11ed-8c5e-00d86184ce3d/scan_7327c66d-e350-11ed-8c5e-00d86184ce3d/bd5cd586-e350-11ed-8c5e-00d86184ce3d.png','PATIENT_6175c1d5-e350-11ed-8c5e-00d86184ce3d_ACT_71ba03b6-e350-11ed-8c5e-00d86184ce3d_SESS_71bbf096-e350-11ed-8c5e-00d86184ce3d_TOSC_7327c66d-e350-11ed-8c5e-00d86184ce3d_SNAPS','bd5cd586-e350-11ed-8c5e-00d86184ce3d.png','bd5cd586-e350-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.13.1.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-25 12:05:43.222','2023-04-25 10:05:44.161',NULL),('bdf70264-e34e-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/971e14b0-e348-11ed-8c5e-00d86184ce3d/session_605503de-e34e-11ed-8c5e-00d86184ce3d/occlusion_6058594e-e34e-11ed-8c5e-00d86184ce3d/scan_682dc48b-e34e-11ed-8c5e-00d86184ce3d/bdf70264-e34e-11ed-8c5e-00d86184ce3d.zip','PATIENT_971e14b0-e348-11ed-8c5e-00d86184ce3d_ACT_605503de-e34e-11ed-8c5e-00d86184ce3d_SESS_6058594e-e34e-11ed-8c5e-00d86184ce3d_TOSC_682dc48b-e34e-11ed-8c5e-00d86184ce3d_MODEL','bdf70264-e34e-11ed-8c5e-00d86184ce3d.zip','bdf70264-e34e-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.12.3.1.1\",\"modelMatrix\":\"0.682703,0.642754,-0.347539,0,-0.730696,0.600538,-0.324712,0,-1.29351e-08,0.475627,0.879647,0,-31.3779,-2.4408,-6.85887,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-25 11:51:25.239','2023-04-25 09:51:25.921',NULL),('bdf7175e-e34e-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/971e14b0-e348-11ed-8c5e-00d86184ce3d/session_605503de-e34e-11ed-8c5e-00d86184ce3d/occlusion_6058594e-e34e-11ed-8c5e-00d86184ce3d/scan_682dc48b-e34e-11ed-8c5e-00d86184ce3d/bdf7175e-e34e-11ed-8c5e-00d86184ce3d.png','PATIENT_971e14b0-e348-11ed-8c5e-00d86184ce3d_ACT_605503de-e34e-11ed-8c5e-00d86184ce3d_SESS_6058594e-e34e-11ed-8c5e-00d86184ce3d_TOSC_682dc48b-e34e-11ed-8c5e-00d86184ce3d_SNAPS','bdf7175e-e34e-11ed-8c5e-00d86184ce3d.png','bdf7175e-e34e-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.12.3.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-25 11:51:25.239','2023-04-25 09:51:25.921',NULL),('bf00b6ac-26e5-11ee-a836-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_d5ef2d6b-26e3-11ee-a836-a0510b46b473/occlusion_d5f241c9-26e3-11ee-a836-a0510b46b473/scan_72927001-26e5-11ee-a836-a0510b46b473/bf00b6ac-26e5-11ee-a836-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_d5ef2d6b-26e3-11ee-a836-a0510b46b473_SESS_d5f241c9-26e3-11ee-a836-a0510b46b473_TOSC_72927001-26e5-11ee-a836-a0510b46b473_MODEL','bf00b6ac-26e5-11ee-a836-a0510b46b473.zip','bf00b6ac-26e5-11ee-a836-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.5.1.5\",\"modelMatrix\":\"-0.349163,0.901367,-0.256169,0,-0.937062,-0.335863,0.0954525,0,1.29159e-09,0.273375,0.961907,0,-10.4223,-32.5726,-5.56986,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-20 12:11:08.892','2023-07-20 10:11:09.635',NULL),('bf01f775-26e5-11ee-a836-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_d5ef2d6b-26e3-11ee-a836-a0510b46b473/occlusion_d5f241c9-26e3-11ee-a836-a0510b46b473/scan_72927001-26e5-11ee-a836-a0510b46b473/bf01f775-26e5-11ee-a836-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_d5ef2d6b-26e3-11ee-a836-a0510b46b473_SESS_d5f241c9-26e3-11ee-a836-a0510b46b473_TOSC_72927001-26e5-11ee-a836-a0510b46b473_SNAPS','bf01f775-26e5-11ee-a836-a0510b46b473.png','bf01f775-26e5-11ee-a836-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.5.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-20 12:11:08.900','2023-07-20 10:11:09.641',NULL),('bf2940a9-1fe9-11ee-b7d5-a0510b46b473',11,'/home/scan/.data//2023/11/6a143ccb-1fe8-11ee-b7d5-a0510b46b473/session_7758b704-1fe8-11ee-b7d5-a0510b46b473/occlusion_775bad6c-1fe8-11ee-b7d5-a0510b46b473/scan_8b2fd266-1fe9-11ee-b7d5-a0510b46b473/bf2940a9-1fe9-11ee-b7d5-a0510b46b473.zip','PATIENT_6a143ccb-1fe8-11ee-b7d5-a0510b46b473_ACT_7758b704-1fe8-11ee-b7d5-a0510b46b473_SESS_775bad6c-1fe8-11ee-b7d5-a0510b46b473_BOSC_8b2fd266-1fe9-11ee-b7d5-a0510b46b473_MODEL','bf2940a9-1fe9-11ee-b7d5-a0510b46b473.zip','bf2940a9-1fe9-11ee-b7d5-a0510b46b473','{\"displayTitle\":\"Mandibule 1.32.1.1.2\",\"modelMatrix\":\"0.800818,0.468807,-0.372708,0,-0.598908,0.626856,-0.498358,0,1.03093e-10,0.622312,0.78277,0,-29.7127,-13.531,-8.68082,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-11 14:52:09.005','2023-07-11 12:52:11.198',NULL),('bf295830-1fe9-11ee-b7d5-a0510b46b473',11,'/home/scan/.data//2023/11/6a143ccb-1fe8-11ee-b7d5-a0510b46b473/session_7758b704-1fe8-11ee-b7d5-a0510b46b473/occlusion_775bad6c-1fe8-11ee-b7d5-a0510b46b473/scan_8b2fd266-1fe9-11ee-b7d5-a0510b46b473/bf295830-1fe9-11ee-b7d5-a0510b46b473.png','PATIENT_6a143ccb-1fe8-11ee-b7d5-a0510b46b473_ACT_7758b704-1fe8-11ee-b7d5-a0510b46b473_SESS_775bad6c-1fe8-11ee-b7d5-a0510b46b473_BOSC_8b2fd266-1fe9-11ee-b7d5-a0510b46b473_SNAPS','bf295830-1fe9-11ee-b7d5-a0510b46b473.png','bf295830-1fe9-11ee-b7d5-a0510b46b473','{\"displayTitle\":\"Mandibule 1.32.1.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-11 14:52:09.006','2023-07-11 12:52:11.198',NULL),('bf38faa2-e354-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/6175c1d5-e350-11ed-8c5e-00d86184ce3d/session_71ba03b6-e350-11ed-8c5e-00d86184ce3d/occlusion_71bbf096-e350-11ed-8c5e-00d86184ce3d/scan_75ebc91b-e354-11ed-8c5e-00d86184ce3d/bf38faa2-e354-11ed-8c5e-00d86184ce3d.zip','PATIENT_6175c1d5-e350-11ed-8c5e-00d86184ce3d_ACT_71ba03b6-e350-11ed-8c5e-00d86184ce3d_SESS_71bbf096-e350-11ed-8c5e-00d86184ce3d_TOSC_75ebc91b-e354-11ed-8c5e-00d86184ce3d_MODEL','bf38faa2-e354-11ed-8c5e-00d86184ce3d.zip','bf38faa2-e354-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.13.1.1.8\",\"modelMatrix\":\"0.468904,0.863483,-0.18581,0,-0.883249,0.458411,-0.098644,0,9.39765e-10,0.210371,0.977622,0,-29.0632,-12.3992,-9.5556,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-25 12:34:24.329','2023-04-25 10:34:25.278',NULL),('bf391587-e354-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/6175c1d5-e350-11ed-8c5e-00d86184ce3d/session_71ba03b6-e350-11ed-8c5e-00d86184ce3d/occlusion_71bbf096-e350-11ed-8c5e-00d86184ce3d/scan_75ebc91b-e354-11ed-8c5e-00d86184ce3d/bf391587-e354-11ed-8c5e-00d86184ce3d.png','PATIENT_6175c1d5-e350-11ed-8c5e-00d86184ce3d_ACT_71ba03b6-e350-11ed-8c5e-00d86184ce3d_SESS_71bbf096-e350-11ed-8c5e-00d86184ce3d_TOSC_75ebc91b-e354-11ed-8c5e-00d86184ce3d_SNAPS','bf391587-e354-11ed-8c5e-00d86184ce3d.png','bf391587-e354-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.13.1.1.8 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-25 12:34:24.330','2023-04-25 10:34:25.278',NULL),('bff750a3-1caf-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/4375c5f1-1cad-11ee-997b-a0510b46b473/session_4a5f2876-1cad-11ee-997b-a0510b46b473/occlusion_4a624109-1cad-11ee-997b-a0510b46b473/scan_6c9f3e6e-1caf-11ee-997b-a0510b46b473/bff750a3-1caf-11ee-997b-a0510b46b473.zip','PATIENT_4375c5f1-1cad-11ee-997b-a0510b46b473_ACT_4a5f2876-1cad-11ee-997b-a0510b46b473_SESS_4a624109-1cad-11ee-997b-a0510b46b473_TOSC_6c9f3e6e-1caf-11ee-997b-a0510b46b473_MODEL','bff750a3-1caf-11ee-997b-a0510b46b473.zip','bff750a3-1caf-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.31.1.1.5\",\"modelMatrix\":\"0.989866,-0.140195,0.0225855,0,0.142003,0.977266,-0.157437,0,-2.33928e-10,0.159049,0.987271,0,-23.4261,23.329,-11.4677,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-07 12:19:26.057','2023-07-07 10:19:26.762',NULL),('bff7668f-1caf-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/4375c5f1-1cad-11ee-997b-a0510b46b473/session_4a5f2876-1cad-11ee-997b-a0510b46b473/occlusion_4a624109-1cad-11ee-997b-a0510b46b473/scan_6c9f3e6e-1caf-11ee-997b-a0510b46b473/bff7668f-1caf-11ee-997b-a0510b46b473.png','PATIENT_4375c5f1-1cad-11ee-997b-a0510b46b473_ACT_4a5f2876-1cad-11ee-997b-a0510b46b473_SESS_4a624109-1cad-11ee-997b-a0510b46b473_TOSC_6c9f3e6e-1caf-11ee-997b-a0510b46b473_SNAPS','bff7668f-1caf-11ee-997b-a0510b46b473.png','bff7668f-1caf-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.31.1.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-07 12:19:26.058','2023-07-07 10:19:26.763',NULL),('c0460508-e03b-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_6f09f9a8-e03a-11ed-bb13-00d86184ce3d/occlusion_6f0c3cda-e03a-11ed-bb13-00d86184ce3d/scan_a39de783-e03b-11ed-bb13-00d86184ce3d/c0460508-e03b-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_6f09f9a8-e03a-11ed-bb13-00d86184ce3d_SESS_6f0c3cda-e03a-11ed-bb13-00d86184ce3d_TOSC_a39de783-e03b-11ed-bb13-00d86184ce3d_MODEL','c0460508-e03b-11ed-bb13-00d86184ce3d.zip','c0460508-e03b-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.3.1.5\",\"modelMatrix\":\"0.999381,0.0275006,-0.0219217,0,-0.0351688,0.781477,-0.622943,0,-1.47866e-09,0.623328,0.78196,0,-5.32469,-8.42691,-14.9003,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,'2023-04-21 14:03:37.060','2023-04-21 13:57:55.186','2023-04-21 12:03:37.064',NULL),('c0462398-e03b-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_6f09f9a8-e03a-11ed-bb13-00d86184ce3d/occlusion_6f0c3cda-e03a-11ed-bb13-00d86184ce3d/scan_a39de783-e03b-11ed-bb13-00d86184ce3d/c0462398-e03b-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_6f09f9a8-e03a-11ed-bb13-00d86184ce3d_SESS_6f0c3cda-e03a-11ed-bb13-00d86184ce3d_TOSC_a39de783-e03b-11ed-bb13-00d86184ce3d_SNAPS','c0462398-e03b-11ed-bb13-00d86184ce3d.png','c0462398-e03b-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.3.1.5 Snapshot\"}','PNG',0,'CREATED',0,'2023-04-21 14:03:37.060','2023-04-21 13:57:55.186','2023-04-21 12:03:37.068',NULL),('c06c90f5-270b-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_c28d11f3-2706-11ee-a98e-a0510b46b473/occlusion_c2900beb-2706-11ee-a98e-a0510b46b473/scan_59311257-270b-11ee-a98e-a0510b46b473/c06c90f5-270b-11ee-a98e-a0510b46b473.zip','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_c28d11f3-2706-11ee-a98e-a0510b46b473_SESS_c2900beb-2706-11ee-a98e-a0510b46b473_TOSC_59311257-270b-11ee-a98e-a0510b46b473_MODEL','c06c90f5-270b-11ee-a98e-a0510b46b473.zip','c06c90f5-270b-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.3.1.8\",\"modelMatrix\":\"0.120915,0.944334,-0.305962,0,-0.992663,0.115028,-0.0372687,0,-2.60909e-10,0.308223,0.951314,0,-23.7665,-17.1088,-9.92951,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-20 16:43:12.152','2023-07-20 14:43:13.059',NULL),('c06dd152-270b-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_c28d11f3-2706-11ee-a98e-a0510b46b473/occlusion_c2900beb-2706-11ee-a98e-a0510b46b473/scan_59311257-270b-11ee-a98e-a0510b46b473/c06dd152-270b-11ee-a98e-a0510b46b473.png','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_c28d11f3-2706-11ee-a98e-a0510b46b473_SESS_c2900beb-2706-11ee-a98e-a0510b46b473_TOSC_59311257-270b-11ee-a98e-a0510b46b473_SNAPS','c06dd152-270b-11ee-a98e-a0510b46b473.png','c06dd152-270b-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.3.1.8 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-20 16:43:12.161','2023-07-20 14:43:13.060',NULL),('c09cce0d-2a39-11ee-9e90-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_b144ba33-2a36-11ee-9e90-a0510b46b473/occlusion_b147bba1-2a36-11ee-9e90-a0510b46b473/scan_80f823c7-2a39-11ee-9e90-a0510b46b473/c09cce0d-2a39-11ee-9e90-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_b144ba33-2a36-11ee-9e90-a0510b46b473_SESS_b147bba1-2a36-11ee-9e90-a0510b46b473_TOSC_80f823c7-2a39-11ee-9e90-a0510b46b473_MODEL','c09cce0d-2a39-11ee-9e90-a0510b46b473.zip','c09cce0d-2a39-11ee-9e90-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.6.1.4\",\"modelMatrix\":\"0.965955,0.242438,-0.0902995,0,-0.258709,0.905205,-0.337157,0,9.23865e-11,0.34904,0.937108,0,-23.8235,10.9635,-13.5816,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,'2023-07-24 18:27:28.634','2023-07-24 17:50:02.806','2023-07-24 16:27:28.639',NULL),('c09ce5d7-2a39-11ee-9e90-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_b144ba33-2a36-11ee-9e90-a0510b46b473/occlusion_b147bba1-2a36-11ee-9e90-a0510b46b473/scan_80f823c7-2a39-11ee-9e90-a0510b46b473/c09ce5d7-2a39-11ee-9e90-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_b144ba33-2a36-11ee-9e90-a0510b46b473_SESS_b147bba1-2a36-11ee-9e90-a0510b46b473_TOSC_80f823c7-2a39-11ee-9e90-a0510b46b473_SNAPS','c09ce5d7-2a39-11ee-9e90-a0510b46b473.png','c09ce5d7-2a39-11ee-9e90-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.6.1.4 Snapshot\"}','PNG',0,'CREATED',0,'2023-07-24 18:27:28.634','2023-07-24 17:50:02.807','2023-07-24 16:27:28.643',NULL),('c0d7f432-1c06-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/ae8bd11e-1c05-11ee-9323-a0510b46b473/session_bb436bde-1c05-11ee-9323-a0510b46b473/occlusion_bb465a1e-1c05-11ee-9323-a0510b46b473/scan_70d3caa1-1c06-11ee-9323-a0510b46b473/c0d7f432-1c06-11ee-9323-a0510b46b473.zip','PATIENT_ae8bd11e-1c05-11ee-9323-a0510b46b473_ACT_bb436bde-1c05-11ee-9323-a0510b46b473_SESS_bb465a1e-1c05-11ee-9323-a0510b46b473_TOSC_70d3caa1-1c06-11ee-9323-a0510b46b473_MODEL','c0d7f432-1c06-11ee-9323-a0510b46b473.zip','c0d7f432-1c06-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.29.1.1.3\",\"modelMatrix\":\"0.71276,0.681431,-0.166208,0,-0.701408,0.69246,-0.168898,0,-3.16051e-09,0.236963,0.971519,0,-31.9571,-6.81272,-9.36058,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 16:09:42.582','2023-07-06 14:09:43.313',NULL),('c0d8090e-1c06-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/ae8bd11e-1c05-11ee-9323-a0510b46b473/session_bb436bde-1c05-11ee-9323-a0510b46b473/occlusion_bb465a1e-1c05-11ee-9323-a0510b46b473/scan_70d3caa1-1c06-11ee-9323-a0510b46b473/c0d8090e-1c06-11ee-9323-a0510b46b473.png','PATIENT_ae8bd11e-1c05-11ee-9323-a0510b46b473_ACT_bb436bde-1c05-11ee-9323-a0510b46b473_SESS_bb465a1e-1c05-11ee-9323-a0510b46b473_TOSC_70d3caa1-1c06-11ee-9323-a0510b46b473_SNAPS','c0d8090e-1c06-11ee-9323-a0510b46b473.png','c0d8090e-1c06-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.29.1.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 16:09:42.582','2023-07-06 14:09:43.313',NULL),('c0e7fd63-e03c-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_6f09f9a8-e03a-11ed-bb13-00d86184ce3d/occlusion_6f0c3cda-e03a-11ed-bb13-00d86184ce3d/scan_a0ee9018-e03c-11ed-bb13-00d86184ce3d/c0e7fd63-e03c-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_6f09f9a8-e03a-11ed-bb13-00d86184ce3d_SESS_6f0c3cda-e03a-11ed-bb13-00d86184ce3d_TOSC_a0ee9018-e03c-11ed-bb13-00d86184ce3d_MODEL','c0e7fd63-e03c-11ed-bb13-00d86184ce3d.zip','c0e7fd63-e03c-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.3.1.10\",\"modelMatrix\":\"0.868816,0.400094,-0.29169,0,-0.495135,0.702048,-0.511831,0,1.49739e-09,0.589113,0.808051,0,-21.6083,-10.1446,-6.19202,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 14:05:05.744','2023-04-21 12:05:06.054',NULL),('c0e814e1-e03c-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_6f09f9a8-e03a-11ed-bb13-00d86184ce3d/occlusion_6f0c3cda-e03a-11ed-bb13-00d86184ce3d/scan_a0ee9018-e03c-11ed-bb13-00d86184ce3d/c0e814e1-e03c-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_6f09f9a8-e03a-11ed-bb13-00d86184ce3d_SESS_6f0c3cda-e03a-11ed-bb13-00d86184ce3d_TOSC_a0ee9018-e03c-11ed-bb13-00d86184ce3d_SNAPS','c0e814e1-e03c-11ed-bb13-00d86184ce3d.png','c0e814e1-e03c-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.3.1.10 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 14:05:05.744','2023-04-21 12:05:06.054',NULL),('c104cec3-1104-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_0628a8e9-1104-11ee-b636-a0510b46b473/occlusion_062b833f-1104-11ee-b636-a0510b46b473/scan_55354f88-1104-11ee-b636-a0510b46b473/c104cec3-1104-11ee-b636-a0510b46b473.zip','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_0628a8e9-1104-11ee-b636-a0510b46b473_SESS_062b833f-1104-11ee-b636-a0510b46b473_TOSC_55354f88-1104-11ee-b636-a0510b46b473_MODEL','c104cec3-1104-11ee-b636-a0510b46b473.zip','c104cec3-1104-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.20.1.1.1\",\"modelMatrix\":\"0.371289,0.91508,-0.157396,0,-0.928518,0.365915,-0.0629384,0,4.52425e-09,0.169514,0.985528,0,-23.5041,-12.1255,-11.628,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 15:57:41.092','2023-06-22 13:57:41.873',NULL),('c104e659-1104-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_0628a8e9-1104-11ee-b636-a0510b46b473/occlusion_062b833f-1104-11ee-b636-a0510b46b473/scan_55354f88-1104-11ee-b636-a0510b46b473/c104e659-1104-11ee-b636-a0510b46b473.png','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_0628a8e9-1104-11ee-b636-a0510b46b473_SESS_062b833f-1104-11ee-b636-a0510b46b473_TOSC_55354f88-1104-11ee-b636-a0510b46b473_SNAPS','c104e659-1104-11ee-b636-a0510b46b473.png','c104e659-1104-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.20.1.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 15:57:41.092','2023-06-22 13:57:41.874',NULL),('c2c7e958-1ca1-11ee-84c4-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_06fff4e1-1ca0-11ee-84c4-a0510b46b473/occlusion_0701c127-1ca0-11ee-84c4-a0510b46b473/scan_653a8ba5-1ca1-11ee-84c4-a0510b46b473/c2c7e958-1ca1-11ee-84c4-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_06fff4e1-1ca0-11ee-84c4-a0510b46b473_SESS_0701c127-1ca0-11ee-84c4-a0510b46b473_TOSC_653a8ba5-1ca1-11ee-84c4-a0510b46b473_MODEL','c2c7e958-1ca1-11ee-84c4-a0510b46b473.zip','c2c7e958-1ca1-11ee-84c4-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.1.1.5\",\"modelMatrix\":\"0.968043,0.249338,-0.0268817,0,-0.250783,0.962466,-0.103766,0,4.94e-10,0.107191,0.994238,0,-25.6733,12.3165,-13.0904,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-07 10:39:17.825','2023-07-07 08:39:18.614',NULL),('c2c7ffe0-1ca1-11ee-84c4-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_06fff4e1-1ca0-11ee-84c4-a0510b46b473/occlusion_0701c127-1ca0-11ee-84c4-a0510b46b473/scan_653a8ba5-1ca1-11ee-84c4-a0510b46b473/c2c7ffe0-1ca1-11ee-84c4-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_06fff4e1-1ca0-11ee-84c4-a0510b46b473_SESS_0701c127-1ca0-11ee-84c4-a0510b46b473_TOSC_653a8ba5-1ca1-11ee-84c4-a0510b46b473_SNAPS','c2c7ffe0-1ca1-11ee-84c4-a0510b46b473.png','c2c7ffe0-1ca1-11ee-84c4-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.1.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-07 10:39:17.826','2023-07-07 08:39:18.622',NULL),('c43da994-2ae6-11ee-95bc-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_b5fe1002-2ae0-11ee-95bc-a0510b46b473/occlusion_b6012772-2ae0-11ee-95bc-a0510b46b473/scan_88fbc867-2ae6-11ee-95bc-a0510b46b473/c43da994-2ae6-11ee-95bc-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_b5fe1002-2ae0-11ee-95bc-a0510b46b473_SESS_b6012772-2ae0-11ee-95bc-a0510b46b473_TOSC_88fbc867-2ae6-11ee-95bc-a0510b46b473_MODEL','c43da994-2ae6-11ee-95bc-a0510b46b473.zip','c43da994-2ae6-11ee-95bc-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.8.1.8\",\"modelMatrix\":\"0.59954,0.759934,-0.251103,0,-0.800345,0.569268,-0.188102,0,1.33504e-08,0.313744,0.949508,0,-27.6391,-5.91614,-9.13243,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-25 14:28:31.828','2023-07-25 12:28:32.264',NULL),('c43dc085-2ae6-11ee-95bc-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_b5fe1002-2ae0-11ee-95bc-a0510b46b473/occlusion_b6012772-2ae0-11ee-95bc-a0510b46b473/scan_88fbc867-2ae6-11ee-95bc-a0510b46b473/c43dc085-2ae6-11ee-95bc-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_b5fe1002-2ae0-11ee-95bc-a0510b46b473_SESS_b6012772-2ae0-11ee-95bc-a0510b46b473_TOSC_88fbc867-2ae6-11ee-95bc-a0510b46b473_SNAPS','c43dc085-2ae6-11ee-95bc-a0510b46b473.png','c43dc085-2ae6-11ee-95bc-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.8.1.8 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-25 14:28:31.829','2023-07-25 12:28:32.273',NULL),('c44f4040-1fe8-11ee-b7d5-a0510b46b473',11,'/home/scan/.data//2023/11/6a143ccb-1fe8-11ee-b7d5-a0510b46b473/session_7758b704-1fe8-11ee-b7d5-a0510b46b473/occlusion_775bad6c-1fe8-11ee-b7d5-a0510b46b473/scan_842643b3-1fe8-11ee-b7d5-a0510b46b473/c44f4040-1fe8-11ee-b7d5-a0510b46b473.zip','PATIENT_6a143ccb-1fe8-11ee-b7d5-a0510b46b473_ACT_7758b704-1fe8-11ee-b7d5-a0510b46b473_SESS_775bad6c-1fe8-11ee-b7d5-a0510b46b473_TOSC_842643b3-1fe8-11ee-b7d5-a0510b46b473_MODEL','c44f4040-1fe8-11ee-b7d5-a0510b46b473.zip','c44f4040-1fe8-11ee-b7d5-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.32.1.1.1\",\"modelMatrix\":\"0.760663,0.61922,-0.194828,0,-0.649147,0.725595,-0.228297,0,-5.20327e-09,0.300129,0.953899,0,-27.9134,-8.12407,-8.56623,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-11 14:45:08.146','2023-07-11 12:45:10.750',NULL),('c44f5935-1fe8-11ee-b7d5-a0510b46b473',11,'/home/scan/.data//2023/11/6a143ccb-1fe8-11ee-b7d5-a0510b46b473/session_7758b704-1fe8-11ee-b7d5-a0510b46b473/occlusion_775bad6c-1fe8-11ee-b7d5-a0510b46b473/scan_842643b3-1fe8-11ee-b7d5-a0510b46b473/c44f5935-1fe8-11ee-b7d5-a0510b46b473.png','PATIENT_6a143ccb-1fe8-11ee-b7d5-a0510b46b473_ACT_7758b704-1fe8-11ee-b7d5-a0510b46b473_SESS_775bad6c-1fe8-11ee-b7d5-a0510b46b473_TOSC_842643b3-1fe8-11ee-b7d5-a0510b46b473_SNAPS','c44f5935-1fe8-11ee-b7d5-a0510b46b473.png','c44f5935-1fe8-11ee-b7d5-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.32.1.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-11 14:45:08.147','2023-07-11 12:45:10.784',NULL),('c469f36f-1cb0-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/4375c5f1-1cad-11ee-997b-a0510b46b473/session_4a5f2876-1cad-11ee-997b-a0510b46b473/occlusion_4a624109-1cad-11ee-997b-a0510b46b473/scan_4dd147e4-1cb0-11ee-997b-a0510b46b473/c469f36f-1cb0-11ee-997b-a0510b46b473.zip','PATIENT_4375c5f1-1cad-11ee-997b-a0510b46b473_ACT_4a5f2876-1cad-11ee-997b-a0510b46b473_SESS_4a624109-1cad-11ee-997b-a0510b46b473_TOSC_4dd147e4-1cb0-11ee-997b-a0510b46b473_MODEL','c469f36f-1cb0-11ee-997b-a0510b46b473.zip','c469f36f-1cb0-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.31.1.1.7\",\"modelMatrix\":\"-0.143745,0.988553,-0.0458213,0,-0.989615,-0.143591,0.00665572,0,1.79714e-10,0.0463022,0.998927,0,-15.8315,-28.7542,-11.0598,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-07 12:26:43.016','2023-07-07 10:26:43.907',NULL),('c46a0a6f-1cb0-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/4375c5f1-1cad-11ee-997b-a0510b46b473/session_4a5f2876-1cad-11ee-997b-a0510b46b473/occlusion_4a624109-1cad-11ee-997b-a0510b46b473/scan_4dd147e4-1cb0-11ee-997b-a0510b46b473/c46a0a6f-1cb0-11ee-997b-a0510b46b473.png','PATIENT_4375c5f1-1cad-11ee-997b-a0510b46b473_ACT_4a5f2876-1cad-11ee-997b-a0510b46b473_SESS_4a624109-1cad-11ee-997b-a0510b46b473_TOSC_4dd147e4-1cb0-11ee-997b-a0510b46b473_SNAPS','c46a0a6f-1cb0-11ee-997b-a0510b46b473.png','c46a0a6f-1cb0-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.31.1.1.7 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-07 12:26:43.017','2023-07-07 10:26:43.907',NULL),('c4c565f2-dcfe-11ed-8097-00d86184ce3d',11,'/home/scan/.data//2023/11/59af3050-dcfe-11ed-8097-00d86184ce3d/session_61025fcf-dcfe-11ed-8097-00d86184ce3d/occlusion_610548c3-dcfe-11ed-8097-00d86184ce3d/scan_64d1deb3-dcfe-11ed-8097-00d86184ce3d/c4c565f2-dcfe-11ed-8097-00d86184ce3d.zip','PATIENT_59af3050-dcfe-11ed-8097-00d86184ce3d_ACT_61025fcf-dcfe-11ed-8097-00d86184ce3d_SESS_610548c3-dcfe-11ed-8097-00d86184ce3d_TOSC_64d1deb3-dcfe-11ed-8097-00d86184ce3d_MODEL','c4c565f2-dcfe-11ed-8097-00d86184ce3d.zip','c4c565f2-dcfe-11ed-8097-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.1.1.1.1\",\"modelMatrix\":\"0.969743,0.237814,-0.0551644,0,-0.244129,0.944661,-0.219128,0,4.90962e-09,0.225965,0.974136,0,-24.588,1.92661,-9.63785,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-04-17 11:03:49.942','2023-04-17 09:03:50.652','2023-04-17 11:03:51.044'),('c4c58136-dcfe-11ed-8097-00d86184ce3d',11,'/home/scan/.data//2023/11/59af3050-dcfe-11ed-8097-00d86184ce3d/session_61025fcf-dcfe-11ed-8097-00d86184ce3d/occlusion_610548c3-dcfe-11ed-8097-00d86184ce3d/scan_64d1deb3-dcfe-11ed-8097-00d86184ce3d/c4c58136-dcfe-11ed-8097-00d86184ce3d.png','PATIENT_59af3050-dcfe-11ed-8097-00d86184ce3d_ACT_61025fcf-dcfe-11ed-8097-00d86184ce3d_SESS_610548c3-dcfe-11ed-8097-00d86184ce3d_TOSC_64d1deb3-dcfe-11ed-8097-00d86184ce3d_SNAPS','c4c58136-dcfe-11ed-8097-00d86184ce3d.png','c4c58136-dcfe-11ed-8097-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.1.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-04-17 11:03:49.943','2023-04-17 09:03:50.653','2023-04-17 11:03:51.181'),('c5202943-1a7a-11ee-8124-a0510b46b473',11,'/home/scan/.data//2023/11/61e16a70-1a76-11ee-8124-a0510b46b473/session_c8578c2f-1a77-11ee-8124-a0510b46b473/occlusion_c85af2e9-1a77-11ee-8124-a0510b46b473/scan_5a4a9396-1a7a-11ee-8124-a0510b46b473/c5202943-1a7a-11ee-8124-a0510b46b473.zip','PATIENT_61e16a70-1a76-11ee-8124-a0510b46b473_ACT_c8578c2f-1a77-11ee-8124-a0510b46b473_SESS_c85af2e9-1a77-11ee-8124-a0510b46b473_TOSC_5a4a9396-1a7a-11ee-8124-a0510b46b473_MODEL','c5202943-1a7a-11ee-8124-a0510b46b473.zip','c5202943-1a7a-11ee-8124-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.27.2.1.7\",\"modelMatrix\":\"0.993682,0.111952,-0.00792168,0,-0.112232,0.991204,-0.070137,0,-1.72732e-10,0.070583,0.997506,0,-23.3305,14.3508,-14.734,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-04 16:55:09.061','2023-07-04 14:55:09.737',NULL),('c520433e-1a7a-11ee-8124-a0510b46b473',11,'/home/scan/.data//2023/11/61e16a70-1a76-11ee-8124-a0510b46b473/session_c8578c2f-1a77-11ee-8124-a0510b46b473/occlusion_c85af2e9-1a77-11ee-8124-a0510b46b473/scan_5a4a9396-1a7a-11ee-8124-a0510b46b473/c520433e-1a7a-11ee-8124-a0510b46b473.png','PATIENT_61e16a70-1a76-11ee-8124-a0510b46b473_ACT_c8578c2f-1a77-11ee-8124-a0510b46b473_SESS_c85af2e9-1a77-11ee-8124-a0510b46b473_TOSC_5a4a9396-1a7a-11ee-8124-a0510b46b473_SNAPS','c520433e-1a7a-11ee-8124-a0510b46b473.png','c520433e-1a7a-11ee-8124-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.27.2.1.7 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-04 16:55:09.062','2023-07-04 14:55:09.738',NULL),('c5570fa2-10fb-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/ed94fe78-10f4-11ee-b636-a0510b46b473/session_8cbad919-10fb-11ee-b636-a0510b46b473/occlusion_8cbde682-10fb-11ee-b636-a0510b46b473/scan_8d6bd7d2-10fb-11ee-b636-a0510b46b473/c5570fa2-10fb-11ee-b636-a0510b46b473.zip','PATIENT_ed94fe78-10f4-11ee-b636-a0510b46b473_ACT_8cbad919-10fb-11ee-b636-a0510b46b473_SESS_8cbde682-10fb-11ee-b636-a0510b46b473_TOSC_8d6bd7d2-10fb-11ee-b636-a0510b46b473_MODEL','c5570fa2-10fb-11ee-b636-a0510b46b473.zip','c5570fa2-10fb-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.19.2.1.1\",\"modelMatrix\":\"0.552645,0.741072,-0.381308,0,-0.833417,0.491411,-0.252848,0,7.21521e-09,0.457524,0.889197,0,-27.6975,-11.4861,-3.81735,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 14:53:22.871','2023-06-22 12:53:23.438',NULL),('c5572545-10fb-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/ed94fe78-10f4-11ee-b636-a0510b46b473/session_8cbad919-10fb-11ee-b636-a0510b46b473/occlusion_8cbde682-10fb-11ee-b636-a0510b46b473/scan_8d6bd7d2-10fb-11ee-b636-a0510b46b473/c5572545-10fb-11ee-b636-a0510b46b473.png','PATIENT_ed94fe78-10f4-11ee-b636-a0510b46b473_ACT_8cbad919-10fb-11ee-b636-a0510b46b473_SESS_8cbde682-10fb-11ee-b636-a0510b46b473_TOSC_8d6bd7d2-10fb-11ee-b636-a0510b46b473_SNAPS','c5572545-10fb-11ee-b636-a0510b46b473.png','c5572545-10fb-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.19.2.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 14:53:22.872','2023-06-22 12:53:23.439',NULL),('c589e9c8-1a76-11ee-8124-a0510b46b473',11,'/home/scan/.data//2023/11/61e16a70-1a76-11ee-8124-a0510b46b473/session_76f916fd-1a76-11ee-8124-a0510b46b473/occlusion_76fc311b-1a76-11ee-8124-a0510b46b473/scan_787588b3-1a76-11ee-8124-a0510b46b473/c589e9c8-1a76-11ee-8124-a0510b46b473.zip','PATIENT_61e16a70-1a76-11ee-8124-a0510b46b473_ACT_76f916fd-1a76-11ee-8124-a0510b46b473_SESS_76fc311b-1a76-11ee-8124-a0510b46b473_TOSC_787588b3-1a76-11ee-8124-a0510b46b473_MODEL','c589e9c8-1a76-11ee-8124-a0510b46b473.zip','c589e9c8-1a76-11ee-8124-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.27.1.1.1\",\"modelMatrix\":\"-0.3543,0.929869,-0.0990728,0,-0.935132,-0.352306,0.0375365,0,-2.22876e-09,0.105945,0.994372,0,-7.33929,-27.0361,-9.66958,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-04 16:26:31.767','2023-07-04 14:26:32.409',NULL),('c58a033e-1a76-11ee-8124-a0510b46b473',11,'/home/scan/.data//2023/11/61e16a70-1a76-11ee-8124-a0510b46b473/session_76f916fd-1a76-11ee-8124-a0510b46b473/occlusion_76fc311b-1a76-11ee-8124-a0510b46b473/scan_787588b3-1a76-11ee-8124-a0510b46b473/c58a033e-1a76-11ee-8124-a0510b46b473.png','PATIENT_61e16a70-1a76-11ee-8124-a0510b46b473_ACT_76f916fd-1a76-11ee-8124-a0510b46b473_SESS_76fc311b-1a76-11ee-8124-a0510b46b473_TOSC_787588b3-1a76-11ee-8124-a0510b46b473_SNAPS','c58a033e-1a76-11ee-8124-a0510b46b473.png','c58a033e-1a76-11ee-8124-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.27.1.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-04 16:26:31.768','2023-07-04 14:26:32.411',NULL),('c5b7601f-e025-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_ed85304d-e024-11ed-bb13-00d86184ce3d/occlusion_ed88a64f-e024-11ed-bb13-00d86184ce3d/scan_7221bbba-e025-11ed-bb13-00d86184ce3d/c5b7601f-e025-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_ed85304d-e024-11ed-bb13-00d86184ce3d_SESS_ed88a64f-e024-11ed-bb13-00d86184ce3d_TOSC_7221bbba-e025-11ed-bb13-00d86184ce3d_MODEL','c5b7601f-e025-11ed-bb13-00d86184ce3d.zip','c5b7601f-e025-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.1.1.2\",\"modelMatrix\":\"-0.502472,0.837508,-0.214716,0,-0.864594,-0.486731,0.124786,0,-2.79546e-09,0.248344,0.968672,0,-6.87592,-32.0093,-7.51217,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 11:20:35.389','2023-04-21 09:20:36.365',NULL),('c5b89b4b-e025-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_ed85304d-e024-11ed-bb13-00d86184ce3d/occlusion_ed88a64f-e024-11ed-bb13-00d86184ce3d/scan_7221bbba-e025-11ed-bb13-00d86184ce3d/c5b89b4b-e025-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_ed85304d-e024-11ed-bb13-00d86184ce3d_SESS_ed88a64f-e024-11ed-bb13-00d86184ce3d_TOSC_7221bbba-e025-11ed-bb13-00d86184ce3d_SNAPS','c5b89b4b-e025-11ed-bb13-00d86184ce3d.png','c5b89b4b-e025-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.1.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 11:20:35.397','2023-04-21 09:20:36.373',NULL),('c701e0be-e01e-11ed-a285-00d86184ce3d',11,'/home/scan/.data//2023/11/5f27680c-e01a-11ed-b6c2-00d86184ce3d/session_65b85f32-e01a-11ed-b6c2-00d86184ce3d/occlusion_65ba9a94-e01a-11ed-b6c2-00d86184ce3d/scan_792cf404-e01e-11ed-a285-00d86184ce3d/c701e0be-e01e-11ed-a285-00d86184ce3d.zip','PATIENT_5f27680c-e01a-11ed-b6c2-00d86184ce3d_ACT_65b85f32-e01a-11ed-b6c2-00d86184ce3d_SESS_65ba9a94-e01a-11ed-b6c2-00d86184ce3d_BOSC_792cf404-e01e-11ed-a285-00d86184ce3d_MODEL','c701e0be-e01e-11ed-a285-00d86184ce3d.zip','c701e0be-e01e-11ed-a285-00d86184ce3d','{\"displayTitle\":\"Mandibule 1.10.1.1.1\",\"modelMatrix\":\"0.585532,0.777818,-0.228369,0,-0.81065,0.561817,-0.164951,0,4.19334e-10,0.281711,0.959499,0,-2.25033,-27.6828,-8.25598,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 10:30:31.078','2023-04-21 08:30:31.890',NULL),('c701f7e3-e01e-11ed-a285-00d86184ce3d',11,'/home/scan/.data//2023/11/5f27680c-e01a-11ed-b6c2-00d86184ce3d/session_65b85f32-e01a-11ed-b6c2-00d86184ce3d/occlusion_65ba9a94-e01a-11ed-b6c2-00d86184ce3d/scan_792cf404-e01e-11ed-a285-00d86184ce3d/c701f7e3-e01e-11ed-a285-00d86184ce3d.png','PATIENT_5f27680c-e01a-11ed-b6c2-00d86184ce3d_ACT_65b85f32-e01a-11ed-b6c2-00d86184ce3d_SESS_65ba9a94-e01a-11ed-b6c2-00d86184ce3d_BOSC_792cf404-e01e-11ed-a285-00d86184ce3d_SNAPS','c701f7e3-e01e-11ed-a285-00d86184ce3d.png','c701f7e3-e01e-11ed-a285-00d86184ce3d','{\"displayTitle\":\"Mandibule 1.10.1.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 10:30:31.078','2023-04-21 08:30:31.891',NULL),('c7279ca1-e03a-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_6f09f9a8-e03a-11ed-bb13-00d86184ce3d/occlusion_6f0c3cda-e03a-11ed-bb13-00d86184ce3d/scan_abc11c99-e03a-11ed-bb13-00d86184ce3d/c7279ca1-e03a-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_6f09f9a8-e03a-11ed-bb13-00d86184ce3d_SESS_6f0c3cda-e03a-11ed-bb13-00d86184ce3d_TOSC_abc11c99-e03a-11ed-bb13-00d86184ce3d_MODEL','c7279ca1-e03a-11ed-bb13-00d86184ce3d.zip','c7279ca1-e03a-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.3.1.3\",\"modelMatrix\":\"-0.624103,0.709277,-0.327753,0,-0.781342,-0.566541,0.261795,0,-1.2121e-09,0.419474,0.907767,0,9.12847,-14.5609,-5.44568,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,'2023-04-21 13:51:25.406','2023-04-21 13:50:57.234','2023-04-21 11:51:25.411',NULL),('c727b313-e03a-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_6f09f9a8-e03a-11ed-bb13-00d86184ce3d/occlusion_6f0c3cda-e03a-11ed-bb13-00d86184ce3d/scan_abc11c99-e03a-11ed-bb13-00d86184ce3d/c727b313-e03a-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_6f09f9a8-e03a-11ed-bb13-00d86184ce3d_SESS_6f0c3cda-e03a-11ed-bb13-00d86184ce3d_TOSC_abc11c99-e03a-11ed-bb13-00d86184ce3d_SNAPS','c727b313-e03a-11ed-bb13-00d86184ce3d.png','c727b313-e03a-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.3.1.3 Snapshot\"}','PNG',0,'CREATED',0,'2023-04-21 13:51:25.407','2023-04-21 13:50:57.234','2023-04-21 11:51:25.415',NULL),('c7318d0e-2579-11ee-b81b-a0510b46b473',11,'/home/scan/.data//2023/11/49f1e276-256f-11ee-91d6-a0510b46b473/session_f58279e9-2576-11ee-b81b-a0510b46b473/occlusion_f584e68a-2576-11ee-b81b-a0510b46b473/scan_5af4daa3-2579-11ee-b81b-a0510b46b473/c7318d0e-2579-11ee-b81b-a0510b46b473.zip','PATIENT_49f1e276-256f-11ee-91d6-a0510b46b473_ACT_f58279e9-2576-11ee-b81b-a0510b46b473_SESS_f584e68a-2576-11ee-b81b-a0510b46b473_TOSC_5af4daa3-2579-11ee-b81b-a0510b46b473_MODEL','c7318d0e-2579-11ee-b81b-a0510b46b473.zip','c7318d0e-2579-11ee-b81b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.33.2.1.5\",\"modelMatrix\":\"0.0647909,0.952105,-0.298827,0,-0.997899,0.0618176,-0.0194021,0,1.48189e-09,0.299457,0.95411,0,-12.2393,-18.8106,-8.77505,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-18 16:45:45.824','2023-07-18 14:45:46.477',NULL),('c732cb0c-2579-11ee-b81b-a0510b46b473',11,'/home/scan/.data//2023/11/49f1e276-256f-11ee-91d6-a0510b46b473/session_f58279e9-2576-11ee-b81b-a0510b46b473/occlusion_f584e68a-2576-11ee-b81b-a0510b46b473/scan_5af4daa3-2579-11ee-b81b-a0510b46b473/c732cb0c-2579-11ee-b81b-a0510b46b473.png','PATIENT_49f1e276-256f-11ee-91d6-a0510b46b473_ACT_f58279e9-2576-11ee-b81b-a0510b46b473_SESS_f584e68a-2576-11ee-b81b-a0510b46b473_TOSC_5af4daa3-2579-11ee-b81b-a0510b46b473_SNAPS','c732cb0c-2579-11ee-b81b-a0510b46b473.png','c732cb0c-2579-11ee-b81b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.33.2.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-18 16:45:45.833','2023-07-18 14:45:46.477',NULL),('c81c361c-1bdb-11ee-9086-a0510b46b473',11,'/home/scan/.data//2023/11/61e16a70-1a76-11ee-8124-a0510b46b473/session_a0a47257-1bd8-11ee-9086-a0510b46b473/occlusion_a0a77bfe-1bd8-11ee-9086-a0510b46b473/scan_5bd91ebd-1bdb-11ee-9086-a0510b46b473/c81c361c-1bdb-11ee-9086-a0510b46b473.zip','PATIENT_61e16a70-1a76-11ee-8124-a0510b46b473_ACT_a0a47257-1bd8-11ee-9086-a0510b46b473_SESS_a0a77bfe-1bd8-11ee-9086-a0510b46b473_TOSC_5bd91ebd-1bdb-11ee-9086-a0510b46b473_MODEL','c81c361c-1bdb-11ee-9086-a0510b46b473.zip','c81c361c-1bdb-11ee-9086-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.27.3.1.5\",\"modelMatrix\":\"0.358353,0.911104,-0.203648,0,-0.933586,0.349723,-0.0781693,0,3.47269e-09,0.218135,0.975919,0,-28.2699,-11.5822,-11.5372,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 11:02:06.414','2023-07-06 09:02:07.085',NULL),('c81cb0ce-1bdb-11ee-9086-a0510b46b473',11,'/home/scan/.data//2023/11/61e16a70-1a76-11ee-8124-a0510b46b473/session_a0a47257-1bd8-11ee-9086-a0510b46b473/occlusion_a0a77bfe-1bd8-11ee-9086-a0510b46b473/scan_5bd91ebd-1bdb-11ee-9086-a0510b46b473/c81cb0ce-1bdb-11ee-9086-a0510b46b473.png','PATIENT_61e16a70-1a76-11ee-8124-a0510b46b473_ACT_a0a47257-1bd8-11ee-9086-a0510b46b473_SESS_a0a77bfe-1bd8-11ee-9086-a0510b46b473_TOSC_5bd91ebd-1bdb-11ee-9086-a0510b46b473_SNAPS','c81cb0ce-1bdb-11ee-9086-a0510b46b473.png','c81cb0ce-1bdb-11ee-9086-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.27.3.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 11:02:06.417','2023-07-06 09:02:07.086',NULL),('c8b89605-158c-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/634153bc-1587-11ee-b3b1-00d86184ce3d/session_6e9df503-1587-11ee-b3b1-00d86184ce3d/occlusion_6ea0d9b2-1587-11ee-b3b1-00d86184ce3d/scan_816711dd-158c-11ee-b3b1-00d86184ce3d/c8b89605-158c-11ee-b3b1-00d86184ce3d.zip','PATIENT_634153bc-1587-11ee-b3b1-00d86184ce3d_ACT_6e9df503-1587-11ee-b3b1-00d86184ce3d_SESS_6ea0d9b2-1587-11ee-b3b1-00d86184ce3d_TOSC_816711dd-158c-11ee-b3b1-00d86184ce3d_MODEL','c8b89605-158c-11ee-b3b1-00d86184ce3d.zip','c8b89605-158c-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.24.1.1.7\",\"modelMatrix\":\"0.626253,0.763826,-0.156129,0,-0.77962,0.613566,-0.125416,0,4.71675e-10,0.200263,0.979742,0,-27.1112,-5.97727,-10.6423,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-28 10:21:30.220','2023-06-28 08:21:30.922',NULL),('c8b8a2d2-158c-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/634153bc-1587-11ee-b3b1-00d86184ce3d/session_6e9df503-1587-11ee-b3b1-00d86184ce3d/occlusion_6ea0d9b2-1587-11ee-b3b1-00d86184ce3d/scan_816711dd-158c-11ee-b3b1-00d86184ce3d/c8b8a2d2-158c-11ee-b3b1-00d86184ce3d.png','PATIENT_634153bc-1587-11ee-b3b1-00d86184ce3d_ACT_6e9df503-1587-11ee-b3b1-00d86184ce3d_SESS_6ea0d9b2-1587-11ee-b3b1-00d86184ce3d_TOSC_816711dd-158c-11ee-b3b1-00d86184ce3d_SNAPS','c8b8a2d2-158c-11ee-b3b1-00d86184ce3d.png','c8b8a2d2-158c-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.24.1.1.7 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-28 10:21:30.221','2023-06-28 08:21:30.923',NULL),('ca58a7a5-2620-11ee-8042-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_62519c59-261f-11ee-8042-a0510b46b473/occlusion_6253caa6-261f-11ee-8042-a0510b46b473/scan_6a0b0e2b-2620-11ee-8042-a0510b46b473/ca58a7a5-2620-11ee-8042-a0510b46b473.zip','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_62519c59-261f-11ee-8042-a0510b46b473_SESS_6253caa6-261f-11ee-8042-a0510b46b473_TOSC_6a0b0e2b-2620-11ee-8042-a0510b46b473_MODEL','ca58a7a5-2620-11ee-8042-a0510b46b473.zip','ca58a7a5-2620-11ee-8042-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.1.1.3\",\"modelMatrix\":\"0.999667,0.0257581,-0.0015479,0,-0.0258046,0.997867,-0.0599654,0,4.25701e-11,0.0599854,0.998199,0,-10.6135,14.6854,-12.8596,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-19 12:41:17.068','2023-07-19 10:41:17.843',NULL),('ca59ea4d-2620-11ee-8042-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_62519c59-261f-11ee-8042-a0510b46b473/occlusion_6253caa6-261f-11ee-8042-a0510b46b473/scan_6a0b0e2b-2620-11ee-8042-a0510b46b473/ca59ea4d-2620-11ee-8042-a0510b46b473.png','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_62519c59-261f-11ee-8042-a0510b46b473_SESS_6253caa6-261f-11ee-8042-a0510b46b473_TOSC_6a0b0e2b-2620-11ee-8042-a0510b46b473_SNAPS','ca59ea4d-2620-11ee-8042-a0510b46b473.png','ca59ea4d-2620-11ee-8042-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.1.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-19 12:41:17.076','2023-07-19 10:41:17.847',NULL),('cb04b927-14c6-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/9619fcac-14c3-11ee-b3b1-00d86184ce3d/session_961b9a11-14c3-11ee-b3b1-00d86184ce3d/occlusion_961d56b4-14c3-11ee-b3b1-00d86184ce3d/scan_6e80bcc9-14c6-11ee-b3b1-00d86184ce3d/cb04b927-14c6-11ee-b3b1-00d86184ce3d.zip','PATIENT_9619fcac-14c3-11ee-b3b1-00d86184ce3d_ACT_961b9a11-14c3-11ee-b3b1-00d86184ce3d_SESS_961d56b4-14c3-11ee-b3b1-00d86184ce3d_TOSC_6e80bcc9-14c6-11ee-b3b1-00d86184ce3d_MODEL','cb04b927-14c6-11ee-b3b1-00d86184ce3d.zip','cb04b927-14c6-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.22.1.1.2\",\"modelMatrix\":\"0.273173,0.960088,-0.0600635,0,-0.961965,0.27264,-0.0170565,0,1.09368e-09,0.0624384,0.998049,0,-21.903,-22.8935,-13.6798,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-27 10:44:13.722','2023-06-27 08:45:11.512',NULL),('cb04cd41-14c6-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/9619fcac-14c3-11ee-b3b1-00d86184ce3d/session_961b9a11-14c3-11ee-b3b1-00d86184ce3d/occlusion_961d56b4-14c3-11ee-b3b1-00d86184ce3d/scan_6e80bcc9-14c6-11ee-b3b1-00d86184ce3d/cb04cd41-14c6-11ee-b3b1-00d86184ce3d.png','PATIENT_9619fcac-14c3-11ee-b3b1-00d86184ce3d_ACT_961b9a11-14c3-11ee-b3b1-00d86184ce3d_SESS_961d56b4-14c3-11ee-b3b1-00d86184ce3d_TOSC_6e80bcc9-14c6-11ee-b3b1-00d86184ce3d_SNAPS','cb04cd41-14c6-11ee-b3b1-00d86184ce3d.png','cb04cd41-14c6-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.22.1.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-27 10:44:13.723','2023-06-27 08:45:11.513',NULL),('cb44d13c-2703-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/848c86d9-26fd-11ee-a98e-a0510b46b473/session_8f62cd50-26fd-11ee-a98e-a0510b46b473/occlusion_8f65e2e0-26fd-11ee-a98e-a0510b46b473/scan_50050eb2-2703-11ee-a98e-a0510b46b473/cb44d13c-2703-11ee-a98e-a0510b46b473.zip','PATIENT_848c86d9-26fd-11ee-a98e-a0510b46b473_ACT_8f62cd50-26fd-11ee-a98e-a0510b46b473_SESS_8f65e2e0-26fd-11ee-a98e-a0510b46b473_TOSC_50050eb2-2703-11ee-a98e-a0510b46b473_MODEL','cb44d13c-2703-11ee-a98e-a0510b46b473.zip','cb44d13c-2703-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.36.1.1.12\",\"modelMatrix\":\"0.648402,0.722263,-0.240645,0,-0.761298,0.615156,-0.204959,0,-1.78441e-09,0.316099,0.948726,0,-1.17057,-26.804,-11.6342,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-20 15:46:14.373','2023-07-20 13:46:15.508',NULL),('cb44e82a-2703-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/848c86d9-26fd-11ee-a98e-a0510b46b473/session_8f62cd50-26fd-11ee-a98e-a0510b46b473/occlusion_8f65e2e0-26fd-11ee-a98e-a0510b46b473/scan_50050eb2-2703-11ee-a98e-a0510b46b473/cb44e82a-2703-11ee-a98e-a0510b46b473.png','PATIENT_848c86d9-26fd-11ee-a98e-a0510b46b473_ACT_8f62cd50-26fd-11ee-a98e-a0510b46b473_SESS_8f65e2e0-26fd-11ee-a98e-a0510b46b473_TOSC_50050eb2-2703-11ee-a98e-a0510b46b473_SNAPS','cb44e82a-2703-11ee-a98e-a0510b46b473.png','cb44e82a-2703-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.36.1.1.12 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-20 15:46:14.374','2023-07-20 13:46:15.509',NULL),('cb991e3d-10fa-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/ed94fe78-10f4-11ee-b636-a0510b46b473/session_f8ef8fe7-10f4-11ee-b636-a0510b46b473/occlusion_f8f2e241-10f4-11ee-b636-a0510b46b473/scan_75b380d5-10fa-11ee-b636-a0510b46b473/cb991e3d-10fa-11ee-b636-a0510b46b473.zip','PATIENT_ed94fe78-10f4-11ee-b636-a0510b46b473_ACT_f8ef8fe7-10f4-11ee-b636-a0510b46b473_SESS_f8f2e241-10f4-11ee-b636-a0510b46b473_TOSC_75b380d5-10fa-11ee-b636-a0510b46b473_MODEL','cb991e3d-10fa-11ee-b636-a0510b46b473.zip','cb991e3d-10fa-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.19.1.1.6\",\"modelMatrix\":\"0.585191,0.802242,-0.11815,0,-0.810895,0.578946,-0.0852639,0,5.75415e-09,0.145703,0.989328,0,-29.8453,-7.59914,-9.93871,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 14:46:23.874','2023-06-22 12:46:24.568',NULL),('cb99322f-10fa-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/ed94fe78-10f4-11ee-b636-a0510b46b473/session_f8ef8fe7-10f4-11ee-b636-a0510b46b473/occlusion_f8f2e241-10f4-11ee-b636-a0510b46b473/scan_75b380d5-10fa-11ee-b636-a0510b46b473/cb99322f-10fa-11ee-b636-a0510b46b473.png','PATIENT_ed94fe78-10f4-11ee-b636-a0510b46b473_ACT_f8ef8fe7-10f4-11ee-b636-a0510b46b473_SESS_f8f2e241-10f4-11ee-b636-a0510b46b473_TOSC_75b380d5-10fa-11ee-b636-a0510b46b473_SNAPS','cb99322f-10fa-11ee-b636-a0510b46b473.png','cb99322f-10fa-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.19.1.1.6 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 14:46:23.874','2023-06-22 12:46:24.569',NULL),('cbdf6f18-1c07-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/ae8bd11e-1c05-11ee-9323-a0510b46b473/session_bb436bde-1c05-11ee-9323-a0510b46b473/occlusion_bb465a1e-1c05-11ee-9323-a0510b46b473/scan_a1364b8c-1c07-11ee-9323-a0510b46b473/cbdf6f18-1c07-11ee-9323-a0510b46b473.zip','PATIENT_ae8bd11e-1c05-11ee-9323-a0510b46b473_ACT_bb436bde-1c05-11ee-9323-a0510b46b473_SESS_bb465a1e-1c05-11ee-9323-a0510b46b473_TOSC_a1364b8c-1c07-11ee-9323-a0510b46b473_MODEL','cbdf6f18-1c07-11ee-9323-a0510b46b473.zip','cbdf6f18-1c07-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.29.1.1.6\",\"modelMatrix\":\"0.408499,-0.858912,0.308867,0,0.912759,0.3844,-0.138231,0,-1.77725e-09,0.338388,0.941007,0,7.00873,25.1296,-22.4558,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 16:17:10.583','2023-07-06 14:17:10.975',NULL),('cbe0b174-1c07-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/ae8bd11e-1c05-11ee-9323-a0510b46b473/session_bb436bde-1c05-11ee-9323-a0510b46b473/occlusion_bb465a1e-1c05-11ee-9323-a0510b46b473/scan_a1364b8c-1c07-11ee-9323-a0510b46b473/cbe0b174-1c07-11ee-9323-a0510b46b473.png','PATIENT_ae8bd11e-1c05-11ee-9323-a0510b46b473_ACT_bb436bde-1c05-11ee-9323-a0510b46b473_SESS_bb465a1e-1c05-11ee-9323-a0510b46b473_TOSC_a1364b8c-1c07-11ee-9323-a0510b46b473_SNAPS','cbe0b174-1c07-11ee-9323-a0510b46b473.png','cbe0b174-1c07-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.29.1.1.6 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 16:17:10.591','2023-07-06 14:17:10.978',NULL),('cdda8e4c-dcff-11ed-8097-00d86184ce3d',11,'/home/scan/.data//2023/11/59af3050-dcfe-11ed-8097-00d86184ce3d/session_61025fcf-dcfe-11ed-8097-00d86184ce3d/occlusion_610548c3-dcfe-11ed-8097-00d86184ce3d/scan_88d1427b-dcff-11ed-8097-00d86184ce3d/cdda8e4c-dcff-11ed-8097-00d86184ce3d.zip','PATIENT_59af3050-dcfe-11ed-8097-00d86184ce3d_ACT_61025fcf-dcfe-11ed-8097-00d86184ce3d_SESS_610548c3-dcfe-11ed-8097-00d86184ce3d_TOSC_88d1427b-dcff-11ed-8097-00d86184ce3d_MODEL','cdda8e4c-dcff-11ed-8097-00d86184ce3d.zip','cdda8e4c-dcff-11ed-8097-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.1.1.1.3\",\"modelMatrix\":\"0.752764,0.638781,-0.159075,0,-0.65829,0.730455,-0.181904,0,8.12336e-09,0.241648,0.970364,0,-27.8076,-1.72663,-8.87985,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-04-17 11:11:14.677','2023-04-17 09:11:15.434','2023-04-17 11:11:15.797'),('cddaadbc-dcff-11ed-8097-00d86184ce3d',11,'/home/scan/.data//2023/11/59af3050-dcfe-11ed-8097-00d86184ce3d/session_61025fcf-dcfe-11ed-8097-00d86184ce3d/occlusion_610548c3-dcfe-11ed-8097-00d86184ce3d/scan_88d1427b-dcff-11ed-8097-00d86184ce3d/cddaadbc-dcff-11ed-8097-00d86184ce3d.png','PATIENT_59af3050-dcfe-11ed-8097-00d86184ce3d_ACT_61025fcf-dcfe-11ed-8097-00d86184ce3d_SESS_610548c3-dcfe-11ed-8097-00d86184ce3d_TOSC_88d1427b-dcff-11ed-8097-00d86184ce3d_SNAPS','cddaadbc-dcff-11ed-8097-00d86184ce3d.png','cddaadbc-dcff-11ed-8097-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.1.1.1.3 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-04-17 11:11:14.678','2023-04-17 09:11:15.435','2023-04-17 11:11:15.927'),('cde20b98-e01d-11ed-a285-00d86184ce3d',11,'/home/scan/.data//2023/11/5f27680c-e01a-11ed-b6c2-00d86184ce3d/session_65b85f32-e01a-11ed-b6c2-00d86184ce3d/occlusion_65ba9a94-e01a-11ed-b6c2-00d86184ce3d/scan_1acdf7bc-e01d-11ed-a285-00d86184ce3d/cde20b98-e01d-11ed-a285-00d86184ce3d.zip','PATIENT_5f27680c-e01a-11ed-b6c2-00d86184ce3d_ACT_65b85f32-e01a-11ed-b6c2-00d86184ce3d_SESS_65ba9a94-e01a-11ed-b6c2-00d86184ce3d_TOSC_1acdf7bc-e01d-11ed-a285-00d86184ce3d_MODEL','cde20b98-e01d-11ed-a285-00d86184ce3d.zip','cde20b98-e01d-11ed-a285-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.10.1.1.3\",\"modelMatrix\":\"0.491814,0.816806,-0.301573,0,-0.8707,0.461372,-0.170343,0,5.33204e-09,0.346356,0.938103,0,-26.91,-7.33052,-7.64465,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 10:23:33.117','2023-04-21 08:23:34.215',NULL),('cde221c5-e01d-11ed-a285-00d86184ce3d',11,'/home/scan/.data//2023/11/5f27680c-e01a-11ed-b6c2-00d86184ce3d/session_65b85f32-e01a-11ed-b6c2-00d86184ce3d/occlusion_65ba9a94-e01a-11ed-b6c2-00d86184ce3d/scan_1acdf7bc-e01d-11ed-a285-00d86184ce3d/cde221c5-e01d-11ed-a285-00d86184ce3d.png','PATIENT_5f27680c-e01a-11ed-b6c2-00d86184ce3d_ACT_65b85f32-e01a-11ed-b6c2-00d86184ce3d_SESS_65ba9a94-e01a-11ed-b6c2-00d86184ce3d_TOSC_1acdf7bc-e01d-11ed-a285-00d86184ce3d_SNAPS','cde221c5-e01d-11ed-a285-00d86184ce3d.png','cde221c5-e01d-11ed-a285-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.10.1.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 10:23:33.117','2023-04-21 08:23:34.215',NULL),('cdec8191-de95-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/35e16a68-de95-11ed-9cc3-00d86184ce3d/session_450c29ef-de95-11ed-9cc3-00d86184ce3d/occlusion_450efda8-de95-11ed-9cc3-00d86184ce3d/scan_7b5be28c-de95-11ed-9cc3-00d86184ce3d/cdec8191-de95-11ed-9cc3-00d86184ce3d.zip','PATIENT_35e16a68-de95-11ed-9cc3-00d86184ce3d_ACT_450c29ef-de95-11ed-9cc3-00d86184ce3d_SESS_450efda8-de95-11ed-9cc3-00d86184ce3d_TOSC_7b5be28c-de95-11ed-9cc3-00d86184ce3d_MODEL','cdec8191-de95-11ed-9cc3-00d86184ce3d.zip','cdec8191-de95-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.4.1.1.1\",\"modelMatrix\":\"0.378423,0.86617,-0.326413,0,-0.925633,0.354113,-0.133446,0,4.16904e-10,0.352638,0.93576,0,-25.6209,-16.9355,-6.35323,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-19 11:37:30.467','2023-04-19 09:37:31.260',NULL),('cdec94cb-de95-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/35e16a68-de95-11ed-9cc3-00d86184ce3d/session_450c29ef-de95-11ed-9cc3-00d86184ce3d/occlusion_450efda8-de95-11ed-9cc3-00d86184ce3d/scan_7b5be28c-de95-11ed-9cc3-00d86184ce3d/cdec94cb-de95-11ed-9cc3-00d86184ce3d.png','PATIENT_35e16a68-de95-11ed-9cc3-00d86184ce3d_ACT_450c29ef-de95-11ed-9cc3-00d86184ce3d_SESS_450efda8-de95-11ed-9cc3-00d86184ce3d_TOSC_7b5be28c-de95-11ed-9cc3-00d86184ce3d_SNAPS','cdec94cb-de95-11ed-9cc3-00d86184ce3d.png','cdec94cb-de95-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.4.1.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-19 11:37:30.468','2023-04-19 09:37:31.261',NULL),('ce090a80-deb3-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/cf3f0588-deb2-11ed-9cc3-00d86184ce3d/session_d7750b8d-deb2-11ed-9cc3-00d86184ce3d/occlusion_d7775a50-deb2-11ed-9cc3-00d86184ce3d/scan_6aa55fd6-deb3-11ed-9cc3-00d86184ce3d/ce090a80-deb3-11ed-9cc3-00d86184ce3d.zip','PATIENT_cf3f0588-deb2-11ed-9cc3-00d86184ce3d_ACT_d7750b8d-deb2-11ed-9cc3-00d86184ce3d_SESS_d7775a50-deb2-11ed-9cc3-00d86184ce3d_TOSC_6aa55fd6-deb3-11ed-9cc3-00d86184ce3d_MODEL','ce090a80-deb3-11ed-9cc3-00d86184ce3d.zip','ce090a80-deb3-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.6.1.1.2\",\"modelMatrix\":\"-0.540085,0.823942,-0.171544,0,-0.84161,-0.528747,0.110085,0,-2.36498e-09,0.203829,0.979007,0,-3.46425,-31.6656,-8.44101,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-19 15:12:15.556','2023-04-19 13:12:16.623',NULL),('ce092151-deb3-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/cf3f0588-deb2-11ed-9cc3-00d86184ce3d/session_d7750b8d-deb2-11ed-9cc3-00d86184ce3d/occlusion_d7775a50-deb2-11ed-9cc3-00d86184ce3d/scan_6aa55fd6-deb3-11ed-9cc3-00d86184ce3d/ce092151-deb3-11ed-9cc3-00d86184ce3d.png','PATIENT_cf3f0588-deb2-11ed-9cc3-00d86184ce3d_ACT_d7750b8d-deb2-11ed-9cc3-00d86184ce3d_SESS_d7775a50-deb2-11ed-9cc3-00d86184ce3d_TOSC_6aa55fd6-deb3-11ed-9cc3-00d86184ce3d_SNAPS','ce092151-deb3-11ed-9cc3-00d86184ce3d.png','ce092151-deb3-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.6.1.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-19 15:12:15.557','2023-04-19 13:12:16.623',NULL),('cf03a91b-1ccf-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/4375c5f1-1cad-11ee-997b-a0510b46b473/session_a945b37e-1ccf-11ee-997b-a0510b46b473/occlusion_a948c735-1ccf-11ee-997b-a0510b46b473/scan_aaeef5ce-1ccf-11ee-997b-a0510b46b473/cf03a91b-1ccf-11ee-997b-a0510b46b473.zip','PATIENT_4375c5f1-1cad-11ee-997b-a0510b46b473_ACT_a945b37e-1ccf-11ee-997b-a0510b46b473_SESS_a948c735-1ccf-11ee-997b-a0510b46b473_TOSC_aaeef5ce-1ccf-11ee-997b-a0510b46b473_MODEL','cf03a91b-1ccf-11ee-997b-a0510b46b473.zip','cf03a91b-1ccf-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.31.3.1.1\",\"modelMatrix\":\"0.101767,0.987689,-0.118799,0,-0.994808,0.101039,-0.012153,0,-9.79105e-10,0.119419,0.992844,0,-3.64613,-13.039,-11.0599,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-07 16:08:55.199','2023-07-07 14:08:55.530',NULL),('cf03bcf6-1ccf-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/4375c5f1-1cad-11ee-997b-a0510b46b473/session_a945b37e-1ccf-11ee-997b-a0510b46b473/occlusion_a948c735-1ccf-11ee-997b-a0510b46b473/scan_aaeef5ce-1ccf-11ee-997b-a0510b46b473/cf03bcf6-1ccf-11ee-997b-a0510b46b473.png','PATIENT_4375c5f1-1cad-11ee-997b-a0510b46b473_ACT_a945b37e-1ccf-11ee-997b-a0510b46b473_SESS_a948c735-1ccf-11ee-997b-a0510b46b473_TOSC_aaeef5ce-1ccf-11ee-997b-a0510b46b473_SNAPS','cf03bcf6-1ccf-11ee-997b-a0510b46b473.png','cf03bcf6-1ccf-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.31.3.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-07 16:08:55.200','2023-07-07 14:08:55.538',NULL),('d1a9f553-15be-11ee-a062-a0510b46b473',11,'/home/scan/.data//2023/11/142e7037-15b6-11ee-b3b1-00d86184ce3d/session_c41888b6-15ba-11ee-b3b1-00d86184ce3d/occlusion_c41a4d8e-15ba-11ee-b3b1-00d86184ce3d/scan_9017917f-15be-11ee-a062-a0510b46b473/d1a9f553-15be-11ee-a062-a0510b46b473.zip','PATIENT_142e7037-15b6-11ee-b3b1-00d86184ce3d_ACT_c41888b6-15ba-11ee-b3b1-00d86184ce3d_SESS_c41a4d8e-15ba-11ee-b3b1-00d86184ce3d_TOSC_9017917f-15be-11ee-a062-a0510b46b473_MODEL','d1a9f553-15be-11ee-a062-a0510b46b473.zip','d1a9f553-15be-11ee-a062-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.25.2.1.2\",\"modelMatrix\":\"0.678237,0.669565,-0.302781,0,-0.734843,0.617988,-0.279458,0,1.25895e-08,0.412035,0.911168,0,-30.6956,4.12854,-8.01224,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-28 16:19:40.061','2023-06-28 14:19:40.615',NULL),('d1aa0e65-15be-11ee-a062-a0510b46b473',11,'/home/scan/.data//2023/11/142e7037-15b6-11ee-b3b1-00d86184ce3d/session_c41888b6-15ba-11ee-b3b1-00d86184ce3d/occlusion_c41a4d8e-15ba-11ee-b3b1-00d86184ce3d/scan_9017917f-15be-11ee-a062-a0510b46b473/d1aa0e65-15be-11ee-a062-a0510b46b473.png','PATIENT_142e7037-15b6-11ee-b3b1-00d86184ce3d_ACT_c41888b6-15ba-11ee-b3b1-00d86184ce3d_SESS_c41a4d8e-15ba-11ee-b3b1-00d86184ce3d_TOSC_9017917f-15be-11ee-a062-a0510b46b473_SNAPS','d1aa0e65-15be-11ee-a062-a0510b46b473.png','d1aa0e65-15be-11ee-a062-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.25.2.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-28 16:19:40.061','2023-06-28 14:19:40.615',NULL),('d20ebb91-2ae9-11ee-97fa-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_8b758c52-2ae7-11ee-97fa-a0510b46b473/occlusion_8b789858-2ae7-11ee-97fa-a0510b46b473/scan_96c65fac-2ae9-11ee-97fa-a0510b46b473/d20ebb91-2ae9-11ee-97fa-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_8b758c52-2ae7-11ee-97fa-a0510b46b473_SESS_8b789858-2ae7-11ee-97fa-a0510b46b473_TOSC_96c65fac-2ae9-11ee-97fa-a0510b46b473_MODEL','d20ebb91-2ae9-11ee-97fa-a0510b46b473.zip','d20ebb91-2ae9-11ee-97fa-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.9.1.4\",\"modelMatrix\":\"0.904239,0.386814,-0.180904,0,-0.427026,0.819089,-0.38307,0,3.68288e-09,0.423638,0.905831,0,-30.8432,0.826107,-9.19046,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-25 14:50:23.499','2023-07-25 12:50:24.000',NULL),('d20ed29c-2ae9-11ee-97fa-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_8b758c52-2ae7-11ee-97fa-a0510b46b473/occlusion_8b789858-2ae7-11ee-97fa-a0510b46b473/scan_96c65fac-2ae9-11ee-97fa-a0510b46b473/d20ed29c-2ae9-11ee-97fa-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_8b758c52-2ae7-11ee-97fa-a0510b46b473_SESS_8b789858-2ae7-11ee-97fa-a0510b46b473_TOSC_96c65fac-2ae9-11ee-97fa-a0510b46b473_SNAPS','d20ed29c-2ae9-11ee-97fa-a0510b46b473.png','d20ed29c-2ae9-11ee-97fa-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.9.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-25 14:50:23.499','2023-07-25 12:50:24.003',NULL),('d360065b-2ac0-11ee-80c8-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_3a881645-2abf-11ee-80c8-a0510b46b473/occlusion_3a8b3537-2abf-11ee-80c8-a0510b46b473/scan_a326ab82-2ac0-11ee-80c8-a0510b46b473/d360065b-2ac0-11ee-80c8-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_3a881645-2abf-11ee-80c8-a0510b46b473_SESS_3a8b3537-2abf-11ee-80c8-a0510b46b473_TOSC_a326ab82-2ac0-11ee-80c8-a0510b46b473_MODEL','d360065b-2ac0-11ee-80c8-a0510b46b473.zip','d360065b-2ac0-11ee-80c8-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.7.1.3\",\"modelMatrix\":\"0.87659,0.437075,-0.201385,0,-0.481239,0.796144,-0.366829,0,8.31946e-09,0.418472,0.908229,0,-32.5932,2.75153,-7.85842,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-25 09:56:56.343','2023-07-25 07:56:56.689',NULL),('d3601e2a-2ac0-11ee-80c8-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_3a881645-2abf-11ee-80c8-a0510b46b473/occlusion_3a8b3537-2abf-11ee-80c8-a0510b46b473/scan_a326ab82-2ac0-11ee-80c8-a0510b46b473/d3601e2a-2ac0-11ee-80c8-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_3a881645-2abf-11ee-80c8-a0510b46b473_SESS_3a8b3537-2abf-11ee-80c8-a0510b46b473_TOSC_a326ab82-2ac0-11ee-80c8-a0510b46b473_SNAPS','d3601e2a-2ac0-11ee-80c8-a0510b46b473.png','d3601e2a-2ac0-11ee-80c8-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.7.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-25 09:56:56.344','2023-07-25 07:56:56.692',NULL),('d3ac0a97-1bd8-11ee-9086-a0510b46b473',11,'/home/scan/.data//2023/11/61e16a70-1a76-11ee-8124-a0510b46b473/session_a0a47257-1bd8-11ee-9086-a0510b46b473/occlusion_a0a77bfe-1bd8-11ee-9086-a0510b46b473/scan_a2399398-1bd8-11ee-9086-a0510b46b473/d3ac0a97-1bd8-11ee-9086-a0510b46b473.zip','PATIENT_61e16a70-1a76-11ee-8124-a0510b46b473_ACT_a0a47257-1bd8-11ee-9086-a0510b46b473_SESS_a0a77bfe-1bd8-11ee-9086-a0510b46b473_TOSC_a2399398-1bd8-11ee-9086-a0510b46b473_MODEL','d3ac0a97-1bd8-11ee-9086-a0510b46b473.zip','d3ac0a97-1bd8-11ee-9086-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.27.3.1.1\",\"modelMatrix\":\"-0.712596,-0.636595,0.294881,0,0.701575,-0.646594,0.299513,0,4.12545e-10,0.420313,0.907379,0,17.283,-0.119029,-12.8609,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,'2023-07-06 10:41:03.138','2023-07-06 10:40:57.321','2023-07-06 08:41:03.142',NULL),('d3ac2461-1bd8-11ee-9086-a0510b46b473',11,'/home/scan/.data//2023/11/61e16a70-1a76-11ee-8124-a0510b46b473/session_a0a47257-1bd8-11ee-9086-a0510b46b473/occlusion_a0a77bfe-1bd8-11ee-9086-a0510b46b473/scan_a2399398-1bd8-11ee-9086-a0510b46b473/d3ac2461-1bd8-11ee-9086-a0510b46b473.png','PATIENT_61e16a70-1a76-11ee-8124-a0510b46b473_ACT_a0a47257-1bd8-11ee-9086-a0510b46b473_SESS_a0a77bfe-1bd8-11ee-9086-a0510b46b473_TOSC_a2399398-1bd8-11ee-9086-a0510b46b473_SNAPS','d3ac2461-1bd8-11ee-9086-a0510b46b473.png','d3ac2461-1bd8-11ee-9086-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.27.3.1.1 Snapshot\"}','PNG',0,'CREATED',0,'2023-07-06 10:41:03.138','2023-07-06 10:40:57.322','2023-07-06 08:41:03.146',NULL),('d3bd13e4-1a64-11ee-9a4f-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_9f32257c-1a64-11ee-9a4f-a0510b46b473/occlusion_9f33e64c-1a64-11ee-9a4f-a0510b46b473/scan_a0303c50-1a64-11ee-9a4f-a0510b46b473/d3bd13e4-1a64-11ee-9a4f-a0510b46b473.zip','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_9f32257c-1a64-11ee-9a4f-a0510b46b473_SESS_9f33e64c-1a64-11ee-9a4f-a0510b46b473_TOSC_a0303c50-1a64-11ee-9a4f-a0510b46b473_MODEL','d3bd13e4-1a64-11ee-9a4f-a0510b46b473.zip','d3bd13e4-1a64-11ee-9a4f-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.2.1.1\",\"modelMatrix\":\"0.961708,0.249291,-0.113893,0,-0.274076,0.87474,-0.39964,0,-5.5461e-09,0.415553,0.909569,0,-25.5253,9.77632,-14.0589,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-04 14:18:04.650','2023-07-04 12:18:05.132',NULL),('d3bd2d3a-1a64-11ee-9a4f-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_9f32257c-1a64-11ee-9a4f-a0510b46b473/occlusion_9f33e64c-1a64-11ee-9a4f-a0510b46b473/scan_a0303c50-1a64-11ee-9a4f-a0510b46b473/d3bd2d3a-1a64-11ee-9a4f-a0510b46b473.png','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_9f32257c-1a64-11ee-9a4f-a0510b46b473_SESS_9f33e64c-1a64-11ee-9a4f-a0510b46b473_TOSC_a0303c50-1a64-11ee-9a4f-a0510b46b473_SNAPS','d3bd2d3a-1a64-11ee-9a4f-a0510b46b473.png','d3bd2d3a-1a64-11ee-9a4f-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.2.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-04 14:18:04.650','2023-07-04 12:18:05.133',NULL),('d41e9ac8-15b6-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/142e7037-15b6-11ee-b3b1-00d86184ce3d/session_1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d/occlusion_1ed7780a-15b6-11ee-b3b1-00d86184ce3d/scan_80d0087a-15b6-11ee-b3b1-00d86184ce3d/d41e9ac8-15b6-11ee-b3b1-00d86184ce3d.zip','PATIENT_142e7037-15b6-11ee-b3b1-00d86184ce3d_ACT_1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d_SESS_1ed7780a-15b6-11ee-b3b1-00d86184ce3d_TOSC_80d0087a-15b6-11ee-b3b1-00d86184ce3d_MODEL','d41e9ac8-15b6-11ee-b3b1-00d86184ce3d.zip','d41e9ac8-15b6-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.25.1.1.2\",\"modelMatrix\":\"0.42391,0.879077,-0.218,0,-0.905705,0.411447,-0.102034,0,-1.04594e-09,0.240696,0.9706,0,-29.6621,-15.7476,-9.38994,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-28 15:22:28.207','2023-06-28 13:22:28.961',NULL),('d41f1ce1-15b6-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/142e7037-15b6-11ee-b3b1-00d86184ce3d/session_1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d/occlusion_1ed7780a-15b6-11ee-b3b1-00d86184ce3d/scan_80d0087a-15b6-11ee-b3b1-00d86184ce3d/d41f1ce1-15b6-11ee-b3b1-00d86184ce3d.png','PATIENT_142e7037-15b6-11ee-b3b1-00d86184ce3d_ACT_1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d_SESS_1ed7780a-15b6-11ee-b3b1-00d86184ce3d_TOSC_80d0087a-15b6-11ee-b3b1-00d86184ce3d_SNAPS','d41f1ce1-15b6-11ee-b3b1-00d86184ce3d.png','d41f1ce1-15b6-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.25.1.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-28 15:22:28.210','2023-06-28 13:22:28.961',NULL),('d5faa688-deb4-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/cf3f0588-deb2-11ed-9cc3-00d86184ce3d/session_d7750b8d-deb2-11ed-9cc3-00d86184ce3d/occlusion_d7775a50-deb2-11ed-9cc3-00d86184ce3d/scan_67f7dd8f-deb4-11ed-9cc3-00d86184ce3d/d5faa688-deb4-11ed-9cc3-00d86184ce3d.zip','PATIENT_cf3f0588-deb2-11ed-9cc3-00d86184ce3d_ACT_d7750b8d-deb2-11ed-9cc3-00d86184ce3d_SESS_d7775a50-deb2-11ed-9cc3-00d86184ce3d_TOSC_67f7dd8f-deb4-11ed-9cc3-00d86184ce3d_MODEL','d5faa688-deb4-11ed-9cc3-00d86184ce3d.zip','d5faa688-deb4-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.6.1.1.4\",\"modelMatrix\":\"-0.486371,0.844511,-0.224154,0,-0.873753,-0.470093,0.124774,0,-3.22036e-09,0.256542,0.966533,0,-6.90431,-30.6539,-7.65587,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-19 15:19:38.380','2023-04-19 13:19:39.541',NULL),('d5fabe91-deb4-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/cf3f0588-deb2-11ed-9cc3-00d86184ce3d/session_d7750b8d-deb2-11ed-9cc3-00d86184ce3d/occlusion_d7775a50-deb2-11ed-9cc3-00d86184ce3d/scan_67f7dd8f-deb4-11ed-9cc3-00d86184ce3d/d5fabe91-deb4-11ed-9cc3-00d86184ce3d.png','PATIENT_cf3f0588-deb2-11ed-9cc3-00d86184ce3d_ACT_d7750b8d-deb2-11ed-9cc3-00d86184ce3d_SESS_d7775a50-deb2-11ed-9cc3-00d86184ce3d_TOSC_67f7dd8f-deb4-11ed-9cc3-00d86184ce3d_SNAPS','d5fabe91-deb4-11ed-9cc3-00d86184ce3d.png','d5fabe91-deb4-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.6.1.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-19 15:19:38.381','2023-04-19 13:19:39.543',NULL),('d6a643f3-e036-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_63b81b7e-e035-11ed-bb13-00d86184ce3d/occlusion_63bb1989-e035-11ed-bb13-00d86184ce3d/scan_bdc2ccd7-e036-11ed-bb13-00d86184ce3d/d6a643f3-e036-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_63b81b7e-e035-11ed-bb13-00d86184ce3d_SESS_63bb1989-e035-11ed-bb13-00d86184ce3d_TOSC_bdc2ccd7-e036-11ed-bb13-00d86184ce3d_MODEL','d6a643f3-e036-11ed-bb13-00d86184ce3d.zip','d6a643f3-e036-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.2.1.3\",\"modelMatrix\":\"0.326597,0.802338,-0.499588,0,-0.945164,0.277244,-0.17263,0,2.78889e-09,0.528573,0.848888,0,2.01763,-15.749,-9.56219,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 13:22:45.243','2023-04-21 11:22:45.517',NULL),('d6a66d6d-e036-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_63b81b7e-e035-11ed-bb13-00d86184ce3d/occlusion_63bb1989-e035-11ed-bb13-00d86184ce3d/scan_bdc2ccd7-e036-11ed-bb13-00d86184ce3d/d6a66d6d-e036-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_63b81b7e-e035-11ed-bb13-00d86184ce3d_SESS_63bb1989-e035-11ed-bb13-00d86184ce3d_TOSC_bdc2ccd7-e036-11ed-bb13-00d86184ce3d_SNAPS','d6a66d6d-e036-11ed-bb13-00d86184ce3d.png','d6a66d6d-e036-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.2.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 13:22:45.244','2023-04-21 11:22:45.528',NULL),('d773d59d-26e4-11ee-a836-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_d5ef2d6b-26e3-11ee-a836-a0510b46b473/occlusion_d5f241c9-26e3-11ee-a836-a0510b46b473/scan_83fb0690-26e4-11ee-a836-a0510b46b473/d773d59d-26e4-11ee-a836-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_d5ef2d6b-26e3-11ee-a836-a0510b46b473_SESS_d5f241c9-26e3-11ee-a836-a0510b46b473_TOSC_83fb0690-26e4-11ee-a836-a0510b46b473_MODEL','d773d59d-26e4-11ee-a836-a0510b46b473.zip','d773d59d-26e4-11ee-a836-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.5.1.3\",\"modelMatrix\":\"-0.225348,0.932598,-0.281921,0,-0.974278,-0.215708,0.0652076,0,3.76968e-09,0.289364,0.957219,0,-14.0479,-31.7228,-7.43454,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-20 12:04:40.415','2023-07-20 10:04:41.215',NULL),('d773ee62-26e4-11ee-a836-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_d5ef2d6b-26e3-11ee-a836-a0510b46b473/occlusion_d5f241c9-26e3-11ee-a836-a0510b46b473/scan_83fb0690-26e4-11ee-a836-a0510b46b473/d773ee62-26e4-11ee-a836-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_d5ef2d6b-26e3-11ee-a836-a0510b46b473_SESS_d5f241c9-26e3-11ee-a836-a0510b46b473_TOSC_83fb0690-26e4-11ee-a836-a0510b46b473_SNAPS','d773ee62-26e4-11ee-a836-a0510b46b473.png','d773ee62-26e4-11ee-a836-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.5.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-20 12:04:40.416','2023-07-20 10:04:41.223',NULL),('d7bb186b-de86-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/f29210da-de80-11ed-9cc3-00d86184ce3d/session_ffdb9942-de80-11ed-9cc3-00d86184ce3d/occlusion_ffdebb3e-de80-11ed-9cc3-00d86184ce3d/scan_7ccbaae8-de86-11ed-9cc3-00d86184ce3d/d7bb186b-de86-11ed-9cc3-00d86184ce3d.zip','PATIENT_f29210da-de80-11ed-9cc3-00d86184ce3d_ACT_ffdb9942-de80-11ed-9cc3-00d86184ce3d_SESS_ffdebb3e-de80-11ed-9cc3-00d86184ce3d_TOSC_7ccbaae8-de86-11ed-9cc3-00d86184ce3d_MODEL','d7bb186b-de86-11ed-9cc3-00d86184ce3d.zip','d7bb186b-de86-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.3.1.1.4\",\"modelMatrix\":\"-0.31488,0.915996,-0.248602,0,-0.949132,-0.303887,0.0824749,0,-5.47936e-09,0.261925,0.965088,0,-15.1166,-27.23,-7.5292,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-04-19 09:50:24.470','2023-04-19 07:50:25.473','2023-04-19 09:50:26.985'),('d7bb2d3e-de86-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/f29210da-de80-11ed-9cc3-00d86184ce3d/session_ffdb9942-de80-11ed-9cc3-00d86184ce3d/occlusion_ffdebb3e-de80-11ed-9cc3-00d86184ce3d/scan_7ccbaae8-de86-11ed-9cc3-00d86184ce3d/d7bb2d3e-de86-11ed-9cc3-00d86184ce3d.png','PATIENT_f29210da-de80-11ed-9cc3-00d86184ce3d_ACT_ffdb9942-de80-11ed-9cc3-00d86184ce3d_SESS_ffdebb3e-de80-11ed-9cc3-00d86184ce3d_TOSC_7ccbaae8-de86-11ed-9cc3-00d86184ce3d_SNAPS','d7bb2d3e-de86-11ed-9cc3-00d86184ce3d.png','d7bb2d3e-de86-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.3.1.1.4 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-04-19 09:50:24.470','2023-04-19 07:50:25.474','2023-04-19 09:50:27.114'),('d9780c94-e01c-11ed-a285-00d86184ce3d',11,'/home/scan/.data//2023/11/5f27680c-e01a-11ed-b6c2-00d86184ce3d/session_65b85f32-e01a-11ed-b6c2-00d86184ce3d/occlusion_65ba9a94-e01a-11ed-b6c2-00d86184ce3d/scan_88e2a894-e01c-11ed-a285-00d86184ce3d/d9780c94-e01c-11ed-a285-00d86184ce3d.zip','PATIENT_5f27680c-e01a-11ed-b6c2-00d86184ce3d_ACT_65b85f32-e01a-11ed-b6c2-00d86184ce3d_SESS_65ba9a94-e01a-11ed-b6c2-00d86184ce3d_TOSC_88e2a894-e01c-11ed-a285-00d86184ce3d_MODEL','d9780c94-e01c-11ed-a285-00d86184ce3d.zip','d9780c94-e01c-11ed-a285-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.10.1.1.2\",\"modelMatrix\":\"0.218779,0.913265,-0.343631,0,-0.975774,0.204764,-0.0770456,0,2.30042e-09,0.352162,0.935939,0,-26.2814,-17.511,-5.9502,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 10:16:43.058','2023-04-21 08:16:44.102',NULL),('d97825c4-e01c-11ed-a285-00d86184ce3d',11,'/home/scan/.data//2023/11/5f27680c-e01a-11ed-b6c2-00d86184ce3d/session_65b85f32-e01a-11ed-b6c2-00d86184ce3d/occlusion_65ba9a94-e01a-11ed-b6c2-00d86184ce3d/scan_88e2a894-e01c-11ed-a285-00d86184ce3d/d97825c4-e01c-11ed-a285-00d86184ce3d.png','PATIENT_5f27680c-e01a-11ed-b6c2-00d86184ce3d_ACT_65b85f32-e01a-11ed-b6c2-00d86184ce3d_SESS_65ba9a94-e01a-11ed-b6c2-00d86184ce3d_TOSC_88e2a894-e01c-11ed-a285-00d86184ce3d_SNAPS','d97825c4-e01c-11ed-a285-00d86184ce3d.png','d97825c4-e01c-11ed-a285-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.10.1.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 10:16:43.058','2023-04-21 08:16:44.102',NULL),('d9e84fe8-2ae7-11ee-97fa-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_8b758c52-2ae7-11ee-97fa-a0510b46b473/occlusion_8b789858-2ae7-11ee-97fa-a0510b46b473/scan_94a0503f-2ae7-11ee-97fa-a0510b46b473/d9e84fe8-2ae7-11ee-97fa-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_8b758c52-2ae7-11ee-97fa-a0510b46b473_SESS_8b789858-2ae7-11ee-97fa-a0510b46b473_TOSC_94a0503f-2ae7-11ee-97fa-a0510b46b473_MODEL','d9e84fe8-2ae7-11ee-97fa-a0510b46b473.zip','d9e84fe8-2ae7-11ee-97fa-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.9.1.1\",\"modelMatrix\":\"0.983514,0.158502,-0.0870458,0,-0.180831,0.862069,-0.473431,0,7.46081e-10,0.481367,0.876519,0,-29.5984,7.13451,-12.2577,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-25 14:36:17.675','2023-07-25 12:36:18.193',NULL),('d9e867d9-2ae7-11ee-97fa-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_8b758c52-2ae7-11ee-97fa-a0510b46b473/occlusion_8b789858-2ae7-11ee-97fa-a0510b46b473/scan_94a0503f-2ae7-11ee-97fa-a0510b46b473/d9e867d9-2ae7-11ee-97fa-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_8b758c52-2ae7-11ee-97fa-a0510b46b473_SESS_8b789858-2ae7-11ee-97fa-a0510b46b473_TOSC_94a0503f-2ae7-11ee-97fa-a0510b46b473_SNAPS','d9e867d9-2ae7-11ee-97fa-a0510b46b473.png','d9e867d9-2ae7-11ee-97fa-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.9.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-25 14:36:17.676','2023-07-25 12:36:18.195',NULL),('daa6a8eb-0f42-11ee-8712-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_55019e04-0f41-11ee-8712-a0510b46b473/occlusion_550492f3-0f41-11ee-8712-a0510b46b473/scan_a793af5d-0f42-11ee-8712-a0510b46b473/daa6a8eb-0f42-11ee-8712-a0510b46b473.zip','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_55019e04-0f41-11ee-8712-a0510b46b473_SESS_550492f3-0f41-11ee-8712-a0510b46b473_TOSC_a793af5d-0f42-11ee-8712-a0510b46b473_MODEL','daa6a8eb-0f42-11ee-8712-a0510b46b473.zip','daa6a8eb-0f42-11ee-8712-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.2.1.5\",\"modelMatrix\":\"0.343708,0.51307,-0.786527,0,-0.939077,0.187787,-0.287874,0,-4.48275e-09,0.837554,0.546355,0,-86.0177,-17.1916,14.1044,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-20 10:17:10.567','2023-06-20 08:17:10.991',NULL),('daa6bda2-0f42-11ee-8712-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_55019e04-0f41-11ee-8712-a0510b46b473/occlusion_550492f3-0f41-11ee-8712-a0510b46b473/scan_a793af5d-0f42-11ee-8712-a0510b46b473/daa6bda2-0f42-11ee-8712-a0510b46b473.png','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_55019e04-0f41-11ee-8712-a0510b46b473_SESS_550492f3-0f41-11ee-8712-a0510b46b473_TOSC_a793af5d-0f42-11ee-8712-a0510b46b473_SNAPS','daa6bda2-0f42-11ee-8712-a0510b46b473.png','daa6bda2-0f42-11ee-8712-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.2.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-20 10:17:10.568','2023-06-20 08:17:10.991',NULL),('dab89c30-1cb1-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/4375c5f1-1cad-11ee-997b-a0510b46b473/session_dfb50528-1cb0-11ee-997b-a0510b46b473/occlusion_dfb7e00f-1cb0-11ee-997b-a0510b46b473/scan_99e4fc40-1cb1-11ee-997b-a0510b46b473/dab89c30-1cb1-11ee-997b-a0510b46b473.zip','PATIENT_4375c5f1-1cad-11ee-997b-a0510b46b473_ACT_dfb50528-1cb0-11ee-997b-a0510b46b473_SESS_dfb7e00f-1cb0-11ee-997b-a0510b46b473_TOSC_99e4fc40-1cb1-11ee-997b-a0510b46b473_MODEL','dab89c30-1cb1-11ee-997b-a0510b46b473.zip','dab89c30-1cb1-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.31.2.1.4\",\"modelMatrix\":\"0.972445,0.207164,-0.106925,0,-0.23313,0.864133,-0.44601,0,3.79763e-09,0.458648,0.888618,0,-13.6836,10.8586,-13.1377,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-07 12:34:29.938','2023-07-07 10:34:30.451',NULL),('dab8b242-1cb1-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/4375c5f1-1cad-11ee-997b-a0510b46b473/session_dfb50528-1cb0-11ee-997b-a0510b46b473/occlusion_dfb7e00f-1cb0-11ee-997b-a0510b46b473/scan_99e4fc40-1cb1-11ee-997b-a0510b46b473/dab8b242-1cb1-11ee-997b-a0510b46b473.png','PATIENT_4375c5f1-1cad-11ee-997b-a0510b46b473_ACT_dfb50528-1cb0-11ee-997b-a0510b46b473_SESS_dfb7e00f-1cb0-11ee-997b-a0510b46b473_TOSC_99e4fc40-1cb1-11ee-997b-a0510b46b473_SNAPS','dab8b242-1cb1-11ee-997b-a0510b46b473.png','dab8b242-1cb1-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.31.2.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-07 12:34:29.939','2023-07-07 10:34:30.454',NULL),('db1f3b5f-1bd2-11ee-9086-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_a6b1a4bd-1bcf-11ee-9086-a0510b46b473/occlusion_a6b491c8-1bcf-11ee-9086-a0510b46b473/scan_6d4e7407-1bd2-11ee-9086-a0510b46b473/db1f3b5f-1bd2-11ee-9086-a0510b46b473.zip','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_a6b1a4bd-1bcf-11ee-9086-a0510b46b473_SESS_a6b491c8-1bcf-11ee-9086-a0510b46b473_TOSC_6d4e7407-1bd2-11ee-9086-a0510b46b473_MODEL','db1f3b5f-1bd2-11ee-9086-a0510b46b473.zip','db1f3b5f-1bd2-11ee-9086-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.3.1.8\",\"modelMatrix\":\"0.187472,0.960499,-0.205661,0,-0.98227,0.183317,-0.0392516,0,-1.34309e-10,0.209373,0.977836,0,-23.877,-22.0989,-8.79495,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 09:58:12.840','2023-07-06 07:58:13.842',NULL),('db1f5008-1bd2-11ee-9086-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_a6b1a4bd-1bcf-11ee-9086-a0510b46b473/occlusion_a6b491c8-1bcf-11ee-9086-a0510b46b473/scan_6d4e7407-1bd2-11ee-9086-a0510b46b473/db1f5008-1bd2-11ee-9086-a0510b46b473.png','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_a6b1a4bd-1bcf-11ee-9086-a0510b46b473_SESS_a6b491c8-1bcf-11ee-9086-a0510b46b473_TOSC_6d4e7407-1bd2-11ee-9086-a0510b46b473_SNAPS','db1f5008-1bd2-11ee-9086-a0510b46b473.png','db1f5008-1bd2-11ee-9086-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.3.1.8 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 09:58:12.840','2023-07-06 07:58:13.851',NULL),('db2f9d88-10f8-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/ed94fe78-10f4-11ee-b636-a0510b46b473/session_f8ef8fe7-10f4-11ee-b636-a0510b46b473/occlusion_f8f2e241-10f4-11ee-b636-a0510b46b473/scan_7b6c0c01-10f8-11ee-b636-a0510b46b473/db2f9d88-10f8-11ee-b636-a0510b46b473.zip','PATIENT_ed94fe78-10f4-11ee-b636-a0510b46b473_ACT_f8ef8fe7-10f4-11ee-b636-a0510b46b473_SESS_f8f2e241-10f4-11ee-b636-a0510b46b473_TOSC_7b6c0c01-10f8-11ee-b636-a0510b46b473_MODEL','db2f9d88-10f8-11ee-b636-a0510b46b473.zip','db2f9d88-10f8-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.19.1.1.1\",\"modelMatrix\":\"0.0738055,0.97413,-0.213598,0,-0.997273,0.0720927,-0.0158078,0,-1.53242e-09,0.214182,0.976794,0,-20.1485,-25.2253,-7.37704,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 14:32:31.032','2023-06-22 12:32:31.710',NULL),('db30de3a-10f8-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/ed94fe78-10f4-11ee-b636-a0510b46b473/session_f8ef8fe7-10f4-11ee-b636-a0510b46b473/occlusion_f8f2e241-10f4-11ee-b636-a0510b46b473/scan_7b6c0c01-10f8-11ee-b636-a0510b46b473/db30de3a-10f8-11ee-b636-a0510b46b473.png','PATIENT_ed94fe78-10f4-11ee-b636-a0510b46b473_ACT_f8ef8fe7-10f4-11ee-b636-a0510b46b473_SESS_f8f2e241-10f4-11ee-b636-a0510b46b473_TOSC_7b6c0c01-10f8-11ee-b636-a0510b46b473_SNAPS','db30de3a-10f8-11ee-b636-a0510b46b473.png','db30de3a-10f8-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.19.1.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 14:32:31.041','2023-06-22 12:32:31.711',NULL),('db65503e-1105-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_0628a8e9-1104-11ee-b636-a0510b46b473/occlusion_062b833f-1104-11ee-b636-a0510b46b473/scan_8c4ffac3-1105-11ee-b636-a0510b46b473/db65503e-1105-11ee-b636-a0510b46b473.zip','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_0628a8e9-1104-11ee-b636-a0510b46b473_SESS_062b833f-1104-11ee-b636-a0510b46b473_TOSC_8c4ffac3-1105-11ee-b636-a0510b46b473_MODEL','db65503e-1105-11ee-b636-a0510b46b473.zip','db65503e-1105-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.20.1.1.4\",\"modelMatrix\":\"0.217818,0.933806,-0.283835,0,-0.975989,0.208403,-0.0633454,0,3.24675e-09,0.290818,0.956778,0,-22.196,-27.3889,-6.37057,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 16:05:34.842','2023-06-22 14:05:35.594',NULL),('db65668d-1105-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_0628a8e9-1104-11ee-b636-a0510b46b473/occlusion_062b833f-1104-11ee-b636-a0510b46b473/scan_8c4ffac3-1105-11ee-b636-a0510b46b473/db65668d-1105-11ee-b636-a0510b46b473.png','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_0628a8e9-1104-11ee-b636-a0510b46b473_SESS_062b833f-1104-11ee-b636-a0510b46b473_TOSC_8c4ffac3-1105-11ee-b636-a0510b46b473_SNAPS','db65668d-1105-11ee-b636-a0510b46b473.png','db65668d-1105-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.20.1.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 16:05:34.842','2023-06-22 14:05:35.595',NULL),('dbcb9c47-26fa-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/c69c4cec-26f5-11ee-aa9d-a0510b46b473/session_4de7c46e-26fa-11ee-a98e-a0510b46b473/occlusion_4deac8dd-26fa-11ee-a98e-a0510b46b473/scan_a7661b8d-26fa-11ee-a98e-a0510b46b473/dbcb9c47-26fa-11ee-a98e-a0510b46b473.zip','PATIENT_c69c4cec-26f5-11ee-aa9d-a0510b46b473_ACT_4de7c46e-26fa-11ee-a98e-a0510b46b473_SESS_4deac8dd-26fa-11ee-a98e-a0510b46b473_TOSC_a7661b8d-26fa-11ee-a98e-a0510b46b473_MODEL','dbcb9c47-26fa-11ee-a98e-a0510b46b473.zip','dbcb9c47-26fa-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.35.2.1.2\",\"modelMatrix\":\"0.366525,0.919989,-0.138852,0,-0.930408,0.36242,-0.0546993,0,-1.75594e-09,0.149238,0.988801,0,-21.7546,-21.3087,-11.4152,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-20 14:42:16.629','2023-07-20 12:42:17.106',NULL),('dbcbb2dc-26fa-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/c69c4cec-26f5-11ee-aa9d-a0510b46b473/session_4de7c46e-26fa-11ee-a98e-a0510b46b473/occlusion_4deac8dd-26fa-11ee-a98e-a0510b46b473/scan_a7661b8d-26fa-11ee-a98e-a0510b46b473/dbcbb2dc-26fa-11ee-a98e-a0510b46b473.png','PATIENT_c69c4cec-26f5-11ee-aa9d-a0510b46b473_ACT_4de7c46e-26fa-11ee-a98e-a0510b46b473_SESS_4deac8dd-26fa-11ee-a98e-a0510b46b473_TOSC_a7661b8d-26fa-11ee-a98e-a0510b46b473_SNAPS','dbcbb2dc-26fa-11ee-a98e-a0510b46b473.png','dbcbb2dc-26fa-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.35.2.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-20 14:42:16.630','2023-07-20 12:42:17.109',NULL),('dbdc0949-262b-11ee-8042-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_62519c59-261f-11ee-8042-a0510b46b473/occlusion_6253caa6-261f-11ee-8042-a0510b46b473/scan_9163b3c8-262b-11ee-8042-a0510b46b473/dbdc0949-262b-11ee-8042-a0510b46b473.zip','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_62519c59-261f-11ee-8042-a0510b46b473_SESS_6253caa6-261f-11ee-8042-a0510b46b473_TOSC_9163b3c8-262b-11ee-8042-a0510b46b473_MODEL','dbdc0949-262b-11ee-8042-a0510b46b473.zip','dbdc0949-262b-11ee-8042-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.1.1.8\",\"modelMatrix\":\"-0.385921,0.899343,-0.205544,0,-0.922532,-0.37622,0.0859849,0,4.22681e-09,0.222805,0.974863,0,-9.57553,-23.9267,-13.1346,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-19 14:00:30.914','2023-07-19 12:00:31.602',NULL),('dbdc205a-262b-11ee-8042-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_62519c59-261f-11ee-8042-a0510b46b473/occlusion_6253caa6-261f-11ee-8042-a0510b46b473/scan_9163b3c8-262b-11ee-8042-a0510b46b473/dbdc205a-262b-11ee-8042-a0510b46b473.png','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_62519c59-261f-11ee-8042-a0510b46b473_SESS_6253caa6-261f-11ee-8042-a0510b46b473_TOSC_9163b3c8-262b-11ee-8042-a0510b46b473_SNAPS','dbdc205a-262b-11ee-8042-a0510b46b473.png','dbdc205a-262b-11ee-8042-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.1.1.8 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-19 14:00:30.915','2023-07-19 12:00:31.605',NULL),('dc5bf00a-158b-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/634153bc-1587-11ee-b3b1-00d86184ce3d/session_6e9df503-1587-11ee-b3b1-00d86184ce3d/occlusion_6ea0d9b2-1587-11ee-b3b1-00d86184ce3d/scan_c4cd30c6-158b-11ee-b3b1-00d86184ce3d/dc5bf00a-158b-11ee-b3b1-00d86184ce3d.zip','PATIENT_634153bc-1587-11ee-b3b1-00d86184ce3d_ACT_6e9df503-1587-11ee-b3b1-00d86184ce3d_SESS_6ea0d9b2-1587-11ee-b3b1-00d86184ce3d_TOSC_c4cd30c6-158b-11ee-b3b1-00d86184ce3d_MODEL','dc5bf00a-158b-11ee-b3b1-00d86184ce3d.zip','dc5bf00a-158b-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.24.1.1.6\",\"modelMatrix\":\"-0.435972,-0.89681,0.0752344,0,0.89996,-0.434446,0.0364462,0,1.36545e-10,0.0835975,0.9965,0,29.2737,10.9475,-11.3207,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-28 10:14:53.671','2023-06-28 08:14:53.878',NULL),('dc5c07e8-158b-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/634153bc-1587-11ee-b3b1-00d86184ce3d/session_6e9df503-1587-11ee-b3b1-00d86184ce3d/occlusion_6ea0d9b2-1587-11ee-b3b1-00d86184ce3d/scan_c4cd30c6-158b-11ee-b3b1-00d86184ce3d/dc5c07e8-158b-11ee-b3b1-00d86184ce3d.png','PATIENT_634153bc-1587-11ee-b3b1-00d86184ce3d_ACT_6e9df503-1587-11ee-b3b1-00d86184ce3d_SESS_6ea0d9b2-1587-11ee-b3b1-00d86184ce3d_TOSC_c4cd30c6-158b-11ee-b3b1-00d86184ce3d_SNAPS','dc5c07e8-158b-11ee-b3b1-00d86184ce3d.png','dc5c07e8-158b-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.24.1.1.6 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-28 10:14:53.672','2023-06-28 08:14:53.879',NULL),('dcfcb833-de8a-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/f29210da-de80-11ed-9cc3-00d86184ce3d/session_ffdb9942-de80-11ed-9cc3-00d86184ce3d/occlusion_ffdebb3e-de80-11ed-9cc3-00d86184ce3d/scan_7b79f25a-de8a-11ed-9cc3-00d86184ce3d/dcfcb833-de8a-11ed-9cc3-00d86184ce3d.zip','PATIENT_f29210da-de80-11ed-9cc3-00d86184ce3d_ACT_ffdb9942-de80-11ed-9cc3-00d86184ce3d_SESS_ffdebb3e-de80-11ed-9cc3-00d86184ce3d_TOSC_7b79f25a-de8a-11ed-9cc3-00d86184ce3d_MODEL','dcfcb833-de8a-11ed-9cc3-00d86184ce3d.zip','dcfcb833-de8a-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.3.1.1.9\",\"modelMatrix\":\"-0.036154,0.944342,-0.326973,0,-0.999346,-0.0341641,0.0118291,0,6.51295e-10,0.327187,0.94496,0,-21.4572,-22.7609,-5.16918,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-19 10:19:11.275','2023-04-19 08:19:12.485',NULL),('dcfccef2-de8a-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/f29210da-de80-11ed-9cc3-00d86184ce3d/session_ffdb9942-de80-11ed-9cc3-00d86184ce3d/occlusion_ffdebb3e-de80-11ed-9cc3-00d86184ce3d/scan_7b79f25a-de8a-11ed-9cc3-00d86184ce3d/dcfccef2-de8a-11ed-9cc3-00d86184ce3d.png','PATIENT_f29210da-de80-11ed-9cc3-00d86184ce3d_ACT_ffdb9942-de80-11ed-9cc3-00d86184ce3d_SESS_ffdebb3e-de80-11ed-9cc3-00d86184ce3d_TOSC_7b79f25a-de8a-11ed-9cc3-00d86184ce3d_SNAPS','dcfccef2-de8a-11ed-9cc3-00d86184ce3d.png','dcfccef2-de8a-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.3.1.1.9 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-19 10:19:11.276','2023-04-19 08:19:12.485',NULL),('de3ede6d-1cad-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/4375c5f1-1cad-11ee-997b-a0510b46b473/session_4a5f2876-1cad-11ee-997b-a0510b46b473/occlusion_4a624109-1cad-11ee-997b-a0510b46b473/scan_97650de0-1cad-11ee-997b-a0510b46b473/de3ede6d-1cad-11ee-997b-a0510b46b473.zip','PATIENT_4375c5f1-1cad-11ee-997b-a0510b46b473_ACT_4a5f2876-1cad-11ee-997b-a0510b46b473_SESS_4a624109-1cad-11ee-997b-a0510b46b473_TOSC_97650de0-1cad-11ee-997b-a0510b46b473_MODEL','de3ede6d-1cad-11ee-997b-a0510b46b473.zip','de3ede6d-1cad-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.31.1.1.2\",\"modelMatrix\":\"0.857313,0.506472,-0.0921973,0,-0.514795,0.843452,-0.153541,0,2.15643e-09,0.179095,0.983832,0,-34.3714,-1.83344,-12.4709,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-07 12:05:57.864','2023-07-07 10:05:58.508',NULL),('de3ef4c2-1cad-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/4375c5f1-1cad-11ee-997b-a0510b46b473/session_4a5f2876-1cad-11ee-997b-a0510b46b473/occlusion_4a624109-1cad-11ee-997b-a0510b46b473/scan_97650de0-1cad-11ee-997b-a0510b46b473/de3ef4c2-1cad-11ee-997b-a0510b46b473.png','PATIENT_4375c5f1-1cad-11ee-997b-a0510b46b473_ACT_4a5f2876-1cad-11ee-997b-a0510b46b473_SESS_4a624109-1cad-11ee-997b-a0510b46b473_TOSC_97650de0-1cad-11ee-997b-a0510b46b473_SNAPS','de3ef4c2-1cad-11ee-997b-a0510b46b473.png','de3ef4c2-1cad-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.31.1.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-07 12:05:57.865','2023-07-07 10:05:58.508',NULL),('de7bb723-e03b-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_6f09f9a8-e03a-11ed-bb13-00d86184ce3d/occlusion_6f0c3cda-e03a-11ed-bb13-00d86184ce3d/scan_c4113de9-e03b-11ed-bb13-00d86184ce3d/de7bb723-e03b-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_6f09f9a8-e03a-11ed-bb13-00d86184ce3d_SESS_6f0c3cda-e03a-11ed-bb13-00d86184ce3d_TOSC_c4113de9-e03b-11ed-bb13-00d86184ce3d_MODEL','de7bb723-e03b-11ed-bb13-00d86184ce3d.zip','de7bb723-e03b-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.3.1.6\",\"modelMatrix\":\"0.906292,0.314542,-0.282307,0,-0.422651,0.674473,-0.605353,0,8.14894e-09,0.667944,0.744211,0,-14.5958,-10.4496,-7.37926,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,'2023-04-21 14:04:05.635','2023-04-21 13:58:45.869','2023-04-21 12:04:05.640',NULL),('de7bcc4a-e03b-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_6f09f9a8-e03a-11ed-bb13-00d86184ce3d/occlusion_6f0c3cda-e03a-11ed-bb13-00d86184ce3d/scan_c4113de9-e03b-11ed-bb13-00d86184ce3d/de7bcc4a-e03b-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_6f09f9a8-e03a-11ed-bb13-00d86184ce3d_SESS_6f0c3cda-e03a-11ed-bb13-00d86184ce3d_TOSC_c4113de9-e03b-11ed-bb13-00d86184ce3d_SNAPS','de7bcc4a-e03b-11ed-bb13-00d86184ce3d.png','de7bcc4a-e03b-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.3.1.6 Snapshot\"}','PNG',0,'CREATED',0,'2023-04-21 14:04:05.636','2023-04-21 13:58:45.870','2023-04-21 12:04:05.643',NULL),('de9018ea-2ac1-11ee-80c8-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_3a881645-2abf-11ee-80c8-a0510b46b473/occlusion_3a8b3537-2abf-11ee-80c8-a0510b46b473/scan_99c041cd-2ac1-11ee-80c8-a0510b46b473/de9018ea-2ac1-11ee-80c8-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_3a881645-2abf-11ee-80c8-a0510b46b473_SESS_3a8b3537-2abf-11ee-80c8-a0510b46b473_TOSC_99c041cd-2ac1-11ee-80c8-a0510b46b473_MODEL','de9018ea-2ac1-11ee-80c8-a0510b46b473.zip','de9018ea-2ac1-11ee-80c8-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.7.1.6\",\"modelMatrix\":\"0.911573,0.386368,-0.140549,0,-0.411137,0.856654,-0.311626,0,9.99793e-10,0.341855,0.939753,0,-27.0739,3.13288,-10.8567,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-25 10:04:24.610','2023-07-25 08:04:25.146',NULL),('de9030d4-2ac1-11ee-80c8-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_3a881645-2abf-11ee-80c8-a0510b46b473/occlusion_3a8b3537-2abf-11ee-80c8-a0510b46b473/scan_99c041cd-2ac1-11ee-80c8-a0510b46b473/de9030d4-2ac1-11ee-80c8-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_3a881645-2abf-11ee-80c8-a0510b46b473_SESS_3a8b3537-2abf-11ee-80c8-a0510b46b473_TOSC_99c041cd-2ac1-11ee-80c8-a0510b46b473_SNAPS','de9030d4-2ac1-11ee-80c8-a0510b46b473.png','de9030d4-2ac1-11ee-80c8-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.7.1.6 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-25 10:04:24.611','2023-07-25 08:04:25.150',NULL),('debee989-1039-11ee-895b-a0510b46b473',11,'/home/scan/.data//2023/11/d75719c6-1032-11ee-895b-a0510b46b473/session_6897acc6-1035-11ee-895b-a0510b46b473/occlusion_689aa1f3-1035-11ee-895b-a0510b46b473/scan_a560f8b6-1039-11ee-895b-a0510b46b473/debee989-1039-11ee-895b-a0510b46b473.zip','PATIENT_d75719c6-1032-11ee-895b-a0510b46b473_ACT_6897acc6-1035-11ee-895b-a0510b46b473_SESS_689aa1f3-1035-11ee-895b-a0510b46b473_TOSC_a560f8b6-1039-11ee-895b-a0510b46b473_MODEL','debee989-1039-11ee-895b-a0510b46b473.zip','debee989-1039-11ee-895b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.16.2.1.4\",\"modelMatrix\":\"0.953553,0.285095,-0.0972486,0,-0.301225,0.902493,-0.307849,0,3.61075e-09,0.322844,0.946452,0,-28.7866,4.10583,-9.28585,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-21 15:45:23.129','2023-06-21 13:45:25.204',NULL),('debf01cd-1039-11ee-895b-a0510b46b473',11,'/home/scan/.data//2023/11/d75719c6-1032-11ee-895b-a0510b46b473/session_6897acc6-1035-11ee-895b-a0510b46b473/occlusion_689aa1f3-1035-11ee-895b-a0510b46b473/scan_a560f8b6-1039-11ee-895b-a0510b46b473/debf01cd-1039-11ee-895b-a0510b46b473.png','PATIENT_d75719c6-1032-11ee-895b-a0510b46b473_ACT_6897acc6-1035-11ee-895b-a0510b46b473_SESS_689aa1f3-1035-11ee-895b-a0510b46b473_TOSC_a560f8b6-1039-11ee-895b-a0510b46b473_SNAPS','debf01cd-1039-11ee-895b-a0510b46b473.png','debf01cd-1039-11ee-895b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.16.2.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-21 15:45:23.130','2023-06-21 13:45:25.239',NULL),('df251dbb-10e3-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/2ff330cd-10e1-11ee-b636-a0510b46b473/session_3adeac35-10e1-11ee-b636-a0510b46b473/occlusion_3ae23ec4-10e1-11ee-b636-a0510b46b473/scan_8663cbf9-10e3-11ee-b636-a0510b46b473/df251dbb-10e3-11ee-b636-a0510b46b473.zip','PATIENT_2ff330cd-10e1-11ee-b636-a0510b46b473_ACT_3adeac35-10e1-11ee-b636-a0510b46b473_SESS_3ae23ec4-10e1-11ee-b636-a0510b46b473_TOSC_8663cbf9-10e3-11ee-b636-a0510b46b473_MODEL','df251dbb-10e3-11ee-b636-a0510b46b473.zip','df251dbb-10e3-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.18.1.1.7\",\"modelMatrix\":\"0.816451,0.559336,-0.143356,0,-0.577414,0.790888,-0.202703,0,5.55345e-09,0.248273,0.96869,0,-30.9322,-5.84773,-9.45289,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 12:02:18.243','2023-06-22 10:02:18.984',NULL),('df25994b-10e3-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/2ff330cd-10e1-11ee-b636-a0510b46b473/session_3adeac35-10e1-11ee-b636-a0510b46b473/occlusion_3ae23ec4-10e1-11ee-b636-a0510b46b473/scan_8663cbf9-10e3-11ee-b636-a0510b46b473/df25994b-10e3-11ee-b636-a0510b46b473.png','PATIENT_2ff330cd-10e1-11ee-b636-a0510b46b473_ACT_3adeac35-10e1-11ee-b636-a0510b46b473_SESS_3ae23ec4-10e1-11ee-b636-a0510b46b473_TOSC_8663cbf9-10e3-11ee-b636-a0510b46b473_SNAPS','df25994b-10e3-11ee-b636-a0510b46b473.png','df25994b-10e3-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.18.1.1.7 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 12:02:18.246','2023-06-22 10:02:18.987',NULL),('df2b8d66-1587-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/634153bc-1587-11ee-b3b1-00d86184ce3d/session_6e9df503-1587-11ee-b3b1-00d86184ce3d/occlusion_6ea0d9b2-1587-11ee-b3b1-00d86184ce3d/scan_905e9915-1587-11ee-b3b1-00d86184ce3d/df2b8d66-1587-11ee-b3b1-00d86184ce3d.zip','PATIENT_634153bc-1587-11ee-b3b1-00d86184ce3d_ACT_6e9df503-1587-11ee-b3b1-00d86184ce3d_SESS_6ea0d9b2-1587-11ee-b3b1-00d86184ce3d_TOSC_905e9915-1587-11ee-b3b1-00d86184ce3d_MODEL','df2b8d66-1587-11ee-b3b1-00d86184ce3d.zip','df2b8d66-1587-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.24.1.1.1\",\"modelMatrix\":\"0.103148,0.965082,-0.240786,0,-0.994666,0.10008,-0.0249697,0,7.77333e-10,0.242078,0.970257,0,-23.6635,-19.7183,-8.75747,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-28 09:46:20.400','2023-06-28 07:46:21.087',NULL),('df2ba810-1587-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/634153bc-1587-11ee-b3b1-00d86184ce3d/session_6e9df503-1587-11ee-b3b1-00d86184ce3d/occlusion_6ea0d9b2-1587-11ee-b3b1-00d86184ce3d/scan_905e9915-1587-11ee-b3b1-00d86184ce3d/df2ba810-1587-11ee-b3b1-00d86184ce3d.png','PATIENT_634153bc-1587-11ee-b3b1-00d86184ce3d_ACT_6e9df503-1587-11ee-b3b1-00d86184ce3d_SESS_6ea0d9b2-1587-11ee-b3b1-00d86184ce3d_TOSC_905e9915-1587-11ee-b3b1-00d86184ce3d_SNAPS','df2ba810-1587-11ee-b3b1-00d86184ce3d.png','df2ba810-1587-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.24.1.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-28 09:46:20.401','2023-06-28 07:46:21.087',NULL),('df361a55-26f7-11ee-aa9d-a0510b46b473',11,'/home/scan/.data//2023/11/c69c4cec-26f5-11ee-aa9d-a0510b46b473/session_cf31a6d6-26f5-11ee-aa9d-a0510b46b473/occlusion_cf34c227-26f5-11ee-aa9d-a0510b46b473/scan_8e7c2080-26f7-11ee-aa9d-a0510b46b473/df361a55-26f7-11ee-aa9d-a0510b46b473.zip','PATIENT_c69c4cec-26f5-11ee-aa9d-a0510b46b473_ACT_cf31a6d6-26f5-11ee-aa9d-a0510b46b473_SESS_cf34c227-26f5-11ee-aa9d-a0510b46b473_TOSC_8e7c2080-26f7-11ee-aa9d-a0510b46b473_MODEL','df361a55-26f7-11ee-aa9d-a0510b46b473.zip','df361a55-26f7-11ee-aa9d-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.35.1.1.5\",\"modelMatrix\":\"0.388133,0.882175,-0.266684,0,-0.921603,0.371528,-0.112314,0,2.41163e-10,0.28937,0.957217,0,-24.954,-21.9309,-9.96696,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-20 14:20:53.870','2023-07-20 12:20:54.577',NULL),('df362f74-26f7-11ee-aa9d-a0510b46b473',11,'/home/scan/.data//2023/11/c69c4cec-26f5-11ee-aa9d-a0510b46b473/session_cf31a6d6-26f5-11ee-aa9d-a0510b46b473/occlusion_cf34c227-26f5-11ee-aa9d-a0510b46b473/scan_8e7c2080-26f7-11ee-aa9d-a0510b46b473/df362f74-26f7-11ee-aa9d-a0510b46b473.png','PATIENT_c69c4cec-26f5-11ee-aa9d-a0510b46b473_ACT_cf31a6d6-26f5-11ee-aa9d-a0510b46b473_SESS_cf34c227-26f5-11ee-aa9d-a0510b46b473_TOSC_8e7c2080-26f7-11ee-aa9d-a0510b46b473_SNAPS','df362f74-26f7-11ee-aa9d-a0510b46b473.png','df362f74-26f7-11ee-aa9d-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.35.1.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-20 14:20:53.871','2023-07-20 12:20:54.578',NULL),('df497ae6-1ca8-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_08b47e37-1ca8-11ee-997b-a0510b46b473/occlusion_08b766f9-1ca8-11ee-997b-a0510b46b473/scan_a7a01da9-1ca8-11ee-997b-a0510b46b473/df497ae6-1ca8-11ee-997b-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_08b47e37-1ca8-11ee-997b-a0510b46b473_SESS_08b766f9-1ca8-11ee-997b-a0510b46b473_TOSC_a7a01da9-1ca8-11ee-997b-a0510b46b473_MODEL','df497ae6-1ca8-11ee-997b-a0510b46b473.zip','df497ae6-1ca8-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.2.1.4\",\"modelMatrix\":\"0.913018,0.345065,-0.217552,0,-0.40792,0.772333,-0.486932,0,-7.26054e-09,0.533321,0.845913,0,-28.8223,2.40804,-12.1552,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-07 11:30:12.128','2023-07-07 09:30:12.634',NULL),('df498fed-1ca8-11ee-997b-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_08b47e37-1ca8-11ee-997b-a0510b46b473/occlusion_08b766f9-1ca8-11ee-997b-a0510b46b473/scan_a7a01da9-1ca8-11ee-997b-a0510b46b473/df498fed-1ca8-11ee-997b-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_08b47e37-1ca8-11ee-997b-a0510b46b473_SESS_08b766f9-1ca8-11ee-997b-a0510b46b473_TOSC_a7a01da9-1ca8-11ee-997b-a0510b46b473_SNAPS','df498fed-1ca8-11ee-997b-a0510b46b473.png','df498fed-1ca8-11ee-997b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.2.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-07 11:30:12.128','2023-07-07 09:30:12.637',NULL),('df5183d7-14e5-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_efcc55aa-14e3-11ee-b3b1-00d86184ce3d/occlusion_efcf357e-14e3-11ee-b3b1-00d86184ce3d/scan_8cd85b54-14e5-11ee-b3b1-00d86184ce3d/df5183d7-14e5-11ee-b3b1-00d86184ce3d.zip','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_efcc55aa-14e3-11ee-b3b1-00d86184ce3d_SESS_efcf357e-14e3-11ee-b3b1-00d86184ce3d_TOSC_8cd85b54-14e5-11ee-b3b1-00d86184ce3d_MODEL','df5183d7-14e5-11ee-b3b1-00d86184ce3d.zip','df5183d7-14e5-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.20.3.1.4\",\"modelMatrix\":\"0.956652,0.286079,-0.0545566,0,-0.291235,0.939716,-0.179208,0,-2.85165e-10,0.187328,0.982297,0,-29.4927,10.2808,-13.6797,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-27 14:26:42.179','2023-06-27 12:26:42.913',NULL),('df519b2e-14e5-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_efcc55aa-14e3-11ee-b3b1-00d86184ce3d/occlusion_efcf357e-14e3-11ee-b3b1-00d86184ce3d/scan_8cd85b54-14e5-11ee-b3b1-00d86184ce3d/df519b2e-14e5-11ee-b3b1-00d86184ce3d.png','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_efcc55aa-14e3-11ee-b3b1-00d86184ce3d_SESS_efcf357e-14e3-11ee-b3b1-00d86184ce3d_TOSC_8cd85b54-14e5-11ee-b3b1-00d86184ce3d_SNAPS','df519b2e-14e5-11ee-b3b1-00d86184ce3d.png','df519b2e-14e5-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.20.3.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-27 14:26:42.179','2023-06-27 12:26:42.914',NULL),('df877e5b-e037-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_63b81b7e-e035-11ed-bb13-00d86184ce3d/occlusion_63bb1989-e035-11ed-bb13-00d86184ce3d/scan_93f6d0de-e037-11ed-bb13-00d86184ce3d/df877e5b-e037-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_63b81b7e-e035-11ed-bb13-00d86184ce3d_SESS_63bb1989-e035-11ed-bb13-00d86184ce3d_TOSC_93f6d0de-e037-11ed-bb13-00d86184ce3d_MODEL','df877e5b-e037-11ed-bb13-00d86184ce3d.zip','df877e5b-e037-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.2.1.5\",\"modelMatrix\":\"0.346505,0.866417,-0.359522,0,-0.938048,0.320045,-0.132804,0,3.49007e-09,0.383266,0.923638,0,-29.2941,-9.98461,-6.55387,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 13:30:09.637','2023-04-21 11:30:10.535',NULL),('df879612-e037-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_63b81b7e-e035-11ed-bb13-00d86184ce3d/occlusion_63bb1989-e035-11ed-bb13-00d86184ce3d/scan_93f6d0de-e037-11ed-bb13-00d86184ce3d/df879612-e037-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_63b81b7e-e035-11ed-bb13-00d86184ce3d_SESS_63bb1989-e035-11ed-bb13-00d86184ce3d_TOSC_93f6d0de-e037-11ed-bb13-00d86184ce3d_SNAPS','df879612-e037-11ed-bb13-00d86184ce3d.png','df879612-e037-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.2.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 13:30:09.638','2023-04-21 11:30:10.535',NULL),('dfbbd7f3-1bdc-11ee-9086-a0510b46b473',11,'/home/scan/.data//2023/11/61e16a70-1a76-11ee-8124-a0510b46b473/session_d30b0955-1bdb-11ee-9086-a0510b46b473/occlusion_d30df7f0-1bdb-11ee-9086-a0510b46b473/scan_9e47776d-1bdc-11ee-9086-a0510b46b473/dfbbd7f3-1bdc-11ee-9086-a0510b46b473.zip','PATIENT_61e16a70-1a76-11ee-8124-a0510b46b473_ACT_d30b0955-1bdb-11ee-9086-a0510b46b473_SESS_d30df7f0-1bdb-11ee-9086-a0510b46b473_TOSC_9e47776d-1bdc-11ee-9086-a0510b46b473_MODEL','dfbbd7f3-1bdc-11ee-9086-a0510b46b473.zip','dfbbd7f3-1bdc-11ee-9086-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.27.4.1.4\",\"modelMatrix\":\"0.799973,0.543634,-0.253977,0,-0.600036,0.724779,-0.338605,0,8.24424e-09,0.42327,0.906003,0,-26.2925,6.46918,-9.76417,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 11:09:55.545','2023-07-06 09:09:55.993',NULL),('dfbbee84-1bdc-11ee-9086-a0510b46b473',11,'/home/scan/.data//2023/11/61e16a70-1a76-11ee-8124-a0510b46b473/session_d30b0955-1bdb-11ee-9086-a0510b46b473/occlusion_d30df7f0-1bdb-11ee-9086-a0510b46b473/scan_9e47776d-1bdc-11ee-9086-a0510b46b473/dfbbee84-1bdc-11ee-9086-a0510b46b473.png','PATIENT_61e16a70-1a76-11ee-8124-a0510b46b473_ACT_d30b0955-1bdb-11ee-9086-a0510b46b473_SESS_d30df7f0-1bdb-11ee-9086-a0510b46b473_TOSC_9e47776d-1bdc-11ee-9086-a0510b46b473_SNAPS','dfbbee84-1bdc-11ee-9086-a0510b46b473.png','dfbbee84-1bdc-11ee-9086-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.27.4.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 11:09:55.545','2023-07-06 09:09:56.001',NULL),('e01bc2ac-26e0-11ee-a836-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_78d129fc-26e0-11ee-a836-a0510b46b473/occlusion_78d4144f-26e0-11ee-a836-a0510b46b473/scan_8d595ef2-26e0-11ee-a836-a0510b46b473/e01bc2ac-26e0-11ee-a836-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_78d129fc-26e0-11ee-a836-a0510b46b473_SESS_78d4144f-26e0-11ee-a836-a0510b46b473_TOSC_8d595ef2-26e0-11ee-a836-a0510b46b473_MODEL','e01bc2ac-26e0-11ee-a836-a0510b46b473.zip','e01bc2ac-26e0-11ee-a836-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.4.1.1\",\"modelMatrix\":\"0.349316,0.921633,-0.16903,0,-0.937005,0.343585,-0.0630144,0,7.69808e-09,0.180394,0.983595,0,-25.197,-17.5076,-9.64444,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-20 11:36:16.951','2023-07-20 09:36:17.647',NULL),('e01bda7e-26e0-11ee-a836-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_78d129fc-26e0-11ee-a836-a0510b46b473/occlusion_78d4144f-26e0-11ee-a836-a0510b46b473/scan_8d595ef2-26e0-11ee-a836-a0510b46b473/e01bda7e-26e0-11ee-a836-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_78d129fc-26e0-11ee-a836-a0510b46b473_SESS_78d4144f-26e0-11ee-a836-a0510b46b473_TOSC_8d595ef2-26e0-11ee-a836-a0510b46b473_SNAPS','e01bda7e-26e0-11ee-a836-a0510b46b473.png','e01bda7e-26e0-11ee-a836-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.4.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-20 11:36:16.951','2023-07-20 09:36:17.650',NULL),('e0926040-e039-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_63b81b7e-e035-11ed-bb13-00d86184ce3d/occlusion_63bb1989-e035-11ed-bb13-00d86184ce3d/scan_cb602850-e039-11ed-bb13-00d86184ce3d/e0926040-e039-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_63b81b7e-e035-11ed-bb13-00d86184ce3d_SESS_63bb1989-e035-11ed-bb13-00d86184ce3d_TOSC_cb602850-e039-11ed-bb13-00d86184ce3d_MODEL','e0926040-e039-11ed-bb13-00d86184ce3d.zip','e0926040-e039-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.2.1.7\",\"modelMatrix\":\"-0.0302753,0.944716,-0.32649,0,-0.999542,-0.0286147,0.00988913,0,4.89493e-10,0.32664,0.945149,0,-4.27626,-13.2207,-13.1714,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 13:44:30.380','2023-04-21 11:44:30.579',NULL),('e092789b-e039-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_63b81b7e-e035-11ed-bb13-00d86184ce3d/occlusion_63bb1989-e035-11ed-bb13-00d86184ce3d/scan_cb602850-e039-11ed-bb13-00d86184ce3d/e092789b-e039-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_63b81b7e-e035-11ed-bb13-00d86184ce3d_SESS_63bb1989-e035-11ed-bb13-00d86184ce3d_TOSC_cb602850-e039-11ed-bb13-00d86184ce3d_SNAPS','e092789b-e039-11ed-bb13-00d86184ce3d.png','e092789b-e039-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.2.1.7 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 13:44:30.380','2023-04-21 11:44:30.580',NULL),('e145b8d5-e02a-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_ed85304d-e024-11ed-bb13-00d86184ce3d/occlusion_ed88a64f-e024-11ed-bb13-00d86184ce3d/scan_b3a485d3-e02a-11ed-bb13-00d86184ce3d/e145b8d5-e02a-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_ed85304d-e024-11ed-bb13-00d86184ce3d_SESS_ed88a64f-e024-11ed-bb13-00d86184ce3d_TOSC_b3a485d3-e02a-11ed-bb13-00d86184ce3d_MODEL','e145b8d5-e02a-11ed-bb13-00d86184ce3d.zip','e145b8d5-e02a-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.1.1.6\",\"modelMatrix\":\"-0.50668,0.858503,-0.079044,0,-0.862134,-0.504546,0.0464545,0,-2.74113e-09,0.0916841,0.995788,0,-2.92688,-28.6487,-8.39843,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 11:57:09.104','2023-04-21 09:57:09.510',NULL),('e145d0dd-e02a-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_ed85304d-e024-11ed-bb13-00d86184ce3d/occlusion_ed88a64f-e024-11ed-bb13-00d86184ce3d/scan_b3a485d3-e02a-11ed-bb13-00d86184ce3d/e145d0dd-e02a-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_ed85304d-e024-11ed-bb13-00d86184ce3d_SESS_ed88a64f-e024-11ed-bb13-00d86184ce3d_TOSC_b3a485d3-e02a-11ed-bb13-00d86184ce3d_SNAPS','e145d0dd-e02a-11ed-bb13-00d86184ce3d.png','e145d0dd-e02a-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.1.1.6 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 11:57:09.105','2023-04-21 09:57:09.513',NULL),('e190344a-e34b-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/971e14b0-e348-11ed-8c5e-00d86184ce3d/session_d6f9d6f4-e34a-11ed-8c5e-00d86184ce3d/occlusion_d6fcc5ab-e34a-11ed-8c5e-00d86184ce3d/scan_a35d12b0-e34b-11ed-8c5e-00d86184ce3d/e190344a-e34b-11ed-8c5e-00d86184ce3d.zip','PATIENT_971e14b0-e348-11ed-8c5e-00d86184ce3d_ACT_d6f9d6f4-e34a-11ed-8c5e-00d86184ce3d_SESS_d6fcc5ab-e34a-11ed-8c5e-00d86184ce3d_TOSC_a35d12b0-e34b-11ed-8c5e-00d86184ce3d_MODEL','e190344a-e34b-11ed-8c5e-00d86184ce3d.zip','e190344a-e34b-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.12.2.1.3\",\"modelMatrix\":\"0.554978,0.745902,-0.36828,0,-0.831865,0.497627,-0.245698,0,-6.71264e-09,0.442716,0.896662,0,-31.6029,-4.33039,-5.88083,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-25 11:30:56.473','2023-04-25 09:30:57.126',NULL),('e1904d17-e34b-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/971e14b0-e348-11ed-8c5e-00d86184ce3d/session_d6f9d6f4-e34a-11ed-8c5e-00d86184ce3d/occlusion_d6fcc5ab-e34a-11ed-8c5e-00d86184ce3d/scan_a35d12b0-e34b-11ed-8c5e-00d86184ce3d/e1904d17-e34b-11ed-8c5e-00d86184ce3d.png','PATIENT_971e14b0-e348-11ed-8c5e-00d86184ce3d_ACT_d6f9d6f4-e34a-11ed-8c5e-00d86184ce3d_SESS_d6fcc5ab-e34a-11ed-8c5e-00d86184ce3d_TOSC_a35d12b0-e34b-11ed-8c5e-00d86184ce3d_SNAPS','e1904d17-e34b-11ed-8c5e-00d86184ce3d.png','e1904d17-e34b-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.12.2.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-25 11:30:56.473','2023-04-25 09:30:57.126',NULL),('e1e86eaf-1c00-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/8a8cc548-1bf9-11ee-9323-a0510b46b473/session_ff6745bb-1bff-11ee-9323-a0510b46b473/occlusion_ff6924df-1bff-11ee-9323-a0510b46b473/scan_aef5cdce-1c00-11ee-9323-a0510b46b473/e1e86eaf-1c00-11ee-9323-a0510b46b473.zip','PATIENT_8a8cc548-1bf9-11ee-9323-a0510b46b473_ACT_ff6745bb-1bff-11ee-9323-a0510b46b473_SESS_ff6924df-1bff-11ee-9323-a0510b46b473_TOSC_aef5cdce-1c00-11ee-9323-a0510b46b473_MODEL','e1e86eaf-1c00-11ee-9323-a0510b46b473.zip','e1e86eaf-1c00-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.28.2.1.4\",\"modelMatrix\":\"0.713406,0.611544,-0.342148,0,-0.700751,0.622589,-0.348327,0,-1.41967e-09,0.488259,0.872699,0,-31.7226,4.15057,-9.20241,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 15:27:41.074','2023-07-06 13:27:41.593',NULL),('e1e88301-1c00-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/8a8cc548-1bf9-11ee-9323-a0510b46b473/session_ff6745bb-1bff-11ee-9323-a0510b46b473/occlusion_ff6924df-1bff-11ee-9323-a0510b46b473/scan_aef5cdce-1c00-11ee-9323-a0510b46b473/e1e88301-1c00-11ee-9323-a0510b46b473.png','PATIENT_8a8cc548-1bf9-11ee-9323-a0510b46b473_ACT_ff6745bb-1bff-11ee-9323-a0510b46b473_SESS_ff6924df-1bff-11ee-9323-a0510b46b473_TOSC_aef5cdce-1c00-11ee-9323-a0510b46b473_SNAPS','e1e88301-1c00-11ee-9323-a0510b46b473.png','e1e88301-1c00-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.28.2.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 15:27:41.075','2023-07-06 13:27:41.593',NULL),('e25832ce-e02e-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_ed85304d-e024-11ed-bb13-00d86184ce3d/occlusion_ed88a64f-e024-11ed-bb13-00d86184ce3d/scan_5bfb0286-e02e-11ed-bb13-00d86184ce3d/e25832ce-e02e-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_ed85304d-e024-11ed-bb13-00d86184ce3d_SESS_ed88a64f-e024-11ed-bb13-00d86184ce3d_TOSC_5bfb0286-e02e-11ed-bb13-00d86184ce3d_MODEL','e25832ce-e02e-11ed-bb13-00d86184ce3d.zip','e25832ce-e02e-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.1.1.13\",\"modelMatrix\":\"0.557632,0.747816,-0.360303,0,-0.830088,0.502363,-0.242042,0,1.30288e-08,0.434053,0.900887,0,-8.59634,-10.1327,-8.78141,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 12:25:48.890','2023-04-21 10:25:49.154',NULL),('e25849c0-e02e-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_ed85304d-e024-11ed-bb13-00d86184ce3d/occlusion_ed88a64f-e024-11ed-bb13-00d86184ce3d/scan_5bfb0286-e02e-11ed-bb13-00d86184ce3d/e25849c0-e02e-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_ed85304d-e024-11ed-bb13-00d86184ce3d_SESS_ed88a64f-e024-11ed-bb13-00d86184ce3d_TOSC_5bfb0286-e02e-11ed-bb13-00d86184ce3d_SNAPS','e25849c0-e02e-11ed-bb13-00d86184ce3d.png','e25849c0-e02e-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.1.1.13 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 12:25:48.890','2023-04-21 10:25:49.154',NULL),('e3a84d5c-10e4-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/2ff330cd-10e1-11ee-b636-a0510b46b473/session_68b68f8e-10e4-11ee-b636-a0510b46b473/occlusion_68b97a59-10e4-11ee-b636-a0510b46b473/scan_9f56a8f7-10e4-11ee-b636-a0510b46b473/e3a84d5c-10e4-11ee-b636-a0510b46b473.zip','PATIENT_2ff330cd-10e1-11ee-b636-a0510b46b473_ACT_68b68f8e-10e4-11ee-b636-a0510b46b473_SESS_68b97a59-10e4-11ee-b636-a0510b46b473_TOSC_9f56a8f7-10e4-11ee-b636-a0510b46b473_MODEL','e3a84d5c-10e4-11ee-b636-a0510b46b473.zip','e3a84d5c-10e4-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.18.2.1.2\",\"modelMatrix\":\"0.857008,0.47562,-0.198299,0,-0.515303,0.791011,-0.329794,0,-5.87483e-09,0.38482,0.922992,0,-23.1387,8.61971,-9.84863,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 12:09:35.311','2023-06-22 10:09:35.886',NULL),('e3a993dc-10e4-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/2ff330cd-10e1-11ee-b636-a0510b46b473/session_68b68f8e-10e4-11ee-b636-a0510b46b473/occlusion_68b97a59-10e4-11ee-b636-a0510b46b473/scan_9f56a8f7-10e4-11ee-b636-a0510b46b473/e3a993dc-10e4-11ee-b636-a0510b46b473.png','PATIENT_2ff330cd-10e1-11ee-b636-a0510b46b473_ACT_68b68f8e-10e4-11ee-b636-a0510b46b473_SESS_68b97a59-10e4-11ee-b636-a0510b46b473_TOSC_9f56a8f7-10e4-11ee-b636-a0510b46b473_SNAPS','e3a993dc-10e4-11ee-b636-a0510b46b473.png','e3a993dc-10e4-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.18.2.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 12:09:35.319','2023-06-22 10:09:35.887',NULL),('e3adb020-1bf9-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/8a8cc548-1bf9-11ee-9323-a0510b46b473/session_976f015a-1bf9-11ee-9323-a0510b46b473/occlusion_97713d19-1bf9-11ee-9323-a0510b46b473/scan_ad3369fe-1bf9-11ee-9323-a0510b46b473/e3adb020-1bf9-11ee-9323-a0510b46b473.zip','PATIENT_8a8cc548-1bf9-11ee-9323-a0510b46b473_ACT_976f015a-1bf9-11ee-9323-a0510b46b473_SESS_97713d19-1bf9-11ee-9323-a0510b46b473_TOSC_ad3369fe-1bf9-11ee-9323-a0510b46b473_MODEL','e3adb020-1bf9-11ee-9323-a0510b46b473.zip','e3adb020-1bf9-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.28.1.1.1\",\"modelMatrix\":\"0.757255,-0.64678,0.0907838,0,0.65312,0.749903,-0.105258,0,-3.65027e-09,0.139,0.990292,0,-11.4457,16.594,-15.9814,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 14:37:37.568','2023-07-06 12:37:38.016',NULL),('e3add51b-1bf9-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/8a8cc548-1bf9-11ee-9323-a0510b46b473/session_976f015a-1bf9-11ee-9323-a0510b46b473/occlusion_97713d19-1bf9-11ee-9323-a0510b46b473/scan_ad3369fe-1bf9-11ee-9323-a0510b46b473/e3add51b-1bf9-11ee-9323-a0510b46b473.png','PATIENT_8a8cc548-1bf9-11ee-9323-a0510b46b473_ACT_976f015a-1bf9-11ee-9323-a0510b46b473_SESS_97713d19-1bf9-11ee-9323-a0510b46b473_TOSC_ad3369fe-1bf9-11ee-9323-a0510b46b473_SNAPS','e3add51b-1bf9-11ee-9323-a0510b46b473.png','e3add51b-1bf9-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.28.1.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 14:37:37.569','2023-07-06 12:37:38.018',NULL),('e4a79b11-14e6-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_efcc55aa-14e3-11ee-b3b1-00d86184ce3d/occlusion_efcf357e-14e3-11ee-b3b1-00d86184ce3d/scan_67cc1e2d-14e6-11ee-b3b1-00d86184ce3d/e4a79b11-14e6-11ee-b3b1-00d86184ce3d.zip','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_efcc55aa-14e3-11ee-b3b1-00d86184ce3d_SESS_efcf357e-14e3-11ee-b3b1-00d86184ce3d_TOSC_67cc1e2d-14e6-11ee-b3b1-00d86184ce3d_MODEL','e4a79b11-14e6-11ee-b3b1-00d86184ce3d.zip','e4a79b11-14e6-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.20.3.1.6\",\"modelMatrix\":\"-0.342605,0.92921,-0.138531,0,-0.93948,-0.33886,0.0505188,0,-2.86635e-09,0.147455,0.989069,0,-3.26226,-31.2709,-10.7247,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-27 14:34:00.628','2023-06-27 12:34:01.533',NULL),('e4a7af45-14e6-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_efcc55aa-14e3-11ee-b3b1-00d86184ce3d/occlusion_efcf357e-14e3-11ee-b3b1-00d86184ce3d/scan_67cc1e2d-14e6-11ee-b3b1-00d86184ce3d/e4a7af45-14e6-11ee-b3b1-00d86184ce3d.png','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_efcc55aa-14e3-11ee-b3b1-00d86184ce3d_SESS_efcf357e-14e3-11ee-b3b1-00d86184ce3d_TOSC_67cc1e2d-14e6-11ee-b3b1-00d86184ce3d_SNAPS','e4a7af45-14e6-11ee-b3b1-00d86184ce3d.png','e4a7af45-14e6-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.20.3.1.6 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-27 14:34:00.629','2023-06-27 12:34:01.533',NULL),('e53e3a62-1bfb-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/8a8cc548-1bf9-11ee-9323-a0510b46b473/session_976f015a-1bf9-11ee-9323-a0510b46b473/occlusion_97713d19-1bf9-11ee-9323-a0510b46b473/scan_760ddbfd-1bfb-11ee-9323-a0510b46b473/e53e3a62-1bfb-11ee-9323-a0510b46b473.zip','PATIENT_8a8cc548-1bf9-11ee-9323-a0510b46b473_ACT_976f015a-1bf9-11ee-9323-a0510b46b473_SESS_97713d19-1bf9-11ee-9323-a0510b46b473_TOSC_760ddbfd-1bfb-11ee-9323-a0510b46b473_MODEL','e53e3a62-1bfb-11ee-9323-a0510b46b473.zip','e53e3a62-1bfb-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.28.1.1.5\",\"modelMatrix\":\"-0.241379,0.955028,-0.172212,0,-0.970431,-0.237548,0.042835,0,2.09907e-09,0.177459,0.984128,0,-15.6175,-26.7342,-10.3325,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 14:51:59.186','2023-07-06 12:52:00.017',NULL),('e53eb782-1bfb-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/8a8cc548-1bf9-11ee-9323-a0510b46b473/session_976f015a-1bf9-11ee-9323-a0510b46b473/occlusion_97713d19-1bf9-11ee-9323-a0510b46b473/scan_760ddbfd-1bfb-11ee-9323-a0510b46b473/e53eb782-1bfb-11ee-9323-a0510b46b473.png','PATIENT_8a8cc548-1bf9-11ee-9323-a0510b46b473_ACT_976f015a-1bf9-11ee-9323-a0510b46b473_SESS_97713d19-1bf9-11ee-9323-a0510b46b473_TOSC_760ddbfd-1bfb-11ee-9323-a0510b46b473_SNAPS','e53eb782-1bfb-11ee-9323-a0510b46b473.png','e53eb782-1bfb-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.28.1.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 14:51:59.189','2023-07-06 12:52:00.017',NULL),('e541de9e-26fd-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/848c86d9-26fd-11ee-a98e-a0510b46b473/session_8f62cd50-26fd-11ee-a98e-a0510b46b473/occlusion_8f65e2e0-26fd-11ee-a98e-a0510b46b473/scan_99e40be5-26fd-11ee-a98e-a0510b46b473/e541de9e-26fd-11ee-a98e-a0510b46b473.zip','PATIENT_848c86d9-26fd-11ee-a98e-a0510b46b473_ACT_8f62cd50-26fd-11ee-a98e-a0510b46b473_SESS_8f65e2e0-26fd-11ee-a98e-a0510b46b473_TOSC_99e40be5-26fd-11ee-a98e-a0510b46b473_MODEL','e541de9e-26fd-11ee-a98e-a0510b46b473.zip','e541de9e-26fd-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.36.1.1.1\",\"modelMatrix\":\"0.671738,-0.740768,0.00544714,0,0.740788,0.67172,-0.0049394,0,-1.49248e-10,0.00735316,0.999973,0,6.06375,22.166,-12.9611,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-20 15:04:00.994','2023-07-20 13:04:01.685',NULL),('e541f7aa-26fd-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/848c86d9-26fd-11ee-a98e-a0510b46b473/session_8f62cd50-26fd-11ee-a98e-a0510b46b473/occlusion_8f65e2e0-26fd-11ee-a98e-a0510b46b473/scan_99e40be5-26fd-11ee-a98e-a0510b46b473/e541f7aa-26fd-11ee-a98e-a0510b46b473.png','PATIENT_848c86d9-26fd-11ee-a98e-a0510b46b473_ACT_8f62cd50-26fd-11ee-a98e-a0510b46b473_SESS_8f65e2e0-26fd-11ee-a98e-a0510b46b473_TOSC_99e40be5-26fd-11ee-a98e-a0510b46b473_SNAPS','e541f7aa-26fd-11ee-a98e-a0510b46b473.png','e541f7aa-26fd-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.36.1.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-20 15:04:00.995','2023-07-20 13:04:01.688',NULL),('e5dec9d0-e040-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_261265bf-e03f-11ed-bb13-00d86184ce3d/occlusion_2615e3c8-e03f-11ed-bb13-00d86184ce3d/scan_a496dd67-e040-11ed-bb13-00d86184ce3d/e5dec9d0-e040-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_261265bf-e03f-11ed-bb13-00d86184ce3d_SESS_2615e3c8-e03f-11ed-bb13-00d86184ce3d_TOSC_a496dd67-e040-11ed-bb13-00d86184ce3d_MODEL','e5dec9d0-e040-11ed-bb13-00d86184ce3d.zip','e5dec9d0-e040-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.4.1.5\",\"modelMatrix\":\"0.59711,0.709606,-0.374056,0,-0.802159,0.528216,-0.278439,0,-2.70956e-08,0.466312,0.884621,0,-27.9234,-13.2406,-3.77002,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 14:34:45.746','2023-04-21 12:34:46.310',NULL),('e5dee223-e040-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_261265bf-e03f-11ed-bb13-00d86184ce3d/occlusion_2615e3c8-e03f-11ed-bb13-00d86184ce3d/scan_a496dd67-e040-11ed-bb13-00d86184ce3d/e5dee223-e040-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_261265bf-e03f-11ed-bb13-00d86184ce3d_SESS_2615e3c8-e03f-11ed-bb13-00d86184ce3d_TOSC_a496dd67-e040-11ed-bb13-00d86184ce3d_SNAPS','e5dee223-e040-11ed-bb13-00d86184ce3d.png','e5dee223-e040-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.4.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 14:34:45.747','2023-04-21 12:34:46.310',NULL),('e5e7824e-1a71-11ee-a125-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_77df3b68-1a6c-11ee-af16-a0510b46b473/occlusion_77e234a6-1a6c-11ee-af16-a0510b46b473/scan_93869b07-1a71-11ee-a125-a0510b46b473/e5e7824e-1a71-11ee-a125-a0510b46b473.zip','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_77df3b68-1a6c-11ee-af16-a0510b46b473_SESS_77e234a6-1a6c-11ee-af16-a0510b46b473_TOSC_93869b07-1a71-11ee-a125-a0510b46b473_MODEL','e5e7824e-1a71-11ee-a125-a0510b46b473.zip','e5e7824e-1a71-11ee-a125-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.4.1.4\",\"modelMatrix\":\"0.0137353,0.984596,-0.174304,0,-0.999906,0.013525,-0.00239434,0,-1.16256e-11,0.17432,0.984689,0,-18.9479,-23.2016,-9.25947,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-04 15:51:38.584','2023-07-04 13:51:39.336',NULL),('e5e8cd4e-1a71-11ee-a125-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_77df3b68-1a6c-11ee-af16-a0510b46b473/occlusion_77e234a6-1a6c-11ee-af16-a0510b46b473/scan_93869b07-1a71-11ee-a125-a0510b46b473/e5e8cd4e-1a71-11ee-a125-a0510b46b473.png','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_77df3b68-1a6c-11ee-af16-a0510b46b473_SESS_77e234a6-1a6c-11ee-af16-a0510b46b473_TOSC_93869b07-1a71-11ee-a125-a0510b46b473_SNAPS','e5e8cd4e-1a71-11ee-a125-a0510b46b473.png','e5e8cd4e-1a71-11ee-a125-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.4.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-04 15:51:38.593','2023-07-04 13:51:39.337',NULL),('e613ebdc-14c8-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/9619fcac-14c3-11ee-b3b1-00d86184ce3d/session_961b9a11-14c3-11ee-b3b1-00d86184ce3d/occlusion_961d56b4-14c3-11ee-b3b1-00d86184ce3d/scan_7ea52c01-14c8-11ee-b3b1-00d86184ce3d/e613ebdc-14c8-11ee-b3b1-00d86184ce3d.zip','PATIENT_9619fcac-14c3-11ee-b3b1-00d86184ce3d_ACT_961b9a11-14c3-11ee-b3b1-00d86184ce3d_SESS_961d56b4-14c3-11ee-b3b1-00d86184ce3d_TOSC_7ea52c01-14c8-11ee-b3b1-00d86184ce3d_MODEL','e613ebdc-14c8-11ee-b3b1-00d86184ce3d.zip','e613ebdc-14c8-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.22.1.1.5\",\"modelMatrix\":\"0.629818,0.754548,-0.184355,0,-0.776743,0.611821,-0.149484,0,4.87575e-09,0.237344,0.971426,0,-33.721,-4.25301,-10.3235,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-27 10:59:18.114','2023-06-27 08:59:18.864',NULL),('e61400c7-14c8-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/9619fcac-14c3-11ee-b3b1-00d86184ce3d/session_961b9a11-14c3-11ee-b3b1-00d86184ce3d/occlusion_961d56b4-14c3-11ee-b3b1-00d86184ce3d/scan_7ea52c01-14c8-11ee-b3b1-00d86184ce3d/e61400c7-14c8-11ee-b3b1-00d86184ce3d.png','PATIENT_9619fcac-14c3-11ee-b3b1-00d86184ce3d_ACT_961b9a11-14c3-11ee-b3b1-00d86184ce3d_SESS_961d56b4-14c3-11ee-b3b1-00d86184ce3d_TOSC_7ea52c01-14c8-11ee-b3b1-00d86184ce3d_SNAPS','e61400c7-14c8-11ee-b3b1-00d86184ce3d.png','e61400c7-14c8-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.22.1.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-27 10:59:18.114','2023-06-27 08:59:18.864',NULL),('e61a4652-2a3e-11ee-9e90-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_b144ba33-2a36-11ee-9e90-a0510b46b473/occlusion_b147bba1-2a36-11ee-9e90-a0510b46b473/scan_ab709502-2a3e-11ee-9e90-a0510b46b473/e61a4652-2a3e-11ee-9e90-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_b144ba33-2a36-11ee-9e90-a0510b46b473_SESS_b147bba1-2a36-11ee-9e90-a0510b46b473_TOSC_ab709502-2a3e-11ee-9e90-a0510b46b473_MODEL','e61a4652-2a3e-11ee-9e90-a0510b46b473.zip','e61a4652-2a3e-11ee-9e90-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.6.1.8\",\"modelMatrix\":\"0.39849,0.869139,-0.292922,0,-0.917173,0.37762,-0.127268,0,7.13857e-09,0.319375,0.947628,0,-26.634,-16.2168,-6.48914,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,'2023-07-24 18:27:16.051','2023-07-24 18:26:53.188','2023-07-24 16:27:16.055',NULL),('e61a5443-2a3e-11ee-9e90-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_b144ba33-2a36-11ee-9e90-a0510b46b473/occlusion_b147bba1-2a36-11ee-9e90-a0510b46b473/scan_ab709502-2a3e-11ee-9e90-a0510b46b473/e61a5443-2a3e-11ee-9e90-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_b144ba33-2a36-11ee-9e90-a0510b46b473_SESS_b147bba1-2a36-11ee-9e90-a0510b46b473_TOSC_ab709502-2a3e-11ee-9e90-a0510b46b473_SNAPS','e61a5443-2a3e-11ee-9e90-a0510b46b473.png','e61a5443-2a3e-11ee-9e90-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.6.1.8 Snapshot\"}','PNG',0,'CREATED',0,'2023-07-24 18:27:16.051','2023-07-24 18:26:53.188','2023-07-24 16:27:16.067',NULL),('e717a247-e355-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_853ebc79-e33f-11ed-8c5e-00d86184ce3d/occlusion_8541c500-e33f-11ed-8c5e-00d86184ce3d/scan_a4f86ab9-e355-11ed-8c5e-00d86184ce3d/e717a247-e355-11ed-8c5e-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_853ebc79-e33f-11ed-8c5e-00d86184ce3d_SESS_8541c500-e33f-11ed-8c5e-00d86184ce3d_TOSC_a4f86ab9-e355-11ed-8c5e-00d86184ce3d_MODEL','e717a247-e355-11ed-8c5e-00d86184ce3d.zip','e717a247-e355-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.6.1.10\",\"modelMatrix\":\"0.755296,0.601578,-0.260063,0,-0.655384,0.693286,-0.299709,0,1.18889e-08,0.39681,0.917901,0,-29.8192,-1.40333,-8.69293,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-25 12:42:40.716','2023-04-25 10:42:41.460',NULL),('e717b914-e355-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_853ebc79-e33f-11ed-8c5e-00d86184ce3d/occlusion_8541c500-e33f-11ed-8c5e-00d86184ce3d/scan_a4f86ab9-e355-11ed-8c5e-00d86184ce3d/e717b914-e355-11ed-8c5e-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_853ebc79-e33f-11ed-8c5e-00d86184ce3d_SESS_8541c500-e33f-11ed-8c5e-00d86184ce3d_TOSC_a4f86ab9-e355-11ed-8c5e-00d86184ce3d_SNAPS','e717b914-e355-11ed-8c5e-00d86184ce3d.png','e717b914-e355-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.6.1.10 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-25 12:42:40.717','2023-04-25 10:42:41.460',NULL),('e8209173-262e-11ee-81dd-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_ab852a49-262e-11ee-81dd-a0510b46b473/occlusion_ab88338c-262e-11ee-81dd-a0510b46b473/scan_acb95c59-262e-11ee-81dd-a0510b46b473/e8209173-262e-11ee-81dd-a0510b46b473.zip','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_ab852a49-262e-11ee-81dd-a0510b46b473_SESS_ab88338c-262e-11ee-81dd-a0510b46b473_TOSC_acb95c59-262e-11ee-81dd-a0510b46b473_MODEL','e8209173-262e-11ee-81dd-a0510b46b473.zip','e8209173-262e-11ee-81dd-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.2.1.1\",\"modelMatrix\":\"0.783902,0.610017,-0.11566,0,-0.620885,0.770181,-0.146028,0,3.37312e-09,0.186283,0.982496,0,-29.3337,0.585108,-9.0751,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-19 14:22:19.986','2023-07-19 12:22:20.469',NULL),('e821dcfe-262e-11ee-81dd-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_ab852a49-262e-11ee-81dd-a0510b46b473/occlusion_ab88338c-262e-11ee-81dd-a0510b46b473/scan_acb95c59-262e-11ee-81dd-a0510b46b473/e821dcfe-262e-11ee-81dd-a0510b46b473.png','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_ab852a49-262e-11ee-81dd-a0510b46b473_SESS_ab88338c-262e-11ee-81dd-a0510b46b473_TOSC_acb95c59-262e-11ee-81dd-a0510b46b473_SNAPS','e821dcfe-262e-11ee-81dd-a0510b46b473.png','e821dcfe-262e-11ee-81dd-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.2.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-19 14:22:19.994','2023-07-19 12:22:20.470',NULL),('e8771853-dd01-11ed-8097-00d86184ce3d',11,'/home/scan/.data//2023/11/59af3050-dcfe-11ed-8097-00d86184ce3d/session_61025fcf-dcfe-11ed-8097-00d86184ce3d/occlusion_610548c3-dcfe-11ed-8097-00d86184ce3d/scan_57977916-dd01-11ed-8097-00d86184ce3d/e8771853-dd01-11ed-8097-00d86184ce3d.zip','PATIENT_59af3050-dcfe-11ed-8097-00d86184ce3d_ACT_61025fcf-dcfe-11ed-8097-00d86184ce3d_SESS_610548c3-dcfe-11ed-8097-00d86184ce3d_BOSC_57977916-dd01-11ed-8097-00d86184ce3d_MODEL','e8771853-dd01-11ed-8097-00d86184ce3d.zip','e8771853-dd01-11ed-8097-00d86184ce3d','{\"displayTitle\":\"Mandibule 1.1.1.1.1\",\"modelMatrix\":\"0.760631,0.639483,-0.111814,0,-0.649184,0.749264,-0.131009,0,6.90835e-09,0.172237,0.985056,0,-29.3983,-7.54753,-12.0079,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-04-17 11:26:18.317','2023-04-17 09:26:19.108','2023-04-17 11:26:19.431'),('e87730e2-dd01-11ed-8097-00d86184ce3d',11,'/home/scan/.data//2023/11/59af3050-dcfe-11ed-8097-00d86184ce3d/session_61025fcf-dcfe-11ed-8097-00d86184ce3d/occlusion_610548c3-dcfe-11ed-8097-00d86184ce3d/scan_57977916-dd01-11ed-8097-00d86184ce3d/e87730e2-dd01-11ed-8097-00d86184ce3d.png','PATIENT_59af3050-dcfe-11ed-8097-00d86184ce3d_ACT_61025fcf-dcfe-11ed-8097-00d86184ce3d_SESS_610548c3-dcfe-11ed-8097-00d86184ce3d_BOSC_57977916-dd01-11ed-8097-00d86184ce3d_SNAPS','e87730e2-dd01-11ed-8097-00d86184ce3d.png','e87730e2-dd01-11ed-8097-00d86184ce3d','{\"displayTitle\":\"Mandibule 1.1.1.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-04-17 11:26:18.318','2023-04-17 09:26:19.109','2023-04-17 11:26:19.551'),('e88dedb7-262c-11ee-8042-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_62519c59-261f-11ee-8042-a0510b46b473/occlusion_6253caa6-261f-11ee-8042-a0510b46b473/scan_83818757-262c-11ee-8042-a0510b46b473/e88dedb7-262c-11ee-8042-a0510b46b473.zip','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_62519c59-261f-11ee-8042-a0510b46b473_SESS_6253caa6-261f-11ee-8042-a0510b46b473_TOSC_83818757-262c-11ee-8042-a0510b46b473_MODEL','e88dedb7-262c-11ee-8042-a0510b46b473.zip','e88dedb7-262c-11ee-8042-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.1.1.10\",\"modelMatrix\":\"0.27595,0.95478,-0.110669,0,-0.961172,0.274115,-0.0317727,0,-9.96737e-10,0.115139,0.993349,0,-18.567,-20.3902,-13.7619,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-19 14:08:01.709','2023-07-19 12:08:02.481',NULL),('e88e05b9-262c-11ee-8042-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_62519c59-261f-11ee-8042-a0510b46b473/occlusion_6253caa6-261f-11ee-8042-a0510b46b473/scan_83818757-262c-11ee-8042-a0510b46b473/e88e05b9-262c-11ee-8042-a0510b46b473.png','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_62519c59-261f-11ee-8042-a0510b46b473_SESS_6253caa6-261f-11ee-8042-a0510b46b473_TOSC_83818757-262c-11ee-8042-a0510b46b473_SNAPS','e88e05b9-262c-11ee-8042-a0510b46b473.png','e88e05b9-262c-11ee-8042-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.1.1.10 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-19 14:08:01.710','2023-07-19 12:08:02.482',NULL),('e9020f73-26e6-11ee-aa9d-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_d5ef2d6b-26e3-11ee-a836-a0510b46b473/occlusion_d5f241c9-26e3-11ee-a836-a0510b46b473/scan_91e9aaad-26e6-11ee-aa9d-a0510b46b473/e9020f73-26e6-11ee-aa9d-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_d5ef2d6b-26e3-11ee-a836-a0510b46b473_SESS_d5f241c9-26e3-11ee-a836-a0510b46b473_BOSC_91e9aaad-26e6-11ee-aa9d-a0510b46b473_MODEL','e9020f73-26e6-11ee-aa9d-a0510b46b473.zip','e9020f73-26e6-11ee-aa9d-a0510b46b473','{\"displayTitle\":\"Mandibule 1.30.5.1.2\",\"modelMatrix\":\"-0.17157,0.976004,-0.134092,0,-0.985172,-0.169974,0.0233525,0,1.2302e-09,0.13611,0.990694,0,-9.44902,-32.5315,-9.38775,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-20 12:19:28.862','2023-07-20 10:19:29.653',NULL),('e9022713-26e6-11ee-aa9d-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_d5ef2d6b-26e3-11ee-a836-a0510b46b473/occlusion_d5f241c9-26e3-11ee-a836-a0510b46b473/scan_91e9aaad-26e6-11ee-aa9d-a0510b46b473/e9022713-26e6-11ee-aa9d-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_d5ef2d6b-26e3-11ee-a836-a0510b46b473_SESS_d5f241c9-26e3-11ee-a836-a0510b46b473_BOSC_91e9aaad-26e6-11ee-aa9d-a0510b46b473_SNAPS','e9022713-26e6-11ee-aa9d-a0510b46b473.png','e9022713-26e6-11ee-aa9d-a0510b46b473','{\"displayTitle\":\"Mandibule 1.30.5.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-20 12:19:28.863','2023-07-20 10:19:29.663',NULL),('e92cc860-2708-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_c28d11f3-2706-11ee-a98e-a0510b46b473/occlusion_c2900beb-2706-11ee-a98e-a0510b46b473/scan_8bbfda67-2708-11ee-a98e-a0510b46b473/e92cc860-2708-11ee-a98e-a0510b46b473.zip','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_c28d11f3-2706-11ee-a98e-a0510b46b473_SESS_c2900beb-2706-11ee-a98e-a0510b46b473_TOSC_8bbfda67-2708-11ee-a98e-a0510b46b473_MODEL','e92cc860-2708-11ee-a98e-a0510b46b473.zip','e92cc860-2708-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.3.1.2\",\"modelMatrix\":\"-0.0794706,0.949707,-0.302888,0,-0.996837,-0.0757132,0.024147,0,-4.58e-10,0.303849,0.95272,0,-11.9843,-32.725,-7.62443,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-20 16:22:52.031','2023-07-20 14:22:52.794',NULL),('e92ce005-2708-11ee-a98e-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_c28d11f3-2706-11ee-a98e-a0510b46b473/occlusion_c2900beb-2706-11ee-a98e-a0510b46b473/scan_8bbfda67-2708-11ee-a98e-a0510b46b473/e92ce005-2708-11ee-a98e-a0510b46b473.png','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_c28d11f3-2706-11ee-a98e-a0510b46b473_SESS_c2900beb-2706-11ee-a98e-a0510b46b473_TOSC_8bbfda67-2708-11ee-a98e-a0510b46b473_SNAPS','e92ce005-2708-11ee-a98e-a0510b46b473.png','e92ce005-2708-11ee-a98e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.3.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-20 16:22:52.031','2023-07-20 14:22:52.798',NULL),('e92ff8d8-deaf-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/eb12a131-deae-11ed-9cc3-00d86184ce3d/session_fdea0616-deae-11ed-9cc3-00d86184ce3d/occlusion_fded0f45-deae-11ed-9cc3-00d86184ce3d/scan_820c3dcb-deaf-11ed-9cc3-00d86184ce3d/e92ff8d8-deaf-11ed-9cc3-00d86184ce3d.zip','PATIENT_eb12a131-deae-11ed-9cc3-00d86184ce3d_ACT_fdea0616-deae-11ed-9cc3-00d86184ce3d_SESS_fded0f45-deae-11ed-9cc3-00d86184ce3d_TOSC_820c3dcb-deaf-11ed-9cc3-00d86184ce3d_MODEL','e92ff8d8-deaf-11ed-9cc3-00d86184ce3d.zip','e92ff8d8-deaf-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.5.1.1.2\",\"modelMatrix\":\"-0.171636,0.979067,-0.109399,0,-0.98516,-0.170574,0.0190596,0,6.78763e-10,0.111047,0.993815,0,-13.248,-20.296,-10.9365,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-19 14:44:23.123','2023-04-19 12:44:23.573',NULL),('e93008e1-deaf-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/eb12a131-deae-11ed-9cc3-00d86184ce3d/session_fdea0616-deae-11ed-9cc3-00d86184ce3d/occlusion_fded0f45-deae-11ed-9cc3-00d86184ce3d/scan_820c3dcb-deaf-11ed-9cc3-00d86184ce3d/e93008e1-deaf-11ed-9cc3-00d86184ce3d.png','PATIENT_eb12a131-deae-11ed-9cc3-00d86184ce3d_ACT_fdea0616-deae-11ed-9cc3-00d86184ce3d_SESS_fded0f45-deae-11ed-9cc3-00d86184ce3d_TOSC_820c3dcb-deaf-11ed-9cc3-00d86184ce3d_SNAPS','e93008e1-deaf-11ed-9cc3-00d86184ce3d.png','e93008e1-deaf-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.5.1.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-19 14:44:23.123','2023-04-19 12:44:23.573',NULL),('e9304255-262a-11ee-8042-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_62519c59-261f-11ee-8042-a0510b46b473/occlusion_6253caa6-261f-11ee-8042-a0510b46b473/scan_8a251426-262a-11ee-8042-a0510b46b473/e9304255-262a-11ee-8042-a0510b46b473.zip','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_62519c59-261f-11ee-8042-a0510b46b473_SESS_6253caa6-261f-11ee-8042-a0510b46b473_TOSC_8a251426-262a-11ee-8042-a0510b46b473_MODEL','e9304255-262a-11ee-8042-a0510b46b473.zip','e9304255-262a-11ee-8042-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.1.1.6\",\"modelMatrix\":\"-0.0453812,0.970274,-0.237714,0,-0.99897,-0.0440776,0.0107989,0,-7.47431e-10,0.23796,0.971275,0,-14.2692,-27.5403,-8.30963,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-19 13:53:43.780','2023-07-19 11:53:44.450',NULL),('e9318e6a-262a-11ee-8042-a0510b46b473',11,'/home/scan/.data//2023/11/53d7979d-261f-11ee-8042-a0510b46b473/session_62519c59-261f-11ee-8042-a0510b46b473/occlusion_6253caa6-261f-11ee-8042-a0510b46b473/scan_8a251426-262a-11ee-8042-a0510b46b473/e9318e6a-262a-11ee-8042-a0510b46b473.png','PATIENT_53d7979d-261f-11ee-8042-a0510b46b473_ACT_62519c59-261f-11ee-8042-a0510b46b473_SESS_6253caa6-261f-11ee-8042-a0510b46b473_TOSC_8a251426-262a-11ee-8042-a0510b46b473_SNAPS','e9318e6a-262a-11ee-8042-a0510b46b473.png','e9318e6a-262a-11ee-8042-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.34.1.1.6 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-19 13:53:43.788','2023-07-19 11:53:44.459',NULL),('e935fb3e-e03c-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_6f09f9a8-e03a-11ed-bb13-00d86184ce3d/occlusion_6f0c3cda-e03a-11ed-bb13-00d86184ce3d/scan_c83422f9-e03c-11ed-bb13-00d86184ce3d/e935fb3e-e03c-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_6f09f9a8-e03a-11ed-bb13-00d86184ce3d_SESS_6f0c3cda-e03a-11ed-bb13-00d86184ce3d_TOSC_c83422f9-e03c-11ed-bb13-00d86184ce3d_MODEL','e935fb3e-e03c-11ed-bb13-00d86184ce3d.zip','e935fb3e-e03c-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.3.1.11\",\"modelMatrix\":\"0.986649,0.134411,-0.091966,0,-0.162862,0.814287,-0.557147,0,5.19763e-09,0.564686,0.825306,0,-8.84846,-2.71373,-5.44871,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,'2023-04-21 14:06:39.118','2023-04-21 14:06:13.364','2023-04-21 12:06:39.122',NULL),('e936123c-e03c-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_6f09f9a8-e03a-11ed-bb13-00d86184ce3d/occlusion_6f0c3cda-e03a-11ed-bb13-00d86184ce3d/scan_c83422f9-e03c-11ed-bb13-00d86184ce3d/e936123c-e03c-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_6f09f9a8-e03a-11ed-bb13-00d86184ce3d_SESS_6f0c3cda-e03a-11ed-bb13-00d86184ce3d_TOSC_c83422f9-e03c-11ed-bb13-00d86184ce3d_SNAPS','e936123c-e03c-11ed-bb13-00d86184ce3d.png','e936123c-e03c-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.3.1.11 Snapshot\"}','PNG',0,'CREATED',0,'2023-04-21 14:06:39.118','2023-04-21 14:06:13.364','2023-04-21 12:06:39.126',NULL),('ea6602d9-14f7-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/8283c62f-14f6-11ee-b3b1-00d86184ce3d/session_8d62c238-14f6-11ee-b3b1-00d86184ce3d/occlusion_8d65509a-14f6-11ee-b3b1-00d86184ce3d/scan_9c8ac102-14f7-11ee-b3b1-00d86184ce3d/ea6602d9-14f7-11ee-b3b1-00d86184ce3d.zip','PATIENT_8283c62f-14f6-11ee-b3b1-00d86184ce3d_ACT_8d62c238-14f6-11ee-b3b1-00d86184ce3d_SESS_8d65509a-14f6-11ee-b3b1-00d86184ce3d_TOSC_9c8ac102-14f7-11ee-b3b1-00d86184ce3d_MODEL','ea6602d9-14f7-11ee-b3b1-00d86184ce3d.zip','ea6602d9-14f7-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.23.1.1.1\",\"modelMatrix\":\"0.388734,0.914479,-0.112314,0,-0.92135,0.385835,-0.0473872,0,1.89249e-09,0.121901,0.992542,0,-23.5069,-11.4257,-11.9928,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-27 16:35:51.709','2023-06-27 14:35:52.430',NULL),('ea661bfc-14f7-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/8283c62f-14f6-11ee-b3b1-00d86184ce3d/session_8d62c238-14f6-11ee-b3b1-00d86184ce3d/occlusion_8d65509a-14f6-11ee-b3b1-00d86184ce3d/scan_9c8ac102-14f7-11ee-b3b1-00d86184ce3d/ea661bfc-14f7-11ee-b3b1-00d86184ce3d.png','PATIENT_8283c62f-14f6-11ee-b3b1-00d86184ce3d_ACT_8d62c238-14f6-11ee-b3b1-00d86184ce3d_SESS_8d65509a-14f6-11ee-b3b1-00d86184ce3d_TOSC_9c8ac102-14f7-11ee-b3b1-00d86184ce3d_SNAPS','ea661bfc-14f7-11ee-b3b1-00d86184ce3d.png','ea661bfc-14f7-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.23.1.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-27 16:35:51.710','2023-06-27 14:35:52.431',NULL),('eaad868e-e03f-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_261265bf-e03f-11ed-bb13-00d86184ce3d/occlusion_2615e3c8-e03f-11ed-bb13-00d86184ce3d/scan_b455b658-e03f-11ed-bb13-00d86184ce3d/eaad868e-e03f-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_261265bf-e03f-11ed-bb13-00d86184ce3d_SESS_2615e3c8-e03f-11ed-bb13-00d86184ce3d_TOSC_b455b658-e03f-11ed-bb13-00d86184ce3d_MODEL','eaad868e-e03f-11ed-bb13-00d86184ce3d.zip','eaad868e-e03f-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.4.1.2\",\"modelMatrix\":\"0.629175,0.707877,-0.321013,0,-0.777264,0.573008,-0.259851,0,-1.71915e-09,0.413003,0.91073,0,-29.2162,-2.02842,-8.06427,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 14:27:44.315','2023-04-21 12:27:44.897',NULL),('eaad9e52-e03f-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_261265bf-e03f-11ed-bb13-00d86184ce3d/occlusion_2615e3c8-e03f-11ed-bb13-00d86184ce3d/scan_b455b658-e03f-11ed-bb13-00d86184ce3d/eaad9e52-e03f-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_261265bf-e03f-11ed-bb13-00d86184ce3d_SESS_2615e3c8-e03f-11ed-bb13-00d86184ce3d_TOSC_b455b658-e03f-11ed-bb13-00d86184ce3d_SNAPS','eaad9e52-e03f-11ed-bb13-00d86184ce3d.png','eaad9e52-e03f-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.4.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 14:27:44.316','2023-04-21 12:27:44.903',NULL),('eaaef6fa-1c09-11ee-a865-a0510b46b473',11,'/home/scan/.data//2023/11/ae8bd11e-1c05-11ee-9323-a0510b46b473/session_bab223ae-1c09-11ee-a865-a0510b46b473/occlusion_bab539ff-1c09-11ee-a865-a0510b46b473/scan_bb6babc0-1c09-11ee-a865-a0510b46b473/eaaef6fa-1c09-11ee-a865-a0510b46b473.zip','PATIENT_ae8bd11e-1c05-11ee-9323-a0510b46b473_ACT_bab223ae-1c09-11ee-a865-a0510b46b473_SESS_bab539ff-1c09-11ee-a865-a0510b46b473_TOSC_bb6babc0-1c09-11ee-a865-a0510b46b473_MODEL','eaaef6fa-1c09-11ee-a865-a0510b46b473.zip','eaaef6fa-1c09-11ee-a865-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.29.2.1.1\",\"modelMatrix\":\"0.981296,0.15243,-0.117576,0,-0.192507,0.777003,-0.599339,0,-4.16529e-09,0.610763,0.791813,0,-28.3446,10.0445,-13.1553,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 16:32:21.268','2023-07-06 14:32:21.722',NULL),('eaaf0c50-1c09-11ee-a865-a0510b46b473',11,'/home/scan/.data//2023/11/ae8bd11e-1c05-11ee-9323-a0510b46b473/session_bab223ae-1c09-11ee-a865-a0510b46b473/occlusion_bab539ff-1c09-11ee-a865-a0510b46b473/scan_bb6babc0-1c09-11ee-a865-a0510b46b473/eaaf0c50-1c09-11ee-a865-a0510b46b473.png','PATIENT_ae8bd11e-1c05-11ee-9323-a0510b46b473_ACT_bab223ae-1c09-11ee-a865-a0510b46b473_SESS_bab539ff-1c09-11ee-a865-a0510b46b473_TOSC_bb6babc0-1c09-11ee-a865-a0510b46b473_SNAPS','eaaf0c50-1c09-11ee-a865-a0510b46b473.png','eaaf0c50-1c09-11ee-a865-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.29.2.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 16:32:21.268','2023-07-06 14:32:21.730',NULL),('eac71d30-1c08-11ee-a865-a0510b46b473',11,'/home/scan/.data//2023/11/ae8bd11e-1c05-11ee-9323-a0510b46b473/session_bb436bde-1c05-11ee-9323-a0510b46b473/occlusion_bb465a1e-1c05-11ee-9323-a0510b46b473/scan_9e224ae1-1c08-11ee-a865-a0510b46b473/eac71d30-1c08-11ee-a865-a0510b46b473.zip','PATIENT_ae8bd11e-1c05-11ee-9323-a0510b46b473_ACT_bb436bde-1c05-11ee-9323-a0510b46b473_SESS_bb465a1e-1c05-11ee-9323-a0510b46b473_TOSC_9e224ae1-1c08-11ee-a865-a0510b46b473_MODEL','eac71d30-1c08-11ee-a865-a0510b46b473.zip','eac71d30-1c08-11ee-a865-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.29.1.1.8\",\"modelMatrix\":\"0.79644,0.603604,-0.0366917,0,-0.604718,0.794973,-0.0483246,0,1.46944e-09,0.0606757,0.998158,0,-32.9394,-0.39661,-12.1399,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 16:25:11.929','2023-07-06 14:25:12.628',NULL),('eac7338b-1c08-11ee-a865-a0510b46b473',11,'/home/scan/.data//2023/11/ae8bd11e-1c05-11ee-9323-a0510b46b473/session_bb436bde-1c05-11ee-9323-a0510b46b473/occlusion_bb465a1e-1c05-11ee-9323-a0510b46b473/scan_9e224ae1-1c08-11ee-a865-a0510b46b473/eac7338b-1c08-11ee-a865-a0510b46b473.png','PATIENT_ae8bd11e-1c05-11ee-9323-a0510b46b473_ACT_bb436bde-1c05-11ee-9323-a0510b46b473_SESS_bb465a1e-1c05-11ee-9323-a0510b46b473_TOSC_9e224ae1-1c08-11ee-a865-a0510b46b473_SNAPS','eac7338b-1c08-11ee-a865-a0510b46b473.png','eac7338b-1c08-11ee-a865-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.29.1.1.8 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 16:25:11.930','2023-07-06 14:25:12.632',NULL),('eb3ec329-dd16-11ed-8097-00d86184ce3d',11,'/home/scan/.data//2023/11/59af3050-dcfe-11ed-8097-00d86184ce3d/session_aed62174-dd16-11ed-8097-00d86184ce3d/occlusion_aed90f86-dd16-11ed-8097-00d86184ce3d/scan_b988ca20-dd16-11ed-8097-00d86184ce3d/eb3ec329-dd16-11ed-8097-00d86184ce3d.zip','PATIENT_59af3050-dcfe-11ed-8097-00d86184ce3d_ACT_aed62174-dd16-11ed-8097-00d86184ce3d_SESS_aed90f86-dd16-11ed-8097-00d86184ce3d_TOSC_b988ca20-dd16-11ed-8097-00d86184ce3d_MODEL','eb3ec329-dd16-11ed-8097-00d86184ce3d.zip','eb3ec329-dd16-11ed-8097-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.1.2.1.1\",\"modelMatrix\":\"0.12502,0.890051,-0.438382,0,-0.992154,0.112154,-0.0552401,0,3.78775e-09,0.441849,0.897089,0,-20.4881,-23.6379,-2.15338,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-04-17 13:56:42.413','2023-04-17 11:56:43.054','2023-04-17 13:56:43.402'),('eb3ed8ab-dd16-11ed-8097-00d86184ce3d',11,'/home/scan/.data//2023/11/59af3050-dcfe-11ed-8097-00d86184ce3d/session_aed62174-dd16-11ed-8097-00d86184ce3d/occlusion_aed90f86-dd16-11ed-8097-00d86184ce3d/scan_b988ca20-dd16-11ed-8097-00d86184ce3d/eb3ed8ab-dd16-11ed-8097-00d86184ce3d.png','PATIENT_59af3050-dcfe-11ed-8097-00d86184ce3d_ACT_aed62174-dd16-11ed-8097-00d86184ce3d_SESS_aed90f86-dd16-11ed-8097-00d86184ce3d_TOSC_b988ca20-dd16-11ed-8097-00d86184ce3d_SNAPS','eb3ed8ab-dd16-11ed-8097-00d86184ce3d.png','eb3ed8ab-dd16-11ed-8097-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.1.2.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-04-17 13:56:42.413','2023-04-17 11:56:43.055','2023-04-17 13:56:43.506'),('eb747a96-deb1-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/e0d449f3-dde9-11ed-aa56-00d86184ce3d/session_858fcc60-de94-11ed-9cc3-00d86184ce3d/occlusion_85925fd9-de94-11ed-9cc3-00d86184ce3d/scan_ac8f201b-deb1-11ed-9cc3-00d86184ce3d/eb747a96-deb1-11ed-9cc3-00d86184ce3d.zip','PATIENT_e0d449f3-dde9-11ed-aa56-00d86184ce3d_ACT_858fcc60-de94-11ed-9cc3-00d86184ce3d_SESS_85925fd9-de94-11ed-9cc3-00d86184ce3d_TOSC_ac8f201b-deb1-11ed-9cc3-00d86184ce3d_MODEL','eb747a96-deb1-11ed-9cc3-00d86184ce3d.zip','eb747a96-deb1-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.2.1.1.3\",\"modelMatrix\":\"-0.694241,0.717068,-0.0619951,0,-0.719743,-0.691661,0.0597985,0,1.95749e-09,0.0861351,0.996283,0,0.324145,-34.7118,-11.5483,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-19 14:58:45.921','2023-04-19 12:58:46.618',NULL),('eb7490eb-deb1-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/e0d449f3-dde9-11ed-aa56-00d86184ce3d/session_858fcc60-de94-11ed-9cc3-00d86184ce3d/occlusion_85925fd9-de94-11ed-9cc3-00d86184ce3d/scan_ac8f201b-deb1-11ed-9cc3-00d86184ce3d/eb7490eb-deb1-11ed-9cc3-00d86184ce3d.png','PATIENT_e0d449f3-dde9-11ed-aa56-00d86184ce3d_ACT_858fcc60-de94-11ed-9cc3-00d86184ce3d_SESS_85925fd9-de94-11ed-9cc3-00d86184ce3d_TOSC_ac8f201b-deb1-11ed-9cc3-00d86184ce3d_SNAPS','eb7490eb-deb1-11ed-9cc3-00d86184ce3d.png','eb7490eb-deb1-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.2.1.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-19 14:58:45.921','2023-04-19 12:58:46.619',NULL),('ebcdda3e-2577-11ee-b81b-a0510b46b473',11,'/home/scan/.data//2023/11/49f1e276-256f-11ee-91d6-a0510b46b473/session_f58279e9-2576-11ee-b81b-a0510b46b473/occlusion_f584e68a-2576-11ee-b81b-a0510b46b473/scan_669cae3d-2577-11ee-b81b-a0510b46b473/ebcdda3e-2577-11ee-b81b-a0510b46b473.zip','PATIENT_49f1e276-256f-11ee-91d6-a0510b46b473_ACT_f58279e9-2576-11ee-b81b-a0510b46b473_SESS_f584e68a-2576-11ee-b81b-a0510b46b473_TOSC_669cae3d-2577-11ee-b81b-a0510b46b473_MODEL','ebcdda3e-2577-11ee-b81b-a0510b46b473.zip','ebcdda3e-2577-11ee-b81b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.33.2.1.1\",\"modelMatrix\":\"0.0510996,0.997042,-0.0574097,0,-0.998694,0.0510151,-0.00293745,0,-2.65962e-10,0.0574848,0.998346,0,-17.6441,-24.6217,-12.3177,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-18 16:32:28.253','2023-07-18 14:32:29.192',NULL),('ebcdf3ad-2577-11ee-b81b-a0510b46b473',11,'/home/scan/.data//2023/11/49f1e276-256f-11ee-91d6-a0510b46b473/session_f58279e9-2576-11ee-b81b-a0510b46b473/occlusion_f584e68a-2576-11ee-b81b-a0510b46b473/scan_669cae3d-2577-11ee-b81b-a0510b46b473/ebcdf3ad-2577-11ee-b81b-a0510b46b473.png','PATIENT_49f1e276-256f-11ee-91d6-a0510b46b473_ACT_f58279e9-2576-11ee-b81b-a0510b46b473_SESS_f584e68a-2576-11ee-b81b-a0510b46b473_TOSC_669cae3d-2577-11ee-b81b-a0510b46b473_SNAPS','ebcdf3ad-2577-11ee-b81b-a0510b46b473.png','ebcdf3ad-2577-11ee-b81b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.33.2.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-18 16:32:28.254','2023-07-18 14:32:29.194',NULL),('ebd76e3d-0f3f-11ee-8712-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_964f8d9e-0f3e-11ee-8712-a0510b46b473/occlusion_965293c3-0f3e-11ee-8712-a0510b46b473/scan_803c4f10-0f3f-11ee-8712-a0510b46b473/ebd76e3d-0f3f-11ee-8712-a0510b46b473.zip','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_964f8d9e-0f3e-11ee-8712-a0510b46b473_SESS_965293c3-0f3e-11ee-8712-a0510b46b473_TOSC_803c4f10-0f3f-11ee-8712-a0510b46b473_MODEL','ebd76e3d-0f3f-11ee-8712-a0510b46b473.zip','ebd76e3d-0f3f-11ee-8712-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.1.1.4\",\"modelMatrix\":\"0.754698,0.648728,-0.0978907,0,-0.656072,0.74625,-0.112606,0,4.40831e-09,0.149207,0.988806,0,-29.9032,-6.53926,-11.7691,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-20 09:56:10.918','2023-06-20 07:56:11.732',NULL),('ebd78cf5-0f3f-11ee-8712-a0510b46b473',11,'/home/scan/.data//2023/11/8e5ac874-0f3e-11ee-8712-a0510b46b473/session_964f8d9e-0f3e-11ee-8712-a0510b46b473/occlusion_965293c3-0f3e-11ee-8712-a0510b46b473/scan_803c4f10-0f3f-11ee-8712-a0510b46b473/ebd78cf5-0f3f-11ee-8712-a0510b46b473.png','PATIENT_8e5ac874-0f3e-11ee-8712-a0510b46b473_ACT_964f8d9e-0f3e-11ee-8712-a0510b46b473_SESS_965293c3-0f3e-11ee-8712-a0510b46b473_TOSC_803c4f10-0f3f-11ee-8712-a0510b46b473_SNAPS','ebd78cf5-0f3f-11ee-8712-a0510b46b473.png','ebd78cf5-0f3f-11ee-8712-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.14.1.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-20 09:56:10.919','2023-06-20 07:56:11.733',NULL),('ec46e25b-deb6-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/cf3f0588-deb2-11ed-9cc3-00d86184ce3d/session_d7750b8d-deb2-11ed-9cc3-00d86184ce3d/occlusion_d7775a50-deb2-11ed-9cc3-00d86184ce3d/scan_91cb80d8-deb6-11ed-9cc3-00d86184ce3d/ec46e25b-deb6-11ed-9cc3-00d86184ce3d.zip','PATIENT_cf3f0588-deb2-11ed-9cc3-00d86184ce3d_ACT_d7750b8d-deb2-11ed-9cc3-00d86184ce3d_SESS_d7775a50-deb2-11ed-9cc3-00d86184ce3d_TOSC_91cb80d8-deb6-11ed-9cc3-00d86184ce3d_MODEL','ec46e25b-deb6-11ed-9cc3-00d86184ce3d.zip','ec46e25b-deb6-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.6.1.1.7\",\"modelMatrix\":\"-0.373671,0.898667,-0.229711,0,-0.927561,-0.362031,0.0925396,0,1.76246e-09,0.24765,0.968849,0,-12.2379,-27.2159,-7.49044,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-19 15:34:34.783','2023-04-19 13:34:35.827',NULL),('ec46f90a-deb6-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/cf3f0588-deb2-11ed-9cc3-00d86184ce3d/session_d7750b8d-deb2-11ed-9cc3-00d86184ce3d/occlusion_d7775a50-deb2-11ed-9cc3-00d86184ce3d/scan_91cb80d8-deb6-11ed-9cc3-00d86184ce3d/ec46f90a-deb6-11ed-9cc3-00d86184ce3d.png','PATIENT_cf3f0588-deb2-11ed-9cc3-00d86184ce3d_ACT_d7750b8d-deb2-11ed-9cc3-00d86184ce3d_SESS_d7775a50-deb2-11ed-9cc3-00d86184ce3d_TOSC_91cb80d8-deb6-11ed-9cc3-00d86184ce3d_SNAPS','ec46f90a-deb6-11ed-9cc3-00d86184ce3d.png','ec46f90a-deb6-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.6.1.1.7 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-19 15:34:34.784','2023-04-19 13:34:35.835',NULL),('ecf85446-e343-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_853ebc79-e33f-11ed-8c5e-00d86184ce3d/occlusion_8541c500-e33f-11ed-8c5e-00d86184ce3d/scan_8bb79791-e343-11ed-8c5e-00d86184ce3d/ecf85446-e343-11ed-8c5e-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_853ebc79-e33f-11ed-8c5e-00d86184ce3d_SESS_8541c500-e33f-11ed-8c5e-00d86184ce3d_TOSC_8bb79791-e343-11ed-8c5e-00d86184ce3d_MODEL','ecf85446-e343-11ed-8c5e-00d86184ce3d.zip','ecf85446-e343-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.6.1.5\",\"modelMatrix\":\"0.732925,0.670073,-0.117569,0,-0.680309,0.721898,-0.126662,0,7.00501e-09,0.172816,0.984954,0,-31.0181,-2.93234,-8.32973,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-25 10:33:59.636','2023-04-25 08:34:00.516',NULL),('ecf86cad-e343-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_853ebc79-e33f-11ed-8c5e-00d86184ce3d/occlusion_8541c500-e33f-11ed-8c5e-00d86184ce3d/scan_8bb79791-e343-11ed-8c5e-00d86184ce3d/ecf86cad-e343-11ed-8c5e-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_853ebc79-e33f-11ed-8c5e-00d86184ce3d_SESS_8541c500-e33f-11ed-8c5e-00d86184ce3d_TOSC_8bb79791-e343-11ed-8c5e-00d86184ce3d_SNAPS','ecf86cad-e343-11ed-8c5e-00d86184ce3d.png','ecf86cad-e343-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.6.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-25 10:33:59.637','2023-04-25 08:34:00.517',NULL),('ed37d334-de85-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/f29210da-de80-11ed-9cc3-00d86184ce3d/session_ffdb9942-de80-11ed-9cc3-00d86184ce3d/occlusion_ffdebb3e-de80-11ed-9cc3-00d86184ce3d/scan_acd32a60-de85-11ed-9cc3-00d86184ce3d/ed37d334-de85-11ed-9cc3-00d86184ce3d.zip','PATIENT_f29210da-de80-11ed-9cc3-00d86184ce3d_ACT_ffdb9942-de80-11ed-9cc3-00d86184ce3d_SESS_ffdebb3e-de80-11ed-9cc3-00d86184ce3d_TOSC_acd32a60-de85-11ed-9cc3-00d86184ce3d_MODEL','ed37d334-de85-11ed-9cc3-00d86184ce3d.zip','ed37d334-de85-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.3.1.1.2\",\"modelMatrix\":\"0.649659,0.735555,-0.1921,0,-0.760226,0.628576,-0.164161,0,3.54406e-09,0.252688,0.967548,0,-30.0002,-2.36408,-9.74107,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-04-19 09:43:51.022','2023-04-19 07:43:51.643','2023-04-19 09:43:53.368'),('ed37e0e3-de85-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/f29210da-de80-11ed-9cc3-00d86184ce3d/session_ffdb9942-de80-11ed-9cc3-00d86184ce3d/occlusion_ffdebb3e-de80-11ed-9cc3-00d86184ce3d/scan_acd32a60-de85-11ed-9cc3-00d86184ce3d/ed37e0e3-de85-11ed-9cc3-00d86184ce3d.png','PATIENT_f29210da-de80-11ed-9cc3-00d86184ce3d_ACT_ffdb9942-de80-11ed-9cc3-00d86184ce3d_SESS_ffdebb3e-de80-11ed-9cc3-00d86184ce3d_TOSC_acd32a60-de85-11ed-9cc3-00d86184ce3d_SNAPS','ed37e0e3-de85-11ed-9cc3-00d86184ce3d.png','ed37e0e3-de85-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.3.1.1.2 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-04-19 09:43:51.023','2023-04-19 07:43:51.650','2023-04-19 09:43:53.488'),('ed666cc3-0f75-11ee-9460-a0510b46b473',11,'/home/scan/.data//2023/11/e4b67639-0f72-11ee-8712-a0510b46b473/session_ec7935d6-0f72-11ee-8712-a0510b46b473/occlusion_ec7bd8ad-0f72-11ee-8712-a0510b46b473/scan_a4c88975-0f75-11ee-9460-a0510b46b473/ed666cc3-0f75-11ee-9460-a0510b46b473.zip','PATIENT_e4b67639-0f72-11ee-8712-a0510b46b473_ACT_ec7935d6-0f72-11ee-8712-a0510b46b473_SESS_ec7bd8ad-0f72-11ee-8712-a0510b46b473_TOSC_a4c88975-0f75-11ee-9460-a0510b46b473_MODEL','ed666cc3-0f75-11ee-9460-a0510b46b473.zip','ed666cc3-0f75-11ee-9460-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.15.1.1.2\",\"modelMatrix\":\"0.854121,0.475517,-0.210619,0,-0.520074,0.780945,-0.345901,0,-8.64195e-09,0.404979,0.914326,0,-30.8479,-2.07281,-7.68186,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-20 16:22:46.356','2023-06-20 14:22:46.980',NULL),('ed6684b9-0f75-11ee-9460-a0510b46b473',11,'/home/scan/.data//2023/11/e4b67639-0f72-11ee-8712-a0510b46b473/session_ec7935d6-0f72-11ee-8712-a0510b46b473/occlusion_ec7bd8ad-0f72-11ee-8712-a0510b46b473/scan_a4c88975-0f75-11ee-9460-a0510b46b473/ed6684b9-0f75-11ee-9460-a0510b46b473.png','PATIENT_e4b67639-0f72-11ee-8712-a0510b46b473_ACT_ec7935d6-0f72-11ee-8712-a0510b46b473_SESS_ec7bd8ad-0f72-11ee-8712-a0510b46b473_TOSC_a4c88975-0f75-11ee-9460-a0510b46b473_SNAPS','ed6684b9-0f75-11ee-9460-a0510b46b473.png','ed6684b9-0f75-11ee-9460-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.15.1.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-20 16:22:46.357','2023-06-20 14:22:46.981',NULL),('eddc1b58-14cc-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/9619fcac-14c3-11ee-b3b1-00d86184ce3d/session_5f50caeb-14cc-11ee-b3b1-00d86184ce3d/occlusion_5f53d32e-14cc-11ee-b3b1-00d86184ce3d/scan_a2ad7fa0-14cc-11ee-b3b1-00d86184ce3d/eddc1b58-14cc-11ee-b3b1-00d86184ce3d.zip','PATIENT_9619fcac-14c3-11ee-b3b1-00d86184ce3d_ACT_5f50caeb-14cc-11ee-b3b1-00d86184ce3d_SESS_5f53d32e-14cc-11ee-b3b1-00d86184ce3d_TOSC_a2ad7fa0-14cc-11ee-b3b1-00d86184ce3d_MODEL','eddc1b58-14cc-11ee-b3b1-00d86184ce3d.zip','eddc1b58-14cc-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.22.2.1.2\",\"modelMatrix\":\"0.455128,0.750053,-0.479873,0,-0.890426,0.383379,-0.24528,0,-2.15257e-09,0.538925,0.842354,0,-36.2838,-10.1513,-3.0803,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-27 11:28:09.157','2023-06-27 09:28:09.683',NULL),('eddc27fd-14cc-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/9619fcac-14c3-11ee-b3b1-00d86184ce3d/session_5f50caeb-14cc-11ee-b3b1-00d86184ce3d/occlusion_5f53d32e-14cc-11ee-b3b1-00d86184ce3d/scan_a2ad7fa0-14cc-11ee-b3b1-00d86184ce3d/eddc27fd-14cc-11ee-b3b1-00d86184ce3d.png','PATIENT_9619fcac-14c3-11ee-b3b1-00d86184ce3d_ACT_5f50caeb-14cc-11ee-b3b1-00d86184ce3d_SESS_5f53d32e-14cc-11ee-b3b1-00d86184ce3d_TOSC_a2ad7fa0-14cc-11ee-b3b1-00d86184ce3d_SNAPS','eddc27fd-14cc-11ee-b3b1-00d86184ce3d.png','eddc27fd-14cc-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.22.2.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-27 11:28:09.157','2023-06-27 09:28:09.684',NULL),('edfdf3b8-e020-11ed-a285-00d86184ce3d',11,'/home/scan/.data//2023/11/5f27680c-e01a-11ed-b6c2-00d86184ce3d/session_65b85f32-e01a-11ed-b6c2-00d86184ce3d/occlusion_65ba9a94-e01a-11ed-b6c2-00d86184ce3d/scan_7b6720a5-e020-11ed-a285-00d86184ce3d/edfdf3b8-e020-11ed-a285-00d86184ce3d.zip','PATIENT_5f27680c-e01a-11ed-b6c2-00d86184ce3d_ACT_65b85f32-e01a-11ed-b6c2-00d86184ce3d_SESS_65ba9a94-e01a-11ed-b6c2-00d86184ce3d_TOSC_7b6720a5-e020-11ed-a285-00d86184ce3d_MODEL','edfdf3b8-e020-11ed-a285-00d86184ce3d.zip','edfdf3b8-e020-11ed-a285-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.10.1.1.8\",\"modelMatrix\":\"0.998697,0.0499917,-0.0102897,0,-0.0510397,0.978191,-0.201339,0,1.18056e-12,0.201602,0.979467,0,-25.9507,14.9409,-12.8239,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 10:45:55.478','2023-04-21 08:45:56.390',NULL),('edfe269b-e020-11ed-a285-00d86184ce3d',11,'/home/scan/.data//2023/11/5f27680c-e01a-11ed-b6c2-00d86184ce3d/session_65b85f32-e01a-11ed-b6c2-00d86184ce3d/occlusion_65ba9a94-e01a-11ed-b6c2-00d86184ce3d/scan_7b6720a5-e020-11ed-a285-00d86184ce3d/edfe269b-e020-11ed-a285-00d86184ce3d.png','PATIENT_5f27680c-e01a-11ed-b6c2-00d86184ce3d_ACT_65b85f32-e01a-11ed-b6c2-00d86184ce3d_SESS_65ba9a94-e01a-11ed-b6c2-00d86184ce3d_TOSC_7b6720a5-e020-11ed-a285-00d86184ce3d_SNAPS','edfe269b-e020-11ed-a285-00d86184ce3d.png','edfe269b-e020-11ed-a285-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.10.1.1.8 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 10:45:55.478','2023-04-21 08:45:56.390',NULL),('f07060fa-10e1-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/2ff330cd-10e1-11ee-b636-a0510b46b473/session_3adeac35-10e1-11ee-b636-a0510b46b473/occlusion_3ae23ec4-10e1-11ee-b636-a0510b46b473/scan_a8b68bd3-10e1-11ee-b636-a0510b46b473/f07060fa-10e1-11ee-b636-a0510b46b473.zip','PATIENT_2ff330cd-10e1-11ee-b636-a0510b46b473_ACT_3adeac35-10e1-11ee-b636-a0510b46b473_SESS_3ae23ec4-10e1-11ee-b636-a0510b46b473_TOSC_a8b68bd3-10e1-11ee-b636-a0510b46b473_MODEL','f07060fa-10e1-11ee-b636-a0510b46b473.zip','f07060fa-10e1-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.18.1.1.2\",\"modelMatrix\":\"0.432828,0.874571,-0.218601,0,-0.901476,0.41991,-0.104957,0,4.07003e-09,0.242492,0.970153,0,-27.3117,-18.9912,-8.67711,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 11:48:28.264','2023-06-22 09:48:28.917',NULL),('f07078ce-10e1-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/2ff330cd-10e1-11ee-b636-a0510b46b473/session_3adeac35-10e1-11ee-b636-a0510b46b473/occlusion_3ae23ec4-10e1-11ee-b636-a0510b46b473/scan_a8b68bd3-10e1-11ee-b636-a0510b46b473/f07078ce-10e1-11ee-b636-a0510b46b473.png','PATIENT_2ff330cd-10e1-11ee-b636-a0510b46b473_ACT_3adeac35-10e1-11ee-b636-a0510b46b473_SESS_3ae23ec4-10e1-11ee-b636-a0510b46b473_TOSC_a8b68bd3-10e1-11ee-b636-a0510b46b473_SNAPS','f07078ce-10e1-11ee-b636-a0510b46b473.png','f07078ce-10e1-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.18.1.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 11:48:28.265','2023-06-22 09:48:28.917',NULL),('f0c144de-14e4-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_efcc55aa-14e3-11ee-b3b1-00d86184ce3d/occlusion_efcf357e-14e3-11ee-b3b1-00d86184ce3d/scan_9f9bdaac-14e4-11ee-b3b1-00d86184ce3d/f0c144de-14e4-11ee-b3b1-00d86184ce3d.zip','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_efcc55aa-14e3-11ee-b3b1-00d86184ce3d_SESS_efcf357e-14e3-11ee-b3b1-00d86184ce3d_TOSC_9f9bdaac-14e4-11ee-b3b1-00d86184ce3d_MODEL','f0c144de-14e4-11ee-b3b1-00d86184ce3d.zip','f0c144de-14e4-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.20.3.1.3\",\"modelMatrix\":\"0.454437,0.861755,-0.225535,0,-0.890779,0.43963,-0.115058,0,-1.44628e-09,0.253189,0.967417,0,-29.1508,-16.2524,-8.95171,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-27 14:20:01.936','2023-06-27 12:20:02.723',NULL),('f0c15c1c-14e4-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_efcc55aa-14e3-11ee-b3b1-00d86184ce3d/occlusion_efcf357e-14e3-11ee-b3b1-00d86184ce3d/scan_9f9bdaac-14e4-11ee-b3b1-00d86184ce3d/f0c15c1c-14e4-11ee-b3b1-00d86184ce3d.png','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_efcc55aa-14e3-11ee-b3b1-00d86184ce3d_SESS_efcf357e-14e3-11ee-b3b1-00d86184ce3d_TOSC_9f9bdaac-14e4-11ee-b3b1-00d86184ce3d_SNAPS','f0c15c1c-14e4-11ee-b3b1-00d86184ce3d.png','f0c15c1c-14e4-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.20.3.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-27 14:20:01.936','2023-06-27 12:20:02.723',NULL),('f0c79b46-4bed-11ee-839e-a0510b46b473',11,'/var/.data/2023/11/a414a41e-4bed-11ee-839e-a0510b46b473/session_a9a1083a-4bed-11ee-839e-a0510b46b473/occlusion_a9a41c2e-4bed-11ee-839e-a0510b46b473/scan_aa95c726-4bed-11ee-839e-a0510b46b473/f0c79b46-4bed-11ee-839e-a0510b46b473.zip','PATIENT_a414a41e-4bed-11ee-839e-a0510b46b473_ACT_a9a1083a-4bed-11ee-839e-a0510b46b473_SESS_a9a41c2e-4bed-11ee-839e-a0510b46b473_TOSC_aa95c726-4bed-11ee-839e-a0510b46b473_MODEL','f0c79b46-4bed-11ee-839e-a0510b46b473.zip','f0c79b46-4bed-11ee-839e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.38.1.1.1\",\"modelMatrix\":\"-0.314342,0.940885,-0.126194,0,-0.94931,-0.311552,0.0417861,0,-2.05244e-09,0.132932,0.991125,0,-6.17263,-27.1968,-10.1964,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-09-05 15:13:01.401','2023-09-05 13:13:02.065',NULL),('f0c7b442-4bed-11ee-839e-a0510b46b473',11,'/var/.data/2023/11/a414a41e-4bed-11ee-839e-a0510b46b473/session_a9a1083a-4bed-11ee-839e-a0510b46b473/occlusion_a9a41c2e-4bed-11ee-839e-a0510b46b473/scan_aa95c726-4bed-11ee-839e-a0510b46b473/f0c7b442-4bed-11ee-839e-a0510b46b473.png','PATIENT_a414a41e-4bed-11ee-839e-a0510b46b473_ACT_a9a1083a-4bed-11ee-839e-a0510b46b473_SESS_a9a41c2e-4bed-11ee-839e-a0510b46b473_TOSC_aa95c726-4bed-11ee-839e-a0510b46b473_SNAPS','f0c7b442-4bed-11ee-839e-a0510b46b473.png','f0c7b442-4bed-11ee-839e-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.38.1.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-09-05 15:13:01.401','2023-09-05 13:13:02.065',NULL),('f109ac0a-1a79-11ee-8124-a0510b46b473',11,'/home/scan/.data//2023/11/61e16a70-1a76-11ee-8124-a0510b46b473/session_c8578c2f-1a77-11ee-8124-a0510b46b473/occlusion_c85af2e9-1a77-11ee-8124-a0510b46b473/scan_9fde0a5b-1a79-11ee-8124-a0510b46b473/f109ac0a-1a79-11ee-8124-a0510b46b473.zip','PATIENT_61e16a70-1a76-11ee-8124-a0510b46b473_ACT_c8578c2f-1a77-11ee-8124-a0510b46b473_SESS_c85af2e9-1a77-11ee-8124-a0510b46b473_TOSC_9fde0a5b-1a79-11ee-8124-a0510b46b473_MODEL','f109ac0a-1a79-11ee-8124-a0510b46b473.zip','f109ac0a-1a79-11ee-8124-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.27.2.1.5\",\"modelMatrix\":\"0.52866,0.836792,-0.14247,0,-0.848834,0.52116,-0.0887315,0,-5.46326e-09,0.167842,0.985814,0,-32.586,-11.815,-12.8014,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-04 16:49:13.237','2023-07-04 14:49:13.826',NULL),('f109c441-1a79-11ee-8124-a0510b46b473',11,'/home/scan/.data//2023/11/61e16a70-1a76-11ee-8124-a0510b46b473/session_c8578c2f-1a77-11ee-8124-a0510b46b473/occlusion_c85af2e9-1a77-11ee-8124-a0510b46b473/scan_9fde0a5b-1a79-11ee-8124-a0510b46b473/f109c441-1a79-11ee-8124-a0510b46b473.png','PATIENT_61e16a70-1a76-11ee-8124-a0510b46b473_ACT_c8578c2f-1a77-11ee-8124-a0510b46b473_SESS_c85af2e9-1a77-11ee-8124-a0510b46b473_TOSC_9fde0a5b-1a79-11ee-8124-a0510b46b473_SNAPS','f109c441-1a79-11ee-8124-a0510b46b473.png','f109c441-1a79-11ee-8124-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.27.2.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-04 16:49:13.237','2023-07-04 14:49:13.830',NULL),('f11d0cfa-e33f-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_853ebc79-e33f-11ed-8c5e-00d86184ce3d/occlusion_8541c500-e33f-11ed-8c5e-00d86184ce3d/scan_bbda8c72-e33f-11ed-8c5e-00d86184ce3d/f11d0cfa-e33f-11ed-8c5e-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_853ebc79-e33f-11ed-8c5e-00d86184ce3d_SESS_8541c500-e33f-11ed-8c5e-00d86184ce3d_TOSC_bbda8c72-e33f-11ed-8c5e-00d86184ce3d_MODEL','f11d0cfa-e33f-11ed-8c5e-00d86184ce3d.zip','f11d0cfa-e33f-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.6.1.1\",\"modelMatrix\":\"0.983455,0.170481,-0.0612589,0,-0.181153,0.925518,-0.332565,0,-8.06253e-10,0.33816,0.941088,0,-24.4174,14.0867,-14.6159,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,'2023-04-25 10:27:41.501','2023-04-25 10:05:28.601','2023-04-25 08:27:41.506',NULL),('f11d2a5b-e33f-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_853ebc79-e33f-11ed-8c5e-00d86184ce3d/occlusion_8541c500-e33f-11ed-8c5e-00d86184ce3d/scan_bbda8c72-e33f-11ed-8c5e-00d86184ce3d/f11d2a5b-e33f-11ed-8c5e-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_853ebc79-e33f-11ed-8c5e-00d86184ce3d_SESS_8541c500-e33f-11ed-8c5e-00d86184ce3d_TOSC_bbda8c72-e33f-11ed-8c5e-00d86184ce3d_SNAPS','f11d2a5b-e33f-11ed-8c5e-00d86184ce3d.png','f11d2a5b-e33f-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.6.1.1 Snapshot\"}','PNG',0,'CREATED',0,'2023-04-25 10:27:41.501','2023-04-25 10:05:28.601','2023-04-25 08:27:41.510',NULL),('f29d3207-1108-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_ceaea325-1107-11ee-b636-a0510b46b473/occlusion_ceb199a7-1107-11ee-b636-a0510b46b473/scan_9a63cecb-1108-11ee-b636-a0510b46b473/f29d3207-1108-11ee-b636-a0510b46b473.zip','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_ceaea325-1107-11ee-b636-a0510b46b473_SESS_ceb199a7-1107-11ee-b636-a0510b46b473_TOSC_9a63cecb-1108-11ee-b636-a0510b46b473_MODEL','f29d3207-1108-11ee-b636-a0510b46b473.zip','f29d3207-1108-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.20.2.1.4\",\"modelMatrix\":\"0.734518,0.599106,-0.318677,0,-0.678589,0.648484,-0.344942,0,1.67393e-08,0.469617,0.88287,0,-69.7537,57.2586,-19.4882,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 16:27:42.286','2023-06-22 14:27:42.917',NULL),('f29d477a-1108-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/f72be411-1103-11ee-b636-a0510b46b473/session_ceaea325-1107-11ee-b636-a0510b46b473/occlusion_ceb199a7-1107-11ee-b636-a0510b46b473/scan_9a63cecb-1108-11ee-b636-a0510b46b473/f29d477a-1108-11ee-b636-a0510b46b473.png','PATIENT_f72be411-1103-11ee-b636-a0510b46b473_ACT_ceaea325-1107-11ee-b636-a0510b46b473_SESS_ceb199a7-1107-11ee-b636-a0510b46b473_TOSC_9a63cecb-1108-11ee-b636-a0510b46b473_SNAPS','f29d477a-1108-11ee-b636-a0510b46b473.png','f29d477a-1108-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.20.2.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 16:27:42.286','2023-06-22 14:27:42.918',NULL),('f300552c-dd07-11ed-8097-00d86184ce3d',11,'/home/scan/.data//2023/11/59af3050-dcfe-11ed-8097-00d86184ce3d/session_61025fcf-dcfe-11ed-8097-00d86184ce3d/occlusion_610548c3-dcfe-11ed-8097-00d86184ce3d/scan_9c4cc46d-dd07-11ed-8097-00d86184ce3d/f300552c-dd07-11ed-8097-00d86184ce3d.zip','PATIENT_59af3050-dcfe-11ed-8097-00d86184ce3d_ACT_61025fcf-dcfe-11ed-8097-00d86184ce3d_SESS_610548c3-dcfe-11ed-8097-00d86184ce3d_BOSC_9c4cc46d-dd07-11ed-8097-00d86184ce3d_MODEL','f300552c-dd07-11ed-8097-00d86184ce3d.zip','f300552c-dd07-11ed-8097-00d86184ce3d','{\"displayTitle\":\"Mandibule 1.1.1.1.3\",\"modelMatrix\":\"-0.373074,0.873282,-0.313358,0,-0.927801,-0.351152,0.126003,0,3.43509e-09,0.337743,0.941238,0,17.7056,-16.5848,-12.5826,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-04-17 12:09:32.974','2023-04-17 10:09:33.780','2023-04-17 12:09:34.188'),('f3006d0c-dd07-11ed-8097-00d86184ce3d',11,'/home/scan/.data//2023/11/59af3050-dcfe-11ed-8097-00d86184ce3d/session_61025fcf-dcfe-11ed-8097-00d86184ce3d/occlusion_610548c3-dcfe-11ed-8097-00d86184ce3d/scan_9c4cc46d-dd07-11ed-8097-00d86184ce3d/f3006d0c-dd07-11ed-8097-00d86184ce3d.png','PATIENT_59af3050-dcfe-11ed-8097-00d86184ce3d_ACT_61025fcf-dcfe-11ed-8097-00d86184ce3d_SESS_610548c3-dcfe-11ed-8097-00d86184ce3d_BOSC_9c4cc46d-dd07-11ed-8097-00d86184ce3d_SNAPS','f3006d0c-dd07-11ed-8097-00d86184ce3d.png','f3006d0c-dd07-11ed-8097-00d86184ce3d','{\"displayTitle\":\"Mandibule 1.1.1.1.3 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-04-17 12:09:32.975','2023-04-17 10:09:33.781','2023-04-17 12:09:34.330'),('f3ba20c5-14cf-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/9619fcac-14c3-11ee-b3b1-00d86184ce3d/session_5f50caeb-14cc-11ee-b3b1-00d86184ce3d/occlusion_5f53d32e-14cc-11ee-b3b1-00d86184ce3d/scan_c3b81436-14cf-11ee-b3b1-00d86184ce3d/f3ba20c5-14cf-11ee-b3b1-00d86184ce3d.zip','PATIENT_9619fcac-14c3-11ee-b3b1-00d86184ce3d_ACT_5f50caeb-14cc-11ee-b3b1-00d86184ce3d_SESS_5f53d32e-14cc-11ee-b3b1-00d86184ce3d_TOSC_c3b81436-14cf-11ee-b3b1-00d86184ce3d_MODEL','f3ba20c5-14cf-11ee-b3b1-00d86184ce3d.zip','f3ba20c5-14cf-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.22.2.1.4\",\"modelMatrix\":\"0.946266,0.250697,-0.204282,0,-0.323389,0.733563,-0.59775,0,1.2949e-08,0.631693,0.775219,0,-27.8204,10.1746,-12.4118,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-27 11:49:47.491','2023-06-27 09:49:47.951',NULL),('f3ba3662-14cf-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/9619fcac-14c3-11ee-b3b1-00d86184ce3d/session_5f50caeb-14cc-11ee-b3b1-00d86184ce3d/occlusion_5f53d32e-14cc-11ee-b3b1-00d86184ce3d/scan_c3b81436-14cf-11ee-b3b1-00d86184ce3d/f3ba3662-14cf-11ee-b3b1-00d86184ce3d.png','PATIENT_9619fcac-14c3-11ee-b3b1-00d86184ce3d_ACT_5f50caeb-14cc-11ee-b3b1-00d86184ce3d_SESS_5f53d32e-14cc-11ee-b3b1-00d86184ce3d_TOSC_c3b81436-14cf-11ee-b3b1-00d86184ce3d_SNAPS','f3ba3662-14cf-11ee-b3b1-00d86184ce3d.png','f3ba3662-14cf-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.22.2.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-27 11:49:47.491','2023-06-27 09:49:47.952',NULL),('f509f62c-1bff-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/8a8cc548-1bf9-11ee-9323-a0510b46b473/session_976f015a-1bf9-11ee-9323-a0510b46b473/occlusion_97713d19-1bf9-11ee-9323-a0510b46b473/scan_af0ad256-1bff-11ee-9323-a0510b46b473/f509f62c-1bff-11ee-9323-a0510b46b473.zip','PATIENT_8a8cc548-1bf9-11ee-9323-a0510b46b473_ACT_976f015a-1bf9-11ee-9323-a0510b46b473_SESS_97713d19-1bf9-11ee-9323-a0510b46b473_TOSC_af0ad256-1bff-11ee-9323-a0510b46b473_MODEL','f509f62c-1bff-11ee-9323-a0510b46b473.zip','f509f62c-1bff-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.28.1.1.12\",\"modelMatrix\":\"-0.556434,0.826019,-0.0898527,0,-0.830892,-0.553171,0.0601729,0,-6.22262e-10,0.10814,0.994136,0,-1.98932,-30.0348,-10.6595,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 15:21:03.674','2023-07-06 13:21:04.395',NULL),('f50a0cd0-1bff-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/8a8cc548-1bf9-11ee-9323-a0510b46b473/session_976f015a-1bf9-11ee-9323-a0510b46b473/occlusion_97713d19-1bf9-11ee-9323-a0510b46b473/scan_af0ad256-1bff-11ee-9323-a0510b46b473/f50a0cd0-1bff-11ee-9323-a0510b46b473.png','PATIENT_8a8cc548-1bf9-11ee-9323-a0510b46b473_ACT_976f015a-1bf9-11ee-9323-a0510b46b473_SESS_97713d19-1bf9-11ee-9323-a0510b46b473_TOSC_af0ad256-1bff-11ee-9323-a0510b46b473_SNAPS','f50a0cd0-1bff-11ee-9323-a0510b46b473.png','f50a0cd0-1bff-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.28.1.1.12 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 15:21:03.675','2023-07-06 13:21:04.398',NULL),('f525a2e4-e036-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_63b81b7e-e035-11ed-bb13-00d86184ce3d/occlusion_63bb1989-e035-11ed-bb13-00d86184ce3d/scan_dd0e2e7b-e036-11ed-bb13-00d86184ce3d/f525a2e4-e036-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_63b81b7e-e035-11ed-bb13-00d86184ce3d_SESS_63bb1989-e035-11ed-bb13-00d86184ce3d_TOSC_dd0e2e7b-e036-11ed-bb13-00d86184ce3d_MODEL','f525a2e4-e036-11ed-bb13-00d86184ce3d.zip','f525a2e4-e036-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.2.1.4\",\"modelMatrix\":\"0.770958,0.502453,-0.391362,0,-0.636886,0.608226,-0.473748,0,6.87859e-09,0.614493,0.788922,0,-13.8025,-10.4449,-7.16881,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 13:23:36.409','2023-04-21 11:23:36.732',NULL),('f525b7bf-e036-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_63b81b7e-e035-11ed-bb13-00d86184ce3d/occlusion_63bb1989-e035-11ed-bb13-00d86184ce3d/scan_dd0e2e7b-e036-11ed-bb13-00d86184ce3d/f525b7bf-e036-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_63b81b7e-e035-11ed-bb13-00d86184ce3d_SESS_63bb1989-e035-11ed-bb13-00d86184ce3d_TOSC_dd0e2e7b-e036-11ed-bb13-00d86184ce3d_SNAPS','f525b7bf-e036-11ed-bb13-00d86184ce3d.png','f525b7bf-e036-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.2.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 13:23:36.409','2023-04-21 11:23:36.742',NULL),('f61b6c53-10db-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/bd51960a-10d5-11ee-b636-a0510b46b473/session_ea36dd21-10da-11ee-b636-a0510b46b473/occlusion_ea39c2be-10da-11ee-b636-a0510b46b473/scan_b93f3f44-10db-11ee-b636-a0510b46b473/f61b6c53-10db-11ee-b636-a0510b46b473.zip','PATIENT_bd51960a-10d5-11ee-b636-a0510b46b473_ACT_ea36dd21-10da-11ee-b636-a0510b46b473_SESS_ea39c2be-10da-11ee-b636-a0510b46b473_TOSC_b93f3f44-10db-11ee-b636-a0510b46b473_MODEL','f61b6c53-10db-11ee-b636-a0510b46b473.zip','f61b6c53-10db-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.17.2.1.4\",\"modelMatrix\":\"0.535328,0.801492,-0.266524,0,-0.844644,0.507978,-0.168921,0,5.70083e-09,0.315546,0.94891,0,-26.5759,-0.494885,-8.31552,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-22 11:05:40.793','2023-06-22 09:05:41.408',NULL),('f61b8147-10db-11ee-b636-a0510b46b473',11,'/home/scan/.data//2023/11/bd51960a-10d5-11ee-b636-a0510b46b473/session_ea36dd21-10da-11ee-b636-a0510b46b473/occlusion_ea39c2be-10da-11ee-b636-a0510b46b473/scan_b93f3f44-10db-11ee-b636-a0510b46b473/f61b8147-10db-11ee-b636-a0510b46b473.png','PATIENT_bd51960a-10d5-11ee-b636-a0510b46b473_ACT_ea36dd21-10da-11ee-b636-a0510b46b473_SESS_ea39c2be-10da-11ee-b636-a0510b46b473_TOSC_b93f3f44-10db-11ee-b636-a0510b46b473_SNAPS','f61b8147-10db-11ee-b636-a0510b46b473.png','f61b8147-10db-11ee-b636-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.17.2.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-22 11:05:40.794','2023-06-22 09:05:41.412',NULL),('f72024db-e348-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/971e14b0-e348-11ed-8c5e-00d86184ce3d/session_a0fbda94-e348-11ed-8c5e-00d86184ce3d/occlusion_a0febadb-e348-11ed-8c5e-00d86184ce3d/scan_a63a9e27-e348-11ed-8c5e-00d86184ce3d/f72024db-e348-11ed-8c5e-00d86184ce3d.zip','PATIENT_971e14b0-e348-11ed-8c5e-00d86184ce3d_ACT_a0fbda94-e348-11ed-8c5e-00d86184ce3d_SESS_a0febadb-e348-11ed-8c5e-00d86184ce3d_TOSC_a63a9e27-e348-11ed-8c5e-00d86184ce3d_MODEL','f72024db-e348-11ed-8c5e-00d86184ce3d.zip','f72024db-e348-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.12.1.1.1\",\"modelMatrix\":\"0.528037,0.792179,-0.30599,0,-0.849221,0.492569,-0.190261,0,-5.03714e-09,0.360318,0.932829,0,-31.719,-6.31771,-7.91478,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-25 11:10:04.158','2023-04-25 09:10:05.049',NULL),('f72033a2-e348-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/971e14b0-e348-11ed-8c5e-00d86184ce3d/session_a0fbda94-e348-11ed-8c5e-00d86184ce3d/occlusion_a0febadb-e348-11ed-8c5e-00d86184ce3d/scan_a63a9e27-e348-11ed-8c5e-00d86184ce3d/f72033a2-e348-11ed-8c5e-00d86184ce3d.png','PATIENT_971e14b0-e348-11ed-8c5e-00d86184ce3d_ACT_a0fbda94-e348-11ed-8c5e-00d86184ce3d_SESS_a0febadb-e348-11ed-8c5e-00d86184ce3d_TOSC_a63a9e27-e348-11ed-8c5e-00d86184ce3d_SNAPS','f72033a2-e348-11ed-8c5e-00d86184ce3d.png','f72033a2-e348-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.12.1.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-25 11:10:04.158','2023-04-25 09:10:05.050',NULL),('f74a0208-e03a-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_6f09f9a8-e03a-11ed-bb13-00d86184ce3d/occlusion_6f0c3cda-e03a-11ed-bb13-00d86184ce3d/scan_dd3763a1-e03a-11ed-bb13-00d86184ce3d/f74a0208-e03a-11ed-bb13-00d86184ce3d.zip','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_6f09f9a8-e03a-11ed-bb13-00d86184ce3d_SESS_6f0c3cda-e03a-11ed-bb13-00d86184ce3d_TOSC_dd3763a1-e03a-11ed-bb13-00d86184ce3d_MODEL','f74a0208-e03a-11ed-bb13-00d86184ce3d.zip','f74a0208-e03a-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.3.1.4\",\"modelMatrix\":\"0.928493,0.346718,-0.132994,0,-0.37135,0.866906,-0.332526,0,6.25715e-09,0.358135,0.93367,0,-15.8795,-7.00976,-8.72256,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,'2023-04-21 13:55:24.740','2023-04-21 13:52:17.990','2023-04-21 11:55:24.741',NULL),('f74a1787-e03a-11ed-bb13-00d86184ce3d',11,'/home/scan/.data//2023/11/e86b5c99-e024-11ed-bb13-00d86184ce3d/session_6f09f9a8-e03a-11ed-bb13-00d86184ce3d/occlusion_6f0c3cda-e03a-11ed-bb13-00d86184ce3d/scan_dd3763a1-e03a-11ed-bb13-00d86184ce3d/f74a1787-e03a-11ed-bb13-00d86184ce3d.png','PATIENT_e86b5c99-e024-11ed-bb13-00d86184ce3d_ACT_6f09f9a8-e03a-11ed-bb13-00d86184ce3d_SESS_6f0c3cda-e03a-11ed-bb13-00d86184ce3d_TOSC_dd3763a1-e03a-11ed-bb13-00d86184ce3d_SNAPS','f74a1787-e03a-11ed-bb13-00d86184ce3d.png','f74a1787-e03a-11ed-bb13-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.11.3.1.4 Snapshot\"}','PNG',0,'CREATED',0,'2023-04-21 13:55:24.740','2023-04-21 13:52:17.990','2023-04-21 11:55:24.742',NULL),('f7ccb0db-2a38-11ee-9e90-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_b144ba33-2a36-11ee-9e90-a0510b46b473/occlusion_b147bba1-2a36-11ee-9e90-a0510b46b473/scan_bdee4251-2a38-11ee-9e90-a0510b46b473/f7ccb0db-2a38-11ee-9e90-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_b144ba33-2a36-11ee-9e90-a0510b46b473_SESS_b147bba1-2a36-11ee-9e90-a0510b46b473_TOSC_bdee4251-2a38-11ee-9e90-a0510b46b473_MODEL','f7ccb0db-2a38-11ee-9e90-a0510b46b473.zip','f7ccb0db-2a38-11ee-9e90-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.6.1.2\",\"modelMatrix\":\"0.951486,0.244177,-0.187223,0,-0.307693,0.755073,-0.578955,0,1.20213e-08,0.608475,0.793573,0,-28.3068,7.7074,-10.0956,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-24 17:44:25.898','2023-07-24 15:44:26.438',NULL),('f7ccc8a0-2a38-11ee-9e90-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_b144ba33-2a36-11ee-9e90-a0510b46b473/occlusion_b147bba1-2a36-11ee-9e90-a0510b46b473/scan_bdee4251-2a38-11ee-9e90-a0510b46b473/f7ccc8a0-2a38-11ee-9e90-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_b144ba33-2a36-11ee-9e90-a0510b46b473_SESS_b147bba1-2a36-11ee-9e90-a0510b46b473_TOSC_bdee4251-2a38-11ee-9e90-a0510b46b473_SNAPS','f7ccc8a0-2a38-11ee-9e90-a0510b46b473.png','f7ccc8a0-2a38-11ee-9e90-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.6.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-24 17:44:25.899','2023-07-24 15:44:26.439',NULL),('f83d1b9e-1bfe-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/8a8cc548-1bf9-11ee-9323-a0510b46b473/session_976f015a-1bf9-11ee-9323-a0510b46b473/occlusion_97713d19-1bf9-11ee-9323-a0510b46b473/scan_967ca6c3-1bfe-11ee-9323-a0510b46b473/f83d1b9e-1bfe-11ee-9323-a0510b46b473.zip','PATIENT_8a8cc548-1bf9-11ee-9323-a0510b46b473_ACT_976f015a-1bf9-11ee-9323-a0510b46b473_SESS_97713d19-1bf9-11ee-9323-a0510b46b473_TOSC_967ca6c3-1bfe-11ee-9323-a0510b46b473_MODEL','f83d1b9e-1bfe-11ee-9323-a0510b46b473.zip','f83d1b9e-1bfe-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.28.1.1.9\",\"modelMatrix\":\"-0.0956151,0.922857,-0.373085,0,-0.995418,-0.0886452,0.0358367,0,-1.20311e-09,0.374802,0.927105,0,-18.231,-27.7681,-5.85674,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-06 15:13:59.546','2023-07-06 13:14:00.459',NULL),('f83d3200-1bfe-11ee-9323-a0510b46b473',11,'/home/scan/.data//2023/11/8a8cc548-1bf9-11ee-9323-a0510b46b473/session_976f015a-1bf9-11ee-9323-a0510b46b473/occlusion_97713d19-1bf9-11ee-9323-a0510b46b473/scan_967ca6c3-1bfe-11ee-9323-a0510b46b473/f83d3200-1bfe-11ee-9323-a0510b46b473.png','PATIENT_8a8cc548-1bf9-11ee-9323-a0510b46b473_ACT_976f015a-1bf9-11ee-9323-a0510b46b473_SESS_97713d19-1bf9-11ee-9323-a0510b46b473_TOSC_967ca6c3-1bfe-11ee-9323-a0510b46b473_SNAPS','f83d3200-1bfe-11ee-9323-a0510b46b473.png','f83d3200-1bfe-11ee-9323-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.28.1.1.9 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-06 15:13:59.546','2023-07-06 13:14:00.462',NULL),('f89afceb-2aea-11ee-97fa-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_8b758c52-2ae7-11ee-97fa-a0510b46b473/occlusion_8b789858-2ae7-11ee-97fa-a0510b46b473/scan_b9c0cb0d-2aea-11ee-97fa-a0510b46b473/f89afceb-2aea-11ee-97fa-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_8b758c52-2ae7-11ee-97fa-a0510b46b473_SESS_8b789858-2ae7-11ee-97fa-a0510b46b473_TOSC_b9c0cb0d-2aea-11ee-97fa-a0510b46b473_MODEL','f89afceb-2aea-11ee-97fa-a0510b46b473.zip','f89afceb-2aea-11ee-97fa-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.9.1.7\",\"modelMatrix\":\"0.878088,0.427023,-0.215899,0,-0.478499,0.783626,-0.396194,0,1.35828e-08,0.4512,0.892423,0,-32.3071,-1.15229,-8.85006,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-25 14:58:37.668','2023-07-25 12:58:38.201',NULL),('f89b1469-2aea-11ee-97fa-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_8b758c52-2ae7-11ee-97fa-a0510b46b473/occlusion_8b789858-2ae7-11ee-97fa-a0510b46b473/scan_b9c0cb0d-2aea-11ee-97fa-a0510b46b473/f89b1469-2aea-11ee-97fa-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_8b758c52-2ae7-11ee-97fa-a0510b46b473_SESS_8b789858-2ae7-11ee-97fa-a0510b46b473_TOSC_b9c0cb0d-2aea-11ee-97fa-a0510b46b473_SNAPS','f89b1469-2aea-11ee-97fa-a0510b46b473.png','f89b1469-2aea-11ee-97fa-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.9.1.7 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-25 14:58:37.669','2023-07-25 12:58:38.203',NULL),('f8c03ff6-1035-11ee-895b-a0510b46b473',11,'/home/scan/.data//2023/11/d75719c6-1032-11ee-895b-a0510b46b473/session_6897acc6-1035-11ee-895b-a0510b46b473/occlusion_689aa1f3-1035-11ee-895b-a0510b46b473/scan_b850467f-1035-11ee-895b-a0510b46b473/f8c03ff6-1035-11ee-895b-a0510b46b473.zip','PATIENT_d75719c6-1032-11ee-895b-a0510b46b473_ACT_6897acc6-1035-11ee-895b-a0510b46b473_SESS_689aa1f3-1035-11ee-895b-a0510b46b473_TOSC_b850467f-1035-11ee-895b-a0510b46b473_MODEL','f8c03ff6-1035-11ee-895b-a0510b46b473.zip','f8c03ff6-1035-11ee-895b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.16.2.1.2\",\"modelMatrix\":\"0.729577,0.659233,-0.182014,0,-0.683899,0.703264,-0.194171,0,-3.37512e-09,0.266142,0.963934,0,-27.9224,-10.0095,-10.0301,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-21 15:17:28.772','2023-06-21 13:17:29.405',NULL),('f8c182af-1035-11ee-895b-a0510b46b473',11,'/home/scan/.data//2023/11/d75719c6-1032-11ee-895b-a0510b46b473/session_6897acc6-1035-11ee-895b-a0510b46b473/occlusion_689aa1f3-1035-11ee-895b-a0510b46b473/scan_b850467f-1035-11ee-895b-a0510b46b473/f8c182af-1035-11ee-895b-a0510b46b473.png','PATIENT_d75719c6-1032-11ee-895b-a0510b46b473_ACT_6897acc6-1035-11ee-895b-a0510b46b473_SESS_689aa1f3-1035-11ee-895b-a0510b46b473_TOSC_b850467f-1035-11ee-895b-a0510b46b473_SNAPS','f8c182af-1035-11ee-895b-a0510b46b473.png','f8c182af-1035-11ee-895b-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.16.2.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-21 15:17:28.780','2023-06-21 13:17:29.414',NULL),('f8cfef55-1a63-11ee-9a4f-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_56e1eee3-1a49-11ee-9a4f-a0510b46b473/occlusion_56e449e9-1a49-11ee-9a4f-a0510b46b473/scan_9934cb4b-1a63-11ee-9a4f-a0510b46b473/f8cfef55-1a63-11ee-9a4f-a0510b46b473.zip','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_56e1eee3-1a49-11ee-9a4f-a0510b46b473_SESS_56e449e9-1a49-11ee-9a4f-a0510b46b473_TOSC_9934cb4b-1a63-11ee-9a4f-a0510b46b473_MODEL','f8cfef55-1a63-11ee-9a4f-a0510b46b473.zip','f8cfef55-1a63-11ee-9a4f-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.1.1.9\",\"modelMatrix\":\"-0.868845,0.492236,-0.053027,0,-0.495084,-0.863847,0.0930594,0,1.13251e-09,0.107107,0.994247,0,14.4525,-29.1191,-10.2016,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-04 14:11:57.352','2023-07-04 12:11:58.225',NULL),('f8d13076-1a63-11ee-9a4f-a0510b46b473',11,'/home/scan/.data//2023/11/4ada0d8c-1a49-11ee-9a4f-a0510b46b473/session_56e1eee3-1a49-11ee-9a4f-a0510b46b473/occlusion_56e449e9-1a49-11ee-9a4f-a0510b46b473/scan_9934cb4b-1a63-11ee-9a4f-a0510b46b473/f8d13076-1a63-11ee-9a4f-a0510b46b473.png','PATIENT_4ada0d8c-1a49-11ee-9a4f-a0510b46b473_ACT_56e1eee3-1a49-11ee-9a4f-a0510b46b473_SESS_56e449e9-1a49-11ee-9a4f-a0510b46b473_TOSC_9934cb4b-1a63-11ee-9a4f-a0510b46b473_SNAPS','f8d13076-1a63-11ee-9a4f-a0510b46b473.png','f8d13076-1a63-11ee-9a4f-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.26.1.1.9 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-04 14:11:57.360','2023-07-04 12:11:58.235',NULL),('f91526e2-e01f-11ed-a285-00d86184ce3d',11,'/home/scan/.data//2023/11/5f27680c-e01a-11ed-b6c2-00d86184ce3d/session_65b85f32-e01a-11ed-b6c2-00d86184ce3d/occlusion_65ba9a94-e01a-11ed-b6c2-00d86184ce3d/scan_c425405a-e01f-11ed-a285-00d86184ce3d/f91526e2-e01f-11ed-a285-00d86184ce3d.zip','PATIENT_5f27680c-e01a-11ed-b6c2-00d86184ce3d_ACT_65b85f32-e01a-11ed-b6c2-00d86184ce3d_SESS_65ba9a94-e01a-11ed-b6c2-00d86184ce3d_BOSC_c425405a-e01f-11ed-a285-00d86184ce3d_MODEL','f91526e2-e01f-11ed-a285-00d86184ce3d.zip','f91526e2-e01f-11ed-a285-00d86184ce3d','{\"displayTitle\":\"Mandibule 1.10.1.1.3\",\"modelMatrix\":\"0.733672,0.666579,-0.1319,0,-0.679504,0.719717,-0.142414,0,-7.96572e-09,0.194112,0.980979,0,-9.53991,-26.9848,-10.997,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 10:39:04.587','2023-04-21 08:39:05.255',NULL),('f9153c70-e01f-11ed-a285-00d86184ce3d',11,'/home/scan/.data//2023/11/5f27680c-e01a-11ed-b6c2-00d86184ce3d/session_65b85f32-e01a-11ed-b6c2-00d86184ce3d/occlusion_65ba9a94-e01a-11ed-b6c2-00d86184ce3d/scan_c425405a-e01f-11ed-a285-00d86184ce3d/f9153c70-e01f-11ed-a285-00d86184ce3d.png','PATIENT_5f27680c-e01a-11ed-b6c2-00d86184ce3d_ACT_65b85f32-e01a-11ed-b6c2-00d86184ce3d_SESS_65ba9a94-e01a-11ed-b6c2-00d86184ce3d_BOSC_c425405a-e01f-11ed-a285-00d86184ce3d_SNAPS','f9153c70-e01f-11ed-a285-00d86184ce3d.png','f9153c70-e01f-11ed-a285-00d86184ce3d','{\"displayTitle\":\"Mandibule 1.10.1.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 10:39:04.588','2023-04-21 08:39:05.258',NULL),('f9c7a287-2ac3-11ee-80c8-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_3a881645-2abf-11ee-80c8-a0510b46b473/occlusion_3a8b3537-2abf-11ee-80c8-a0510b46b473/scan_db694c3f-2ac3-11ee-80c8-a0510b46b473/f9c7a287-2ac3-11ee-80c8-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_3a881645-2abf-11ee-80c8-a0510b46b473_SESS_3a8b3537-2abf-11ee-80c8-a0510b46b473_TOSC_db694c3f-2ac3-11ee-80c8-a0510b46b473_MODEL','f9c7a287-2ac3-11ee-80c8-a0510b46b473.zip','f9c7a287-2ac3-11ee-80c8-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.7.1.9\",\"modelMatrix\":\"-0.323851,0.938556,-0.119307,0,-0.946108,-0.321266,0.0408385,0,1.18661e-09,0.126103,0.992017,0,-5.45202,-29.2468,-7.21163,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-25 10:19:29.266','2023-07-25 08:19:29.456',NULL),('f9c7b7eb-2ac3-11ee-80c8-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_3a881645-2abf-11ee-80c8-a0510b46b473/occlusion_3a8b3537-2abf-11ee-80c8-a0510b46b473/scan_db694c3f-2ac3-11ee-80c8-a0510b46b473/f9c7b7eb-2ac3-11ee-80c8-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_3a881645-2abf-11ee-80c8-a0510b46b473_SESS_3a8b3537-2abf-11ee-80c8-a0510b46b473_TOSC_db694c3f-2ac3-11ee-80c8-a0510b46b473_SNAPS','f9c7b7eb-2ac3-11ee-80c8-a0510b46b473.png','f9c7b7eb-2ac3-11ee-80c8-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.7.1.9 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-25 10:19:29.266','2023-07-25 08:19:29.464',NULL),('fa6ee480-15b7-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/142e7037-15b6-11ee-b3b1-00d86184ce3d/session_1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d/occlusion_1ed7780a-15b6-11ee-b3b1-00d86184ce3d/scan_aa8e949a-15b7-11ee-b3b1-00d86184ce3d/fa6ee480-15b7-11ee-b3b1-00d86184ce3d.zip','PATIENT_142e7037-15b6-11ee-b3b1-00d86184ce3d_ACT_1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d_SESS_1ed7780a-15b6-11ee-b3b1-00d86184ce3d_TOSC_aa8e949a-15b7-11ee-b3b1-00d86184ce3d_MODEL','fa6ee480-15b7-11ee-b3b1-00d86184ce3d.zip','fa6ee480-15b7-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.25.1.1.5\",\"modelMatrix\":\"0.0738251,0.976294,-0.203468,0,-0.997271,0.0722722,-0.0150622,0,-1.36799e-09,0.204025,0.978966,0,-24.4493,-22.8712,-8.61102,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-28 15:30:41.983','2023-06-28 13:30:42.809',NULL),('fa6efc1e-15b7-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/142e7037-15b6-11ee-b3b1-00d86184ce3d/session_1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d/occlusion_1ed7780a-15b6-11ee-b3b1-00d86184ce3d/scan_aa8e949a-15b7-11ee-b3b1-00d86184ce3d/fa6efc1e-15b7-11ee-b3b1-00d86184ce3d.png','PATIENT_142e7037-15b6-11ee-b3b1-00d86184ce3d_ACT_1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d_SESS_1ed7780a-15b6-11ee-b3b1-00d86184ce3d_TOSC_aa8e949a-15b7-11ee-b3b1-00d86184ce3d_SNAPS','fa6efc1e-15b7-11ee-b3b1-00d86184ce3d.png','fa6efc1e-15b7-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.25.1.1.5 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-28 15:30:41.984','2023-06-28 13:30:42.809',NULL),('faa8ef4b-de9b-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/35e16a68-de95-11ed-9cc3-00d86184ce3d/session_450c29ef-de95-11ed-9cc3-00d86184ce3d/occlusion_450efda8-de95-11ed-9cc3-00d86184ce3d/scan_967f7503-de9b-11ed-9cc3-00d86184ce3d/faa8ef4b-de9b-11ed-9cc3-00d86184ce3d.zip','PATIENT_35e16a68-de95-11ed-9cc3-00d86184ce3d_ACT_450c29ef-de95-11ed-9cc3-00d86184ce3d_SESS_450efda8-de95-11ed-9cc3-00d86184ce3d_TOSC_967f7503-de9b-11ed-9cc3-00d86184ce3d_MODEL','faa8ef4b-de9b-11ed-9cc3-00d86184ce3d.zip','faa8ef4b-de9b-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.4.1.1.8\",\"modelMatrix\":\"0.314807,0.90852,-0.27475,0,-0.949156,0.301329,-0.0911266,0,-1.61858e-09,0.289468,0.957188,0,-24.8137,-18.5823,-6.40282,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-19 12:21:42.502','2023-04-19 10:21:43.626',NULL),('faa9077a-de9b-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/35e16a68-de95-11ed-9cc3-00d86184ce3d/session_450c29ef-de95-11ed-9cc3-00d86184ce3d/occlusion_450efda8-de95-11ed-9cc3-00d86184ce3d/scan_967f7503-de9b-11ed-9cc3-00d86184ce3d/faa9077a-de9b-11ed-9cc3-00d86184ce3d.png','PATIENT_35e16a68-de95-11ed-9cc3-00d86184ce3d_ACT_450c29ef-de95-11ed-9cc3-00d86184ce3d_SESS_450efda8-de95-11ed-9cc3-00d86184ce3d_TOSC_967f7503-de9b-11ed-9cc3-00d86184ce3d_SNAPS','faa9077a-de9b-11ed-9cc3-00d86184ce3d.png','faa9077a-de9b-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.4.1.1.8 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-19 12:21:42.503','2023-04-19 10:21:43.627',NULL),('fd0e859a-2ac4-11ee-80c8-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_3a881645-2abf-11ee-80c8-a0510b46b473/occlusion_3a8b3537-2abf-11ee-80c8-a0510b46b473/scan_c12d924b-2ac4-11ee-80c8-a0510b46b473/fd0e859a-2ac4-11ee-80c8-a0510b46b473.zip','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_3a881645-2abf-11ee-80c8-a0510b46b473_SESS_3a8b3537-2abf-11ee-80c8-a0510b46b473_TOSC_c12d924b-2ac4-11ee-80c8-a0510b46b473_MODEL','fd0e859a-2ac4-11ee-80c8-a0510b46b473.zip','fd0e859a-2ac4-11ee-80c8-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.7.1.13\",\"modelMatrix\":\"0.75267,0.589415,-0.293392,0,-0.658399,0.673809,-0.3354,0,-2.58187e-08,0.445615,0.895225,0,-32.2062,-4.84684,-6.7735,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-25 10:26:44.260','2023-07-25 08:26:44.829',NULL),('fd0e9d04-2ac4-11ee-80c8-a0510b46b473',11,'/home/scan/.data//2023/11/fef8307a-1c9f-11ee-84c4-a0510b46b473/session_3a881645-2abf-11ee-80c8-a0510b46b473/occlusion_3a8b3537-2abf-11ee-80c8-a0510b46b473/scan_c12d924b-2ac4-11ee-80c8-a0510b46b473/fd0e9d04-2ac4-11ee-80c8-a0510b46b473.png','PATIENT_fef8307a-1c9f-11ee-84c4-a0510b46b473_ACT_3a881645-2abf-11ee-80c8-a0510b46b473_SESS_3a8b3537-2abf-11ee-80c8-a0510b46b473_TOSC_c12d924b-2ac4-11ee-80c8-a0510b46b473_SNAPS','fd0e9d04-2ac4-11ee-80c8-a0510b46b473.png','fd0e9d04-2ac4-11ee-80c8-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.30.7.1.13 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-25 10:26:44.261','2023-07-25 08:26:44.829',NULL),('fdb32eb9-1a78-11ee-8124-a0510b46b473',11,'/home/scan/.data//2023/11/61e16a70-1a76-11ee-8124-a0510b46b473/session_c8578c2f-1a77-11ee-8124-a0510b46b473/occlusion_c85af2e9-1a77-11ee-8124-a0510b46b473/scan_9d1b0e98-1a78-11ee-8124-a0510b46b473/fdb32eb9-1a78-11ee-8124-a0510b46b473.zip','PATIENT_61e16a70-1a76-11ee-8124-a0510b46b473_ACT_c8578c2f-1a77-11ee-8124-a0510b46b473_SESS_c85af2e9-1a77-11ee-8124-a0510b46b473_TOSC_9d1b0e98-1a78-11ee-8124-a0510b46b473_MODEL','fdb32eb9-1a78-11ee-8124-a0510b46b473.zip','fdb32eb9-1a78-11ee-8124-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.27.2.1.3\",\"modelMatrix\":\"0.643014,0.760148,-0.0933159,0,-0.765854,0.638223,-0.0783484,0,-4.0468e-09,0.121846,0.992549,0,-30.5436,-16.1632,-13.0124,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-04 16:42:24.984','2023-07-04 14:42:25.647',NULL),('fdb34556-1a78-11ee-8124-a0510b46b473',11,'/home/scan/.data//2023/11/61e16a70-1a76-11ee-8124-a0510b46b473/session_c8578c2f-1a77-11ee-8124-a0510b46b473/occlusion_c85af2e9-1a77-11ee-8124-a0510b46b473/scan_9d1b0e98-1a78-11ee-8124-a0510b46b473/fdb34556-1a78-11ee-8124-a0510b46b473.png','PATIENT_61e16a70-1a76-11ee-8124-a0510b46b473_ACT_c8578c2f-1a77-11ee-8124-a0510b46b473_SESS_c85af2e9-1a77-11ee-8124-a0510b46b473_TOSC_9d1b0e98-1a78-11ee-8124-a0510b46b473_SNAPS','fdb34556-1a78-11ee-8124-a0510b46b473.png','fdb34556-1a78-11ee-8124-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.27.2.1.3 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-04 16:42:24.984','2023-07-04 14:42:25.647',NULL),('fdd89b6e-256f-11ee-91d6-a0510b46b473',11,'/home/scan/.data//2023/11/49f1e276-256f-11ee-91d6-a0510b46b473/session_5c74c40a-256f-11ee-91d6-a0510b46b473/occlusion_5c77122f-256f-11ee-91d6-a0510b46b473/scan_a2727b51-256f-11ee-91d6-a0510b46b473/fdd89b6e-256f-11ee-91d6-a0510b46b473.zip','PATIENT_49f1e276-256f-11ee-91d6-a0510b46b473_ACT_5c74c40a-256f-11ee-91d6-a0510b46b473_SESS_5c77122f-256f-11ee-91d6-a0510b46b473_TOSC_a2727b51-256f-11ee-91d6-a0510b46b473_MODEL','fdd89b6e-256f-11ee-91d6-a0510b46b473.zip','fdd89b6e-256f-11ee-91d6-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.33.1.1.2\",\"modelMatrix\":\"0.984228,-0.175873,0.0190671,0,0.176904,0.978495,-0.106083,0,1.00068e-09,0.107783,0.994175,0,-17.0119,19.1304,-16.2234,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-07-18 15:35:42.549','2023-07-18 13:35:43.254',NULL),('fdd8ae4d-256f-11ee-91d6-a0510b46b473',11,'/home/scan/.data//2023/11/49f1e276-256f-11ee-91d6-a0510b46b473/session_5c74c40a-256f-11ee-91d6-a0510b46b473/occlusion_5c77122f-256f-11ee-91d6-a0510b46b473/scan_a2727b51-256f-11ee-91d6-a0510b46b473/fdd8ae4d-256f-11ee-91d6-a0510b46b473.png','PATIENT_49f1e276-256f-11ee-91d6-a0510b46b473_ACT_5c74c40a-256f-11ee-91d6-a0510b46b473_SESS_5c77122f-256f-11ee-91d6-a0510b46b473_TOSC_a2727b51-256f-11ee-91d6-a0510b46b473_SNAPS','fdd8ae4d-256f-11ee-91d6-a0510b46b473.png','fdd8ae4d-256f-11ee-91d6-a0510b46b473','{\"displayTitle\":\"Maxillaire 1.33.1.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-07-18 15:35:42.549','2023-07-18 13:35:43.263',NULL),('fdf4d8d5-deb2-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/cf3f0588-deb2-11ed-9cc3-00d86184ce3d/session_d7750b8d-deb2-11ed-9cc3-00d86184ce3d/occlusion_d7775a50-deb2-11ed-9cc3-00d86184ce3d/scan_d82e9636-deb2-11ed-9cc3-00d86184ce3d/fdf4d8d5-deb2-11ed-9cc3-00d86184ce3d.zip','PATIENT_cf3f0588-deb2-11ed-9cc3-00d86184ce3d_ACT_d7750b8d-deb2-11ed-9cc3-00d86184ce3d_SESS_d7775a50-deb2-11ed-9cc3-00d86184ce3d_TOSC_d82e9636-deb2-11ed-9cc3-00d86184ce3d_MODEL','fdf4d8d5-deb2-11ed-9cc3-00d86184ce3d.zip','fdf4d8d5-deb2-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.6.1.1.1\",\"modelMatrix\":\"0.999883,-0.015286,0.000782473,0,0.0153061,0.998576,-0.0511158,0,-4.64906e-12,0.0511218,0.998692,0,-20.0618,17.0167,-14.1237,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-19 15:06:26.458','2023-04-19 13:06:26.789',NULL),('fdf4efee-deb2-11ed-9cc3-00d86184ce3d',11,'/home/scan/.data//2023/11/cf3f0588-deb2-11ed-9cc3-00d86184ce3d/session_d7750b8d-deb2-11ed-9cc3-00d86184ce3d/occlusion_d7775a50-deb2-11ed-9cc3-00d86184ce3d/scan_d82e9636-deb2-11ed-9cc3-00d86184ce3d/fdf4efee-deb2-11ed-9cc3-00d86184ce3d.png','PATIENT_cf3f0588-deb2-11ed-9cc3-00d86184ce3d_ACT_d7750b8d-deb2-11ed-9cc3-00d86184ce3d_SESS_d7775a50-deb2-11ed-9cc3-00d86184ce3d_TOSC_d82e9636-deb2-11ed-9cc3-00d86184ce3d_SNAPS','fdf4efee-deb2-11ed-9cc3-00d86184ce3d.png','fdf4efee-deb2-11ed-9cc3-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.6.1.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-19 15:06:26.458','2023-04-19 13:06:26.789',NULL),('ff432d5f-e00f-11ed-b6c2-00d86184ce3d',11,'/home/scan/.data//2023/11/e0d449f3-dde9-11ed-aa56-00d86184ce3d/session_858fcc60-de94-11ed-9cc3-00d86184ce3d/occlusion_85925fd9-de94-11ed-9cc3-00d86184ce3d/scan_bcc15c94-e00f-11ed-b6c2-00d86184ce3d/ff432d5f-e00f-11ed-b6c2-00d86184ce3d.zip','PATIENT_e0d449f3-dde9-11ed-aa56-00d86184ce3d_ACT_858fcc60-de94-11ed-9cc3-00d86184ce3d_SESS_85925fd9-de94-11ed-9cc3-00d86184ce3d_TOSC_bcc15c94-e00f-11ed-b6c2-00d86184ce3d_MODEL','ff432d5f-e00f-11ed-b6c2-00d86184ce3d.zip','ff432d5f-e00f-11ed-b6c2-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.2.1.1.7\",\"modelMatrix\":\"0.413942,0.855637,-0.310705,0,-0.910303,0.389084,-0.141287,0,-8.40622e-10,0.34132,0.939947,0,-22.5296,-20.4204,-6.82331,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-21 08:44:43.007','2023-04-21 06:44:43.646',NULL),('ff4344cf-e00f-11ed-b6c2-00d86184ce3d',11,'/home/scan/.data//2023/11/e0d449f3-dde9-11ed-aa56-00d86184ce3d/session_858fcc60-de94-11ed-9cc3-00d86184ce3d/occlusion_85925fd9-de94-11ed-9cc3-00d86184ce3d/scan_bcc15c94-e00f-11ed-b6c2-00d86184ce3d/ff4344cf-e00f-11ed-b6c2-00d86184ce3d.png','PATIENT_e0d449f3-dde9-11ed-aa56-00d86184ce3d_ACT_858fcc60-de94-11ed-9cc3-00d86184ce3d_SESS_85925fd9-de94-11ed-9cc3-00d86184ce3d_TOSC_bcc15c94-e00f-11ed-b6c2-00d86184ce3d_SNAPS','ff4344cf-e00f-11ed-b6c2-00d86184ce3d.png','ff4344cf-e00f-11ed-b6c2-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.2.1.1.7 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-21 08:44:43.008','2023-04-21 06:44:43.647',NULL),('ff44f1b2-e350-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/6175c1d5-e350-11ed-8c5e-00d86184ce3d/session_71ba03b6-e350-11ed-8c5e-00d86184ce3d/occlusion_71bbf096-e350-11ed-8c5e-00d86184ce3d/scan_c21e15d4-e350-11ed-8c5e-00d86184ce3d/ff44f1b2-e350-11ed-8c5e-00d86184ce3d.zip','PATIENT_6175c1d5-e350-11ed-8c5e-00d86184ce3d_ACT_71ba03b6-e350-11ed-8c5e-00d86184ce3d_SESS_71bbf096-e350-11ed-8c5e-00d86184ce3d_TOSC_c21e15d4-e350-11ed-8c5e-00d86184ce3d_MODEL','ff44f1b2-e350-11ed-8c5e-00d86184ce3d.zip','ff44f1b2-e350-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.13.1.1.2\",\"modelMatrix\":\"0.906815,0.399018,-0.135909,0,-0.421529,0.858388,-0.292375,0,-7.04146e-09,0.32242,0.946597,0,-30.6256,11.64,-10.4876,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-25 12:07:33.795','2023-04-25 10:07:34.610',NULL),('ff450dbb-e350-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/6175c1d5-e350-11ed-8c5e-00d86184ce3d/session_71ba03b6-e350-11ed-8c5e-00d86184ce3d/occlusion_71bbf096-e350-11ed-8c5e-00d86184ce3d/scan_c21e15d4-e350-11ed-8c5e-00d86184ce3d/ff450dbb-e350-11ed-8c5e-00d86184ce3d.png','PATIENT_6175c1d5-e350-11ed-8c5e-00d86184ce3d_ACT_71ba03b6-e350-11ed-8c5e-00d86184ce3d_SESS_71bbf096-e350-11ed-8c5e-00d86184ce3d_TOSC_c21e15d4-e350-11ed-8c5e-00d86184ce3d_SNAPS','ff450dbb-e350-11ed-8c5e-00d86184ce3d.png','ff450dbb-e350-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.13.1.1.2 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-25 12:07:33.795','2023-04-25 10:07:34.610',NULL),('ff6aa1af-e349-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/971e14b0-e348-11ed-8c5e-00d86184ce3d/session_a0fbda94-e348-11ed-8c5e-00d86184ce3d/occlusion_a0febadb-e348-11ed-8c5e-00d86184ce3d/scan_ad42e864-e349-11ed-8c5e-00d86184ce3d/ff6aa1af-e349-11ed-8c5e-00d86184ce3d.zip','PATIENT_971e14b0-e348-11ed-8c5e-00d86184ce3d_ACT_a0fbda94-e348-11ed-8c5e-00d86184ce3d_SESS_a0febadb-e348-11ed-8c5e-00d86184ce3d_TOSC_ad42e864-e349-11ed-8c5e-00d86184ce3d_MODEL','ff6aa1af-e349-11ed-8c5e-00d86184ce3d.zip','ff6aa1af-e349-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.12.1.1.4\",\"modelMatrix\":\"0.124894,0.936614,-0.327345,0,-0.99217,0.117901,-0.0412062,0,-1.1608e-10,0.329929,0.944006,0,-25.753,-21.34,-5.2895,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-04-25 11:17:27.565','2023-04-25 09:17:28.436',NULL),('ff6b17df-e349-11ed-8c5e-00d86184ce3d',11,'/home/scan/.data//2023/11/971e14b0-e348-11ed-8c5e-00d86184ce3d/session_a0fbda94-e348-11ed-8c5e-00d86184ce3d/occlusion_a0febadb-e348-11ed-8c5e-00d86184ce3d/scan_ad42e864-e349-11ed-8c5e-00d86184ce3d/ff6b17df-e349-11ed-8c5e-00d86184ce3d.png','PATIENT_971e14b0-e348-11ed-8c5e-00d86184ce3d_ACT_a0fbda94-e348-11ed-8c5e-00d86184ce3d_SESS_a0febadb-e348-11ed-8c5e-00d86184ce3d_TOSC_ad42e864-e349-11ed-8c5e-00d86184ce3d_SNAPS','ff6b17df-e349-11ed-8c5e-00d86184ce3d.png','ff6b17df-e349-11ed-8c5e-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.12.1.1.4 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-04-25 11:17:27.568','2023-04-25 09:17:28.436',NULL),('ffae2596-15ba-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/142e7037-15b6-11ee-b3b1-00d86184ce3d/session_c41888b6-15ba-11ee-b3b1-00d86184ce3d/occlusion_c41a4d8e-15ba-11ee-b3b1-00d86184ce3d/scan_c52fcde3-15ba-11ee-b3b1-00d86184ce3d/ffae2596-15ba-11ee-b3b1-00d86184ce3d.zip','PATIENT_142e7037-15b6-11ee-b3b1-00d86184ce3d_ACT_c41888b6-15ba-11ee-b3b1-00d86184ce3d_SESS_c41a4d8e-15ba-11ee-b3b1-00d86184ce3d_TOSC_c52fcde3-15ba-11ee-b3b1-00d86184ce3d_MODEL','ffae2596-15ba-11ee-b3b1-00d86184ce3d.zip','ffae2596-15ba-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.25.2.1.1\",\"modelMatrix\":\"0.688463,0.41905,-0.591959,0,-0.725271,0.397783,-0.561917,0,2.00159e-09,0.81619,0.577783,0,-25.5418,8.92083,-10.0335,1\",\"scanBodies\":[]}','ZIP',0,'CREATED',0,NULL,'2023-06-28 15:52:19.276','2023-06-28 13:52:19.742',NULL),('ffae3e4e-15ba-11ee-b3b1-00d86184ce3d',11,'/home/scan/.data//2023/11/142e7037-15b6-11ee-b3b1-00d86184ce3d/session_c41888b6-15ba-11ee-b3b1-00d86184ce3d/occlusion_c41a4d8e-15ba-11ee-b3b1-00d86184ce3d/scan_c52fcde3-15ba-11ee-b3b1-00d86184ce3d/ffae3e4e-15ba-11ee-b3b1-00d86184ce3d.png','PATIENT_142e7037-15b6-11ee-b3b1-00d86184ce3d_ACT_c41888b6-15ba-11ee-b3b1-00d86184ce3d_SESS_c41a4d8e-15ba-11ee-b3b1-00d86184ce3d_TOSC_c52fcde3-15ba-11ee-b3b1-00d86184ce3d_SNAPS','ffae3e4e-15ba-11ee-b3b1-00d86184ce3d.png','ffae3e4e-15ba-11ee-b3b1-00d86184ce3d','{\"displayTitle\":\"Maxillaire 1.25.2.1.1 Snapshot\"}','PNG',0,'CREATED',0,NULL,'2023-06-28 15:52:19.277','2023-06-28 13:52:19.743',NULL);
/*!40000 ALTER TABLE `File` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `MessageStatus`
--

DROP TABLE IF EXISTS `MessageStatus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `MessageStatus` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `sentMessageId` varchar(36) NOT NULL,
  `contactId` varchar(36) NOT NULL,
  `status` enum('UNDELIVERED','DELIVERED','TRANSMITTED') NOT NULL DEFAULT 'UNDELIVERED',
  `bcc` tinyint(1) NOT NULL DEFAULT '0',
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  PRIMARY KEY (`sentMessageId`,`contactId`),
  KEY `ownerId` (`ownerId`),
  KEY `contactId` (`contactId`),
  CONSTRAINT `MessageStatus_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `MessageStatus_ibfk_2` FOREIGN KEY (`sentMessageId`) REFERENCES `SentMessage` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `MessageStatus_ibfk_3` FOREIGN KEY (`contactId`) REFERENCES `Contact` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `MessageStatus`
--

LOCK TABLES `MessageStatus` WRITE;
/*!40000 ALTER TABLE `MessageStatus` DISABLE KEYS */;
/*!40000 ALTER TABLE `MessageStatus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Occlusion`
--

DROP TABLE IF EXISTS `Occlusion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Occlusion` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `sessionId` varchar(36) DEFAULT NULL,
  `occlusionType` enum('UNKNOWN','HEMI_ARCADE_POSTERIEUR_DROIT','HEMI_ARCADE_POSTERIEUR_GAUCHE','HEMI_ARCADE_ANTERIEUR','ARCADE_COMPLETE_ANTERIEUR','ARCADE_COMPLETE') DEFAULT 'UNKNOWN',
  `displayId` mediumint unsigned DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `comments` text,
  `topScanId` varchar(36) DEFAULT NULL,
  `bottomScanId` varchar(36) DEFAULT NULL,
  `anteriorBiteScanId` varchar(36) DEFAULT NULL,
  `rightBiteScanId` varchar(36) DEFAULT NULL,
  `leftBiteScanId` varchar(36) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `sessionId` (`sessionId`),
  KEY `topScanId` (`topScanId`),
  KEY `bottomScanId` (`bottomScanId`),
  KEY `anteriorBiteScanId` (`anteriorBiteScanId`),
  KEY `rightBiteScanId` (`rightBiteScanId`),
  KEY `leftBiteScanId` (`leftBiteScanId`),
  CONSTRAINT `Occlusion_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_2` FOREIGN KEY (`sessionId`) REFERENCES `Session` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_3` FOREIGN KEY (`topScanId`) REFERENCES `Scan` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_4` FOREIGN KEY (`bottomScanId`) REFERENCES `Scan` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_5` FOREIGN KEY (`anteriorBiteScanId`) REFERENCES `Scan` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_6` FOREIGN KEY (`rightBiteScanId`) REFERENCES `Scan` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_7` FOREIGN KEY (`leftBiteScanId`) REFERENCES `Scan` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Occlusion`
--

LOCK TABLES `Occlusion` WRITE;
/*!40000 ALTER TABLE `Occlusion` DISABLE KEYS */;
/*!40000 ALTER TABLE `Occlusion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `OcclusionFile`
--

DROP TABLE IF EXISTS `OcclusionFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `OcclusionFile` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `occlusionId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('RESULT','MANDIBLE','MAXILLARY','MANDIBLE_SB','MAXILLARY_SB','MANDIBLE_PRE','MAXILLARY_PRE','LIFI','LIFIMETA','SNAPSHOT','SCREENSHOT') DEFAULT 'RESULT',
  PRIMARY KEY (`occlusionId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `OcclusionFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `OcclusionFile_ibfk_2` FOREIGN KEY (`occlusionId`) REFERENCES `Occlusion` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `OcclusionFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `OcclusionFile`
--

LOCK TABLES `OcclusionFile` WRITE;
/*!40000 ALTER TABLE `OcclusionFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `OcclusionFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Office`
--

DROP TABLE IF EXISTS `Office`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Office` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `mainPhone` varchar(45) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `cityName` varchar(255) DEFAULT NULL,
  `cityZip` varchar(25) DEFAULT NULL,
  `address` text,
  `country` varchar(75) DEFAULT NULL,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  CONSTRAINT `Office_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Office`
--

LOCK TABLES `Office` WRITE;
/*!40000 ALTER TABLE `Office` DISABLE KEYS */;
INSERT INTO `Office` VALUES ('2b879809-8839-11ec-89bc-2e174fce41cd',1,'0606060606','Biotech-Dental','','Toulouse','31100','Route du test','France',NULL,'2022-09-01 14:34:37.000','2023-04-17 08:59:51.185','2023-04-17 10:59:51.185'),('385e5f12-8c3d-4fc2-8561-ca3184d9c754',11,'753179074','scan','','labege','31000','Lebege','France',NULL,'2022-12-08 10:16:10.000','2023-04-17 08:59:50.843','2023-04-17 10:59:50.843');
/*!40000 ALTER TABLE `Office` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PersonInfo`
--

DROP TABLE IF EXISTS `PersonInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PersonInfo` (
  `uuid` varchar(36) NOT NULL,
  `firstname` varchar(64) NOT NULL,
  `lastname` varchar(64) NOT NULL,
  `email` varchar(255) NOT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PersonInfo`
--

LOCK TABLES `PersonInfo` WRITE;
/*!40000 ALTER TABLE `PersonInfo` DISABLE KEYS */;
INSERT INTO `PersonInfo` VALUES ('4114e703-8838-11ec-89bc-2e174fce41cd','Biotech-Dental','LABORATOIRE','lab@biotech-dental.pro','2023-04-17 08:59:51.158','2023-04-17 10:59:51.199'),('448eb16d-3d1a-4829-bb08-6d5e73aae89b','Ilisio','Viana','ilisio.viana@scan4all.fr','2023-04-17 08:59:50.827','2023-04-17 10:59:51.141');
/*!40000 ALTER TABLE `PersonInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PhoneInfo`
--

DROP TABLE IF EXISTS `PhoneInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PhoneInfo` (
  `uuid` varchar(36) NOT NULL,
  `phone` varchar(45) DEFAULT NULL,
  `cellular` varchar(45) DEFAULT NULL,
  `fax` varchar(45) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PhoneInfo`
--

LOCK TABLES `PhoneInfo` WRITE;
/*!40000 ALTER TABLE `PhoneInfo` DISABLE KEYS */;
INSERT INTO `PhoneInfo` VALUES ('178f2329-373e-437b-8f49-8030371a2c1d','753179074','','','2023-04-17 08:59:50.828','2023-04-17 10:59:51.141'),('47ead308-8838-11ec-89bc-2e174fce41cd','0606060606','','','2023-04-17 08:59:51.159','2023-04-17 10:59:51.199');
/*!40000 ALTER TABLE `PhoneInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Professional`
--

DROP TABLE IF EXISTS `Professional`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Professional` (
  `uuid` varchar(36) NOT NULL,
  `id` mediumint unsigned NOT NULL,
  `credentialsId` varchar(36) DEFAULT NULL,
  `personInfoId` varchar(36) NOT NULL,
  `phoneInfoId` varchar(36) NOT NULL,
  `addressInfoId` varchar(36) NOT NULL,
  `configId` mediumint unsigned DEFAULT NULL,
  `syncInfoId` mediumint unsigned DEFAULT NULL,
  `surgeryName` varchar(255) DEFAULT NULL,
  `comments` text,
  `type` enum('UNDEFINED','PROTHESIST','DENTIST','DEMO','OTHER') NOT NULL DEFAULT 'UNDEFINED',
  `limitedContactId` varchar(36) DEFAULT NULL,
  `directoryVisible` tinyint(1) NOT NULL DEFAULT '1',
  `statusGalaxy` tinyint(1) DEFAULT '0',
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  UNIQUE KEY `personInfoId` (`personInfoId`),
  UNIQUE KEY `phoneInfoId` (`phoneInfoId`),
  UNIQUE KEY `addressInfoId` (`addressInfoId`),
  UNIQUE KEY `credentialsId` (`credentialsId`),
  KEY `syncInfoId` (`syncInfoId`,`id`),
  KEY `configId` (`configId`,`id`),
  CONSTRAINT `Professional_ibfk_1` FOREIGN KEY (`credentialsId`) REFERENCES `Credentials` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_2` FOREIGN KEY (`personInfoId`) REFERENCES `PersonInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_3` FOREIGN KEY (`phoneInfoId`) REFERENCES `PhoneInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_4` FOREIGN KEY (`addressInfoId`) REFERENCES `AddressInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_5` FOREIGN KEY (`syncInfoId`, `id`) REFERENCES `SyncInfo` (`id`, `ownerId`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_6` FOREIGN KEY (`configId`, `id`) REFERENCES `Config` (`id`, `ownerId`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Professional`
--

LOCK TABLES `Professional` WRITE;
/*!40000 ALTER TABLE `Professional` DISABLE KEYS */;
INSERT INTO `Professional` VALUES ('71b743e8-8838-11ec-89bc-2e174fce41cd',1,'2e995095-88b2-11ec-89bc-2e174fce41cd','4114e703-8838-11ec-89bc-2e174fce41cd','47ead308-8838-11ec-89bc-2e174fce41cd','4caacc66-8838-11ec-89bc-2e174fce41cd',1,1,'','','PROTHESIST',NULL,1,0,NULL,'2022-09-01 14:34:37.000','2023-04-17 08:59:51.162','2023-04-17 10:59:51.199'),('cd586b7f-bd29-4792-9c08-6cd1ba1a6424',11,'c6874010-7819-4ad2-8eba-52219ee74012','448eb16d-3d1a-4829-bb08-6d5e73aae89b','178f2329-373e-437b-8f49-8030371a2c1d','1fd355d2-43be-4ef9-a9e2-65df5d36a899',1,1,'','','DENTIST',NULL,1,0,NULL,'2022-12-08 10:16:10.000','2023-04-17 08:59:51.124','2023-04-17 10:59:51.141');
/*!40000 ALTER TABLE `Professional` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProfessionalEnvInfos`
--

DROP TABLE IF EXISTS `ProfessionalEnvInfos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProfessionalEnvInfos` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `accessCode` varchar(45) DEFAULT NULL,
  `status` enum('CREATED','CONFIRMED','BLOCKED') NOT NULL DEFAULT 'CREATED',
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`ownerId`),
  CONSTRAINT `ProfessionalEnvInfos_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProfessionalEnvInfos`
--

LOCK TABLES `ProfessionalEnvInfos` WRITE;
/*!40000 ALTER TABLE `ProfessionalEnvInfos` DISABLE KEYS */;
INSERT INTO `ProfessionalEnvInfos` VALUES (1,'','CONFIRMED','2023-04-17 08:59:51.172','2023-04-17 10:59:51.172'),(11,'','CONFIRMED','2023-04-17 08:59:50.842','2023-04-17 10:59:50.842');
/*!40000 ALTER TABLE `ProfessionalEnvInfos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProfessionalPatient`
--

DROP TABLE IF EXISTS `ProfessionalPatient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProfessionalPatient` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `patientId` varchar(36) NOT NULL,
  `officeId` varchar(36) DEFAULT NULL,
  `enablePatientSharing` tinyint(1) DEFAULT '0',
  `pinned` tinyint(1) NOT NULL DEFAULT '0',
  `theme` enum('NONE','ADULT','BOY','GIRL','BABY') DEFAULT 'NONE',
  PRIMARY KEY (`ownerId`,`patientId`),
  KEY `patientId` (`patientId`),
  KEY `officeId` (`officeId`),
  CONSTRAINT `ProfessionalPatient_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ProfessionalPatient_ibfk_2` FOREIGN KEY (`patientId`) REFERENCES `wow_patient`.`Patient` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ProfessionalPatient_ibfk_3` FOREIGN KEY (`officeId`) REFERENCES `Office` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProfessionalPatient`
--

LOCK TABLES `ProfessionalPatient` WRITE;
/*!40000 ALTER TABLE `ProfessionalPatient` DISABLE KEYS */;
INSERT INTO `ProfessionalPatient` VALUES (11,'142e7037-15b6-11ee-b3b1-00d86184ce3d','385e5f12-8c3d-4fc2-8561-ca3184d9c754',0,0,'NONE'),(11,'2ff330cd-10e1-11ee-b636-a0510b46b473','385e5f12-8c3d-4fc2-8561-ca3184d9c754',0,0,'NONE'),(11,'35e16a68-de95-11ed-9cc3-00d86184ce3d','385e5f12-8c3d-4fc2-8561-ca3184d9c754',0,0,'NONE'),(11,'4051490b-1404-11ee-91d8-a0510b46b473','385e5f12-8c3d-4fc2-8561-ca3184d9c754',0,0,'NONE'),(11,'4375c5f1-1cad-11ee-997b-a0510b46b473','385e5f12-8c3d-4fc2-8561-ca3184d9c754',0,0,'NONE'),(11,'49f1e276-256f-11ee-91d6-a0510b46b473','385e5f12-8c3d-4fc2-8561-ca3184d9c754',0,0,'NONE'),(11,'4ada0d8c-1a49-11ee-9a4f-a0510b46b473','385e5f12-8c3d-4fc2-8561-ca3184d9c754',1,0,'NONE'),(11,'4baca484-2aeb-11ee-97fa-a0510b46b473','385e5f12-8c3d-4fc2-8561-ca3184d9c754',0,0,'NONE'),(11,'53d7979d-261f-11ee-8042-a0510b46b473','385e5f12-8c3d-4fc2-8561-ca3184d9c754',0,0,'NONE'),(11,'59af3050-dcfe-11ed-8097-00d86184ce3d','385e5f12-8c3d-4fc2-8561-ca3184d9c754',0,0,'ADULT'),(11,'5f27680c-e01a-11ed-b6c2-00d86184ce3d','385e5f12-8c3d-4fc2-8561-ca3184d9c754',0,0,'ADULT'),(11,'6175c1d5-e350-11ed-8c5e-00d86184ce3d','385e5f12-8c3d-4fc2-8561-ca3184d9c754',0,0,'NONE'),(11,'61e16a70-1a76-11ee-8124-a0510b46b473','385e5f12-8c3d-4fc2-8561-ca3184d9c754',0,0,'NONE'),(11,'634153bc-1587-11ee-b3b1-00d86184ce3d','385e5f12-8c3d-4fc2-8561-ca3184d9c754',0,0,'NONE'),(11,'6a143ccb-1fe8-11ee-b7d5-a0510b46b473','385e5f12-8c3d-4fc2-8561-ca3184d9c754',1,0,'ADULT'),(11,'6ee9e4a7-4bec-11ee-839e-a0510b46b473','385e5f12-8c3d-4fc2-8561-ca3184d9c754',0,0,'NONE'),(11,'8283c62f-14f6-11ee-b3b1-00d86184ce3d','385e5f12-8c3d-4fc2-8561-ca3184d9c754',0,0,'NONE'),(11,'848c86d9-26fd-11ee-a98e-a0510b46b473','385e5f12-8c3d-4fc2-8561-ca3184d9c754',0,0,'NONE'),(11,'8a8cc548-1bf9-11ee-9323-a0510b46b473','385e5f12-8c3d-4fc2-8561-ca3184d9c754',0,0,'NONE'),(11,'8e5ac874-0f3e-11ee-8712-a0510b46b473','385e5f12-8c3d-4fc2-8561-ca3184d9c754',0,0,'NONE'),(11,'9619fcac-14c3-11ee-b3b1-00d86184ce3d','385e5f12-8c3d-4fc2-8561-ca3184d9c754',0,0,'NONE'),(11,'971e14b0-e348-11ed-8c5e-00d86184ce3d','385e5f12-8c3d-4fc2-8561-ca3184d9c754',0,0,'NONE'),(11,'a414a41e-4bed-11ee-839e-a0510b46b473','385e5f12-8c3d-4fc2-8561-ca3184d9c754',0,0,'NONE'),(11,'ac239c53-df81-11ed-b6c2-00d86184ce3d','385e5f12-8c3d-4fc2-8561-ca3184d9c754',0,0,'ADULT'),(11,'ae8bd11e-1c05-11ee-9323-a0510b46b473','385e5f12-8c3d-4fc2-8561-ca3184d9c754',0,0,'NONE'),(11,'bd51960a-10d5-11ee-b636-a0510b46b473','385e5f12-8c3d-4fc2-8561-ca3184d9c754',0,0,'NONE'),(11,'c69c4cec-26f5-11ee-aa9d-a0510b46b473','385e5f12-8c3d-4fc2-8561-ca3184d9c754',0,0,'NONE'),(11,'ce063c89-df8b-11ed-b6c2-00d86184ce3d','385e5f12-8c3d-4fc2-8561-ca3184d9c754',0,0,'NONE'),(11,'cf3f0588-deb2-11ed-9cc3-00d86184ce3d','385e5f12-8c3d-4fc2-8561-ca3184d9c754',0,0,'NONE'),(11,'d75719c6-1032-11ee-895b-a0510b46b473','385e5f12-8c3d-4fc2-8561-ca3184d9c754',1,0,'ADULT'),(11,'e0d449f3-dde9-11ed-aa56-00d86184ce3d','385e5f12-8c3d-4fc2-8561-ca3184d9c754',0,0,'NONE'),(11,'e4b67639-0f72-11ee-8712-a0510b46b473','385e5f12-8c3d-4fc2-8561-ca3184d9c754',0,0,'NONE'),(11,'e86b5c99-e024-11ed-bb13-00d86184ce3d','385e5f12-8c3d-4fc2-8561-ca3184d9c754',0,0,'ADULT'),(11,'eb12a131-deae-11ed-9cc3-00d86184ce3d','385e5f12-8c3d-4fc2-8561-ca3184d9c754',0,0,'NONE'),(11,'ed94fe78-10f4-11ee-b636-a0510b46b473','385e5f12-8c3d-4fc2-8561-ca3184d9c754',0,0,'NONE'),(11,'ee09109f-df83-11ed-b6c2-00d86184ce3d','385e5f12-8c3d-4fc2-8561-ca3184d9c754',0,0,'ADULT'),(11,'f29210da-de80-11ed-9cc3-00d86184ce3d','385e5f12-8c3d-4fc2-8561-ca3184d9c754',0,0,'ADULT'),(11,'f72be411-1103-11ee-b636-a0510b46b473','385e5f12-8c3d-4fc2-8561-ca3184d9c754',0,0,'NONE'),(11,'fef8307a-1c9f-11ee-84c4-a0510b46b473','385e5f12-8c3d-4fc2-8561-ca3184d9c754',0,0,'NONE');
/*!40000 ALTER TABLE `ProfessionalPatient` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrder`
--

DROP TABLE IF EXISTS `ProstheticOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticOrder` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `actId` varchar(36) NOT NULL,
  `title` varchar(64) DEFAULT NULL,
  `status` enum('NOT_SENT','SENT','DATE_VALIDATED','DATE_EDITED','VALIDATED','CANCELLED','DELIVERY') NOT NULL DEFAULT 'NOT_SENT',
  `unread` tinyint(1) DEFAULT '0',
  `currentDeliveryDate` datetime(3) DEFAULT NULL,
  `previousDeliveryDate` datetime(3) DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `displayId` mediumint unsigned DEFAULT NULL,
  `createdById` varchar(36) DEFAULT NULL,
  `updatedById` varchar(36) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `actId` (`actId`),
  CONSTRAINT `ProstheticOrder_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrder_ibfk_2` FOREIGN KEY (`actId`) REFERENCES `Act` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrder`
--

LOCK TABLES `ProstheticOrder` WRITE;
/*!40000 ALTER TABLE `ProstheticOrder` DISABLE KEYS */;
INSERT INTO `ProstheticOrder` VALUES ('062cc886-1104-11ee-b636-a0510b46b473',11,'0628a8e9-1104-11ee-b636-a0510b46b473','Commande n° 1.20.1.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-22 15:52:27.620',NULL,'2023-06-22 15:52:27.624','2023-06-22 13:52:27.624',NULL),('0703f184-1ca0-11ee-84c4-a0510b46b473',11,'06fff4e1-1ca0-11ee-84c4-a0510b46b473','Commande n° 1.30.1.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-07 10:26:53.310',NULL,'2023-07-07 10:26:53.314','2023-07-07 08:26:53.314',NULL),('08b889f4-1ca8-11ee-997b-a0510b46b473',11,'08b47e37-1ca8-11ee-997b-a0510b46b473','Commande n° 1.30.2.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-07 11:24:12.145',NULL,'2023-07-07 11:24:12.146','2023-07-07 09:24:12.147',NULL),('1677b8c6-09e6-11ee-8676-a0510b46b473',11,'1673b758-09e6-11ee-8676-a0510b46b473','Commande n° 1.11.7.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-13 14:30:31.913',NULL,'2023-06-13 14:30:31.914','2023-06-13 12:30:31.914',NULL),('1ed8829f-15b6-11ee-b3b1-00d86184ce3d',11,'1ed4b1e6-15b6-11ee-b3b1-00d86184ce3d','Commande n° 1.25.1.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-28 15:17:24.080',NULL,'2023-06-28 15:17:24.080','2023-06-28 13:17:24.081',NULL),('2617b8ff-e03f-11ed-bb13-00d86184ce3d',11,'261265bf-e03f-11ed-bb13-00d86184ce3d','Commande n° 1.11.4.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-21 14:22:14.500',NULL,'2023-04-21 14:22:14.504','2023-04-21 12:22:14.504',NULL),('31a24fdc-1a66-11ee-9a4f-a0510b46b473',11,'319e146c-1a66-11ee-9a4f-a0510b46b473','Commande n° 1.26.3.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-04 14:27:51.677',NULL,'2023-07-04 14:27:51.678','2023-07-04 12:27:51.678',NULL),('3a8d69ff-2abf-11ee-80c8-a0510b46b473',11,'3a881645-2abf-11ee-80c8-a0510b46b473','Commande n° 1.30.7.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-25 09:45:30.453',NULL,'2023-07-25 09:45:30.456','2023-07-25 07:45:30.457',NULL),('3ae40b6f-10e1-11ee-b636-a0510b46b473',11,'3adeac35-10e1-11ee-b636-a0510b46b473','Commande n° 1.18.1.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-22 11:43:23.677',NULL,'2023-06-22 11:43:23.680','2023-06-22 09:43:23.681',NULL),('4510670b-de95-11ed-9cc3-00d86184ce3d',11,'450c29ef-de95-11ed-9cc3-00d86184ce3d','Commande n° 1.4.1.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-19 11:33:40.855',NULL,'2023-04-19 11:33:40.855','2023-04-19 09:33:40.856',NULL),('4a63bc8f-1cad-11ee-997b-a0510b46b473',11,'4a5f2876-1cad-11ee-997b-a0510b46b473','Commande n° 1.31.1.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-07 12:01:49.803',NULL,'2023-07-07 12:01:49.806','2023-07-07 10:01:49.807',NULL),('4b2184da-1404-11ee-91d8-a0510b46b473',11,'4b1c4cb0-1404-11ee-91d8-a0510b46b473','Commande n° 1.21.1.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-26 11:31:56.797',NULL,'2023-06-26 11:31:56.801','2023-06-26 09:31:56.801',NULL),('4dec34d4-26fa-11ee-a98e-a0510b46b473',11,'4de7c46e-26fa-11ee-a98e-a0510b46b473','Commande n° 1.35.2.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-20 14:38:18.607',NULL,'2023-07-20 14:38:18.610','2023-07-20 12:38:18.611',NULL),('4ff6a3e4-2aeb-11ee-97fa-a0510b46b473',11,'4ff1c1c7-2aeb-11ee-97fa-a0510b46b473','Commande n° 1.37.1.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-25 15:01:04.231',NULL,'2023-07-25 15:01:04.234','2023-07-25 13:01:04.234',NULL),('55065ac3-0f41-11ee-8712-a0510b46b473',11,'55019e04-0f41-11ee-8712-a0510b46b473','Commande n° 1.14.2.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-20 10:06:16.883',NULL,'2023-06-20 10:06:16.886','2023-06-20 08:06:16.887',NULL),('56909bae-26df-11ee-a836-a0510b46b473',11,'568bc925-26df-11ee-a836-a0510b46b473','Commande n° 1.30.3.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-20 11:25:16.694','2023-07-21 10:01:25.392','2023-07-21 10:01:25.392','2023-07-21 08:01:25.393',NULL),('56e59d6e-1a49-11ee-9a4f-a0510b46b473',11,'56e1eee3-1a49-11ee-9a4f-a0510b46b473','Commande n° 1.26.1.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-04 11:01:18.788',NULL,'2023-07-04 11:01:18.789','2023-07-04 09:01:18.789',NULL),('5a5f585f-e042-11ed-bb13-00d86184ce3d',11,'5a5a69f7-e042-11ed-bb13-00d86184ce3d','Commande n° 1.11.5.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-21 14:45:10.701',NULL,'2023-04-21 14:45:10.705','2023-04-21 12:45:10.705',NULL),('5c792b81-256f-11ee-91d6-a0510b46b473',11,'5c74c40a-256f-11ee-91d6-a0510b46b473','Commande n° 1.33.1.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-18 15:31:11.810',NULL,'2023-07-18 15:31:11.814','2023-07-18 13:31:11.814',NULL),('5f55fef0-14cc-11ee-b3b1-00d86184ce3d',11,'5f50caeb-14cc-11ee-b3b1-00d86184ce3d','Commande n° 1.22.2.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-27 11:24:10.042',NULL,'2023-06-27 11:24:10.045','2023-06-27 09:24:10.046',NULL),('605a4a0c-e34e-11ed-8c5e-00d86184ce3d',11,'605503de-e34e-11ed-8c5e-00d86184ce3d','Commande n° 1.12.3.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-25 11:48:48.183',NULL,'2023-04-25 11:48:48.185','2023-04-25 09:48:48.185',NULL),('61079347-dcfe-11ed-8097-00d86184ce3d',11,'61025fcf-dcfe-11ed-8097-00d86184ce3d','Commande n° 1.1.1.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-17 11:01:02.604',NULL,'2023-04-17 11:01:02.608','2023-04-17 09:01:02.609',NULL),('6255c5b9-261f-11ee-8042-a0510b46b473',11,'62519c59-261f-11ee-8042-a0510b46b473','Commande n° 1.34.1.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-19 12:31:13.069',NULL,'2023-07-19 12:31:13.072','2023-07-19 10:31:13.073',NULL),('63bcdd10-e035-11ed-bb13-00d86184ce3d',11,'63b81b7e-e035-11ed-bb13-00d86184ce3d','Commande n° 1.11.2.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-21 13:12:22.956',NULL,'2023-04-21 13:12:22.959','2023-04-21 11:12:22.960',NULL),('65bc596d-e01a-11ed-b6c2-00d86184ce3d',11,'65b85f32-e01a-11ed-b6c2-00d86184ce3d','Commande n° 1.10.1.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-21 09:59:09.896',NULL,'2023-04-21 09:59:09.900','2023-04-21 07:59:09.900',NULL),('689c9bda-1035-11ee-895b-a0510b46b473',11,'6897acc6-1035-11ee-895b-a0510b46b473','Commande n° 1.16.2.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-21 15:13:26.947',NULL,'2023-06-21 15:13:26.950','2023-06-21 13:13:26.950',NULL),('68bbf60f-10e4-11ee-b636-a0510b46b473',11,'68b68f8e-10e4-11ee-b636-a0510b46b473','Commande n° 1.18.2.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-22 12:06:09.080',NULL,'2023-06-22 12:06:09.083','2023-06-22 10:06:09.084',NULL),('6ea1fb0b-1587-11ee-b3b1-00d86184ce3d',11,'6e9df503-1587-11ee-b3b1-00d86184ce3d','Commande n° 1.24.1.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-28 09:43:11.594',NULL,'2023-06-28 09:43:11.595','2023-06-28 07:43:11.595',NULL),('6f0dd28e-e03a-11ed-bb13-00d86184ce3d',11,'6f09f9a8-e03a-11ed-bb13-00d86184ce3d','Commande n° 1.11.3.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-21 13:48:29.425',NULL,'2023-04-21 13:48:29.428','2023-04-21 11:48:29.429',NULL),('71bd6c2e-e350-11ed-8c5e-00d86184ce3d',11,'71ba03b6-e350-11ed-8c5e-00d86184ce3d','Commande n° 1.13.1.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-25 12:03:36.348',NULL,'2023-04-25 12:03:36.349','2023-04-25 10:03:36.349',NULL),('76fdd950-1a76-11ee-8124-a0510b46b473',11,'76f916fd-1a76-11ee-8124-a0510b46b473','Commande n° 1.27.1.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-04 16:24:19.987',NULL,'2023-07-04 16:24:19.990','2023-07-04 14:24:19.991',NULL),('775d77cd-1fe8-11ee-b7d5-a0510b46b473',11,'7758b704-1fe8-11ee-b7d5-a0510b46b473','Commande n° 1.32.1.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-11 14:42:59.055',NULL,'2023-07-11 14:42:59.058','2023-07-11 12:42:59.059',NULL),('77e45f2f-1a6c-11ee-af16-a0510b46b473',11,'77df3b68-1a6c-11ee-af16-a0510b46b473','Commande n° 1.26.4.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-04 15:12:46.531',NULL,'2023-07-04 15:12:46.533','2023-07-04 13:12:46.534',NULL),('78d581c9-26e0-11ee-a836-a0510b46b473',11,'78d129fc-26e0-11ee-a836-a0510b46b473','Commande n° 1.30.4.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-20 11:33:23.685',NULL,'2023-07-20 11:33:23.688','2023-07-20 09:33:23.689',NULL),('85437a5f-e33f-11ed-8c5e-00d86184ce3d',11,'853ebc79-e33f-11ed-8c5e-00d86184ce3d','Commande n° 1.11.6.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-25 10:02:27.659',NULL,'2023-04-25 10:02:27.662','2023-04-25 08:02:27.662',NULL),('85939733-de94-11ed-9cc3-00d86184ce3d',11,'858fcc60-de94-11ed-9cc3-00d86184ce3d','Commande n° 1.2.1.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-19 11:28:19.592',NULL,'2023-04-19 11:28:19.593','2023-04-19 09:28:19.593',NULL),('8b7abaad-2ae7-11ee-97fa-a0510b46b473',11,'8b758c52-2ae7-11ee-97fa-a0510b46b473','Commande n° 1.30.9.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-25 14:34:06.095',NULL,'2023-07-25 14:34:06.098','2023-07-25 12:34:06.099',NULL),('8cbfeb18-10fb-11ee-b636-a0510b46b473',11,'8cbad919-10fb-11ee-b636-a0510b46b473','Commande n° 1.19.2.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-22 14:51:47.928',NULL,'2023-06-22 14:51:47.932','2023-06-22 12:51:47.933',NULL),('8d668b31-14f6-11ee-b3b1-00d86184ce3d',11,'8d62c238-14f6-11ee-b3b1-00d86184ce3d','Commande n° 1.23.1.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-27 16:26:06.188',NULL,'2023-06-27 16:26:06.189','2023-06-27 14:26:06.189',NULL),('8f67b426-26fd-11ee-a98e-a0510b46b473',11,'8f62cd50-26fd-11ee-a98e-a0510b46b473','Commande n° 1.36.1.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-20 15:01:36.958',NULL,'2023-07-20 15:01:36.962','2023-07-20 13:01:36.963',NULL),('965499cb-0f3e-11ee-8712-a0510b46b473',11,'964f8d9e-0f3e-11ee-8712-a0510b46b473','Commande n° 1.14.1.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-20 09:46:37.958',NULL,'2023-06-20 09:46:37.961','2023-06-20 07:46:37.961',NULL),('97735329-1bf9-11ee-9323-a0510b46b473',11,'976f015a-1bf9-11ee-9323-a0510b46b473','Commande n° 1.28.1.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-06 14:35:29.678',NULL,'2023-07-06 14:35:29.682','2023-07-06 12:35:29.683',NULL),('9f35c6ae-1a64-11ee-9a4f-a0510b46b473',11,'9f32257c-1a64-11ee-9a4f-a0510b46b473','Commande n° 1.26.2.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-04 14:16:36.521',NULL,'2023-07-04 14:16:36.524','2023-07-04 12:16:36.525',NULL),('a0a9c102-1bd8-11ee-9086-a0510b46b473',11,'a0a47257-1bd8-11ee-9086-a0510b46b473','Commande n° 1.27.3.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-06 10:39:31.743',NULL,'2023-07-06 10:39:31.746','2023-07-06 08:39:31.746',NULL),('a100687a-e348-11ed-8c5e-00d86184ce3d',11,'a0fbda94-e348-11ed-8c5e-00d86184ce3d','Commande n° 1.12.1.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-25 11:07:39.666',NULL,'2023-04-25 11:07:39.667','2023-04-25 09:07:39.667',NULL),('a5cdacb3-e021-11ed-a285-00d86184ce3d',11,'a5c8b0b7-e021-11ed-a285-00d86184ce3d','Commande n° 1.10.2.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-21 10:51:03.861',NULL,'2023-04-21 10:51:03.864','2023-04-21 08:51:03.865',NULL),('a6b5c0b0-1bcf-11ee-9086-a0510b46b473',11,'a6b1a4bd-1bcf-11ee-9086-a0510b46b473','Commande n° 1.14.3.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-06 09:35:16.417',NULL,'2023-07-06 09:35:16.418','2023-07-06 07:35:16.418',NULL),('a94aa8a6-1ccf-11ee-997b-a0510b46b473',11,'a945b37e-1ccf-11ee-997b-a0510b46b473','Commande n° 1.31.3.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-07 16:07:51.911',NULL,'2023-07-07 16:07:51.914','2023-07-07 14:07:51.915',NULL),('a9a65d79-4bed-11ee-839e-a0510b46b473',11,'a9a1083a-4bed-11ee-839e-a0510b46b473','Commande n° 1.38.1.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-09-05 15:11:02.064',NULL,'2023-09-05 15:11:02.068','2023-09-05 13:11:02.068',NULL),('ab8a0134-262e-11ee-81dd-a0510b46b473',11,'ab852a49-262e-11ee-81dd-a0510b46b473','Commande n° 1.34.2.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-19 14:20:38.336',NULL,'2023-07-19 14:20:38.339','2023-07-19 12:20:38.340',NULL),('aeda854d-dd16-11ed-8097-00d86184ce3d',11,'aed62174-dd16-11ed-8097-00d86184ce3d','Commande n° 1.1.2.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-17 13:55:01.092',NULL,'2023-04-17 13:55:01.093','2023-04-17 11:55:01.093',NULL),('b149ef16-2a36-11ee-9e90-a0510b46b473',11,'b144ba33-2a36-11ee-9e90-a0510b46b473','Commande n° 1.30.6.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-24 17:28:08.607',NULL,'2023-07-24 17:28:08.611','2023-07-24 15:28:08.611',NULL),('b2135aae-df81-11ed-b6c2-00d86184ce3d',11,'b20f4b8a-df81-11ed-b6c2-00d86184ce3d','Commande n° 1.7.1.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-20 15:46:04.974',NULL,'2023-04-20 15:46:04.975','2023-04-20 13:46:04.975',NULL),('b60361f7-2ae0-11ee-95bc-a0510b46b473',11,'b5fe1002-2ae0-11ee-95bc-a0510b46b473','Commande n° 1.30.8.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-25 13:45:10.978',NULL,'2023-07-25 13:45:10.981','2023-07-25 11:45:10.982',NULL),('bab70441-1c09-11ee-a865-a0510b46b473',11,'bab223ae-1c09-11ee-a865-a0510b46b473','Commande n° 1.29.2.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-06 16:31:00.790',NULL,'2023-07-06 16:31:00.793','2023-07-06 14:31:00.794',NULL),('bb477ede-1c05-11ee-9323-a0510b46b473',11,'bb436bde-1c05-11ee-9323-a0510b46b473','Commande n° 1.29.1.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-06 16:02:23.750',NULL,'2023-07-06 16:02:23.751','2023-07-06 14:02:23.751',NULL),('c2917968-2706-11ee-a98e-a0510b46b473',11,'c28d11f3-2706-11ee-a98e-a0510b46b473','Commande n° 1.34.3.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-20 16:07:28.266',NULL,'2023-07-20 16:07:28.269','2023-07-20 14:07:28.270',NULL),('c2f8c4d7-deba-11ed-9cc3-00d86184ce3d',11,'c2f3ac91-deba-11ed-9cc3-00d86184ce3d','Commande n° 1.6.2.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-19 16:02:03.472',NULL,'2023-04-19 16:02:03.475','2023-04-19 14:02:03.475',NULL),('c41c16b7-15ba-11ee-b3b1-00d86184ce3d',11,'c41888b6-15ba-11ee-b3b1-00d86184ce3d','Commande n° 1.25.2.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-28 15:50:39.333',NULL,'2023-06-28 15:50:39.335','2023-06-28 13:50:39.335',NULL),('c5eb6bac-10d5-11ee-b636-a0510b46b473',11,'c5e67f1c-10d5-11ee-b636-a0510b46b473','Commande n° 1.17.1.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-22 10:21:22.968',NULL,'2023-06-22 10:21:22.971','2023-06-22 08:21:22.972',NULL),('c85ccf48-1a77-11ee-8124-a0510b46b473',11,'c8578c2f-1a77-11ee-8124-a0510b46b473','Commande n° 1.27.2.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-04 16:33:46.002',NULL,'2023-07-04 16:33:46.005','2023-07-04 14:33:46.005',NULL),('ceb3bc4a-1107-11ee-b636-a0510b46b473',11,'ceaea325-1107-11ee-b636-a0510b46b473','Commande n° 1.20.2.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-22 16:19:32.539',NULL,'2023-06-22 16:19:32.542','2023-06-22 14:19:32.543',NULL),('cf363921-26f5-11ee-aa9d-a0510b46b473',11,'cf31a6d6-26f5-11ee-aa9d-a0510b46b473','Commande n° 1.35.1.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-20 14:06:08.034',NULL,'2023-07-20 14:06:08.037','2023-07-20 12:06:08.038',NULL),('d30fbe11-1bdb-11ee-9086-a0510b46b473',11,'d30b0955-1bdb-11ee-9086-a0510b46b473','Commande n° 1.27.4.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-06 11:02:24.787',NULL,'2023-07-06 11:02:24.791','2023-07-06 09:02:24.791',NULL),('d50d8b4b-df8b-11ed-b6c2-00d86184ce3d',11,'d5081c73-df8b-11ed-b6c2-00d86184ce3d','Commande n° 1.9.1.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-20 16:58:38.623',NULL,'2023-04-20 16:58:38.627','2023-04-20 14:58:38.628',NULL),('d5f4bd9a-26e3-11ee-a836-a0510b46b473',11,'d5ef2d6b-26e3-11ee-a836-a0510b46b473','Commande n° 1.30.5.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-20 11:57:28.408',NULL,'2023-07-20 11:57:28.411','2023-07-20 09:57:28.412',NULL),('d6fe3482-e34a-11ed-8c5e-00d86184ce3d',11,'d6f9d6f4-e34a-11ed-8c5e-00d86184ce3d','Commande n° 1.12.2.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-25 11:23:29.242',NULL,'2023-04-25 11:23:29.246','2023-04-25 09:23:29.246',NULL),('d778c54a-deb2-11ed-9cc3-00d86184ce3d',11,'d7750b8d-deb2-11ed-9cc3-00d86184ce3d','Commande n° 1.6.1.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-19 15:05:21.891',NULL,'2023-04-19 15:05:21.892','2023-04-19 13:05:21.892',NULL),('dfb8fc03-1cb0-11ee-997b-a0510b46b473',11,'dfb50528-1cb0-11ee-997b-a0510b46b473','Commande n° 1.31.2.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-07 12:27:28.832',NULL,'2023-07-07 12:27:28.833','2023-07-07 10:27:28.833',NULL),('e5c9ad0a-1032-11ee-895b-a0510b46b473',11,'e5c513d4-1032-11ee-895b-a0510b46b473','Commande n° 1.16.1.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-21 14:55:28.467',NULL,'2023-06-21 14:55:28.471','2023-06-21 12:55:28.471',NULL),('ea20644d-e352-11ed-8c5e-00d86184ce3d',11,'ea1c884f-e352-11ed-8c5e-00d86184ce3d','Commande n° 1.13.2.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-25 12:21:17.316',NULL,'2023-04-25 12:21:17.317','2023-04-25 10:21:17.317',NULL),('ea3b6b96-10da-11ee-b636-a0510b46b473',11,'ea36dd21-10da-11ee-b636-a0510b46b473','Commande n° 1.17.2.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-22 10:58:11.374',NULL,'2023-06-22 10:58:11.375','2023-06-22 08:58:11.375',NULL),('ec7d92d3-0f72-11ee-8712-a0510b46b473',11,'ec7935d6-0f72-11ee-8712-a0510b46b473','Commande n° 1.15.1.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-20 16:01:16.340',NULL,'2023-06-20 16:01:16.342','2023-06-20 14:01:16.342',NULL),('ed8ae1d1-e024-11ed-bb13-00d86184ce3d',11,'ed85304d-e024-11ed-bb13-00d86184ce3d','Commande n° 1.11.1.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-21 11:14:32.710',NULL,'2023-04-21 11:14:32.713','2023-04-21 09:14:32.713',NULL),('efd0597a-14e3-11ee-b3b1-00d86184ce3d',11,'efcc55aa-14e3-11ee-b3b1-00d86184ce3d','Commande n° 1.20.3.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-27 14:12:50.860',NULL,'2023-06-27 14:12:50.861','2023-06-27 12:12:50.861',NULL),('f3db211a-df83-11ed-b6c2-00d86184ce3d',11,'f3d790be-df83-11ed-b6c2-00d86184ce3d','Commande n° 1.8.1.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-20 16:02:14.328',NULL,'2023-04-20 16:02:14.329','2023-04-20 14:02:14.329',NULL),('f5864534-2576-11ee-b81b-a0510b46b473',11,'f58279e9-2576-11ee-b81b-a0510b46b473','Commande n° 1.33.2.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-18 16:25:35.065',NULL,'2023-07-18 16:25:35.065','2023-07-18 14:25:35.066',NULL),('f8f44d12-10f4-11ee-b636-a0510b46b473',11,'f8ef8fe7-10f4-11ee-b636-a0510b46b473','Commande n° 1.19.1.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-22 14:04:42.988',NULL,'2023-06-22 14:04:42.989','2023-06-22 12:04:42.990',NULL),('fc639fc0-e353-11ed-8c5e-00d86184ce3d',11,'fc5f9260-e353-11ed-8c5e-00d86184ce3d','Commande n° 1.13.3.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-25 12:28:57.453',NULL,'2023-04-25 12:28:57.453','2023-04-25 10:28:57.454',NULL),('fdeed1eb-deae-11ed-9cc3-00d86184ce3d',11,'fdea0616-deae-11ed-9cc3-00d86184ce3d','Commande n° 1.5.1.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-19 14:37:48.431',NULL,'2023-04-19 14:37:48.435','2023-04-19 12:37:48.435',NULL),('ff6aeaec-1bff-11ee-9323-a0510b46b473',11,'ff6745bb-1bff-11ee-9323-a0510b46b473','Commande n° 1.28.2.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-06 15:21:21.087',NULL,'2023-07-06 15:21:21.090','2023-07-06 13:21:21.091',NULL),('ffe0d924-de80-11ed-9cc3-00d86184ce3d',11,'ffdb9942-de80-11ed-9cc3-00d86184ce3d','Commande n° 1.3.1.1','NOT_SENT',1,NULL,NULL,1,1,'cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-19 09:08:34.846',NULL,'2023-04-19 09:08:34.849','2023-04-19 07:08:34.849',NULL);
/*!40000 ALTER TABLE `ProstheticOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrderFile`
--

DROP TABLE IF EXISTS `ProstheticOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticOrderFile` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('FORM','SCAN') NOT NULL,
  PRIMARY KEY (`orderId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `ProstheticOrderFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrderFile_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `ProstheticOrder` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrderFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrderFile`
--

LOCK TABLES `ProstheticOrderFile` WRITE;
/*!40000 ALTER TABLE `ProstheticOrderFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `ProstheticOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrderRecipient`
--

DROP TABLE IF EXISTS `ProstheticOrderRecipient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticOrderRecipient` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `recipientId` varchar(36) NOT NULL,
  PRIMARY KEY (`orderId`,`recipientId`),
  KEY `ownerId` (`ownerId`),
  KEY `recipientId` (`recipientId`),
  CONSTRAINT `ProstheticOrderRecipient_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrderRecipient_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `ProstheticOrder` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrderRecipient_ibfk_3` FOREIGN KEY (`recipientId`) REFERENCES `Contact` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrderRecipient`
--

LOCK TABLES `ProstheticOrderRecipient` WRITE;
/*!40000 ALTER TABLE `ProstheticOrderRecipient` DISABLE KEYS */;
/*!40000 ALTER TABLE `ProstheticOrderRecipient` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticSheet`
--

DROP TABLE IF EXISTS `ProstheticSheet`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticSheet` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `json` text NOT NULL,
  `pdfFileId` varchar(36) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `orderId` (`orderId`),
  KEY `pdfFileId` (`pdfFileId`),
  CONSTRAINT `ProstheticSheet_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ProstheticSheet_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `ProstheticOrder` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ProstheticSheet_ibfk_3` FOREIGN KEY (`pdfFileId`) REFERENCES `File` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticSheet`
--

LOCK TABLES `ProstheticSheet` WRITE;
/*!40000 ALTER TABLE `ProstheticSheet` DISABLE KEYS */;
INSERT INTO `ProstheticSheet` VALUES ('062d332a-1104-11ee-b636-a0510b46b473',11,'062cc886-1104-11ee-b636-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"bouche manip V2\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-06-22 15:52:07.361',NULL,'2023-06-22 15:52:27.623','2023-06-22 13:52:27.626',NULL),('07044daa-1ca0-11ee-84c4-a0510b46b473',11,'0703f184-1ca0-11ee-84c4-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"bouche\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-07-07 10:26:44.749',NULL,'2023-07-07 10:26:53.313','2023-07-07 08:26:53.316',NULL),('08b8a4a0-1ca8-11ee-997b-a0510b46b473',11,'08b889f4-1ca8-11ee-997b-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"MANIP V2\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-07-07 11:24:01.307',NULL,'2023-07-07 11:24:12.146','2023-07-07 09:24:12.147',NULL),('1677cc67-09e6-11ee-8676-a0510b46b473',11,'1677b8c6-09e6-11ee-8676-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"recuperation scan intermediaire\",\n        \"subType\": 0,\n        \"type\": 10,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-06-13 14:30:14.941',NULL,'2023-06-13 14:30:31.914','2023-06-13 12:30:31.914',NULL),('1ed894f9-15b6-11ee-b3b1-00d86184ce3d',11,'1ed8829f-15b6-11ee-b3b1-00d86184ce3d','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"bouche\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-06-28 15:17:13.217',NULL,'2023-06-28 15:17:24.080','2023-06-28 13:17:24.081',NULL),('26181cd3-e03f-11ed-bb13-00d86184ce3d',11,'2617b8ff-e03f-11ed-bb13-00d86184ce3d','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"video arcade\",\n        \"type\": 12,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-04-21 14:21:31.161',NULL,'2023-04-21 14:22:14.503','2023-04-21 12:22:14.506',NULL),('31a26d34-1a66-11ee-9a4f-a0510b46b473',11,'31a24fdc-1a66-11ee-9a4f-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"SEQUENCE MANIP V2\",\n        \"subType\": 0,\n        \"type\": 10,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-07-04 14:27:28.475',NULL,'2023-07-04 14:27:51.677','2023-07-04 12:27:51.678',NULL),('3a8dc83c-2abf-11ee-80c8-a0510b46b473',11,'3a8d69ff-2abf-11ee-80c8-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"vidéo\",\n        \"type\": 12,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-07-25 09:45:15.557',NULL,'2023-07-25 09:45:30.455','2023-07-25 07:45:30.458',NULL),('3ae468af-10e1-11ee-b636-a0510b46b473',11,'3ae40b6f-10e1-11ee-b636-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"bouche en v1\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-06-22 11:43:09.857',NULL,'2023-06-22 11:43:23.680','2023-06-22 09:43:23.682',NULL),('451080e4-de95-11ed-9cc3-00d86184ce3d',11,'4510670b-de95-11ed-9cc3-00d86184ce3d','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"tests x 6\",\n        \"type\": 12,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-04-19 11:33:24.839',NULL,'2023-04-19 11:33:40.855','2023-04-19 09:33:40.856',NULL),('4a6421f6-1cad-11ee-997b-a0510b46b473',11,'4a63bc8f-1cad-11ee-997b-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"bouche\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-07-07 12:01:42.137',NULL,'2023-07-07 12:01:49.806','2023-07-07 10:01:49.808',NULL),('4b21e55e-1404-11ee-91d8-a0510b46b473',11,'4b2184da-1404-11ee-91d8-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"bouche\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-06-26 11:31:42.223',NULL,'2023-06-26 11:31:56.800','2023-06-26 09:31:56.803',NULL),('4dec96fa-26fa-11ee-a98e-a0510b46b473',11,'4dec34d4-26fa-11ee-a98e-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"bouche apres demarrage\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-07-20 14:37:47.969',NULL,'2023-07-20 14:38:18.609','2023-07-20 12:38:18.612',NULL),('4ff6fdb3-2aeb-11ee-97fa-a0510b46b473',11,'4ff6a3e4-2aeb-11ee-97fa-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"Autre\",\n        \"type\": 12,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-07-25 15:01:00.766',NULL,'2023-07-25 15:01:04.233','2023-07-25 13:01:04.236',NULL),('5506b24c-0f41-11ee-8712-a0510b46b473',11,'55065ac3-0f41-11ee-8712-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"MANIP V2\",\n        \"type\": 12,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-06-20 10:06:04.317',NULL,'2023-06-20 10:06:16.886','2023-06-20 08:06:16.888',NULL),('5690f591-26df-11ee-a836-a0510b46b473',11,'56909bae-26df-11ee-a836-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"chauffe\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-07-20 11:25:05.090','2023-07-21 10:01:25.392','2023-07-20 11:25:16.697','2023-07-21 08:01:25.395',NULL),('56e5b9bb-1a49-11ee-9a4f-a0510b46b473',11,'56e59d6e-1a49-11ee-9a4f-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"bouche\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-07-04 11:01:03.432',NULL,'2023-07-04 11:01:18.789','2023-07-04 09:01:18.790',NULL),('5a5fb93d-e042-11ed-bb13-00d86184ce3d',11,'5a5f585f-e042-11ed-bb13-00d86184ce3d','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"video2 arcade\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-04-21 14:44:59.052',NULL,'2023-04-21 14:45:10.704','2023-04-21 12:45:10.707',NULL),('5c798d53-256f-11ee-91d6-a0510b46b473',11,'5c792b81-256f-11ee-91d6-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"bouche\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-07-18 15:30:56.009',NULL,'2023-07-18 15:31:11.813','2023-07-18 13:31:11.816',NULL),('5f566600-14cc-11ee-b3b1-00d86184ce3d',11,'5f55fef0-14cc-11ee-b3b1-00d86184ce3d','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"manip V2\",\n        \"subType\": 0,\n        \"type\": 10,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-06-27 11:23:55.307',NULL,'2023-06-27 11:24:10.044','2023-06-27 09:24:10.047',NULL),('605a6f9f-e34e-11ed-8c5e-00d86184ce3d',11,'605a4a0c-e34e-11ed-8c5e-00d86184ce3d','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"video manip V2\",\n        \"type\": 12,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-04-25 11:48:35.845',NULL,'2023-04-25 11:48:48.184','2023-04-25 09:48:48.185',NULL),('61080464-dcfe-11ed-8097-00d86184ce3d',11,'61079347-dcfe-11ed-8097-00d86184ce3d','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"Guide\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-04-17 11:00:57.099',NULL,'2023-04-17 11:01:02.607','2023-04-17 09:01:02.610',NULL),('62561fbe-261f-11ee-8042-a0510b46b473',11,'6255c5b9-261f-11ee-8042-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"bouche\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-07-19 12:30:57.262',NULL,'2023-07-19 12:31:13.072','2023-07-19 10:31:13.074',NULL),('63bd3aa6-e035-11ed-bb13-00d86184ce3d',11,'63bcdd10-e035-11ed-bb13-00d86184ce3d','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"video\",\n        \"type\": 12,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-04-21 13:12:14.584',NULL,'2023-04-21 13:12:22.959','2023-04-21 11:12:22.961',NULL),('65bcb8ca-e01a-11ed-b6c2-00d86184ce3d',11,'65bc596d-e01a-11ed-b6c2-00d86184ce3d','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"Autre\",\n        \"type\": 12,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-04-21 09:59:06.544',NULL,'2023-04-21 09:59:09.899','2023-04-21 07:59:09.902',NULL),('689cf983-1035-11ee-895b-a0510b46b473',11,'689c9bda-1035-11ee-895b-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"ref23\",\n        \"type\": 12,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-06-21 15:13:18.004',NULL,'2023-06-21 15:13:26.949','2023-06-21 13:13:26.952',NULL),('68bc60c3-10e4-11ee-b636-a0510b46b473',11,'68bbf60f-10e4-11ee-b636-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"MANIP V2\",\n        \"subType\": 0,\n        \"type\": 10,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-06-22 12:06:00.339',NULL,'2023-06-22 12:06:09.083','2023-06-22 10:06:09.085',NULL),('6ea21963-1587-11ee-b3b1-00d86184ce3d',11,'6ea1fb0b-1587-11ee-b3b1-00d86184ce3d','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"bouche\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-06-28 09:43:01.483',NULL,'2023-06-28 09:43:11.595','2023-06-28 07:43:11.595',NULL),('6f0e2db2-e03a-11ed-bb13-00d86184ce3d',11,'6f0dd28e-e03a-11ed-bb13-00d86184ce3d','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"pour video-hemi\",\n        \"type\": 12,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-04-21 13:48:15.196',NULL,'2023-04-21 13:48:29.428','2023-04-21 11:48:29.430',NULL),('71bd842d-e350-11ed-8c5e-00d86184ce3d',11,'71bd6c2e-e350-11ed-8c5e-00d86184ce3d','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"precision manip V1\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-04-25 12:03:15.008',NULL,'2023-04-25 12:03:36.348','2023-04-25 10:03:36.349',NULL),('76fe3572-1a76-11ee-8124-a0510b46b473',11,'76fdd950-1a76-11ee-8124-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"bouche\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-07-04 16:23:49.693',NULL,'2023-07-04 16:24:19.990','2023-07-04 14:24:19.992',NULL),('775dd795-1fe8-11ee-b7d5-a0510b46b473',11,'775d77cd-1fe8-11ee-b7d5-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"Gouttière\",\n        \"subType\": 0,\n        \"type\": 10,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-07-11 14:42:55.544',NULL,'2023-07-11 14:42:59.058','2023-07-11 12:42:59.061',NULL),('77e4b1ba-1a6c-11ee-af16-a0510b46b473',11,'77e45f2f-1a6c-11ee-af16-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"bouche\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-07-04 15:12:36.912',NULL,'2023-07-04 15:12:46.533','2023-07-04 13:12:46.535',NULL),('78d5dd17-26e0-11ee-a836-a0510b46b473',11,'78d581c9-26e0-11ee-a836-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"bouche-2 essais\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-07-20 11:31:43.678',NULL,'2023-07-20 11:33:23.687','2023-07-20 09:33:23.690',NULL),('8543d38a-e33f-11ed-8c5e-00d86184ce3d',11,'85437a5f-e33f-11ed-8c5e-00d86184ce3d','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"tests precision\",\n        \"type\": 12,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-04-25 10:02:16.728',NULL,'2023-04-25 10:02:27.661','2023-04-25 08:02:27.664',NULL),('8593b40b-de94-11ed-9cc3-00d86184ce3d',11,'85939733-de94-11ed-9cc3-00d86184ce3d','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"Guide\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-04-19 11:28:13.303',NULL,'2023-04-19 11:28:19.593','2023-04-19 09:28:19.593',NULL),('8b7b1db0-2ae7-11ee-97fa-a0510b46b473',11,'8b7abaad-2ae7-11ee-97fa-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"Autre\",\n        \"type\": 12,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-07-25 14:33:56.161',NULL,'2023-07-25 14:34:06.098','2023-07-25 12:34:06.100',NULL),('8cc04e67-10fb-11ee-b636-a0510b46b473',11,'8cbfeb18-10fb-11ee-b636-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"manip V2\",\n        \"subType\": 0,\n        \"type\": 10,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-06-22 14:51:29.631',NULL,'2023-06-22 14:51:47.931','2023-06-22 12:51:47.934',NULL),('8d66a916-14f6-11ee-b3b1-00d86184ce3d',11,'8d668b31-14f6-11ee-b3b1-00d86184ce3d','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"bouche\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-06-27 16:25:53.438',NULL,'2023-06-27 16:26:06.189','2023-06-27 14:26:06.189',NULL),('8f68232a-26fd-11ee-a98e-a0510b46b473',11,'8f67b426-26fd-11ee-a98e-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"bouche\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-07-20 15:01:23.704',NULL,'2023-07-20 15:01:36.961','2023-07-20 13:01:36.968',NULL),('9654f56c-0f3e-11ee-8712-a0510b46b473',11,'965499cb-0f3e-11ee-8712-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"bouche\",\n        \"type\": 12,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-06-20 09:46:29.787',NULL,'2023-06-20 09:46:37.960','2023-06-20 07:46:37.963',NULL),('9773b5fd-1bf9-11ee-9323-a0510b46b473',11,'97735329-1bf9-11ee-9323-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"bouche\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-07-06 14:35:17.010',NULL,'2023-07-06 14:35:29.681','2023-07-06 12:35:29.684',NULL),('9f361b92-1a64-11ee-9a4f-a0510b46b473',11,'9f35c6ae-1a64-11ee-9a4f-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"manip V2\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-07-04 14:16:24.232',NULL,'2023-07-04 14:16:36.524','2023-07-04 12:16:36.526',NULL),('a0aa1bf2-1bd8-11ee-9086-a0510b46b473',11,'a0a9c102-1bd8-11ee-9086-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"bouche \",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-07-06 10:38:55.569',NULL,'2023-07-06 10:39:31.745','2023-07-06 08:39:31.748',NULL),('a10081c3-e348-11ed-8c5e-00d86184ce3d',11,'a100687a-e348-11ed-8c5e-00d86184ce3d','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"precision\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-04-25 11:07:29.729',NULL,'2023-04-25 11:07:39.666','2023-04-25 09:07:39.667',NULL),('a5ce0bc7-e021-11ed-a285-00d86184ce3d',11,'a5cdacb3-e021-11ed-a285-00d86184ce3d','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"video\",\n        \"type\": 12,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-04-21 10:50:57.352',NULL,'2023-04-21 10:51:03.864','2023-04-21 08:51:03.866',NULL),('a6b5d94b-1bcf-11ee-9086-a0510b46b473',11,'a6b5c0b0-1bcf-11ee-9086-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"bouche\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-07-06 09:35:08.290',NULL,'2023-07-06 09:35:16.418','2023-07-06 07:35:16.418',NULL),('a94b0ab3-1ccf-11ee-997b-a0510b46b473',11,'a94aa8a6-1ccf-11ee-997b-a0510b46b473','{\n    \"v2\": {\n        \"brandScanBody\": \"Biotech Dental\",\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"prostheticContactPoint\": 1,\n        \"prostheticMaterial\": 0,\n        \"refImplant\": \"\",\n        \"refScanBody\": \"KPLPSCANP\",\n        \"selectedTeeth\": [\n            17\n        ],\n        \"sheetTitle\": \"Couronne sur implant\",\n        \"specificTint\": \"\",\n        \"subType\": 0,\n        \"type\": 1,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-07-07 16:07:36.756',NULL,'2023-07-07 16:07:51.914','2023-07-07 14:07:51.916',NULL),('a9a6b5f9-4bed-11ee-839e-a0510b46b473',11,'a9a65d79-4bed-11ee-839e-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"Guide\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-09-05 15:10:58.989',NULL,'2023-09-05 15:11:02.067','2023-09-05 13:11:02.070',NULL),('ab8a6671-262e-11ee-81dd-a0510b46b473',11,'ab8a0134-262e-11ee-81dd-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"manip V2\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-07-19 14:20:19.992',NULL,'2023-07-19 14:20:38.339','2023-07-19 12:20:38.341',NULL),('aeda9612-dd16-11ed-8097-00d86184ce3d',11,'aeda854d-dd16-11ed-8097-00d86184ce3d','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"Nadège\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-04-17 13:54:47.173',NULL,'2023-04-17 13:55:01.093','2023-04-17 11:55:01.094',NULL),('b14a4dee-2a36-11ee-9e90-a0510b46b473',11,'b149ef16-2a36-11ee-9e90-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"Gouttière\",\n        \"subType\": 0,\n        \"type\": 10,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-07-24 17:28:05.496',NULL,'2023-07-24 17:28:08.610','2023-07-24 15:28:08.613',NULL),('b21371ef-df81-11ed-b6c2-00d86184ce3d',11,'b2135aae-df81-11ed-b6c2-00d86184ce3d','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"Autre\",\n        \"type\": 12,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-04-20 15:46:01.916',NULL,'2023-04-20 15:46:04.974','2023-04-20 13:46:04.975',NULL),('b603ca92-2ae0-11ee-95bc-a0510b46b473',11,'b60361f7-2ae0-11ee-95bc-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"video\",\n        \"type\": 12,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-07-25 13:45:03.414',NULL,'2023-07-25 13:45:10.981','2023-07-25 11:45:10.983',NULL),('bab76541-1c09-11ee-a865-a0510b46b473',11,'bab70441-1c09-11ee-a865-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"MANIP v2\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-07-06 16:30:50.598',NULL,'2023-07-06 16:31:00.793','2023-07-06 14:31:00.795',NULL),('bb479a9f-1c05-11ee-9323-a0510b46b473',11,'bb477ede-1c05-11ee-9323-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"bouche\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-07-06 16:02:08.931',NULL,'2023-07-06 16:02:23.751','2023-07-06 14:02:23.751',NULL),('c291d32d-2706-11ee-a98e-a0510b46b473',11,'c2917968-2706-11ee-a98e-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"essai 2\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-07-20 16:07:14.994',NULL,'2023-07-20 16:07:28.269','2023-07-20 14:07:28.271',NULL),('c2f91cae-deba-11ed-9cc3-00d86184ce3d',11,'c2f8c4d7-deba-11ed-9cc3-00d86184ce3d','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"vidéo\",\n        \"type\": 12,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-04-19 16:01:57.121',NULL,'2023-04-19 16:02:03.474','2023-04-19 14:02:03.477',NULL),('c41c48d0-15ba-11ee-b3b1-00d86184ce3d',11,'c41c16b7-15ba-11ee-b3b1-00d86184ce3d','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"manip V2\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-06-28 15:50:30.352',NULL,'2023-06-28 15:50:39.335','2023-06-28 13:50:39.336',NULL),('c5ebc2bb-10d5-11ee-b636-a0510b46b473',11,'c5eb6bac-10d5-11ee-b636-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"verif bouche\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-06-22 10:21:14.246',NULL,'2023-06-22 10:21:22.970','2023-06-22 08:21:22.973',NULL),('c85d27d6-1a77-11ee-8124-a0510b46b473',11,'c85ccf48-1a77-11ee-8124-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \" bouche essai2\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-07-04 16:33:30.096',NULL,'2023-07-04 16:33:46.004','2023-07-04 14:33:46.007',NULL),('ceb4166b-1107-11ee-b636-a0510b46b473',11,'ceb3bc4a-1107-11ee-b636-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"manipV2\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-06-22 16:19:22.809',NULL,'2023-06-22 16:19:32.542','2023-06-22 14:19:32.544',NULL),('cf3690e4-26f5-11ee-aa9d-a0510b46b473',11,'cf363921-26f5-11ee-aa9d-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"bouche\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-07-20 14:05:58.419',NULL,'2023-07-20 14:06:08.037','2023-07-20 12:06:08.039',NULL),('d31022a7-1bdb-11ee-9086-a0510b46b473',11,'d30fbe11-1bdb-11ee-9086-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"manip V2\",\n        \"subType\": 0,\n        \"type\": 10,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-07-06 11:02:15.465',NULL,'2023-07-06 11:02:24.790','2023-07-06 09:02:24.792',NULL),('d50de9a9-df8b-11ed-b6c2-00d86184ce3d',11,'d50d8b4b-df8b-11ed-b6c2-00d86184ce3d','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"Autre\",\n        \"type\": 12,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-04-20 16:58:34.747',NULL,'2023-04-20 16:58:38.626','2023-04-20 14:58:38.629',NULL),('d5f51f26-26e3-11ee-a836-a0510b46b473',11,'d5f4bd9a-26e3-11ee-a836-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"bouche avec autre coque\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-07-20 11:57:05.954',NULL,'2023-07-20 11:57:28.411','2023-07-20 09:57:28.413',NULL),('d6fea39b-e34a-11ed-8c5e-00d86184ce3d',11,'d6fe3482-e34a-11ed-8c5e-00d86184ce3d','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"manip V2\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-04-25 11:23:11.437',NULL,'2023-04-25 11:23:29.245','2023-04-25 09:23:29.247',NULL),('d778deea-deb2-11ed-9cc3-00d86184ce3d',11,'d778c54a-deb2-11ed-9cc3-00d86184ce3d','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"bouche x 6\",\n        \"type\": 12,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-04-19 15:05:12.590',NULL,'2023-04-19 15:05:21.892','2023-04-19 13:05:21.892',NULL),('dfb91655-1cb0-11ee-997b-a0510b46b473',11,'dfb8fc03-1cb0-11ee-997b-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"MANIP V2\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-07-07 12:27:18.670',NULL,'2023-07-07 12:27:28.833','2023-07-07 10:27:28.834',NULL),('e5ca19b0-1032-11ee-895b-a0510b46b473',11,'e5c9ad0a-1032-11ee-895b-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"devel_v2_ph3\",\n        \"type\": 12,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-06-21 14:55:10.844',NULL,'2023-06-21 14:55:28.470','2023-06-21 12:55:28.472',NULL),('ea2079d2-e352-11ed-8c5e-00d86184ce3d',11,'ea20644d-e352-11ed-8c5e-00d86184ce3d','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"MANIP V2\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-04-25 12:21:07.389',NULL,'2023-04-25 12:21:17.317','2023-04-25 10:21:17.318',NULL),('ea3b8a89-10da-11ee-b636-a0510b46b473',11,'ea3b6b96-10da-11ee-b636-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"MANIP V2\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-06-22 10:58:02.311',NULL,'2023-06-22 10:58:11.375','2023-06-22 08:58:11.375',NULL),('ec7dc2b2-0f72-11ee-8712-a0510b46b473',11,'ec7d92d3-0f72-11ee-8712-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"bouche\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-06-20 16:01:08.271',NULL,'2023-06-20 16:01:16.341','2023-06-20 14:01:16.343',NULL),('ed8b3994-e024-11ed-bb13-00d86184ce3d',11,'ed8ae1d1-e024-11ed-bb13-00d86184ce3d','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"Autre\",\n        \"type\": 12,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-04-21 11:14:28.961',NULL,'2023-04-21 11:14:32.712','2023-04-21 09:14:32.715',NULL),('efd0744a-14e3-11ee-b3b1-00d86184ce3d',11,'efd0597a-14e3-11ee-b3b1-00d86184ce3d','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"verif après ref29\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-06-27 14:12:39.873',NULL,'2023-06-27 14:12:50.861','2023-06-27 12:12:50.862',NULL),('f3db3980-df83-11ed-b6c2-00d86184ce3d',11,'f3db211a-df83-11ed-b6c2-00d86184ce3d','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"Autre\",\n        \"type\": 12,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-04-20 16:02:09.822',NULL,'2023-04-20 16:02:14.329','2023-04-20 14:02:14.330',NULL),('f5865dea-2576-11ee-b81b-a0510b46b473',11,'f5864534-2576-11ee-b81b-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"redemarrage pc\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-07-18 16:25:22.899',NULL,'2023-07-18 16:25:35.065','2023-07-18 14:25:35.066',NULL),('f8f46a3d-10f4-11ee-b636-a0510b46b473',11,'f8f44d12-10f4-11ee-b636-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"bouche manip V1\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-06-22 14:04:28.653',NULL,'2023-06-22 14:04:42.989','2023-06-22 12:04:42.990',NULL),('fc63b3de-e353-11ed-8c5e-00d86184ce3d',11,'fc639fc0-e353-11ed-8c5e-00d86184ce3d','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"VIDEO manip V2\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-04-25 12:28:02.875',NULL,'2023-04-25 12:28:57.453','2023-04-25 10:28:57.454',NULL),('fdef2c09-deae-11ed-9cc3-00d86184ce3d',11,'fdeed1eb-deae-11ed-9cc3-00d86184ce3d','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"bouche x 6\",\n        \"type\": 12,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-04-19 14:37:22.393',NULL,'2023-04-19 14:37:48.434','2023-04-19 12:37:48.437',NULL),('ff6b4d80-1bff-11ee-9323-a0510b46b473',11,'ff6aeaec-1bff-11ee-9323-a0510b46b473','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"manip V2\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-07-06 15:21:10.911',NULL,'2023-07-06 15:21:21.090','2023-07-06 13:21:21.092',NULL),('ffe13467-de80-11ed-9cc3-00d86184ce3d',11,'ffe0d924-de80-11ed-9cc3-00d86184ce3d','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"Guide\",\n        \"subType\": 0,\n        \"type\": 9,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-04-19 09:08:27.565',NULL,'2023-04-19 09:08:34.848','2023-04-19 07:08:34.851',NULL);
/*!40000 ALTER TABLE `ProstheticSheet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ReceivedAttachment`
--

DROP TABLE IF EXISTS `ReceivedAttachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ReceivedAttachment` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `receivedMessageId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  PRIMARY KEY (`receivedMessageId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `ReceivedAttachment_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ReceivedAttachment_ibfk_2` FOREIGN KEY (`receivedMessageId`) REFERENCES `ReceivedMessage` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ReceivedAttachment_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ReceivedAttachment`
--

LOCK TABLES `ReceivedAttachment` WRITE;
/*!40000 ALTER TABLE `ReceivedAttachment` DISABLE KEYS */;
/*!40000 ALTER TABLE `ReceivedAttachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ReceivedMessage`
--

DROP TABLE IF EXISTS `ReceivedMessage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ReceivedMessage` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `messageTransmitted` tinyint(1) NOT NULL DEFAULT '0',
  `messageSubject` varchar(45) NOT NULL,
  `body` text,
  `fromId` mediumint unsigned NOT NULL,
  `originMessageId` varchar(36) DEFAULT NULL,
  `discussionId` varchar(36) NOT NULL,
  `readStatus` enum('READ','UNREAD') DEFAULT 'UNREAD',
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `fromId` (`fromId`),
  KEY `discussionId` (`discussionId`,`ownerId`),
  CONSTRAINT `ReceivedMessage_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ReceivedMessage_ibfk_2` FOREIGN KEY (`fromId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ReceivedMessage_ibfk_3` FOREIGN KEY (`discussionId`, `ownerId`) REFERENCES `Discussion` (`uuid`, `ownerId`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ReceivedMessage`
--

LOCK TABLES `ReceivedMessage` WRITE;
/*!40000 ALTER TABLE `ReceivedMessage` DISABLE KEYS */;
/*!40000 ALTER TABLE `ReceivedMessage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Scan`
--

DROP TABLE IF EXISTS `Scan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Scan` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL,
  `sessionId` varchar(36) NOT NULL,
  `type` enum('MAXILLAIRE','MANDIBULE','MORDU_ANTERIEUR','MORDU_POSTERIEUR_GAUCHE','MORDU_POSTERIEUR_DROIT') NOT NULL,
  `label` enum('PRE_PREPARATION','SCAN','SCANBODY') NOT NULL DEFAULT 'SCAN',
  `validated` tinyint(1) NOT NULL DEFAULT '0',
  `status` enum('IN_PROGRESS','NONE') NOT NULL DEFAULT 'IN_PROGRESS',
  `displayId` mediumint unsigned DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `comments` text,
  `createdById` varchar(36) DEFAULT NULL,
  `updatedById` varchar(36) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `sessionId` (`sessionId`),
  CONSTRAINT `Scan_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Scan_ibfk_2` FOREIGN KEY (`sessionId`) REFERENCES `Session` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Scan`
--

LOCK TABLES `Scan` WRITE;
/*!40000 ALTER TABLE `Scan` DISABLE KEYS */;
INSERT INTO `Scan` VALUES ('0041c98c-1c00-11ee-9323-a0510b46b473',11,'ff6924df-1bff-11ee-9323-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-06 15:21:22.497',NULL,'2023-07-06 15:22:59.714','2023-07-06 13:22:59.714',NULL),('007b26af-df82-11ed-b6c2-00d86184ce3d',11,'b21241b0-df81-11ed-b6c2-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-20 15:48:16.516',NULL,'2023-04-20 15:50:22.171','2023-04-20 13:50:22.172',NULL),('01383647-e349-11ed-8c5e-00d86184ce3d',11,'a0febadb-e348-11ed-8c5e-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',2,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-25 11:10:21.093',NULL,'2023-04-25 11:12:32.247','2023-04-25 09:12:32.248',NULL),('02397992-1109-11ee-b636-a0510b46b473',11,'ceb199a7-1107-11ee-b636-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',5,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-22 16:28:08.476',NULL,'2023-06-22 16:29:46.754','2023-06-22 14:29:46.754',NULL),('0247ff51-de81-11ed-9cc3-00d86184ce3d',11,'ffdebb3e-de80-11ed-9cc3-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-19 09:08:38.877','2023-04-19 09:39:14.382','2023-04-19 09:39:14.382','2023-04-19 07:39:14.384','2023-04-19 09:39:14.411'),('02cc4e74-2ac5-11ee-80c8-a0510b46b473',11,'3a8b3537-2abf-11ee-80c8-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',14,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-25 10:26:53.893',NULL,'2023-07-25 10:28:32.338','2023-07-25 08:28:32.338',NULL),('0311e969-de87-11ed-9cc3-00d86184ce3d',11,'ffdebb3e-de80-11ed-9cc3-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',5,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-19 09:51:37.181',NULL,'2023-04-19 09:54:07.116','2023-04-19 07:54:07.116','2023-04-19 09:54:07.127'),('0385ac49-e351-11ed-8c5e-00d86184ce3d',11,'71bbf096-e350-11ed-8c5e-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',3,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-25 12:07:40.930',NULL,'2023-04-25 12:09:54.696','2023-04-25 10:09:54.696',NULL),('03994d09-df7e-11ed-b6c2-00d86184ce3d',11,'85925fd9-de94-11ed-9cc3-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',4,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-20 15:19:43.760',NULL,'2023-04-20 15:21:24.858','2023-04-20 13:21:24.858',NULL),('042354a4-14f8-11ee-b3b1-00d86184ce3d',11,'8d65509a-14f6-11ee-b3b1-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',2,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-27 16:36:34.893',NULL,'2023-06-27 16:39:39.605','2023-06-27 14:39:39.606',NULL),('042aff0b-e01b-11ed-b6c2-00d86184ce3d',11,'85925fd9-de94-11ed-9cc3-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',8,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-21 10:03:35.701',NULL,'2023-04-21 10:04:14.094','2023-04-21 08:04:14.094',NULL),('04c3bf10-e028-11ed-bb13-00d86184ce3d',11,'ed88a64f-e024-11ed-bb13-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',4,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-21 11:36:40.160',NULL,'2023-04-21 11:38:47.850','2023-04-21 09:38:47.850',NULL),('0514e729-e354-11ed-8c5e-00d86184ce3d',11,'fc627ef8-e353-11ed-8c5e-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-25 12:29:12.036',NULL,'2023-04-25 12:30:39.394','2023-04-25 10:30:39.394',NULL),('05b43523-e352-11ed-8c5e-00d86184ce3d',11,'71bbf096-e350-11ed-8c5e-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',6,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-25 12:14:54.087',NULL,'2023-04-25 12:17:16.412','2023-04-25 10:17:16.412',NULL),('0655838d-0f42-11ee-8712-a0510b46b473',11,'550492f3-0f41-11ee-8712-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',3,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-20 10:11:14.359',NULL,'2023-06-20 10:13:00.983','2023-06-20 08:13:00.983',NULL),('0674de77-26e7-11ee-aa9d-a0510b46b473',11,'d5f241c9-26e3-11ee-a836-a0510b46b473','MANDIBULE','SCAN',1,'NONE',3,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-20 12:20:18.268',NULL,'2023-07-20 12:22:29.312','2023-07-20 10:22:29.312',NULL),('06bcfc1b-e010-11ed-b6c2-00d86184ce3d',11,'85925fd9-de94-11ed-9cc3-00d86184ce3d','MANDIBULE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-21 08:44:55.550',NULL,'2023-04-21 08:46:55.904','2023-04-21 06:46:55.904',NULL),('07ef2822-e34a-11ed-8c5e-00d86184ce3d',11,'a0febadb-e348-11ed-8c5e-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',5,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-25 11:17:41.855',NULL,'2023-04-25 11:19:50.301','2023-04-25 09:19:50.302',NULL),('08053bdb-df8d-11ed-b6c2-00d86184ce3d',11,'d50b8b0c-df8b-11ed-b6c2-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',3,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-20 17:07:13.629',NULL,'2023-04-20 17:09:18.210','2023-04-20 15:09:18.210',NULL),('082bb3fc-df7f-11ed-b6c2-00d86184ce3d',11,'85925fd9-de94-11ed-9cc3-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',6,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-20 15:27:00.927',NULL,'2023-04-20 15:29:17.766','2023-04-20 13:29:17.766',NULL),('089921e4-1108-11ee-b636-a0510b46b473',11,'ceb199a7-1107-11ee-b636-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',2,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-22 16:21:09.672',NULL,'2023-06-22 16:22:50.355','2023-06-22 14:22:50.355',NULL),('09a559d7-1ca8-11ee-997b-a0510b46b473',11,'08b766f9-1ca8-11ee-997b-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-07 11:24:13.698',NULL,'2023-07-07 11:25:20.801','2023-07-07 09:25:20.801',NULL),('0a167497-15bf-11ee-a062-a0510b46b473',11,'c41a4d8e-15ba-11ee-b3b1-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',4,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-28 16:21:14.724',NULL,'2023-06-28 16:22:42.969','2023-06-28 14:22:42.969',NULL),('0acf79e0-0f40-11ee-8712-a0510b46b473',11,'965293c3-0f3e-11ee-8712-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',5,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-20 09:57:02.875',NULL,'2023-06-20 09:59:20.163','2023-06-20 07:59:20.163',NULL),('0ad8ca97-e03a-11ed-bb13-00d86184ce3d',11,'63bb1989-e035-11ed-bb13-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',8,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-21 13:45:41.305',NULL,'2023-04-21 13:46:24.481','2023-04-21 11:46:24.481',NULL),('0bb3f9ba-de9c-11ed-9cc3-00d86184ce3d',11,'450efda8-de95-11ed-9cc3-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',9,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-19 12:22:11.096',NULL,'2023-04-19 12:25:07.107','2023-04-19 10:25:07.108',NULL),('0ca0f60a-1ca0-11ee-84c4-a0510b46b473',11,'0701c127-1ca0-11ee-84c4-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-07 10:27:02.728',NULL,'2023-07-07 10:29:29.015','2023-07-07 08:29:29.015',NULL),('0d97ae6e-e02b-11ed-bb13-00d86184ce3d',11,'ed88a64f-e024-11ed-bb13-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',7,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-21 11:58:23.461',NULL,'2023-04-21 11:59:14.718','2023-04-21 09:59:14.718',NULL),('0e8a66a1-2631-11ee-81dd-a0510b46b473',11,'6253caa6-261f-11ee-8042-a0510b46b473','MANDIBULE','SCAN',1,'NONE',3,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-19 14:37:43.427',NULL,'2023-07-19 14:39:58.015','2023-07-19 12:39:58.015',NULL),('0f669f5c-2ae1-11ee-95bc-a0510b46b473',11,'b6012772-2ae0-11ee-95bc-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-25 13:47:40.945',NULL,'2023-07-25 13:49:43.293','2023-07-25 11:49:43.293',NULL),('112daefc-2a39-11ee-9e90-a0510b46b473',11,'b147bba1-2a36-11ee-9e90-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',3,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-24 17:45:08.477',NULL,'2023-07-24 17:47:07.398','2023-07-24 15:47:07.398',NULL),('11365db6-e020-11ed-a285-00d86184ce3d',11,'65ba9a94-e01a-11ed-b6c2-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',7,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-21 10:39:45.070',NULL,'2023-04-21 10:41:31.638','2023-04-21 08:41:31.638',NULL),('1142d295-10fc-11ee-b636-a0510b46b473',11,'8cbde682-10fb-11ee-b636-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',3,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-22 14:55:30.246',NULL,'2023-06-22 14:57:08.382','2023-06-22 12:57:08.382',NULL),('114be474-e343-11ed-8c5e-00d86184ce3d',11,'8541c500-e33f-11ed-8c5e-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',4,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-25 10:27:51.085',NULL,'2023-04-25 10:30:05.274','2023-04-25 08:30:05.274',NULL),('117e7303-1c06-11ee-9323-a0510b46b473',11,'bb465a1e-1c05-11ee-9323-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',2,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-06 16:04:48.394',NULL,'2023-07-06 16:07:13.427','2023-07-06 14:07:13.427',NULL),('120f2752-1bd0-11ee-9086-a0510b46b473',11,'a6b491c8-1bcf-11ee-9086-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',2,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-06 09:38:16.519',NULL,'2023-07-06 09:39:59.783','2023-07-06 07:39:59.783',NULL),('125d5fc5-e025-11ed-bb13-00d86184ce3d',11,'ed88a64f-e024-11ed-bb13-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-21 11:15:34.487',NULL,'2023-04-21 11:18:06.008','2023-04-21 09:18:06.008',NULL),('1281e227-1ca1-11ee-84c4-a0510b46b473',11,'0701c127-1ca0-11ee-84c4-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',4,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-07 10:34:22.087',NULL,'2023-07-07 10:36:29.161','2023-07-07 08:36:29.161',NULL),('14008eff-1a64-11ee-9a4f-a0510b46b473',11,'56e449e9-1a49-11ee-9a4f-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',10,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-04 14:12:42.969',NULL,'2023-07-04 14:15:20.250','2023-07-04 12:15:20.250',NULL),('14e08c2e-2570-11ee-91d6-a0510b46b473',11,'5c77122f-256f-11ee-91d6-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',3,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-18 15:36:21.189',NULL,'2023-07-18 15:40:17.994','2023-07-18 13:40:17.994',NULL),('15171312-10fa-11ee-b636-a0510b46b473',11,'f8f2e241-10f4-11ee-b636-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',5,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-22 14:41:17.676',NULL,'2023-06-22 14:43:30.003','2023-06-22 12:43:30.003',NULL),('168cd704-1bd2-11ee-9086-a0510b46b473',11,'a6b491c8-1bcf-11ee-9086-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',7,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-06 09:52:43.047',NULL,'2023-07-06 09:55:04.439','2023-07-06 07:55:04.439',NULL),('16d21737-2a3e-11ee-9e90-a0510b46b473',11,'b147bba1-2a36-11ee-9e90-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',6,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-24 18:21:05.427','2023-07-24 18:27:44.658','2023-07-24 18:27:44.659','2023-07-24 16:27:44.660',NULL),('16f3e3bc-e02e-11ed-bb13-00d86184ce3d',11,'ed88a64f-e024-11ed-bb13-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',12,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-21 12:20:07.655',NULL,'2023-04-21 12:20:49.012','2023-04-21 10:20:49.012',NULL),('1734b0eb-1ca4-11ee-997b-a0510b46b473',11,'0701c127-1ca0-11ee-84c4-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',11,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-07 10:55:58.463',NULL,'2023-07-07 10:58:34.370','2023-07-07 08:58:34.370',NULL),('1753b238-262c-11ee-8042-a0510b46b473',11,'6253caa6-261f-11ee-8042-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',9,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-19 14:02:10.684',NULL,'2023-07-19 14:04:28.972','2023-07-19 12:04:28.972',NULL),('17a864a7-1a65-11ee-9a4f-a0510b46b473',11,'9f33e64c-1a64-11ee-9a4f-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',2,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-04 14:19:58.599',NULL,'2023-07-04 14:21:28.733','2023-07-04 12:21:28.733',NULL),('17cddb0e-1cb1-11ee-997b-a0510b46b473',11,'dfb7e00f-1cb0-11ee-997b-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',2,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-07 12:29:02.922',NULL,'2023-07-07 12:30:48.172','2023-07-07 10:30:48.172',NULL),('1a3cdc6a-0f3f-11ee-8712-a0510b46b473',11,'965293c3-0f3e-11ee-8712-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',3,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-20 09:50:19.261',NULL,'2023-06-20 09:52:26.052','2023-06-20 07:52:26.052',NULL),('1a89f0bf-df8c-11ed-b6c2-00d86184ce3d',11,'d50b8b0c-df8b-11ed-b6c2-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-20 17:00:35.201',NULL,'2023-04-20 17:02:17.713','2023-04-20 15:02:17.714',NULL),('1ac586d5-df85-11ed-b6c2-00d86184ce3d',11,'f3d9f61c-df83-11ed-b6c2-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',4,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-20 16:10:29.115',NULL,'2023-04-20 16:12:26.270','2023-04-20 14:12:26.270',NULL),('1acdf7bc-e01d-11ed-a285-00d86184ce3d',11,'65ba9a94-e01a-11ed-b6c2-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',3,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-21 10:18:32.673',NULL,'2023-04-21 10:23:34.214','2023-04-21 08:23:34.214',NULL),('1af0f921-e02c-11ed-bb13-00d86184ce3d',11,'ed88a64f-e024-11ed-bb13-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',10,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-21 12:05:55.353',NULL,'2023-04-21 12:07:37.056','2023-04-21 10:07:37.057',NULL),('1babeeef-1a79-11ee-8124-a0510b46b473',11,'c85af2e9-1a77-11ee-8124-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',4,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-04 16:43:15.268',NULL,'2023-07-04 16:46:21.538','2023-07-04 14:46:21.538',NULL),('20842b51-e01f-11ed-a285-00d86184ce3d',11,'65ba9a94-e01a-11ed-b6c2-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',6,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-21 10:33:01.249',NULL,'2023-04-21 10:35:01.613','2023-04-21 08:35:01.614',NULL),('20a8c9f7-15b6-11ee-b3b1-00d86184ce3d',11,'1ed7780a-15b6-11ee-b3b1-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-28 15:17:27.122',NULL,'2023-06-28 15:19:58.101','2023-06-28 13:19:58.102',NULL),('20ae1b09-1bdc-11ee-9086-a0510b46b473',11,'d30df7f0-1bdb-11ee-9086-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',2,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-06 11:04:35.010',NULL,'2023-07-06 11:06:01.774','2023-07-06 09:06:01.774',NULL),('21ce8315-262a-11ee-8042-a0510b46b473',11,'6253caa6-261f-11ee-8042-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',5,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-19 13:48:09.273',NULL,'2023-07-19 13:50:28.564','2023-07-19 11:50:28.564',NULL),('22b678df-de89-11ed-9cc3-00d86184ce3d',11,'ffdebb3e-de80-11ed-9cc3-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',7,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-19 10:06:49.262',NULL,'2023-04-19 10:08:24.739','2023-04-19 08:08:24.740','2023-04-19 10:08:24.753'),('2303941b-dd04-11ed-8097-00d86184ce3d',11,'610548c3-dcfe-11ed-8097-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',9,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-17 11:42:15.540',NULL,'2023-04-17 11:44:39.742','2023-04-17 09:44:39.743','2023-04-17 11:44:39.763'),('237ac86e-262b-11ee-8042-a0510b46b473',11,'6253caa6-261f-11ee-8042-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',7,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-19 13:55:21.576',NULL,'2023-07-19 13:58:12.712','2023-07-19 11:58:12.712',NULL),('25a75139-26e4-11ee-a836-a0510b46b473',11,'d5f241c9-26e3-11ee-a836-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',2,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-20 11:59:42.118',NULL,'2023-07-20 12:01:57.174','2023-07-20 10:01:57.175',NULL),('25ba4185-15b9-11ee-b3b1-00d86184ce3d',11,'1ed7780a-15b6-11ee-b3b1-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',9,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-28 15:39:04.116',NULL,'2023-06-28 15:42:06.307','2023-06-28 13:42:06.307',NULL),('25d7d863-e355-11ed-8c5e-00d86184ce3d',11,'8541c500-e33f-11ed-8c5e-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',9,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-25 12:37:16.498',NULL,'2023-04-25 12:39:34.855','2023-04-25 10:39:34.856',NULL),('265e16be-e03a-11ed-bb13-00d86184ce3d',11,'63bb1989-e035-11ed-bb13-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',9,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-21 13:46:27.478',NULL,'2023-04-21 13:47:13.273','2023-04-21 11:47:13.273',NULL),('280b0576-e036-11ed-bb13-00d86184ce3d',11,'63bb1989-e035-11ed-bb13-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',2,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-21 13:17:52.302',NULL,'2023-04-21 13:18:47.968','2023-04-21 11:18:47.968',NULL),('2863b54c-0f79-11ee-9460-a0510b46b473',11,'ec7bd8ad-0f72-11ee-8712-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',8,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-20 16:45:53.814',NULL,'2023-06-20 16:46:58.692','2023-06-20 14:46:58.692',NULL),('288ec454-2700-11ee-a98e-a0510b46b473',11,'8f65e2e0-26fd-11ee-a98e-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',6,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-20 15:20:12.899',NULL,'2023-07-20 15:21:29.917','2023-07-20 13:21:29.917',NULL),('28958b14-e03c-11ed-bb13-00d86184ce3d',11,'6f0c3cda-e03a-11ed-bb13-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',8,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-21 14:00:50.190','2023-04-21 14:03:45.440','2023-04-21 14:03:45.440','2023-04-21 12:03:45.442',NULL),('29414f74-10e3-11ee-b636-a0510b46b473',11,'3ae23ec4-10e1-11ee-b636-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',6,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-22 11:57:13.083',NULL,'2023-06-22 11:59:25.261','2023-06-22 09:59:25.261',NULL),('29d886a7-1c0a-11ee-a865-a0510b46b473',11,'bab539ff-1c09-11ee-a865-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',3,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-06 16:34:07.237',NULL,'2023-07-06 16:35:37.518','2023-07-06 14:35:37.518',NULL),('2ab9c9fd-e03f-11ed-bb13-00d86184ce3d',11,'2615e3c8-e03f-11ed-bb13-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-21 14:22:22.273','2023-04-21 14:40:04.714','2023-04-21 14:40:04.714','2023-04-21 12:40:04.715',NULL),('2b3c7dd6-e01e-11ed-a285-00d86184ce3d',11,'65ba9a94-e01a-11ed-b6c2-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',5,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-21 10:26:09.738',NULL,'2023-04-21 10:28:02.698','2023-04-21 08:28:02.698',NULL),('2bf8893b-10e5-11ee-b636-a0510b46b473',11,'68b97a59-10e4-11ee-b636-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',4,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-22 12:11:36.632',NULL,'2023-06-22 12:13:07.353','2023-06-22 10:13:07.354',NULL),('2caf99d1-1a62-11ee-9a4f-a0510b46b473',11,'56e449e9-1a49-11ee-9a4f-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',7,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-04 13:59:05.388',NULL,'2023-07-04 14:01:17.438','2023-07-04 12:01:17.438',NULL),('2d9ffc1f-e353-11ed-8c5e-00d86184ce3d',11,'ea1f514a-e352-11ed-8c5e-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',2,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-25 12:23:10.560',NULL,'2023-04-25 12:24:58.834','2023-04-25 10:24:58.834',NULL),('2da74f58-10db-11ee-b636-a0510b46b473',11,'ea39c2be-10da-11ee-b636-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',2,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-22 11:00:04.488',NULL,'2023-06-22 11:01:39.322','2023-06-22 09:01:39.322',NULL),('2da926ce-0f78-11ee-9460-a0510b46b473',11,'ec7bd8ad-0f72-11ee-8712-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',6,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-20 16:38:53.161',NULL,'2023-06-20 16:42:15.218','2023-06-20 14:42:15.219',NULL),('2dbec3da-10d7-11ee-b636-a0510b46b473',11,'c5e95a7b-10d5-11ee-b636-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',4,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-22 10:31:26.655',NULL,'2023-06-22 10:34:12.280','2023-06-22 08:34:12.280',NULL),('2fdfbb85-1ca2-11ee-84c4-a0510b46b473',11,'0701c127-1ca0-11ee-84c4-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',7,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-07 10:42:20.853',NULL,'2023-07-07 10:44:25.914','2023-07-07 08:44:25.914',NULL),('30c627d2-1a78-11ee-8124-a0510b46b473',11,'c85af2e9-1a77-11ee-8124-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',2,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-04 16:36:41.175',NULL,'2023-07-04 16:39:33.129','2023-07-04 14:39:33.129',NULL),('32674cda-2701-11ee-a98e-a0510b46b473',11,'8f65e2e0-26fd-11ee-a98e-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',9,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-20 15:27:38.914',NULL,'2023-07-20 15:30:28.827','2023-07-20 13:30:28.828',NULL),('339f33af-1105-11ee-b636-a0510b46b473',11,'062b833f-1104-11ee-b636-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',3,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-22 16:00:53.364',NULL,'2023-06-22 16:03:01.824','2023-06-22 14:03:01.825',NULL),('34372189-262d-11ee-8042-a0510b46b473',11,'6253caa6-261f-11ee-8042-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',11,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-19 14:10:08.647',NULL,'2023-07-19 14:12:40.959','2023-07-19 12:12:40.959',NULL),('347289c7-110a-11ee-b636-a0510b46b473',11,'ceb199a7-1107-11ee-b636-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',6,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-22 16:36:42.233',NULL,'2023-06-22 16:39:20.283','2023-06-22 14:39:20.284',NULL),('349dc4a0-26f7-11ee-aa9d-a0510b46b473',11,'cf34c227-26f5-11ee-aa9d-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',4,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-20 14:16:07.659',NULL,'2023-07-20 14:18:21.912','2023-07-20 12:18:21.913',NULL),('34fbc4ca-1bfe-11ee-9323-a0510b46b473',11,'97713d19-1bf9-11ee-9323-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',8,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-06 15:08:31.962',NULL,'2023-07-06 15:11:07.878','2023-07-06 13:11:07.879',NULL),('3579b26b-1ca3-11ee-997b-a0510b46b473',11,'0701c127-1ca0-11ee-84c4-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',9,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-07 10:49:39.748',NULL,'2023-07-07 10:51:35.506','2023-07-07 08:51:35.506',NULL),('3693c57b-26e6-11ee-aa9d-a0510b46b473',11,'d5f241c9-26e3-11ee-a836-a0510b46b473','MANDIBULE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-20 12:14:29.505',NULL,'2023-07-20 12:16:54.951','2023-07-20 10:16:54.952',NULL),('36e57b7e-de98-11ed-9cc3-00d86184ce3d',11,'450efda8-de95-11ed-9cc3-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',4,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-19 11:54:45.575',NULL,'2023-04-19 11:56:58.556','2023-04-19 09:56:58.556',NULL),('37459e1a-1033-11ee-895b-a0510b46b473',11,'e5c7f174-1032-11ee-895b-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',2,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-21 14:57:45.175',NULL,'2023-06-21 14:59:23.120','2023-06-21 12:59:23.120',NULL),('375a5159-1ca8-11ee-997b-a0510b46b473',11,'08b766f9-1ca8-11ee-997b-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',2,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-07 11:25:30.381',NULL,'2023-07-07 11:27:03.448','2023-07-07 09:27:03.448',NULL),('3790bff2-1c07-11ee-9323-a0510b46b473',11,'bb465a1e-1c05-11ee-9323-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',5,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-06 16:13:01.764',NULL,'2023-07-06 16:15:51.710','2023-07-06 14:15:51.710',NULL),('389d6b03-dd03-11ed-8097-00d86184ce3d',11,'610548c3-dcfe-11ed-8097-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',7,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-17 11:35:42.283',NULL,'2023-04-17 11:38:12.569','2023-04-17 09:38:12.569','2023-04-17 11:38:12.581'),('38d97111-1a72-11ee-9594-a0510b46b473',11,'77e234a6-1a6c-11ee-af16-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',5,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-04 15:53:57.743',NULL,'2023-07-04 15:56:22.989','2023-07-04 13:56:22.989',NULL),('3a013dab-2ac2-11ee-80c8-a0510b46b473',11,'3a8b3537-2abf-11ee-80c8-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',8,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-25 10:06:58.024',NULL,'2023-07-25 10:08:13.531','2023-07-25 08:08:13.531',NULL),('3ae69f75-10d6-11ee-b636-a0510b46b473',11,'c5e95a7b-10d5-11ee-b636-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',2,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-22 10:24:39.230',NULL,'2023-06-22 10:26:55.021','2023-06-22 08:26:55.021',NULL),('3b9ca1ce-1bdd-11ee-9086-a0510b46b473',11,'d30df7f0-1bdb-11ee-9086-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',6,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-06 11:12:29.690',NULL,'2023-07-06 11:14:45.352','2023-07-06 09:14:45.353',NULL),('3cbd6cf4-e040-11ed-bb13-00d86184ce3d',11,'2615e3c8-e03f-11ed-bb13-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',4,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-21 14:30:01.993',NULL,'2023-04-21 14:32:38.990','2023-04-21 12:32:38.990',NULL),('3d6b4d06-debb-11ed-9cc3-00d86184ce3d',11,'c2f6aec6-deba-11ed-9cc3-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',2,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-19 16:05:28.904',NULL,'2023-04-19 16:07:31.434','2023-04-19 14:07:31.434',NULL),('3f46983b-1c00-11ee-9323-a0510b46b473',11,'ff6924df-1bff-11ee-9323-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',2,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-06 15:23:08.223',NULL,'2023-07-06 15:24:33.700','2023-07-06 13:24:33.700',NULL),('3fe37f21-0f77-11ee-9460-a0510b46b473',11,'ec7bd8ad-0f72-11ee-8712-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',4,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-20 16:32:14.246',NULL,'2023-06-20 16:35:04.545','2023-06-20 14:35:04.545',NULL),('40918071-10d9-11ee-b636-a0510b46b473',11,'c5e95a7b-10d5-11ee-b636-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',5,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-22 10:46:17.229',NULL,'2023-06-22 10:47:28.803','2023-06-22 08:47:28.803',NULL),('40b9e4ef-e03c-11ed-bb13-00d86184ce3d',11,'6f0c3cda-e03a-11ed-bb13-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',9,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-21 14:01:30.693','2023-04-21 14:04:10.924','2023-04-21 14:04:10.924','2023-04-21 12:04:10.926',NULL),('4133bf78-1a66-11ee-9a4f-a0510b46b473',11,'31a0a20e-1a66-11ee-9a4f-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-04 14:28:17.796',NULL,'2023-07-04 14:29:46.595','2023-07-04 12:29:46.596',NULL),('41937fc5-2621-11ee-8042-a0510b46b473',11,'6253caa6-261f-11ee-8042-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',4,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-19 12:44:37.102',NULL,'2023-07-19 12:47:23.297','2023-07-19 10:47:23.298',NULL),('41ffc1c9-1a61-11ee-9a4f-a0510b46b473',11,'56e449e9-1a49-11ee-9a4f-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',5,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-04 13:52:31.649',NULL,'2023-07-04 13:55:11.451','2023-07-04 11:55:11.451',NULL),('42a16325-de8a-11ed-9cc3-00d86184ce3d',11,'ffdebb3e-de80-11ed-9cc3-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',8,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-19 10:14:52.308',NULL,'2023-04-19 10:16:16.894','2023-04-19 08:16:16.894',NULL),('42e42822-2630-11ee-81dd-a0510b46b473',11,'6253caa6-261f-11ee-8042-a0510b46b473','MANDIBULE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-19 14:32:01.760',NULL,'2023-07-19 14:33:52.426','2023-07-19 12:33:52.426',NULL),('44bdecc8-e03a-11ed-bb13-00d86184ce3d',11,'63bb1989-e035-11ed-bb13-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',10,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-21 13:47:18.437',NULL,'2023-04-21 13:48:01.246','2023-04-21 11:48:01.246',NULL),('4582d779-14e4-11ee-b3b1-00d86184ce3d',11,'efcf357e-14e3-11ee-b3b1-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',2,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-27 14:15:14.636',NULL,'2023-06-27 14:17:37.885','2023-06-27 12:17:37.885',NULL),('463f194b-df7e-11ed-b6c2-00d86184ce3d',11,'85925fd9-de94-11ed-9cc3-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',5,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-20 15:21:35.576',NULL,'2023-04-20 15:23:51.509','2023-04-20 13:23:51.510',NULL),('474674d0-dd08-11ed-8097-00d86184ce3d',11,'610548c3-dcfe-11ed-8097-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',13,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-17 12:11:54.363',NULL,'2023-04-17 12:13:28.514','2023-04-17 10:13:28.514','2023-04-17 12:13:28.527'),('47c015dc-1bfd-11ee-9323-a0510b46b473',11,'97713d19-1bf9-11ee-9323-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',6,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-06 15:01:53.951',NULL,'2023-07-06 15:04:25.943','2023-07-06 13:04:25.944',NULL),('47dc7833-1c08-11ee-a865-a0510b46b473',11,'bb465a1e-1c05-11ee-9323-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',7,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-06 16:20:38.601',NULL,'2023-07-06 16:22:58.090','2023-07-06 14:22:58.091',NULL),('47f46fd5-1c09-11ee-a865-a0510b46b473',11,'bb465a1e-1c05-11ee-9323-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',10,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-06 16:27:48.255',NULL,'2023-07-06 16:30:16.198','2023-07-06 14:30:16.198',NULL),('47f6b127-10e1-11ee-b636-a0510b46b473',11,'3ae23ec4-10e1-11ee-b636-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-22 11:43:45.611',NULL,'2023-06-22 11:45:58.592','2023-06-22 09:45:58.592',NULL),('4816cca9-1bd1-11ee-9086-a0510b46b473',11,'a6b491c8-1bcf-11ee-9086-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',5,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-06 09:46:56.663',NULL,'2023-07-06 09:49:17.338','2023-07-06 07:49:17.339',NULL),('482a8087-10e2-11ee-b636-a0510b46b473',11,'3ae23ec4-10e1-11ee-b636-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',4,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-22 11:50:55.446',NULL,'2023-06-22 11:53:14.692','2023-06-22 09:53:14.693',NULL),('48497064-2ae6-11ee-95bc-a0510b46b473',11,'b6012772-2ae0-11ee-95bc-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',7,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-25 14:25:03.868',NULL,'2023-07-25 14:26:43.323','2023-07-25 12:26:43.323',NULL),('4852c1dc-270a-11ee-a98e-a0510b46b473',11,'c2900beb-2706-11ee-a98e-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',6,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-20 16:32:41.160',NULL,'2023-07-20 16:35:47.125','2023-07-20 14:35:47.125',NULL),('4854d445-2ae9-11ee-97fa-a0510b46b473',11,'8b789858-2ae7-11ee-97fa-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',3,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-25 14:46:32.433',NULL,'2023-07-25 14:48:19.755','2023-07-25 12:48:19.755',NULL),('488d704f-2ae5-11ee-95bc-a0510b46b473',11,'b6012772-2ae0-11ee-95bc-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',4,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-25 14:17:54.817',NULL,'2023-07-25 14:19:11.548','2023-07-25 12:19:11.549',NULL),('4891c8ec-10f9-11ee-b636-a0510b46b473',11,'f8f2e241-10f4-11ee-b636-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',3,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-22 14:35:34.548',NULL,'2023-06-22 14:38:06.182','2023-06-22 12:38:06.182',NULL),('48f0dbce-dd05-11ed-8097-00d86184ce3d',11,'610548c3-dcfe-11ed-8097-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',11,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-17 11:50:28.667',NULL,'2023-04-17 11:52:32.938','2023-04-17 09:52:32.938','2023-04-17 11:52:32.950'),('4abfd2f6-1108-11ee-b636-a0510b46b473',11,'ceb199a7-1107-11ee-b636-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',3,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-22 16:23:00.656',NULL,'2023-06-22 16:25:02.360','2023-06-22 14:25:02.360',NULL),('4b836789-1cad-11ee-997b-a0510b46b473',11,'4a624109-1cad-11ee-997b-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-07 12:01:51.688',NULL,'2023-07-07 12:03:44.763','2023-07-07 10:03:44.764',NULL),('4bb8140e-26e1-11ee-a836-a0510b46b473',11,'78d4144f-26e0-11ee-a836-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',3,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-20 11:39:17.491',NULL,'2023-07-20 11:41:38.101','2023-07-20 09:41:38.101',NULL),('4c414b2c-2ac4-11ee-80c8-a0510b46b473',11,'3a8b3537-2abf-11ee-80c8-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',11,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-25 10:21:47.637',NULL,'2023-07-25 10:23:16.941','2023-07-25 08:23:16.942',NULL),('4d4c0ace-14e7-11ee-b3b1-00d86184ce3d',11,'efcf357e-14e3-11ee-b3b1-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',7,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-27 14:36:56.189',NULL,'2023-06-27 14:39:49.490','2023-06-27 12:39:49.491',NULL),('4d7b2f1f-15b7-11ee-b3b1-00d86184ce3d',11,'1ed7780a-15b6-11ee-b3b1-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',4,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-28 15:25:51.818',NULL,'2023-06-28 15:28:18.439','2023-06-28 13:28:18.439',NULL),('4dd147e4-1cb0-11ee-997b-a0510b46b473',11,'4a624109-1cad-11ee-997b-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',7,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-07 12:23:24.044',NULL,'2023-07-07 12:26:43.906','2023-07-07 10:26:43.906',NULL),('4ebf8a4b-2a3e-11ee-9e90-a0510b46b473',11,'b147bba1-2a36-11ee-9e90-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',7,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-24 18:22:39.257','2023-07-24 18:24:59.052','2023-07-24 18:24:59.053','2023-07-24 16:24:59.054',NULL),('4f5385fc-26fa-11ee-a98e-a0510b46b473',11,'4deac8dd-26fa-11ee-a98e-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-20 14:38:20.963',NULL,'2023-07-20 14:39:54.028','2023-07-20 12:39:54.028',NULL),('50050eb2-2703-11ee-a98e-a0510b46b473',11,'8f65e2e0-26fd-11ee-a98e-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',12,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-20 15:42:47.595',NULL,'2023-07-20 15:46:15.508','2023-07-20 13:46:15.508',NULL),('50156bf7-158a-11ee-b3b1-00d86184ce3d',11,'6ea0d9b2-1587-11ee-b3b1-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',4,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-28 10:03:48.831',NULL,'2023-06-28 10:05:45.655','2023-06-28 08:05:45.655',NULL),('5062a95e-15bf-11ee-a062-a0510b46b473',11,'c41a4d8e-15ba-11ee-b3b1-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',5,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-28 16:23:12.664',NULL,'2023-06-28 16:25:02.388','2023-06-28 14:25:02.388',NULL),('50d73e18-2aeb-11ee-97fa-a0510b46b473',11,'4ff4b712-2aeb-11ee-97fa-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-25 15:01:05.704',NULL,'2023-07-25 15:03:09.970','2023-07-25 13:03:09.971',NULL),('50e7bd0c-1fe9-11ee-b7d5-a0510b46b473',11,'775bad6c-1fe8-11ee-b7d5-a0510b46b473','MANDIBULE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-11 14:49:04.027',NULL,'2023-07-11 14:50:33.558','2023-07-11 12:50:33.558',NULL),('51038fc0-10fc-11ee-b636-a0510b46b473',11,'8cbde682-10fb-11ee-b636-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',4,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-22 14:57:17.205',NULL,'2023-06-22 14:58:51.993','2023-06-22 12:58:51.993',NULL),('520b9fb7-0f79-11ee-9460-a0510b46b473',11,'ec7bd8ad-0f72-11ee-8712-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',9,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-20 16:47:03.701',NULL,'2023-06-20 16:49:42.221','2023-06-20 14:49:42.221',NULL),('52d8ee2b-e341-11ed-8c5e-00d86184ce3d',11,'8541c500-e33f-11ed-8c5e-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',3,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-25 10:15:22.068',NULL,'2023-04-25 10:21:04.718','2023-04-25 08:21:04.718',NULL),('530a16a3-1107-11ee-b636-a0510b46b473',11,'062b833f-1104-11ee-b636-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',8,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-22 16:16:05.067',NULL,'2023-06-22 16:17:59.834','2023-06-22 14:17:59.834',NULL),('53a2d93e-1bd0-11ee-9086-a0510b46b473',11,'a6b491c8-1bcf-11ee-9086-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',3,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-06 09:40:06.539',NULL,'2023-07-06 09:42:36.188','2023-07-06 07:42:36.188',NULL),('54635134-2702-11ee-a98e-a0510b46b473',11,'8f65e2e0-26fd-11ee-a98e-a0510b46b473','MANDIBULE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-20 15:35:45.427','2023-07-20 15:37:50.694','2023-07-20 15:37:50.695','2023-07-20 13:37:50.699',NULL),('5533f819-e043-11ed-bb13-00d86184ce3d',11,'5a5d89b2-e042-11ed-bb13-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',3,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-21 14:52:11.525',NULL,'2023-04-21 14:54:10.646','2023-04-21 12:54:10.646',NULL),('55354f88-1104-11ee-b636-a0510b46b473',11,'062b833f-1104-11ee-b636-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-22 15:54:40.216',NULL,'2023-06-22 15:57:41.872','2023-06-22 13:57:41.873',NULL),('55708cfc-e010-11ed-b6c2-00d86184ce3d',11,'85925fd9-de94-11ed-9cc3-00d86184ce3d','MANDIBULE','SCAN',1,'NONE',2,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-21 08:47:07.589',NULL,'2023-04-21 08:48:55.967','2023-04-21 06:48:55.968',NULL),('5608c4ca-0f41-11ee-8712-a0510b46b473',11,'550492f3-0f41-11ee-8712-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-20 10:06:18.577',NULL,'2023-06-20 10:08:37.406','2023-06-20 08:08:37.406',NULL),('56105016-2aea-11ee-97fa-a0510b46b473',11,'8b789858-2ae7-11ee-97fa-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',6,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-25 14:54:04.968',NULL,'2023-07-25 14:55:46.264','2023-07-25 12:55:46.265',NULL),('5633d33f-de99-11ed-9cc3-00d86184ce3d',11,'450efda8-de95-11ed-9cc3-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',6,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-19 12:02:47.595',NULL,'2023-04-19 12:05:26.594','2023-04-19 10:05:26.594',NULL),('56b2e06a-e351-11ed-8c5e-00d86184ce3d',11,'71bbf096-e350-11ed-8c5e-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',4,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-25 12:10:00.477',NULL,'2023-04-25 12:12:33.571','2023-04-25 10:12:33.571',NULL),('5737fef3-10da-11ee-b636-a0510b46b473',11,'c5e95a7b-10d5-11ee-b636-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',7,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-22 10:54:04.726',NULL,'2023-06-22 10:56:52.632','2023-06-22 08:56:52.633',NULL),('5749fe3e-e349-11ed-8c5e-00d86184ce3d',11,'a0febadb-e348-11ed-8c5e-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',3,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-25 11:12:45.493',NULL,'2023-04-25 11:15:00.611','2023-04-25 09:15:00.611',NULL),('57977916-dd01-11ed-8097-00d86184ce3d',11,'610548c3-dcfe-11ed-8097-00d86184ce3d','MANDIBULE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-17 11:22:15.260',NULL,'2023-04-17 11:26:19.107','2023-04-17 09:26:19.107','2023-04-17 11:26:19.123'),('581eb6dc-14c7-11ee-b3b1-00d86184ce3d',11,'961d56b4-14c3-11ee-b3b1-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',4,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-27 10:48:10.452',NULL,'2023-06-27 10:50:30.687','2023-06-27 08:50:30.687',NULL),('59311257-270b-11ee-a98e-a0510b46b473',11,'c2900beb-2706-11ee-a98e-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',8,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-20 16:40:18.957',NULL,'2023-07-20 16:43:13.058','2023-07-20 14:43:13.058',NULL),('59748b5e-1bff-11ee-9323-a0510b46b473',11,'97713d19-1bf9-11ee-9323-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',11,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-06 15:16:42.648',NULL,'2023-07-06 15:19:01.935','2023-07-06 13:19:01.935',NULL),('5a0453ee-df84-11ed-b6c2-00d86184ce3d',11,'f3d9f61c-df83-11ed-b6c2-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',2,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-20 16:05:05.726',NULL,'2023-04-20 16:07:49.682','2023-04-20 14:07:49.682',NULL),('5a4a9396-1a7a-11ee-8124-a0510b46b473',11,'c85af2e9-1a77-11ee-8124-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',7,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-04 16:52:09.823',NULL,'2023-07-04 16:55:09.737','2023-07-04 14:55:09.737',NULL),('5ad1c88c-df82-11ed-b6c2-00d86184ce3d',11,'b21241b0-df81-11ed-b6c2-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',2,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-20 15:50:48.079',NULL,'2023-04-20 15:53:11.085','2023-04-20 13:53:11.086',NULL),('5ae77078-26f6-11ee-aa9d-a0510b46b473',11,'cf34c227-26f5-11ee-aa9d-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',2,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-20 14:10:02.400',NULL,'2023-07-20 14:12:01.971','2023-07-20 12:12:01.971',NULL),('5af4daa3-2579-11ee-b81b-a0510b46b473',11,'f584e68a-2576-11ee-b81b-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',5,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-18 16:42:44.233',NULL,'2023-07-18 16:45:46.476','2023-07-18 14:45:46.476',NULL),('5b0d4628-2709-11ee-a98e-a0510b46b473',11,'c2900beb-2706-11ee-a98e-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',4,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-20 16:26:03.085',NULL,'2023-07-20 16:28:27.364','2023-07-20 14:28:27.364',NULL),('5b28b216-e042-11ed-bb13-00d86184ce3d',11,'5a5d89b2-e042-11ed-bb13-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-21 14:45:12.021',NULL,'2023-04-21 14:47:17.474','2023-04-21 12:47:17.474',NULL),('5b848959-1bda-11ee-9086-a0510b46b473',11,'a0a77bfe-1bd8-11ee-9086-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',3,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-06 10:51:54.729',NULL,'2023-07-06 10:54:34.009','2023-07-06 08:54:34.009',NULL),('5b9d68ab-15b8-11ee-b3b1-00d86184ce3d',11,'1ed7780a-15b6-11ee-b3b1-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',7,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-28 15:33:25.027',NULL,'2023-06-28 15:35:38.958','2023-06-28 13:35:38.959',NULL),('5b9f63fb-e344-11ed-8c5e-00d86184ce3d',11,'8541c500-e33f-11ed-8c5e-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',7,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-25 10:37:05.280',NULL,'2023-04-25 10:39:28.993','2023-04-25 08:39:28.993',NULL),('5bd91ebd-1bdb-11ee-9086-a0510b46b473',11,'a0a77bfe-1bd8-11ee-9086-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',5,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-06 10:59:04.780',NULL,'2023-07-06 11:02:07.084','2023-07-06 09:02:07.085',NULL),('5bfb0286-e02e-11ed-bb13-00d86184ce3d',11,'ed88a64f-e024-11ed-bb13-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',13,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-21 12:22:03.464',NULL,'2023-04-21 12:25:49.153','2023-04-21 10:25:49.154',NULL),('5c533d2c-e34b-11ed-8c5e-00d86184ce3d',11,'d6fcc5ab-e34a-11ed-8c5e-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',2,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-25 11:27:12.936',NULL,'2023-04-25 11:29:01.261','2023-04-25 09:29:01.261',NULL),('5c724fe5-1bdc-11ee-9086-a0510b46b473',11,'d30df7f0-1bdb-11ee-9086-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',3,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-06 11:06:15.281',NULL,'2023-07-06 11:07:54.015','2023-07-06 09:07:54.015',NULL),('5d4ad9a4-2ac1-11ee-80c8-a0510b46b473',11,'3a8b3537-2abf-11ee-80c8-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',5,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-25 10:00:47.730',NULL,'2023-07-25 10:02:24.906','2023-07-25 08:02:24.906',NULL),('5d6835c8-e041-11ed-bb13-00d86184ce3d',11,'2615e3c8-e03f-11ed-bb13-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',6,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-21 14:38:06.296','2023-04-21 14:39:57.459','2023-04-21 14:39:57.460','2023-04-21 12:39:57.461',NULL),('5d6d930c-1a70-11ee-9a4e-a0510b46b473',11,'77e234a6-1a6c-11ee-af16-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',2,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-04 15:40:40.118',NULL,'2023-07-04 15:42:47.373','2023-07-04 13:42:47.373',NULL),('5d93ab2a-2578-11ee-b81b-a0510b46b473',11,'f584e68a-2576-11ee-b81b-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',3,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-18 16:35:39.132',NULL,'2023-07-18 16:36:10.248','2023-07-18 14:36:10.248',NULL),('5df04335-256f-11ee-91d6-a0510b46b473',11,'5c77122f-256f-11ee-91d6-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-18 15:31:14.269','2023-07-18 15:33:06.035','2023-07-18 15:33:06.036','2023-07-18 13:33:06.037',NULL),('5e667c52-1106-11ee-b636-a0510b46b473',11,'062b833f-1104-11ee-b636-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',6,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-22 16:09:14.631',NULL,'2023-06-22 16:11:33.752','2023-06-22 14:11:33.752',NULL),('5e679fd4-26fe-11ee-a98e-a0510b46b473',11,'8f65e2e0-26fd-11ee-a98e-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',3,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-20 15:07:24.246',NULL,'2023-07-20 15:09:59.663','2023-07-20 13:09:59.664',NULL),('5eb8cdd7-1a60-11ee-9a4f-a0510b46b473',11,'56e449e9-1a49-11ee-9a4f-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',3,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-04 13:46:10.341',NULL,'2023-07-04 13:48:10.649','2023-07-04 11:48:10.649',NULL),('5f5fa83b-0f42-11ee-8712-a0510b46b473',11,'550492f3-0f41-11ee-8712-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',4,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-20 10:13:43.742',NULL,'2023-06-20 10:15:12.466','2023-06-20 08:15:12.466',NULL),('5f91c0b6-df8c-11ed-b6c2-00d86184ce3d',11,'d50b8b0c-df8b-11ed-b6c2-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',2,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-20 17:02:31.015',NULL,'2023-04-20 17:04:38.819','2023-04-20 15:04:38.820',NULL),('602f9914-14cc-11ee-b3b1-00d86184ce3d',11,'5f53d32e-14cc-11ee-b3b1-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-27 11:24:11.468',NULL,'2023-06-27 11:25:53.232','2023-06-27 09:25:53.232',NULL),('6062d660-de97-11ed-9cc3-00d86184ce3d',11,'450efda8-de95-11ed-9cc3-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',3,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-19 11:48:45.687',NULL,'2023-04-19 11:51:14.549','2023-04-19 09:51:14.549',NULL),('620f86ab-262f-11ee-81dd-a0510b46b473',11,'ab88338c-262e-11ee-81dd-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',3,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-19 14:25:44.556',NULL,'2023-07-19 14:27:12.686','2023-07-19 12:27:12.687',NULL),('626e3c07-1a49-11ee-9a4f-a0510b46b473',11,'56e449e9-1a49-11ee-9a4f-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-04 11:01:38.139',NULL,'2023-07-04 11:03:39.485','2023-07-04 09:03:39.485',NULL),('63d415ce-1cb1-11ee-997b-a0510b46b473',11,'dfb7e00f-1cb0-11ee-997b-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',3,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-07 12:31:10.469',NULL,'2023-07-07 12:32:34.141','2023-07-07 10:32:34.141',NULL),('63ff2cb1-261f-11ee-8042-a0510b46b473',11,'6253caa6-261f-11ee-8042-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-19 12:31:15.857','2023-07-19 12:33:11.621','2023-07-19 12:33:11.621','2023-07-19 10:33:11.623',NULL),('642fea87-dd00-11ed-8097-00d86184ce3d',11,'610548c3-dcfe-11ed-8097-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',4,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-17 11:15:26.895',NULL,'2023-04-17 11:17:50.254','2023-04-17 09:17:50.254','2023-04-17 11:17:50.266'),('644096f1-1c0a-11ee-a865-a0510b46b473',11,'bab539ff-1c09-11ee-a865-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',4,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-06 16:35:45.228',NULL,'2023-07-06 16:37:19.005','2023-07-06 14:37:19.005',NULL),('644b1c1f-14cd-11ee-b3b1-00d86184ce3d',11,'5f53d32e-14cc-11ee-b3b1-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',3,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-27 11:31:27.856',NULL,'2023-06-27 11:33:05.221','2023-06-27 09:33:05.221',NULL),('64866cf1-deb5-11ed-9cc3-00d86184ce3d',11,'d7775a50-deb2-11ed-9cc3-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',6,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-19 15:23:37.533',NULL,'2023-04-19 15:31:27.720','2023-04-19 13:31:27.720',NULL),('64d1deb3-dcfe-11ed-8097-00d86184ce3d',11,'610548c3-dcfe-11ed-8097-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-17 11:01:08.963',NULL,'2023-04-17 11:03:50.651','2023-04-17 09:03:50.651','2023-04-17 11:03:50.665'),('653a8ba5-1ca1-11ee-84c4-a0510b46b473',11,'0701c127-1ca0-11ee-84c4-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',5,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-07 10:36:40.871',NULL,'2023-07-07 10:39:18.613','2023-07-07 08:39:18.613',NULL),('6558b252-2631-11ee-81dd-a0510b46b473',11,'6253caa6-261f-11ee-8042-a0510b46b473','MANDIBULE','SCAN',1,'NONE',4,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-19 14:40:09.063',NULL,'2023-07-19 14:42:11.576','2023-07-19 12:42:11.576',NULL),('65a537c4-2700-11ee-a98e-a0510b46b473',11,'8f65e2e0-26fd-11ee-a98e-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',7,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-20 15:21:55.387',NULL,'2023-07-20 15:24:05.515','2023-07-20 13:24:05.515',NULL),('66624caf-2ae8-11ee-97fa-a0510b46b473',11,'8b789858-2ae7-11ee-97fa-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',2,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-25 14:40:13.356',NULL,'2023-07-25 14:42:11.571','2023-07-25 12:42:11.571',NULL),('669cae3d-2577-11ee-b81b-a0510b46b473',11,'f584e68a-2576-11ee-b81b-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-18 16:28:44.794',NULL,'2023-07-18 16:32:29.191','2023-07-18 14:32:29.191',NULL),('66b1d8bf-0f40-11ee-8712-a0510b46b473',11,'965293c3-0f3e-11ee-8712-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',6,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-20 09:59:37.032',NULL,'2023-06-20 10:02:02.642','2023-06-20 08:02:02.643',NULL),('67550aab-2ac5-11ee-80c8-a0510b46b473',11,'3a8b3537-2abf-11ee-80c8-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',15,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-25 10:29:42.561',NULL,'2023-07-25 10:31:23.938','2023-07-25 08:31:23.938',NULL),('67bd6aa9-e03d-11ed-bb13-00d86184ce3d',11,'6f0c3cda-e03a-11ed-bb13-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',13,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-21 14:09:45.644',NULL,'2023-04-21 14:10:34.601','2023-04-21 12:10:34.601',NULL),('67c4bd75-e038-11ed-bb13-00d86184ce3d',11,'63bb1989-e035-11ed-bb13-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',6,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-21 13:33:58.209',NULL,'2023-04-21 13:36:10.650','2023-04-21 11:36:10.650',NULL),('67cc1e2d-14e6-11ee-b3b1-00d86184ce3d',11,'efcf357e-14e3-11ee-b3b1-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',6,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-27 14:30:31.153',NULL,'2023-06-27 14:34:01.532','2023-06-27 12:34:01.533',NULL),('67d1c368-1bfa-11ee-9323-a0510b46b473',11,'97713d19-1bf9-11ee-9323-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',3,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-06 14:41:19.263',NULL,'2023-07-06 14:43:42.454','2023-07-06 12:43:42.454',NULL),('67f7dd8f-deb4-11ed-9cc3-00d86184ce3d',11,'d7775a50-deb2-11ed-9cc3-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',4,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-19 15:16:33.813',NULL,'2023-04-19 15:19:39.533','2023-04-19 13:19:39.533',NULL),('682dc48b-e34e-11ed-8c5e-00d86184ce3d',11,'6058594e-e34e-11ed-8c5e-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-25 11:49:01.313',NULL,'2023-04-25 11:51:25.920','2023-04-25 09:51:25.920',NULL),('695dc75c-10e4-11ee-b636-a0510b46b473',11,'68b97a59-10e4-11ee-b636-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-22 12:06:10.142',NULL,'2023-06-22 12:07:30.775','2023-06-22 10:07:30.776',NULL),('6a0b0e2b-2620-11ee-8042-a0510b46b473',11,'6253caa6-261f-11ee-8042-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',3,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-19 12:38:35.498',NULL,'2023-07-19 12:41:17.842','2023-07-19 10:41:17.843',NULL),('6a0d9a25-e34a-11ed-8c5e-00d86184ce3d',11,'a0febadb-e348-11ed-8c5e-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',6,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-25 11:20:26.471',NULL,'2023-04-25 11:22:43.088','2023-04-25 09:22:43.088',NULL),('6a385516-1ca0-11ee-84c4-a0510b46b473',11,'0701c127-1ca0-11ee-84c4-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',2,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-07 10:29:39.748',NULL,'2023-07-07 10:31:50.379','2023-07-07 08:31:50.379',NULL),('6aa55fd6-deb3-11ed-9cc3-00d86184ce3d',11,'d7775a50-deb2-11ed-9cc3-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',2,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-19 15:09:28.809',NULL,'2023-04-19 15:12:16.622','2023-04-19 13:12:16.622',NULL),('6aaf129f-10db-11ee-b636-a0510b46b473',11,'ea39c2be-10da-11ee-b636-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',3,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-22 11:01:46.880',NULL,'2023-06-22 11:03:33.731','2023-06-22 09:03:33.732',NULL),('6c1dd994-1035-11ee-895b-a0510b46b473',11,'689aa1f3-1035-11ee-895b-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-21 15:13:32.827',NULL,'2023-06-21 15:15:30.425','2023-06-21 13:15:30.425',NULL),('6c45dfd0-e352-11ed-8c5e-00d86184ce3d',11,'71bbf096-e350-11ed-8c5e-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',7,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-25 12:17:46.169',NULL,'2023-04-25 12:19:50.832','2023-04-25 10:19:50.833',NULL),('6c9f3e6e-1caf-11ee-997b-a0510b46b473',11,'4a624109-1cad-11ee-997b-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',5,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-07 12:17:06.229',NULL,'2023-07-07 12:19:26.761','2023-07-07 10:19:26.762',NULL),('6d249f21-e02b-11ed-bb13-00d86184ce3d',11,'ed88a64f-e024-11ed-bb13-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',8,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-21 12:01:03.768',NULL,'2023-04-21 12:01:38.583','2023-04-21 10:01:38.583',NULL),('6d4e7407-1bd2-11ee-9086-a0510b46b473',11,'a6b491c8-1bcf-11ee-9086-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',8,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-06 09:55:08.600',NULL,'2023-07-06 09:58:13.842','2023-07-06 07:58:13.842',NULL),('6e80bcc9-14c6-11ee-b3b1-00d86184ce3d',11,'961d56b4-14c3-11ee-b3b1-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',2,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-27 10:41:38.507',NULL,'2023-06-27 10:45:11.511','2023-06-27 08:45:11.512',NULL),('6ea74874-10f6-11ee-b636-a0510b46b473',11,'85925fd9-de94-11ed-9cc3-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',9,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-22 14:15:09.952',NULL,'2023-06-22 14:15:50.578','2023-06-22 12:15:50.579',NULL),('70a7e0a4-2ae1-11ee-95bc-a0510b46b473',11,'b6012772-2ae0-11ee-95bc-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',2,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-25 13:50:24.112',NULL,'2023-07-25 13:52:07.872','2023-07-25 11:52:07.872',NULL),('70d3caa1-1c06-11ee-9323-a0510b46b473',11,'bb465a1e-1c05-11ee-9323-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',3,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-06 16:07:28.337',NULL,'2023-07-06 16:09:43.312','2023-07-06 14:09:43.312',NULL),('70de37ee-e03a-11ed-bb13-00d86184ce3d',11,'6f0c3cda-e03a-11ed-bb13-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-21 13:48:32.469','2023-04-21 13:49:17.756','2023-04-21 13:49:17.756','2023-04-21 11:49:17.758',NULL),('7221bbba-e025-11ed-bb13-00d86184ce3d',11,'ed88a64f-e024-11ed-bb13-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',2,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-21 11:18:15.158',NULL,'2023-04-21 11:20:36.364','2023-04-21 09:20:36.364',NULL),('72927001-26e5-11ee-a836-a0510b46b473',11,'d5f241c9-26e3-11ee-a836-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',5,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-20 12:09:00.663',NULL,'2023-07-20 12:11:09.635','2023-07-20 10:11:09.635',NULL),('7327c66d-e350-11ed-8c5e-00d86184ce3d',11,'71bbf096-e350-11ed-8c5e-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-25 12:03:38.723',NULL,'2023-04-25 12:05:44.159','2023-04-25 10:05:44.160',NULL),('73724c33-1ca8-11ee-997b-a0510b46b473',11,'08b766f9-1ca8-11ee-997b-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',3,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-07 11:27:11.201',NULL,'2023-07-07 11:28:27.673','2023-07-07 09:28:27.673',NULL),('741d1c09-1c00-11ee-9323-a0510b46b473',11,'ff6924df-1bff-11ee-9323-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',3,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-06 15:24:36.870',NULL,'2023-07-06 15:26:11.345','2023-07-06 13:26:11.345',NULL),('74f81308-e353-11ed-8c5e-00d86184ce3d',11,'ea1f514a-e352-11ed-8c5e-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',3,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-25 12:25:10.256',NULL,'2023-04-25 12:26:52.606','2023-04-25 10:26:52.607',NULL),('75255547-e356-11ed-8c5e-00d86184ce3d',11,'8541c500-e33f-11ed-8c5e-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',12,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-25 12:46:39.042',NULL,'2023-04-25 12:48:00.651','2023-04-25 10:48:00.651',NULL),('75b380d5-10fa-11ee-b636-a0510b46b473',11,'f8f2e241-10f4-11ee-b636-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',6,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-22 14:43:59.763',NULL,'2023-06-22 14:46:24.567','2023-06-22 12:46:24.568',NULL),('75ebc91b-e354-11ed-8c5e-00d86184ce3d',11,'71bbf096-e350-11ed-8c5e-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',8,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-25 12:32:21.349',NULL,'2023-04-25 12:34:25.269','2023-04-25 10:34:25.270',NULL),('760ddbfd-1bfb-11ee-9323-a0510b46b473',11,'97713d19-1bf9-11ee-9323-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',5,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-06 14:48:52.642',NULL,'2023-07-06 14:52:00.016','2023-07-06 12:52:00.016',NULL),('76c59fd3-2578-11ee-b81b-a0510b46b473',11,'f584e68a-2576-11ee-b81b-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',4,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-18 16:36:21.403',NULL,'2023-07-18 16:37:23.350','2023-07-18 14:37:23.350',NULL),('77868fcd-e02c-11ed-bb13-00d86184ce3d',11,'ed88a64f-e024-11ed-bb13-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',11,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-21 12:08:30.684',NULL,'2023-04-21 12:09:34.226','2023-04-21 10:09:34.226',NULL),('787588b3-1a76-11ee-8124-a0510b46b473',11,'76fc311b-1a76-11ee-8124-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-04 16:24:22.451',NULL,'2023-07-04 16:26:32.409','2023-07-04 14:26:32.409',NULL),('78780086-2ae5-11ee-95bc-a0510b46b473',11,'b6012772-2ae0-11ee-95bc-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',5,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-25 14:19:15.207',NULL,'2023-07-25 14:20:55.397','2023-07-25 12:20:55.397',NULL),('792cf404-e01e-11ed-a285-00d86184ce3d',11,'65ba9a94-e01a-11ed-b6c2-00d86184ce3d','MANDIBULE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-21 10:28:20.498',NULL,'2023-04-21 10:30:31.890','2023-04-21 08:30:31.890',NULL),('79325a91-1a6c-11ee-af16-a0510b46b473',11,'77e234a6-1a6c-11ee-af16-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-04 15:12:48.719',NULL,'2023-07-04 15:17:21.731','2023-07-04 13:17:21.732',NULL),('799d201d-1a65-11ee-9a4f-a0510b46b473',11,'9f33e64c-1a64-11ee-9a4f-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',3,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-04 14:22:42.942',NULL,'2023-07-04 14:24:17.582','2023-07-04 12:24:17.583',NULL),('7b5be28c-de95-11ed-9cc3-00d86184ce3d',11,'450efda8-de95-11ed-9cc3-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-19 11:35:11.946',NULL,'2023-04-19 11:37:31.259','2023-04-19 09:37:31.260',NULL),('7b6720a5-e020-11ed-a285-00d86184ce3d',11,'65ba9a94-e01a-11ed-b6c2-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',8,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-21 10:42:43.228',NULL,'2023-04-21 10:45:56.389','2023-04-21 08:45:56.390',NULL),('7b6c0c01-10f8-11ee-b636-a0510b46b473',11,'f8f2e241-10f4-11ee-b636-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-22 14:29:50.369',NULL,'2023-06-22 14:32:31.709','2023-06-22 12:32:31.709',NULL),('7b79f25a-de8a-11ed-9cc3-00d86184ce3d',11,'ffdebb3e-de80-11ed-9cc3-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',9,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-19 10:16:27.679',NULL,'2023-04-19 10:19:12.484','2023-04-19 08:19:12.485',NULL),('7ccbaae8-de86-11ed-9cc3-00d86184ce3d',11,'ffdebb3e-de80-11ed-9cc3-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',4,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-19 09:47:51.906',NULL,'2023-04-19 09:50:25.472','2023-04-19 07:50:25.473','2023-04-19 09:50:25.489'),('7ea52c01-14c8-11ee-b3b1-00d86184ce3d',11,'961d56b4-14c3-11ee-b3b1-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',5,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-27 10:56:24.583',NULL,'2023-06-27 10:59:18.863','2023-06-27 08:59:18.863',NULL),('803c4f10-0f3f-11ee-8712-a0510b46b473',11,'965293c3-0f3e-11ee-8712-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',4,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-20 09:53:10.385',NULL,'2023-06-20 09:56:11.731','2023-06-20 07:56:11.732',NULL),('80977c83-2abf-11ee-80c8-a0510b46b473',11,'3a8b3537-2abf-11ee-80c8-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-25 09:47:27.959','2023-07-25 09:49:07.612','2023-07-25 09:49:07.613','2023-07-25 07:49:07.614',NULL),('80d0087a-15b6-11ee-b3b1-00d86184ce3d',11,'1ed7780a-15b6-11ee-b3b1-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',2,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-28 15:20:08.441',NULL,'2023-06-28 15:22:28.960','2023-06-28 13:22:28.960',NULL),('80f823c7-2a39-11ee-9e90-a0510b46b473',11,'b147bba1-2a36-11ee-9e90-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',4,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-24 17:48:16.031','2023-07-24 18:27:28.634','2023-07-24 18:27:28.635','2023-07-24 16:27:28.637',NULL),('816711dd-158c-11ee-b3b1-00d86184ce3d',11,'6ea0d9b2-1587-11ee-b3b1-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',7,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-06-28 10:19:30.568',NULL,'2023-06-28 10:21:30.922','2023-06-28 08:21:30.922',NULL),('820c3dcb-deaf-11ed-9cc3-00d86184ce3d',11,'fded0f45-deae-11ed-9cc3-00d86184ce3d','MAXILLAIRE','SCAN',1,'NONE',2,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-04-19 14:41:30.083',NULL,'2023-04-19 14:44:23.569','2023-04-19 12:44:23.569',NULL),('83818757-262c-11ee-8042-a0510b46b473',11,'6253caa6-261f-11ee-8042-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',10,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-19 14:05:12.178',NULL,'2023-07-19 14:08:02.481','2023-07-19 12:08:02.481',NULL),('83fb0690-26e4-11ee-a836-a0510b46b473',11,'d5f241c9-26e3-11ee-a836-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',3,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-20 12:02:20.373',NULL,'2023-07-20 12:04:41.214','2023-07-20 10:04:41.215',NULL),('842643b3-1fe8-11ee-b7d5-a0510b46b473',11,'775bad6c-1fe8-11ee-b7d5-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',1,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-11 14:43:20.503',NULL,'2023-07-11 14:45:10.748','2023-07-11 12:45:10.748',NULL),('86351fdc-2ac4-11ee-80c8-a0510b46b473',11,'3a8b3537-2abf-11ee-80c8-a0510b46b473','MAXILLAIRE','SCAN',1,'NONE',12,0,'','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','cd586b7f-bd29-4792-9c08-6cd1ba1a6424','2023-07-25 10:23:24.865',NULL,'2023-07-25 10:24:55.006','2023-07-25 08:24:55.006',NULL),('8663cbf9-10e3-11ee-b636-a0510b46b473'