-- MySQL dump 10.13  Distrib 5.7.33, for Linux (x86_64)
--
-- Host: localhost    Database: condor_client_local
-- ------------------------------------------------------
-- Server version	5.7.33-0ubuntu0.16.04.1

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `Camera`
--

DROP TABLE IF EXISTS `Camera`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Camera` (
  `reference` char(13) NOT NULL,
  PRIMARY KEY (`reference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Camera`
--

LOCK TABLES `Camera` WRITE;
/*!40000 ALTER TABLE `Camera` DISABLE KEYS */;
/*!40000 ALTER TABLE `Camera` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CameraAccess`
--

DROP TABLE IF EXISTS `CameraAccess`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `CameraAccess` (
  `professionalID` mediumint(8) unsigned NOT NULL,
  `computerMac` char(17) NOT NULL,
  `cameraReference` char(13) NOT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`professionalID`,`computerMac`,`cameraReference`),
  KEY `fk_CameraAccess_Professional_idx` (`professionalID`),
  KEY `fk_CameraAccess_Computer_idx` (`computerMac`),
  KEY `fk_CameraAccess_Camera_idx` (`cameraReference`),
  CONSTRAINT `fk_CameraAccess_Camera` FOREIGN KEY (`cameraReference`) REFERENCES `Camera` (`reference`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_CameraAccess_Computer` FOREIGN KEY (`computerMac`) REFERENCES `Computer` (`mac`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_CameraAccess_Professional` FOREIGN KEY (`professionalID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CameraAccess`
--

LOCK TABLES `CameraAccess` WRITE;
/*!40000 ALTER TABLE `CameraAccess` DISABLE KEYS */;
/*!40000 ALTER TABLE `CameraAccess` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Computer`
--

DROP TABLE IF EXISTS `Computer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Computer` (
  `mac` char(17) NOT NULL,
  `condorVersionID` varchar(16) DEFAULT NULL,
  `graphicsCard` varchar(50) DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastSynced` datetime DEFAULT NULL,
  PRIMARY KEY (`mac`),
  KEY `fk_Computer_CondorVersion_idx` (`condorVersionID`),
  CONSTRAINT `fk_Computer_CondorVersion` FOREIGN KEY (`condorVersionID`) REFERENCES `CondorVersion` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Computer`
--

LOCK TABLES `Computer` WRITE;
/*!40000 ALTER TABLE `Computer` DISABLE KEYS */;
INSERT INTO `Computer` VALUES ('00:d8:61:06:ef:c8','v2.4.4','GeForce RTX 2070 with Max-Q Design','2021-11-10 15:26:14',NULL);
/*!40000 ALTER TABLE `Computer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CondorVersion`
--

DROP TABLE IF EXISTS `CondorVersion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `CondorVersion` (
  `id` varchar(16) NOT NULL,
  `db_version` varchar(10) DEFAULT NULL,
  `ihm_version` varchar(10) DEFAULT NULL,
  `core_version` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CondorVersion`
--

LOCK TABLES `CondorVersion` WRITE;
/*!40000 ALTER TABLE `CondorVersion` DISABLE KEYS */;
INSERT INTO `CondorVersion` VALUES ('v0.1.1',NULL,NULL,NULL),('v0.1.2',NULL,NULL,NULL),('v2.4.4',NULL,NULL,NULL);
/*!40000 ALTER TABLE `CondorVersion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `License`
--

DROP TABLE IF EXISTS `License`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `License` (
  `number` char(23) NOT NULL,
  `professionalID` mediumint(8) unsigned DEFAULT NULL,
  `enabled` enum('NONE','SOFTWARE','WEB','ALL') NOT NULL DEFAULT 'ALL',
  `licenseType` enum('PROD','DEMO') NOT NULL DEFAULT 'PROD',
  PRIMARY KEY (`number`),
  UNIQUE KEY `uq_professional` (`professionalID`),
  KEY `fk_License_Professional_idx` (`professionalID`),
  CONSTRAINT `fk_License_Professional` FOREIGN KEY (`professionalID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `License`
--

LOCK TABLES `License` WRITE;
/*!40000 ALTER TABLE `License` DISABLE KEYS */;
/*!40000 ALTER TABLE `License` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `LicenseAccess`
--

DROP TABLE IF EXISTS `LicenseAccess`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `LicenseAccess` (
  `professionalID` mediumint(8) unsigned NOT NULL,
  `licenseNumber` char(23) NOT NULL,
  `computerMac` char(17) NOT NULL,
  `condorVersionID` varchar(16) NOT NULL,
  `globalID` mediumint(8) unsigned DEFAULT NULL,
  `status` enum('VALID','REPAIR') NOT NULL DEFAULT 'VALID',
  `activationDate` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`professionalID`,`licenseNumber`,`computerMac`),
  KEY `fk_LicenseAccess_Computer_idx` (`computerMac`),
  KEY `fk_LicenseAccess_License_idx` (`licenseNumber`),
  KEY `fk_LicenseAccess_CondorVersion_idx` (`condorVersionID`),
  CONSTRAINT `fk_LicenseAccess_Computer` FOREIGN KEY (`computerMac`) REFERENCES `Computer` (`mac`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_LicenseAccess_CondorVersion` FOREIGN KEY (`condorVersionID`) REFERENCES `CondorVersion` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_LicenseAccess_License` FOREIGN KEY (`licenseNumber`) REFERENCES `License` (`number`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_LicenseAccess_Professional` FOREIGN KEY (`professionalID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LicenseAccess`
--

LOCK TABLES `LicenseAccess` WRITE;
/*!40000 ALTER TABLE `LicenseAccess` DISABLE KEYS */;
/*!40000 ALTER TABLE `LicenseAccess` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Professional`
--

DROP TABLE IF EXISTS `Professional`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Professional` (
  `id` mediumint(8) unsigned NOT NULL,
  `firstName` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `mainPhone` varchar(45) DEFAULT NULL,
  `country` varchar(75) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Professional`
--

LOCK TABLES `Professional` WRITE;
/*!40000 ALTER TABLE `Professional` DISABLE KEYS */;
/*!40000 ALTER TABLE `Professional` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `__db_version__`
--

DROP TABLE IF EXISTS `__db_version__`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `__db_version__` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `version_major` int(11) NOT NULL DEFAULT '0',
  `version_minor` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `migration_file` varchar(1024) DEFAULT NULL,
  `commit` varchar(255) DEFAULT NULL,
  `version_core` varchar(255) DEFAULT NULL,
  `version_IHM` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `__db_version__`
--

LOCK TABLES `__db_version__` WRITE;
/*!40000 ALTER TABLE `__db_version__` DISABLE KEYS */;
INSERT INTO `__db_version__` VALUES (1,1,0,'v1.0','migration_init_condorclient_local','','1.9','2.0.4'),(2,1,1,'v1.1','migration_camera_condorclient_local','','1.9','2.0.4'),(3,1,2,'v1.2','migration_graphicsCard_condorclient_local','','1.9','2.0.4'),(4,1,3,'v1.3','migration_officecountry_condorclient_local','','1.9.0','2.0.4'),(5,1,4,'v1.4','migration_licenseaccess_globalid_condorclient_local','','1.9','2.0.4'),(6,1,5,'v1.5','migration_remove_null_mac_computer_condorclient_local','','1.9','2.0.4'),(7,1,6,'v1.6','migration_license_enabled_condorclient_local','','1.9','2.0.4'),(8,1,7,'v1.7','migration_activation_history_condorclient_local','','1.9.0','2.0.4'),(9,1,8,'v1.8','migration_condor_version_condorclient_local','','1.9.0','2.0.4'),(10,1,9,'v1.9','migration_demo_professional','','4.1.0','2.1.1');
/*!40000 ALTER TABLE `__db_version__` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping routines for database 'condor_client_local'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2021-11-12  9:34:55
