-- MySQL dump 10.13  Distrib 8.0.27, for Linux (x86_64)
--
-- Host: localhost    Database: condor
-- ------------------------------------------------------
-- Server version	8.0.27-0ubuntu0.20.04.1

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `Act`
--

DROP TABLE IF EXISTS `Act`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Act` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `title` varchar(64) DEFAULT NULL,
  `dateCreated` datetime DEFAULT NULL,
  `comments` mediumtext,
  `globalDisplayID` mediumint unsigned DEFAULT NULL,
  `displayID` mediumint unsigned DEFAULT NULL,
  `patientID` char(36) NOT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastAccessed` datetime NOT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Work_Patient` (`patientID`,`ownerID`),
  CONSTRAINT `fk_Act_Patient` FOREIGN KEY (`patientID`) REFERENCES `condor_patient_local`.`Patient` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Act`
--

LOCK TABLES `Act` WRITE;
/*!40000 ALTER TABLE `Act` DISABLE KEYS */;
INSERT INTO `Act` VALUES (163,'0816b184-9799-4efa-a263-841dc64405d0','14','2019-08-27 14:37:01','',1,1,'ead5b230-47e1-4b8d-8773-1a934e1ba033','','',NULL,'2019-09-19 11:12:44','2019-09-19 11:13:42','2019-09-19 09:13:42','2019-08-27 14:51:12'),(163,'1a37c2d2-e6a1-4863-8afb-27944d3a7e33','TEST','2020-02-17 11:34:29','',1,1,'1288ba7c-0bcf-4c6f-92e7-2873863af918','','',NULL,'2020-02-17 11:34:29','2020-02-17 12:05:51','2020-02-17 11:05:51','2020-02-17 12:05:47'),(163,'1ff39b04-4666-4c18-afaa-74990cd38521','IN-ONLAY / 34','2019-09-18 15:13:21','',1,1,'bdb79646-26a6-440d-867f-112e46644df6','','',NULL,'2019-09-24 11:34:10','2019-09-24 11:35:00','2019-09-24 09:35:00','2019-09-24 11:33:26'),(163,'208338ea-2209-4f7c-ad22-9db0447ff940','','2017-07-07 15:41:03','',1,1,'c8f81196-baea-4404-bca2-c39acd92734c','','','2019-08-07 10:12:43','2017-07-07 15:43:59',NULL,'2019-08-07 08:12:43','2017-07-07 15:43:59'),(163,'3ae0c9b4-944b-4732-8dff-c023398bb119','TEST','2019-08-26 18:31:10','',1,1,'ba0bbbe7-1747-427a-836e-38eb56979058','','',NULL,'2019-09-05 15:02:40','2019-09-05 15:02:41','2019-09-05 13:02:41','2019-08-26 18:31:35'),(163,'4252a7af-d6d9-4447-b402-60820076dceb','inlay','2019-08-20 15:27:07','',1,1,'3e81f0de-1357-45a1-a1d1-75e348b3b043','','','2020-04-30 11:53:44','2019-08-20 15:37:22','2019-08-20 15:37:23','2020-04-30 09:53:44','2019-08-20 15:37:11'),(163,'42afb509-9a10-464d-a838-9efc02a03458','21 fmi','2020-01-30 12:47:25','',1,1,'338e2117-81fc-470d-b92f-d61d9ea6739b','','',NULL,'2020-01-30 12:47:25','2020-02-17 11:21:12','2020-02-17 10:21:12','2020-01-30 12:47:26'),(163,'4829e17a-6262-4322-bd2d-12f3055adf7d','test WOW1','2019-08-20 14:24:18','',1,2,'db79203f-7f7c-4e19-85d6-0069adcfbd11','','','2020-04-30 11:53:44','2019-08-20 15:37:39','2019-08-20 15:37:39','2020-04-30 09:53:44','2019-08-20 15:13:10'),(163,'54e4e76a-88ec-47fe-8787-b7d925a5a345','Inlay 26','2019-08-28 19:37:58','',1,1,'b9d4138d-2c8c-492f-bf20-3aa5437834df','','',NULL,'2019-09-05 20:12:11','2019-09-05 20:12:12','2019-09-05 18:12:12','2019-09-05 20:11:39'),(163,'692fa6c8-2523-4d56-bebf-b736f05db142','CCM SUR  11','2019-10-14 12:42:45','',1,1,'b10e93aa-548c-427f-adcd-2dbc22bc6626','','',NULL,'2019-10-14 12:42:45','2019-10-14 13:02:19','2019-10-14 11:02:19','2019-10-14 13:02:11'),(163,'78f19188-19ad-480e-8d99-35699a9590fa','Travail 1','2017-06-14 16:37:51','',1,1,'db79203f-7f7c-4e19-85d6-0069adcfbd11','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','','2020-04-30 11:53:44','2017-07-07 15:55:06','2019-08-07 10:12:47','2020-04-30 09:53:44','2017-07-07 15:55:06'),(163,'7c5c9390-023c-4e0d-a61e-ae3e13c7e8f7','PROTHESE SUR IMPLANTS','2022-03-26 14:56:13','',1,1,'42283eca-193c-404a-97f6-56ef218de2b8','','',NULL,'2022-03-26 14:56:13','2022-03-26 15:42:14','2022-03-26 14:42:14','2022-03-26 15:42:13'),(163,'7c797d57-e5c3-461e-83aa-0572f4d928dd','','2019-07-26 15:34:18','',1,1,'7ba9aec5-62a3-4219-a383-9d2bbd4147f6','','','2019-08-07 10:12:43','2019-07-26 15:34:39',NULL,'2019-08-07 08:12:43','2019-07-26 15:34:18'),(3,'81146ef5-a63c-4e0a-9164-e233746442ae','','2021-12-10 14:54:00','',18,1,'b8ad1160-ea98-421c-99a9-742ccb19a736','','',NULL,'2021-12-10 14:54:00','2021-12-10 14:54:01','2021-12-10 13:54:01','2021-12-10 14:54:00'),(163,'87eba16d-aff7-41e9-9637-bf09b56f1030','Test 1','2021-04-11 10:03:46','',1,1,'409f26d0-a7e4-4813-8322-7342ba9597af','','',NULL,'2021-04-11 12:20:07','2021-12-16 22:25:57','2021-12-16 21:25:57','2021-04-11 12:25:10'),(163,'8ba0980a-f3b0-4678-95c3-5866f7faa344','','2019-07-26 15:35:18','',1,2,'c3d48f98-f992-4b17-9ebd-a8f388b7e0ca','','',NULL,'2019-09-05 15:02:57','2019-09-05 15:02:57','2019-09-05 13:02:57','2019-07-26 15:35:18'),(163,'97e5ae19-9444-4dd2-9134-8f61d8d268df','TEST EMPREINTE','2022-02-12 15:04:53','',1,2,'409f26d0-a7e4-4813-8322-7342ba9597af','','',NULL,'2022-11-08 22:46:37','2022-11-08 22:49:11','2022-11-08 21:49:11','2022-11-08 22:49:11'),(1,'99140e2a-6c40-4cec-8b61-6b676b8308a5','Travail 1','2017-05-26 09:55:59',NULL,8,1,'146dc0ed-e7c0-4b2a-9a6f-7fa2d76847ac','81719eb6-9836-45c5-a632-3098f463dde0','',NULL,'2017-05-26 09:56:00',NULL,'2019-08-07 08:10:27','2017-05-26 09:56:00'),(163,'b5113824-905e-4f98-a455-48450edf42fe','','2018-06-26 17:06:34','',1,1,'d6df50c1-2f0d-49c5-b022-5c2d80a9226b','','','2019-08-07 10:12:43','2019-07-26 15:34:42',NULL,'2019-08-07 08:12:43','2018-06-26 17:06:34'),(163,'bc3db4c6-a79c-4ab4-a006-4f82c00387c4','','2021-12-16 22:37:07','',1,1,'faa00c69-6a8f-4658-9cfd-f65108440db8','','','2022-02-12 15:04:15','2021-12-16 22:37:07','2022-02-12 15:04:15','2022-02-12 14:04:15','2021-12-16 22:51:46'),(163,'bc55b8f5-e548-4538-975e-99c4c5e0df82','CCM CCC 11 ET 21','2019-10-09 19:17:00','',1,1,'9b491976-73ed-4d02-8711-4f4da13f42d9','','',NULL,'2019-10-09 20:37:50','2019-10-09 20:37:51','2019-10-09 18:37:51','2019-10-09 20:37:28'),(163,'c2ba8e83-c45e-4afb-a56d-642916e2bc25','','2017-07-07 16:46:22','',1,1,'d9e77c5f-e140-4942-b81b-d2676fd3f9e9','','','2019-08-07 10:12:43','2017-07-07 16:46:21',NULL,'2019-08-07 08:12:43','2017-07-07 16:46:21'),(163,'c88b02dd-0888-4d7e-b3d5-66d58b9cf56a','','2019-08-20 15:25:40','',1,1,'06f2a3bd-d1ba-4ac0-8808-522987236cbe','','','2019-08-20 15:26:41','2019-08-20 15:25:40','2019-08-20 15:26:41','2019-08-20 13:26:41','2019-08-20 15:26:38'),(163,'ce36d71d-debf-4f14-bbe8-30830b342bd3','','2017-09-23 10:23:31','',1,1,'c3d48f98-f992-4b17-9ebd-a8f388b7e0ca','','',NULL,'2019-07-26 15:36:08','2019-08-07 10:12:46','2019-08-07 08:12:46','2017-09-23 10:23:32'),(163,'cf18f1d7-15eb-478c-9049-91f184fe0fc4','','2019-07-26 15:34:01','',1,1,'484533a4-c958-4ae0-9685-23a2b9cda42c','','','2019-08-07 10:12:43','2019-07-26 15:34:01',NULL,'2019-08-07 08:12:43','2019-07-26 15:34:01'),(163,'d602bcde-28c7-42bd-90b2-813d264ff6a5','','2020-01-24 10:12:51','',1,1,'709a6d6f-071f-48a8-ab41-6314d7801e27','','','2020-01-24 10:12:58','2020-01-24 10:12:51',NULL,'2020-01-24 09:12:58','2020-01-24 10:12:51');
/*!40000 ALTER TABLE `Act` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AddressInfo`
--

DROP TABLE IF EXISTS `AddressInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AddressInfo` (
  `id` char(36) NOT NULL COMMENT '(DC2Type:guid)',
  `line_0` varchar(255) DEFAULT NULL,
  `line_1` varchar(255) DEFAULT NULL,
  `line_2` varchar(255) DEFAULT NULL,
  `detail` varchar(255) DEFAULT NULL,
  `cityName` varchar(255) DEFAULT NULL,
  `cityState` varchar(255) DEFAULT NULL,
  `cityZip` varchar(25) DEFAULT NULL,
  `countryName` varchar(255) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AddressInfo`
--

LOCK TABLES `AddressInfo` WRITE;
/*!40000 ALTER TABLE `AddressInfo` DISABLE KEYS */;
INSERT INTO `AddressInfo` VALUES ('00000001-0000-0000-0000-000000000001',NULL,NULL,NULL,NULL,'LEZIGNAN',NULL,NULL,NULL,NULL,NULL,'2022-11-08 21:42:31'),('00000002-0000-0000-0000-000000000017',NULL,'','',NULL,'lezignan',NULL,'11200',NULL,NULL,NULL,'2022-11-08 21:42:31'),('00000003-0000-0000-0000-000000000001','137 rue Garance','','',NULL,'Labège','','31670','France',NULL,NULL,'2022-11-08 21:42:31'),('00000005-0000-0000-0000-000000000001','','','',NULL,'HOENHEIM','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000006-0000-0000-0000-000000000001','','','',NULL,'Marseille','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000007-0000-0000-0000-000000000001','','','',NULL,'MERIGNAC','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000008-0000-0000-0000-000000000001','','','',NULL,'MERIGNAC','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000009-0000-0000-0000-000000000001','','','',NULL,'Villiers Sur Marne','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000011-0000-0000-0000-000000000001','137 rue Garance','','',NULL,'Labège','','31670','France',NULL,NULL,'2022-11-08 21:42:31'),('00000016-0000-0000-0000-000000000012',NULL,NULL,NULL,NULL,'LEZIGNAN',NULL,NULL,NULL,NULL,NULL,'2022-11-08 21:42:31'),('00000026-0000-0000-0000-000000000020',NULL,NULL,NULL,NULL,'Molsheim',NULL,NULL,NULL,NULL,NULL,'2022-11-08 21:42:31'),('00000027-0000-0000-0000-000000000009',NULL,NULL,NULL,NULL,'Besançon',NULL,NULL,NULL,NULL,NULL,'2022-11-08 21:42:31'),('00000041-0000-0000-0000-000000000007',NULL,NULL,NULL,NULL,'lezignan',NULL,NULL,NULL,NULL,NULL,'2022-11-08 21:42:31'),('00000046-0000-0000-0000-000000000018',NULL,NULL,NULL,NULL,'Aix en Provence',NULL,NULL,NULL,NULL,NULL,'2022-11-08 21:42:31'),('00000060-0000-0000-0000-000000000006',NULL,NULL,NULL,NULL,'MOLSHEIM',NULL,NULL,NULL,NULL,NULL,'2022-11-08 21:42:31'),('00000061-0000-0000-0000-000000000010',NULL,NULL,NULL,NULL,'MOLSHEIM',NULL,NULL,NULL,NULL,NULL,'2022-11-08 21:42:31'),('00000063-0000-0000-0000-000000000008',NULL,NULL,NULL,NULL,'MOLSHEIM',NULL,NULL,NULL,NULL,NULL,'2022-11-08 21:42:31'),('00000064-0000-0000-0000-000000000002',NULL,NULL,NULL,NULL,'MOLSHEIM',NULL,NULL,NULL,NULL,NULL,'2022-11-08 21:42:31'),('00000065-0000-0000-0000-000000000003',NULL,NULL,NULL,NULL,'BESANCON','doubs','25000',NULL,NULL,NULL,'2022-11-08 21:42:31'),('00000089-0000-0000-0000-000000000011',NULL,NULL,NULL,NULL,'PARIS',NULL,NULL,NULL,NULL,NULL,'2022-11-08 21:42:31'),('00000101-0000-0000-0000-000000000004',NULL,NULL,NULL,NULL,'Strasbourg',NULL,NULL,NULL,NULL,NULL,'2022-11-08 21:42:31'),('00000106-0000-0000-0000-000000000005',NULL,NULL,NULL,NULL,'PARIS',NULL,'75018',NULL,NULL,NULL,'2022-11-08 21:42:31'),('00000163-0000-0000-0000-000000000021','','','',NULL,'','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000176-0000-0000-0000-000000000019',NULL,NULL,NULL,NULL,'Landerneau',NULL,NULL,NULL,NULL,NULL,'2022-11-08 21:42:31'),('00000188-0000-0000-0000-000000000001','','','',NULL,'Francheville','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000253-0000-0000-0000-000000000001','','','',NULL,'','','','',NULL,NULL,'2022-11-08 21:42:31'),('00000438-0000-0000-0000-000000000022',NULL,NULL,NULL,NULL,'lyon',NULL,NULL,'France',NULL,NULL,'2022-11-08 21:42:31'),('00000689-0000-0000-0000-000000000001','','','',NULL,'CHAMBERY','','','France',NULL,NULL,'2022-03-31 17:40:19');
/*!40000 ALTER TABLE `AddressInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Assistant`
--

DROP TABLE IF EXISTS `Assistant`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Assistant` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `patientRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'READ_ONLY',
  `actRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'READ_ONLY',
  `discussionRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'READ_ONLY',
  `credentialsID` char(36) DEFAULT NULL,
  `personInfoID` char(36) DEFAULT NULL COMMENT '(DC2Type:guid)',
  `phoneInfoID` char(36) DEFAULT NULL COMMENT '(DC2Type:guid)',
  `addressInfoID` char(36) DEFAULT NULL COMMENT '(DC2Type:guid)',
  `officeID` char(36) DEFAULT NULL,
  `tempPassword` varchar(32) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `lastConnection` timestamp NULL DEFAULT NULL,
  `firstConnection` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`,`ownerID`),
  UNIQUE KEY `UNIQ_4068FE723D139428` (`personInfoID`),
  UNIQUE KEY `UNIQ_4068FE72627FFEF6` (`phoneInfoID`),
  UNIQUE KEY `UNIQ_4068FE72A680FCCC` (`addressInfoID`),
  KEY `fk_Assistant_Professional` (`ownerID`),
  KEY `fk_Assistant_Office` (`officeID`,`ownerID`),
  KEY `fk_Assistant_Credentials_idx` (`credentialsID`,`id`),
  KEY `fk_Assistant_PersonInfo_idx` (`personInfoID`),
  KEY `fk_Assistant_PhoneInfo_idx` (`phoneInfoID`),
  KEY `fk_Assistant_AddressInfo_idx` (`addressInfoID`),
  CONSTRAINT `fk_Assistant_AddressInfo` FOREIGN KEY (`addressInfoID`) REFERENCES `AddressInfo` (`id`),
  CONSTRAINT `fk_Assistant_Credentials` FOREIGN KEY (`credentialsID`) REFERENCES `Credentials` (`id`),
  CONSTRAINT `fk_Assistant_Office` FOREIGN KEY (`officeID`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Assistant_PersonInfo` FOREIGN KEY (`personInfoID`) REFERENCES `PersonInfo` (`id`),
  CONSTRAINT `fk_Assistant_PhoneInfo` FOREIGN KEY (`phoneInfoID`) REFERENCES `PhoneInfo` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Assistant`
--

LOCK TABLES `Assistant` WRITE;
/*!40000 ALTER TABLE `Assistant` DISABLE KEYS */;
/*!40000 ALTER TABLE `Assistant` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `Assistant_AFTER_DELETE` AFTER DELETE ON `Assistant` FOR EACH ROW BEGIN
	DELETE FROM PersonInfo  WHERE ownerID = OLD.ownerID AND id = OLD.personInfoID;
	DELETE FROM AddressInfo WHERE ownerID = OLD.ownerID AND id = OLD.addressInfoID;
	DELETE FROM PhoneInfo   WHERE ownerID = OLD.ownerID AND id = OLD.phoneInfoID;
	DELETE FROM Credentials WHERE ownerID = OLD.ownerID AND id = OLD.credentialsID;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `CircleOrder`
--

DROP TABLE IF EXISTS `CircleOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CircleOrder` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `actID` char(36) NOT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `title` varchar(64) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `status` enum('not_sent','waiting_wow_api','sending_wow_api','sending_circle_api','sent','cancelled') NOT NULL DEFAULT 'waiting_wow_api',
  `createdAt` datetime NOT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `json` text NOT NULL,
  `metadata` text NOT NULL,
  `localDisplayID` int unsigned DEFAULT NULL,
  `globalDisplayID` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_CircleOrder_Act` (`actID`,`ownerID`),
  CONSTRAINT `fk_CircleOrder_Act` FOREIGN KEY (`actID`, `ownerID`) REFERENCES `Act` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CircleOrder`
--

LOCK TABLES `CircleOrder` WRITE;
/*!40000 ALTER TABLE `CircleOrder` DISABLE KEYS */;
/*!40000 ALTER TABLE `CircleOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CircleOrderFile`
--

DROP TABLE IF EXISTS `CircleOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CircleOrderFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `orderID` char(36) NOT NULL,
  `fileID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`orderID`,`fileID`),
  KEY `fk_CircleOrderFile_CircleOrder` (`orderID`,`ownerID`),
  KEY `fk_CircleOrderFile_CondorFile` (`fileID`,`ownerID`),
  CONSTRAINT `fk_CircleOrderFile_CircleOrder` FOREIGN KEY (`orderID`, `ownerID`) REFERENCES `CircleOrder` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_CircleOrderFile_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CircleOrderFile`
--

LOCK TABLES `CircleOrderFile` WRITE;
/*!40000 ALTER TABLE `CircleOrderFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `CircleOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CondorFile`
--

DROP TABLE IF EXISTS `CondorFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CondorFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `path` text NOT NULL,
  `type` varchar(250) NOT NULL,
  `tag` varchar(250) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `originalName` varchar(100) DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `status` enum('CREATED','UPDATED','SYNCED','ERROR') DEFAULT NULL,
  `originalID` char(36) NOT NULL,
  `version` mediumint NOT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `metadata` text,
  PRIMARY KEY (`id`,`ownerID`),
  UNIQUE KEY `un_CondorFile_version` (`ownerID`,`originalID`,`version`),
  KEY `fk_CondorFile_Professional` (`ownerID`),
  KEY `fk_CondorFile_CondorFile` (`originalID`,`ownerID`),
  CONSTRAINT `fk_CondorFile_CondorFile` FOREIGN KEY (`originalID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_CondorFile_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CondorFile`
--

LOCK TABLES `CondorFile` WRITE;
/*!40000 ALTER TABLE `CondorFile` DISABLE KEYS */;
INSERT INTO `CondorFile` VALUES (163,'017a9667-ac3d-4fef-a06e-5ddd29fdc587','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/b9d4138d-2c8c-492f-bf20-3aa5437834df/session_54e4e76a-88ec-47fe-8787-b7d925a5a345/occlusion_92b33516-ba42-40bc-80ec-77c62a130f93/scan_be3fdbda-df17-4184-bf04-6f17a0efb2c6/14_w1_o1_mordu_posterieur_gauche_scan_file_0.stl','STL','PATIENT_b9d4138d-2c8c-492f-bf20-3aa5437834df_ACT_54e4e76a-88ec-47fe-8787-b7d925a5a345_SESS_92b33516-ba42-40bc-80ec-77c62a130f93_LESC_be3fdbda-df17-4184-bf04-6f17a0efb2c6_STL_','2021-12-10 13:53:52','2019-08-28 19:56:43','14_w1_o1_mordu_posterieur_gauche_scan_file_0.stl','2021-12-10 14:53:52','SYNCED','017a9667-ac3d-4fef-a06e-5ddd29fdc587',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MORDU_POSTERIEUR_GAUCHE 1.14.1.1\",\"modelMatrix\":\"-0.96361,-0.188213,0.190629,0,0.222107,-0.960005,0.17339,0,0.148751,0.207296,0.966231,0,13.428,-2.96864,-19.2432,1\",\"title\":\"MORDU_POSTERIEUR_GAUCHE STL\"}'),(163,'01c97edc-1505-4e0a-8f10-092893017632','','ZIP','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_97e5ae19-9444-4dd2-9134-8f61d8d268df_SESS_85186f51-753c-498e-8346-beea8a780c7b_LESC_0aa3a260-9283-4def-b4f0-f3652eb329cc_ZIP_','2022-03-26 13:54:03','2022-02-12 15:32:30','','2022-03-26 14:54:03','SYNCED','01c97edc-1505-4e0a-8f10-092893017632',0,'2022-03-26 14:54:03','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mordu posterieur gauche 1.21.2.1.1\",\"modelMatrix\":\"-0.993519,-0.104725,0.0468487,0,0.105681,-0.993263,0.0444902,0,0.0418765,0.0496183,0.997911,0,-4.49702,-6.51056,-8.72478,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(163,'02807cae-d63f-40cf-9ac4-c747ea770b34','','ZIP','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_97e5ae19-9444-4dd2-9134-8f61d8d268df_SESS_85186f51-753c-498e-8346-beea8a780c7b_TOSC_4dae9d5a-78fb-4bf8-baf8-409fa0374e57_ZIP_','2022-03-26 13:54:03','2022-02-12 15:18:42','','2022-03-26 14:54:03','SYNCED','02807cae-d63f-40cf-9ac4-c747ea770b34',0,'2022-03-26 14:54:03','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.21.2.1.3\",\"modelMatrix\":\"-0.882727,0.46488,-0.0684041,0,-0.469885,-0.873324,0.128504,0,-2.61303e-09,0.145576,0.989347,0,4.98752,-3.33986,-22.0581,1\",\"title\":\"Maxillaire ZIP\"}'),(163,'04d6ba70-17fa-4ec6-b60a-ae8c83a21656','','PLY','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_4829e17a-6262-4322-bd2d-12f3055adf7d_SESS_be8b17ea-1f2d-4455-823c-87f31acb59e4_TOSC_073fbacf-ede3-4d02-b1ed-c47271ca0e8b_PLY_','2021-12-16 21:25:56','2019-08-20 14:25:19','','2021-12-16 22:25:56','SYNCED','04d6ba70-17fa-4ec6-b60a-ae8c83a21656',0,'2021-12-16 22:25:56','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mandibule Occlusion 1.2.2.1\",\"modelMatrix\":\"0.995496,0.0870518,-0.0375587,0,-0.0948086,0.914049,-0.394368,0,9.73178e-10,0.396153,0.918185,0,-9.5601,-11.7473,-13.9851,1\",\"title\":\"MAXILLAIRE PLY\"}'),(163,'06c13027-f4ec-452a-90e6-376ae8aa4573','','SNAPS','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_78f19188-19ad-480e-8d99-35699a9590fa_SESS_ea11a5f6-aafe-41d9-b61b-f8b13f045b1e_BOSC_6a1c5075-98b1-4211-9987-29ee0ba6ef5f_SNAPS_','2020-12-16 20:58:19','2017-07-07 15:57:38','',NULL,'SYNCED','06c13027-f4ec-452a-90e6-376ae8aa4573',0,'2019-08-20 15:37:52','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mandibule Occlusion 1.2.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(163,'06cc9b99-fb22-4ea1-bf33-8947b179c894','','SNAPS','PATIENT_c8f81196-baea-4404-bca2-c39acd92734c_ACT_208338ea-2209-4f7c-ad22-9db0447ff940_SESS_26578904-6388-4b67-926c-fa9cede7abea_TOSC_195ffba3-6544-4214-acf3-3a4088cbb672_SNAPS_','2020-12-16 20:58:19','2017-07-07 15:44:19','',NULL,'SYNCED','06cc9b99-fb22-4ea1-bf33-8947b179c894',0,'2019-08-07 10:12:43','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.3.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(163,'06fda1e2-604f-4d55-9109-753390f8de28','','STL','PATIENT_c3d48f98-f992-4b17-9ebd-a8f388b7e0ca_ACT_ce36d71d-debf-4f14-bbe8-30830b342bd3_SESS_2c9b2990-8860-4259-b919-67aa71e0b43f_BOSC_3af0c7c7-068f-4b49-a043-c9deaf8798fc_STL_','2020-12-16 20:58:19','2017-09-23 11:51:55','',NULL,'CREATED','06fda1e2-604f-4d55-9109-753390f8de28',0,'2017-09-23 11:51:55','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"modelMatrix\":\"0.396053,-0.804808,0.44207,0,0.918227,0.347133,-0.190676,0,7.66151e-09,0.481439,0.87648,0,2.83338,-21.017,-17.8866,1\",\"title\":\"Mandibule STL\"}'),(163,'0739d8ee-2b14-4370-a430-8495fec0feec','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/b9d4138d-2c8c-492f-bf20-3aa5437834df/session_54e4e76a-88ec-47fe-8787-b7d925a5a345/occlusion_92b33516-ba42-40bc-80ec-77c62a130f93/scan_2961c928-7419-415c-a0c6-570bb108af7f/14_w1_o1_maxillaire_scan_file_0.stl','STL','PATIENT_b9d4138d-2c8c-492f-bf20-3aa5437834df_ACT_54e4e76a-88ec-47fe-8787-b7d925a5a345_SESS_92b33516-ba42-40bc-80ec-77c62a130f93_TOSC_2961c928-7419-415c-a0c6-570bb108af7f_STL_','2021-12-10 13:53:52','2019-08-28 19:42:44','','2021-12-10 14:53:52','SYNCED','0739d8ee-2b14-4370-a430-8495fec0feec',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.14.1.1.1\",\"modelMatrix\":\"0.904497,-0.4229,0.0551409,0,0.42648,0.896905,-0.116945,0,1.56132e-9,0.129293,0.991606,0,-0.332992,-5.0551,-18.1067,1\",\"title\":\"MAXILLAIRE STL\"}'),(163,'0791250b-1f00-4e84-86a1-3dea34c3d54f','','STL','PATIENT_3e81f0de-1357-45a1-a1d1-75e348b3b043_ACT_4252a7af-d6d9-4447-b402-60820076dceb_SESS_6e0b4165-03cb-4f3b-bd97-fca211c1fe33_TOSC_1b051bff-7722-4829-8766-0b9476ca1a2b_STL_','2021-12-16 21:25:56','2019-08-20 15:34:58','','2021-12-16 22:25:56','SYNCED','0791250b-1f00-4e84-86a1-3dea34c3d54f',0,'2021-12-16 22:25:56','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.12.1.1\",\"modelMatrix\":\"-0.910111,0.396347,-0.120857,0,-0.414363,-0.870539,0.26545,0,-3.60985e-9,0.291668,0.956519,0,1.87354,-6.17378,-16.5835,1\",\"title\":\"MAXILLAIRE STL\"}'),(163,'07cdc5f1-9ddf-4eab-a043-c35a6f9783a0','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_c721c0c0-a514-44bc-af6d-0394b9e59459/16_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_TOSC_c721c0c0-a514-44bc-af6d-0394b9e59459_SNAPS_','2021-12-10 13:53:53','2019-10-09 19:22:10','','2021-12-10 14:53:53','SYNCED','07cdc5f1-9ddf-4eab-a043-c35a6f9783a0',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(163,'08d2ffde-2c03-4ec9-8db4-66e88fe25ddd','/var/.data/2021/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/409f26d0-a7e4-4813-8322-7342ba9597af/session_87eba16d-aff7-41e9-9637-bf09b56f1030/occlusion_a53c56e5-88df-4213-95fa-5e72bf6599b9/scan_bae5c384-8be6-46cb-914f-52893ff0a986/21_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_87eba16d-aff7-41e9-9637-bf09b56f1030_SESS_a53c56e5-88df-4213-95fa-5e72bf6599b9_TOSC_bae5c384-8be6-46cb-914f-52893ff0a986_SNAPS_','2021-12-16 21:25:58','2021-04-11 10:11:49','21_w1_o1_maxillaire_snapshot_0.png','2021-12-16 22:25:58','SYNCED','08d2ffde-2c03-4ec9-8db4-66e88fe25ddd',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire SNAPSHOT\",\"title\":\"Maxillaire SNAPSHOT\"}'),(163,'09098d73-a550-46fd-b107-f556eadffd45','','SNAPS','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_97e5ae19-9444-4dd2-9134-8f61d8d268df_SESS_85186f51-753c-498e-8346-beea8a780c7b_TOSC_4dae9d5a-78fb-4bf8-baf8-409fa0374e57_SNAPS_','2022-03-26 13:54:03','2022-02-12 15:18:41','','2022-03-26 14:54:03','SYNCED','09098d73-a550-46fd-b107-f556eadffd45',0,'2022-03-26 14:54:03','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.21.2.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(163,'0aa71ebb-4833-4dfd-bf99-5158c2d6b79f','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_04084a21-671f-49ef-a336-594796e4386f/16_w1_o1_mordu_anterieur_snapshot_1.png','SNAPS','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_FRSC_04084a21-671f-49ef-a336-594796e4386f_SNAPS_','2021-12-10 13:53:53','2019-10-09 20:10:11','','2021-12-10 14:53:53','SYNCED','d0c49092-4174-41ea-a6df-115b7fbd1689',1,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mordu anterieur 1.16.1.1.1\",\"title\":\"MORDU_ANTERIEUR SNAPSHOT\"}'),(163,'0b57b957-257f-4fef-8207-bfd0571938b5','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/bdb79646-26a6-440d-867f-112e46644df6/session_1ff39b04-4666-4c18-afaa-74990cd38521/order_2d03e092-9432-42e7-80e7-c4b571887fa6/15_w1_inlay_onlay_prost_file_0.json','JSON','PATIENT_bdb79646-26a6-440d-867f-112e46644df6_ACT_1ff39b04-4666-4c18-afaa-74990cd38521_PROST_2d03e092-9432-42e7-80e7-c4b571887fa6_JSON_','2019-12-15 21:03:21','2019-09-19 11:18:21','','2019-12-15 22:03:21','SYNCED','0b57b957-257f-4fef-8207-bfd0571938b5',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"INLAY ONLAY 1.15.1 INLAY ONLAY\",\"title\":\"Inlay/Onlay JSON\"}'),(163,'0d5f673d-1e06-4c82-b781-3166313d5ca7','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/bdb79646-26a6-440d-867f-112e46644df6/session_1ff39b04-4666-4c18-afaa-74990cd38521/occlusion_ae07c5e5-6b65-46ef-9cd1-c0a9daccea5f/scan_753d010b-c7ba-4dc4-a9cb-eaa7680a0b86/15_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_bdb79646-26a6-440d-867f-112e46644df6_ACT_1ff39b04-4666-4c18-afaa-74990cd38521_SESS_ae07c5e5-6b65-46ef-9cd1-c0a9daccea5f_BOSC_753d010b-c7ba-4dc4-a9cb-eaa7680a0b86_SNAPS_','2021-12-10 13:53:53','2019-09-18 15:27:35','','2021-12-10 14:53:53','SYNCED','0d5f673d-1e06-4c82-b781-3166313d5ca7',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mandibule 1.15.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(163,'0e03805c-4acf-475d-82a6-cef42ae568ea','','PLY','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_4829e17a-6262-4322-bd2d-12f3055adf7d_SESS_be8b17ea-1f2d-4455-823c-87f31acb59e4_BOSC_993e81f9-b63b-42e8-9992-72d3942cce1a_PLY_','2021-12-16 21:25:56','2019-08-20 14:32:27','','2021-12-16 22:25:56','SYNCED','d4d9ec35-a91a-4fd8-a5f6-46de28e34612',1,'2021-12-16 22:25:56','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MANDIBULE 1.2.2.1\",\"modelMatrix\":\"0.782581,0.530544,-0.325715,0,-0.622549,0.666925,-0.409444,0,-1.03547e-8,0.523196,0.852212,0,-4.97091,-14.1252,-11.0101,1\",\"title\":\"MANDIBULE PLY\"}'),(163,'0f8c0a7d-9d25-4b9e-9a7f-33d9881acf78','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_7cd8be19-c5e8-48d9-8950-c7006af5dda6/16_w1_o1_mordu_posterieur_droit_snapshot_3.png','SNAPS','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_RISC_7cd8be19-c5e8-48d9-8950-c7006af5dda6_SNAPS_','2021-12-10 13:53:53','2019-10-09 19:59:52','16_w1_o1_mordu_posterieur_droit_snapshot_3.png','2021-12-10 14:53:53','SYNCED','76dda0ce-1254-4edd-bfae-486661f8e03d',3,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MORDU_POSTERIEUR_DROIT 1.16.1.1\",\"title\":\"MORDU_POSTERIEUR_DROIT SNAPSHOT\"}'),(163,'0fa448af-8873-4fdf-ad1a-9a236b78247f','/var/.data/2022/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/409f26d0-a7e4-4813-8322-7342ba9597af/session_97e5ae19-9444-4dd2-9134-8f61d8d268df/occlusion_85186f51-753c-498e-8346-beea8a780c7b/computedocclusion_4d83f219-0b5d-4997-b640-b46da3aba91f/21_w2_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_97e5ae19-9444-4dd2-9134-8f61d8d268df_SESS_85186f51-753c-498e-8346-beea8a780c7b_OCC_4d83f219-0b5d-4997-b640-b46da3aba91f_TOMA__MATRX_','2022-02-12 14:45:22','2022-02-12 15:45:19','21_w2_o1_maxillaire_matrix_occ_file_0.m','2022-02-12 15:45:22','SYNCED','0fa448af-8873-4fdf-ad1a-9a236b78247f',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.21.2.1.4 Occlusion 1\",\"referenceScanID\":\"1.21.2.1.4\",\"title\":\"Matrice Transfo. Maxillaire 1.21.2.1.4 Occlusion 1\"}'),(163,'1014295d-2e79-47fe-92bf-3111bfc9d43e','','SNAPS','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_4829e17a-6262-4322-bd2d-12f3055adf7d_SESS_9f7449d6-1278-45d5-9492-02cd28be29ca_TOSC_19d904f0-1e7a-4097-baf5-3d03ff2ff6d0_SNAPS_','2021-12-16 21:25:56','2019-08-20 14:39:12','','2021-12-16 22:25:56','SYNCED','1014295d-2e79-47fe-92bf-3111bfc9d43e',0,'2021-12-16 22:25:56','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mandibule Occlusion 1.2.2.2\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(163,'115eb8f9-db47-45d2-a963-651d349e8124','computedocclusion_92b33516-ba42-40bc-80ec-77cmigraoccl/','LIFIM','PATIENT_b9d4138d-2c8c-492f-bf20-3aa5437834df_ACT_54e4e76a-88ec-47fe-8787-b7d925a5a345_SESS_92b33516-ba42-40bc-80ec-77c62a130f93_OCC_92b33516-ba42-40bc-80ec-77cmigraoccl_LIFIMO_LIFIM_','2021-12-16 21:25:56','2019-08-29 15:24:01','','2021-12-16 22:25:56','SYNCED','71847718-31ab-4ff8-a7f2-31b3d3797945',1,'2021-12-16 22:25:56','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Ligne de finition MAXILLAIRE 1.14.1.1 Sans nom 0 Occlusion\",\"isOcclusionMarginLine\":true,\"name\":\"Sans nom 0 Occlusion\",\"title\":\"MAXILLAIRE LIFI_META\",\"toothNumber\":1000,\"lifi_scan_type\":\"MAXILLAIRE\"}'),(163,'11fa8713-51a4-4ebe-826b-f8e77b81fa64','','STL','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_4829e17a-6262-4322-bd2d-12f3055adf7d_SESS_be8b17ea-1f2d-4455-823c-87f31acb59e4_BOSC_993e81f9-b63b-42e8-9992-72d3942cce1a_STL_','2021-12-16 21:25:57','2019-08-20 14:30:37','','2021-12-16 22:25:57','SYNCED','11fa8713-51a4-4ebe-826b-f8e77b81fa64',0,'2021-12-16 22:25:57','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mandibule Occlusion 1.2.2.1\",\"modelMatrix\":\"0.785829,0.550368,-0.282077,0,-0.618443,0.699328,-0.358424,0,-7.2817e-9,0.456109,0.889924,0,-4.80164,-13.1044,-12.194,1\",\"title\":\"MANDIBULE STL\"}'),(163,'12b83c2b-966f-46ac-92eb-c4aeaeeabfa7','','SNAPS','PATIENT_c3d48f98-f992-4b17-9ebd-a8f388b7e0ca_ACT_ce36d71d-debf-4f14-bbe8-30830b342bd3_SESS_2c9b2990-8860-4259-b919-67aa71e0b43f_TOSC_5b265bae-8c91-414d-bee3-c03fcfb27c19_SNAPS_','2020-12-16 20:58:19','2017-09-23 10:30:21','',NULL,'SYNCED','12b83c2b-966f-46ac-92eb-c4aeaeeabfa7',0,'2017-09-23 10:30:21','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"title\":\"Maxillaire SNAPSHOT\"}'),(163,'14425596-1207-4e3c-85a2-962de24cd892','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_c721c0c0-a514-44bc-af6d-0394b9e59459/16_w1_o1_maxillaire_snapshot_2.png','SNAPS','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_TOSC_c721c0c0-a514-44bc-af6d-0394b9e59459_SNAPS_','2021-12-10 13:53:53','2019-10-09 19:27:13','16_w1_o1_maxillaire_snapshot_2.png','2021-12-10 14:53:53','SYNCED','07cdc5f1-9ddf-4eab-a043-c35a6f9783a0',2,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(3,'1838e490-b32b-4dbb-a741-2b78c171c383','/var/.data/2021/7655b09e-027b-49c5-9b6c-832c6e41cee8/discussion_605c208e-ad38-4268-a678-5f04c6f9007f/1838e490-b32b-4dbb-a741-2b78c171c383.stl','STL','PATIENT_dcc81b31-38ca-437f-b1e2-7dd685a6af0f_ACT_677738ea-9ad8-4e2a-9cd2-074bfa0bf78d_SESS_74fb8ff3-73e7-4d38-a4cf-efbd69884ace_TOSC_41bee0c2-80a9-42c3-bca3-64690ff159ef_STL_','2020-11-23 20:19:26','2019-07-03 17:18:05','1838e490-b32b-4dbb-a741-2b78c171c383.stl','2020-11-23 21:19:26','SYNCED','1838e490-b32b-4dbb-a741-2b78c171c383',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.9.1.1.1\",\"modelMatrix\":\"0.972746,-0.229158,0.0353824,0,0.231873,0.961354,-0.148435,0,2.17642e-10,0.152594,0.988289,0,-35.8517,-15.8436,-18.6142,1\",\"title\":\"MAXILLAIRE STL\"}'),(163,'18814eeb-ff1c-4473-b5af-604e53018f60','','PLY','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_78f19188-19ad-480e-8d99-35699a9590fa_SESS_ea11a5f6-aafe-41d9-b61b-f8b13f045b1e_BOSC_6a1c5075-98b1-4211-9987-29ee0ba6ef5f_PLY_','2020-12-16 20:58:19','2017-07-07 16:02:16','',NULL,'SYNCED','a730168d-f711-4f65-97cc-e1abf584ee29',1,'2019-08-20 15:37:52','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mandibule Occlusion 1.2.1.1\",\"modelMatrix\":\"0.894225,-0.406275,0.187888,0,0.447617,0.811634,-0.375352,0,1.62914e-08,0.419751,0.907639,0,-8.25828,-9.38956,-23.8323,1\",\"title\":\"Mandibule PLY\"}'),(163,'1884156e-0009-429c-a499-0ea06f50ac03','','PLY','PATIENT_3e81f0de-1357-45a1-a1d1-75e348b3b043_ACT_4252a7af-d6d9-4447-b402-60820076dceb_SESS_6e0b4165-03cb-4f3b-bd97-fca211c1fe33_BOSC_c747cc9f-b0ac-4699-9c44-0651899bc2b1_PLY_','2021-12-16 21:25:57','2019-08-20 15:36:26','','2021-12-16 22:25:57','SYNCED','1884156e-0009-429c-a499-0ea06f50ac03',0,'2021-12-16 22:25:57','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MANDIBULE 1.12.1.1\",\"modelMatrix\":\"-0.838165,0.449579,-0.308801,0,-0.545417,-0.690888,0.474547,0,1.02511e-8,0.566174,0.824286,0,-2.34851,-4.70645,-6.03757,1\",\"title\":\"MANDIBULE PLY\"}'),(163,'1975cc7c-b839-4085-805d-f147a5b0713e','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_7cd8be19-c5e8-48d9-8950-c7006af5dda6/16_w1_o1_mordu_posterieur_droit_snapshot_2.png','SNAPS','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_RISC_7cd8be19-c5e8-48d9-8950-c7006af5dda6_SNAPS_','2021-12-10 13:53:53','2019-10-09 19:55:54','16_w1_o1_mordu_posterieur_droit_snapshot_2.png','2021-12-10 14:53:53','SYNCED','76dda0ce-1254-4edd-bfae-486661f8e03d',2,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MORDU_POSTERIEUR_DROIT 1.16.1.1\",\"title\":\"MORDU_POSTERIEUR_DROIT SNAPSHOT\"}'),(163,'19e971d5-8f70-4650-be06-d6b925134b9f','/var/.data/2022/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/409f26d0-a7e4-4813-8322-7342ba9597af/session_97e5ae19-9444-4dd2-9134-8f61d8d268df/occlusion_85186f51-753c-498e-8346-beea8a780c7b/scan_cd569007-a8b8-4363-acd4-5ff36a438dbd/21_w2_o1_maxillaire_snapshot_2.png','SNAPS','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_97e5ae19-9444-4dd2-9134-8f61d8d268df_SESS_85186f51-753c-498e-8346-beea8a780c7b_TOSC_cd569007-a8b8-4363-acd4-5ff36a438dbd_SNAPS_','2022-02-12 15:23:44','2022-02-12 16:23:38','21_w2_o1_maxillaire_snapshot_2.png','2022-02-12 16:23:44','SYNCED','a9aa3381-bdc3-46c7-a6b4-5a267ebfb25d',2,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.21.2.1.6\",\"title\":\"Maxillaire SNAPSHOT\"}'),(163,'1a7468db-e426-418f-9be5-ea619e178e80','/var/.data/2021/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/409f26d0-a7e4-4813-8322-7342ba9597af/session_87eba16d-aff7-41e9-9637-bf09b56f1030/occlusion_a53c56e5-88df-4213-95fa-5e72bf6599b9/scan_ff508a13-6fb6-4736-87b1-187a5e0330b5/21_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_87eba16d-aff7-41e9-9637-bf09b56f1030_SESS_a53c56e5-88df-4213-95fa-5e72bf6599b9_TOSC_ff508a13-6fb6-4736-87b1-187a5e0330b5_SNAPS_','2021-12-16 21:26:21','2021-04-11 12:00:32','21_w1_o1_maxillaire_snapshot_1.png','2021-12-16 22:26:21','SYNCED','4c1113c9-3ec7-4c67-8bf8-3076f18cac31',1,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.21.1.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(163,'1ba1d207-956d-49d4-b5aa-76c29f35e81c','','PLY','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_78f19188-19ad-480e-8d99-35699a9590fa_SESS_ea11a5f6-aafe-41d9-b61b-f8b13f045b1e_TOSC_d1dc341b-6602-437f-99c5-f70a9e47e85a_PLY_','2020-12-16 20:58:19','2017-06-22 18:17:24','',NULL,'SYNCED','1ba1d207-956d-49d4-b5aa-76c29f35e81c',0,'2017-06-22 18:17:24','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"modelMatrix\":\"0.991177,0.0888989,-0.0983066,0,-0.132541,0.664808,-0.735162,0,2.07498e-10,0.741705,0.670726,0,1.08205,-13.5011,-7.9269,1\",\"title\":\"Maxillaire PLY\"}'),(163,'1c7f8f32-d02f-4b09-a844-56f902e86e98','/var/.data/2017/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/c3d48f98-f992-4b17-9ebd-a8f388b7e0ca/session_ce36d71d-debf-4f14-bbe8-30830b342bd3/occlusion_2c9b2990-8860-4259-b919-67aa71e0b43f/scan_44384df8-d4cf-4515-a227-e58defb71ddd/5_w1_mandibule_scan_file_0.stl','STL','PATIENT_c3d48f98-f992-4b17-9ebd-a8f388b7e0ca_ACT_ce36d71d-debf-4f14-bbe8-30830b342bd3_SESS_2c9b2990-8860-4259-b919-67aa71e0b43f_BOSC_44384df8-d4cf-4515-a227-e58defb71ddd_STL_','2021-12-10 13:53:53','2017-11-30 17:52:27','5_w1_mandibule_scan_file_0.stl','2021-12-10 14:53:53','SYNCED','1c7f8f32-d02f-4b09-a844-56f902e86e98',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MANDIBULE 1.5.1.1\",\"modelMatrix\":\"0.92173,-0.256717,0.290705,0,0.387831,0.610121,-0.690898,0,-1.07026e-08,0.749566,0.66193,0,2.82042,-23.133,-11.2583,1\",\"title\":\"Mandibule STL\"}'),(163,'1d94168f-dde9-4b67-80b3-e774e27517e6','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/b9d4138d-2c8c-492f-bf20-3aa5437834df/session_54e4e76a-88ec-47fe-8787-b7d925a5a345/occlusion_92b33516-ba42-40bc-80ec-77c62a130f93/14_w1_o1_maxillaire_contact_occ_file_1.ply','CONTACT','PATIENT_b9d4138d-2c8c-492f-bf20-3aa5437834df_ACT_54e4e76a-88ec-47fe-8787-b7d925a5a345_SESS_92b33516-ba42-40bc-80ec-77c62a130f93_TOCO__CONTACT_','2021-12-10 13:53:54','2019-08-28 20:01:50','','2021-12-10 14:53:54','SYNCED','69876a92-8c10-4ffc-a0a4-f0740c567866',1,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Pts de Contacts Maxillaire Occlusion 1.14.1.1\",\"title\":\"Pts de Contacts Maxillaire Occlusion CONTACT\"}'),(163,'1e31cc48-54e9-432a-b8bf-8740fff36776','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_7cd8be19-c5e8-48d9-8950-c7006af5dda6/16_w1_o1_mordu_posterieur_droit_scan_file_1.ply','PLY','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_RISC_7cd8be19-c5e8-48d9-8950-c7006af5dda6_PLY_','2021-12-10 13:53:54','2019-10-09 19:51:50','16_w1_o1_mordu_posterieur_droit_scan_file_1.ply','2021-12-10 14:53:54','SYNCED','8f08a4aa-c3db-47d5-8812-811198ddca5a',1,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MORDU_POSTERIEUR_DROIT 1.16.1.1\",\"modelMatrix\":\"0.960416,-0.154039,0.235142,0,0.14667,0.987583,0.0598983,0,-0.236924,-0.0323139,0.970162,0,-1.789,-3.76583,-14.5136,1\",\"title\":\"MORDU_POSTERIEUR_DROIT PLY\"}'),(163,'205963cf-0d3b-4c74-9f74-7eec3cc0f022','','STL','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_78f19188-19ad-480e-8d99-35699a9590fa_SESS_ea11a5f6-aafe-41d9-b61b-f8b13f045b1e_TOSC_d1dc341b-6602-437f-99c5-f70a9e47e85a_STL_','2020-12-16 20:58:19','2017-06-22 18:17:24','',NULL,'SYNCED','205963cf-0d3b-4c74-9f74-7eec3cc0f022',0,'2017-06-22 18:17:24','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"modelMatrix\":\"0.991177,0.0888989,-0.0983066,0,-0.132541,0.664808,-0.735162,0,2.07498e-10,0.741705,0.670726,0,1.08205,-13.5011,-7.9269,1\",\"title\":\"Maxillaire STL\"}'),(163,'20edaff2-efa9-45ee-9d49-2f7195591f97','','STL','PATIENT_3e81f0de-1357-45a1-a1d1-75e348b3b043_ACT_4252a7af-d6d9-4447-b402-60820076dceb_SESS_6e0b4165-03cb-4f3b-bd97-fca211c1fe33_BOSC_c747cc9f-b0ac-4699-9c44-0651899bc2b1_STL_','2021-12-16 21:25:57','2019-08-20 15:36:26','','2021-12-16 22:25:57','SYNCED','20edaff2-efa9-45ee-9d49-2f7195591f97',0,'2021-12-16 22:25:57','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MANDIBULE 1.12.1.1\",\"modelMatrix\":\"-0.838165,0.449579,-0.308801,0,-0.545417,-0.690888,0.474547,0,1.02511e-8,0.566174,0.824286,0,-2.34851,-4.70645,-6.03757,1\",\"title\":\"MANDIBULE STL\"}'),(163,'23f1b081-9ad4-49bf-b123-0d1971f56cab','','PLY','PATIENT_c3d48f98-f992-4b17-9ebd-a8f388b7e0ca_ACT_ce36d71d-debf-4f14-bbe8-30830b342bd3_SESS_2c9b2990-8860-4259-b919-67aa71e0b43f_BOSC_3af0c7c7-068f-4b49-a043-c9deaf8798fc_PLY_','2020-12-16 20:58:19','2017-09-23 11:51:55','',NULL,'CREATED','23f1b081-9ad4-49bf-b123-0d1971f56cab',0,'2017-09-23 11:51:55','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"modelMatrix\":\"0.396053,-0.804808,0.44207,0,0.918227,0.347133,-0.190676,0,7.66151e-09,0.481439,0.87648,0,2.83338,-21.017,-17.8866,1\",\"title\":\"Mandibule PLY\"}'),(163,'25113e99-c3e7-4d17-9c78-0289f82697f0','/var/.data/2022/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/409f26d0-a7e4-4813-8322-7342ba9597af/session_97e5ae19-9444-4dd2-9134-8f61d8d268df/occlusion_85186f51-753c-498e-8346-beea8a780c7b/scan_3390e065-1f9a-438a-8024-2e1b03309150/21_w2_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_97e5ae19-9444-4dd2-9134-8f61d8d268df_SESS_85186f51-753c-498e-8346-beea8a780c7b_TOSC_3390e065-1f9a-438a-8024-2e1b03309150_SNAPS_','2022-02-12 14:34:56','2022-02-12 15:34:54','21_w2_o1_maxillaire_snapshot_0.png','2022-02-12 15:34:56','SYNCED','25113e99-c3e7-4d17-9c78-0289f82697f0',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.21.2.1.4\",\"title\":\"Maxillaire SNAPSHOT\"}'),(163,'253a912c-c2e7-49c5-9cc4-243ebc7de3a8','','PLY','PATIENT_c3d48f98-f992-4b17-9ebd-a8f388b7e0ca_ACT_ce36d71d-debf-4f14-bbe8-30830b342bd3_SESS_2c9b2990-8860-4259-b919-67aa71e0b43f_BOSC_3af0c7c7-068f-4b49-a043-c9deaf8798fc_PLY_','2020-12-16 20:58:19','2017-09-23 11:51:55','',NULL,'CREATED','23f1b081-9ad4-49bf-b123-0d1971f56cab',2,'2017-09-23 11:51:55','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"modelMatrix\":\"0.763764,-0.223642,0.605516,0,0.645496,0.264618,-0.716458,0,-2.8558e-08,0.938063,0.346466,0,-3.69598,-25.1252,-7.92147,1\",\"title\":\"Mandibule PLY\"}'),(163,'26211f5c-1ad8-4463-8e8b-b3b60a00ba7e','','SNAPS','PATIENT_faa00c69-6a8f-4658-9cfd-f65108440db8_ACT_bc3db4c6-a79c-4ab4-a006-4f82c00387c4_SESS_05363e68-a254-4acc-8205-219c338c6ba1_TOSC_18a8129a-a9a0-43e4-b924-c8cc8c0e462c_SNAPS_','2022-02-12 14:04:15','2021-12-16 22:43:27','','2022-02-12 15:04:15','SYNCED','26211f5c-1ad8-4463-8e8b-b3b60a00ba7e',0,'2022-02-12 15:04:15','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.22.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(163,'276c12a8-3d75-42ec-97d2-18b68d9a6101','','SNAPS','PATIENT_c3d48f98-f992-4b17-9ebd-a8f388b7e0ca_ACT_ce36d71d-debf-4f14-bbe8-30830b342bd3_SESS_2c9b2990-8860-4259-b919-67aa71e0b43f_BOSC_3af0c7c7-068f-4b49-a043-c9deaf8798fc_SNAPS_','2020-12-16 20:58:19','2017-09-23 11:51:55','',NULL,'CREATED','9223ddc8-c22b-432b-8e5b-e2bbed0d9bce',3,'2017-09-23 11:51:55','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"title\":\"Mandibule SNAPSHOT\"}'),(163,'27a5fc38-18cd-4993-ac8c-aed0d82de108','','SNAPS','PATIENT_06f2a3bd-d1ba-4ac0-8808-522987236cbe_ACT_c88b02dd-0888-4d7e-b3d5-66d58b9cf56a_SESS_aa101222-6e4e-4d52-97cc-39e34711339f_TOSC_f73ede6a-6df1-4316-bced-be2c046effe7_SNAPS_','2021-12-16 21:25:57','2019-08-20 15:26:28','','2021-12-16 22:25:57','SYNCED','27a5fc38-18cd-4993-ac8c-aed0d82de108',0,'2021-12-16 22:25:57','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.11.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(3,'27cfdaa5-b01b-4b0a-93c2-65c6a1a62fcb','/var/.data/2021/7655b09e-027b-49c5-9b6c-832c6e41cee8/discussion_88f8c70c-bd90-4787-bf46-0897cd968fca/27cfdaa5-b01b-4b0a-93c2-65c6a1a62fcb.pdf','PDF','PATIENT_f1ba7774-7c5d-40d1-adaf-bf5e9ddee4c5_ACT_6c4aa713-5123-4551-8db5-cfa1136bd86a_PROST_cda06966-1509-4b92-9e65-86f5896015c7_PDF_','2019-12-15 21:03:21','2019-07-08 15:35:54','27cfdaa5-b01b-4b0a-93c2-65c6a1a62fcb.pdf','2019-12-15 22:03:21','SYNCED','27cfdaa5-b01b-4b0a-93c2-65c6a1a62fcb',0,NULL,'','','{\"displayTitle\":\"COURONNE SUR IMPLANT 2.2.2 COURONNE SUR IMPLANT\",\"title\":\"Couronne sur Implant PDF\"}'),(163,'29b0101d-6385-4e7a-9086-253fdc351d02','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/bdb79646-26a6-440d-867f-112e46644df6/session_1ff39b04-4666-4c18-afaa-74990cd38521/order_2d03e092-9432-42e7-80e7-c4b571887fa6/15_w1_inlay_onlay_prost_file_0.pdf','PDF','PATIENT_bdb79646-26a6-440d-867f-112e46644df6_ACT_1ff39b04-4666-4c18-afaa-74990cd38521_PROST_2d03e092-9432-42e7-80e7-c4b571887fa6_PDF_','2019-12-15 21:03:21','2019-09-19 11:18:21','','2019-12-15 22:03:21','SYNCED','29b0101d-6385-4e7a-9086-253fdc351d02',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"INLAY ONLAY 1.15.1 INLAY ONLAY\",\"title\":\"Inlay/Onlay PDF\"}'),(163,'2b2da34e-40de-4eec-97e1-03189a8ce722','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/order_2365cac3-5051-47bd-98df-b6ee18e8b8a6/16_w1_inlay_core_prost_file_0.pdf','PDF','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_PROST_2365cac3-5051-47bd-98df-b6ee18e8b8a6_PDF_','2019-12-15 21:03:21','2019-10-09 20:32:10','','2019-12-15 22:03:21','SYNCED','2b2da34e-40de-4eec-97e1-03189a8ce722',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"INLAY CORE 1.16.1 INLAY CORE\",\"title\":\"Inlay Core PDF\"}'),(3,'2bf17da1-2bd8-412a-acb3-638f2ce2d508','/var/.data/2021/7655b09e-027b-49c5-9b6c-832c6e41cee8/discussion_605c208e-ad38-4268-a678-5f04c6f9007f/2bf17da1-2bd8-412a-acb3-638f2ce2d508.stl','STL','PATIENT_f1ba7774-7c5d-40d1-adaf-bf5e9ddee4c5_ACT_6c4aa713-5123-4551-8db5-cfa1136bd86a_SESS_b1f65e85-2a53-4c07-89bc-95a34ee8c209_BOSC_ac62ad28-ce76-4c21-8909-4348bd46d50f_STL_','2020-11-23 20:19:26','2019-07-08 15:32:31','2bf17da1-2bd8-412a-acb3-638f2ce2d508.stl','2020-11-23 21:19:26','SYNCED','2bf17da1-2bd8-412a-acb3-638f2ce2d508',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 2.2.2.1.1\",\"modelMatrix\":\"-0.477557,-0.869559,0.125726,0,0.878601,-0.472642,0.0683376,0,-3.04888e-9,0.143098,0.989708,0,8.87102,14.4776,-17.3023,1\",\"title\":\"MANDIBULE STL\"}'),(163,'2ca4b9b6-0fa5-43c0-9189-717339b5f3d4','/var/.data/2021/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/409f26d0-a7e4-4813-8322-7342ba9597af/session_87eba16d-aff7-41e9-9637-bf09b56f1030/occlusion_a53c56e5-88df-4213-95fa-5e72bf6599b9/scan_bae5c384-8be6-46cb-914f-52893ff0a986/21_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_87eba16d-aff7-41e9-9637-bf09b56f1030_SESS_a53c56e5-88df-4213-95fa-5e72bf6599b9_TOSC_bae5c384-8be6-46cb-914f-52893ff0a986_SNAPS_','2021-12-16 21:26:10','2021-04-11 11:38:40','21_w1_o1_maxillaire_snapshot_1.png','2021-12-16 22:26:10','SYNCED','08d2ffde-2c03-4ec9-8db4-66e88fe25ddd',1,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.21.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(163,'2d9489cd-1db0-4f5a-b533-f46d8404ab3b','','STL','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_78f19188-19ad-480e-8d99-35699a9590fa_SESS_ea11a5f6-aafe-41d9-b61b-f8b13f045b1e_TOSC_6e7c8911-84d8-43fd-8f0f-1af7ab21a105_STL_','2020-12-16 20:58:19','2017-07-07 14:59:28','',NULL,'SYNCED','2d9489cd-1db0-4f5a-b533-f46d8404ab3b',0,'2017-07-07 14:59:28','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"modelMatrix\":\"0.999519,-0.0306223,0.00482209,0,0.0309996,0.987353,-0.155478,0,-3.13187e-10,0.155553,0.987828,0,9.92195,-3.93564,-21.9356,1\",\"title\":\"Maxillaire STL\"}'),(3,'2e779ae0-691f-413a-b2b7-c5516bb4357e','/var/.data/2021/7655b09e-027b-49c5-9b6c-832c6e41cee8/discussion_605c208e-ad38-4268-a678-5f04c6f9007f/2e779ae0-691f-413a-b2b7-c5516bb4357e.ply','PLY','PATIENT_f1ba7774-7c5d-40d1-adaf-bf5e9ddee4c5_ACT_6c4aa713-5123-4551-8db5-cfa1136bd86a_SESS_b1f65e85-2a53-4c07-89bc-95a34ee8c209_TOSC_3a6328c7-ecc7-45ef-b5b6-32a9abadded8_PLY_','2020-11-23 20:19:26','2019-07-08 15:30:28','2e779ae0-691f-413a-b2b7-c5516bb4357e.ply','2020-11-23 21:19:26','SYNCED','2e779ae0-691f-413a-b2b7-c5516bb4357e',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 2.2.2.1.1\",\"modelMatrix\":\"0.562045,-0.814585,0.143379,0,0.827107,0.553535,-0.0974305,0,2.22825e-9,0.17335,0.98486,0,-11.7114,14.098,-15.7553,1\",\"title\":\"MAXILLAIRE PLY\"}'),(163,'2f7fded2-7b5f-4f6e-8f55-0f5f30f2fd97','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/b9d4138d-2c8c-492f-bf20-3aa5437834df/session_54e4e76a-88ec-47fe-8787-b7d925a5a345/occlusion_92b33516-ba42-40bc-80ec-77c62a130f93/14_w1_o1_maxillaire_occlusion_occ_file_0.stl','STL','PATIENT_b9d4138d-2c8c-492f-bf20-3aa5437834df_ACT_54e4e76a-88ec-47fe-8787-b7d925a5a345_SESS_92b33516-ba42-40bc-80ec-77c62a130f93_TOSTL__STL_','2021-12-10 13:53:54','2019-08-28 20:00:06','','2021-12-10 14:53:54','SYNCED','2f7fded2-7b5f-4f6e-8f55-0f5f30f2fd97',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire Occlusion 1.14.1.1\",\"title\":\"Maxillaire Occlusion STL\"}'),(163,'34e3bf9d-9455-42e8-8211-5f98ddc4a7b5','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_f1172a60-6504-4697-9acb-2793b430d7fe/16_w1_o1_mandibule_scan_file_1.stl','STL','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_BOSC_f1172a60-6504-4697-9acb-2793b430d7fe_STL_','2021-12-10 13:53:54','2019-10-09 19:38:18','16_w1_o1_mandibule_scan_file_1.stl','2021-12-10 14:53:54','SYNCED','631bcc28-4111-4e0e-a212-e688ec1d3e11',1,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MANDIBULE 1.16.1.1\",\"modelMatrix\":\"0.932882,0.243802,-0.265126,0,-0.360182,0.631455,-0.686683,0,9.46485e-9,0.736088,0.676886,0,1.17629,-20.9991,-17.5388,1\",\"title\":\"MANDIBULE STL\"}'),(163,'3564a77e-4582-46c4-9f2c-b5ad00af9b7f','','SNAPS','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_4829e17a-6262-4322-bd2d-12f3055adf7d_SESS_be8b17ea-1f2d-4455-823c-87f31acb59e4_TOSC_073fbacf-ede3-4d02-b1ed-c47271ca0e8b_SNAPS_','2021-12-16 21:25:57','2019-08-20 14:25:19','','2021-12-16 22:25:57','SYNCED','3564a77e-4582-46c4-9f2c-b5ad00af9b7f',0,'2021-12-16 22:25:57','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mandibule Occlusion 1.2.2.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(163,'360a685a-cc03-46f2-bcd3-b66e7250b82d','','SNAPS','PATIENT_1288ba7c-0bcf-4c6f-92e7-2873863af918_ACT_1a37c2d2-e6a1-4863-8afb-27944d3a7e33_SESS_7560d619-3fa6-414c-85d8-52a724ef7bf4_TOSC_9bfc9e7e-6d55-461c-b01c-e6ef10fc5f61_SNAPS_','2020-12-16 20:58:19','2020-02-17 11:35:42','',NULL,'CREATED','360a685a-cc03-46f2-bcd3-b66e7250b82d',0,'2020-02-17 11:46:51','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.20.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(163,'36485abc-845b-4d31-9b2e-f1d57c158b2f','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/b9d4138d-2c8c-492f-bf20-3aa5437834df/session_54e4e76a-88ec-47fe-8787-b7d925a5a345/occlusion_92b33516-ba42-40bc-80ec-77c62a130f93/computedocclusion_92b33516-ba42-40bc-80ec-77cmigraoccl/14_w1_o1_maxillaire_occlusion_occ_file_0.ply','PLY','PATIENT_b9d4138d-2c8c-492f-bf20-3aa5437834df_ACT_54e4e76a-88ec-47fe-8787-b7d925a5a345_SESS_92b33516-ba42-40bc-80ec-77c62a130f93_OCC_92b33516-ba42-40bc-80ec-77cmigraoccl_TOPLY__PLY_','2021-12-10 13:53:54','2019-08-28 20:00:06','','2021-12-10 14:53:54','SYNCED','36485abc-845b-4d31-9b2e-f1d57c158b2f',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire Occlusion 1.14.1.1\",\"title\":\"Maxillaire Occlusion PLY\"}'),(163,'37b2e7e8-7b45-44f6-9bf3-a3ee58f12ffc','','SNAPS','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_78f19188-19ad-480e-8d99-35699a9590fa_SESS_ea11a5f6-aafe-41d9-b61b-f8b13f045b1e_TOSC_6e7c8911-84d8-43fd-8f0f-1af7ab21a105_SNAPS_','2020-12-16 20:58:19','2017-07-07 14:59:28','',NULL,'SYNCED','37b2e7e8-7b45-44f6-9bf3-a3ee58f12ffc',0,'2017-07-07 14:59:28','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"title\":\"Maxillaire SNAPSHOT\"}'),(163,'37d607cd-338e-40c0-a7a8-1124df452998','/var/.data/2022/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/409f26d0-a7e4-4813-8322-7342ba9597af/session_97e5ae19-9444-4dd2-9134-8f61d8d268df/occlusion_85186f51-753c-498e-8346-beea8a780c7b/scan_3390e065-1f9a-438a-8024-2e1b03309150/21_w2_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_97e5ae19-9444-4dd2-9134-8f61d8d268df_SESS_85186f51-753c-498e-8346-beea8a780c7b_TOSC_3390e065-1f9a-438a-8024-2e1b03309150_ZIP_','2022-02-12 14:36:23','2022-02-12 15:36:22','21_w2_o1_maxillaire_scan_file_1.zip','2022-02-12 15:36:23','SYNCED','88c19117-97fb-4589-a086-5b48d3765732',1,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.21.2.1.4\",\"modelMatrix\":\"-0.496698,0.809858,-0.312124,0,-0.867923,-0.463468,0.178623,0,1.1277e-08,0.359622,0.933098,0,7.58203,-15.2884,-15.0384,1\",\"title\":\"Maxillaire ZIP\"}'),(163,'39ab4c97-d8bf-4e73-9692-c019edc8dac8','/var/.data/2022/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/409f26d0-a7e4-4813-8322-7342ba9597af/session_97e5ae19-9444-4dd2-9134-8f61d8d268df/occlusion_85186f51-753c-498e-8346-beea8a780c7b/computedocclusion_4d83f219-0b5d-4997-b640-b46da3aba91f/21_w2_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_97e5ae19-9444-4dd2-9134-8f61d8d268df_SESS_85186f51-753c-498e-8346-beea8a780c7b_OCC_4d83f219-0b5d-4997-b640-b46da3aba91f_TOPLY__ZIP_','2022-02-12 14:45:22','2022-02-12 15:45:19','21_w2_o1_maxillaire_occlusion_occ_file_0.zip','2022-02-12 15:45:22','SYNCED','39ab4c97-d8bf-4e73-9692-c019edc8dac8',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.21.2.1.4 Occlusion 1\",\"modelMatrix\":\"-0.496698,0.809858,-0.312124,0,-0.867923,-0.463468,0.178623,0,1.1277e-08,0.359622,0.933098,0,7.58203,-15.2884,-15.0384,1\",\"referenceScanID\":\"1.21.2.1.4\",\"title\":\"Maxillaire 1.21.2.1.4 Occlusion 1\"}'),(163,'39bb61d6-8872-44f1-9c84-e4c0161b0e1f','','LIFI','PATIENT_b9d4138d-2c8c-492f-bf20-3aa5437834df_ACT_54e4e76a-88ec-47fe-8787-b7d925a5a345_SESS_92b33516-ba42-40bc-80ec-77c62a130f93_TOSC_2961c928-7419-415c-a0c6-570bb108af7f_LIFI_','2021-12-16 21:25:57','2019-08-29 15:23:58','','2021-12-16 22:25:57','SYNCED','39bb61d6-8872-44f1-9c84-e4c0161b0e1f',0,'2021-12-16 22:25:57','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Ligne de finition MAXILLAIRE 1.14.1.1 Sans nom 0\",\"name\":\"Sans nom 0\",\"title\":\"MAXILLAIRE LIFI\",\"toothNumber\":0}'),(3,'3bb0340b-c13a-4632-8cc0-f16aeda43252','/var/.data/2021/7655b09e-027b-49c5-9b6c-832c6e41cee8/discussion_88f8c70c-bd90-4787-bf46-0897cd968fca/3bb0340b-c13a-4632-8cc0-f16aeda43252.json','JSON','PATIENT_f1ba7774-7c5d-40d1-adaf-bf5e9ddee4c5_ACT_6c4aa713-5123-4551-8db5-cfa1136bd86a_PROST_cda06966-1509-4b92-9e65-86f5896015c7_JSON_','2019-12-15 21:03:21','2019-07-08 15:35:54','3bb0340b-c13a-4632-8cc0-f16aeda43252.json','2019-12-15 22:03:21','SYNCED','3bb0340b-c13a-4632-8cc0-f16aeda43252',0,NULL,'','','{\"displayTitle\":\"COURONNE SUR IMPLANT 2.2.2 COURONNE SUR IMPLANT\",\"title\":\"Couronne sur Implant JSON\"}'),(163,'3bf4bfa2-cc28-4996-9ae2-b0e93df2de6b','','STL','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_4829e17a-6262-4322-bd2d-12f3055adf7d_SESS_9f7449d6-1278-45d5-9492-02cd28be29ca_TOSC_9ed276f9-9775-47d3-ad07-589e561c3ce7_STL_','2021-12-16 21:25:57','2019-08-20 15:13:10','','2021-12-16 22:25:57','SYNCED','3bf4bfa2-cc28-4996-9ae2-b0e93df2de6b',0,'2021-12-16 22:25:57','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.2.2.2\",\"modelMatrix\":\"0.241839,0.826558,-0.508247,0,-0.970316,0.206009,-0.126674,0,-6.762e-9,0.523795,0.851844,0,-27.4034,-34.3034,-5.51386,1\",\"title\":\"MAXILLAIRE STL\"}'),(163,'3d2cd757-e631-4446-9e31-0898c32d2626','','SNAPS','PATIENT_c3d48f98-f992-4b17-9ebd-a8f388b7e0ca_ACT_ce36d71d-debf-4f14-bbe8-30830b342bd3_SESS_2c9b2990-8860-4259-b919-67aa71e0b43f_BOSC_44d5b703-6523-47a8-aa54-e6c882485fdd_SNAPS_','2020-12-16 20:58:19','2017-09-23 10:41:16','',NULL,'SYNCED','3d2cd757-e631-4446-9e31-0898c32d2626',0,'2017-09-23 10:41:16','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"title\":\"Mandibule SNAPSHOT\"}'),(163,'3d6af265-a88f-4743-a5e7-a9f9a29f81fb','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/b10e93aa-548c-427f-adcd-2dbc22bc6626/session_692fa6c8-2523-4d56-bebf-b736f05db142/occlusion_c2195287-5f39-4a66-93d5-5b83792fc9a8/scan_18cd0f29-a9fb-4dcd-91fe-8fb30a4d171a/17_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_b10e93aa-548c-427f-adcd-2dbc22bc6626_ACT_692fa6c8-2523-4d56-bebf-b736f05db142_SESS_c2195287-5f39-4a66-93d5-5b83792fc9a8_TOSC_18cd0f29-a9fb-4dcd-91fe-8fb30a4d171a_SNAPS_','2021-12-10 13:53:54','2019-10-14 12:54:26','','2021-12-10 14:53:54','SYNCED','3d6af265-a88f-4743-a5e7-a9f9a29f81fb',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.17.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(163,'3dd0f9f9-74b8-4ce7-9a38-a25d8ccb971b','/var/.data/2022/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/409f26d0-a7e4-4813-8322-7342ba9597af/session_97e5ae19-9444-4dd2-9134-8f61d8d268df/occlusion_85186f51-753c-498e-8346-beea8a780c7b/scan_cd569007-a8b8-4363-acd4-5ff36a438dbd/21_w2_o1_maxillaire_scan_file_4.zip','ZIP','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_97e5ae19-9444-4dd2-9134-8f61d8d268df_SESS_85186f51-753c-498e-8346-beea8a780c7b_TOSC_cd569007-a8b8-4363-acd4-5ff36a438dbd_ZIP_','2022-11-08 21:49:13','2022-11-08 22:49:10','21_w2_o1_maxillaire_scan_file_4.zip','2022-11-08 22:49:13','SYNCED','d003a690-dc4d-4562-9884-3f053f338768',4,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.21.2.1.6\",\"modelMatrix\":\"0.796425,0.467762,-0.383284,0,-0.604738,0.616031,-0.504776,0,8.49903e-09,0.633802,0.773495,0,-8.36884,-41.6361,-11.1844,1\",\"socleColor\":\"0.8,0.8,0.8\",\"socleHeight\":10,\"socleIsFullArch\":true,\"socleThickness\":-1,\"socleType\":3,\"title\":\"Maxillaire ZIP\"}'),(3,'3e226da0-a173-11e9-a33b-226cec7cb58a','/var/.data/2021/7655b09e-027b-49c5-9b6c-832c6e41cee8/discussion_605c208e-ad38-4268-a678-5f04c6f9007f/3e226da0-a173-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_f1ba7774-7c5d-40d1-adaf-bf5e9ddee4c5_ACT_6c4aa713-5123-4551-8db5-cfa1136bd86a_SESS_b1f65e85-2a53-4c07-89bc-95a34ee8c209_BOSC_ac62ad28-ce76-4c21-8909-4348bd46d50f_STL_','2020-11-23 20:19:26','2019-07-08 15:32:31','3e226da0-a173-11e9-a33b-226cec7cb58a.stl','2020-11-23 21:19:26','SYNCED','3e226da0-a173-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 2.2.2.1.1\",\"modelMatrix\":\"-0.477557,-0.869559,0.125726,0,0.878601,-0.472642,0.0683376,0,-3.04888e-9,0.143098,0.989708,0,8.87102,14.4776,-17.3023,1\",\"title\":\"MANDIBULE STL\"}'),(3,'3e231110-a173-11e9-a33b-226cec7cb58a','/var/.data/2021/7655b09e-027b-49c5-9b6c-832c6e41cee8/discussion_605c208e-ad38-4268-a678-5f04c6f9007f/3e231110-a173-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_f1ba7774-7c5d-40d1-adaf-bf5e9ddee4c5_ACT_6c4aa713-5123-4551-8db5-cfa1136bd86a_SESS_b1f65e85-2a53-4c07-89bc-95a34ee8c209_TOSC_3a6328c7-ecc7-45ef-b5b6-32a9abadded8_PLY_','2020-11-23 20:19:26','2019-07-08 15:30:28','3e231110-a173-11e9-a33b-226cec7cb58a.ply','2020-11-23 21:19:26','SYNCED','3e231110-a173-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 2.2.2.1.1\",\"modelMatrix\":\"0.562045,-0.814585,0.143379,0,0.827107,0.553535,-0.0974305,0,2.22825e-9,0.17335,0.98486,0,-11.7114,14.098,-15.7553,1\",\"title\":\"MAXILLAIRE PLY\"}'),(3,'3e24b106-a173-11e9-a33b-226cec7cb58a','/var/.data/2021/7655b09e-027b-49c5-9b6c-832c6e41cee8/discussion_605c208e-ad38-4268-a678-5f04c6f9007f/3e24b106-a173-11e9-a33b-226cec7cb58a.json','JSON','PATIENT_f1ba7774-7c5d-40d1-adaf-bf5e9ddee4c5_ACT_6c4aa713-5123-4551-8db5-cfa1136bd86a_PROST_f22738cf-6b3e-437b-82a4-ba4f30397b8e_JSON_','2019-12-15 21:03:21','2019-07-08 15:35:21','3e24b106-a173-11e9-a33b-226cec7cb58a.json','2019-12-15 22:03:21','SYNCED','3e24b106-a173-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"COURONNE 2.2.2 COURONNE\",\"title\":\"Couronne JSON\"}'),(3,'3e250a56-a173-11e9-a33b-226cec7cb58a','/var/.data/2021/7655b09e-027b-49c5-9b6c-832c6e41cee8/discussion_605c208e-ad38-4268-a678-5f04c6f9007f/3e250a56-a173-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_f1ba7774-7c5d-40d1-adaf-bf5e9ddee4c5_ACT_6c4aa713-5123-4551-8db5-cfa1136bd86a_SESS_b1f65e85-2a53-4c07-89bc-95a34ee8c209_TOSC_3a6328c7-ecc7-45ef-b5b6-32a9abadded8_STL_','2020-11-23 20:19:26','2019-07-08 15:30:28','3e250a56-a173-11e9-a33b-226cec7cb58a.stl','2020-11-23 21:19:26','SYNCED','3e250a56-a173-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 2.2.2.1.1\",\"modelMatrix\":\"0.562045,-0.814585,0.143379,0,0.827107,0.553535,-0.0974305,0,2.22825e-9,0.17335,0.98486,0,-11.7114,14.098,-15.7553,1\",\"title\":\"MAXILLAIRE STL\"}'),(3,'3e259a88-a173-11e9-a33b-226cec7cb58a','/var/.data/2021/7655b09e-027b-49c5-9b6c-832c6e41cee8/discussion_605c208e-ad38-4268-a678-5f04c6f9007f/3e259a88-a173-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_f1ba7774-7c5d-40d1-adaf-bf5e9ddee4c5_ACT_6c4aa713-5123-4551-8db5-cfa1136bd86a_SESS_b1f65e85-2a53-4c07-89bc-95a34ee8c209_BOSC_ac62ad28-ce76-4c21-8909-4348bd46d50f_SNAPS_','2020-11-23 20:19:26','2019-07-08 15:32:31','3e259a88-a173-11e9-a33b-226cec7cb58a.png','2020-11-23 21:19:26','SYNCED','3e259a88-a173-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 2.2.2.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(3,'3e262f77-a173-11e9-a33b-226cec7cb58a','/var/.data/2021/7655b09e-027b-49c5-9b6c-832c6e41cee8/discussion_605c208e-ad38-4268-a678-5f04c6f9007f/3e262f77-a173-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_f1ba7774-7c5d-40d1-adaf-bf5e9ddee4c5_ACT_6c4aa713-5123-4551-8db5-cfa1136bd86a_SESS_b1f65e85-2a53-4c07-89bc-95a34ee8c209_BOSC_ac62ad28-ce76-4c21-8909-4348bd46d50f_PLY_','2020-11-23 20:19:26','2019-07-08 15:32:31','3e262f77-a173-11e9-a33b-226cec7cb58a.ply','2020-11-23 21:19:26','SYNCED','3e262f77-a173-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 2.2.2.1.1\",\"modelMatrix\":\"-0.477557,-0.869559,0.125726,0,0.878601,-0.472642,0.0683376,0,-3.04888e-9,0.143098,0.989708,0,8.87102,14.4776,-17.3023,1\",\"title\":\"MANDIBULE PLY\"}'),(3,'3e26ccea-a173-11e9-a33b-226cec7cb58a','/var/.data/2021/7655b09e-027b-49c5-9b6c-832c6e41cee8/discussion_605c208e-ad38-4268-a678-5f04c6f9007f/3e26ccea-a173-11e9-a33b-226cec7cb58a.pdf','PDF','PATIENT_f1ba7774-7c5d-40d1-adaf-bf5e9ddee4c5_ACT_6c4aa713-5123-4551-8db5-cfa1136bd86a_PROST_f22738cf-6b3e-437b-82a4-ba4f30397b8e_PDF_','2019-12-15 21:03:21','2019-07-08 15:35:21','3e26ccea-a173-11e9-a33b-226cec7cb58a.pdf','2019-12-15 22:03:21','SYNCED','3e26ccea-a173-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"COURONNE 2.2.2 COURONNE\",\"title\":\"Couronne PDF\"}'),(3,'3e27581e-a173-11e9-a33b-226cec7cb58a','/var/.data/2021/7655b09e-027b-49c5-9b6c-832c6e41cee8/discussion_605c208e-ad38-4268-a678-5f04c6f9007f/3e27581e-a173-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_f1ba7774-7c5d-40d1-adaf-bf5e9ddee4c5_ACT_6c4aa713-5123-4551-8db5-cfa1136bd86a_SESS_b1f65e85-2a53-4c07-89bc-95a34ee8c209_TOSC_3a6328c7-ecc7-45ef-b5b6-32a9abadded8_SNAPS_','2020-11-23 20:19:26','2019-07-08 15:30:28','3e27581e-a173-11e9-a33b-226cec7cb58a.png','2020-11-23 21:19:26','SYNCED','3e27581e-a173-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 2.2.2.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(163,'4082adc1-d3e3-4085-89b9-70348f16efd3','','PLY','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_78f19188-19ad-480e-8d99-35699a9590fa_SESS_ea11a5f6-aafe-41d9-b61b-f8b13f045b1e_TOSC_ecab33ae-7dab-49e3-814b-55b739bced5b_PLY_','2021-12-16 21:25:58','2017-07-07 15:44:19','','2021-12-16 22:25:58','SYNCED','4082adc1-d3e3-4085-89b9-70348f16efd3',0,'2021-12-16 22:25:58','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.2.1.1\",\"modelMatrix\":\"-0.752072,0.629531,-0.195138,0,-0.659081,-0.718353,0.22267,0,1.89678e-08,0.296075,0.955165,0,10.0981,-10.6008,-15.2555,1\",\"title\":\"Maxillaire PLY\"}'),(163,'40c5cd84-5aba-4596-a35c-26d65c1fde9f','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_7cd8be19-c5e8-48d9-8950-c7006af5dda6/16_w1_o1_mordu_posterieur_droit_scan_file_3.stl','STL','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_RISC_7cd8be19-c5e8-48d9-8950-c7006af5dda6_STL_','2021-12-10 13:53:54','2019-10-09 19:59:52','16_w1_o1_mordu_posterieur_droit_scan_file_3.stl','2021-12-10 14:53:54','SYNCED','a0840078-f705-4297-a590-258aedaa7cf8',3,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MORDU_POSTERIEUR_DROIT 1.16.1.1\",\"modelMatrix\":\"0.962556,-0.115067,0.245447,0,0.100911,0.992437,0.0634498,0,-0.251602,-0.043368,0.967359,0,-1.51746,-3.55368,-14.6145,1\",\"title\":\"MORDU_POSTERIEUR_DROIT STL\"}'),(163,'410060f9-e183-48c7-bc84-bea261066501','','STL','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_78f19188-19ad-480e-8d99-35699a9590fa_SESS_ea11a5f6-aafe-41d9-b61b-f8b13f045b1e_TOSC_ecab33ae-7dab-49e3-814b-55b739bced5b_STL_','2021-12-16 21:25:58','2017-07-07 15:41:38','','2021-12-16 22:25:58','SYNCED','410060f9-e183-48c7-bc84-bea261066501',0,'2021-12-16 22:25:58','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.2.1.1\",\"modelMatrix\":\"-0.752072,0.629531,-0.195138,0,-0.659081,-0.718353,0.22267,0,1.89678e-08,0.296075,0.955165,0,10.0981,-10.6008,-15.2555,1\",\"title\":\"Maxillaire STL\"}'),(163,'410e2a87-a6fb-4335-98b8-a1e70bb0776a','','SNAPS','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_78f19188-19ad-480e-8d99-35699a9590fa_SESS_ea11a5f6-aafe-41d9-b61b-f8b13f045b1e_BOSC_c58bf258-8cf8-46c5-b72f-1794963795db_SNAPS_','2020-12-16 20:58:19','2017-07-07 14:36:55','',NULL,'SYNCED','410e2a87-a6fb-4335-98b8-a1e70bb0776a',0,'2017-07-07 14:36:55','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"title\":\"Mandibule SNAPSHOT\"}'),(163,'41a9f0ea-4d20-46b5-9408-ddfdda2170d3','','LIFIM','PATIENT_b9d4138d-2c8c-492f-bf20-3aa5437834df_ACT_54e4e76a-88ec-47fe-8787-b7d925a5a345_SESS_92b33516-ba42-40bc-80ec-77c62a130f93_TOSC_2961c928-7419-415c-a0c6-570bb108af7f_LIFIM_','2021-12-16 21:25:58','2019-08-29 15:23:58','','2021-12-16 22:25:58','SYNCED','41a9f0ea-4d20-46b5-9408-ddfdda2170d3',0,'2021-12-16 22:25:58','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Ligne de finition MAXILLAIRE 1.14.1.1 Sans nom 0\",\"name\":\"Sans nom 0\",\"title\":\"MAXILLAIRE LIFI_META\",\"toothNumber\":0}'),(3,'4211d279-56a3-454f-b752-6eaa303f7ee6','/var/.data/2021/7655b09e-027b-49c5-9b6c-832c6e41cee8/discussion_605c208e-ad38-4268-a678-5f04c6f9007f/4211d279-56a3-454f-b752-6eaa303f7ee6.png','SNAPS','PATIENT_dcc81b31-38ca-437f-b1e2-7dd685a6af0f_ACT_677738ea-9ad8-4e2a-9cd2-074bfa0bf78d_SESS_74fb8ff3-73e7-4d38-a4cf-efbd69884ace_TOSC_41bee0c2-80a9-42c3-bca3-64690ff159ef_SNAPS_','2020-11-23 20:19:26','2019-07-03 17:18:05','4211d279-56a3-454f-b752-6eaa303f7ee6.png','2020-11-23 21:19:26','SYNCED','4211d279-56a3-454f-b752-6eaa303f7ee6',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.9.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(163,'42483e0d-9fd2-4cf4-8ffc-4b3f97b0b998','','SNAPS','PATIENT_3e81f0de-1357-45a1-a1d1-75e348b3b043_ACT_4252a7af-d6d9-4447-b402-60820076dceb_SESS_6e0b4165-03cb-4f3b-bd97-fca211c1fe33_TOSC_1b051bff-7722-4829-8766-0b9476ca1a2b_SNAPS_','2021-12-16 21:25:59','2019-08-20 15:34:58','','2021-12-16 22:25:59','SYNCED','42483e0d-9fd2-4cf4-8ffc-4b3f97b0b998',0,'2021-12-16 22:25:59','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.12.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(163,'428a57a7-6701-41dd-8dd8-d8a01e1de216','','PLY','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_4829e17a-6262-4322-bd2d-12f3055adf7d_SESS_9f7449d6-1278-45d5-9492-02cd28be29ca_TOSC_9ed276f9-9775-47d3-ad07-589e561c3ce7_PLY_','2021-12-16 21:25:59','2019-08-20 15:13:10','','2021-12-16 22:25:59','SYNCED','428a57a7-6701-41dd-8dd8-d8a01e1de216',0,'2021-12-16 22:25:59','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.2.2.2\",\"modelMatrix\":\"0.241839,0.826558,-0.508247,0,-0.970316,0.206009,-0.126674,0,-6.762e-9,0.523795,0.851844,0,-27.4034,-34.3034,-5.51386,1\",\"title\":\"MAXILLAIRE PLY\"}'),(163,'43b78c5a-49ae-4a2c-a6cb-0acfa61d751c','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_c721c0c0-a514-44bc-af6d-0394b9e59459/16_w1_o1_maxillaire_scan_file_2.ply','PLY','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_TOSC_c721c0c0-a514-44bc-af6d-0394b9e59459_PLY_','2021-12-10 13:53:55','2019-10-09 19:27:13','16_w1_o1_maxillaire_scan_file_2.ply','2021-12-10 14:53:55','SYNCED','dafd74d2-dd54-4260-8a8a-ac8fdcfe717a',2,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"modelMatrix\":\"0.64116,-0.731017,0.233513,0,0.767408,0.610756,-0.195098,0,7.27128e-9,0.304289,0.95258,0,12.0061,-4.86171,-14.1394,1\",\"title\":\"MAXILLAIRE PLY\"}'),(163,'469b61a0-982e-4476-b1f0-695a8851103b','/var/.data/2022/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/409f26d0-a7e4-4813-8322-7342ba9597af/session_97e5ae19-9444-4dd2-9134-8f61d8d268df/occlusion_85186f51-753c-498e-8346-beea8a780c7b/computedocclusion_4d83f219-0b5d-4997-b640-b46da3aba91f/21_w2_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_97e5ae19-9444-4dd2-9134-8f61d8d268df_SESS_85186f51-753c-498e-8346-beea8a780c7b_OCC_4d83f219-0b5d-4997-b640-b46da3aba91f_SNAPO__SNAPS_','2022-02-12 14:45:23','2022-02-12 15:45:19','21_w2_o1_snapshot_occ_file_0.png','2022-02-12 15:45:23','SYNCED','469b61a0-982e-4476-b1f0-695a8851103b',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(163,'489ef9db-5210-4675-be4c-7c7b32faaa0f','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_04084a21-671f-49ef-a336-594796e4386f/16_w1_o1_mordu_anterieur_scan_file_0.ply','PLY','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_FRSC_04084a21-671f-49ef-a336-594796e4386f_PLY_','2021-12-10 13:53:55','2019-10-09 20:07:04','','2021-12-10 14:53:55','SYNCED','489ef9db-5210-4675-be4c-7c7b32faaa0f',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MORDU_ANTERIEUR 1.16.1.1.1\",\"modelMatrix\":\"0.886347,-0.228412,-0.409922,0,0.170257,0.973164,-0.109534,0,0.43108,0.0420153,0.905912,0,-4.658,-5.71516,-30.4802,1\",\"title\":\"MORDU_ANTERIEUR PLY\"}'),(163,'49fa018c-a1f8-41c3-89ca-42d90f70b465','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_c721c0c0-a514-44bc-af6d-0394b9e59459/16_w1_o1_maxillaire_scan_file_3.stl','STL','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_TOSC_c721c0c0-a514-44bc-af6d-0394b9e59459_STL_','2021-12-10 13:53:55','2019-10-09 19:30:43','','2021-12-10 14:53:55','SYNCED','5a0fc415-f9a5-4ae5-9e02-248ca895ca32',3,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1.1\",\"modelMatrix\":\"0.418185,-0.867684,0.268784,0,0.908362,0.399458,-0.123741,0,-8.03681e-9,0.2959,0.955219,0,11.3243,-2.98852,-14.4642,1\",\"title\":\"MAXILLAIRE STL\"}'),(163,'4ac1bde3-ded4-41d1-83a4-46e496e8b5cd','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/b9d4138d-2c8c-492f-bf20-3aa5437834df/session_54e4e76a-88ec-47fe-8787-b7d925a5a345/order_816f04b9-978f-4f25-b999-b4179ef17116/14_w1_inlay_onlay_prost_file_0.pdf','PDF','PATIENT_b9d4138d-2c8c-492f-bf20-3aa5437834df_ACT_54e4e76a-88ec-47fe-8787-b7d925a5a345_PROST_816f04b9-978f-4f25-b999-b4179ef17116_PDF_','2019-12-15 21:03:21','2019-09-05 20:06:30','','2019-12-15 22:03:21','SYNCED','4ac1bde3-ded4-41d1-83a4-46e496e8b5cd',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"INLAY ONLAY 1.14.1 INLAY ONLAY\",\"title\":\"Inlay/Onlay PDF\"}'),(163,'4b5f064c-9285-4119-bc00-8e7a6dd729b0','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_04084a21-671f-49ef-a336-594796e4386f/16_w1_o1_mordu_anterieur_scan_file_1.ply','PLY','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_FRSC_04084a21-671f-49ef-a336-594796e4386f_PLY_','2021-12-10 13:53:55','2019-10-09 20:10:11','','2021-12-10 14:53:55','SYNCED','489ef9db-5210-4675-be4c-7c7b32faaa0f',1,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mordu anterieur 1.16.1.1.1\",\"modelMatrix\":\"0.885046,-0.19799,-0.429918,0,0.128291,0.978969,-0.103016,0,0.447929,0.0712136,0.898315,0,-4.85615,-8.57613,-33.3341,1\",\"title\":\"MORDU_ANTERIEUR PLY\"}'),(163,'4c1113c9-3ec7-4c67-8bf8-3076f18cac31','/var/.data/2021/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/409f26d0-a7e4-4813-8322-7342ba9597af/session_87eba16d-aff7-41e9-9637-bf09b56f1030/occlusion_a53c56e5-88df-4213-95fa-5e72bf6599b9/scan_ff508a13-6fb6-4736-87b1-187a5e0330b5/21_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_87eba16d-aff7-41e9-9637-bf09b56f1030_SESS_a53c56e5-88df-4213-95fa-5e72bf6599b9_TOSC_ff508a13-6fb6-4736-87b1-187a5e0330b5_SNAPS_','2021-12-16 21:26:15','2021-04-11 11:57:45','21_w1_o1_maxillaire_snapshot_0.png','2021-12-16 22:26:15','SYNCED','4c1113c9-3ec7-4c67-8bf8-3076f18cac31',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire SNAPSHOT\",\"title\":\"Maxillaire SNAPSHOT\"}'),(163,'4c444508-c858-46f3-aa77-fa0f8322d1b9','','SNAPS','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_78f19188-19ad-480e-8d99-35699a9590fa_SESS_ea11a5f6-aafe-41d9-b61b-f8b13f045b1e_TOSC_02e51064-f0d6-446a-acb0-0b5ce80915d9_SNAPS_','2020-12-16 20:58:19','2017-07-07 15:00:08','',NULL,'SYNCED','4c444508-c858-46f3-aa77-fa0f8322d1b9',0,'2017-07-07 15:00:08','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"title\":\"Maxillaire SNAPSHOT\"}'),(163,'4c96b8bd-1cd4-4204-af6e-228db3257714','','STL','PATIENT_c3d48f98-f992-4b17-9ebd-a8f388b7e0ca_ACT_ce36d71d-debf-4f14-bbe8-30830b342bd3_SESS_2c9b2990-8860-4259-b919-67aa71e0b43f_TOSC_5b265bae-8c91-414d-bee3-c03fcfb27c19_STL_','2020-12-16 20:58:19','2017-09-23 10:30:21','',NULL,'SYNCED','4c96b8bd-1cd4-4204-af6e-228db3257714',0,'2017-09-23 10:30:21','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"modelMatrix\":\"0.990351,-0.114243,0.0784452,0,0.138582,0.816413,-0.560594,0,-1.0103e-10,0.566056,0.824367,0,-3.02464,-15.679,-16.4024,1\",\"title\":\"Maxillaire STL\"}'),(163,'4d049a4d-88f0-4043-a34b-c505c9e9d331','','STL','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_78f19188-19ad-480e-8d99-35699a9590fa_SESS_ea11a5f6-aafe-41d9-b61b-f8b13f045b1e_TOSC_2f578874-fe02-494a-b5ac-1b5da453aed0_STL_','2020-12-16 20:58:19','2017-07-07 15:14:53','',NULL,'SYNCED','4d049a4d-88f0-4043-a34b-c505c9e9d331',0,'2017-07-07 15:14:53','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"modelMatrix\":\"0.999717,0.023073,-0.00584865,0,-0.0238027,0.969068,-0.245644,0,-3.08567e-10,0.245713,0.969343,0,3.90502,-2.71809,-21.1945,1\",\"title\":\"Maxillaire STL\"}'),(163,'4d7867b4-9f52-49a2-88c8-83c3d4865095','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/bdb79646-26a6-440d-867f-112e46644df6/session_1ff39b04-4666-4c18-afaa-74990cd38521/occlusion_ae07c5e5-6b65-46ef-9cd1-c0a9daccea5f/scan_0796eab6-1d31-4c12-930b-d1645168f0cc/15_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_bdb79646-26a6-440d-867f-112e46644df6_ACT_1ff39b04-4666-4c18-afaa-74990cd38521_SESS_ae07c5e5-6b65-46ef-9cd1-c0a9daccea5f_FRSC_0796eab6-1d31-4c12-930b-d1645168f0cc_SNAPS_','2021-12-10 13:53:55','2019-09-18 15:29:53','','2021-12-10 14:53:55','SYNCED','4d7867b4-9f52-49a2-88c8-83c3d4865095',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mordu anterieur 1.15.1.1.1\",\"title\":\"MORDU_ANTERIEUR SNAPSHOT\"}'),(163,'4e06ebeb-9f37-41bc-9024-b3a5fb8571d9','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/b10e93aa-548c-427f-adcd-2dbc22bc6626/session_692fa6c8-2523-4d56-bebf-b736f05db142/occlusion_c2195287-5f39-4a66-93d5-5b83792fc9a8/scan_18cd0f29-a9fb-4dcd-91fe-8fb30a4d171a/17_w1_o1_maxillaire_snapshot_2.png','SNAPS','PATIENT_b10e93aa-548c-427f-adcd-2dbc22bc6626_ACT_692fa6c8-2523-4d56-bebf-b736f05db142_SESS_c2195287-5f39-4a66-93d5-5b83792fc9a8_TOSC_18cd0f29-a9fb-4dcd-91fe-8fb30a4d171a_SNAPS_','2021-12-10 13:53:55','2019-10-14 13:02:11','','2021-12-10 14:53:55','SYNCED','3d6af265-a88f-4743-a5e7-a9f9a29f81fb',2,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.17.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(163,'4e12bcab-9945-4ac0-80ca-4f849846a4bd','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/b10e93aa-548c-427f-adcd-2dbc22bc6626/session_692fa6c8-2523-4d56-bebf-b736f05db142/occlusion_c2195287-5f39-4a66-93d5-5b83792fc9a8/scan_18cd0f29-a9fb-4dcd-91fe-8fb30a4d171a/17_w1_o1_maxillaire_scan_file_0.ply','PLY','PATIENT_b10e93aa-548c-427f-adcd-2dbc22bc6626_ACT_692fa6c8-2523-4d56-bebf-b736f05db142_SESS_c2195287-5f39-4a66-93d5-5b83792fc9a8_TOSC_18cd0f29-a9fb-4dcd-91fe-8fb30a4d171a_PLY_','2021-12-10 13:53:55','2019-10-14 12:54:26','','2021-12-10 14:53:55','SYNCED','4e12bcab-9945-4ac0-80ca-4f849846a4bd',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.17.1.1.1\",\"modelMatrix\":\"0.999235,0.037218,-0.0119875,0,-0.0391009,0.951117,-0.306345,0,-7.18694e-10,0.306579,0.951845,0,-15.846,-16.1163,-11.7486,1\",\"title\":\"MAXILLAIRE PLY\"}'),(1,'4e406ac7-d775-4ae1-a021-065b692e23b6','/var/.data/2017/81719eb6-9836-45c5-a632-3098f463dde0/146dc0ed-e7c0-4b2a-9a6f-7fa2d76847ac/session_99140e2a-6c40-4cec-8b61-6b676b8308a5/occlusion_669bd839-b35f-4277-b25e-d33767724d18/scan_b78dcdc3-320d-4071-b1af-34f1a9dbaf7d/2_w1_maxillaire_scan_file_0.ply','PLY','PATIENT_146dc0ed-e7c0-4b2a-9a6f-7fa2d76847ac_ACT_99140e2a-6c40-4cec-8b61-6b676b8308a5_SESS_669bd839-b35f-4277-b25e-d33767724d18_TOSC_b78dcdc3-320d-4071-b1af-34f1a9dbaf7d_PLY_','2020-12-16 20:58:19','2017-05-26 09:59:09','2_w1_maxillaire_scan_file_0.ply',NULL,'SYNCED','4e406ac7-d775-4ae1-a021-065b692e23b6',0,NULL,'81719eb6-9836-45c5-a632-3098f463dde0',NULL,'{\"modelMatrix\":\"0.408509,0.90278,-0.134566,0,-0.912754,0.404045,-0.0602261,0,-5.51681e-09,0.147429,0.989073,0,5.2676,9.94783,-22.7385,1\",\"patientDisplayId\":\"8.2\"}'),(163,'4f05928e-7b4d-4f5d-80cb-38b13108dc65','','STL','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_4829e17a-6262-4322-bd2d-12f3055adf7d_SESS_be8b17ea-1f2d-4455-823c-87f31acb59e4_BOSC_993e81f9-b63b-42e8-9992-72d3942cce1a_STL_','2021-12-16 21:26:02','2019-08-20 14:32:27','','2021-12-16 22:26:02','SYNCED','11fa8713-51a4-4ebe-826b-f8e77b81fa64',1,'2021-12-16 22:26:02','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MANDIBULE 1.2.2.1\",\"modelMatrix\":\"0.782581,0.530544,-0.325715,0,-0.622549,0.666925,-0.409444,0,-1.03547e-8,0.523196,0.852212,0,-4.97091,-14.1252,-11.0101,1\",\"title\":\"MANDIBULE STL\"}'),(163,'50fdd65d-7e14-48e2-a3ca-6a69a2a4ec71','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/bdb79646-26a6-440d-867f-112e46644df6/session_1ff39b04-4666-4c18-afaa-74990cd38521/occlusion_ae07c5e5-6b65-46ef-9cd1-c0a9daccea5f/scan_0796eab6-1d31-4c12-930b-d1645168f0cc/15_w1_o1_mordu_anterieur_scan_file_0.ply','PLY','PATIENT_bdb79646-26a6-440d-867f-112e46644df6_ACT_1ff39b04-4666-4c18-afaa-74990cd38521_SESS_ae07c5e5-6b65-46ef-9cd1-c0a9daccea5f_FRSC_0796eab6-1d31-4c12-930b-d1645168f0cc_PLY_','2021-12-10 13:53:55','2019-09-19 17:37:02','','2021-12-10 14:53:55','SYNCED','50fdd65d-7e14-48e2-a3ca-6a69a2a4ec71',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mordu anterieur 1.15.1.1.1\",\"modelMatrix\":\"-0.985757,0.00142314,-0.165103,0,0.00926254,-0.999363,-0.0326102,0,-0.168013,-0.03611,0.985748,0,1.6677,-1.65917,-21.2856,1\",\"title\":\"MORDU_ANTERIEUR PLY\"}'),(163,'5511b6a1-dc48-4b08-a3c5-cb80df1ef921','','SNAPS','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_4829e17a-6262-4322-bd2d-12f3055adf7d_SESS_9f7449d6-1278-45d5-9492-02cd28be29ca_TOSC_9ed276f9-9775-47d3-ad07-589e561c3ce7_SNAPS_','2021-12-16 21:26:02','2019-08-20 15:13:10','','2021-12-16 22:26:02','SYNCED','5511b6a1-dc48-4b08-a3c5-cb80df1ef921',0,'2021-12-16 22:26:02','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.2.2.2\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(163,'56264e08-ee06-4c6f-8e9b-6d38cc8530b1','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_7cd8be19-c5e8-48d9-8950-c7006af5dda6/16_w1_o1_mordu_posterieur_droit_scan_file_4.stl','STL','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_RISC_7cd8be19-c5e8-48d9-8950-c7006af5dda6_STL_','2021-12-10 13:53:56','2019-10-09 20:02:37','','2021-12-10 14:53:56','SYNCED','a0840078-f705-4297-a590-258aedaa7cf8',4,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MORDU_POSTERIEUR_DROIT 1.16.1.1.1\",\"modelMatrix\":\"0.962333,-0.114478,0.246872,0,0.100349,0.992499,0.0637102,0,-0.252677,-0.0434926,0.966977,0,-1.61364,-3.64635,-14.6614,1\",\"title\":\"MORDU_POSTERIEUR_DROIT STL\"}'),(163,'5a0fc415-f9a5-4ae5-9e02-248ca895ca32','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_c721c0c0-a514-44bc-af6d-0394b9e59459/16_w1_o1_maxillaire_scan_file_0.stl','STL','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_TOSC_c721c0c0-a514-44bc-af6d-0394b9e59459_STL_','2021-12-10 13:53:56','2019-10-09 19:22:10','','2021-12-10 14:53:56','SYNCED','5a0fc415-f9a5-4ae5-9e02-248ca895ca32',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1.1\",\"modelMatrix\":\"0.410931,-0.866317,0.283955,0,0.911666,0.39049,-0.127992,0,6.27254e-9,0.311468,0.950257,0,9.07828,-8.54913,-11.8536,1\",\"title\":\"MAXILLAIRE STL\"}'),(163,'5a428bc0-3c04-4a62-be3e-9ba7fe2fb90e','/var/.data/2022/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/409f26d0-a7e4-4813-8322-7342ba9597af/session_97e5ae19-9444-4dd2-9134-8f61d8d268df/occlusion_85186f51-753c-498e-8346-beea8a780c7b/computedocclusion_4d83f219-0b5d-4997-b640-b46da3aba91f/21_w2_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_97e5ae19-9444-4dd2-9134-8f61d8d268df_SESS_85186f51-753c-498e-8346-beea8a780c7b_OCC_4d83f219-0b5d-4997-b640-b46da3aba91f_BOPLY__ZIP_','2022-02-12 14:45:21','2022-02-12 15:45:19','21_w2_o1_mandibule_occlusion_occ_file_0.zip','2022-02-12 15:45:21','SYNCED','5a428bc0-3c04-4a62-be3e-9ba7fe2fb90e',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mandibule 1.21.2.1.2 Occlusion 1\",\"modelMatrix\":\"-0.978078,-0.133691,0.159658,0,0.20824,-0.627928,0.749895,0,8.31149e-09,0.766703,0.642002,0,13.3814,-10.9477,-15.478,1\",\"referenceScanID\":\"1.21.2.1.2\",\"title\":\"Mandibule 1.21.2.1.2 Occlusion 1\"}'),(163,'5c5378c6-f77b-4b5d-a2dc-e7d066bcf273','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_4f66eeb0-72e9-4b3f-9e2e-2051256ddf18/16_w1_o1_mordu_posterieur_gauche_scan_file_0.stl','STL','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_LESC_4f66eeb0-72e9-4b3f-9e2e-2051256ddf18_STL_','2021-12-10 13:53:56','2019-10-09 20:04:18','','2021-12-10 14:53:56','SYNCED','5c5378c6-f77b-4b5d-a2dc-e7d066bcf273',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MORDU_POSTERIEUR_GAUCHE 1.16.1.1.1\",\"modelMatrix\":\"-0.969184,0.0737549,0.233925,0,-0.0019714,-0.955708,0.292156,0,0.246332,0.284935,0.927324,0,-10.2666,-10.7335,-16.1802,1\",\"title\":\"MORDU_POSTERIEUR_GAUCHE STL\"}'),(163,'5df203dd-8224-41c9-96b4-e9581babd5b4','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_c721c0c0-a514-44bc-af6d-0394b9e59459/16_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_TOSC_c721c0c0-a514-44bc-af6d-0394b9e59459_SNAPS_','2021-12-10 13:53:56','2019-10-09 19:25:52','16_w1_o1_maxillaire_snapshot_1.png','2021-12-10 14:53:56','SYNCED','07cdc5f1-9ddf-4eab-a043-c35a6f9783a0',1,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(163,'5e6d2e48-de8b-4d61-adcd-18525a78ce52','/var/.data/2021/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/409f26d0-a7e4-4813-8322-7342ba9597af/session_87eba16d-aff7-41e9-9637-bf09b56f1030/occlusion_a53c56e5-88df-4213-95fa-5e72bf6599b9/scan_ac9639e4-a6ce-49f4-b726-2783785c402d/21_w1_o1_maxillaire_scan_file_0.ply','PLY','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_87eba16d-aff7-41e9-9637-bf09b56f1030_SESS_a53c56e5-88df-4213-95fa-5e72bf6599b9_TOSC_ac9639e4-a6ce-49f4-b726-2783785c402d_PLY_','2021-12-16 21:26:09','2021-04-11 12:25:10','21_w1_o1_maxillaire_scan_file_0.ply','2021-12-16 22:26:09','SYNCED','5e6d2e48-de8b-4d61-adcd-18525a78ce52',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.21.1.1.4\",\"modelMatrix\":\"0.918918,0.295251,-0.261566,0,-0.394449,0.687825,-0.60935,0,7.30981e-9,0.663117,0.748516,0,-25.2062,-40.821,-12.2048,1\",\"title\":\"Maxillaire PLY\"}'),(163,'600a88ef-6d46-4292-867d-829372324c67','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_f1172a60-6504-4697-9acb-2793b430d7fe/16_w1_o1_mandibule_snapshot_2.png','SNAPS','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_BOSC_f1172a60-6504-4697-9acb-2793b430d7fe_SNAPS_','2021-12-10 13:53:56','2019-10-09 19:41:41','16_w1_o1_mandibule_snapshot_2.png','2021-12-10 14:53:56','SYNCED','ef91b022-83f4-4ff4-97e8-4bcb62ff5b6d',2,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MANDIBULE 1.16.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(163,'61b0112d-a867-41af-947e-13ece4d9fbe2','/var/.data/2021/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/409f26d0-a7e4-4813-8322-7342ba9597af/session_87eba16d-aff7-41e9-9637-bf09b56f1030/occlusion_a53c56e5-88df-4213-95fa-5e72bf6599b9/scan_bae5c384-8be6-46cb-914f-52893ff0a986/21_w1_o1_maxillaire_scan_file_2.ply','PLY','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_87eba16d-aff7-41e9-9637-bf09b56f1030_SESS_a53c56e5-88df-4213-95fa-5e72bf6599b9_TOSC_bae5c384-8be6-46cb-914f-52893ff0a986_PLY_','2021-12-16 21:26:34','2021-04-11 11:44:48','21_w1_o1_maxillaire_scan_file_2.ply','2021-12-16 22:26:34','SYNCED','71e2ee96-4fab-47a8-824e-8e926c4280ba',2,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.21.1.1.1\",\"modelMatrix\":\"-0.538079,-0.756767,0.371179,0,0.842894,-0.483098,0.23695,0,7.53675e-9,0.440363,0.89782,0,19.0525,-40.1463,-12.777,1\",\"title\":\"Maxillaire PLY\"}'),(163,'62599b0c-da27-495f-b818-77493722da47','','STL','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_4829e17a-6262-4322-bd2d-12f3055adf7d_SESS_be8b17ea-1f2d-4455-823c-87f31acb59e4_TOSC_073fbacf-ede3-4d02-b1ed-c47271ca0e8b_STL_','2021-12-16 21:26:02','2019-08-20 14:26:37','','2021-12-16 22:26:02','SYNCED','6bc71a1d-d0ff-492c-b3cc-bf5d0b0e7ec3',1,'2021-12-16 22:26:02','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.2.2.1\",\"modelMatrix\":\"0.995146,0.0916692,-0.0358017,0,-0.0984124,0.926958,-0.362027,0,1.18826e-9,0.363793,0.93148,0,-9.23998,-11.0505,-14.2369,1\",\"title\":\"MAXILLAIRE STL\"}'),(163,'62bd53c9-9933-4b00-8ef1-38d0f2d31e6e','/var/.data/2022/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/409f26d0-a7e4-4813-8322-7342ba9597af/session_97e5ae19-9444-4dd2-9134-8f61d8d268df/occlusion_85186f51-753c-498e-8346-beea8a780c7b/scan_cd569007-a8b8-4363-acd4-5ff36a438dbd/21_w2_o1_maxillaire_snapshot_3.png','SNAPS','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_97e5ae19-9444-4dd2-9134-8f61d8d268df_SESS_85186f51-753c-498e-8346-beea8a780c7b_TOSC_cd569007-a8b8-4363-acd4-5ff36a438dbd_SNAPS_','2022-02-12 15:32:07','2022-02-12 16:32:01','21_w2_o1_maxillaire_snapshot_3.png','2022-02-12 16:32:07','SYNCED','a9aa3381-bdc3-46c7-a6b4-5a267ebfb25d',3,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.21.2.1.6\",\"title\":\"Maxillaire SNAPSHOT\"}'),(163,'631bcc28-4111-4e0e-a212-e688ec1d3e11','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_f1172a60-6504-4697-9acb-2793b430d7fe/16_w1_o1_mandibule_scan_file_0.stl','STL','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_BOSC_f1172a60-6504-4697-9acb-2793b430d7fe_STL_','2021-12-10 13:53:56','2019-10-09 19:36:04','','2021-12-10 14:53:56','SYNCED','631bcc28-4111-4e0e-a212-e688ec1d3e11',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MANDIBULE 1.16.1.1.1\",\"modelMatrix\":\"0.981406,0.162503,-0.102148,0,-0.191942,0.830886,-0.52229,0,-1.24392e-8,0.532185,0.846628,0,0.422752,-14.4367,-22.0897,1\",\"title\":\"MANDIBULE STL\"}'),(163,'63637d4c-1873-4650-b296-f47906667d72','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_f1172a60-6504-4697-9acb-2793b430d7fe/16_w1_o1_mandibule_scan_file_1.ply','PLY','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_BOSC_f1172a60-6504-4697-9acb-2793b430d7fe_PLY_','2021-12-10 13:53:56','2019-10-09 19:38:18','16_w1_o1_mandibule_scan_file_1.ply','2021-12-10 14:53:56','SYNCED','fb3b6e24-9356-49d8-8960-dfd6ec1157f6',1,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MANDIBULE 1.16.1.1\",\"modelMatrix\":\"0.932882,0.243802,-0.265126,0,-0.360182,0.631455,-0.686683,0,9.46485e-9,0.736088,0.676886,0,1.17629,-20.9991,-17.5388,1\",\"title\":\"MANDIBULE PLY\"}'),(163,'637b2b70-d4cb-45b9-9b4b-26e077032bbb','','STL','PATIENT_c3d48f98-f992-4b17-9ebd-a8f388b7e0ca_ACT_ce36d71d-debf-4f14-bbe8-30830b342bd3_SESS_2c9b2990-8860-4259-b919-67aa71e0b43f_BOSC_3af0c7c7-068f-4b49-a043-c9deaf8798fc_STL_','2020-12-16 20:58:19','2017-09-23 11:51:55','',NULL,'CREATED','06fda1e2-604f-4d55-9109-753390f8de28',1,'2017-09-23 11:51:55','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"modelMatrix\":\"0.464279,-0.806799,0.365404,0,0.885689,0.422925,-0.191545,0,1.95659e-08,0.412564,0.910928,0,2.49506,-18.2306,-19.3693,1\",\"title\":\"Mandibule STL\"}'),(163,'64286f64-d288-471b-8ab7-0fa381df35a6','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/bdb79646-26a6-440d-867f-112e46644df6/session_1ff39b04-4666-4c18-afaa-74990cd38521/occlusion_ae07c5e5-6b65-46ef-9cd1-c0a9daccea5f/scan_753d010b-c7ba-4dc4-a9cb-eaa7680a0b86/15_w1_o1_mandibule_scan_file_0.ply','PLY','PATIENT_bdb79646-26a6-440d-867f-112e46644df6_ACT_1ff39b04-4666-4c18-afaa-74990cd38521_SESS_ae07c5e5-6b65-46ef-9cd1-c0a9daccea5f_BOSC_753d010b-c7ba-4dc4-a9cb-eaa7680a0b86_PLY_','2021-12-10 13:53:56','2019-09-18 15:27:35','','2021-12-10 14:53:56','SYNCED','64286f64-d288-471b-8ab7-0fa381df35a6',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mandibule 1.15.1.1.1\",\"modelMatrix\":\"-0.350708,0.928203,-0.124274,0,-0.936485,-0.347606,0.0465397,0,-2.44584e-9,0.132702,0.991156,0,-10.6528,6.31269,-22.2532,1\",\"title\":\"MANDIBULE PLY\"}'),(3,'647a36c9-483d-45d7-8671-52befd2d43a4','/var/.data/2021/7655b09e-027b-49c5-9b6c-832c6e41cee8/discussion_605c208e-ad38-4268-a678-5f04c6f9007f/647a36c9-483d-45d7-8671-52befd2d43a4.ply','PLY','PATIENT_dcc81b31-38ca-437f-b1e2-7dd685a6af0f_ACT_677738ea-9ad8-4e2a-9cd2-074bfa0bf78d_SESS_74fb8ff3-73e7-4d38-a4cf-efbd69884ace_TOSC_41bee0c2-80a9-42c3-bca3-64690ff159ef_PLY_','2020-11-23 20:19:26','2019-07-03 17:18:05','647a36c9-483d-45d7-8671-52befd2d43a4.ply','2020-11-23 21:19:26','SYNCED','647a36c9-483d-45d7-8671-52befd2d43a4',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.9.1.1.1\",\"modelMatrix\":\"0.972746,-0.229158,0.0353824,0,0.231873,0.961354,-0.148435,0,2.17642e-10,0.152594,0.988289,0,-35.8517,-15.8436,-18.6142,1\",\"title\":\"MAXILLAIRE PLY\"}'),(163,'657f26bc-ab53-4f46-875d-85b6d8c2ecb7','','PLY','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_87eba16d-aff7-41e9-9637-bf09b56f1030_SESS_a53c56e5-88df-4213-95fa-5e72bf6599b9_TOSC_606f5a2d-49c9-431b-adfc-bfd319d3757c_PLY_','2021-04-11 10:20:25','2021-04-11 12:15:56','',NULL,'CREATED','657f26bc-ab53-4f46-875d-85b6d8c2ecb7',0,'2021-04-11 12:20:25','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.21.1.1.3\",\"modelMatrix\":\"0.694186,-0.681111,0.232796,0,0.719796,0.656877,-0.224513,0,-8.5244e-9,0.323419,0.946256,0,6.04213,-10.027,-33.3378,1\",\"title\":\"Maxillaire PLY\"}'),(163,'66f7c057-b653-4b14-b57f-df9137dd6388','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/b9d4138d-2c8c-492f-bf20-3aa5437834df/session_54e4e76a-88ec-47fe-8787-b7d925a5a345/occlusion_92b33516-ba42-40bc-80ec-77c62a130f93/computedocclusion_92b33516-ba42-40bc-80ec-77cmigraoccl/14_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_b9d4138d-2c8c-492f-bf20-3aa5437834df_ACT_54e4e76a-88ec-47fe-8787-b7d925a5a345_SESS_92b33516-ba42-40bc-80ec-77c62a130f93_OCC_92b33516-ba42-40bc-80ec-77cmigraoccl_TOMA__MATRX_','2021-12-10 13:53:57','2019-08-28 20:00:06','','2021-12-10 14:53:57','SYNCED','66f7c057-b653-4b14-b57f-df9137dd6388',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.14.1.1\",\"title\":\"Matrice Transfo. Maxillaire MATRIX\"}'),(163,'67349e8c-f1af-4275-9741-d8f70cb19787','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_f1172a60-6504-4697-9acb-2793b430d7fe/16_w1_o1_mandibule_snapshot_3.png','SNAPS','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_BOSC_f1172a60-6504-4697-9acb-2793b430d7fe_SNAPS_','2021-12-10 13:53:57','2019-10-09 19:44:41','','2021-12-10 14:53:57','SYNCED','ef91b022-83f4-4ff4-97e8-4bcb62ff5b6d',3,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mandibule 1.16.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(163,'67f86da1-b93d-49a5-b128-ce4b4dbba427','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/order_0f0915f0-d99f-401f-bc07-6de3f1346d65/16_w1_couronne_sur_implant_prost_file_0.pdf','PDF','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_PROST_0f0915f0-d99f-401f-bc07-6de3f1346d65_PDF_','2019-12-15 21:03:21','2019-10-09 20:32:18','','2019-12-15 22:03:21','SYNCED','67f86da1-b93d-49a5-b128-ce4b4dbba427',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"COURONNE SUR IMPLANT 1.16.1 COURONNE SUR IMPLANT\",\"title\":\"Couronne sur Implant PDF\"}'),(163,'69056410-5cdd-435f-a663-cd4600b06e72','/var/.data/2022/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/409f26d0-a7e4-4813-8322-7342ba9597af/session_97e5ae19-9444-4dd2-9134-8f61d8d268df/occlusion_85186f51-753c-498e-8346-beea8a780c7b/scan_cd569007-a8b8-4363-acd4-5ff36a438dbd/21_w2_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_97e5ae19-9444-4dd2-9134-8f61d8d268df_SESS_85186f51-753c-498e-8346-beea8a780c7b_TOSC_cd569007-a8b8-4363-acd4-5ff36a438dbd_SNAPS_','2022-02-12 15:06:58','2022-02-12 16:06:49','21_w2_o1_maxillaire_snapshot_1.png','2022-02-12 16:06:58','SYNCED','a9aa3381-bdc3-46c7-a6b4-5a267ebfb25d',1,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.21.2.1.6\",\"title\":\"Maxillaire SNAPSHOT\"}'),(163,'69358d1c-9f7a-48fc-adcb-c56e9cf5ff0d','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_c721c0c0-a514-44bc-af6d-0394b9e59459/16_w1_o1_maxillaire_scan_file_2.stl','STL','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_TOSC_c721c0c0-a514-44bc-af6d-0394b9e59459_STL_','2021-12-10 13:53:57','2019-10-09 19:27:13','16_w1_o1_maxillaire_scan_file_2.stl','2021-12-10 14:53:57','SYNCED','5a0fc415-f9a5-4ae5-9e02-248ca895ca32',2,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"modelMatrix\":\"0.64116,-0.731017,0.233513,0,0.767408,0.610756,-0.195098,0,7.27128e-9,0.304289,0.95258,0,12.0061,-4.86171,-14.1394,1\",\"title\":\"MAXILLAIRE STL\"}'),(163,'69876a92-8c10-4ffc-a0a4-f0740c567866','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/b9d4138d-2c8c-492f-bf20-3aa5437834df/session_54e4e76a-88ec-47fe-8787-b7d925a5a345/occlusion_92b33516-ba42-40bc-80ec-77c62a130f93/14_w1_o1_maxillaire_contact_occ_file_0.ply','CONTACT','PATIENT_b9d4138d-2c8c-492f-bf20-3aa5437834df_ACT_54e4e76a-88ec-47fe-8787-b7d925a5a345_SESS_92b33516-ba42-40bc-80ec-77c62a130f93_TOCO__CONTACT_','2021-12-10 13:53:57','2019-08-28 20:00:06','','2021-12-10 14:53:57','SYNCED','69876a92-8c10-4ffc-a0a4-f0740c567866',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Pts de Contacts Maxillaire Occlusion 1.14.1.1\",\"title\":\"Pts de Contacts Maxillaire Occlusion CONTACT\"}'),(163,'69ab1861-8202-44b4-ab9c-aa1f8173d43a','','STL','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_4829e17a-6262-4322-bd2d-12f3055adf7d_SESS_9f7449d6-1278-45d5-9492-02cd28be29ca_TOSC_1c96bfa5-9beb-46a7-920d-54e049105cae_STL_','2021-12-16 21:26:02','2019-08-20 14:49:14','','2021-12-16 22:26:02','SYNCED','69ab1861-8202-44b4-ab9c-aa1f8173d43a',0,'2021-12-16 22:26:02','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.2.2.2\",\"modelMatrix\":\"0.326876,0.838569,-0.435837,0,-0.945067,0.290041,-0.150746,0,-1.10947e-9,0.461171,0.887311,0,6.91414,-39.8917,-13.1378,1\",\"title\":\"MAXILLAIRE STL\"}'),(3,'6b3439e3-43cd-441d-a50e-cd456df457c1','/var/.data/2021/7655b09e-027b-49c5-9b6c-832c6e41cee8/discussion_605c208e-ad38-4268-a678-5f04c6f9007f/6b3439e3-43cd-441d-a50e-cd456df457c1.json','JSON','PATIENT_f1ba7774-7c5d-40d1-adaf-bf5e9ddee4c5_ACT_6c4aa713-5123-4551-8db5-cfa1136bd86a_PROST_f22738cf-6b3e-437b-82a4-ba4f30397b8e_JSON_','2019-12-15 21:03:21','2019-07-08 15:35:21','6b3439e3-43cd-441d-a50e-cd456df457c1.json','2019-12-15 22:03:21','SYNCED','6b3439e3-43cd-441d-a50e-cd456df457c1',0,NULL,'','','{\"displayTitle\":\"COURONNE 2.2.2 COURONNE\",\"title\":\"Couronne JSON\"}'),(163,'6bc71a1d-d0ff-492c-b3cc-bf5d0b0e7ec3','','STL','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_4829e17a-6262-4322-bd2d-12f3055adf7d_SESS_be8b17ea-1f2d-4455-823c-87f31acb59e4_TOSC_073fbacf-ede3-4d02-b1ed-c47271ca0e8b_STL_','2021-12-16 21:26:03','2019-08-20 14:25:19','','2021-12-16 22:26:03','SYNCED','6bc71a1d-d0ff-492c-b3cc-bf5d0b0e7ec3',0,'2021-12-16 22:26:03','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mandibule Occlusion 1.2.2.1\",\"modelMatrix\":\"0.995496,0.0870518,-0.0375587,0,-0.0948086,0.914049,-0.394368,0,9.73178e-10,0.396153,0.918185,0,-9.5601,-11.7473,-13.9851,1\",\"title\":\"MAXILLAIRE STL\"}'),(163,'6c1402f2-cd34-461f-8bcd-719448b12370','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/b9d4138d-2c8c-492f-bf20-3aa5437834df/session_54e4e76a-88ec-47fe-8787-b7d925a5a345/occlusion_92b33516-ba42-40bc-80ec-77c62a130f93/scan_2961c928-7419-415c-a0c6-570bb108af7f/14_w1_o1_maxillaire_scan_file_0.ply','PLY','PATIENT_b9d4138d-2c8c-492f-bf20-3aa5437834df_ACT_54e4e76a-88ec-47fe-8787-b7d925a5a345_SESS_92b33516-ba42-40bc-80ec-77c62a130f93_TOSC_2961c928-7419-415c-a0c6-570bb108af7f_PLY_','2021-12-10 13:53:57','2019-08-28 19:42:44','','2021-12-10 14:53:57','SYNCED','6c1402f2-cd34-461f-8bcd-719448b12370',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.14.1.1.1\",\"modelMatrix\":\"0.904497,-0.4229,0.0551409,0,0.42648,0.896905,-0.116945,0,1.56132e-9,0.129293,0.991606,0,-0.332992,-5.0551,-18.1067,1\",\"title\":\"MAXILLAIRE PLY\"}'),(163,'71009f34-7ae1-4cb9-9556-58cfdb6630ec','','PLY','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_4829e17a-6262-4322-bd2d-12f3055adf7d_SESS_9f7449d6-1278-45d5-9492-02cd28be29ca_BOSC_26a71710-0617-458e-becc-629d4d7677c8_PLY_','2021-12-16 21:26:03','2019-08-20 14:57:25','','2021-12-16 22:26:03','SYNCED','71009f34-7ae1-4cb9-9556-58cfdb6630ec',0,'2021-12-16 22:26:03','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MANDIBULE 1.2.2.2\",\"modelMatrix\":\"0.840732,-0.539249,0.0487862,0,0.541452,0.837312,-0.0757521,0,1.83124e-9,0.0901026,0.995932,0,-4.84825,33.2266,-22.0715,1\",\"title\":\"MANDIBULE PLY\"}'),(163,'71847718-31ab-4ff8-a7f2-31b3d3797945','computedocclusion_92b33516-ba42-40bc-80ec-77cmigraoccl/','LIFIM','PATIENT_b9d4138d-2c8c-492f-bf20-3aa5437834df_ACT_54e4e76a-88ec-47fe-8787-b7d925a5a345_SESS_92b33516-ba42-40bc-80ec-77c62a130f93_OCC_92b33516-ba42-40bc-80ec-77cmigraoccl_LIFIMO_LIFIM_','2021-12-16 21:26:03','2019-08-29 15:23:58','','2021-12-16 22:26:03','SYNCED','71847718-31ab-4ff8-a7f2-31b3d3797945',0,'2021-12-16 22:26:03','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mandibule Occlusion 1.14.1.1\",\"isOcclusionMarginLine\":true,\"name\":\"Sans nom 0 Occlusion\",\"title\":\"MAXILLAIRE LIFI_META\",\"toothNumber\":1000,\"lifi_scan_type\":\"MAXILLAIRE\"}'),(163,'71e2ee96-4fab-47a8-824e-8e926c4280ba','/var/.data/2021/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/409f26d0-a7e4-4813-8322-7342ba9597af/session_87eba16d-aff7-41e9-9637-bf09b56f1030/occlusion_a53c56e5-88df-4213-95fa-5e72bf6599b9/scan_bae5c384-8be6-46cb-914f-52893ff0a986/21_w1_o1_maxillaire_scan_file_0.ply','PLY','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_87eba16d-aff7-41e9-9637-bf09b56f1030_SESS_a53c56e5-88df-4213-95fa-5e72bf6599b9_TOSC_bae5c384-8be6-46cb-914f-52893ff0a986_PLY_','2021-12-16 21:26:21','2021-04-11 10:11:49','21_w1_o1_maxillaire_scan_file_0.ply','2021-12-16 22:26:21','SYNCED','71e2ee96-4fab-47a8-824e-8e926c4280ba',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire PLY\",\"modelMatrix\":\"-0.491755,-0.78973,0.366746,0,0.870733,-0.446008,0.207124,0,-5.02689e-9,0.421192,0.906971,0,19.5997,-39.7351,-13.5121,1\",\"title\":\"Maxillaire PLY\"}'),(163,'72025620-698a-462f-92db-da5e4caf0dfd','/var/.data/2022/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/409f26d0-a7e4-4813-8322-7342ba9597af/session_97e5ae19-9444-4dd2-9134-8f61d8d268df/occlusion_85186f51-753c-498e-8346-beea8a780c7b/scan_3390e065-1f9a-438a-8024-2e1b03309150/21_w2_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_97e5ae19-9444-4dd2-9134-8f61d8d268df_SESS_85186f51-753c-498e-8346-beea8a780c7b_TOSC_3390e065-1f9a-438a-8024-2e1b03309150_SNAPS_','2022-02-12 14:36:23','2022-02-12 15:36:21','21_w2_o1_maxillaire_snapshot_1.png','2022-02-12 15:36:23','SYNCED','25113e99-c3e7-4d17-9c78-0289f82697f0',1,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.21.2.1.4\",\"title\":\"Maxillaire SNAPSHOT\"}'),(163,'72d4e8b8-2ebb-4d1f-9ca9-3fb0a8e1ea48','','PLY','PATIENT_c3d48f98-f992-4b17-9ebd-a8f388b7e0ca_ACT_ce36d71d-debf-4f14-bbe8-30830b342bd3_SESS_2c9b2990-8860-4259-b919-67aa71e0b43f_TOSC_5b265bae-8c91-414d-bee3-c03fcfb27c19_PLY_','2020-12-16 20:58:19','2017-09-23 10:30:21','',NULL,'SYNCED','72d4e8b8-2ebb-4d1f-9ca9-3fb0a8e1ea48',0,'2017-09-23 10:30:21','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"modelMatrix\":\"0.990351,-0.114243,0.0784452,0,0.138582,0.816413,-0.560594,0,-1.0103e-10,0.566056,0.824367,0,-3.02464,-15.679,-16.4024,1\",\"title\":\"Maxillaire PLY\"}'),(163,'752e53bc-9b9f-4861-ab01-bfae139d6a4a','/var/.data/2020/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/1288ba7c-0bcf-4c6f-92e7-2873863af918/session_1a37c2d2-e6a1-4863-8afb-27944d3a7e33/occlusion_7560d619-3fa6-414c-85d8-52a724ef7bf4/scan_e45e36ef-7d3d-43b1-bfcd-00f5c6766a24/20_w1_o1_maxillaire_scan_file_0.ply','PLY','PATIENT_1288ba7c-0bcf-4c6f-92e7-2873863af918_ACT_1a37c2d2-e6a1-4863-8afb-27944d3a7e33_SESS_7560d619-3fa6-414c-85d8-52a724ef7bf4_TOSC_e45e36ef-7d3d-43b1-bfcd-00f5c6766a24_PLY_','2021-12-10 13:53:57','2020-02-17 11:47:42','20_w1_o1_maxillaire_scan_file_0.ply','2021-12-10 14:53:57','SYNCED','752e53bc-9b9f-4861-ab01-bfae139d6a4a',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.20.1.1.2\",\"modelMatrix\":\"0.92629,-0.346403,0.148298,0,0.376812,0.851538,-0.364549,0,5.2506e-9,0.393559,0.919299,0,-10.5778,-4.5381,-18.052,1\",\"title\":\"MAXILLAIRE PLY\"}'),(163,'7555c2a5-cd64-4010-aaec-f25c5371e1b4','','SNAPS','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_78f19188-19ad-480e-8d99-35699a9590fa_SESS_ea11a5f6-aafe-41d9-b61b-f8b13f045b1e_BOSC_a83382e1-a424-413d-b331-e18fb09d8050_SNAPS_','2020-12-16 20:58:19','2017-07-07 14:53:43','',NULL,'SYNCED','7555c2a5-cd64-4010-aaec-f25c5371e1b4',0,'2017-07-07 14:53:43','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"title\":\"Mandibule SNAPSHOT\"}'),(163,'75ac9adc-2f27-4f4f-8b5a-4eaf930c1045','/var/.data/2021/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/409f26d0-a7e4-4813-8322-7342ba9597af/session_87eba16d-aff7-41e9-9637-bf09b56f1030/occlusion_a53c56e5-88df-4213-95fa-5e72bf6599b9/scan_ac9639e4-a6ce-49f4-b726-2783785c402d/21_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_87eba16d-aff7-41e9-9637-bf09b56f1030_SESS_a53c56e5-88df-4213-95fa-5e72bf6599b9_TOSC_ac9639e4-a6ce-49f4-b726-2783785c402d_SNAPS_','2021-12-16 21:25:58','2021-04-11 12:25:10','21_w1_o1_maxillaire_snapshot_0.png','2021-12-16 22:25:58','SYNCED','75ac9adc-2f27-4f4f-8b5a-4eaf930c1045',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.21.1.1.4\",\"title\":\"Maxillaire SNAPSHOT\"}'),(163,'762a3b6d-dc65-4c0f-b252-3f012d6880ed','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_f1172a60-6504-4697-9acb-2793b430d7fe/16_w1_o1_mandibule_scan_file_3.ply','PLY','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_BOSC_f1172a60-6504-4697-9acb-2793b430d7fe_PLY_','2021-12-10 13:53:57','2019-10-09 19:44:41','','2021-12-10 14:53:57','SYNCED','fb3b6e24-9356-49d8-8960-dfd6ec1157f6',3,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mandibule 1.16.1.1.1\",\"modelMatrix\":\"0.903443,0.359697,-0.233258,0,-0.428708,0.758011,-0.491557,0,4.7123e-9,0.544094,0.839024,0,-1.68174,-17.6788,-21.6512,1\",\"title\":\"MANDIBULE PLY\"}'),(163,'764731ff-7791-45c8-ae68-82dd2bbe2346','','PLY','PATIENT_3e81f0de-1357-45a1-a1d1-75e348b3b043_ACT_4252a7af-d6d9-4447-b402-60820076dceb_SESS_6e0b4165-03cb-4f3b-bd97-fca211c1fe33_TOSC_1b051bff-7722-4829-8766-0b9476ca1a2b_PLY_','2021-12-16 21:26:03','2019-08-20 15:34:58','','2021-12-16 22:26:03','SYNCED','764731ff-7791-45c8-ae68-82dd2bbe2346',0,'2021-12-16 22:26:03','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.12.1.1\",\"modelMatrix\":\"-0.910111,0.396347,-0.120857,0,-0.414363,-0.870539,0.26545,0,-3.60985e-9,0.291668,0.956519,0,1.87354,-6.17378,-16.5835,1\",\"title\":\"MAXILLAIRE PLY\"}'),(163,'76555b35-9c78-4952-908e-1ada8ee3b976','','PLY','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_4829e17a-6262-4322-bd2d-12f3055adf7d_SESS_be8b17ea-1f2d-4455-823c-87f31acb59e4_TOSC_073fbacf-ede3-4d02-b1ed-c47271ca0e8b_PLY_','2021-12-16 21:26:04','2019-08-20 14:26:37','','2021-12-16 22:26:04','SYNCED','04d6ba70-17fa-4ec6-b60a-ae8c83a21656',1,'2021-12-16 22:26:04','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.2.2.1\",\"modelMatrix\":\"0.995146,0.0916692,-0.0358017,0,-0.0984124,0.926958,-0.362027,0,1.18826e-9,0.363793,0.93148,0,-9.23998,-11.0505,-14.2369,1\",\"title\":\"MAXILLAIRE PLY\"}'),(163,'76dda0ce-1254-4edd-bfae-486661f8e03d','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_7cd8be19-c5e8-48d9-8950-c7006af5dda6/16_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_RISC_7cd8be19-c5e8-48d9-8950-c7006af5dda6_SNAPS_','2021-12-10 13:53:58','2019-10-09 19:49:41','','2021-12-10 14:53:58','SYNCED','76dda0ce-1254-4edd-bfae-486661f8e03d',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MORDU_POSTERIEUR_DROIT 1.16.1.1.1\",\"title\":\"MORDU_POSTERIEUR_DROIT SNAPSHOT\"}'),(3,'7738e4ec-b2c9-465c-a9b7-71d77c2a1c91','/var/.data/2021/7655b09e-027b-49c5-9b6c-832c6e41cee8/discussion_605c208e-ad38-4268-a678-5f04c6f9007f/7738e4ec-b2c9-465c-a9b7-71d77c2a1c91.stl','STL','PATIENT_f1ba7774-7c5d-40d1-adaf-bf5e9ddee4c5_ACT_6c4aa713-5123-4551-8db5-cfa1136bd86a_SESS_b1f65e85-2a53-4c07-89bc-95a34ee8c209_TOSC_3a6328c7-ecc7-45ef-b5b6-32a9abadded8_STL_','2020-11-23 20:19:26','2019-07-08 15:30:28','7738e4ec-b2c9-465c-a9b7-71d77c2a1c91.stl','2020-11-23 21:19:26','SYNCED','7738e4ec-b2c9-465c-a9b7-71d77c2a1c91',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 2.2.2.1.1\",\"modelMatrix\":\"0.562045,-0.814585,0.143379,0,0.827107,0.553535,-0.0974305,0,2.22825e-9,0.17335,0.98486,0,-11.7114,14.098,-15.7553,1\",\"title\":\"MAXILLAIRE STL\"}'),(163,'77bd0e85-8efc-4891-ac66-9952c05b0022','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_c721c0c0-a514-44bc-af6d-0394b9e59459/16_w1_o1_maxillaire_scan_file_1.ply','PLY','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_TOSC_c721c0c0-a514-44bc-af6d-0394b9e59459_PLY_','2021-12-10 13:53:58','2019-10-09 19:25:52','16_w1_o1_maxillaire_scan_file_1.ply','2021-12-10 14:53:58','SYNCED','dafd74d2-dd54-4260-8a8a-ac8fdcfe717a',1,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"modelMatrix\":\"0.616332,-0.745321,0.254229,0,0.787486,0.58333,-0.198974,0,-1.48837e-8,0.322836,0.946455,0,11.7771,-5.53411,-13.8309,1\",\"title\":\"MAXILLAIRE PLY\"}'),(163,'784ec1f1-3dc8-422a-82e5-68c5869965cc','','SNAPS','PATIENT_c3d48f98-f992-4b17-9ebd-a8f388b7e0ca_ACT_ce36d71d-debf-4f14-bbe8-30830b342bd3_SESS_2c9b2990-8860-4259-b919-67aa71e0b43f_BOSC_3af0c7c7-068f-4b49-a043-c9deaf8798fc_SNAPS_','2020-12-16 20:58:19','2017-09-23 11:51:55','',NULL,'CREATED','9223ddc8-c22b-432b-8e5b-e2bbed0d9bce',2,'2017-09-23 11:51:55','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"title\":\"Mandibule SNAPSHOT\"}'),(163,'78dbcda8-e113-49fc-942b-1ead943195ae','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/b9d4138d-2c8c-492f-bf20-3aa5437834df/session_54e4e76a-88ec-47fe-8787-b7d925a5a345/occlusion_92b33516-ba42-40bc-80ec-77c62a130f93/computedocclusion_92b33516-ba42-40bc-80ec-77cmigraoccl/14_w1_o1_mandibule_occlusion_occ_file_1.ply','PLY','PATIENT_b9d4138d-2c8c-492f-bf20-3aa5437834df_ACT_54e4e76a-88ec-47fe-8787-b7d925a5a345_SESS_92b33516-ba42-40bc-80ec-77c62a130f93_OCC_92b33516-ba42-40bc-80ec-77cmigraoccl_BOPLY__PLY_','2021-12-10 13:53:58','2019-08-28 20:01:50','','2021-12-10 14:53:58','SYNCED','d4cc7dce-72d7-4f4a-9d50-2c92da97a233',1,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mandibule Occlusion 1.14.1.1\",\"title\":\"Mandibule Occlusion PLY\"}'),(163,'79018a8b-f206-4a43-a634-64204d878940','','STL','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_4829e17a-6262-4322-bd2d-12f3055adf7d_SESS_9f7449d6-1278-45d5-9492-02cd28be29ca_BOSC_26a71710-0617-458e-becc-629d4d7677c8_STL_','2021-12-16 21:26:04','2019-08-20 14:57:25','','2021-12-16 22:26:04','SYNCED','79018a8b-f206-4a43-a634-64204d878940',0,'2021-12-16 22:26:04','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MANDIBULE 1.2.2.2\",\"modelMatrix\":\"0.840732,-0.539249,0.0487862,0,0.541452,0.837312,-0.0757521,0,1.83124e-9,0.0901026,0.995932,0,-4.84825,33.2266,-22.0715,1\",\"title\":\"MANDIBULE STL\"}'),(163,'797372b9-0108-43a4-8d44-c4b10f1f6b57','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_7cd8be19-c5e8-48d9-8950-c7006af5dda6/16_w1_o1_mordu_posterieur_droit_scan_file_2.stl','STL','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_RISC_7cd8be19-c5e8-48d9-8950-c7006af5dda6_STL_','2021-12-10 13:53:58','2019-10-09 19:55:54','16_w1_o1_mordu_posterieur_droit_scan_file_2.stl','2021-12-10 14:53:58','SYNCED','a0840078-f705-4297-a590-258aedaa7cf8',2,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MORDU_POSTERIEUR_DROIT 1.16.1.1\",\"modelMatrix\":\"0.963071,-0.12478,0.239477,0,0.112827,0.991353,0.0643275,0,-0.244476,-0.041076,0.968787,0,-1.13169,-3.89187,-14.4966,1\",\"title\":\"MORDU_POSTERIEUR_DROIT STL\"}'),(163,'7a9749e4-92f4-4da4-8285-8bfcc18562dc','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_f1172a60-6504-4697-9acb-2793b430d7fe/16_w1_o1_mandibule_scan_file_3.stl','STL','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_BOSC_f1172a60-6504-4697-9acb-2793b430d7fe_STL_','2021-12-10 13:53:58','2019-10-09 19:44:41','','2021-12-10 14:53:58','SYNCED','631bcc28-4111-4e0e-a212-e688ec1d3e11',3,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MANDIBULE 1.16.1.1.1\",\"modelMatrix\":\"0.903443,0.359697,-0.233258,0,-0.428708,0.758011,-0.491557,0,4.7123e-9,0.544094,0.839024,0,-1.68174,-17.6788,-21.6512,1\",\"title\":\"MANDIBULE STL\"}'),(163,'7d880d12-8b38-442f-bd8a-2b0e2ba3c858','','SNAPS','PATIENT_c3d48f98-f992-4b17-9ebd-a8f388b7e0ca_ACT_ce36d71d-debf-4f14-bbe8-30830b342bd3_SESS_2c9b2990-8860-4259-b919-67aa71e0b43f_BOSC_3af0c7c7-068f-4b49-a043-c9deaf8798fc_SNAPS_','2020-12-16 20:58:19','2017-09-23 11:51:55','',NULL,'CREATED','9223ddc8-c22b-432b-8e5b-e2bbed0d9bce',1,'2017-09-23 11:51:55','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"title\":\"Mandibule SNAPSHOT\"}'),(163,'7d9bfb0d-1cae-4e52-947a-72ab21c7f74c','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/b9d4138d-2c8c-492f-bf20-3aa5437834df/session_54e4e76a-88ec-47fe-8787-b7d925a5a345/occlusion_92b33516-ba42-40bc-80ec-77c62a130f93/scan_2961c928-7419-415c-a0c6-570bb108af7f/14_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_b9d4138d-2c8c-492f-bf20-3aa5437834df_ACT_54e4e76a-88ec-47fe-8787-b7d925a5a345_SESS_92b33516-ba42-40bc-80ec-77c62a130f93_TOSC_2961c928-7419-415c-a0c6-570bb108af7f_SNAPS_','2021-12-10 13:53:58','2019-08-28 19:42:44','','2021-12-10 14:53:58','SYNCED','7d9bfb0d-1cae-4e52-947a-72ab21c7f74c',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.14.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(163,'7e6be391-d34a-4c0f-8079-2e159f2dacd3','','STL','PATIENT_c8f81196-baea-4404-bca2-c39acd92734c_ACT_208338ea-2209-4f7c-ad22-9db0447ff940_SESS_26578904-6388-4b67-926c-fa9cede7abea_TOSC_195ffba3-6544-4214-acf3-3a4088cbb672_STL_','2020-12-16 20:58:19','2017-07-07 15:46:20','',NULL,'SYNCED','7e6be391-d34a-4c0f-8079-2e159f2dacd3',0,'2019-08-07 10:12:43','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.3.1.1\",\"modelMatrix\":\"0.918753,-0.391723,0.0494602,0,0.394833,0.911516,-0.115091,0,1.72298e-09,0.125269,0.992123,0,-14.4652,-1.59413,-15.449,1\",\"title\":\"Maxillaire STL\"}'),(163,'7ed5d04f-5da5-4b8f-9528-5ea7290ef17a','','PLY','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_78f19188-19ad-480e-8d99-35699a9590fa_SESS_ea11a5f6-aafe-41d9-b61b-f8b13f045b1e_TOSC_2f578874-fe02-494a-b5ac-1b5da453aed0_PLY_','2020-12-16 20:58:19','2017-07-07 15:14:53','',NULL,'SYNCED','7ed5d04f-5da5-4b8f-9528-5ea7290ef17a',0,'2017-07-07 15:14:53','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"modelMatrix\":\"0.999717,0.023073,-0.00584865,0,-0.0238027,0.969068,-0.245644,0,-3.08567e-10,0.245713,0.969343,0,3.90502,-2.71809,-21.1945,1\",\"title\":\"Maxillaire PLY\"}'),(163,'7f7478f0-370a-42e0-ae41-55eb424c1542','','PLY','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_78f19188-19ad-480e-8d99-35699a9590fa_SESS_ea11a5f6-aafe-41d9-b61b-f8b13f045b1e_BOSC_4f70034d-9a83-44fd-bb82-e82e6766d783_PLY_','2020-12-16 20:58:19','2017-07-07 14:31:25','',NULL,'SYNCED','7f7478f0-370a-42e0-ae41-55eb424c1542',0,'2017-07-07 14:31:25','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"modelMatrix\":\"0.900265,0.409128,-0.148783,0,-0.435342,0.846057,-0.307677,0,5.42277e-09,0.341762,0.939787,0,-9.48244,-8.94828,-22.5093,1\",\"title\":\"Mandibule PLY\"}'),(163,'7fe0b9f5-3acf-4966-8a2b-b615d4be86d3','','SNAPS','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_78f19188-19ad-480e-8d99-35699a9590fa_SESS_ea11a5f6-aafe-41d9-b61b-f8b13f045b1e_TOSC_17981b33-27cc-453f-b1fe-d84e831b12c6_SNAPS_','2020-12-16 20:58:19','2017-07-07 15:01:46','',NULL,'SYNCED','7fe0b9f5-3acf-4966-8a2b-b615d4be86d3',0,'2017-07-07 15:01:46','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"title\":\"Maxillaire SNAPSHOT\"}'),(163,'812d3ded-5efc-4768-afe5-7ef344ae2eef','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/b10e93aa-548c-427f-adcd-2dbc22bc6626/session_692fa6c8-2523-4d56-bebf-b736f05db142/occlusion_c2195287-5f39-4a66-93d5-5b83792fc9a8/scan_18cd0f29-a9fb-4dcd-91fe-8fb30a4d171a/17_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_b10e93aa-548c-427f-adcd-2dbc22bc6626_ACT_692fa6c8-2523-4d56-bebf-b736f05db142_SESS_c2195287-5f39-4a66-93d5-5b83792fc9a8_TOSC_18cd0f29-a9fb-4dcd-91fe-8fb30a4d171a_SNAPS_','2021-12-10 13:53:58','2019-10-14 12:57:56','17_w1_o1_maxillaire_snapshot_1.png','2021-12-10 14:53:58','SYNCED','3d6af265-a88f-4743-a5e7-a9f9a29f81fb',1,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mandibule Occlusion 1.17.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(163,'819653ad-864a-4e20-9933-b4bc60307323','','PLY','PATIENT_c3d48f98-f992-4b17-9ebd-a8f388b7e0ca_ACT_ce36d71d-debf-4f14-bbe8-30830b342bd3_SESS_2c9b2990-8860-4259-b919-67aa71e0b43f_BOSC_3af0c7c7-068f-4b49-a043-c9deaf8798fc_PLY_','2020-12-16 20:58:19','2017-09-23 11:51:55','',NULL,'CREATED','23f1b081-9ad4-49bf-b123-0d1971f56cab',3,'2017-09-23 11:51:55','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"modelMatrix\":\"0.766152,-0.220278,0.603729,0,0.64266,0.262607,-0.71974,0,-8.99308e-09,0.939423,0.342761,0,-4.48061,-25.3575,-8.68167,1\",\"title\":\"Mandibule PLY\"}'),(3,'82870def-459f-430b-a808-fc1b88e3fc29','/var/.data/2021/7655b09e-027b-49c5-9b6c-832c6e41cee8/discussion_605c208e-ad38-4268-a678-5f04c6f9007f/82870def-459f-430b-a808-fc1b88e3fc29.png','SNAPS','PATIENT_f1ba7774-7c5d-40d1-adaf-bf5e9ddee4c5_ACT_6c4aa713-5123-4551-8db5-cfa1136bd86a_SESS_b1f65e85-2a53-4c07-89bc-95a34ee8c209_BOSC_ac62ad28-ce76-4c21-8909-4348bd46d50f_SNAPS_','2020-11-23 20:19:26','2019-07-08 15:32:31','82870def-459f-430b-a808-fc1b88e3fc29.png','2020-11-23 21:19:26','SYNCED','82870def-459f-430b-a808-fc1b88e3fc29',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 2.2.2.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(163,'853cfd60-31d8-4c11-a0dc-b0a68a6c74ce','','SNAPS','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_78f19188-19ad-480e-8d99-35699a9590fa_SESS_ea11a5f6-aafe-41d9-b61b-f8b13f045b1e_TOSC_b6ed79b7-008c-41ab-bff5-854add43f023_SNAPS_','2020-12-16 20:58:19','2017-06-21 09:49:34','',NULL,'CREATED','853cfd60-31d8-4c11-a0dc-b0a68a6c74ce',0,'2018-06-26 17:07:29','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','','{\"patientDisplayId\":\"1.2\"}'),(163,'87144a98-d15e-4dc3-bcb4-339cd6015590','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/b9d4138d-2c8c-492f-bf20-3aa5437834df/session_54e4e76a-88ec-47fe-8787-b7d925a5a345/order_816f04b9-978f-4f25-b999-b4179ef17116/14_w1_inlay_onlay_prost_file_0.json','JSON','PATIENT_b9d4138d-2c8c-492f-bf20-3aa5437834df_ACT_54e4e76a-88ec-47fe-8787-b7d925a5a345_PROST_816f04b9-978f-4f25-b999-b4179ef17116_JSON_','2019-12-15 21:03:21','2019-09-05 20:06:30','','2019-12-15 22:03:21','SYNCED','87144a98-d15e-4dc3-bcb4-339cd6015590',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"INLAY ONLAY 1.14.1 INLAY ONLAY\",\"title\":\"Inlay/Onlay JSON\"}'),(163,'8824e951-379b-45ae-9210-b4228cc832a2','','SNAPS','PATIENT_c3d48f98-f992-4b17-9ebd-a8f388b7e0ca_ACT_ce36d71d-debf-4f14-bbe8-30830b342bd3_SESS_2c9b2990-8860-4259-b919-67aa71e0b43f_TOSC_33cf5659-a381-4c06-9187-ad29576848da_SNAPS_','2020-12-16 20:58:19','2017-09-23 10:32:51','',NULL,'SYNCED','8824e951-379b-45ae-9210-b4228cc832a2',0,'2017-09-23 10:32:51','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"title\":\"Maxillaire SNAPSHOT\"}'),(163,'88a3a973-9f5c-40bf-b35a-7ac9ccd2a5f2','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_f1172a60-6504-4697-9acb-2793b430d7fe/16_w1_o1_mandibule_scan_file_2.stl','STL','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_BOSC_f1172a60-6504-4697-9acb-2793b430d7fe_STL_','2021-12-10 13:53:58','2019-10-09 19:41:41','16_w1_o1_mandibule_scan_file_2.stl','2021-12-10 14:53:58','SYNCED','631bcc28-4111-4e0e-a212-e688ec1d3e11',2,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MANDIBULE 1.16.1.1\",\"modelMatrix\":\"0.898195,0.348615,-0.267795,0,-0.439598,0.712296,-0.547164,0,9.87468e-10,0.609182,0.79303,0,-2.10571,-18.6031,-20.6383,1\",\"title\":\"MANDIBULE STL\"}'),(163,'88c19117-97fb-4589-a086-5b48d3765732','/var/.data/2022/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/409f26d0-a7e4-4813-8322-7342ba9597af/session_97e5ae19-9444-4dd2-9134-8f61d8d268df/occlusion_85186f51-753c-498e-8346-beea8a780c7b/scan_3390e065-1f9a-438a-8024-2e1b03309150/21_w2_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_97e5ae19-9444-4dd2-9134-8f61d8d268df_SESS_85186f51-753c-498e-8346-beea8a780c7b_TOSC_3390e065-1f9a-438a-8024-2e1b03309150_ZIP_','2022-02-12 14:34:56','2022-02-12 15:34:55','21_w2_o1_maxillaire_scan_file_0.zip','2022-02-12 15:34:56','SYNCED','88c19117-97fb-4589-a086-5b48d3765732',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.21.2.1.4\",\"modelMatrix\":\"-0.215101,0.923386,-0.317947,0,-0.976592,-0.203382,0.0700301,0,-2.15849e-09,0.325568,0.945518,0,4.64996,-16.2535,-14.85,1\",\"title\":\"Maxillaire ZIP\"}'),(163,'8a9433cc-16c8-47db-8cba-6b849b3e9718','','SNAPS','PATIENT_c3d48f98-f992-4b17-9ebd-a8f388b7e0ca_ACT_ce36d71d-debf-4f14-bbe8-30830b342bd3_SESS_2c9b2990-8860-4259-b919-67aa71e0b43f_BOSC_7a1e80e2-3ff5-435d-8603-bf4d9090c2f2_SNAPS_','2020-12-16 20:58:19','2017-09-23 10:54:39','',NULL,'SYNCED','8a9433cc-16c8-47db-8cba-6b849b3e9718',0,'2017-09-23 10:54:39','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"title\":\"Mandibule SNAPSHOT\"}'),(163,'8d8bb1d2-703a-485b-87dc-e53404858cfe','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/b9d4138d-2c8c-492f-bf20-3aa5437834df/session_54e4e76a-88ec-47fe-8787-b7d925a5a345/occlusion_92b33516-ba42-40bc-80ec-77c62a130f93/scan_be3fdbda-df17-4184-bf04-6f17a0efb2c6/14_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_b9d4138d-2c8c-492f-bf20-3aa5437834df_ACT_54e4e76a-88ec-47fe-8787-b7d925a5a345_SESS_92b33516-ba42-40bc-80ec-77c62a130f93_LESC_be3fdbda-df17-4184-bf04-6f17a0efb2c6_SNAPS_','2021-12-10 13:53:59','2019-08-28 19:56:43','','2021-12-10 14:53:59','SYNCED','8d8bb1d2-703a-485b-87dc-e53404858cfe',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mordu posterieur gauche 1.14.1.1.1\",\"title\":\"MORDU_POSTERIEUR_GAUCHE SNAPSHOT\"}'),(163,'8ef3aa5a-839a-4af3-8b68-c5896c6d8f2a','','PLY','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_4829e17a-6262-4322-bd2d-12f3055adf7d_SESS_9f7449d6-1278-45d5-9492-02cd28be29ca_TOSC_1c96bfa5-9beb-46a7-920d-54e049105cae_PLY_','2021-12-16 21:26:04','2019-08-20 14:49:14','','2021-12-16 22:26:04','SYNCED','8ef3aa5a-839a-4af3-8b68-c5896c6d8f2a',0,'2021-12-16 22:26:04','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.2.2.2\",\"modelMatrix\":\"0.326876,0.838569,-0.435837,0,-0.945067,0.290041,-0.150746,0,-1.10947e-9,0.461171,0.887311,0,6.91414,-39.8917,-13.1378,1\",\"title\":\"MAXILLAIRE PLY\"}'),(163,'8f08a4aa-c3db-47d5-8812-811198ddca5a','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_7cd8be19-c5e8-48d9-8950-c7006af5dda6/16_w1_o1_mordu_posterieur_droit_scan_file_0.ply','PLY','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_RISC_7cd8be19-c5e8-48d9-8950-c7006af5dda6_PLY_','2021-12-10 13:53:59','2019-10-09 19:49:41','','2021-12-10 14:53:59','SYNCED','8f08a4aa-c3db-47d5-8812-811198ddca5a',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MORDU_POSTERIEUR_DROIT 1.16.1.1.1\",\"modelMatrix\":\"0.970733,-0.155238,0.194951,0,0.149682,0.987229,0.0496399,0,-0.188286,-0.0432154,0.979917,0,-4.57,-3.77931,-14.8961,1\",\"title\":\"MORDU_POSTERIEUR_DROIT PLY\"}'),(163,'905ddea2-ff14-48f0-b814-44ab659a02e9','','PLY','PATIENT_06f2a3bd-d1ba-4ac0-8808-522987236cbe_ACT_c88b02dd-0888-4d7e-b3d5-66d58b9cf56a_SESS_aa101222-6e4e-4d52-97cc-39e34711339f_TOSC_f73ede6a-6df1-4316-bced-be2c046effe7_PLY_','2021-12-16 21:26:04','2019-08-20 15:26:28','','2021-12-16 22:26:04','SYNCED','905ddea2-ff14-48f0-b814-44ab659a02e9',0,'2021-12-16 22:26:04','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.11.1.1\",\"modelMatrix\":\"0.696597,0.69999,-0.157378,0,-0.717463,0.679631,-0.152801,0,-3.90526e-9,0.219353,0.975645,0,-0.695157,-7.97721,-16.226,1\",\"title\":\"MAXILLAIRE PLY\"}'),(1,'90612e90-6323-453a-b100-2c14dd6ba1f0','/var/.data/2017/81719eb6-9836-45c5-a632-3098f463dde0/146dc0ed-e7c0-4b2a-9a6f-7fa2d76847ac/session_99140e2a-6c40-4cec-8b61-6b676b8308a5/occlusion_669bd839-b35f-4277-b25e-d33767724d18/scan_b78dcdc3-320d-4071-b1af-34f1a9dbaf7d/2_w1_maxillaire_scan_file_0.stl','STL','PATIENT_146dc0ed-e7c0-4b2a-9a6f-7fa2d76847ac_ACT_99140e2a-6c40-4cec-8b61-6b676b8308a5_SESS_669bd839-b35f-4277-b25e-d33767724d18_TOSC_b78dcdc3-320d-4071-b1af-34f1a9dbaf7d_STL_','2020-12-16 20:58:19','2017-05-26 10:00:04','2_w1_maxillaire_scan_file_0.stl',NULL,'SYNCED','90612e90-6323-453a-b100-2c14dd6ba1f0',0,NULL,'81719eb6-9836-45c5-a632-3098f463dde0',NULL,'{\"modelMatrix\":\"0.408509,0.90278,-0.134566,0,-0.912754,0.404045,-0.0602261,0,-5.51681e-09,0.147429,0.989073,0,5.2676,9.94783,-22.7385,1\",\"patientDisplayId\":\"8.2\"}'),(163,'907003f5-2965-4caa-bfaa-10e6969a7b2c','/var/.data/2021/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/409f26d0-a7e4-4813-8322-7342ba9597af/session_87eba16d-aff7-41e9-9637-bf09b56f1030/occlusion_a53c56e5-88df-4213-95fa-5e72bf6599b9/scan_bae5c384-8be6-46cb-914f-52893ff0a986/21_w1_o1_maxillaire_scan_file_1.ply','PLY','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_87eba16d-aff7-41e9-9637-bf09b56f1030_SESS_a53c56e5-88df-4213-95fa-5e72bf6599b9_TOSC_bae5c384-8be6-46cb-914f-52893ff0a986_PLY_','2021-12-16 21:26:30','2021-04-11 11:38:40','21_w1_o1_maxillaire_scan_file_1.ply','2021-12-16 22:26:30','SYNCED','71e2ee96-4fab-47a8-824e-8e926c4280ba',1,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.21.1.1.1\",\"modelMatrix\":\"-0.473992,-0.80031,0.367201,0,0.880529,-0.430809,0.197665,0,6.75803e-9,0.417022,0.908896,0,21.2879,-38.0109,-14.2275,1\",\"title\":\"Maxillaire PLY\"}'),(163,'910c069a-0802-4b84-ac09-8112b5ef422c','','PLY','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_78f19188-19ad-480e-8d99-35699a9590fa_SESS_ea11a5f6-aafe-41d9-b61b-f8b13f045b1e_TOSC_b6ed79b7-008c-41ab-bff5-854add43f023_PLY_','2020-12-16 20:58:19','2017-06-21 09:47:56','',NULL,'CREATED','910c069a-0802-4b84-ac09-8112b5ef422c',0,'2018-06-26 17:07:29','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','','{\"modelMatrix\":\"-0.997133,-0.074449,0.0135181,0,0.0756663,-0.981091,0.178142,0,-7.54421e-11,0.178654,0.983912,0,-1.85398,-2.6145,-13.6846,1\",\"patientDisplayId\":\"1.2\"}'),(163,'9223ddc8-c22b-432b-8e5b-e2bbed0d9bce','','SNAPS','PATIENT_c3d48f98-f992-4b17-9ebd-a8f388b7e0ca_ACT_ce36d71d-debf-4f14-bbe8-30830b342bd3_SESS_2c9b2990-8860-4259-b919-67aa71e0b43f_BOSC_3af0c7c7-068f-4b49-a043-c9deaf8798fc_SNAPS_','2020-12-16 20:58:19','2017-09-23 11:51:55','',NULL,'CREATED','9223ddc8-c22b-432b-8e5b-e2bbed0d9bce',0,'2017-09-23 11:51:55','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"title\":\"Mandibule SNAPSHOT\"}'),(163,'9273720b-56c3-415c-b28e-0440361cecc8','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_7cd8be19-c5e8-48d9-8950-c7006af5dda6/16_w1_o1_mordu_posterieur_droit_scan_file_4.ply','PLY','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_RISC_7cd8be19-c5e8-48d9-8950-c7006af5dda6_PLY_','2021-12-10 13:53:59','2019-10-09 20:02:37','','2021-12-10 14:53:59','SYNCED','8f08a4aa-c3db-47d5-8812-811198ddca5a',4,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mordu posterieur droit 1.16.1.1.1\",\"modelMatrix\":\"0.962333,-0.114478,0.246872,0,0.100349,0.992499,0.0637102,0,-0.252677,-0.0434926,0.966977,0,-1.61364,-3.64635,-14.6614,1\",\"title\":\"MORDU_POSTERIEUR_DROIT PLY\"}'),(163,'92bf2967-ccd3-4869-87d8-c7c47372079a','','SNAPS','PATIENT_faa00c69-6a8f-4658-9cfd-f65108440db8_ACT_bc3db4c6-a79c-4ab4-a006-4f82c00387c4_SESS_05363e68-a254-4acc-8205-219c338c6ba1_TOSC_8bc0f684-8578-4ea5-84ed-9a2a184b15d3_SNAPS_','2022-02-12 14:04:15','2021-12-16 22:51:45','','2022-02-12 15:04:15','SYNCED','92bf2967-ccd3-4869-87d8-c7c47372079a',0,'2022-02-12 15:04:15','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.22.1.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(163,'948d31ea-7959-45fc-8837-7042467113b1','','SNAPS','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_78f19188-19ad-480e-8d99-35699a9590fa_SESS_ea11a5f6-aafe-41d9-b61b-f8b13f045b1e_BOSC_4f70034d-9a83-44fd-bb82-e82e6766d783_SNAPS_','2020-12-16 20:58:19','2017-07-07 14:31:26','',NULL,'SYNCED','948d31ea-7959-45fc-8837-7042467113b1',0,'2017-07-07 14:31:26','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"title\":\"Mandibule SNAPSHOT\"}'),(1,'95127d8e-06cd-4869-a3cd-73db8c8ec785','/var/.data/2017/81719eb6-9836-45c5-a632-3098f463dde0/146dc0ed-e7c0-4b2a-9a6f-7fa2d76847ac/session_99140e2a-6c40-4cec-8b61-6b676b8308a5/occlusion_669bd839-b35f-4277-b25e-d33767724d18/scan_416100cd-bf35-4dbb-932a-8661f3ba4f6f/2_w1_mandibule_snapshot_0.png','SNAPS','PATIENT_146dc0ed-e7c0-4b2a-9a6f-7fa2d76847ac_ACT_99140e2a-6c40-4cec-8b61-6b676b8308a5_SESS_669bd839-b35f-4277-b25e-d33767724d18_BOSC_416100cd-bf35-4dbb-932a-8661f3ba4f6f_SNAPS_','2020-12-16 20:58:19','2017-05-29 11:49:15','2_w1_mandibule_snapshot_0.png',NULL,'SYNCED','95127d8e-06cd-4869-a3cd-73db8c8ec785',0,NULL,'81719eb6-9836-45c5-a632-3098f463dde0',NULL,'{\"patientDisplayId\":\"8.2\"}'),(163,'98705d86-9475-4eb0-bd0c-7cceb74127d9','','SNAPS','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_78f19188-19ad-480e-8d99-35699a9590fa_SESS_ea11a5f6-aafe-41d9-b61b-f8b13f045b1e_TOSC_ecab33ae-7dab-49e3-814b-55b739bced5b_SNAPS_','2021-12-16 21:26:05','2017-07-07 15:40:45','','2021-12-16 22:26:05','SYNCED','98705d86-9475-4eb0-bd0c-7cceb74127d9',0,'2021-12-16 22:26:05','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.2.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(163,'99fa3152-eda1-48eb-8d5f-7b0904c50cb4','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/b10e93aa-548c-427f-adcd-2dbc22bc6626/session_692fa6c8-2523-4d56-bebf-b736f05db142/occlusion_c2195287-5f39-4a66-93d5-5b83792fc9a8/scan_18cd0f29-a9fb-4dcd-91fe-8fb30a4d171a/17_w1_o1_maxillaire_scan_file_1.stl','STL','PATIENT_b10e93aa-548c-427f-adcd-2dbc22bc6626_ACT_692fa6c8-2523-4d56-bebf-b736f05db142_SESS_c2195287-5f39-4a66-93d5-5b83792fc9a8_TOSC_18cd0f29-a9fb-4dcd-91fe-8fb30a4d171a_STL_','2021-12-10 13:53:59','2019-10-14 12:57:56','17_w1_o1_maxillaire_scan_file_1.stl','2021-12-10 14:53:59','SYNCED','b63744ab-d942-4a63-9107-d2ccb5da0f63',1,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.17.1.1\",\"modelMatrix\":\"0.99984,-0.0172721,0.00470526,0,0.0179015,0.964685,-0.262799,0,-2.06254e-10,0.262841,0.964839,0,-16.503,-14.1962,-12.9193,1\",\"title\":\"MAXILLAIRE STL\"}'),(163,'9a1535dd-b5a7-41f8-9557-b243a7f416e4','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/b9d4138d-2c8c-492f-bf20-3aa5437834df/session_54e4e76a-88ec-47fe-8787-b7d925a5a345/occlusion_92b33516-ba42-40bc-80ec-77c62a130f93/scan_3f4e0761-9685-4aa9-a99e-f32bc3f3587a/14_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_b9d4138d-2c8c-492f-bf20-3aa5437834df_ACT_54e4e76a-88ec-47fe-8787-b7d925a5a345_SESS_92b33516-ba42-40bc-80ec-77c62a130f93_BOSC_3f4e0761-9685-4aa9-a99e-f32bc3f3587a_SNAPS_','2021-12-10 13:53:59','2019-08-28 19:48:42','','2021-12-10 14:53:59','SYNCED','9a1535dd-b5a7-41f8-9557-b243a7f416e4',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mandibule 1.14.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(163,'9a6aa6b0-aaf4-4514-a385-1323a42ce5ed','','SNAPS','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_78f19188-19ad-480e-8d99-35699a9590fa_SESS_ea11a5f6-aafe-41d9-b61b-f8b13f045b1e_BOSC_6a1c5075-98b1-4211-9987-29ee0ba6ef5f_SNAPS_','2020-12-16 20:58:19','2017-07-07 16:07:43','',NULL,'SYNCED','06c13027-f4ec-452a-90e6-376ae8aa4573',2,'2019-08-20 15:37:52','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MANDIBULE 1.2.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(163,'9aa094ef-9ea6-4843-981d-e021401874a1','','STL','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_78f19188-19ad-480e-8d99-35699a9590fa_SESS_ea11a5f6-aafe-41d9-b61b-f8b13f045b1e_BOSC_6a1c5075-98b1-4211-9987-29ee0ba6ef5f_STL_','2020-12-16 20:58:19','2017-07-07 16:02:01','',NULL,'SYNCED','c2a12178-bc47-40b7-b1f8-49dad7689c38',1,'2019-08-20 15:37:52','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mandibule Occlusion 1.2.1.1\",\"modelMatrix\":\"0.894225,-0.406275,0.187888,0,0.447617,0.811634,-0.375352,0,1.62914e-08,0.419751,0.907639,0,-8.25828,-9.38956,-23.8323,1\",\"title\":\"Mandibule STL\"}'),(163,'9d375328-38fb-45a3-9305-dbb966236d24','/var/.data/2020/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/1288ba7c-0bcf-4c6f-92e7-2873863af918/session_1a37c2d2-e6a1-4863-8afb-27944d3a7e33/occlusion_7560d619-3fa6-414c-85d8-52a724ef7bf4/scan_e45e36ef-7d3d-43b1-bfcd-00f5c6766a24/20_w1_o1_maxillaire_scan_file_1.ply','PLY','PATIENT_1288ba7c-0bcf-4c6f-92e7-2873863af918_ACT_1a37c2d2-e6a1-4863-8afb-27944d3a7e33_SESS_7560d619-3fa6-414c-85d8-52a724ef7bf4_TOSC_e45e36ef-7d3d-43b1-bfcd-00f5c6766a24_PLY_','2021-12-10 13:53:59','2020-02-17 12:03:03','20_w1_o1_maxillaire_scan_file_1.ply','2021-12-10 14:53:59','SYNCED','752e53bc-9b9f-4861-ab01-bfae139d6a4a',1,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.20.1.1.2\",\"modelMatrix\":\"0.967864,-0.242457,0.0667406,0,0.251475,0.933156,-0.256868,0,-4.7445e-9,0.265397,0.964139,0,-11.4054,-2.53784,-18.765,1\",\"title\":\"MAXILLAIRE PLY\"}'),(163,'9dbe5232-44ea-4c9c-820d-84e24471a57d','','PLY','PATIENT_c8f81196-baea-4404-bca2-c39acd92734c_ACT_208338ea-2209-4f7c-ad22-9db0447ff940_SESS_26578904-6388-4b67-926c-fa9cede7abea_TOSC_195ffba3-6544-4214-acf3-3a4088cbb672_PLY_','2020-12-16 20:58:19','2017-07-07 15:47:03','',NULL,'SYNCED','9dbe5232-44ea-4c9c-820d-84e24471a57d',0,'2019-08-07 10:12:43','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.3.1.1\",\"modelMatrix\":\"0.918753,-0.391723,0.0494602,0,0.394833,0.911516,-0.115091,0,1.72298e-09,0.125269,0.992123,0,-14.4652,-1.59413,-15.449,1\",\"title\":\"Maxillaire PLY\"}'),(163,'9e62651d-f00e-4acc-8116-c99afaddc2b6','/var/.data/2022/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/409f26d0-a7e4-4813-8322-7342ba9597af/session_97e5ae19-9444-4dd2-9134-8f61d8d268df/occlusion_85186f51-753c-498e-8346-beea8a780c7b/computedocclusion_4d83f219-0b5d-4997-b640-b46da3aba91f/21_w2_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_97e5ae19-9444-4dd2-9134-8f61d8d268df_SESS_85186f51-753c-498e-8346-beea8a780c7b_OCC_4d83f219-0b5d-4997-b640-b46da3aba91f_BOMA__MATRX_','2022-02-12 14:45:22','2022-02-12 15:45:19','21_w2_o1_mandibule_matrix_occ_file_0.m','2022-02-12 15:45:22','SYNCED','9e62651d-f00e-4acc-8116-c99afaddc2b6',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.21.2.1.2 Occlusion 1\",\"referenceScanID\":\"1.21.2.1.2\",\"title\":\"Matrice Transfo. Mandibule 1.21.2.1.2 Occlusion 1\"}'),(163,'9e9ef1a8-d9dd-4a8a-a944-ae04a6e71c1e','','PLY','PATIENT_1288ba7c-0bcf-4c6f-92e7-2873863af918_ACT_1a37c2d2-e6a1-4863-8afb-27944d3a7e33_SESS_7560d619-3fa6-414c-85d8-52a724ef7bf4_TOSC_9bfc9e7e-6d55-461c-b01c-e6ef10fc5f61_PLY_','2020-12-16 20:58:19','2020-02-17 11:35:42','',NULL,'CREATED','9e9ef1a8-d9dd-4a8a-a944-ae04a6e71c1e',0,'2020-02-17 11:46:51','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.20.1.1.1\",\"modelMatrix\":\"0.904689,-0.417795,0.083573,0,0.426072,0.887115,-0.177453,0,1.42349e-9,0.196148,0.980574,0,-16.5834,-0.141919,-14.7909,1\",\"title\":\"MAXILLAIRE PLY\"}'),(163,'9ed7eab6-a6ff-4315-a0ab-49db0f33f29b','computedocclusion_92b33516-ba42-40bc-80ec-77cmigraoccl/','LIFI','PATIENT_b9d4138d-2c8c-492f-bf20-3aa5437834df_ACT_54e4e76a-88ec-47fe-8787-b7d925a5a345_SESS_92b33516-ba42-40bc-80ec-77c62a130f93_OCC_92b33516-ba42-40bc-80ec-77cmigraoccl_LIFIO_LIFI_','2021-12-16 21:26:05','2019-08-29 15:24:01','','2021-12-16 22:26:05','SYNCED','bf8a5ead-e3ac-479b-a9f3-8fc17af8cb10',1,'2021-12-16 22:26:05','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Ligne de finition MAXILLAIRE 1.14.1.1 Sans nom 0 Occlusion\",\"isOcclusionMarginLine\":true,\"name\":\"Sans nom 0 Occlusion\",\"title\":\"MAXILLAIRE LIFI\",\"toothNumber\":1000,\"lifi_scan_type\":\"MAXILLAIRE\"}'),(163,'a0611add-acd8-4025-8433-f453f9d61ada','','STL','PATIENT_06f2a3bd-d1ba-4ac0-8808-522987236cbe_ACT_c88b02dd-0888-4d7e-b3d5-66d58b9cf56a_SESS_aa101222-6e4e-4d52-97cc-39e34711339f_TOSC_f73ede6a-6df1-4316-bced-be2c046effe7_STL_','2021-12-16 21:26:05','2019-08-20 15:26:28','','2021-12-16 22:26:05','SYNCED','a0611add-acd8-4025-8433-f453f9d61ada',0,'2021-12-16 22:26:05','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.11.1.1\",\"modelMatrix\":\"0.696597,0.69999,-0.157378,0,-0.717463,0.679631,-0.152801,0,-3.90526e-9,0.219353,0.975645,0,-0.695157,-7.97721,-16.226,1\",\"title\":\"MAXILLAIRE STL\"}'),(163,'a0754964-2abc-4bfc-9fd1-3368814f9560','','STL','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_4829e17a-6262-4322-bd2d-12f3055adf7d_SESS_9f7449d6-1278-45d5-9492-02cd28be29ca_TOSC_19d904f0-1e7a-4097-baf5-3d03ff2ff6d0_STL_','2021-12-16 21:26:05','2019-08-20 14:39:12','','2021-12-16 22:26:05','SYNCED','a0754964-2abc-4bfc-9fd1-3368814f9560',0,'2021-12-16 22:26:05','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mandibule Occlusion 1.2.2.2\",\"modelMatrix\":\"0.849034,0.500992,-0.167774,0,-0.528338,0.805089,-0.269611,0,9.55235e-9,0.31755,0.948241,0,-7.14376,-34.7633,-17.1981,1\",\"title\":\"MAXILLAIRE STL\"}'),(163,'a0840078-f705-4297-a590-258aedaa7cf8','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_7cd8be19-c5e8-48d9-8950-c7006af5dda6/16_w1_o1_mordu_posterieur_droit_scan_file_0.stl','STL','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_RISC_7cd8be19-c5e8-48d9-8950-c7006af5dda6_STL_','2021-12-10 13:53:59','2019-10-09 19:49:41','','2021-12-10 14:53:59','SYNCED','a0840078-f705-4297-a590-258aedaa7cf8',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MORDU_POSTERIEUR_DROIT 1.16.1.1.1\",\"modelMatrix\":\"0.970733,-0.155238,0.194951,0,0.149682,0.987229,0.0496399,0,-0.188286,-0.0432154,0.979917,0,-4.57,-3.77931,-14.8961,1\",\"title\":\"MORDU_POSTERIEUR_DROIT STL\"}'),(163,'a26c62ea-7c34-452d-88cf-9d144550ec86','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/b9d4138d-2c8c-492f-bf20-3aa5437834df/session_54e4e76a-88ec-47fe-8787-b7d925a5a345/occlusion_92b33516-ba42-40bc-80ec-77c62a130f93/14_w1_o1_mandibule_occlusion_occ_file_1.stl','STL','PATIENT_b9d4138d-2c8c-492f-bf20-3aa5437834df_ACT_54e4e76a-88ec-47fe-8787-b7d925a5a345_SESS_92b33516-ba42-40bc-80ec-77c62a130f93_BOSTL__STL_','2021-12-10 13:53:59','2019-08-28 20:01:50','','2021-12-10 14:53:59','SYNCED','c1d1f8e9-e378-44e3-9302-9ac3c4b77dfa',1,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mandibule Occlusion 1.14.1.1\",\"title\":\"Mandibule Occlusion STL\"}'),(163,'a482b141-3f90-4434-9fc1-749180c3a246','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/b9d4138d-2c8c-492f-bf20-3aa5437834df/session_54e4e76a-88ec-47fe-8787-b7d925a5a345/occlusion_92b33516-ba42-40bc-80ec-77c62a130f93/computedocclusion_92b33516-ba42-40bc-80ec-77cmigraoccl/14_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_b9d4138d-2c8c-492f-bf20-3aa5437834df_ACT_54e4e76a-88ec-47fe-8787-b7d925a5a345_SESS_92b33516-ba42-40bc-80ec-77c62a130f93_OCC_92b33516-ba42-40bc-80ec-77cmigraoccl_BOMA__MATRX_','2021-12-10 13:54:00','2019-08-28 20:00:06','','2021-12-10 14:54:00','SYNCED','a482b141-3f90-4434-9fc1-749180c3a246',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.14.1.1\",\"title\":\"Matrice Transfo. Mandibule MATRIX\"}'),(163,'a4fe9afa-c87f-4755-8881-cbd8df0e865e','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_4f66eeb0-72e9-4b3f-9e2e-2051256ddf18/16_w1_o1_mordu_posterieur_gauche_scan_file_0.ply','PLY','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_LESC_4f66eeb0-72e9-4b3f-9e2e-2051256ddf18_PLY_','2021-12-10 13:54:00','2019-10-09 20:04:18','','2021-12-10 14:54:00','SYNCED','a4fe9afa-c87f-4755-8881-cbd8df0e865e',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mordu posterieur gauche 1.16.1.1.1\",\"modelMatrix\":\"-0.969184,0.0737549,0.233925,0,-0.0019714,-0.955708,0.292156,0,0.246332,0.284935,0.927324,0,-10.2666,-10.7335,-16.1802,1\",\"title\":\"MORDU_POSTERIEUR_GAUCHE PLY\"}'),(163,'a730168d-f711-4f65-97cc-e1abf584ee29','','PLY','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_78f19188-19ad-480e-8d99-35699a9590fa_SESS_ea11a5f6-aafe-41d9-b61b-f8b13f045b1e_BOSC_6a1c5075-98b1-4211-9987-29ee0ba6ef5f_PLY_','2020-12-16 20:58:19','2017-07-07 15:58:52','',NULL,'SYNCED','a730168d-f711-4f65-97cc-e1abf584ee29',0,'2019-08-20 15:37:52','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mandibule Occlusion 1.2.1.1\",\"modelMatrix\":\"0.999755,0.021779,-0.00391216,0,-0.0221276,0.984006,-0.176757,0,4.13977e-10,0.1768,0.984247,0,-17.1434,-5.85438,-15.7437,1\",\"title\":\"Mandibule PLY\"}'),(3,'a750cc3c-58c8-495f-9661-a40e2bf96037','/var/.data/2021/7655b09e-027b-49c5-9b6c-832c6e41cee8/discussion_605c208e-ad38-4268-a678-5f04c6f9007f/a750cc3c-58c8-495f-9661-a40e2bf96037.ply','PLY','PATIENT_f1ba7774-7c5d-40d1-adaf-bf5e9ddee4c5_ACT_6c4aa713-5123-4551-8db5-cfa1136bd86a_SESS_b1f65e85-2a53-4c07-89bc-95a34ee8c209_BOSC_ac62ad28-ce76-4c21-8909-4348bd46d50f_PLY_','2020-11-23 20:19:26','2019-07-08 15:32:31','a750cc3c-58c8-495f-9661-a40e2bf96037.ply','2020-11-23 21:19:26','SYNCED','a750cc3c-58c8-495f-9661-a40e2bf96037',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 2.2.2.1.1\",\"modelMatrix\":\"-0.477557,-0.869559,0.125726,0,0.878601,-0.472642,0.0683376,0,-3.04888e-9,0.143098,0.989708,0,8.87102,14.4776,-17.3023,1\",\"title\":\"MANDIBULE PLY\"}'),(163,'a875f57f-7f35-4ffb-ac85-18b73e5cda0e','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/bdb79646-26a6-440d-867f-112e46644df6/session_1ff39b04-4666-4c18-afaa-74990cd38521/occlusion_ae07c5e5-6b65-46ef-9cd1-c0a9daccea5f/scan_753d010b-c7ba-4dc4-a9cb-eaa7680a0b86/15_w1_o1_mandibule_scan_file_0.stl','STL','PATIENT_bdb79646-26a6-440d-867f-112e46644df6_ACT_1ff39b04-4666-4c18-afaa-74990cd38521_SESS_ae07c5e5-6b65-46ef-9cd1-c0a9daccea5f_BOSC_753d010b-c7ba-4dc4-a9cb-eaa7680a0b86_STL_','2021-12-10 13:54:00','2019-09-18 15:27:35','','2021-12-10 14:54:00','SYNCED','a875f57f-7f35-4ffb-ac85-18b73e5cda0e',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MANDIBULE 1.15.1.1.1\",\"modelMatrix\":\"-0.350708,0.928203,-0.124274,0,-0.936485,-0.347606,0.0465397,0,-2.44584e-9,0.132702,0.991156,0,-10.6528,6.31269,-22.2532,1\",\"title\":\"MANDIBULE STL\"}'),(163,'a9a24eec-ed31-4ca3-a322-e55a79a15bdc','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/b9d4138d-2c8c-492f-bf20-3aa5437834df/session_54e4e76a-88ec-47fe-8787-b7d925a5a345/occlusion_92b33516-ba42-40bc-80ec-77c62a130f93/scan_3f4e0761-9685-4aa9-a99e-f32bc3f3587a/14_w1_o1_mandibule_scan_file_0.stl','STL','PATIENT_b9d4138d-2c8c-492f-bf20-3aa5437834df_ACT_54e4e76a-88ec-47fe-8787-b7d925a5a345_SESS_92b33516-ba42-40bc-80ec-77c62a130f93_BOSC_3f4e0761-9685-4aa9-a99e-f32bc3f3587a_STL_','2021-12-10 13:54:01','2019-08-28 19:48:42','','2021-12-10 14:54:01','SYNCED','a9a24eec-ed31-4ca3-a322-e55a79a15bdc',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MANDIBULE 1.14.1.1.1\",\"modelMatrix\":\"0.289133,0.88827,-0.356901,0,-0.957289,0.268287,-0.107796,0,1.97496e-9,0.372824,0.927902,0,-2.26156,-6.31375,-20.394,1\",\"title\":\"MANDIBULE STL\"}'),(163,'a9aa3381-bdc3-46c7-a6b4-5a267ebfb25d','/var/.data/2022/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/409f26d0-a7e4-4813-8322-7342ba9597af/session_97e5ae19-9444-4dd2-9134-8f61d8d268df/occlusion_85186f51-753c-498e-8346-beea8a780c7b/scan_cd569007-a8b8-4363-acd4-5ff36a438dbd/21_w2_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_97e5ae19-9444-4dd2-9134-8f61d8d268df_SESS_85186f51-753c-498e-8346-beea8a780c7b_TOSC_cd569007-a8b8-4363-acd4-5ff36a438dbd_SNAPS_','2022-02-12 14:58:56','2022-02-12 15:58:51','21_w2_o1_maxillaire_snapshot_0.png','2022-02-12 15:58:56','SYNCED','a9aa3381-bdc3-46c7-a6b4-5a267ebfb25d',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.21.2.1.6\",\"title\":\"Maxillaire SNAPSHOT\"}'),(163,'abbd99e5-91a4-49a3-81a1-0f5dbd693be5','/var/.data/2021/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/409f26d0-a7e4-4813-8322-7342ba9597af/session_87eba16d-aff7-41e9-9637-bf09b56f1030/occlusion_a53c56e5-88df-4213-95fa-5e72bf6599b9/scan_bae5c384-8be6-46cb-914f-52893ff0a986/21_w1_o1_maxillaire_snapshot_2.png','SNAPS','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_87eba16d-aff7-41e9-9637-bf09b56f1030_SESS_a53c56e5-88df-4213-95fa-5e72bf6599b9_TOSC_bae5c384-8be6-46cb-914f-52893ff0a986_SNAPS_','2021-12-16 21:26:15','2021-04-11 11:44:48','21_w1_o1_maxillaire_snapshot_2.png','2021-12-16 22:26:15','SYNCED','08d2ffde-2c03-4ec9-8db4-66e88fe25ddd',2,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.21.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(163,'ac69a972-fe3a-4fd6-8687-203d02d867a9','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_f1172a60-6504-4697-9acb-2793b430d7fe/16_w1_o1_mandibule_scan_file_2.ply','PLY','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_BOSC_f1172a60-6504-4697-9acb-2793b430d7fe_PLY_','2021-12-10 13:54:01','2019-10-09 19:41:41','16_w1_o1_mandibule_scan_file_2.ply','2021-12-10 14:54:01','SYNCED','fb3b6e24-9356-49d8-8960-dfd6ec1157f6',2,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MANDIBULE 1.16.1.1\",\"modelMatrix\":\"0.898195,0.348615,-0.267795,0,-0.439598,0.712296,-0.547164,0,9.87468e-10,0.609182,0.79303,0,-2.10571,-18.6031,-20.6383,1\",\"title\":\"MANDIBULE PLY\"}'),(163,'ad0a72a1-7e90-4a8f-9f02-4b383d0f2463','','SNAPS','PATIENT_c3d48f98-f992-4b17-9ebd-a8f388b7e0ca_ACT_ce36d71d-debf-4f14-bbe8-30830b342bd3_SESS_2c9b2990-8860-4259-b919-67aa71e0b43f_TOSC_5b265bae-8c91-414d-bee3-c03fcfb27c19_SNAPS_','2020-12-16 20:58:19','2017-09-23 10:30:21','',NULL,'SYNCED','12b83c2b-966f-46ac-92eb-c4aeaeeabfa7',1,'2017-09-23 10:30:21','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"title\":\"Maxillaire SNAPSHOT\"}'),(163,'ad72d576-cf58-46df-a31d-34e5436dd82b','','SNAPS','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_78f19188-19ad-480e-8d99-35699a9590fa_SESS_ea11a5f6-aafe-41d9-b61b-f8b13f045b1e_TOSC_d1dc341b-6602-437f-99c5-f70a9e47e85a_SNAPS_','2020-12-16 20:58:19','2017-06-22 18:17:24','',NULL,'SYNCED','d74c043a-1a69-4c1b-b15d-0294ad179983',1,'2017-06-22 18:17:24','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"title\":\"Maxillaire SNAPSHOT\"}'),(163,'ad7fe43a-bcf6-4679-91f6-cc90438bd5fc','','ZIP','PATIENT_faa00c69-6a8f-4658-9cfd-f65108440db8_ACT_bc3db4c6-a79c-4ab4-a006-4f82c00387c4_SESS_05363e68-a254-4acc-8205-219c338c6ba1_TOSC_8bc0f684-8578-4ea5-84ed-9a2a184b15d3_ZIP_','2022-02-12 14:04:16','2021-12-16 22:51:46','','2022-02-12 15:04:16','SYNCED','ad7fe43a-bcf6-4679-91f6-cc90438bd5fc',0,'2022-02-12 15:04:16','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.22.1.1.2\",\"modelMatrix\":\"-0.509134,0.853697,-0.109468,0,-0.860687,-0.504999,0.0647552,0,-1.30287e-10,0.127187,0.991879,0,23.7777,-6.05424,-15.5235,1\",\"title\":\"Maxillaire ZIP\"}'),(163,'adfde7b0-a6d4-4608-8117-f3790bea8ef9','','SNAPS','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_4829e17a-6262-4322-bd2d-12f3055adf7d_SESS_be8b17ea-1f2d-4455-823c-87f31acb59e4_BOSC_993e81f9-b63b-42e8-9992-72d3942cce1a_SNAPS_','2021-12-16 21:26:05','2019-08-20 14:30:37','','2021-12-16 22:26:05','SYNCED','adfde7b0-a6d4-4608-8117-f3790bea8ef9',0,'2021-12-16 22:26:05','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mandibule Occlusion 1.2.2.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(163,'af3275fd-de94-4563-a07f-efe7b8ecf1f4','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/bdb79646-26a6-440d-867f-112e46644df6/session_1ff39b04-4666-4c18-afaa-74990cd38521/occlusion_ae07c5e5-6b65-46ef-9cd1-c0a9daccea5f/scan_07ab566c-1f76-4aed-a865-ba42f4f56bfc/15_w1_o1_maxillaire_scan_file_0.ply','PLY','PATIENT_bdb79646-26a6-440d-867f-112e46644df6_ACT_1ff39b04-4666-4c18-afaa-74990cd38521_SESS_ae07c5e5-6b65-46ef-9cd1-c0a9daccea5f_TOSC_07ab566c-1f76-4aed-a865-ba42f4f56bfc_PLY_','2021-12-10 13:54:01','2019-09-18 15:21:05','','2021-12-10 14:54:01','SYNCED','af3275fd-de94-4563-a07f-efe7b8ecf1f4',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.15.1.1.1\",\"modelMatrix\":\"0.975068,0.19737,-0.101425,0,-0.221905,0.867259,-0.445667,0,-7.79617e-9,0.457063,0.889434,0,-15.2766,-12.3359,-5.25124,1\",\"title\":\"MAXILLAIRE PLY\"}'),(163,'b0dd07cc-d696-4bca-80b0-e17007eae6bf','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/b10e93aa-548c-427f-adcd-2dbc22bc6626/session_692fa6c8-2523-4d56-bebf-b736f05db142/occlusion_c2195287-5f39-4a66-93d5-5b83792fc9a8/scan_18cd0f29-a9fb-4dcd-91fe-8fb30a4d171a/17_w1_o1_maxillaire_scan_file_2.stl','STL','PATIENT_b10e93aa-548c-427f-adcd-2dbc22bc6626_ACT_692fa6c8-2523-4d56-bebf-b736f05db142_SESS_c2195287-5f39-4a66-93d5-5b83792fc9a8_TOSC_18cd0f29-a9fb-4dcd-91fe-8fb30a4d171a_STL_','2021-12-10 13:54:01','2019-10-14 13:02:11','17_w1_o1_maxillaire_scan_file_2.stl','2021-12-10 14:54:01','SYNCED','b63744ab-d942-4a63-9107-d2ccb5da0f63',2,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.17.1.1\",\"modelMatrix\":\"0.891043,0.44454,-0.0917963,0,-0.453919,0.872632,-0.180196,0,-5.32389e-10,0.20223,0.979338,0,-9.04271,-16.6029,-12.7969,1\",\"title\":\"MAXILLAIRE STL\"}'),(1,'b249311d-c71f-4e50-9e5a-230d4488d820','/var/.data/2017/81719eb6-9836-45c5-a632-3098f463dde0/146dc0ed-e7c0-4b2a-9a6f-7fa2d76847ac/session_99140e2a-6c40-4cec-8b61-6b676b8308a5/occlusion_669bd839-b35f-4277-b25e-d33767724d18/scan_b78dcdc3-320d-4071-b1af-34f1a9dbaf7d/2_w1_maxillaire_snapshot_0.png','SNAPS','PATIENT_146dc0ed-e7c0-4b2a-9a6f-7fa2d76847ac_ACT_99140e2a-6c40-4cec-8b61-6b676b8308a5_SESS_669bd839-b35f-4277-b25e-d33767724d18_TOSC_b78dcdc3-320d-4071-b1af-34f1a9dbaf7d_SNAPS_','2020-12-16 20:58:19','2017-05-26 09:57:54','2_w1_maxillaire_snapshot_0.png',NULL,'SYNCED','b249311d-c71f-4e50-9e5a-230d4488d820',0,NULL,'81719eb6-9836-45c5-a632-3098f463dde0',NULL,'{\"patientDisplayId\":\"8.2\"}'),(1,'b51230cc-9d03-4f5f-b14e-db9f71efb070','/var/.data/2017/81719eb6-9836-45c5-a632-3098f463dde0/146dc0ed-e7c0-4b2a-9a6f-7fa2d76847ac/session_99140e2a-6c40-4cec-8b61-6b676b8308a5/occlusion_669bd839-b35f-4277-b25e-d33767724d18/scan_416100cd-bf35-4dbb-932a-8661f3ba4f6f/2_w1_mandibule_scan_file_0.ply','PLY','PATIENT_146dc0ed-e7c0-4b2a-9a6f-7fa2d76847ac_ACT_99140e2a-6c40-4cec-8b61-6b676b8308a5_SESS_669bd839-b35f-4277-b25e-d33767724d18_BOSC_416100cd-bf35-4dbb-932a-8661f3ba4f6f_PLY_','2020-12-16 20:58:19','2017-05-29 11:51:00','2_w1_mandibule_scan_file_0.ply',NULL,'SYNCED','b51230cc-9d03-4f5f-b14e-db9f71efb070',0,NULL,'81719eb6-9836-45c5-a632-3098f463dde0',NULL,'{\"modelMatrix\":\"-0.950674,0.302379,-0.0691731,0,-0.31019,-0.926735,0.212002,0,-2.49248e-09,0.223002,0.974818,0,8.3365,-8.68327,-23.0169,1\",\"patientDisplayId\":\"8.2\"}'),(163,'b5df8952-3e2b-4b22-b7cf-e3d423dc8126','','SNAPS','PATIENT_c3d48f98-f992-4b17-9ebd-a8f388b7e0ca_ACT_ce36d71d-debf-4f14-bbe8-30830b342bd3_SESS_2c9b2990-8860-4259-b919-67aa71e0b43f_BOSC_dc0831aa-93b4-4baf-aab0-a9b0ce8b83e5_SNAPS_','2020-12-16 20:58:19','2017-09-23 10:33:37','',NULL,'SYNCED','b5df8952-3e2b-4b22-b7cf-e3d423dc8126',0,'2017-09-23 10:33:37','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"title\":\"Mandibule SNAPSHOT\"}'),(163,'b63744ab-d942-4a63-9107-d2ccb5da0f63','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/b10e93aa-548c-427f-adcd-2dbc22bc6626/session_692fa6c8-2523-4d56-bebf-b736f05db142/occlusion_c2195287-5f39-4a66-93d5-5b83792fc9a8/scan_18cd0f29-a9fb-4dcd-91fe-8fb30a4d171a/17_w1_o1_maxillaire_scan_file_0.stl','STL','PATIENT_b10e93aa-548c-427f-adcd-2dbc22bc6626_ACT_692fa6c8-2523-4d56-bebf-b736f05db142_SESS_c2195287-5f39-4a66-93d5-5b83792fc9a8_TOSC_18cd0f29-a9fb-4dcd-91fe-8fb30a4d171a_STL_','2021-12-10 13:54:01','2019-10-14 12:54:26','17_w1_o1_maxillaire_scan_file_0.stl','2021-12-10 14:54:01','SYNCED','b63744ab-d942-4a63-9107-d2ccb5da0f63',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.17.1.1\",\"modelMatrix\":\"0.999235,0.037218,-0.0119875,0,-0.0391009,0.951117,-0.306345,0,-7.18694e-10,0.306579,0.951845,0,-15.846,-16.1163,-11.7486,1\",\"title\":\"MAXILLAIRE STL\"}'),(163,'b67927f2-22fc-40af-9f19-12385a8c424a','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/b9d4138d-2c8c-492f-bf20-3aa5437834df/session_54e4e76a-88ec-47fe-8787-b7d925a5a345/occlusion_92b33516-ba42-40bc-80ec-77c62a130f93/computedocclusion_92b33516-ba42-40bc-80ec-77cmigraoccl/14_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_b9d4138d-2c8c-492f-bf20-3aa5437834df_ACT_54e4e76a-88ec-47fe-8787-b7d925a5a345_SESS_92b33516-ba42-40bc-80ec-77c62a130f93_OCC_92b33516-ba42-40bc-80ec-77cmigraoccl_SNAPO__SNAPS_','2021-12-10 13:54:01','2019-08-28 20:00:06','','2021-12-10 14:54:01','SYNCED','b67927f2-22fc-40af-9f19-12385a8c424a',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Snapshot 1.14.1.1\",\"title\":\"Snapshot SNAPSHOT\"}'),(163,'b6865a4a-2933-4ddf-a792-1aa292359fd7','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_c721c0c0-a514-44bc-af6d-0394b9e59459/16_w1_o1_maxillaire_snapshot_3.png','SNAPS','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_TOSC_c721c0c0-a514-44bc-af6d-0394b9e59459_SNAPS_','2021-12-10 13:54:01','2019-10-09 19:30:43','','2021-12-10 14:54:01','SYNCED','07cdc5f1-9ddf-4eab-a043-c35a6f9783a0',3,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.16.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(163,'b6c5bbd3-6387-4b17-84ec-098c0020c139','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/b9d4138d-2c8c-492f-bf20-3aa5437834df/session_54e4e76a-88ec-47fe-8787-b7d925a5a345/occlusion_92b33516-ba42-40bc-80ec-77c62a130f93/computedocclusion_92b33516-ba42-40bc-80ec-77cmigraoccl/14_w1_o1_mandibule_matrix_occ_file_1.m','MATRX','PATIENT_b9d4138d-2c8c-492f-bf20-3aa5437834df_ACT_54e4e76a-88ec-47fe-8787-b7d925a5a345_SESS_92b33516-ba42-40bc-80ec-77c62a130f93_OCC_92b33516-ba42-40bc-80ec-77cmigraoccl_BOMA__MATRX_','2021-12-10 13:54:01','2019-08-28 20:01:50','','2021-12-10 14:54:01','SYNCED','a482b141-3f90-4434-9fc1-749180c3a246',1,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.14.1.1\",\"title\":\"Matrice Transfo. Mandibule MATRIX\"}'),(163,'b7026194-7463-405c-bf47-935e3808c03b','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_7cd8be19-c5e8-48d9-8950-c7006af5dda6/16_w1_o1_mordu_posterieur_droit_scan_file_1.stl','STL','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_RISC_7cd8be19-c5e8-48d9-8950-c7006af5dda6_STL_','2021-12-10 13:54:01','2019-10-09 19:51:50','16_w1_o1_mordu_posterieur_droit_scan_file_1.stl','2021-12-10 14:54:01','SYNCED','a0840078-f705-4297-a590-258aedaa7cf8',1,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MORDU_POSTERIEUR_DROIT 1.16.1.1\",\"modelMatrix\":\"0.960416,-0.154039,0.235142,0,0.14667,0.987583,0.0598983,0,-0.236924,-0.0323139,0.970162,0,-1.789,-3.76583,-14.5136,1\",\"title\":\"MORDU_POSTERIEUR_DROIT STL\"}'),(163,'b7c0b693-e7fb-4f9f-a38b-30bf36ce6b45','','STL','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_78f19188-19ad-480e-8d99-35699a9590fa_SESS_ea11a5f6-aafe-41d9-b61b-f8b13f045b1e_TOSC_d1dc341b-6602-437f-99c5-f70a9e47e85a_STL_','2020-12-16 20:58:19','2017-06-22 18:17:24','',NULL,'SYNCED','205963cf-0d3b-4c74-9f74-7eec3cc0f022',1,'2017-06-22 18:17:24','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"modelMatrix\":\"0.980894,0.165356,-0.102494,0,-0.194545,0.833724,-0.516776,0,1.92069e-09,0.526842,0.849963,0,0.932327,-8.16382,-11.7095,1\",\"title\":\"Maxillaire STL\"}'),(163,'b901812e-8285-4bd8-b23e-0be4dbd27b7a','','PLY','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_78f19188-19ad-480e-8d99-35699a9590fa_SESS_ea11a5f6-aafe-41d9-b61b-f8b13f045b1e_TOSC_d1dc341b-6602-437f-99c5-f70a9e47e85a_PLY_','2020-12-16 20:58:19','2017-06-22 18:17:24','',NULL,'SYNCED','1ba1d207-956d-49d4-b5aa-76c29f35e81c',1,'2017-06-22 18:17:24','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"modelMatrix\":\"0.980894,0.165356,-0.102494,0,-0.194545,0.833724,-0.516776,0,1.92069e-09,0.526842,0.849963,0,0.932327,-8.16382,-11.7095,1\",\"title\":\"Maxillaire PLY\"}'),(163,'b9144045-628a-41d7-b414-01e326179b28','','STL','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_78f19188-19ad-480e-8d99-35699a9590fa_SESS_ea11a5f6-aafe-41d9-b61b-f8b13f045b1e_TOSC_b6ed79b7-008c-41ab-bff5-854add43f023_STL_','2020-12-16 20:58:19','2017-06-21 09:47:56','',NULL,'CREATED','b9144045-628a-41d7-b414-01e326179b28',0,'2018-06-26 17:07:29','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','','{\"modelMatrix\":\"-0.997133,-0.074449,0.0135181,0,0.0756663,-0.981091,0.178142,0,-7.54421e-11,0.178654,0.983912,0,-1.85398,-2.6145,-13.6846,1\",\"patientDisplayId\":\"1.2\"}'),(163,'b9278bcb-3c8b-4c8e-ba62-8ef3a63d21a8','','SNAPS','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_78f19188-19ad-480e-8d99-35699a9590fa_SESS_ea11a5f6-aafe-41d9-b61b-f8b13f045b1e_BOSC_8ee89240-4c2c-43cf-a156-7cda82f0637f_SNAPS_','2020-12-16 20:58:19','2017-07-07 14:45:16','',NULL,'SYNCED','b9278bcb-3c8b-4c8e-ba62-8ef3a63d21a8',0,'2017-07-07 14:45:16','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"title\":\"Mandibule SNAPSHOT\"}'),(163,'bb5d84f3-d791-4765-9d93-4ef53157d5f8','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_f1172a60-6504-4697-9acb-2793b430d7fe/16_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_BOSC_f1172a60-6504-4697-9acb-2793b430d7fe_SNAPS_','2021-12-10 13:54:01','2019-10-09 19:38:18','16_w1_o1_mandibule_snapshot_1.png','2021-12-10 14:54:01','SYNCED','ef91b022-83f4-4ff4-97e8-4bcb62ff5b6d',1,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MANDIBULE 1.16.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(163,'bcb48043-98c3-49fc-932c-6d3999941b8c','','SNAPS','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_4829e17a-6262-4322-bd2d-12f3055adf7d_SESS_be8b17ea-1f2d-4455-823c-87f31acb59e4_BOSC_993e81f9-b63b-42e8-9992-72d3942cce1a_SNAPS_','2021-12-16 21:26:05','2019-08-20 14:32:27','','2021-12-16 22:26:05','SYNCED','adfde7b0-a6d4-4608-8117-f3790bea8ef9',1,'2021-12-16 22:26:05','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MANDIBULE 1.2.2.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(163,'bcc537fa-de81-4f4a-a687-dd2ad5438982','/var/.data/2020/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/1288ba7c-0bcf-4c6f-92e7-2873863af918/session_1a37c2d2-e6a1-4863-8afb-27944d3a7e33/occlusion_7560d619-3fa6-414c-85d8-52a724ef7bf4/scan_e45e36ef-7d3d-43b1-bfcd-00f5c6766a24/20_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_1288ba7c-0bcf-4c6f-92e7-2873863af918_ACT_1a37c2d2-e6a1-4863-8afb-27944d3a7e33_SESS_7560d619-3fa6-414c-85d8-52a724ef7bf4_TOSC_e45e36ef-7d3d-43b1-bfcd-00f5c6766a24_SNAPS_','2021-12-10 13:54:02','2020-02-17 11:47:42','20_w1_o1_maxillaire_snapshot_0.png','2021-12-10 14:54:02','SYNCED','bcc537fa-de81-4f4a-a687-dd2ad5438982',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.20.1.1.2\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(163,'bcc65d9e-d6ca-49f2-aa48-b84ef943291b','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_04084a21-671f-49ef-a336-594796e4386f/16_w1_o1_mordu_anterieur_scan_file_1.stl','STL','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_FRSC_04084a21-671f-49ef-a336-594796e4386f_STL_','2021-12-10 13:54:02','2019-10-09 20:10:11','','2021-12-10 14:54:02','SYNCED','f3227141-7884-4fbb-afb6-a2168a8223e6',1,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MORDU_ANTERIEUR 1.16.1.1.1\",\"modelMatrix\":\"0.885046,-0.19799,-0.429918,0,0.128291,0.978969,-0.103016,0,0.447929,0.0712136,0.898315,0,-4.85615,-8.57613,-33.3341,1\",\"title\":\"MORDU_ANTERIEUR STL\"}'),(163,'bd6fe391-56db-48a1-9f21-da2b75191eca','','STL','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_78f19188-19ad-480e-8d99-35699a9590fa_SESS_ea11a5f6-aafe-41d9-b61b-f8b13f045b1e_BOSC_4f70034d-9a83-44fd-bb82-e82e6766d783_STL_','2020-12-16 20:58:19','2017-07-07 14:31:25','',NULL,'SYNCED','bd6fe391-56db-48a1-9f21-da2b75191eca',0,'2017-07-07 14:31:25','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"modelMatrix\":\"0.900265,0.409128,-0.148783,0,-0.435342,0.846057,-0.307677,0,5.42277e-09,0.341762,0.939787,0,-9.48244,-8.94828,-22.5093,1\",\"title\":\"Mandibule STL\"}'),(163,'bd9bacc0-d27a-486b-bc53-bd6172d5cd80','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/b9d4138d-2c8c-492f-bf20-3aa5437834df/session_54e4e76a-88ec-47fe-8787-b7d925a5a345/occlusion_92b33516-ba42-40bc-80ec-77c62a130f93/14_w1_o1_mandibule_contact_occ_file_1.ply','CONTACT','PATIENT_b9d4138d-2c8c-492f-bf20-3aa5437834df_ACT_54e4e76a-88ec-47fe-8787-b7d925a5a345_SESS_92b33516-ba42-40bc-80ec-77c62a130f93_BOCO__CONTACT_','2021-12-10 13:54:02','2019-08-28 20:01:50','','2021-12-10 14:54:02','SYNCED','f542d9cf-fca7-4ca6-b5df-2410384eb5ce',1,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Pts de Contacts Mandibule Occlusion 1.14.1.1\",\"title\":\"Pts de Contacts Mandibule Occlusion CONTACT\"}'),(163,'be2ca89b-1f70-4164-b966-0516457b5506','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/b9d4138d-2c8c-492f-bf20-3aa5437834df/session_54e4e76a-88ec-47fe-8787-b7d925a5a345/occlusion_92b33516-ba42-40bc-80ec-77c62a130f93/14_w1_o1_maxillaire_occlusion_occ_file_1.stl','STL','PATIENT_b9d4138d-2c8c-492f-bf20-3aa5437834df_ACT_54e4e76a-88ec-47fe-8787-b7d925a5a345_SESS_92b33516-ba42-40bc-80ec-77c62a130f93_TOSTL__STL_','2021-12-10 13:54:02','2019-08-28 20:01:50','','2021-12-10 14:54:02','SYNCED','2f7fded2-7b5f-4f6e-8f55-0f5f30f2fd97',1,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire Occlusion 1.14.1.1\",\"title\":\"Maxillaire Occlusion STL\"}'),(163,'be3ec918-8b02-450e-8e28-f25a61cb7c67','/var/.data/2020/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/1288ba7c-0bcf-4c6f-92e7-2873863af918/session_1a37c2d2-e6a1-4863-8afb-27944d3a7e33/occlusion_7560d619-3fa6-414c-85d8-52a724ef7bf4/scan_e45e36ef-7d3d-43b1-bfcd-00f5c6766a24/20_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_1288ba7c-0bcf-4c6f-92e7-2873863af918_ACT_1a37c2d2-e6a1-4863-8afb-27944d3a7e33_SESS_7560d619-3fa6-414c-85d8-52a724ef7bf4_TOSC_e45e36ef-7d3d-43b1-bfcd-00f5c6766a24_SNAPS_','2021-12-10 13:54:02','2020-02-17 12:03:03','20_w1_o1_maxillaire_snapshot_1.png','2021-12-10 14:54:02','SYNCED','bcc537fa-de81-4f4a-a687-dd2ad5438982',1,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.20.1.1.2\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(163,'bf8a5ead-e3ac-479b-a9f3-8fc17af8cb10','computedocclusion_92b33516-ba42-40bc-80ec-77cmigraoccl/','LIFI','PATIENT_b9d4138d-2c8c-492f-bf20-3aa5437834df_ACT_54e4e76a-88ec-47fe-8787-b7d925a5a345_SESS_92b33516-ba42-40bc-80ec-77c62a130f93_OCC_92b33516-ba42-40bc-80ec-77cmigraoccl_LIFIO_LIFI_','2021-12-16 21:26:06','2019-08-29 15:23:58','','2021-12-16 22:26:06','SYNCED','bf8a5ead-e3ac-479b-a9f3-8fc17af8cb10',0,'2021-12-16 22:26:06','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mandibule Occlusion 1.14.1.1\",\"isOcclusionMarginLine\":true,\"name\":\"Sans nom 0 Occlusion\",\"title\":\"MAXILLAIRE LIFI\",\"toothNumber\":1000,\"lifi_scan_type\":\"MAXILLAIRE\"}'),(163,'bf93739f-7ccf-4c21-9c8f-02a4c8c9e1c2','/var/.data/2017/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/c3d48f98-f992-4b17-9ebd-a8f388b7e0ca/session_ce36d71d-debf-4f14-bbe8-30830b342bd3/occlusion_2c9b2990-8860-4259-b919-67aa71e0b43f/scan_44384df8-d4cf-4515-a227-e58defb71ddd/5_w1_mandibule_scan_file_0.ply','PLY','PATIENT_c3d48f98-f992-4b17-9ebd-a8f388b7e0ca_ACT_ce36d71d-debf-4f14-bbe8-30830b342bd3_SESS_2c9b2990-8860-4259-b919-67aa71e0b43f_BOSC_44384df8-d4cf-4515-a227-e58defb71ddd_PLY_','2021-12-10 13:54:02','2017-11-30 17:51:04','','2021-12-10 14:54:02','SYNCED','bf93739f-7ccf-4c21-9c8f-02a4c8c9e1c2',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mandibule 1.5.1.1.1\",\"modelMatrix\":\"0.92173,-0.256717,0.290705,0,0.387831,0.610121,-0.690898,0,-1.07026e-08,0.749566,0.66193,0,2.82042,-23.133,-11.2583,1\",\"title\":\"Mandibule PLY\"}'),(163,'bfc26d0f-8c87-4bc8-8eb6-414ecd4d2501','/var/.data/2021/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/409f26d0-a7e4-4813-8322-7342ba9597af/session_87eba16d-aff7-41e9-9637-bf09b56f1030/occlusion_a53c56e5-88df-4213-95fa-5e72bf6599b9/scan_ff508a13-6fb6-4736-87b1-187a5e0330b5/21_w1_o1_maxillaire_scan_file_1.ply','PLY','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_87eba16d-aff7-41e9-9637-bf09b56f1030_SESS_a53c56e5-88df-4213-95fa-5e72bf6599b9_TOSC_ff508a13-6fb6-4736-87b1-187a5e0330b5_PLY_','2021-12-16 21:26:14','2021-04-11 12:00:32','21_w1_o1_maxillaire_scan_file_1.ply','2021-12-16 22:26:14','SYNCED','e48275cd-4456-4c27-9c83-938df1bce8a3',1,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.21.1.1.2\",\"modelMatrix\":\"0.89594,-0.345069,0.279678,0,0.444176,0.696032,-0.564134,0,2.07925e-8,0.629656,0.776874,0,22.3913,3.49688,-17.4585,1\",\"title\":\"Maxillaire PLY\"}'),(163,'c1d1f8e9-e378-44e3-9302-9ac3c4b77dfa','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/b9d4138d-2c8c-492f-bf20-3aa5437834df/session_54e4e76a-88ec-47fe-8787-b7d925a5a345/occlusion_92b33516-ba42-40bc-80ec-77c62a130f93/14_w1_o1_mandibule_occlusion_occ_file_0.stl','STL','PATIENT_b9d4138d-2c8c-492f-bf20-3aa5437834df_ACT_54e4e76a-88ec-47fe-8787-b7d925a5a345_SESS_92b33516-ba42-40bc-80ec-77c62a130f93_BOSTL__STL_','2021-12-10 13:54:02','2019-08-28 20:00:06','','2021-12-10 14:54:02','SYNCED','c1d1f8e9-e378-44e3-9302-9ac3c4b77dfa',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mandibule Occlusion 1.14.1.1\",\"title\":\"Mandibule Occlusion STL\"}'),(163,'c2a12178-bc47-40b7-b1f8-49dad7689c38','','STL','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_78f19188-19ad-480e-8d99-35699a9590fa_SESS_ea11a5f6-aafe-41d9-b61b-f8b13f045b1e_BOSC_6a1c5075-98b1-4211-9987-29ee0ba6ef5f_STL_','2020-12-16 20:58:19','2017-07-07 15:58:31','',NULL,'SYNCED','c2a12178-bc47-40b7-b1f8-49dad7689c38',0,'2019-08-20 15:37:52','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mandibule Occlusion 1.2.1.1\",\"modelMatrix\":\"0.999755,0.021779,-0.00391216,0,-0.0221276,0.984006,-0.176757,0,4.13977e-10,0.1768,0.984247,0,-17.1434,-5.85438,-15.7437,1\",\"title\":\"Mandibule STL\"}'),(163,'c38a95f8-5f9b-4321-9fb5-f876db2b59c7','/var/.data/2022/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/409f26d0-a7e4-4813-8322-7342ba9597af/session_97e5ae19-9444-4dd2-9134-8f61d8d268df/occlusion_85186f51-753c-498e-8346-beea8a780c7b/scan_942c6d2f-f8fa-467f-8daf-5a19257fea61/21_w2_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_97e5ae19-9444-4dd2-9134-8f61d8d268df_SESS_85186f51-753c-498e-8346-beea8a780c7b_RISC_942c6d2f-f8fa-467f-8daf-5a19257fea61_ZIP_','2022-02-12 14:45:12','2022-02-12 15:45:10','21_w2_o1_mordu_posterieur_droit_scan_file_0.zip','2022-02-12 15:45:12','SYNCED','c38a95f8-5f9b-4321-9fb5-f876db2b59c7',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mordu posterieur droit 1.21.2.1.1\",\"modelMatrix\":\"0.980218,-0.0487751,0.193119,0,0.0473424,0.998756,-0.0011372,0,-0.192193,0.0106832,0.981175,0,3.60044,3.58203,-17.7196,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(163,'c450cf2f-ec8e-4cb7-aa0a-e3d9d5c0fd05','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/b9d4138d-2c8c-492f-bf20-3aa5437834df/session_54e4e76a-88ec-47fe-8787-b7d925a5a345/occlusion_92b33516-ba42-40bc-80ec-77c62a130f93/computedocclusion_92b33516-ba42-40bc-80ec-77cmigraoccl/14_w1_o1_maxillaire_matrix_occ_file_1.m','MATRX','PATIENT_b9d4138d-2c8c-492f-bf20-3aa5437834df_ACT_54e4e76a-88ec-47fe-8787-b7d925a5a345_SESS_92b33516-ba42-40bc-80ec-77c62a130f93_OCC_92b33516-ba42-40bc-80ec-77cmigraoccl_TOMA__MATRX_','2021-12-10 13:54:03','2019-08-28 20:01:50','','2021-12-10 14:54:03','SYNCED','66f7c057-b653-4b14-b57f-df9137dd6388',1,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.14.1.1\",\"title\":\"Matrice Transfo. Maxillaire MATRIX\"}'),(163,'c69d2270-21b7-4a7a-a972-7ef5795a4220','','SNAPS','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_4829e17a-6262-4322-bd2d-12f3055adf7d_SESS_9f7449d6-1278-45d5-9492-02cd28be29ca_BOSC_26a71710-0617-458e-becc-629d4d7677c8_SNAPS_','2021-12-16 21:26:06','2019-08-20 14:57:25','','2021-12-16 22:26:06','SYNCED','c69d2270-21b7-4a7a-a972-7ef5795a4220',0,'2021-12-16 22:26:06','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MANDIBULE 1.2.2.2\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(163,'c6b0f3cc-8336-4cae-917f-bf6759764002','','PLY','PATIENT_c3d48f98-f992-4b17-9ebd-a8f388b7e0ca_ACT_ce36d71d-debf-4f14-bbe8-30830b342bd3_SESS_2c9b2990-8860-4259-b919-67aa71e0b43f_BOSC_dc0831aa-93b4-4baf-aab0-a9b0ce8b83e5_PLY_','2020-12-16 20:58:19','2017-09-23 10:33:37','',NULL,'SYNCED','c6b0f3cc-8336-4cae-917f-bf6759764002',0,'2017-09-23 10:33:37','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"modelMatrix\":\"0.0412372,-0.939612,0.339748,0,0.99915,0.0387799,-0.0140222,0,-1.02247e-10,0.340038,0.940412,0,0.899532,-2.83888,-9.85702,1\",\"title\":\"Mandibule PLY\"}'),(163,'c8476340-c7f4-4492-af1b-1638eca300cb','','ZIP','PATIENT_faa00c69-6a8f-4658-9cfd-f65108440db8_ACT_bc3db4c6-a79c-4ab4-a006-4f82c00387c4_SESS_05363e68-a254-4acc-8205-219c338c6ba1_TOSC_18a8129a-a9a0-43e4-b924-c8cc8c0e462c_ZIP_','2022-02-12 14:04:16','2021-12-16 22:43:27','','2022-02-12 15:04:16','SYNCED','c8476340-c7f4-4492-af1b-1638eca300cb',0,'2022-02-12 15:04:16','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.22.1.1.1\",\"modelMatrix\":\"0.996045,0.0865585,-0.0200614,0,-0.0888529,0.970325,-0.224889,0,1.39166e-9,0.225782,0.974178,0,2.69932,-3.67642,-14.902,1\",\"title\":\"Maxillaire ZIP\"}'),(163,'c8c830ba-cf40-40b0-b6b7-7194b746c2a2','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/bdb79646-26a6-440d-867f-112e46644df6/session_1ff39b04-4666-4c18-afaa-74990cd38521/occlusion_ae07c5e5-6b65-46ef-9cd1-c0a9daccea5f/scan_07ab566c-1f76-4aed-a865-ba42f4f56bfc/15_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_bdb79646-26a6-440d-867f-112e46644df6_ACT_1ff39b04-4666-4c18-afaa-74990cd38521_SESS_ae07c5e5-6b65-46ef-9cd1-c0a9daccea5f_TOSC_07ab566c-1f76-4aed-a865-ba42f4f56bfc_SNAPS_','2021-12-10 13:54:03','2019-09-18 15:21:05','','2021-12-10 14:54:03','SYNCED','c8c830ba-cf40-40b0-b6b7-7194b746c2a2',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.15.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(163,'c98dc488-e62f-4367-9cf1-0f11d08460dd','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_7cd8be19-c5e8-48d9-8950-c7006af5dda6/16_w1_o1_mordu_posterieur_droit_scan_file_2.ply','PLY','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_RISC_7cd8be19-c5e8-48d9-8950-c7006af5dda6_PLY_','2021-12-10 13:54:03','2019-10-09 19:55:54','16_w1_o1_mordu_posterieur_droit_scan_file_2.ply','2021-12-10 14:54:03','SYNCED','8f08a4aa-c3db-47d5-8812-811198ddca5a',2,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MORDU_POSTERIEUR_DROIT 1.16.1.1\",\"modelMatrix\":\"0.963071,-0.12478,0.239477,0,0.112827,0.991353,0.0643275,0,-0.244476,-0.041076,0.968787,0,-1.13169,-3.89187,-14.4966,1\",\"title\":\"MORDU_POSTERIEUR_DROIT PLY\"}'),(163,'c9b6005e-411d-4c7c-8e2d-820d894f40cf','','SNAPS','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_4829e17a-6262-4322-bd2d-12f3055adf7d_SESS_be8b17ea-1f2d-4455-823c-87f31acb59e4_TOSC_073fbacf-ede3-4d02-b1ed-c47271ca0e8b_SNAPS_','2021-12-16 21:26:06','2019-08-20 14:26:37','','2021-12-16 22:26:06','SYNCED','3564a77e-4582-46c4-9f2c-b5ad00af9b7f',1,'2021-12-16 22:26:06','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.2.2.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(163,'c9cfc51a-f52b-4ba8-98bf-f2b96ce33545','','STL','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_4829e17a-6262-4322-bd2d-12f3055adf7d_SESS_9f7449d6-1278-45d5-9492-02cd28be29ca_TOSC_19d904f0-1e7a-4097-baf5-3d03ff2ff6d0_STL_','2021-12-16 21:26:06','2019-08-20 14:40:51','','2021-12-16 22:26:06','SYNCED','a0754964-2abc-4bfc-9fd1-3368814f9560',1,'2021-12-16 22:26:06','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.2.2.2\",\"modelMatrix\":\"0.822459,0.538579,-0.183011,0,-0.568824,0.778729,-0.264614,0,-6.24943e-9,0.321735,0.94683,0,-5.69284,-35.5637,-16.8473,1\",\"title\":\"MAXILLAIRE STL\"}'),(163,'c9fe09d4-cd80-48e9-812a-78877cdd3e62','/var/.data/2022/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/42283eca-193c-404a-97f6-56ef218de2b8/session_7c5c9390-023c-4e0d-a61e-ae3e13c7e8f7/occlusion_a8dad053-002c-407d-875a-1d0fe8c5e10f/scan_eb411c34-6d2f-47b2-9f50-a318343a0ec0/23_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_42283eca-193c-404a-97f6-56ef218de2b8_ACT_7c5c9390-023c-4e0d-a61e-ae3e13c7e8f7_SESS_a8dad053-002c-407d-875a-1d0fe8c5e10f_TOSC_eb411c34-6d2f-47b2-9f50-a318343a0ec0_ZIP_','2022-03-26 14:42:15','2022-03-26 15:42:13','23_w1_o1_maxillaire_scan_file_0.zip','2022-03-26 15:42:15','SYNCED','c9fe09d4-cd80-48e9-812a-78877cdd3e62',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.23.1.1.1\",\"modelMatrix\":\"0.755644,-0.653554,0.0432393,0,0.654983,0.753995,-0.0498845,0,5.59627e-10,0.0660159,0.997819,0,-16.8994,5.19055,-14.5707,1\",\"title\":\"Maxillaire ZIP\"}'),(163,'ca16d92c-2112-4b6c-83ac-10b123b7e3f0','','SNAPS','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_4829e17a-6262-4322-bd2d-12f3055adf7d_SESS_9f7449d6-1278-45d5-9492-02cd28be29ca_TOSC_1c96bfa5-9beb-46a7-920d-54e049105cae_SNAPS_','2021-12-16 21:26:06','2019-08-20 14:49:14','','2021-12-16 22:26:06','SYNCED','ca16d92c-2112-4b6c-83ac-10b123b7e3f0',0,'2021-12-16 22:26:06','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.2.2.2\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(163,'cafc2275-35d2-453b-a78d-41fe37eb95e4','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_7cd8be19-c5e8-48d9-8950-c7006af5dda6/16_w1_o1_mordu_posterieur_droit_snapshot_1.png','SNAPS','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_RISC_7cd8be19-c5e8-48d9-8950-c7006af5dda6_SNAPS_','2021-12-10 13:54:03','2019-10-09 19:51:50','16_w1_o1_mordu_posterieur_droit_snapshot_1.png','2021-12-10 14:54:03','SYNCED','76dda0ce-1254-4edd-bfae-486661f8e03d',1,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MORDU_POSTERIEUR_DROIT 1.16.1.1\",\"title\":\"MORDU_POSTERIEUR_DROIT SNAPSHOT\"}'),(163,'cc353b45-490c-4cda-971d-9b57a05443e1','','PLY','PATIENT_c3d48f98-f992-4b17-9ebd-a8f388b7e0ca_ACT_ce36d71d-debf-4f14-bbe8-30830b342bd3_SESS_2c9b2990-8860-4259-b919-67aa71e0b43f_BOSC_3af0c7c7-068f-4b49-a043-c9deaf8798fc_PLY_','2020-12-16 20:58:19','2017-09-23 11:51:55','',NULL,'CREATED','23f1b081-9ad4-49bf-b123-0d1971f56cab',1,'2017-09-23 11:51:55','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"modelMatrix\":\"0.464279,-0.806799,0.365404,0,0.885689,0.422925,-0.191545,0,1.95659e-08,0.412564,0.910928,0,2.49506,-18.2306,-19.3693,1\",\"title\":\"Mandibule PLY\"}'),(163,'cc9c6ab1-44d9-4808-9f07-b14e58898b42','','STL','PATIENT_c3d48f98-f992-4b17-9ebd-a8f388b7e0ca_ACT_ce36d71d-debf-4f14-bbe8-30830b342bd3_SESS_2c9b2990-8860-4259-b919-67aa71e0b43f_BOSC_3af0c7c7-068f-4b49-a043-c9deaf8798fc_STL_','2020-12-16 20:58:19','2017-09-23 11:51:55','',NULL,'CREATED','06fda1e2-604f-4d55-9109-753390f8de28',3,'2017-09-23 11:51:55','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"modelMatrix\":\"0.766152,-0.220278,0.603729,0,0.64266,0.262607,-0.71974,0,-8.99308e-09,0.939423,0.342761,0,-4.48061,-25.3575,-8.68167,1\",\"title\":\"Mandibule STL\"}'),(163,'ccca477c-c237-4726-b103-037205c50d3d','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_7cd8be19-c5e8-48d9-8950-c7006af5dda6/16_w1_o1_mordu_posterieur_droit_scan_file_3.ply','PLY','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_RISC_7cd8be19-c5e8-48d9-8950-c7006af5dda6_PLY_','2021-12-10 13:54:03','2019-10-09 19:59:52','16_w1_o1_mordu_posterieur_droit_scan_file_3.ply','2021-12-10 14:54:03','SYNCED','8f08a4aa-c3db-47d5-8812-811198ddca5a',3,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MORDU_POSTERIEUR_DROIT 1.16.1.1\",\"modelMatrix\":\"0.962556,-0.115067,0.245447,0,0.100911,0.992437,0.0634498,0,-0.251602,-0.043368,0.967359,0,-1.51746,-3.55368,-14.6145,1\",\"title\":\"MORDU_POSTERIEUR_DROIT PLY\"}'),(163,'d003a690-dc4d-4562-9884-3f053f338768','/var/.data/2022/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/409f26d0-a7e4-4813-8322-7342ba9597af/session_97e5ae19-9444-4dd2-9134-8f61d8d268df/occlusion_85186f51-753c-498e-8346-beea8a780c7b/scan_cd569007-a8b8-4363-acd4-5ff36a438dbd/21_w2_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_97e5ae19-9444-4dd2-9134-8f61d8d268df_SESS_85186f51-753c-498e-8346-beea8a780c7b_TOSC_cd569007-a8b8-4363-acd4-5ff36a438dbd_ZIP_','2022-02-12 14:58:55','2022-02-12 15:58:52','21_w2_o1_maxillaire_scan_file_0.zip','2022-02-12 15:58:55','SYNCED','d003a690-dc4d-4562-9884-3f053f338768',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.21.2.1.6\",\"modelMatrix\":\"0.783037,0.472878,-0.40403,0,-0.621976,0.59533,-0.508653,0,-6.523e-09,0.649591,0.760284,0,-8.01074,-41.4171,-10.1402,1\",\"title\":\"Maxillaire ZIP\"}'),(163,'d0c49092-4174-41ea-a6df-115b7fbd1689','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_04084a21-671f-49ef-a336-594796e4386f/16_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_FRSC_04084a21-671f-49ef-a336-594796e4386f_SNAPS_','2021-12-10 13:54:03','2019-10-09 20:07:04','','2021-12-10 14:54:03','SYNCED','d0c49092-4174-41ea-a6df-115b7fbd1689',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MORDU_ANTERIEUR 1.16.1.1.1\",\"title\":\"MORDU_ANTERIEUR SNAPSHOT\"}'),(163,'d291fa5f-f8a2-4df1-8722-ce9dd35c0a1e','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_c721c0c0-a514-44bc-af6d-0394b9e59459/16_w1_o1_maxillaire_scan_file_1.stl','STL','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_TOSC_c721c0c0-a514-44bc-af6d-0394b9e59459_STL_','2021-12-10 13:54:03','2019-10-09 19:25:52','16_w1_o1_maxillaire_scan_file_1.stl','2021-12-10 14:54:03','SYNCED','5a0fc415-f9a5-4ae5-9e02-248ca895ca32',1,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"modelMatrix\":\"0.616332,-0.745321,0.254229,0,0.787486,0.58333,-0.198974,0,-1.48837e-8,0.322836,0.946455,0,11.7771,-5.53411,-13.8309,1\",\"title\":\"MAXILLAIRE STL\"}'),(163,'d303cf66-8219-41f9-ac8a-a9a6d81f0e51','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_4f66eeb0-72e9-4b3f-9e2e-2051256ddf18/16_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_LESC_4f66eeb0-72e9-4b3f-9e2e-2051256ddf18_SNAPS_','2021-12-10 13:54:03','2019-10-09 20:04:18','','2021-12-10 14:54:03','SYNCED','d303cf66-8219-41f9-ac8a-a9a6d81f0e51',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mordu posterieur gauche 1.16.1.1.1\",\"title\":\"MORDU_POSTERIEUR_GAUCHE SNAPSHOT\"}'),(163,'d4cc7dce-72d7-4f4a-9d50-2c92da97a233','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/b9d4138d-2c8c-492f-bf20-3aa5437834df/session_54e4e76a-88ec-47fe-8787-b7d925a5a345/occlusion_92b33516-ba42-40bc-80ec-77c62a130f93/computedocclusion_92b33516-ba42-40bc-80ec-77cmigraoccl/14_w1_o1_mandibule_occlusion_occ_file_0.ply','PLY','PATIENT_b9d4138d-2c8c-492f-bf20-3aa5437834df_ACT_54e4e76a-88ec-47fe-8787-b7d925a5a345_SESS_92b33516-ba42-40bc-80ec-77c62a130f93_OCC_92b33516-ba42-40bc-80ec-77cmigraoccl_BOPLY__PLY_','2021-12-10 13:54:03','2019-08-28 20:00:06','','2021-12-10 14:54:03','SYNCED','d4cc7dce-72d7-4f4a-9d50-2c92da97a233',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mandibule Occlusion 1.14.1.1\",\"title\":\"Mandibule Occlusion PLY\"}'),(163,'d4d9ec35-a91a-4fd8-a5f6-46de28e34612','','PLY','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_4829e17a-6262-4322-bd2d-12f3055adf7d_SESS_be8b17ea-1f2d-4455-823c-87f31acb59e4_BOSC_993e81f9-b63b-42e8-9992-72d3942cce1a_PLY_','2021-12-16 21:26:06','2019-08-20 14:30:37','','2021-12-16 22:26:06','SYNCED','d4d9ec35-a91a-4fd8-a5f6-46de28e34612',0,'2021-12-16 22:26:06','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mandibule Occlusion 1.2.2.1\",\"modelMatrix\":\"0.785829,0.550368,-0.282077,0,-0.618443,0.699328,-0.358424,0,-7.2817e-9,0.456109,0.889924,0,-4.80164,-13.1044,-12.194,1\",\"title\":\"MANDIBULE PLY\"}'),(163,'d52360b6-d894-4515-a6f0-d7c351152dbe','','SNAPS','PATIENT_c3d48f98-f992-4b17-9ebd-a8f388b7e0ca_ACT_ce36d71d-debf-4f14-bbe8-30830b342bd3_SESS_2c9b2990-8860-4259-b919-67aa71e0b43f_BOSC_b918998e-0bf2-43ed-924e-57f69af453e7_SNAPS_','2020-12-16 20:58:19','2017-09-23 10:35:58','',NULL,'SYNCED','d52360b6-d894-4515-a6f0-d7c351152dbe',0,'2017-09-23 10:35:58','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"title\":\"Mandibule SNAPSHOT\"}'),(163,'d5c7e23c-4a05-472b-bef5-950b733bfab5','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/b9d4138d-2c8c-492f-bf20-3aa5437834df/session_54e4e76a-88ec-47fe-8787-b7d925a5a345/occlusion_92b33516-ba42-40bc-80ec-77c62a130f93/computedocclusion_92b33516-ba42-40bc-80ec-77cmigraoccl/14_w1_o1_snapshot_occ_file_1.png','SNAPS','PATIENT_b9d4138d-2c8c-492f-bf20-3aa5437834df_ACT_54e4e76a-88ec-47fe-8787-b7d925a5a345_SESS_92b33516-ba42-40bc-80ec-77c62a130f93_OCC_92b33516-ba42-40bc-80ec-77cmigraoccl_SNAPO__SNAPS_','2021-12-10 13:54:04','2019-08-28 20:01:50','','2021-12-10 14:54:04','SYNCED','b67927f2-22fc-40af-9f19-12385a8c424a',1,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Snapshot 1.14.1.1\",\"title\":\"Snapshot SNAPSHOT\"}'),(3,'d64b1334-9d52-11e9-a33b-226cec7cb58a','/var/.data/2021/7655b09e-027b-49c5-9b6c-832c6e41cee8/discussion_605c208e-ad38-4268-a678-5f04c6f9007f/d64b1334-9d52-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_dcc81b31-38ca-437f-b1e2-7dd685a6af0f_ACT_677738ea-9ad8-4e2a-9cd2-074bfa0bf78d_SESS_74fb8ff3-73e7-4d38-a4cf-efbd69884ace_TOSC_41bee0c2-80a9-42c3-bca3-64690ff159ef_STL_','2020-11-23 20:19:26','2019-07-03 17:18:05','d64b1334-9d52-11e9-a33b-226cec7cb58a.stl','2020-11-23 21:19:26','SYNCED','d64b1334-9d52-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.9.1.1.1\",\"modelMatrix\":\"0.972746,-0.229158,0.0353824,0,0.231873,0.961354,-0.148435,0,2.17642e-10,0.152594,0.988289,0,-35.8517,-15.8436,-18.6142,1\",\"title\":\"MAXILLAIRE STL\"}'),(3,'d64c9ff0-9d52-11e9-a33b-226cec7cb58a','/var/.data/2021/7655b09e-027b-49c5-9b6c-832c6e41cee8/discussion_605c208e-ad38-4268-a678-5f04c6f9007f/d64c9ff0-9d52-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_dcc81b31-38ca-437f-b1e2-7dd685a6af0f_ACT_677738ea-9ad8-4e2a-9cd2-074bfa0bf78d_SESS_74fb8ff3-73e7-4d38-a4cf-efbd69884ace_TOSC_41bee0c2-80a9-42c3-bca3-64690ff159ef_SNAPS_','2020-11-23 20:19:26','2019-07-03 17:18:05','d64c9ff0-9d52-11e9-a33b-226cec7cb58a.png','2020-11-23 21:19:26','SYNCED','d64c9ff0-9d52-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.9.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(3,'d6507660-9d52-11e9-a33b-226cec7cb58a','/var/.data/2021/7655b09e-027b-49c5-9b6c-832c6e41cee8/discussion_605c208e-ad38-4268-a678-5f04c6f9007f/d6507660-9d52-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_dcc81b31-38ca-437f-b1e2-7dd685a6af0f_ACT_677738ea-9ad8-4e2a-9cd2-074bfa0bf78d_SESS_74fb8ff3-73e7-4d38-a4cf-efbd69884ace_TOSC_41bee0c2-80a9-42c3-bca3-64690ff159ef_PLY_','2020-11-23 20:19:26','2019-07-03 17:18:05','d6507660-9d52-11e9-a33b-226cec7cb58a.ply','2020-11-23 21:19:26','SYNCED','d6507660-9d52-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.9.1.1.1\",\"modelMatrix\":\"0.972746,-0.229158,0.0353824,0,0.231873,0.961354,-0.148435,0,2.17642e-10,0.152594,0.988289,0,-35.8517,-15.8436,-18.6142,1\",\"title\":\"MAXILLAIRE PLY\"}'),(163,'d74c043a-1a69-4c1b-b15d-0294ad179983','','SNAPS','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_78f19188-19ad-480e-8d99-35699a9590fa_SESS_ea11a5f6-aafe-41d9-b61b-f8b13f045b1e_TOSC_d1dc341b-6602-437f-99c5-f70a9e47e85a_SNAPS_','2020-12-16 20:58:19','2017-06-22 18:17:24','',NULL,'SYNCED','d74c043a-1a69-4c1b-b15d-0294ad179983',0,'2017-06-22 18:17:24','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"title\":\"Maxillaire SNAPSHOT\"}'),(163,'d8d85c43-8550-4d6b-b9cb-c32a35f811ce','/var/.data/2022/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/409f26d0-a7e4-4813-8322-7342ba9597af/session_97e5ae19-9444-4dd2-9134-8f61d8d268df/occlusion_85186f51-753c-498e-8346-beea8a780c7b/scan_3c0180ee-a48e-4a57-83c5-b2c2144f5bc2/21_w2_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_97e5ae19-9444-4dd2-9134-8f61d8d268df_SESS_85186f51-753c-498e-8346-beea8a780c7b_BOSC_3c0180ee-a48e-4a57-83c5-b2c2144f5bc2_ZIP_','2022-02-12 14:39:13','2022-02-12 15:39:04','21_w2_o1_mandibule_scan_file_0.zip','2022-02-12 15:39:13','SYNCED','d8d85c43-8550-4d6b-b9cb-c32a35f811ce',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mandibule 1.21.2.1.2\",\"modelMatrix\":\"-0.978078,-0.133691,0.159658,0,0.20824,-0.627928,0.749895,0,8.31149e-09,0.766703,0.642002,0,13.3814,-10.9477,-15.478,1\",\"title\":\"Mandibule ZIP\"}'),(163,'dabf252e-b8aa-4c07-a2d2-208a2e3b9178','/var/.data/2022/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/42283eca-193c-404a-97f6-56ef218de2b8/session_7c5c9390-023c-4e0d-a61e-ae3e13c7e8f7/occlusion_a8dad053-002c-407d-875a-1d0fe8c5e10f/scan_eb411c34-6d2f-47b2-9f50-a318343a0ec0/23_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_42283eca-193c-404a-97f6-56ef218de2b8_ACT_7c5c9390-023c-4e0d-a61e-ae3e13c7e8f7_SESS_a8dad053-002c-407d-875a-1d0fe8c5e10f_TOSC_eb411c34-6d2f-47b2-9f50-a318343a0ec0_SNAPS_','2022-03-26 14:42:15','2022-03-26 15:42:12','23_w1_o1_maxillaire_snapshot_0.png','2022-03-26 15:42:15','SYNCED','dabf252e-b8aa-4c07-a2d2-208a2e3b9178',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.23.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(163,'dae9f2a3-c4f3-4de7-9f42-43667adba09f','','STL','PATIENT_c3d48f98-f992-4b17-9ebd-a8f388b7e0ca_ACT_ce36d71d-debf-4f14-bbe8-30830b342bd3_SESS_2c9b2990-8860-4259-b919-67aa71e0b43f_BOSC_3af0c7c7-068f-4b49-a043-c9deaf8798fc_STL_','2020-12-16 20:58:19','2017-09-23 11:51:55','',NULL,'CREATED','06fda1e2-604f-4d55-9109-753390f8de28',2,'2017-09-23 11:51:55','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"modelMatrix\":\"0.763764,-0.223642,0.605516,0,0.645496,0.264618,-0.716458,0,-2.8558e-08,0.938063,0.346466,0,-3.69598,-25.1252,-7.92147,1\",\"title\":\"Mandibule STL\"}'),(163,'dafd74d2-dd54-4260-8a8a-ac8fdcfe717a','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_c721c0c0-a514-44bc-af6d-0394b9e59459/16_w1_o1_maxillaire_scan_file_0.ply','PLY','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_TOSC_c721c0c0-a514-44bc-af6d-0394b9e59459_PLY_','2021-12-10 13:54:04','2019-10-09 19:22:10','','2021-12-10 14:54:04','SYNCED','dafd74d2-dd54-4260-8a8a-ac8fdcfe717a',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1.1\",\"modelMatrix\":\"0.410931,-0.866317,0.283955,0,0.911666,0.39049,-0.127992,0,6.27254e-9,0.311468,0.950257,0,9.07828,-8.54913,-11.8536,1\",\"title\":\"MAXILLAIRE PLY\"}'),(163,'dd651c32-5d3b-4598-bb9f-7e028160d5fd','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/b9d4138d-2c8c-492f-bf20-3aa5437834df/session_54e4e76a-88ec-47fe-8787-b7d925a5a345/occlusion_92b33516-ba42-40bc-80ec-77c62a130f93/scan_3f4e0761-9685-4aa9-a99e-f32bc3f3587a/14_w1_o1_mandibule_scan_file_0.ply','PLY','PATIENT_b9d4138d-2c8c-492f-bf20-3aa5437834df_ACT_54e4e76a-88ec-47fe-8787-b7d925a5a345_SESS_92b33516-ba42-40bc-80ec-77c62a130f93_BOSC_3f4e0761-9685-4aa9-a99e-f32bc3f3587a_PLY_','2021-12-10 13:54:04','2019-08-28 19:48:42','','2021-12-10 14:54:04','SYNCED','dd651c32-5d3b-4598-bb9f-7e028160d5fd',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mandibule 1.14.1.1.1\",\"modelMatrix\":\"0.289133,0.88827,-0.356901,0,-0.957289,0.268287,-0.107796,0,1.97496e-9,0.372824,0.927902,0,-2.26156,-6.31375,-20.394,1\",\"title\":\"MANDIBULE PLY\"}'),(163,'dde30441-002a-4e92-9233-96d200200eb1','','SNAPS','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_97e5ae19-9444-4dd2-9134-8f61d8d268df_SESS_85186f51-753c-498e-8346-beea8a780c7b_BOSC_00186753-75e1-4932-a7c7-83841ff310c4_SNAPS_','2022-03-26 13:54:03','2022-02-12 15:12:05','','2022-03-26 14:54:03','SYNCED','dde30441-002a-4e92-9233-96d200200eb1',0,'2022-03-26 14:54:03','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mandibule 1.21.2.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(163,'df26a803-1f84-452f-8358-f7e2941632cb','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/b10e93aa-548c-427f-adcd-2dbc22bc6626/session_692fa6c8-2523-4d56-bebf-b736f05db142/occlusion_c2195287-5f39-4a66-93d5-5b83792fc9a8/scan_18cd0f29-a9fb-4dcd-91fe-8fb30a4d171a/17_w1_o1_maxillaire_scan_file_2.ply','PLY','PATIENT_b10e93aa-548c-427f-adcd-2dbc22bc6626_ACT_692fa6c8-2523-4d56-bebf-b736f05db142_SESS_c2195287-5f39-4a66-93d5-5b83792fc9a8_TOSC_18cd0f29-a9fb-4dcd-91fe-8fb30a4d171a_PLY_','2021-12-10 13:54:04','2019-10-14 13:02:11','','2021-12-10 14:54:04','SYNCED','4e12bcab-9945-4ac0-80ca-4f849846a4bd',2,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.17.1.1.1\",\"modelMatrix\":\"0.891043,0.44454,-0.0917963,0,-0.453919,0.872632,-0.180196,0,-5.32389e-10,0.20223,0.979338,0,-9.04271,-16.6029,-12.7969,1\",\"title\":\"MAXILLAIRE PLY\"}'),(163,'df33eab1-f93f-4b78-93da-b18b16a448e6','','SNAPS','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_4829e17a-6262-4322-bd2d-12f3055adf7d_SESS_9f7449d6-1278-45d5-9492-02cd28be29ca_TOSC_19d904f0-1e7a-4097-baf5-3d03ff2ff6d0_SNAPS_','2021-12-16 21:26:06','2019-08-20 14:40:51','','2021-12-16 22:26:06','SYNCED','1014295d-2e79-47fe-92bf-3111bfc9d43e',1,'2021-12-16 22:26:06','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.2.2.2\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(163,'df8fd6d6-4a11-4757-b046-a7ffa9a05eab','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/b9d4138d-2c8c-492f-bf20-3aa5437834df/session_54e4e76a-88ec-47fe-8787-b7d925a5a345/occlusion_92b33516-ba42-40bc-80ec-77c62a130f93/computedocclusion_92b33516-ba42-40bc-80ec-77cmigraoccl/14_w1_o1_maxillaire_occlusion_occ_file_1.ply','PLY','PATIENT_b9d4138d-2c8c-492f-bf20-3aa5437834df_ACT_54e4e76a-88ec-47fe-8787-b7d925a5a345_SESS_92b33516-ba42-40bc-80ec-77c62a130f93_OCC_92b33516-ba42-40bc-80ec-77cmigraoccl_TOPLY__PLY_','2021-12-10 13:54:04','2019-08-28 20:01:50','','2021-12-10 14:54:04','SYNCED','36485abc-845b-4d31-9b2e-f1d57c158b2f',1,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire Occlusion 1.14.1.1\",\"title\":\"Maxillaire Occlusion PLY\"}'),(163,'dfb3acc0-5259-451b-9dee-6ebd6b98f76f','/var/.data/2022/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/409f26d0-a7e4-4813-8322-7342ba9597af/session_97e5ae19-9444-4dd2-9134-8f61d8d268df/occlusion_85186f51-753c-498e-8346-beea8a780c7b/scan_cd569007-a8b8-4363-acd4-5ff36a438dbd/21_w2_o1_maxillaire_scan_file_2.zip','ZIP','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_97e5ae19-9444-4dd2-9134-8f61d8d268df_SESS_85186f51-753c-498e-8346-beea8a780c7b_TOSC_cd569007-a8b8-4363-acd4-5ff36a438dbd_ZIP_','2022-02-12 15:23:44','2022-02-12 16:23:41','21_w2_o1_maxillaire_scan_file_2.zip','2022-02-12 16:23:44','SYNCED','d003a690-dc4d-4562-9884-3f053f338768',2,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.21.2.1.6\",\"modelMatrix\":\"0.807322,0.458371,-0.371655,0,-0.590111,0.62709,-0.508455,0,-2.26644e-08,0.629805,0.776753,0,-8.18871,-41.9597,-11.6152,1\",\"title\":\"Maxillaire ZIP\"}'),(163,'e0be079b-af79-44e4-9464-46d48246ee2e','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/order_0f0915f0-d99f-401f-bc07-6de3f1346d65/16_w1_couronne_sur_implant_prost_file_0.json','JSON','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_PROST_0f0915f0-d99f-401f-bc07-6de3f1346d65_JSON_','2019-12-15 21:03:21','2019-10-09 20:32:18','','2019-12-15 22:03:21','SYNCED','e0be079b-af79-44e4-9464-46d48246ee2e',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"COURONNE SUR IMPLANT 1.16.1 COURONNE SUR IMPLANT\",\"title\":\"Couronne sur Implant JSON\"}'),(163,'e232f8ba-a8e2-4b1b-af2f-a9df87af7d9d','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/b9d4138d-2c8c-492f-bf20-3aa5437834df/session_54e4e76a-88ec-47fe-8787-b7d925a5a345/occlusion_92b33516-ba42-40bc-80ec-77c62a130f93/scan_be3fdbda-df17-4184-bf04-6f17a0efb2c6/14_w1_o1_mordu_posterieur_gauche_scan_file_0.ply','PLY','PATIENT_b9d4138d-2c8c-492f-bf20-3aa5437834df_ACT_54e4e76a-88ec-47fe-8787-b7d925a5a345_SESS_92b33516-ba42-40bc-80ec-77c62a130f93_LESC_be3fdbda-df17-4184-bf04-6f17a0efb2c6_PLY_','2021-12-10 13:54:04','2019-08-28 19:56:43','','2021-12-10 14:54:04','SYNCED','e232f8ba-a8e2-4b1b-af2f-a9df87af7d9d',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mordu posterieur gauche 1.14.1.1.1\",\"modelMatrix\":\"-0.96361,-0.188213,0.190629,0,0.222107,-0.960005,0.17339,0,0.148751,0.207296,0.966231,0,13.428,-2.96864,-19.2432,1\",\"title\":\"MORDU_POSTERIEUR_GAUCHE PLY\"}'),(3,'e28deca9-9a33-4f4a-a764-0a13a3305f4b','/var/.data/2021/7655b09e-027b-49c5-9b6c-832c6e41cee8/discussion_605c208e-ad38-4268-a678-5f04c6f9007f/e28deca9-9a33-4f4a-a764-0a13a3305f4b.pdf','PDF','PATIENT_f1ba7774-7c5d-40d1-adaf-bf5e9ddee4c5_ACT_6c4aa713-5123-4551-8db5-cfa1136bd86a_PROST_f22738cf-6b3e-437b-82a4-ba4f30397b8e_PDF_','2019-12-15 21:03:21','2019-07-08 15:35:21','e28deca9-9a33-4f4a-a764-0a13a3305f4b.pdf','2019-12-15 22:03:21','SYNCED','e28deca9-9a33-4f4a-a764-0a13a3305f4b',0,NULL,'','','{\"displayTitle\":\"COURONNE 2.2.2 COURONNE\",\"title\":\"Couronne PDF\"}'),(163,'e34bd481-90b0-47c9-9f3b-8114fff93036','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/bdb79646-26a6-440d-867f-112e46644df6/session_1ff39b04-4666-4c18-afaa-74990cd38521/occlusion_ae07c5e5-6b65-46ef-9cd1-c0a9daccea5f/scan_0796eab6-1d31-4c12-930b-d1645168f0cc/15_w1_o1_mordu_anterieur_scan_file_0.stl','STL','PATIENT_bdb79646-26a6-440d-867f-112e46644df6_ACT_1ff39b04-4666-4c18-afaa-74990cd38521_SESS_ae07c5e5-6b65-46ef-9cd1-c0a9daccea5f_FRSC_0796eab6-1d31-4c12-930b-d1645168f0cc_STL_','2021-12-10 13:54:04','2019-09-19 17:37:02','','2021-12-10 14:54:04','SYNCED','e34bd481-90b0-47c9-9f3b-8114fff93036',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MORDU_ANTERIEUR 1.15.1.1.1\",\"modelMatrix\":\"-0.985757,0.00142314,-0.165103,0,0.00926254,-0.999363,-0.0326102,0,-0.168013,-0.03611,0.985748,0,1.6677,-1.65917,-21.2856,1\",\"title\":\"MORDU_ANTERIEUR STL\"}'),(163,'e36af518-bf7d-4847-95c4-06d20926f931','','SNAPS','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_97e5ae19-9444-4dd2-9134-8f61d8d268df_SESS_85186f51-753c-498e-8346-beea8a780c7b_LESC_0aa3a260-9283-4def-b4f0-f3652eb329cc_SNAPS_','2022-03-26 13:54:03','2022-02-12 15:32:29','','2022-03-26 14:54:03','SYNCED','e36af518-bf7d-4847-95c4-06d20926f931',0,'2022-03-26 14:54:03','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mordu posterieur gauche 1.21.2.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(163,'e48275cd-4456-4c27-9c83-938df1bce8a3','/var/.data/2021/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/409f26d0-a7e4-4813-8322-7342ba9597af/session_87eba16d-aff7-41e9-9637-bf09b56f1030/occlusion_a53c56e5-88df-4213-95fa-5e72bf6599b9/scan_ff508a13-6fb6-4736-87b1-187a5e0330b5/21_w1_o1_maxillaire_scan_file_0.ply','PLY','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_87eba16d-aff7-41e9-9637-bf09b56f1030_SESS_a53c56e5-88df-4213-95fa-5e72bf6599b9_TOSC_ff508a13-6fb6-4736-87b1-187a5e0330b5_PLY_','2021-12-16 21:26:05','2021-04-11 11:57:45','21_w1_o1_maxillaire_scan_file_0.ply','2021-12-16 22:26:05','SYNCED','e48275cd-4456-4c27-9c83-938df1bce8a3',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire PLY\",\"modelMatrix\":\"0.911416,-0.32053,0.258032,0,0.411485,0.709956,-0.571527,0,-1.25154e-8,0.627076,0.778958,0,23.0395,1.92077,-17.483,1\",\"title\":\"Maxillaire PLY\"}'),(3,'e6376a68-cf36-436d-8e75-85d45fd650b3','/var/.data/2021/7655b09e-027b-49c5-9b6c-832c6e41cee8/discussion_605c208e-ad38-4268-a678-5f04c6f9007f/e6376a68-cf36-436d-8e75-85d45fd650b3.png','SNAPS','PATIENT_f1ba7774-7c5d-40d1-adaf-bf5e9ddee4c5_ACT_6c4aa713-5123-4551-8db5-cfa1136bd86a_SESS_b1f65e85-2a53-4c07-89bc-95a34ee8c209_TOSC_3a6328c7-ecc7-45ef-b5b6-32a9abadded8_SNAPS_','2020-11-23 20:19:26','2019-07-08 15:30:28','e6376a68-cf36-436d-8e75-85d45fd650b3.png','2020-11-23 21:19:26','SYNCED','e6376a68-cf36-436d-8e75-85d45fd650b3',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 2.2.2.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(163,'e6e29632-fbf6-43f8-acdd-57c836081670','/var/.data/2022/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/409f26d0-a7e4-4813-8322-7342ba9597af/session_97e5ae19-9444-4dd2-9134-8f61d8d268df/occlusion_85186f51-753c-498e-8346-beea8a780c7b/scan_942c6d2f-f8fa-467f-8daf-5a19257fea61/21_w2_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_97e5ae19-9444-4dd2-9134-8f61d8d268df_SESS_85186f51-753c-498e-8346-beea8a780c7b_RISC_942c6d2f-f8fa-467f-8daf-5a19257fea61_SNAPS_','2022-02-12 14:45:12','2022-02-12 15:45:10','21_w2_o1_mordu_posterieur_droit_snapshot_0.png','2022-02-12 15:45:12','SYNCED','e6e29632-fbf6-43f8-acdd-57c836081670',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mordu posterieur droit 1.21.2.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(163,'e718ad91-2aab-4430-9ea9-5014c920299b','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/bdb79646-26a6-440d-867f-112e46644df6/session_1ff39b04-4666-4c18-afaa-74990cd38521/occlusion_ae07c5e5-6b65-46ef-9cd1-c0a9daccea5f/scan_07ab566c-1f76-4aed-a865-ba42f4f56bfc/15_w1_o1_maxillaire_scan_file_0.stl','STL','PATIENT_bdb79646-26a6-440d-867f-112e46644df6_ACT_1ff39b04-4666-4c18-afaa-74990cd38521_SESS_ae07c5e5-6b65-46ef-9cd1-c0a9daccea5f_TOSC_07ab566c-1f76-4aed-a865-ba42f4f56bfc_STL_','2021-12-10 13:54:04','2019-09-18 15:21:05','','2021-12-10 14:54:04','SYNCED','e718ad91-2aab-4430-9ea9-5014c920299b',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.15.1.1.1\",\"modelMatrix\":\"0.975068,0.19737,-0.101425,0,-0.221905,0.867259,-0.445667,0,-7.79617e-9,0.457063,0.889434,0,-15.2766,-12.3359,-5.25124,1\",\"title\":\"MAXILLAIRE STL\"}'),(163,'e74c6abb-f68f-4393-a830-53652f4b0201','','SNAPS','PATIENT_3e81f0de-1357-45a1-a1d1-75e348b3b043_ACT_4252a7af-d6d9-4447-b402-60820076dceb_SESS_6e0b4165-03cb-4f3b-bd97-fca211c1fe33_BOSC_c747cc9f-b0ac-4699-9c44-0651899bc2b1_SNAPS_','2021-12-16 21:26:07','2019-08-20 15:36:26','','2021-12-16 22:26:07','SYNCED','e74c6abb-f68f-4393-a830-53652f4b0201',0,'2021-12-16 22:26:07','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MANDIBULE 1.12.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(163,'e7aff107-74de-4692-8cc6-1e7b0ff9de2f','','PLY','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_4829e17a-6262-4322-bd2d-12f3055adf7d_SESS_9f7449d6-1278-45d5-9492-02cd28be29ca_TOSC_19d904f0-1e7a-4097-baf5-3d03ff2ff6d0_PLY_','2021-12-16 21:26:07','2019-08-20 14:40:51','','2021-12-16 22:26:07','SYNCED','f95119ce-2fc9-4394-9721-e06fe8267fe4',1,'2021-12-16 22:26:07','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MAXILLAIRE 1.2.2.2\",\"modelMatrix\":\"0.822459,0.538579,-0.183011,0,-0.568824,0.778729,-0.264614,0,-6.24943e-9,0.321735,0.94683,0,-5.69284,-35.5637,-16.8473,1\",\"title\":\"MAXILLAIRE PLY\"}'),(163,'e8dadd53-f8a7-4cee-9109-41034eca20e6','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_c721c0c0-a514-44bc-af6d-0394b9e59459/16_w1_o1_maxillaire_scan_file_3.ply','PLY','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_TOSC_c721c0c0-a514-44bc-af6d-0394b9e59459_PLY_','2021-12-10 13:54:05','2019-10-09 19:30:43','','2021-12-10 14:54:05','SYNCED','dafd74d2-dd54-4260-8a8a-ac8fdcfe717a',3,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.16.1.1.1\",\"modelMatrix\":\"0.418185,-0.867684,0.268784,0,0.908362,0.399458,-0.123741,0,-8.03681e-9,0.2959,0.955219,0,11.3243,-2.98852,-14.4642,1\",\"title\":\"MAXILLAIRE PLY\"}'),(163,'ea8078ad-79b9-48a5-91ba-1f7fac287026','','SNAPS','PATIENT_3e81f0de-1357-45a1-a1d1-75e348b3b043_ACT_4252a7af-d6d9-4447-b402-60820076dceb_SESS_6e0b4165-03cb-4f3b-bd97-fca211c1fe33_BOSC_678e3b56-1265-4277-ab02-4bde03704ae0_SNAPS_','2021-12-16 21:26:07','2019-08-20 15:36:57','','2021-12-16 22:26:07','SYNCED','ea8078ad-79b9-48a5-91ba-1f7fac287026',0,'2021-12-16 22:26:07','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MANDIBULE 1.12.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(163,'ecab608c-1b4f-40da-b9fc-82f952b14a67','/var/.data/2022/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/409f26d0-a7e4-4813-8322-7342ba9597af/session_97e5ae19-9444-4dd2-9134-8f61d8d268df/occlusion_85186f51-753c-498e-8346-beea8a780c7b/scan_cd569007-a8b8-4363-acd4-5ff36a438dbd/21_w2_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_97e5ae19-9444-4dd2-9134-8f61d8d268df_SESS_85186f51-753c-498e-8346-beea8a780c7b_TOSC_cd569007-a8b8-4363-acd4-5ff36a438dbd_ZIP_','2022-02-12 15:06:58','2022-02-12 16:06:52','21_w2_o1_maxillaire_scan_file_1.zip','2022-02-12 16:06:58','SYNCED','d003a690-dc4d-4562-9884-3f053f338768',1,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.21.2.1.6\",\"modelMatrix\":\"0.804898,0.453286,-0.382977,0,-0.593414,0.614831,-0.519464,0,2.08581e-08,0.645379,0.763862,0,-8.45018,-41.9396,-10.7629,1\",\"title\":\"Maxillaire ZIP\"}'),(163,'eec326a1-9d25-49b3-9968-9781ac07b1ff','','SNAPS','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_87eba16d-aff7-41e9-9637-bf09b56f1030_SESS_a53c56e5-88df-4213-95fa-5e72bf6599b9_TOSC_606f5a2d-49c9-431b-adfc-bfd319d3757c_SNAPS_','2021-04-11 10:20:25','2021-04-11 12:15:56','',NULL,'CREATED','eec326a1-9d25-49b3-9968-9781ac07b1ff',0,'2021-04-11 12:20:25','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.21.1.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(163,'eed9f4a6-6cb9-4553-a819-5ed36a9b5c9e','/var/.data/2017/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/c3d48f98-f992-4b17-9ebd-a8f388b7e0ca/session_ce36d71d-debf-4f14-bbe8-30830b342bd3/occlusion_2c9b2990-8860-4259-b919-67aa71e0b43f/scan_44384df8-d4cf-4515-a227-e58defb71ddd/5_w1_mandibule_snapshot_0.png','SNAPS','PATIENT_c3d48f98-f992-4b17-9ebd-a8f388b7e0ca_ACT_ce36d71d-debf-4f14-bbe8-30830b342bd3_SESS_2c9b2990-8860-4259-b919-67aa71e0b43f_BOSC_44384df8-d4cf-4515-a227-e58defb71ddd_SNAPS_','2021-12-10 13:54:05','2017-11-30 17:50:30','','2021-12-10 14:54:05','SYNCED','eed9f4a6-6cb9-4553-a819-5ed36a9b5c9e',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mandibule 1.5.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(163,'ef2faa51-92ed-4810-914e-f585dc84b167','','PLY','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_78f19188-19ad-480e-8d99-35699a9590fa_SESS_ea11a5f6-aafe-41d9-b61b-f8b13f045b1e_TOSC_6e7c8911-84d8-43fd-8f0f-1af7ab21a105_PLY_','2020-12-16 20:58:19','2017-07-07 14:59:28','',NULL,'SYNCED','ef2faa51-92ed-4810-914e-f585dc84b167',0,'2017-07-07 14:59:28','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"modelMatrix\":\"0.999519,-0.0306223,0.00482209,0,0.0309996,0.987353,-0.155478,0,-3.13187e-10,0.155553,0.987828,0,9.92195,-3.93564,-21.9356,1\",\"title\":\"Maxillaire PLY\"}'),(163,'ef91b022-83f4-4ff4-97e8-4bcb62ff5b6d','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_f1172a60-6504-4697-9acb-2793b430d7fe/16_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_BOSC_f1172a60-6504-4697-9acb-2793b430d7fe_SNAPS_','2021-12-10 13:54:05','2019-10-09 19:36:04','','2021-12-10 14:54:05','SYNCED','ef91b022-83f4-4ff4-97e8-4bcb62ff5b6d',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MANDIBULE 1.16.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(163,'f16e392b-d1d5-499c-a379-06e00eb00a82','','STL','PATIENT_3e81f0de-1357-45a1-a1d1-75e348b3b043_ACT_4252a7af-d6d9-4447-b402-60820076dceb_SESS_6e0b4165-03cb-4f3b-bd97-fca211c1fe33_BOSC_678e3b56-1265-4277-ab02-4bde03704ae0_STL_','2021-12-16 21:26:07','2019-08-20 15:36:57','','2021-12-16 22:26:07','SYNCED','f16e392b-d1d5-499c-a379-06e00eb00a82',0,'2021-12-16 22:26:07','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MANDIBULE 1.12.1.1\",\"modelMatrix\":\"-0.890732,0.44771,-0.0784345,0,-0.454528,-0.87737,0.153707,0,-3.31592e-9,0.172562,0.984999,0,2.93943,-4.89958,-13.1184,1\",\"title\":\"MANDIBULE STL\"}'),(163,'f23cf02f-cc31-4339-863c-a995c5c0eed8','','PLY','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_78f19188-19ad-480e-8d99-35699a9590fa_SESS_ea11a5f6-aafe-41d9-b61b-f8b13f045b1e_BOSC_6a1c5075-98b1-4211-9987-29ee0ba6ef5f_PLY_','2020-12-16 20:58:19','2017-07-07 16:08:30','',NULL,'SYNCED','a730168d-f711-4f65-97cc-e1abf584ee29',2,'2019-08-20 15:37:52','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MANDIBULE 1.2.1.1\",\"modelMatrix\":\"0.111795,-0.970141,0.21524,0,0.993731,0.109141,-0.0242146,0,-4.20565e-10,0.216598,0.976261,0,-3.17449,5.61795,-23.9668,1\",\"title\":\"Mandibule PLY\"}'),(163,'f2610181-ff91-4f47-9c01-1b9ad8b99487','','SNAPS','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_78f19188-19ad-480e-8d99-35699a9590fa_SESS_ea11a5f6-aafe-41d9-b61b-f8b13f045b1e_BOSC_6a1c5075-98b1-4211-9987-29ee0ba6ef5f_SNAPS_','2020-12-16 20:58:19','2017-07-07 16:02:01','',NULL,'SYNCED','06c13027-f4ec-452a-90e6-376ae8aa4573',1,'2019-08-20 15:37:52','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mandibule Occlusion 1.2.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(163,'f2eab1f5-bc32-4010-8205-31f71d9839d3','','PLY','PATIENT_3e81f0de-1357-45a1-a1d1-75e348b3b043_ACT_4252a7af-d6d9-4447-b402-60820076dceb_SESS_6e0b4165-03cb-4f3b-bd97-fca211c1fe33_BOSC_678e3b56-1265-4277-ab02-4bde03704ae0_PLY_','2021-12-16 21:26:07','2019-08-20 15:36:57','','2021-12-16 22:26:07','SYNCED','f2eab1f5-bc32-4010-8205-31f71d9839d3',0,'2021-12-16 22:26:07','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MANDIBULE 1.12.1.1\",\"modelMatrix\":\"-0.890732,0.44771,-0.0784345,0,-0.454528,-0.87737,0.153707,0,-3.31592e-9,0.172562,0.984999,0,2.93943,-4.89958,-13.1184,1\",\"title\":\"MANDIBULE PLY\"}'),(163,'f3227141-7884-4fbb-afb6-a2168a8223e6','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_04084a21-671f-49ef-a336-594796e4386f/16_w1_o1_mordu_anterieur_scan_file_0.stl','STL','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_FRSC_04084a21-671f-49ef-a336-594796e4386f_STL_','2021-12-10 13:54:05','2019-10-09 20:07:04','','2021-12-10 14:54:05','SYNCED','f3227141-7884-4fbb-afb6-a2168a8223e6',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MORDU_ANTERIEUR 1.16.1.1.1\",\"modelMatrix\":\"0.886347,-0.228412,-0.409922,0,0.170257,0.973164,-0.109534,0,0.43108,0.0420153,0.905912,0,-4.658,-5.71516,-30.4802,1\",\"title\":\"MORDU_ANTERIEUR STL\"}'),(163,'f542d9cf-fca7-4ca6-b5df-2410384eb5ce','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/b9d4138d-2c8c-492f-bf20-3aa5437834df/session_54e4e76a-88ec-47fe-8787-b7d925a5a345/occlusion_92b33516-ba42-40bc-80ec-77c62a130f93/14_w1_o1_mandibule_contact_occ_file_0.ply','CONTACT','PATIENT_b9d4138d-2c8c-492f-bf20-3aa5437834df_ACT_54e4e76a-88ec-47fe-8787-b7d925a5a345_SESS_92b33516-ba42-40bc-80ec-77c62a130f93_BOCO__CONTACT_','2021-12-10 13:54:05','2019-08-28 20:00:06','','2021-12-10 14:54:05','SYNCED','f542d9cf-fca7-4ca6-b5df-2410384eb5ce',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Pts de Contacts Mandibule Occlusion 1.14.1.1\",\"title\":\"Pts de Contacts Mandibule Occlusion CONTACT\"}'),(163,'f562c1d5-8b9d-40d0-82b2-c5ca1efb8991','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_7cd8be19-c5e8-48d9-8950-c7006af5dda6/16_w1_o1_mordu_posterieur_droit_snapshot_4.png','SNAPS','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_RISC_7cd8be19-c5e8-48d9-8950-c7006af5dda6_SNAPS_','2021-12-10 13:54:05','2019-10-09 20:02:37','','2021-12-10 14:54:05','SYNCED','76dda0ce-1254-4edd-bfae-486661f8e03d',4,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mordu posterieur droit 1.16.1.1.1\",\"title\":\"MORDU_POSTERIEUR_DROIT SNAPSHOT\"}'),(163,'f630803a-a4af-46bc-a9f8-ae749e594fb0','','STL','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_78f19188-19ad-480e-8d99-35699a9590fa_SESS_ea11a5f6-aafe-41d9-b61b-f8b13f045b1e_BOSC_6a1c5075-98b1-4211-9987-29ee0ba6ef5f_STL_','2020-12-16 20:58:19','2017-07-07 16:07:43','',NULL,'SYNCED','c2a12178-bc47-40b7-b1f8-49dad7689c38',2,'2019-08-20 15:37:52','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MANDIBULE 1.2.1.1\",\"modelMatrix\":\"0.111795,-0.970141,0.21524,0,0.993731,0.109141,-0.0242146,0,-4.20565e-10,0.216598,0.976261,0,-3.17449,5.61795,-23.9668,1\",\"title\":\"Mandibule STL\"}'),(163,'f8e4d624-10f1-4625-8c54-c1778040bd09','','STL','PATIENT_c3d48f98-f992-4b17-9ebd-a8f388b7e0ca_ACT_ce36d71d-debf-4f14-bbe8-30830b342bd3_SESS_2c9b2990-8860-4259-b919-67aa71e0b43f_BOSC_dc0831aa-93b4-4baf-aab0-a9b0ce8b83e5_STL_','2020-12-16 20:58:19','2017-09-23 10:33:37','',NULL,'SYNCED','f8e4d624-10f1-4625-8c54-c1778040bd09',0,'2017-09-23 10:33:37','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"modelMatrix\":\"0.0412372,-0.939612,0.339748,0,0.99915,0.0387799,-0.0140222,0,-1.02247e-10,0.340038,0.940412,0,0.899532,-2.83888,-9.85702,1\",\"title\":\"Mandibule STL\"}'),(163,'f95119ce-2fc9-4394-9721-e06fe8267fe4','','PLY','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_4829e17a-6262-4322-bd2d-12f3055adf7d_SESS_9f7449d6-1278-45d5-9492-02cd28be29ca_TOSC_19d904f0-1e7a-4097-baf5-3d03ff2ff6d0_PLY_','2021-12-16 21:26:07','2019-08-20 14:39:12','','2021-12-16 22:26:07','SYNCED','f95119ce-2fc9-4394-9721-e06fe8267fe4',0,'2021-12-16 22:26:07','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mandibule Occlusion 1.2.2.2\",\"modelMatrix\":\"0.849034,0.500992,-0.167774,0,-0.528338,0.805089,-0.269611,0,9.55235e-9,0.31755,0.948241,0,-7.14376,-34.7633,-17.1981,1\",\"title\":\"MAXILLAIRE PLY\"}'),(163,'f95a370d-8233-4ddc-9dca-4d2c6a111556','/var/.data/2022/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/409f26d0-a7e4-4813-8322-7342ba9597af/session_97e5ae19-9444-4dd2-9134-8f61d8d268df/occlusion_85186f51-753c-498e-8346-beea8a780c7b/scan_3c0180ee-a48e-4a57-83c5-b2c2144f5bc2/21_w2_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_97e5ae19-9444-4dd2-9134-8f61d8d268df_SESS_85186f51-753c-498e-8346-beea8a780c7b_BOSC_3c0180ee-a48e-4a57-83c5-b2c2144f5bc2_SNAPS_','2022-02-12 14:39:14','2022-02-12 15:39:04','21_w2_o1_mandibule_snapshot_0.png','2022-02-12 15:39:14','SYNCED','f95a370d-8233-4ddc-9dca-4d2c6a111556',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mandibule 1.21.2.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(163,'f9960be8-9d0d-41de-98ff-841336bef8ad','','ZIP','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_97e5ae19-9444-4dd2-9134-8f61d8d268df_SESS_85186f51-753c-498e-8346-beea8a780c7b_BOSC_00186753-75e1-4932-a7c7-83841ff310c4_ZIP_','2022-03-26 13:54:04','2022-02-12 15:12:05','','2022-03-26 14:54:04','SYNCED','f9960be8-9d0d-41de-98ff-841336bef8ad',0,'2022-03-26 14:54:04','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mandibule 1.21.2.1.1\",\"modelMatrix\":\"-0.996878,-0.0765124,0.0194791,0,0.078953,-0.966062,0.245947,0,1.464e-09,0.246717,0.969088,0,8.38746,-3.81013,-18.6749,1\",\"title\":\"Mandibule ZIP\"}'),(163,'fa4ef123-90ee-4188-9147-31311bc25127','','SNAPS','PATIENT_db79203f-7f7c-4e19-85d6-0069adcfbd11_ACT_78f19188-19ad-480e-8d99-35699a9590fa_SESS_ea11a5f6-aafe-41d9-b61b-f8b13f045b1e_TOSC_2f578874-fe02-494a-b5ac-1b5da453aed0_SNAPS_','2020-12-16 20:58:19','2017-07-07 15:14:53','',NULL,'SYNCED','fa4ef123-90ee-4188-9147-31311bc25127',0,'2017-07-07 15:14:53','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"title\":\"Maxillaire SNAPSHOT\"}'),(163,'fb3b6e24-9356-49d8-8960-dfd6ec1157f6','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/occlusion_d0e25f50-d624-467e-9ec5-62f18f66d406/scan_f1172a60-6504-4697-9acb-2793b430d7fe/16_w1_o1_mandibule_scan_file_0.ply','PLY','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_SESS_d0e25f50-d624-467e-9ec5-62f18f66d406_BOSC_f1172a60-6504-4697-9acb-2793b430d7fe_PLY_','2021-12-10 13:54:05','2019-10-09 19:36:04','','2021-12-10 14:54:05','SYNCED','fb3b6e24-9356-49d8-8960-dfd6ec1157f6',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"MANDIBULE 1.16.1.1.1\",\"modelMatrix\":\"0.981406,0.162503,-0.102148,0,-0.191942,0.830886,-0.52229,0,-1.24392e-8,0.532185,0.846628,0,0.422752,-14.4367,-22.0897,1\",\"title\":\"MANDIBULE PLY\"}'),(163,'fbab7ba4-a3c0-48ba-8117-a5a0a91d6163','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/9b491976-73ed-4d02-8711-4f4da13f42d9/session_bc55b8f5-e548-4538-975e-99c4c5e0df82/order_2365cac3-5051-47bd-98df-b6ee18e8b8a6/16_w1_inlay_core_prost_file_0.json','JSON','PATIENT_9b491976-73ed-4d02-8711-4f4da13f42d9_ACT_bc55b8f5-e548-4538-975e-99c4c5e0df82_PROST_2365cac3-5051-47bd-98df-b6ee18e8b8a6_JSON_','2019-12-15 21:03:21','2019-10-09 20:32:10','','2019-12-15 22:03:21','SYNCED','fbab7ba4-a3c0-48ba-8117-a5a0a91d6163',0,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"INLAY CORE 1.16.1 INLAY CORE\",\"title\":\"Inlay Core JSON\"}'),(163,'fcc7307b-f00b-4c18-8587-a659de2eb7ed','/var/.data/2022/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/409f26d0-a7e4-4813-8322-7342ba9597af/session_97e5ae19-9444-4dd2-9134-8f61d8d268df/occlusion_85186f51-753c-498e-8346-beea8a780c7b/scan_cd569007-a8b8-4363-acd4-5ff36a438dbd/21_w2_o1_maxillaire_scan_file_3.zip','ZIP','PATIENT_409f26d0-a7e4-4813-8322-7342ba9597af_ACT_97e5ae19-9444-4dd2-9134-8f61d8d268df_SESS_85186f51-753c-498e-8346-beea8a780c7b_TOSC_cd569007-a8b8-4363-acd4-5ff36a438dbd_ZIP_','2022-02-12 15:32:06','2022-02-12 16:32:04','21_w2_o1_maxillaire_scan_file_3.zip','2022-02-12 16:32:06','SYNCED','d003a690-dc4d-4562-9884-3f053f338768',3,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Maxillaire 1.21.2.1.6\",\"modelMatrix\":\"0.796425,0.467762,-0.383284,0,-0.604738,0.616031,-0.504776,0,8.49903e-09,0.633802,0.773495,0,-8.36884,-41.6361,-11.1844,1\",\"title\":\"Maxillaire ZIP\"}'),(163,'fd172ed2-6103-47d5-93d9-9e68c457e419','','SNAPS','PATIENT_c3d48f98-f992-4b17-9ebd-a8f388b7e0ca_ACT_ce36d71d-debf-4f14-bbe8-30830b342bd3_SESS_2c9b2990-8860-4259-b919-67aa71e0b43f_BOSC_6d4776fc-8fa0-4bf4-9766-84a771e3fa0a_SNAPS_','2020-12-16 20:58:19','2017-09-23 10:49:48','',NULL,'SYNCED','fd172ed2-6103-47d5-93d9-9e68c457e419',0,'2017-09-23 10:49:48','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"title\":\"Mandibule SNAPSHOT\"}'),(1,'fd8b4d1f-d4d7-4a12-bf74-74c5fe91a00b','/var/.data/2017/81719eb6-9836-45c5-a632-3098f463dde0/146dc0ed-e7c0-4b2a-9a6f-7fa2d76847ac/session_99140e2a-6c40-4cec-8b61-6b676b8308a5/occlusion_669bd839-b35f-4277-b25e-d33767724d18/scan_416100cd-bf35-4dbb-932a-8661f3ba4f6f/2_w1_mandibule_scan_file_0.stl','STL','PATIENT_146dc0ed-e7c0-4b2a-9a6f-7fa2d76847ac_ACT_99140e2a-6c40-4cec-8b61-6b676b8308a5_SESS_669bd839-b35f-4277-b25e-d33767724d18_BOSC_416100cd-bf35-4dbb-932a-8661f3ba4f6f_STL_','2020-12-16 20:58:19','2017-05-29 11:52:15','2_w1_mandibule_scan_file_0.stl',NULL,'SYNCED','fd8b4d1f-d4d7-4a12-bf74-74c5fe91a00b',0,NULL,'81719eb6-9836-45c5-a632-3098f463dde0',NULL,'{\"modelMatrix\":\"-0.950674,0.302379,-0.0691731,0,-0.31019,-0.926735,0.212002,0,-2.49248e-09,0.223002,0.974818,0,8.3365,-8.68327,-23.0169,1\",\"patientDisplayId\":\"8.2\"}'),(163,'ff71a3ea-b15b-4dc0-8b52-90b409e29344','/var/.data/2019/af4a9c1b-956e-4f70-b8f8-f40cadc590ff/b10e93aa-548c-427f-adcd-2dbc22bc6626/session_692fa6c8-2523-4d56-bebf-b736f05db142/occlusion_c2195287-5f39-4a66-93d5-5b83792fc9a8/scan_18cd0f29-a9fb-4dcd-91fe-8fb30a4d171a/17_w1_o1_maxillaire_scan_file_1.ply','PLY','PATIENT_b10e93aa-548c-427f-adcd-2dbc22bc6626_ACT_692fa6c8-2523-4d56-bebf-b736f05db142_SESS_c2195287-5f39-4a66-93d5-5b83792fc9a8_TOSC_18cd0f29-a9fb-4dcd-91fe-8fb30a4d171a_PLY_','2021-12-10 13:54:05','2019-10-14 12:57:56','17_w1_o1_maxillaire_scan_file_1.ply','2021-12-10 14:54:05','SYNCED','4e12bcab-9945-4ac0-80ca-4f849846a4bd',1,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','{\"displayTitle\":\"Mandibule Occlusion 1.17.1.1\",\"modelMatrix\":\"0.99984,-0.0172721,0.00470526,0,0.0179015,0.964685,-0.262799,0,-2.06254e-10,0.262841,0.964839,0,-16.503,-14.1962,-12.9193,1\",\"title\":\"MAXILLAIRE PLY\"}');
/*!40000 ALTER TABLE `CondorFile` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `CondorFile_BEFORE_DELETE` BEFORE DELETE ON `CondorFile` FOR EACH ROW BEGIN
  UPDATE Session SET mandibuleOcclusionPlyID = NULL
  WHERE ownerID = OLD.ownerID AND mandibuleOcclusionPlyID = OLD.id;

  UPDATE Session SET mandibuleOcclusionStlID = NULL
  WHERE ownerID = OLD.ownerID AND mandibuleOcclusionStlID = OLD.id;

  UPDATE Session SET maxillaireOcclusionPlyID = NULL
  WHERE ownerID = OLD.ownerID AND maxillaireOcclusionPlyID = OLD.id;

  UPDATE Session SET maxillaireOcclusionStlID = NULL
  WHERE ownerID = OLD.ownerID AND maxillaireOcclusionStlID = OLD.id;

  UPDATE Session SET mandibuleOcclusionPointContactID = NULL
  WHERE ownerID = OLD.ownerID AND mandibuleOcclusionPointContactID = OLD.id;

  UPDATE Session SET maxillaireOcclusionPointContactID = NULL
  WHERE ownerID = OLD.ownerID AND maxillaireOcclusionPointContactID = OLD.id;

  UPDATE Session SET matrixTransformationMandibuleID = NULL
  WHERE ownerID = OLD.ownerID AND matrixTransformationMandibuleID = OLD.id;

  UPDATE Session SET matrixTransformationMaxillaireID = NULL
  WHERE ownerID = OLD.ownerID AND matrixTransformationMaxillaireID = OLD.id;

  UPDATE Session SET snapshotID = NULL
  WHERE ownerID = OLD.ownerID AND snapshotID = OLD.id;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `Config`
--

DROP TABLE IF EXISTS `Config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Config` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `fullRetrieve` tinyint(1) DEFAULT '0',
  `syncEnabled` tinyint(1) DEFAULT '1',
  `showOcclusionScan` tinyint(1) DEFAULT '1',
  `showOpenStlWarning` tinyint(1) DEFAULT '1',
  `showMarginLinesWarning` tinyint(1) DEFAULT '1',
  `showDeleteConfirmation` tinyint(1) DEFAULT '1',
  `showSyncInfo` tinyint(1) DEFAULT '1',
  `downloadAtFullRetrieve` tinyint(1) DEFAULT '1',
  `lagSound` tinyint(1) DEFAULT '0',
  `lostSound` tinyint(1) DEFAULT '0',
  `emailNotifications` tinyint(1) DEFAULT '1',
  `logout` mediumint DEFAULT '10',
  `language` varchar(2) DEFAULT NULL,
  `flipMaxillaryH` tinyint(1) DEFAULT '0',
  `flipMaxillaryV` tinyint(1) DEFAULT '0',
  `flipMandibleH` tinyint(1) DEFAULT '0',
  `flipMandibleV` tinyint(1) DEFAULT '0',
  `showFlipPopupMaxillary` tinyint(1) DEFAULT '1',
  `showFlipPopupMandible` tinyint(1) DEFAULT '1',
  `enableUserSharing` tinyint(1) DEFAULT '1',
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `diagnosticMode` tinyint(1) DEFAULT '0',
  `repairMode` tinyint(1) DEFAULT '0',
  `lostTrackingRectangle` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Config_Professional` (`ownerID`),
  CONSTRAINT `fk_Config_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Config`
--

LOCK TABLES `Config` WRITE;
/*!40000 ALTER TABLE `Config` DISABLE KEYS */;
INSERT INTO `Config` VALUES (1,1,0,1,1,1,1,1,1,0,0,0,1,999,'fr',0,0,0,0,1,1,0,'1970-01-01 01:00:01','2020-01-24 09:21:55','2017-11-30 17:48:49',0,0,1),(2,1,0,1,1,1,1,1,1,0,0,0,1,10,'fr',0,0,0,0,1,1,0,'1970-01-01 01:00:01','2020-01-24 09:21:55','2017-11-30 17:48:49',0,0,1),(3,1,0,1,1,1,1,1,1,0,0,0,1,10,'fr',0,0,0,0,1,1,0,'2021-12-10 14:54:16','2021-12-10 13:54:16','2021-12-10 14:54:16',0,0,1),(5,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-07-02 11:04:44','2020-01-24 09:21:55','2019-07-02 11:04:44',0,0,1),(6,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-07-02 11:05:21','2020-01-24 09:21:55','2019-07-02 11:05:21',0,0,1),(7,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-07-02 11:06:14','2020-01-24 09:21:55','2019-07-02 11:06:14',0,0,1),(8,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-07-02 11:06:33','2020-01-24 09:21:55','2019-07-02 11:06:33',0,0,1),(9,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-07-02 11:07:02','2020-01-24 09:21:55','2019-07-02 11:07:02',0,0,1),(11,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-07-08 19:45:00',0,0,1),(16,1,0,1,1,1,1,1,1,1,0,0,1,10,NULL,0,0,0,0,1,1,0,'1970-01-01 01:00:01','2020-01-24 09:21:55','2017-11-30 17:48:49',0,0,1),(26,1,0,1,1,1,1,1,1,1,0,0,1,10,NULL,0,0,0,0,1,1,0,'1970-01-01 01:00:01','2020-01-24 09:21:55','2017-11-30 17:48:49',0,0,1),(27,1,0,1,1,1,1,1,1,1,0,0,1,10,NULL,0,0,0,0,1,1,0,'1970-01-01 01:00:01','2020-01-24 09:21:55','2017-11-30 17:48:49',0,0,1),(41,1,0,1,1,1,1,1,1,1,0,0,1,10,NULL,0,0,0,0,1,1,0,'1970-01-01 01:00:01','2020-01-24 09:21:55','2017-11-30 17:48:49',0,0,1),(46,1,0,1,1,1,1,1,1,1,0,0,1,10,NULL,0,0,0,0,1,1,0,'1970-01-01 01:00:01','2020-01-24 09:21:55','2017-11-30 17:48:49',0,0,1),(60,1,0,1,1,1,1,1,1,1,0,0,1,10,NULL,0,0,0,0,1,1,0,'1970-01-01 01:00:01','2020-01-24 09:21:55','2017-11-30 17:48:49',0,0,1),(61,1,0,1,1,1,1,1,1,1,0,0,1,10,NULL,0,0,0,0,1,1,0,'1970-01-01 01:00:01','2020-01-24 09:21:55','2017-11-30 17:48:49',0,0,1),(63,1,0,1,1,1,1,1,1,1,0,0,1,10,NULL,0,0,0,0,1,1,0,'1970-01-01 01:00:01','2020-01-24 09:21:55','2017-11-30 17:48:49',0,0,1),(64,1,0,1,1,1,1,1,1,1,0,0,1,10,NULL,0,0,0,0,1,1,0,'1970-01-01 01:00:01','2020-01-24 09:21:55','2017-11-30 17:48:49',0,0,1),(65,1,0,1,1,1,1,1,1,1,0,0,1,10,NULL,0,0,0,0,1,1,0,'1970-01-01 01:00:01','2020-01-24 09:21:55','2017-11-30 17:48:49',0,0,1),(89,1,0,1,1,1,1,1,1,1,0,0,1,10,NULL,0,0,0,0,1,1,0,'1970-01-01 01:00:01','2020-01-24 09:21:55','2017-11-30 17:48:49',0,0,1),(101,1,0,1,1,1,1,1,1,1,0,0,1,10,NULL,0,0,0,0,1,1,0,'1970-01-01 01:00:01','2020-01-24 09:21:55','2017-11-30 17:48:49',0,0,1),(106,1,0,1,1,1,1,1,1,1,0,0,1,10,NULL,0,0,0,0,1,1,0,'1970-01-01 01:00:01','2020-01-24 09:21:55','2017-11-30 17:48:49',0,0,1),(163,1,0,1,1,1,1,1,1,0,0,1,1,200,'fr',0,0,0,0,1,1,0,'2021-12-16 22:25:56','2021-12-16 21:25:56','2020-12-16 21:27:40',0,0,1),(176,1,0,1,1,1,1,1,1,1,0,0,1,10,NULL,0,0,0,0,1,1,0,'1970-01-01 01:00:01','2020-01-24 09:21:55','2017-11-30 17:48:49',0,0,1),(188,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-08-29 15:36:40','2020-01-24 09:21:55','2019-08-29 15:36:40',0,0,1),(253,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-09-17 15:34:27',0,0,1),(437,1,0,1,1,1,1,1,0,0,1,0,1,10,'fr',0,0,0,0,1,1,0,'2017-11-30 17:50:33','2020-01-24 09:21:55','2017-11-30 17:50:31',0,0,1),(438,1,0,1,1,1,1,1,1,1,0,0,1,10,NULL,0,0,0,0,1,1,0,'1970-01-01 01:00:01','2020-01-24 09:21:55','2017-11-30 17:48:49',0,0,1),(689,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2020-06-02 12:32:01','2020-06-02 10:32:01','2020-06-02 12:32:01',0,0,1);
/*!40000 ALTER TABLE `Config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Contact`
--

DROP TABLE IF EXISTS `Contact`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Contact` (
  `ownerID` mediumint unsigned NOT NULL DEFAULT '0',
  `id` char(36) NOT NULL,
  `comments` text,
  `professionalID` mediumint unsigned NOT NULL,
  `officeID` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `status` enum('invitationSent','invitationReceived','accepted','rejected') DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  UNIQUE KEY `unique_contact_pro` (`ownerID`,`professionalID`),
  KEY `fk_Contact_Professionnal` (`ownerID`),
  KEY `fk_Contact_RefersTo` (`professionalID`),
  KEY `fk_Contact_Office` (`officeID`,`ownerID`),
  CONSTRAINT `fk_Contact_Office` FOREIGN KEY (`officeID`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Contact_Professionnal` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Contact_RefersTo` FOREIGN KEY (`professionalID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Contact`
--

LOCK TABLES `Contact` WRITE;
/*!40000 ALTER TABLE `Contact` DISABLE KEYS */;
INSERT INTO `Contact` VALUES (3,'1c5b0ed4-2e36-4ac2-8563-ea991c9686f8','',9,NULL,NULL,'2020-01-24 14:39:36','2020-01-24 13:39:36','2019-07-02 17:21:50','accepted'),(3,'20cd7ccd-2468-44d0-9e65-98a1d9a0f104','',5,NULL,NULL,'2021-04-21 14:26:48','2021-04-21 12:26:48','2019-07-03 08:44:28','accepted'),(3,'20d898ea-0101-4bbc-8743-b468a3466c81','',11,NULL,NULL,'2020-12-09 11:10:32','2020-12-09 10:10:32','2019-07-03 10:12:52','accepted'),(163,'37ec353a-ee19-47ce-ad72-2a7c5c66a14a','',7,NULL,NULL,'2019-08-07 10:07:38','2019-08-07 08:07:38','2019-08-07 10:07:38','accepted'),(3,'3975fc98-88e3-4db7-b15b-6edc54696b45','',8,NULL,NULL,'2019-07-22 19:36:25','2019-07-22 17:36:25','2019-07-02 17:21:50','accepted'),(163,'3ad13f54-9058-4b76-958e-50420d1f8abf','',5,NULL,NULL,'2021-04-21 14:26:48','2021-04-21 12:26:48','2019-08-07 10:07:38','accepted'),(163,'3e9f50e8-a00b-469f-8c61-c82a162ada53','',689,NULL,NULL,'2021-12-16 22:25:56','2021-12-16 21:25:56','2021-12-16 22:25:56','accepted'),(163,'500b42bd-1bee-49d0-8bcf-cc15b7cf4ca0','',6,NULL,NULL,'2019-08-07 10:07:38','2019-08-07 08:07:38','2019-08-07 10:07:38','accepted'),(163,'59e7fd50-610d-49e6-9bdb-c4c01b5bb9ff','',9,NULL,NULL,'2020-01-24 14:39:36','2020-01-24 13:39:36','2019-08-07 10:07:38','accepted'),(3,'707d9cb0-34cd-43fd-afea-df98fcebd8f6','',689,NULL,NULL,'2021-05-14 13:25:21','2021-05-14 11:25:21','2021-05-14 13:25:21','accepted'),(163,'9460e697-c2bc-4e3d-9c13-755611df8866','',188,NULL,NULL,'2019-09-24 11:25:48','2019-09-24 09:25:48','2019-09-24 11:25:48','accepted'),(163,'9db09067-f531-42c2-aff3-2bbfe18ff4c2','',163,NULL,NULL,'2022-11-08 22:51:18','2022-11-08 21:51:18','2019-08-07 10:07:38','accepted'),(163,'a263761c-faa4-42dd-ad37-f456e07f0fd1','',8,NULL,NULL,'2019-08-07 10:07:38','2019-08-07 08:07:38','2019-08-07 10:07:38','accepted'),(3,'a76ed817-f9e0-4db2-9410-3ff4c9ddf54b','',6,NULL,NULL,'2019-07-26 06:43:50','2019-07-26 04:43:50','2019-07-08 15:21:46','accepted'),(3,'a8fec85a-ff77-4214-8958-ed05817ec540','',253,NULL,NULL,'2019-09-17 15:34:27','2019-09-17 13:34:27','2019-09-17 15:34:27','invitationSent'),(3,'be8b1ef2-5292-4f36-afb9-5e5f40cbf829','',7,NULL,NULL,'2019-09-09 13:51:13','2019-09-09 11:51:13','2019-09-09 13:51:13','accepted'),(3,'d025c59d-d6a3-4d8d-8728-e201f04b73c0','',3,NULL,NULL,'2021-12-10 14:54:13','2021-12-10 13:54:13','2019-07-01 14:13:31','accepted');
/*!40000 ALTER TABLE `Contact` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ContactNotification`
--

DROP TABLE IF EXISTS `ContactNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ContactNotification` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `contactID` char(36) DEFAULT NULL,
  `rescueDisplayName` varchar(50) DEFAULT NULL,
  `event` enum('received','received_to_accepted','received_to_rejected','sent_to_accepted','sent_to_rejected','activation_timeout') NOT NULL DEFAULT 'received',
  `unread` tinyint(1) NOT NULL DEFAULT '1',
  `createdAt` datetime NOT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_ContactNotification_Professional` (`ownerID`),
  KEY `fk_ContactNotification_Contact` (`contactID`,`ownerID`),
  CONSTRAINT `fk_ContactNotification_Contact` FOREIGN KEY (`contactID`, `ownerID`) REFERENCES `Contact` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_ContactNotification_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ContactNotification`
--

LOCK TABLES `ContactNotification` WRITE;
/*!40000 ALTER TABLE `ContactNotification` DISABLE KEYS */;
INSERT INTO `ContactNotification` VALUES (163,'1d0c8e17-f0b5-4035-ae19-2fbd5a9377c9','9460e697-c2bc-4e3d-9c13-755611df8866','Bienfait Laboratoire','sent_to_accepted',0,'2019-09-24 11:25:48',NULL,'2019-10-09 20:38:36','2019-10-09 20:38:36','2019-10-09 18:38:36'),(3,'5c86c168-8ea7-462d-8e7e-a4c81c2f231c','20d898ea-0101-4bbc-8743-b468a3466c81','IVVQ Condor','sent_to_accepted',0,'2019-07-03 10:12:52',NULL,'2019-07-03 10:13:07','2019-07-03 10:12:52','2019-07-03 08:13:07'),(3,'a4b04f6a-63f4-4c09-8575-ae559b9b293e','20d898ea-0101-4bbc-8743-b468a3466c81','IVVQ Condor','sent_to_rejected',0,'2019-07-03 10:07:11',NULL,'2019-07-03 10:07:22','2019-07-03 10:07:11','2019-07-03 08:07:22');
/*!40000 ALTER TABLE `ContactNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Credentials`
--

DROP TABLE IF EXISTS `Credentials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Credentials` (
  `id` char(36) NOT NULL DEFAULT '',
  `login` varchar(64) NOT NULL,
  `password` varchar(100) DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `un_Login` (`login`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Credentials`
--

LOCK TABLES `Credentials` WRITE;
/*!40000 ALTER TABLE `Credentials` DISABLE KEYS */;
INSERT INTO `Credentials` VALUES ('00000001-0000-0000-0000-000000000001','j.roc','d076c3c95ceef3ea6b6cd3bc74124031be8b221798c598b4abba48765e6da10b',NULL,'2022-11-08 21:42:29'),('00000002-0000-0000-0000-000000000001','t.villette','d076c3c95ceef3ea6b6cd3bc74124031be8b221798c598b4abba48765e6da10b',NULL,'2022-11-08 21:42:29'),('00000003-0000-0000-0000-000000000001','prod.c2w','29a2c02a04ebfb0a366bf2c7b19b97155e8436c3ccb378852224b528fe070d75',NULL,'2022-11-08 21:42:29'),('00000163-0000-0000-0000-000000000001','35753','b21abfbcce4f0aa26a8c0177dc730c44164b0807f2d04e0e8f0b8b46b0e11a37',NULL,'2022-11-08 21:46:26');
/*!40000 ALTER TABLE `Credentials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Discussion`
--

DROP TABLE IF EXISTS `Discussion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Discussion` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `selfImplied` tinyint(1) NOT NULL DEFAULT '0',
  `officeID` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Discussion_Professional` (`ownerID`),
  KEY `fk_Discussion_Office` (`officeID`,`ownerID`),
  CONSTRAINT `fk_Discussion_Office` FOREIGN KEY (`officeID`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Discussion_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Discussion`
--

LOCK TABLES `Discussion` WRITE;
/*!40000 ALTER TABLE `Discussion` DISABLE KEYS */;
INSERT INTO `Discussion` VALUES (163,'0581f1c1-e4ed-403d-93da-e75cb19e55cd',0,NULL,NULL,'2019-10-10 11:01:37','2019-10-10 09:01:37','2019-09-05 20:06:30'),(188,'0581f1c1-e4ed-403d-93da-e75cb19e55cd',0,NULL,NULL,NULL,'2019-09-05 18:06:30','2019-09-05 20:06:30'),(3,'605c208e-ad38-4268-a678-5f04c6f9007f',1,NULL,NULL,'2019-07-08 15:35:23','2019-07-08 13:35:23','2019-07-03 17:32:34'),(3,'88f8c70c-bd90-4787-bf46-0897cd968fca',0,NULL,NULL,'2019-07-09 14:59:22','2019-07-09 12:59:22','2019-07-08 15:35:54'),(11,'88f8c70c-bd90-4787-bf46-0897cd968fca',0,NULL,NULL,NULL,'2021-12-10 13:53:54','2021-12-10 14:53:54');
/*!40000 ALTER TABLE `Discussion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Licence`
--

DROP TABLE IF EXISTS `Licence`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Licence` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `reference` varchar(45) DEFAULT NULL,
  `installKey` varchar(45) DEFAULT NULL,
  `activationDate` datetime DEFAULT NULL,
  `professionalID` mediumint unsigned NOT NULL,
  `cameraReference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`,`professionalID`),
  KEY `fk_Licence_Professional` (`professionalID`),
  CONSTRAINT `fk_Licence_Professional` FOREIGN KEY (`professionalID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Licence`
--

LOCK TABLES `Licence` WRITE;
/*!40000 ALTER TABLE `Licence` DISABLE KEYS */;
/*!40000 ALTER TABLE `Licence` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `MessageStatus`
--

DROP TABLE IF EXISTS `MessageStatus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `MessageStatus` (
  `ownerID` mediumint unsigned NOT NULL,
  `sentMessageID` char(36) NOT NULL,
  `contactID` char(36) NOT NULL,
  `status` enum('undelivered','delivered','transmitted') NOT NULL DEFAULT 'undelivered',
  `bcc` tinyint(1) NOT NULL DEFAULT '0',
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`sentMessageID`,`contactID`),
  KEY `fk_MessageStatus_SentMessage` (`sentMessageID`,`ownerID`),
  KEY `fk_MessageStatus_Contact` (`contactID`,`ownerID`),
  CONSTRAINT `fk_MessageStatus_Contact` FOREIGN KEY (`contactID`, `ownerID`) REFERENCES `Contact` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_MessageStatus_SentMessage` FOREIGN KEY (`sentMessageID`, `ownerID`) REFERENCES `SentMessage` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `MessageStatus`
--

LOCK TABLES `MessageStatus` WRITE;
/*!40000 ALTER TABLE `MessageStatus` DISABLE KEYS */;
INSERT INTO `MessageStatus` VALUES (3,'148ab8de-7fa6-4388-9982-dd1dc536091f','20d898ea-0101-4bbc-8743-b468a3466c81','transmitted',0,'2019-07-08 17:44:58'),(3,'89776b11-d1ce-4070-89ab-77be21b5a063','d025c59d-d6a3-4d8d-8728-e201f04b73c0','transmitted',0,'2019-07-08 13:35:23'),(3,'ba6724d6-e1a0-440b-83fc-d6d4deea9e52','d025c59d-d6a3-4d8d-8728-e201f04b73c0','transmitted',0,'2019-07-03 07:33:20'),(163,'09eb132c-5b8e-4d92-9a94-a305e9f53d43','9460e697-c2bc-4e3d-9c13-755611df8866','transmitted',0,'2019-10-10 09:01:36'),(163,'0b66c392-8355-4d7d-b61e-3437910c35b6','9460e697-c2bc-4e3d-9c13-755611df8866','transmitted',0,'2019-10-10 09:01:36'),(163,'9e71a078-d9db-473d-a3ca-f2acffb3ee48','9460e697-c2bc-4e3d-9c13-755611df8866','transmitted',0,'2019-10-10 09:01:36'),(163,'bba92c3d-5b82-4abb-8e9e-3df91aea60e0','9460e697-c2bc-4e3d-9c13-755611df8866','transmitted',0,'2019-10-10 09:01:36');
/*!40000 ALTER TABLE `MessageStatus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Occlusion`
--

DROP TABLE IF EXISTS `Occlusion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Occlusion` (
  `ownerID` mediumint unsigned NOT NULL DEFAULT '0',
  `id` char(36) NOT NULL,
  `sessionID` char(36) DEFAULT NULL,
  `occlusionType` enum('UNKNOWN','HEMI_ARCADE_POSTERIEUR_DROIT','HEMI_ARCADE_POSTERIEUR_GAUCHE','HEMI_ARCADE_ANTERIEUR','ARCADE_COMPLETE_ANTERIEUR','ARCADE_COMPLETE') DEFAULT 'HEMI_ARCADE_POSTERIEUR_DROIT',
  `deletedAt` datetime DEFAULT NULL,
  `createdAt` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `topScanID` char(36) DEFAULT NULL,
  `bottomScanID` char(36) DEFAULT NULL,
  `anteriorBiteScanID` char(36) DEFAULT NULL,
  `rightBiteScanID` char(36) DEFAULT NULL,
  `leftBiteScanID` char(36) DEFAULT NULL,
  `snapshotID` char(36) DEFAULT NULL,
  `mandibuleOcclusionPlyID` char(36) DEFAULT NULL,
  `maxillaireOcclusionPlyID` char(36) DEFAULT NULL,
  `matrixTransformationMandibuleID` char(36) DEFAULT NULL,
  `matrixTransformationMaxillaireID` char(36) DEFAULT NULL,
  `globalDisplayID` mediumint unsigned DEFAULT NULL,
  `displayID` mediumint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Occlusion_Session` (`sessionID`,`ownerID`),
  KEY `fk_Occlusion_topScan` (`topScanID`,`ownerID`),
  KEY `fk_Occlusion_bottomScan` (`bottomScanID`,`ownerID`),
  KEY `fk_Occlusion_anteriorBiteScanID` (`anteriorBiteScanID`,`ownerID`),
  KEY `fk_Occlusion_rightBiteScanID` (`rightBiteScanID`,`ownerID`),
  KEY `fk_Occlusion_leftBiteScanID` (`leftBiteScanID`,`ownerID`),
  KEY `fk_Occlusion_CondorFile_snapshot` (`snapshotID`,`ownerID`),
  KEY `fk_Occlusion_CondorFile_mandibulePly` (`mandibuleOcclusionPlyID`,`ownerID`),
  KEY `fk_Occlusion_CondorFile_matrixTransformationMandibule` (`matrixTransformationMandibuleID`,`ownerID`),
  KEY `fk_Occlusion_CondorFile_maxillairePly` (`maxillaireOcclusionPlyID`,`ownerID`),
  KEY `fk_Occlusion_CondorFile_matrixTransformationMaxillaire` (`matrixTransformationMaxillaireID`,`ownerID`),
  CONSTRAINT `fk_Occlusion_anteriorBiteScanID` FOREIGN KEY (`anteriorBiteScanID`, `ownerID`) REFERENCES `Scan` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_bottomScan` FOREIGN KEY (`bottomScanID`, `ownerID`) REFERENCES `Scan` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_CondorFile_mandibulePly` FOREIGN KEY (`mandibuleOcclusionPlyID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_CondorFile_matrixTransformationMandibule` FOREIGN KEY (`matrixTransformationMandibuleID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_CondorFile_matrixTransformationMaxillaire` FOREIGN KEY (`matrixTransformationMaxillaireID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_CondorFile_maxillairePly` FOREIGN KEY (`maxillaireOcclusionPlyID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_CondorFile_snapshot` FOREIGN KEY (`snapshotID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_leftBiteScanID` FOREIGN KEY (`leftBiteScanID`, `ownerID`) REFERENCES `Scan` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_rightBiteScanID` FOREIGN KEY (`rightBiteScanID`, `ownerID`) REFERENCES `Scan` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_Session` FOREIGN KEY (`sessionID`, `ownerID`) REFERENCES `Session` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_topScan` FOREIGN KEY (`topScanID`, `ownerID`) REFERENCES `Scan` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Occlusion`
--

LOCK TABLES `Occlusion` WRITE;
/*!40000 ALTER TABLE `Occlusion` DISABLE KEYS */;
INSERT INTO `Occlusion` VALUES (163,'4d83f219-0b5d-4997-b640-b46da3aba91f','85186f51-753c-498e-8346-beea8a780c7b','HEMI_ARCADE_POSTERIEUR_DROIT',NULL,'2022-02-12 15:45:16','2022-02-12 15:45:23','2022-02-12 15:45:19','2022-02-12 14:45:23','3390e065-1f9a-438a-8024-2e1b03309150','3c0180ee-a48e-4a57-83c5-b2c2144f5bc2',NULL,'942c6d2f-f8fa-467f-8daf-5a19257fea61',NULL,'469b61a0-982e-4476-b1f0-695a8851103b','5a428bc0-3c04-4a62-be3e-9ba7fe2fb90e','39ab4c97-d8bf-4e73-9692-c019edc8dac8','9e62651d-f00e-4acc-8116-c99afaddc2b6','0fa448af-8873-4fdf-ad1a-9a236b78247f',1,1),(163,'92b33516-ba42-40bc-80ec-77cmigraoccl','92b33516-ba42-40bc-80ec-77c62a130f93','UNKNOWN',NULL,'2021-12-16 22:26:09','2021-09-20 18:22:59','2020-11-23 21:19:36','2021-09-20 16:22:59',NULL,NULL,NULL,NULL,NULL,'d5c7e23c-4a05-472b-bef5-950b733bfab5','78dbcda8-e113-49fc-942b-1ead943195ae','df8fd6d6-4a11-4757-b046-a7ffa9a05eab','b6c5bbd3-6387-4b17-84ec-098c0020c139','c450cf2f-ec8e-4cb7-aa0a-e3d9d5c0fd05',1,1);
/*!40000 ALTER TABLE `Occlusion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `OcclusionFile`
--

DROP TABLE IF EXISTS `OcclusionFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `OcclusionFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `fileID` char(36) NOT NULL,
  `occlusionID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `occlusionType` enum('OCCLUSION_RESULT','MANDIBULE_PLY','MAXILLAIRE_PLY','LEFT_BITE','RIGHT_BITE','ANTERIOR_BITE','SCREENSHOT','LIFI','MANDIBULE_MATRIX','MAXILLAIRE_MATRIX') DEFAULT 'OCCLUSION_RESULT',
  PRIMARY KEY (`fileID`,`occlusionID`,`ownerID`),
  KEY `fk_OcclusionFile_CondorFile` (`fileID`,`ownerID`),
  KEY `fk_OcclusionFile_Occlusion` (`occlusionID`,`ownerID`),
  CONSTRAINT `fk_OcclusionFile_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_OcclusionFile_Occlusion` FOREIGN KEY (`occlusionID`, `ownerID`) REFERENCES `Occlusion` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `OcclusionFile`
--

LOCK TABLES `OcclusionFile` WRITE;
/*!40000 ALTER TABLE `OcclusionFile` DISABLE KEYS */;
INSERT INTO `OcclusionFile` VALUES (163,'0fa448af-8873-4fdf-ad1a-9a236b78247f','4d83f219-0b5d-4997-b640-b46da3aba91f','2022-02-12 14:45:19','OCCLUSION_RESULT'),(163,'115eb8f9-db47-45d2-a963-651d349e8124','92b33516-ba42-40bc-80ec-77cmigraoccl','2020-12-16 20:58:20','OCCLUSION_RESULT'),(163,'39ab4c97-d8bf-4e73-9692-c019edc8dac8','4d83f219-0b5d-4997-b640-b46da3aba91f','2022-02-12 14:45:19','OCCLUSION_RESULT'),(163,'469b61a0-982e-4476-b1f0-695a8851103b','4d83f219-0b5d-4997-b640-b46da3aba91f','2022-02-12 14:45:19','OCCLUSION_RESULT'),(163,'5a428bc0-3c04-4a62-be3e-9ba7fe2fb90e','4d83f219-0b5d-4997-b640-b46da3aba91f','2022-02-12 14:45:19','OCCLUSION_RESULT'),(163,'71847718-31ab-4ff8-a7f2-31b3d3797945','92b33516-ba42-40bc-80ec-77cmigraoccl','2020-12-16 20:58:20','OCCLUSION_RESULT'),(163,'78dbcda8-e113-49fc-942b-1ead943195ae','92b33516-ba42-40bc-80ec-77cmigraoccl','2020-12-16 20:58:19','OCCLUSION_RESULT'),(163,'9e62651d-f00e-4acc-8116-c99afaddc2b6','4d83f219-0b5d-4997-b640-b46da3aba91f','2022-02-12 14:45:19','OCCLUSION_RESULT'),(163,'9ed7eab6-a6ff-4315-a0ab-49db0f33f29b','92b33516-ba42-40bc-80ec-77cmigraoccl','2020-12-16 20:58:20','OCCLUSION_RESULT'),(163,'b6c5bbd3-6387-4b17-84ec-098c0020c139','92b33516-ba42-40bc-80ec-77cmigraoccl','2020-12-16 20:58:19','OCCLUSION_RESULT'),(163,'bf8a5ead-e3ac-479b-a9f3-8fc17af8cb10','92b33516-ba42-40bc-80ec-77cmigraoccl','2020-12-16 20:58:20','OCCLUSION_RESULT'),(163,'c450cf2f-ec8e-4cb7-aa0a-e3d9d5c0fd05','92b33516-ba42-40bc-80ec-77cmigraoccl','2020-12-16 20:58:19','OCCLUSION_RESULT'),(163,'d5c7e23c-4a05-472b-bef5-950b733bfab5','92b33516-ba42-40bc-80ec-77cmigraoccl','2020-12-16 20:58:19','OCCLUSION_RESULT'),(163,'df8fd6d6-4a11-4757-b046-a7ffa9a05eab','92b33516-ba42-40bc-80ec-77cmigraoccl','2020-12-16 20:58:19','OCCLUSION_RESULT');
/*!40000 ALTER TABLE `OcclusionFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Office`
--

DROP TABLE IF EXISTS `Office`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Office` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `mainPhone` varchar(45) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `cityName` varchar(255) DEFAULT NULL,
  `cityZip` varchar(25) DEFAULT NULL,
  `address` text,
  `country` varchar(75) DEFAULT NULL,
  `reassignedTo` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Office_Professional_idx` (`ownerID`),
  KEY `fk_Office_Office_reassignedTo` (`reassignedTo`,`ownerID`),
  CONSTRAINT `fk_Office_Office_reassignedTo` FOREIGN KEY (`reassignedTo`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Office_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Office`
--

LOCK TABLES `Office` WRITE;
/*!40000 ALTER TABLE `Office` DISABLE KEYS */;
INSERT INTO `Office` VALUES (3,'07a4901a-a73e-414b-bafe-ff42d883049b','542138759','Condor','','Labège','31670','137 rue Garance','France',NULL,NULL,'2019-07-01 14:13:31','2019-07-01 12:13:31','2019-07-01 14:13:31'),(41,'0ca65de1-1ed7-4a7b-91c3-a2e354c46796','bob','Cabinet (default)',NULL,'lezignan',NULL,NULL,NULL,NULL,NULL,NULL,'2019-08-07 08:10:27','2016-08-19 11:59:03'),(7,'12faf4c9-95d6-4c4f-b641-481c29111d9a','0664864059','DENTAL CUB','','MERIGNAC','33700','10 av jean mazaryck,','France',NULL,NULL,'2019-07-09 11:35:13','2019-07-09 09:35:13','2019-07-09 11:35:13'),(101,'2f65679e-d346-464f-85cf-191e95c20d56','0388793083','Cabinet (default)',NULL,'Strasbourg',NULL,NULL,NULL,NULL,NULL,NULL,'2019-08-07 08:10:27','2016-09-05 18:35:33'),(188,'365b5047-4807-44e0-a5f4-5407f8d9b238','04 78 34 32 30','Cabinet (default)','','Francheville','','','France',NULL,NULL,'2019-09-03 15:14:06','2019-09-03 13:14:06','2019-08-29 15:36:40'),(16,'3f68ec2f-3132-4a90-a79a-7ded1f0346f1','0972550483','SAV','','LEZIGNAN','11200','38 rue du languedoc','France',NULL,NULL,NULL,'2019-08-07 08:10:27','2017-05-16 14:16:59'),(65,'43e5d07d-a2c4-4a12-a195-139c58f5d021','0381887844','Cabinet (default)',NULL,'BESANCON',NULL,NULL,NULL,NULL,NULL,NULL,'2019-08-07 08:10:27','2016-08-25 11:02:42'),(9,'544e3fb2-5e62-472f-b606-7185054c1396','0149698526','Laboratoire LDA','www.laboratoirelda.com','Villiers Sur Marne','94350','1 rue de la fraternité','France',NULL,NULL,'2019-07-02 11:36:03','2019-07-02 09:36:03','2019-07-02 11:36:03'),(60,'5a62ce4d-4b6f-4aa0-a940-fedf882986e2','0388386777','Cabinet (default)',NULL,'MOLSHEIM',NULL,NULL,NULL,NULL,NULL,NULL,'2019-08-07 08:10:27','2016-08-24 16:24:28'),(11,'5acfc32b-1bbc-4d32-a61c-a9970e819bf2','00000000000000000','Condor','','Labège','31670','137 rue Garance','France',NULL,NULL,'2019-07-03 10:05:55','2019-07-03 08:05:55','2019-07-03 10:05:55'),(1,'6947ca19-61ce-4695-b4db-fd46714e65e9','0468707457','PRODUCTION','www.condorscan.com','Fleury d\'Aude','11560','Chateau de Tarailhan','France',NULL,NULL,NULL,'2019-08-07 08:10:27','2017-05-26 09:51:49'),(163,'8ec1b161-3ff1-4576-ab53-1461e43533e6','478421239','Dr Meyrand Jerôme','','Lyon','69002','106 rue du Président Edouard Herriot','France',NULL,NULL,'2019-08-07 10:12:46','2019-08-07 08:12:46','2017-02-24 14:07:32'),(2,'99179cd3-423e-4ffd-a9ea-36a1358f1529','097255048','PRODUCTION',NULL,'Fleury','11560','Château de Tarailhan','France',NULL,NULL,NULL,'2019-08-07 08:10:27','2017-05-26 10:11:08'),(63,'99b06c46-e7c2-465b-bbbf-1dcd13467393','0388386777','Cabinet (default)',NULL,'MOLSHEIM',NULL,NULL,NULL,NULL,NULL,NULL,'2019-08-07 08:10:27','2016-08-25 09:41:49'),(106,'9b577d22-de54-4635-8475-0018fc4d1e8d','0153250381','Cabinet (default)',NULL,'PARIS',NULL,NULL,NULL,NULL,NULL,NULL,'2019-08-07 08:10:27','2016-09-07 12:25:18'),(6,'a1984274-1ad9-41d4-b536-d4407f8fca00','0491776127','Cabinet (default)','','Marseille','','','France',NULL,NULL,'2019-07-07 06:24:25','2019-07-07 04:24:25','2019-07-02 11:05:21'),(176,'a8da4030-0b6a-4d24-8136-bd6602a0e508','09 64 03 59 83','Cabinet (default)',NULL,'Landerneau',NULL,NULL,NULL,NULL,NULL,NULL,'2019-08-07 08:10:27','2016-09-26 09:40:31'),(689,'b9db0008-e73d-4e5a-ac76-2c93df3250ae','04 79 26 15 66','Cabinet (default)','','CHAMBERY','73000','1 Place de la Libération','France',NULL,NULL,'2020-11-03 08:32:27','2020-11-03 07:32:27','2020-11-03 08:32:27'),(61,'bc2904b4-8419-41b6-bd92-d62508cada63','0388386777','Cabinet (default)',NULL,'MOLSHEIM',NULL,NULL,NULL,NULL,NULL,NULL,'2019-08-07 08:10:27','2016-08-24 16:58:14'),(8,'c54ab53e-cc43-42dd-a0f6-824b6dc657ad','0664143389','LABEL DENT','','MERIGNAC','','10 AV JAN MASARYK','France',NULL,NULL,'2019-07-22 16:59:15','2019-07-22 14:59:15','2019-07-22 16:59:15'),(46,'c5a5ef93-2bba-4896-8ebb-387efc1c997a','0660112896','Cabinet (default)',NULL,'Aix en Provence',NULL,NULL,NULL,NULL,NULL,NULL,'2019-08-07 08:10:27','2016-08-22 14:27:49'),(89,'c9b8e71c-5b5e-49d2-a9ab-e87091c0ea1d','0153250381','Cabinet (default)',NULL,'PARIS',NULL,NULL,NULL,NULL,NULL,NULL,'2019-08-07 08:10:27','2016-09-01 14:52:06'),(438,'df89b789-3a48-4977-b7d0-629f62ab3938','478584366','Cabinet (default)',NULL,'lyon',NULL,NULL,'France',NULL,NULL,NULL,'2019-08-07 08:10:27','2017-02-24 14:09:13'),(253,'dfe3a485-25b7-48e2-b6a1-9e1854717624','','Cabinet (default)','','','','','',NULL,NULL,'2019-09-17 15:34:27','2019-09-17 13:34:27','2019-09-17 15:34:27'),(5,'e563f7db-c71c-416d-a74d-2b979f6eade2','0388334408','LABORATOIRE DENTAL BIOTECH','https://laboratoire-labeldent.fr/','WOLFISHEIM','67202','5 impasse Joffre','France',NULL,NULL,'2021-04-21 14:26:48','2021-04-21 12:26:48','2021-04-21 14:26:48'),(64,'fa58abd0-49bc-4c86-acbd-8900652f67a3','0805693705','Cabinet (default)',NULL,'MOLSHEIM',NULL,NULL,NULL,NULL,NULL,NULL,'2019-08-07 08:10:27','2016-08-25 10:15:28');
/*!40000 ALTER TABLE `Office` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `Office_BEFORE_DELETE` BEFORE DELETE ON `Office` FOR EACH ROW BEGIN		
  UPDATE Assistant SET officeID = NULL 
  WHERE ownerID = OLD.ownerID AND officeID = OLD.id;

  UPDATE Contact SET officeID = NULL 
  WHERE ownerID = OLD.ownerID AND officeID = OLD.id;

  UPDATE Discussion SET officeID = NULL 
  WHERE ownerID = OLD.ownerID AND officeID = OLD.id;

  UPDATE Patient SET officeID = NULL 
  WHERE ownerID = OLD.ownerID AND officeID = OLD.id;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `PersonInfo`
--

DROP TABLE IF EXISTS `PersonInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PersonInfo` (
  `id` char(36) NOT NULL COMMENT '(DC2Type:guid)',
  `firstName` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `sex` enum('M','F') DEFAULT NULL,
  `birthDate` date DEFAULT NULL,
  `salutation` varchar(45) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `picturePath` varchar(255) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PersonInfo`
--

LOCK TABLES `PersonInfo` WRITE;
/*!40000 ALTER TABLE `PersonInfo` DISABLE KEYS */;
INSERT INTO `PersonInfo` VALUES ('00000001-0000-0000-0000-000000000001','Tests','Production','j.roc@aabam.net',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-11-08 21:42:30'),('00000002-0000-0000-0000-000000000017','Tests','Production','t.villette@condorscan.com',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-11-08 21:42:30'),('00000003-0000-0000-0000-000000000001','c2w','prod-test','thomas.besson@condorscan.pro','',NULL,'','','',NULL,NULL,'2022-11-08 21:42:30'),('00000005-0000-0000-0000-000000000001','Dental Biotech Strasbourg','Laboratoire','cfao@dentalbiotech.fr','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000006-0000-0000-0000-000000000001','Gilles','Philip','laboratoirephilip@yahoo.fr','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000007-0000-0000-0000-000000000001','DENTAL CUB','LABORATOIRE','cfao@dentalcub.fr','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000008-0000-0000-0000-000000000001','LABEL DENT','LABORATOIRE','label.dent@orange.fr','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000009-0000-0000-0000-000000000001','Laboratoire','LDA','cfao@laboratoirelda.com','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000011-0000-0000-0000-000000000001','IVVQ','Condor','t.b@condorscan.pro','',NULL,'','','',NULL,NULL,'2022-11-08 21:42:30'),('00000016-0000-0000-0000-000000000012','Yves','VELUT','jonathanvelut@gmail.com',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-11-08 21:42:30'),('00000026-0000-0000-0000-000000000020','[]','[]','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-06-08 16:24:01'),('00000027-0000-0000-0000-000000000009','[]','[]','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-06-08 16:24:01'),('00000041-0000-0000-0000-000000000007','Contactor','Rocky','j.barsanti@aabam.net',NULL,'2002-08-17',NULL,NULL,NULL,NULL,NULL,'2022-11-08 21:42:30'),('00000046-0000-0000-0000-000000000018','[]','[]','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-06-08 16:24:01'),('00000060-0000-0000-0000-000000000006','flajolet','LABO','j.barsanti@aabam.net',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-11-08 21:42:30'),('00000061-0000-0000-0000-000000000010','[]','[]','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-06-08 16:24:01'),('00000063-0000-0000-0000-000000000008','[]','[]','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-06-08 16:24:01'),('00000064-0000-0000-0000-000000000002','Laboratoire','FLAJOLET','info@labo-flajolet.fr',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-11-08 21:42:30'),('00000065-0000-0000-0000-000000000003','Laboratoire','HOLTZ','holtzlaboratoire@hotmail.com',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-11-08 21:42:30'),('00000089-0000-0000-0000-000000000011','[]','[]','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-06-08 16:24:01'),('00000101-0000-0000-0000-000000000004','DIDIER','NONN','labodent.nonn@wanadoo.fr',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-11-08 21:42:30'),('00000106-0000-0000-0000-000000000005','PROTILAB','LABORATOIRE','csconnect@protilab.com',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-11-08 21:42:30'),('00000163-0000-0000-0000-000000000021','Jerôme','Meyrand','meyrand.jerome@wanadoo.fr','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000176-0000-0000-0000-000000000019','[]','[]','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-06-08 16:24:01'),('00000188-0000-0000-0000-000000000001','Bienfait','Laboratoire','labo.bienfait@gmail.com','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000253-0000-0000-0000-000000000001','','','test.application@condorscan.pro','',NULL,'','','',NULL,NULL,'2022-11-08 21:42:30'),('00000438-0000-0000-0000-000000000022','sep','Murat Canque','cfao-murat-canque@orange.fr',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-11-08 21:42:30'),('00000689-0000-0000-0000-000000000001','BY AXE ORTHO','SMILERS LAB','axe-ortho@outlook.fr','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19');
/*!40000 ALTER TABLE `PersonInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PhoneInfo`
--

DROP TABLE IF EXISTS `PhoneInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PhoneInfo` (
  `id` char(36) NOT NULL COMMENT '(DC2Type:guid)',
  `mainPhone` varchar(45) DEFAULT NULL,
  `cellular` varchar(45) DEFAULT NULL,
  `fax` varchar(45) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PhoneInfo`
--

LOCK TABLES `PhoneInfo` WRITE;
/*!40000 ALTER TABLE `PhoneInfo` DISABLE KEYS */;
INSERT INTO `PhoneInfo` VALUES ('00000001-0000-0000-0000-000000000001','0468707457',NULL,NULL,NULL,NULL,'2022-11-08 21:42:31'),('00000002-0000-0000-0000-000000000019','097255048',NULL,NULL,NULL,NULL,'2022-11-08 21:42:31'),('00000003-0000-0000-0000-000000000001','542138759','','',NULL,NULL,'2022-11-08 21:42:31'),('00000005-0000-0000-0000-000000000001','0388334408','','',NULL,NULL,'2022-03-31 17:40:19'),('00000006-0000-0000-0000-000000000001','0491776127','','',NULL,NULL,'2022-03-31 17:40:19'),('00000007-0000-0000-0000-000000000001','0664864059','','',NULL,NULL,'2022-03-31 17:40:19'),('00000008-0000-0000-0000-000000000001','0664143389','','',NULL,NULL,'2022-03-31 17:40:19'),('00000009-0000-0000-0000-000000000001','0149698526','','',NULL,NULL,'2022-03-31 17:40:19'),('00000011-0000-0000-0000-000000000001','00000000000000000','','',NULL,NULL,'2022-11-08 21:42:31'),('00000016-0000-0000-0000-000000000012','0972550483',NULL,NULL,NULL,NULL,'2022-11-08 21:42:31'),('00000026-0000-0000-0000-000000000022','038838677',NULL,NULL,NULL,NULL,'2022-11-08 21:42:31'),('00000027-0000-0000-0000-000000000009','0381887844',NULL,NULL,NULL,NULL,'2022-11-08 21:42:31'),('00000041-0000-0000-0000-000000000007','bobby',NULL,NULL,NULL,NULL,'2022-11-08 21:42:31'),('00000046-0000-0000-0000-000000000020','0660112896',NULL,NULL,NULL,NULL,'2022-11-08 21:42:31'),('00000060-0000-0000-0000-000000000006','0388386777',NULL,NULL,NULL,NULL,'2022-11-08 21:42:31'),('00000061-0000-0000-0000-000000000010','0388386777',NULL,NULL,NULL,NULL,'2022-11-08 21:42:31'),('00000063-0000-0000-0000-000000000008','0388386777',NULL,NULL,NULL,NULL,'2022-11-08 21:42:31'),('00000064-0000-0000-0000-000000000002','0388386777',NULL,NULL,NULL,NULL,'2022-11-08 21:42:31'),('00000065-0000-0000-0000-000000000003','0381887844','0622532967',NULL,NULL,NULL,'2022-11-08 21:42:31'),('00000089-0000-0000-0000-000000000011','0153250381',NULL,NULL,NULL,NULL,'2022-11-08 21:42:31'),('00000101-0000-0000-0000-000000000004','0388793083',NULL,NULL,NULL,NULL,'2022-11-08 21:42:31'),('00000106-0000-0000-0000-000000000005','0153250380',NULL,NULL,NULL,NULL,'2022-11-08 21:42:31'),('00000163-0000-0000-0000-000000000023','478421239','','',NULL,NULL,'2022-03-31 17:40:19'),('00000176-0000-0000-0000-000000000021','09 64 03 59 83',NULL,NULL,NULL,NULL,'2022-11-08 21:42:31'),('00000188-0000-0000-0000-000000000001','04 78 34 32 30','','',NULL,NULL,'2022-03-31 17:40:19'),('00000253-0000-0000-0000-000000000001','','','',NULL,NULL,'2022-11-08 21:42:31'),('00000438-0000-0000-0000-000000000024','478584366',NULL,NULL,NULL,NULL,'2022-11-08 21:42:31'),('00000689-0000-0000-0000-000000000001','04 79 26 15 66','','',NULL,NULL,'2022-03-31 17:40:19');
/*!40000 ALTER TABLE `PhoneInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Professional`
--

DROP TABLE IF EXISTS `Professional`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Professional` (
  `id` mediumint unsigned NOT NULL,
  `UUID` char(36) NOT NULL,
  `credentialsID` char(36) DEFAULT NULL,
  `comments` text,
  `personInfoID` char(36) DEFAULT NULL COMMENT '(DC2Type:guid)',
  `phoneInfoID` char(36) DEFAULT NULL COMMENT '(DC2Type:guid)',
  `addressInfoID` char(36) DEFAULT NULL COMMENT '(DC2Type:guid)',
  `configID` mediumint unsigned DEFAULT NULL,
  `syncInfoID` mediumint unsigned DEFAULT NULL,
  `surgeryName` varchar(255) DEFAULT NULL,
  `type` enum('Undefined','Prothesist','Dentist','Demo','Other') NOT NULL DEFAULT 'Undefined',
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastConnection` timestamp NULL DEFAULT NULL,
  `lastConnectionChecked` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `limitedContactID` char(36) DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `directoryVisible` tinyint(1) NOT NULL DEFAULT '1',
  `statusGalaxy` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_AB84A8523D139428` (`personInfoID`),
  UNIQUE KEY `UNIQ_AB84A852627FFEF6` (`phoneInfoID`),
  UNIQUE KEY `UNIQ_AB84A852A680FCCC` (`addressInfoID`),
  KEY `fk_Professional_Credentials` (`credentialsID`,`id`),
  KEY `fk_Professional_PersonInfo` (`personInfoID`,`id`),
  KEY `fk_Professional_PhoneInfo` (`phoneInfoID`,`id`),
  KEY `fk_Professional_AddressInfo` (`addressInfoID`,`id`),
  KEY `fk_Professional_Config` (`configID`,`id`),
  KEY `fk_Professional_SyncInfo` (`syncInfoID`,`id`),
  CONSTRAINT `fk_Professional_AddressInfo` FOREIGN KEY (`addressInfoID`) REFERENCES `AddressInfo` (`id`),
  CONSTRAINT `fk_Professional_Config` FOREIGN KEY (`configID`, `id`) REFERENCES `Config` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Professional_Credentials` FOREIGN KEY (`credentialsID`) REFERENCES `Credentials` (`id`),
  CONSTRAINT `fk_Professional_PersonInfo` FOREIGN KEY (`personInfoID`) REFERENCES `PersonInfo` (`id`),
  CONSTRAINT `fk_Professional_PhoneInfo` FOREIGN KEY (`phoneInfoID`) REFERENCES `PhoneInfo` (`id`),
  CONSTRAINT `fk_Professional_SyncInfo` FOREIGN KEY (`syncInfoID`, `id`) REFERENCES `SyncInfo` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Professional`
--

LOCK TABLES `Professional` WRITE;
/*!40000 ALTER TABLE `Professional` DISABLE KEYS */;
INSERT INTO `Professional` VALUES (1,'81719eb6-9836-45c5-a632-3098f463dde0','00000001-0000-0000-0000-000000000001',NULL,'00000001-0000-0000-0000-000000000001','00000001-0000-0000-0000-000000000001','00000001-0000-0000-0000-000000000001',1,1,NULL,'Other',NULL,NULL,'2017-05-29 09:49:20','2019-08-07 08:01:40','2022-11-08 21:42:32',NULL,'2017-11-30 17:48:49',1,0),(2,'7e7a8ee0-785b-40af-8351-37a30f9a949e','00000002-0000-0000-0000-000000000001',NULL,'00000002-0000-0000-0000-000000000017','00000002-0000-0000-0000-000000000019','00000002-0000-0000-0000-000000000017',1,1,NULL,'Other',NULL,NULL,'2017-05-26 08:06:41','2019-08-07 08:01:40','2022-11-08 21:42:32',NULL,'2017-11-30 17:48:49',1,0),(3,'7655b09e-027b-49c5-9b6c-832c6e41cee8','00000003-0000-0000-0000-000000000001','','00000003-0000-0000-0000-000000000001','00000003-0000-0000-0000-000000000001','00000003-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2021-12-10 14:54:22',NULL,'2021-12-10 13:53:52','2022-11-08 21:42:32',NULL,'2021-12-10 14:53:52',1,0),(5,'35997e6a-79be-404d-8b2c-46fa78f0f219',NULL,'','00000005-0000-0000-0000-000000000001','00000005-0000-0000-0000-000000000001','00000005-0000-0000-0000-000000000001',1,1,'','Other',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2020-02-21 15:56:57',1,0),(6,'372fe703-e954-4df2-a079-51315f137deb',NULL,'','00000006-0000-0000-0000-000000000001','00000006-0000-0000-0000-000000000001','00000006-0000-0000-0000-000000000001',1,1,'','Other',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2019-07-02 11:05:21',1,0),(7,'14d1a5e5-e2aa-42ab-9b88-6ff9da357d9b',NULL,'','00000007-0000-0000-0000-000000000001','00000007-0000-0000-0000-000000000001','00000007-0000-0000-0000-000000000001',1,1,'','Other',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2019-07-22 17:07:13',1,0),(8,'48539f38-473c-4be5-b635-3fb0fd42b27e',NULL,'','00000008-0000-0000-0000-000000000001','00000008-0000-0000-0000-000000000001','00000008-0000-0000-0000-000000000001',1,1,'','Other',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2019-07-22 19:36:25',1,0),(9,'1dab4f0e-ae37-4417-a649-d2a1322d368a',NULL,'','00000009-0000-0000-0000-000000000001','00000009-0000-0000-0000-000000000001','00000009-0000-0000-0000-000000000001',1,1,'','Other',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2019-07-11 10:05:09',1,0),(11,'9073bbcf-3ad7-4cbb-b538-10d515250299',NULL,'','00000011-0000-0000-0000-000000000001','00000011-0000-0000-0000-000000000001','00000011-0000-0000-0000-000000000001',1,1,'','Undefined',NULL,'2020-12-09 11:10:32',NULL,NULL,'2022-11-08 21:42:32',NULL,'2019-07-09 14:58:50',1,0),(16,'f0019226-6384-43c1-9791-0c19f71c920a',NULL,NULL,'00000016-0000-0000-0000-000000000012','00000016-0000-0000-0000-000000000012','00000016-0000-0000-0000-000000000012',1,1,NULL,'Dentist',NULL,NULL,NULL,'2019-08-07 08:01:40','2022-11-08 21:42:32',NULL,'2017-11-30 17:48:49',1,0),(26,'919a57ee-5d2a-4ca8-be3f-ffba24ba4459',NULL,NULL,'00000026-0000-0000-0000-000000000020','00000026-0000-0000-0000-000000000022','00000026-0000-0000-0000-000000000020',1,1,NULL,'Other',NULL,NULL,NULL,'2019-08-07 08:01:40','2022-11-08 21:42:32',NULL,'2017-11-30 17:48:49',1,0),(27,'bc403d9d-8075-4e25-bbb7-82c424753eb4',NULL,NULL,'00000027-0000-0000-0000-000000000009','00000027-0000-0000-0000-000000000009','00000027-0000-0000-0000-000000000009',1,1,NULL,'Other',NULL,NULL,NULL,'2019-08-07 08:01:40','2022-11-08 21:42:32',NULL,'2017-11-30 17:48:49',1,0),(41,'e0933b67-1ee9-4b58-a913-710a7b3ccc05',NULL,NULL,'00000041-0000-0000-0000-000000000007','00000041-0000-0000-0000-000000000007','00000041-0000-0000-0000-000000000007',1,1,NULL,'Other',NULL,NULL,NULL,'2019-08-07 08:01:40','2022-11-08 21:42:32',NULL,'2017-11-30 17:48:49',1,0),(46,'71b6ff75-01f6-4a10-91ae-903f5090b019',NULL,NULL,'00000046-0000-0000-0000-000000000018','00000046-0000-0000-0000-000000000020','00000046-0000-0000-0000-000000000018',1,1,NULL,'Other',NULL,NULL,NULL,'2019-08-07 08:01:40','2022-11-08 21:42:32',NULL,'2017-11-30 17:48:49',1,0),(60,'a7c35f61-2306-443e-b5f9-11cc70f49190',NULL,NULL,'00000060-0000-0000-0000-000000000006','00000060-0000-0000-0000-000000000006','00000060-0000-0000-0000-000000000006',1,1,NULL,'Other',NULL,NULL,NULL,'2019-08-07 08:01:40','2022-11-08 21:42:32',NULL,'2017-11-30 17:48:49',1,0),(61,'a147479f-235a-4bac-abde-8e73b245a775',NULL,NULL,'00000061-0000-0000-0000-000000000010','00000061-0000-0000-0000-000000000010','00000061-0000-0000-0000-000000000010',1,1,NULL,'Other',NULL,NULL,NULL,'2019-08-07 08:01:40','2022-11-08 21:42:32',NULL,'2017-11-30 17:48:49',1,0),(63,'09ba06af-f59a-4ab2-b1ae-86bca23140a1',NULL,NULL,'00000063-0000-0000-0000-000000000008','00000063-0000-0000-0000-000000000008','00000063-0000-0000-0000-000000000008',1,1,NULL,'Other',NULL,NULL,NULL,'2019-08-07 08:01:40','2022-11-08 21:42:32',NULL,'2017-11-30 17:48:49',1,0),(64,'331666b7-4fdb-4225-9e11-2c788d6309ee',NULL,NULL,'00000064-0000-0000-0000-000000000002','00000064-0000-0000-0000-000000000002','00000064-0000-0000-0000-000000000002',1,1,NULL,'Other',NULL,NULL,NULL,'2019-08-07 08:01:40','2022-11-08 21:42:32',NULL,'2017-11-30 17:48:49',1,0),(65,'9593c49b-e96d-420d-88dd-c62cd990dcc7',NULL,NULL,'00000065-0000-0000-0000-000000000003','00000065-0000-0000-0000-000000000003','00000065-0000-0000-0000-000000000003',1,1,NULL,'Other',NULL,NULL,NULL,'2019-08-07 08:01:40','2022-11-08 21:42:32',NULL,'2017-11-30 17:48:49',1,0),(89,'cce9f1f6-ba41-419a-a244-8be8e14da9ae',NULL,NULL,'00000089-0000-0000-0000-000000000011','00000089-0000-0000-0000-000000000011','00000089-0000-0000-0000-000000000011',1,1,NULL,'Other',NULL,NULL,NULL,'2019-08-07 08:01:40','2022-11-08 21:42:32',NULL,'2017-11-30 17:48:49',1,0),(101,'19d88398-2e5a-4755-be66-d765a9b7739f',NULL,NULL,'00000101-0000-0000-0000-000000000004','00000101-0000-0000-0000-000000000004','00000101-0000-0000-0000-000000000004',1,1,NULL,'Other',NULL,NULL,NULL,'2019-08-07 08:01:40','2022-11-08 21:42:32',NULL,'2017-11-30 17:48:49',1,0),(106,'bb4cc898-c1a2-409c-8a7c-23041b71a23a',NULL,NULL,'00000106-0000-0000-0000-000000000005','00000106-0000-0000-0000-000000000005','00000106-0000-0000-0000-000000000005',1,1,NULL,'Other',NULL,NULL,NULL,'2019-08-07 08:01:40','2022-11-08 21:42:32',NULL,'2017-11-30 17:48:49',1,0),(163,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','00000163-0000-0000-0000-000000000001','','00000163-0000-0000-0000-000000000021','00000163-0000-0000-0000-000000000023','00000163-0000-0000-0000-000000000021',1,1,'','Dentist',NULL,'2022-11-08 22:51:27',NULL,NULL,'2022-11-08 21:51:27',NULL,'2022-11-08 22:51:18',1,0),(176,'21ab12b0-fb2a-478c-be75-b0aa8ad26d21',NULL,NULL,'00000176-0000-0000-0000-000000000019','00000176-0000-0000-0000-000000000021','00000176-0000-0000-0000-000000000019',1,1,NULL,'Other',NULL,NULL,NULL,'2019-08-07 08:01:40','2022-11-08 21:42:32',NULL,'2017-11-30 17:48:49',1,0),(188,'ccac7772-c44c-4d76-85c1-7cbdb580f2b5',NULL,'','00000188-0000-0000-0000-000000000001','00000188-0000-0000-0000-000000000001','00000188-0000-0000-0000-000000000001',1,1,'','Undefined',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2019-08-29 15:36:40',1,0),(253,'249b9bde-20b6-45f6-8d20-2bc84bb6bffd',NULL,'','00000253-0000-0000-0000-000000000001','00000253-0000-0000-0000-000000000001','00000253-0000-0000-0000-000000000001',1,1,'','Undefined',NULL,'2020-06-01 19:47:46',NULL,NULL,'2022-11-08 21:42:32',NULL,'2019-09-17 15:34:27',1,0),(438,'2c3dfa46-fc5c-45aa-81e6-818a1dcb831e',NULL,NULL,'00000438-0000-0000-0000-000000000022','00000438-0000-0000-0000-000000000024','00000438-0000-0000-0000-000000000022',1,1,NULL,'Other',NULL,NULL,NULL,'2019-08-07 08:01:40','2022-11-08 21:42:32',NULL,'2017-11-30 17:48:49',1,0),(689,'464a0019-6c2e-403e-b0a5-f1b453741d76',NULL,'','00000689-0000-0000-0000-000000000001','00000689-0000-0000-0000-000000000001','00000689-0000-0000-0000-000000000001',1,1,'','Prothesist',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2020-11-03 08:29:54',1,0);
/*!40000 ALTER TABLE `Professional` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProfessionalEnvInfos`
--

DROP TABLE IF EXISTS `ProfessionalEnvInfos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProfessionalEnvInfos` (
  `id` char(36) NOT NULL COMMENT '(DC2Type:guid)',
  `professionalID` mediumint unsigned NOT NULL DEFAULT '0' COMMENT 'Le professionnel propriétaire des informations',
  `accessCode` varchar(45) DEFAULT NULL,
  `status` enum('created','confirmed','blocked') NOT NULL DEFAULT 'created',
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `preventDuplicateProfessionalEnvInfos` (`professionalID`),
  KEY `fk_ProfessionalEnvInfos_RefersTo_idx` (`professionalID`),
  CONSTRAINT `FK_A15010B8C37A46A` FOREIGN KEY (`professionalID`) REFERENCES `Professional` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProfessionalEnvInfos`
--

LOCK TABLES `ProfessionalEnvInfos` WRITE;
/*!40000 ALTER TABLE `ProfessionalEnvInfos` DISABLE KEYS */;
INSERT INTO `ProfessionalEnvInfos` VALUES ('0751ee10-9063-4a67-a39f-07c0759434a8',6,NULL,'confirmed','2022-11-08 21:42:32'),('1abecd26-b185-43b2-8467-102a3c42fcca',11,NULL,'confirmed','2022-11-08 21:42:32'),('1aeec034-703e-4598-930e-f09b624d19b1',27,'0b245dd6','created','2022-11-08 21:42:32'),('1e4b8dcb-6a1b-4aab-b613-6928cf75d1d3',163,NULL,'confirmed','2022-11-08 21:42:32'),('324be804-f135-412e-9314-fe012269b205',689,NULL,'confirmed','2022-11-08 21:42:32'),('35d280bc-e237-419b-8d51-e8e2e5c5c236',101,NULL,'confirmed','2022-11-08 21:42:32'),('3620384e-7724-4aa5-8307-aacbf08fb26a',64,NULL,'confirmed','2022-11-08 21:42:32'),('39ca72fc-9190-48d1-a86b-7edec5a45f9c',7,NULL,'confirmed','2022-11-08 21:42:32'),('3c319b87-5512-4c44-9cac-d6c432a178d8',65,NULL,'confirmed','2022-11-08 21:42:32'),('40a6daba-83b5-4ea0-8d9d-025880997bf9',1,NULL,'created','2022-11-08 21:42:32'),('455a3702-42fe-4cab-b3db-a9f088b8adc7',176,'981ffbe6','created','2022-11-08 21:42:32'),('5c3fa39a-1d49-4a5a-8ecc-a79aee2bb00a',26,'0a04642f','created','2022-11-08 21:42:32'),('6d0d0194-c0b8-4267-9a05-bee278421ca6',61,'52f9e7b1','created','2022-11-08 21:42:32'),('6f7a7431-f687-4855-87e8-741660d987fc',188,NULL,'confirmed','2022-11-08 21:42:32'),('6ffcb440-354f-47f9-a4bf-edc905054fbd',253,'e247de4d','created','2022-11-08 21:42:32'),('7b9eea96-2216-44c5-b033-eaac2f1d2b8b',106,NULL,'confirmed','2022-11-08 21:42:32'),('7da48aef-3dbe-4f9a-a0a9-93ec2a63182b',60,NULL,'confirmed','2022-11-08 21:42:32'),('8513b162-e7b5-4b6e-be82-726684db411a',9,NULL,'confirmed','2022-11-08 21:42:32'),('9c797b96-9485-4b35-a9d6-73d985b040e4',41,NULL,'confirmed','2022-11-08 21:42:32'),('b4a426ba-a3b6-470e-b2ec-be60ccc0c4a2',89,'312e702d','created','2022-11-08 21:42:32'),('b93609db-05a4-40ac-aa2a-fea4e84a8d89',8,NULL,'confirmed','2022-11-08 21:42:32'),('be041781-3b74-4d2f-8122-e2c4bb7a0117',5,NULL,'confirmed','2022-11-08 21:42:32'),('cb88263f-5ca1-469e-a633-5c6ab83083b3',16,NULL,'confirmed','2022-11-08 21:42:32'),('cee5269a-5450-4baf-a067-31c4fbe25622',438,NULL,'confirmed','2022-11-08 21:42:32'),('d83860c9-5b44-40ff-aa30-a5f82c12ea70',46,'6ab7d0f5','created','2022-11-08 21:42:32'),('e2bb8c9c-16da-4f8c-8f20-cc6eb99b3abd',63,'fda81a15','created','2022-11-08 21:42:32'),('e62cf138-0396-42e6-9e09-3e432c8f2404',2,NULL,'created','2022-11-08 21:42:32'),('ef350a31-6553-4896-b34d-dc0c1c48f941',3,NULL,'confirmed','2022-11-08 21:42:32');
/*!40000 ALTER TABLE `ProfessionalEnvInfos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProfessionalPatient`
--

DROP TABLE IF EXISTS `ProfessionalPatient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProfessionalPatient` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `ownerID` mediumint unsigned NOT NULL DEFAULT '0',
  `patientID` char(36) DEFAULT NULL,
  `officeID` char(36) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `enablePatientSharing` tinyint(1) DEFAULT '0',
  `pinned` tinyint(1) NOT NULL DEFAULT '0',
  `theme` enum('NONE','ADULT','BOY','GIRL','BABY') DEFAULT 'NONE',
  PRIMARY KEY (`id`),
  KEY `unique_Patient_Pro` (`ownerID`,`patientID`),
  CONSTRAINT `fk_Patient_Pro` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProfessionalPatient`
--

LOCK TABLES `ProfessionalPatient` WRITE;
/*!40000 ALTER TABLE `ProfessionalPatient` DISABLE KEYS */;
INSERT INTO `ProfessionalPatient` VALUES (1,163,'06f2a3bd-d1ba-4ac0-8808-522987236cbe','8ec1b161-3ff1-4576-ab53-1461e43533e6',0,0,'NONE'),(2,163,'1288ba7c-0bcf-4c6f-92e7-2873863af918','8ec1b161-3ff1-4576-ab53-1461e43533e6',0,0,'NONE'),(3,1,'146dc0ed-e7c0-4b2a-9a6f-7fa2d76847ac','6947ca19-61ce-4695-b4db-fd46714e65e9',0,0,'NONE'),(4,163,'266e265e-f763-4d62-adf2-f96067af6c06','8ec1b161-3ff1-4576-ab53-1461e43533e6',0,0,'NONE'),(5,163,'338e2117-81fc-470d-b92f-d61d9ea6739b','8ec1b161-3ff1-4576-ab53-1461e43533e6',0,0,'NONE'),(6,163,'3e81f0de-1357-45a1-a1d1-75e348b3b043','8ec1b161-3ff1-4576-ab53-1461e43533e6',0,0,'NONE'),(7,163,'484533a4-c958-4ae0-9685-23a2b9cda42c','8ec1b161-3ff1-4576-ab53-1461e43533e6',0,0,'NONE'),(8,163,'6d04f7f3-8727-469a-85cd-aa8e54904ed4','8ec1b161-3ff1-4576-ab53-1461e43533e6',0,0,'NONE'),(9,163,'709a6d6f-071f-48a8-ab41-6314d7801e27','8ec1b161-3ff1-4576-ab53-1461e43533e6',0,0,'NONE'),(10,163,'7ba9aec5-62a3-4219-a383-9d2bbd4147f6','8ec1b161-3ff1-4576-ab53-1461e43533e6',0,0,'NONE'),(11,163,'9b491976-73ed-4d02-8711-4f4da13f42d9','8ec1b161-3ff1-4576-ab53-1461e43533e6',0,0,'NONE'),(12,163,'b10e93aa-548c-427f-adcd-2dbc22bc6626','8ec1b161-3ff1-4576-ab53-1461e43533e6',0,0,'NONE'),(13,1,'b5a499d5-eb5f-4ed6-bc3f-bba7ca153d51','6947ca19-61ce-4695-b4db-fd46714e65e9',0,0,'NONE'),(14,163,'b9d4138d-2c8c-492f-bf20-3aa5437834df','8ec1b161-3ff1-4576-ab53-1461e43533e6',0,0,'NONE'),(15,163,'ba0bbbe7-1747-427a-836e-38eb56979058','8ec1b161-3ff1-4576-ab53-1461e43533e6',0,0,'NONE'),(16,163,'bdb79646-26a6-440d-867f-112e46644df6','8ec1b161-3ff1-4576-ab53-1461e43533e6',0,0,'NONE'),(17,163,'c3d48f98-f992-4b17-9ebd-a8f388b7e0ca','8ec1b161-3ff1-4576-ab53-1461e43533e6',0,0,'NONE'),(18,163,'c8f81196-baea-4404-bca2-c39acd92734c','8ec1b161-3ff1-4576-ab53-1461e43533e6',0,0,'NONE'),(19,163,'d6df50c1-2f0d-49c5-b022-5c2d80a9226b','8ec1b161-3ff1-4576-ab53-1461e43533e6',0,0,'NONE'),(20,163,'d9e77c5f-e140-4942-b81b-d2676fd3f9e9','8ec1b161-3ff1-4576-ab53-1461e43533e6',0,0,'NONE'),(21,163,'db79203f-7f7c-4e19-85d6-0069adcfbd11','8ec1b161-3ff1-4576-ab53-1461e43533e6',0,0,'NONE'),(22,163,'ead5b230-47e1-4b8d-8773-1a934e1ba033','8ec1b161-3ff1-4576-ab53-1461e43533e6',0,0,'NONE'),(23,163,'409f26d0-a7e4-4813-8322-7342ba9597af','8ec1b161-3ff1-4576-ab53-1461e43533e6',0,0,'NONE'),(24,3,'b8ad1160-ea98-421c-99a9-742ccb19a736','07a4901a-a73e-414b-bafe-ff42d883049b',0,0,'NONE'),(25,163,'faa00c69-6a8f-4658-9cfd-f65108440db8','8ec1b161-3ff1-4576-ab53-1461e43533e6',0,0,'NONE'),(26,163,'42283eca-193c-404a-97f6-56ef218de2b8','8ec1b161-3ff1-4576-ab53-1461e43533e6',0,0,'ADULT');
/*!40000 ALTER TABLE `ProfessionalPatient` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrder`
--

DROP TABLE IF EXISTS `ProstheticOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticOrder` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `currentDeliveryDate` datetime DEFAULT NULL,
  `previousDeliveryDate` datetime DEFAULT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `title` varchar(64) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `status` enum('not_sent','sent','date_validated','date_edited','validated','cancelled') NOT NULL DEFAULT 'sent',
  `unread` tinyint(1) DEFAULT '0',
  `createdAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `actID` char(36) NOT NULL,
  `localDisplayID` mediumint unsigned DEFAULT NULL,
  `globalDisplayID` mediumint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Order_SentMessage` (`ownerID`),
  KEY `idx_Order_Work` (`ownerID`),
  KEY `fk_ProstheticOrder_CondorFile_json` (`ownerID`),
  KEY `fk_ProstheticOrder_CondorFile_pdf` (`ownerID`),
  KEY `fk_Order_Act` (`actID`,`ownerID`),
  CONSTRAINT `fk_Order_Act` FOREIGN KEY (`actID`, `ownerID`) REFERENCES `Act` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrder`
--

LOCK TABLES `ProstheticOrder` WRITE;
/*!40000 ALTER TABLE `ProstheticOrder` DISABLE KEYS */;
INSERT INTO `ProstheticOrder` VALUES (163,'066d18a1-e56f-4695-a3bc-047a4064ad8e','2017-07-07 15:28:12',NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','COURONNE',NULL,'not_sent',0,'2019-08-07 10:10:27',NULL,'2021-12-10 11:26:59','2017-07-07 15:28:52','78f19188-19ad-480e-8d99-35699a9590fa',NULL,NULL),(163,'0f0915f0-d99f-401f-bc07-6de3f1346d65','2019-10-10 00:00:01',NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','COURONNE SUR IMPLANT',NULL,'date_validated',0,'2019-10-09 20:16:21','2019-10-10 11:05:41','2019-10-10 09:05:41','2019-10-10 11:05:41','bc55b8f5-e548-4538-975e-99c4c5e0df82',1,1),(163,'230857c5-798f-46ce-98ba-22728fcf0601','2019-08-20 15:27:19',NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','INLAY ONLAY',NULL,'not_sent',0,'2019-08-20 15:27:19',NULL,'2019-08-20 13:28:03','2019-08-20 15:28:02','4252a7af-d6d9-4447-b402-60820076dceb',1,1),(163,'2365cac3-5051-47bd-98df-b6ee18e8b8a6','2019-10-10 00:00:01',NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','INLAY CORE',NULL,'date_validated',0,'2019-10-09 20:16:35','2019-10-23 17:40:34','2019-10-23 15:40:34','2019-10-23 17:40:34','bc55b8f5-e548-4538-975e-99c4c5e0df82',2,1),(163,'2d03e092-9432-42e7-80e7-c4b571887fa6','2019-09-20 00:00:01',NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','INLAY ONLAY',NULL,'date_validated',0,'2019-09-19 11:15:04','2019-09-24 11:36:21','2019-09-24 09:36:21','2019-09-24 11:36:21','1ff39b04-4666-4c18-afaa-74990cd38521',1,1),(163,'2f000c1f-8ad6-4a2a-83d4-a09486ed49cc','2019-10-09 20:26:32',NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','COURONNE','2019-10-09 20:28:54','not_sent',0,'2019-10-09 20:26:32',NULL,'2019-10-09 18:28:54','2019-10-09 20:26:32','bc55b8f5-e548-4538-975e-99c4c5e0df82',3,1),(163,'488bcc99-0ec8-4bbd-8c96-416ae4683e43','2020-02-17 12:05:47',NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','COURONNE',NULL,'not_sent',0,'2020-02-17 12:05:47',NULL,'2020-02-17 11:05:47','2020-02-17 12:05:47','1a37c2d2-e6a1-4863-8afb-27944d3a7e33',1,1),(163,'816f04b9-978f-4f25-b999-b4179ef17116','2019-09-06 00:00:01',NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff','INLAY ONLAY',NULL,'date_validated',0,'2019-08-28 20:07:01','2019-09-26 11:13:39','2019-09-26 09:13:39','2019-09-26 11:13:39','54e4e76a-88ec-47fe-8787-b7d925a5a345',1,1);
/*!40000 ALTER TABLE `ProstheticOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrderFile`
--

DROP TABLE IF EXISTS `ProstheticOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticOrderFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `orderID` char(36) NOT NULL,
  `fileID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`orderID`,`fileID`),
  KEY `fk_ProstheticOrderFile_ProstheticOrder` (`orderID`,`ownerID`),
  KEY `fk_ProstheticOrderFile_CondorFile` (`fileID`,`ownerID`),
  CONSTRAINT `fk_ProstheticOrderFile_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_ProstheticOrderFile_ProstheticOrder` FOREIGN KEY (`orderID`, `ownerID`) REFERENCES `ProstheticOrder` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrderFile`
--

LOCK TABLES `ProstheticOrderFile` WRITE;
/*!40000 ALTER TABLE `ProstheticOrderFile` DISABLE KEYS */;
INSERT INTO `ProstheticOrderFile` VALUES (163,'0f0915f0-d99f-401f-bc07-6de3f1346d65','0aa71ebb-4833-4dfd-bf99-5158c2d6b79f','2019-10-09 18:32:18'),(163,'0f0915f0-d99f-401f-bc07-6de3f1346d65','49fa018c-a1f8-41c3-89ca-42d90f70b465','2019-10-09 18:32:18'),(163,'0f0915f0-d99f-401f-bc07-6de3f1346d65','4b5f064c-9285-4119-bc00-8e7a6dd729b0','2019-10-09 18:32:18'),(163,'0f0915f0-d99f-401f-bc07-6de3f1346d65','56264e08-ee06-4c6f-8e9b-6d38cc8530b1','2019-10-09 18:32:18'),(163,'0f0915f0-d99f-401f-bc07-6de3f1346d65','5c5378c6-f77b-4b5d-a2dc-e7d066bcf273','2019-10-09 18:32:18'),(163,'0f0915f0-d99f-401f-bc07-6de3f1346d65','67349e8c-f1af-4275-9741-d8f70cb19787','2019-10-09 18:32:18'),(163,'0f0915f0-d99f-401f-bc07-6de3f1346d65','67f86da1-b93d-49a5-b128-ce4b4dbba427','2019-10-09 18:32:18'),(163,'0f0915f0-d99f-401f-bc07-6de3f1346d65','762a3b6d-dc65-4c0f-b252-3f012d6880ed','2019-10-09 18:32:18'),(163,'0f0915f0-d99f-401f-bc07-6de3f1346d65','7a9749e4-92f4-4da4-8285-8bfcc18562dc','2019-10-09 18:32:18'),(163,'0f0915f0-d99f-401f-bc07-6de3f1346d65','9273720b-56c3-415c-b28e-0440361cecc8','2019-10-09 18:32:18'),(163,'0f0915f0-d99f-401f-bc07-6de3f1346d65','a4fe9afa-c87f-4755-8881-cbd8df0e865e','2019-10-09 18:32:18'),(163,'0f0915f0-d99f-401f-bc07-6de3f1346d65','b6865a4a-2933-4ddf-a792-1aa292359fd7','2019-10-09 18:32:18'),(163,'0f0915f0-d99f-401f-bc07-6de3f1346d65','bcc65d9e-d6ca-49f2-aa48-b84ef943291b','2019-10-09 18:32:18'),(163,'0f0915f0-d99f-401f-bc07-6de3f1346d65','d303cf66-8219-41f9-ac8a-a9a6d81f0e51','2019-10-09 18:32:18'),(163,'0f0915f0-d99f-401f-bc07-6de3f1346d65','e0be079b-af79-44e4-9464-46d48246ee2e','2019-10-09 18:32:18'),(163,'0f0915f0-d99f-401f-bc07-6de3f1346d65','e8dadd53-f8a7-4cee-9109-41034eca20e6','2019-10-09 18:32:18'),(163,'0f0915f0-d99f-401f-bc07-6de3f1346d65','f562c1d5-8b9d-40d0-82b2-c5ca1efb8991','2019-10-09 18:32:18'),(163,'2365cac3-5051-47bd-98df-b6ee18e8b8a6','0aa71ebb-4833-4dfd-bf99-5158c2d6b79f','2019-10-09 18:32:10'),(163,'2365cac3-5051-47bd-98df-b6ee18e8b8a6','2b2da34e-40de-4eec-97e1-03189a8ce722','2019-10-09 18:32:10'),(163,'2365cac3-5051-47bd-98df-b6ee18e8b8a6','49fa018c-a1f8-41c3-89ca-42d90f70b465','2019-10-09 18:32:10'),(163,'2365cac3-5051-47bd-98df-b6ee18e8b8a6','4b5f064c-9285-4119-bc00-8e7a6dd729b0','2019-10-09 18:32:10'),(163,'2365cac3-5051-47bd-98df-b6ee18e8b8a6','56264e08-ee06-4c6f-8e9b-6d38cc8530b1','2019-10-09 18:32:10'),(163,'2365cac3-5051-47bd-98df-b6ee18e8b8a6','5c5378c6-f77b-4b5d-a2dc-e7d066bcf273','2019-10-09 18:32:10'),(163,'2365cac3-5051-47bd-98df-b6ee18e8b8a6','67349e8c-f1af-4275-9741-d8f70cb19787','2019-10-09 18:32:10'),(163,'2365cac3-5051-47bd-98df-b6ee18e8b8a6','762a3b6d-dc65-4c0f-b252-3f012d6880ed','2019-10-09 18:32:10'),(163,'2365cac3-5051-47bd-98df-b6ee18e8b8a6','7a9749e4-92f4-4da4-8285-8bfcc18562dc','2019-10-09 18:32:10'),(163,'2365cac3-5051-47bd-98df-b6ee18e8b8a6','9273720b-56c3-415c-b28e-0440361cecc8','2019-10-09 18:32:10'),(163,'2365cac3-5051-47bd-98df-b6ee18e8b8a6','a4fe9afa-c87f-4755-8881-cbd8df0e865e','2019-10-09 18:32:10'),(163,'2365cac3-5051-47bd-98df-b6ee18e8b8a6','b6865a4a-2933-4ddf-a792-1aa292359fd7','2019-10-09 18:32:10'),(163,'2365cac3-5051-47bd-98df-b6ee18e8b8a6','bcc65d9e-d6ca-49f2-aa48-b84ef943291b','2019-10-09 18:32:10'),(163,'2365cac3-5051-47bd-98df-b6ee18e8b8a6','d303cf66-8219-41f9-ac8a-a9a6d81f0e51','2019-10-09 18:32:10'),(163,'2365cac3-5051-47bd-98df-b6ee18e8b8a6','e8dadd53-f8a7-4cee-9109-41034eca20e6','2019-10-09 18:32:10'),(163,'2365cac3-5051-47bd-98df-b6ee18e8b8a6','f562c1d5-8b9d-40d0-82b2-c5ca1efb8991','2019-10-09 18:32:10'),(163,'2365cac3-5051-47bd-98df-b6ee18e8b8a6','fbab7ba4-a3c0-48ba-8117-a5a0a91d6163','2019-10-09 18:32:10'),(163,'2d03e092-9432-42e7-80e7-c4b571887fa6','0b57b957-257f-4fef-8207-bfd0571938b5','2019-09-19 09:18:21'),(163,'2d03e092-9432-42e7-80e7-c4b571887fa6','0d5f673d-1e06-4c82-b781-3166313d5ca7','2019-09-19 09:18:21'),(163,'2d03e092-9432-42e7-80e7-c4b571887fa6','29b0101d-6385-4e7a-9086-253fdc351d02','2019-09-19 09:18:21'),(163,'2d03e092-9432-42e7-80e7-c4b571887fa6','4d7867b4-9f52-49a2-88c8-83c3d4865095','2019-09-19 09:18:21'),(163,'2d03e092-9432-42e7-80e7-c4b571887fa6','50fdd65d-7e14-48e2-a3ca-6a69a2a4ec71','2019-09-19 09:18:21'),(163,'2d03e092-9432-42e7-80e7-c4b571887fa6','64286f64-d288-471b-8ab7-0fa381df35a6','2019-09-19 09:18:21'),(163,'2d03e092-9432-42e7-80e7-c4b571887fa6','a875f57f-7f35-4ffb-ac85-18b73e5cda0e','2019-09-19 09:18:21'),(163,'2d03e092-9432-42e7-80e7-c4b571887fa6','af3275fd-de94-4563-a07f-efe7b8ecf1f4','2019-09-19 09:18:21'),(163,'2d03e092-9432-42e7-80e7-c4b571887fa6','c8c830ba-cf40-40b0-b6b7-7194b746c2a2','2019-09-19 09:18:21'),(163,'2d03e092-9432-42e7-80e7-c4b571887fa6','e34bd481-90b0-47c9-9f3b-8114fff93036','2019-09-19 09:18:21'),(163,'2d03e092-9432-42e7-80e7-c4b571887fa6','e718ad91-2aab-4430-9ea9-5014c920299b','2019-09-19 09:18:21'),(163,'816f04b9-978f-4f25-b999-b4179ef17116','0739d8ee-2b14-4370-a430-8495fec0feec','2019-09-05 18:06:30'),(163,'816f04b9-978f-4f25-b999-b4179ef17116','1d94168f-dde9-4b67-80b3-e774e27517e6','2019-09-05 18:06:30'),(163,'816f04b9-978f-4f25-b999-b4179ef17116','4ac1bde3-ded4-41d1-83a4-46e496e8b5cd','2019-09-05 18:06:30'),(163,'816f04b9-978f-4f25-b999-b4179ef17116','6c1402f2-cd34-461f-8bcd-719448b12370','2019-09-05 18:06:30'),(163,'816f04b9-978f-4f25-b999-b4179ef17116','78dbcda8-e113-49fc-942b-1ead943195ae','2019-09-05 18:06:30'),(163,'816f04b9-978f-4f25-b999-b4179ef17116','7d9bfb0d-1cae-4e52-947a-72ab21c7f74c','2019-09-05 18:06:30'),(163,'816f04b9-978f-4f25-b999-b4179ef17116','87144a98-d15e-4dc3-bcb4-339cd6015590','2019-09-05 18:06:30'),(163,'816f04b9-978f-4f25-b999-b4179ef17116','9a1535dd-b5a7-41f8-9557-b243a7f416e4','2019-09-05 18:06:30'),(163,'816f04b9-978f-4f25-b999-b4179ef17116','a26c62ea-7c34-452d-88cf-9d144550ec86','2019-09-05 18:06:30'),(163,'816f04b9-978f-4f25-b999-b4179ef17116','a9a24eec-ed31-4ca3-a322-e55a79a15bdc','2019-09-05 18:06:30'),(163,'816f04b9-978f-4f25-b999-b4179ef17116','b6c5bbd3-6387-4b17-84ec-098c0020c139','2019-09-05 18:06:30'),(163,'816f04b9-978f-4f25-b999-b4179ef17116','bd9bacc0-d27a-486b-bc53-bd6172d5cd80','2019-09-05 18:06:30'),(163,'816f04b9-978f-4f25-b999-b4179ef17116','be2ca89b-1f70-4164-b966-0516457b5506','2019-09-05 18:06:30'),(163,'816f04b9-978f-4f25-b999-b4179ef17116','c450cf2f-ec8e-4cb7-aa0a-e3d9d5c0fd05','2019-09-05 18:06:30'),(163,'816f04b9-978f-4f25-b999-b4179ef17116','d5c7e23c-4a05-472b-bef5-950b733bfab5','2019-09-05 18:06:30'),(163,'816f04b9-978f-4f25-b999-b4179ef17116','dd651c32-5d3b-4598-bb9f-7e028160d5fd','2019-09-05 18:06:30'),(163,'816f04b9-978f-4f25-b999-b4179ef17116','df8fd6d6-4a11-4757-b046-a7ffa9a05eab','2019-09-05 18:06:30');
/*!40000 ALTER TABLE `ProstheticOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrderRecipient`
--

DROP TABLE IF EXISTS `ProstheticOrderRecipient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticOrderRecipient` (
  `ownerID` mediumint unsigned NOT NULL,
  `orderID` char(36) NOT NULL,
  `recipientID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`orderID`,`recipientID`),
  KEY `fk_ProstheticOrderRecipient_ProstheticOrder` (`orderID`,`ownerID`),
  KEY `fk_ProstheticOrderRecipient_Contact` (`recipientID`,`ownerID`),
  CONSTRAINT `fk_ProstheticOrderRecipient_Contact` FOREIGN KEY (`recipientID`, `ownerID`) REFERENCES `Contact` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_ProstheticOrderRecipient_ProstheticOrder` FOREIGN KEY (`orderID`, `ownerID`) REFERENCES `ProstheticOrder` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrderRecipient`
--

LOCK TABLES `ProstheticOrderRecipient` WRITE;
/*!40000 ALTER TABLE `ProstheticOrderRecipient` DISABLE KEYS */;
INSERT INTO `ProstheticOrderRecipient` VALUES (163,'0f0915f0-d99f-401f-bc07-6de3f1346d65','9460e697-c2bc-4e3d-9c13-755611df8866','2019-10-09 18:32:18'),(163,'2365cac3-5051-47bd-98df-b6ee18e8b8a6','9460e697-c2bc-4e3d-9c13-755611df8866','2019-10-09 18:32:10'),(163,'2d03e092-9432-42e7-80e7-c4b571887fa6','9460e697-c2bc-4e3d-9c13-755611df8866','2019-09-19 09:18:21'),(163,'816f04b9-978f-4f25-b999-b4179ef17116','9460e697-c2bc-4e3d-9c13-755611df8866','2019-09-05 18:06:30');
/*!40000 ALTER TABLE `ProstheticOrderRecipient` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticSheet`
--

DROP TABLE IF EXISTS `ProstheticSheet`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticSheet` (
  `id` char(36) NOT NULL,
  `ownerID` mediumint unsigned NOT NULL,
  `orderID` char(36) NOT NULL,
  `json` text NOT NULL,
  `pdfFileID` char(36) DEFAULT NULL,
  `dateCreated` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_ProstheticSheet_ProstheticOrder` (`orderID`),
  KEY `fk_ProstheticSheet_CondorFile` (`pdfFileID`),
  CONSTRAINT `fk_ProstheticSheet_CondorFile` FOREIGN KEY (`pdfFileID`) REFERENCES `CondorFile` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_ProstheticSheet_ProstheticOrder` FOREIGN KEY (`orderID`) REFERENCES `ProstheticOrder` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticSheet`
--

LOCK TABLES `ProstheticSheet` WRITE;
/*!40000 ALTER TABLE `ProstheticSheet` DISABLE KEYS */;
INSERT INTO `ProstheticSheet` VALUES ('066d18a1-e56f-4695-a3bc-047a4064ad8e',163,'066d18a1-e56f-4695-a3bc-047a4064ad8e','{\"sheetTitle\":\"COURONNE\",\"comment\":\"\",\"generalTintElement\":\"\",\"generalTintSupport\":\"\",\"prostheticContactPoint\":2,\"prostheticMaterial\":13,\"prostheticModel\":0,\"prostheticStep\":0,\"selectedTeeth\":[16],\"subType\":0,\"type\":0}',NULL,'2019-08-07 10:10:27',NULL,NULL,'2017-07-07 15:28:52','2021-12-10 11:26:59'),('0f0915f0-d99f-401f-bc07-6de3f1346d65',163,'0f0915f0-d99f-401f-bc07-6de3f1346d65','{\"comment\":\"\",\"language\":\"fr_FR\",\"sheetTitle\":\"AUTRE FICHE DE PROTHESE\",\"type\":12}','67f86da1-b93d-49a5-b128-ce4b4dbba427','2019-10-09 20:16:21',NULL,'2021-12-16 22:26:07','2019-10-10 11:05:41','2021-12-16 21:26:07'),('230857c5-798f-46ce-98ba-22728fcf0601',163,'230857c5-798f-46ce-98ba-22728fcf0601','{\"sheetTitle\":\"INLAY ONLAY\",\"comment\":\"\",\"generalTintElement\":\"\",\"generalTintSupport\":\"A35\",\"language\":\"fr_FR\",\"prostheticContactPoint\":5,\"prostheticMaterial\":13,\"quality\":2,\"selectedTeeth\":[36],\"subType\":0,\"type\":2}',NULL,'2019-08-20 15:27:19',NULL,NULL,'2019-08-20 15:28:02','2019-08-20 13:28:03'),('2365cac3-5051-47bd-98df-b6ee18e8b8a6',163,'2365cac3-5051-47bd-98df-b6ee18e8b8a6','{\"comment\":\"\",\"language\":\"fr_FR\",\"sheetTitle\":\"AUTRE FICHE DE PROTHESE\",\"type\":12}','2b2da34e-40de-4eec-97e1-03189a8ce722','2019-10-09 20:16:35',NULL,'2021-12-16 22:26:07','2019-10-23 17:40:34','2021-12-16 21:26:07'),('2d03e092-9432-42e7-80e7-c4b571887fa6',163,'2d03e092-9432-42e7-80e7-c4b571887fa6','{\"sheetTitle\":\"INLAY ONLAY\",\"comment\":\"facette proximale haute et large\\n3m3 + EMAIL 3m2\\nINVERSION MAXILLAIRE ET MANDIBULE\",\"generalTintElement\":\"\",\"generalTintSupport\":\"\",\"language\":\"fr_FR\",\"prostheticContactPoint\":4,\"prostheticMaterial\":2,\"quality\":2,\"selectedTeeth\":[],\"subType\":3,\"type\":2}','29b0101d-6385-4e7a-9086-253fdc351d02','2019-09-19 11:15:04',NULL,'2021-12-16 22:26:03','2019-09-24 11:36:21','2021-12-16 21:26:03'),('2f000c1f-8ad6-4a2a-83d4-a09486ed49cc',163,'2f000c1f-8ad6-4a2a-83d4-a09486ed49cc','{\"sheetTitle\":\"COURONNE\",\"comment\":\"\",\"generalTintElement\":\"\",\"generalTintSupport\":\"\",\"language\":\"fr_FR\",\"prostheticContactPoint\":0,\"prostheticMaterial\":0,\"prostheticModel\":0,\"prostheticStep\":0,\"selectedTeeth\":[],\"subType\":0,\"type\":0}',NULL,'2019-10-09 20:26:32','2019-10-09 20:28:54',NULL,'2019-10-09 20:26:32','2019-10-09 18:28:54'),('488bcc99-0ec8-4bbd-8c96-416ae4683e43',163,'488bcc99-0ec8-4bbd-8c96-416ae4683e43','{\"sheetTitle\":\"COURONNE\",\"comment\":\"\",\"generalTintElement\":\"\",\"generalTintSupport\":\"\",\"language\":\"fr_FR\",\"prostheticContactPoint\":0,\"prostheticMaterial\":0,\"prostheticModel\":0,\"prostheticStep\":0,\"selectedTeeth\":[],\"subType\":0,\"type\":0}',NULL,'2020-02-17 12:05:47',NULL,NULL,'2020-02-17 12:05:47','2020-02-17 11:05:47'),('816f04b9-978f-4f25-b999-b4179ef17116',163,'816f04b9-978f-4f25-b999-b4179ef17116','{\"sheetTitle\":\"INLAY ONLAY\",\"comment\":\"facettes prox hautes et larges\\nEmail 4M1 sur Dentine 4M2\\nIdealiser l\'occlusion car 36 sera refaite\",\"generalTintElement\":\"\",\"generalTintSupport\":\"\",\"language\":\"fr_FR\",\"prostheticContactPoint\":5,\"prostheticMaterial\":2,\"quality\":2,\"selectedTeeth\":[],\"subType\":1,\"type\":2}','4ac1bde3-ded4-41d1-83a4-46e496e8b5cd','2019-08-28 20:07:01',NULL,'2021-12-16 22:26:10','2019-09-26 11:13:39','2021-12-16 21:26:10');
/*!40000 ALTER TABLE `ProstheticSheet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ReceivedAttachment`
--

DROP TABLE IF EXISTS `ReceivedAttachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ReceivedAttachment` (
  `ownerID` mediumint unsigned NOT NULL,
  `receivedMessageID` char(36) NOT NULL,
  `fileID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`fileID`,`receivedMessageID`),
  KEY `fk_ReceivedAttachment_ReceivedMessage` (`receivedMessageID`,`ownerID`),
  KEY `fk_ReceivedAttachment_CondorFile` (`fileID`,`ownerID`),
  CONSTRAINT `fk_ReceivedAttachment_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_ReceivedAttachment_ReceivedMessage` FOREIGN KEY (`receivedMessageID`, `ownerID`) REFERENCES `ReceivedMessage` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ReceivedAttachment`
--

LOCK TABLES `ReceivedAttachment` WRITE;
/*!40000 ALTER TABLE `ReceivedAttachment` DISABLE KEYS */;
INSERT INTO `ReceivedAttachment` VALUES (3,'3e1b8030-a173-11e9-a33b-226cec7cb58a','3e226da0-a173-11e9-a33b-226cec7cb58a','2021-12-10 13:53:55'),(3,'3e1b8030-a173-11e9-a33b-226cec7cb58a','3e231110-a173-11e9-a33b-226cec7cb58a','2021-12-10 13:53:55'),(3,'3e1b8030-a173-11e9-a33b-226cec7cb58a','3e24b106-a173-11e9-a33b-226cec7cb58a','2021-12-10 13:53:55'),(3,'3e1b8030-a173-11e9-a33b-226cec7cb58a','3e250a56-a173-11e9-a33b-226cec7cb58a','2021-12-10 13:53:55'),(3,'3e1b8030-a173-11e9-a33b-226cec7cb58a','3e259a88-a173-11e9-a33b-226cec7cb58a','2021-12-10 13:53:55'),(3,'3e1b8030-a173-11e9-a33b-226cec7cb58a','3e262f77-a173-11e9-a33b-226cec7cb58a','2021-12-10 13:53:55'),(3,'3e1b8030-a173-11e9-a33b-226cec7cb58a','3e26ccea-a173-11e9-a33b-226cec7cb58a','2021-12-10 13:53:55'),(3,'3e1b8030-a173-11e9-a33b-226cec7cb58a','3e27581e-a173-11e9-a33b-226cec7cb58a','2021-12-10 13:53:55'),(3,'d649619a-9d52-11e9-a33b-226cec7cb58a','d64b1334-9d52-11e9-a33b-226cec7cb58a','2021-12-10 13:53:55'),(3,'d649619a-9d52-11e9-a33b-226cec7cb58a','d64c9ff0-9d52-11e9-a33b-226cec7cb58a','2021-12-10 13:53:55'),(3,'d649619a-9d52-11e9-a33b-226cec7cb58a','d6507660-9d52-11e9-a33b-226cec7cb58a','2021-12-10 13:53:55');
/*!40000 ALTER TABLE `ReceivedAttachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ReceivedMessage`
--

DROP TABLE IF EXISTS `ReceivedMessage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ReceivedMessage` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `created` datetime DEFAULT NULL,
  `messageTransmitted` tinyint(1) NOT NULL DEFAULT '0',
  `messageSubject` varchar(45) NOT NULL,
  `body` text,
  `fromID` mediumint unsigned NOT NULL,
  `originMessageID` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `discussionID` char(36) NOT NULL,
  `readStatus` enum('Read','Unread') DEFAULT 'Unread',
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_ReceivedMessage_Discussion` (`discussionID`,`ownerID`),
  CONSTRAINT `fk_ReceivedMessage_Discussion` FOREIGN KEY (`discussionID`, `ownerID`) REFERENCES `Discussion` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ReceivedMessage`
--

LOCK TABLES `ReceivedMessage` WRITE;
/*!40000 ALTER TABLE `ReceivedMessage` DISABLE KEYS */;
INSERT INTO `ReceivedMessage` VALUES (3,'3e1b8030-a173-11e9-a33b-226cec7cb58a','2019-07-08 15:35:22',1,'#','Commande n° 2.2.2.1',3,NULL,NULL,'2019-07-08 15:35:23','2019-07-08 13:35:23','2019-07-08 15:35:21','605c208e-ad38-4268-a678-5f04c6f9007f','Read'),(3,'d649619a-9d52-11e9-a33b-226cec7cb58a','2019-07-03 17:32:35',1,'#','#',3,NULL,NULL,'2019-07-03 09:33:21','2019-07-03 07:33:21','2019-07-03 17:32:34','605c208e-ad38-4268-a678-5f04c6f9007f','Read');
/*!40000 ALTER TABLE `ReceivedMessage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Scan`
--

DROP TABLE IF EXISTS `Scan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Scan` (
  `ownerID` mediumint unsigned NOT NULL DEFAULT '0',
  `id` char(36) NOT NULL,
  `scanType` enum('MAXILLAIRE','MANDIBULE','MORDU_ANTERIEUR','MORDU_POSTERIEUR_GAUCHE','MORDU_POSTERIEUR_DROIT') DEFAULT 'MAXILLAIRE',
  `comments` mediumtext,
  `cameraX` decimal(10,0) DEFAULT NULL,
  `cameraY` decimal(10,0) DEFAULT NULL,
  `cameraZ` decimal(10,0) DEFAULT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `validated` tinyint(1) NOT NULL DEFAULT '0',
  `status` enum('in_progress','none') NOT NULL DEFAULT 'in_progress',
  `dateCreated` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `sessionID` char(36) DEFAULT NULL,
  `displayID` mediumint unsigned DEFAULT NULL,
  `globalDisplayID` mediumint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Scan_Work` (`ownerID`),
  KEY `fk_Scan_Session` (`sessionID`,`ownerID`),
  CONSTRAINT `fk_Scan_Session` FOREIGN KEY (`sessionID`, `ownerID`) REFERENCES `Session` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Scan`
--

LOCK TABLES `Scan` WRITE;
/*!40000 ALTER TABLE `Scan` DISABLE KEYS */;
INSERT INTO `Scan` VALUES (163,'00186753-75e1-4932-a7c7-83841ff310c4','MANDIBULE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'none','2022-02-12 15:09:06','2022-02-12 15:42:42','2022-02-12 15:42:42','2022-02-12 14:42:42','2022-02-12 15:12:05','85186f51-753c-498e-8346-beea8a780c7b',1,1),(163,'02e51064-f0d6-446a-acb0-0b5ce80915d9','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-07-07 15:00:08','2017-07-07 15:00:08',NULL,'2021-04-09 17:08:57','2017-07-07 15:00:08',NULL,1,NULL),(163,'04084a21-671f-49ef-a336-594796e4386f','MORDU_ANTERIEUR','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2019-10-09 20:10:11',NULL,'2021-12-16 22:26:06','2021-12-16 21:26:06','2019-10-09 20:10:11','d0e25f50-d624-467e-9ec5-62f18f66d406',1,1),(163,'073fbacf-ede3-4d02-b1ed-c47271ca0e8b','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2019-08-20 14:26:37','2019-08-20 14:26:48','2019-08-20 14:26:48','2021-04-09 17:08:57','2019-08-20 14:26:37',NULL,NULL,NULL),(163,'0796eab6-1d31-4c12-930b-d1645168f0cc','MORDU_ANTERIEUR','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2019-09-18 15:29:53',NULL,'2021-12-16 22:26:02','2021-12-16 21:26:02','2019-09-18 15:29:53','ae07c5e5-6b65-46ef-9cd1-c0a9daccea5f',1,1),(163,'07ab566c-1f76-4aed-a865-ba42f4f56bfc','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2019-09-18 15:21:05',NULL,'2021-12-16 22:26:02','2021-12-16 21:26:02','2019-09-18 15:21:05','ae07c5e5-6b65-46ef-9cd1-c0a9daccea5f',1,1),(163,'0aa3a260-9283-4def-b4f0-f3652eb329cc','MORDU_POSTERIEUR_GAUCHE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'none','2022-02-12 15:21:06','2022-02-12 15:43:53','2022-02-12 15:43:53','2022-02-12 14:43:53','2022-02-12 15:32:30','85186f51-753c-498e-8346-beea8a780c7b',1,1),(163,'167fb826-5833-4f16-abbf-9b5c9946585c','MORDU_POSTERIEUR_DROIT','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2019-08-28 20:02:41','2019-08-28 20:02:53',NULL,'2021-04-09 17:08:57','2019-08-28 20:02:41','92b33516-ba42-40bc-80ec-77c62a130f93',1,1),(163,'17981b33-27cc-453f-b1fe-d84e831b12c6','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-07-07 15:01:46','2017-07-07 15:01:46',NULL,'2021-04-09 17:08:57','2017-07-07 15:01:46',NULL,1,NULL),(163,'1886c25e-b99f-486a-9f55-cc6e16d1e54a','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-09-23 11:13:19','2017-09-23 11:13:19',NULL,'2021-04-09 17:08:57','2017-09-23 11:13:19',NULL,1,NULL),(163,'18a8129a-a9a0-43e4-b924-c8cc8c0e462c','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'none','2021-12-16 22:37:13','2021-12-16 22:44:24','2021-12-16 22:44:24','2021-12-16 21:44:24','2021-12-16 22:43:27','05363e68-a254-4acc-8205-219c338c6ba1',1,1),(163,'18cd0f29-a9fb-4dcd-91fe-8fb30a4d171a','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2019-10-14 13:02:12',NULL,'2021-12-16 22:26:11','2021-12-16 21:26:11','2019-10-14 13:02:12','c2195287-5f39-4a66-93d5-5b83792fc9a8',1,1),(163,'195ffba3-6544-4214-acf3-3a4088cbb672','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-07-07 15:47:04','2020-04-30 11:53:44',NULL,'2021-04-09 17:08:57','2017-07-07 15:47:04','26578904-6388-4b67-926c-fa9cede7abea',1,1),(163,'19d904f0-1e7a-4097-baf5-3d03ff2ff6d0','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2019-08-20 14:40:52','2020-04-30 11:53:44','2019-12-15 22:23:03','2021-04-09 17:08:57','2019-08-20 14:40:52','9f7449d6-1278-45d5-9492-02cd28be29ca',1,1),(163,'1a557577-b246-4e7a-8a7f-4ce5282bebcf','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2019-08-27 14:51:30',NULL,'2021-12-16 22:25:58','2021-12-16 21:25:58','2019-08-27 14:51:30','a28eb91b-4a0f-4d12-b29c-dd3f3c9d6c5f',1,1),(163,'1b051bff-7722-4829-8766-0b9476ca1a2b','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2019-08-20 15:34:58','2020-04-30 11:53:44','2019-12-15 22:23:03','2021-04-09 17:08:57','2019-08-20 15:34:58','6e0b4165-03cb-4f3b-bd97-fca211c1fe33',1,1),(163,'1c96bfa5-9beb-46a7-920d-54e049105cae','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2019-08-20 14:49:15','2020-04-30 11:53:44','2019-12-15 22:23:03','2021-04-09 17:08:57','2019-08-20 14:49:15','9f7449d6-1278-45d5-9492-02cd28be29ca',2,1),(163,'1d07390f-3d80-41c2-86c4-1303b894ae5c','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-09-23 11:16:45','2017-09-23 11:16:45',NULL,'2021-04-09 17:08:57','2017-09-23 11:16:45',NULL,1,NULL),(163,'20d217e0-77e2-4454-ba56-4d7129d4748a','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-09-23 10:24:22','2017-09-23 10:24:22',NULL,'2021-04-09 17:08:57','2017-09-23 10:24:22',NULL,1,NULL),(163,'23f33327-311c-4fff-b18e-b6a2ab47d776','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-09-23 11:19:54','2017-09-23 11:19:54',NULL,'2021-04-09 17:08:57','2017-09-23 11:19:54',NULL,1,NULL),(163,'25f01226-fdee-4f6c-a178-6b15e174b932','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'none','2022-02-12 15:05:04','2022-02-12 15:42:19','2022-02-12 15:42:19','2022-02-12 14:42:19','2022-02-12 15:05:04','85186f51-753c-498e-8346-beea8a780c7b',1,1),(163,'26a71710-0617-458e-becc-629d4d7677c8','MANDIBULE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2019-08-20 14:57:26','2020-04-30 11:53:44','2019-12-15 22:23:03','2021-04-09 17:08:57','2019-08-20 14:57:26','9f7449d6-1278-45d5-9492-02cd28be29ca',1,1),(163,'2961c928-7419-415c-a0c6-570bb108af7f','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2019-08-29 15:24:04',NULL,'2021-12-16 22:26:09','2021-12-16 21:26:09','2019-08-29 15:24:04','92b33516-ba42-40bc-80ec-77c62a130f93',1,1),(163,'2bc28be9-95a8-4df7-8286-d5897ac10c0d','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'none','2022-02-12 15:41:41','2022-02-12 15:41:47',NULL,'2022-02-12 14:41:47','2022-02-12 15:41:41','85186f51-753c-498e-8346-beea8a780c7b',5,1),(163,'2f4b6497-af99-4a81-aa43-26975955e7e9','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2020-01-30 12:47:34',NULL,'2021-12-16 22:26:08','2021-12-16 21:26:08','2020-01-30 12:47:34','2aa32ab4-f951-4bdb-bc1b-b3dbf0587866',1,1),(163,'2f578874-fe02-494a-b5ac-1b5da453aed0','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-07-07 15:14:53','2017-07-07 15:14:53',NULL,'2021-04-09 17:08:57','2017-07-07 15:14:53',NULL,1,NULL),(163,'317d3532-09fa-4b4b-9149-ef8efd300917','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-09-23 10:55:17','2017-09-23 10:55:17',NULL,'2021-04-09 17:08:57','2017-09-23 10:55:17',NULL,1,NULL),(163,'3390e065-1f9a-438a-8024-2e1b03309150','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'none','2022-02-12 15:33:27',NULL,'2022-02-12 15:36:24','2022-02-12 14:36:24','2022-02-12 15:36:22','85186f51-753c-498e-8346-beea8a780c7b',4,1),(163,'33cf5659-a381-4c06-9187-ad29576848da','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-09-23 10:32:51','2017-09-23 10:32:51',NULL,'2021-04-09 17:08:57','2017-09-23 10:32:51',NULL,1,NULL),(163,'355eef09-362c-4ad3-8144-d26528cee0f1','MANDIBULE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'none','2022-02-12 16:35:32',NULL,'2022-03-26 14:54:04','2022-03-26 13:54:04','2022-02-12 16:35:32','85186f51-753c-498e-8346-beea8a780c7b',3,1),(163,'3af0c7c7-068f-4b49-a043-c9deaf8798fc','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-09-23 11:51:55','2017-09-23 11:51:55',NULL,'2021-04-09 17:08:57','2017-09-23 11:51:55',NULL,1,NULL),(163,'3c0180ee-a48e-4a57-83c5-b2c2144f5bc2','MANDIBULE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'none','2022-02-12 15:36:25',NULL,'2022-02-12 15:39:15','2022-02-12 14:39:15','2022-02-12 15:39:04','85186f51-753c-498e-8346-beea8a780c7b',2,1),(163,'3f4e0761-9685-4aa9-a99e-f32bc3f3587a','MANDIBULE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2019-08-28 19:48:42',NULL,'2021-12-16 22:26:08','2021-12-16 21:26:08','2019-08-28 19:48:42','92b33516-ba42-40bc-80ec-77c62a130f93',1,1),(1,'416100cd-bf35-4dbb-932a-8661f3ba4f6f','MANDIBULE',NULL,NULL,NULL,NULL,'81719eb6-9836-45c5-a632-3098f463dde0','81719eb6-9836-45c5-a632-3098f463dde0',1,'in_progress','2017-05-29 11:49:15',NULL,NULL,'2021-04-09 17:08:57','2017-05-29 11:49:15','669bd839-b35f-4277-b25e-d33767724d18',1,8),(163,'44384df8-d4cf-4515-a227-e58defb71ddd','MANDIBULE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-09-23 12:00:17',NULL,'2021-12-16 22:26:04','2021-12-16 21:26:04','2017-09-23 12:00:17','2c9b2990-8860-4259-b919-67aa71e0b43f',1,1),(163,'44d5b703-6523-47a8-aa54-e6c882485fdd','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-09-23 10:41:16','2017-09-23 10:41:16',NULL,'2021-04-09 17:08:57','2017-09-23 10:41:16',NULL,1,NULL),(163,'4583be27-737a-431a-ada2-bcf554afd229','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2019-09-18 15:21:39','2019-09-18 15:21:47',NULL,'2021-04-09 17:08:57','2019-09-18 15:21:39','ae07c5e5-6b65-46ef-9cd1-c0a9daccea5f',2,1),(163,'4dae9d5a-78fb-4bf8-baf8-409fa0374e57','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'none','2022-02-12 15:12:50','2022-02-12 15:42:25','2022-02-12 15:42:25','2022-02-12 14:42:25','2022-02-12 15:18:42','85186f51-753c-498e-8346-beea8a780c7b',3,1),(163,'4f66eeb0-72e9-4b3f-9e2e-2051256ddf18','MORDU_POSTERIEUR_GAUCHE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2019-10-09 20:04:18',NULL,'2021-12-16 22:26:06','2021-12-16 21:26:06','2019-10-09 20:04:18','d0e25f50-d624-467e-9ec5-62f18f66d406',1,1),(163,'4f70034d-9a83-44fd-bb82-e82e6766d783','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-07-07 14:31:24','2018-06-26 17:07:29',NULL,'2021-04-09 17:08:57','2017-07-07 14:31:24',NULL,1,NULL),(163,'5b265bae-8c91-414d-bee3-c03fcfb27c19','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-09-23 10:30:21','2018-06-26 17:07:29',NULL,'2021-04-09 17:08:57','2017-09-23 10:30:21',NULL,1,NULL),(163,'606f5a2d-49c9-431b-adfc-bfd319d3757c','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'none','2021-04-11 12:12:27','2021-04-11 12:20:25',NULL,'2021-04-11 10:20:25','2021-04-11 12:15:56','a53c56e5-88df-4213-95fa-5e72bf6599b9',3,1),(163,'678e3b56-1265-4277-ab02-4bde03704ae0','MANDIBULE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2019-08-20 15:36:57','2020-04-30 11:53:44','2019-12-15 22:23:03','2021-04-09 17:08:57','2019-08-20 15:36:57','6e0b4165-03cb-4f3b-bd97-fca211c1fe33',1,1),(163,'6a1c5075-98b1-4211-9987-29ee0ba6ef5f','MANDIBULE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-07-07 16:08:31','2020-04-30 11:53:44',NULL,'2021-04-09 17:08:57','2017-07-07 16:08:31','ea11a5f6-aafe-41d9-b61b-f8b13f045b1e',1,1),(163,'6a92128a-9ab5-465e-86f2-e18355a2a85d','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2019-10-09 19:31:37','2019-10-09 19:31:52',NULL,'2021-04-09 17:08:57','2019-10-09 19:31:37','d0e25f50-d624-467e-9ec5-62f18f66d406',2,1),(163,'6d4776fc-8fa0-4bf4-9766-84a771e3fa0a','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-09-23 10:49:48','2017-09-23 10:49:48',NULL,'2021-04-09 17:08:57','2017-09-23 10:49:48',NULL,1,NULL),(163,'6d4dae1f-0c07-4972-8cd7-8b9e149a2b53','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-09-23 11:22:11','2017-09-23 11:22:11',NULL,'2021-04-09 17:08:57','2017-09-23 11:22:11',NULL,1,NULL),(163,'6d4e346f-b461-4ef0-b762-6d4c55126404','MORDU_ANTERIEUR','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2019-10-09 20:04:32','2019-10-09 20:05:51',NULL,'2021-04-09 17:08:57','2019-10-09 20:04:32','d0e25f50-d624-467e-9ec5-62f18f66d406',2,1),(163,'6e1de076-d685-4ba6-9073-9290f00e2e41','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2019-08-26 18:31:38',NULL,'2021-12-16 22:26:04','2021-12-16 21:26:04','2019-08-26 18:31:38','959392d0-b14f-4c07-bf36-75b2e165b77a',1,1),(163,'6e7c8911-84d8-43fd-8f0f-1af7ab21a105','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-07-07 14:59:26','2018-06-26 17:07:29',NULL,'2021-04-09 17:08:57','2017-07-07 14:59:26',NULL,1,NULL),(163,'71991f41-5a75-4db9-aaea-150dccb63670','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2019-10-09 19:32:41','2019-10-09 19:32:51',NULL,'2021-04-09 17:08:57','2019-10-09 19:32:41','d0e25f50-d624-467e-9ec5-62f18f66d406',3,1),(163,'750a7a0d-f537-43f0-aad6-f789a3aaf59c','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-09-23 10:45:26','2017-09-23 10:45:26',NULL,'2021-04-09 17:08:57','2017-09-23 10:45:26',NULL,1,NULL),(163,'753d010b-c7ba-4dc4-a9cb-eaa7680a0b86','MANDIBULE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2019-09-18 15:27:35',NULL,'2021-12-16 22:26:02','2021-12-16 21:26:02','2019-09-18 15:27:35','ae07c5e5-6b65-46ef-9cd1-c0a9daccea5f',1,1),(163,'7a1e80e2-3ff5-435d-8603-bf4d9090c2f2','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-09-23 10:54:39','2017-09-23 10:54:39',NULL,'2021-04-09 17:08:57','2017-09-23 10:54:39',NULL,1,NULL),(163,'7c9f870e-3da5-4258-b23d-c82cf5d82ab7','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-09-23 11:03:45','2017-09-23 11:03:45',NULL,'2021-04-09 17:08:57','2017-09-23 11:03:45',NULL,1,NULL),(163,'7cd8be19-c5e8-48d9-8950-c7006af5dda6','MORDU_POSTERIEUR_DROIT','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2019-10-09 20:02:38',NULL,'2021-12-16 22:26:06','2021-12-16 21:26:06','2019-10-09 20:02:38','d0e25f50-d624-467e-9ec5-62f18f66d406',1,1),(163,'8706821b-f8e9-424b-97f8-a7f55cdcb149','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-09-23 10:59:53','2017-09-23 10:59:53',NULL,'2021-04-09 17:08:57','2017-09-23 10:59:53',NULL,1,NULL),(163,'8bc0f684-8578-4ea5-84ed-9a2a184b15d3','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'none','2021-12-16 22:44:39','2022-02-12 16:36:13','2021-12-16 22:51:51','2022-02-12 15:36:13','2021-12-16 22:51:46','05363e68-a254-4acc-8205-219c338c6ba1',2,1),(163,'8e1238f1-606e-4e9a-bc88-a2d4b26c6bed','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'none','2022-02-12 15:07:08','2022-02-12 15:09:04',NULL,'2022-02-12 14:09:04','2022-02-12 15:07:08','85186f51-753c-498e-8346-beea8a780c7b',2,1),(163,'8ee89240-4c2c-43cf-a156-7cda82f0637f','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-07-07 14:45:16','2017-07-07 14:45:16',NULL,'2021-04-09 17:08:57','2017-07-07 14:45:16',NULL,1,NULL),(163,'942c6d2f-f8fa-467f-8daf-5a19257fea61','MORDU_POSTERIEUR_DROIT','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'none','2022-02-12 15:44:07',NULL,'2022-02-12 15:45:12','2022-02-12 14:45:12','2022-02-12 15:45:10','85186f51-753c-498e-8346-beea8a780c7b',1,1),(163,'9434a874-d77e-419f-a1ea-637de6b66399','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-09-23 11:57:28','2017-09-23 11:57:28',NULL,'2021-04-09 17:08:57','2017-09-23 11:57:28',NULL,1,NULL),(163,'993e81f9-b63b-42e8-9992-72d3942cce1a','MANDIBULE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2019-08-20 14:32:28','2020-04-30 11:53:44','2019-12-15 22:23:03','2021-04-09 17:08:57','2019-08-20 14:32:28','be8b17ea-1f2d-4455-823c-87f31acb59e4',1,1),(163,'9bfc9e7e-6d55-461c-b01c-e6ef10fc5f61','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2020-02-17 11:35:43','2020-02-17 11:46:51',NULL,'2021-04-09 17:08:57','2020-02-17 11:35:43','7560d619-3fa6-414c-85d8-52a724ef7bf4',1,1),(163,'9ed276f9-9775-47d3-ad07-589e561c3ce7','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2019-08-20 15:13:12','2020-04-30 11:53:44','2019-12-15 22:23:03','2021-04-09 17:08:57','2019-08-20 15:13:12','9f7449d6-1278-45d5-9492-02cd28be29ca',3,1),(163,'a632c622-54e1-4b73-902c-b181d20222d4','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-09-23 11:16:28','2017-09-23 11:16:28',NULL,'2021-04-09 17:08:57','2017-09-23 11:16:28',NULL,1,NULL),(163,'a83382e1-a424-413d-b331-e18fb09d8050','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-07-07 14:53:43','2017-07-07 14:53:43',NULL,'2021-04-09 17:08:57','2017-07-07 14:53:43',NULL,1,NULL),(163,'ac9639e4-a6ce-49f4-b726-2783785c402d','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'none','2021-04-11 12:20:33',NULL,'2021-12-16 22:26:10','2021-12-16 21:26:10','2021-04-11 12:25:10','a53c56e5-88df-4213-95fa-5e72bf6599b9',4,1),(1,'b78dcdc3-320d-4071-b1af-34f1a9dbaf7d','MAXILLAIRE',NULL,NULL,NULL,NULL,'81719eb6-9836-45c5-a632-3098f463dde0','81719eb6-9836-45c5-a632-3098f463dde0',1,'in_progress','2017-05-26 09:56:05',NULL,NULL,'2021-04-09 17:08:57','2017-05-26 09:56:05','669bd839-b35f-4277-b25e-d33767724d18',1,8),(163,'b918998e-0bf2-43ed-924e-57f69af453e7','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-09-23 10:35:58','2017-09-23 10:35:58',NULL,'2021-04-09 17:08:57','2017-09-23 10:35:58',NULL,1,NULL),(163,'bada95b4-b2ee-4b37-a39e-cb3348ed1dc3','MORDU_POSTERIEUR_DROIT','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2019-09-19 17:37:04','2019-09-19 17:37:10',NULL,'2021-04-09 17:08:57','2019-09-19 17:37:04','ae07c5e5-6b65-46ef-9cd1-c0a9daccea5f',1,1),(163,'bae5c384-8be6-46cb-914f-52893ff0a986','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'none','2021-04-11 10:04:08',NULL,'2021-12-16 22:26:35','2021-12-16 21:26:35','2021-04-11 11:44:50','a53c56e5-88df-4213-95fa-5e72bf6599b9',1,1),(163,'bdb4377a-7435-4a51-a3f1-0976ab9914be','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-09-23 11:01:41','2017-09-23 11:01:41',NULL,'2021-04-09 17:08:57','2017-09-23 11:01:41',NULL,1,NULL),(163,'be3fdbda-df17-4184-bf04-6f17a0efb2c6','MORDU_POSTERIEUR_GAUCHE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2019-08-28 19:56:43',NULL,'2021-12-16 22:26:08','2021-12-16 21:26:08','2019-08-28 19:56:43','92b33516-ba42-40bc-80ec-77c62a130f93',1,1),(163,'c417a061-3829-4fef-b4b6-b8e157772e8b','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2019-07-26 15:36:10','2019-07-26 15:36:26',NULL,'2021-04-09 17:08:57','2019-07-26 15:36:10',NULL,1,NULL),(163,'c58bf258-8cf8-46c5-b72f-1794963795db','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-07-07 14:36:55','2017-07-07 14:36:55',NULL,'2021-04-09 17:08:57','2017-07-07 14:36:55',NULL,1,NULL),(163,'c721c0c0-a514-44bc-af6d-0394b9e59459','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2019-10-09 19:30:44',NULL,'2021-12-16 22:26:05','2021-12-16 21:26:05','2019-10-09 19:30:44','d0e25f50-d624-467e-9ec5-62f18f66d406',1,1),(163,'c747cc9f-b0ac-4699-9c44-0651899bc2b1','MANDIBULE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2019-08-20 15:36:26','2019-08-20 15:37:11','2019-08-20 15:37:11','2021-04-09 17:08:57','2019-08-20 15:36:26',NULL,NULL,NULL),(163,'c76338b8-bffe-47d4-8998-dc50a5c1cdb9','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-07-07 14:54:48','2018-06-26 17:07:29',NULL,'2021-04-09 17:08:57','2017-07-07 14:54:48',NULL,1,NULL),(163,'c7b7db0b-804c-45c7-be06-002dd020c03a','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-07-07 14:43:32','2017-07-07 14:43:32',NULL,'2021-04-09 17:08:57','2017-07-07 14:43:32',NULL,1,NULL),(163,'cd569007-a8b8-4363-acd4-5ff36a438dbd','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'none','2022-02-12 15:49:57',NULL,'2022-11-08 22:49:14','2022-11-08 21:49:14','2022-11-08 22:49:11','85186f51-753c-498e-8346-beea8a780c7b',6,1),(163,'cebdf08e-3b3d-443b-9a43-ce334677c5ea','MANDIBULE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2019-08-20 14:26:51','2019-08-20 14:28:19',NULL,'2021-04-09 17:08:57','2019-08-20 14:26:51','be8b17ea-1f2d-4455-823c-87f31acb59e4',2,1),(163,'cf75ad7a-1e8d-4351-bb9d-d157349960ae','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-09-23 11:06:48','2017-09-23 11:06:48',NULL,'2021-04-09 17:08:57','2017-09-23 11:06:48',NULL,1,NULL),(163,'d1dc341b-6602-437f-99c5-f70a9e47e85a','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-06-22 18:17:22','2018-06-26 17:07:29',NULL,'2021-04-09 17:08:57','2017-06-22 18:17:22',NULL,1,NULL),(163,'d481f307-e5ea-4052-bad7-bd47bfc63610','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2019-08-27 14:37:19',NULL,'2021-12-16 22:25:58','2021-12-16 21:25:58','2019-08-27 14:37:19','11be814f-456b-4d24-997e-2f1d8310fc14',1,1),(163,'d4f5f9a3-deda-4c86-bfb5-75b54ae4b528','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2019-08-20 15:33:15','2019-08-20 15:33:18',NULL,'2021-04-09 17:08:57','2019-08-20 15:33:15','6e0b4165-03cb-4f3b-bd97-fca211c1fe33',2,1),(163,'d9467eb8-cd68-4cf7-bd55-81dceb72a1d0','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-09-23 10:46:55','2017-09-23 10:46:55',NULL,'2021-04-09 17:08:57','2017-09-23 10:46:55',NULL,1,NULL),(163,'d97e60ea-e111-4cd4-8c33-3e721fc48f13','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-07-07 14:21:58','2017-07-07 14:21:58',NULL,'2021-04-09 17:08:57','2017-07-07 14:21:58',NULL,1,NULL),(163,'dc0831aa-93b4-4baf-aab0-a9b0ce8b83e5','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-09-23 10:33:37','2018-06-26 17:07:29',NULL,'2021-04-09 17:08:57','2017-09-23 10:33:37',NULL,1,NULL),(163,'ddd0a775-a2c2-4d64-9ecc-b1396a74ba65','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-09-23 11:03:37','2017-09-23 11:03:37',NULL,'2021-04-09 17:08:57','2017-09-23 11:03:37',NULL,1,NULL),(163,'e45e36ef-7d3d-43b1-bfcd-00f5c6766a24','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2020-02-17 12:03:03',NULL,'2021-12-16 22:26:05','2021-12-16 21:26:05','2020-02-17 12:03:03','7560d619-3fa6-414c-85d8-52a724ef7bf4',2,1),(163,'e6641bf0-11a2-4258-82a5-4a7f31303a1a','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-09-23 11:10:55','2017-09-23 11:10:55',NULL,'2021-04-09 17:08:57','2017-09-23 11:10:55',NULL,1,NULL),(163,'eb411c34-6d2f-47b2-9f50-a318343a0ec0','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'none','2022-03-26 15:34:49',NULL,'2022-03-26 15:42:15','2022-03-26 14:42:15','2022-03-26 15:42:13','a8dad053-002c-407d-875a-1d0fe8c5e10f',1,1),(163,'ec391873-f0af-4d4b-9338-05f7be4443ea','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-09-23 11:24:20','2017-09-23 11:24:20',NULL,'2021-04-09 17:08:57','2017-09-23 11:24:20',NULL,1,NULL),(163,'ecab33ae-7dab-49e3-814b-55b739bced5b','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-07-07 15:44:19','2020-04-30 11:53:44','2019-12-15 22:23:03','2021-04-09 17:08:57','2017-07-07 15:44:19','ea11a5f6-aafe-41d9-b61b-f8b13f045b1e',1,1),(163,'f1172a60-6504-4697-9acb-2793b430d7fe','MANDIBULE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2019-10-09 19:44:42',NULL,'2021-12-16 22:26:06','2021-12-16 21:26:06','2019-10-09 19:44:42','d0e25f50-d624-467e-9ec5-62f18f66d406',1,1),(163,'f4a5df3d-ff5f-4124-ba17-a0d59fcef2e9','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2017-06-21 10:00:18','2017-06-21 10:00:18',NULL,'2021-04-09 17:08:57','2017-06-21 10:00:18',NULL,1,NULL),(163,'f73ede6a-6df1-4316-bced-be2c046effe7','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'in_progress','2019-08-20 15:26:28','2019-08-20 15:26:38','2019-08-20 15:26:38','2021-04-09 17:08:57','2019-08-20 15:26:28',NULL,NULL,NULL),(163,'ff508a13-6fb6-4736-87b1-187a5e0330b5','MAXILLAIRE','',NULL,NULL,NULL,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff','af4a9c1b-956e-4f70-b8f8-f40cadc590ff',1,'none','2021-04-11 11:53:15',NULL,'2021-12-16 22:26:22','2021-12-16 21:26:22','2021-04-11 12:00:33','a53c56e5-88df-4213-95fa-5e72bf6599b9',2,1);
/*!40000 ALTER TABLE `Scan` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `Scan_AFTER_UPDATE` AFTER UPDATE ON `Scan` FOR EACH ROW BEGIN
    IF NEW.deletedAt IS NOT NULL THEN
      UPDATE Occlusion SET topScanID = NULL
	  WHERE topScanID = new.id;

	  UPDATE Occlusion SET bottomScanID = NULL
	  WHERE bottomScanID = new.id;

	  UPDATE Occlusion SET leftBiteScanID = NULL
	  WHERE leftBiteScanID = new.id;

	  UPDATE Occlusion SET rightBiteScanID = NULL
	  WHERE rightBiteScanID = new.id;

	  UPDATE Occlusion SET anteriorBiteScanID = NULL
	  WHERE anteriorBiteScanID = new.id;
    END IF;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `Scan_BEFORE_DELETE` BEFORE DELETE ON `Scan` FOR EACH ROW BEGIN
  UPDATE Occlusion SET topScanID = NULL
  WHERE topScanID = OLD.id;

  UPDATE Occlusion SET bottomScanID = NULL
  WHERE bottomScanID = OLD.id;

  UPDATE Occlusion SET leftBiteScanID = NULL
  WHERE leftBiteScanID = OLD.id;

  UPDATE Occlusion SET rightBiteScanID = NULL
  WHERE rightBiteScanID = OLD.id;

  UPDATE Occlusion SET anteriorBiteScanID = NULL
  WHERE anteriorBiteScanID = OLD.id;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `ScanFile`
--

DROP TABLE IF EXISTS `ScanFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ScanFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `fileID` char(36) NOT NULL,
  `scanID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`fileID`,`scanID`,`ownerID`),
  KEY `fk_ScanFile_Scan` (`scanID`,`ownerID`),
  KEY `fk_ScanFile_CondorFile` (`fileID`,`ownerID`),
  CONSTRAINT `fk_ScanFile_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_ScanFile_Scan` FOREIGN KEY (`scanID`, `ownerID`) REFERENCES `Scan` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ScanFile`
--

LOCK TABLES `ScanFile` WRITE;
/*!40000 ALTER TABLE `ScanFile` DISABLE KEYS */;
INSERT INTO `ScanFile` VALUES (163,'017a9667-ac3d-4fef-a06e-5ddd29fdc587','be3fdbda-df17-4184-bf04-6f17a0efb2c6','2019-08-28 17:56:43'),(163,'01c97edc-1505-4e0a-8f10-092893017632','0aa3a260-9283-4def-b4f0-f3652eb329cc','2022-02-12 14:32:29'),(163,'02807cae-d63f-40cf-9ac4-c747ea770b34','4dae9d5a-78fb-4bf8-baf8-409fa0374e57','2022-02-12 14:18:41'),(163,'04d6ba70-17fa-4ec6-b60a-ae8c83a21656','073fbacf-ede3-4d02-b1ed-c47271ca0e8b','2019-08-20 12:25:19'),(163,'06c13027-f4ec-452a-90e6-376ae8aa4573','6a1c5075-98b1-4211-9987-29ee0ba6ef5f','2019-08-07 08:10:27'),(163,'06cc9b99-fb22-4ea1-bf33-8947b179c894','195ffba3-6544-4214-acf3-3a4088cbb672','2019-08-07 08:10:27'),(163,'06fda1e2-604f-4d55-9109-753390f8de28','3af0c7c7-068f-4b49-a043-c9deaf8798fc','2019-08-07 08:10:27'),(163,'0739d8ee-2b14-4370-a430-8495fec0feec','2961c928-7419-415c-a0c6-570bb108af7f','2019-08-28 17:42:44'),(163,'0791250b-1f00-4e84-86a1-3dea34c3d54f','1b051bff-7722-4829-8766-0b9476ca1a2b','2019-08-20 13:34:58'),(163,'07cdc5f1-9ddf-4eab-a043-c35a6f9783a0','c721c0c0-a514-44bc-af6d-0394b9e59459','2019-10-09 17:22:10'),(163,'08d2ffde-2c03-4ec9-8db4-66e88fe25ddd','bae5c384-8be6-46cb-914f-52893ff0a986','2021-04-11 08:11:49'),(163,'09098d73-a550-46fd-b107-f556eadffd45','4dae9d5a-78fb-4bf8-baf8-409fa0374e57','2022-02-12 14:18:41'),(163,'0aa71ebb-4833-4dfd-bf99-5158c2d6b79f','04084a21-671f-49ef-a336-594796e4386f','2019-10-09 18:10:11'),(163,'0d5f673d-1e06-4c82-b781-3166313d5ca7','753d010b-c7ba-4dc4-a9cb-eaa7680a0b86','2019-09-18 13:27:35'),(163,'0e03805c-4acf-475d-82a6-cef42ae568ea','993e81f9-b63b-42e8-9992-72d3942cce1a','2019-08-20 12:32:27'),(163,'0f8c0a7d-9d25-4b9e-9a7f-33d9881acf78','7cd8be19-c5e8-48d9-8950-c7006af5dda6','2019-10-09 17:59:52'),(163,'1014295d-2e79-47fe-92bf-3111bfc9d43e','19d904f0-1e7a-4097-baf5-3d03ff2ff6d0','2019-08-20 12:39:12'),(163,'11fa8713-51a4-4ebe-826b-f8e77b81fa64','993e81f9-b63b-42e8-9992-72d3942cce1a','2019-08-20 12:30:37'),(163,'12b83c2b-966f-46ac-92eb-c4aeaeeabfa7','5b265bae-8c91-414d-bee3-c03fcfb27c19','2019-08-07 08:10:27'),(163,'14425596-1207-4e3c-85a2-962de24cd892','c721c0c0-a514-44bc-af6d-0394b9e59459','2019-10-09 17:27:13'),(163,'18814eeb-ff1c-4473-b5af-604e53018f60','6a1c5075-98b1-4211-9987-29ee0ba6ef5f','2019-08-07 08:10:27'),(163,'1884156e-0009-429c-a499-0ea06f50ac03','c747cc9f-b0ac-4699-9c44-0651899bc2b1','2019-08-20 13:36:26'),(163,'1975cc7c-b839-4085-805d-f147a5b0713e','7cd8be19-c5e8-48d9-8950-c7006af5dda6','2019-10-09 17:55:54'),(163,'19e971d5-8f70-4650-be06-d6b925134b9f','cd569007-a8b8-4363-acd4-5ff36a438dbd','2022-02-12 15:23:38'),(163,'1a7468db-e426-418f-9be5-ea619e178e80','ff508a13-6fb6-4736-87b1-187a5e0330b5','2021-04-11 10:00:32'),(163,'1ba1d207-956d-49d4-b5aa-76c29f35e81c','d1dc341b-6602-437f-99c5-f70a9e47e85a','2019-08-07 08:10:27'),(163,'1c7f8f32-d02f-4b09-a844-56f902e86e98','44384df8-d4cf-4515-a227-e58defb71ddd','2019-08-07 08:10:27'),(163,'1e31cc48-54e9-432a-b8bf-8740fff36776','7cd8be19-c5e8-48d9-8950-c7006af5dda6','2019-10-09 17:51:50'),(163,'205963cf-0d3b-4c74-9f74-7eec3cc0f022','d1dc341b-6602-437f-99c5-f70a9e47e85a','2019-08-07 08:10:27'),(163,'20edaff2-efa9-45ee-9d49-2f7195591f97','c747cc9f-b0ac-4699-9c44-0651899bc2b1','2019-08-20 13:36:26'),(163,'23f1b081-9ad4-49bf-b123-0d1971f56cab','3af0c7c7-068f-4b49-a043-c9deaf8798fc','2019-08-07 08:10:27'),(163,'25113e99-c3e7-4d17-9c78-0289f82697f0','3390e065-1f9a-438a-8024-2e1b03309150','2022-02-12 14:34:54'),(163,'253a912c-c2e7-49c5-9cc4-243ebc7de3a8','3af0c7c7-068f-4b49-a043-c9deaf8798fc','2019-08-07 08:10:27'),(163,'26211f5c-1ad8-4463-8e8b-b3b60a00ba7e','18a8129a-a9a0-43e4-b924-c8cc8c0e462c','2021-12-16 21:43:27'),(163,'276c12a8-3d75-42ec-97d2-18b68d9a6101','3af0c7c7-068f-4b49-a043-c9deaf8798fc','2019-08-07 08:10:27'),(163,'27a5fc38-18cd-4993-ac8c-aed0d82de108','f73ede6a-6df1-4316-bced-be2c046effe7','2019-08-20 13:26:28'),(163,'2ca4b9b6-0fa5-43c0-9189-717339b5f3d4','bae5c384-8be6-46cb-914f-52893ff0a986','2021-04-11 09:38:40'),(163,'2d9489cd-1db0-4f5a-b533-f46d8404ab3b','6e7c8911-84d8-43fd-8f0f-1af7ab21a105','2019-08-07 08:10:27'),(163,'34e3bf9d-9455-42e8-8211-5f98ddc4a7b5','f1172a60-6504-4697-9acb-2793b430d7fe','2019-10-09 17:38:18'),(163,'3564a77e-4582-46c4-9f2c-b5ad00af9b7f','073fbacf-ede3-4d02-b1ed-c47271ca0e8b','2019-08-20 12:25:19'),(163,'360a685a-cc03-46f2-bcd3-b66e7250b82d','9bfc9e7e-6d55-461c-b01c-e6ef10fc5f61','2020-02-17 10:35:42'),(163,'37b2e7e8-7b45-44f6-9bf3-a3ee58f12ffc','6e7c8911-84d8-43fd-8f0f-1af7ab21a105','2019-08-07 08:10:27'),(163,'37d607cd-338e-40c0-a7a8-1124df452998','3390e065-1f9a-438a-8024-2e1b03309150','2022-02-12 14:36:21'),(163,'39bb61d6-8872-44f1-9c84-e4c0161b0e1f','2961c928-7419-415c-a0c6-570bb108af7f','2019-08-29 13:23:58'),(163,'3bf4bfa2-cc28-4996-9ae2-b0e93df2de6b','9ed276f9-9775-47d3-ad07-589e561c3ce7','2019-08-20 13:13:10'),(163,'3d2cd757-e631-4446-9e31-0898c32d2626','44d5b703-6523-47a8-aa54-e6c882485fdd','2019-08-07 08:10:27'),(163,'3d6af265-a88f-4743-a5e7-a9f9a29f81fb','18cd0f29-a9fb-4dcd-91fe-8fb30a4d171a','2019-10-14 10:54:26'),(163,'3dd0f9f9-74b8-4ce7-9a38-a25d8ccb971b','cd569007-a8b8-4363-acd4-5ff36a438dbd','2022-11-08 21:49:10'),(163,'4082adc1-d3e3-4085-89b9-70348f16efd3','ecab33ae-7dab-49e3-814b-55b739bced5b','2019-08-07 08:10:27'),(163,'40c5cd84-5aba-4596-a35c-26d65c1fde9f','7cd8be19-c5e8-48d9-8950-c7006af5dda6','2019-10-09 17:59:52'),(163,'410060f9-e183-48c7-bc84-bea261066501','ecab33ae-7dab-49e3-814b-55b739bced5b','2019-08-07 08:10:27'),(163,'410e2a87-a6fb-4335-98b8-a1e70bb0776a','c58bf258-8cf8-46c5-b72f-1794963795db','2019-08-07 08:10:27'),(163,'41a9f0ea-4d20-46b5-9408-ddfdda2170d3','2961c928-7419-415c-a0c6-570bb108af7f','2019-08-29 13:23:58'),(163,'42483e0d-9fd2-4cf4-8ffc-4b3f97b0b998','1b051bff-7722-4829-8766-0b9476ca1a2b','2019-08-20 13:34:58'),(163,'428a57a7-6701-41dd-8dd8-d8a01e1de216','9ed276f9-9775-47d3-ad07-589e561c3ce7','2019-08-20 13:13:10'),(163,'43b78c5a-49ae-4a2c-a6cb-0acfa61d751c','c721c0c0-a514-44bc-af6d-0394b9e59459','2019-10-09 17:27:13'),(163,'489ef9db-5210-4675-be4c-7c7b32faaa0f','04084a21-671f-49ef-a336-594796e4386f','2019-10-09 18:07:04'),(163,'49fa018c-a1f8-41c3-89ca-42d90f70b465','c721c0c0-a514-44bc-af6d-0394b9e59459','2019-10-09 17:30:43'),(163,'4b5f064c-9285-4119-bc00-8e7a6dd729b0','04084a21-671f-49ef-a336-594796e4386f','2019-10-09 18:10:11'),(163,'4c1113c9-3ec7-4c67-8bf8-3076f18cac31','ff508a13-6fb6-4736-87b1-187a5e0330b5','2021-04-11 09:57:45'),(163,'4c444508-c858-46f3-aa77-fa0f8322d1b9','02e51064-f0d6-446a-acb0-0b5ce80915d9','2019-08-07 08:10:27'),(163,'4c96b8bd-1cd4-4204-af6e-228db3257714','5b265bae-8c91-414d-bee3-c03fcfb27c19','2019-08-07 08:10:27'),(163,'4d049a4d-88f0-4043-a34b-c505c9e9d331','2f578874-fe02-494a-b5ac-1b5da453aed0','2019-08-07 08:10:27'),(163,'4d7867b4-9f52-49a2-88c8-83c3d4865095','0796eab6-1d31-4c12-930b-d1645168f0cc','2019-09-18 13:29:53'),(163,'4e06ebeb-9f37-41bc-9024-b3a5fb8571d9','18cd0f29-a9fb-4dcd-91fe-8fb30a4d171a','2019-10-14 11:02:11'),(163,'4e12bcab-9945-4ac0-80ca-4f849846a4bd','18cd0f29-a9fb-4dcd-91fe-8fb30a4d171a','2019-10-14 10:54:26'),(1,'4e406ac7-d775-4ae1-a021-065b692e23b6','b78dcdc3-320d-4071-b1af-34f1a9dbaf7d','2017-05-26 07:56:05'),(163,'4f05928e-7b4d-4f5d-80cb-38b13108dc65','993e81f9-b63b-42e8-9992-72d3942cce1a','2019-08-20 12:32:27'),(163,'50fdd65d-7e14-48e2-a3ca-6a69a2a4ec71','0796eab6-1d31-4c12-930b-d1645168f0cc','2019-09-18 13:29:53'),(163,'5511b6a1-dc48-4b08-a3c5-cb80df1ef921','9ed276f9-9775-47d3-ad07-589e561c3ce7','2019-08-20 13:13:10'),(163,'56264e08-ee06-4c6f-8e9b-6d38cc8530b1','7cd8be19-c5e8-48d9-8950-c7006af5dda6','2019-10-09 18:02:37'),(163,'5a0fc415-f9a5-4ae5-9e02-248ca895ca32','c721c0c0-a514-44bc-af6d-0394b9e59459','2019-10-09 17:22:10'),(163,'5c5378c6-f77b-4b5d-a2dc-e7d066bcf273','4f66eeb0-72e9-4b3f-9e2e-2051256ddf18','2019-10-09 18:04:18'),(163,'5df203dd-8224-41c9-96b4-e9581babd5b4','c721c0c0-a514-44bc-af6d-0394b9e59459','2019-10-09 17:25:52'),(163,'5e6d2e48-de8b-4d61-adcd-18525a78ce52','ac9639e4-a6ce-49f4-b726-2783785c402d','2021-04-11 10:25:10'),(163,'600a88ef-6d46-4292-867d-829372324c67','f1172a60-6504-4697-9acb-2793b430d7fe','2019-10-09 17:41:41'),(163,'61b0112d-a867-41af-947e-13ece4d9fbe2','bae5c384-8be6-46cb-914f-52893ff0a986','2021-04-11 09:44:48'),(163,'62599b0c-da27-495f-b818-77493722da47','073fbacf-ede3-4d02-b1ed-c47271ca0e8b','2019-08-20 12:26:37'),(163,'62bd53c9-9933-4b00-8ef1-38d0f2d31e6e','cd569007-a8b8-4363-acd4-5ff36a438dbd','2022-02-12 15:32:01'),(163,'631bcc28-4111-4e0e-a212-e688ec1d3e11','f1172a60-6504-4697-9acb-2793b430d7fe','2019-10-09 17:36:04'),(163,'63637d4c-1873-4650-b296-f47906667d72','f1172a60-6504-4697-9acb-2793b430d7fe','2019-10-09 17:38:18'),(163,'637b2b70-d4cb-45b9-9b4b-26e077032bbb','3af0c7c7-068f-4b49-a043-c9deaf8798fc','2019-08-07 08:10:27'),(163,'64286f64-d288-471b-8ab7-0fa381df35a6','753d010b-c7ba-4dc4-a9cb-eaa7680a0b86','2019-09-18 13:27:35'),(163,'657f26bc-ab53-4f46-875d-85b6d8c2ecb7','606f5a2d-49c9-431b-adfc-bfd319d3757c','2021-04-11 10:15:56'),(163,'67349e8c-f1af-4275-9741-d8f70cb19787','f1172a60-6504-4697-9acb-2793b430d7fe','2019-10-09 17:44:41'),(163,'69056410-5cdd-435f-a663-cd4600b06e72','cd569007-a8b8-4363-acd4-5ff36a438dbd','2022-02-12 15:06:49'),(163,'69358d1c-9f7a-48fc-adcb-c56e9cf5ff0d','c721c0c0-a514-44bc-af6d-0394b9e59459','2019-10-09 17:27:13'),(163,'69ab1861-8202-44b4-ab9c-aa1f8173d43a','1c96bfa5-9beb-46a7-920d-54e049105cae','2019-08-20 12:49:14'),(163,'6bc71a1d-d0ff-492c-b3cc-bf5d0b0e7ec3','073fbacf-ede3-4d02-b1ed-c47271ca0e8b','2019-08-20 12:25:19'),(163,'6c1402f2-cd34-461f-8bcd-719448b12370','2961c928-7419-415c-a0c6-570bb108af7f','2019-08-28 17:42:44'),(163,'71009f34-7ae1-4cb9-9556-58cfdb6630ec','26a71710-0617-458e-becc-629d4d7677c8','2019-08-20 12:57:25'),(163,'71e2ee96-4fab-47a8-824e-8e926c4280ba','bae5c384-8be6-46cb-914f-52893ff0a986','2021-04-11 08:11:49'),(163,'72025620-698a-462f-92db-da5e4caf0dfd','3390e065-1f9a-438a-8024-2e1b03309150','2022-02-12 14:36:21'),(163,'72d4e8b8-2ebb-4d1f-9ca9-3fb0a8e1ea48','5b265bae-8c91-414d-bee3-c03fcfb27c19','2019-08-07 08:10:27'),(163,'752e53bc-9b9f-4861-ab01-bfae139d6a4a','e45e36ef-7d3d-43b1-bfcd-00f5c6766a24','2020-02-17 10:47:42'),(163,'7555c2a5-cd64-4010-aaec-f25c5371e1b4','a83382e1-a424-413d-b331-e18fb09d8050','2019-08-07 08:10:27'),(163,'75ac9adc-2f27-4f4f-8b5a-4eaf930c1045','ac9639e4-a6ce-49f4-b726-2783785c402d','2021-04-11 10:25:10'),(163,'762a3b6d-dc65-4c0f-b252-3f012d6880ed','f1172a60-6504-4697-9acb-2793b430d7fe','2019-10-09 17:44:41'),(163,'764731ff-7791-45c8-ae68-82dd2bbe2346','1b051bff-7722-4829-8766-0b9476ca1a2b','2019-08-20 13:34:58'),(163,'76555b35-9c78-4952-908e-1ada8ee3b976','073fbacf-ede3-4d02-b1ed-c47271ca0e8b','2019-08-20 12:26:37'),(163,'76dda0ce-1254-4edd-bfae-486661f8e03d','7cd8be19-c5e8-48d9-8950-c7006af5dda6','2019-10-09 17:49:41'),(163,'77bd0e85-8efc-4891-ac66-9952c05b0022','c721c0c0-a514-44bc-af6d-0394b9e59459','2019-10-09 17:25:52'),(163,'784ec1f1-3dc8-422a-82e5-68c5869965cc','3af0c7c7-068f-4b49-a043-c9deaf8798fc','2019-08-07 08:10:27'),(163,'79018a8b-f206-4a43-a634-64204d878940','26a71710-0617-458e-becc-629d4d7677c8','2019-08-20 12:57:25'),(163,'797372b9-0108-43a4-8d44-c4b10f1f6b57','7cd8be19-c5e8-48d9-8950-c7006af5dda6','2019-10-09 17:55:54'),(163,'7a9749e4-92f4-4da4-8285-8bfcc18562dc','f1172a60-6504-4697-9acb-2793b430d7fe','2019-10-09 17:44:41'),(163,'7d880d12-8b38-442f-bd8a-2b0e2ba3c858','3af0c7c7-068f-4b49-a043-c9deaf8798fc','2019-08-07 08:10:27'),(163,'7d9bfb0d-1cae-4e52-947a-72ab21c7f74c','2961c928-7419-415c-a0c6-570bb108af7f','2019-08-28 17:42:44'),(163,'7e6be391-d34a-4c0f-8079-2e159f2dacd3','195ffba3-6544-4214-acf3-3a4088cbb672','2019-08-07 08:10:27'),(163,'7ed5d04f-5da5-4b8f-9528-5ea7290ef17a','2f578874-fe02-494a-b5ac-1b5da453aed0','2019-08-07 08:10:27'),(163,'7f7478f0-370a-42e0-ae41-55eb424c1542','4f70034d-9a83-44fd-bb82-e82e6766d783','2019-08-07 08:10:27'),(163,'7fe0b9f5-3acf-4966-8a2b-b615d4be86d3','17981b33-27cc-453f-b1fe-d84e831b12c6','2019-08-07 08:10:27'),(163,'812d3ded-5efc-4768-afe5-7ef344ae2eef','18cd0f29-a9fb-4dcd-91fe-8fb30a4d171a','2019-10-14 10:57:56'),(163,'819653ad-864a-4e20-9933-b4bc60307323','3af0c7c7-068f-4b49-a043-c9deaf8798fc','2019-08-07 08:10:27'),(163,'8824e951-379b-45ae-9210-b4228cc832a2','33cf5659-a381-4c06-9187-ad29576848da','2019-08-07 08:10:27'),(163,'88a3a973-9f5c-40bf-b35a-7ac9ccd2a5f2','f1172a60-6504-4697-9acb-2793b430d7fe','2019-10-09 17:41:41'),(163,'88c19117-97fb-4589-a086-5b48d3765732','3390e065-1f9a-438a-8024-2e1b03309150','2022-02-12 14:34:54'),(163,'8a9433cc-16c8-47db-8cba-6b849b3e9718','7a1e80e2-3ff5-435d-8603-bf4d9090c2f2','2019-08-07 08:10:27'),(163,'8d8bb1d2-703a-485b-87dc-e53404858cfe','be3fdbda-df17-4184-bf04-6f17a0efb2c6','2019-08-28 17:56:43'),(163,'8ef3aa5a-839a-4af3-8b68-c5896c6d8f2a','1c96bfa5-9beb-46a7-920d-54e049105cae','2019-08-20 12:49:14'),(163,'8f08a4aa-c3db-47d5-8812-811198ddca5a','7cd8be19-c5e8-48d9-8950-c7006af5dda6','2019-10-09 17:49:41'),(163,'905ddea2-ff14-48f0-b814-44ab659a02e9','f73ede6a-6df1-4316-bced-be2c046effe7','2019-08-20 13:26:28'),(1,'90612e90-6323-453a-b100-2c14dd6ba1f0','b78dcdc3-320d-4071-b1af-34f1a9dbaf7d','2017-05-26 07:56:05'),(163,'907003f5-2965-4caa-bfaa-10e6969a7b2c','bae5c384-8be6-46cb-914f-52893ff0a986','2021-04-11 09:38:40'),(163,'9223ddc8-c22b-432b-8e5b-e2bbed0d9bce','3af0c7c7-068f-4b49-a043-c9deaf8798fc','2019-08-07 08:10:27'),(163,'9273720b-56c3-415c-b28e-0440361cecc8','7cd8be19-c5e8-48d9-8950-c7006af5dda6','2019-10-09 18:02:37'),(163,'92bf2967-ccd3-4869-87d8-c7c47372079a','8bc0f684-8578-4ea5-84ed-9a2a184b15d3','2021-12-16 21:51:45'),(163,'948d31ea-7959-45fc-8837-7042467113b1','4f70034d-9a83-44fd-bb82-e82e6766d783','2019-08-07 08:10:27'),(1,'95127d8e-06cd-4869-a3cd-73db8c8ec785','416100cd-bf35-4dbb-932a-8661f3ba4f6f','2017-05-29 09:49:15'),(163,'98705d86-9475-4eb0-bd0c-7cceb74127d9','ecab33ae-7dab-49e3-814b-55b739bced5b','2019-08-07 08:10:27'),(163,'99fa3152-eda1-48eb-8d5f-7b0904c50cb4','18cd0f29-a9fb-4dcd-91fe-8fb30a4d171a','2019-10-14 10:57:56'),(163,'9a1535dd-b5a7-41f8-9557-b243a7f416e4','3f4e0761-9685-4aa9-a99e-f32bc3f3587a','2019-08-28 17:48:42'),(163,'9a6aa6b0-aaf4-4514-a385-1323a42ce5ed','6a1c5075-98b1-4211-9987-29ee0ba6ef5f','2019-08-07 08:10:27'),(163,'9aa094ef-9ea6-4843-981d-e021401874a1','6a1c5075-98b1-4211-9987-29ee0ba6ef5f','2019-08-07 08:10:27'),(163,'9d375328-38fb-45a3-9305-dbb966236d24','e45e36ef-7d3d-43b1-bfcd-00f5c6766a24','2020-02-17 11:03:03'),(163,'9dbe5232-44ea-4c9c-820d-84e24471a57d','195ffba3-6544-4214-acf3-3a4088cbb672','2019-08-07 08:10:27'),(163,'9e9ef1a8-d9dd-4a8a-a944-ae04a6e71c1e','9bfc9e7e-6d55-461c-b01c-e6ef10fc5f61','2020-02-17 10:35:42'),(163,'a0611add-acd8-4025-8433-f453f9d61ada','f73ede6a-6df1-4316-bced-be2c046effe7','2019-08-20 13:26:28'),(163,'a0754964-2abc-4bfc-9fd1-3368814f9560','19d904f0-1e7a-4097-baf5-3d03ff2ff6d0','2019-08-20 12:39:12'),(163,'a0840078-f705-4297-a590-258aedaa7cf8','7cd8be19-c5e8-48d9-8950-c7006af5dda6','2019-10-09 17:49:41'),(163,'a4fe9afa-c87f-4755-8881-cbd8df0e865e','4f66eeb0-72e9-4b3f-9e2e-2051256ddf18','2019-10-09 18:04:18'),(163,'a730168d-f711-4f65-97cc-e1abf584ee29','6a1c5075-98b1-4211-9987-29ee0ba6ef5f','2019-08-07 08:10:27'),(163,'a875f57f-7f35-4ffb-ac85-18b73e5cda0e','753d010b-c7ba-4dc4-a9cb-eaa7680a0b86','2019-09-18 13:27:35'),(163,'a9a24eec-ed31-4ca3-a322-e55a79a15bdc','3f4e0761-9685-4aa9-a99e-f32bc3f3587a','2019-08-28 17:48:42'),(163,'a9aa3381-bdc3-46c7-a6b4-5a267ebfb25d','cd569007-a8b8-4363-acd4-5ff36a438dbd','2022-02-12 14:58:51'),(163,'abbd99e5-91a4-49a3-81a1-0f5dbd693be5','bae5c384-8be6-46cb-914f-52893ff0a986','2021-04-11 09:44:48'),(163,'ac69a972-fe3a-4fd6-8687-203d02d867a9','f1172a60-6504-4697-9acb-2793b430d7fe','2019-10-09 17:41:41'),(163,'ad0a72a1-7e90-4a8f-9f02-4b383d0f2463','5b265bae-8c91-414d-bee3-c03fcfb27c19','2019-08-07 08:10:27'),(163,'ad72d576-cf58-46df-a31d-34e5436dd82b','d1dc341b-6602-437f-99c5-f70a9e47e85a','2019-08-07 08:10:27'),(163,'ad7fe43a-bcf6-4679-91f6-cc90438bd5fc','8bc0f684-8578-4ea5-84ed-9a2a184b15d3','2021-12-16 21:51:45'),(163,'adfde7b0-a6d4-4608-8117-f3790bea8ef9','993e81f9-b63b-42e8-9992-72d3942cce1a','2019-08-20 12:30:37'),(163,'af3275fd-de94-4563-a07f-efe7b8ecf1f4','07ab566c-1f76-4aed-a865-ba42f4f56bfc','2019-09-18 13:21:05'),(163,'b0dd07cc-d696-4bca-80b0-e17007eae6bf','18cd0f29-a9fb-4dcd-91fe-8fb30a4d171a','2019-10-14 11:02:11'),(1,'b249311d-c71f-4e50-9e5a-230d4488d820','b78dcdc3-320d-4071-b1af-34f1a9dbaf7d','2017-05-26 07:57:52'),(1,'b51230cc-9d03-4f5f-b14e-db9f71efb070','416100cd-bf35-4dbb-932a-8661f3ba4f6f','2017-05-29 09:47:48'),(163,'b5df8952-3e2b-4b22-b7cf-e3d423dc8126','dc0831aa-93b4-4baf-aab0-a9b0ce8b83e5','2019-08-07 08:10:27'),(163,'b63744ab-d942-4a63-9107-d2ccb5da0f63','18cd0f29-a9fb-4dcd-91fe-8fb30a4d171a','2019-10-14 10:54:26'),(163,'b6865a4a-2933-4ddf-a792-1aa292359fd7','c721c0c0-a514-44bc-af6d-0394b9e59459','2019-10-09 17:30:43'),(163,'b7026194-7463-405c-bf47-935e3808c03b','7cd8be19-c5e8-48d9-8950-c7006af5dda6','2019-10-09 17:51:50'),(163,'b7c0b693-e7fb-4f9f-a38b-30bf36ce6b45','d1dc341b-6602-437f-99c5-f70a9e47e85a','2019-08-07 08:10:27'),(163,'b901812e-8285-4bd8-b23e-0be4dbd27b7a','d1dc341b-6602-437f-99c5-f70a9e47e85a','2019-08-07 08:10:27'),(163,'b9278bcb-3c8b-4c8e-ba62-8ef3a63d21a8','8ee89240-4c2c-43cf-a156-7cda82f0637f','2019-08-07 08:10:27'),(163,'bb5d84f3-d791-4765-9d93-4ef53157d5f8','f1172a60-6504-4697-9acb-2793b430d7fe','2019-10-09 17:38:18'),(163,'bcb48043-98c3-49fc-932c-6d3999941b8c','993e81f9-b63b-42e8-9992-72d3942cce1a','2019-08-20 12:32:27'),(163,'bcc537fa-de81-4f4a-a687-dd2ad5438982','e45e36ef-7d3d-43b1-bfcd-00f5c6766a24','2020-02-17 10:47:42'),(163,'bcc65d9e-d6ca-49f2-aa48-b84ef943291b','04084a21-671f-49ef-a336-594796e4386f','2019-10-09 18:10:11'),(163,'bd6fe391-56db-48a1-9f21-da2b75191eca','4f70034d-9a83-44fd-bb82-e82e6766d783','2019-08-07 08:10:27'),(163,'be3ec918-8b02-450e-8e28-f25a61cb7c67','e45e36ef-7d3d-43b1-bfcd-00f5c6766a24','2020-02-17 11:03:03'),(163,'bf93739f-7ccf-4c21-9c8f-02a4c8c9e1c2','44384df8-d4cf-4515-a227-e58defb71ddd','2019-08-07 08:10:27'),(163,'bfc26d0f-8c87-4bc8-8eb6-414ecd4d2501','ff508a13-6fb6-4736-87b1-187a5e0330b5','2021-04-11 10:00:32'),(163,'c2a12178-bc47-40b7-b1f8-49dad7689c38','6a1c5075-98b1-4211-9987-29ee0ba6ef5f','2019-08-07 08:10:27'),(163,'c38a95f8-5f9b-4321-9fb5-f876db2b59c7','942c6d2f-f8fa-467f-8daf-5a19257fea61','2022-02-12 14:45:10'),(163,'c69d2270-21b7-4a7a-a972-7ef5795a4220','26a71710-0617-458e-becc-629d4d7677c8','2019-08-20 12:57:25'),(163,'c6b0f3cc-8336-4cae-917f-bf6759764002','dc0831aa-93b4-4baf-aab0-a9b0ce8b83e5','2019-08-07 08:10:27'),(163,'c8476340-c7f4-4492-af1b-1638eca300cb','18a8129a-a9a0-43e4-b924-c8cc8c0e462c','2021-12-16 21:43:27'),(163,'c8c830ba-cf40-40b0-b6b7-7194b746c2a2','07ab566c-1f76-4aed-a865-ba42f4f56bfc','2019-09-18 13:21:05'),(163,'c98dc488-e62f-4367-9cf1-0f11d08460dd','7cd8be19-c5e8-48d9-8950-c7006af5dda6','2019-10-09 17:55:54'),(163,'c9b6005e-411d-4c7c-8e2d-820d894f40cf','073fbacf-ede3-4d02-b1ed-c47271ca0e8b','2019-08-20 12:26:37'),(163,'c9cfc51a-f52b-4ba8-98bf-f2b96ce33545','19d904f0-1e7a-4097-baf5-3d03ff2ff6d0','2019-08-20 12:40:51'),(163,'c9fe09d4-cd80-48e9-812a-78877cdd3e62','eb411c34-6d2f-47b2-9f50-a318343a0ec0','2022-03-26 14:42:12'),(163,'ca16d92c-2112-4b6c-83ac-10b123b7e3f0','1c96bfa5-9beb-46a7-920d-54e049105cae','2019-08-20 12:49:14'),(163,'cafc2275-35d2-453b-a78d-41fe37eb95e4','7cd8be19-c5e8-48d9-8950-c7006af5dda6','2019-10-09 17:51:50'),(163,'cc353b45-490c-4cda-971d-9b57a05443e1','3af0c7c7-068f-4b49-a043-c9deaf8798fc','2019-08-07 08:10:27'),(163,'cc9c6ab1-44d9-4808-9f07-b14e58898b42','3af0c7c7-068f-4b49-a043-c9deaf8798fc','2019-08-07 08:10:27'),(163,'ccca477c-c237-4726-b103-037205c50d3d','7cd8be19-c5e8-48d9-8950-c7006af5dda6','2019-10-09 17:59:52'),(163,'d003a690-dc4d-4562-9884-3f053f338768','cd569007-a8b8-4363-acd4-5ff36a438dbd','2022-02-12 14:58:51'),(163,'d0c49092-4174-41ea-a6df-115b7fbd1689','04084a21-671f-49ef-a336-594796e4386f','2019-10-09 18:07:04'),(163,'d291fa5f-f8a2-4df1-8722-ce9dd35c0a1e','c721c0c0-a514-44bc-af6d-0394b9e59459','2019-10-09 17:25:52'),(163,'d303cf66-8219-41f9-ac8a-a9a6d81f0e51','4f66eeb0-72e9-4b3f-9e2e-2051256ddf18','2019-10-09 18:04:18'),(163,'d4d9ec35-a91a-4fd8-a5f6-46de28e34612','993e81f9-b63b-42e8-9992-72d3942cce1a','2019-08-20 12:30:37'),(163,'d52360b6-d894-4515-a6f0-d7c351152dbe','b918998e-0bf2-43ed-924e-57f69af453e7','2019-08-07 08:10:27'),(163,'d74c043a-1a69-4c1b-b15d-0294ad179983','d1dc341b-6602-437f-99c5-f70a9e47e85a','2019-08-07 08:10:27'),(163,'d8d85c43-8550-4d6b-b9cb-c32a35f811ce','3c0180ee-a48e-4a57-83c5-b2c2144f5bc2','2022-02-12 14:39:04'),(163,'dabf252e-b8aa-4c07-a2d2-208a2e3b9178','eb411c34-6d2f-47b2-9f50-a318343a0ec0','2022-03-26 14:42:12'),(163,'dae9f2a3-c4f3-4de7-9f42-43667adba09f','3af0c7c7-068f-4b49-a043-c9deaf8798fc','2019-08-07 08:10:27'),(163,'dafd74d2-dd54-4260-8a8a-ac8fdcfe717a','c721c0c0-a514-44bc-af6d-0394b9e59459','2019-10-09 17:22:10'),(163,'dd651c32-5d3b-4598-bb9f-7e028160d5fd','3f4e0761-9685-4aa9-a99e-f32bc3f3587a','2019-08-28 17:48:42'),(163,'dde30441-002a-4e92-9233-96d200200eb1','00186753-75e1-4932-a7c7-83841ff310c4','2022-02-12 14:12:05'),(163,'df26a803-1f84-452f-8358-f7e2941632cb','18cd0f29-a9fb-4dcd-91fe-8fb30a4d171a','2019-10-14 11:02:11'),(163,'df33eab1-f93f-4b78-93da-b18b16a448e6','19d904f0-1e7a-4097-baf5-3d03ff2ff6d0','2019-08-20 12:40:51'),(163,'dfb3acc0-5259-451b-9dee-6ebd6b98f76f','cd569007-a8b8-4363-acd4-5ff36a438dbd','2022-02-12 15:23:38'),(163,'e232f8ba-a8e2-4b1b-af2f-a9df87af7d9d','be3fdbda-df17-4184-bf04-6f17a0efb2c6','2019-08-28 17:56:43'),(163,'e34bd481-90b0-47c9-9f3b-8114fff93036','0796eab6-1d31-4c12-930b-d1645168f0cc','2019-09-18 13:29:53'),(163,'e36af518-bf7d-4847-95c4-06d20926f931','0aa3a260-9283-4def-b4f0-f3652eb329cc','2022-02-12 14:32:29'),(163,'e48275cd-4456-4c27-9c83-938df1bce8a3','ff508a13-6fb6-4736-87b1-187a5e0330b5','2021-04-11 09:57:45'),(163,'e6e29632-fbf6-43f8-acdd-57c836081670','942c6d2f-f8fa-467f-8daf-5a19257fea61','2022-02-12 14:45:10'),(163,'e718ad91-2aab-4430-9ea9-5014c920299b','07ab566c-1f76-4aed-a865-ba42f4f56bfc','2019-09-18 13:21:05'),(163,'e74c6abb-f68f-4393-a830-53652f4b0201','c747cc9f-b0ac-4699-9c44-0651899bc2b1','2019-08-20 13:36:26'),(163,'e7aff107-74de-4692-8cc6-1e7b0ff9de2f','19d904f0-1e7a-4097-baf5-3d03ff2ff6d0','2019-08-20 12:40:51'),(163,'e8dadd53-f8a7-4cee-9109-41034eca20e6','c721c0c0-a514-44bc-af6d-0394b9e59459','2019-10-09 17:30:43'),(163,'ea8078ad-79b9-48a5-91ba-1f7fac287026','678e3b56-1265-4277-ab02-4bde03704ae0','2019-08-20 13:36:57'),(163,'ecab608c-1b4f-40da-b9fc-82f952b14a67','cd569007-a8b8-4363-acd4-5ff36a438dbd','2022-02-12 15:06:49'),(163,'eec326a1-9d25-49b3-9968-9781ac07b1ff','606f5a2d-49c9-431b-adfc-bfd319d3757c','2021-04-11 10:15:56'),(163,'eed9f4a6-6cb9-4553-a819-5ed36a9b5c9e','44384df8-d4cf-4515-a227-e58defb71ddd','2019-08-07 08:10:27'),(163,'ef2faa51-92ed-4810-914e-f585dc84b167','6e7c8911-84d8-43fd-8f0f-1af7ab21a105','2019-08-07 08:10:27'),(163,'ef91b022-83f4-4ff4-97e8-4bcb62ff5b6d','f1172a60-6504-4697-9acb-2793b430d7fe','2019-10-09 17:36:04'),(163,'f16e392b-d1d5-499c-a379-06e00eb00a82','678e3b56-1265-4277-ab02-4bde03704ae0','2019-08-20 13:36:57'),(163,'f23cf02f-cc31-4339-863c-a995c5c0eed8','6a1c5075-98b1-4211-9987-29ee0ba6ef5f','2019-08-07 08:10:27'),(163,'f2610181-ff91-4f47-9c01-1b9ad8b99487','6a1c5075-98b1-4211-9987-29ee0ba6ef5f','2019-08-07 08:10:27'),(163,'f2eab1f5-bc32-4010-8205-31f71d9839d3','678e3b56-1265-4277-ab02-4bde03704ae0','2019-08-20 13:36:57'),(163,'f3227141-7884-4fbb-afb6-a2168a8223e6','04084a21-671f-49ef-a336-594796e4386f','2019-10-09 18:07:04'),(163,'f562c1d5-8b9d-40d0-82b2-c5ca1efb8991','7cd8be19-c5e8-48d9-8950-c7006af5dda6','2019-10-09 18:02:37'),(163,'f630803a-a4af-46bc-a9f8-ae749e594fb0','6a1c5075-98b1-4211-9987-29ee0ba6ef5f','2019-08-07 08:10:27'),(163,'f8e4d624-10f1-4625-8c54-c1778040bd09','dc0831aa-93b4-4baf-aab0-a9b0ce8b83e5','2019-08-07 08:10:27'),(163,'f95119ce-2fc9-4394-9721-e06fe8267fe4','19d904f0-1e7a-4097-baf5-3d03ff2ff6d0','2019-08-20 12:39:12'),(163,'f95a370d-8233-4ddc-9dca-4d2c6a111556','3c0180ee-a48e-4a57-83c5-b2c2144f5bc2','2022-02-12 14:39:04'),(163,'f9960be8-9d0d-41de-98ff-841336bef8ad','00186753-75e1-4932-a7c7-83841ff310c4','2022-02-12 14:12:05'),(163,'fa4ef123-90ee-4188-9147-31311bc25127','2f578874-fe02-494a-b5ac-1b5da453aed0','2019-08-07 08:10:27'),(163,'fb3b6e24-9356-49d8-8960-dfd6ec1157f6','f1172a60-6504-4697-9acb-2793b430d7fe','2019-10-09 17:36:04'),(163,'fcc7307b-f00b-4c18-8587-a659de2eb7ed','cd569007-a8b8-4363-acd4-5ff36a438dbd','2022-02-12 15:32:01'),(163,'fd172ed2-6103-47d5-93d9-9e68c457e419','6d4776fc-8fa0-4bf4-9766-84a771e3fa0a','2019-08-07 08:10:27'),(1,'fd8b4d1f-d4d7-4a12-bf74-74c5fe91a00b','416100cd-bf35-4dbb-932a-8661f3ba4f6f','2017-05-29 09:47:48'),(163,'ff71a3ea-b15b-4dc0-8b52-90b409e29344','18cd0f29-a9fb-4dcd-91fe-8fb30a4d171a','2019-10-14 10:57:56');
/*!40000 ALTER TABLE `ScanFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SentAttachment`
--

DROP TABLE IF EXISTS `SentAttachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SentAttachment` (
  `ownerID` mediumint unsigned NOT NULL DEFAULT '0',
  `sentMessageID` char(36) NOT NULL,
  `fileID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`sentMessageID`,`fileID`),
  KEY `fk_SentAttachment_SentMessage` (`sentMessageID`,`ownerID`),
  KEY `fk_SentAttachment_CondorFile` (`fileID`,`ownerID`),
  CONSTRAINT `fk_SentAttachment_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_SentAttachment_SentMessage` FOREIGN KEY (`sentMessageID`, `ownerID`) REFERENCES `SentMessage` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SentAttachment`
--

LOCK TABLES `SentAttachment` WRITE;
/*!40000 ALTER TABLE `SentAttachment` DISABLE KEYS */;
INSERT INTO `SentAttachment` VALUES (3,'148ab8de-7fa6-4388-9982-dd1dc536091f','27cfdaa5-b01b-4b0a-93c2-65c6a1a62fcb','2021-12-10 13:53:55'),(3,'148ab8de-7fa6-4388-9982-dd1dc536091f','2bf17da1-2bd8-412a-acb3-638f2ce2d508','2021-12-10 13:53:55'),(3,'148ab8de-7fa6-4388-9982-dd1dc536091f','2e779ae0-691f-413a-b2b7-c5516bb4357e','2021-12-10 13:53:55'),(3,'148ab8de-7fa6-4388-9982-dd1dc536091f','3bb0340b-c13a-4632-8cc0-f16aeda43252','2021-12-10 13:53:55'),(3,'148ab8de-7fa6-4388-9982-dd1dc536091f','7738e4ec-b2c9-465c-a9b7-71d77c2a1c91','2021-12-10 13:53:55'),(3,'148ab8de-7fa6-4388-9982-dd1dc536091f','82870def-459f-430b-a808-fc1b88e3fc29','2021-12-10 13:53:55'),(3,'148ab8de-7fa6-4388-9982-dd1dc536091f','a750cc3c-58c8-495f-9661-a40e2bf96037','2021-12-10 13:53:55'),(3,'148ab8de-7fa6-4388-9982-dd1dc536091f','e6376a68-cf36-436d-8e75-85d45fd650b3','2021-12-10 13:53:55'),(3,'89776b11-d1ce-4070-89ab-77be21b5a063','2bf17da1-2bd8-412a-acb3-638f2ce2d508','2021-12-10 13:53:55'),(3,'89776b11-d1ce-4070-89ab-77be21b5a063','2e779ae0-691f-413a-b2b7-c5516bb4357e','2021-12-10 13:53:55'),(3,'89776b11-d1ce-4070-89ab-77be21b5a063','6b3439e3-43cd-441d-a50e-cd456df457c1','2021-12-10 13:53:55'),(3,'89776b11-d1ce-4070-89ab-77be21b5a063','7738e4ec-b2c9-465c-a9b7-71d77c2a1c91','2021-12-10 13:53:55'),(3,'89776b11-d1ce-4070-89ab-77be21b5a063','82870def-459f-430b-a808-fc1b88e3fc29','2021-12-10 13:53:55'),(3,'89776b11-d1ce-4070-89ab-77be21b5a063','a750cc3c-58c8-495f-9661-a40e2bf96037','2021-12-10 13:53:55'),(3,'89776b11-d1ce-4070-89ab-77be21b5a063','e28deca9-9a33-4f4a-a764-0a13a3305f4b','2021-12-10 13:53:55'),(3,'89776b11-d1ce-4070-89ab-77be21b5a063','e6376a68-cf36-436d-8e75-85d45fd650b3','2021-12-10 13:53:55'),(3,'ba6724d6-e1a0-440b-83fc-d6d4deea9e52','1838e490-b32b-4dbb-a741-2b78c171c383','2021-12-10 13:53:55'),(3,'ba6724d6-e1a0-440b-83fc-d6d4deea9e52','4211d279-56a3-454f-b752-6eaa303f7ee6','2021-12-10 13:53:55'),(3,'ba6724d6-e1a0-440b-83fc-d6d4deea9e52','647a36c9-483d-45d7-8671-52befd2d43a4','2021-12-10 13:53:55'),(163,'09eb132c-5b8e-4d92-9a94-a305e9f53d43','0739d8ee-2b14-4370-a430-8495fec0feec','2019-09-05 18:06:30'),(163,'09eb132c-5b8e-4d92-9a94-a305e9f53d43','1d94168f-dde9-4b67-80b3-e774e27517e6','2019-09-05 18:06:30'),(163,'09eb132c-5b8e-4d92-9a94-a305e9f53d43','4ac1bde3-ded4-41d1-83a4-46e496e8b5cd','2019-09-05 18:06:30'),(163,'09eb132c-5b8e-4d92-9a94-a305e9f53d43','6c1402f2-cd34-461f-8bcd-719448b12370','2019-09-05 18:06:30'),(163,'09eb132c-5b8e-4d92-9a94-a305e9f53d43','78dbcda8-e113-49fc-942b-1ead943195ae','2019-09-05 18:06:30'),(163,'09eb132c-5b8e-4d92-9a94-a305e9f53d43','7d9bfb0d-1cae-4e52-947a-72ab21c7f74c','2019-09-05 18:06:30'),(163,'09eb132c-5b8e-4d92-9a94-a305e9f53d43','87144a98-d15e-4dc3-bcb4-339cd6015590','2019-09-05 18:06:30'),(163,'09eb132c-5b8e-4d92-9a94-a305e9f53d43','9a1535dd-b5a7-41f8-9557-b243a7f416e4','2019-09-05 18:06:30'),(163,'09eb132c-5b8e-4d92-9a94-a305e9f53d43','a26c62ea-7c34-452d-88cf-9d144550ec86','2019-09-05 18:06:30'),(163,'09eb132c-5b8e-4d92-9a94-a305e9f53d43','a9a24eec-ed31-4ca3-a322-e55a79a15bdc','2019-09-05 18:06:30'),(163,'09eb132c-5b8e-4d92-9a94-a305e9f53d43','b6c5bbd3-6387-4b17-84ec-098c0020c139','2019-09-05 18:06:30'),(163,'09eb132c-5b8e-4d92-9a94-a305e9f53d43','bd9bacc0-d27a-486b-bc53-bd6172d5cd80','2019-09-05 18:06:30'),(163,'09eb132c-5b8e-4d92-9a94-a305e9f53d43','be2ca89b-1f70-4164-b966-0516457b5506','2019-09-05 18:06:30'),(163,'09eb132c-5b8e-4d92-9a94-a305e9f53d43','c450cf2f-ec8e-4cb7-aa0a-e3d9d5c0fd05','2019-09-05 18:06:30'),(163,'09eb132c-5b8e-4d92-9a94-a305e9f53d43','d5c7e23c-4a05-472b-bef5-950b733bfab5','2019-09-05 18:06:30'),(163,'09eb132c-5b8e-4d92-9a94-a305e9f53d43','dd651c32-5d3b-4598-bb9f-7e028160d5fd','2019-09-05 18:06:30'),(163,'09eb132c-5b8e-4d92-9a94-a305e9f53d43','df8fd6d6-4a11-4757-b046-a7ffa9a05eab','2019-09-05 18:06:30'),(163,'0b66c392-8355-4d7d-b61e-3437910c35b6','0b57b957-257f-4fef-8207-bfd0571938b5','2019-09-19 09:18:21'),(163,'0b66c392-8355-4d7d-b61e-3437910c35b6','0d5f673d-1e06-4c82-b781-3166313d5ca7','2019-09-19 09:18:21'),(163,'0b66c392-8355-4d7d-b61e-3437910c35b6','29b0101d-6385-4e7a-9086-253fdc351d02','2019-09-19 09:18:21'),(163,'0b66c392-8355-4d7d-b61e-3437910c35b6','4d7867b4-9f52-49a2-88c8-83c3d4865095','2019-09-19 09:18:21'),(163,'0b66c392-8355-4d7d-b61e-3437910c35b6','50fdd65d-7e14-48e2-a3ca-6a69a2a4ec71','2019-09-19 09:18:21'),(163,'0b66c392-8355-4d7d-b61e-3437910c35b6','64286f64-d288-471b-8ab7-0fa381df35a6','2019-09-19 09:18:21'),(163,'0b66c392-8355-4d7d-b61e-3437910c35b6','a875f57f-7f35-4ffb-ac85-18b73e5cda0e','2019-09-19 09:18:21'),(163,'0b66c392-8355-4d7d-b61e-3437910c35b6','af3275fd-de94-4563-a07f-efe7b8ecf1f4','2019-09-19 09:18:21'),(163,'0b66c392-8355-4d7d-b61e-3437910c35b6','c8c830ba-cf40-40b0-b6b7-7194b746c2a2','2019-09-19 09:18:21'),(163,'0b66c392-8355-4d7d-b61e-3437910c35b6','e34bd481-90b0-47c9-9f3b-8114fff93036','2019-09-19 09:18:21'),(163,'0b66c392-8355-4d7d-b61e-3437910c35b6','e718ad91-2aab-4430-9ea9-5014c920299b','2019-09-19 09:18:21'),(163,'9e71a078-d9db-473d-a3ca-f2acffb3ee48','0aa71ebb-4833-4dfd-bf99-5158c2d6b79f','2019-10-09 18:32:18'),(163,'9e71a078-d9db-473d-a3ca-f2acffb3ee48','49fa018c-a1f8-41c3-89ca-42d90f70b465','2019-10-09 18:32:18'),(163,'9e71a078-d9db-473d-a3ca-f2acffb3ee48','4b5f064c-9285-4119-bc00-8e7a6dd729b0','2019-10-09 18:32:18'),(163,'9e71a078-d9db-473d-a3ca-f2acffb3ee48','56264e08-ee06-4c6f-8e9b-6d38cc8530b1','2019-10-09 18:32:18'),(163,'9e71a078-d9db-473d-a3ca-f2acffb3ee48','5c5378c6-f77b-4b5d-a2dc-e7d066bcf273','2019-10-09 18:32:18'),(163,'9e71a078-d9db-473d-a3ca-f2acffb3ee48','67349e8c-f1af-4275-9741-d8f70cb19787','2019-10-09 18:32:18'),(163,'9e71a078-d9db-473d-a3ca-f2acffb3ee48','67f86da1-b93d-49a5-b128-ce4b4dbba427','2019-10-09 18:32:18'),(163,'9e71a078-d9db-473d-a3ca-f2acffb3ee48','762a3b6d-dc65-4c0f-b252-3f012d6880ed','2019-10-09 18:32:18'),(163,'9e71a078-d9db-473d-a3ca-f2acffb3ee48','7a9749e4-92f4-4da4-8285-8bfcc18562dc','2019-10-09 18:32:18'),(163,'9e71a078-d9db-473d-a3ca-f2acffb3ee48','9273720b-56c3-415c-b28e-0440361cecc8','2019-10-09 18:32:18'),(163,'9e71a078-d9db-473d-a3ca-f2acffb3ee48','a4fe9afa-c87f-4755-8881-cbd8df0e865e','2019-10-09 18:32:18'),(163,'9e71a078-d9db-473d-a3ca-f2acffb3ee48','b6865a4a-2933-4ddf-a792-1aa292359fd7','2019-10-09 18:32:18'),(163,'9e71a078-d9db-473d-a3ca-f2acffb3ee48','bcc65d9e-d6ca-49f2-aa48-b84ef943291b','2019-10-09 18:32:18'),(163,'9e71a078-d9db-473d-a3ca-f2acffb3ee48','d303cf66-8219-41f9-ac8a-a9a6d81f0e51','2019-10-09 18:32:18'),(163,'9e71a078-d9db-473d-a3ca-f2acffb3ee48','e0be079b-af79-44e4-9464-46d48246ee2e','2019-10-09 18:32:18'),(163,'9e71a078-d9db-473d-a3ca-f2acffb3ee48','e8dadd53-f8a7-4cee-9109-41034eca20e6','2019-10-09 18:32:18'),(163,'9e71a078-d9db-473d-a3ca-f2acffb3ee48','f562c1d5-8b9d-40d0-82b2-c5ca1efb8991','2019-10-09 18:32:18'),(163,'bba92c3d-5b82-4abb-8e9e-3df91aea60e0','0aa71ebb-4833-4dfd-bf99-5158c2d6b79f','2019-10-09 18:32:10'),(163,'bba92c3d-5b82-4abb-8e9e-3df91aea60e0','2b2da34e-40de-4eec-97e1-03189a8ce722','2019-10-09 18:32:10'),(163,'bba92c3d-5b82-4abb-8e9e-3df91aea60e0','49fa018c-a1f8-41c3-89ca-42d90f70b465','2019-10-09 18:32:10'),(163,'bba92c3d-5b82-4abb-8e9e-3df91aea60e0','4b5f064c-9285-4119-bc00-8e7a6dd729b0','2019-10-09 18:32:10'),(163,'bba92c3d-5b82-4abb-8e9e-3df91aea60e0','56264e08-ee06-4c6f-8e9b-6d38cc8530b1','2019-10-09 18:32:10'),(163,'bba92c3d-5b82-4abb-8e9e-3df91aea60e0','5c5378c6-f77b-4b5d-a2dc-e7d066bcf273','2019-10-09 18:32:10'),(163,'bba92c3d-5b82-4abb-8e9e-3df91aea60e0','67349e8c-f1af-4275-9741-d8f70cb19787','2019-10-09 18:32:10'),(163,'bba92c3d-5b82-4abb-8e9e-3df91aea60e0','762a3b6d-dc65-4c0f-b252-3f012d6880ed','2019-10-09 18:32:10'),(163,'bba92c3d-5b82-4abb-8e9e-3df91aea60e0','7a9749e4-92f4-4da4-8285-8bfcc18562dc','2019-10-09 18:32:10'),(163,'bba92c3d-5b82-4abb-8e9e-3df91aea60e0','9273720b-56c3-415c-b28e-0440361cecc8','2019-10-09 18:32:10'),(163,'bba92c3d-5b82-4abb-8e9e-3df91aea60e0','a4fe9afa-c87f-4755-8881-cbd8df0e865e','2019-10-09 18:32:10'),(163,'bba92c3d-5b82-4abb-8e9e-3df91aea60e0','b6865a4a-2933-4ddf-a792-1aa292359fd7','2019-10-09 18:32:10'),(163,'bba92c3d-5b82-4abb-8e9e-3df91aea60e0','bcc65d9e-d6ca-49f2-aa48-b84ef943291b','2019-10-09 18:32:10'),(163,'bba92c3d-5b82-4abb-8e9e-3df91aea60e0','d303cf66-8219-41f9-ac8a-a9a6d81f0e51','2019-10-09 18:32:10'),(163,'bba92c3d-5b82-4abb-8e9e-3df91aea60e0','e8dadd53-f8a7-4cee-9109-41034eca20e6','2019-10-09 18:32:10'),(163,'bba92c3d-5b82-4abb-8e9e-3df91aea60e0','f562c1d5-8b9d-40d0-82b2-c5ca1efb8991','2019-10-09 18:32:10'),(163,'bba92c3d-5b82-4abb-8e9e-3df91aea60e0','fbab7ba4-a3c0-48ba-8117-a5a0a91d6163','2019-10-09 18:32:10');
/*!40000 ALTER TABLE `SentAttachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SentMessage`
--

DROP TABLE IF EXISTS `SentMessage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SentMessage` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `created` datetime DEFAULT NULL,
  `subject` varchar(45) NOT NULL,
  `body` text,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `discussionID` char(36) NOT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_SentMessage_Discussion` (`discussionID`,`ownerID`),
  CONSTRAINT `fk_SentMessage_Discussion` FOREIGN KEY (`discussionID`, `ownerID`) REFERENCES `Discussion` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SentMessage`
--

LOCK TABLES `SentMessage` WRITE;
/*!40000 ALTER TABLE `SentMessage` DISABLE KEYS */;
INSERT INTO `SentMessage` VALUES (163,'09eb132c-5b8e-4d92-9a94-a305e9f53d43','2019-09-05 20:06:30','#','Commande n° 1.14.1.1',NULL,'2019-10-10 11:01:36','2019-10-10 09:01:36','2019-09-05 20:06:30','0581f1c1-e4ed-403d-93da-e75cb19e55cd'),(163,'0b66c392-8355-4d7d-b61e-3437910c35b6','2019-09-19 11:18:21','#','Commande n° 1.15.1.1',NULL,'2019-10-10 11:01:36','2019-10-10 09:01:36','2019-09-19 11:18:21','0581f1c1-e4ed-403d-93da-e75cb19e55cd'),(3,'148ab8de-7fa6-4388-9982-dd1dc536091f','2019-07-08 15:35:54','#','Commande n° 2.2.2.2',NULL,'2019-07-08 19:44:58','2019-07-08 17:44:58','2019-07-08 15:35:54','88f8c70c-bd90-4787-bf46-0897cd968fca'),(3,'89776b11-d1ce-4070-89ab-77be21b5a063','2019-07-08 15:35:21','#','Commande n° 2.2.2.1',NULL,'2019-07-08 15:35:23','2019-07-08 13:35:23','2019-07-08 15:35:21','605c208e-ad38-4268-a678-5f04c6f9007f'),(163,'9e71a078-d9db-473d-a3ca-f2acffb3ee48','2019-10-09 20:32:18','#','Commande n° 1.16.1.1',NULL,'2019-10-10 11:01:36','2019-10-10 09:01:36','2019-10-09 20:32:18','0581f1c1-e4ed-403d-93da-e75cb19e55cd'),(3,'ba6724d6-e1a0-440b-83fc-d6d4deea9e52','2019-07-03 17:32:34','#','#',NULL,'2019-07-03 09:33:20','2019-07-03 07:33:20','2019-07-03 17:32:34','605c208e-ad38-4268-a678-5f04c6f9007f'),(163,'bba92c3d-5b82-4abb-8e9e-3df91aea60e0','2019-10-09 20:32:10','#','Commande n° 1.16.1.2',NULL,'2019-10-10 11:01:36','2019-10-10 09:01:36','2019-10-09 20:32:10','0581f1c1-e4ed-403d-93da-e75cb19e55cd');
/*!40000 ALTER TABLE `SentMessage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SentOrderNotification`
--

DROP TABLE IF EXISTS `SentOrderNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SentOrderNotification` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `orderID` char(36) DEFAULT NULL,
  `recipientID` char(36) DEFAULT NULL,
  `rescueData` text,
  `deliveryDate` datetime DEFAULT NULL,
  `event` enum('edited','validated','cancelled') NOT NULL DEFAULT 'edited',
  `unread` tinyint(1) NOT NULL DEFAULT '1',
  `createdAt` datetime NOT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_SentOrderNotification_Professional` (`ownerID`),
  KEY `fk_SentOrderNotification_Contact` (`recipientID`,`ownerID`),
  KEY `fk_SentOrderNotification_ProstheticOrder` (`orderID`,`ownerID`),
  CONSTRAINT `fk_SentOrderNotification_Contact` FOREIGN KEY (`recipientID`, `ownerID`) REFERENCES `Contact` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_SentOrderNotification_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_SentOrderNotification_ProstheticOrder` FOREIGN KEY (`orderID`, `ownerID`) REFERENCES `ProstheticOrder` (`id`, `ownerID`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SentOrderNotification`
--

LOCK TABLES `SentOrderNotification` WRITE;
/*!40000 ALTER TABLE `SentOrderNotification` DISABLE KEYS */;
INSERT INTO `SentOrderNotification` VALUES (163,'5848cfcf-13ea-4cc3-a785-f2205f4fefbc','0f0915f0-d99f-401f-bc07-6de3f1346d65','9460e697-c2bc-4e3d-9c13-755611df8866','{\"recipientDisplayName\":\"Bienfait Laboratoire\",\"patientDisplayID\":\"1.16\",\"orderTitle\":\"COURONNE SUR IMPLANT\",\"sheetType\":\"COURONNE_SUR_IMPLANT\"}','2019-10-10 00:00:01','validated',0,'2019-10-10 11:05:41',NULL,'2019-12-10 21:06:10','2019-12-10 21:06:09','2019-12-10 20:06:10'),(163,'b99daa01-8162-42e0-896c-478d37dff55f','816f04b9-978f-4f25-b999-b4179ef17116','9460e697-c2bc-4e3d-9c13-755611df8866','{\"recipientDisplayName\":\"Bienfait Laboratoire\",\"patientDisplayID\":\"1.14\",\"orderTitle\":\"INLAY ONLAY\",\"sheetType\":\"INLAY_ONLAY\"}','2019-09-06 00:00:01','validated',0,'2019-09-26 11:13:39',NULL,'2019-10-09 20:38:37','2019-10-09 20:38:36','2019-10-09 18:38:37'),(163,'c358de26-37b1-44e0-ba02-33658aba52b2','2d03e092-9432-42e7-80e7-c4b571887fa6','9460e697-c2bc-4e3d-9c13-755611df8866','{\"recipientDisplayName\":\"Bienfait Laboratoire\",\"patientDisplayID\":\"1.15\",\"orderTitle\":\"INLAY ONLAY\",\"sheetType\":\"INLAY_ONLAY\"}','2019-09-20 00:00:01','validated',0,'2019-09-24 11:36:21',NULL,'2019-10-09 20:38:37','2019-10-09 20:38:36','2019-10-09 18:38:37'),(163,'d168a580-2268-4aca-803a-4063c3d8796d','2365cac3-5051-47bd-98df-b6ee18e8b8a6','9460e697-c2bc-4e3d-9c13-755611df8866','{\"recipientDisplayName\":\"Bienfait Laboratoire\",\"patientDisplayID\":\"1.16\",\"orderTitle\":\"INLAY CORE\",\"sheetType\":\"INLAY_CORE\"}','2019-10-10 00:00:01','validated',0,'2019-10-23 17:40:34',NULL,'2019-12-10 21:06:10','2019-12-10 21:06:09','2019-12-10 20:06:10');
/*!40000 ALTER TABLE `SentOrderNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Session`
--

DROP TABLE IF EXISTS `Session`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Session` (
  `ownerID` mediumint unsigned NOT NULL DEFAULT '0',
  `id` char(36) NOT NULL,
  `comments` mediumtext,
  `actID` char(36) NOT NULL,
  `globalDisplayID` mediumint unsigned DEFAULT NULL,
  `displayID` mediumint unsigned DEFAULT NULL,
  `mandibuleOcclusionPlyID` char(36) DEFAULT NULL,
  `maxillaireOcclusionPlyID` char(36) DEFAULT NULL,
  `matrixTransformationMandibuleID` char(36) DEFAULT NULL,
  `matrixTransformationMaxillaireID` char(36) DEFAULT NULL,
  `snapshotID` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `createdAt` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Occlusion_Work` (`actID`,`ownerID`),
  KEY `fk_Occlusion_CondorFile_mandibulePly` (`mandibuleOcclusionPlyID`,`ownerID`),
  KEY `fk_Occlusion_CondorFile_mandibuleStl` (`ownerID`),
  KEY `fk_Occlusion_CondorFile_matrixTransformationMandibule` (`matrixTransformationMandibuleID`,`ownerID`),
  KEY `fk_Occlusion_CondorFile_mandibulePointContact` (`ownerID`),
  KEY `fk_Occlusion_CondorFile_maxillairePly` (`maxillaireOcclusionPlyID`,`ownerID`),
  KEY `fk_Occlusion_CondorFile_maxillaireStl` (`ownerID`),
  KEY `fk_Occlusion_CondorFile_matrixTransformationMaxillaire` (`matrixTransformationMaxillaireID`,`ownerID`),
  KEY `fk_Occlusion_CondorFile_maxillairePointContact` (`ownerID`),
  KEY `fk_Occlusion_CondorFile_snapshot` (`snapshotID`,`ownerID`),
  CONSTRAINT `fk_Session_Act` FOREIGN KEY (`actID`, `ownerID`) REFERENCES `Act` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Session_CondorFile_mandibulePly` FOREIGN KEY (`mandibuleOcclusionPlyID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Session_CondorFile_matrixTransformationMandibule` FOREIGN KEY (`matrixTransformationMandibuleID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Session_CondorFile_matrixTransformationMaxillaire` FOREIGN KEY (`matrixTransformationMaxillaireID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Session_CondorFile_maxillairePly` FOREIGN KEY (`maxillaireOcclusionPlyID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Session_CondorFile_snapshot` FOREIGN KEY (`snapshotID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Session`
--

LOCK TABLES `Session` WRITE;
/*!40000 ALTER TABLE `Session` DISABLE KEYS */;
INSERT INTO `Session` VALUES (163,'05363e68-a254-4acc-8205-219c338c6ba1','Sous dossier 1','bc3db4c6-a79c-4ab4-a006-4f82c00387c4',1,1,NULL,NULL,NULL,NULL,NULL,'2022-02-12 16:36:13','2021-12-16 22:51:47','2022-02-12 15:36:13','2021-12-16 22:51:46','2021-12-16 22:37:07'),(163,'0ab26869-22f4-4b5a-8839-9959ad9c0318','Sous dossier 1','d602bcde-28c7-42bd-90b2-813d264ff6a5',1,1,NULL,NULL,NULL,NULL,NULL,'2020-04-30 11:53:44',NULL,'2020-04-30 09:53:44','2020-01-24 10:12:51','2020-01-24 10:12:51'),(163,'11be814f-456b-4d24-997e-2f1d8310fc14','Sous dossier 1','0816b184-9799-4efa-a263-841dc64405d0',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2019-09-05 15:02:34','2019-09-05 13:02:34','2019-09-05 15:02:33','2019-08-27 14:37:01'),(163,'1440795e-2881-4afb-8ab2-894ee1f45534','Sous dossier 1','7c797d57-e5c3-461e-83aa-0572f4d928dd',1,1,NULL,NULL,NULL,NULL,NULL,'2020-04-30 11:53:44',NULL,'2020-04-30 09:53:44','2019-07-26 15:34:18','2019-08-07 10:01:48'),(163,'195bfb04-640f-4899-8e7e-6bbc10695cc3','Sous dossier 3','97e5ae19-9444-4dd2-9134-8f61d8d268df',1,3,NULL,NULL,NULL,NULL,NULL,NULL,'2022-11-08 22:47:41','2022-11-08 21:47:41','2022-11-08 22:47:40','2022-11-08 22:47:40'),(163,'26578904-6388-4b67-926c-fa9cede7abea','Sous dossier 1','208338ea-2209-4f7c-ad22-9db0447ff940',1,1,NULL,NULL,NULL,NULL,NULL,'2020-04-30 11:53:44',NULL,'2020-04-30 09:53:44','2017-11-30 17:48:44','2019-08-07 10:01:48'),(163,'2aa32ab4-f951-4bdb-bc1b-b3dbf0587866','Sous dossier 1','42afb509-9a10-464d-a838-9efc02a03458',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-17 11:21:13','2020-02-17 10:21:13','2020-01-30 12:47:25','2020-01-30 12:47:25'),(163,'2c9b2990-8860-4259-b919-67aa71e0b43f','Sous dossier 1','ce36d71d-debf-4f14-bbe8-30830b342bd3',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2019-08-07 10:12:49','2019-08-07 08:12:49','2017-11-30 17:48:44','2019-08-07 10:01:48'),(163,'527d2f94-918c-4936-9bf1-b8feaa69d1a1','Sous dossier 1','8ba0980a-f3b0-4678-95c3-5866f7faa344',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2019-08-07 10:12:47','2019-08-07 08:12:47','2019-07-26 15:35:18','2019-08-07 10:01:48'),(1,'669bd839-b35f-4277-b25e-d33767724d18','Dossier empreintes','99140e2a-6c40-4cec-8b61-6b676b8308a5',8,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2017-11-30 16:48:44','2017-11-30 17:48:44','2019-08-07 10:01:48'),(163,'6b48d741-5054-47fb-94d3-450e0ee64498','Sous dossier 1','b5113824-905e-4f98-a455-48450edf42fe',1,1,NULL,NULL,NULL,NULL,NULL,'2020-04-30 11:53:44',NULL,'2020-04-30 09:53:44','2018-06-26 17:06:34','2019-08-07 10:01:48'),(163,'6e0b4165-03cb-4f3b-bd97-fca211c1fe33','Sous dossier 1','4252a7af-d6d9-4447-b402-60820076dceb',1,1,NULL,NULL,NULL,NULL,NULL,'2020-04-30 11:53:44','2019-08-20 15:37:23','2020-04-30 09:53:44','2019-08-20 15:37:23','2019-08-20 15:27:07'),(163,'6fc763b3-a841-4131-83ee-4b1670fa870e','Sous dossier 2','97e5ae19-9444-4dd2-9134-8f61d8d268df',1,2,NULL,NULL,NULL,NULL,NULL,NULL,'2022-02-12 15:49:45','2022-02-12 14:49:45','2022-02-12 15:49:43','2022-02-12 15:49:43'),(163,'74ab0e98-70f9-437f-98be-f8c8058c9304','Sous dossier 1','c2ba8e83-c45e-4afb-a56d-642916e2bc25',1,1,NULL,NULL,NULL,NULL,NULL,'2020-04-30 11:53:44',NULL,'2020-04-30 09:53:44','2017-11-30 17:48:44','2019-08-07 10:01:48'),(163,'7560d619-3fa6-414c-85d8-52a724ef7bf4','Sous dossier 1','1a37c2d2-e6a1-4863-8afb-27944d3a7e33',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-17 12:03:03','2020-02-17 11:03:03','2020-02-17 12:03:03','2020-02-17 11:34:29'),(163,'845f7824-4df1-486f-a131-1ffd2a0d900c','Sous dossier 2','0816b184-9799-4efa-a263-841dc64405d0',1,2,NULL,NULL,NULL,NULL,NULL,NULL,'2019-08-27 14:51:10','2019-08-27 12:51:10','2019-08-27 14:51:10','2019-08-27 14:51:10'),(163,'85186f51-753c-498e-8346-beea8a780c7b','Sous dossier 1','97e5ae19-9444-4dd2-9134-8f61d8d268df',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2022-11-08 22:49:11','2022-11-08 21:49:11','2022-11-08 22:49:11','2022-02-12 15:04:53'),(163,'8e5a7622-07fe-459d-b08c-003178dd5d76','Sous dossier 2','7c797d57-e5c3-461e-83aa-0572f4d928dd',1,2,NULL,NULL,NULL,NULL,NULL,'2020-04-30 11:53:44',NULL,'2020-04-30 09:53:44','2019-07-26 15:34:28','2019-08-07 10:01:48'),(163,'92b33516-ba42-40bc-80ec-77c62a130f93','Sous dossier 1','54e4e76a-88ec-47fe-8787-b7d925a5a345',1,1,'78dbcda8-e113-49fc-942b-1ead943195ae','df8fd6d6-4a11-4757-b046-a7ffa9a05eab','b6c5bbd3-6387-4b17-84ec-098c0020c139','c450cf2f-ec8e-4cb7-aa0a-e3d9d5c0fd05','d5c7e23c-4a05-472b-bef5-950b733bfab5',NULL,'2019-09-05 20:12:12','2019-09-05 18:12:12','2019-09-05 20:12:12','2019-08-28 19:37:58'),(163,'959392d0-b14f-4c07-bf36-75b2e165b77a','Sous dossier 2','3ae0c9b4-944b-4732-8dff-c023398bb119',1,2,NULL,NULL,NULL,NULL,NULL,NULL,'2019-09-05 15:02:43','2019-09-05 13:02:43','2019-09-05 15:02:43','2019-08-26 18:31:35'),(163,'9f7449d6-1278-45d5-9492-02cd28be29ca','Sous dossier 2','4829e17a-6262-4322-bd2d-12f3055adf7d',1,2,NULL,NULL,NULL,NULL,NULL,'2020-04-30 11:53:44','2019-08-20 15:25:19','2020-04-30 09:53:44','2019-08-20 15:25:18','2019-08-20 14:33:23'),(163,'a28eb91b-4a0f-4d12-b29c-dd3f3c9d6c5f','Sous dossier 3','0816b184-9799-4efa-a263-841dc64405d0',1,3,NULL,NULL,NULL,NULL,NULL,NULL,'2019-09-19 11:13:40','2019-09-19 09:13:40','2019-09-19 11:12:44','2019-08-27 14:51:12'),(163,'a53c56e5-88df-4213-95fa-5e72bf6599b9','Sous dossier 1','87eba16d-aff7-41e9-9637-bf09b56f1030',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2021-12-16 22:25:57','2021-12-16 21:25:57','2021-04-11 12:25:10','2021-04-11 10:03:46'),(3,'a7c88910-fd78-423e-b163-7de9e0328a4d','Sous dossier 1','81146ef5-a63c-4e0a-9164-e233746442ae',18,1,NULL,NULL,NULL,NULL,NULL,NULL,'2021-12-10 14:54:01','2021-12-10 13:54:01','2021-12-10 14:54:00','2021-12-10 14:54:00'),(163,'a8dad053-002c-407d-875a-1d0fe8c5e10f','Sous dossier 1','7c5c9390-023c-4e0d-a61e-ae3e13c7e8f7',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2022-03-26 15:42:14','2022-03-26 14:42:14','2022-03-26 15:42:13','2022-03-26 14:56:13'),(163,'aa101222-6e4e-4d52-97cc-39e34711339f','Sous dossier 1','c88b02dd-0888-4d7e-b3d5-66d58b9cf56a',1,1,NULL,NULL,NULL,NULL,NULL,'2020-04-30 11:53:44','2019-08-20 15:26:39','2020-04-30 09:53:44','2019-08-20 15:26:38','2019-08-20 15:25:40'),(163,'ae07c5e5-6b65-46ef-9cd1-c0a9daccea5f','Sous dossier 1','1ff39b04-4666-4c18-afaa-74990cd38521',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2019-09-24 11:34:59','2019-09-24 09:34:59','2019-09-24 11:34:10','2019-09-18 15:13:21'),(163,'b7af3319-ea25-4bb9-bb0f-24b87515d047','Sous dossier 1','3ae0c9b4-944b-4732-8dff-c023398bb119',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2019-08-26 18:31:11','2019-08-26 16:31:11','2019-08-26 18:31:10','2019-08-26 18:31:10'),(163,'be8b17ea-1f2d-4455-823c-87f31acb59e4','Sous dossier 1','4829e17a-6262-4322-bd2d-12f3055adf7d',1,1,NULL,NULL,NULL,NULL,NULL,'2020-04-30 11:53:44','2019-08-20 15:37:39','2020-04-30 09:53:44','2019-08-20 15:37:39','2019-08-20 14:24:18'),(163,'c2195287-5f39-4a66-93d5-5b83792fc9a8','Sous dossier 1','692fa6c8-2523-4d56-bebf-b736f05db142',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2019-10-14 13:02:19','2019-10-14 11:02:19','2019-10-14 13:02:12','2019-10-14 12:42:45'),(163,'d0e25f50-d624-467e-9ec5-62f18f66d406','Sous dossier 1','bc55b8f5-e548-4538-975e-99c4c5e0df82',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2019-10-09 20:37:51','2019-10-09 18:37:51','2019-10-09 20:37:51','2019-10-09 19:17:00'),(163,'e0033e76-2425-4808-90ae-56e261aeec29','Sous dossier 1','cf18f1d7-15eb-478c-9049-91f184fe0fc4',1,1,NULL,NULL,NULL,NULL,NULL,'2020-04-30 11:53:44',NULL,'2020-04-30 09:53:44','2019-07-26 15:34:01','2019-08-07 10:01:48'),(163,'ea11a5f6-aafe-41d9-b61b-f8b13f045b1e','Dossier empreintes','78f19188-19ad-480e-8d99-35699a9590fa',1,1,NULL,NULL,NULL,NULL,NULL,'2020-04-30 11:53:44','2019-08-20 14:18:18','2020-04-30 09:53:44','2017-11-30 17:48:44','2019-08-07 10:01:48');
/*!40000 ALTER TABLE `Session` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SharedOffices`
--

DROP TABLE IF EXISTS `SharedOffices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SharedOffices` (
  `ownerID` mediumint unsigned NOT NULL,
  `office1ID` char(36) NOT NULL,
  `office2ID` char(36) NOT NULL,
  `sharedDataType` enum('ALL','CONTACTS') NOT NULL DEFAULT 'CONTACTS',
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  PRIMARY KEY (`office1ID`,`office2ID`,`ownerID`),
  KEY `fk_SharedOffices_Office_1` (`office1ID`,`ownerID`),
  KEY `fk_SharedOffices_Office_2` (`office2ID`,`ownerID`),
  CONSTRAINT `fk_SharedOffices_Office_1` FOREIGN KEY (`office1ID`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_SharedOffices_Office_2` FOREIGN KEY (`office2ID`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SharedOffices`
--

LOCK TABLES `SharedOffices` WRITE;
/*!40000 ALTER TABLE `SharedOffices` DISABLE KEYS */;
/*!40000 ALTER TABLE `SharedOffices` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `SharedOffices_BEFORE_INSERT` BEFORE INSERT ON `SharedOffices` FOR EACH ROW BEGIN
    IF EXISTS (
		SELECT 1 FROM SharedOffices WHERE
		(office1ID=NEW.office2ID AND office2ID=NEW.office1ID)
		OR
		(office1ID=NEW.office1ID AND office2ID=NEW.office2ID)
	) THEN
        SIGNAL SQLSTATE '45000' SET MESSAGE_TEXT = 'Try to insert an existing pair of keys';
    END IF;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `SmilersOrder`
--

DROP TABLE IF EXISTS `SmilersOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SmilersOrder` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `actID` char(36) NOT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `title` varchar(64) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `status` enum('not_sent','waiting_wow_api','sending_wow_api','sending_smilers_api','sent','cancelled') NOT NULL DEFAULT 'waiting_wow_api',
  `createdAt` datetime NOT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `json` text NOT NULL,
  `metadata` text NOT NULL,
  `tag` varchar(250) DEFAULT NULL,
  `localDisplayID` int unsigned DEFAULT NULL,
  `globalDisplayID` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_SmilersOrder_Act` (`actID`,`ownerID`),
  CONSTRAINT `fk_SmilersOrder_Act` FOREIGN KEY (`actID`, `ownerID`) REFERENCES `Act` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SmilersOrder`
--

LOCK TABLES `SmilersOrder` WRITE;
/*!40000 ALTER TABLE `SmilersOrder` DISABLE KEYS */;
/*!40000 ALTER TABLE `SmilersOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SmilersOrderFile`
--

DROP TABLE IF EXISTS `SmilersOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SmilersOrderFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `orderID` char(36) NOT NULL,
  `fileID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`orderID`,`fileID`),
  KEY `fk_SmilersOrderFile_SmilersOrder` (`orderID`,`ownerID`),
  KEY `fk_SmilersOrderFile_CondorFile` (`fileID`,`ownerID`),
  CONSTRAINT `fk_SmilersOrderFile_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_SmilersOrderFile_SmilersOrder` FOREIGN KEY (`orderID`, `ownerID`) REFERENCES `SmilersOrder` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SmilersOrderFile`
--

LOCK TABLES `SmilersOrderFile` WRITE;
/*!40000 ALTER TABLE `SmilersOrderFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `SmilersOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SyncInfo`
--

DROP TABLE IF EXISTS `SyncInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SyncInfo` (
  `id` mediumint unsigned NOT NULL,
  `ownerID` mediumint unsigned NOT NULL,
  `patientsLastRetrieved` datetime DEFAULT NULL,
  `actsLastRetrieved` datetime DEFAULT NULL,
  `sessionsLastRetrieved` datetime DEFAULT NULL,
  `scansLastRetrieved` datetime DEFAULT NULL,
  `ordersLastRetrieved` datetime DEFAULT NULL,
  `assistantsLastRetrieved` datetime DEFAULT NULL,
  `contactsLastRetrieved` datetime DEFAULT NULL,
  `discussionsLastRetrieved` datetime DEFAULT NULL,
  `messagesLastRetrieved` datetime DEFAULT NULL,
  `notificationsLastRetrieved` datetime DEFAULT NULL,
  `occlusionsLastRetrieved` datetime DEFAULT NULL,
  `circleordersLastRetrieved` datetime DEFAULT NULL,
  `smilersordersLastRetrieved` datetime DEFAULT NULL,
  `prostheticSheetsLastRetrieved` datetime DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `idx_SyncInfo_Professional` (`ownerID`),
  CONSTRAINT `fk_SyncInfo_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SyncInfo`
--

LOCK TABLES `SyncInfo` WRITE;
/*!40000 ALTER TABLE `SyncInfo` DISABLE KEYS */;
INSERT INTO `SyncInfo` VALUES (1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,8,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,11,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,26,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,27,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,41,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,46,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,60,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,61,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,63,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,64,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,65,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,89,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,101,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,106,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,163,'2020-02-17 11:54:06','2020-02-17 12:05:51','2020-02-17 12:03:03','2020-02-17 12:03:05','2019-10-23 17:40:34',NULL,'2020-02-27 20:08:41','2019-10-10 11:01:37','2019-10-10 11:01:36','2019-12-10 21:06:10',NULL,NULL,NULL,NULL),(1,176,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,188,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,253,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,438,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,689,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `SyncInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SystemNotification`
--

DROP TABLE IF EXISTS `SystemNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SystemNotification` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `event` enum('no_connection_for_x_days') NOT NULL DEFAULT 'no_connection_for_x_days',
  `unread` tinyint(1) NOT NULL DEFAULT '1',
  `createdAt` datetime NOT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_SystemNotification_Professional` (`ownerID`),
  CONSTRAINT `fk_SystemNotification_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SystemNotification`
--

LOCK TABLES `SystemNotification` WRITE;
/*!40000 ALTER TABLE `SystemNotification` DISABLE KEYS */;
/*!40000 ALTER TABLE `SystemNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Token`
--

DROP TABLE IF EXISTS `Token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Token` (
  `id` char(36) NOT NULL,
  `ownerID` mediumint unsigned NOT NULL,
  `created` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `token` char(200) NOT NULL,
  `credentialsId` char(36) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '',
  `context` varchar(40) DEFAULT NULL,
  `device` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  UNIQUE KEY `un_Token` (`token`),
  KEY `IDX_9EF68E3F818B3C83` (`credentialsId`),
  CONSTRAINT `fk_Token_Credentials` FOREIGN KEY (`credentialsId`) REFERENCES `Credentials` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Token`
--

LOCK TABLES `Token` WRITE;
/*!40000 ALTER TABLE `Token` DISABLE KEYS */;
INSERT INTO `Token` VALUES ('4d405ddf-a9f4-4a1e-9fc9-f22c9e4d8cd6',2,NULL,'2022-11-08 21:42:30','dfe0bc8b051efb1ebd083b754a2f9e01bdd95376','00000002-0000-0000-0000-000000000001',NULL,NULL),('5b3b3110-f32d-45ca-bbb4-c6ba05fb691d',3,NULL,'2022-11-08 21:42:30','9ac7bc186a2fb27bbe8dd0434cd440b2211538a4','00000003-0000-0000-0000-000000000001',NULL,NULL),('6528d5d6-3e97-4e08-98f9-91b465f88515',437,NULL,'2022-11-08 21:42:30','43bc05905bbc00be80ee40587fbe4d6ed5347611',NULL,NULL,NULL),('7e1b89f9-45fc-48cd-a806-83b46fbd33ce',1,NULL,'2022-11-08 21:42:30','6c812a81ea07f32f8abe638452a56421480bf2cb','00000001-0000-0000-0000-000000000001',NULL,NULL),('ca2e2a13-d690-4153-bd81-176f3d45e653',163,NULL,'2022-11-08 21:46:26','8ae6a8c6317741a3befd396036b673ec49de5227','00000163-0000-0000-0000-000000000001',NULL,NULL);
/*!40000 ALTER TABLE `Token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ToothInfo`
--

DROP TABLE IF EXISTS `ToothInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ToothInfo` (
  `ownerID` mediumint unsigned NOT NULL,
  `toothNumber` tinyint unsigned NOT NULL,
  `prostheticSheetID` char(36) NOT NULL,
  `toothColor` tinytext,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`toothNumber`,`prostheticSheetID`),
  KEY `idx_ToothInfo_Order` (`ownerID`),
  KEY `fk_ToothInfo_ProstheticSheet` (`prostheticSheetID`),
  CONSTRAINT `fk_ToothInfo_ProstheticSheet` FOREIGN KEY (`prostheticSheetID`) REFERENCES `ProstheticSheet` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ToothInfo`
--

LOCK TABLES `ToothInfo` WRITE;
/*!40000 ALTER TABLE `ToothInfo` DISABLE KEYS */;
INSERT INTO `ToothInfo` VALUES (163,11,'066d18a1-e56f-4695-a3bc-047a4064ad8e',NULL,'2021-12-10 11:27:00'),(163,11,'0f0915f0-d99f-401f-bc07-6de3f1346d65',NULL,'2021-12-10 11:27:00'),(163,11,'230857c5-798f-46ce-98ba-22728fcf0601',NULL,'2021-12-10 11:27:00'),(163,11,'2365cac3-5051-47bd-98df-b6ee18e8b8a6',NULL,'2021-12-10 11:27:00'),(163,11,'2d03e092-9432-42e7-80e7-c4b571887fa6',NULL,'2021-12-10 11:27:00'),(163,11,'2f000c1f-8ad6-4a2a-83d4-a09486ed49cc',NULL,'2021-12-10 11:27:00'),(163,11,'488bcc99-0ec8-4bbd-8c96-416ae4683e43',NULL,'2021-12-10 11:27:00'),(163,11,'816f04b9-978f-4f25-b999-b4179ef17116',NULL,'2021-12-10 11:27:00'),(163,12,'066d18a1-e56f-4695-a3bc-047a4064ad8e',NULL,'2021-12-10 11:27:00'),(163,12,'0f0915f0-d99f-401f-bc07-6de3f1346d65',NULL,'2021-12-10 11:27:00'),(163,12,'230857c5-798f-46ce-98ba-22728fcf0601',NULL,'2021-12-10 11:27:00'),(163,12,'2365cac3-5051-47bd-98df-b6ee18e8b8a6',NULL,'2021-12-10 11:27:00'),(163,12,'2d03e092-9432-42e7-80e7-c4b571887fa6',NULL,'2021-12-10 11:27:00'),(163,12,'2f000c1f-8ad6-4a2a-83d4-a09486ed49cc',NULL,'2021-12-10 11:27:00'),(163,12,'488bcc99-0ec8-4bbd-8c96-416ae4683e43',NULL,'2021-12-10 11:27:00'),(163,12,'816f04b9-978f-4f25-b999-b4179ef17116',NULL,'2021-12-10 11:27:00'),(163,13,'066d18a1-e56f-4695-a3bc-047a4064ad8e',NULL,'2021-12-10 11:27:00'),(163,13,'0f0915f0-d99f-401f-bc07-6de3f1346d65',NULL,'2021-12-10 11:27:00'),(163,13,'230857c5-798f-46ce-98ba-22728fcf0601',NULL,'2021-12-10 11:27:00'),(163,13,'2365cac3-5051-47bd-98df-b6ee18e8b8a6',NULL,'2021-12-10 11:27:00'),(163,13,'2d03e092-9432-42e7-80e7-c4b571887fa6',NULL,'2021-12-10 11:27:00'),(163,13,'2f000c1f-8ad6-4a2a-83d4-a09486ed49cc',NULL,'2021-12-10 11:27:00'),(163,13,'488bcc99-0ec8-4bbd-8c96-416ae4683e43',NULL,'2021-12-10 11:27:00'),(163,13,'816f04b9-978f-4f25-b999-b4179ef17116',NULL,'2021-12-10 11:27:00'),(163,14,'066d18a1-e56f-4695-a3bc-047a4064ad8e',NULL,'2021-12-10 11:27:00'),(163,14,'0f0915f0-d99f-401f-bc07-6de3f1346d65',NULL,'2021-12-10 11:27:00'),(163,14,'230857c5-798f-46ce-98ba-22728fcf0601',NULL,'2021-12-10 11:27:00'),(163,14,'2365cac3-5051-47bd-98df-b6ee18e8b8a6',NULL,'2021-12-10 11:27:00'),(163,14,'2d03e092-9432-42e7-80e7-c4b571887fa6',NULL,'2021-12-10 11:27:00'),(163,14,'2f000c1f-8ad6-4a2a-83d4-a09486ed49cc',NULL,'2021-12-10 11:27:00'),(163,14,'488bcc99-0ec8-4bbd-8c96-416ae4683e43',NULL,'2021-12-10 11:27:00'),(163,14,'816f04b9-978f-4f25-b999-b4179ef17116',NULL,'2021-12-10 11:27:00'),(163,15,'066d18a1-e56f-4695-a3bc-047a4064ad8e',NULL,'2021-12-10 11:27:00'),(163,15,'0f0915f0-d99f-401f-bc07-6de3f1346d65',NULL,'2021-12-10 11:27:00'),(163,15,'230857c5-798f-46ce-98ba-22728fcf0601',NULL,'2021-12-10 11:27:00'),(163,15,'2365cac3-5051-47bd-98df-b6ee18e8b8a6',NULL,'2021-12-10 11:27:00'),(163,15,'2d03e092-9432-42e7-80e7-c4b571887fa6',NULL,'2021-12-10 11:27:00'),(163,15,'2f000c1f-8ad6-4a2a-83d4-a09486ed49cc',NULL,'2021-12-10 11:27:00'),(163,15,'488bcc99-0ec8-4bbd-8c96-416ae4683e43',NULL,'2021-12-10 11:27:00'),(163,15,'816f04b9-978f-4f25-b999-b4179ef17116',NULL,'2021-12-10 11:27:00'),(163,16,'066d18a1-e56f-4695-a3bc-047a4064ad8e',NULL,'2021-12-10 11:27:00'),(163,16,'0f0915f0-d99f-401f-bc07-6de3f1346d65',NULL,'2021-12-10 11:27:00'),(163,16,'230857c5-798f-46ce-98ba-22728fcf0601',NULL,'2021-12-10 11:27:00'),(163,16,'2365cac3-5051-47bd-98df-b6ee18e8b8a6',NULL,'2021-12-10 11:27:00'),(163,16,'2d03e092-9432-42e7-80e7-c4b571887fa6',NULL,'2021-12-10 11:27:00'),(163,16,'2f000c1f-8ad6-4a2a-83d4-a09486ed49cc',NULL,'2021-12-10 11:27:00'),(163,16,'488bcc99-0ec8-4bbd-8c96-416ae4683e43',NULL,'2021-12-10 11:27:00'),(163,16,'816f04b9-978f-4f25-b999-b4179ef17116',NULL,'2021-12-10 11:27:00'),(163,17,'066d18a1-e56f-4695-a3bc-047a4064ad8e',NULL,'2021-12-10 11:27:00'),(163,17,'0f0915f0-d99f-401f-bc07-6de3f1346d65',NULL,'2021-12-10 11:27:00'),(163,17,'230857c5-798f-46ce-98ba-22728fcf0601',NULL,'2021-12-10 11:27:00'),(163,17,'2365cac3-5051-47bd-98df-b6ee18e8b8a6',NULL,'2021-12-10 11:27:00'),(163,17,'2d03e092-9432-42e7-80e7-c4b571887fa6',NULL,'2021-12-10 11:27:00'),(163,17,'2f000c1f-8ad6-4a2a-83d4-a09486ed49cc',NULL,'2021-12-10 11:27:00'),(163,17,'488bcc99-0ec8-4bbd-8c96-416ae4683e43',NULL,'2021-12-10 11:27:00'),(163,17,'816f04b9-978f-4f25-b999-b4179ef17116',NULL,'2021-12-10 11:27:00'),(163,18,'066d18a1-e56f-4695-a3bc-047a4064ad8e',NULL,'2021-12-10 11:27:00'),(163,18,'0f0915f0-d99f-401f-bc07-6de3f1346d65',NULL,'2021-12-10 11:27:00'),(163,18,'230857c5-798f-46ce-98ba-22728fcf0601',NULL,'2021-12-10 11:27:00'),(163,18,'2365cac3-5051-47bd-98df-b6ee18e8b8a6',NULL,'2021-12-10 11:27:00'),(163,18,'2d03e092-9432-42e7-80e7-c4b571887fa6',NULL,'2021-12-10 11:27:00'),(163,18,'2f000c1f-8ad6-4a2a-83d4-a09486ed49cc',NULL,'2021-12-10 11:27:00'),(163,18,'488bcc99-0ec8-4bbd-8c96-416ae4683e43',NULL,'2021-12-10 11:27:00'),(163,18,'816f04b9-978f-4f25-b999-b4179ef17116',NULL,'2021-12-10 11:27:00'),(163,21,'066d18a1-e56f-4695-a3bc-047a4064ad8e',NULL,'2021-12-10 11:27:00'),(163,21,'0f0915f0-d99f-401f-bc07-6de3f1346d65',NULL,'2021-12-10 11:27:00'),(163,21,'230857c5-798f-46ce-98ba-22728fcf0601',NULL,'2021-12-10 11:27:00'),(163,21,'2365cac3-5051-47bd-98df-b6ee18e8b8a6',NULL,'2021-12-10 11:27:00'),(163,21,'2d03e092-9432-42e7-80e7-c4b571887fa6',NULL,'2021-12-10 11:27:00'),(163,21,'2f000c1f-8ad6-4a2a-83d4-a09486ed49cc',NULL,'2021-12-10 11:27:00'),(163,21,'488bcc99-0ec8-4bbd-8c96-416ae4683e43',NULL,'2021-12-10 11:27:00'),(163,21,'816f04b9-978f-4f25-b999-b4179ef17116',NULL,'2021-12-10 11:27:00'),(163,22,'066d18a1-e56f-4695-a3bc-047a4064ad8e',NULL,'2021-12-10 11:27:00'),(163,22,'0f0915f0-d99f-401f-bc07-6de3f1346d65',NULL,'2021-12-10 11:27:00'),(163,22,'230857c5-798f-46ce-98ba-22728fcf0601',NULL,'2021-12-10 11:27:00'),(163,22,'2365cac3-5051-47bd-98df-b6ee18e8b8a6',NULL,'2021-12-10 11:27:00'),(163,22,'2d03e092-9432-42e7-80e7-c4b571887fa6',NULL,'2021-12-10 11:27:00'),(163,22,'2f000c1f-8ad6-4a2a-83d4-a09486ed49cc',NULL,'2021-12-10 11:27:00'),(163,22,'488bcc99-0ec8-4bbd-8c96-416ae4683e43',NULL,'2021-12-10 11:27:00'),(163,22,'816f04b9-978f-4f25-b999-b4179ef17116',NULL,'2021-12-10 11:27:00'),(163,23,'066d18a1-e56f-4695-a3bc-047a4064ad8e',NULL,'2021-12-10 11:27:00'),(163,23,'0f0915f0-d99f-401f-bc07-6de3f1346d65',NULL,'2021-12-10 11:27:00'),(163,23,'230857c5-798f-46ce-98ba-22728fcf0601',NULL,'2021-12-10 11:27:00'),(163,23,'2365cac3-5051-47bd-98df-b6ee18e8b8a6',NULL,'2021-12-10 11:27:00'),(163,23,'2d03e092-9432-42e7-80e7-c4b571887fa6',NULL,'2021-12-10 11:27:00'),(163,23,'2f000c1f-8ad6-4a2a-83d4-a09486ed49cc',NULL,'2021-12-10 11:27:00'),(163,23,'488bcc99-0ec8-4bbd-8c96-416ae4683e43',NULL,'2021-12-10 11:27:00'),(163,23,'816f04b9-978f-4f25-b999-b4179ef17116',NULL,'2021-12-10 11:27:00'),(163,24,'066d18a1-e56f-4695-a3bc-047a4064ad8e',NULL,'2021-12-10 11:27:00'),(163,24,'0f0915f0-d99f-401f-bc07-6de3f1346d65',NULL,'2021-12-10 11:27:00'),(163,24,'230857c5-798f-46ce-98ba-22728fcf0601',NULL,'2021-12-10 11:27:00'),(163,24,'2365cac3-5051-47bd-98df-b6ee18e8b8a6',NULL,'2021-12-10 11:27:00'),(163,24,'2d03e092-9432-42e7-80e7-c4b571887fa6',NULL,'2021-12-10 11:27:00'),(163,24,'2f000c1f-8ad6-4a2a-83d4-a09486ed49cc',NULL,'2021-12-10 11:27:00'),(163,24,'488bcc99-0ec8-4bbd-8c96-416ae4683e43',NULL,'2021-12-10 11:27:00'),(163,24,'816f04b9-978f-4f25-b999-b4179ef17116',NULL,'2021-12-10 11:27:00'),(163,25,'066d18a1-e56f-4695-a3bc-047a4064ad8e',NULL,'2021-12-10 11:27:00'),(163,25,'0f0915f0-d99f-401f-bc07-6de3f1346d65',NULL,'2021-12-10 11:27:00'),(163,25,'230857c5-798f-46ce-98ba-22728fcf0601',NULL,'2021-12-10 11:27:00'),(163,25,'2365cac3-5051-47bd-98df-b6ee18e8b8a6',NULL,'2021-12-10 11:27:00'),(163,25,'2d03e092-9432-42e7-80e7-c4b571887fa6',NULL,'2021-12-10 11:27:00'),(163,25,'2f000c1f-8ad6-4a2a-83d4-a09486ed49cc',NULL,'2021-12-10 11:27:00'),(163,25,'488bcc99-0ec8-4bbd-8c96-416ae4683e43',NULL,'2021-12-10 11:27:00'),(163,25,'816f04b9-978f-4f25-b999-b4179ef17116',NULL,'2021-12-10 11:27:00'),(163,26,'066d18a1-e56f-4695-a3bc-047a4064ad8e',NULL,'2021-12-10 11:27:00'),(163,26,'0f0915f0-d99f-401f-bc07-6de3f1346d65',NULL,'2021-12-10 11:27:00'),(163,26,'230857c5-798f-46ce-98ba-22728fcf0601',NULL,'2021-12-10 11:27:00'),(163,26,'2365cac3-5051-47bd-98df-b6ee18e8b8a6',NULL,'2021-12-10 11:27:00'),(163,26,'2d03e092-9432-42e7-80e7-c4b571887fa6',NULL,'2021-12-10 11:27:00'),(163,26,'2f000c1f-8ad6-4a2a-83d4-a09486ed49cc',NULL,'2021-12-10 11:27:00'),(163,26,'488bcc99-0ec8-4bbd-8c96-416ae4683e43',NULL,'2021-12-10 11:27:00'),(163,26,'816f04b9-978f-4f25-b999-b4179ef17116',NULL,'2021-12-10 11:27:00'),(163,27,'066d18a1-e56f-4695-a3bc-047a4064ad8e',NULL,'2021-12-10 11:27:00'),(163,27,'0f0915f0-d99f-401f-bc07-6de3f1346d65',NULL,'2021-12-10 11:27:00'),(163,27,'230857c5-798f-46ce-98ba-22728fcf0601',NULL,'2021-12-10 11:27:00'),(163,27,'2365cac3-5051-47bd-98df-b6ee18e8b8a6',NULL,'2021-12-10 11:27:00'),(163,27,'2d03e092-9432-42e7-80e7-c4b571887fa6',NULL,'2021-12-10 11:27:00'),(163,27,'2f000c1f-8ad6-4a2a-83d4-a09486ed49cc',NULL,'2021-12-10 11:27:00'),(163,27,'488bcc99-0ec8-4bbd-8c96-416ae4683e43',NULL,'2021-12-10 11:27:00'),(163,27,'816f04b9-978f-4f25-b999-b4179ef17116',NULL,'2021-12-10 11:27:00'),(163,28,'066d18a1-e56f-4695-a3bc-047a4064ad8e',NULL,'2021-12-10 11:27:00'),(163,28,'0f0915f0-d99f-401f-bc07-6de3f1346d65',NULL,'2021-12-10 11:27:00'),(163,28,'230857c5-798f-46ce-98ba-22728fcf0601',NULL,'2021-12-10 11:27:00'),(163,28,'2365cac3-5051-47bd-98df-b6ee18e8b8a6',NULL,'2021-12-10 11:27:00'),(163,28,'2d03e092-9432-42e7-80e7-c4b571887fa6',NULL,'2021-12-10 11:27:00'),(163,28,'2f000c1f-8ad6-4a2a-83d4-a09486ed49cc',NULL,'2021-12-10 11:27:00'),(163,28,'488bcc99-0ec8-4bbd-8c96-416ae4683e43',NULL,'2021-12-10 11:27:00'),(163,28,'816f04b9-978f-4f25-b999-b4179ef17116',NULL,'2021-12-10 11:27:00'),(163,31,'066d18a1-e56f-4695-a3bc-047a4064ad8e',NULL,'2021-12-10 11:27:00'),(163,31,'0f0915f0-d99f-401f-bc07-6de3f1346d65',NULL,'2021-12-10 11:27:00'),(163,31,'230857c5-798f-46ce-98ba-22728fcf0601',NULL,'2021-12-10 11:27:00'),(163,31,'2365cac3-5051-47bd-98df-b6ee18e8b8a6',NULL,'2021-12-10 11:27:00'),(163,31,'2d03e092-9432-42e7-80e7-c4b571887fa6',NULL,'2021-12-10 11:27:00'),(163,31,'2f000c1f-8ad6-4a2a-83d4-a09486ed49cc',NULL,'2021-12-10 11:27:00'),(163,31,'488bcc99-0ec8-4bbd-8c96-416ae4683e43',NULL,'2021-12-10 11:27:00'),(163,31,'816f04b9-978f-4f25-b999-b4179ef17116',NULL,'2021-12-10 11:27:00'),(163,32,'066d18a1-e56f-4695-a3bc-047a4064ad8e',NULL,'2021-12-10 11:27:00'),(163,32,'0f0915f0-d99f-401f-bc07-6de3f1346d65',NULL,'2021-12-10 11:27:00'),(163,32,'230857c5-798f-46ce-98ba-22728fcf0601',NULL,'2021-12-10 11:27:00'),(163,32,'2365cac3-5051-47bd-98df-b6ee18e8b8a6',NULL,'2021-12-10 11:27:00'),(163,32,'2d03e092-9432-42e7-80e7-c4b571887fa6',NULL,'2021-12-10 11:27:00'),(163,32,'2f000c1f-8ad6-4a2a-83d4-a09486ed49cc',NULL,'2021-12-10 11:27:00'),(163,32,'488bcc99-0ec8-4bbd-8c96-416ae4683e43',NULL,'2021-12-10 11:27:00'),(163,32,'816f04b9-978f-4f25-b999-b4179ef17116',NULL,'2021-12-10 11:27:00'),(163,33,'066d18a1-e56f-4695-a3bc-047a4064ad8e',NULL,'2021-12-10 11:27:00'),(163,33,'0f0915f0-d99f-401f-bc07-6de3f1346d65',NULL,'2021-12-10 11:27:00'),(163,33,'230857c5-798f-46ce-98ba-22728fcf0601',NULL,'2021-12-10 11:27:00'),(163,33,'2365cac3-5051-47bd-98df-b6ee18e8b8a6',NULL,'2021-12-10 11:27:00'),(163,33,'2d03e092-9432-42e7-80e7-c4b571887fa6',NULL,'2021-12-10 11:27:00'),(163,33,'2f000c1f-8ad6-4a2a-83d4-a09486ed49cc',NULL,'2021-12-10 11:27:00'),(163,33,'488bcc99-0ec8-4bbd-8c96-416ae4683e43',NULL,'2021-12-10 11:27:00'),(163,33,'816f04b9-978f-4f25-b999-b4179ef17116',NULL,'2021-12-10 11:27:00'),(163,34,'066d18a1-e56f-4695-a3bc-047a4064ad8e',NULL,'2021-12-10 11:27:00'),(163,34,'0f0915f0-d99f-401f-bc07-6de3f1346d65',NULL,'2021-12-10 11:27:00'),(163,34,'230857c5-798f-46ce-98ba-22728fcf0601',NULL,'2021-12-10 11:27:00'),(163,34,'2365cac3-5051-47bd-98df-b6ee18e8b8a6',NULL,'2021-12-10 11:27:00'),(163,34,'2d03e092-9432-42e7-80e7-c4b571887fa6',NULL,'2021-12-10 11:27:00'),(163,34,'2f000c1f-8ad6-4a2a-83d4-a09486ed49cc',NULL,'2021-12-10 11:27:00'),(163,34,'488bcc99-0ec8-4bbd-8c96-416ae4683e43',NULL,'2021-12-10 11:27:00'),(163,34,'816f04b9-978f-4f25-b999-b4179ef17116',NULL,'2021-12-10 11:27:00'),(163,35,'066d18a1-e56f-4695-a3bc-047a4064ad8e',NULL,'2021-12-10 11:27:00'),(163,35,'0f0915f0-d99f-401f-bc07-6de3f1346d65',NULL,'2021-12-10 11:27:00'),(163,35,'230857c5-798f-46ce-98ba-22728fcf0601',NULL,'2021-12-10 11:27:00'),(163,35,'2365cac3-5051-47bd-98df-b6ee18e8b8a6',NULL,'2021-12-10 11:27:00'),(163,35,'2d03e092-9432-42e7-80e7-c4b571887fa6',NULL,'2021-12-10 11:27:00'),(163,35,'2f000c1f-8ad6-4a2a-83d4-a09486ed49cc',NULL,'2021-12-10 11:27:00'),(163,35,'488bcc99-0ec8-4bbd-8c96-416ae4683e43',NULL,'2021-12-10 11:27:00'),(163,35,'816f04b9-978f-4f25-b999-b4179ef17116',NULL,'2021-12-10 11:27:00'),(163,36,'066d18a1-e56f-4695-a3bc-047a4064ad8e',NULL,'2021-12-10 11:27:00'),(163,36,'0f0915f0-d99f-401f-bc07-6de3f1346d65',NULL,'2021-12-10 11:27:00'),(163,36,'230857c5-798f-46ce-98ba-22728fcf0601',NULL,'2021-12-10 11:27:00'),(163,36,'2365cac3-5051-47bd-98df-b6ee18e8b8a6',NULL,'2021-12-10 11:27:00'),(163,36,'2d03e092-9432-42e7-80e7-c4b571887fa6',NULL,'2021-12-10 11:27:00'),(163,36,'2f000c1f-8ad6-4a2a-83d4-a09486ed49cc',NULL,'2021-12-10 11:27:00'),(163,36,'488bcc99-0ec8-4bbd-8c96-416ae4683e43',NULL,'2021-12-10 11:27:00'),(163,36,'816f04b9-978f-4f25-b999-b4179ef17116',NULL,'2021-12-10 11:27:00'),(163,37,'066d18a1-e56f-4695-a3bc-047a4064ad8e',NULL,'2021-12-10 11:27:00'),(163,37,'0f0915f0-d99f-401f-bc07-6de3f1346d65',NULL,'2021-12-10 11:27:00'),(163,37,'230857c5-798f-46ce-98ba-22728fcf0601',NULL,'2021-12-10 11:27:00'),(163,37,'2365cac3-5051-47bd-98df-b6ee18e8b8a6',NULL,'2021-12-10 11:27:00'),(163,37,'2d03e092-9432-42e7-80e7-c4b571887fa6',NULL,'2021-12-10 11:27:00'),(163,37,'2f000c1f-8ad6-4a2a-83d4-a09486ed49cc',NULL,'2021-12-10 11:27:00'),(163,37,'488bcc99-0ec8-4bbd-8c96-416ae4683e43',NULL,'2021-12-10 11:27:00'),(163,37,'816f04b9-978f-4f25-b999-b4179ef17116',NULL,'2021-12-10 11:27:00'),(163,38,'066d18a1-e56f-4695-a3bc-047a4064ad8e',NULL,'2021-12-10 11:27:00'),(163,38,'0f0915f0-d99f-401f-bc07-6de3f1346d65',NULL,'2021-12-10 11:27:00'),(163,38,'230857c5-798f-46ce-98ba-22728fcf0601',NULL,'2021-12-10 11:27:00'),(163,38,'2365cac3-5051-47bd-98df-b6ee18e8b8a6',NULL,'2021-12-10 11:27:00'),(163,38,'2d03e092-9432-42e7-80e7-c4b571887fa6',NULL,'2021-12-10 11:27:00'),(163,38,'2f000c1f-8ad6-4a2a-83d4-a09486ed49cc',NULL,'2021-12-10 11:27:00'),(163,38,'488bcc99-0ec8-4bbd-8c96-416ae4683e43',NULL,'2021-12-10 11:27:00'),(163,38,'816f04b9-978f-4f25-b999-b4179ef17116',NULL,'2021-12-10 11:27:00'),(163,41,'066d18a1-e56f-4695-a3bc-047a4064ad8e',NULL,'2021-12-10 11:27:00'),(163,41,'0f0915f0-d99f-401f-bc07-6de3f1346d65',NULL,'2021-12-10 11:27:00'),(163,41,'230857c5-798f-46ce-98ba-22728fcf0601',NULL,'2021-12-10 11:27:00'),(163,41,'2365cac3-5051-47bd-98df-b6ee18e8b8a6',NULL,'2021-12-10 11:27:00'),(163,41,'2d03e092-9432-42e7-80e7-c4b571887fa6',NULL,'2021-12-10 11:27:00'),(163,41,'2f000c1f-8ad6-4a2a-83d4-a09486ed49cc',NULL,'2021-12-10 11:27:00'),(163,41,'488bcc99-0ec8-4bbd-8c96-416ae4683e43',NULL,'2021-12-10 11:27:00'),(163,41,'816f04b9-978f-4f25-b999-b4179ef17116',NULL,'2021-12-10 11:27:00'),(163,42,'066d18a1-e56f-4695-a3bc-047a4064ad8e',NULL,'2021-12-10 11:27:00'),(163,42,'0f0915f0-d99f-401f-bc07-6de3f1346d65',NULL,'2021-12-10 11:27:00'),(163,42,'230857c5-798f-46ce-98ba-22728fcf0601',NULL,'2021-12-10 11:27:00'),(163,42,'2365cac3-5051-47bd-98df-b6ee18e8b8a6',NULL,'2021-12-10 11:27:00'),(163,42,'2d03e092-9432-42e7-80e7-c4b571887fa6',NULL,'2021-12-10 11:27:00'),(163,42,'2f000c1f-8ad6-4a2a-83d4-a09486ed49cc',NULL,'2021-12-10 11:27:00'),(163,42,'488bcc99-0ec8-4bbd-8c96-416ae4683e43',NULL,'2021-12-10 11:27:00'),(163,42,'816f04b9-978f-4f25-b999-b4179ef17116',NULL,'2021-12-10 11:27:00'),(163,43,'066d18a1-e56f-4695-a3bc-047a4064ad8e',NULL,'2021-12-10 11:27:00'),(163,43,'0f0915f0-d99f-401f-bc07-6de3f1346d65',NULL,'2021-12-10 11:27:00'),(163,43,'230857c5-798f-46ce-98ba-22728fcf0601',NULL,'2021-12-10 11:27:00'),(163,43,'2365cac3-5051-47bd-98df-b6ee18e8b8a6',NULL,'2021-12-10 11:27:00'),(163,43,'2d03e092-9432-42e7-80e7-c4b571887fa6',NULL,'2021-12-10 11:27:00'),(163,43,'2f000c1f-8ad6-4a2a-83d4-a09486ed49cc',NULL,'2021-12-10 11:27:00'),(163,43,'488bcc99-0ec8-4bbd-8c96-416ae4683e43',NULL,'2021-12-10 11:27:00'),(163,43,'816f04b9-978f-4f25-b999-b4179ef17116',NULL,'2021-12-10 11:27:00'),(163,44,'066d18a1-e56f-4695-a3bc-047a4064ad8e',NULL,'2021-12-10 11:27:00'),(163,44,'0f0915f0-d99f-401f-bc07-6de3f1346d65',NULL,'2021-12-10 11:27:00'),(163,44,'230857c5-798f-46ce-98ba-22728fcf0601',NULL,'2021-12-10 11:27:00'),(163,44,'2365cac3-5051-47bd-98df-b6ee18e8b8a6',NULL,'2021-12-10 11:27:00'),(163,44,'2d03e092-9432-42e7-80e7-c4b571887fa6',NULL,'2021-12-10 11:27:00'),(163,44,'2f000c1f-8ad6-4a2a-83d4-a09486ed49cc',NULL,'2021-12-10 11:27:00'),(163,44,'488bcc99-0ec8-4bbd-8c96-416ae4683e43',NULL,'2021-12-10 11:27:00'),(163,44,'816f04b9-978f-4f25-b999-b4179ef17116',NULL,'2021-12-10 11:27:00'),(163,45,'066d18a1-e56f-4695-a3bc-047a4064ad8e',NULL,'2021-12-10 11:27:00'),(163,45,'0f0915f0-d99f-401f-bc07-6de3f1346d65',NULL,'2021-12-10 11:27:00'),(163,45,'230857c5-798f-46ce-98ba-22728fcf0601',NULL,'2021-12-10 11:27:00'),(163,45,'2365cac3-5051-47bd-98df-b6ee18e8b8a6',NULL,'2021-12-10 11:27:00'),(163,45,'2d03e092-9432-42e7-80e7-c4b571887fa6',NULL,'2021-12-10 11:27:00'),(163,45,'2f000c1f-8ad6-4a2a-83d4-a09486ed49cc',NULL,'2021-12-10 11:27:00'),(163,45,'488bcc99-0ec8-4bbd-8c96-416ae4683e43',NULL,'2021-12-10 11:27:00'),(163,45,'816f04b9-978f-4f25-b999-b4179ef17116',NULL,'2021-12-10 11:27:00'),(163,46,'066d18a1-e56f-4695-a3bc-047a4064ad8e',NULL,'2021-12-10 11:27:00'),(163,46,'0f0915f0-d99f-401f-bc07-6de3f1346d65',NULL,'2021-12-10 11:27:00'),(163,46,'230857c5-798f-46ce-98ba-22728fcf0601',NULL,'2021-12-10 11:27:00'),(163,46,'2365cac3-5051-47bd-98df-b6ee18e8b8a6',NULL,'2021-12-10 11:27:00'),(163,46,'2d03e092-9432-42e7-80e7-c4b571887fa6',NULL,'2021-12-10 11:27:00'),(163,46,'2f000c1f-8ad6-4a2a-83d4-a09486ed49cc',NULL,'2021-12-10 11:27:00'),(163,46,'488bcc99-0ec8-4bbd-8c96-416ae4683e43',NULL,'2021-12-10 11:27:00'),(163,46,'816f04b9-978f-4f25-b999-b4179ef17116',NULL,'2021-12-10 11:27:00'),(163,47,'066d18a1-e56f-4695-a3bc-047a4064ad8e',NULL,'2021-12-10 11:27:00'),(163,47,'0f0915f0-d99f-401f-bc07-6de3f1346d65',NULL,'2021-12-10 11:27:00'),(163,47,'230857c5-798f-46ce-98ba-22728fcf0601',NULL,'2021-12-10 11:27:00'),(163,47,'2365cac3-5051-47bd-98df-b6ee18e8b8a6',NULL,'2021-12-10 11:27:00'),(163,47,'2d03e092-9432-42e7-80e7-c4b571887fa6',NULL,'2021-12-10 11:27:00'),(163,47,'2f000c1f-8ad6-4a2a-83d4-a09486ed49cc',NULL,'2021-12-10 11:27:00'),(163,47,'488bcc99-0ec8-4bbd-8c96-416ae4683e43',NULL,'2021-12-10 11:27:00'),(163,47,'816f04b9-978f-4f25-b999-b4179ef17116',NULL,'2021-12-10 11:27:00'),(163,48,'066d18a1-e56f-4695-a3bc-047a4064ad8e',NULL,'2021-12-10 11:27:00'),(163,48,'0f0915f0-d99f-401f-bc07-6de3f1346d65',NULL,'2021-12-10 11:27:00'),(163,48,'230857c5-798f-46ce-98ba-22728fcf0601',NULL,'2021-12-10 11:27:00'),(163,48,'2365cac3-5051-47bd-98df-b6ee18e8b8a6',NULL,'2021-12-10 11:27:00'),(163,48,'2d03e092-9432-42e7-80e7-c4b571887fa6',NULL,'2021-12-10 11:27:00'),(163,48,'2f000c1f-8ad6-4a2a-83d4-a09486ed49cc',NULL,'2021-12-10 11:27:00'),(163,48,'488bcc99-0ec8-4bbd-8c96-416ae4683e43',NULL,'2021-12-10 11:27:00'),(163,48,'816f04b9-978f-4f25-b999-b4179ef17116',NULL,'2021-12-10 11:27:00');
/*!40000 ALTER TABLE `ToothInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `__db_version__`
--

DROP TABLE IF EXISTS `__db_version__`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `__db_version__` (
  `id` int NOT NULL AUTO_INCREMENT,
  `version_major` int NOT NULL DEFAULT '0',
  `version_minor` int NOT NULL DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `migration_file` varchar(1024) DEFAULT NULL,
  `commit` varchar(255) DEFAULT NULL,
  `version_core` varchar(255) DEFAULT NULL,
  `version_IHM` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=75 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `__db_version__`
--

LOCK TABLES `__db_version__` WRITE;
/*!40000 ALTER TABLE `__db_version__` DISABLE KEYS */;
INSERT INTO `__db_version__` VALUES (1,1,15,'v1.15','','','1.9.0','2.0.4'),(2,1,18,'v1.18','migration_fileconstraint_local','','1.9.0','2.0.4'),(3,1,19,'v1.19','migration_fileconstraint_local','','1.9.0','2.0.4'),(4,1,20,'v1.20','migration_globalDisplayID_local','','1.9','2.0.4'),(5,1,21,'v1.21','migration_config_show_open_stl_warning_local','','1.9','2.0.4'),(6,1,22,'v1.22','migration_resetcontact_local','','1.9','2.0.4'),(7,1,23,'v1.23','migration_token_context_device_local','','1.9','2.0.4'),(8,1,24,'v1.24','migration_config_lag_and_lost_sound_local','','1.9','2.0.4'),(9,1,25,'v1.25','migration_fix_unset_scan_creator_local','','1.9.0','2.0.4'),(10,1,26,'v1.26','migration_fix_wrong_original_files_local','','1.9.0','2.0.4'),(11,1,27,'v1.27','migration_occlusion_display_id_local','','1.9','2.0.4'),(12,1,28,'v1.28','migration_selfdiscussions_local','','1.9','2.0.4'),(13,1,29,'v1.29','migration_config_show_delete_confirmation_local','','1.9','2.0.4'),(14,1,30,'v1.30','migration_config_email_notifications_local','','1.9','2.0.4'),(15,1,31,'v1.31','migration_config_last_synced_local','','1.9','2.0.4'),(16,1,32,'v1.32','migration_lastmodified_local','','1.9','2.0.4'),(17,1,33,'v1.33','migration_config_add_fields_flip_local','','1.9','2.0.4'),(18,1,34,'v1.34','migration_unread_local','','1.9','2.0.4'),(19,1,35,'v1.35','migration_work_last_accessed_local','','1.9','2.0.4'),(20,1,36,'v1.36','migration_config_show_sync_info_local','','1.9','2.0.4'),(21,1,37,'v1.37','migration_config_clean_deprecated_fields_local','','1.9','2.0.4'),(22,1,38,'v1.38','migration_act_refonte_local','','1.9','2.0.4'),(23,1,39,'v1.39','migration_fix_duplicate_screenshot_path_local','','1.9','2.0.4'),(24,1,40,'v1.40','migration_rework_local','','1.9.0','2.0.4'),(25,1,41,'v1.41','migration_sync_info_local','','1.9.0','1.1-3'),(26,1,42,'v1.42','migration_config_popup_flip','','1.9','2.0.4'),(27,1,43,'v1.43','migration_mark_contacts_invisible_local','','1.9','3.2.1'),(28,1,44,'v1.44','migration_config_show_margin_lines_warning_local','','1.9','2.0.4'),(29,1,45,'v1.45','migration_contact_invitation_local','','1.9','2.3.0'),(30,1,46,'v1.46','migration_received_order_local','','1.9','3.3.0'),(31,1,47,'v1.47','migration_merge_discussions_local','','1.9','3.3.1'),(32,1,48,'v1.48','migration_office_rename_email_local','','1.9','3.3.1'),(33,1,49,'v1.49','migration_contact_cannot_reject_self_local','','1.9','3.3.1'),(34,1,50,'v1.50','migration_discussion_deletedat_not_null_local','','1.9','3.3.1'),(35,1,51,'v1.51','migration_reset_condor_file_trigger_local','','1.9','3.3.1'),(36,1,52,'v1.52','migration_system_notification_local','','1.9','2.3.0'),(37,1,53,'v1.53','migration_add_last_connection_checked_professional_local','','1.9','3.4.0'),(38,1,54,'v1.54','migration_endless_scans_local','','1.9','3.4.0'),(39,1,55,'v1.55','migration_rename_act_session_local','','1.9','3.4.0'),(40,1,56,'v1.56','migration_sessionId_local','','1.9','3.4.0'),(41,1,57,'v1.57','migration_session_created_at_local','','1.9','3.4.0'),(42,1,58,'v1.58','migration_order_display_id_local','','1.9','3.4.0'),(43,1,59,'v1.59','migration_pin_patient_local','','1.9','1.0.0'),(44,1,60,'v1.60','migration_enable_upload_local','','3.4.0','1.0.1'),(45,1,61,'v1.61','migration_remove_occlusion_contact_local','','3.4.1','1.1.0'),(46,1,62,'v1.62','migration_scanid_local','','3.4.1','1.1.0'),(47,1,63,'v1.63','migration_circleorder_local','','3.4.1','1.1.0'),(48,1,64,'v1.64','migration_smilersorder_local','','4.1.0','2.1.0'),(49,1,65,'v1.65','migration_demo_professional','','4.1.0','2.1.0'),(50,1,66,'v1.66','migration_tracking_rectangle','','4.1.0','2.1.1'),(51,1,67,'v1.67','migration_fix_status_circle_smilers','','4.1.0','2.1.1'),(52,1,68,'v1.68','migration_remove_scansID_session_local','','4.2.0','2.1.1'),(53,1,69,'v1.69','migration_externalize_occlusion_local','','4.2.0','2.1.1'),(54,1,70,'v1.70','migration_scan_occlusion_trigger_local','','4.2.0','2.1.1'),(55,1,71,'v1.71','migration_add_date_created_scan_local','','4.2.0','2.1.1'),(56,1,72,'v1.72','migration_scan_status_local','','4.2.0','2.1.1'),(57,1,73,'v1.73','migration_remove_patient_personnal_data_local','','4.2.0','2.1.1'),(58,1,74,'v1.74','migration_fix_xxxinfo_local','','4.3.0','2.2.3'),(59,1,75,'v1.75','migration_add_displayid_occlusion_local','','4.3.0','2.3.3'),(60,1,76,'v1.76','migration_add_table_ProstheticSheet_local','','4.4.0','2.3.4'),(61,1,77,'v1.77','migration_status_smilers_circle_local','','4.2.0','2.4.0'),(62,1,78,'v1.78','migration_condor_local_1.78_patient_theme','','4.4.0','2.4.0'),(63,1,79,'v1.79','migration_condor_local_1.79_fix_order_recipient','','4.5.0','2.4.4'),(64,1,80,'v1.80','migration_condor_local_1.80_fix_order','','4.5.0','2.4.4'),(65,1,81,'v1.81','migration_condor_local_1.81_fix_theme_null','','4.5.0','2.4.4'),(66,1,82,'v1.82','migration_condor_local_1.82_fix_wow_data','','5.0.0','3.0.1'),(67,1,83,'v1.83','migration_condor_local_1.83_remove_ownerid','','5.0.0','3.0.1'),(68,1,84,'v1.84','migration_condor_local_1.84_generate_professional_env_infos','','5.0.0','3.0.1'),(69,1,85,'v1.85','migration_condor_local_1.85_add_updatedat_professional_env_infos','','5.0.0','3.0.1'),(70,1,86,'v1.86','migration_condor_local_1.86_update_token','','5.0.0','3.0.1'),(71,1,87,'v1.87','migration_condor_local_1.87_add_galaxy_status','','5.0.0','3.0.1'),(72,1,88,'v1.88','migration_condor_local_1.88_fix_order_recipient','','5.0.0','3.1.2'),(73,1,89,'v1.89','migration_condor_local_1.89_fix_personinfo','','5.1.0','4.0.0'),(74,1,90,'v1.90','migration_condor_local_1.90_fix_syncinfo','','5.1.0','4.0.0');
/*!40000 ALTER TABLE `__db_version__` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping routines for database 'condor'
--
/*!50003 DROP FUNCTION IF EXISTS `generateid` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `generateid`(maxchars int) RETURNS char(36) CHARSET latin1
BEGIN

  DECLARE AllChars char(16);
  DECLARE currentStr CHAR(36);
  DECLARE p1 int;
  
  SET AllChars = 'abcdef0123456789'; 
  SET currentStr = '';
  SET p1 = 0;

  charLoop: LOOP
  
    IF p1 < maxchars THEN
	  SET currentStr = CONCAT(currentStr, substring(AllChars, (RAND()*15)+1, 1));
	  SET p1 = p1 + 1;
      
      ITERATE charLoop;
    END IF;
    
    LEAVE charLoop;
    
  END LOOP charLoop;
  
  RETURN currentStr;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `uuid_v4` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `uuid_v4`() RETURNS char(36) CHARSET utf8mb4
    NO SQL
BEGIN
    
    SET @h1 = LPAD(HEX(FLOOR(RAND() * 0xffff)), 4, '0');
    SET @h2 = LPAD(HEX(FLOOR(RAND() * 0xffff)), 4, '0');
    SET @h3 = LPAD(HEX(FLOOR(RAND() * 0xffff)), 4, '0');
    SET @h6 = LPAD(HEX(FLOOR(RAND() * 0xffff)), 4, '0');
    SET @h7 = LPAD(HEX(FLOOR(RAND() * 0xffff)), 4, '0');
    SET @h8 = LPAD(HEX(FLOOR(RAND() * 0xffff)), 4, '0');

    
    SET @h4 = CONCAT('4', LPAD(HEX(FLOOR(RAND() * 0x0fff)), 3, '0'));

    
    SET @h5 = CONCAT(HEX(FLOOR(RAND() * 4 + 8)),
                LPAD(HEX(FLOOR(RAND() * 0x0fff)), 3, '0'));

    
    RETURN LOWER(CONCAT(
        @h1, @h2, '-', @h3, '-', @h4, '-', @h5, '-', @h6, @h7, @h8
    ));
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `drop_fk_if_exists` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `drop_fk_if_exists`(in theTable varchar(128), in theFKName varchar(128) )
BEGIN
 IF((SELECT COUNT(*) AS fk_exists
     FROM information_schema.table_constraints
     WHERE TABLE_SCHEMA = DATABASE() AND table_name = theTable AND constraint_name = theFKName AND constraint_type = 'FOREIGN KEY') > 0)
 THEN
   SET @s = CONCAT('ALTER TABLE ', theTable, ' DROP FOREIGN KEY ' , theFKName);
   PREPARE stmt FROM @s;
   EXECUTE stmt;
 END IF;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `drop_index_if_exists` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `drop_index_if_exists`(in theTable varchar(128), in theIndexName varchar(128) )
BEGIN
 IF((SELECT COUNT(*) AS index_exists
     FROM information_schema.statistics
     WHERE TABLE_SCHEMA = DATABASE() and table_name = theTable AND index_name = theIndexName) > 0)
 THEN
   SET @s = CONCAT('DROP INDEX ' , theIndexName , ' ON ' , theTable);
   PREPARE stmt FROM @s;
   EXECUTE stmt;
 END IF;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `fixOrderFrom176` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `fixOrderFrom176`()
    NO SQL
BEGIN
    SET @script_ok = (SELECT COUNT(*) FROM __db_version__ WHERE version_major = '1' AND version_minor = '76');

	IF (@script_ok = 0) THEN
        SET @count_bad_date = (SELECT COUNT(*) FROM ProstheticOrder WHERE createdAt IS NULL);
        IF (@count_bad_date > 0) THEN
            CALL `script176`();
        ELSE
            SET @count_bad_toothinfo = (SELECT COUNT(*) FROM ToothInfo WHERE prostheticSheetID = '');
            IF (@count_bad_toothinfo > 0) THEN
                DELETE FROM ToothInfo WHERE prostheticSheetID = '';

                ALTER TABLE ToothInfo ADD PRIMARY KEY (ownerID, toothNumber, prostheticSheetID);
                ALTER TABLE ToothInfo DROP COLUMN orderID;

                INSERT INTO `__db_version__`(`version_major`, `version_minor`, `title`, `commit`, `migration_file`, `version_core`, `version_IHM`) VALUES
                    (1, 76, 'v1.76', '', 'migration_condor_local_1.76_add_table_ProstheticSheet_from_180', '4.4.0', '2.3.4');
            END IF;
        END IF;
    END IF;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `FixOrderRecipient` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `FixOrderRecipient`()
    NO SQL
BEGIN
    DECLARE CurOrderOwnerID MEDIUMINT(8) UNSIGNED;
    DECLARE CurOrderUuid CHAR(36);
    DECLARE CurOrderId VARCHAR(255);

    DECLARE NbRecipient INT(8);
    DECLARE DID CHAR(36);
    DECLARE RecipientOwnerId MEDIUMINT(8) UNSIGNED;
    DECLARE RecipientContactId CHAR(36);

    DECLARE exit_loop BOOLEAN DEFAULT FALSE;

    DECLARE CUR CURSOR FOR
        SELECT ownerId, uuid, id
        FROM DebugOrderData
        WHERE id IS NOT NULL;

    DECLARE CONTINUE HANDLER FOR NOT FOUND SET exit_loop = TRUE;

    OPEN CUR;
    read_loop: LOOP
        FETCH CUR INTO CurOrderOwnerID, CurOrderUuid, CurOrderId;

        
        
        IF exit_loop THEN
            CLOSE CUR;
            LEAVE read_loop;
        END IF;

        SET NbRecipient = (SELECT COUNT(*) FROM ProstheticOrderRecipient WHERE orderID = CurOrderUuid);

        IF NbRecipient = 0 THEN
            SET DID = (SELECT discussionID FROM SentMessage WHERE LOCATE(CurOrderId, body) > 0);

            IF DID IS NOT NULL THEN
                SET RecipientOwnerId = (SELECT ownerID FROM Discussion WHERE id = DID AND ownerID != CurOrderOwnerID);

                IF RecipientOwnerId IS NOT NULL THEN
                    SET RecipientContactId = (SELECT id FROM Contact WHERE ownerID = CurOrderOwnerID AND professionalID = RecipientOwnerId);

                    IF RecipientContactId IS NOT NULL THEN
                        INSERT INTO ProstheticOrderRecipient VALUES (CurOrderOwnerID, CurOrderUuid , RecipientContactId, NOW());
                    END IF;
                END IF;
            END IF;
        END IF;
    END LOOP;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `getUsedScansForOcclusion` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `getUsedScansForOcclusion`()
    NO SQL
BLOCK1: BEGIN

  DECLARE CurFileID CHAR(36);
  DECLARE CurFileMetadata TEXT;
  DECLARE CurOwnerID MEDIUMINT(8) UNSIGNED;
  DECLARE CurFileTag TEXT;
  
  DECLARE exit_loop BOOLEAN DEFAULT FALSE;

  DECLARE read_sessionid TEXT;

  DECLARE CUR CURSOR FOR
          SELECT CondorFile.id, CondorFile.metadata, CondorFile.ownerID, CondorFile.tag
          FROM CondorFile WHERE tag LIKE '%_OCC_%' AND metadata LIKE '%"referenceScanID":"%' AND deletedAt IS NULL;
          
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET exit_loop = TRUE;

  OPEN CUR;
  read_loop: LOOP

	  FETCH CUR INTO CurFileID, CurFileMetadata, CurOwnerID, CurFileTag;

		IF exit_loop THEN
			CLOSE CUR;
			LEAVE read_loop;
		END IF;
		
    
		SET @refScanDelimiter = SUBSTRING_INDEX(CurFileMetadata, '"referenceScanID":"', -1); 
		SET @refScanID = SUBSTRING_INDEX(@refScanDelimiter, ':', 1);
        
		SET @actDelemiter = SUBSTRING_INDEX(CurFileTag, '_ACT_', -1); 
        SET @curActID = SUBSTRING_INDEX(@actDelemiter, '_', 1);
		SET @sessionDelemiter = SUBSTRING_INDEX(CurFileTag, '_SESS_', -1); 
        SET @curSessionID = SUBSTRING_INDEX(@sessionDelemiter, '_', 1);
        
        
        
		IF @curActID is NOT NULL AND @curSessionID is NOT NULL THEN
        
			SET @actOwnerID = (SELECT ownerID FROM Act WHERE id = @curActID);
			SET @sessionOwnerID = (SELECT ownerID FROM Session WHERE id = @curSessionID);
            
            
            IF @actOwnerID = CurOwnerID AND @sessionOwnerID = CurOwnerID THEN
            
				SET @scanNo = SUBSTRING_INDEX(@refScanID,'.',-1);
				SET @scanType = '';
				SET @findTopScan = CurFileTag LIKE '%_TOPLY_%';
				SET @findBottomScan = CurFileTag LIKE '%_BOPLY_%';
				
				IF @findTopScan > 0 THEN
					SET @scanType = 'MAXILLAIRE';
				ELSEIF @findBottomScan > 0 THEN
					SET @scanType = 'MANDIBULE';
				ELSE 
					ITERATE read_loop;
				END IF;
                 
                SET @scanID = (SELECT id FROM Scan WHERE ownerID = CurOwnerID AND sessionID = @curSessionID AND displayID = @scanNo AND scanType = @scanType AND deletedAt IS NULL );
				SET @occlusionID =  SUBSTRING_INDEX(SUBSTRING_INDEX(CurFileTag, '_OCC_', -1), '_', 1); 
				
				IF @occlusionID IS NULL THEN 
					ITERATE read_loop;
				END IF;
	
				IF @findTopScan > 0 THEN
					UPDATE Occlusion SET topScanID = @scanID WHERE id = @occlusionID;
				ELSEIF @findBottomScan > 0 THEN
					UPDATE Occlusion SET bottomScanID = @scanID WHERE id = @occlusionID;
				END IF; 
                
            END IF;
		
        END IF;
         
  END LOOP;

END BLOCK1 ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `migrateLifiOcclusionFiles` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `migrateLifiOcclusionFiles`()
    NO SQL
BEGIN

  DECLARE CurOwnerID MEDIUMINT(8) UNSIGNED;
  DECLARE CurFilePath TEXT;
  DECLARE CurFileID CHAR(36);
  DECLARE CurFileTag VARCHAR(250);
  DECLARE CurFileType VARCHAR(250);
  DECLARE CurFileMetadata TEXT;
  
  DECLARE exit_loop BOOLEAN DEFAULT FALSE;
  
  DECLARE read_sessionid TEXT;

  
  DECLARE CUR CURSOR FOR
          SELECT CondorFile.ownerID, CondorFile.id, CondorFile.tag, CondorFile.path, CondorFile.type, CondorFile.metadata
          FROM CondorFile
	  WHERE type LIKE '%LIFI%' AND metadata LIKE '%"isOcclusionMarginLine":true%' AND id NOT IN (SELECT fileID FROM ReceivedAttachment);

  DECLARE CONTINUE HANDLER FOR NOT FOUND SET exit_loop = TRUE;
  
  OPEN CUR;
  read_loop: LOOP

  FETCH CUR INTO CurOwnerID, CurFileID, CurFileTag, CurFilePath, CurFileType, CurFileMetadata;

	
	
	IF exit_loop THEN
		CLOSE CUR;
		LEAVE read_loop;
	END IF;
		
	SET @sessionDelimiter = SUBSTRING_INDEX(CurFileTag, '_SESS_', -1);
        SET @curSessionID = SUBSTRING_INDEX(@sessionDelimiter, '_', 1);
        
	SELECT ownerID, id INTO @occlusionOwnerID, @occlusionID FROM Occlusion WHERE sessionID = @curSessionID;
      
	
        
	IF @occlusionID IS NOT NULL AND @occlusionOwnerID = CurOwnerID THEN

		SET @pleft = SUBSTRING_INDEX(CurFileTag, @curSessionID, 1);
		SET @newTag = CONCAT(@pleft, @curSessionID, '_OCC_', @occlusionID, '_', CurFileType, 'O_', CurFileType, '_');
            
		SET @filename = SUBSTRING_INDEX(CurFilePath, '/', -1);
		SET @scanPath = SUBSTRING_INDEX(CurFilePath, '/', -2);
		SET @sessionPath = SUBSTRING_INDEX(CurFilePath, @scanPath, 1);
		SET @newFilePath = CONCAT(@sessionPath, 'computedocclusion_', @occlusionID, '/', @filename);

		UPDATE CondorFile SET tag = @newTag, path = @newFilePath WHERE id = CurFileID;
             
		
		INSERT INTO OcclusionFile(ownerID, fileID, occlusionID, lastUpdated)
		VALUES (CurOwnerID, CurFileID, @occlusionID, CURRENT_TIMESTAMP);

		
		SET @scanID = (SELECT scanID FROM ScanFile WHERE fileID = CurFileID);

		IF @scanID IS NOT NULL THEN
			SET @scanType = (SELECT scanType FROM Scan WHERE id = @scanID);

			IF @scanType is not NULL THEN
				SET @currentMetadata = SUBSTRING_INDEX(CurFileMetadata, '}', 1);
				SET @lifiScanType = CONCAT('"lifi_scan_type":"', @scanType, '"');
				SET @newMetadata = CONCAT(@currentMetadata, ',', @lifiScanType, '}');

				UPDATE CondorFile SET metadata = @newMetadata WHERE id = CurFileID;
			END IF;

		END IF;

            
            DELETE FROM ScanFile WHERE fileID = CurFileID;

	END IF;

  END LOOP;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `migrateOcclusions` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `migrateOcclusions`()
    NO SQL
BEGIN
  DECLARE CurOwnerID MEDIUMINT(8) UNSIGNED;
  DECLARE CurSessionID CHAR(36);
  DECLARE CurMandibuleOcclusionPlyID CHAR(36);
  DECLARE CurMaxillaireOcclusionPlyID CHAR(36);
  DECLARE CurMatrixTransformationMandibuleID CHAR(36);
  DECLARE CurMatrixTransformationMaxillaireID CHAR(36);
  DECLARE CurSnapshotID CHAR(36);
  
  
  DECLARE TopScanID CHAR(36);
  DECLARE BottomScanID CHAR(36);
  DECLARE CheckIntegrity BOOLEAN DEFAULT FALSE;

  DECLARE NewOcclusionID CHAR(36);
  DECLARE exit_loop BOOLEAN DEFAULT FALSE;

  
  DECLARE CUR CURSOR FOR
          SELECT Session.ownerID, Session.id, Session.mandibuleOcclusionPlyID, Session.maxillaireOcclusionPlyID,
					Session.matrixTransformationMandibuleID, Session.matrixTransformationMaxillaireID, Session.snapshotID
          FROM Session WHERE deletedAt IS NULL AND mandibuleOcclusionPlyID IS NOT NULL AND maxillaireOcclusionPlyID IS NOT NULL AND
					matrixTransformationMandibuleID IS NOT NULL AND matrixTransformationMaxillaireID IS NOT NULL AND snapshotID IS NOT NULL;
          
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET exit_loop = TRUE;

  OPEN CUR;
  read_loop: LOOP

  FETCH CUR INTO CurOwnerID, CurSessionID, CurMandibuleOcclusionPlyID, CurMaxillaireOcclusionPlyID,
					CurMatrixTransformationMandibuleID, CurMatrixTransformationMaxillaireID, CurSnapshotID;

    
    
    IF exit_loop THEN
	CLOSE CUR;
	LEAVE read_loop;
    END IF;

	SET TopScanID = (SELECT scanID from ScanFile WHERE fileID = CurMaxillaireOcclusionPlyID);
    SET BottomScanID = (SELECT scanID from ScanFile WHERE fileID = CurMandibuleOcclusionPlyID);

    
	
	

	
	
    
    SET NewOcclusionID = concat(left(CurSessionID, length(CurSessionID) - 9), 'migraoccl');
	
	INSERT INTO Occlusion(ownerID, id, sessionID, occlusionType, deletedAt, createdAt, lastSynced, lastModified, lastUpdated, topScanID, bottomScanID, 
							anteriorBiteScanID, rightBiteScanID, leftBiteScanID, snapshotID, mandibuleOcclusionPlyID, maxillaireOcclusionPlyID, matrixTransformationMandibuleID, 
							matrixTransformationMaxillaireID)
							VALUES (CurOwnerID, NewOcclusionID, CurSessionID, NULL, NULL, CURRENT_TIMESTAMP, NULL, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP, TopScanID, BottomScanID,
							NULL, NULL, NULL, CurSnapshotID, CurMandibuleOcclusionPlyID, CurMaxillaireOcclusionPlyID, CurMatrixTransformationMandibuleID,
							CurMatrixTransformationMaxillaireID);
	
	
	INSERT INTO OcclusionFile(ownerID, fileID, occlusionID, lastUpdated)
							VALUES (CurOwnerID, CurMandibuleOcclusionPlyID, NewOcclusionID, CURRENT_TIMESTAMP);
	INSERT INTO OcclusionFile(ownerID, fileID, occlusionID, lastUpdated)
							VALUES (CurOwnerID, CurMaxillaireOcclusionPlyID, NewOcclusionID, CURRENT_TIMESTAMP);
	INSERT INTO OcclusionFile(ownerID, fileID, occlusionID, lastUpdated)
							VALUES (CurOwnerID, CurMatrixTransformationMandibuleID, NewOcclusionID, CURRENT_TIMESTAMP);
	INSERT INTO OcclusionFile(ownerID, fileID, occlusionID, lastUpdated)
							VALUES (CurOwnerID, CurMatrixTransformationMaxillaireID, NewOcclusionID, CURRENT_TIMESTAMP);
	INSERT INTO OcclusionFile(ownerID, fileID, occlusionID, lastUpdated)
							VALUES (CurOwnerID, CurSnapshotID, NewOcclusionID, CURRENT_TIMESTAMP);          
    


  END LOOP;
  
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `script176` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `script176`()
    NO SQL
BEGIN
    
    DROP TABLE IF EXISTS `ProstheticSheet`;
    CREATE TABLE `ProstheticSheet` (
        `id` char(36) NOT NULL,
        `ownerID` mediumint(8) unsigned NOT NULL,
        `orderID` char(36) NOT NULL,
        `json` TEXT NOT NULL,
        `pdfFileID` char(36) DEFAULT NULL,
        `dateCreated` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
        `deletedAt` datetime DEFAULT NULL,
        `lastSynced` datetime DEFAULT NULL,
        `lastModified` datetime NOT NULL,
        `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`,`ownerID`),
        CONSTRAINT `fk_ProstheticSheet_ProstheticOrder` FOREIGN KEY (`orderID`) REFERENCES `ProstheticOrder` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
        CONSTRAINT `fk_ProstheticSheet_CondorFile` FOREIGN KEY (`pdfFileID`) REFERENCES `CondorFile` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

    
    UPDATE ProstheticOrder SET createdAt = lastUpdated WHERE createdAt IS NULL;

    
    INSERT INTO ProstheticSheet (id, ownerID, orderID, json, dateCreated, deletedAt, lastSynced, lastModified, lastUpdated)
    SELECT
        PO.id as id,
        PO.ownerID,
        PO.id as orderID,
        CONCAT('{"sheetTitle":"', PO.title, '",', RIGHT(PO.json, LENGTH(PO.json)-1)), 
        PO.createdAt as dateCreated,
        PO.deletedAt,
        PO.lastSynced,
        PO.lastModified,
        PO.lastUpdated
    FROM ProstheticOrder AS PO;

    CREATE TEMPORARY TABLE PDF_ID_TMP
    SELECT POF1.orderID, POF1.fileID, CF1.version, T.maxVersion
    FROM ProstheticOrderFile AS POF1
    INNER JOIN CondorFile AS CF1 ON POF1.fileID = CF1.id
    INNER JOIN (
        SELECT POF2.orderID, MAX(CF2.version) AS maxVersion
        FROM ProstheticOrderFile AS POF2
        INNER JOIN CondorFile AS CF2 ON POF2.fileID = CF2.id
        WHERE CF2.type = 'PDF'
        GROUP BY POF2.orderID
    ) T ON POF1.orderID = T.orderID
    WHERE CF1.type = 'PDF' AND CF1.version = T.maxVersion;

    UPDATE ProstheticSheet AS PS
    INNER JOIN PDF_ID_TMP AS PDF ON PDF.orderID = PS.orderID
    SET PS.pdfFileID = PDF.fileID;

    DROP TEMPORARY TABLE PDF_ID_TMP;

    
    
    

    ALTER TABLE SyncInfo ADD prostheticSheetsLastRetrieved DATETIME NULL AFTER smilersordersLastRetrieved;

    ALTER TABLE ProstheticOrder DROP COLUMN json;

    ALTER TABLE ToothInfo ADD prostheticSheetID char(36) NOT NULL AFTER toothNumber;

    UPDATE ToothInfo AS TI
    INNER JOIN ProstheticSheet AS PS on TI.orderID = PS.orderID
    SET TI.prostheticSheetID = PS.id;

    
    
    

    
    ALTER TABLE ToothInfo DROP FOREIGN KEY fk_ToothInfo_Order;

    
    ALTER TABLE ToothInfo ADD CONSTRAINT `fk_ToothInfo_ProstheticSheet` FOREIGN KEY (`prostheticSheetID`) REFERENCES `ProstheticSheet` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

    ALTER TABLE ToothInfo DROP PRIMARY KEY;
    ALTER TABLE ToothInfo ADD PRIMARY KEY (ownerID, toothNumber, prostheticSheetID);

    ALTER TABLE ToothInfo DROP COLUMN orderID;

    
    
    

    INSERT INTO `__db_version__`(`version_major`, `version_minor`, `title`, `commit`, `migration_file`, `version_core`, `version_IHM`) VALUES
    (1, 76, 'v1.76', '', 'migration_condor_local_1.76_add_table_ProstheticSheet_from_180', '4.4.0', '2.3.4');

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `updateOcclusionsCondorFilesTag` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `updateOcclusionsCondorFilesTag`()
    NO SQL
BEGIN

  DECLARE CurFilePath TEXT;
  DECLARE CurFileID CHAR(36);
  DECLARE CurFileTag VARCHAR(250);
  DECLARE exit_loop BOOLEAN DEFAULT FALSE;
  
  DECLARE read_sessionid TEXT;

  
  DECLARE CUR CURSOR FOR
          SELECT CondorFile.id, CondorFile.tag, CondorFile.path
          FROM CondorFile 
	  WHERE tag REGEXP '_TOMA_|_BOMA_|_TOPLY_|_BOPLY_|_SNAPO_' AND id NOT IN (SELECT fileID FROM ReceivedAttachment);

  DECLARE CONTINUE HANDLER FOR NOT FOUND SET exit_loop = TRUE;

  OPEN CUR;
  read_loop: LOOP

  FETCH CUR INTO CurFileID, CurFileTag, CurFilePath;

	
	
	IF exit_loop THEN
		CLOSE CUR;
		LEAVE read_loop;
	END IF;
		
        SET @sessionDelimiter = SUBSTRING_INDEX(CurFileTag, '_SESS_', -1); 
        SET @curSessionID = SUBSTRING_INDEX(@sessionDelimiter, '_', 1);
        
        
	Set @occlusionID = (SELECT id FROM Occlusion WHERE sessionID = @curSessionID AND deletedAt IS NULL);
      
	IF @occlusionID is not NULL THEN

		SET @pleft = SUBSTRING_INDEX(CurFileTag, @curSessionID, 1); 
		SET @pright = SUBSTRING_INDEX(CurFileTag, @curSessionID, -1); 
		SET @newTag = CONCAT(@pleft, @curSessionID, '_OCC_', @occlusionID, @pright);

		SET @filename = SUBSTRING_INDEX(CurFilePath, '/', -1);
		SET @sessionPath = SUBSTRING_INDEX(CurFilePath, @filename, 1);
		SET @newFilePath = CONCAT(@sessionPath, 'computedocclusion_', @occlusionID, '/', @filename);

		UPDATE CondorFile SET tag = @newTag, path = @newFilePath WHERE id = CurFileID;
        END IF;
        
  END LOOP;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `updateScanDisplayID` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `updateScanDisplayID`()
    NO SQL
BEGIN
  DECLARE CurOwnerID MEDIUMINT(8) UNSIGNED;
  DECLARE CurID CHAR(36);
  DECLARE CurSessionID CHAR(36);
  DECLARE CurLastSync DATETIME;

  DECLARE CurScanType
  ENUM('MAXILLAIRE', 'MANDIBULE', 'MORDU_ANTERIEUR', 'MORDU_POSTERIEUR_GAUCHE', 'MORDU_POSTERIEUR_DROIT');

  DECLARE CurNbSyncScan INT;
  DECLARE CurMaxDisplayID INT;

  DECLARE exit_loop BOOLEAN DEFAULT FALSE;

  DECLARE CUR CURSOR FOR
          SELECT Scan.ownerID, Scan.id, Scan.sessionID, Scan.scanType, Scan.lastSynced
          FROM Scan;

  DECLARE CONTINUE HANDLER FOR NOT FOUND SET exit_loop = TRUE;

  OPEN CUR;
  read_loop: LOOP

  FETCH CUR INTO CurOwnerID, CurID, CurSessionID, CurScanType, CurLastSync;

    
    
    IF exit_loop THEN
	CLOSE CUR;
	LEAVE read_loop;
    END IF;

    IF CurLastSync IS NULL THEN

	SET CurNbSyncScan = (SELECT COUNT(*)
				FROM Scan
				WHERE ownerID = CurOwnerID AND sessionID = CurSessionID AND scanType = CurScanType AND lastSynced IS NOT NULL);


	SET CurMaxDisplayID = (SELECT MAX(displayID)
				FROM Scan
				WHERE ownerID = CurOwnerID AND sessionID = CurSessionID AND scanType = CurScanType);

    	IF CurMaxDisplayID IS NULL OR CurMaxDisplayID = 0 THEN
		
        	SET CurMaxDisplayID = CurNbSyncScan;
    	END IF;

    	UPDATE Scan
    	SET displayID = (CurMaxDisplayID + 1)
    	WHERE ownerID = CurOwnerID AND id = CurID;

    END IF;

  END LOOP;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-06-12 11:27:21
