-- MySQL dump 10.13  Distrib 8.0.30, for Linux (x86_64)
--
-- Host: localhost    Database: wow_client
-- ------------------------------------------------------
-- Server version	8.0.30-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `Camera`
--

DROP TABLE IF EXISTS `Camera`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Camera` (
  `reference` char(13) NOT NULL,
  PRIMARY KEY (`reference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Camera`
--

LOCK TABLES `Camera` WRITE;
/*!40000 ALTER TABLE `Camera` DISABLE KEYS */;
INSERT INTO `Camera` VALUES ('1517010CR0141'),('1928021WO0537'),('1928021WO0769'),('1928021WO0805'),('1928021WO0812'),('1928021WO0828'),('2005021WO0954'),('2005021WO0961'),('2005021WO1088'),('2049022WO1700'),('2118022WO1991');
/*!40000 ALTER TABLE `Camera` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CameraAccess`
--

DROP TABLE IF EXISTS `CameraAccess`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CameraAccess` (
  `professionalId` mediumint unsigned NOT NULL,
  `computerMac` char(17) NOT NULL,
  `cameraReference` char(13) NOT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`professionalId`,`computerMac`,`cameraReference`),
  KEY `computerMac` (`computerMac`),
  KEY `cameraReference` (`cameraReference`),
  CONSTRAINT `CameraAccess_ibfk_1` FOREIGN KEY (`professionalId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `CameraAccess_ibfk_2` FOREIGN KEY (`computerMac`) REFERENCES `Computer` (`mac`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `CameraAccess_ibfk_3` FOREIGN KEY (`cameraReference`) REFERENCES `Camera` (`reference`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CameraAccess`
--

LOCK TABLES `CameraAccess` WRITE;
/*!40000 ALTER TABLE `CameraAccess` DISABLE KEYS */;
INSERT INTO `CameraAccess` VALUES (3,'00:d8:61:08:37:31','2005021WO1088','2021-09-21 09:33:52.000','2021-09-21 11:33:52.000'),(650,'00:d8:61:08:37:31','1928021WO0537','2020-07-16 11:03:04.000','2020-07-16 13:03:04.000'),(650,'00:d8:61:08:37:31','1928021WO0769','2020-09-11 07:35:20.000','2020-09-11 09:35:20.000'),(650,'00:d8:61:08:37:31','1928021WO0805','2020-05-03 13:55:55.000','2020-05-03 15:55:55.000'),(650,'00:d8:61:08:37:31','1928021WO0812','2020-04-10 11:52:07.000','2020-04-10 13:52:07.000'),(650,'00:d8:61:08:37:31','1928021WO0828','2020-04-03 08:29:33.000','2020-04-03 10:29:33.000'),(650,'00:d8:61:08:37:31','2005021WO0954','2021-02-15 08:07:18.000','2021-02-15 09:07:18.000'),(650,'00:d8:61:08:37:31','2005021WO0961','2020-11-02 10:39:50.000','2020-11-02 11:39:50.000'),(650,'00:d8:61:08:37:31','2005021WO1088','2021-04-02 16:35:05.000','2021-04-02 18:35:05.000'),(650,'00:d8:61:08:37:31','2049022WO1700','2021-10-19 16:23:31.000','2021-10-19 18:23:31.000'),(650,'00:d8:61:08:37:31','2118022WO1991','2022-11-08 12:40:00.000','2022-11-08 13:40:00.000'),(650,'d8:cb:8a:f4:6d:aa','1517010CR0141','2020-03-11 08:33:42.000',NULL);
/*!40000 ALTER TABLE `CameraAccess` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Computer`
--

DROP TABLE IF EXISTS `Computer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Computer` (
  `mac` char(76) NOT NULL,
  `condorVersionId` varchar(16) DEFAULT NULL,
  `graphicsCard` varchar(50) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`mac`),
  KEY `condorVersionId` (`condorVersionId`),
  CONSTRAINT `Computer_ibfk_1` FOREIGN KEY (`condorVersionId`) REFERENCES `CondorVersion` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Computer`
--

LOCK TABLES `Computer` WRITE;
/*!40000 ALTER TABLE `Computer` DISABLE KEYS */;
INSERT INTO `Computer` VALUES ('00:d8:61:08:37:31','v3.0.1','NVIDIA GeForce RTX 2070 with Max-Q Design','2022-04-04 06:55:44.000','2022-04-04 08:55:44.000'),('d8:cb:8a:f4:6d:aa','v3.3.1','GeForce GTX 980','2019-01-11 13:34:19.000','2019-01-11 14:34:19.000');
/*!40000 ALTER TABLE `Computer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CondorVersion`
--

DROP TABLE IF EXISTS `CondorVersion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CondorVersion` (
  `id` varchar(16) NOT NULL,
  `dbVersion` varchar(10) DEFAULT NULL,
  `ihmVersion` varchar(10) DEFAULT NULL,
  `coreVersion` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CondorVersion`
--

LOCK TABLES `CondorVersion` WRITE;
/*!40000 ALTER TABLE `CondorVersion` DISABLE KEYS */;
INSERT INTO `CondorVersion` VALUES ('v1.0.0',NULL,NULL,NULL),('v2.0.0',NULL,NULL,NULL),('v2.1.1',NULL,NULL,NULL),('v2.2.2',NULL,NULL,NULL),('v2.3.3',NULL,NULL,NULL),('v2.4.4',NULL,NULL,NULL),('v3.0.0',NULL,NULL,NULL),('v3.0.1',NULL,NULL,NULL),('v3.3.1',NULL,NULL,NULL);
/*!40000 ALTER TABLE `CondorVersion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `License`
--

DROP TABLE IF EXISTS `License`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `License` (
  `number` char(23) NOT NULL,
  `professionalId` mediumint unsigned NOT NULL,
  `enabled` enum('NONE','SOFTWARE','WEB','ALL') NOT NULL DEFAULT 'ALL',
  `licenseType` enum('PROD','DEMO') NOT NULL DEFAULT 'PROD',
  PRIMARY KEY (`number`),
  KEY `professionalId` (`professionalId`),
  CONSTRAINT `License_ibfk_1` FOREIGN KEY (`professionalId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `License`
--

LOCK TABLES `License` WRITE;
/*!40000 ALTER TABLE `License` DISABLE KEYS */;
INSERT INTO `License` VALUES ('2003A1NKY68D8CB8AF14E95',2,'ALL','PROD'),('AMFB23TT6WRGERM8NCZCTRI',650,'ALL','PROD'),('JAENAHJEINEITH9WAI5SAIY',3,'ALL','PROD');
/*!40000 ALTER TABLE `License` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `LicenseAccess`
--

DROP TABLE IF EXISTS `LicenseAccess`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LicenseAccess` (
  `professionalId` mediumint unsigned NOT NULL,
  `licenseNumber` char(23) NOT NULL,
  `computerMac` char(17) NOT NULL,
  `condorVersionId` varchar(16) NOT NULL,
  `globalId` mediumint unsigned DEFAULT NULL,
  `status` enum('VALID','REPAIR') NOT NULL DEFAULT 'VALID',
  `activationDate` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`professionalId`,`licenseNumber`,`computerMac`),
  KEY `licenseNumber` (`licenseNumber`),
  KEY `computerMac` (`computerMac`),
  KEY `condorVersionId` (`condorVersionId`),
  CONSTRAINT `LicenseAccess_ibfk_1` FOREIGN KEY (`professionalId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `LicenseAccess_ibfk_2` FOREIGN KEY (`licenseNumber`) REFERENCES `License` (`number`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `LicenseAccess_ibfk_3` FOREIGN KEY (`computerMac`) REFERENCES `Computer` (`mac`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `LicenseAccess_ibfk_4` FOREIGN KEY (`condorVersionId`) REFERENCES `CondorVersion` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LicenseAccess`
--

LOCK TABLES `LicenseAccess` WRITE;
/*!40000 ALTER TABLE `LicenseAccess` DISABLE KEYS */;
INSERT INTO `LicenseAccess` VALUES (2,'2003A1NKY68D8CB8AF14E95','d8:cb:8a:f4:6d:aa','v1.0.0',NULL,'VALID','2017-01-20 09:43:50.000','2020-03-11 08:21:44.000','2017-01-20 09:43:50.000'),(3,'JAENAHJEINEITH9WAI5SAIY','00:d8:61:08:37:31','v2.4.4',12,'VALID','2021-09-21 00:00:00.000','2021-09-21 09:33:51.000','2021-09-21 11:33:51.000'),(650,'AMFB23TT6WRGERM8NCZCTRI','00:d8:61:08:37:31','v3.0.1',1,'VALID','2020-03-11 00:00:00.000','2022-04-04 06:55:44.000','2022-04-04 08:55:44.000');
/*!40000 ALTER TABLE `LicenseAccess` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Professional`
--

DROP TABLE IF EXISTS `Professional`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Professional` (
  `id` mediumint unsigned NOT NULL,
  `firstName` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `mainPhone` varchar(45) DEFAULT NULL,
  `country` varchar(75) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Professional`
--

LOCK TABLES `Professional` WRITE;
/*!40000 ALTER TABLE `Professional` DISABLE KEYS */;
INSERT INTO `Professional` VALUES (2,'THOMAS','VILLETTE','0972550483',NULL),(3,'c2w','prod-test','542138759','France'),(650,'Ollier','Ollier Richard','0473931729','NULL');
/*!40000 ALTER TABLE `Professional` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `__db_version__`
--

DROP TABLE IF EXISTS `__db_version__`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `__db_version__` (
  `id` int NOT NULL AUTO_INCREMENT,
  `versionMajor` int NOT NULL,
  `versionMinor` int NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `migrationFile` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `__db_version__`
--

LOCK TABLES `__db_version__` WRITE;
/*!40000 ALTER TABLE `__db_version__` DISABLE KEYS */;
INSERT INTO `__db_version__` VALUES (1,1,0,'v1.0','migration_wow_client_1.0_create_wow_client_from_condor');
/*!40000 ALTER TABLE `__db_version__` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping routines for database 'wow_client'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-04-25 18:26:30
