-- MySQL dump 10.13  Distrib 8.0.28, for Linux (x86_64)
--
-- Host: localhost    Database: condor
-- ------------------------------------------------------
-- Server version	8.0.28-0ubuntu0.20.04.3

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `Act`
--

DROP TABLE IF EXISTS `Act`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Act` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `title` varchar(64) DEFAULT NULL,
  `dateCreated` datetime DEFAULT NULL,
  `comments` mediumtext,
  `globalDisplayID` mediumint unsigned DEFAULT NULL,
  `displayID` mediumint unsigned DEFAULT NULL,
  `patientID` char(36) NOT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastAccessed` datetime NOT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Work_Patient` (`patientID`,`ownerID`),
  CONSTRAINT `fk_Act_Patient` FOREIGN KEY (`patientID`) REFERENCES `condor_patient_local`.`Patient` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Act`
--

LOCK TABLES `Act` WRITE;
/*!40000 ALTER TABLE `Act` DISABLE KEYS */;
INSERT INTO `Act` VALUES (524,'07e9596f-88c8-44a1-9e02-dfcbeeb0497c','bridge 35-37','2020-09-30 12:36:09','',1,1,'182873b3-d53c-4aaf-9465-b1e9b4278e75','','',NULL,'2020-10-07 08:53:04',NULL,'2020-10-07 06:53:19','2020-10-07 08:53:19'),(524,'0f70da2a-5818-43cb-880a-48a2118b94b0','','2020-01-24 08:24:38','',1,1,'e24bfe17-3078-4656-88ba-8371e0369a7b','','','2020-01-25 09:09:31','2020-01-24 08:24:38',NULL,'2020-01-25 08:09:31','2020-01-24 08:24:38'),(524,'1e0f2e65-454c-4e38-abe9-7cea55b078b4','','2023-02-02 12:29:37','',1,1,'b9ea15f7-ef29-4ade-b8c3-2c04434862a1','','',NULL,'2023-02-02 12:29:37',NULL,'2023-02-02 11:29:37','2023-02-02 12:29:37'),(524,'29e4742c-2f16-4c10-96f6-e4e47f9948a6','','2020-09-30 12:09:45','',1,1,'bf69875d-af07-40ca-a97f-9643150c5913','','','2020-09-30 12:09:50','2020-09-30 12:09:45','2020-09-30 12:09:50','2020-09-30 10:09:50','2020-09-30 12:09:45'),(524,'3f1e9539-3cc5-475b-8ed7-477aad47ffa4','','2020-01-23 08:55:32','',1,1,'ae1b89fc-1858-4a4a-9e42-3fd133abcb1c','','','2020-01-23 08:55:45','2020-01-23 08:55:32',NULL,'2020-01-23 07:55:45','2020-01-23 08:55:32'),(524,'429beadb-0c5a-48b3-8940-1e4fe4a835a3','35 Couronne','2020-02-08 09:34:07','',1,1,'77a534cd-8e81-4d67-9393-9f9a9b03e52c','','',NULL,'2020-09-30 12:11:43','2020-09-30 12:12:09','2020-09-30 10:12:09','2020-09-30 12:12:09'),(524,'4dbe54be-76e7-4c55-8510-236002f4572f','EMPREINTE SMILERS','2020-01-22 14:05:42','',1,1,'5e1c39c4-bfce-46b5-924b-131fc5789ca0','','',NULL,'2020-01-23 10:57:34','2020-01-25 11:09:26','2020-01-25 10:09:26','2020-01-23 10:58:58'),(524,'670e452c-202b-4784-9e3f-df43033bef70','','2020-01-23 08:55:02','',1,1,'37e30dc1-659c-4c18-943a-7301f67af622','','','2020-01-23 08:55:30','2020-01-23 08:55:02',NULL,'2020-01-23 07:55:30','2020-01-23 08:55:02'),(524,'68c2ce3d-9d7f-4a09-a042-4f337f0d0f99','INLAY','2020-02-03 18:30:15','',1,1,'ca68987b-cfa7-4f89-ae77-d77610474e05','','',NULL,'2020-02-03 18:50:13','2020-02-03 18:50:13','2020-02-03 17:50:13','2020-02-03 18:49:49'),(524,'922d11e9-0035-47b7-a24b-e7f9062d19ee','','2020-01-23 09:24:26','',1,1,'0934e6d0-76ee-4665-be49-a74de2291879','','','2020-01-23 09:25:47','2020-01-23 09:24:26',NULL,'2020-01-23 08:25:47','2020-01-23 09:25:43'),(524,'a6b67258-2380-4a5e-9802-45192f586f42','','2020-01-23 09:25:58','',1,1,'46784e98-9d89-44f5-8232-33e8d9da1922','','','2020-01-23 09:28:10','2020-01-23 09:25:58',NULL,'2020-01-23 08:28:10','2020-01-23 09:28:08'),(524,'b2025ef0-3849-4ea4-b6bd-aba788c9e831','couronne 36','2020-09-30 12:10:17','',1,2,'5e1c39c4-bfce-46b5-924b-131fc5789ca0','','',NULL,'2020-09-30 12:18:32','2020-09-30 12:27:22','2020-09-30 10:27:22','2020-09-30 12:27:22'),(524,'c17f5fc7-527b-4442-8b45-21d1156392cd','','2020-01-23 08:49:58','',1,1,'b1226e29-6a03-40b5-bf0a-543a6cddb914','','','2020-01-23 08:54:59','2020-01-23 08:49:58','2020-01-23 08:54:59','2020-01-23 07:54:59','2020-01-23 08:54:28'),(524,'c2463b05-c212-4f06-9956-da9ba480f046','','2020-01-22 14:45:07','',1,1,'93ee4723-881c-4e19-a7de-b884552ebd9e','','','2020-01-22 14:55:11','2020-01-22 14:45:07',NULL,'2020-01-22 13:55:11','2020-01-22 14:55:06'),(524,'c25c3b35-6072-4013-9f98-0c3ef69340f7','','2022-03-04 15:29:59','',1,1,'f873a927-05d1-4b46-8446-10bab1a6650b','','','2022-03-04 15:49:44','2022-03-04 15:29:59',NULL,'2022-03-04 14:49:44','2022-03-04 15:38:27'),(524,'c9fa75d9-76a0-4039-96a3-a48c25a33ab7','','2020-01-23 08:56:00','',1,1,'20e6ca25-7792-47c0-aeec-6eb5901306f8','','','2020-01-23 09:24:16','2020-01-23 08:56:00',NULL,'2020-01-23 08:24:16','2020-01-23 08:56:00'),(524,'cb2bc872-bbcd-4cdc-a383-bcbce19592fe','','2022-03-04 15:27:30','',1,1,'70cc3a46-c5c6-4886-8f7d-34da7ab423b9','','','2022-03-04 15:28:47','2022-03-04 15:27:30',NULL,'2022-03-04 14:28:47','2022-03-04 15:27:30'),(524,'d94695aa-41a6-41b3-b59c-28f69616feed','','2020-01-22 13:27:25','',1,1,'5ed9b6f7-72bc-4520-ad4a-c429d25af1fc','','','2020-01-22 13:27:47','2020-01-22 13:27:25','2020-01-22 13:27:47','2020-01-22 12:27:47','2020-01-22 13:27:25'),(524,'e4f3f501-0920-4580-a2a7-147aac8ee471','couronne 36','2020-01-22 13:28:56','',1,1,'2a40421f-a9d5-41ba-9038-ffb6617b8b4b','','',NULL,'2020-01-23 16:14:12','2020-01-25 11:09:25','2020-01-25 10:09:25','2020-01-25 09:02:17'),(524,'f527d743-0ed6-4923-aaa0-eb5b3e0f1972','Photos','2020-07-16 14:55:04','',1,1,'c7c5c1f3-addc-49f3-a0b7-bebfd70b71ba','','',NULL,'2020-07-16 14:55:04','2020-09-30 12:09:17','2020-09-30 10:09:17','2020-07-16 14:55:04'),(524,'fc376534-a331-4355-a7e9-6634e5578e6f','','2022-03-04 15:51:48','',1,1,'8acd5db9-383d-4654-9948-3c74894f71af','','','2023-02-02 12:29:32','2022-03-04 15:51:48',NULL,'2023-02-02 11:29:32','2022-03-04 15:51:48'),(524,'ff268208-714c-466b-b3f9-edf5ae230cd9','','2020-01-23 10:53:43','',1,1,'40fa3bff-2fd4-4187-bdbd-2e2d0bd52f68','','','2020-01-23 10:57:17','2020-01-23 10:53:43',NULL,'2020-01-23 09:57:17','2020-01-23 10:53:43');
/*!40000 ALTER TABLE `Act` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AddressInfo`
--

DROP TABLE IF EXISTS `AddressInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AddressInfo` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `line_0` varchar(255) DEFAULT NULL,
  `line_1` varchar(255) DEFAULT NULL,
  `line_2` varchar(255) DEFAULT NULL,
  `detail` varchar(255) DEFAULT NULL,
  `cityName` varchar(255) DEFAULT NULL,
  `cityState` varchar(255) DEFAULT NULL,
  `cityZip` varchar(25) DEFAULT NULL,
  `countryName` varchar(255) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_AddressInfo_Professional` (`ownerID`),
  CONSTRAINT `fk_AddressInfo_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AddressInfo`
--

LOCK TABLES `AddressInfo` WRITE;
/*!40000 ALTER TABLE `AddressInfo` DISABLE KEYS */;
INSERT INTO `AddressInfo` VALUES (1,1,'Labege','','',NULL,'Labege','','31670','France',NULL,NULL,'2019-06-28 16:00:23'),(2,1,'137 rue garance','','',NULL,'LABEGE','','31670','France',NULL,NULL,'2019-07-01 06:54:35'),(3,1,'137 rue Garance','','',NULL,'Labège','','31670','France',NULL,NULL,'2019-07-01 12:13:31'),(5,1,'','','',NULL,'HOENHEIM','','','France',NULL,NULL,'2019-07-02 15:25:01'),(6,1,'','','',NULL,'Marseille','','','France',NULL,NULL,'2019-07-07 04:24:25'),(7,1,'','','',NULL,'MERIGNAC','','','France',NULL,NULL,'2019-07-08 17:46:42'),(8,1,'','','',NULL,'MERIGNAC','','','France',NULL,NULL,'2019-07-02 13:36:09'),(9,1,'','','',NULL,'Villiers Sur Marne','','','France',NULL,NULL,'2019-07-02 09:28:10'),(28,1,'','','',NULL,'lyon','','','France',NULL,NULL,'2019-07-18 12:19:16'),(33,1,'','','',NULL,'','','','',NULL,NULL,'2019-07-15 12:34:40'),(59,1,'','','',NULL,'LE TEIL','','','France',NULL,NULL,'2019-09-05 15:19:00'),(130,1,'','','',NULL,'Strasbourg','','','France',NULL,NULL,'2019-07-26 13:02:27'),(155,1,'','','',NULL,'ECOUFLANT','','','France',NULL,NULL,'2019-08-27 12:25:03'),(172,1,'4 Chemin Couralis','','',NULL,'LAROIN','','64110','France',NULL,NULL,'2019-08-19 15:46:21'),(177,1,'AVDA. JUAN CARAMUEL,1','','',NULL,'LEGANES','','28916','España',NULL,NULL,'2019-08-26 09:09:47'),(193,1,'','','',NULL,'VIRIAT ','','','France',NULL,NULL,'2019-09-05 19:11:53'),(224,1,'','','',NULL,'CUGNAUX','','','France',NULL,NULL,'2019-09-09 13:32:36'),(225,1,'','','',NULL,'PARIS','','','France',NULL,NULL,'2019-09-10 08:20:33'),(317,1,'','','',NULL,'LONGWY','','','France',NULL,NULL,'2019-12-09 10:58:34'),(339,1,'','','',NULL,'Paris','','','France',NULL,NULL,'2019-10-15 08:41:09'),(355,1,'','','',NULL,'Parma','','','Italia',NULL,NULL,'2019-10-23 10:54:50'),(375,1,'95, Avenue de la Marne','','',NULL,'Epinay sur Seine','','93800','France',NULL,NULL,'2019-10-28 12:42:01'),(377,1,'51 rue moncey','','',NULL,'LYON','','69003','France',NULL,NULL,'2019-10-28 14:15:50'),(421,1,'','','',NULL,'PARIS 17','','','France',NULL,NULL,'2019-11-25 15:36:35'),(524,1,'3 bld foch','','',NULL,'selestat','','67600','France',NULL,NULL,'2020-01-22 12:09:10'),(525,1,'','','',NULL,'Molsheim','','','France',NULL,NULL,'2020-01-22 12:53:00'),(568,1,'','','',NULL,'Tlse','','','France',NULL,NULL,'2020-02-04 14:19:54'),(652,1,'','','',NULL,'','','','',NULL,NULL,'2020-03-12 13:49:16'),(681,1,'','','',NULL,'Chamalières ','','','France',NULL,NULL,'2020-06-02 20:16:29'),(689,1,'','','',NULL,'CHAMBERY','','','France',NULL,NULL,'2020-06-02 10:44:27'),(805,1,'137 rue Garance','','',NULL,'Labege','','31670','France',NULL,NULL,'2020-12-09 10:04:46'),(838,1,'','','',NULL,'','','','',NULL,NULL,'2021-01-22 13:37:07'),(840,1,'','','',NULL,'','','','',NULL,NULL,'2021-01-22 15:28:38'),(850,1,'52 RUE DU BOURNO','','',NULL,'BOEGE','','74420','France',NULL,NULL,'2021-02-01 13:49:44'),(899,1,'VIA E.TAZZOLI','','',NULL,'CASERTA','','81100','Italia',NULL,NULL,'2021-04-03 09:51:30'),(916,1,'','','',NULL,'','','','',NULL,NULL,'2021-04-28 12:05:53'),(917,1,'','','',NULL,'','','','',NULL,NULL,'2021-04-28 12:53:31'),(918,1,'','','',NULL,'Paris','','','France',NULL,NULL,'2021-04-29 14:05:22'),(941,1,'','','',NULL,'','','','',NULL,NULL,'2021-06-07 12:52:03');
/*!40000 ALTER TABLE `AddressInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Assistant`
--

DROP TABLE IF EXISTS `Assistant`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Assistant` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `patientRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'READ_ONLY',
  `actRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'READ_ONLY',
  `discussionRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'READ_ONLY',
  `credentialsID` mediumint unsigned DEFAULT NULL,
  `personInfoID` mediumint unsigned DEFAULT NULL,
  `phoneInfoID` mediumint unsigned DEFAULT NULL,
  `addressInfoID` mediumint unsigned DEFAULT NULL,
  `officeID` char(36) DEFAULT NULL,
  `tempPassword` varchar(32) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `lastConnection` timestamp NULL DEFAULT NULL,
  `firstConnection` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Assistant_Professional` (`ownerID`),
  KEY `fk_Assistant_Credentials` (`credentialsID`,`ownerID`),
  KEY `fk_Assistant_PersonInfo` (`personInfoID`,`ownerID`),
  KEY `fk_Assistant_PhoneInfo` (`phoneInfoID`,`ownerID`),
  KEY `fk_Assistant_AddressInfo` (`addressInfoID`,`ownerID`),
  KEY `fk_Assistant_Office` (`officeID`,`ownerID`),
  CONSTRAINT `fk_Assistant_AddressInfo` FOREIGN KEY (`addressInfoID`, `ownerID`) REFERENCES `AddressInfo` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Assistant_Credentials` FOREIGN KEY (`credentialsID`, `ownerID`) REFERENCES `Credentials` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Assistant_Office` FOREIGN KEY (`officeID`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Assistant_PersonInfo` FOREIGN KEY (`personInfoID`, `ownerID`) REFERENCES `PersonInfo` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Assistant_PhoneInfo` FOREIGN KEY (`phoneInfoID`, `ownerID`) REFERENCES `PhoneInfo` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Assistant_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Assistant`
--

LOCK TABLES `Assistant` WRITE;
/*!40000 ALTER TABLE `Assistant` DISABLE KEYS */;
/*!40000 ALTER TABLE `Assistant` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `Assistant_AFTER_DELETE` AFTER DELETE ON `Assistant` FOR EACH ROW BEGIN
	DELETE FROM PersonInfo  WHERE ownerID = OLD.ownerID AND id = OLD.personInfoID;
	DELETE FROM AddressInfo WHERE ownerID = OLD.ownerID AND id = OLD.addressInfoID;
	DELETE FROM PhoneInfo   WHERE ownerID = OLD.ownerID AND id = OLD.phoneInfoID;
	DELETE FROM Credentials WHERE ownerID = OLD.ownerID AND id = OLD.credentialsID;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `CircleOrder`
--

DROP TABLE IF EXISTS `CircleOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CircleOrder` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `actID` char(36) NOT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `title` varchar(64) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `status` enum('not_sent','waiting_wow_api','sending_wow_api','sending_circle_api','sent','cancelled') NOT NULL DEFAULT 'waiting_wow_api',
  `createdAt` datetime NOT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `json` text NOT NULL,
  `metadata` text NOT NULL,
  `localDisplayID` int unsigned DEFAULT NULL,
  `globalDisplayID` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_CircleOrder_Act` (`actID`,`ownerID`),
  CONSTRAINT `fk_CircleOrder_Act` FOREIGN KEY (`actID`, `ownerID`) REFERENCES `Act` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CircleOrder`
--

LOCK TABLES `CircleOrder` WRITE;
/*!40000 ALTER TABLE `CircleOrder` DISABLE KEYS */;
/*!40000 ALTER TABLE `CircleOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CircleOrderFile`
--

DROP TABLE IF EXISTS `CircleOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CircleOrderFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `orderID` char(36) NOT NULL,
  `fileID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`orderID`,`fileID`),
  KEY `fk_CircleOrderFile_CircleOrder` (`orderID`,`ownerID`),
  KEY `fk_CircleOrderFile_CondorFile` (`fileID`,`ownerID`),
  CONSTRAINT `fk_CircleOrderFile_CircleOrder` FOREIGN KEY (`orderID`, `ownerID`) REFERENCES `CircleOrder` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_CircleOrderFile_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CircleOrderFile`
--

LOCK TABLES `CircleOrderFile` WRITE;
/*!40000 ALTER TABLE `CircleOrderFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `CircleOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CondorFile`
--

DROP TABLE IF EXISTS `CondorFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CondorFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `path` text NOT NULL,
  `type` varchar(250) NOT NULL,
  `tag` varchar(250) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `originalName` varchar(100) DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `status` enum('CREATED','UPDATED','SYNCED','ERROR') DEFAULT NULL,
  `originalID` char(36) NOT NULL,
  `version` mediumint NOT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `metadata` text,
  PRIMARY KEY (`id`,`ownerID`),
  UNIQUE KEY `un_CondorFile_version` (`ownerID`,`originalID`,`version`),
  KEY `fk_CondorFile_Professional` (`ownerID`),
  KEY `fk_CondorFile_CondorFile` (`originalID`,`ownerID`),
  CONSTRAINT `fk_CondorFile_CondorFile` FOREIGN KEY (`originalID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_CondorFile_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CondorFile`
--

LOCK TABLES `CondorFile` WRITE;
/*!40000 ALTER TABLE `CondorFile` DISABLE KEYS */;
INSERT INTO `CondorFile` VALUES (2,'00057e37-5a11-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/00057e37-5a11-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_b2d2515e-7d0a-4904-9d27-ac4e02fba617_SESS_056eaabd-a59c-4879-8f67-008ffb433a0e_BOSC_64e9b74c-2b40-4d4f-84c0-3cb17f506dfb_PLY_','2020-12-16 10:50:58','2020-02-28 10:53:37','00057e37-5a11-11ea-947d-226cec7cb58a.ply','2020-12-16 11:50:58','SYNCED','00057e37-5a11-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"modelMatrix\":\"-0.986366,0.159782,-0.0394005,0,-0.164568,-0.957679,0.236154,0,-1.97894e-9,0.239418,0.970917,0,-9.74739,15.3465,-17.9971,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0007b61c-5a11-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0007b61c-5a11-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_dc626d03-a041-4b5f-9433-09664a7ed4e6_ACT_b2d2515e-7d0a-4904-9d27-ac4e02fba617_SESS_056eaabd-a59c-4879-8f67-008ffb433a0e_TOSC_2eff0026-ccc9-423b-81b5-015ae60a0ea6_PLY_','2020-12-16 10:50:58','2020-02-28 10:50:49','0007b61c-5a11-11ea-947d-226cec7cb58a.ply','2020-12-16 11:50:58','SYNCED','0007b61c-5a11-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"modelMatrix\":\"0.535435,-0.797983,0.276644,0,0.844576,0.505897,-0.175384,0,1.04442e-8,0.327554,0.944832,0,-8.58789,-33.1869,-15.6023,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'000963b7-5a11-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/000963b7-5a11-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_dc626d03-a041-4b5f-9433-09664a7ed4e6_ACT_b2d2515e-7d0a-4904-9d27-ac4e02fba617_SESS_056eaabd-a59c-4879-8f67-008ffb433a0e_TOSC_2eff0026-ccc9-423b-81b5-015ae60a0ea6_SNAPS_','2020-12-16 10:50:59','2020-02-28 10:50:49','000963b7-5a11-11ea-947d-226cec7cb58a.png','2020-12-16 11:50:59','SYNCED','000963b7-5a11-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'000af9d4-5a11-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/000af9d4-5a11-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_b2d2515e-7d0a-4904-9d27-ac4e02fba617_SESS_056eaabd-a59c-4879-8f67-008ffb433a0e_BOSC_64e9b74c-2b40-4d4f-84c0-3cb17f506dfb_SNAPS_','2020-12-16 10:50:59','2020-02-28 10:53:37','000af9d4-5a11-11ea-947d-226cec7cb58a.png','2020-12-16 11:50:59','SYNCED','000af9d4-5a11-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0010d9ec-dffc-4a1f-b561-bcfbea9379ac','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0010d9ec-dffc-4a1f-b561-bcfbea9379ac.ply','PLY','PATIENT_cb792ec3-1780-40fa-b01b-45b72329970a_ACT_bf1e82a2-d47f-4e1e-8585-5081cd72732d_SESS_af593c0e-7054-4435-96a3-d0215b9a1fc1_BOSC_94fdbaee-e5c4-4b24-b8c9-eaf73f18c1eb_PLY_','2021-12-07 08:38:04','2019-08-19 14:20:37','0010d9ec-dffc-4a1f-b561-bcfbea9379ac.ply','2021-12-07 09:38:04','SYNCED','0010d9ec-dffc-4a1f-b561-bcfbea9379ac',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 130.1.1.1\",\"modelMatrix\":\"-0.99907,0.0406562,-0.0143341,0,-0.0431091,-0.942224,0.332197,0,-7.93217e-11,0.332506,0.943101,0,-14.6704,12.686,-25.0713,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0026f8f7-79ad-42f4-9381-a74d12908bd7','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0026f8f7-79ad-42f4-9381-a74d12908bd7.ply','PLY','PATIENT_d175f0ac-06f6-49a0-9ab4-bbd562516521_ACT_aa317266-3fb3-41c2-9073-a3de3bc4c25e_SESS_dfe9ad46-537f-4906-b524-e43990804e77_BOSC_60eb325b-c417-4cd5-b583-f6a1b33e83ee_PLY_','2021-01-06 11:01:41','2019-12-13 15:44:19','0026f8f7-79ad-42f4-9381-a74d12908bd7.ply','2021-01-06 12:01:41','SYNCED','0026f8f7-79ad-42f4-9381-a74d12908bd7',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 232.7.1.1\",\"modelMatrix\":\"-0.848858,0.512865,-0.1281,0,-0.528621,-0.823557,0.205703,0,7.31659e-9,0.24233,0.970194,0,-5.95898,17.4392,-19.223,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0036f03b-3a64-4a5c-bae7-df4dc58eb733','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0036f03b-3a64-4a5c-bae7-df4dc58eb733.ply','PLY','PATIENT_31590453-d088-4fec-8a78-3f7cffc3f3bc_ACT_f97a8f4e-31ca-4629-af01-578fbf3e7e49_SESS_9a2bd988-7a13-49ec-a900-83b0011cafa2_BOSC_93ed771d-48a0-4d1e-82b4-ff5e666b769f_PLY_','2021-12-07 08:38:04','2019-07-17 09:51:00','0036f03b-3a64-4a5c-bae7-df4dc58eb733.ply','2021-12-07 09:38:04','SYNCED','0036f03b-3a64-4a5c-bae7-df4dc58eb733',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 85.1.1.1\",\"modelMatrix\":\"-0.991168,-0.131404,0.0178513,0,0.132611,-0.982147,0.133425,0,-3.69299e-10,0.134614,0.990898,0,-16.3221,17.8337,-30.4683,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'00460d20-8eb7-428c-a40a-98964f04a2e4','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/00460d20-8eb7-428c-a40a-98964f04a2e4.ply','PLY','PATIENT_55452abe-c899-4508-a6ad-a6862da81096_ACT_10244838-8d43-4b45-843e-1b1867b80fe9_SESS_a27242e6-79e3-49b8-9935-388a52c32306_TOSC_01c314a1-8c78-4274-8e37-28f8743f052f_PLY_','2020-12-08 10:47:03','2020-06-17 09:22:55','00460d20-8eb7-428c-a40a-98964f04a2e4.ply','2020-12-08 11:47:03','SYNCED','7ce02404-d34e-4a70-a1bd-2a27a1511971',1,NULL,'','','{\"displayTitle\":\"Maxillaire 32.1.1.1.4\",\"modelMatrix\":\"0.687928,-0.691083,0.221718,0,0.725779,0.655042,-0.210155,0,8.17336e-9,0.305489,0.952196,0,2.20199,-35.8443,-19.104,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0072875a-4e1e-4db7-b8c8-2f820d8b2ba7','','PLY','PATIENT_55452abe-c899-4508-a6ad-a6862da81096_ACT_10244838-8d43-4b45-843e-1b1867b80fe9_SESS_a27242e6-79e3-49b8-9935-388a52c32306_TOSC_4f13b604-10d9-4f30-b6b6-1270427ec1ab_PLY_','2020-12-08 10:47:03','2020-06-17 09:13:25','','2020-12-08 11:47:03','SYNCED','0072875a-4e1e-4db7-b8c8-2f820d8b2ba7',0,NULL,'','','{\"displayTitle\":\"Maxillaire 32.1.1.1.2\",\"modelMatrix\":\"0.461522,-0.839354,0.287198,0,0.887129,0.436668,-0.149413,0,-3.26597e-9,0.323739,0.946146,0,-6.86067,-39.0227,-19.0746,1\",\"title\":\"Maxillaire PLY\"}'),(2,'008765bb-af75-4240-ad7b-4d05be3367fe','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/008765bb-af75-4240-ad7b-4d05be3367fe.png','SNAPS','PATIENT_8f2a30ae-f5f0-42c4-9e6c-369d6d815a83_ACT_d8442e32-491d-4b5e-88dd-348895bccb5f_SESS_6134d13f-57ab-4858-bdd8-c5d63443974b_TOSC_652ab7ba-3e4d-4273-975b-6a93c47a9ab3_SNAPS_','2021-08-05 07:30:31','2019-12-02 14:04:18','008765bb-af75-4240-ad7b-4d05be3367fe.png','2021-08-05 09:30:31','SYNCED','008765bb-af75-4240-ad7b-4d05be3367fe',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 222.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'008dd458-fcea-4159-bc56-f9c209d6d2fc','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/008dd458-fcea-4159-bc56-f9c209d6d2fc.png','SNAPS','PATIENT_37924e66-6fca-42d1-866c-8897f314ef35_ACT_b97bc99b-fc77-46b8-82b7-151aef0aec54_SESS_f2ff3c9a-d754-4dd6-9785-85c513b9862b_FRSC_a7270607-d7cb-4657-bf0e-3f62029d18f8_SNAPS_','2021-12-07 08:38:04','2019-09-05 11:48:28','008dd458-fcea-4159-bc56-f9c209d6d2fc.png','2021-12-07 09:38:04','SYNCED','008dd458-fcea-4159-bc56-f9c209d6d2fc',0,NULL,'','','{\"displayTitle\":\"MORDU_ANTERIEUR 145.1.1.1\",\"title\":\"MORDU_ANTERIEUR SNAPSHOT\"}'),(2,'00a86396-528d-4cb3-b45d-f04917e29e89','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/00a86396-528d-4cb3-b45d-f04917e29e89.ply','PLY','PATIENT_aa33ba4f-57d4-473c-99f1-9ce301adcba9_ACT_950b6d17-2c4c-4052-969e-e70f65959620_SESS_7f9de4d9-f433-4a03-a9d6-dc607602722c_TOSC_f4fe35a7-d9e5-4661-a2b8-e2ed0374685b_PLY_','2021-01-06 11:01:42','2019-12-13 16:13:35','00a86396-528d-4cb3-b45d-f04917e29e89.ply','2021-01-06 12:01:42','SYNCED','00a86396-528d-4cb3-b45d-f04917e29e89',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 232.28.1.1\",\"modelMatrix\":\"0.599587,-0.754989,0.265496,0,0.80031,0.565632,-0.198908,0,-4.76656e-9,0.331742,0.94337,0,1.80296,-36.2041,-18.9692,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'00be63fe-c4dc-4b74-85d3-32c4ef71fbcf','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/00be63fe-c4dc-4b74-85d3-32c4ef71fbcf.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_7e31dc23-e958-4dce-a295-bc79e0259c7b_SNAPS_','2020-12-16 11:05:18','2020-01-24 14:15:19','00be63fe-c4dc-4b74-85d3-32c4ef71fbcf.png','2020-12-16 12:05:18','SYNCED','00be63fe-c4dc-4b74-85d3-32c4ef71fbcf',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.16\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'00cc5701-a837-4eed-b15f-41cdca298f6c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/00cc5701-a837-4eed-b15f-41cdca298f6c.stl','STL','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_BOSC_3c967e5f-226a-49e0-8aaa-a64bdd6bd888_STL_','2021-12-07 08:38:04','2019-11-14 11:37:33','00cc5701-a837-4eed-b15f-41cdca298f6c.stl','2021-12-07 09:38:04','SYNCED','00cc5701-a837-4eed-b15f-41cdca298f6c',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 202.1.1.1\",\"modelMatrix\":\"0.625309,0.779918,-0.0267683,0,-0.780377,0.624941,-0.0214492,0,8.88769e-10,0.0343017,0.999411,0,18.605,4.26683,-30.1581,1\",\"title\":\"MANDIBULE STL\"}'),(2,'00ce9540-d255-4a34-8b13-3c22e692383f','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/00ce9540-d255-4a34-8b13-3c22e692383f.png','SNAPS','PATIENT_72f539f4-2d06-47fa-b0b8-1291879a4818_ACT_d55baca2-6f09-4446-a148-dcdcfcaf57d8_SESS_5efdc987-8bdd-454f-b282-82efcf807bae_TOSC_a3a8b1cb-3fe8-4a12-ae47-0a86ec64a47d_SNAPS_','2021-08-05 07:30:31','2019-11-26 11:23:27','00ce9540-d255-4a34-8b13-3c22e692383f.png','2021-08-05 09:30:31','SYNCED','00ce9540-d255-4a34-8b13-3c22e692383f',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 86.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'00db8693-de3e-4b54-ab3e-ef1f8ccbaf90','','SNAPS','PATIENT_c99d352c-a346-4446-b7d9-4cacf017b67a_ACT_2b22a50e-19be-4908-85ec-2b3c28f8a0a3_SESS_98d25a16-10f9-498a-b3ce-02ed35bb57db_BOSC_f8c7ea3d-e8d3-4562-8cc9-7f56875943af_SNAPS_','2022-03-04 13:40:19','2019-07-09 13:26:08','','2022-03-04 14:40:19','SYNCED','00db8693-de3e-4b54-ab3e-ef1f8ccbaf90',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 12.2.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'00e72ba1-e3c3-4148-834e-d313cbe23f4f','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/00e72ba1-e3c3-4148-834e-d313cbe23f4f.ply','PLY','PATIENT_67c10a45-b4ec-42ba-ae2c-900a195adb87_ACT_86b9837f-894c-450e-be34-50dce2fbdc92_SESS_11baa7ef-ca17-442b-a5da-1d859ce1c951_BOSC_cda8c336-ec40-4e26-8336-664a2f417b06_PLY_','2021-12-07 08:38:05','2019-10-14 11:15:29','00e72ba1-e3c3-4148-834e-d313cbe23f4f.ply','2021-12-07 09:38:05','SYNCED','00e72ba1-e3c3-4148-834e-d313cbe23f4f',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.19.1.1\",\"modelMatrix\":\"-0.888695,0.432995,-0.150785,0,-0.458498,-0.839263,0.292262,0,-7.26766e-9,0.328866,0.944377,0,-7.01934,24.555,-16.6179,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0106f27b-76ec-4cc3-8c16-bf68325c6b9a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0106f27b-76ec-4cc3-8c16-bf68325c6b9a.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_4d5f9849-771f-4905-b4af-9f54867d3981_SESS_634356c8-f0f1-4841-b539-8f2ec59be200_BOSC_7cba2d58-2100-46e7-99be-c0c289fca438_PLY_','2020-12-16 10:51:02','2020-05-27 13:42:11','0106f27b-76ec-4cc3-8c16-bf68325c6b9a.ply','2020-12-16 11:51:02','SYNCED','0106f27b-76ec-4cc3-8c16-bf68325c6b9a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 216.1.14.1.1\",\"modelMatrix\":\"-0.862183,0.505,-0.0402044,0,-0.506597,-0.859463,0.0684243,0,1.4102e-9,0.0793617,0.996846,0,-7.23584,17.3611,-20.1938,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'01419ad5-a3bb-11e9-a33b-226cec7cb58a','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01419ad5-a3bb-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_79406c13-00e4-4a57-b938-5ac4cd1a9f2f_ACT_dbfeadf7-7793-42fb-be76-63e1515647d5_SESS_e53f2bc1-2f26-4656-aae6-7e1b2bbb1f50_TOSC_24085d39-bee0-4389-b5b7-8eea2c1764e2_PLY_','2022-03-04 13:40:19','2019-07-11 12:41:28','01419ad5-a3bb-11e9-a33b-226cec7cb58a.ply','2022-03-04 14:40:19','SYNCED','01419ad5-a3bb-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 40.1.1.1\",\"modelMatrix\":\"0.852576,-0.486267,0.191461,0,0.522603,0.793299,-0.312351,0,-1.89462e-9,0.366361,0.930473,0,5.3154,-32.6559,-18.1157,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'01422984-a3bb-11e9-a33b-226cec7cb58a','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01422984-a3bb-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_79406c13-00e4-4a57-b938-5ac4cd1a9f2f_ACT_dbfeadf7-7793-42fb-be76-63e1515647d5_SESS_e53f2bc1-2f26-4656-aae6-7e1b2bbb1f50_TOSC_24085d39-bee0-4389-b5b7-8eea2c1764e2_STL_','2022-03-04 13:40:19','2019-07-11 12:41:28','01422984-a3bb-11e9-a33b-226cec7cb58a.stl','2022-03-04 14:40:19','SYNCED','01422984-a3bb-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 40.1.1.1\",\"modelMatrix\":\"0.852576,-0.486267,0.191461,0,0.522603,0.793299,-0.312351,0,-1.89462e-9,0.366361,0.930473,0,5.3154,-32.6559,-18.1157,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'014284fe-1b1b-4fbf-82ac-d4ec75315ef9','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/014284fe-1b1b-4fbf-82ac-d4ec75315ef9.ply','PLY','PATIENT_924bf1a2-20af-4047-90c0-8d8b8a5fceb6_ACT_d32cbe7d-f29f-48b8-8656-3065d72e68bb_SESS_f6828a70-e523-4c66-97ef-ce1749bd1c5a_TOSC_e2bae541-1651-4b4d-8f92-c46b87c5a5e2_PLY_','2021-01-06 11:01:43','2019-12-12 14:49:32','014284fe-1b1b-4fbf-82ac-d4ec75315ef9.ply','2021-01-06 12:01:43','SYNCED','014284fe-1b1b-4fbf-82ac-d4ec75315ef9',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 232.15.1.1\",\"modelMatrix\":\"0.430033,-0.826966,0.362213,0,0.902813,0.393905,-0.172532,0,-7.69649e-9,0.401205,0.915988,0,3.46065,-33.3907,-24.753,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0142b109-a3bb-11e9-a33b-226cec7cb58a','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0142b109-a3bb-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_79406c13-00e4-4a57-b938-5ac4cd1a9f2f_ACT_dbfeadf7-7793-42fb-be76-63e1515647d5_SESS_e53f2bc1-2f26-4656-aae6-7e1b2bbb1f50_BOSC_0a7999fe-aef8-4205-b3b5-74d2746c93bf_STL_','2022-03-04 13:40:20','2019-07-11 12:46:11','0142b109-a3bb-11e9-a33b-226cec7cb58a.stl','2022-03-04 14:40:20','SYNCED','0142b109-a3bb-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 40.1.1.1\",\"modelMatrix\":\"-0.998063,-0.0615553,0.00903301,0,0.0622145,-0.987487,0.14491,0,-1.34323e-10,0.145191,0.989404,0,-18.6543,17.3715,-22.9564,1\",\"title\":\"MANDIBULE STL\"}'),(2,'01436f08-a3bb-11e9-a33b-226cec7cb58a','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01436f08-a3bb-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_79406c13-00e4-4a57-b938-5ac4cd1a9f2f_ACT_dbfeadf7-7793-42fb-be76-63e1515647d5_SESS_e53f2bc1-2f26-4656-aae6-7e1b2bbb1f50_BOSC_0a7999fe-aef8-4205-b3b5-74d2746c93bf_PLY_','2022-03-04 13:40:20','2019-07-11 12:46:11','01436f08-a3bb-11e9-a33b-226cec7cb58a.ply','2022-03-04 14:40:20','SYNCED','01436f08-a3bb-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 40.1.1.1\",\"modelMatrix\":\"-0.998063,-0.0615553,0.00903301,0,0.0622145,-0.987487,0.14491,0,-1.34323e-10,0.145191,0.989404,0,-18.6543,17.3715,-22.9564,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0143eb07-a3bb-11e9-a33b-226cec7cb58a','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0143eb07-a3bb-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_79406c13-00e4-4a57-b938-5ac4cd1a9f2f_ACT_dbfeadf7-7793-42fb-be76-63e1515647d5_SESS_e53f2bc1-2f26-4656-aae6-7e1b2bbb1f50_TOSC_24085d39-bee0-4389-b5b7-8eea2c1764e2_SNAPS_','2022-03-04 13:40:20','2019-07-11 12:41:28','0143eb07-a3bb-11e9-a33b-226cec7cb58a.png','2022-03-04 14:40:20','SYNCED','0143eb07-a3bb-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 40.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'01446165-a3bb-11e9-a33b-226cec7cb58a','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01446165-a3bb-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_79406c13-00e4-4a57-b938-5ac4cd1a9f2f_ACT_dbfeadf7-7793-42fb-be76-63e1515647d5_SESS_e53f2bc1-2f26-4656-aae6-7e1b2bbb1f50_BOSC_0a7999fe-aef8-4205-b3b5-74d2746c93bf_SNAPS_','2022-03-04 13:40:20','2019-07-11 12:46:11','01446165-a3bb-11e9-a33b-226cec7cb58a.png','2022-03-04 14:40:20','SYNCED','01446165-a3bb-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 40.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'01562426-a85d-4668-a64e-b9e33ca1d42b','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01562426-a85d-4668-a64e-b9e33ca1d42b.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_9ac41709-266d-46c7-a5d6-c38801e11232_SESS_d5fff860-73d3-4cdc-9e34-2bd0e66bbd7c_BOSC_eceb447b-bf3e-4aa0-83cb-5e3c1ace204f_PLY_','2020-12-08 10:47:08','2020-06-05 10:13:07','01562426-a85d-4668-a64e-b9e33ca1d42b.ply','2020-12-08 11:47:08','SYNCED','01562426-a85d-4668-a64e-b9e33ca1d42b',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.20.1.1\",\"modelMatrix\":\"-0.981676,-0.18988,0.0160604,0,0.190558,-0.978183,0.0827362,0,-8.06272e-10,0.0842806,0.996442,0,-12.1911,10.9783,-21.3539,1\",\"title\":\"Mandibule PLY\"}'),(2,'016077a5-a897-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/016077a5-a897-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_3397764f-98bb-416e-97fc-bdb90c785356_ACT_de792429-7cc9-4684-8574-cc42108e6cdc_SESS_72e329ac-390b-427a-9384-d6296c240328_BOSC_4a3bd60c-26c1-4c98-9437-2a88544e3b0c_PLY_','2021-12-07 08:38:05','2019-07-17 17:36:34','016077a5-a897-11e9-a33b-226cec7cb58a.ply','2021-12-07 09:38:05','SYNCED','016077a5-a897-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 96.1.1.1\",\"modelMatrix\":\"-0.960118,-0.275272,0.0489776,0,0.279596,-0.945272,0.168187,0,1.14725e-9,0.175173,0.984538,0,-23.2468,15.9017,-28.9485,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'016115d5-a897-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/016115d5-a897-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_3397764f-98bb-416e-97fc-bdb90c785356_ACT_de792429-7cc9-4684-8574-cc42108e6cdc_SESS_72e329ac-390b-427a-9384-d6296c240328_BOSC_4a3bd60c-26c1-4c98-9437-2a88544e3b0c_SNAPS_','2021-12-07 08:38:06','2019-07-17 17:36:34','016115d5-a897-11e9-a33b-226cec7cb58a.png','2021-12-07 09:38:06','SYNCED','016115d5-a897-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 96.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'01618b44-c1fc-4501-b531-f1f113613211','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01618b44-c1fc-4501-b531-f1f113613211.png','SNAPS','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_2a2b96a4-a0e0-43e8-880c-4a576a26100c_SESS_28b7bd97-0dfa-43d9-b4aa-09587119b68a_BOSC_3f08005c-4379-4946-87cd-15f582d0ca08_SNAPS_','2020-12-23 09:07:04','2019-12-20 15:00:36','01618b44-c1fc-4501-b531-f1f113613211.png','2020-12-23 10:07:04','SYNCED','01618b44-c1fc-4501-b531-f1f113613211',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0161b62b-a897-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0161b62b-a897-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_3397764f-98bb-416e-97fc-bdb90c785356_ACT_de792429-7cc9-4684-8574-cc42108e6cdc_SESS_72e329ac-390b-427a-9384-d6296c240328_TOSC_67399eca-d324-41ca-93d7-653a6817b1e3_SNAPS_','2021-12-07 08:38:08','2019-07-17 17:30:12','0161b62b-a897-11e9-a33b-226cec7cb58a.png','2021-12-07 09:38:08','SYNCED','0161b62b-a897-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 96.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'01624971-a897-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01624971-a897-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_3397764f-98bb-416e-97fc-bdb90c785356_ACT_de792429-7cc9-4684-8574-cc42108e6cdc_SESS_72e329ac-390b-427a-9384-d6296c240328_TOSC_67399eca-d324-41ca-93d7-653a6817b1e3_PLY_','2021-12-07 08:38:09','2019-07-17 17:30:12','01624971-a897-11e9-a33b-226cec7cb58a.ply','2021-12-07 09:38:09','SYNCED','01624971-a897-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 96.1.1.1\",\"modelMatrix\":\"0.508608,-0.834618,0.211498,0,0.860998,0.493024,-0.124936,0,-1.21187e-9,0.245643,0.96936,0,0.947789,-33.9751,-13.4366,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0162ee1a-a897-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0162ee1a-a897-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_3397764f-98bb-416e-97fc-bdb90c785356_ACT_de792429-7cc9-4684-8574-cc42108e6cdc_SESS_72e329ac-390b-427a-9384-d6296c240328_TOSC_67399eca-d324-41ca-93d7-653a6817b1e3_STL_','2021-12-07 08:38:09','2019-07-17 17:30:12','0162ee1a-a897-11e9-a33b-226cec7cb58a.stl','2021-12-07 09:38:09','SYNCED','0162ee1a-a897-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 96.1.1.1\",\"modelMatrix\":\"0.508608,-0.834618,0.211498,0,0.860998,0.493024,-0.124936,0,-1.21187e-9,0.245643,0.96936,0,0.947789,-33.9751,-13.4366,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'016375bb-a897-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/016375bb-a897-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_3397764f-98bb-416e-97fc-bdb90c785356_ACT_de792429-7cc9-4684-8574-cc42108e6cdc_SESS_72e329ac-390b-427a-9384-d6296c240328_BOSC_4a3bd60c-26c1-4c98-9437-2a88544e3b0c_STL_','2021-12-07 08:38:09','2019-07-17 17:36:34','016375bb-a897-11e9-a33b-226cec7cb58a.stl','2021-12-07 09:38:09','SYNCED','016375bb-a897-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 96.1.1.1\",\"modelMatrix\":\"-0.960118,-0.275272,0.0489776,0,0.279596,-0.945272,0.168187,0,1.14725e-9,0.175173,0.984538,0,-23.2468,15.9017,-28.9485,1\",\"title\":\"MANDIBULE STL\"}'),(2,'0185abba-25af-4bd2-8937-b1b0a965ff92','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0185abba-25af-4bd2-8937-b1b0a965ff92.stl','STL','PATIENT_fb6c4a59-c72c-46ad-a554-ed6056e6aa8f_ACT_a993018f-4e2c-4c41-9e18-5b2cd8a5a5ad_SESS_5f263ed3-a107-4539-bca7-bbee330b804d_TOSC_342bc4aa-a803-43f4-abaf-5ad83033bd39_STL_','2021-12-07 08:38:09','2019-07-24 15:05:25','0185abba-25af-4bd2-8937-b1b0a965ff92.stl','2021-12-07 09:38:09','SYNCED','0185abba-25af-4bd2-8937-b1b0a965ff92',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 113.1.1.1\",\"modelMatrix\":\"0.357983,-0.903725,0.234795,0,0.933728,0.34648,-0.0900185,0,-4.06751e-10,0.25146,0.967868,0,-9.76076,-32.0819,-16.3726,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'01b22b0f-ea8e-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01b22b0f-ea8e-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_3e53fe02-afc4-4a4e-baa1-8e748cae6c31_ACT_7c221ea4-4cae-4db9-9833-48b1955c6d3e_SESS_759f7cb5-cf25-43d3-8a49-15e06ae98c56_BOSC_54df7545-92b5-4c41-b7f3-fb58a9c6a435_SNAPS_','2021-12-07 08:38:09','2019-10-09 14:11:34','01b22b0f-ea8e-11e9-947d-226cec7cb58a.png','2021-12-07 09:38:09','SYNCED','01b22b0f-ea8e-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 182.2.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'01b39498-ea8e-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01b39498-ea8e-11e9-947d-226cec7cb58a.stl','STL','PATIENT_3e53fe02-afc4-4a4e-baa1-8e748cae6c31_ACT_7c221ea4-4cae-4db9-9833-48b1955c6d3e_SESS_759f7cb5-cf25-43d3-8a49-15e06ae98c56_TOSC_5960393d-c5d2-4c4b-b829-7f09cf5858e1_STL_','2021-12-07 08:38:09','2019-10-09 14:07:14','01b39498-ea8e-11e9-947d-226cec7cb58a.stl','2021-12-07 09:38:09','SYNCED','01b39498-ea8e-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 182.2.1.1\",\"modelMatrix\":\"-0.161793,-0.932839,0.321923,0,0.986825,-0.152942,0.0527802,0,-3.54057e-10,0.326221,0.945294,0,-25.7894,-27.5189,-29.8912,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'01b4e4af-ea8e-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01b4e4af-ea8e-11e9-947d-226cec7cb58a.stl','STL','PATIENT_3e53fe02-afc4-4a4e-baa1-8e748cae6c31_ACT_7c221ea4-4cae-4db9-9833-48b1955c6d3e_SESS_759f7cb5-cf25-43d3-8a49-15e06ae98c56_BOSC_54df7545-92b5-4c41-b7f3-fb58a9c6a435_STL_','2021-12-07 08:38:09','2019-10-09 14:11:34','01b4e4af-ea8e-11e9-947d-226cec7cb58a.stl','2021-12-07 09:38:09','SYNCED','01b4e4af-ea8e-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 182.2.1.1\",\"modelMatrix\":\"-0.999066,-0.0420892,0.00980389,0,0.0432159,-0.973018,0.226646,0,-7.14046e-10,0.226858,0.973928,0,-16.0175,16.5323,-26.7006,1\",\"title\":\"MANDIBULE STL\"}'),(2,'01b6756f-ea8e-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01b6756f-ea8e-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_3e53fe02-afc4-4a4e-baa1-8e748cae6c31_ACT_7c221ea4-4cae-4db9-9833-48b1955c6d3e_SESS_759f7cb5-cf25-43d3-8a49-15e06ae98c56_TOSC_5960393d-c5d2-4c4b-b829-7f09cf5858e1_PLY_','2021-12-07 08:38:10','2019-10-09 14:07:14','01b6756f-ea8e-11e9-947d-226cec7cb58a.ply','2021-12-07 09:38:10','SYNCED','01b6756f-ea8e-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 182.2.1.1\",\"modelMatrix\":\"-0.161793,-0.932839,0.321923,0,0.986825,-0.152942,0.0527802,0,-3.54057e-10,0.326221,0.945294,0,-25.7894,-27.5189,-29.8912,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'01b7c19c-ea8e-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01b7c19c-ea8e-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_3e53fe02-afc4-4a4e-baa1-8e748cae6c31_ACT_7c221ea4-4cae-4db9-9833-48b1955c6d3e_SESS_759f7cb5-cf25-43d3-8a49-15e06ae98c56_TOSC_5960393d-c5d2-4c4b-b829-7f09cf5858e1_SNAPS_','2021-12-07 08:38:10','2019-10-09 14:07:14','01b7c19c-ea8e-11e9-947d-226cec7cb58a.png','2021-12-07 09:38:10','SYNCED','01b7c19c-ea8e-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 182.2.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'01b90682-ea8e-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01b90682-ea8e-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_3e53fe02-afc4-4a4e-baa1-8e748cae6c31_ACT_7c221ea4-4cae-4db9-9833-48b1955c6d3e_SESS_759f7cb5-cf25-43d3-8a49-15e06ae98c56_BOSC_54df7545-92b5-4c41-b7f3-fb58a9c6a435_PLY_','2021-12-07 08:38:10','2019-10-09 14:11:34','01b90682-ea8e-11e9-947d-226cec7cb58a.ply','2021-12-07 09:38:10','SYNCED','01b90682-ea8e-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 182.2.1.1\",\"modelMatrix\":\"-0.999066,-0.0420892,0.00980389,0,0.0432159,-0.973018,0.226646,0,-7.14046e-10,0.226858,0.973928,0,-16.0175,16.5323,-26.7006,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'01b9dabc-6dcd-4429-8e2f-0bb79ab0f845','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01b9dabc-6dcd-4429-8e2f-0bb79ab0f845.ply','PLY','PATIENT_0a66945b-1a85-401b-ad4b-8f12d5db9a24_ACT_cb5e78e7-76fe-4b53-a205-f9848e191205_SESS_b910b3e0-439a-469f-8215-5ef68253dded_BOSC_f55a2f95-8884-4a24-8c9d-7fc71862595c_PLY_','2022-03-04 13:40:20','2019-07-11 10:51:33','01b9dabc-6dcd-4429-8e2f-0bb79ab0f845.ply','2022-03-04 14:40:20','SYNCED','01b9dabc-6dcd-4429-8e2f-0bb79ab0f845',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 38.1.1.1\",\"modelMatrix\":\"-0.973864,0.219502,-0.0583813,0,-0.227133,-0.941144,0.250318,0,-1.74617e-9,0.257036,0.966402,0,-15.9619,18.2817,-25.4787,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'01bb05bc-112e-46de-8b80-20e0cacad764','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01bb05bc-112e-46de-8b80-20e0cacad764.png','SNAPS','PATIENT_183e1e44-c049-45b8-8e15-90b510c1c43f_ACT_739b3c65-5057-49d0-8174-dd85b45325e6_SESS_06e71475-7dc6-49b7-a980-0689aaae3a5d_TOSC_71ce3b04-6516-4d5a-bca5-570015244774_SNAPS_','2020-12-16 10:51:08','2020-03-12 14:47:11','01bb05bc-112e-46de-8b80-20e0cacad764.png','2020-12-16 11:51:08','SYNCED','01bb05bc-112e-46de-8b80-20e0cacad764',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'01cb46b7-f296-4599-83d9-dd4169f3f3dc','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01cb46b7-f296-4599-83d9-dd4169f3f3dc.ply','PLY','PATIENT_4ed0364e-d067-4452-8839-8e909c61b1ea_ACT_439d6b4b-8f66-4316-a9b9-00cd70637694_SESS_14bc0526-ec82-440b-a6a4-b544d274a55b_TOSC_c880d341-0837-4d73-9aaa-da9b4f978b1d_PLY_','2020-12-08 10:54:34','2020-06-08 10:18:25','01cb46b7-f296-4599-83d9-dd4169f3f3dc.ply','2020-12-08 11:54:34','SYNCED','01cb46b7-f296-4599-83d9-dd4169f3f3dc',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.29.1.1\",\"modelMatrix\":\"0.533222,-0.821323,0.202738,0,0.845976,0.517683,-0.127787,0,-4.71109e-9,0.23965,0.970859,0,-4.15096,-32.3971,-14.4051,1\",\"title\":\"Maxillaire PLY\"}'),(2,'01ef3f57-b136-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01ef3f57-b136-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_64c7fd99-6753-4e45-90f5-ecf7a34ff48c_ACT_2e528630-1806-4d7e-a255-1699c9fdcd28_SESS_aa55adeb-bb57-4e86-87e6-ea423db4eab5_TOSC_10d097be-4df9-4d3b-84bd-88416166ad49_PLY_','2020-12-08 10:54:35','2020-06-18 09:25:05','01ef3f57-b136-11ea-947d-226cec7cb58a.ply','2020-12-08 11:54:35','SYNCED','01ef3f57-b136-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.61.1.1\",\"modelMatrix\":\"0.422553,-0.886488,0.188647,0,0.906338,0.413299,-0.0879512,0,1.83295e-9,0.208142,0.978099,0,-4.19759,-35.1844,-19.8637,1\",\"title\":\"Maxillaire PLY\"}'),(2,'01f0ffcc-1f20-45f7-b2a2-4dcd2bdf614d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01f0ffcc-1f20-45f7-b2a2-4dcd2bdf614d.png','SNAPS','PATIENT_2c31ad8e-22ad-441e-9c15-c34ef23d4519_ACT_e319cb73-6f62-4156-8701-64f342c4711e_SESS_df356414-5249-4c0a-a80c-c8031597086a_TOSC_5ba2bba1-a95a-4d62-9570-f28eeb93be5a_SNAPS_','2020-12-23 09:07:07','2019-12-31 12:04:33','01f0ffcc-1f20-45f7-b2a2-4dcd2bdf614d.png','2020-12-23 10:07:07','SYNCED','01f0ffcc-1f20-45f7-b2a2-4dcd2bdf614d',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'01f17a83-b136-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01f17a83-b136-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_64c7fd99-6753-4e45-90f5-ecf7a34ff48c_ACT_2e528630-1806-4d7e-a255-1699c9fdcd28_SESS_aa55adeb-bb57-4e86-87e6-ea423db4eab5_TOSC_10d097be-4df9-4d3b-84bd-88416166ad49_SNAPS_','2020-12-08 10:54:36','2020-06-18 09:25:05','01f17a83-b136-11ea-947d-226cec7cb58a.png','2020-12-08 11:54:36','SYNCED','01f17a83-b136-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.61.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'01f372e2-b136-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01f372e2-b136-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_2e528630-1806-4d7e-a255-1699c9fdcd28_SESS_aa55adeb-bb57-4e86-87e6-ea423db4eab5_BOSC_cb6a7309-e36f-4913-b35d-db5c1f576027_SNAPS_','2020-12-08 10:54:36','2020-06-18 09:29:24','01f372e2-b136-11ea-947d-226cec7cb58a.png','2020-12-08 11:54:36','SYNCED','01f372e2-b136-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.61.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'01f52e07-b136-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01f52e07-b136-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_2e528630-1806-4d7e-a255-1699c9fdcd28_SESS_aa55adeb-bb57-4e86-87e6-ea423db4eab5_BOSC_cb6a7309-e36f-4913-b35d-db5c1f576027_PLY_','2020-12-08 10:54:37','2020-06-18 09:29:24','01f52e07-b136-11ea-947d-226cec7cb58a.ply','2020-12-08 11:54:37','SYNCED','01f52e07-b136-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.61.1.1\",\"modelMatrix\":\"-0.982259,0.180477,-0.0509406,0,-0.187528,-0.945325,0.266823,0,-1.06424e-9,0.271642,0.962398,0,-15.2483,14.687,-20.9958,1\",\"title\":\"Mandibule PLY\"}'),(2,'020e2dc9-06f7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/020e2dc9-06f7-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_db56cba1-23ff-48bf-b86e-4ceff749087f_TOSC_ee6a9a11-5f12-4108-99f0-f79ed91ada60_SNAPS_','2021-12-07 08:38:10','2019-11-14 14:35:28','020e2dc9-06f7-11ea-947d-226cec7cb58a.png','2021-12-07 09:38:10','SYNCED','020e2dc9-06f7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 202.1.1.2\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'020f9fcd-06f7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/020f9fcd-06f7-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_db56cba1-23ff-48bf-b86e-4ceff749087f_BOSC_61758c9e-f753-4e49-aa06-7f9b9fb5d0c0_PLY_','2021-12-07 08:38:10','2019-11-14 15:29:16','020f9fcd-06f7-11ea-947d-226cec7cb58a.ply','2021-12-07 09:38:10','SYNCED','020f9fcd-06f7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 202.1.1.2\",\"modelMatrix\":\"-0.784347,0.614172,-0.0871374,0,-0.620322,-0.77657,0.110178,0,-1.89916e-9,0.140471,0.990085,0,-4.05211,19.878,-15.8828,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'021029ce-f7b9-4309-8c1a-01232074867d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/021029ce-f7b9-4309-8c1a-01232074867d.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_cf7510f6-bfb5-4e90-af14-79e2643fc837_SNAPS_','2020-12-16 11:05:25','2020-01-24 13:50:45','021029ce-f7b9-4309-8c1a-01232074867d.png','2020-12-16 12:05:25','SYNCED','021029ce-f7b9-4309-8c1a-01232074867d',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.8\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'02111727-06f7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02111727-06f7-11ea-947d-226cec7cb58a.stl','STL','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_db56cba1-23ff-48bf-b86e-4ceff749087f_TOSC_ee6a9a11-5f12-4108-99f0-f79ed91ada60_STL_','2021-12-07 08:38:10','2019-11-14 14:35:28','02111727-06f7-11ea-947d-226cec7cb58a.stl','2021-12-07 09:38:10','SYNCED','02111727-06f7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 202.1.1.2\",\"modelMatrix\":\"0.387292,-0.880586,0.27308,0,0.921957,0.369913,-0.114715,0,-3.27977e-9,0.296196,0.955127,0,-3.7782,-36.0627,-16.3793,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'0211de51-8772-4990-92c7-1e6029238302','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0211de51-8772-4990-92c7-1e6029238302.png','SNAPS','PATIENT_1fe53bd5-165d-4f83-8b14-5ccfa106502b_ACT_160645fc-3820-4053-baf9-297adc7a3bd0_SESS_e51149df-9a1e-4ccd-b213-42584b7c91f8_TOSC_8c462e06-1f0c-43f2-a258-219811582fb3_SNAPS_','2021-01-06 11:01:48','2019-12-11 16:12:25','0211de51-8772-4990-92c7-1e6029238302.png','2021-01-06 12:01:48','SYNCED','0211de51-8772-4990-92c7-1e6029238302',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 232.3.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0212747b-06f7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0212747b-06f7-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_db56cba1-23ff-48bf-b86e-4ceff749087f_BOSC_61758c9e-f753-4e49-aa06-7f9b9fb5d0c0_SNAPS_','2021-12-07 08:38:11','2019-11-14 15:29:16','0212747b-06f7-11ea-947d-226cec7cb58a.png','2021-12-07 09:38:11','SYNCED','0212747b-06f7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 202.1.1.2\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0213b009-06f7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0213b009-06f7-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_db56cba1-23ff-48bf-b86e-4ceff749087f_TOSC_ee6a9a11-5f12-4108-99f0-f79ed91ada60_PLY_','2021-12-07 08:38:11','2019-11-14 14:35:28','0213b009-06f7-11ea-947d-226cec7cb58a.ply','2021-12-07 09:38:11','SYNCED','0213b009-06f7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 202.1.1.2\",\"modelMatrix\":\"0.387292,-0.880586,0.27308,0,0.921957,0.369913,-0.114715,0,-3.27977e-9,0.296196,0.955127,0,-3.7782,-36.0627,-16.3793,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0214e61b-06f7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0214e61b-06f7-11ea-947d-226cec7cb58a.stl','STL','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_db56cba1-23ff-48bf-b86e-4ceff749087f_BOSC_61758c9e-f753-4e49-aa06-7f9b9fb5d0c0_STL_','2021-12-07 08:38:11','2019-11-14 15:29:16','0214e61b-06f7-11ea-947d-226cec7cb58a.stl','2021-12-07 09:38:11','SYNCED','0214e61b-06f7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 202.1.1.2\",\"modelMatrix\":\"-0.784347,0.614172,-0.0871374,0,-0.620322,-0.77657,0.110178,0,-1.89916e-9,0.140471,0.990085,0,-4.05211,19.878,-15.8828,1\",\"title\":\"MANDIBULE STL\"}'),(2,'021cc598-3998-4d2c-a77f-cb3cca432a8e','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/021cc598-3998-4d2c-a77f-cb3cca432a8e.stl','STL','PATIENT_2aa6e500-959c-4ad7-b322-62edde25b391_ACT_b7bc042d-95d4-45b7-a66e-ac5645f21987_SESS_0a59fcbd-fe82-4c25-9569-c973303fa798_BOSC_980fc19a-c1d5-43e0-8886-b39817252ba5_STL_','2022-03-04 13:40:21','2019-07-09 17:23:46','021cc598-3998-4d2c-a77f-cb3cca432a8e.stl','2022-03-04 14:40:21','SYNCED','021cc598-3998-4d2c-a77f-cb3cca432a8e',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 14.2.1.1\",\"modelMatrix\":\"-0.983484,-0.176157,0.0415677,0,0.180995,-0.957196,0.225869,0,3.50663e-9,0.229662,0.97327,0,-27.5532,10.9078,-22.7908,1\",\"title\":\"MANDIBULE STL\"}'),(2,'0222741b-ac63-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0222741b-ac63-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_e35fbaa5-d7a0-42a5-b618-26a8a2103a86_ACT_f4db7c6b-fe9c-42e0-85b8-af618a6208c6_SESS_93bd4bb1-0e40-4467-8ba8-a836ea5e5b3d_BOSC_fe736191-fc66-465e-9b51-1a35c1a5534c_SNAPS_','2021-12-07 08:39:07','2019-07-22 13:36:37','0222741b-ac63-11e9-a33b-226cec7cb58a.png','2021-12-07 09:39:07','SYNCED','0222741b-ac63-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 107.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0223167e-ac63-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0223167e-ac63-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_e35fbaa5-d7a0-42a5-b618-26a8a2103a86_ACT_f4db7c6b-fe9c-42e0-85b8-af618a6208c6_SESS_93bd4bb1-0e40-4467-8ba8-a836ea5e5b3d_BOSC_fe736191-fc66-465e-9b51-1a35c1a5534c_STL_','2021-12-07 08:39:07','2019-07-22 13:36:37','0223167e-ac63-11e9-a33b-226cec7cb58a.stl','2021-12-07 09:39:07','SYNCED','0223167e-ac63-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 107.1.1.1\",\"modelMatrix\":\"-0.845958,0.532498,-0.0282894,0,-0.533249,-0.844767,0.0448789,0,-4.56777e-10,0.053051,0.998592,0,0.756341,22.1609,-20.24,1\",\"title\":\"MANDIBULE STL\"}'),(2,'0223d121-ac63-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0223d121-ac63-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_e35fbaa5-d7a0-42a5-b618-26a8a2103a86_ACT_f4db7c6b-fe9c-42e0-85b8-af618a6208c6_SESS_93bd4bb1-0e40-4467-8ba8-a836ea5e5b3d_BOSC_fe736191-fc66-465e-9b51-1a35c1a5534c_PLY_','2021-12-07 08:39:08','2019-07-22 13:36:37','0223d121-ac63-11e9-a33b-226cec7cb58a.ply','2021-12-07 09:39:08','SYNCED','0223d121-ac63-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 107.1.1.1\",\"modelMatrix\":\"-0.845958,0.532498,-0.0282894,0,-0.533249,-0.844767,0.0448789,0,-4.56777e-10,0.053051,0.998592,0,0.756341,22.1609,-20.24,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'02247312-ac63-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02247312-ac63-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_e35fbaa5-d7a0-42a5-b618-26a8a2103a86_ACT_f4db7c6b-fe9c-42e0-85b8-af618a6208c6_SESS_93bd4bb1-0e40-4467-8ba8-a836ea5e5b3d_TOSC_35f55190-dfb3-41ee-9998-ac885f266e67_PLY_','2021-12-07 08:39:08','2019-07-22 13:27:50','02247312-ac63-11e9-a33b-226cec7cb58a.ply','2021-12-07 09:39:08','SYNCED','02247312-ac63-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 107.1.1.1\",\"modelMatrix\":\"0.331814,-0.868099,0.369193,0,0.943345,0.305347,-0.129861,0,6.70804e-9,0.391366,0.920235,0,-9.20109,-35.7061,-22.4628,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'02250f1a-ac63-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02250f1a-ac63-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_e35fbaa5-d7a0-42a5-b618-26a8a2103a86_ACT_f4db7c6b-fe9c-42e0-85b8-af618a6208c6_SESS_93bd4bb1-0e40-4467-8ba8-a836ea5e5b3d_TOSC_35f55190-dfb3-41ee-9998-ac885f266e67_SNAPS_','2021-12-07 08:39:08','2019-07-22 13:27:50','02250f1a-ac63-11e9-a33b-226cec7cb58a.png','2021-12-07 09:39:08','SYNCED','02250f1a-ac63-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 107.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0225947c-ac63-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0225947c-ac63-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_e35fbaa5-d7a0-42a5-b618-26a8a2103a86_ACT_f4db7c6b-fe9c-42e0-85b8-af618a6208c6_SESS_93bd4bb1-0e40-4467-8ba8-a836ea5e5b3d_TOSC_35f55190-dfb3-41ee-9998-ac885f266e67_STL_','2021-12-07 08:39:08','2019-07-22 13:27:50','0225947c-ac63-11e9-a33b-226cec7cb58a.stl','2021-12-07 09:39:08','SYNCED','0225947c-ac63-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 107.1.1.1\",\"modelMatrix\":\"0.331814,-0.868099,0.369193,0,0.943345,0.305347,-0.129861,0,6.70804e-9,0.391366,0.920235,0,-9.20109,-35.7061,-22.4628,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'0234935d-4a2a-48cb-853d-d7cce95c0250','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0234935d-4a2a-48cb-853d-d7cce95c0250.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_87665c02-e5d9-49bf-8298-2fbddb730821_SESS_c5feb751-c308-430d-aca7-7ec47a49a052_BOSC_9cc6c0cf-c24e-47ca-ba31-2e6106e1a26a_PLY_','2020-12-16 10:51:12','2020-02-11 16:07:19','0234935d-4a2a-48cb-853d-d7cce95c0250.ply','2020-12-16 11:51:12','SYNCED','0234935d-4a2a-48cb-853d-d7cce95c0250',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"modelMatrix\":\"0.916965,0.381068,-0.118166,0,-0.398969,0.875823,-0.271584,0,3.07065e-9,0.296178,0.955133,0,17.4106,-13.4374,-18.4509,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0237c4d2-471c-4c3c-ba08-83c366dc0aa4','','STL','PATIENT_c99d352c-a346-4446-b7d9-4cacf017b67a_ACT_2b22a50e-19be-4908-85ec-2b3c28f8a0a3_SESS_98d25a16-10f9-498a-b3ce-02ed35bb57db_BOSC_f8c7ea3d-e8d3-4562-8cc9-7f56875943af_STL_','2022-03-04 13:40:21','2019-07-09 13:26:08','','2022-03-04 14:40:21','SYNCED','0237c4d2-471c-4c3c-ba08-83c366dc0aa4',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 12.2.1.1\",\"modelMatrix\":\"-0.137502,-0.989748,0.0386197,0,0.990501,-0.137398,0.00536123,0,8.09006e-11,0.03899,0.99924,0,-24.6771,-17.3281,-26.6846,1\",\"title\":\"MANDIBULE STL\"}'),(2,'023e789e-89c4-409d-8131-f3adb26a6a60','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/023e789e-89c4-409d-8131-f3adb26a6a60.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_a652bfa0-2f48-4a5c-baee-0b1742d0f575_SNAPS_','2020-12-16 11:05:29','2020-01-24 13:33:07','023e789e-89c4-409d-8131-f3adb26a6a60.png','2020-12-16 12:05:29','SYNCED','023e789e-89c4-409d-8131-f3adb26a6a60',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.2\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'02420166-cdcc-4867-920a-0f1f2b14d241','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02420166-cdcc-4867-920a-0f1f2b14d241.stl','STL','PATIENT_0c1246d6-d8e8-4416-8498-e34a2e9ddfd8_ACT_628664ea-6869-485b-9c25-5b14151d796d_SESS_fbdbf097-6fee-4478-995f-6221a0d4627a_BOSC_5f094bfc-a13f-4914-8a09-41fcf18a809b_STL_','2021-01-06 11:01:52','2019-12-13 15:04:06','02420166-cdcc-4867-920a-0f1f2b14d241.stl','2021-01-06 12:01:52','SYNCED','02420166-cdcc-4867-920a-0f1f2b14d241',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 232.17.1.1\",\"modelMatrix\":\"-0.993781,-0.1046,0.0381808,0,0.11135,-0.933534,0.340757,0,-1.46497e-9,0.342889,0.939376,0,-16.9627,10.4973,-25.7872,1\",\"title\":\"MANDIBULE STL\"}'),(2,'025c0a5f-f6a9-4196-996f-1a8240d030b2','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/025c0a5f-f6a9-4196-996f-1a8240d030b2.stl','STL','PATIENT_d1fbcf37-7232-4ed6-99e0-35ce505a6eed_ACT_1a9de72b-91ea-4ac2-a68d-1f48d60d3620_SESS_6cdfbecb-293c-4466-9415-108f9f941cde_TOSC_9c8388f2-53cf-4c6c-970a-22814a4166bd_STL_','2021-12-07 08:39:08','2019-09-10 09:52:45','025c0a5f-f6a9-4196-996f-1a8240d030b2.stl','2021-12-07 09:39:08','SYNCED','025c0a5f-f6a9-4196-996f-1a8240d030b2',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 149.1.1.1\",\"modelMatrix\":\"0.501696,-0.825919,0.257214,0,0.865044,0.479005,-0.149175,0,4.28886e-9,0.297342,0.954771,0,-2.56852,-36.3065,-16.0373,1\",\"title\":\"MAXILLAIRE STL\"}'),(524,'025fa07f-ec08-430c-a737-0c3027e7bc4a','','PLY','PATIENT_93ee4723-881c-4e19-a7de-b884552ebd9e_ACT_c2463b05-c212-4f06-9956-da9ba480f046_SESS_e9449863-8e18-4d2a-8708-1c143403f278_TOSC_5541d2a9-4d5b-4c7b-9822-4a389656bed0_PLY_','2022-03-04 11:18:48','2020-01-22 14:49:20','',NULL,'CREATED','542a8271-ad42-4de2-a715-2a7fc38ef67a',2,'2020-01-22 14:49:50','9f2592c4-76b3-4230-b316-5ec7307bcb92','9f2592c4-76b3-4230-b316-5ec7307bcb92','{\"displayTitle\":\"MAXILLAIRE 1.4.1.1.1\",\"modelMatrix\":\"-0.985431,0.161537,-0.0532179,0,-0.170077,-0.935947,0.308346,0,6.36616e-9,0.312904,0.949785,0,5.57493,-2.90054,-17.4985,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'02631cd3-fd15-43b3-b466-681e05d02809','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02631cd3-fd15-43b3-b466-681e05d02809.png','SNAPS','PATIENT_0880e4ab-6c5d-4b3d-9c49-8064a77d5d3f_ACT_7afe7778-e5f3-4e25-9a55-35d809c89b51_SESS_32c67196-65ac-4a5b-8953-2160d87c6f98_TOSC_5f3a674e-652e-4215-b499-e54093d56b85_SNAPS_','2021-01-06 11:01:53','2019-12-12 14:17:37','02631cd3-fd15-43b3-b466-681e05d02809.png','2021-01-06 12:01:53','SYNCED','02631cd3-fd15-43b3-b466-681e05d02809',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 232.13.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'02814746-b058-416a-b0f2-e858e7071c2d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02814746-b058-416a-b0f2-e858e7071c2d.ply','PLY','PATIENT_89c88118-827d-4c69-a01a-e71fa0de5341_ACT_2bcd6cff-7e33-484d-ae1f-14db83791ca8_SESS_cc616314-745e-4ae9-b1b7-4470a7570057_TOSC_b91f5e42-1586-44df-9091-bedc810494d0_PLY_','2020-12-23 09:07:12','2020-01-02 14:33:16','02814746-b058-416a-b0f2-e858e7071c2d.ply','2020-12-23 10:07:12','SYNCED','02814746-b058-416a-b0f2-e858e7071c2d',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"modelMatrix\":\"0.586986,-0.75518,0.291806,0,0.809597,0.547532,-0.211569,0,-9.01964e-9,0.360434,0.932785,0,2.01759,-30.6166,-20.1209,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'028e61ca-6ea1-40ad-93e8-ba63e8faa225','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/028e61ca-6ea1-40ad-93e8-ba63e8faa225.ply','PLY','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_BOSC_3d01b460-102f-4924-9743-d521a9112c5e_PLY_','2021-12-07 08:39:08','2019-11-15 14:02:46','028e61ca-6ea1-40ad-93e8-ba63e8faa225.ply','2021-12-07 09:39:08','SYNCED','028e61ca-6ea1-40ad-93e8-ba63e8faa225',0,NULL,'','','{\"displayTitle\":\"Mandibola 0\",\"modelMatrix\":\"-0.88619,0.453016,-0.0971796,0,-0.463322,-0.866478,0.185874,0,1.2747e-9,0.209745,0.977756,0,-6.68917,19.8563,-19.6101,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'02a0e260-e5bf-46ce-b9a4-88f5573e0717','','STL','PATIENT_28755122-fae1-4f95-b068-985d91181935_ACT_666c9397-f546-4de3-9c7b-9ecd62b9600e_SESS_d13984ab-a578-49fa-a6e0-ea9b2ecd3e86_TOSC_ec40cee1-48ab-4ec1-8dd8-c1f3dfddba2e_STL_','2021-12-07 08:39:08','2019-09-19 13:53:42','','2021-12-07 09:39:08','SYNCED','02a0e260-e5bf-46ce-b9a4-88f5573e0717',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 156.1.1.1\",\"modelMatrix\":\"0.440016,-0.817257,0.372126,0,0.89799,0.400456,-0.182342,0,1.76863e-9,0.414399,0.910095,0,-12.4219,-35.018,-18.1277,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'02a6047c-0921-420d-9edb-36b8201b25f2','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02a6047c-0921-420d-9edb-36b8201b25f2.ply','PLY','PATIENT_2c31ad8e-22ad-441e-9c15-c34ef23d4519_ACT_e319cb73-6f62-4156-8701-64f342c4711e_SESS_df356414-5249-4c0a-a80c-c8031597086a_TOSC_5ba2bba1-a95a-4d62-9570-f28eeb93be5a_PLY_','2020-12-23 09:07:13','2019-12-31 12:04:33','02a6047c-0921-420d-9edb-36b8201b25f2.ply','2020-12-23 10:07:13','SYNCED','02a6047c-0921-420d-9edb-36b8201b25f2',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"modelMatrix\":\"0.39383,-0.903426,0.169465,0,0.919183,0.387079,-0.0726083,0,6.05217e-9,0.184364,0.982858,0,-5.61266,-37.8332,-12.0176,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'02a77634-6cdc-4800-8694-0f262e960210','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02a77634-6cdc-4800-8694-0f262e960210.ply','PLY','PATIENT_f3e2711a-4a50-43c0-81ed-79aff7c7e3d9_ACT_249106b8-8e78-48ce-bb17-76612bb11c46_SESS_b11270a1-ab24-43c5-9863-edf1a7287b62_BOSC_9f85bdda-ea29-4d91-9258-6cee6b592767_PLY_','2021-08-05 07:30:36','2019-11-27 16:29:12','02a77634-6cdc-4800-8694-0f262e960210.ply','2021-08-05 09:30:36','SYNCED','02a77634-6cdc-4800-8694-0f262e960210',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 215.1.1.1\",\"modelMatrix\":\"-0.968845,0.241292,-0.0558279,0,-0.247667,-0.94391,0.218393,0,1.7506e-9,0.225415,0.974263,0,-9.94713,14.5908,-20.83,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'02b68124-ed2f-4697-83af-d7e4c87702cc','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02b68124-ed2f-4697-83af-d7e4c87702cc.stl','STL','PATIENT_1969ff5c-b071-4e17-bd50-2d86bc0b2bd0_ACT_f7bcfec5-5f8f-4f3d-967d-8810b57e2806_SESS_fa8a0221-3753-40a2-94ff-8934c2312429_BOSC_4c98422a-5015-4d09-be04-64925d568756_STL_','2021-12-07 08:39:08','2019-07-15 16:01:39','02b68124-ed2f-4697-83af-d7e4c87702cc.stl','2021-12-07 09:39:08','SYNCED','02b68124-ed2f-4697-83af-d7e4c87702cc',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 67.1.1.1\",\"modelMatrix\":\"-0.990578,0.129356,-0.0449653,0,-0.136948,-0.935661,0.325245,0,-4.06082e-9,0.328339,0.94456,0,-17.8969,15.7399,-24.9614,1\",\"title\":\"MANDIBULE STL\"}'),(2,'02c33ed2-443f-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02c33ed2-443f-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_b8905467-2e71-4779-bf51-94e66a47e3d5_ACT_6eae5d88-d0ca-4468-9daa-5a0f413d86b9_SESS_b15b868d-7cb1-47f7-ab0a-8d9fec9d4f75_TOSC_d0105e2f-8fc5-4727-a781-64e95f4045a1_PLY_','2020-12-16 10:51:15','2020-01-31 16:30:16','02c33ed2-443f-11ea-947d-226cec7cb58a.ply','2020-12-16 11:51:15','SYNCED','02c33ed2-443f-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"modelMatrix\":\"0.829413,-0.505608,0.237562,0,0.558637,0.75068,-0.35271,0,1.29213e-8,0.425253,0.905074,0,8.20583,-34.0391,-14.6529,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'02c595e7-443f-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02c595e7-443f-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_6eae5d88-d0ca-4468-9daa-5a0f413d86b9_SESS_b15b868d-7cb1-47f7-ab0a-8d9fec9d4f75_BOSC_ff44a32e-4ba1-4ada-8859-b02299c5ae80_PLY_','2020-12-16 10:51:15','2020-01-31 16:33:11','02c595e7-443f-11ea-947d-226cec7cb58a.ply','2020-12-16 11:51:15','SYNCED','02c595e7-443f-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"modelMatrix\":\"0.963003,-0.267113,0.035706,0,0.269489,0.954513,-0.127593,0,-1.21015e-9,0.132495,0.991184,0,4.97835,-20.0727,-26.9542,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'02c917a6-443f-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02c917a6-443f-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_b8905467-2e71-4779-bf51-94e66a47e3d5_ACT_6eae5d88-d0ca-4468-9daa-5a0f413d86b9_SESS_b15b868d-7cb1-47f7-ab0a-8d9fec9d4f75_TOSC_d0105e2f-8fc5-4727-a781-64e95f4045a1_SNAPS_','2020-12-16 10:51:15','2020-01-31 16:30:16','02c917a6-443f-11ea-947d-226cec7cb58a.png','2020-12-16 11:51:15','SYNCED','02c917a6-443f-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'02ca89d7-443f-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02ca89d7-443f-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_6eae5d88-d0ca-4468-9daa-5a0f413d86b9_SESS_b15b868d-7cb1-47f7-ab0a-8d9fec9d4f75_BOSC_ff44a32e-4ba1-4ada-8859-b02299c5ae80_SNAPS_','2020-12-16 10:51:15','2020-01-31 16:33:11','02ca89d7-443f-11ea-947d-226cec7cb58a.png','2020-12-16 11:51:15','SYNCED','02ca89d7-443f-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'02e4316e-9c4b-4e94-95c4-04866620eed2','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02e4316e-9c4b-4e94-95c4-04866620eed2.stl','STL','PATIENT_3dd35559-3891-4145-925d-2ca9ff021c92_ACT_3f91c745-f4b2-4db3-bf4a-7af2f4b090ed_SESS_1cdccc16-cfc5-47a6-a81f-5e3c5e4d5dec_TOSC_51300324-40f1-43a2-8068-12999ba32625_STL_','2021-12-07 08:39:09','2019-07-11 16:22:06','02e4316e-9c4b-4e94-95c4-04866620eed2.stl','2021-12-07 09:39:09','SYNCED','02e4316e-9c4b-4e94-95c4-04866620eed2',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 44.1.1.1\",\"modelMatrix\":\"0.827496,-0.544818,0.135734,0,0.561472,0.802952,-0.200045,0,-7.66774e-10,0.241747,0.970339,0,8.0114,-34.6695,-20.3847,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'030b5a43-c395-415c-b2fb-bfd86dc0a1f1','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/030b5a43-c395-415c-b2fb-bfd86dc0a1f1.ply','PLY','PATIENT_ccc00cdd-6862-49a0-a8b9-ec6471536e71_ACT_cbf6bad3-e84b-4487-b5ca-34461e4c29ab_SESS_2b2d2a2f-1f54-4773-8355-e1542edf294d_TOSC_bca4e258-fa03-4fdd-9a4b-c2f464de3696_PLY_','2022-03-04 13:40:21','2019-07-10 10:42:29','030b5a43-c395-415c-b2fb-bfd86dc0a1f1.ply','2022-03-04 14:40:21','SYNCED','030b5a43-c395-415c-b2fb-bfd86dc0a1f1',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 21.1.1.1\",\"modelMatrix\":\"0.744984,0.597525,-0.296585,0,-0.667082,0.667304,-0.33122,0,-1.11805e-9,0.4446,0.895729,0,-2.59196,-39.1301,-12.3044,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'03374e91-b842-46f6-9177-76e731f02a2d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03374e91-b842-46f6-9177-76e731f02a2d.ply','PLY','PATIENT_53100b02-c94b-47bc-8b64-ebba6073de50_ACT_8464161e-f420-42dd-97a7-8d8a43e0d890_SESS_24b4b44e-82d8-423d-a1e9-3be90a46aad3_TOSC_f4706931-83dd-4c85-aba6-b8279066b046_PLY_','2020-12-08 17:24:58','2020-06-17 11:37:38','03374e91-b842-46f6-9177-76e731f02a2d.ply','2020-12-08 18:24:58','SYNCED','03374e91-b842-46f6-9177-76e731f02a2d',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.50.1.1\",\"modelMatrix\":\"0.386935,-0.884941,0.259152,0,0.922107,0.37134,-0.108746,0,-6.18261e-9,0.281044,0.959695,0,-8.83839,-30.6419,-16.7318,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0337f521-0177-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0337f521-0177-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_4196aec4-665a-43ec-823c-c46b273b499c_ACT_4fea5157-9778-4ede-818a-ed0fde944998_SESS_55cdee94-4e99-4007-9e55-e77ae266154e_TOSC_b44b6acf-5ee7-4d6e-8471-b71e5b40cd8a_SNAPS_','2021-12-07 08:39:10','2019-11-07 16:50:46','0337f521-0177-11ea-947d-226cec7cb58a.png','2021-12-07 09:39:10','SYNCED','0337f521-0177-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.27.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'03398035-0177-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03398035-0177-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_4196aec4-665a-43ec-823c-c46b273b499c_ACT_4fea5157-9778-4ede-818a-ed0fde944998_SESS_55cdee94-4e99-4007-9e55-e77ae266154e_BOSC_967d5eed-a778-4446-ab11-1947eaaee7fa_SNAPS_','2021-12-07 08:39:10','2019-11-07 16:55:09','03398035-0177-11ea-947d-226cec7cb58a.png','2021-12-07 09:39:10','SYNCED','03398035-0177-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.27.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'033afab2-0177-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/033afab2-0177-11ea-947d-226cec7cb58a.stl','STL','PATIENT_4196aec4-665a-43ec-823c-c46b273b499c_ACT_4fea5157-9778-4ede-818a-ed0fde944998_SESS_55cdee94-4e99-4007-9e55-e77ae266154e_TOSC_b44b6acf-5ee7-4d6e-8471-b71e5b40cd8a_STL_','2021-12-07 08:39:10','2019-11-07 16:50:46','033afab2-0177-11ea-947d-226cec7cb58a.stl','2021-12-07 09:39:10','SYNCED','033afab2-0177-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.27.1.1\",\"modelMatrix\":\"-0.197011,-0.964941,0.173423,0,0.980401,-0.193904,0.0348493,0,-2.98387e-9,0.17689,0.984231,0,-21.0383,-19.6249,-19.194,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'033c5308-0177-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/033c5308-0177-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_4196aec4-665a-43ec-823c-c46b273b499c_ACT_4fea5157-9778-4ede-818a-ed0fde944998_SESS_55cdee94-4e99-4007-9e55-e77ae266154e_BOSC_967d5eed-a778-4446-ab11-1947eaaee7fa_PLY_','2021-12-07 08:39:10','2019-11-07 16:55:09','033c5308-0177-11ea-947d-226cec7cb58a.ply','2021-12-07 09:39:10','SYNCED','033c5308-0177-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.27.1.1\",\"modelMatrix\":\"-0.8845,0.436467,-0.164789,0,-0.46654,-0.827487,0.312419,0,2.07177e-9,0.353215,0.935542,0,-1.91759,19.8062,-21.4267,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'033dac0e-0177-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/033dac0e-0177-11ea-947d-226cec7cb58a.stl','STL','PATIENT_4196aec4-665a-43ec-823c-c46b273b499c_ACT_4fea5157-9778-4ede-818a-ed0fde944998_SESS_55cdee94-4e99-4007-9e55-e77ae266154e_BOSC_967d5eed-a778-4446-ab11-1947eaaee7fa_STL_','2021-12-07 08:39:10','2019-11-07 16:55:09','033dac0e-0177-11ea-947d-226cec7cb58a.stl','2021-12-07 09:39:10','SYNCED','033dac0e-0177-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.27.1.1\",\"modelMatrix\":\"-0.8845,0.436467,-0.164789,0,-0.46654,-0.827487,0.312419,0,2.07177e-9,0.353215,0.935542,0,-1.91759,19.8062,-21.4267,1\",\"title\":\"MANDIBULE STL\"}'),(2,'033f0f1a-0177-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/033f0f1a-0177-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_4196aec4-665a-43ec-823c-c46b273b499c_ACT_4fea5157-9778-4ede-818a-ed0fde944998_SESS_55cdee94-4e99-4007-9e55-e77ae266154e_TOSC_b44b6acf-5ee7-4d6e-8471-b71e5b40cd8a_PLY_','2021-12-07 08:39:10','2019-11-07 16:50:46','033f0f1a-0177-11ea-947d-226cec7cb58a.ply','2021-12-07 09:39:10','SYNCED','033f0f1a-0177-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.27.1.1\",\"modelMatrix\":\"-0.197011,-0.964941,0.173423,0,0.980401,-0.193904,0.0348493,0,-2.98387e-9,0.17689,0.984231,0,-21.0383,-19.6249,-19.194,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0342dd04-1062-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0342dd04-1062-11ea-947d-226cec7cb58a.stl','STL','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_fd694b3f-abde-4e46-91f7-7c62bfdcafa4_SESS_73a3f5b9-e905-4911-a163-2022e1de3380_TOSC_7e853b2b-25e6-4eb0-8bb9-1268c49445de_STL_','2021-08-05 07:30:38','2019-11-26 16:32:17','0342dd04-1062-11ea-947d-226cec7cb58a.stl','2021-08-05 09:30:38','SYNCED','0342dd04-1062-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"modelMatrix\":\"0.706199,-0.660159,0.255876,0,0.708014,0.658468,-0.25522,0,9.24341e-9,0.3614,0.932411,0,5.93232,-33.6673,-18.6426,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'034466e3-1062-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/034466e3-1062-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_fd694b3f-abde-4e46-91f7-7c62bfdcafa4_SESS_73a3f5b9-e905-4911-a163-2022e1de3380_TOSC_7e853b2b-25e6-4eb0-8bb9-1268c49445de_SNAPS_','2021-08-05 07:30:38','2019-11-26 16:32:17','034466e3-1062-11ea-947d-226cec7cb58a.png','2021-08-05 09:30:38','SYNCED','034466e3-1062-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0344a3fe-955d-4624-8a2a-f6a3401ce240','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0344a3fe-955d-4624-8a2a-f6a3401ce240.png','SNAPS','PATIENT_96afd601-d8c2-4e20-abec-292b75f99b16_ACT_1b95d362-259d-45d0-b12b-f82c49c26c12_SESS_812c317a-661f-4f64-916c-40d448feeca0_BOSC_9f368c08-fead-4763-876d-df309790e365_SNAPS_','2021-08-05 07:30:38','2019-12-05 15:38:54','0344a3fe-955d-4624-8a2a-f6a3401ce240.png','2021-08-05 09:30:38','SYNCED','0344a3fe-955d-4624-8a2a-f6a3401ce240',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 224.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0345f68d-1062-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0345f68d-1062-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_fd694b3f-abde-4e46-91f7-7c62bfdcafa4_SESS_73a3f5b9-e905-4911-a163-2022e1de3380_TOSC_7e853b2b-25e6-4eb0-8bb9-1268c49445de_PLY_','2021-08-05 07:30:38','2019-11-26 16:32:17','0345f68d-1062-11ea-947d-226cec7cb58a.ply','2021-08-05 09:30:38','SYNCED','0345f68d-1062-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"modelMatrix\":\"0.706199,-0.660159,0.255876,0,0.708014,0.658468,-0.25522,0,9.24341e-9,0.3614,0.932411,0,5.93232,-33.6673,-18.6426,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'034d06b8-7ba9-40ff-b74d-5772ee58d2b2','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/034d06b8-7ba9-40ff-b74d-5772ee58d2b2.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_dcea2419-687c-4fd2-bdc4-648efc507ebd_SESS_30bc559f-4455-43a2-b911-8ba645b91742_BOSC_8d745730-da6f-4ae3-9bec-f6cde3d4482c_PLY_','2020-12-16 10:51:18','2020-02-25 10:09:33','034d06b8-7ba9-40ff-b74d-5772ee58d2b2.ply','2020-12-16 11:51:18','SYNCED','034d06b8-7ba9-40ff-b74d-5772ee58d2b2',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"modelMatrix\":\"-0.771816,0.62585,-0.112307,0,-0.635846,-0.759681,0.136323,0,4.26647e-10,0.176627,0.984278,0,4.95209,18.4492,-14.5417,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'034e033e-4c10-43c9-9af2-287ec2a0d3a3','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/034e033e-4c10-43c9-9af2-287ec2a0d3a3.ply','PLY','PATIENT_72f539f4-2d06-47fa-b0b8-1291879a4818_ACT_d55baca2-6f09-4446-a148-dcdcfcaf57d8_SESS_5efdc987-8bdd-454f-b282-82efcf807bae_TOSC_c46ccd65-b88a-4797-a341-a681e8b71e58_PLY_','2021-08-05 07:30:38','2019-11-26 11:09:34','034e033e-4c10-43c9-9af2-287ec2a0d3a3.ply','2021-08-05 09:30:38','SYNCED','034e033e-4c10-43c9-9af2-287ec2a0d3a3',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 86.1.1.1.1\",\"modelMatrix\":\"0.717624,-0.654422,0.238218,0,0.696431,0.674336,-0.245467,0,-5.45333e-9,0.342056,0.93968,0,5.31256,-35.5973,-17.3929,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'034fd9bb-6566-4930-b469-67314b071791','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/034fd9bb-6566-4930-b469-67314b071791.stl','STL','PATIENT_1da4d746-be7d-4b76-83ab-ea0f893a037f_ACT_675a182e-b3d8-4879-885d-947de50cff0a_SESS_781a5087-c565-4f1b-95e2-54358316e8e3_BOSC_3086b448-bff8-4477-a088-31bb38c3dd89_STL_','2021-01-06 11:01:56','2019-12-13 09:37:48','034fd9bb-6566-4930-b469-67314b071791.stl','2021-01-06 12:01:56','SYNCED','034fd9bb-6566-4930-b469-67314b071791',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 232.18.1.1\",\"modelMatrix\":\"-0.942506,0.316866,-0.106197,0,-0.334189,-0.893652,0.299505,0,7.67262e-10,0.317775,0.948166,0,-6.417,23.0731,-15.4771,1\",\"title\":\"MANDIBULE STL\"}'),(524,'035f0cb4-8d43-46c1-aa2a-c8d9ebd8957c','/var/.data/2020/9f2592c4-76b3-4230-b316-5ec7307bcb92/5e1c39c4-bfce-46b5-924b-131fc5789ca0/session_4dbe54be-76e7-4c55-8510-236002f4572f/occlusion_364dd289-5c0c-4304-b23f-06159567a094/scan_be2d5f9d-be2f-4321-9bf0-b5f3daf6cbdc/3_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_5e1c39c4-bfce-46b5-924b-131fc5789ca0_ACT_4dbe54be-76e7-4c55-8510-236002f4572f_SESS_364dd289-5c0c-4304-b23f-06159567a094_RISC_be2d5f9d-be2f-4321-9bf0-b5f3daf6cbdc_SNAPS_','2022-03-04 13:42:44','2020-01-22 14:20:25','3_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-03-04 14:42:44','SYNCED','035f0cb4-8d43-46c1-aa2a-c8d9ebd8957c',0,NULL,'9f2592c4-76b3-4230-b316-5ec7307bcb92','9f2592c4-76b3-4230-b316-5ec7307bcb92','{\"displayTitle\":\"Mordu posterieur droit 1.3.1.1.1\",\"title\":\"MORDU_POSTERIEUR_DROIT SNAPSHOT\"}'),(2,'038d74e5-ead7-4cb1-91d2-6e4d990fac1c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/038d74e5-ead7-4cb1-91d2-6e4d990fac1c.png','SNAPS','PATIENT_3fae9447-e15b-4704-9907-1bf5e90f95dc_ACT_f9754ae5-b96b-4910-900e-5b70d2c7b9be_SESS_54470e11-bfb2-4144-9c34-70a077f1fb4f_TOSC_ad4f4efe-fe4a-46bd-a3d3-c82d4719c821_SNAPS_','2020-12-16 11:05:36','2020-01-22 15:30:10','038d74e5-ead7-4cb1-91d2-6e4d990fac1c.png','2020-12-16 12:05:36','SYNCED','038d74e5-ead7-4cb1-91d2-6e4d990fac1c',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'03991044-160a-49b1-b013-2880aa408cb1','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03991044-160a-49b1-b013-2880aa408cb1.png','SNAPS','PATIENT_7999473e-e556-4557-832b-32238063b37a_ACT_f34901e5-54f1-492c-a4a2-44e130fbc20a_SESS_8648b8e9-7e51-4f6c-9088-9a7c72129004_TOSC_bfbd315e-e829-4a93-bd33-52d402fc8de3_SNAPS_','2020-12-16 11:05:36','2020-01-21 11:20:29','03991044-160a-49b1-b013-2880aa408cb1.png','2020-12-16 12:05:36','SYNCED','03991044-160a-49b1-b013-2880aa408cb1',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'03a3b3af-99bb-4dda-8987-8e72e798bd15','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03a3b3af-99bb-4dda-8987-8e72e798bd15.stl','STL','PATIENT_d4ea044b-3514-42f4-ae88-c9548bd72102_ACT_0a1e2259-cccc-4340-b89c-6e8977a2ad52_SESS_182b8b60-e273-40dd-805e-e07693857391_TOSC_83030167-26ca-4b08-8d8e-d25579056e48_STL_','2021-12-07 08:39:10','2019-09-03 11:21:50','03a3b3af-99bb-4dda-8987-8e72e798bd15.stl','2021-12-07 09:39:10','SYNCED','03a3b3af-99bb-4dda-8987-8e72e798bd15',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 141.1.1.1\",\"modelMatrix\":\"0.709399,-0.630954,0.314086,0,0.704807,0.635065,-0.316132,0,-1.15324e-8,0.445634,0.895215,0,5.20191,-38.0091,-16.2605,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'03bb76d0-5f38-41a5-a56d-592393136017','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03bb76d0-5f38-41a5-a56d-592393136017.stl','STL','PATIENT_67c10a45-b4ec-42ba-ae2c-900a195adb87_ACT_86b9837f-894c-450e-be34-50dce2fbdc92_SESS_11baa7ef-ca17-442b-a5da-1d859ce1c951_TOSC_ac047e44-8462-4977-a9f4-84b2517681ab_STL_','2021-12-07 08:39:11','2019-10-14 11:11:56','03bb76d0-5f38-41a5-a56d-592393136017.stl','2021-12-07 09:39:11','SYNCED','03bb76d0-5f38-41a5-a56d-592393136017',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.19.1.1\",\"modelMatrix\":\"0.534199,-0.8234,0.191423,0,0.845359,0.520323,-0.120964,0,9.34479e-10,0.22644,0.974025,0,-3.96586,-29.2976,-17.9656,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'03c94c70-77f5-4035-9fd6-b9c627d7d233','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03c94c70-77f5-4035-9fd6-b9c627d7d233.ply','PLY','PATIENT_d057767a-48b8-47b4-b560-db225cf00938_ACT_c3fa7e61-3ce9-4cee-851c-8ac67b865e76_SESS_c9e83e51-62fb-483a-af48-a6e75bc9093a_TOSC_30c24f2e-ae7b-48f0-a01d-39798dfca852_PLY_','2020-12-08 17:25:04','2020-06-05 09:43:01','03c94c70-77f5-4035-9fd6-b9c627d7d233.ply','2020-12-08 18:25:04','SYNCED','03c94c70-77f5-4035-9fd6-b9c627d7d233',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.19.1.1\",\"modelMatrix\":\"0.853389,-0.463184,0.239139,0,0.521274,0.758288,-0.391499,0,5.00323e-9,0.458759,0.888561,0,10.6874,-29.9189,-21.418,1\",\"title\":\"Maxillaire PLY\"}'),(2,'03d0117e-3130-4bbe-8bb3-336b2831f77a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03d0117e-3130-4bbe-8bb3-336b2831f77a.png','SNAPS','PATIENT_7fcdb9e0-636c-4d7e-b8af-e3ce69be84ce_ACT_16bd83ca-3f07-4021-80cc-302935ee3226_SESS_3ade4a4b-4a11-440c-8f17-176f1f9542ed_BOSC_20e24c2c-6e01-442a-9367-5b5485e0f99f_SNAPS_','2021-12-07 08:39:11','2019-10-25 10:30:05','03d0117e-3130-4bbe-8bb3-336b2831f77a.png','2021-12-07 09:39:11','SYNCED','03d0117e-3130-4bbe-8bb3-336b2831f77a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 195.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'03dd200a-296b-45cc-86d0-5edc592674b2','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03dd200a-296b-45cc-86d0-5edc592674b2.png','SNAPS','PATIENT_a28124a5-5a15-49be-8b28-d3f28826653d_ACT_2c77a989-d1c0-4ddd-9485-05e6e6e906cf_SESS_289ef78d-71de-454c-ab79-4baea1efb016_BOSC_2d153d35-a953-4a8b-841a-ff2021ef5289_SNAPS_','2022-03-04 13:40:21','2019-07-10 16:45:53','03dd200a-296b-45cc-86d0-5edc592674b2.png','2022-03-04 14:40:21','SYNCED','03dd200a-296b-45cc-86d0-5edc592674b2',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 30.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'03df81e0-f0c5-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03df81e0-f0c5-11e9-947d-226cec7cb58a.stl','STL','PATIENT_a129d44a-65d0-4ac1-a000-e9b31e66968b_ACT_5787cc1a-6794-4c24-ae9e-643e33ebe9f5_SESS_f3211a9e-3be7-4908-9f34-f373542de71a_TOSC_729bc0f7-9290-41ee-b4eb-003d98543423_STL_','2021-12-07 08:39:11','2019-10-17 11:57:02','03df81e0-f0c5-11e9-947d-226cec7cb58a.stl','2021-12-07 09:39:11','SYNCED','03df81e0-f0c5-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 190.1.1.1\",\"modelMatrix\":\"0.464407,-0.815054,0.346429,0,0.885622,0.427403,-0.181662,0,-2.60889e-9,0.39117,0.920318,0,-5.51707,-31.5894,-22.9935,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'03e1445a-f0c5-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03e1445a-f0c5-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_a129d44a-65d0-4ac1-a000-e9b31e66968b_ACT_5787cc1a-6794-4c24-ae9e-643e33ebe9f5_SESS_f3211a9e-3be7-4908-9f34-f373542de71a_TOSC_729bc0f7-9290-41ee-b4eb-003d98543423_PLY_','2021-12-07 08:39:11','2019-10-17 11:57:02','03e1445a-f0c5-11e9-947d-226cec7cb58a.ply','2021-12-07 09:39:11','SYNCED','03e1445a-f0c5-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 190.1.1.1\",\"modelMatrix\":\"0.464407,-0.815054,0.346429,0,0.885622,0.427403,-0.181662,0,-2.60889e-9,0.39117,0.920318,0,-5.51707,-31.5894,-22.9935,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'03e2a61f-f0c5-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03e2a61f-f0c5-11e9-947d-226cec7cb58a.stl','STL','PATIENT_a129d44a-65d0-4ac1-a000-e9b31e66968b_ACT_5787cc1a-6794-4c24-ae9e-643e33ebe9f5_SESS_f3211a9e-3be7-4908-9f34-f373542de71a_BOSC_b3edb1d0-8d9f-4ca2-8489-d8be05f5d777_STL_','2021-12-07 08:39:11','2019-10-17 12:00:40','03e2a61f-f0c5-11e9-947d-226cec7cb58a.stl','2021-12-07 09:39:11','SYNCED','03e2a61f-f0c5-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 190.1.1.1\",\"modelMatrix\":\"-0.309364,0.927218,-0.211095,0,-0.950944,-0.301645,0.0686741,0,-1.17902e-9,0.221985,0.97505,0,11.5286,16.0503,-13.2994,1\",\"title\":\"MANDIBULE STL\"}'),(2,'03e44672-f0c5-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03e44672-f0c5-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_a129d44a-65d0-4ac1-a000-e9b31e66968b_ACT_5787cc1a-6794-4c24-ae9e-643e33ebe9f5_SESS_f3211a9e-3be7-4908-9f34-f373542de71a_BOSC_b3edb1d0-8d9f-4ca2-8489-d8be05f5d777_SNAPS_','2021-12-07 08:39:11','2019-10-17 12:00:40','03e44672-f0c5-11e9-947d-226cec7cb58a.png','2021-12-07 09:39:11','SYNCED','03e44672-f0c5-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 190.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'03e5ac51-f0c5-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03e5ac51-f0c5-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_a129d44a-65d0-4ac1-a000-e9b31e66968b_ACT_5787cc1a-6794-4c24-ae9e-643e33ebe9f5_SESS_f3211a9e-3be7-4908-9f34-f373542de71a_BOSC_b3edb1d0-8d9f-4ca2-8489-d8be05f5d777_PLY_','2021-12-07 08:39:11','2019-10-17 12:00:40','03e5ac51-f0c5-11e9-947d-226cec7cb58a.ply','2021-12-07 09:39:11','SYNCED','03e5ac51-f0c5-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 190.1.1.1\",\"modelMatrix\":\"-0.309364,0.927218,-0.211095,0,-0.950944,-0.301645,0.0686741,0,-1.17902e-9,0.221985,0.97505,0,11.5286,16.0503,-13.2994,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'03e74ea5-f0c5-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03e74ea5-f0c5-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_a129d44a-65d0-4ac1-a000-e9b31e66968b_ACT_5787cc1a-6794-4c24-ae9e-643e33ebe9f5_SESS_f3211a9e-3be7-4908-9f34-f373542de71a_TOSC_729bc0f7-9290-41ee-b4eb-003d98543423_SNAPS_','2021-12-07 08:39:11','2019-10-17 11:57:02','03e74ea5-f0c5-11e9-947d-226cec7cb58a.png','2021-12-07 09:39:11','SYNCED','03e74ea5-f0c5-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 190.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0404116f-91e9-4aad-a4e7-f62202b30f2c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0404116f-91e9-4aad-a4e7-f62202b30f2c.stl','STL','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_TOSC_2afbfc00-2e27-4ab9-a065-45aed0e6c370_STL_','2021-12-07 08:39:11','2019-11-14 13:43:03','0404116f-91e9-4aad-a4e7-f62202b30f2c.stl','2021-12-07 09:39:11','SYNCED','0404116f-91e9-4aad-a4e7-f62202b30f2c',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 202.1.1.1\",\"modelMatrix\":\"0.725705,-0.591258,0.351805,0,0.688006,0.623655,-0.371082,0,2.43361e-13,0.51134,0.859379,0,12.7041,-31.2192,-23.6108,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'0405004d-d904-4c16-bc68-1973a1576c85','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0405004d-d904-4c16-bc68-1973a1576c85.ply','PLY','PATIENT_df5cd3e3-f012-41db-937e-54f6102a7215_ACT_de0c93fe-463b-44c5-a3d4-058f2138bc94_SESS_0e0aba24-d37b-41e0-a159-d57412935ff8_BOSC_27984250-2b58-4874-9026-5e21a138804a_PLY_','2021-01-06 11:01:58','2019-12-12 14:08:41','0405004d-d904-4c16-bc68-1973a1576c85.ply','2021-01-06 12:01:58','SYNCED','0405004d-d904-4c16-bc68-1973a1576c85',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 232.12.1.1\",\"modelMatrix\":\"-0.978446,0.200348,-0.0500315,0,-0.2065,-0.949294,0.237061,0,5.4752e-9,0.242283,0.970206,0,-13.1689,16.8327,-20.9766,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0424ec47-41f2-486d-9f6a-513f1ec59d26','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0424ec47-41f2-486d-9f6a-513f1ec59d26.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_e67c44fa-320d-4cec-929c-0fac66b8a7ca_SESS_584f4de7-5dda-471a-8bd1-a202eb080ef8_TOSC_2ba7bd87-daec-4f84-8049-a1f5d84c1280_PLY_','2020-12-16 10:51:22','2020-02-12 15:10:21','0424ec47-41f2-486d-9f6a-513f1ec59d26.ply','2020-12-16 11:51:22','SYNCED','0424ec47-41f2-486d-9f6a-513f1ec59d26',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.3\",\"modelMatrix\":\"0.593925,-0.79189,0.141996,0,0.80452,0.584601,-0.104827,0,-5.06499e-9,0.176498,0.984301,0,-2.50945,-35.0588,-15.1893,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0425e73a-dfb3-49c8-aad7-4655160c94e0','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0425e73a-dfb3-49c8-aad7-4655160c94e0.png','SNAPS','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_06ede66b-fe62-4fae-adf6-cb0ad7e5eb0d_SESS_6b5b6f6d-0889-4a5a-9272-79df97f4a3b2_BOSC_250eaf91-0236-42a8-be74-add31ed4f999_SNAPS_','2020-12-16 11:05:39','2020-01-23 15:06:03','0425e73a-dfb3-49c8-aad7-4655160c94e0.png','2020-12-16 12:05:39','SYNCED','0425e73a-dfb3-49c8-aad7-4655160c94e0',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'04308099-ecbb-4116-8f76-f81146bc23b6','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04308099-ecbb-4116-8f76-f81146bc23b6.png','SNAPS','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_d2f7b7b4-32ff-450c-90d1-a5f55fa4b594_SESS_7a7679ff-68b2-4367-b7ea-cd532163d818_BOSC_9292d259-554f-400e-b12c-c0f437df6c89_SNAPS_','2020-12-16 11:05:39','2020-01-15 15:14:14','04308099-ecbb-4116-8f76-f81146bc23b6.png','2020-12-16 12:05:39','SYNCED','04308099-ecbb-4116-8f76-f81146bc23b6',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0444a47b-46e7-449f-9e7c-d362465890bf','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0444a47b-46e7-449f-9e7c-d362465890bf.png','SNAPS','PATIENT_d69ddf10-a601-42dc-820a-f460242af90d_ACT_de1a5cff-fd0c-4847-ad05-dca4d654941d_SESS_d04f9fad-2c0c-450d-9694-7bd24a88e7d5_TOSC_89e34fa8-57ff-412d-9498-f6d544ee4c5f_SNAPS_','2021-12-07 08:39:12','2019-10-09 11:08:21','0444a47b-46e7-449f-9e7c-d362465890bf.png','2021-12-07 09:39:12','SYNCED','0444a47b-46e7-449f-9e7c-d362465890bf',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 181.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0447d585-3f63-4fb3-ba33-1cce4406499c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0447d585-3f63-4fb3-ba33-1cce4406499c.ply','PLY','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_085fdf08-d777-4c3e-bf1b-ba3c5d9a1188_SESS_e47de5cc-baee-41be-b434-97cd36e2cf62_BOSC_ee261dd0-3674-4619-a271-d353528625fe_PLY_','2020-12-23 09:07:21','2019-12-16 13:59:58','0447d585-3f63-4fb3-ba33-1cce4406499c.ply','2020-12-23 10:07:21','SYNCED','0447d585-3f63-4fb3-ba33-1cce4406499c',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.1.1.2\",\"modelMatrix\":\"0.476071,-0.877969,0.0502743,0,0.879407,0.475292,-0.0272162,0,-1.22536e-11,0.0571685,0.998364,0,-9.06333,-19.0344,-18.1046,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'044db94b-884c-44c4-b504-360b9a943f6e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/044db94b-884c-44c4-b504-360b9a943f6e.png','SNAPS','PATIENT_9bdadecd-3730-4989-a33e-fe0feac57f3a_ACT_8a64410e-90d6-4583-b2ff-11e95ddfbac1_SESS_d3cea504-daed-416f-9289-b020834e9ba0_BOSC_4e110fb1-3423-418e-9ab7-839b18527427_SNAPS_','2020-12-16 10:51:23','2020-05-28 10:07:23','044db94b-884c-44c4-b504-360b9a943f6e.png','2020-12-16 11:51:23','SYNCED','044db94b-884c-44c4-b504-360b9a943f6e',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 49.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0456e8a7-f0c3-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0456e8a7-f0c3-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_2b864ce0-3cc8-4b80-969d-f9b27f99086e_ACT_17d544b7-b276-47e6-81d5-535312f6ff69_SESS_ab2dadf7-83a6-4b5b-bf14-291c389c43be_TOSC_27584331-5553-42cf-bbc0-5510faa74c16_SNAPS_','2021-12-07 08:39:12','2019-10-17 11:40:31','0456e8a7-f0c3-11e9-947d-226cec7cb58a.png','2021-12-07 09:39:12','SYNCED','0456e8a7-f0c3-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 189.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0458ff02-f0c3-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0458ff02-f0c3-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_2b864ce0-3cc8-4b80-969d-f9b27f99086e_ACT_17d544b7-b276-47e6-81d5-535312f6ff69_SESS_ab2dadf7-83a6-4b5b-bf14-291c389c43be_BOSC_9deb8500-8c7a-4b84-bd3b-1d6728f4672e_PLY_','2021-12-07 08:39:12','2019-10-17 11:44:44','0458ff02-f0c3-11e9-947d-226cec7cb58a.ply','2021-12-07 09:39:12','SYNCED','0458ff02-f0c3-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 189.1.1.1\",\"modelMatrix\":\"-0.8128,0.579395,-0.0604814,0,-0.582544,-0.808407,0.0843873,0,-3.8587e-9,0.103823,0.994596,0,-4.46482,19.662,-23.6504,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'045cc40c-90e3-4762-8836-c1875a5b72b6','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/045cc40c-90e3-4762-8836-c1875a5b72b6.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_f4fade88-9b6b-4d3c-b86d-70413fa3f1c8_SESS_6df99adb-0102-41e4-8799-371d34609080_BOSC_fdc353ad-cf71-4357-844a-c7bdfc65f951_SNAPS_','2020-12-08 17:25:13','2020-06-08 10:41:44','045cc40c-90e3-4762-8836-c1875a5b72b6.png','2020-12-08 18:25:13','SYNCED','045cc40c-90e3-4762-8836-c1875a5b72b6',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.31.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'045ce80f-f0c3-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/045ce80f-f0c3-11e9-947d-226cec7cb58a.stl','STL','PATIENT_2b864ce0-3cc8-4b80-969d-f9b27f99086e_ACT_17d544b7-b276-47e6-81d5-535312f6ff69_SESS_ab2dadf7-83a6-4b5b-bf14-291c389c43be_TOSC_27584331-5553-42cf-bbc0-5510faa74c16_STL_','2021-12-07 08:39:12','2019-10-17 11:40:31','045ce80f-f0c3-11e9-947d-226cec7cb58a.stl','2021-12-07 09:39:12','SYNCED','045ce80f-f0c3-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 189.1.1.1\",\"modelMatrix\":\"0.459882,-0.856748,0.233436,0,0.88798,0.443706,-0.120895,0,-4.43804e-9,0.262884,0.964827,0,-3.81265,-37.5853,-16.1998,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'045f3223-f0c3-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/045f3223-f0c3-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_2b864ce0-3cc8-4b80-969d-f9b27f99086e_ACT_17d544b7-b276-47e6-81d5-535312f6ff69_SESS_ab2dadf7-83a6-4b5b-bf14-291c389c43be_BOSC_9deb8500-8c7a-4b84-bd3b-1d6728f4672e_SNAPS_','2021-12-07 08:39:12','2019-10-17 11:44:44','045f3223-f0c3-11e9-947d-226cec7cb58a.png','2021-12-07 09:39:12','SYNCED','045f3223-f0c3-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 189.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0460a698-f0c3-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0460a698-f0c3-11e9-947d-226cec7cb58a.stl','STL','PATIENT_2b864ce0-3cc8-4b80-969d-f9b27f99086e_ACT_17d544b7-b276-47e6-81d5-535312f6ff69_SESS_ab2dadf7-83a6-4b5b-bf14-291c389c43be_BOSC_9deb8500-8c7a-4b84-bd3b-1d6728f4672e_STL_','2021-12-07 08:39:12','2019-10-17 11:44:44','0460a698-f0c3-11e9-947d-226cec7cb58a.stl','2021-12-07 09:39:12','SYNCED','0460a698-f0c3-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 189.1.1.1\",\"modelMatrix\":\"-0.8128,0.579395,-0.0604814,0,-0.582544,-0.808407,0.0843873,0,-3.8587e-9,0.103823,0.994596,0,-4.46482,19.662,-23.6504,1\",\"title\":\"MANDIBULE STL\"}'),(2,'046225a2-f0c3-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/046225a2-f0c3-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_2b864ce0-3cc8-4b80-969d-f9b27f99086e_ACT_17d544b7-b276-47e6-81d5-535312f6ff69_SESS_ab2dadf7-83a6-4b5b-bf14-291c389c43be_TOSC_27584331-5553-42cf-bbc0-5510faa74c16_PLY_','2021-12-07 08:39:12','2019-10-17 11:40:31','046225a2-f0c3-11e9-947d-226cec7cb58a.ply','2021-12-07 09:39:12','SYNCED','046225a2-f0c3-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 189.1.1.1\",\"modelMatrix\":\"0.459882,-0.856748,0.233436,0,0.88798,0.443706,-0.120895,0,-4.43804e-9,0.262884,0.964827,0,-3.81265,-37.5853,-16.1998,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'046a5062-66c6-4469-b24c-e8862a88aa24','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/046a5062-66c6-4469-b24c-e8862a88aa24.ply','PLY','PATIENT_227c16ab-62f2-4f76-a1f4-3a753d883af7_ACT_b819729a-c589-41ec-af68-d13a0bb8c21a_SESS_caed56fc-3a88-41c5-ba84-693c72fc12d4_BOSC_6907490c-7dfd-42e8-aa94-7f0cf85bc022_PLY_','2021-12-07 08:39:12','2019-09-18 11:01:55','046a5062-66c6-4469-b24c-e8862a88aa24.ply','2021-12-07 09:39:12','SYNCED','046a5062-66c6-4469-b24c-e8862a88aa24',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 152.1.1.1\",\"modelMatrix\":\"-0.989073,-0.139013,0.0490826,0,0.147424,-0.932646,0.329297,0,-2.72371e-9,0.332935,0.94295,0,-15.4641,10.9591,-35.7228,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'049a27ff-5494-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/049a27ff-5494-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_d9a8ab1f-8d67-4ff5-815a-2852ad6a6366_SESS_7b7df491-2844-4c63-9ecb-fad2d62250c9_BOSC_627ceba9-0608-4d11-84fa-5a02ca9cfb9f_SNAPS_','2020-12-16 10:51:25','2020-02-21 11:21:32','049a27ff-5494-11ea-947d-226cec7cb58a.png','2020-12-16 11:51:25','SYNCED','049a27ff-5494-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.2.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'049d424a-5494-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/049d424a-5494-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_d9a8ab1f-8d67-4ff5-815a-2852ad6a6366_SESS_7b7df491-2844-4c63-9ecb-fad2d62250c9_TOSC_f56e1805-31be-4bfa-88fa-9fab9cdb84bd_SNAPS_','2020-12-16 10:51:26','2020-02-21 11:18:26','049d424a-5494-11ea-947d-226cec7cb58a.png','2020-12-16 11:51:26','SYNCED','049d424a-5494-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.2.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'049fa184-5494-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/049fa184-5494-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_d9a8ab1f-8d67-4ff5-815a-2852ad6a6366_SESS_7b7df491-2844-4c63-9ecb-fad2d62250c9_BOSC_627ceba9-0608-4d11-84fa-5a02ca9cfb9f_PLY_','2020-12-16 10:51:26','2020-02-21 11:21:32','049fa184-5494-11ea-947d-226cec7cb58a.ply','2020-12-16 11:51:26','SYNCED','049fa184-5494-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.2.1.1\",\"modelMatrix\":\"-0.986573,0.15367,-0.0553063,0,-0.163319,-0.928283,0.334092,0,-3.57181e-9,0.338639,0.940916,0,-16.9453,9.6915,-23.7858,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'04a15384-5494-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04a15384-5494-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_d9a8ab1f-8d67-4ff5-815a-2852ad6a6366_SESS_7b7df491-2844-4c63-9ecb-fad2d62250c9_TOSC_f56e1805-31be-4bfa-88fa-9fab9cdb84bd_PLY_','2020-12-16 10:51:26','2020-02-21 11:18:26','04a15384-5494-11ea-947d-226cec7cb58a.ply','2020-12-16 11:51:26','SYNCED','04a15384-5494-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.2.1.1\",\"modelMatrix\":\"0.0112247,-0.959526,0.281395,0,0.999937,0.0107711,-0.00315878,0,-6.58271e-11,0.281413,0.959587,0,-20.6165,-31.9941,-18.0386,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'04aabb83-2e0b-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04aabb83-2e0b-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_0331d3a8-cc7b-44e0-ae03-7f8543b4c613_ACT_c0b56124-1fc8-48f6-8278-8568f573053c_SESS_6511d2dc-171a-49fb-a3e2-c2b4bc29fe2c_TOSC_d2eea46d-7385-4d24-88ff-0305a578392e_PLY_','2020-12-23 09:07:23','2020-01-03 10:22:43','04aabb83-2e0b-11ea-947d-226cec7cb58a.ply','2020-12-23 10:07:23','SYNCED','04aabb83-2e0b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"modelMatrix\":\"0.528568,-0.805771,0.267111,0,0.848891,0.501719,-0.166319,0,-2.26092e-8,0.314659,0.949205,0,-0.578565,-33.1292,-19.5329,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'04abc13c-2197-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04abc13c-2197-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_7237dc5d-0c61-4cb9-b1db-a73cd6a11ada_ACT_c3ed1bf2-28aa-48d2-a107-07a01b82e9af_SESS_558f874e-8228-460b-a7fa-2ee26150b988_TOSC_64e8cb05-12f0-4e95-9fe8-974f57289a89_SNAPS_','2020-12-23 09:07:23','2019-12-18 14:01:21','04abc13c-2197-11ea-947d-226cec7cb58a.png','2020-12-23 10:07:23','SYNCED','04abc13c-2197-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 21.1.268.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'04ace40a-2e0b-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04ace40a-2e0b-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_c0b56124-1fc8-48f6-8278-8568f573053c_SESS_6511d2dc-171a-49fb-a3e2-c2b4bc29fe2c_BOSC_be022936-d035-4126-a288-8428a90afb91_SNAPS_','2020-12-23 09:07:23','2020-01-03 10:25:34','04ace40a-2e0b-11ea-947d-226cec7cb58a.png','2020-12-23 10:07:23','SYNCED','04ace40a-2e0b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'04ad6081-2197-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04ad6081-2197-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_ccc00cdd-6862-49a0-a8b9-ec6471536e71_ACT_c3ed1bf2-28aa-48d2-a107-07a01b82e9af_SESS_558f874e-8228-460b-a7fa-2ee26150b988_BOSC_a0b56ba5-ce3a-450f-9b5e-2191a833df5b_SNAPS_','2020-12-23 09:07:24','2019-12-18 14:05:03','04ad6081-2197-11ea-947d-226cec7cb58a.png','2020-12-23 10:07:24','SYNCED','04ad6081-2197-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 21.1.268.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'04ae6190-2e0b-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04ae6190-2e0b-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_c0b56124-1fc8-48f6-8278-8568f573053c_SESS_6511d2dc-171a-49fb-a3e2-c2b4bc29fe2c_BOSC_be022936-d035-4126-a288-8428a90afb91_PLY_','2020-12-23 09:07:24','2020-01-03 10:25:34','04ae6190-2e0b-11ea-947d-226cec7cb58a.ply','2020-12-23 10:07:24','SYNCED','04ae6190-2e0b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"modelMatrix\":\"-0.970459,0.231899,-0.066572,0,-0.241266,-0.932784,0.267777,0,-6.31081e-9,0.275928,0.961178,0,-16.7368,17.5553,-18.0188,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'04ae8cce-ca97-4787-bde2-a2d961645932','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04ae8cce-ca97-4787-bde2-a2d961645932.png','SNAPS','PATIENT_74a66f39-c9db-4c13-9dbf-7acfc0ea9391_ACT_bd746a5b-c1c4-42fa-88a3-345da35d47a0_SESS_a64913b8-d6d8-4c57-8ded-53d9f86e010a_TOSC_672a3a90-85f2-4c6a-89a3-22bebfee164c_SNAPS_','2021-12-07 08:39:12','2019-10-25 10:50:35','04ae8cce-ca97-4787-bde2-a2d961645932.png','2021-12-07 09:39:12','SYNCED','0f3334a9-68bd-49f8-a15e-a6a0ec4d2dfd',1,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 196.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'04b02e67-2e0b-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04b02e67-2e0b-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_0331d3a8-cc7b-44e0-ae03-7f8543b4c613_ACT_c0b56124-1fc8-48f6-8278-8568f573053c_SESS_6511d2dc-171a-49fb-a3e2-c2b4bc29fe2c_TOSC_d2eea46d-7385-4d24-88ff-0305a578392e_SNAPS_','2020-12-23 09:07:24','2020-01-03 10:22:43','04b02e67-2e0b-11ea-947d-226cec7cb58a.png','2020-12-23 10:07:24','SYNCED','04b02e67-2e0b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'04b2255c-2197-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04b2255c-2197-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_7237dc5d-0c61-4cb9-b1db-a73cd6a11ada_ACT_c3ed1bf2-28aa-48d2-a107-07a01b82e9af_SESS_558f874e-8228-460b-a7fa-2ee26150b988_TOSC_64e8cb05-12f0-4e95-9fe8-974f57289a89_PLY_','2020-12-23 09:07:25','2019-12-18 14:01:21','04b2255c-2197-11ea-947d-226cec7cb58a.ply','2020-12-23 10:07:25','SYNCED','04b2255c-2197-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 21.1.268.1.1.1\",\"modelMatrix\":\"0.407314,-0.880262,0.24338,0,0.913288,0.392584,-0.108544,0,5.90618e-9,0.266487,0.963838,0,-4.3112,-32.8215,-20.569,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'04b3c844-2197-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04b3c844-2197-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_ccc00cdd-6862-49a0-a8b9-ec6471536e71_ACT_c3ed1bf2-28aa-48d2-a107-07a01b82e9af_SESS_558f874e-8228-460b-a7fa-2ee26150b988_BOSC_a0b56ba5-ce3a-450f-9b5e-2191a833df5b_PLY_','2020-12-23 09:07:25','2019-12-18 14:05:03','04b3c844-2197-11ea-947d-226cec7cb58a.ply','2020-12-23 10:07:25','SYNCED','04b3c844-2197-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 21.1.268.1.1.1\",\"modelMatrix\":\"-0.95347,0.285062,-0.0981548,0,-0.301487,-0.901524,0.31042,0,-5.42887e-9,0.325569,0.945518,0,-7.5727,16.8436,-20.4036,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'04c69345-1499-498e-b315-51cfccad4ba2','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04c69345-1499-498e-b315-51cfccad4ba2.stl','STL','PATIENT_a951fff6-cb01-45e2-9da5-6b824792106c_ACT_aae68188-e6dc-4e55-a08c-a7bbaf441a12_SESS_efcfe50e-78d9-4126-b2c0-f59373cb399c_TOSC_6801e179-f17f-4b52-a428-23baefe0e101_STL_','2022-03-04 13:40:21','2019-07-10 15:40:11','04c69345-1499-498e-b315-51cfccad4ba2.stl','2022-03-04 14:40:21','SYNCED','04c69345-1499-498e-b315-51cfccad4ba2',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 28.1.1.1\",\"modelMatrix\":\"0.99658,-0.0806812,0.0178831,0,0.0826393,0.972966,-0.215659,0,-8.65997e-10,0.216399,0.976305,0,-28.8034,-20.3675,-16.9924,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'04d63205-02da-4bf9-b481-6494ed514d98','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04d63205-02da-4bf9-b481-6494ed514d98.ply','PLY','PATIENT_068fa927-65ba-41f8-a806-53e0dcc2959b_ACT_a50fd995-2816-4bae-887e-7b0ebcbfc3f5_SESS_6dc4ce39-c651-4e40-a616-1b4cdb235cff_TOSC_eb523328-ab5b-47d5-8795-28bd970f16b2_PLY_','2020-12-08 17:25:21','2020-06-16 14:30:20','04d63205-02da-4bf9-b481-6494ed514d98.ply','2020-12-08 18:25:21','SYNCED','04d63205-02da-4bf9-b481-6494ed514d98',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.46.1.1\",\"modelMatrix\":\"0.737114,-0.639776,0.2176,0,0.675769,0.697854,-0.237353,0,-7.16491e-9,0.322003,0.946739,0,1.34245,-32.5258,-20.2498,1\",\"title\":\"Maxillaire PLY\"}'),(2,'04ddf064-e61a-4da7-83d9-ca50c2c0b1be','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04ddf064-e61a-4da7-83d9-ca50c2c0b1be.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_a78941e1-e63b-4f03-84db-3c4fcdb64d89_SESS_caf59252-3532-421e-9b72-5abe78045a36_BOSC_8dab0ada-8b66-421f-a822-76bf8bad5ce6_SNAPS_','2020-12-16 10:51:29','2020-02-20 15:04:39','04ddf064-e61a-4da7-83d9-ca50c2c0b1be.png','2020-12-16 11:51:29','SYNCED','04ddf064-e61a-4da7-83d9-ca50c2c0b1be',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'04e01dca-2bcc-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04e01dca-2bcc-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_c9dbaf18-0fb2-4968-b361-68c173abadee_ACT_4e71ec6a-14de-49f1-94a7-a434f3d543ed_SESS_e5cc07c8-892b-4ec6-9fac-a0b5b66356ec_TOSC_ba50136d-7065-4cc2-b2a3-3deb58d91911_SNAPS_','2020-12-23 09:07:25','2019-12-31 13:49:05','04e01dca-2bcc-11ea-947d-226cec7cb58a.png','2020-12-23 10:07:25','SYNCED','04e01dca-2bcc-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'04e1d676-2bcc-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04e1d676-2bcc-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_c9dbaf18-0fb2-4968-b361-68c173abadee_ACT_4e71ec6a-14de-49f1-94a7-a434f3d543ed_SESS_e5cc07c8-892b-4ec6-9fac-a0b5b66356ec_TOSC_920f7df6-b178-46f7-bda7-aad391070154_PLY_','2020-12-23 09:07:26','2019-12-31 13:46:07','04e1d676-2bcc-11ea-947d-226cec7cb58a.ply','2020-12-23 10:07:26','SYNCED','04e1d676-2bcc-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"modelMatrix\":\"-0.983141,0.178659,-0.0389306,0,-0.182851,-0.960599,0.209319,0,-7.61736e-10,0.212908,0.977072,0,-3.10135,17.6651,-20.0538,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'04e25742-b8c5-43a9-adae-660e823dbf22','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04e25742-b8c5-43a9-adae-660e823dbf22.stl','STL','PATIENT_a20c5079-e26f-4d25-a4f7-898bb7b44b4f_ACT_2d40ced0-53bf-41a0-b55d-a8170b2031a3_SESS_0e2721b3-8710-485f-8ea8-bded33c4312d_TOSC_ac4cee3f-45d4-431b-899a-1094f9f31a8d_STL_','2022-02-17 14:31:11','2019-08-20 15:17:46','04e25742-b8c5-43a9-adae-660e823dbf22.stl','2022-02-17 15:31:11','SYNCED','04e25742-b8c5-43a9-adae-660e823dbf22',0,'2022-02-17 15:31:11','','','{\"displayTitle\":\"MAXILLAIRE 129.1.1.1.1\",\"modelMatrix\":\"0.63609,-0.729718,0.250801,0,0.771615,0.601552,-0.206751,0,-3.92588e-9,0.325035,0.945702,0,0.907116,-34.8798,-16.1821,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'04e34e26-2bcc-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04e34e26-2bcc-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_c9dbaf18-0fb2-4968-b361-68c173abadee_ACT_4e71ec6a-14de-49f1-94a7-a434f3d543ed_SESS_e5cc07c8-892b-4ec6-9fac-a0b5b66356ec_TOSC_ba50136d-7065-4cc2-b2a3-3deb58d91911_PLY_','2020-12-23 09:07:26','2019-12-31 13:49:05','04e34e26-2bcc-11ea-947d-226cec7cb58a.ply','2020-12-23 10:07:26','SYNCED','04e34e26-2bcc-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"modelMatrix\":\"0.415761,-0.84638,0.33284,0,0.909474,0.386918,-0.152156,0,6.77872e-9,0.36597,0.930627,0,-3.74244,-34.9458,-21.6852,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'04e578a1-2bcc-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04e578a1-2bcc-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_c9dbaf18-0fb2-4968-b361-68c173abadee_ACT_4e71ec6a-14de-49f1-94a7-a434f3d543ed_SESS_e5cc07c8-892b-4ec6-9fac-a0b5b66356ec_TOSC_920f7df6-b178-46f7-bda7-aad391070154_SNAPS_','2020-12-23 09:07:26','2019-12-31 13:46:07','04e578a1-2bcc-11ea-947d-226cec7cb58a.png','2020-12-23 10:07:26','SYNCED','04e578a1-2bcc-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'04f507b5-8bd9-4216-91a4-4df747b11226','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04f507b5-8bd9-4216-91a4-4df747b11226.png','SNAPS','PATIENT_dc79f3b2-d683-43ed-b1fa-7c071f41f22f_ACT_b951b408-da73-41a1-be4c-5976b8fd8339_SESS_70eca243-d3b9-437e-a3be-2cba7f50d4a2_TOSC_a0048acf-12b0-4191-9b3f-848665b63760_SNAPS_','2021-12-07 08:39:13','2019-10-01 09:39:55','04f507b5-8bd9-4216-91a4-4df747b11226.png','2021-12-07 09:39:13','SYNCED','04f507b5-8bd9-4216-91a4-4df747b11226',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 169.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'050917c3-4e76-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/050917c3-4e76-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_e67c44fa-320d-4cec-929c-0fac66b8a7ca_SESS_584f4de7-5dda-471a-8bd1-a202eb080ef8_BOSC_a839179b-0053-4b45-954c-a0b9c9e06bd4_SNAPS_','2020-12-16 10:51:30','2020-02-12 10:43:23','050917c3-4e76-11ea-947d-226cec7cb58a.png','2020-12-16 11:51:30','SYNCED','050917c3-4e76-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'050ad2e3-4e76-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/050ad2e3-4e76-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_e67c44fa-320d-4cec-929c-0fac66b8a7ca_SESS_584f4de7-5dda-471a-8bd1-a202eb080ef8_BOSC_a839179b-0053-4b45-954c-a0b9c9e06bd4_PLY_','2020-12-16 10:51:31','2020-02-12 10:43:23','050ad2e3-4e76-11ea-947d-226cec7cb58a.ply','2020-12-16 11:51:31','SYNCED','050ad2e3-4e76-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"modelMatrix\":\"-0.624188,0.772523,-0.116608,0,-0.781274,-0.617196,0.093162,0,4.23084e-9,0.149253,0.988799,0,6.53274,19.1368,-15.6158,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'052d3463-9885-4125-8532-1a1ac4b4b09d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/052d3463-9885-4125-8532-1a1ac4b4b09d.ply','PLY','PATIENT_dffebdef-29f0-48d3-a06b-c16d19da2836_ACT_877296c2-8eeb-49fe-afdb-abb4d477d113_SESS_61ce92e0-cf8d-4d3a-bf40-f61b2dcf18e5_BOSC_5a5f0eb0-57c6-4b92-87a4-2943a6799cc5_PLY_','2021-12-07 08:39:13','2019-07-15 13:20:18','052d3463-9885-4125-8532-1a1ac4b4b09d.ply','2021-12-07 09:39:13','SYNCED','052d3463-9885-4125-8532-1a1ac4b4b09d',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 63.3.1.1\",\"modelMatrix\":\"-0.986489,-0.155414,0.0518306,0,0.163829,-0.935819,0.312095,0,4.70652e-10,0.316369,0.948636,0,-26.4296,10.9661,-21.217,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0531f268-cba5-4840-864f-11f7158e49dc','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0531f268-cba5-4840-864f-11f7158e49dc.stl','STL','PATIENT_978991c3-73ec-4272-81bb-35e9fa062036_ACT_f94467b8-6cae-452e-880a-7e1c05d160ee_SESS_f0f0a818-08c6-47f4-9ea1-3e8b8fc3b874_TOSC_6e628d10-e5df-4cf1-a696-e2ffa827067f_STL_','2021-12-07 08:39:13','2019-09-02 10:14:21','0531f268-cba5-4840-864f-11f7158e49dc.stl','2021-12-07 09:39:13','SYNCED','0531f268-cba5-4840-864f-11f7158e49dc',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 135.1.1.1\",\"modelMatrix\":\"0.366572,-0.755427,0.543098,0,0.93039,0.297637,-0.213979,0,-2.72584e-9,0.583731,0.811947,0,-4.62399,-42.8038,-15.7739,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'053856db-646e-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/053856db-646e-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_bfff99cf-e91f-4eed-bb3a-06bece8eaf9f_ACT_b7c84d8c-fbc4-465a-ac48-6c183da143a6_SESS_11809b61-25e7-46d5-bf47-cd02b888e7ae_TOSC_7d7a0827-7efd-49c9-821e-fe36b7e07a14_SNAPS_','2020-12-16 10:51:31','2020-03-12 15:25:00','053856db-646e-11ea-947d-226cec7cb58a.png','2020-12-16 11:51:31','SYNCED','053856db-646e-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 20.1.1.2.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'053a4961-646e-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/053a4961-646e-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_bfff99cf-e91f-4eed-bb3a-06bece8eaf9f_ACT_b7c84d8c-fbc4-465a-ac48-6c183da143a6_SESS_11809b61-25e7-46d5-bf47-cd02b888e7ae_BOSC_1ed09b04-4bda-4908-ab68-9037606cc0e9_PLY_','2020-12-16 10:51:32','2020-03-12 15:30:12','053a4961-646e-11ea-947d-226cec7cb58a.ply','2020-12-16 11:51:32','SYNCED','053a4961-646e-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 20.1.1.2.1.1\",\"modelMatrix\":\"-0.995741,-0.0876824,0.0284807,0,0.0921919,-0.947035,0.307613,0,-7.69095e-10,0.308929,0.951085,0,-20.4083,9.58921,-23.1594,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'053c019f-646e-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/053c019f-646e-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_bfff99cf-e91f-4eed-bb3a-06bece8eaf9f_ACT_b7c84d8c-fbc4-465a-ac48-6c183da143a6_SESS_11809b61-25e7-46d5-bf47-cd02b888e7ae_BOSC_1ed09b04-4bda-4908-ab68-9037606cc0e9_SNAPS_','2020-12-16 10:51:32','2020-03-12 15:30:12','053c019f-646e-11ea-947d-226cec7cb58a.png','2020-12-16 11:51:32','SYNCED','053c019f-646e-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 20.1.1.2.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'053e254c-646e-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/053e254c-646e-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_bfff99cf-e91f-4eed-bb3a-06bece8eaf9f_ACT_b7c84d8c-fbc4-465a-ac48-6c183da143a6_SESS_11809b61-25e7-46d5-bf47-cd02b888e7ae_TOSC_7d7a0827-7efd-49c9-821e-fe36b7e07a14_PLY_','2020-12-16 10:51:32','2020-03-12 15:25:00','053e254c-646e-11ea-947d-226cec7cb58a.ply','2020-12-16 11:51:32','SYNCED','053e254c-646e-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 20.1.1.2.1.1\",\"modelMatrix\":\"0.176498,-0.938781,0.29587,0,0.984301,0.168335,-0.0530533,0,2.44693e-9,0.300589,0.953754,0,-17.1177,-30.9431,-23.3501,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'054c7b46-8e49-4b26-9fe5-2629b21cc10e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/054c7b46-8e49-4b26-9fe5-2629b21cc10e.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_9d55e20d-c9a3-47c1-be07-a1b8b8e1ad46_SESS_f4c4cf33-1da8-4a4f-a33c-5f4ad5b9b16d_BOSC_a577cccc-2b82-47f4-ad7c-b1b671b00bee_PLY_','2020-12-16 11:05:45','2020-01-31 14:08:56','054c7b46-8e49-4b26-9fe5-2629b21cc10e.ply','2020-12-16 12:05:45','SYNCED','054c7b46-8e49-4b26-9fe5-2629b21cc10e',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.2\",\"modelMatrix\":\"-0.722198,0.687827,-0.0729651,0,-0.691686,-0.718169,0.0761838,0,-3.43021e-9,0.105489,0.99442,0,5.72091,19.7596,-24.2097,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0562db7b-9ccb-42d4-b4de-2287830bf34a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0562db7b-9ccb-42d4-b4de-2287830bf34a.png','SNAPS','PATIENT_b87a45f4-e9da-42dd-a118-319f1cadc208_ACT_e48ea1a6-dafa-457d-b928-ddb5957d68d3_SESS_0b023d1b-96d3-44b5-b2a9-50a025917cea_TOSC_c41f71a3-52ee-4451-83e9-f2bc1af1e94e_SNAPS_','2021-12-07 08:39:13','2019-07-26 09:12:09','0562db7b-9ccb-42d4-b4de-2287830bf34a.png','2021-12-07 09:39:13','SYNCED','0562db7b-9ccb-42d4-b4de-2287830bf34a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 72.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0575c532-ee5c-4204-adb3-37ddf2f3e229','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0575c532-ee5c-4204-adb3-37ddf2f3e229.png','SNAPS','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_db56cba1-23ff-48bf-b86e-4ceff749087f_TOSC_98d2d011-681b-459b-9f74-1d29047fb345_SNAPS_','2021-12-07 08:39:13','2019-11-14 15:15:13','0575c532-ee5c-4204-adb3-37ddf2f3e229.png','2021-12-07 09:39:13','SYNCED','0575c532-ee5c-4204-adb3-37ddf2f3e229',0,NULL,'','','{\"displayTitle\":\"Mascella 0\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'059312d2-4e76-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/059312d2-4e76-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_e67c44fa-320d-4cec-929c-0fac66b8a7ca_SESS_584f4de7-5dda-471a-8bd1-a202eb080ef8_BOSC_a839179b-0053-4b45-954c-a0b9c9e06bd4_SNAPS_','2020-12-16 10:51:33','2020-02-12 10:43:23','059312d2-4e76-11ea-947d-226cec7cb58a.png','2020-12-16 11:51:33','SYNCED','059312d2-4e76-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'059549a1-4e76-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/059549a1-4e76-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_e67c44fa-320d-4cec-929c-0fac66b8a7ca_SESS_584f4de7-5dda-471a-8bd1-a202eb080ef8_BOSC_a839179b-0053-4b45-954c-a0b9c9e06bd4_PLY_','2020-12-16 10:51:34','2020-02-12 10:43:23','059549a1-4e76-11ea-947d-226cec7cb58a.ply','2020-12-16 11:51:34','SYNCED','059549a1-4e76-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"modelMatrix\":\"-0.624188,0.772523,-0.116608,0,-0.781274,-0.617196,0.093162,0,4.23084e-9,0.149253,0.988799,0,6.53274,19.1368,-15.6158,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'05a790e6-4522-4e4d-a3aa-50954d8ecea7','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05a790e6-4522-4e4d-a3aa-50954d8ecea7.png','SNAPS','PATIENT_6592423c-c895-4f90-ae97-d29a34961d34_ACT_6628cbc8-0118-491e-93d0-25211a465bc4_SESS_6e23570d-ebd1-4a63-9ffe-aa47019113cd_TOSC_457faa66-0e03-48aa-8993-67dd0d38bb88_SNAPS_','2022-03-04 13:40:22','2019-07-09 13:14:08','05a790e6-4522-4e4d-a3aa-50954d8ecea7.png','2022-03-04 14:40:22','SYNCED','05a790e6-4522-4e4d-a3aa-50954d8ecea7',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 11.2.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'05abdc47-105e-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05abdc47-105e-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_fd694b3f-abde-4e46-91f7-7c62bfdcafa4_SESS_73a3f5b9-e905-4911-a163-2022e1de3380_TOSC_e19a083d-61ad-4910-8a4a-2676147e39fe_SNAPS_','2021-08-05 07:30:41','2019-11-26 16:00:47','05abdc47-105e-11ea-947d-226cec7cb58a.png','2021-08-05 09:30:41','SYNCED','05abdc47-105e-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'05ad6cf6-105e-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05ad6cf6-105e-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_fd694b3f-abde-4e46-91f7-7c62bfdcafa4_SESS_73a3f5b9-e905-4911-a163-2022e1de3380_TOSC_e19a083d-61ad-4910-8a4a-2676147e39fe_PLY_','2021-08-05 07:30:41','2019-11-26 16:00:47','05ad6cf6-105e-11ea-947d-226cec7cb58a.ply','2021-08-05 09:30:41','SYNCED','05ad6cf6-105e-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"modelMatrix\":\"0.812499,-0.533535,0.234916,0,0.582962,0.74361,-0.327413,0,1.71683e-8,0.40297,0.915213,0,9.90536,-33.4042,-14.2184,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'05aef557-105e-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05aef557-105e-11ea-947d-226cec7cb58a.stl','STL','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_fd694b3f-abde-4e46-91f7-7c62bfdcafa4_SESS_73a3f5b9-e905-4911-a163-2022e1de3380_TOSC_e19a083d-61ad-4910-8a4a-2676147e39fe_STL_','2021-08-05 07:30:41','2019-11-26 16:00:47','05aef557-105e-11ea-947d-226cec7cb58a.stl','2021-08-05 09:30:41','SYNCED','05aef557-105e-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"modelMatrix\":\"0.812499,-0.533535,0.234916,0,0.582962,0.74361,-0.327413,0,1.71683e-8,0.40297,0.915213,0,9.90536,-33.4042,-14.2184,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'05caca0f-3b10-4228-914c-c378834c7b2a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05caca0f-3b10-4228-914c-c378834c7b2a.stl','STL','PATIENT_dfbf8ad5-0860-4209-8b85-003bb4250cea_ACT_8cf2d43b-73ce-4c11-9178-da113e274d32_SESS_b49d130d-87ee-424a-9a76-0420a20e43ad_TOSC_8370aa9d-f601-405d-b4ad-04ba67eedf23_STL_','2021-12-07 08:39:13','2019-08-27 10:31:44','05caca0f-3b10-4228-914c-c378834c7b2a.stl','2021-12-07 09:39:13','SYNCED','8db23c6e-b97d-4ddc-a1cb-a99e972e5f54',2,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 133.1.1.1\",\"modelMatrix\":\"0.892058,-0.420264,0.166163,0,0.45192,0.829571,-0.327993,0,1.40793e-8,0.367681,0.929952,0,10.6768,-36.1223,-16.9831,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'05d7c128-146d-4399-8a0f-7564363f79b0','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05d7c128-146d-4399-8a0f-7564363f79b0.ply','PLY','PATIENT_5f861654-dd88-4404-b6ce-ab61dd80d65a_ACT_283ffdd7-9872-400e-8864-ceb7a283e06c_SESS_053ae2bd-f330-4080-9666-9491f24cbd51_TOSC_d0ec3bf9-0b1d-4ac2-953b-6e06c3399146_PLY_','2021-12-07 08:39:13','2019-09-03 11:40:46','05d7c128-146d-4399-8a0f-7564363f79b0.ply','2021-12-07 09:39:13','SYNCED','05d7c128-146d-4399-8a0f-7564363f79b0',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 142.1.1.1\",\"modelMatrix\":\"0.497483,-0.760571,0.417185,0,0.867474,0.436175,-0.239249,0,-7.18833e-10,0.480919,0.876765,0,-1.44043,-33.7094,-16.4454,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'05ec1b46-2050-4be9-be12-817f265a328d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05ec1b46-2050-4be9-be12-817f265a328d.png','SNAPS','PATIENT_bfff99cf-e91f-4eed-bb3a-06bece8eaf9f_ACT_ee7a5012-1ec5-43b8-82bd-f42cb859f757_SESS_0b92af6d-d56a-4d56-941a-44824081e629_BOSC_dad20e14-4c4a-4ce3-8d10-65382dc7bdfc_SNAPS_','2021-06-07 11:39:06','2019-12-18 13:42:54','05ec1b46-2050-4be9-be12-817f265a328d.png','2021-06-07 13:39:06','SYNCED','05ec1b46-2050-4be9-be12-817f265a328d',0,'2021-06-07 13:39:06','','','{\"displayTitle\":\"MANDIBULE 20.1.268.1.1.2\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'05eefaa6-45b9-46c4-8a54-9081e076f7ea','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05eefaa6-45b9-46c4-8a54-9081e076f7ea.png','SNAPS','PATIENT_a10e3f5d-314e-4b48-9f85-704e43cd8e68_ACT_c18fcc45-0d8e-4d09-98c9-44de0d8535be_SESS_ccecfdc2-f538-407e-a5e3-2522a945ca39_TOSC_f47aa494-8830-4011-b50d-9159de431d77_SNAPS_','2022-03-04 13:40:22','2019-07-09 15:51:52','05eefaa6-45b9-46c4-8a54-9081e076f7ea.png','2022-03-04 14:40:22','SYNCED','05eefaa6-45b9-46c4-8a54-9081e076f7ea',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 13.3.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'063ff7c3-56c8-4eb7-9705-d05dfab764c4','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/063ff7c3-56c8-4eb7-9705-d05dfab764c4.png','SNAPS','PATIENT_2df9c598-3519-4719-a1e4-f4e150a235a9_ACT_ceb083f7-ec86-4eba-9690-123a703c3abc_SESS_ea3ce5df-3ae9-45ef-896c-5661af24bc30_TOSC_4114ee21-40cc-4ffd-84df-2b8954d95607_SNAPS_','2021-12-30 18:03:03','2019-11-21 15:39:30','063ff7c3-56c8-4eb7-9705-d05dfab764c4.png','2021-12-30 19:03:03','SYNCED','b4c99326-ad69-456f-99a3-02956ba9f6fc',1,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 207.3.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'066516ae-da48-4d25-8d7c-061717ebb48c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/066516ae-da48-4d25-8d7c-061717ebb48c.png','SNAPS','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_0ddbb940-8c37-4403-b0e9-1fe058ea5261_SESS_10c77bce-3658-442c-bda4-03d5e4618ea0_BOSC_372e3005-b44d-4f87-93a6-f97178c97192_SNAPS_','2020-12-16 11:05:47','2020-01-15 15:00:46','066516ae-da48-4d25-8d7c-061717ebb48c.png','2020-12-16 12:05:47','SYNCED','066516ae-da48-4d25-8d7c-061717ebb48c',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'066da2fc-4c14-42e7-90c9-728b1a3b2266','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/066da2fc-4c14-42e7-90c9-728b1a3b2266.stl','STL','PATIENT_dec054d6-9cc2-469e-ac1b-f0b2fcd7b449_ACT_91242394-1612-4b65-bd03-91bfa48432f6_SESS_df03db5c-f821-47c5-add4-bdce62ba0dc4_BOSC_610aeb0c-c528-49a1-9d82-3a6a8bda7e7e_STL_','2021-12-30 18:03:03','2019-10-11 16:42:33','066da2fc-4c14-42e7-90c9-728b1a3b2266.stl','2021-12-30 19:03:03','SYNCED','066da2fc-4c14-42e7-90c9-728b1a3b2266',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 186.1.1.1\",\"modelMatrix\":\"-0.927884,0.360288,-0.0960432,0,-0.372869,-0.896575,0.239003,0,5.95159e-9,0.257579,0.966257,0,-10.3635,18.4555,-21.2926,1\",\"title\":\"MANDIBULE STL\"}'),(2,'067b9457-0f00-41e6-ba3b-3722dbf6572b','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/067b9457-0f00-41e6-ba3b-3722dbf6572b.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_43dc61b8-8a78-42d9-8ed9-0050f80eadb4_SESS_1296078b-02a5-4737-9afa-e4afb6771314_BOSC_45ec4140-ab16-4b14-818c-75d4340894b4_PLY_','2020-12-16 10:51:36','2020-02-11 15:03:54','067b9457-0f00-41e6-ba3b-3722dbf6572b.ply','2020-12-16 11:51:36','SYNCED','067b9457-0f00-41e6-ba3b-3722dbf6572b',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"modelMatrix\":\"-0.568087,0.812234,-0.13249,0,-0.822969,-0.560677,0.0914565,0,2.42039e-9,0.16099,0.986956,0,8.61376,18.4525,-15.6196,1\",\"title\":\"MANDIBULE PLY\"}'),(524,'067dc69d-c1a5-4fc9-8514-265da48879eb','/var/.data/2020/9f2592c4-76b3-4230-b316-5ec7307bcb92/2a40421f-a9d5-41ba-9038-ffb6617b8b4b/session_e4f3f501-0920-4580-a2a7-147aac8ee471/occlusion_d32d455b-5916-40f8-bd39-4d728901842f/computedocclusion_d32d455b-5916-40f8-bd39-4d7migraoccl/2_w1_o1_mandibule_occlusion_occ_file_0.ply','PLY','PATIENT_2a40421f-a9d5-41ba-9038-ffb6617b8b4b_ACT_e4f3f501-0920-4580-a2a7-147aac8ee471_SESS_d32d455b-5916-40f8-bd39-4d728901842f_OCC_d32d455b-5916-40f8-bd39-4d7migraoccl_BOPLY__PLY_','2022-03-04 13:42:44','2020-01-22 13:57:17','2_w1_o1_mandibule_occlusion_occ_file_0.ply','2022-03-04 14:42:44','SYNCED','067dc69d-c1a5-4fc9-8514-265da48879eb',0,NULL,'9f2592c4-76b3-4230-b316-5ec7307bcb92','9f2592c4-76b3-4230-b316-5ec7307bcb92','{\"displayTitle\":\"Mandibule Occlusion 1.2.1.1.1\",\"referenceScanID\":\"1.2.1.1.1\",\"title\":\"Mandibule Occlusion PLY\"}'),(2,'068757e7-bbcd-4032-9f43-d0507eaf91fd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/068757e7-bbcd-4032-9f43-d0507eaf91fd.stl','STL','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_aceb6871-e01a-4e37-9c9f-33adfe6e0268_SESS_1ad73395-8cbd-4dcc-9a8e-cf3241e4e156_BOSC_0b40cf8a-581b-4ca9-90a5-cd0340988c9a_STL_','2021-08-05 07:30:43','2019-11-29 09:24:56','068757e7-bbcd-4032-9f43-d0507eaf91fd.stl','2021-08-05 09:30:43','SYNCED','068757e7-bbcd-4032-9f43-d0507eaf91fd',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.1.1\",\"modelMatrix\":\"-0.993012,0.110987,-0.0401215,0,-0.118017,-0.933866,0.337589,0,-1.6142e-9,0.339965,0.940438,0,-15.1095,16.5385,-18.8615,1\",\"title\":\"MANDIBULE STL\"}'),(2,'06b8557c-ec59-4644-a9f1-da49565f61b0','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/06b8557c-ec59-4644-a9f1-da49565f61b0.stl','STL','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_BOSC_354fcd1e-1b9b-4433-a96d-a079f19a9534_STL_','2021-12-30 18:03:03','2019-11-15 13:57:45','06b8557c-ec59-4644-a9f1-da49565f61b0.stl','2021-12-30 19:03:03','SYNCED','06b8557c-ec59-4644-a9f1-da49565f61b0',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 202.1.1.1\",\"modelMatrix\":\"-0.943152,0.327826,-0.0547245,0,-0.332363,-0.930279,0.155293,0,3.18135e-9,0.164653,0.986352,0,-9.12563,17.863,-21.143,1\",\"title\":\"MANDIBULE STL\"}'),(2,'06b8cf84-289b-4144-868c-a07bef93e7a0','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/06b8cf84-289b-4144-868c-a07bef93e7a0.ply','PLY','PATIENT_24e6296f-61e8-4047-8ff5-f9ed012a1232_ACT_eda2d23f-44a6-4af8-860c-2bddc040e439_SESS_24b4dd62-660c-4500-aadc-c90c5e1d3168_BOSC_459b9814-3e40-4e6f-baf4-65e771a13f53_PLY_','2022-03-04 13:40:22','2019-07-10 10:58:41','06b8cf84-289b-4144-868c-a07bef93e7a0.ply','2022-03-04 14:40:22','SYNCED','06b8cf84-289b-4144-868c-a07bef93e7a0',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 22.1.1.1\",\"modelMatrix\":\"-0.996483,0.0828682,-0.0124428,0,-0.0837971,-0.985436,0.147965,0,4.60215e-10,0.148487,0.988914,0,-19.9973,18.5808,-24.8957,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'06ca1d21-368e-44b1-9e8d-a550d7b6829b','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/06ca1d21-368e-44b1-9e8d-a550d7b6829b.png','SNAPS','PATIENT_b300e71e-93ef-48e1-8eb9-e4f1c516a9d5_ACT_47fe2ba9-f5ad-42b7-b29b-475d98d6c3d9_SESS_0ebe1667-9b32-41d1-b4c9-a74f9fad08a2_TOSC_b0443fa1-e270-464d-8cfb-000049160b31_SNAPS_','2021-01-06 11:02:03','2019-12-13 14:48:23','06ca1d21-368e-44b1-9e8d-a550d7b6829b.png','2021-01-06 12:02:03','SYNCED','06ca1d21-368e-44b1-9e8d-a550d7b6829b',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 232.20.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'06ea002b-0a78-441d-aed0-69ebed1b8e67','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/06ea002b-0a78-441d-aed0-69ebed1b8e67.ply','PLY','PATIENT_ee4744a4-0cfa-43ac-9f41-9b2f812ad53d_ACT_93fe39b1-22fa-40c6-9508-a1e59ecdb3de_SESS_c3b612b4-bea4-4d2f-a26e-e720114fd914_TOSC_b3afedf8-e464-4f33-8738-3aa38dc38a08_PLY_','2021-12-30 18:03:04','2019-07-15 17:26:54','06ea002b-0a78-441d-aed0-69ebed1b8e67.ply','2021-12-30 19:03:04','SYNCED','7ec36ae8-ef6e-47b4-a27f-9b8d4535a3f2',1,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 72.1.1.1\",\"modelMatrix\":\"0.889398,-0.416987,0.187334,0,0.457134,0.811287,-0.364475,0,-6.35333e-9,0.4098,0.912175,0,13.6667,-40.099,-11.6335,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'06ec7c3f-4f45-452f-8f49-2cd390b8ee92','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/06ec7c3f-4f45-452f-8f49-2cd390b8ee92.png','SNAPS','PATIENT_b66c8b16-da16-4738-b82d-c2ca14d347df_ACT_e05ca76e-09b0-4832-915f-5d8f769e2ea5_SESS_540861f8-5ba9-4984-8617-509dd1da3f0e_TOSC_374a902c-e2a4-4899-a882-226cd0645ca1_SNAPS_','2020-12-23 09:07:31','2019-12-18 14:09:59','06ec7c3f-4f45-452f-8f49-2cd390b8ee92.png','2020-12-23 10:07:31','SYNCED','06ec7c3f-4f45-452f-8f49-2cd390b8ee92',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 20.1.267.1.1.2\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'06fd3671-30b6-472a-a7b2-663f003673d7','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/06fd3671-30b6-472a-a7b2-663f003673d7.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_63cad8a7-ad8a-45a0-9b8c-0cd14133beb1_SESS_301fa620-c944-4147-9b90-4343dc3a468b_TOSC_f75e676b-5fa5-4e04-a767-dcdbfe755df8_SNAPS_','2020-12-16 10:51:38','2020-05-20 14:59:27','06fd3671-30b6-472a-a7b2-663f003673d7.png','2020-12-16 11:51:38','SYNCED','06fd3671-30b6-472a-a7b2-663f003673d7',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 216.1.2.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'07034e7f-9850-47b6-bbda-171d61ce6047','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07034e7f-9850-47b6-bbda-171d61ce6047.ply','PLY','PATIENT_1726cd89-f2a1-4528-bf69-d3a18a5aaa71_ACT_afbd2d3d-fdc4-4c89-b445-f65a75119d97_SESS_71887ae7-34c5-4a58-9942-d643739a52f4_TOSC_4d480282-a30b-422f-b05b-c7b46744b349_PLY_','2020-12-16 10:51:38','2020-02-05 13:27:27','07034e7f-9850-47b6-bbda-171d61ce6047.ply','2020-12-16 11:51:38','SYNCED','07034e7f-9850-47b6-bbda-171d61ce6047',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"modelMatrix\":\"0.912101,-0.386215,0.137513,0,0.409965,0.85926,-0.305943,0,-4.03176e-9,0.335426,0.942066,0,12.5029,-25.914,-17.5718,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'07078b77-9aa6-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07078b77-9aa6-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_346179d4-644c-4816-83f1-b1c374c2c119_SESS_e736d7e4-27ed-44f2-be3d-a50efcf33db4_TOSC_e953b5a5-0174-441b-9d65-1dd36187779c_PLY_','2020-12-16 10:51:38','2020-05-20 16:24:51','07078b77-9aa6-11ea-947d-226cec7cb58a.ply','2020-12-16 11:51:38','SYNCED','07078b77-9aa6-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 216.1.7.1.1\",\"modelMatrix\":\"-0.361508,-0.898338,0.249601,0,0.932369,-0.348313,0.0967778,0,-4.5028e-9,0.267706,0.963501,0,-27.2562,-17.9704,-21.7141,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0709ad38-9aa6-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0709ad38-9aa6-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_346179d4-644c-4816-83f1-b1c374c2c119_SESS_e736d7e4-27ed-44f2-be3d-a50efcf33db4_TOSC_e953b5a5-0174-441b-9d65-1dd36187779c_SNAPS_','2020-12-16 10:51:39','2020-05-20 16:24:51','0709ad38-9aa6-11ea-947d-226cec7cb58a.png','2020-12-16 11:51:39','SYNCED','0709ad38-9aa6-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 216.1.7.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'070a1f7f-3193-44e5-b2ca-2fc8e55458c2','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/070a1f7f-3193-44e5-b2ca-2fc8e55458c2.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_16d7b282-66e1-4355-9b60-0bafa1ca8e98_SESS_220665e1-59d7-472e-9aaf-149ee093a8e1_TOSC_43b0bf3c-4e11-4230-b40a-c0d9f728e658_SNAPS_','2020-12-16 10:51:39','2020-05-27 16:14:40','070a1f7f-3193-44e5-b2ca-2fc8e55458c2.png','2020-12-16 11:51:39','SYNCED','070a1f7f-3193-44e5-b2ca-2fc8e55458c2',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 216.1.18.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'070abf44-a38e-4718-a888-78d19638df0e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/070abf44-a38e-4718-a888-78d19638df0e.ply','PLY','PATIENT_f6a9d20f-4172-4d39-ba1f-4f41db70ecf7_ACT_fd08bf2b-a80c-4955-aae7-db4757ea760f_SESS_835f8695-828f-44c2-b917-01ed20fcf20f_BOSC_9587fc84-7571-48b4-ae98-413ef6e5f2f5_PLY_','2021-12-30 18:03:04','2019-07-30 13:42:54','070abf44-a38e-4718-a888-78d19638df0e.ply','2021-12-30 19:03:04','SYNCED','070abf44-a38e-4718-a888-78d19638df0e',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 117.1.1.1\",\"modelMatrix\":\"-0.986844,-0.157745,0.0354338,0,0.161676,-0.962851,0.216282,0,3.75321e-9,0.219166,0.975688,0,-20.0397,10.0574,-26.2799,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'070b8cde-9aa6-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/070b8cde-9aa6-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_346179d4-644c-4816-83f1-b1c374c2c119_SESS_e736d7e4-27ed-44f2-be3d-a50efcf33db4_BOSC_28317be3-724b-40c0-acd2-71b025a48fb8_SNAPS_','2020-12-16 10:51:39','2020-05-20 16:27:12','070b8cde-9aa6-11ea-947d-226cec7cb58a.png','2020-12-16 11:51:39','SYNCED','070b8cde-9aa6-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 216.1.7.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'070d80b9-9aa6-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/070d80b9-9aa6-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_346179d4-644c-4816-83f1-b1c374c2c119_SESS_e736d7e4-27ed-44f2-be3d-a50efcf33db4_BOSC_28317be3-724b-40c0-acd2-71b025a48fb8_PLY_','2020-12-16 10:51:40','2020-05-20 16:27:12','070d80b9-9aa6-11ea-947d-226cec7cb58a.ply','2020-12-16 11:51:40','SYNCED','070d80b9-9aa6-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 216.1.7.1.1\",\"modelMatrix\":\"-0.96938,0.227565,-0.0922842,0,-0.245565,-0.898324,0.364296,0,-1.63901e-10,0.375803,0.9267,0,-16.5924,16.96,-16.3113,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0710005b-aadd-4c8d-aeb5-a4c43f941002','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0710005b-aadd-4c8d-aeb5-a4c43f941002.png','SNAPS','PATIENT_18401d60-483b-4b93-9647-53c77e9930bd_ACT_c1277707-2973-4f51-a731-cb23e64a7a44_SESS_bc075a83-0346-4556-9154-f07079993cd8_TOSC_5a00f895-d081-4305-b452-88e1f51d797f_SNAPS_','2020-12-08 17:25:47','2020-06-05 10:35:25','0710005b-aadd-4c8d-aeb5-a4c43f941002.png','2020-12-08 18:25:47','SYNCED','0710005b-aadd-4c8d-aeb5-a4c43f941002',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.22.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'07159b8f-4d9b-4dc8-b555-167f0c71a9cf','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07159b8f-4d9b-4dc8-b555-167f0c71a9cf.ply','PLY','PATIENT_e7a45a68-ba38-4e97-bfd2-34fd3e8d0d4a_ACT_ebf70c6b-8993-444f-b73a-7b93ad4320dc_SESS_d591e9f4-fee5-48a1-bf3f-02ffa1a384cc_BOSC_d476a1e0-d16e-4fc3-bdfd-fe557cbf8869_PLY_','2022-03-04 13:40:22','2019-07-10 17:46:46','07159b8f-4d9b-4dc8-b555-167f0c71a9cf.ply','2022-03-04 14:40:22','SYNCED','07159b8f-4d9b-4dc8-b555-167f0c71a9cf',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 35.1.1.1\",\"modelMatrix\":\"-0.950688,-0.294787,0.0963967,0,0.310148,-0.903603,0.295482,0,6.14392e-9,0.310809,0.950472,0,-21.4337,9.7346,-28.879,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'071b8999-ce23-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/071b8999-ce23-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_6df72f48-6933-4986-9961-403150b72460_ACT_8066fb46-4e88-4174-a7b5-ced23d87937b_SESS_59d4c3ec-651e-4d62-b38d-23c6193830fb_BOSC_6c729960-d05e-4459-88a9-b2710ad7af41_PLY_','2021-12-30 18:03:05','2019-09-03 10:13:47','071b8999-ce23-11e9-947d-226cec7cb58a.ply','2021-12-30 19:03:05','SYNCED','071b8999-ce23-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 140.1.1.1\",\"modelMatrix\":\"0.507186,-0.860924,0.0396495,0,0.861836,0.506649,-0.0233335,0,4.80862e-10,0.0460058,0.998941,0,-7.8918,-25.1397,-25.2686,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'071cb9b4-ce23-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/071cb9b4-ce23-11e9-947d-226cec7cb58a.stl','STL','PATIENT_6df72f48-6933-4986-9961-403150b72460_ACT_8066fb46-4e88-4174-a7b5-ced23d87937b_SESS_59d4c3ec-651e-4d62-b38d-23c6193830fb_TOSC_c6783949-8a9a-42ca-814a-9600e7796d81_STL_','2021-12-30 18:03:05','2019-09-03 10:05:40','071cb9b4-ce23-11e9-947d-226cec7cb58a.stl','2021-12-30 19:03:05','SYNCED','071cb9b4-ce23-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 140.1.1.1\",\"modelMatrix\":\"0.413128,-0.815308,0.405707,0,0.910673,0.369866,-0.18405,0,-5.23369e-9,0.445503,0.895281,0,-9.9541,-42.7607,-15.8659,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'071e282b-ce23-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/071e282b-ce23-11e9-947d-226cec7cb58a.stl','STL','PATIENT_6df72f48-6933-4986-9961-403150b72460_ACT_8066fb46-4e88-4174-a7b5-ced23d87937b_SESS_59d4c3ec-651e-4d62-b38d-23c6193830fb_BOSC_6c729960-d05e-4459-88a9-b2710ad7af41_STL_','2021-12-30 18:03:05','2019-09-03 10:13:47','071e282b-ce23-11e9-947d-226cec7cb58a.stl','2021-12-30 19:03:05','SYNCED','071e282b-ce23-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 140.1.1.1\",\"modelMatrix\":\"0.507186,-0.860924,0.0396495,0,0.861836,0.506649,-0.0233335,0,4.80862e-10,0.0460058,0.998941,0,-7.8918,-25.1397,-25.2686,1\",\"title\":\"MANDIBULE STL\"}'),(2,'071f8cc5-ce23-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/071f8cc5-ce23-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_6df72f48-6933-4986-9961-403150b72460_ACT_8066fb46-4e88-4174-a7b5-ced23d87937b_SESS_59d4c3ec-651e-4d62-b38d-23c6193830fb_TOSC_c6783949-8a9a-42ca-814a-9600e7796d81_SNAPS_','2021-12-30 18:03:06','2019-09-03 10:05:40','071f8cc5-ce23-11e9-947d-226cec7cb58a.png','2021-12-30 19:03:06','SYNCED','071f8cc5-ce23-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 140.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'071ff6c8-e267-441a-854b-a686e8ad198d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/071ff6c8-e267-441a-854b-a686e8ad198d.png','SNAPS','PATIENT_dde53ea4-f623-42e4-9864-d8e77d9deabe_ACT_c658c808-2655-4213-a8a0-1c34d5830ee5_SESS_ad32c977-4115-45c7-9168-d19d87c66102_TOSC_b289381b-23ec-4a96-9206-71132277e1ca_SNAPS_','2021-12-30 18:03:06','2019-11-22 08:14:15','071ff6c8-e267-441a-854b-a686e8ad198d.png','2021-12-30 19:03:06','SYNCED','071ff6c8-e267-441a-854b-a686e8ad198d',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 208.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0720db1c-ce23-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0720db1c-ce23-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_6df72f48-6933-4986-9961-403150b72460_ACT_8066fb46-4e88-4174-a7b5-ced23d87937b_SESS_59d4c3ec-651e-4d62-b38d-23c6193830fb_TOSC_c6783949-8a9a-42ca-814a-9600e7796d81_PLY_','2021-12-30 18:03:06','2019-09-03 10:05:40','0720db1c-ce23-11e9-947d-226cec7cb58a.ply','2021-12-30 19:03:06','SYNCED','0720db1c-ce23-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 140.1.1.1\",\"modelMatrix\":\"0.413128,-0.815308,0.405707,0,0.910673,0.369866,-0.18405,0,-5.23369e-9,0.445503,0.895281,0,-9.9541,-42.7607,-15.8659,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'07221d26-ce23-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07221d26-ce23-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_6df72f48-6933-4986-9961-403150b72460_ACT_8066fb46-4e88-4174-a7b5-ced23d87937b_SESS_59d4c3ec-651e-4d62-b38d-23c6193830fb_BOSC_6c729960-d05e-4459-88a9-b2710ad7af41_SNAPS_','2021-12-30 18:03:06','2019-09-03 10:13:47','07221d26-ce23-11e9-947d-226cec7cb58a.png','2021-12-30 19:03:06','SYNCED','07221d26-ce23-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 140.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0723bea1-afcc-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0723bea1-afcc-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_b336036e-8165-40a2-ad14-ad02e4f39442_SESS_dae5cfb6-da12-4d11-a6d5-8fccb3f422e8_BOSC_9a21e55b-ef8a-4e8a-821b-47835ca1b041_PLY_','2020-12-08 17:25:51','2020-06-16 14:22:02','0723bea1-afcc-11ea-947d-226cec7cb58a.ply','2020-12-08 18:25:51','SYNCED','0723bea1-afcc-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.45.1.1\",\"modelMatrix\":\"-0.930409,0.347186,-0.117475,0,-0.366522,-0.881325,0.298208,0,7.75683e-9,0.320513,0.947244,0,-6.12106,15.9318,-17.978,1\",\"title\":\"Mandibule PLY\"}'),(2,'0723ff37-9197-4832-a5bd-0249f71008a8','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0723ff37-9197-4832-a5bd-0249f71008a8.ply','PLY','PATIENT_924bf1a2-20af-4047-90c0-8d8b8a5fceb6_ACT_d32cbe7d-f29f-48b8-8656-3065d72e68bb_SESS_f6828a70-e523-4c66-97ef-ce1749bd1c5a_BOSC_f40350c1-69dd-4af5-b5d7-9659a15cdfe3_PLY_','2021-01-06 11:02:05','2019-12-12 14:52:47','0723ff37-9197-4832-a5bd-0249f71008a8.ply','2021-01-06 12:02:05','SYNCED','0723ff37-9197-4832-a5bd-0249f71008a8',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 232.15.1.1\",\"modelMatrix\":\"-0.929789,0.36215,-0.0658759,0,-0.368093,-0.914778,0.1664,0,-1.5773e-9,0.178965,0.983855,0,-10.7689,18.4021,-20.0851,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'072658c1-afcc-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/072658c1-afcc-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_8bcf85e1-fc5f-4380-8edf-2af92062ab93_ACT_b336036e-8165-40a2-ad14-ad02e4f39442_SESS_dae5cfb6-da12-4d11-a6d5-8fccb3f422e8_TOSC_d4456386-8148-4cde-b08b-a50fd192b97f_PLY_','2020-12-08 17:25:51','2020-06-16 14:19:13','072658c1-afcc-11ea-947d-226cec7cb58a.ply','2020-12-08 18:25:51','SYNCED','072658c1-afcc-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.45.1.1\",\"modelMatrix\":\"0.615035,-0.759864,0.210566,0,0.7885,0.592699,-0.164243,0,1.1844e-8,0.267046,0.963684,0,4.77243,-33.0107,-18.0758,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0727edbf-cae2-43d1-9f65-e73d902e0dae','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0727edbf-cae2-43d1-9f65-e73d902e0dae.ply','PLY','PATIENT_c30dd79a-8ef2-482c-8fe6-9c33a39cfff2_ACT_c1ee43c4-7708-4c9f-950b-7e9bfa7afaf3_SESS_ab31f180-9314-4a7c-9461-50ac67b8d619_BOSC_6631cb53-f53e-464d-b96f-d14530a4f28c_PLY_','2021-12-30 18:03:06','2019-10-07 14:01:58','0727edbf-cae2-43d1-9f65-e73d902e0dae.ply','2021-12-30 19:03:06','SYNCED','0727edbf-cae2-43d1-9f65-e73d902e0dae',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 179.1.1.1\",\"modelMatrix\":\"-0.630789,0.766308,-0.121975,0,-0.775954,-0.622947,0.0991559,0,-3.01434e-9,0.157193,0.987568,0,3.97328,20.3738,-21.0195,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0728a220-afcc-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0728a220-afcc-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_b336036e-8165-40a2-ad14-ad02e4f39442_SESS_dae5cfb6-da12-4d11-a6d5-8fccb3f422e8_BOSC_9a21e55b-ef8a-4e8a-821b-47835ca1b041_SNAPS_','2020-12-08 17:25:52','2020-06-16 14:22:02','0728a220-afcc-11ea-947d-226cec7cb58a.png','2020-12-08 18:25:52','SYNCED','0728a220-afcc-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.45.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'072aa625-afcc-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/072aa625-afcc-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_8bcf85e1-fc5f-4380-8edf-2af92062ab93_ACT_b336036e-8165-40a2-ad14-ad02e4f39442_SESS_dae5cfb6-da12-4d11-a6d5-8fccb3f422e8_TOSC_d4456386-8148-4cde-b08b-a50fd192b97f_SNAPS_','2020-12-08 17:25:52','2020-06-16 14:19:13','072aa625-afcc-11ea-947d-226cec7cb58a.png','2020-12-08 18:25:52','SYNCED','072aa625-afcc-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.45.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0739c22e-f506-43b0-9847-919adf92ea99','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0739c22e-f506-43b0-9847-919adf92ea99.stl','STL','PATIENT_7bac4a06-9561-47ca-9cb2-d9c7ebf15731_ACT_4e02d446-89ce-4e03-9ebc-cd89a36784ec_SESS_bc7540fa-3b0e-4c71-bf91-69247ca18910_TOSC_00dd3495-ff4f-47d9-afd9-114212d9f7f0_STL_','2021-06-07 11:39:06','2019-12-11 16:00:21','0739c22e-f506-43b0-9847-919adf92ea99.stl','2021-06-07 13:39:06','SYNCED','0739c22e-f506-43b0-9847-919adf92ea99',0,'2021-06-07 13:39:06','','','{\"displayTitle\":\"MAXILLAIRE 232.2.1.1.1\",\"modelMatrix\":\"0.740543,-0.632643,0.226625,0,0.672009,0.697162,-0.249737,0,-1.02448e-9,0.337235,0.941421,0,12.5185,-30.8019,-20.7293,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'07659b93-1e8f-41d6-b4f6-2f9cba2d4b5a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07659b93-1e8f-41d6-b4f6-2f9cba2d4b5a.png','SNAPS','PATIENT_978991c3-73ec-4272-81bb-35e9fa062036_ACT_f94467b8-6cae-452e-880a-7e1c05d160ee_SESS_f0f0a818-08c6-47f4-9ea1-3e8b8fc3b874_BOSC_4586ec2b-739b-4247-a727-a063f25c2074_SNAPS_','2021-12-30 18:03:07','2019-09-02 10:26:52','07659b93-1e8f-41d6-b4f6-2f9cba2d4b5a.png','2021-12-30 19:03:07','SYNCED','07659b93-1e8f-41d6-b4f6-2f9cba2d4b5a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 135.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'07678823-bee8-4826-8909-258f5307302d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07678823-bee8-4826-8909-258f5307302d.stl','STL','PATIENT_d81819be-bc30-4092-b5e9-498e0cbb7c78_ACT_e2efb8df-4ec9-4c9d-98df-c9d1978d79fb_SESS_1d7bc7d7-a77e-46e6-aaa2-768afa5219c9_BOSC_ed4417fc-f174-43ac-be0d-27c541079eb3_STL_','2021-12-30 18:03:07','2019-07-15 16:35:44','07678823-bee8-4826-8909-258f5307302d.stl','2021-12-30 19:03:07','SYNCED','07678823-bee8-4826-8909-258f5307302d',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 71.1.1.1\",\"modelMatrix\":\"0.790377,0.608579,-0.0702491,0,-0.61262,0.785164,-0.0906326,0,-4.49984e-9,0.11467,0.993404,0,24.9918,-1.2555,-21.4061,1\",\"title\":\"MANDIBULE STL\"}'),(2,'077564fb-0ca5-4cd7-8b95-1271de79f701','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/077564fb-0ca5-4cd7-8b95-1271de79f701.png','SNAPS','PATIENT_bc50bff3-dacb-4f7a-a7c8-b971782c6d1d_ACT_be5de36f-b43d-47f3-b178-801c7822bb7d_SESS_df767eeb-30cd-456e-91c0-aa5269ac29d4_TOSC_8e88295e-926b-4397-8ead-e6454a4c2c67_SNAPS_','2021-08-05 07:30:45','2019-11-27 12:13:25','077564fb-0ca5-4cd7-8b95-1271de79f701.png','2021-08-05 09:30:45','SYNCED','077564fb-0ca5-4cd7-8b95-1271de79f701',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 212.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0782b215-3eb4-4339-aba7-47e30da87988','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0782b215-3eb4-4339-aba7-47e30da87988.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_6f9b06e7-95a1-4b2c-974a-63ad638a404a_SESS_00bc2be9-26ee-40d0-b135-3cea0ac87ae2_TOSC_495620a4-e965-44a8-a639-2e2dd9d954b6_PLY_','2020-12-16 10:51:43','2020-05-22 14:10:19','0782b215-3eb4-4339-aba7-47e30da87988.ply','2020-12-16 11:51:43','SYNCED','0782b215-3eb4-4339-aba7-47e30da87988',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 216.1.9.1.1\",\"modelMatrix\":\"0.15418,-0.953114,0.260387,0,0.988043,0.148729,-0.0406322,0,2.59738e-9,0.263538,0.964649,0,-18.7177,-25.5279,-13.8068,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0783951f-2337-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0783951f-2337-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_aff4eaff-030a-4db3-bb48-829132017f6c_ACT_2ff44845-9186-4589-bd19-c7c20e898d46_SESS_0df16f53-eb00-4ebd-9c14-fe6fa158742f_TOSC_baa7f31c-3db8-49ce-8afe-d9403ad64066_PLY_','2020-12-23 09:07:35','2019-12-20 15:42:18','0783951f-2337-11ea-947d-226cec7cb58a.ply','2020-12-23 10:07:35','SYNCED','0783951f-2337-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"modelMatrix\":\"0.707269,-0.66098,0.25075,0,0.706944,0.661284,-0.250865,0,-3.49905e-9,0.354695,0.934982,0,2.10528,-31.4426,-12.8581,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'07856f3d-2337-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07856f3d-2337-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_aff4eaff-030a-4db3-bb48-829132017f6c_ACT_2ff44845-9186-4589-bd19-c7c20e898d46_SESS_0df16f53-eb00-4ebd-9c14-fe6fa158742f_TOSC_baa7f31c-3db8-49ce-8afe-d9403ad64066_SNAPS_','2020-12-23 09:07:35','2019-12-20 15:42:18','07856f3d-2337-11ea-947d-226cec7cb58a.png','2020-12-23 10:07:35','SYNCED','07856f3d-2337-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0793262e-99c0-471d-a612-875db30dcc74','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0793262e-99c0-471d-a612-875db30dcc74.png','SNAPS','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_1b04f888-3de3-4ebf-ab9c-e34753a7524d_SESS_7e214c47-5f56-495a-9e3e-c7bd35d49b80_BOSC_d5baa18b-a4d3-4edf-8b22-58c2d6f3e1cd_SNAPS_','2020-12-23 09:07:36','2020-01-02 15:50:24','0793262e-99c0-471d-a612-875db30dcc74.png','2020-12-23 10:07:36','SYNCED','0793262e-99c0-471d-a612-875db30dcc74',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'07a5f4d8-f064-424f-a9bf-ec562f83cbd2','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07a5f4d8-f064-424f-a9bf-ec562f83cbd2.png','SNAPS','PATIENT_be48faa5-408d-4557-9d5f-60c67821aff4_ACT_9f77cb0d-bdf4-4451-a561-df188dcfd90b_SESS_ae5d102d-69f4-4a1f-ad3d-ce4a77600f7b_TOSC_aed6d770-14a0-4a08-b1dc-657cd2564cc8_SNAPS_','2020-12-16 10:51:44','2020-02-05 11:31:58','07a5f4d8-f064-424f-a9bf-ec562f83cbd2.png','2020-12-16 11:51:44','SYNCED','07a5f4d8-f064-424f-a9bf-ec562f83cbd2',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'07a64a34-992c-4c47-a96c-7584fa9656f8','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07a64a34-992c-4c47-a96c-7584fa9656f8.stl','STL','PATIENT_fcf8c111-84a1-4f17-859c-ea2ad21d373b_ACT_d27c23bb-fa1e-4cd8-bacc-e2b65114a20e_SESS_844480c5-a8a8-4eb3-a014-e1424d66a1ca_TOSC_6ee11505-19ec-4ef6-8ea1-4eca73d57bad_STL_','2021-12-30 18:03:08','2019-11-18 11:53:39','07a64a34-992c-4c47-a96c-7584fa9656f8.stl','2021-12-30 19:03:08','SYNCED','07a64a34-992c-4c47-a96c-7584fa9656f8',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 168.1.1.1.1\",\"modelMatrix\":\"0.416599,-0.850788,0.320321,0,0.90909,0.389881,-0.14679,0,-7.49928e-9,0.352353,0.935867,0,-8.21069,-35.5188,-22.7189,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'07ba4b9d-8de6-4eeb-bf9d-c5e0d3dbb45e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07ba4b9d-8de6-4eeb-bf9d-c5e0d3dbb45e.ply','PLY','PATIENT_fcf8c111-84a1-4f17-859c-ea2ad21d373b_ACT_d27c23bb-fa1e-4cd8-bacc-e2b65114a20e_SESS_844480c5-a8a8-4eb3-a014-e1424d66a1ca_BOSC_ee5e8d11-7fd2-4e32-9bcd-156edaa7ec82_PLY_','2021-12-30 18:03:08','2019-11-18 16:56:47','07ba4b9d-8de6-4eeb-bf9d-c5e0d3dbb45e.ply','2021-12-30 19:03:08','SYNCED','07ba4b9d-8de6-4eeb-bf9d-c5e0d3dbb45e',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 168.1.1.1.1\",\"modelMatrix\":\"-0.971915,0.222709,-0.0760346,0,-0.235331,-0.919788,0.314022,0,-6.61285e-9,0.323096,0.946366,0,-2.26085,16.2906,-29.2499,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'07ba9e9b-7d23-4d41-9d64-ff7b638fab28','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07ba9e9b-7d23-4d41-9d64-ff7b638fab28.png','SNAPS','PATIENT_2807a523-f049-4cb4-b87c-145d1c34703d_ACT_c814024c-0941-4b02-94bd-294d8fdb06f3_SESS_c5963919-b6e6-43fd-af82-eed8f169475a_TOSC_788c4f2e-8c8f-48d6-ba56-ec592372f47b_SNAPS_','2020-12-16 10:51:45','2020-02-21 10:33:47','07ba9e9b-7d23-4d41-9d64-ff7b638fab28.png','2020-12-16 11:51:45','SYNCED','07ba9e9b-7d23-4d41-9d64-ff7b638fab28',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'07c0251a-b50d-4923-8ec7-171e918b3e4c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07c0251a-b50d-4923-8ec7-171e918b3e4c.ply','PLY','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_TOSC_86e65ef7-65a9-4ebf-9283-0d4408367194_PLY_','2021-12-30 18:03:08','2019-11-15 10:55:18','07c0251a-b50d-4923-8ec7-171e918b3e4c.ply','2021-12-30 19:03:08','SYNCED','07c0251a-b50d-4923-8ec7-171e918b3e4c',0,NULL,'','','{\"displayTitle\":\"Mascella 0\",\"modelMatrix\":\"0.475206,-0.843721,0.249629,0,0.879875,0.45568,-0.134821,0,-8.41607e-10,0.28371,0.95891,0,-4.59861,-35.7904,-16.6972,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'07c4d5e6-593a-4f3a-b073-de15c5c8d1a5','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07c4d5e6-593a-4f3a-b073-de15c5c8d1a5.png','SNAPS','PATIENT_95e4ff6d-7100-48d0-935f-08c3371d3f80_ACT_37b3ec2f-500c-49ed-8c3c-a7e4c917cdd2_SESS_d8048054-32d9-4927-94dd-09a8174b6fb8_BOSC_b0807140-904c-496e-a01d-b1a34d3dcae2_SNAPS_','2020-12-16 11:05:54','2020-01-29 10:11:02','07c4d5e6-593a-4f3a-b073-de15c5c8d1a5.png','2020-12-16 12:05:54','SYNCED','07c4d5e6-593a-4f3a-b073-de15c5c8d1a5',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 96.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'07c9e130-fadc-4135-a4dd-9f7e1be03a42','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07c9e130-fadc-4135-a4dd-9f7e1be03a42.png','SNAPS','PATIENT_6592423c-c895-4f90-ae97-d29a34961d34_ACT_6628cbc8-0118-491e-93d0-25211a465bc4_SESS_6e23570d-ebd1-4a63-9ffe-aa47019113cd_BOSC_d05e0ee7-1b6e-4b5f-b812-2f7e5503a36c_SNAPS_','2022-03-04 13:40:22','2019-07-09 13:19:01','07c9e130-fadc-4135-a4dd-9f7e1be03a42.png','2022-03-04 14:40:22','SYNCED','07c9e130-fadc-4135-a4dd-9f7e1be03a42',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 11.2.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'07d6b2c6-e1b5-43d1-86e9-71f6ba535066','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07d6b2c6-e1b5-43d1-86e9-71f6ba535066.png','SNAPS','PATIENT_819e0ef8-8a2d-4056-87eb-b0140b49b138_ACT_dcb00f7d-2ebb-4a3e-b55a-0a5d6542a290_SESS_aef83cd5-09b8-4a48-899c-22a2ab0c2d9c_TOSC_07ee40f7-97e9-4d9a-8fe2-d2c6e4b8f2d8_SNAPS_','2020-12-23 09:07:38','2019-12-20 15:48:39','07d6b2c6-e1b5-43d1-86e9-71f6ba535066.png','2020-12-23 10:07:38','SYNCED','07d6b2c6-e1b5-43d1-86e9-71f6ba535066',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'07db12d6-169d-4c33-82b7-510c5efee44e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07db12d6-169d-4c33-82b7-510c5efee44e.png','SNAPS','PATIENT_42f1168d-7e4d-4574-9695-1bb3c7af4f61_ACT_5f10eca4-62d0-44ae-96ec-54c8413298eb_SESS_1e0d7fa4-8337-4681-a87b-a30c32238dc0_BOSC_7bb27809-7253-4bf4-9c66-0ad2ff3bed50_SNAPS_','2021-12-30 18:03:08','2019-07-16 16:55:45','07db12d6-169d-4c33-82b7-510c5efee44e.png','2021-12-30 19:03:08','SYNCED','07db12d6-169d-4c33-82b7-510c5efee44e',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 82.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'07e48eec-70fc-4a59-baaa-d7fa7daaeaf0','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07e48eec-70fc-4a59-baaa-d7fa7daaeaf0.stl','STL','PATIENT_dde53ea4-f623-42e4-9864-d8e77d9deabe_ACT_c658c808-2655-4213-a8a0-1c34d5830ee5_SESS_ad32c977-4115-45c7-9168-d19d87c66102_TOSC_f15a7ce9-78df-4165-9e1c-12667b7323cd_STL_','2021-12-30 18:03:09','2019-11-22 08:47:53','07e48eec-70fc-4a59-baaa-d7fa7daaeaf0.stl','2021-12-30 19:03:09','SYNCED','07e48eec-70fc-4a59-baaa-d7fa7daaeaf0',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 208.1.1.1\",\"modelMatrix\":\"0.743035,-0.627516,0.232643,0,0.669253,0.696697,-0.258291,0,3.81443e-9,0.347616,0.937637,0,7.40466,-40.2943,-15.8547,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'07e9e164-38f9-43c7-b154-5224032b853d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07e9e164-38f9-43c7-b154-5224032b853d.png','SNAPS','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_aceb6871-e01a-4e37-9c9f-33adfe6e0268_SESS_1ad73395-8cbd-4dcc-9a8e-cf3241e4e156_BOSC_0b40cf8a-581b-4ca9-90a5-cd0340988c9a_SNAPS_','2021-08-05 07:30:47','2019-11-29 09:24:56','07e9e164-38f9-43c7-b154-5224032b853d.png','2021-08-05 09:30:47','SYNCED','07e9e164-38f9-43c7-b154-5224032b853d',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'07f0a94c-f1e5-4235-a547-38ac0a1b3e4c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07f0a94c-f1e5-4235-a547-38ac0a1b3e4c.png','SNAPS','PATIENT_961e5084-1756-4d47-8e90-a6b717094efe_ACT_e9340f44-a13c-41df-99f2-1472c63e5f38_SESS_6cd9c521-7e64-409c-93d7-2039dee96ec0_BOSC_4f8722e2-7d5c-4b81-b12b-385283da44bd_SNAPS_','2020-12-16 11:05:55','2020-01-21 13:54:56','07f0a94c-f1e5-4235-a547-38ac0a1b3e4c.png','2020-12-16 12:05:55','SYNCED','07f0a94c-f1e5-4235-a547-38ac0a1b3e4c',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 199.1.3.1.2\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'07f191b5-6320-49aa-b7f6-c05327b7b025','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07f191b5-6320-49aa-b7f6-c05327b7b025.ply','PLY','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_BOSC_a9a62eef-7474-4307-b60b-7a50c1cea0c8_PLY_','2021-12-30 18:03:09','2019-11-15 14:00:22','07f191b5-6320-49aa-b7f6-c05327b7b025.ply','2021-12-30 19:03:09','SYNCED','07f191b5-6320-49aa-b7f6-c05327b7b025',0,NULL,'','','{\"displayTitle\":\"Mandibola 0\",\"modelMatrix\":\"-0.994025,-0.105788,0.0268761,0,0.109149,-0.96342,0.244763,0,4.14586e-10,0.246234,0.96921,0,-15.6582,8.51879,-29.1663,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'07f92f93-041a-4717-9ddb-520cfdbd2905','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07f92f93-041a-4717-9ddb-520cfdbd2905.ply','PLY','PATIENT_b3c8ff23-e845-45b0-a992-48c610e95f19_ACT_cc20c13e-b334-481e-a606-cd0de87d95ae_SESS_8f0b3737-3a1c-41c8-8963-7fe7b125bd86_BOSC_41805ccf-577f-4a83-b554-3f7a6cb844b7_PLY_','2021-12-30 18:03:09','2019-09-23 12:32:41','07f92f93-041a-4717-9ddb-520cfdbd2905.ply','2021-12-30 19:03:09','SYNCED','07f92f93-041a-4717-9ddb-520cfdbd2905',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 161.6.1.1\",\"modelMatrix\":\"0.271411,-0.961353,0.0462216,0,0.962463,0.271098,-0.0130343,0,9.55236e-13,0.0480242,0.998846,0,-10.3082,-25.8097,-17.6044,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'07fc2983-e5e7-444b-a6a4-14cadbd8f286','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07fc2983-e5e7-444b-a6a4-14cadbd8f286.png','SNAPS','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_bbd6c708-e7be-443c-93ab-eb1285e51fe4_SESS_8966eee1-d22b-4e86-835c-607819f15da6_TOSC_e923234a-811e-44be-8079-61870828163a_SNAPS_','2020-12-16 11:05:56','2020-01-21 11:10:27','07fc2983-e5e7-444b-a6a4-14cadbd8f286.png','2020-12-16 12:05:56','SYNCED','07fc2983-e5e7-444b-a6a4-14cadbd8f286',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0805d80c-adf0-4408-bc7e-09a6929000fa','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0805d80c-adf0-4408-bc7e-09a6929000fa.stl','STL','PATIENT_0ef241a1-4320-47aa-87f1-f774661cb469_ACT_b8784c02-311f-47ea-925f-610d5e3dea61_SESS_0c914052-c9c6-4d08-92b7-188e991cbe37_BOSC_b9140416-81ca-4a60-8fcb-c6e3b103a0a1_STL_','2021-12-30 18:03:10','2019-07-15 11:01:06','0805d80c-adf0-4408-bc7e-09a6929000fa.stl','2021-12-30 19:03:10','SYNCED','0805d80c-adf0-4408-bc7e-09a6929000fa',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 62.1.1.1\",\"modelMatrix\":\"-0.764791,0.641119,-0.0637199,0,-0.644278,-0.761042,0.0756389,0,3.48635e-10,0.0989013,0.995097,0,-1.11618,30.2034,-25.3022,1\",\"title\":\"MANDIBULE STL\"}'),(2,'080d2eb7-4344-495b-b276-00d44e5bc5b1','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/080d2eb7-4344-495b-b276-00d44e5bc5b1.png','SNAPS','PATIENT_1726cd89-f2a1-4528-bf69-d3a18a5aaa71_ACT_afbd2d3d-fdc4-4c89-b445-f65a75119d97_SESS_71887ae7-34c5-4a58-9942-d643739a52f4_TOSC_4d480282-a30b-422f-b05b-c7b46744b349_SNAPS_','2020-12-16 10:51:48','2020-02-05 13:27:27','080d2eb7-4344-495b-b276-00d44e5bc5b1.png','2020-12-16 11:51:48','SYNCED','080d2eb7-4344-495b-b276-00d44e5bc5b1',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0813e6d6-d3e4-4ea9-8471-d48733eff1c2','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0813e6d6-d3e4-4ea9-8471-d48733eff1c2.png','SNAPS','PATIENT_639098f4-47e7-4689-ae2d-8e309459f01f_ACT_503c189c-eae7-406b-ad30-d7cf8d8f3382_SESS_fd734a44-ec1f-4f1c-a4fb-fed2c88b1e8c_BOSC_e3b9e763-d745-4ece-a1ba-66350c8dcfe5_SNAPS_','2022-03-04 13:40:22','2019-07-10 09:31:49','0813e6d6-d3e4-4ea9-8471-d48733eff1c2.png','2022-03-04 14:40:22','SYNCED','0813e6d6-d3e4-4ea9-8471-d48733eff1c2',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 18.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'081b8c9d-b71c-4a7d-8b9d-7b98f8e0c45c','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/081b8c9d-b71c-4a7d-8b9d-7b98f8e0c45c.png','SNAPS','PATIENT_639098f4-47e7-4689-ae2d-8e309459f01f_ACT_503c189c-eae7-406b-ad30-d7cf8d8f3382_SESS_fd734a44-ec1f-4f1c-a4fb-fed2c88b1e8c_TOSC_e5e94b7e-50b9-4aea-ae2b-e4d7621d5f13_SNAPS_','2022-03-04 13:40:23','2019-07-10 09:27:27','081b8c9d-b71c-4a7d-8b9d-7b98f8e0c45c.png','2022-03-04 14:40:23','SYNCED','081b8c9d-b71c-4a7d-8b9d-7b98f8e0c45c',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 18.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'084cc778-61ef-43e8-8fe9-5ae1e7b6891c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/084cc778-61ef-43e8-8fe9-5ae1e7b6891c.png','SNAPS','PATIENT_492648bb-d190-48e7-ae8c-6b3a3748a733_ACT_2d69d1ac-c55f-45a6-a3b9-750eacd6c2b1_SESS_7bfad63b-d134-4619-9af5-a68f5c5d02e5_TOSC_42514db7-7238-4ec7-b8de-c3af1f29968a_SNAPS_','2020-12-23 09:07:42','2019-12-31 13:59:00','084cc778-61ef-43e8-8fe9-5ae1e7b6891c.png','2020-12-23 10:07:42','SYNCED','084cc778-61ef-43e8-8fe9-5ae1e7b6891c',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'084e11c2-86b8-4d8a-a2cc-7002fd7ced13','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/084e11c2-86b8-4d8a-a2cc-7002fd7ced13.stl','STL','PATIENT_74e69d84-8a8c-4dfb-8447-bb46b9f0b090_ACT_283f3801-2a5b-4acd-a56e-8ccd852b3058_SESS_cf940c68-5a78-423f-a99d-4cd17151306b_BOSC_8c74792e-c70d-4eb4-bcc7-0d60f21bb9c5_STL_','2022-02-01 11:47:23','2019-07-11 16:53:05','084e11c2-86b8-4d8a-a2cc-7002fd7ced13.stl','2022-02-01 12:47:23','SYNCED','084e11c2-86b8-4d8a-a2cc-7002fd7ced13',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 45.1.1.1\",\"modelMatrix\":\"-0.977292,0.204453,-0.0556692,0,-0.211897,-0.942962,0.256753,0,-2.55443e-9,0.262718,0.964873,0,-12.1169,19.1399,-22.4071,1\",\"title\":\"MANDIBULE STL\"}'),(2,'088336f4-74ed-4a45-9449-0310a81fe5be','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/088336f4-74ed-4a45-9449-0310a81fe5be.ply','PLY','PATIENT_95405121-f140-4116-92ca-cae7d44f9bba_ACT_3d2ec6af-c315-4775-9d50-cf24a2a45658_SESS_faa85dca-33e7-48ff-9dc3-1ff7d89b3feb_BOSC_27f5e407-f1e1-4db7-84b3-b7d173106c32_PLY_','2022-02-01 11:47:23','2019-07-16 08:44:55','088336f4-74ed-4a45-9449-0310a81fe5be.ply','2022-02-01 12:47:23','SYNCED','088336f4-74ed-4a45-9449-0310a81fe5be',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 73.1.1.1\",\"modelMatrix\":\"-0.972787,-0.226138,0.0504687,0,0.231701,-0.94943,0.211891,0,1.66262e-9,0.217818,0.975989,0,-25.3697,10.0166,-23.5228,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0886433a-7f49-40d9-a00d-2af61e20ca9a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0886433a-7f49-40d9-a00d-2af61e20ca9a.stl','STL','PATIENT_ff96c5bd-a3bf-4f05-92e4-56f76b83b454_ACT_d737feed-a81f-42f0-a536-f47f5a256ae6_SESS_4ac56d86-9375-40ed-956b-affb4721bd49_TOSC_c703c340-c05c-4271-a8ef-688293b8a817_STL_','2021-12-30 18:03:11','2019-11-18 11:46:57','0886433a-7f49-40d9-a00d-2af61e20ca9a.stl','2021-12-30 19:03:11','SYNCED','0886433a-7f49-40d9-a00d-2af61e20ca9a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 203.1.1.1\",\"modelMatrix\":\"0.689837,-0.645555,0.327696,0,0.723965,0.615123,-0.312248,0,-5.68395e-9,0.45264,0.891693,0,6.49575,-35.8846,-20.1313,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'08af026d-f438-4397-ab86-35e189222735','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/08af026d-f438-4397-ab86-35e189222735.ply','PLY','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_8d653271-32c7-44b9-8871-ff413f597bf4_SESS_73a88555-3377-4c81-b14e-4c5adf325290_BOSC_3cbc8dfc-4fb7-49d2-9ba6-629967fdb1d9_PLY_','2020-12-23 09:07:43','2020-01-03 10:41:35','08af026d-f438-4397-ab86-35e189222735.ply','2020-12-23 10:07:43','SYNCED','08af026d-f438-4397-ab86-35e189222735',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"modelMatrix\":\"-0.969936,0.233808,-0.0675202,0,-0.243362,-0.931857,0.269106,0,4.03347e-9,0.277448,0.960741,0,-12.5278,17.1631,-16.7395,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'08b08c83-1deb-45de-bccb-220770199f99','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/08b08c83-1deb-45de-bccb-220770199f99.ply','PLY','PATIENT_85f75944-a935-4d81-b144-df694a135914_ACT_dfa89c7a-56d5-41f7-a023-17e952b5b982_SESS_d7124024-9d62-42cf-9ec0-f190cdbd0557_TOSC_092a4e45-f5df-44d6-9079-20dc1ad9493d_PLY_','2021-12-30 18:03:12','2019-10-15 11:09:08','08b08c83-1deb-45de-bccb-220770199f99.ply','2021-12-30 19:03:12','SYNCED','08b08c83-1deb-45de-bccb-220770199f99',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 188.1.1.1\",\"modelMatrix\":\"0.765088,-0.598485,0.237604,0,0.643926,0.711097,-0.282312,0,-9.24433e-9,0.368993,0.929432,0,9.6311,-27.6002,-27.1971,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'08ebe2e8-bc7b-445e-892c-13c4c77980e6','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/08ebe2e8-bc7b-445e-892c-13c4c77980e6.ply','PLY','PATIENT_5f861654-dd88-4404-b6ce-ab61dd80d65a_ACT_283ffdd7-9872-400e-8864-ceb7a283e06c_SESS_053ae2bd-f330-4080-9666-9491f24cbd51_BOSC_f0fbcaab-7c1c-4425-8080-75a125de3ce0_PLY_','2022-02-01 11:47:23','2019-09-03 11:47:55','08ebe2e8-bc7b-445e-892c-13c4c77980e6.ply','2022-02-01 12:47:23','SYNCED','08ebe2e8-bc7b-445e-892c-13c4c77980e6',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 142.1.1.1\",\"modelMatrix\":\"0.396607,-0.901233,0.174591,0,0.917989,0.389368,-0.07543,0,-2.63711e-10,0.190188,0.981748,0,-7.58146,-29.449,-25.838,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'09104522-10f7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09104522-10f7-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_7da1c98d-8103-4b55-a8f3-84a1ce2c951b_ACT_0559baca-076e-4d10-b98d-839b7104e5e1_SESS_4a20a374-7067-4593-a215-f2557a95fac7_TOSC_09eed85a-5f33-4efb-b954-ac02193fa2c0_SNAPS_','2021-08-05 07:30:48','2019-11-27 10:14:43','09104522-10f7-11ea-947d-226cec7cb58a.png','2021-08-05 09:30:48','SYNCED','09104522-10f7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 211.3.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0911d952-10f7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0911d952-10f7-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_7da1c98d-8103-4b55-a8f3-84a1ce2c951b_ACT_0559baca-076e-4d10-b98d-839b7104e5e1_SESS_4a20a374-7067-4593-a215-f2557a95fac7_TOSC_09eed85a-5f33-4efb-b954-ac02193fa2c0_PLY_','2021-08-05 07:30:48','2019-11-27 10:14:43','0911d952-10f7-11ea-947d-226cec7cb58a.ply','2021-08-05 09:30:48','SYNCED','0911d952-10f7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 211.3.1.1\",\"modelMatrix\":\"0.737304,-0.660437,0.142149,0,0.675561,0.720797,-0.15514,0,-4.95262e-9,0.210416,0.977612,0,7.08308,-31.9606,-20.2196,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'091321e1-10f7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/091321e1-10f7-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_7da1c98d-8103-4b55-a8f3-84a1ce2c951b_ACT_0559baca-076e-4d10-b98d-839b7104e5e1_SESS_4a20a374-7067-4593-a215-f2557a95fac7_BOSC_0b356503-8997-4830-a758-349a99a0de63_PLY_','2021-08-05 07:30:48','2019-11-27 10:17:59','091321e1-10f7-11ea-947d-226cec7cb58a.ply','2021-08-05 09:30:48','SYNCED','091321e1-10f7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 211.3.1.1\",\"modelMatrix\":\"-0.923899,0.369196,-0.100526,0,-0.382638,-0.891444,0.242726,0,9.50099e-10,0.262719,0.964872,0,-15.1679,21.9347,-16.8309,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'09148312-10f7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09148312-10f7-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_7da1c98d-8103-4b55-a8f3-84a1ce2c951b_ACT_0559baca-076e-4d10-b98d-839b7104e5e1_SESS_4a20a374-7067-4593-a215-f2557a95fac7_BOSC_0b356503-8997-4830-a758-349a99a0de63_SNAPS_','2021-08-05 07:30:48','2019-11-27 10:17:59','09148312-10f7-11ea-947d-226cec7cb58a.png','2021-08-05 09:30:48','SYNCED','09148312-10f7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 211.3.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0915c26e-10f7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0915c26e-10f7-11ea-947d-226cec7cb58a.stl','STL','PATIENT_7da1c98d-8103-4b55-a8f3-84a1ce2c951b_ACT_0559baca-076e-4d10-b98d-839b7104e5e1_SESS_4a20a374-7067-4593-a215-f2557a95fac7_TOSC_09eed85a-5f33-4efb-b954-ac02193fa2c0_STL_','2021-08-05 07:30:48','2019-11-27 10:14:43','0915c26e-10f7-11ea-947d-226cec7cb58a.stl','2021-08-05 09:30:48','SYNCED','0915c26e-10f7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 211.3.1.1\",\"modelMatrix\":\"0.737304,-0.660437,0.142149,0,0.675561,0.720797,-0.15514,0,-4.95262e-9,0.210416,0.977612,0,7.08308,-31.9606,-20.2196,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'09171781-10f7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09171781-10f7-11ea-947d-226cec7cb58a.stl','STL','PATIENT_7da1c98d-8103-4b55-a8f3-84a1ce2c951b_ACT_0559baca-076e-4d10-b98d-839b7104e5e1_SESS_4a20a374-7067-4593-a215-f2557a95fac7_BOSC_0b356503-8997-4830-a758-349a99a0de63_STL_','2021-08-05 07:30:49','2019-11-27 10:17:59','09171781-10f7-11ea-947d-226cec7cb58a.stl','2021-08-05 09:30:49','SYNCED','09171781-10f7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 211.3.1.1\",\"modelMatrix\":\"-0.923899,0.369196,-0.100526,0,-0.382638,-0.891444,0.242726,0,9.50099e-10,0.262719,0.964872,0,-15.1679,21.9347,-16.8309,1\",\"title\":\"MANDIBULE STL\"}'),(2,'091a751e-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/091a751e-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_7e31dc23-e958-4dce-a295-bc79e0259c7b_SNAPS_','2020-12-16 11:05:59','2020-01-24 14:15:19','091a751e-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:05:59','SYNCED','091a751e-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.16\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'091c8201-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/091c8201-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_cf7510f6-bfb5-4e90-af14-79e2643fc837_SNAPS_','2020-12-16 11:05:59','2020-01-24 13:50:45','091c8201-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:05:59','SYNCED','091c8201-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.8\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'091e3a55-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/091e3a55-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_a652bfa0-2f48-4a5c-baee-0b1742d0f575_SNAPS_','2020-12-16 11:06:00','2020-01-24 13:33:07','091e3a55-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:00','SYNCED','091e3a55-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.2\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'091ff0a2-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/091ff0a2-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_2bed089e-68c3-431b-99b5-222a86530979_PLY_','2020-12-16 11:06:00','2020-01-24 14:18:24','091ff0a2-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:00','SYNCED','091ff0a2-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.17\",\"modelMatrix\":\"-0.908515,0.388306,-0.154331,0,-0.417851,-0.844276,0.335556,0,-1.75121e-8,0.369345,0.929292,0,-7.51411,22.2665,-17.6662,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'09219e50-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09219e50-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_e44fbbcb-7ace-4649-8a05-a692408f5313_SNAPS_','2020-12-16 11:06:00','2020-01-24 12:28:27','09219e50-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:00','SYNCED','09219e50-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.10\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'092357d4-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/092357d4-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_8f0d3062-1121-4e4e-b9ed-921f4dc3427f_PLY_','2020-12-16 11:06:00','2020-01-24 13:44:39','092357d4-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:00','SYNCED','092357d4-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.6\",\"modelMatrix\":\"-0.945861,0.317991,-0.0650353,0,-0.324573,-0.926679,0.189524,0,4.02151e-10,0.200372,0.97972,0,-9.97534,16.089,-15.7728,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0924f01e-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0924f01e-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_abfa29ed-6ab0-4bc3-bba5-0eb65b7afeb5_SNAPS_','2020-12-16 11:06:01','2020-01-24 14:02:24','0924f01e-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:01','SYNCED','0924f01e-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.12\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0926b5fb-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0926b5fb-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_ded13e4f-345b-4d5a-a99e-d24ba3e66dda_PLY_','2020-12-16 11:06:01','2020-01-24 12:08:35','0926b5fb-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:01','SYNCED','0926b5fb-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.3\",\"modelMatrix\":\"0.773921,-0.571864,0.272062,0,0.633282,0.698864,-0.332481,0,-1.40391e-9,0.429606,0.903017,0,7.71486,-28.8235,-19.6118,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0926c281-4a3b-4c7b-865f-5675c16be627','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0926c281-4a3b-4c7b-865f-5675c16be627.ply','PLY','PATIENT_79406c13-00e4-4a57-b938-5ac4cd1a9f2f_ACT_dbfeadf7-7793-42fb-be76-63e1515647d5_SESS_e53f2bc1-2f26-4656-aae6-7e1b2bbb1f50_TOSC_c094cf0d-a010-4bed-ae80-ef79a2a5a509_PLY_','2022-02-01 11:47:23','2019-07-11 13:34:49','0926c281-4a3b-4c7b-865f-5675c16be627.ply','2022-02-01 12:47:23','SYNCED','0926c281-4a3b-4c7b-865f-5675c16be627',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 40.1.1.1\",\"modelMatrix\":\"0.756185,-0.607693,0.242679,0,0.654357,0.702259,-0.280443,0,-3.89043e-9,0.370866,0.928686,0,6.44214,-42.93,-15.4868,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0928565e-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0928565e-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_27ed9780-6a38-4d69-9839-e42c0698e136_PLY_','2020-12-16 11:06:01','2020-01-24 12:20:58','0928565e-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:01','SYNCED','0928565e-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.7\",\"modelMatrix\":\"0.698056,-0.652176,0.295609,0,0.716043,0.635793,-0.288183,0,-2.02374e-9,0.412837,0.910805,0,2.04657,-33.7628,-14.7611,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'092a1409-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/092a1409-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_27ed9780-6a38-4d69-9839-e42c0698e136_SNAPS_','2020-12-16 11:06:01','2020-01-24 12:20:58','092a1409-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:01','SYNCED','092a1409-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.7\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'092bd013-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/092bd013-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_880ad313-09b0-46e2-864d-098e649dc55c_SNAPS_','2020-12-16 11:06:02','2020-01-24 12:06:05','092bd013-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:02','SYNCED','092bd013-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.2\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'092cdcf0-1044-468a-82ab-bb36c89570c9','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/092cdcf0-1044-468a-82ab-bb36c89570c9.stl','STL','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_db56cba1-23ff-48bf-b86e-4ceff749087f_BOSC_2ae10500-9760-472b-aee1-1fe00e33da53_STL_','2021-12-30 18:03:12','2019-11-14 16:13:51','092cdcf0-1044-468a-82ab-bb36c89570c9.stl','2021-12-30 19:03:12','SYNCED','092cdcf0-1044-468a-82ab-bb36c89570c9',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 202.1.1.2\",\"modelMatrix\":\"-0.997327,0.0686079,-0.0251209,0,-0.0730623,-0.936523,0.342909,0,-3.2719e-10,0.343828,0.939033,0,-17.3342,21.6229,-21.2219,1\",\"title\":\"MANDIBULE STL\"}'),(2,'092d687a-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/092d687a-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_6079dc2b-a3c3-468c-a7a3-54b4ec6bc8c2_SNAPS_','2020-12-16 11:06:02','2020-01-24 13:29:57','092d687a-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:02','SYNCED','092d687a-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'092f2e35-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/092f2e35-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_d49854df-257e-4070-b2e6-624cd798c324_PLY_','2020-12-16 11:06:02','2020-01-24 14:09:56','092f2e35-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:02','SYNCED','092f2e35-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.14\",\"modelMatrix\":\"-0.877455,0.455405,-0.150594,0,-0.479659,-0.833087,0.275487,0,-7.69801e-9,0.313962,0.949436,0,-12.6135,20.4154,-19.4439,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0930cb3c-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0930cb3c-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_4dd9e802-7e05-49b9-a508-4fb2c24adc7c_SNAPS_','2020-12-16 11:06:03','2020-01-24 13:10:47','0930cb3c-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:03','SYNCED','0930cb3c-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.15\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0932a07b-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0932a07b-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_b21b9f7d-63e5-4a3f-b6d5-51109cd9e4b9_PLY_','2020-12-16 11:06:03','2020-01-24 12:11:17','0932a07b-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:03','SYNCED','0932a07b-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.4\",\"modelMatrix\":\"0.839685,-0.489853,0.234465,0,0.543074,0.757395,-0.362523,0,-1.05621e-8,0.431736,0.902,0,4.73178,-29.3929,-15.7552,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'09344ef2-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09344ef2-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_fbddb62c-dc01-42a6-a3ba-06432b6eae2e_PLY_','2020-12-16 11:06:03','2020-01-24 13:53:34','09344ef2-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:03','SYNCED','09344ef2-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.9\",\"modelMatrix\":\"-0.94086,0.336342,-0.0406949,0,-0.338795,-0.934048,0.113013,0,1.53005e-9,0.120117,0.99276,0,-6.00259,16.597,-18.5459,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0936428c-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0936428c-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_6d7a38e4-c6c2-43e5-a6bc-969002959047_PLY_','2020-12-16 11:06:03','2020-01-24 13:20:22','0936428c-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:03','SYNCED','0936428c-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.18\",\"modelMatrix\":\"0.618528,-0.754039,0.221019,0,0.785763,0.593555,-0.173979,0,1.02333e-8,0.281279,0.959626,0,2.58563,-34.2137,-12.9019,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'093844e5-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/093844e5-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_999173f9-2453-4343-bad0-801edb58e455_SNAPS_','2020-12-16 11:06:04','2020-01-24 13:41:55','093844e5-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:04','SYNCED','093844e5-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.5\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'093a26f8-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/093a26f8-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_6079dc2b-a3c3-468c-a7a3-54b4ec6bc8c2_PLY_','2020-12-16 11:06:04','2020-01-24 13:29:57','093a26f8-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:04','SYNCED','093a26f8-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.1\",\"modelMatrix\":\"-0.921683,0.3664,-0.127478,0,-0.387943,-0.870501,0.302866,0,-9.17098e-9,0.328601,0.944469,0,-3.80924,18.7754,-18.1748,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'093bd886-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/093bd886-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_999173f9-2453-4343-bad0-801edb58e455_PLY_','2020-12-16 11:06:04','2020-01-24 13:41:55','093bd886-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:04','SYNCED','093bd886-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.5\",\"modelMatrix\":\"-0.549516,0.829949,-0.0959998,0,-0.835483,-0.545876,0.0631412,0,3.52985e-9,0.114903,0.993377,0,5.74486,27.9373,-23.7628,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'093d8717-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/093d8717-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_fdb6ffdd-d519-4f22-9036-58453f3d05ae_SNAPS_','2020-12-16 11:06:04','2020-01-24 13:04:15','093d8717-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:04','SYNCED','093d8717-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.13\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'093f7734-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/093f7734-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_255dc983-95c1-4174-8ec2-30f7a6795843_PLY_','2020-12-16 11:06:04','2020-01-24 13:23:24','093f7734-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:04','SYNCED','093f7734-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.19\",\"modelMatrix\":\"0.803356,-0.549076,0.230511,0,0.5955,0.740728,-0.31097,0,2.29095e-8,0.387089,0.922042,0,7.5171,-32.5339,-14.9323,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'093fd03b-b0a7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/093fd03b-b0a7-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_a956d8cc-0010-4cd8-a41b-1273e5303ab7_SESS_1af6c295-df5e-445d-b07c-952827b78105_TOSC_8dccec77-694b-46e3-82dd-e9fb43e0eacd_PLY_','2020-12-08 17:26:19','2020-06-17 16:29:53','093fd03b-b0a7-11ea-947d-226cec7cb58a.ply','2020-12-08 18:26:19','SYNCED','093fd03b-b0a7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.57.1.3\",\"modelMatrix\":\"0.703843,-0.649845,0.286889,0,0.710355,0.643888,-0.284259,0,2.77769e-8,0.403867,0.914818,0,-0.0651417,-35.3856,-18.1424,1\",\"title\":\"Maxillaire PLY\"}'),(2,'09415b13-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09415b13-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_dd6db312-ea21-47ef-ad39-f6ecd63b9542_PLY_','2020-12-16 11:06:05','2020-01-24 12:25:57','09415b13-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:05','SYNCED','09415b13-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.9\",\"modelMatrix\":\"-0.244305,-0.931546,0.269328,0,0.969698,-0.234693,0.0678542,0,-4.37568e-9,0.277744,0.960655,0,-21.6114,-25.954,-15.8035,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0941f40f-b0a7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0941f40f-b0a7-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_a956d8cc-0010-4cd8-a41b-1273e5303ab7_SESS_1af6c295-df5e-445d-b07c-952827b78105_TOSC_8dccec77-694b-46e3-82dd-e9fb43e0eacd_SNAPS_','2020-12-08 17:26:20','2020-06-17 16:29:53','0941f40f-b0a7-11ea-947d-226cec7cb58a.png','2020-12-08 18:26:20','SYNCED','0941f40f-b0a7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.57.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0942f42b-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0942f42b-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_c907ff3b-bdf9-48e3-91f7-2a2cfde88396_PLY_','2020-12-16 11:06:05','2020-01-24 14:06:58','0942f42b-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:05','SYNCED','0942f42b-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.13\",\"modelMatrix\":\"-0.892631,0.441307,-0.0919626,0,-0.450787,-0.873859,0.182101,0,-3.08498e-9,0.204004,0.97897,0,-12.3901,24.0432,-16.9874,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0944cf6f-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0944cf6f-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_9433adaa-ab6a-4e7d-98f6-a92b36da2982_PLY_','2020-12-16 11:06:05','2020-01-24 13:47:43','0944cf6f-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:05','SYNCED','0944cf6f-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.7\",\"modelMatrix\":\"-0.966309,0.237118,-0.100111,0,-0.257385,-0.890219,0.37585,0,1.04382e-8,0.388954,0.921257,0,-10.9841,12.471,-21.7873,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0946e20a-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0946e20a-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_bdc35573-704d-4584-86aa-734054708738_PLY_','2020-12-16 11:06:05','2020-01-24 12:13:30','0946e20a-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:05','SYNCED','0946e20a-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.5\",\"modelMatrix\":\"0.772204,-0.598445,0.213456,0,0.635374,0.727323,-0.259424,0,-5.82845e-9,0.335953,0.941879,0,4.92343,-32.8078,-12.8591,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0948b512-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0948b512-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_fdb6ffdd-d519-4f22-9036-58453f3d05ae_PLY_','2020-12-16 11:06:05','2020-01-24 13:04:15','0948b512-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:05','SYNCED','0948b512-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.13\",\"modelMatrix\":\"0.764589,-0.559255,0.320371,0,0.644518,0.663442,-0.380055,0,-2.27391e-9,0.497071,0.86771,0,4.60887,-31.9303,-15.34,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'094a6077-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/094a6077-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_b21b9f7d-63e5-4a3f-b6d5-51109cd9e4b9_SNAPS_','2020-12-16 11:06:06','2020-01-24 12:11:17','094a6077-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:06','SYNCED','094a6077-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.4\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'094bfe24-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/094bfe24-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_c907ff3b-bdf9-48e3-91f7-2a2cfde88396_SNAPS_','2020-12-16 11:06:06','2020-01-24 14:06:58','094bfe24-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:06','SYNCED','094bfe24-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.13\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'094e4cdd-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/094e4cdd-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_f97f8ae6-f86e-4501-9828-8fcb5cddd959_PLY_','2020-12-16 11:06:06','2020-01-24 13:35:51','094e4cdd-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:06','SYNCED','094e4cdd-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.3\",\"modelMatrix\":\"-0.980712,0.185973,-0.0601507,0,-0.195459,-0.933118,0.301806,0,2.10146e-9,0.307741,0.95147,0,-13.392,16.0456,-15.9342,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0950087f-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0950087f-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_9433adaa-ab6a-4e7d-98f6-a92b36da2982_SNAPS_','2020-12-16 11:06:06','2020-01-24 13:47:43','0950087f-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:06','SYNCED','0950087f-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.7\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'09520c54-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09520c54-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_1ce67bad-2826-4e28-bcd1-486703f20e5a_PLY_','2020-12-16 11:06:07','2020-01-24 13:38:51','09520c54-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:07','SYNCED','09520c54-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.4\",\"modelMatrix\":\"-0.939122,0.329617,-0.0969661,0,-0.343583,-0.900947,0.265039,0,8.3637e-10,0.28222,0.95935,0,-13.935,19.2088,-19.8511,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0952ebf3-af37-4b19-805f-7c04d43ccb4f','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0952ebf3-af37-4b19-805f-7c04d43ccb4f.stl','STL','PATIENT_8fa2891d-7bba-4605-bf05-54a276fd00f4_ACT_16441b00-310c-4cfa-bf2b-0ab01025332e_SESS_feeefb5e-69b6-4e19-ac4c-f3518e1a16dd_BOSC_96402078-5732-47ce-ad74-262452997f01_STL_','2022-02-01 11:47:23','2019-08-01 15:34:42','0952ebf3-af37-4b19-805f-7c04d43ccb4f.stl','2022-02-01 12:47:23','SYNCED','0952ebf3-af37-4b19-805f-7c04d43ccb4f',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 122.1.1.1\",\"modelMatrix\":\"-0.638379,0.767866,-0.0534277,0,-0.769722,-0.63684,0.044311,0,3.01333e-9,0.0694117,0.997588,0,1.05865,23.8827,-24.4654,1\",\"title\":\"MANDIBULE STL\"}'),(2,'0953c13d-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0953c13d-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_e44fbbcb-7ace-4649-8a05-a692408f5313_PLY_','2020-12-16 11:06:07','2020-01-24 12:28:27','0953c13d-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:07','SYNCED','0953c13d-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.10\",\"modelMatrix\":\"0.646919,-0.714202,0.26723,0,0.762559,0.605895,-0.226705,0,-4.91168e-9,0.350438,0.936586,0,1.79064,-37.1221,-11.862,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'09557735-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09557735-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_7ae48595-66f5-4167-ac7e-1725a9a86df3_PLY_','2020-12-16 11:06:07','2020-01-24 12:57:34','09557735-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:07','SYNCED','09557735-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.11\",\"modelMatrix\":\"0.436917,-0.872535,0.218601,0,0.899502,0.423818,-0.106181,0,-4.25041e-9,0.243024,0.97002,0,-7.36178,-38.4439,-10.849,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'095728e9-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/095728e9-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_c3e53fec-023d-4ec4-b5c4-43c4206d722c_SNAPS_','2020-12-16 11:06:07','2020-01-24 12:18:40','095728e9-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:07','SYNCED','095728e9-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.6\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0958c554-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0958c554-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_575489f2-70fd-4452-b245-51aee46eaf3b_PLY_','2020-12-16 11:06:08','2020-01-24 13:16:59','0958c554-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:08','SYNCED','0958c554-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.17\",\"modelMatrix\":\"0.636562,-0.748708,0.185003,0,0.771226,0.617976,-0.152699,0,9.10946e-9,0.239881,0.970802,0,1.80356,-35.1325,-15.6973,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'095c0a90-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/095c0a90-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_f248a996-fb72-4dfc-8d99-73472d18b95f_PLY_','2020-12-16 11:06:08','2020-01-24 14:12:44','095c0a90-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:08','SYNCED','095c0a90-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.15\",\"modelMatrix\":\"-0.872558,0.487073,-0.0374617,0,-0.488511,-0.869988,0.0669125,0,-3.04951e-9,0.0766855,0.997055,0,1.41659,15.9367,-23.17,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'095dd9ea-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/095dd9ea-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_7e31dc23-e958-4dce-a295-bc79e0259c7b_PLY_','2020-12-16 11:06:08','2020-01-24 14:15:19','095dd9ea-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:08','SYNCED','095dd9ea-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.16\",\"modelMatrix\":\"-0.819033,0.555924,-0.141893,0,-0.573747,-0.793591,0.202555,0,-4.53486e-9,0.24731,0.968936,0,-5.34247,26.0523,-15.7637,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'096001a3-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/096001a3-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_ecd07bc0-5a3c-4525-8dfe-74f5499a2099_SNAPS_','2020-12-16 11:06:08','2020-01-24 13:56:20','096001a3-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:08','SYNCED','096001a3-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.10\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'09621771-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09621771-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_f02f8b98-ed67-4fe5-8f44-8cbdfc993303_SNAPS_','2020-12-16 11:06:09','2020-01-24 14:33:28','09621771-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:09','SYNCED','09621771-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.19\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'09646cb4-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09646cb4-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_4eecda62-fb52-471f-9f18-1a2492b214fc_SNAPS_','2020-12-16 11:06:09','2020-01-24 13:07:18','09646cb4-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:09','SYNCED','09646cb4-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.14\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'09667d16-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09667d16-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_571cb779-07f1-4b4a-b54a-afe301c423c4_SNAPS_','2020-12-16 11:06:09','2020-01-24 12:01:54','09667d16-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:09','SYNCED','09667d16-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'09687a38-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09687a38-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_53dc197c-f7a3-4a3b-bc99-114403c3dab5_SNAPS_','2020-12-16 11:06:09','2020-01-24 13:13:27','09687a38-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:09','SYNCED','09687a38-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.16\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'096a453b-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/096a453b-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_bdc35573-704d-4584-86aa-734054708738_SNAPS_','2020-12-16 11:06:09','2020-01-24 12:13:30','096a453b-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:09','SYNCED','096a453b-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.5\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'096be345-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/096be345-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_1ce67bad-2826-4e28-bcd1-486703f20e5a_SNAPS_','2020-12-16 11:06:10','2020-01-24 13:38:51','096be345-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:10','SYNCED','096be345-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.4\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'096d7d36-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/096d7d36-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_27f590bb-6f49-467c-bd68-6ffb3b5b8066_SNAPS_','2020-12-16 11:06:10','2020-01-24 13:59:00','096d7d36-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:10','SYNCED','096d7d36-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.11\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'096dc0ac-b505-4611-8485-8995b123a6c7','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/096dc0ac-b505-4611-8485-8995b123a6c7.ply','PLY','PATIENT_bc50bff3-dacb-4f7a-a7c8-b971782c6d1d_ACT_be5de36f-b43d-47f3-b178-801c7822bb7d_SESS_df767eeb-30cd-456e-91c0-aa5269ac29d4_TOSC_53a2bf92-5fc4-4a57-94e3-611738da6165_PLY_','2021-08-05 07:30:49','2019-11-27 11:58:23','096dc0ac-b505-4611-8485-8995b123a6c7.ply','2021-08-05 09:30:49','SYNCED','096dc0ac-b505-4611-8485-8995b123a6c7',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 212.1.1.1\",\"modelMatrix\":\"0.456078,-0.842561,0.286504,0,0.88994,0.431797,-0.146828,0,3.98182e-9,0.321936,0.946761,0,-7.04778,-36.9499,-18.3322,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'096f3115-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/096f3115-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_4eecda62-fb52-471f-9f18-1a2492b214fc_PLY_','2020-12-16 11:06:10','2020-01-24 13:07:18','096f3115-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:10','SYNCED','096f3115-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.14\",\"modelMatrix\":\"0.312532,-0.914912,0.25546,0,0.949907,0.301018,-0.0840496,0,-3.17512e-9,0.268932,0.963159,0,-11.048,-35.2208,-13.1547,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0970a26e-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0970a26e-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_ecd07bc0-5a3c-4525-8dfe-74f5499a2099_PLY_','2020-12-16 11:06:10','2020-01-24 13:56:20','0970a26e-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:10','SYNCED','0970a26e-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.10\",\"modelMatrix\":\"-0.982085,0.182693,-0.0461722,0,-0.188437,-0.952148,0.240637,0,-1.51594e-9,0.245027,0.969516,0,-9.41129,20.9673,-17.7008,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0972b6fc-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0972b6fc-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_cf7510f6-bfb5-4e90-af14-79e2643fc837_PLY_','2020-12-16 11:06:11','2020-01-24 13:50:45','0972b6fc-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:11','SYNCED','0972b6fc-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.8\",\"modelMatrix\":\"-0.923862,0.371489,-0.092063,0,-0.382726,-0.896735,0.222231,0,3.17344e-9,0.240545,0.970638,0,-10.9376,19.3585,-14.9569,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'097417ba-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/097417ba-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_53dc197c-f7a3-4a3b-bc99-114403c3dab5_PLY_','2020-12-16 11:06:11','2020-01-24 13:13:27','097417ba-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:11','SYNCED','097417ba-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.16\",\"modelMatrix\":\"0.607836,-0.756955,0.239906,0,0.794063,0.579431,-0.183642,0,-6.20592e-9,0.302125,0.953268,0,-1.1237,-37.4176,-9.48596,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0975da4c-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0975da4c-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_f248a996-fb72-4dfc-8d99-73472d18b95f_SNAPS_','2020-12-16 11:06:11','2020-01-24 14:12:44','0975da4c-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:11','SYNCED','0975da4c-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.15\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'09779c3e-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09779c3e-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_10e00968-b057-4488-9fbb-ab792652fb58_PLY_','2020-12-16 11:06:11','2020-01-24 13:00:37','09779c3e-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:11','SYNCED','09779c3e-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.12\",\"modelMatrix\":\"0.700054,-0.65545,0.283389,0,0.71409,0.642567,-0.277819,0,2.01743e-8,0.396853,0.917882,0,5.2451,-33.7225,-14.8914,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'09791f82-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09791f82-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_7ae48595-66f5-4167-ac7e-1725a9a86df3_SNAPS_','2020-12-16 11:06:11','2020-01-24 12:57:34','09791f82-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:11','SYNCED','09791f82-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.11\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'097ad9a0-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/097ad9a0-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_6d7a38e4-c6c2-43e5-a6bc-969002959047_SNAPS_','2020-12-16 11:06:12','2020-01-24 13:20:22','097ad9a0-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:12','SYNCED','097ad9a0-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.18\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'097b804e-b805-4a0a-b908-fb135aa3c776','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/097b804e-b805-4a0a-b908-fb135aa3c776.png','SNAPS','PATIENT_2b864ce0-3cc8-4b80-969d-f9b27f99086e_ACT_17d544b7-b276-47e6-81d5-535312f6ff69_SESS_ab2dadf7-83a6-4b5b-bf14-291c389c43be_TOSC_27584331-5553-42cf-bbc0-5510faa74c16_SNAPS_','2021-12-30 18:03:15','2019-10-17 11:40:31','097b804e-b805-4a0a-b908-fb135aa3c776.png','2021-12-30 19:03:15','SYNCED','097b804e-b805-4a0a-b908-fb135aa3c776',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 189.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'097c5092-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/097c5092-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_b70478b1-5f48-4ae4-a41f-d5061b66be45_PLY_','2020-12-16 11:06:12','2020-01-24 13:27:05','097c5092-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:12','SYNCED','097c5092-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.20\",\"modelMatrix\":\"0.71648,-0.659174,0.228357,0,0.697608,0.677006,-0.234535,0,7.74296e-9,0.327343,0.944906,0,3.01042,-33.152,-13.3403,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'097df11d-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/097df11d-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_c3e53fec-023d-4ec4-b5c4-43c4206d722c_PLY_','2020-12-16 11:06:12','2020-01-24 12:18:40','097df11d-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:12','SYNCED','097df11d-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.6\",\"modelMatrix\":\"0.851157,-0.445757,0.277187,0,0.524912,0.722806,-0.449465,0,1.36924e-9,0.528063,0.849205,0,11.5637,-29.0554,-17.1155,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'097fa696-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/097fa696-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_b70478b1-5f48-4ae4-a41f-d5061b66be45_SNAPS_','2020-12-16 11:06:13','2020-01-24 13:27:05','097fa696-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:13','SYNCED','097fa696-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.20\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'09816a9e-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09816a9e-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_880ad313-09b0-46e2-864d-098e649dc55c_PLY_','2020-12-16 11:06:13','2020-01-24 12:06:05','09816a9e-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:13','SYNCED','09816a9e-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.2\",\"modelMatrix\":\"0.791241,-0.576961,0.202615,0,0.611504,0.746545,-0.262169,0,-1.22118e-8,0.331339,0.943512,0,5.50772,-30.857,-10.9295,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'098348a8-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/098348a8-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_a838ef29-02aa-4db9-944e-273b898e0f4b_SNAPS_','2020-12-16 11:06:13','2020-01-24 14:27:27','098348a8-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:13','SYNCED','098348a8-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.18\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0984dffe-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0984dffe-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_27f590bb-6f49-467c-bd68-6ffb3b5b8066_PLY_','2020-12-16 11:06:13','2020-01-24 13:59:00','0984dffe-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:13','SYNCED','0984dffe-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.11\",\"modelMatrix\":\"-0.712164,0.694418,-0.102987,0,-0.702013,-0.704459,0.104476,0,7.40534e-9,0.146702,0.989181,0,4.66919,16.09,-17.0977,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0986a467-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0986a467-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_255dc983-95c1-4174-8ec2-30f7a6795843_SNAPS_','2020-12-16 11:06:14','2020-01-24 13:23:24','0986a467-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:14','SYNCED','0986a467-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.19\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'09893c2a-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09893c2a-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_571cb779-07f1-4b4a-b54a-afe301c423c4_PLY_','2020-12-16 11:06:14','2020-01-24 12:01:54','09893c2a-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:14','SYNCED','09893c2a-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.1\",\"modelMatrix\":\"0.302959,-0.9422,0.143095,0,0.953004,0.299524,-0.0454898,0,1.70815e-9,0.150152,0.988663,0,-12.5834,-25.8801,-16.6298,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'098c5bca-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/098c5bca-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_f97f8ae6-f86e-4501-9828-8fcb5cddd959_SNAPS_','2020-12-16 11:06:14','2020-01-24 13:35:51','098c5bca-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:14','SYNCED','098c5bca-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.3\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'098e9e41-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/098e9e41-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_f02f8b98-ed67-4fe5-8f44-8cbdfc993303_PLY_','2020-12-16 11:06:14','2020-01-24 14:33:28','098e9e41-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:14','SYNCED','098e9e41-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.19\",\"modelMatrix\":\"-0.934629,0.347969,-0.0733966,0,-0.355625,-0.914506,0.192896,0,5.37018e-9,0.206388,0.97847,0,-3.99166,21.7512,-15.2256,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0990c612-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0990c612-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_fbddb62c-dc01-42a6-a3ba-06432b6eae2e_SNAPS_','2020-12-16 11:06:14','2020-01-24 13:53:34','0990c612-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:14','SYNCED','0990c612-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.9\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'099288c7-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/099288c7-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_34b02c4d-5fa9-4b9d-98b4-48d85a686fde_PLY_','2020-12-16 11:06:15','2020-01-24 12:23:27','099288c7-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:15','SYNCED','099288c7-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.8\",\"modelMatrix\":\"0.783445,-0.550086,0.289171,0,0.621462,0.693465,-0.364543,0,-2.17087e-8,0.465308,0.885149,0,0.758246,-31.3396,-14.8588,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0994a9b1-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0994a9b1-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_4dd9e802-7e05-49b9-a508-4fb2c24adc7c_PLY_','2020-12-16 11:06:15','2020-01-24 13:10:47','0994a9b1-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:15','SYNCED','0994a9b1-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.15\",\"modelMatrix\":\"0.787294,-0.562412,0.252708,0,0.616578,0.71813,-0.322677,0,-1.88464e-9,0.409856,0.91215,0,6.51226,-30.0623,-19.6356,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0996b175-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0996b175-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_dd6db312-ea21-47ef-ad39-f6ecd63b9542_SNAPS_','2020-12-16 11:06:15','2020-01-24 12:25:57','0996b175-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:15','SYNCED','0996b175-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.9\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'099875c6-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/099875c6-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_34b02c4d-5fa9-4b9d-98b4-48d85a686fde_SNAPS_','2020-12-16 11:06:15','2020-01-24 12:23:27','099875c6-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:15','SYNCED','099875c6-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.8\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'099a65e4-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/099a65e4-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_2bed089e-68c3-431b-99b5-222a86530979_SNAPS_','2020-12-16 11:06:16','2020-01-24 14:18:24','099a65e4-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:16','SYNCED','099a65e4-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.17\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'099c61b0-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/099c61b0-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_ded13e4f-345b-4d5a-a99e-d24ba3e66dda_SNAPS_','2020-12-16 11:06:16','2020-01-24 12:08:35','099c61b0-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:16','SYNCED','099c61b0-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.3\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'099e3158-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/099e3158-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_a838ef29-02aa-4db9-944e-273b898e0f4b_PLY_','2020-12-16 11:06:16','2020-01-24 14:27:27','099e3158-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:16','SYNCED','099e3158-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.18\",\"modelMatrix\":\"-0.955862,0.253688,-0.148222,0,-0.293815,-0.825318,0.482206,0,2.27161e-9,0.504473,0.863428,0,-15.0526,11.7182,-21.373,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'099ff65f-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/099ff65f-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_8f0d3062-1121-4e4e-b9ed-921f4dc3427f_SNAPS_','2020-12-16 11:06:16','2020-01-24 13:44:39','099ff65f-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:16','SYNCED','099ff65f-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.6\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'09a1e7b2-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09a1e7b2-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_575489f2-70fd-4452-b245-51aee46eaf3b_SNAPS_','2020-12-16 11:06:17','2020-01-24 13:16:59','09a1e7b2-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:17','SYNCED','09a1e7b2-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.17\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'09a3e6ca-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09a3e6ca-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_a7d50cc0-3fca-4680-bdad-29b328f5b62a_SNAPS_','2020-12-16 11:06:17','2020-01-24 14:39:39','09a3e6ca-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:17','SYNCED','09a3e6ca-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.20\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'09a610e3-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09a610e3-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_10e00968-b057-4488-9fbb-ab792652fb58_SNAPS_','2020-12-16 11:06:17','2020-01-24 13:00:37','09a610e3-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:17','SYNCED','09a610e3-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.12\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'09a8210e-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09a8210e-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_d49854df-257e-4070-b2e6-624cd798c324_SNAPS_','2020-12-16 11:06:17','2020-01-24 14:09:56','09a8210e-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:17','SYNCED','09a8210e-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.14\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'09aa4b30-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09aa4b30-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_a652bfa0-2f48-4a5c-baee-0b1742d0f575_PLY_','2020-12-16 11:06:18','2020-01-24 13:33:07','09aa4b30-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:18','SYNCED','09aa4b30-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.2\",\"modelMatrix\":\"-0.795971,0.604782,-0.0258706,0,-0.605335,-0.795243,0.0340179,0,-1.94414e-9,0.0427376,0.999086,0,-1.93611,20.8759,-18.0257,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'09ac61d4-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09ac61d4-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_a7d50cc0-3fca-4680-bdad-29b328f5b62a_PLY_','2020-12-16 11:06:18','2020-01-24 14:39:39','09ac61d4-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:18','SYNCED','09ac61d4-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.20\",\"modelMatrix\":\"-0.778745,0.624547,-0.0591346,0,-0.62734,-0.775278,0.0734063,0,-3.70358e-9,0.0942623,0.995547,0,0.709204,23.0661,-18.9816,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'09ae5421-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09ae5421-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_abfa29ed-6ab0-4bc3-bba5-0eb65b7afeb5_PLY_','2020-12-16 11:06:18','2020-01-24 14:02:24','09ae5421-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:18','SYNCED','09ae5421-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.12\",\"modelMatrix\":\"-0.464623,0.882387,-0.0742891,0,-0.885508,-0.462985,0.0389793,0,-2.99715e-9,0.0838943,0.996475,0,4.71474,15.989,-23.0544,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'09b38a97-cae3-4f8c-9985-94559da6c4da','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09b38a97-cae3-4f8c-9985-94559da6c4da.png','SNAPS','PATIENT_e6cb123a-be87-4228-97b3-06d5473ed349_ACT_99e7b9d4-2a93-4741-8341-cb9c68abefa5_SESS_caf7693c-1b52-401d-830a-1bf478ab6c0c_TOSC_96e4357a-6c6d-444f-822c-5d8dcc74e000_SNAPS_','2020-12-08 17:26:40','2020-06-18 09:44:18','09b38a97-cae3-4f8c-9985-94559da6c4da.png','2020-12-08 18:26:40','SYNCED','09b38a97-cae3-4f8c-9985-94559da6c4da',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.62.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'09b79c8d-68bd-4b99-8e34-1a218553e3fc','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09b79c8d-68bd-4b99-8e34-1a218553e3fc.ply','PLY','PATIENT_2e96b047-789a-4c40-9501-4fcae191cc7e_ACT_cda50aaf-54ba-4d75-bfa1-6b9506445a20_SESS_201e32b7-d790-47ae-95b1-f7d8437c1d49_TOSC_1b9c1daf-2b69-4cf2-bac9-1384add7efa8_PLY_','2020-12-16 11:06:18','2020-01-28 17:20:24','09b79c8d-68bd-4b99-8e34-1a218553e3fc.ply','2020-12-16 12:06:18','SYNCED','09b79c8d-68bd-4b99-8e34-1a218553e3fc',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 96.1.1.1.1\",\"modelMatrix\":\"0.782286,-0.579533,0.228408,0,0.622919,0.7278,-0.286844,0,1.04789e-9,0.366674,0.930349,0,6.67217,-34.335,-18.3093,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'09f7e33b-5277-4039-9bcb-546fafc179a7','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09f7e33b-5277-4039-9bcb-546fafc179a7.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_16d7b282-66e1-4355-9b60-0bafa1ca8e98_SESS_220665e1-59d7-472e-9aaf-149ee093a8e1_BOSC_58e07cde-2422-4a97-afcb-b86f55db1dc4_PLY_','2020-12-16 10:52:14','2020-05-27 16:17:07','09f7e33b-5277-4039-9bcb-546fafc179a7.ply','2020-12-16 11:52:14','SYNCED','09f7e33b-5277-4039-9bcb-546fafc179a7',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 216.1.18.1.1\",\"modelMatrix\":\"-0.99972,0.022192,-0.00822923,0,-0.0236686,-0.937349,0.347588,0,-1.14021e-10,0.347685,0.937611,0,-10.9063,13.0068,-20.0127,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'09fbefc5-e1bf-4b40-ad4f-f25b67895098','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09fbefc5-e1bf-4b40-ad4f-f25b67895098.png','SNAPS','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_BOSC_6b91b69b-0088-4a4e-bb54-ae2789304ed8_SNAPS_','2021-12-30 18:03:15','2019-11-15 13:40:45','09fbefc5-e1bf-4b40-ad4f-f25b67895098.png','2021-12-30 19:03:15','SYNCED','09fbefc5-e1bf-4b40-ad4f-f25b67895098',0,NULL,'','','{\"displayTitle\":\"Mandibola 0\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0a00a270-9ad1-47af-b0ab-128fec38241e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a00a270-9ad1-47af-b0ab-128fec38241e.ply','PLY','PATIENT_77df9d3b-1263-4977-9ccc-286cac817ae8_ACT_b6197058-add2-4c61-ab3b-b8da15d9bb13_SESS_35096ba8-a837-42da-ad6e-e6bdbbf74116_BOSC_12ebb0d0-3e96-45d3-ae51-5c0312466e23_PLY_','2022-02-01 11:47:24','2019-07-17 13:31:26','0a00a270-9ad1-47af-b0ab-128fec38241e.ply','2022-02-01 12:47:24','SYNCED','0a00a270-9ad1-47af-b0ab-128fec38241e',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 87.1.1.1\",\"modelMatrix\":\"-0.613858,0.784002,-0.0922982,0,-0.789416,-0.609648,0.071772,0,-2.39726e-9,0.11692,0.993141,0,10.2466,26.5157,-24.9078,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0a0daba1-88b9-4aca-a32e-33ee62cf03ec','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a0daba1-88b9-4aca-a32e-33ee62cf03ec.png','SNAPS','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_aaaeb032-2111-434f-b0d7-0923a56dbb56_SESS_1f381489-037a-46af-8034-d00e0aa3d9ea_BOSC_a2ae7933-dd79-48fa-9694-203d29380116_SNAPS_','2020-12-16 11:06:19','2020-01-20 16:11:47','0a0daba1-88b9-4aca-a32e-33ee62cf03ec.png','2020-12-16 12:06:19','SYNCED','0a0daba1-88b9-4aca-a32e-33ee62cf03ec',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.1.1.1.2\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0a2783ba-62d1-41a7-b99b-6d1cd2c5a7dc','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a2783ba-62d1-41a7-b99b-6d1cd2c5a7dc.ply','PLY','PATIENT_ff96c5bd-a3bf-4f05-92e4-56f76b83b454_ACT_d737feed-a81f-42f0-a536-f47f5a256ae6_SESS_4ac56d86-9375-40ed-956b-affb4721bd49_TOSC_c703c340-c05c-4271-a8ef-688293b8a817_PLY_','2021-12-30 18:03:15','2019-11-18 11:46:57','0a2783ba-62d1-41a7-b99b-6d1cd2c5a7dc.ply','2021-12-30 19:03:15','SYNCED','0a2783ba-62d1-41a7-b99b-6d1cd2c5a7dc',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 203.1.1.1\",\"modelMatrix\":\"0.689837,-0.645555,0.327696,0,0.723965,0.615123,-0.312248,0,-5.68395e-9,0.45264,0.891693,0,6.49575,-35.8846,-20.1313,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0a29fdf4-586b-4b87-aa3d-8e35e23bcdaa','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a29fdf4-586b-4b87-aa3d-8e35e23bcdaa.png','SNAPS','PATIENT_b4908dda-5d76-4e35-849e-e08780817f2e_ACT_daf35305-351d-42c6-9799-5882d57a3476_SESS_758b6d2c-f72a-49d9-9fea-a57718467959_TOSC_771664cd-d750-49a0-aa43-8b0cb7d8c509_SNAPS_','2022-02-01 11:47:24','2019-07-22 16:54:02','0a29fdf4-586b-4b87-aa3d-8e35e23bcdaa.png','2022-02-01 12:47:24','SYNCED','0a29fdf4-586b-4b87-aa3d-8e35e23bcdaa',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 109.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0a2d8e9d-460a-4c22-9efa-293ed82495ec','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a2d8e9d-460a-4c22-9efa-293ed82495ec.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_65b9d490-aed6-4c41-be15-53e25c84af4d_SESS_9f48c8ba-9786-4871-bcb0-7f121f65e446_TOSC_637eb2be-61e2-43af-b2fe-1bbd0b7c3d54_PLY_','2020-12-16 10:52:16','2020-03-12 15:29:55','0a2d8e9d-460a-4c22-9efa-293ed82495ec.ply','2020-12-16 11:52:16','SYNCED','0a2d8e9d-460a-4c22-9efa-293ed82495ec',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.2\",\"modelMatrix\":\"0.537018,-0.801869,0.261952,0,0.843571,0.51047,-0.166759,0,-1.01997e-8,0.310528,0.950564,0,-2.7145,-33.1247,-16.8876,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0a3b2b66-a02c-42f1-b214-6bb66e68b5c1','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a3b2b66-a02c-42f1-b214-6bb66e68b5c1.ply','PLY','PATIENT_896c58b2-09d0-4924-afd4-804b68c496b7_ACT_22ff036e-5aec-4cfd-9224-cc3b88c546b5_SESS_0e888239-d087-47ba-82ab-1f79eddb5b0c_BOSC_ea82ec27-ce8d-43f2-a778-3b5bb5cfba24_PLY_','2021-12-30 18:03:16','2019-10-31 09:12:42','0a3b2b66-a02c-42f1-b214-6bb66e68b5c1.ply','2021-12-30 19:03:16','SYNCED','0a3b2b66-a02c-42f1-b214-6bb66e68b5c1',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 197.1.1.1\",\"modelMatrix\":\"-0.807339,0.581042,-0.102932,0,-0.590088,-0.794961,0.140828,0,1.04965e-9,0.174435,0.984669,0,-0.44251,20.671,-15.2433,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0a3bbdb9-aa1e-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a3bbdb9-aa1e-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_e51cf9a2-03cb-4e48-928a-2755186e1db6_ACT_000dfdf1-07e2-4cb4-9351-56d36d0f2b2f_SESS_bcaa9cd4-a73e-45a0-aa14-14571985bf99_TOSC_4898a0f1-e758-4945-8096-35453addad4f_STL_','2022-02-01 11:47:24','2019-07-19 16:11:04','0a3bbdb9-aa1e-11e9-a33b-226cec7cb58a.stl','2022-02-01 12:47:24','SYNCED','0a3bbdb9-aa1e-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 102.1.1.1\",\"modelMatrix\":\"0.604138,-0.726749,0.326884,0,0.796879,0.55097,-0.247821,0,1.17685e-8,0.410205,0.911993,0,4.5742,-36.6945,-23.86,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'0a3c58fe-aa1e-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a3c58fe-aa1e-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_e51cf9a2-03cb-4e48-928a-2755186e1db6_ACT_000dfdf1-07e2-4cb4-9351-56d36d0f2b2f_SESS_bcaa9cd4-a73e-45a0-aa14-14571985bf99_BOSC_45a59966-4c7e-47ea-b045-6b04d1ecd1ad_STL_','2022-02-01 11:47:24','2019-07-19 16:16:54','0a3c58fe-aa1e-11e9-a33b-226cec7cb58a.stl','2022-02-01 12:47:24','SYNCED','0a3c58fe-aa1e-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 102.1.1.1\",\"modelMatrix\":\"-0.983759,0.173515,-0.045952,0,-0.179497,-0.950975,0.251847,0,-9.75582e-10,0.256005,0.966676,0,-12.4899,15.7274,-23.3581,1\",\"title\":\"MANDIBULE STL\"}'),(2,'0a3cf32d-aa1e-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a3cf32d-aa1e-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_e51cf9a2-03cb-4e48-928a-2755186e1db6_ACT_000dfdf1-07e2-4cb4-9351-56d36d0f2b2f_SESS_bcaa9cd4-a73e-45a0-aa14-14571985bf99_BOSC_45a59966-4c7e-47ea-b045-6b04d1ecd1ad_PLY_','2022-02-01 11:47:24','2019-07-19 16:16:54','0a3cf32d-aa1e-11e9-a33b-226cec7cb58a.ply','2022-02-01 12:47:24','SYNCED','0a3cf32d-aa1e-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 102.1.1.1\",\"modelMatrix\":\"-0.983759,0.173515,-0.045952,0,-0.179497,-0.950975,0.251847,0,-9.75582e-10,0.256005,0.966676,0,-12.4899,15.7274,-23.3581,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0a3d6f24-aa1e-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a3d6f24-aa1e-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_e51cf9a2-03cb-4e48-928a-2755186e1db6_ACT_000dfdf1-07e2-4cb4-9351-56d36d0f2b2f_SESS_bcaa9cd4-a73e-45a0-aa14-14571985bf99_TOSC_4898a0f1-e758-4945-8096-35453addad4f_SNAPS_','2022-02-01 11:47:25','2019-07-19 16:11:04','0a3d6f24-aa1e-11e9-a33b-226cec7cb58a.png','2022-02-01 12:47:25','SYNCED','0a3d6f24-aa1e-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 102.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0a3dbafe-aa1e-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a3dbafe-aa1e-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_e51cf9a2-03cb-4e48-928a-2755186e1db6_ACT_000dfdf1-07e2-4cb4-9351-56d36d0f2b2f_SESS_bcaa9cd4-a73e-45a0-aa14-14571985bf99_BOSC_45a59966-4c7e-47ea-b045-6b04d1ecd1ad_SNAPS_','2022-02-01 11:47:25','2019-07-19 16:16:54','0a3dbafe-aa1e-11e9-a33b-226cec7cb58a.png','2022-02-01 12:47:25','SYNCED','0a3dbafe-aa1e-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 102.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0a3e440c-aa1e-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a3e440c-aa1e-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_e51cf9a2-03cb-4e48-928a-2755186e1db6_ACT_000dfdf1-07e2-4cb4-9351-56d36d0f2b2f_SESS_bcaa9cd4-a73e-45a0-aa14-14571985bf99_TOSC_4898a0f1-e758-4945-8096-35453addad4f_PLY_','2022-02-01 11:47:25','2019-07-19 16:11:04','0a3e440c-aa1e-11e9-a33b-226cec7cb58a.ply','2022-02-01 12:47:25','SYNCED','0a3e440c-aa1e-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 102.1.1.1\",\"modelMatrix\":\"0.604138,-0.726749,0.326884,0,0.796879,0.55097,-0.247821,0,1.17685e-8,0.410205,0.911993,0,4.5742,-36.6945,-23.86,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0a5ddb9d-f06b-4469-bad6-069d0ac84241','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a5ddb9d-f06b-4469-bad6-069d0ac84241.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_96214f4b-9456-4208-b81d-5b82b21b335a_SESS_07baa47f-dbc6-44a6-834f-d97971fa404b_BOSC_d16f3392-688b-4393-8cc1-b59599a49b32_PLY_','2020-12-16 10:52:18','2020-02-11 16:39:55','0a5ddb9d-f06b-4469-bad6-069d0ac84241.ply','2020-12-16 11:52:18','SYNCED','0a5ddb9d-f06b-4469-bad6-069d0ac84241',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"modelMatrix\":\"-0.999002,0.0429314,-0.0123,0,-0.0446586,-0.960364,0.275147,0,-5.53983e-11,0.275422,0.961323,0,-15.3569,15.881,-14.8301,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0a784696-e5f0-4e0f-b4e2-62abfc51436f','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a784696-e5f0-4e0f-b4e2-62abfc51436f.ply','PLY','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_fd694b3f-abde-4e46-91f7-7c62bfdcafa4_SESS_73a3f5b9-e905-4911-a163-2022e1de3380_TOSC_33c23c80-0963-40c0-a315-0461c3cb686a_PLY_','2021-08-19 22:26:44','2019-11-26 15:43:14','0a784696-e5f0-4e0f-b4e2-62abfc51436f.ply','2021-08-20 00:26:44','SYNCED','0a784696-e5f0-4e0f-b4e2-62abfc51436f',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"modelMatrix\":\"-0.314282,-0.917164,0.245023,0,0.94933,-0.303633,0.0811166,0,-3.23617e-9,0.258102,0.966118,0,-26.7208,-19.9951,-15.3285,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0a7a3f65-54ae-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a7a3f65-54ae-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_442eff8f-6b66-481a-8ed8-4880ab72f3b4_SESS_c4721828-5af5-4858-8ec9-8b9a91b74be2_BOSC_f2121c2c-4949-41e2-bde3-d951dcca0a00_PLY_','2020-12-16 10:52:18','2020-02-21 14:16:09','0a7a3f65-54ae-11ea-947d-226cec7cb58a.ply','2020-12-16 11:52:18','SYNCED','0a7a3f65-54ae-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"modelMatrix\":\"-0.487776,0.872338,-0.0331893,0,-0.872969,-0.487423,0.0185447,0,-8.62903e-10,0.0380189,0.999277,0,7.91763,20.7783,-20.3288,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0a7c381c-54ae-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a7c381c-54ae-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_feae2a9b-ce74-4748-a769-afb48091183f_ACT_442eff8f-6b66-481a-8ed8-4880ab72f3b4_SESS_c4721828-5af5-4858-8ec9-8b9a91b74be2_TOSC_486af8d6-7715-463b-9719-5d135f018413_SNAPS_','2020-12-16 10:52:18','2020-02-21 14:13:11','0a7c381c-54ae-11ea-947d-226cec7cb58a.png','2020-12-16 11:52:18','SYNCED','0a7c381c-54ae-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0a7dc2a5-54ae-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a7dc2a5-54ae-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_442eff8f-6b66-481a-8ed8-4880ab72f3b4_SESS_c4721828-5af5-4858-8ec9-8b9a91b74be2_BOSC_f2121c2c-4949-41e2-bde3-d951dcca0a00_SNAPS_','2020-12-16 10:52:19','2020-02-21 14:16:09','0a7dc2a5-54ae-11ea-947d-226cec7cb58a.png','2020-12-16 11:52:19','SYNCED','0a7dc2a5-54ae-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0a800105-54ae-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a800105-54ae-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_feae2a9b-ce74-4748-a769-afb48091183f_ACT_442eff8f-6b66-481a-8ed8-4880ab72f3b4_SESS_c4721828-5af5-4858-8ec9-8b9a91b74be2_TOSC_486af8d6-7715-463b-9719-5d135f018413_PLY_','2020-12-16 10:52:19','2020-02-21 14:13:11','0a800105-54ae-11ea-947d-226cec7cb58a.ply','2020-12-16 11:52:19','SYNCED','0a800105-54ae-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"modelMatrix\":\"0.677827,-0.692328,0.24745,0,0.735221,0.638283,-0.228133,0,-4.58298e-9,0.336566,0.94166,0,-0.962451,-31.9979,-15.8202,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0a82f573-6a32-4b8d-8584-3156d278b7be','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a82f573-6a32-4b8d-8584-3156d278b7be.ply','PLY','PATIENT_d9860777-a354-46c2-bb39-b2f150617cc7_ACT_007fc3da-8408-4668-b268-90b0cc4e0512_SESS_e5c0ff5f-1b35-473b-bb5b-6a699181486e_BOSC_e2acb957-0e34-46cc-88b6-368e2a1956df_PLY_','2020-12-23 09:07:50','2019-12-18 14:32:59','0a82f573-6a32-4b8d-8584-3156d278b7be.ply','2020-12-23 10:07:50','SYNCED','0a82f573-6a32-4b8d-8584-3156d278b7be',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 21.1.268.1.1.1\",\"modelMatrix\":\"-0.223239,0.966774,-0.124547,0,-0.974764,-0.221409,0.0285235,0,-3.13958e-10,0.127771,0.991804,0,11.8882,16.7578,-23.1337,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0a889874-9b6e-4be0-a2b9-55a5f419a324','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a889874-9b6e-4be0-a2b9-55a5f419a324.ply','PLY','PATIENT_878a5537-ff9c-4571-a968-f11b3b1e2055_ACT_6c0855be-3e79-42b9-84ff-3f2afe3afb78_SESS_eb76868f-5b66-47aa-8517-3a782fe0b86f_BOSC_28318e36-8937-4aa6-8ea5-8d0ebd1423c1_PLY_','2022-02-01 11:47:25','2019-07-19 12:00:00','0a889874-9b6e-4be0-a2b9-55a5f419a324.ply','2022-02-01 12:47:25','SYNCED','0a889874-9b6e-4be0-a2b9-55a5f419a324',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 99.1.1.1\",\"modelMatrix\":\"-0.961114,-0.274262,0.0322554,0,0.276153,-0.954535,0.112261,0,2.84132e-10,0.116803,0.993155,0,-29.2489,12.1179,-27.6354,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0a8ccbff-82ef-443a-b57e-031ad8b27082','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a8ccbff-82ef-443a-b57e-031ad8b27082.ply','PLY','PATIENT_dde53ea4-f623-42e4-9864-d8e77d9deabe_ACT_c658c808-2655-4213-a8a0-1c34d5830ee5_SESS_ad32c977-4115-45c7-9168-d19d87c66102_BOSC_a2b7dde6-1c31-47e4-ba81-afc2bb602260_PLY_','2021-12-30 18:03:17','2019-11-22 08:23:12','0a8ccbff-82ef-443a-b57e-031ad8b27082.ply','2021-12-30 19:03:17','SYNCED','0a8ccbff-82ef-443a-b57e-031ad8b27082',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 208.1.1.1\",\"modelMatrix\":\"-0.852783,0.513392,-0.0958648,0,-0.522266,-0.838293,0.156533,0,-6.56088e-9,0.183556,0.983009,0,2.08999,21.5508,-19.8589,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0acb7283-1d94-428b-916d-677f332440cc','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0acb7283-1d94-428b-916d-677f332440cc.ply','PLY','PATIENT_67c10a45-b4ec-42ba-ae2c-900a195adb87_ACT_86b9837f-894c-450e-be34-50dce2fbdc92_SESS_11baa7ef-ca17-442b-a5da-1d859ce1c951_TOSC_ac047e44-8462-4977-a9f4-84b2517681ab_PLY_','2021-12-30 18:03:17','2019-10-14 11:11:56','0acb7283-1d94-428b-916d-677f332440cc.ply','2021-12-30 19:03:17','SYNCED','0acb7283-1d94-428b-916d-677f332440cc',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.19.1.1\",\"modelMatrix\":\"0.534199,-0.8234,0.191423,0,0.845359,0.520323,-0.120964,0,9.34479e-10,0.22644,0.974025,0,-3.96586,-29.2976,-17.9656,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0acbffd9-1150-40cb-b4a4-8eca5cf94553','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0acbffd9-1150-40cb-b4a4-8eca5cf94553.ply','PLY','PATIENT_8d82ec2a-5aab-4c9b-b6ad-36b7d5ee6b2e_ACT_10218071-9e0c-43c4-85ff-32ab432e2d0c_SESS_24753abd-8bfd-4d4a-9076-ac7545bfde80_TOSC_eda85daf-d64f-445f-9ca4-6a217ed99fe0_PLY_','2022-02-01 11:47:26','2019-07-22 12:15:15','0acbffd9-1150-40cb-b4a4-8eca5cf94553.ply','2022-02-01 12:47:26','SYNCED','0acbffd9-1150-40cb-b4a4-8eca5cf94553',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 105.1.1.1\",\"modelMatrix\":\"0.444408,-0.849926,0.283069,0,0.895824,0.421638,-0.140427,0,-1.23332e-8,0.315987,0.948763,0,-6.05735,-35.8179,-18.2183,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0adf659c-e355-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0adf659c-e355-11e9-947d-226cec7cb58a.stl','STL','PATIENT_7dec86c0-1085-463b-888a-3363184a2fec_ACT_054e3d99-a38e-4dbd-adc8-33dbc93198c7_SESS_853ab549-f561-4849-8acd-2ec1e14f57fc_TOSC_5916611b-ff0e-465b-ad25-89420f1e6066_STL_','2022-02-01 11:47:26','2019-09-30 09:31:25','0adf659c-e355-11e9-947d-226cec7cb58a.stl','2022-02-01 12:47:26','SYNCED','0adf659c-e355-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 45.1.1.1\",\"modelMatrix\":\"0.531945,-0.755195,0.383034,0,0.846779,0.474413,-0.240621,0,1.30923e-9,0.452342,0.891844,0,-0.207042,-33.9745,-18.8016,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'0ae17ece-e355-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0ae17ece-e355-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_7dec86c0-1085-463b-888a-3363184a2fec_ACT_054e3d99-a38e-4dbd-adc8-33dbc93198c7_SESS_853ab549-f561-4849-8acd-2ec1e14f57fc_TOSC_5916611b-ff0e-465b-ad25-89420f1e6066_SNAPS_','2022-02-01 11:47:26','2019-09-30 09:31:25','0ae17ece-e355-11e9-947d-226cec7cb58a.png','2022-02-01 12:47:26','SYNCED','0ae17ece-e355-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 45.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0ae2ee37-e355-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0ae2ee37-e355-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_7dec86c0-1085-463b-888a-3363184a2fec_ACT_054e3d99-a38e-4dbd-adc8-33dbc93198c7_SESS_853ab549-f561-4849-8acd-2ec1e14f57fc_TOSC_5916611b-ff0e-465b-ad25-89420f1e6066_PLY_','2022-02-01 11:47:26','2019-09-30 09:31:25','0ae2ee37-e355-11e9-947d-226cec7cb58a.ply','2022-02-01 12:47:26','SYNCED','0ae2ee37-e355-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 45.1.1.1\",\"modelMatrix\":\"0.531945,-0.755195,0.383034,0,0.846779,0.474413,-0.240621,0,1.30923e-9,0.452342,0.891844,0,-0.207042,-33.9745,-18.8016,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0ae48b23-e355-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0ae48b23-e355-11e9-947d-226cec7cb58a.stl','STL','PATIENT_7dec86c0-1085-463b-888a-3363184a2fec_ACT_054e3d99-a38e-4dbd-adc8-33dbc93198c7_SESS_853ab549-f561-4849-8acd-2ec1e14f57fc_BOSC_c199af24-d81f-409c-bf2d-51044e8d1a0e_STL_','2022-02-01 11:47:26','2019-09-30 09:35:36','0ae48b23-e355-11e9-947d-226cec7cb58a.stl','2022-02-01 12:47:26','SYNCED','0ae48b23-e355-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 45.1.1.1\",\"modelMatrix\":\"-0.737863,0.672926,-0.0522281,0,-0.67495,-0.735651,0.0570963,0,1.38662e-9,0.0773806,0.997002,0,-7.34162,26.1681,-26.7786,1\",\"title\":\"MANDIBULE STL\"}'),(2,'0ae61a27-e355-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0ae61a27-e355-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_7dec86c0-1085-463b-888a-3363184a2fec_ACT_054e3d99-a38e-4dbd-adc8-33dbc93198c7_SESS_853ab549-f561-4849-8acd-2ec1e14f57fc_BOSC_c199af24-d81f-409c-bf2d-51044e8d1a0e_PLY_','2022-02-01 11:47:27','2019-09-30 09:35:36','0ae61a27-e355-11e9-947d-226cec7cb58a.ply','2022-02-01 12:47:27','SYNCED','0ae61a27-e355-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 45.1.1.1\",\"modelMatrix\":\"-0.737863,0.672926,-0.0522281,0,-0.67495,-0.735651,0.0570963,0,1.38662e-9,0.0773806,0.997002,0,-7.34162,26.1681,-26.7786,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0ae76b4e-e355-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0ae76b4e-e355-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_7dec86c0-1085-463b-888a-3363184a2fec_ACT_054e3d99-a38e-4dbd-adc8-33dbc93198c7_SESS_853ab549-f561-4849-8acd-2ec1e14f57fc_BOSC_c199af24-d81f-409c-bf2d-51044e8d1a0e_SNAPS_','2022-02-01 11:47:27','2019-09-30 09:35:36','0ae76b4e-e355-11e9-947d-226cec7cb58a.png','2022-02-01 12:47:27','SYNCED','0ae76b4e-e355-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 45.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0ae76e33-dfec-4e0c-8471-68f81312dcc4','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0ae76e33-dfec-4e0c-8471-68f81312dcc4.png','SNAPS','PATIENT_1fff6898-79c5-4b7a-8ae6-ae2af9a8cbe4_ACT_c988658e-e313-4d11-9672-2c295b7584a6_SESS_db3f12ec-05bf-4d4c-a595-6a4620d49fae_TOSC_ec53d847-39f7-424f-8508-5ef0c1545647_SNAPS_','2022-02-01 11:47:28','2019-09-23 16:37:49','0ae76e33-dfec-4e0c-8471-68f81312dcc4.png','2022-02-01 12:47:28','SYNCED','0ae76e33-dfec-4e0c-8471-68f81312dcc4',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 162.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0ae8b1e9-1ccf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0ae8b1e9-1ccf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_0dc4f506-9fce-480c-982e-216990922429_ACT_ed8a1fc3-a794-4c54-a67e-f97b524d231f_SESS_855c3013-3b21-4f57-9d52-c7a464ee9f30_TOSC_ae0bb8f3-9c17-435e-b1bd-87507c964bae_SNAPS_','2021-01-06 11:02:17','2019-12-12 11:54:12','0ae8b1e9-1ccf-11ea-947d-226cec7cb58a.png','2021-01-06 12:02:17','SYNCED','0ae8b1e9-1ccf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 232.10.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0aea0507-1ccf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0aea0507-1ccf-11ea-947d-226cec7cb58a.stl','STL','PATIENT_0dc4f506-9fce-480c-982e-216990922429_ACT_ed8a1fc3-a794-4c54-a67e-f97b524d231f_SESS_855c3013-3b21-4f57-9d52-c7a464ee9f30_BOSC_6209ee8c-34a1-499e-b00b-1711f30ddf77_STL_','2021-01-06 11:02:18','2019-12-12 12:01:26','0aea0507-1ccf-11ea-947d-226cec7cb58a.stl','2021-01-06 12:02:18','SYNCED','0aea0507-1ccf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 232.10.1.1\",\"modelMatrix\":\"-0.992458,0.121287,-0.017786,0,-0.122584,-0.981956,0.143998,0,3.27737e-10,0.145093,0.989418,0,-15.0188,19.9604,-23.0852,1\",\"title\":\"MANDIBULE STL\"}'),(2,'0aeb8512-1ccf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0aeb8512-1ccf-11ea-947d-226cec7cb58a.stl','STL','PATIENT_0dc4f506-9fce-480c-982e-216990922429_ACT_ed8a1fc3-a794-4c54-a67e-f97b524d231f_SESS_855c3013-3b21-4f57-9d52-c7a464ee9f30_TOSC_ae0bb8f3-9c17-435e-b1bd-87507c964bae_STL_','2021-01-06 11:02:18','2019-12-12 11:54:12','0aeb8512-1ccf-11ea-947d-226cec7cb58a.stl','2021-01-06 12:02:18','SYNCED','0aeb8512-1ccf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 232.10.1.1\",\"modelMatrix\":\"0.528126,-0.820693,0.218051,0,0.849166,0.510418,-0.135613,0,7.4386e-9,0.256782,0.966469,0,1.61407,-37.5502,-19.5006,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'0aed0572-1ccf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0aed0572-1ccf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_0dc4f506-9fce-480c-982e-216990922429_ACT_ed8a1fc3-a794-4c54-a67e-f97b524d231f_SESS_855c3013-3b21-4f57-9d52-c7a464ee9f30_BOSC_6209ee8c-34a1-499e-b00b-1711f30ddf77_SNAPS_','2021-01-06 11:02:18','2019-12-12 12:01:26','0aed0572-1ccf-11ea-947d-226cec7cb58a.png','2021-01-06 12:02:18','SYNCED','0aed0572-1ccf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 232.10.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0aee7d8c-1ccf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0aee7d8c-1ccf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_0dc4f506-9fce-480c-982e-216990922429_ACT_ed8a1fc3-a794-4c54-a67e-f97b524d231f_SESS_855c3013-3b21-4f57-9d52-c7a464ee9f30_TOSC_ae0bb8f3-9c17-435e-b1bd-87507c964bae_PLY_','2021-01-06 11:02:18','2019-12-12 11:54:12','0aee7d8c-1ccf-11ea-947d-226cec7cb58a.ply','2021-01-06 12:02:18','SYNCED','0aee7d8c-1ccf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 232.10.1.1\",\"modelMatrix\":\"0.528126,-0.820693,0.218051,0,0.849166,0.510418,-0.135613,0,7.4386e-9,0.256782,0.966469,0,1.61407,-37.5502,-19.5006,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0af0067b-1ccf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0af0067b-1ccf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_0dc4f506-9fce-480c-982e-216990922429_ACT_ed8a1fc3-a794-4c54-a67e-f97b524d231f_SESS_855c3013-3b21-4f57-9d52-c7a464ee9f30_BOSC_6209ee8c-34a1-499e-b00b-1711f30ddf77_PLY_','2021-01-06 11:02:18','2019-12-12 12:01:26','0af0067b-1ccf-11ea-947d-226cec7cb58a.ply','2021-01-06 12:02:18','SYNCED','0af0067b-1ccf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 232.10.1.1\",\"modelMatrix\":\"-0.992458,0.121287,-0.017786,0,-0.122584,-0.981956,0.143998,0,3.27737e-10,0.145093,0.989418,0,-15.0188,19.9604,-23.0852,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0af92cc2-dda7-4441-8281-2da2b6ed926a','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0af92cc2-dda7-4441-8281-2da2b6ed926a.png','SNAPS','PATIENT_5eb7abc4-d0cc-450f-9e7a-604c0f9351ff_ACT_10ab35a8-5264-4163-af13-7213405a8e68_SESS_90aa3626-8319-4317-a65b-5406f818f772_BOSC_073d37c3-c84a-4a22-a7ac-4e8fd5757bba_SNAPS_','2022-03-04 13:40:23','2019-07-11 11:08:20','0af92cc2-dda7-4441-8281-2da2b6ed926a.png','2022-03-04 14:40:23','SYNCED','0af92cc2-dda7-4441-8281-2da2b6ed926a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 39.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0afed30c-4432-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0afed30c-4432-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_02187354-bba8-452a-b51b-9fdee38ff259_ACT_52815b84-f366-4ee6-a46d-a6e9066ada25_SESS_9425e6c4-f103-4ced-928e-fa239e582e3d_BOSC_72662b68-6568-4dec-9645-da3b21fbb2b2_PLY_','2020-12-16 10:52:23','2020-01-31 14:57:07','0afed30c-4432-11ea-947d-226cec7cb58a.ply','2020-12-16 11:52:23','SYNCED','0afed30c-4432-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"modelMatrix\":\"-0.863798,0.48712,-0.128711,0,-0.503838,-0.835137,0.220666,0,-4.71987e-9,0.25546,0.966819,0,-0.651488,14.7576,-24.5508,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0b036349-4432-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b036349-4432-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_02187354-bba8-452a-b51b-9fdee38ff259_ACT_52815b84-f366-4ee6-a46d-a6e9066ada25_SESS_9425e6c4-f103-4ced-928e-fa239e582e3d_BOSC_72662b68-6568-4dec-9645-da3b21fbb2b2_SNAPS_','2020-12-16 10:52:24','2020-01-31 14:57:07','0b036349-4432-11ea-947d-226cec7cb58a.png','2020-12-16 11:52:24','SYNCED','0b036349-4432-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0b04eeff-15a6-45cc-bf5b-4baa9c42ea3d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b04eeff-15a6-45cc-bf5b-4baa9c42ea3d.png','SNAPS','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_9f394a6f-c380-47c1-9eab-ff46399f6197_SESS_c9ec17f4-bf0a-492f-87da-1f7550b49119_BOSC_e0c0ae20-9b2e-46bf-936c-fada35e02d52_SNAPS_','2020-12-16 11:08:15','2020-01-21 14:31:03','0b04eeff-15a6-45cc-bf5b-4baa9c42ea3d.png','2020-12-16 12:08:15','SYNCED','0b04eeff-15a6-45cc-bf5b-4baa9c42ea3d',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0b052877-4432-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b052877-4432-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_52815b84-f366-4ee6-a46d-a6e9066ada25_SESS_9425e6c4-f103-4ced-928e-fa239e582e3d_TOSC_6bc03acb-0176-4c4c-8675-d848ebe274b8_SNAPS_','2020-12-16 10:52:24','2020-01-31 15:00:05','0b052877-4432-11ea-947d-226cec7cb58a.png','2020-12-16 11:52:24','SYNCED','0b052877-4432-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.2\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0b072065-4432-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b072065-4432-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_52815b84-f366-4ee6-a46d-a6e9066ada25_SESS_9425e6c4-f103-4ced-928e-fa239e582e3d_TOSC_6bc03acb-0176-4c4c-8675-d848ebe274b8_PLY_','2020-12-16 10:52:24','2020-01-31 15:00:05','0b072065-4432-11ea-947d-226cec7cb58a.ply','2020-12-16 11:52:24','SYNCED','0b072065-4432-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.2\",\"modelMatrix\":\"0.953728,-0.286941,0.089826,0,0.300672,0.910172,-0.284927,0,-2.68992e-9,0.298751,0.954331,0,19.8908,-32.196,-15.5893,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0b08572e-0b11-4628-babd-05a506c24060','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b08572e-0b11-4628-babd-05a506c24060.stl','STL','PATIENT_b07384f8-83d9-4f6c-859b-96adaea8e7c0_ACT_c06769e9-07b5-4084-85aa-73bd7bfc7f7b_SESS_33427a38-fc45-41ba-9b48-8437b5d15a18_BOSC_928b0458-34c3-4dc2-b7ba-8ad33d28b263_STL_','2021-08-19 22:26:58','2019-12-06 09:42:41','0b08572e-0b11-4628-babd-05a506c24060.stl','2021-08-20 00:26:58','SYNCED','0b08572e-0b11-4628-babd-05a506c24060',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 225.1.1.1\",\"modelMatrix\":\"-0.838557,0.526228,-0.14109,0,-0.544814,-0.80995,0.21716,0,-1.4875e-9,0.258968,0.965886,0,-7.8237,20.7557,-18.7482,1\",\"title\":\"MANDIBULE STL\"}'),(2,'0b2baa94-4781-4b84-b73e-36c352bc2454','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b2baa94-4781-4b84-b73e-36c352bc2454.ply','PLY','PATIENT_373efe94-53bb-432c-a2ed-a739e05b9789_ACT_1205fdc3-20e3-46cd-9d9e-df0aab481b6b_SESS_ddaac425-10bf-47b8-986b-406244cbf15f_TOSC_763c476b-a024-4cc6-ac33-f598773d84db_PLY_','2020-12-16 11:08:15','2020-01-21 13:43:08','0b2baa94-4781-4b84-b73e-36c352bc2454.ply','2020-12-16 12:08:15','SYNCED','0b2baa94-4781-4b84-b73e-36c352bc2454',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.1.1.1.1\",\"modelMatrix\":\"0.612646,-0.7273,0.309353,0,0.790357,0.563767,-0.239795,0,-1.72881e-9,0.391409,0.920217,0,1.55771,-31.3894,-15.1173,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0b3b84de-aba0-44cd-9dd7-b1579b305d30','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b3b84de-aba0-44cd-9dd7-b1579b305d30.png','SNAPS','PATIENT_7da1c98d-8103-4b55-a8f3-84a1ce2c951b_ACT_0559baca-076e-4d10-b98d-839b7104e5e1_SESS_4a20a374-7067-4593-a215-f2557a95fac7_TOSC_09eed85a-5f33-4efb-b954-ac02193fa2c0_SNAPS_','2022-02-07 12:37:54','2019-11-27 10:14:43','0b3b84de-aba0-44cd-9dd7-b1579b305d30.png','2022-02-07 13:37:54','SYNCED','0b3b84de-aba0-44cd-9dd7-b1579b305d30',0,'2022-02-07 13:37:54','','','{\"displayTitle\":\"MAXILLAIRE 211.3.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0b41d10e-b38b-4d04-adaf-1257f8ee0909','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b41d10e-b38b-4d04-adaf-1257f8ee0909.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_d0f20639-a432-47cd-9454-251a59a1e0c9_SESS_b6dc05a1-1fb1-4be1-9a88-e217ff97bec5_TOSC_55edd8f6-6615-4786-aa85-aaeb006076a6_PLY_','2020-12-08 17:26:56','2020-06-17 16:59:37','0b41d10e-b38b-4d04-adaf-1257f8ee0909.ply','2020-12-08 18:26:56','SYNCED','0b41d10e-b38b-4d04-adaf-1257f8ee0909',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.58.1.1\",\"modelMatrix\":\"0.261294,-0.942155,0.209928,0,0.965259,0.25504,-0.0568273,0,-5.36025e-9,0.217484,0.976064,0,-16.4813,-32.5088,-14.9848,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0b58abba-2429-4b5c-9908-279936772e7f','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b58abba-2429-4b5c-9908-279936772e7f.png','SNAPS','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_BOSC_f2c387e7-d80a-4eb5-83bb-7389bfba262a_SNAPS_','2021-12-30 18:03:19','2019-11-14 14:06:05','0b58abba-2429-4b5c-9908-279936772e7f.png','2021-12-30 19:03:19','SYNCED','0b58abba-2429-4b5c-9908-279936772e7f',0,NULL,'','','{\"displayTitle\":\"Mandibola 0\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0b6a859d-0537-427e-8475-f78d8635a6e7','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b6a859d-0537-427e-8475-f78d8635a6e7.png','SNAPS','PATIENT_79d89cb8-7533-4691-ae26-03fb32120e14_ACT_b7fb2f2e-15a1-423d-9ec6-5cd6b7c3b3df_SESS_71ea43ce-6134-4395-adb6-356a0a54fc0d_BOSC_9e97800a-23cd-4169-a16d-dfb593a68d22_SNAPS_','2021-08-19 22:26:59','2019-12-05 16:20:59','0b6a859d-0537-427e-8475-f78d8635a6e7.png','2021-08-20 00:26:59','SYNCED','0b6a859d-0537-427e-8475-f78d8635a6e7',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 224.2.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0b7e2a2b-5d58-45fb-b1f8-6879ab11907a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b7e2a2b-5d58-45fb-b1f8-6879ab11907a.ply','PLY','PATIENT_84817142-00fa-404c-bc75-3c1bd55648b7_ACT_14643d0c-fc35-45b4-a60e-26d206653526_SESS_833387df-f92e-416d-ae3b-2e3142fb69b7_BOSC_c5d598e8-9735-4593-bfb5-1db057ca39c5_PLY_','2021-08-19 22:27:00','2019-11-27 15:46:20','0b7e2a2b-5d58-45fb-b1f8-6879ab11907a.ply','2021-08-20 00:27:00','SYNCED','0b7e2a2b-5d58-45fb-b1f8-6879ab11907a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 214.1.1.1\",\"modelMatrix\":\"0.80106,0.594921,-0.0661184,0,-0.598584,0.796158,-0.0884835,0,7.48337e-10,0.110458,0.993881,0,17.6514,-9.67322,-19.9118,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0b8e31a8-2600-4d81-84c2-d7d22dc6cd2e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b8e31a8-2600-4d81-84c2-d7d22dc6cd2e.ply','PLY','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_db56cba1-23ff-48bf-b86e-4ceff749087f_BOSC_deb9190a-00b3-492c-b89c-ef991e01aea9_PLY_','2021-12-30 18:03:19','2019-11-14 16:17:04','0b8e31a8-2600-4d81-84c2-d7d22dc6cd2e.ply','2021-12-30 19:03:19','SYNCED','0b8e31a8-2600-4d81-84c2-d7d22dc6cd2e',0,NULL,'','','{\"displayTitle\":\"Mandibola 0\",\"modelMatrix\":\"-0.999059,-0.0412759,0.0133204,0,0.043372,-0.950775,0.306832,0,-6.57848e-10,0.307121,0.951671,0,-17.8359,10.6222,-25.5632,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0b8fc569-6e23-4cee-ade6-f4aea247fe97','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b8fc569-6e23-4cee-ade6-f4aea247fe97.stl','STL','PATIENT_cadfb79e-7de5-4015-97e3-269a77999943_ACT_087c4066-ec0b-4035-93aa-10a106e71f3b_SESS_e1ed2519-b566-46fa-a753-50431597c10e_BOSC_4fd01687-5e39-44cf-a8ab-2b5bb73babf9_STL_','2021-12-30 18:03:20','2019-11-05 14:19:36','0b8fc569-6e23-4cee-ade6-f4aea247fe97.stl','2021-12-30 19:03:20','SYNCED','0b8fc569-6e23-4cee-ade6-f4aea247fe97',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.2.1.3\",\"modelMatrix\":\"-0.992812,0.112429,-0.0410465,0,-0.119688,-0.932602,0.340481,0,5.5892e-10,0.342947,0.939355,0,-18.6668,10.2624,-15.7975,1\",\"title\":\"MANDIBULE STL\"}'),(2,'0b99e236-a963-4406-bf18-15f43d76a7cb','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b99e236-a963-4406-bf18-15f43d76a7cb.ply','PLY','PATIENT_4d2ff420-445f-4f6c-a090-c3b148f59e55_ACT_14aea70f-0403-40a0-b351-d60d5b01eb39_SESS_87409468-4c74-49d2-a719-0a27a09993ae_TOSC_b13a5f4c-b98d-4e1c-9490-ec61643df6e8_PLY_','2021-12-30 18:03:20','2019-11-21 09:56:09','0b99e236-a963-4406-bf18-15f43d76a7cb.ply','2021-12-30 19:03:20','SYNCED','9a80f1f9-0a45-431b-84cc-c5ab41051930',1,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 207.6.1.1\",\"modelMatrix\":\"0.515463,-0.799056,0.309529,0,0.856912,0.48066,-0.186193,0,-1.84802e-9,0.361214,0.932483,0,-6.60408,-39.4109,-23.0604,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0ba3eb1b-ca69-443f-b1f4-27de053c4875','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0ba3eb1b-ca69-443f-b1f4-27de053c4875.ply','PLY','PATIENT_fd4825c4-beed-452a-8641-25e55e983249_ACT_855e8123-60a7-46bf-bbe7-5b619e7e3c83_SESS_c128ff5c-e71a-4dbf-a87d-029519b521d9_TOSC_df9431b2-2fe3-4aea-a54f-e4072dcbfdfc_PLY_','2020-12-08 17:26:59','2020-06-17 11:47:50','0ba3eb1b-ca69-443f-b1f4-27de053c4875.ply','2020-12-08 18:26:59','SYNCED','0ba3eb1b-ca69-443f-b1f4-27de053c4875',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.51.1.1\",\"modelMatrix\":\"0.277343,-0.929712,0.242315,0,0.960771,0.268377,-0.0699484,0,-2.97217e-9,0.252209,0.967673,0,-8.23271,-33.3182,-12.0221,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0ba7c697-3236-429d-9a81-5cd3d9738593','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0ba7c697-3236-429d-9a81-5cd3d9738593.png','SNAPS','PATIENT_ebaef17c-16cb-4f80-a524-d7025782104f_ACT_7398381b-4b26-49ad-bbe4-521897a13cfc_SESS_76113035-010d-4824-86c8-ba584465891c_BOSC_8edd8e97-b515-4712-b72c-07e34bbb0d12_SNAPS_','2022-02-01 11:47:28','2019-07-19 12:05:16','0ba7c697-3236-429d-9a81-5cd3d9738593.png','2022-02-01 12:47:28','SYNCED','0ba7c697-3236-429d-9a81-5cd3d9738593',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 100.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0ba96783-3cfc-430b-aad8-ce9f7dc69393','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0ba96783-3cfc-430b-aad8-ce9f7dc69393.ply','PLY','PATIENT_4d2e9fca-544c-4fb9-85f2-602ba219c257_ACT_a78bfdb6-db3d-4c2d-aefa-ac2518575b04_SESS_86e9b775-4bce-49b9-990c-987afc4d07b2_BOSC_07a2bb3b-0b56-42e5-86ff-ba5851b33c0a_PLY_','2022-02-01 11:47:29','2019-07-15 10:40:43','0ba96783-3cfc-430b-aad8-ce9f7dc69393.ply','2022-02-01 12:47:29','SYNCED','0ba96783-3cfc-430b-aad8-ce9f7dc69393',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 61.1.1.1\",\"modelMatrix\":\"0.284999,0.95791,-0.0344173,0,-0.958528,0.284816,-0.0102333,0,3.89863e-10,0.0359064,0.999355,0,20.2451,11.1207,-24.5276,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0ba98f2a-c390-4f2f-98bb-69118cc65cb5','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0ba98f2a-c390-4f2f-98bb-69118cc65cb5.png','SNAPS','PATIENT_24508ae5-050d-4367-a6bf-e8b3afbe9bd4_ACT_69dea633-e25c-4e85-87a6-e51ed662f863_SESS_0212c0aa-313c-4751-acec-87455cd29190_TOSC_30539282-2b84-4eac-984b-c59ed72c5e96_SNAPS_','2021-12-30 18:03:20','2019-10-09 12:07:56','0ba98f2a-c390-4f2f-98bb-69118cc65cb5.png','2021-12-30 19:03:20','SYNCED','0ba98f2a-c390-4f2f-98bb-69118cc65cb5',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 183.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0bab1881-6303-4a0e-98a5-12baee15b775','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bab1881-6303-4a0e-98a5-12baee15b775.png','SNAPS','PATIENT_0bec7ef8-f644-4d84-a2ed-56f8f1364672_ACT_a78941e1-e63b-4f03-84db-3c4fcdb64d89_SESS_caf59252-3532-421e-9b72-5abe78045a36_TOSC_38bb1323-feb0-4bb1-8cda-5daf12e12eed_SNAPS_','2020-12-16 10:52:27','2020-02-20 15:01:23','0bab1881-6303-4a0e-98a5-12baee15b775.png','2020-12-16 11:52:27','SYNCED','0bab1881-6303-4a0e-98a5-12baee15b775',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0bbfc511-a30e-4e3c-aa07-087b335b578d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bbfc511-a30e-4e3c-aa07-087b335b578d.ply','PLY','PATIENT_8892a729-7b98-4726-983e-ec6c473dd682_ACT_e46254d7-795e-424f-a471-1b87c829a36f_SESS_8daa3164-f6a4-4b97-ba38-aecfd72f5632_TOSC_c6fc7f3a-ee08-4834-b1ce-bcb8a5fd6fba_PLY_','2020-12-16 10:52:27','2020-02-14 14:43:08','0bbfc511-a30e-4e3c-aa07-087b335b578d.ply','2020-12-16 11:52:27','SYNCED','0bbfc511-a30e-4e3c-aa07-087b335b578d',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"modelMatrix\":\"0.568058,-0.811431,0.137443,0,0.822989,0.56008,-0.094868,0,2.47527e-9,0.167004,0.985956,0,-0.876338,-36.6533,-14.0626,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0bc111fa-beaf-46a2-91be-1662bc947dd6','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bc111fa-beaf-46a2-91be-1662bc947dd6.png','SNAPS','PATIENT_5d30a2cb-9ff4-4a6a-a943-84be7cc64b67_ACT_d1d4ebb3-1d3e-4726-a8be-9860f3742ec4_SESS_895f4d84-2131-429b-842c-38796c8f28d2_TOSC_fdb713d3-b366-4f63-b65e-83c72fa9ae2c_SNAPS_','2022-03-04 13:40:23','2019-07-10 09:03:22','0bc111fa-beaf-46a2-91be-1662bc947dd6.png','2022-03-04 14:40:23','SYNCED','5bd6f1d5-33cf-4e79-b057-9bc309f51770',1,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 15.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0bc2ec9a-4e76-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bc2ec9a-4e76-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_e67c44fa-320d-4cec-929c-0fac66b8a7ca_SESS_584f4de7-5dda-471a-8bd1-a202eb080ef8_TOSC_2ba7bd87-daec-4f84-8049-a1f5d84c1280_PLY_','2020-12-16 10:52:28','2020-02-12 15:10:21','0bc2ec9a-4e76-11ea-947d-226cec7cb58a.ply','2020-12-16 11:52:28','SYNCED','0bc2ec9a-4e76-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.3\",\"modelMatrix\":\"0.593925,-0.79189,0.141996,0,0.80452,0.584601,-0.104827,0,-5.06499e-9,0.176498,0.984301,0,-2.50945,-35.0588,-15.1893,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0bc6f2d5-4e76-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bc6f2d5-4e76-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_e67c44fa-320d-4cec-929c-0fac66b8a7ca_SESS_584f4de7-5dda-471a-8bd1-a202eb080ef8_TOSC_2ba7bd87-daec-4f84-8049-a1f5d84c1280_SNAPS_','2020-12-16 10:52:28','2020-02-12 15:10:21','0bc6f2d5-4e76-11ea-947d-226cec7cb58a.png','2020-12-16 11:52:28','SYNCED','0bc6f2d5-4e76-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.3\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0bc8c522-4e76-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bc8c522-4e76-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_e67c44fa-320d-4cec-929c-0fac66b8a7ca_SESS_584f4de7-5dda-471a-8bd1-a202eb080ef8_BOSC_a839179b-0053-4b45-954c-a0b9c9e06bd4_SNAPS_','2020-12-16 10:52:28','2020-02-12 10:43:23','0bc8c522-4e76-11ea-947d-226cec7cb58a.png','2020-12-16 11:52:28','SYNCED','0bc8c522-4e76-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0bc9cb6d-ac4a-4b45-bcad-c833102de033','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bc9cb6d-ac4a-4b45-bcad-c833102de033.stl','STL','PATIENT_61967112-3a78-48fd-bc51-0c68d4fe392d_ACT_41259790-3c8e-4f1f-ac65-03a90c5da37b_SESS_85c43b2b-59af-425b-82b7-7afb265e62f2_TOSC_9ac76aa6-15c9-4d28-aa8f-771eaacb5e63_STL_','2021-12-30 18:03:21','2019-11-22 08:02:51','0bc9cb6d-ac4a-4b45-bcad-c833102de033.stl','2021-12-30 19:03:21','SYNCED','0bc9cb6d-ac4a-4b45-bcad-c833102de033',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 202.4.1.1\",\"modelMatrix\":\"0.643115,-0.717199,0.268383,0,0.76577,0.602323,-0.225396,0,8.23696e-9,0.350475,0.936572,0,-1.42724,-37.9988,-20.7265,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'0bcc4090-4e76-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bcc4090-4e76-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_e67c44fa-320d-4cec-929c-0fac66b8a7ca_SESS_584f4de7-5dda-471a-8bd1-a202eb080ef8_BOSC_a839179b-0053-4b45-954c-a0b9c9e06bd4_PLY_','2020-12-16 10:52:29','2020-02-12 10:43:23','0bcc4090-4e76-11ea-947d-226cec7cb58a.ply','2020-12-16 11:52:29','SYNCED','0bcc4090-4e76-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"modelMatrix\":\"-0.624188,0.772523,-0.116608,0,-0.781274,-0.617196,0.093162,0,4.23084e-9,0.149253,0.988799,0,6.53274,19.1368,-15.6158,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0bdfda11-aaf2-48f6-88a5-d3b086210608','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bdfda11-aaf2-48f6-88a5-d3b086210608.stl','STL','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_fd694b3f-abde-4e46-91f7-7c62bfdcafa4_SESS_73a3f5b9-e905-4911-a163-2022e1de3380_TOSC_457a2de3-d779-43f0-a00d-b2e6ff55cf7a_STL_','2021-08-19 22:27:06','2019-11-26 16:43:24','0bdfda11-aaf2-48f6-88a5-d3b086210608.stl','2021-08-20 00:27:06','SYNCED','0bdfda11-aaf2-48f6-88a5-d3b086210608',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"modelMatrix\":\"0.818284,-0.543486,0.187172,0,0.574814,0.773688,-0.266452,0,-1.39837e-9,0.325622,0.9455,0,13.2322,-32.4371,-9.58114,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'0be2ba47-6397-47d5-b9a8-80de61e83cb1','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0be2ba47-6397-47d5-b9a8-80de61e83cb1.ply','PLY','PATIENT_60337f02-8dc5-49ce-b0bb-1548b081473d_ACT_21efaafa-313e-4152-b6df-df2a1f68fd61_SESS_4bc32c9d-46a9-4dcc-9d12-f6e805212837_TOSC_9bf554d7-2ad7-46ce-8daf-0e2cddda153d_PLY_','2022-02-01 11:47:30','2019-09-19 11:43:22','0be2ba47-6397-47d5-b9a8-80de61e83cb1.ply','2022-02-01 12:47:30','SYNCED','0be2ba47-6397-47d5-b9a8-80de61e83cb1',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 154.1.1.1\",\"modelMatrix\":\"0.613971,-0.717439,0.329121,0,0.789328,0.558053,-0.256004,0,8.15742e-10,0.416963,0.908923,0,-4.20645,-38.7581,-20.2512,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0be63229-a7c0-4cb6-8f9c-8e8509dff31a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0be63229-a7c0-4cb6-8f9c-8e8509dff31a.png','SNAPS','PATIENT_cbd259d8-b167-4ae5-b02e-593bafa6de29_ACT_950b6d17-2c4c-4052-969e-e70f65959620_SESS_7f9de4d9-f433-4a03-a9d6-dc607602722c_BOSC_1a254ae0-0561-4e8f-b72b-420fd73295a2_SNAPS_','2021-01-06 11:02:52','2019-12-13 16:18:00','0be63229-a7c0-4cb6-8f9c-8e8509dff31a.png','2021-01-06 12:02:52','SYNCED','0be63229-a7c0-4cb6-8f9c-8e8509dff31a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 232.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0bee1206-bf5a-4e13-9d6e-0a26614de441','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bee1206-bf5a-4e13-9d6e-0a26614de441.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_2bed089e-68c3-431b-99b5-222a86530979_PLY_','2020-12-16 11:08:19','2020-01-24 14:18:24','0bee1206-bf5a-4e13-9d6e-0a26614de441.ply','2020-12-16 12:08:19','SYNCED','0bee1206-bf5a-4e13-9d6e-0a26614de441',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.17\",\"modelMatrix\":\"-0.908515,0.388306,-0.154331,0,-0.417851,-0.844276,0.335556,0,-1.75121e-8,0.369345,0.929292,0,-7.51411,22.2665,-17.6662,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0bf8cf83-d5fb-41ae-8c2c-1a337e7f2bdf','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bf8cf83-d5fb-41ae-8c2c-1a337e7f2bdf.png','SNAPS','PATIENT_7ba92652-afee-4923-b0e5-5c6f639eef34_ACT_93c1572c-ea31-4ce0-b14b-8e4f7c735ddd_SESS_b63f2baa-6b1c-4cba-9fb5-a0a17d070a93_TOSC_ffefc120-28a3-4bcf-a765-da1144bf03bd_SNAPS_','2020-12-16 11:08:19','2020-01-15 14:32:58','0bf8cf83-d5fb-41ae-8c2c-1a337e7f2bdf.png','2020-12-16 12:08:19','SYNCED','0bf8cf83-d5fb-41ae-8c2c-1a337e7f2bdf',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0c08b06e-5acf-42d5-8e80-9e9b4311ed63','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c08b06e-5acf-42d5-8e80-9e9b4311ed63.png','SNAPS','PATIENT_0379f83f-2e06-4f1d-9d08-c90cd857fe89_ACT_76b3beac-11ce-4742-97fb-ea0345b94d35_SESS_49e44a0d-d303-43e0-94c7-f81e248f7980_TOSC_59c30d46-edc5-471c-be16-62769625224d_SNAPS_','2020-12-16 11:08:20','2020-01-23 14:39:53','0c08b06e-5acf-42d5-8e80-9e9b4311ed63.png','2020-12-16 12:08:20','SYNCED','0c08b06e-5acf-42d5-8e80-9e9b4311ed63',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0c1b3106-dc95-400f-adca-0f6d1860b395','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c1b3106-dc95-400f-adca-0f6d1860b395.png','SNAPS','PATIENT_96afd601-d8c2-4e20-abec-292b75f99b16_ACT_1b95d362-259d-45d0-b12b-f82c49c26c12_SESS_812c317a-661f-4f64-916c-40d448feeca0_TOSC_efb79c65-d8d5-4616-88c4-87020d1d032c_SNAPS_','2021-08-19 22:27:07','2019-12-05 15:34:21','0c1b3106-dc95-400f-adca-0f6d1860b395.png','2021-08-20 00:27:07','SYNCED','0c1b3106-dc95-400f-adca-0f6d1860b395',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 224.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0c1e2b77-6232-499e-afb7-96936d9913bc','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c1e2b77-6232-499e-afb7-96936d9913bc.png','SNAPS','PATIENT_55452abe-c899-4508-a6ad-a6862da81096_ACT_10244838-8d43-4b45-843e-1b1867b80fe9_SESS_a27242e6-79e3-49b8-9935-388a52c32306_BOSC_c8c05cc5-ac7c-4b2a-9eea-e2f370f9081e_SNAPS_','2020-12-08 17:27:04','2020-06-17 10:27:27','0c1e2b77-6232-499e-afb7-96936d9913bc.png','2020-12-08 18:27:04','SYNCED','0c1e2b77-6232-499e-afb7-96936d9913bc',0,NULL,'','','{\"displayTitle\":\"Mandibule 32.1.1.1.11\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0c2ed37b-22c6-488e-b36e-126a48f7dc9b','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c2ed37b-22c6-488e-b36e-126a48f7dc9b.stl','STL','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_87cb19c3-f54a-4c63-ac5f-47eef98d329e_SESS_d040337d-b8cd-499c-a0b9-2c3d9c4a35b7_TOSC_797d271a-88c8-4866-af1b-ff8894ed3efd_STL_','2021-12-30 18:03:21','2019-11-22 08:56:44','0c2ed37b-22c6-488e-b36e-126a48f7dc9b.stl','2021-12-30 19:03:21','SYNCED','0c2ed37b-22c6-488e-b36e-126a48f7dc9b',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 202.1.2.1\",\"modelMatrix\":\"0.707649,-0.653658,0.26826,0,0.706564,0.654663,-0.268672,0,2.23066e-9,0.379668,0.925123,0,5.9275,-38.3022,-16.0092,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'0c317f25-6317-487a-a1a9-ed4e6da002b7','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c317f25-6317-487a-a1a9-ed4e6da002b7.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_73c89c5c-4f86-40a7-8368-f41b3c1ccf7a_SESS_db9ab031-4725-4b7f-baf0-20f9e3b4911f_BOSC_23fb14cf-4c52-421e-9b80-217198438f1a_SNAPS_','2020-12-16 10:52:31','2020-05-20 17:05:29','0c317f25-6317-487a-a1a9-ed4e6da002b7.png','2020-12-16 11:52:31','SYNCED','0c317f25-6317-487a-a1a9-ed4e6da002b7',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 216.1.8.1.2\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0c45f002-a6fa-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c45f002-a6fa-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_8ca476e2-f154-4773-b8ee-bd913f841508_ACT_1a0ba8c5-d07a-459e-ab6b-3b12a8dd9c78_SESS_b98d3f70-5095-426f-882b-b559702fb364_TOSC_4025d533-0f08-4afb-b679-8aa40e41cf88_STL_','2022-02-01 11:47:30','2019-07-15 16:11:50','0c45f002-a6fa-11e9-a33b-226cec7cb58a.stl','2022-02-01 12:47:30','SYNCED','0c45f002-a6fa-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 69.1.1.1\",\"modelMatrix\":\"0.60991,-0.766529,0.201105,0,0.792471,0.589944,-0.154777,0,-4.87518e-9,0.25377,0.967265,0,-2.37103,-28.3661,-22.361,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'0c46d86f-a6fa-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c46d86f-a6fa-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_8ca476e2-f154-4773-b8ee-bd913f841508_ACT_1a0ba8c5-d07a-459e-ab6b-3b12a8dd9c78_SESS_b98d3f70-5095-426f-882b-b559702fb364_BOSC_2d5eef3f-efbe-4452-b985-bd847a341882_PLY_','2022-02-01 11:47:30','2019-07-15 16:18:37','0c46d86f-a6fa-11e9-a33b-226cec7cb58a.ply','2022-02-01 12:47:30','SYNCED','0c46d86f-a6fa-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 69.1.1.1\",\"modelMatrix\":\"0.837957,0.543912,-0.0445969,0,-0.545737,0.835154,-0.0684767,0,-4.06017e-9,0.0817187,0.996655,0,19.8578,-8.37496,-22.8433,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0c477b91-a6fa-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c477b91-a6fa-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_8ca476e2-f154-4773-b8ee-bd913f841508_ACT_1a0ba8c5-d07a-459e-ab6b-3b12a8dd9c78_SESS_b98d3f70-5095-426f-882b-b559702fb364_BOSC_2d5eef3f-efbe-4452-b985-bd847a341882_STL_','2022-02-01 11:47:30','2019-07-15 16:18:37','0c477b91-a6fa-11e9-a33b-226cec7cb58a.stl','2022-02-01 12:47:30','SYNCED','0c477b91-a6fa-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 69.1.1.1\",\"modelMatrix\":\"0.837957,0.543912,-0.0445969,0,-0.545737,0.835154,-0.0684767,0,-4.06017e-9,0.0817187,0.996655,0,19.8578,-8.37496,-22.8433,1\",\"title\":\"MANDIBULE STL\"}'),(2,'0c48725f-a6fa-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c48725f-a6fa-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_8ca476e2-f154-4773-b8ee-bd913f841508_ACT_1a0ba8c5-d07a-459e-ab6b-3b12a8dd9c78_SESS_b98d3f70-5095-426f-882b-b559702fb364_TOSC_4025d533-0f08-4afb-b679-8aa40e41cf88_PLY_','2022-02-01 11:47:31','2019-07-15 16:11:50','0c48725f-a6fa-11e9-a33b-226cec7cb58a.ply','2022-02-01 12:47:31','SYNCED','0c48725f-a6fa-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 69.1.1.1\",\"modelMatrix\":\"0.60991,-0.766529,0.201105,0,0.792471,0.589944,-0.154777,0,-4.87518e-9,0.25377,0.967265,0,-2.37103,-28.3661,-22.361,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0c491e5e-a6fa-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c491e5e-a6fa-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_8ca476e2-f154-4773-b8ee-bd913f841508_ACT_1a0ba8c5-d07a-459e-ab6b-3b12a8dd9c78_SESS_b98d3f70-5095-426f-882b-b559702fb364_TOSC_4025d533-0f08-4afb-b679-8aa40e41cf88_SNAPS_','2022-02-01 11:47:31','2019-07-15 16:11:50','0c491e5e-a6fa-11e9-a33b-226cec7cb58a.png','2022-02-01 12:47:31','SYNCED','0c491e5e-a6fa-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 69.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0c49d34f-a6fa-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c49d34f-a6fa-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_8ca476e2-f154-4773-b8ee-bd913f841508_ACT_1a0ba8c5-d07a-459e-ab6b-3b12a8dd9c78_SESS_b98d3f70-5095-426f-882b-b559702fb364_BOSC_2d5eef3f-efbe-4452-b985-bd847a341882_SNAPS_','2022-02-01 11:47:31','2019-07-15 16:18:37','0c49d34f-a6fa-11e9-a33b-226cec7cb58a.png','2022-02-01 12:47:31','SYNCED','0c49d34f-a6fa-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 69.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0c53e63e-528c-4250-b5ca-66ef16935f13','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c53e63e-528c-4250-b5ca-66ef16935f13.ply','PLY','PATIENT_2f28ecf2-8a3a-41d4-86bb-cf55c01ad025_ACT_78f6ee3e-94b9-419c-8442-ddf8e957291f_SESS_99544d16-2b44-4c4f-98f5-39f771e05aca_TOSC_ae9c9f76-fe29-4c87-818e-300ac9a5cb92_PLY_','2021-12-30 18:03:23','2019-10-17 14:01:41','0c53e63e-528c-4250-b5ca-66ef16935f13.ply','2021-12-30 19:03:23','SYNCED','0c53e63e-528c-4250-b5ca-66ef16935f13',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 192.1.1.1\",\"modelMatrix\":\"0.649646,-0.741198,0.169073,0,0.760237,0.633376,-0.144478,0,-2.45723e-10,0.222395,0.974957,0,3.93746,-32.6789,-17.2413,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0c615829-7f5b-4022-a454-b7d407305676','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c615829-7f5b-4022-a454-b7d407305676.png','SNAPS','PATIENT_ecdf47e8-c89a-46f6-90f6-5aa78020d4b4_ACT_085fdf08-d777-4c3e-bf1b-ba3c5d9a1188_SESS_e47de5cc-baee-41be-b434-97cd36e2cf62_TOSC_eab1d47f-40b8-45b2-bcdc-30a8ce009e99_SNAPS_','2020-12-23 09:08:07','2019-12-16 13:52:07','0c615829-7f5b-4022-a454-b7d407305676.png','2020-12-23 10:08:07','SYNCED','0c615829-7f5b-4022-a454-b7d407305676',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0c77a091-25e9-49fe-ad96-2d1913a47629','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c77a091-25e9-49fe-ad96-2d1913a47629.stl','STL','PATIENT_de132740-d90a-46fb-9843-ca1070f94f10_ACT_64ad6d77-7b96-44e1-932d-0031115fd156_SESS_bb5725cd-9c7f-452c-a8b4-0cb1c79cef27_TOSC_c93ccf4d-eb64-44f1-b9fa-036840d78ee2_STL_','2022-03-04 13:40:23','2019-07-08 16:19:23','0c77a091-25e9-49fe-ad96-2d1913a47629.stl','2022-03-04 14:40:23','SYNCED','0c77a091-25e9-49fe-ad96-2d1913a47629',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 5.2.1.1\",\"modelMatrix\":\"0.773297,0.595388,-0.218002,0,-0.634044,0.726151,-0.265881,0,-6.56596e-9,0.343828,0.939033,0,-5.15819,-34.3656,-18.2744,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'0c7bf196-452a-49fb-89bb-0ebdfe33bd53','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c7bf196-452a-49fb-89bb-0ebdfe33bd53.png','SNAPS','PATIENT_f366662e-4444-4f1a-a132-37b6d8ecc850_ACT_35cae365-54c2-448f-a188-26c90d41bb9d_SESS_9b59de13-1b53-468a-9aab-438a223015c1_BOSC_3febb610-b690-430f-85e8-01026217f82a_SNAPS_','2022-02-01 11:47:31','2019-10-02 11:58:56','0c7bf196-452a-49fb-89bb-0ebdfe33bd53.png','2022-02-01 12:47:31','SYNCED','0c7bf196-452a-49fb-89bb-0ebdfe33bd53',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 173.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0c7d52f7-c2a2-4649-b100-d89ea67d13d9','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c7d52f7-c2a2-4649-b100-d89ea67d13d9.ply','PLY','PATIENT_e7a45a68-ba38-4e97-bfd2-34fd3e8d0d4a_ACT_ebf70c6b-8993-444f-b73a-7b93ad4320dc_SESS_d591e9f4-fee5-48a1-bf3f-02ffa1a384cc_TOSC_201fd16e-db34-4267-a853-bdfdf68f9fa4_PLY_','2022-03-04 13:40:23','2019-07-10 17:50:52','0c7d52f7-c2a2-4649-b100-d89ea67d13d9.ply','2022-03-04 14:40:23','SYNCED','0c7d52f7-c2a2-4649-b100-d89ea67d13d9',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 35.1.1.1\",\"modelMatrix\":\"0.536438,-0.798106,0.274337,0,0.843939,0.507305,-0.174378,0,-6.00634e-9,0.325067,0.945691,0,-0.0281093,-41.6067,-18.5317,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0c84ebf8-f6e6-4b12-ae0f-288e45160496','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c84ebf8-f6e6-4b12-ae0f-288e45160496.png','SNAPS','PATIENT_4ed0364e-d067-4452-8839-8e909c61b1ea_ACT_439d6b4b-8f66-4316-a9b9-00cd70637694_SESS_14bc0526-ec82-440b-a6a4-b544d274a55b_TOSC_c880d341-0837-4d73-9aaa-da9b4f978b1d_SNAPS_','2020-12-08 17:27:07','2020-06-08 10:18:25','0c84ebf8-f6e6-4b12-ae0f-288e45160496.png','2020-12-08 18:27:07','SYNCED','0c84ebf8-f6e6-4b12-ae0f-288e45160496',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.29.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0cb0199e-ac79-40a3-b817-44757893bfe2','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cb0199e-ac79-40a3-b817-44757893bfe2.stl','STL','PATIENT_e54147b7-fada-4c55-bff0-b2e1d5220517_ACT_2195a047-9f4e-4d6a-91a6-76e7d65445d7_SESS_c0d7afbe-1996-4b7b-a52f-1a475877cc5f_BOSC_0eb647a5-f323-4df2-a962-e0baa4732bd7_STL_','2021-01-06 11:02:56','2019-12-12 15:06:02','0cb0199e-ac79-40a3-b817-44757893bfe2.stl','2021-01-06 12:02:56','SYNCED','0cb0199e-ac79-40a3-b817-44757893bfe2',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 232.16.1.1\",\"modelMatrix\":\"-0.998738,-0.0486526,0.0124307,0,0.0502155,-0.967653,0.247235,0,3.26126e-10,0.247547,0.968876,0,-11.8928,12.3194,-21.409,1\",\"title\":\"MANDIBULE STL\"}'),(2,'0cb03e33-4681-4d07-9c9c-5f6f59eb7e80','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cb03e33-4681-4d07-9c9c-5f6f59eb7e80.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_0d77e86e-ff82-4aeb-baf6-8263e4f9c8d4_SESS_8e2af3be-39ab-4c2e-8dd5-7a8294818783_BOSC_2cc88ae5-0c77-4f32-9fb0-1f9669803234_PLY_','2020-12-16 10:52:34','2020-05-20 11:22:04','0cb03e33-4681-4d07-9c9c-5f6f59eb7e80.ply','2020-12-16 11:52:34','SYNCED','0cb03e33-4681-4d07-9c9c-5f6f59eb7e80',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 216.1.1.1.1\",\"modelMatrix\":\"0.828724,0.55577,-0.0658566,0,-0.559658,0.822966,-0.0975183,0,6.2995e-9,0.117673,0.993052,0,20.6538,-7.21197,-17.6945,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0cc8b930-1c49-40f4-849f-25c5ab4b41ce','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cc8b930-1c49-40f4-849f-25c5ab4b41ce.ply','PLY','PATIENT_72f539f4-2d06-47fa-b0b8-1291879a4818_ACT_d55baca2-6f09-4446-a148-dcdcfcaf57d8_SESS_5efdc987-8bdd-454f-b282-82efcf807bae_TOSC_d4b9e0ad-bc1d-4120-8cc6-d9bbcfa6e59e_PLY_','2021-08-19 22:27:15','2019-11-26 11:54:50','0cc8b930-1c49-40f4-849f-25c5ab4b41ce.ply','2021-08-20 00:27:15','SYNCED','0cc8b930-1c49-40f4-849f-25c5ab4b41ce',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 86.1.1.1.1\",\"modelMatrix\":\"-0.0622311,-0.963833,0.259139,0,0.998062,-0.0600968,0.0161578,0,-1.30401e-9,0.259642,0.965705,0,-18.9601,-24.0529,-25.4983,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0cce8376-2d3f-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cce8376-2d3f-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_c4b2ab75-de84-4ead-837c-d8e600b338c4_SESS_4576ed53-a7e8-4fb1-a55f-f2d13c3acb65_BOSC_dac163bd-d09c-4923-afcb-5ed73f7f4734_PLY_','2020-12-23 09:08:09','2020-01-02 10:05:09','0cce8376-2d3f-11ea-947d-226cec7cb58a.ply','2020-12-23 10:08:09','SYNCED','0cce8376-2d3f-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"modelMatrix\":\"-0.96203,0.269205,-0.0450329,0,-0.272945,-0.948845,0.158724,0,-2.34857e-10,0.164989,0.986295,0,-14.5519,22.5128,-14.11,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0cd01242-2d3f-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cd01242-2d3f-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_dd21fc57-5706-4bab-afe0-722c1578f1f6_ACT_c4b2ab75-de84-4ead-837c-d8e600b338c4_SESS_4576ed53-a7e8-4fb1-a55f-f2d13c3acb65_TOSC_4dd88361-dbce-44b6-a693-7c5311fc4b07_PLY_','2020-12-23 09:08:09','2020-01-02 10:01:25','0cd01242-2d3f-11ea-947d-226cec7cb58a.ply','2020-12-23 10:08:09','SYNCED','0cd01242-2d3f-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"modelMatrix\":\"0.727828,-0.61277,0.307863,0,0.68576,0.65036,-0.326749,0,-2.1555e-9,0.448937,0.893563,0,6.39389,-28.6894,-19.2638,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0cd19247-2d3f-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cd19247-2d3f-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_c4b2ab75-de84-4ead-837c-d8e600b338c4_SESS_4576ed53-a7e8-4fb1-a55f-f2d13c3acb65_BOSC_dac163bd-d09c-4923-afcb-5ed73f7f4734_SNAPS_','2020-12-23 09:08:10','2020-01-02 10:05:09','0cd19247-2d3f-11ea-947d-226cec7cb58a.png','2020-12-23 10:08:10','SYNCED','0cd19247-2d3f-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0cd3a14a-247c-4e87-ae56-840b04ecce06','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cd3a14a-247c-4e87-ae56-840b04ecce06.png','SNAPS','PATIENT_9243b0db-6a51-43bc-9684-db6d75efe77d_ACT_f25f7924-fb03-4ba2-96c4-c2b66c61bc2d_SESS_c577848c-5e45-4e04-af91-d3c2810d2480_BOSC_ee921a4a-bb66-44f1-a13f-786c6fe9e5cd_SNAPS_','2022-03-04 13:40:23','2019-07-10 12:07:50','0cd3a14a-247c-4e87-ae56-840b04ecce06.png','2022-03-04 14:40:23','SYNCED','0cd3a14a-247c-4e87-ae56-840b04ecce06',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 26.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0cd64172-2d3f-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cd64172-2d3f-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_dd21fc57-5706-4bab-afe0-722c1578f1f6_ACT_c4b2ab75-de84-4ead-837c-d8e600b338c4_SESS_4576ed53-a7e8-4fb1-a55f-f2d13c3acb65_TOSC_4dd88361-dbce-44b6-a693-7c5311fc4b07_SNAPS_','2020-12-23 09:08:10','2020-01-02 10:01:25','0cd64172-2d3f-11ea-947d-226cec7cb58a.png','2020-12-23 10:08:10','SYNCED','0cd64172-2d3f-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0cda629b-6aff-479e-826f-f453629054f1','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cda629b-6aff-479e-826f-f453629054f1.ply','PLY','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_d711943f-43de-4c7a-91a9-6cbafd17a8f3_SESS_77d93af5-856f-466b-b06f-025212b773a8_BOSC_18945b15-c41e-44f3-9d15-747d7ff88e9d_PLY_','2020-12-23 09:08:10','2019-12-20 13:59:47','0cda629b-6aff-479e-826f-f453629054f1.ply','2020-12-23 10:08:10','SYNCED','0cda629b-6aff-479e-826f-f453629054f1',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"modelMatrix\":\"-0.712111,0.664676,-0.22606,0,-0.702067,-0.674186,0.229294,0,-6.27336e-9,0.321992,0.946743,0,1.81909,18.8773,-20.6364,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0cde93fe-f762-4d72-ac90-bf56c1a85e2a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cde93fe-f762-4d72-ac90-bf56c1a85e2a.png','SNAPS','PATIENT_1d3a5311-b69a-4276-8b4a-369d086f6371_ACT_28ab8610-8893-458c-8518-76753ca69a12_SESS_79751b02-c9d7-4b56-93d1-2104702255fc_TOSC_1db7a6a6-6a80-4ca5-aa44-23d538f2db22_SNAPS_','2022-02-01 11:47:32','2019-07-29 11:10:59','0cde93fe-f762-4d72-ac90-bf56c1a85e2a.png','2022-02-01 12:47:32','SYNCED','0cde93fe-f762-4d72-ac90-bf56c1a85e2a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 115.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0cfc3f89-06a6-483e-90a0-2b1d60a8ede0','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cfc3f89-06a6-483e-90a0-2b1d60a8ede0.png','SNAPS','PATIENT_7afceb75-c859-449d-98fc-db1d3941b795_ACT_43f2649c-a6d8-46e8-9a60-f6c6e927308f_SESS_6724c6e2-b258-4fed-8224-afbb51fadbe9_TOSC_585ef489-0439-4c6c-a2b8-503d9056495d_SNAPS_','2022-02-01 11:47:32','2019-07-22 16:50:56','0cfc3f89-06a6-483e-90a0-2b1d60a8ede0.png','2022-02-01 12:47:32','SYNCED','0cfc3f89-06a6-483e-90a0-2b1d60a8ede0',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 108.2.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0d13a711-d28d-4d0f-ae15-a0de1173508a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d13a711-d28d-4d0f-ae15-a0de1173508a.stl','STL','PATIENT_e2ad6866-17be-4ec9-ace3-df2075baed98_ACT_628664ea-6869-485b-9c25-5b14151d796d_SESS_fbdbf097-6fee-4478-995f-6221a0d4627a_TOSC_b4e1ae2c-0f1b-44b1-b43f-287c75583c96_STL_','2021-01-06 11:02:57','2019-12-13 15:00:07','0d13a711-d28d-4d0f-ae15-a0de1173508a.stl','2021-01-06 12:02:57','SYNCED','0d13a711-d28d-4d0f-ae15-a0de1173508a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 232.21.1.1\",\"modelMatrix\":\"0.346437,-0.905252,0.245969,0,0.938073,0.334316,-0.0908383,0,1.42618e-9,0.262207,0.965012,0,-10.2143,-32.7421,-18.0217,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'0d21db67-685f-47c9-89de-758bb6affea7','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d21db67-685f-47c9-89de-758bb6affea7.ply','PLY','PATIENT_9243b0db-6a51-43bc-9684-db6d75efe77d_ACT_f25f7924-fb03-4ba2-96c4-c2b66c61bc2d_SESS_c577848c-5e45-4e04-af91-d3c2810d2480_BOSC_ee921a4a-bb66-44f1-a13f-786c6fe9e5cd_PLY_','2022-03-04 13:40:24','2019-07-10 12:07:50','0d21db67-685f-47c9-89de-758bb6affea7.ply','2022-03-04 14:40:24','SYNCED','0d21db67-685f-47c9-89de-758bb6affea7',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 26.1.1.1\",\"modelMatrix\":\"0.351244,0.928713,-0.118826,0,-0.936284,0.348404,-0.0445771,0,1.42707e-9,0.126912,0.991914,0,6.81309,-34.1121,-21.355,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0d2c87ca-9482-4e4b-b974-10e379a56e3f','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d2c87ca-9482-4e4b-b974-10e379a56e3f.ply','PLY','PATIENT_bc50bff3-dacb-4f7a-a7c8-b971782c6d1d_ACT_be5de36f-b43d-47f3-b178-801c7822bb7d_SESS_df767eeb-30cd-456e-91c0-aa5269ac29d4_TOSC_5f0e526c-a0b7-4b79-a15f-cda97cb49eb9_PLY_','2021-08-19 22:27:19','2019-11-27 12:29:07','0d2c87ca-9482-4e4b-b974-10e379a56e3f.ply','2021-08-20 00:27:19','SYNCED','0d2c87ca-9482-4e4b-b974-10e379a56e3f',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 212.1.1.1\",\"modelMatrix\":\"0.476896,-0.839712,0.259721,0,0.87896,0.455601,-0.140916,0,1.05962e-8,0.295486,0.955347,0,-3.63681,-30.6605,-19.4772,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0d38bd49-36eb-4dcb-9f65-5afe4750db4c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d38bd49-36eb-4dcb-9f65-5afe4750db4c.stl','STL','PATIENT_e51cf9a2-03cb-4e48-928a-2755186e1db6_ACT_000dfdf1-07e2-4cb4-9351-56d36d0f2b2f_SESS_bcaa9cd4-a73e-45a0-aa14-14571985bf99_TOSC_4898a0f1-e758-4945-8096-35453addad4f_STL_','2022-02-01 11:47:32','2019-07-19 16:11:04','0d38bd49-36eb-4dcb-9f65-5afe4750db4c.stl','2022-02-01 12:47:32','SYNCED','0d38bd49-36eb-4dcb-9f65-5afe4750db4c',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 102.1.1.1\",\"modelMatrix\":\"0.604138,-0.726749,0.326884,0,0.796879,0.55097,-0.247821,0,1.17685e-8,0.410205,0.911993,0,4.5742,-36.6945,-23.86,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'0d39dbf2-9fc7-42d5-b54b-dc58bbde0d4e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d39dbf2-9fc7-42d5-b54b-dc58bbde0d4e.png','SNAPS','PATIENT_68ccc647-d7af-43af-b066-4950901b78bd_ACT_1bfc9ae5-42fb-4b3d-8e54-a2c849ae3d96_SESS_10597265-5639-48a6-9f49-5b6f9e85d80e_BOSC_a7acb7b8-ed11-4b6f-9278-8182955e6081_SNAPS_','2022-02-01 11:47:33','2019-09-04 10:47:41','0d39dbf2-9fc7-42d5-b54b-dc58bbde0d4e.png','2022-02-01 12:47:33','SYNCED','0d39dbf2-9fc7-42d5-b54b-dc58bbde0d4e',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 144.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0d42f8ae-4e76-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d42f8ae-4e76-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_9d457cf7-2ac5-41fa-ac28-5cc81ee6178a_SESS_234f0eb8-1a1c-45f0-a535-9f2becf0b609_BOSC_dacd7773-dda3-4729-9529-ee2868c579f7_SNAPS_','2020-12-16 10:52:37','2020-02-12 10:10:18','0d42f8ae-4e76-11ea-947d-226cec7cb58a.png','2020-12-16 11:52:37','SYNCED','0d42f8ae-4e76-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0d44a1ab-4e76-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d44a1ab-4e76-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_9d457cf7-2ac5-41fa-ac28-5cc81ee6178a_SESS_234f0eb8-1a1c-45f0-a535-9f2becf0b609_BOSC_dacd7773-dda3-4729-9529-ee2868c579f7_PLY_','2020-12-16 10:52:38','2020-02-12 10:10:18','0d44a1ab-4e76-11ea-947d-226cec7cb58a.ply','2020-12-16 11:52:38','SYNCED','0d44a1ab-4e76-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"modelMatrix\":\"-0.908043,0.405854,-0.103631,0,-0.418876,-0.879815,0.224653,0,3.82351e-9,0.247403,0.968913,0,-9.2401,22.4077,-15.7005,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0d46ab82-4e76-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d46ab82-4e76-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_9d457cf7-2ac5-41fa-ac28-5cc81ee6178a_SESS_234f0eb8-1a1c-45f0-a535-9f2becf0b609_TOSC_3ae568a6-3131-4cb5-b9ba-74b41651eee5_PLY_','2020-12-16 10:52:38','2020-02-12 11:28:29','0d46ab82-4e76-11ea-947d-226cec7cb58a.ply','2020-12-16 11:52:38','SYNCED','0d46ab82-4e76-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.2\",\"modelMatrix\":\"0.820175,-0.538746,0.192524,0,0.572113,0.772341,-0.276,0,1.42698e-8,0.336514,0.941679,0,6.48031,-31.5564,-17.9281,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0d483fc8-4e76-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d483fc8-4e76-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_9d457cf7-2ac5-41fa-ac28-5cc81ee6178a_SESS_234f0eb8-1a1c-45f0-a535-9f2becf0b609_TOSC_3ae568a6-3131-4cb5-b9ba-74b41651eee5_SNAPS_','2020-12-16 10:52:38','2020-02-12 11:28:29','0d483fc8-4e76-11ea-947d-226cec7cb58a.png','2020-12-16 11:52:38','SYNCED','0d483fc8-4e76-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.2\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0d5dbf86-47ff-47a1-a38f-5cd36955e21f','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d5dbf86-47ff-47a1-a38f-5cd36955e21f.ply','PLY','PATIENT_bfff99cf-e91f-4eed-bb3a-06bece8eaf9f_ACT_e05ca76e-09b0-4832-915f-5d8f769e2ea5_SESS_540861f8-5ba9-4984-8617-509dd1da3f0e_BOSC_07294597-d031-46fe-b79f-0c2df83c25af_PLY_','2020-12-23 09:08:12','2019-12-18 14:14:40','0d5dbf86-47ff-47a1-a38f-5cd36955e21f.ply','2020-12-23 10:08:12','SYNCED','0d5dbf86-47ff-47a1-a38f-5cd36955e21f',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 20.1.267.1.1.1\",\"modelMatrix\":\"0.56392,-0.825448,0.0250934,0,0.82583,0.563659,-0.0171351,0,-7.50406e-10,0.0303857,0.999538,0,-6.37233,-22.0449,-23.1277,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0d9782fb-6c9e-4ed2-96ef-0406fc2605d0','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d9782fb-6c9e-4ed2-96ef-0406fc2605d0.ply','PLY','PATIENT_b9c60833-03cc-4842-8403-95f28716d322_ACT_df542486-b7c1-494f-b480-9858c2859c62_SESS_344a7203-1cfa-4cc9-9e4d-99d317027314_TOSC_42dde97a-3e8e-45b1-bf8c-a2f88d4f7e64_PLY_','2020-12-16 11:08:27','2020-01-15 14:03:36','0d9782fb-6c9e-4ed2-96ef-0406fc2605d0.ply','2020-12-16 12:08:27','SYNCED','0d9782fb-6c9e-4ed2-96ef-0406fc2605d0',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.1.1.1.1\",\"modelMatrix\":\"0.240146,-0.922754,0.301422,0,0.970737,0.228276,-0.0745675,0,-1.77078e-9,0.310509,0.95057,0,-9.59377,-36.6954,-16.5549,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0d9f1486-a2e3-11e9-a33b-226cec7cb58a','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d9f1486-a2e3-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_3f00b0a8-6ea9-4cb3-8a3c-6ca3c492e30a_ACT_aa8c9e80-a350-499c-af49-e74b1d5e8f5a_SESS_aa320683-814c-4fb9-bf2f-98d908e2eef2_TOSC_b8907c0d-eb88-4b68-950c-174cb3b6f98f_PLY_','2022-03-04 13:40:24','2019-07-10 11:23:35','0d9f1486-a2e3-11e9-a33b-226cec7cb58a.ply','2022-03-04 14:40:24','SYNCED','0d9f1486-a2e3-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 24.1.1.1\",\"modelMatrix\":\"0.989387,-0.142183,0.0299455,0,0.145302,0.968148,-0.203904,0,-1.1672e-9,0.206091,0.978533,0,-30.1603,-20.7354,-14.3758,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0d9fd477-a2e3-11e9-a33b-226cec7cb58a','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d9fd477-a2e3-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_3f00b0a8-6ea9-4cb3-8a3c-6ca3c492e30a_ACT_aa8c9e80-a350-499c-af49-e74b1d5e8f5a_SESS_aa320683-814c-4fb9-bf2f-98d908e2eef2_BOSC_aaac2579-3560-4ef2-a4c0-c80d89c272d9_SNAPS_','2022-03-04 13:40:25','2019-07-10 11:26:17','0d9fd477-a2e3-11e9-a33b-226cec7cb58a.png','2022-03-04 14:40:25','SYNCED','0d9fd477-a2e3-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 24.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0da16d6c-a2e3-11e9-a33b-226cec7cb58a','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0da16d6c-a2e3-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_3f00b0a8-6ea9-4cb3-8a3c-6ca3c492e30a_ACT_aa8c9e80-a350-499c-af49-e74b1d5e8f5a_SESS_aa320683-814c-4fb9-bf2f-98d908e2eef2_TOSC_b8907c0d-eb88-4b68-950c-174cb3b6f98f_STL_','2022-03-04 13:40:25','2019-07-10 11:23:35','0da16d6c-a2e3-11e9-a33b-226cec7cb58a.stl','2022-03-04 14:40:25','SYNCED','0da16d6c-a2e3-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 24.1.1.1\",\"modelMatrix\":\"0.989387,-0.142183,0.0299455,0,0.145302,0.968148,-0.203904,0,-1.1672e-9,0.206091,0.978533,0,-30.1603,-20.7354,-14.3758,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'0da31c2f-a2e3-11e9-a33b-226cec7cb58a','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0da31c2f-a2e3-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_3f00b0a8-6ea9-4cb3-8a3c-6ca3c492e30a_ACT_aa8c9e80-a350-499c-af49-e74b1d5e8f5a_SESS_aa320683-814c-4fb9-bf2f-98d908e2eef2_BOSC_aaac2579-3560-4ef2-a4c0-c80d89c272d9_STL_','2022-03-04 13:40:25','2019-07-10 11:26:17','0da31c2f-a2e3-11e9-a33b-226cec7cb58a.stl','2022-03-04 14:40:25','SYNCED','0da31c2f-a2e3-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 24.1.1.1\",\"modelMatrix\":\"-0.73338,-0.658398,0.16931,0,0.679819,-0.710271,0.18265,0,-9.67868e-9,0.249052,0.96849,0,13.1017,28.833,-17.587,1\",\"title\":\"MANDIBULE STL\"}'),(2,'0da4b31a-a2e3-11e9-a33b-226cec7cb58a','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0da4b31a-a2e3-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_3f00b0a8-6ea9-4cb3-8a3c-6ca3c492e30a_ACT_aa8c9e80-a350-499c-af49-e74b1d5e8f5a_SESS_aa320683-814c-4fb9-bf2f-98d908e2eef2_TOSC_b8907c0d-eb88-4b68-950c-174cb3b6f98f_SNAPS_','2022-03-04 13:40:25','2019-07-10 11:23:35','0da4b31a-a2e3-11e9-a33b-226cec7cb58a.png','2022-03-04 14:40:25','SYNCED','0da4b31a-a2e3-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 24.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0da55d90-a2e3-11e9-a33b-226cec7cb58a','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0da55d90-a2e3-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_3f00b0a8-6ea9-4cb3-8a3c-6ca3c492e30a_ACT_aa8c9e80-a350-499c-af49-e74b1d5e8f5a_SESS_aa320683-814c-4fb9-bf2f-98d908e2eef2_BOSC_aaac2579-3560-4ef2-a4c0-c80d89c272d9_PLY_','2022-03-04 13:40:25','2019-07-10 11:26:17','0da55d90-a2e3-11e9-a33b-226cec7cb58a.ply','2022-03-04 14:40:25','SYNCED','0da55d90-a2e3-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 24.1.1.1\",\"modelMatrix\":\"-0.73338,-0.658398,0.16931,0,0.679819,-0.710271,0.18265,0,-9.67868e-9,0.249052,0.96849,0,13.1017,28.833,-17.587,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0da97ae5-8c29-47d1-b476-1dc819c2ad5a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0da97ae5-8c29-47d1-b476-1dc819c2ad5a.png','SNAPS','PATIENT_6023972b-e8b9-49bf-9549-4359624cbf73_ACT_d0e3cbf3-3c30-45f2-a815-a498ea7935eb_SESS_498b8e88-42c8-4a38-bb1f-31e9e8b89a70_BOSC_f4ee1bd8-10c0-4055-b2b1-6cde530699a9_SNAPS_','2021-12-30 18:03:27','2019-10-10 14:40:38','0da97ae5-8c29-47d1-b476-1dc819c2ad5a.png','2021-12-30 19:03:27','SYNCED','0da97ae5-8c29-47d1-b476-1dc819c2ad5a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 185.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0db1079f-d9ed-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0db1079f-d9ed-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_f8f4fd0f-dc97-4b11-9286-86eaf67fb5cb_ACT_bf86aebf-fadb-4a91-a6f6-11f29cebf495_SESS_18d45998-bb23-48fc-abf3-f17f12f8d8b6_BOSC_58e6b3bf-fd55-48a6-bf83-601c93c68e71_PLY_','2022-02-01 11:47:34','2019-09-18 10:18:55','0db1079f-d9ed-11e9-947d-226cec7cb58a.ply','2022-02-01 12:47:34','SYNCED','0db1079f-d9ed-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 150.1.1.1\",\"modelMatrix\":\"0.715123,-0.659481,0.2317,0,0.698999,0.674693,-0.237045,0,2.63167e-9,0.331474,0.943464,0,2.21702,-30.8157,-25.6092,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0db275bb-d9ed-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0db275bb-d9ed-11e9-947d-226cec7cb58a.stl','STL','PATIENT_f8f4fd0f-dc97-4b11-9286-86eaf67fb5cb_ACT_bf86aebf-fadb-4a91-a6f6-11f29cebf495_SESS_18d45998-bb23-48fc-abf3-f17f12f8d8b6_BOSC_58e6b3bf-fd55-48a6-bf83-601c93c68e71_STL_','2022-02-01 11:47:34','2019-09-18 10:18:55','0db275bb-d9ed-11e9-947d-226cec7cb58a.stl','2022-02-01 12:47:34','SYNCED','0db275bb-d9ed-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 150.1.1.1\",\"modelMatrix\":\"0.715123,-0.659481,0.2317,0,0.698999,0.674693,-0.237045,0,2.63167e-9,0.331474,0.943464,0,2.21702,-30.8157,-25.6092,1\",\"title\":\"MANDIBULE STL\"}'),(2,'0db31d27-a3af-4ec5-a653-fd6c15e341b3','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0db31d27-a3af-4ec5-a653-fd6c15e341b3.stl','STL','PATIENT_f6a9d20f-4172-4d39-ba1f-4f41db70ecf7_ACT_fd08bf2b-a80c-4955-aae7-db4757ea760f_SESS_835f8695-828f-44c2-b917-01ed20fcf20f_BOSC_9587fc84-7571-48b4-ae98-413ef6e5f2f5_STL_','2022-02-01 11:47:37','2019-07-30 13:42:54','0db31d27-a3af-4ec5-a653-fd6c15e341b3.stl','2022-02-01 12:47:37','SYNCED','0db31d27-a3af-4ec5-a653-fd6c15e341b3',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 117.1.1.1\",\"modelMatrix\":\"-0.986844,-0.157745,0.0354338,0,0.161676,-0.962851,0.216282,0,3.75321e-9,0.219166,0.975688,0,-20.0397,10.0574,-26.2799,1\",\"title\":\"MANDIBULE STL\"}'),(2,'0db3b350-d9ed-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0db3b350-d9ed-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_f8f4fd0f-dc97-4b11-9286-86eaf67fb5cb_ACT_bf86aebf-fadb-4a91-a6f6-11f29cebf495_SESS_18d45998-bb23-48fc-abf3-f17f12f8d8b6_TOSC_7d394ecf-2eb2-4a7e-8d73-1c89607dd7e7_SNAPS_','2022-02-01 11:47:37','2019-09-18 10:14:22','0db3b350-d9ed-11e9-947d-226cec7cb58a.png','2022-02-01 12:47:37','SYNCED','0db3b350-d9ed-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 150.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0db3f4b9-6282-418a-9f23-608226cfa936','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0db3f4b9-6282-418a-9f23-608226cfa936.ply','PLY','PATIENT_df2eeadd-f92f-4837-9d06-8003b62898b8_ACT_41c458ba-26b5-45af-82c6-dc1d9ea54a57_SESS_d2915c3c-c86f-43cd-9b66-7a8e7598be93_TOSC_ca914dd6-399a-4673-a49a-ac7b2e8396d7_PLY_','2022-02-01 11:47:37','2019-09-02 11:46:47','0db3f4b9-6282-418a-9f23-608226cfa936.ply','2022-02-01 12:47:37','SYNCED','0db3f4b9-6282-418a-9f23-608226cfa936',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 138.1.1.1\",\"modelMatrix\":\"0.70981,-0.626528,0.32192,0,0.704394,0.631346,-0.324395,0,2.07846e-8,0.457018,0.889458,0,4.46835,-37.3103,-20.8687,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0db50b16-d9ed-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0db50b16-d9ed-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_f8f4fd0f-dc97-4b11-9286-86eaf67fb5cb_ACT_bf86aebf-fadb-4a91-a6f6-11f29cebf495_SESS_18d45998-bb23-48fc-abf3-f17f12f8d8b6_BOSC_58e6b3bf-fd55-48a6-bf83-601c93c68e71_SNAPS_','2022-02-01 11:47:37','2019-09-18 10:18:55','0db50b16-d9ed-11e9-947d-226cec7cb58a.png','2022-02-01 12:47:37','SYNCED','0db50b16-d9ed-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 150.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0db5b52b-5d92-4b6b-bf5a-42b14a2b4fd3','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0db5b52b-5d92-4b6b-bf5a-42b14a2b4fd3.stl','STL','PATIENT_9ba806a1-0d9a-46a5-8143-6e968c07c4dd_ACT_bc4ea83b-5ee8-442e-84a0-72e1000837c7_SESS_44ecada7-6aaf-4e06-ac38-4207e5d32862_TOSC_3f31c016-6a97-47d5-ba87-11e40b101724_STL_','2022-02-01 11:47:38','2019-07-12 08:09:03','0db5b52b-5d92-4b6b-bf5a-42b14a2b4fd3.stl','2022-02-01 12:47:38','SYNCED','0db5b52b-5d92-4b6b-bf5a-42b14a2b4fd3',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 49.1.1.1\",\"modelMatrix\":\"0.696866,-0.704819,0.132693,0,0.717201,0.684836,-0.12893,0,1.6403e-9,0.185014,0.982736,0,0.381334,-25.5514,-14.578,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'0db7f073-d9ed-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0db7f073-d9ed-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_f8f4fd0f-dc97-4b11-9286-86eaf67fb5cb_ACT_bf86aebf-fadb-4a91-a6f6-11f29cebf495_SESS_18d45998-bb23-48fc-abf3-f17f12f8d8b6_TOSC_7d394ecf-2eb2-4a7e-8d73-1c89607dd7e7_PLY_','2022-02-01 11:47:38','2019-09-18 10:14:22','0db7f073-d9ed-11e9-947d-226cec7cb58a.ply','2022-02-01 12:47:38','SYNCED','0db7f073-d9ed-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 150.1.1.1\",\"modelMatrix\":\"0.640582,-0.695144,0.326236,0,0.76789,0.579897,-0.27215,0,-6.93149e-9,0.424848,0.905265,0,1.75343,-38.714,-25.9257,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0db95088-d9ed-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0db95088-d9ed-11e9-947d-226cec7cb58a.stl','STL','PATIENT_f8f4fd0f-dc97-4b11-9286-86eaf67fb5cb_ACT_bf86aebf-fadb-4a91-a6f6-11f29cebf495_SESS_18d45998-bb23-48fc-abf3-f17f12f8d8b6_TOSC_7d394ecf-2eb2-4a7e-8d73-1c89607dd7e7_STL_','2022-02-01 11:47:38','2019-09-18 10:14:22','0db95088-d9ed-11e9-947d-226cec7cb58a.stl','2022-02-01 12:47:38','SYNCED','0db95088-d9ed-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 150.1.1.1\",\"modelMatrix\":\"0.640582,-0.695144,0.326236,0,0.76789,0.579897,-0.27215,0,-6.93149e-9,0.424848,0.905265,0,1.75343,-38.714,-25.9257,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'0dbb9fed-2332-40ad-b017-1e71b53d5934','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0dbb9fed-2332-40ad-b017-1e71b53d5934.stl','STL','PATIENT_1fff6898-79c5-4b7a-8ae6-ae2af9a8cbe4_ACT_c988658e-e313-4d11-9672-2c295b7584a6_SESS_db3f12ec-05bf-4d4c-a595-6a4620d49fae_BOSC_4cdf0532-b607-4368-b371-5c49dafc661d_STL_','2022-02-01 11:47:38','2019-09-23 16:42:05','0dbb9fed-2332-40ad-b017-1e71b53d5934.stl','2022-02-01 12:47:38','SYNCED','0dbb9fed-2332-40ad-b017-1e71b53d5934',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 162.1.1.1\",\"modelMatrix\":\"0.611688,0.790406,-0.0331098,0,-0.791099,0.611152,-0.0256009,0,-1.92415e-9,0.0418529,0.999124,0,26.9592,4.88247,-19.4352,1\",\"title\":\"MANDIBULE STL\"}'),(2,'0dd6e85e-1b20-407e-b7bb-7616279f3be5','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0dd6e85e-1b20-407e-b7bb-7616279f3be5.ply','PLY','PATIENT_4887c403-6684-431d-9efd-4230d74f9f6e_ACT_b67be1ff-ec7d-4035-9281-b8e4b218da86_SESS_1c9989e2-d42d-4cab-80e3-b783c63d8a22_BOSC_018e2213-672e-4d3a-b803-426a6ae54b82_PLY_','2021-12-30 18:03:29','2019-10-10 14:24:13','0dd6e85e-1b20-407e-b7bb-7616279f3be5.ply','2021-12-30 19:03:29','SYNCED','0dd6e85e-1b20-407e-b7bb-7616279f3be5',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 184.1.1.1\",\"modelMatrix\":\"0.966458,-0.256743,0.00650652,0,0.256826,0.966148,-0.0244846,0,-2.09839e-10,0.0253344,0.999679,0,9.6621,-23.4411,-23.1822,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0df27ac7-219b-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0df27ac7-219b-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_d9860777-a354-46c2-bb39-b2f150617cc7_ACT_007fc3da-8408-4668-b268-90b0cc4e0512_SESS_e5c0ff5f-1b35-473b-bb5b-6a699181486e_BOSC_e2acb957-0e34-46cc-88b6-368e2a1956df_PLY_','2020-12-23 09:08:17','2019-12-18 14:32:59','0df27ac7-219b-11ea-947d-226cec7cb58a.ply','2020-12-23 10:08:17','SYNCED','0df27ac7-219b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 21.1.268.1.1.1\",\"modelMatrix\":\"-0.223239,0.966774,-0.124547,0,-0.974764,-0.221409,0.0285235,0,-3.13958e-10,0.127771,0.991804,0,11.8882,16.7578,-23.1337,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0df3e066-219b-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0df3e066-219b-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_d9860777-a354-46c2-bb39-b2f150617cc7_ACT_007fc3da-8408-4668-b268-90b0cc4e0512_SESS_e5c0ff5f-1b35-473b-bb5b-6a699181486e_TOSC_74751b16-e67c-476c-874e-887f4154a58b_SNAPS_','2020-12-23 09:08:18','2019-12-18 14:28:39','0df3e066-219b-11ea-947d-226cec7cb58a.png','2020-12-23 10:08:18','SYNCED','0df3e066-219b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 21.1.268.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0df54426-219b-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0df54426-219b-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_d9860777-a354-46c2-bb39-b2f150617cc7_ACT_007fc3da-8408-4668-b268-90b0cc4e0512_SESS_e5c0ff5f-1b35-473b-bb5b-6a699181486e_TOSC_74751b16-e67c-476c-874e-887f4154a58b_PLY_','2020-12-23 09:08:18','2019-12-18 14:28:39','0df54426-219b-11ea-947d-226cec7cb58a.ply','2020-12-23 10:08:18','SYNCED','0df54426-219b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 21.1.268.1.1.1\",\"modelMatrix\":\"0.156134,-0.943399,0.292611,0,0.987736,0.149126,-0.0462539,0,2.00489e-10,0.296244,0.955112,0,-13.7304,-31.3358,-15.5915,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0df67462-219b-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0df67462-219b-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_d9860777-a354-46c2-bb39-b2f150617cc7_ACT_007fc3da-8408-4668-b268-90b0cc4e0512_SESS_e5c0ff5f-1b35-473b-bb5b-6a699181486e_BOSC_e2acb957-0e34-46cc-88b6-368e2a1956df_SNAPS_','2020-12-23 09:08:18','2019-12-18 14:32:59','0df67462-219b-11ea-947d-226cec7cb58a.png','2020-12-23 10:08:18','SYNCED','0df67462-219b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 21.1.268.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0e12d40c-67dc-45e9-a66e-7b31c8752e25','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0e12d40c-67dc-45e9-a66e-7b31c8752e25.png','SNAPS','PATIENT_de25b615-973f-4c4b-816f-91e661f13dde_ACT_671432ea-64fe-4d83-b4a7-ca1415ddf527_SESS_ab99f8ce-fe34-496e-b44b-81de6494455d_BOSC_7c48b43b-5a11-452c-b64c-64ec50012f71_SNAPS_','2022-02-01 11:47:38','2019-07-12 09:06:22','0e12d40c-67dc-45e9-a66e-7b31c8752e25.png','2022-02-01 12:47:38','SYNCED','0e12d40c-67dc-45e9-a66e-7b31c8752e25',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 52.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0e15787b-53ea-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0e15787b-53ea-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_a78941e1-e63b-4f03-84db-3c4fcdb64d89_SESS_caf59252-3532-421e-9b72-5abe78045a36_BOSC_8dab0ada-8b66-421f-a822-76bf8bad5ce6_SNAPS_','2020-12-16 10:52:44','2020-02-20 15:04:39','0e15787b-53ea-11ea-947d-226cec7cb58a.png','2020-12-16 11:52:44','SYNCED','0e15787b-53ea-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0e175edf-53ea-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0e175edf-53ea-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_0bec7ef8-f644-4d84-a2ed-56f8f1364672_ACT_a78941e1-e63b-4f03-84db-3c4fcdb64d89_SESS_caf59252-3532-421e-9b72-5abe78045a36_TOSC_38bb1323-feb0-4bb1-8cda-5daf12e12eed_SNAPS_','2020-12-16 10:52:44','2020-02-20 15:01:23','0e175edf-53ea-11ea-947d-226cec7cb58a.png','2020-12-16 11:52:44','SYNCED','0e175edf-53ea-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0e192ea8-53ea-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0e192ea8-53ea-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_a78941e1-e63b-4f03-84db-3c4fcdb64d89_SESS_caf59252-3532-421e-9b72-5abe78045a36_BOSC_8dab0ada-8b66-421f-a822-76bf8bad5ce6_PLY_','2020-12-16 10:52:45','2020-02-20 15:04:39','0e192ea8-53ea-11ea-947d-226cec7cb58a.ply','2020-12-16 11:52:45','SYNCED','0e192ea8-53ea-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"modelMatrix\":\"-0.941069,0.332787,-0.0603439,0,-0.338214,-0.925969,0.167905,0,5.08476e-9,0.178419,0.983955,0,-6.98178,19.525,-17.2077,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0e1b1162-bc01-42cc-b4a9-c999d6a9e485','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0e1b1162-bc01-42cc-b4a9-c999d6a9e485.ply','PLY','PATIENT_ac2fda67-6a37-42ca-88dc-f608ad4b59d1_ACT_e7e2089a-48a5-454d-8df3-e01056f00103_SESS_727f371b-23b2-4b34-9baf-d6986728505e_TOSC_0c377400-4f8c-4b1e-be60-b3b242f24e47_PLY_','2020-12-08 17:27:24','2020-06-16 11:35:45','0e1b1162-bc01-42cc-b4a9-c999d6a9e485.ply','2020-12-08 18:27:24','SYNCED','0e1b1162-bc01-42cc-b4a9-c999d6a9e485',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.40.1.1\",\"modelMatrix\":\"0.801784,-0.539922,0.256176,0,0.597613,0.724383,-0.343698,0,2.84946e-9,0.428666,0.903463,0,7.72812,-33.2753,-19.2581,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0e1b2277-53ea-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0e1b2277-53ea-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_0bec7ef8-f644-4d84-a2ed-56f8f1364672_ACT_a78941e1-e63b-4f03-84db-3c4fcdb64d89_SESS_caf59252-3532-421e-9b72-5abe78045a36_TOSC_38bb1323-feb0-4bb1-8cda-5daf12e12eed_PLY_','2020-12-16 10:52:45','2020-02-20 15:01:23','0e1b2277-53ea-11ea-947d-226cec7cb58a.ply','2020-12-16 11:52:45','SYNCED','0e1b2277-53ea-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"modelMatrix\":\"0.819622,-0.538128,0.196565,0,0.572904,0.76987,-0.281214,0,1.36026e-8,0.343102,0.939298,0,10.5225,-28.2766,-17.0957,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0e27f895-556a-47af-b5db-6a4447a86b24','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0e27f895-556a-47af-b5db-6a4447a86b24.ply','PLY','PATIENT_cbd259d8-b167-4ae5-b02e-593bafa6de29_ACT_34fa1c9b-715e-411d-a03f-6f26498858ca_SESS_024384a7-8b62-46fd-8fd0-3a6d4aec0594_TOSC_95cd0980-b02a-48a3-8c81-8fc0e6dd9980_PLY_','2021-01-06 11:03:04','2019-12-11 15:39:36','0e27f895-556a-47af-b5db-6a4447a86b24.ply','2021-01-06 12:03:04','SYNCED','0e27f895-556a-47af-b5db-6a4447a86b24',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 232.1.1.1\",\"modelMatrix\":\"0.206797,-0.950392,0.232359,0,0.978384,0.20088,-0.0491127,0,-2.35827e-9,0.237493,0.971389,0,-13.47,-28.7275,-17.9558,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0e3fd84d-efae-4ba2-ba37-c8960761a10e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0e3fd84d-efae-4ba2-ba37-c8960761a10e.stl','STL','PATIENT_bc50bff3-dacb-4f7a-a7c8-b971782c6d1d_ACT_be5de36f-b43d-47f3-b178-801c7822bb7d_SESS_df767eeb-30cd-456e-91c0-aa5269ac29d4_TOSC_269be812-7049-43da-b5b5-8082fcff4e39_STL_','2021-08-19 22:27:34','2019-11-27 12:24:49','0e3fd84d-efae-4ba2-ba37-c8960761a10e.stl','2021-08-20 00:27:34','SYNCED','0e3fd84d-efae-4ba2-ba37-c8960761a10e',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 212.1.1.1\",\"modelMatrix\":\"0.798472,-0.57712,0.171391,0,0.602032,0.765432,-0.227315,0,2.42314e-9,0.284687,0.95862,0,10.1901,-31.3555,-15.2319,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'0e406ad5-a89f-4a02-a811-5c730d58b0dc','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0e406ad5-a89f-4a02-a811-5c730d58b0dc.ply','PLY','PATIENT_b3c01a18-bf96-412e-abc4-a54012ab02c7_ACT_a13375ec-ea2a-4160-a01e-df6b4aa8236c_SESS_e11a368c-c597-4a5e-a772-b85449c93d08_BOSC_86053586-104c-492d-a7a7-0b2d39aab55e_PLY_','2022-02-01 11:47:39','2019-07-23 16:16:06','0e406ad5-a89f-4a02-a811-5c730d58b0dc.ply','2022-02-01 12:47:39','SYNCED','0e406ad5-a89f-4a02-a811-5c730d58b0dc',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 56.1.1.1\",\"modelMatrix\":\"-0.999958,0.00891299,-0.00195689,0,-0.00912528,-0.976695,0.214438,0,3.618e-11,0.214447,0.976736,0,-15.5716,19.1631,-22.4176,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0e72c844-6ed2-4c7f-94d2-3e69ff91c152','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0e72c844-6ed2-4c7f-94d2-3e69ff91c152.ply','PLY','PATIENT_d4ea044b-3514-42f4-ae88-c9548bd72102_ACT_0a1e2259-cccc-4340-b89c-6e8977a2ad52_SESS_182b8b60-e273-40dd-805e-e07693857391_TOSC_83030167-26ca-4b08-8d8e-d25579056e48_PLY_','2022-02-01 11:47:39','2019-09-03 11:21:50','0e72c844-6ed2-4c7f-94d2-3e69ff91c152.ply','2022-02-01 12:47:39','SYNCED','0e72c844-6ed2-4c7f-94d2-3e69ff91c152',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 141.1.1.1\",\"modelMatrix\":\"0.709399,-0.630954,0.314086,0,0.704807,0.635065,-0.316132,0,-1.15324e-8,0.445634,0.895215,0,5.20191,-38.0091,-16.2605,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0e77fb82-a2b2-4bde-bdb4-c69276193adb','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0e77fb82-a2b2-4bde-bdb4-c69276193adb.stl','STL','PATIENT_7a05621b-faf4-4349-b2d2-c3be727792f4_ACT_08d18960-730f-4f7c-9b47-931603308bdb_SESS_4a7294e9-e836-459e-b858-97f1d4d1e112_TOSC_fb0e5ccd-00fb-4a58-a87d-aa747f563e00_STL_','2021-08-19 22:27:36','2019-11-27 11:54:14','0e77fb82-a2b2-4bde-bdb4-c69276193adb.stl','2021-08-20 00:27:36','SYNCED','0e77fb82-a2b2-4bde-bdb4-c69276193adb',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 211.5.1.1\",\"modelMatrix\":\"0.884301,-0.390678,0.255701,0,0.466918,0.739909,-0.484275,0,1.29539e-10,0.547637,0.836716,0,15.337,-31.7097,-21.1273,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'0eb11552-5d2b-4606-9cd0-ed9fb28ee068','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0eb11552-5d2b-4606-9cd0-ed9fb28ee068.stl','STL','PATIENT_2df9c598-3519-4719-a1e4-f4e150a235a9_ACT_ceb083f7-ec86-4eba-9690-123a703c3abc_SESS_ea3ce5df-3ae9-45ef-896c-5661af24bc30_TOSC_9ea9beda-7ec0-46aa-bb03-291a141652f3_STL_','2022-02-07 12:37:54','2019-11-21 10:37:22','0eb11552-5d2b-4606-9cd0-ed9fb28ee068.stl','2022-02-07 13:37:54','SYNCED','0eb11552-5d2b-4606-9cd0-ed9fb28ee068',0,'2022-02-07 13:37:54','','','{\"displayTitle\":\"MAXILLAIRE 207.3.1.1.5\",\"modelMatrix\":\"0.688471,-0.682808,0.244502,0,0.725264,0.648169,-0.232099,0,2.11116e-8,0.337122,0.941461,0,8.04313,-34.6315,-21.9452,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'0ebacf55-4cb2-4ef0-b229-f7a39d5c0bdc','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0ebacf55-4cb2-4ef0-b229-f7a39d5c0bdc.ply','PLY','PATIENT_c7652665-71bd-461e-a124-c26bb95893f1_ACT_e3a98034-08e2-4b98-aebb-e3e098593612_SESS_5a2f63cd-863a-464a-8ba9-a6efa7738c10_TOSC_0a718297-770a-4d62-a17c-57e690e0333a_PLY_','2021-01-20 15:41:12','2019-12-06 15:39:36','0ebacf55-4cb2-4ef0-b229-f7a39d5c0bdc.ply','2021-01-20 16:41:12','SYNCED','0ebacf55-4cb2-4ef0-b229-f7a39d5c0bdc',0,NULL,'','','{\"displayTitle\":\"Maxilar 0\",\"modelMatrix\":\"0.524259,-0.842949,0.120788,0,0.851559,0.518959,-0.0743625,0,1.08292e-8,0.141843,0.989889,0,-4.29475,-30.8267,-13.8515,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0ee6e3c4-f760-4c34-ab55-fd41f8a3d249','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0ee6e3c4-f760-4c34-ab55-fd41f8a3d249.stl','STL','PATIENT_7afceb75-c859-449d-98fc-db1d3941b795_ACT_43f2649c-a6d8-46e8-9a60-f6c6e927308f_SESS_6724c6e2-b258-4fed-8224-afbb51fadbe9_BOSC_00fd5f84-1a00-44b3-a253-aa1965d85ad4_STL_','2022-02-01 11:47:39','2019-07-22 16:56:50','0ee6e3c4-f760-4c34-ab55-fd41f8a3d249.stl','2022-02-01 12:47:39','SYNCED','0ee6e3c4-f760-4c34-ab55-fd41f8a3d249',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 108.2.1.1\",\"modelMatrix\":\"0.999922,0.0124577,-0.00110608,0,-0.0125067,0.996004,-0.0884321,0,1.01142e-10,0.088439,0.996082,0,15.8971,-28.7398,-28.3094,1\",\"title\":\"MANDIBULE STL\"}'),(2,'0ee971ee-496a-47fe-b6f8-cfbfce621af7','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0ee971ee-496a-47fe-b6f8-cfbfce621af7.stl','STL','PATIENT_d4c7e589-712b-45fa-8b2d-3f3c9661bf0b_ACT_3ee02514-2ffd-4c5c-967c-82ae7f8ff8c3_SESS_d5d64b70-3623-40ea-ba14-ea2dcb5c4d3f_BOSC_114ae338-8cee-411f-b15e-dc290c488671_STL_','2021-12-30 18:03:30','2019-10-07 14:21:49','0ee971ee-496a-47fe-b6f8-cfbfce621af7.stl','2021-12-30 19:03:30','SYNCED','0ee971ee-496a-47fe-b6f8-cfbfce621af7',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 180.1.1.1\",\"modelMatrix\":\"-0.889249,0.455614,-0.0406382,0,-0.457422,-0.885733,0.0790025,0,1.44218e-9,0.0888417,0.996046,0,-4.75044,23.5423,-19.112,1\",\"title\":\"MANDIBULE STL\"}'),(2,'0f00977d-f344-4614-8361-734f94bf55d5','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0f00977d-f344-4614-8361-734f94bf55d5.ply','PLY','PATIENT_d31bbbbf-04d4-4ed1-a51f-8bd816669381_ACT_6f07aa75-bd4a-40ca-8b16-b0dc3e7e96dc_SESS_966435b6-291a-4cc9-8a4b-0d5ec3acc397_BOSC_45edd857-a797-4bef-98fd-b939b967a5e7_PLY_','2021-12-30 18:03:30','2019-11-18 14:48:06','0f00977d-f344-4614-8361-734f94bf55d5.ply','2021-12-30 19:03:30','SYNCED','0f00977d-f344-4614-8361-734f94bf55d5',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 205.1.1.1\",\"modelMatrix\":\"-0.85775,0.486084,-0.167295,0,-0.514068,-0.811058,0.279141,0,-3.56119e-9,0.325434,0.945565,0,-2.60144,18.8898,-18.9634,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0f015e13-673b-4e8a-9f0c-85817cba7f49','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0f015e13-673b-4e8a-9f0c-85817cba7f49.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_e44fbbcb-7ace-4649-8a05-a692408f5313_SNAPS_','2020-12-16 11:08:36','2020-01-24 12:28:27','0f015e13-673b-4e8a-9f0c-85817cba7f49.png','2020-12-16 12:08:36','SYNCED','0f015e13-673b-4e8a-9f0c-85817cba7f49',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.10\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0f2b5321-cabc-446c-8ad0-40da4269dc87','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0f2b5321-cabc-446c-8ad0-40da4269dc87.png','SNAPS','PATIENT_64359e51-e452-44a6-afe9-6f3e6bceec8c_ACT_8d766078-1a0c-4ad1-a6d1-814b0552d119_SESS_e19007d0-7999-4f58-9d2f-dc9b7757dfb4_TOSC_7780eda4-ec12-4f1c-9839-fdaac8adce76_SNAPS_','2022-02-01 11:47:39','2019-09-20 11:32:16','0f2b5321-cabc-446c-8ad0-40da4269dc87.png','2022-02-01 12:47:39','SYNCED','aa1f9e8b-5002-4329-a998-326a2742dec7',1,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 159.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0f2c3b32-ab12-4586-bd1e-03017e2e2b91','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0f2c3b32-ab12-4586-bd1e-03017e2e2b91.png','SNAPS','PATIENT_c43dfbc1-87d5-42db-ab2b-544103380ac4_ACT_c138fcf7-8ef1-4cc2-884a-91278deed561_SESS_9ea9c387-3185-4853-a925-ef49faac58a2_TOSC_57f133b7-0701-4a48-970b-fed868a34091_SNAPS_','2020-12-23 09:08:21','2019-12-31 11:31:21','0f2c3b32-ab12-4586-bd1e-03017e2e2b91.png','2020-12-23 10:08:21','SYNCED','0f2c3b32-ab12-4586-bd1e-03017e2e2b91',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0f3334a9-68bd-49f8-a15e-a6a0ec4d2dfd','','SNAPS','PATIENT_74a66f39-c9db-4c13-9dbf-7acfc0ea9391_ACT_bd746a5b-c1c4-42fa-88a3-345da35d47a0_SESS_a64913b8-d6d8-4c57-8ded-53d9f86e010a_TOSC_672a3a90-85f2-4c6a-89a3-22bebfee164c_SNAPS_','2021-12-30 18:03:30','2019-10-25 10:46:04','','2021-12-30 19:03:30','SYNCED','0f3334a9-68bd-49f8-a15e-a6a0ec4d2dfd',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 196.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0f527de8-d8a6-4b7f-8926-37aa75af66d8','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0f527de8-d8a6-4b7f-8926-37aa75af66d8.stl','STL','PATIENT_fcf8c111-84a1-4f17-859c-ea2ad21d373b_ACT_4e553ae3-f2ae-4ebb-a8a1-1fd2b0e6a047_SESS_fbbf125e-8572-4cc2-a8cf-594668da6217_BOSC_122d8247-aabb-4435-a8c0-ae09f23abfca_STL_','2022-02-01 11:47:39','2019-09-30 17:20:48','0f527de8-d8a6-4b7f-8926-37aa75af66d8.stl','2022-02-01 12:47:39','SYNCED','0f527de8-d8a6-4b7f-8926-37aa75af66d8',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 168.1.1.1\",\"modelMatrix\":\"0.820644,-0.569077,0.0519091,0,0.57144,0.817251,-0.0745466,0,1.66436e-9,0.0908391,0.995866,0,-5.85906,-28.4024,-20.909,1\",\"title\":\"MANDIBULE STL\"}'),(2,'0f66d802-6447-41cb-9343-83bdd7d9587e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0f66d802-6447-41cb-9343-83bdd7d9587e.ply','PLY','PATIENT_1da4d746-be7d-4b76-83ab-ea0f893a037f_ACT_675a182e-b3d8-4879-885d-947de50cff0a_SESS_781a5087-c565-4f1b-95e2-54358316e8e3_TOSC_08daebbf-c9f0-4d27-b5c9-c83c53974996_PLY_','2021-01-06 11:03:07','2019-12-13 09:34:15','0f66d802-6447-41cb-9343-83bdd7d9587e.ply','2021-01-06 12:03:07','SYNCED','0f66d802-6447-41cb-9343-83bdd7d9587e',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 232.18.1.1\",\"modelMatrix\":\"0.652505,-0.720147,0.235851,0,0.757785,0.620096,-0.203083,0,5.9146e-9,0.311237,0.950332,0,-0.0694818,-31.9776,-21.1425,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0f880a58-a06f-4520-8ad8-f06cdc2ae30b','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0f880a58-a06f-4520-8ad8-f06cdc2ae30b.ply','PLY','PATIENT_fcf8c111-84a1-4f17-859c-ea2ad21d373b_ACT_d27c23bb-fa1e-4cd8-bacc-e2b65114a20e_SESS_844480c5-a8a8-4eb3-a014-e1424d66a1ca_BOSC_479aff55-b65b-4bc0-a786-1a78381faa63_PLY_','2021-12-30 18:03:31','2019-11-18 15:25:38','0f880a58-a06f-4520-8ad8-f06cdc2ae30b.ply','2021-12-30 19:03:31','SYNCED','0f880a58-a06f-4520-8ad8-f06cdc2ae30b',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 168.1.1.1.1\",\"modelMatrix\":\"-0.973862,0.211793,-0.0820774,0,-0.227141,-0.908058,0.351905,0,-5.4656e-9,0.36135,0.93243,0,-9.66149,10.5921,-19.6488,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0f978889-12ab-4235-b888-7ca28088da95','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0f978889-12ab-4235-b888-7ca28088da95.stl','STL','PATIENT_3ac5152b-a005-4ed5-95d1-82a7cc8d4bd5_ACT_12eb8c65-9ba0-4f86-b5ba-ca70f1b14d8a_SESS_bbc3949b-10a6-410f-8ece-f50bba0a5585_BOSC_23762ed2-8993-4505-9e85-4f6296fe4003_STL_','2022-02-01 11:47:40','2019-08-05 09:22:56','0f978889-12ab-4235-b888-7ca28088da95.stl','2022-02-01 12:47:40','SYNCED','0f978889-12ab-4235-b888-7ca28088da95',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 124.1.1.1\",\"modelMatrix\":\"-0.835769,-0.548801,0.0175195,0,0.549081,-0.835344,0.0266669,0,1.39237e-9,0.031907,0.999491,0,-26.3289,4.64533,-26.0466,1\",\"title\":\"MANDIBULE STL\"}'),(2,'0f9af1c7-badd-4455-8725-aa5a8a58d07c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0f9af1c7-badd-4455-8725-aa5a8a58d07c.png','SNAPS','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_c138fcf7-8ef1-4cc2-884a-91278deed561_SESS_9ea9c387-3185-4853-a925-ef49faac58a2_BOSC_1371ce40-2abf-4ae1-b3e4-e85210a0c5c4_SNAPS_','2020-12-23 09:08:23','2019-12-31 11:35:35','0f9af1c7-badd-4455-8725-aa5a8a58d07c.png','2020-12-23 10:08:23','SYNCED','0f9af1c7-badd-4455-8725-aa5a8a58d07c',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0f9c680a-566a-446c-a0ca-981f3c440777','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0f9c680a-566a-446c-a0ca-981f3c440777.stl','STL','PATIENT_94217f81-bba6-4d76-8071-78114d090c03_ACT_94854232-4ce3-4ade-b690-a1ad1b56e2ec_SESS_51fac453-ecfe-4176-93bb-b7870f3eab12_TOSC_11befdd9-1e0d-4933-a7fc-78c3659f0160_STL_','2021-08-19 22:27:41','2019-11-27 10:00:07','0f9c680a-566a-446c-a0ca-981f3c440777.stl','2021-08-20 00:27:41','SYNCED','0f9c680a-566a-446c-a0ca-981f3c440777',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.35.1.1\",\"modelMatrix\":\"0.652087,-0.69678,0.298796,0,0.758144,0.599308,-0.256998,0,-1.47181e-8,0.394115,0.919061,0,-2.30351,-36.4461,-20.8583,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'0f9d95c0-c096-4eb8-b6f3-c88398d46316','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0f9d95c0-c096-4eb8-b6f3-c88398d46316.png','SNAPS','PATIENT_6cda0ff7-9066-45b9-90ca-6e11634d3844_ACT_0a1be447-887b-46a0-8401-d533a77b8192_SESS_25929069-e287-4283-ae0a-8b51a4974547_BOSC_96ba0852-ebf7-4dd4-8ab4-8d022ae4eb5a_SNAPS_','2022-02-01 11:47:40','2019-07-17 15:34:46','0f9d95c0-c096-4eb8-b6f3-c88398d46316.png','2022-02-01 12:47:40','SYNCED','0f9d95c0-c096-4eb8-b6f3-c88398d46316',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 91.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0f9fa62f-a048-485d-9652-b60b8e0a3403','','PLY','PATIENT_2df9c598-3519-4719-a1e4-f4e150a235a9_ACT_ceb083f7-ec86-4eba-9690-123a703c3abc_SESS_ea3ce5df-3ae9-45ef-896c-5661af24bc30_TOSC_4114ee21-40cc-4ffd-84df-2b8954d95607_PLY_','2021-12-30 18:03:31','2019-11-21 15:36:46','','2021-12-30 19:03:31','SYNCED','0f9fa62f-a048-485d-9652-b60b8e0a3403',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 207.3.1.1\",\"modelMatrix\":\"0.666884,-0.698689,0.259034,0,0.745161,0.625294,-0.231823,0,-9.79153e-9,0.347622,0.937635,0,6.05261,-38.4706,-23.7557,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0faaacec-ea81-4585-b4c0-e9ba8f500297','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0faaacec-ea81-4585-b4c0-e9ba8f500297.ply','PLY','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_fd694b3f-abde-4e46-91f7-7c62bfdcafa4_SESS_73a3f5b9-e905-4911-a163-2022e1de3380_TOSC_1fa74125-0851-4e94-abdc-8b29cf638995_PLY_','2021-08-19 22:27:43','2019-11-26 16:04:03','0faaacec-ea81-4585-b4c0-e9ba8f500297.ply','2021-08-20 00:27:43','SYNCED','0faaacec-ea81-4585-b4c0-e9ba8f500297',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"modelMatrix\":\"0.418332,-0.873138,0.250255,0,0.908294,0.40214,-0.11526,0,-8.87156e-9,0.275522,0.961295,0,-7.18197,-30.5759,-18.3735,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0fad1c54-1a44-4843-8fe0-f7212a3bd655','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0fad1c54-1a44-4843-8fe0-f7212a3bd655.stl','STL','PATIENT_90e58efc-5bdd-461e-b60c-845950928383_ACT_a648c578-4d42-450f-ae6d-3fa61d8c3dea_SESS_679262ee-0141-4579-a3ce-ccfcc3ef28db_TOSC_825976bd-2a76-417b-a846-7265cda5a69f_STL_','2022-02-01 11:47:40','2019-09-09 10:19:57','0fad1c54-1a44-4843-8fe0-f7212a3bd655.stl','2022-02-01 12:47:40','SYNCED','0fad1c54-1a44-4843-8fe0-f7212a3bd655',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 147.1.1.1\",\"modelMatrix\":\"0.295061,-0.879579,0.373203,0,0.955478,0.271622,-0.115249,0,2.44043e-9,0.390593,0.920564,0,-14.0544,-32.7486,-16.5992,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'0fade721-dff9-4c89-aa66-4b05f4afa81c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0fade721-dff9-4c89-aa66-4b05f4afa81c.stl','STL','PATIENT_1fe53bd5-165d-4f83-8b14-5ccfa106502b_ACT_160645fc-3820-4053-baf9-297adc7a3bd0_SESS_e51149df-9a1e-4ccd-b213-42584b7c91f8_TOSC_8c462e06-1f0c-43f2-a258-219811582fb3_STL_','2021-01-06 11:03:08','2019-12-11 16:12:25','0fade721-dff9-4c89-aa66-4b05f4afa81c.stl','2021-01-06 12:03:08','SYNCED','0fade721-dff9-4c89-aa66-4b05f4afa81c',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 232.3.1.1\",\"modelMatrix\":\"0.77671,-0.603367,0.18075,0,0.629859,0.744041,-0.222892,0,4.02453e-9,0.286969,0.95794,0,7.01605,-35.0585,-17.1229,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'0fb4f9f2-7767-4550-939f-0a3fecc2fec0','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0fb4f9f2-7767-4550-939f-0a3fecc2fec0.stl','STL','PATIENT_cb792ec3-1780-40fa-b01b-45b72329970a_ACT_bf1e82a2-d47f-4e1e-8585-5081cd72732d_SESS_af593c0e-7054-4435-96a3-d0215b9a1fc1_TOSC_c4d7ab4d-89b0-4b61-ab3f-86bfbcfb5523_STL_','2022-02-01 11:47:40','2019-08-19 14:02:53','0fb4f9f2-7767-4550-939f-0a3fecc2fec0.stl','2022-02-01 12:47:40','SYNCED','4d623b0c-6f5a-41f8-8e92-fee9b07e70bb',1,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 130.1.1.1\",\"modelMatrix\":\"0.489069,-0.819401,0.298988,0,0.872245,0.459439,-0.167643,0,7.85065e-9,0.342779,0.939416,0,-5.40402,-36.2924,-19.2531,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'0fbb9d6a-251b-4cc5-ade5-1d8ef2c88c1c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0fbb9d6a-251b-4cc5-ade5-1d8ef2c88c1c.ply','PLY','PATIENT_961e5084-1756-4d47-8e90-a6b717094efe_ACT_e578fe8c-ed3c-46bc-b105-bc17f69b4a2e_SESS_9f266ece-fc0c-49df-ba49-eeafaee3b31b_BOSC_05e98f2e-9554-4971-b08d-3b988c5efd29_PLY_','2020-12-16 11:08:40','2020-01-21 11:49:58','0fbb9d6a-251b-4cc5-ade5-1d8ef2c88c1c.ply','2020-12-16 12:08:40','SYNCED','0fbb9d6a-251b-4cc5-ade5-1d8ef2c88c1c',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 199.1.2.1.1\",\"modelMatrix\":\"-0.99777,-0.0653266,0.0136577,0,0.066739,-0.976654,0.204187,0,-4.01632e-10,0.204643,0.978837,0,-17.393,16.1758,-29.6534,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0fc3e35f-2ee2-4fcd-87c3-d861e14d1890','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0fc3e35f-2ee2-4fcd-87c3-d861e14d1890.png','SNAPS','PATIENT_1bef42e7-74b5-408e-9752-fdb770ead93f_ACT_d8cd77ea-5298-4bca-ad2d-459ba572e935_SESS_17eb53c4-e3ba-4227-b3b4-fba3a38cf0b7_TOSC_4a5f302e-2a1a-4f89-ad4b-b6f891046bf5_SNAPS_','2020-12-23 09:08:25','2020-01-02 11:00:56','0fc3e35f-2ee2-4fcd-87c3-d861e14d1890.png','2020-12-23 10:08:25','SYNCED','0fc3e35f-2ee2-4fcd-87c3-d861e14d1890',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0fc5962a-d7c9-4ada-b52b-4c0a70f3278d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0fc5962a-d7c9-4ada-b52b-4c0a70f3278d.png','SNAPS','PATIENT_944eb49e-32a6-450d-a2ef-6cb420031bbb_ACT_27b727ae-63d6-4686-ab97-71fe9256c87a_SESS_035fb980-4fc7-4a0a-9a11-e7b912145869_TOSC_8ef65bc4-e25d-4b75-ae61-81aad4ed852f_SNAPS_','2022-02-01 11:47:40','2019-08-05 17:00:15','0fc5962a-d7c9-4ada-b52b-4c0a70f3278d.png','2022-02-01 12:47:40','SYNCED','0fc5962a-d7c9-4ada-b52b-4c0a70f3278d',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 125.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0fd490ad-e57b-4ec6-9f2d-48a7e7e2452a','','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_2feaafd5-9186-4b34-97e9-a3294e6e15be_SESS_da430c8c-2ca8-4108-bf57-a3f31aaba3fe_TOSC_27376364-f519-4d82-ac22-dd05910d1bf4_PLY_','2020-12-16 10:52:51','2020-05-22 15:08:05','','2020-12-16 11:52:51','SYNCED','0fd490ad-e57b-4ec6-9f2d-48a7e7e2452a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 216.1.11.1.1\",\"modelMatrix\":\"0.010222,-0.961683,0.273972,0,0.999948,0.0098308,-0.00280068,0,2.72118e-10,0.273986,0.961734,0,-18.9495,-29.8282,-27.7875,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0feb9ef8-abfe-47f2-bdce-2dce6417cf83','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0feb9ef8-abfe-47f2-bdce-2dce6417cf83.stl','STL','PATIENT_c0cb70de-94b5-4ad1-8096-f1713ade0ce1_ACT_7b78ee76-d591-4a20-94ed-fa3498e1fe9c_SESS_cdccf1b9-9263-4647-a7af-3daca544410f_BOSC_740a54bf-8ad8-4b87-b29d-717c03c2ecef_STL_','2022-02-01 11:47:40','2019-07-17 17:06:05','0feb9ef8-abfe-47f2-bdce-2dce6417cf83.stl','2022-02-01 12:47:40','SYNCED','0feb9ef8-abfe-47f2-bdce-2dce6417cf83',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 94.1.1.1\",\"modelMatrix\":\"0.464594,0.868796,-0.171306,0,-0.885524,0.455818,-0.0898766,0,3.81744e-9,0.193452,0.98111,0,24.6284,8.25066,-19.1497,1\",\"title\":\"MANDIBULE STL\"}'),(2,'0fecf739-fdb9-444c-99a4-3cb7fbf31e00','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0fecf739-fdb9-444c-99a4-3cb7fbf31e00.ply','PLY','PATIENT_24e6296f-61e8-4047-8ff5-f9ed012a1232_ACT_eda2d23f-44a6-4af8-860c-2bddc040e439_SESS_24b4dd62-660c-4500-aadc-c90c5e1d3168_TOSC_53a7927e-92d3-4679-85fc-0059c96ec0fd_PLY_','2022-03-04 13:40:25','2019-07-10 10:54:10','0fecf739-fdb9-444c-99a4-3cb7fbf31e00.ply','2022-03-04 14:40:25','SYNCED','0fecf739-fdb9-444c-99a4-3cb7fbf31e00',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 22.1.1.1\",\"modelMatrix\":\"0.833505,-0.513071,0.205007,0,0.552512,0.774005,-0.309268,0,-6.77483e-10,0.371045,0.928615,0,11.7132,-39.7349,-18.1723,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0ff0942f-aae0-44de-a0f1-2b46a115b659','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0ff0942f-aae0-44de-a0f1-2b46a115b659.stl','STL','PATIENT_743efa0d-50c5-40ff-877a-c8e7d625a010_ACT_301ef009-76fa-4ec1-890b-7c740b050075_SESS_27cb4da5-1d2c-452d-b8a9-ad3332098aee_BOSC_3779c608-14f6-4904-ae5c-76bbea7b7bf1_STL_','2022-02-01 11:47:41','2019-09-26 15:49:06','0ff0942f-aae0-44de-a0f1-2b46a115b659.stl','2022-02-01 12:47:41','SYNCED','0ff0942f-aae0-44de-a0f1-2b46a115b659',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 164.1.1.1\",\"modelMatrix\":\"-0.88151,0.4619,-0.0979257,0,-0.472166,-0.862343,0.182822,0,-4.53287e-9,0.207397,0.978257,0,-5.89656,22.9215,-24.0829,1\",\"title\":\"MANDIBULE STL\"}'),(2,'0ffb2063-8198-423b-a164-c83360ff76cd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0ffb2063-8198-423b-a164-c83360ff76cd.ply','PLY','PATIENT_d7b3cadc-8356-418c-aad5-c24747161527_ACT_5a789675-4685-42fc-9a84-35f09f0b7ab6_SESS_ef0782bd-ddc2-4e69-8b3a-b0b28b0560a8_TOSC_46e3f2d4-26df-476b-8bdd-96f884261e75_PLY_','2022-02-01 11:47:41','2019-07-15 12:31:30','0ffb2063-8198-423b-a164-c83360ff76cd.ply','2022-02-01 12:47:41','SYNCED','0ffb2063-8198-423b-a164-c83360ff76cd',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 64.1.1.1\",\"modelMatrix\":\"0.600735,-0.781487,0.168513,0,0.799448,0.587237,-0.126626,0,5.20037e-9,0.210786,0.977532,0,-1.02488,-33.2309,-17.203,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0ffe3d73-9c30-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0ffe3d73-9c30-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_2feaafd5-9186-4b34-97e9-a3294e6e15be_SESS_da430c8c-2ca8-4108-bf57-a3f31aaba3fe_BOSC_2e92df08-a75c-48a4-9198-33eaf4e3dc76_SNAPS_','2020-12-16 10:52:52','2020-05-22 15:27:35','0ffe3d73-9c30-11ea-947d-226cec7cb58a.png','2020-12-16 11:52:52','SYNCED','0ffe3d73-9c30-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 216.1.11.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'100289e5-9c30-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/100289e5-9c30-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_2feaafd5-9186-4b34-97e9-a3294e6e15be_SESS_da430c8c-2ca8-4108-bf57-a3f31aaba3fe_BOSC_2e92df08-a75c-48a4-9198-33eaf4e3dc76_PLY_','2020-12-16 10:52:52','2020-05-22 15:27:35','100289e5-9c30-11ea-947d-226cec7cb58a.ply','2020-12-16 11:52:52','SYNCED','100289e5-9c30-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 216.1.11.1.1\",\"modelMatrix\":\"-0.994956,0.0981683,-0.020625,0,-0.100312,-0.973698,0.204572,0,8.58486e-10,0.20561,0.978634,0,3.08618,15.489,-22.0713,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'1005ae11-9c30-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1005ae11-9c30-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_2feaafd5-9186-4b34-97e9-a3294e6e15be_SESS_da430c8c-2ca8-4108-bf57-a3f31aaba3fe_TOSC_27376364-f519-4d82-ac22-dd05910d1bf4_SNAPS_','2020-12-16 10:52:53','2020-05-22 15:11:52','1005ae11-9c30-11ea-947d-226cec7cb58a.png','2020-12-16 11:52:53','SYNCED','1005ae11-9c30-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 216.1.11.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'10093f4e-9c30-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/10093f4e-9c30-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_2feaafd5-9186-4b34-97e9-a3294e6e15be_SESS_da430c8c-2ca8-4108-bf57-a3f31aaba3fe_TOSC_27376364-f519-4d82-ac22-dd05910d1bf4_PLY_','2020-12-16 10:52:53','2020-05-22 15:11:52','10093f4e-9c30-11ea-947d-226cec7cb58a.ply','2020-12-16 11:52:53','SYNCED','10093f4e-9c30-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 216.1.11.1.1\",\"modelMatrix\":\"-0.0174798,-0.959893,0.279823,0,0.999847,-0.0167813,0.00489198,0,1.07096e-10,0.279865,0.960039,0,-19.133,-29.3364,-27.4236,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'100d55d9-8f2f-4ad7-897c-9e611d2f61f0','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/100d55d9-8f2f-4ad7-897c-9e611d2f61f0.png','SNAPS','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_8c7a1e74-25c2-432c-9c36-1bc4fc678ec1_SESS_692c8ffd-5299-4eda-8e48-a424d5caa737_TOSC_82e3ed51-9883-492e-aa92-183fbac4f581_SNAPS_','2021-06-07 11:39:08','2020-01-20 14:04:40','100d55d9-8f2f-4ad7-897c-9e611d2f61f0.png','2021-06-07 13:39:08','SYNCED','100d55d9-8f2f-4ad7-897c-9e611d2f61f0',0,'2021-06-07 13:39:08','','','{\"displayTitle\":\"MAXILLAIRE 283.1.1.1.3\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'10133036-e14e-461e-addc-871b769493a0','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/10133036-e14e-461e-addc-871b769493a0.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_8f0d3062-1121-4e4e-b9ed-921f4dc3427f_PLY_','2020-12-16 11:08:42','2020-01-24 13:44:39','10133036-e14e-461e-addc-871b769493a0.ply','2020-12-16 12:08:42','SYNCED','10133036-e14e-461e-addc-871b769493a0',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.6\",\"modelMatrix\":\"-0.945861,0.317991,-0.0650353,0,-0.324573,-0.926679,0.189524,0,4.02151e-10,0.200372,0.97972,0,-9.97534,16.089,-15.7728,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'101505bc-b31b-4ad2-a860-1496e04dd7e7','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/101505bc-b31b-4ad2-a860-1496e04dd7e7.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_2d224d3d-fa18-49d9-a6ce-810f5d111f17_SESS_aa356540-d03e-4f3f-9fd2-53c8d78b4465_BOSC_ae37f589-097e-4d1a-853c-3217cde319d0_SNAPS_','2020-12-16 11:08:42','2020-01-31 09:24:02','101505bc-b31b-4ad2-a860-1496e04dd7e7.png','2020-12-16 12:08:42','SYNCED','101505bc-b31b-4ad2-a860-1496e04dd7e7',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'1016317d-9227-466c-aac7-93a1682c62ff','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1016317d-9227-466c-aac7-93a1682c62ff.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_e70310f5-b4ba-40e1-b9b9-fbf3c922b90b_SESS_f687de0e-63e2-4a92-a913-46f8d090cd17_BOSC_c79f6c00-5b10-4c15-b26e-ac6e51da0e4c_PLY_','2020-12-08 17:27:41','2020-06-17 11:29:57','1016317d-9227-466c-aac7-93a1682c62ff.ply','2020-12-08 18:27:41','SYNCED','1016317d-9227-466c-aac7-93a1682c62ff',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.49.1.1\",\"modelMatrix\":\"0.55223,0.830124,-0.0770472,0,-0.833692,0.549867,-0.0510354,0,1.37341e-9,0.0924169,0.99572,0,18.2252,1.17476,-16.8729,1\",\"title\":\"Mandibule PLY\"}'),(2,'101792d3-d9f3-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/101792d3-d9f3-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_227c16ab-62f2-4f76-a1f4-3a753d883af7_ACT_b819729a-c589-41ec-af68-d13a0bb8c21a_SESS_caed56fc-3a88-41c5-ba84-693c72fc12d4_BOSC_6907490c-7dfd-42e8-aa94-7f0cf85bc022_PLY_','2022-02-01 11:47:41','2019-09-18 11:01:55','101792d3-d9f3-11e9-947d-226cec7cb58a.ply','2022-02-01 12:47:41','SYNCED','101792d3-d9f3-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 152.1.1.1\",\"modelMatrix\":\"-0.989073,-0.139013,0.0490826,0,0.147424,-0.932646,0.329297,0,-2.72371e-9,0.332935,0.94295,0,-15.4641,10.9591,-35.7228,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'101a3bae-d9f3-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/101a3bae-d9f3-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_227c16ab-62f2-4f76-a1f4-3a753d883af7_ACT_b819729a-c589-41ec-af68-d13a0bb8c21a_SESS_caed56fc-3a88-41c5-ba84-693c72fc12d4_TOSC_85f85038-2a2a-4658-8e03-04710b384826_SNAPS_','2022-02-01 11:47:41','2019-09-18 10:56:21','101a3bae-d9f3-11e9-947d-226cec7cb58a.png','2022-02-01 12:47:41','SYNCED','101a3bae-d9f3-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 152.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'101bbb01-d9f3-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/101bbb01-d9f3-11e9-947d-226cec7cb58a.stl','STL','PATIENT_227c16ab-62f2-4f76-a1f4-3a753d883af7_ACT_b819729a-c589-41ec-af68-d13a0bb8c21a_SESS_caed56fc-3a88-41c5-ba84-693c72fc12d4_BOSC_6907490c-7dfd-42e8-aa94-7f0cf85bc022_STL_','2022-02-01 11:47:41','2019-09-18 11:01:55','101bbb01-d9f3-11e9-947d-226cec7cb58a.stl','2022-02-01 12:47:41','SYNCED','101bbb01-d9f3-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 152.1.1.1\",\"modelMatrix\":\"-0.989073,-0.139013,0.0490826,0,0.147424,-0.932646,0.329297,0,-2.72371e-9,0.332935,0.94295,0,-15.4641,10.9591,-35.7228,1\",\"title\":\"MANDIBULE STL\"}'),(2,'101d033d-d9f3-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/101d033d-d9f3-11e9-947d-226cec7cb58a.stl','STL','PATIENT_227c16ab-62f2-4f76-a1f4-3a753d883af7_ACT_b819729a-c589-41ec-af68-d13a0bb8c21a_SESS_caed56fc-3a88-41c5-ba84-693c72fc12d4_TOSC_85f85038-2a2a-4658-8e03-04710b384826_STL_','2022-02-01 11:47:42','2019-09-18 10:56:21','101d033d-d9f3-11e9-947d-226cec7cb58a.stl','2022-02-01 12:47:42','SYNCED','101d033d-d9f3-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 152.1.1.1\",\"modelMatrix\":\"0.752714,-0.55097,0.360353,0,0.658348,0.629944,-0.412005,0,-1.38214e-8,0.547359,0.836898,0,8.67731,-36.5566,-23.1618,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'101e46e6-d9f3-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/101e46e6-d9f3-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_227c16ab-62f2-4f76-a1f4-3a753d883af7_ACT_b819729a-c589-41ec-af68-d13a0bb8c21a_SESS_caed56fc-3a88-41c5-ba84-693c72fc12d4_TOSC_85f85038-2a2a-4658-8e03-04710b384826_PLY_','2022-02-01 11:47:42','2019-09-18 10:56:21','101e46e6-d9f3-11e9-947d-226cec7cb58a.ply','2022-02-01 12:47:42','SYNCED','101e46e6-d9f3-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 152.1.1.1\",\"modelMatrix\":\"0.752714,-0.55097,0.360353,0,0.658348,0.629944,-0.412005,0,-1.38214e-8,0.547359,0.836898,0,8.67731,-36.5566,-23.1618,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'101f0d3a-8936-4977-9397-d7015656c7e8','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/101f0d3a-8936-4977-9397-d7015656c7e8.ply','PLY','PATIENT_c2f74ac1-a607-4117-bca1-6299e1c15bbe_ACT_f29566f7-028f-44b9-a828-a9925dedad13_SESS_172e0ed1-350c-448a-a072-a8f77f85d85d_TOSC_a5abf5b1-d358-4670-88d4-3748e002b62a_PLY_','2022-02-01 11:47:42','2019-09-03 10:11:48','101f0d3a-8936-4977-9397-d7015656c7e8.ply','2022-02-01 12:47:42','SYNCED','101f0d3a-8936-4977-9397-d7015656c7e8',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 8.1.1.1\",\"modelMatrix\":\"0.56475,-0.791955,0.232088,0,0.825262,0.541957,-0.158825,0,-7.97693e-9,0.28123,0.95964,0,-4.10098,-36.1471,-16.7072,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'101fa440-d9f3-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/101fa440-d9f3-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_227c16ab-62f2-4f76-a1f4-3a753d883af7_ACT_b819729a-c589-41ec-af68-d13a0bb8c21a_SESS_caed56fc-3a88-41c5-ba84-693c72fc12d4_BOSC_6907490c-7dfd-42e8-aa94-7f0cf85bc022_SNAPS_','2022-02-01 11:47:42','2019-09-18 11:01:55','101fa440-d9f3-11e9-947d-226cec7cb58a.png','2022-02-01 12:47:42','SYNCED','101fa440-d9f3-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 152.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'105389d9-6ba3-4596-a84f-04c93cae2b6d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/105389d9-6ba3-4596-a84f-04c93cae2b6d.png','SNAPS','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_93c1572c-ea31-4ce0-b14b-8e4f7c735ddd_SESS_b63f2baa-6b1c-4cba-9fb5-a0a17d070a93_BOSC_ab21727f-0c4b-405d-b8f6-4be270028790_SNAPS_','2020-12-16 11:08:44','2020-01-15 14:35:49','105389d9-6ba3-4596-a84f-04c93cae2b6d.png','2020-12-16 12:08:44','SYNCED','105389d9-6ba3-4596-a84f-04c93cae2b6d',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'1053b561-8946-4e01-9515-76b0276d326c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1053b561-8946-4e01-9515-76b0276d326c.png','SNAPS','PATIENT_f02ff132-5a6c-40c5-a006-6246516d9fc3_ACT_bc95ebb7-704d-428f-afd3-47cec36174fe_SESS_d89758fd-b704-4365-b07c-4f7c639a7c68_TOSC_94400656-194e-4cac-8126-b211550ef3bd_SNAPS_','2020-12-23 09:08:28','2019-12-20 14:34:14','1053b561-8946-4e01-9515-76b0276d326c.png','2020-12-23 10:08:28','SYNCED','1053b561-8946-4e01-9515-76b0276d326c',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.2\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'1060937b-c33d-4a5f-92ac-46345b6aa88b','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1060937b-c33d-4a5f-92ac-46345b6aa88b.png','SNAPS','PATIENT_55452abe-c899-4508-a6ad-a6862da81096_ACT_10244838-8d43-4b45-843e-1b1867b80fe9_SESS_a27242e6-79e3-49b8-9935-388a52c32306_TOSC_51f29aae-6608-45c3-a484-99015b6b40b9_SNAPS_','2020-12-08 17:27:44','2020-06-17 09:42:34','1060937b-c33d-4a5f-92ac-46345b6aa88b.png','2020-12-08 18:27:44','SYNCED','1060937b-c33d-4a5f-92ac-46345b6aa88b',0,NULL,'','','{\"displayTitle\":\"Maxillaire 32.1.1.1.10\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'106fa720-e524-4540-bd9b-0f91cf49bf9c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/106fa720-e524-4540-bd9b-0f91cf49bf9c.png','SNAPS','PATIENT_c9dbaf18-0fb2-4968-b361-68c173abadee_ACT_4e71ec6a-14de-49f1-94a7-a434f3d543ed_SESS_e5cc07c8-892b-4ec6-9fac-a0b5b66356ec_TOSC_ba50136d-7065-4cc2-b2a3-3deb58d91911_SNAPS_','2020-12-23 09:08:29','2019-12-31 13:49:05','106fa720-e524-4540-bd9b-0f91cf49bf9c.png','2020-12-23 10:08:29','SYNCED','106fa720-e524-4540-bd9b-0f91cf49bf9c',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'1086363f-3c55-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1086363f-3c55-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_961e5084-1756-4d47-8e90-a6b717094efe_ACT_23eaa3ec-6829-4eb0-80d0-bf925ebdf8e8_SESS_3f982e60-f405-47d3-be5e-6de14bee972a_TOSC_a7889ef2-0f9f-4cbe-9ebe-0fe973faa1fa_SNAPS_','2020-12-16 11:08:44','2020-01-21 14:44:59','1086363f-3c55-11ea-947d-226cec7cb58a.png','2020-12-16 12:08:44','SYNCED','1086363f-3c55-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 199.1.4.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'10882637-3c55-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/10882637-3c55-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_961e5084-1756-4d47-8e90-a6b717094efe_ACT_23eaa3ec-6829-4eb0-80d0-bf925ebdf8e8_SESS_3f982e60-f405-47d3-be5e-6de14bee972a_BOSC_e70da4ec-d154-4226-8e6d-cc143595fb36_PLY_','2020-12-16 11:08:45','2020-01-21 14:49:06','10882637-3c55-11ea-947d-226cec7cb58a.ply','2020-12-16 12:08:45','SYNCED','10882637-3c55-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 199.1.4.1.1\",\"modelMatrix\":\"-0.995553,0.0857369,-0.0390183,0,-0.0941979,-0.906131,0.412374,0,-4.07906e-9,0.414216,0.910178,0,-15.6396,13.063,-19.5767,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'1088eccb-442b-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1088eccb-442b-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_9d55e20d-c9a3-47c1-be07-a1b8b8e1ad46_SESS_f4c4cf33-1da8-4a4f-a33c-5f4ad5b9b16d_BOSC_a577cccc-2b82-47f4-ad7c-b1b671b00bee_PLY_','2020-12-16 11:08:45','2020-01-31 14:08:56','1088eccb-442b-11ea-947d-226cec7cb58a.ply','2020-12-16 12:08:45','SYNCED','1088eccb-442b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.2\",\"modelMatrix\":\"-0.722198,0.687827,-0.0729651,0,-0.691686,-0.718169,0.0761838,0,-3.43021e-9,0.105489,0.99442,0,5.72091,19.7596,-24.2097,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'108a1007-3c55-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/108a1007-3c55-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_961e5084-1756-4d47-8e90-a6b717094efe_ACT_23eaa3ec-6829-4eb0-80d0-bf925ebdf8e8_SESS_3f982e60-f405-47d3-be5e-6de14bee972a_TOSC_a7889ef2-0f9f-4cbe-9ebe-0fe973faa1fa_PLY_','2020-12-16 11:08:45','2020-01-21 14:44:59','108a1007-3c55-11ea-947d-226cec7cb58a.ply','2020-12-16 12:08:45','SYNCED','108a1007-3c55-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 199.1.4.1.1\",\"modelMatrix\":\"0.275271,-0.938386,0.208944,0,0.961366,0.268691,-0.0598276,0,-9.63432e-10,0.21734,0.976096,0,-10.688,-34.7796,-14.0143,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'108bc66b-442b-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/108bc66b-442b-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_9d55e20d-c9a3-47c1-be07-a1b8b8e1ad46_SESS_f4c4cf33-1da8-4a4f-a33c-5f4ad5b9b16d_BOSC_a577cccc-2b82-47f4-ad7c-b1b671b00bee_SNAPS_','2020-12-16 11:08:45','2020-01-31 14:08:56','108bc66b-442b-11ea-947d-226cec7cb58a.png','2020-12-16 12:08:45','SYNCED','108bc66b-442b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.2\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'108c11ba-3c55-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/108c11ba-3c55-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_961e5084-1756-4d47-8e90-a6b717094efe_ACT_23eaa3ec-6829-4eb0-80d0-bf925ebdf8e8_SESS_3f982e60-f405-47d3-be5e-6de14bee972a_BOSC_e70da4ec-d154-4226-8e6d-cc143595fb36_SNAPS_','2020-12-16 11:08:45','2020-01-21 14:49:06','108c11ba-3c55-11ea-947d-226cec7cb58a.png','2020-12-16 12:08:45','SYNCED','108c11ba-3c55-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 199.1.4.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'109185e6-2b67-4d61-a547-1abc00f32a6f','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/109185e6-2b67-4d61-a547-1abc00f32a6f.ply','PLY','PATIENT_183e1e44-c049-45b8-8e15-90b510c1c43f_ACT_739b3c65-5057-49d0-8174-dd85b45325e6_SESS_06e71475-7dc6-49b7-a980-0689aaae3a5d_TOSC_71ce3b04-6516-4d5a-bca5-570015244774_PLY_','2020-12-16 10:52:57','2020-03-12 14:47:11','109185e6-2b67-4d61-a547-1abc00f32a6f.ply','2020-12-16 11:52:57','SYNCED','109185e6-2b67-4d61-a547-1abc00f32a6f',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"modelMatrix\":\"0.500647,-0.848127,0.1733,0,0.865651,0.490512,-0.100228,0,-9.20458e-10,0.200196,0.979756,0,0.276525,-33.1337,-17.6395,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1096e7ef-f4b7-4397-8107-6f5ee3567050','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1096e7ef-f4b7-4397-8107-6f5ee3567050.ply','PLY','PATIENT_f29d1620-d8c6-4d4b-98c3-f69de5d61bdf_ACT_1cf8bd71-aab9-4f6f-82fe-3d87cab0a57f_SESS_2a95fd48-b4d6-433c-9254-cd2ec1e9a139_TOSC_2ec1a6c3-d872-4108-b991-3de386d468ac_PLY_','2020-12-08 17:27:48','2020-06-16 15:14:47','1096e7ef-f4b7-4397-8107-6f5ee3567050.ply','2020-12-08 18:27:48','SYNCED','1096e7ef-f4b7-4397-8107-6f5ee3567050',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.48.1.1\",\"modelMatrix\":\"0.528205,-0.820584,0.218267,0,0.849117,0.510456,-0.135776,0,-1.01886e-8,0.257052,0.966398,0,0.924418,-33.4018,-18.7224,1\",\"title\":\"Maxillaire PLY\"}'),(2,'10bcdd94-f7c2-424c-9a87-13c636aa7c84','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/10bcdd94-f7c2-424c-9a87-13c636aa7c84.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_abfa29ed-6ab0-4bc3-bba5-0eb65b7afeb5_SNAPS_','2020-12-16 11:08:46','2020-01-24 14:02:24','10bcdd94-f7c2-424c-9a87-13c636aa7c84.png','2020-12-16 12:08:46','SYNCED','10bcdd94-f7c2-424c-9a87-13c636aa7c84',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.12\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'10c14f1d-dc8a-45e4-910f-e1859e20c409','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/10c14f1d-dc8a-45e4-910f-e1859e20c409.ply','PLY','PATIENT_11666633-667a-4917-801a-bc4161b9771c_ACT_db5b6146-4c77-4f90-83c3-112726786693_SESS_4493fcea-2851-43f9-9a3a-8a2e4208e653_BOSC_2f54c7e5-fdc2-46e7-989f-ba349b0ef6b1_PLY_','2020-12-16 10:52:57','2020-03-13 11:17:26','10c14f1d-dc8a-45e4-910f-e1859e20c409.ply','2020-12-16 11:52:57','SYNCED','10c14f1d-dc8a-45e4-910f-e1859e20c409',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"modelMatrix\":\"-0.762038,0.566238,-0.314123,0,-0.647533,-0.666367,0.36967,0,-7.4558e-9,0.485107,0.874455,0,-4.75669,17.2501,-20.4079,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'10c884de-d182-444a-9c2a-9fa0e0f8ad86','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/10c884de-d182-444a-9c2a-9fa0e0f8ad86.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_ded13e4f-345b-4d5a-a99e-d24ba3e66dda_PLY_','2020-12-16 11:08:46','2020-01-24 12:08:35','10c884de-d182-444a-9c2a-9fa0e0f8ad86.ply','2020-12-16 12:08:46','SYNCED','10c884de-d182-444a-9c2a-9fa0e0f8ad86',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.3\",\"modelMatrix\":\"0.773921,-0.571864,0.272062,0,0.633282,0.698864,-0.332481,0,-1.40391e-9,0.429606,0.903017,0,7.71486,-28.8235,-19.6118,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'10dc2c45-f7a0-4e8e-804a-2ca8339942eb','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/10dc2c45-f7a0-4e8e-804a-2ca8339942eb.ply','PLY','PATIENT_0c1246d6-d8e8-4416-8498-e34a2e9ddfd8_ACT_196d0994-8364-4a69-b12b-c9b727850beb_SESS_5ebff43b-e87c-4a08-99e1-2e9256d1b756_BOSC_c37ab1f7-7303-447f-956c-4fbb72fc7b9c_PLY_','2021-02-16 16:37:29','2019-12-13 15:26:47','10dc2c45-f7a0-4e8e-804a-2ca8339942eb.ply','2021-02-16 17:37:29','SYNCED','10dc2c45-f7a0-4e8e-804a-2ca8339942eb',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 232.17.1.1\",\"modelMatrix\":\"-0.924831,0.372028,-0.0792599,0,-0.380377,-0.904531,0.192709,0,-7.2367e-9,0.208372,0.97805,0,-4.69585,18.0846,-18.3447,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'10e0aa7c-a321-4b8c-b312-3567244f7be9','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/10e0aa7c-a321-4b8c-b312-3567244f7be9.ply','PLY','PATIENT_e0bced5a-2636-46f1-8f98-24eb38574d86_ACT_7114231e-59fe-4dbe-b163-c55e35db80ad_SESS_ad45cfc7-2ac6-4333-b2e0-9c4ea5658917_TOSC_6b056636-081a-4dcd-a01c-49e40094bf5d_PLY_','2020-12-16 10:52:58','2020-02-03 09:52:44','10e0aa7c-a321-4b8c-b312-3567244f7be9.ply','2020-12-16 11:52:58','SYNCED','10e0aa7c-a321-4b8c-b312-3567244f7be9',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"modelMatrix\":\"0.885171,-0.421284,0.197464,0,0.465266,0.801495,-0.375676,0,-3.41687e-9,0.424411,0.90547,0,7.09732,-32.0527,-19.9183,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'10e144fb-adec-44f6-893e-b61dee442fd7','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/10e144fb-adec-44f6-893e-b61dee442fd7.ply','PLY','PATIENT_aa0253fa-587c-4d87-927c-586cf1c12d57_ACT_e5eb186f-2a8b-4c74-9516-f0334424fe0e_SESS_5c7d8280-efc6-4390-a95d-221b907f1bc9_BOSC_43fcc59e-451b-4c25-966e-e1f5e5fee1bb_PLY_','2021-08-19 22:30:50','2019-12-06 14:34:17','10e144fb-adec-44f6-893e-b61dee442fd7.ply','2021-08-20 00:30:50','SYNCED','10e144fb-adec-44f6-893e-b61dee442fd7',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 226.1.1.1\",\"modelMatrix\":\"-0.868112,0.456547,-0.194799,0,-0.496369,-0.798467,0.340689,0,-1.11033e-8,0.392448,0.919774,0,-12.0843,23.619,-15.1642,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'10e69d66-9684-45b9-b6e3-c5144be59d0c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/10e69d66-9684-45b9-b6e3-c5144be59d0c.ply','PLY','PATIENT_ac556afa-dc57-4ccb-b901-7bf02b7ba533_ACT_0694e700-372e-4a8b-819c-9b2d9dc37d82_SESS_dd32efee-bcf5-4120-87e3-a6ce7dcfc947_TOSC_0058c9db-e562-401a-a474-2f212374481b_PLY_','2020-12-08 17:27:50','2020-06-16 12:15:00','10e69d66-9684-45b9-b6e3-c5144be59d0c.ply','2020-12-08 18:27:50','SYNCED','10e69d66-9684-45b9-b6e3-c5144be59d0c',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.43.1.1\",\"modelMatrix\":\"-0.127539,-0.971629,0.199174,0,0.991833,-0.124941,0.0256116,0,8.96758e-11,0.200814,0.979629,0,-22.3222,-27.1959,-15.4729,1\",\"title\":\"Maxillaire PLY\"}'),(2,'10ed0822-8779-4d0f-925d-cebf5ec4f67c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/10ed0822-8779-4d0f-925d-cebf5ec4f67c.png','SNAPS','PATIENT_9a318c4f-2fbd-4155-a76f-3c43b7d53bae_ACT_19e804ce-ab6b-4e85-a75b-48a6cf8d9f70_SESS_2a5a5787-6d83-45b1-b55b-d274789cd71e_TOSC_e4648601-e914-414b-ace7-c8c291d7d1d8_SNAPS_','2021-02-16 16:37:30','2019-12-12 13:36:08','10ed0822-8779-4d0f-925d-cebf5ec4f67c.png','2021-02-16 17:37:30','SYNCED','10ed0822-8779-4d0f-925d-cebf5ec4f67c',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 232.11.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'10f9fd2e-57d0-486a-a48d-231eaf776eeb','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/10f9fd2e-57d0-486a-a48d-231eaf776eeb.ply','PLY','PATIENT_4887c403-6684-431d-9efd-4230d74f9f6e_ACT_b67be1ff-ec7d-4035-9281-b8e4b218da86_SESS_1c9989e2-d42d-4cab-80e3-b783c63d8a22_TOSC_b3ad7e7c-a51b-4b65-870b-4ffabed1c10b_PLY_','2021-12-30 18:03:34','2019-10-10 14:20:30','10f9fd2e-57d0-486a-a48d-231eaf776eeb.ply','2021-12-30 19:03:34','SYNCED','10f9fd2e-57d0-486a-a48d-231eaf776eeb',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 184.1.1.1\",\"modelMatrix\":\"0.733226,-0.629536,0.25703,0,0.679985,0.678827,-0.277155,0,2.52571e-10,0.377993,0.925808,0,8.11236,-32.0667,-19.5463,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1108e972-4ce2-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1108e972-4ce2-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_07480190-0d9c-4257-9d2e-30433b4d0f2e_ACT_b87f78f7-4db0-4789-82e1-1c37b8aac67f_SESS_ae425182-f3c4-425c-a079-fc17daf9015d_TOSC_2bc89f44-a112-4afb-8a09-405f40ea785c_SNAPS_','2020-12-16 10:52:59','2020-02-11 16:16:44','1108e972-4ce2-11ea-947d-226cec7cb58a.png','2020-12-16 11:52:59','SYNCED','1108e972-4ce2-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'110adb91-4ce2-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/110adb91-4ce2-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_b87f78f7-4db0-4789-82e1-1c37b8aac67f_SESS_ae425182-f3c4-425c-a079-fc17daf9015d_BOSC_ed65e1e9-a32b-43d2-b619-817448c25380_PLY_','2020-12-16 10:52:59','2020-02-11 16:19:49','110adb91-4ce2-11ea-947d-226cec7cb58a.ply','2020-12-16 11:52:59','SYNCED','110adb91-4ce2-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"modelMatrix\":\"-0.830204,0.537949,-0.14619,0,-0.557459,-0.801149,0.217716,0,-9.28874e-9,0.262244,0.965002,0,-5.74524,24.3241,-20.8038,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'110de2c1-4ce2-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/110de2c1-4ce2-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_b87f78f7-4db0-4789-82e1-1c37b8aac67f_SESS_ae425182-f3c4-425c-a079-fc17daf9015d_BOSC_ed65e1e9-a32b-43d2-b619-817448c25380_SNAPS_','2020-12-16 10:52:59','2020-02-11 16:19:49','110de2c1-4ce2-11ea-947d-226cec7cb58a.png','2020-12-16 11:52:59','SYNCED','110de2c1-4ce2-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'110fac0f-4ce2-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/110fac0f-4ce2-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_07480190-0d9c-4257-9d2e-30433b4d0f2e_ACT_b87f78f7-4db0-4789-82e1-1c37b8aac67f_SESS_ae425182-f3c4-425c-a079-fc17daf9015d_TOSC_2bc89f44-a112-4afb-8a09-405f40ea785c_PLY_','2020-12-16 10:52:59','2020-02-11 16:16:44','110fac0f-4ce2-11ea-947d-226cec7cb58a.ply','2020-12-16 11:52:59','SYNCED','110fac0f-4ce2-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"modelMatrix\":\"0.893371,-0.428008,0.136736,0,0.449319,0.850999,-0.27187,0,1.12844e-8,0.304319,0.95257,0,5.88881,-28.5979,-19.4854,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'111366f7-10f5-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/111366f7-10f5-11ea-947d-226cec7cb58a.stl','STL','PATIENT_94217f81-bba6-4d76-8071-78114d090c03_ACT_94854232-4ce3-4ade-b690-a1ad1b56e2ec_SESS_51fac453-ecfe-4176-93bb-b7870f3eab12_TOSC_11befdd9-1e0d-4933-a7fc-78c3659f0160_STL_','2021-08-19 22:30:51','2019-11-27 15:00:07','111366f7-10f5-11ea-947d-226cec7cb58a.stl','2021-08-20 00:30:51','SYNCED','111366f7-10f5-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.35.1.1\",\"modelMatrix\":\"0.652087,-0.69678,0.298796,0,0.758144,0.599308,-0.256998,0,-1.47181e-8,0.394115,0.919061,0,-2.30351,-36.4461,-20.8583,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'11152d70-10f5-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/11152d70-10f5-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_94217f81-bba6-4d76-8071-78114d090c03_ACT_94854232-4ce3-4ade-b690-a1ad1b56e2ec_SESS_51fac453-ecfe-4176-93bb-b7870f3eab12_TOSC_11befdd9-1e0d-4933-a7fc-78c3659f0160_PLY_','2021-08-19 22:30:52','2019-11-27 15:00:07','11152d70-10f5-11ea-947d-226cec7cb58a.ply','2021-08-20 00:30:52','SYNCED','11152d70-10f5-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.35.1.1\",\"modelMatrix\":\"0.652087,-0.69678,0.298796,0,0.758144,0.599308,-0.256998,0,-1.47181e-8,0.394115,0.919061,0,-2.30351,-36.4461,-20.8583,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1116af65-10f5-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1116af65-10f5-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_94854232-4ce3-4ade-b690-a1ad1b56e2ec_SESS_51fac453-ecfe-4176-93bb-b7870f3eab12_BOSC_81de6de6-52e9-4d77-87d1-8f7bbc858779_SNAPS_','2021-08-19 22:30:52','2019-11-27 15:05:03','1116af65-10f5-11ea-947d-226cec7cb58a.png','2021-08-20 00:30:52','SYNCED','1116af65-10f5-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'1118233c-10f5-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1118233c-10f5-11ea-947d-226cec7cb58a.stl','STL','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_94854232-4ce3-4ade-b690-a1ad1b56e2ec_SESS_51fac453-ecfe-4176-93bb-b7870f3eab12_BOSC_81de6de6-52e9-4d77-87d1-8f7bbc858779_STL_','2021-08-19 22:30:53','2019-11-27 15:05:03','1118233c-10f5-11ea-947d-226cec7cb58a.stl','2021-08-20 00:30:53','SYNCED','1118233c-10f5-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.1.1\",\"modelMatrix\":\"-0.979421,0.19454,-0.0537443,0,-0.201827,-0.944057,0.260808,0,4.84857e-9,0.266288,0.963893,0,-15.5517,20.6473,-21.9075,1\",\"title\":\"MANDIBULE STL\"}'),(2,'1119c3c3-10f5-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1119c3c3-10f5-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_94854232-4ce3-4ade-b690-a1ad1b56e2ec_SESS_51fac453-ecfe-4176-93bb-b7870f3eab12_BOSC_81de6de6-52e9-4d77-87d1-8f7bbc858779_PLY_','2021-08-19 22:31:00','2019-11-27 15:05:03','1119c3c3-10f5-11ea-947d-226cec7cb58a.ply','2021-08-20 00:31:00','SYNCED','1119c3c3-10f5-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.1.1\",\"modelMatrix\":\"-0.979421,0.19454,-0.0537443,0,-0.201827,-0.944057,0.260808,0,4.84857e-9,0.266288,0.963893,0,-15.5517,20.6473,-21.9075,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'111af839-1db7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/111af839-1db7-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_d175f0ac-06f6-49a0-9ab4-bbd562516521_ACT_aa317266-3fb3-41c2-9073-a3de3bc4c25e_SESS_dfe9ad46-537f-4906-b524-e43990804e77_BOSC_60eb325b-c417-4cd5-b583-f6a1b33e83ee_PLY_','2021-02-16 16:37:33','2019-12-13 15:44:19','111af839-1db7-11ea-947d-226cec7cb58a.ply','2021-02-16 17:37:33','SYNCED','111af839-1db7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 232.7.1.1\",\"modelMatrix\":\"-0.848858,0.512865,-0.1281,0,-0.528621,-0.823557,0.205703,0,7.31659e-9,0.24233,0.970194,0,-5.95898,17.4392,-19.223,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'111b5f51-10f5-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/111b5f51-10f5-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_94217f81-bba6-4d76-8071-78114d090c03_ACT_94854232-4ce3-4ade-b690-a1ad1b56e2ec_SESS_51fac453-ecfe-4176-93bb-b7870f3eab12_TOSC_11befdd9-1e0d-4933-a7fc-78c3659f0160_SNAPS_','2021-08-19 22:31:01','2019-11-27 15:00:07','111b5f51-10f5-11ea-947d-226cec7cb58a.png','2021-08-20 00:31:01','SYNCED','111b5f51-10f5-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.35.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'111c952b-1db7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/111c952b-1db7-11ea-947d-226cec7cb58a.stl','STL','PATIENT_dc4cf315-524d-408f-b8de-af607aab88f6_ACT_aa317266-3fb3-41c2-9073-a3de3bc4c25e_SESS_dfe9ad46-537f-4906-b524-e43990804e77_TOSC_53f6668c-148c-4894-a873-656e22b88b95_STL_','2021-02-16 16:37:34','2019-12-13 15:40:43','111c952b-1db7-11ea-947d-226cec7cb58a.stl','2021-02-16 17:37:34','SYNCED','111c952b-1db7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 232.25.1.1\",\"modelMatrix\":\"0.495435,-0.854978,0.153485,0,0.868645,0.48764,-0.0875406,0,1.85425e-9,0.176695,0.984266,0,-6.04437,-34.6594,-11.6895,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'111e1d39-1db7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/111e1d39-1db7-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_d175f0ac-06f6-49a0-9ab4-bbd562516521_ACT_aa317266-3fb3-41c2-9073-a3de3bc4c25e_SESS_dfe9ad46-537f-4906-b524-e43990804e77_BOSC_60eb325b-c417-4cd5-b583-f6a1b33e83ee_SNAPS_','2021-02-16 16:37:35','2019-12-13 15:44:19','111e1d39-1db7-11ea-947d-226cec7cb58a.png','2021-02-16 17:37:35','SYNCED','111e1d39-1db7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 232.7.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'111e2bb9-6be3-4902-86d5-b319501d3d80','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/111e2bb9-6be3-4902-86d5-b319501d3d80.ply','PLY','PATIENT_f93454c6-663d-4e6d-ac6f-b722071bd526_ACT_d2592cf9-13e5-45b6-8fed-2e88d5fda817_SESS_97a06e73-bc39-462a-a930-2f76dc7b4983_TOSC_0837b222-4252-4d45-b27d-2e595bde000d_PLY_','2021-12-30 18:03:35','2019-10-15 10:52:44','111e2bb9-6be3-4902-86d5-b319501d3d80.ply','2021-12-30 19:03:35','SYNCED','111e2bb9-6be3-4902-86d5-b319501d3d80',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 187.1.1.1\",\"modelMatrix\":\"0.766695,-0.551525,0.328632,0,0.642011,0.658635,-0.392455,0,1.58339e-8,0.511879,0.859057,0,5.94099,-37.2687,-25.7941,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'111f8f20-1db7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/111f8f20-1db7-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_dc4cf315-524d-408f-b8de-af607aab88f6_ACT_aa317266-3fb3-41c2-9073-a3de3bc4c25e_SESS_dfe9ad46-537f-4906-b524-e43990804e77_TOSC_53f6668c-148c-4894-a873-656e22b88b95_PLY_','2021-02-16 16:37:36','2019-12-13 15:40:43','111f8f20-1db7-11ea-947d-226cec7cb58a.ply','2021-02-16 17:37:36','SYNCED','111f8f20-1db7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 232.25.1.1\",\"modelMatrix\":\"0.495435,-0.854978,0.153485,0,0.868645,0.48764,-0.0875406,0,1.85425e-9,0.176695,0.984266,0,-6.04437,-34.6594,-11.6895,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1120f2df-1db7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1120f2df-1db7-11ea-947d-226cec7cb58a.stl','STL','PATIENT_d175f0ac-06f6-49a0-9ab4-bbd562516521_ACT_aa317266-3fb3-41c2-9073-a3de3bc4c25e_SESS_dfe9ad46-537f-4906-b524-e43990804e77_BOSC_60eb325b-c417-4cd5-b583-f6a1b33e83ee_STL_','2021-02-16 16:37:37','2019-12-13 15:44:19','1120f2df-1db7-11ea-947d-226cec7cb58a.stl','2021-02-16 17:37:37','SYNCED','1120f2df-1db7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 232.7.1.1\",\"modelMatrix\":\"-0.848858,0.512865,-0.1281,0,-0.528621,-0.823557,0.205703,0,7.31659e-9,0.24233,0.970194,0,-5.95898,17.4392,-19.223,1\",\"title\":\"MANDIBULE STL\"}'),(2,'11226cf7-1db7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/11226cf7-1db7-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_dc4cf315-524d-408f-b8de-af607aab88f6_ACT_aa317266-3fb3-41c2-9073-a3de3bc4c25e_SESS_dfe9ad46-537f-4906-b524-e43990804e77_TOSC_53f6668c-148c-4894-a873-656e22b88b95_SNAPS_','2021-02-16 16:37:38','2019-12-13 15:40:43','11226cf7-1db7-11ea-947d-226cec7cb58a.png','2021-02-16 17:37:38','SYNCED','11226cf7-1db7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 232.25.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'11230705-1f49-4cab-b70f-f09f75a10606','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/11230705-1f49-4cab-b70f-f09f75a10606.stl','STL','PATIENT_18e1787a-bf25-4981-a2fe-48b513b09fce_ACT_434c7d20-a87d-47a3-945f-330dbfbe77f8_SESS_a6b3c304-cd51-4641-9b06-701bf64e1282_TOSC_e18eb57c-be08-4f06-9091-68bda90c3426_STL_','2021-02-16 16:37:38','2019-12-06 11:21:05','11230705-1f49-4cab-b70f-f09f75a10606.stl','2021-02-16 17:37:38','SYNCED','11230705-1f49-4cab-b70f-f09f75a10606',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 228.1.1.1\",\"modelMatrix\":\"0.306537,-0.91734,0.254015,0,0.951859,0.295421,-0.081803,0,-4.87439e-9,0.266862,0.963735,0,-12.2128,-34.6975,-11.4216,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'11275903-8d01-4ec9-b0d9-60b5ad0dc250','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/11275903-8d01-4ec9-b0d9-60b5ad0dc250.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_1b2563b4-6ca9-4353-8810-00a3b6f4378e_SESS_eeba68d7-6bf0-4fea-99e1-d28e1baff33b_BOSC_262ee06c-735d-4fce-a32a-d4dc48b5ba9d_PLY_','2020-12-16 10:53:02','2020-05-20 15:48:20','11275903-8d01-4ec9-b0d9-60b5ad0dc250.ply','2020-12-16 11:53:02','SYNCED','11275903-8d01-4ec9-b0d9-60b5ad0dc250',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 216.1.5.1.1\",\"modelMatrix\":\"-0.999957,-0.00824559,0.00427792,0,0.00928926,-0.887609,0.460503,0,3.45186e-10,0.460523,0.887648,0,-15.7738,14.3181,-21.1369,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'1128bb17-2e83-4185-a1db-97da2becc438','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1128bb17-2e83-4185-a1db-97da2becc438.stl','STL','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_TOSC_407f969e-5180-4ec7-b88f-a5d10ba9e59a_STL_','2021-12-30 18:03:35','2019-11-15 12:03:13','1128bb17-2e83-4185-a1db-97da2becc438.stl','2021-12-30 19:03:35','SYNCED','1128bb17-2e83-4185-a1db-97da2becc438',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 202.1.1.1\",\"modelMatrix\":\"0.641273,-0.679181,0.357048,0,0.767313,0.567617,-0.298398,0,2.24697e-8,0.465322,0.885141,0,2.64201,-35.7414,-29.5451,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'112dffa9-acff-4d58-b660-eec99bc17d20','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/112dffa9-acff-4d58-b660-eec99bc17d20.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_bd76c4b5-3ac5-48cb-b314-fee96325cdde_SESS_672a732f-3308-43cc-a6cb-ad8b107ad6e3_BOSC_9eb75a54-78c3-4ce7-8343-2e6ea1bc1028_SNAPS_','2021-06-07 11:39:08','2020-05-22 15:00:47','112dffa9-acff-4d58-b660-eec99bc17d20.png','2021-06-07 13:39:08','SYNCED','112dffa9-acff-4d58-b660-eec99bc17d20',0,'2021-06-07 13:39:08','','','{\"displayTitle\":\"MANDIBULE 216.1.10.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'112e152a-1f8b-4a28-8f3e-cda3fa38be05','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/112e152a-1f8b-4a28-8f3e-cda3fa38be05.ply','PLY','PATIENT_a951fff6-cb01-45e2-9da5-6b824792106c_ACT_aae68188-e6dc-4e55-a08c-a7bbaf441a12_SESS_efcfe50e-78d9-4126-b2c0-f59373cb399c_TOSC_6801e179-f17f-4b52-a428-23baefe0e101_PLY_','2022-03-04 13:40:25','2019-07-10 15:40:11','112e152a-1f8b-4a28-8f3e-cda3fa38be05.ply','2022-03-04 14:40:25','SYNCED','112e152a-1f8b-4a28-8f3e-cda3fa38be05',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 28.1.1.1\",\"modelMatrix\":\"0.99658,-0.0806812,0.0178831,0,0.0826393,0.972966,-0.215659,0,-8.65997e-10,0.216399,0.976305,0,-28.8034,-20.3675,-16.9924,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'11418556-8b09-4c5a-ae45-b012eeb5bb56','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/11418556-8b09-4c5a-ae45-b012eeb5bb56.ply','PLY','PATIENT_1dc3cc8c-4494-44b4-aa1f-d9de15a13484_ACT_4988c2b0-951d-4074-9c77-d6890a307dec_SESS_9fe66e73-19c3-46db-9286-3c347d08985c_TOSC_853c3192-707a-49f5-ba41-579283ad8295_PLY_','2022-02-01 11:47:42','2019-09-20 10:25:18','11418556-8b09-4c5a-ae45-b012eeb5bb56.ply','2022-02-01 12:47:42','SYNCED','11418556-8b09-4c5a-ae45-b012eeb5bb56',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 158.1.1.1\",\"modelMatrix\":\"0.324108,-0.875203,0.35913,0,0.94602,0.299846,-0.123038,0,-8.88826e-9,0.379621,0.925142,0,-10.401,-38.1834,-18.9947,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1169a61d-0c6e-49ee-b63a-ad342fa63f9e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1169a61d-0c6e-49ee-b63a-ad342fa63f9e.ply','PLY','PATIENT_8d82ec2a-5aab-4c9b-b6ad-36b7d5ee6b2e_ACT_10218071-9e0c-43c4-85ff-32ab432e2d0c_SESS_24753abd-8bfd-4d4a-9076-ac7545bfde80_BOSC_cd7d5b67-d7b4-488e-bc50-6c7b6c2e30d0_PLY_','2022-02-01 11:47:43','2019-07-22 12:19:52','1169a61d-0c6e-49ee-b63a-ad342fa63f9e.ply','2022-02-01 12:47:43','SYNCED','1169a61d-0c6e-49ee-b63a-ad342fa63f9e',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 105.1.1.1\",\"modelMatrix\":\"-0.997324,-0.0730375,0.00334979,0,0.0731143,-0.996276,0.0456933,0,-1.30989e-10,0.0458159,0.99895,0,-20.9429,20.1733,-27.6732,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'11883456-ad19-4b63-a695-590dea7a50ef','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/11883456-ad19-4b63-a695-590dea7a50ef.png','SNAPS','PATIENT_d31bbbbf-04d4-4ed1-a51f-8bd816669381_ACT_6f07aa75-bd4a-40ca-8b16-b0dc3e7e96dc_SESS_966435b6-291a-4cc9-8a4b-0d5ec3acc397_TOSC_486a4dbb-bee4-444d-af1c-f46ca7ace71c_SNAPS_','2021-12-30 18:03:35','2019-11-18 15:13:01','11883456-ad19-4b63-a695-590dea7a50ef.png','2021-12-30 19:03:35','SYNCED','11883456-ad19-4b63-a695-590dea7a50ef',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 205.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'119b6f5a-23c8-40c0-90c5-a039d1b113e4','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/119b6f5a-23c8-40c0-90c5-a039d1b113e4.png','SNAPS','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_BOSC_f472891f-1148-4844-8dd6-79068cdb039a_SNAPS_','2021-12-30 18:03:36','2019-11-14 12:08:36','119b6f5a-23c8-40c0-90c5-a039d1b113e4.png','2021-12-30 19:03:36','SYNCED','119b6f5a-23c8-40c0-90c5-a039d1b113e4',0,NULL,'','','{\"displayTitle\":\"Mandibola 0\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'119da9e2-b8db-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/119da9e2-b8db-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_4907c007-c2a7-4673-ad2b-3d0ad664a56e_ACT_93dab2ca-c638-414c-ad53-70a4424fd6c3_SESS_d59b2d16-19af-44df-a9dd-eb468bab0096_TOSC_c7936b41-40df-41f7-bdd3-4e525ee41b1a_SNAPS_','2022-02-01 11:47:43','2019-08-07 10:17:34','119da9e2-b8db-11e9-a33b-226cec7cb58a.png','2022-02-01 12:47:43','SYNCED','119da9e2-b8db-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 128.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'119e5569-b8db-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/119e5569-b8db-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_4907c007-c2a7-4673-ad2b-3d0ad664a56e_ACT_93dab2ca-c638-414c-ad53-70a4424fd6c3_SESS_d59b2d16-19af-44df-a9dd-eb468bab0096_BOSC_8d03083e-580f-4773-8ec2-b0890561a335_STL_','2022-02-01 11:47:43','2019-08-07 10:25:42','119e5569-b8db-11e9-a33b-226cec7cb58a.stl','2022-02-01 12:47:43','SYNCED','119e5569-b8db-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 128.1.1.1\",\"modelMatrix\":\"-0.96361,0.249265,-0.0965495,0,-0.26731,-0.89856,0.348045,0,-4.87365e-10,0.361189,0.932493,0,-10.8158,19.6873,-18.7196,1\",\"title\":\"MANDIBULE STL\"}'),(2,'119ef19e-b8db-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/119ef19e-b8db-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_4907c007-c2a7-4673-ad2b-3d0ad664a56e_ACT_93dab2ca-c638-414c-ad53-70a4424fd6c3_SESS_d59b2d16-19af-44df-a9dd-eb468bab0096_BOSC_8d03083e-580f-4773-8ec2-b0890561a335_SNAPS_','2022-02-01 11:47:43','2019-08-07 10:25:42','119ef19e-b8db-11e9-a33b-226cec7cb58a.png','2022-02-01 12:47:43','SYNCED','119ef19e-b8db-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 128.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'119f87e1-b8db-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/119f87e1-b8db-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_4907c007-c2a7-4673-ad2b-3d0ad664a56e_ACT_93dab2ca-c638-414c-ad53-70a4424fd6c3_SESS_d59b2d16-19af-44df-a9dd-eb468bab0096_BOSC_8d03083e-580f-4773-8ec2-b0890561a335_PLY_','2022-02-01 11:47:43','2019-08-07 10:25:42','119f87e1-b8db-11e9-a33b-226cec7cb58a.ply','2022-02-01 12:47:43','SYNCED','119f87e1-b8db-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 128.1.1.1\",\"modelMatrix\":\"-0.96361,0.249265,-0.0965495,0,-0.26731,-0.89856,0.348045,0,-4.87365e-10,0.361189,0.932493,0,-10.8158,19.6873,-18.7196,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'11a020dd-b8db-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/11a020dd-b8db-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_4907c007-c2a7-4673-ad2b-3d0ad664a56e_ACT_93dab2ca-c638-414c-ad53-70a4424fd6c3_SESS_d59b2d16-19af-44df-a9dd-eb468bab0096_TOSC_c7936b41-40df-41f7-bdd3-4e525ee41b1a_STL_','2022-02-01 11:47:44','2019-08-07 10:17:34','11a020dd-b8db-11e9-a33b-226cec7cb58a.stl','2022-02-01 12:47:44','SYNCED','11a020dd-b8db-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 128.1.1.1\",\"modelMatrix\":\"0.815633,-0.51006,0.273097,0,0.57857,0.719052,-0.384995,0,1.33106e-9,0.47202,0.881588,0,5.89755,-42.8992,-27.14,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'11a0bf65-b8db-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/11a0bf65-b8db-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_4907c007-c2a7-4673-ad2b-3d0ad664a56e_ACT_93dab2ca-c638-414c-ad53-70a4424fd6c3_SESS_d59b2d16-19af-44df-a9dd-eb468bab0096_TOSC_c7936b41-40df-41f7-bdd3-4e525ee41b1a_PLY_','2022-02-01 11:47:44','2019-08-07 10:17:34','11a0bf65-b8db-11e9-a33b-226cec7cb58a.ply','2022-02-01 12:47:44','SYNCED','11a0bf65-b8db-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 128.1.1.1\",\"modelMatrix\":\"0.815633,-0.51006,0.273097,0,0.57857,0.719052,-0.384995,0,1.33106e-9,0.47202,0.881588,0,5.89755,-42.8992,-27.14,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'11ba8748-62ca-4252-8e09-7570455ec776','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/11ba8748-62ca-4252-8e09-7570455ec776.png','SNAPS','PATIENT_aa0253fa-587c-4d87-927c-586cf1c12d57_ACT_e5eb186f-2a8b-4c74-9516-f0334424fe0e_SESS_5c7d8280-efc6-4390-a95d-221b907f1bc9_TOSC_4c5f0c23-fe3e-4a9d-a4fd-05a080c0d594_SNAPS_','2021-08-19 22:31:20','2019-12-06 14:30:28','11ba8748-62ca-4252-8e09-7570455ec776.png','2021-08-20 00:31:20','SYNCED','11ba8748-62ca-4252-8e09-7570455ec776',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 226.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'11c991ff-2788-4410-a2e5-0c99023adbcb','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/11c991ff-2788-4410-a2e5-0c99023adbcb.png','SNAPS','PATIENT_a38850a1-cad3-4402-b419-3e6d42249a53_ACT_f247cbbe-6a56-4c48-852f-b5c48e626d26_SESS_8226bbaa-5cce-4619-8dd0-58dac53b8bac_TOSC_62ce4ee0-97a5-46fb-a8e5-7d31244d8c6d_SNAPS_','2021-08-19 22:31:21','2019-11-29 15:50:11','11c991ff-2788-4410-a2e5-0c99023adbcb.png','2021-08-20 00:31:21','SYNCED','11c991ff-2788-4410-a2e5-0c99023adbcb',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 217.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'11cb3b3b-91ec-4008-9e19-1f875252ab55','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/11cb3b3b-91ec-4008-9e19-1f875252ab55.ply','PLY','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_905e26fe-fadd-48d5-abd5-6c436f4a2d5e_SESS_1e25ea8a-5850-42e8-a874-a54e6c1ed24d_BOSC_ffe3ec63-7c87-43b5-8032-7668493193b5_PLY_','2020-12-16 11:08:53','2020-01-15 14:46:37','11cb3b3b-91ec-4008-9e19-1f875252ab55.ply','2020-12-16 12:08:53','SYNCED','11cb3b3b-91ec-4008-9e19-1f875252ab55',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.1.1.1.1\",\"modelMatrix\":\"0.989863,0.141342,-0.0139391,0,-0.142028,0.985084,-0.0971484,0,1.26463e-9,0.0981433,0.995172,0,14.8029,-13.5953,-23.2414,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'11e42201-0446-4ad7-9a65-e1c300a11f99','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/11e42201-0446-4ad7-9a65-e1c300a11f99.png','SNAPS','PATIENT_961e5084-1756-4d47-8e90-a6b717094efe_ACT_e578fe8c-ed3c-46bc-b105-bc17f69b4a2e_SESS_9f266ece-fc0c-49df-ba49-eeafaee3b31b_BOSC_05e98f2e-9554-4971-b08d-3b988c5efd29_SNAPS_','2020-12-16 11:08:53','2020-01-21 11:49:58','11e42201-0446-4ad7-9a65-e1c300a11f99.png','2020-12-16 12:08:53','SYNCED','11e42201-0446-4ad7-9a65-e1c300a11f99',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 199.1.2.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'11e4459f-5efc-4c0b-8919-d359514b9fae','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/11e4459f-5efc-4c0b-8919-d359514b9fae.png','SNAPS','PATIENT_0453378f-5439-4da7-9cb5-52d1ffc679d4_ACT_30d14ef5-fb40-43a4-bfff-e611ee67a93e_SESS_cd91998e-cbf9-4ceb-929b-eb2c0c8baf3f_BOSC_afaca07b-b1a9-4e3c-8e6b-c773b4e9ab85_SNAPS_','2022-02-01 11:47:44','2019-09-30 10:57:12','11e4459f-5efc-4c0b-8919-d359514b9fae.png','2022-02-01 12:47:44','SYNCED','11e4459f-5efc-4c0b-8919-d359514b9fae',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 165.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'11ee1821-22c5-436f-a334-91b8a20c06c5','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/11ee1821-22c5-436f-a334-91b8a20c06c5.stl','STL','PATIENT_28da837d-b270-4c64-a49b-609a27dfbf59_ACT_38cbf729-ea81-4758-b1f1-e1d4e43ec5e6_SESS_d015bead-b2da-46e2-b4dd-1364cd56bc0b_BOSC_39da3e5f-6d40-4537-b9ba-6fa1daec4ff6_STL_','2021-12-30 18:03:37','2019-11-13 10:30:38','11ee1821-22c5-436f-a334-91b8a20c06c5.stl','2021-12-30 19:03:37','SYNCED','11ee1821-22c5-436f-a334-91b8a20c06c5',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 201.1.1.1\",\"modelMatrix\":\"-0.998824,-0.0481664,0.00560844,0,0.0484918,-0.992121,0.115521,0,2.54363e-10,0.115657,0.993289,0,-14.1895,12.9261,-26.9041,1\",\"title\":\"MANDIBULE STL\"}'),(2,'11f3c63b-2697-468f-acd8-3283cb054521','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/11f3c63b-2697-468f-acd8-3283cb054521.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_9d457cf7-2ac5-41fa-ac28-5cc81ee6178a_SESS_234f0eb8-1a1c-45f0-a535-9f2becf0b609_BOSC_dacd7773-dda3-4729-9529-ee2868c579f7_SNAPS_','2020-12-16 10:53:06','2020-02-12 10:10:18','11f3c63b-2697-468f-acd8-3283cb054521.png','2020-12-16 11:53:06','SYNCED','11f3c63b-2697-468f-acd8-3283cb054521',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'12155e71-9341-4a24-a857-45ba51d0e155','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/12155e71-9341-4a24-a857-45ba51d0e155.png','SNAPS','PATIENT_e5ec82ce-272f-4cfc-a1af-8ca2c13bd4bb_ACT_27004097-68f2-405a-98a0-7cbc2f692fdd_SESS_e3aea28a-9d4b-474c-ad01-212949dc63e0_BOSC_6dcd22a2-aa3d-4b4e-8017-803d8035b345_SNAPS_','2020-12-23 09:08:39','2020-01-06 10:29:31','12155e71-9341-4a24-a857-45ba51d0e155.png','2020-12-23 10:08:39','SYNCED','12155e71-9341-4a24-a857-45ba51d0e155',0,NULL,'','','{\"displayTitle\":\"Mandible 249.13.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'121c9216-7760-49b9-b035-43b71b302b07','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/121c9216-7760-49b9-b035-43b71b302b07.png','SNAPS','PATIENT_f827f9c4-0c33-4508-b7f0-8cbdcc7bcb4a_ACT_d881b54e-7ed6-464c-be49-c16760f416fc_SESS_e5dab94e-84e8-4be2-a2b7-01cbd59dd940_TOSC_d7499d53-78ad-465f-9a64-497e8f7fd240_SNAPS_','2020-12-16 10:53:07','2020-05-28 09:20:58','121c9216-7760-49b9-b035-43b71b302b07.png','2020-12-16 11:53:07','SYNCED','121c9216-7760-49b9-b035-43b71b302b07',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 216.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'121c976a-3396-4872-b8cb-8477e7a472a0','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/121c976a-3396-4872-b8cb-8477e7a472a0.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_26f4869e-6740-4a46-b6e1-dabb923817ec_SESS_7ff1892f-9158-4cdd-a409-5b43ca392387_BOSC_b053286b-1a30-438f-89de-17486cbbda90_PLY_','2020-12-16 10:53:07','2020-02-28 11:25:22','121c976a-3396-4872-b8cb-8477e7a472a0.ply','2020-12-16 11:53:07','SYNCED','121c976a-3396-4872-b8cb-8477e7a472a0',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"modelMatrix\":\"-0.867064,0.480137,-0.132926,0,-0.498198,-0.835631,0.231344,0,-5.03163e-10,0.266814,0.963748,0,-3.47784,13.3719,-18.8118,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'122e3a2f-9c33-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/122e3a2f-9c33-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_df003086-bcf3-4ed8-ba31-74d187f47a6d_SESS_ba6046a0-3247-4f95-9a2c-ee17117d8eb6_TOSC_0c478ee7-bd2a-4fa6-aebc-321505375018_PLY_','2020-12-16 10:53:07','2020-05-22 15:46:20','122e3a2f-9c33-11ea-947d-226cec7cb58a.ply','2020-12-16 11:53:07','SYNCED','122e3a2f-9c33-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 216.1.12.1.2\",\"modelMatrix\":\"-0.298816,-0.929308,0.217014,0,0.954311,-0.290987,0.0679518,0,-5.4301e-9,0.227404,0.973801,0,-24.6494,-18.5468,-25.1141,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'12305c07-9c33-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/12305c07-9c33-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_df003086-bcf3-4ed8-ba31-74d187f47a6d_SESS_ba6046a0-3247-4f95-9a2c-ee17117d8eb6_TOSC_0c478ee7-bd2a-4fa6-aebc-321505375018_SNAPS_','2020-12-16 10:53:07','2020-05-22 15:46:20','12305c07-9c33-11ea-947d-226cec7cb58a.png','2020-12-16 11:53:07','SYNCED','12305c07-9c33-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 216.1.12.1.2\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'12333fd0-9c33-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/12333fd0-9c33-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_df003086-bcf3-4ed8-ba31-74d187f47a6d_SESS_ba6046a0-3247-4f95-9a2c-ee17117d8eb6_BOSC_c5370f20-995e-44df-9c42-3316454d9cd9_SNAPS_','2020-12-16 10:53:08','2020-05-22 15:48:59','12333fd0-9c33-11ea-947d-226cec7cb58a.png','2020-12-16 11:53:08','SYNCED','12333fd0-9c33-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 216.1.12.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'12346b47-7f82-4a9a-93af-c25c346e4428','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/12346b47-7f82-4a9a-93af-c25c346e4428.ply','PLY','PATIENT_d81819be-bc30-4092-b5e9-498e0cbb7c78_ACT_e2efb8df-4ec9-4c9d-98df-c9d1978d79fb_SESS_1d7bc7d7-a77e-46e6-aaa2-768afa5219c9_TOSC_d3008fbd-07ec-48bb-977f-8c7a251900fe_PLY_','2022-02-01 11:47:44','2019-07-15 16:30:13','12346b47-7f82-4a9a-93af-c25c346e4428.ply','2022-02-01 12:47:44','SYNCED','12346b47-7f82-4a9a-93af-c25c346e4428',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 71.1.1.1\",\"modelMatrix\":\"0.859323,-0.488528,0.151342,0,0.511433,0.820837,-0.254289,0,3.42811e-9,0.295917,0.955213,0,11.5965,-27.3857,-15.4448,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'123566ec-9c33-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/123566ec-9c33-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_df003086-bcf3-4ed8-ba31-74d187f47a6d_SESS_ba6046a0-3247-4f95-9a2c-ee17117d8eb6_BOSC_c5370f20-995e-44df-9c42-3316454d9cd9_PLY_','2020-12-16 10:53:08','2020-05-22 15:48:59','123566ec-9c33-11ea-947d-226cec7cb58a.ply','2020-12-16 11:53:08','SYNCED','123566ec-9c33-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 216.1.12.1.1\",\"modelMatrix\":\"-0.982589,0.178268,-0.0523398,0,-0.185793,-0.942794,0.276805,0,3.99435e-10,0.28171,0.9595,0,-8.80223,13.3169,-21.5072,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'1240b62e-cd69-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1240b62e-cd69-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_df2eeadd-f92f-4837-9d06-8003b62898b8_ACT_41c458ba-26b5-45af-82c6-dc1d9ea54a57_SESS_d2915c3c-c86f-43cd-9b66-7a8e7598be93_TOSC_ca914dd6-399a-4673-a49a-ac7b2e8396d7_PLY_','2022-02-01 11:47:44','2019-09-02 11:46:47','1240b62e-cd69-11e9-947d-226cec7cb58a.ply','2022-02-01 12:47:44','SYNCED','1240b62e-cd69-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 138.1.1.1\",\"modelMatrix\":\"0.70981,-0.626528,0.32192,0,0.704394,0.631346,-0.324395,0,2.07846e-8,0.457018,0.889458,0,4.46835,-37.3103,-20.8687,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'124206a4-cd69-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/124206a4-cd69-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_df2eeadd-f92f-4837-9d06-8003b62898b8_ACT_41c458ba-26b5-45af-82c6-dc1d9ea54a57_SESS_d2915c3c-c86f-43cd-9b66-7a8e7598be93_BOSC_8530b1bc-a249-4054-91fd-029aa5430d83_SNAPS_','2022-02-01 11:47:44','2019-09-02 11:54:24','124206a4-cd69-11e9-947d-226cec7cb58a.png','2022-02-01 12:47:44','SYNCED','124206a4-cd69-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 138.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'12434285-cd69-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/12434285-cd69-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_df2eeadd-f92f-4837-9d06-8003b62898b8_ACT_41c458ba-26b5-45af-82c6-dc1d9ea54a57_SESS_d2915c3c-c86f-43cd-9b66-7a8e7598be93_BOSC_8530b1bc-a249-4054-91fd-029aa5430d83_PLY_','2022-02-01 11:47:45','2019-09-02 11:54:24','12434285-cd69-11e9-947d-226cec7cb58a.ply','2022-02-01 12:47:45','SYNCED','12434285-cd69-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 138.1.1.1\",\"modelMatrix\":\"-0.811082,-0.570713,0.128188,0,0.584932,-0.791366,0.177749,0,-3.85183e-9,0.219151,0.975691,0,-31.2004,-3.27729,-22.1787,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'12443fb0-cd69-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/12443fb0-cd69-11e9-947d-226cec7cb58a.stl','STL','PATIENT_df2eeadd-f92f-4837-9d06-8003b62898b8_ACT_41c458ba-26b5-45af-82c6-dc1d9ea54a57_SESS_d2915c3c-c86f-43cd-9b66-7a8e7598be93_TOSC_ca914dd6-399a-4673-a49a-ac7b2e8396d7_STL_','2022-02-01 11:47:45','2019-09-02 11:46:47','12443fb0-cd69-11e9-947d-226cec7cb58a.stl','2022-02-01 12:47:45','SYNCED','12443fb0-cd69-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 138.1.1.1\",\"modelMatrix\":\"0.70981,-0.626528,0.32192,0,0.704394,0.631346,-0.324395,0,2.07846e-8,0.457018,0.889458,0,4.46835,-37.3103,-20.8687,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'124586f3-f964-4084-80cd-b9c63378fd7b','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/124586f3-f964-4084-80cd-b9c63378fd7b.ply','PLY','PATIENT_a730394c-024c-4469-9597-1dc64fff623b_ACT_5e6241cd-e16c-4454-8465-f82b0ebdfe75_SESS_989a5231-a11e-4601-a8bd-e423054384eb_BOSC_39f27bc4-9f14-491b-b262-aac225ef7c62_PLY_','2020-12-16 11:08:55','2020-01-31 13:56:13','124586f3-f964-4084-80cd-b9c63378fd7b.ply','2020-12-16 12:08:55','SYNCED','124586f3-f964-4084-80cd-b9c63378fd7b',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 25.1.1.5.1.1\",\"modelMatrix\":\"-0.9694,0.229963,-0.0859114,0,-0.245487,-0.908099,0.339254,0,-2.69273e-9,0.349963,0.936764,0,-10.095,17.3673,-17.2107,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'1245ac17-cd69-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1245ac17-cd69-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_df2eeadd-f92f-4837-9d06-8003b62898b8_ACT_41c458ba-26b5-45af-82c6-dc1d9ea54a57_SESS_d2915c3c-c86f-43cd-9b66-7a8e7598be93_TOSC_ca914dd6-399a-4673-a49a-ac7b2e8396d7_SNAPS_','2022-02-01 11:47:45','2019-09-02 11:46:47','1245ac17-cd69-11e9-947d-226cec7cb58a.png','2022-02-01 12:47:45','SYNCED','1245ac17-cd69-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 138.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'12471335-cd69-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/12471335-cd69-11e9-947d-226cec7cb58a.stl','STL','PATIENT_df2eeadd-f92f-4837-9d06-8003b62898b8_ACT_41c458ba-26b5-45af-82c6-dc1d9ea54a57_SESS_d2915c3c-c86f-43cd-9b66-7a8e7598be93_BOSC_8530b1bc-a249-4054-91fd-029aa5430d83_STL_','2022-02-01 11:47:45','2019-09-02 11:54:24','12471335-cd69-11e9-947d-226cec7cb58a.stl','2022-02-01 12:47:45','SYNCED','12471335-cd69-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 138.1.1.1\",\"modelMatrix\":\"-0.811082,-0.570713,0.128188,0,0.584932,-0.791366,0.177749,0,-3.85183e-9,0.219151,0.975691,0,-31.2004,-3.27729,-22.1787,1\",\"title\":\"MANDIBULE STL\"}'),(2,'1280c0d0-3be2-4275-bcdb-9f6092c1eaf4','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1280c0d0-3be2-4275-bcdb-9f6092c1eaf4.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_cb674a1b-2e6a-49e6-9171-287c4ba97efc_SESS_be64cbe1-2278-4676-af32-701bf582a748_BOSC_9df7dc8b-8482-467f-a6be-0c5441565087_SNAPS_','2020-12-16 10:53:10','2020-02-25 14:22:15','1280c0d0-3be2-4275-bcdb-9f6092c1eaf4.png','2020-12-16 11:53:10','SYNCED','1280c0d0-3be2-4275-bcdb-9f6092c1eaf4',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'1295bf20-8650-4af6-abe0-19b61fad8a61','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1295bf20-8650-4af6-abe0-19b61fad8a61.png','SNAPS','PATIENT_1dc3cc8c-4494-44b4-aa1f-d9de15a13484_ACT_4988c2b0-951d-4074-9c77-d6890a307dec_SESS_9fe66e73-19c3-46db-9286-3c347d08985c_TOSC_853c3192-707a-49f5-ba41-579283ad8295_SNAPS_','2022-02-01 11:47:45','2019-09-20 10:25:18','1295bf20-8650-4af6-abe0-19b61fad8a61.png','2022-02-01 12:47:45','SYNCED','1295bf20-8650-4af6-abe0-19b61fad8a61',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 158.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'129dfa16-2c2f-44ec-912d-ba4f5e6425c9','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/129dfa16-2c2f-44ec-912d-ba4f5e6425c9.ply','PLY','PATIENT_70e312f8-9281-4312-b389-002f93086044_ACT_40bb45c1-9628-4cc2-acc2-463a6f7cdea5_SESS_506d761d-3038-4e19-a73d-7bf25de75537_TOSC_736f8743-abc7-4cec-b4b8-be2444f15147_PLY_','2022-02-01 11:47:46','2019-07-30 14:17:20','129dfa16-2c2f-44ec-912d-ba4f5e6425c9.ply','2022-02-01 12:47:46','SYNCED','129dfa16-2c2f-44ec-912d-ba4f5e6425c9',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 119.1.1.1\",\"modelMatrix\":\"-0.127631,-0.963929,0.233561,0,0.991822,-0.124042,0.0300554,0,3.59809e-10,0.235486,0.971878,0,-26.0161,-24.2632,-21.7972,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'12b77920-9b82-42ac-8594-2bdbc3951b52','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/12b77920-9b82-42ac-8594-2bdbc3951b52.png','SNAPS','PATIENT_d2ff948f-69d4-46e9-9ef1-704c8bba4325_ACT_2c576716-4606-4205-9348-747d0fefdc69_SESS_55134a44-2c28-45a8-a968-309f20beea5f_BOSC_6213c25f-b2c9-4dd9-a965-e89a30fc3f2c_SNAPS_','2021-08-19 22:31:31','2019-12-02 17:00:59','12b77920-9b82-42ac-8594-2bdbc3951b52.png','2021-08-20 00:31:31','SYNCED','12b77920-9b82-42ac-8594-2bdbc3951b52',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 221.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'12dc7633-bdb0-4b94-bee3-3d762891bfd2','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/12dc7633-bdb0-4b94-bee3-3d762891bfd2.ply','PLY','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_TOSC_3fc5d493-b11e-4998-bcb7-288a149cec75_PLY_','2021-12-30 18:03:39','2019-11-14 13:38:43','12dc7633-bdb0-4b94-bee3-3d762891bfd2.ply','2021-12-30 19:03:39','SYNCED','12dc7633-bdb0-4b94-bee3-3d762891bfd2',0,NULL,'','','{\"displayTitle\":\"Mascella 0\",\"modelMatrix\":\"0.222058,-0.9407,0.256463,0,0.975034,0.214239,-0.058408,0,-2.53832e-9,0.26303,0.964788,0,-20.6273,-30.0685,-14.215,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'12e52414-5b00-40c8-864c-772b7b0d7926','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/12e52414-5b00-40c8-864c-772b7b0d7926.ply','PLY','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_TOSC_a1f4078d-a25a-4663-8fd2-9fa32d012000_PLY_','2021-12-30 18:03:39','2019-11-15 11:00:22','12e52414-5b00-40c8-864c-772b7b0d7926.ply','2021-12-30 19:03:39','SYNCED','12e52414-5b00-40c8-864c-772b7b0d7926',0,NULL,'','','{\"displayTitle\":\"Mascella 0\",\"modelMatrix\":\"0.604375,-0.725102,0.330088,0,0.7967,0.550061,-0.250404,0,-3.68487e-11,0.414319,0.910132,0,-0.671123,-34.3745,-16.6885,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'12f23d77-b86a-44b3-97ab-ca4de0a65a24','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/12f23d77-b86a-44b3-97ab-ca4de0a65a24.png','SNAPS','PATIENT_961e5084-1756-4d47-8e90-a6b717094efe_ACT_3ac76d22-ce4c-4cc0-b913-70810960e40b_SESS_993b2fa9-602e-4fd2-a180-6149b3dbf2ef_TOSC_f6dc75cc-2014-4c26-9dc4-ea43ef02ca06_SNAPS_','2020-12-16 11:08:56','2020-01-24 10:51:09','12f23d77-b86a-44b3-97ab-ca4de0a65a24.png','2020-12-16 12:08:56','SYNCED','12f23d77-b86a-44b3-97ab-ca4de0a65a24',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 199.1.7.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'12ffeb32-ef4a-48a4-8207-1a0f7a1a2bd9','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/12ffeb32-ef4a-48a4-8207-1a0f7a1a2bd9.stl','STL','PATIENT_079ffac1-3b07-44e9-a6d8-c8c99dddfd30_ACT_50c1349d-a4cb-4edd-8ba6-178f8bb48c27_SESS_ea4078da-c040-409c-8d7d-e7483d2404e3_TOSC_51362368-129f-4221-8773-54a32f3fad13_STL_','2021-12-30 18:03:39','2019-10-15 12:34:31','12ffeb32-ef4a-48a4-8207-1a0f7a1a2bd9.stl','2021-12-30 19:03:39','SYNCED','12ffeb32-ef4a-48a4-8207-1a0f7a1a2bd9',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 58.1.1.1\",\"modelMatrix\":\"0.299796,-0.918185,0.258958,0,0.954003,0.28854,-0.0813775,0,-3.87226e-9,0.271443,0.962454,0,-11.4896,-32.7289,-21.0753,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'1323cd63-0a1d-49cb-9aec-d0c28cd5ea6b','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1323cd63-0a1d-49cb-9aec-d0c28cd5ea6b.png','SNAPS','PATIENT_bfff99cf-e91f-4eed-bb3a-06bece8eaf9f_ACT_ee7a5012-1ec5-43b8-82bd-f42cb859f757_SESS_0b92af6d-d56a-4d56-941a-44824081e629_BOSC_c79667fc-b0eb-4cb5-9dc7-4e194ed338e3_SNAPS_','2020-12-23 09:08:47','2019-12-18 14:10:49','1323cd63-0a1d-49cb-9aec-d0c28cd5ea6b.png','2020-12-23 10:08:47','SYNCED','1323cd63-0a1d-49cb-9aec-d0c28cd5ea6b',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 20.1.268.1.1.3\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'132ba7d0-4ff5-454c-947a-4ad978ccfd1e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/132ba7d0-4ff5-454c-947a-4ad978ccfd1e.png','SNAPS','PATIENT_7fc0b770-1c44-43d1-a92c-6a506694c8b0_ACT_d902922d-2ce1-4865-9eca-52b7a83a9e70_SESS_4b1d888f-52ff-4bdb-b9e3-e793cb526652_BOSC_061611fd-875f-47bb-b74b-854df83ce355_SNAPS_','2022-02-01 11:47:46','2019-07-31 16:02:55','132ba7d0-4ff5-454c-947a-4ad978ccfd1e.png','2022-02-01 12:47:46','SYNCED','132ba7d0-4ff5-454c-947a-4ad978ccfd1e',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 121.2.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'133d1ff8-279c-41ce-a726-97e0145f4347','','SNAPS','PATIENT_cb792ec3-1780-40fa-b01b-45b72329970a_ACT_bf1e82a2-d47f-4e1e-8585-5081cd72732d_SESS_af593c0e-7054-4435-96a3-d0215b9a1fc1_TOSC_c4d7ab4d-89b0-4b61-ab3f-86bfbcfb5523_SNAPS_','2022-02-01 11:47:46','2019-08-19 14:00:17','','2022-02-01 12:47:46','SYNCED','133d1ff8-279c-41ce-a726-97e0145f4347',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 130.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'133d76a2-a5eb-41e1-84c6-593b5afaa6f4','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/133d76a2-a5eb-41e1-84c6-593b5afaa6f4.ply','PLY','PATIENT_961e5084-1756-4d47-8e90-a6b717094efe_ACT_98c4e8c8-b585-402f-9f25-607a96fd2f4d_SESS_5abb4cc4-ea51-4889-b538-9aee199a52f8_BOSC_432adc29-fec8-4fd8-8822-84ddae18c411_PLY_','2020-12-16 11:08:57','2020-01-23 16:38:00','133d76a2-a5eb-41e1-84c6-593b5afaa6f4.ply','2020-12-16 12:08:57','SYNCED','133d76a2-a5eb-41e1-84c6-593b5afaa6f4',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 199.1.5.1.1\",\"modelMatrix\":\"-0.972172,0.222079,-0.0745819,0,-0.234268,-0.921589,0.309502,0,-3.12522e-9,0.318361,0.947969,0,-14.8876,18.6848,-18.3014,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'134d8e67-a1b6-4007-9572-5c34b0ef6066','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/134d8e67-a1b6-4007-9572-5c34b0ef6066.stl','STL','PATIENT_b91b12ac-6144-42d7-97e8-da7ac9eebdc2_ACT_7563c172-7fae-490c-aef8-357e72d49088_SESS_28794cdb-fd2d-42c7-bbc0-00011c3add7a_TOSC_e23148ec-ff39-4dcb-8b2f-521224700535_STL_','2022-03-04 13:40:26','2019-07-10 12:07:29','134d8e67-a1b6-4007-9572-5c34b0ef6066.stl','2022-03-04 14:40:26','SYNCED','134d8e67-a1b6-4007-9572-5c34b0ef6066',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 27.1.1.1\",\"modelMatrix\":\"0.523387,-0.823893,0.217407,0,0.852095,0.506065,-0.133539,0,2.58748e-9,0.255144,0.966903,0,-3.25456,-37.7039,-21.0094,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'134eb347-0586-416b-96b6-d9bd9cbd8e3d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/134eb347-0586-416b-96b6-d9bd9cbd8e3d.png','SNAPS','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_db56cba1-23ff-48bf-b86e-4ceff749087f_TOSC_95ba1b04-bad8-4550-9b06-d48a2e72b1f6_SNAPS_','2021-12-30 18:03:41','2019-11-14 14:39:44','134eb347-0586-416b-96b6-d9bd9cbd8e3d.png','2021-12-30 19:03:41','SYNCED','134eb347-0586-416b-96b6-d9bd9cbd8e3d',0,NULL,'','','{\"displayTitle\":\"Mascella 0\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'13628fbe-242c-4f05-8c36-22f79e6dd01d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/13628fbe-242c-4f05-8c36-22f79e6dd01d.png','SNAPS','PATIENT_ee852659-205f-42dc-8107-64d08e2abe7f_ACT_3197fd12-14d2-4815-950d-3556c3d3aead_SESS_39b39ead-48ef-4c63-bcea-6083e524cabd_TOSC_af6dd5a1-13ab-4313-ba74-21c75bfaaa35_SNAPS_','2021-12-30 18:03:41','2019-11-20 14:25:24','13628fbe-242c-4f05-8c36-22f79e6dd01d.png','2021-12-30 19:03:41','SYNCED','13628fbe-242c-4f05-8c36-22f79e6dd01d',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 207.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'13665f21-14b2-49d9-8601-58dcf7d52ce8','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/13665f21-14b2-49d9-8601-58dcf7d52ce8.png','SNAPS','PATIENT_2aa6e500-959c-4ad7-b322-62edde25b391_ACT_b7bc042d-95d4-45b7-a66e-ac5645f21987_SESS_0a59fcbd-fe82-4c25-9569-c973303fa798_TOSC_3ee06446-29d1-41ad-8f5b-2df57494deda_SNAPS_','2022-03-04 13:40:26','2019-07-09 17:20:20','13665f21-14b2-49d9-8601-58dcf7d52ce8.png','2022-03-04 14:40:26','SYNCED','13665f21-14b2-49d9-8601-58dcf7d52ce8',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 14.2.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'1366fe91-c08d-4263-8891-e7d6276b9db8','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1366fe91-c08d-4263-8891-e7d6276b9db8.png','SNAPS','PATIENT_878a5537-ff9c-4571-a968-f11b3b1e2055_ACT_6c0855be-3e79-42b9-84ff-3f2afe3afb78_SESS_eb76868f-5b66-47aa-8517-3a782fe0b86f_TOSC_831781f0-6163-480b-b2b6-96d27375644f_SNAPS_','2022-02-01 11:47:47','2019-07-19 11:54:02','1366fe91-c08d-4263-8891-e7d6276b9db8.png','2022-02-01 12:47:47','SYNCED','1366fe91-c08d-4263-8891-e7d6276b9db8',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 99.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'136ce4f0-829b-44a6-b452-d8a2df53fdd6','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/136ce4f0-829b-44a6-b452-d8a2df53fdd6.stl','STL','PATIENT_b78e7906-cc0d-4210-b157-797fe415e92b_ACT_26567a40-f2f0-4120-af8b-ea661c78a274_SESS_ad0c8493-7965-4b9b-abab-b58d1eceab40_BOSC_672b1ceb-5c31-4541-a49f-c70f5c11f0a6_STL_','2022-02-01 11:47:47','2019-07-17 14:07:02','136ce4f0-829b-44a6-b452-d8a2df53fdd6.stl','2022-02-01 12:47:47','SYNCED','136ce4f0-829b-44a6-b452-d8a2df53fdd6',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 89.1.1.1\",\"modelMatrix\":\"-0.955263,-0.284214,0.0818244,0,0.295758,-0.917977,0.264283,0,7.13936e-10,0.27666,0.960968,0,-27.2358,8.0752,-20.2935,1\",\"title\":\"MANDIBULE STL\"}'),(2,'1373f169-5218-43fe-b04a-097fd9afc128','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1373f169-5218-43fe-b04a-097fd9afc128.ply','PLY','PATIENT_49a084e5-164b-4cc8-882c-863d3b56289f_ACT_81763d87-b7a1-49c4-84d5-66fb0a646f2b_SESS_7a2fb731-12b4-46ce-b8fb-342d683b46d0_TOSC_bd93feca-129a-4d05-8364-774b78d1857e_PLY_','2020-12-23 09:08:50','2019-12-31 15:48:26','1373f169-5218-43fe-b04a-097fd9afc128.ply','2020-12-23 10:08:50','SYNCED','1373f169-5218-43fe-b04a-097fd9afc128',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"modelMatrix\":\"0.513981,-0.771292,0.375409,0,0.857802,0.462146,-0.224939,0,-8.08963e-9,0.43764,0.89915,0,-0.921068,-28.1165,-23.2354,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'137477f1-769f-4874-b826-1de33ee6ab0d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/137477f1-769f-4874-b826-1de33ee6ab0d.ply','PLY','PATIENT_37332762-361d-4c33-8978-e4263ffd76a2_ACT_0404ec73-f975-40b9-be2e-096a8cea445d_SESS_77705ab4-a161-4dcf-ad09-bf2ef931d7fb_TOSC_daf6f746-f0c7-49fa-966f-dc56f4c69a10_PLY_','2020-12-16 11:08:59','2020-01-20 10:56:56','137477f1-769f-4874-b826-1de33ee6ab0d.ply','2020-12-16 12:08:59','SYNCED','137477f1-769f-4874-b826-1de33ee6ab0d',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.1.1.1.1\",\"modelMatrix\":\"0.803773,-0.511247,0.304262,0,0.594936,0.690707,-0.411065,0,2.03986e-8,0.51142,0.859331,0,6.20963,-30.1525,-17.3464,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1399752c-08c8-46a4-af30-6427d485a9c3','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1399752c-08c8-46a4-af30-6427d485a9c3.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_2f24eb52-e901-408f-93dc-f1eb6282e395_SESS_026492db-4b27-4e60-b1d3-861d8999edd3_BOSC_75a0f68e-c979-4bb5-ab5a-79feb04b4888_SNAPS_','2020-12-08 17:28:22','2020-06-17 15:43:44','1399752c-08c8-46a4-af30-6427d485a9c3.png','2020-12-08 18:28:22','SYNCED','1399752c-08c8-46a4-af30-6427d485a9c3',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.56.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'139adc73-2d62-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/139adc73-2d62-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_1b807244-2d56-4038-9d74-a9dd992da0de_ACT_1a3c84ff-42d5-4683-971e-11da788f70d9_SESS_79141edc-4a2d-406e-a9f3-15976a872569_TOSC_f54ae426-9821-4380-b68a-6c72cde91e51_SNAPS_','2020-12-23 09:08:50','2020-01-02 14:12:44','139adc73-2d62-11ea-947d-226cec7cb58a.png','2020-12-23 10:08:50','SYNCED','139adc73-2d62-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'139cd244-2d62-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/139cd244-2d62-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_1a3c84ff-42d5-4683-971e-11da788f70d9_SESS_79141edc-4a2d-406e-a9f3-15976a872569_BOSC_bfb23b25-031e-4587-9209-d240233e8e4e_SNAPS_','2020-12-23 09:08:51','2020-01-02 14:15:56','139cd244-2d62-11ea-947d-226cec7cb58a.png','2020-12-23 10:08:51','SYNCED','139cd244-2d62-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'139e98a6-2d62-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/139e98a6-2d62-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_1b807244-2d56-4038-9d74-a9dd992da0de_ACT_1a3c84ff-42d5-4683-971e-11da788f70d9_SESS_79141edc-4a2d-406e-a9f3-15976a872569_TOSC_f54ae426-9821-4380-b68a-6c72cde91e51_PLY_','2020-12-23 09:08:51','2020-01-02 14:12:44','139e98a6-2d62-11ea-947d-226cec7cb58a.ply','2020-12-23 10:08:51','SYNCED','139e98a6-2d62-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"modelMatrix\":\"0.600319,-0.758701,0.252961,0,0.799761,0.569499,-0.189879,0,-8.61689e-9,0.316296,0.948661,0,-2.53806,-29.3616,-16.1256,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'13a054ab-2d62-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/13a054ab-2d62-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_1a3c84ff-42d5-4683-971e-11da788f70d9_SESS_79141edc-4a2d-406e-a9f3-15976a872569_BOSC_bfb23b25-031e-4587-9209-d240233e8e4e_PLY_','2020-12-23 09:08:51','2020-01-02 14:15:56','13a054ab-2d62-11ea-947d-226cec7cb58a.ply','2020-12-23 10:08:51','SYNCED','13a054ab-2d62-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"modelMatrix\":\"-0.978033,0.205035,-0.037581,0,-0.20845,-0.962007,0.176327,0,2.07537e-9,0.180288,0.983614,0,-8.044,17.2922,-18.2784,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'13a70516-4820-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/13a70516-4820-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_58df9e6d-17e2-4aad-a4d6-fbfc117b8b69_ACT_259c275d-dc7b-4580-8e6d-196f4a65e7f0_SESS_fa9a16cf-2753-4269-9f14-7c132449c07b_TOSC_1f4de892-5ac7-4bb4-8ff2-549ca5b4f789_PLY_','2020-12-16 10:53:15','2020-02-05 14:55:43','13a70516-4820-11ea-947d-226cec7cb58a.ply','2020-12-16 11:53:15','SYNCED','13a70516-4820-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"modelMatrix\":\"0.741298,-0.646059,0.181892,0,0.671176,0.713557,-0.200896,0,8.137e-9,0.271005,0.962578,0,-1.38,-25.401,-20.3662,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'13a90c9d-4820-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/13a90c9d-4820-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_259c275d-dc7b-4580-8e6d-196f4a65e7f0_SESS_fa9a16cf-2753-4269-9f14-7c132449c07b_BOSC_327dfb17-fec0-4984-b35d-31da478e9eae_SNAPS_','2020-12-16 10:53:16','2020-02-05 15:01:34','13a90c9d-4820-11ea-947d-226cec7cb58a.png','2020-12-16 11:53:16','SYNCED','13a90c9d-4820-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'13aafb1f-4820-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/13aafb1f-4820-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_58df9e6d-17e2-4aad-a4d6-fbfc117b8b69_ACT_259c275d-dc7b-4580-8e6d-196f4a65e7f0_SESS_fa9a16cf-2753-4269-9f14-7c132449c07b_TOSC_1f4de892-5ac7-4bb4-8ff2-549ca5b4f789_SNAPS_','2020-12-16 10:53:16','2020-02-05 14:55:43','13aafb1f-4820-11ea-947d-226cec7cb58a.png','2020-12-16 11:53:16','SYNCED','13aafb1f-4820-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'13ad944f-4820-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/13ad944f-4820-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_259c275d-dc7b-4580-8e6d-196f4a65e7f0_SESS_fa9a16cf-2753-4269-9f14-7c132449c07b_BOSC_327dfb17-fec0-4984-b35d-31da478e9eae_PLY_','2020-12-16 10:53:16','2020-02-05 15:01:34','13ad944f-4820-11ea-947d-226cec7cb58a.ply','2020-12-16 11:53:16','SYNCED','13ad944f-4820-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"modelMatrix\":\"0.852859,0.521666,-0.0222659,0,-0.522141,0.852083,-0.0363689,0,2.13967e-9,0.0426435,0.99909,0,20.6919,-6.95982,-21.999,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'13aed907-dd07-4fdc-bd89-a2ea19e3f4f0','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/13aed907-dd07-4fdc-bd89-a2ea19e3f4f0.png','SNAPS','PATIENT_8c8c6555-73d1-4206-b336-747c074c14ee_ACT_ca44eb01-1265-4c6f-80f3-b53c68db40c9_SESS_6beb74a4-7ab6-47ed-807f-6e347177ffb0_TOSC_5d1c2dac-afee-4586-b1eb-8fb3e2f1c9b2_SNAPS_','2021-12-30 18:03:42','2019-10-17 13:47:46','13aed907-dd07-4fdc-bd89-a2ea19e3f4f0.png','2021-12-30 19:03:42','SYNCED','13aed907-dd07-4fdc-bd89-a2ea19e3f4f0',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 191.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'13c0ab3b-8879-4497-be7a-fc91471fb910','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/13c0ab3b-8879-4497-be7a-fc91471fb910.ply','PLY','PATIENT_60c51933-26a9-4f4a-83e7-2357f09a083a_ACT_b36010b8-72bf-4254-8155-52613f8ac41e_SESS_3a951625-b6f7-490e-8bc9-1338cfa93e33_BOSC_3f940d17-bff9-4a82-add4-47c55280c5ed_PLY_','2022-02-01 11:47:47','2019-07-22 11:31:53','13c0ab3b-8879-4497-be7a-fc91471fb910.ply','2022-02-01 12:47:47','SYNCED','13c0ab3b-8879-4497-be7a-fc91471fb910',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 104.1.1.1\",\"modelMatrix\":\"-0.991612,-0.128367,0.0150872,0,0.129251,-0.984833,0.115749,0,-2.16271e-13,0.116728,0.993164,0,-18.2661,15.9648,-34.6119,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'13c1b8f7-4fcf-4748-a03d-38cc53102619','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/13c1b8f7-4fcf-4748-a03d-38cc53102619.png','SNAPS','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_6fa69972-69f3-4c7f-8791-75cc95c31a0d_SESS_28878620-862a-4728-b222-123cb5890c82_BOSC_02834a82-f3a3-46e6-ad4a-6419af841511_SNAPS_','2020-12-23 09:08:52','2019-12-20 14:48:54','13c1b8f7-4fcf-4748-a03d-38cc53102619.png','2020-12-23 10:08:52','SYNCED','13c1b8f7-4fcf-4748-a03d-38cc53102619',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'13d4c476-e4e8-47a2-b638-e3fdb56d8f22','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/13d4c476-e4e8-47a2-b638-e3fdb56d8f22.ply','PLY','PATIENT_997d35af-5f6a-46ef-a66b-5d8026f342a3_ACT_1193a07b-ce66-43c2-9e53-6e9a66271626_SESS_b36843e2-3c38-4e8a-ad7a-e65d5bbfb29c_TOSC_5fb06f05-bf44-424b-902f-6c77fb27375c_PLY_','2020-12-23 09:08:53','2020-01-02 16:19:47','13d4c476-e4e8-47a2-b638-e3fdb56d8f22.ply','2020-12-23 10:08:53','SYNCED','13d4c476-e4e8-47a2-b638-e3fdb56d8f22',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"modelMatrix\":\"-0.111199,-0.970901,0.212101,0,0.993798,-0.108636,0.0237325,0,3.2582e-10,0.213425,0.976959,0,-16.4216,-5.76639,-26.0154,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'13d4cd20-f296-43ae-a4d6-e12c986802be','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/13d4cd20-f296-43ae-a4d6-e12c986802be.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_a78941e1-e63b-4f03-84db-3c4fcdb64d89_SESS_caf59252-3532-421e-9b72-5abe78045a36_BOSC_8dab0ada-8b66-421f-a822-76bf8bad5ce6_PLY_','2020-12-16 10:53:17','2020-02-20 15:04:39','13d4cd20-f296-43ae-a4d6-e12c986802be.ply','2020-12-16 11:53:17','SYNCED','13d4cd20-f296-43ae-a4d6-e12c986802be',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"modelMatrix\":\"-0.941069,0.332787,-0.0603439,0,-0.338214,-0.925969,0.167905,0,5.08476e-9,0.178419,0.983955,0,-6.98178,19.525,-17.2077,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'13df9b0c-63c5-4853-b102-bcbbeea5fc1d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/13df9b0c-63c5-4853-b102-bcbbeea5fc1d.png','SNAPS','PATIENT_72f539f4-2d06-47fa-b0b8-1291879a4818_ACT_d55baca2-6f09-4446-a148-dcdcfcaf57d8_SESS_5efdc987-8bdd-454f-b282-82efcf807bae_TOSC_021e414e-a672-4bab-9b7a-58801541da2e_SNAPS_','2021-08-19 22:36:07','2019-11-26 15:42:19','13df9b0c-63c5-4853-b102-bcbbeea5fc1d.png','2021-08-20 00:36:07','SYNCED','13df9b0c-63c5-4853-b102-bcbbeea5fc1d',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 86.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'13f091fc-a614-4e63-9b7c-d8733271934a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/13f091fc-a614-4e63-9b7c-d8733271934a.ply','PLY','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_aaaeb032-2111-434f-b0d7-0923a56dbb56_SESS_1f381489-037a-46af-8034-d00e0aa3d9ea_BOSC_93de4689-e7db-470d-861c-f78b8e003860_PLY_','2021-06-07 11:39:09','2020-01-20 13:43:57','13f091fc-a614-4e63-9b7c-d8733271934a.ply','2021-06-07 13:39:09','SYNCED','13f091fc-a614-4e63-9b7c-d8733271934a',0,'2021-06-07 13:39:09','','','{\"displayTitle\":\"MANDIBULE 283.1.1.1.1\",\"modelMatrix\":\"-0.977803,0.199962,-0.062585,0,-0.209527,-0.933164,0.292066,0,-2.90555e-10,0.298696,0.954348,0,-11.7939,16.0943,-22.6236,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'14195b5f-2d61-434d-9278-4412aa2f866a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/14195b5f-2d61-434d-9278-4412aa2f866a.ply','PLY','PATIENT_9a8e2ba6-f448-4f2d-bd91-8275f3fb08ac_ACT_f4fade88-9b6b-4d3c-b86d-70413fa3f1c8_SESS_6df99adb-0102-41e4-8799-371d34609080_TOSC_793838ae-2932-4555-963f-880a1b2b8cd3_PLY_','2020-12-08 17:28:28','2020-06-08 10:38:59','14195b5f-2d61-434d-9278-4412aa2f866a.ply','2020-12-08 18:28:28','SYNCED','14195b5f-2d61-434d-9278-4412aa2f866a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.31.1.1\",\"modelMatrix\":\"0.698723,-0.675695,0.234997,0,0.715393,0.65995,-0.229521,0,2.90584e-9,0.328486,0.944509,0,2.14568,-31.6571,-17.1923,1\",\"title\":\"Maxillaire PLY\"}'),(2,'1444554a-6707-4389-ad0a-cf29de80dec1','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1444554a-6707-4389-ad0a-cf29de80dec1.png','SNAPS','PATIENT_fcf8c111-84a1-4f17-859c-ea2ad21d373b_ACT_d27c23bb-fa1e-4cd8-bacc-e2b65114a20e_SESS_844480c5-a8a8-4eb3-a014-e1424d66a1ca_BOSC_8f3d315e-5c4a-4f20-b843-cc6ea3308289_SNAPS_','2021-12-30 18:03:42','2019-11-18 16:48:17','1444554a-6707-4389-ad0a-cf29de80dec1.png','2021-12-30 19:03:42','SYNCED','1444554a-6707-4389-ad0a-cf29de80dec1',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 168.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'1447c73f-6b76-4b44-a969-fa5eeb7787f3','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1447c73f-6b76-4b44-a969-fa5eeb7787f3.ply','PLY','PATIENT_c47df9a6-a592-4be6-a99c-ee5e02e02037_ACT_b8dedaaf-b96b-4157-b498-2b2a27c187e7_SESS_1e1d12e1-8057-481e-9a85-2713babfed55_BOSC_d223c491-eaa5-4969-90e4-6f057c15c1c0_PLY_','2022-02-01 11:47:47','2019-09-18 10:34:19','1447c73f-6b76-4b44-a969-fa5eeb7787f3.ply','2022-02-01 12:47:47','SYNCED','1447c73f-6b76-4b44-a969-fa5eeb7787f3',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 151.1.1.1\",\"modelMatrix\":\"0.0306244,-0.997711,0.0602852,0,0.999531,0.0305686,-0.00184707,0,-6.66109e-11,0.0603135,0.998179,0,-21.2096,-25.2477,-23.6118,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'1462a00c-3b77-4ba5-bfdf-444744e1774c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1462a00c-3b77-4ba5-bfdf-444744e1774c.ply','PLY','PATIENT_990204e3-cf2f-4026-952f-1dddcf7ba877_ACT_7cc92ba2-1d5b-419e-a74a-49ee200bad42_SESS_2da8fcc1-66de-4b26-b59a-065327a30f5f_TOSC_0046b2b3-f361-4424-ad70-d7e0cda10542_PLY_','2022-02-01 11:47:47','2019-07-22 14:54:34','1462a00c-3b77-4ba5-bfdf-444744e1774c.ply','2022-02-01 12:47:47','SYNCED','1462a00c-3b77-4ba5-bfdf-444744e1774c',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 56.1.1.2\",\"modelMatrix\":\"0.227396,-0.913436,0.337528,0,0.973802,0.2133,-0.0788176,0,4.64129e-9,0.346609,0.93801,0,-14.8261,-30.9597,-31.0561,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1462fe03-57a7-4821-9847-f5918b3b30da','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1462fe03-57a7-4821-9847-f5918b3b30da.png','SNAPS','PATIENT_a730394c-024c-4469-9597-1dc64fff623b_ACT_7c775d8a-c5f0-4242-92b0-3fd02fa5428f_SESS_715397ea-ceae-49f7-99c6-0010425952e2_BOSC_74fb105f-4735-474c-b50b-34c833e3b3cc_SNAPS_','2020-12-16 11:09:02','2020-01-31 12:00:40','1462fe03-57a7-4821-9847-f5918b3b30da.png','2020-12-16 12:09:02','SYNCED','1462fe03-57a7-4821-9847-f5918b3b30da',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 25.1.1.4.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'146ae79a-f3b8-46e6-9023-0b7ed5d71d15','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/146ae79a-f3b8-46e6-9023-0b7ed5d71d15.png','SNAPS','PATIENT_b3c01a18-bf96-412e-abc4-a54012ab02c7_ACT_a13375ec-ea2a-4160-a01e-df6b4aa8236c_SESS_e11a368c-c597-4a5e-a772-b85449c93d08_TOSC_497000b0-3d92-417d-b7c9-c14133cae8fc_SNAPS_','2022-02-01 11:47:48','2019-07-23 15:38:04','146ae79a-f3b8-46e6-9023-0b7ed5d71d15.png','2022-02-01 12:47:48','SYNCED','146ae79a-f3b8-46e6-9023-0b7ed5d71d15',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 56.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'147a5601-eb49-4d25-946a-dbc06ca4de4a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a18a6dc8-e71f-45cb-a7ad-b53500079bd4/147a5601-eb49-4d25-946a-dbc06ca4de4a.pdf','PDF','PATIENT_cadfb79e-7de5-4015-97e3-269a77999943_ACT_087c4066-ec0b-4035-93aa-10a106e71f3b_PROST_53039ff9-51d6-49db-9cca-3763f5ad3687_PDF_','2020-12-10 12:00:39','2019-09-09 16:10:00','147a5601-eb49-4d25-946a-dbc06ca4de4a.pdf','2020-12-10 13:00:39','SYNCED','147a5601-eb49-4d25-946a-dbc06ca4de4a',0,NULL,'','','{\"displayTitle\":\"INLAY ONLAY 1.2.1 INLAY ONLAY\",\"title\":\"Inlay/Onlay PDF\"}'),(2,'147a9292-1db0-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/147a9292-1db0-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_b300e71e-93ef-48e1-8eb9-e4f1c516a9d5_ACT_47fe2ba9-f5ad-42b7-b29b-475d98d6c3d9_SESS_0ebe1667-9b32-41d1-b4c9-a74f9fad08a2_TOSC_b0443fa1-e270-464d-8cfb-000049160b31_SNAPS_','2021-02-16 16:38:02','2019-12-13 14:48:23','147a9292-1db0-11ea-947d-226cec7cb58a.png','2021-02-16 17:38:02','SYNCED','147a9292-1db0-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 232.20.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'147c77a3-1db0-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/147c77a3-1db0-11ea-947d-226cec7cb58a.stl','STL','PATIENT_1fe53bd5-165d-4f83-8b14-5ccfa106502b_ACT_47fe2ba9-f5ad-42b7-b29b-475d98d6c3d9_SESS_0ebe1667-9b32-41d1-b4c9-a74f9fad08a2_BOSC_2f55f9cb-2759-4560-bf2f-9110d4d4b209_STL_','2021-02-16 16:38:03','2019-12-13 14:53:29','147c77a3-1db0-11ea-947d-226cec7cb58a.stl','2021-02-16 17:38:03','SYNCED','147c77a3-1db0-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 232.3.1.1\",\"modelMatrix\":\"-0.97559,0.212519,-0.0553192,0,-0.219601,-0.944128,0.245759,0,-2.28765e-9,0.251908,0.967751,0,-12.9983,14.8678,-25.262,1\",\"title\":\"MANDIBULE STL\"}'),(2,'147de7c7-1db0-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/147de7c7-1db0-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_1fe53bd5-165d-4f83-8b14-5ccfa106502b_ACT_47fe2ba9-f5ad-42b7-b29b-475d98d6c3d9_SESS_0ebe1667-9b32-41d1-b4c9-a74f9fad08a2_BOSC_2f55f9cb-2759-4560-bf2f-9110d4d4b209_SNAPS_','2021-02-16 16:38:03','2019-12-13 14:53:29','147de7c7-1db0-11ea-947d-226cec7cb58a.png','2021-02-16 17:38:03','SYNCED','147de7c7-1db0-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 232.3.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'147f5d89-1db0-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/147f5d89-1db0-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_1fe53bd5-165d-4f83-8b14-5ccfa106502b_ACT_47fe2ba9-f5ad-42b7-b29b-475d98d6c3d9_SESS_0ebe1667-9b32-41d1-b4c9-a74f9fad08a2_BOSC_2f55f9cb-2759-4560-bf2f-9110d4d4b209_PLY_','2021-02-16 16:38:04','2019-12-13 14:53:29','147f5d89-1db0-11ea-947d-226cec7cb58a.ply','2021-02-16 17:38:04','SYNCED','147f5d89-1db0-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 232.3.1.1\",\"modelMatrix\":\"-0.97559,0.212519,-0.0553192,0,-0.219601,-0.944128,0.245759,0,-2.28765e-9,0.251908,0.967751,0,-12.9983,14.8678,-25.262,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'14810ae3-1db0-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/14810ae3-1db0-11ea-947d-226cec7cb58a.stl','STL','PATIENT_b300e71e-93ef-48e1-8eb9-e4f1c516a9d5_ACT_47fe2ba9-f5ad-42b7-b29b-475d98d6c3d9_SESS_0ebe1667-9b32-41d1-b4c9-a74f9fad08a2_TOSC_b0443fa1-e270-464d-8cfb-000049160b31_STL_','2021-02-16 16:38:04','2019-12-13 14:48:23','14810ae3-1db0-11ea-947d-226cec7cb58a.stl','2021-02-16 17:38:04','SYNCED','14810ae3-1db0-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 232.20.1.1\",\"modelMatrix\":\"0.108447,-0.954142,0.279019,0,0.994102,0.104088,-0.0304384,0,7.31813e-10,0.280675,0.959803,0,-16.3492,-30.5822,-18.0179,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'1482c6be-1db0-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1482c6be-1db0-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_b300e71e-93ef-48e1-8eb9-e4f1c516a9d5_ACT_47fe2ba9-f5ad-42b7-b29b-475d98d6c3d9_SESS_0ebe1667-9b32-41d1-b4c9-a74f9fad08a2_TOSC_b0443fa1-e270-464d-8cfb-000049160b31_PLY_','2021-02-16 16:38:05','2019-12-13 14:48:23','1482c6be-1db0-11ea-947d-226cec7cb58a.ply','2021-02-16 17:38:05','SYNCED','1482c6be-1db0-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 232.20.1.1\",\"modelMatrix\":\"0.108447,-0.954142,0.279019,0,0.994102,0.104088,-0.0304384,0,7.31813e-10,0.280675,0.959803,0,-16.3492,-30.5822,-18.0179,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1489062d-0c19-4b9a-971c-983682530d0f','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1489062d-0c19-4b9a-971c-983682530d0f.ply','PLY','PATIENT_a730394c-024c-4469-9597-1dc64fff623b_ACT_7c775d8a-c5f0-4242-92b0-3fd02fa5428f_SESS_715397ea-ceae-49f7-99c6-0010425952e2_BOSC_74fb105f-4735-474c-b50b-34c833e3b3cc_PLY_','2020-12-16 11:09:04','2020-01-31 12:00:40','1489062d-0c19-4b9a-971c-983682530d0f.ply','2020-12-16 12:09:04','SYNCED','1489062d-0c19-4b9a-971c-983682530d0f',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 25.1.1.4.1.1\",\"modelMatrix\":\"-0.940811,0.325397,-0.0948192,0,-0.338931,-0.903245,0.263201,0,1.51664e-9,0.27976,0.96007,0,-8.74586,17.0876,-15.5974,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'148e77a2-dc3a-459b-b619-8653c6f5d7e9','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/148e77a2-dc3a-459b-b619-8653c6f5d7e9.stl','STL','PATIENT_6592423c-c895-4f90-ae97-d29a34961d34_ACT_6628cbc8-0118-491e-93d0-25211a465bc4_SESS_6e23570d-ebd1-4a63-9ffe-aa47019113cd_TOSC_457faa66-0e03-48aa-8993-67dd0d38bb88_STL_','2022-03-04 13:40:26','2019-07-09 13:14:08','148e77a2-dc3a-459b-b619-8653c6f5d7e9.stl','2022-03-04 14:40:26','SYNCED','148e77a2-dc3a-459b-b619-8653c6f5d7e9',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 11.2.1.1\",\"modelMatrix\":\"0.71082,-0.628392,0.316004,0,0.703374,0.635044,-0.319349,0,-1.6745e-10,0.449268,0.893397,0,0.709509,-41.1177,-12.6752,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'14b1c3ce-298a-4b70-96b5-3804eab903ad','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/14b1c3ce-298a-4b70-96b5-3804eab903ad.png','SNAPS','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_87cb19c3-f54a-4c63-ac5f-47eef98d329e_SESS_d040337d-b8cd-499c-a0b9-2c3d9c4a35b7_TOSC_797d271a-88c8-4866-af1b-ff8894ed3efd_SNAPS_','2021-12-30 18:03:43','2019-11-22 08:56:44','14b1c3ce-298a-4b70-96b5-3804eab903ad.png','2021-12-30 19:03:43','SYNCED','14b1c3ce-298a-4b70-96b5-3804eab903ad',0,NULL,'','','{\"displayTitle\":\"Mascella 0\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'14befb86-6af9-4831-a6a0-2b7598686511','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/14befb86-6af9-4831-a6a0-2b7598686511.png','SNAPS','PATIENT_dc75e1af-fe4f-4b70-865b-512dbaca7415_ACT_c251045a-a425-4792-bd94-aa56eccd090f_SESS_d03ab951-0779-4a64-9b39-14d6013484f6_TOSC_e911ecbd-4d12-448a-ba5b-bc12a01dd05e_SNAPS_','2021-02-16 16:38:06','2019-12-12 11:24:35','14befb86-6af9-4831-a6a0-2b7598686511.png','2021-02-16 17:38:06','SYNCED','14befb86-6af9-4831-a6a0-2b7598686511',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 232.8.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'14c55ee0-1936-4503-9c8a-61092d01261b','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/14c55ee0-1936-4503-9c8a-61092d01261b.ply','PLY','PATIENT_877c1eee-0a64-4e47-be37-a6d5a4f5e1ac_ACT_fd694b3f-abde-4e46-91f7-7c62bfdcafa4_SESS_73a3f5b9-e905-4911-a163-2022e1de3380_TOSC_ee354b5f-a735-4898-9841-2419cf554566_PLY_','2021-08-19 22:36:24','2019-11-26 20:05:56','14c55ee0-1936-4503-9c8a-61092d01261b.ply','2021-08-20 00:36:24','SYNCED','14c55ee0-1936-4503-9c8a-61092d01261b',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.33.1.1\",\"modelMatrix\":\"0.39815,-0.879582,0.260407,0,0.91732,0.381771,-0.113026,0,1.89622e-10,0.283878,0.95886,0,-7.10097,-33.0624,-15.8789,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'14f16022-08d1-42ab-bb6c-643a85c5c810','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/14f16022-08d1-42ab-bb6c-643a85c5c810.ply','PLY','PATIENT_55452abe-c899-4508-a6ad-a6862da81096_ACT_10244838-8d43-4b45-843e-1b1867b80fe9_SESS_a27242e6-79e3-49b8-9935-388a52c32306_BOSC_b48ee4d5-a15f-4d81-85e6-e6224fc3fbd7_PLY_','2020-12-08 17:28:36','2020-06-17 10:08:11','14f16022-08d1-42ab-bb6c-643a85c5c810.ply','2020-12-08 18:28:36','SYNCED','14f16022-08d1-42ab-bb6c-643a85c5c810',0,NULL,'','','{\"displayTitle\":\"Mandibule 32.1.1.1.6\",\"modelMatrix\":\"-0.983351,0.173093,-0.0553206,0,-0.181719,-0.936676,0.299361,0,-9.35033e-10,0.30443,0.952535,0,-10.5535,20.8316,-13.923,1\",\"title\":\"Mandibule PLY\"}'),(2,'14f997df-b812-49e4-94cf-8fe7152dc8fb','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/14f997df-b812-49e4-94cf-8fe7152dc8fb.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_26a3a691-19da-4407-853d-fd0fce406b5b_SESS_193beb30-e194-499a-a284-d72bf3b7b78d_BOSC_01131184-2bce-422f-8140-0096613e71d7_SNAPS_','2020-12-16 10:53:21','2020-02-12 09:47:37','14f997df-b812-49e4-94cf-8fe7152dc8fb.png','2020-12-16 11:53:21','SYNCED','14f997df-b812-49e4-94cf-8fe7152dc8fb',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'14ff388a-6b67-4218-9a4b-2fd126f47a6c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/14ff388a-6b67-4218-9a4b-2fd126f47a6c.png','SNAPS','PATIENT_7a05621b-faf4-4349-b2d2-c3be727792f4_ACT_08d18960-730f-4f7c-9b47-931603308bdb_SESS_4a7294e9-e836-459e-b858-97f1d4d1e112_TOSC_fb0e5ccd-00fb-4a58-a87d-aa747f563e00_SNAPS_','2021-08-19 22:36:24','2019-11-27 16:54:14','14ff388a-6b67-4218-9a4b-2fd126f47a6c.png','2021-08-20 00:36:24','SYNCED','14ff388a-6b67-4218-9a4b-2fd126f47a6c',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 211.5.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'1535406a-6065-4f6a-ae2f-56233ee8a7d3','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1535406a-6065-4f6a-ae2f-56233ee8a7d3.png','SNAPS','PATIENT_a5b4e9a6-398e-46de-8713-20c96b6b984a_ACT_d5b62591-5b4d-4e35-ae77-da155fdfa0a7_SESS_3c48c829-0fd8-4841-8a2b-372c2401b25a_TOSC_bfcdff87-387e-4726-8ef6-0e88bef8773f_SNAPS_','2020-12-23 09:08:58','2020-01-02 14:23:17','1535406a-6065-4f6a-ae2f-56233ee8a7d3.png','2020-12-23 10:08:58','SYNCED','1535406a-6065-4f6a-ae2f-56233ee8a7d3',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'1536f079-b138-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1536f079-b138-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_e6cb123a-be87-4228-97b3-06d5473ed349_ACT_99e7b9d4-2a93-4741-8341-cb9c68abefa5_SESS_caf7693c-1b52-401d-830a-1bf478ab6c0c_TOSC_96e4357a-6c6d-444f-822c-5d8dcc74e000_SNAPS_','2020-12-08 17:28:40','2020-06-18 09:44:18','1536f079-b138-11ea-947d-226cec7cb58a.png','2020-12-08 18:28:40','SYNCED','1536f079-b138-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.62.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'1539723f-b138-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1539723f-b138-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_99e7b9d4-2a93-4741-8341-cb9c68abefa5_SESS_caf7693c-1b52-401d-830a-1bf478ab6c0c_BOSC_063d7831-596f-44c4-8dc9-b2c3f089496e_PLY_','2020-12-08 17:28:40','2020-06-18 09:47:46','1539723f-b138-11ea-947d-226cec7cb58a.ply','2020-12-08 18:28:40','SYNCED','1539723f-b138-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.62.1.1\",\"modelMatrix\":\"-0.960446,0.269275,-0.0709489,0,-0.278465,-0.928749,0.244708,0,2.54499e-9,0.254786,0.966998,0,-16.4155,17.4038,-16.9443,1\",\"title\":\"Mandibule PLY\"}'),(2,'153b8e71-b138-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/153b8e71-b138-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_99e7b9d4-2a93-4741-8341-cb9c68abefa5_SESS_caf7693c-1b52-401d-830a-1bf478ab6c0c_BOSC_063d7831-596f-44c4-8dc9-b2c3f089496e_SNAPS_','2020-12-08 17:28:40','2020-06-18 09:47:46','153b8e71-b138-11ea-947d-226cec7cb58a.png','2020-12-08 18:28:40','SYNCED','153b8e71-b138-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.62.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'153c542d-5a3d-412a-a335-4c6a24812e02','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/153c542d-5a3d-412a-a335-4c6a24812e02.stl','STL','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_BOSC_4130b951-2ea4-4c1e-9e71-e69c342e36b1_STL_','2022-02-01 11:47:48','2019-08-26 14:41:36','153c542d-5a3d-412a-a335-4c6a24812e02.stl','2022-02-01 12:47:48','SYNCED','153c542d-5a3d-412a-a335-4c6a24812e02',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 129.12.1.1\",\"modelMatrix\":\"-0.86495,0.497159,-0.0685085,0,-0.501857,-0.856853,0.118074,0,-5.63121e-9,0.13651,0.990639,0,-5.41015,22.1831,-19.7439,1\",\"title\":\"MANDIBULE STL\"}'),(2,'153da3f9-b138-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/153da3f9-b138-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_e6cb123a-be87-4228-97b3-06d5473ed349_ACT_99e7b9d4-2a93-4741-8341-cb9c68abefa5_SESS_caf7693c-1b52-401d-830a-1bf478ab6c0c_TOSC_96e4357a-6c6d-444f-822c-5d8dcc74e000_PLY_','2020-12-08 17:28:41','2020-06-18 09:44:18','153da3f9-b138-11ea-947d-226cec7cb58a.ply','2020-12-08 18:28:41','SYNCED','153da3f9-b138-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.62.1.1\",\"modelMatrix\":\"0.65688,-0.701163,0.27727,0,0.753995,0.610853,-0.241557,0,8.18757e-9,0.367734,0.929931,0,-3.49638,-30.6303,-15.8009,1\",\"title\":\"Maxillaire PLY\"}'),(2,'15417d41-c080-4a6b-8bc5-19e0ca8cb547','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/15417d41-c080-4a6b-8bc5-19e0ca8cb547.ply','PLY','PATIENT_c63c9dcb-2c5e-4bd8-80db-ba9cf9d5d8fe_ACT_bcb03231-8c5e-439f-8655-1a1c490c7d8d_SESS_b21ad8d7-d436-42f3-9965-c1bba3c1c272_BOSC_8b849b97-9ba4-4977-b4bd-755b4aa04bcc_PLY_','2022-02-01 11:47:48','2019-07-16 16:39:47','15417d41-c080-4a6b-8bc5-19e0ca8cb547.ply','2022-02-01 12:47:48','SYNCED','15417d41-c080-4a6b-8bc5-19e0ca8cb547',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 81.1.1.1\",\"modelMatrix\":\"-0.834439,0.54697,-0.067339,0,-0.5511,-0.828186,0.10196,0,-2.19703e-10,0.12219,0.992507,0,-3.39041,31.2028,-24.1097,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'1547ac78-241b-49ea-b1fe-f114873e71b6','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1547ac78-241b-49ea-b1fe-f114873e71b6.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_27ed9780-6a38-4d69-9839-e42c0698e136_PLY_','2020-12-16 11:09:06','2020-01-24 12:20:58','1547ac78-241b-49ea-b1fe-f114873e71b6.ply','2020-12-16 12:09:06','SYNCED','1547ac78-241b-49ea-b1fe-f114873e71b6',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.7\",\"modelMatrix\":\"0.698056,-0.652176,0.295609,0,0.716043,0.635793,-0.288183,0,-2.02374e-9,0.412837,0.910805,0,2.04657,-33.7628,-14.7611,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'155270c5-b080-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/155270c5-b080-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_fd4825c4-beed-452a-8641-25e55e983249_ACT_855e8123-60a7-46bf-bbe7-5b619e7e3c83_SESS_c128ff5c-e71a-4dbf-a87d-029519b521d9_TOSC_df9431b2-2fe3-4aea-a54f-e4072dcbfdfc_PLY_','2020-12-08 17:28:42','2020-06-17 11:47:50','155270c5-b080-11ea-947d-226cec7cb58a.ply','2020-12-08 18:28:42','SYNCED','155270c5-b080-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.51.1.1\",\"modelMatrix\":\"0.277343,-0.929712,0.242315,0,0.960771,0.268377,-0.0699484,0,-2.97217e-9,0.252209,0.967673,0,-8.23271,-33.3182,-12.0221,1\",\"title\":\"Maxillaire PLY\"}'),(2,'1557b5ce-aa5b-4ebd-8c08-14da588b15f8','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1557b5ce-aa5b-4ebd-8c08-14da588b15f8.ply','PLY','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_1a8047ce-7b95-446a-b5b9-71639b6c4b05_SESS_af562828-6543-4aac-b52c-3a40f5e106a6_BOSC_dcb397a5-f96e-4836-a97d-43368c9cd1ad_PLY_','2020-12-23 09:08:58','2020-01-06 10:20:51','1557b5ce-aa5b-4ebd-8c08-14da588b15f8.ply','2020-12-23 10:08:58','SYNCED','1557b5ce-aa5b-4ebd-8c08-14da588b15f8',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"modelMatrix\":\"-0.74176,0.664523,-0.090562,0,-0.670666,-0.734966,0.100162,0,-3.8414e-9,0.135033,0.990841,0,-1.61158,25.0403,-14.5308,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'15580635-b080-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/15580635-b080-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_855e8123-60a7-46bf-bbe7-5b619e7e3c83_SESS_c128ff5c-e71a-4dbf-a87d-029519b521d9_BOSC_2d711298-fa1a-43f7-a2cc-493d030dba40_SNAPS_','2020-12-08 17:28:43','2020-06-17 11:50:38','15580635-b080-11ea-947d-226cec7cb58a.png','2020-12-08 18:28:43','SYNCED','15580635-b080-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.51.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'155aaebc-b080-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/155aaebc-b080-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_fd4825c4-beed-452a-8641-25e55e983249_ACT_855e8123-60a7-46bf-bbe7-5b619e7e3c83_SESS_c128ff5c-e71a-4dbf-a87d-029519b521d9_TOSC_df9431b2-2fe3-4aea-a54f-e4072dcbfdfc_SNAPS_','2020-12-08 17:28:44','2020-06-17 11:47:50','155aaebc-b080-11ea-947d-226cec7cb58a.png','2020-12-08 18:28:44','SYNCED','155aaebc-b080-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.51.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'155d8db3-b080-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/155d8db3-b080-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_855e8123-60a7-46bf-bbe7-5b619e7e3c83_SESS_c128ff5c-e71a-4dbf-a87d-029519b521d9_BOSC_2d711298-fa1a-43f7-a2cc-493d030dba40_PLY_','2020-12-08 17:28:44','2020-06-17 11:50:38','155d8db3-b080-11ea-947d-226cec7cb58a.ply','2020-12-08 18:28:44','SYNCED','155d8db3-b080-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.51.1.1\",\"modelMatrix\":\"-0.986846,0.153125,-0.0518452,0,-0.161664,-0.934723,0.316478,0,-1.51035e-9,0.320697,0.947182,0,-15.7077,16.7808,-13.1772,1\",\"title\":\"Mandibule PLY\"}'),(2,'155e3d13-2bb4-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/155e3d13-2bb4-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_4d5dcab0-4aac-4fc2-af46-a2a1883d7c8c_ACT_811df52c-f826-4fbc-a956-15504763fa8e_SESS_07240494-a51e-480d-bd92-5cdb7f5788b6_TOSC_eb1064f0-8631-4c18-add2-dc9d328e3d5b_PLY_','2020-12-23 09:08:59','2019-12-31 10:54:36','155e3d13-2bb4-11ea-947d-226cec7cb58a.ply','2020-12-23 10:08:59','SYNCED','155e3d13-2bb4-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"modelMatrix\":\"0.796636,-0.561494,0.223819,0,0.604459,0.740011,-0.294978,0,6.61103e-9,0.37028,0.92892,0,4.66432,-30.7577,-14.7484,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'155f89ab-d8c1-4d95-bb62-fcbd3fb1c3c0','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/155f89ab-d8c1-4d95-bb62-fcbd3fb1c3c0.png','SNAPS','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_db56cba1-23ff-48bf-b86e-4ceff749087f_BOSC_2ae10500-9760-472b-aee1-1fe00e33da53_SNAPS_','2021-12-30 18:03:44','2019-11-14 16:13:51','155f89ab-d8c1-4d95-bb62-fcbd3fb1c3c0.png','2021-12-30 19:03:44','SYNCED','155f89ab-d8c1-4d95-bb62-fcbd3fb1c3c0',0,NULL,'','','{\"displayTitle\":\"Mandibola 0\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'1561aeef-e65b-4ec8-8afd-6a1db7d1ccdb','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1561aeef-e65b-4ec8-8afd-6a1db7d1ccdb.png','SNAPS','PATIENT_cefbe643-b27e-40e4-9042-8620ee42f0e3_ACT_f0e99d57-6c12-450b-91f5-0410d608eb97_SESS_a67970f3-eec5-47f1-a8a4-8ed18b0cd94c_TOSC_9d98c76a-d89a-44af-a720-c75f83f4ad4c_SNAPS_','2022-02-01 11:47:48','2019-07-15 16:26:00','1561aeef-e65b-4ec8-8afd-6a1db7d1ccdb.png','2022-02-01 12:47:48','SYNCED','1561aeef-e65b-4ec8-8afd-6a1db7d1ccdb',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 70.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'1562d836-2bb4-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1562d836-2bb4-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_4d5dcab0-4aac-4fc2-af46-a2a1883d7c8c_ACT_811df52c-f826-4fbc-a956-15504763fa8e_SESS_07240494-a51e-480d-bd92-5cdb7f5788b6_TOSC_eb1064f0-8631-4c18-add2-dc9d328e3d5b_SNAPS_','2020-12-23 09:09:00','2019-12-31 10:54:36','1562d836-2bb4-11ea-947d-226cec7cb58a.png','2020-12-23 10:09:00','SYNCED','1562d836-2bb4-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'15649b47-2bb4-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/15649b47-2bb4-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_4d5dcab0-4aac-4fc2-af46-a2a1883d7c8c_ACT_811df52c-f826-4fbc-a956-15504763fa8e_SESS_07240494-a51e-480d-bd92-5cdb7f5788b6_BOSC_f6a85ee0-da10-4fc1-8821-a6d92cfbf7cd_PLY_','2020-12-23 09:09:00','2019-12-31 10:57:33','15649b47-2bb4-11ea-947d-226cec7cb58a.ply','2020-12-23 10:09:00','SYNCED','15649b47-2bb4-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"modelMatrix\":\"-0.874676,0.483178,-0.0384852,0,-0.484708,-0.871914,0.0694481,0,-3.4091e-9,0.0793987,0.996843,0,-1.83096,19.636,-21.2228,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'15660fb9-bc2b-4f1b-a9db-b1e8f06df1d2','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/15660fb9-bc2b-4f1b-a9db-b1e8f06df1d2.ply','PLY','PATIENT_96afd601-d8c2-4e20-abec-292b75f99b16_ACT_1b95d362-259d-45d0-b12b-f82c49c26c12_SESS_812c317a-661f-4f64-916c-40d448feeca0_TOSC_efb79c65-d8d5-4616-88c4-87020d1d032c_PLY_','2021-08-19 22:36:27','2019-12-05 20:34:21','15660fb9-bc2b-4f1b-a9db-b1e8f06df1d2.ply','2021-08-20 00:36:27','SYNCED','15660fb9-bc2b-4f1b-a9db-b1e8f06df1d2',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 224.1.1.1\",\"modelMatrix\":\"0.519053,-0.797914,0.306458,0,0.854742,0.484544,-0.186101,0,-1.18398e-10,0.358538,0.933515,0,-7.30781,-25.4049,-25.3121,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'15665d8a-2bb4-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/15665d8a-2bb4-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_4d5dcab0-4aac-4fc2-af46-a2a1883d7c8c_ACT_811df52c-f826-4fbc-a956-15504763fa8e_SESS_07240494-a51e-480d-bd92-5cdb7f5788b6_BOSC_f6a85ee0-da10-4fc1-8821-a6d92cfbf7cd_SNAPS_','2020-12-23 09:09:00','2019-12-31 10:57:33','15665d8a-2bb4-11ea-947d-226cec7cb58a.png','2020-12-23 10:09:00','SYNCED','15665d8a-2bb4-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'156d0645-0665-4265-94fa-03ac4e1e450c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/156d0645-0665-4265-94fa-03ac4e1e450c.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_abfdecf1-e835-4baf-9c2a-ebb77ed8fd7e_SESS_b192bf2c-b8a2-4077-980e-b7d2d1c460de_BOSC_3470bf67-5d1a-4acf-b824-5345542fde48_SNAPS_','2020-12-16 10:53:25','2020-05-28 10:00:52','156d0645-0665-4265-94fa-03ac4e1e450c.png','2020-12-16 11:53:25','SYNCED','156d0645-0665-4265-94fa-03ac4e1e450c',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 216.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'1579007b-9e20-45b4-8afd-65b30eca854c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1579007b-9e20-45b4-8afd-65b30eca854c.png','SNAPS','PATIENT_87d3edf3-06f6-4fb8-8ac6-e0c73d339bbe_ACT_8c4a4ddb-e5bf-431f-b0af-03f1f155ac20_SESS_5a8d948f-9b60-450f-800c-e78e7d2670d5_TOSC_7d9da2cf-280b-48f0-8680-8a7fbc34d9de_SNAPS_','2022-02-01 11:47:49','2019-07-15 15:38:43','1579007b-9e20-45b4-8afd-65b30eca854c.png','2022-02-01 12:47:49','SYNCED','1579007b-9e20-45b4-8afd-65b30eca854c',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 66.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'159450eb-6900-44fb-b9b0-33a9a463cb43','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/159450eb-6900-44fb-b9b0-33a9a463cb43.ply','PLY','PATIENT_dce2d354-977c-43bc-973c-f0ea8296f48d_ACT_73d0a12e-a102-409d-92c7-25347f29f3a2_SESS_f0be6bf9-31df-434a-8258-f30cab8a2185_TOSC_ced66b33-8c4a-4689-a266-355cea9a77cc_PLY_','2021-12-30 18:03:44','2019-11-04 15:19:10','159450eb-6900-44fb-b9b0-33a9a463cb43.ply','2021-12-30 19:03:44','SYNCED','159450eb-6900-44fb-b9b0-33a9a463cb43',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 197.2.1.1\",\"modelMatrix\":\"0.83592,-0.527059,0.153124,0,0.548852,0.802729,-0.233213,0,-6.47181e-9,0.27899,0.960294,0,9.45869,-33.6047,-16.9852,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'15aff93b-7757-4dc2-8dad-949f0e4da6fc','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/15aff93b-7757-4dc2-8dad-949f0e4da6fc.ply','PLY','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_fd694b3f-abde-4e46-91f7-7c62bfdcafa4_SESS_73a3f5b9-e905-4911-a163-2022e1de3380_TOSC_6832121d-a35d-4ba8-8810-5c0bb21f6ae0_PLY_','2021-08-19 22:36:29','2019-11-26 20:49:52','15aff93b-7757-4dc2-8dad-949f0e4da6fc.ply','2021-08-20 00:36:29','SYNCED','15aff93b-7757-4dc2-8dad-949f0e4da6fc',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"modelMatrix\":\"0.854224,-0.464537,0.233467,0,0.519906,0.763252,-0.383595,0,1.9098e-9,0.449057,0.893503,0,11.8782,-28.9887,-15.3757,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'15cb1987-5c20-407b-ba14-4b8835fa6724','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/15cb1987-5c20-407b-ba14-4b8835fa6724.stl','STL','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_fd694b3f-abde-4e46-91f7-7c62bfdcafa4_SESS_73a3f5b9-e905-4911-a163-2022e1de3380_TOSC_7af0421e-a090-426e-a7cc-ced7d1b09ced_STL_','2021-08-19 22:36:30','2019-11-26 21:22:44','15cb1987-5c20-407b-ba14-4b8835fa6724.stl','2021-08-20 00:36:30','SYNCED','15cb1987-5c20-407b-ba14-4b8835fa6724',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"modelMatrix\":\"0.746539,-0.613945,0.25642,0,0.665341,0.68887,-0.287713,0,1.32865e-8,0.385396,0.922751,0,5.52737,-35.8865,-16.9241,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'15d410cb-cfb1-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/15d410cb-cfb1-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_37924e66-6fca-42d1-866c-8897f314ef35_ACT_b97bc99b-fc77-46b8-82b7-151aef0aec54_SESS_f2ff3c9a-d754-4dd6-9785-85c513b9862b_TOSC_bef0018c-1ca5-45e9-b2a7-eb2bf155f2a7_SNAPS_','2022-02-01 11:47:49','2019-09-05 09:35:47','15d410cb-cfb1-11e9-947d-226cec7cb58a.png','2022-02-01 12:47:49','SYNCED','15d410cb-cfb1-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 145.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'15d5fa2b-cfb1-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/15d5fa2b-cfb1-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_37924e66-6fca-42d1-866c-8897f314ef35_ACT_b97bc99b-fc77-46b8-82b7-151aef0aec54_SESS_f2ff3c9a-d754-4dd6-9785-85c513b9862b_BOSC_bdce270a-4f08-427f-9c20-88cca983c47e_SNAPS_','2022-02-01 11:47:49','2019-09-05 09:43:35','15d5fa2b-cfb1-11e9-947d-226cec7cb58a.png','2022-02-01 12:47:49','SYNCED','15d5fa2b-cfb1-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 145.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'15d8bc9e-cfb1-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/15d8bc9e-cfb1-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_37924e66-6fca-42d1-866c-8897f314ef35_ACT_b97bc99b-fc77-46b8-82b7-151aef0aec54_SESS_f2ff3c9a-d754-4dd6-9785-85c513b9862b_BOSC_bdce270a-4f08-427f-9c20-88cca983c47e_PLY_','2022-02-01 11:47:49','2019-09-05 09:43:35','15d8bc9e-cfb1-11e9-947d-226cec7cb58a.ply','2022-02-01 12:47:49','SYNCED','15d8bc9e-cfb1-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 145.1.1.1\",\"modelMatrix\":\"-0.636227,-0.770253,0.0438665,0,0.771501,-0.635198,0.036175,0,-1.05727e-9,0.0568586,0.998382,0,-29.0141,-3.76624,-19.5755,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'15da7b76-cfb1-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/15da7b76-cfb1-11e9-947d-226cec7cb58a.stl','STL','PATIENT_37924e66-6fca-42d1-866c-8897f314ef35_ACT_b97bc99b-fc77-46b8-82b7-151aef0aec54_SESS_f2ff3c9a-d754-4dd6-9785-85c513b9862b_TOSC_bef0018c-1ca5-45e9-b2a7-eb2bf155f2a7_STL_','2022-02-01 11:47:49','2019-09-05 09:35:47','15da7b76-cfb1-11e9-947d-226cec7cb58a.stl','2022-02-01 12:47:49','SYNCED','15da7b76-cfb1-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 145.1.1.1\",\"modelMatrix\":\"0.764032,-0.533948,0.362153,0,0.645178,0.632311,-0.428868,0,-2.04107e-8,0.561322,0.827597,0,6.4005,-39.2018,-26.7108,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'15dc5d58-cfb1-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/15dc5d58-cfb1-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_37924e66-6fca-42d1-866c-8897f314ef35_ACT_b97bc99b-fc77-46b8-82b7-151aef0aec54_SESS_f2ff3c9a-d754-4dd6-9785-85c513b9862b_TOSC_bef0018c-1ca5-45e9-b2a7-eb2bf155f2a7_PLY_','2022-02-01 11:47:50','2019-09-05 09:35:47','15dc5d58-cfb1-11e9-947d-226cec7cb58a.ply','2022-02-01 12:47:50','SYNCED','15dc5d58-cfb1-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 145.1.1.1\",\"modelMatrix\":\"0.764032,-0.533948,0.362153,0,0.645178,0.632311,-0.428868,0,-2.04107e-8,0.561322,0.827597,0,6.4005,-39.2018,-26.7108,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'15ddb887-cfb1-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/15ddb887-cfb1-11e9-947d-226cec7cb58a.stl','STL','PATIENT_37924e66-6fca-42d1-866c-8897f314ef35_ACT_b97bc99b-fc77-46b8-82b7-151aef0aec54_SESS_f2ff3c9a-d754-4dd6-9785-85c513b9862b_BOSC_bdce270a-4f08-427f-9c20-88cca983c47e_STL_','2022-02-01 11:47:50','2019-09-05 09:43:35','15ddb887-cfb1-11e9-947d-226cec7cb58a.stl','2022-02-01 12:47:50','SYNCED','15ddb887-cfb1-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 145.1.1.1\",\"modelMatrix\":\"-0.636227,-0.770253,0.0438665,0,0.771501,-0.635198,0.036175,0,-1.05727e-9,0.0568586,0.998382,0,-29.0141,-3.76624,-19.5755,1\",\"title\":\"MANDIBULE STL\"}'),(2,'15ed7ae2-4aad-4290-b4c9-2050424977df','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/15ed7ae2-4aad-4290-b4c9-2050424977df.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_555acc27-98f9-4870-b622-74c6431a068c_SESS_696da30d-59a2-4a70-88ad-383566369158_BOSC_db33c7dc-51d1-4acd-87b6-290998a23797_PLY_','2020-12-08 17:28:54','2020-06-18 11:53:03','15ed7ae2-4aad-4290-b4c9-2050424977df.ply','2020-12-08 18:28:54','SYNCED','15ed7ae2-4aad-4290-b4c9-2050424977df',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.65.1.1\",\"modelMatrix\":\"-0.849572,0.50027,-0.167205,0,-0.527473,-0.805758,0.269307,0,3.84853e-9,0.316992,0.948428,0,-7.13255,23.5488,-18.5156,1\",\"title\":\"Mandibule PLY\"}'),(2,'15fc6f86-7eff-4a72-bea1-fa8c13e35aaa','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/15fc6f86-7eff-4a72-bea1-fa8c13e35aaa.png','SNAPS','PATIENT_5eb7abc4-d0cc-450f-9e7a-604c0f9351ff_ACT_10ab35a8-5264-4163-af13-7213405a8e68_SESS_90aa3626-8319-4317-a65b-5406f818f772_TOSC_68a16a4f-f6d7-4d6f-9252-d9caa7e82ef5_SNAPS_','2022-03-04 13:40:26','2019-07-11 11:04:29','15fc6f86-7eff-4a72-bea1-fa8c13e35aaa.png','2022-03-04 14:40:26','SYNCED','15fc6f86-7eff-4a72-bea1-fa8c13e35aaa',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 39.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'161d38ea-0937-42d1-81b3-ba8c677916f1','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/161d38ea-0937-42d1-81b3-ba8c677916f1.png','SNAPS','PATIENT_413fa48c-7f99-4dd8-a792-00becc734610_ACT_91711ce4-9482-4ede-963f-52b2515d8e67_SESS_b44a90cf-dcf7-4885-b25d-5f2caf2f85ac_TOSC_ed5ad41d-f06b-4bc1-a528-95df2129fd1e_SNAPS_','2020-12-16 11:09:10','2020-01-16 10:08:11','161d38ea-0937-42d1-81b3-ba8c677916f1.png','2020-12-16 12:09:10','SYNCED','161d38ea-0937-42d1-81b3-ba8c677916f1',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'16223397-e7cb-4741-86f5-f77459118aa4','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/16223397-e7cb-4741-86f5-f77459118aa4.png','SNAPS','PATIENT_de132740-d90a-46fb-9843-ca1070f94f10_ACT_64ad6d77-7b96-44e1-932d-0031115fd156_SESS_bb5725cd-9c7f-452c-a8b4-0cb1c79cef27_TOSC_c93ccf4d-eb64-44f1-b9fa-036840d78ee2_SNAPS_','2022-03-04 13:40:26','2019-07-08 16:19:23','16223397-e7cb-4741-86f5-f77459118aa4.png','2022-03-04 14:40:26','SYNCED','16223397-e7cb-4741-86f5-f77459118aa4',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 5.2.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'16321232-3051-4fb2-8d9b-055870292861','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/16321232-3051-4fb2-8d9b-055870292861.ply','PLY','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_92b82de5-561e-4d3a-8c0a-89db7b9daf7c_SESS_d567dbe6-b7fa-4e4a-875f-3787a6f600d7_BOSC_6f9d6efa-a50f-4d94-bd93-793af1fd8023_PLY_','2020-12-16 11:09:11','2020-01-23 13:53:09','16321232-3051-4fb2-8d9b-055870292861.ply','2020-12-16 12:09:11','SYNCED','16321232-3051-4fb2-8d9b-055870292861',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.1.1.1.1\",\"modelMatrix\":\"-0.81983,0.565755,-0.0883188,0,-0.572607,-0.810019,0.12645,0,1.50919e-9,0.15424,0.988033,0,-1.00563,23.1568,-15.9834,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'16328d27-3cb1-40fd-9a09-c8f4faae6976','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/16328d27-3cb1-40fd-9a09-c8f4faae6976.ply','PLY','PATIENT_286e820b-c75e-4ab1-a5c5-0a716fb62e78_ACT_9ec2ca33-c4b7-45ae-bf07-0429298e9bad_SESS_a85faa48-ea55-48f9-bceb-a4be46385631_BOSC_e0f82691-2617-43af-8f28-6af9f75b282d_PLY_','2020-12-16 10:53:30','2020-02-18 11:00:42','16328d27-3cb1-40fd-9a09-c8f4faae6976.ply','2020-12-16 11:53:30','SYNCED','16328d27-3cb1-40fd-9a09-c8f4faae6976',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 95.1.1.1.1\",\"modelMatrix\":\"-0.975367,0.214112,-0.0530508,0,-0.220586,-0.94674,0.234575,0,3.82101e-9,0.240499,0.970649,0,-8.33795,15.7746,-17.7107,1\",\"title\":\"MANDIBULE PLY\"}'),(524,'16486c2c-976d-4753-962d-ec06644e3589','/var/.data/2020/9f2592c4-76b3-4230-b316-5ec7307bcb92/ca68987b-cfa7-4f89-ae77-d77610474e05/session_68c2ce3d-9d7f-4a09-a042-4f337f0d0f99/occlusion_6c011242-25f9-4e08-85a7-df06ad3646e3/scan_6f5fb9c2-7efd-4627-a0e6-b2d6038e2188/13_w1_o1_maxillaire_scan_file_0.ply','PLY','PATIENT_ca68987b-cfa7-4f89-ae77-d77610474e05_ACT_68c2ce3d-9d7f-4a09-a042-4f337f0d0f99_SESS_6c011242-25f9-4e08-85a7-df06ad3646e3_TOSC_6f5fb9c2-7efd-4627-a0e6-b2d6038e2188_PLY_','2022-03-04 13:42:45','2020-02-03 18:42:41','13_w1_o1_maxillaire_scan_file_0.ply','2022-03-04 14:42:45','SYNCED','16486c2c-976d-4753-962d-ec06644e3589',0,NULL,'9f2592c4-76b3-4230-b316-5ec7307bcb92','9f2592c4-76b3-4230-b316-5ec7307bcb92','{\"displayTitle\":\"Maxillaire 1.13.1.1.1\",\"modelMatrix\":\"0.618507,-0.743504,0.254266,0,0.785779,0.585231,-0.20014,0,4.05461e-9,0.323585,0.946199,0,-6.77118,-1.40552,-17.7028,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'164b5934-89f0-49a6-8b4a-3d219028ebc2','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/164b5934-89f0-49a6-8b4a-3d219028ebc2.ply','PLY','PATIENT_85383439-b5ef-448f-bbc5-cdaddf8ed626_ACT_cc87cc84-124c-43bf-91f3-607ec6779b2c_SESS_a74f7ee6-623c-4010-8d90-6da6fe053acc_TOSC_10455ab0-d1db-4d60-9a3f-111318f5532a_PLY_','2022-02-01 11:47:50','2019-07-12 08:50:49','164b5934-89f0-49a6-8b4a-3d219028ebc2.ply','2022-02-01 12:47:50','SYNCED','164b5934-89f0-49a6-8b4a-3d219028ebc2',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 51.1.1.1\",\"modelMatrix\":\"0.575674,-0.790139,0.210429,0,0.817679,0.556284,-0.148149,0,1.1191e-8,0.25735,0.966318,0,-4.30442,-25.532,-14.7083,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1665fedd-809b-4dac-a9c8-4403752d148b','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1665fedd-809b-4dac-a9c8-4403752d148b.stl','STL','PATIENT_de25b615-973f-4c4b-816f-91e661f13dde_ACT_671432ea-64fe-4d83-b4a7-ca1415ddf527_SESS_ab99f8ce-fe34-496e-b44b-81de6494455d_BOSC_7c48b43b-5a11-452c-b64c-64ec50012f71_STL_','2022-02-01 11:47:51','2019-07-12 09:06:22','1665fedd-809b-4dac-a9c8-4403752d148b.stl','2022-02-01 12:47:51','SYNCED','1665fedd-809b-4dac-a9c8-4403752d148b',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 52.1.1.1\",\"modelMatrix\":\"-0.883354,0.463348,-0.0706748,0,-0.468707,-0.873254,0.133198,0,-7.58871e-9,0.150787,0.988566,0,-5.44633,23.7649,-25.611,1\",\"title\":\"MANDIBULE STL\"}'),(2,'166a0fdd-3df8-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/166a0fdd-3df8-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_961e5084-1756-4d47-8e90-a6b717094efe_ACT_e756944c-dde0-419e-9f4c-37821d9a78c4_SESS_986a8205-36a2-4328-8a86-368dc7208c69_TOSC_28e137e9-1c1a-471c-817d-381c91646d70_PLY_','2020-12-16 11:09:11','2020-01-23 16:43:58','166a0fdd-3df8-11ea-947d-226cec7cb58a.ply','2020-12-16 12:09:11','SYNCED','166a0fdd-3df8-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 199.1.6.1.1\",\"modelMatrix\":\"-0.0771655,-0.964604,0.252161,0,0.997018,-0.0746567,0.0195164,0,1.28438e-9,0.252916,0.967488,0,-22.7081,-28.6124,-20.0799,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'166bf619-3df8-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/166bf619-3df8-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_961e5084-1756-4d47-8e90-a6b717094efe_ACT_e756944c-dde0-419e-9f4c-37821d9a78c4_SESS_986a8205-36a2-4328-8a86-368dc7208c69_TOSC_28e137e9-1c1a-471c-817d-381c91646d70_SNAPS_','2020-12-16 11:09:11','2020-01-23 16:43:58','166bf619-3df8-11ea-947d-226cec7cb58a.png','2020-12-16 12:09:11','SYNCED','166bf619-3df8-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 199.1.6.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'166d9db5-3df8-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/166d9db5-3df8-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_961e5084-1756-4d47-8e90-a6b717094efe_ACT_e756944c-dde0-419e-9f4c-37821d9a78c4_SESS_986a8205-36a2-4328-8a86-368dc7208c69_BOSC_d86489d9-9b76-4f84-8010-a746723c8d68_SNAPS_','2020-12-16 11:09:12','2020-01-23 16:50:08','166d9db5-3df8-11ea-947d-226cec7cb58a.png','2020-12-16 12:09:12','SYNCED','166d9db5-3df8-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 199.1.6.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'166f9938-3df8-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/166f9938-3df8-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_961e5084-1756-4d47-8e90-a6b717094efe_ACT_e756944c-dde0-419e-9f4c-37821d9a78c4_SESS_986a8205-36a2-4328-8a86-368dc7208c69_BOSC_d86489d9-9b76-4f84-8010-a746723c8d68_PLY_','2020-12-16 11:09:12','2020-01-23 16:50:08','166f9938-3df8-11ea-947d-226cec7cb58a.ply','2020-12-16 12:09:12','SYNCED','166f9938-3df8-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 199.1.6.1.1\",\"modelMatrix\":\"-0.992102,0.115049,-0.049971,0,-0.125433,-0.909972,0.395243,0,3.9248e-9,0.398389,0.917217,0,-20.6476,15.5082,-19.5487,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'167730b6-5add-434f-8a10-be4f1df91d49','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/167730b6-5add-434f-8a10-be4f1df91d49.stl','STL','PATIENT_6ed444a5-4611-4f3b-8cae-804b37830b93_ACT_1ef97e5c-1a4d-4f3d-a593-b198e5bb381c_SESS_6670bbfb-e525-4dfe-a47a-98c0d576cbaa_TOSC_4b1a53cf-cb17-45ab-81f3-b96bda59df87_STL_','2022-03-04 13:40:26','2019-07-11 09:40:51','167730b6-5add-434f-8a10-be4f1df91d49.stl','2022-03-04 14:40:26','SYNCED','167730b6-5add-434f-8a10-be4f1df91d49',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 37.1.1.1\",\"modelMatrix\":\"0.373715,-0.894549,0.245191,0,0.927544,0.360421,-0.0987893,0,2.57867e-9,0.264344,0.964428,0,-9.01243,-39.9177,-13.3765,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'1678ba62-1268-4943-a47e-637668877987','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1678ba62-1268-4943-a47e-637668877987.png','SNAPS','PATIENT_4196aec4-665a-43ec-823c-c46b273b499c_ACT_4fea5157-9778-4ede-818a-ed0fde944998_SESS_55cdee94-4e99-4007-9e55-e77ae266154e_TOSC_b44b6acf-5ee7-4d6e-8471-b71e5b40cd8a_SNAPS_','2021-12-30 18:03:47','2019-11-07 16:50:46','1678ba62-1268-4943-a47e-637668877987.png','2021-12-30 19:03:47','SYNCED','1678ba62-1268-4943-a47e-637668877987',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.27.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'16828305-9146-49a6-a393-dc7edcef2921','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/16828305-9146-49a6-a393-dc7edcef2921.ply','PLY','PATIENT_11de1596-c701-436e-8902-a3d28ae466d2_ACT_6fa69972-69f3-4c7f-8791-75cc95c31a0d_SESS_28878620-862a-4728-b222-123cb5890c82_TOSC_3197955f-3b34-4bce-910a-0c3d35bb155f_PLY_','2020-12-23 09:09:06','2019-12-20 14:45:36','16828305-9146-49a6-a393-dc7edcef2921.ply','2020-12-23 10:09:06','SYNCED','16828305-9146-49a6-a393-dc7edcef2921',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"modelMatrix\":\"0.138511,-0.977277,0.160447,0,0.990361,0.136682,-0.02244,0,6.10888e-10,0.162009,0.986789,0,-18.3366,-32.6342,-12.2847,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'169aa4c9-09d1-42f3-9624-ba4c5a25cfcc','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/169aa4c9-09d1-42f3-9624-ba4c5a25cfcc.png','SNAPS','PATIENT_2ff0cc07-0aa8-4776-866a-c0be4904b070_ACT_87c983ec-e441-439c-96d9-b8436371d3f3_SESS_b9a447ac-7116-432b-9e63-91c835fbd309_TOSC_0a7e72f1-3a12-4381-9ec0-1519fd78692c_SNAPS_','2021-02-16 16:38:18','2019-12-09 15:57:49','169aa4c9-09d1-42f3-9624-ba4c5a25cfcc.png','2021-02-16 17:38:18','SYNCED','169aa4c9-09d1-42f3-9624-ba4c5a25cfcc',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 40.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'16aff009-5882-4204-8e24-61f78f96ddb6','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/16aff009-5882-4204-8e24-61f78f96ddb6.stl','STL','PATIENT_4ec057eb-d132-43fb-96fb-11348abd205b_ACT_bec7cb5f-4dd0-4601-aa64-0a558c6e8b78_SESS_b153a28c-3493-496f-bb70-e96ca7cf7e78_TOSC_5774d083-5529-4abf-bbc4-30e8e59bcab2_STL_','2021-12-30 18:03:47','2019-10-02 15:23:05','16aff009-5882-4204-8e24-61f78f96ddb6.stl','2021-12-30 19:03:47','SYNCED','16aff009-5882-4204-8e24-61f78f96ddb6',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 174.1.1.1\",\"modelMatrix\":\"0.685321,-0.672551,0.279304,0,0.728242,0.632912,-0.262842,0,-2.35119e-8,0.383532,0.923528,0,5.40038,-35.3585,-16.6417,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'16da7b89-a961-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/16da7b89-a961-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_4ed0364e-d067-4452-8839-8e909c61b1ea_ACT_439d6b4b-8f66-4316-a9b9-00cd70637694_SESS_14bc0526-ec82-440b-a6a4-b544d274a55b_TOSC_c880d341-0837-4d73-9aaa-da9b4f978b1d_PLY_','2020-12-08 17:29:04','2020-06-08 10:18:25','16da7b89-a961-11ea-947d-226cec7cb58a.ply','2020-12-08 18:29:04','SYNCED','16da7b89-a961-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.29.1.1\",\"modelMatrix\":\"0.533222,-0.821323,0.202738,0,0.845976,0.517683,-0.127787,0,-4.71109e-9,0.23965,0.970859,0,-4.15096,-32.3971,-14.4051,1\",\"title\":\"Maxillaire PLY\"}'),(2,'16dc7abc-a961-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/16dc7abc-a961-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_4ed0364e-d067-4452-8839-8e909c61b1ea_ACT_439d6b4b-8f66-4316-a9b9-00cd70637694_SESS_14bc0526-ec82-440b-a6a4-b544d274a55b_TOSC_c880d341-0837-4d73-9aaa-da9b4f978b1d_SNAPS_','2020-12-08 17:29:04','2020-06-08 10:18:25','16dc7abc-a961-11ea-947d-226cec7cb58a.png','2020-12-08 18:29:04','SYNCED','16dc7abc-a961-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.29.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'16de75bf-a961-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/16de75bf-a961-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_439d6b4b-8f66-4316-a9b9-00cd70637694_SESS_14bc0526-ec82-440b-a6a4-b544d274a55b_BOSC_b5d19269-a7c3-4c3e-ab15-480cd31418cb_PLY_','2020-12-08 17:29:05','2020-06-08 10:21:22','16de75bf-a961-11ea-947d-226cec7cb58a.ply','2020-12-08 18:29:05','SYNCED','16de75bf-a961-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.29.1.1\",\"modelMatrix\":\"-0.992457,0.113621,-0.0460417,0,-0.122595,-0.919807,0.372726,0,5.06136e-9,0.375559,0.926798,0,-15.5783,9.50834,-27.3257,1\",\"title\":\"Mandibule PLY\"}'),(2,'16e045c2-a961-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/16e045c2-a961-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_439d6b4b-8f66-4316-a9b9-00cd70637694_SESS_14bc0526-ec82-440b-a6a4-b544d274a55b_BOSC_b5d19269-a7c3-4c3e-ab15-480cd31418cb_SNAPS_','2020-12-08 17:29:05','2020-06-08 10:21:22','16e045c2-a961-11ea-947d-226cec7cb58a.png','2020-12-08 18:29:05','SYNCED','16e045c2-a961-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.29.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'16f0a950-b0dc-415f-b7e7-2a88d5cb2024','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/16f0a950-b0dc-415f-b7e7-2a88d5cb2024.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_b17fbded-e440-404b-9e3a-f1ff0c633c52_SESS_d3b4a31d-648a-440e-bf8a-a06937232206_BOSC_20ce1c07-137c-4f06-832a-980af08b477d_SNAPS_','2020-12-16 10:53:34','2020-02-05 10:36:36','16f0a950-b0dc-415f-b7e7-2a88d5cb2024.png','2020-12-16 11:53:34','SYNCED','16f0a950-b0dc-415f-b7e7-2a88d5cb2024',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'1705a445-2bdd-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1705a445-2bdd-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_49a084e5-164b-4cc8-882c-863d3b56289f_ACT_81763d87-b7a1-49c4-84d5-66fb0a646f2b_SESS_7a2fb731-12b4-46ce-b8fb-342d683b46d0_TOSC_bd93feca-129a-4d05-8364-774b78d1857e_PLY_','2020-12-23 09:09:07','2019-12-31 15:48:26','1705a445-2bdd-11ea-947d-226cec7cb58a.ply','2020-12-23 10:09:07','SYNCED','1705a445-2bdd-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"modelMatrix\":\"0.513981,-0.771292,0.375409,0,0.857802,0.462146,-0.224939,0,-8.08963e-9,0.43764,0.89915,0,-0.921068,-28.1165,-23.2354,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1709e702-2bdd-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1709e702-2bdd-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_81763d87-b7a1-49c4-84d5-66fb0a646f2b_SESS_7a2fb731-12b4-46ce-b8fb-342d683b46d0_BOSC_1c6a8350-0f65-4059-b5fc-f8ef2935c72a_SNAPS_','2020-12-23 09:09:07','2019-12-31 15:51:26','1709e702-2bdd-11ea-947d-226cec7cb58a.png','2020-12-23 10:09:07','SYNCED','1709e702-2bdd-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'170b5d80-2bdd-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/170b5d80-2bdd-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_49a084e5-164b-4cc8-882c-863d3b56289f_ACT_81763d87-b7a1-49c4-84d5-66fb0a646f2b_SESS_7a2fb731-12b4-46ce-b8fb-342d683b46d0_TOSC_bd93feca-129a-4d05-8364-774b78d1857e_SNAPS_','2020-12-23 09:09:08','2019-12-31 15:48:26','170b5d80-2bdd-11ea-947d-226cec7cb58a.png','2020-12-23 10:09:08','SYNCED','170b5d80-2bdd-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'170ce710-2bdd-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/170ce710-2bdd-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_81763d87-b7a1-49c4-84d5-66fb0a646f2b_SESS_7a2fb731-12b4-46ce-b8fb-342d683b46d0_BOSC_1c6a8350-0f65-4059-b5fc-f8ef2935c72a_PLY_','2020-12-23 09:09:08','2019-12-31 15:51:26','170ce710-2bdd-11ea-947d-226cec7cb58a.ply','2020-12-23 10:09:08','SYNCED','170ce710-2bdd-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"modelMatrix\":\"-0.997211,0.0716211,-0.0209964,0,-0.0746353,-0.956937,0.280536,0,9.27271e-10,0.281321,0.959614,0,-12.4366,11.0727,-22.1644,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'17241755-1dbd-46b7-ac31-5b8fe0ad7775','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/17241755-1dbd-46b7-ac31-5b8fe0ad7775.png','SNAPS','PATIENT_a3021108-f5bb-4035-93fa-e7903e33ed9c_ACT_13598db2-93f5-45d6-8ad6-218304620035_SESS_5b19a59d-3516-47b6-90c1-e0a5810e5344_TOSC_a9c6d045-30f6-42ed-855c-0465ae65b41b_SNAPS_','2020-12-23 09:09:08','2019-12-18 13:22:53','17241755-1dbd-46b7-ac31-5b8fe0ad7775.png','2020-12-23 10:09:08','SYNCED','17241755-1dbd-46b7-ac31-5b8fe0ad7775',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 20.1.267.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'1729e4b7-2192-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1729e4b7-2192-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_a3021108-f5bb-4035-93fa-e7903e33ed9c_ACT_13598db2-93f5-45d6-8ad6-218304620035_SESS_5b19a59d-3516-47b6-90c1-e0a5810e5344_TOSC_a9c6d045-30f6-42ed-855c-0465ae65b41b_SNAPS_','2020-12-23 09:09:09','2019-12-18 13:22:53','1729e4b7-2192-11ea-947d-226cec7cb58a.png','2020-12-23 10:09:09','SYNCED','1729e4b7-2192-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 20.1.267.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'172b8867-2192-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/172b8867-2192-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_bfff99cf-e91f-4eed-bb3a-06bece8eaf9f_ACT_13598db2-93f5-45d6-8ad6-218304620035_SESS_5b19a59d-3516-47b6-90c1-e0a5810e5344_BOSC_3ff97289-082b-435b-8bc1-77b8adac01ee_PLY_','2020-12-23 09:09:09','2019-12-18 13:27:56','172b8867-2192-11ea-947d-226cec7cb58a.ply','2020-12-23 10:09:09','SYNCED','172b8867-2192-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 20.1.267.1.1.1\",\"modelMatrix\":\"-0.954017,0.278986,-0.10963,0,-0.299753,-0.887922,0.348917,0,-3.9746e-11,0.365734,0.930719,0,-6.08293,12.2362,-20.8238,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'172d1440-2192-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/172d1440-2192-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_a3021108-f5bb-4035-93fa-e7903e33ed9c_ACT_13598db2-93f5-45d6-8ad6-218304620035_SESS_5b19a59d-3516-47b6-90c1-e0a5810e5344_TOSC_a9c6d045-30f6-42ed-855c-0465ae65b41b_PLY_','2020-12-23 09:09:09','2019-12-18 13:22:53','172d1440-2192-11ea-947d-226cec7cb58a.ply','2020-12-23 10:09:09','SYNCED','172d1440-2192-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 20.1.267.1.1.1\",\"modelMatrix\":\"0.847622,-0.484787,0.215682,0,0.530601,0.774436,-0.344547,0,-5.74001e-10,0.406487,0.913657,0,13.8176,-29.9716,-17.6239,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'172ef7d5-2192-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/172ef7d5-2192-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_bfff99cf-e91f-4eed-bb3a-06bece8eaf9f_ACT_13598db2-93f5-45d6-8ad6-218304620035_SESS_5b19a59d-3516-47b6-90c1-e0a5810e5344_BOSC_3ff97289-082b-435b-8bc1-77b8adac01ee_SNAPS_','2020-12-23 09:09:09','2019-12-18 13:27:56','172ef7d5-2192-11ea-947d-226cec7cb58a.png','2020-12-23 10:09:09','SYNCED','172ef7d5-2192-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 20.1.267.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'1742d534-176d-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1742d534-176d-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_96afd601-d8c2-4e20-abec-292b75f99b16_ACT_1b95d362-259d-45d0-b12b-f82c49c26c12_SESS_812c317a-661f-4f64-916c-40d448feeca0_BOSC_9f368c08-fead-4763-876d-df309790e365_SNAPS_','2021-08-19 22:39:09','2019-12-05 20:38:54','1742d534-176d-11ea-947d-226cec7cb58a.png','2021-08-20 00:39:09','SYNCED','1742d534-176d-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 224.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'17449f00-176d-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/17449f00-176d-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_96afd601-d8c2-4e20-abec-292b75f99b16_ACT_1b95d362-259d-45d0-b12b-f82c49c26c12_SESS_812c317a-661f-4f64-916c-40d448feeca0_TOSC_efb79c65-d8d5-4616-88c4-87020d1d032c_SNAPS_','2021-08-19 22:39:10','2019-12-05 20:34:21','17449f00-176d-11ea-947d-226cec7cb58a.png','2021-08-20 00:39:10','SYNCED','17449f00-176d-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 224.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'1745f4dc-1903-4751-9e9b-6ccd5ac5f27d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1745f4dc-1903-4751-9e9b-6ccd5ac5f27d.stl','STL','PATIENT_72f539f4-2d06-47fa-b0b8-1291879a4818_ACT_d55baca2-6f09-4446-a148-dcdcfcaf57d8_SESS_5efdc987-8bdd-454f-b282-82efcf807bae_TOSC_4f43da91-58b4-4461-8b83-659e6fbebe8c_STL_','2021-08-19 22:39:10','2019-11-26 15:52:02','1745f4dc-1903-4751-9e9b-6ccd5ac5f27d.stl','2021-08-20 00:39:10','SYNCED','1745f4dc-1903-4751-9e9b-6ccd5ac5f27d',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 86.1.1.1.1\",\"modelMatrix\":\"0.661741,-0.699061,0.270947,0,0.749733,0.617016,-0.239148,0,-4.74625e-9,0.361392,0.932414,0,4.0184,-35.7163,-19.9875,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'174668da-176d-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/174668da-176d-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_96afd601-d8c2-4e20-abec-292b75f99b16_ACT_1b95d362-259d-45d0-b12b-f82c49c26c12_SESS_812c317a-661f-4f64-916c-40d448feeca0_TOSC_efb79c65-d8d5-4616-88c4-87020d1d032c_PLY_','2021-08-19 22:39:11','2019-12-05 20:34:21','174668da-176d-11ea-947d-226cec7cb58a.ply','2021-08-20 00:39:11','SYNCED','174668da-176d-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 224.1.1.1\",\"modelMatrix\":\"0.519053,-0.797914,0.306458,0,0.854742,0.484544,-0.186101,0,-1.18398e-10,0.358538,0.933515,0,-7.30781,-25.4049,-25.3121,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'174837d3-176d-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/174837d3-176d-11ea-947d-226cec7cb58a.stl','STL','PATIENT_96afd601-d8c2-4e20-abec-292b75f99b16_ACT_1b95d362-259d-45d0-b12b-f82c49c26c12_SESS_812c317a-661f-4f64-916c-40d448feeca0_TOSC_efb79c65-d8d5-4616-88c4-87020d1d032c_STL_','2021-08-19 22:39:12','2019-12-05 20:34:21','174837d3-176d-11ea-947d-226cec7cb58a.stl','2021-08-20 00:39:12','SYNCED','174837d3-176d-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 224.1.1.1\",\"modelMatrix\":\"0.519053,-0.797914,0.306458,0,0.854742,0.484544,-0.186101,0,-1.18398e-10,0.358538,0.933515,0,-7.30781,-25.4049,-25.3121,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'174ac8d6-176d-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/174ac8d6-176d-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_96afd601-d8c2-4e20-abec-292b75f99b16_ACT_1b95d362-259d-45d0-b12b-f82c49c26c12_SESS_812c317a-661f-4f64-916c-40d448feeca0_BOSC_9f368c08-fead-4763-876d-df309790e365_PLY_','2021-08-19 22:39:12','2019-12-05 20:38:54','174ac8d6-176d-11ea-947d-226cec7cb58a.ply','2021-08-20 00:39:12','SYNCED','174ac8d6-176d-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 224.1.1.1\",\"modelMatrix\":\"-0.682,0.717259,-0.142885,0,-0.731353,-0.668857,0.133243,0,1.15581e-8,0.195371,0.980729,0,-0.820476,21.5265,-15.7267,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'174c5596-176d-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/174c5596-176d-11ea-947d-226cec7cb58a.stl','STL','PATIENT_96afd601-d8c2-4e20-abec-292b75f99b16_ACT_1b95d362-259d-45d0-b12b-f82c49c26c12_SESS_812c317a-661f-4f64-916c-40d448feeca0_BOSC_9f368c08-fead-4763-876d-df309790e365_STL_','2021-08-19 22:39:13','2019-12-05 20:38:54','174c5596-176d-11ea-947d-226cec7cb58a.stl','2021-08-20 00:39:13','SYNCED','174c5596-176d-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 224.1.1.1\",\"modelMatrix\":\"-0.682,0.717259,-0.142885,0,-0.731353,-0.668857,0.133243,0,1.15581e-8,0.195371,0.980729,0,-0.820476,21.5265,-15.7267,1\",\"title\":\"MANDIBULE STL\"}'),(2,'174de66f-ea07-4db5-9240-d47076c31a17','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/174de66f-ea07-4db5-9240-d47076c31a17.png','SNAPS','PATIENT_c996ca5a-306f-4ae9-bff1-2fa7858ed7c7_ACT_578179ad-75f5-445b-8ec5-3dcb290e68be_SESS_9bac6ebc-14cd-481c-8558-16da99cfae1f_TOSC_c2138c47-4b14-4ca2-95b7-3c5b6d7bdb47_SNAPS_','2020-12-16 11:09:17','2020-01-22 15:12:42','174de66f-ea07-4db5-9240-d47076c31a17.png','2020-12-16 12:09:17','SYNCED','174de66f-ea07-4db5-9240-d47076c31a17',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'175d7b8a-ff60-4f78-a0e4-180a06e7f32b','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/175d7b8a-ff60-4f78-a0e4-180a06e7f32b.stl','STL','PATIENT_9a7fb011-3358-4d3c-a11d-cb262db47e63_ACT_c67535d0-06e7-4ed6-baf0-b01f41a8676e_SESS_8c42e51d-b2b2-43c8-a92d-1352af5ff425_BOSC_21d4b3c6-2c5d-49b4-95c9-a445ada7959e_STL_','2022-03-04 13:40:19','2019-07-09 10:18:36','175d7b8a-ff60-4f78-a0e4-180a06e7f32b.stl','2022-03-04 14:40:19','SYNCED','175d7b8a-ff60-4f78-a0e4-180a06e7f32b',0,'2022-03-04 14:40:19','','','{\"displayTitle\":\"MANDIBULE 11.1.1.1.1\",\"modelMatrix\":\"-0.903569,-0.42625,0.0432899,0,0.428442,-0.898945,0.0912968,0,3.20028e-11,0.10104,0.994882,0,15.5796,27.7192,-19.5979,1\",\"title\":\"MANDIBULE STL\"}'),(2,'1771d15e-a7b8-4382-b03b-63a3978fe1c1','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1771d15e-a7b8-4382-b03b-63a3978fe1c1.png','SNAPS','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_578179ad-75f5-445b-8ec5-3dcb290e68be_SESS_9bac6ebc-14cd-481c-8558-16da99cfae1f_BOSC_3652bd26-621e-4c86-aefb-5b0aad9f459f_SNAPS_','2020-12-16 11:09:17','2020-01-22 15:15:53','1771d15e-a7b8-4382-b03b-63a3978fe1c1.png','2020-12-16 12:09:17','SYNCED','1771d15e-a7b8-4382-b03b-63a3978fe1c1',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'17ab92ae-498e-4c6f-a89c-3c2b323c8cb3','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/17ab92ae-498e-4c6f-a89c-3c2b323c8cb3.ply','PLY','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_BOSC_5da0ad8e-75b1-46b8-8740-0c2d9c83df29_PLY_','2021-12-30 18:03:47','2019-11-14 13:47:19','17ab92ae-498e-4c6f-a89c-3c2b323c8cb3.ply','2021-12-30 19:03:47','SYNCED','17ab92ae-498e-4c6f-a89c-3c2b323c8cb3',0,NULL,'','','{\"displayTitle\":\"Mandibola 0\",\"modelMatrix\":\"-0.812386,0.573179,-0.107209,0,-0.583119,-0.798538,0.149361,0,-9.77095e-9,0.183855,0.982953,0,0.216935,20.1659,-23.7841,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'17bebae0-548c-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/17bebae0-548c-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_67d9d234-2142-4598-b3d5-a5de2a68f903_ACT_27ae8f9e-e404-4641-96b6-16080a35d897_SESS_a45e6721-1111-4d9d-be19-696dc58dd237_TOSC_175c6391-3062-48ce-ac7b-db50ef63c54a_SNAPS_','2020-12-16 10:53:39','2020-02-21 10:19:25','17bebae0-548c-11ea-947d-226cec7cb58a.png','2020-12-16 11:53:39','SYNCED','17bebae0-548c-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'17c0ab34-548c-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/17c0ab34-548c-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_27ae8f9e-e404-4641-96b6-16080a35d897_SESS_a45e6721-1111-4d9d-be19-696dc58dd237_BOSC_14aa360f-27d5-44c0-a74d-5cfc22305f5f_PLY_','2020-12-16 10:53:39','2020-02-21 10:22:24','17c0ab34-548c-11ea-947d-226cec7cb58a.ply','2020-12-16 11:53:39','SYNCED','17c0ab34-548c-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"modelMatrix\":\"-0.924284,0.373812,-0.0772226,0,-0.381705,-0.905171,0.186991,0,-4.79535e-9,0.202309,0.979322,0,-4.0784,21.357,-16.501,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'17c24d17-548c-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/17c24d17-548c-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_27ae8f9e-e404-4641-96b6-16080a35d897_SESS_a45e6721-1111-4d9d-be19-696dc58dd237_BOSC_14aa360f-27d5-44c0-a74d-5cfc22305f5f_SNAPS_','2020-12-16 10:53:39','2020-02-21 10:22:24','17c24d17-548c-11ea-947d-226cec7cb58a.png','2020-12-16 11:53:39','SYNCED','17c24d17-548c-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'17c3dbc5-548c-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/17c3dbc5-548c-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_67d9d234-2142-4598-b3d5-a5de2a68f903_ACT_27ae8f9e-e404-4641-96b6-16080a35d897_SESS_a45e6721-1111-4d9d-be19-696dc58dd237_TOSC_175c6391-3062-48ce-ac7b-db50ef63c54a_PLY_','2020-12-16 10:53:39','2020-02-21 10:19:25','17c3dbc5-548c-11ea-947d-226cec7cb58a.ply','2020-12-16 11:53:39','SYNCED','17c3dbc5-548c-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"modelMatrix\":\"0.871838,-0.440819,0.213486,0,0.489794,0.784664,-0.380007,0,-2.52684e-9,0.435869,0.90001,0,7.33649,-31.4068,-18.3302,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'17c4f94d-06de-468b-b7f7-2353115753d3','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/17c4f94d-06de-468b-b7f7-2353115753d3.stl','STL','PATIENT_ae02cf00-1850-4620-987b-4d05333da3d4_ACT_1853f626-d6a7-4c48-9935-7386491435e0_SESS_cf856030-b309-41de-a1c5-1c50dd600256_BOSC_952b5039-ad74-4479-bc5d-1a36cc76fd35_STL_','2021-08-19 22:40:35','2019-11-22 14:24:34','17c4f94d-06de-468b-b7f7-2353115753d3.stl','2021-08-20 00:40:35','SYNCED','17c4f94d-06de-468b-b7f7-2353115753d3',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 209.1.1.1\",\"modelMatrix\":\"-0.999429,-0.0325136,0.00921107,0,0.0337932,-0.961586,0.272416,0,-2.84062e-10,0.272572,0.962135,0,-13.8579,13.7046,-28.7914,1\",\"title\":\"MANDIBULE STL\"}'),(2,'17d10a6c-8f3a-4715-8e24-a19fcfc94f4b','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/17d10a6c-8f3a-4715-8e24-a19fcfc94f4b.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_27ed9780-6a38-4d69-9839-e42c0698e136_SNAPS_','2020-12-16 11:09:18','2020-01-24 12:20:58','17d10a6c-8f3a-4715-8e24-a19fcfc94f4b.png','2020-12-16 12:09:18','SYNCED','17d10a6c-8f3a-4715-8e24-a19fcfc94f4b',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.7\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'17e8d45f-6ec1-42e5-80b4-1440902e654a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/17e8d45f-6ec1-42e5-80b4-1440902e654a.png','SNAPS','PATIENT_72f539f4-2d06-47fa-b0b8-1291879a4818_ACT_d55baca2-6f09-4446-a148-dcdcfcaf57d8_SESS_5efdc987-8bdd-454f-b282-82efcf807bae_TOSC_b058ab38-4b27-4b4e-a277-093aad8191e8_SNAPS_','2021-08-19 22:40:36','2019-11-26 16:30:11','17e8d45f-6ec1-42e5-80b4-1440902e654a.png','2021-08-20 00:40:36','SYNCED','17e8d45f-6ec1-42e5-80b4-1440902e654a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 86.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'180b285b-042f-418d-a8d7-1a9bd09d4279','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/180b285b-042f-418d-a8d7-1a9bd09d4279.png','SNAPS','PATIENT_8ea368ce-75b8-4f95-8ed4-5b043177ea67_ACT_ceb6fdac-e0d2-40da-9833-cb012e45acad_SESS_ab9f3547-51bc-44d6-bf5d-e237d3de0f6b_TOSC_131e92b1-8bba-4177-b1c9-24c2d7682d5d_SNAPS_','2021-12-30 18:03:47','2019-11-04 15:53:06','180b285b-042f-418d-a8d7-1a9bd09d4279.png','2021-12-30 19:03:47','SYNCED','180b285b-042f-418d-a8d7-1a9bd09d4279',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 200.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'18151f20-2835-4c98-9f9a-a0960ee17e97','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/18151f20-2835-4c98-9f9a-a0960ee17e97.stl','STL','PATIENT_79d89cb8-7533-4691-ae26-03fb32120e14_ACT_b7fb2f2e-15a1-423d-9ec6-5cd6b7c3b3df_SESS_71ea43ce-6134-4395-adb6-356a0a54fc0d_BOSC_9e97800a-23cd-4169-a16d-dfb593a68d22_STL_','2021-08-19 22:40:37','2019-12-05 21:20:59','18151f20-2835-4c98-9f9a-a0960ee17e97.stl','2021-08-20 00:40:37','SYNCED','18151f20-2835-4c98-9f9a-a0960ee17e97',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 224.2.1.1\",\"modelMatrix\":\"-0.999421,0.0331658,-0.00754209,0,-0.0340125,-0.974541,0.221616,0,4.18885e-10,0.221745,0.975105,0,-15.8483,17.6415,-16.2816,1\",\"title\":\"MANDIBULE STL\"}'),(2,'182b1f3b-2682-4ae7-876d-f08791d06db8','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/182b1f3b-2682-4ae7-876d-f08791d06db8.png','SNAPS','PATIENT_b1a4ca7b-ca89-4218-a968-a47276c5ddc3_ACT_ad32f770-bdfe-47dd-abbc-5d48ecbf032b_SESS_fc66416f-a9bd-46d6-aa19-0c4feba5b343_TOSC_0afe2c4c-ac0d-4aa2-ba34-c08029644967_SNAPS_','2020-12-23 09:09:13','2019-12-20 16:08:55','182b1f3b-2682-4ae7-876d-f08791d06db8.png','2020-12-23 10:09:13','SYNCED','182b1f3b-2682-4ae7-876d-f08791d06db8',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 20.1.267.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'182c94a2-6172-47c9-a75a-e263157aca62','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/182c94a2-6172-47c9-a75a-e263157aca62.png','SNAPS','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_c3ab5bf5-34d1-4fb2-a3de-612395babdd0_SESS_710babeb-f2de-4d71-aec7-5c3b80d72e3a_BOSC_1f313051-160f-43e2-8273-b09cbee68edb_SNAPS_','2020-12-16 11:09:19','2020-01-15 11:43:51','182c94a2-6172-47c9-a75a-e263157aca62.png','2020-12-16 12:09:19','SYNCED','182c94a2-6172-47c9-a75a-e263157aca62',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'18457f86-b232-4abf-8548-e0dc3bd1547f','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/18457f86-b232-4abf-8548-e0dc3bd1547f.png','SNAPS','PATIENT_67c10a45-b4ec-42ba-ae2c-900a195adb87_ACT_86b9837f-894c-450e-be34-50dce2fbdc92_SESS_11baa7ef-ca17-442b-a5da-1d859ce1c951_BOSC_cda8c336-ec40-4e26-8336-664a2f417b06_SNAPS_','2021-12-30 18:03:47','2019-10-14 11:15:29','18457f86-b232-4abf-8548-e0dc3bd1547f.png','2021-12-30 19:03:47','SYNCED','18457f86-b232-4abf-8548-e0dc3bd1547f',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.19.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'1847fa47-100e-4b3c-8edf-da1e9a4ee052','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1847fa47-100e-4b3c-8edf-da1e9a4ee052.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_aacc6ea0-f502-4843-8cde-bebaad7e420c_SESS_4c58d51a-4616-4536-9863-413285213a6c_BOSC_0c3e3053-457a-45e9-b4b3-47586f46b365_SNAPS_','2020-12-16 10:53:42','2020-03-12 15:00:45','1847fa47-100e-4b3c-8edf-da1e9a4ee052.png','2020-12-16 11:53:42','SYNCED','1847fa47-100e-4b3c-8edf-da1e9a4ee052',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'1856e711-f604-4c8a-8011-7ab8c336f0e9','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1856e711-f604-4c8a-8011-7ab8c336f0e9.png','SNAPS','PATIENT_9e511014-ee3d-4c26-b85c-165cdc724413_ACT_72a7d1b9-2ede-45a3-acff-faa1d1d55297_SESS_4265a271-0d5f-49aa-bb33-e95db5f72bd1_BOSC_aa2a8b5f-6a2d-48f4-9a7c-3ca072538fed_SNAPS_','2020-12-23 09:09:14','2019-12-20 14:10:31','1856e711-f604-4c8a-8011-7ab8c336f0e9.png','2020-12-23 10:09:14','SYNCED','1856e711-f604-4c8a-8011-7ab8c336f0e9',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 20.1.267.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'185befe3-64c2-4d67-a581-6803ef55b88d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/185befe3-64c2-4d67-a581-6803ef55b88d.stl','STL','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_TOSC_44516845-ca32-49c0-8577-f34223c31274_STL_','2021-12-30 18:03:48','2019-11-14 12:20:16','185befe3-64c2-4d67-a581-6803ef55b88d.stl','2021-12-30 19:03:48','SYNCED','185befe3-64c2-4d67-a581-6803ef55b88d',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 202.1.1.1\",\"modelMatrix\":\"0.716692,-0.650629,0.251068,0,0.69739,0.668636,-0.258016,0,-6.71938e-9,0.36001,0.932948,0,-0.173964,-31.8973,-16.6105,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'18635b0f-fe96-4cf1-9a8b-7f5237e2f86d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/18635b0f-fe96-4cf1-9a8b-7f5237e2f86d.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_2f24eb52-e901-408f-93dc-f1eb6282e395_SESS_026492db-4b27-4e60-b1d3-861d8999edd3_TOSC_1c7769d0-6d84-4b49-8def-a1b567c382d7_PLY_','2020-12-08 17:29:23','2020-06-17 16:12:26','18635b0f-fe96-4cf1-9a8b-7f5237e2f86d.ply','2020-12-08 18:29:23','SYNCED','18635b0f-fe96-4cf1-9a8b-7f5237e2f86d',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.56.1.2\",\"modelMatrix\":\"0.29483,-0.927828,0.228498,0,0.95555,0.286277,-0.0705019,0,5.96722e-9,0.239127,0.970988,0,-12.0344,-31.6873,-17.5478,1\",\"title\":\"Maxillaire PLY\"}'),(2,'186e6d47-fa88-4bad-97e4-e186185b13c2','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/186e6d47-fa88-4bad-97e4-e186185b13c2.ply','PLY','PATIENT_f4c14b8d-b0ca-40d3-abb6-3fe9e2c8a923_ACT_1f76a84b-d13a-4799-919d-0cab36bd86d7_SESS_bf26279d-db8e-482a-8d01-f5bb63af23ed_BOSC_2798f363-27e8-4f6f-b647-a5d46c25539a_PLY_','2022-03-04 13:40:27','2019-07-11 08:26:43','186e6d47-fa88-4bad-97e4-e186185b13c2.ply','2022-03-04 14:40:27','SYNCED','186e6d47-fa88-4bad-97e4-e186185b13c2',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 36.1.1.1\",\"modelMatrix\":\"-0.994778,0.100343,-0.0186752,0,-0.102066,-0.977984,0.182015,0,-1.17881e-9,0.182971,0.983118,0,-18.9633,21.761,-25.7861,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'18810788-105b-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/18810788-105b-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_fd694b3f-abde-4e46-91f7-7c62bfdcafa4_SESS_73a3f5b9-e905-4911-a163-2022e1de3380_TOSC_44cbd4cb-a9a9-4c8c-bdd9-4e8f95df41b8_PLY_','2021-08-19 22:40:39','2019-11-26 20:39:33','18810788-105b-11ea-947d-226cec7cb58a.ply','2021-08-20 00:40:39','SYNCED','18810788-105b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"modelMatrix\":\"0.570069,-0.783152,0.248383,0,0.821597,0.543394,-0.172342,0,-3.71288e-9,0.302318,0.953207,0,0.241964,-32.3161,-17.5042,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1882c5b2-105b-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1882c5b2-105b-11ea-947d-226cec7cb58a.stl','STL','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_fd694b3f-abde-4e46-91f7-7c62bfdcafa4_SESS_73a3f5b9-e905-4911-a163-2022e1de3380_TOSC_44cbd4cb-a9a9-4c8c-bdd9-4e8f95df41b8_STL_','2021-08-19 22:40:40','2019-11-26 20:39:33','1882c5b2-105b-11ea-947d-226cec7cb58a.stl','2021-08-20 00:40:40','SYNCED','1882c5b2-105b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"modelMatrix\":\"0.570069,-0.783152,0.248383,0,0.821597,0.543394,-0.172342,0,-3.71288e-9,0.302318,0.953207,0,0.241964,-32.3161,-17.5042,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'18843cab-105b-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/18843cab-105b-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_fd694b3f-abde-4e46-91f7-7c62bfdcafa4_SESS_73a3f5b9-e905-4911-a163-2022e1de3380_TOSC_44cbd4cb-a9a9-4c8c-bdd9-4e8f95df41b8_SNAPS_','2021-08-19 22:40:41','2019-11-26 20:39:33','18843cab-105b-11ea-947d-226cec7cb58a.png','2021-08-20 00:40:41','SYNCED','18843cab-105b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'18baec6e-f03a-43ad-9565-b57eb71d1742','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/18baec6e-f03a-43ad-9565-b57eb71d1742.stl','STL','PATIENT_141b5bee-a45d-43ca-bf39-68cd03bb2bae_ACT_e9445e1d-87d4-4f9d-b316-1a8110f09c69_SESS_c3698130-bfaf-4799-a95b-e35d183732fe_TOSC_43e518c1-e3c1-4e3f-95bf-f5896363bc70_STL_','2021-12-30 18:03:48','2019-11-04 15:29:57','18baec6e-f03a-43ad-9565-b57eb71d1742.stl','2021-12-30 19:03:48','SYNCED','18baec6e-f03a-43ad-9565-b57eb71d1742',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 198.1.1.1\",\"modelMatrix\":\"0.722827,-0.668847,0.173682,0,0.691029,0.699623,-0.181674,0,5.02671e-9,0.251339,0.967899,0,5.18494,-32.8368,-12.3825,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'18c173c4-cbc4-4d70-96ca-e4357ebcabb4','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/18c173c4-cbc4-4d70-96ca-e4357ebcabb4.ply','PLY','PATIENT_7b18c122-3f5d-47ba-9d26-8b0b39afc65b_ACT_1de8d155-51d1-439d-83c5-bcc82ae246c5_SESS_faf3617c-309f-4d4a-8eb2-57aea45f003d_BOSC_c33b9ce0-8a49-4aa0-826f-7e8cd8dfa478_PLY_','2021-02-16 16:38:26','2019-12-06 16:13:15','18c173c4-cbc4-4d70-96ca-e4357ebcabb4.ply','2021-02-16 17:38:26','SYNCED','18c173c4-cbc4-4d70-96ca-e4357ebcabb4',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 230.4.1.1\",\"modelMatrix\":\"-0.877858,0.465297,-0.113424,0,-0.478922,-0.852883,0.207905,0,-8.5835e-10,0.236832,0.971551,0,-5.1931,21.4956,-17.7739,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'18c9cba3-5a4c-41b5-bdf7-e776ecd9c30e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/18c9cba3-5a4c-41b5-bdf7-e776ecd9c30e.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_30aec79f-770c-4080-b132-a378fb911bbf_SESS_233a2543-12ec-47d1-8b2d-0a3e1a26ae24_TOSC_c118535b-fb4c-4107-afff-43c863866f58_SNAPS_','2020-12-16 10:53:44','2020-05-20 15:55:41','18c9cba3-5a4c-41b5-bdf7-e776ecd9c30e.png','2020-12-16 11:53:44','SYNCED','18c9cba3-5a4c-41b5-bdf7-e776ecd9c30e',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 216.1.6.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'18ca2a56-eadb-4398-805f-bdfc4c3245c6','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/18ca2a56-eadb-4398-805f-bdfc4c3245c6.png','SNAPS','PATIENT_990204e3-cf2f-4026-952f-1dddcf7ba877_ACT_7cc92ba2-1d5b-419e-a74a-49ee200bad42_SESS_2da8fcc1-66de-4b26-b59a-065327a30f5f_TOSC_0046b2b3-f361-4424-ad70-d7e0cda10542_SNAPS_','2022-02-01 11:47:51','2019-07-22 14:54:34','18ca2a56-eadb-4398-805f-bdfc4c3245c6.png','2022-02-01 12:47:51','SYNCED','18ca2a56-eadb-4398-805f-bdfc4c3245c6',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 56.1.1.2\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'18ca59c5-53e7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/18ca59c5-53e7-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_cb9616d0-c3bc-41ed-ab30-baa70dbbe3b3_SESS_86c5e257-01ac-4399-be7c-4e690369a043_BOSC_2e1fe8d1-e967-4177-8722-b9dc689536e3_PLY_','2020-12-16 10:53:44','2020-02-20 14:43:55','18ca59c5-53e7-11ea-947d-226cec7cb58a.ply','2020-12-16 11:53:44','SYNCED','18ca59c5-53e7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"modelMatrix\":\"-0.962569,0.248909,-0.107264,0,-0.271038,-0.883981,0.38094,0,-6.21655e-9,0.395754,0.918357,0,-14.5157,16.5556,-18.8312,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'18cbd792-722c-4f24-9d6d-a42e4bcb74e7','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/18cbd792-722c-4f24-9d6d-a42e4bcb74e7.png','SNAPS','PATIENT_4887c403-6684-431d-9efd-4230d74f9f6e_ACT_b67be1ff-ec7d-4035-9281-b8e4b218da86_SESS_1c9989e2-d42d-4cab-80e3-b783c63d8a22_TOSC_b3ad7e7c-a51b-4b65-870b-4ffabed1c10b_SNAPS_','2021-12-30 18:03:49','2019-10-10 14:20:30','18cbd792-722c-4f24-9d6d-a42e4bcb74e7.png','2021-12-30 19:03:49','SYNCED','18cbd792-722c-4f24-9d6d-a42e4bcb74e7',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 184.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'18cd3dca-53e7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/18cd3dca-53e7-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_421ab29a-a729-4e06-abf8-da1e12246d0e_ACT_cb9616d0-c3bc-41ed-ab30-baa70dbbe3b3_SESS_86c5e257-01ac-4399-be7c-4e690369a043_TOSC_c8fc0a06-9400-4153-98c0-a7c24823336a_PLY_','2020-12-16 10:53:45','2020-02-20 14:39:35','18cd3dca-53e7-11ea-947d-226cec7cb58a.ply','2020-12-16 11:53:45','SYNCED','18cd3dca-53e7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"modelMatrix\":\"0.811643,-0.546345,0.206745,0,0.584154,0.759109,-0.287258,0,-9.37277e-10,0.353922,0.935275,0,3.25617,-34.7874,-16.7878,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'18ce0950-14f3-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/18ce0950-14f3-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_d2ff948f-69d4-46e9-9ef1-704c8bba4325_ACT_2c576716-4606-4205-9348-747d0fefdc69_SESS_55134a44-2c28-45a8-a968-309f20beea5f_BOSC_6213c25f-b2c9-4dd9-a965-e89a30fc3f2c_SNAPS_','2021-08-19 22:40:44','2019-12-02 17:00:59','18ce0950-14f3-11ea-947d-226cec7cb58a.png','2021-08-20 00:40:44','SYNCED','18ce0950-14f3-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 221.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'18cec6d0-53e7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/18cec6d0-53e7-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_421ab29a-a729-4e06-abf8-da1e12246d0e_ACT_cb9616d0-c3bc-41ed-ab30-baa70dbbe3b3_SESS_86c5e257-01ac-4399-be7c-4e690369a043_TOSC_c8fc0a06-9400-4153-98c0-a7c24823336a_SNAPS_','2020-12-16 10:53:45','2020-02-20 14:39:35','18cec6d0-53e7-11ea-947d-226cec7cb58a.png','2020-12-16 11:53:45','SYNCED','18cec6d0-53e7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'18cfb060-14f3-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/18cfb060-14f3-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_d2ff948f-69d4-46e9-9ef1-704c8bba4325_ACT_2c576716-4606-4205-9348-747d0fefdc69_SESS_55134a44-2c28-45a8-a968-309f20beea5f_TOSC_60a4ab65-4466-4aa5-9e70-a2961463fa7e_SNAPS_','2021-08-19 22:40:44','2019-12-02 16:57:33','18cfb060-14f3-11ea-947d-226cec7cb58a.png','2021-08-20 00:40:44','SYNCED','18cfb060-14f3-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 221.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'18d07b94-53e7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/18d07b94-53e7-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_cb9616d0-c3bc-41ed-ab30-baa70dbbe3b3_SESS_86c5e257-01ac-4399-be7c-4e690369a043_BOSC_2e1fe8d1-e967-4177-8722-b9dc689536e3_SNAPS_','2020-12-16 10:53:46','2020-02-20 14:43:55','18d07b94-53e7-11ea-947d-226cec7cb58a.png','2020-12-16 11:53:46','SYNCED','18d07b94-53e7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'18d13a17-14f3-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/18d13a17-14f3-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_d2ff948f-69d4-46e9-9ef1-704c8bba4325_ACT_2c576716-4606-4205-9348-747d0fefdc69_SESS_55134a44-2c28-45a8-a968-309f20beea5f_BOSC_6213c25f-b2c9-4dd9-a965-e89a30fc3f2c_PLY_','2021-08-19 22:40:45','2019-12-02 17:00:59','18d13a17-14f3-11ea-947d-226cec7cb58a.ply','2021-08-20 00:40:45','SYNCED','18d13a17-14f3-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 221.1.1.1\",\"modelMatrix\":\"-0.862969,0.490477,-0.121315,0,-0.505258,-0.837724,0.207203,0,-7.32673e-10,0.240105,0.970747,0,-0.267394,18.7316,-17.0245,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'18d2e1eb-14f3-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/18d2e1eb-14f3-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_d2ff948f-69d4-46e9-9ef1-704c8bba4325_ACT_2c576716-4606-4205-9348-747d0fefdc69_SESS_55134a44-2c28-45a8-a968-309f20beea5f_TOSC_60a4ab65-4466-4aa5-9e70-a2961463fa7e_PLY_','2021-08-19 22:40:46','2019-12-02 16:57:33','18d2e1eb-14f3-11ea-947d-226cec7cb58a.ply','2021-08-20 00:40:46','SYNCED','18d2e1eb-14f3-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 221.1.1.1\",\"modelMatrix\":\"0.857822,-0.452776,0.243176,0,0.513946,0.755723,-0.405883,0,-1.97092e-8,0.473155,0.880979,0,7.85563,-32.4043,-20.047,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'18d447d1-14f3-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/18d447d1-14f3-11ea-947d-226cec7cb58a.stl','STL','PATIENT_d2ff948f-69d4-46e9-9ef1-704c8bba4325_ACT_2c576716-4606-4205-9348-747d0fefdc69_SESS_55134a44-2c28-45a8-a968-309f20beea5f_BOSC_6213c25f-b2c9-4dd9-a965-e89a30fc3f2c_STL_','2021-08-19 22:40:46','2019-12-02 17:00:59','18d447d1-14f3-11ea-947d-226cec7cb58a.stl','2021-08-20 00:40:46','SYNCED','18d447d1-14f3-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 221.1.1.1\",\"modelMatrix\":\"-0.862969,0.490477,-0.121315,0,-0.505258,-0.837724,0.207203,0,-7.32673e-10,0.240105,0.970747,0,-0.267394,18.7316,-17.0245,1\",\"title\":\"MANDIBULE STL\"}'),(2,'18d5eeee-14f3-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/18d5eeee-14f3-11ea-947d-226cec7cb58a.stl','STL','PATIENT_d2ff948f-69d4-46e9-9ef1-704c8bba4325_ACT_2c576716-4606-4205-9348-747d0fefdc69_SESS_55134a44-2c28-45a8-a968-309f20beea5f_TOSC_60a4ab65-4466-4aa5-9e70-a2961463fa7e_STL_','2021-08-19 22:40:47','2019-12-02 16:57:33','18d5eeee-14f3-11ea-947d-226cec7cb58a.stl','2021-08-20 00:40:47','SYNCED','18d5eeee-14f3-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 221.1.1.1\",\"modelMatrix\":\"0.857822,-0.452776,0.243176,0,0.513946,0.755723,-0.405883,0,-1.97092e-8,0.473155,0.880979,0,7.85563,-32.4043,-20.047,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'18e81b3c-8b0a-47e3-b555-f7868abbcf95','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/18e81b3c-8b0a-47e3-b555-f7868abbcf95.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_e67c44fa-320d-4cec-929c-0fac66b8a7ca_SESS_584f4de7-5dda-471a-8bd1-a202eb080ef8_TOSC_2ba7bd87-daec-4f84-8049-a1f5d84c1280_SNAPS_','2020-12-16 10:53:47','2020-02-12 15:10:21','18e81b3c-8b0a-47e3-b555-f7868abbcf95.png','2020-12-16 11:53:47','SYNCED','18e81b3c-8b0a-47e3-b555-f7868abbcf95',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.3\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'18f64cb9-a8a2-4e47-827f-4f82381143f5','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/18f64cb9-a8a2-4e47-827f-4f82381143f5.png','SNAPS','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_BOSC_5da0ad8e-75b1-46b8-8740-0c2d9c83df29_SNAPS_','2021-12-30 18:03:49','2019-11-14 13:47:19','18f64cb9-a8a2-4e47-827f-4f82381143f5.png','2021-12-30 19:03:49','SYNCED','18f64cb9-a8a2-4e47-827f-4f82381143f5',0,NULL,'','','{\"displayTitle\":\"Mandibola 0\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'19041197-58c1-41f0-9756-0dff6851739d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/19041197-58c1-41f0-9756-0dff6851739d.ply','PLY','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_d2f7b7b4-32ff-450c-90d1-a5f55fa4b594_SESS_7a7679ff-68b2-4367-b7ea-cd532163d818_BOSC_9292d259-554f-400e-b12c-c0f437df6c89_PLY_','2020-12-16 11:09:23','2020-01-15 15:14:14','19041197-58c1-41f0-9756-0dff6851739d.ply','2020-12-16 12:09:23','SYNCED','19041197-58c1-41f0-9756-0dff6851739d',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.1.1.1.1\",\"modelMatrix\":\"-0.996155,-0.0833079,0.027114,0,0.0876092,-0.947247,0.308298,0,4.40276e-10,0.309488,0.950903,0,-14.2876,10.5416,-19.3735,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'190a858b-7b5e-4e90-b1f4-0c2f5bbdc088','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/190a858b-7b5e-4e90-b1f4-0c2f5bbdc088.stl','STL','PATIENT_a7d38c96-2582-4988-ac47-4f044afb0023_ACT_499f1edc-5e16-4f5d-8a5a-015cd35de134_SESS_27c35a26-c5ee-4f51-a0fb-d38e49bec344_TOSC_f6a6f8a2-d81b-4ee5-98be-0d5ce05ec111_STL_','2022-02-01 11:47:51','2019-09-18 11:15:05','190a858b-7b5e-4e90-b1f4-0c2f5bbdc088.stl','2022-02-01 12:47:51','SYNCED','190a858b-7b5e-4e90-b1f4-0c2f5bbdc088',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 153.1.1.1\",\"modelMatrix\":\"0.866136,-0.439569,0.237878,0,0.499807,0.761748,-0.412229,0,-1.75349e-8,0.47594,0.879478,0,9.59131,-37.1999,-25.3857,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'191ddc19-d922-4366-b913-95e833924db6','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/191ddc19-d922-4366-b913-95e833924db6.ply','PLY','PATIENT_60a42385-b044-450b-bc5e-7ed0dacffc40_ACT_9bfd0fad-9323-4ecc-aa3c-4e92e0d8411b_SESS_d64c3246-d837-498e-a781-c83914964d85_TOSC_2f71357d-2c07-4768-abe9-0a05a5480267_PLY_','2020-12-23 09:09:19','2019-12-20 14:20:53','191ddc19-d922-4366-b913-95e833924db6.ply','2020-12-23 10:09:19','SYNCED','191ddc19-d922-4366-b913-95e833924db6',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"modelMatrix\":\"0.296555,-0.92843,0.22377,0,0.955016,0.288299,-0.0694857,0,-5.7054e-9,0.23431,0.972162,0,-13.4015,-19.363,-24.3267,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1922bd94-9e1d-4e63-bee4-d09173f60cbd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1922bd94-9e1d-4e63-bee4-d09173f60cbd.png','SNAPS','PATIENT_147188ff-abc8-4e88-9331-414c43730737_ACT_65ecad27-2da0-49b3-a499-5bc0e64768d8_SESS_d835cb18-6077-448e-83c2-8a9a1eece218_BOSC_75c0fa31-b7a3-481b-a561-d3072b000da1_SNAPS_','2022-02-17 14:31:11','2019-08-23 15:21:17','1922bd94-9e1d-4e63-bee4-d09173f60cbd.png','2022-02-17 15:31:11','SYNCED','1922bd94-9e1d-4e63-bee4-d09173f60cbd',0,'2022-02-17 15:31:11','','','{\"displayTitle\":\"MANDIBULE 129.8.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'192fa2eb-f9fe-42a2-9258-927869c56c63','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/192fa2eb-f9fe-42a2-9258-927869c56c63.ply','PLY','PATIENT_f378056d-f37c-4a09-952d-c4874c6a7590_ACT_7b843882-d3fe-43f2-8383-c119292fa05e_SESS_d860ca72-5a30-47ca-89d8-76b73a3fde3c_TOSC_7f7da7d5-4b2f-4c65-b299-50e97221fa0f_PLY_','2022-03-04 13:40:27','2019-07-08 16:36:30','192fa2eb-f9fe-42a2-9258-927869c56c63.ply','2022-03-04 14:40:27','SYNCED','192fa2eb-f9fe-42a2-9258-927869c56c63',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 8.1.1.1\",\"modelMatrix\":\"0.969108,-0.241002,0.0524166,0,0.246636,0.946969,-0.205961,0,-2.44706e-9,0.212526,0.977155,0,-27.8829,-17.5743,-19.0438,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1933e3df-1e77-43f6-a354-1e07fdde7a26','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1933e3df-1e77-43f6-a354-1e07fdde7a26.png','SNAPS','PATIENT_3ac5152b-a005-4ed5-95d1-82a7cc8d4bd5_ACT_12eb8c65-9ba0-4f86-b5ba-ca70f1b14d8a_SESS_bbc3949b-10a6-410f-8ece-f50bba0a5585_TOSC_384d750d-857a-4b15-95c1-9a0cc1c0f603_SNAPS_','2022-02-01 11:47:52','2019-08-05 09:18:40','1933e3df-1e77-43f6-a354-1e07fdde7a26.png','2022-02-01 12:47:52','SYNCED','1933e3df-1e77-43f6-a354-1e07fdde7a26',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 124.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'193a9fe0-6df5-46fc-9764-2376a9831bb5','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/193a9fe0-6df5-46fc-9764-2376a9831bb5.png','SNAPS','PATIENT_a730394c-024c-4469-9597-1dc64fff623b_ACT_d06f5848-7983-4029-b7d5-5fca4dc843dc_SESS_f41ed3e2-fec4-48ed-a7a0-8a30ff371794_TOSC_14100e12-78db-459f-9a41-8182a218f61c_SNAPS_','2020-12-16 11:09:24','2020-01-31 11:34:16','193a9fe0-6df5-46fc-9764-2376a9831bb5.png','2020-12-16 12:09:24','SYNCED','193a9fe0-6df5-46fc-9764-2376a9831bb5',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 25.1.1.3.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'19562b11-2f1e-424c-aa9b-8c0009f3b322','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/19562b11-2f1e-424c-aa9b-8c0009f3b322.ply','PLY','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_bbf236c3-6316-4d2c-b56d-7c75acf71f72_SESS_0951b2a2-2dcd-4a26-b6b4-d3858e9b55b6_BOSC_5b52c631-0d85-40ea-ae71-031ed64cd308_PLY_','2020-12-16 11:09:24','2020-01-15 11:31:06','19562b11-2f1e-424c-aa9b-8c0009f3b322.ply','2020-12-16 12:09:24','SYNCED','19562b11-2f1e-424c-aa9b-8c0009f3b322',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.1.1.1.1\",\"modelMatrix\":\"-0.956831,0.286092,-0.0512438,0,-0.290645,-0.941842,0.168699,0,-9.05067e-11,0.17631,0.984335,0,-10.996,22.1573,-17.0708,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'19670df9-ea7b-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/19670df9-ea7b-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_71aee62b-1256-4553-9a40-c09863d2d28c_ACT_d5685dd3-41af-48bb-a514-b7d0fab78352_SESS_67c163cf-861a-424f-9e1c-42ca714a5b71_BOSC_e17f5369-82b3-4fbd-a785-adeec0f5d9c2_PLY_','2021-12-30 18:03:50','2019-10-09 11:56:25','19670df9-ea7b-11e9-947d-226cec7cb58a.ply','2021-12-30 19:03:50','SYNCED','19670df9-ea7b-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 182.1.1.1\",\"modelMatrix\":\"-0.526139,0.845759,-0.0887085,0,-0.850398,-0.523269,0.0548837,0,7.61713e-10,0.104314,0.994544,0,7.08089,17.3323,-20.9879,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'19682467-ea7b-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/19682467-ea7b-11e9-947d-226cec7cb58a.stl','STL','PATIENT_71aee62b-1256-4553-9a40-c09863d2d28c_ACT_d5685dd3-41af-48bb-a514-b7d0fab78352_SESS_67c163cf-861a-424f-9e1c-42ca714a5b71_TOSC_455fef41-ecaf-404d-9025-f23db6030f93_STL_','2021-12-30 18:03:51','2019-10-09 11:52:00','19682467-ea7b-11e9-947d-226cec7cb58a.stl','2021-12-30 19:03:51','SYNCED','19682467-ea7b-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 182.1.1.1\",\"modelMatrix\":\"0.903502,-0.385979,0.186291,0,0.428584,0.813686,-0.392723,0,-2.125e-9,0.434667,0.900591,0,11.1213,-29.1167,-17.5317,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'196f6190-ea7b-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/196f6190-ea7b-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_71aee62b-1256-4553-9a40-c09863d2d28c_ACT_d5685dd3-41af-48bb-a514-b7d0fab78352_SESS_67c163cf-861a-424f-9e1c-42ca714a5b71_TOSC_455fef41-ecaf-404d-9025-f23db6030f93_PLY_','2021-12-30 18:03:51','2019-10-09 11:52:00','196f6190-ea7b-11e9-947d-226cec7cb58a.ply','2021-12-30 19:03:51','SYNCED','196f6190-ea7b-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 182.1.1.1\",\"modelMatrix\":\"0.903502,-0.385979,0.186291,0,0.428584,0.813686,-0.392723,0,-2.125e-9,0.434667,0.900591,0,11.1213,-29.1167,-17.5317,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1970aed9-ea7b-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1970aed9-ea7b-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_71aee62b-1256-4553-9a40-c09863d2d28c_ACT_d5685dd3-41af-48bb-a514-b7d0fab78352_SESS_67c163cf-861a-424f-9e1c-42ca714a5b71_TOSC_455fef41-ecaf-404d-9025-f23db6030f93_SNAPS_','2021-12-30 18:03:52','2019-10-09 11:52:00','1970aed9-ea7b-11e9-947d-226cec7cb58a.png','2021-12-30 19:03:52','SYNCED','1970aed9-ea7b-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 182.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'1971f636-ea7b-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1971f636-ea7b-11e9-947d-226cec7cb58a.stl','STL','PATIENT_71aee62b-1256-4553-9a40-c09863d2d28c_ACT_d5685dd3-41af-48bb-a514-b7d0fab78352_SESS_67c163cf-861a-424f-9e1c-42ca714a5b71_BOSC_e17f5369-82b3-4fbd-a785-adeec0f5d9c2_STL_','2021-12-30 18:03:52','2019-10-09 11:56:25','1971f636-ea7b-11e9-947d-226cec7cb58a.stl','2021-12-30 19:03:52','SYNCED','1971f636-ea7b-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 182.1.1.1\",\"modelMatrix\":\"-0.526139,0.845759,-0.0887085,0,-0.850398,-0.523269,0.0548837,0,7.61713e-10,0.104314,0.994544,0,7.08089,17.3323,-20.9879,1\",\"title\":\"MANDIBULE STL\"}'),(2,'1973697c-ea7b-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1973697c-ea7b-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_71aee62b-1256-4553-9a40-c09863d2d28c_ACT_d5685dd3-41af-48bb-a514-b7d0fab78352_SESS_67c163cf-861a-424f-9e1c-42ca714a5b71_BOSC_e17f5369-82b3-4fbd-a785-adeec0f5d9c2_SNAPS_','2021-12-30 18:03:52','2019-10-09 11:56:25','1973697c-ea7b-11e9-947d-226cec7cb58a.png','2021-12-30 19:03:52','SYNCED','1973697c-ea7b-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 182.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'1974ce93-dbba-43c4-ba09-452a902869ad','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1974ce93-dbba-43c4-ba09-452a902869ad.ply','PLY','PATIENT_961e5084-1756-4d47-8e90-a6b717094efe_ACT_e9340f44-a13c-41df-99f2-1472c63e5f38_SESS_6cd9c521-7e64-409c-93d7-2039dee96ec0_BOSC_4f8722e2-7d5c-4b81-b12b-385283da44bd_PLY_','2020-12-16 11:09:26','2020-01-21 13:54:56','1974ce93-dbba-43c4-ba09-452a902869ad.ply','2020-12-16 12:09:26','SYNCED','1974ce93-dbba-43c4-ba09-452a902869ad',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 199.1.3.1.2\",\"modelMatrix\":\"-0.984177,0.170195,-0.0492909,0,-0.177189,-0.94533,0.273781,0,1.57291e-9,0.278183,0.960528,0,-12.3712,17.1387,-15.661,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'198b356e-4f2f-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/198b356e-4f2f-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_d38ccefd-8869-4ee0-9df2-5010370a6f3d_ACT_69b582dc-e8c3-40c4-af22-028179e2e5e4_SESS_94522aeb-e112-446f-91c6-efe02abf7ed2_TOSC_90e2b1be-a885-4ece-8667-b0a93b199729_PLY_','2020-12-16 10:53:51','2020-02-14 14:28:21','198b356e-4f2f-11ea-947d-226cec7cb58a.ply','2020-12-16 11:53:51','SYNCED','198b356e-4f2f-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"modelMatrix\":\"0.812998,-0.53643,0.226446,0,0.582267,0.748997,-0.316178,0,-1.1012e-8,0.388904,0.921278,0,3.30484,-34.3477,-20.3618,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'198d5b1a-4f2f-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/198d5b1a-4f2f-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_d38ccefd-8869-4ee0-9df2-5010370a6f3d_ACT_69b582dc-e8c3-40c4-af22-028179e2e5e4_SESS_94522aeb-e112-446f-91c6-efe02abf7ed2_TOSC_90e2b1be-a885-4ece-8667-b0a93b199729_SNAPS_','2020-12-16 10:53:51','2020-02-14 14:28:21','198d5b1a-4f2f-11ea-947d-226cec7cb58a.png','2020-12-16 11:53:51','SYNCED','198d5b1a-4f2f-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'198f4f62-4f2f-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/198f4f62-4f2f-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_69b582dc-e8c3-40c4-af22-028179e2e5e4_SESS_94522aeb-e112-446f-91c6-efe02abf7ed2_BOSC_ae145f08-178e-49a7-af78-2a9ae740fad4_SNAPS_','2020-12-16 10:53:51','2020-02-14 14:36:30','198f4f62-4f2f-11ea-947d-226cec7cb58a.png','2020-12-16 11:53:51','SYNCED','198f4f62-4f2f-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'1991e8f1-4f2f-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1991e8f1-4f2f-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_69b582dc-e8c3-40c4-af22-028179e2e5e4_SESS_94522aeb-e112-446f-91c6-efe02abf7ed2_BOSC_ae145f08-178e-49a7-af78-2a9ae740fad4_PLY_','2020-12-16 10:53:52','2020-02-14 14:36:30','1991e8f1-4f2f-11ea-947d-226cec7cb58a.ply','2020-12-16 11:53:52','SYNCED','1991e8f1-4f2f-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"modelMatrix\":\"-0.893191,0.446261,-0.0553283,0,-0.449678,-0.886404,0.109898,0,2.7254e-9,0.12304,0.992402,0,-3.86756,16.4952,-21.3481,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'19a7258d-0891-49e0-bdbc-5563e23b0c94','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/19a7258d-0891-49e0-bdbc-5563e23b0c94.ply','PLY','PATIENT_0ef458f8-7ce1-4e6d-80cc-c7824bf4274d_ACT_893c1d07-40ba-45a9-be11-2f0f2121928a_SESS_e8aa915c-4542-47ba-a235-dfa7285b7eaa_TOSC_19e97372-3440-46f0-b039-4a88492876ef_PLY_','2020-12-16 10:53:52','2020-02-18 11:07:54','19a7258d-0891-49e0-bdbc-5563e23b0c94.ply','2020-12-16 11:53:52','SYNCED','19a7258d-0891-49e0-bdbc-5563e23b0c94',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 95.1.1.1.1\",\"modelMatrix\":\"0.709207,-0.662848,0.240121,0,0.705,0.666803,-0.241554,0,-8.54733e-9,0.340597,0.940209,0,4.16777,-37.677,-15.5787,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'19b110d8-6255-40d7-bcf9-a555bd1d9aa7','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/19b110d8-6255-40d7-bcf9-a555bd1d9aa7.stl','STL','PATIENT_fa356cc1-2a61-41a9-97f5-eee3850a926c_ACT_94c1619e-6096-4464-837b-4b14ca5da156_SESS_fd9c0fc4-1c81-4aed-a4e0-992153cc0fef_TOSC_f1822fc6-53a7-42bd-a3ba-3958d3797998_STL_','2022-02-01 11:47:52','2019-07-15 09:39:01','19b110d8-6255-40d7-bcf9-a555bd1d9aa7.stl','2022-02-01 12:47:52','SYNCED','19b110d8-6255-40d7-bcf9-a555bd1d9aa7',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 59.1.1.1\",\"modelMatrix\":\"0.791699,-0.560608,0.242757,0,0.610911,0.72651,-0.314597,0,2.24778e-9,0.39737,0.917659,0,4.98661,-39.7673,-15.9582,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'19b1e459-3af8-499c-ac32-c44cca740847','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/19b1e459-3af8-499c-ac32-c44cca740847.ply','PLY','PATIENT_b8905467-2e71-4779-bf51-94e66a47e3d5_ACT_6eae5d88-d0ca-4468-9daa-5a0f413d86b9_SESS_b15b868d-7cb1-47f7-ab0a-8d9fec9d4f75_TOSC_d0105e2f-8fc5-4727-a781-64e95f4045a1_PLY_','2020-12-16 10:53:52','2020-01-31 16:30:16','19b1e459-3af8-499c-ac32-c44cca740847.ply','2020-12-16 11:53:52','SYNCED','19b1e459-3af8-499c-ac32-c44cca740847',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"modelMatrix\":\"0.829413,-0.505608,0.237562,0,0.558637,0.75068,-0.35271,0,1.29213e-8,0.425253,0.905074,0,8.20583,-34.0391,-14.6529,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'19cfb882-d70d-4fb2-8a92-25bb8bbc3edd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/19cfb882-d70d-4fb2-8a92-25bb8bbc3edd.stl','STL','PATIENT_e51cf9a2-03cb-4e48-928a-2755186e1db6_ACT_000dfdf1-07e2-4cb4-9351-56d36d0f2b2f_SESS_bcaa9cd4-a73e-45a0-aa14-14571985bf99_BOSC_45a59966-4c7e-47ea-b045-6b04d1ecd1ad_STL_','2022-02-01 11:47:52','2019-07-19 16:16:54','19cfb882-d70d-4fb2-8a92-25bb8bbc3edd.stl','2022-02-01 12:47:52','SYNCED','19cfb882-d70d-4fb2-8a92-25bb8bbc3edd',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 102.1.1.1\",\"modelMatrix\":\"-0.983759,0.173515,-0.045952,0,-0.179497,-0.950975,0.251847,0,-9.75582e-10,0.256005,0.966676,0,-12.4899,15.7274,-23.3581,1\",\"title\":\"MANDIBULE STL\"}'),(2,'19d966ca-41a1-4519-b076-c31cb8211bdd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/19d966ca-41a1-4519-b076-c31cb8211bdd.png','SNAPS','PATIENT_4ec057eb-d132-43fb-96fb-11348abd205b_ACT_bec7cb5f-4dd0-4601-aa64-0a558c6e8b78_SESS_b153a28c-3493-496f-bb70-e96ca7cf7e78_TOSC_5774d083-5529-4abf-bbc4-30e8e59bcab2_SNAPS_','2021-12-30 18:03:52','2019-10-02 15:23:05','19d966ca-41a1-4519-b076-c31cb8211bdd.png','2021-12-30 19:03:52','SYNCED','19d966ca-41a1-4519-b076-c31cb8211bdd',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 174.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'19def09d-e08a-42b0-903f-dcd13c33cbae','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/19def09d-e08a-42b0-903f-dcd13c33cbae.png','SNAPS','PATIENT_d81819be-bc30-4092-b5e9-498e0cbb7c78_ACT_e2efb8df-4ec9-4c9d-98df-c9d1978d79fb_SESS_1d7bc7d7-a77e-46e6-aaa2-768afa5219c9_BOSC_ed4417fc-f174-43ac-be0d-27c541079eb3_SNAPS_','2022-02-01 11:47:52','2019-07-15 16:35:44','19def09d-e08a-42b0-903f-dcd13c33cbae.png','2022-02-01 12:47:52','SYNCED','19def09d-e08a-42b0-903f-dcd13c33cbae',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 71.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'19e9b001-abe3-45f0-b46e-0d1926c9e963','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/19e9b001-abe3-45f0-b46e-0d1926c9e963.png','SNAPS','PATIENT_ccd3e8fe-0427-46ac-9a78-4982bf0a05fe_ACT_ee7a5012-1ec5-43b8-82bd-f42cb859f757_SESS_0b92af6d-d56a-4d56-941a-44824081e629_TOSC_e4fa63d0-f2e4-45d5-9661-4e5df10c0ab7_SNAPS_','2020-12-23 09:09:23','2019-12-18 13:36:27','19e9b001-abe3-45f0-b46e-0d1926c9e963.png','2020-12-23 10:09:23','SYNCED','19e9b001-abe3-45f0-b46e-0d1926c9e963',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 20.1.268.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'19eb4150-9ade-4bf8-82ec-a5deb8b47c28','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/19eb4150-9ade-4bf8-82ec-a5deb8b47c28.png','SNAPS','PATIENT_d9860777-a354-46c2-bb39-b2f150617cc7_ACT_007fc3da-8408-4668-b268-90b0cc4e0512_SESS_e5c0ff5f-1b35-473b-bb5b-6a699181486e_TOSC_74751b16-e67c-476c-874e-887f4154a58b_SNAPS_','2020-12-23 09:09:23','2019-12-18 14:28:39','19eb4150-9ade-4bf8-82ec-a5deb8b47c28.png','2020-12-23 10:09:23','SYNCED','19eb4150-9ade-4bf8-82ec-a5deb8b47c28',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 21.1.268.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'1a064538-a770-400a-9ae7-7dc82dab1914','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1a064538-a770-400a-9ae7-7dc82dab1914.ply','PLY','PATIENT_c99d352c-a346-4446-b7d9-4cacf017b67a_ACT_2b22a50e-19be-4908-85ec-2b3c28f8a0a3_SESS_98d25a16-10f9-498a-b3ce-02ed35bb57db_BOSC_f8c7ea3d-e8d3-4562-8cc9-7f56875943af_PLY_','2022-03-04 13:40:27','2019-07-09 13:27:50','1a064538-a770-400a-9ae7-7dc82dab1914.ply','2022-03-04 14:40:27','SYNCED','9d7cfec3-5eaa-4a43-9df0-52afca7a6659',1,NULL,'','','{\"displayTitle\":\"MANDIBULE 12.2.1.1\",\"modelMatrix\":\"-0.463186,-0.885255,0.0422048,0,0.886261,-0.462661,0.0220575,0,1.00124e-10,0.0476212,0.998865,0,-28.6409,-9.29436,-27.1477,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'1a1bb475-753e-42f1-8e77-6026322bc780','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1a1bb475-753e-42f1-8e77-6026322bc780.png','SNAPS','PATIENT_a730394c-024c-4469-9597-1dc64fff623b_ACT_d06f5848-7983-4029-b7d5-5fca4dc843dc_SESS_f41ed3e2-fec4-48ed-a7a0-8a30ff371794_BOSC_eaf850f9-b0f2-4558-96d6-555cc2a7914f_SNAPS_','2020-12-16 11:09:27','2020-01-31 11:37:49','1a1bb475-753e-42f1-8e77-6026322bc780.png','2020-12-16 12:09:27','SYNCED','1a1bb475-753e-42f1-8e77-6026322bc780',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 25.1.1.3.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'1a223688-ad90-48c6-9ef9-789d7e241f28','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1a223688-ad90-48c6-9ef9-789d7e241f28.ply','PLY','PATIENT_019f88e4-b296-4fae-b81b-047b7ac1e2ad_ACT_4a8f3bf4-50e5-43f3-832c-67abea46adac_SESS_4175ebf4-caa4-41f9-9e4b-bb89709e4f54_TOSC_7391f79f-b53b-4bf1-bfba-8cccf358ba01_PLY_','2022-02-01 11:47:53','2019-09-10 09:45:28','1a223688-ad90-48c6-9ef9-789d7e241f28.ply','2022-02-01 12:47:53','SYNCED','1a223688-ad90-48c6-9ef9-789d7e241f28',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 148.1.1.1\",\"modelMatrix\":\"0.751705,-0.57028,0.331239,0,0.659499,0.650013,-0.377551,0,-1.13395e-8,0.502259,0.864717,0,4.80113,-36.8968,-11.3702,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1a32e867-105e-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1a32e867-105e-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_fd694b3f-abde-4e46-91f7-7c62bfdcafa4_SESS_73a3f5b9-e905-4911-a163-2022e1de3380_TOSC_1fa74125-0851-4e94-abdc-8b29cf638995_PLY_','2021-08-19 22:40:59','2019-11-26 21:04:03','1a32e867-105e-11ea-947d-226cec7cb58a.ply','2021-08-20 00:40:59','SYNCED','1a32e867-105e-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"modelMatrix\":\"0.418332,-0.873138,0.250255,0,0.908294,0.40214,-0.11526,0,-8.87156e-9,0.275522,0.961295,0,-7.18197,-30.5759,-18.3735,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1a34a6b7-105e-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1a34a6b7-105e-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_fd694b3f-abde-4e46-91f7-7c62bfdcafa4_SESS_73a3f5b9-e905-4911-a163-2022e1de3380_TOSC_1fa74125-0851-4e94-abdc-8b29cf638995_SNAPS_','2021-08-19 22:41:01','2019-11-26 21:04:03','1a34a6b7-105e-11ea-947d-226cec7cb58a.png','2021-08-20 00:41:01','SYNCED','1a34a6b7-105e-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'1a362018-105e-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1a362018-105e-11ea-947d-226cec7cb58a.stl','STL','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_fd694b3f-abde-4e46-91f7-7c62bfdcafa4_SESS_73a3f5b9-e905-4911-a163-2022e1de3380_TOSC_1fa74125-0851-4e94-abdc-8b29cf638995_STL_','2021-08-19 22:41:01','2019-11-26 21:04:03','1a362018-105e-11ea-947d-226cec7cb58a.stl','2021-08-20 00:41:01','SYNCED','1a362018-105e-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"modelMatrix\":\"0.418332,-0.873138,0.250255,0,0.908294,0.40214,-0.11526,0,-8.87156e-9,0.275522,0.961295,0,-7.18197,-30.5759,-18.3735,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'1a79cabf-3d20-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1a79cabf-3d20-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_81216474-903a-40ae-a892-6c590d71129e_SESS_32348743-f20e-4ba7-8bb6-3d0bb22ac6d6_BOSC_46617b09-f156-4a66-ba86-8cf28b667a26_SNAPS_','2020-12-16 11:09:28','2020-01-22 15:04:14','1a79cabf-3d20-11ea-947d-226cec7cb58a.png','2020-12-16 12:09:28','SYNCED','1a79cabf-3d20-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'1a7bb831-3d20-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1a7bb831-3d20-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_81216474-903a-40ae-a892-6c590d71129e_SESS_32348743-f20e-4ba7-8bb6-3d0bb22ac6d6_BOSC_46617b09-f156-4a66-ba86-8cf28b667a26_PLY_','2020-12-16 11:09:29','2020-01-22 15:04:14','1a7bb831-3d20-11ea-947d-226cec7cb58a.ply','2020-12-16 12:09:29','SYNCED','1a7bb831-3d20-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.1.1.1.1\",\"modelMatrix\":\"-0.977073,0.203822,-0.0615193,0,-0.212904,-0.935394,0.282329,0,2.75634e-9,0.288954,0.957343,0,-9.48991,16.0562,-15.8,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'1a7d5d95-3d20-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1a7d5d95-3d20-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_cb3d6deb-e5a7-4c50-8417-7dbc22bbea85_ACT_81216474-903a-40ae-a892-6c590d71129e_SESS_32348743-f20e-4ba7-8bb6-3d0bb22ac6d6_TOSC_09ee17c5-a16c-4091-836a-6bedd4d487e3_PLY_','2020-12-16 11:09:29','2020-01-22 15:01:34','1a7d5d95-3d20-11ea-947d-226cec7cb58a.ply','2020-12-16 12:09:29','SYNCED','1a7d5d95-3d20-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.1.1.1.1\",\"modelMatrix\":\"0.638609,-0.712757,0.290095,0,0.769531,0.591495,-0.24074,0,8.2948e-9,0.376976,0.926223,0,-1.62114,-33.242,-11.1667,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1a7f1977-3d20-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1a7f1977-3d20-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_cb3d6deb-e5a7-4c50-8417-7dbc22bbea85_ACT_81216474-903a-40ae-a892-6c590d71129e_SESS_32348743-f20e-4ba7-8bb6-3d0bb22ac6d6_TOSC_09ee17c5-a16c-4091-836a-6bedd4d487e3_SNAPS_','2020-12-16 11:09:29','2020-01-22 15:01:34','1a7f1977-3d20-11ea-947d-226cec7cb58a.png','2020-12-16 12:09:29','SYNCED','1a7f1977-3d20-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'1a95e4aa-11e4-4773-acd4-6e2313dd1a72','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1a95e4aa-11e4-4773-acd4-6e2313dd1a72.stl','STL','PATIENT_f378056d-f37c-4a09-952d-c4874c6a7590_ACT_7b843882-d3fe-43f2-8383-c119292fa05e_SESS_d860ca72-5a30-47ca-89d8-76b73a3fde3c_BOSC_fa1c2d54-7543-4725-b6f3-66eef2c50a1a_STL_','2022-03-04 13:40:27','2019-07-08 16:41:32','1a95e4aa-11e4-4773-acd4-6e2313dd1a72.stl','2022-03-04 14:40:27','SYNCED','1a95e4aa-11e4-4773-acd4-6e2313dd1a72',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 8.1.1.1\",\"modelMatrix\":\"-0.868208,-0.463605,0.176873,0,0.4962,-0.811178,0.309478,0,-6.77165e-9,0.356456,0.934312,0,19.082,23.0734,-22.7013,1\",\"title\":\"MANDIBULE STL\"}'),(2,'1ab8a9a6-1ea8-41bb-815e-5b2432504c52','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1ab8a9a6-1ea8-41bb-815e-5b2432504c52.ply','PLY','PATIENT_219e06bf-658b-4509-89dd-91eb233e7414_ACT_3e8de40a-84ea-400e-a796-1909a3cd4eb1_SESS_bbcd74d3-ccf3-4041-9d8f-f9bd1d31e4c0_BOSC_d3975b25-88fc-41d2-981a-50980ae67106_PLY_','2022-02-01 11:47:53','2019-09-20 10:23:32','1ab8a9a6-1ea8-41bb-815e-5b2432504c52.ply','2022-02-01 12:47:53','SYNCED','b327a63b-42c0-41ff-a19d-cfeebf50fdbe',1,NULL,'','','{\"displayTitle\":\"MANDIBULE 157.1.1.1\",\"modelMatrix\":\"0.866705,0.498381,-0.0209471,0,-0.498821,0.86594,-0.0363957,0,-6.27146e-10,0.0419932,0.999118,0,20.2369,-10.8757,-29.4777,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'1ad96584-bfb2-450b-8773-11aa5f287fc8','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1ad96584-bfb2-450b-8773-11aa5f287fc8.ply','PLY','PATIENT_0c1246d6-d8e8-4416-8498-e34a2e9ddfd8_ACT_78d1800f-cfc8-4d8b-95d4-905d652bc290_SESS_1e85e5ad-1bed-4579-a9f1-ede0148c3578_BOSC_ee4e1ede-09dc-44bc-9733-a48456d90500_PLY_','2021-02-16 16:39:02','2019-12-12 15:22:30','1ad96584-bfb2-450b-8773-11aa5f287fc8.ply','2021-02-16 17:39:02','SYNCED','1ad96584-bfb2-450b-8773-11aa5f287fc8',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 232.17.1.1\",\"modelMatrix\":\"-0.964864,0.244964,-0.0950274,0,-0.26275,-0.899551,0.348957,0,1.18968e-9,0.361665,0.932308,0,-7.19111,16.3826,-20.2816,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'1ae5abaa-ea55-459f-87b2-95a1bc3b8e80','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1ae5abaa-ea55-459f-87b2-95a1bc3b8e80.stl','STL','PATIENT_7dec86c0-1085-463b-888a-3363184a2fec_ACT_054e3d99-a38e-4dbd-adc8-33dbc93198c7_SESS_853ab549-f561-4849-8acd-2ec1e14f57fc_TOSC_5916611b-ff0e-465b-ad25-89420f1e6066_STL_','2022-02-01 11:47:54','2019-09-30 09:31:25','1ae5abaa-ea55-459f-87b2-95a1bc3b8e80.stl','2022-02-01 12:47:54','SYNCED','1ae5abaa-ea55-459f-87b2-95a1bc3b8e80',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 45.1.1.1\",\"modelMatrix\":\"0.531945,-0.755195,0.383034,0,0.846779,0.474413,-0.240621,0,1.30923e-9,0.452342,0.891844,0,-0.207042,-33.9745,-18.8016,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'1ae5f4fa-6302-490e-b89d-340f5f40ea8b','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1ae5f4fa-6302-490e-b89d-340f5f40ea8b.stl','STL','PATIENT_67d39055-0cd5-49c0-9f3b-2cc576bfc310_ACT_291510cf-2ad2-4298-817d-22026f7bf446_SESS_9284a539-a136-47a9-a524-769845154750_BOSC_9a58cd85-8834-4e0c-92c1-2ea40f660e6d_STL_','2022-02-01 11:47:54','2019-07-24 15:21:56','1ae5f4fa-6302-490e-b89d-340f5f40ea8b.stl','2022-02-01 12:47:54','SYNCED','1ae5f4fa-6302-490e-b89d-340f5f40ea8b',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 114.1.1.1\",\"modelMatrix\":\"-0.729991,0.673961,-0.11353,0,-0.683456,-0.71985,0.12126,0,-3.67039e-9,0.166112,0.986107,0,-5.44857,24.2465,-24.2553,1\",\"title\":\"MANDIBULE STL\"}'),(2,'1aeb3a0a-f3a6-414b-b50a-e70389c9dd4a','','PLY','PATIENT_16367112-6a96-47d9-859f-3dc28d5a08e4_ACT_628e12f5-617f-4cd1-94f1-89c29cf040d1_SESS_78998169-feb8-4484-a493-1ba5891adbe8_TOSC_7b9bc597-781f-4a85-9875-dcdd1bab4a91_PLY_','2022-02-01 11:47:54','2019-09-04 10:15:37','','2022-02-01 12:47:54','SYNCED','1aeb3a0a-f3a6-414b-b50a-e70389c9dd4a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 143.1.1.1\",\"modelMatrix\":\"0.667841,-0.682049,0.29799,0,0.744304,0.611981,-0.267377,0,-1.53761e-8,0.40036,0.916358,0,-1.37195,-38.1391,-26.6895,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1b046322-102b-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1b046322-102b-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_1703ba62-35c6-4b8c-8017-7e720f790f3a_ACT_d55baca2-6f09-4446-a148-dcdcfcaf57d8_SESS_5efdc987-8bdd-454f-b282-82efcf807bae_TOSC_dcbc56e6-2eed-4eb4-8bd7-1772f7d5c1eb_SNAPS_','2021-08-19 22:41:05','2019-11-26 14:53:46','1b046322-102b-11ea-947d-226cec7cb58a.png','2021-08-20 00:41:05','SYNCED','1b046322-102b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.31.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'1b06466c-102b-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1b06466c-102b-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_1703ba62-35c6-4b8c-8017-7e720f790f3a_ACT_d55baca2-6f09-4446-a148-dcdcfcaf57d8_SESS_5efdc987-8bdd-454f-b282-82efcf807bae_TOSC_dcbc56e6-2eed-4eb4-8bd7-1772f7d5c1eb_PLY_','2021-08-19 22:41:06','2019-11-26 14:53:46','1b06466c-102b-11ea-947d-226cec7cb58a.ply','2021-08-20 00:41:06','SYNCED','1b06466c-102b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.31.1.1\",\"modelMatrix\":\"-0.0643169,-0.952267,0.298413,0,0.99793,-0.0613739,0.0192328,0,5.98575e-10,0.299032,0.954243,0,-22.4595,-26.6577,-15.2831,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1b0805c5-102b-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1b0805c5-102b-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_72f539f4-2d06-47fa-b0b8-1291879a4818_ACT_d55baca2-6f09-4446-a148-dcdcfcaf57d8_SESS_5efdc987-8bdd-454f-b282-82efcf807bae_TOSC_b66fea2f-bc78-4e5c-a916-f991e18ffd9c_PLY_','2021-08-19 22:41:06','2019-11-26 14:59:17','1b0805c5-102b-11ea-947d-226cec7cb58a.ply','2021-08-20 00:41:06','SYNCED','1b0805c5-102b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 86.1.1.1.1\",\"modelMatrix\":\"0.177266,-0.959157,0.220444,0,0.984163,0.172762,-0.039706,0,-2.83523e-10,0.223992,0.974591,0,-15.0317,-31.62,-14.1388,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1b09966c-102b-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1b09966c-102b-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_72f539f4-2d06-47fa-b0b8-1291879a4818_ACT_d55baca2-6f09-4446-a148-dcdcfcaf57d8_SESS_5efdc987-8bdd-454f-b282-82efcf807bae_TOSC_b66fea2f-bc78-4e5c-a916-f991e18ffd9c_SNAPS_','2021-08-19 22:41:07','2019-11-26 14:59:17','1b09966c-102b-11ea-947d-226cec7cb58a.png','2021-08-20 00:41:07','SYNCED','1b09966c-102b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 86.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'1b0affb1-102b-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1b0affb1-102b-11ea-947d-226cec7cb58a.stl','STL','PATIENT_1703ba62-35c6-4b8c-8017-7e720f790f3a_ACT_d55baca2-6f09-4446-a148-dcdcfcaf57d8_SESS_5efdc987-8bdd-454f-b282-82efcf807bae_TOSC_dcbc56e6-2eed-4eb4-8bd7-1772f7d5c1eb_STL_','2021-08-19 22:41:07','2019-11-26 14:53:46','1b0affb1-102b-11ea-947d-226cec7cb58a.stl','2021-08-20 00:41:07','SYNCED','1b0affb1-102b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.31.1.1\",\"modelMatrix\":\"-0.0643169,-0.952267,0.298413,0,0.99793,-0.0613739,0.0192328,0,5.98575e-10,0.299032,0.954243,0,-22.4595,-26.6577,-15.2831,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'1b0c7abd-102b-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1b0c7abd-102b-11ea-947d-226cec7cb58a.stl','STL','PATIENT_72f539f4-2d06-47fa-b0b8-1291879a4818_ACT_d55baca2-6f09-4446-a148-dcdcfcaf57d8_SESS_5efdc987-8bdd-454f-b282-82efcf807bae_TOSC_b66fea2f-bc78-4e5c-a916-f991e18ffd9c_STL_','2021-08-19 22:41:08','2019-11-26 14:59:17','1b0c7abd-102b-11ea-947d-226cec7cb58a.stl','2021-08-20 00:41:08','SYNCED','1b0c7abd-102b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 86.1.1.1.1\",\"modelMatrix\":\"0.177266,-0.959157,0.220444,0,0.984163,0.172762,-0.039706,0,-2.83523e-10,0.223992,0.974591,0,-15.0317,-31.62,-14.1388,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'1b178a56-219c-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1b178a56-219c-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_3a17dba1-ccaf-434a-9992-bf0a911e471d_ACT_6f454b97-62a3-47bf-af0b-2c715349b9fa_SESS_c0a70891-bb78-4cfe-a93c-d3883bdd420b_TOSC_75faf722-c504-459e-90a7-25bddfca96ff_SNAPS_','2020-12-23 09:09:28','2019-12-18 14:35:48','1b178a56-219c-11ea-947d-226cec7cb58a.png','2020-12-23 10:09:28','SYNCED','1b178a56-219c-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 20.1.267.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'1b1e30b4-219c-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1b1e30b4-219c-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_3a17dba1-ccaf-434a-9992-bf0a911e471d_ACT_6f454b97-62a3-47bf-af0b-2c715349b9fa_SESS_c0a70891-bb78-4cfe-a93c-d3883bdd420b_TOSC_75faf722-c504-459e-90a7-25bddfca96ff_PLY_','2020-12-23 09:09:28','2019-12-18 14:35:48','1b1e30b4-219c-11ea-947d-226cec7cb58a.ply','2020-12-23 10:09:28','SYNCED','1b1e30b4-219c-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 20.1.267.1.1.1\",\"modelMatrix\":\"0.464931,-0.8434,0.269288,0,0.885347,0.442903,-0.141414,0,-6.36828e-9,0.304161,0.952621,0,-9.464,-35.2795,-24.0394,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1b1fea71-219c-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1b1fea71-219c-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_bfff99cf-e91f-4eed-bb3a-06bece8eaf9f_ACT_6f454b97-62a3-47bf-af0b-2c715349b9fa_SESS_c0a70891-bb78-4cfe-a93c-d3883bdd420b_BOSC_456be945-d765-4194-95fb-324ec25b5b77_SNAPS_','2020-12-23 09:09:28','2019-12-18 14:41:11','1b1fea71-219c-11ea-947d-226cec7cb58a.png','2020-12-23 10:09:28','SYNCED','1b1fea71-219c-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 20.1.267.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'1b214ee7-219c-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1b214ee7-219c-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_bfff99cf-e91f-4eed-bb3a-06bece8eaf9f_ACT_6f454b97-62a3-47bf-af0b-2c715349b9fa_SESS_c0a70891-bb78-4cfe-a93c-d3883bdd420b_BOSC_456be945-d765-4194-95fb-324ec25b5b77_PLY_','2020-12-23 09:09:29','2019-12-18 14:41:11','1b214ee7-219c-11ea-947d-226cec7cb58a.ply','2020-12-23 10:09:29','SYNCED','1b214ee7-219c-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 20.1.267.1.1.1\",\"modelMatrix\":\"-0.96076,-0.277204,0.00994822,0,0.277382,-0.960142,0.0344573,0,-2.72597e-10,0.0358647,0.999357,0,-15.66,11.7824,-20.4747,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'1b240b02-4403-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1b240b02-4403-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_2d224d3d-fa18-49d9-a6ce-810f5d111f17_SESS_aa356540-d03e-4f3f-9fd2-53c8d78b4465_BOSC_ae37f589-097e-4d1a-853c-3217cde319d0_SNAPS_','2020-12-16 11:09:33','2020-01-31 09:24:02','1b240b02-4403-11ea-947d-226cec7cb58a.png','2020-12-16 12:09:33','SYNCED','1b240b02-4403-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'1b25a64a-4403-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1b25a64a-4403-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_3bb18279-17fc-4a07-bc51-29dd742442cd_ACT_2d224d3d-fa18-49d9-a6ce-810f5d111f17_SESS_aa356540-d03e-4f3f-9fd2-53c8d78b4465_TOSC_00aa044f-8b90-47cc-aece-33cfe81a862f_SNAPS_','2020-12-16 11:09:33','2020-01-31 09:21:16','1b25a64a-4403-11ea-947d-226cec7cb58a.png','2020-12-16 12:09:33','SYNCED','1b25a64a-4403-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'1b275c26-4403-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1b275c26-4403-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_2d224d3d-fa18-49d9-a6ce-810f5d111f17_SESS_aa356540-d03e-4f3f-9fd2-53c8d78b4465_BOSC_ae37f589-097e-4d1a-853c-3217cde319d0_PLY_','2020-12-16 11:09:34','2020-01-31 09:24:02','1b275c26-4403-11ea-947d-226cec7cb58a.ply','2020-12-16 12:09:34','SYNCED','1b275c26-4403-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"modelMatrix\":\"-0.985853,-0.167493,0.00629577,0,0.167612,-0.985157,0.0370303,0,7.42756e-10,0.0375617,0.999294,0,-12.2278,14.3913,-24.3996,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'1b28fd69-4403-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1b28fd69-4403-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_3bb18279-17fc-4a07-bc51-29dd742442cd_ACT_2d224d3d-fa18-49d9-a6ce-810f5d111f17_SESS_aa356540-d03e-4f3f-9fd2-53c8d78b4465_TOSC_00aa044f-8b90-47cc-aece-33cfe81a862f_PLY_','2020-12-16 11:09:34','2020-01-31 09:21:16','1b28fd69-4403-11ea-947d-226cec7cb58a.ply','2020-12-16 12:09:34','SYNCED','1b28fd69-4403-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"modelMatrix\":\"0.501664,-0.832093,0.236545,0,0.865062,0.482545,-0.137176,0,-5.12868e-9,0.273443,0.961888,0,-4.7611,-39.638,-18.917,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1b3138cd-0d03-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1b3138cd-0d03-11ea-947d-226cec7cb58a.stl','STL','PATIENT_5e9d5ed1-9305-4161-bcfe-e9e72f8250aa_ACT_cf507921-2b53-45d7-a98a-02c2b435dce9_SESS_ba5bf823-72cd-4316-9ff1-82ecfa732bb0_TOSC_7126b12e-6fcc-430e-8343-349a5662b498_STL_','2021-08-19 22:41:09','2019-11-22 14:30:48','1b3138cd-0d03-11ea-947d-226cec7cb58a.stl','2021-08-20 00:41:09','SYNCED','1b3138cd-0d03-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 210.1.1.1\",\"modelMatrix\":\"0.316314,-0.91193,0.2614,0,0.948655,0.304068,-0.0871595,0,-3.80529e-9,0.275548,0.961287,0,-15.3391,-32.4828,-20.5975,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'1b3328db-0d03-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1b3328db-0d03-11ea-947d-226cec7cb58a.stl','STL','PATIENT_5e9d5ed1-9305-4161-bcfe-e9e72f8250aa_ACT_cf507921-2b53-45d7-a98a-02c2b435dce9_SESS_ba5bf823-72cd-4316-9ff1-82ecfa732bb0_BOSC_637e5446-2a04-4b45-a164-358b3765e93e_STL_','2021-08-19 22:41:09','2019-11-22 14:35:44','1b3328db-0d03-11ea-947d-226cec7cb58a.stl','2021-08-20 00:41:09','SYNCED','1b3328db-0d03-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 210.1.1.1\",\"modelMatrix\":\"-0.993528,0.105725,-0.0415308,0,-0.11359,-0.92474,0.363255,0,-1.1901e-9,0.365621,0.930764,0,-10.4651,15.3202,-21.8916,1\",\"title\":\"MANDIBULE STL\"}'),(2,'1b34a481-0d03-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1b34a481-0d03-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_5e9d5ed1-9305-4161-bcfe-e9e72f8250aa_ACT_cf507921-2b53-45d7-a98a-02c2b435dce9_SESS_ba5bf823-72cd-4316-9ff1-82ecfa732bb0_TOSC_7126b12e-6fcc-430e-8343-349a5662b498_SNAPS_','2021-08-19 22:41:10','2019-11-22 14:30:48','1b34a481-0d03-11ea-947d-226cec7cb58a.png','2021-08-20 00:41:10','SYNCED','1b34a481-0d03-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 210.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'1b360e4d-0d03-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1b360e4d-0d03-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_5e9d5ed1-9305-4161-bcfe-e9e72f8250aa_ACT_cf507921-2b53-45d7-a98a-02c2b435dce9_SESS_ba5bf823-72cd-4316-9ff1-82ecfa732bb0_BOSC_637e5446-2a04-4b45-a164-358b3765e93e_SNAPS_','2021-08-19 22:41:10','2019-11-22 14:35:44','1b360e4d-0d03-11ea-947d-226cec7cb58a.png','2021-08-20 00:41:10','SYNCED','1b360e4d-0d03-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 210.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'1b3795bc-0d03-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1b3795bc-0d03-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_5e9d5ed1-9305-4161-bcfe-e9e72f8250aa_ACT_cf507921-2b53-45d7-a98a-02c2b435dce9_SESS_ba5bf823-72cd-4316-9ff1-82ecfa732bb0_TOSC_7126b12e-6fcc-430e-8343-349a5662b498_PLY_','2021-08-19 22:41:11','2019-11-22 14:30:48','1b3795bc-0d03-11ea-947d-226cec7cb58a.ply','2021-08-20 00:41:11','SYNCED','1b3795bc-0d03-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 210.1.1.1\",\"modelMatrix\":\"0.316314,-0.91193,0.2614,0,0.948655,0.304068,-0.0871595,0,-3.80529e-9,0.275548,0.961287,0,-15.3391,-32.4828,-20.5975,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1b39284d-0d03-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1b39284d-0d03-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_5e9d5ed1-9305-4161-bcfe-e9e72f8250aa_ACT_cf507921-2b53-45d7-a98a-02c2b435dce9_SESS_ba5bf823-72cd-4316-9ff1-82ecfa732bb0_BOSC_637e5446-2a04-4b45-a164-358b3765e93e_PLY_','2021-08-19 22:41:12','2019-11-22 14:35:44','1b39284d-0d03-11ea-947d-226cec7cb58a.ply','2021-08-20 00:41:12','SYNCED','1b39284d-0d03-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 210.1.1.1\",\"modelMatrix\":\"-0.993528,0.105725,-0.0415308,0,-0.11359,-0.92474,0.363255,0,-1.1901e-9,0.365621,0.930764,0,-10.4651,15.3202,-21.8916,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'1b43dee2-eecb-4a60-9974-607eaa75ccff','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1b43dee2-eecb-4a60-9974-607eaa75ccff.ply','PLY','PATIENT_7d2a007e-30d9-47a2-b96b-1aa1b182a14a_ACT_bc2221a8-3b0b-4bf6-b473-ea9bc6a6252a_SESS_87e76ca7-5aa9-46e3-9a83-83606e8d2d5d_TOSC_711b8459-d5e6-4cd2-b375-812bdb4401b2_PLY_','2022-03-04 13:40:27','2019-07-10 09:06:54','1b43dee2-eecb-4a60-9974-607eaa75ccff.ply','2022-03-04 14:40:27','SYNCED','1b43dee2-eecb-4a60-9974-607eaa75ccff',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 16.1.1.1\",\"modelMatrix\":\"0.685116,-0.681951,0.256046,0,0.728434,0.641397,-0.240819,0,-5.25244e-9,0.351502,0.936187,0,4.60841,-34.4291,-18.1085,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1b444a38-480f-4572-b663-7033ac318b2c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1b444a38-480f-4572-b663-7033ac318b2c.ply','PLY','PATIENT_f8f4fd0f-dc97-4b11-9286-86eaf67fb5cb_ACT_bf86aebf-fadb-4a91-a6f6-11f29cebf495_SESS_18d45998-bb23-48fc-abf3-f17f12f8d8b6_BOSC_58e6b3bf-fd55-48a6-bf83-601c93c68e71_PLY_','2022-02-01 11:47:54','2019-09-18 10:18:55','1b444a38-480f-4572-b663-7033ac318b2c.ply','2022-02-01 12:47:54','SYNCED','1b444a38-480f-4572-b663-7033ac318b2c',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 150.1.1.1\",\"modelMatrix\":\"0.715123,-0.659481,0.2317,0,0.698999,0.674693,-0.237045,0,2.63167e-9,0.331474,0.943464,0,2.21702,-30.8157,-25.6092,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'1b454aac-cd4b-4267-9b2b-50b9c493baad','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1b454aac-cd4b-4267-9b2b-50b9c493baad.ply','PLY','PATIENT_ad658416-1165-446a-8058-6a104becf6a6_ACT_0dab2cd9-80a2-4590-88d8-b1b554f5baf7_SESS_942b7768-d8a1-438c-979b-25d9f27ef108_TOSC_edfb2785-6ffb-4c70-8eec-1b355595949e_PLY_','2022-02-01 11:47:54','2019-07-30 13:40:29','1b454aac-cd4b-4267-9b2b-50b9c493baad.ply','2022-02-01 12:47:54','SYNCED','1b454aac-cd4b-4267-9b2b-50b9c493baad',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 118.1.1.1\",\"modelMatrix\":\"0.683992,-0.682405,0.257835,0,0.72949,0.639843,-0.241754,0,4.20148e-9,0.353446,0.935455,0,1.71381,-29.8282,-19.8494,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1b476913-00b3-45f0-b4ef-585836a346d8','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1b476913-00b3-45f0-b4ef-585836a346d8.ply','PLY','PATIENT_4b3599a2-0412-4a8f-be4d-71ea2cec752f_ACT_05fd0ace-8b1a-4b11-9e22-e5cd3f104fc2_SESS_8781df2c-c9da-40bd-832d-193fbbe8e5a2_TOSC_4e82dd70-2c10-4b88-919c-20b80df2d4ae_PLY_','2022-03-04 13:40:27','2019-07-10 11:12:26','1b476913-00b3-45f0-b4ef-585836a346d8.ply','2022-03-04 14:40:27','SYNCED','1b476913-00b3-45f0-b4ef-585836a346d8',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 23.1.1.1\",\"modelMatrix\":\"0.806608,0.589656,-0.041104,0,-0.591087,0.804656,-0.0560913,0,2.35861e-9,0.0695397,0.997579,0,-7.26107,-33.3245,-13.1941,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1b48b991-09f8-4d16-a643-20ca8e29636c','','STL','PATIENT_6df72f48-6933-4986-9961-403150b72460_ACT_8066fb46-4e88-4174-a7b5-ced23d87937b_SESS_59d4c3ec-651e-4d62-b38d-23c6193830fb_TOSC_c6783949-8a9a-42ca-814a-9600e7796d81_STL_','2022-02-01 11:47:55','2019-09-03 10:01:19','','2022-02-01 12:47:55','SYNCED','1b48b991-09f8-4d16-a643-20ca8e29636c',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 140.1.1.1\",\"modelMatrix\":\"0.318373,-0.857701,0.403717,0,0.947965,0.288058,-0.135588,0,-1.99908e-9,0.425877,0.904781,0,-12.8856,-41.7915,-17.0292,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'1b526e01-9b33-440c-8a2c-1e97532b89cf','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1b526e01-9b33-440c-8a2c-1e97532b89cf.ply','PLY','PATIENT_dfbf8ad5-0860-4209-8b85-003bb4250cea_ACT_8cf2d43b-73ce-4c11-9178-da113e274d32_SESS_b49d130d-87ee-424a-9a76-0420a20e43ad_TOSC_8370aa9d-f601-405d-b4ad-04ba67eedf23_PLY_','2022-02-01 11:47:55','2019-08-27 10:31:44','1b526e01-9b33-440c-8a2c-1e97532b89cf.ply','2022-02-01 12:47:55','SYNCED','87a00054-2333-4f4a-9b94-77c5d226fbc9',2,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 133.1.1.1\",\"modelMatrix\":\"0.892058,-0.420264,0.166163,0,0.45192,0.829571,-0.327993,0,1.40793e-8,0.367681,0.929952,0,10.6768,-36.1223,-16.9831,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1b53a4f7-22f8-431e-8d24-a56a1a1b2c41','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1b53a4f7-22f8-431e-8d24-a56a1a1b2c41.stl','STL','PATIENT_fe5c7a46-b553-4918-8645-19d9ebfe7b63_ACT_2577d263-368d-4adc-84a9-942be81edcab_SESS_e2a9cb76-b29b-461b-abde-76a956734b9d_TOSC_161e032c-d390-4467-990b-63a9ac4e9c71_STL_','2022-02-01 11:47:55','2019-09-19 11:52:59','1b53a4f7-22f8-431e-8d24-a56a1a1b2c41.stl','2022-02-01 12:47:55','SYNCED','1b53a4f7-22f8-431e-8d24-a56a1a1b2c41',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 155.1.1.1\",\"modelMatrix\":\"0.431495,-0.836439,0.337907,0,0.902115,0.400081,-0.161626,0,2.90531e-9,0.374572,0.927198,0,-11.3008,-37.017,-24.3058,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'1b641db7-82e8-41a1-9581-e6f98953c8df','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1b641db7-82e8-41a1-9581-e6f98953c8df.stl','STL','PATIENT_e6392ce4-9f0b-4433-a531-f70528fa6af6_ACT_5d325a6f-6bef-44e4-856d-4f346f71711f_SESS_43b5b817-d353-4fe5-8914-4a8d95bd305f_TOSC_e6cc9412-e40d-4d2a-9be5-1d21cd5958d7_STL_','2021-12-30 18:03:55','2019-11-18 14:48:52','1b641db7-82e8-41a1-9581-e6f98953c8df.stl','2021-12-30 19:03:55','SYNCED','1b641db7-82e8-41a1-9581-e6f98953c8df',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 206.1.1.1\",\"modelMatrix\":\"0.548695,-0.777186,0.308085,0,0.836022,0.510079,-0.202201,0,4.30786e-9,0.368512,0.929623,0,-3.72913,-34.9636,-23.0118,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'1b6a0095-26b5-4566-94f6-0c2a97e53359','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1b6a0095-26b5-4566-94f6-0c2a97e53359.stl','STL','PATIENT_bc50bff3-dacb-4f7a-a7c8-b971782c6d1d_ACT_be5de36f-b43d-47f3-b178-801c7822bb7d_SESS_df767eeb-30cd-456e-91c0-aa5269ac29d4_TOSC_7305c3ed-5293-413b-94e3-7184b2ba1d4c_STL_','2021-08-19 22:41:17','2019-11-27 17:32:25','1b6a0095-26b5-4566-94f6-0c2a97e53359.stl','2021-08-20 00:41:17','SYNCED','1b6a0095-26b5-4566-94f6-0c2a97e53359',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 212.1.1.1\",\"modelMatrix\":\"0.613681,-0.764482,0.197389,0,0.789554,0.594195,-0.153421,0,7.9082e-9,0.250001,0.968246,0,4.91535,-32.3696,-10.2703,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'1b83b27b-54d3-4a6e-827e-e5f1ca258e87','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1b83b27b-54d3-4a6e-827e-e5f1ca258e87.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_0fa50162-e5b4-4362-94b6-96de0e9c4b09_SESS_14883797-0220-4581-b082-e16c27e11d39_BOSC_6f3e55e6-ca5a-4b33-9aca-b292f6b15686_PLY_','2020-12-08 17:30:09','2020-06-15 15:37:57','1b83b27b-54d3-4a6e-827e-e5f1ca258e87.ply','2020-12-08 18:30:09','SYNCED','1b83b27b-54d3-4a6e-827e-e5f1ca258e87',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.37.1.1\",\"modelMatrix\":\"-0.994337,-0.0996749,0.0368609,0,0.106272,-0.932608,0.344889,0,-4.26441e-9,0.346853,0.937919,0,-18.3699,17.234,-21.8887,1\",\"title\":\"Mandibule PLY\"}'),(2,'1b91d11e-490f-4362-891c-e81e3b8c7e86','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1b91d11e-490f-4362-891c-e81e3b8c7e86.ply','PLY','PATIENT_29462aad-9a2e-4826-aa98-b584154bf013_ACT_c427eab3-51e7-4ffb-ac3e-fdbec6640ab5_SESS_2486156e-bbb3-4293-9d3c-856c533d0d3a_TOSC_3a9dc5c5-6614-4e08-bf04-941c6fcedd6b_PLY_','2020-12-08 17:30:09','2020-06-18 11:16:30','1b91d11e-490f-4362-891c-e81e3b8c7e86.ply','2020-12-08 18:30:09','SYNCED','1b91d11e-490f-4362-891c-e81e3b8c7e86',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.63.1.1\",\"modelMatrix\":\"0.70054,-0.676427,0.227355,0,0.713614,0.664035,-0.22319,0,-6.10376e-9,0.318597,0.94789,0,0.0548865,-31.515,-19.5777,1\",\"title\":\"Maxillaire PLY\"}'),(2,'1b9e6cfa-1c30-455d-bac3-0ef87adf478d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1b9e6cfa-1c30-455d-bac3-0ef87adf478d.png','SNAPS','PATIENT_b07384f8-83d9-4f6c-859b-96adaea8e7c0_ACT_c06769e9-07b5-4084-85aa-73bd7bfc7f7b_SESS_33427a38-fc45-41ba-9b48-8437b5d15a18_TOSC_3ec15b06-39ea-4ba7-b458-b5ed8acb3e76_SNAPS_','2021-08-19 22:41:18','2019-12-06 14:36:39','1b9e6cfa-1c30-455d-bac3-0ef87adf478d.png','2021-08-20 00:41:18','SYNCED','1b9e6cfa-1c30-455d-bac3-0ef87adf478d',0,NULL,'','','{\"displayTitle\":\"Maxillaire 0\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'1ba092cf-2909-4c57-8a31-6c8fed3ab60f','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1ba092cf-2909-4c57-8a31-6c8fed3ab60f.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_e50e4a79-6194-4e43-81c1-17f414a832a0_SESS_d74ed2f7-c48b-4f59-ba01-030c757a6331_BOSC_edde6709-28bc-4151-8f78-19be82b0834a_SNAPS_','2020-12-16 10:54:05','2020-02-03 09:43:44','1ba092cf-2909-4c57-8a31-6c8fed3ab60f.png','2020-12-16 11:54:05','SYNCED','1ba092cf-2909-4c57-8a31-6c8fed3ab60f',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'1bb1047a-004e-40a7-b38e-0233ac9ea67b','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1bb1047a-004e-40a7-b38e-0233ac9ea67b.stl','STL','PATIENT_815b5386-1271-4b58-bd9d-9262b6f134b2_ACT_3314cd57-1068-47e8-907e-f85c11a633c4_SESS_80bd9038-b20d-46d7-b35d-0ee034cd58e3_BOSC_21384bb6-72d4-4140-9740-78be7fe27460_STL_','2022-02-01 11:47:55','2019-07-12 13:31:44','1bb1047a-004e-40a7-b38e-0233ac9ea67b.stl','2022-02-01 12:47:55','SYNCED','1bb1047a-004e-40a7-b38e-0233ac9ea67b',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 54.1.1.1\",\"modelMatrix\":\"-0.998177,-0.059613,0.00942093,0,0.0603529,-0.985941,0.155813,0,2.34879e-10,0.156097,0.987742,0,-24.2058,12.2684,-20.8529,1\",\"title\":\"MANDIBULE STL\"}'),(2,'1bcbe4e8-0533-4730-8a32-73339a1c15fc','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1bcbe4e8-0533-4730-8a32-73339a1c15fc.stl','STL','PATIENT_67d39055-0cd5-49c0-9f3b-2cc576bfc310_ACT_291510cf-2ad2-4298-817d-22026f7bf446_SESS_9284a539-a136-47a9-a524-769845154750_TOSC_9231a7fc-461e-4bec-a308-e021c8bdb92f_STL_','2022-02-01 11:47:56','2019-07-24 15:16:35','1bcbe4e8-0533-4730-8a32-73339a1c15fc.stl','2022-02-01 12:47:56','SYNCED','1bcbe4e8-0533-4730-8a32-73339a1c15fc',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 114.1.1.1\",\"modelMatrix\":\"-0.593536,-0.781057,0.194071,0,0.804807,-0.576021,0.143126,0,-1.00835e-8,0.24114,0.97049,0,-29.5096,-13.7964,-16.1702,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'1bdaa0b5-a1c0-4959-8ce4-254e6b92fc5e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1bdaa0b5-a1c0-4959-8ce4-254e6b92fc5e.ply','PLY','PATIENT_6df72f48-6933-4986-9961-403150b72460_ACT_8066fb46-4e88-4174-a7b5-ced23d87937b_SESS_59d4c3ec-651e-4d62-b38d-23c6193830fb_BOSC_6c729960-d05e-4459-88a9-b2710ad7af41_PLY_','2022-02-01 11:47:56','2019-09-03 10:13:47','1bdaa0b5-a1c0-4959-8ce4-254e6b92fc5e.ply','2022-02-01 12:47:56','SYNCED','1bdaa0b5-a1c0-4959-8ce4-254e6b92fc5e',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 140.1.1.1\",\"modelMatrix\":\"0.507186,-0.860924,0.0396495,0,0.861836,0.506649,-0.0233335,0,4.80862e-10,0.0460058,0.998941,0,-7.8918,-25.1397,-25.2686,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'1c02cbc5-4a59-43aa-a37d-dec28291cfab','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1c02cbc5-4a59-43aa-a37d-dec28291cfab.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_880ad313-09b0-46e2-864d-098e649dc55c_SNAPS_','2020-12-16 11:09:39','2020-01-24 12:06:05','1c02cbc5-4a59-43aa-a37d-dec28291cfab.png','2020-12-16 12:09:39','SYNCED','1c02cbc5-4a59-43aa-a37d-dec28291cfab',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.2\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'1c072441-eb6c-4f1a-90dd-097b51c55975','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1c072441-eb6c-4f1a-90dd-097b51c55975.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_30aec79f-770c-4080-b132-a378fb911bbf_SESS_233a2543-12ec-47d1-8b2d-0a3e1a26ae24_BOSC_93adad7d-ba30-4f3c-a0bf-5156b9fd6a56_PLY_','2020-12-16 10:54:06','2020-05-20 15:59:09','1c072441-eb6c-4f1a-90dd-097b51c55975.ply','2020-12-16 11:54:06','SYNCED','1c072441-eb6c-4f1a-90dd-097b51c55975',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 216.1.6.1.1\",\"modelMatrix\":\"-0.962425,0.26317,-0.0669237,0,-0.271546,-0.932739,0.237194,0,7.85324e-10,0.246455,0.969154,0,-6.96779,16.8364,-22.0225,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'1c22a07f-a217-4bd4-84dd-549fbc69aef9','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1c22a07f-a217-4bd4-84dd-549fbc69aef9.ply','PLY','PATIENT_990204e3-cf2f-4026-952f-1dddcf7ba877_ACT_89bf7c83-fd87-406c-9bf8-17bb0fe96844_SESS_294a1d39-6e82-4868-9099-03fd0489e3b4_BOSC_25a7a33a-7975-4a61-8489-53a1b9655a8a_PLY_','2020-12-23 09:09:34','2019-12-20 13:38:31','1c22a07f-a217-4bd4-84dd-549fbc69aef9.ply','2020-12-23 10:09:34','SYNCED','1c22a07f-a217-4bd4-84dd-549fbc69aef9',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 56.1.267.1.1.1\",\"modelMatrix\":\"-0.657785,0.747648,-0.0913362,0,-0.753206,-0.65293,0.0797651,0,3.11058e-10,0.121263,0.99262,0,2.90849,25.3058,-19.6205,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'1c24d800-dbf4-46dc-92a6-cf3bd595b35e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1c24d800-dbf4-46dc-92a6-cf3bd595b35e.stl','STL','PATIENT_9a318c4f-2fbd-4155-a76f-3c43b7d53bae_ACT_19e804ce-ab6b-4e85-a75b-48a6cf8d9f70_SESS_2a5a5787-6d83-45b1-b55b-d274789cd71e_TOSC_e4648601-e914-414b-ace7-c8c291d7d1d8_STL_','2021-02-16 16:39:16','2019-12-12 13:36:08','1c24d800-dbf4-46dc-92a6-cf3bd595b35e.stl','2021-02-16 17:39:16','SYNCED','1c24d800-dbf4-46dc-92a6-cf3bd595b35e',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 232.11.1.1\",\"modelMatrix\":\"0.524111,-0.81118,0.259413,0,0.85165,0.499205,-0.159644,0,-5.7871e-9,0.304601,0.95248,0,-1.05391,-32.6395,-16.6428,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'1c2d5815-183d-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1c2d5815-183d-11ea-947d-226cec7cb58a.stl','STL','PATIENT_584425d1-9187-46b2-b779-389ca7946b11_ACT_409afe1a-6919-4fe9-a391-310aec14a3f6_SESS_c1a8d29a-48f5-4a93-8864-20a11b883716_BOSC_8226adab-85e9-40b8-ac63-fa81572bac7d_STL_','2021-02-16 16:39:16','2019-12-06 16:28:38','1c2d5815-183d-11ea-947d-226cec7cb58a.stl','2021-02-16 17:39:16','SYNCED','1c2d5815-183d-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 230.1.1.1\",\"modelMatrix\":\"-0.995044,0.0858767,-0.0501226,0,-0.0994338,-0.859377,0.501582,0,1.66381e-9,0.50408,0.863657,0,-16.8078,13.3522,-20.9704,1\",\"title\":\"MANDIBULE STL\"}'),(2,'1c2e2fef-14f7-475f-a3c9-ba0a5743cd2c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1c2e2fef-14f7-475f-a3c9-ba0a5743cd2c.ply','PLY','PATIENT_961e5084-1756-4d47-8e90-a6b717094efe_ACT_e578fe8c-ed3c-46bc-b105-bc17f69b4a2e_SESS_9f266ece-fc0c-49df-ba49-eeafaee3b31b_TOSC_3b4badfe-6a88-45e3-aa40-a860483d45a7_PLY_','2020-12-16 11:09:40','2020-01-21 11:44:59','1c2e2fef-14f7-475f-a3c9-ba0a5743cd2c.ply','2020-12-16 12:09:40','SYNCED','1c2e2fef-14f7-475f-a3c9-ba0a5743cd2c',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 199.1.2.1.1\",\"modelMatrix\":\"0.400226,-0.894462,0.199392,0,0.916416,0.390638,-0.0870806,0,9.42531e-9,0.217578,0.976043,0,-9.29609,-28.4271,-16.3208,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1c2ee9e8-183d-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1c2ee9e8-183d-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_584425d1-9187-46b2-b779-389ca7946b11_ACT_409afe1a-6919-4fe9-a391-310aec14a3f6_SESS_c1a8d29a-48f5-4a93-8864-20a11b883716_BOSC_8226adab-85e9-40b8-ac63-fa81572bac7d_SNAPS_','2021-02-16 16:39:16','2019-12-06 16:28:38','1c2ee9e8-183d-11ea-947d-226cec7cb58a.png','2021-02-16 17:39:16','SYNCED','1c2ee9e8-183d-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 230.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'1c303450-183d-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1c303450-183d-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_71f7a268-e5be-4c26-a0eb-9954bee7e855_ACT_409afe1a-6919-4fe9-a391-310aec14a3f6_SESS_c1a8d29a-48f5-4a93-8864-20a11b883716_TOSC_30d8a951-0ef8-4f4d-9123-fe218f513361_PLY_','2021-02-16 16:39:17','2019-12-06 16:24:36','1c303450-183d-11ea-947d-226cec7cb58a.ply','2021-02-16 17:39:17','SYNCED','1c303450-183d-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 230.5.1.1\",\"modelMatrix\":\"0.476215,-0.855927,0.201513,0,0.879329,0.463542,-0.109133,0,3.2732e-9,0.229167,0.973387,0,-4.93937,-35.1253,-16.9037,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1c31819b-183d-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1c31819b-183d-11ea-947d-226cec7cb58a.stl','STL','PATIENT_71f7a268-e5be-4c26-a0eb-9954bee7e855_ACT_409afe1a-6919-4fe9-a391-310aec14a3f6_SESS_c1a8d29a-48f5-4a93-8864-20a11b883716_TOSC_30d8a951-0ef8-4f4d-9123-fe218f513361_STL_','2021-02-16 16:39:18','2019-12-06 16:24:36','1c31819b-183d-11ea-947d-226cec7cb58a.stl','2021-02-16 17:39:18','SYNCED','1c31819b-183d-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 230.5.1.1\",\"modelMatrix\":\"0.476215,-0.855927,0.201513,0,0.879329,0.463542,-0.109133,0,3.2732e-9,0.229167,0.973387,0,-4.93937,-35.1253,-16.9037,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'1c33178c-183d-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1c33178c-183d-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_71f7a268-e5be-4c26-a0eb-9954bee7e855_ACT_409afe1a-6919-4fe9-a391-310aec14a3f6_SESS_c1a8d29a-48f5-4a93-8864-20a11b883716_TOSC_30d8a951-0ef8-4f4d-9123-fe218f513361_SNAPS_','2021-02-16 16:39:18','2019-12-06 16:24:36','1c33178c-183d-11ea-947d-226cec7cb58a.png','2021-02-16 17:39:18','SYNCED','1c33178c-183d-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 230.5.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'1c34ff40-183d-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1c34ff40-183d-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_584425d1-9187-46b2-b779-389ca7946b11_ACT_409afe1a-6919-4fe9-a391-310aec14a3f6_SESS_c1a8d29a-48f5-4a93-8864-20a11b883716_BOSC_8226adab-85e9-40b8-ac63-fa81572bac7d_PLY_','2021-02-16 16:39:18','2019-12-06 16:28:38','1c34ff40-183d-11ea-947d-226cec7cb58a.ply','2021-02-16 17:39:18','SYNCED','1c34ff40-183d-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 230.1.1.1\",\"modelMatrix\":\"-0.995044,0.0858767,-0.0501226,0,-0.0994338,-0.859377,0.501582,0,1.66381e-9,0.50408,0.863657,0,-16.8078,13.3522,-20.9704,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'1c3f32b2-06b1-4434-bc67-c963527ff895','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1c3f32b2-06b1-4434-bc67-c963527ff895.png','SNAPS','PATIENT_1dfeecba-f15d-47a0-8441-39c0a59e8efb_ACT_01705e56-9cac-4986-bd22-f57409780d81_SESS_70490eb5-7fa8-4828-842f-ba025ffc949b_TOSC_96735176-5a71-4243-8e31-55a30c6d524a_SNAPS_','2022-02-01 11:47:56','2019-07-22 12:17:41','1c3f32b2-06b1-4434-bc67-c963527ff895.png','2022-02-01 12:47:56','SYNCED','1c3f32b2-06b1-4434-bc67-c963527ff895',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 106.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'1c4c5a8a-44d7-49a2-8db3-aa2df759f293','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1c4c5a8a-44d7-49a2-8db3-aa2df759f293.stl','STL','PATIENT_800e5513-5023-48f2-9c4d-10c8100e77b8_ACT_3496764d-672e-4434-be29-beb06b419e6f_SESS_4904be4e-9f42-485f-a33f-b682e3b55bfa_TOSC_8fd20f85-5c33-4d5c-8705-c05ff2a4f810_STL_','2022-02-01 11:47:56','2019-07-11 14:41:31','1c4c5a8a-44d7-49a2-8db3-aa2df759f293.stl','2022-02-01 12:47:56','SYNCED','1c4c5a8a-44d7-49a2-8db3-aa2df759f293',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 43.1.1.1\",\"modelMatrix\":\"0.73471,-0.660563,0.154464,0,0.678382,0.715411,-0.167289,0,-3.44059e-9,0.227694,0.973733,0,-0.0448326,-35.5872,-15.0178,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'1c6e857d-218d-4ae1-abb1-d7b7f00fb99e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1c6e857d-218d-4ae1-abb1-d7b7f00fb99e.png','SNAPS','PATIENT_e70f7e60-3171-47f6-b304-48663793dd6c_ACT_aaa611dc-5043-4084-a623-dee5521b387d_SESS_8c7531eb-ce1f-43ad-9225-6dc50dc511b3_TOSC_68e4e89e-5129-45db-81c4-431f18e65e9d_SNAPS_','2022-02-01 11:47:56','2019-07-11 17:19:23','1c6e857d-218d-4ae1-abb1-d7b7f00fb99e.png','2022-02-01 12:47:56','SYNCED','1c6e857d-218d-4ae1-abb1-d7b7f00fb99e',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 46.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'1c7b0843-47fb-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1c7b0843-47fb-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_b17fbded-e440-404b-9e3a-f1ff0c633c52_SESS_d3b4a31d-648a-440e-bf8a-a06937232206_BOSC_20ce1c07-137c-4f06-832a-980af08b477d_SNAPS_','2021-02-11 15:55:20','2020-02-05 10:36:36','1c7b0843-47fb-11ea-947d-226cec7cb58a.png','2021-02-11 16:55:20','SYNCED','1c7b0843-47fb-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'1c7d4e38-47fb-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1c7d4e38-47fb-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_9eadb148-0e40-4794-9f72-fd51e040867c_ACT_b17fbded-e440-404b-9e3a-f1ff0c633c52_SESS_d3b4a31d-648a-440e-bf8a-a06937232206_TOSC_cc34351a-a270-4383-a462-5e386823080b_SNAPS_','2021-02-11 15:55:21','2020-02-05 10:32:00','1c7d4e38-47fb-11ea-947d-226cec7cb58a.png','2021-02-11 16:55:21','SYNCED','1c7d4e38-47fb-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'1c7f5c50-47fb-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1c7f5c50-47fb-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_9eadb148-0e40-4794-9f72-fd51e040867c_ACT_b17fbded-e440-404b-9e3a-f1ff0c633c52_SESS_d3b4a31d-648a-440e-bf8a-a06937232206_TOSC_cc34351a-a270-4383-a462-5e386823080b_PLY_','2021-02-11 15:55:21','2020-02-05 10:32:00','1c7f5c50-47fb-11ea-947d-226cec7cb58a.ply','2021-02-11 16:55:21','SYNCED','1c7f5c50-47fb-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"modelMatrix\":\"0.507311,-0.839811,0.193268,0,0.861763,0.494388,-0.113775,0,-7.08135e-9,0.224271,0.974527,0,-3.38045,-35.2633,-17.6413,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1c81fdc1-47fb-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1c81fdc1-47fb-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_b17fbded-e440-404b-9e3a-f1ff0c633c52_SESS_d3b4a31d-648a-440e-bf8a-a06937232206_BOSC_20ce1c07-137c-4f06-832a-980af08b477d_PLY_','2021-02-11 15:55:21','2020-02-05 10:36:36','1c81fdc1-47fb-11ea-947d-226cec7cb58a.ply','2021-02-11 16:55:21','SYNCED','1c81fdc1-47fb-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"modelMatrix\":\"-0.825214,0.557022,-0.0935282,0,-0.56482,-0.813822,0.136647,0,-4.37533e-9,0.165589,0.986195,0,-2.1782,21.2668,-18.1189,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'1c8c66be-0fb6-4559-ba0f-fa9220d0e921','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1c8c66be-0fb6-4559-ba0f-fa9220d0e921.png','SNAPS','PATIENT_55452abe-c899-4508-a6ad-a6862da81096_ACT_10244838-8d43-4b45-843e-1b1867b80fe9_SESS_a27242e6-79e3-49b8-9935-388a52c32306_BOSC_8ecb3f26-bcc5-4755-b33c-40ac0640d1f3_SNAPS_','2021-02-11 15:55:21','2020-06-17 10:15:14','1c8c66be-0fb6-4559-ba0f-fa9220d0e921.png','2021-02-11 16:55:21','SYNCED','1c8c66be-0fb6-4559-ba0f-fa9220d0e921',0,NULL,'','','{\"displayTitle\":\"Mandibule 32.1.1.1.8\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'1c9e8eaa-0c7f-4465-877d-ee73291e1f7c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1c9e8eaa-0c7f-4465-877d-ee73291e1f7c.ply','PLY','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_4236ad55-b0ce-4915-b0f9-fdd697747472_SESS_bbc54361-eed1-4f69-bf2e-073e97cca6b5_BOSC_6af84cd6-434f-4459-b494-e647df3f3e3b_PLY_','2021-02-11 15:55:21','2019-12-31 11:21:25','1c9e8eaa-0c7f-4465-877d-ee73291e1f7c.ply','2021-02-11 16:55:21','SYNCED','1c9e8eaa-0c7f-4465-877d-ee73291e1f7c',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"modelMatrix\":\"-0.992334,0.120388,-0.0279248,0,-0.123584,-0.966669,0.224226,0,-6.99286e-10,0.225958,0.974137,0,-11.4358,15.4423,-22.9364,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'1cdb6a49-3c4e-4d75-89e9-c2655ba2d456','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1cdb6a49-3c4e-4d75-89e9-c2655ba2d456.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_db5b6146-4c77-4f90-83c3-112726786693_SESS_4493fcea-2851-43f9-9a3a-8a2e4208e653_TOSC_71db489f-5cb0-474f-b373-b62a9d51372b_PLY_','2021-02-11 15:55:22','2020-03-13 11:20:54','1cdb6a49-3c4e-4d75-89e9-c2655ba2d456.ply','2021-02-11 16:55:22','SYNCED','1cdb6a49-3c4e-4d75-89e9-c2655ba2d456',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"modelMatrix\":\"0.609118,-0.761073,0.223032,0,0.79308,0.584535,-0.171298,0,1.31309e-8,0.281223,0.959642,0,4.07644,-35.2054,-15.7103,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1cdd0ff5-f6db-448e-9ffc-05740f1ee7b5','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1cdd0ff5-f6db-448e-9ffc-05740f1ee7b5.stl','STL','PATIENT_fcf8c111-84a1-4f17-859c-ea2ad21d373b_ACT_d27c23bb-fa1e-4cd8-bacc-e2b65114a20e_SESS_844480c5-a8a8-4eb3-a014-e1424d66a1ca_TOSC_b73a04bd-84b6-4f87-a8b3-d33b2a76f182_STL_','2021-12-30 18:03:58','2019-11-18 11:28:10','1cdd0ff5-f6db-448e-9ffc-05740f1ee7b5.stl','2021-12-30 19:03:58','SYNCED','1cdd0ff5-f6db-448e-9ffc-05740f1ee7b5',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 168.1.1.1.1\",\"modelMatrix\":\"0.293186,-0.903676,0.312108,0,0.956055,0.277124,-0.0957117,0,8.61169e-9,0.326453,0.945213,0,-12.429,-30.6556,-23.2798,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'1cdf8a84-a5b6-42d0-8bbc-4b5e6aa31fe5','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1cdf8a84-a5b6-42d0-8bbc-4b5e6aa31fe5.stl','STL','PATIENT_2df9c598-3519-4719-a1e4-f4e150a235a9_ACT_ceb083f7-ec86-4eba-9690-123a703c3abc_SESS_ea3ce5df-3ae9-45ef-896c-5661af24bc30_TOSC_c228b987-5095-482a-a729-fecb3ee35abd_STL_','2022-02-07 12:37:55','2019-11-21 10:57:19','1cdf8a84-a5b6-42d0-8bbc-4b5e6aa31fe5.stl','2022-02-07 13:37:55','SYNCED','1cdf8a84-a5b6-42d0-8bbc-4b5e6aa31fe5',0,'2022-02-07 13:37:55','','','{\"displayTitle\":\"MAXILLAIRE 207.3.1.1.8\",\"modelMatrix\":\"0.193768,-0.963162,0.186474,0,0.981047,0.190236,-0.0368308,0,-1.26783e-10,0.190077,0.981769,0,-17.8226,-30.5328,-16.6487,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'1ce08eb0-ea6b-4300-94bf-4e1f0a1010b7','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1ce08eb0-ea6b-4300-94bf-4e1f0a1010b7.png','SNAPS','PATIENT_fcf8c111-84a1-4f17-859c-ea2ad21d373b_ACT_d27c23bb-fa1e-4cd8-bacc-e2b65114a20e_SESS_844480c5-a8a8-4eb3-a014-e1424d66a1ca_TOSC_b73a04bd-84b6-4f87-a8b3-d33b2a76f182_SNAPS_','2021-12-30 18:03:58','2019-11-18 11:28:10','1ce08eb0-ea6b-4300-94bf-4e1f0a1010b7.png','2021-12-30 19:03:58','SYNCED','1ce08eb0-ea6b-4300-94bf-4e1f0a1010b7',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 168.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'1ceac0e1-233b-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1ceac0e1-233b-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_b1a4ca7b-ca89-4218-a968-a47276c5ddc3_ACT_ad32f770-bdfe-47dd-abbc-5d48ecbf032b_SESS_fc66416f-a9bd-46d6-aa19-0c4feba5b343_TOSC_0afe2c4c-ac0d-4aa2-ba34-c08029644967_SNAPS_','2021-02-11 15:55:22','2019-12-20 16:08:55','1ceac0e1-233b-11ea-947d-226cec7cb58a.png','2021-02-11 16:55:22','SYNCED','1ceac0e1-233b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 20.1.267.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'1cecde75-233b-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1cecde75-233b-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_b1a4ca7b-ca89-4218-a968-a47276c5ddc3_ACT_ad32f770-bdfe-47dd-abbc-5d48ecbf032b_SESS_fc66416f-a9bd-46d6-aa19-0c4feba5b343_TOSC_0afe2c4c-ac0d-4aa2-ba34-c08029644967_PLY_','2021-02-11 15:55:22','2019-12-20 16:08:55','1cecde75-233b-11ea-947d-226cec7cb58a.ply','2021-02-11 16:55:22','SYNCED','1cecde75-233b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 20.1.267.1.1.1\",\"modelMatrix\":\"0.573057,-0.766996,0.288657,0,0.819516,0.536332,-0.201847,0,-1.41188e-8,0.352229,0.935914,0,-2.07728,-33.0812,-16.267,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1ceedec2-233b-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1ceedec2-233b-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_bfff99cf-e91f-4eed-bb3a-06bece8eaf9f_ACT_ad32f770-bdfe-47dd-abbc-5d48ecbf032b_SESS_fc66416f-a9bd-46d6-aa19-0c4feba5b343_BOSC_770d96c6-1b99-43ab-896c-0bd5c338b919_SNAPS_','2021-02-11 15:55:22','2019-12-20 16:12:01','1ceedec2-233b-11ea-947d-226cec7cb58a.png','2021-02-11 16:55:22','SYNCED','1ceedec2-233b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 20.1.267.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'1cf0567c-67c6-44e5-a11c-358a963e0ce4','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1cf0567c-67c6-44e5-a11c-358a963e0ce4.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_a69762a2-63e9-4dd6-b501-eaf42be2500d_SESS_3a3f463d-b0c5-448b-882c-2bd19ac5da44_BOSC_b0387d7a-ca4d-43a9-91fe-94cb6a02d905_SNAPS_','2021-02-11 15:55:22','2020-02-24 16:47:12','1cf0567c-67c6-44e5-a11c-358a963e0ce4.png','2021-02-11 16:55:22','SYNCED','1cf0567c-67c6-44e5-a11c-358a963e0ce4',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.2\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'1cf1669c-233b-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1cf1669c-233b-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_bfff99cf-e91f-4eed-bb3a-06bece8eaf9f_ACT_ad32f770-bdfe-47dd-abbc-5d48ecbf032b_SESS_fc66416f-a9bd-46d6-aa19-0c4feba5b343_BOSC_770d96c6-1b99-43ab-896c-0bd5c338b919_PLY_','2021-02-11 15:55:22','2019-12-20 16:12:01','1cf1669c-233b-11ea-947d-226cec7cb58a.ply','2021-02-11 16:55:22','SYNCED','1cf1669c-233b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 20.1.267.1.1.1\",\"modelMatrix\":\"-0.928204,0.367376,-0.0589219,0,-0.372071,-0.916491,0.146992,0,-3.27767e-9,0.158362,0.987381,0,-9.1088,19.974,-15.1226,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'1cff103c-aec3-4152-8479-c9e7e917a910','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1cff103c-aec3-4152-8479-c9e7e917a910.ply','PLY','PATIENT_2df9c598-3519-4719-a1e4-f4e150a235a9_ACT_ceb083f7-ec86-4eba-9690-123a703c3abc_SESS_ea3ce5df-3ae9-45ef-896c-5661af24bc30_TOSC_9ea9beda-7ec0-46aa-bb03-291a141652f3_PLY_','2022-02-07 12:37:55','2019-11-21 10:37:22','1cff103c-aec3-4152-8479-c9e7e917a910.ply','2022-02-07 13:37:55','SYNCED','1cff103c-aec3-4152-8479-c9e7e917a910',0,'2022-02-07 13:37:55','','','{\"displayTitle\":\"MAXILLAIRE 207.3.1.1.5\",\"modelMatrix\":\"0.688471,-0.682808,0.244502,0,0.725264,0.648169,-0.232099,0,2.11116e-8,0.337122,0.941461,0,8.04313,-34.6315,-21.9452,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1d1e5569-b128-476f-a551-293381b067d1','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1d1e5569-b128-476f-a551-293381b067d1.png','SNAPS','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_BOSC_ae8e8633-aa2a-4367-b865-ed0262e99a32_SNAPS_','2021-12-30 18:03:58','2019-11-14 13:24:59','1d1e5569-b128-476f-a551-293381b067d1.png','2021-12-30 19:03:58','SYNCED','1d1e5569-b128-476f-a551-293381b067d1',0,NULL,'','','{\"displayTitle\":\"Mandibola 0\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'1d230521-58cd-45ac-b44d-1c08b18f1d9f','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1d230521-58cd-45ac-b44d-1c08b18f1d9f.ply','PLY','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_c4b2ab75-de84-4ead-837c-d8e600b338c4_SESS_4576ed53-a7e8-4fb1-a55f-f2d13c3acb65_BOSC_dac163bd-d09c-4923-afcb-5ed73f7f4734_PLY_','2021-02-11 15:55:24','2020-01-02 10:05:09','1d230521-58cd-45ac-b44d-1c08b18f1d9f.ply','2021-02-11 16:55:24','SYNCED','1d230521-58cd-45ac-b44d-1c08b18f1d9f',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"modelMatrix\":\"-0.96203,0.269205,-0.0450329,0,-0.272945,-0.948845,0.158724,0,-2.34857e-10,0.164989,0.986295,0,-14.5519,22.5128,-14.11,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'1d24deea-9e66-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1d24deea-9e66-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_96ee9de3-5462-4347-86f9-ed3902bbef33_ACT_c14eea4f-a78d-43c6-9458-0fea262a1f43_SESS_815a7a31-502e-4db1-ba3e-4f8c24301267_TOSC_99840898-9aa0-4693-a7af-2e29b706fa9f_PLY_','2021-02-11 15:55:24','2020-05-25 10:55:33','1d24deea-9e66-11ea-947d-226cec7cb58a.ply','2021-02-11 16:55:24','SYNCED','1d24deea-9e66-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 216.1.1.1.1\",\"modelMatrix\":\"0.67453,-0.70567,0.216884,0,0.738247,0.644765,-0.198165,0,1.29586e-9,0.293782,0.955872,0,1.80998,-29.2007,-19.4814,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1d294e7c-9e66-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1d294e7c-9e66-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_96ee9de3-5462-4347-86f9-ed3902bbef33_ACT_c14eea4f-a78d-43c6-9458-0fea262a1f43_SESS_815a7a31-502e-4db1-ba3e-4f8c24301267_TOSC_99840898-9aa0-4693-a7af-2e29b706fa9f_SNAPS_','2021-02-11 15:55:24','2020-05-25 10:55:33','1d294e7c-9e66-11ea-947d-226cec7cb58a.png','2021-02-11 16:55:24','SYNCED','1d294e7c-9e66-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 216.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'1d2b548a-9e66-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1d2b548a-9e66-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_c14eea4f-a78d-43c6-9458-0fea262a1f43_SESS_815a7a31-502e-4db1-ba3e-4f8c24301267_BOSC_e18aa8bb-3ec0-4fa7-a2fa-7d6cbe0b1872_SNAPS_','2021-02-11 15:55:24','2020-05-25 10:58:27','1d2b548a-9e66-11ea-947d-226cec7cb58a.png','2021-02-11 16:55:24','SYNCED','1d2b548a-9e66-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 216.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'1d2d3d71-9e66-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1d2d3d71-9e66-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_c14eea4f-a78d-43c6-9458-0fea262a1f43_SESS_815a7a31-502e-4db1-ba3e-4f8c24301267_BOSC_e18aa8bb-3ec0-4fa7-a2fa-7d6cbe0b1872_PLY_','2021-02-11 15:55:25','2020-05-25 10:58:27','1d2d3d71-9e66-11ea-947d-226cec7cb58a.ply','2021-02-11 16:55:25','SYNCED','1d2d3d71-9e66-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 216.1.1.1.1\",\"modelMatrix\":\"-0.786502,0.612114,-0.0820421,0,-0.617588,-0.779531,0.104481,0,2.99495e-9,0.132843,0.991137,0,-2.89857,19.6494,-22.8559,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'1d3b7639-1b0a-4d11-a3f2-6cdc8e3e71ac','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1d3b7639-1b0a-4d11-a3f2-6cdc8e3e71ac.png','SNAPS','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_9bfd0fad-9323-4ecc-aa3c-4e92e0d8411b_SESS_d64c3246-d837-498e-a781-c83914964d85_BOSC_6f396560-7dae-4104-8500-c5c5111a9048_SNAPS_','2021-02-11 15:55:25','2019-12-20 14:25:27','1d3b7639-1b0a-4d11-a3f2-6cdc8e3e71ac.png','2021-02-11 16:55:25','SYNCED','1d3b7639-1b0a-4d11-a3f2-6cdc8e3e71ac',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'1d5002d6-c19e-4342-a30a-0da98e9ae1b5','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1d5002d6-c19e-4342-a30a-0da98e9ae1b5.png','SNAPS','PATIENT_3a71900a-c0b3-44f1-97fe-511f6da059ed_ACT_998354df-dabb-40ad-aef4-81fcf373fb99_SESS_afdc2ce6-731d-4d67-8fd1-e4c82a8cb2e2_BOSC_5a89d5d9-b78e-4730-b31e-2b57c29834fe_SNAPS_','2022-02-17 14:31:14','2019-07-15 10:30:00','1d5002d6-c19e-4342-a30a-0da98e9ae1b5.png','2022-02-17 15:31:14','SYNCED','1d5002d6-c19e-4342-a30a-0da98e9ae1b5',0,'2022-02-17 15:31:14','','','{\"displayTitle\":\"MANDIBULE 60.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'1d6a15a0-edb3-4d1d-84f8-10e0e64bb5f4','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1d6a15a0-edb3-4d1d-84f8-10e0e64bb5f4.png','SNAPS','PATIENT_e2b8de54-9669-4fcd-87b6-8e89c7e4bc4d_ACT_0b28fdc6-8b72-4776-bb12-6b9709da4c8b_SESS_55edd854-2683-4bf2-9fbf-6f6981396c19_TOSC_a648f12f-0c65-4043-9082-d2130015fcba_SNAPS_','2021-12-30 18:03:58','2019-10-03 14:19:36','1d6a15a0-edb3-4d1d-84f8-10e0e64bb5f4.png','2021-12-30 19:03:58','SYNCED','1d6a15a0-edb3-4d1d-84f8-10e0e64bb5f4',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 175.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'1d789d03-b2ed-4ec3-b3da-c13790de6e87','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1d789d03-b2ed-4ec3-b3da-c13790de6e87.png','SNAPS','PATIENT_67d9d234-2142-4598-b3d5-a5de2a68f903_ACT_27ae8f9e-e404-4641-96b6-16080a35d897_SESS_a45e6721-1111-4d9d-be19-696dc58dd237_TOSC_175c6391-3062-48ce-ac7b-db50ef63c54a_SNAPS_','2021-02-11 15:55:25','2020-02-21 10:19:25','1d789d03-b2ed-4ec3-b3da-c13790de6e87.png','2021-02-11 16:55:25','SYNCED','1d789d03-b2ed-4ec3-b3da-c13790de6e87',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'1d7bbb13-21f5-426f-8175-6bafd86326a7','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1d7bbb13-21f5-426f-8175-6bafd86326a7.ply','PLY','PATIENT_02187354-bba8-452a-b51b-9fdee38ff259_ACT_52815b84-f366-4ee6-a46d-a6e9066ada25_SESS_9425e6c4-f103-4ced-928e-fa239e582e3d_BOSC_72662b68-6568-4dec-9645-da3b21fbb2b2_PLY_','2021-02-11 15:55:25','2020-01-31 14:57:07','1d7bbb13-21f5-426f-8175-6bafd86326a7.ply','2021-02-11 16:55:25','SYNCED','1d7bbb13-21f5-426f-8175-6bafd86326a7',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"modelMatrix\":\"-0.863798,0.48712,-0.128711,0,-0.503838,-0.835137,0.220666,0,-4.71987e-9,0.25546,0.966819,0,-0.651488,14.7576,-24.5508,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'1d9cad29-d3a0-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1d9cad29-d3a0-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_019f88e4-b296-4fae-b81b-047b7ac1e2ad_ACT_4a8f3bf4-50e5-43f3-832c-67abea46adac_SESS_4175ebf4-caa4-41f9-9e4b-bb89709e4f54_TOSC_7391f79f-b53b-4bf1-bfba-8cccf358ba01_PLY_','2022-02-01 11:47:57','2019-09-10 09:45:28','1d9cad29-d3a0-11e9-947d-226cec7cb58a.ply','2022-02-01 12:47:57','SYNCED','1d9cad29-d3a0-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 148.1.1.1\",\"modelMatrix\":\"0.751705,-0.57028,0.331239,0,0.659499,0.650013,-0.377551,0,-1.13395e-8,0.502259,0.864717,0,4.80113,-36.8968,-11.3702,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1d9ed8fa-d3a0-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1d9ed8fa-d3a0-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_019f88e4-b296-4fae-b81b-047b7ac1e2ad_ACT_4a8f3bf4-50e5-43f3-832c-67abea46adac_SESS_4175ebf4-caa4-41f9-9e4b-bb89709e4f54_TOSC_7391f79f-b53b-4bf1-bfba-8cccf358ba01_SNAPS_','2022-02-01 11:47:57','2019-09-10 09:45:28','1d9ed8fa-d3a0-11e9-947d-226cec7cb58a.png','2022-02-01 12:47:57','SYNCED','1d9ed8fa-d3a0-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 148.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'1da05b14-d3a0-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1da05b14-d3a0-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_019f88e4-b296-4fae-b81b-047b7ac1e2ad_ACT_4a8f3bf4-50e5-43f3-832c-67abea46adac_SESS_4175ebf4-caa4-41f9-9e4b-bb89709e4f54_BOSC_65059476-c726-418b-b1ea-8a4db02557ca_SNAPS_','2022-02-01 11:47:57','2019-09-10 09:50:25','1da05b14-d3a0-11e9-947d-226cec7cb58a.png','2022-02-01 12:47:57','SYNCED','1da05b14-d3a0-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 148.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'1da1a990-d3a0-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1da1a990-d3a0-11e9-947d-226cec7cb58a.stl','STL','PATIENT_019f88e4-b296-4fae-b81b-047b7ac1e2ad_ACT_4a8f3bf4-50e5-43f3-832c-67abea46adac_SESS_4175ebf4-caa4-41f9-9e4b-bb89709e4f54_TOSC_7391f79f-b53b-4bf1-bfba-8cccf358ba01_STL_','2022-02-01 11:47:57','2019-09-10 09:45:28','1da1a990-d3a0-11e9-947d-226cec7cb58a.stl','2022-02-01 12:47:57','SYNCED','1da1a990-d3a0-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 148.1.1.1\",\"modelMatrix\":\"0.751705,-0.57028,0.331239,0,0.659499,0.650013,-0.377551,0,-1.13395e-8,0.502259,0.864717,0,4.80113,-36.8968,-11.3702,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'1da2d42e-d3a0-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1da2d42e-d3a0-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_019f88e4-b296-4fae-b81b-047b7ac1e2ad_ACT_4a8f3bf4-50e5-43f3-832c-67abea46adac_SESS_4175ebf4-caa4-41f9-9e4b-bb89709e4f54_BOSC_65059476-c726-418b-b1ea-8a4db02557ca_PLY_','2022-02-01 11:47:57','2019-09-10 09:50:25','1da2d42e-d3a0-11e9-947d-226cec7cb58a.ply','2022-02-01 12:47:57','SYNCED','1da2d42e-d3a0-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 148.1.1.1\",\"modelMatrix\":\"-0.366803,0.930089,-0.0197555,0,-0.930299,-0.36672,0.00778932,0,1.38553e-10,0.0212357,0.999775,0,6.56639,26.9879,-19.3431,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'1da41615-d3a0-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1da41615-d3a0-11e9-947d-226cec7cb58a.stl','STL','PATIENT_019f88e4-b296-4fae-b81b-047b7ac1e2ad_ACT_4a8f3bf4-50e5-43f3-832c-67abea46adac_SESS_4175ebf4-caa4-41f9-9e4b-bb89709e4f54_BOSC_65059476-c726-418b-b1ea-8a4db02557ca_STL_','2022-02-01 11:47:57','2019-09-10 09:50:25','1da41615-d3a0-11e9-947d-226cec7cb58a.stl','2022-02-01 12:47:57','SYNCED','1da41615-d3a0-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 148.1.1.1\",\"modelMatrix\":\"-0.366803,0.930089,-0.0197555,0,-0.930299,-0.36672,0.00778932,0,1.38553e-10,0.0212357,0.999775,0,6.56639,26.9879,-19.3431,1\",\"title\":\"MANDIBULE STL\"}'),(2,'1da467e0-f187-4d67-9a1e-37cd3e083283','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1da467e0-f187-4d67-9a1e-37cd3e083283.stl','STL','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_db56cba1-23ff-48bf-b86e-4ceff749087f_TOSC_98d2d011-681b-459b-9f74-1d29047fb345_STL_','2021-12-30 18:03:59','2019-11-14 15:15:13','1da467e0-f187-4d67-9a1e-37cd3e083283.stl','2021-12-30 19:03:59','SYNCED','1da467e0-f187-4d67-9a1e-37cd3e083283',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 202.1.1.2\",\"modelMatrix\":\"0.412726,-0.856044,0.311202,0,0.910855,0.38789,-0.141012,0,4.59885e-9,0.341659,0.939824,0,-10.1172,-26.3228,-24.6488,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'1da67948-3769-493e-8a32-6e4d7b0d9bbf','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1da67948-3769-493e-8a32-6e4d7b0d9bbf.png','SNAPS','PATIENT_9f7a036c-220d-4ae4-bbcb-216a65f41b5a_ACT_26a70d16-499b-4516-84ed-fa65947e4129_SESS_8e178a4e-7c33-49fd-8e91-b68df8d3b750_TOSC_01e143d1-43b3-4c3b-9adb-8d0a0b4f6fba_SNAPS_','2021-02-11 15:55:26','2020-01-23 15:15:29','1da67948-3769-493e-8a32-6e4d7b0d9bbf.png','2021-02-11 16:55:26','SYNCED','1da67948-3769-493e-8a32-6e4d7b0d9bbf',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'1db33829-7225-49e8-b836-f1aa46693058','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1db33829-7225-49e8-b836-f1aa46693058.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_1d71b800-f606-4aa6-afdc-be1fcad191d1_SESS_02c4c729-f6f3-4c02-b83a-8bf60094828c_BOSC_b5661018-51b8-4e65-b319-052cf14c11c6_PLY_','2021-02-11 15:55:27','2020-06-16 12:08:18','1db33829-7225-49e8-b836-f1aa46693058.ply','2021-02-11 16:55:27','SYNCED','1db33829-7225-49e8-b836-f1aa46693058',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.42.1.1\",\"modelMatrix\":\"0.11748,0.99235,-0.037958,0,-0.993075,0.117394,-0.0044904,0,3.98232e-11,0.0382227,0.999269,0,18.2111,12.1633,-17.573,1\",\"title\":\"Mandibule PLY\"}'),(2,'1db5e0c1-0f06-406c-8ec5-2e4cb4397d40','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1db5e0c1-0f06-406c-8ec5-2e4cb4397d40.stl','STL','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_fd694b3f-abde-4e46-91f7-7c62bfdcafa4_SESS_73a3f5b9-e905-4911-a163-2022e1de3380_TOSC_19aa3948-bf98-4032-ae14-592e90e9c54f_STL_','2021-08-19 22:41:29','2019-11-26 20:53:12','1db5e0c1-0f06-406c-8ec5-2e4cb4397d40.stl','2021-08-20 00:41:29','SYNCED','1db5e0c1-0f06-406c-8ec5-2e4cb4397d40',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"modelMatrix\":\"0.811974,-0.52408,0.25698,0,0.583694,0.729045,-0.357483,0,-4.50747e-9,0.440265,0.897868,0,5.4772,-28.6145,-12.6976,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'1db87054-7792-4f1c-a746-a8bb7b476d17','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1db87054-7792-4f1c-a746-a8bb7b476d17.stl','STL','PATIENT_3d563d28-1ce3-4ac5-8724-fd2a22b85825_ACT_9f6777ee-04d6-45ba-a1ea-b599ea39fc57_SESS_ab127abe-0c88-4b74-a36d-087642299f26_TOSC_f9829394-8079-4a7b-81fd-92fafaac0242_STL_','2022-03-04 13:40:27','2019-07-08 15:53:25','1db87054-7792-4f1c-a746-a8bb7b476d17.stl','2022-03-04 14:40:27','SYNCED','1db87054-7792-4f1c-a746-a8bb7b476d17',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 2.1.1.1\",\"modelMatrix\":\"0.696202,-0.688758,0.202275,0,0.717846,0.667991,-0.196176,0,-8.32121e-9,0.28178,0.959479,0,-3.91479,-35.5235,-13.4531,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'1dbaef79-9624-4850-9bec-dd9590360de9','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1dbaef79-9624-4850-9bec-dd9590360de9.ply','PLY','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_TOSC_1c5ca125-81ee-4184-83f6-804cc9273616_PLY_','2021-12-30 18:04:00','2019-11-15 12:06:57','1dbaef79-9624-4850-9bec-dd9590360de9.ply','2021-12-30 19:04:00','SYNCED','1dbaef79-9624-4850-9bec-dd9590360de9',0,NULL,'','','{\"displayTitle\":\"Mascella 0\",\"modelMatrix\":\"0.746798,-0.623624,0.231055,0,0.665051,0.700278,-0.259456,0,-3.69147e-9,0.347425,0.937708,0,11.3916,-32.1488,-20.1369,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1dc6963b-3010-4bfd-9acf-4a061bf34754','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1dc6963b-3010-4bfd-9acf-4a061bf34754.stl','STL','PATIENT_878a5537-ff9c-4571-a968-f11b3b1e2055_ACT_6c0855be-3e79-42b9-84ff-3f2afe3afb78_SESS_eb76868f-5b66-47aa-8517-3a782fe0b86f_BOSC_28318e36-8937-4aa6-8ea5-8d0ebd1423c1_STL_','2022-02-01 11:47:58','2019-07-19 12:00:00','1dc6963b-3010-4bfd-9acf-4a061bf34754.stl','2022-02-01 12:47:58','SYNCED','1dc6963b-3010-4bfd-9acf-4a061bf34754',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 99.1.1.1\",\"modelMatrix\":\"-0.961114,-0.274262,0.0322554,0,0.276153,-0.954535,0.112261,0,2.84132e-10,0.116803,0.993155,0,-29.2489,12.1179,-27.6354,1\",\"title\":\"MANDIBULE STL\"}'),(2,'1dd77166-dccc-42e1-bc39-cf0c799daade','','SNAPS','PATIENT_55452abe-c899-4508-a6ad-a6862da81096_ACT_10244838-8d43-4b45-843e-1b1867b80fe9_SESS_a27242e6-79e3-49b8-9935-388a52c32306_TOSC_bf98742d-f1e8-4b3c-99ac-8620c7bff8a1_SNAPS_','2021-02-11 15:55:28','2020-06-17 09:30:34','','2021-02-11 16:55:28','SYNCED','1dd77166-dccc-42e1-bc39-cf0c799daade',0,NULL,'','','{\"displayTitle\":\"Maxillaire 32.1.1.1.7\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'1e0f1e1e-8ef3-489c-9bfe-ab667ff6dd68','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1e0f1e1e-8ef3-489c-9bfe-ab667ff6dd68.ply','PLY','PATIENT_8a820a88-4b3e-478f-91bf-391b7d18010a_ACT_f241ffb9-2728-47c6-ab82-b1158009d656_SESS_68e8c4eb-4528-4168-a200-b9b2e899ea57_BOSC_39b27591-b02e-4a9c-bd7f-f14260b65a57_PLY_','2021-12-30 18:04:00','2019-11-18 14:49:42','1e0f1e1e-8ef3-489c-9bfe-ab667ff6dd68.ply','2021-12-30 19:04:00','SYNCED','1e0f1e1e-8ef3-489c-9bfe-ab667ff6dd68',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 204.1.1.1\",\"modelMatrix\":\"-0.96128,0.27372,-0.0319196,0,-0.275575,-0.954809,0.111344,0,4.07726e-10,0.115829,0.993269,0,-9.75539,18.0032,-31.6814,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'1e10f2a1-b146-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1e10f2a1-b146-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_9e237a53-4c20-4704-aad8-66e7d28d880b_SESS_85bc7802-1247-4b5a-a69b-2ac3c413cdaf_BOSC_beb4dc99-a13d-468b-8dbe-d1f319c1aa8b_PLY_','2021-02-11 15:55:28','2020-06-18 11:28:40','1e10f2a1-b146-11ea-947d-226cec7cb58a.ply','2021-02-11 16:55:28','SYNCED','1e10f2a1-b146-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.64.1.1\",\"modelMatrix\":\"-0.998196,0.0558626,-0.0220158,0,-0.0600444,-0.928677,0.365997,0,-6.07763e-10,0.366659,0.930355,0,-18.4515,15.8444,-20.0367,1\",\"title\":\"Mandibule PLY\"}'),(2,'1e137b00-b146-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1e137b00-b146-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_4a323cd2-36f1-422e-bd71-f55792a8d30e_ACT_9e237a53-4c20-4704-aad8-66e7d28d880b_SESS_85bc7802-1247-4b5a-a69b-2ac3c413cdaf_TOSC_e8af2619-b59a-40a8-8cbd-345ffa7a521c_SNAPS_','2021-02-11 15:55:28','2020-06-18 11:26:11','1e137b00-b146-11ea-947d-226cec7cb58a.png','2021-02-11 16:55:28','SYNCED','1e137b00-b146-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.64.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'1e15b420-b146-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1e15b420-b146-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_9e237a53-4c20-4704-aad8-66e7d28d880b_SESS_85bc7802-1247-4b5a-a69b-2ac3c413cdaf_BOSC_beb4dc99-a13d-468b-8dbe-d1f319c1aa8b_SNAPS_','2021-02-11 15:55:28','2020-06-18 11:28:40','1e15b420-b146-11ea-947d-226cec7cb58a.png','2021-02-11 16:55:28','SYNCED','1e15b420-b146-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.64.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'1e1826f2-b146-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1e1826f2-b146-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_4a323cd2-36f1-422e-bd71-f55792a8d30e_ACT_9e237a53-4c20-4704-aad8-66e7d28d880b_SESS_85bc7802-1247-4b5a-a69b-2ac3c413cdaf_TOSC_e8af2619-b59a-40a8-8cbd-345ffa7a521c_PLY_','2021-02-11 15:55:28','2020-06-18 11:26:11','1e1826f2-b146-11ea-947d-226cec7cb58a.ply','2021-02-11 16:55:28','SYNCED','1e1826f2-b146-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.64.1.1\",\"modelMatrix\":\"0.769332,-0.588987,0.24743,0,0.638849,0.709287,-0.297967,0,-1.36248e-8,0.387306,0.921951,0,2.85742,-31.529,-16.7299,1\",\"title\":\"Maxillaire PLY\"}'),(2,'1e32e78b-06a7-4bcf-bbf8-653a05317785','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1e32e78b-06a7-4bcf-bbf8-653a05317785.ply','PLY','PATIENT_9d8ee3c4-279c-49f6-84a5-c72a6bbb261a_ACT_3f4ac314-88e9-4b46-ad3d-7b6efca66cd6_SESS_3332cf67-cbb4-48cd-85a3-8b8d4c6b2db2_TOSC_47d38377-f708-4fb7-ad57-293bde29ce57_PLY_','2022-02-01 11:47:58','2019-07-17 08:34:58','1e32e78b-06a7-4bcf-bbf8-653a05317785.ply','2022-02-01 12:47:58','SYNCED','1e32e78b-06a7-4bcf-bbf8-653a05317785',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1\",\"modelMatrix\":\"0.490625,-0.84762,0.202058,0,0.871371,0.477252,-0.113769,0,-2.64867e-9,0.231885,0.972743,0,-1.38975,-34.262,-24.4648,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1e44f23e-6abc-4750-9dac-75077a14183c','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1e44f23e-6abc-4750-9dac-75077a14183c.ply','PLY','PATIENT_cadfb79e-7de5-4015-97e3-269a77999943_ACT_087c4066-ec0b-4035-93aa-10a106e71f3b_SESS_076eb8ca-e04f-483c-b1b1-7caa3017af15_TOSC_619e33ae-800e-448c-a6e2-89895e888cf8_PLY_','2022-03-04 13:40:28','2019-07-01 17:33:08','1e44f23e-6abc-4750-9dac-75077a14183c.ply','2022-03-04 14:40:28','SYNCED','1e44f23e-6abc-4750-9dac-75077a14183c',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.2.1.1\",\"modelMatrix\":\"-0.556781,-0.811499,0.177381,0,0.830659,-0.543938,0.118897,0,-9.27662e-10,0.213543,0.976934,0,11.8106,-25.434,-16.8691,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1e57db0f-bc4d-4e8a-b8fe-311824240b9f','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1e57db0f-bc4d-4e8a-b8fe-311824240b9f.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_4d5f9849-771f-4905-b4af-9f54867d3981_SESS_634356c8-f0f1-4841-b539-8f2ec59be200_BOSC_7cba2d58-2100-46e7-99be-c0c289fca438_SNAPS_','2021-02-11 15:55:29','2020-05-27 13:42:11','1e57db0f-bc4d-4e8a-b8fe-311824240b9f.png','2021-02-11 16:55:29','SYNCED','1e57db0f-bc4d-4e8a-b8fe-311824240b9f',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 216.1.14.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'1e6ee19e-ee80-4cd3-bf28-5cf01a7a29a8','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1e6ee19e-ee80-4cd3-bf28-5cf01a7a29a8.ply','PLY','PATIENT_c9dbaf18-0fb2-4968-b361-68c173abadee_ACT_4e71ec6a-14de-49f1-94a7-a434f3d543ed_SESS_e5cc07c8-892b-4ec6-9fac-a0b5b66356ec_TOSC_920f7df6-b178-46f7-bda7-aad391070154_PLY_','2021-02-11 15:55:29','2019-12-31 13:46:07','1e6ee19e-ee80-4cd3-bf28-5cf01a7a29a8.ply','2021-02-11 16:55:29','SYNCED','1e6ee19e-ee80-4cd3-bf28-5cf01a7a29a8',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"modelMatrix\":\"-0.983141,0.178659,-0.0389306,0,-0.182851,-0.960599,0.209319,0,-7.61736e-10,0.212908,0.977072,0,-3.10135,17.6651,-20.0538,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'1e926896-06f7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1e926896-06f7-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_db56cba1-23ff-48bf-b86e-4ceff749087f_TOSC_95ba1b04-bad8-4550-9b06-d48a2e72b1f6_SNAPS_','2021-12-30 18:04:01','2019-11-14 14:39:44','1e926896-06f7-11ea-947d-226cec7cb58a.png','2021-12-30 19:04:01','SYNCED','1e926896-06f7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 202.1.1.2\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'1e93f7c6-06f7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1e93f7c6-06f7-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_db56cba1-23ff-48bf-b86e-4ceff749087f_TOSC_95ba1b04-bad8-4550-9b06-d48a2e72b1f6_PLY_','2021-12-30 18:04:01','2019-11-14 14:39:44','1e93f7c6-06f7-11ea-947d-226cec7cb58a.ply','2021-12-30 19:04:01','SYNCED','1e93f7c6-06f7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 202.1.1.2\",\"modelMatrix\":\"0.54134,-0.789131,0.290213,0,0.840804,0.508071,-0.18685,0,2.00403e-8,0.345162,0.938543,0,-0.711634,-32.4033,-23.4657,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1e94366c-05df-4804-8361-0d54a98dba2d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1e94366c-05df-4804-8361-0d54a98dba2d.png','SNAPS','PATIENT_37924e66-6fca-42d1-866c-8897f314ef35_ACT_b97bc99b-fc77-46b8-82b7-151aef0aec54_SESS_f2ff3c9a-d754-4dd6-9785-85c513b9862b_LESC_7c4ff61d-52b3-4fa3-9db6-a80fccbeef76_SNAPS_','2022-02-01 11:47:58','2019-09-05 11:45:40','1e94366c-05df-4804-8361-0d54a98dba2d.png','2022-02-01 12:47:58','SYNCED','1e94366c-05df-4804-8361-0d54a98dba2d',0,NULL,'','','{\"displayTitle\":\"MORDU_POSTERIEUR_GAUCHE 145.1.1.1\",\"title\":\"MORDU_POSTERIEUR_GAUCHE SNAPSHOT\"}'),(2,'1e956e4b-06f7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1e956e4b-06f7-11ea-947d-226cec7cb58a.stl','STL','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_db56cba1-23ff-48bf-b86e-4ceff749087f_BOSC_13426cff-cd00-406a-a148-c0495f254285_STL_','2021-12-30 18:04:02','2019-11-14 16:09:54','1e956e4b-06f7-11ea-947d-226cec7cb58a.stl','2021-12-30 19:04:02','SYNCED','1e956e4b-06f7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 202.1.1.2\",\"modelMatrix\":\"-0.993005,-0.110956,0.0403736,0,0.118073,-0.93315,0.339544,0,-1.71207e-9,0.341936,0.939723,0,-21.1567,9.45214,-24.4188,1\",\"title\":\"MANDIBULE STL\"}'),(2,'1e96d678-06f7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1e96d678-06f7-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_db56cba1-23ff-48bf-b86e-4ceff749087f_BOSC_13426cff-cd00-406a-a148-c0495f254285_SNAPS_','2021-12-30 18:04:02','2019-11-14 16:09:54','1e96d678-06f7-11ea-947d-226cec7cb58a.png','2021-12-30 19:04:02','SYNCED','1e96d678-06f7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 202.1.1.2\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'1e982a5d-06f7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1e982a5d-06f7-11ea-947d-226cec7cb58a.stl','STL','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_db56cba1-23ff-48bf-b86e-4ceff749087f_TOSC_95ba1b04-bad8-4550-9b06-d48a2e72b1f6_STL_','2021-12-30 18:04:02','2019-11-14 14:39:44','1e982a5d-06f7-11ea-947d-226cec7cb58a.stl','2021-12-30 19:04:02','SYNCED','1e982a5d-06f7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 202.1.1.2\",\"modelMatrix\":\"0.54134,-0.789131,0.290213,0,0.840804,0.508071,-0.18685,0,2.00403e-8,0.345162,0.938543,0,-0.711634,-32.4033,-23.4657,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'1e99922f-06f7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1e99922f-06f7-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_db56cba1-23ff-48bf-b86e-4ceff749087f_BOSC_13426cff-cd00-406a-a148-c0495f254285_PLY_','2021-12-30 18:04:02','2019-11-14 16:09:54','1e99922f-06f7-11ea-947d-226cec7cb58a.ply','2021-12-30 19:04:02','SYNCED','1e99922f-06f7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 202.1.1.2\",\"modelMatrix\":\"-0.993005,-0.110956,0.0403736,0,0.118073,-0.93315,0.339544,0,-1.71207e-9,0.341936,0.939723,0,-21.1567,9.45214,-24.4188,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'1ea7d82d-a7c8-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1ea7d82d-a7c8-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_42f1168d-7e4d-4574-9695-1bb3c7af4f61_ACT_5f10eca4-62d0-44ae-96ec-54c8413298eb_SESS_1e0d7fa4-8337-4681-a87b-a30c32238dc0_BOSC_7bb27809-7253-4bf4-9c66-0ad2ff3bed50_SNAPS_','2022-02-01 11:47:59','2019-07-16 16:55:45','1ea7d82d-a7c8-11e9-a33b-226cec7cb58a.png','2022-02-01 12:47:59','SYNCED','1ea7d82d-a7c8-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 82.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'1ea878b8-a7c8-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1ea878b8-a7c8-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_42f1168d-7e4d-4574-9695-1bb3c7af4f61_ACT_5f10eca4-62d0-44ae-96ec-54c8413298eb_SESS_1e0d7fa4-8337-4681-a87b-a30c32238dc0_BOSC_7bb27809-7253-4bf4-9c66-0ad2ff3bed50_PLY_','2022-02-01 11:47:59','2019-07-16 16:55:45','1ea878b8-a7c8-11e9-a33b-226cec7cb58a.ply','2022-02-01 12:47:59','SYNCED','1ea878b8-a7c8-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 82.1.1.1\",\"modelMatrix\":\"-0.19456,0.976988,-0.0874083,0,-0.980891,-0.193786,0.0173374,0,-6.67926e-10,0.0891111,0.996022,0,18.394,20.3191,-17.7894,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'1ea90b2e-a7c8-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1ea90b2e-a7c8-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_42f1168d-7e4d-4574-9695-1bb3c7af4f61_ACT_5f10eca4-62d0-44ae-96ec-54c8413298eb_SESS_1e0d7fa4-8337-4681-a87b-a30c32238dc0_BOSC_7bb27809-7253-4bf4-9c66-0ad2ff3bed50_STL_','2022-02-01 11:47:59','2019-07-16 16:55:45','1ea90b2e-a7c8-11e9-a33b-226cec7cb58a.stl','2022-02-01 12:47:59','SYNCED','1ea90b2e-a7c8-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 82.1.1.1\",\"modelMatrix\":\"-0.19456,0.976988,-0.0874083,0,-0.980891,-0.193786,0.0173374,0,-6.67926e-10,0.0891111,0.996022,0,18.394,20.3191,-17.7894,1\",\"title\":\"MANDIBULE STL\"}'),(2,'1ea990e7-a7c8-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1ea990e7-a7c8-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_42f1168d-7e4d-4574-9695-1bb3c7af4f61_ACT_5f10eca4-62d0-44ae-96ec-54c8413298eb_SESS_1e0d7fa4-8337-4681-a87b-a30c32238dc0_TOSC_0548c508-dcdb-4a4d-b1c1-090af1ae5afd_STL_','2022-02-01 11:47:59','2019-07-16 16:49:16','1ea990e7-a7c8-11e9-a33b-226cec7cb58a.stl','2022-02-01 12:47:59','SYNCED','1ea990e7-a7c8-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 82.1.1.1\",\"modelMatrix\":\"0.510103,-0.799415,0.317382,0,0.860113,0.474105,-0.188228,0,4.47857e-9,0.369,0.929429,0,-3.7318,-40.4103,-21.1885,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'1eaa12c2-a7c8-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1eaa12c2-a7c8-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_42f1168d-7e4d-4574-9695-1bb3c7af4f61_ACT_5f10eca4-62d0-44ae-96ec-54c8413298eb_SESS_1e0d7fa4-8337-4681-a87b-a30c32238dc0_TOSC_0548c508-dcdb-4a4d-b1c1-090af1ae5afd_SNAPS_','2022-02-01 11:47:59','2019-07-16 16:49:16','1eaa12c2-a7c8-11e9-a33b-226cec7cb58a.png','2022-02-01 12:47:59','SYNCED','1eaa12c2-a7c8-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 82.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'1eaa9c07-a7c8-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1eaa9c07-a7c8-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_42f1168d-7e4d-4574-9695-1bb3c7af4f61_ACT_5f10eca4-62d0-44ae-96ec-54c8413298eb_SESS_1e0d7fa4-8337-4681-a87b-a30c32238dc0_TOSC_0548c508-dcdb-4a4d-b1c1-090af1ae5afd_PLY_','2022-02-01 11:47:59','2019-07-16 16:49:16','1eaa9c07-a7c8-11e9-a33b-226cec7cb58a.ply','2022-02-01 12:47:59','SYNCED','1eaa9c07-a7c8-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 82.1.1.1\",\"modelMatrix\":\"0.510103,-0.799415,0.317382,0,0.860113,0.474105,-0.188228,0,4.47857e-9,0.369,0.929429,0,-3.7318,-40.4103,-21.1885,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1ecb3e1c-4419-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1ecb3e1c-4419-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_a730394c-024c-4469-9597-1dc64fff623b_ACT_7c775d8a-c5f0-4242-92b0-3fd02fa5428f_SESS_715397ea-ceae-49f7-99c6-0010425952e2_BOSC_74fb105f-4735-474c-b50b-34c833e3b3cc_SNAPS_','2021-02-11 15:55:32','2020-01-31 12:00:40','1ecb3e1c-4419-11ea-947d-226cec7cb58a.png','2021-02-11 16:55:32','SYNCED','1ecb3e1c-4419-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 25.1.1.4.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'1ecd96e4-4419-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1ecd96e4-4419-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_a730394c-024c-4469-9597-1dc64fff623b_ACT_7c775d8a-c5f0-4242-92b0-3fd02fa5428f_SESS_715397ea-ceae-49f7-99c6-0010425952e2_BOSC_74fb105f-4735-474c-b50b-34c833e3b3cc_PLY_','2021-02-11 15:55:32','2020-01-31 12:00:40','1ecd96e4-4419-11ea-947d-226cec7cb58a.ply','2021-02-11 16:55:32','SYNCED','1ecd96e4-4419-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 25.1.1.4.1.1\",\"modelMatrix\":\"-0.940811,0.325397,-0.0948192,0,-0.338931,-0.903245,0.263201,0,1.51664e-9,0.27976,0.96007,0,-8.74586,17.0876,-15.5974,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'1ecf428f-f599-461f-83df-85a40c24fef7','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1ecf428f-f599-461f-83df-85a40c24fef7.png','SNAPS','PATIENT_60c51933-26a9-4f4a-83e7-2357f09a083a_ACT_b36010b8-72bf-4254-8155-52613f8ac41e_SESS_3a951625-b6f7-490e-8bc9-1338cfa93e33_BOSC_3f940d17-bff9-4a82-add4-47c55280c5ed_SNAPS_','2022-02-01 11:48:00','2019-07-22 11:31:53','1ecf428f-f599-461f-83df-85a40c24fef7.png','2022-02-01 12:48:00','SYNCED','1ecf428f-f599-461f-83df-85a40c24fef7',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 104.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'1ecfb201-4419-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1ecfb201-4419-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_a730394c-024c-4469-9597-1dc64fff623b_ACT_7c775d8a-c5f0-4242-92b0-3fd02fa5428f_SESS_715397ea-ceae-49f7-99c6-0010425952e2_TOSC_88ead517-587d-487f-b46a-1239f78a6997_PLY_','2021-02-11 15:55:32','2020-01-31 11:55:48','1ecfb201-4419-11ea-947d-226cec7cb58a.ply','2021-02-11 16:55:32','SYNCED','1ecfb201-4419-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 25.1.1.4.1.1\",\"modelMatrix\":\"0.295176,-0.922413,0.249048,0,0.955443,0.284972,-0.0769411,0,5.86135e-9,0.260662,0.96543,0,-10.2389,-35.5771,-21.9996,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1ed22772-4419-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1ed22772-4419-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_a730394c-024c-4469-9597-1dc64fff623b_ACT_7c775d8a-c5f0-4242-92b0-3fd02fa5428f_SESS_715397ea-ceae-49f7-99c6-0010425952e2_TOSC_88ead517-587d-487f-b46a-1239f78a6997_SNAPS_','2021-02-11 15:55:33','2020-01-31 11:55:48','1ed22772-4419-11ea-947d-226cec7cb58a.png','2021-02-11 16:55:33','SYNCED','1ed22772-4419-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 25.1.1.4.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'1edeca1f-8460-43cc-8557-ab185edf79d9','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1edeca1f-8460-43cc-8557-ab185edf79d9.stl','STL','PATIENT_b4908dda-5d76-4e35-849e-e08780817f2e_ACT_daf35305-351d-42c6-9799-5882d57a3476_SESS_758b6d2c-f72a-49d9-9fea-a57718467959_TOSC_771664cd-d750-49a0-aa43-8b0cb7d8c509_STL_','2022-02-01 11:48:00','2019-07-22 16:54:02','1edeca1f-8460-43cc-8557-ab185edf79d9.stl','2022-02-01 12:48:00','SYNCED','1edeca1f-8460-43cc-8557-ab185edf79d9',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 109.1.1.1\",\"modelMatrix\":\"0.270412,-0.852394,0.44755,0,0.962745,0.239417,-0.125706,0,6.15896e-10,0.464869,0.885379,0,-14.8973,-40.0409,-26.1509,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'1ee107f5-a16a-4b5e-b921-fbe1878e6cb7','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1ee107f5-a16a-4b5e-b921-fbe1878e6cb7.stl','STL','PATIENT_5cecd1d2-544b-4f12-aed7-e956f4534c34_ACT_4d4e2801-1d6b-4f74-af08-8d5715fa0f30_SESS_5fc19491-cea4-4af8-bb68-ed00a7cf21cf_TOSC_9b84b8e4-18c4-4153-b8a3-82ad3dbd05b5_STL_','2021-08-19 22:41:43','2019-12-02 16:05:14','1ee107f5-a16a-4b5e-b921-fbe1878e6cb7.stl','2021-08-20 00:41:43','SYNCED','1ee107f5-a16a-4b5e-b921-fbe1878e6cb7',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 219.1.1.1\",\"modelMatrix\":\"0.784679,-0.522681,0.333291,0,0.619902,0.661616,-0.421884,0,-9.45797e-9,0.537652,0.843167,0,10.4613,-36.045,-19.5402,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'1efbac6c-b49d-4760-ae0c-be1c41bd7de2','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1efbac6c-b49d-4760-ae0c-be1c41bd7de2.stl','STL','PATIENT_f8f4fd0f-dc97-4b11-9286-86eaf67fb5cb_ACT_bf86aebf-fadb-4a91-a6f6-11f29cebf495_SESS_18d45998-bb23-48fc-abf3-f17f12f8d8b6_BOSC_58e6b3bf-fd55-48a6-bf83-601c93c68e71_STL_','2022-02-01 11:48:00','2019-09-18 10:18:55','1efbac6c-b49d-4760-ae0c-be1c41bd7de2.stl','2022-02-01 12:48:00','SYNCED','1efbac6c-b49d-4760-ae0c-be1c41bd7de2',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 150.1.1.1\",\"modelMatrix\":\"0.715123,-0.659481,0.2317,0,0.698999,0.674693,-0.237045,0,2.63167e-9,0.331474,0.943464,0,2.21702,-30.8157,-25.6092,1\",\"title\":\"MANDIBULE STL\"}'),(2,'1f02d512-4329-4c82-a0cf-329cb193c634','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1f02d512-4329-4c82-a0cf-329cb193c634.ply','PLY','PATIENT_7fcdb9e0-636c-4d7e-b8af-e3ce69be84ce_ACT_16bd83ca-3f07-4021-80cc-302935ee3226_SESS_3ade4a4b-4a11-440c-8f17-176f1f9542ed_BOSC_20e24c2c-6e01-442a-9367-5b5485e0f99f_PLY_','2021-12-30 18:04:06','2019-10-25 10:30:05','1f02d512-4329-4c82-a0cf-329cb193c634.ply','2021-12-30 19:04:06','SYNCED','1f02d512-4329-4c82-a0cf-329cb193c634',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 195.1.1.1\",\"modelMatrix\":\"-0.58739,0.80609,-0.0720569,0,-0.809304,-0.585057,0.0522985,0,-1.98276e-9,0.0890356,0.996028,0,5.65365,16.8097,-28.3517,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'1f106dd0-24bc-4b2e-ba4d-26dec8626444','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1f106dd0-24bc-4b2e-ba4d-26dec8626444.png','SNAPS','PATIENT_7999473e-e556-4557-832b-32238063b37a_ACT_f34901e5-54f1-492c-a4a2-44e130fbc20a_SESS_8648b8e9-7e51-4f6c-9088-9a7c72129004_BOSC_d3923049-41ea-4195-a5ad-dcebb9485dc1_SNAPS_','2021-02-11 15:55:33','2020-01-21 11:23:22','1f106dd0-24bc-4b2e-ba4d-26dec8626444.png','2021-02-11 16:55:33','SYNCED','1f106dd0-24bc-4b2e-ba4d-26dec8626444',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.1.1.1.2\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'1f2b8a1b-9901-4f54-9f4e-3139d037ae6f','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1f2b8a1b-9901-4f54-9f4e-3139d037ae6f.png','SNAPS','PATIENT_dc22ff59-246c-4251-8dd8-97142da6dfed_ACT_93f941e2-7abf-4cba-b918-04a6605a6ff8_SESS_4ff908c3-af69-46e7-8264-aad72b82c589_BOSC_59f5fe74-d1ac-408a-a2b5-00fd9a089d13_SNAPS_','2021-12-30 18:04:06','2019-10-25 16:24:25','1f2b8a1b-9901-4f54-9f4e-3139d037ae6f.png','2021-12-30 19:04:06','SYNCED','1f2b8a1b-9901-4f54-9f4e-3139d037ae6f',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 194.3.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'1f3ae044-d964-4d9d-bb6a-37d4128bf31c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1f3ae044-d964-4d9d-bb6a-37d4128bf31c.stl','STL','PATIENT_d5ef196c-173b-490b-a478-f1ca17a88256_ACT_c1343c91-e8d4-4698-93d9-578e6f8f45b5_SESS_621ec82a-dd13-4c37-8944-c6c9466fef1e_TOSC_cb28f2d2-cfc8-4a44-972c-b60b6aafe6c0_STL_','2021-08-19 22:41:46','2019-12-02 19:15:20','1f3ae044-d964-4d9d-bb6a-37d4128bf31c.stl','2021-08-20 00:41:46','SYNCED','1f3ae044-d964-4d9d-bb6a-37d4128bf31c',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 223.1.1.1\",\"modelMatrix\":\"0.795456,-0.582,0.168897,0,0.606012,0.763938,-0.221695,0,1.65161e-9,0.278702,0.960378,0,1.97259,-34.558,-22.9913,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'1f419263-3dc1-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1f419263-3dc1-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_e230cce6-18ae-45e3-9bee-19e55a71491a_SESS_3bff5a71-f41f-43f5-8db2-cc0d2c7feeb9_BOSC_75127b69-d348-4daa-9eaf-8c49b56b32cc_PLY_','2021-02-11 15:55:35','2020-01-23 10:16:57','1f419263-3dc1-11ea-947d-226cec7cb58a.ply','2021-02-11 16:55:35','SYNCED','1f419263-3dc1-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.1.1.1.1\",\"modelMatrix\":\"-0.149375,0.985062,-0.0856769,0,-0.988781,-0.148813,0.0129432,0,7.5638e-10,0.0866491,0.996239,0,14.8472,13.0978,-19.1061,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'1f436d1b-3dc1-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1f436d1b-3dc1-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_e230cce6-18ae-45e3-9bee-19e55a71491a_SESS_3bff5a71-f41f-43f5-8db2-cc0d2c7feeb9_BOSC_75127b69-d348-4daa-9eaf-8c49b56b32cc_SNAPS_','2021-02-11 15:55:35','2020-01-23 10:16:57','1f436d1b-3dc1-11ea-947d-226cec7cb58a.png','2021-02-11 16:55:35','SYNCED','1f436d1b-3dc1-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'1f4530f1-3dc1-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1f4530f1-3dc1-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_6718c0be-a8a8-47c1-af11-f08fd85f089d_ACT_e230cce6-18ae-45e3-9bee-19e55a71491a_SESS_3bff5a71-f41f-43f5-8db2-cc0d2c7feeb9_TOSC_ced88f3d-bc46-41e3-b23c-acc0222ab868_PLY_','2021-02-11 15:55:35','2020-01-23 10:14:16','1f4530f1-3dc1-11ea-947d-226cec7cb58a.ply','2021-02-11 16:55:35','SYNCED','1f4530f1-3dc1-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.1.1.1.1\",\"modelMatrix\":\"0.714535,-0.648102,0.263444,0,0.699599,0.661939,-0.269068,0,2.28956e-9,0.376564,0.926391,0,9.45057,-36.2583,-16.6615,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1f46d499-3dc1-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1f46d499-3dc1-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_6718c0be-a8a8-47c1-af11-f08fd85f089d_ACT_e230cce6-18ae-45e3-9bee-19e55a71491a_SESS_3bff5a71-f41f-43f5-8db2-cc0d2c7feeb9_TOSC_ced88f3d-bc46-41e3-b23c-acc0222ab868_SNAPS_','2021-02-11 15:55:35','2020-01-23 10:14:16','1f46d499-3dc1-11ea-947d-226cec7cb58a.png','2021-02-11 16:55:35','SYNCED','1f46d499-3dc1-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'1f4e97ef-9473-4a66-9a9e-bd2b8003e152','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1f4e97ef-9473-4a66-9a9e-bd2b8003e152.stl','STL','PATIENT_bc50bff3-dacb-4f7a-a7c8-b971782c6d1d_ACT_be5de36f-b43d-47f3-b178-801c7822bb7d_SESS_df767eeb-30cd-456e-91c0-aa5269ac29d4_TOSC_da25aded-3d97-41a1-b4c3-a9efa0a41453_STL_','2021-08-19 22:41:47','2019-11-27 17:20:43','1f4e97ef-9473-4a66-9a9e-bd2b8003e152.stl','2021-08-20 00:41:47','SYNCED','1f4e97ef-9473-4a66-9a9e-bd2b8003e152',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 212.1.1.1\",\"modelMatrix\":\"0.617506,-0.743854,0.255671,0,0.786566,0.583974,-0.200718,0,3.26907e-9,0.325046,0.945698,0,6.19484,-35.1006,-15.9214,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'1f56b121-2722-4c39-9c35-2c458b9c763c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1f56b121-2722-4c39-9c35-2c458b9c763c.ply','PLY','PATIENT_04e69d75-91c9-45a9-adfc-916028c83220_ACT_9ac41709-266d-46c7-a5d6-c38801e11232_SESS_d5fff860-73d3-4cdc-9e34-2bd0e66bbd7c_TOSC_ca12970f-05b9-4dae-bcdc-d4774899ec88_PLY_','2021-02-11 15:55:36','2020-06-05 10:08:31','1f56b121-2722-4c39-9c35-2c458b9c763c.ply','2021-02-11 16:55:36','SYNCED','1f56b121-2722-4c39-9c35-2c458b9c763c',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.20.1.1\",\"modelMatrix\":\"0.189497,-0.949507,0.250054,0,0.981881,0.183249,-0.0482587,0,-4.12684e-10,0.254668,0.967029,0,-11.727,-28.3111,-16.92,1\",\"title\":\"Maxillaire PLY\"}'),(2,'1f5aed97-ed38-471c-9a74-c5eb8c97e7b2','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1f5aed97-ed38-471c-9a74-c5eb8c97e7b2.ply','PLY','PATIENT_bf0229a2-1f18-4741-990a-d5f5f2c124ff_ACT_6c32b5e7-394b-4560-8eda-af25b87783aa_SESS_bf8b4446-bd97-4257-99ba-7a619b1fe1b0_BOSC_182e8ef8-e9e5-4fcf-8638-fba623358a5f_PLY_','2022-02-01 11:48:00','2019-07-15 15:29:37','1f5aed97-ed38-471c-9a74-c5eb8c97e7b2.ply','2022-02-01 12:48:00','SYNCED','1f5aed97-ed38-471c-9a74-c5eb8c97e7b2',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 65.1.1.1\",\"modelMatrix\":\"-0.657607,-0.753005,0.0231713,0,0.753361,-0.657296,0.0202261,0,1.16224e-9,0.0307572,0.999527,0,-25.3821,-1.19214,-25.4768,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'1f6969c4-759c-4717-b193-db795c94e139','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1f6969c4-759c-4717-b193-db795c94e139.stl','STL','PATIENT_9d8ee3c4-279c-49f6-84a5-c72a6bbb261a_ACT_3f4ac314-88e9-4b46-ad3d-7b6efca66cd6_SESS_3332cf67-cbb4-48cd-85a3-8b8d4c6b2db2_BOSC_975827b1-5db0-464d-a41e-c69d519dba7c_STL_','2022-02-01 11:48:00','2019-07-17 08:29:45','1f6969c4-759c-4717-b193-db795c94e139.stl','2022-02-01 12:48:00','SYNCED','1f6969c4-759c-4717-b193-db795c94e139',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1\",\"modelMatrix\":\"-0.99389,0.107773,-0.0238188,0,-0.110374,-0.970471,0.214483,0,6.71358e-10,0.215802,0.976437,0,-13.2696,19.471,-32.4185,1\",\"title\":\"MANDIBULE STL\"}'),(2,'1f6b5642-7b05-48e1-a9cb-83ca0e055368','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1f6b5642-7b05-48e1-a9cb-83ca0e055368.png','SNAPS','PATIENT_c0cb70de-94b5-4ad1-8096-f1713ade0ce1_ACT_7b78ee76-d591-4a20-94ed-fa3498e1fe9c_SESS_cdccf1b9-9263-4647-a7af-3daca544410f_BOSC_740a54bf-8ad8-4b87-b29d-717c03c2ecef_SNAPS_','2022-02-01 11:48:01','2019-07-17 17:06:05','1f6b5642-7b05-48e1-a9cb-83ca0e055368.png','2022-02-01 12:48:01','SYNCED','1f6b5642-7b05-48e1-a9cb-83ca0e055368',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 94.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'1f87c088-e1d1-45ec-b9c2-0177a85188af','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1f87c088-e1d1-45ec-b9c2-0177a85188af.png','SNAPS','PATIENT_f0e9b45a-b2a9-4688-a8fd-a7f9b92ae62d_ACT_6e50aa1c-456f-4c69-8ccf-86be647c761d_SESS_64fd8d5c-ea39-4ace-b052-b09520e46f44_TOSC_df7440e1-f173-4de6-8f2d-7c894174014b_SNAPS_','2022-02-01 11:48:01','2019-07-16 11:52:38','1f87c088-e1d1-45ec-b9c2-0177a85188af.png','2022-02-01 12:48:01','SYNCED','1f87c088-e1d1-45ec-b9c2-0177a85188af',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 77.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'1f901cce-2d75-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1f901cce-2d75-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_1a6e510c-e9f1-4208-854b-f48c05344668_ACT_eca0ed7b-94b1-422a-995c-fb82d252cbe4_SESS_14990dc2-cc01-4750-914c-3a5c5816d1c2_TOSC_43f2c975-4a91-4301-984e-9610cb9f171b_SNAPS_','2021-02-11 15:55:36','2020-01-02 16:29:21','1f901cce-2d75-11ea-947d-226cec7cb58a.png','2021-02-11 16:55:36','SYNCED','1f901cce-2d75-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'1f91b72d-2d75-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1f91b72d-2d75-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_1a6e510c-e9f1-4208-854b-f48c05344668_ACT_eca0ed7b-94b1-422a-995c-fb82d252cbe4_SESS_14990dc2-cc01-4750-914c-3a5c5816d1c2_TOSC_43f2c975-4a91-4301-984e-9610cb9f171b_PLY_','2021-02-11 15:55:36','2020-01-02 16:29:21','1f91b72d-2d75-11ea-947d-226cec7cb58a.ply','2021-02-11 16:55:36','SYNCED','1f91b72d-2d75-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"modelMatrix\":\"0.582599,-0.790509,0.188877,0,0.81276,0.566649,-0.13539,0,1.3451e-8,0.232389,0.972623,0,-0.458175,-38.7294,-17.9786,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1f92088b-096e-4c1d-84ce-4a3b54e0539f','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1f92088b-096e-4c1d-84ce-4a3b54e0539f.stl','STL','PATIENT_d4c7e589-712b-45fa-8b2d-3f3c9661bf0b_ACT_3ee02514-2ffd-4c5c-967c-82ae7f8ff8c3_SESS_d5d64b70-3623-40ea-ba14-ea2dcb5c4d3f_TOSC_5a957eef-f672-4a80-a3cd-252622b8f74b_STL_','2021-12-30 18:04:07','2019-10-07 14:17:57','1f92088b-096e-4c1d-84ce-4a3b54e0539f.stl','2021-12-30 19:04:07','SYNCED','1f92088b-096e-4c1d-84ce-4a3b54e0539f',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 180.1.1.1\",\"modelMatrix\":\"0.631263,-0.697302,0.339525,0,0.775569,0.567559,-0.276351,0,-1.95185e-9,0.437775,0.899085,0,-2.07739,-35.1764,-22.4309,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'1f93ad58-2d75-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1f93ad58-2d75-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_eca0ed7b-94b1-422a-995c-fb82d252cbe4_SESS_14990dc2-cc01-4750-914c-3a5c5816d1c2_BOSC_bb4f83db-c271-477a-9e6b-2ef56b7d3cfb_PLY_','2021-02-11 15:55:37','2020-01-02 16:32:29','1f93ad58-2d75-11ea-947d-226cec7cb58a.ply','2021-02-11 16:55:37','SYNCED','1f93ad58-2d75-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"modelMatrix\":\"-0.882186,0.448218,-0.144392,0,-0.470902,-0.83969,0.270503,0,2.91688e-9,0.306628,0.951829,0,-2.77658,18.3266,-19.7748,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'1f953a37-2d75-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1f953a37-2d75-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_eca0ed7b-94b1-422a-995c-fb82d252cbe4_SESS_14990dc2-cc01-4750-914c-3a5c5816d1c2_BOSC_bb4f83db-c271-477a-9e6b-2ef56b7d3cfb_SNAPS_','2021-02-11 15:55:37','2020-01-02 16:32:29','1f953a37-2d75-11ea-947d-226cec7cb58a.png','2021-02-11 16:55:37','SYNCED','1f953a37-2d75-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'1fa0d836-e8fa-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1fa0d836-e8fa-11e9-947d-226cec7cb58a.stl','STL','PATIENT_e955e2f3-95a0-4c0c-b4c5-49cb70046fd3_ACT_b3e8e44c-3ca7-4505-a896-5be6ac27e3de_SESS_8501ff91-e691-4166-af1f-6f918fe635ba_BOSC_86856d52-f993-465c-9f45-fb08eaaf985a_STL_','2021-12-30 18:04:08','2019-10-07 13:59:20','1fa0d836-e8fa-11e9-947d-226cec7cb58a.stl','2021-12-30 19:04:08','SYNCED','1fa0d836-e8fa-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 178.1.1.1\",\"modelMatrix\":\"0.75317,0.655171,-0.0590366,0,-0.657825,0.750131,-0.0675934,0,-5.67112e-9,0.0897451,0.995965,0,29.4687,-13.094,-21.3834,1\",\"title\":\"MANDIBULE STL\"}'),(2,'1fa233c1-e8fa-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1fa233c1-e8fa-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_e955e2f3-95a0-4c0c-b4c5-49cb70046fd3_ACT_b3e8e44c-3ca7-4505-a896-5be6ac27e3de_SESS_8501ff91-e691-4166-af1f-6f918fe635ba_TOSC_5cbd57a4-1b7d-41f8-b732-f219bbb35ebd_PLY_','2021-12-30 18:04:08','2019-10-07 13:45:27','1fa233c1-e8fa-11e9-947d-226cec7cb58a.ply','2021-12-30 19:04:08','SYNCED','1fa233c1-e8fa-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 178.1.1.1\",\"modelMatrix\":\"0.458829,-0.854153,0.244741,0,0.888524,0.44108,-0.126383,0,3.21724e-9,0.275447,0.961316,0,-1.69042,-31.2163,-26.0246,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1fa376bb-e8fa-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1fa376bb-e8fa-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_e955e2f3-95a0-4c0c-b4c5-49cb70046fd3_ACT_b3e8e44c-3ca7-4505-a896-5be6ac27e3de_SESS_8501ff91-e691-4166-af1f-6f918fe635ba_TOSC_5cbd57a4-1b7d-41f8-b732-f219bbb35ebd_SNAPS_','2021-12-30 18:04:08','2019-10-07 13:45:27','1fa376bb-e8fa-11e9-947d-226cec7cb58a.png','2021-12-30 19:04:08','SYNCED','1fa376bb-e8fa-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 178.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'1fa451aa-615d-4f54-ba7d-a850da68b59e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1fa451aa-615d-4f54-ba7d-a850da68b59e.ply','PLY','PATIENT_8f2a30ae-f5f0-42c4-9e6c-369d6d815a83_ACT_d8442e32-491d-4b5e-88dd-348895bccb5f_SESS_6134d13f-57ab-4858-bdd8-c5d63443974b_BOSC_ee4ae791-64c8-497f-a87e-16b2df2ec92d_PLY_','2021-08-19 22:41:53','2019-12-02 19:08:00','1fa451aa-615d-4f54-ba7d-a850da68b59e.ply','2021-08-20 00:41:53','SYNCED','1fa451aa-615d-4f54-ba7d-a850da68b59e',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 222.1.1.1\",\"modelMatrix\":\"-0.977984,0.206312,-0.0313546,0,-0.208681,-0.966882,0.146943,0,-8.69058e-10,0.150251,0.988648,0,-9.16944,22.1473,-16.3793,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'1fa4a508-e8fa-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1fa4a508-e8fa-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_e955e2f3-95a0-4c0c-b4c5-49cb70046fd3_ACT_b3e8e44c-3ca7-4505-a896-5be6ac27e3de_SESS_8501ff91-e691-4166-af1f-6f918fe635ba_BOSC_86856d52-f993-465c-9f45-fb08eaaf985a_SNAPS_','2021-12-30 18:04:08','2019-10-07 13:59:20','1fa4a508-e8fa-11e9-947d-226cec7cb58a.png','2021-12-30 19:04:08','SYNCED','1fa4a508-e8fa-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 178.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'1fa5f255-e8fa-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1fa5f255-e8fa-11e9-947d-226cec7cb58a.stl','STL','PATIENT_e955e2f3-95a0-4c0c-b4c5-49cb70046fd3_ACT_b3e8e44c-3ca7-4505-a896-5be6ac27e3de_SESS_8501ff91-e691-4166-af1f-6f918fe635ba_TOSC_5cbd57a4-1b7d-41f8-b732-f219bbb35ebd_STL_','2021-12-30 18:04:08','2019-10-07 13:45:27','1fa5f255-e8fa-11e9-947d-226cec7cb58a.stl','2021-12-30 19:04:08','SYNCED','1fa5f255-e8fa-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 178.1.1.1\",\"modelMatrix\":\"0.458829,-0.854153,0.244741,0,0.888524,0.44108,-0.126383,0,3.21724e-9,0.275447,0.961316,0,-1.69042,-31.2163,-26.0246,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'1fa72947-e8fa-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1fa72947-e8fa-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_e955e2f3-95a0-4c0c-b4c5-49cb70046fd3_ACT_b3e8e44c-3ca7-4505-a896-5be6ac27e3de_SESS_8501ff91-e691-4166-af1f-6f918fe635ba_BOSC_86856d52-f993-465c-9f45-fb08eaaf985a_PLY_','2021-12-30 18:04:09','2019-10-07 13:59:20','1fa72947-e8fa-11e9-947d-226cec7cb58a.ply','2021-12-30 19:04:09','SYNCED','1fa72947-e8fa-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 178.1.1.1\",\"modelMatrix\":\"0.75317,0.655171,-0.0590366,0,-0.657825,0.750131,-0.0675934,0,-5.67112e-9,0.0897451,0.995965,0,29.4687,-13.094,-21.3834,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'1fa78ae8-1060-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1fa78ae8-1060-11ea-947d-226cec7cb58a.stl','STL','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_fd694b3f-abde-4e46-91f7-7c62bfdcafa4_SESS_73a3f5b9-e905-4911-a163-2022e1de3380_TOSC_bd43a869-97da-4c76-a8aa-a927299f912f_STL_','2021-08-19 22:41:57','2019-11-26 21:18:53','1fa78ae8-1060-11ea-947d-226cec7cb58a.stl','2021-08-20 00:41:57','SYNCED','1fa78ae8-1060-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"modelMatrix\":\"0.847928,-0.474534,0.236295,0,0.530112,0.75903,-0.377961,0,-7.86232e-10,0.445747,0.895159,0,13.0614,-37.576,-12.1213,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'1fa9e297-1060-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1fa9e297-1060-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_fd694b3f-abde-4e46-91f7-7c62bfdcafa4_SESS_73a3f5b9-e905-4911-a163-2022e1de3380_TOSC_bd43a869-97da-4c76-a8aa-a927299f912f_SNAPS_','2021-08-19 22:41:58','2019-11-26 21:18:53','1fa9e297-1060-11ea-947d-226cec7cb58a.png','2021-08-20 00:41:58','SYNCED','1fa9e297-1060-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'1fac0fbe-1060-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1fac0fbe-1060-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_fd694b3f-abde-4e46-91f7-7c62bfdcafa4_SESS_73a3f5b9-e905-4911-a163-2022e1de3380_TOSC_bd43a869-97da-4c76-a8aa-a927299f912f_PLY_','2021-08-19 22:41:58','2019-11-26 21:18:53','1fac0fbe-1060-11ea-947d-226cec7cb58a.ply','2021-08-20 00:41:58','SYNCED','1fac0fbe-1060-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"modelMatrix\":\"0.847928,-0.474534,0.236295,0,0.530112,0.75903,-0.377961,0,-7.86232e-10,0.445747,0.895159,0,13.0614,-37.576,-12.1213,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1fba7f0a-bb96-463b-a65d-a5f7e583129f','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1fba7f0a-bb96-463b-a65d-a5f7e583129f.ply','PLY','PATIENT_9a7fb011-3358-4d3c-a11d-cb262db47e63_ACT_8d3d24a8-8497-455b-a175-3c2ad080b066_SESS_4c947a81-1ce1-4f4b-9ced-98099e5c9e41_BOSC_1c6e5ffe-c555-4036-96c1-ff9513f7fd5d_PLY_','2022-03-04 13:40:28','2019-07-09 12:42:55','1fba7f0a-bb96-463b-a65d-a5f7e583129f.ply','2022-03-04 14:40:28','SYNCED','1fba7f0a-bb96-463b-a65d-a5f7e583129f',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 11.1.2.1\",\"modelMatrix\":\"-0.909132,-0.380167,0.170155,0,0.416509,-0.829806,0.371405,0,-8.74546e-9,0.408527,0.912746,0,10.0823,12.935,-19.3284,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'1fc5edae-ffbd-4364-8b4f-f97790e262c6','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1fc5edae-ffbd-4364-8b4f-f97790e262c6.ply','PLY','PATIENT_e10dd73f-e0a1-4244-93ef-41a0fe1b27fd_ACT_1a8047ce-7b95-446a-b5b9-71639b6c4b05_SESS_af562828-6543-4aac-b52c-3a40f5e106a6_TOSC_ae1e6238-0a21-4e6b-86b3-6cf6e2b54501_PLY_','2021-02-11 15:55:39','2020-01-06 10:17:44','1fc5edae-ffbd-4364-8b4f-f97790e262c6.ply','2021-02-11 16:55:39','SYNCED','1fc5edae-ffbd-4364-8b4f-f97790e262c6',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"modelMatrix\":\"0.716462,-0.652414,0.247058,0,0.697626,0.67003,-0.253729,0,1.5136e-8,0.354141,0.935192,0,4.99357,-31.5165,-18.1489,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'1fd488e8-5237-4013-94bb-afcdccca8c25','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1fd488e8-5237-4013-94bb-afcdccca8c25.png','SNAPS','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_27ace852-e6ff-4334-bd4f-8ec6820636b4_SESS_9528198e-0624-475b-8000-e2382f71af15_BOSC_1ce74820-939c-4eee-a1cf-e977ed58738b_SNAPS_','2021-02-11 15:55:40','2020-01-15 15:23:16','1fd488e8-5237-4013-94bb-afcdccca8c25.png','2021-02-11 16:55:40','SYNCED','1fd488e8-5237-4013-94bb-afcdccca8c25',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'1fe651af-f20a-408f-af82-836ac7ee68ac','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1fe651af-f20a-408f-af82-836ac7ee68ac.png','SNAPS','PATIENT_1dfeecba-f15d-47a0-8441-39c0a59e8efb_ACT_6578623f-4aba-41d5-ac36-d29ffe41a73d_SESS_96c0b35f-ca1e-450d-952f-bad9e6a1d224_BOSC_c1852659-c405-4c51-9180-0a89a440355a_SNAPS_','2021-02-11 15:55:41','2020-02-24 16:43:35','1fe651af-f20a-408f-af82-836ac7ee68ac.png','2021-02-11 16:55:41','SYNCED','1fe651af-f20a-408f-af82-836ac7ee68ac',0,NULL,'','','{\"displayTitle\":\"Mandibule 106.1.1.2.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'1ff87893-953d-4a16-babd-e0f4707bec66','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/1ff87893-953d-4a16-babd-e0f4707bec66.stl','STL','PATIENT_06241678-eb3f-47ac-9851-393bf5d3a406_ACT_03c914bf-ef1a-4d7c-8a97-c98a392a9c13_SESS_553a8d13-f746-48ad-b91a-303a2c369140_BOSC_9b917b6f-0812-4769-93b8-f62c8025b7f5_STL_','2022-02-01 11:48:01','2019-07-26 09:09:22','1ff87893-953d-4a16-babd-e0f4707bec66.stl','2022-02-01 12:48:01','SYNCED','1ff87893-953d-4a16-babd-e0f4707bec66',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 73.1.1.1\",\"modelMatrix\":\"-0.935518,0.352313,-0.0260954,0,-0.353278,-0.932963,0.0691035,0,3.3682e-10,0.0738665,0.997268,0,-5.37206,23.5811,-19.8882,1\",\"title\":\"MANDIBULE STL\"}'),(2,'2024d706-7957-4aa5-ab22-1a35aed91250','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2024d706-7957-4aa5-ab22-1a35aed91250.ply','PLY','PATIENT_88d83e3f-9fde-4f01-9197-aee6d9fbd1df_ACT_83fbcc79-5cfb-4cf9-9200-e4a7166bf0d2_SESS_eaee00cc-7837-499a-98e4-4ae19617dc0b_TOSC_7c2632d5-9275-4ada-a680-0b0932dd2671_PLY_','2021-02-11 15:55:41','2020-06-16 11:12:13','2024d706-7957-4aa5-ab22-1a35aed91250.ply','2021-02-11 16:55:41','SYNCED','2024d706-7957-4aa5-ab22-1a35aed91250',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.38.1.1\",\"modelMatrix\":\"0.720264,-0.64431,0.257067,0,0.6937,0.668984,-0.266911,0,-2.89374e-9,0.370574,0.928803,0,4.33505,-31.3019,-14.3439,1\",\"title\":\"Maxillaire PLY\"}'),(2,'2025094c-b0a3-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2025094c-b0a3-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_a956d8cc-0010-4cd8-a41b-1273e5303ab7_SESS_1af6c295-df5e-445d-b07c-952827b78105_TOSC_81d6286a-0eb6-4aa4-a210-cccc4d7c48e9_SNAPS_','2021-02-11 15:55:41','2020-06-17 15:58:10','2025094c-b0a3-11ea-947d-226cec7cb58a.png','2021-02-11 16:55:41','SYNCED','2025094c-b0a3-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.57.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'20271f38-b0a3-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/20271f38-b0a3-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_a956d8cc-0010-4cd8-a41b-1273e5303ab7_SESS_1af6c295-df5e-445d-b07c-952827b78105_TOSC_81d6286a-0eb6-4aa4-a210-cccc4d7c48e9_PLY_','2021-02-11 15:55:41','2020-06-17 15:58:10','20271f38-b0a3-11ea-947d-226cec7cb58a.ply','2021-02-11 16:55:41','SYNCED','20271f38-b0a3-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.57.1.1\",\"modelMatrix\":\"0.08854,-0.966392,0.241346,0,0.996073,0.0859017,-0.021453,0,-6.99325e-11,0.242298,0.970202,0,-16.1296,-27.0686,-18.2578,1\",\"title\":\"Maxillaire PLY\"}'),(2,'20291b91-b0a3-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/20291b91-b0a3-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_a956d8cc-0010-4cd8-a41b-1273e5303ab7_SESS_1af6c295-df5e-445d-b07c-952827b78105_BOSC_80d27444-8da6-4ed7-9739-2031fdb0e7b6_PLY_','2021-02-11 15:55:42','2020-06-17 16:00:38','20291b91-b0a3-11ea-947d-226cec7cb58a.ply','2021-02-11 16:55:42','SYNCED','20291b91-b0a3-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.57.1.1\",\"modelMatrix\":\"-0.999959,-0.00852222,0.0030779,0,0.009061,-0.9405,0.339672,0,-1.99624e-10,0.339686,0.940539,0,-19.9238,8.72499,-19.8145,1\",\"title\":\"Mandibule PLY\"}'),(2,'202a116f-1c8d-41c3-a3c2-71df31e28c3e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/202a116f-1c8d-41c3-a3c2-71df31e28c3e.ply','PLY','PATIENT_a20c5079-e26f-4d25-a4f7-898bb7b44b4f_ACT_2d40ced0-53bf-41a0-b55d-a8170b2031a3_SESS_0e2721b3-8710-485f-8ea8-bded33c4312d_BOSC_8ab1e8fb-fb20-41fb-8bdb-67a2faf7d398_PLY_','2022-02-17 14:31:14','2019-08-21 09:12:10','202a116f-1c8d-41c3-a3c2-71df31e28c3e.ply','2022-02-17 15:31:14','SYNCED','202a116f-1c8d-41c3-a3c2-71df31e28c3e',0,'2022-02-17 15:31:14','','','{\"displayTitle\":\"MANDIBULE 129.1.1.1.4\",\"modelMatrix\":\"0.988795,0.148966,-0.00968196,0,-0.149281,0.986713,-0.0641307,0,-3.19455e-10,0.0648574,0.997895,0,20.4665,-16.6033,-28.2062,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'202c0293-b0a3-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/202c0293-b0a3-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_a956d8cc-0010-4cd8-a41b-1273e5303ab7_SESS_1af6c295-df5e-445d-b07c-952827b78105_BOSC_80d27444-8da6-4ed7-9739-2031fdb0e7b6_SNAPS_','2021-02-11 15:55:42','2020-06-17 16:00:38','202c0293-b0a3-11ea-947d-226cec7cb58a.png','2021-02-11 16:55:42','SYNCED','202c0293-b0a3-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.57.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'20308f17-2b24-494a-b999-2726806acec1','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/20308f17-2b24-494a-b999-2726806acec1.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_12a03243-3249-4c24-ac67-53b402dade12_SESS_498a14f0-c752-4902-8e07-41b84c3c384f_BOSC_40908a38-3143-48ef-ae31-7d76fa1858e5_SNAPS_','2021-02-11 15:55:42','2020-02-28 11:40:18','20308f17-2b24-494a-b999-2726806acec1.png','2021-02-11 16:55:42','SYNCED','20308f17-2b24-494a-b999-2726806acec1',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'203b676b-0d19-42cd-8963-66d288e982cf','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/203b676b-0d19-42cd-8963-66d288e982cf.ply','PLY','PATIENT_ae02cf00-1850-4620-987b-4d05333da3d4_ACT_1853f626-d6a7-4c48-9935-7386491435e0_SESS_cf856030-b309-41de-a1c5-1c50dd600256_BOSC_952b5039-ad74-4479-bc5d-1a36cc76fd35_PLY_','2021-08-19 22:42:00','2019-11-22 14:24:34','203b676b-0d19-42cd-8963-66d288e982cf.ply','2021-08-20 00:42:00','SYNCED','203b676b-0d19-42cd-8963-66d288e982cf',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 209.1.1.1\",\"modelMatrix\":\"-0.999429,-0.0325136,0.00921107,0,0.0337932,-0.961586,0.272416,0,-2.84062e-10,0.272572,0.962135,0,-13.8579,13.7046,-28.7914,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'20432b21-7c39-4942-a1a1-35b267d7967e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/20432b21-7c39-4942-a1a1-35b267d7967e.png','SNAPS','PATIENT_6dfc6178-3793-44ed-b36c-7a76f741e180_ACT_3601abc7-d845-4ebf-850e-1cc04933ed30_SESS_a87c6a30-95c7-4120-827b-c37c76c0a486_TOSC_63d19b9e-ad2b-45c8-af61-7ee5ac1ceee3_SNAPS_','2022-02-01 11:48:01','2019-07-19 11:10:53','20432b21-7c39-4942-a1a1-35b267d7967e.png','2022-02-01 12:48:01','SYNCED','20432b21-7c39-4942-a1a1-35b267d7967e',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 98.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'204787a4-ff10-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/204787a4-ff10-11e9-947d-226cec7cb58a.stl','STL','PATIENT_141b5bee-a45d-43ca-bf39-68cd03bb2bae_ACT_e9445e1d-87d4-4f9d-b316-1a8110f09c69_SESS_c3698130-bfaf-4799-a95b-e35d183732fe_TOSC_43e518c1-e3c1-4e3f-95bf-f5896363bc70_STL_','2021-12-30 18:04:09','2019-11-04 15:29:57','204787a4-ff10-11e9-947d-226cec7cb58a.stl','2021-12-30 19:04:09','SYNCED','204787a4-ff10-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 198.1.1.1\",\"modelMatrix\":\"0.722827,-0.668847,0.173682,0,0.691029,0.699623,-0.181674,0,5.02671e-9,0.251339,0.967899,0,5.18494,-32.8368,-12.3825,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'204b23dc-ff10-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/204b23dc-ff10-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_141b5bee-a45d-43ca-bf39-68cd03bb2bae_ACT_e9445e1d-87d4-4f9d-b316-1a8110f09c69_SESS_c3698130-bfaf-4799-a95b-e35d183732fe_BOSC_e974bdcd-2c1c-4ed6-9320-2d2a45b2aac7_PLY_','2021-12-30 18:04:09','2019-11-04 15:33:29','204b23dc-ff10-11e9-947d-226cec7cb58a.ply','2021-12-30 19:04:09','SYNCED','204b23dc-ff10-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 198.1.1.1\",\"modelMatrix\":\"-0.993627,0.109173,-0.0280541,0,-0.11272,-0.962361,0.247298,0,-6.84726e-10,0.248884,0.968533,0,-10.5382,15.1448,-23.5232,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'204d1269-ff10-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/204d1269-ff10-11e9-947d-226cec7cb58a.stl','STL','PATIENT_141b5bee-a45d-43ca-bf39-68cd03bb2bae_ACT_e9445e1d-87d4-4f9d-b316-1a8110f09c69_SESS_c3698130-bfaf-4799-a95b-e35d183732fe_BOSC_e974bdcd-2c1c-4ed6-9320-2d2a45b2aac7_STL_','2021-12-30 18:04:10','2019-11-04 15:33:29','204d1269-ff10-11e9-947d-226cec7cb58a.stl','2021-12-30 19:04:10','SYNCED','204d1269-ff10-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 198.1.1.1\",\"modelMatrix\":\"-0.993627,0.109173,-0.0280541,0,-0.11272,-0.962361,0.247298,0,-6.84726e-10,0.248884,0.968533,0,-10.5382,15.1448,-23.5232,1\",\"title\":\"MANDIBULE STL\"}'),(2,'204e9f79-ff10-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/204e9f79-ff10-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_141b5bee-a45d-43ca-bf39-68cd03bb2bae_ACT_e9445e1d-87d4-4f9d-b316-1a8110f09c69_SESS_c3698130-bfaf-4799-a95b-e35d183732fe_BOSC_e974bdcd-2c1c-4ed6-9320-2d2a45b2aac7_SNAPS_','2021-12-30 18:04:10','2019-11-04 15:33:29','204e9f79-ff10-11e9-947d-226cec7cb58a.png','2021-12-30 19:04:10','SYNCED','204e9f79-ff10-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 198.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'20509057-ff10-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/20509057-ff10-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_141b5bee-a45d-43ca-bf39-68cd03bb2bae_ACT_e9445e1d-87d4-4f9d-b316-1a8110f09c69_SESS_c3698130-bfaf-4799-a95b-e35d183732fe_TOSC_43e518c1-e3c1-4e3f-95bf-f5896363bc70_SNAPS_','2021-12-30 18:04:10','2019-11-04 15:29:57','20509057-ff10-11e9-947d-226cec7cb58a.png','2021-12-30 19:04:10','SYNCED','20509057-ff10-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 198.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'2052a777-ff10-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2052a777-ff10-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_141b5bee-a45d-43ca-bf39-68cd03bb2bae_ACT_e9445e1d-87d4-4f9d-b316-1a8110f09c69_SESS_c3698130-bfaf-4799-a95b-e35d183732fe_TOSC_43e518c1-e3c1-4e3f-95bf-f5896363bc70_PLY_','2021-12-30 18:04:10','2019-11-04 15:29:57','2052a777-ff10-11e9-947d-226cec7cb58a.ply','2021-12-30 19:04:10','SYNCED','2052a777-ff10-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 198.1.1.1\",\"modelMatrix\":\"0.722827,-0.668847,0.173682,0,0.691029,0.699623,-0.181674,0,5.02671e-9,0.251339,0.967899,0,5.18494,-32.8368,-12.3825,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'20881f26-38ed-46cb-83f5-63e75ad07437','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/20881f26-38ed-46cb-83f5-63e75ad07437.stl','STL','PATIENT_1fe53bd5-165d-4f83-8b14-5ccfa106502b_ACT_47fe2ba9-f5ad-42b7-b29b-475d98d6c3d9_SESS_0ebe1667-9b32-41d1-b4c9-a74f9fad08a2_BOSC_2f55f9cb-2759-4560-bf2f-9110d4d4b209_STL_','2021-02-16 16:39:54','2019-12-13 14:53:29','20881f26-38ed-46cb-83f5-63e75ad07437.stl','2021-02-16 17:39:54','SYNCED','20881f26-38ed-46cb-83f5-63e75ad07437',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 232.3.1.1\",\"modelMatrix\":\"-0.97559,0.212519,-0.0553192,0,-0.219601,-0.944128,0.245759,0,-2.28765e-9,0.251908,0.967751,0,-12.9983,14.8678,-25.262,1\",\"title\":\"MANDIBULE STL\"}'),(2,'209b7bfe-d6d7-4bd4-b380-e52a36c6a3bb','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/209b7bfe-d6d7-4bd4-b380-e52a36c6a3bb.png','SNAPS','PATIENT_9bdadecd-3730-4989-a33e-fe0feac57f3a_ACT_9df78093-62b6-4fea-a5f5-06a603297d9a_SESS_a9d40c45-2c5a-46a6-b7f3-2ae4ca61b8d3_TOSC_4f6c812c-61b9-40fa-87a8-81c5d140faf0_SNAPS_','2021-02-11 15:55:44','2020-05-27 14:53:06','209b7bfe-d6d7-4bd4-b380-e52a36c6a3bb.png','2021-02-11 16:55:44','SYNCED','209b7bfe-d6d7-4bd4-b380-e52a36c6a3bb',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 49.1.4.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'209c6124-eb1a-497d-bf0f-4fec7f5963ae','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/209c6124-eb1a-497d-bf0f-4fec7f5963ae.png','SNAPS','PATIENT_9ba806a1-0d9a-46a5-8143-6e968c07c4dd_ACT_bc4ea83b-5ee8-442e-84a0-72e1000837c7_SESS_44ecada7-6aaf-4e06-ac38-4207e5d32862_TOSC_3f31c016-6a97-47d5-ba87-11e40b101724_SNAPS_','2022-02-01 11:48:01','2019-07-12 08:09:03','209c6124-eb1a-497d-bf0f-4fec7f5963ae.png','2022-02-01 12:48:01','SYNCED','209c6124-eb1a-497d-bf0f-4fec7f5963ae',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 49.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'20cb24f6-221b-4c71-bf7d-372b45fbccd3','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/20cb24f6-221b-4c71-bf7d-372b45fbccd3.ply','PLY','PATIENT_68ccc647-d7af-43af-b066-4950901b78bd_ACT_1bfc9ae5-42fb-4b3d-8e54-a2c849ae3d96_SESS_10597265-5639-48a6-9f49-5b6f9e85d80e_TOSC_595a222a-5b8c-4092-b0d8-ddf41a8caeb2_PLY_','2022-02-01 11:48:02','2019-09-04 10:37:42','20cb24f6-221b-4c71-bf7d-372b45fbccd3.ply','2022-02-01 12:48:02','SYNCED','20cb24f6-221b-4c71-bf7d-372b45fbccd3',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 144.1.1.1\",\"modelMatrix\":\"0.540317,-0.739083,0.402261,0,0.841462,0.474578,-0.258299,0,2.31823e-10,0.478051,0.878332,0,1.28855,-40.0399,-20.5251,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'20d5f2d6-5872-47f4-96c1-c94b50d9c9a1','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/20d5f2d6-5872-47f4-96c1-c94b50d9c9a1.png','SNAPS','PATIENT_0a978937-37d2-4044-a9bd-50cb59fb7012_ACT_a7064a8b-e27d-4d86-b80c-4e581e435c56_SESS_6248d1d4-8069-4bd6-b69e-9cf7dbdade6e_BOSC_d94fb6db-e138-4de7-a0c6-a20408452f39_SNAPS_','2022-02-01 11:48:02','2019-07-24 10:00:15','20d5f2d6-5872-47f4-96c1-c94b50d9c9a1.png','2022-02-01 12:48:02','SYNCED','20d5f2d6-5872-47f4-96c1-c94b50d9c9a1',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 111.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'20e8fe70-3799-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/20e8fe70-3799-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_b9c60833-03cc-4842-8403-95f28716d322_ACT_df542486-b7c1-494f-b480-9858c2859c62_SESS_344a7203-1cfa-4cc9-9e4d-99d317027314_TOSC_42dde97a-3e8e-45b1-bf8c-a2f88d4f7e64_PLY_','2021-02-11 15:55:45','2020-01-15 14:03:36','20e8fe70-3799-11ea-947d-226cec7cb58a.ply','2021-02-11 16:55:45','SYNCED','20e8fe70-3799-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.1.1.1.1\",\"modelMatrix\":\"0.240146,-0.922754,0.301422,0,0.970737,0.228276,-0.0745675,0,-1.77078e-9,0.310509,0.95057,0,-9.59377,-36.6954,-16.5549,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'20eaaa54-3799-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/20eaaa54-3799-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_b9c60833-03cc-4842-8403-95f28716d322_ACT_df542486-b7c1-494f-b480-9858c2859c62_SESS_344a7203-1cfa-4cc9-9e4d-99d317027314_TOSC_42dde97a-3e8e-45b1-bf8c-a2f88d4f7e64_SNAPS_','2021-02-11 15:55:45','2020-01-15 14:03:36','20eaaa54-3799-11ea-947d-226cec7cb58a.png','2021-02-11 16:55:45','SYNCED','20eaaa54-3799-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'20ec40d7-3799-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/20ec40d7-3799-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_df542486-b7c1-494f-b480-9858c2859c62_SESS_344a7203-1cfa-4cc9-9e4d-99d317027314_BOSC_2882f8a7-5a96-4601-ab5b-ac3fb25edaf5_SNAPS_','2021-02-11 15:55:45','2020-01-15 14:13:13','20ec40d7-3799-11ea-947d-226cec7cb58a.png','2021-02-11 16:55:45','SYNCED','20ec40d7-3799-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'20edac1a-3799-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/20edac1a-3799-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_df542486-b7c1-494f-b480-9858c2859c62_SESS_344a7203-1cfa-4cc9-9e4d-99d317027314_BOSC_2882f8a7-5a96-4601-ab5b-ac3fb25edaf5_PLY_','2021-02-11 15:55:45','2020-01-15 14:13:13','20edac1a-3799-11ea-947d-226cec7cb58a.ply','2021-02-11 16:55:45','SYNCED','20edac1a-3799-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.1.1.1.1\",\"modelMatrix\":\"-0.979284,-0.202213,0.0106692,0,0.202494,-0.977923,0.0515974,0,-8.42675e-10,0.052689,0.998611,0,-16.989,10.2642,-18.7638,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'21050413-548e-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/21050413-548e-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_2807a523-f049-4cb4-b87c-145d1c34703d_ACT_c814024c-0941-4b02-94bd-294d8fdb06f3_SESS_c5963919-b6e6-43fd-af82-eed8f169475a_TOSC_788c4f2e-8c8f-48d6-ba56-ec592372f47b_SNAPS_','2021-02-11 15:55:46','2020-02-21 10:33:47','21050413-548e-11ea-947d-226cec7cb58a.png','2021-02-11 16:55:46','SYNCED','21050413-548e-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'21078db4-548e-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/21078db4-548e-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_2807a523-f049-4cb4-b87c-145d1c34703d_ACT_c814024c-0941-4b02-94bd-294d8fdb06f3_SESS_c5963919-b6e6-43fd-af82-eed8f169475a_TOSC_788c4f2e-8c8f-48d6-ba56-ec592372f47b_PLY_','2021-02-11 15:55:46','2020-02-21 10:33:47','21078db4-548e-11ea-947d-226cec7cb58a.ply','2021-02-11 16:55:46','SYNCED','21078db4-548e-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"modelMatrix\":\"0.86336,-0.452615,0.223046,0,0.504589,0.774432,-0.381635,0,-4.01774e-9,0.442035,0.896998,0,8.57347,-31.1057,-21.4912,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'21094ddb-548e-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/21094ddb-548e-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_c814024c-0941-4b02-94bd-294d8fdb06f3_SESS_c5963919-b6e6-43fd-af82-eed8f169475a_BOSC_3e46a900-e0fe-4caa-9378-0ed67fc8b67b_SNAPS_','2021-02-11 15:55:46','2020-02-21 10:36:32','21094ddb-548e-11ea-947d-226cec7cb58a.png','2021-02-11 16:55:46','SYNCED','21094ddb-548e-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'210b30f6-548e-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/210b30f6-548e-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_c814024c-0941-4b02-94bd-294d8fdb06f3_SESS_c5963919-b6e6-43fd-af82-eed8f169475a_BOSC_3e46a900-e0fe-4caa-9378-0ed67fc8b67b_PLY_','2021-02-11 15:55:46','2020-02-21 10:36:32','210b30f6-548e-11ea-947d-226cec7cb58a.ply','2021-02-11 16:55:46','SYNCED','210b30f6-548e-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"modelMatrix\":\"-0.964669,0.258375,-0.0515343,0,-0.263465,-0.946035,0.188691,0,5.15659e-10,0.195602,0.980683,0,-5.23437,12.471,-24.5009,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'210dd6aa-f1b0-407b-9588-bb53add83bb5','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/210dd6aa-f1b0-407b-9588-bb53add83bb5.stl','STL','PATIENT_7d0d2bad-c9d6-4ee9-ab94-e37c020f0093_ACT_b51379b6-fde7-419f-8674-9d0273d4045e_SESS_645b719e-cea8-429b-818a-7b6e4a02189d_BOSC_22a2ed0b-fadb-4475-b37f-74a174369a34_STL_','2021-08-19 22:42:08','2019-11-25 14:57:16','210dd6aa-f1b0-407b-9588-bb53add83bb5.stl','2021-08-20 00:42:08','SYNCED','210dd6aa-f1b0-407b-9588-bb53add83bb5',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 211.1.1.1\",\"modelMatrix\":\"-0.937672,0.328644,-0.112982,0,-0.347523,-0.886734,0.304844,0,8.77959e-9,0.325108,0.945677,0,-7.01243,16.4261,-21.03,1\",\"title\":\"MANDIBULE STL\"}'),(2,'212938e2-bb31-47d8-8a43-217c889545a5','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/212938e2-bb31-47d8-8a43-217c889545a5.png','SNAPS','PATIENT_709f9ec4-af48-40f4-a9a5-be0f73ef4cb2_ACT_28eb5975-dda1-4110-8e4c-f3584b36f7d8_SESS_363bcde4-11db-4da0-9d9d-cda58af55d82_TOSC_04a44a02-3c8e-4525-8b34-11aaa8ff30f4_SNAPS_','2021-02-11 15:55:47','2020-02-05 13:36:56','212938e2-bb31-47d8-8a43-217c889545a5.png','2021-02-11 16:55:47','SYNCED','212938e2-bb31-47d8-8a43-217c889545a5',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'2178889f-0879-4a84-873a-0c45732dec4d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2178889f-0879-4a84-873a-0c45732dec4d.png','SNAPS','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_TOSC_44516845-ca32-49c0-8577-f34223c31274_SNAPS_','2021-12-30 18:04:11','2019-11-14 12:20:16','2178889f-0879-4a84-873a-0c45732dec4d.png','2021-12-30 19:04:11','SYNCED','2178889f-0879-4a84-873a-0c45732dec4d',0,NULL,'','','{\"displayTitle\":\"Mascella 0\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'219efef9-3d96-4a89-a7ab-dc526eeccb84','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/219efef9-3d96-4a89-a7ab-dc526eeccb84.stl','STL','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_BOSC_5da0ad8e-75b1-46b8-8740-0c2d9c83df29_STL_','2021-12-30 18:04:11','2019-11-14 13:47:19','219efef9-3d96-4a89-a7ab-dc526eeccb84.stl','2021-12-30 19:04:11','SYNCED','219efef9-3d96-4a89-a7ab-dc526eeccb84',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 202.1.1.1\",\"modelMatrix\":\"-0.812386,0.573179,-0.107209,0,-0.583119,-0.798538,0.149361,0,-9.77095e-9,0.183855,0.982953,0,0.216935,20.1659,-23.7841,1\",\"title\":\"MANDIBULE STL\"}'),(2,'21a3ded3-458d-47bf-bfd7-d43f792f7b73','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/21a3ded3-458d-47bf-bfd7-d43f792f7b73.ply','PLY','PATIENT_9a7fb011-3358-4d3c-a11d-cb262db47e63_ACT_8d3d24a8-8497-455b-a175-3c2ad080b066_SESS_4c947a81-1ce1-4f4b-9ced-98099e5c9e41_TOSC_6c77a427-9c36-4753-9c20-b37adb53412f_PLY_','2022-03-04 13:40:28','2019-07-09 12:38:40','21a3ded3-458d-47bf-bfd7-d43f792f7b73.ply','2022-03-04 14:40:28','SYNCED','21a3ded3-458d-47bf-bfd7-d43f792f7b73',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 11.1.2.1\",\"modelMatrix\":\"0.745306,-0.659524,0.0977101,0,0.666723,0.737259,-0.109227,0,3.87132e-10,0.146553,0.989203,0,-31.4908,-2.28884,-22.4832,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'21aea522-9429-4fba-b7cf-558fa3c005fc','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/21aea522-9429-4fba-b7cf-558fa3c005fc.ply','PLY','PATIENT_e2ad6866-17be-4ec9-ace3-df2075baed98_ACT_628664ea-6869-485b-9c25-5b14151d796d_SESS_fbdbf097-6fee-4478-995f-6221a0d4627a_TOSC_b4e1ae2c-0f1b-44b1-b43f-287c75583c96_PLY_','2021-02-16 16:39:57','2019-12-13 15:00:07','21aea522-9429-4fba-b7cf-558fa3c005fc.ply','2021-02-16 17:39:57','SYNCED','21aea522-9429-4fba-b7cf-558fa3c005fc',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 232.21.1.1\",\"modelMatrix\":\"0.346437,-0.905252,0.245969,0,0.938073,0.334316,-0.0908383,0,1.42618e-9,0.262207,0.965012,0,-10.2143,-32.7421,-18.0217,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'21b4bc38-38b6-493e-85bd-aa8ae075ff81','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/21b4bc38-38b6-493e-85bd-aa8ae075ff81.stl','STL','PATIENT_b87a45f4-e9da-42dd-a118-319f1cadc208_ACT_e48ea1a6-dafa-457d-b928-ddb5957d68d3_SESS_0b023d1b-96d3-44b5-b2a9-50a025917cea_TOSC_c41f71a3-52ee-4451-83e9-f2bc1af1e94e_STL_','2022-02-01 11:48:02','2019-07-26 09:12:09','21b4bc38-38b6-493e-85bd-aa8ae075ff81.stl','2022-02-01 12:48:02','SYNCED','21b4bc38-38b6-493e-85bd-aa8ae075ff81',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 72.1.1.1\",\"modelMatrix\":\"0.63557,-0.73402,0.239302,0,0.772043,0.604268,-0.197001,0,4.4887e-9,0.309959,0.95075,0,5.21738,-36.0021,-23.0764,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'21f3937a-d49d-4661-86ce-204a0bc623f1','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/21f3937a-d49d-4661-86ce-204a0bc623f1.ply','PLY','PATIENT_dc79f3b2-d683-43ed-b1fa-7c071f41f22f_ACT_b951b408-da73-41a1-be4c-5976b8fd8339_SESS_70eca243-d3b9-437e-a3be-2cba7f50d4a2_BOSC_6aadc74f-b823-4c78-9a07-ac0e9ce66150_PLY_','2022-02-01 11:48:02','2019-10-01 09:45:57','21f3937a-d49d-4661-86ce-204a0bc623f1.ply','2022-02-01 12:48:02','SYNCED','21f3937a-d49d-4661-86ce-204a0bc623f1',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 169.1.1.1\",\"modelMatrix\":\"0.643959,0.764328,-0.033468,0,-0.76506,0.643342,-0.0281703,0,1.49302e-9,0.0437455,0.999043,0,23.0511,5.62668,-26.4168,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'21f401f5-ac55-4ef6-a67e-efcddf4b001c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/21f401f5-ac55-4ef6-a67e-efcddf4b001c.ply','PLY','PATIENT_1d7eb2a4-406e-41b4-a2c1-95e3f2a5c277_ACT_a397025f-6777-4f73-b8ab-486366544db1_SESS_2b6be060-783a-4da6-98b8-91c0f55f2e42_TOSC_b92166b2-0613-4346-baf7-3c9b3d7819ee_PLY_','2021-02-11 15:55:49','2020-01-20 10:18:35','21f401f5-ac55-4ef6-a67e-efcddf4b001c.ply','2021-02-11 16:55:49','SYNCED','21f401f5-ac55-4ef6-a67e-efcddf4b001c',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.1.1.1.1\",\"modelMatrix\":\"0.334351,-0.88887,0.31324,0,0.942449,0.315343,-0.111128,0,-7.3933e-9,0.332368,0.94315,0,-6.09276,-31.0472,-19.9185,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'21f57bda-442b-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/21f57bda-442b-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_9d55e20d-c9a3-47c1-be07-a1b8b8e1ad46_SESS_f4c4cf33-1da8-4a4f-a33c-5f4ad5b9b16d_BOSC_a577cccc-2b82-47f4-ad7c-b1b671b00bee_PLY_','2021-02-11 15:55:49','2020-01-31 14:08:56','21f57bda-442b-11ea-947d-226cec7cb58a.ply','2021-02-11 16:55:49','SYNCED','21f57bda-442b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.2\",\"modelMatrix\":\"-0.722198,0.687827,-0.0729651,0,-0.691686,-0.718169,0.0761838,0,-3.43021e-9,0.105489,0.99442,0,5.72091,19.7596,-24.2097,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'21f771f0-442b-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/21f771f0-442b-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_9d55e20d-c9a3-47c1-be07-a1b8b8e1ad46_SESS_f4c4cf33-1da8-4a4f-a33c-5f4ad5b9b16d_BOSC_a577cccc-2b82-47f4-ad7c-b1b671b00bee_SNAPS_','2021-02-11 15:55:49','2020-01-31 14:08:56','21f771f0-442b-11ea-947d-226cec7cb58a.png','2021-02-11 16:55:49','SYNCED','21f771f0-442b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.2\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'220a004d-3fe4-4aa7-ab3b-fc7950e888d2','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/220a004d-3fe4-4aa7-ab3b-fc7950e888d2.ply','PLY','PATIENT_acdaa556-b90a-46f8-8a1e-f00e8587af57_ACT_ef39e64f-4944-446a-8d1e-6cad2cb3a22e_SESS_4817bf30-fd2c-45ab-9ca5-9cc837ebe537_BOSC_761058bf-27b9-4b0b-a015-148fd0d52e7d_PLY_','2022-02-01 11:48:02','2019-09-02 10:43:11','220a004d-3fe4-4aa7-ab3b-fc7950e888d2.ply','2022-02-01 12:48:02','SYNCED','220a004d-3fe4-4aa7-ab3b-fc7950e888d2',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 136.1.1.1\",\"modelMatrix\":\"0.972906,-0.213731,0.0881677,0,0.231202,0.899386,-0.371013,0,3.05035e-9,0.381345,0.924433,0,10.7382,-35.2296,-26.3733,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'22223483-6dc9-47f1-8a09-0c94cac349ad','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/22223483-6dc9-47f1-8a09-0c94cac349ad.ply','PLY','PATIENT_d0231c57-f6d9-4025-a220-4508319181b1_ACT_55defb8f-45b5-46e3-8061-fc96e950b0e6_SESS_86bb682b-e6f9-4f45-b2be-03baa9dd0b5d_TOSC_0067e2eb-3ee8-48b6-b674-02cbd8a5c609_PLY_','2022-02-01 11:48:02','2019-07-17 14:12:14','22223483-6dc9-47f1-8a09-0c94cac349ad.ply','2022-02-01 12:48:02','SYNCED','716c3699-8e64-487c-b60c-0c842db25796',1,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 88.1.1.1\",\"modelMatrix\":\"0.222113,-0.938834,0.263166,0,0.975021,0.213869,-0.0599501,0,-9.03166e-10,0.269909,0.962886,0,-14.3326,-35.5711,-23.7062,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'222ac6c5-a6db-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/222ac6c5-a6db-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_d7b3cadc-8356-418c-aad5-c24747161527_ACT_5a789675-4685-42fc-9a84-35f09f0b7ab6_SESS_ef0782bd-ddc2-4e69-8b3a-b0b28b0560a8_TOSC_46e3f2d4-26df-476b-8bdd-96f884261e75_PLY_','2022-02-01 11:48:03','2019-07-15 12:31:30','222ac6c5-a6db-11e9-a33b-226cec7cb58a.ply','2022-02-01 12:48:03','SYNCED','222ac6c5-a6db-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 64.1.1.1\",\"modelMatrix\":\"0.600735,-0.781487,0.168513,0,0.799448,0.587237,-0.126626,0,5.20037e-9,0.210786,0.977532,0,-1.02488,-33.2309,-17.203,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'222b68ae-a6db-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/222b68ae-a6db-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_d7b3cadc-8356-418c-aad5-c24747161527_ACT_5a789675-4685-42fc-9a84-35f09f0b7ab6_SESS_ef0782bd-ddc2-4e69-8b3a-b0b28b0560a8_TOSC_46e3f2d4-26df-476b-8bdd-96f884261e75_SNAPS_','2022-02-01 11:48:03','2019-07-15 12:31:30','222b68ae-a6db-11e9-a33b-226cec7cb58a.png','2022-02-01 12:48:03','SYNCED','222b68ae-a6db-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 64.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'222bf307-a6db-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/222bf307-a6db-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_d7b3cadc-8356-418c-aad5-c24747161527_ACT_5a789675-4685-42fc-9a84-35f09f0b7ab6_SESS_ef0782bd-ddc2-4e69-8b3a-b0b28b0560a8_BOSC_a723a33a-fc79-44a8-bd29-b8a7f71d69a8_SNAPS_','2022-02-01 11:48:03','2019-07-15 12:41:01','222bf307-a6db-11e9-a33b-226cec7cb58a.png','2022-02-01 12:48:03','SYNCED','222bf307-a6db-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 64.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'222c8723-a6db-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/222c8723-a6db-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_d7b3cadc-8356-418c-aad5-c24747161527_ACT_5a789675-4685-42fc-9a84-35f09f0b7ab6_SESS_ef0782bd-ddc2-4e69-8b3a-b0b28b0560a8_BOSC_a723a33a-fc79-44a8-bd29-b8a7f71d69a8_PLY_','2022-02-01 11:48:03','2019-07-15 12:41:01','222c8723-a6db-11e9-a33b-226cec7cb58a.ply','2022-02-01 12:48:03','SYNCED','222c8723-a6db-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 64.1.1.1\",\"modelMatrix\":\"-0.710054,0.685124,-0.162565,0,-0.704147,-0.690872,0.163929,0,-1.17033e-8,0.230868,0.972985,0,6.54695,18.4926,-22.6352,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'222d2910-a6db-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/222d2910-a6db-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_d7b3cadc-8356-418c-aad5-c24747161527_ACT_5a789675-4685-42fc-9a84-35f09f0b7ab6_SESS_ef0782bd-ddc2-4e69-8b3a-b0b28b0560a8_TOSC_46e3f2d4-26df-476b-8bdd-96f884261e75_STL_','2022-02-01 11:48:03','2019-07-15 12:31:30','222d2910-a6db-11e9-a33b-226cec7cb58a.stl','2022-02-01 12:48:03','SYNCED','222d2910-a6db-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 64.1.1.1\",\"modelMatrix\":\"0.600735,-0.781487,0.168513,0,0.799448,0.587237,-0.126626,0,5.20037e-9,0.210786,0.977532,0,-1.02488,-33.2309,-17.203,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'222dccbe-a6db-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/222dccbe-a6db-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_d7b3cadc-8356-418c-aad5-c24747161527_ACT_5a789675-4685-42fc-9a84-35f09f0b7ab6_SESS_ef0782bd-ddc2-4e69-8b3a-b0b28b0560a8_BOSC_a723a33a-fc79-44a8-bd29-b8a7f71d69a8_STL_','2022-02-01 11:48:04','2019-07-15 12:41:01','222dccbe-a6db-11e9-a33b-226cec7cb58a.stl','2022-02-01 12:48:04','SYNCED','222dccbe-a6db-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 64.1.1.1\",\"modelMatrix\":\"-0.710054,0.685124,-0.162565,0,-0.704147,-0.690872,0.163929,0,-1.17033e-8,0.230868,0.972985,0,6.54695,18.4926,-22.6352,1\",\"title\":\"MANDIBULE STL\"}'),(2,'223adf01-22f5-46fd-ba2c-11c53dc4488e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/223adf01-22f5-46fd-ba2c-11c53dc4488e.stl','STL','PATIENT_acdaa556-b90a-46f8-8a1e-f00e8587af57_ACT_ef39e64f-4944-446a-8d1e-6cad2cb3a22e_SESS_4817bf30-fd2c-45ab-9ca5-9cc837ebe537_TOSC_7dccf992-11e9-4117-b2ee-8de56c870cff_STL_','2022-02-01 11:48:04','2019-09-02 11:31:33','223adf01-22f5-46fd-ba2c-11c53dc4488e.stl','2022-02-01 12:48:04','SYNCED','223adf01-22f5-46fd-ba2c-11c53dc4488e',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 136.1.1.1\",\"modelMatrix\":\"0.870111,-0.416797,0.263034,0,0.492856,0.735834,-0.464373,0,-1.40552e-8,0.533694,0.845678,0,11.0594,-40.1028,-13.2101,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'22418a6c-03bd-4587-b287-b87cf4d7deb5','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/22418a6c-03bd-4587-b287-b87cf4d7deb5.png','SNAPS','PATIENT_c5ace945-eba3-4313-b492-5ddcd477266f_ACT_8915263d-3a89-4ba1-8bcd-8da9a9717cd9_SESS_d675c75a-79e9-4f80-9fd7-416b684604da_TOSC_c929d5f1-95d5-4879-9e11-c1871e7492b6_SNAPS_','2022-03-04 13:40:28','2019-07-09 11:34:40','22418a6c-03bd-4587-b287-b87cf4d7deb5.png','2022-03-04 14:40:28','SYNCED','22418a6c-03bd-4587-b287-b87cf4d7deb5',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 12.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'2245b665-0a7b-46da-8f68-d8054a665132','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2245b665-0a7b-46da-8f68-d8054a665132.stl','STL','PATIENT_8b56b11e-d006-4d51-96ed-0cd4a2cbb94a_ACT_ef0ca6ba-0462-4bb0-8c8d-8b28fa60bbf3_SESS_64db0077-343e-46d0-8ccd-4844cd637422_BOSC_4c3e8c04-608d-4121-99e4-fd384f7cc0b4_STL_','2021-12-30 18:04:14','2019-10-16 09:51:24','2245b665-0a7b-46da-8f68-d8054a665132.stl','2021-12-30 19:04:14','SYNCED','2245b665-0a7b-46da-8f68-d8054a665132',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 130.1.1.1\",\"modelMatrix\":\"-0.968072,0.248236,-0.0348754,0,-0.250674,-0.958657,0.134684,0,-6.18632e-10,0.139127,0.990275,0,-12.1175,18.6073,-22.4084,1\",\"title\":\"MANDIBULE STL\"}'),(2,'2252dd99-5fa2-42a5-a6c0-12c2ead36fb3','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2252dd99-5fa2-42a5-a6c0-12c2ead36fb3.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_9f64af17-fa20-4e3c-9e93-28b399a01ceb_SESS_2313309c-20c9-418e-9628-ffed7923a737_BOSC_7a7ebff8-4107-4442-8840-03699211d4c5_SNAPS_','2021-02-11 15:55:52','2020-01-31 15:23:40','2252dd99-5fa2-42a5-a6c0-12c2ead36fb3.png','2021-02-11 16:55:52','SYNCED','2252dd99-5fa2-42a5-a6c0-12c2ead36fb3',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'22572d5a-6939-480b-8626-22b991ae904e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/22572d5a-6939-480b-8626-22b991ae904e.png','SNAPS','PATIENT_5d459557-968e-47e1-ab0d-40f6f35af19f_ACT_0c285c17-0391-4813-bb3b-23ed0d69c4c2_SESS_d64759ae-a35d-4c4c-9187-e9ba2e931c8d_TOSC_2803d772-6123-41d8-bb80-ce12e522a72e_SNAPS_','2022-02-01 11:48:05','2019-09-02 11:41:29','22572d5a-6939-480b-8626-22b991ae904e.png','2022-02-01 12:48:05','SYNCED','22572d5a-6939-480b-8626-22b991ae904e',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 137.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'225d8efb-1a48-46c6-8063-e5946602f245','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/225d8efb-1a48-46c6-8063-e5946602f245.png','SNAPS','PATIENT_d15fb585-804c-41fa-b64b-5c8d859f198b_ACT_bfc3cb95-f419-45fa-9c89-345a650d95b4_SESS_e0d8b204-af15-455d-a0ec-52e5b2d7957c_BOSC_6ffd3412-8dbd-41e9-b197-049ca2ffc36a_SNAPS_','2021-02-16 16:40:03','2019-12-11 16:31:26','225d8efb-1a48-46c6-8063-e5946602f245.png','2021-02-16 17:40:03','SYNCED','225d8efb-1a48-46c6-8063-e5946602f245',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 232.4.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'2262acd8-ba48-449b-a026-fb12ff0523b7','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2262acd8-ba48-449b-a026-fb12ff0523b7.ply','PLY','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_TOSC_03aaf826-a041-432a-a917-8af9a1e25b73_PLY_','2021-12-30 18:04:14','2019-11-15 11:06:50','2262acd8-ba48-449b-a026-fb12ff0523b7.ply','2021-12-30 19:04:14','SYNCED','2262acd8-ba48-449b-a026-fb12ff0523b7',0,NULL,'','','{\"displayTitle\":\"Mascella 0\",\"modelMatrix\":\"0.756092,-0.611841,0.232326,0,0.654465,0.706849,-0.268402,0,1.1094e-8,0.354986,0.934872,0,7.06144,-37.4454,-15.1845,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'22675bd5-9058-4057-a9b4-78a20b567e75','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/22675bd5-9058-4057-a9b4-78a20b567e75.png','SNAPS','PATIENT_cbd259d8-b167-4ae5-b02e-593bafa6de29_ACT_34fa1c9b-715e-411d-a03f-6f26498858ca_SESS_024384a7-8b62-46fd-8fd0-3a6d4aec0594_TOSC_95cd0980-b02a-48a3-8c81-8fc0e6dd9980_SNAPS_','2021-02-16 16:40:05','2019-12-11 15:39:36','22675bd5-9058-4057-a9b4-78a20b567e75.png','2021-02-16 17:40:05','SYNCED','22675bd5-9058-4057-a9b4-78a20b567e75',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 232.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'227ded5f-ba2f-439b-80f0-a3266da26c07','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/227ded5f-ba2f-439b-80f0-a3266da26c07.png','SNAPS','PATIENT_2441f64a-7a36-4f7f-86d7-d2f15e0f427e_ACT_b8b06ecf-8667-4356-b44a-4d1695a213e0_SESS_275dd034-f567-4845-9032-96abb3689845_BOSC_9b87b1fb-4bd3-4db2-bc9b-7d57ca4b4507_SNAPS_','2022-02-01 11:48:05','2019-07-15 16:09:42','227ded5f-ba2f-439b-80f0-a3266da26c07.png','2022-02-01 12:48:05','SYNCED','227ded5f-ba2f-439b-80f0-a3266da26c07',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 68.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'2290066a-b09c-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2290066a-b09c-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_4256090f-2b3b-416c-b6d3-1c46b5678d4a_SESS_d7b9615e-34a4-446f-8b43-b280815bacec_TOSC_3d8d7864-898c-452c-b9be-fff0788aecea_SNAPS_','2021-02-11 15:55:53','2020-06-17 15:11:39','2290066a-b09c-11ea-947d-226cec7cb58a.png','2021-02-11 16:55:53','SYNCED','2290066a-b09c-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.54.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'2292cc97-b09c-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2292cc97-b09c-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_4256090f-2b3b-416c-b6d3-1c46b5678d4a_SESS_d7b9615e-34a4-446f-8b43-b280815bacec_TOSC_3d8d7864-898c-452c-b9be-fff0788aecea_PLY_','2021-02-11 15:55:53','2020-06-17 15:11:39','2292cc97-b09c-11ea-947d-226cec7cb58a.ply','2021-02-11 16:55:53','SYNCED','2292cc97-b09c-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.54.1.3\",\"modelMatrix\":\"-0.290576,-0.918049,0.269725,0,0.956852,-0.278792,0.0819096,0,8.33424e-9,0.281888,0.959447,0,-27.9077,-14.3553,-14.3373,1\",\"title\":\"Maxillaire PLY\"}'),(2,'22963201-1066-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/22963201-1066-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_fd694b3f-abde-4e46-91f7-7c62bfdcafa4_SESS_73a3f5b9-e905-4911-a163-2022e1de3380_TOSC_03b99d3a-4584-48bf-89eb-5a4427348490_SNAPS_','2021-08-19 22:42:20','2019-11-26 22:02:03','22963201-1066-11ea-947d-226cec7cb58a.png','2021-08-20 00:42:20','SYNCED','22963201-1066-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'2297ed6e-1066-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2297ed6e-1066-11ea-947d-226cec7cb58a.stl','STL','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_fd694b3f-abde-4e46-91f7-7c62bfdcafa4_SESS_73a3f5b9-e905-4911-a163-2022e1de3380_TOSC_03b99d3a-4584-48bf-89eb-5a4427348490_STL_','2021-08-19 22:42:20','2019-11-26 22:02:03','2297ed6e-1066-11ea-947d-226cec7cb58a.stl','2021-08-20 00:42:20','SYNCED','2297ed6e-1066-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"modelMatrix\":\"0.539012,-0.816928,0.20517,0,0.842298,0.522777,-0.131295,0,1.36469e-8,0.243584,0.96988,0,-5.84022,-37.9635,-20.406,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'22997827-1066-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/22997827-1066-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_fd694b3f-abde-4e46-91f7-7c62bfdcafa4_SESS_73a3f5b9-e905-4911-a163-2022e1de3380_TOSC_03b99d3a-4584-48bf-89eb-5a4427348490_PLY_','2021-08-19 22:42:21','2019-11-26 22:02:03','22997827-1066-11ea-947d-226cec7cb58a.ply','2021-08-20 00:42:21','SYNCED','22997827-1066-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"modelMatrix\":\"0.539012,-0.816928,0.20517,0,0.842298,0.522777,-0.131295,0,1.36469e-8,0.243584,0.96988,0,-5.84022,-37.9635,-20.406,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'229dd4d6-a02c-4524-b3eb-c9dea4da71d1','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/229dd4d6-a02c-4524-b3eb-c9dea4da71d1.ply','PLY','PATIENT_e70f7e60-3171-47f6-b304-48663793dd6c_ACT_aaa611dc-5043-4084-a623-dee5521b387d_SESS_8c7531eb-ce1f-43ad-9225-6dc50dc511b3_TOSC_68e4e89e-5129-45db-81c4-431f18e65e9d_PLY_','2022-02-01 11:48:05','2019-07-11 17:19:23','229dd4d6-a02c-4524-b3eb-c9dea4da71d1.ply','2022-02-01 12:48:05','SYNCED','229dd4d6-a02c-4524-b3eb-c9dea4da71d1',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 46.1.1.1\",\"modelMatrix\":\"0.0906731,-0.959984,0.264972,0,0.995881,0.0874047,-0.0241252,0,-3.44859e-9,0.266068,0.963954,0,-21.0417,-31.0636,-17.7208,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'229f6bb2-5959-4303-a06e-e1879c2872c0','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/229f6bb2-5959-4303-a06e-e1879c2872c0.ply','PLY','PATIENT_566a9c67-4ca6-4989-a176-9085587e993c_ACT_5e6a4314-7576-433f-bed9-a2ac65ced795_SESS_ccba3902-a3ec-4421-b91b-d65d0e2c8596_TOSC_6baa2c30-a8f7-44b7-8f81-412994978073_PLY_','2021-08-19 22:42:22','2019-11-29 15:47:52','229f6bb2-5959-4303-a06e-e1879c2872c0.ply','2021-08-20 00:42:22','SYNCED','229f6bb2-5959-4303-a06e-e1879c2872c0',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 216.1.1.1\",\"modelMatrix\":\"0.364775,-0.898981,0.24243,0,0.931096,0.352194,-0.0949767,0,-1.84262e-10,0.26037,0.965509,0,-9.4876,-35.0102,-20.3618,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'22c3f283-a29a-47ca-b715-532ba4f0eb76','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/22c3f283-a29a-47ca-b715-532ba4f0eb76.ply','PLY','PATIENT_a730394c-024c-4469-9597-1dc64fff623b_ACT_0c243121-7129-407f-a57e-ab9991a033a8_SESS_8afbb30e-6cc2-4909-9e30-cfe0f7cbeb93_BOSC_9d0613fb-ddf4-4aaa-997a-148424eaecc5_PLY_','2021-02-11 15:55:55','2020-01-31 14:19:20','22c3f283-a29a-47ca-b715-532ba4f0eb76.ply','2021-02-11 16:55:55','SYNCED','22c3f283-a29a-47ca-b715-532ba4f0eb76',0,NULL,'','','{\"displayTitle\":\"Mandibule 25.1.1.7.1.2\",\"modelMatrix\":\"-0.997394,0.0696153,-0.0189396,0,-0.0721456,-0.962412,0.261835,0,-4.09621e-10,0.262519,0.964927,0,-18.6032,14.412,-22.3611,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'22c70c77-9c16-11e9-90d7-226cec7cb58a','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/22c70c77-9c16-11e9-90d7-226cec7cb58a.ply','PLY','PATIENT_cadfb79e-7de5-4015-97e3-269a77999943_ACT_087c4066-ec0b-4035-93aa-10a106e71f3b_SESS_076eb8ca-e04f-483c-b1b1-7caa3017af15_TOSC_619e33ae-800e-448c-a6e2-89895e888cf8_PLY_','2022-03-04 13:40:28','2019-07-01 17:33:08','22c70c77-9c16-11e9-90d7-226cec7cb58a.ply','2022-03-04 14:40:28','SYNCED','22c70c77-9c16-11e9-90d7-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.2.1.1\",\"modelMatrix\":\"-0.556781,-0.811499,0.177381,0,0.830659,-0.543938,0.118897,0,-9.27662e-10,0.213543,0.976934,0,11.8106,-25.434,-16.8691,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'22c7c6a1-9c16-11e9-90d7-226cec7cb58a','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/22c7c6a1-9c16-11e9-90d7-226cec7cb58a.stl','STL','PATIENT_cadfb79e-7de5-4015-97e3-269a77999943_ACT_087c4066-ec0b-4035-93aa-10a106e71f3b_SESS_076eb8ca-e04f-483c-b1b1-7caa3017af15_TOSC_619e33ae-800e-448c-a6e2-89895e888cf8_STL_','2022-03-04 13:40:28','2019-07-01 17:33:08','22c7c6a1-9c16-11e9-90d7-226cec7cb58a.stl','2022-03-04 14:40:28','SYNCED','22c7c6a1-9c16-11e9-90d7-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.2.1.1\",\"modelMatrix\":\"-0.556781,-0.811499,0.177381,0,0.830659,-0.543938,0.118897,0,-9.27662e-10,0.213543,0.976934,0,11.8106,-25.434,-16.8691,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'22c9f4bd-9c16-11e9-90d7-226cec7cb58a','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/22c9f4bd-9c16-11e9-90d7-226cec7cb58a.png','SNAPS','PATIENT_cadfb79e-7de5-4015-97e3-269a77999943_ACT_087c4066-ec0b-4035-93aa-10a106e71f3b_SESS_076eb8ca-e04f-483c-b1b1-7caa3017af15_TOSC_619e33ae-800e-448c-a6e2-89895e888cf8_SNAPS_','2022-03-04 13:40:29','2019-07-01 17:33:08','22c9f4bd-9c16-11e9-90d7-226cec7cb58a.png','2022-03-04 14:40:29','SYNCED','22c9f4bd-9c16-11e9-90d7-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.2.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'22cbb91c-91bf-46e4-beea-7915395cf8a9','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/22cbb91c-91bf-46e4-beea-7915395cf8a9.ply','PLY','PATIENT_72f539f4-2d06-47fa-b0b8-1291879a4818_ACT_d55baca2-6f09-4446-a148-dcdcfcaf57d8_SESS_5efdc987-8bdd-454f-b282-82efcf807bae_TOSC_4f43da91-58b4-4461-8b83-659e6fbebe8c_PLY_','2021-08-19 22:42:25','2019-11-26 15:52:02','22cbb91c-91bf-46e4-beea-7915395cf8a9.ply','2021-08-20 00:42:25','SYNCED','22cbb91c-91bf-46e4-beea-7915395cf8a9',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 86.1.1.1.1\",\"modelMatrix\":\"0.661741,-0.699061,0.270947,0,0.749733,0.617016,-0.239148,0,-4.74625e-9,0.361392,0.932414,0,4.0184,-35.7163,-19.9875,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'22cfb1de-6153-4a24-bebb-7e12f044f64a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/22cfb1de-6153-4a24-bebb-7e12f044f64a.ply','PLY','PATIENT_0ca041a1-027c-4dd2-b295-60f5d76e45a7_ACT_d23098f0-2472-45a9-b3e5-d7bef8926ef9_SESS_8dad33c1-fa53-4b10-be29-d6c13bd7610b_BOSC_2cd80f66-d461-44c9-ac56-9e42f079237e_PLY_','2022-02-01 11:48:06','2019-07-11 18:00:57','22cfb1de-6153-4a24-bebb-7e12f044f64a.ply','2022-02-01 12:48:06','SYNCED','22cfb1de-6153-4a24-bebb-7e12f044f64a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 47.1.1.1\",\"modelMatrix\":\"-0.658096,0.752258,-0.0318884,0,-0.752934,-0.657506,0.0278718,0,1.28874e-9,0.0423522,0.999103,0,4.41864,30.1535,-25.8921,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'22e1f3b9-0d4f-4b31-bbdb-0fee799c4728','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/22e1f3b9-0d4f-4b31-bbdb-0fee799c4728.stl','STL','PATIENT_b91b12ac-6144-42d7-97e8-da7ac9eebdc2_ACT_7563c172-7fae-490c-aef8-357e72d49088_SESS_28794cdb-fd2d-42c7-bbc0-00011c3add7a_BOSC_466db563-b1e3-4b62-b9bb-8273cd11dcf3_STL_','2022-03-04 13:40:29','2019-07-10 12:11:17','22e1f3b9-0d4f-4b31-bbdb-0fee799c4728.stl','2022-03-04 14:40:29','SYNCED','22e1f3b9-0d4f-4b31-bbdb-0fee799c4728',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 27.1.1.1\",\"modelMatrix\":\"-0.878488,-0.457458,0.137805,0,0.477764,-0.841151,0.253389,0,8.85833e-9,0.288437,0.957499,0,-30.7751,2.91535,-23.4267,1\",\"title\":\"MANDIBULE STL\"}'),(2,'22e67d4a-361b-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/22e67d4a-361b-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_c13f3da9-c793-4658-ab25-6b392b783949_ACT_f1cefff9-41ec-4f30-8fab-06042613a303_SESS_3f278eda-318c-43b4-b531-cb9208a8b2ec_BOSC_ee53a6b4-fced-4821-b98c-09c9ef1d2848_PLY_','2021-02-11 15:55:56','2020-01-13 16:40:28','22e67d4a-361b-11ea-947d-226cec7cb58a.ply','2021-02-11 16:55:56','SYNCED','22e67d4a-361b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.1.1.2\",\"modelMatrix\":\"0.546044,-0.834239,0.0766859,0,0.837757,0.543751,-0.0499833,0,-6.51994e-10,0.0915372,0.995802,0,-9.05599,-20.6099,-19.9333,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'22e873dd-361b-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/22e873dd-361b-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_c13f3da9-c793-4658-ab25-6b392b783949_ACT_f1cefff9-41ec-4f30-8fab-06042613a303_SESS_3f278eda-318c-43b4-b531-cb9208a8b2ec_TOSC_0d1ffc8b-fde2-4e1a-9dd4-78445b4a30a1_SNAPS_','2021-02-11 15:55:56','2020-01-13 16:34:51','22e873dd-361b-11ea-947d-226cec7cb58a.png','2021-02-11 16:55:56','SYNCED','22e873dd-361b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'22ea2fa0-361b-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/22ea2fa0-361b-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_c13f3da9-c793-4658-ab25-6b392b783949_ACT_f1cefff9-41ec-4f30-8fab-06042613a303_SESS_3f278eda-318c-43b4-b531-cb9208a8b2ec_TOSC_0d1ffc8b-fde2-4e1a-9dd4-78445b4a30a1_PLY_','2021-02-11 15:55:56','2020-01-13 16:34:51','22ea2fa0-361b-11ea-947d-226cec7cb58a.ply','2021-02-11 16:55:56','SYNCED','22ea2fa0-361b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1.1\",\"modelMatrix\":\"0.0459448,-0.931156,0.361715,0,0.998944,0.042827,-0.0166365,0,4.68948e-10,0.362097,0.93214,0,-16.9557,-16.291,-21.9227,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'22ed8c50-361b-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/22ed8c50-361b-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_c13f3da9-c793-4658-ab25-6b392b783949_ACT_f1cefff9-41ec-4f30-8fab-06042613a303_SESS_3f278eda-318c-43b4-b531-cb9208a8b2ec_BOSC_ee53a6b4-fced-4821-b98c-09c9ef1d2848_SNAPS_','2021-02-11 15:55:56','2020-01-13 16:40:28','22ed8c50-361b-11ea-947d-226cec7cb58a.png','2021-02-11 16:55:56','SYNCED','22ed8c50-361b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.1.1.2\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'2306e742-3112-4b7e-a96b-35db540f844d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2306e742-3112-4b7e-a96b-35db540f844d.ply','PLY','PATIENT_990204e3-cf2f-4026-952f-1dddcf7ba877_ACT_7cc92ba2-1d5b-419e-a74a-49ee200bad42_SESS_12c31307-3c9f-4293-9271-370e33e4c708_TOSC_c193f66e-9b14-4e27-8f24-25c41a008157_PLY_','2022-02-01 11:48:06','2019-07-12 13:59:20','2306e742-3112-4b7e-a96b-35db540f844d.ply','2022-02-01 12:48:06','SYNCED','2306e742-3112-4b7e-a96b-35db540f844d',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 56.1.1.1\",\"modelMatrix\":\"0.707448,-0.677626,0.200847,0,0.706765,0.678282,-0.201041,0,-7.68818e-9,0.284178,0.958772,0,3.48375,-35.3691,-16.2954,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'231f8a10-3c54-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/231f8a10-3c54-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_52bf5802-4b38-492b-8770-ed589e047dbc_SESS_ba52c0de-80dc-4ce3-b5b0-23a5b67e49a5_BOSC_62607abc-fbec-4844-9fc3-cfe3ae2ee1c6_SNAPS_','2021-02-11 15:55:58','2020-01-21 14:44:10','231f8a10-3c54-11ea-947d-226cec7cb58a.png','2021-02-11 16:55:58','SYNCED','231f8a10-3c54-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'232170a1-3c54-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/232170a1-3c54-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_f332cd22-e768-490b-a9b7-4ac8e869da6f_ACT_52bf5802-4b38-492b-8770-ed589e047dbc_SESS_ba52c0de-80dc-4ce3-b5b0-23a5b67e49a5_TOSC_de9a9522-c728-4824-8a3e-542474c1ef0d_SNAPS_','2021-02-11 15:55:58','2020-01-21 14:40:16','232170a1-3c54-11ea-947d-226cec7cb58a.png','2021-02-11 16:55:58','SYNCED','232170a1-3c54-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'232307d6-3c54-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/232307d6-3c54-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_f332cd22-e768-490b-a9b7-4ac8e869da6f_ACT_52bf5802-4b38-492b-8770-ed589e047dbc_SESS_ba52c0de-80dc-4ce3-b5b0-23a5b67e49a5_TOSC_de9a9522-c728-4824-8a3e-542474c1ef0d_PLY_','2021-02-11 15:55:58','2020-01-21 14:40:16','232307d6-3c54-11ea-947d-226cec7cb58a.ply','2021-02-11 16:55:58','SYNCED','232307d6-3c54-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.1.1.1.1\",\"modelMatrix\":\"-0.415623,-0.896246,0.154923,0,0.909537,-0.40955,0.0707939,0,-1.78619e-9,0.170332,0.985387,0,-25.4642,-12.1786,-16.1714,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'2324c3aa-3c54-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2324c3aa-3c54-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_52bf5802-4b38-492b-8770-ed589e047dbc_SESS_ba52c0de-80dc-4ce3-b5b0-23a5b67e49a5_BOSC_62607abc-fbec-4844-9fc3-cfe3ae2ee1c6_PLY_','2021-02-11 15:55:58','2020-01-21 14:44:10','2324c3aa-3c54-11ea-947d-226cec7cb58a.ply','2021-02-11 16:55:58','SYNCED','2324c3aa-3c54-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.1.1.1.1\",\"modelMatrix\":\"-0.967335,0.240501,-0.0801388,0,-0.253501,-0.917727,0.305802,0,7.84605e-9,0.316128,0.948717,0,-2.99162,14.0669,-19.9103,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'23338ff2-dc56-42bd-b1d0-9c5c764b7010','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/23338ff2-dc56-42bd-b1d0-9c5c764b7010.png','SNAPS','PATIENT_28da837d-b270-4c64-a49b-609a27dfbf59_ACT_38cbf729-ea81-4758-b1f1-e1d4e43ec5e6_SESS_d015bead-b2da-46e2-b4dd-1364cd56bc0b_BOSC_39da3e5f-6d40-4537-b9ba-6fa1daec4ff6_SNAPS_','2021-12-30 18:04:16','2019-11-13 10:30:38','23338ff2-dc56-42bd-b1d0-9c5c764b7010.png','2021-12-30 19:04:16','SYNCED','23338ff2-dc56-42bd-b1d0-9c5c764b7010',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 201.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'234974fc-95f3-460e-8ec6-8d4c158b5208','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/234974fc-95f3-460e-8ec6-8d4c158b5208.png','SNAPS','PATIENT_b0ea3f28-1fc0-470c-b47a-a394ed2e5f21_ACT_96214f4b-9456-4208-b81d-5b82b21b335a_SESS_07baa47f-dbc6-44a6-834f-d97971fa404b_TOSC_29809c5e-509e-4da7-8893-06936a8d53e6_SNAPS_','2021-02-11 15:55:58','2020-02-11 16:35:47','234974fc-95f3-460e-8ec6-8d4c158b5208.png','2021-02-11 16:55:58','SYNCED','234974fc-95f3-460e-8ec6-8d4c158b5208',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'2353156a-6473-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2353156a-6473-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_6e51df23-9789-49af-8c8c-1f005b5ee0c4_SESS_29fc0730-9b51-4316-8821-cc0374638b3c_TOSC_59b6541a-e3bd-4c9d-adc5-4e2e666e1e43_SNAPS_','2021-02-11 15:55:59','2020-03-12 16:06:53','2353156a-6473-11ea-947d-226cec7cb58a.png','2021-02-11 16:55:59','SYNCED','2353156a-6473-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.4.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'2355109c-6473-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2355109c-6473-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_6e51df23-9789-49af-8c8c-1f005b5ee0c4_SESS_29fc0730-9b51-4316-8821-cc0374638b3c_BOSC_22e762cd-8ea5-4903-8122-5eb961511189_SNAPS_','2021-02-11 15:55:59','2020-03-12 15:56:38','2355109c-6473-11ea-947d-226cec7cb58a.png','2021-02-11 16:55:59','SYNCED','2355109c-6473-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.4.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'2356dcc3-6473-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2356dcc3-6473-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_6e51df23-9789-49af-8c8c-1f005b5ee0c4_SESS_29fc0730-9b51-4316-8821-cc0374638b3c_TOSC_59b6541a-e3bd-4c9d-adc5-4e2e666e1e43_PLY_','2021-02-11 15:55:59','2020-03-12 16:06:53','2356dcc3-6473-11ea-947d-226cec7cb58a.ply','2021-02-11 16:55:59','SYNCED','2356dcc3-6473-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.4.1.1\",\"modelMatrix\":\"0.429605,-0.876847,0.215821,0,0.903017,0.417155,-0.102675,0,-1.53026e-9,0.239,0.97102,0,-8.30295,-34.6034,-16.7602,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'2358afe0-6473-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2358afe0-6473-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_6e51df23-9789-49af-8c8c-1f005b5ee0c4_SESS_29fc0730-9b51-4316-8821-cc0374638b3c_BOSC_22e762cd-8ea5-4903-8122-5eb961511189_PLY_','2021-02-11 15:55:59','2020-03-12 15:56:38','2358afe0-6473-11ea-947d-226cec7cb58a.ply','2021-02-11 16:55:59','SYNCED','2358afe0-6473-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.4.1.1\",\"modelMatrix\":\"-0.801977,0.592695,-0.0744732,0,-0.597355,-0.79572,0.0999836,0,1.21403e-10,0.124671,0.992198,0,-1.74155,18.9286,-19.3827,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'235aa107-59dd-47b2-8db4-a983648fe699','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/235aa107-59dd-47b2-8db4-a983648fe699.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_6adeb7d6-f8e6-4e09-b4f9-34e08a81d86e_SESS_e2775ea7-f13a-4b82-ae07-b770697898b9_BOSC_ed0f4714-03df-459a-a00b-623287afc080_PLY_','2021-02-11 15:55:59','2020-06-05 16:00:31','235aa107-59dd-47b2-8db4-a983648fe699.ply','2021-02-11 16:55:59','SYNCED','235aa107-59dd-47b2-8db4-a983648fe699',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.25.1.1\",\"modelMatrix\":\"-0.998044,0.05906,-0.0204835,0,-0.0625113,-0.942942,0.327036,0,2.12047e-9,0.327677,0.94479,0,-16.9624,13.2098,-20.0497,1\",\"title\":\"Mandibule PLY\"}'),(2,'235ac401-a17a-11e9-a33b-226cec7cb58a','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/235ac401-a17a-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_6eb305c5-7c97-42eb-952b-d53ef4722531_ACT_436d105e-3c8a-43c0-bc90-f0470fa4ed39_SESS_3cebc938-b215-44d1-9690-224ae019612a_TOSC_7ffa7ffa-7bbe-411e-b43d-96897a556f73_STL_','2022-03-04 13:40:29','2019-07-08 16:22:52','235ac401-a17a-11e9-a33b-226cec7cb58a.stl','2022-03-04 14:40:29','SYNCED','235ac401-a17a-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 6.1.1.1\",\"modelMatrix\":\"0.965275,-0.259652,0.0287128,0,0.261235,0.959427,-0.106095,0,2.53285e-10,0.109912,0.993941,0,-29.3021,-21.1255,-16.5088,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'235b8261-a17a-11e9-a33b-226cec7cb58a','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/235b8261-a17a-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_6eb305c5-7c97-42eb-952b-d53ef4722531_ACT_436d105e-3c8a-43c0-bc90-f0470fa4ed39_SESS_3cebc938-b215-44d1-9690-224ae019612a_BOSC_ab00831c-a593-4918-aacc-a44c1ee55c28_SNAPS_','2022-03-04 13:40:29','2019-07-08 16:18:59','235b8261-a17a-11e9-a33b-226cec7cb58a.png','2022-03-04 14:40:29','SYNCED','235b8261-a17a-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 6.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'235d431c-a17a-11e9-a33b-226cec7cb58a','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/235d431c-a17a-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_6eb305c5-7c97-42eb-952b-d53ef4722531_ACT_436d105e-3c8a-43c0-bc90-f0470fa4ed39_SESS_3cebc938-b215-44d1-9690-224ae019612a_BOSC_ab00831c-a593-4918-aacc-a44c1ee55c28_STL_','2022-03-04 13:40:29','2019-07-08 16:18:59','235d431c-a17a-11e9-a33b-226cec7cb58a.stl','2022-03-04 14:40:29','SYNCED','235d431c-a17a-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 6.1.1.1\",\"modelMatrix\":\"-0.722505,-0.651927,0.230167,0,0.691365,-0.681291,0.240534,0,5.28e-9,0.332916,0.942956,0,9.13382,26.8096,-24.1674,1\",\"title\":\"MANDIBULE STL\"}'),(2,'235dcd37-a17a-11e9-a33b-226cec7cb58a','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/235dcd37-a17a-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_6eb305c5-7c97-42eb-952b-d53ef4722531_ACT_436d105e-3c8a-43c0-bc90-f0470fa4ed39_SESS_3cebc938-b215-44d1-9690-224ae019612a_BOSC_ab00831c-a593-4918-aacc-a44c1ee55c28_PLY_','2022-03-04 13:40:29','2019-07-08 16:18:59','235dcd37-a17a-11e9-a33b-226cec7cb58a.ply','2022-03-04 14:40:29','SYNCED','235dcd37-a17a-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 6.1.1.1\",\"modelMatrix\":\"-0.722505,-0.651927,0.230167,0,0.691365,-0.681291,0.240534,0,5.28e-9,0.332916,0.942956,0,9.13382,26.8096,-24.1674,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'235e619b-a17a-11e9-a33b-226cec7cb58a','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/235e619b-a17a-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_6eb305c5-7c97-42eb-952b-d53ef4722531_ACT_436d105e-3c8a-43c0-bc90-f0470fa4ed39_SESS_3cebc938-b215-44d1-9690-224ae019612a_TOSC_7ffa7ffa-7bbe-411e-b43d-96897a556f73_PLY_','2022-03-04 13:40:29','2019-07-08 16:22:52','235e619b-a17a-11e9-a33b-226cec7cb58a.ply','2022-03-04 14:40:29','SYNCED','235e619b-a17a-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 6.1.1.1\",\"modelMatrix\":\"0.965275,-0.259652,0.0287128,0,0.261235,0.959427,-0.106095,0,2.53285e-10,0.109912,0.993941,0,-29.3021,-21.1255,-16.5088,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'235f04cc-a17a-11e9-a33b-226cec7cb58a','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/235f04cc-a17a-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_6eb305c5-7c97-42eb-952b-d53ef4722531_ACT_436d105e-3c8a-43c0-bc90-f0470fa4ed39_SESS_3cebc938-b215-44d1-9690-224ae019612a_TOSC_7ffa7ffa-7bbe-411e-b43d-96897a556f73_SNAPS_','2022-03-04 13:40:30','2019-07-08 16:22:52','235f04cc-a17a-11e9-a33b-226cec7cb58a.png','2022-03-04 14:40:30','SYNCED','235f04cc-a17a-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 6.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'236b7f36-aeba-44eb-8a42-8cee3716a9ba','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/236b7f36-aeba-44eb-8a42-8cee3716a9ba.png','SNAPS','PATIENT_1703ba62-35c6-4b8c-8017-7e720f790f3a_ACT_d55baca2-6f09-4446-a148-dcdcfcaf57d8_SESS_5efdc987-8bdd-454f-b282-82efcf807bae_TOSC_dcbc56e6-2eed-4eb4-8bd7-1772f7d5c1eb_SNAPS_','2021-08-19 22:42:36','2019-11-26 14:53:46','236b7f36-aeba-44eb-8a42-8cee3716a9ba.png','2021-08-20 00:42:36','SYNCED','236b7f36-aeba-44eb-8a42-8cee3716a9ba',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.31.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'2384b3d3-8ce6-45a3-9839-61c8c65183ac','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2384b3d3-8ce6-45a3-9839-61c8c65183ac.stl','STL','PATIENT_8fa2891d-7bba-4605-bf05-54a276fd00f4_ACT_16441b00-310c-4cfa-bf2b-0ab01025332e_SESS_feeefb5e-69b6-4e19-ac4c-f3518e1a16dd_TOSC_3bae9dda-89c2-4f25-bcb3-9912f777bd9d_STL_','2022-02-01 11:48:08','2019-08-01 15:29:22','2384b3d3-8ce6-45a3-9839-61c8c65183ac.stl','2022-02-01 12:48:08','SYNCED','2384b3d3-8ce6-45a3-9839-61c8c65183ac',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 122.1.1.1\",\"modelMatrix\":\"-0.440084,-0.841329,0.313835,0,0.897957,-0.412331,0.153809,0,4.41689e-10,0.349499,0.936937,0,-32.2555,-18.4415,-26.9918,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'239047ab-0713-4398-a63a-bc0f1bfee480','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/239047ab-0713-4398-a63a-bc0f1bfee480.png','SNAPS','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_706607e7-f61a-4947-b93f-328973a9c8c9_SESS_d5efdc11-49bf-402f-9991-513e8fdf51e5_BOSC_7779a589-a960-4c88-a390-02306cad063e_SNAPS_','2021-02-11 15:56:00','2020-01-24 11:01:25','239047ab-0713-4398-a63a-bc0f1bfee480.png','2021-02-11 16:56:00','SYNCED','239047ab-0713-4398-a63a-bc0f1bfee480',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'2392b506-cbd5-4c3f-b867-89e959e3e274','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2392b506-cbd5-4c3f-b867-89e959e3e274.ply','PLY','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_8848f527-608e-47db-980d-f74c99869fc5_SESS_269e5643-d9ad-470e-ad19-419796f8f2cf_TOSC_f424564c-c637-4a95-b806-ac36cbdc9d18_PLY_','2021-02-11 15:56:01','2020-03-12 15:41:28','2392b506-cbd5-4c3f-b867-89e959e3e274.ply','2021-02-11 16:56:01','SYNCED','2392b506-cbd5-4c3f-b867-89e959e3e274',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.16.3.1.1\",\"modelMatrix\":\"0.212671,-0.926713,0.309796,0,0.977124,0.201699,-0.067427,0,-1.27427e-9,0.317049,0.948409,0,-11.9371,-31.7103,-19.8231,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'2397b966-3a19-44e2-8cc1-5fb92f9d1ad5','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2397b966-3a19-44e2-8cc1-5fb92f9d1ad5.ply','PLY','PATIENT_bfff99cf-e91f-4eed-bb3a-06bece8eaf9f_ACT_b7db8e0b-e4ee-4ca1-9241-e0560c7ce60e_SESS_2c37c218-3e15-4247-84ed-d4e685e2455e_BOSC_5d2b9a2b-3a16-4a5e-8da5-b30887bafb5b_PLY_','2021-02-11 15:56:01','2019-12-18 12:09:35','2397b966-3a19-44e2-8cc1-5fb92f9d1ad5.ply','2021-02-11 16:56:01','SYNCED','2397b966-3a19-44e2-8cc1-5fb92f9d1ad5',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 20.1.267.1.1.1\",\"modelMatrix\":\"-0.959709,-0.272558,0.0683373,0,0.280994,-0.930896,0.233399,0,-1.97107e-9,0.243198,0.969977,0,-17.5914,11.7443,-21.7065,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'239d4cb9-3f4e-4b85-addb-d21db64ff73a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/239d4cb9-3f4e-4b85-addb-d21db64ff73a.png','SNAPS','PATIENT_1fe53bd5-165d-4f83-8b14-5ccfa106502b_ACT_47fe2ba9-f5ad-42b7-b29b-475d98d6c3d9_SESS_0ebe1667-9b32-41d1-b4c9-a74f9fad08a2_BOSC_2f55f9cb-2759-4560-bf2f-9110d4d4b209_SNAPS_','2021-02-16 16:40:13','2019-12-13 14:53:29','239d4cb9-3f4e-4b85-addb-d21db64ff73a.png','2021-02-16 17:40:13','SYNCED','239d4cb9-3f4e-4b85-addb-d21db64ff73a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 232.3.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'239f0379-d7a5-42ed-b2a8-9750c3f3e195','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/239f0379-d7a5-42ed-b2a8-9750c3f3e195.png','SNAPS','PATIENT_7237dc5d-0c61-4cb9-b1db-a73cd6a11ada_ACT_c3ed1bf2-28aa-48d2-a107-07a01b82e9af_SESS_558f874e-8228-460b-a7fa-2ee26150b988_TOSC_64e8cb05-12f0-4e95-9fe8-974f57289a89_SNAPS_','2021-02-11 15:56:01','2019-12-18 14:01:21','239f0379-d7a5-42ed-b2a8-9750c3f3e195.png','2021-02-11 16:56:01','SYNCED','239f0379-d7a5-42ed-b2a8-9750c3f3e195',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 21.1.268.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'23a44875-2d3d-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/23a44875-2d3d-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_739dd02c-68c8-4648-8b0f-e0a050d5e395_SESS_dfcde062-5ae1-4aa9-ad94-86d9b63e99f2_BOSC_b87c21bf-84b4-4962-9f39-0d17ff0d3351_PLY_','2021-02-11 15:56:01','2020-01-02 09:36:48','23a44875-2d3d-11ea-947d-226cec7cb58a.ply','2021-02-11 16:56:01','SYNCED','23a44875-2d3d-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"modelMatrix\":\"-0.994324,0.103447,-0.0248787,0,-0.106397,-0.966759,0.232502,0,1.1885e-9,0.233829,0.972278,0,-10.947,18.3198,-19.8663,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'23a63c54-2d3d-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/23a63c54-2d3d-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_3642cf18-bc4c-48dc-ae0e-2ec85c510567_ACT_739dd02c-68c8-4648-8b0f-e0a050d5e395_SESS_dfcde062-5ae1-4aa9-ad94-86d9b63e99f2_TOSC_a3941f11-24b3-4980-8c7c-fd26177cd72e_PLY_','2021-02-11 15:56:01','2020-01-02 09:31:10','23a63c54-2d3d-11ea-947d-226cec7cb58a.ply','2021-02-11 16:56:01','SYNCED','23a63c54-2d3d-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"modelMatrix\":\"0.182767,-0.965449,0.185755,0,0.983156,0.179475,-0.0345315,0,-2.84236e-9,0.188937,0.981989,0,-14.3155,-17.6281,-19.0567,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'23a6d384-3a80-471d-8afc-995e24875c82','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/23a6d384-3a80-471d-8afc-995e24875c82.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_1cf8bd71-aab9-4f6f-82fe-3d87cab0a57f_SESS_2a95fd48-b4d6-433c-9254-cd2ec1e9a139_BOSC_27dad09a-ce91-43a3-bb86-671ce73ab120_PLY_','2021-02-11 15:56:01','2020-06-16 15:17:50','23a6d384-3a80-471d-8afc-995e24875c82.ply','2021-02-11 16:56:01','SYNCED','23a6d384-3a80-471d-8afc-995e24875c82',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.48.1.1\",\"modelMatrix\":\"-0.674045,0.737051,-0.0491879,0,-0.73869,-0.672549,0.0448833,0,-1.56973e-10,0.066588,0.997781,0,3.06201,19.2564,-19.3819,1\",\"title\":\"Mandibule PLY\"}'),(2,'23ac7c00-2d3d-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/23ac7c00-2d3d-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_739dd02c-68c8-4648-8b0f-e0a050d5e395_SESS_dfcde062-5ae1-4aa9-ad94-86d9b63e99f2_BOSC_b87c21bf-84b4-4962-9f39-0d17ff0d3351_SNAPS_','2021-02-11 15:56:02','2020-01-02 09:36:48','23ac7c00-2d3d-11ea-947d-226cec7cb58a.png','2021-02-11 16:56:02','SYNCED','23ac7c00-2d3d-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'23ad0c14-eb59-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/23ad0c14-eb59-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_4887c403-6684-431d-9efd-4230d74f9f6e_ACT_b67be1ff-ec7d-4035-9281-b8e4b218da86_SESS_1c9989e2-d42d-4cab-80e3-b783c63d8a22_BOSC_018e2213-672e-4d3a-b803-426a6ae54b82_PLY_','2021-12-30 18:04:19','2019-10-10 14:24:13','23ad0c14-eb59-11e9-947d-226cec7cb58a.ply','2021-12-30 19:04:19','SYNCED','23ad0c14-eb59-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 184.1.1.1\",\"modelMatrix\":\"0.966458,-0.256743,0.00650652,0,0.256826,0.966148,-0.0244846,0,-2.09839e-10,0.0253344,0.999679,0,9.6621,-23.4411,-23.1822,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'23adf987-2d3d-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/23adf987-2d3d-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_3642cf18-bc4c-48dc-ae0e-2ec85c510567_ACT_739dd02c-68c8-4648-8b0f-e0a050d5e395_SESS_dfcde062-5ae1-4aa9-ad94-86d9b63e99f2_TOSC_a3941f11-24b3-4980-8c7c-fd26177cd72e_SNAPS_','2021-02-11 15:56:02','2020-01-02 09:31:10','23adf987-2d3d-11ea-947d-226cec7cb58a.png','2021-02-11 16:56:02','SYNCED','23adf987-2d3d-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'23aeebca-eb59-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/23aeebca-eb59-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_4887c403-6684-431d-9efd-4230d74f9f6e_ACT_b67be1ff-ec7d-4035-9281-b8e4b218da86_SESS_1c9989e2-d42d-4cab-80e3-b783c63d8a22_TOSC_b3ad7e7c-a51b-4b65-870b-4ffabed1c10b_PLY_','2021-12-30 18:04:19','2019-10-10 14:20:30','23aeebca-eb59-11e9-947d-226cec7cb58a.ply','2021-12-30 19:04:19','SYNCED','23aeebca-eb59-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 184.1.1.1\",\"modelMatrix\":\"0.733226,-0.629536,0.25703,0,0.679985,0.678827,-0.277155,0,2.52571e-10,0.377993,0.925808,0,8.11236,-32.0667,-19.5463,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'23b07258-eb59-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/23b07258-eb59-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_4887c403-6684-431d-9efd-4230d74f9f6e_ACT_b67be1ff-ec7d-4035-9281-b8e4b218da86_SESS_1c9989e2-d42d-4cab-80e3-b783c63d8a22_TOSC_b3ad7e7c-a51b-4b65-870b-4ffabed1c10b_SNAPS_','2021-12-30 18:04:19','2019-10-10 14:20:30','23b07258-eb59-11e9-947d-226cec7cb58a.png','2021-12-30 19:04:19','SYNCED','23b07258-eb59-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 184.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'23b1f78c-eb59-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/23b1f78c-eb59-11e9-947d-226cec7cb58a.stl','STL','PATIENT_4887c403-6684-431d-9efd-4230d74f9f6e_ACT_b67be1ff-ec7d-4035-9281-b8e4b218da86_SESS_1c9989e2-d42d-4cab-80e3-b783c63d8a22_BOSC_018e2213-672e-4d3a-b803-426a6ae54b82_STL_','2021-12-30 18:04:19','2019-10-10 14:24:13','23b1f78c-eb59-11e9-947d-226cec7cb58a.stl','2021-12-30 19:04:19','SYNCED','23b1f78c-eb59-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 184.1.1.1\",\"modelMatrix\":\"0.966458,-0.256743,0.00650652,0,0.256826,0.966148,-0.0244846,0,-2.09839e-10,0.0253344,0.999679,0,9.6621,-23.4411,-23.1822,1\",\"title\":\"MANDIBULE STL\"}'),(2,'23b3e343-eb59-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/23b3e343-eb59-11e9-947d-226cec7cb58a.stl','STL','PATIENT_4887c403-6684-431d-9efd-4230d74f9f6e_ACT_b67be1ff-ec7d-4035-9281-b8e4b218da86_SESS_1c9989e2-d42d-4cab-80e3-b783c63d8a22_TOSC_b3ad7e7c-a51b-4b65-870b-4ffabed1c10b_STL_','2021-12-30 18:04:19','2019-10-10 14:20:30','23b3e343-eb59-11e9-947d-226cec7cb58a.stl','2021-12-30 19:04:19','SYNCED','23b3e343-eb59-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 184.1.1.1\",\"modelMatrix\":\"0.733226,-0.629536,0.25703,0,0.679985,0.678827,-0.277155,0,2.52571e-10,0.377993,0.925808,0,8.11236,-32.0667,-19.5463,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'23b558f5-eb59-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/23b558f5-eb59-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_4887c403-6684-431d-9efd-4230d74f9f6e_ACT_b67be1ff-ec7d-4035-9281-b8e4b218da86_SESS_1c9989e2-d42d-4cab-80e3-b783c63d8a22_BOSC_018e2213-672e-4d3a-b803-426a6ae54b82_SNAPS_','2021-12-30 18:04:20','2019-10-10 14:24:13','23b558f5-eb59-11e9-947d-226cec7cb58a.png','2021-12-30 19:04:20','SYNCED','23b558f5-eb59-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 184.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'23b85bba-c136-40c3-9697-ee9567c21ea6','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/23b85bba-c136-40c3-9697-ee9567c21ea6.ply','PLY','PATIENT_2f28ecf2-8a3a-41d4-86bb-cf55c01ad025_ACT_78f6ee3e-94b9-419c-8442-ddf8e957291f_SESS_99544d16-2b44-4c4f-98f5-39f771e05aca_BOSC_2500145f-45ac-42f3-b6a0-782b09ad92f9_PLY_','2021-12-30 18:04:20','2019-10-17 14:04:49','23b85bba-c136-40c3-9697-ee9567c21ea6.ply','2021-12-30 19:04:20','SYNCED','23b85bba-c136-40c3-9697-ee9567c21ea6',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 192.1.1.1\",\"modelMatrix\":\"0.313634,0.946507,-0.0758869,0,-0.949544,0.312631,-0.0250655,0,2.01687e-9,0.0799194,0.996801,0,16.8315,6.47046,-26.097,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'23e18945-34ea-4a8f-b4ca-cf87dade455d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/23e18945-34ea-4a8f-b4ca-cf87dade455d.ply','PLY','PATIENT_55452abe-c899-4508-a6ad-a6862da81096_ACT_10244838-8d43-4b45-843e-1b1867b80fe9_SESS_a27242e6-79e3-49b8-9935-388a52c32306_TOSC_aea1fa8c-8814-4f7e-8d30-87495a2f6ef6_PLY_','2021-02-11 15:56:04','2020-06-17 09:36:51','23e18945-34ea-4a8f-b4ca-cf87dade455d.ply','2021-02-11 16:56:04','SYNCED','4a092f6f-22e6-47e8-8f6c-e41b34431c9c',1,NULL,'','','{\"displayTitle\":\"Maxillaire 32.1.1.1.8\",\"modelMatrix\":\"0.637422,-0.723858,0.264052,0,0.770515,0.598824,-0.218441,0,1.01263e-8,0.342695,0.939447,0,-1.82175,-36.7908,-14.5954,1\",\"title\":\"Maxillaire PLY\"}'),(2,'23f61070-3bbe-41cd-8da2-cd31bf4f8cc5','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/23f61070-3bbe-41cd-8da2-cd31bf4f8cc5.ply','PLY','PATIENT_0a978937-37d2-4044-a9bd-50cb59fb7012_ACT_a7064a8b-e27d-4d86-b80c-4e581e435c56_SESS_6248d1d4-8069-4bd6-b69e-9cf7dbdade6e_TOSC_bb0fbda7-d59a-44b6-bc38-b165467dbab3_PLY_','2022-02-01 11:48:08','2019-07-24 09:55:56','23f61070-3bbe-41cd-8da2-cd31bf4f8cc5.ply','2022-02-01 12:48:08','SYNCED','23f61070-3bbe-41cd-8da2-cd31bf4f8cc5',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 111.1.1.1\",\"modelMatrix\":\"0.556368,-0.781399,0.282613,0,0.830936,0.5232,-0.189229,0,-1.41637e-8,0.340114,0.940384,0,-6.09525,-35.5209,-19.8043,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'242c587e-47fd-4bc6-8619-c88ba7c3fca6','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/242c587e-47fd-4bc6-8619-c88ba7c3fca6.png','SNAPS','PATIENT_13334e1b-6b42-4e97-a738-b6332758df79_ACT_fb15c2ed-ff86-4f06-8005-6289a061e90e_SESS_eebbe153-656d-4d14-8323-06127ce56e9f_TOSC_46bceccf-5f12-41e9-ad14-f80f205ce34e_SNAPS_','2021-02-11 15:56:04','2020-02-28 13:56:39','242c587e-47fd-4bc6-8619-c88ba7c3fca6.png','2021-02-11 16:56:04','SYNCED','242c587e-47fd-4bc6-8619-c88ba7c3fca6',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'2431a668-1f24-4c92-9573-de6f28a38656','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2431a668-1f24-4c92-9573-de6f28a38656.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_6079dc2b-a3c3-468c-a7a3-54b4ec6bc8c2_SNAPS_','2021-02-11 15:56:04','2020-01-24 13:29:57','2431a668-1f24-4c92-9573-de6f28a38656.png','2021-02-11 16:56:04','SYNCED','2431a668-1f24-4c92-9573-de6f28a38656',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'2446688f-a3cc-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2446688f-a3cc-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_800e5513-5023-48f2-9c4d-10c8100e77b8_ACT_3496764d-672e-4434-be29-beb06b419e6f_SESS_4904be4e-9f42-485f-a33f-b682e3b55bfa_TOSC_8fd20f85-5c33-4d5c-8705-c05ff2a4f810_STL_','2022-02-01 11:48:08','2019-07-11 14:41:31','2446688f-a3cc-11e9-a33b-226cec7cb58a.stl','2022-02-01 12:48:08','SYNCED','2446688f-a3cc-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 43.1.1.1\",\"modelMatrix\":\"0.73471,-0.660563,0.154464,0,0.678382,0.715411,-0.167289,0,-3.44059e-9,0.227694,0.973733,0,-0.0448326,-35.5872,-15.0178,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'24470a29-a3cc-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/24470a29-a3cc-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_800e5513-5023-48f2-9c4d-10c8100e77b8_ACT_3496764d-672e-4434-be29-beb06b419e6f_SESS_4904be4e-9f42-485f-a33f-b682e3b55bfa_BOSC_7e5c9af3-a302-40a4-8e3f-b8eeaeb6643a_STL_','2022-02-01 11:48:08','2019-07-11 14:45:08','24470a29-a3cc-11e9-a33b-226cec7cb58a.stl','2022-02-01 12:48:08','SYNCED','24470a29-a3cc-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 43.1.1.1\",\"modelMatrix\":\"-0.977294,-0.205259,0.0525806,0,0.211887,-0.946725,0.24252,0,8.12528e-10,0.248155,0.96872,0,-23.0236,11.3024,-22.9651,1\",\"title\":\"MANDIBULE STL\"}'),(2,'2447972a-a3cc-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2447972a-a3cc-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_800e5513-5023-48f2-9c4d-10c8100e77b8_ACT_3496764d-672e-4434-be29-beb06b419e6f_SESS_4904be4e-9f42-485f-a33f-b682e3b55bfa_TOSC_8fd20f85-5c33-4d5c-8705-c05ff2a4f810_SNAPS_','2022-02-01 11:48:08','2019-07-11 14:41:31','2447972a-a3cc-11e9-a33b-226cec7cb58a.png','2022-02-01 12:48:08','SYNCED','2447972a-a3cc-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 43.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'24484252-a3cc-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/24484252-a3cc-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_800e5513-5023-48f2-9c4d-10c8100e77b8_ACT_3496764d-672e-4434-be29-beb06b419e6f_SESS_4904be4e-9f42-485f-a33f-b682e3b55bfa_BOSC_7e5c9af3-a302-40a4-8e3f-b8eeaeb6643a_PLY_','2022-02-01 11:48:09','2019-07-11 14:45:08','24484252-a3cc-11e9-a33b-226cec7cb58a.ply','2022-02-01 12:48:09','SYNCED','24484252-a3cc-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 43.1.1.1\",\"modelMatrix\":\"-0.977294,-0.205259,0.0525806,0,0.211887,-0.946725,0.24252,0,8.12528e-10,0.248155,0.96872,0,-23.0236,11.3024,-22.9651,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'2448dae6-a3cc-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2448dae6-a3cc-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_800e5513-5023-48f2-9c4d-10c8100e77b8_ACT_3496764d-672e-4434-be29-beb06b419e6f_SESS_4904be4e-9f42-485f-a33f-b682e3b55bfa_BOSC_7e5c9af3-a302-40a4-8e3f-b8eeaeb6643a_SNAPS_','2022-02-01 11:48:09','2019-07-11 14:45:08','2448dae6-a3cc-11e9-a33b-226cec7cb58a.png','2022-02-01 12:48:09','SYNCED','2448dae6-a3cc-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 43.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'24497927-a3cc-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/24497927-a3cc-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_800e5513-5023-48f2-9c4d-10c8100e77b8_ACT_3496764d-672e-4434-be29-beb06b419e6f_SESS_4904be4e-9f42-485f-a33f-b682e3b55bfa_TOSC_8fd20f85-5c33-4d5c-8705-c05ff2a4f810_PLY_','2022-02-01 11:48:09','2019-07-11 14:41:31','24497927-a3cc-11e9-a33b-226cec7cb58a.ply','2022-02-01 12:48:09','SYNCED','24497927-a3cc-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 43.1.1.1\",\"modelMatrix\":\"0.73471,-0.660563,0.154464,0,0.678382,0.715411,-0.167289,0,-3.44059e-9,0.227694,0.973733,0,-0.0448326,-35.5872,-15.0178,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'2459df7c-3e8f-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2459df7c-3e8f-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_4f482827-5082-4728-9f38-c433a5ca405c_ACT_bc608472-d9b2-45a1-a264-4ee7c9b5be5a_SESS_155227c8-a91c-4e93-9075-b013a316a917_TOSC_19c93424-84f0-4eb0-a0ca-0dc13612f9da_PLY_','2021-02-11 15:56:06','2020-01-24 10:48:25','2459df7c-3e8f-11ea-947d-226cec7cb58a.ply','2021-02-11 16:56:06','SYNCED','2459df7c-3e8f-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.1.1.1.1\",\"modelMatrix\":\"0.754243,-0.609672,0.243756,0,0.656595,0.700342,-0.280007,0,1.46885e-8,0.371242,0.928536,0,10.2738,-25.1057,-15.0414,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'245c296b-3e8f-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/245c296b-3e8f-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_bc608472-d9b2-45a1-a264-4ee7c9b5be5a_SESS_155227c8-a91c-4e93-9075-b013a316a917_BOSC_60935eb7-56c3-48e9-9fe4-47cbdd0c991b_SNAPS_','2021-02-11 15:56:06','2020-01-24 10:51:23','245c296b-3e8f-11ea-947d-226cec7cb58a.png','2021-02-11 16:56:06','SYNCED','245c296b-3e8f-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'245cf870-5188-4128-8455-f4ad376209d0','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/245cf870-5188-4128-8455-f4ad376209d0.ply','PLY','PATIENT_b48882ea-1da3-4fe4-a7e6-757f2c50854b_ACT_abfdecf1-e835-4baf-9c2a-ebb77ed8fd7e_SESS_b192bf2c-b8a2-4077-980e-b7d2d1c460de_TOSC_93346dc6-65c5-4687-b0a7-899a457e04b6_PLY_','2021-02-11 15:56:06','2020-05-28 09:57:28','245cf870-5188-4128-8455-f4ad376209d0.ply','2021-02-11 16:56:06','SYNCED','245cf870-5188-4128-8455-f4ad376209d0',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 216.1.1.1.1\",\"modelMatrix\":\"0.795675,-0.57594,0.187604,0,0.605724,0.75655,-0.246436,0,-1.39114e-8,0.309719,0.950828,0,5.2632,-31.7728,-17.5507,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'245e28cd-3e8f-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/245e28cd-3e8f-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_4f482827-5082-4728-9f38-c433a5ca405c_ACT_bc608472-d9b2-45a1-a264-4ee7c9b5be5a_SESS_155227c8-a91c-4e93-9075-b013a316a917_TOSC_19c93424-84f0-4eb0-a0ca-0dc13612f9da_SNAPS_','2021-02-11 15:56:06','2020-01-24 10:48:25','245e28cd-3e8f-11ea-947d-226cec7cb58a.png','2021-02-11 16:56:06','SYNCED','245e28cd-3e8f-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'245ef255-f8a6-43df-9080-8a021ceb00a7','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/245ef255-f8a6-43df-9080-8a021ceb00a7.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_2feaafd5-9186-4b34-97e9-a3294e6e15be_SESS_da430c8c-2ca8-4108-bf57-a3f31aaba3fe_BOSC_2e92df08-a75c-48a4-9198-33eaf4e3dc76_SNAPS_','2021-02-11 15:56:07','2020-05-22 15:27:35','245ef255-f8a6-43df-9080-8a021ceb00a7.png','2021-02-11 16:56:07','SYNCED','7c85600d-2e15-4846-ad2c-0982a752b6f7',1,NULL,'','','{\"displayTitle\":\"MANDIBULE 216.1.11.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'245fb052-3e8f-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/245fb052-3e8f-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_bc608472-d9b2-45a1-a264-4ee7c9b5be5a_SESS_155227c8-a91c-4e93-9075-b013a316a917_BOSC_60935eb7-56c3-48e9-9fe4-47cbdd0c991b_PLY_','2021-02-11 15:56:07','2020-01-24 10:51:23','245fb052-3e8f-11ea-947d-226cec7cb58a.ply','2021-02-11 16:56:07','SYNCED','245fb052-3e8f-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.1.1.1.1\",\"modelMatrix\":\"-0.968539,0.237414,-0.0746086,0,-0.248862,-0.923988,0.290368,0,1.27908e-10,0.2998,0.954002,0,-8.33587,16.7151,-13.8993,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'246678fc-b813-42a2-b05a-1602d819a12f','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/246678fc-b813-42a2-b05a-1602d819a12f.ply','PLY','PATIENT_6cda0ff7-9066-45b9-90ca-6e11634d3844_ACT_0a1be447-887b-46a0-8401-d533a77b8192_SESS_25929069-e287-4283-ae0a-8b51a4974547_BOSC_96ba0852-ebf7-4dd4-8ab4-8d022ae4eb5a_PLY_','2022-02-01 11:48:09','2019-07-17 15:34:46','246678fc-b813-42a2-b05a-1602d819a12f.ply','2022-02-01 12:48:09','SYNCED','246678fc-b813-42a2-b05a-1602d819a12f',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 91.1.1.1\",\"modelMatrix\":\"-0.921274,0.380681,-0.0795953,0,-0.388913,-0.901774,0.188549,0,-3.14408e-9,0.204661,0.978833,0,-9.36698,25.1427,-21.7152,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'24776e00-eca7-45ec-b856-b7543fd77d11','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/24776e00-eca7-45ec-b856-b7543fd77d11.png','SNAPS','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_d8cd77ea-5298-4bca-ad2d-459ba572e935_SESS_17eb53c4-e3ba-4227-b3b4-fba3a38cf0b7_BOSC_ba7dd807-fe2b-4d8e-8492-7bc936b584ea_SNAPS_','2021-02-11 15:56:07','2020-01-02 11:04:18','24776e00-eca7-45ec-b856-b7543fd77d11.png','2021-02-11 16:56:07','SYNCED','24776e00-eca7-45ec-b856-b7543fd77d11',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'247ad77e-6762-43bf-ad1f-9012b2b00127','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/247ad77e-6762-43bf-ad1f-9012b2b00127.png','SNAPS','PATIENT_b91b12ac-6144-42d7-97e8-da7ac9eebdc2_ACT_7563c172-7fae-490c-aef8-357e72d49088_SESS_28794cdb-fd2d-42c7-bbc0-00011c3add7a_BOSC_466db563-b1e3-4b62-b9bb-8273cd11dcf3_SNAPS_','2022-03-04 13:40:30','2019-07-10 12:11:17','247ad77e-6762-43bf-ad1f-9012b2b00127.png','2022-03-04 14:40:30','SYNCED','247ad77e-6762-43bf-ad1f-9012b2b00127',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 27.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'24834508-efe1-493b-85f1-c4e13383d145','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/24834508-efe1-493b-85f1-c4e13383d145.ply','PLY','PATIENT_aff4eaff-030a-4db3-bb48-829132017f6c_ACT_2ff44845-9186-4589-bd19-c7c20e898d46_SESS_0df16f53-eb00-4ebd-9c14-fe6fa158742f_TOSC_baa7f31c-3db8-49ce-8afe-d9403ad64066_PLY_','2021-02-11 15:56:07','2019-12-20 15:42:18','24834508-efe1-493b-85f1-c4e13383d145.ply','2021-02-11 16:56:07','SYNCED','24834508-efe1-493b-85f1-c4e13383d145',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"modelMatrix\":\"0.707269,-0.66098,0.25075,0,0.706944,0.661284,-0.250865,0,-3.49905e-9,0.354695,0.934982,0,2.10528,-31.4426,-12.8581,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'24c0d9a7-6f53-460b-bf43-f1dca9ff1114','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/24c0d9a7-6f53-460b-bf43-f1dca9ff1114.png','SNAPS','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_96a77903-f1bc-4a34-8004-4df0afe64c50_SESS_27c18a45-b47e-45ae-98f0-4425697bb357_BOSC_3690303f-18ed-45fc-ad7d-4c4095100ec3_SNAPS_','2021-02-11 15:56:08','2020-01-03 10:51:51','24c0d9a7-6f53-460b-bf43-f1dca9ff1114.png','2021-02-11 16:56:08','SYNCED','24c0d9a7-6f53-460b-bf43-f1dca9ff1114',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'24ca1112-3232-4255-8791-42ca5f81f37c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/24ca1112-3232-4255-8791-42ca5f81f37c.png','SNAPS','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_085fdf08-d777-4c3e-bf1b-ba3c5d9a1188_SESS_e47de5cc-baee-41be-b434-97cd36e2cf62_BOSC_ee261dd0-3674-4619-a271-d353528625fe_SNAPS_','2021-02-11 15:56:08','2019-12-16 13:59:58','24ca1112-3232-4255-8791-42ca5f81f37c.png','2021-02-11 16:56:08','SYNCED','24ca1112-3232-4255-8791-42ca5f81f37c',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.16.1.1.2\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'24e4f885-78c6-4c43-b6f7-0a90d6dcbff9','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/24e4f885-78c6-4c43-b6f7-0a90d6dcbff9.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_c7594576-0a9b-42f5-8b20-70cef5de8442_SESS_909efa2b-b8fa-4924-98fe-affb40ad58c2_BOSC_5c8a0022-ec6c-4a8a-9fe2-331dd838a341_PLY_','2021-02-11 15:56:08','2020-06-08 11:41:14','24e4f885-78c6-4c43-b6f7-0a90d6dcbff9.ply','2021-02-11 16:56:08','SYNCED','24e4f885-78c6-4c43-b6f7-0a90d6dcbff9',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.33.1.1\",\"modelMatrix\":\"-0.924294,0.371794,-0.086306,0,-0.38168,-0.900355,0.209003,0,-4.5174e-9,0.226121,0.974099,0,-9.12617,22.3212,-19.7276,1\",\"title\":\"Mandibule PLY\"}'),(2,'24e61132-095b-4995-9c39-cc99386938b0','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/24e61132-095b-4995-9c39-cc99386938b0.png','SNAPS','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_db56cba1-23ff-48bf-b86e-4ceff749087f_BOSC_ef1f32b0-0d47-4efc-a92d-5b97f9440e44_SNAPS_','2021-12-30 18:04:22','2019-11-14 16:45:01','24e61132-095b-4995-9c39-cc99386938b0.png','2021-12-30 19:04:22','SYNCED','24e61132-095b-4995-9c39-cc99386938b0',0,NULL,'','','{\"displayTitle\":\"Mandibola 0\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'24e83126-e7dd-4e24-9f47-9c6aea91e8ff','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/24e83126-e7dd-4e24-9f47-9c6aea91e8ff.ply','PLY','PATIENT_f02ff132-5a6c-40c5-a006-6246516d9fc3_ACT_bc95ebb7-704d-428f-afd3-47cec36174fe_SESS_d89758fd-b704-4365-b07c-4f7c639a7c68_TOSC_94400656-194e-4cac-8126-b211550ef3bd_PLY_','2021-02-11 15:56:08','2019-12-20 14:34:14','24e83126-e7dd-4e24-9f47-9c6aea91e8ff.ply','2021-02-11 16:56:08','SYNCED','24e83126-e7dd-4e24-9f47-9c6aea91e8ff',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.2\",\"modelMatrix\":\"0.818805,-0.510837,0.261924,0,0.574072,0.728612,-0.373585,0,-4.53042e-11,0.456256,0.889849,0,6.65421,-28.5976,-17.7302,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'24e98d96-9bfe-435f-ae3e-c762caa055d1','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/24e98d96-9bfe-435f-ae3e-c762caa055d1.png','SNAPS','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_TOSC_407f969e-5180-4ec7-b88f-a5d10ba9e59a_SNAPS_','2021-12-30 18:04:22','2019-11-15 12:03:13','24e98d96-9bfe-435f-ae3e-c762caa055d1.png','2021-12-30 19:04:22','SYNCED','24e98d96-9bfe-435f-ae3e-c762caa055d1',0,NULL,'','','{\"displayTitle\":\"Mascella 0\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'24ea2d6f-5dfa-43a6-8edf-08bc45e51fa6','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/24ea2d6f-5dfa-43a6-8edf-08bc45e51fa6.stl','STL','PATIENT_c240893c-f0b3-496f-a29c-6f58c49ba9bb_ACT_bd62034c-19cb-4da3-a4b7-2cb3f687c2c9_SESS_73819a0c-e2a8-477b-a803-c85cfdd60101_BOSC_cadd966e-ef3e-4169-9cf1-61a6565ba5a8_STL_','2022-02-01 11:48:09','2019-07-19 11:06:41','24ea2d6f-5dfa-43a6-8edf-08bc45e51fa6.stl','2022-02-01 12:48:09','SYNCED','24ea2d6f-5dfa-43a6-8edf-08bc45e51fa6',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 97.1.1.1\",\"modelMatrix\":\"-0.972272,0.226465,-0.0583167,0,-0.233853,-0.941555,0.242459,0,4.46789e-9,0.249373,0.968407,0,-17.6684,16.7943,-19.9067,1\",\"title\":\"MANDIBULE STL\"}'),(2,'24f075d6-c523-4037-a5e6-fd03f6174acb','','PLY','PATIENT_a258dda4-74b5-4e6e-a1e6-808823ec0c82_ACT_4a6089c0-3902-401a-8041-8ae44511974d_SESS_8435dd71-3e05-40bf-a55c-7eb3a8b844a4_BOSC_b6282c7e-d99c-4959-a0c9-d36aca6b4096_PLY_','2022-03-04 13:40:30','2019-07-10 09:43:35','','2022-03-04 14:40:30','SYNCED','24f075d6-c523-4037-a5e6-fd03f6174acb',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 19.1.1.1\",\"modelMatrix\":\"-0.835448,-0.518008,0.183559,0,0.549569,-0.787469,0.279045,0,-2.43666e-9,0.334006,0.942571,0,13.1282,26.026,-21.8794,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'2534e65f-8800-467a-954d-11e6c3f65143','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2534e65f-8800-467a-954d-11e6c3f65143.png','SNAPS','PATIENT_3e53fe02-afc4-4a4e-baa1-8e748cae6c31_ACT_7c221ea4-4cae-4db9-9833-48b1955c6d3e_SESS_759f7cb5-cf25-43d3-8a49-15e06ae98c56_BOSC_54df7545-92b5-4c41-b7f3-fb58a9c6a435_SNAPS_','2021-12-30 18:04:22','2019-10-09 14:11:34','2534e65f-8800-467a-954d-11e6c3f65143.png','2021-12-30 19:04:22','SYNCED','2534e65f-8800-467a-954d-11e6c3f65143',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 182.2.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'2547b791-7e1b-4895-852c-1ac74e0143ec','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2547b791-7e1b-4895-852c-1ac74e0143ec.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_8464161e-f420-42dd-97a7-8d8a43e0d890_SESS_24b4b44e-82d8-423d-a1e9-3be90a46aad3_BOSC_b19bf61e-76c3-4cd1-a57d-1f7d87c32e70_PLY_','2021-02-11 15:56:09','2020-06-17 11:40:33','2547b791-7e1b-4895-852c-1ac74e0143ec.ply','2021-02-11 16:56:09','SYNCED','2547b791-7e1b-4895-852c-1ac74e0143ec',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.50.1.1\",\"modelMatrix\":\"-0.898659,0.433609,-0.0662959,0,-0.438648,-0.888336,0.13582,0,2.85158e-9,0.151137,0.988513,0,-1.48136,20.5702,-14.6355,1\",\"title\":\"Mandibule PLY\"}'),(2,'254a2e4d-e536-435b-a6ed-3e2bf2aa70ab','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/254a2e4d-e536-435b-a6ed-3e2bf2aa70ab.png','SNAPS','PATIENT_d5ef196c-173b-490b-a478-f1ca17a88256_ACT_c1343c91-e8d4-4698-93d9-578e6f8f45b5_SESS_621ec82a-dd13-4c37-8944-c6c9466fef1e_BOSC_ce771962-2979-4ff2-ae53-922eeaf4a8f7_SNAPS_','2021-08-19 22:42:50','2019-12-02 19:19:13','254a2e4d-e536-435b-a6ed-3e2bf2aa70ab.png','2021-08-20 00:42:50','SYNCED','254a2e4d-e536-435b-a6ed-3e2bf2aa70ab',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 223.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'2553a02a-c509-4574-bbfa-5dff0a37b5c4','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2553a02a-c509-4574-bbfa-5dff0a37b5c4.png','SNAPS','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_BOSC_41daa221-1590-427d-b378-8a0916719470_SNAPS_','2021-12-30 18:04:22','2019-11-15 12:17:08','2553a02a-c509-4574-bbfa-5dff0a37b5c4.png','2021-12-30 19:04:22','SYNCED','2553a02a-c509-4574-bbfa-5dff0a37b5c4',0,NULL,'','','{\"displayTitle\":\"Mandibola 0\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'255578dc-7689-4c09-8837-174525733f0c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/255578dc-7689-4c09-8837-174525733f0c.ply','PLY','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_BOSC_354fcd1e-1b9b-4433-a96d-a079f19a9534_PLY_','2021-12-30 18:04:23','2019-11-15 13:57:45','255578dc-7689-4c09-8837-174525733f0c.ply','2021-12-30 19:04:23','SYNCED','255578dc-7689-4c09-8837-174525733f0c',0,NULL,'','','{\"displayTitle\":\"Mandibola 0\",\"modelMatrix\":\"-0.943152,0.327826,-0.0547245,0,-0.332363,-0.930279,0.155293,0,3.18135e-9,0.164653,0.986352,0,-9.12563,17.863,-21.143,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'2555d767-56c4-478b-a615-3a3a3f42e62d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2555d767-56c4-478b-a615-3a3a3f42e62d.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_6f9b06e7-95a1-4b2c-974a-63ad638a404a_SESS_00bc2be9-26ee-40d0-b135-3cea0ac87ae2_TOSC_495620a4-e965-44a8-a639-2e2dd9d954b6_SNAPS_','2021-02-11 15:56:10','2020-05-22 14:10:19','2555d767-56c4-478b-a615-3a3a3f42e62d.png','2021-02-11 16:56:10','SYNCED','2555d767-56c4-478b-a615-3a3a3f42e62d',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 216.1.9.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'25561469-0ed1-4bcf-870f-1899b797db27','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/25561469-0ed1-4bcf-870f-1899b797db27.ply','PLY','PATIENT_add0eef7-f3cb-4500-8dd7-9d43d3202c9d_ACT_bf610bd2-fd7d-49df-a7fe-b5b2aff4876f_SESS_05501508-0550-4df0-9a42-1a77639bbc2f_BOSC_be623d48-329f-4308-9c13-e79732b18c55_PLY_','2022-03-04 13:40:30','2019-07-08 16:37:43','25561469-0ed1-4bcf-870f-1899b797db27.ply','2022-03-04 14:40:30','SYNCED','25561469-0ed1-4bcf-870f-1899b797db27',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 7.1.1.1\",\"modelMatrix\":\"0.871552,0.375419,-0.315368,0,-0.490302,0.667338,-0.560592,0,1.39307e-8,0.643211,0.765689,0,-18.6626,-42.3396,-11.0485,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'2566ede6-3c3a-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2566ede6-3c3a-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_7c6f73e0-1bb8-49f1-b520-b89cdf71c993_SESS_7f62e3d7-a0dc-4ad0-b0ec-e4c623aa10ae_BOSC_c07cd6cd-7c36-4f97-936e-5c18348c0fb3_PLY_','2021-02-11 15:56:12','2020-01-21 11:37:40','2566ede6-3c3a-11ea-947d-226cec7cb58a.ply','2021-02-11 16:56:12','SYNCED','2566ede6-3c3a-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.1.1.1.1\",\"modelMatrix\":\"-0.967094,0.244319,-0.0709769,0,-0.25442,-0.928699,0.269795,0,-1.42597e-9,0.278975,0.960298,0,-9.53432,16.1851,-20.0034,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'256894a8-3c3a-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/256894a8-3c3a-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_9b9b1f6f-bc9b-4d0d-b403-4225fc8930a9_ACT_7c6f73e0-1bb8-49f1-b520-b89cdf71c993_SESS_7f62e3d7-a0dc-4ad0-b0ec-e4c623aa10ae_TOSC_380e8429-e3f9-49d1-be1b-5d49fbb10840_SNAPS_','2021-02-11 15:56:12','2020-01-21 11:32:13','256894a8-3c3a-11ea-947d-226cec7cb58a.png','2021-02-11 16:56:12','SYNCED','256894a8-3c3a-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'256a2bfb-3c3a-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/256a2bfb-3c3a-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_7c6f73e0-1bb8-49f1-b520-b89cdf71c993_SESS_7f62e3d7-a0dc-4ad0-b0ec-e4c623aa10ae_BOSC_c07cd6cd-7c36-4f97-936e-5c18348c0fb3_SNAPS_','2021-02-11 15:56:12','2020-01-21 11:37:40','256a2bfb-3c3a-11ea-947d-226cec7cb58a.png','2021-02-11 16:56:12','SYNCED','256a2bfb-3c3a-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'256bc843-3c3a-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/256bc843-3c3a-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_9b9b1f6f-bc9b-4d0d-b403-4225fc8930a9_ACT_7c6f73e0-1bb8-49f1-b520-b89cdf71c993_SESS_7f62e3d7-a0dc-4ad0-b0ec-e4c623aa10ae_TOSC_380e8429-e3f9-49d1-be1b-5d49fbb10840_PLY_','2021-02-11 15:56:12','2020-01-21 11:32:13','256bc843-3c3a-11ea-947d-226cec7cb58a.ply','2021-02-11 16:56:12','SYNCED','256bc843-3c3a-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.1.1.1.1\",\"modelMatrix\":\"0.627287,-0.739358,0.244665,0,0.778788,0.595527,-0.197069,0,2.31384e-8,0.314161,0.94937,0,0.377759,-36.47,-16.3031,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'256dcb00-a84b-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/256dcb00-a84b-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_9d8ee3c4-279c-49f6-84a5-c72a6bbb261a_ACT_3f4ac314-88e9-4b46-ad3d-7b6efca66cd6_SESS_3332cf67-cbb4-48cd-85a3-8b8d4c6b2db2_TOSC_47d38377-f708-4fb7-ad57-293bde29ce57_PLY_','2022-02-01 11:48:10','2019-07-17 08:34:58','256dcb00-a84b-11e9-a33b-226cec7cb58a.ply','2022-02-01 12:48:10','SYNCED','256dcb00-a84b-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1\",\"modelMatrix\":\"0.490625,-0.84762,0.202058,0,0.871371,0.477252,-0.113769,0,-2.64867e-9,0.231885,0.972743,0,-1.38975,-34.262,-24.4648,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'256f0678-a84b-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/256f0678-a84b-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_9d8ee3c4-279c-49f6-84a5-c72a6bbb261a_ACT_3f4ac314-88e9-4b46-ad3d-7b6efca66cd6_SESS_3332cf67-cbb4-48cd-85a3-8b8d4c6b2db2_BOSC_975827b1-5db0-464d-a41e-c69d519dba7c_STL_','2022-02-01 11:48:10','2019-07-17 08:29:45','256f0678-a84b-11e9-a33b-226cec7cb58a.stl','2022-02-01 12:48:10','SYNCED','256f0678-a84b-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1\",\"modelMatrix\":\"-0.99389,0.107773,-0.0238188,0,-0.110374,-0.970471,0.214483,0,6.71358e-10,0.215802,0.976437,0,-13.2696,19.471,-32.4185,1\",\"title\":\"MANDIBULE STL\"}'),(2,'256f950a-a84b-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/256f950a-a84b-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_9d8ee3c4-279c-49f6-84a5-c72a6bbb261a_ACT_3f4ac314-88e9-4b46-ad3d-7b6efca66cd6_SESS_3332cf67-cbb4-48cd-85a3-8b8d4c6b2db2_BOSC_975827b1-5db0-464d-a41e-c69d519dba7c_SNAPS_','2022-02-01 11:48:10','2019-07-17 08:29:45','256f950a-a84b-11e9-a33b-226cec7cb58a.png','2022-02-01 12:48:10','SYNCED','256f950a-a84b-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'257089ef-a84b-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/257089ef-a84b-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_9d8ee3c4-279c-49f6-84a5-c72a6bbb261a_ACT_3f4ac314-88e9-4b46-ad3d-7b6efca66cd6_SESS_3332cf67-cbb4-48cd-85a3-8b8d4c6b2db2_BOSC_975827b1-5db0-464d-a41e-c69d519dba7c_PLY_','2022-02-01 11:48:11','2019-07-17 08:29:45','257089ef-a84b-11e9-a33b-226cec7cb58a.ply','2022-02-01 12:48:11','SYNCED','257089ef-a84b-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1\",\"modelMatrix\":\"-0.99389,0.107773,-0.0238188,0,-0.110374,-0.970471,0.214483,0,6.71358e-10,0.215802,0.976437,0,-13.2696,19.471,-32.4185,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'2571258f-a84b-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2571258f-a84b-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_9d8ee3c4-279c-49f6-84a5-c72a6bbb261a_ACT_3f4ac314-88e9-4b46-ad3d-7b6efca66cd6_SESS_3332cf67-cbb4-48cd-85a3-8b8d4c6b2db2_TOSC_47d38377-f708-4fb7-ad57-293bde29ce57_SNAPS_','2022-02-01 11:48:11','2019-07-17 08:34:58','2571258f-a84b-11e9-a33b-226cec7cb58a.png','2022-02-01 12:48:11','SYNCED','2571258f-a84b-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'2571b42d-a84b-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2571b42d-a84b-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_9d8ee3c4-279c-49f6-84a5-c72a6bbb261a_ACT_3f4ac314-88e9-4b46-ad3d-7b6efca66cd6_SESS_3332cf67-cbb4-48cd-85a3-8b8d4c6b2db2_TOSC_47d38377-f708-4fb7-ad57-293bde29ce57_STL_','2022-02-01 11:48:11','2019-07-17 08:34:58','2571b42d-a84b-11e9-a33b-226cec7cb58a.stl','2022-02-01 12:48:11','SYNCED','2571b42d-a84b-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1\",\"modelMatrix\":\"0.490625,-0.84762,0.202058,0,0.871371,0.477252,-0.113769,0,-2.64867e-9,0.231885,0.972743,0,-1.38975,-34.262,-24.4648,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'2586ef4c-105b-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2586ef4c-105b-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_fd694b3f-abde-4e46-91f7-7c62bfdcafa4_SESS_73a3f5b9-e905-4911-a163-2022e1de3380_TOSC_33c23c80-0963-40c0-a315-0461c3cb686a_PLY_','2021-08-19 22:42:56','2019-11-26 20:43:14','2586ef4c-105b-11ea-947d-226cec7cb58a.ply','2021-08-20 00:42:56','SYNCED','2586ef4c-105b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"modelMatrix\":\"-0.314282,-0.917164,0.245023,0,0.94933,-0.303633,0.0811166,0,-3.23617e-9,0.258102,0.966118,0,-26.7208,-19.9951,-15.3285,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'2588abf6-105b-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2588abf6-105b-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_fd694b3f-abde-4e46-91f7-7c62bfdcafa4_SESS_73a3f5b9-e905-4911-a163-2022e1de3380_TOSC_33c23c80-0963-40c0-a315-0461c3cb686a_SNAPS_','2021-08-19 22:42:57','2019-11-26 20:43:14','2588abf6-105b-11ea-947d-226cec7cb58a.png','2021-08-20 00:42:57','SYNCED','2588abf6-105b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'258a3ed2-105b-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/258a3ed2-105b-11ea-947d-226cec7cb58a.stl','STL','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_fd694b3f-abde-4e46-91f7-7c62bfdcafa4_SESS_73a3f5b9-e905-4911-a163-2022e1de3380_TOSC_33c23c80-0963-40c0-a315-0461c3cb686a_STL_','2021-08-19 22:42:57','2019-11-26 20:43:14','258a3ed2-105b-11ea-947d-226cec7cb58a.stl','2021-08-20 00:42:57','SYNCED','258a3ed2-105b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"modelMatrix\":\"-0.314282,-0.917164,0.245023,0,0.94933,-0.303633,0.0811166,0,-3.23617e-9,0.258102,0.966118,0,-26.7208,-19.9951,-15.3285,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'2597dfed-b07d-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2597dfed-b07d-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_e70310f5-b4ba-40e1-b9b9-fbf3c922b90b_SESS_f687de0e-63e2-4a92-a913-46f8d090cd17_BOSC_c79f6c00-5b10-4c15-b26e-ac6e51da0e4c_PLY_','2021-02-11 15:56:14','2020-06-17 11:29:57','2597dfed-b07d-11ea-947d-226cec7cb58a.ply','2021-02-11 16:56:14','SYNCED','2597dfed-b07d-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.49.1.1\",\"modelMatrix\":\"0.55223,0.830124,-0.0770472,0,-0.833692,0.549867,-0.0510354,0,1.37341e-9,0.0924169,0.99572,0,18.2252,1.17476,-16.8729,1\",\"title\":\"Mandibule PLY\"}'),(2,'259a17a4-b07d-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/259a17a4-b07d-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_e70310f5-b4ba-40e1-b9b9-fbf3c922b90b_SESS_f687de0e-63e2-4a92-a913-46f8d090cd17_BOSC_c79f6c00-5b10-4c15-b26e-ac6e51da0e4c_SNAPS_','2021-02-11 15:56:14','2020-06-17 11:29:57','259a17a4-b07d-11ea-947d-226cec7cb58a.png','2021-02-11 16:56:14','SYNCED','259a17a4-b07d-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.49.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'259bdf90-b07d-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/259bdf90-b07d-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_eed66322-9dbf-40e3-901a-b7e885a99bc8_ACT_e70310f5-b4ba-40e1-b9b9-fbf3c922b90b_SESS_f687de0e-63e2-4a92-a913-46f8d090cd17_TOSC_43fecf44-d80d-4ac0-bf8d-58d9fff7bdd8_SNAPS_','2021-02-11 15:56:14','2020-06-17 11:27:24','259bdf90-b07d-11ea-947d-226cec7cb58a.png','2021-02-11 16:56:14','SYNCED','259bdf90-b07d-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.49.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'259d8b9c-b07d-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/259d8b9c-b07d-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_eed66322-9dbf-40e3-901a-b7e885a99bc8_ACT_e70310f5-b4ba-40e1-b9b9-fbf3c922b90b_SESS_f687de0e-63e2-4a92-a913-46f8d090cd17_TOSC_43fecf44-d80d-4ac0-bf8d-58d9fff7bdd8_PLY_','2021-02-11 15:56:15','2020-06-17 11:27:24','259d8b9c-b07d-11ea-947d-226cec7cb58a.ply','2021-02-11 16:56:15','SYNCED','259d8b9c-b07d-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.49.1.1\",\"modelMatrix\":\"0.828114,-0.527626,0.18931,0,0.56056,0.779461,-0.279666,0,2.20674e-8,0.337715,0.941248,0,6.38169,-30.5512,-17.4416,1\",\"title\":\"Maxillaire PLY\"}'),(2,'25a3d0cd-c89c-451f-8d60-0a3e776cb95c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/25a3d0cd-c89c-451f-8d60-0a3e776cb95c.ply','PLY','PATIENT_fcf8c111-84a1-4f17-859c-ea2ad21d373b_ACT_d27c23bb-fa1e-4cd8-bacc-e2b65114a20e_SESS_844480c5-a8a8-4eb3-a014-e1424d66a1ca_BOSC_8f3d315e-5c4a-4f20-b843-cc6ea3308289_PLY_','2021-12-30 18:04:28','2019-11-18 16:48:17','25a3d0cd-c89c-451f-8d60-0a3e776cb95c.ply','2021-12-30 19:04:28','SYNCED','25a3d0cd-c89c-451f-8d60-0a3e776cb95c',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 168.1.1.1.1\",\"modelMatrix\":\"-0.94276,0.327108,-0.0648412,0,-0.333472,-0.924766,0.183313,0,2.56456e-10,0.194443,0.980914,0,-8.98584,15.965,-16.5042,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'25b30ddc-062e-4043-8a15-1bb96123167d','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/25b30ddc-062e-4043-8a15-1bb96123167d.ply','PLY','PATIENT_79406c13-00e4-4a57-b938-5ac4cd1a9f2f_ACT_dbfeadf7-7793-42fb-be76-63e1515647d5_SESS_e53f2bc1-2f26-4656-aae6-7e1b2bbb1f50_TOSC_24085d39-bee0-4389-b5b7-8eea2c1764e2_PLY_','2022-03-04 13:40:30','2019-07-11 12:41:28','25b30ddc-062e-4043-8a15-1bb96123167d.ply','2022-03-04 14:40:30','SYNCED','25b30ddc-062e-4043-8a15-1bb96123167d',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 40.1.1.1\",\"modelMatrix\":\"0.852576,-0.486267,0.191461,0,0.522603,0.793299,-0.312351,0,-1.89462e-9,0.366361,0.930473,0,5.3154,-32.6559,-18.1157,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'25bd0344-ae0d-4023-a3dc-2f22c28f0d83','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/25bd0344-ae0d-4023-a3dc-2f22c28f0d83.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_4d5f9849-771f-4905-b4af-9f54867d3981_SESS_634356c8-f0f1-4841-b539-8f2ec59be200_TOSC_6ea22fae-b025-402a-b92d-8a057606974b_PLY_','2021-02-11 15:56:15','2020-05-27 13:36:22','25bd0344-ae0d-4023-a3dc-2f22c28f0d83.ply','2021-02-11 16:56:15','SYNCED','25bd0344-ae0d-4023-a3dc-2f22c28f0d83',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 216.1.14.1.1\",\"modelMatrix\":\"-0.192412,-0.950153,0.24533,0,0.981314,-0.186302,0.0481033,0,2.15826e-9,0.250002,0.968245,0,-27.9835,-22.6345,-21.4184,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'25c57783-ce1d-4238-a6c3-756b82fe91dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/25c57783-ce1d-4238-a6c3-756b82fe91dd.ply','PLY','PATIENT_961e5084-1756-4d47-8e90-a6b717094efe_ACT_98c4e8c8-b585-402f-9f25-607a96fd2f4d_SESS_5abb4cc4-ea51-4889-b538-9aee199a52f8_TOSC_f8281f49-e529-41ae-a3d6-cb0a4258ac41_PLY_','2021-02-11 15:56:16','2020-01-23 16:24:55','25c57783-ce1d-4238-a6c3-756b82fe91dd.ply','2021-02-11 16:56:16','SYNCED','25c57783-ce1d-4238-a6c3-756b82fe91dd',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 199.1.5.1.1\",\"modelMatrix\":\"0.482947,-0.85696,0.17995,0,0.87565,0.472639,-0.0992475,0,5.54065e-9,0.205504,0.978656,0,-6.70163,-34.9749,-15.3384,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'25d6cbcc-2595-4ed1-9747-9b06ec846305','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/25d6cbcc-2595-4ed1-9747-9b06ec846305.stl','STL','PATIENT_48663f07-7d9b-45b6-b1d2-d0eee1162507_ACT_917a5ea3-a099-4d16-9ba6-92dfca8c3da2_SESS_11e165de-8915-47dd-8649-29da5caf4ce6_BOSC_c7c42fa0-9ffb-47f0-b520-045f5c94fc78_STL_','2021-12-30 18:04:29','2019-10-04 15:54:17','25d6cbcc-2595-4ed1-9747-9b06ec846305.stl','2021-12-30 19:04:29','SYNCED','25d6cbcc-2595-4ed1-9747-9b06ec846305',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 177.1.1.1\",\"modelMatrix\":\"-0.676848,0.733473,-0.0623987,0,-0.736122,-0.674412,0.0573743,0,-1.98389e-10,0.0847668,0.996401,0,6.80706,18.7548,-25.8235,1\",\"title\":\"MANDIBULE STL\"}'),(2,'25e0b1ca-86eb-4376-a3d1-b82dcb258269','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/25e0b1ca-86eb-4376-a3d1-b82dcb258269.pdf','PDF','PATIENT_cadfb79e-7de5-4015-97e3-269a77999943_ACT_087c4066-ec0b-4035-93aa-10a106e71f3b_PROST_514d3577-62f6-47d3-8fb0-0a9e4d86c6b7_PDF_','2020-01-20 11:40:25','2019-11-25 11:23:31','25e0b1ca-86eb-4376-a3d1-b82dcb258269.pdf','2020-01-20 12:40:25','SYNCED','25e0b1ca-86eb-4376-a3d1-b82dcb258269',0,NULL,'','','{\"displayTitle\":\"IMPLANT CROWN 1.2.1.1 IMPLANT CROWN\",\"title\":\"Couronne sur Implant PDF\"}'),(2,'25e6c6a0-07a9-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/25e6c6a0-07a9-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_BOSC_6b91b69b-0088-4a4e-bb54-ae2789304ed8_SNAPS_','2021-12-30 18:04:29','2019-11-15 13:40:45','25e6c6a0-07a9-11ea-947d-226cec7cb58a.png','2021-12-30 19:04:29','SYNCED','25e6c6a0-07a9-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 202.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'25e86bfb-07a9-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/25e86bfb-07a9-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_TOSC_a1f4078d-a25a-4663-8fd2-9fa32d012000_PLY_','2021-12-30 18:04:30','2019-11-15 11:00:22','25e86bfb-07a9-11ea-947d-226cec7cb58a.ply','2021-12-30 19:04:30','SYNCED','25e86bfb-07a9-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 202.1.1.1\",\"modelMatrix\":\"0.604375,-0.725102,0.330088,0,0.7967,0.550061,-0.250404,0,-3.68487e-11,0.414319,0.910132,0,-0.671123,-34.3745,-16.6885,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'25e9b452-07a9-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/25e9b452-07a9-11ea-947d-226cec7cb58a.stl','STL','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_BOSC_6b91b69b-0088-4a4e-bb54-ae2789304ed8_STL_','2021-12-30 18:04:30','2019-11-15 13:40:45','25e9b452-07a9-11ea-947d-226cec7cb58a.stl','2021-12-30 19:04:30','SYNCED','25e9b452-07a9-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 202.1.1.1\",\"modelMatrix\":\"-0.976662,-0.208037,0.0534026,0,0.214781,-0.945992,0.242834,0,-1.45872e-9,0.248637,0.968597,0,-13.8667,4.837,-22.6065,1\",\"title\":\"MANDIBULE STL\"}'),(2,'25eb6c91-07a9-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/25eb6c91-07a9-11ea-947d-226cec7cb58a.stl','STL','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_TOSC_a1f4078d-a25a-4663-8fd2-9fa32d012000_STL_','2021-12-30 18:04:32','2019-11-15 11:00:22','25eb6c91-07a9-11ea-947d-226cec7cb58a.stl','2021-12-30 19:04:32','SYNCED','25eb6c91-07a9-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 202.1.1.1\",\"modelMatrix\":\"0.604375,-0.725102,0.330088,0,0.7967,0.550061,-0.250404,0,-3.68487e-11,0.414319,0.910132,0,-0.671123,-34.3745,-16.6885,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'25eccbc5-4e79-4e16-9cd3-403edb9b6401','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/25eccbc5-4e79-4e16-9cd3-403edb9b6401.png','SNAPS','PATIENT_ac556afa-dc57-4ccb-b901-7bf02b7ba533_ACT_0694e700-372e-4a8b-819c-9b2d9dc37d82_SESS_dd32efee-bcf5-4120-87e3-a6ce7dcfc947_TOSC_0058c9db-e562-401a-a474-2f212374481b_SNAPS_','2021-02-11 15:56:17','2020-06-16 12:15:00','25eccbc5-4e79-4e16-9cd3-403edb9b6401.png','2021-02-11 16:56:17','SYNCED','25eccbc5-4e79-4e16-9cd3-403edb9b6401',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.43.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'25ed2ca8-07a9-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/25ed2ca8-07a9-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_BOSC_6b91b69b-0088-4a4e-bb54-ae2789304ed8_PLY_','2021-12-30 18:04:32','2019-11-15 13:40:45','25ed2ca8-07a9-11ea-947d-226cec7cb58a.ply','2021-12-30 19:04:32','SYNCED','25ed2ca8-07a9-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 202.1.1.1\",\"modelMatrix\":\"-0.976662,-0.208037,0.0534026,0,0.214781,-0.945992,0.242834,0,-1.45872e-9,0.248637,0.968597,0,-13.8667,4.837,-22.6065,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'25eea0d8-07a9-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/25eea0d8-07a9-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_TOSC_a1f4078d-a25a-4663-8fd2-9fa32d012000_SNAPS_','2021-12-30 18:04:33','2019-11-15 11:00:22','25eea0d8-07a9-11ea-947d-226cec7cb58a.png','2021-12-30 19:04:33','SYNCED','25eea0d8-07a9-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 202.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'25f1de5e-e4b4-4f4a-8e23-4911f1d6c0a6','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/25f1de5e-e4b4-4f4a-8e23-4911f1d6c0a6.png','SNAPS','PATIENT_87d3edf3-06f6-4fb8-8ac6-e0c73d339bbe_ACT_8c4a4ddb-e5bf-431f-b0af-03f1f155ac20_SESS_5a8d948f-9b60-450f-800c-e78e7d2670d5_BOSC_adaa1a41-9e73-4276-a644-9541d876fe05_SNAPS_','2022-02-01 11:48:12','2019-07-15 15:44:27','25f1de5e-e4b4-4f4a-8e23-4911f1d6c0a6.png','2022-02-01 12:48:12','SYNCED','25f1de5e-e4b4-4f4a-8e23-4911f1d6c0a6',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 66.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'25f5f1cf-0f46-4e0e-977b-c61e44307c65','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/25f5f1cf-0f46-4e0e-977b-c61e44307c65.stl','STL','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_BOSC_ce0ace35-8d90-4fcf-839a-30eef78912a1_STL_','2021-12-30 18:04:33','2019-11-14 13:50:50','25f5f1cf-0f46-4e0e-977b-c61e44307c65.stl','2021-12-30 19:04:33','SYNCED','25f5f1cf-0f46-4e0e-977b-c61e44307c65',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 202.1.1.1\",\"modelMatrix\":\"-0.720031,0.690306,-0.0709439,0,-0.693942,-0.716258,0.073611,0,1.07452e-9,0.102233,0.99476,0,-1.71555,18.2493,-19.0388,1\",\"title\":\"MANDIBULE STL\"}'),(2,'25f9c32a-2331-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/25f9c32a-2331-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_2a2b96a4-a0e0-43e8-880c-4a576a26100c_SESS_28b7bd97-0dfa-43d9-b4aa-09587119b68a_BOSC_3f08005c-4379-4946-87cd-15f582d0ca08_SNAPS_','2021-02-11 15:56:17','2019-12-20 15:00:36','25f9c32a-2331-11ea-947d-226cec7cb58a.png','2021-02-11 16:56:17','SYNCED','25f9c32a-2331-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'25fb83f6-2331-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/25fb83f6-2331-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_2a2b96a4-a0e0-43e8-880c-4a576a26100c_SESS_28b7bd97-0dfa-43d9-b4aa-09587119b68a_BOSC_3f08005c-4379-4946-87cd-15f582d0ca08_PLY_','2021-02-11 15:56:18','2019-12-20 15:00:36','25fb83f6-2331-11ea-947d-226cec7cb58a.ply','2021-02-11 16:56:18','SYNCED','25fb83f6-2331-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"modelMatrix\":\"-0.982647,0.185211,-0.0100567,0,-0.185484,-0.981202,0.053278,0,-5.28875e-10,0.0542188,0.998529,0,-14.7514,15.414,-24.1296,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'25fd4c08-2331-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/25fd4c08-2331-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_b48225f9-22c8-4b6e-8c0b-d666f0a9e842_ACT_2a2b96a4-a0e0-43e8-880c-4a576a26100c_SESS_28b7bd97-0dfa-43d9-b4aa-09587119b68a_TOSC_e7c84580-1264-46df-9793-8311c3717fe6_SNAPS_','2021-02-11 15:56:18','2019-12-20 14:56:56','25fd4c08-2331-11ea-947d-226cec7cb58a.png','2021-02-11 16:56:18','SYNCED','25fd4c08-2331-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'25fef2c2-2331-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/25fef2c2-2331-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_b48225f9-22c8-4b6e-8c0b-d666f0a9e842_ACT_2a2b96a4-a0e0-43e8-880c-4a576a26100c_SESS_28b7bd97-0dfa-43d9-b4aa-09587119b68a_TOSC_e7c84580-1264-46df-9793-8311c3717fe6_PLY_','2021-02-11 15:56:18','2019-12-20 14:56:56','25fef2c2-2331-11ea-947d-226cec7cb58a.ply','2021-02-11 16:56:18','SYNCED','25fef2c2-2331-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"modelMatrix\":\"0.72723,-0.639723,0.248778,0,0.686393,0.677783,-0.263579,0,8.10468e-9,0.362442,0.932006,0,8.01211,-36.362,-14.3225,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'2619bd4b-202b-4881-ae81-c59c4bf5d0f3','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2619bd4b-202b-4881-ae81-c59c4bf5d0f3.png','SNAPS','PATIENT_dffebdef-29f0-48d3-a06b-c16d19da2836_ACT_877296c2-8eeb-49fe-afdb-abb4d477d113_SESS_61ce92e0-cf8d-4d3a-bf40-f61b2dcf18e5_BOSC_5a5f0eb0-57c6-4b92-87a4-2943a6799cc5_SNAPS_','2022-02-01 11:48:12','2019-07-15 13:20:18','2619bd4b-202b-4881-ae81-c59c4bf5d0f3.png','2022-02-01 12:48:12','SYNCED','2619bd4b-202b-4881-ae81-c59c4bf5d0f3',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 63.3.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'261b675d-cf0e-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/261b675d-cf0e-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_68ccc647-d7af-43af-b066-4950901b78bd_ACT_1bfc9ae5-42fb-4b3d-8e54-a2c849ae3d96_SESS_10597265-5639-48a6-9f49-5b6f9e85d80e_BOSC_ff034889-564b-4963-9b02-7c27ba78729d_PLY_','2022-02-01 11:48:12','2019-09-04 14:18:19','261b675d-cf0e-11e9-947d-226cec7cb58a.ply','2022-02-01 12:48:12','SYNCED','261b675d-cf0e-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 144.1.1.1\",\"modelMatrix\":\"-0.741603,-0.656298,0.138919,0,0.670839,-0.725527,0.153573,0,-5.26333e-9,0.207083,0.978323,0,-23.5239,0.967448,-26.4964,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'261c974c-cf0e-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/261c974c-cf0e-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_68ccc647-d7af-43af-b066-4950901b78bd_ACT_1bfc9ae5-42fb-4b3d-8e54-a2c849ae3d96_SESS_10597265-5639-48a6-9f49-5b6f9e85d80e_BOSC_ff034889-564b-4963-9b02-7c27ba78729d_SNAPS_','2022-02-01 11:48:12','2019-09-04 14:18:19','261c974c-cf0e-11e9-947d-226cec7cb58a.png','2022-02-01 12:48:12','SYNCED','261c974c-cf0e-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 144.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'261dcae1-cf0e-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/261dcae1-cf0e-11e9-947d-226cec7cb58a.stl','STL','PATIENT_68ccc647-d7af-43af-b066-4950901b78bd_ACT_1bfc9ae5-42fb-4b3d-8e54-a2c849ae3d96_SESS_10597265-5639-48a6-9f49-5b6f9e85d80e_BOSC_ff034889-564b-4963-9b02-7c27ba78729d_STL_','2022-02-01 11:48:16','2019-09-04 14:18:19','261dcae1-cf0e-11e9-947d-226cec7cb58a.stl','2022-02-01 12:48:16','SYNCED','261dcae1-cf0e-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 144.1.1.1\",\"modelMatrix\":\"-0.741603,-0.656298,0.138919,0,0.670839,-0.725527,0.153573,0,-5.26333e-9,0.207083,0.978323,0,-23.5239,0.967448,-26.4964,1\",\"title\":\"MANDIBULE STL\"}'),(2,'264e66e3-51ed-4d96-b141-b7bfb2694c31','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/264e66e3-51ed-4d96-b141-b7bfb2694c31.png','SNAPS','PATIENT_53100b02-c94b-47bc-8b64-ebba6073de50_ACT_8464161e-f420-42dd-97a7-8d8a43e0d890_SESS_24b4b44e-82d8-423d-a1e9-3be90a46aad3_TOSC_f4706931-83dd-4c85-aba6-b8279066b046_SNAPS_','2021-02-11 15:56:19','2020-06-17 11:37:38','264e66e3-51ed-4d96-b141-b7bfb2694c31.png','2021-02-11 16:56:19','SYNCED','264e66e3-51ed-4d96-b141-b7bfb2694c31',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.50.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'264f342e-245a-4b70-b347-79dd5adf2cae','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/264f342e-245a-4b70-b347-79dd5adf2cae.ply','PLY','PATIENT_67d39055-0cd5-49c0-9f3b-2cc576bfc310_ACT_291510cf-2ad2-4298-817d-22026f7bf446_SESS_9284a539-a136-47a9-a524-769845154750_BOSC_9a58cd85-8834-4e0c-92c1-2ea40f660e6d_PLY_','2022-02-01 11:48:16','2019-07-24 15:21:56','264f342e-245a-4b70-b347-79dd5adf2cae.ply','2022-02-01 12:48:16','SYNCED','264f342e-245a-4b70-b347-79dd5adf2cae',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 114.1.1.1\",\"modelMatrix\":\"-0.729991,0.673961,-0.11353,0,-0.683456,-0.71985,0.12126,0,-3.67039e-9,0.166112,0.986107,0,-5.44857,24.2465,-24.2553,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'2662d14c-342a-47b8-80e8-b77baf2258ff','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2662d14c-342a-47b8-80e8-b77baf2258ff.png','SNAPS','PATIENT_9bdadecd-3730-4989-a33e-fe0feac57f3a_ACT_eb210610-e663-4719-881d-f565abd3fa10_SESS_e338a54c-fc97-4f7d-866b-5b6bed0fc882_BOSC_954fc72d-548e-4607-a7b0-1ef0125d37c1_SNAPS_','2021-02-11 15:56:19','2020-05-27 13:43:34','2662d14c-342a-47b8-80e8-b77baf2258ff.png','2021-02-11 16:56:19','SYNCED','2662d14c-342a-47b8-80e8-b77baf2258ff',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 49.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(524,'2664c41c-9edf-47a5-960a-9eabbafa4179','/var/.data/2020/9f2592c4-76b3-4230-b316-5ec7307bcb92/2a40421f-a9d5-41ba-9038-ffb6617b8b4b/session_e4f3f501-0920-4580-a2a7-147aac8ee471/occlusion_d32d455b-5916-40f8-bd39-4d728901842f/scan_64adc875-cbd9-42b2-a239-70f0f745072b/2_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_2a40421f-a9d5-41ba-9038-ffb6617b8b4b_ACT_e4f3f501-0920-4580-a2a7-147aac8ee471_SESS_d32d455b-5916-40f8-bd39-4d728901842f_BOSC_64adc875-cbd9-42b2-a239-70f0f745072b_SNAPS_','2022-03-04 13:42:45','2020-01-22 13:51:51','2_w1_o1_mandibule_snapshot_0.png','2022-03-04 14:42:45','SYNCED','2664c41c-9edf-47a5-960a-9eabbafa4179',0,NULL,'9f2592c4-76b3-4230-b316-5ec7307bcb92','9f2592c4-76b3-4230-b316-5ec7307bcb92','{\"displayTitle\":\"Mandibule 1.2.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'2671ea28-9bf3-4690-9881-dab406dc8a72','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2671ea28-9bf3-4690-9881-dab406dc8a72.png','SNAPS','PATIENT_16367112-6a96-47d9-859f-3dc28d5a08e4_ACT_628e12f5-617f-4cd1-94f1-89c29cf040d1_SESS_78998169-feb8-4484-a493-1ba5891adbe8_TOSC_db8d3774-4102-4f43-b2ed-dbb2594c18ac_SNAPS_','2022-02-01 11:48:17','2019-09-04 10:57:41','2671ea28-9bf3-4690-9881-dab406dc8a72.png','2022-02-01 12:48:17','SYNCED','2671ea28-9bf3-4690-9881-dab406dc8a72',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 143.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'267a1d1c-b82e-4964-b5c9-2ac5c050fbf8','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/267a1d1c-b82e-4964-b5c9-2ac5c050fbf8.stl','STL','PATIENT_4887c403-6684-431d-9efd-4230d74f9f6e_ACT_b67be1ff-ec7d-4035-9281-b8e4b218da86_SESS_1c9989e2-d42d-4cab-80e3-b783c63d8a22_BOSC_018e2213-672e-4d3a-b803-426a6ae54b82_STL_','2021-12-30 18:04:35','2019-10-10 14:24:13','267a1d1c-b82e-4964-b5c9-2ac5c050fbf8.stl','2021-12-30 19:04:35','SYNCED','267a1d1c-b82e-4964-b5c9-2ac5c050fbf8',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 184.1.1.1\",\"modelMatrix\":\"0.966458,-0.256743,0.00650652,0,0.256826,0.966148,-0.0244846,0,-2.09839e-10,0.0253344,0.999679,0,9.6621,-23.4411,-23.1822,1\",\"title\":\"MANDIBULE STL\"}'),(2,'267d2195-10c0-42eb-bfc4-7d039b6b3973','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/267d2195-10c0-42eb-bfc4-7d039b6b3973.stl','STL','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_BOSC_a9a62eef-7474-4307-b60b-7a50c1cea0c8_STL_','2021-12-30 18:04:36','2019-11-15 14:00:22','267d2195-10c0-42eb-bfc4-7d039b6b3973.stl','2021-12-30 19:04:36','SYNCED','267d2195-10c0-42eb-bfc4-7d039b6b3973',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 202.1.1.1\",\"modelMatrix\":\"-0.994025,-0.105788,0.0268761,0,0.109149,-0.96342,0.244763,0,4.14586e-10,0.246234,0.96921,0,-15.6582,8.51879,-29.1663,1\",\"title\":\"MANDIBULE STL\"}'),(2,'267d40dc-c0ab-435a-bf2a-3d52dec9a853','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/267d40dc-c0ab-435a-bf2a-3d52dec9a853.stl','STL','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_TOSC_03aaf826-a041-432a-a917-8af9a1e25b73_STL_','2021-12-30 18:04:38','2019-11-15 11:06:50','267d40dc-c0ab-435a-bf2a-3d52dec9a853.stl','2021-12-30 19:04:38','SYNCED','267d40dc-c0ab-435a-bf2a-3d52dec9a853',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 202.1.1.1\",\"modelMatrix\":\"0.756092,-0.611841,0.232326,0,0.654465,0.706849,-0.268402,0,1.1094e-8,0.354986,0.934872,0,7.06144,-37.4454,-15.1845,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'267ddf37-f5c6-4cdd-9234-bbff26785b36','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/267ddf37-f5c6-4cdd-9234-bbff26785b36.stl','STL','PATIENT_95405121-f140-4116-92ca-cae7d44f9bba_ACT_3d2ec6af-c315-4775-9d50-cf24a2a45658_SESS_faa85dca-33e7-48ff-9dc3-1ff7d89b3feb_BOSC_27f5e407-f1e1-4db7-84b3-b7d173106c32_STL_','2022-02-01 11:48:17','2019-07-16 08:44:55','267ddf37-f5c6-4cdd-9234-bbff26785b36.stl','2022-02-01 12:48:17','SYNCED','267ddf37-f5c6-4cdd-9234-bbff26785b36',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 73.1.1.1\",\"modelMatrix\":\"-0.972787,-0.226138,0.0504687,0,0.231701,-0.94943,0.211891,0,1.66262e-9,0.217818,0.975989,0,-25.3697,10.0166,-23.5228,1\",\"title\":\"MANDIBULE STL\"}'),(2,'268df21f-8787-48c7-babc-9ce4fae9a7e4','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/268df21f-8787-48c7-babc-9ce4fae9a7e4.ply','PLY','PATIENT_944eb49e-32a6-450d-a2ef-6cb420031bbb_ACT_27b727ae-63d6-4686-ab97-71fe9256c87a_SESS_035fb980-4fc7-4a0a-9a11-e7b912145869_BOSC_c4965721-b28f-4029-a345-8c100ae9bfaa_PLY_','2022-02-01 11:48:17','2019-08-05 17:06:01','268df21f-8787-48c7-babc-9ce4fae9a7e4.ply','2022-02-01 12:48:17','SYNCED','268df21f-8787-48c7-babc-9ce4fae9a7e4',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 125.1.1.1\",\"modelMatrix\":\"-0.985587,-0.166489,0.029998,0,0.16917,-0.969968,0.174769,0,-1.145e-9,0.177325,0.984152,0,-22.7748,14.1918,-32.8987,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'26972064-1026-467b-b695-d5ea138c9dad','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/26972064-1026-467b-b695-d5ea138c9dad.ply','PLY','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_TOSC_5895661c-2003-4b99-867a-ea298023c400_PLY_','2021-12-30 18:04:40','2019-11-15 11:12:32','26972064-1026-467b-b695-d5ea138c9dad.ply','2021-12-30 19:04:40','SYNCED','26972064-1026-467b-b695-d5ea138c9dad',0,NULL,'','','{\"displayTitle\":\"Mascella 0\",\"modelMatrix\":\"0.448489,-0.837122,0.313184,0,0.893789,0.420055,-0.157151,0,-2.44323e-9,0.350401,0.9366,0,-4.19298,-34.4643,-17.7158,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'26a1bfe5-89fd-44fb-a709-982e27be6ad9','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/26a1bfe5-89fd-44fb-a709-982e27be6ad9.ply','PLY','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_a3de1c4e-bb42-4e1e-b136-9922607a4144_SESS_1a924035-7ad6-49df-81ca-8b9e8ff8131b_BOSC_ba0bca0a-688c-4cd2-b2be-b59b477766b8_PLY_','2021-02-11 15:56:21','2020-01-15 13:54:53','26a1bfe5-89fd-44fb-a709-982e27be6ad9.ply','2021-02-11 16:56:21','SYNCED','26a1bfe5-89fd-44fb-a709-982e27be6ad9',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.1.1.1.2\",\"modelMatrix\":\"-0.999604,0.02774,-0.00467823,0,-0.0281318,-0.985685,0.166231,0,2.07287e-10,0.166297,0.986076,0,-22.5187,18.2729,-18.5722,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'26c027db-04ca-4cf8-9234-c50bcd017f8b','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/26c027db-04ca-4cf8-9234-c50bcd017f8b.ply','PLY','PATIENT_c43dfbc1-87d5-42db-ab2b-544103380ac4_ACT_c138fcf7-8ef1-4cc2-884a-91278deed561_SESS_9ea9c387-3185-4853-a925-ef49faac58a2_TOSC_57f133b7-0701-4a48-970b-fed868a34091_PLY_','2021-02-11 15:56:21','2019-12-31 11:31:21','26c027db-04ca-4cf8-9234-c50bcd017f8b.ply','2021-02-11 16:56:21','SYNCED','26c027db-04ca-4cf8-9234-c50bcd017f8b',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"modelMatrix\":\"0.38673,-0.875112,0.290893,0,0.922193,0.366987,-0.121989,0,-9.26495e-11,0.315437,0.948947,0,0.870876,-26.7547,-24.2684,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'26ccec8f-7a34-4b10-8321-c3f6734eb92c','','SNAPS','PATIENT_6df72f48-6933-4986-9961-403150b72460_ACT_8066fb46-4e88-4174-a7b5-ced23d87937b_SESS_59d4c3ec-651e-4d62-b38d-23c6193830fb_TOSC_c6783949-8a9a-42ca-814a-9600e7796d81_SNAPS_','2022-02-01 11:48:17','2019-09-03 10:01:19','','2022-02-01 12:48:17','SYNCED','26ccec8f-7a34-4b10-8321-c3f6734eb92c',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 140.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'26eac4fe-00bd-47e4-aac7-ec0bfa0d862b','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/26eac4fe-00bd-47e4-aac7-ec0bfa0d862b.png','SNAPS','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_bddee589-9eb3-49ab-8787-283d50085d40_SESS_8b76caad-4ecf-4e29-a9ad-8754395dc454_TOSC_3f5c652d-12c7-4b24-b7ce-9ba785820104_SNAPS_','2021-02-11 15:56:22','2019-12-16 14:38:49','26eac4fe-00bd-47e4-aac7-ec0bfa0d862b.png','2021-02-11 16:56:22','SYNCED','26eac4fe-00bd-47e4-aac7-ec0bfa0d862b',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.16.1.1.2\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'2753ed14-2eff-46d0-a3d0-1569a995f9af','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2753ed14-2eff-46d0-a3d0-1569a995f9af.png','SNAPS','PATIENT_84817142-00fa-404c-bc75-3c1bd55648b7_ACT_14643d0c-fc35-45b4-a60e-26d206653526_SESS_833387df-f92e-416d-ae3b-2e3142fb69b7_BOSC_c5d598e8-9735-4593-bfb5-1db057ca39c5_SNAPS_','2021-08-19 22:43:14','2019-11-27 20:46:20','2753ed14-2eff-46d0-a3d0-1569a995f9af.png','2021-08-20 00:43:14','SYNCED','2753ed14-2eff-46d0-a3d0-1569a995f9af',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 214.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'27584101-5431-4e78-b478-dd4fe8020b89','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/27584101-5431-4e78-b478-dd4fe8020b89.stl','STL','PATIENT_de25b615-973f-4c4b-816f-91e661f13dde_ACT_671432ea-64fe-4d83-b4a7-ca1415ddf527_SESS_ab99f8ce-fe34-496e-b44b-81de6494455d_TOSC_aa2ec091-86f9-4070-9740-688da8959714_STL_','2022-02-01 11:48:17','2019-07-12 09:01:50','27584101-5431-4e78-b478-dd4fe8020b89.stl','2022-02-01 12:48:17','SYNCED','27584101-5431-4e78-b478-dd4fe8020b89',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 52.1.1.1\",\"modelMatrix\":\"0.282669,-0.940684,0.18765,0,0.959217,0.277208,-0.0552981,0,-7.02423e-10,0.195628,0.980678,0,-6.20571,-33.8258,-13.6689,1\",\"title\":\"MAXILLAIRE STL\"}'),(524,'275ae209-65ef-48fd-a768-907a237eab23','/var/.data/2020/9f2592c4-76b3-4230-b316-5ec7307bcb92/5e1c39c4-bfce-46b5-924b-131fc5789ca0/session_4dbe54be-76e7-4c55-8510-236002f4572f/occlusion_364dd289-5c0c-4304-b23f-06159567a094/scan_e0111396-0376-4668-ad69-76aca0a5c775/3_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_5e1c39c4-bfce-46b5-924b-131fc5789ca0_ACT_4dbe54be-76e7-4c55-8510-236002f4572f_SESS_364dd289-5c0c-4304-b23f-06159567a094_TOSC_e0111396-0376-4668-ad69-76aca0a5c775_SNAPS_','2022-03-04 13:42:45','2020-01-22 14:12:15','3_w1_o1_maxillaire_snapshot_0.png','2022-03-04 14:42:45','SYNCED','275ae209-65ef-48fd-a768-907a237eab23',0,NULL,'9f2592c4-76b3-4230-b316-5ec7307bcb92','9f2592c4-76b3-4230-b316-5ec7307bcb92','{\"displayTitle\":\"Maxillaire 1.3.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'275bfca3-25cb-4e62-b0e8-f1f4ed840a06','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/275bfca3-25cb-4e62-b0e8-f1f4ed840a06.ply','PLY','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_TOSC_44516845-ca32-49c0-8577-f34223c31274_PLY_','2021-12-30 18:04:42','2019-11-14 12:20:16','275bfca3-25cb-4e62-b0e8-f1f4ed840a06.ply','2021-12-30 19:04:42','SYNCED','275bfca3-25cb-4e62-b0e8-f1f4ed840a06',0,NULL,'','','{\"displayTitle\":\"Mascella 0\",\"modelMatrix\":\"0.716692,-0.650629,0.251068,0,0.69739,0.668636,-0.258016,0,-6.71938e-9,0.36001,0.932948,0,-0.173964,-31.8973,-16.6105,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'277bd0bb-b59d-40af-b455-1290cf868dba','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/277bd0bb-b59d-40af-b455-1290cf868dba.ply','PLY','PATIENT_24508ae5-050d-4367-a6bf-e8b3afbe9bd4_ACT_69dea633-e25c-4e85-87a6-e51ed662f863_SESS_0212c0aa-313c-4751-acec-87455cd29190_BOSC_e6ddd6ad-3096-49b1-a3e2-dc1c2c660b51_PLY_','2021-12-30 18:04:42','2019-10-09 12:11:21','277bd0bb-b59d-40af-b455-1290cf868dba.ply','2021-12-30 19:04:42','SYNCED','277bd0bb-b59d-40af-b455-1290cf868dba',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 183.1.1.1\",\"modelMatrix\":\"0.88134,0.470286,-0.045499,0,-0.472482,0.877244,-0.0848712,0,3.8862e-9,0.0962979,0.995353,0,19.8229,-6.67853,-25.6891,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'277ca434-d46e-4375-ba7f-0bd22cac5d4c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/277ca434-d46e-4375-ba7f-0bd22cac5d4c.ply','PLY','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_0c21ba1f-7cd7-44dd-9efe-afc4bc0145fe_SESS_01b67f56-d54d-439c-a58d-300ec35bfc5a_BOSC_d41c5f2a-389f-4ef5-a447-24fa1e59f8f0_PLY_','2021-02-11 15:56:25','2020-01-21 14:56:40','277ca434-d46e-4375-ba7f-0bd22cac5d4c.ply','2021-02-11 16:56:25','SYNCED','277ca434-d46e-4375-ba7f-0bd22cac5d4c',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.1.1.1.1\",\"modelMatrix\":\"-0.904618,0.425316,-0.0277955,0,-0.426223,-0.902692,0.0589934,0,-1.72404e-10,0.0652136,0.997871,0,3.2129,22.1905,-23.5369,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'277eb87d-a9e9-4662-808a-e54dff869a99','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/277eb87d-a9e9-4662-808a-e54dff869a99.png','SNAPS','PATIENT_f3e2711a-4a50-43c0-81ed-79aff7c7e3d9_ACT_249106b8-8e78-48ce-bb17-76612bb11c46_SESS_b11270a1-ab24-43c5-9863-edf1a7287b62_BOSC_9f85bdda-ea29-4d91-9258-6cee6b592767_SNAPS_','2021-08-19 22:43:18','2019-11-27 21:29:12','277eb87d-a9e9-4662-808a-e54dff869a99.png','2021-08-20 00:43:18','SYNCED','277eb87d-a9e9-4662-808a-e54dff869a99',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 215.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'27804d44-1d0d-4356-b4d8-8ac227e0bcb1','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/27804d44-1d0d-4356-b4d8-8ac227e0bcb1.ply','PLY','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_d5b62591-5b4d-4e35-ae77-da155fdfa0a7_SESS_3c48c829-0fd8-4841-8a2b-372c2401b25a_BOSC_f05f8175-5e8f-4fa1-af38-e37f54d89443_PLY_','2021-02-11 15:56:25','2020-01-02 14:26:39','27804d44-1d0d-4356-b4d8-8ac227e0bcb1.ply','2021-02-11 16:56:25','SYNCED','27804d44-1d0d-4356-b4d8-8ac227e0bcb1',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"modelMatrix\":\"-0.938628,0.336888,-0.0740558,0,-0.344932,-0.91674,0.201521,0,-8.25178e-10,0.214697,0.976681,0,-5.20897,20.3826,-16.4156,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'278f7607-7831-4606-8c8b-90c694de255f','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/278f7607-7831-4606-8c8b-90c694de255f.ply','PLY','PATIENT_8e20155d-2648-4544-857c-cabb1265b67d_ACT_9aa21519-6a35-4e2b-979d-a5ad755fe712_SESS_0ffb6770-2cf6-459c-91a4-878d29e9ef1d_TOSC_fd194316-6a25-4dcb-a8d8-5f8681f78ab2_PLY_','2022-03-04 13:40:30','2019-07-09 09:06:00','278f7607-7831-4606-8c8b-90c694de255f.ply','2022-03-04 14:40:30','SYNCED','278f7607-7831-4606-8c8b-90c694de255f',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 7.1.1.1\",\"modelMatrix\":\"0.969937,-0.236621,0.0568528,0,0.243355,0.943097,-0.226598,0,-1.11086e-9,0.233621,0.972328,0,-28.5892,-22.6762,-22.157,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'27c21d57-5203-4c6f-ac3f-fa7103a6544b','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/27c21d57-5203-4c6f-ac3f-fa7103a6544b.stl','STL','PATIENT_8e20155d-2648-4544-857c-cabb1265b67d_ACT_9aa21519-6a35-4e2b-979d-a5ad755fe712_SESS_0ffb6770-2cf6-459c-91a4-878d29e9ef1d_TOSC_fd194316-6a25-4dcb-a8d8-5f8681f78ab2_STL_','2022-03-04 13:40:31','2019-07-09 09:06:00','27c21d57-5203-4c6f-ac3f-fa7103a6544b.stl','2022-03-04 14:40:31','SYNCED','27c21d57-5203-4c6f-ac3f-fa7103a6544b',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 7.1.1.1\",\"modelMatrix\":\"0.969937,-0.236621,0.0568528,0,0.243355,0.943097,-0.226598,0,-1.11086e-9,0.233621,0.972328,0,-28.5892,-22.6762,-22.157,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'27cf08e2-9b2a-429f-888a-5dc46d6b343c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/27cf08e2-9b2a-429f-888a-5dc46d6b343c.png','SNAPS','PATIENT_bc50bff3-dacb-4f7a-a7c8-b971782c6d1d_ACT_be5de36f-b43d-47f3-b178-801c7822bb7d_SESS_df767eeb-30cd-456e-91c0-aa5269ac29d4_TOSC_c0093ed9-df83-4a90-85a8-3b2e25ec094d_SNAPS_','2021-08-19 22:43:19','2019-11-27 18:49:49','27cf08e2-9b2a-429f-888a-5dc46d6b343c.png','2021-08-20 00:43:19','SYNCED','27cf08e2-9b2a-429f-888a-5dc46d6b343c',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 212.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'27e427b6-1124-44e0-a7ec-d78871c2696b','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_6885f3a8-c779-49e9-87ed-5d4c70e2ca06/27e427b6-1124-44e0-a7ec-d78871c2696b.png','SNAPS','PATIENT_0453378f-5439-4da7-9cb5-52d1ffc679d4_ACT_30d14ef5-fb40-43a4-bfff-e611ee67a93e_SESS_cd91998e-cbf9-4ceb-929b-eb2c0c8baf3f_RISC_8ee543b5-8392-4cdd-83dd-b63b33812263_SNAPS_','2022-02-01 11:48:18','2019-09-30 11:07:26','27e427b6-1124-44e0-a7ec-d78871c2696b.png','2022-02-01 12:48:18','SYNCED','27e427b6-1124-44e0-a7ec-d78871c2696b',0,NULL,'','','{\"displayTitle\":\"MORDU_POSTERIEUR_DROIT 165.1.1.1\",\"title\":\"MORDU_POSTERIEUR_DROIT SNAPSHOT\"}'),(2,'27e6bb09-c3d1-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/27e6bb09-c3d1-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_a20c5079-e26f-4d25-a4f7-898bb7b44b4f_ACT_2d40ced0-53bf-41a0-b55d-a8170b2031a3_SESS_0e2721b3-8710-485f-8ea8-bded33c4312d_TOSC_ac4cee3f-45d4-431b-899a-1094f9f31a8d_STL_','2022-02-01 11:48:18','2019-08-20 15:17:46','27e6bb09-c3d1-11e9-a33b-226cec7cb58a.stl','2022-02-01 12:48:18','SYNCED','27e6bb09-c3d1-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 129.1.1.1\",\"modelMatrix\":\"0.63609,-0.729718,0.250801,0,0.771615,0.601552,-0.206751,0,-3.92588e-9,0.325035,0.945702,0,0.907116,-34.8798,-16.1821,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'27e75df7-c3d1-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/27e75df7-c3d1-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_a20c5079-e26f-4d25-a4f7-898bb7b44b4f_ACT_2d40ced0-53bf-41a0-b55d-a8170b2031a3_SESS_0e2721b3-8710-485f-8ea8-bded33c4312d_BOSC_8ab1e8fb-fb20-41fb-8bdb-67a2faf7d398_PLY_','2022-02-01 11:48:18','2019-08-21 09:12:10','27e75df7-c3d1-11e9-a33b-226cec7cb58a.ply','2022-02-01 12:48:18','SYNCED','27e75df7-c3d1-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 129.1.1.1\",\"modelMatrix\":\"0.988795,0.148966,-0.00968196,0,-0.149281,0.986713,-0.0641307,0,-3.19455e-10,0.0648574,0.997895,0,20.4665,-16.6033,-28.2062,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'27e7f60e-c3d1-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/27e7f60e-c3d1-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_a20c5079-e26f-4d25-a4f7-898bb7b44b4f_ACT_2d40ced0-53bf-41a0-b55d-a8170b2031a3_SESS_0e2721b3-8710-485f-8ea8-bded33c4312d_TOSC_ac4cee3f-45d4-431b-899a-1094f9f31a8d_PLY_','2022-02-01 11:48:19','2019-08-20 15:17:46','27e7f60e-c3d1-11e9-a33b-226cec7cb58a.ply','2022-02-01 12:48:19','SYNCED','27e7f60e-c3d1-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 129.1.1.1\",\"modelMatrix\":\"0.63609,-0.729718,0.250801,0,0.771615,0.601552,-0.206751,0,-3.92588e-9,0.325035,0.945702,0,0.907116,-34.8798,-16.1821,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'27e884cf-c3d1-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/27e884cf-c3d1-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_a20c5079-e26f-4d25-a4f7-898bb7b44b4f_ACT_2d40ced0-53bf-41a0-b55d-a8170b2031a3_SESS_0e2721b3-8710-485f-8ea8-bded33c4312d_BOSC_8ab1e8fb-fb20-41fb-8bdb-67a2faf7d398_SNAPS_','2022-02-01 11:48:19','2019-08-21 09:12:10','27e884cf-c3d1-11e9-a33b-226cec7cb58a.png','2022-02-01 12:48:19','SYNCED','27e884cf-c3d1-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 129.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'27e92401-c3d1-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/27e92401-c3d1-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_a20c5079-e26f-4d25-a4f7-898bb7b44b4f_ACT_2d40ced0-53bf-41a0-b55d-a8170b2031a3_SESS_0e2721b3-8710-485f-8ea8-bded33c4312d_TOSC_ac4cee3f-45d4-431b-899a-1094f9f31a8d_SNAPS_','2022-02-01 11:48:19','2019-08-20 15:17:46','27e92401-c3d1-11e9-a33b-226cec7cb58a.png','2022-02-01 12:48:19','SYNCED','27e92401-c3d1-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 129.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'27e9bff9-c3d1-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/27e9bff9-c3d1-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_a20c5079-e26f-4d25-a4f7-898bb7b44b4f_ACT_2d40ced0-53bf-41a0-b55d-a8170b2031a3_SESS_0e2721b3-8710-485f-8ea8-bded33c4312d_BOSC_8ab1e8fb-fb20-41fb-8bdb-67a2faf7d398_STL_','2022-02-01 11:48:19','2019-08-21 09:12:10','27e9bff9-c3d1-11e9-a33b-226cec7cb58a.stl','2022-02-01 12:48:19','SYNCED','27e9bff9-c3d1-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 129.1.1.1\",\"modelMatrix\":\"0.988795,0.148966,-0.00968196,0,-0.149281,0.986713,-0.0641307,0,-3.19455e-10,0.0648574,0.997895,0,20.4665,-16.6033,-28.2062,1\",\"title\":\"MANDIBULE STL\"}'),(2,'27fddb53-7d64-48bf-913d-4d6dc538e73e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/27fddb53-7d64-48bf-913d-4d6dc538e73e.png','SNAPS','PATIENT_7bc3212d-9298-4074-84af-cec8733a233a_ACT_3939d6f4-5dfe-4220-9391-41569e7c9dd7_SESS_f58192db-f352-4ab9-be15-abb55efd94ed_TOSC_d9f87dc0-b231-458f-baac-287f7ad673c9_SNAPS_','2021-02-11 15:56:28','2020-01-02 10:50:40','27fddb53-7d64-48bf-913d-4d6dc538e73e.png','2021-02-11 16:56:28','SYNCED','27fddb53-7d64-48bf-913d-4d6dc538e73e',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'2804b6c6-1837-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2804b6c6-1837-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_c7652665-71bd-461e-a124-c26bb95893f1_ACT_e3a98034-08e2-4b98-aebb-e3e098593612_SESS_5a2f63cd-863a-464a-8ba9-a6efa7738c10_TOSC_0a718297-770a-4d62-a17c-57e690e0333a_PLY_','2021-02-16 16:40:31','2019-12-06 15:39:36','2804b6c6-1837-11ea-947d-226cec7cb58a.ply','2021-02-16 17:40:31','SYNCED','2804b6c6-1837-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 230.2.1.1\",\"modelMatrix\":\"0.524259,-0.842949,0.120788,0,0.851559,0.518959,-0.0743625,0,1.08292e-8,0.141843,0.989889,0,-4.29475,-30.8267,-13.8515,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'2805706a-7e1c-4b59-8c7d-2f29bb2d1d65','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2805706a-7e1c-4b59-8c7d-2f29bb2d1d65.ply','PLY','PATIENT_ae02cf00-1850-4620-987b-4d05333da3d4_ACT_1853f626-d6a7-4c48-9935-7386491435e0_SESS_cf856030-b309-41de-a1c5-1c50dd600256_TOSC_449f0b15-f391-4b2a-95db-0bd04141685e_PLY_','2021-08-19 22:43:25','2019-11-22 14:17:27','2805706a-7e1c-4b59-8c7d-2f29bb2d1d65.ply','2021-08-20 00:43:25','SYNCED','2805706a-7e1c-4b59-8c7d-2f29bb2d1d65',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 209.1.1.1\",\"modelMatrix\":\"0.222155,-0.935316,0.275375,0,0.975011,0.21311,-0.0627437,0,5.31813e-10,0.282433,0.959287,0,-16.0542,-28.2961,-17.3413,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'28065a2d-1837-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/28065a2d-1837-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_c7652665-71bd-461e-a124-c26bb95893f1_ACT_e3a98034-08e2-4b98-aebb-e3e098593612_SESS_5a2f63cd-863a-464a-8ba9-a6efa7738c10_BOSC_c901f216-8008-4f06-a72d-f82aeff3eec1_PLY_','2021-02-16 16:40:32','2019-12-06 15:43:18','28065a2d-1837-11ea-947d-226cec7cb58a.ply','2021-02-16 17:40:32','SYNCED','28065a2d-1837-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 230.2.1.1\",\"modelMatrix\":\"-0.940976,0.332249,-0.0646136,0,-0.338474,-0.923671,0.17963,0,8.27796e-10,0.190897,0.98161,0,-10.3071,21.8197,-13.5618,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'2806816b-f620-41bb-84b4-8f3f044571fc','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2806816b-f620-41bb-84b4-8f3f044571fc.png','SNAPS','PATIENT_227c16ab-62f2-4f76-a1f4-3a753d883af7_ACT_b819729a-c589-41ec-af68-d13a0bb8c21a_SESS_caed56fc-3a88-41c5-ba84-693c72fc12d4_TOSC_85f85038-2a2a-4658-8e03-04710b384826_SNAPS_','2022-02-01 11:48:19','2019-09-18 10:56:21','2806816b-f620-41bb-84b4-8f3f044571fc.png','2022-02-01 12:48:19','SYNCED','2806816b-f620-41bb-84b4-8f3f044571fc',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 152.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'2807c394-1837-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2807c394-1837-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_c7652665-71bd-461e-a124-c26bb95893f1_ACT_e3a98034-08e2-4b98-aebb-e3e098593612_SESS_5a2f63cd-863a-464a-8ba9-a6efa7738c10_BOSC_c901f216-8008-4f06-a72d-f82aeff3eec1_SNAPS_','2021-02-16 16:40:32','2019-12-06 15:43:18','2807c394-1837-11ea-947d-226cec7cb58a.png','2021-02-16 17:40:32','SYNCED','2807c394-1837-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 230.2.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'28092d00-1837-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/28092d00-1837-11ea-947d-226cec7cb58a.stl','STL','PATIENT_c7652665-71bd-461e-a124-c26bb95893f1_ACT_e3a98034-08e2-4b98-aebb-e3e098593612_SESS_5a2f63cd-863a-464a-8ba9-a6efa7738c10_TOSC_0a718297-770a-4d62-a17c-57e690e0333a_STL_','2021-02-16 16:40:32','2019-12-06 15:39:36','28092d00-1837-11ea-947d-226cec7cb58a.stl','2021-02-16 17:40:32','SYNCED','28092d00-1837-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 230.2.1.1\",\"modelMatrix\":\"0.524259,-0.842949,0.120788,0,0.851559,0.518959,-0.0743625,0,1.08292e-8,0.141843,0.989889,0,-4.29475,-30.8267,-13.8515,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'280a9af8-1837-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/280a9af8-1837-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_c7652665-71bd-461e-a124-c26bb95893f1_ACT_e3a98034-08e2-4b98-aebb-e3e098593612_SESS_5a2f63cd-863a-464a-8ba9-a6efa7738c10_TOSC_0a718297-770a-4d62-a17c-57e690e0333a_SNAPS_','2021-02-16 16:40:33','2019-12-06 15:39:36','280a9af8-1837-11ea-947d-226cec7cb58a.png','2021-02-16 17:40:33','SYNCED','280a9af8-1837-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 230.2.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'280c11ad-1837-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/280c11ad-1837-11ea-947d-226cec7cb58a.stl','STL','PATIENT_c7652665-71bd-461e-a124-c26bb95893f1_ACT_e3a98034-08e2-4b98-aebb-e3e098593612_SESS_5a2f63cd-863a-464a-8ba9-a6efa7738c10_BOSC_c901f216-8008-4f06-a72d-f82aeff3eec1_STL_','2021-02-16 16:40:33','2019-12-06 15:43:18','280c11ad-1837-11ea-947d-226cec7cb58a.stl','2021-02-16 17:40:33','SYNCED','280c11ad-1837-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 230.2.1.1\",\"modelMatrix\":\"-0.940976,0.332249,-0.0646136,0,-0.338474,-0.923671,0.17963,0,8.27796e-10,0.190897,0.98161,0,-10.3071,21.8197,-13.5618,1\",\"title\":\"MANDIBULE STL\"}'),(2,'28139ac9-06e0-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/28139ac9-06e0-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_BOSC_f2c387e7-d80a-4eb5-83bb-7389bfba262a_SNAPS_','2021-12-30 18:04:53','2019-11-14 14:06:05','28139ac9-06e0-11ea-947d-226cec7cb58a.png','2021-12-30 19:04:53','SYNCED','28139ac9-06e0-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 202.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'28153b11-06e0-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/28153b11-06e0-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_TOSC_9416b36c-cc86-4c33-bbbb-ee8e6e7a8b9b_SNAPS_','2021-12-30 18:04:53','2019-11-14 13:59:02','28153b11-06e0-11ea-947d-226cec7cb58a.png','2021-12-30 19:04:53','SYNCED','28153b11-06e0-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 202.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'281690a1-06e0-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/281690a1-06e0-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_BOSC_f2c387e7-d80a-4eb5-83bb-7389bfba262a_PLY_','2021-12-30 18:04:53','2019-11-14 14:06:05','281690a1-06e0-11ea-947d-226cec7cb58a.ply','2021-12-30 19:04:53','SYNCED','281690a1-06e0-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 202.1.1.1\",\"modelMatrix\":\"-0.863144,0.488759,-0.126872,0,-0.504957,-0.835456,0.216867,0,-4.52696e-9,0.251253,0.967921,0,-9.77701,20.9827,-15.86,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'2817c765-06e0-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2817c765-06e0-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_TOSC_9416b36c-cc86-4c33-bbbb-ee8e6e7a8b9b_PLY_','2021-12-30 18:04:53','2019-11-14 13:59:02','2817c765-06e0-11ea-947d-226cec7cb58a.ply','2021-12-30 19:04:53','SYNCED','2817c765-06e0-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 202.1.1.1\",\"modelMatrix\":\"0.785912,-0.545968,0.290278,0,0.618339,0.693928,-0.368945,0,-4.14053e-9,0.469449,0.88296,0,9.44192,-36.2559,-14.6434,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'28190622-06e0-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/28190622-06e0-11ea-947d-226cec7cb58a.stl','STL','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_BOSC_f2c387e7-d80a-4eb5-83bb-7389bfba262a_STL_','2021-12-30 18:04:53','2019-11-14 14:06:05','28190622-06e0-11ea-947d-226cec7cb58a.stl','2021-12-30 19:04:53','SYNCED','28190622-06e0-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 202.1.1.1\",\"modelMatrix\":\"-0.863144,0.488759,-0.126872,0,-0.504957,-0.835456,0.216867,0,-4.52696e-9,0.251253,0.967921,0,-9.77701,20.9827,-15.86,1\",\"title\":\"MANDIBULE STL\"}'),(2,'281a3c39-06e0-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/281a3c39-06e0-11ea-947d-226cec7cb58a.stl','STL','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_TOSC_9416b36c-cc86-4c33-bbbb-ee8e6e7a8b9b_STL_','2021-12-30 18:04:54','2019-11-14 13:59:02','281a3c39-06e0-11ea-947d-226cec7cb58a.stl','2021-12-30 19:04:54','SYNCED','281a3c39-06e0-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 202.1.1.1\",\"modelMatrix\":\"0.785912,-0.545968,0.290278,0,0.618339,0.693928,-0.368945,0,-4.14053e-9,0.469449,0.88296,0,9.44192,-36.2559,-14.6434,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'2832da70-cd9f-420f-acfe-47393e00e018','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2832da70-cd9f-420f-acfe-47393e00e018.stl','STL','PATIENT_dc4cf315-524d-408f-b8de-af607aab88f6_ACT_aa317266-3fb3-41c2-9073-a3de3bc4c25e_SESS_dfe9ad46-537f-4906-b524-e43990804e77_TOSC_53f6668c-148c-4894-a873-656e22b88b95_STL_','2021-02-16 16:40:35','2019-12-13 15:40:43','2832da70-cd9f-420f-acfe-47393e00e018.stl','2021-02-16 17:40:35','SYNCED','2832da70-cd9f-420f-acfe-47393e00e018',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 232.25.1.1\",\"modelMatrix\":\"0.495435,-0.854978,0.153485,0,0.868645,0.48764,-0.0875406,0,1.85425e-9,0.176695,0.984266,0,-6.04437,-34.6594,-11.6895,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'28506531-8b96-4ab0-b316-ae10b083593a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/28506531-8b96-4ab0-b316-ae10b083593a.png','SNAPS','PATIENT_c240893c-f0b3-496f-a29c-6f58c49ba9bb_ACT_bd62034c-19cb-4da3-a4b7-2cb3f687c2c9_SESS_73819a0c-e2a8-477b-a803-c85cfdd60101_BOSC_cadd966e-ef3e-4169-9cf1-61a6565ba5a8_SNAPS_','2022-02-01 11:48:19','2019-07-19 11:06:41','28506531-8b96-4ab0-b316-ae10b083593a.png','2022-02-01 12:48:19','SYNCED','28506531-8b96-4ab0-b316-ae10b083593a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 97.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'28639f47-bd12-42cc-9248-1c6c91892958','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/28639f47-bd12-42cc-9248-1c6c91892958.png','SNAPS','PATIENT_06241678-eb3f-47ac-9851-393bf5d3a406_ACT_03c914bf-ef1a-4d7c-8a97-c98a392a9c13_SESS_553a8d13-f746-48ad-b91a-303a2c369140_TOSC_8928bff5-371e-4ddf-9503-17136d9ba16c_SNAPS_','2022-02-01 11:48:20','2019-07-26 09:04:27','28639f47-bd12-42cc-9248-1c6c91892958.png','2022-02-01 12:48:20','SYNCED','28639f47-bd12-42cc-9248-1c6c91892958',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 73.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'286cfb3d-0cf9-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/286cfb3d-0cf9-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_dde53ea4-f623-42e4-9864-d8e77d9deabe_ACT_c658c808-2655-4213-a8a0-1c34d5830ee5_SESS_ad32c977-4115-45c7-9168-d19d87c66102_TOSC_b289381b-23ec-4a96-9206-71132277e1ca_SNAPS_','2021-12-30 18:04:54','2019-11-22 08:14:15','286cfb3d-0cf9-11ea-947d-226cec7cb58a.png','2021-12-30 19:04:54','SYNCED','286cfb3d-0cf9-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 208.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'286e5b14-0cf9-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/286e5b14-0cf9-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_dde53ea4-f623-42e4-9864-d8e77d9deabe_ACT_c658c808-2655-4213-a8a0-1c34d5830ee5_SESS_ad32c977-4115-45c7-9168-d19d87c66102_BOSC_a2b7dde6-1c31-47e4-ba81-afc2bb602260_PLY_','2021-12-30 18:04:54','2019-11-22 08:23:12','286e5b14-0cf9-11ea-947d-226cec7cb58a.ply','2021-12-30 19:04:54','SYNCED','286e5b14-0cf9-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 208.1.1.1\",\"modelMatrix\":\"-0.852783,0.513392,-0.0958648,0,-0.522266,-0.838293,0.156533,0,-6.56088e-9,0.183556,0.983009,0,2.08999,21.5508,-19.8589,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'286fb47d-0cf9-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/286fb47d-0cf9-11ea-947d-226cec7cb58a.stl','STL','PATIENT_dde53ea4-f623-42e4-9864-d8e77d9deabe_ACT_c658c808-2655-4213-a8a0-1c34d5830ee5_SESS_ad32c977-4115-45c7-9168-d19d87c66102_TOSC_b289381b-23ec-4a96-9206-71132277e1ca_STL_','2021-12-30 18:04:55','2019-11-22 08:14:15','286fb47d-0cf9-11ea-947d-226cec7cb58a.stl','2021-12-30 19:04:55','SYNCED','286fb47d-0cf9-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 208.1.1.1\",\"modelMatrix\":\"0.372298,-0.882355,0.287826,0,0.928113,0.353943,-0.115457,0,6.55733e-10,0.31012,0.950698,0,-12.357,-35.988,-17.2824,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'28712522-0cf9-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/28712522-0cf9-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_dde53ea4-f623-42e4-9864-d8e77d9deabe_ACT_c658c808-2655-4213-a8a0-1c34d5830ee5_SESS_ad32c977-4115-45c7-9168-d19d87c66102_TOSC_b289381b-23ec-4a96-9206-71132277e1ca_PLY_','2021-12-30 18:04:55','2019-11-22 08:14:15','28712522-0cf9-11ea-947d-226cec7cb58a.ply','2021-12-30 19:04:55','SYNCED','28712522-0cf9-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 208.1.1.1\",\"modelMatrix\":\"0.372298,-0.882355,0.287826,0,0.928113,0.353943,-0.115457,0,6.55733e-10,0.31012,0.950698,0,-12.357,-35.988,-17.2824,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'2872de57-0cf9-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2872de57-0cf9-11ea-947d-226cec7cb58a.stl','STL','PATIENT_dde53ea4-f623-42e4-9864-d8e77d9deabe_ACT_c658c808-2655-4213-a8a0-1c34d5830ee5_SESS_ad32c977-4115-45c7-9168-d19d87c66102_BOSC_a2b7dde6-1c31-47e4-ba81-afc2bb602260_STL_','2021-12-30 18:04:55','2019-11-22 08:23:12','2872de57-0cf9-11ea-947d-226cec7cb58a.stl','2021-12-30 19:04:55','SYNCED','2872de57-0cf9-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 208.1.1.1\",\"modelMatrix\":\"-0.852783,0.513392,-0.0958648,0,-0.522266,-0.838293,0.156533,0,-6.56088e-9,0.183556,0.983009,0,2.08999,21.5508,-19.8589,1\",\"title\":\"MANDIBULE STL\"}'),(2,'2873eb17-0cf9-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2873eb17-0cf9-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_dde53ea4-f623-42e4-9864-d8e77d9deabe_ACT_c658c808-2655-4213-a8a0-1c34d5830ee5_SESS_ad32c977-4115-45c7-9168-d19d87c66102_BOSC_a2b7dde6-1c31-47e4-ba81-afc2bb602260_SNAPS_','2021-12-30 18:04:55','2019-11-22 08:23:12','2873eb17-0cf9-11ea-947d-226cec7cb58a.png','2021-12-30 19:04:55','SYNCED','2873eb17-0cf9-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 208.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'287c6b64-ee16-4c71-b59e-994be73e0796','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/287c6b64-ee16-4c71-b59e-994be73e0796.png','SNAPS','PATIENT_9bdadecd-3730-4989-a33e-fe0feac57f3a_ACT_8091ecd9-5b1c-489c-a60d-b5241a28910f_SESS_947f5704-d078-42a3-b6a2-bf73e4cabbca_BOSC_3c3fb67c-f365-4412-999e-24dd6774fcc2_SNAPS_','2021-02-11 15:56:32','2020-05-27 16:32:48','287c6b64-ee16-4c71-b59e-994be73e0796.png','2021-02-11 16:56:32','SYNCED','287c6b64-ee16-4c71-b59e-994be73e0796',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 49.1.6.1.2\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'287d053b-3d24-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/287d053b-3d24-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_3fae9447-e15b-4704-9907-1bf5e90f95dc_ACT_f9754ae5-b96b-4910-900e-5b70d2c7b9be_SESS_54470e11-bfb2-4144-9c34-70a077f1fb4f_TOSC_ad4f4efe-fe4a-46bd-a3d3-c82d4719c821_SNAPS_','2021-02-11 15:56:32','2020-01-22 15:30:10','287d053b-3d24-11ea-947d-226cec7cb58a.png','2021-02-11 16:56:32','SYNCED','287d053b-3d24-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'287e7b6f-3d24-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/287e7b6f-3d24-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_3fae9447-e15b-4704-9907-1bf5e90f95dc_ACT_f9754ae5-b96b-4910-900e-5b70d2c7b9be_SESS_54470e11-bfb2-4144-9c34-70a077f1fb4f_TOSC_ad4f4efe-fe4a-46bd-a3d3-c82d4719c821_PLY_','2021-02-11 15:56:32','2020-01-22 15:30:10','287e7b6f-3d24-11ea-947d-226cec7cb58a.ply','2021-02-11 16:56:32','SYNCED','287e7b6f-3d24-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.1.1.1.1\",\"modelMatrix\":\"0.490721,-0.840832,0.228461,0,0.871317,0.473552,-0.128668,0,6.11495e-9,0.262202,0.965013,0,-2.97447,-38.0121,-12.6781,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'287ff7fb-3d24-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/287ff7fb-3d24-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_f9754ae5-b96b-4910-900e-5b70d2c7b9be_SESS_54470e11-bfb2-4144-9c34-70a077f1fb4f_BOSC_eec13afb-ba8e-46de-8452-a49a52187356_PLY_','2021-02-11 15:56:33','2020-01-22 15:33:08','287ff7fb-3d24-11ea-947d-226cec7cb58a.ply','2021-02-11 16:56:33','SYNCED','287ff7fb-3d24-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.1.1.1.1\",\"modelMatrix\":\"0.126345,0.991203,-0.0394175,0,-0.991986,0.126245,-0.00502044,0,4.80103e-10,0.0397359,0.99921,0,15.8821,8.72212,-22.162,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'28814eb7-3d24-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/28814eb7-3d24-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_f9754ae5-b96b-4910-900e-5b70d2c7b9be_SESS_54470e11-bfb2-4144-9c34-70a077f1fb4f_BOSC_eec13afb-ba8e-46de-8452-a49a52187356_SNAPS_','2021-02-11 15:56:33','2020-01-22 15:33:08','28814eb7-3d24-11ea-947d-226cec7cb58a.png','2021-02-11 16:56:33','SYNCED','28814eb7-3d24-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'28921ead-b55d-4e42-8788-a406b836c1a2','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/28921ead-b55d-4e42-8788-a406b836c1a2.ply','PLY','PATIENT_4d02fa39-bbed-4725-b89c-52b99d593d1a_ACT_4c7c538a-19fe-4a08-abbf-bacc862a9058_SESS_4cedd4eb-a30f-4237-aa7a-b1927a0c89f9_BOSC_4cf1fc76-e900-40ec-bcf8-09080bb35af7_PLY_','2021-08-19 22:43:35','2019-12-03 18:31:22','28921ead-b55d-4e42-8788-a406b836c1a2.ply','2021-08-20 00:43:35','SYNCED','28921ead-b55d-4e42-8788-a406b836c1a2',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.42.1.1\",\"modelMatrix\":\"0.93583,0.348428,-0.0531019,0,-0.352451,0.925147,-0.140996,0,9.55107e-10,0.150665,0.988585,0,16.506,-13.8131,-24.8949,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'28a6ab04-ef44-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/28a6ab04-ef44-11e9-947d-226cec7cb58a.stl','STL','PATIENT_079ffac1-3b07-44e9-a6d8-c8c99dddfd30_ACT_50c1349d-a4cb-4edd-8ba6-178f8bb48c27_SESS_ea4078da-c040-409c-8d7d-e7483d2404e3_TOSC_51362368-129f-4221-8773-54a32f3fad13_STL_','2021-12-30 18:04:55','2019-10-15 12:34:31','28a6ab04-ef44-11e9-947d-226cec7cb58a.stl','2021-12-30 19:04:55','SYNCED','28a6ab04-ef44-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 58.1.1.1\",\"modelMatrix\":\"0.299796,-0.918185,0.258958,0,0.954003,0.28854,-0.0813775,0,-3.87226e-9,0.271443,0.962454,0,-11.4896,-32.7289,-21.0753,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'28a80d5f-ef44-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/28a80d5f-ef44-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_079ffac1-3b07-44e9-a6d8-c8c99dddfd30_ACT_50c1349d-a4cb-4edd-8ba6-178f8bb48c27_SESS_ea4078da-c040-409c-8d7d-e7483d2404e3_BOSC_660a23be-b1bd-400d-9484-5e52e858e0cd_PLY_','2021-12-30 18:04:56','2019-10-15 14:00:36','28a80d5f-ef44-11e9-947d-226cec7cb58a.ply','2021-12-30 19:04:56','SYNCED','28a80d5f-ef44-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 58.1.1.1\",\"modelMatrix\":\"-0.268089,0.957023,-0.110613,0,-0.963394,-0.266316,0.0307808,0,6.35806e-10,0.114816,0.993387,0,17.1852,22.3464,-24.8463,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'28a99572-ef44-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/28a99572-ef44-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_079ffac1-3b07-44e9-a6d8-c8c99dddfd30_ACT_50c1349d-a4cb-4edd-8ba6-178f8bb48c27_SESS_ea4078da-c040-409c-8d7d-e7483d2404e3_TOSC_51362368-129f-4221-8773-54a32f3fad13_PLY_','2021-12-30 18:04:56','2019-10-15 12:34:31','28a99572-ef44-11e9-947d-226cec7cb58a.ply','2021-12-30 19:04:56','SYNCED','28a99572-ef44-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 58.1.1.1\",\"modelMatrix\":\"0.299796,-0.918185,0.258958,0,0.954003,0.28854,-0.0813775,0,-3.87226e-9,0.271443,0.962454,0,-11.4896,-32.7289,-21.0753,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'28ab3ee6-ef44-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/28ab3ee6-ef44-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_079ffac1-3b07-44e9-a6d8-c8c99dddfd30_ACT_50c1349d-a4cb-4edd-8ba6-178f8bb48c27_SESS_ea4078da-c040-409c-8d7d-e7483d2404e3_TOSC_51362368-129f-4221-8773-54a32f3fad13_SNAPS_','2021-12-30 18:04:56','2019-10-15 12:34:31','28ab3ee6-ef44-11e9-947d-226cec7cb58a.png','2021-12-30 19:04:56','SYNCED','28ab3ee6-ef44-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 58.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'28acb4b3-ef44-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/28acb4b3-ef44-11e9-947d-226cec7cb58a.stl','STL','PATIENT_079ffac1-3b07-44e9-a6d8-c8c99dddfd30_ACT_50c1349d-a4cb-4edd-8ba6-178f8bb48c27_SESS_ea4078da-c040-409c-8d7d-e7483d2404e3_BOSC_660a23be-b1bd-400d-9484-5e52e858e0cd_STL_','2021-12-30 18:04:57','2019-10-15 14:00:36','28acb4b3-ef44-11e9-947d-226cec7cb58a.stl','2021-12-30 19:04:57','SYNCED','28acb4b3-ef44-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 58.1.1.1\",\"modelMatrix\":\"-0.268089,0.957023,-0.110613,0,-0.963394,-0.266316,0.0307808,0,6.35806e-10,0.114816,0.993387,0,17.1852,22.3464,-24.8463,1\",\"title\":\"MANDIBULE STL\"}'),(2,'28ae4f9f-ef44-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/28ae4f9f-ef44-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_079ffac1-3b07-44e9-a6d8-c8c99dddfd30_ACT_50c1349d-a4cb-4edd-8ba6-178f8bb48c27_SESS_ea4078da-c040-409c-8d7d-e7483d2404e3_BOSC_660a23be-b1bd-400d-9484-5e52e858e0cd_SNAPS_','2021-12-30 18:04:59','2019-10-15 14:00:36','28ae4f9f-ef44-11e9-947d-226cec7cb58a.png','2021-12-30 19:04:59','SYNCED','28ae4f9f-ef44-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 58.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'28b0bf2c-8108-49c4-8e0f-a02aa5c461d2','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/28b0bf2c-8108-49c4-8e0f-a02aa5c461d2.stl','STL','PATIENT_74a66f39-c9db-4c13-9dbf-7acfc0ea9391_ACT_bd746a5b-c1c4-42fa-88a3-345da35d47a0_SESS_a64913b8-d6d8-4c57-8ded-53d9f86e010a_BOSC_4ecfdebe-9d47-413f-8fb6-239846c869ba_STL_','2021-12-30 18:04:59','2019-10-25 10:56:47','28b0bf2c-8108-49c4-8e0f-a02aa5c461d2.stl','2021-12-30 19:04:59','SYNCED','28b0bf2c-8108-49c4-8e0f-a02aa5c461d2',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 196.1.1.1\",\"modelMatrix\":\"-0.977025,0.208759,-0.0429231,0,-0.213126,-0.957005,0.196771,0,4.8265e-9,0.201398,0.97951,0,-9.59418,13.8347,-22.1014,1\",\"title\":\"MANDIBULE STL\"}'),(2,'28b3f14d-5028-4ee2-92c8-c79342a445ac','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/28b3f14d-5028-4ee2-92c8-c79342a445ac.stl','STL','PATIENT_7749462f-5e3f-428f-8b79-660094a43a9c_ACT_0a1783af-3709-427a-bba6-43fb15137d30_SESS_d2b2fa27-1560-4e62-94f5-136eed4e784d_BOSC_f4db3134-e8be-4fea-baa7-2b342952834c_STL_','2022-03-04 13:40:31','2019-07-10 17:50:58','28b3f14d-5028-4ee2-92c8-c79342a445ac.stl','2022-03-04 14:40:31','SYNCED','28b3f14d-5028-4ee2-92c8-c79342a445ac',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 34.1.1.1\",\"modelMatrix\":\"0.43418,0.881581,-0.185211,0,-0.900826,0.424904,-0.089268,0,3.01741e-9,0.205601,0.978636,0,2.70453,-35.4702,-24.2156,1\",\"title\":\"MANDIBULE STL\"}'),(2,'28bdd155-83b9-4063-b83b-94ee2be91ce5','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/28bdd155-83b9-4063-b83b-94ee2be91ce5.stl','STL','PATIENT_1dfeecba-f15d-47a0-8441-39c0a59e8efb_ACT_01705e56-9cac-4986-bd22-f57409780d81_SESS_70490eb5-7fa8-4828-842f-ba025ffc949b_BOSC_1149e59a-13e5-4daa-9c7b-70471fadb011_STL_','2022-02-01 11:48:20','2019-07-22 12:22:06','28bdd155-83b9-4063-b83b-94ee2be91ce5.stl','2022-02-01 12:48:20','SYNCED','28bdd155-83b9-4063-b83b-94ee2be91ce5',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 106.1.1.1\",\"modelMatrix\":\"-0.999069,0.0429598,-0.00401995,0,-0.0431475,-0.994723,0.0930809,0,-2.69976e-10,0.0931676,0.99565,0,-15.6105,19.8871,-25.8159,1\",\"title\":\"MANDIBULE STL\"}'),(2,'28c9c4b2-c77a-464a-ad37-0809b9e50fdd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/28c9c4b2-c77a-464a-ad37-0809b9e50fdd.png','SNAPS','PATIENT_01271377-6891-420b-b3ae-775a63cf5f2d_ACT_fe30343f-9347-4c5e-a20b-076c70790bdf_SESS_9857f16b-5832-42f0-bbfe-edd7139c3c22_TOSC_f175a954-c663-4c00-98f9-e5afa8572821_SNAPS_','2021-02-11 15:56:35','2020-01-29 09:26:34','28c9c4b2-c77a-464a-ad37-0809b9e50fdd.png','2021-02-11 16:56:35','SYNCED','28c9c4b2-c77a-464a-ad37-0809b9e50fdd',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 96.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'28de1afc-e8e7-41b7-b2d4-67d9989bca17','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/28de1afc-e8e7-41b7-b2d4-67d9989bca17.ply','PLY','PATIENT_bf358e92-6aab-4f3a-8b60-a4fa6f96b213_ACT_1f5dd958-e7c7-4afe-bccb-d22ce6905397_SESS_747721f2-079d-4169-a3b9-7e066dcea4f1_BOSC_f45034fe-fb6b-4c58-95aa-5e2b8517e493_PLY_','2021-12-30 18:04:59','2019-10-15 11:38:58','28de1afc-e8e7-41b7-b2d4-67d9989bca17.ply','2021-12-30 19:04:59','SYNCED','28de1afc-e8e7-41b7-b2d4-67d9989bca17',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 9.1.1.1\",\"modelMatrix\":\"-0.990921,0.129532,-0.0360128,0,-0.134445,-0.95471,0.26543,0,-6.2485e-10,0.267862,0.963457,0,-14.5995,18.9412,-25.9523,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'28deea22-4534-4caf-a545-f0ce26a1587b','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/28deea22-4534-4caf-a545-f0ce26a1587b.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_7114231e-59fe-4dbe-b163-c55e35db80ad_SESS_ad45cfc7-2ac6-4333-b2e0-9c4ea5658917_BOSC_12ff568e-7240-498b-888c-4c5380d08afb_SNAPS_','2021-02-11 15:56:35','2020-02-03 09:55:26','28deea22-4534-4caf-a545-f0ce26a1587b.png','2021-02-11 16:56:35','SYNCED','28deea22-4534-4caf-a545-f0ce26a1587b',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'28f443b0-67c9-424a-985e-59cf5292a68a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/28f443b0-67c9-424a-985e-59cf5292a68a.png','SNAPS','PATIENT_fa356cc1-2a61-41a9-97f5-eee3850a926c_ACT_94c1619e-6096-4464-837b-4b14ca5da156_SESS_fd9c0fc4-1c81-4aed-a4e0-992153cc0fef_TOSC_f1822fc6-53a7-42bd-a3ba-3958d3797998_SNAPS_','2022-02-01 11:48:20','2019-07-15 09:39:01','28f443b0-67c9-424a-985e-59cf5292a68a.png','2022-02-01 12:48:20','SYNCED','28f443b0-67c9-424a-985e-59cf5292a68a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 59.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'290a642e-add7-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/290a642e-add7-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_0a978937-37d2-4044-a9bd-50cb59fb7012_ACT_a7064a8b-e27d-4d86-b80c-4e581e435c56_SESS_6248d1d4-8069-4bd6-b69e-9cf7dbdade6e_BOSC_d94fb6db-e138-4de7-a0c6-a20408452f39_SNAPS_','2022-02-01 11:48:21','2019-07-24 10:00:15','290a642e-add7-11e9-a33b-226cec7cb58a.png','2022-02-01 12:48:21','SYNCED','290a642e-add7-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 111.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'290affcb-add7-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/290affcb-add7-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_0a978937-37d2-4044-a9bd-50cb59fb7012_ACT_a7064a8b-e27d-4d86-b80c-4e581e435c56_SESS_6248d1d4-8069-4bd6-b69e-9cf7dbdade6e_TOSC_bb0fbda7-d59a-44b6-bc38-b165467dbab3_PLY_','2022-02-01 11:48:21','2019-07-24 09:55:56','290affcb-add7-11e9-a33b-226cec7cb58a.ply','2022-02-01 12:48:21','SYNCED','290affcb-add7-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 111.1.1.1\",\"modelMatrix\":\"0.556368,-0.781399,0.282613,0,0.830936,0.5232,-0.189229,0,-1.41637e-8,0.340114,0.940384,0,-6.09525,-35.5209,-19.8043,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'290b996b-add7-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/290b996b-add7-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_0a978937-37d2-4044-a9bd-50cb59fb7012_ACT_a7064a8b-e27d-4d86-b80c-4e581e435c56_SESS_6248d1d4-8069-4bd6-b69e-9cf7dbdade6e_BOSC_d94fb6db-e138-4de7-a0c6-a20408452f39_PLY_','2022-02-01 11:48:21','2019-07-24 10:00:15','290b996b-add7-11e9-a33b-226cec7cb58a.ply','2022-02-01 12:48:21','SYNCED','290b996b-add7-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 111.1.1.1\",\"modelMatrix\":\"-0.972606,-0.226908,0.0504973,0,0.232459,-0.949381,0.21128,0,-4.23124e-10,0.217231,0.97612,0,-22.1536,14.6636,-33.8056,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'290c27f2-add7-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/290c27f2-add7-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_0a978937-37d2-4044-a9bd-50cb59fb7012_ACT_a7064a8b-e27d-4d86-b80c-4e581e435c56_SESS_6248d1d4-8069-4bd6-b69e-9cf7dbdade6e_BOSC_d94fb6db-e138-4de7-a0c6-a20408452f39_STL_','2022-02-01 11:48:21','2019-07-24 10:00:15','290c27f2-add7-11e9-a33b-226cec7cb58a.stl','2022-02-01 12:48:21','SYNCED','290c27f2-add7-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 111.1.1.1\",\"modelMatrix\":\"-0.972606,-0.226908,0.0504973,0,0.232459,-0.949381,0.21128,0,-4.23124e-10,0.217231,0.97612,0,-22.1536,14.6636,-33.8056,1\",\"title\":\"MANDIBULE STL\"}'),(2,'290cbf28-add7-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/290cbf28-add7-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_0a978937-37d2-4044-a9bd-50cb59fb7012_ACT_a7064a8b-e27d-4d86-b80c-4e581e435c56_SESS_6248d1d4-8069-4bd6-b69e-9cf7dbdade6e_TOSC_bb0fbda7-d59a-44b6-bc38-b165467dbab3_SNAPS_','2022-02-01 11:48:21','2019-07-24 09:55:56','290cbf28-add7-11e9-a33b-226cec7cb58a.png','2022-02-01 12:48:21','SYNCED','290cbf28-add7-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 111.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'290d3376-611d-4844-a054-84e9681cc5a7','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/290d3376-611d-4844-a054-84e9681cc5a7.png','SNAPS','PATIENT_274a8e70-1f17-4173-8827-ba197171f209_ACT_f920b34b-3908-470d-b100-706ab4c53afd_SESS_528bb94d-cf10-47b4-a8fd-9efc9e8eb671_TOSC_c9362237-03ee-4147-9772-06bb3226331f_SNAPS_','2021-02-11 15:56:36','2020-06-17 11:57:31','290d3376-611d-4844-a054-84e9681cc5a7.png','2021-02-11 16:56:36','SYNCED','290d3376-611d-4844-a054-84e9681cc5a7',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.52.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'290d596f-add7-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/290d596f-add7-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_0a978937-37d2-4044-a9bd-50cb59fb7012_ACT_a7064a8b-e27d-4d86-b80c-4e581e435c56_SESS_6248d1d4-8069-4bd6-b69e-9cf7dbdade6e_TOSC_bb0fbda7-d59a-44b6-bc38-b165467dbab3_STL_','2022-02-01 11:48:21','2019-07-24 09:55:56','290d596f-add7-11e9-a33b-226cec7cb58a.stl','2022-02-01 12:48:21','SYNCED','290d596f-add7-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 111.1.1.1\",\"modelMatrix\":\"0.556368,-0.781399,0.282613,0,0.830936,0.5232,-0.189229,0,-1.41637e-8,0.340114,0.940384,0,-6.09525,-35.5209,-19.8043,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'29160d37-fd6c-45a0-a83d-1230bf6f702f','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/29160d37-fd6c-45a0-a83d-1230bf6f702f.ply','PLY','PATIENT_be48faa5-408d-4557-9d5f-60c67821aff4_ACT_9f77cb0d-bdf4-4451-a561-df188dcfd90b_SESS_ae5d102d-69f4-4a1f-ad3d-ce4a77600f7b_TOSC_aed6d770-14a0-4a08-b1dc-657cd2564cc8_PLY_','2021-02-11 15:56:37','2020-02-05 11:31:58','29160d37-fd6c-45a0-a83d-1230bf6f702f.ply','2021-02-11 16:56:37','SYNCED','29160d37-fd6c-45a0-a83d-1230bf6f702f',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"modelMatrix\":\"0.8167,-0.520409,0.24935,0,0.577063,0.73652,-0.352898,0,2.42888e-8,0.432103,0.901824,0,4.88628,-30.6685,-17.4785,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'292160fa-fe1e-4f0b-84fe-a2dd88f6bddd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/292160fa-fe1e-4f0b-84fe-a2dd88f6bddd.png','SNAPS','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_ecf9367f-79e2-4c37-94be-6f616e52afdc_SESS_4e4013b7-db7c-4110-93a4-d2585e4f55a4_TOSC_1aa4dd14-d236-4570-9925-f9bde57c245c_SNAPS_','2021-02-11 15:56:37','2020-01-21 14:17:28','292160fa-fe1e-4f0b-84fe-a2dd88f6bddd.png','2021-02-11 16:56:37','SYNCED','292160fa-fe1e-4f0b-84fe-a2dd88f6bddd',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'292a747d-97e1-4cbd-a134-39ea2469f41a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/292a747d-97e1-4cbd-a134-39ea2469f41a.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_9e237a53-4c20-4704-aad8-66e7d28d880b_SESS_85bc7802-1247-4b5a-a69b-2ac3c413cdaf_TOSC_adb8dce1-0fa1-47a2-b548-20b9d8171e9e_SNAPS_','2021-02-11 15:56:37','2020-06-18 13:09:49','292a747d-97e1-4cbd-a134-39ea2469f41a.png','2021-02-11 16:56:37','SYNCED','292a747d-97e1-4cbd-a134-39ea2469f41a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.64.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'29391a95-dac3-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/29391a95-dac3-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_60337f02-8dc5-49ce-b0bb-1548b081473d_ACT_21efaafa-313e-4152-b6df-df2a1f68fd61_SESS_4bc32c9d-46a9-4dcc-9d12-f6e805212837_TOSC_9bf554d7-2ad7-46ce-8daf-0e2cddda153d_PLY_','2022-02-01 11:48:22','2019-09-19 11:43:22','29391a95-dac3-11e9-947d-226cec7cb58a.ply','2022-02-01 12:48:22','SYNCED','29391a95-dac3-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 154.1.1.1\",\"modelMatrix\":\"0.613971,-0.717439,0.329121,0,0.789328,0.558053,-0.256004,0,8.15742e-10,0.416963,0.908923,0,-4.20645,-38.7581,-20.2512,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'293aa2a5-dac3-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/293aa2a5-dac3-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_60337f02-8dc5-49ce-b0bb-1548b081473d_ACT_21efaafa-313e-4152-b6df-df2a1f68fd61_SESS_4bc32c9d-46a9-4dcc-9d12-f6e805212837_TOSC_9bf554d7-2ad7-46ce-8daf-0e2cddda153d_SNAPS_','2022-02-01 11:48:22','2019-09-19 11:43:22','293aa2a5-dac3-11e9-947d-226cec7cb58a.png','2022-02-01 12:48:22','SYNCED','293aa2a5-dac3-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 154.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'293c1be1-dac3-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/293c1be1-dac3-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_60337f02-8dc5-49ce-b0bb-1548b081473d_ACT_21efaafa-313e-4152-b6df-df2a1f68fd61_SESS_4bc32c9d-46a9-4dcc-9d12-f6e805212837_BOSC_deefc6cd-4b7e-485b-9884-8662df23a003_PLY_','2022-02-01 11:48:22','2019-09-19 11:49:40','293c1be1-dac3-11e9-947d-226cec7cb58a.ply','2022-02-01 12:48:22','SYNCED','293c1be1-dac3-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 154.1.1.1\",\"modelMatrix\":\"-0.993797,0.107129,-0.029832,0,-0.111205,-0.957371,0.266597,0,8.94445e-10,0.268261,0.963346,0,-22.911,15.1066,-22.6323,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'293da56a-dac3-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/293da56a-dac3-11e9-947d-226cec7cb58a.stl','STL','PATIENT_60337f02-8dc5-49ce-b0bb-1548b081473d_ACT_21efaafa-313e-4152-b6df-df2a1f68fd61_SESS_4bc32c9d-46a9-4dcc-9d12-f6e805212837_BOSC_deefc6cd-4b7e-485b-9884-8662df23a003_STL_','2022-02-01 11:48:22','2019-09-19 11:49:40','293da56a-dac3-11e9-947d-226cec7cb58a.stl','2022-02-01 12:48:22','SYNCED','293da56a-dac3-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 154.1.1.1\",\"modelMatrix\":\"-0.993797,0.107129,-0.029832,0,-0.111205,-0.957371,0.266597,0,8.94445e-10,0.268261,0.963346,0,-22.911,15.1066,-22.6323,1\",\"title\":\"MANDIBULE STL\"}'),(2,'293f0ffd-dac3-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/293f0ffd-dac3-11e9-947d-226cec7cb58a.stl','STL','PATIENT_60337f02-8dc5-49ce-b0bb-1548b081473d_ACT_21efaafa-313e-4152-b6df-df2a1f68fd61_SESS_4bc32c9d-46a9-4dcc-9d12-f6e805212837_TOSC_9bf554d7-2ad7-46ce-8daf-0e2cddda153d_STL_','2022-02-01 11:48:22','2019-09-19 11:43:22','293f0ffd-dac3-11e9-947d-226cec7cb58a.stl','2022-02-01 12:48:22','SYNCED','293f0ffd-dac3-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 154.1.1.1\",\"modelMatrix\":\"0.613971,-0.717439,0.329121,0,0.789328,0.558053,-0.256004,0,8.15742e-10,0.416963,0.908923,0,-4.20645,-38.7581,-20.2512,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'2940686e-dac3-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2940686e-dac3-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_60337f02-8dc5-49ce-b0bb-1548b081473d_ACT_21efaafa-313e-4152-b6df-df2a1f68fd61_SESS_4bc32c9d-46a9-4dcc-9d12-f6e805212837_BOSC_deefc6cd-4b7e-485b-9884-8662df23a003_SNAPS_','2022-02-01 11:48:23','2019-09-19 11:49:40','2940686e-dac3-11e9-947d-226cec7cb58a.png','2022-02-01 12:48:23','SYNCED','2940686e-dac3-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 154.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'2940a0eb-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2940a0eb-c807-11e9-8df1-226cec7cb58a.stl','STL','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_BOSC_4130b951-2ea4-4c1e-9e71-e69c342e36b1_STL_','2022-02-01 11:48:23','2019-08-26 14:41:36','2940a0eb-c807-11e9-8df1-226cec7cb58a.stl','2022-02-01 12:48:23','SYNCED','2940a0eb-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 129.12.1.1\",\"modelMatrix\":\"-0.86495,0.497159,-0.0685085,0,-0.501857,-0.856853,0.118074,0,-5.63121e-9,0.13651,0.990639,0,-5.41015,22.1831,-19.7439,1\",\"title\":\"MANDIBULE STL\"}'),(2,'294189dc-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/294189dc-c807-11e9-8df1-226cec7cb58a.ply','PLY','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_BOSC_4130b951-2ea4-4c1e-9e71-e69c342e36b1_PLY_','2022-02-01 11:48:23','2019-08-26 14:41:36','294189dc-c807-11e9-8df1-226cec7cb58a.ply','2022-02-01 12:48:23','SYNCED','294189dc-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 129.12.1.1\",\"modelMatrix\":\"-0.86495,0.497159,-0.0685085,0,-0.501857,-0.856853,0.118074,0,-5.63121e-9,0.13651,0.990639,0,-5.41015,22.1831,-19.7439,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'29434ace-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/29434ace-c807-11e9-8df1-226cec7cb58a.png','SNAPS','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_BOSC_4130b951-2ea4-4c1e-9e71-e69c342e36b1_SNAPS_','2022-02-01 11:48:23','2019-08-26 14:41:36','29434ace-c807-11e9-8df1-226cec7cb58a.png','2022-02-01 12:48:23','SYNCED','29434ace-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 129.12.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'294c99f7-7360-4bf2-93bc-e6b2fe375040','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/294c99f7-7360-4bf2-93bc-e6b2fe375040.stl','STL','PATIENT_4ec057eb-d132-43fb-96fb-11348abd205b_ACT_bec7cb5f-4dd0-4601-aa64-0a558c6e8b78_SESS_b153a28c-3493-496f-bb70-e96ca7cf7e78_BOSC_1af0b286-7f10-4d99-ab95-2a03e7b2174d_STL_','2021-12-30 18:05:03','2019-10-02 15:28:57','294c99f7-7360-4bf2-93bc-e6b2fe375040.stl','2021-12-30 19:05:03','SYNCED','294c99f7-7360-4bf2-93bc-e6b2fe375040',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 174.1.1.1\",\"modelMatrix\":\"-0.927494,-0.37103,0.0457295,0,0.373838,-0.920529,0.113455,0,-1.18688e-9,0.122325,0.99249,0,-21.687,7.85265,-24.8367,1\",\"title\":\"MANDIBULE STL\"}'),(2,'2960ef5b-bc86-40a2-92b3-517d2f3613e4','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2960ef5b-bc86-40a2-92b3-517d2f3613e4.png','SNAPS','PATIENT_9bdadecd-3730-4989-a33e-fe0feac57f3a_ACT_eb210610-e663-4719-881d-f565abd3fa10_SESS_e338a54c-fc97-4f7d-866b-5b6bed0fc882_TOSC_efb04151-ed3f-42d7-a182-e6ae4abd1e85_SNAPS_','2021-02-11 15:56:38','2020-05-27 13:40:58','2960ef5b-bc86-40a2-92b3-517d2f3613e4.png','2021-02-11 16:56:38','SYNCED','2960ef5b-bc86-40a2-92b3-517d2f3613e4',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 49.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'296725da-8e10-4738-818d-3b52646d2e86','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/296725da-8e10-4738-818d-3b52646d2e86.ply','PLY','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_8c7a1e74-25c2-432c-9c36-1bc4fc678ec1_SESS_692c8ffd-5299-4eda-8e48-a424d5caa737_BOSC_024b32ef-f9d3-4c16-a14e-a6d70d789141_PLY_','2021-02-11 15:56:38','2020-01-20 16:22:09','296725da-8e10-4738-818d-3b52646d2e86.ply','2021-02-11 16:56:38','SYNCED','296725da-8e10-4738-818d-3b52646d2e86',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.1.1.1.2\",\"modelMatrix\":\"-0.985694,0.167542,-0.0183771,0,-0.168547,-0.979817,0.107473,0,9.55354e-10,0.109033,0.994038,0,-14.0881,22.0623,-15.3475,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'299bda01-11c9-45b2-a125-28eb71028365','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/299bda01-11c9-45b2-a125-28eb71028365.ply','PLY','PATIENT_3a71900a-c0b3-44f1-97fe-511f6da059ed_ACT_998354df-dabb-40ad-aef4-81fcf373fb99_SESS_afdc2ce6-731d-4d67-8fd1-e4c82a8cb2e2_BOSC_89b0fe77-e51c-42b3-b702-30f7b2ffa15f_PLY_','2022-02-01 11:48:23','2019-07-15 10:55:14','299bda01-11c9-45b2-a125-28eb71028365.ply','2022-02-01 12:48:23','SYNCED','299bda01-11c9-45b2-a125-28eb71028365',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 60.1.1.1\",\"modelMatrix\":\"-0.78896,0.596737,-0.146446,0,-0.614444,-0.766224,0.18804,0,-1.64394e-9,0.238339,0.971182,0,-6.1502,22.0711,-20.7422,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'29a82c10-f588-42c8-a203-7948055f49e3','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/29a82c10-f588-42c8-a203-7948055f49e3.stl','STL','PATIENT_3e343923-9a7e-43a7-9f72-bb44234cdd4a_ACT_1970bd18-092b-45d7-886c-a1515b8f73a4_SESS_e26064f9-cf7e-439b-b8f8-66ca3221f4ec_BOSC_a96af336-1ea5-4ff8-98da-847df044620b_STL_','2022-02-01 11:48:24','2019-08-07 10:21:45','29a82c10-f588-42c8-a203-7948055f49e3.stl','2022-02-01 12:48:24','SYNCED','29a82c10-f588-42c8-a203-7948055f49e3',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 127.1.1.1\",\"modelMatrix\":\"-0.968053,0.250405,-0.0130709,0,-0.250746,-0.966737,0.0504627,0,5.45279e-10,0.0521281,0.99864,0,-4.7703,28.9894,-32.5066,1\",\"title\":\"MANDIBULE STL\"}'),(2,'29bcab5e-b7e5-4494-b3e6-91b9ec013ac4','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/29bcab5e-b7e5-4494-b3e6-91b9ec013ac4.stl','STL','PATIENT_a60114e8-08c6-4aff-afd6-b40b6a9e413d_ACT_0745751f-61fa-4f5e-b2e0-e274e9454037_SESS_6eaabd44-fd04-4a05-b859-3d0841e6a8eb_TOSC_d4c22156-5a6e-477a-abfa-6edd4b2b9b94_STL_','2021-08-19 22:43:56','2019-12-02 16:40:52','29bcab5e-b7e5-4494-b3e6-91b9ec013ac4.stl','2021-08-20 00:43:56','SYNCED','29bcab5e-b7e5-4494-b3e6-91b9ec013ac4',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 220.2.1.1\",\"modelMatrix\":\"0.388242,-0.896271,0.214397,0,0.921558,0.377589,-0.0903232,0,1.37095e-9,0.232647,0.972561,0,-9.75674,-30.6107,-14.6881,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'29cc6d46-ef56-473c-a45f-14ecf2cf47da','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/29cc6d46-ef56-473c-a45f-14ecf2cf47da.stl','STL','PATIENT_9f8b6616-9553-4db4-a1d1-9f44a80edd64_ACT_88375f7a-be18-4d17-9220-3f53a51e4b7f_SESS_8d6cac80-7337-4053-ad7e-d9635d0b640f_BOSC_f88e22ed-bf26-4f72-b49d-ceb496af29b9_STL_','2021-12-30 18:05:04','2019-10-25 11:03:17','29cc6d46-ef56-473c-a45f-14ecf2cf47da.stl','2021-12-30 19:05:04','SYNCED','29cc6d46-ef56-473c-a45f-14ecf2cf47da',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 194.1.1.1\",\"modelMatrix\":\"-0.998063,0.0600801,-0.0161344,0,-0.0622088,-0.963911,0.258856,0,-7.66387e-10,0.259358,0.965781,0,-9.23064,14.7054,-25.952,1\",\"title\":\"MANDIBULE STL\"}'),(2,'29cf924d-2b93-4d96-94f6-e14f0af8b028','','STL','PATIENT_2df9c598-3519-4719-a1e4-f4e150a235a9_ACT_ceb083f7-ec86-4eba-9690-123a703c3abc_SESS_ea3ce5df-3ae9-45ef-896c-5661af24bc30_TOSC_4114ee21-40cc-4ffd-84df-2b8954d95607_STL_','2021-12-30 18:05:04','2019-11-21 15:36:46','','2021-12-30 19:05:04','SYNCED','29cf924d-2b93-4d96-94f6-e14f0af8b028',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 207.3.1.1\",\"modelMatrix\":\"0.666884,-0.698689,0.259034,0,0.745161,0.625294,-0.231823,0,-9.79153e-9,0.347622,0.937635,0,6.05261,-38.4706,-23.7557,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'29d335b0-2e98-419c-b8cf-bbfa0b5f96cf','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/29d335b0-2e98-419c-b8cf-bbfa0b5f96cf.ply','PLY','PATIENT_ccd3e8fe-0427-46ac-9a78-4982bf0a05fe_ACT_ee7a5012-1ec5-43b8-82bd-f42cb859f757_SESS_0b92af6d-d56a-4d56-941a-44824081e629_TOSC_e4fa63d0-f2e4-45d5-9661-4e5df10c0ab7_PLY_','2021-02-11 15:56:40','2019-12-18 13:36:27','29d335b0-2e98-419c-b8cf-bbfa0b5f96cf.ply','2021-02-11 16:56:40','SYNCED','29d335b0-2e98-419c-b8cf-bbfa0b5f96cf',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 20.1.268.1.1.1\",\"modelMatrix\":\"0.59362,-0.760398,0.263457,0,0.804745,0.560908,-0.194339,0,1.78376e-8,0.327379,0.944893,0,-4.32418,-34.1677,-21.9618,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'29dcf616-dc04-4ee3-999e-e4c0c4050567','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/29dcf616-dc04-4ee3-999e-e4c0c4050567.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_4256090f-2b3b-416c-b6d3-1c46b5678d4a_SESS_d7b9615e-34a4-446f-8b43-b280815bacec_TOSC_3d8d7864-898c-452c-b9be-fff0788aecea_SNAPS_','2021-02-11 15:56:40','2020-06-17 15:11:39','29dcf616-dc04-4ee3-999e-e4c0c4050567.png','2021-02-11 16:56:40','SYNCED','29dcf616-dc04-4ee3-999e-e4c0c4050567',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.54.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'29f20898-1390-438a-ba9e-1c147450cac0','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/29f20898-1390-438a-ba9e-1c147450cac0.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_d49854df-257e-4070-b2e6-624cd798c324_PLY_','2021-02-11 15:56:40','2020-01-24 14:09:56','29f20898-1390-438a-ba9e-1c147450cac0.ply','2021-02-11 16:56:40','SYNCED','29f20898-1390-438a-ba9e-1c147450cac0',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.14\",\"modelMatrix\":\"-0.877455,0.455405,-0.150594,0,-0.479659,-0.833087,0.275487,0,-7.69801e-9,0.313962,0.949436,0,-12.6135,20.4154,-19.4439,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'29f7104b-3066-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/29f7104b-3066-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_1a8047ce-7b95-446a-b5b9-71639b6c4b05_SESS_af562828-6543-4aac-b52c-3a40f5e106a6_BOSC_dcb397a5-f96e-4836-a97d-43368c9cd1ad_PLY_','2021-02-11 15:56:40','2020-01-06 10:20:51','29f7104b-3066-11ea-947d-226cec7cb58a.ply','2021-02-11 16:56:40','SYNCED','29f7104b-3066-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"modelMatrix\":\"-0.74176,0.664523,-0.090562,0,-0.670666,-0.734966,0.100162,0,-3.8414e-9,0.135033,0.990841,0,-1.61158,25.0403,-14.5308,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'29fa66dd-3066-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/29fa66dd-3066-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_e10dd73f-e0a1-4244-93ef-41a0fe1b27fd_ACT_1a8047ce-7b95-446a-b5b9-71639b6c4b05_SESS_af562828-6543-4aac-b52c-3a40f5e106a6_TOSC_ae1e6238-0a21-4e6b-86b3-6cf6e2b54501_PLY_','2021-02-11 15:56:41','2020-01-06 10:17:44','29fa66dd-3066-11ea-947d-226cec7cb58a.ply','2021-02-11 16:56:41','SYNCED','29fa66dd-3066-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"modelMatrix\":\"0.716462,-0.652414,0.247058,0,0.697626,0.67003,-0.253729,0,1.5136e-8,0.354141,0.935192,0,4.99357,-31.5165,-18.1489,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'29fc1b04-3066-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/29fc1b04-3066-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_e10dd73f-e0a1-4244-93ef-41a0fe1b27fd_ACT_1a8047ce-7b95-446a-b5b9-71639b6c4b05_SESS_af562828-6543-4aac-b52c-3a40f5e106a6_TOSC_ae1e6238-0a21-4e6b-86b3-6cf6e2b54501_SNAPS_','2021-02-11 15:56:41','2020-01-06 10:17:44','29fc1b04-3066-11ea-947d-226cec7cb58a.png','2021-02-11 16:56:41','SYNCED','29fc1b04-3066-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'29fca39b-910e-4724-a617-cb76b168e8c8','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/29fca39b-910e-4724-a617-cb76b168e8c8.ply','PLY','PATIENT_df5cd3e3-f012-41db-937e-54f6102a7215_ACT_de0c93fe-463b-44c5-a3d4-058f2138bc94_SESS_0e0aba24-d37b-41e0-a159-d57412935ff8_TOSC_ebde19be-35b8-4580-b046-6565768b8e01_PLY_','2021-02-16 16:40:53','2019-12-12 14:05:15','29fca39b-910e-4724-a617-cb76b168e8c8.ply','2021-02-16 17:40:53','SYNCED','29fca39b-910e-4724-a617-cb76b168e8c8',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 232.12.1.1\",\"modelMatrix\":\"0.738451,-0.634194,0.229101,0,0.674307,0.694523,-0.250895,0,7.07945e-9,0.339758,0.940513,0,1.4063,-36.8522,-20.7638,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'29fd933e-3066-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/29fd933e-3066-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_1a8047ce-7b95-446a-b5b9-71639b6c4b05_SESS_af562828-6543-4aac-b52c-3a40f5e106a6_BOSC_dcb397a5-f96e-4836-a97d-43368c9cd1ad_SNAPS_','2021-02-11 15:56:41','2020-01-06 10:20:51','29fd933e-3066-11ea-947d-226cec7cb58a.png','2021-02-11 16:56:41','SYNCED','29fd933e-3066-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'2a07e193-20d7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_5cde9543-ba84-400d-ae2b-8c834d912266/2a07e193-20d7-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_9e19c6c5-27e3-41f8-90a7-f84d73b731bb_ACT_545d13eb-7a31-42bf-90ab-cb4233458aa7_SESS_c6e68ab1-08f5-4291-86d3-ad9cd6495071_BOSC_6617526b-52c2-4521-9e47-86c8cc69d311_SNAPS_','2021-02-11 15:56:41','2019-12-16 09:18:24','2a07e193-20d7-11ea-947d-226cec7cb58a.png','2021-02-11 16:56:41','SYNCED','2a07e193-20d7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.116.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'2a0971ea-20d7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_5cde9543-ba84-400d-ae2b-8c834d912266/2a0971ea-20d7-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_9e19c6c5-27e3-41f8-90a7-f84d73b731bb_ACT_545d13eb-7a31-42bf-90ab-cb4233458aa7_SESS_c6e68ab1-08f5-4291-86d3-ad9cd6495071_TOSC_83873afd-72ee-4b45-bc18-37867142560f_SNAPS_','2021-02-11 15:56:41','2019-12-16 09:24:25','2a0971ea-20d7-11ea-947d-226cec7cb58a.png','2021-02-11 16:56:41','SYNCED','2a0971ea-20d7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.116.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'2a0c1f7d-cc84-4196-92a1-43ec839e874e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2a0c1f7d-cc84-4196-92a1-43ec839e874e.stl','STL','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_BOSC_40a5a78d-6553-4ef6-9ab0-a225a831beee_STL_','2021-12-30 18:05:05','2019-11-14 12:01:07','2a0c1f7d-cc84-4196-92a1-43ec839e874e.stl','2021-12-30 19:05:05','SYNCED','2a0c1f7d-cc84-4196-92a1-43ec839e874e',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 202.1.1.1\",\"modelMatrix\":\"-0.796495,0.59019,-0.13142,0,-0.604645,-0.777454,0.173119,0,4.75618e-9,0.217351,0.976093,0,-4.42386,24.527,-16.4687,1\",\"title\":\"MANDIBULE STL\"}'),(2,'2a0c2388-20d7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_5cde9543-ba84-400d-ae2b-8c834d912266/2a0c2388-20d7-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_9e19c6c5-27e3-41f8-90a7-f84d73b731bb_ACT_545d13eb-7a31-42bf-90ab-cb4233458aa7_SESS_c6e68ab1-08f5-4291-86d3-ad9cd6495071_LESC_c5db4d76-26ba-47a0-aeab-5bd7fb2706e6_PLY_','2021-02-11 15:56:41','2019-12-16 09:26:30','2a0c2388-20d7-11ea-947d-226cec7cb58a.ply','2021-02-11 16:56:41','SYNCED','2a0c2388-20d7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MORDU_POSTERIEUR_GAUCHE 1.116.1.1.1\",\"modelMatrix\":\"-0.991988,-0.0229869,0.130238,0,0.051951,-0.953466,0.290149,0,0.115529,0.30078,0.948105,0,13.2786,-4.74492,-20.5104,1\",\"title\":\"MORDU_POSTERIEUR_GAUCHE PLY\"}'),(2,'2a0da19c-20d7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_5cde9543-ba84-400d-ae2b-8c834d912266/2a0da19c-20d7-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_9e19c6c5-27e3-41f8-90a7-f84d73b731bb_ACT_545d13eb-7a31-42bf-90ab-cb4233458aa7_SESS_c6e68ab1-08f5-4291-86d3-ad9cd6495071_OCC_c6e68ab1-08f5-4291-86d3-ad9migraoccl_SNAPO__SNAPS_','2021-02-11 15:56:42','2019-12-16 09:46:47','2a0da19c-20d7-11ea-947d-226cec7cb58a.png','2021-02-11 16:56:42','SYNCED','2a0da19c-20d7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule Occlusion 1.116.1.1\",\"title\":\"Snapshot SNAPSHOT\"}'),(2,'2a0f28c0-20d7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_5cde9543-ba84-400d-ae2b-8c834d912266/2a0f28c0-20d7-11ea-947d-226cec7cb58a.pdf','PDF','PATIENT_9e19c6c5-27e3-41f8-90a7-f84d73b731bb_ACT_545d13eb-7a31-42bf-90ab-cb4233458aa7_PROST_ef66b7fb-d0b5-494e-8b79-459f1c55b4e3_PDF_','2020-01-20 11:41:00','2019-12-17 15:11:56','2a0f28c0-20d7-11ea-947d-226cec7cb58a.pdf','2020-01-20 12:41:00','SYNCED','2a0f28c0-20d7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"SMILERS 1.116.1.4 SMILERS\",\"title\":\"Smilers PDF\"}'),(2,'2a112f8c-20d7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_5cde9543-ba84-400d-ae2b-8c834d912266/2a112f8c-20d7-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_9e19c6c5-27e3-41f8-90a7-f84d73b731bb_ACT_545d13eb-7a31-42bf-90ab-cb4233458aa7_SESS_c6e68ab1-08f5-4291-86d3-ad9cd6495071_OCC_c6e68ab1-08f5-4291-86d3-ad9migraoccl_TOPLY__PLY_','2021-02-11 15:56:42','2019-12-16 09:46:47','2a112f8c-20d7-11ea-947d-226cec7cb58a.ply','2021-02-11 16:56:42','SYNCED','2a112f8c-20d7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire Occlusion 1.116.1.1\",\"title\":\"Maxillaire Occlusion PLY\"}'),(2,'2a137ae2-20d7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_5cde9543-ba84-400d-ae2b-8c834d912266/2a137ae2-20d7-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_9e19c6c5-27e3-41f8-90a7-f84d73b731bb_ACT_545d13eb-7a31-42bf-90ab-cb4233458aa7_SESS_c6e68ab1-08f5-4291-86d3-ad9cd6495071_TOSC_83873afd-72ee-4b45-bc18-37867142560f_PLY_','2021-02-11 15:56:42','2019-12-16 09:24:25','2a137ae2-20d7-11ea-947d-226cec7cb58a.ply','2021-02-11 16:56:42','SYNCED','2a137ae2-20d7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.116.1.1.1\",\"modelMatrix\":\"0.797205,0.535992,-0.277807,0,-0.603708,0.707785,-0.366848,0,2.04021e-8,0.460167,0.887832,0,-13.9508,-19.8534,-12.8571,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'2a15eac6-20d7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_5cde9543-ba84-400d-ae2b-8c834d912266/2a15eac6-20d7-11ea-947d-226cec7cb58a.m','MATRX','PATIENT_9e19c6c5-27e3-41f8-90a7-f84d73b731bb_ACT_545d13eb-7a31-42bf-90ab-cb4233458aa7_SESS_c6e68ab1-08f5-4291-86d3-ad9cd6495071_OCC_c6e68ab1-08f5-4291-86d3-ad9migraoccl_TOMA__MATRX_','2021-02-11 15:56:42','2019-12-16 09:46:47','2a15eac6-20d7-11ea-947d-226cec7cb58a.m','2021-02-11 16:56:42','SYNCED','2a15eac6-20d7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire Occlusion 1.116.1.1\",\"title\":\"Matrice Transfo. Maxillaire MATRIX\"}'),(2,'2a176d6b-20d7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_5cde9543-ba84-400d-ae2b-8c834d912266/2a176d6b-20d7-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_9e19c6c5-27e3-41f8-90a7-f84d73b731bb_ACT_545d13eb-7a31-42bf-90ab-cb4233458aa7_SESS_c6e68ab1-08f5-4291-86d3-ad9cd6495071_BOSC_6617526b-52c2-4521-9e47-86c8cc69d311_PLY_','2021-02-11 15:56:42','2019-12-16 09:18:24','2a176d6b-20d7-11ea-947d-226cec7cb58a.ply','2021-02-11 16:56:42','SYNCED','2a176d6b-20d7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.116.1.1.1\",\"modelMatrix\":\"-0.988318,0.111422,-0.103986,0,-0.152408,-0.72254,0.67432,0,-9.38115e-10,0.682291,0.731081,0,10.7463,-15.7162,-13.5125,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'2a191376-20d7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_5cde9543-ba84-400d-ae2b-8c834d912266/2a191376-20d7-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_9e19c6c5-27e3-41f8-90a7-f84d73b731bb_ACT_545d13eb-7a31-42bf-90ab-cb4233458aa7_SESS_c6e68ab1-08f5-4291-86d3-ad9cd6495071_OCC_c6e68ab1-08f5-4291-86d3-ad9migraoccl_BOPLY__PLY_','2021-02-11 15:56:42','2019-12-16 09:46:47','2a191376-20d7-11ea-947d-226cec7cb58a.ply','2021-02-11 16:56:42','SYNCED','2a191376-20d7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule Occlusion 1.116.1.1\",\"title\":\"Mandibule Occlusion PLY\"}'),(2,'2a1bd1c3-20d7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_5cde9543-ba84-400d-ae2b-8c834d912266/2a1bd1c3-20d7-11ea-947d-226cec7cb58a.json','JSON','PATIENT_9e19c6c5-27e3-41f8-90a7-f84d73b731bb_ACT_545d13eb-7a31-42bf-90ab-cb4233458aa7_PROST_ef66b7fb-d0b5-494e-8b79-459f1c55b4e3_JSON_','2020-01-20 11:41:01','2019-12-17 15:11:56','2a1bd1c3-20d7-11ea-947d-226cec7cb58a.json','2020-01-20 12:41:01','SYNCED','2a1bd1c3-20d7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"SMILERS 1.116.1.4 SMILERS\",\"title\":\"Smilers JSON\"}'),(2,'2a1d1f8b-20d7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_5cde9543-ba84-400d-ae2b-8c834d912266/2a1d1f8b-20d7-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_9e19c6c5-27e3-41f8-90a7-f84d73b731bb_ACT_545d13eb-7a31-42bf-90ab-cb4233458aa7_SESS_c6e68ab1-08f5-4291-86d3-ad9cd6495071_LESC_c5db4d76-26ba-47a0-aeab-5bd7fb2706e6_SNAPS_','2021-02-11 15:56:42','2019-12-16 09:26:30','2a1d1f8b-20d7-11ea-947d-226cec7cb58a.png','2021-02-11 16:56:42','SYNCED','2a1d1f8b-20d7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MORDU_POSTERIEUR_GAUCHE 1.116.1.1.1\",\"title\":\"MORDU_POSTERIEUR_GAUCHE SNAPSHOT\"}'),(2,'2a20ebc7-20d7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_5cde9543-ba84-400d-ae2b-8c834d912266/2a20ebc7-20d7-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_9e19c6c5-27e3-41f8-90a7-f84d73b731bb_ACT_545d13eb-7a31-42bf-90ab-cb4233458aa7_SESS_c6e68ab1-08f5-4291-86d3-ad9cd6495071_TOSC_e9d8f1be-b116-4ece-ab8b-b2b34ce33f95_PLY_','2021-02-11 15:56:43','2019-12-16 09:46:05','2a20ebc7-20d7-11ea-947d-226cec7cb58a.ply','2021-02-11 16:56:43','SYNCED','2a20ebc7-20d7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.116.1.1.2\",\"modelMatrix\":\"0.956047,0.108017,-0.272592,0,-0.293213,0.3522,-0.888809,0,1.56119e-9,0.929671,0.368392,0,-17.049,-23.0481,-2.6454,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'2a2287cc-20d7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_5cde9543-ba84-400d-ae2b-8c834d912266/2a2287cc-20d7-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_9e19c6c5-27e3-41f8-90a7-f84d73b731bb_ACT_545d13eb-7a31-42bf-90ab-cb4233458aa7_SESS_c6e68ab1-08f5-4291-86d3-ad9cd6495071_TOSC_e9d8f1be-b116-4ece-ab8b-b2b34ce33f95_SNAPS_','2021-02-11 15:56:43','2019-12-16 09:46:05','2a2287cc-20d7-11ea-947d-226cec7cb58a.png','2021-02-11 16:56:43','SYNCED','2a2287cc-20d7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.116.1.1.2\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'2a24187e-20d7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_5cde9543-ba84-400d-ae2b-8c834d912266/2a24187e-20d7-11ea-947d-226cec7cb58a.m','MATRX','PATIENT_9e19c6c5-27e3-41f8-90a7-f84d73b731bb_ACT_545d13eb-7a31-42bf-90ab-cb4233458aa7_SESS_c6e68ab1-08f5-4291-86d3-ad9cd6495071_OCC_c6e68ab1-08f5-4291-86d3-ad9migraoccl_BOMA__MATRX_','2021-02-11 15:56:43','2019-12-16 09:46:47','2a24187e-20d7-11ea-947d-226cec7cb58a.m','2021-02-11 16:56:43','SYNCED','2a24187e-20d7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule Occlusion 1.116.1.1\",\"title\":\"Matrice Transfo. Mandibule MATRIX\"}'),(2,'2a43ce5a-96b7-4b2e-a5cc-38121ed0ed44','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2a43ce5a-96b7-4b2e-a5cc-38121ed0ed44.png','SNAPS','PATIENT_fb6c4a59-c72c-46ad-a554-ed6056e6aa8f_ACT_a993018f-4e2c-4c41-9e18-5b2cd8a5a5ad_SESS_5f263ed3-a107-4539-bca7-bbee330b804d_BOSC_bc439951-5ecb-4c25-bb4f-d62a524e586b_SNAPS_','2022-02-01 11:48:24','2019-07-24 15:10:36','2a43ce5a-96b7-4b2e-a5cc-38121ed0ed44.png','2022-02-01 12:48:24','SYNCED','2a43ce5a-96b7-4b2e-a5cc-38121ed0ed44',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 113.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'2a45f299-1f2f-42a9-b9ae-dd5adac5212b','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2a45f299-1f2f-42a9-b9ae-dd5adac5212b.png','SNAPS','PATIENT_e10dd73f-e0a1-4244-93ef-41a0fe1b27fd_ACT_1a8047ce-7b95-446a-b5b9-71639b6c4b05_SESS_af562828-6543-4aac-b52c-3a40f5e106a6_TOSC_ae1e6238-0a21-4e6b-86b3-6cf6e2b54501_SNAPS_','2021-02-11 15:56:44','2020-01-06 10:17:44','2a45f299-1f2f-42a9-b9ae-dd5adac5212b.png','2021-02-11 16:56:44','SYNCED','2a45f299-1f2f-42a9-b9ae-dd5adac5212b',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'2a88ad63-3174-4eb4-8410-2fc2b77519e3','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2a88ad63-3174-4eb4-8410-2fc2b77519e3.ply','PLY','PATIENT_0ca041a1-027c-4dd2-b295-60f5d76e45a7_ACT_d23098f0-2472-45a9-b3e5-d7bef8926ef9_SESS_8dad33c1-fa53-4b10-be29-d6c13bd7610b_TOSC_176433c0-b415-4e93-a728-dc0dea0ad46a_PLY_','2022-02-01 11:48:24','2019-07-11 17:55:14','2a88ad63-3174-4eb4-8410-2fc2b77519e3.ply','2022-02-01 12:48:24','SYNCED','2a88ad63-3174-4eb4-8410-2fc2b77519e3',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 47.1.1.1\",\"modelMatrix\":\"0.489877,-0.827552,0.274185,0,0.871791,0.465018,-0.15407,0,-6.06674e-9,0.314508,0.949255,0,-6.11092,-35.7986,-17.1298,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'2aa05296-cb75-48a3-9393-a94853176649','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2aa05296-cb75-48a3-9393-a94853176649.ply','PLY','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_a88bef1e-7647-4bdf-93dc-3ecd4800c5bf_SESS_c407d6b9-e27c-42ab-86de-0387570e1b6e_BOSC_8d623e3e-89c9-4f91-bbd1-79dcc32a611b_PLY_','2021-02-11 15:56:46','2020-01-23 11:02:06','2aa05296-cb75-48a3-9393-a94853176649.ply','2021-02-11 16:56:46','SYNCED','2aa05296-cb75-48a3-9393-a94853176649',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.1.1.1.1\",\"modelMatrix\":\"0.857029,-0.482654,0.180406,0,0.515268,0.802783,-0.300064,0,-7.23445e-9,0.350121,0.936704,0,9.85588,-31.0709,-11.9117,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'2aae30b1-71b4-48a0-a35d-8d8e851ca4cd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2aae30b1-71b4-48a0-a35d-8d8e851ca4cd.stl','STL','PATIENT_584425d1-9187-46b2-b779-389ca7946b11_ACT_80c10a09-bf4e-411f-8ece-d34feac7d281_SESS_e97b29cd-64f9-4614-9520-45e81976c498_TOSC_4e5249e1-7f53-4c40-87d8-a1bc8a6b2ce1_STL_','2021-02-16 16:40:54','2019-12-06 15:21:44','2aae30b1-71b4-48a0-a35d-8d8e851ca4cd.stl','2021-02-16 17:40:54','SYNCED','2aae30b1-71b4-48a0-a35d-8d8e851ca4cd',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 230.1.1.1\",\"modelMatrix\":\"-0.520718,-0.830428,0.198096,0,0.853729,-0.506506,0.120825,0,-4.98e-9,0.232036,0.972707,0,-34.341,-14.6538,-15.8194,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'2acdb887-0817-4177-8fa6-21f43f277347','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2acdb887-0817-4177-8fa6-21f43f277347.png','SNAPS','PATIENT_efcb936d-815d-4f38-924f-76c33ec49c3e_ACT_b9475811-feb6-4b33-ac20-9005ea74f590_SESS_cc2f5cb7-4723-4aa1-9cd4-357ca2a2ab5e_BOSC_9ec40e5e-e71c-4d66-81d5-09d4378b323c_SNAPS_','2021-02-11 15:56:47','2019-12-18 11:55:40','2acdb887-0817-4177-8fa6-21f43f277347.png','2021-02-11 16:56:47','SYNCED','2acdb887-0817-4177-8fa6-21f43f277347',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 20.1.267.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'2ad546c0-309d-4f72-9dc1-fc5c9974669b','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2ad546c0-309d-4f72-9dc1-fc5c9974669b.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_74046856-f7e4-4155-906f-2a46dba1127e_SESS_8a390dd7-3674-4940-ac5e-c794a278300d_TOSC_9cbb15d4-ae04-4698-ad0b-c1fe5b179655_PLY_','2021-02-11 15:56:47','2020-03-12 16:10:52','2ad546c0-309d-4f72-9dc1-fc5c9974669b.ply','2021-02-11 16:56:47','SYNCED','2ad546c0-309d-4f72-9dc1-fc5c9974669b',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"modelMatrix\":\"0.682002,-0.682446,0.262944,0,0.73135,0.636399,-0.245202,0,-6.48685e-9,0.359533,0.933133,0,4.67794,-39.9694,-14.1768,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'2ad72077-96dd-4f5f-b9e8-b6273abb60b8','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2ad72077-96dd-4f5f-b9e8-b6273abb60b8.ply','PLY','PATIENT_16367112-6a96-47d9-859f-3dc28d5a08e4_ACT_628e12f5-617f-4cd1-94f1-89c29cf040d1_SESS_78998169-feb8-4484-a493-1ba5891adbe8_BOSC_d770b6f6-494c-474a-91f2-bd672dacef6b_PLY_','2022-02-01 11:48:24','2019-09-04 10:24:08','2ad72077-96dd-4f5f-b9e8-b6273abb60b8.ply','2022-02-01 12:48:24','SYNCED','2ad72077-96dd-4f5f-b9e8-b6273abb60b8',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 143.1.1.1\",\"modelMatrix\":\"-0.31573,-0.942011,0.11371,0,0.948849,-0.313455,0.037837,0,-1.85616e-9,0.11984,0.992793,0,-19.0383,-7.17177,-36.2942,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'2adcae13-4d72-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2adcae13-4d72-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_d6bcc64f-1224-43bb-9346-ab1a357e51a6_SESS_fd4c2517-8e66-47b4-9a2f-87f549c8dbf2_BOSC_5b6e64d3-0730-4b20-bae1-2b5d22daa0ca_PLY_','2021-02-11 15:56:47','2020-02-12 09:31:40','2adcae13-4d72-11ea-947d-226cec7cb58a.ply','2021-02-11 16:56:47','SYNCED','2adcae13-4d72-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"modelMatrix\":\"-0.83333,0.534966,-0.139184,0,-0.552775,-0.806482,0.209826,0,3.06413e-9,0.251792,0.967781,0,-4.66003,23.3701,-18.2127,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'2ae16209-4d72-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2ae16209-4d72-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_daace80e-0220-46cd-9d7c-6aeb8106b672_ACT_d6bcc64f-1224-43bb-9346-ab1a357e51a6_SESS_fd4c2517-8e66-47b4-9a2f-87f549c8dbf2_TOSC_6f103144-5802-4686-aa7c-0a2174f99248_PLY_','2021-02-11 15:56:47','2020-02-12 09:28:50','2ae16209-4d72-11ea-947d-226cec7cb58a.ply','2021-02-11 16:56:47','SYNCED','2ae16209-4d72-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"modelMatrix\":\"0.79596,-0.567234,0.211408,0,0.605349,0.745843,-0.277975,0,7.90795e-9,0.349233,0.937036,0,5.52322,-31.8201,-18.1464,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'2ae31399-4d72-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2ae31399-4d72-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_daace80e-0220-46cd-9d7c-6aeb8106b672_ACT_d6bcc64f-1224-43bb-9346-ab1a357e51a6_SESS_fd4c2517-8e66-47b4-9a2f-87f549c8dbf2_TOSC_6f103144-5802-4686-aa7c-0a2174f99248_SNAPS_','2021-02-11 15:56:47','2020-02-12 09:28:50','2ae31399-4d72-11ea-947d-226cec7cb58a.png','2021-02-11 16:56:47','SYNCED','2ae31399-4d72-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'2ae4b535-4d72-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2ae4b535-4d72-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_d6bcc64f-1224-43bb-9346-ab1a357e51a6_SESS_fd4c2517-8e66-47b4-9a2f-87f549c8dbf2_BOSC_5b6e64d3-0730-4b20-bae1-2b5d22daa0ca_SNAPS_','2021-02-11 15:56:48','2020-02-12 09:31:40','2ae4b535-4d72-11ea-947d-226cec7cb58a.png','2021-02-11 16:56:48','SYNCED','2ae4b535-4d72-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'2afc856b-1c0f-4bbf-a1e7-e0c55c0e84a4','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2afc856b-1c0f-4bbf-a1e7-e0c55c0e84a4.png','SNAPS','PATIENT_16367112-6a96-47d9-859f-3dc28d5a08e4_ACT_628e12f5-617f-4cd1-94f1-89c29cf040d1_SESS_78998169-feb8-4484-a493-1ba5891adbe8_TOSC_7b9bc597-781f-4a85-9875-dcdd1bab4a91_SNAPS_','2022-02-01 11:48:24','2019-09-04 10:18:02','2afc856b-1c0f-4bbf-a1e7-e0c55c0e84a4.png','2022-02-01 12:48:24','SYNCED','44672503-d0dc-4f7a-bcec-bb88b252dad3',1,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 143.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'2b0ef623-3cbf-4268-9eb6-1006d340d07b','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2b0ef623-3cbf-4268-9eb6-1006d340d07b.ply','PLY','PATIENT_5f9b3580-4fd2-4fe2-ad6d-0a5d895a11e8_ACT_1d71b800-f606-4aa6-afdc-be1fcad191d1_SESS_02c4c729-f6f3-4c02-b83a-8bf60094828c_TOSC_a7c386f5-be1a-4e6f-b10d-78dfe16060cc_PLY_','2021-02-11 15:56:49','2020-06-16 12:05:34','2b0ef623-3cbf-4268-9eb6-1006d340d07b.ply','2021-02-11 16:56:49','SYNCED','2b0ef623-3cbf-4268-9eb6-1006d340d07b',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.42.1.1\",\"modelMatrix\":\"0.885742,-0.449277,0.116669,0,0.464178,0.857308,-0.222627,0,-1.3698e-9,0.251345,0.967897,0,12.7727,-34.4233,-10.1972,1\",\"title\":\"Maxillaire PLY\"}'),(2,'2b1fe4ff-5665-4c49-9cb9-326bb214d363','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2b1fe4ff-5665-4c49-9cb9-326bb214d363.stl','STL','PATIENT_dde53ea4-f623-42e4-9864-d8e77d9deabe_ACT_c658c808-2655-4213-a8a0-1c34d5830ee5_SESS_ad32c977-4115-45c7-9168-d19d87c66102_TOSC_b289381b-23ec-4a96-9206-71132277e1ca_STL_','2021-12-30 18:05:07','2019-11-22 08:14:15','2b1fe4ff-5665-4c49-9cb9-326bb214d363.stl','2021-12-30 19:05:07','SYNCED','2b1fe4ff-5665-4c49-9cb9-326bb214d363',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 208.1.1.1\",\"modelMatrix\":\"0.372298,-0.882355,0.287826,0,0.928113,0.353943,-0.115457,0,6.55733e-10,0.31012,0.950698,0,-12.357,-35.988,-17.2824,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'2b1ff232-8d31-481a-902e-b2f460d15399','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2b1ff232-8d31-481a-902e-b2f460d15399.stl','STL','PATIENT_31f9e32b-31bd-49c3-b810-0e9239bc4ea6_ACT_f5f2b260-46bb-4075-9902-c3dc5fcff02f_SESS_b2a49fb6-a9a4-4aa2-98ea-d9a2ad02d393_TOSC_11708461-8a7b-4ad4-afe9-b10c0878fa24_STL_','2022-02-01 11:48:24','2019-07-23 15:16:53','2b1ff232-8d31-481a-902e-b2f460d15399.stl','2022-02-01 12:48:24','SYNCED','2b1ff232-8d31-481a-902e-b2f460d15399',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 21.1.1.1\",\"modelMatrix\":\"-0.615133,-0.753943,0.230613,0,0.788424,-0.58823,0.179926,0,-9.74944e-9,0.292499,0.956266,0,-22.1191,-9.83144,-24.7884,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'2b2bccc0-5ef1-4b78-bfce-9cdc997d05e7','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2b2bccc0-5ef1-4b78-bfce-9cdc997d05e7.stl','STL','PATIENT_df5cd3e3-f012-41db-937e-54f6102a7215_ACT_de0c93fe-463b-44c5-a3d4-058f2138bc94_SESS_0e0aba24-d37b-41e0-a159-d57412935ff8_BOSC_27984250-2b58-4874-9026-5e21a138804a_STL_','2021-02-16 16:40:55','2019-12-12 14:08:41','2b2bccc0-5ef1-4b78-bfce-9cdc997d05e7.stl','2021-02-16 17:40:55','SYNCED','2b2bccc0-5ef1-4b78-bfce-9cdc997d05e7',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 232.12.1.1\",\"modelMatrix\":\"-0.978446,0.200348,-0.0500315,0,-0.2065,-0.949294,0.237061,0,5.4752e-9,0.242283,0.970206,0,-13.1689,16.8327,-20.9766,1\",\"title\":\"MANDIBULE STL\"}'),(2,'2b2e5a24-dea2-46aa-ac24-82b61dd2713d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2b2e5a24-dea2-46aa-ac24-82b61dd2713d.png','SNAPS','PATIENT_37924e66-6fca-42d1-866c-8897f314ef35_ACT_b97bc99b-fc77-46b8-82b7-151aef0aec54_SESS_f2ff3c9a-d754-4dd6-9785-85c513b9862b_TOSC_bef0018c-1ca5-45e9-b2a7-eb2bf155f2a7_SNAPS_','2022-02-01 11:48:25','2019-09-05 09:35:47','2b2e5a24-dea2-46aa-ac24-82b61dd2713d.png','2022-02-01 12:48:25','SYNCED','2b2e5a24-dea2-46aa-ac24-82b61dd2713d',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 145.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'2b3ada98-9a45-48fc-8c37-a32dc803ccc9','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2b3ada98-9a45-48fc-8c37-a32dc803ccc9.png','SNAPS','PATIENT_b1c6772e-2335-4d4c-9aa8-24011cedd2b6_ACT_905e26fe-fadd-48d5-abd5-6c436f4a2d5e_SESS_1e25ea8a-5850-42e8-a874-a54e6c1ed24d_TOSC_3b7058fb-90b7-452e-86f5-e28de9e219be_SNAPS_','2021-02-11 15:56:51','2020-01-15 14:43:45','2b3ada98-9a45-48fc-8c37-a32dc803ccc9.png','2021-02-11 16:56:51','SYNCED','2b3ada98-9a45-48fc-8c37-a32dc803ccc9',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'2b42afe7-ae04-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2b42afe7-ae04-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_67d39055-0cd5-49c0-9f3b-2cc576bfc310_ACT_291510cf-2ad2-4298-817d-22026f7bf446_SESS_9284a539-a136-47a9-a524-769845154750_BOSC_9a58cd85-8834-4e0c-92c1-2ea40f660e6d_STL_','2022-02-01 11:48:25','2019-07-24 15:21:56','2b42afe7-ae04-11e9-a33b-226cec7cb58a.stl','2022-02-01 12:48:25','SYNCED','2b42afe7-ae04-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 114.1.1.1\",\"modelMatrix\":\"-0.729991,0.673961,-0.11353,0,-0.683456,-0.71985,0.12126,0,-3.67039e-9,0.166112,0.986107,0,-5.44857,24.2465,-24.2553,1\",\"title\":\"MANDIBULE STL\"}'),(2,'2b435b68-ae04-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2b435b68-ae04-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_67d39055-0cd5-49c0-9f3b-2cc576bfc310_ACT_291510cf-2ad2-4298-817d-22026f7bf446_SESS_9284a539-a136-47a9-a524-769845154750_TOSC_9231a7fc-461e-4bec-a308-e021c8bdb92f_STL_','2022-02-01 11:48:25','2019-07-24 15:16:35','2b435b68-ae04-11e9-a33b-226cec7cb58a.stl','2022-02-01 12:48:25','SYNCED','2b435b68-ae04-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 114.1.1.1\",\"modelMatrix\":\"-0.593536,-0.781057,0.194071,0,0.804807,-0.576021,0.143126,0,-1.00835e-8,0.24114,0.97049,0,-29.5096,-13.7964,-16.1702,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'2b43f19b-ae04-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2b43f19b-ae04-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_67d39055-0cd5-49c0-9f3b-2cc576bfc310_ACT_291510cf-2ad2-4298-817d-22026f7bf446_SESS_9284a539-a136-47a9-a524-769845154750_BOSC_9a58cd85-8834-4e0c-92c1-2ea40f660e6d_PLY_','2022-02-01 11:48:25','2019-07-24 15:21:56','2b43f19b-ae04-11e9-a33b-226cec7cb58a.ply','2022-02-01 12:48:25','SYNCED','2b43f19b-ae04-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 114.1.1.1\",\"modelMatrix\":\"-0.729991,0.673961,-0.11353,0,-0.683456,-0.71985,0.12126,0,-3.67039e-9,0.166112,0.986107,0,-5.44857,24.2465,-24.2553,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'2b448ecd-ae04-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2b448ecd-ae04-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_67d39055-0cd5-49c0-9f3b-2cc576bfc310_ACT_291510cf-2ad2-4298-817d-22026f7bf446_SESS_9284a539-a136-47a9-a524-769845154750_TOSC_9231a7fc-461e-4bec-a308-e021c8bdb92f_SNAPS_','2022-02-01 11:48:25','2019-07-24 15:16:35','2b448ecd-ae04-11e9-a33b-226cec7cb58a.png','2022-02-01 12:48:25','SYNCED','2b448ecd-ae04-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 114.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'2b4518bb-ae04-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2b4518bb-ae04-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_67d39055-0cd5-49c0-9f3b-2cc576bfc310_ACT_291510cf-2ad2-4298-817d-22026f7bf446_SESS_9284a539-a136-47a9-a524-769845154750_BOSC_9a58cd85-8834-4e0c-92c1-2ea40f660e6d_SNAPS_','2022-02-01 11:48:26','2019-07-24 15:21:56','2b4518bb-ae04-11e9-a33b-226cec7cb58a.png','2022-02-01 12:48:26','SYNCED','2b4518bb-ae04-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 114.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'2b4595c2-ae04-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2b4595c2-ae04-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_67d39055-0cd5-49c0-9f3b-2cc576bfc310_ACT_291510cf-2ad2-4298-817d-22026f7bf446_SESS_9284a539-a136-47a9-a524-769845154750_TOSC_9231a7fc-461e-4bec-a308-e021c8bdb92f_PLY_','2022-02-01 11:48:26','2019-07-24 15:16:35','2b4595c2-ae04-11e9-a33b-226cec7cb58a.ply','2022-02-01 12:48:26','SYNCED','2b4595c2-ae04-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 114.1.1.1\",\"modelMatrix\":\"-0.593536,-0.781057,0.194071,0,0.804807,-0.576021,0.143126,0,-1.00835e-8,0.24114,0.97049,0,-29.5096,-13.7964,-16.1702,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'2b546f48-d92d-4f44-be8c-8a6c44c407e1','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2b546f48-d92d-4f44-be8c-8a6c44c407e1.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_12ae5cd5-2589-498e-9b88-724523a4f0a8_SESS_aec1fa2a-093a-4ae2-8dec-b36507f28ab9_TOSC_099fbf95-8c37-4393-a8d7-8259a0f77314_PLY_','2021-02-11 15:56:52','2020-06-19 09:11:34','2b546f48-d92d-4f44-be8c-8a6c44c407e1.ply','2021-02-11 16:56:52','SYNCED','2b546f48-d92d-4f44-be8c-8a6c44c407e1',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.67.1.1\",\"modelMatrix\":\"0.176599,-0.949575,0.259075,0,0.984283,0.170372,-0.0464831,0,-2.11098e-9,0.263212,0.964738,0,-13.365,-32.3958,-17.403,1\",\"title\":\"Maxillaire PLY\"}'),(2,'2b5e91bb-f86e-41bb-8f33-78b88b391f10','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2b5e91bb-f86e-41bb-8f33-78b88b391f10.png','SNAPS','PATIENT_ecb61ddf-1f89-4a95-a7b1-7a6363382f65_ACT_3c91f7a9-06d1-4cba-8143-a036ed8bcf17_SESS_219a302b-9f70-4f11-b21b-a869fc21049f_TOSC_ff454941-8333-4910-9d4f-7f588688b8d6_SNAPS_','2022-02-01 11:48:26','2019-07-17 08:29:16','2b5e91bb-f86e-41bb-8f33-78b88b391f10.png','2022-02-01 12:48:26','SYNCED','2b5e91bb-f86e-41bb-8f33-78b88b391f10',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 83.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'2b67b273-2360-475e-9c30-94e74e4a1b69','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2b67b273-2360-475e-9c30-94e74e4a1b69.stl','STL','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_fd694b3f-abde-4e46-91f7-7c62bfdcafa4_SESS_73a3f5b9-e905-4911-a163-2022e1de3380_TOSC_ea57c5ea-7b5f-4f81-bb16-ad8a234998e2_STL_','2021-08-19 22:44:18','2019-11-26 21:09:39','2b67b273-2360-475e-9c30-94e74e4a1b69.stl','2021-08-20 00:44:18','SYNCED','2b67b273-2360-475e-9c30-94e74e4a1b69',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"modelMatrix\":\"0.790436,-0.553077,0.263281,0,0.612545,0.713698,-0.339741,0,1.748e-8,0.429815,0.902917,0,10.4806,-35.6646,-17.1264,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'2b6f9d4f-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2b6f9d4f-c807-11e9-8df1-226cec7cb58a.stl','STL','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_TOSC_e9bb612d-7fee-4070-8a3a-42b5e7681803_STL_','2022-02-01 11:48:26','2019-08-26 14:33:24','2b6f9d4f-c807-11e9-8df1-226cec7cb58a.stl','2022-02-01 12:48:26','SYNCED','2b6f9d4f-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 129.12.1.1\",\"modelMatrix\":\"0.835322,-0.512426,0.199138,0,0.549761,0.778595,-0.302576,0,-2.47761e-9,0.362227,0.93209,0,10.3011,-32.9038,-31.5403,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'2b70446a-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2b70446a-c807-11e9-8df1-226cec7cb58a.ply','PLY','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_TOSC_e9bb612d-7fee-4070-8a3a-42b5e7681803_PLY_','2022-02-01 11:48:26','2019-08-26 14:33:24','2b70446a-c807-11e9-8df1-226cec7cb58a.ply','2022-02-01 12:48:26','SYNCED','2b70446a-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 129.12.1.1\",\"modelMatrix\":\"0.835322,-0.512426,0.199138,0,0.549761,0.778595,-0.302576,0,-2.47761e-9,0.362227,0.93209,0,10.3011,-32.9038,-31.5403,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'2b70a258-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2b70a258-c807-11e9-8df1-226cec7cb58a.png','SNAPS','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_TOSC_e9bb612d-7fee-4070-8a3a-42b5e7681803_SNAPS_','2022-02-01 11:48:27','2019-08-26 14:33:24','2b70a258-c807-11e9-8df1-226cec7cb58a.png','2022-02-01 12:48:27','SYNCED','2b70a258-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 129.12.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'2b7b45be-bbea-4e76-8c9f-37551f9caf11','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2b7b45be-bbea-4e76-8c9f-37551f9caf11.ply','PLY','PATIENT_9e511014-ee3d-4c26-b85c-165cdc724413_ACT_72a7d1b9-2ede-45a3-acff-faa1d1d55297_SESS_4265a271-0d5f-49aa-bb33-e95db5f72bd1_BOSC_aa2a8b5f-6a2d-48f4-9a7c-3ca072538fed_PLY_','2021-02-11 15:56:53','2019-12-20 14:10:31','2b7b45be-bbea-4e76-8c9f-37551f9caf11.ply','2021-02-11 16:56:53','SYNCED','2b7b45be-bbea-4e76-8c9f-37551f9caf11',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 20.1.267.1.1.1\",\"modelMatrix\":\"-0.814443,0.57566,-0.0727896,0,-0.580243,-0.80801,0.102169,0,3.27112e-9,0.125447,0.9921,0,-8.35227,26.5363,-20.5406,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'2b8cb2c0-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2b8cb2c0-c807-11e9-8df1-226cec7cb58a.stl','STL','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_BOSC_4130b951-2ea4-4c1e-9e71-e69c342e36b1_STL_','2022-02-01 11:48:27','2019-08-26 14:41:36','2b8cb2c0-c807-11e9-8df1-226cec7cb58a.stl','2022-02-01 12:48:27','SYNCED','2b8cb2c0-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 129.12.1.1\",\"modelMatrix\":\"-0.86495,0.497159,-0.0685085,0,-0.501857,-0.856853,0.118074,0,-5.63121e-9,0.13651,0.990639,0,-5.41015,22.1831,-19.7439,1\",\"title\":\"MANDIBULE STL\"}'),(2,'2b8cda56-17c4-4a4e-988a-927290f83570','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2b8cda56-17c4-4a4e-988a-927290f83570.ply','PLY','PATIENT_0331d3a8-cc7b-44e0-ae03-7f8543b4c613_ACT_c0b56124-1fc8-48f6-8278-8568f573053c_SESS_6511d2dc-171a-49fb-a3e2-c2b4bc29fe2c_TOSC_d2eea46d-7385-4d24-88ff-0305a578392e_PLY_','2021-02-11 15:56:53','2020-01-03 10:22:43','2b8cda56-17c4-4a4e-988a-927290f83570.ply','2021-02-11 16:56:53','SYNCED','2b8cda56-17c4-4a4e-988a-927290f83570',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"modelMatrix\":\"0.528568,-0.805771,0.267111,0,0.848891,0.501719,-0.166319,0,-2.26092e-8,0.314659,0.949205,0,-0.578565,-33.1292,-19.5329,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'2b8d598b-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2b8d598b-c807-11e9-8df1-226cec7cb58a.ply','PLY','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_BOSC_4130b951-2ea4-4c1e-9e71-e69c342e36b1_PLY_','2022-02-01 11:48:27','2019-08-26 14:41:36','2b8d598b-c807-11e9-8df1-226cec7cb58a.ply','2022-02-01 12:48:27','SYNCED','2b8d598b-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 129.12.1.1\",\"modelMatrix\":\"-0.86495,0.497159,-0.0685085,0,-0.501857,-0.856853,0.118074,0,-5.63121e-9,0.13651,0.990639,0,-5.41015,22.1831,-19.7439,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'2b8ddc76-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2b8ddc76-c807-11e9-8df1-226cec7cb58a.stl','STL','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_TOSC_e9bb612d-7fee-4070-8a3a-42b5e7681803_STL_','2022-02-01 11:48:27','2019-08-26 14:33:24','2b8ddc76-c807-11e9-8df1-226cec7cb58a.stl','2022-02-01 12:48:27','SYNCED','2b8ddc76-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 129.12.1.1\",\"modelMatrix\":\"0.835322,-0.512426,0.199138,0,0.549761,0.778595,-0.302576,0,-2.47761e-9,0.362227,0.93209,0,10.3011,-32.9038,-31.5403,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'2b8e9967-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2b8e9967-c807-11e9-8df1-226cec7cb58a.ply','PLY','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_TOSC_e9bb612d-7fee-4070-8a3a-42b5e7681803_PLY_','2022-02-01 11:48:27','2019-08-26 14:33:24','2b8e9967-c807-11e9-8df1-226cec7cb58a.ply','2022-02-01 12:48:27','SYNCED','2b8e9967-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 129.12.1.1\",\"modelMatrix\":\"0.835322,-0.512426,0.199138,0,0.549761,0.778595,-0.302576,0,-2.47761e-9,0.362227,0.93209,0,10.3011,-32.9038,-31.5403,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'2b8f2e2a-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2b8f2e2a-c807-11e9-8df1-226cec7cb58a.png','SNAPS','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_TOSC_e9bb612d-7fee-4070-8a3a-42b5e7681803_SNAPS_','2022-02-01 11:48:27','2019-08-26 14:33:24','2b8f2e2a-c807-11e9-8df1-226cec7cb58a.png','2022-02-01 12:48:27','SYNCED','2b8f2e2a-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 129.12.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'2b8fd9d7-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2b8fd9d7-c807-11e9-8df1-226cec7cb58a.png','SNAPS','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_BOSC_4130b951-2ea4-4c1e-9e71-e69c342e36b1_SNAPS_','2022-02-01 11:48:27','2019-08-26 14:41:36','2b8fd9d7-c807-11e9-8df1-226cec7cb58a.png','2022-02-01 12:48:27','SYNCED','2b8fd9d7-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 129.12.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'2ba3f53d-0b0c-4e58-a82a-f1eb2f2cbc52','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2ba3f53d-0b0c-4e58-a82a-f1eb2f2cbc52.stl','STL','PATIENT_f93454c6-663d-4e6d-ac6f-b722071bd526_ACT_d2592cf9-13e5-45b6-8fed-2e88d5fda817_SESS_97a06e73-bc39-462a-a930-2f76dc7b4983_BOSC_db940e92-a302-446e-bbeb-c730581b29e5_STL_','2021-12-30 18:05:11','2019-10-15 10:56:27','2ba3f53d-0b0c-4e58-a82a-f1eb2f2cbc52.stl','2021-12-30 19:05:11','SYNCED','2ba3f53d-0b0c-4e58-a82a-f1eb2f2cbc52',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 187.1.1.1\",\"modelMatrix\":\"-0.822701,0.557853,-0.109378,0,-0.568475,-0.807329,0.158293,0,-1.02276e-9,0.192407,0.981315,0,-5.35381,25.3566,-16.7812,1\",\"title\":\"MANDIBULE STL\"}'),(2,'2badfb36-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2badfb36-c807-11e9-8df1-226cec7cb58a.stl','STL','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_BOSC_4130b951-2ea4-4c1e-9e71-e69c342e36b1_STL_','2022-02-01 11:48:28','2019-08-26 14:41:36','2badfb36-c807-11e9-8df1-226cec7cb58a.stl','2022-02-01 12:48:28','SYNCED','2badfb36-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 129.12.1.1\",\"modelMatrix\":\"-0.86495,0.497159,-0.0685085,0,-0.501857,-0.856853,0.118074,0,-5.63121e-9,0.13651,0.990639,0,-5.41015,22.1831,-19.7439,1\",\"title\":\"MANDIBULE STL\"}'),(2,'2baea767-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2baea767-c807-11e9-8df1-226cec7cb58a.ply','PLY','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_BOSC_4130b951-2ea4-4c1e-9e71-e69c342e36b1_PLY_','2022-02-01 11:48:28','2019-08-26 14:41:36','2baea767-c807-11e9-8df1-226cec7cb58a.ply','2022-02-01 12:48:28','SYNCED','2baea767-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 129.12.1.1\",\"modelMatrix\":\"-0.86495,0.497159,-0.0685085,0,-0.501857,-0.856853,0.118074,0,-5.63121e-9,0.13651,0.990639,0,-5.41015,22.1831,-19.7439,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'2baeee63-6f19-4b0b-81e2-0339d5082c31','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2baeee63-6f19-4b0b-81e2-0339d5082c31.png','SNAPS','PATIENT_a7979338-30b6-4816-bbd5-ef24133b068c_ACT_9d55e20d-c9a3-47c1-be07-a1b8b8e1ad46_SESS_f4c4cf33-1da8-4a4f-a33c-5f4ad5b9b16d_TOSC_d4e65b9a-90f8-4e59-9432-ce2d24eabb3d_SNAPS_','2021-02-11 15:56:55','2020-01-31 11:44:24','2baeee63-6f19-4b0b-81e2-0339d5082c31.png','2021-02-11 16:56:55','SYNCED','2baeee63-6f19-4b0b-81e2-0339d5082c31',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'2baf42a9-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2baf42a9-c807-11e9-8df1-226cec7cb58a.stl','STL','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_TOSC_e9bb612d-7fee-4070-8a3a-42b5e7681803_STL_','2022-02-01 11:48:28','2019-08-26 14:33:24','2baf42a9-c807-11e9-8df1-226cec7cb58a.stl','2022-02-01 12:48:28','SYNCED','2baf42a9-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 129.12.1.1\",\"modelMatrix\":\"0.835322,-0.512426,0.199138,0,0.549761,0.778595,-0.302576,0,-2.47761e-9,0.362227,0.93209,0,10.3011,-32.9038,-31.5403,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'2bafe71a-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2bafe71a-c807-11e9-8df1-226cec7cb58a.ply','PLY','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_TOSC_e9bb612d-7fee-4070-8a3a-42b5e7681803_PLY_','2022-02-01 11:48:28','2019-08-26 14:33:24','2bafe71a-c807-11e9-8df1-226cec7cb58a.ply','2022-02-01 12:48:28','SYNCED','2bafe71a-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 129.12.1.1\",\"modelMatrix\":\"0.835322,-0.512426,0.199138,0,0.549761,0.778595,-0.302576,0,-2.47761e-9,0.362227,0.93209,0,10.3011,-32.9038,-31.5403,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'2bb08f01-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2bb08f01-c807-11e9-8df1-226cec7cb58a.png','SNAPS','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_TOSC_e9bb612d-7fee-4070-8a3a-42b5e7681803_SNAPS_','2022-02-01 11:48:28','2019-08-26 14:33:24','2bb08f01-c807-11e9-8df1-226cec7cb58a.png','2022-02-01 12:48:28','SYNCED','2bb08f01-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 129.12.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'2bb122ff-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2bb122ff-c807-11e9-8df1-226cec7cb58a.png','SNAPS','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_BOSC_4130b951-2ea4-4c1e-9e71-e69c342e36b1_SNAPS_','2022-02-01 11:48:29','2019-08-26 14:41:36','2bb122ff-c807-11e9-8df1-226cec7cb58a.png','2022-02-01 12:48:29','SYNCED','2bb122ff-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 129.12.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'2bbe140d-3d51-4c14-b4b3-14331f159743','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2bbe140d-3d51-4c14-b4b3-14331f159743.png','SNAPS','PATIENT_5d459557-968e-47e1-ab0d-40f6f35af19f_ACT_0c285c17-0391-4813-bb3b-23ed0d69c4c2_SESS_d64759ae-a35d-4c4c-9187-e9ba2e931c8d_BOSC_afdaa6a1-db42-4bf7-9d93-bac7d3d99e6b_SNAPS_','2022-02-01 11:48:29','2019-09-02 11:47:04','2bbe140d-3d51-4c14-b4b3-14331f159743.png','2022-02-01 12:48:29','SYNCED','2bbe140d-3d51-4c14-b4b3-14331f159743',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 137.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'2bccdc94-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2bccdc94-c807-11e9-8df1-226cec7cb58a.stl','STL','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_BOSC_4130b951-2ea4-4c1e-9e71-e69c342e36b1_STL_','2022-02-01 11:48:29','2019-08-26 14:41:36','2bccdc94-c807-11e9-8df1-226cec7cb58a.stl','2022-02-01 12:48:29','SYNCED','2bccdc94-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 129.12.1.1\",\"modelMatrix\":\"-0.86495,0.497159,-0.0685085,0,-0.501857,-0.856853,0.118074,0,-5.63121e-9,0.13651,0.990639,0,-5.41015,22.1831,-19.7439,1\",\"title\":\"MANDIBULE STL\"}'),(2,'2bcd8124-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2bcd8124-c807-11e9-8df1-226cec7cb58a.ply','PLY','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_BOSC_4130b951-2ea4-4c1e-9e71-e69c342e36b1_PLY_','2022-02-01 11:48:29','2019-08-26 14:41:36','2bcd8124-c807-11e9-8df1-226cec7cb58a.ply','2022-02-01 12:48:29','SYNCED','2bcd8124-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 129.12.1.1\",\"modelMatrix\":\"-0.86495,0.497159,-0.0685085,0,-0.501857,-0.856853,0.118074,0,-5.63121e-9,0.13651,0.990639,0,-5.41015,22.1831,-19.7439,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'2bce0da3-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2bce0da3-c807-11e9-8df1-226cec7cb58a.stl','STL','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_TOSC_e9bb612d-7fee-4070-8a3a-42b5e7681803_STL_','2022-02-01 11:48:29','2019-08-26 14:33:24','2bce0da3-c807-11e9-8df1-226cec7cb58a.stl','2022-02-01 12:48:29','SYNCED','2bce0da3-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 129.12.1.1\",\"modelMatrix\":\"0.835322,-0.512426,0.199138,0,0.549761,0.778595,-0.302576,0,-2.47761e-9,0.362227,0.93209,0,10.3011,-32.9038,-31.5403,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'2bcea157-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2bcea157-c807-11e9-8df1-226cec7cb58a.ply','PLY','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_TOSC_e9bb612d-7fee-4070-8a3a-42b5e7681803_PLY_','2022-02-01 11:48:29','2019-08-26 14:33:24','2bcea157-c807-11e9-8df1-226cec7cb58a.ply','2022-02-01 12:48:29','SYNCED','2bcea157-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 129.12.1.1\",\"modelMatrix\":\"0.835322,-0.512426,0.199138,0,0.549761,0.778595,-0.302576,0,-2.47761e-9,0.362227,0.93209,0,10.3011,-32.9038,-31.5403,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'2bcf3b44-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2bcf3b44-c807-11e9-8df1-226cec7cb58a.png','SNAPS','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_TOSC_e9bb612d-7fee-4070-8a3a-42b5e7681803_SNAPS_','2022-02-01 11:48:30','2019-08-26 14:33:24','2bcf3b44-c807-11e9-8df1-226cec7cb58a.png','2022-02-01 12:48:30','SYNCED','2bcf3b44-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 129.12.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'2bcfde6a-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2bcfde6a-c807-11e9-8df1-226cec7cb58a.png','SNAPS','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_BOSC_4130b951-2ea4-4c1e-9e71-e69c342e36b1_SNAPS_','2022-02-01 11:48:30','2019-08-26 14:41:36','2bcfde6a-c807-11e9-8df1-226cec7cb58a.png','2022-02-01 12:48:30','SYNCED','2bcfde6a-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 129.12.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'2bd10083-5fc1-4cc9-b777-cd304862ba64','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2bd10083-5fc1-4cc9-b777-cd304862ba64.ply','PLY','PATIENT_c0cb70de-94b5-4ad1-8096-f1713ade0ce1_ACT_7b78ee76-d591-4a20-94ed-fa3498e1fe9c_SESS_cdccf1b9-9263-4647-a7af-3daca544410f_TOSC_452ebdd2-5b7e-4ef5-8e15-73ea7fd1928f_PLY_','2022-02-01 11:48:30','2019-07-17 16:58:53','2bd10083-5fc1-4cc9-b777-cd304862ba64.ply','2022-02-01 12:48:30','SYNCED','d42ba046-eae0-4687-81e6-1fee1f3ce676',1,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 94.1.1.1\",\"modelMatrix\":\"0.543406,-0.835552,0.0810134,0,0.83947,0.54087,-0.0524416,0,5.19472e-9,0.0965054,0.995332,0,-9.02213,-35.6213,-18.5471,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'2bead01d-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2bead01d-c807-11e9-8df1-226cec7cb58a.stl','STL','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_BOSC_4130b951-2ea4-4c1e-9e71-e69c342e36b1_STL_','2022-02-01 11:48:30','2019-08-26 14:41:36','2bead01d-c807-11e9-8df1-226cec7cb58a.stl','2022-02-01 12:48:30','SYNCED','2bead01d-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 129.12.1.1\",\"modelMatrix\":\"-0.86495,0.497159,-0.0685085,0,-0.501857,-0.856853,0.118074,0,-5.63121e-9,0.13651,0.990639,0,-5.41015,22.1831,-19.7439,1\",\"title\":\"MANDIBULE STL\"}'),(2,'2beb5058-3f66-4b4a-aace-597bc7eca48e','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2beb5058-3f66-4b4a-aace-597bc7eca48e.stl','STL','PATIENT_f378056d-f37c-4a09-952d-c4874c6a7590_ACT_7b843882-d3fe-43f2-8383-c119292fa05e_SESS_d860ca72-5a30-47ca-89d8-76b73a3fde3c_TOSC_7f7da7d5-4b2f-4c65-b299-50e97221fa0f_STL_','2022-03-04 13:40:31','2019-07-08 16:36:30','2beb5058-3f66-4b4a-aace-597bc7eca48e.stl','2022-03-04 14:40:31','SYNCED','2beb5058-3f66-4b4a-aace-597bc7eca48e',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 8.1.1.1\",\"modelMatrix\":\"0.969108,-0.241002,0.0524166,0,0.246636,0.946969,-0.205961,0,-2.44706e-9,0.212526,0.977155,0,-27.8829,-17.5743,-19.0438,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'2beb826b-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2beb826b-c807-11e9-8df1-226cec7cb58a.ply','PLY','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_BOSC_4130b951-2ea4-4c1e-9e71-e69c342e36b1_PLY_','2022-02-01 11:48:31','2019-08-26 14:41:36','2beb826b-c807-11e9-8df1-226cec7cb58a.ply','2022-02-01 12:48:31','SYNCED','2beb826b-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 129.12.1.1\",\"modelMatrix\":\"-0.86495,0.497159,-0.0685085,0,-0.501857,-0.856853,0.118074,0,-5.63121e-9,0.13651,0.990639,0,-5.41015,22.1831,-19.7439,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'2bebe975-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2bebe975-c807-11e9-8df1-226cec7cb58a.stl','STL','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_TOSC_e9bb612d-7fee-4070-8a3a-42b5e7681803_STL_','2022-02-01 11:48:31','2019-08-26 14:33:24','2bebe975-c807-11e9-8df1-226cec7cb58a.stl','2022-02-01 12:48:31','SYNCED','2bebe975-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 129.12.1.1\",\"modelMatrix\":\"0.835322,-0.512426,0.199138,0,0.549761,0.778595,-0.302576,0,-2.47761e-9,0.362227,0.93209,0,10.3011,-32.9038,-31.5403,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'2beca81a-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2beca81a-c807-11e9-8df1-226cec7cb58a.ply','PLY','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_TOSC_e9bb612d-7fee-4070-8a3a-42b5e7681803_PLY_','2022-02-01 11:48:31','2019-08-26 14:33:24','2beca81a-c807-11e9-8df1-226cec7cb58a.ply','2022-02-01 12:48:31','SYNCED','2beca81a-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 129.12.1.1\",\"modelMatrix\":\"0.835322,-0.512426,0.199138,0,0.549761,0.778595,-0.302576,0,-2.47761e-9,0.362227,0.93209,0,10.3011,-32.9038,-31.5403,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'2bed3974-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2bed3974-c807-11e9-8df1-226cec7cb58a.png','SNAPS','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_TOSC_e9bb612d-7fee-4070-8a3a-42b5e7681803_SNAPS_','2022-02-01 11:48:31','2019-08-26 14:33:24','2bed3974-c807-11e9-8df1-226cec7cb58a.png','2022-02-01 12:48:31','SYNCED','2bed3974-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 129.12.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'2bedee81-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2bedee81-c807-11e9-8df1-226cec7cb58a.png','SNAPS','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_BOSC_4130b951-2ea4-4c1e-9e71-e69c342e36b1_SNAPS_','2022-02-01 11:48:31','2019-08-26 14:41:36','2bedee81-c807-11e9-8df1-226cec7cb58a.png','2022-02-01 12:48:31','SYNCED','2bedee81-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 129.12.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'2bef57f7-0ad4-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2bef57f7-0ad4-11ea-947d-226cec7cb58a.stl','STL','PATIENT_fcf8c111-84a1-4f17-859c-ea2ad21d373b_ACT_d27c23bb-fa1e-4cd8-bacc-e2b65114a20e_SESS_844480c5-a8a8-4eb3-a014-e1424d66a1ca_BOSC_8b18f4f8-205e-47bf-8316-9a891e798ce1_STL_','2021-12-30 18:05:15','2019-11-18 14:03:30','2bef57f7-0ad4-11ea-947d-226cec7cb58a.stl','2021-12-30 19:05:15','SYNCED','2bef57f7-0ad4-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 168.1.1.1.1\",\"modelMatrix\":\"-0.999741,-0.0221736,0.00513725,0,0.0227609,-0.973943,0.225647,0,1.86442e-10,0.225705,0.974196,0,-17.4239,12.3022,-20.5406,1\",\"title\":\"MANDIBULE STL\"}'),(2,'2bf1252d-0ad4-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2bf1252d-0ad4-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_fcf8c111-84a1-4f17-859c-ea2ad21d373b_ACT_d27c23bb-fa1e-4cd8-bacc-e2b65114a20e_SESS_844480c5-a8a8-4eb3-a014-e1424d66a1ca_BOSC_8b18f4f8-205e-47bf-8316-9a891e798ce1_PLY_','2021-12-30 18:05:15','2019-11-18 14:03:30','2bf1252d-0ad4-11ea-947d-226cec7cb58a.ply','2021-12-30 19:05:15','SYNCED','2bf1252d-0ad4-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 168.1.1.1.1\",\"modelMatrix\":\"-0.999741,-0.0221736,0.00513725,0,0.0227609,-0.973943,0.225647,0,1.86442e-10,0.225705,0.974196,0,-17.4239,12.3022,-20.5406,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'2bf19a13-a3a8-11e9-a33b-226cec7cb58a','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2bf19a13-a3a8-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_0a66945b-1a85-401b-ad4b-8f12d5db9a24_ACT_cb5e78e7-76fe-4b53-a205-f9848e191205_SESS_b910b3e0-439a-469f-8215-5ef68253dded_BOSC_f55a2f95-8884-4a24-8c9d-7fc71862595c_PLY_','2022-03-04 13:40:31','2019-07-11 10:51:33','2bf19a13-a3a8-11e9-a33b-226cec7cb58a.ply','2022-03-04 14:40:31','SYNCED','2bf19a13-a3a8-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 38.1.1.1\",\"modelMatrix\":\"-0.973864,0.219502,-0.0583813,0,-0.227133,-0.941144,0.250318,0,-1.74617e-9,0.257036,0.966402,0,-15.9619,18.2817,-25.4787,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'2bf25386-a3a8-11e9-a33b-226cec7cb58a','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2bf25386-a3a8-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_0a66945b-1a85-401b-ad4b-8f12d5db9a24_ACT_cb5e78e7-76fe-4b53-a205-f9848e191205_SESS_b910b3e0-439a-469f-8215-5ef68253dded_TOSC_6b6262c1-e8fd-4865-ada6-4b7ecdde6571_STL_','2022-03-04 13:40:31','2019-07-11 10:47:49','2bf25386-a3a8-11e9-a33b-226cec7cb58a.stl','2022-03-04 14:40:31','SYNCED','2bf25386-a3a8-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 38.1.1.1\",\"modelMatrix\":\"0.538927,-0.807464,0.239917,0,0.842353,0.516605,-0.153496,0,-3.59725e-9,0.284818,0.958582,0,-7.44882,-35.7964,-13.3815,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'2bf2db99-0ad4-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2bf2db99-0ad4-11ea-947d-226cec7cb58a.stl','STL','PATIENT_09a2e393-74ab-40f4-9bff-bc038639effe_ACT_d27c23bb-fa1e-4cd8-bacc-e2b65114a20e_SESS_844480c5-a8a8-4eb3-a014-e1424d66a1ca_TOSC_4e142a49-a24c-434e-86df-a724494cc09a_STL_','2021-12-30 18:05:16','2019-11-18 11:23:27','2bf2db99-0ad4-11ea-947d-226cec7cb58a.stl','2021-12-30 19:05:16','SYNCED','2bf2db99-0ad4-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.30.1.1\",\"modelMatrix\":\"0.108343,-0.934859,0.338084,0,0.994114,0.101885,-0.0368459,0,-2.12746e-9,0.340085,0.940394,0,-16.8929,-27.793,-27.3833,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'2bf2e5d3-a3a8-11e9-a33b-226cec7cb58a','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2bf2e5d3-a3a8-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_0a66945b-1a85-401b-ad4b-8f12d5db9a24_ACT_cb5e78e7-76fe-4b53-a205-f9848e191205_SESS_b910b3e0-439a-469f-8215-5ef68253dded_BOSC_f55a2f95-8884-4a24-8c9d-7fc71862595c_STL_','2022-03-04 13:40:31','2019-07-11 10:51:33','2bf2e5d3-a3a8-11e9-a33b-226cec7cb58a.stl','2022-03-04 14:40:31','SYNCED','2bf2e5d3-a3a8-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 38.1.1.1\",\"modelMatrix\":\"-0.973864,0.219502,-0.0583813,0,-0.227133,-0.941144,0.250318,0,-1.74617e-9,0.257036,0.966402,0,-15.9619,18.2817,-25.4787,1\",\"title\":\"MANDIBULE STL\"}'),(2,'2bf358d7-a3a8-11e9-a33b-226cec7cb58a','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2bf358d7-a3a8-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_0a66945b-1a85-401b-ad4b-8f12d5db9a24_ACT_cb5e78e7-76fe-4b53-a205-f9848e191205_SESS_b910b3e0-439a-469f-8215-5ef68253dded_BOSC_f55a2f95-8884-4a24-8c9d-7fc71862595c_SNAPS_','2022-03-04 13:40:31','2019-07-11 10:51:33','2bf358d7-a3a8-11e9-a33b-226cec7cb58a.png','2022-03-04 14:40:31','SYNCED','2bf358d7-a3a8-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 38.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'2bf401f1-a3a8-11e9-a33b-226cec7cb58a','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2bf401f1-a3a8-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_0a66945b-1a85-401b-ad4b-8f12d5db9a24_ACT_cb5e78e7-76fe-4b53-a205-f9848e191205_SESS_b910b3e0-439a-469f-8215-5ef68253dded_TOSC_6b6262c1-e8fd-4865-ada6-4b7ecdde6571_SNAPS_','2022-03-04 13:40:32','2019-07-11 10:47:49','2bf401f1-a3a8-11e9-a33b-226cec7cb58a.png','2022-03-04 14:40:32','SYNCED','2bf401f1-a3a8-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 38.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'2bf47859-0ad4-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2bf47859-0ad4-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_fcf8c111-84a1-4f17-859c-ea2ad21d373b_ACT_d27c23bb-fa1e-4cd8-bacc-e2b65114a20e_SESS_844480c5-a8a8-4eb3-a014-e1424d66a1ca_BOSC_8b18f4f8-205e-47bf-8316-9a891e798ce1_SNAPS_','2021-12-30 18:05:17','2019-11-18 14:03:30','2bf47859-0ad4-11ea-947d-226cec7cb58a.png','2021-12-30 19:05:17','SYNCED','2bf47859-0ad4-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 168.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'2bf494ab-a3a8-11e9-a33b-226cec7cb58a','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2bf494ab-a3a8-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_0a66945b-1a85-401b-ad4b-8f12d5db9a24_ACT_cb5e78e7-76fe-4b53-a205-f9848e191205_SESS_b910b3e0-439a-469f-8215-5ef68253dded_TOSC_6b6262c1-e8fd-4865-ada6-4b7ecdde6571_PLY_','2022-03-04 13:40:32','2019-07-11 10:47:49','2bf494ab-a3a8-11e9-a33b-226cec7cb58a.ply','2022-03-04 14:40:32','SYNCED','2bf494ab-a3a8-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 38.1.1.1\",\"modelMatrix\":\"0.538927,-0.807464,0.239917,0,0.842353,0.516605,-0.153496,0,-3.59725e-9,0.284818,0.958582,0,-7.44882,-35.7964,-13.3815,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'2bf667de-0ad4-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2bf667de-0ad4-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_09a2e393-74ab-40f4-9bff-bc038639effe_ACT_d27c23bb-fa1e-4cd8-bacc-e2b65114a20e_SESS_844480c5-a8a8-4eb3-a014-e1424d66a1ca_TOSC_4e142a49-a24c-434e-86df-a724494cc09a_PLY_','2021-12-30 18:05:18','2019-11-18 11:23:27','2bf667de-0ad4-11ea-947d-226cec7cb58a.ply','2021-12-30 19:05:18','SYNCED','2bf667de-0ad4-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.30.1.1\",\"modelMatrix\":\"0.108343,-0.934859,0.338084,0,0.994114,0.101885,-0.0368459,0,-2.12746e-9,0.340085,0.940394,0,-16.8929,-27.793,-27.3833,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'2bf84673-0ad4-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2bf84673-0ad4-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_09a2e393-74ab-40f4-9bff-bc038639effe_ACT_d27c23bb-fa1e-4cd8-bacc-e2b65114a20e_SESS_844480c5-a8a8-4eb3-a014-e1424d66a1ca_TOSC_4e142a49-a24c-434e-86df-a724494cc09a_SNAPS_','2021-12-30 18:05:20','2019-11-18 11:23:27','2bf84673-0ad4-11ea-947d-226cec7cb58a.png','2021-12-30 19:05:20','SYNCED','2bf84673-0ad4-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.30.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'2bf96d55-91a4-4fab-b559-00b59e443dca','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2bf96d55-91a4-4fab-b559-00b59e443dca.png','SNAPS','PATIENT_a38850a1-cad3-4402-b419-3e6d42249a53_ACT_f247cbbe-6a56-4c48-852f-b5c48e626d26_SESS_8226bbaa-5cce-4619-8dd0-58dac53b8bac_BOSC_60ffcbf1-fa90-453b-a320-ccf50b558c7b_SNAPS_','2021-08-19 22:44:58','2019-11-29 15:55:19','2bf96d55-91a4-4fab-b559-00b59e443dca.png','2021-08-20 00:44:58','SYNCED','2bf96d55-91a4-4fab-b559-00b59e443dca',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 217.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'2bfe1bcd-b27c-4bbd-9764-2f79849af4c8','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2bfe1bcd-b27c-4bbd-9764-2f79849af4c8.ply','PLY','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_9f394a6f-c380-47c1-9eab-ff46399f6197_SESS_c9ec17f4-bf0a-492f-87da-1f7550b49119_BOSC_e0c0ae20-9b2e-46bf-936c-fada35e02d52_PLY_','2021-02-14 13:51:52','2020-01-21 14:31:03','2bfe1bcd-b27c-4bbd-9764-2f79849af4c8.ply','2021-02-14 14:51:52','SYNCED','2bfe1bcd-b27c-4bbd-9764-2f79849af4c8',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.1.1.1.1\",\"modelMatrix\":\"-0.87172,0.480571,-0.095685,0,-0.490004,-0.854938,0.170224,0,2.44359e-9,0.195274,0.980749,0,-7.63925,22.1092,-19.9697,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'2bff468a-27bf-48bd-a948-3ee4db643dd0','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2bff468a-27bf-48bd-a948-3ee4db643dd0.ply','PLY','PATIENT_fa356cc1-2a61-41a9-97f5-eee3850a926c_ACT_94c1619e-6096-4464-837b-4b14ca5da156_SESS_fd9c0fc4-1c81-4aed-a4e0-992153cc0fef_BOSC_6f2a92f6-3650-49aa-b437-6acb1ae66cfb_PLY_','2022-02-01 11:48:33','2019-07-15 09:42:22','2bff468a-27bf-48bd-a948-3ee4db643dd0.ply','2022-02-01 12:48:33','SYNCED','2bff468a-27bf-48bd-a948-3ee4db643dd0',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 59.1.1.1\",\"modelMatrix\":\"-0.844562,-0.531795,0.0625302,0,0.535459,-0.838783,0.098627,0,-3.06647e-10,0.116779,0.993158,0,-30.0035,6.45574,-24.5444,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'2c09ea82-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c09ea82-c807-11e9-8df1-226cec7cb58a.stl','STL','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_BOSC_4130b951-2ea4-4c1e-9e71-e69c342e36b1_STL_','2022-02-01 11:48:33','2019-08-26 14:41:36','2c09ea82-c807-11e9-8df1-226cec7cb58a.stl','2022-02-01 12:48:33','SYNCED','2c09ea82-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 129.12.1.1\",\"modelMatrix\":\"-0.86495,0.497159,-0.0685085,0,-0.501857,-0.856853,0.118074,0,-5.63121e-9,0.13651,0.990639,0,-5.41015,22.1831,-19.7439,1\",\"title\":\"MANDIBULE STL\"}'),(2,'2c0a98e2-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c0a98e2-c807-11e9-8df1-226cec7cb58a.ply','PLY','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_BOSC_4130b951-2ea4-4c1e-9e71-e69c342e36b1_PLY_','2022-02-01 11:48:33','2019-08-26 14:41:36','2c0a98e2-c807-11e9-8df1-226cec7cb58a.ply','2022-02-01 12:48:33','SYNCED','2c0a98e2-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 129.12.1.1\",\"modelMatrix\":\"-0.86495,0.497159,-0.0685085,0,-0.501857,-0.856853,0.118074,0,-5.63121e-9,0.13651,0.990639,0,-5.41015,22.1831,-19.7439,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'2c0b3049-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c0b3049-c807-11e9-8df1-226cec7cb58a.stl','STL','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_TOSC_e9bb612d-7fee-4070-8a3a-42b5e7681803_STL_','2022-02-01 11:48:33','2019-08-26 14:33:24','2c0b3049-c807-11e9-8df1-226cec7cb58a.stl','2022-02-01 12:48:33','SYNCED','2c0b3049-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 129.12.1.1\",\"modelMatrix\":\"0.835322,-0.512426,0.199138,0,0.549761,0.778595,-0.302576,0,-2.47761e-9,0.362227,0.93209,0,10.3011,-32.9038,-31.5403,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'2c0bbad8-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c0bbad8-c807-11e9-8df1-226cec7cb58a.ply','PLY','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_TOSC_e9bb612d-7fee-4070-8a3a-42b5e7681803_PLY_','2022-02-01 11:48:35','2019-08-26 14:33:24','2c0bbad8-c807-11e9-8df1-226cec7cb58a.ply','2022-02-01 12:48:35','SYNCED','2c0bbad8-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 129.12.1.1\",\"modelMatrix\":\"0.835322,-0.512426,0.199138,0,0.549761,0.778595,-0.302576,0,-2.47761e-9,0.362227,0.93209,0,10.3011,-32.9038,-31.5403,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'2c0c5736-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c0c5736-c807-11e9-8df1-226cec7cb58a.png','SNAPS','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_TOSC_e9bb612d-7fee-4070-8a3a-42b5e7681803_SNAPS_','2022-02-01 11:48:36','2019-08-26 14:33:24','2c0c5736-c807-11e9-8df1-226cec7cb58a.png','2022-02-01 12:48:36','SYNCED','2c0c5736-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 129.12.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'2c0cfb71-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c0cfb71-c807-11e9-8df1-226cec7cb58a.png','SNAPS','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_BOSC_4130b951-2ea4-4c1e-9e71-e69c342e36b1_SNAPS_','2022-02-01 11:48:36','2019-08-26 14:41:36','2c0cfb71-c807-11e9-8df1-226cec7cb58a.png','2022-02-01 12:48:36','SYNCED','2c0cfb71-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 129.12.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'2c1ced35-a96a-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c1ced35-a96a-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_84fa6e96-515c-4fe4-a525-40d8d90556e5_SESS_e5c0e29e-2da1-43d2-8528-7646e6258f3d_BOSC_4791e9ff-d419-4d38-b26f-129464e6dad3_SNAPS_','2021-02-14 13:51:55','2020-06-08 11:25:47','2c1ced35-a96a-11ea-947d-226cec7cb58a.png','2021-02-14 14:51:55','SYNCED','2c1ced35-a96a-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.32.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'2c1ea733-a96a-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c1ea733-a96a-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_5db9ada8-a590-418d-abe2-c1b9515b2b06_ACT_84fa6e96-515c-4fe4-a525-40d8d90556e5_SESS_e5c0e29e-2da1-43d2-8528-7646e6258f3d_TOSC_654d7487-9b82-48a5-b260-89da24114906_PLY_','2021-02-14 13:51:55','2020-06-08 11:22:15','2c1ea733-a96a-11ea-947d-226cec7cb58a.ply','2021-02-14 14:51:55','SYNCED','2c1ea733-a96a-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.32.1.1\",\"modelMatrix\":\"0.753062,-0.602348,0.264716,0,0.65795,0.689423,-0.302983,0,8.13665e-9,0.402335,0.915492,0,10.4679,-29.6853,-18.4793,1\",\"title\":\"Maxillaire PLY\"}'),(2,'2c2066dd-a96a-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c2066dd-a96a-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_5db9ada8-a590-418d-abe2-c1b9515b2b06_ACT_84fa6e96-515c-4fe4-a525-40d8d90556e5_SESS_e5c0e29e-2da1-43d2-8528-7646e6258f3d_TOSC_654d7487-9b82-48a5-b260-89da24114906_SNAPS_','2021-02-14 13:51:55','2020-06-08 11:22:15','2c2066dd-a96a-11ea-947d-226cec7cb58a.png','2021-02-14 14:51:55','SYNCED','2c2066dd-a96a-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.32.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'2c20df3e-a097-402e-ba3c-cb6b750dea8c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c20df3e-a097-402e-ba3c-cb6b750dea8c.ply','PLY','PATIENT_7b336908-dd69-4fa5-bcb4-4369ef596b6f_ACT_0e76fa33-d14f-4600-848a-e4a51fbbe354_SESS_d0c44858-5836-4c42-87c4-9631221eb428_TOSC_4b7e5ca1-dba0-4593-aaea-173b96e206bb_PLY_','2021-02-14 13:51:56','2020-01-03 16:17:44','2c20df3e-a097-402e-ba3c-cb6b750dea8c.ply','2021-02-14 14:51:56','SYNCED','2c20df3e-a097-402e-ba3c-cb6b750dea8c',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"modelMatrix\":\"0.678281,-0.700929,0.220531,0,0.734803,0.647012,-0.203567,0,-1.34457e-8,0.300122,0.953901,0,2.60254,-34.8995,-10.3687,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'2c223cfe-a96a-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c223cfe-a96a-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_84fa6e96-515c-4fe4-a525-40d8d90556e5_SESS_e5c0e29e-2da1-43d2-8528-7646e6258f3d_BOSC_4791e9ff-d419-4d38-b26f-129464e6dad3_PLY_','2021-02-14 13:51:56','2020-06-08 11:25:47','2c223cfe-a96a-11ea-947d-226cec7cb58a.ply','2021-02-14 14:51:56','SYNCED','2c223cfe-a96a-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.32.1.1\",\"modelMatrix\":\"-0.889671,0.447814,-0.0891579,0,-0.456603,-0.872545,0.17372,0,8.97449e-10,0.195264,0.980751,0,-4.08742,21.8863,-18.7167,1\",\"title\":\"Mandibule PLY\"}'),(2,'2c282f50-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c282f50-c807-11e9-8df1-226cec7cb58a.stl','STL','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_BOSC_4130b951-2ea4-4c1e-9e71-e69c342e36b1_STL_','2022-02-01 11:48:36','2019-08-26 14:41:36','2c282f50-c807-11e9-8df1-226cec7cb58a.stl','2022-02-01 12:48:36','SYNCED','2c282f50-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 129.12.1.1\",\"modelMatrix\":\"-0.86495,0.497159,-0.0685085,0,-0.501857,-0.856853,0.118074,0,-5.63121e-9,0.13651,0.990639,0,-5.41015,22.1831,-19.7439,1\",\"title\":\"MANDIBULE STL\"}'),(2,'2c29265f-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c29265f-c807-11e9-8df1-226cec7cb58a.ply','PLY','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_BOSC_4130b951-2ea4-4c1e-9e71-e69c342e36b1_PLY_','2022-02-01 11:48:36','2019-08-26 14:41:36','2c29265f-c807-11e9-8df1-226cec7cb58a.ply','2022-02-01 12:48:36','SYNCED','2c29265f-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 129.12.1.1\",\"modelMatrix\":\"-0.86495,0.497159,-0.0685085,0,-0.501857,-0.856853,0.118074,0,-5.63121e-9,0.13651,0.990639,0,-5.41015,22.1831,-19.7439,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'2c29d40e-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c29d40e-c807-11e9-8df1-226cec7cb58a.stl','STL','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_TOSC_e9bb612d-7fee-4070-8a3a-42b5e7681803_STL_','2022-02-01 11:48:36','2019-08-26 14:33:24','2c29d40e-c807-11e9-8df1-226cec7cb58a.stl','2022-02-01 12:48:36','SYNCED','2c29d40e-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 129.12.1.1\",\"modelMatrix\":\"0.835322,-0.512426,0.199138,0,0.549761,0.778595,-0.302576,0,-2.47761e-9,0.362227,0.93209,0,10.3011,-32.9038,-31.5403,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'2c2a8006-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c2a8006-c807-11e9-8df1-226cec7cb58a.ply','PLY','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_TOSC_e9bb612d-7fee-4070-8a3a-42b5e7681803_PLY_','2022-02-01 11:48:37','2019-08-26 14:33:24','2c2a8006-c807-11e9-8df1-226cec7cb58a.ply','2022-02-01 12:48:37','SYNCED','2c2a8006-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 129.12.1.1\",\"modelMatrix\":\"0.835322,-0.512426,0.199138,0,0.549761,0.778595,-0.302576,0,-2.47761e-9,0.362227,0.93209,0,10.3011,-32.9038,-31.5403,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'2c2abe93-31eb-49f0-8258-fcc3ac0beea6','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c2abe93-31eb-49f0-8258-fcc3ac0beea6.ply','PLY','PATIENT_0880e4ab-6c5d-4b3d-9c49-8064a77d5d3f_ACT_7afe7778-e5f3-4e25-9a55-35d809c89b51_SESS_32c67196-65ac-4a5b-8953-2160d87c6f98_BOSC_c5cc8904-a4e0-453e-88c2-da69f9354a40_PLY_','2021-02-16 16:41:11','2019-12-12 14:21:02','2c2abe93-31eb-49f0-8258-fcc3ac0beea6.ply','2021-02-16 17:41:11','SYNCED','2c2abe93-31eb-49f0-8258-fcc3ac0beea6',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 232.13.1.1\",\"modelMatrix\":\"-0.982476,0.179113,-0.0515768,0,-0.186392,-0.944113,0.271863,0,1.36635e-9,0.276712,0.960953,0,-14.9169,21.2063,-14.6604,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'2c2b18d7-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c2b18d7-c807-11e9-8df1-226cec7cb58a.png','SNAPS','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_TOSC_e9bb612d-7fee-4070-8a3a-42b5e7681803_SNAPS_','2022-02-01 11:48:37','2019-08-26 14:33:24','2c2b18d7-c807-11e9-8df1-226cec7cb58a.png','2022-02-01 12:48:37','SYNCED','2c2b18d7-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 129.12.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'2c2bb2ca-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c2bb2ca-c807-11e9-8df1-226cec7cb58a.png','SNAPS','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_BOSC_4130b951-2ea4-4c1e-9e71-e69c342e36b1_SNAPS_','2022-02-01 11:48:37','2019-08-26 14:41:36','2c2bb2ca-c807-11e9-8df1-226cec7cb58a.png','2022-02-01 12:48:37','SYNCED','2c2bb2ca-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 129.12.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'2c39672b-b0b7-46b6-af67-4181e1175035','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c39672b-b0b7-46b6-af67-4181e1175035.ply','PLY','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_db56cba1-23ff-48bf-b86e-4ceff749087f_TOSC_95ba1b04-bad8-4550-9b06-d48a2e72b1f6_PLY_','2021-12-30 18:05:24','2019-11-14 14:39:44','2c39672b-b0b7-46b6-af67-4181e1175035.ply','2021-12-30 19:05:24','SYNCED','2c39672b-b0b7-46b6-af67-4181e1175035',0,NULL,'','','{\"displayTitle\":\"Mascella 0\",\"modelMatrix\":\"0.54134,-0.789131,0.290213,0,0.840804,0.508071,-0.18685,0,2.00403e-8,0.345162,0.938543,0,-0.711634,-32.4033,-23.4657,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'2c43156f-de0c-48ee-b88a-ae453e0b920c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c43156f-de0c-48ee-b88a-ae453e0b920c.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_4dd9e802-7e05-49b9-a508-4fb2c24adc7c_SNAPS_','2021-02-14 13:51:59','2020-01-24 13:10:47','2c43156f-de0c-48ee-b88a-ae453e0b920c.png','2021-02-14 14:51:59','SYNCED','2c43156f-de0c-48ee-b88a-ae453e0b920c',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.15\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'2c476757-5d07-48e7-838c-b3673ba73951','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c476757-5d07-48e7-838c-b3673ba73951.ply','PLY','PATIENT_3401487b-2a28-4a31-a1a5-2962b7a94938_ACT_cab66439-abe1-4bfb-8a17-7395e453d265_SESS_8ae4c6e7-18c8-4625-b317-f1628fda8690_BOSC_a616b6ac-f672-4cf0-8e0b-10e75e1a1cb7_PLY_','2022-02-01 11:48:37','2019-08-05 17:09:23','2c476757-5d07-48e7-838c-b3673ba73951.ply','2022-02-01 12:48:37','SYNCED','2c476757-5d07-48e7-838c-b3673ba73951',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 126.1.1.1\",\"modelMatrix\":\"-0.87883,0.471183,-0.0751322,0,-0.477136,-0.867866,0.138385,0,1.85727e-9,0.157465,0.987525,0,-1.65884,23.5427,-21.68,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'2c490f37-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c490f37-c807-11e9-8df1-226cec7cb58a.stl','STL','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_BOSC_4130b951-2ea4-4c1e-9e71-e69c342e36b1_STL_','2022-02-01 11:48:37','2019-08-26 14:41:36','2c490f37-c807-11e9-8df1-226cec7cb58a.stl','2022-02-01 12:48:37','SYNCED','2c490f37-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 129.12.1.1\",\"modelMatrix\":\"-0.86495,0.497159,-0.0685085,0,-0.501857,-0.856853,0.118074,0,-5.63121e-9,0.13651,0.990639,0,-5.41015,22.1831,-19.7439,1\",\"title\":\"MANDIBULE STL\"}'),(2,'2c4a91c6-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c4a91c6-c807-11e9-8df1-226cec7cb58a.ply','PLY','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_BOSC_4130b951-2ea4-4c1e-9e71-e69c342e36b1_PLY_','2022-02-01 11:48:37','2019-08-26 14:41:36','2c4a91c6-c807-11e9-8df1-226cec7cb58a.ply','2022-02-01 12:48:37','SYNCED','2c4a91c6-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 129.12.1.1\",\"modelMatrix\":\"-0.86495,0.497159,-0.0685085,0,-0.501857,-0.856853,0.118074,0,-5.63121e-9,0.13651,0.990639,0,-5.41015,22.1831,-19.7439,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'2c4b2cc4-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c4b2cc4-c807-11e9-8df1-226cec7cb58a.stl','STL','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_TOSC_e9bb612d-7fee-4070-8a3a-42b5e7681803_STL_','2022-02-01 11:48:38','2019-08-26 14:33:24','2c4b2cc4-c807-11e9-8df1-226cec7cb58a.stl','2022-02-01 12:48:38','SYNCED','2c4b2cc4-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 129.12.1.1\",\"modelMatrix\":\"0.835322,-0.512426,0.199138,0,0.549761,0.778595,-0.302576,0,-2.47761e-9,0.362227,0.93209,0,10.3011,-32.9038,-31.5403,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'2c4bc111-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c4bc111-c807-11e9-8df1-226cec7cb58a.ply','PLY','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_TOSC_e9bb612d-7fee-4070-8a3a-42b5e7681803_PLY_','2022-02-01 11:48:38','2019-08-26 14:33:24','2c4bc111-c807-11e9-8df1-226cec7cb58a.ply','2022-02-01 12:48:38','SYNCED','2c4bc111-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 129.12.1.1\",\"modelMatrix\":\"0.835322,-0.512426,0.199138,0,0.549761,0.778595,-0.302576,0,-2.47761e-9,0.362227,0.93209,0,10.3011,-32.9038,-31.5403,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'2c4c27e6-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c4c27e6-c807-11e9-8df1-226cec7cb58a.png','SNAPS','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_TOSC_e9bb612d-7fee-4070-8a3a-42b5e7681803_SNAPS_','2022-02-01 11:48:38','2019-08-26 14:33:24','2c4c27e6-c807-11e9-8df1-226cec7cb58a.png','2022-02-01 12:48:38','SYNCED','2c4c27e6-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 129.12.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'2c4cd5d9-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c4cd5d9-c807-11e9-8df1-226cec7cb58a.png','SNAPS','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_BOSC_4130b951-2ea4-4c1e-9e71-e69c342e36b1_SNAPS_','2022-02-01 11:48:38','2019-08-26 14:41:36','2c4cd5d9-c807-11e9-8df1-226cec7cb58a.png','2022-02-01 12:48:38','SYNCED','2c4cd5d9-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 129.12.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'2c5b04da-8da7-4cfa-808f-5a826bc797d9','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c5b04da-8da7-4cfa-808f-5a826bc797d9.png','SNAPS','PATIENT_dc75e1af-fe4f-4b70-865b-512dbaca7415_ACT_c251045a-a425-4792-bd94-aa56eccd090f_SESS_d03ab951-0779-4a64-9b39-14d6013484f6_BOSC_69631055-f05c-45d0-af4e-73e36c67ae02_SNAPS_','2021-02-16 16:41:15','2019-12-12 11:30:03','2c5b04da-8da7-4cfa-808f-5a826bc797d9.png','2021-02-16 17:41:15','SYNCED','2c5b04da-8da7-4cfa-808f-5a826bc797d9',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 232.8.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'2c5ce2ea-b5f9-4743-a648-42bc0b172041','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c5ce2ea-b5f9-4743-a648-42bc0b172041.stl','STL','PATIENT_f3643223-109c-4b7b-b99b-b1d8d4b1a362_ACT_77ca47a4-b59a-46a1-9669-cee3ca3573c5_SESS_3a3e4e3e-9d64-4866-be9f-bf17cc7e6576_TOSC_6b78f2c1-fe50-4eb5-8af4-c5e0a8065320_STL_','2022-02-01 11:48:39','2019-09-20 12:02:03','2c5ce2ea-b5f9-4743-a648-42bc0b172041.stl','2022-02-01 12:48:39','SYNCED','2c5ce2ea-b5f9-4743-a648-42bc0b172041',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 160.1.1.1\",\"modelMatrix\":\"0.134036,-0.92888,0.345278,0,0.990976,0.125637,-0.0467011,0,2.28503e-9,0.348422,0.937338,0,-14.8716,-36.4844,-16.9012,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'2c655cd1-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c655cd1-c807-11e9-8df1-226cec7cb58a.stl','STL','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_BOSC_4130b951-2ea4-4c1e-9e71-e69c342e36b1_STL_','2022-02-01 11:48:39','2019-08-26 14:41:36','2c655cd1-c807-11e9-8df1-226cec7cb58a.stl','2022-02-01 12:48:39','SYNCED','2c655cd1-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 129.12.1.1\",\"modelMatrix\":\"-0.86495,0.497159,-0.0685085,0,-0.501857,-0.856853,0.118074,0,-5.63121e-9,0.13651,0.990639,0,-5.41015,22.1831,-19.7439,1\",\"title\":\"MANDIBULE STL\"}'),(2,'2c661576-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c661576-c807-11e9-8df1-226cec7cb58a.ply','PLY','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_BOSC_4130b951-2ea4-4c1e-9e71-e69c342e36b1_PLY_','2022-02-01 11:48:39','2019-08-26 14:41:36','2c661576-c807-11e9-8df1-226cec7cb58a.ply','2022-02-01 12:48:39','SYNCED','2c661576-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 129.12.1.1\",\"modelMatrix\":\"-0.86495,0.497159,-0.0685085,0,-0.501857,-0.856853,0.118074,0,-5.63121e-9,0.13651,0.990639,0,-5.41015,22.1831,-19.7439,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'2c66c2d8-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c66c2d8-c807-11e9-8df1-226cec7cb58a.stl','STL','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_TOSC_e9bb612d-7fee-4070-8a3a-42b5e7681803_STL_','2022-02-01 11:48:39','2019-08-26 14:33:24','2c66c2d8-c807-11e9-8df1-226cec7cb58a.stl','2022-02-01 12:48:39','SYNCED','2c66c2d8-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 129.12.1.1\",\"modelMatrix\":\"0.835322,-0.512426,0.199138,0,0.549761,0.778595,-0.302576,0,-2.47761e-9,0.362227,0.93209,0,10.3011,-32.9038,-31.5403,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'2c67215f-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c67215f-c807-11e9-8df1-226cec7cb58a.ply','PLY','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_TOSC_e9bb612d-7fee-4070-8a3a-42b5e7681803_PLY_','2022-02-01 11:48:40','2019-08-26 14:33:24','2c67215f-c807-11e9-8df1-226cec7cb58a.ply','2022-02-01 12:48:40','SYNCED','2c67215f-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 129.12.1.1\",\"modelMatrix\":\"0.835322,-0.512426,0.199138,0,0.549761,0.778595,-0.302576,0,-2.47761e-9,0.362227,0.93209,0,10.3011,-32.9038,-31.5403,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'2c67d0d1-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c67d0d1-c807-11e9-8df1-226cec7cb58a.png','SNAPS','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_TOSC_e9bb612d-7fee-4070-8a3a-42b5e7681803_SNAPS_','2022-02-01 11:48:40','2019-08-26 14:33:24','2c67d0d1-c807-11e9-8df1-226cec7cb58a.png','2022-02-01 12:48:40','SYNCED','2c67d0d1-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 129.12.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'2c686be0-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c686be0-c807-11e9-8df1-226cec7cb58a.png','SNAPS','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_BOSC_4130b951-2ea4-4c1e-9e71-e69c342e36b1_SNAPS_','2022-02-01 11:48:40','2019-08-26 14:41:36','2c686be0-c807-11e9-8df1-226cec7cb58a.png','2022-02-01 12:48:40','SYNCED','2c686be0-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 129.12.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'2c760f36-ad70-4ebf-8cab-32a7c69c3458','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c760f36-ad70-4ebf-8cab-32a7c69c3458.stl','STL','PATIENT_990204e3-cf2f-4026-952f-1dddcf7ba877_ACT_7cc92ba2-1d5b-419e-a74a-49ee200bad42_SESS_12c31307-3c9f-4293-9271-370e33e4c708_TOSC_c193f66e-9b14-4e27-8f24-25c41a008157_STL_','2022-02-01 11:48:41','2019-07-12 13:59:20','2c760f36-ad70-4ebf-8cab-32a7c69c3458.stl','2022-02-01 12:48:41','SYNCED','2c760f36-ad70-4ebf-8cab-32a7c69c3458',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 56.1.1.1\",\"modelMatrix\":\"0.707448,-0.677626,0.200847,0,0.706765,0.678282,-0.201041,0,-7.68818e-9,0.284178,0.958772,0,3.48375,-35.3691,-16.2954,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'2c834028-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c834028-c807-11e9-8df1-226cec7cb58a.stl','STL','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_BOSC_4130b951-2ea4-4c1e-9e71-e69c342e36b1_STL_','2022-02-01 11:48:41','2019-08-26 14:41:36','2c834028-c807-11e9-8df1-226cec7cb58a.stl','2022-02-01 12:48:41','SYNCED','2c834028-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 129.12.1.1\",\"modelMatrix\":\"-0.86495,0.497159,-0.0685085,0,-0.501857,-0.856853,0.118074,0,-5.63121e-9,0.13651,0.990639,0,-5.41015,22.1831,-19.7439,1\",\"title\":\"MANDIBULE STL\"}'),(2,'2c83f221-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c83f221-c807-11e9-8df1-226cec7cb58a.ply','PLY','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_BOSC_4130b951-2ea4-4c1e-9e71-e69c342e36b1_PLY_','2022-02-01 11:48:41','2019-08-26 14:41:36','2c83f221-c807-11e9-8df1-226cec7cb58a.ply','2022-02-01 12:48:41','SYNCED','2c83f221-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 129.12.1.1\",\"modelMatrix\":\"-0.86495,0.497159,-0.0685085,0,-0.501857,-0.856853,0.118074,0,-5.63121e-9,0.13651,0.990639,0,-5.41015,22.1831,-19.7439,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'2c845c0f-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c845c0f-c807-11e9-8df1-226cec7cb58a.stl','STL','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_TOSC_e9bb612d-7fee-4070-8a3a-42b5e7681803_STL_','2022-02-01 11:48:41','2019-08-26 14:33:24','2c845c0f-c807-11e9-8df1-226cec7cb58a.stl','2022-02-01 12:48:41','SYNCED','2c845c0f-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 129.12.1.1\",\"modelMatrix\":\"0.835322,-0.512426,0.199138,0,0.549761,0.778595,-0.302576,0,-2.47761e-9,0.362227,0.93209,0,10.3011,-32.9038,-31.5403,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'2c84fcfc-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c84fcfc-c807-11e9-8df1-226cec7cb58a.ply','PLY','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_TOSC_e9bb612d-7fee-4070-8a3a-42b5e7681803_PLY_','2022-02-01 11:48:41','2019-08-26 14:33:24','2c84fcfc-c807-11e9-8df1-226cec7cb58a.ply','2022-02-01 12:48:41','SYNCED','2c84fcfc-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 129.12.1.1\",\"modelMatrix\":\"0.835322,-0.512426,0.199138,0,0.549761,0.778595,-0.302576,0,-2.47761e-9,0.362227,0.93209,0,10.3011,-32.9038,-31.5403,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'2c855f7b-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c855f7b-c807-11e9-8df1-226cec7cb58a.png','SNAPS','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_TOSC_e9bb612d-7fee-4070-8a3a-42b5e7681803_SNAPS_','2022-02-01 11:48:42','2019-08-26 14:33:24','2c855f7b-c807-11e9-8df1-226cec7cb58a.png','2022-02-01 12:48:42','SYNCED','2c855f7b-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 129.12.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'2c85b936-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c85b936-c807-11e9-8df1-226cec7cb58a.png','SNAPS','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_BOSC_4130b951-2ea4-4c1e-9e71-e69c342e36b1_SNAPS_','2022-02-01 11:48:42','2019-08-26 14:41:36','2c85b936-c807-11e9-8df1-226cec7cb58a.png','2022-02-01 12:48:42','SYNCED','2c85b936-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 129.12.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'2c899520-b395-4016-99fa-a0c8f851692c','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c899520-b395-4016-99fa-a0c8f851692c.ply','PLY','PATIENT_153fda23-4057-4aa4-ad8e-a2219ba8709a_ACT_edebfba1-d015-4db4-98c1-53ee82436ef3_SESS_9f88bc21-067f-4fac-81c3-ffd767b950d9_TOSC_5e24d8af-6468-4b63-9c23-6ef1838a04ea_PLY_','2022-03-04 13:40:32','2019-07-10 15:49:06','2c899520-b395-4016-99fa-a0c8f851692c.ply','2022-03-04 14:40:32','SYNCED','2c899520-b395-4016-99fa-a0c8f851692c',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 29.1.1.1\",\"modelMatrix\":\"0.873852,-0.46087,0.15486,0,0.486192,0.82834,-0.278336,0,2.27848e-10,0.318516,0.947918,0,4.409,-40.1998,-15.7738,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'2c8ddbe6-965f-4ecb-a172-27480efc39e9','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c8ddbe6-965f-4ecb-a172-27480efc39e9.ply','PLY','PATIENT_122acf86-9495-47dc-8057-d52aa776a132_ACT_a61cb7fa-9dd1-4448-90a4-f960adaae7cd_SESS_41526972-e2a6-4a0c-af87-a97372b95d6e_TOSC_1424bc5a-c69a-4495-9f44-21915a33118b_PLY_','2022-02-01 11:48:42','2019-07-17 15:27:02','2c8ddbe6-965f-4ecb-a172-27480efc39e9.ply','2022-02-01 12:48:42','SYNCED','84e236dc-0f2d-497b-85d5-805f3dec1b18',1,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 90.1.1.1\",\"modelMatrix\":\"0.358192,-0.894999,0.26585,0,0.933648,0.343364,-0.101993,0,7.66349e-9,0.284743,0.958604,0,-7.42623,-35.2604,-18.4788,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'2c90cee9-6b4a-41f0-a1c3-abef49d433b7','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2c90cee9-6b4a-41f0-a1c3-abef49d433b7.png','SNAPS','PATIENT_afb3c9b5-2f4f-49d3-a88c-881650a2af06_ACT_1fa339a4-2a8b-463e-b059-c6c128d1833a_SESS_c1582cec-097b-4b91-bd3d-267379a14aba_TOSC_1a4f8e15-b5dc-4184-a5f8-384e8070edd7_SNAPS_','2021-02-16 16:41:21','2019-12-12 14:30:18','2c90cee9-6b4a-41f0-a1c3-abef49d433b7.png','2021-02-16 17:41:21','SYNCED','2c90cee9-6b4a-41f0-a1c3-abef49d433b7',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 232.14.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'2ca289b5-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2ca289b5-c807-11e9-8df1-226cec7cb58a.stl','STL','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_BOSC_4130b951-2ea4-4c1e-9e71-e69c342e36b1_STL_','2022-02-01 11:48:42','2019-08-26 14:41:36','2ca289b5-c807-11e9-8df1-226cec7cb58a.stl','2022-02-01 12:48:42','SYNCED','2ca289b5-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 129.12.1.1\",\"modelMatrix\":\"-0.86495,0.497159,-0.0685085,0,-0.501857,-0.856853,0.118074,0,-5.63121e-9,0.13651,0.990639,0,-5.41015,22.1831,-19.7439,1\",\"title\":\"MANDIBULE STL\"}'),(2,'2ca32983-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2ca32983-c807-11e9-8df1-226cec7cb58a.ply','PLY','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_BOSC_4130b951-2ea4-4c1e-9e71-e69c342e36b1_PLY_','2022-02-01 11:48:43','2019-08-26 14:41:36','2ca32983-c807-11e9-8df1-226cec7cb58a.ply','2022-02-01 12:48:43','SYNCED','2ca32983-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 129.12.1.1\",\"modelMatrix\":\"-0.86495,0.497159,-0.0685085,0,-0.501857,-0.856853,0.118074,0,-5.63121e-9,0.13651,0.990639,0,-5.41015,22.1831,-19.7439,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'2ca3979d-c807-11e9-8df1-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2ca3979d-c807-11e9-8df1-226cec7cb58a.stl','STL','PATIENT_e57f7aa2-0e91-48a5-96fa-2bf1413e9d2a_ACT_edded955-bd28-459d-8a2a-8dcc17dfbe19_SESS_2df0c552-214c-4f59-8232-a605d89f120b_TOSC_e9bb612d-7fee-4070-8a3a-42b5e7681803_STL_','2022-02-01 11:48:43','2019-08-26 14:33:24','2ca3979d-c807-11e9-8df1-226cec7cb58a.stl','2022-02-01 12:48:43','SYNCED','2ca3979d-c807-11e9-8df1-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 129.12.1.1\",\"modelMatrix\":\"0.835322,-0.512426,0.199138,0,0.549761,0.778595,-0.302576,0,-2.47761e-9,0.362227,0.93209,0,10.3011,-32.9038,-31.5403,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'2ca4bacc-6fee-4f0e-8155-5f122048122f','/var/.data/2020/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2ca4bacc-6fee-4f0e-8155-5f122048122f.png','SNAPS','PATIENT_f378056d-f37c-4a09-952d-c4874c6a7590_ACT_7b843882-d3fe-43f2-8383-c119292fa05e_SESS_d860ca72-5a30-47ca-89d8-76b73a3fde3c_BOSC_fa1c2d54-7543-4725-b6f3-66eef2c50a1a_SNAPS_','2022-03-04 13:40:32','2019-07-08 16:41:32','2ca4bacc-6fee-4f0e-8155-5f122048122f.png','2022-03-04 14:40:32','SYNCED','2ca4bacc-6fee-4f0e-8155-5f1220