-- MySQL dump 10.13  Distrib 8.0.28, for Linux (x86_64)
--
-- Host: localhost    Database: condor_patient_local
-- ------------------------------------------------------
-- Server version	8.0.28-0ubuntu0.20.04.3

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `AddressInfo`
--

DROP TABLE IF EXISTS `AddressInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AddressInfo` (
  `id` varchar(36) NOT NULL,
  `line_0` varchar(255) DEFAULT NULL,
  `line_1` varchar(255) DEFAULT NULL,
  `line_2` varchar(255) DEFAULT NULL,
  `detail` varchar(255) DEFAULT NULL,
  `cityName` varchar(255) DEFAULT NULL,
  `cityState` varchar(255) DEFAULT NULL,
  `cityZip` varchar(25) DEFAULT NULL,
  `countryName` varchar(255) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AddressInfo`
--

LOCK TABLES `AddressInfo` WRITE;
/*!40000 ALTER TABLE `AddressInfo` DISABLE KEYS */;
INSERT INTO `AddressInfo` VALUES ('05b90417-a3ff-49fb-8e2c-2ead84c12e8e','','','',NULL,'','','','',NULL,NULL,'2022-03-04 14:51:03'),('10ea18ee-fd4b-41f0-93b8-700258c9cd5a','','','',NULL,'','','','',NULL,NULL,'2022-03-04 14:29:59'),('117a7f7b-2201-47b4-bd94-510d87c9270e','','','',NULL,'','','','',NULL,NULL,'2022-03-04 14:51:48'),('1a22c043-9653-4f2a-b542-74efddd3011f','','','',NULL,'','','','',NULL,NULL,'2022-03-04 14:27:29'),('524-10','','','',NULL,'','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-11','','','',NULL,'','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-12','','','',NULL,'','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-13','','','',NULL,'','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-14','','','',NULL,'','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-15','','','',NULL,'','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-16','','','',NULL,'','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-17','','','',NULL,'','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-18','','','',NULL,'','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-19','','','',NULL,'','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-2','','','',NULL,'','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-20','','','',NULL,'','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-21','','','',NULL,'','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-22','','','',NULL,'','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-23','','','',NULL,'','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-24','','','',NULL,'','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-25','','','',NULL,'','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-26','','','',NULL,'','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-27','','','',NULL,'','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-28','','','',NULL,'','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-29','','','',NULL,'','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-3','','','',NULL,'','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-30','','','',NULL,'','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-31','','','',NULL,'','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-32','','','',NULL,'','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-33','','','',NULL,'','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-34','','','',NULL,'','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-35','','','',NULL,'','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-4','','','',NULL,'','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-5','','','',NULL,'','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-6','','','',NULL,'','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-7','','','',NULL,'','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-8','','','',NULL,'','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-9','','','',NULL,'','','','',NULL,NULL,'2022-03-04 11:18:58'),('722896de-584a-4e61-aa53-1dd219235345','','','',NULL,'','','','',NULL,NULL,'2022-03-04 14:51:03'),('7ec5c22f-7d1b-4c87-a86d-1381fe4036c8','','','',NULL,'','','','',NULL,NULL,'2022-03-04 14:51:48'),('a105b5b8-ad69-4035-a44c-57d36610c460','','','',NULL,'','','','',NULL,NULL,'2022-03-04 14:27:29'),('a6cebe97-e343-4ed0-b2f2-37bae8629771','','','',NULL,'','','','',NULL,NULL,'2022-03-04 14:29:59'),('e4ebd75e-2dfc-41e4-a672-a1fe459bf867','','','',NULL,'','','','',NULL,NULL,'2023-02-02 11:29:37'),('ecc8827b-41e0-4094-af48-815f1e5f8e6e','','','',NULL,'','','','',NULL,NULL,'2023-02-02 11:29:37');
/*!40000 ALTER TABLE `AddressInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `DownloadRequest`
--

DROP TABLE IF EXISTS `DownloadRequest`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DownloadRequest` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `patientID` char(36) NOT NULL,
  `createdAt` datetime NOT NULL,
  `sentAt` datetime DEFAULT NULL,
  `token` char(40) DEFAULT NULL,
  `locale` char(5) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_DownloadRequest_Patient` (`patientID`),
  CONSTRAINT `fk_DownloadRequest_Patient` FOREIGN KEY (`patientID`) REFERENCES `Patient` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DownloadRequest`
--

LOCK TABLES `DownloadRequest` WRITE;
/*!40000 ALTER TABLE `DownloadRequest` DISABLE KEYS */;
/*!40000 ALTER TABLE `DownloadRequest` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `EmergencyContact`
--

DROP TABLE IF EXISTS `EmergencyContact`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `EmergencyContact` (
  `id` varchar(36) NOT NULL,
  `personInfoID` varchar(36) DEFAULT NULL,
  `phoneInfoID` varchar(36) DEFAULT NULL,
  `addressInfoID` varchar(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_EmergencyContact_AddressInfo` (`addressInfoID`),
  KEY `fk_EmergencyContact_PersonInfo` (`personInfoID`),
  KEY `fk_EmergencyContact_PhoneInfo` (`phoneInfoID`),
  CONSTRAINT `fk_EmergencyContact_AddressInfo` FOREIGN KEY (`addressInfoID`) REFERENCES `AddressInfo` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_EmergencyContact_PersonInfo` FOREIGN KEY (`personInfoID`) REFERENCES `PersonInfo` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_EmergencyContact_PhoneInfo` FOREIGN KEY (`phoneInfoID`) REFERENCES `PhoneInfo` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `EmergencyContact`
--

LOCK TABLES `EmergencyContact` WRITE;
/*!40000 ALTER TABLE `EmergencyContact` DISABLE KEYS */;
INSERT INTO `EmergencyContact` VALUES ('1d013017-9fe0-4b2a-a057-c0d8c74d46a9','72554025-cd8b-4cb5-8f80-395a81adc0d1','8c1fc566-43fc-4590-b3d9-4c193b539136','7ec5c22f-7d1b-4c87-a86d-1381fe4036c8',NULL,NULL,'2022-03-04 14:51:48'),('524-1','524-3','524-3','524-3',NULL,NULL,'2022-03-04 11:18:58'),('524-10','524-21','524-30','524-21',NULL,NULL,'2022-03-04 11:18:58'),('524-11','524-23','524-33','524-23',NULL,NULL,'2022-03-04 11:18:58'),('524-12','524-25','524-36','524-25',NULL,NULL,'2022-03-04 11:18:58'),('524-13','524-27','524-39','524-27',NULL,NULL,'2022-03-04 11:18:58'),('524-14','524-29','524-42','524-29',NULL,NULL,'2022-03-04 11:18:58'),('524-15','524-31','524-45','524-31',NULL,NULL,'2022-03-04 11:18:58'),('524-16','524-33','524-48','524-33',NULL,NULL,'2022-03-04 11:18:58'),('524-17','524-35','524-51','524-35',NULL,NULL,'2022-03-04 11:18:58'),('524-2','524-5','524-6','524-5',NULL,NULL,'2022-03-04 11:18:58'),('524-3','524-7','524-9','524-7',NULL,NULL,'2022-03-04 11:18:58'),('524-4','524-9','524-12','524-9',NULL,NULL,'2022-03-04 11:18:58'),('524-5','524-11','524-15','524-11',NULL,NULL,'2022-03-04 11:18:58'),('524-6','524-13','524-18','524-13',NULL,NULL,'2022-03-04 11:18:58'),('524-7','524-15','524-21','524-15',NULL,NULL,'2022-03-04 11:18:58'),('524-8','524-17','524-24','524-17',NULL,NULL,'2022-03-04 11:18:58'),('524-9','524-19','524-27','524-19',NULL,NULL,'2022-03-04 11:18:58'),('59f08df5-464a-4e1f-a094-7ad096f2301a','f903b55e-d4b2-4149-98dd-f28d09df2c7e','36a5f3c2-6cee-42a2-ac92-ba6eefbddf14','a105b5b8-ad69-4035-a44c-57d36610c460',NULL,NULL,'2022-03-04 14:27:29'),('7fc6370d-a729-4276-a6d1-6d0cc02a8b35','a98bb13f-9136-4f00-a7a0-6f8d694ef562','4ce0cebf-0f94-43cc-8728-ed2edac9d7b1','10ea18ee-fd4b-41f0-93b8-700258c9cd5a',NULL,NULL,'2022-03-04 14:29:59'),('83610f5a-2d70-4a59-b366-9d4ea8ec4963','07014444-ac05-49c8-8d6e-c43f95e41558','c6c62b92-67e6-4304-be9d-9060985d60f8','05b90417-a3ff-49fb-8e2c-2ead84c12e8e',NULL,NULL,'2022-03-04 14:51:03'),('ae8b59f6-8594-4173-927b-88bb56474152','4e6c8ccf-7df1-4cd8-8b0c-1c1d6d535994','63bfb645-ba8d-4a57-bf7d-c618ba884015','e4ebd75e-2dfc-41e4-a672-a1fe459bf867',NULL,NULL,'2023-02-02 11:29:37');
/*!40000 ALTER TABLE `EmergencyContact` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `EmergencyContact_AFTER_DELETE` AFTER DELETE ON `EmergencyContact` FOR EACH ROW BEGIN
	DELETE FROM PersonInfo 	WHERE id = OLD.personInfoID;
	DELETE FROM AddressInfo	WHERE id = OLD.addressInfoID;
	DELETE FROM PhoneInfo   WHERE id = OLD.phoneInfoID;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `Patient`
--

DROP TABLE IF EXISTS `Patient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Patient` (
  `id` varchar(36) NOT NULL,
  `globalDisplayID` mediumint unsigned DEFAULT NULL,
  `displayID` mediumint unsigned DEFAULT NULL,
  `socialSecurity` varchar(255) DEFAULT NULL,
  `allergies` varchar(255) DEFAULT NULL,
  `personInfoID` varchar(36) DEFAULT NULL,
  `phoneInfoID` varchar(36) DEFAULT NULL,
  `addressInfoID` varchar(36) DEFAULT NULL,
  `emergencyContactID` varchar(36) DEFAULT NULL,
  `practitionerID` varchar(36) DEFAULT NULL,
  `comments` text,
  `privateComments` text,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_Patient_AddressInfo` (`addressInfoID`),
  KEY `fk_Patient_EmergencyContact` (`emergencyContactID`),
  KEY `fk_Patient_PersonInfo` (`personInfoID`),
  KEY `fk_Patient_PhoneInfo` (`phoneInfoID`),
  KEY `fk_Patient_Practitioner` (`practitionerID`),
  CONSTRAINT `fk_Patient_AddressInfo` FOREIGN KEY (`addressInfoID`) REFERENCES `AddressInfo` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Patient_EmergencyContact` FOREIGN KEY (`emergencyContactID`) REFERENCES `EmergencyContact` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Patient_PersonInfo` FOREIGN KEY (`personInfoID`) REFERENCES `PersonInfo` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Patient_PhoneInfo` FOREIGN KEY (`phoneInfoID`) REFERENCES `PhoneInfo` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Patient_Practitioner` FOREIGN KEY (`practitionerID`) REFERENCES `Practitioner` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Patient`
--

LOCK TABLES `Patient` WRITE;
/*!40000 ALTER TABLE `Patient` DISABLE KEYS */;
INSERT INTO `Patient` VALUES ('0934e6d0-76ee-4665-be49-a74de2291879',1,9,'','','524-18','524-26','524-18','524-9','524-9','','',NULL,NULL,'2020-01-23 09:35:30','2020-01-23 09:35:30','2022-03-04 11:18:58','2020-01-23 09:24:26'),('182873b3-d53c-4aaf-9465-b1e9b4278e75',1,17,'','','524-34','524-50','524-34','524-17','524-17','','',NULL,NULL,NULL,NULL,'2022-03-04 11:18:58','2020-09-30 12:35:09'),('20e6ca25-7792-47c0-aeec-6eb5901306f8',1,8,'','','524-16','524-23','524-16','524-8','524-8','','',NULL,NULL,'2020-01-23 09:24:16',NULL,'2022-03-04 11:18:58','2020-01-23 08:56:00'),('2a40421f-a9d5-41ba-9038-ffb6617b8b4b',1,2,'','','524-4','524-5','524-4','524-2','524-2','','',NULL,NULL,NULL,'2020-01-22 13:28:34','2022-03-04 14:29:24','2020-01-22 13:28:33'),('37e30dc1-659c-4c18-943a-7301f67af622',1,6,'','','524-12','524-17','524-12','524-6','524-6','','',NULL,NULL,'2020-01-23 09:24:26','2020-01-23 09:24:26','2022-03-04 11:18:58','2020-01-23 08:55:02'),('40fa3bff-2fd4-4187-bdbd-2e2d0bd52f68',1,11,'','','524-22','524-32','524-22','524-11','524-11','','',NULL,NULL,'2020-01-23 10:57:17',NULL,'2022-03-04 11:18:58','2020-01-23 10:53:43'),('46784e98-9d89-44f5-8232-33e8d9da1922',1,10,'','','524-20','524-29','524-20','524-10','524-10','','',NULL,NULL,'2020-01-23 09:28:10',NULL,'2022-03-04 11:18:58','2020-01-23 09:25:58'),('49c43baf-3cdd-4573-b760-bac3879a4a8c',1,20,'','','b6a360ce-c47f-429b-823d-508a30eefd4c','146b1965-477f-4da1-8335-af14e962c1fe','722896de-584a-4e61-aa53-1dd219235345','83610f5a-2d70-4a59-b366-9d4ea8ec4963','12ceee59-a11f-4fe8-b114-7267eb6e6da0','','',NULL,NULL,NULL,NULL,'2022-03-04 14:51:03','2022-03-04 15:51:03'),('5e1c39c4-bfce-46b5-924b-131fc5789ca0',1,3,'','','524-6','524-8','524-6','524-3','524-3','','',NULL,NULL,NULL,'2020-01-23 08:29:32','2022-03-04 11:18:58','2020-01-22 14:04:53'),('5ed9b6f7-72bc-4520-ad4a-c429d25af1fc',1,1,'','','524-2','524-2','524-2','524-1','524-1','','',NULL,NULL,'2020-01-22 13:27:47','2020-01-22 13:27:47','2022-03-04 11:18:58','2020-01-22 13:27:25'),('70cc3a46-c5c6-4886-8f7d-34da7ab423b9',1,18,'','','993f4422-c1d9-4711-a5b4-b4a5cb3cc15a','fb694096-4a05-4efa-ba60-c756fe92f81b','1a22c043-9653-4f2a-b542-74efddd3011f','59f08df5-464a-4e1f-a094-7ad096f2301a','d42ac28b-4bad-4087-910c-7e73e2e8e9df','','',NULL,NULL,'2022-03-04 15:28:47',NULL,'2022-03-04 14:28:47','2022-03-04 15:27:29'),('77a534cd-8e81-4d67-9393-9f9a9b03e52c',1,14,'','','524-28','524-41','524-28','524-14','524-14','','',NULL,NULL,NULL,'2020-02-11 08:59:10','2022-03-04 11:18:58','2020-02-08 09:33:22'),('8acd5db9-383d-4654-9948-3c74894f71af',1,21,'','','bf622b96-473c-47f6-a0e4-91ac17577737','f4dfad69-94ea-4c1a-a422-6f735a17a6bc','117a7f7b-2201-47b4-bd94-510d87c9270e','1d013017-9fe0-4b2a-a057-c0d8c74d46a9','815e815b-d1cf-4dea-a354-cf48472a2c96','','',NULL,NULL,'2023-02-02 12:29:32',NULL,'2023-02-02 11:29:32','2022-03-04 15:51:48'),('93ee4723-881c-4e19-a7de-b884552ebd9e',1,4,'','','524-8','524-11','524-8','524-4','524-4','','',NULL,NULL,'2020-01-22 14:55:11',NULL,'2022-03-04 11:18:58','2020-01-22 14:45:07'),('ae1b89fc-1858-4a4a-9e42-3fd133abcb1c',1,7,'','','524-14','524-20','524-14','524-7','524-7','','',NULL,NULL,'2020-01-23 08:55:45',NULL,'2022-03-04 11:18:58','2020-01-23 08:55:32'),('b1226e29-6a03-40b5-bf0a-543a6cddb914',1,5,'','','524-10','524-14','524-10','524-5','524-5','','',NULL,NULL,'2020-01-23 08:54:59','2020-01-23 08:54:59','2022-03-04 11:18:58','2020-01-23 08:49:58'),('b9ea15f7-ef29-4ade-b8c3-2c04434862a1',1,22,'','','6738af39-bb7d-4a92-9e6d-9fb099fed33f','0d4a72d8-1668-4496-bb85-38237a3b1de1','ecc8827b-41e0-4094-af48-815f1e5f8e6e','ae8b59f6-8594-4173-927b-88bb56474152','31112d05-5090-4531-ad0b-06508a9a9e7a','','',NULL,NULL,NULL,NULL,'2023-02-02 11:29:37','2023-02-02 12:29:37'),('bf69875d-af07-40ca-a97f-9643150c5913',1,16,'','','524-32','524-47','524-32','524-16','524-16','','',NULL,NULL,'2020-09-30 12:09:50','2020-09-30 12:09:50','2022-03-04 11:18:58','2020-09-30 12:09:45'),('c7c5c1f3-addc-49f3-a0b7-bebfd70b71ba',1,15,'','','524-30','524-44','524-30','524-15','524-15','','',NULL,NULL,NULL,'2020-09-30 12:09:16','2022-03-04 11:18:58','2020-07-16 14:54:40'),('ca68987b-cfa7-4f89-ae77-d77610474e05',1,13,'','','524-26','524-38','524-26','524-13','524-13','','',NULL,NULL,NULL,'2020-02-03 18:29:58','2022-03-04 11:18:58','2020-02-03 18:29:57'),('e24bfe17-3078-4656-88ba-8371e0369a7b',1,12,'','','524-24','524-35','524-24','524-12','524-12','','',NULL,NULL,'2020-01-25 09:09:31',NULL,'2022-03-04 11:18:58','2020-01-24 08:24:38'),('f873a927-05d1-4b46-8446-10bab1a6650b',1,19,'','','8e79c1e0-7621-4045-8eb1-a3f3aa524c7e','6b94b393-0b28-4787-8236-f2fb008d384b','a6cebe97-e343-4ed0-b2f2-37bae8629771','7fc6370d-a729-4276-a6d1-6d0cc02a8b35','917993c0-c05b-494b-acc6-3d4fcb47bd3f','','',NULL,NULL,'2022-03-04 15:49:44',NULL,'2022-03-04 14:49:44','2022-03-04 15:29:59');
/*!40000 ALTER TABLE `Patient` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `Patient_AFTER_DELETE` AFTER DELETE ON `Patient` FOR EACH ROW BEGIN
	DELETE FROM PersonInfo  	 WHERE id = OLD.personInfoID;
	DELETE FROM AddressInfo 	 WHERE id = OLD.addressInfoID;
	DELETE FROM PhoneInfo   	 WHERE id = OLD.phoneInfoID;
	DELETE FROM EmergencyContact     WHERE id = OLD.emergencyContactID;
	DELETE FROM Practitioner 	 WHERE id = OLD.practitionerID;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `PatientCredentials`
--

DROP TABLE IF EXISTS `PatientCredentials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PatientCredentials` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `patientID` char(36) NOT NULL,
  `accessCode` varchar(128) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `un_AccessCode` (`accessCode`),
  KEY `fk_PatientCredentials_Patient` (`patientID`),
  CONSTRAINT `fk_PatientCredentials_Patient` FOREIGN KEY (`patientID`) REFERENCES `Patient` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PatientCredentials`
--

LOCK TABLES `PatientCredentials` WRITE;
/*!40000 ALTER TABLE `PatientCredentials` DISABLE KEYS */;
/*!40000 ALTER TABLE `PatientCredentials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PatientToken`
--

DROP TABLE IF EXISTS `PatientToken`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PatientToken` (
  `id` char(36) NOT NULL,
  `created` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `token` char(41) NOT NULL,
  `patientCredentialsId` mediumint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `un_Token` (`token`),
  KEY `fk_PatientToken_PatientCredentials` (`patientCredentialsId`),
  CONSTRAINT `fk_PatientToken_PatientCredentials` FOREIGN KEY (`patientCredentialsId`) REFERENCES `PatientCredentials` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PatientToken`
--

LOCK TABLES `PatientToken` WRITE;
/*!40000 ALTER TABLE `PatientToken` DISABLE KEYS */;
/*!40000 ALTER TABLE `PatientToken` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PersonInfo`
--

DROP TABLE IF EXISTS `PersonInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PersonInfo` (
  `id` varchar(36) NOT NULL,
  `firstName` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `sex` enum('M','F') DEFAULT NULL,
  `birthDate` date DEFAULT NULL,
  `salutation` varchar(45) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `picturePath` varchar(255) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PersonInfo`
--

LOCK TABLES `PersonInfo` WRITE;
/*!40000 ALTER TABLE `PersonInfo` DISABLE KEYS */;
INSERT INTO `PersonInfo` VALUES ('07014444-ac05-49c8-8d6e-c43f95e41558','','','','',NULL,'','','',NULL,NULL,'2022-03-04 14:51:03'),('4e6c8ccf-7df1-4cd8-8b0c-1c1d6d535994','','','','',NULL,'','','',NULL,NULL,'2023-02-02 11:29:37'),('524-10','','','','',NULL,'','','',NULL,NULL,'2022-03-04 11:18:58'),('524-11','','','','',NULL,'','','',NULL,NULL,'2022-03-04 11:18:58'),('524-12','','','','',NULL,'','','',NULL,NULL,'2022-03-04 11:18:58'),('524-13','','','','',NULL,'','','',NULL,NULL,'2022-03-04 11:18:58'),('524-14','','','','',NULL,'','','',NULL,NULL,'2022-03-04 11:18:58'),('524-15','','','','',NULL,'','','',NULL,NULL,'2022-03-04 11:18:58'),('524-16','','','','',NULL,'','','',NULL,NULL,'2022-03-04 11:18:58'),('524-17','','','','',NULL,'','','',NULL,NULL,'2022-03-04 11:18:58'),('524-18','','','','',NULL,'','','',NULL,NULL,'2022-03-04 11:18:58'),('524-19','','','','',NULL,'','','',NULL,NULL,'2022-03-04 11:18:58'),('524-2','','','','',NULL,'','','',NULL,NULL,'2022-03-04 11:18:58'),('524-20','','','','',NULL,'','','',NULL,NULL,'2022-03-04 11:18:58'),('524-21','','','','',NULL,'','','',NULL,NULL,'2022-03-04 11:18:58'),('524-22','','','','',NULL,'','','',NULL,NULL,'2022-03-04 11:18:58'),('524-23','','','','',NULL,'','','',NULL,NULL,'2022-03-04 11:18:58'),('524-24','','','','',NULL,'','','',NULL,NULL,'2022-03-04 11:18:58'),('524-25','','','','',NULL,'','','',NULL,NULL,'2022-03-04 11:18:58'),('524-26','DENIS','ROUDOT','','M','1962-10-07','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-27','','','','',NULL,'','','',NULL,NULL,'2022-03-04 11:18:58'),('524-28','Romain','LABATUT','','M','1984-02-02','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-29','','','','',NULL,'','','',NULL,NULL,'2022-03-04 11:18:58'),('524-3','','','','',NULL,'','','',NULL,NULL,'2022-03-04 11:18:58'),('524-30','Serdal','SAKALLI','','M','1992-11-07','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-31','','','','',NULL,'','','',NULL,NULL,'2022-03-04 11:18:58'),('524-32','','','','',NULL,'','','',NULL,NULL,'2022-03-04 11:18:58'),('524-33','','','','',NULL,'','','',NULL,NULL,'2022-03-04 11:18:58'),('524-34','VICTORIA','DI GIULIPO','','F','1966-06-27','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-35','','','','',NULL,'','','',NULL,NULL,'2022-03-04 11:18:58'),('524-4','jf','ohlmann','','M','1948-08-20','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-5','','','','',NULL,'','','',NULL,NULL,'2022-03-04 11:18:58'),('524-6','ANNE','FROMENTAL','','F','1978-06-11','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-7','','','','',NULL,'','','',NULL,NULL,'2022-03-04 11:18:58'),('524-8','','','','',NULL,'','','',NULL,NULL,'2022-03-04 11:18:58'),('524-9','','','','',NULL,'','','',NULL,NULL,'2022-03-04 11:18:58'),('6738af39-bb7d-4a92-9e6d-9fb099fed33f','','','','',NULL,'','','',NULL,NULL,'2023-02-02 11:29:37'),('72554025-cd8b-4cb5-8f80-395a81adc0d1','','','','',NULL,'','','',NULL,NULL,'2022-03-04 14:51:48'),('8e79c1e0-7621-4045-8eb1-a3f3aa524c7e','','','','',NULL,'','','',NULL,NULL,'2022-03-04 14:29:59'),('993f4422-c1d9-4711-a5b4-b4a5cb3cc15a','','','','',NULL,'','','',NULL,NULL,'2022-03-04 14:27:29'),('a98bb13f-9136-4f00-a7a0-6f8d694ef562','','','','',NULL,'','','',NULL,NULL,'2022-03-04 14:29:59'),('b6a360ce-c47f-429b-823d-508a30eefd4c','sophie','quintana','','F','1981-05-02','','','',NULL,NULL,'2022-03-04 14:51:03'),('bf622b96-473c-47f6-a0e4-91ac17577737','','','','',NULL,'','','',NULL,NULL,'2022-03-04 14:51:48'),('f903b55e-d4b2-4149-98dd-f28d09df2c7e','','','','',NULL,'','','',NULL,NULL,'2022-03-04 14:27:29');
/*!40000 ALTER TABLE `PersonInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PhoneInfo`
--

DROP TABLE IF EXISTS `PhoneInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PhoneInfo` (
  `id` varchar(36) NOT NULL,
  `mainPhone` varchar(45) DEFAULT NULL,
  `cellular` varchar(45) DEFAULT NULL,
  `fax` varchar(45) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PhoneInfo`
--

LOCK TABLES `PhoneInfo` WRITE;
/*!40000 ALTER TABLE `PhoneInfo` DISABLE KEYS */;
INSERT INTO `PhoneInfo` VALUES ('0d4a72d8-1668-4496-bb85-38237a3b1de1','','','',NULL,NULL,'2023-02-02 11:29:37'),('146b1965-477f-4da1-8335-af14e962c1fe','','','',NULL,NULL,'2022-03-04 14:51:03'),('2d880b94-5900-48be-bfb2-1a5169f34818','','','',NULL,NULL,'2022-03-04 14:29:59'),('3492393c-61ab-4c57-9d31-b8acb1c04b00','','','',NULL,NULL,'2022-03-04 14:51:03'),('36a5f3c2-6cee-42a2-ac92-ba6eefbddf14','','','',NULL,NULL,'2022-03-04 14:27:29'),('4ce0cebf-0f94-43cc-8728-ed2edac9d7b1','','','',NULL,NULL,'2022-03-04 14:29:59'),('524-10','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-11','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-12','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-13','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-14','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-15','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-16','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-17','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-18','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-19','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-2','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-20','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-21','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-22','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-23','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-24','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-25','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-26','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-27','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-28','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-29','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-3','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-30','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-31','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-32','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-33','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-34','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-35','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-36','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-37','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-38','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-39','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-4','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-40','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-41','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-42','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-43','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-44','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-45','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-46','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-47','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-48','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-49','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-5','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-50','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-51','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-52','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-6','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-7','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-8','','','',NULL,NULL,'2022-03-04 11:18:58'),('524-9','','','',NULL,NULL,'2022-03-04 11:18:58'),('53b9c9e7-bd21-4dca-bdca-4974346ce62c','','','',NULL,NULL,'2023-02-02 11:29:37'),('63bfb645-ba8d-4a57-bf7d-c618ba884015','','','',NULL,NULL,'2023-02-02 11:29:37'),('6b94b393-0b28-4787-8236-f2fb008d384b','','','',NULL,NULL,'2022-03-04 14:29:59'),('8c1fc566-43fc-4590-b3d9-4c193b539136','','','',NULL,NULL,'2022-03-04 14:51:48'),('b88e7291-9dbc-49c7-ab52-2c9f70ade1d8','','','',NULL,NULL,'2022-03-04 14:51:48'),('b9d6c713-1dc3-46bf-a4e1-f427aa064ede','','','',NULL,NULL,'2022-03-04 14:27:29'),('c6c62b92-67e6-4304-be9d-9060985d60f8','','','',NULL,NULL,'2022-03-04 14:51:03'),('f4dfad69-94ea-4c1a-a422-6f735a17a6bc','','','',NULL,NULL,'2022-03-04 14:51:48'),('fb694096-4a05-4efa-ba60-c756fe92f81b','','','',NULL,NULL,'2022-03-04 14:27:29');
/*!40000 ALTER TABLE `PhoneInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Practitioner`
--

DROP TABLE IF EXISTS `Practitioner`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Practitioner` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `phoneInfoID` varchar(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_Practitioner_PhoneInfo` (`phoneInfoID`),
  CONSTRAINT `fk_Practitioner_PhoneInfo` FOREIGN KEY (`phoneInfoID`) REFERENCES `PhoneInfo` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Practitioner`
--

LOCK TABLES `Practitioner` WRITE;
/*!40000 ALTER TABLE `Practitioner` DISABLE KEYS */;
INSERT INTO `Practitioner` VALUES ('12ceee59-a11f-4fe8-b114-7267eb6e6da0','','3492393c-61ab-4c57-9d31-b8acb1c04b00',NULL,NULL,'2022-03-04 14:51:03'),('31112d05-5090-4531-ad0b-06508a9a9e7a','','53b9c9e7-bd21-4dca-bdca-4974346ce62c',NULL,NULL,'2023-02-02 11:29:37'),('524-1','','524-4',NULL,NULL,'2022-03-04 11:18:58'),('524-10','','524-31',NULL,NULL,'2022-03-04 11:18:58'),('524-11','','524-34',NULL,NULL,'2022-03-04 11:18:58'),('524-12','','524-37',NULL,NULL,'2022-03-04 11:18:58'),('524-13','','524-40',NULL,NULL,'2022-03-04 11:18:58'),('524-14','','524-43',NULL,NULL,'2022-03-04 11:18:58'),('524-15','','524-46',NULL,NULL,'2022-03-04 11:18:58'),('524-16','','524-49',NULL,NULL,'2022-03-04 11:18:58'),('524-17','','524-52',NULL,NULL,'2022-03-04 11:18:58'),('524-2','','524-7',NULL,NULL,'2022-03-04 11:18:58'),('524-3','','524-10',NULL,NULL,'2022-03-04 11:18:58'),('524-4','','524-13',NULL,NULL,'2022-03-04 11:18:58'),('524-5','','524-16',NULL,NULL,'2022-03-04 11:18:58'),('524-6','','524-19',NULL,NULL,'2022-03-04 11:18:58'),('524-7','','524-22',NULL,NULL,'2022-03-04 11:18:58'),('524-8','','524-25',NULL,NULL,'2022-03-04 11:18:58'),('524-9','','524-28',NULL,NULL,'2022-03-04 11:18:58'),('815e815b-d1cf-4dea-a354-cf48472a2c96','','b88e7291-9dbc-49c7-ab52-2c9f70ade1d8',NULL,NULL,'2022-03-04 14:51:48'),('917993c0-c05b-494b-acc6-3d4fcb47bd3f','','2d880b94-5900-48be-bfb2-1a5169f34818',NULL,NULL,'2022-03-04 14:29:59'),('d42ac28b-4bad-4087-910c-7e73e2e8e9df','','b9d6c713-1dc3-46bf-a4e1-f427aa064ede',NULL,NULL,'2022-03-04 14:27:29');
/*!40000 ALTER TABLE `Practitioner` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `Practitioner_AFTER_DELETE` AFTER DELETE ON `Practitioner` FOR EACH ROW BEGIN
	DELETE FROM PhoneInfo WHERE id = OLD.phoneInfoID;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `__db_version__`
--

DROP TABLE IF EXISTS `__db_version__`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `__db_version__` (
  `id` int NOT NULL AUTO_INCREMENT,
  `version_major` int NOT NULL DEFAULT '0',
  `version_minor` int NOT NULL DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `migration_file` varchar(1024) DEFAULT NULL,
  `commit` varchar(255) DEFAULT NULL,
  `version_core` varchar(255) DEFAULT NULL,
  `version_IHM` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `__db_version__`
--

LOCK TABLES `__db_version__` WRITE;
/*!40000 ALTER TABLE `__db_version__` DISABLE KEYS */;
INSERT INTO `__db_version__` VALUES (1,1,0,'v1.0','migration_initial_patient_cleanup_local','','4.2.0','2.1.1'),(2,1,1,'v1.1','migration_add_version_and_patient_credentials','','4.2.0','2.1.1'),(3,1,2,'v1.2','migration_add_patient_download_request','','4.2.0','2.1.1'),(4,1,3,'v1.3','migration_patient_trigger_local','','4.3.0','2.2.2');
/*!40000 ALTER TABLE `__db_version__` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping routines for database 'condor_patient_local'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-02-02 12:32:49
