-- MySQL dump 10.13  Distrib 8.0.30, for Linux (x86_64)
--
-- Host: localhost    Database: condor
-- ------------------------------------------------------
-- Server version	8.0.30-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `Act`
--

DROP TABLE IF EXISTS `Act`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Act` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `title` varchar(64) DEFAULT NULL,
  `dateCreated` datetime DEFAULT NULL,
  `comments` mediumtext,
  `globalDisplayID` mediumint unsigned DEFAULT NULL,
  `displayID` mediumint unsigned DEFAULT NULL,
  `patientID` char(36) NOT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastAccessed` datetime NOT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Work_Patient` (`patientID`,`ownerID`),
  CONSTRAINT `fk_Act_Patient` FOREIGN KEY (`patientID`) REFERENCES `condor_patient_local`.`Patient` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Act`
--

LOCK TABLES `Act` WRITE;
/*!40000 ALTER TABLE `Act` DISABLE KEYS */;
INSERT INTO `Act` VALUES (1001,'00022a66-7220-4aec-bb84-ddea7664d49d','','2022-01-19 20:15:57','',1,1,'4000373f-1dfa-42e5-ad0d-797ed98bbf1a','','','2022-01-19 20:16:08','2022-01-19 20:15:57','2022-01-19 20:16:08','2022-01-19 19:16:08','2022-01-19 20:15:57'),(1001,'01b85cc7-ad9c-44db-a6c5-3f8d1493bb30','empreinte initiale 0056','2022-01-27 12:40:11','',1,1,'021a268a-4571-414a-bbef-2ea30a0a7fed','','',NULL,'2022-10-06 17:54:41','2022-10-06 17:54:43','2022-10-06 15:54:43','2022-03-08 11:18:09'),(1001,'01bd0635-6ec6-42cb-8561-8638bded352c','Vincent 1707: 27 CCC','2022-06-03 14:36:49','',1,1,'1c189ddc-0ee7-45e7-9d80-585dac08374a','','',NULL,'2022-06-07 13:43:29','2022-06-07 13:43:32','2022-06-07 11:43:32','2022-06-03 19:00:56'),(1001,'049862c5-29b2-4fcd-a5b1-4c8f1f6cf480','SEB01','2022-01-19 15:51:34','',1,1,'593972a6-d7d6-4802-b87d-38aab371f71e','','',NULL,'2022-06-28 19:39:53','2022-06-28 19:39:56','2022-06-28 17:39:56','2022-01-19 16:27:34'),(1001,'0aac522d-3c38-465a-a1e0-014166c140ac','0171','2022-01-21 12:24:08','',1,1,'a0c21836-ba79-4f15-9e35-02ef8211a9e5','','',NULL,'2022-07-12 19:48:58','2022-07-12 19:48:59','2022-07-12 17:48:59','2022-02-02 11:14:39'),(1001,'146b346d-b9f6-44b4-a722-edc0a0f231ed','CCC 47','2022-04-21 12:39:12','',1,1,'87f00f75-c29c-430a-a553-82cbedff21d9','','',NULL,'2022-04-21 19:37:08','2022-04-21 19:47:18','2022-04-21 17:47:18','2022-04-21 19:47:18'),(1001,'1f3e06be-a2ec-4423-831c-7b01979d5187','PIERRE 13 EMPREINTE','2022-07-12 12:38:36','',1,1,'55f86771-cc61-43c6-a8d5-5e4006a24fc9','','',NULL,'2022-07-19 15:44:40','2022-07-19 15:56:03','2022-07-19 13:56:03','2022-07-19 15:56:02'),(1001,'1f6a1e17-7d25-4906-b07f-ef2a5b507d38','EMP 13','2022-06-28 15:33:48','',1,3,'95cf30e7-fd74-43ff-9655-43abf2f63669','','',NULL,'2022-10-06 15:17:33','2022-10-06 15:17:41','2022-10-06 13:17:41','2022-10-06 15:17:41'),(1001,'223a16b9-c15c-4bcc-9b2f-7373785fcc51','mai','2022-01-19 10:16:29','',1,1,'2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d','','',NULL,'2022-01-19 14:47:55','2022-01-19 14:51:12','2022-01-19 13:51:12','2022-01-19 14:51:11'),(1001,'24d0aeb5-3058-4070-aeea-97c289e41e3c','7502','2022-01-19 14:53:21','',1,1,'de078619-3946-4adb-a799-1c260e16face','','',NULL,'2022-01-28 19:01:28','2022-01-28 19:35:12','2022-01-28 18:35:12','2022-01-19 15:46:50'),(1001,'267349dd-4d0c-4356-a35b-f7060d5b6403','0010 Philippe/','2022-06-17 17:31:03','',1,1,'95cf30e7-fd74-43ff-9655-43abf2f63669','','','2022-06-20 13:57:13','2022-06-20 13:57:02','2022-06-20 13:57:13','2022-06-20 11:57:13','2022-06-20 13:57:11'),(1001,'2c8b85b5-c805-4b08-85e7-3d02dab72e99','16','2022-02-01 15:47:50','',1,1,'d100e894-0be9-4495-94e2-e469232f7817','','',NULL,'2022-02-08 10:17:48','2022-02-08 10:17:49','2022-02-08 09:17:49','2022-02-07 16:23:43'),(1001,'319a8f1d-33fc-4f87-a108-b3eabda0510f','EMP 23:pierre','2022-07-07 17:30:54','',1,1,'533d4409-e39d-4a27-a0af-b59e6cf76ce3','','',NULL,'2022-07-12 19:49:25','2022-07-12 19:49:26','2022-07-12 17:49:26','2022-07-07 18:14:07'),(1001,'33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416','INLAY35','2022-06-28 12:43:42','',1,1,'4a3954e0-1e2f-4721-9fdd-4180380dc19f','','',NULL,'2022-06-28 19:39:09','2022-06-28 19:39:09','2022-06-28 17:39:09','2022-06-28 19:31:31'),(1001,'3e95d626-668f-45f7-98ad-be2cf9d7b90b','Colette 3738/ 26 ','2022-05-24 10:54:46','',1,1,'452a5200-3e06-4b74-8949-6abc7f2dda8a','','',NULL,'2022-05-30 09:50:52','2022-05-30 09:50:53','2022-05-30 07:50:53','2022-05-25 13:20:15'),(1001,'4075a8d6-094f-4202-abe0-4c02b7a5a8e6','7267','2022-01-20 09:51:18','',1,1,'32939ecf-ba11-4fff-a074-5e86a9f7f313','','',NULL,'2022-02-08 10:11:23','2022-02-08 10:11:55','2022-02-08 09:11:55','2022-01-20 20:45:47'),(2,'440a8315-0df8-4219-8d74-9470bfeeacbf','','2022-07-28 14:29:39','',371,1,'1095dc95-d70a-4936-8b50-ae8aa7963fc9','','','2022-08-30 10:32:23','2022-07-28 14:29:39',NULL,'2022-08-30 08:32:23','2022-08-30 10:32:23'),(1001,'498ae60a-23f0-44fc-9730-be499bfc4b46','EMPREINTE 38','2022-06-14 15:07:45','',1,1,'f4fc00ec-4af8-4a15-b427-f1c5aabf6260','','',NULL,'2022-06-17 08:43:02','2022-06-17 08:43:05','2022-06-17 06:43:05','2022-06-14 19:10:41'),(1001,'4bed076c-8541-4a2f-800a-5aeb4cb49de5','ONLAY 37','2022-06-28 16:52:59','',1,1,'fa7fa96b-f393-4b9a-8198-144702462cfa','','',NULL,'2022-06-28 19:40:34','2022-06-28 19:40:35','2022-06-28 17:40:35','2022-06-28 19:28:44'),(1001,'4f4c72c4-9f78-40d6-9576-4281f6d06aa3','0010/Philippe 44/45/46/47','2022-06-17 17:31:56','',1,2,'95cf30e7-fd74-43ff-9655-43abf2f63669','','','2022-06-20 13:56:57','2022-06-20 13:56:44','2022-06-20 13:56:57','2022-06-20 11:56:57','2022-06-20 13:56:57'),(1001,'4f62e395-5623-4d5b-869c-1b2fc4d22b00','AMELIE 0355','2022-06-16 12:46:06','',1,1,'57c4096f-98dd-49c8-bea5-a5b109ad3fd0','','',NULL,'2022-06-18 10:23:25','2022-06-18 10:23:28','2022-06-18 08:23:28','2022-06-16 18:10:14'),(1001,'4ff9c682-c09d-42ff-8c29-aeb13e066ed2','0045','2022-01-24 18:24:06','',1,1,'45ff7437-0691-4427-a7da-8250862e4b96','','',NULL,'2022-10-06 17:54:14','2022-10-06 17:54:19','2022-10-06 15:54:19','2022-01-24 20:57:08'),(1001,'5368829e-7dec-4775-a487-a1019f9604f4','25 26','2022-02-01 11:32:26','',1,1,'8fc74d9e-a5a0-46bf-be3f-500548a130ad','','',NULL,'2022-03-19 11:42:26','2022-03-19 11:42:27','2022-03-19 10:42:27','2022-02-02 11:00:42'),(1001,'55831d43-1906-4a22-9b7a-ed4b2820c8b2','Genevieve 0125 / dent 11','2022-06-16 15:11:10','',1,2,'458c92d8-9da1-4df9-967f-d14fc7e6303d','','',NULL,'2022-06-16 18:06:44','2022-06-16 18:06:46','2022-06-16 16:06:46','2022-06-16 15:34:57'),(1001,'5f9199b0-eb37-4ed3-8d1a-6c38505d4913','Empreinte étude','2022-09-09 17:53:33','',1,1,'69640c87-271c-4a44-a6fa-67b01654cc27','','',NULL,'2022-09-10 10:16:36','2022-09-10 11:45:53','2022-09-10 09:45:53','2022-09-10 11:45:51'),(2,'6206892a-2e7e-4765-ac90-b49bfb465997','bouche','2022-08-30 10:32:28','',371,1,'6a4b302c-278d-4e12-ace5-f095ba0bf856','','',NULL,'2022-08-30 14:06:13','2022-09-06 11:17:33','2022-09-06 09:17:33','2022-08-30 14:34:16'),(1001,'64c1427a-b91d-4675-94df-f36bd40e9b0f','Inlay14','2022-06-28 09:56:17','',1,2,'32710234-804f-46f5-899d-eed636f8a906','','',NULL,'2022-07-21 17:33:38','2022-07-21 17:33:47','2022-07-21 15:33:47','2022-06-28 19:34:50'),(1001,'6cd9ac89-d152-4881-ae60-0aa4d933a545','EMP ETUDE','2022-03-07 14:53:56','',1,1,'7eca2942-3d65-4279-8dae-998594082bb0','','',NULL,'2022-05-12 14:23:16','2022-05-12 14:33:47','2022-05-12 12:33:47','2022-05-12 14:33:46'),(1001,'7873a396-419c-4215-83c7-fec9f2742ccf','EMP 46','2022-02-03 11:00:24','',1,1,'7f47fd88-9ea0-4c08-9193-a54d4f158c7c','','',NULL,'2022-06-17 08:40:38','2022-06-17 08:40:40','2022-06-17 06:40:40','2022-06-16 17:39:33'),(1001,'796aca94-b14e-4e17-bfc0-9f3f45ade8f3','0062 23 27','2022-05-13 15:50:48','',1,1,'f3295a8a-61a2-46d8-af67-c1d1e5901069','','',NULL,'2022-06-20 12:09:34','2022-06-20 12:09:44','2022-06-20 10:09:44','2022-06-14 14:09:40'),(1001,'7d5777ce-32ef-4f6a-85c5-0ac67029d64b','','2022-10-07 09:21:47','',1,1,'fad4ff40-5c01-4280-88a4-568c5b75c8dd','','','2022-10-07 09:22:49','2022-10-07 09:21:47',NULL,'2022-10-07 07:22:49','2022-10-07 09:22:49'),(1001,'7fe13e47-f2c8-4c59-ad95-d384d4cbaa35','7338/ Claire/ 16','2022-05-30 12:47:54','',1,1,'207d6dbc-c19b-4726-a9b3-16235ae554cc','','',NULL,'2022-06-15 11:06:33','2022-06-15 11:06:37','2022-06-15 09:06:37','2022-05-30 20:29:45'),(2,'81cd9cb1-6b36-47c0-8149-074211a960fe','','2021-12-24 13:42:51','',371,1,'c7f5dffb-2c97-44f8-926b-68aff9d64c15','','',NULL,'2021-12-24 13:42:51','2022-07-28 14:06:48','2022-07-28 12:06:48','2021-12-24 13:42:51'),(1001,'9b1d2a8e-c6de-4f5c-92c5-88005869d8e9','7304','2022-03-08 11:11:04','',1,1,'f6f52932-463d-4797-9974-ed4b8eb30a12','','',NULL,'2022-04-21 19:48:08','2022-04-21 19:48:10','2022-04-21 17:48:10','2022-04-15 16:06:50'),(1001,'a2369349-1629-40ad-8784-d271bc3fbade','Bridge prov','2022-04-21 10:29:51','',1,1,'e922efb9-8c03-445b-8a0f-449e3c43bdca','','',NULL,'2022-04-21 14:12:25','2022-04-21 15:43:41','2022-04-21 13:43:41','2022-04-21 15:43:41'),(1001,'a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5','EMPREINTE 2526','2022-02-07 12:17:00','',1,1,'513ccf80-8cc1-47fa-b351-4e0414a0fda5','','',NULL,'2022-03-19 11:38:33','2022-03-19 11:38:35','2022-03-19 10:38:35','2022-02-12 17:57:58'),(1001,'a7bcb190-dd19-4f3b-8aab-266030bf4064','EMPREINTE CC zircone 35','2022-07-04 15:25:11','',1,1,'f9d03016-567a-4bd4-9cc5-dafeea34e365','','',NULL,'2022-09-08 10:24:15','2022-09-08 10:24:28','2022-09-08 08:24:28','2022-07-19 16:05:53'),(1001,'b6039092-51ba-40dc-86e3-23be741dbb99','7280','2022-01-24 15:25:41','',1,1,'fa942554-dda6-4d2d-b578-ae9be6b3904d','','',NULL,'2022-01-28 19:12:39','2022-01-28 19:35:13','2022-01-28 18:35:13','2022-01-24 15:31:00'),(1001,'bc96e41e-0457-4067-9d27-c4eaa1a505b3','7050','2022-01-19 19:55:07','',1,1,'5c3e71a4-b9b8-4f4d-b447-42654db92f32','','',NULL,'2022-06-01 12:05:28','2022-06-01 12:05:40','2022-06-01 10:05:40','2022-05-31 16:58:18'),(1001,'c0df7d9c-0cc6-48c6-8595-92335a500fe2','Mara 7270/ 3637','2022-05-17 18:05:02','',1,1,'22c79f73-5e2c-4406-9e49-1a07f8ab0bc4','','',NULL,'2022-09-10 13:02:24','2022-09-10 13:02:27','2022-09-10 11:02:27','2022-06-09 13:25:00'),(1001,'c81670ed-4144-4347-b19e-8057d11b5f7c','0677/ 14 15 16 17/ ONLAY','2022-05-31 12:21:05','',1,1,'986374de-c4d7-4d6f-bf0c-2dc7e3b859a9','','',NULL,'2022-06-15 11:06:07','2022-06-15 11:06:12','2022-06-15 09:06:12','2022-06-07 13:41:28'),(1001,'c9079d19-8ffb-46f7-a51e-3a7a90ccae59','0125','2022-01-25 12:49:06','',1,1,'458c92d8-9da1-4df9-967f-d14fc7e6303d','','','2022-01-28 18:13:56','2022-01-28 18:13:08','2022-01-28 18:13:56','2022-01-28 17:13:56','2022-01-27 14:52:24'),(1001,'cfefc247-4a56-4d5a-8350-5ab72a8af67a','1114  CCC12','2022-05-13 11:40:59','',1,1,'7a831424-620b-4719-a82e-263d8602fd6e','','',NULL,'2022-06-02 19:24:09','2022-06-02 19:24:19','2022-06-02 17:24:19','2022-05-25 16:26:12'),(2,'d0298050-98d9-4076-b3bd-110404d60135','','2022-09-06 11:17:53','',371,1,'6a47006e-5c4a-4fab-835f-67e3301b2acf','','',NULL,'2022-09-06 11:17:53',NULL,'2022-09-06 09:20:25','2022-09-06 11:20:25'),(1001,'d67ff95f-e960-4948-8959-f79c151da5ce','===','2022-06-28 09:54:35','',1,1,'32710234-804f-46f5-899d-eed636f8a906','','','2022-06-28 09:55:55','2022-06-28 09:54:35','2022-06-28 09:55:55','2022-06-28 07:55:55','2022-06-28 09:55:55'),(1001,'dcedf77c-c664-46b3-91b3-902529b54810','empreinte 6929','2022-01-27 17:27:02','',1,1,'3fe29844-5082-4e50-a510-61af15cb5cba','','',NULL,'2022-03-19 11:41:25','2022-03-19 11:41:27','2022-03-19 10:41:27','2022-02-11 14:22:16'),(1001,'ef4d16ee-fe39-4081-920a-e42ecf24a857','0000','2022-03-19 11:44:39','',1,1,'02df4b55-8d30-46ac-b34e-449ffbc4269e','','',NULL,'2022-04-15 13:41:16','2022-04-15 13:41:29','2022-04-15 11:41:29','2022-04-15 13:41:28'),(1001,'fcd6a92e-e91c-4367-9fc7-5919a6acfcb5','Bridge 15 17','2022-10-06 15:16:54','',1,2,'f3295a8a-61a2-46d8-af67-c1d1e5901069','','',NULL,'2022-10-07 09:22:58','2022-10-07 09:27:57','2022-10-07 07:27:57','2022-10-07 09:27:57'),(1001,'ff05cb1f-6c46-4287-9cdd-81bf817a9c78','7172','2022-01-25 16:27:03','',1,1,'c8418992-7324-4a11-9437-bf2bb0fa802f','','',NULL,'2022-01-26 14:47:46','2022-01-26 14:47:48','2022-01-26 13:47:48','2022-01-25 16:45:57');
/*!40000 ALTER TABLE `Act` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AddressInfo`
--

DROP TABLE IF EXISTS `AddressInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AddressInfo` (
  `id` char(36) NOT NULL COMMENT '(DC2Type:guid)',
  `line_0` varchar(255) DEFAULT NULL,
  `line_1` varchar(255) DEFAULT NULL,
  `line_2` varchar(255) DEFAULT NULL,
  `detail` varchar(255) DEFAULT NULL,
  `cityName` varchar(255) DEFAULT NULL,
  `cityState` varchar(255) DEFAULT NULL,
  `cityZip` varchar(25) DEFAULT NULL,
  `countryName` varchar(255) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AddressInfo`
--

LOCK TABLES `AddressInfo` WRITE;
/*!40000 ALTER TABLE `AddressInfo` DISABLE KEYS */;
INSERT INTO `AddressInfo` VALUES ('00000001-0000-0000-0000-000000000001','Labege','','',NULL,'Labege','','31670','France',NULL,NULL,'2022-03-31 17:40:19'),('00000002-0000-0000-0000-000000000001','137 rue garance','','',NULL,'LABEGE','','31670','France',NULL,NULL,'2022-03-31 17:40:19'),('00000003-0000-0000-0000-000000000001','137 rue Garance','','',NULL,'Labège','','31670','France',NULL,NULL,'2022-03-31 17:40:19'),('00000005-0000-0000-0000-000000000001','','','',NULL,'HOENHEIM','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000006-0000-0000-0000-000000000001','','','',NULL,'Marseille','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000007-0000-0000-0000-000000000001','','','',NULL,'MERIGNAC','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000008-0000-0000-0000-000000000001','','','',NULL,'MERIGNAC','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000009-0000-0000-0000-000000000001','','','',NULL,'Villiers Sur Marne','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000028-0000-0000-0000-000000000001','','','',NULL,'lyon','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000033-0000-0000-0000-000000000001','','','',NULL,'','','','',NULL,NULL,'2022-03-31 17:40:19'),('00000059-0000-0000-0000-000000000001','','','',NULL,'LE TEIL','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000071-0000-0000-0000-000000000001','','','',NULL,'Paris ','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000155-0000-0000-0000-000000000001','','','',NULL,'ECOUFLANT','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000172-0000-0000-0000-000000000001','4 Chemin Couralis','','',NULL,'LAROIN','','64110','France',NULL,NULL,'2022-03-31 17:40:19'),('00000177-0000-0000-0000-000000000001','AVDA. JUAN CARAMUEL,1','','',NULL,'LEGANES','','28916','España',NULL,NULL,'2022-03-31 17:40:19'),('00000193-0000-0000-0000-000000000001','','','',NULL,'VIRIAT ','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000224-0000-0000-0000-000000000001','','','',NULL,'CUGNAUX','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000317-0000-0000-0000-000000000001','','','',NULL,'LONGWY','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000339-0000-0000-0000-000000000001','','','',NULL,'Paris','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000355-0000-0000-0000-000000000001','','','',NULL,'Parma','','','Italia',NULL,NULL,'2022-03-31 17:40:19'),('00000375-0000-0000-0000-000000000001','95, Avenue de la Marne','','',NULL,'Epinay sur Seine','','93800','France',NULL,NULL,'2022-03-31 17:40:19'),('00000377-0000-0000-0000-000000000001','51 rue moncey','','',NULL,'LYON','','69003','France',NULL,NULL,'2022-03-31 17:40:19'),('00000421-0000-0000-0000-000000000001','','','',NULL,'PARIS 17','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000568-0000-0000-0000-000000000001','','','',NULL,'Tlse','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000652-0000-0000-0000-000000000001','','','',NULL,'','','','',NULL,NULL,'2022-03-31 17:40:19'),('00000681-0000-0000-0000-000000000001','','','',NULL,'Chamalières ','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000689-0000-0000-0000-000000000001','','','',NULL,'CHAMBERY','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000805-0000-0000-0000-000000000001','137 rue Garance','','',NULL,'Labege','','31670','France',NULL,NULL,'2022-03-31 17:40:19'),('00000838-0000-0000-0000-000000000001','','','',NULL,'','','','',NULL,NULL,'2022-03-31 17:40:19'),('00000840-0000-0000-0000-000000000001','','','',NULL,'','','','',NULL,NULL,'2022-03-31 17:40:19'),('00000850-0000-0000-0000-000000000001','52 RUE DU BOURNO','','',NULL,'BOEGE','','74420','France',NULL,NULL,'2022-03-31 17:40:19'),('00000899-0000-0000-0000-000000000001','VIA E.TAZZOLI','','',NULL,'CASERTA','','81100','Italia',NULL,NULL,'2022-03-31 17:40:19'),('00000916-0000-0000-0000-000000000001','','','',NULL,'','','','',NULL,NULL,'2022-04-14 13:25:32'),('00000917-0000-0000-0000-000000000001','','','',NULL,'','','','',NULL,NULL,'2022-03-31 17:40:19'),('00000918-0000-0000-0000-000000000001','','','',NULL,'Paris','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000941-0000-0000-0000-000000000001','','','',NULL,'','','','',NULL,NULL,'2022-03-31 17:40:19'),('00000979-0000-0000-0000-000000000001','','','',NULL,'La crau','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00001001-0000-0000-0000-000000000001','111 BD RICHARD LENOIR','','',NULL,'PARIS','','75011','France',NULL,NULL,'2022-03-31 17:40:19'),('00001002-0000-0000-0000-000000000001','','','',NULL,'ETAMPES','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00001003-0000-0000-0000-000000000001','','','',NULL,'Paris','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00001004-0000-0000-0000-000000000001','','','',NULL,'PARIS','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00001005-0000-0000-0000-000000000001','','','',NULL,'','','','',NULL,NULL,'2022-03-31 17:40:19'),('00001006-0000-0000-0000-000000000001','','','',NULL,'Paris','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00001007-0000-0000-0000-000000000001','','','',NULL,'','','','',NULL,NULL,'2022-03-31 17:40:19'),('090a7130-6429-400d-8dad-f1a80580d071','','','',NULL,'','','','',NULL,NULL,'2022-07-20 09:30:20'),('4f6c5ebf-2e87-4fdf-9fd4-2583db44d18a','PRACTICANTE ANTONIO ASTRAY 4 BAJO. ','','',NULL,'TAPIA','','33740','España',NULL,NULL,'2022-03-31 17:40:19'),('8607fa5e-3b45-49bc-b05b-bc5ac3b97ff0','','','',NULL,'TOULOUSE','','','',NULL,NULL,'2022-07-20 10:24:12'),('96f58522-1a05-40cf-8221-02becbf44486','801 Wayne Avenue, Suite G200','','',NULL,'Silver Spring','','20910','United States',NULL,NULL,'2022-03-31 17:40:19'),('9eb45cea-671c-4d46-a2d1-ab73e98cfe99','','','',NULL,'Labege','','','',NULL,NULL,'2022-06-17 15:22:57');
/*!40000 ALTER TABLE `AddressInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Assistant`
--

DROP TABLE IF EXISTS `Assistant`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Assistant` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `patientRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'READ_ONLY',
  `actRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'READ_ONLY',
  `discussionRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'READ_ONLY',
  `credentialsID` char(36) DEFAULT NULL,
  `personInfoID` char(36) DEFAULT NULL COMMENT '(DC2Type:guid)',
  `phoneInfoID` char(36) DEFAULT NULL COMMENT '(DC2Type:guid)',
  `addressInfoID` char(36) DEFAULT NULL COMMENT '(DC2Type:guid)',
  `officeID` char(36) DEFAULT NULL,
  `tempPassword` varchar(32) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `lastConnection` timestamp NULL DEFAULT NULL,
  `firstConnection` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`,`ownerID`),
  UNIQUE KEY `UNIQ_4068FE723D139428` (`personInfoID`),
  UNIQUE KEY `UNIQ_4068FE72627FFEF6` (`phoneInfoID`),
  UNIQUE KEY `UNIQ_4068FE72A680FCCC` (`addressInfoID`),
  KEY `fk_Assistant_Professional` (`ownerID`),
  KEY `fk_Assistant_Office` (`officeID`,`ownerID`),
  KEY `fk_Assistant_Credentials_idx` (`credentialsID`,`id`),
  KEY `fk_Assistant_PersonInfo_idx` (`personInfoID`),
  KEY `fk_Assistant_PhoneInfo_idx` (`phoneInfoID`),
  KEY `fk_Assistant_AddressInfo_idx` (`addressInfoID`),
  CONSTRAINT `fk_Assistant_AddressInfo` FOREIGN KEY (`addressInfoID`) REFERENCES `AddressInfo` (`id`),
  CONSTRAINT `fk_Assistant_Credentials` FOREIGN KEY (`credentialsID`) REFERENCES `Credentials` (`id`),
  CONSTRAINT `fk_Assistant_Office` FOREIGN KEY (`officeID`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Assistant_PersonInfo` FOREIGN KEY (`personInfoID`) REFERENCES `PersonInfo` (`id`),
  CONSTRAINT `fk_Assistant_PhoneInfo` FOREIGN KEY (`phoneInfoID`) REFERENCES `PhoneInfo` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Assistant`
--

LOCK TABLES `Assistant` WRITE;
/*!40000 ALTER TABLE `Assistant` DISABLE KEYS */;
/*!40000 ALTER TABLE `Assistant` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8mb3_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `Assistant_AFTER_DELETE` AFTER DELETE ON `Assistant` FOR EACH ROW BEGIN
	DELETE FROM PersonInfo  WHERE ownerID = OLD.ownerID AND id = OLD.personInfoID;
	DELETE FROM AddressInfo WHERE ownerID = OLD.ownerID AND id = OLD.addressInfoID;
	DELETE FROM PhoneInfo   WHERE ownerID = OLD.ownerID AND id = OLD.phoneInfoID;
	DELETE FROM Credentials WHERE ownerID = OLD.ownerID AND id = OLD.credentialsID;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `CircleOrder`
--

DROP TABLE IF EXISTS `CircleOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CircleOrder` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `actID` char(36) NOT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `title` varchar(64) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `status` enum('not_sent','waiting_wow_api','sending_wow_api','sending_circle_api','sent','cancelled') NOT NULL DEFAULT 'waiting_wow_api',
  `createdAt` datetime NOT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `json` text NOT NULL,
  `metadata` text NOT NULL,
  `localDisplayID` int unsigned DEFAULT NULL,
  `globalDisplayID` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_CircleOrder_Act` (`actID`,`ownerID`),
  CONSTRAINT `fk_CircleOrder_Act` FOREIGN KEY (`actID`, `ownerID`) REFERENCES `Act` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CircleOrder`
--

LOCK TABLES `CircleOrder` WRITE;
/*!40000 ALTER TABLE `CircleOrder` DISABLE KEYS */;
/*!40000 ALTER TABLE `CircleOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CircleOrderFile`
--

DROP TABLE IF EXISTS `CircleOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CircleOrderFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `orderID` char(36) NOT NULL,
  `fileID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`orderID`,`fileID`),
  KEY `fk_CircleOrderFile_CircleOrder` (`orderID`,`ownerID`),
  KEY `fk_CircleOrderFile_CondorFile` (`fileID`,`ownerID`),
  CONSTRAINT `fk_CircleOrderFile_CircleOrder` FOREIGN KEY (`orderID`, `ownerID`) REFERENCES `CircleOrder` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_CircleOrderFile_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CircleOrderFile`
--

LOCK TABLES `CircleOrderFile` WRITE;
/*!40000 ALTER TABLE `CircleOrderFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `CircleOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CondorFile`
--

DROP TABLE IF EXISTS `CondorFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CondorFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `path` text NOT NULL,
  `type` varchar(250) NOT NULL,
  `tag` varchar(250) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `originalName` varchar(100) DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `status` enum('CREATED','UPDATED','SYNCED','ERROR') DEFAULT NULL,
  `originalID` char(36) NOT NULL,
  `version` mediumint NOT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `metadata` text,
  PRIMARY KEY (`id`,`ownerID`),
  UNIQUE KEY `un_CondorFile_version` (`ownerID`,`originalID`,`version`),
  KEY `fk_CondorFile_Professional` (`ownerID`),
  KEY `fk_CondorFile_CondorFile` (`originalID`,`ownerID`),
  CONSTRAINT `fk_CondorFile_CondorFile` FOREIGN KEY (`originalID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_CondorFile_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CondorFile`
--

LOCK TABLES `CondorFile` WRITE;
/*!40000 ALTER TABLE `CondorFile` DISABLE KEYS */;
INSERT INTO `CondorFile` VALUES (1001,'00514ba5-3006-428d-87e3-9ce7215b8e79','','SNAPS','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_RISC_b434cfd5-6ef9-4523-92e9-9f68fc4af6be_SNAPS_','2022-09-09 16:21:09','2022-09-09 18:15:02','','2022-09-09 18:21:09','SYNCED','00514ba5-3006-428d-87e3-9ce7215b8e79',0,'2022-09-09 18:21:09','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.39.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'0094b009-39bf-4b30-bd35-96e7bcdd4020','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/533d4409-e39d-4a27-a0af-b59e6cf76ce3/session_319a8f1d-33fc-4f87-a108-b3eabda0510f/occlusion_3b38f07b-42cb-40b1-933f-365e568702e4/scan_109ca2c4-8222-4d02-9ac7-b4b93937e1e2/37_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_533d4409-e39d-4a27-a0af-b59e6cf76ce3_ACT_319a8f1d-33fc-4f87-a108-b3eabda0510f_SESS_3b38f07b-42cb-40b1-933f-365e568702e4_TOSC_109ca2c4-8222-4d02-9ac7-b4b93937e1e2_ZIP_','2022-07-07 15:51:57','2022-07-07 17:51:47','37_w1_o1_maxillaire_scan_file_1.zip','2022-07-07 17:51:57','SYNCED','0192b393-b665-47d2-aaac-671ff4a06d5c',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.37.1.1.1\",\"modelMatrix\":\"0.644942,0.738261,-0.197535,0,-0.764231,0.623026,-0.166702,0,-1.14666e-08,0.258475,0.966018,0,3.62982,-26.4657,-16.9038,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'00af1aee-3448-458a-9664-8c6714a79a2b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/scan_03839278-13f8-46e6-9581-ba11bc8bcb81/1_w1_o1_maxillaire_screenshot_00af1aee-3448-458a-9664-8c6714a79a2b_0.png','SCREENS','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_TOSC_03839278-13f8-46e6-9581-ba11bc8bcb81_SCREENS_','2022-01-19 13:04:00','2022-01-19 11:36:07','1_w1_o1_maxillaire_screenshot_00af1aee-3448-458a-9664-8c6714a79a2b_0.png','2022-01-19 14:04:00','SYNCED','00af1aee-3448-458a-9664-8c6714a79a2b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Screenshot 1.1.1.1.1 Maxillaire 2\",\"scanFileType\":\"PLY\",\"scanPosition\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"title\":\"Maxillaire 2\"}'),(1001,'013be9a4-374c-4881-9ac7-daff0b32f1c4','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/de078619-3946-4adb-a799-1c260e16face/session_24d0aeb5-3058-4070-aeea-97c289e41e3c/occlusion_ea6da896-1504-41fc-890c-7c48575e9e40/scan_aa24138a-68e8-4bc3-9a5d-d617f0fe496b/2_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_de078619-3946-4adb-a799-1c260e16face_ACT_24d0aeb5-3058-4070-aeea-97c289e41e3c_SESS_ea6da896-1504-41fc-890c-7c48575e9e40_TOSC_aa24138a-68e8-4bc3-9a5d-d617f0fe496b_SNAPS_','2022-01-19 14:06:34','2022-01-19 15:06:15','2_w1_o1_maxillaire_snapshot_1.png','2022-01-19 15:06:34','SYNCED','2cdb0d7a-4a22-4953-a430-1bf6d75a218e',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.2.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'018696d3-f17d-483a-953f-cf3375c8278e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_e6c95ef7-636d-4c88-8d02-e2d9840573db/13_w1_o1_mandibule_scan_file_4.zip','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_e6c95ef7-636d-4c88-8d02-e2d9840573db_ZIP_','2022-01-27 16:40:57','2022-01-27 17:37:48','13_w1_o1_mandibule_scan_file_4.zip','2022-01-27 17:40:57','SYNCED','bcef8d3e-9632-4976-8cda-4c6f3ac50e99',4,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.1\",\"modelMatrix\":\"-0.963479,0.243305,-0.111855,0,-0.267785,-0.8754,0.402451,0,1.23617e-9,0.417706,0.908582,0,32.4632,-3.53421,-16.2323,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'0192b393-b665-47d2-aaac-671ff4a06d5c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/533d4409-e39d-4a27-a0af-b59e6cf76ce3/session_319a8f1d-33fc-4f87-a108-b3eabda0510f/occlusion_3b38f07b-42cb-40b1-933f-365e568702e4/scan_109ca2c4-8222-4d02-9ac7-b4b93937e1e2/37_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_533d4409-e39d-4a27-a0af-b59e6cf76ce3_ACT_319a8f1d-33fc-4f87-a108-b3eabda0510f_SESS_3b38f07b-42cb-40b1-933f-365e568702e4_TOSC_109ca2c4-8222-4d02-9ac7-b4b93937e1e2_ZIP_','2022-07-07 15:42:21','2022-07-07 17:42:10','37_w1_o1_maxillaire_scan_file_0.zip','2022-07-07 17:42:21','SYNCED','0192b393-b665-47d2-aaac-671ff4a06d5c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.37.1.1.1\",\"modelMatrix\":\"0.645872,0.740889,-0.18421,0,-0.763445,0.626789,-0.155841,0,4.41234e-09,0.241287,0.970454,0,3.47315,-26.0398,-17.4387,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'01bd7ce5-4459-41fa-9f87-0c8c8693ddd6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/452a5200-3e06-4b74-8949-6abc7f2dda8a/session_3e95d626-668f-45f7-98ad-be2cf9d7b90b/occlusion_bce8310f-eee9-4f0a-a6b7-d592dec66be5/computedocclusion_d9818808-7d5e-47e6-9880-cc95357483ff/26_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_452a5200-3e06-4b74-8949-6abc7f2dda8a_ACT_3e95d626-668f-45f7-98ad-be2cf9d7b90b_SESS_bce8310f-eee9-4f0a-a6b7-d592dec66be5_OCC_d9818808-7d5e-47e6-9880-cc95357483ff_BOPLY__ZIP_','2022-05-24 09:42:49','2022-05-24 11:42:41','26_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-05-24 11:42:49','SYNCED','01bd7ce5-4459-41fa-9f87-0c8c8693ddd6',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.26.1.1.2 Occlusion 2\",\"modelMatrix\":\"-0.440993,0.868318,-0.227045,0,-0.89751,-0.426649,0.111559,0,-1.10485e-08,0.252972,0.967474,0,8.55795,-16.8564,-17.5092,1\",\"referenceScanID\":\"1.26.1.1.2\",\"title\":\"Mandibule 1.26.1.1.2 Occlusion 2\"}'),(1001,'01d3e05e-ff13-4067-b5bd-5ec37bbc3d2c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/fa7fa96b-f393-4b9a-8198-144702462cfa/session_4bed076c-8541-4a2f-800a-5aeb4cb49de5/occlusion_16b82fca-4b65-4866-af87-1f6dbb42f5dc/computedocclusion_94a0167c-6798-4c78-a76c-cb9fc91ccdda/35_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_fa7fa96b-f393-4b9a-8198-144702462cfa_ACT_4bed076c-8541-4a2f-800a-5aeb4cb49de5_SESS_16b82fca-4b65-4866-af87-1f6dbb42f5dc_OCC_94a0167c-6798-4c78-a76c-cb9fc91ccdda_SNAPO__SNAPS_','2022-06-28 15:03:44','2022-06-28 17:03:25','35_w1_o1_snapshot_occ_file_0.png','2022-06-28 17:03:44','SYNCED','01d3e05e-ff13-4067-b5bd-5ec37bbc3d2c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'02dc36dc-042f-48ff-af0e-10111549609e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/593972a6-d7d6-4802-b87d-38aab371f71e/session_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480/occlusion_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3/scan_ae54b48a-8f70-45c1-81cc-4ed8a6bc0e95/3_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_593972a6-d7d6-4802-b87d-38aab371f71e_ACT_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480_SESS_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3_LESC_ae54b48a-8f70-45c1-81cc-4ed8a6bc0e95_ZIP_','2022-01-19 15:17:03','2022-01-19 16:16:52','3_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-01-19 16:17:03','SYNCED','02dc36dc-042f-48ff-af0e-10111549609e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.3.1.1.1\",\"modelMatrix\":\"-0.862425,0.0225098,0.514183,0,-0.0216437,-0.999168,0.0310726,0,0.506555,0.0491997,0.857481,0,1.24261,3.48267,-26.4232,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'035fa0d1-dd19-497e-b90c-3eacf018100b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f4fc00ec-4af8-4a15-b427-f1c5aabf6260/session_498ae60a-23f0-44fc-9730-be499bfc4b46/occlusion_8f3d6c73-3468-45a5-85c7-93bba47ec9f7/scan_0d368f7d-e2ae-489f-b39f-cfe87c4103c8/30_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_f4fc00ec-4af8-4a15-b427-f1c5aabf6260_ACT_498ae60a-23f0-44fc-9730-be499bfc4b46_SESS_8f3d6c73-3468-45a5-85c7-93bba47ec9f7_TOSC_0d368f7d-e2ae-489f-b39f-cfe87c4103c8_SNAPS_','2022-06-14 13:26:12','2022-06-14 15:26:01','30_w1_o1_maxillaire_snapshot_0.png','2022-06-14 15:26:12','SYNCED','035fa0d1-dd19-497e-b90c-3eacf018100b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.30.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'038c47f3-791b-4934-8a4c-80a05ce0fbab','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/de078619-3946-4adb-a799-1c260e16face/session_24d0aeb5-3058-4070-aeea-97c289e41e3c/occlusion_ea6da896-1504-41fc-890c-7c48575e9e40/scan_aa24138a-68e8-4bc3-9a5d-d617f0fe496b/2_w1_o1_maxillaire_scan_file_2.zip','ZIP','PATIENT_de078619-3946-4adb-a799-1c260e16face_ACT_24d0aeb5-3058-4070-aeea-97c289e41e3c_SESS_ea6da896-1504-41fc-890c-7c48575e9e40_TOSC_aa24138a-68e8-4bc3-9a5d-d617f0fe496b_ZIP_','2022-01-19 14:09:10','2022-01-19 15:08:52','2_w1_o1_maxillaire_scan_file_2.zip','2022-01-19 15:09:10','SYNCED','80d822aa-8c38-4390-bdc1-0b044f167d73',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.2.1.1.1\",\"modelMatrix\":\"0.999693,0.0234182,-0.00803445,0,-0.0247581,0.94559,-0.324418,0,2.12043e-11,0.324518,0.94588,0,-21.3098,-33.4944,-23.4708,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'03f624d5-fb67-488f-ba6a-0e018eebce48','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7f47fd88-9ea0-4c08-9193-a54d4f158c7c/session_7873a396-419c-4215-83c7-fec9f2742ccf/occlusion_2e287bb0-e19a-414a-9177-23b335d286d9/scan_aa3849b7-bd16-41b9-8afe-0af192f363d1/16_w1_o2_mandibule_snapshot_1.png','SNAPS','PATIENT_7f47fd88-9ea0-4c08-9193-a54d4f158c7c_ACT_7873a396-419c-4215-83c7-fec9f2742ccf_SESS_2e287bb0-e19a-414a-9177-23b335d286d9_BOSC_aa3849b7-bd16-41b9-8afe-0af192f363d1_SNAPS_','2022-06-03 09:01:34','2022-06-03 11:01:25','16_w1_o2_mandibule_snapshot_1.png','2022-06-03 11:01:34','SYNCED','f1e9e673-dabe-4bb3-8a39-0e12c5205cb8',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.16.1.2.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'04e4a117-3200-4c26-85c5-6b14197f4b36','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_4f8dc275-857c-482a-9886-5521591e9661/scan_df08df19-150c-437d-8ed4-bf2826644265/12_w1_o4_mandibule_scan_file_2.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_BOSC_df08df19-150c-437d-8ed4-bf2826644265_ZIP_','2022-02-18 16:21:56','2022-02-18 17:21:46','12_w1_o4_mandibule_scan_file_2.zip','2022-02-18 17:21:56','SYNCED','68cf35d1-7f31-4f48-8b81-a07300151534',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.4.5\",\"modelMatrix\":\"0.544059,0.800225,-0.252267,0,-0.839047,0.518887,-0.163576,0,1.62336e-08,0.300659,0.953732,0,0.402905,-10.8858,-19.8968,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'04f31f25-40ed-4635-a2b0-b657241835d4','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_0b63813c-7fbe-455b-a5e3-483908522ff0/4_w1_o2_mandibule_snapshot_0.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_BOSC_0b63813c-7fbe-455b-a5e3-483908522ff0_SNAPS_','2022-02-15 12:48:20','2022-02-15 13:48:11','4_w1_o2_mandibule_snapshot_0.png','2022-02-15 13:48:20','SYNCED','04f31f25-40ed-4635-a2b0-b657241835d4',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.2.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'050930b4-ded7-45ca-885c-5ac156ea0cf7','','SNAPS','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_OCC_d8bec5dc-8405-473d-9ba5-ae6e461ed6fd_SNAPO__SNAPS_','2022-02-07 11:15:30','2022-02-04 19:13:44','','2022-02-07 12:15:30','SYNCED','050930b4-ded7-45ca-885c-5ac156ea0cf7',0,'2022-02-07 12:15:30','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'05c15182-223b-47c3-a79a-728540db8292','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/452a5200-3e06-4b74-8949-6abc7f2dda8a/session_3e95d626-668f-45f7-98ad-be2cf9d7b90b/occlusion_bce8310f-eee9-4f0a-a6b7-d592dec66be5/computedocclusion_d9818808-7d5e-47e6-9880-cc95357483ff/26_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_452a5200-3e06-4b74-8949-6abc7f2dda8a_ACT_3e95d626-668f-45f7-98ad-be2cf9d7b90b_SESS_bce8310f-eee9-4f0a-a6b7-d592dec66be5_OCC_d9818808-7d5e-47e6-9880-cc95357483ff_BOMA__MATRX_','2022-05-24 09:42:42','2022-05-24 11:42:41','26_w1_o1_mandibule_matrix_occ_file_0.m','2022-05-24 11:42:42','SYNCED','05c15182-223b-47c3-a79a-728540db8292',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.26.1.1.2 Occlusion 2\",\"referenceScanID\":\"1.26.1.1.2\",\"title\":\"Matrice Transfo. Mandibule 1.26.1.1.2 Occlusion 2\"}'),(1001,'0604d07a-bebf-444d-b0d3-ef45e6312bb6','','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_812fdd67-c9dc-4e0c-806a-0524a386b296_TOPLY__ZIP_','2022-02-07 17:55:14','2022-02-07 18:54:30','',NULL,'CREATED','0604d07a-bebf-444d-b0d3-ef45e6312bb6',0,'2022-02-07 18:55:14','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.17.1.1.1 Occlusion 5\",\"modelMatrix\":\"0.149253,0.920186,-0.361913,0,-0.988799,0.138896,-0.0546284,0,-8.90892e-10,0.366013,0.93061,0,-24.4594,-29.735,-12.8678,1\",\"referenceScanID\":\"1.17.1.1.1\",\"title\":\"Maxillaire 1.17.1.1.1 Occlusion 5\"}'),(2,'0695b9bc-6ebd-4a37-904a-5b84f5f478d6','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a4b302c-278d-4e12-ace5-f095ba0bf856/session_6206892a-2e7e-4765-ac90-b49bfb465997/occlusion_3c30231c-7cd7-4431-985b-2eaf7f6925ae/scan_21743037-e185-4ce7-80aa-af01b0d42c2d/3_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_21743037-e185-4ce7-80aa-af01b0d42c2d_SNAPS_','2022-09-06 09:20:42','2022-08-30 11:00:57','3_w1_o1_maxillaire_snapshot_0.png','2022-09-06 11:20:42','SYNCED','0695b9bc-6ebd-4a37-904a-5b84f5f478d6',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.3.1.1.6\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'070c1477-6bea-43bc-b0d6-b09d919b40c3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_be8c90b6-055f-49b1-a5b6-cb782162d6cd/12_w1_o1_mandibule_snapshot_2.png','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_be8c90b6-055f-49b1-a5b6-cb782162d6cd_SNAPS_','2022-02-04 12:39:32','2022-02-04 13:39:18','12_w1_o1_mandibule_snapshot_2.png','2022-02-04 13:39:32','SYNCED','09a60bd0-5644-4c1f-85c2-b6dfce87f5a8',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.6\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'072a7fd4-ae0e-46ae-8a9f-0fa5cc08ca50','','MATRX','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_OCC_ac3a5a7c-5db4-4c82-a2a9-9cb52e09f003_BOMA__MATRX_','2022-05-12 12:34:04','2022-05-12 14:33:33','',NULL,'CREATED','072a7fd4-ae0e-46ae-8a9f-0fa5cc08ca50',0,'2022-05-12 14:34:04','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.18.1.1.3 Occlusion 4\",\"referenceScanID\":\"1.18.1.1.3\",\"title\":\"Matrice Transfo. Mandibule 1.18.1.1.3 Occlusion 4\"}'),(1001,'0736b41f-5f3b-4cc2-98dc-956017612fa7','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/593972a6-d7d6-4802-b87d-38aab371f71e/session_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480/occlusion_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3/computedocclusion_e23c031c-2c78-414b-840d-85b58e959fbe/3_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_593972a6-d7d6-4802-b87d-38aab371f71e_ACT_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480_SESS_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3_OCC_e23c031c-2c78-414b-840d-85b58e959fbe_SNAPO__SNAPS_','2022-01-19 15:27:39','2022-01-19 16:26:52','3_w1_o1_snapshot_occ_file_0.png','2022-01-19 16:27:39','SYNCED','0736b41f-5f3b-4cc2-98dc-956017612fa7',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'07c3f250-4079-4176-a60e-48bb3a8bdedc','','ZIP','PATIENT_f9d03016-567a-4bd4-9cc5-dafeea34e365_ACT_a7bcb190-dd19-4f3b-8aab-266030bf4064_SESS_c321e210-b67c-40e8-bece-f8946164a768_LESC_25580af0-adbb-452a-8a44-6d9b1ca92471_ZIP_','2022-07-04 14:10:44','2022-07-04 16:07:52','','2022-07-04 16:10:44','SYNCED','07c3f250-4079-4176-a60e-48bb3a8bdedc',0,'2022-07-04 16:10:44','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.36.1.1.1\",\"modelMatrix\":\"-0.873504,0.0779007,0.479365,0,-0.0412056,-0.992002,0.106292,0,0.485647,0.104683,0.871462,0,-7.19234,-4.29622,-17.1182,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'07d4419f-c602-4dc8-b5f4-8c1ce7a7959b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/scan_a628b7db-c954-4964-8d48-1e09fa34d82b/1_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_RISC_a628b7db-c954-4964-8d48-1e09fa34d82b_SNAPS_','2022-01-19 12:59:18','2022-01-19 12:03:50','1_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-01-19 13:59:18','SYNCED','07d4419f-c602-4dc8-b5f4-8c1ce7a7959b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.1.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'081335b0-4cf5-4720-ac13-b858da5d8e93','','MATRX','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_OCC_778ed9fd-f658-471d-9dd0-a48417419cba_TOMA__MATRX_','2022-05-12 12:32:06','2022-05-12 14:31:43','',NULL,'CREATED','081335b0-4cf5-4720-ac13-b858da5d8e93',0,'2022-05-12 14:32:06','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.18.1.1.2 Occlusion 3\",\"referenceScanID\":\"1.18.1.1.2\",\"title\":\"Matrice Transfo. Maxillaire 1.18.1.1.2 Occlusion 3\"}'),(1001,'08509c37-5e28-4b88-b2ce-fd2bd6b2e379','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/computedocclusion_864c98a3-fcf7-466a-b999-13bd4dfb8c65/23_w1_o1_ml_occ_file_to1000.xyz','LIFI','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_864c98a3-fcf7-466a-b999-13bd4dfb8c65_LIFIO_LIFI_','2022-05-25 08:32:45','2022-05-25 10:32:43','23_w1_o1_ml_occ_file_to1000.xyz','2022-05-25 10:32:45','SYNCED','08509c37-5e28-4b88-b2ce-fd2bd6b2e379',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.23.1.1.1 Occlusion 3 Ligne de finition 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"Maxillaire\",\"name\":\"Ligne de finition 0\",\"title\":\"Ligne finition\",\"toothNumber\":1000}'),(1001,'086ee5b6-e3e6-4beb-9c14-6fea397482f6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a0c21836-ba79-4f15-9e35-02ef8211a9e5/session_0aac522d-3c38-465a-a1e0-014166c140ac/occlusion_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042/scan_dda4ec6d-010a-4593-be9f-97cb59747424/7_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_a0c21836-ba79-4f15-9e35-02ef8211a9e5_ACT_0aac522d-3c38-465a-a1e0-014166c140ac_SESS_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042_BOSC_dda4ec6d-010a-4593-be9f-97cb59747424_ZIP_','2022-02-02 10:14:56','2022-02-02 11:14:39','7_w1_o1_mandibule_scan_file_1.zip','2022-02-02 11:14:56','SYNCED','54af140d-b148-43e6-84b4-455ce19fbd59',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.7.1.1.1\",\"modelMatrix\":\"-0.95397,-0.276542,0.116045,0,0.299903,-0.879659,0.369132,0,-4.3083e-9,0.386943,0.922104,0,13.6932,12.2039,-15.7846,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'08725014-e287-4ddd-9b4f-f24b8ede2c81','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/452a5200-3e06-4b74-8949-6abc7f2dda8a/session_3e95d626-668f-45f7-98ad-be2cf9d7b90b/occlusion_bce8310f-eee9-4f0a-a6b7-d592dec66be5/computedocclusion_7a922eb8-5139-40fe-8402-fc7ff4204a1a/26_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_452a5200-3e06-4b74-8949-6abc7f2dda8a_ACT_3e95d626-668f-45f7-98ad-be2cf9d7b90b_SESS_bce8310f-eee9-4f0a-a6b7-d592dec66be5_OCC_7a922eb8-5139-40fe-8402-fc7ff4204a1a_TOPLY__ZIP_','2022-05-24 09:42:29','2022-05-24 11:42:09','26_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-05-24 11:42:29','SYNCED','08725014-e287-4ddd-9b4f-f24b8ede2c81',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.26.1.1.2 Occlusion 1\",\"modelMatrix\":\"-0.139935,0.977576,-0.157365,0,-0.990161,-0.138156,0.0222396,0,1.70026e-09,0.158929,0.98729,0,5.50609,-23.1559,-20.3156,1\",\"referenceScanID\":\"1.26.1.1.2\",\"title\":\"Maxillaire 1.26.1.1.2 Occlusion 1\"}'),(1001,'0900dead-3491-44ec-92ff-5e09fb9ec644','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_2a7068fc-0efa-496f-ade9-aba5b0650655/12_w1_o1_mandibule_snapshot_2.png','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_2a7068fc-0efa-496f-ade9-aba5b0650655_SNAPS_','2022-02-04 12:01:40','2022-02-04 12:56:15','12_w1_o1_mandibule_snapshot_2.png','2022-02-04 13:01:40','SYNCED','7636e0d7-f242-431c-90a5-a65399d83ecd',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.5\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'0960c7db-412b-47c9-a02f-f06e2e0da8a8','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/458c92d8-9da1-4df9-967f-d14fc7e6303d/session_55831d43-1906-4a22-9b7a-ed4b2820c8b2/occlusion_4f582d4c-81d0-4e01-8be3-9ff53b12c7f4/scan_6d0788eb-96a4-43dc-aa97-e9dbd7601d00/10_w2_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_55831d43-1906-4a22-9b7a-ed4b2820c8b2_SESS_4f582d4c-81d0-4e01-8be3-9ff53b12c7f4_BOSC_6d0788eb-96a4-43dc-aa97-e9dbd7601d00_SNAPS_','2022-06-16 13:35:06','2022-06-16 15:34:56','10_w2_o1_mandibule_snapshot_0.png','2022-06-16 15:35:06','SYNCED','0960c7db-412b-47c9-a02f-f06e2e0da8a8',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.10.2.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'09a60bd0-5644-4c1f-85c2-b6dfce87f5a8','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_be8c90b6-055f-49b1-a5b6-cb782162d6cd/12_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_be8c90b6-055f-49b1-a5b6-cb782162d6cd_SNAPS_','2022-02-04 12:32:22','2022-02-04 13:32:06','12_w1_o1_mandibule_snapshot_0.png','2022-02-04 13:32:22','SYNCED','09a60bd0-5644-4c1f-85c2-b6dfce87f5a8',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.6\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'0a58d1c6-38a8-4015-b4eb-e52116984b09','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_2a7068fc-0efa-496f-ade9-aba5b0650655/12_w1_o1_mandibule_scan_file_4.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_2a7068fc-0efa-496f-ade9-aba5b0650655_ZIP_','2022-02-04 12:02:09','2022-02-04 12:57:18','12_w1_o1_mandibule_scan_file_4.zip','2022-02-04 13:02:09','SYNCED','44ebcd6f-57c2-4cce-96f5-f9faa1c6b373',4,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.5\",\"modelMatrix\":\"0.713807,-0.664318,0.221723,0,0.700343,0.677089,-0.225986,0,-4.22566e-9,0.316593,0.948562,0,3.53751,30.2884,-29.5645,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'0a69600b-9dec-4bda-bf5d-cf963cc65c76','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/4a3954e0-1e2f-4721-9fdd-4180380dc19f/session_33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416/occlusion_3accbada-5a51-4d10-88d1-c3e7d8598d6f/scan_eb03dd9c-db3d-4d79-99ee-0715da7cea41/34_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_4a3954e0-1e2f-4721-9fdd-4180380dc19f_ACT_33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416_SESS_3accbada-5a51-4d10-88d1-c3e7d8598d6f_TOSC_eb03dd9c-db3d-4d79-99ee-0715da7cea41_ZIP_','2022-06-28 10:53:48','2022-06-28 12:53:41','34_w1_o1_maxillaire_scan_file_0.zip','2022-06-28 12:53:48','SYNCED','0a69600b-9dec-4bda-bf5d-cf963cc65c76',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.34.1.1.1\",\"modelMatrix\":\"0.433907,0.888246,-0.150809,0,-0.900958,0.427785,-0.0726306,0,2.15454e-09,0.167388,0.985891,0,-4.91739,-21.5763,-15.238,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'0a6f7e88-646e-4386-a4b9-0847224e61ab','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/computedocclusion_35af1bf5-285a-4bb1-a6db-fe9897defe51/23_w1_o1_ml_occ_file_to1000.xyz','LIFI','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_35af1bf5-285a-4bb1-a6db-fe9897defe51_LIFIO_LIFI_','2022-05-25 08:32:46','2022-05-25 10:32:43','23_w1_o1_ml_occ_file_to1000.xyz','2022-05-25 10:32:46','SYNCED','0a6f7e88-646e-4386-a4b9-0847224e61ab',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.23.1.1.1 Occlusion 4 Ligne de finition 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"Maxillaire\",\"name\":\"Ligne de finition 0\",\"title\":\"Ligne finition\",\"toothNumber\":1000}'),(1001,'0a9ebab4-2df3-4fb9-9a55-13558575a869','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/order_862350ae-e3fa-4271-a22e-8c96d4c89f10/22_w1_autre_prost_file_0a9ebab4-2df3-4fb9-9a55-13558575a869_0.pdf','PDF','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_PROST_862350ae-e3fa-4271-a22e-8c96d4c89f10_PDF_','2022-04-21 17:47:19','2022-04-21 19:47:17','22_w1_autre_prost_file_0a9ebab4-2df3-4fb9-9a55-13558575a869_0.pdf','2022-04-21 19:47:19','SYNCED','0a9ebab4-2df3-4fb9-9a55-13558575a869',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.22.1.1 AUTRE FICHE DE PROTHESE\",\"title\":\"Autre PDF\"}'),(1001,'0abefe94-3f85-4adb-b30a-34fe734e64a2','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/fa7fa96b-f393-4b9a-8198-144702462cfa/session_4bed076c-8541-4a2f-800a-5aeb4cb49de5/occlusion_16b82fca-4b65-4866-af87-1f6dbb42f5dc/computedocclusion_94a0167c-6798-4c78-a76c-cb9fc91ccdda/35_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_fa7fa96b-f393-4b9a-8198-144702462cfa_ACT_4bed076c-8541-4a2f-800a-5aeb4cb49de5_SESS_16b82fca-4b65-4866-af87-1f6dbb42f5dc_OCC_94a0167c-6798-4c78-a76c-cb9fc91ccdda_BOMA__MATRX_','2022-06-28 15:03:44','2022-06-28 17:03:25','35_w1_o1_mandibule_matrix_occ_file_0.m','2022-06-28 17:03:44','SYNCED','0abefe94-3f85-4adb-b30a-34fe734e64a2',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.35.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.35.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.35.1.1.1 Occlusion 1\"}'),(1001,'0b902cd8-144a-4a2d-a2da-dc9d7a13668b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/986374de-c4d7-4d6f-bf0c-2dc7e3b859a9/session_c81670ed-4144-4347-b19e-8057d11b5f7c/occlusion_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be/computedocclusion_7a5acfd0-87ca-4009-aa4e-677a88ceffde/28_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_986374de-c4d7-4d6f-bf0c-2dc7e3b859a9_ACT_c81670ed-4144-4347-b19e-8057d11b5f7c_SESS_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be_OCC_7a5acfd0-87ca-4009-aa4e-677a88ceffde_SNAPO__SNAPS_','2022-05-31 10:54:13','2022-05-31 12:53:55','28_w1_o1_snapshot_occ_file_0.png','2022-05-31 12:54:13','SYNCED','0b902cd8-144a-4a2d-a2da-dc9d7a13668b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'0ba98896-34dc-4662-8aca-beb999e99512','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/scan_03839278-13f8-46e6-9581-ba11bc8bcb81/1_w1_o1_maxillaire_snapshot_4.png','SNAPS','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_TOSC_03839278-13f8-46e6-9581-ba11bc8bcb81_SNAPS_','2022-01-19 13:00:20','2022-01-19 11:35:09','1_w1_o1_maxillaire_snapshot_4.png','2022-01-19 14:00:20','SYNCED','99c7b58b-6259-4c43-ac2f-8b7f47f0b3e7',4,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.1.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'0c0b6b4b-ea96-436e-870c-67030a45f51f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/computedocclusion_00405f86-eefa-41f9-8d98-1fa9cbeef855/24_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_00405f86-eefa-41f9-8d98-1fa9cbeef855_BOMA__MATRX_','2022-05-25 09:03:41','2022-05-25 11:02:54','24_w1_o1_mandibule_matrix_occ_file_0.m','2022-05-25 11:03:41','SYNCED','0c0b6b4b-ea96-436e-870c-67030a45f51f',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.24.1.1.1 Occlusion 4\",\"referenceScanID\":\"1.24.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.24.1.1.1 Occlusion 4\"}'),(1001,'0cc52590-1049-4b69-b1f4-fc0364e6ce81','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/order_220692cd-dfae-4cae-ae0f-48969e936e55/4_w1_autre_prost_file_0cc52590-1049-4b69-b1f4-fc0364e6ce81_0.pdf','PDF','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_PROST_220692cd-dfae-4cae-ae0f-48969e936e55_PDF_','2022-02-23 09:40:55','2022-02-23 10:40:54','4_w1_autre_prost_file_0cc52590-1049-4b69-b1f4-fc0364e6ce81_0.pdf','2022-02-23 10:40:55','SYNCED','0cc52590-1049-4b69-b1f4-fc0364e6ce81',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.4.1.1 AUTRE FICHE DE PROTHESE\",\"title\":\"Autre PDF\"}'),(1001,'0cf20f0f-ac97-4211-869b-4b322cf0e13e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_e6c95ef7-636d-4c88-8d02-e2d9840573db/13_w1_o1_mandibule_scan_file_9.zip','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_e6c95ef7-636d-4c88-8d02-e2d9840573db_ZIP_','2022-01-27 16:54:08','2022-01-27 17:50:13','13_w1_o1_mandibule_scan_file_9.zip','2022-01-27 17:54:08','SYNCED','bcef8d3e-9632-4976-8cda-4c6f3ac50e99',9,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.1\",\"modelMatrix\":\"-0.961822,0.259307,-0.0875072,0,-0.273675,-0.911329,0.307542,0,5.65717e-9,0.319749,0.947502,0,33.7925,-1.80222,-15.4388,1\",\"title\":\"Mandibule ZIP\"}'),(2,'0dbd0737-62de-4709-b376-5c0e86141952','','SNAPS','PATIENT_1095dc95-d70a-4936-8b50-ae8aa7963fc9_ACT_440a8315-0df8-4219-8d74-9470bfeeacbf_SESS_8cfb01ae-a13a-442b-9752-d2219bf5d263_TOSC_807a5b2c-0545-475c-b38c-00561d7c62df_SNAPS_','2022-08-30 08:32:23','2022-07-28 14:33:13','',NULL,'CREATED','0dbd0737-62de-4709-b376-5c0e86141952',0,'2022-08-30 10:32:23','bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.2.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'0e202590-c363-4913-9535-a4a43f96f003','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5/occlusion_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa/scan_6148a482-5ea5-4353-ace5-f0d520a32e6e/24_w2_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5_SESS_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa_TOSC_6148a482-5ea5-4353-ace5-f0d520a32e6e_ZIP_','2022-10-06 14:27:20','2022-10-06 16:27:08','24_w2_o1_maxillaire_scan_file_0.zip','2022-10-06 16:27:20','SYNCED','0e202590-c363-4913-9535-a4a43f96f003',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.2.1.1\",\"modelMatrix\":\"0.626985,0.76241,-0.160065,0,-0.779032,0.613607,-0.128824,0,4.39427e-09,0.205467,0.978664,0,0.203644,-29.5943,-18.0319,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'0eb7d0da-dd5e-458e-b51d-1b6310760ce8','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a0c21836-ba79-4f15-9e35-02ef8211a9e5/session_0aac522d-3c38-465a-a1e0-014166c140ac/occlusion_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042/scan_e3c95f99-398c-470f-97a1-8755ccbe1568/7_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_a0c21836-ba79-4f15-9e35-02ef8211a9e5_ACT_0aac522d-3c38-465a-a1e0-014166c140ac_SESS_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042_BOSC_e3c95f99-398c-470f-97a1-8755ccbe1568_SNAPS_','2022-01-21 11:56:39','2022-01-21 12:56:07','7_w1_o1_mandibule_snapshot_0.png','2022-01-21 12:56:39','SYNCED','0eb7d0da-dd5e-458e-b51d-1b6310760ce8',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.7.1.1.4\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'0ed2aa3b-9a59-495c-9032-f6eb5757beb8','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/computedocclusion_e15a2d21-e8f2-4d2a-9a68-13d92ae4b997/13_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_OCC_e15a2d21-e8f2-4d2a-9a68-13d92ae4b997_BOPLY__ZIP_','2022-02-04 18:24:38','2022-02-04 19:23:45','13_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-02-04 19:24:38','SYNCED','0ed2aa3b-9a59-495c-9032-f6eb5757beb8',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.5 Occlusion 3\",\"modelMatrix\":\"-0.996857,-0.0768567,0.0192233,0,0.0792243,-0.967066,0.241882,0,1.71456e-9,0.242644,0.970115,0,23.7843,9.22152,-23.0024,1\",\"referenceScanID\":\"1.13.1.1.5\",\"title\":\"Mandibule 1.13.1.1.5 Occlusion 3\"}'),(1001,'0f6e5816-9908-4996-af79-cabf91fcb4f3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/207d6dbc-c19b-4726-a9b3-16235ae554cc/session_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35/occlusion_dc5762a3-c453-4166-8c86-82d23ac9f8a6/scan_5139ec2e-4608-4b67-b0d1-bc4dc3498038/27_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_207d6dbc-c19b-4726-a9b3-16235ae554cc_ACT_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35_SESS_dc5762a3-c453-4166-8c86-82d23ac9f8a6_BOSC_5139ec2e-4608-4b67-b0d1-bc4dc3498038_SNAPS_','2022-05-30 11:02:22','2022-05-30 13:02:13','27_w1_o1_mandibule_snapshot_0.png','2022-05-30 13:02:22','SYNCED','0f6e5816-9908-4996-af79-cabf91fcb4f3',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.27.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'0ff1b82e-f12c-4a7b-a24b-df36ab306f9a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/occlusion_a2220645-c79d-4dda-b6cc-772384a4106b/computedocclusion_cf412dab-1d83-4db0-ae1b-d2724d5be97d/38_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_OCC_cf412dab-1d83-4db0-ae1b-d2724d5be97d_BOMA__MATRX_','2022-07-12 11:04:31','2022-07-12 13:04:14','38_w1_o1_mandibule_matrix_occ_file_0.m','2022-07-12 13:04:31','SYNCED','0ff1b82e-f12c-4a7b-a24b-df36ab306f9a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.38.1.1.1 Occlusion 2\",\"referenceScanID\":\"1.38.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.38.1.1.1 Occlusion 2\"}'),(1001,'10411aa0-2d8f-4c2d-bb34-619517bed145','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/207d6dbc-c19b-4726-a9b3-16235ae554cc/session_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35/occlusion_dc5762a3-c453-4166-8c86-82d23ac9f8a6/scan_db144753-52d9-4c43-950b-25093a3aee5f/27_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_207d6dbc-c19b-4726-a9b3-16235ae554cc_ACT_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35_SESS_dc5762a3-c453-4166-8c86-82d23ac9f8a6_RISC_db144753-52d9-4c43-950b-25093a3aee5f_SNAPS_','2022-05-30 11:09:16','2022-05-30 13:09:07','27_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-05-30 13:09:16','SYNCED','10411aa0-2d8f-4c2d-bb34-619517bed145',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.27.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'1050fd18-33ef-4994-bb2b-d74c35a009b6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f4fc00ec-4af8-4a15-b427-f1c5aabf6260/session_498ae60a-23f0-44fc-9730-be499bfc4b46/occlusion_8f3d6c73-3468-45a5-85c7-93bba47ec9f7/computedocclusion_9c318e86-fa90-4cd9-8319-2503cde2b455/30_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_f4fc00ec-4af8-4a15-b427-f1c5aabf6260_ACT_498ae60a-23f0-44fc-9730-be499bfc4b46_SESS_8f3d6c73-3468-45a5-85c7-93bba47ec9f7_OCC_9c318e86-fa90-4cd9-8319-2503cde2b455_TOMA__MATRX_','2022-06-14 13:30:12','2022-06-14 15:29:56','30_w1_o1_maxillaire_matrix_occ_file_0.m','2022-06-14 15:30:12','SYNCED','1050fd18-33ef-4994-bb2b-d74c35a009b6',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.30.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.30.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.30.1.1.1 Occlusion 1\"}'),(1001,'10ae0671-57c9-4c70-b4bc-4d8748fa1b1b','','MATRX','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_OCC_d58ce31f-4b72-44ad-b0e0-3d5d7d789322_BOMA__MATRX_','2022-01-19 11:15:36','2022-01-19 12:06:18','',NULL,'CREATED','10ae0671-57c9-4c70-b4bc-4d8748fa1b1b',0,'2022-01-19 12:15:36','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.1.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.1.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.1.1.1.1 Occlusion 1\"}'),(1001,'10b7f922-a161-46d6-acb1-9b8427a0b3e5','','MATRX','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_812fdd67-c9dc-4e0c-806a-0524a386b296_BOMA__MATRX_','2022-02-07 17:55:14','2022-02-07 18:54:30','',NULL,'CREATED','10b7f922-a161-46d6-acb1-9b8427a0b3e5',0,'2022-02-07 18:55:14','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.17.1.1.1 Occlusion 5\",\"referenceScanID\":\"1.17.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.17.1.1.1 Occlusion 5\"}'),(1001,'10d18c2a-96a4-4c73-984a-f7b73cfa9104','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/57c4096f-98dd-49c8-bea5-a5b109ad3fd0/session_4f62e395-5623-4d5b-869c-1b2fc4d22b00/occlusion_1ac20dc7-b36b-4786-a05f-37091554dc5c/scan_1808e07b-25f9-4fb8-a923-34263a3c0386/31_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_57c4096f-98dd-49c8-bea5-a5b109ad3fd0_ACT_4f62e395-5623-4d5b-869c-1b2fc4d22b00_SESS_1ac20dc7-b36b-4786-a05f-37091554dc5c_RISC_1808e07b-25f9-4fb8-a923-34263a3c0386_ZIP_','2022-06-16 11:03:37','2022-06-16 13:03:30','31_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-06-16 13:03:37','SYNCED','10d18c2a-96a4-4c73-984a-f7b73cfa9104',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.31.1.1.1\",\"modelMatrix\":\"0.993132,-0.00842034,0.116144,0,0.029398,0.983845,-0.174498,0,-0.11325,0.178838,0.977786,0,3.7926,-6.7524,-15.2927,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'11474084-e02d-4d01-b0c2-4dcae6ab6ef3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/8fc74d9e-a5a0-46bf-be3f-500548a130ad/session_5368829e-7dec-4775-a487-a1019f9604f4/occlusion_bb63a653-1b34-4d80-a4bf-7fda5c9b0360/scan_e3fea328-cb79-4ad5-a652-3eebe9ee3e12/14_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_8fc74d9e-a5a0-46bf-be3f-500548a130ad_ACT_5368829e-7dec-4775-a487-a1019f9604f4_SESS_bb63a653-1b34-4d80-a4bf-7fda5c9b0360_TOSC_e3fea328-cb79-4ad5-a652-3eebe9ee3e12_SNAPS_','2022-02-01 10:46:25','2022-02-01 11:41:44','14_w1_o1_maxillaire_snapshot_0.png','2022-02-01 11:46:25','SYNCED','11474084-e02d-4d01-b0c2-4dcae6ab6ef3',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.14.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'1147b9ad-8062-49b0-abb8-e21503c142a6','','MATRX','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_65f9077d-c859-4b2c-9d4d-692d723315a5_TOMA__MATRX_','2022-05-13 12:07:44','2022-05-13 14:07:00','','2022-05-13 14:07:44','SYNCED','1147b9ad-8062-49b0-abb8-e21503c142a6',0,'2022-05-13 14:07:44','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.23.1.1.1 Occlusion 4\",\"referenceScanID\":\"1.23.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.23.1.1.1 Occlusion 4\"}'),(1001,'11dc07f6-a7e5-45da-8192-128345b80de3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_b28164eb-0070-4968-83be-bfabe1a0c839/13_w1_o1_mandibule_scan_file_6.zip','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_b28164eb-0070-4968-83be-bfabe1a0c839_ZIP_','2022-02-04 17:57:42','2022-02-04 17:08:27','13_w1_o1_mandibule_scan_file_6.zip','2022-02-04 18:57:42','SYNCED','d8a3bf39-16d1-435f-bafa-6c625f77d811',6,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.5\",\"modelMatrix\":\"-0.999849,-0.0166313,0.00499618,0,0.0173655,-0.957574,0.287663,0,1.82324e-10,0.287707,0.957719,0,26.6518,7.14728,-23.0855,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'12e39583-f42e-4162-a7f2-f42b8732bef6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/scan_36a05dde-4390-4db1-9df5-ea42cd16ed7d/1_w1_o1_mordu_anterieur_scan_file_0.zip','ZIP','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_FRSC_36a05dde-4390-4db1-9df5-ea42cd16ed7d_ZIP_','2022-01-19 12:59:27','2022-01-19 12:11:01','1_w1_o1_mordu_anterieur_scan_file_0.zip','2022-01-19 13:59:27','SYNCED','12e39583-f42e-4162-a7f2-f42b8732bef6',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.1.1.1.1\",\"modelMatrix\":\"-0.283735,-0.96941,-0.010519,0,0.958521,-0.249899,-0.0306912,0,0.0509487,0.0174887,1.00037,0,-11.9297,20.5189,-27.6561,1\",\"title\":\"Mordu anterieur ZIP\"}'),(1001,'1307b63c-d68c-40b7-a3ff-4fc477f139dc','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/computedocclusion_7c70edbe-5cb4-4244-8baf-7caf2bd7d86b/12_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_OCC_7c70edbe-5cb4-4244-8baf-7caf2bd7d86b_SNAPO__SNAPS_','2022-02-04 17:59:24','2022-02-04 18:58:48','12_w1_o1_snapshot_occ_file_0.png','2022-02-04 18:59:24','SYNCED','1307b63c-d68c-40b7-a3ff-4fc477f139dc',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'13274aa9-059b-4fbd-be76-c9773cde9e63','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/69640c87-271c-4a44-a6fa-67b01654cc27/session_5f9199b0-eb37-4ed3-8d1a-6c38505d4913/occlusion_991beec3-fe9e-4c98-a3d4-c98e4a4c2471/scan_5f9e4be9-4eec-45c8-937d-583b1a5e8642/39_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_BOSC_5f9e4be9-4eec-45c8-937d-583b1a5e8642_SNAPS_','2022-09-09 16:15:03','2022-09-09 18:14:02','39_w1_o1_mandibule_snapshot_0.png','2022-09-09 18:15:03','SYNCED','13274aa9-059b-4fbd-be76-c9773cde9e63',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.39.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'135e8c27-bf0a-4d0f-b495-291e99638543','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/occlusion_e08bbeeb-a30b-428c-bd4a-40198f792219/scan_ef1d20c7-5f61-4c35-8f0f-d85507cab786/25_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_SESS_e08bbeeb-a30b-428c-bd4a-40198f792219_BOSC_ef1d20c7-5f61-4c35-8f0f-d85507cab786_SNAPS_','2022-05-17 16:11:04','2022-05-17 18:10:54','25_w1_o1_mandibule_snapshot_0.png','2022-05-17 18:11:04','SYNCED','135e8c27-bf0a-4d0f-b495-291e99638543',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.25.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'1427d616-5653-4d37-a57b-c647c2ad237c','','MATRX','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_OCC_87edc123-163f-46ce-be5c-45f2ff80b857_TOMA__MATRX_','2022-05-12 12:27:27','2022-05-12 14:26:51','','2022-05-12 14:27:27','SYNCED','1427d616-5653-4d37-a57b-c647c2ad237c',0,'2022-05-12 14:27:27','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.18.1.1.2 Occlusion 3\",\"referenceScanID\":\"1.18.1.1.2\",\"title\":\"Matrice Transfo. Maxillaire 1.18.1.1.2 Occlusion 3\"}'),(1001,'1485361c-1943-4401-8ed1-23059245eae1','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/1c189ddc-0ee7-45e7-9d80-585dac08374a/session_01bd0635-6ec6-42cb-8561-8638bded352c/occlusion_2aa712ca-8b46-4a50-a03e-1c6a6a0c40fc/computedocclusion_727485e0-8637-4024-83d8-95544991f73f/29_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_1c189ddc-0ee7-45e7-9d80-585dac08374a_ACT_01bd0635-6ec6-42cb-8561-8638bded352c_SESS_2aa712ca-8b46-4a50-a03e-1c6a6a0c40fc_OCC_727485e0-8637-4024-83d8-95544991f73f_TOMA__MATRX_','2022-06-03 14:07:17','2022-06-03 16:07:00','29_w1_o1_maxillaire_matrix_occ_file_0.m','2022-06-03 16:07:17','SYNCED','1485361c-1943-4401-8ed1-23059245eae1',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.29.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.29.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.29.1.1.1 Occlusion 1\"}'),(1001,'1534b13d-c7b3-496e-9c8e-5f6fa0e172a0','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_aa38e68a-4c1f-4e58-a176-2a4d533c35a0/24_w1_o1_mordu_posterieur_gauche_scan_file_1.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_LESC_aa38e68a-4c1f-4e58-a176-2a4d533c35a0_ZIP_','2022-05-13 16:15:40','2022-05-13 18:15:33','24_w1_o1_mordu_posterieur_gauche_scan_file_1.zip','2022-05-13 18:15:40','SYNCED','cf34344a-9be8-4726-893c-bb841db45a19',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.24.1.1.2\",\"modelMatrix\":\"0.792987,0.149859,-0.592819,0,-0.322886,0.925453,-0.206041,0,0.51664,0.348069,0.77858,0,-5.39761,-12.4459,-28.9289,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'1560fe3c-2fde-4b99-b398-f1c254efa26c','','ZIP','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_65f9077d-c859-4b2c-9d4d-692d723315a5_TOPLY__ZIP_','2022-05-13 12:07:45','2022-05-13 14:07:00','','2022-05-13 14:07:45','SYNCED','1560fe3c-2fde-4b99-b398-f1c254efa26c',0,'2022-05-13 14:07:45','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.23.1.1.1 Occlusion 4\",\"modelMatrix\":\"-0.996412,0.0371381,-0.0760535,0,-0.0846367,-0.43722,0.895363,0,9.59179e-10,0.898588,0.438794,0,-5.67604,-22.9357,-12.9416,1\",\"referenceScanID\":\"1.23.1.1.1\",\"title\":\"Maxillaire 1.23.1.1.1 Occlusion 4\"}'),(1001,'158c2a75-1b0f-417a-8ed0-a7fb6ac2a492','','SNAPS','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_7d8decb1-23db-4824-940f-8d8822d88813_SNAPO__SNAPS_','2022-02-08 08:48:58','2022-02-07 18:48:45','','2022-02-08 09:48:58','SYNCED','158c2a75-1b0f-417a-8ed0-a7fb6ac2a492',0,'2022-02-08 09:48:58','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'15a6f8e8-d619-49b9-ac67-6a80eb3f2f9f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/order_d9158af5-bd4d-41e7-8357-3f09c9b95671/25_w1_autre_prost_file_15a6f8e8-d619-49b9-ac67-6a80eb3f2f9f_0.pdf','PDF','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_PROST_d9158af5-bd4d-41e7-8357-3f09c9b95671_PDF_','2022-05-18 14:11:49','2022-05-18 16:11:48','25_w1_autre_prost_file_15a6f8e8-d619-49b9-ac67-6a80eb3f2f9f_0.pdf','2022-05-18 16:11:49','SYNCED','15a6f8e8-d619-49b9-ac67-6a80eb3f2f9f',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.25.1.1 AUTRE FICHE DE PROTHESE\",\"title\":\"Autre PDF\"}'),(1001,'16aca5f6-a7b2-4fba-8fb4-5317db833f5f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_731ce686-8c03-4019-bc8e-040c31652c88/4_w1_o2_mandibule_scan_file_0.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_BOSC_731ce686-8c03-4019-bc8e-040c31652c88_ZIP_','2022-03-08 12:00:04','2022-03-08 12:59:57','4_w1_o2_mandibule_scan_file_0.zip','2022-03-08 13:00:04','SYNCED','16aca5f6-a7b2-4fba-8fb4-5317db833f5f',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.2.4\",\"modelMatrix\":\"0.246751,0.968429,-0.0354996,0,-0.969079,0.246585,-0.00903904,0,3.89658e-10,0.0366323,0.999329,0,0.572804,7.07408,-21.9357,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'16bbc6bf-911d-4d19-a2a7-d67f58277348','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_71fd8305-087d-4c31-82c4-b83df7b3cc9a/4_w1_o2_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_RISC_71fd8305-087d-4c31-82c4-b83df7b3cc9a_SNAPS_','2022-02-15 12:34:19','2022-02-15 13:34:12','4_w1_o2_mordu_posterieur_droit_snapshot_0.png','2022-02-15 13:34:19','SYNCED','16bbc6bf-911d-4d19-a2a7-d67f58277348',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.4.1.2.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'174df459-b65b-4330-9f93-b725dfc602d1','','MATRX','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_9440baee-a8bf-406c-bc0a-f5e9596f197b_TOMA__MATRX_','2022-05-13 16:14:04','2022-05-13 18:13:11','','2022-05-13 18:14:04','SYNCED','174df459-b65b-4330-9f93-b725dfc602d1',0,'2022-05-13 18:14:04','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.24.1.1.2 Occlusion 3\",\"referenceScanID\":\"1.24.1.1.2\",\"title\":\"Matrice Transfo. Maxillaire 1.24.1.1.2 Occlusion 3\"}'),(1001,'1759d630-e2be-4ef5-8fe0-f2f6a8a10873','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/computedocclusion_8e4092a3-64a2-4464-addd-03b3c8ba2289/24_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_8e4092a3-64a2-4464-addd-03b3c8ba2289_SNAPO__SNAPS_','2022-05-13 16:21:26','2022-05-13 18:20:53','24_w1_o1_snapshot_occ_file_0.png','2022-05-13 18:21:26','SYNCED','1759d630-e2be-4ef5-8fe0-f2f6a8a10873',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'175aa819-aaa5-44a2-bc16-b58049070c3b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/computedocclusion_864c98a3-fcf7-466a-b999-13bd4dfb8c65/23_w1_o1_mlmeta_occ_file_to1002.bin','LIFIM','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_864c98a3-fcf7-466a-b999-13bd4dfb8c65_LIFIMO_LIFIM_','2022-05-25 10:46:45','2022-05-25 12:46:42','23_w1_o1_mlmeta_occ_file_to1002.bin','2022-05-25 12:46:45','SYNCED','175aa819-aaa5-44a2-bc16-b58049070c3b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.23.1.1.1 Occlusion 3 Ligne de finition 2\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"Maxillaire\",\"name\":\"Ligne de finition 2\",\"title\":\"Ligne finition metadata\",\"toothNumber\":1002}'),(1001,'17b7f3d2-9eaa-4daf-98f2-0e902832966d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_2a7068fc-0efa-496f-ade9-aba5b0650655/12_w1_o1_mandibule_snapshot_7.png','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_2a7068fc-0efa-496f-ade9-aba5b0650655_SNAPS_','2022-02-04 12:15:36','2022-02-04 13:14:57','12_w1_o1_mandibule_snapshot_7.png','2022-02-04 13:15:36','SYNCED','7636e0d7-f242-431c-90a5-a65399d83ecd',7,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.5\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'17fda618-cda1-4757-8ea4-c62a6ae8991c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_04d6e3f1-19ce-4851-a9d0-40419cea7542/scan_fef6f617-40e8-4052-8a2d-9af9e39ab22d/19_w1_o2_mandibule_snapshot_2.png','SNAPS','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_04d6e3f1-19ce-4851-a9d0-40419cea7542_BOSC_fef6f617-40e8-4052-8a2d-9af9e39ab22d_SNAPS_','2022-04-15 14:07:00','2022-04-15 16:06:47','19_w1_o2_mandibule_snapshot_2.png','2022-04-15 16:07:00','SYNCED','5a1c3667-dbf3-4de6-af8e-149a263ba435',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.2.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'189a792c-fafa-4b60-958f-637d69400a83','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_b28164eb-0070-4968-83be-bfabe1a0c839/13_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_b28164eb-0070-4968-83be-bfabe1a0c839_SNAPS_','2022-02-04 17:55:03','2022-02-04 16:57:48','13_w1_o1_mandibule_snapshot_0.png','2022-02-04 18:55:03','SYNCED','189a792c-fafa-4b60-958f-637d69400a83',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule SNAPSHOT\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'18c3af60-0e70-4145-8e6d-00bea7e76567','','ZIP','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_RISC_b434cfd5-6ef9-4523-92e9-9f68fc4af6be_ZIP_','2022-09-09 16:21:09','2022-09-09 18:15:03','','2022-09-09 18:21:09','SYNCED','18c3af60-0e70-4145-8e6d-00bea7e76567',0,'2022-09-09 18:21:09','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.39.1.1.1\",\"modelMatrix\":\"0.985198,0.107441,0.133561,0,-0.107614,0.993941,0.014647,0,-0.13347,-0.0238721,0.990949,0,4.2555,7.67257,-15.8185,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'1918f151-9602-438b-911f-8fa1ba5b7218','','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_OCC_e9a397c8-e329-4471-985b-0eb40ed458b0_TOPLY__ZIP_','2022-02-04 15:01:39','2022-02-04 14:50:30','','2022-02-04 16:01:39','SYNCED','1918f151-9602-438b-911f-8fa1ba5b7218',0,'2022-02-04 16:01:39','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.12.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.622652,0.772747,-0.123153,0,-0.782499,0.614892,-0.0979959,0,-5.00422e-9,0.157385,0.987537,0,-21.5256,-19.2669,-19.1349,1\",\"referenceScanID\":\"1.12.1.1.1\",\"title\":\"Maxillaire 1.12.1.1.1 Occlusion 1\"}'),(1001,'1927c87b-194f-4939-b2e1-0a49fcbd011f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_7048f93c-1091-4f02-bc64-b73347dfa962/24_w1_o1_mordu_posterieur_droit_snapshot_1.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_RISC_7048f93c-1091-4f02-bc64-b73347dfa962_SNAPS_','2022-06-13 15:02:10','2022-06-13 17:02:03','24_w1_o1_mordu_posterieur_droit_snapshot_1.png','2022-06-13 17:02:10','SYNCED','6ed13785-759e-4640-96b7-73753d0c8c51',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.24.1.1.3\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'196b0af5-8cf0-44bd-bad9-a4b7a53bd42b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/8fc74d9e-a5a0-46bf-be3f-500548a130ad/session_5368829e-7dec-4775-a487-a1019f9604f4/occlusion_bb63a653-1b34-4d80-a4bf-7fda5c9b0360/scan_812e813b-02e0-44c6-bb91-8e662cd9a614/14_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_8fc74d9e-a5a0-46bf-be3f-500548a130ad_ACT_5368829e-7dec-4775-a487-a1019f9604f4_SESS_bb63a653-1b34-4d80-a4bf-7fda5c9b0360_LESC_812e813b-02e0-44c6-bb91-8e662cd9a614_SNAPS_','2022-02-01 10:51:03','2022-02-01 11:50:54','14_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-02-01 11:51:03','SYNCED','196b0af5-8cf0-44bd-bad9-a4b7a53bd42b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.14.1.1.2\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'198065c3-4dda-432e-9e76-0641770f2cf5','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_77ec818f-d778-4945-9458-90665b5522ba/17_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_TOSC_77ec818f-d778-4945-9458-90665b5522ba_SNAPS_','2022-02-07 11:35:19','2022-02-07 12:26:05','17_w1_o1_maxillaire_snapshot_1.png','2022-02-07 12:35:19','SYNCED','e4232ec2-aa4d-453c-8af0-16f147580e79',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.17.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'19ea170f-c063-4a37-972a-35885657c236','','MATRX','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_9440baee-a8bf-406c-bc0a-f5e9596f197b_BOMA__MATRX_','2022-05-13 16:14:03','2022-05-13 18:13:11','','2022-05-13 18:14:03','SYNCED','19ea170f-c063-4a37-972a-35885657c236',0,'2022-05-13 18:14:03','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.24.1.1.1 Occlusion 3\",\"referenceScanID\":\"1.24.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.24.1.1.1 Occlusion 3\"}'),(1001,'1a0767db-326c-4cdc-96d6-37bbfc6c059c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/45ff7437-0691-4427-a7da-8250862e4b96/session_4ff9c682-c09d-42ff-8c29-aeb13e066ed2/occlusion_934673c1-a4b9-4508-ac1b-a03092a0693e/computedocclusion_161f60a4-d4f2-41f1-98ad-a8ccad84216c/9_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_45ff7437-0691-4427-a7da-8250862e4b96_ACT_4ff9c682-c09d-42ff-8c29-aeb13e066ed2_SESS_934673c1-a4b9-4508-ac1b-a03092a0693e_OCC_161f60a4-d4f2-41f1-98ad-a8ccad84216c_SNAPO__SNAPS_','2022-01-24 17:47:25','2022-01-24 18:46:00','9_w1_o1_snapshot_occ_file_0.png','2022-01-24 18:47:25','SYNCED','1a0767db-326c-4cdc-96d6-37bbfc6c059c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'1a099ce4-e506-42cd-880e-d56cf533b172','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/c8418992-7324-4a11-9437-bf2bb0fa802f/session_ff05cb1f-6c46-4287-9cdd-81bf817a9c78/occlusion_f6f084bb-a5f1-4f39-860f-1483132c8283/scan_9263fb3c-bf3a-443f-8c9b-4d12244b4612/11_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_c8418992-7324-4a11-9437-bf2bb0fa802f_ACT_ff05cb1f-6c46-4287-9cdd-81bf817a9c78_SESS_f6f084bb-a5f1-4f39-860f-1483132c8283_TOSC_9263fb3c-bf3a-443f-8c9b-4d12244b4612_ZIP_','2022-01-25 15:43:38','2022-01-25 16:42:41','11_w1_o1_maxillaire_scan_file_0.zip','2022-01-25 16:43:38','SYNCED','1a099ce4-e506-42cd-880e-d56cf533b172',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.11.1.1.1\",\"modelMatrix\":\"-0.665268,0.740224,-0.097398,0,-0.746605,-0.659583,0.0867872,0,6.12842e-9,0.130455,0.991454,0,7.84336,-27.4628,-19.7451,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'1a33cdc9-13ae-4967-b870-f6fd01e98f27','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_8cd7948c-ef59-4b88-a894-5b497d849e92/24_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_RISC_8cd7948c-ef59-4b88-a894-5b497d849e92_SNAPS_','2022-05-24 14:55:21','2022-05-24 16:55:13','24_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-05-24 16:55:21','SYNCED','1a33cdc9-13ae-4967-b870-f6fd01e98f27',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.24.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'1a697c44-46ac-43a0-82b9-a46dbc74a391','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/occlusion_a2220645-c79d-4dda-b6cc-772384a4106b/computedocclusion_8b14563e-0862-4cac-8045-e8aed2be886d/38_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_OCC_8b14563e-0862-4cac-8045-e8aed2be886d_TOPLY__ZIP_','2022-07-12 10:57:42','2022-07-12 12:57:24','38_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-07-12 12:57:42','SYNCED','1a697c44-46ac-43a0-82b9-a46dbc74a391',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.38.1.1.1 Occlusion 1\",\"modelMatrix\":\"-0.298707,0.922945,-0.242789,0,-0.954345,-0.288879,0.0759925,0,9.14042e-10,0.254404,0.967098,0,20.3691,-25.7421,-14.8867,1\",\"referenceScanID\":\"1.38.1.1.1\",\"title\":\"Maxillaire 1.38.1.1.1 Occlusion 1\"}'),(1001,'1aa1663d-b6c0-47cd-9157-0c17e591468c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/occlusion_e08bbeeb-a30b-428c-bd4a-40198f792219/computedocclusion_a503ab26-f707-4923-86b6-049c17f73533/25_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_SESS_e08bbeeb-a30b-428c-bd4a-40198f792219_OCC_a503ab26-f707-4923-86b6-049c17f73533_TOPLY__ZIP_','2022-05-17 16:40:45','2022-05-17 18:40:25','25_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-05-17 18:40:45','SYNCED','1aa1663d-b6c0-47cd-9157-0c17e591468c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.25.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.999921,-0.0124601,0.00173472,0,0.0125803,0.990369,-0.137881,0,5.51735e-11,0.137892,0.990447,0,12.823,6.75113,-24.6355,1\",\"referenceScanID\":\"1.25.1.1.1\",\"title\":\"Maxillaire 1.25.1.1.1 Occlusion 1\"}'),(1001,'1b9c8ae0-a860-49fe-a798-7ebbebcd8510','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7f47fd88-9ea0-4c08-9193-a54d4f158c7c/session_7873a396-419c-4215-83c7-fec9f2742ccf/occlusion_2e287bb0-e19a-414a-9177-23b335d286d9/scan_05d5d943-3268-4239-ac7d-5efbc2d2ab9b/16_w1_o2_maxillaire_scan_file_1.zip','ZIP','PATIENT_7f47fd88-9ea0-4c08-9193-a54d4f158c7c_ACT_7873a396-419c-4215-83c7-fec9f2742ccf_SESS_2e287bb0-e19a-414a-9177-23b335d286d9_TOSC_05d5d943-3268-4239-ac7d-5efbc2d2ab9b_ZIP_','2022-06-03 08:52:14','2022-06-03 10:52:05','16_w1_o2_maxillaire_scan_file_1.zip','2022-06-03 10:52:14','SYNCED','74b28d88-c271-4aef-ac3b-1c8d372ae615',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.16.1.2.1\",\"modelMatrix\":\"-0.655868,0.747425,-0.105795,0,-0.754875,-0.649395,0.091919,0,-1.02677e-10,0.140149,0.99013,0,13.4773,-13.0045,-20.4999,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'1bc4344e-c5ca-4ed5-b6d6-551607344b94','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_04abc032-a797-420b-8d5e-ee9528f5e291/12_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_FRSC_04abc032-a797-420b-8d5e-ee9528f5e291_SNAPS_','2022-02-04 12:19:29','2022-02-04 13:19:19','12_w1_o1_mordu_anterieur_snapshot_0.png','2022-02-04 13:19:29','SYNCED','1bc4344e-c5ca-4ed5-b6d6-551607344b94',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.12.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'1bfdf28b-74a5-4572-8ee8-9f2091668cf7','','MATRX','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_cb4cdc08-5d89-48dc-80a3-2e659c55f971_TOMA__MATRX_','2022-02-08 08:48:59','2022-02-07 18:52:17','','2022-02-08 09:48:59','SYNCED','1bfdf28b-74a5-4572-8ee8-9f2091668cf7',0,'2022-02-08 09:48:59','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.17.1.1.1 Occlusion 4\",\"referenceScanID\":\"1.17.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.17.1.1.1 Occlusion 4\"}'),(1001,'1c6296d6-4a5b-4cfb-b3c5-73fe516033e7','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_16f04a07-72e8-4a39-9b55-3ae7405733af/24_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_TOSC_16f04a07-72e8-4a39-9b55-3ae7405733af_ZIP_','2022-06-13 14:42:43','2022-06-13 16:42:31','24_w1_o1_maxillaire_scan_file_1.zip','2022-06-13 16:42:43','SYNCED','d3ff533f-e540-46c8-8f68-b5341a94ad72',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.4\",\"modelMatrix\":\"0.56797,0.795218,-0.212224,0,-0.823049,0.548764,-0.146451,0,-1.57613e-08,0.25785,0.966185,0,-15.7017,-3.48081,-19.4449,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'1c676927-9bdf-4dde-88d2-e62e956f53e3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_e6c95ef7-636d-4c88-8d02-e2d9840573db/13_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_e6c95ef7-636d-4c88-8d02-e2d9840573db_SNAPS_','2022-01-28 17:11:15','2022-01-27 17:40:37','13_w1_o1_mandibule_snapshot_1.png','2022-01-28 18:11:15','SYNCED','ac0f8bbb-d9a6-428c-a397-1febe6de5982',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'1c7456f3-a02f-42dc-a4f0-35f09bbaa740','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_cb7d52e7-16ce-470b-9b62-b1f627e9badc/18_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_RISC_cb7d52e7-16ce-470b-9b62-b1f627e9badc_ZIP_','2022-03-07 14:33:35','2022-03-07 15:33:29','18_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-03-07 15:33:35','SYNCED','1c7456f3-a02f-42dc-a4f0-35f09bbaa740',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.18.1.1.2\",\"modelMatrix\":\"0.987719,0.0315531,0.160783,0,0.0010254,0.977441,-0.213889,0,-0.156434,0.208857,0.963571,0,3.95362,0.226955,-18.1408,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'1cb9b372-74dd-4ae5-ab0d-283626d588f0','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_2ffbfbca-f236-4802-be93-8eb43d523274/scan_eb904683-acc6-4e6d-8900-3982d403ba0f/4_w1_o1_mordu_anterieur_snapshot_1.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_2ffbfbca-f236-4802-be93-8eb43d523274_FRSC_eb904683-acc6-4e6d-8900-3982d403ba0f_SNAPS_','2022-01-19 19:13:34','2022-01-19 20:13:22','4_w1_o1_mordu_anterieur_snapshot_1.png','2022-01-19 20:13:34','SYNCED','416db3c9-b04a-404f-8271-79d9066b8d08',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.4.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'1cc7ae90-17d0-4892-b281-93a08c20fffa','','MATRX','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_1500b3eb-4b86-46c1-9c9f-7efbd0224ac8_TOMA__MATRX_','2022-05-25 08:56:38','2022-05-13 18:22:04','','2022-05-25 10:56:38','SYNCED','1cc7ae90-17d0-4892-b281-93a08c20fffa',0,'2022-05-25 10:56:38','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.24.1.1.2 Occlusion 4\",\"referenceScanID\":\"1.24.1.1.2\",\"title\":\"Matrice Transfo. Maxillaire 1.24.1.1.2 Occlusion 4\"}'),(1001,'1d033a05-b36d-48d3-a077-cba01c0ba281','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/computedocclusion_35af1bf5-285a-4bb1-a6db-fe9897defe51/23_w1_o1_mlmeta_occ_file_to1001.bin','LIFIM','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_35af1bf5-285a-4bb1-a6db-fe9897defe51_LIFIMO_LIFIM_','2022-05-25 10:45:11','2022-05-25 12:45:09','23_w1_o1_mlmeta_occ_file_to1001.bin','2022-05-25 12:45:11','SYNCED','1d033a05-b36d-48d3-a077-cba01c0ba281',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.23.1.1.1 Occlusion 4 Ligne de finition 1\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"Maxillaire\",\"name\":\"Ligne de finition 1\",\"title\":\"Ligne finition metadata\",\"toothNumber\":1001}'),(1001,'1d22f124-58fe-452c-bb7d-54d19e0ed5d4','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/69640c87-271c-4a44-a6fa-67b01654cc27/session_5f9199b0-eb37-4ed3-8d1a-6c38505d4913/occlusion_991beec3-fe9e-4c98-a3d4-c98e4a4c2471/computedocclusion_c7bccd1e-370e-4347-8296-1bcd4c30b631/39_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_OCC_c7bccd1e-370e-4347-8296-1bcd4c30b631_BOPLY__ZIP_','2022-09-10 09:46:17','2022-09-10 11:45:43','39_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-09-10 11:46:17','SYNCED','1d22f124-58fe-452c-bb7d-54d19e0ed5d4',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.39.1.1.1 Occlusion 10\",\"modelMatrix\":\"-0.977808,0.200729,-0.0599951,0,-0.209503,-0.936857,0.280013,0,3.36067e-09,0.286368,0.95812,0,23.2439,5.67049,-19.9331,1\",\"referenceScanID\":\"1.39.1.1.1\",\"title\":\"Mandibule 1.39.1.1.1 Occlusion 10\"}'),(1001,'1d255ba6-133d-4e2f-b133-667c46f08b4b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_8cd7948c-ef59-4b88-a894-5b497d849e92/24_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_RISC_8cd7948c-ef59-4b88-a894-5b497d849e92_ZIP_','2022-05-24 14:55:21','2022-05-24 16:55:14','24_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-05-24 16:55:21','SYNCED','1d255ba6-133d-4e2f-b133-667c46f08b4b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.24.1.1.1\",\"modelMatrix\":\"0.995776,-0.0533792,0.0847523,0,0.0415956,0.997888,-0.0407471,0,-0.0832184,0.0402666,0.995582,0,5.84452,-6.13542,-17.4079,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'1d77467f-1eb7-4fb2-8d86-69476c13ccff','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/scan_f2bad12a-451d-406d-98b0-e431a37951dd/19_w1_o1_mandibule_snapshot_2.png','SNAPS','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_BOSC_f2bad12a-451d-406d-98b0-e431a37951dd_SNAPS_','2022-03-08 10:48:39','2022-03-08 11:48:29','19_w1_o1_mandibule_snapshot_2.png','2022-03-08 11:48:39','SYNCED','8fb19261-9e70-4678-8a85-98e89dd98dcb',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.1.4\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'1e204833-d2dd-4476-a89b-bac41168472a','','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_BOSC_f8b316c9-3008-451e-bdae-0fb8163c2756_SNAPS_','2022-02-19 17:53:23','2022-02-18 16:58:19','','2022-02-19 18:53:23','SYNCED','1e204833-d2dd-4476-a89b-bac41168472a',0,'2022-02-19 18:53:23','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.4.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'1e2ab731-95d9-4ab4-b9e3-2a30e1ede882','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_04d6e3f1-19ce-4851-a9d0-40419cea7542/scan_9e43db2d-10a9-414e-ac07-6b7642412ce5/19_w1_o2_maxillaire_scan_file_1.zip','ZIP','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_04d6e3f1-19ce-4851-a9d0-40419cea7542_TOSC_9e43db2d-10a9-414e-ac07-6b7642412ce5_ZIP_','2022-04-15 11:41:49','2022-04-01 18:18:33','19_w1_o2_maxillaire_scan_file_1.zip','2022-04-15 13:41:49','SYNCED','bf1a3548-3c4b-44f2-98bd-9b8130cf0fb8',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.19.1.2.1\",\"modelMatrix\":\"0.233501,0.918982,-0.317724,0,-0.972357,0.220683,-0.076298,0,5.73627e-09,0.326757,0.945108,0,14.2402,-14.8737,-20.3712,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'1e34800f-6443-4433-a2fd-ac3d1de66258','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/452a5200-3e06-4b74-8949-6abc7f2dda8a/session_3e95d626-668f-45f7-98ad-be2cf9d7b90b/occlusion_bce8310f-eee9-4f0a-a6b7-d592dec66be5/computedocclusion_7a922eb8-5139-40fe-8402-fc7ff4204a1a/26_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_452a5200-3e06-4b74-8949-6abc7f2dda8a_ACT_3e95d626-668f-45f7-98ad-be2cf9d7b90b_SESS_bce8310f-eee9-4f0a-a6b7-d592dec66be5_OCC_7a922eb8-5139-40fe-8402-fc7ff4204a1a_BOPLY__ZIP_','2022-05-24 09:42:18','2022-05-24 11:42:09','26_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-05-24 11:42:18','SYNCED','1e34800f-6443-4433-a2fd-ac3d1de66258',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.26.1.1.2 Occlusion 1\",\"modelMatrix\":\"-0.440993,0.868318,-0.227045,0,-0.89751,-0.426649,0.111559,0,-1.10485e-08,0.252972,0.967474,0,8.55795,-16.8564,-17.5092,1\",\"referenceScanID\":\"1.26.1.1.2\",\"title\":\"Mandibule 1.26.1.1.2 Occlusion 1\"}'),(1001,'1e723f20-3875-49b6-b45e-d9be499a3768','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_f62659c6-4f30-430c-95e4-d14e40327192/13_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_FRSC_f62659c6-4f30-430c-95e4-d14e40327192_SNAPS_','2022-02-04 17:55:12','2022-02-04 17:27:11','13_w1_o1_mordu_anterieur_snapshot_0.png','2022-02-04 18:55:12','SYNCED','1e723f20-3875-49b6-b45e-d9be499a3768',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.13.1.1.2\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'1e88200b-6ed2-4ef3-a449-f66ac52fc40b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/occlusion_a2220645-c79d-4dda-b6cc-772384a4106b/scan_0136d883-d517-448a-82a3-bfcdd5f4c35c/38_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_TOSC_0136d883-d517-448a-82a3-bfcdd5f4c35c_ZIP_','2022-07-19 12:30:54','2022-07-19 14:30:45','38_w1_o1_maxillaire_scan_file_1.zip','2022-07-19 14:30:54','SYNCED','229065de-cf1c-4956-8237-67f43f93246b',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.38.1.1.1\",\"modelMatrix\":\"-0.298707,0.922945,-0.242789,0,-0.954345,-0.288879,0.0759925,0,9.14042e-10,0.254404,0.967098,0,20.3691,-25.7421,-14.8867,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'1ed03b1b-6b26-4ef7-b480-93870e62438f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_e6c95ef7-636d-4c88-8d02-e2d9840573db/13_w1_o1_mandibule_scan_file_2.zip','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_e6c95ef7-636d-4c88-8d02-e2d9840573db_ZIP_','2022-01-27 16:37:44','2022-01-27 17:37:15','13_w1_o1_mandibule_scan_file_2.zip','2022-01-27 17:37:44','SYNCED','bcef8d3e-9632-4976-8cda-4c6f3ac50e99',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.1\",\"modelMatrix\":\"-0.963479,0.243305,-0.111855,0,-0.267785,-0.8754,0.402451,0,1.23617e-9,0.417706,0.908582,0,32.4632,-3.53421,-16.2323,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'1ee80ca4-d94e-45b0-8e49-65d950ee4df9','','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_fa1c1f6f-5c0d-45ca-8646-2a1ca68f51b4_BOPLY__ZIP_','2022-05-16 17:51:10','2022-05-16 19:50:25','','2022-05-16 19:51:10','SYNCED','1ee80ca4-d94e-45b0-8e49-65d950ee4df9',0,'2022-05-16 19:51:10','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.24.1.1.1 Occlusion 6\",\"modelMatrix\":\"0.852703,-0.521011,0.0380208,0,0.522396,0.850441,-0.062061,0,3.49638e-10,0.0727815,0.997348,0,-11.3911,-12.8136,-21.1334,1\",\"referenceScanID\":\"1.24.1.1.1\",\"title\":\"Mandibule 1.24.1.1.1 Occlusion 6\"}'),(1001,'1ef50d07-0bdf-4786-9a09-f0d43d4157e4','','ZIP','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_c9079d19-8ffb-46f7-a51e-3a7a90ccae59_SESS_8ba0f3b1-408f-4a02-92a0-63f09123b68e_BOSC_3f14002f-c2c4-4c73-b111-290940b150eb_ZIP_','2022-01-28 17:15:43','2022-01-27 14:52:24','','2022-01-28 18:15:43','SYNCED','1ef50d07-0bdf-4786-9a09-f0d43d4157e4',0,'2022-01-28 18:15:43','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.10.1.1.4\",\"modelMatrix\":\"0.499842,0.862645,-0.0774669,0,-0.866117,0.497839,-0.0447067,0,1.10064e-9,0.0894417,0.995992,0,1.32298,-8.42824,-29.2225,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'1f2547b2-94d6-4ad3-8965-45ffd5789b90','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/order_be77a0f7-c81a-46c8-ba80-8ea4d3c3b1c8/4_w1_autre_prost_file_1f2547b2-94d6-4ad3-8965-45ffd5789b90_0.pdf','PDF','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_PROST_be77a0f7-c81a-46c8-ba80-8ea4d3c3b1c8_PDF_','2022-05-31 14:58:19','2022-05-31 16:58:18','4_w1_autre_prost_file_1f2547b2-94d6-4ad3-8965-45ffd5789b90_0.pdf','2022-05-31 16:58:19','SYNCED','1f2547b2-94d6-4ad3-8965-45ffd5789b90',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.4.1.5 AUTRE FICHE DE PROTHESE\",\"title\":\"Autre PDF\"}'),(1001,'1f6a5510-cff7-4ce9-975a-d7ad45db166d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/scan_f2bad12a-451d-406d-98b0-e431a37951dd/19_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_BOSC_f2bad12a-451d-406d-98b0-e431a37951dd_ZIP_','2022-03-08 10:43:45','2022-03-08 11:43:38','19_w1_o1_mandibule_scan_file_1.zip','2022-03-08 11:43:45','SYNCED','e3a545cc-fe2a-418f-9896-979b09c1f684',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.1.4\",\"modelMatrix\":\"-0.997126,0.0688557,-0.0316083,0,-0.075764,-0.906205,0.415996,0,-1.80164e-09,0.417195,0.908817,0,23.7521,-24.6217,-20.8001,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'1f7ddfe0-7f99-4153-b3c2-97663ca5b8ae','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/occlusion_e08bbeeb-a30b-428c-bd4a-40198f792219/scan_ef1d20c7-5f61-4c35-8f0f-d85507cab786/25_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_SESS_e08bbeeb-a30b-428c-bd4a-40198f792219_BOSC_ef1d20c7-5f61-4c35-8f0f-d85507cab786_ZIP_','2022-05-17 16:13:04','2022-05-17 18:12:54','25_w1_o1_mandibule_scan_file_1.zip','2022-05-17 18:13:04','SYNCED','69ad61a1-bbd5-4415-a55b-c7c378bdf30e',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.25.1.1.1\",\"modelMatrix\":\"0.706223,-0.70478,0.0673387,0,0.70799,0.703021,-0.0671707,0,-2.542e-09,0.0951126,0.995466,0,-2.01848,-3.90735,-21.641,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'1f8d4d2e-1df3-4232-9784-04f300109aab','','ZIP','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_LESC_ecfd300a-08c2-4c42-a0d5-5dbf17a8210e_ZIP_','2022-09-09 16:30:29','2022-09-09 18:16:24','','2022-09-09 18:30:29','SYNCED','1f8d4d2e-1df3-4232-9784-04f300109aab',0,'2022-09-09 18:30:29','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.39.1.1.1\",\"modelMatrix\":\"-0.957377,0.0514487,0.288511,0,-0.0471191,-0.998681,0.013968,0,0.285002,0.010975,0.957451,0,-24.7487,5.84229,-7.00493,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'1f9724a7-2075-47b0-8aee-e88fec576ca0','','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_BOSC_a1a9cef4-72fe-4dbe-928c-3831f98ecfbc_ZIP_','2022-02-19 17:53:23','2022-02-18 17:00:42','','2022-02-19 18:53:23','SYNCED','1f9724a7-2075-47b0-8aee-e88fec576ca0',0,'2022-02-19 18:53:23','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.4.4\",\"modelMatrix\":\"-0.484902,-0.858844,0.165097,0,0.874569,-0.476183,0.0915377,0,5.0731e-09,0.188776,0.98202,0,0.867766,-4.01351,-24.0032,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'1fc93c7d-617e-42e3-b407-18216c5a47ca','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/scan_1a0b9502-8df2-41a2-89eb-2def508b7462/22_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_RISC_1a0b9502-8df2-41a2-89eb-2def508b7462_ZIP_','2022-04-21 17:38:20','2022-04-21 19:38:19','22_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-04-21 19:38:20','SYNCED','1fc93c7d-617e-42e3-b407-18216c5a47ca',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.22.1.1.6\",\"modelMatrix\":\"-0.989729,0.00526289,-0.143837,0,-0.00941161,-1.00005,-0.00463951,0,-0.142672,0.0133764,0.989739,0,15.8973,1.46372,-15.7658,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'20010b5b-e8eb-499b-8bf9-25f8af288f05','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/c8418992-7324-4a11-9437-bf2bb0fa802f/session_ff05cb1f-6c46-4287-9cdd-81bf817a9c78/occlusion_f6f084bb-a5f1-4f39-860f-1483132c8283/scan_9263fb3c-bf3a-443f-8c9b-4d12244b4612/11_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_c8418992-7324-4a11-9437-bf2bb0fa802f_ACT_ff05cb1f-6c46-4287-9cdd-81bf817a9c78_SESS_f6f084bb-a5f1-4f39-860f-1483132c8283_TOSC_9263fb3c-bf3a-443f-8c9b-4d12244b4612_SNAPS_','2022-01-25 15:45:30','2022-01-25 16:42:39','11_w1_o1_maxillaire_snapshot_0.png','2022-01-25 16:45:30','SYNCED','20010b5b-e8eb-499b-8bf9-25f8af288f05',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.11.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'204b529d-94bd-48ef-b172-5317b14df862','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/32710234-804f-46f5-899d-eed636f8a906/session_64c1427a-b91d-4675-94df-f36bd40e9b0f/occlusion_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a/computedocclusion_84d73896-4c7a-4dc0-994a-b2a70e3d1cf2/33_w2_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_32710234-804f-46f5-899d-eed636f8a906_ACT_64c1427a-b91d-4675-94df-f36bd40e9b0f_SESS_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a_OCC_84d73896-4c7a-4dc0-994a-b2a70e3d1cf2_TOPLY__ZIP_','2022-06-28 09:07:13','2022-06-28 11:07:03','33_w2_o1_maxillaire_occlusion_occ_file_0.zip','2022-06-28 11:07:13','SYNCED','204b529d-94bd-48ef-b172-5317b14df862',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.33.2.1.1 Occlusion 1\",\"modelMatrix\":\"-0.712189,0.701711,-0.019724,0,-0.701988,-0.711908,0.0200107,0,1.61205e-10,0.0280974,0.999605,0,4.73611,1.67537,-20.9792,1\",\"referenceScanID\":\"1.33.2.1.1\",\"title\":\"Maxillaire 1.33.2.1.1 Occlusion 1\"}'),(1001,'204dc781-5a83-4f4b-930a-661b60965ae3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/scan_9937f6fe-f500-4cc5-acd7-39dadc5ac2e7/22_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_TOSC_9937f6fe-f500-4cc5-acd7-39dadc5ac2e7_SNAPS_','2022-04-21 11:00:57','2022-04-21 13:00:43','22_w1_o1_maxillaire_snapshot_0.png','2022-04-21 13:00:57','SYNCED','204dc781-5a83-4f4b-930a-661b60965ae3',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.22.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'20e88106-93f1-4036-9c08-787a1d2939bd','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a0c21836-ba79-4f15-9e35-02ef8211a9e5/session_0aac522d-3c38-465a-a1e0-014166c140ac/occlusion_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042/scan_e3c95f99-398c-470f-97a1-8755ccbe1568/7_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_a0c21836-ba79-4f15-9e35-02ef8211a9e5_ACT_0aac522d-3c38-465a-a1e0-014166c140ac_SESS_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042_BOSC_e3c95f99-398c-470f-97a1-8755ccbe1568_ZIP_','2022-01-21 11:56:39','2022-01-21 12:56:08','7_w1_o1_mandibule_scan_file_0.zip','2022-01-21 12:56:39','SYNCED','20e88106-93f1-4036-9c08-787a1d2939bd',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.7.1.1.4\",\"modelMatrix\":\"-0.958149,-0.275593,0.0774524,0,0.286269,-0.922414,0.259235,0,-4.63746e-10,0.270558,0.962704,0,17.7986,10.9536,-17.3493,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'20f94b95-aaa7-41af-af0d-73dcf93e1a3c','','SNAPS','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_26ae7fce-0ea3-479f-9989-7d0a3a19aaf7_SNAPO__SNAPS_','2022-02-08 08:48:59','2022-02-07 18:58:31','','2022-02-08 09:48:59','SYNCED','20f94b95-aaa7-41af-af0d-73dcf93e1a3c',0,'2022-02-08 09:48:59','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'20fe8caf-9985-46f2-a4af-5f1b220a188f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f9d03016-567a-4bd4-9cc5-dafeea34e365/session_a7bcb190-dd19-4f3b-8aab-266030bf4064/occlusion_c321e210-b67c-40e8-bece-f8946164a768/computedocclusion_03fe87bc-2a25-4d16-a476-2df62bb3cf76/36_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_f9d03016-567a-4bd4-9cc5-dafeea34e365_ACT_a7bcb190-dd19-4f3b-8aab-266030bf4064_SESS_c321e210-b67c-40e8-bece-f8946164a768_OCC_03fe87bc-2a25-4d16-a476-2df62bb3cf76_TOMA__MATRX_','2022-07-04 14:14:03','2022-07-04 16:13:45','36_w1_o1_maxillaire_matrix_occ_file_0.m','2022-07-04 16:14:03','SYNCED','20fe8caf-9985-46f2-a4af-5f1b220a188f',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.36.1.1.1 Occlusion 2\",\"referenceScanID\":\"1.36.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.36.1.1.1 Occlusion 2\"}'),(1001,'212e5401-b297-469c-b7b5-2cf6013be5d4','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/scan_7b00996b-90f8-4307-9a8c-263a28f1b341/4_w1_o4_maxillaire_scan_file_2.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_TOSC_7b00996b-90f8-4307-9a8c-263a28f1b341_ZIP_','2022-05-31 11:55:53','2022-05-31 13:55:42','4_w1_o4_maxillaire_scan_file_2.zip','2022-05-31 13:55:53','SYNCED','c1ee6f0c-823c-43ab-892b-aa2b9c60a5d0',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.4.1.4.1\",\"modelMatrix\":\"-0.970276,0.236528,-0.0511731,0,-0.242001,-0.948335,0.205173,0,4.08722e-09,0.211459,0.977387,0,20.8295,-20.7118,-18.5295,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'21347aa2-1d83-49d6-a245-e30506990fbc','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/computedocclusion_e9bfc750-6943-42bf-8c0b-b7e1dc1803c5/1_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_OCC_e9bfc750-6943-42bf-8c0b-b7e1dc1803c5_BOPLY__ZIP_','2022-01-19 13:04:53','2022-01-19 12:12:14','1_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-01-19 14:04:53','SYNCED','21347aa2-1d83-49d6-a245-e30506990fbc',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.1.1.1.1 Occlusion 2\",\"referenceScanID\":\"1.1.1.1.1\",\"title\":\"Mandibule 1.1.1.1.1 Occlusion 2\"}'),(1001,'214a2e75-f3aa-4102-ab22-e2344558a6ab','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/1c189ddc-0ee7-45e7-9d80-585dac08374a/session_01bd0635-6ec6-42cb-8561-8638bded352c/order_77d4416a-6efc-4760-97d5-48e41e9044fd/29_w1_couronne_prost_file_214a2e75-f3aa-4102-ab22-e2344558a6ab_0.pdf','PDF','PATIENT_1c189ddc-0ee7-45e7-9d80-585dac08374a_ACT_01bd0635-6ec6-42cb-8561-8638bded352c_PROST_77d4416a-6efc-4760-97d5-48e41e9044fd_PDF_','2022-06-03 17:00:57','2022-06-03 19:00:56','29_w1_couronne_prost_file_214a2e75-f3aa-4102-ab22-e2344558a6ab_0.pdf','2022-06-03 19:00:57','SYNCED','214a2e75-f3aa-4102-ab22-e2344558a6ab',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.29.1.1 COURONNE\",\"title\":\"Couronne PDF\"}'),(1001,'21d0e66c-3e52-4d85-a3f2-d70f5369923a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/scan_2d226451-8adb-4007-be22-99a9b3af61d6/23_w1_o1_maxillaire_ml_1_0.xyz','LIFI','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_TOSC_2d226451-8adb-4007-be22-99a9b3af61d6_LIFI_','2022-05-25 10:45:09','2022-05-25 12:45:09','23_w1_o1_maxillaire_ml_1_0.xyz','2022-05-25 12:45:09','SYNCED','21d0e66c-3e52-4d85-a3f2-d70f5369923a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.23.1.1.1 Ligne de finition 1\",\"name\":\"Ligne de finition 1\",\"title\":\"Maxillaire LIFI\",\"toothNumber\":1,\"versionMarginLine\":1}'),(1001,'21df10c9-ac4a-4a75-8a15-e5c30db28180','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/computedocclusion_d7643aed-d242-47f6-8e1a-703d4672f109/18_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_OCC_d7643aed-d242-47f6-8e1a-703d4672f109_TOPLY__ZIP_','2022-03-07 14:44:46','2022-03-07 15:44:20','18_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-03-07 15:44:46','SYNCED','21df10c9-ac4a-4a75-8a15-e5c30db28180',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.18.1.1.2 Occlusion 2\",\"modelMatrix\":\"-0.979743,-0.199678,0.0152522,0,0.20026,-0.976897,0.0746194,0,-1.52856e-10,0.0761623,0.997095,0,19.5629,-11.4708,-22.5064,1\",\"referenceScanID\":\"1.18.1.1.2\",\"title\":\"Maxillaire 1.18.1.1.2 Occlusion 2\"}'),(1001,'21f16639-e10d-42f9-b1b1-ecd1dbc0e28b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/452a5200-3e06-4b74-8949-6abc7f2dda8a/session_3e95d626-668f-45f7-98ad-be2cf9d7b90b/occlusion_bce8310f-eee9-4f0a-a6b7-d592dec66be5/computedocclusion_d9818808-7d5e-47e6-9880-cc95357483ff/26_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_452a5200-3e06-4b74-8949-6abc7f2dda8a_ACT_3e95d626-668f-45f7-98ad-be2cf9d7b90b_SESS_bce8310f-eee9-4f0a-a6b7-d592dec66be5_OCC_d9818808-7d5e-47e6-9880-cc95357483ff_SNAPO__SNAPS_','2022-05-24 09:43:00','2022-05-24 11:42:41','26_w1_o1_snapshot_occ_file_0.png','2022-05-24 11:43:00','SYNCED','21f16639-e10d-42f9-b1b1-ecd1dbc0e28b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'22087293-2aac-4313-989b-8aa120c20399','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/occlusion_e08bbeeb-a30b-428c-bd4a-40198f792219/scan_6aeb3c55-f3f0-4e74-9793-ec74659a28ad/25_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_SESS_e08bbeeb-a30b-428c-bd4a-40198f792219_BOSC_6aeb3c55-f3f0-4e74-9793-ec74659a28ad_ZIP_','2022-05-17 16:28:17','2022-05-17 18:28:16','25_w1_o1_maxillaire_scan_file_0.zip','2022-05-17 18:28:17','SYNCED','22087293-2aac-4313-989b-8aa120c20399',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.25.1.1.2\",\"modelMatrix\":\"-0.964287,0.263246,-0.0291771,0,-0.264858,-0.958419,0.106227,0,5.11078e-10,0.110162,0.993914,0,-2.81379,1.33022,-23.6936,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'222e5132-509a-41d5-9b54-889df4e0023e','','MATRX','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_aa16f8ea-198d-4240-ab78-5a1f54823f0c_TOMA__MATRX_','2022-05-16 17:48:36','2022-05-16 19:47:59','','2022-05-16 19:48:36','SYNCED','222e5132-509a-41d5-9b54-889df4e0023e',0,'2022-05-16 19:48:36','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.24.1.1.2 Occlusion 6\",\"referenceScanID\":\"1.24.1.1.2\",\"title\":\"Matrice Transfo. Maxillaire 1.24.1.1.2 Occlusion 6\"}'),(1001,'229065de-cf1c-4956-8237-67f43f93246b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/occlusion_a2220645-c79d-4dda-b6cc-772384a4106b/scan_0136d883-d517-448a-82a3-bfcdd5f4c35c/38_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_TOSC_0136d883-d517-448a-82a3-bfcdd5f4c35c_ZIP_','2022-07-12 10:46:07','2022-07-12 12:45:58','38_w1_o1_maxillaire_scan_file_0.zip','2022-07-12 12:46:07','SYNCED','229065de-cf1c-4956-8237-67f43f93246b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.38.1.1.1\",\"modelMatrix\":\"-0.298707,0.922945,-0.242789,0,-0.954345,-0.288879,0.0759925,0,9.14042e-10,0.254404,0.967098,0,20.3691,-25.7421,-14.8867,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'22ae53ab-f53d-40bd-b1c2-9fd46bcf26f5','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/32939ecf-ba11-4fff-a074-5e86a9f7f313/session_4075a8d6-094f-4202-abe0-4c02b7a5a8e6/occlusion_51192c80-5065-420e-ae8f-bac335ac1de1/scan_2ca8702c-bb71-418c-b881-0d3d2af204d1/6_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_32939ecf-ba11-4fff-a074-5e86a9f7f313_ACT_4075a8d6-094f-4202-abe0-4c02b7a5a8e6_SESS_51192c80-5065-420e-ae8f-bac335ac1de1_TOSC_2ca8702c-bb71-418c-b881-0d3d2af204d1_SNAPS_','2022-01-20 19:41:40','2022-01-20 11:35:38','6_w1_o1_maxillaire_snapshot_1.png','2022-01-20 20:41:40','SYNCED','b685e310-d84a-4a81-a008-eee4725a0bd6',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.6.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'230c7b3c-798a-4e8e-9487-522dcddd0350','','SNAPS','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_RISC_261fcec0-ce06-45e0-a8b7-6a5f785c988d_SNAPS_','2022-04-21 17:37:36','2022-04-21 13:11:18','','2022-04-21 19:37:36','SYNCED','230c7b3c-798a-4e8e-9487-522dcddd0350',0,'2022-04-21 19:37:36','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.22.1.1.2\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'2343da36-b2ed-48aa-8bea-6bbf74dee09b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/32939ecf-ba11-4fff-a074-5e86a9f7f313/session_4075a8d6-094f-4202-abe0-4c02b7a5a8e6/occlusion_51192c80-5065-420e-ae8f-bac335ac1de1/scan_2ca8702c-bb71-418c-b881-0d3d2af204d1/6_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_32939ecf-ba11-4fff-a074-5e86a9f7f313_ACT_4075a8d6-094f-4202-abe0-4c02b7a5a8e6_SESS_51192c80-5065-420e-ae8f-bac335ac1de1_TOSC_2ca8702c-bb71-418c-b881-0d3d2af204d1_ZIP_','2022-01-20 10:13:02','2022-01-20 11:12:39','6_w1_o1_maxillaire_scan_file_0.zip','2022-01-20 11:13:02','SYNCED','2343da36-b2ed-48aa-8bea-6bbf74dee09b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.6.1.1.1\",\"modelMatrix\":\"0.299661,0.916001,-0.26673,0,-0.954046,0.287711,-0.0837784,0,7.6452e-9,0.279578,0.960123,0,-15.1089,-22.8916,-20.0563,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'2347ba2a-b6ae-4584-996b-ec0c44f04a55','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/scan_2d226451-8adb-4007-be22-99a9b3af61d6/23_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_TOSC_2d226451-8adb-4007-be22-99a9b3af61d6_ZIP_','2022-05-13 10:02:02','2022-05-13 12:01:51','23_w1_o1_maxillaire_scan_file_0.zip','2022-05-13 12:02:02','SYNCED','2347ba2a-b6ae-4584-996b-ec0c44f04a55',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.23.1.1.1\",\"modelMatrix\":\"-0.996412,0.0371381,-0.0760535,0,-0.0846367,-0.43722,0.895363,0,9.59179e-10,0.898588,0.438794,0,-5.67604,-22.9357,-12.9416,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'2408b3ef-b412-436d-a442-1944dba562c5','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/computedocclusion_b35629de-38d8-4cdd-bf2c-b61c461410cb/17_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_b35629de-38d8-4cdd-bf2c-b61c461410cb_BOPLY__ZIP_','2022-02-07 18:07:22','2022-02-07 19:05:55','17_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-02-07 19:07:22','SYNCED','2408b3ef-b412-436d-a442-1944dba562c5',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.17.1.1.1 Occlusion 6\",\"modelMatrix\":\"-0.980954,-0.188901,0.0452269,0,0.19424,-0.953992,0.228406,0,1.35057e-9,0.232841,0.972515,0,27.4349,19.1019,-20.1379,1\",\"referenceScanID\":\"1.17.1.1.1\",\"title\":\"Mandibule 1.17.1.1.1 Occlusion 6\"}'),(1001,'2413d387-ed67-4527-b74d-3bc45541eadf','','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_fa1c1f6f-5c0d-45ca-8646-2a1ca68f51b4_TOPLY__ZIP_','2022-05-16 17:51:10','2022-05-16 19:50:25','','2022-05-16 19:51:10','SYNCED','2413d387-ed67-4527-b74d-3bc45541eadf',0,'2022-05-16 19:51:10','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.2 Occlusion 6\",\"modelMatrix\":\"-0.80453,0.576793,-0.141569,0,-0.593912,-0.781339,0.191773,0,-6.05286e-09,0.238367,0.971175,0,0.910551,-5.61768,-25.9513,1\",\"referenceScanID\":\"1.24.1.1.2\",\"title\":\"Maxillaire 1.24.1.1.2 Occlusion 6\"}'),(1001,'241ff7c7-536a-43e6-9bad-9685fc523fa7','','SNAPS','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_LESC_f9eccc16-31b5-4a87-b758-9bf72196ca28_SNAPS_','2022-09-09 16:40:45','2022-09-09 18:38:08','','2022-09-09 18:40:45','SYNCED','241ff7c7-536a-43e6-9bad-9685fc523fa7',0,'2022-09-09 18:40:45','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.39.1.1.7\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'24532129-ed40-4cea-a3b3-8012bb0d2259','','MATRX','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_fa1c1f6f-5c0d-45ca-8646-2a1ca68f51b4_TOMA__MATRX_','2022-05-16 17:51:11','2022-05-16 19:50:25','','2022-05-16 19:51:11','SYNCED','24532129-ed40-4cea-a3b3-8012bb0d2259',0,'2022-05-16 19:51:11','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.24.1.1.2 Occlusion 6\",\"referenceScanID\":\"1.24.1.1.2\",\"title\":\"Matrice Transfo. Maxillaire 1.24.1.1.2 Occlusion 6\"}'),(1001,'24b218af-fcc6-4d11-8bc7-0d12769286f9','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/computedocclusion_2de3d2bb-d512-4514-8bed-a879b73a6028/22_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_OCC_2de3d2bb-d512-4514-8bed-a879b73a6028_SNAPO__SNAPS_','2022-04-21 11:29:39','2022-04-21 13:29:16','22_w1_o1_snapshot_occ_file_0.png','2022-04-21 13:29:39','SYNCED','24b218af-fcc6-4d11-8bc7-0d12769286f9',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'24e5a7c7-24f3-4b9c-97a8-51bdaa4d628b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_2a7068fc-0efa-496f-ade9-aba5b0650655/12_w1_o1_mandibule_scan_file_10.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_2a7068fc-0efa-496f-ade9-aba5b0650655_ZIP_','2022-02-04 12:15:35','2022-02-04 13:15:01','12_w1_o1_mandibule_scan_file_10.zip','2022-02-04 13:15:35','SYNCED','44ebcd6f-57c2-4cce-96f5-f9faa1c6b373',10,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.5\",\"modelMatrix\":\"0.821265,-0.551643,0.145651,0,0.570547,0.794053,-0.209655,0,5.91416e-9,0.255283,0.966866,0,-2.59195,32.4156,-27.5972,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'2505eb15-7090-4f82-ad06-2fbd8aea623a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/32710234-804f-46f5-899d-eed636f8a906/session_64c1427a-b91d-4675-94df-f36bd40e9b0f/occlusion_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a/computedocclusion_84d73896-4c7a-4dc0-994a-b2a70e3d1cf2/33_w2_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_32710234-804f-46f5-899d-eed636f8a906_ACT_64c1427a-b91d-4675-94df-f36bd40e9b0f_SESS_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a_OCC_84d73896-4c7a-4dc0-994a-b2a70e3d1cf2_BOPLY__ZIP_','2022-06-28 09:07:20','2022-06-28 11:07:03','33_w2_o1_mandibule_occlusion_occ_file_0.zip','2022-06-28 11:07:20','SYNCED','2505eb15-7090-4f82-ad06-2fbd8aea623a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.33.2.1.1 Occlusion 1\",\"modelMatrix\":\"-0.911542,-0.410478,0.0244887,0,0.411207,-0.909924,0.0542853,0,-6.94447e-10,0.0595532,0.998225,0,18.7622,-5.69322,-17.7897,1\",\"referenceScanID\":\"1.33.2.1.1\",\"title\":\"Mandibule 1.33.2.1.1 Occlusion 1\"}'),(1001,'251f57eb-36ef-45d5-affe-51494469c59a','','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_OCC_a525c976-46dd-42bc-abc1-c7cf71f9a1f1_TOPLY__ZIP_','2022-02-07 11:15:30','2022-02-04 14:58:28','','2022-02-07 12:15:30','SYNCED','251f57eb-36ef-45d5-affe-51494469c59a',0,'2022-02-07 12:15:30','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.12.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.622652,0.772747,-0.123153,0,-0.782499,0.614892,-0.0979959,0,-5.00422e-9,0.157385,0.987537,0,-21.5256,-19.2669,-19.1349,1\",\"referenceScanID\":\"1.12.1.1.1\",\"title\":\"Maxillaire 1.12.1.1.1 Occlusion 1\"}'),(1001,'253b7aa4-960b-44cb-8866-6a79764bcc0b','','ZIP','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_RISC_0f004b83-11e3-49ae-b25b-7872c0ac7485_ZIP_','2022-09-10 08:18:17','2022-09-09 18:36:23','','2022-09-10 10:18:17','SYNCED','253b7aa4-960b-44cb-8866-6a79764bcc0b',0,'2022-09-10 10:18:17','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.39.1.1.5\",\"modelMatrix\":\"0.95568,0.161732,0.244456,0,-0.161618,0.986149,0.00747179,0,-0.246206,-0.0383378,0.969701,0,-3.25243,1.23227,-19.9296,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'257d0e5e-38b7-45cd-8c0c-d2e0641bfda7','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_f9c2783a-c405-481c-a97e-47bb9db0d0d2/17_w1_o1_mordu_posterieur_droit_snapshot_1.png','SNAPS','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_RISC_f9c2783a-c405-481c-a97e-47bb9db0d0d2_SNAPS_','2022-02-07 11:47:27','2022-02-07 12:44:03','17_w1_o1_mordu_posterieur_droit_snapshot_1.png','2022-02-07 12:47:27','SYNCED','6e5eb213-3b0b-4c68-a8b7-4d44d6e5a4a8',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.17.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'25d4cc8b-2ba5-422c-b88a-0cecfa682ae3','','MATRX','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_65f9077d-c859-4b2c-9d4d-692d723315a5_BOMA__MATRX_','2022-05-13 12:07:43','2022-05-13 14:07:00','','2022-05-13 14:07:43','SYNCED','25d4cc8b-2ba5-422c-b88a-0cecfa682ae3',0,'2022-05-13 14:07:43','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.23.1.1.1 Occlusion 4\",\"referenceScanID\":\"1.23.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.23.1.1.1 Occlusion 4\"}'),(1001,'25e74dd8-3937-4ae4-b200-5489bfb184fd','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/458c92d8-9da1-4df9-967f-d14fc7e6303d/session_55831d43-1906-4a22-9b7a-ed4b2820c8b2/occlusion_4f582d4c-81d0-4e01-8be3-9ff53b12c7f4/scan_19e6ea5c-af28-439b-bc57-b561cd42e12b/10_w2_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_55831d43-1906-4a22-9b7a-ed4b2820c8b2_SESS_4f582d4c-81d0-4e01-8be3-9ff53b12c7f4_TOSC_19e6ea5c-af28-439b-bc57-b561cd42e12b_SNAPS_','2022-06-16 13:27:31','2022-06-16 15:27:21','10_w2_o1_maxillaire_snapshot_1.png','2022-06-16 15:27:31','SYNCED','b6f46e96-4d05-4b63-8956-16b3af586d47',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.10.2.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'26486b53-a539-40e3-b121-f2aa550df56e','','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_OCC_e9a397c8-e329-4471-985b-0eb40ed458b0_SNAPO__SNAPS_','2022-02-04 15:01:39','2022-02-04 14:50:30','','2022-02-04 16:01:39','SYNCED','26486b53-a539-40e3-b121-f2aa550df56e',0,'2022-02-04 16:01:39','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'2669117e-8bb2-4f15-9ce3-d1ccf1251c13','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_0e451099-a0ad-463c-9441-7ded1297fa16/24_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_TOSC_0e451099-a0ad-463c-9441-7ded1297fa16_SNAPS_','2022-05-24 14:43:41','2022-05-24 16:43:24','24_w1_o1_maxillaire_snapshot_1.png','2022-05-24 16:43:41','SYNCED','2ae18efe-89ec-4910-93a7-b68bc09a8249',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'2697d64a-9f2f-4500-84e9-a0315f87e33d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/452a5200-3e06-4b74-8949-6abc7f2dda8a/session_3e95d626-668f-45f7-98ad-be2cf9d7b90b/occlusion_bce8310f-eee9-4f0a-a6b7-d592dec66be5/scan_315ac573-ca2e-4c47-8969-e667ad225aa2/26_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_452a5200-3e06-4b74-8949-6abc7f2dda8a_ACT_3e95d626-668f-45f7-98ad-be2cf9d7b90b_SESS_bce8310f-eee9-4f0a-a6b7-d592dec66be5_LESC_315ac573-ca2e-4c47-8969-e667ad225aa2_ZIP_','2022-05-24 09:41:38','2022-05-24 11:41:30','26_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-05-24 11:41:38','SYNCED','2697d64a-9f2f-4500-84e9-a0315f87e33d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.26.1.1.1\",\"modelMatrix\":\"-0.940924,0.0532921,0.32678,0,0.0960697,-0.905072,0.4126,0,0.324812,0.421914,0.850326,0,-19.6107,-10.4836,-8.10302,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'26c6a3a9-4104-4bbb-a17d-704486a1f413','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f9d03016-567a-4bd4-9cc5-dafeea34e365/session_a7bcb190-dd19-4f3b-8aab-266030bf4064/occlusion_c321e210-b67c-40e8-bece-f8946164a768/computedocclusion_03fe87bc-2a25-4d16-a476-2df62bb3cf76/36_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_f9d03016-567a-4bd4-9cc5-dafeea34e365_ACT_a7bcb190-dd19-4f3b-8aab-266030bf4064_SESS_c321e210-b67c-40e8-bece-f8946164a768_OCC_03fe87bc-2a25-4d16-a476-2df62bb3cf76_TOPLY__ZIP_','2022-07-04 14:13:55','2022-07-04 16:13:45','36_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-07-04 16:13:55','SYNCED','26c6a3a9-4104-4bbb-a17d-704486a1f413',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.36.1.1.1 Occlusion 2\",\"modelMatrix\":\"-0.740632,0.661068,-0.120222,0,-0.671911,-0.72868,0.132518,0,7.47193e-09,0.178926,0.983863,0,13.1843,-17.5524,-17.7657,1\",\"referenceScanID\":\"1.36.1.1.1\",\"title\":\"Maxillaire 1.36.1.1.1 Occlusion 2\"}'),(2,'273ede87-068a-42c6-aa6e-0184f164e3fe','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a4b302c-278d-4e12-ace5-f095ba0bf856/session_6206892a-2e7e-4765-ac90-b49bfb465997/occlusion_7ec70f78-dc80-40c5-b293-570a59f034c4/scan_2ef30e56-ed6b-4233-94dd-08cbb9ef27df/3_w1_o2_maxillaire_snapshot_0.png','SNAPS','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_7ec70f78-dc80-40c5-b293-570a59f034c4_TOSC_2ef30e56-ed6b-4233-94dd-08cbb9ef27df_SNAPS_','2022-09-06 09:17:56','2022-08-30 14:20:46','3_w1_o2_maxillaire_snapshot_0.png','2022-09-06 11:17:56','SYNCED','273ede87-068a-42c6-aa6e-0184f164e3fe',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.3.1.2.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'27492cd3-eb70-48a2-876e-dce55c90a17a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/e922efb9-8c03-445b-8a0f-449e3c43bdca/session_a2369349-1629-40ad-8784-d271bc3fbade/occlusion_292cc1aa-8b12-463b-87a1-7d9731cf886b/computedocclusion_f9f6d9d2-cc34-43c3-9f5f-4b8e54b41bbb/21_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_e922efb9-8c03-445b-8a0f-449e3c43bdca_ACT_a2369349-1629-40ad-8784-d271bc3fbade_SESS_292cc1aa-8b12-463b-87a1-7d9731cf886b_OCC_f9f6d9d2-cc34-43c3-9f5f-4b8e54b41bbb_BOPLY__ZIP_','2022-04-21 08:53:24','2022-04-21 10:53:03','21_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-04-21 10:53:24','SYNCED','27492cd3-eb70-48a2-876e-dce55c90a17a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.21.1.1.1 Occlusion 2\",\"modelMatrix\":\"-0.976637,0.206889,-0.0581121,0,-0.214896,-0.94025,0.264102,0,1.90262e-09,0.27042,0.962742,0,12.5761,-24.3862,-20.0904,1\",\"referenceScanID\":\"1.21.1.1.1\",\"title\":\"Mandibule 1.21.1.1.1 Occlusion 2\"}'),(1001,'27571368-d410-426c-bb87-4de2c6774315','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/computedocclusion_0bc29ff9-efea-448d-b521-2c39fd4faa78/19_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_OCC_0bc29ff9-efea-448d-b521-2c39fd4faa78_SNAPO__SNAPS_','2022-03-08 11:18:05','2022-03-08 12:17:37','19_w1_o1_snapshot_occ_file_0.png','2022-03-08 12:18:05','SYNCED','27571368-d410-426c-bb87-4de2c6774315',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'27783779-520f-4bd8-b471-a13cdf11718c','','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_BOSC_a1a9cef4-72fe-4dbe-928c-3831f98ecfbc_SNAPS_','2022-02-19 17:53:23','2022-02-18 17:01:38','','2022-02-19 18:53:23','SYNCED','fb2afa86-ebd5-4360-a84e-10047e56c6e5',1,'2022-02-19 18:53:23','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.4.4\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'279111aa-db84-4754-8277-7244a074df26','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_44561518-16e3-45bd-af90-fefe4eca9d27/24_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_RISC_44561518-16e3-45bd-af90-fefe4eca9d27_SNAPS_','2022-06-13 14:53:09','2022-06-13 16:53:02','24_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-06-13 16:53:09','SYNCED','279111aa-db84-4754-8277-7244a074df26',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.24.1.1.2\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'27b915e1-c25a-4eca-a403-ac238b3d04d5','','SNAPS','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_RISC_ceafbbd6-01e4-4f7a-9d71-a337153d555a_SNAPS_','2022-04-21 17:37:47','2022-04-21 13:10:25','','2022-04-21 19:37:47','SYNCED','27b915e1-c25a-4eca-a403-ac238b3d04d5',0,'2022-04-21 19:37:47','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.22.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'27d20733-0f26-4b51-b528-aef4f716d664','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/order_1f7b5476-a626-43ce-baf4-b1e445f56770/4_w1_autre_prost_file_27d20733-0f26-4b51-b528-aef4f716d664_0.pdf','PDF','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_PROST_1f7b5476-a626-43ce-baf4-b1e445f56770_PDF_','2022-03-09 09:37:43','2022-03-09 10:37:41','4_w1_autre_prost_file_27d20733-0f26-4b51-b528-aef4f716d664_0.pdf','2022-03-09 10:37:43','SYNCED','27d20733-0f26-4b51-b528-aef4f716d664',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.4.1.4 AUTRE FICHE DE PROTHESE\",\"title\":\"Autre PDF\"}'),(1001,'289d0553-c152-4c7e-9fdc-478e07f0302f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_7048f93c-1091-4f02-bc64-b73347dfa962/24_w1_o1_mordu_posterieur_droit_scan_file_1.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_RISC_7048f93c-1091-4f02-bc64-b73347dfa962_ZIP_','2022-06-13 15:02:10','2022-06-13 17:02:03','24_w1_o1_mordu_posterieur_droit_scan_file_1.zip','2022-06-13 17:02:10','SYNCED','91975b1f-684b-4717-9edb-bec57444b873',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.24.1.1.3\",\"modelMatrix\":\"0.998619,-0.0225373,-0.0518672,0,0.0274141,0.999152,0.0316937,0,0.0453051,-0.0346534,0.998169,0,-1.54115,-3.89745,-17.238,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'28a9fce2-d866-4a71-92dc-42eef3b92846','','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_1500b3eb-4b86-46c1-9c9f-7efbd0224ac8_SNAPO__SNAPS_','2022-05-25 08:56:39','2022-05-13 18:22:04','','2022-05-25 10:56:39','SYNCED','28a9fce2-d866-4a71-92dc-42eef3b92846',0,'2022-05-25 10:56:39','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'28cb3d03-2b1a-4f45-9d78-e221a6841249','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f4fc00ec-4af8-4a15-b427-f1c5aabf6260/session_498ae60a-23f0-44fc-9730-be499bfc4b46/occlusion_8f3d6c73-3468-45a5-85c7-93bba47ec9f7/scan_a7163552-20ad-4b45-ae78-be2b0453dbd3/30_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_f4fc00ec-4af8-4a15-b427-f1c5aabf6260_ACT_498ae60a-23f0-44fc-9730-be499bfc4b46_SESS_8f3d6c73-3468-45a5-85c7-93bba47ec9f7_LESC_a7163552-20ad-4b45-ae78-be2b0453dbd3_ZIP_','2022-06-14 13:29:51','2022-06-14 15:29:43','30_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-06-14 15:29:51','SYNCED','28cb3d03-2b1a-4f45-9d78-e221a6841249',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.30.1.1.1\",\"modelMatrix\":\"-0.940851,0.0844677,0.327584,0,-0.0316586,-0.987891,0.129627,0,0.337376,0.132286,0.936188,0,-6.40134,-4.82352,-19.1939,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'28ffb267-985a-45c9-98e6-5f2d57a9c656','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/452a5200-3e06-4b74-8949-6abc7f2dda8a/session_3e95d626-668f-45f7-98ad-be2cf9d7b90b/occlusion_bce8310f-eee9-4f0a-a6b7-d592dec66be5/scan_bd194eb4-5c69-43b1-94bb-66c7ae8aa0ce/26_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_452a5200-3e06-4b74-8949-6abc7f2dda8a_ACT_3e95d626-668f-45f7-98ad-be2cf9d7b90b_SESS_bce8310f-eee9-4f0a-a6b7-d592dec66be5_BOSC_bd194eb4-5c69-43b1-94bb-66c7ae8aa0ce_ZIP_','2022-05-24 09:15:07','2022-05-24 11:15:00','26_w1_o1_mandibule_scan_file_1.zip','2022-05-24 11:15:07','SYNCED','8d1bd14c-e811-4bca-828b-4f1629ec9192',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.26.1.1.2\",\"modelMatrix\":\"-0.440993,0.868318,-0.227045,0,-0.89751,-0.426649,0.111559,0,-1.10485e-08,0.252972,0.967474,0,8.55795,-16.8564,-17.5092,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'28ffc1de-2be4-4a19-87be-aecd0b0aa83f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/computedocclusion_6960b50e-6f78-4f83-9303-8c985410457c/4_w1_o4_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_OCC_6960b50e-6f78-4f83-9303-8c985410457c_TOPLY__ZIP_','2022-05-31 14:56:07','2022-05-31 16:55:44','4_w1_o4_maxillaire_occlusion_occ_file_0.zip','2022-05-31 16:56:07','SYNCED','28ffc1de-2be4-4a19-87be-aecd0b0aa83f',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.4.1.4.1 Occlusion 5\",\"modelMatrix\":\"-0.970276,0.236528,-0.0511731,0,-0.242001,-0.948335,0.205173,0,4.08722e-09,0.211459,0.977387,0,20.8295,-20.7118,-18.5295,1\",\"referenceScanID\":\"1.4.1.4.1\",\"title\":\"Maxillaire 1.4.1.4.1 Occlusion 5\"}'),(1001,'29171666-f57b-4fcc-893b-6e01da2033fe','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/computedocclusion_e15a2d21-e8f2-4d2a-9a68-13d92ae4b997/13_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_OCC_e15a2d21-e8f2-4d2a-9a68-13d92ae4b997_BOMA__MATRX_','2022-02-04 18:25:04','2022-02-04 19:23:45','13_w1_o1_mandibule_matrix_occ_file_0.m','2022-02-04 19:25:04','SYNCED','29171666-f57b-4fcc-893b-6e01da2033fe',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.13.1.1.5 Occlusion 3\",\"referenceScanID\":\"1.13.1.1.5\",\"title\":\"Matrice Transfo. Mandibule 1.13.1.1.5 Occlusion 3\"}'),(1001,'29214935-0f63-4c89-bfb3-06abb6bbb7ae','','ZIP','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_OCC_ff8547d7-27f8-4862-9b63-e713dd817f3f_TOPLY__ZIP_','2022-09-09 17:04:15','2022-09-09 19:03:34','','2022-09-09 19:04:15','SYNCED','29214935-0f63-4c89-bfb3-06abb6bbb7ae',0,'2022-09-09 19:04:15','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.39.1.1.1 Occlusion 10\",\"modelMatrix\":\"-0.226177,0.929302,-0.291961,0,-0.974086,-0.215779,0.0677916,0,7.55513e-09,0.299728,0.954025,0,-12.3361,-28.543,-16.1754,1\",\"referenceScanID\":\"1.39.1.1.1\",\"title\":\"Maxillaire 1.39.1.1.1 Occlusion 10\"}'),(1001,'29712bfe-3317-4e6f-9b73-f5b757e2f2cc','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/207d6dbc-c19b-4726-a9b3-16235ae554cc/session_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35/occlusion_dc5762a3-c453-4166-8c86-82d23ac9f8a6/scan_9a90e42e-88ee-4808-8ae4-399e7285a1d0/27_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_207d6dbc-c19b-4726-a9b3-16235ae554cc_ACT_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35_SESS_dc5762a3-c453-4166-8c86-82d23ac9f8a6_TOSC_9a90e42e-88ee-4808-8ae4-399e7285a1d0_ZIP_','2022-05-30 10:55:02','2022-05-30 12:54:52','27_w1_o1_maxillaire_scan_file_0.zip','2022-05-30 12:55:02','SYNCED','29712bfe-3317-4e6f-9b73-f5b757e2f2cc',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.27.1.1.1\",\"modelMatrix\":\"0.708736,0.675594,-0.203138,0,-0.705473,0.678719,-0.204077,0,4.95031e-09,0.287945,0.957647,0,-5.6101,-21.7145,-20.7773,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'29722a02-997e-45bb-8685-579d5915af43','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_4f8dc275-857c-482a-9886-5521591e9661/scan_df08df19-150c-437d-8ed4-bf2826644265/12_w1_o4_mandibule_snapshot_1.png','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_BOSC_df08df19-150c-437d-8ed4-bf2826644265_SNAPS_','2022-02-18 16:21:47','2022-02-18 17:15:35','12_w1_o4_mandibule_snapshot_1.png','2022-02-18 17:21:47','SYNCED','e3598e66-59db-43ac-a342-a835944e8fab',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.4.5\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'29f3b0e2-4a26-4b27-ba2e-8513c1c9d0f7','','SNAPS','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_d79359b0-a63e-4bdb-91ad-dec77d961970_SNAPS_','2022-02-04 11:29:38','2022-02-04 09:36:23','','2022-02-04 12:29:38','SYNCED','29f3b0e2-4a26-4b27-ba2e-8513c1c9d0f7',0,'2022-02-04 12:29:38','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'2a8fdc87-7a3f-47e4-83f8-76543163cd17','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/computedocclusion_0bc29ff9-efea-448d-b521-2c39fd4faa78/19_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_OCC_0bc29ff9-efea-448d-b521-2c39fd4faa78_BOPLY__ZIP_','2022-03-08 11:17:53','2022-03-08 12:17:37','19_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-03-08 12:17:53','SYNCED','2a8fdc87-7a3f-47e4-83f8-76543163cd17',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.1.4 Occlusion 3\",\"modelMatrix\":\"-0.988793,0.145775,-0.0322113,0,-0.149292,-0.965503,0.213343,0,-2.16806e-09,0.215761,0.976446,0,23.0578,-21.2539,-25.059,1\",\"referenceScanID\":\"1.19.1.1.4\",\"title\":\"Mandibule 1.19.1.1.4 Occlusion 3\"}'),(1001,'2ae18efe-89ec-4910-93a7-b68bc09a8249','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_0e451099-a0ad-463c-9441-7ded1297fa16/24_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_TOSC_0e451099-a0ad-463c-9441-7ded1297fa16_SNAPS_','2022-05-24 14:34:54','2022-05-24 16:34:38','24_w1_o1_maxillaire_snapshot_0.png','2022-05-24 16:34:54','SYNCED','2ae18efe-89ec-4910-93a7-b68bc09a8249',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'2b408b13-2a9b-4477-8eea-ca0d2ef357cf','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/computedocclusion_42098ceb-3335-4f13-8aed-b29c37a5f57f/22_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_OCC_42098ceb-3335-4f13-8aed-b29c37a5f57f_BOPLY__ZIP_','2022-04-21 11:28:51','2022-04-21 13:28:43','22_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-04-21 13:28:51','SYNCED','2b408b13-2a9b-4477-8eea-ca0d2ef357cf',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.22.1.1.2 Occlusion 6\",\"modelMatrix\":\"0.930866,0.359665,-0.0642588,0,-0.36536,0.916356,-0.163719,0,1.67408e-09,0.175878,0.984412,0,-11.7687,0.165278,-18.4217,1\",\"referenceScanID\":\"1.22.1.1.2\",\"title\":\"Mandibule 1.22.1.1.2 Occlusion 6\"}'),(1001,'2bbd50df-4190-4607-a3d7-f1d8663a4cb1','','MATRX','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_7d8decb1-23db-4824-940f-8d8822d88813_TOMA__MATRX_','2022-02-08 08:48:59','2022-02-07 18:48:45','','2022-02-08 09:48:59','SYNCED','2bbd50df-4190-4607-a3d7-f1d8663a4cb1',0,'2022-02-08 09:48:59','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.17.1.1.1 Occlusion 3\",\"referenceScanID\":\"1.17.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.17.1.1.1 Occlusion 3\"}'),(1001,'2c5f5cbb-b4e2-48d5-951b-8b45381f8520','','ZIP','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_LESC_0e74383c-84a7-4c1f-b833-adf54ce6a402_ZIP_','2022-09-10 08:18:25','2022-09-10 10:17:21','','2022-09-10 10:18:25','SYNCED','2c5f5cbb-b4e2-48d5-951b-8b45381f8520',0,'2022-09-10 10:18:25','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.39.1.1.11\",\"modelMatrix\":\"0.982905,0.0665172,0.172476,0,-0.0922199,0.979731,0.17838,0,-0.159442,-0.189045,0.968733,0,17.3596,5.98539,-12.3379,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'2c6d6160-5bc1-40c9-8604-7c7bf18ba87b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7f47fd88-9ea0-4c08-9193-a54d4f158c7c/session_7873a396-419c-4215-83c7-fec9f2742ccf/order_fea60d55-0fac-426f-9ae8-7c5f199dfe32/16_w1_inlay_onlay_prost_file_2c6d6160-5bc1-40c9-8604-7c7bf18ba87b_0.pdf','PDF','PATIENT_7f47fd88-9ea0-4c08-9193-a54d4f158c7c_ACT_7873a396-419c-4215-83c7-fec9f2742ccf_PROST_fea60d55-0fac-426f-9ae8-7c5f199dfe32_PDF_','2022-02-04 08:35:45','2022-02-04 09:35:44','16_w1_inlay_onlay_prost_file_2c6d6160-5bc1-40c9-8604-7c7bf18ba87b_0.pdf','2022-02-04 09:35:45','SYNCED','2c6d6160-5bc1-40c9-8604-7c7bf18ba87b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.16.1.1 INLAY ONLAY\",\"title\":\"Inlay/Onlay PDF\"}'),(1001,'2c9dc5ab-4ca8-43c2-abc8-b66390f71327','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/533d4409-e39d-4a27-a0af-b59e6cf76ce3/session_319a8f1d-33fc-4f87-a108-b3eabda0510f/occlusion_3b38f07b-42cb-40b1-933f-365e568702e4/scan_450a38a9-baaa-443c-b15d-b73099c5ee33/37_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_533d4409-e39d-4a27-a0af-b59e6cf76ce3_ACT_319a8f1d-33fc-4f87-a108-b3eabda0510f_SESS_3b38f07b-42cb-40b1-933f-365e568702e4_BOSC_450a38a9-baaa-443c-b15d-b73099c5ee33_SNAPS_','2022-07-07 16:02:36','2022-07-07 18:02:27','37_w1_o1_mandibule_snapshot_0.png','2022-07-07 18:02:36','SYNCED','2c9dc5ab-4ca8-43c2-abc8-b66390f71327',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.37.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'2cdb0d7a-4a22-4953-a430-1bf6d75a218e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/de078619-3946-4adb-a799-1c260e16face/session_24d0aeb5-3058-4070-aeea-97c289e41e3c/occlusion_ea6da896-1504-41fc-890c-7c48575e9e40/scan_aa24138a-68e8-4bc3-9a5d-d617f0fe496b/2_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_de078619-3946-4adb-a799-1c260e16face_ACT_24d0aeb5-3058-4070-aeea-97c289e41e3c_SESS_ea6da896-1504-41fc-890c-7c48575e9e40_TOSC_aa24138a-68e8-4bc3-9a5d-d617f0fe496b_SNAPS_','2022-01-19 14:01:46','2022-01-19 15:01:28','2_w1_o1_maxillaire_snapshot_0.png','2022-01-19 15:01:46','SYNCED','2cdb0d7a-4a22-4953-a430-1bf6d75a218e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.2.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'2d19158c-3b80-44da-a89a-406e83a828ae','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_1c86378e-7d31-4b12-82ff-af797020160f/4_w1_o2_mandibule_snapshot_2.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_BOSC_1c86378e-7d31-4b12-82ff-af797020160f_SNAPS_','2022-03-08 11:40:04','2022-03-08 12:39:55','4_w1_o2_mandibule_snapshot_2.png','2022-03-08 12:40:04','SYNCED','a13ef72a-3421-4e8c-a897-3f43da14e842',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.2.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'2d3ec2de-1984-4105-8e9d-9dc6be723be5','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a0c21836-ba79-4f15-9e35-02ef8211a9e5/session_0aac522d-3c38-465a-a1e0-014166c140ac/occlusion_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042/scan_b3e360d5-eb70-4046-910f-cbac3270fd6c/7_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_a0c21836-ba79-4f15-9e35-02ef8211a9e5_ACT_0aac522d-3c38-465a-a1e0-014166c140ac_SESS_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042_TOSC_b3e360d5-eb70-4046-910f-cbac3270fd6c_ZIP_','2022-01-21 11:45:25','2022-01-21 12:44:55','7_w1_o1_maxillaire_scan_file_1.zip','2022-01-21 12:45:25','SYNCED','7fc09fc3-81a3-49fd-a553-03ab9f8a113e',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.7.1.1.1\",\"modelMatrix\":\"-0.680945,0.720562,-0.130783,0,-0.732335,-0.669999,0.121606,0,-1.31378e-9,0.178584,0.983925,0,12.1717,-26.3212,-18.2196,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'2da411aa-1f1a-4e03-9645-da281ed894ff','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/occlusion_e08bbeeb-a30b-428c-bd4a-40198f792219/scan_fba3c050-83af-4c2f-a411-0975c46179ac/25_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_SESS_e08bbeeb-a30b-428c-bd4a-40198f792219_LESC_fba3c050-83af-4c2f-a411-0975c46179ac_SNAPS_','2022-05-17 16:40:17','2022-05-17 18:40:07','25_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-05-17 18:40:17','SYNCED','2da411aa-1f1a-4e03-9645-da281ed894ff',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.25.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'2ddc847f-ec82-429e-b529-37c074cacf57','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f4fc00ec-4af8-4a15-b427-f1c5aabf6260/session_498ae60a-23f0-44fc-9730-be499bfc4b46/occlusion_8f3d6c73-3468-45a5-85c7-93bba47ec9f7/scan_60c1cc80-0d70-4511-8993-70e3a3c146b8/30_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_f4fc00ec-4af8-4a15-b427-f1c5aabf6260_ACT_498ae60a-23f0-44fc-9730-be499bfc4b46_SESS_8f3d6c73-3468-45a5-85c7-93bba47ec9f7_BOSC_60c1cc80-0d70-4511-8993-70e3a3c146b8_ZIP_','2022-06-14 13:19:46','2022-06-14 15:19:39','30_w1_o1_mandibule_scan_file_1.zip','2022-06-14 15:19:46','SYNCED','c5123228-55c5-43a0-9a9c-7d17bd8cb24d',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.30.1.1.1\",\"modelMatrix\":\"-0.121583,0.970699,-0.207271,0,-0.992581,-0.118902,0.0253889,0,1.0676e-09,0.20882,0.977954,0,3.47051,-3.06677,-21.1986,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'2de8ced1-ba29-48f4-bc49-585a3648f21c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_6c9ae07a-23c3-4355-87ff-b57ef558a4ea/17_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_LESC_6c9ae07a-23c3-4355-87ff-b57ef558a4ea_SNAPS_','2022-02-11 16:09:33','2022-02-11 17:08:22','17_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-02-11 17:09:33','SYNCED','2de8ced1-ba29-48f4-bc49-585a3648f21c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.17.1.1.3\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'2e01a63c-1021-4a88-8ff7-135b62add7d5','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/452a5200-3e06-4b74-8949-6abc7f2dda8a/session_3e95d626-668f-45f7-98ad-be2cf9d7b90b/occlusion_bce8310f-eee9-4f0a-a6b7-d592dec66be5/computedocclusion_d9818808-7d5e-47e6-9880-cc95357483ff/26_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_452a5200-3e06-4b74-8949-6abc7f2dda8a_ACT_3e95d626-668f-45f7-98ad-be2cf9d7b90b_SESS_bce8310f-eee9-4f0a-a6b7-d592dec66be5_OCC_d9818808-7d5e-47e6-9880-cc95357483ff_TOMA__MATRX_','2022-05-24 09:43:00','2022-05-24 11:42:41','26_w1_o1_maxillaire_matrix_occ_file_0.m','2022-05-24 11:43:00','SYNCED','2e01a63c-1021-4a88-8ff7-135b62add7d5',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.26.1.1.2 Occlusion 2\",\"referenceScanID\":\"1.26.1.1.2\",\"title\":\"Matrice Transfo. Maxillaire 1.26.1.1.2 Occlusion 2\"}'),(1001,'2e04f411-6952-46e7-84ee-356ce3d09961','','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_BOSC_07148fa2-1d5b-4343-81f9-ef44df15e4c7_ZIP_','2022-02-19 17:53:23','2022-02-14 19:30:12','','2022-02-19 18:53:23','SYNCED','473be61f-e0c7-4b5b-97bc-a62aab17df37',1,'2022-02-19 18:53:23','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.4.2\",\"modelMatrix\":\"0.127972,0.961809,-0.241963,0,-0.991778,0.124105,-0.0312211,0,-1.70152e-09,0.243969,0.969783,0,5.86815,-42.128,-18.2425,1\",\"title\":\"Mandibule ZIP\"}'),(2,'2e4bff0b-2dc5-11ed-a752-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2e4bff0b-2dc5-11ed-a752-9ec33d03e6dd.png','SNAPS','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_21743037-e185-4ce7-80aa-af01b0d42c2d_SNAPS_','2022-09-06 09:20:42','2022-08-30 11:00:57','2e4bff0b-2dc5-11ed-a752-9ec33d03e6dd.png','2022-09-06 11:20:42','SYNCED','2e4bff0b-2dc5-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 371.3.1.1.6\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'2e4ec1fa-2dc5-11ed-a752-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2e4ec1fa-2dc5-11ed-a752-9ec33d03e6dd.png','SNAPS','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_b42f4445-ea70-4de5-bf5c-892a7b6eaa24_SNAPS_','2022-09-06 09:20:32','2022-08-30 10:57:23','2e4ec1fa-2dc5-11ed-a752-9ec33d03e6dd.png','2022-09-06 11:20:32','SYNCED','2e4ec1fa-2dc5-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 371.3.1.1.5\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'2e50706e-2dc5-11ed-a752-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2e50706e-2dc5-11ed-a752-9ec33d03e6dd.zip','ZIP','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_232c4a5c-d521-4972-9735-eb9d27cffedc_ZIP_','2022-09-06 09:20:42','2022-08-30 10:43:19','2e50706e-2dc5-11ed-a752-9ec33d03e6dd.zip','2022-09-06 11:20:42','SYNCED','2e50706e-2dc5-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 371.3.1.1.3\",\"modelMatrix\":\"0.807997,0.577429,-0.117121,0,-0.589187,0.791872,-0.160616,0,8.33841e-10,0.198783,0.980043,0,-28.159,-4.83121,-15.9851,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'2e5263fe-2dc5-11ed-a752-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2e5263fe-2dc5-11ed-a752-9ec33d03e6dd.zip','ZIP','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_53241704-034c-49e7-bd41-012398465214_ZIP_','2022-09-06 09:20:38','2022-08-30 10:39:58','2e5263fe-2dc5-11ed-a752-9ec33d03e6dd.zip','2022-09-06 11:20:38','SYNCED','2e5263fe-2dc5-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 371.3.1.1.2\",\"modelMatrix\":\"0.731042,0.662354,-0.163904,0,-0.682332,0.709638,-0.175604,0,-7.1534e-09,0.240211,0.970721,0,-27.4537,-9.8526,-16.0814,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'2e53e5e6-2dc5-11ed-a752-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2e53e5e6-2dc5-11ed-a752-9ec33d03e6dd.zip','ZIP','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_587e0605-ba57-4583-83e9-a1cc32707c91_ZIP_','2022-09-06 09:20:35','2022-08-30 10:53:39','2e53e5e6-2dc5-11ed-a752-9ec33d03e6dd.zip','2022-09-06 11:20:35','SYNCED','2e53e5e6-2dc5-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 371.3.1.1.4\",\"modelMatrix\":\"0.544914,0.827333,-0.136337,0,-0.838492,0.537663,-0.0886022,0,1.16965e-09,0.162599,0.986692,0,-24.1684,-16.3159,-16.3462,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'2e55ba84-2dc5-11ed-a752-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2e55ba84-2dc5-11ed-a752-9ec33d03e6dd.zip','ZIP','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_21743037-e185-4ce7-80aa-af01b0d42c2d_ZIP_','2022-09-06 09:17:55','2022-08-30 11:00:58','2e55ba84-2dc5-11ed-a752-9ec33d03e6dd.zip','2022-09-06 11:17:55','SYNCED','2e55ba84-2dc5-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 371.3.1.1.6\",\"modelMatrix\":\"0.884901,0.449075,-0.123616,0,-0.465778,0.853169,-0.234849,0,3.7488e-09,0.265396,0.96414,0,-28.3676,-3.7757,-16.7896,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'2e572fd3-2dc5-11ed-a752-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2e572fd3-2dc5-11ed-a752-9ec33d03e6dd.png','SNAPS','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_587e0605-ba57-4583-83e9-a1cc32707c91_SNAPS_','2022-09-06 09:17:50','2022-08-30 10:53:38','2e572fd3-2dc5-11ed-a752-9ec33d03e6dd.png','2022-09-06 11:17:50','SYNCED','2e572fd3-2dc5-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 371.3.1.1.4\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'2e5771c3-2656-438e-88f4-f38de1cdf014','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/fa7fa96b-f393-4b9a-8198-144702462cfa/session_4bed076c-8541-4a2f-800a-5aeb4cb49de5/occlusion_16b82fca-4b65-4866-af87-1f6dbb42f5dc/computedocclusion_94a0167c-6798-4c78-a76c-cb9fc91ccdda/35_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_fa7fa96b-f393-4b9a-8198-144702462cfa_ACT_4bed076c-8541-4a2f-800a-5aeb4cb49de5_SESS_16b82fca-4b65-4866-af87-1f6dbb42f5dc_OCC_94a0167c-6798-4c78-a76c-cb9fc91ccdda_TOPLY__ZIP_','2022-06-28 15:03:43','2022-06-28 17:03:25','35_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-06-28 17:03:43','SYNCED','2e5771c3-2656-438e-88f4-f38de1cdf014',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.35.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.09906,0.984988,-0.141374,0,-0.995081,0.0980552,-0.0140737,0,-1.38943e-09,0.142073,0.989856,0,-3.58695,-24.3271,-17.1724,1\",\"referenceScanID\":\"1.35.1.1.1\",\"title\":\"Maxillaire 1.35.1.1.1 Occlusion 1\"}'),(2,'2e58a3d5-2dc5-11ed-a752-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2e58a3d5-2dc5-11ed-a752-9ec33d03e6dd.png','SNAPS','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_53241704-034c-49e7-bd41-012398465214_SNAPS_','2022-09-06 09:17:50','2022-08-30 10:39:57','2e58a3d5-2dc5-11ed-a752-9ec33d03e6dd.png','2022-09-06 11:17:50','SYNCED','2e58a3d5-2dc5-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 371.3.1.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'2e5aa489-2dc5-11ed-a752-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2e5aa489-2dc5-11ed-a752-9ec33d03e6dd.zip','ZIP','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_f9a200bf-710b-4bad-a122-de56d5bc4da4_ZIP_','2022-09-06 09:20:32','2022-08-30 10:36:06','2e5aa489-2dc5-11ed-a752-9ec33d03e6dd.zip','2022-09-06 11:20:32','SYNCED','2e5aa489-2dc5-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 371.3.1.1.1\",\"modelMatrix\":\"0.68153,0.72027,-0.129336,0,-0.73179,0.670801,-0.120453,0,1.08731e-08,0.176739,0.984258,0,-27.3042,-9.55749,-15.1525,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'2e5c24fb-2dc5-11ed-a752-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2e5c24fb-2dc5-11ed-a752-9ec33d03e6dd.png','SNAPS','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_232c4a5c-d521-4972-9735-eb9d27cffedc_SNAPS_','2022-09-06 09:17:51','2022-08-30 10:43:18','2e5c24fb-2dc5-11ed-a752-9ec33d03e6dd.png','2022-09-06 11:17:51','SYNCED','2e5c24fb-2dc5-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 371.3.1.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'2e5d8de7-2dc5-11ed-a752-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2e5d8de7-2dc5-11ed-a752-9ec33d03e6dd.png','SNAPS','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_f9a200bf-710b-4bad-a122-de56d5bc4da4_SNAPS_','2022-09-06 09:17:46','2022-08-30 10:36:05','2e5d8de7-2dc5-11ed-a752-9ec33d03e6dd.png','2022-09-06 11:17:46','SYNCED','2e5d8de7-2dc5-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 371.3.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'2e5ef4e2-2dc5-11ed-a752-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2e5ef4e2-2dc5-11ed-a752-9ec33d03e6dd.zip','ZIP','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_b42f4445-ea70-4de5-bf5c-892a7b6eaa24_ZIP_','2022-09-06 09:17:49','2022-08-30 10:57:24','2e5ef4e2-2dc5-11ed-a752-9ec33d03e6dd.zip','2022-09-06 11:17:49','SYNCED','2e5ef4e2-2dc5-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 371.3.1.1.5\",\"modelMatrix\":\"0.797969,0.575965,-0.177509,0,-0.602698,0.762575,-0.235021,0,1.5203e-09,0.294523,0.955644,0,-29.1176,-8.59099,-15.2129,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'2f656c4b-a2fa-4387-af79-da669c8f19dd','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/scan_a45e609a-ed7e-4f9d-a646-fcf505dd8590/22_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_RISC_a45e609a-ed7e-4f9d-a646-fcf505dd8590_SNAPS_','2022-04-21 11:27:47','2022-04-21 13:27:39','22_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-04-21 13:27:47','SYNCED','2f656c4b-a2fa-4387-af79-da669c8f19dd',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.22.1.1.5\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'2f75a784-e183-40f9-b781-9d47264b3a09','','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_BOSC_4aa73b1e-d6d0-436c-8abe-c649026c7ff2_SNAPS_','2022-02-19 17:53:23','2022-02-14 19:11:33','','2022-02-19 18:53:23','SYNCED','82b96208-37c7-4afb-8cb7-2139b6f0227e',1,'2022-02-19 18:53:23','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.4.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'2fb94557-be5e-48c5-9ff3-311d1acedadc','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/69640c87-271c-4a44-a6fa-67b01654cc27/session_5f9199b0-eb37-4ed3-8d1a-6c38505d4913/occlusion_991beec3-fe9e-4c98-a3d4-c98e4a4c2471/scan_6d0af0d8-98cb-48b6-aac5-3e0e3c3d7e7e/39_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_LESC_6d0af0d8-98cb-48b6-aac5-3e0e3c3d7e7e_SNAPS_','2022-09-09 16:43:33','2022-09-09 18:43:26','39_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-09-09 18:43:33','SYNCED','2fb94557-be5e-48c5-9ff3-311d1acedadc',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.39.1.1.8\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'2feb5083-2342-4ea4-b23e-8a9e43aa5b65','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/fa7fa96b-f393-4b9a-8198-144702462cfa/session_4bed076c-8541-4a2f-800a-5aeb4cb49de5/occlusion_16b82fca-4b65-4866-af87-1f6dbb42f5dc/scan_07f2d366-54ce-478e-95a9-7ae35cfbc11a/35_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_fa7fa96b-f393-4b9a-8198-144702462cfa_ACT_4bed076c-8541-4a2f-800a-5aeb4cb49de5_SESS_16b82fca-4b65-4866-af87-1f6dbb42f5dc_LESC_07f2d366-54ce-478e-95a9-7ae35cfbc11a_SNAPS_','2022-06-28 15:03:04','2022-06-28 17:02:56','35_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-06-28 17:03:04','SYNCED','2feb5083-2342-4ea4-b23e-8a9e43aa5b65',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.35.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'303d11e3-0d3a-4c62-9d15-3ebe2e7bb93b','','ZIP','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_OCC_ac3a5a7c-5db4-4c82-a2a9-9cb52e09f003_BOPLY__ZIP_','2022-05-12 12:34:04','2022-05-12 14:33:34','','2022-05-12 14:34:04','SYNCED','303d11e3-0d3a-4c62-9d15-3ebe2e7bb93b',0,'2022-05-12 14:34:04','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.18.1.1.3 Occlusion 4\",\"modelMatrix\":\"-0.721265,0.622319,-0.304132,0,-0.69266,-0.648019,0.316692,0,5.59464e-09,0.439079,0.898449,0,-8.58806,-18.2472,-17.8803,1\",\"referenceScanID\":\"1.18.1.1.3\",\"title\":\"Mandibule 1.18.1.1.3 Occlusion 4\"}'),(1001,'30443cfd-cdb4-4ea3-87e5-17e124205f74','','SNAPS','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_OCC_ac3a5a7c-5db4-4c82-a2a9-9cb52e09f003_SNAPO__SNAPS_','2022-05-12 12:34:04','2022-05-12 14:33:33','',NULL,'CREATED','30443cfd-cdb4-4ea3-87e5-17e124205f74',0,'2022-05-12 14:34:04','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'306d6630-ab21-4773-9b55-279096ec07d2','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/32710234-804f-46f5-899d-eed636f8a906/session_64c1427a-b91d-4675-94df-f36bd40e9b0f/occlusion_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a/scan_3954e24e-9220-452b-a8fa-b1fbde6ebcad/33_w2_o1_mandibule_scan_file_2.zip','ZIP','PATIENT_32710234-804f-46f5-899d-eed636f8a906_ACT_64c1427a-b91d-4675-94df-f36bd40e9b0f_SESS_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a_BOSC_3954e24e-9220-452b-a8fa-b1fbde6ebcad_ZIP_','2022-06-28 09:03:24','2022-06-28 11:03:16','33_w2_o1_mandibule_scan_file_2.zip','2022-06-28 11:03:24','SYNCED','f83e0257-49c2-409b-a1b0-0c5bb674c327',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.33.2.1.1\",\"modelMatrix\":\"-0.911542,-0.410478,0.0244887,0,0.411207,-0.909924,0.0542853,0,-6.94447e-10,0.0595532,0.998225,0,18.7622,-5.69322,-17.7897,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'30720071-8a94-43cc-8fd5-1a603f6e4072','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/computedocclusion_00405f86-eefa-41f9-8d98-1fa9cbeef855/24_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_00405f86-eefa-41f9-8d98-1fa9cbeef855_BOPLY__ZIP_','2022-05-25 09:03:27','2022-05-25 11:02:54','24_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-05-25 11:03:27','SYNCED','30720071-8a94-43cc-8fd5-1a603f6e4072',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.24.1.1.1 Occlusion 4\",\"modelMatrix\":\"0.852703,-0.521011,0.0380208,0,0.522396,0.850441,-0.062061,0,3.49638e-10,0.0727815,0.997348,0,-11.3911,-12.8136,-21.1334,1\",\"referenceScanID\":\"1.24.1.1.1\",\"title\":\"Mandibule 1.24.1.1.1 Occlusion 4\"}'),(1001,'3091a3f3-f34b-4876-8a99-9c2aa5f3ac00','','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_812fdd67-c9dc-4e0c-806a-0524a386b296_BOPLY__ZIP_','2022-02-07 17:55:14','2022-02-07 18:54:30','',NULL,'CREATED','3091a3f3-f34b-4876-8a99-9c2aa5f3ac00',0,'2022-02-07 18:55:14','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.17.1.1.1 Occlusion 5\",\"modelMatrix\":\"-0.980954,-0.188901,0.0452269,0,0.19424,-0.953992,0.228406,0,1.35057e-9,0.232841,0.972515,0,27.4349,19.1019,-20.1379,1\",\"referenceScanID\":\"1.17.1.1.1\",\"title\":\"Mandibule 1.17.1.1.1 Occlusion 5\"}'),(1001,'30d21ae5-2866-494e-8606-0d2109e784ca','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f9d03016-567a-4bd4-9cc5-dafeea34e365/session_a7bcb190-dd19-4f3b-8aab-266030bf4064/occlusion_c321e210-b67c-40e8-bece-f8946164a768/scan_90f9c577-02d8-45f3-9ac5-6c6cfeef1fa2/36_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_f9d03016-567a-4bd4-9cc5-dafeea34e365_ACT_a7bcb190-dd19-4f3b-8aab-266030bf4064_SESS_c321e210-b67c-40e8-bece-f8946164a768_BOSC_90f9c577-02d8-45f3-9ac5-6c6cfeef1fa2_SNAPS_','2022-07-04 13:53:56','2022-07-04 15:53:48','36_w1_o1_mandibule_snapshot_0.png','2022-07-04 15:53:56','SYNCED','30d21ae5-2866-494e-8606-0d2109e784ca',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.36.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'30e287e4-f479-42bb-a57e-e27ecab9f8ef','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/occlusion_a2220645-c79d-4dda-b6cc-772384a4106b/computedocclusion_8b14563e-0862-4cac-8045-e8aed2be886d/38_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_OCC_8b14563e-0862-4cac-8045-e8aed2be886d_BOPLY__ZIP_','2022-07-12 10:57:34','2022-07-12 12:57:24','38_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-07-12 12:57:34','SYNCED','30e287e4-f479-42bb-a57e-e27ecab9f8ef',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.38.1.1.1 Occlusion 1\",\"modelMatrix\":\"-0.751938,0.649871,-0.110711,0,-0.659234,-0.741259,0.12628,0,-8.33225e-09,0.167939,0.985797,0,9.41783,-30.192,-17.274,1\",\"referenceScanID\":\"1.38.1.1.1\",\"title\":\"Mandibule 1.38.1.1.1 Occlusion 1\"}'),(1001,'315d2e9a-ddd6-479c-912b-2896b73d049c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_a1bc5849-382d-4646-be42-6c870a889494/24_w1_o1_mordu_anterieur_scan_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_FRSC_a1bc5849-382d-4646-be42-6c870a889494_ZIP_','2022-05-24 14:57:25','2022-05-24 16:57:18','24_w1_o1_mordu_anterieur_scan_file_0.zip','2022-05-24 16:57:25','SYNCED','315d2e9a-ddd6-479c-912b-2896b73d049c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.24.1.1.1\",\"modelMatrix\":\"0.965547,-0.014051,-0.254255,0,0.0237033,0.999946,-0.00528806,0,0.259318,-0.00901537,0.967193,0,-1.16124,-2.99844,-20.2046,1\",\"title\":\"Mordu anterieur ZIP\"}'),(1001,'317f0ec5-e31d-433b-8d49-a5a69338f5f2','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/de078619-3946-4adb-a799-1c260e16face/session_24d0aeb5-3058-4070-aeea-97c289e41e3c/occlusion_ea6da896-1504-41fc-890c-7c48575e9e40/scan_aa24138a-68e8-4bc3-9a5d-d617f0fe496b/2_w1_o1_maxillaire_snapshot_2.png','SNAPS','PATIENT_de078619-3946-4adb-a799-1c260e16face_ACT_24d0aeb5-3058-4070-aeea-97c289e41e3c_SESS_ea6da896-1504-41fc-890c-7c48575e9e40_TOSC_aa24138a-68e8-4bc3-9a5d-d617f0fe496b_SNAPS_','2022-01-19 14:09:10','2022-01-19 15:08:51','2_w1_o1_maxillaire_snapshot_2.png','2022-01-19 15:09:10','SYNCED','2cdb0d7a-4a22-4953-a430-1bf6d75a218e',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.2.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'31816ce0-6747-48aa-98ae-21ae0c6b8280','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/scan_2a38e9c2-6808-43f3-904a-decdb37d60d5/4_w1_o4_mandibule_scan_file_1.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_BOSC_2a38e9c2-6808-43f3-904a-decdb37d60d5_ZIP_','2022-05-31 12:05:57','2022-05-31 14:05:49','4_w1_o4_mandibule_scan_file_1.zip','2022-05-31 14:05:57','SYNCED','9d63c9e3-26ee-496a-aee1-ec6b35f881e5',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.4.1\",\"modelMatrix\":\"-0.693921,-0.706378,0.139651,0,0.720051,-0.680745,0.134584,0,-7.89603e-09,0.193947,0.981012,0,1.63985,-2.11708,-20.6571,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'3188c2ad-80df-4826-920c-b8f1b834ccf5','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_4ed7adaa-3b77-4537-8479-4d0c4bd28c7b/12_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_TOSC_4ed7adaa-3b77-4537-8479-4d0c4bd28c7b_ZIP_','2022-01-27 11:55:36','2022-01-27 12:55:01','12_w1_o1_maxillaire_scan_file_0.zip','2022-01-27 12:55:36','SYNCED','3188c2ad-80df-4826-920c-b8f1b834ccf5',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.12.1.1.1\",\"modelMatrix\":\"0.861363,0.502204,-0.0764579,0,-0.507991,0.85155,-0.129644,0,-4.79901e-9,0.15051,0.988608,0,-26.2767,-10.316,-20.7198,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'31df9b40-ce6a-441c-a253-232bfee6d11d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/computedocclusion_0d180e89-cc7f-4718-abf6-79b3ada7fd3c/4_w1_o2_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_OCC_0d180e89-cc7f-4718-abf6-79b3ada7fd3c_TOMA__MATRX_','2022-02-15 12:49:57','2022-02-15 13:49:40','4_w1_o2_maxillaire_matrix_occ_file_0.m','2022-02-15 13:49:57','SYNCED','31df9b40-ce6a-441c-a253-232bfee6d11d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.4.1.2.1 Occlusion 3\",\"referenceScanID\":\"1.4.1.2.1\",\"title\":\"Matrice Transfo. Maxillaire 1.4.1.2.1 Occlusion 3\"}'),(1001,'3208f8ef-621d-43b2-b795-42c3bda237c7','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/computedocclusion_35af1bf5-285a-4bb1-a6db-fe9897defe51/23_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_35af1bf5-285a-4bb1-a6db-fe9897defe51_BOPLY__ZIP_','2022-05-13 12:11:30','2022-05-13 14:11:07','23_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-05-13 14:11:30','SYNCED','3208f8ef-621d-43b2-b795-42c3bda237c7',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.23.1.1.1 Occlusion 4\",\"modelMatrix\":\"0.99884,-0.00870968,0.0473501,0,0.0481445,0.180697,-0.98236,0,-1.26898e-10,0.9835,0.180907,0,0.872294,-19.7028,-3.24839,1\",\"referenceScanID\":\"1.23.1.1.1\",\"title\":\"Mandibule 1.23.1.1.1 Occlusion 4\"}'),(1001,'3220ff46-caf1-419c-a89c-e443c01aed51','','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_26ae7fce-0ea3-479f-9989-7d0a3a19aaf7_BOPLY__ZIP_','2022-02-08 08:48:59','2022-02-07 18:58:31','','2022-02-08 09:48:59','SYNCED','3220ff46-caf1-419c-a89c-e443c01aed51',0,'2022-02-08 09:48:59','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.17.1.1.1 Occlusion 6\",\"modelMatrix\":\"-0.980954,-0.188901,0.0452269,0,0.19424,-0.953992,0.228406,0,1.35057e-9,0.232841,0.972515,0,27.4349,19.1019,-20.1379,1\",\"referenceScanID\":\"1.17.1.1.1\",\"title\":\"Mandibule 1.17.1.1.1 Occlusion 6\"}'),(1001,'323c571d-5135-43a3-8d38-00a71feaa843','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/computedocclusion_864c98a3-fcf7-466a-b999-13bd4dfb8c65/23_w1_o1_mlmeta_occ_file_to1000.bin','LIFIM','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_864c98a3-fcf7-466a-b999-13bd4dfb8c65_LIFIMO_LIFIM_','2022-05-25 08:32:44','2022-05-25 10:32:43','23_w1_o1_mlmeta_occ_file_to1000.bin','2022-05-25 10:32:44','SYNCED','323c571d-5135-43a3-8d38-00a71feaa843',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.23.1.1.1 Occlusion 3 Ligne de finition 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"Maxillaire\",\"name\":\"Ligne de finition 0\",\"title\":\"Ligne finition metadata\",\"toothNumber\":1000}'),(1001,'32a6b182-e758-48ff-8841-fb3488ac3fb5','','ZIP','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_55831d43-1906-4a22-9b7a-ed4b2820c8b2_SESS_4f582d4c-81d0-4e01-8be3-9ff53b12c7f4_BOSC_b36554f3-43ab-43e8-bcdf-e12f8de33163_ZIP_','2022-06-16 13:28:16','2022-06-16 15:25:25','','2022-06-16 15:28:16','SYNCED','32a6b182-e758-48ff-8841-fb3488ac3fb5',0,'2022-06-16 15:28:16','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.10.2.1.1\",\"modelMatrix\":\"-0.976999,0.178683,-0.116387,0,-0.213246,-0.818649,0.533236,0,8.11329e-09,0.54579,0.837922,0,-2.14335,-13.14,-16.6489,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'32c963db-937e-4097-9147-82e959d76ecf','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/computedocclusion_b903dd27-411a-4a7c-b357-1cc9a414dbdd/17_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_b903dd27-411a-4a7c-b357-1cc9a414dbdd_BOMA__MATRX_','2022-02-12 16:54:19','2022-02-12 17:53:18','17_w1_o1_mandibule_matrix_occ_file_0.m','2022-02-12 17:54:19','SYNCED','32c963db-937e-4097-9147-82e959d76ecf',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.17.1.1.2 Occlusion 7\",\"referenceScanID\":\"1.17.1.1.2\",\"title\":\"Matrice Transfo. Mandibule 1.17.1.1.2 Occlusion 7\"}'),(1001,'330f51cf-ae9e-4420-bbab-1556708e4b2f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_e6c95ef7-636d-4c88-8d02-e2d9840573db/13_w1_o1_mandibule_scan_file_7.zip','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_e6c95ef7-636d-4c88-8d02-e2d9840573db_ZIP_','2022-01-27 16:49:56','2022-01-27 17:41:36','13_w1_o1_mandibule_scan_file_7.zip','2022-01-27 17:49:56','SYNCED','bcef8d3e-9632-4976-8cda-4c6f3ac50e99',7,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.1\",\"modelMatrix\":\"-0.988558,-0.14507,0.041326,0,0.150841,-0.950734,0.270835,0,9.21839e-10,0.27397,0.961738,0,25.2533,13.1486,-19.6942,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'33116074-3803-4c9a-9b0b-7f2ec0ea7b7f','','MATRX','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_OCC_d58ce31f-4b72-44ad-b0e0-3d5d7d789322_TOMA__MATRX_','2022-01-19 11:15:36','2022-01-19 12:06:18','',NULL,'CREATED','33116074-3803-4c9a-9b0b-7f2ec0ea7b7f',0,'2022-01-19 12:15:36','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.1.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.1.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.1.1.1.1 Occlusion 1\"}'),(1001,'3358903e-3e70-4a5e-927b-c3466331075a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/computedocclusion_77753fb3-75a1-45c2-9191-7a5d98206df2/24_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_77753fb3-75a1-45c2-9191-7a5d98206df2_TOPLY__ZIP_','2022-06-14 12:07:16','2022-06-14 14:06:33','24_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-06-14 14:07:16','SYNCED','3358903e-3e70-4a5e-927b-c3466331075a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.4 Occlusion 5\",\"modelMatrix\":\"0.468816,0.851463,-0.234993,0,-0.883296,0.451921,-0.124724,0,3.16254e-09,0.266041,0.963962,0,-15.9085,-5.48362,-18.8921,1\",\"referenceScanID\":\"1.24.1.1.4\",\"title\":\"Maxillaire 1.24.1.1.4 Occlusion 5\"}'),(1001,'33b3a130-dc00-43ca-a57f-6d86e6efa62c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/computedocclusion_e15a2d21-e8f2-4d2a-9a68-13d92ae4b997/13_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_OCC_e15a2d21-e8f2-4d2a-9a68-13d92ae4b997_TOMA__MATRX_','2022-02-04 18:25:04','2022-02-04 19:23:45','13_w1_o1_maxillaire_matrix_occ_file_0.m','2022-02-04 19:25:04','SYNCED','33b3a130-dc00-43ca-a57f-6d86e6efa62c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.13.1.1.3 Occlusion 3\",\"referenceScanID\":\"1.13.1.1.3\",\"title\":\"Matrice Transfo. Maxillaire 1.13.1.1.3 Occlusion 3\"}'),(1001,'33c1a04d-cbe7-4edc-920a-e235f4da07ff','','ZIP','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_OCC_ff8547d7-27f8-4862-9b63-e713dd817f3f_BOPLY__ZIP_','2022-09-09 17:04:15','2022-09-09 19:03:34','','2022-09-09 19:04:15','SYNCED','33c1a04d-cbe7-4edc-920a-e235f4da07ff',0,'2022-09-09 19:04:15','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.39.1.1.1 Occlusion 10\",\"modelMatrix\":\"-0.977808,0.200729,-0.0599951,0,-0.209503,-0.936857,0.280013,0,3.36067e-09,0.286368,0.95812,0,23.2439,5.67049,-19.9331,1\",\"referenceScanID\":\"1.39.1.1.1\",\"title\":\"Mandibule 1.39.1.1.1 Occlusion 10\"}'),(1001,'3404669d-d29f-41be-8f3a-d80595434b84','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_72adeb31-f7a3-4840-9f93-f10e61c84bef/4_w1_o2_maxillaire_snapshot_0.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_TOSC_72adeb31-f7a3-4840-9f93-f10e61c84bef_SNAPS_','2022-02-15 12:29:42','2022-02-15 13:29:29','4_w1_o2_maxillaire_snapshot_0.png','2022-02-15 13:29:42','SYNCED','3404669d-d29f-41be-8f3a-d80595434b84',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.4.1.2.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'344537a9-71f7-48c9-9243-57e6292e0241','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_2a7068fc-0efa-496f-ade9-aba5b0650655/12_w1_o1_mandibule_snapshot_6.png','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_2a7068fc-0efa-496f-ade9-aba5b0650655_SNAPS_','2022-02-04 12:11:39','2022-02-04 13:11:19','12_w1_o1_mandibule_snapshot_6.png','2022-02-04 13:11:39','SYNCED','7636e0d7-f242-431c-90a5-a65399d83ecd',6,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.5\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'34b47434-9215-4ffe-a7f7-4dea3dbc9904','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/scan_03839278-13f8-46e6-9581-ba11bc8bcb81/1_w1_o1_maxillaire_scan_file_4.zip','ZIP','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_BOSC_03839278-13f8-46e6-9581-ba11bc8bcb81_ZIP_','2022-01-19 13:02:33','2022-01-19 11:34:57','1_w1_o1_maxillaire_scan_file_4.zip','2022-01-19 14:02:33','SYNCED','96dd75bb-5035-460a-8afc-04f3755604b1',4,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.1.1.1.1\",\"modelMatrix\":\"-0.154277,0.952805,-0.261459,0,-0.988028,-0.148777,0.0408259,0,-2.59672e-9,0.264627,0.964351,0,-14.8611,-36.6101,-15.3158,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'352cc186-fca4-4aef-a7b3-20fcaf762580','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_9418414d-48f1-4a41-baa8-98bf650edaa3/4_w1_o2_mandibule_snapshot_0.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_BOSC_9418414d-48f1-4a41-baa8-98bf650edaa3_SNAPS_','2022-02-15 12:19:27','2022-02-15 13:19:18','4_w1_o2_mandibule_snapshot_0.png','2022-02-15 13:19:27','SYNCED','352cc186-fca4-4aef-a7b3-20fcaf762580',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.2.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'36168fc8-8ef4-4949-8aa2-4b37c94ba243','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_f4b07389-264e-4772-afc3-29b2187ced21/18_w1_o1_mordu_posterieur_gauche_scan_file_1.zip','ZIP','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_LESC_f4b07389-264e-4772-afc3-29b2187ced21_ZIP_','2022-03-07 14:43:38','2022-03-07 15:43:32','18_w1_o1_mordu_posterieur_gauche_scan_file_1.zip','2022-03-07 15:43:38','SYNCED','76566ef8-b89a-4fea-87e0-c9931b617c2a',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.18.1.1.1\",\"modelMatrix\":\"0.996698,-0.0718327,0.0141172,0,0.0785401,0.984466,0.159169,0,-0.022992,-0.160511,0.987162,0,-0.12545,-0.751174,-18.7896,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'366fc470-5b13-4ffc-b7a3-48eab550846c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_04d6e3f1-19ce-4851-a9d0-40419cea7542/scan_fef6f617-40e8-4052-8a2d-9af9e39ab22d/19_w1_o2_mandibule_snapshot_1.png','SNAPS','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_04d6e3f1-19ce-4851-a9d0-40419cea7542_BOSC_fef6f617-40e8-4052-8a2d-9af9e39ab22d_SNAPS_','2022-04-15 14:02:29','2022-04-15 16:02:16','19_w1_o2_mandibule_snapshot_1.png','2022-04-15 16:02:29','SYNCED','5a1c3667-dbf3-4de6-af8e-149a263ba435',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.2.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'36a94f62-cceb-4886-91fa-b926e6c95a77','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_1c86378e-7d31-4b12-82ff-af797020160f/4_w1_o2_mandibule_scan_file_1.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_BOSC_1c86378e-7d31-4b12-82ff-af797020160f_ZIP_','2022-03-08 11:37:29','2022-03-08 12:37:22','4_w1_o2_mandibule_scan_file_1.zip','2022-03-08 12:37:29','SYNCED','bb22e8ec-52ef-47ae-acce-e63ab615a505',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.2.3\",\"modelMatrix\":\"0.9578,-0.285579,0.0326067,0,0.287435,0.951617,-0.108653,0,-5.99873e-10,0.113441,0.993545,0,-3.29225,5.66637,-21.5294,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'371bb9fd-905d-4943-84fd-cd6950c4032d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_59fb6872-6b71-417d-a7ee-ab313b732b6c/13_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_TOSC_59fb6872-6b71-417d-a7ee-ab313b732b6c_ZIP_','2022-02-04 17:55:02','2022-02-04 17:22:20','13_w1_o1_maxillaire_scan_file_0.zip','2022-02-04 18:55:02','SYNCED','371bb9fd-905d-4943-84fd-cd6950c4032d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.13.1.1.3\",\"modelMatrix\":\"0.754335,0.643596,-0.129474,0,-0.65649,0.739519,-0.148771,0,2.61688e-9,0.197222,0.980359,0,-9.25272,-30.1421,-17.7968,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'3776cf6f-78c5-4afd-b648-487e22bf22b0','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_7b68804e-41db-41a7-9a19-d1aaecf91ab5/17_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_LESC_7b68804e-41db-41a7-9a19-d1aaecf91ab5_ZIP_','2022-02-07 11:43:16','2022-02-07 12:40:31','17_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-02-07 12:43:16','SYNCED','3776cf6f-78c5-4afd-b648-487e22bf22b0',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.17.1.1.1\",\"modelMatrix\":\"-0.945111,-0.253993,0.211265,0,0.256252,-0.965583,0.00632607,0,0.202773,0.0563478,0.97742,0,13.1357,2.84484,-21.4488,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'379b2161-55d8-42d3-8e51-07c89c9a759a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/57c4096f-98dd-49c8-bea5-a5b109ad3fd0/session_4f62e395-5623-4d5b-869c-1b2fc4d22b00/occlusion_1ac20dc7-b36b-4786-a05f-37091554dc5c/scan_e2e4ad7f-c1c9-4c11-a41c-d237b2e0023e/31_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_57c4096f-98dd-49c8-bea5-a5b109ad3fd0_ACT_4f62e395-5623-4d5b-869c-1b2fc4d22b00_SESS_1ac20dc7-b36b-4786-a05f-37091554dc5c_BOSC_e2e4ad7f-c1c9-4c11-a41c-d237b2e0023e_ZIP_','2022-06-16 10:59:43','2022-06-16 12:59:34','31_w1_o1_mandibule_scan_file_0.zip','2022-06-16 12:59:43','SYNCED','379b2161-55d8-42d3-8e51-07c89c9a759a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.31.1.1.1\",\"modelMatrix\":\"0.252718,0.957401,-0.139701,0,-0.96754,0.25007,-0.0364895,0,-5.51629e-10,0.144388,0.989521,0,-10.0594,-15.8463,-16.5488,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'37e0d74e-736e-4545-a4af-6d91a77c9ce3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5/occlusion_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa/scan_e350f1fd-e88b-43c1-b1e6-a905c9a72ccf/24_w2_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5_SESS_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa_LESC_e350f1fd-e88b-43c1-b1e6-a905c9a72ccf_ZIP_','2022-10-06 14:50:09','2022-10-06 16:49:57','24_w2_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-10-06 16:50:09','SYNCED','37e0d74e-736e-4545-a4af-6d91a77c9ce3',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.24.2.1.1\",\"modelMatrix\":\"-0.94054,0.32818,0.335078,0,-0.444603,-0.933011,-0.187644,0,-0.036303,-0.212769,0.9642,0,23.8077,13.1309,-17.6168,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'3809472a-b874-44bf-95da-806137b1d16e','','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_d79359b0-a63e-4bdb-91ad-dec77d961970_ZIP_','2022-02-04 11:29:38','2022-02-04 09:36:23','','2022-02-04 12:29:38','SYNCED','3809472a-b874-44bf-95da-806137b1d16e',0,'2022-02-04 12:29:38','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.3\",\"modelMatrix\":\"-0.961822,0.259307,-0.0875072,0,-0.273675,-0.911329,0.307542,0,5.65717e-9,0.319749,0.947502,0,33.7925,-1.80222,-15.4388,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'3857c31f-4878-48ad-9ad9-5da851292116','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_909d9ecd-46b3-4692-868e-f6405507ecd1/24_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_TOSC_909d9ecd-46b3-4692-868e-f6405507ecd1_ZIP_','2022-05-13 14:40:37','2022-05-13 16:40:25','24_w1_o1_maxillaire_scan_file_0.zip','2022-05-13 16:40:37','SYNCED','3857c31f-4878-48ad-9ad9-5da851292116',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.2\",\"modelMatrix\":\"-0.781023,0.606576,-0.148558,0,-0.624502,-0.758603,0.185791,0,5.67908e-09,0.237882,0.971294,0,0.960311,-5.65425,-25.9345,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'390337fd-721e-490f-b704-0a456bfdee04','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/69640c87-271c-4a44-a6fa-67b01654cc27/session_5f9199b0-eb37-4ed3-8d1a-6c38505d4913/occlusion_991beec3-fe9e-4c98-a3d4-c98e4a4c2471/computedocclusion_c7bccd1e-370e-4347-8296-1bcd4c30b631/39_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_OCC_c7bccd1e-370e-4347-8296-1bcd4c30b631_TOPLY__ZIP_','2022-09-10 09:46:06','2022-09-10 11:45:43','39_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-09-10 11:46:06','SYNCED','390337fd-721e-490f-b704-0a456bfdee04',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.39.1.1.1 Occlusion 10\",\"modelMatrix\":\"-0.226177,0.929302,-0.291961,0,-0.974086,-0.215779,0.0677916,0,7.55513e-09,0.299728,0.954025,0,-12.3361,-28.543,-16.1754,1\",\"referenceScanID\":\"1.39.1.1.1\",\"title\":\"Maxillaire 1.39.1.1.1 Occlusion 10\"}'),(1001,'391def53-fd6d-47f4-9a89-7f3eeef7ecbe','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/69640c87-271c-4a44-a6fa-67b01654cc27/session_5f9199b0-eb37-4ed3-8d1a-6c38505d4913/occlusion_991beec3-fe9e-4c98-a3d4-c98e4a4c2471/scan_1ff80dd9-2d47-4292-adde-0923cb6fe572/39_w1_o1_mordu_anterieur_scan_file_0.zip','ZIP','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_FRSC_1ff80dd9-2d47-4292-adde-0923cb6fe572_ZIP_','2022-09-09 16:25:08','2022-09-09 18:25:01','39_w1_o1_mordu_anterieur_scan_file_0.zip','2022-09-09 18:25:08','SYNCED','391def53-fd6d-47f4-9a89-7f3eeef7ecbe',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.39.1.1.1\",\"modelMatrix\":\"0.79041,-0.155351,0.589854,0,0.108758,0.987952,0.0864821,0,-0.602972,-0.0109634,0.803053,0,3.79118,0.958309,-24.7208,1\",\"title\":\"Mordu anterieur ZIP\"}'),(1001,'3943b273-3c44-4676-9549-5fe85a49e6a8','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/computedocclusion_e9bfc750-6943-42bf-8c0b-b7e1dc1803c5/1_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_OCC_e9bfc750-6943-42bf-8c0b-b7e1dc1803c5_TOMA__MATRX_','2022-01-19 13:04:01','2022-01-19 12:12:14','1_w1_o1_maxillaire_matrix_occ_file_0.m','2022-01-19 14:04:01','SYNCED','3943b273-3c44-4676-9549-5fe85a49e6a8',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.1.1.1.1 Occlusion 2\",\"referenceScanID\":\"1.1.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.1.1.1.1 Occlusion 2\"}'),(1001,'395ffacb-e959-4db8-8895-8d4342bd04ad','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_165dc4ed-fa76-4753-970f-5b2176e3e023/13_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_RISC_165dc4ed-fa76-4753-970f-5b2176e3e023_SNAPS_','2022-02-04 17:55:12','2022-02-04 17:29:16','13_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-02-04 18:55:12','SYNCED','395ffacb-e959-4db8-8895-8d4342bd04ad',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.13.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'39cdef70-1950-497a-a4b8-6989adae5674','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f9d03016-567a-4bd4-9cc5-dafeea34e365/session_a7bcb190-dd19-4f3b-8aab-266030bf4064/occlusion_c321e210-b67c-40e8-bece-f8946164a768/scan_90f9c577-02d8-45f3-9ac5-6c6cfeef1fa2/36_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_f9d03016-567a-4bd4-9cc5-dafeea34e365_ACT_a7bcb190-dd19-4f3b-8aab-266030bf4064_SESS_c321e210-b67c-40e8-bece-f8946164a768_BOSC_90f9c577-02d8-45f3-9ac5-6c6cfeef1fa2_SNAPS_','2022-07-04 13:58:41','2022-07-04 15:58:32','36_w1_o1_mandibule_snapshot_1.png','2022-07-04 15:58:41','SYNCED','30d21ae5-2866-494e-8606-0d2109e784ca',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.36.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'3a16e517-144b-422c-8b55-f03ff1c5b7f7','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/occlusion_e08bbeeb-a30b-428c-bd4a-40198f792219/scan_ef1d20c7-5f61-4c35-8f0f-d85507cab786/25_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_SESS_e08bbeeb-a30b-428c-bd4a-40198f792219_BOSC_ef1d20c7-5f61-4c35-8f0f-d85507cab786_SNAPS_','2022-05-17 16:13:04','2022-05-17 18:12:53','25_w1_o1_mandibule_snapshot_1.png','2022-05-17 18:13:04','SYNCED','135e8c27-bf0a-4d0f-b495-291e99638543',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.25.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'3a2cd8ae-78bd-4479-87b5-e22f52cf10d1','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/computedocclusion_b35629de-38d8-4cdd-bf2c-b61c461410cb/17_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_b35629de-38d8-4cdd-bf2c-b61c461410cb_BOMA__MATRX_','2022-02-07 18:07:23','2022-02-07 19:05:55','17_w1_o1_mandibule_matrix_occ_file_0.m','2022-02-07 19:07:23','SYNCED','3a2cd8ae-78bd-4479-87b5-e22f52cf10d1',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.17.1.1.1 Occlusion 6\",\"referenceScanID\":\"1.17.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.17.1.1.1 Occlusion 6\"}'),(1001,'3a3b3288-ed82-415d-8fb9-20b3ce5b6990','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7f47fd88-9ea0-4c08-9193-a54d4f158c7c/session_7873a396-419c-4215-83c7-fec9f2742ccf/occlusion_2e287bb0-e19a-414a-9177-23b335d286d9/scan_817e3173-ed5b-4bb7-93d5-bc02ec7eb79b/16_w1_o2_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_7f47fd88-9ea0-4c08-9193-a54d4f158c7c_ACT_7873a396-419c-4215-83c7-fec9f2742ccf_SESS_2e287bb0-e19a-414a-9177-23b335d286d9_RISC_817e3173-ed5b-4bb7-93d5-bc02ec7eb79b_ZIP_','2022-06-03 09:04:19','2022-06-03 11:04:12','16_w1_o2_mordu_posterieur_droit_scan_file_0.zip','2022-06-03 11:04:19','SYNCED','3a3b3288-ed82-415d-8fb9-20b3ce5b6990',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.16.1.2.1\",\"modelMatrix\":\"0.970745,-0.237229,-0.0275537,0,0.239874,0.951918,0.193352,0,-0.0128356,-0.193843,0.980768,0,-5.81621,9.44461,-17.517,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'3a6d9be4-fd1a-4da7-a56f-657c83be58a6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/scan_2a38e9c2-6808-43f3-904a-decdb37d60d5/4_w1_o4_mandibule_snapshot_1.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_BOSC_2a38e9c2-6808-43f3-904a-decdb37d60d5_SNAPS_','2022-05-31 12:05:57','2022-05-31 14:05:48','4_w1_o4_mandibule_snapshot_1.png','2022-05-31 14:05:57','SYNCED','fdb57445-483a-4c6d-abea-e77292f019f1',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.4.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'3af8da16-1c78-4867-83f5-40af48dbf8ae','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/computedocclusion_0bc29ff9-efea-448d-b521-2c39fd4faa78/19_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_OCC_0bc29ff9-efea-448d-b521-2c39fd4faa78_TOPLY__ZIP_','2022-03-08 11:18:04','2022-03-08 12:17:37','19_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-03-08 12:18:04','SYNCED','3af8da16-1c78-4867-83f5-40af48dbf8ae',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.19.1.1.1 Occlusion 3\",\"modelMatrix\":\"0.985752,-0.166051,0.0268482,0,0.168208,0.973114,-0.157339,0,2.19633e-09,0.159614,0.98718,0,-32.9792,-5.96138,-23.3688,1\",\"referenceScanID\":\"1.19.1.1.1\",\"title\":\"Maxillaire 1.19.1.1.1 Occlusion 3\"}'),(1001,'3b0eba2e-2de6-4ec7-83c9-1e2c7c8ff4da','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/occlusion_a2220645-c79d-4dda-b6cc-772384a4106b/computedocclusion_cf412dab-1d83-4db0-ae1b-d2724d5be97d/38_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_OCC_cf412dab-1d83-4db0-ae1b-d2724d5be97d_TOMA__MATRX_','2022-07-12 11:04:31','2022-07-12 13:04:14','38_w1_o1_maxillaire_matrix_occ_file_0.m','2022-07-12 13:04:31','SYNCED','3b0eba2e-2de6-4ec7-83c9-1e2c7c8ff4da',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.38.1.1.3 Occlusion 2\",\"referenceScanID\":\"1.38.1.1.3\",\"title\":\"Matrice Transfo. Maxillaire 1.38.1.1.3 Occlusion 2\"}'),(1001,'3b1b8529-9696-4bae-8527-ef23772fe66a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/computedocclusion_704a0750-2a24-448f-8f30-928139977895/4_w1_o2_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_OCC_704a0750-2a24-448f-8f30-928139977895_BOPLY__ZIP_','2022-03-08 11:49:43','2022-03-08 12:49:34','4_w1_o2_mandibule_occlusion_occ_file_0.zip','2022-03-08 12:49:43','SYNCED','3b1b8529-9696-4bae-8527-ef23772fe66a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.2.3 Occlusion 4\",\"modelMatrix\":\"0.966621,-0.254359,0.0307347,0,0.256209,0.959641,-0.115955,0,1.29208e-09,0.119959,0.992779,0,-3.1268,5.20706,-21.613,1\",\"referenceScanID\":\"1.4.1.2.3\",\"title\":\"Mandibule 1.4.1.2.3 Occlusion 4\"}'),(1001,'3b721ecd-c4ae-405a-9689-c48a7fb70e2b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/occlusion_e08bbeeb-a30b-428c-bd4a-40198f792219/scan_ef1d20c7-5f61-4c35-8f0f-d85507cab786/25_w1_o1_mandibule_snapshot_3.png','SNAPS','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_SESS_e08bbeeb-a30b-428c-bd4a-40198f792219_BOSC_ef1d20c7-5f61-4c35-8f0f-d85507cab786_SNAPS_','2022-05-17 16:18:51','2022-05-17 18:18:39','25_w1_o1_mandibule_snapshot_3.png','2022-05-17 18:18:51','SYNCED','135e8c27-bf0a-4d0f-b495-291e99638543',3,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.25.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'3bf97384-e1d6-4d83-b9a8-0e3c85f73174','','SNAPS','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_LESC_890154d7-23d4-4fb6-a767-967ce5a423f7_SNAPS_','2022-09-09 16:30:34','2022-09-09 18:19:24','','2022-09-09 18:30:34','SYNCED','3bf97384-e1d6-4d83-b9a8-0e3c85f73174',0,'2022-09-09 18:30:34','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.39.1.1.2\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'3c40df65-b847-40a7-b508-d8fe1ff90b07','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/computedocclusion_b903dd27-411a-4a7c-b357-1cc9a414dbdd/17_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_b903dd27-411a-4a7c-b357-1cc9a414dbdd_SNAPO__SNAPS_','2022-02-12 16:54:34','2022-02-12 17:53:18','17_w1_o1_snapshot_occ_file_0.png','2022-02-12 17:54:34','SYNCED','3c40df65-b847-40a7-b508-d8fe1ff90b07',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'3c4fadd2-de7f-4837-8bbb-4f30b68e8540','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/scan_c1f909ab-5469-4839-84f1-d04759dd1237/1_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_BOSC_c1f909ab-5469-4839-84f1-d04759dd1237_ZIP_','2022-01-19 13:00:20','2022-01-19 11:56:08','1_w1_o1_mandibule_scan_file_1.zip','2022-01-19 14:00:20','SYNCED','9dd0c754-d272-45ee-aa54-5d3030ae4573',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.1.1.1.1\",\"modelMatrix\":\"-0.89361,0.44322,-0.0708281,0,-0.448843,-0.882414,0.141013,0,3.36694e-10,0.157801,0.987471,0,37.1181,-2.30066,-14.9109,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'3cdf761f-0ac4-4f73-9f0e-c766ac406760','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_e6c95ef7-636d-4c88-8d02-e2d9840573db/13_w1_o1_mandibule_scan_file_5.zip','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_e6c95ef7-636d-4c88-8d02-e2d9840573db_ZIP_','2022-01-27 16:41:22','2022-01-27 17:40:39','13_w1_o1_mandibule_scan_file_5.zip','2022-01-27 17:41:22','SYNCED','bcef8d3e-9632-4976-8cda-4c6f3ac50e99',5,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.1\",\"modelMatrix\":\"-0.988558,-0.14507,0.041326,0,0.150841,-0.950734,0.270835,0,9.21839e-10,0.27397,0.961738,0,25.2533,13.1486,-19.6942,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'3d3712b8-d105-4369-a45d-93e76bd3c1f4','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_2ffbfbca-f236-4802-be93-8eb43d523274/scan_0bd54e85-3f0d-4955-9f02-7de656ad9f6f/4_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_2ffbfbca-f236-4802-be93-8eb43d523274_BOSC_0bd54e85-3f0d-4955-9f02-7de656ad9f6f_ZIP_','2022-01-19 19:04:35','2022-01-19 20:04:16','4_w1_o1_mandibule_scan_file_0.zip','2022-01-19 20:04:35','SYNCED','3d3712b8-d105-4369-a45d-93e76bd3c1f4',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.1.1\",\"modelMatrix\":\"-0.879502,0.457057,-0.13257,0,-0.475895,-0.844688,0.245003,0,-6.19601e-9,0.278571,0.960416,0,9.76271,-0.876021,-18.4238,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'3d6c789e-b9c2-4ef8-8fa6-d943d1f54eda','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/8fc74d9e-a5a0-46bf-be3f-500548a130ad/session_5368829e-7dec-4775-a487-a1019f9604f4/occlusion_bb63a653-1b34-4d80-a4bf-7fda5c9b0360/scan_3e9aff47-e0ac-4b19-973d-d25c0bab00c9/14_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_8fc74d9e-a5a0-46bf-be3f-500548a130ad_ACT_5368829e-7dec-4775-a487-a1019f9604f4_SESS_bb63a653-1b34-4d80-a4bf-7fda5c9b0360_LESC_3e9aff47-e0ac-4b19-973d-d25c0bab00c9_SNAPS_','2022-02-01 10:49:09','2022-02-01 11:48:59','14_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-02-01 11:49:09','SYNCED','3d6c789e-b9c2-4ef8-8fa6-d943d1f54eda',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.14.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'3d6d5801-910c-4d3d-9e99-e429d1716fc0','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/occlusion_e08bbeeb-a30b-428c-bd4a-40198f792219/scan_dee5ca38-e252-41d1-86ca-aebc66ae36fa/25_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_SESS_e08bbeeb-a30b-428c-bd4a-40198f792219_TOSC_dee5ca38-e252-41d1-86ca-aebc66ae36fa_ZIP_','2022-05-17 16:34:51','2022-05-17 18:34:39','25_w1_o1_maxillaire_scan_file_1.zip','2022-05-17 18:34:51','SYNCED','d240ab40-d14e-490e-b3b7-2c5295c6f83e',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.25.1.1.1\",\"modelMatrix\":\"0.999921,-0.0124601,0.00173472,0,0.0125803,0.990369,-0.137881,0,5.51735e-11,0.137892,0.990447,0,12.823,6.75113,-24.6355,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'3dbf1334-fddd-48c1-8621-612a8780a8c5','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_cfcda3c3-749c-4f3d-96e2-556ed558ceef/18_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_TOSC_cfcda3c3-749c-4f3d-96e2-556ed558ceef_SNAPS_','2022-03-07 14:03:59','2022-03-07 15:03:43','18_w1_o1_maxillaire_snapshot_0.png','2022-03-07 15:03:59','SYNCED','3dbf1334-fddd-48c1-8621-612a8780a8c5',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.18.1.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'3dfb9122-354d-485f-b43b-e2274d9b20d4','','SNAPS','PATIENT_452a5200-3e06-4b74-8949-6abc7f2dda8a_ACT_3e95d626-668f-45f7-98ad-be2cf9d7b90b_SESS_bce8310f-eee9-4f0a-a6b7-d592dec66be5_TOSC_0cdd9706-bf86-43f6-8f49-976542e5b9e8_SNAPS_','2022-05-24 09:15:25','2022-05-24 11:07:54','','2022-05-24 11:15:25','SYNCED','3dfb9122-354d-485f-b43b-e2274d9b20d4',0,'2022-05-24 11:15:25','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.26.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'3e073d59-562e-47d2-8488-a683f9596818','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/order_db4fa824-a30d-4200-8214-b45494eafbf7/23_w1_couronne_prost_file_3e073d59-562e-47d2-8488-a683f9596818_0.pdf','PDF','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_PROST_db4fa824-a30d-4200-8214-b45494eafbf7_PDF_','2022-05-13 11:41:15','2022-05-13 13:41:14','23_w1_couronne_prost_file_3e073d59-562e-47d2-8488-a683f9596818_0.pdf','2022-05-13 13:41:15','SYNCED','3e073d59-562e-47d2-8488-a683f9596818',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.23.1.1 COURONNE\",\"title\":\"Couronne PDF\"}'),(1001,'3e12665e-3464-414d-b006-973919ddbaa1','','ZIP','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_BOSC_3379235c-b42d-440c-84bc-d105a1d56127_ZIP_','2022-03-09 07:54:47','2022-03-08 11:29:35','','2022-03-09 08:54:47','SYNCED','91e77307-7833-49da-b522-a802584e820d',1,'2022-03-09 08:54:47','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.1.2\",\"modelMatrix\":\"0.688357,-0.67065,0.276395,0,0.725372,0.636426,-0.262291,0,-8.0385e-09,0.381039,0.924559,0,-11.574,-3.66965,-16.3105,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'3eae79bc-22cb-44f1-966d-3975f4f05ac6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/458c92d8-9da1-4df9-967f-d14fc7e6303d/session_55831d43-1906-4a22-9b7a-ed4b2820c8b2/occlusion_4f582d4c-81d0-4e01-8be3-9ff53b12c7f4/scan_19e6ea5c-af28-439b-bc57-b561cd42e12b/10_w2_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_55831d43-1906-4a22-9b7a-ed4b2820c8b2_SESS_4f582d4c-81d0-4e01-8be3-9ff53b12c7f4_TOSC_19e6ea5c-af28-439b-bc57-b561cd42e12b_ZIP_','2022-06-16 13:27:31','2022-06-16 15:27:22','10_w2_o1_maxillaire_scan_file_1.zip','2022-06-16 15:27:31','SYNCED','9eb7d518-a769-4fd8-9066-a0f2ece8f396',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.10.2.1.1\",\"modelMatrix\":\"-0.212083,-0.899884,0.38109,0,0.977252,-0.195292,0.0827039,0,9.19492e-09,0.389961,0.920831,0,4.82955,-10.9388,-23.3718,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'3f0d80c9-c35b-4350-8560-6f0018887c71','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_d87d63d7-4507-4391-b749-4b160c9363ed/12_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_d87d63d7-4507-4391-b749-4b160c9363ed_ZIP_','2022-01-27 12:07:55','2022-01-27 13:07:41','12_w1_o1_mandibule_scan_file_0.zip','2022-01-27 13:07:55','SYNCED','3f0d80c9-c35b-4350-8560-6f0018887c71',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.1\",\"modelMatrix\":\"0.990642,-0.135532,0.0161156,0,0.136487,0.983712,-0.11697,0,-9.70693e-10,0.118075,0.993005,0,-24.0456,-2.08013,-18.1911,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'3f37a0d9-8c84-43c7-9b52-17754cc2eb0b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/order_e17d5c9a-174c-49e5-9c0e-69a4ff4d101c/24_w1_autre_prost_file_3f37a0d9-8c84-43c7-9b52-17754cc2eb0b_0.pdf','PDF','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_PROST_e17d5c9a-174c-49e5-9c0e-69a4ff4d101c_PDF_','2022-05-16 18:03:10','2022-05-16 20:03:08','24_w1_autre_prost_file_3f37a0d9-8c84-43c7-9b52-17754cc2eb0b_0.pdf','2022-05-16 20:03:10','SYNCED','3f37a0d9-8c84-43c7-9b52-17754cc2eb0b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.24.1.1 AUTRE FICHE DE PROTHESE\",\"title\":\"Autre PDF\"}'),(1001,'3fd39567-7451-4cea-b9da-8ae7227c54be','','SNAPS','PATIENT_a0c21836-ba79-4f15-9e35-02ef8211a9e5_ACT_0aac522d-3c38-465a-a1e0-014166c140ac_SESS_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042_RISC_1181b7d1-03e3-4847-bb73-0b48192e787c_SNAPS_','2022-01-24 14:24:09','2022-01-21 13:00:20','','2022-01-24 15:24:09','SYNCED','3fd39567-7451-4cea-b9da-8ae7227c54be',0,'2022-01-24 15:24:09','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.7.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'3fe128aa-0e1b-4e6e-80e7-4b10abe3f501','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/occlusion_e08bbeeb-a30b-428c-bd4a-40198f792219/computedocclusion_a503ab26-f707-4923-86b6-049c17f73533/25_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_SESS_e08bbeeb-a30b-428c-bd4a-40198f792219_OCC_a503ab26-f707-4923-86b6-049c17f73533_BOPLY__ZIP_','2022-05-17 16:40:33','2022-05-17 18:40:25','25_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-05-17 18:40:33','SYNCED','3fe128aa-0e1b-4e6e-80e7-4b10abe3f501',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.25.1.1.2 Occlusion 1\",\"modelMatrix\":\"-0.964287,0.263246,-0.0291771,0,-0.264858,-0.958419,0.106227,0,5.11078e-10,0.110162,0.993914,0,-2.81379,1.33022,-23.6936,1\",\"referenceScanID\":\"1.25.1.1.2\",\"title\":\"Mandibule 1.25.1.1.2 Occlusion 1\"}'),(1001,'3fefd4cc-db2f-4080-84eb-0b75c88cc393','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_14264009-2f96-4841-9c75-17adb3424f9f/18_w1_o1_mordu_anterieur_scan_file_1.zip','ZIP','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_FRSC_14264009-2f96-4841-9c75-17adb3424f9f_ZIP_','2022-03-07 14:38:04','2022-03-07 15:37:56','18_w1_o1_mordu_anterieur_scan_file_1.zip','2022-03-07 15:38:04','SYNCED','6acab9c1-fd86-4b22-a28b-e83dbe7f0bf2',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.18.1.1.1\",\"modelMatrix\":\"0.988862,-0.147596,0.0590464,0,0.14644,0.983189,-0.0983675,0,-0.0303973,0.107632,0.993494,0,-1.70108,-5.92658,-20.3766,1\",\"title\":\"Mordu anterieur ZIP\"}'),(1001,'409dd0ba-1f03-4042-8f03-5144dba2e69e','','LIFI','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_OCC_8b14563e-0862-4cac-8045-e8aed2be886d_LIFIO_LIFI_','2022-07-19 13:44:34','2022-07-19 14:28:21','','2022-07-19 15:44:34','SYNCED','409dd0ba-1f03-4042-8f03-5144dba2e69e',0,'2022-07-19 15:44:34','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.38.1.1.1 Occlusion 1 Ligne de finition 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"Maxillaire\",\"name\":\"Ligne de finition 0\",\"title\":\"Ligne finition\",\"toothNumber\":1000}'),(1001,'411fcadb-15cc-4199-a69b-4707b3ed32ea','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/scan_64badb85-f6d8-46a0-8cc4-2125845f9e47/22_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_RISC_64badb85-f6d8-46a0-8cc4-2125845f9e47_SNAPS_','2022-04-21 11:13:13','2022-04-21 13:13:07','22_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-04-21 13:13:13','SYNCED','411fcadb-15cc-4199-a69b-4707b3ed32ea',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.22.1.1.3\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'41685560-a818-4e12-b424-2a69f0942647','','LIFI','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_TOSC_47ae7109-ac97-4f1b-8dd7-cc22debd4324_LIFI_','2022-07-19 13:56:04','2022-07-19 15:55:49','','2022-07-19 15:56:04','SYNCED','41685560-a818-4e12-b424-2a69f0942647',0,'2022-07-19 15:56:04','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.38.1.1.4 Ligne de finition 0\",\"name\":\"Ligne de finition 0\",\"title\":\"Maxillaire LIFI\",\"toothNumber\":0,\"versionMarginLine\":1}'),(1001,'416db3c9-b04a-404f-8271-79d9066b8d08','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_2ffbfbca-f236-4802-be93-8eb43d523274/scan_eb904683-acc6-4e6d-8900-3982d403ba0f/4_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_2ffbfbca-f236-4802-be93-8eb43d523274_FRSC_eb904683-acc6-4e6d-8900-3982d403ba0f_SNAPS_','2022-01-19 19:13:25','2022-01-19 20:11:50','4_w1_o1_mordu_anterieur_snapshot_0.png','2022-01-19 20:13:25','SYNCED','416db3c9-b04a-404f-8271-79d9066b8d08',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.4.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(2,'4224c7b0-e556-43c5-a593-8800fdfac9a9','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a4b302c-278d-4e12-ace5-f095ba0bf856/session_6206892a-2e7e-4765-ac90-b49bfb465997/occlusion_3c30231c-7cd7-4431-985b-2eaf7f6925ae/scan_b42f4445-ea70-4de5-bf5c-892a7b6eaa24/3_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_b42f4445-ea70-4de5-bf5c-892a7b6eaa24_SNAPS_','2022-09-06 09:20:32','2022-08-30 10:57:23','3_w1_o1_maxillaire_snapshot_0.png','2022-09-06 11:20:32','SYNCED','4224c7b0-e556-43c5-a593-8800fdfac9a9',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.3.1.1.5\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'426a07b1-c2bc-4663-b618-0e098b82921b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/fa7fa96b-f393-4b9a-8198-144702462cfa/session_4bed076c-8541-4a2f-800a-5aeb4cb49de5/occlusion_16b82fca-4b65-4866-af87-1f6dbb42f5dc/scan_07f2d366-54ce-478e-95a9-7ae35cfbc11a/35_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_fa7fa96b-f393-4b9a-8198-144702462cfa_ACT_4bed076c-8541-4a2f-800a-5aeb4cb49de5_SESS_16b82fca-4b65-4866-af87-1f6dbb42f5dc_LESC_07f2d366-54ce-478e-95a9-7ae35cfbc11a_ZIP_','2022-06-28 15:03:03','2022-06-28 17:02:56','35_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-06-28 17:03:03','SYNCED','426a07b1-c2bc-4663-b618-0e098b82921b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.35.1.1.1\",\"modelMatrix\":\"-0.88792,-0.0581614,0.456915,0,0.00733581,-0.994324,-0.0876594,0,0.459946,-0.0914194,0.885415,0,-7.37981,3.84763,-17.9281,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'42734ae7-ac95-4d21-8d0c-77ddbb5cc9e1','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/533d4409-e39d-4a27-a0af-b59e6cf76ce3/session_319a8f1d-33fc-4f87-a108-b3eabda0510f/occlusion_3b38f07b-42cb-40b1-933f-365e568702e4/scan_109ca2c4-8222-4d02-9ac7-b4b93937e1e2/37_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_533d4409-e39d-4a27-a0af-b59e6cf76ce3_ACT_319a8f1d-33fc-4f87-a108-b3eabda0510f_SESS_3b38f07b-42cb-40b1-933f-365e568702e4_TOSC_109ca2c4-8222-4d02-9ac7-b4b93937e1e2_SNAPS_','2022-07-07 15:51:58','2022-07-07 17:51:45','37_w1_o1_maxillaire_snapshot_1.png','2022-07-07 17:51:58','SYNCED','6fa5ad33-3773-4801-9f0b-ed36985cc55e',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.37.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'428d14dc-d1d1-483e-971b-4a89b607834d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/533d4409-e39d-4a27-a0af-b59e6cf76ce3/session_319a8f1d-33fc-4f87-a108-b3eabda0510f/occlusion_3b38f07b-42cb-40b1-933f-365e568702e4/scan_109ca2c4-8222-4d02-9ac7-b4b93937e1e2/37_w1_o1_maxillaire_scan_file_2.zip','ZIP','PATIENT_533d4409-e39d-4a27-a0af-b59e6cf76ce3_ACT_319a8f1d-33fc-4f87-a108-b3eabda0510f_SESS_3b38f07b-42cb-40b1-933f-365e568702e4_TOSC_109ca2c4-8222-4d02-9ac7-b4b93937e1e2_ZIP_','2022-07-07 15:56:37','2022-07-07 17:56:26','37_w1_o1_maxillaire_scan_file_2.zip','2022-07-07 17:56:37','SYNCED','0192b393-b665-47d2-aaac-671ff4a06d5c',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.37.1.1.1\",\"modelMatrix\":\"0.661054,0.729657,-0.174953,0,-0.750338,0.642834,-0.154135,0,1.49368e-08,0.233165,0.972437,0,3.12705,-26.0579,-17.6521,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'42d933f2-4058-4b08-b0d7-6431c9f7a74c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/occlusion_a2220645-c79d-4dda-b6cc-772384a4106b/scan_fb5993c3-7f31-49de-8a74-e83ef447f0a1/38_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_RISC_fb5993c3-7f31-49de-8a74-e83ef447f0a1_ZIP_','2022-07-12 10:57:17','2022-07-12 12:57:08','38_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-07-12 12:57:17','SYNCED','42d933f2-4058-4b08-b0d7-6431c9f7a74c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.38.1.1.1\",\"modelMatrix\":\"0.993183,0.110435,0.0498648,0,-0.112648,0.989693,0.0756138,0,-0.031496,-0.0918607,0.995999,0,4.71151,5.45832,-20.0366,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'430563f9-b0c8-4cb8-80de-b74c4152c2d2','','MATRX','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_1500b3eb-4b86-46c1-9c9f-7efbd0224ac8_BOMA__MATRX_','2022-05-25 08:56:38','2022-05-13 18:22:04','','2022-05-25 10:56:38','SYNCED','430563f9-b0c8-4cb8-80de-b74c4152c2d2',0,'2022-05-25 10:56:38','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.24.1.1.1 Occlusion 4\",\"referenceScanID\":\"1.24.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.24.1.1.1 Occlusion 4\"}'),(1001,'439d33c4-cacc-42ff-8ae1-ae3420efe92c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/computedocclusion_d5bff097-1085-4c55-afe3-1ce57126d88f/19_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_OCC_d5bff097-1085-4c55-afe3-1ce57126d88f_TOPLY__ZIP_','2022-03-08 11:16:24','2022-03-08 12:15:58','19_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-03-08 12:16:24','SYNCED','439d33c4-cacc-42ff-8ae1-ae3420efe92c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.19.1.1.1 Occlusion 2\",\"modelMatrix\":\"0.985752,-0.166051,0.0268482,0,0.168208,0.973114,-0.157339,0,2.19633e-09,0.159614,0.98718,0,-32.9792,-5.96138,-23.3688,1\",\"referenceScanID\":\"1.19.1.1.1\",\"title\":\"Maxillaire 1.19.1.1.1 Occlusion 2\"}'),(1001,'43bf2afa-4f73-488a-b1fc-60b302be27b3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/45ff7437-0691-4427-a7da-8250862e4b96/session_4ff9c682-c09d-42ff-8c29-aeb13e066ed2/occlusion_934673c1-a4b9-4508-ac1b-a03092a0693e/computedocclusion_161f60a4-d4f2-41f1-98ad-a8ccad84216c/9_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_45ff7437-0691-4427-a7da-8250862e4b96_ACT_4ff9c682-c09d-42ff-8c29-aeb13e066ed2_SESS_934673c1-a4b9-4508-ac1b-a03092a0693e_OCC_161f60a4-d4f2-41f1-98ad-a8ccad84216c_TOMA__MATRX_','2022-01-24 17:47:25','2022-01-24 18:46:00','9_w1_o1_maxillaire_matrix_occ_file_0.m','2022-01-24 18:47:25','SYNCED','43bf2afa-4f73-488a-b1fc-60b302be27b3',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.9.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.9.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.9.1.1.1 Occlusion 1\"}'),(1001,'43c446c4-2944-4827-8b74-5456466149e7','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/scan_a6e9f7d5-ea01-4016-a5c9-4b948fbd5ded/22_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_FRSC_a6e9f7d5-ea01-4016-a5c9-4b948fbd5ded_SNAPS_','2022-04-21 11:14:44','2022-04-21 13:14:37','22_w1_o1_mordu_anterieur_snapshot_0.png','2022-04-21 13:14:44','SYNCED','43c446c4-2944-4827-8b74-5456466149e7',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.22.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'43eafd97-707f-4454-9553-a0f6803a11fc','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/d100e894-0be9-4495-94e2-e469232f7817/session_2c8b85b5-c805-4b08-85e7-3d02dab72e99/occlusion_8a278cc5-a1c1-4dfb-9ee2-c971a6309afa/scan_061005ca-b3b4-4cb2-bf80-5bae7b8fc987/15_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_d100e894-0be9-4495-94e2-e469232f7817_ACT_2c8b85b5-c805-4b08-85e7-3d02dab72e99_SESS_8a278cc5-a1c1-4dfb-9ee2-c971a6309afa_TOSC_061005ca-b3b4-4cb2-bf80-5bae7b8fc987_SNAPS_','2022-02-01 15:15:50','2022-02-01 16:15:48','15_w1_o1_mandibule_snapshot_0.png','2022-02-01 16:15:50','SYNCED','43eafd97-707f-4454-9553-a0f6803a11fc',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.15.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'43faec45-d44e-4a5b-980c-14c82d42fdd3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_04d6e3f1-19ce-4851-a9d0-40419cea7542/scan_9e43db2d-10a9-414e-ac07-6b7642412ce5/19_w1_o2_maxillaire_snapshot_0.png','SNAPS','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_04d6e3f1-19ce-4851-a9d0-40419cea7542_TOSC_9e43db2d-10a9-414e-ac07-6b7642412ce5_SNAPS_','2022-04-15 11:41:27','2022-04-01 18:15:18','19_w1_o2_maxillaire_snapshot_0.png','2022-04-15 13:41:27','SYNCED','43faec45-d44e-4a5b-980c-14c82d42fdd3',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire SNAPSHOT\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'4427d55b-c065-48be-af93-9fe5797988df','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_77ec818f-d778-4945-9458-90665b5522ba/17_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_TOSC_77ec818f-d778-4945-9458-90665b5522ba_ZIP_','2022-02-07 11:28:27','2022-02-07 12:26:07','17_w1_o1_maxillaire_scan_file_1.zip','2022-02-07 12:28:27','SYNCED','6a291473-6bc6-401e-8fb7-01a4524ebec6',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.17.1.1.1\",\"modelMatrix\":\"0.149253,0.920186,-0.361913,0,-0.988799,0.138896,-0.0546284,0,-8.90892e-10,0.366013,0.93061,0,-24.4594,-29.735,-12.8678,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'44301718-8b73-40e6-9f06-c0e89b7e49e6','','SNAPS','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_TOSC_47ae7109-ac97-4f1b-8dd7-cc22debd4324_SNAPS_','2022-07-19 13:56:03','2022-07-19 15:55:49','','2022-07-19 15:56:03','SYNCED','44301718-8b73-40e6-9f06-c0e89b7e49e6',0,'2022-07-19 15:56:03','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.38.1.1.4\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'44327a80-c315-4ee4-8339-c54421e1de06','','ZIP','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_c9079d19-8ffb-46f7-a51e-3a7a90ccae59_SESS_8ba0f3b1-408f-4a02-92a0-63f09123b68e_LESC_f2611342-ebf4-4c08-b8d1-c7c38b1c7e7c_ZIP_','2022-01-28 17:15:43','2022-01-27 14:27:09','','2022-01-28 18:15:43','SYNCED','44327a80-c315-4ee4-8339-c54421e1de06',0,'2022-01-28 18:15:43','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.10.1.1.1\",\"modelMatrix\":\"-0.992699,0.089386,0.0835266,0,-0.0768384,-0.990191,0.106545,0,0.0930207,0.107778,0.990833,0,-5.72027,-7.8724,-16.0337,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'4447b3ff-fae6-4112-b63c-3a9385ee2158','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/computedocclusion_8e4092a3-64a2-4464-addd-03b3c8ba2289/24_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_8e4092a3-64a2-4464-addd-03b3c8ba2289_BOPLY__ZIP_','2022-05-13 16:21:12','2022-05-13 18:20:53','24_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-05-13 18:21:12','SYNCED','4447b3ff-fae6-4112-b63c-3a9385ee2158',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.24.1.1.1 Occlusion 3\",\"modelMatrix\":\"0.852703,-0.521011,0.0380208,0,0.522396,0.850441,-0.062061,0,3.49638e-10,0.0727815,0.997348,0,-11.3911,-12.8136,-21.1334,1\",\"referenceScanID\":\"1.24.1.1.1\",\"title\":\"Mandibule 1.24.1.1.1 Occlusion 3\"}'),(1001,'4484d278-10aa-429c-9763-c6998e83c1d6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f4fc00ec-4af8-4a15-b427-f1c5aabf6260/session_498ae60a-23f0-44fc-9730-be499bfc4b46/order_d76d0cba-8849-44b5-86bd-d723580b3cf9/30_w1_autre_prost_file_4484d278-10aa-429c-9763-c6998e83c1d6_0.pdf','PDF','PATIENT_f4fc00ec-4af8-4a15-b427-f1c5aabf6260_ACT_498ae60a-23f0-44fc-9730-be499bfc4b46_PROST_d76d0cba-8849-44b5-86bd-d723580b3cf9_PDF_','2022-06-14 17:10:42','2022-06-14 19:10:41','30_w1_autre_prost_file_4484d278-10aa-429c-9763-c6998e83c1d6_0.pdf','2022-06-14 19:10:42','SYNCED','4484d278-10aa-429c-9763-c6998e83c1d6',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.30.1.1 AUTRE FICHE DE PROTHESE\",\"title\":\"Autre PDF\"}'),(1001,'44912674-3117-4268-89c9-8b101f972579','','ZIP','PATIENT_452a5200-3e06-4b74-8949-6abc7f2dda8a_ACT_3e95d626-668f-45f7-98ad-be2cf9d7b90b_SESS_bce8310f-eee9-4f0a-a6b7-d592dec66be5_TOSC_0cdd9706-bf86-43f6-8f49-976542e5b9e8_ZIP_','2022-05-24 09:15:25','2022-05-24 11:07:55','','2022-05-24 11:15:25','SYNCED','44912674-3117-4268-89c9-8b101f972579',0,'2022-05-24 11:15:25','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.26.1.1.1\",\"modelMatrix\":\"-0.790076,0.350974,-0.502591,0,-0.61301,-0.452352,0.647764,0,1.88961e-08,0.819875,0.572542,0,3.3596,-22.5543,-15.4755,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'44c9a086-ebd4-4513-b03b-df67f000a760','','MATRX','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_OCC_ff8547d7-27f8-4862-9b63-e713dd817f3f_BOMA__MATRX_','2022-09-09 17:04:15','2022-09-09 19:03:34','','2022-09-09 19:04:15','SYNCED','44c9a086-ebd4-4513-b03b-df67f000a760',0,'2022-09-09 19:04:15','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.39.1.1.1 Occlusion 10\",\"referenceScanID\":\"1.39.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.39.1.1.1 Occlusion 10\"}'),(1001,'44ebcd6f-57c2-4cce-96f5-f9faa1c6b373','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_2a7068fc-0efa-496f-ade9-aba5b0650655/12_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_2a7068fc-0efa-496f-ade9-aba5b0650655_ZIP_','2022-02-04 11:45:00','2022-02-04 12:44:47','12_w1_o1_mandibule_scan_file_0.zip','2022-02-04 12:45:00','SYNCED','44ebcd6f-57c2-4cce-96f5-f9faa1c6b373',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.5\",\"modelMatrix\":\"0.625532,-0.7537,0.20161,0,0.780199,0.604286,-0.161642,0,3.06863e-9,0.258408,0.966036,0,4.64949,31.8294,-26.5993,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'45057e79-706b-4ee4-9c23-ad93f8923f71','','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_e2722784-a66c-4ece-91c0-2add756415ea_TOPLY__ZIP_','2022-05-13 16:32:18','2022-05-13 18:31:42','','2022-05-13 18:32:18','SYNCED','45057e79-706b-4ee4-9c23-ad93f8923f71',0,'2022-05-13 18:32:18','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.2 Occlusion 5\",\"modelMatrix\":\"-0.80453,0.576793,-0.141569,0,-0.593912,-0.781339,0.191773,0,-6.05286e-09,0.238367,0.971175,0,0.910551,-5.61768,-25.9513,1\",\"referenceScanID\":\"1.24.1.1.2\",\"title\":\"Maxillaire 1.24.1.1.2 Occlusion 5\"}'),(1001,'452d955d-b844-42ed-9edf-9d005a4afa46','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/207d6dbc-c19b-4726-a9b3-16235ae554cc/session_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35/occlusion_dc5762a3-c453-4166-8c86-82d23ac9f8a6/computedocclusion_3a1fff1c-0427-409c-aa94-06326e554d82/27_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_207d6dbc-c19b-4726-a9b3-16235ae554cc_ACT_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35_SESS_dc5762a3-c453-4166-8c86-82d23ac9f8a6_OCC_3a1fff1c-0427-409c-aa94-06326e554d82_BOMA__MATRX_','2022-05-30 11:09:39','2022-05-30 13:09:22','27_w1_o1_mandibule_matrix_occ_file_0.m','2022-05-30 13:09:39','SYNCED','452d955d-b844-42ed-9edf-9d005a4afa46',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.27.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.27.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.27.1.1.1 Occlusion 1\"}'),(1001,'45bad5da-e084-4bfd-828b-fd44fd367e7b','','MATRX','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_aa16f8ea-198d-4240-ab78-5a1f54823f0c_BOMA__MATRX_','2022-05-16 17:48:36','2022-05-16 19:47:59','','2022-05-16 19:48:36','SYNCED','45bad5da-e084-4bfd-828b-fd44fd367e7b',0,'2022-05-16 19:48:36','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.24.1.1.1 Occlusion 6\",\"referenceScanID\":\"1.24.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.24.1.1.1 Occlusion 6\"}'),(1001,'4637d7fd-a62e-492f-a536-68ef0089c543','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_04abc032-a797-420b-8d5e-ee9528f5e291/12_w1_o1_mordu_anterieur_scan_file_0.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_FRSC_04abc032-a797-420b-8d5e-ee9528f5e291_ZIP_','2022-02-04 12:19:28','2022-02-04 13:19:20','12_w1_o1_mordu_anterieur_scan_file_0.zip','2022-02-04 13:19:28','SYNCED','4637d7fd-a62e-492f-a536-68ef0089c543',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.12.1.1.1\",\"modelMatrix\":\"0.974766,-0.105993,0.210432,0,0.0700793,0.994301,0.0335315,0,-0.213467,-0.0385566,0.977398,0,1.51255,1.93508,-19.9759,1\",\"title\":\"Mordu anterieur ZIP\"}'),(1001,'463c7b84-774c-483c-ab9a-89a270919932','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/57c4096f-98dd-49c8-bea5-a5b109ad3fd0/session_4f62e395-5623-4d5b-869c-1b2fc4d22b00/occlusion_1ac20dc7-b36b-4786-a05f-37091554dc5c/computedocclusion_70f4220e-2a6b-4575-bd0e-09c14a13d758/31_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_57c4096f-98dd-49c8-bea5-a5b109ad3fd0_ACT_4f62e395-5623-4d5b-869c-1b2fc4d22b00_SESS_1ac20dc7-b36b-4786-a05f-37091554dc5c_OCC_70f4220e-2a6b-4575-bd0e-09c14a13d758_SNAPO__SNAPS_','2022-06-16 11:04:13','2022-06-16 13:03:55','31_w1_o1_snapshot_occ_file_0.png','2022-06-16 13:04:13','SYNCED','463c7b84-774c-483c-ab9a-89a270919932',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'46812872-d002-4e9b-a255-b85e584a028a','','MATRX','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_cb4cdc08-5d89-48dc-80a3-2e659c55f971_BOMA__MATRX_','2022-02-08 08:48:59','2022-02-07 18:52:17','','2022-02-08 09:48:59','SYNCED','46812872-d002-4e9b-a255-b85e584a028a',0,'2022-02-08 09:48:59','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.17.1.1.1 Occlusion 4\",\"referenceScanID\":\"1.17.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.17.1.1.1 Occlusion 4\"}'),(1001,'46be4566-2ed9-474b-bbd1-c7748e98f460','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_6c9ae07a-23c3-4355-87ff-b57ef558a4ea/17_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_LESC_6c9ae07a-23c3-4355-87ff-b57ef558a4ea_ZIP_','2022-02-11 16:08:30','2022-02-11 17:08:22','17_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-02-11 17:08:30','SYNCED','46be4566-2ed9-474b-bbd1-c7748e98f460',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.17.1.1.3\",\"modelMatrix\":\"-0.993498,0.071131,0.0881033,0,-0.069339,-0.99592,0.0645507,0,0.0903847,0.0556956,0.994024,0,-5.58281,0.770671,-18.0738,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'473be61f-e0c7-4b5b-97bc-a62aab17df37','','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_BOSC_07148fa2-1d5b-4343-81f9-ef44df15e4c7_ZIP_','2022-02-19 17:53:23','2022-02-14 19:20:09','','2022-02-19 18:53:23','SYNCED','473be61f-e0c7-4b5b-97bc-a62aab17df37',0,'2022-02-19 18:53:23','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.4.2\",\"modelMatrix\":\"0.443894,0.860251,-0.25085,0,-0.896079,0.426146,-0.124264,0,5.11492e-09,0.279941,0.960017,0,-5.21707,-37.3792,-16.1535,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'47ac428d-e0c9-491a-a37b-11c7e4ec7b7b','','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_fa1c1f6f-5c0d-45ca-8646-2a1ca68f51b4_SNAPO__SNAPS_','2022-05-16 17:51:11','2022-05-16 19:50:25','','2022-05-16 19:51:11','SYNCED','47ac428d-e0c9-491a-a37b-11c7e4ec7b7b',0,'2022-05-16 19:51:11','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(2,'47f5a352-41b9-4799-8e13-91efabce0db2','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a4b302c-278d-4e12-ace5-f095ba0bf856/session_6206892a-2e7e-4765-ac90-b49bfb465997/occlusion_7ec70f78-dc80-40c5-b293-570a59f034c4/scan_2ef30e56-ed6b-4233-94dd-08cbb9ef27df/3_w1_o2_maxillaire_scan_file_0.zip','ZIP','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_7ec70f78-dc80-40c5-b293-570a59f034c4_TOSC_2ef30e56-ed6b-4233-94dd-08cbb9ef27df_ZIP_','2022-09-06 09:17:41','2022-08-30 14:20:47','3_w1_o2_maxillaire_scan_file_0.zip','2022-09-06 11:17:41','SYNCED','47f5a352-41b9-4799-8e13-91efabce0db2',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.3.1.2.3\",\"modelMatrix\":\"0.897523,0.421058,-0.131002,0,-0.440967,0.857003,-0.266636,0,8.30491e-10,0.29708,0.954853,0,-25.9823,-2.19041,-18.2404,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'47fc8529-a72e-460b-8907-3892e470eebb','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/computedocclusion_35af1bf5-285a-4bb1-a6db-fe9897defe51/23_w1_o1_ml_occ_file_to1002.xyz','LIFI','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_35af1bf5-285a-4bb1-a6db-fe9897defe51_LIFIO_LIFI_','2022-05-25 10:46:45','2022-05-25 12:46:42','23_w1_o1_ml_occ_file_to1002.xyz','2022-05-25 12:46:45','SYNCED','47fc8529-a72e-460b-8907-3892e470eebb',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.23.1.1.1 Occlusion 4 Ligne de finition 2\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"Maxillaire\",\"name\":\"Ligne de finition 2\",\"title\":\"Ligne finition\",\"toothNumber\":1002}'),(1001,'48568b30-23dd-4d00-b4de-f54ce8d90d30','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_49bd090f-1a01-4a79-8202-62487b9af783/18_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_BOSC_49bd090f-1a01-4a79-8202-62487b9af783_ZIP_','2022-03-07 14:12:06','2022-03-07 15:12:03','18_w1_o1_mandibule_scan_file_0.zip','2022-03-07 15:12:06','SYNCED','48568b30-23dd-4d00-b4de-f54ce8d90d30',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.18.1.1.1\",\"modelMatrix\":\"-0.740045,-0.667159,0.0850427,0,0.672558,-0.734105,0.0935762,0,1.1198e-09,0.126447,0.991973,0,3.45916,-3.12895,-14.1428,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'487b79f0-f02a-454f-9a94-0c92ab61e123','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/scan_f4fff5f5-f728-44ae-ac48-f3e653594098/23_w1_o1_mordu_anterieur_scan_file_1.zip','ZIP','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_FRSC_f4fff5f5-f728-44ae-ac48-f3e653594098_ZIP_','2022-05-13 10:16:21','2022-05-13 12:16:12','23_w1_o1_mordu_anterieur_scan_file_1.zip','2022-05-13 12:16:21','SYNCED','fe88a495-d983-431f-8551-3e0e8c3fd862',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.23.1.1.1\",\"modelMatrix\":\"0.949837,0.187085,0.26758,0,-0.160399,0.982293,-0.0587988,0,-0.268901,0.0218887,0.961844,0,-3.13315,-5.64448,-28.5361,1\",\"title\":\"Mordu anterieur ZIP\"}'),(1001,'48a4df55-ee3e-4ecc-a344-338002adecd5','','ZIP','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_OCC_87edc123-163f-46ce-be5c-45f2ff80b857_BOPLY__ZIP_','2022-05-12 12:27:26','2022-05-12 14:26:51','','2022-05-12 14:27:26','SYNCED','48a4df55-ee3e-4ecc-a344-338002adecd5',0,'2022-05-12 14:27:26','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.18.1.1.3 Occlusion 3\",\"modelMatrix\":\"-0.721265,0.622319,-0.304132,0,-0.69266,-0.648019,0.316692,0,5.59464e-09,0.439079,0.898449,0,-8.58806,-18.2472,-17.8803,1\",\"referenceScanID\":\"1.18.1.1.3\",\"title\":\"Mandibule 1.18.1.1.3 Occlusion 3\"}'),(1001,'48afa4c7-21ba-4151-9a0b-2ab41c611fc4','','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_a16e268c-a9f5-4f0b-8346-6f1984df70bb_ZIP_','2022-02-04 11:29:38','2022-02-02 11:14:58','','2022-02-04 12:29:38','SYNCED','48afa4c7-21ba-4151-9a0b-2ab41c611fc4',0,'2022-02-04 12:29:38','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.2\",\"modelMatrix\":\"-0.961822,0.259307,-0.0875072,0,-0.273675,-0.911329,0.307542,0,5.65717e-9,0.319749,0.947502,0,33.7925,-1.80222,-15.4388,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'48ca5e89-974f-45f9-85f2-85c4644fb297','','ZIP','PATIENT_593972a6-d7d6-4802-b87d-38aab371f71e_ACT_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480_SESS_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3_OCC_4e1258a6-b789-451f-bfe8-8b395e1129d8_TOPLY__ZIP_','2022-01-19 15:25:10','2022-01-19 16:24:43','',NULL,'CREATED','48ca5e89-974f-45f9-85f2-85c4644fb297',0,'2022-01-19 16:25:10','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.3.1.1.1 Occlusion 3\",\"modelMatrix\":\"-0.8207,0.559215,-0.117173,0,-0.571359,-0.803257,0.168307,0,5.51916e-9,0.205077,0.978746,0,22.3383,-22.9288,-32.0145,1\",\"referenceScanID\":\"1.3.1.1.1\",\"title\":\"Maxillaire 1.3.1.1.1 Occlusion 3\"}'),(1001,'498f6778-802a-47f0-b4ab-22e9392831be','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_a1bc5849-382d-4646-be42-6c870a889494/24_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_FRSC_a1bc5849-382d-4646-be42-6c870a889494_SNAPS_','2022-05-24 14:57:26','2022-05-24 16:57:17','24_w1_o1_mordu_anterieur_snapshot_0.png','2022-05-24 16:57:26','SYNCED','498f6778-802a-47f0-b4ab-22e9392831be',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.24.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'4a1a5a35-8969-4721-8ec6-7e6b023b1fdf','','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_9440baee-a8bf-406c-bc0a-f5e9596f197b_TOPLY__ZIP_','2022-05-13 16:14:03','2022-05-13 18:13:11','','2022-05-13 18:14:03','SYNCED','4a1a5a35-8969-4721-8ec6-7e6b023b1fdf',0,'2022-05-13 18:14:03','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.2 Occlusion 3\",\"modelMatrix\":\"-0.80453,0.576793,-0.141569,0,-0.593912,-0.781339,0.191773,0,-6.05286e-09,0.238367,0.971175,0,0.910551,-5.61768,-25.9513,1\",\"referenceScanID\":\"1.24.1.1.2\",\"title\":\"Maxillaire 1.24.1.1.2 Occlusion 3\"}'),(1001,'4aea7a79-8371-4db5-8510-b9150d842cbe','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/986374de-c4d7-4d6f-bf0c-2dc7e3b859a9/session_c81670ed-4144-4347-b19e-8057d11b5f7c/occlusion_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be/scan_d969cedf-8de4-4e27-8d4d-f4a1e8eac60c/28_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_986374de-c4d7-4d6f-bf0c-2dc7e3b859a9_ACT_c81670ed-4144-4347-b19e-8057d11b5f7c_SESS_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be_TOSC_d969cedf-8de4-4e27-8d4d-f4a1e8eac60c_SNAPS_','2022-05-31 10:30:36','2022-05-31 12:30:23','28_w1_o1_maxillaire_snapshot_0.png','2022-05-31 12:30:36','SYNCED','4aea7a79-8371-4db5-8510-b9150d842cbe',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.28.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'4b05a0d4-2193-4350-856f-f38547af5710','','MATRX','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_ea89007b-3846-43ef-92f9-d5c7aa1a7dfa_TOMA__MATRX_','2022-05-25 08:56:32','2022-05-13 18:35:18','','2022-05-25 10:56:32','SYNCED','4b05a0d4-2193-4350-856f-f38547af5710',0,'2022-05-25 10:56:32','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.24.1.1.2 Occlusion 5\",\"referenceScanID\":\"1.24.1.1.2\",\"title\":\"Matrice Transfo. Maxillaire 1.24.1.1.2 Occlusion 5\"}'),(1001,'4b857ad9-9df3-4a2f-848a-64d97e7f4e49','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/scan_03839278-13f8-46e6-9581-ba11bc8bcb81/1_w1_o1_maxillaire_scan_file_6.zip','ZIP','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_TOSC_03839278-13f8-46e6-9581-ba11bc8bcb81_ZIP_','2022-01-19 13:03:29','2022-01-19 11:35:09','1_w1_o1_maxillaire_scan_file_6.zip','2022-01-19 14:03:29','SYNCED','96dd75bb-5035-460a-8afc-04f3755604b1',6,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.1.1.1.1\",\"modelMatrix\":\"-0.154277,0.952805,-0.261459,0,-0.988028,-0.148777,0.0408259,0,-2.59672e-9,0.264627,0.964351,0,-14.8611,-36.6101,-15.3158,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'4b90930b-b4dd-4eae-8b5f-8c8f04e970c6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/computedocclusion_6960b50e-6f78-4f83-9303-8c985410457c/4_w1_o4_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_OCC_6960b50e-6f78-4f83-9303-8c985410457c_TOMA__MATRX_','2022-05-31 14:55:58','2022-05-31 16:55:44','4_w1_o4_maxillaire_matrix_occ_file_0.m','2022-05-31 16:55:58','SYNCED','4b90930b-b4dd-4eae-8b5f-8c8f04e970c6',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.4.1.4.1 Occlusion 5\",\"referenceScanID\":\"1.4.1.4.1\",\"title\":\"Matrice Transfo. Maxillaire 1.4.1.4.1 Occlusion 5\"}'),(1001,'4bc8bbc2-a943-4af1-a2a9-b06f461fcfcc','','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_7d8decb1-23db-4824-940f-8d8822d88813_BOPLY__ZIP_','2022-02-08 08:48:59','2022-02-07 18:48:45','','2022-02-08 09:48:59','SYNCED','4bc8bbc2-a943-4af1-a2a9-b06f461fcfcc',0,'2022-02-08 09:48:59','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.17.1.1.1 Occlusion 3\",\"modelMatrix\":\"-0.980954,-0.188901,0.0452269,0,0.19424,-0.953992,0.228406,0,1.35057e-9,0.232841,0.972515,0,27.4349,19.1019,-20.1379,1\",\"referenceScanID\":\"1.17.1.1.1\",\"title\":\"Mandibule 1.17.1.1.1 Occlusion 3\"}'),(1001,'4bf52f65-04f9-420f-bc0d-457f239f1bc0','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/computedocclusion_2de3d2bb-d512-4514-8bed-a879b73a6028/22_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_OCC_2de3d2bb-d512-4514-8bed-a879b73a6028_BOMA__MATRX_','2022-04-21 11:29:39','2022-04-21 13:29:16','22_w1_o1_mandibule_matrix_occ_file_0.m','2022-04-21 13:29:39','SYNCED','4bf52f65-04f9-420f-bc0d-457f239f1bc0',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.22.1.1.1 Occlusion 7\",\"referenceScanID\":\"1.22.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.22.1.1.1 Occlusion 7\"}'),(1001,'4bf7dce1-a998-4b64-8333-9a01e60cea8a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/de078619-3946-4adb-a799-1c260e16face/session_24d0aeb5-3058-4070-aeea-97c289e41e3c/occlusion_ea6da896-1504-41fc-890c-7c48575e9e40/scan_aa24138a-68e8-4bc3-9a5d-d617f0fe496b/2_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_de078619-3946-4adb-a799-1c260e16face_ACT_24d0aeb5-3058-4070-aeea-97c289e41e3c_SESS_ea6da896-1504-41fc-890c-7c48575e9e40_TOSC_aa24138a-68e8-4bc3-9a5d-d617f0fe496b_ZIP_','2022-01-19 14:06:34','2022-01-19 15:06:17','2_w1_o1_maxillaire_scan_file_1.zip','2022-01-19 15:06:34','SYNCED','80d822aa-8c38-4390-bdc1-0b044f167d73',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.2.1.1.1\",\"modelMatrix\":\"0.999524,0.0288188,-0.0110138,0,-0.0308516,0.933663,-0.356821,0,-3.83807e-10,0.356991,0.934108,0,-21.932,-35.0893,-21.8585,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'4c4f5567-afa0-4bb0-9782-09482e7b807c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a47006e-5c4a-4fab-835f-67e3301b2acf/session_d0298050-98d9-4076-b3bd-110404d60135/occlusion_c5f98876-f420-4912-bd39-cfffac649936/scan_41295122-614f-4e97-b820-f8a9940950f4/4_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_6a47006e-5c4a-4fab-835f-67e3301b2acf_ACT_d0298050-98d9-4076-b3bd-110404d60135_SESS_c5f98876-f420-4912-bd39-cfffac649936_TOSC_41295122-614f-4e97-b820-f8a9940950f4_ZIP_','2022-09-06 09:20:25','2022-09-06 11:20:25','4_w1_o1_maxillaire_scan_file_0.zip',NULL,'CREATED','4c4f5567-afa0-4bb0-9782-09482e7b807c',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.4.1.1.1\",\"modelMatrix\":\"0.288216,-0.89868,0.330614,0,0.957565,0.270492,-0.0995111,0,-6.83428e-09,0.345265,0.938505,0,-3.52566,-41.0641,-17.0348,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'4c85fe3b-92ce-4c9f-bba8-70bca998d5fc','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7f47fd88-9ea0-4c08-9193-a54d4f158c7c/session_7873a396-419c-4215-83c7-fec9f2742ccf/occlusion_2e287bb0-e19a-414a-9177-23b335d286d9/scan_05d5d943-3268-4239-ac7d-5efbc2d2ab9b/16_w1_o2_maxillaire_snapshot_0.png','SNAPS','PATIENT_7f47fd88-9ea0-4c08-9193-a54d4f158c7c_ACT_7873a396-419c-4215-83c7-fec9f2742ccf_SESS_2e287bb0-e19a-414a-9177-23b335d286d9_TOSC_05d5d943-3268-4239-ac7d-5efbc2d2ab9b_SNAPS_','2022-06-03 08:48:49','2022-06-03 10:48:39','16_w1_o2_maxillaire_snapshot_0.png','2022-06-03 10:48:49','SYNCED','4c85fe3b-92ce-4c9f-bba8-70bca998d5fc',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.16.1.2.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'4d069ae2-84d8-4d50-a251-f43a7ea92bf9','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/e922efb9-8c03-445b-8a0f-449e3c43bdca/session_a2369349-1629-40ad-8784-d271bc3fbade/occlusion_292cc1aa-8b12-463b-87a1-7d9731cf886b/scan_d1ea0460-f48a-4dc1-a0ae-c13f265abac4/21_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_e922efb9-8c03-445b-8a0f-449e3c43bdca_ACT_a2369349-1629-40ad-8784-d271bc3fbade_SESS_292cc1aa-8b12-463b-87a1-7d9731cf886b_RISC_d1ea0460-f48a-4dc1-a0ae-c13f265abac4_ZIP_','2022-04-21 08:52:46','2022-04-21 10:52:38','21_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-04-21 10:52:46','SYNCED','4d069ae2-84d8-4d50-a251-f43a7ea92bf9',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.21.1.1.2\",\"modelMatrix\":\"0.994753,-0.0885331,0.0483952,0,0.0823669,0.990498,0.108801,0,-0.0607708,-0.105244,0.99289,0,-13.9918,7.01422,-18.0194,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'4d2887e9-9f2a-46be-8a39-4a7b9dc42bc6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_f9c2783a-c405-481c-a97e-47bb9db0d0d2/17_w1_o1_mordu_posterieur_droit_scan_file_1.zip','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_RISC_f9c2783a-c405-481c-a97e-47bb9db0d0d2_ZIP_','2022-02-07 11:47:25','2022-02-07 12:44:04','17_w1_o1_mordu_posterieur_droit_scan_file_1.zip','2022-02-07 12:47:25','SYNCED','ee6ba447-6aa9-4446-ac83-1541e7fe80b7',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.17.1.1.1\",\"modelMatrix\":\"0.958858,-0.278951,0.0584984,0,0.279373,0.96007,0.00245979,0,-0.0507895,0.023133,0.998345,0,-18.2614,12.5541,-16.0474,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'4d803815-9470-468e-afb5-8b1d9b629641','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/scan_1a0b9502-8df2-41a2-89eb-2def508b7462/22_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_RISC_1a0b9502-8df2-41a2-89eb-2def508b7462_SNAPS_','2022-04-21 17:38:20','2022-04-21 19:38:19','22_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-04-21 19:38:20','SYNCED','4d803815-9470-468e-afb5-8b1d9b629641',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.22.1.1.6\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'4d931155-9fb2-4358-a1c7-465f58401480','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_731ce686-8c03-4019-bc8e-040c31652c88/4_w1_o2_mandibule_snapshot_0.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_BOSC_731ce686-8c03-4019-bc8e-040c31652c88_SNAPS_','2022-03-08 12:00:04','2022-03-08 12:59:57','4_w1_o2_mandibule_snapshot_0.png','2022-03-08 13:00:04','SYNCED','4d931155-9fb2-4358-a1c7-465f58401480',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.2.4\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'4dfde161-5e5f-46cd-b413-649e565d2640','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_b28164eb-0070-4968-83be-bfabe1a0c839/13_w1_o1_mandibule_scan_file_4.zip','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_b28164eb-0070-4968-83be-bfabe1a0c839_ZIP_','2022-02-04 17:57:00','2022-02-04 17:03:59','13_w1_o1_mandibule_scan_file_4.zip','2022-02-04 18:57:00','SYNCED','d8a3bf39-16d1-435f-bafa-6c625f77d811',4,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.5\",\"modelMatrix\":\"-0.980986,-0.182732,0.0653907,0,0.19408,-0.923628,0.33052,0,1.2429e-9,0.336927,0.941531,0,23.7056,9.64329,-24.5584,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'4e0a0002-d93c-4b33-ba51-9cc84cb7c62e','','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_ea89007b-3846-43ef-92f9-d5c7aa1a7dfa_SNAPO__SNAPS_','2022-05-25 08:56:33','2022-05-13 18:35:18','','2022-05-25 10:56:33','SYNCED','4e0a0002-d93c-4b33-ba51-9cc84cb7c62e',0,'2022-05-25 10:56:33','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'4e0a4109-35b7-4c91-b28f-2ae7a227dbb7','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/57c4096f-98dd-49c8-bea5-a5b109ad3fd0/session_4f62e395-5623-4d5b-869c-1b2fc4d22b00/occlusion_1ac20dc7-b36b-4786-a05f-37091554dc5c/computedocclusion_70f4220e-2a6b-4575-bd0e-09c14a13d758/31_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_57c4096f-98dd-49c8-bea5-a5b109ad3fd0_ACT_4f62e395-5623-4d5b-869c-1b2fc4d22b00_SESS_1ac20dc7-b36b-4786-a05f-37091554dc5c_OCC_70f4220e-2a6b-4575-bd0e-09c14a13d758_TOMA__MATRX_','2022-06-16 11:04:12','2022-06-16 13:03:55','31_w1_o1_maxillaire_matrix_occ_file_0.m','2022-06-16 13:04:12','SYNCED','4e0a4109-35b7-4c91-b28f-2ae7a227dbb7',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.31.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.31.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.31.1.1.1 Occlusion 1\"}'),(1001,'4e0b586d-010c-4f46-ba34-26a139bf9937','','ZIP','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_OCC_d58ce31f-4b72-44ad-b0e0-3d5d7d789322_BOPLY__ZIP_','2022-01-19 11:15:36','2022-01-19 12:06:18','',NULL,'CREATED','4e0b586d-010c-4f46-ba34-26a139bf9937',0,'2022-01-19 12:15:36','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.1.1.1.1 Occlusion 1\",\"modelMatrix\":\"-0.89361,0.44322,-0.0708281,0,-0.448843,-0.882414,0.141013,0,3.36694e-10,0.157801,0.987471,0,37.1181,-2.30066,-14.9109,1\",\"referenceScanID\":\"1.1.1.1.1\",\"title\":\"Mandibule 1.1.1.1.1 Occlusion 1\"}'),(1001,'4ef4a778-c652-4a4d-b0ab-26259314c303','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_6c9ae07a-23c3-4355-87ff-b57ef558a4ea/17_w1_o1_mordu_posterieur_gauche_scan_file_1.zip','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_LESC_6c9ae07a-23c3-4355-87ff-b57ef558a4ea_ZIP_','2022-02-11 16:09:43','2022-02-11 17:09:32','17_w1_o1_mordu_posterieur_gauche_scan_file_1.zip','2022-02-11 17:09:43','SYNCED','46be4566-2ed9-474b-bbd1-c7748e98f460',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.17.1.1.3\",\"modelMatrix\":\"-0.994733,0.0873893,0.0549181,0,-0.0832057,-0.992685,0.0917926,0,0.0599197,0.0833779,0.994272,0,-5.89408,0.0239513,-18.3172,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'4f401606-db4e-4efa-be4f-fb461f5aedc5','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_f62659c6-4f30-430c-95e4-d14e40327192/13_w1_o1_mordu_anterieur_scan_file_0.zip','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_FRSC_f62659c6-4f30-430c-95e4-d14e40327192_ZIP_','2022-02-04 17:54:37','2022-02-04 17:27:12','13_w1_o1_mordu_anterieur_scan_file_0.zip','2022-02-04 18:54:37','SYNCED','4f401606-db4e-4efa-be4f-fb461f5aedc5',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.13.1.1.2\",\"modelMatrix\":\"0.953323,-0.314537,0.0701576,0,0.291713,0.949017,0.129459,0,-0.0833426,-0.0546414,0.990463,0,-9.41378,2.15841,-20.3131,1\",\"title\":\"Mordu anterieur ZIP\"}'),(1001,'4f77dab6-d9a8-464f-a28e-e9fc7afdbd4f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/32710234-804f-46f5-899d-eed636f8a906/session_64c1427a-b91d-4675-94df-f36bd40e9b0f/occlusion_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a/scan_3954e24e-9220-452b-a8fa-b1fbde6ebcad/33_w2_o1_mandibule_snapshot_2.png','SNAPS','PATIENT_32710234-804f-46f5-899d-eed636f8a906_ACT_64c1427a-b91d-4675-94df-f36bd40e9b0f_SESS_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a_BOSC_3954e24e-9220-452b-a8fa-b1fbde6ebcad_SNAPS_','2022-06-28 09:03:26','2022-06-28 11:03:14','33_w2_o1_mandibule_snapshot_2.png','2022-06-28 11:03:26','SYNCED','fe809790-75be-4a2e-9d94-7358f686eecf',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.33.2.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'502162a6-a0d3-4c4e-9cf3-8d014a530435','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/computedocclusion_b903dd27-411a-4a7c-b357-1cc9a414dbdd/17_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_b903dd27-411a-4a7c-b357-1cc9a414dbdd_TOMA__MATRX_','2022-02-12 16:54:33','2022-02-12 17:53:18','17_w1_o1_maxillaire_matrix_occ_file_0.m','2022-02-12 17:54:33','SYNCED','502162a6-a0d3-4c4e-9cf3-8d014a530435',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.17.1.1.1 Occlusion 7\",\"referenceScanID\":\"1.17.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.17.1.1.1 Occlusion 7\"}'),(1001,'5065e06b-2a6d-4eed-ad88-93c9743302e9','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_04d6e3f1-19ce-4851-a9d0-40419cea7542/scan_fef6f617-40e8-4052-8a2d-9af9e39ab22d/19_w1_o2_mandibule_scan_file_2.zip','ZIP','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_04d6e3f1-19ce-4851-a9d0-40419cea7542_BOSC_fef6f617-40e8-4052-8a2d-9af9e39ab22d_ZIP_','2022-04-15 14:06:59','2022-04-15 16:06:50','19_w1_o2_mandibule_scan_file_2.zip','2022-04-15 16:06:59','SYNCED','6fc1ad7b-72f9-4540-9e11-3ded800f23dc',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.2.2\",\"modelMatrix\":\"0.922398,0.363551,-0.130433,0,-0.386241,0.868211,-0.311491,0,8.299e-09,0.337698,0.941255,0,3.01727,1.11171,-28.7776,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'510471aa-b2e2-4205-bdc2-67a8d1957d49','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/452a5200-3e06-4b74-8949-6abc7f2dda8a/session_3e95d626-668f-45f7-98ad-be2cf9d7b90b/order_de50ab2d-d622-4973-a0f1-fd569575b61a/26_w1_couronne_prost_file_510471aa-b2e2-4205-bdc2-67a8d1957d49_0.pdf','PDF','PATIENT_452a5200-3e06-4b74-8949-6abc7f2dda8a_ACT_3e95d626-668f-45f7-98ad-be2cf9d7b90b_PROST_de50ab2d-d622-4973-a0f1-fd569575b61a_PDF_','2022-05-25 11:20:17','2022-05-25 13:20:15','26_w1_couronne_prost_file_510471aa-b2e2-4205-bdc2-67a8d1957d49_0.pdf','2022-05-25 13:20:17','SYNCED','510471aa-b2e2-4205-bdc2-67a8d1957d49',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.26.1.1 COURONNE\",\"title\":\"Couronne PDF\"}'),(1001,'51860c04-fdfe-4bde-923f-956ac5bcfcbd','','ZIP','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_LESC_890154d7-23d4-4fb6-a767-967ce5a423f7_ZIP_','2022-09-09 16:30:34','2022-09-09 18:19:25','','2022-09-09 18:30:34','SYNCED','51860c04-fdfe-4bde-923f-956ac5bcfcbd',0,'2022-09-09 18:30:34','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.39.1.1.2\",\"modelMatrix\":\"-0.978812,0.196139,0.00396484,0,-0.202913,-0.944691,0.24922,0,0.0353639,0.263853,0.96888,0,-6.42769,0.929324,-20.8752,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'51a9191a-3d52-4dbe-a549-0616a8adb43b','','MATRX','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_OCC_e9a397c8-e329-4471-985b-0eb40ed458b0_TOMA__MATRX_','2022-02-04 15:01:39','2022-02-04 14:50:30','','2022-02-04 16:01:39','SYNCED','51a9191a-3d52-4dbe-a549-0616a8adb43b',0,'2022-02-04 16:01:39','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.12.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.12.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.12.1.1.1 Occlusion 1\"}'),(2,'526e9fb6-b6a0-4f25-9d0a-b3aab61ddd2e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a4b302c-278d-4e12-ace5-f095ba0bf856/session_6206892a-2e7e-4765-ac90-b49bfb465997/occlusion_3c30231c-7cd7-4431-985b-2eaf7f6925ae/scan_232c4a5c-d521-4972-9735-eb9d27cffedc/3_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_232c4a5c-d521-4972-9735-eb9d27cffedc_ZIP_','2022-09-06 09:20:42','2022-08-30 10:43:19','3_w1_o1_maxillaire_scan_file_0.zip','2022-09-06 11:20:42','SYNCED','526e9fb6-b6a0-4f25-9d0a-b3aab61ddd2e',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.3.1.1.3\",\"modelMatrix\":\"0.807997,0.577429,-0.117121,0,-0.589187,0.791872,-0.160616,0,8.33841e-10,0.198783,0.980043,0,-28.159,-4.83121,-15.9851,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'52c30d44-dd5d-4b6f-8fc9-709139c04709','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/order_3b627fcf-9786-459e-a2ac-911498e37f8e/23_w1_couronne_prost_file_52c30d44-dd5d-4b6f-8fc9-709139c04709_0.pdf','PDF','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_PROST_3b627fcf-9786-459e-a2ac-911498e37f8e_PDF_','2022-05-25 14:26:12','2022-05-25 16:26:11','23_w1_couronne_prost_file_52c30d44-dd5d-4b6f-8fc9-709139c04709_0.pdf','2022-05-25 16:26:12','SYNCED','52c30d44-dd5d-4b6f-8fc9-709139c04709',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.23.1.4 COURONNE\",\"title\":\"Couronne PDF\"}'),(1001,'53730f49-b109-4397-a05a-fa05be3beb52','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/69640c87-271c-4a44-a6fa-67b01654cc27/session_5f9199b0-eb37-4ed3-8d1a-6c38505d4913/occlusion_991beec3-fe9e-4c98-a3d4-c98e4a4c2471/computedocclusion_c7bccd1e-370e-4347-8296-1bcd4c30b631/39_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_OCC_c7bccd1e-370e-4347-8296-1bcd4c30b631_BOMA__MATRX_','2022-09-10 09:46:06','2022-09-10 11:45:43','39_w1_o1_mandibule_matrix_occ_file_0.m','2022-09-10 11:46:06','SYNCED','53730f49-b109-4397-a05a-fa05be3beb52',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.39.1.1.1 Occlusion 10\",\"referenceScanID\":\"1.39.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.39.1.1.1 Occlusion 10\"}'),(1001,'546a8041-4f76-419c-89fd-3181695f2b96','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/57c4096f-98dd-49c8-bea5-a5b109ad3fd0/session_4f62e395-5623-4d5b-869c-1b2fc4d22b00/occlusion_1ac20dc7-b36b-4786-a05f-37091554dc5c/scan_7d899967-a5be-43f7-acbd-42d4237792d4/31_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_57c4096f-98dd-49c8-bea5-a5b109ad3fd0_ACT_4f62e395-5623-4d5b-869c-1b2fc4d22b00_SESS_1ac20dc7-b36b-4786-a05f-37091554dc5c_TOSC_7d899967-a5be-43f7-acbd-42d4237792d4_SNAPS_','2022-06-16 10:52:48','2022-06-16 12:52:38','31_w1_o1_maxillaire_snapshot_0.png','2022-06-16 12:52:48','SYNCED','546a8041-4f76-419c-89fd-3181695f2b96',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.31.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'5486d4bc-5b14-4a94-ade5-1720c829818d','','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_BOSC_a1a9cef4-72fe-4dbe-928c-3831f98ecfbc_SNAPS_','2022-02-19 17:53:23','2022-02-18 17:01:56','','2022-02-19 18:53:23','SYNCED','fb2afa86-ebd5-4360-a84e-10047e56c6e5',2,'2022-02-19 18:53:23','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.4.4\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'54af140d-b148-43e6-84b4-455ce19fbd59','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a0c21836-ba79-4f15-9e35-02ef8211a9e5/session_0aac522d-3c38-465a-a1e0-014166c140ac/occlusion_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042/scan_dda4ec6d-010a-4593-be9f-97cb59747424/7_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_a0c21836-ba79-4f15-9e35-02ef8211a9e5_ACT_0aac522d-3c38-465a-a1e0-014166c140ac_SESS_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042_BOSC_dda4ec6d-010a-4593-be9f-97cb59747424_ZIP_','2022-01-21 11:50:26','2022-01-21 12:49:06','7_w1_o1_mandibule_scan_file_0.zip','2022-01-21 12:50:26','SYNCED','54af140d-b148-43e6-84b4-455ce19fbd59',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.7.1.1.1\",\"modelMatrix\":\"-0.95397,-0.276542,0.116045,0,0.299903,-0.879659,0.369132,0,-4.3083e-9,0.386943,0.922104,0,13.6932,12.2039,-15.7846,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'54dec040-bf2a-4f49-aa21-80bee5829b26','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_909d9ecd-46b3-4692-868e-f6405507ecd1/24_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_TOSC_909d9ecd-46b3-4692-868e-f6405507ecd1_ZIP_','2022-05-13 14:42:34','2022-05-13 16:42:23','24_w1_o1_maxillaire_scan_file_1.zip','2022-05-13 16:42:34','SYNCED','3857c31f-4878-48ad-9ad9-5da851292116',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.2\",\"modelMatrix\":\"-0.80453,0.576793,-0.141569,0,-0.593912,-0.781339,0.191773,0,-6.05286e-09,0.238367,0.971175,0,0.910551,-5.61768,-25.9513,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'5522b546-fb91-4268-9a1a-6471a732b617','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/order_9e0e25bb-7234-43a4-80d0-a7d7b71aafa4/19_w1_guide_prost_file_5522b546-fb91-4268-9a1a-6471a732b617_0.pdf','PDF','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_PROST_9e0e25bb-7234-43a4-80d0-a7d7b71aafa4_PDF_','2022-03-09 17:00:44','2022-03-09 18:00:42','19_w1_guide_prost_file_5522b546-fb91-4268-9a1a-6471a732b617_0.pdf','2022-03-09 18:00:44','SYNCED','5522b546-fb91-4268-9a1a-6471a732b617',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.19.1.2 GUIDE\",\"title\":\"Guide PDF\"}'),(1001,'55331df2-aca7-4a34-acaf-8e97458bf54f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/fa7fa96b-f393-4b9a-8198-144702462cfa/session_4bed076c-8541-4a2f-800a-5aeb4cb49de5/occlusion_16b82fca-4b65-4866-af87-1f6dbb42f5dc/scan_378056ed-259b-4069-96b1-1e6050e30f87/35_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_fa7fa96b-f393-4b9a-8198-144702462cfa_ACT_4bed076c-8541-4a2f-800a-5aeb4cb49de5_SESS_16b82fca-4b65-4866-af87-1f6dbb42f5dc_BOSC_378056ed-259b-4069-96b1-1e6050e30f87_ZIP_','2022-06-28 14:57:35','2022-06-28 16:57:25','35_w1_o1_mandibule_scan_file_0.zip','2022-06-28 16:57:35','SYNCED','55331df2-aca7-4a34-acaf-8e97458bf54f',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.35.1.1.1\",\"modelMatrix\":\"0.0975586,0.955587,-0.278094,0,-0.99523,0.0936725,-0.0272605,0,1.35871e-09,0.279427,0.960167,0,-3.44734,-12.1676,-17.3219,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'55725ce5-4c86-45bc-a52a-0f716dd5a486','','MATRX','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_7d8decb1-23db-4824-940f-8d8822d88813_BOMA__MATRX_','2022-02-08 08:48:59','2022-02-07 18:48:45','','2022-02-08 09:48:59','SYNCED','55725ce5-4c86-45bc-a52a-0f716dd5a486',0,'2022-02-08 09:48:59','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.17.1.1.1 Occlusion 3\",\"referenceScanID\":\"1.17.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.17.1.1.1 Occlusion 3\"}'),(1001,'55f52934-bbd7-4e86-bd7e-fc42a74d3419','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f4fc00ec-4af8-4a15-b427-f1c5aabf6260/session_498ae60a-23f0-44fc-9730-be499bfc4b46/occlusion_8f3d6c73-3468-45a5-85c7-93bba47ec9f7/computedocclusion_9c318e86-fa90-4cd9-8319-2503cde2b455/30_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_f4fc00ec-4af8-4a15-b427-f1c5aabf6260_ACT_498ae60a-23f0-44fc-9730-be499bfc4b46_SESS_8f3d6c73-3468-45a5-85c7-93bba47ec9f7_OCC_9c318e86-fa90-4cd9-8319-2503cde2b455_BOPLY__ZIP_','2022-06-14 13:30:04','2022-06-14 15:29:56','30_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-06-14 15:30:04','SYNCED','55f52934-bbd7-4e86-bd7e-fc42a74d3419',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.30.1.1.1 Occlusion 1\",\"modelMatrix\":\"-0.121583,0.970699,-0.207271,0,-0.992581,-0.118902,0.0253889,0,1.0676e-09,0.20882,0.977954,0,3.47051,-3.06677,-21.1986,1\",\"referenceScanID\":\"1.30.1.1.1\",\"title\":\"Mandibule 1.30.1.1.1 Occlusion 1\"}'),(1001,'565d69de-f728-4686-a5e9-490a8f086cd5','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/occlusion_a2220645-c79d-4dda-b6cc-772384a4106b/computedocclusion_cf412dab-1d83-4db0-ae1b-d2724d5be97d/38_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_OCC_cf412dab-1d83-4db0-ae1b-d2724d5be97d_SNAPO__SNAPS_','2022-07-12 11:04:31','2022-07-12 13:04:14','38_w1_o1_snapshot_occ_file_0.png','2022-07-12 13:04:31','SYNCED','565d69de-f728-4686-a5e9-490a8f086cd5',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'566be85e-38a3-4083-ba96-401708153e00','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_9418414d-48f1-4a41-baa8-98bf650edaa3/4_w1_o2_mandibule_scan_file_0.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_BOSC_9418414d-48f1-4a41-baa8-98bf650edaa3_ZIP_','2022-02-15 12:19:26','2022-02-15 13:19:19','4_w1_o2_mandibule_scan_file_0.zip','2022-02-15 13:19:26','SYNCED','566be85e-38a3-4083-ba96-401708153e00',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.2.1\",\"modelMatrix\":\"0.979683,0.193592,-0.0523778,0,-0.200552,0.945681,-0.255862,0,-3.35472e-09,0.261168,0.965293,0,-13.8508,-18.7644,-17.2987,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'573423ef-791f-4a2f-aa1f-bb3662f66baa','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/computedocclusion_e9bfc750-6943-42bf-8c0b-b7e1dc1803c5/1_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_OCC_e9bfc750-6943-42bf-8c0b-b7e1dc1803c5_BOMA__MATRX_','2022-01-19 13:04:53','2022-01-19 12:12:14','1_w1_o1_mandibule_matrix_occ_file_0.m','2022-01-19 14:04:53','SYNCED','573423ef-791f-4a2f-aa1f-bb3662f66baa',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.1.1.1.1 Occlusion 2\",\"referenceScanID\":\"1.1.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.1.1.1.1 Occlusion 2\"}'),(1001,'579ff165-11f6-4035-96ba-aa4a2d120cc8','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_f4b07389-264e-4772-afc3-29b2187ced21/18_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_LESC_f4b07389-264e-4772-afc3-29b2187ced21_SNAPS_','2022-03-07 14:43:34','2022-03-07 15:43:32','18_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-03-07 15:43:34','SYNCED','579ff165-11f6-4035-96ba-aa4a2d120cc8',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.18.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'57ada530-ed64-430e-a2d9-f1e6307bf947','','MATRX','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_OCC_4aa37ef9-cd2d-4cfa-9436-a62cc782a27a_BOMA__MATRX_','2022-02-04 15:01:39','2022-02-04 14:55:02','','2022-02-04 16:01:39','SYNCED','57ada530-ed64-430e-a2d9-f1e6307bf947',0,'2022-02-04 16:01:39','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.12.1.1.5 Occlusion 1\",\"referenceScanID\":\"1.12.1.1.5\",\"title\":\"Matrice Transfo. Mandibule 1.12.1.1.5 Occlusion 1\"}'),(1001,'57d16105-76ab-4818-8b3b-97cd680f701e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/order_37a778ee-af03-4993-a8f5-8ce26e516db0/13_w1_amovible_prost_file_57d16105-76ab-4818-8b3b-97cd680f701e_0.pdf','PDF','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_PROST_37a778ee-af03-4993-a8f5-8ce26e516db0_PDF_','2022-02-04 18:28:43','2022-02-04 19:28:42','13_w1_amovible_prost_file_57d16105-76ab-4818-8b3b-97cd680f701e_0.pdf','2022-02-04 19:28:43','SYNCED','57d16105-76ab-4818-8b3b-97cd680f701e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.13.1.1 AMOVIBLE\",\"title\":\"Amovible PDF\"}'),(1001,'57da302c-26b5-42e6-bcf0-6a9456ce4145','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_e8550560-cfe0-40a1-bfb3-992d471fbcb7/17_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_BOSC_e8550560-cfe0-40a1-bfb3-992d471fbcb7_SNAPS_','2022-02-07 11:47:26','2022-02-07 12:38:30','17_w1_o1_mandibule_snapshot_1.png','2022-02-07 12:47:26','SYNCED','8c69c578-53d3-4a85-8b22-b7992c482bdd',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.17.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'5810288a-4f85-4cf7-a638-3fb6d3fdf0fd','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/207d6dbc-c19b-4726-a9b3-16235ae554cc/session_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35/occlusion_dc5762a3-c453-4166-8c86-82d23ac9f8a6/scan_5139ec2e-4608-4b67-b0d1-bc4dc3498038/27_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_207d6dbc-c19b-4726-a9b3-16235ae554cc_ACT_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35_SESS_dc5762a3-c453-4166-8c86-82d23ac9f8a6_BOSC_5139ec2e-4608-4b67-b0d1-bc4dc3498038_SNAPS_','2022-05-30 11:06:27','2022-05-30 13:06:19','27_w1_o1_mandibule_snapshot_1.png','2022-05-30 13:06:27','SYNCED','0f6e5816-9908-4996-af79-cabf91fcb4f3',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.27.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'58c340c6-87b7-4d1d-a161-277017ac45d3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_d454a556-70ce-4c4c-8e13-114edfa03642/17_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_BOSC_d454a556-70ce-4c4c-8e13-114edfa03642_SNAPS_','2022-02-11 16:04:48','2022-02-11 17:04:32','17_w1_o1_mandibule_snapshot_0.png','2022-02-11 17:04:48','SYNCED','58c340c6-87b7-4d1d-a161-277017ac45d3',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.17.1.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'595feda8-cae8-4964-818c-868a61418f19','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/57c4096f-98dd-49c8-bea5-a5b109ad3fd0/session_4f62e395-5623-4d5b-869c-1b2fc4d22b00/order_f2d38d5b-67ff-45ef-8aa5-61656f0530e5/31_w1_inlay_onlay_prost_file_595feda8-cae8-4964-818c-868a61418f19_0.pdf','PDF','PATIENT_57c4096f-98dd-49c8-bea5-a5b109ad3fd0_ACT_4f62e395-5623-4d5b-869c-1b2fc4d22b00_PROST_f2d38d5b-67ff-45ef-8aa5-61656f0530e5_PDF_','2022-06-16 16:10:14','2022-06-16 18:10:13','31_w1_inlay_onlay_prost_file_595feda8-cae8-4964-818c-868a61418f19_0.pdf','2022-06-16 18:10:14','SYNCED','595feda8-cae8-4964-818c-868a61418f19',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.31.1.1 AmelieP/0355/Dent 15/ONLAY\",\"title\":\"Inlay/Onlay PDF\"}'),(1001,'5a015b83-2cc8-4b4a-bdff-8297760d8847','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/order_5b6bef74-4ccc-47db-a97c-d187ff9acae0/23_w1_couronne_prost_file_5a015b83-2cc8-4b4a-bdff-8297760d8847_0.pdf','PDF','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_PROST_5b6bef74-4ccc-47db-a97c-d187ff9acae0_PDF_','2022-05-25 10:43:06','2022-05-25 12:43:05','23_w1_couronne_prost_file_5a015b83-2cc8-4b4a-bdff-8297760d8847_0.pdf','2022-05-25 12:43:06','SYNCED','5a015b83-2cc8-4b4a-bdff-8297760d8847',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.23.1.2 COURONNE\",\"title\":\"Couronne PDF\"}'),(1001,'5a1c3667-dbf3-4de6-af8e-149a263ba435','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_04d6e3f1-19ce-4851-a9d0-40419cea7542/scan_fef6f617-40e8-4052-8a2d-9af9e39ab22d/19_w1_o2_mandibule_snapshot_0.png','SNAPS','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_04d6e3f1-19ce-4851-a9d0-40419cea7542_BOSC_fef6f617-40e8-4052-8a2d-9af9e39ab22d_SNAPS_','2022-04-15 13:53:56','2022-04-15 15:53:44','19_w1_o2_mandibule_snapshot_0.png','2022-04-15 15:53:56','SYNCED','5a1c3667-dbf3-4de6-af8e-149a263ba435',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.2.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'5a1f9ce5-306f-497e-8975-eefaafa1022b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/32710234-804f-46f5-899d-eed636f8a906/session_64c1427a-b91d-4675-94df-f36bd40e9b0f/occlusion_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a/scan_3954e24e-9220-452b-a8fa-b1fbde6ebcad/33_w2_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_32710234-804f-46f5-899d-eed636f8a906_ACT_64c1427a-b91d-4675-94df-f36bd40e9b0f_SESS_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a_BOSC_3954e24e-9220-452b-a8fa-b1fbde6ebcad_SNAPS_','2022-06-28 09:01:34','2022-06-28 11:01:22','33_w2_o1_mandibule_snapshot_1.png','2022-06-28 11:01:34','SYNCED','fe809790-75be-4a2e-9d94-7358f686eecf',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.33.2.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'5a5e59c6-da45-4e2d-991c-fb6f039cb431','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/scan_36a05dde-4390-4db1-9df5-ea42cd16ed7d/1_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_FRSC_36a05dde-4390-4db1-9df5-ea42cd16ed7d_SNAPS_','2022-01-19 12:59:17','2022-01-19 12:11:00','1_w1_o1_mordu_anterieur_snapshot_0.png','2022-01-19 13:59:17','SYNCED','5a5e59c6-da45-4e2d-991c-fb6f039cb431',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.1.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'5adfa2d7-f3c9-4609-9d90-3a85c0853b42','','MATRX','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_OCC_87edc123-163f-46ce-be5c-45f2ff80b857_BOMA__MATRX_','2022-05-12 12:27:26','2022-05-12 14:26:51','','2022-05-12 14:27:26','SYNCED','5adfa2d7-f3c9-4609-9d90-3a85c0853b42',0,'2022-05-12 14:27:26','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.18.1.1.3 Occlusion 3\",\"referenceScanID\":\"1.18.1.1.3\",\"title\":\"Matrice Transfo. Mandibule 1.18.1.1.3 Occlusion 3\"}'),(1001,'5be397c6-6389-4466-89bf-df569bbce2b9','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_04d6e3f1-19ce-4851-a9d0-40419cea7542/scan_9e43db2d-10a9-414e-ac07-6b7642412ce5/19_w1_o2_maxillaire_snapshot_1.png','SNAPS','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_04d6e3f1-19ce-4851-a9d0-40419cea7542_TOSC_9e43db2d-10a9-414e-ac07-6b7642412ce5_SNAPS_','2022-04-15 11:41:27','2022-04-01 18:18:31','19_w1_o2_maxillaire_snapshot_1.png','2022-04-15 13:41:27','SYNCED','43faec45-d44e-4a5b-980c-14c82d42fdd3',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.19.1.2.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'5c552dd5-711b-49d9-8d67-2470cfd3aa77','','MATRX','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_OCC_764b8e22-8600-49e3-8d7c-d619725096ee_BOMA__MATRX_','2022-02-04 18:20:41','2022-02-04 19:19:48','',NULL,'CREATED','5c552dd5-711b-49d9-8d67-2470cfd3aa77',0,'2022-02-04 19:20:41','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.13.1.1.5 Occlusion 2\",\"referenceScanID\":\"1.13.1.1.5\",\"title\":\"Matrice Transfo. Mandibule 1.13.1.1.5 Occlusion 2\"}'),(1001,'5d3dcc4f-6d2d-44ab-815b-4de5076cb320','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_0e451099-a0ad-463c-9441-7ded1297fa16/24_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_TOSC_0e451099-a0ad-463c-9441-7ded1297fa16_ZIP_','2022-05-24 14:34:54','2022-05-24 16:34:40','24_w1_o1_maxillaire_scan_file_0.zip','2022-05-24 16:34:54','SYNCED','5d3dcc4f-6d2d-44ab-815b-4de5076cb320',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.3\",\"modelMatrix\":\"-0.267728,0.945753,-0.184045,0,-0.963495,-0.262798,0.0511409,0,1.26612e-09,0.191018,0.981586,0,-10.2402,-22.3473,-17.4553,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'5de4d708-9268-44d3-8f75-05e78bdf5d20','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a4b302c-278d-4e12-ace5-f095ba0bf856/session_6206892a-2e7e-4765-ac90-b49bfb465997/occlusion_7ec70f78-dc80-40c5-b293-570a59f034c4/scan_e57dd65c-d607-4b04-af86-37d5f5d568b7/3_w1_o2_maxillaire_snapshot_0.png','SNAPS','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_7ec70f78-dc80-40c5-b293-570a59f034c4_TOSC_e57dd65c-d607-4b04-af86-37d5f5d568b7_SNAPS_','2022-09-06 09:17:56','2022-08-30 14:14:58','3_w1_o2_maxillaire_snapshot_0.png','2022-09-06 11:17:56','SYNCED','5de4d708-9268-44d3-8f75-05e78bdf5d20',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.3.1.2.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'5deb7cff-a8a8-4c00-af67-2cc45b57bc3c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f4fc00ec-4af8-4a15-b427-f1c5aabf6260/session_498ae60a-23f0-44fc-9730-be499bfc4b46/occlusion_8f3d6c73-3468-45a5-85c7-93bba47ec9f7/scan_0d368f7d-e2ae-489f-b39f-cfe87c4103c8/30_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_f4fc00ec-4af8-4a15-b427-f1c5aabf6260_ACT_498ae60a-23f0-44fc-9730-be499bfc4b46_SESS_8f3d6c73-3468-45a5-85c7-93bba47ec9f7_TOSC_0d368f7d-e2ae-489f-b39f-cfe87c4103c8_ZIP_','2022-06-14 13:26:11','2022-06-14 15:26:02','30_w1_o1_maxillaire_scan_file_0.zip','2022-06-14 15:26:11','SYNCED','5deb7cff-a8a8-4c00-af67-2cc45b57bc3c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.30.1.1.1\",\"modelMatrix\":\"-0.102207,0.992752,-0.0632283,0,-0.994763,-0.102001,0.00649642,0,1.08257e-11,0.0635612,0.997978,0,0.134114,-19.6177,-21.1524,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'5dfbb2b2-a700-4e05-b70f-a8db7b295be5','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a4b302c-278d-4e12-ace5-f095ba0bf856/session_6206892a-2e7e-4765-ac90-b49bfb465997/occlusion_3c30231c-7cd7-4431-985b-2eaf7f6925ae/scan_53241704-034c-49e7-bd41-012398465214/3_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_53241704-034c-49e7-bd41-012398465214_ZIP_','2022-09-06 09:20:38','2022-08-30 10:39:58','3_w1_o1_maxillaire_scan_file_0.zip','2022-09-06 11:20:38','SYNCED','5dfbb2b2-a700-4e05-b70f-a8db7b295be5',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.3.1.1.2\",\"modelMatrix\":\"0.731042,0.662354,-0.163904,0,-0.682332,0.709638,-0.175604,0,-7.1534e-09,0.240211,0.970721,0,-27.4537,-9.8526,-16.0814,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'5e045628-a37a-469c-89a3-80d0555bc569','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/computedocclusion_864c98a3-fcf7-466a-b999-13bd4dfb8c65/23_w1_o1_ml_occ_file_to1001.xyz','LIFI','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_864c98a3-fcf7-466a-b999-13bd4dfb8c65_LIFIO_LIFI_','2022-05-25 10:45:11','2022-05-25 12:45:09','23_w1_o1_ml_occ_file_to1001.xyz','2022-05-25 12:45:11','SYNCED','5e045628-a37a-469c-89a3-80d0555bc569',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.23.1.1.1 Occlusion 3 Ligne de finition 1\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"Maxillaire\",\"name\":\"Ligne de finition 1\",\"title\":\"Ligne finition\",\"toothNumber\":1001}'),(1001,'5e2227aa-c48a-4337-a9f3-899cdb079950','','SNAPS','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_OCC_764b8e22-8600-49e3-8d7c-d619725096ee_SNAPO__SNAPS_','2022-02-04 18:20:41','2022-02-04 19:19:48','',NULL,'CREATED','5e2227aa-c48a-4337-a9f3-899cdb079950',0,'2022-02-04 19:20:41','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'5e949756-e279-4f76-aa98-e944015eb62e','','LIFIM','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_TOSC_47ae7109-ac97-4f1b-8dd7-cc22debd4324_LIFIM_','2022-07-19 13:56:03','2022-07-19 15:55:49','','2022-07-19 15:56:03','SYNCED','5e949756-e279-4f76-aa98-e944015eb62e',0,'2022-07-19 15:56:03','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.38.1.1.4 Ligne de finition 0\",\"name\":\"Ligne de finition 0\",\"title\":\"Maxillaire LIFI_META\",\"toothNumber\":0,\"versionMarginLine\":1}'),(1001,'5eec5129-78cc-470e-82e3-9767204a05e4','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_1c86378e-7d31-4b12-82ff-af797020160f/4_w1_o2_mandibule_snapshot_3.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_BOSC_1c86378e-7d31-4b12-82ff-af797020160f_SNAPS_','2022-03-08 11:43:38','2022-03-08 12:43:29','4_w1_o2_mandibule_snapshot_3.png','2022-03-08 12:43:38','SYNCED','a13ef72a-3421-4e8c-a897-3f43da14e842',3,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.2.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'5f1cba97-c736-42be-b834-c71e914779a0','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_499bf817-e96f-4ff6-ae84-c5c2ccc847c2/17_w1_o1_mordu_anterieur_scan_file_0.zip','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_FRSC_499bf817-e96f-4ff6-ae84-c5c2ccc847c2_ZIP_','2022-02-07 11:46:52','2022-02-07 12:45:17','17_w1_o1_mordu_anterieur_scan_file_0.zip','2022-02-07 12:46:52','SYNCED','5f1cba97-c736-42be-b834-c71e914779a0',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.17.1.1.1\",\"modelMatrix\":\"0.960074,0.00808373,-0.276731,0,0.0920233,0.939826,0.279277,0,0.264214,-0.346635,0.921371,0,4.69226,8.36856,-31.3561,1\",\"title\":\"Mordu anterieur ZIP\"}'),(1001,'5f547eb8-8e01-467b-8bc2-36624f0938f2','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/986374de-c4d7-4d6f-bf0c-2dc7e3b859a9/session_c81670ed-4144-4347-b19e-8057d11b5f7c/occlusion_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be/scan_67168b1b-2bef-47a9-8e7f-994731a82831/28_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_986374de-c4d7-4d6f-bf0c-2dc7e3b859a9_ACT_c81670ed-4144-4347-b19e-8057d11b5f7c_SESS_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be_BOSC_67168b1b-2bef-47a9-8e7f-994731a82831_ZIP_','2022-05-31 10:45:14','2022-05-31 12:45:06','28_w1_o1_mandibule_scan_file_0.zip','2022-05-31 12:45:14','SYNCED','5f547eb8-8e01-467b-8bc2-36624f0938f2',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.28.1.1.1\",\"modelMatrix\":\"-0.884338,-0.414341,0.215098,0,0.466846,-0.784878,0.407456,0,8.2671e-09,0.460747,0.887532,0,11.4557,-5.93595,-19.3272,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'5fb5df68-7218-45fd-ba70-e0699bf168c3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_2ffbfbca-f236-4802-be93-8eb43d523274/scan_0bd54e85-3f0d-4955-9f02-7de656ad9f6f/4_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_2ffbfbca-f236-4802-be93-8eb43d523274_BOSC_0bd54e85-3f0d-4955-9f02-7de656ad9f6f_SNAPS_','2022-01-19 19:04:36','2022-01-19 20:04:15','4_w1_o1_mandibule_snapshot_0.png','2022-01-19 20:04:36','SYNCED','5fb5df68-7218-45fd-ba70-e0699bf168c3',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'5ff5a707-5e7c-47c4-8920-69e306d9f228','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_04d6e3f1-19ce-4851-a9d0-40419cea7542/scan_fef6f617-40e8-4052-8a2d-9af9e39ab22d/19_w1_o2_mandibule_scan_file_1.zip','ZIP','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_04d6e3f1-19ce-4851-a9d0-40419cea7542_BOSC_fef6f617-40e8-4052-8a2d-9af9e39ab22d_ZIP_','2022-04-15 14:02:29','2022-04-15 16:02:19','19_w1_o2_mandibule_scan_file_1.zip','2022-04-15 16:02:29','SYNCED','6fc1ad7b-72f9-4540-9e11-3ded800f23dc',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.2.2\",\"modelMatrix\":\"0.965818,0.246498,-0.080219,0,-0.259223,0.918408,-0.298882,0,-5.08029e-09,0.30946,0.950913,0,4.33301,1.42447,-28.5855,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'5ff5e58f-3f58-4a87-ac42-a542459a37c9','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_44561518-16e3-45bd-af90-fefe4eca9d27/24_w1_o1_mordu_posterieur_droit_snapshot_1.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_LESC_44561518-16e3-45bd-af90-fefe4eca9d27_SNAPS_','2022-06-14 11:57:26','2022-06-14 13:57:24','24_w1_o1_mordu_posterieur_droit_snapshot_1.png','2022-06-14 13:57:26','SYNCED','279111aa-db84-4754-8277-7244a074df26',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.24.1.1.8\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'602979f4-a95f-4ba9-aada-25d7c4560704','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/scan_f4fff5f5-f728-44ae-ac48-f3e653594098/23_w1_o1_mordu_anterieur_snapshot_1.png','SNAPS','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_FRSC_f4fff5f5-f728-44ae-ac48-f3e653594098_SNAPS_','2022-05-13 10:16:21','2022-05-13 12:16:11','23_w1_o1_mordu_anterieur_snapshot_1.png','2022-05-13 12:16:21','SYNCED','a0f1c5f4-8b35-4db9-8ae4-da64e546d1f6',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.23.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'604e49d8-63b3-4b19-90ef-e934ef7c9a28','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_2a7068fc-0efa-496f-ade9-aba5b0650655/12_w1_o1_mandibule_scan_file_9.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_2a7068fc-0efa-496f-ade9-aba5b0650655_ZIP_','2022-02-04 12:12:14','2022-02-04 13:11:40','12_w1_o1_mandibule_scan_file_9.zip','2022-02-04 13:12:14','SYNCED','44ebcd6f-57c2-4cce-96f5-f9faa1c6b373',9,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.5\",\"modelMatrix\":\"0.748154,-0.636082,0.188853,0,0.663525,0.717211,-0.21294,0,-1.38811e-9,0.284621,0.95864,0,2.11874,31.439,-28.6314,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'60959529-680d-4313-8700-3248303a4526','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/593972a6-d7d6-4802-b87d-38aab371f71e/session_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480/occlusion_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3/scan_7338a694-0f0d-4c09-8c45-b4e4129978cb/3_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_593972a6-d7d6-4802-b87d-38aab371f71e_ACT_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480_SESS_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3_RISC_7338a694-0f0d-4c09-8c45-b4e4129978cb_ZIP_','2022-01-19 15:15:35','2022-01-19 16:15:26','3_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-01-19 16:15:35','SYNCED','60959529-680d-4313-8700-3248303a4526',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.3.1.1.1\",\"modelMatrix\":\"0.977863,0.0243235,0.213697,0,-0.0290719,0.997638,0.0437543,0,-0.207464,-0.0668813,0.976072,0,-7.52046,-0.417257,-27.1865,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'62110026-7393-4ad5-bf19-dfa00af5ad07','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_6c9ae07a-23c3-4355-87ff-b57ef558a4ea/17_w1_o1_mordu_posterieur_gauche_snapshot_1.png','SNAPS','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_LESC_6c9ae07a-23c3-4355-87ff-b57ef558a4ea_SNAPS_','2022-02-11 16:09:43','2022-02-11 17:09:32','17_w1_o1_mordu_posterieur_gauche_snapshot_1.png','2022-02-11 17:09:43','SYNCED','2de8ced1-ba29-48f4-bc49-585a3648f21c',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.17.1.1.3\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'62166d54-8239-45c4-af5b-13106fa4a222','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/45ff7437-0691-4427-a7da-8250862e4b96/session_4ff9c682-c09d-42ff-8c29-aeb13e066ed2/order_8e37acfc-d63e-497a-b841-276203d01db8/9_w1_inlay_onlay_prost_file_62166d54-8239-45c4-af5b-13106fa4a222_0.pdf','PDF','PATIENT_45ff7437-0691-4427-a7da-8250862e4b96_ACT_4ff9c682-c09d-42ff-8c29-aeb13e066ed2_PROST_8e37acfc-d63e-497a-b841-276203d01db8_PDF_','2022-01-24 19:57:10','2022-01-24 20:57:07','9_w1_inlay_onlay_prost_file_62166d54-8239-45c4-af5b-13106fa4a222_0.pdf','2022-01-24 20:57:10','SYNCED','62166d54-8239-45c4-af5b-13106fa4a222',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.9.1.1 INLAY ONLAY\",\"title\":\"Inlay/Onlay PDF\"}'),(1001,'6217fbe5-09ba-48c5-9c84-c981fea99cac','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f4fc00ec-4af8-4a15-b427-f1c5aabf6260/session_498ae60a-23f0-44fc-9730-be499bfc4b46/occlusion_8f3d6c73-3468-45a5-85c7-93bba47ec9f7/computedocclusion_9c318e86-fa90-4cd9-8319-2503cde2b455/30_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_f4fc00ec-4af8-4a15-b427-f1c5aabf6260_ACT_498ae60a-23f0-44fc-9730-be499bfc4b46_SESS_8f3d6c73-3468-45a5-85c7-93bba47ec9f7_OCC_9c318e86-fa90-4cd9-8319-2503cde2b455_TOPLY__ZIP_','2022-06-14 13:30:12','2022-06-14 15:29:56','30_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-06-14 15:30:12','SYNCED','6217fbe5-09ba-48c5-9c84-c981fea99cac',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.30.1.1.1 Occlusion 1\",\"modelMatrix\":\"-0.102207,0.992752,-0.0632283,0,-0.994763,-0.102001,0.00649642,0,1.08257e-11,0.0635612,0.997978,0,0.134114,-19.6177,-21.1524,1\",\"referenceScanID\":\"1.30.1.1.1\",\"title\":\"Maxillaire 1.30.1.1.1 Occlusion 1\"}'),(1001,'62e04955-36d7-4e72-9a0b-cffb6a8463fe','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/scan_eafe4b37-e7ad-4f58-b931-a99f31f6d4a4/22_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_BOSC_eafe4b37-e7ad-4f58-b931-a99f31f6d4a4_SNAPS_','2022-04-21 10:47:54','2022-04-21 12:47:43','22_w1_o1_mandibule_snapshot_0.png','2022-04-21 12:47:54','SYNCED','62e04955-36d7-4e72-9a0b-cffb6a8463fe',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.22.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'636f5563-3dce-48da-97ef-4162f2b3051b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7f47fd88-9ea0-4c08-9193-a54d4f158c7c/session_7873a396-419c-4215-83c7-fec9f2742ccf/occlusion_2e287bb0-e19a-414a-9177-23b335d286d9/scan_aa3849b7-bd16-41b9-8afe-0af192f363d1/16_w1_o2_mandibule_scan_file_1.zip','ZIP','PATIENT_7f47fd88-9ea0-4c08-9193-a54d4f158c7c_ACT_7873a396-419c-4215-83c7-fec9f2742ccf_SESS_2e287bb0-e19a-414a-9177-23b335d286d9_BOSC_aa3849b7-bd16-41b9-8afe-0af192f363d1_ZIP_','2022-06-03 09:01:34','2022-06-03 11:01:26','16_w1_o2_mandibule_scan_file_1.zip','2022-06-03 11:01:34','SYNCED','f6f9c81e-5679-4d17-89e3-2a76bf2488aa',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.16.1.2.1\",\"modelMatrix\":\"-0.864845,0.473616,-0.166526,0,-0.502038,-0.815882,0.286869,0,-7.35692e-09,0.3317,0.943385,0,-0.119603,-7.43592,-19.1524,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'63ba55f1-1de3-4eec-ac72-d886606ec033','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/452a5200-3e06-4b74-8949-6abc7f2dda8a/session_3e95d626-668f-45f7-98ad-be2cf9d7b90b/occlusion_bce8310f-eee9-4f0a-a6b7-d592dec66be5/scan_49ae59fe-0bc4-4d86-b65e-d8788e2d12fb/26_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_452a5200-3e06-4b74-8949-6abc7f2dda8a_ACT_3e95d626-668f-45f7-98ad-be2cf9d7b90b_SESS_bce8310f-eee9-4f0a-a6b7-d592dec66be5_TOSC_49ae59fe-0bc4-4d86-b65e-d8788e2d12fb_ZIP_','2022-05-24 09:36:31','2022-05-24 11:36:20','26_w1_o1_maxillaire_scan_file_1.zip','2022-05-24 11:36:31','SYNCED','ed3a6299-1604-4ba4-8ce0-6c50eb2674e7',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.26.1.1.2\",\"modelMatrix\":\"-0.139935,0.977576,-0.157365,0,-0.990161,-0.138156,0.0222396,0,1.70026e-09,0.158929,0.98729,0,5.50609,-23.1559,-20.3156,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'63e9f9a7-c8a4-4bf2-9e7c-c06c335ff76a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/207d6dbc-c19b-4726-a9b3-16235ae554cc/session_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35/occlusion_dc5762a3-c453-4166-8c86-82d23ac9f8a6/computedocclusion_3a1fff1c-0427-409c-aa94-06326e554d82/27_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_207d6dbc-c19b-4726-a9b3-16235ae554cc_ACT_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35_SESS_dc5762a3-c453-4166-8c86-82d23ac9f8a6_OCC_3a1fff1c-0427-409c-aa94-06326e554d82_TOPLY__ZIP_','2022-05-30 11:09:39','2022-05-30 13:09:22','27_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-05-30 13:09:39','SYNCED','63e9f9a7-c8a4-4bf2-9e7c-c06c335ff76a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.27.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.708736,0.675594,-0.203138,0,-0.705473,0.678719,-0.204077,0,4.95031e-09,0.287945,0.957647,0,-5.6101,-21.7145,-20.7773,1\",\"referenceScanID\":\"1.27.1.1.1\",\"title\":\"Maxillaire 1.27.1.1.1 Occlusion 1\"}'),(1001,'63fde542-acb3-4b8f-82f2-355dcc8f8d55','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/8fc74d9e-a5a0-46bf-be3f-500548a130ad/session_5368829e-7dec-4775-a487-a1019f9604f4/occlusion_bb63a653-1b34-4d80-a4bf-7fda5c9b0360/scan_bb2387c3-c044-46d4-bfeb-b3572a68a3e5/14_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_8fc74d9e-a5a0-46bf-be3f-500548a130ad_ACT_5368829e-7dec-4775-a487-a1019f9604f4_SESS_bb63a653-1b34-4d80-a4bf-7fda5c9b0360_BOSC_bb2387c3-c044-46d4-bfeb-b3572a68a3e5_ZIP_','2022-02-01 10:46:35','2022-02-01 11:46:24','14_w1_o1_mandibule_scan_file_0.zip','2022-02-01 11:46:35','SYNCED','63fde542-acb3-4b8f-82f2-355dcc8f8d55',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.14.1.1.1\",\"modelMatrix\":\"0.729394,0.676142,-0.103997,0,-0.684093,0.720917,-0.110883,0,-1.15254e-9,0.152021,0.988377,0,-16.6301,-13.2651,-17.5315,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'642f1d21-72b4-419c-b005-26b9f2557b21','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/e922efb9-8c03-445b-8a0f-449e3c43bdca/session_a2369349-1629-40ad-8784-d271bc3fbade/occlusion_292cc1aa-8b12-463b-87a1-7d9731cf886b/computedocclusion_f9f6d9d2-cc34-43c3-9f5f-4b8e54b41bbb/21_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_e922efb9-8c03-445b-8a0f-449e3c43bdca_ACT_a2369349-1629-40ad-8784-d271bc3fbade_SESS_292cc1aa-8b12-463b-87a1-7d9731cf886b_OCC_f9f6d9d2-cc34-43c3-9f5f-4b8e54b41bbb_TOMA__MATRX_','2022-04-21 08:53:15','2022-04-21 10:53:03','21_w1_o1_maxillaire_matrix_occ_file_0.m','2022-04-21 10:53:15','SYNCED','642f1d21-72b4-419c-b005-26b9f2557b21',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.21.1.1.1 Occlusion 2\",\"referenceScanID\":\"1.21.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.21.1.1.1 Occlusion 2\"}'),(1001,'643b4b45-c20a-4040-bf63-70edc63f19d1','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/computedocclusion_7c70edbe-5cb4-4244-8baf-7caf2bd7d86b/12_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_OCC_7c70edbe-5cb4-4244-8baf-7caf2bd7d86b_BOMA__MATRX_','2022-02-04 17:59:49','2022-02-04 18:58:48','12_w1_o1_mandibule_matrix_occ_file_0.m','2022-02-04 18:59:49','SYNCED','643b4b45-c20a-4040-bf63-70edc63f19d1',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.12.1.1.5 Occlusion 1\",\"referenceScanID\":\"1.12.1.1.5\",\"title\":\"Matrice Transfo. Mandibule 1.12.1.1.5 Occlusion 1\"}'),(1001,'6450ccf2-fa7c-4da9-b0db-3bf64296703e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_2ffbfbca-f236-4802-be93-8eb43d523274/scan_dfbb6a00-3125-4e66-bba2-7ad562b73551/4_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_2ffbfbca-f236-4802-be93-8eb43d523274_TOSC_dfbb6a00-3125-4e66-bba2-7ad562b73551_ZIP_','2022-01-19 18:59:33','2022-01-19 19:59:10','4_w1_o1_maxillaire_scan_file_0.zip','2022-01-19 19:59:33','SYNCED','6450ccf2-fa7c-4da9-b0db-3bf64296703e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.4.1.1.1\",\"modelMatrix\":\"-0.389008,0.904422,-0.175195,0,-0.921234,-0.381909,0.0739794,0,-3.44075e-9,0.190174,0.98175,0,-3.07419,-20.917,-20.2976,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'64a2cdcc-5188-478e-9b53-93f8a3b2cb90','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/scan_f2bad12a-451d-406d-98b0-e431a37951dd/19_w1_o1_mandibule_scan_file_3.zip','ZIP','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_BOSC_f2bad12a-451d-406d-98b0-e431a37951dd_ZIP_','2022-03-08 10:52:49','2022-03-08 11:52:41','19_w1_o1_mandibule_scan_file_3.zip','2022-03-08 11:52:49','SYNCED','e3a545cc-fe2a-418f-9896-979b09c1f684',3,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.1.4\",\"modelMatrix\":\"-0.988793,0.145775,-0.0322113,0,-0.149292,-0.965503,0.213343,0,-2.16806e-09,0.215761,0.976446,0,23.0578,-21.2539,-25.059,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'64b1a7cd-06d4-469c-b06d-4c38cfd82051','','ZIP','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_OCC_778ed9fd-f658-471d-9dd0-a48417419cba_BOPLY__ZIP_','2022-05-12 12:32:06','2022-05-12 14:31:43','','2022-05-12 14:32:06','SYNCED','64b1a7cd-06d4-469c-b06d-4c38cfd82051',0,'2022-05-12 14:32:06','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.18.1.1.3 Occlusion 3\",\"modelMatrix\":\"-0.721265,0.622319,-0.304132,0,-0.69266,-0.648019,0.316692,0,5.59464e-09,0.439079,0.898449,0,-8.58806,-18.2472,-17.8803,1\",\"referenceScanID\":\"1.18.1.1.3\",\"title\":\"Mandibule 1.18.1.1.3 Occlusion 3\"}'),(1001,'6504ab72-95fe-47d4-9e8c-72f5662b1616','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/order_13ed86f9-f32c-434d-be1e-dd6b645457dd/38_w1_couronne_prost_file_6504ab72-95fe-47d4-9e8c-72f5662b1616_0.pdf','PDF','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_PROST_13ed86f9-f32c-434d-be1e-dd6b645457dd_PDF_','2022-07-12 17:44:23','2022-07-12 19:44:21','38_w1_couronne_prost_file_6504ab72-95fe-47d4-9e8c-72f5662b1616_0.pdf','2022-07-12 19:44:23','SYNCED','6504ab72-95fe-47d4-9e8c-72f5662b1616',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.38.1.1 COURONNE\",\"title\":\"Couronne PDF\"}'),(1001,'65248dcf-9c3a-47ce-a2c2-9d6f5de84040','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/computedocclusion_2de3d2bb-d512-4514-8bed-a879b73a6028/22_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_OCC_2de3d2bb-d512-4514-8bed-a879b73a6028_TOMA__MATRX_','2022-04-21 11:29:39','2022-04-21 13:29:16','22_w1_o1_maxillaire_matrix_occ_file_0.m','2022-04-21 13:29:39','SYNCED','65248dcf-9c3a-47ce-a2c2-9d6f5de84040',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.22.1.1.1 Occlusion 7\",\"referenceScanID\":\"1.22.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.22.1.1.1 Occlusion 7\"}'),(2,'65304f6c-7e3f-44de-9447-cad85ecf6541','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a4b302c-278d-4e12-ace5-f095ba0bf856/session_6206892a-2e7e-4765-ac90-b49bfb465997/occlusion_7ec70f78-dc80-40c5-b293-570a59f034c4/scan_1075d1a0-1218-4048-a7c7-3aa9195b6f63/3_w1_o2_maxillaire_scan_file_0.zip','ZIP','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_7ec70f78-dc80-40c5-b293-570a59f034c4_TOSC_1075d1a0-1218-4048-a7c7-3aa9195b6f63_ZIP_','2022-09-06 09:20:30','2022-08-30 14:28:41','3_w1_o2_maxillaire_scan_file_0.zip','2022-09-06 11:20:30','SYNCED','65304f6c-7e3f-44de-9447-cad85ecf6541',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.3.1.2.5\",\"modelMatrix\":\"0.456772,0.864302,-0.210572,0,-0.889584,0.443791,-0.108122,0,6.64111e-09,0.236708,0.971581,0,-22.1477,-20.4345,-15.1629,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'6572a09e-0600-46b5-808e-1a6ed5da434e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/d100e894-0be9-4495-94e2-e469232f7817/session_2c8b85b5-c805-4b08-85e7-3d02dab72e99/occlusion_8a278cc5-a1c1-4dfb-9ee2-c971a6309afa/scan_6c418416-1c53-40cd-ba49-f56373b0bc1a/15_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_d100e894-0be9-4495-94e2-e469232f7817_ACT_2c8b85b5-c805-4b08-85e7-3d02dab72e99_SESS_8a278cc5-a1c1-4dfb-9ee2-c971a6309afa_BOSC_6c418416-1c53-40cd-ba49-f56373b0bc1a_ZIP_','2022-02-01 15:02:14','2022-02-01 16:01:54','15_w1_o1_mandibule_scan_file_0.zip','2022-02-01 16:02:14','SYNCED','6572a09e-0600-46b5-808e-1a6ed5da434e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.15.1.1.2\",\"modelMatrix\":\"-0.985432,0.141687,-0.0940649,0,-0.170069,-0.820979,0.545042,0,2.27757e-9,0.5531,0.833115,0,26.9779,0.977042,-14.8944,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'65a1c33d-5a70-4155-ac8d-4be3028e8eca','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/discussion_4d12bcc3-80f2-49dc-9159-54929f160ce6/65a1c33d-5a70-4155-ac8d-4be3028e8eca.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_426bd908-3163-4291-a697-20eacff771ab_BOPLY__ZIP_','2022-05-25 08:56:24','2022-05-16 19:57:11','65a1c33d-5a70-4155-ac8d-4be3028e8eca.zip','2022-05-25 10:56:24','SYNCED','65a1c33d-5a70-4155-ac8d-4be3028e8eca',0,'2022-05-25 10:56:24','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.24.1.1.1 Occlusion 6\",\"modelMatrix\":\"0.852703,-0.521011,0.0380208,0,0.522396,0.850441,-0.062061,0,3.49638e-10,0.0727815,0.997348,0,-11.3911,-12.8136,-21.1334,1\",\"referenceScanID\":\"1.24.1.1.1\",\"title\":\"Mandibule 1.24.1.1.1 Occlusion 6\"}'),(1001,'65fd3ecb-affa-479b-8a28-d81f4574f5ef','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/computedocclusion_b35629de-38d8-4cdd-bf2c-b61c461410cb/17_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_b35629de-38d8-4cdd-bf2c-b61c461410cb_TOMA__MATRX_','2022-02-07 18:07:23','2022-02-07 19:05:55','17_w1_o1_maxillaire_matrix_occ_file_0.m','2022-02-07 19:07:23','SYNCED','65fd3ecb-affa-479b-8a28-d81f4574f5ef',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.17.1.1.1 Occlusion 6\",\"referenceScanID\":\"1.17.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.17.1.1.1 Occlusion 6\"}'),(1001,'6638ad2b-84e9-4c08-ad38-98e12dae4a45','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_fde05ea2-d0fd-419b-ba13-bf1a1bd03a22/18_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_BOSC_fde05ea2-d0fd-419b-ba13-bf1a1bd03a22_ZIP_','2022-03-07 14:25:30','2022-03-07 15:25:19','18_w1_o1_mandibule_scan_file_0.zip','2022-03-07 15:25:30','SYNCED','6638ad2b-84e9-4c08-ad38-98e12dae4a45',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.18.1.1.2\",\"modelMatrix\":\"0.885931,-0.458931,0.0671427,0,0.463817,0.876599,-0.128249,0,7.65783e-11,0.144761,0.989467,0,0.24241,21.5206,-16.5349,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'6663a1af-2944-4657-897b-ca9974703102','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/57c4096f-98dd-49c8-bea5-a5b109ad3fd0/session_4f62e395-5623-4d5b-869c-1b2fc4d22b00/occlusion_1ac20dc7-b36b-4786-a05f-37091554dc5c/scan_e2e4ad7f-c1c9-4c11-a41c-d237b2e0023e/31_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_57c4096f-98dd-49c8-bea5-a5b109ad3fd0_ACT_4f62e395-5623-4d5b-869c-1b2fc4d22b00_SESS_1ac20dc7-b36b-4786-a05f-37091554dc5c_BOSC_e2e4ad7f-c1c9-4c11-a41c-d237b2e0023e_SNAPS_','2022-06-16 10:59:43','2022-06-16 12:59:33','31_w1_o1_mandibule_snapshot_0.png','2022-06-16 12:59:43','SYNCED','6663a1af-2944-4657-897b-ca9974703102',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.31.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'6664ed29-0935-466e-abc8-468b0ac6dee3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/scan_725ef2a4-4b53-4ec9-a807-17759213c882/22_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_BOSC_725ef2a4-4b53-4ec9-a807-17759213c882_ZIP_','2022-04-21 11:05:31','2022-04-21 13:05:24','22_w1_o1_mandibule_scan_file_0.zip','2022-04-21 13:05:31','SYNCED','6664ed29-0935-466e-abc8-468b0ac6dee3',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.22.1.1.2\",\"modelMatrix\":\"0.930866,0.359665,-0.0642588,0,-0.36536,0.916356,-0.163719,0,1.67408e-09,0.175878,0.984412,0,-11.7687,0.165278,-18.4217,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'66961639-a805-46f9-bc8c-5d51fa295ec0','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_e8550560-cfe0-40a1-bfb3-992d471fbcb7/17_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_BOSC_e8550560-cfe0-40a1-bfb3-992d471fbcb7_ZIP_','2022-02-07 11:41:44','2022-02-07 12:35:18','17_w1_o1_mandibule_scan_file_0.zip','2022-02-07 12:41:44','SYNCED','66961639-a805-46f9-bc8c-5d51fa295ec0',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.17.1.1.1\",\"modelMatrix\":\"-0.999279,-0.0367359,0.00954126,0,0.0379548,-0.96719,0.251204,0,-7.36168e-10,0.251385,0.967887,0,30.9318,13.7449,-19.2031,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'66b1ce2c-2444-4a54-9fe5-0dadee0be0cb','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_4f8dc275-857c-482a-9886-5521591e9661/scan_ac56bd4c-2fb3-4bde-858c-86c2586bc3e9/12_w1_o4_maxillaire_snapshot_0.png','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_TOSC_ac56bd4c-2fb3-4bde-858c-86c2586bc3e9_SNAPS_','2022-02-14 10:22:02','2022-02-14 11:21:44','12_w1_o4_maxillaire_snapshot_0.png','2022-02-14 11:22:02','SYNCED','66b1ce2c-2444-4a54-9fe5-0dadee0be0cb',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.12.1.4.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'66f0c509-0e47-49c8-8cae-0cbb6a788831','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_2a7068fc-0efa-496f-ade9-aba5b0650655/12_w1_o1_mandibule_scan_file_7.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_2a7068fc-0efa-496f-ade9-aba5b0650655_ZIP_','2022-02-04 12:08:35','2022-02-04 13:08:20','12_w1_o1_mandibule_scan_file_7.zip','2022-02-04 13:08:35','SYNCED','44ebcd6f-57c2-4cce-96f5-f9faa1c6b373',7,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.5\",\"modelMatrix\":\"0.812765,-0.55474,0.177983,0,0.582592,0.773907,-0.248301,0,-6.61608e-9,0.305502,0.952191,0,-2.30692,30.696,-29.3075,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'6703e7d5-5908-4d87-8d6c-4fb206bab958','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/fa7fa96b-f393-4b9a-8198-144702462cfa/session_4bed076c-8541-4a2f-800a-5aeb4cb49de5/occlusion_16b82fca-4b65-4866-af87-1f6dbb42f5dc/scan_77280faa-6fb3-46f5-aa9e-fd5dd96b1535/35_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_fa7fa96b-f393-4b9a-8198-144702462cfa_ACT_4bed076c-8541-4a2f-800a-5aeb4cb49de5_SESS_16b82fca-4b65-4866-af87-1f6dbb42f5dc_TOSC_77280faa-6fb3-46f5-aa9e-fd5dd96b1535_ZIP_','2022-06-28 15:01:18','2022-06-28 17:01:09','35_w1_o1_maxillaire_scan_file_0.zip','2022-06-28 17:01:18','SYNCED','6703e7d5-5908-4d87-8d6c-4fb206bab958',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.35.1.1.1\",\"modelMatrix\":\"0.09906,0.984988,-0.141374,0,-0.995081,0.0980552,-0.0140737,0,-1.38943e-09,0.142073,0.989856,0,-3.58695,-24.3271,-17.1724,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'674bf663-589f-4efa-8935-869a415dee68','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_0e451099-a0ad-463c-9441-7ded1297fa16/24_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_TOSC_0e451099-a0ad-463c-9441-7ded1297fa16_ZIP_','2022-05-24 14:43:40','2022-05-24 16:43:26','24_w1_o1_maxillaire_scan_file_1.zip','2022-05-24 16:43:40','SYNCED','5d3dcc4f-6d2d-44ab-815b-4de5076cb320',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.3\",\"modelMatrix\":\"-0.348415,0.927523,-0.135305,0,-0.93734,-0.344766,0.0502937,0,4.16863e-09,0.14435,0.989527,0,-8.01926,-22.8232,-18.3945,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'675b37ea-2917-45cd-8a16-d591bc39a814','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_04d6e3f1-19ce-4851-a9d0-40419cea7542/scan_e61be1a3-1cc4-4625-b318-5e591ee9846a/19_w1_o2_mordu_anterieur_scan_file_0.zip','ZIP','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_04d6e3f1-19ce-4851-a9d0-40419cea7542_FRSC_e61be1a3-1cc4-4625-b318-5e591ee9846a_ZIP_','2022-04-15 11:41:26','2022-04-01 18:21:10','19_w1_o2_mordu_anterieur_scan_file_0.zip','2022-04-15 13:41:26','SYNCED','675b37ea-2917-45cd-8a16-d591bc39a814',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.19.1.2.1\",\"modelMatrix\":\"0.854332,0.1505,0.504464,0,-0.137793,0.988812,0.0147122,0,-0.501422,-0.047782,0.864719,0,-2.93614,-3.90513,-30.1512,1\",\"title\":\"Mordu anterieur ZIP\"}'),(1001,'679107eb-7e9d-4180-ae79-9907a2a032e3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a0c21836-ba79-4f15-9e35-02ef8211a9e5/session_0aac522d-3c38-465a-a1e0-014166c140ac/occlusion_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042/scan_8e186cfd-8ea5-4242-96cb-5a138aa44971/7_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_a0c21836-ba79-4f15-9e35-02ef8211a9e5_ACT_0aac522d-3c38-465a-a1e0-014166c140ac_SESS_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042_FRSC_8e186cfd-8ea5-4242-96cb-5a138aa44971_SNAPS_','2022-01-21 12:04:48','2022-01-21 13:03:11','7_w1_o1_mordu_anterieur_snapshot_0.png','2022-01-21 13:04:48','SYNCED','679107eb-7e9d-4180-ae79-9907a2a032e3',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.7.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'67a26d2a-1c67-4353-aac9-8b3183eb074d','','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_7d8decb1-23db-4824-940f-8d8822d88813_TOPLY__ZIP_','2022-02-08 08:49:00','2022-02-07 18:48:45','','2022-02-08 09:49:00','SYNCED','67a26d2a-1c67-4353-aac9-8b3183eb074d',0,'2022-02-08 09:49:00','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.17.1.1.1 Occlusion 3\",\"modelMatrix\":\"0.149253,0.920186,-0.361913,0,-0.988799,0.138896,-0.0546284,0,-8.90892e-10,0.366013,0.93061,0,-24.4594,-29.735,-12.8678,1\",\"referenceScanID\":\"1.17.1.1.1\",\"title\":\"Maxillaire 1.17.1.1.1 Occlusion 3\"}'),(1001,'67dec3ff-5824-4997-9c0b-d7b18cdb2cbd','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_d1eece96-1e6b-468d-8dc5-8295ca2149a4/24_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_LESC_d1eece96-1e6b-468d-8dc5-8295ca2149a4_ZIP_','2022-05-13 14:46:30','2022-05-13 16:46:23','24_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-05-13 16:46:30','SYNCED','67dec3ff-5824-4997-9c0b-d7b18cdb2cbd',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.24.1.1.1\",\"modelMatrix\":\"-0.988881,0.00916675,0.152174,0,-0.0148994,-0.99946,-0.0232662,0,0.148013,-0.0324218,0.988115,0,-9.88635,-3.09015,-15.7074,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'682c54ab-42b2-46a2-a6af-320afbdfdf82','','MATRX','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_OCC_ff8547d7-27f8-4862-9b63-e713dd817f3f_TOMA__MATRX_','2022-09-09 17:04:16','2022-09-09 19:03:34','','2022-09-09 19:04:16','SYNCED','682c54ab-42b2-46a2-a6af-320afbdfdf82',0,'2022-09-09 19:04:16','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.39.1.1.1 Occlusion 10\",\"referenceScanID\":\"1.39.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.39.1.1.1 Occlusion 10\"}'),(1001,'683c73b6-a453-4c29-a8cb-6a99b6d7e3d3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/45ff7437-0691-4427-a7da-8250862e4b96/session_4ff9c682-c09d-42ff-8c29-aeb13e066ed2/occlusion_934673c1-a4b9-4508-ac1b-a03092a0693e/scan_00f98bb4-dc6f-4a78-b9c8-5f04e23fc139/9_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_45ff7437-0691-4427-a7da-8250862e4b96_ACT_4ff9c682-c09d-42ff-8c29-aeb13e066ed2_SESS_934673c1-a4b9-4508-ac1b-a03092a0693e_TOSC_00f98bb4-dc6f-4a78-b9c8-5f04e23fc139_ZIP_','2022-01-24 17:38:28','2022-01-24 18:31:10','9_w1_o1_maxillaire_scan_file_0.zip','2022-01-24 18:38:28','SYNCED','683c73b6-a453-4c29-a8cb-6a99b6d7e3d3',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.9.1.1.1\",\"modelMatrix\":\"-0.0573042,0.992846,-0.104756,0,-0.998357,-0.0569879,0.00601286,0,4.73835e-10,0.104929,0.99448,0,6.4536,-23.1032,-18.5679,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'685e7310-189c-40af-ac57-e8cbef5c2417','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_e6c95ef7-636d-4c88-8d02-e2d9840573db/13_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_e6c95ef7-636d-4c88-8d02-e2d9840573db_ZIP_','2022-01-27 16:37:23','2022-01-27 17:36:59','13_w1_o1_mandibule_scan_file_1.zip','2022-01-27 17:37:23','SYNCED','bcef8d3e-9632-4976-8cda-4c6f3ac50e99',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.1\",\"modelMatrix\":\"-0.963479,0.243305,-0.111855,0,-0.267785,-0.8754,0.402451,0,1.23617e-9,0.417706,0.908582,0,32.4632,-3.53421,-16.2323,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'68a7881a-ea83-4e50-b8af-b28454591c34','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/scan_7b00996b-90f8-4307-9a8c-263a28f1b341/4_w1_o4_maxillaire_snapshot_0.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_TOSC_7b00996b-90f8-4307-9a8c-263a28f1b341_SNAPS_','2022-05-31 11:49:49','2022-05-31 13:49:39','4_w1_o4_maxillaire_snapshot_0.png','2022-05-31 13:49:49','SYNCED','68a7881a-ea83-4e50-b8af-b28454591c34',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.4.1.4.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'68cf35d1-7f31-4f48-8b81-a07300151534','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_4f8dc275-857c-482a-9886-5521591e9661/scan_df08df19-150c-437d-8ed4-bf2826644265/12_w1_o4_mandibule_scan_file_0.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_BOSC_df08df19-150c-437d-8ed4-bf2826644265_ZIP_','2022-02-18 16:11:36','2022-02-18 17:11:28','12_w1_o4_mandibule_scan_file_0.zip','2022-02-18 17:11:36','SYNCED','68cf35d1-7f31-4f48-8b81-a07300151534',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.4.5\",\"modelMatrix\":\"0.547289,0.783506,-0.294268,0,-0.836944,0.512345,-0.192425,0,2.01316e-08,0.351598,0.936151,0,-3.99458,-15.7075,-19.0924,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'68e7c3a1-6552-416d-a849-77f78c6c1539','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/scan_eafe4b37-e7ad-4f58-b931-a99f31f6d4a4/22_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_BOSC_eafe4b37-e7ad-4f58-b931-a99f31f6d4a4_ZIP_','2022-04-21 10:47:53','2022-04-21 12:47:44','22_w1_o1_mandibule_scan_file_0.zip','2022-04-21 12:47:53','SYNCED','68e7c3a1-6552-416d-a849-77f78c6c1539',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.22.1.1.1\",\"modelMatrix\":\"0.547665,-0.836383,0.0229432,0,0.836697,0.547459,-0.0150176,0,4.65993e-10,0.0274211,0.999624,0,6.28122,8.42122,-22.362,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'69031f67-5df5-4275-9366-6c75582ef750','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/32939ecf-ba11-4fff-a074-5e86a9f7f313/session_4075a8d6-094f-4202-abe0-4c02b7a5a8e6/order_920b9d76-bc23-467b-a3c6-2d7b175a8e1a/6_w1_couronne_prost_file_69031f67-5df5-4275-9366-6c75582ef750_0.pdf','PDF','PATIENT_32939ecf-ba11-4fff-a074-5e86a9f7f313_ACT_4075a8d6-094f-4202-abe0-4c02b7a5a8e6_PROST_920b9d76-bc23-467b-a3c6-2d7b175a8e1a_PDF_','2022-01-20 19:45:48','2022-01-20 20:45:47','6_w1_couronne_prost_file_69031f67-5df5-4275-9366-6c75582ef750_0.pdf','2022-01-20 20:45:48','SYNCED','69031f67-5df5-4275-9366-6c75582ef750',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.6.1.1 COURONNE\",\"title\":\"Couronne PDF\"}'),(1001,'697b7f82-bb89-492f-b79f-63826892538f','','LIFI','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_TOSC_0136d883-d517-448a-82a3-bfcdd5f4c35c_LIFI_','2022-07-19 13:44:35','2022-07-19 14:28:21','','2022-07-19 15:44:35','SYNCED','697b7f82-bb89-492f-b79f-63826892538f',0,'2022-07-19 15:44:35','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.38.1.1.1 Ligne de finition 0\",\"name\":\"Ligne de finition 0\",\"title\":\"Maxillaire LIFI\",\"toothNumber\":0,\"versionMarginLine\":1}'),(1001,'69a8428e-386d-4f89-953d-72fb9eeaee3f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_af1a113d-a181-4a3b-8ed8-44cff2f8fe53/24_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_LESC_af1a113d-a181-4a3b-8ed8-44cff2f8fe53_ZIP_','2022-05-24 14:48:50','2022-05-24 16:48:43','24_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-05-24 16:48:50','SYNCED','69a8428e-386d-4f89-953d-72fb9eeaee3f',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.24.1.1.4\",\"modelMatrix\":\"-0.985409,-0.126722,0.12268,0,0.122972,-0.991323,0.0219164,0,0.117897,0.0357085,0.992207,0,-7.36216,-1.4312,-17.9903,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'69ad61a1-bbd5-4415-a55b-c7c378bdf30e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/occlusion_e08bbeeb-a30b-428c-bd4a-40198f792219/scan_ef1d20c7-5f61-4c35-8f0f-d85507cab786/25_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_SESS_e08bbeeb-a30b-428c-bd4a-40198f792219_BOSC_ef1d20c7-5f61-4c35-8f0f-d85507cab786_ZIP_','2022-05-17 16:11:04','2022-05-17 18:10:54','25_w1_o1_mandibule_scan_file_0.zip','2022-05-17 18:11:04','SYNCED','69ad61a1-bbd5-4415-a55b-c7c378bdf30e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.25.1.1.1\",\"modelMatrix\":\"0.987554,-0.156623,0.0143947,0,0.157283,0.983409,-0.0903818,0,-2.60027e-10,0.0915209,0.995803,0,-0.804564,-4.57332,-21.3253,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'69e26dc2-cd36-4482-bdd3-656e011afd54','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_44561518-16e3-45bd-af90-fefe4eca9d27/24_w1_o1_mordu_posterieur_gauche_scan_file_2.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_LESC_44561518-16e3-45bd-af90-fefe4eca9d27_ZIP_','2022-06-14 11:57:30','2022-06-14 13:57:24','24_w1_o1_mordu_posterieur_gauche_scan_file_2.zip','2022-06-14 13:57:30','SYNCED','8e3b2146-f0cf-465d-9fe3-fdbb0b0d4d1e',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.24.1.1.8\",\"modelMatrix\":\"0.998505,0.0288376,0.0356512,0,-0.0392148,0.994627,0.101591,0,-0.0393194,-0.099669,0.99422,0,9.20621,7.03609,-15.1186,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'6a291473-6bc6-401e-8fb7-01a4524ebec6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_77ec818f-d778-4945-9458-90665b5522ba/17_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_TOSC_77ec818f-d778-4945-9458-90665b5522ba_ZIP_','2022-02-07 11:25:29','2022-02-07 12:23:53','17_w1_o1_maxillaire_scan_file_0.zip','2022-02-07 12:25:29','SYNCED','6a291473-6bc6-401e-8fb7-01a4524ebec6',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.17.1.1.1\",\"modelMatrix\":\"0.181283,0.917783,-0.353285,0,-0.983431,0.169181,-0.0651236,0,3.73031e-9,0.359238,0.933246,0,-25.409,-29.3409,-13.62,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'6a7c327b-919b-43af-9cea-a2ff628c91c8','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_d87d63d7-4507-4391-b749-4b160c9363ed/12_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_d87d63d7-4507-4391-b749-4b160c9363ed_SNAPS_','2022-01-27 12:07:55','2022-01-27 13:07:39','12_w1_o1_mandibule_snapshot_0.png','2022-01-27 13:07:55','SYNCED','6a7c327b-919b-43af-9cea-a2ff628c91c8',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'6acab9c1-fd86-4b22-a28b-e83dbe7f0bf2','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_14264009-2f96-4841-9c75-17adb3424f9f/18_w1_o1_mordu_anterieur_scan_file_0.zip','ZIP','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_FRSC_14264009-2f96-4841-9c75-17adb3424f9f_ZIP_','2022-03-07 14:35:30','2022-03-07 15:35:21','18_w1_o1_mordu_anterieur_scan_file_0.zip','2022-03-07 15:35:30','SYNCED','6acab9c1-fd86-4b22-a28b-e83dbe7f0bf2',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.18.1.1.1\",\"modelMatrix\":\"0.984075,-0.0589972,0.176695,0,0.0739748,0.992259,-0.124267,0,-0.161791,0.111986,0.976715,0,0.555039,-6.34584,-20.5488,1\",\"title\":\"Mordu anterieur ZIP\"}'),(1001,'6b4e9480-26b4-4d05-b592-372c05f53a4e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/d100e894-0be9-4495-94e2-e469232f7817/session_2c8b85b5-c805-4b08-85e7-3d02dab72e99/occlusion_8a278cc5-a1c1-4dfb-9ee2-c971a6309afa/scan_b1a27ca1-b17d-4071-99c1-940f9efedb70/15_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_d100e894-0be9-4495-94e2-e469232f7817_ACT_2c8b85b5-c805-4b08-85e7-3d02dab72e99_SESS_8a278cc5-a1c1-4dfb-9ee2-c971a6309afa_RISC_b1a27ca1-b17d-4071-99c1-940f9efedb70_SNAPS_','2022-02-01 15:11:23','2022-02-01 16:11:12','15_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-02-01 16:11:23','SYNCED','6b4e9480-26b4-4d05-b592-372c05f53a4e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.15.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'6b4f02ea-c57e-40cc-a471-e0a4dd200fcd','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/computedocclusion_35af1bf5-285a-4bb1-a6db-fe9897defe51/23_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_35af1bf5-285a-4bb1-a6db-fe9897defe51_SNAPO__SNAPS_','2022-05-13 12:11:30','2022-05-13 14:11:07','23_w1_o1_snapshot_occ_file_0.png','2022-05-13 14:11:30','SYNCED','6b4f02ea-c57e-40cc-a471-e0a4dd200fcd',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'6b9eecc3-635f-4c15-8609-cf0c4f6d6dae','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/computedocclusion_864c98a3-fcf7-466a-b999-13bd4dfb8c65/23_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_864c98a3-fcf7-466a-b999-13bd4dfb8c65_SNAPO__SNAPS_','2022-05-13 11:31:02','2022-05-13 13:30:43','23_w1_o1_snapshot_occ_file_0.png','2022-05-13 13:31:02','SYNCED','6b9eecc3-635f-4c15-8609-cf0c4f6d6dae',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'6ba1ffaa-7f81-420c-bdc5-28b53161c4f3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_2ffbfbca-f236-4802-be93-8eb43d523274/scan_6313fe60-344e-44c5-9805-fd1382bb983f/4_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_2ffbfbca-f236-4802-be93-8eb43d523274_LESC_6313fe60-344e-44c5-9805-fd1382bb983f_ZIP_','2022-01-19 19:08:56','2022-01-19 20:08:48','4_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-01-19 20:08:56','SYNCED','6ba1ffaa-7f81-420c-bdc5-28b53161c4f3',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.4.1.1.1\",\"modelMatrix\":\"-0.888388,0.450171,0.0688823,0,-0.45893,-0.884246,-0.102551,0,0.0130484,-0.124404,0.992342,0,-6.81792,15.0877,-17.8786,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'6bb63a3b-8000-4f0c-89f0-23596bbf5507','','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_OCC_d8bec5dc-8405-473d-9ba5-ae6e461ed6fd_TOPLY__ZIP_','2022-02-04 18:14:41','2022-02-04 19:13:44','',NULL,'CREATED','6bb63a3b-8000-4f0c-89f0-23596bbf5507',0,'2022-02-04 19:14:41','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.13.1.1.3 Occlusion 1\",\"modelMatrix\":\"0.754335,0.643596,-0.129474,0,-0.65649,0.739519,-0.148771,0,2.61688e-9,0.197222,0.980359,0,-9.25272,-30.1421,-17.7968,1\",\"referenceScanID\":\"1.13.1.1.3\",\"title\":\"Maxillaire 1.13.1.1.3 Occlusion 1\"}'),(1001,'6bc7e08a-0082-4460-9fa9-8c680f43839c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/69640c87-271c-4a44-a6fa-67b01654cc27/session_5f9199b0-eb37-4ed3-8d1a-6c38505d4913/occlusion_991beec3-fe9e-4c98-a3d4-c98e4a4c2471/scan_1ff80dd9-2d47-4292-adde-0923cb6fe572/39_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_FRSC_1ff80dd9-2d47-4292-adde-0923cb6fe572_SNAPS_','2022-09-09 16:25:08','2022-09-09 18:25:01','39_w1_o1_mordu_anterieur_snapshot_0.png','2022-09-09 18:25:08','SYNCED','6bc7e08a-0082-4460-9fa9-8c680f43839c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.39.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'6c068fd4-9fc3-4964-b6e1-b872b9490c35','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/986374de-c4d7-4d6f-bf0c-2dc7e3b859a9/session_c81670ed-4144-4347-b19e-8057d11b5f7c/occlusion_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be/computedocclusion_7a5acfd0-87ca-4009-aa4e-677a88ceffde/28_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_986374de-c4d7-4d6f-bf0c-2dc7e3b859a9_ACT_c81670ed-4144-4347-b19e-8057d11b5f7c_SESS_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be_OCC_7a5acfd0-87ca-4009-aa4e-677a88ceffde_BOMA__MATRX_','2022-05-31 10:54:13','2022-05-31 12:53:55','28_w1_o1_mandibule_matrix_occ_file_0.m','2022-05-31 12:54:13','SYNCED','6c068fd4-9fc3-4964-b6e1-b872b9490c35',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.28.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.28.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.28.1.1.1 Occlusion 1\"}'),(1001,'6c6fd223-601d-4256-8405-c41834d00e44','','LIFIM','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_TOSC_0136d883-d517-448a-82a3-bfcdd5f4c35c_LIFIM_','2022-07-19 13:44:35','2022-07-19 14:28:21','','2022-07-19 15:44:35','SYNCED','6c6fd223-601d-4256-8405-c41834d00e44',0,'2022-07-19 15:44:35','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.38.1.1.1 Ligne de finition 0\",\"name\":\"Ligne de finition 0\",\"title\":\"Maxillaire LIFI_META\",\"toothNumber\":0,\"versionMarginLine\":1}'),(1001,'6c76bb80-76df-4010-a738-de9fd2f31989','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f9d03016-567a-4bd4-9cc5-dafeea34e365/session_a7bcb190-dd19-4f3b-8aab-266030bf4064/occlusion_c321e210-b67c-40e8-bece-f8946164a768/computedocclusion_03fe87bc-2a25-4d16-a476-2df62bb3cf76/36_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_f9d03016-567a-4bd4-9cc5-dafeea34e365_ACT_a7bcb190-dd19-4f3b-8aab-266030bf4064_SESS_c321e210-b67c-40e8-bece-f8946164a768_OCC_03fe87bc-2a25-4d16-a476-2df62bb3cf76_SNAPO__SNAPS_','2022-07-04 14:14:03','2022-07-04 16:13:45','36_w1_o1_snapshot_occ_file_0.png','2022-07-04 16:14:03','SYNCED','6c76bb80-76df-4010-a738-de9fd2f31989',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'6d53bd96-2c20-488f-b9c5-69c68f762598','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/occlusion_e08bbeeb-a30b-428c-bd4a-40198f792219/computedocclusion_a503ab26-f707-4923-86b6-049c17f73533/25_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_SESS_e08bbeeb-a30b-428c-bd4a-40198f792219_OCC_a503ab26-f707-4923-86b6-049c17f73533_SNAPO__SNAPS_','2022-05-17 16:40:46','2022-05-17 18:40:25','25_w1_o1_snapshot_occ_file_0.png','2022-05-17 18:40:46','SYNCED','6d53bd96-2c20-488f-b9c5-69c68f762598',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'6d736fe2-1310-4fb3-bde6-77b8f5a985e1','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/fa942554-dda6-4d2d-b578-ae9be6b3904d/session_b6039092-51ba-40dc-86e3-23be741dbb99/occlusion_e6bd34f2-af0e-48a6-9872-ec017a776e77/scan_1c59283c-95f4-431e-8b66-62a243009081/8_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_fa942554-dda6-4d2d-b578-ae9be6b3904d_ACT_b6039092-51ba-40dc-86e3-23be741dbb99_SESS_e6bd34f2-af0e-48a6-9872-ec017a776e77_TOSC_1c59283c-95f4-431e-8b66-62a243009081_ZIP_','2022-01-24 17:23:27','2022-01-24 15:31:00','8_w1_o1_maxillaire_scan_file_0.zip','2022-01-24 18:23:27','SYNCED','6d736fe2-1310-4fb3-bde6-77b8f5a985e1',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.8.1.1.1\",\"modelMatrix\":\"-0.782965,0.61189,-0.112058,0,-0.622066,-0.770157,0.141042,0,-1.63504e-9,0.180138,0.983641,0,9.34468,-28.5555,-17.9359,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'6d7ab355-db18-40f5-a21a-830289e55df4','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/occlusion_a2220645-c79d-4dda-b6cc-772384a4106b/scan_914fba31-85f1-4c6e-85e2-bacfd3c1770c/38_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_TOSC_914fba31-85f1-4c6e-85e2-bacfd3c1770c_ZIP_','2022-07-12 11:04:03','2022-07-12 13:03:55','38_w1_o1_maxillaire_scan_file_0.zip','2022-07-12 13:04:03','SYNCED','6d7ab355-db18-40f5-a21a-830289e55df4',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.38.1.1.3\",\"modelMatrix\":\"0.292113,0.953283,-0.0769574,0,-0.956384,0.291166,-0.0235055,0,3.79853e-10,0.0804671,0.996757,0,-4.50082,-22.5707,-20.6555,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'6dae25df-ce2e-48a8-8501-220d7a313308','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_4f8dc275-857c-482a-9886-5521591e9661/scan_000f859e-bd0c-453b-b60b-dddef781cd58/12_w1_o4_maxillaire_snapshot_0.png','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_TOSC_000f859e-bd0c-453b-b60b-dddef781cd58_SNAPS_','2022-02-14 17:57:22','2022-02-14 18:48:08','12_w1_o4_maxillaire_snapshot_0.png','2022-02-14 18:57:22','SYNCED','6dae25df-ce2e-48a8-8501-220d7a313308',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.12.1.4.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'6dddc0b6-858d-41c2-badc-3eac78bfa8d2','','ZIP','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_TOSC_47ae7109-ac97-4f1b-8dd7-cc22debd4324_ZIP_','2022-07-19 13:56:03','2022-07-19 15:55:49','','2022-07-19 15:56:03','SYNCED','6dddc0b6-858d-41c2-badc-3eac78bfa8d2',0,'2022-07-19 15:56:03','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.38.1.1.4\",\"modelMatrix\":\"-0.298707,0.922945,-0.242789,0,-0.954345,-0.288879,0.0759925,0,9.14042e-10,0.254404,0.967098,0,20.3691,-25.7421,-14.8867,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'6e0bfe0c-593a-4a2e-8782-7f1e18f4d6bd','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/computedocclusion_00405f86-eefa-41f9-8d98-1fa9cbeef855/24_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_00405f86-eefa-41f9-8d98-1fa9cbeef855_TOPLY__ZIP_','2022-05-25 09:03:40','2022-05-25 11:02:54','24_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-05-25 11:03:40','SYNCED','6e0bfe0c-593a-4a2e-8782-7f1e18f4d6bd',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.3 Occlusion 4\",\"modelMatrix\":\"-0.348415,0.927523,-0.135305,0,-0.93734,-0.344766,0.0502937,0,4.16863e-09,0.14435,0.989527,0,-8.01926,-22.8232,-18.3945,1\",\"referenceScanID\":\"1.24.1.1.3\",\"title\":\"Maxillaire 1.24.1.1.3 Occlusion 4\"}'),(1001,'6e5eb213-3b0b-4c68-a8b7-4d44d6e5a4a8','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_f9c2783a-c405-481c-a97e-47bb9db0d0d2/17_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_RISC_f9c2783a-c405-481c-a97e-47bb9db0d0d2_SNAPS_','2022-02-07 11:47:27','2022-02-07 12:42:41','17_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-02-07 12:47:27','SYNCED','6e5eb213-3b0b-4c68-a8b7-4d44d6e5a4a8',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.17.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'6e5f597c-a4b6-42b0-b7fc-80e18211ffe8','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/593972a6-d7d6-4802-b87d-38aab371f71e/session_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480/occlusion_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3/scan_20c281c1-af15-40ce-8892-18a2507513e3/3_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_593972a6-d7d6-4802-b87d-38aab371f71e_ACT_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480_SESS_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3_BOSC_20c281c1-af15-40ce-8892-18a2507513e3_ZIP_','2022-01-19 15:09:22','2022-01-19 16:09:00','3_w1_o1_mandibule_scan_file_0.zip','2022-01-19 16:09:22','SYNCED','6e5f597c-a4b6-42b0-b7fc-80e18211ffe8',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.3.1.1.1\",\"modelMatrix\":\"0.888791,-0.456948,0.035335,0,0.458312,0.886146,-0.0685242,0,1.93169e-9,0.0770982,0.997023,0,-18.6308,-12.394,-21.0367,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'6e9fc174-28d5-42d8-bbc0-dd92bf08bde1','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/e922efb9-8c03-445b-8a0f-449e3c43bdca/session_a2369349-1629-40ad-8784-d271bc3fbade/occlusion_292cc1aa-8b12-463b-87a1-7d9731cf886b/computedocclusion_f9f6d9d2-cc34-43c3-9f5f-4b8e54b41bbb/21_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_e922efb9-8c03-445b-8a0f-449e3c43bdca_ACT_a2369349-1629-40ad-8784-d271bc3fbade_SESS_292cc1aa-8b12-463b-87a1-7d9731cf886b_OCC_f9f6d9d2-cc34-43c3-9f5f-4b8e54b41bbb_BOMA__MATRX_','2022-04-21 08:53:14','2022-04-21 10:53:03','21_w1_o1_mandibule_matrix_occ_file_0.m','2022-04-21 10:53:14','SYNCED','6e9fc174-28d5-42d8-bbc0-dd92bf08bde1',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.21.1.1.1 Occlusion 2\",\"referenceScanID\":\"1.21.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.21.1.1.1 Occlusion 2\"}'),(1001,'6ed107a2-54c1-4786-af15-8fac44ad82df','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_2ffbfbca-f236-4802-be93-8eb43d523274/scan_0bd54e85-3f0d-4955-9f02-7de656ad9f6f/4_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_2ffbfbca-f236-4802-be93-8eb43d523274_BOSC_0bd54e85-3f0d-4955-9f02-7de656ad9f6f_SNAPS_','2022-01-19 19:08:49','2022-01-19 20:06:56','4_w1_o1_mandibule_snapshot_1.png','2022-01-19 20:08:49','SYNCED','5fb5df68-7218-45fd-ba70-e0699bf168c3',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'6ed13785-759e-4640-96b7-73753d0c8c51','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_7048f93c-1091-4f02-bc64-b73347dfa962/24_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_RISC_7048f93c-1091-4f02-bc64-b73347dfa962_SNAPS_','2022-06-13 15:00:13','2022-06-13 17:00:06','24_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-06-13 17:00:13','SYNCED','6ed13785-759e-4640-96b7-73753d0c8c51',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.24.1.1.3\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'6edb9cce-0310-4291-9dac-49fec98d18b9','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/e922efb9-8c03-445b-8a0f-449e3c43bdca/session_a2369349-1629-40ad-8784-d271bc3fbade/occlusion_292cc1aa-8b12-463b-87a1-7d9731cf886b/scan_500ef012-99d0-4604-93eb-ec789b5a245b/21_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_e922efb9-8c03-445b-8a0f-449e3c43bdca_ACT_a2369349-1629-40ad-8784-d271bc3fbade_SESS_292cc1aa-8b12-463b-87a1-7d9731cf886b_FRSC_500ef012-99d0-4604-93eb-ec789b5a245b_SNAPS_','2022-04-21 08:49:51','2022-04-21 10:49:43','21_w1_o1_mordu_anterieur_snapshot_0.png','2022-04-21 10:49:51','SYNCED','6edb9cce-0310-4291-9dac-49fec98d18b9',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.21.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'6f4c2c37-2063-47e9-9b81-2912e4b09097','','SNAPS','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_c9079d19-8ffb-46f7-a51e-3a7a90ccae59_SESS_8ba0f3b1-408f-4a02-92a0-63f09123b68e_BOSC_30b22823-10be-472c-b053-59b470998f02_SNAPS_','2022-01-28 17:15:44','2022-01-25 13:06:26','','2022-01-28 18:15:44','SYNCED','6f4c2c37-2063-47e9-9b81-2912e4b09097',0,'2022-01-28 18:15:44','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.10.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'6f6a9b2c-99a5-4c89-9435-60646732a096','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/1c189ddc-0ee7-45e7-9d80-585dac08374a/session_01bd0635-6ec6-42cb-8561-8638bded352c/occlusion_2aa712ca-8b46-4a50-a03e-1c6a6a0c40fc/computedocclusion_727485e0-8637-4024-83d8-95544991f73f/29_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_1c189ddc-0ee7-45e7-9d80-585dac08374a_ACT_01bd0635-6ec6-42cb-8561-8638bded352c_SESS_2aa712ca-8b46-4a50-a03e-1c6a6a0c40fc_OCC_727485e0-8637-4024-83d8-95544991f73f_TOPLY__ZIP_','2022-06-03 14:07:17','2022-06-03 16:07:00','29_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-06-03 16:07:17','SYNCED','6f6a9b2c-99a5-4c89-9435-60646732a096',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.29.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.83472,0.522,-0.175383,0,-0.550675,0.791254,-0.265848,0,9.28981e-09,0.318487,0.947927,0,-14.455,-20.1962,-17.5787,1\",\"referenceScanID\":\"1.29.1.1.1\",\"title\":\"Maxillaire 1.29.1.1.1 Occlusion 1\"}'),(1001,'6fa5ad33-3773-4801-9f0b-ed36985cc55e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/533d4409-e39d-4a27-a0af-b59e6cf76ce3/session_319a8f1d-33fc-4f87-a108-b3eabda0510f/occlusion_3b38f07b-42cb-40b1-933f-365e568702e4/scan_109ca2c4-8222-4d02-9ac7-b4b93937e1e2/37_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_533d4409-e39d-4a27-a0af-b59e6cf76ce3_ACT_319a8f1d-33fc-4f87-a108-b3eabda0510f_SESS_3b38f07b-42cb-40b1-933f-365e568702e4_TOSC_109ca2c4-8222-4d02-9ac7-b4b93937e1e2_SNAPS_','2022-07-07 15:42:22','2022-07-07 17:42:09','37_w1_o1_maxillaire_snapshot_0.png','2022-07-07 17:42:22','SYNCED','6fa5ad33-3773-4801-9f0b-ed36985cc55e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.37.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'6fc1ad7b-72f9-4540-9e11-3ded800f23dc','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_04d6e3f1-19ce-4851-a9d0-40419cea7542/scan_fef6f617-40e8-4052-8a2d-9af9e39ab22d/19_w1_o2_mandibule_scan_file_0.zip','ZIP','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_04d6e3f1-19ce-4851-a9d0-40419cea7542_BOSC_fef6f617-40e8-4052-8a2d-9af9e39ab22d_ZIP_','2022-04-15 13:53:56','2022-04-15 15:53:47','19_w1_o2_mandibule_scan_file_0.zip','2022-04-15 15:53:56','SYNCED','6fc1ad7b-72f9-4540-9e11-3ded800f23dc',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.2.2\",\"modelMatrix\":\"0.985295,0.161582,-0.0555372,0,-0.17086,0.931792,-0.320266,0,1.66291e-09,0.325046,0.945698,0,4.81481,0.667092,-28.1591,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'701053d2-5dcc-443f-b666-c76eaf06528b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/de078619-3946-4adb-a799-1c260e16face/session_24d0aeb5-3058-4070-aeea-97c289e41e3c/occlusion_ea6da896-1504-41fc-890c-7c48575e9e40/scan_e7e54c23-0fb4-457b-aa49-43078736514f/2_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_de078619-3946-4adb-a799-1c260e16face_ACT_24d0aeb5-3058-4070-aeea-97c289e41e3c_SESS_ea6da896-1504-41fc-890c-7c48575e9e40_FRSC_e7e54c23-0fb4-457b-aa49-43078736514f_SNAPS_','2022-01-19 14:46:11','2022-01-19 15:45:59','2_w1_o1_mordu_anterieur_snapshot_0.png','2022-01-19 15:46:11','SYNCED','701053d2-5dcc-443f-b666-c76eaf06528b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.2.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'7033216f-6fae-4a9f-a27c-a4df8e40a06c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/d100e894-0be9-4495-94e2-e469232f7817/session_2c8b85b5-c805-4b08-85e7-3d02dab72e99/occlusion_8a278cc5-a1c1-4dfb-9ee2-c971a6309afa/scan_061005ca-b3b4-4cb2-bf80-5bae7b8fc987/15_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_d100e894-0be9-4495-94e2-e469232f7817_ACT_2c8b85b5-c805-4b08-85e7-3d02dab72e99_SESS_8a278cc5-a1c1-4dfb-9ee2-c971a6309afa_TOSC_061005ca-b3b4-4cb2-bf80-5bae7b8fc987_ZIP_','2022-02-01 15:15:50','2022-02-01 16:15:48','15_w1_o1_mandibule_scan_file_0.zip','2022-02-01 16:15:50','SYNCED','7033216f-6fae-4a9f-a27c-a4df8e40a06c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.15.1.1.1\",\"modelMatrix\":\"0.727689,0.636405,-0.255846,0,-0.685907,0.675172,-0.271431,0,1.4085e-8,0.373004,0.92783,0,-4.62287,-39.5325,-13.5601,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'707cc62e-7061-456a-8160-495b8b08c922','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_2ffbfbca-f236-4802-be93-8eb43d523274/scan_0bd54e85-3f0d-4955-9f02-7de656ad9f6f/4_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_2ffbfbca-f236-4802-be93-8eb43d523274_BOSC_0bd54e85-3f0d-4955-9f02-7de656ad9f6f_ZIP_','2022-01-19 19:08:46','2022-01-19 20:06:58','4_w1_o1_mandibule_scan_file_1.zip','2022-01-19 20:08:46','SYNCED','3d3712b8-d105-4369-a45d-93e76bd3c1f4',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.1.1\",\"modelMatrix\":\"-0.761239,0.619606,-0.191322,0,-0.648472,-0.727353,0.224592,0,-2.36675e-9,0.295035,0.955486,0,12.5557,-2.69168,-18.0113,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'70b5974b-73f4-4b7d-a247-890b7852597b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/d100e894-0be9-4495-94e2-e469232f7817/session_2c8b85b5-c805-4b08-85e7-3d02dab72e99/occlusion_8a278cc5-a1c1-4dfb-9ee2-c971a6309afa/scan_061005ca-b3b4-4cb2-bf80-5bae7b8fc987/15_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_d100e894-0be9-4495-94e2-e469232f7817_ACT_2c8b85b5-c805-4b08-85e7-3d02dab72e99_SESS_8a278cc5-a1c1-4dfb-9ee2-c971a6309afa_TOSC_061005ca-b3b4-4cb2-bf80-5bae7b8fc987_ZIP_','2022-02-01 15:16:31','2022-02-01 16:15:48','15_w1_o1_maxillaire_scan_file_1.zip','2022-02-01 16:16:31','SYNCED','7033216f-6fae-4a9f-a27c-a4df8e40a06c',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.15.1.1.1\",\"modelMatrix\":\"0.727689,0.636405,-0.255846,0,-0.685907,0.675172,-0.271431,0,1.4085e-8,0.373004,0.92783,0,-4.62287,-39.5325,-13.5601,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'71025541-ae2b-4806-8961-2faf3306885e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/scan_7b00996b-90f8-4307-9a8c-263a28f1b341/4_w1_o4_maxillaire_snapshot_2.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_TOSC_7b00996b-90f8-4307-9a8c-263a28f1b341_SNAPS_','2022-05-31 12:03:36','2022-05-31 13:55:41','4_w1_o4_maxillaire_snapshot_2.png','2022-05-31 14:03:36','SYNCED','68a7881a-ea83-4e50-b8af-b28454591c34',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.4.1.4.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'7161a896-678c-49ce-a8db-989109953ffa','','ZIP','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_c9079d19-8ffb-46f7-a51e-3a7a90ccae59_SESS_8ba0f3b1-408f-4a02-92a0-63f09123b68e_TOSC_cf1df2e4-52f9-48a2-8e0b-54a1e4ed5741_ZIP_','2022-01-28 17:15:44','2022-01-26 15:40:40','','2022-01-28 18:15:44','SYNCED','7161a896-678c-49ce-a8db-989109953ffa',0,'2022-01-28 18:15:44','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.10.1.1.1\",\"modelMatrix\":\"0.588218,0.770346,-0.246102,0,-0.808703,0.560319,-0.179005,0,-8.9354e-9,0.304318,0.952571,0,-34.3596,-30.1664,-22.2111,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'71a2825f-f78b-4482-8e0d-c6100f1cdb56','','SNAPS','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_LESC_273e24bd-58e9-4983-8fdc-d9f60e8e0de7_SNAPS_','2022-09-09 16:40:53','2022-09-09 18:33:56','','2022-09-09 18:40:53','SYNCED','71a2825f-f78b-4482-8e0d-c6100f1cdb56',0,'2022-09-09 18:40:53','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.39.1.1.6\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'71ce59d2-c248-4631-93f9-1335cd3337ca','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/4a3954e0-1e2f-4721-9fdd-4180380dc19f/session_33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416/occlusion_3accbada-5a51-4d10-88d1-c3e7d8598d6f/scan_ca26b24d-fb66-43e1-8719-cc661811d143/34_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_4a3954e0-1e2f-4721-9fdd-4180380dc19f_ACT_33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416_SESS_3accbada-5a51-4d10-88d1-c3e7d8598d6f_BOSC_ca26b24d-fb66-43e1-8719-cc661811d143_SNAPS_','2022-06-28 10:49:58','2022-06-28 12:49:35','34_w1_o1_mandibule_snapshot_0.png','2022-06-28 12:49:58','SYNCED','71ce59d2-c248-4631-93f9-1335cd3337ca',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.34.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'71d2bbfb-3fa6-4836-a72d-8509a8c942a5','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/45ff7437-0691-4427-a7da-8250862e4b96/session_4ff9c682-c09d-42ff-8c29-aeb13e066ed2/occlusion_934673c1-a4b9-4508-ac1b-a03092a0693e/scan_8d7fa4fe-ab8d-4b70-b921-fabf93cf9f25/9_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_45ff7437-0691-4427-a7da-8250862e4b96_ACT_4ff9c682-c09d-42ff-8c29-aeb13e066ed2_SESS_934673c1-a4b9-4508-ac1b-a03092a0693e_RISC_8d7fa4fe-ab8d-4b70-b921-fabf93cf9f25_ZIP_','2022-01-24 17:46:37','2022-01-24 18:45:22','9_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-01-24 18:46:37','SYNCED','71d2bbfb-3fa6-4836-a72d-8509a8c942a5',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.9.1.1.1\",\"modelMatrix\":\"0.826976,-0.148071,0.532511,0,0.10609,0.988222,0.10819,0,-0.552279,-0.0391122,0.839577,0,-10.1803,17.2042,-30.0662,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'7210d8cd-3a05-4560-b55f-80951c90c08c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/computedocclusion_d5bff097-1085-4c55-afe3-1ce57126d88f/19_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_OCC_d5bff097-1085-4c55-afe3-1ce57126d88f_TOMA__MATRX_','2022-03-08 11:16:25','2022-03-08 12:15:58','19_w1_o1_maxillaire_matrix_occ_file_0.m','2022-03-08 12:16:25','SYNCED','7210d8cd-3a05-4560-b55f-80951c90c08c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.19.1.1.1 Occlusion 2\",\"referenceScanID\":\"1.19.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.19.1.1.1 Occlusion 2\"}'),(1001,'72226bb6-e398-4d1a-8cab-cf476af66ce4','','ZIP','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_RISC_ceafbbd6-01e4-4f7a-9d71-a337153d555a_ZIP_','2022-04-21 17:37:46','2022-04-21 13:10:25','','2022-04-21 19:37:46','SYNCED','72226bb6-e398-4d1a-8cab-cf476af66ce4',0,'2022-04-21 19:37:46','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.22.1.1.1\",\"modelMatrix\":\"0.993112,-0.0138798,-0.115616,0,0.00933857,0.999845,-0.0107109,0,0.116842,0.0114836,0.99324,0,1.35324,-2.01758,-16.5083,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'7261116b-75a2-4416-a745-d880100deb03','','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_OCC_4aa37ef9-cd2d-4cfa-9436-a62cc782a27a_BOPLY__ZIP_','2022-02-04 15:01:39','2022-02-04 14:55:02','','2022-02-04 16:01:39','SYNCED','7261116b-75a2-4416-a745-d880100deb03',0,'2022-02-04 16:01:39','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.5 Occlusion 1\",\"modelMatrix\":\"0.821265,-0.551643,0.145651,0,0.570547,0.794053,-0.209655,0,5.91416e-9,0.255283,0.966866,0,-2.59195,32.4156,-27.5972,1\",\"referenceScanID\":\"1.12.1.1.5\",\"title\":\"Mandibule 1.12.1.1.5 Occlusion 1\"}'),(1001,'729cdd5a-8314-463b-bbd8-cea619e1e925','','ZIP','PATIENT_02df4b55-8d30-46ac-b34e-449ffbc4269e_ACT_ef4d16ee-fe39-4081-920a-e42ecf24a857_SESS_d0ba750a-59bf-4ba0-b876-4c1bd25d5677_TOSC_3ac5d21b-7377-44ee-9096-b54f97336106_ZIP_','2022-03-22 07:55:51','2022-03-19 11:45:59','','2022-03-22 08:55:51','SYNCED','729cdd5a-8314-463b-bbd8-cea619e1e925',0,'2022-03-22 08:55:51','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.20.1.1.1\",\"modelMatrix\":\"-0.999974,-0.00712961,0.00050452,0,0.00714744,-0.99748,0.0705857,0,-2.84132e-11,0.0705875,0.997506,0,3.4575,-1.85207,-18.1678,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'73c9cb73-3a98-4256-bc80-f01b135239bd','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_cfcda3c3-749c-4f3d-96e2-556ed558ceef/18_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_TOSC_cfcda3c3-749c-4f3d-96e2-556ed558ceef_ZIP_','2022-03-07 14:03:59','2022-03-07 15:03:44','18_w1_o1_maxillaire_scan_file_0.zip','2022-03-07 15:03:59','SYNCED','73c9cb73-3a98-4256-bc80-f01b135239bd',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.18.1.1.2\",\"modelMatrix\":\"-0.437675,-0.897964,0.0458401,0,0.899133,-0.437106,0.0223138,0,4.2805e-10,0.0509825,0.9987,0,19.3367,8.64495,-23.6403,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'749660e2-55a3-4b7b-8618-0ecb7ace7e8b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/computedocclusion_35af1bf5-285a-4bb1-a6db-fe9897defe51/23_w1_o1_mlmeta_occ_file_to1002.bin','LIFIM','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_35af1bf5-285a-4bb1-a6db-fe9897defe51_LIFIMO_LIFIM_','2022-05-25 10:46:44','2022-05-25 12:46:42','23_w1_o1_mlmeta_occ_file_to1002.bin','2022-05-25 12:46:44','SYNCED','749660e2-55a3-4b7b-8618-0ecb7ace7e8b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.23.1.1.1 Occlusion 4 Ligne de finition 2\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"Maxillaire\",\"name\":\"Ligne de finition 2\",\"title\":\"Ligne finition metadata\",\"toothNumber\":1002}'),(1001,'74b28d88-c271-4aef-ac3b-1c8d372ae615','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7f47fd88-9ea0-4c08-9193-a54d4f158c7c/session_7873a396-419c-4215-83c7-fec9f2742ccf/occlusion_2e287bb0-e19a-414a-9177-23b335d286d9/scan_05d5d943-3268-4239-ac7d-5efbc2d2ab9b/16_w1_o2_maxillaire_scan_file_0.zip','ZIP','PATIENT_7f47fd88-9ea0-4c08-9193-a54d4f158c7c_ACT_7873a396-419c-4215-83c7-fec9f2742ccf_SESS_2e287bb0-e19a-414a-9177-23b335d286d9_TOSC_05d5d943-3268-4239-ac7d-5efbc2d2ab9b_ZIP_','2022-06-03 08:48:48','2022-06-03 10:48:40','16_w1_o2_maxillaire_scan_file_0.zip','2022-06-03 10:48:48','SYNCED','74b28d88-c271-4aef-ac3b-1c8d372ae615',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.16.1.2.1\",\"modelMatrix\":\"-0.661751,0.738844,-0.12726,0,-0.749723,-0.652148,0.112327,0,-3.86758e-09,0.169743,0.985488,0,12.6776,-13.3436,-20.1604,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'74e3f855-5feb-462a-80ec-2a3e46acc509','','SNAPS','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_65f9077d-c859-4b2c-9d4d-692d723315a5_SNAPO__SNAPS_','2022-05-13 12:07:45','2022-05-13 14:07:00','','2022-05-13 14:07:45','SYNCED','74e3f855-5feb-462a-80ec-2a3e46acc509',0,'2022-05-13 14:07:45','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'74e3feba-f624-4451-927e-e5f83d567991','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/scan_2d226451-8adb-4007-be22-99a9b3af61d6/23_w1_o1_maxillaire_mlmeta_2_0.bin','LIFIM','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_TOSC_2d226451-8adb-4007-be22-99a9b3af61d6_LIFIM_','2022-05-25 10:46:43','2022-05-25 12:46:42','23_w1_o1_maxillaire_mlmeta_2_0.bin','2022-05-25 12:46:43','SYNCED','74e3feba-f624-4451-927e-e5f83d567991',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.23.1.1.1 Ligne de finition 2\",\"name\":\"Ligne de finition 2\",\"title\":\"Maxillaire LIFI_META\",\"toothNumber\":2,\"versionMarginLine\":1}'),(1001,'7581879e-bdd8-413f-b525-f9cecc54fe29','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/order_37a778ee-af03-4993-a8f5-8ce26e516db0/13_w1_autre_prost_file_7581879e-bdd8-413f-b525-f9cecc54fe29_0.pdf','PDF','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_PROST_37a778ee-af03-4993-a8f5-8ce26e516db0_PDF_','2022-02-04 18:28:44','2022-02-04 19:28:41','13_w1_autre_prost_file_7581879e-bdd8-413f-b525-f9cecc54fe29_0.pdf','2022-02-04 19:28:44','SYNCED','7581879e-bdd8-413f-b525-f9cecc54fe29',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.13.1.1 AUTRE FICHE DE PROTHESE\",\"title\":\"Autre PDF\"}'),(1001,'75ab6534-9048-449f-bd27-86687f417acf','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_72adeb31-f7a3-4840-9f93-f10e61c84bef/4_w1_o2_maxillaire_scan_file_0.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_TOSC_72adeb31-f7a3-4840-9f93-f10e61c84bef_ZIP_','2022-02-15 12:29:42','2022-02-15 13:29:31','4_w1_o2_maxillaire_scan_file_0.zip','2022-02-15 13:29:42','SYNCED','75ab6534-9048-449f-bd27-86687f417acf',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.4.1.2.1\",\"modelMatrix\":\"-0.490235,0.86217,-0.1278,0,-0.871591,-0.484936,0.0718825,0,1.34143e-09,0.146629,0.989192,0,5.4499,-24.2387,-22.3553,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'75bc0b22-b15a-42fa-8cf2-3584942783f6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/de078619-3946-4adb-a799-1c260e16face/session_24d0aeb5-3058-4070-aeea-97c289e41e3c/occlusion_ea6da896-1504-41fc-890c-7c48575e9e40/computedocclusion_a15a6719-2996-4256-93d7-515e4d4f5bef/2_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_de078619-3946-4adb-a799-1c260e16face_ACT_24d0aeb5-3058-4070-aeea-97c289e41e3c_SESS_ea6da896-1504-41fc-890c-7c48575e9e40_OCC_a15a6719-2996-4256-93d7-515e4d4f5bef_TOMA__MATRX_','2022-01-19 14:47:19','2022-01-19 15:46:49','2_w1_o1_maxillaire_matrix_occ_file_0.m','2022-01-19 15:47:19','SYNCED','75bc0b22-b15a-42fa-8cf2-3584942783f6',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.2.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.2.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.2.1.1.1 Occlusion 1\"}'),(1001,'75e9d535-e503-486c-8ceb-2a7cd0b59233','','SNAPS','PATIENT_de078619-3946-4adb-a799-1c260e16face_ACT_24d0aeb5-3058-4070-aeea-97c289e41e3c_SESS_ea6da896-1504-41fc-890c-7c48575e9e40_BOSC_c4bbad69-6205-4593-a0c3-370703a57829_SNAPS_','2022-01-19 17:01:43','2022-01-19 15:26:31','','2022-01-19 18:01:43','SYNCED','75e9d535-e503-486c-8ceb-2a7cd0b59233',0,'2022-01-19 18:01:43','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.2.1.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'75ecadc3-8c76-453d-8277-1a2ae4e32db1','','MATRX','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_OCC_4aa37ef9-cd2d-4cfa-9436-a62cc782a27a_TOMA__MATRX_','2022-02-04 15:01:40','2022-02-04 14:55:02','','2022-02-04 16:01:40','SYNCED','75ecadc3-8c76-453d-8277-1a2ae4e32db1',0,'2022-02-04 16:01:40','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.12.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.12.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.12.1.1.1 Occlusion 1\"}'),(1001,'7636e0d7-f242-431c-90a5-a65399d83ecd','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_2a7068fc-0efa-496f-ade9-aba5b0650655/12_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_2a7068fc-0efa-496f-ade9-aba5b0650655_SNAPS_','2022-02-04 11:45:00','2022-02-04 12:44:46','12_w1_o1_mandibule_snapshot_0.png','2022-02-04 12:45:00','SYNCED','7636e0d7-f242-431c-90a5-a65399d83ecd',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.5\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'7654ca8f-01b8-415b-9e19-c4f63283bc46','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/order_d440ce89-b623-4846-8974-44335ef5ecc8/24_w1_autre_prost_file_7654ca8f-01b8-415b-9e19-c4f63283bc46_0.pdf','PDF','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_PROST_d440ce89-b623-4846-8974-44335ef5ecc8_PDF_','2022-06-14 12:09:41','2022-06-14 14:09:39','24_w1_autre_prost_file_7654ca8f-01b8-415b-9e19-c4f63283bc46_0.pdf','2022-06-14 14:09:41','SYNCED','7654ca8f-01b8-415b-9e19-c4f63283bc46',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.24.1.2 AUTRE FICHE DE PROTHESE\",\"title\":\"Autre PDF\"}'),(1001,'76566ef8-b89a-4fea-87e0-c9931b617c2a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_f4b07389-264e-4772-afc3-29b2187ced21/18_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_LESC_f4b07389-264e-4772-afc3-29b2187ced21_ZIP_','2022-03-07 14:43:33','2022-03-07 15:43:32','18_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-03-07 15:43:33','SYNCED','76566ef8-b89a-4fea-87e0-c9931b617c2a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.18.1.1.1\",\"modelMatrix\":\"0.996698,-0.0718327,0.0141172,0,0.0785401,0.984466,0.159169,0,-0.022992,-0.160511,0.987162,0,-0.12545,-0.751174,-18.7896,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'76d25260-1e03-445e-97e6-40a0f4ade327','','MATRX','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_e2722784-a66c-4ece-91c0-2add756415ea_TOMA__MATRX_','2022-05-13 16:32:18','2022-05-13 18:31:42','','2022-05-13 18:32:18','SYNCED','76d25260-1e03-445e-97e6-40a0f4ade327',0,'2022-05-13 18:32:18','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.24.1.1.2 Occlusion 5\",\"referenceScanID\":\"1.24.1.1.2\",\"title\":\"Matrice Transfo. Maxillaire 1.24.1.1.2 Occlusion 5\"}'),(1001,'7757fade-a1c3-4f58-b5f4-6a8c840a1026','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7f47fd88-9ea0-4c08-9193-a54d4f158c7c/session_7873a396-419c-4215-83c7-fec9f2742ccf/occlusion_2e287bb0-e19a-414a-9177-23b335d286d9/computedocclusion_389a085b-21e0-4004-9d53-dfcb5c4bd2f1/16_w1_o2_snapshot_occ_file_0.png','SNAPS','PATIENT_7f47fd88-9ea0-4c08-9193-a54d4f158c7c_ACT_7873a396-419c-4215-83c7-fec9f2742ccf_SESS_2e287bb0-e19a-414a-9177-23b335d286d9_OCC_389a085b-21e0-4004-9d53-dfcb5c4bd2f1_SNAPO__SNAPS_','2022-06-03 09:04:40','2022-06-03 11:04:23','16_w1_o2_snapshot_occ_file_0.png','2022-06-03 11:04:40','SYNCED','7757fade-a1c3-4f58-b5f4-6a8c840a1026',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'77a65753-09fd-45ea-8312-8effe35d66c0','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/4a3954e0-1e2f-4721-9fdd-4180380dc19f/session_33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416/occlusion_3accbada-5a51-4d10-88d1-c3e7d8598d6f/computedocclusion_5775815f-f076-48af-be27-50e4dbfd3622/34_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_4a3954e0-1e2f-4721-9fdd-4180380dc19f_ACT_33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416_SESS_3accbada-5a51-4d10-88d1-c3e7d8598d6f_OCC_5775815f-f076-48af-be27-50e4dbfd3622_TOMA__MATRX_','2022-06-28 10:56:21','2022-06-28 12:55:54','34_w1_o1_maxillaire_matrix_occ_file_0.m','2022-06-28 12:56:21','SYNCED','77a65753-09fd-45ea-8312-8effe35d66c0',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.34.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.34.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.34.1.1.1 Occlusion 1\"}'),(1001,'78950e09-dd44-4ad7-8aa0-6799130478b6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/computedocclusion_d7643aed-d242-47f6-8e1a-703d4672f109/18_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_OCC_d7643aed-d242-47f6-8e1a-703d4672f109_BOPLY__ZIP_','2022-03-07 14:44:31','2022-03-07 15:44:20','18_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-03-07 15:44:31','SYNCED','78950e09-dd44-4ad7-8aa0-6799130478b6',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.18.1.1.2 Occlusion 2\",\"modelMatrix\":\"0.919793,-0.387127,0.064141,0,0.392404,0.907422,-0.150346,0,2.24171e-09,0.163456,0.986551,0,-1.76441,21.4524,-16.898,1\",\"referenceScanID\":\"1.18.1.1.2\",\"title\":\"Mandibule 1.18.1.1.2 Occlusion 2\"}'),(2,'7915052b-1509-4287-8888-c0b5f15b4551','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a4b302c-278d-4e12-ace5-f095ba0bf856/session_6206892a-2e7e-4765-ac90-b49bfb465997/occlusion_3c30231c-7cd7-4431-985b-2eaf7f6925ae/scan_587e0605-ba57-4583-83e9-a1cc32707c91/3_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_587e0605-ba57-4583-83e9-a1cc32707c91_ZIP_','2022-09-06 09:20:35','2022-08-30 10:53:39','3_w1_o1_maxillaire_scan_file_0.zip','2022-09-06 11:20:35','SYNCED','7915052b-1509-4287-8888-c0b5f15b4551',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.3.1.1.4\",\"modelMatrix\":\"0.544914,0.827333,-0.136337,0,-0.838492,0.537663,-0.0886022,0,1.16965e-09,0.162599,0.986692,0,-24.1684,-16.3159,-16.3462,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'797ff92c-f041-4f92-b744-b31285c7e136','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/computedocclusion_b903dd27-411a-4a7c-b357-1cc9a414dbdd/17_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_b903dd27-411a-4a7c-b357-1cc9a414dbdd_BOPLY__ZIP_','2022-02-12 16:54:33','2022-02-12 17:53:18','17_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-02-12 17:54:33','SYNCED','797ff92c-f041-4f92-b744-b31285c7e136',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.17.1.1.2 Occlusion 7\",\"modelMatrix\":\"-0.981109,-0.182585,0.0639297,0,0.193454,-0.925989,0.324223,0,-2.83491e-09,0.330465,0.943818,0,24.0114,15.3472,-21.0981,1\",\"referenceScanID\":\"1.17.1.1.2\",\"title\":\"Mandibule 1.17.1.1.2 Occlusion 7\"}'),(1001,'79944cf3-b4e5-436e-ac4e-af7ee9d2f8d1','','MATRX','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_e2722784-a66c-4ece-91c0-2add756415ea_BOMA__MATRX_','2022-05-13 16:32:18','2022-05-13 18:31:42','','2022-05-13 18:32:18','SYNCED','79944cf3-b4e5-436e-ac4e-af7ee9d2f8d1',0,'2022-05-13 18:32:18','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.24.1.1.1 Occlusion 5\",\"referenceScanID\":\"1.24.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.24.1.1.1 Occlusion 5\"}'),(1001,'7a1bc3ae-2bd2-4767-abb5-fe9c2bd23091','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/computedocclusion_77753fb3-75a1-45c2-9191-7a5d98206df2/24_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_77753fb3-75a1-45c2-9191-7a5d98206df2_SNAPO__SNAPS_','2022-06-14 12:07:17','2022-06-14 14:06:33','24_w1_o1_snapshot_occ_file_0.png','2022-06-14 14:07:17','SYNCED','7a1bc3ae-2bd2-4767-abb5-fe9c2bd23091',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'7a404f59-71cc-4f37-9054-92b986bb31bf','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_4f8dc275-857c-482a-9886-5521591e9661/scan_df08df19-150c-437d-8ed4-bf2826644265/12_w1_o4_mandibule_snapshot_2.png','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_BOSC_df08df19-150c-437d-8ed4-bf2826644265_SNAPS_','2022-02-18 16:21:56','2022-02-18 17:21:44','12_w1_o4_mandibule_snapshot_2.png','2022-02-18 17:21:56','SYNCED','e3598e66-59db-43ac-a342-a835944e8fab',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.4.5\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'7a692e33-2ad7-4ef5-aed9-90e94767f73c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/d100e894-0be9-4495-94e2-e469232f7817/session_2c8b85b5-c805-4b08-85e7-3d02dab72e99/occlusion_8a278cc5-a1c1-4dfb-9ee2-c971a6309afa/scan_aa48ecdd-c861-41de-8796-655dc3852c64/15_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_d100e894-0be9-4495-94e2-e469232f7817_ACT_2c8b85b5-c805-4b08-85e7-3d02dab72e99_SESS_8a278cc5-a1c1-4dfb-9ee2-c971a6309afa_FRSC_aa48ecdd-c861-41de-8796-655dc3852c64_SNAPS_','2022-02-01 15:12:44','2022-02-01 16:12:35','15_w1_o1_mordu_anterieur_snapshot_0.png','2022-02-01 16:12:44','SYNCED','7a692e33-2ad7-4ef5-aed9-90e94767f73c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.15.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'7a6dd0cf-9494-4f37-ab1d-2d816a28bd12','','SNAPS','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_c9079d19-8ffb-46f7-a51e-3a7a90ccae59_SESS_8ba0f3b1-408f-4a02-92a0-63f09123b68e_FRSC_4186a7d8-3050-4b21-ad69-cfd42fea66c5_SNAPS_','2022-01-28 17:15:44','2022-01-27 14:31:23','','2022-01-28 18:15:44','SYNCED','7a6dd0cf-9494-4f37-ab1d-2d816a28bd12',0,'2022-01-28 18:15:44','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.10.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'7a767a56-d808-44ed-af8b-93032cc3c01c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f9d03016-567a-4bd4-9cc5-dafeea34e365/session_a7bcb190-dd19-4f3b-8aab-266030bf4064/occlusion_c321e210-b67c-40e8-bece-f8946164a768/scan_21fc87fa-c767-4333-893a-3f0ab5cd76f2/36_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_f9d03016-567a-4bd4-9cc5-dafeea34e365_ACT_a7bcb190-dd19-4f3b-8aab-266030bf4064_SESS_c321e210-b67c-40e8-bece-f8946164a768_LESC_21fc87fa-c767-4333-893a-3f0ab5cd76f2_ZIP_','2022-07-04 14:12:22','2022-07-04 16:12:15','36_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-07-04 16:12:22','SYNCED','7a767a56-d808-44ed-af8b-93032cc3c01c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.36.1.1.2\",\"modelMatrix\":\"-0.948221,-0.169468,0.273029,0,0.11428,-0.973508,-0.184035,0,0.296364,-0.154065,0.944322,0,10.6477,7.79999,-20.1688,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'7a7c6ba9-78fb-4f22-8f83-8466156a75ac','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/discussion_4d12bcc3-80f2-49dc-9159-54929f160ce6/7a7c6ba9-78fb-4f22-8f83-8466156a75ac.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_426bd908-3163-4291-a697-20eacff771ab_TOPLY__ZIP_','2022-05-25 08:56:22','2022-05-16 19:57:11','7a7c6ba9-78fb-4f22-8f83-8466156a75ac.zip','2022-05-25 10:56:22','SYNCED','7a7c6ba9-78fb-4f22-8f83-8466156a75ac',0,'2022-05-25 10:56:22','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.2 Occlusion 6\",\"modelMatrix\":\"-0.80453,0.576793,-0.141569,0,-0.593912,-0.781339,0.191773,0,-6.05286e-09,0.238367,0.971175,0,0.910551,-5.61768,-25.9513,1\",\"referenceScanID\":\"1.24.1.1.2\",\"title\":\"Maxillaire 1.24.1.1.2 Occlusion 6\"}'),(1001,'7aa382e0-3722-4b51-b555-ca86b2fdea0f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/32710234-804f-46f5-899d-eed636f8a906/session_64c1427a-b91d-4675-94df-f36bd40e9b0f/occlusion_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a/computedocclusion_84d73896-4c7a-4dc0-994a-b2a70e3d1cf2/33_w2_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_32710234-804f-46f5-899d-eed636f8a906_ACT_64c1427a-b91d-4675-94df-f36bd40e9b0f_SESS_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a_OCC_84d73896-4c7a-4dc0-994a-b2a70e3d1cf2_BOMA__MATRX_','2022-06-28 09:07:06','2022-06-28 11:07:03','33_w2_o1_mandibule_matrix_occ_file_0.m','2022-06-28 11:07:06','SYNCED','7aa382e0-3722-4b51-b555-ca86b2fdea0f',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.33.2.1.1 Occlusion 1\",\"referenceScanID\":\"1.33.2.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.33.2.1.1 Occlusion 1\"}'),(1001,'7acff767-8dc0-4bd7-9333-8187e6479927','','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_cb4cdc08-5d89-48dc-80a3-2e659c55f971_BOPLY__ZIP_','2022-02-08 08:49:00','2022-02-07 18:52:17','','2022-02-08 09:49:00','SYNCED','7acff767-8dc0-4bd7-9333-8187e6479927',0,'2022-02-08 09:49:00','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.17.1.1.1 Occlusion 4\",\"modelMatrix\":\"-0.980954,-0.188901,0.0452269,0,0.19424,-0.953992,0.228406,0,1.35057e-9,0.232841,0.972515,0,27.4349,19.1019,-20.1379,1\",\"referenceScanID\":\"1.17.1.1.1\",\"title\":\"Mandibule 1.17.1.1.1 Occlusion 4\"}'),(1001,'7ad19c15-8266-4c29-bd63-8c53155064ad','','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_aa16f8ea-198d-4240-ab78-5a1f54823f0c_BOPLY__ZIP_','2022-05-16 17:48:35','2022-05-16 19:47:59','','2022-05-16 19:48:35','SYNCED','7ad19c15-8266-4c29-bd63-8c53155064ad',0,'2022-05-16 19:48:35','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.24.1.1.1 Occlusion 6\",\"modelMatrix\":\"0.852703,-0.521011,0.0380208,0,0.522396,0.850441,-0.062061,0,3.49638e-10,0.0727815,0.997348,0,-11.3911,-12.8136,-21.1334,1\",\"referenceScanID\":\"1.24.1.1.1\",\"title\":\"Mandibule 1.24.1.1.1 Occlusion 6\"}'),(1001,'7af23859-5ba5-41ff-8a79-87df077d50d3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f4fc00ec-4af8-4a15-b427-f1c5aabf6260/session_498ae60a-23f0-44fc-9730-be499bfc4b46/occlusion_8f3d6c73-3468-45a5-85c7-93bba47ec9f7/scan_a7163552-20ad-4b45-ae78-be2b0453dbd3/30_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_f4fc00ec-4af8-4a15-b427-f1c5aabf6260_ACT_498ae60a-23f0-44fc-9730-be499bfc4b46_SESS_8f3d6c73-3468-45a5-85c7-93bba47ec9f7_LESC_a7163552-20ad-4b45-ae78-be2b0453dbd3_SNAPS_','2022-06-14 13:29:52','2022-06-14 15:29:43','30_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-06-14 15:29:52','SYNCED','7af23859-5ba5-41ff-8a79-87df077d50d3',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.30.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'7b06349b-4ad9-4d66-bf24-7760cd5a84be','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_2ffbfbca-f236-4802-be93-8eb43d523274/scan_dfbb6a00-3125-4e66-bba2-7ad562b73551/4_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_2ffbfbca-f236-4802-be93-8eb43d523274_TOSC_dfbb6a00-3125-4e66-bba2-7ad562b73551_SNAPS_','2022-01-19 18:59:33','2022-01-19 19:59:09','4_w1_o1_maxillaire_snapshot_0.png','2022-01-19 19:59:33','SYNCED','7b06349b-4ad9-4d66-bf24-7760cd5a84be',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.4.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'7b1b7e50-5b0a-456a-9574-72b61f8238d2','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_2a7068fc-0efa-496f-ade9-aba5b0650655/12_w1_o1_mandibule_scan_file_3.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_2a7068fc-0efa-496f-ade9-aba5b0650655_ZIP_','2022-02-04 12:01:55','2022-02-04 12:57:01','12_w1_o1_mandibule_scan_file_3.zip','2022-02-04 13:01:55','SYNCED','44ebcd6f-57c2-4cce-96f5-f9faa1c6b373',3,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.5\",\"modelMatrix\":\"0.713807,-0.664318,0.221723,0,0.700343,0.677089,-0.225986,0,-4.22566e-9,0.316593,0.948562,0,3.53751,30.2884,-29.5645,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'7b2c0599-a564-406a-a92c-1e8ebb63ae32','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/computedocclusion_0bc29ff9-efea-448d-b521-2c39fd4faa78/19_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_OCC_0bc29ff9-efea-448d-b521-2c39fd4faa78_BOMA__MATRX_','2022-03-08 11:18:04','2022-03-08 12:17:37','19_w1_o1_mandibule_matrix_occ_file_0.m','2022-03-08 12:18:04','SYNCED','7b2c0599-a564-406a-a92c-1e8ebb63ae32',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.19.1.1.4 Occlusion 3\",\"referenceScanID\":\"1.19.1.1.4\",\"title\":\"Matrice Transfo. Mandibule 1.19.1.1.4 Occlusion 3\"}'),(1001,'7b448472-93a0-4faf-a51d-7e632836d89d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/593972a6-d7d6-4802-b87d-38aab371f71e/session_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480/occlusion_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3/computedocclusion_e23c031c-2c78-414b-840d-85b58e959fbe/3_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_593972a6-d7d6-4802-b87d-38aab371f71e_ACT_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480_SESS_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3_OCC_e23c031c-2c78-414b-840d-85b58e959fbe_TOMA__MATRX_','2022-01-19 15:28:10','2022-01-19 16:26:52','3_w1_o1_maxillaire_matrix_occ_file_0.m','2022-01-19 16:28:10','SYNCED','7b448472-93a0-4faf-a51d-7e632836d89d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.3.1.1.1 Occlusion 4\",\"referenceScanID\":\"1.3.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.3.1.1.1 Occlusion 4\"}'),(1001,'7b4cca84-e8d2-407c-be53-278f95c64d9b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/scan_1a0b9502-8df2-41a2-89eb-2def508b7462/22_w1_o1_mordu_posterieur_droit_scan_file_1.zip','ZIP','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_RISC_1a0b9502-8df2-41a2-89eb-2def508b7462_ZIP_','2022-04-21 17:38:25','2022-04-21 19:38:19','22_w1_o1_mordu_posterieur_droit_scan_file_1.zip','2022-04-21 19:38:25','SYNCED','1fc93c7d-617e-42e3-b407-18216c5a47ca',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.22.1.1.6\",\"modelMatrix\":\"-0.989729,0.00526289,-0.143837,0,-0.00941161,-1.00005,-0.00463951,0,-0.142672,0.0133764,0.989739,0,15.8973,1.46372,-15.7658,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'7ca6f680-78d4-4290-b246-10418b29f7f5','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/computedocclusion_e9bfc750-6943-42bf-8c0b-b7e1dc1803c5/1_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_OCC_e9bfc750-6943-42bf-8c0b-b7e1dc1803c5_SNAPO__SNAPS_','2022-01-19 13:04:01','2022-01-19 12:12:14','1_w1_o1_snapshot_occ_file_0.png','2022-01-19 14:04:01','SYNCED','7ca6f680-78d4-4290-b246-10418b29f7f5',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'7cec7e1d-dea8-4323-9a35-77e7166c42eb','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/computedocclusion_7c70edbe-5cb4-4244-8baf-7caf2bd7d86b/12_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_OCC_7c70edbe-5cb4-4244-8baf-7caf2bd7d86b_BOPLY__ZIP_','2022-02-04 17:59:24','2022-02-04 18:58:48','12_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-02-04 18:59:24','SYNCED','7cec7e1d-dea8-4323-9a35-77e7166c42eb',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.5 Occlusion 1\",\"modelMatrix\":\"0.821265,-0.551643,0.145651,0,0.570547,0.794053,-0.209655,0,5.91416e-9,0.255283,0.966866,0,-2.59195,32.4156,-27.5972,1\",\"referenceScanID\":\"1.12.1.1.5\",\"title\":\"Mandibule 1.12.1.1.5 Occlusion 1\"}'),(1001,'7d450445-455d-49e5-9ca6-17391bd11056','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_4f8dc275-857c-482a-9886-5521591e9661/scan_ac56bd4c-2fb3-4bde-858c-86c2586bc3e9/12_w1_o4_maxillaire_scan_file_0.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_TOSC_ac56bd4c-2fb3-4bde-858c-86c2586bc3e9_ZIP_','2022-02-14 10:22:01','2022-02-14 11:21:45','12_w1_o4_maxillaire_scan_file_0.zip','2022-02-14 11:22:01','SYNCED','7d450445-455d-49e5-9ca6-17391bd11056',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.12.1.4.1\",\"modelMatrix\":\"0.289939,0.931295,-0.220513,0,-0.957045,0.282138,-0.0668048,0,-2.02843e-09,0.23041,0.973094,0,-18.1704,-26.1606,-18.7028,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'7ec34b4e-bd8b-4125-bc39-a94b91122070','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/computedocclusion_42098ceb-3335-4f13-8aed-b29c37a5f57f/22_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_OCC_42098ceb-3335-4f13-8aed-b29c37a5f57f_TOPLY__ZIP_','2022-04-21 11:29:04','2022-04-21 13:28:43','22_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-04-21 13:29:04','SYNCED','7ec34b4e-bd8b-4125-bc39-a94b91122070',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.22.1.1.1 Occlusion 6\",\"modelMatrix\":\"0.527598,0.839702,-0.128611,0,-0.849494,0.521516,-0.0798764,0,4.31898e-09,0.151397,0.988473,0,-4.53893,-22.22,-19.046,1\",\"referenceScanID\":\"1.22.1.1.1\",\"title\":\"Maxillaire 1.22.1.1.1 Occlusion 6\"}'),(1001,'7eefa8d1-beb5-4db9-adf4-6f919d9dd7ee','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f9d03016-567a-4bd4-9cc5-dafeea34e365/session_a7bcb190-dd19-4f3b-8aab-266030bf4064/occlusion_c321e210-b67c-40e8-bece-f8946164a768/scan_90f9c577-02d8-45f3-9ac5-6c6cfeef1fa2/36_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_f9d03016-567a-4bd4-9cc5-dafeea34e365_ACT_a7bcb190-dd19-4f3b-8aab-266030bf4064_SESS_c321e210-b67c-40e8-bece-f8946164a768_BOSC_90f9c577-02d8-45f3-9ac5-6c6cfeef1fa2_ZIP_','2022-07-04 13:53:56','2022-07-04 15:53:48','36_w1_o1_mandibule_scan_file_0.zip','2022-07-04 15:53:56','SYNCED','7eefa8d1-beb5-4db9-adf4-6f919d9dd7ee',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.36.1.1.1\",\"modelMatrix\":\"-0.990067,0.139225,-0.0195784,0,-0.140595,-0.980421,0.137871,0,7.05379e-10,0.139254,0.990257,0,10.6502,0.270883,-21.469,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'7f150a86-6fec-4718-a058-cd12d7a38305','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/computedocclusion_d7643aed-d242-47f6-8e1a-703d4672f109/18_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_OCC_d7643aed-d242-47f6-8e1a-703d4672f109_BOMA__MATRX_','2022-03-07 14:44:32','2022-03-07 15:44:20','18_w1_o1_mandibule_matrix_occ_file_0.m','2022-03-07 15:44:32','SYNCED','7f150a86-6fec-4718-a058-cd12d7a38305',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.18.1.1.2 Occlusion 2\",\"referenceScanID\":\"1.18.1.1.2\",\"title\":\"Matrice Transfo. Mandibule 1.18.1.1.2 Occlusion 2\"}'),(1001,'7f170f84-f1e1-4d43-8fcb-0fe153f8a949','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/computedocclusion_0d180e89-cc7f-4718-abf6-79b3ada7fd3c/4_w1_o2_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_OCC_0d180e89-cc7f-4718-abf6-79b3ada7fd3c_TOPLY__ZIP_','2022-02-15 12:49:56','2022-02-15 13:49:40','4_w1_o2_maxillaire_occlusion_occ_file_0.zip','2022-02-15 13:49:56','SYNCED','7f170f84-f1e1-4d43-8fcb-0fe153f8a949',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.4.1.2.1 Occlusion 3\",\"modelMatrix\":\"-0.408152,0.902703,-0.13616,0,-0.912914,-0.403587,0.0608755,0,-1.7183e-09,0.149149,0.988815,0,3.7011,-24.744,-22.2405,1\",\"referenceScanID\":\"1.4.1.2.1\",\"title\":\"Maxillaire 1.4.1.2.1 Occlusion 3\"}'),(1001,'7f6a360e-6853-4644-b9e8-38e216b20de4','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/533d4409-e39d-4a27-a0af-b59e6cf76ce3/session_319a8f1d-33fc-4f87-a108-b3eabda0510f/occlusion_3b38f07b-42cb-40b1-933f-365e568702e4/scan_450a38a9-baaa-443c-b15d-b73099c5ee33/37_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_533d4409-e39d-4a27-a0af-b59e6cf76ce3_ACT_319a8f1d-33fc-4f87-a108-b3eabda0510f_SESS_3b38f07b-42cb-40b1-933f-365e568702e4_BOSC_450a38a9-baaa-443c-b15d-b73099c5ee33_ZIP_','2022-07-07 16:02:36','2022-07-07 18:02:28','37_w1_o1_mandibule_scan_file_0.zip','2022-07-07 18:02:36','SYNCED','7f6a360e-6853-4644-b9e8-38e216b20de4',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.37.1.1.1\",\"modelMatrix\":\"-0.86819,0.468903,-0.16241,0,-0.496233,-0.820374,0.284146,0,-2.07609e-10,0.327285,0.944926,0,12.7312,-21.9778,-18.4361,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'7f961e41-617e-4e30-84ef-a53f823e5acf','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/computedocclusion_2de3d2bb-d512-4514-8bed-a879b73a6028/22_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_OCC_2de3d2bb-d512-4514-8bed-a879b73a6028_BOPLY__ZIP_','2022-04-21 11:29:26','2022-04-21 13:29:16','22_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-04-21 13:29:26','SYNCED','7f961e41-617e-4e30-84ef-a53f823e5acf',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.22.1.1.1 Occlusion 7\",\"modelMatrix\":\"0.955284,-0.295231,0.0164688,0,0.29569,0.953801,-0.0532056,0,-9.04209e-10,0.0556961,0.998448,0,-1.05738,9.66348,-22.4364,1\",\"referenceScanID\":\"1.22.1.1.1\",\"title\":\"Mandibule 1.22.1.1.1 Occlusion 7\"}'),(1001,'7f962851-c777-4bcf-aed9-3de954af09bb','','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_BOSC_a1a9cef4-72fe-4dbe-928c-3831f98ecfbc_ZIP_','2022-02-19 17:53:24','2022-02-18 17:01:56','','2022-02-19 18:53:24','SYNCED','1f9724a7-2075-47b0-8aee-e88fec576ca0',2,'2022-02-19 18:53:24','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.4.4\",\"modelMatrix\":\"-0.253847,-0.962806,0.0925531,0,0.967245,-0.252682,0.0242899,0,2.7793e-10,0.0956874,0.995411,0,0.0328966,-2.05616,-25.0668,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'7fb6e5a5-0050-48c4-95d0-034a5b68e153','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/593972a6-d7d6-4802-b87d-38aab371f71e/session_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480/occlusion_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3/scan_4d153a25-3b94-464b-9b18-2966d8ae2ce6/3_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_593972a6-d7d6-4802-b87d-38aab371f71e_ACT_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480_SESS_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3_FRSC_4d153a25-3b94-464b-9b18-2966d8ae2ce6_SNAPS_','2022-01-19 15:20:34','2022-01-19 16:20:20','3_w1_o1_mordu_anterieur_snapshot_0.png','2022-01-19 16:20:34','SYNCED','7fb6e5a5-0050-48c4-95d0-034a5b68e153',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.3.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'7fc09fc3-81a3-49fd-a553-03ab9f8a113e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a0c21836-ba79-4f15-9e35-02ef8211a9e5/session_0aac522d-3c38-465a-a1e0-014166c140ac/occlusion_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042/scan_b3e360d5-eb70-4046-910f-cbac3270fd6c/7_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_a0c21836-ba79-4f15-9e35-02ef8211a9e5_ACT_0aac522d-3c38-465a-a1e0-014166c140ac_SESS_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042_TOSC_b3e360d5-eb70-4046-910f-cbac3270fd6c_ZIP_','2022-01-21 11:31:57','2022-01-21 12:31:33','7_w1_o1_maxillaire_scan_file_0.zip','2022-01-21 12:31:57','SYNCED','7fc09fc3-81a3-49fd-a553-03ab9f8a113e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.7.1.1.1\",\"modelMatrix\":\"-0.77677,0.624884,-0.0784113,0,-0.629784,-0.770726,0.0967117,0,3.07242e-9,0.124505,0.992219,0,14.2813,-22.8909,-20.0873,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'7fddb7f4-ade9-4efb-85ae-77539683dea6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/69640c87-271c-4a44-a6fa-67b01654cc27/session_5f9199b0-eb37-4ed3-8d1a-6c38505d4913/occlusion_991beec3-fe9e-4c98-a3d4-c98e4a4c2471/computedocclusion_c7bccd1e-370e-4347-8296-1bcd4c30b631/39_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_OCC_c7bccd1e-370e-4347-8296-1bcd4c30b631_TOMA__MATRX_','2022-09-10 09:46:17','2022-09-10 11:45:43','39_w1_o1_maxillaire_matrix_occ_file_0.m','2022-09-10 11:46:17','SYNCED','7fddb7f4-ade9-4efb-85ae-77539683dea6',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.39.1.1.1 Occlusion 10\",\"referenceScanID\":\"1.39.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.39.1.1.1 Occlusion 10\"}'),(1001,'7fec2d30-959d-47cf-ba48-d5cb7d8e334e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/scan_eafe4b37-e7ad-4f58-b931-a99f31f6d4a4/22_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_BOSC_eafe4b37-e7ad-4f58-b931-a99f31f6d4a4_SNAPS_','2022-04-21 10:50:46','2022-04-21 12:50:36','22_w1_o1_mandibule_snapshot_1.png','2022-04-21 12:50:46','SYNCED','62e04955-36d7-4e72-9a0b-cffb6a8463fe',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.22.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'80093ded-a48f-45ee-95e5-aea0e4d6100f','','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_BOSC_4aa73b1e-d6d0-436c-8abe-c649026c7ff2_ZIP_','2022-02-19 17:53:24','2022-02-14 19:11:35','','2022-02-19 18:53:24','SYNCED','a47f7028-b44e-4922-80ba-98156019677c',1,'2022-02-19 18:53:24','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.4.1\",\"modelMatrix\":\"-0.860708,-0.503908,0.0725143,0,0.509098,-0.851933,0.122596,0,2.77008e-09,0.142437,0.989804,0,18.9902,16.8499,-23.097,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'800a13fa-89b5-4193-bf7b-bf2a1c5ec28f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/computedocclusion_864c98a3-fcf7-466a-b999-13bd4dfb8c65/23_w1_o1_mlmeta_occ_file_to1001.bin','LIFIM','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_864c98a3-fcf7-466a-b999-13bd4dfb8c65_LIFIMO_LIFIM_','2022-05-25 10:45:10','2022-05-25 12:45:09','23_w1_o1_mlmeta_occ_file_to1001.bin','2022-05-25 12:45:10','SYNCED','800a13fa-89b5-4193-bf7b-bf2a1c5ec28f',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.23.1.1.1 Occlusion 3 Ligne de finition 1\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"Maxillaire\",\"name\":\"Ligne de finition 1\",\"title\":\"Ligne finition metadata\",\"toothNumber\":1001}'),(1001,'803a5a7f-c846-41ee-9190-6d020a343c0b','','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_9440baee-a8bf-406c-bc0a-f5e9596f197b_SNAPO__SNAPS_','2022-05-13 16:14:04','2022-05-13 18:13:11','','2022-05-13 18:14:04','SYNCED','803a5a7f-c846-41ee-9190-6d020a343c0b',0,'2022-05-13 18:14:04','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'80740dcf-ef50-473b-bf6b-dbd21bab0839','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/986374de-c4d7-4d6f-bf0c-2dc7e3b859a9/session_c81670ed-4144-4347-b19e-8057d11b5f7c/occlusion_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be/computedocclusion_7a5acfd0-87ca-4009-aa4e-677a88ceffde/28_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_986374de-c4d7-4d6f-bf0c-2dc7e3b859a9_ACT_c81670ed-4144-4347-b19e-8057d11b5f7c_SESS_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be_OCC_7a5acfd0-87ca-4009-aa4e-677a88ceffde_TOPLY__ZIP_','2022-05-31 10:54:12','2022-05-31 12:53:55','28_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-05-31 12:54:12','SYNCED','80740dcf-ef50-473b-bf6b-dbd21bab0839',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.28.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.881614,0.469845,-0.0447426,0,-0.471971,0.877644,-0.0835766,0,-1.4504e-09,0.0947996,0.995496,0,-11.2843,-18.9837,-19.8455,1\",\"referenceScanID\":\"1.28.1.1.1\",\"title\":\"Maxillaire 1.28.1.1.1 Occlusion 1\"}'),(1001,'8092dcf3-d2f4-4b48-8165-79c4350ba9e2','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_2a7068fc-0efa-496f-ade9-aba5b0650655/12_w1_o1_mandibule_scan_file_5.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_2a7068fc-0efa-496f-ade9-aba5b0650655_ZIP_','2022-02-04 12:03:03','2022-02-04 13:01:39','12_w1_o1_mandibule_scan_file_5.zip','2022-02-04 13:03:03','SYNCED','44ebcd6f-57c2-4cce-96f5-f9faa1c6b373',5,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.5\",\"modelMatrix\":\"0.733745,-0.643824,0.217047,0,0.679425,0.695298,-0.2344,0,-4.52824e-9,0.319456,0.947601,0,1.99189,29.7441,-29.4896,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'80d822aa-8c38-4390-bdc1-0b044f167d73','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/de078619-3946-4adb-a799-1c260e16face/session_24d0aeb5-3058-4070-aeea-97c289e41e3c/occlusion_ea6da896-1504-41fc-890c-7c48575e9e40/scan_aa24138a-68e8-4bc3-9a5d-d617f0fe496b/2_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_de078619-3946-4adb-a799-1c260e16face_ACT_24d0aeb5-3058-4070-aeea-97c289e41e3c_SESS_ea6da896-1504-41fc-890c-7c48575e9e40_TOSC_aa24138a-68e8-4bc3-9a5d-d617f0fe496b_ZIP_','2022-01-19 14:01:46','2022-01-19 15:01:29','2_w1_o1_maxillaire_scan_file_0.zip','2022-01-19 15:01:46','SYNCED','80d822aa-8c38-4390-bdc1-0b044f167d73',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.2.1.1.1\",\"modelMatrix\":\"0.994941,0.0949868,-0.0327181,0,-0.100464,0.9407,-0.324023,0,5.62813e-10,0.325671,0.945483,0,-20.9401,-37.2969,-22.6714,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'80ec1edf-c2f7-4914-86c8-ba85dac6448a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_909d9ecd-46b3-4692-868e-f6405507ecd1/24_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_TOSC_909d9ecd-46b3-4692-868e-f6405507ecd1_SNAPS_','2022-05-13 14:40:37','2022-05-13 16:40:24','24_w1_o1_maxillaire_snapshot_0.png','2022-05-13 16:40:37','SYNCED','80ec1edf-c2f7-4914-86c8-ba85dac6448a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'80fac73f-4e14-44dd-b7e3-5b5fd926bcb2','','MATRX','PATIENT_593972a6-d7d6-4802-b87d-38aab371f71e_ACT_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480_SESS_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3_OCC_4e1258a6-b789-451f-bfe8-8b395e1129d8_TOMA__MATRX_','2022-01-19 15:25:10','2022-01-19 16:24:43','',NULL,'CREATED','80fac73f-4e14-44dd-b7e3-5b5fd926bcb2',0,'2022-01-19 16:25:10','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.3.1.1.1 Occlusion 3\",\"referenceScanID\":\"1.3.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.3.1.1.1 Occlusion 3\"}'),(1001,'815860cb-19c9-4171-93d6-ec345254eb3e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/occlusion_a2220645-c79d-4dda-b6cc-772384a4106b/computedocclusion_cf412dab-1d83-4db0-ae1b-d2724d5be97d/38_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_OCC_cf412dab-1d83-4db0-ae1b-d2724d5be97d_BOPLY__ZIP_','2022-07-12 11:04:23','2022-07-12 13:04:14','38_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-07-12 13:04:23','SYNCED','815860cb-19c9-4171-93d6-ec345254eb3e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.38.1.1.1 Occlusion 2\",\"modelMatrix\":\"-0.751938,0.649871,-0.110711,0,-0.659234,-0.741259,0.12628,0,-8.33225e-09,0.167939,0.985797,0,9.41783,-30.192,-17.274,1\",\"referenceScanID\":\"1.38.1.1.1\",\"title\":\"Mandibule 1.38.1.1.1 Occlusion 2\"}'),(1001,'815d4a5a-3f95-4f4d-bdb2-1da2d1652a51','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_fde05ea2-d0fd-419b-ba13-bf1a1bd03a22/18_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_BOSC_fde05ea2-d0fd-419b-ba13-bf1a1bd03a22_ZIP_','2022-03-07 14:28:30','2022-03-07 15:28:18','18_w1_o1_mandibule_scan_file_1.zip','2022-03-07 15:28:30','SYNCED','6638ad2b-84e9-4c08-ad38-98e12dae4a45',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.18.1.1.2\",\"modelMatrix\":\"0.919793,-0.387127,0.064141,0,0.392404,0.907422,-0.150346,0,2.24171e-09,0.163456,0.986551,0,-1.76441,21.4524,-16.898,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'81ab663b-3f7f-440e-bc5e-0b3f41373259','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/computedocclusion_6960b50e-6f78-4f83-9303-8c985410457c/4_w1_o4_snapshot_occ_file_0.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_OCC_6960b50e-6f78-4f83-9303-8c985410457c_SNAPO__SNAPS_','2022-05-31 14:56:07','2022-05-31 16:55:44','4_w1_o4_snapshot_occ_file_0.png','2022-05-31 16:56:07','SYNCED','81ab663b-3f7f-440e-bc5e-0b3f41373259',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'81ec8405-393a-486b-974a-31e4794db9ba','','MATRX','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_OCC_a525c976-46dd-42bc-abc1-c7cf71f9a1f1_BOMA__MATRX_','2022-02-07 11:15:30','2022-02-04 14:58:28','','2022-02-07 12:15:30','SYNCED','81ec8405-393a-486b-974a-31e4794db9ba',0,'2022-02-07 12:15:30','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.12.1.1.5 Occlusion 1\",\"referenceScanID\":\"1.12.1.1.5\",\"title\":\"Matrice Transfo. Mandibule 1.12.1.1.5 Occlusion 1\"}'),(1001,'829ffd44-c4bc-4933-8b47-bd648efb8221','','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_OCC_a525c976-46dd-42bc-abc1-c7cf71f9a1f1_BOPLY__ZIP_','2022-02-07 11:15:31','2022-02-04 14:58:28','','2022-02-07 12:15:31','SYNCED','829ffd44-c4bc-4933-8b47-bd648efb8221',0,'2022-02-07 12:15:31','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.5 Occlusion 1\",\"modelMatrix\":\"0.821265,-0.551643,0.145651,0,0.570547,0.794053,-0.209655,0,5.91416e-9,0.255283,0.966866,0,-2.59195,32.4156,-27.5972,1\",\"referenceScanID\":\"1.12.1.1.5\",\"title\":\"Mandibule 1.12.1.1.5 Occlusion 1\"}'),(1001,'82b96208-37c7-4afb-8cb7-2139b6f0227e','','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_BOSC_4aa73b1e-d6d0-436c-8abe-c649026c7ff2_SNAPS_','2022-02-19 17:53:24','2022-02-14 18:57:20','','2022-02-19 18:53:24','SYNCED','82b96208-37c7-4afb-8cb7-2139b6f0227e',0,'2022-02-19 18:53:24','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.4.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'82de4186-a7d9-4d61-87ed-a4ef94f0ce68','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/533d4409-e39d-4a27-a0af-b59e6cf76ce3/session_319a8f1d-33fc-4f87-a108-b3eabda0510f/occlusion_3b38f07b-42cb-40b1-933f-365e568702e4/scan_109ca2c4-8222-4d02-9ac7-b4b93937e1e2/37_w1_o1_maxillaire_scan_file_3.zip','ZIP','PATIENT_533d4409-e39d-4a27-a0af-b59e6cf76ce3_ACT_319a8f1d-33fc-4f87-a108-b3eabda0510f_SESS_3b38f07b-42cb-40b1-933f-365e568702e4_TOSC_109ca2c4-8222-4d02-9ac7-b4b93937e1e2_ZIP_','2022-07-07 16:05:55','2022-07-07 18:05:44','37_w1_o1_maxillaire_scan_file_3.zip','2022-07-07 18:05:55','SYNCED','0192b393-b665-47d2-aaac-671ff4a06d5c',3,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.37.1.1.1\",\"modelMatrix\":\"0.575392,0.796207,-0.187024,0,-0.817878,0.560146,-0.131575,0,-7.09343e-09,0.22867,0.973504,0,5.4577,-25.4107,-17.9502,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'82e8db17-5fea-47ae-80d5-6e8bb12e5f9c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/order_e183d0b1-c9b1-419a-b14b-8ccde159219c/19_w1_autre_prost_file_82e8db17-5fea-47ae-80d5-6e8bb12e5f9c_0.pdf','PDF','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_PROST_e183d0b1-c9b1-419a-b14b-8ccde159219c_PDF_','2022-03-09 08:01:40','2022-03-09 09:01:37','19_w1_autre_prost_file_82e8db17-5fea-47ae-80d5-6e8bb12e5f9c_0.pdf','2022-03-09 09:01:40','SYNCED','82e8db17-5fea-47ae-80d5-6e8bb12e5f9c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.19.1.1 AUTRE FICHE DE PROTHESE\",\"title\":\"Autre PDF\"}'),(1001,'831e4532-3962-4547-af55-74e75647063d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/4a3954e0-1e2f-4721-9fdd-4180380dc19f/session_33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416/occlusion_3accbada-5a51-4d10-88d1-c3e7d8598d6f/computedocclusion_5775815f-f076-48af-be27-50e4dbfd3622/34_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_4a3954e0-1e2f-4721-9fdd-4180380dc19f_ACT_33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416_SESS_3accbada-5a51-4d10-88d1-c3e7d8598d6f_OCC_5775815f-f076-48af-be27-50e4dbfd3622_SNAPO__SNAPS_','2022-06-28 10:56:23','2022-06-28 12:55:54','34_w1_o1_snapshot_occ_file_0.png','2022-06-28 12:56:23','SYNCED','831e4532-3962-4547-af55-74e75647063d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'83246ce2-0d72-4319-a131-12ed4b4419a9','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_c76850a7-9433-47f8-825d-ced9f35dede0/24_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_BOSC_c76850a7-9433-47f8-825d-ced9f35dede0_SNAPS_','2022-05-13 14:11:03','2022-05-13 16:10:50','24_w1_o1_mandibule_snapshot_0.png','2022-05-13 16:11:03','SYNCED','83246ce2-0d72-4319-a131-12ed4b4419a9',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.24.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'833d41bc-57cd-41cd-85e4-fc650bc0c886','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a0c21836-ba79-4f15-9e35-02ef8211a9e5/session_0aac522d-3c38-465a-a1e0-014166c140ac/occlusion_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042/scan_c3e689b6-6028-4fc6-9373-eab430b52625/7_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_a0c21836-ba79-4f15-9e35-02ef8211a9e5_ACT_0aac522d-3c38-465a-a1e0-014166c140ac_SESS_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042_LESC_c3e689b6-6028-4fc6-9373-eab430b52625_SNAPS_','2022-01-21 12:04:49','2022-01-21 13:04:33','7_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-01-21 13:04:49','SYNCED','833d41bc-57cd-41cd-85e4-fc650bc0c886',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.7.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'83b22557-d465-4536-b879-b5e8ba185d00','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/e922efb9-8c03-445b-8a0f-449e3c43bdca/session_a2369349-1629-40ad-8784-d271bc3fbade/order_08c2f5cb-1a54-4450-97e5-7e8bb6d72785/21_w1_autre_prost_file_83b22557-d465-4536-b879-b5e8ba185d00_0.pdf','PDF','PATIENT_e922efb9-8c03-445b-8a0f-449e3c43bdca_ACT_a2369349-1629-40ad-8784-d271bc3fbade_PROST_08c2f5cb-1a54-4450-97e5-7e8bb6d72785_PDF_','2022-04-21 13:43:42','2022-04-21 15:43:40','21_w1_autre_prost_file_83b22557-d465-4536-b879-b5e8ba185d00_0.pdf','2022-04-21 15:43:42','SYNCED','83b22557-d465-4536-b879-b5e8ba185d00',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.21.1.1 AUTRE FICHE DE PROTHESE\",\"title\":\"Autre PDF\"}'),(1001,'8455543e-ffff-43df-bb30-d3cae8c01e44','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/scan_7b00996b-90f8-4307-9a8c-263a28f1b341/4_w1_o4_maxillaire_snapshot_1.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_TOSC_7b00996b-90f8-4307-9a8c-263a28f1b341_SNAPS_','2022-05-31 11:53:50','2022-05-31 13:53:37','4_w1_o4_maxillaire_snapshot_1.png','2022-05-31 13:53:50','SYNCED','68a7881a-ea83-4e50-b8af-b28454591c34',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.4.1.4.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'84740299-1f4d-41e0-ac34-8854d80684e2','','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_OCC_4aa37ef9-cd2d-4cfa-9436-a62cc782a27a_TOPLY__ZIP_','2022-02-04 15:01:40','2022-02-04 14:55:02','','2022-02-04 16:01:40','SYNCED','84740299-1f4d-41e0-ac34-8854d80684e2',0,'2022-02-04 16:01:40','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.12.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.622652,0.772747,-0.123153,0,-0.782499,0.614892,-0.0979959,0,-5.00422e-9,0.157385,0.987537,0,-21.5256,-19.2669,-19.1349,1\",\"referenceScanID\":\"1.12.1.1.1\",\"title\":\"Maxillaire 1.12.1.1.1 Occlusion 1\"}'),(1001,'848ef817-dbc7-482b-a5da-58b2b9fffcd1','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/fa7fa96b-f393-4b9a-8198-144702462cfa/session_4bed076c-8541-4a2f-800a-5aeb4cb49de5/occlusion_16b82fca-4b65-4866-af87-1f6dbb42f5dc/computedocclusion_94a0167c-6798-4c78-a76c-cb9fc91ccdda/35_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_fa7fa96b-f393-4b9a-8198-144702462cfa_ACT_4bed076c-8541-4a2f-800a-5aeb4cb49de5_SESS_16b82fca-4b65-4866-af87-1f6dbb42f5dc_OCC_94a0167c-6798-4c78-a76c-cb9fc91ccdda_TOMA__MATRX_','2022-06-28 15:03:44','2022-06-28 17:03:25','35_w1_o1_maxillaire_matrix_occ_file_0.m','2022-06-28 17:03:44','SYNCED','848ef817-dbc7-482b-a5da-58b2b9fffcd1',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.35.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.35.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.35.1.1.1 Occlusion 1\"}'),(1001,'84e32701-3099-4943-babb-39906f06e7db','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/207d6dbc-c19b-4726-a9b3-16235ae554cc/session_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35/occlusion_dc5762a3-c453-4166-8c86-82d23ac9f8a6/computedocclusion_3a1fff1c-0427-409c-aa94-06326e554d82/27_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_207d6dbc-c19b-4726-a9b3-16235ae554cc_ACT_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35_SESS_dc5762a3-c453-4166-8c86-82d23ac9f8a6_OCC_3a1fff1c-0427-409c-aa94-06326e554d82_TOMA__MATRX_','2022-05-30 11:09:39','2022-05-30 13:09:22','27_w1_o1_maxillaire_matrix_occ_file_0.m','2022-05-30 13:09:39','SYNCED','84e32701-3099-4943-babb-39906f06e7db',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.27.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.27.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.27.1.1.1 Occlusion 1\"}'),(1001,'853e2356-bdec-4762-8140-becfdb0d014d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/computedocclusion_704a0750-2a24-448f-8f30-928139977895/4_w1_o2_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_OCC_704a0750-2a24-448f-8f30-928139977895_TOMA__MATRX_','2022-03-08 11:49:51','2022-03-08 12:49:34','4_w1_o2_maxillaire_matrix_occ_file_0.m','2022-03-08 12:49:51','SYNCED','853e2356-bdec-4762-8140-becfdb0d014d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.4.1.2.1 Occlusion 4\",\"referenceScanID\":\"1.4.1.2.1\",\"title\":\"Matrice Transfo. Maxillaire 1.4.1.2.1 Occlusion 4\"}'),(1001,'855f70ca-d5a8-443f-a159-e143b241ef33','','MATRX','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_OCC_e9a397c8-e329-4471-985b-0eb40ed458b0_BOMA__MATRX_','2022-02-04 15:01:40','2022-02-04 14:50:30','','2022-02-04 16:01:40','SYNCED','855f70ca-d5a8-443f-a159-e143b241ef33',0,'2022-02-04 16:01:40','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.12.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.12.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.12.1.1.1 Occlusion 1\"}'),(1001,'857f1cd7-a7cf-432d-ad31-31819c36b9f2','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/1c189ddc-0ee7-45e7-9d80-585dac08374a/session_01bd0635-6ec6-42cb-8561-8638bded352c/occlusion_2aa712ca-8b46-4a50-a03e-1c6a6a0c40fc/scan_2b27113d-3b20-4d7e-8591-1e87c6e97f79/29_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_1c189ddc-0ee7-45e7-9d80-585dac08374a_ACT_01bd0635-6ec6-42cb-8561-8638bded352c_SESS_2aa712ca-8b46-4a50-a03e-1c6a6a0c40fc_BOSC_2b27113d-3b20-4d7e-8591-1e87c6e97f79_ZIP_','2022-06-03 14:01:21','2022-06-03 16:01:13','29_w1_o1_mandibule_scan_file_0.zip','2022-06-03 16:01:21','SYNCED','857f1cd7-a7cf-432d-ad31-31819c36b9f2',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.29.1.1.1\",\"modelMatrix\":\"0.32521,0.939942,-0.103669,0,-0.945642,0.323249,-0.035652,0,-2.34477e-09,0.109628,0.993973,0,-1.47724,-13.3603,-18.8662,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'86411b04-6731-49a3-b09f-936337ac02f5','','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_OCC_764b8e22-8600-49e3-8d7c-d619725096ee_BOPLY__ZIP_','2022-02-04 18:20:41','2022-02-04 19:19:48','',NULL,'CREATED','86411b04-6731-49a3-b09f-936337ac02f5',0,'2022-02-04 19:20:41','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.5 Occlusion 2\",\"modelMatrix\":\"-0.996857,-0.0768567,0.0192233,0,0.0792243,-0.967066,0.241882,0,1.71456e-9,0.242644,0.970115,0,23.7843,9.22152,-23.0024,1\",\"referenceScanID\":\"1.13.1.1.5\",\"title\":\"Mandibule 1.13.1.1.5 Occlusion 2\"}'),(1001,'86743da6-1ee0-44f8-a265-3c6de7c6342a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/occlusion_e08bbeeb-a30b-428c-bd4a-40198f792219/computedocclusion_a503ab26-f707-4923-86b6-049c17f73533/25_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_SESS_e08bbeeb-a30b-428c-bd4a-40198f792219_OCC_a503ab26-f707-4923-86b6-049c17f73533_BOMA__MATRX_','2022-05-17 16:40:45','2022-05-17 18:40:25','25_w1_o1_mandibule_matrix_occ_file_0.m','2022-05-17 18:40:45','SYNCED','86743da6-1ee0-44f8-a265-3c6de7c6342a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.25.1.1.2 Occlusion 1\",\"referenceScanID\":\"1.25.1.1.2\",\"title\":\"Matrice Transfo. Mandibule 1.25.1.1.2 Occlusion 1\"}'),(1001,'871e24f4-6581-4908-8713-9be13e9edaee','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/69640c87-271c-4a44-a6fa-67b01654cc27/session_5f9199b0-eb37-4ed3-8d1a-6c38505d4913/occlusion_991beec3-fe9e-4c98-a3d4-c98e4a4c2471/scan_b06956a5-97b1-485d-b20a-8c33bd91a0ed/39_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_TOSC_b06956a5-97b1-485d-b20a-8c33bd91a0ed_SNAPS_','2022-09-09 16:14:04','2022-09-09 18:04:15','39_w1_o1_maxillaire_snapshot_0.png','2022-09-09 18:14:04','SYNCED','871e24f4-6581-4908-8713-9be13e9edaee',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.39.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'87755a4f-dd8f-4169-b738-20996e645f56','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/scan_f2bad12a-451d-406d-98b0-e431a37951dd/19_w1_o1_mandibule_scan_file_4.zip','ZIP','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_BOSC_f2bad12a-451d-406d-98b0-e431a37951dd_ZIP_','2022-03-08 11:20:54','2022-03-08 12:20:45','19_w1_o1_mandibule_scan_file_4.zip','2022-03-08 12:20:54','SYNCED','e3a545cc-fe2a-418f-9896-979b09c1f684',4,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.1.4\",\"modelMatrix\":\"-0.997375,0.0673092,-0.0266838,0,-0.0724055,-0.927175,0.367565,0,1.7712e-09,0.368533,0.929615,0,24.2057,-23.2621,-22.074,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'87bda901-4876-4455-b2fb-8e60ef75b135','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/986374de-c4d7-4d6f-bf0c-2dc7e3b859a9/session_c81670ed-4144-4347-b19e-8057d11b5f7c/occlusion_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be/scan_67168b1b-2bef-47a9-8e7f-994731a82831/28_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_986374de-c4d7-4d6f-bf0c-2dc7e3b859a9_ACT_c81670ed-4144-4347-b19e-8057d11b5f7c_SESS_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be_BOSC_67168b1b-2bef-47a9-8e7f-994731a82831_SNAPS_','2022-05-31 10:50:31','2022-05-31 12:50:22','28_w1_o1_mandibule_snapshot_1.png','2022-05-31 12:50:31','SYNCED','bb28b621-dccb-4c99-8175-e391881f0c0e',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.28.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'87de1c3d-bc9e-4ad8-b453-1999183a60da','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/69640c87-271c-4a44-a6fa-67b01654cc27/session_5f9199b0-eb37-4ed3-8d1a-6c38505d4913/occlusion_991beec3-fe9e-4c98-a3d4-c98e4a4c2471/scan_5f9e4be9-4eec-45c8-937d-583b1a5e8642/39_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_BOSC_5f9e4be9-4eec-45c8-937d-583b1a5e8642_ZIP_','2022-09-09 16:14:15','2022-09-09 18:14:04','39_w1_o1_mandibule_scan_file_0.zip','2022-09-09 18:14:15','SYNCED','87de1c3d-bc9e-4ad8-b453-1999183a60da',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.39.1.1.1\",\"modelMatrix\":\"-0.977808,0.200729,-0.0599951,0,-0.209503,-0.936857,0.280013,0,3.36067e-09,0.286368,0.95812,0,23.2439,5.67049,-19.9331,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'87f8ddbc-407e-47c4-9fb5-a72ab20b2c82','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/scan_c1f909ab-5469-4839-84f1-d04759dd1237/1_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_BOSC_c1f909ab-5469-4839-84f1-d04759dd1237_SNAPS_','2022-01-19 12:59:28','2022-01-19 11:56:05','1_w1_o1_mandibule_snapshot_1.png','2022-01-19 13:59:28','SYNCED','ae626f34-952a-4c2f-ac1a-1aad95d218b5',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.1.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'8807cbe4-80d2-4af2-9e28-4ad511514e42','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/computedocclusion_d5bff097-1085-4c55-afe3-1ce57126d88f/19_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_OCC_d5bff097-1085-4c55-afe3-1ce57126d88f_BOPLY__ZIP_','2022-03-08 11:16:13','2022-03-08 12:15:58','19_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-03-08 12:16:13','SYNCED','8807cbe4-80d2-4af2-9e28-4ad511514e42',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.1.4 Occlusion 2\",\"modelMatrix\":\"-0.988793,0.145775,-0.0322113,0,-0.149292,-0.965503,0.213343,0,-2.16806e-09,0.215761,0.976446,0,23.0578,-21.2539,-25.059,1\",\"referenceScanID\":\"1.19.1.1.4\",\"title\":\"Mandibule 1.19.1.1.4 Occlusion 2\"}'),(1001,'88162920-1788-49ea-ae0d-e172762106ef','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/scan_999aa1db-d517-4b25-8095-2a4a53e4d5af/4_w1_o4_mordu_anterieur_scan_file_0.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_FRSC_999aa1db-d517-4b25-8095-2a4a53e4d5af_ZIP_','2022-05-31 12:07:26','2022-05-31 14:07:19','4_w1_o4_mordu_anterieur_scan_file_0.zip','2022-05-31 14:07:26','SYNCED','88162920-1788-49ea-ae0d-e172762106ef',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.4.1.4.1\",\"modelMatrix\":\"0.942484,-0.00016389,-0.32861,0,0.0846161,0.979005,0.174406,0,0.323822,-0.205455,0.928457,0,-2.77743,12.6811,-23.5226,1\",\"title\":\"Mordu anterieur ZIP\"}'),(1001,'881fa71e-8ff2-48d9-90d7-929e8ee439ed','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/e922efb9-8c03-445b-8a0f-449e3c43bdca/session_a2369349-1629-40ad-8784-d271bc3fbade/occlusion_292cc1aa-8b12-463b-87a1-7d9731cf886b/computedocclusion_f9f6d9d2-cc34-43c3-9f5f-4b8e54b41bbb/21_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_e922efb9-8c03-445b-8a0f-449e3c43bdca_ACT_a2369349-1629-40ad-8784-d271bc3fbade_SESS_292cc1aa-8b12-463b-87a1-7d9731cf886b_OCC_f9f6d9d2-cc34-43c3-9f5f-4b8e54b41bbb_SNAPO__SNAPS_','2022-04-21 08:53:24','2022-04-21 10:53:03','21_w1_o1_snapshot_occ_file_0.png','2022-04-21 10:53:24','SYNCED','881fa71e-8ff2-48d9-90d7-929e8ee439ed',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'8828114d-b2b9-4aee-b553-1025354571bd','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a0c21836-ba79-4f15-9e35-02ef8211a9e5/session_0aac522d-3c38-465a-a1e0-014166c140ac/occlusion_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042/scan_dda4ec6d-010a-4593-be9f-97cb59747424/7_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_a0c21836-ba79-4f15-9e35-02ef8211a9e5_ACT_0aac522d-3c38-465a-a1e0-014166c140ac_SESS_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042_BOSC_dda4ec6d-010a-4593-be9f-97cb59747424_SNAPS_','2022-01-21 11:56:13','2022-01-21 12:49:05','7_w1_o1_mandibule_snapshot_0.png','2022-01-21 12:56:13','SYNCED','8828114d-b2b9-4aee-b553-1025354571bd',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.7.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'883e54e7-1599-4931-8155-5059841504be','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a4b302c-278d-4e12-ace5-f095ba0bf856/session_6206892a-2e7e-4765-ac90-b49bfb465997/occlusion_7ec70f78-dc80-40c5-b293-570a59f034c4/scan_9ad9c2d5-a3f4-4d4d-a153-085fbf878be4/3_w1_o2_maxillaire_scan_file_0.zip','ZIP','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_7ec70f78-dc80-40c5-b293-570a59f034c4_TOSC_9ad9c2d5-a3f4-4d4d-a153-085fbf878be4_ZIP_','2022-09-06 09:20:27','2022-08-30 14:24:50','3_w1_o2_maxillaire_scan_file_0.zip','2022-09-06 11:20:27','SYNCED','883e54e7-1599-4931-8155-5059841504be',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.3.1.2.4\",\"modelMatrix\":\"0.899865,0.418474,-0.122975,0,-0.436169,0.863358,-0.25371,0,-2.79404e-09,0.281943,0.959431,0,-27.175,-4.50248,-15.2315,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'888bb95f-87d1-41f4-8484-d4032b4e50da','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/69640c87-271c-4a44-a6fa-67b01654cc27/session_5f9199b0-eb37-4ed3-8d1a-6c38505d4913/occlusion_991beec3-fe9e-4c98-a3d4-c98e4a4c2471/scan_b06956a5-97b1-485d-b20a-8c33bd91a0ed/39_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_TOSC_b06956a5-97b1-485d-b20a-8c33bd91a0ed_ZIP_','2022-09-09 16:04:32','2022-09-09 18:04:17','39_w1_o1_maxillaire_scan_file_0.zip','2022-09-09 18:04:32','SYNCED','888bb95f-87d1-41f4-8484-d4032b4e50da',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.39.1.1.1\",\"modelMatrix\":\"-0.226177,0.929302,-0.291961,0,-0.974086,-0.215779,0.0677916,0,7.55513e-09,0.299728,0.954025,0,-12.3361,-28.543,-16.1754,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'88efb696-eab9-4f14-8212-702210d91d21','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/de078619-3946-4adb-a799-1c260e16face/session_24d0aeb5-3058-4070-aeea-97c289e41e3c/occlusion_ea6da896-1504-41fc-890c-7c48575e9e40/scan_cf9b0360-b96a-4e1a-a219-fdaa6228f9f7/2_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_de078619-3946-4adb-a799-1c260e16face_ACT_24d0aeb5-3058-4070-aeea-97c289e41e3c_SESS_ea6da896-1504-41fc-890c-7c48575e9e40_BOSC_cf9b0360-b96a-4e1a-a219-fdaa6228f9f7_ZIP_','2022-01-19 14:38:49','2022-01-19 15:38:26','2_w1_o1_mandibule_scan_file_0.zip','2022-01-19 15:38:49','SYNCED','88efb696-eab9-4f14-8212-702210d91d21',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.2.1.1.3\",\"modelMatrix\":\"0.874383,0.484915,-0.0176853,0,-0.485237,0.873802,-0.0318683,0,-9.67484e-11,0.0364466,0.999336,0,-5.867,-23.6052,-21.5014,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'8929cc33-5776-4799-a4b1-27a26c789c50','','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_BOSC_f8b316c9-3008-451e-bdae-0fb8163c2756_ZIP_','2022-02-19 17:53:24','2022-02-18 16:58:20','','2022-02-19 18:53:24','SYNCED','8929cc33-5776-4799-a4b1-27a26c789c50',0,'2022-02-19 18:53:24','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.4.3\",\"modelMatrix\":\"0.472687,-0.855054,0.213187,0,0.88123,0.458647,-0.114352,0,3.40632e-10,0.24192,0.970296,0,-25.6765,11.8374,-25.3711,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'8a4ad7fe-8660-4de4-87fc-e34225ca52a0','','SNAPS','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_OCC_778ed9fd-f658-471d-9dd0-a48417419cba_SNAPO__SNAPS_','2022-05-12 12:32:06','2022-05-12 14:31:43','',NULL,'CREATED','8a4ad7fe-8660-4de4-87fc-e34225ca52a0',0,'2022-05-12 14:32:06','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'8a72c490-d57c-49ed-a392-7053d70d734d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/de078619-3946-4adb-a799-1c260e16face/session_24d0aeb5-3058-4070-aeea-97c289e41e3c/occlusion_ea6da896-1504-41fc-890c-7c48575e9e40/computedocclusion_a15a6719-2996-4256-93d7-515e4d4f5bef/2_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_de078619-3946-4adb-a799-1c260e16face_ACT_24d0aeb5-3058-4070-aeea-97c289e41e3c_SESS_ea6da896-1504-41fc-890c-7c48575e9e40_OCC_a15a6719-2996-4256-93d7-515e4d4f5bef_BOPLY__ZIP_','2022-01-19 14:47:19','2022-01-19 15:46:49','2_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-01-19 15:47:19','SYNCED','8a72c490-d57c-49ed-a392-7053d70d734d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.2.1.1.3 Occlusion 1\",\"modelMatrix\":\"0.874383,0.484915,-0.0176853,0,-0.485237,0.873802,-0.0318683,0,-9.67484e-11,0.0364466,0.999336,0,-5.867,-23.6052,-21.5014,1\",\"referenceScanID\":\"1.2.1.1.3\",\"title\":\"Mandibule 1.2.1.1.3 Occlusion 1\"}'),(1001,'8aa4c440-2665-4042-8dfd-a5325566690b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/e922efb9-8c03-445b-8a0f-449e3c43bdca/session_a2369349-1629-40ad-8784-d271bc3fbade/occlusion_292cc1aa-8b12-463b-87a1-7d9731cf886b/scan_171c6386-cba0-454c-a194-380c61a2ad2d/21_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_e922efb9-8c03-445b-8a0f-449e3c43bdca_ACT_a2369349-1629-40ad-8784-d271bc3fbade_SESS_292cc1aa-8b12-463b-87a1-7d9731cf886b_BOSC_171c6386-cba0-454c-a194-380c61a2ad2d_ZIP_','2022-04-21 08:45:31','2022-04-21 10:45:21','21_w1_o1_mandibule_scan_file_0.zip','2022-04-21 10:45:31','SYNCED','8aa4c440-2665-4042-8dfd-a5325566690b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.21.1.1.1\",\"modelMatrix\":\"-0.976637,0.206889,-0.0581121,0,-0.214896,-0.94025,0.264102,0,1.90262e-09,0.27042,0.962742,0,12.5761,-24.3862,-20.0904,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'8b0696ff-a902-4672-a040-5a87cb3b99b4','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f4fc00ec-4af8-4a15-b427-f1c5aabf6260/session_498ae60a-23f0-44fc-9730-be499bfc4b46/occlusion_8f3d6c73-3468-45a5-85c7-93bba47ec9f7/computedocclusion_9c318e86-fa90-4cd9-8319-2503cde2b455/30_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_f4fc00ec-4af8-4a15-b427-f1c5aabf6260_ACT_498ae60a-23f0-44fc-9730-be499bfc4b46_SESS_8f3d6c73-3468-45a5-85c7-93bba47ec9f7_OCC_9c318e86-fa90-4cd9-8319-2503cde2b455_BOMA__MATRX_','2022-06-14 13:30:12','2022-06-14 15:29:56','30_w1_o1_mandibule_matrix_occ_file_0.m','2022-06-14 15:30:12','SYNCED','8b0696ff-a902-4672-a040-5a87cb3b99b4',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.30.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.30.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.30.1.1.1 Occlusion 1\"}'),(1001,'8b48514f-d8d7-4e30-a7b7-9ff34435a5d8','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/computedocclusion_35af1bf5-285a-4bb1-a6db-fe9897defe51/23_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_35af1bf5-285a-4bb1-a6db-fe9897defe51_TOMA__MATRX_','2022-05-13 12:11:24','2022-05-13 14:11:07','23_w1_o1_maxillaire_matrix_occ_file_0.m','2022-05-13 14:11:24','SYNCED','8b48514f-d8d7-4e30-a7b7-9ff34435a5d8',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.23.1.1.1 Occlusion 4\",\"referenceScanID\":\"1.23.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.23.1.1.1 Occlusion 4\"}'),(1001,'8b55178c-b238-40bd-8ce4-2f27f23d3b91','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/occlusion_e08bbeeb-a30b-428c-bd4a-40198f792219/scan_6aeb3c55-f3f0-4e74-9793-ec74659a28ad/25_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_SESS_e08bbeeb-a30b-428c-bd4a-40198f792219_BOSC_6aeb3c55-f3f0-4e74-9793-ec74659a28ad_ZIP_','2022-05-17 16:28:24','2022-05-17 18:28:16','25_w1_o1_mandibule_scan_file_1.zip','2022-05-17 18:28:24','SYNCED','22087293-2aac-4313-989b-8aa120c20399',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.25.1.1.2\",\"modelMatrix\":\"-0.964287,0.263246,-0.0291771,0,-0.264858,-0.958419,0.106227,0,5.11078e-10,0.110162,0.993914,0,-2.81379,1.33022,-23.6936,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'8b995262-9a19-4f27-a906-f0a97ad14a3e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/32710234-804f-46f5-899d-eed636f8a906/session_64c1427a-b91d-4675-94df-f36bd40e9b0f/occlusion_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a/computedocclusion_84d73896-4c7a-4dc0-994a-b2a70e3d1cf2/33_w2_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_32710234-804f-46f5-899d-eed636f8a906_ACT_64c1427a-b91d-4675-94df-f36bd40e9b0f_SESS_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a_OCC_84d73896-4c7a-4dc0-994a-b2a70e3d1cf2_TOMA__MATRX_','2022-06-28 09:07:13','2022-06-28 11:07:03','33_w2_o1_maxillaire_matrix_occ_file_0.m','2022-06-28 11:07:13','SYNCED','8b995262-9a19-4f27-a906-f0a97ad14a3e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.33.2.1.1 Occlusion 1\",\"referenceScanID\":\"1.33.2.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.33.2.1.1 Occlusion 1\"}'),(1001,'8c0459bd-0102-41f8-9d98-758b74f6b263','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/57c4096f-98dd-49c8-bea5-a5b109ad3fd0/session_4f62e395-5623-4d5b-869c-1b2fc4d22b00/occlusion_1ac20dc7-b36b-4786-a05f-37091554dc5c/computedocclusion_70f4220e-2a6b-4575-bd0e-09c14a13d758/31_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_57c4096f-98dd-49c8-bea5-a5b109ad3fd0_ACT_4f62e395-5623-4d5b-869c-1b2fc4d22b00_SESS_1ac20dc7-b36b-4786-a05f-37091554dc5c_OCC_70f4220e-2a6b-4575-bd0e-09c14a13d758_BOMA__MATRX_','2022-06-16 11:04:12','2022-06-16 13:03:55','31_w1_o1_mandibule_matrix_occ_file_0.m','2022-06-16 13:04:12','SYNCED','8c0459bd-0102-41f8-9d98-758b74f6b263',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.31.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.31.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.31.1.1.1 Occlusion 1\"}'),(1001,'8c2859ce-3386-4052-b715-178d980197db','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_992e34fe-b7bb-45b7-a2c6-794c8211aba7/18_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_LESC_992e34fe-b7bb-45b7-a2c6-794c8211aba7_SNAPS_','2022-05-10 14:04:37','2022-05-10 16:04:30','18_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-05-10 16:04:37','SYNCED','8c2859ce-3386-4052-b715-178d980197db',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.18.1.1.2\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'8c489273-df3d-4efa-9d94-8ed6e0acc9ad','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/occlusion_a2220645-c79d-4dda-b6cc-772384a4106b/computedocclusion_8b14563e-0862-4cac-8045-e8aed2be886d/38_w1_o1_mlmeta_occ_file_to1000.bin','LIFIM','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_OCC_8b14563e-0862-4cac-8045-e8aed2be886d_LIFIMO_LIFIM_','2022-07-19 12:28:52','2022-07-19 14:28:51','38_w1_o1_mlmeta_occ_file_to1000.bin','2022-07-19 14:28:52','SYNCED','8c489273-df3d-4efa-9d94-8ed6e0acc9ad',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.38.1.1.1 Occlusion 1 Ligne de finition 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"Maxillaire\",\"name\":\"Ligne de finition 0\",\"title\":\"Ligne finition metadata\",\"toothNumber\":1000}'),(1001,'8c67e607-f4c9-46bb-81c6-75ee3f55af66','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/986374de-c4d7-4d6f-bf0c-2dc7e3b859a9/session_c81670ed-4144-4347-b19e-8057d11b5f7c/occlusion_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be/scan_d969cedf-8de4-4e27-8d4d-f4a1e8eac60c/28_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_986374de-c4d7-4d6f-bf0c-2dc7e3b859a9_ACT_c81670ed-4144-4347-b19e-8057d11b5f7c_SESS_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be_TOSC_d969cedf-8de4-4e27-8d4d-f4a1e8eac60c_ZIP_','2022-05-31 10:30:35','2022-05-31 12:30:24','28_w1_o1_maxillaire_scan_file_0.zip','2022-05-31 12:30:35','SYNCED','8c67e607-f4c9-46bb-81c6-75ee3f55af66',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.28.1.1.1\",\"modelMatrix\":\"0.881614,0.469845,-0.0447426,0,-0.471971,0.877644,-0.0835766,0,-1.4504e-09,0.0947996,0.995496,0,-11.2843,-18.9837,-19.8455,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'8c69c578-53d3-4a85-8b22-b7992c482bdd','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_e8550560-cfe0-40a1-bfb3-992d471fbcb7/17_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_BOSC_e8550560-cfe0-40a1-bfb3-992d471fbcb7_SNAPS_','2022-02-07 11:46:52','2022-02-07 12:35:17','17_w1_o1_mandibule_snapshot_0.png','2022-02-07 12:46:52','SYNCED','8c69c578-53d3-4a85-8b22-b7992c482bdd',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.17.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'8cfef9ee-a9b8-4ffb-ba60-2be8fa0abd6a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/scan_f5ab063d-18f1-443e-b694-fd1ef20e9e78/4_w1_o4_mordu_posterieur_gauche_scan_file_1.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_LESC_f5ab063d-18f1-443e-b694-fd1ef20e9e78_ZIP_','2022-05-31 12:11:51','2022-05-31 14:11:43','4_w1_o4_mordu_posterieur_gauche_scan_file_1.zip','2022-05-31 14:11:51','SYNCED','9faedb0a-5c1a-4ea6-b027-8e5f8df16abc',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.4.1.4.1\",\"modelMatrix\":\"-0.975851,0.154861,0.174589,0,-0.121783,-0.985808,0.0697992,0,0.182191,0.0739001,0.982648,0,-4.64098,-3.66848,-19.0455,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'8d091250-13fa-4e1e-89d6-2dae08a91119','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/computedocclusion_704a0750-2a24-448f-8f30-928139977895/4_w1_o2_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_OCC_704a0750-2a24-448f-8f30-928139977895_BOMA__MATRX_','2022-03-08 11:49:51','2022-03-08 12:49:34','4_w1_o2_mandibule_matrix_occ_file_0.m','2022-03-08 12:49:51','SYNCED','8d091250-13fa-4e1e-89d6-2dae08a91119',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.4.1.2.3 Occlusion 4\",\"referenceScanID\":\"1.4.1.2.3\",\"title\":\"Matrice Transfo. Mandibule 1.4.1.2.3 Occlusion 4\"}'),(1001,'8d1bd14c-e811-4bca-828b-4f1629ec9192','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/452a5200-3e06-4b74-8949-6abc7f2dda8a/session_3e95d626-668f-45f7-98ad-be2cf9d7b90b/occlusion_bce8310f-eee9-4f0a-a6b7-d592dec66be5/scan_bd194eb4-5c69-43b1-94bb-66c7ae8aa0ce/26_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_452a5200-3e06-4b74-8949-6abc7f2dda8a_ACT_3e95d626-668f-45f7-98ad-be2cf9d7b90b_SESS_bce8310f-eee9-4f0a-a6b7-d592dec66be5_BOSC_bd194eb4-5c69-43b1-94bb-66c7ae8aa0ce_ZIP_','2022-05-24 13:01:24','2022-05-24 11:15:00','26_w1_o1_maxillaire_scan_file_0.zip','2022-05-24 15:01:24','SYNCED','8d1bd14c-e811-4bca-828b-4f1629ec9192',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.26.1.1.2\",\"modelMatrix\":\"-0.440993,0.868318,-0.227045,0,-0.89751,-0.426649,0.111559,0,-1.10485e-08,0.252972,0.967474,0,8.55795,-16.8564,-17.5092,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'8d28fe7d-78b8-4718-992a-cf4d0a619f5a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/scan_90beda40-67c7-49a2-88be-64610235c1c8/19_w1_o1_mordu_anterieur_scan_file_0.zip','ZIP','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_FRSC_90beda40-67c7-49a2-88be-64610235c1c8_ZIP_','2022-03-08 11:12:11','2022-03-08 12:12:03','19_w1_o1_mordu_anterieur_scan_file_0.zip','2022-03-08 12:12:11','SYNCED','8d28fe7d-78b8-4718-992a-cf4d0a619f5a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.19.1.1.1\",\"modelMatrix\":\"0.98938,-0.145581,-0.0368645,0,0.141631,0.988719,0.0299436,0,0.0330974,-0.0356012,0.998872,0,-1.19359,1.82809,-19.3955,1\",\"title\":\"Mordu anterieur ZIP\"}'),(1001,'8d2fe9bc-4164-43b6-bdca-e21ff9b44241','','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_cb4cdc08-5d89-48dc-80a3-2e659c55f971_TOPLY__ZIP_','2022-02-08 08:49:00','2022-02-07 18:52:17','','2022-02-08 09:49:00','SYNCED','8d2fe9bc-4164-43b6-bdca-e21ff9b44241',0,'2022-02-08 09:49:00','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.17.1.1.1 Occlusion 4\",\"modelMatrix\":\"0.149253,0.920186,-0.361913,0,-0.988799,0.138896,-0.0546284,0,-8.90892e-10,0.366013,0.93061,0,-24.4594,-29.735,-12.8678,1\",\"referenceScanID\":\"1.17.1.1.1\",\"title\":\"Maxillaire 1.17.1.1.1 Occlusion 4\"}'),(1001,'8d4aee7a-6819-4016-b51b-71ba7ffaadea','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/986374de-c4d7-4d6f-bf0c-2dc7e3b859a9/session_c81670ed-4144-4347-b19e-8057d11b5f7c/occlusion_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be/computedocclusion_7a5acfd0-87ca-4009-aa4e-677a88ceffde/28_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_986374de-c4d7-4d6f-bf0c-2dc7e3b859a9_ACT_c81670ed-4144-4347-b19e-8057d11b5f7c_SESS_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be_OCC_7a5acfd0-87ca-4009-aa4e-677a88ceffde_BOPLY__ZIP_','2022-05-31 10:54:03','2022-05-31 12:53:55','28_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-05-31 12:54:03','SYNCED','8d4aee7a-6819-4016-b51b-71ba7ffaadea',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.28.1.1.1 Occlusion 1\",\"modelMatrix\":\"-0.906695,-0.381018,0.180913,0,0.421787,-0.819056,0.3889,0,-1.14174e-08,0.428921,0.903342,0,15.4673,-8.13965,-18.6147,1\",\"referenceScanID\":\"1.28.1.1.1\",\"title\":\"Mandibule 1.28.1.1.1 Occlusion 1\"}'),(1001,'8dee1a22-5c57-440d-a9c7-a5399fa77ed9','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_7b68804e-41db-41a7-9a19-d1aaecf91ab5/17_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_LESC_7b68804e-41db-41a7-9a19-d1aaecf91ab5_SNAPS_','2022-02-07 11:46:36','2022-02-07 12:40:30','17_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-02-07 12:46:36','SYNCED','8dee1a22-5c57-440d-a9c7-a5399fa77ed9',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.17.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'8e3b2146-f0cf-465d-9fe3-fdbb0b0d4d1e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_44561518-16e3-45bd-af90-fefe4eca9d27/24_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_RISC_44561518-16e3-45bd-af90-fefe4eca9d27_ZIP_','2022-06-13 14:53:08','2022-06-13 16:53:03','24_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-06-13 16:53:08','SYNCED','8e3b2146-f0cf-465d-9fe3-fdbb0b0d4d1e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.24.1.1.2\",\"modelMatrix\":\"0.997486,0.0216524,0.0587864,0,-0.0311832,0.997277,0.0740198,0,-0.0642751,-0.0708235,0.995562,0,8.9883,6.43936,-14.8856,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'8e862ac1-432a-45be-97fa-1ea4891400dc','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_16f04a07-72e8-4a39-9b55-3ae7405733af/24_w1_o1_maxillaire_snapshot_3.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_TOSC_16f04a07-72e8-4a39-9b55-3ae7405733af_SNAPS_','2022-06-13 14:49:08','2022-06-13 16:48:54','24_w1_o1_maxillaire_snapshot_3.png','2022-06-13 16:49:08','SYNCED','ace017e9-ff30-403f-aee6-3daa66025d8d',3,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.4\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'8f22f90d-c07d-4fc3-b9fb-4529ff268063','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/57c4096f-98dd-49c8-bea5-a5b109ad3fd0/session_4f62e395-5623-4d5b-869c-1b2fc4d22b00/occlusion_1ac20dc7-b36b-4786-a05f-37091554dc5c/scan_7d899967-a5be-43f7-acbd-42d4237792d4/31_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_57c4096f-98dd-49c8-bea5-a5b109ad3fd0_ACT_4f62e395-5623-4d5b-869c-1b2fc4d22b00_SESS_1ac20dc7-b36b-4786-a05f-37091554dc5c_TOSC_7d899967-a5be-43f7-acbd-42d4237792d4_ZIP_','2022-06-16 10:52:48','2022-06-16 12:52:39','31_w1_o1_maxillaire_scan_file_0.zip','2022-06-16 12:52:48','SYNCED','8f22f90d-c07d-4fc3-b9fb-4529ff268063',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.31.1.1.1\",\"modelMatrix\":\"0.997887,0.0642305,-0.00984649,0,-0.0649809,0.986364,-0.151209,0,-4.81543e-10,0.151529,0.988453,0,-2.47476,-6.56649,-21.1676,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'8f26da38-e26c-4658-9fd5-f0e614308ff9','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_2a7068fc-0efa-496f-ade9-aba5b0650655/12_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_2a7068fc-0efa-496f-ade9-aba5b0650655_ZIP_','2022-02-04 11:52:26','2022-02-04 12:52:03','12_w1_o1_mandibule_scan_file_1.zip','2022-02-04 12:52:26','SYNCED','44ebcd6f-57c2-4cce-96f5-f9faa1c6b373',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.5\",\"modelMatrix\":\"0.860642,-0.488202,0.144758,0,0.509211,0.825133,-0.244663,0,-4.02363e-9,0.284279,0.958741,0,-6.04134,30.4631,-28.4285,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'8f3ff963-3c36-45c7-aeef-20558e20e496','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_4ed7adaa-3b77-4537-8479-4d0c4bd28c7b/12_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_TOSC_4ed7adaa-3b77-4537-8479-4d0c4bd28c7b_SNAPS_','2022-01-27 11:58:08','2022-01-27 12:54:59','12_w1_o1_maxillaire_snapshot_0.png','2022-01-27 12:58:08','SYNCED','8f3ff963-3c36-45c7-aeef-20558e20e496',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.12.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'8f69f135-daef-4f4b-a1a0-3aa76fb92de1','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/4a3954e0-1e2f-4721-9fdd-4180380dc19f/session_33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416/occlusion_3accbada-5a51-4d10-88d1-c3e7d8598d6f/computedocclusion_5775815f-f076-48af-be27-50e4dbfd3622/34_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_4a3954e0-1e2f-4721-9fdd-4180380dc19f_ACT_33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416_SESS_3accbada-5a51-4d10-88d1-c3e7d8598d6f_OCC_5775815f-f076-48af-be27-50e4dbfd3622_BOMA__MATRX_','2022-06-28 10:56:19','2022-06-28 12:55:54','34_w1_o1_mandibule_matrix_occ_file_0.m','2022-06-28 12:56:19','SYNCED','8f69f135-daef-4f4b-a1a0-3aa76fb92de1',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.34.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.34.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.34.1.1.1 Occlusion 1\"}'),(1001,'8fb05be8-f57e-46ea-9abd-c2f8b7e453bc','','ZIP','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_65f9077d-c859-4b2c-9d4d-692d723315a5_BOPLY__ZIP_','2022-05-13 12:07:43','2022-05-13 14:07:00','','2022-05-13 14:07:43','SYNCED','8fb05be8-f57e-46ea-9abd-c2f8b7e453bc',0,'2022-05-13 14:07:43','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.23.1.1.1 Occlusion 4\",\"modelMatrix\":\"0.99884,-0.00870968,0.0473501,0,0.0481445,0.180697,-0.98236,0,-1.26898e-10,0.9835,0.180907,0,0.872294,-19.7028,-3.24839,1\",\"referenceScanID\":\"1.23.1.1.1\",\"title\":\"Mandibule 1.23.1.1.1 Occlusion 4\"}'),(1001,'8fb19261-9e70-4678-8a85-98e89dd98dcb','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/scan_f2bad12a-451d-406d-98b0-e431a37951dd/19_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_BOSC_f2bad12a-451d-406d-98b0-e431a37951dd_SNAPS_','2022-03-08 10:38:42','2022-03-08 11:38:34','19_w1_o1_mandibule_snapshot_0.png','2022-03-08 11:38:42','SYNCED','8fb19261-9e70-4678-8a85-98e89dd98dcb',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.1.4\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'8fccf724-5a93-4f6d-8056-653d4b6b830f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/45ff7437-0691-4427-a7da-8250862e4b96/session_4ff9c682-c09d-42ff-8c29-aeb13e066ed2/occlusion_934673c1-a4b9-4508-ac1b-a03092a0693e/scan_8d7fa4fe-ab8d-4b70-b921-fabf93cf9f25/9_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_45ff7437-0691-4427-a7da-8250862e4b96_ACT_4ff9c682-c09d-42ff-8c29-aeb13e066ed2_SESS_934673c1-a4b9-4508-ac1b-a03092a0693e_RISC_8d7fa4fe-ab8d-4b70-b921-fabf93cf9f25_SNAPS_','2022-01-24 17:46:38','2022-01-24 18:45:21','9_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-01-24 18:46:38','SYNCED','8fccf724-5a93-4f6d-8056-653d4b6b830f',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.9.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'9009fa0f-5f5b-491f-b430-198a7ef6e5a6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_93b9b214-5793-480a-b05f-e0419802faf3/12_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_LESC_93b9b214-5793-480a-b05f-e0419802faf3_SNAPS_','2022-02-04 12:19:20','2022-02-04 13:17:21','12_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-02-04 13:19:20','SYNCED','9009fa0f-5f5b-491f-b430-198a7ef6e5a6',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.12.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'901c6e3e-fe86-4c38-9bde-1921d9f62a90','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/scan_3743c984-7cdf-4a7a-bb8e-522e16ccb6e4/4_w1_o4_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_FRSC_3743c984-7cdf-4a7a-bb8e-522e16ccb6e4_SNAPS_','2022-05-31 12:16:25','2022-05-31 14:16:17','4_w1_o4_mordu_anterieur_snapshot_0.png','2022-05-31 14:16:25','SYNCED','901c6e3e-fe86-4c38-9bde-1921d9f62a90',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.4.1.4.2\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'9026aa67-b409-4693-81c4-92607b3386a1','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/computedocclusion_0bc29ff9-efea-448d-b521-2c39fd4faa78/19_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_OCC_0bc29ff9-efea-448d-b521-2c39fd4faa78_TOMA__MATRX_','2022-03-08 11:18:04','2022-03-08 12:17:37','19_w1_o1_maxillaire_matrix_occ_file_0.m','2022-03-08 12:18:04','SYNCED','9026aa67-b409-4693-81c4-92607b3386a1',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.19.1.1.1 Occlusion 3\",\"referenceScanID\":\"1.19.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.19.1.1.1 Occlusion 3\"}'),(1001,'902ec464-8030-4908-b872-2aa60ec542d8','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/207d6dbc-c19b-4726-a9b3-16235ae554cc/session_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35/occlusion_dc5762a3-c453-4166-8c86-82d23ac9f8a6/scan_9a90e42e-88ee-4808-8ae4-399e7285a1d0/27_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_207d6dbc-c19b-4726-a9b3-16235ae554cc_ACT_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35_SESS_dc5762a3-c453-4166-8c86-82d23ac9f8a6_TOSC_9a90e42e-88ee-4808-8ae4-399e7285a1d0_SNAPS_','2022-05-30 10:55:02','2022-05-30 12:54:51','27_w1_o1_maxillaire_snapshot_0.png','2022-05-30 12:55:02','SYNCED','902ec464-8030-4908-b872-2aa60ec542d8',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.27.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'9055105b-b138-4723-8426-bb8b57a97a50','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/533d4409-e39d-4a27-a0af-b59e6cf76ce3/session_319a8f1d-33fc-4f87-a108-b3eabda0510f/occlusion_3b38f07b-42cb-40b1-933f-365e568702e4/scan_109ca2c4-8222-4d02-9ac7-b4b93937e1e2/37_w1_o1_maxillaire_snapshot_3.png','SNAPS','PATIENT_533d4409-e39d-4a27-a0af-b59e6cf76ce3_ACT_319a8f1d-33fc-4f87-a108-b3eabda0510f_SESS_3b38f07b-42cb-40b1-933f-365e568702e4_TOSC_109ca2c4-8222-4d02-9ac7-b4b93937e1e2_SNAPS_','2022-07-07 16:05:55','2022-07-07 18:05:43','37_w1_o1_maxillaire_snapshot_3.png','2022-07-07 18:05:55','SYNCED','6fa5ad33-3773-4801-9f0b-ed36985cc55e',3,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.37.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'911094e4-fe1d-4725-b083-95706a95ce27','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/discussion_4d12bcc3-80f2-49dc-9159-54929f160ce6/911094e4-fe1d-4725-b083-95706a95ce27.m','MATRX','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_426bd908-3163-4291-a697-20eacff771ab_BOMA__MATRX_','2022-05-25 08:56:23','2022-05-16 19:57:11','911094e4-fe1d-4725-b083-95706a95ce27.m','2022-05-25 10:56:23','SYNCED','911094e4-fe1d-4725-b083-95706a95ce27',0,'2022-05-25 10:56:23','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.24.1.1.1 Occlusion 6\",\"referenceScanID\":\"1.24.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.24.1.1.1 Occlusion 6\"}'),(1001,'91975b1f-684b-4717-9edb-bec57444b873','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_7048f93c-1091-4f02-bc64-b73347dfa962/24_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_RISC_7048f93c-1091-4f02-bc64-b73347dfa962_ZIP_','2022-06-13 15:00:13','2022-06-13 17:00:06','24_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-06-13 17:00:13','SYNCED','91975b1f-684b-4717-9edb-bec57444b873',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.24.1.1.3\",\"modelMatrix\":\"0.996985,-0.00432956,0.0671889,0,0.0129732,0.991367,0.136127,0,-0.0794612,-0.13248,0.988467,0,-1.91791,-2.8084,-17.3973,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'91bc9544-42d1-4de0-9184-79f217dab1d6','','ZIP','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_RISC_4cf74467-a55c-46b5-99f6-e0f80fd19b31_ZIP_','2022-09-09 16:30:10','2022-09-09 18:22:24','','2022-09-09 18:30:10','SYNCED','91bc9544-42d1-4de0-9184-79f217dab1d6',0,'2022-09-09 18:30:10','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.39.1.1.3\",\"modelMatrix\":\"0.972701,0.23083,0.0172,0,-0.230455,0.970014,-0.0774539,0,-0.0280687,0.0762563,0.996881,0,12.3932,2.3166,-17.9958,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'91c78cb3-fa9c-4ddc-a426-8d7913857428','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/scan_f2bad12a-451d-406d-98b0-e431a37951dd/19_w1_o1_mandibule_snapshot_4.png','SNAPS','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_BOSC_f2bad12a-451d-406d-98b0-e431a37951dd_SNAPS_','2022-03-08 11:20:54','2022-03-08 12:20:43','19_w1_o1_mandibule_snapshot_4.png','2022-03-08 12:20:54','SYNCED','8fb19261-9e70-4678-8a85-98e89dd98dcb',4,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.1.4\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'91e406d3-a205-49ce-8101-9fdaade0241b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/32710234-804f-46f5-899d-eed636f8a906/session_64c1427a-b91d-4675-94df-f36bd40e9b0f/occlusion_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a/scan_62c04472-88fd-4ac5-acbe-aefb92941897/33_w2_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_32710234-804f-46f5-899d-eed636f8a906_ACT_64c1427a-b91d-4675-94df-f36bd40e9b0f_SESS_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a_TOSC_62c04472-88fd-4ac5-acbe-aefb92941897_ZIP_','2022-06-28 08:50:38','2022-06-28 10:50:30','33_w2_o1_maxillaire_scan_file_0.zip','2022-06-28 10:50:38','SYNCED','91e406d3-a205-49ce-8101-9fdaade0241b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.33.2.1.1\",\"modelMatrix\":\"-0.712189,0.701711,-0.019724,0,-0.701988,-0.711908,0.0200107,0,1.61205e-10,0.0280974,0.999605,0,4.73611,1.67537,-20.9792,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'91e77307-7833-49da-b522-a802584e820d','','ZIP','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_BOSC_3379235c-b42d-440c-84bc-d105a1d56127_ZIP_','2022-03-09 07:54:47','2022-03-08 11:27:31','','2022-03-09 08:54:47','SYNCED','91e77307-7833-49da-b522-a802584e820d',0,'2022-03-09 08:54:47','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.1.2\",\"modelMatrix\":\"0.663561,-0.696268,0.273675,0,0.748123,0.617567,-0.242741,0,7.59721e-10,0.365816,0.930687,0,-11.4517,-3.047,-16.5035,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'920a762b-6fe8-4198-8bb1-e0c244ac1799','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/4a3954e0-1e2f-4721-9fdd-4180380dc19f/session_33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416/order_bfcc9c3f-f8b9-4984-af13-110825822614/34_w1_inlay_onlay_prost_file_920a762b-6fe8-4198-8bb1-e0c244ac1799_0.pdf','PDF','PATIENT_4a3954e0-1e2f-4721-9fdd-4180380dc19f_ACT_33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416_PROST_bfcc9c3f-f8b9-4984-af13-110825822614_PDF_','2022-06-28 17:31:32','2022-06-28 19:31:31','34_w1_inlay_onlay_prost_file_920a762b-6fe8-4198-8bb1-e0c244ac1799_0.pdf','2022-06-28 19:31:32','SYNCED','920a762b-6fe8-4198-8bb1-e0c244ac1799',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.34.1.1 INLAY ONLAY35 Marie josé\",\"title\":\"Inlay/Onlay PDF\"}'),(1001,'920f3016-ec04-481a-9403-cbf6252efb92','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_49bd090f-1a01-4a79-8202-62487b9af783/18_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_BOSC_49bd090f-1a01-4a79-8202-62487b9af783_ZIP_','2022-03-07 14:12:46','2022-03-07 15:12:44','18_w1_o1_mandibule_scan_file_1.zip','2022-03-07 15:12:46','SYNCED','48568b30-23dd-4d00-b4de-f54ce8d90d30',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.18.1.1.1\",\"modelMatrix\":\"-0.740045,-0.667159,0.0850427,0,0.672558,-0.734105,0.0935762,0,1.1198e-09,0.126447,0.991973,0,3.45916,-3.12895,-14.1428,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'921fb52f-b180-40cb-95ac-af03083394e1','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/32710234-804f-46f5-899d-eed636f8a906/session_64c1427a-b91d-4675-94df-f36bd40e9b0f/occlusion_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a/scan_50213132-9c82-471d-8981-66894edf36a4/33_w2_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_32710234-804f-46f5-899d-eed636f8a906_ACT_64c1427a-b91d-4675-94df-f36bd40e9b0f_SESS_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a_RISC_50213132-9c82-471d-8981-66894edf36a4_ZIP_','2022-06-28 09:06:59','2022-06-28 11:06:50','33_w2_o1_mordu_posterieur_droit_scan_file_0.zip','2022-06-28 11:06:59','SYNCED','921fb52f-b180-40cb-95ac-af03083394e1',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.33.2.1.1\",\"modelMatrix\":\"0.833161,-0.0337151,0.555659,0,0.0430126,0.998334,-0.0149013,0,-0.551502,0.0488838,0.831315,0,-6.43315,-1.37286,-28.8896,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'926c10eb-7fb9-451f-a515-0fb23610d5ce','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_16f04a07-72e8-4a39-9b55-3ae7405733af/24_w1_o1_maxillaire_scan_file_2.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_TOSC_16f04a07-72e8-4a39-9b55-3ae7405733af_ZIP_','2022-06-13 14:45:22','2022-06-13 16:45:10','24_w1_o1_maxillaire_scan_file_2.zip','2022-06-13 16:45:22','SYNCED','d3ff533f-e540-46c8-8f68-b5341a94ad72',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.4\",\"modelMatrix\":\"0.522347,0.830611,-0.192972,0,-0.852733,0.508797,-0.118206,0,-1.09725e-09,0.226298,0.974058,0,-16.4252,-3.89119,-19.4472,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'92be922c-d588-45df-a4be-47304ce445f7','','SNAPS','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_RISC_0f004b83-11e3-49ae-b25b-7872c0ac7485_SNAPS_','2022-09-10 08:18:17','2022-09-09 18:36:22','','2022-09-10 10:18:17','SYNCED','92be922c-d588-45df-a4be-47304ce445f7',0,'2022-09-10 10:18:17','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.39.1.1.5\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'92bf4f89-6d0d-4ee8-bd82-d36a90b3cacb','','SNAPS','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_OCC_87edc123-163f-46ce-be5c-45f2ff80b857_SNAPO__SNAPS_','2022-05-12 12:27:27','2022-05-12 14:26:51','','2022-05-12 14:27:27','SYNCED','92bf4f89-6d0d-4ee8-bd82-d36a90b3cacb',0,'2022-05-12 14:27:27','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'93208781-7d31-457e-9d61-61f5954a03e4','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_14264009-2f96-4841-9c75-17adb3424f9f/18_w1_o1_mordu_anterieur_snapshot_1.png','SNAPS','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_FRSC_14264009-2f96-4841-9c75-17adb3424f9f_SNAPS_','2022-03-07 14:38:04','2022-03-07 15:37:55','18_w1_o1_mordu_anterieur_snapshot_1.png','2022-03-07 15:38:04','SYNCED','9519696c-cd0e-413e-a068-1fb998797b48',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.18.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(2,'93825ccc-d1f9-49ef-a00c-3634f15f5219','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a4b302c-278d-4e12-ace5-f095ba0bf856/session_6206892a-2e7e-4765-ac90-b49bfb465997/occlusion_3c30231c-7cd7-4431-985b-2eaf7f6925ae/scan_21743037-e185-4ce7-80aa-af01b0d42c2d/3_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_21743037-e185-4ce7-80aa-af01b0d42c2d_ZIP_','2022-09-06 09:17:55','2022-08-30 11:00:58','3_w1_o1_maxillaire_scan_file_0.zip','2022-09-06 11:17:55','SYNCED','93825ccc-d1f9-49ef-a00c-3634f15f5219',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.3.1.1.6\",\"modelMatrix\":\"0.884901,0.449075,-0.123616,0,-0.465778,0.853169,-0.234849,0,3.7488e-09,0.265396,0.96414,0,-28.3676,-3.7757,-16.7896,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'93a19afa-3bad-4510-bfa1-ee7dff7e1a61','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/593972a6-d7d6-4802-b87d-38aab371f71e/session_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480/occlusion_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3/scan_7338a694-0f0d-4c09-8c45-b4e4129978cb/3_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_593972a6-d7d6-4802-b87d-38aab371f71e_ACT_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480_SESS_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3_RISC_7338a694-0f0d-4c09-8c45-b4e4129978cb_SNAPS_','2022-01-19 15:16:53','2022-01-19 16:15:25','3_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-01-19 16:16:53','SYNCED','93a19afa-3bad-4510-bfa1-ee7dff7e1a61',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.3.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'93d056fd-9cb6-4d4f-906f-4a02f6e3bbca','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/de078619-3946-4adb-a799-1c260e16face/session_24d0aeb5-3058-4070-aeea-97c289e41e3c/occlusion_ea6da896-1504-41fc-890c-7c48575e9e40/scan_cf9b0360-b96a-4e1a-a219-fdaa6228f9f7/2_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_de078619-3946-4adb-a799-1c260e16face_ACT_24d0aeb5-3058-4070-aeea-97c289e41e3c_SESS_ea6da896-1504-41fc-890c-7c48575e9e40_BOSC_cf9b0360-b96a-4e1a-a219-fdaa6228f9f7_SNAPS_','2022-01-19 14:38:49','2022-01-19 15:38:24','2_w1_o1_mandibule_snapshot_0.png','2022-01-19 15:38:49','SYNCED','93d056fd-9cb6-4d4f-906f-4a02f6e3bbca',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.2.1.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'93e015c7-46c1-406e-be60-bf0c78428875','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/occlusion_e08bbeeb-a30b-428c-bd4a-40198f792219/computedocclusion_a503ab26-f707-4923-86b6-049c17f73533/25_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_SESS_e08bbeeb-a30b-428c-bd4a-40198f792219_OCC_a503ab26-f707-4923-86b6-049c17f73533_TOMA__MATRX_','2022-05-17 16:40:45','2022-05-17 18:40:25','25_w1_o1_maxillaire_matrix_occ_file_0.m','2022-05-17 18:40:45','SYNCED','93e015c7-46c1-406e-be60-bf0c78428875',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.25.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.25.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.25.1.1.1 Occlusion 1\"}'),(1001,'93ed2900-e60f-4603-869c-35779261d045','','SNAPS','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_c9079d19-8ffb-46f7-a51e-3a7a90ccae59_SESS_8ba0f3b1-408f-4a02-92a0-63f09123b68e_LESC_f2611342-ebf4-4c08-b8d1-c7c38b1c7e7c_SNAPS_','2022-01-28 17:15:44','2022-01-27 14:27:08','','2022-01-28 18:15:44','SYNCED','93ed2900-e60f-4603-869c-35779261d045',0,'2022-01-28 18:15:44','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.10.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'941b2895-4d14-4eff-bae6-5aa44f38a0c6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_4f8dc275-857c-482a-9886-5521591e9661/scan_df08df19-150c-437d-8ed4-bf2826644265/12_w1_o4_mandibule_scan_file_1.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_BOSC_df08df19-150c-437d-8ed4-bf2826644265_ZIP_','2022-02-18 16:15:50','2022-02-18 17:15:36','12_w1_o4_mandibule_scan_file_1.zip','2022-02-18 17:15:50','SYNCED','68cf35d1-7f31-4f48-8b81-a07300151534',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.4.5\",\"modelMatrix\":\"0.569927,0.756194,-0.321488,0,-0.821696,0.524495,-0.222984,0,1.64912e-08,0.39125,0.920285,0,0.42327,-12.328,-18.8879,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'94f85e53-53fa-4619-b521-dd644a72254d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/593972a6-d7d6-4802-b87d-38aab371f71e/session_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480/occlusion_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3/scan_0bf938e8-3ff3-4e2d-981d-f2db30285d60/3_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_593972a6-d7d6-4802-b87d-38aab371f71e_ACT_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480_SESS_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3_TOSC_0bf938e8-3ff3-4e2d-981d-f2db30285d60_ZIP_','2022-01-19 14:59:11','2022-01-19 15:58:40','3_w1_o1_maxillaire_scan_file_0.zip','2022-01-19 15:59:11','SYNCED','94f85e53-53fa-4619-b521-dd644a72254d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.3.1.1.1\",\"modelMatrix\":\"-0.8207,0.559215,-0.117173,0,-0.571359,-0.803257,0.168307,0,5.51916e-9,0.205077,0.978746,0,22.3383,-22.9288,-32.0145,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'9505a7cb-ab3e-4498-837a-c1d9163e0965','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_2a7068fc-0efa-496f-ade9-aba5b0650655/12_w1_o1_mandibule_snapshot_3.png','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_2a7068fc-0efa-496f-ade9-aba5b0650655_SNAPS_','2022-02-04 12:01:55','2022-02-04 13:01:37','12_w1_o1_mandibule_snapshot_3.png','2022-02-04 13:01:55','SYNCED','7636e0d7-f242-431c-90a5-a65399d83ecd',3,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.5\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'9519696c-cd0e-413e-a068-1fb998797b48','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_14264009-2f96-4841-9c75-17adb3424f9f/18_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_FRSC_14264009-2f96-4841-9c75-17adb3424f9f_SNAPS_','2022-03-07 14:37:56','2022-03-07 15:35:21','18_w1_o1_mordu_anterieur_snapshot_0.png','2022-03-07 15:37:56','SYNCED','9519696c-cd0e-413e-a068-1fb998797b48',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.18.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'95267990-f2d4-4cd6-b572-9f6c8fd29601','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/scan_f5ab063d-18f1-443e-b694-fd1ef20e9e78/4_w1_o4_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_LESC_f5ab063d-18f1-443e-b694-fd1ef20e9e78_SNAPS_','2022-05-31 12:11:44','2022-05-31 14:09:38','4_w1_o4_mordu_posterieur_gauche_snapshot_0.png','2022-05-31 14:11:44','SYNCED','95267990-f2d4-4cd6-b572-9f6c8fd29601',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.4.1.4.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'9536f005-a147-4c1b-81e6-1e7123ebdb38','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_b28164eb-0070-4968-83be-bfabe1a0c839/13_w1_o1_mandibule_scan_file_2.zip','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_b28164eb-0070-4968-83be-bfabe1a0c839_ZIP_','2022-02-04 17:56:22','2022-02-04 17:02:36','13_w1_o1_mandibule_scan_file_2.zip','2022-02-04 18:56:22','SYNCED','d8a3bf39-16d1-435f-bafa-6c625f77d811',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.5\",\"modelMatrix\":\"-0.980986,-0.182732,0.0653907,0,0.19408,-0.923628,0.33052,0,1.2429e-9,0.336927,0.941531,0,23.7056,9.64329,-24.5584,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'96dd75bb-5035-460a-8afc-04f3755604b1','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/scan_03839278-13f8-46e6-9581-ba11bc8bcb81/1_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_TOSC_03839278-13f8-46e6-9581-ba11bc8bcb81_ZIP_','2022-01-19 13:00:44','2022-01-19 10:24:18','1_w1_o1_maxillaire_scan_file_0.zip','2022-01-19 14:00:44','SYNCED','96dd75bb-5035-460a-8afc-04f3755604b1',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.1.1.1.1\",\"modelMatrix\":\"-0.169937,0.932851,-0.317664,0,-0.985455,-0.160866,0.0547797,0,-2.44953e-9,0.322353,0.94662,0,-14.6828,-39.2953,-12.5174,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'976c8ff2-0cca-43fe-8b36-f902660807ef','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/32710234-804f-46f5-899d-eed636f8a906/session_64c1427a-b91d-4675-94df-f36bd40e9b0f/occlusion_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a/computedocclusion_84d73896-4c7a-4dc0-994a-b2a70e3d1cf2/33_w2_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_32710234-804f-46f5-899d-eed636f8a906_ACT_64c1427a-b91d-4675-94df-f36bd40e9b0f_SESS_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a_OCC_84d73896-4c7a-4dc0-994a-b2a70e3d1cf2_SNAPO__SNAPS_','2022-06-28 09:07:20','2022-06-28 11:07:03','33_w2_o1_snapshot_occ_file_0.png','2022-06-28 11:07:20','SYNCED','976c8ff2-0cca-43fe-8b36-f902660807ef',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'97714910-7f35-4b7d-95cd-64c6cf044087','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/scan_6f906ffa-4828-4d68-a894-572a056b896b/23_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_BOSC_6f906ffa-4828-4d68-a894-572a056b896b_SNAPS_','2022-05-13 10:06:36','2022-05-13 12:06:28','23_w1_o1_mandibule_snapshot_0.png','2022-05-13 12:06:36','SYNCED','97714910-7f35-4b7d-95cd-64c6cf044087',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.23.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'977518ea-ece1-49a3-8637-c97f53f5e63a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/occlusion_a2220645-c79d-4dda-b6cc-772384a4106b/computedocclusion_cf412dab-1d83-4db0-ae1b-d2724d5be97d/38_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_OCC_cf412dab-1d83-4db0-ae1b-d2724d5be97d_TOPLY__ZIP_','2022-07-12 11:04:31','2022-07-12 13:04:14','38_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-07-12 13:04:31','SYNCED','977518ea-ece1-49a3-8637-c97f53f5e63a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.38.1.1.3 Occlusion 2\",\"modelMatrix\":\"0.292113,0.953283,-0.0769574,0,-0.956384,0.291166,-0.0235055,0,3.79853e-10,0.0804671,0.996757,0,-4.50082,-22.5707,-20.6555,1\",\"referenceScanID\":\"1.38.1.1.3\",\"title\":\"Maxillaire 1.38.1.1.3 Occlusion 2\"}'),(1001,'9791ebc4-1ba3-48c6-918f-eb0a1f569c6c','','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_OCC_4aa37ef9-cd2d-4cfa-9436-a62cc782a27a_SNAPO__SNAPS_','2022-02-04 15:01:40','2022-02-04 14:55:02','','2022-02-04 16:01:40','SYNCED','9791ebc4-1ba3-48c6-918f-eb0a1f569c6c',0,'2022-02-04 16:01:40','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'97cbafa8-978a-4607-a2ab-e4b13a4afa8b','','SNAPS','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_c9079d19-8ffb-46f7-a51e-3a7a90ccae59_SESS_8ba0f3b1-408f-4a02-92a0-63f09123b68e_TOSC_44c8d5b1-b2de-4ba6-8ae5-8bc2a88e7918_SNAPS_','2022-01-28 17:15:44','2022-01-27 14:22:54','','2022-01-28 18:15:44','SYNCED','c7d8c731-2671-41fa-98d3-647d17160f01',1,'2022-01-28 18:15:44','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.10.1.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'98432173-1253-48fa-b893-e2dd7ab26a00','','ZIP','PATIENT_593972a6-d7d6-4802-b87d-38aab371f71e_ACT_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480_SESS_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3_OCC_4e1258a6-b789-451f-bfe8-8b395e1129d8_BOPLY__ZIP_','2022-01-19 15:25:10','2022-01-19 16:24:43','',NULL,'CREATED','98432173-1253-48fa-b893-e2dd7ab26a00',0,'2022-01-19 16:25:10','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.3.1.1.1 Occlusion 3\",\"modelMatrix\":\"0.888791,-0.456948,0.035335,0,0.458312,0.886146,-0.0685242,0,1.93169e-9,0.0770982,0.997023,0,-18.6308,-12.394,-21.0367,1\",\"referenceScanID\":\"1.3.1.1.1\",\"title\":\"Mandibule 1.3.1.1.1 Occlusion 3\"}'),(1001,'98489097-716a-4b58-9941-a5fc369a2d70','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/computedocclusion_6960b50e-6f78-4f83-9303-8c985410457c/4_w1_o4_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_OCC_6960b50e-6f78-4f83-9303-8c985410457c_BOPLY__ZIP_','2022-05-31 14:55:58','2022-05-31 16:55:44','4_w1_o4_mandibule_occlusion_occ_file_0.zip','2022-05-31 16:55:58','SYNCED','98489097-716a-4b58-9941-a5fc369a2d70',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.4.1 Occlusion 5\",\"modelMatrix\":\"-0.693921,-0.706378,0.139651,0,0.720051,-0.680745,0.134584,0,-7.89603e-09,0.193947,0.981012,0,1.63985,-2.11708,-20.6571,1\",\"referenceScanID\":\"1.4.1.4.1\",\"title\":\"Mandibule 1.4.1.4.1 Occlusion 5\"}'),(1001,'99207aa8-492a-4329-8b5e-927534c1602d','','ZIP','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_c9079d19-8ffb-46f7-a51e-3a7a90ccae59_SESS_8ba0f3b1-408f-4a02-92a0-63f09123b68e_TOSC_44c8d5b1-b2de-4ba6-8ae5-8bc2a88e7918_ZIP_','2022-01-28 17:15:44','2022-01-27 14:19:03','','2022-01-28 18:15:44','SYNCED','99207aa8-492a-4329-8b5e-927534c1602d',0,'2022-01-28 18:15:44','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.10.1.1.3\",\"modelMatrix\":\"0.836207,0.53764,-0.108173,0,-0.548414,0.819779,-0.164939,0,-1.06729e-8,0.197247,0.980354,0,-22.3668,-9.22041,-17.6362,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'994cb9e0-2e19-495f-a47d-a8e5a7508218','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/de078619-3946-4adb-a799-1c260e16face/session_24d0aeb5-3058-4070-aeea-97c289e41e3c/occlusion_ea6da896-1504-41fc-890c-7c48575e9e40/scan_e7e54c23-0fb4-457b-aa49-43078736514f/2_w1_o1_mordu_anterieur_scan_file_0.zip','ZIP','PATIENT_de078619-3946-4adb-a799-1c260e16face_ACT_24d0aeb5-3058-4070-aeea-97c289e41e3c_SESS_ea6da896-1504-41fc-890c-7c48575e9e40_FRSC_e7e54c23-0fb4-457b-aa49-43078736514f_ZIP_','2022-01-19 14:46:11','2022-01-19 15:46:00','2_w1_o1_mordu_anterieur_scan_file_0.zip','2022-01-19 15:46:11','SYNCED','994cb9e0-2e19-495f-a47d-a8e5a7508218',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.2.1.1.1\",\"modelMatrix\":\"0.980065,-0.204958,-0.0526448,0,0.112398,0.463376,0.872879,0,-0.167578,-0.862155,0.486365,0,-2.15237,17.6189,-29.4292,1\",\"title\":\"Mordu anterieur ZIP\"}'),(1001,'99c7b58b-6259-4c43-ac2f-8b7f47f0b3e7','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/scan_03839278-13f8-46e6-9581-ba11bc8bcb81/1_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_TOSC_03839278-13f8-46e6-9581-ba11bc8bcb81_SNAPS_','2022-01-19 12:59:18','2022-01-19 10:24:17','1_w1_o1_maxillaire_snapshot_0.png','2022-01-19 13:59:18','SYNCED','99c7b58b-6259-4c43-ac2f-8b7f47f0b3e7',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire SNAPSHOT\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'99e9c64c-195f-4a43-beb2-035ad896a764','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/scan_a628b7db-c954-4964-8d48-1e09fa34d82b/1_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_RISC_a628b7db-c954-4964-8d48-1e09fa34d82b_ZIP_','2022-01-19 12:59:17','2022-01-19 12:03:51','1_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-01-19 13:59:17','SYNCED','99e9c64c-195f-4a43-beb2-035ad896a764',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.1.1.1.1\",\"modelMatrix\":\"0.975619,0.193926,0.102839,0,-0.205915,0.968059,0.140778,0,-0.0760501,-0.158929,0.984692,0,-11.6702,-2.08029,-19.9288,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'9b224217-9a8a-452f-b50f-bd96620b3ed4','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a0c21836-ba79-4f15-9e35-02ef8211a9e5/session_0aac522d-3c38-465a-a1e0-014166c140ac/occlusion_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042/scan_c3e689b6-6028-4fc6-9373-eab430b52625/7_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_a0c21836-ba79-4f15-9e35-02ef8211a9e5_ACT_0aac522d-3c38-465a-a1e0-014166c140ac_SESS_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042_LESC_c3e689b6-6028-4fc6-9373-eab430b52625_ZIP_','2022-01-21 12:04:47','2022-01-21 13:04:33','7_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-01-21 13:04:47','SYNCED','9b224217-9a8a-452f-b50f-bd96620b3ed4',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.7.1.1.1\",\"modelMatrix\":\"-0.976609,-0.0506279,0.213734,0,0.0565187,-0.996245,0.0558216,0,0.207631,0.0707217,0.975304,0,5.92907,-1.09381,-19.0899,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'9b41cfe4-14a3-4577-80f8-bcdd6cf985e5','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/computedocclusion_864c98a3-fcf7-466a-b999-13bd4dfb8c65/23_w1_o1_ml_occ_file_to1002.xyz','LIFI','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_864c98a3-fcf7-466a-b999-13bd4dfb8c65_LIFIO_LIFI_','2022-05-25 10:46:43','2022-05-25 12:46:42','23_w1_o1_ml_occ_file_to1002.xyz','2022-05-25 12:46:43','SYNCED','9b41cfe4-14a3-4577-80f8-bcdd6cf985e5',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.23.1.1.1 Occlusion 3 Ligne de finition 2\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"Maxillaire\",\"name\":\"Ligne de finition 2\",\"title\":\"Ligne finition\",\"toothNumber\":1002}'),(1001,'9b548519-68c0-45b3-83c4-c58081ddab21','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_1ecf6aa5-37ac-49b0-ab34-94916ad9415a/4_w1_o2_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_LESC_1ecf6aa5-37ac-49b0-ab34-94916ad9415a_ZIP_','2022-02-15 12:37:05','2022-02-15 13:36:58','4_w1_o2_mordu_posterieur_gauche_scan_file_0.zip','2022-02-15 13:37:05','SYNCED','9b548519-68c0-45b3-83c4-c58081ddab21',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.4.1.2.1\",\"modelMatrix\":\"-0.977205,-0.173965,0.16006,0,0.160172,-0.983412,0.0139735,0,0.141616,0.0574546,0.987233,0,-8.00566,-2.7193,-19.0144,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'9b6af1b1-98f8-49a2-b094-91fd0cf4bb06','','ZIP','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_OCC_d58ce31f-4b72-44ad-b0e0-3d5d7d789322_TOPLY__ZIP_','2022-01-19 11:15:36','2022-01-19 12:06:18','',NULL,'CREATED','9b6af1b1-98f8-49a2-b094-91fd0cf4bb06',0,'2022-01-19 12:15:36','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.1.1.1.1 Occlusion 1\",\"modelMatrix\":\"-0.154277,0.952805,-0.261459,0,-0.988028,-0.148777,0.0408259,0,-2.59672e-9,0.264627,0.964351,0,-14.8611,-36.6101,-15.3158,1\",\"referenceScanID\":\"1.1.1.1.1\",\"title\":\"Maxillaire 1.1.1.1.1 Occlusion 1\"}'),(1001,'9bc487be-aea8-4232-90ae-806369f205fd','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/computedocclusion_b35629de-38d8-4cdd-bf2c-b61c461410cb/17_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_b35629de-38d8-4cdd-bf2c-b61c461410cb_SNAPO__SNAPS_','2022-02-07 18:07:23','2022-02-07 19:05:55','17_w1_o1_snapshot_occ_file_0.png','2022-02-07 19:07:23','SYNCED','9bc487be-aea8-4232-90ae-806369f205fd',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'9c197d27-028f-4f29-873a-a3f68074f173','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/scan_90beda40-67c7-49a2-88be-64610235c1c8/19_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_FRSC_90beda40-67c7-49a2-88be-64610235c1c8_SNAPS_','2022-03-08 11:12:11','2022-03-08 12:12:02','19_w1_o1_mordu_anterieur_snapshot_0.png','2022-03-08 12:12:11','SYNCED','9c197d27-028f-4f29-873a-a3f68074f173',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.19.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'9d4d6431-d42e-4d0f-aeb9-24b3faf6a0d2','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/c8418992-7324-4a11-9437-bf2bb0fa802f/session_ff05cb1f-6c46-4287-9cdd-81bf817a9c78/occlusion_f6f084bb-a5f1-4f39-860f-1483132c8283/scan_9263fb3c-bf3a-443f-8c9b-4d12244b4612/11_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_c8418992-7324-4a11-9437-bf2bb0fa802f_ACT_ff05cb1f-6c46-4287-9cdd-81bf817a9c78_SESS_f6f084bb-a5f1-4f39-860f-1483132c8283_TOSC_9263fb3c-bf3a-443f-8c9b-4d12244b4612_SNAPS_','2022-01-25 15:45:57','2022-01-25 16:45:25','11_w1_o1_maxillaire_snapshot_1.png','2022-01-25 16:45:57','SYNCED','20010b5b-e8eb-499b-8bf9-25f8af288f05',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.11.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'9d63c9e3-26ee-496a-aee1-ec6b35f881e5','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/scan_2a38e9c2-6808-43f3-904a-decdb37d60d5/4_w1_o4_mandibule_scan_file_0.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_BOSC_2a38e9c2-6808-43f3-904a-decdb37d60d5_ZIP_','2022-05-31 12:03:44','2022-05-31 14:03:35','4_w1_o4_mandibule_scan_file_0.zip','2022-05-31 14:03:44','SYNCED','9d63c9e3-26ee-496a-aee1-ec6b35f881e5',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.4.1\",\"modelMatrix\":\"-0.629357,-0.770163,0.103726,0,0.777116,-0.623726,0.0840038,0,8.35188e-10,0.133476,0.991052,0,1.59326,-0.77893,-20.701,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'9d6855d8-8a5f-4524-991e-ab57f21501ab','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/e922efb9-8c03-445b-8a0f-449e3c43bdca/session_a2369349-1629-40ad-8784-d271bc3fbade/occlusion_292cc1aa-8b12-463b-87a1-7d9731cf886b/scan_171c6386-cba0-454c-a194-380c61a2ad2d/21_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_e922efb9-8c03-445b-8a0f-449e3c43bdca_ACT_a2369349-1629-40ad-8784-d271bc3fbade_SESS_292cc1aa-8b12-463b-87a1-7d9731cf886b_BOSC_171c6386-cba0-454c-a194-380c61a2ad2d_SNAPS_','2022-04-21 08:45:31','2022-04-21 10:45:20','21_w1_o1_mandibule_snapshot_0.png','2022-04-21 10:45:31','SYNCED','9d6855d8-8a5f-4524-991e-ab57f21501ab',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.21.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'9db18e41-2237-4adc-8007-8d9bafdcf55f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_2a7068fc-0efa-496f-ade9-aba5b0650655/12_w1_o1_mandibule_snapshot_5.png','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_2a7068fc-0efa-496f-ade9-aba5b0650655_SNAPS_','2022-02-04 12:08:36','2022-02-04 13:08:17','12_w1_o1_mandibule_snapshot_5.png','2022-02-04 13:08:36','SYNCED','7636e0d7-f242-431c-90a5-a65399d83ecd',5,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.5\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'9dd0c754-d272-45ee-aa54-5d3030ae4573','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/scan_c1f909ab-5469-4839-84f1-d04759dd1237/1_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_BOSC_c1f909ab-5469-4839-84f1-d04759dd1237_ZIP_','2022-01-19 12:59:55','2022-01-19 11:51:31','1_w1_o1_mandibule_scan_file_0.zip','2022-01-19 13:59:55','SYNCED','9dd0c754-d272-45ee-aa54-5d3030ae4573',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.1.1.1.1\",\"modelMatrix\":\"-0.978511,0.202624,-0.0382083,0,-0.206195,-0.961565,0.18132,0,1.68873e-9,0.185302,0.982682,0,35.5572,6.72193,-16.6463,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'9e1292ba-2d2b-4b4c-8e8c-1c5231018cf4','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/computedocclusion_7c70edbe-5cb4-4244-8baf-7caf2bd7d86b/12_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_OCC_7c70edbe-5cb4-4244-8baf-7caf2bd7d86b_TOPLY__ZIP_','2022-02-04 17:59:48','2022-02-04 18:58:48','12_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-02-04 18:59:48','SYNCED','9e1292ba-2d2b-4b4c-8e8c-1c5231018cf4',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.12.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.622652,0.772747,-0.123153,0,-0.782499,0.614892,-0.0979959,0,-5.00422e-9,0.157385,0.987537,0,-21.5256,-19.2669,-19.1349,1\",\"referenceScanID\":\"1.12.1.1.1\",\"title\":\"Maxillaire 1.12.1.1.1 Occlusion 1\"}'),(1001,'9e13d9e3-cdab-4d9f-ad77-b8a3cbfbd2c9','','MATRX','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_26ae7fce-0ea3-479f-9989-7d0a3a19aaf7_BOMA__MATRX_','2022-02-08 08:49:00','2022-02-07 18:58:31','','2022-02-08 09:49:00','SYNCED','9e13d9e3-cdab-4d9f-ad77-b8a3cbfbd2c9',0,'2022-02-08 09:49:00','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.17.1.1.1 Occlusion 6\",\"referenceScanID\":\"1.17.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.17.1.1.1 Occlusion 6\"}'),(2,'9e45c2ae-5076-435b-8537-ce6255f263b3','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a47006e-5c4a-4fab-835f-67e3301b2acf/session_d0298050-98d9-4076-b3bd-110404d60135/occlusion_c5f98876-f420-4912-bd39-cfffac649936/scan_41295122-614f-4e97-b820-f8a9940950f4/4_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_6a47006e-5c4a-4fab-835f-67e3301b2acf_ACT_d0298050-98d9-4076-b3bd-110404d60135_SESS_c5f98876-f420-4912-bd39-cfffac649936_TOSC_41295122-614f-4e97-b820-f8a9940950f4_SNAPS_','2022-09-06 09:20:24','2022-09-06 11:20:24','4_w1_o1_maxillaire_snapshot_0.png',NULL,'CREATED','9e45c2ae-5076-435b-8537-ce6255f263b3',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire SNAPSHOT\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'9eb7d518-a769-4fd8-9066-a0f2ece8f396','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/458c92d8-9da1-4df9-967f-d14fc7e6303d/session_55831d43-1906-4a22-9b7a-ed4b2820c8b2/occlusion_4f582d4c-81d0-4e01-8be3-9ff53b12c7f4/scan_19e6ea5c-af28-439b-bc57-b561cd42e12b/10_w2_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_55831d43-1906-4a22-9b7a-ed4b2820c8b2_SESS_4f582d4c-81d0-4e01-8be3-9ff53b12c7f4_TOSC_19e6ea5c-af28-439b-bc57-b561cd42e12b_ZIP_','2022-06-16 13:17:46','2022-06-16 15:17:36','10_w2_o1_maxillaire_scan_file_0.zip','2022-06-16 15:17:46','SYNCED','9eb7d518-a769-4fd8-9066-a0f2ece8f396',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.10.2.1.1\",\"modelMatrix\":\"-0.0964683,-0.959476,0.264765,0,0.995336,-0.0929927,0.0256611,0,-1.25281e-09,0.266005,0.963971,0,4.90102,-7.21788,-24.7307,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'9ee0ae1d-fe0a-4553-9d50-11a13c8b42fc','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/207d6dbc-c19b-4726-a9b3-16235ae554cc/session_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35/occlusion_dc5762a3-c453-4166-8c86-82d23ac9f8a6/computedocclusion_3a1fff1c-0427-409c-aa94-06326e554d82/27_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_207d6dbc-c19b-4726-a9b3-16235ae554cc_ACT_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35_SESS_dc5762a3-c453-4166-8c86-82d23ac9f8a6_OCC_3a1fff1c-0427-409c-aa94-06326e554d82_SNAPO__SNAPS_','2022-05-30 11:09:40','2022-05-30 13:09:22','27_w1_o1_snapshot_occ_file_0.png','2022-05-30 13:09:40','SYNCED','9ee0ae1d-fe0a-4553-9d50-11a13c8b42fc',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'9ee12909-baa5-4a11-9161-ac732edc1263','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/de078619-3946-4adb-a799-1c260e16face/session_24d0aeb5-3058-4070-aeea-97c289e41e3c/occlusion_ea6da896-1504-41fc-890c-7c48575e9e40/computedocclusion_a15a6719-2996-4256-93d7-515e4d4f5bef/2_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_de078619-3946-4adb-a799-1c260e16face_ACT_24d0aeb5-3058-4070-aeea-97c289e41e3c_SESS_ea6da896-1504-41fc-890c-7c48575e9e40_OCC_a15a6719-2996-4256-93d7-515e4d4f5bef_TOPLY__ZIP_','2022-01-19 14:47:45','2022-01-19 15:46:49','2_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-01-19 15:47:45','SYNCED','9ee12909-baa5-4a11-9161-ac732edc1263',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.2.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.999693,0.0234182,-0.00803445,0,-0.0247581,0.94559,-0.324418,0,2.12043e-11,0.324518,0.94588,0,-21.3098,-33.4944,-23.4708,1\",\"referenceScanID\":\"1.2.1.1.1\",\"title\":\"Maxillaire 1.2.1.1.1 Occlusion 1\"}'),(1001,'9f084861-d8a3-4071-b9c8-235aab6b53fe','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/occlusion_a2220645-c79d-4dda-b6cc-772384a4106b/computedocclusion_8b14563e-0862-4cac-8045-e8aed2be886d/38_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_OCC_8b14563e-0862-4cac-8045-e8aed2be886d_BOMA__MATRX_','2022-07-12 10:57:42','2022-07-12 12:57:24','38_w1_o1_mandibule_matrix_occ_file_0.m','2022-07-12 12:57:42','SYNCED','9f084861-d8a3-4071-b9c8-235aab6b53fe',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.38.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.38.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.38.1.1.1 Occlusion 1\"}'),(1001,'9f767c47-1f3f-419b-800a-e52cc2aafb11','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/discussion_4d12bcc3-80f2-49dc-9159-54929f160ce6/9f767c47-1f3f-419b-800a-e52cc2aafb11.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_426bd908-3163-4291-a697-20eacff771ab_SNAPO__SNAPS_','2022-05-25 08:56:24','2022-05-16 19:57:11','9f767c47-1f3f-419b-800a-e52cc2aafb11.png','2022-05-25 10:56:24','SYNCED','9f767c47-1f3f-419b-800a-e52cc2aafb11',0,'2022-05-25 10:56:24','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'9f899abf-8146-4e60-b6b9-0479f28a9141','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/scan_255c9e68-7cd6-413d-ba72-261666fdb488/19_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_BOSC_255c9e68-7cd6-413d-ba72-261666fdb488_ZIP_','2022-03-08 10:56:17','2022-03-08 11:56:13','19_w1_o1_mandibule_scan_file_0.zip','2022-03-08 11:56:17','SYNCED','9f899abf-8146-4e60-b6b9-0479f28a9141',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.1.6\",\"modelMatrix\":\"0.960036,-0.234632,0.152577,0,0.279878,0.804832,-0.523368,0,4.54095e-09,0.545155,0.838335,0,-2.16511,-15.3211,-15.1064,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'9faedb0a-5c1a-4ea6-b027-8e5f8df16abc','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/scan_f5ab063d-18f1-443e-b694-fd1ef20e9e78/4_w1_o4_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_LESC_f5ab063d-18f1-443e-b694-fd1ef20e9e78_ZIP_','2022-05-31 12:09:43','2022-05-31 14:09:38','4_w1_o4_mordu_posterieur_gauche_scan_file_0.zip','2022-05-31 14:09:43','SYNCED','9faedb0a-5c1a-4ea6-b027-8e5f8df16abc',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.4.1.4.1\",\"modelMatrix\":\"-0.998155,0.0210725,0.0625312,0,-0.00999653,-0.998165,0.0577016,0,0.0604331,0.0572825,0.996378,0,-3.01752,-2.21358,-18.2835,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'9fe8afd4-2328-4751-9d29-f1bedd1325b2','','ZIP','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_RISC_029ae158-d269-4f43-b5ee-add7ce3f59c5_ZIP_','2022-04-21 13:44:33','2022-04-21 13:25:56','','2022-04-21 15:44:33','SYNCED','9fe8afd4-2328-4751-9d29-f1bedd1325b2',0,'2022-04-21 15:44:33','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.22.1.1.4\",\"modelMatrix\":\"0.998263,0.0528348,0.0197903,0,-0.0571413,0.993325,0.10153,0,-0.0145614,-0.102565,0.994636,0,5.1608,4.26452,-17.249,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'9ff81c89-8932-4154-acbf-a1b46fe30571','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f4fc00ec-4af8-4a15-b427-f1c5aabf6260/session_498ae60a-23f0-44fc-9730-be499bfc4b46/occlusion_8f3d6c73-3468-45a5-85c7-93bba47ec9f7/scan_60c1cc80-0d70-4511-8993-70e3a3c146b8/30_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_f4fc00ec-4af8-4a15-b427-f1c5aabf6260_ACT_498ae60a-23f0-44fc-9730-be499bfc4b46_SESS_8f3d6c73-3468-45a5-85c7-93bba47ec9f7_BOSC_60c1cc80-0d70-4511-8993-70e3a3c146b8_SNAPS_','2022-06-14 13:16:26','2022-06-14 15:16:17','30_w1_o1_mandibule_snapshot_0.png','2022-06-14 15:16:26','SYNCED','9ff81c89-8932-4154-acbf-a1b46fe30571',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.30.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'a0900aa8-5d3a-417a-b72a-99a7368de3b7','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_2ffbfbca-f236-4802-be93-8eb43d523274/scan_eb904683-acc6-4e6d-8900-3982d403ba0f/4_w1_o1_mordu_anterieur_scan_file_1.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_2ffbfbca-f236-4802-be93-8eb43d523274_FRSC_eb904683-acc6-4e6d-8900-3982d403ba0f_ZIP_','2022-01-19 19:13:33','2022-01-19 20:13:23','4_w1_o1_mordu_anterieur_scan_file_1.zip','2022-01-19 20:13:33','SYNCED','df493b46-f498-46f5-862e-735db106fc71',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.4.1.1.1\",\"modelMatrix\":\"0.92977,-0.258814,0.27194,0,0.220301,0.966039,0.0839037,0,-0.29607,-0.0183757,0.958759,0,4.8152,-6.1951,-20.4448,1\",\"title\":\"Mordu anterieur ZIP\"}'),(2,'a0e5b4b9-4dd7-461c-9ae7-afaffaa18202','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a4b302c-278d-4e12-ace5-f095ba0bf856/session_6206892a-2e7e-4765-ac90-b49bfb465997/occlusion_3c30231c-7cd7-4431-985b-2eaf7f6925ae/scan_587e0605-ba57-4583-83e9-a1cc32707c91/3_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_587e0605-ba57-4583-83e9-a1cc32707c91_SNAPS_','2022-09-06 09:17:50','2022-08-30 10:53:38','3_w1_o1_maxillaire_snapshot_0.png','2022-09-06 11:17:50','SYNCED','a0e5b4b9-4dd7-461c-9ae7-afaffaa18202',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.3.1.1.4\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'a0f1c5f4-8b35-4db9-8ae4-da64e546d1f6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/scan_f4fff5f5-f728-44ae-ac48-f3e653594098/23_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_FRSC_f4fff5f5-f728-44ae-ac48-f3e653594098_SNAPS_','2022-05-13 10:11:34','2022-05-13 12:11:24','23_w1_o1_mordu_anterieur_snapshot_0.png','2022-05-13 12:11:34','SYNCED','a0f1c5f4-8b35-4db9-8ae4-da64e546d1f6',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.23.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'a13ef72a-3421-4e8c-a897-3f43da14e842','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_1c86378e-7d31-4b12-82ff-af797020160f/4_w1_o2_mandibule_snapshot_0.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_BOSC_1c86378e-7d31-4b12-82ff-af797020160f_SNAPS_','2022-03-08 11:34:09','2022-03-08 12:34:00','4_w1_o2_mandibule_snapshot_0.png','2022-03-08 12:34:09','SYNCED','a13ef72a-3421-4e8c-a897-3f43da14e842',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.2.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'a1b9dbd6-1067-4531-89ab-a474ccdccbfe','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7f47fd88-9ea0-4c08-9193-a54d4f158c7c/session_7873a396-419c-4215-83c7-fec9f2742ccf/occlusion_2e287bb0-e19a-414a-9177-23b335d286d9/computedocclusion_389a085b-21e0-4004-9d53-dfcb5c4bd2f1/16_w1_o2_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_7f47fd88-9ea0-4c08-9193-a54d4f158c7c_ACT_7873a396-419c-4215-83c7-fec9f2742ccf_SESS_2e287bb0-e19a-414a-9177-23b335d286d9_OCC_389a085b-21e0-4004-9d53-dfcb5c4bd2f1_BOPLY__ZIP_','2022-06-03 09:04:39','2022-06-03 11:04:23','16_w1_o2_mandibule_occlusion_occ_file_0.zip','2022-06-03 11:04:39','SYNCED','a1b9dbd6-1067-4531-89ab-a474ccdccbfe',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.16.1.2.1 Occlusion 1\",\"modelMatrix\":\"-0.864845,0.473616,-0.166526,0,-0.502038,-0.815882,0.286869,0,-7.35692e-09,0.3317,0.943385,0,-0.119603,-7.43592,-19.1524,1\",\"referenceScanID\":\"1.16.1.2.1\",\"title\":\"Mandibule 1.16.1.2.1 Occlusion 1\"}'),(1001,'a21ef8f4-f744-47a0-a25e-660ba3f7901b','','SNAPS','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_c9079d19-8ffb-46f7-a51e-3a7a90ccae59_SESS_8ba0f3b1-408f-4a02-92a0-63f09123b68e_BOSC_cf1df2e4-52f9-48a2-8e0b-54a1e4ed5741_SNAPS_','2022-01-28 17:15:45','2022-01-26 15:48:06','','2022-01-28 18:15:45','SYNCED','cdd9fdce-3676-419e-aab1-ed095f43e2bf',1,'2022-01-28 18:15:45','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.10.1.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'a25ff0a9-2187-4450-a8c0-3e7dd53302af','','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_BOSC_07148fa2-1d5b-4343-81f9-ef44df15e4c7_SNAPS_','2022-02-19 17:53:24','2022-02-14 19:20:08','','2022-02-19 18:53:24','SYNCED','a25ff0a9-2187-4450-a8c0-3e7dd53302af',0,'2022-02-19 18:53:24','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.4.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'a27566e2-5edb-4da7-b379-b24af5d20c36','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_c76850a7-9433-47f8-825d-ced9f35dede0/24_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_BOSC_c76850a7-9433-47f8-825d-ced9f35dede0_ZIP_','2022-05-13 14:11:03','2022-05-13 16:10:51','24_w1_o1_mandibule_scan_file_0.zip','2022-05-13 16:11:03','SYNCED','a27566e2-5edb-4da7-b379-b24af5d20c36',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.24.1.1.1\",\"modelMatrix\":\"0.852703,-0.521011,0.0380208,0,0.522396,0.850441,-0.062061,0,3.49638e-10,0.0727815,0.997348,0,-11.3911,-12.8136,-21.1334,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'a2b88e98-2d9c-4985-b0c8-0632851521ac','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/computedocclusion_b35629de-38d8-4cdd-bf2c-b61c461410cb/17_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_b35629de-38d8-4cdd-bf2c-b61c461410cb_TOPLY__ZIP_','2022-02-07 18:09:03','2022-02-07 19:05:55','17_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-02-07 19:09:03','SYNCED','a2b88e98-2d9c-4985-b0c8-0632851521ac',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.17.1.1.1 Occlusion 6\",\"modelMatrix\":\"0.149253,0.920186,-0.361913,0,-0.988799,0.138896,-0.0546284,0,-8.90892e-10,0.366013,0.93061,0,-24.4594,-29.735,-12.8678,1\",\"referenceScanID\":\"1.17.1.1.1\",\"title\":\"Maxillaire 1.17.1.1.1 Occlusion 6\"}'),(1001,'a3123ce9-0a29-44e7-bcac-a52435f09641','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/scan_64badb85-f6d8-46a0-8cc4-2125845f9e47/22_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_RISC_64badb85-f6d8-46a0-8cc4-2125845f9e47_ZIP_','2022-04-21 11:13:13','2022-04-21 13:13:07','22_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-04-21 13:13:13','SYNCED','a3123ce9-0a29-44e7-bcac-a52435f09641',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.22.1.1.3\",\"modelMatrix\":\"0.985334,-0.166578,0.0259059,0,0.170153,0.983505,-0.0709395,0,-0.0130759,0.0706275,0.997151,0,-0.724133,-4.65401,-17.4344,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'a353c4ca-59ef-4c7c-a4bd-45852b0bd715','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/order_8a9c0203-cf65-4431-a383-136329150bbd/12_w1_autre_prost_file_a353c4ca-59ef-4c7c-a4bd-45852b0bd715_0.pdf','PDF','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_PROST_8a9c0203-cf65-4431-a383-136329150bbd_PDF_','2022-02-04 18:06:55','2022-02-04 19:06:54','12_w1_autre_prost_file_a353c4ca-59ef-4c7c-a4bd-45852b0bd715_0.pdf','2022-02-04 19:06:55','SYNCED','a353c4ca-59ef-4c7c-a4bd-45852b0bd715',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.12.1.1 AUTRE FICHE DE PROTHESE\",\"title\":\"Autre PDF\"}'),(1001,'a360a2dd-98b2-4d38-8590-55792ba9a418','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/scan_eafe4b37-e7ad-4f58-b931-a99f31f6d4a4/22_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_BOSC_eafe4b37-e7ad-4f58-b931-a99f31f6d4a4_ZIP_','2022-04-21 10:50:46','2022-04-21 12:50:37','22_w1_o1_mandibule_scan_file_1.zip','2022-04-21 12:50:46','SYNCED','68e7c3a1-6552-416d-a849-77f78c6c1539',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.22.1.1.1\",\"modelMatrix\":\"0.955284,-0.295231,0.0164688,0,0.29569,0.953801,-0.0532056,0,-9.04209e-10,0.0556961,0.998448,0,-1.05738,9.66348,-22.4364,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'a3983784-e00f-4a0d-ac07-1fa9e1c16ad9','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_d1eece96-1e6b-468d-8dc5-8295ca2149a4/24_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_LESC_d1eece96-1e6b-468d-8dc5-8295ca2149a4_SNAPS_','2022-05-13 14:46:32','2022-05-13 16:46:22','24_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-05-13 16:46:32','SYNCED','a3983784-e00f-4a0d-ac07-1fa9e1c16ad9',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.24.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'a3e66aa6-7b7c-4d22-b55c-65dba960ada3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_16f04a07-72e8-4a39-9b55-3ae7405733af/24_w1_o1_maxillaire_scan_file_3.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_TOSC_16f04a07-72e8-4a39-9b55-3ae7405733af_ZIP_','2022-06-13 14:49:07','2022-06-13 16:48:56','24_w1_o1_maxillaire_scan_file_3.zip','2022-06-13 16:49:07','SYNCED','d3ff533f-e540-46c8-8f68-b5341a94ad72',3,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.4\",\"modelMatrix\":\"0.468816,0.851463,-0.234993,0,-0.883296,0.451921,-0.124724,0,3.16254e-09,0.266041,0.963962,0,-15.9085,-5.48362,-18.8921,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'a3f2a1f8-ae1e-48e1-a6ab-515fa04c3b55','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f9d03016-567a-4bd4-9cc5-dafeea34e365/session_a7bcb190-dd19-4f3b-8aab-266030bf4064/occlusion_c321e210-b67c-40e8-bece-f8946164a768/scan_e7993d2d-cc6b-42d8-af77-232b04342812/36_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_f9d03016-567a-4bd4-9cc5-dafeea34e365_ACT_a7bcb190-dd19-4f3b-8aab-266030bf4064_SESS_c321e210-b67c-40e8-bece-f8946164a768_TOSC_e7993d2d-cc6b-42d8-af77-232b04342812_SNAPS_','2022-07-04 14:04:56','2022-07-04 16:04:45','36_w1_o1_maxillaire_snapshot_0.png','2022-07-04 16:04:56','SYNCED','a3f2a1f8-ae1e-48e1-a6ab-515fa04c3b55',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.36.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'a40d913c-74f9-49c2-a50f-cc2226955dfa','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f9d03016-567a-4bd4-9cc5-dafeea34e365/session_a7bcb190-dd19-4f3b-8aab-266030bf4064/occlusion_c321e210-b67c-40e8-bece-f8946164a768/computedocclusion_03fe87bc-2a25-4d16-a476-2df62bb3cf76/36_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_f9d03016-567a-4bd4-9cc5-dafeea34e365_ACT_a7bcb190-dd19-4f3b-8aab-266030bf4064_SESS_c321e210-b67c-40e8-bece-f8946164a768_OCC_03fe87bc-2a25-4d16-a476-2df62bb3cf76_BOPLY__ZIP_','2022-07-04 14:14:02','2022-07-04 16:13:45','36_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-07-04 16:14:02','SYNCED','a40d913c-74f9-49c2-a50f-cc2226955dfa',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.36.1.1.1 Occlusion 2\",\"modelMatrix\":\"0.642095,-0.756672,0.12313,0,0.766625,0.633759,-0.103128,0,-2.36675e-09,0.160612,0.987018,0,-11.9604,2.52084,-21.6228,1\",\"referenceScanID\":\"1.36.1.1.1\",\"title\":\"Mandibule 1.36.1.1.1 Occlusion 2\"}'),(1001,'a4310095-689c-47d1-a99d-3dfc77d2344e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/occlusion_a2220645-c79d-4dda-b6cc-772384a4106b/scan_0136d883-d517-448a-82a3-bfcdd5f4c35c/38_w1_o1_maxillaire_ml_0_0.xyz','LIFI','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_TOSC_0136d883-d517-448a-82a3-bfcdd5f4c35c_LIFI_','2022-07-19 12:28:52','2022-07-19 14:28:51','38_w1_o1_maxillaire_ml_0_0.xyz','2022-07-19 14:28:52','SYNCED','a4310095-689c-47d1-a99d-3dfc77d2344e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.38.1.1.1 Ligne de finition 0\",\"name\":\"Ligne de finition 0\",\"title\":\"Maxillaire LIFI\",\"toothNumber\":0,\"versionMarginLine\":1}'),(1001,'a47f7028-b44e-4922-80ba-98156019677c','','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_BOSC_4aa73b1e-d6d0-436c-8abe-c649026c7ff2_ZIP_','2022-02-19 17:53:24','2022-02-14 18:57:22','','2022-02-19 18:53:24','SYNCED','a47f7028-b44e-4922-80ba-98156019677c',0,'2022-02-19 18:53:24','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.4.1\",\"modelMatrix\":\"-0.464753,-0.88126,0.0859365,0,0.88544,-0.462559,0.0451066,0,5.93096e-10,0.0970551,0.995279,0,4.38335,16.2715,-22.6813,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'a4896c47-7cb7-4dae-83eb-fa24f032eea2','','MATRX','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_OCC_ac3a5a7c-5db4-4c82-a2a9-9cb52e09f003_TOMA__MATRX_','2022-05-12 12:34:04','2022-05-12 14:33:33','',NULL,'CREATED','a4896c47-7cb7-4dae-83eb-fa24f032eea2',0,'2022-05-12 14:34:04','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.18.1.1.2 Occlusion 4\",\"referenceScanID\":\"1.18.1.1.2\",\"title\":\"Matrice Transfo. Maxillaire 1.18.1.1.2 Occlusion 4\"}'),(1001,'a54c946c-a9df-45b0-aa2e-35efdf9f6439','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/57c4096f-98dd-49c8-bea5-a5b109ad3fd0/session_4f62e395-5623-4d5b-869c-1b2fc4d22b00/occlusion_1ac20dc7-b36b-4786-a05f-37091554dc5c/computedocclusion_70f4220e-2a6b-4575-bd0e-09c14a13d758/31_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_57c4096f-98dd-49c8-bea5-a5b109ad3fd0_ACT_4f62e395-5623-4d5b-869c-1b2fc4d22b00_SESS_1ac20dc7-b36b-4786-a05f-37091554dc5c_OCC_70f4220e-2a6b-4575-bd0e-09c14a13d758_TOPLY__ZIP_','2022-06-16 11:04:11','2022-06-16 13:03:55','31_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-06-16 13:04:11','SYNCED','a54c946c-a9df-45b0-aa2e-35efdf9f6439',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.31.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.997887,0.0642305,-0.00984649,0,-0.0649809,0.986364,-0.151209,0,-4.81543e-10,0.151529,0.988453,0,-2.47476,-6.56649,-21.1676,1\",\"referenceScanID\":\"1.31.1.1.1\",\"title\":\"Maxillaire 1.31.1.1.1 Occlusion 1\"}'),(1001,'a592e8f8-a0ee-44b9-9aa2-9e88a48ddca9','','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_1500b3eb-4b86-46c1-9c9f-7efbd0224ac8_BOPLY__ZIP_','2022-05-25 08:56:38','2022-05-13 18:22:04','','2022-05-25 10:56:38','SYNCED','a592e8f8-a0ee-44b9-9aa2-9e88a48ddca9',0,'2022-05-25 10:56:38','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.24.1.1.1 Occlusion 4\",\"modelMatrix\":\"0.852703,-0.521011,0.0380208,0,0.522396,0.850441,-0.062061,0,3.49638e-10,0.0727815,0.997348,0,-11.3911,-12.8136,-21.1334,1\",\"referenceScanID\":\"1.24.1.1.1\",\"title\":\"Mandibule 1.24.1.1.1 Occlusion 4\"}'),(1001,'a5a65004-12be-4f11-9b79-c3b1d218f4df','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_b1201d2a-0fbf-48bc-a1c2-f3649c1ca576/18_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_BOSC_b1201d2a-0fbf-48bc-a1c2-f3649c1ca576_ZIP_','2022-05-10 14:00:12','2022-05-10 16:00:02','18_w1_o1_mandibule_scan_file_0.zip','2022-05-10 16:00:12','SYNCED','a5a65004-12be-4f11-9b79-c3b1d218f4df',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.18.1.1.3\",\"modelMatrix\":\"-0.721265,0.622319,-0.304132,0,-0.69266,-0.648019,0.316692,0,5.59464e-09,0.439079,0.898449,0,-8.58806,-18.2472,-17.8803,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'a5ed4ec1-1055-4583-8f19-2ee0942ee99d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/d100e894-0be9-4495-94e2-e469232f7817/session_2c8b85b5-c805-4b08-85e7-3d02dab72e99/occlusion_8a278cc5-a1c1-4dfb-9ee2-c971a6309afa/scan_6c418416-1c53-40cd-ba49-f56373b0bc1a/15_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_d100e894-0be9-4495-94e2-e469232f7817_ACT_2c8b85b5-c805-4b08-85e7-3d02dab72e99_SESS_8a278cc5-a1c1-4dfb-9ee2-c971a6309afa_BOSC_6c418416-1c53-40cd-ba49-f56373b0bc1a_SNAPS_','2022-02-01 15:02:14','2022-02-01 16:01:53','15_w1_o1_mandibule_snapshot_0.png','2022-02-01 16:02:14','SYNCED','a5ed4ec1-1055-4583-8f19-2ee0942ee99d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.15.1.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'a6877aaa-6599-4bba-a1a9-275adfcb1c68','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_4ed7adaa-3b77-4537-8479-4d0c4bd28c7b/12_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_TOSC_4ed7adaa-3b77-4537-8479-4d0c4bd28c7b_ZIP_','2022-01-27 11:58:32','2022-01-27 12:58:07','12_w1_o1_maxillaire_scan_file_1.zip','2022-01-27 12:58:32','SYNCED','3188c2ad-80df-4826-920c-b8f1b834ccf5',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.12.1.1.1\",\"modelMatrix\":\"0.622652,0.772747,-0.123153,0,-0.782499,0.614892,-0.0979959,0,-5.00422e-9,0.157385,0.987537,0,-21.5256,-19.2669,-19.1349,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'a68a9b64-1e64-43ce-b4bd-a56d3a3ef762','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f9d03016-567a-4bd4-9cc5-dafeea34e365/session_a7bcb190-dd19-4f3b-8aab-266030bf4064/occlusion_c321e210-b67c-40e8-bece-f8946164a768/scan_21fc87fa-c767-4333-893a-3f0ab5cd76f2/36_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_f9d03016-567a-4bd4-9cc5-dafeea34e365_ACT_a7bcb190-dd19-4f3b-8aab-266030bf4064_SESS_c321e210-b67c-40e8-bece-f8946164a768_LESC_21fc87fa-c767-4333-893a-3f0ab5cd76f2_SNAPS_','2022-07-04 14:12:22','2022-07-04 16:12:14','36_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-07-04 16:12:22','SYNCED','a68a9b64-1e64-43ce-b4bd-a56d3a3ef762',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.36.1.1.2\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'a68c2300-df5c-4b80-adbc-59147c325c82','','ZIP','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_OCC_ac3a5a7c-5db4-4c82-a2a9-9cb52e09f003_TOPLY__ZIP_','2022-05-12 12:34:04','2022-05-12 14:33:34','',NULL,'CREATED','a68c2300-df5c-4b80-adbc-59147c325c82',0,'2022-05-12 14:34:04','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.18.1.1.2 Occlusion 4\",\"modelMatrix\":\"-0.979743,-0.199678,0.0152522,0,0.20026,-0.976897,0.0746194,0,-1.52856e-10,0.0761623,0.997095,0,19.5629,-11.4708,-22.5064,1\",\"referenceScanID\":\"1.18.1.1.2\",\"title\":\"Maxillaire 1.18.1.1.2 Occlusion 4\"}'),(1001,'a6c18f23-3ae1-43e9-9a43-453be1c719a4','','SNAPS','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_BOSC_3379235c-b42d-440c-84bc-d105a1d56127_SNAPS_','2022-03-09 07:54:47','2022-03-08 11:27:31','','2022-03-09 08:54:47','SYNCED','a6c18f23-3ae1-43e9-9a43-453be1c719a4',0,'2022-03-09 08:54:47','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'a8374abc-5fc4-4fa5-ae16-6f40012d91fe','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_4f8dc275-857c-482a-9886-5521591e9661/scan_000f859e-bd0c-453b-b60b-dddef781cd58/12_w1_o4_maxillaire_scan_file_0.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_TOSC_000f859e-bd0c-453b-b60b-dddef781cd58_ZIP_','2022-02-14 17:48:23','2022-02-14 18:48:10','12_w1_o4_maxillaire_scan_file_0.zip','2022-02-14 18:48:23','SYNCED','a8374abc-5fc4-4fa5-ae16-6f40012d91fe',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.12.1.4.2\",\"modelMatrix\":\"0.391933,0.866585,-0.308901,0,-0.919994,0.369179,-0.131597,0,-2.19795e-09,0.335764,0.941946,0,-18.947,-18.6547,-19.6427,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'a8876c47-7256-480c-887f-a31e06590e3b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/458c92d8-9da1-4df9-967f-d14fc7e6303d/session_55831d43-1906-4a22-9b7a-ed4b2820c8b2/occlusion_4f582d4c-81d0-4e01-8be3-9ff53b12c7f4/scan_6d0788eb-96a4-43dc-aa97-e9dbd7601d00/10_w2_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_55831d43-1906-4a22-9b7a-ed4b2820c8b2_SESS_4f582d4c-81d0-4e01-8be3-9ff53b12c7f4_BOSC_6d0788eb-96a4-43dc-aa97-e9dbd7601d00_ZIP_','2022-06-16 13:35:06','2022-06-16 15:34:57','10_w2_o1_mandibule_scan_file_0.zip','2022-06-16 15:35:06','SYNCED','a8876c47-7256-480c-887f-a31e06590e3b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.10.2.1.2\",\"modelMatrix\":\"0.582885,-0.72158,0.373587,0,0.812555,0.517624,-0.267992,0,3.71467e-09,0.459768,0.888039,0,16.6062,-17.753,-20.882,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'a88ec234-530c-4987-8fc0-9de5bb04a904','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_49bd090f-1a01-4a79-8202-62487b9af783/18_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_BOSC_49bd090f-1a01-4a79-8202-62487b9af783_SNAPS_','2022-03-07 14:12:06','2022-03-07 15:12:03','18_w1_o1_mandibule_snapshot_0.png','2022-03-07 15:12:06','SYNCED','a88ec234-530c-4987-8fc0-9de5bb04a904',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.18.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'a8e5687e-19fc-4dcf-955c-ddab334d6346','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/computedocclusion_35af1bf5-285a-4bb1-a6db-fe9897defe51/23_w1_o1_ml_occ_file_to1001.xyz','LIFI','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_35af1bf5-285a-4bb1-a6db-fe9897defe51_LIFIO_LIFI_','2022-05-25 10:45:10','2022-05-25 12:45:09','23_w1_o1_ml_occ_file_to1001.xyz','2022-05-25 12:45:10','SYNCED','a8e5687e-19fc-4dcf-955c-ddab334d6346',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.23.1.1.1 Occlusion 4 Ligne de finition 1\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"Maxillaire\",\"name\":\"Ligne de finition 1\",\"title\":\"Ligne finition\",\"toothNumber\":1001}'),(1001,'a8e57a61-55b2-4aa0-9a71-87da91116564','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/discussion_4d12bcc3-80f2-49dc-9159-54929f160ce6/a8e57a61-55b2-4aa0-9a71-87da91116564.m','MATRX','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_426bd908-3163-4291-a697-20eacff771ab_TOMA__MATRX_','2022-05-25 08:56:22','2022-05-16 19:57:11','a8e57a61-55b2-4aa0-9a71-87da91116564.m','2022-05-25 10:56:22','SYNCED','a8e57a61-55b2-4aa0-9a71-87da91116564',0,'2022-05-25 10:56:22','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.24.1.1.2 Occlusion 6\",\"referenceScanID\":\"1.24.1.1.2\",\"title\":\"Matrice Transfo. Maxillaire 1.24.1.1.2 Occlusion 6\"}'),(1001,'a8fe8aec-2370-4436-b402-eb13b571de0f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/fa7fa96b-f393-4b9a-8198-144702462cfa/session_4bed076c-8541-4a2f-800a-5aeb4cb49de5/occlusion_16b82fca-4b65-4866-af87-1f6dbb42f5dc/computedocclusion_94a0167c-6798-4c78-a76c-cb9fc91ccdda/35_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_fa7fa96b-f393-4b9a-8198-144702462cfa_ACT_4bed076c-8541-4a2f-800a-5aeb4cb49de5_SESS_16b82fca-4b65-4866-af87-1f6dbb42f5dc_OCC_94a0167c-6798-4c78-a76c-cb9fc91ccdda_BOPLY__ZIP_','2022-06-28 15:03:34','2022-06-28 17:03:25','35_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-06-28 17:03:34','SYNCED','a8fe8aec-2370-4436-b402-eb13b571de0f',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.35.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.0975586,0.955587,-0.278094,0,-0.99523,0.0936725,-0.0272605,0,1.35871e-09,0.279427,0.960167,0,-3.44734,-12.1676,-17.3219,1\",\"referenceScanID\":\"1.35.1.1.1\",\"title\":\"Mandibule 1.35.1.1.1 Occlusion 1\"}'),(1001,'a9375253-136d-4fb3-b6ba-de6ab06fadf3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_165dc4ed-fa76-4753-970f-5b2176e3e023/13_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_RISC_165dc4ed-fa76-4753-970f-5b2176e3e023_ZIP_','2022-02-04 17:55:11','2022-02-04 17:29:17','13_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-02-04 18:55:11','SYNCED','a9375253-136d-4fb3-b6ba-de6ab06fadf3',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.13.1.1.1\",\"modelMatrix\":\"0.998253,0.0534818,-0.0245601,0,-0.056238,0.998273,0.0259443,0,0.0195181,-0.024499,0.999383,0,-18.0163,0.483915,-16.2776,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'a97341f9-0b44-49b6-b4a3-32de704dc98d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_16f04a07-72e8-4a39-9b55-3ae7405733af/24_w1_o1_maxillaire_snapshot_2.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_TOSC_16f04a07-72e8-4a39-9b55-3ae7405733af_SNAPS_','2022-06-13 14:45:22','2022-06-13 16:45:09','24_w1_o1_maxillaire_snapshot_2.png','2022-06-13 16:45:22','SYNCED','ace017e9-ff30-403f-aee6-3daa66025d8d',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.4\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'a97cae90-ec12-4953-9507-bec2b3c4c454','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f4fc00ec-4af8-4a15-b427-f1c5aabf6260/session_498ae60a-23f0-44fc-9730-be499bfc4b46/occlusion_8f3d6c73-3468-45a5-85c7-93bba47ec9f7/scan_60c1cc80-0d70-4511-8993-70e3a3c146b8/30_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_f4fc00ec-4af8-4a15-b427-f1c5aabf6260_ACT_498ae60a-23f0-44fc-9730-be499bfc4b46_SESS_8f3d6c73-3468-45a5-85c7-93bba47ec9f7_BOSC_60c1cc80-0d70-4511-8993-70e3a3c146b8_SNAPS_','2022-06-14 13:19:48','2022-06-14 15:19:38','30_w1_o1_mandibule_snapshot_1.png','2022-06-14 15:19:48','SYNCED','9ff81c89-8932-4154-acbf-a1b46fe30571',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.30.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'a97e2cb6-17d0-493c-bf3b-0f57286e4530','','MATRX','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_OCC_a525c976-46dd-42bc-abc1-c7cf71f9a1f1_TOMA__MATRX_','2022-02-07 11:15:31','2022-02-04 14:58:28','','2022-02-07 12:15:31','SYNCED','a97e2cb6-17d0-493c-bf3b-0f57286e4530',0,'2022-02-07 12:15:31','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.12.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.12.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.12.1.1.1 Occlusion 1\"}'),(1001,'aa4c3fbb-0476-41cf-bb3e-f4c22e907f61','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7f47fd88-9ea0-4c08-9193-a54d4f158c7c/session_7873a396-419c-4215-83c7-fec9f2742ccf/occlusion_2e287bb0-e19a-414a-9177-23b335d286d9/computedocclusion_389a085b-21e0-4004-9d53-dfcb5c4bd2f1/16_w1_o2_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_7f47fd88-9ea0-4c08-9193-a54d4f158c7c_ACT_7873a396-419c-4215-83c7-fec9f2742ccf_SESS_2e287bb0-e19a-414a-9177-23b335d286d9_OCC_389a085b-21e0-4004-9d53-dfcb5c4bd2f1_TOMA__MATRX_','2022-06-03 09:04:40','2022-06-03 11:04:23','16_w1_o2_maxillaire_matrix_occ_file_0.m','2022-06-03 11:04:40','SYNCED','aa4c3fbb-0476-41cf-bb3e-f4c22e907f61',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.16.1.2.1 Occlusion 1\",\"referenceScanID\":\"1.16.1.2.1\",\"title\":\"Matrice Transfo. Maxillaire 1.16.1.2.1 Occlusion 1\"}'),(1001,'aa8c868e-3e96-48bf-8efd-588c479cb684','','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_9440baee-a8bf-406c-bc0a-f5e9596f197b_BOPLY__ZIP_','2022-05-13 16:14:03','2022-05-13 18:13:11','','2022-05-13 18:14:03','SYNCED','aa8c868e-3e96-48bf-8efd-588c479cb684',0,'2022-05-13 18:14:03','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.24.1.1.1 Occlusion 3\",\"modelMatrix\":\"0.852703,-0.521011,0.0380208,0,0.522396,0.850441,-0.062061,0,3.49638e-10,0.0727815,0.997348,0,-11.3911,-12.8136,-21.1334,1\",\"referenceScanID\":\"1.24.1.1.1\",\"title\":\"Mandibule 1.24.1.1.1 Occlusion 3\"}'),(1001,'aaada05c-7c17-4fd4-9b5b-8535148a93da','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/e922efb9-8c03-445b-8a0f-449e3c43bdca/session_a2369349-1629-40ad-8784-d271bc3fbade/occlusion_292cc1aa-8b12-463b-87a1-7d9731cf886b/scan_877e5641-7010-4a8d-99a9-8005d48d7ec6/21_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_e922efb9-8c03-445b-8a0f-449e3c43bdca_ACT_a2369349-1629-40ad-8784-d271bc3fbade_SESS_292cc1aa-8b12-463b-87a1-7d9731cf886b_LESC_877e5641-7010-4a8d-99a9-8005d48d7ec6_SNAPS_','2022-04-21 08:47:27','2022-04-21 10:47:20','21_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-04-21 10:47:27','SYNCED','aaada05c-7c17-4fd4-9b5b-8535148a93da',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.21.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(2,'aabf7c65-29e7-457f-9f52-8c1f1255556e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a4b302c-278d-4e12-ace5-f095ba0bf856/session_6206892a-2e7e-4765-ac90-b49bfb465997/occlusion_3c30231c-7cd7-4431-985b-2eaf7f6925ae/scan_53241704-034c-49e7-bd41-012398465214/3_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_53241704-034c-49e7-bd41-012398465214_SNAPS_','2022-09-06 09:17:50','2022-08-30 10:39:57','3_w1_o1_maxillaire_snapshot_0.png','2022-09-06 11:17:50','SYNCED','aabf7c65-29e7-457f-9f52-8c1f1255556e',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.3.1.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'aafe4d65-1e01-4ca4-bc19-034f5c3f3ed4','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/533d4409-e39d-4a27-a0af-b59e6cf76ce3/session_319a8f1d-33fc-4f87-a108-b3eabda0510f/occlusion_3b38f07b-42cb-40b1-933f-365e568702e4/scan_109ca2c4-8222-4d02-9ac7-b4b93937e1e2/37_w1_o1_maxillaire_snapshot_2.png','SNAPS','PATIENT_533d4409-e39d-4a27-a0af-b59e6cf76ce3_ACT_319a8f1d-33fc-4f87-a108-b3eabda0510f_SESS_3b38f07b-42cb-40b1-933f-365e568702e4_TOSC_109ca2c4-8222-4d02-9ac7-b4b93937e1e2_SNAPS_','2022-07-07 15:56:37','2022-07-07 17:56:25','37_w1_o1_maxillaire_snapshot_2.png','2022-07-07 17:56:37','SYNCED','6fa5ad33-3773-4801-9f0b-ed36985cc55e',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.37.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'ab4d888e-67b6-4e2d-b756-d99726b47b1b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_72adeb31-f7a3-4840-9f93-f10e61c84bef/4_w1_o2_maxillaire_snapshot_1.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_TOSC_72adeb31-f7a3-4840-9f93-f10e61c84bef_SNAPS_','2022-02-15 12:31:40','2022-02-15 13:31:26','4_w1_o2_maxillaire_snapshot_1.png','2022-02-15 13:31:40','SYNCED','3404669d-d29f-41be-8f3a-d80595434b84',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.4.1.2.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'abe9bf28-5109-4b6b-96f0-9db3d075c9ff','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/fa942554-dda6-4d2d-b578-ae9be6b3904d/session_b6039092-51ba-40dc-86e3-23be741dbb99/occlusion_e6bd34f2-af0e-48a6-9872-ec017a776e77/scan_1c59283c-95f4-431e-8b66-62a243009081/8_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_fa942554-dda6-4d2d-b578-ae9be6b3904d_ACT_b6039092-51ba-40dc-86e3-23be741dbb99_SESS_e6bd34f2-af0e-48a6-9872-ec017a776e77_TOSC_1c59283c-95f4-431e-8b66-62a243009081_SNAPS_','2022-01-24 17:22:53','2022-01-24 15:30:59','8_w1_o1_maxillaire_snapshot_0.png','2022-01-24 18:22:53','SYNCED','abe9bf28-5109-4b6b-96f0-9db3d075c9ff',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.8.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'ac0f8bbb-d9a6-428c-a397-1febe6de5982','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_e6c95ef7-636d-4c88-8d02-e2d9840573db/13_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_e6c95ef7-636d-4c88-8d02-e2d9840573db_SNAPS_','2022-01-27 16:36:58','2022-01-27 17:36:33','13_w1_o1_mandibule_snapshot_0.png','2022-01-27 17:36:58','SYNCED','ac0f8bbb-d9a6-428c-a397-1febe6de5982',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'ac34dc6a-7c17-41be-8a8f-f01a61c13e0d','','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_BOSC_07148fa2-1d5b-4343-81f9-ef44df15e4c7_SNAPS_','2022-02-19 17:53:24','2022-02-14 19:30:10','','2022-02-19 18:53:24','SYNCED','a25ff0a9-2187-4450-a8c0-3e7dd53302af',1,'2022-02-19 18:53:24','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.4.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'ac8b0ff0-1835-4c06-b555-8cd869ed8dcf','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/69640c87-271c-4a44-a6fa-67b01654cc27/session_5f9199b0-eb37-4ed3-8d1a-6c38505d4913/occlusion_991beec3-fe9e-4c98-a3d4-c98e4a4c2471/computedocclusion_c7bccd1e-370e-4347-8296-1bcd4c30b631/39_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_OCC_c7bccd1e-370e-4347-8296-1bcd4c30b631_SNAPO__SNAPS_','2022-09-10 09:46:18','2022-09-10 11:45:43','39_w1_o1_snapshot_occ_file_0.png','2022-09-10 11:46:18','SYNCED','ac8b0ff0-1835-4c06-b555-8cd869ed8dcf',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'ace017e9-ff30-403f-aee6-3daa66025d8d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_16f04a07-72e8-4a39-9b55-3ae7405733af/24_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_TOSC_16f04a07-72e8-4a39-9b55-3ae7405733af_SNAPS_','2022-06-13 14:42:32','2022-06-13 16:33:03','24_w1_o1_maxillaire_snapshot_0.png','2022-06-13 16:42:32','SYNCED','ace017e9-ff30-403f-aee6-3daa66025d8d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.4\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'ad385cc8-79ad-4c40-91ea-1275223f15d9','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/computedocclusion_864c98a3-fcf7-466a-b999-13bd4dfb8c65/23_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_864c98a3-fcf7-466a-b999-13bd4dfb8c65_BOPLY__ZIP_','2022-05-13 11:30:53','2022-05-13 13:30:43','23_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-05-13 13:30:53','SYNCED','ad385cc8-79ad-4c40-91ea-1275223f15d9',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.23.1.1.1 Occlusion 3\",\"modelMatrix\":\"0.99884,-0.00870968,0.0473501,0,0.0481445,0.180697,-0.98236,0,-1.26898e-10,0.9835,0.180907,0,0.872294,-19.7028,-3.24839,1\",\"referenceScanID\":\"1.23.1.1.1\",\"title\":\"Mandibule 1.23.1.1.1 Occlusion 3\"}'),(1001,'ad3ef871-3da5-4513-a26a-7990242d318d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_be8c90b6-055f-49b1-a5b6-cb782162d6cd/12_w1_o1_mandibule_scan_file_2.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_be8c90b6-055f-49b1-a5b6-cb782162d6cd_ZIP_','2022-02-04 12:39:32','2022-02-04 13:39:20','12_w1_o1_mandibule_scan_file_2.zip','2022-02-04 13:39:32','SYNCED','db484565-ee6f-4ebd-803a-ec8279d42cae',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.6\",\"modelMatrix\":\"0.955358,0.0799776,0.284419,0,0.29545,-0.258613,-0.919689,0,2.43157e-9,0.962664,-0.270698,0,-10.6442,-5.98327,-7.98243,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'adc3b531-b8c6-4f79-a5cf-5afae533973d','','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_OCC_d8bec5dc-8405-473d-9ba5-ae6e461ed6fd_BOPLY__ZIP_','2022-02-07 11:15:31','2022-02-04 19:13:44','','2022-02-07 12:15:31','SYNCED','adc3b531-b8c6-4f79-a5cf-5afae533973d',0,'2022-02-07 12:15:31','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.5 Occlusion 1\",\"modelMatrix\":\"-0.996857,-0.0768567,0.0192233,0,0.0792243,-0.967066,0.241882,0,1.71456e-9,0.242644,0.970115,0,23.7843,9.22152,-23.0024,1\",\"referenceScanID\":\"1.13.1.1.5\",\"title\":\"Mandibule 1.13.1.1.5 Occlusion 1\"}'),(1001,'adcfc3f6-2557-4375-a3b5-51d331cc65fb','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/computedocclusion_77753fb3-75a1-45c2-9191-7a5d98206df2/24_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_77753fb3-75a1-45c2-9191-7a5d98206df2_TOMA__MATRX_','2022-06-14 12:07:17','2022-06-14 14:06:33','24_w1_o1_maxillaire_matrix_occ_file_0.m','2022-06-14 14:07:17','SYNCED','adcfc3f6-2557-4375-a3b5-51d331cc65fb',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.24.1.1.4 Occlusion 5\",\"referenceScanID\":\"1.24.1.1.4\",\"title\":\"Matrice Transfo. Maxillaire 1.24.1.1.4 Occlusion 5\"}'),(1001,'ae18282f-9453-4966-8fff-7648d7fefeeb','','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_e2722784-a66c-4ece-91c0-2add756415ea_SNAPO__SNAPS_','2022-05-13 16:32:19','2022-05-13 18:31:42','','2022-05-13 18:32:19','SYNCED','ae18282f-9453-4966-8fff-7648d7fefeeb',0,'2022-05-13 18:32:19','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'ae581db1-9e8e-4239-b0e7-e1568d8e0752','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/occlusion_e08bbeeb-a30b-428c-bd4a-40198f792219/scan_6aeb3c55-f3f0-4e74-9793-ec74659a28ad/25_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_SESS_e08bbeeb-a30b-428c-bd4a-40198f792219_BOSC_6aeb3c55-f3f0-4e74-9793-ec74659a28ad_SNAPS_','2022-05-17 16:28:18','2022-05-17 18:28:16','25_w1_o1_maxillaire_snapshot_0.png','2022-05-17 18:28:18','SYNCED','ae581db1-9e8e-4239-b0e7-e1568d8e0752',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.25.1.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'ae626f34-952a-4c2f-ac1a-1aad95d218b5','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/scan_c1f909ab-5469-4839-84f1-d04759dd1237/1_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_BOSC_c1f909ab-5469-4839-84f1-d04759dd1237_SNAPS_','2022-01-19 12:59:18','2022-01-19 11:51:29','1_w1_o1_mandibule_snapshot_0.png','2022-01-19 13:59:18','SYNCED','ae626f34-952a-4c2f-ac1a-1aad95d218b5',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule SNAPSHOT\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'ae8bfa69-d95e-46a3-bb3e-cc68442120e2','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/593972a6-d7d6-4802-b87d-38aab371f71e/session_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480/occlusion_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3/computedocclusion_e23c031c-2c78-414b-840d-85b58e959fbe/3_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_593972a6-d7d6-4802-b87d-38aab371f71e_ACT_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480_SESS_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3_OCC_e23c031c-2c78-414b-840d-85b58e959fbe_TOPLY__ZIP_','2022-01-19 15:28:10','2022-01-19 16:26:52','3_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-01-19 16:28:10','SYNCED','ae8bfa69-d95e-46a3-bb3e-cc68442120e2',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.3.1.1.1 Occlusion 4\",\"modelMatrix\":\"-0.8207,0.559215,-0.117173,0,-0.571359,-0.803257,0.168307,0,5.51916e-9,0.205077,0.978746,0,22.3383,-22.9288,-32.0145,1\",\"referenceScanID\":\"1.3.1.1.1\",\"title\":\"Maxillaire 1.3.1.1.1 Occlusion 4\"}'),(1001,'aff7447b-86b3-422c-9e1f-a47c18457200','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/986374de-c4d7-4d6f-bf0c-2dc7e3b859a9/session_c81670ed-4144-4347-b19e-8057d11b5f7c/occlusion_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be/scan_f6f4f4dc-826e-4efc-957c-61074915b6b6/28_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_986374de-c4d7-4d6f-bf0c-2dc7e3b859a9_ACT_c81670ed-4144-4347-b19e-8057d11b5f7c_SESS_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be_RISC_f6f4f4dc-826e-4efc-957c-61074915b6b6_SNAPS_','2022-05-31 10:52:55','2022-05-31 12:52:42','28_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-05-31 12:52:55','SYNCED','aff7447b-86b3-422c-9e1f-a47c18457200',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.28.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'b015947f-1181-4536-b39a-ad5c494a9c91','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/452a5200-3e06-4b74-8949-6abc7f2dda8a/session_3e95d626-668f-45f7-98ad-be2cf9d7b90b/occlusion_bce8310f-eee9-4f0a-a6b7-d592dec66be5/computedocclusion_7a922eb8-5139-40fe-8402-fc7ff4204a1a/26_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_452a5200-3e06-4b74-8949-6abc7f2dda8a_ACT_3e95d626-668f-45f7-98ad-be2cf9d7b90b_SESS_bce8310f-eee9-4f0a-a6b7-d592dec66be5_OCC_7a922eb8-5139-40fe-8402-fc7ff4204a1a_SNAPO__SNAPS_','2022-05-24 09:42:30','2022-05-24 11:42:09','26_w1_o1_snapshot_occ_file_0.png','2022-05-24 11:42:30','SYNCED','b015947f-1181-4536-b39a-ad5c494a9c91',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'b07a13e9-d146-40aa-9c8c-d08b70786222','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/computedocclusion_d5bff097-1085-4c55-afe3-1ce57126d88f/19_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_OCC_d5bff097-1085-4c55-afe3-1ce57126d88f_BOMA__MATRX_','2022-03-08 11:16:25','2022-03-08 12:15:58','19_w1_o1_mandibule_matrix_occ_file_0.m','2022-03-08 12:16:25','SYNCED','b07a13e9-d146-40aa-9c8c-d08b70786222',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.19.1.1.4 Occlusion 2\",\"referenceScanID\":\"1.19.1.1.4\",\"title\":\"Matrice Transfo. Mandibule 1.19.1.1.4 Occlusion 2\"}'),(1001,'b0a26d3e-e20e-4fb7-bfea-a91cdaa7612c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/45ff7437-0691-4427-a7da-8250862e4b96/session_4ff9c682-c09d-42ff-8c29-aeb13e066ed2/occlusion_934673c1-a4b9-4508-ac1b-a03092a0693e/scan_da7dbb1d-043a-4c99-abde-d5ee77a3f819/9_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_45ff7437-0691-4427-a7da-8250862e4b96_ACT_4ff9c682-c09d-42ff-8c29-aeb13e066ed2_SESS_934673c1-a4b9-4508-ac1b-a03092a0693e_BOSC_da7dbb1d-043a-4c99-abde-d5ee77a3f819_SNAPS_','2022-01-24 17:45:23','2022-01-24 18:38:33','9_w1_o1_mandibule_snapshot_0.png','2022-01-24 18:45:23','SYNCED','b0a26d3e-e20e-4fb7-bfea-a91cdaa7612c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.9.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'b1612f1f-e70c-4dd6-bc02-855001953261','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/8fc74d9e-a5a0-46bf-be3f-500548a130ad/session_5368829e-7dec-4775-a487-a1019f9604f4/occlusion_bb63a653-1b34-4d80-a4bf-7fda5c9b0360/scan_812e813b-02e0-44c6-bb91-8e662cd9a614/14_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_8fc74d9e-a5a0-46bf-be3f-500548a130ad_ACT_5368829e-7dec-4775-a487-a1019f9604f4_SESS_bb63a653-1b34-4d80-a4bf-7fda5c9b0360_LESC_812e813b-02e0-44c6-bb91-8e662cd9a614_ZIP_','2022-02-01 10:51:03','2022-02-01 11:50:55','14_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-02-01 11:51:03','SYNCED','b1612f1f-e70c-4dd6-bc02-855001953261',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.14.1.1.2\",\"modelMatrix\":\"-0.957323,-0.238085,0.152849,0,0.225415,-0.962796,-0.158324,0,0.18139,-0.128793,0.975546,0,8.77435,4.5508,-19.3933,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'b1664c01-41f8-480b-af72-ad73284a731d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/occlusion_e08bbeeb-a30b-428c-bd4a-40198f792219/scan_ef1d20c7-5f61-4c35-8f0f-d85507cab786/25_w1_o1_mandibule_scan_file_3.zip','ZIP','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_SESS_e08bbeeb-a30b-428c-bd4a-40198f792219_BOSC_ef1d20c7-5f61-4c35-8f0f-d85507cab786_ZIP_','2022-05-17 16:18:50','2022-05-17 18:18:41','25_w1_o1_mandibule_scan_file_3.zip','2022-05-17 18:18:50','SYNCED','69ad61a1-bbd5-4415-a55b-c7c378bdf30e',3,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.25.1.1.1\",\"modelMatrix\":\"0.997472,-0.0698388,0.0130886,0,0.0710547,0.980404,-0.183739,0,8.96814e-10,0.184205,0.982888,0,-0.267312,-6.63349,-20.8465,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'b1b20d81-2ce7-4745-8d89-ddf4a21226dd','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a0c21836-ba79-4f15-9e35-02ef8211a9e5/session_0aac522d-3c38-465a-a1e0-014166c140ac/occlusion_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042/scan_8e186cfd-8ea5-4242-96cb-5a138aa44971/7_w1_o1_mordu_anterieur_scan_file_0.zip','ZIP','PATIENT_a0c21836-ba79-4f15-9e35-02ef8211a9e5_ACT_0aac522d-3c38-465a-a1e0-014166c140ac_SESS_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042_FRSC_8e186cfd-8ea5-4242-96cb-5a138aa44971_ZIP_','2022-01-21 12:04:41','2022-01-21 13:03:11','7_w1_o1_mordu_anterieur_scan_file_0.zip','2022-01-21 13:04:41','SYNCED','b1b20d81-2ce7-4745-8d89-ddf4a21226dd',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.7.1.1.1\",\"modelMatrix\":\"0.98688,-0.164233,0.0363058,0,0.15534,0.985548,0.047494,0,-0.0446001,-0.0421189,0.998213,0,7.95826,-0.82504,-21.4697,1\",\"title\":\"Mordu anterieur ZIP\"}'),(1001,'b1c51b5d-3ce0-4f2b-bf4c-ff8dc11c8e7d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5/occlusion_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa/scan_6148a482-5ea5-4353-ace5-f0d520a32e6e/24_w2_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5_SESS_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa_TOSC_6148a482-5ea5-4353-ace5-f0d520a32e6e_SNAPS_','2022-10-06 14:27:21','2022-10-06 16:27:07','24_w2_o1_maxillaire_snapshot_0.png','2022-10-06 16:27:21','SYNCED','b1c51b5d-3ce0-4f2b-bf4c-ff8dc11c8e7d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.2.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'b289e4d6-3c9a-4c99-9b03-22a1c45f557a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/computedocclusion_864c98a3-fcf7-466a-b999-13bd4dfb8c65/23_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_864c98a3-fcf7-466a-b999-13bd4dfb8c65_TOPLY__ZIP_','2022-05-13 11:31:01','2022-05-13 13:30:43','23_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-05-13 13:31:01','SYNCED','b289e4d6-3c9a-4c99-9b03-22a1c45f557a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.23.1.1.1 Occlusion 3\",\"modelMatrix\":\"-0.996412,0.0371381,-0.0760535,0,-0.0846367,-0.43722,0.895363,0,9.59179e-10,0.898588,0.438794,0,-5.67604,-22.9357,-12.9416,1\",\"referenceScanID\":\"1.23.1.1.1\",\"title\":\"Maxillaire 1.23.1.1.1 Occlusion 3\"}'),(1001,'b2acc793-4bfb-4782-8e11-283897626385','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7f47fd88-9ea0-4c08-9193-a54d4f158c7c/session_7873a396-419c-4215-83c7-fec9f2742ccf/occlusion_2e287bb0-e19a-414a-9177-23b335d286d9/scan_05d5d943-3268-4239-ac7d-5efbc2d2ab9b/16_w1_o2_maxillaire_snapshot_1.png','SNAPS','PATIENT_7f47fd88-9ea0-4c08-9193-a54d4f158c7c_ACT_7873a396-419c-4215-83c7-fec9f2742ccf_SESS_2e287bb0-e19a-414a-9177-23b335d286d9_TOSC_05d5d943-3268-4239-ac7d-5efbc2d2ab9b_SNAPS_','2022-06-03 08:58:59','2022-06-03 10:52:04','16_w1_o2_maxillaire_snapshot_1.png','2022-06-03 10:58:59','SYNCED','4c85fe3b-92ce-4c9f-bba8-70bca998d5fc',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.16.1.2.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'b2edc514-dfe1-4669-9903-5360d4916e4f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/e922efb9-8c03-445b-8a0f-449e3c43bdca/session_a2369349-1629-40ad-8784-d271bc3fbade/occlusion_292cc1aa-8b12-463b-87a1-7d9731cf886b/scan_877e5641-7010-4a8d-99a9-8005d48d7ec6/21_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_e922efb9-8c03-445b-8a0f-449e3c43bdca_ACT_a2369349-1629-40ad-8784-d271bc3fbade_SESS_292cc1aa-8b12-463b-87a1-7d9731cf886b_LESC_877e5641-7010-4a8d-99a9-8005d48d7ec6_ZIP_','2022-04-21 08:47:27','2022-04-21 10:47:20','21_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-04-21 10:47:27','SYNCED','b2edc514-dfe1-4669-9903-5360d4916e4f',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.21.1.1.1\",\"modelMatrix\":\"-0.948339,0.00379469,0.317975,0,-0.0111445,-0.999965,-0.00926301,0,0.317098,-0.00901499,0.948056,0,-5.63961,2.22475,-16.982,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'b371f5a8-1821-4778-bc62-c98e0ef00388','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/scan_725ef2a4-4b53-4ec9-a807-17759213c882/22_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_BOSC_725ef2a4-4b53-4ec9-a807-17759213c882_SNAPS_','2022-04-21 11:05:32','2022-04-21 13:05:23','22_w1_o1_mandibule_snapshot_0.png','2022-04-21 13:05:32','SYNCED','b371f5a8-1821-4778-bc62-c98e0ef00388',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.22.1.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'b3b10ee1-2648-4394-a6e4-81a5e5e3e4df','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/8fc74d9e-a5a0-46bf-be3f-500548a130ad/session_5368829e-7dec-4775-a487-a1019f9604f4/occlusion_bb63a653-1b34-4d80-a4bf-7fda5c9b0360/scan_3e9aff47-e0ac-4b19-973d-d25c0bab00c9/14_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_8fc74d9e-a5a0-46bf-be3f-500548a130ad_ACT_5368829e-7dec-4775-a487-a1019f9604f4_SESS_bb63a653-1b34-4d80-a4bf-7fda5c9b0360_LESC_3e9aff47-e0ac-4b19-973d-d25c0bab00c9_ZIP_','2022-02-01 10:49:08','2022-02-01 11:48:59','14_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-02-01 11:49:08','SYNCED','b3b10ee1-2648-4394-a6e4-81a5e5e3e4df',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.14.1.1.1\",\"modelMatrix\":\"-0.98904,-0.0675101,0.130562,0,0.0772743,-0.993194,0.094479,0,0.12585,0.0953193,0.986968,0,12.8128,-2.54273,-17.2464,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'b3c1c9e6-2468-4942-a4b5-2c0391c8432d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/occlusion_a2220645-c79d-4dda-b6cc-772384a4106b/scan_38a668ff-3bd3-4238-90d7-65cc6f5a9ca7/38_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_BOSC_38a668ff-3bd3-4238-90d7-65cc6f5a9ca7_ZIP_','2022-07-12 10:53:47','2022-07-12 12:53:38','38_w1_o1_mandibule_scan_file_0.zip','2022-07-12 12:53:47','SYNCED','b3c1c9e6-2468-4942-a4b5-2c0391c8432d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.38.1.1.1\",\"modelMatrix\":\"-0.751938,0.649871,-0.110711,0,-0.659234,-0.741259,0.12628,0,-8.33225e-09,0.167939,0.985797,0,9.41783,-30.192,-17.274,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'b491ccb9-a206-434b-99cb-610beb966dfa','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/occlusion_a2220645-c79d-4dda-b6cc-772384a4106b/computedocclusion_8b14563e-0862-4cac-8045-e8aed2be886d/38_w1_o1_ml_occ_file_to1000.xyz','LIFI','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_OCC_8b14563e-0862-4cac-8045-e8aed2be886d_LIFIO_LIFI_','2022-07-19 12:28:52','2022-07-19 14:28:51','38_w1_o1_ml_occ_file_to1000.xyz','2022-07-19 14:28:52','SYNCED','b491ccb9-a206-434b-99cb-610beb966dfa',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.38.1.1.1 Occlusion 1 Ligne de finition 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"Maxillaire\",\"name\":\"Ligne de finition 0\",\"title\":\"Ligne finition\",\"toothNumber\":1000}'),(1001,'b4cc54aa-aa6f-4638-ab86-cb7cd20e7285','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5/occlusion_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa/scan_569997ca-080a-44fb-9a38-e48cedabde17/24_w2_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5_SESS_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa_RISC_569997ca-080a-44fb-9a38-e48cedabde17_SNAPS_','2022-10-06 14:32:32','2022-10-06 16:32:23','24_w2_o1_mordu_posterieur_droit_snapshot_0.png','2022-10-06 16:32:32','SYNCED','b4cc54aa-aa6f-4638-ab86-cb7cd20e7285',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.24.2.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'b4e5f5b8-812b-4550-93b3-a8808b89d8cd','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/computedocclusion_704a0750-2a24-448f-8f30-928139977895/4_w1_o2_snapshot_occ_file_0.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_OCC_704a0750-2a24-448f-8f30-928139977895_SNAPO__SNAPS_','2022-03-08 11:49:51','2022-03-08 12:49:34','4_w1_o2_snapshot_occ_file_0.png','2022-03-08 12:49:51','SYNCED','b4e5f5b8-812b-4550-93b3-a8808b89d8cd',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'b51aa40c-9bbb-44c4-a878-efb405af40a5','','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_ea89007b-3846-43ef-92f9-d5c7aa1a7dfa_BOPLY__ZIP_','2022-05-25 08:56:32','2022-05-13 18:35:18','','2022-05-25 10:56:32','SYNCED','b51aa40c-9bbb-44c4-a878-efb405af40a5',0,'2022-05-25 10:56:32','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.24.1.1.1 Occlusion 5\",\"modelMatrix\":\"0.852703,-0.521011,0.0380208,0,0.522396,0.850441,-0.062061,0,3.49638e-10,0.0727815,0.997348,0,-11.3911,-12.8136,-21.1334,1\",\"referenceScanID\":\"1.24.1.1.1\",\"title\":\"Mandibule 1.24.1.1.1 Occlusion 5\"}'),(1001,'b5b15730-75d0-4419-8b97-a0362238661d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/57c4096f-98dd-49c8-bea5-a5b109ad3fd0/session_4f62e395-5623-4d5b-869c-1b2fc4d22b00/occlusion_1ac20dc7-b36b-4786-a05f-37091554dc5c/computedocclusion_70f4220e-2a6b-4575-bd0e-09c14a13d758/31_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_57c4096f-98dd-49c8-bea5-a5b109ad3fd0_ACT_4f62e395-5623-4d5b-869c-1b2fc4d22b00_SESS_1ac20dc7-b36b-4786-a05f-37091554dc5c_OCC_70f4220e-2a6b-4575-bd0e-09c14a13d758_BOPLY__ZIP_','2022-06-16 11:04:03','2022-06-16 13:03:55','31_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-06-16 13:04:03','SYNCED','b5b15730-75d0-4419-8b97-a0362238661d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.31.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.252718,0.957401,-0.139701,0,-0.96754,0.25007,-0.0364895,0,-5.51629e-10,0.144388,0.989521,0,-10.0594,-15.8463,-16.5488,1\",\"referenceScanID\":\"1.31.1.1.1\",\"title\":\"Mandibule 1.31.1.1.1 Occlusion 1\"}'),(1001,'b5f2d1e9-c850-486b-9609-5e65632eea3c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/d100e894-0be9-4495-94e2-e469232f7817/session_2c8b85b5-c805-4b08-85e7-3d02dab72e99/occlusion_8a278cc5-a1c1-4dfb-9ee2-c971a6309afa/scan_b1a27ca1-b17d-4071-99c1-940f9efedb70/15_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_d100e894-0be9-4495-94e2-e469232f7817_ACT_2c8b85b5-c805-4b08-85e7-3d02dab72e99_SESS_8a278cc5-a1c1-4dfb-9ee2-c971a6309afa_RISC_b1a27ca1-b17d-4071-99c1-940f9efedb70_ZIP_','2022-02-01 15:11:23','2022-02-01 16:11:12','15_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-02-01 16:11:23','SYNCED','b5f2d1e9-c850-486b-9609-5e65632eea3c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.15.1.1.1\",\"modelMatrix\":\"0.985583,-0.0324105,0.163583,0,0.0137503,0.991881,0.127662,0,-0.168661,-0.122999,0.978237,0,-7.43884,5.93846,-19.4808,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'b60666c5-07cb-4f6c-ba71-538dcfe3d89d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/45ff7437-0691-4427-a7da-8250862e4b96/session_4ff9c682-c09d-42ff-8c29-aeb13e066ed2/occlusion_934673c1-a4b9-4508-ac1b-a03092a0693e/computedocclusion_161f60a4-d4f2-41f1-98ad-a8ccad84216c/9_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_45ff7437-0691-4427-a7da-8250862e4b96_ACT_4ff9c682-c09d-42ff-8c29-aeb13e066ed2_SESS_934673c1-a4b9-4508-ac1b-a03092a0693e_OCC_161f60a4-d4f2-41f1-98ad-a8ccad84216c_TOPLY__ZIP_','2022-01-24 19:55:57','2022-01-24 18:46:00','9_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-01-24 20:55:57','SYNCED','b60666c5-07cb-4f6c-ba71-538dcfe3d89d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.9.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.9.1.1.1\",\"title\":\"Maxillaire 1.9.1.1.1 Occlusion 1\"}'),(1001,'b60d5f74-99b5-43dd-8f13-25a0c83717d3','','ZIP','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_LESC_273e24bd-58e9-4983-8fdc-d9f60e8e0de7_ZIP_','2022-09-09 16:40:52','2022-09-09 18:33:57','','2022-09-09 18:40:52','SYNCED','b60d5f74-99b5-43dd-8f13-25a0c83717d3',0,'2022-09-09 18:40:52','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.39.1.1.6\",\"modelMatrix\":\"-0.988587,0.144207,0.0409559,0,-0.137967,-0.977474,0.158097,0,0.0605711,0.154154,0.986583,0,-2.607,0.716326,-19.8323,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'b6303ea4-a27b-45d8-8859-2f8f8edda5cb','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/scan_2d226451-8adb-4007-be22-99a9b3af61d6/23_w1_o1_maxillaire_mlmeta_1_0.bin','LIFIM','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_TOSC_2d226451-8adb-4007-be22-99a9b3af61d6_LIFIM_','2022-05-25 10:45:09','2022-05-25 12:45:09','23_w1_o1_maxillaire_mlmeta_1_0.bin','2022-05-25 12:45:09','SYNCED','b6303ea4-a27b-45d8-8859-2f8f8edda5cb',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.23.1.1.1 Ligne de finition 1\",\"name\":\"Ligne de finition 1\",\"title\":\"Maxillaire LIFI_META\",\"toothNumber\":1,\"versionMarginLine\":1}'),(1001,'b685e310-d84a-4a81-a008-eee4725a0bd6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/32939ecf-ba11-4fff-a074-5e86a9f7f313/session_4075a8d6-094f-4202-abe0-4c02b7a5a8e6/occlusion_51192c80-5065-420e-ae8f-bac335ac1de1/scan_2ca8702c-bb71-418c-b881-0d3d2af204d1/6_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_32939ecf-ba11-4fff-a074-5e86a9f7f313_ACT_4075a8d6-094f-4202-abe0-4c02b7a5a8e6_SESS_51192c80-5065-420e-ae8f-bac335ac1de1_TOSC_2ca8702c-bb71-418c-b881-0d3d2af204d1_SNAPS_','2022-01-20 10:13:02','2022-01-20 11:12:37','6_w1_o1_maxillaire_snapshot_0.png','2022-01-20 11:13:02','SYNCED','b685e310-d84a-4a81-a008-eee4725a0bd6',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.6.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'b6d0c906-79cf-49c8-a1fa-4ed6e5c7355c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/452a5200-3e06-4b74-8949-6abc7f2dda8a/session_3e95d626-668f-45f7-98ad-be2cf9d7b90b/occlusion_bce8310f-eee9-4f0a-a6b7-d592dec66be5/scan_315ac573-ca2e-4c47-8969-e667ad225aa2/26_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_452a5200-3e06-4b74-8949-6abc7f2dda8a_ACT_3e95d626-668f-45f7-98ad-be2cf9d7b90b_SESS_bce8310f-eee9-4f0a-a6b7-d592dec66be5_LESC_315ac573-ca2e-4c47-8969-e667ad225aa2_SNAPS_','2022-05-24 09:41:39','2022-05-24 11:41:30','26_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-05-24 11:41:39','SYNCED','b6d0c906-79cf-49c8-a1fa-4ed6e5c7355c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.26.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'b6f46e96-4d05-4b63-8956-16b3af586d47','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/458c92d8-9da1-4df9-967f-d14fc7e6303d/session_55831d43-1906-4a22-9b7a-ed4b2820c8b2/occlusion_4f582d4c-81d0-4e01-8be3-9ff53b12c7f4/scan_19e6ea5c-af28-439b-bc57-b561cd42e12b/10_w2_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_55831d43-1906-4a22-9b7a-ed4b2820c8b2_SESS_4f582d4c-81d0-4e01-8be3-9ff53b12c7f4_TOSC_19e6ea5c-af28-439b-bc57-b561cd42e12b_SNAPS_','2022-06-16 13:17:46','2022-06-16 15:17:36','10_w2_o1_maxillaire_snapshot_0.png','2022-06-16 15:17:46','SYNCED','b6f46e96-4d05-4b63-8956-16b3af586d47',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.10.2.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'b79c08d2-6a61-4a8a-a196-1be264af0e42','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/scan_03839278-13f8-46e6-9581-ba11bc8bcb81/1_w1_o1_maxillaire_scan_file_2.zip','ZIP','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_TOSC_03839278-13f8-46e6-9581-ba11bc8bcb81_ZIP_','2022-01-19 13:01:35','2022-01-19 11:09:50','1_w1_o1_maxillaire_scan_file_2.zip','2022-01-19 14:01:35','SYNCED','96dd75bb-5035-460a-8afc-04f3755604b1',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.1.1.1.1\",\"modelMatrix\":\"-0.183277,0.932835,-0.310209,0,-0.983061,-0.173913,0.0578337,0,-6.22287e-9,0.315554,0.948908,0,-14.0294,-37.4355,-13.2447,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'b7bee708-79bb-43ec-832d-02b35be06369','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/32710234-804f-46f5-899d-eed636f8a906/session_64c1427a-b91d-4675-94df-f36bd40e9b0f/order_52f078fa-727c-4bbd-a020-8c414d4fe6a5/33_w2_inlay_onlay_prost_file_b7bee708-79bb-43ec-832d-02b35be06369_0.pdf','PDF','PATIENT_32710234-804f-46f5-899d-eed636f8a906_ACT_64c1427a-b91d-4675-94df-f36bd40e9b0f_PROST_52f078fa-727c-4bbd-a020-8c414d4fe6a5_PDF_','2022-06-28 17:34:51','2022-06-28 19:34:49','33_w2_inlay_onlay_prost_file_b7bee708-79bb-43ec-832d-02b35be06369_0.pdf','2022-06-28 19:34:51','SYNCED','b7bee708-79bb-43ec-832d-02b35be06369',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.33.2.1 INLAY ONLAY 14 Claire\",\"title\":\"Inlay/Onlay PDF\"}'),(1001,'b7cf2866-aec2-4f49-8f97-82fca065a1f3','','SNAPS','PATIENT_de078619-3946-4adb-a799-1c260e16face_ACT_24d0aeb5-3058-4070-aeea-97c289e41e3c_SESS_ea6da896-1504-41fc-890c-7c48575e9e40_BOSC_00feff25-f8bf-405a-9778-d3fd08af5e37_SNAPS_','2022-01-19 17:01:43','2022-01-19 15:19:15','','2022-01-19 18:01:43','SYNCED','b7cf2866-aec2-4f49-8f97-82fca065a1f3',0,'2022-01-19 18:01:43','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.2.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'b812ac8b-f89d-4997-a934-b84fc86cdf84','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a4b302c-278d-4e12-ace5-f095ba0bf856/session_6206892a-2e7e-4765-ac90-b49bfb465997/occlusion_3c30231c-7cd7-4431-985b-2eaf7f6925ae/scan_f9a200bf-710b-4bad-a122-de56d5bc4da4/3_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_f9a200bf-710b-4bad-a122-de56d5bc4da4_ZIP_','2022-09-06 09:20:32','2022-08-30 10:36:06','3_w1_o1_maxillaire_scan_file_0.zip','2022-09-06 11:20:32','SYNCED','b812ac8b-f89d-4997-a934-b84fc86cdf84',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.3.1.1.1\",\"modelMatrix\":\"0.68153,0.72027,-0.129336,0,-0.73179,0.670801,-0.120453,0,1.08731e-08,0.176739,0.984258,0,-27.3042,-9.55749,-15.1525,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'b84f27be-e2df-4069-8159-d734bcbcec08','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_7f58ef07-2de6-4bb2-982d-86ac2b5ae742/17_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_RISC_7f58ef07-2de6-4bb2-982d-86ac2b5ae742_SNAPS_','2022-02-11 16:12:11','2022-02-11 17:12:03','17_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-02-11 17:12:11','SYNCED','b84f27be-e2df-4069-8159-d734bcbcec08',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.17.1.1.2\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'b85116ff-ba7b-4dc5-a868-287b0ab403b1','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_2a7068fc-0efa-496f-ade9-aba5b0650655/12_w1_o1_mandibule_scan_file_6.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_2a7068fc-0efa-496f-ade9-aba5b0650655_ZIP_','2022-02-04 12:06:15','2022-02-04 13:05:53','12_w1_o1_mandibule_scan_file_6.zip','2022-02-04 13:06:15','SYNCED','44ebcd6f-57c2-4cce-96f5-f9faa1c6b373',6,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.5\",\"modelMatrix\":\"0.712702,-0.661388,0.233712,0,0.701467,0.671982,-0.237455,0,2.34471e-9,0.333176,0.942865,0,3.59767,30.1121,-30.1698,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'b85be850-5590-4c9b-b13b-3d6d94c2e3ab','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/computedocclusion_42098ceb-3335-4f13-8aed-b29c37a5f57f/22_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_OCC_42098ceb-3335-4f13-8aed-b29c37a5f57f_BOMA__MATRX_','2022-04-21 11:29:05','2022-04-21 13:28:43','22_w1_o1_mandibule_matrix_occ_file_0.m','2022-04-21 13:29:05','SYNCED','b85be850-5590-4c9b-b13b-3d6d94c2e3ab',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.22.1.1.2 Occlusion 6\",\"referenceScanID\":\"1.22.1.1.2\",\"title\":\"Matrice Transfo. Mandibule 1.22.1.1.2 Occlusion 6\"}'),(1001,'b8629303-55d9-4e62-9233-49367e1d7bb6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/986374de-c4d7-4d6f-bf0c-2dc7e3b859a9/session_c81670ed-4144-4347-b19e-8057d11b5f7c/order_8125a57d-e19e-4264-ba12-984e020c452e/28_w1_inlay_onlay_prost_file_b8629303-55d9-4e62-9233-49367e1d7bb6_0.pdf','PDF','PATIENT_986374de-c4d7-4d6f-bf0c-2dc7e3b859a9_ACT_c81670ed-4144-4347-b19e-8057d11b5f7c_PROST_8125a57d-e19e-4264-ba12-984e020c452e_PDF_','2022-06-07 11:41:29','2022-06-07 13:41:28','28_w1_inlay_onlay_prost_file_b8629303-55d9-4e62-9233-49367e1d7bb6_0.pdf','2022-06-07 13:41:29','SYNCED','b8629303-55d9-4e62-9233-49367e1d7bb6',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.28.1.1 INLAY ONLAY\",\"title\":\"Inlay/Onlay PDF\"}'),(1001,'b874f86b-93dd-4bf0-963c-c9cf446e4836','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_b1201d2a-0fbf-48bc-a1c2-f3649c1ca576/18_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_BOSC_b1201d2a-0fbf-48bc-a1c2-f3649c1ca576_SNAPS_','2022-05-10 14:00:12','2022-05-10 16:00:00','18_w1_o1_mandibule_snapshot_0.png','2022-05-10 16:00:12','SYNCED','b874f86b-93dd-4bf0-963c-c9cf446e4836',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.18.1.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'b8b1811e-1d8b-4e17-8c28-b529cbc427b9','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/occlusion_a2220645-c79d-4dda-b6cc-772384a4106b/computedocclusion_8b14563e-0862-4cac-8045-e8aed2be886d/38_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_OCC_8b14563e-0862-4cac-8045-e8aed2be886d_TOMA__MATRX_','2022-07-12 10:57:43','2022-07-12 12:57:24','38_w1_o1_maxillaire_matrix_occ_file_0.m','2022-07-12 12:57:43','SYNCED','b8b1811e-1d8b-4e17-8c28-b529cbc427b9',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.38.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.38.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.38.1.1.1 Occlusion 1\"}'),(1001,'b8b7a966-6291-445c-85e0-39e995878daa','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_be8c90b6-055f-49b1-a5b6-cb782162d6cd/12_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_be8c90b6-055f-49b1-a5b6-cb782162d6cd_SNAPS_','2022-02-04 12:36:39','2022-02-04 13:36:24','12_w1_o1_mandibule_snapshot_1.png','2022-02-04 13:36:39','SYNCED','09a60bd0-5644-4c1f-85c2-b6dfce87f5a8',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.6\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'b92bcf1f-2d56-46b6-b871-378a0142816d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7f47fd88-9ea0-4c08-9193-a54d4f158c7c/session_7873a396-419c-4215-83c7-fec9f2742ccf/occlusion_2f21aacc-dc8f-459b-b89b-bd548ffc070d/scan_410077c0-79fe-4e07-b332-33923a495579/16_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_7f47fd88-9ea0-4c08-9193-a54d4f158c7c_ACT_7873a396-419c-4215-83c7-fec9f2742ccf_SESS_2f21aacc-dc8f-459b-b89b-bd548ffc070d_BOSC_410077c0-79fe-4e07-b332-33923a495579_SNAPS_','2022-02-03 10:10:12','2022-02-03 11:09:56','16_w1_o1_mandibule_snapshot_0.png','2022-02-03 11:10:12','SYNCED','b92bcf1f-2d56-46b6-b871-378a0142816d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.16.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'b96d1194-073e-457b-8576-4bc1f1670ab3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_1c86378e-7d31-4b12-82ff-af797020160f/4_w1_o2_mandibule_scan_file_2.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_BOSC_1c86378e-7d31-4b12-82ff-af797020160f_ZIP_','2022-03-08 11:40:04','2022-03-08 12:39:57','4_w1_o2_mandibule_scan_file_2.zip','2022-03-08 12:40:04','SYNCED','bb22e8ec-52ef-47ae-acce-e63ab615a505',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.2.3\",\"modelMatrix\":\"0.911616,-0.405119,0.069536,0,0.411044,0.898477,-0.154217,0,-1.58245e-09,0.169169,0.985587,0,-2.41197,4.44675,-21.7512,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'b973e12b-eb72-4f9d-acda-04165903bf1d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/452a5200-3e06-4b74-8949-6abc7f2dda8a/session_3e95d626-668f-45f7-98ad-be2cf9d7b90b/occlusion_bce8310f-eee9-4f0a-a6b7-d592dec66be5/scan_49ae59fe-0bc4-4d86-b65e-d8788e2d12fb/26_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_452a5200-3e06-4b74-8949-6abc7f2dda8a_ACT_3e95d626-668f-45f7-98ad-be2cf9d7b90b_SESS_bce8310f-eee9-4f0a-a6b7-d592dec66be5_TOSC_49ae59fe-0bc4-4d86-b65e-d8788e2d12fb_SNAPS_','2022-05-24 09:36:31','2022-05-24 11:36:18','26_w1_o1_maxillaire_snapshot_1.png','2022-05-24 11:36:31','SYNCED','cb795e35-e3c3-4871-a194-cf67dc3a59ab',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.26.1.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'b9fe2aeb-5be3-4c12-bb79-46f1198412a3','','ZIP','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_RISC_261fcec0-ce06-45e0-a8b7-6a5f785c988d_ZIP_','2022-04-21 17:37:36','2022-04-21 13:11:18','','2022-04-21 19:37:36','SYNCED','b9fe2aeb-5be3-4c12-bb79-46f1198412a3',0,'2022-04-21 19:37:36','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.22.1.1.2\",\"modelMatrix\":\"0.990398,-0.0591629,0.125496,0,0.0595402,0.997139,-0.0424849,0,-0.124893,0.0474083,0.99119,0,3.88654,-0.889286,-9.53459,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'ba4a6637-3a12-44b7-ba1f-a50120fc6f3e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/fa7fa96b-f393-4b9a-8198-144702462cfa/session_4bed076c-8541-4a2f-800a-5aeb4cb49de5/order_85b54577-74c9-4914-ab8b-326faaeee445/35_w1_autre_prost_file_ba4a6637-3a12-44b7-ba1f-a50120fc6f3e_0.pdf','PDF','PATIENT_fa7fa96b-f393-4b9a-8198-144702462cfa_ACT_4bed076c-8541-4a2f-800a-5aeb4cb49de5_PROST_85b54577-74c9-4914-ab8b-326faaeee445_PDF_','2022-06-28 17:25:45','2022-06-28 19:25:43','35_w1_autre_prost_file_ba4a6637-3a12-44b7-ba1f-a50120fc6f3e_0.pdf','2022-06-28 19:25:45','SYNCED','ba4a6637-3a12-44b7-ba1f-a50120fc6f3e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.35.1.1 AUTRE FICHE DE PROTHESE\",\"title\":\"Autre PDF\"}'),(1001,'bab4efeb-320f-419c-8066-203fc2212abd','','MATRX','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_26ae7fce-0ea3-479f-9989-7d0a3a19aaf7_TOMA__MATRX_','2022-02-08 08:49:00','2022-02-07 18:58:31','','2022-02-08 09:49:00','SYNCED','bab4efeb-320f-419c-8066-203fc2212abd',0,'2022-02-08 09:49:00','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.17.1.1.1 Occlusion 6\",\"referenceScanID\":\"1.17.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.17.1.1.1 Occlusion 6\"}'),(1001,'bb22e8ec-52ef-47ae-acce-e63ab615a505','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_1c86378e-7d31-4b12-82ff-af797020160f/4_w1_o2_mandibule_scan_file_0.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_BOSC_1c86378e-7d31-4b12-82ff-af797020160f_ZIP_','2022-03-08 11:34:08','2022-03-08 12:34:01','4_w1_o2_mandibule_scan_file_0.zip','2022-03-08 12:34:08','SYNCED','bb22e8ec-52ef-47ae-acce-e63ab615a505',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.2.3\",\"modelMatrix\":\"0.770557,-0.629916,0.097197,0,0.637371,0.761545,-0.117507,0,1.23863e-09,0.152497,0.988304,0,-0.31229,4.52166,-21.9424,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'bb28b621-dccb-4c99-8175-e391881f0c0e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/986374de-c4d7-4d6f-bf0c-2dc7e3b859a9/session_c81670ed-4144-4347-b19e-8057d11b5f7c/occlusion_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be/scan_67168b1b-2bef-47a9-8e7f-994731a82831/28_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_986374de-c4d7-4d6f-bf0c-2dc7e3b859a9_ACT_c81670ed-4144-4347-b19e-8057d11b5f7c_SESS_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be_BOSC_67168b1b-2bef-47a9-8e7f-994731a82831_SNAPS_','2022-05-31 10:45:14','2022-05-31 12:45:05','28_w1_o1_mandibule_snapshot_0.png','2022-05-31 12:45:14','SYNCED','bb28b621-dccb-4c99-8175-e391881f0c0e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.28.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'bb5d8a2c-ca49-4c79-82f5-e0afa03412b2','','ZIP','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_c9079d19-8ffb-46f7-a51e-3a7a90ccae59_SESS_8ba0f3b1-408f-4a02-92a0-63f09123b68e_BOSC_cf1df2e4-52f9-48a2-8e0b-54a1e4ed5741_ZIP_','2022-01-28 17:15:45','2022-01-26 15:48:06','','2022-01-28 18:15:45','SYNCED','7161a896-678c-49ce-a8db-989109953ffa',2,'2022-01-28 18:15:45','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.10.1.1.2\",\"modelMatrix\":\"0.516833,0.814252,-0.264344,0,-0.856086,0.491576,-0.159588,0,2.51174e-9,0.308782,0.951133,0,-33.079,-33.4874,-21.0835,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'bbbe68f7-b908-4db3-9434-4a1f290691ec','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/e922efb9-8c03-445b-8a0f-449e3c43bdca/session_a2369349-1629-40ad-8784-d271bc3fbade/occlusion_292cc1aa-8b12-463b-87a1-7d9731cf886b/scan_3d958f24-3e12-4683-9cee-1d6c2a7022c8/21_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_e922efb9-8c03-445b-8a0f-449e3c43bdca_ACT_a2369349-1629-40ad-8784-d271bc3fbade_SESS_292cc1aa-8b12-463b-87a1-7d9731cf886b_TOSC_3d958f24-3e12-4683-9cee-1d6c2a7022c8_SNAPS_','2022-04-21 08:36:29','2022-04-21 10:36:14','21_w1_o1_maxillaire_snapshot_0.png','2022-04-21 10:36:29','SYNCED','bbbe68f7-b908-4db3-9434-4a1f290691ec',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.21.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'bc3ef2fe-37e6-4917-bb61-0bdfc03e79ad','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/scan_f5ab063d-18f1-443e-b694-fd1ef20e9e78/4_w1_o4_mordu_posterieur_gauche_snapshot_1.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_LESC_f5ab063d-18f1-443e-b694-fd1ef20e9e78_SNAPS_','2022-05-31 12:11:51','2022-05-31 14:11:43','4_w1_o4_mordu_posterieur_gauche_snapshot_1.png','2022-05-31 14:11:51','SYNCED','95267990-f2d4-4cd6-b572-9f6c8fd29601',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.4.1.4.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'bc41e869-1823-4f51-9784-f364bea77540','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/1c189ddc-0ee7-45e7-9d80-585dac08374a/session_01bd0635-6ec6-42cb-8561-8638bded352c/occlusion_2aa712ca-8b46-4a50-a03e-1c6a6a0c40fc/scan_c38af399-ff7c-47c5-8f3f-7a96401d72b5/29_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_1c189ddc-0ee7-45e7-9d80-585dac08374a_ACT_01bd0635-6ec6-42cb-8561-8638bded352c_SESS_2aa712ca-8b46-4a50-a03e-1c6a6a0c40fc_LESC_c38af399-ff7c-47c5-8f3f-7a96401d72b5_SNAPS_','2022-06-03 14:04:22','2022-06-03 16:04:13','29_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-06-03 16:04:22','SYNCED','bc41e869-1823-4f51-9784-f364bea77540',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.29.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'bc633195-8681-4e1b-b717-dddd5f11bde7','','ZIP','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_c9079d19-8ffb-46f7-a51e-3a7a90ccae59_SESS_8ba0f3b1-408f-4a02-92a0-63f09123b68e_BOSC_30b22823-10be-472c-b053-59b470998f02_ZIP_','2022-01-28 17:15:46','2022-01-25 13:06:28','','2022-01-28 18:15:46','SYNCED','bc633195-8681-4e1b-b717-dddd5f11bde7',0,'2022-01-28 18:15:46','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.10.1.1.1\",\"modelMatrix\":\"-0.954688,-0.285844,0.0828552,0,0.29761,-0.916944,0.265787,0,8.3528e-9,0.278402,0.960465,0,13.1987,7.96464,-25.1028,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'bcba0d65-c508-4d4c-9e7f-b39de190c5ed','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/computedocclusion_00405f86-eefa-41f9-8d98-1fa9cbeef855/24_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_00405f86-eefa-41f9-8d98-1fa9cbeef855_SNAPO__SNAPS_','2022-05-25 09:03:41','2022-05-25 11:02:54','24_w1_o1_snapshot_occ_file_0.png','2022-05-25 11:03:41','SYNCED','bcba0d65-c508-4d4c-9e7f-b39de190c5ed',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'bcc40a26-24c9-4920-b007-02a587a94afd','','SNAPS','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_a16e268c-a9f5-4f0b-8346-6f1984df70bb_SNAPS_','2022-02-04 11:29:39','2022-02-02 11:14:58','','2022-02-04 12:29:39','SYNCED','bcc40a26-24c9-4920-b007-02a587a94afd',0,'2022-02-04 12:29:39','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'bcc5ce7c-04f8-4198-9751-bdfc90e79289','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a0c21836-ba79-4f15-9e35-02ef8211a9e5/session_0aac522d-3c38-465a-a1e0-014166c140ac/occlusion_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042/scan_b3e360d5-eb70-4046-910f-cbac3270fd6c/7_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_a0c21836-ba79-4f15-9e35-02ef8211a9e5_ACT_0aac522d-3c38-465a-a1e0-014166c140ac_SESS_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042_TOSC_b3e360d5-eb70-4046-910f-cbac3270fd6c_SNAPS_','2022-01-21 11:45:25','2022-01-21 12:44:52','7_w1_o1_maxillaire_snapshot_1.png','2022-01-21 12:45:25','SYNCED','c22cf400-8aa1-42db-9cdb-0b4c8cf80b52',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.7.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'bcc6d6b1-4cdb-40f6-9e05-410c5f790a07','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/scan_48982add-ff93-4e3a-a453-012a73678b39/19_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_TOSC_48982add-ff93-4e3a-a453-012a73678b39_SNAPS_','2022-03-08 11:09:54','2022-03-08 12:09:38','19_w1_o1_maxillaire_snapshot_1.png','2022-03-08 12:09:54','SYNCED','c4ff0a0b-2408-4188-9880-ebaa94ad910a',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.19.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'bcef8d3e-9632-4976-8cda-4c6f3ac50e99','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_e6c95ef7-636d-4c88-8d02-e2d9840573db/13_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_e6c95ef7-636d-4c88-8d02-e2d9840573db_ZIP_','2022-01-27 16:36:57','2022-01-27 17:36:35','13_w1_o1_mandibule_scan_file_0.zip','2022-01-27 17:36:57','SYNCED','bcef8d3e-9632-4976-8cda-4c6f3ac50e99',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.1\",\"modelMatrix\":\"-0.963479,0.243305,-0.111855,0,-0.267785,-0.8754,0.402451,0,1.23617e-9,0.417706,0.908582,0,32.4632,-3.53421,-16.2323,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'bd5e6662-24ee-41e1-984f-ae69a2181d96','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_4ed7adaa-3b77-4537-8479-4d0c4bd28c7b/12_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_TOSC_4ed7adaa-3b77-4537-8479-4d0c4bd28c7b_SNAPS_','2022-01-27 11:58:32','2022-01-27 12:58:04','12_w1_o1_maxillaire_snapshot_1.png','2022-01-27 12:58:32','SYNCED','8f3ff963-3c36-45c7-aeef-20558e20e496',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.12.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'bd6002bf-c415-4f2f-bc32-a5d650a91be7','','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_1500b3eb-4b86-46c1-9c9f-7efbd0224ac8_TOPLY__ZIP_','2022-05-25 08:56:38','2022-05-13 18:22:04','','2022-05-25 10:56:38','SYNCED','bd6002bf-c415-4f2f-bc32-a5d650a91be7',0,'2022-05-25 10:56:38','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.2 Occlusion 4\",\"modelMatrix\":\"-0.80453,0.576793,-0.141569,0,-0.593912,-0.781339,0.191773,0,-6.05286e-09,0.238367,0.971175,0,0.910551,-5.61768,-25.9513,1\",\"referenceScanID\":\"1.24.1.1.2\",\"title\":\"Maxillaire 1.24.1.1.2 Occlusion 4\"}'),(1001,'bd6547b3-c0de-47d0-bbc5-60dbfff0774b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_fde05ea2-d0fd-419b-ba13-bf1a1bd03a22/18_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_BOSC_fde05ea2-d0fd-419b-ba13-bf1a1bd03a22_SNAPS_','2022-03-07 14:25:30','2022-03-07 15:25:17','18_w1_o1_mandibule_snapshot_0.png','2022-03-07 15:25:30','SYNCED','bd6547b3-c0de-47d0-bbc5-60dbfff0774b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.18.1.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'bd950b62-1dff-4500-a7bd-87564d6d797c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/986374de-c4d7-4d6f-bf0c-2dc7e3b859a9/session_c81670ed-4144-4347-b19e-8057d11b5f7c/occlusion_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be/scan_f6f4f4dc-826e-4efc-957c-61074915b6b6/28_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_986374de-c4d7-4d6f-bf0c-2dc7e3b859a9_ACT_c81670ed-4144-4347-b19e-8057d11b5f7c_SESS_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be_RISC_f6f4f4dc-826e-4efc-957c-61074915b6b6_ZIP_','2022-05-31 10:52:50','2022-05-31 12:52:42','28_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-05-31 12:52:50','SYNCED','bd950b62-1dff-4500-a7bd-87564d6d797c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.28.1.1.1\",\"modelMatrix\":\"0.989642,-0.0901087,0.109351,0,0.0882222,0.994872,0.0512598,0,-0.113313,-0.0463427,0.992693,0,6.92822,1.84947,-16.9683,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(2,'bda6bdd6-862a-42a9-a75d-a4bcb49f2d6b','','ZIP','PATIENT_1095dc95-d70a-4936-8b50-ae8aa7963fc9_ACT_440a8315-0df8-4219-8d74-9470bfeeacbf_SESS_8cfb01ae-a13a-442b-9752-d2219bf5d263_TOSC_807a5b2c-0545-475c-b38c-00561d7c62df_ZIP_','2022-08-30 08:32:23','2022-07-28 14:33:14','',NULL,'CREATED','bda6bdd6-862a-42a9-a75d-a4bcb49f2d6b',0,'2022-08-30 10:32:23','bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.2.1.1.1\",\"modelMatrix\":\"0.781299,-0.551197,0.292837,0,0.624157,0.689971,-0.366563,0,-3.73229e-09,0.469172,0.883107,0,9.52285,-32.0404,-18.9641,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'bdacdfeb-45f7-4ecd-a130-0d654c6fa37f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_04d6e3f1-19ce-4851-a9d0-40419cea7542/scan_e61be1a3-1cc4-4625-b318-5e591ee9846a/19_w1_o2_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_04d6e3f1-19ce-4851-a9d0-40419cea7542_FRSC_e61be1a3-1cc4-4625-b318-5e591ee9846a_SNAPS_','2022-04-15 11:41:18','2022-04-01 18:21:10','19_w1_o2_mordu_anterieur_snapshot_0.png','2022-04-15 13:41:18','SYNCED','bdacdfeb-45f7-4ecd-a130-0d654c6fa37f',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.19.1.2.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'bddcd9b3-c70e-46f1-8f8d-64ad558320cb','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/1c189ddc-0ee7-45e7-9d80-585dac08374a/session_01bd0635-6ec6-42cb-8561-8638bded352c/occlusion_2aa712ca-8b46-4a50-a03e-1c6a6a0c40fc/scan_c38af399-ff7c-47c5-8f3f-7a96401d72b5/29_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_1c189ddc-0ee7-45e7-9d80-585dac08374a_ACT_01bd0635-6ec6-42cb-8561-8638bded352c_SESS_2aa712ca-8b46-4a50-a03e-1c6a6a0c40fc_LESC_c38af399-ff7c-47c5-8f3f-7a96401d72b5_ZIP_','2022-06-03 14:04:21','2022-06-03 16:04:14','29_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-06-03 16:04:21','SYNCED','bddcd9b3-c70e-46f1-8f8d-64ad558320cb',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.29.1.1.1\",\"modelMatrix\":\"-0.981057,0.00668509,-0.194821,0,-0.0578871,-0.967667,0.241749,0,-0.184897,0.252197,0.950592,0,-11.5718,-8.39478,-24.1213,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'be597cd8-a226-4cc2-affe-df9ddb8e42a3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_2a7068fc-0efa-496f-ade9-aba5b0650655/12_w1_o1_mandibule_scan_file_2.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_2a7068fc-0efa-496f-ade9-aba5b0650655_ZIP_','2022-02-04 11:57:21','2022-02-04 12:56:17','12_w1_o1_mandibule_scan_file_2.zip','2022-02-04 12:57:21','SYNCED','44ebcd6f-57c2-4cce-96f5-f9faa1c6b373',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.5\",\"modelMatrix\":\"0.713807,-0.664318,0.221723,0,0.700343,0.677089,-0.225986,0,-4.22566e-9,0.316593,0.948562,0,3.53751,30.2884,-29.5645,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'bf0bcfa3-f531-46fe-9ee8-0c42f01196a3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_b28164eb-0070-4968-83be-bfabe1a0c839/13_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_b28164eb-0070-4968-83be-bfabe1a0c839_ZIP_','2022-02-04 17:55:53','2022-02-04 16:58:23','13_w1_o1_mandibule_scan_file_1.zip','2022-02-04 18:55:53','SYNCED','d8a3bf39-16d1-435f-bafa-6c625f77d811',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.5\",\"modelMatrix\":\"-0.999116,-0.0392827,0.0149893,0,0.0420454,-0.933468,0.356187,0,-3.66865e-10,0.356503,0.934294,0,26.1512,5.7893,-22.5637,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'bf19efc9-b89f-4603-b2a2-1ce7bcd94152','','ZIP','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_LESC_0e74383c-84a7-4c1f-b833-adf54ce6a402_ZIP_','2022-09-10 08:18:25','2022-09-10 10:17:21','','2022-09-10 10:18:25','SYNCED','2c5f5cbb-b4e2-48d5-951b-8b45381f8520',1,'2022-09-10 10:18:25','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.39.1.1.11\",\"modelMatrix\":\"0.982905,0.0665172,0.172476,0,-0.0922199,0.979731,0.17838,0,-0.159442,-0.189045,0.968733,0,17.3596,5.98539,-12.3379,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'bf1a3548-3c4b-44f2-98bd-9b8130cf0fb8','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_04d6e3f1-19ce-4851-a9d0-40419cea7542/scan_9e43db2d-10a9-414e-ac07-6b7642412ce5/19_w1_o2_maxillaire_scan_file_0.zip','ZIP','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_04d6e3f1-19ce-4851-a9d0-40419cea7542_TOSC_9e43db2d-10a9-414e-ac07-6b7642412ce5_ZIP_','2022-04-15 11:41:38','2022-04-01 18:15:20','19_w1_o2_maxillaire_scan_file_0.zip','2022-04-15 13:41:38','SYNCED','bf1a3548-3c4b-44f2-98bd-9b8130cf0fb8',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.19.1.2.1\",\"modelMatrix\":\"0.318649,0.89091,-0.323639,0,-0.947873,0.299499,-0.108798,0,3.80085e-09,0.341437,0.939905,0,13.7443,-16.4334,-19.6973,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'bf27fa48-2bce-43eb-98c2-306272ec251f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/computedocclusion_6960b50e-6f78-4f83-9303-8c985410457c/4_w1_o4_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_OCC_6960b50e-6f78-4f83-9303-8c985410457c_BOMA__MATRX_','2022-05-31 14:55:58','2022-05-31 16:55:44','4_w1_o4_mandibule_matrix_occ_file_0.m','2022-05-31 16:55:58','SYNCED','bf27fa48-2bce-43eb-98c2-306272ec251f',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.4.1.4.1 Occlusion 5\",\"referenceScanID\":\"1.4.1.4.1\",\"title\":\"Matrice Transfo. Mandibule 1.4.1.4.1 Occlusion 5\"}'),(1001,'bf2dec6c-e829-4736-9db7-bda108ca2719','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/207d6dbc-c19b-4726-a9b3-16235ae554cc/session_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35/occlusion_dc5762a3-c453-4166-8c86-82d23ac9f8a6/scan_db144753-52d9-4c43-950b-25093a3aee5f/27_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_207d6dbc-c19b-4726-a9b3-16235ae554cc_ACT_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35_SESS_dc5762a3-c453-4166-8c86-82d23ac9f8a6_RISC_db144753-52d9-4c43-950b-25093a3aee5f_ZIP_','2022-05-30 11:09:16','2022-05-30 13:09:08','27_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-05-30 13:09:16','SYNCED','bf2dec6c-e829-4736-9db7-bda108ca2719',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.27.1.1.1\",\"modelMatrix\":\"0.996158,-0.023589,0.0912871,0,0.0456219,0.945925,-0.313373,0,-0.0751123,0.323645,0.945278,0,4.22253,-9.63293,-15.9528,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'bf650fa6-3b37-4142-ba9f-2bdb57a0b0a0','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_909d9ecd-46b3-4692-868e-f6405507ecd1/24_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_TOSC_909d9ecd-46b3-4692-868e-f6405507ecd1_SNAPS_','2022-05-13 14:42:34','2022-05-13 16:42:22','24_w1_o1_maxillaire_snapshot_1.png','2022-05-13 16:42:34','SYNCED','80ec1edf-c2f7-4914-86c8-ba85dac6448a',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'bfbd620d-ea20-449f-aa53-6517b2fdaa2e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_1c86378e-7d31-4b12-82ff-af797020160f/4_w1_o2_mandibule_scan_file_3.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_BOSC_1c86378e-7d31-4b12-82ff-af797020160f_ZIP_','2022-03-08 11:43:38','2022-03-08 12:43:31','4_w1_o2_mandibule_scan_file_3.zip','2022-03-08 12:43:38','SYNCED','bb22e8ec-52ef-47ae-acce-e63ab615a505',3,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.2.3\",\"modelMatrix\":\"0.966621,-0.254359,0.0307347,0,0.256209,0.959641,-0.115955,0,1.29208e-09,0.119959,0.992779,0,-3.1268,5.20706,-21.613,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'bfbe666e-8f72-4da8-8054-ee175d7a8ba1','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/scan_03839278-13f8-46e6-9581-ba11bc8bcb81/1_w1_o1_maxillaire_snapshot_2.png','SNAPS','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_TOSC_03839278-13f8-46e6-9581-ba11bc8bcb81_SNAPS_','2022-01-19 12:59:56','2022-01-19 11:09:47','1_w1_o1_maxillaire_snapshot_2.png','2022-01-19 13:59:56','SYNCED','99c7b58b-6259-4c43-ac2f-8b7f47f0b3e7',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.1.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'c0104148-b00b-48dc-8336-d2def7604c23','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/scan_f2bad12a-451d-406d-98b0-e431a37951dd/19_w1_o1_mandibule_snapshot_3.png','SNAPS','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_BOSC_f2bad12a-451d-406d-98b0-e431a37951dd_SNAPS_','2022-03-08 10:52:49','2022-03-08 11:52:38','19_w1_o1_mandibule_snapshot_3.png','2022-03-08 11:52:49','SYNCED','8fb19261-9e70-4678-8a85-98e89dd98dcb',3,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.1.4\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'c0e2418d-8a03-4c3c-bc34-614d663c5fce','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/occlusion_e08bbeeb-a30b-428c-bd4a-40198f792219/scan_dee5ca38-e252-41d1-86ca-aebc66ae36fa/25_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_SESS_e08bbeeb-a30b-428c-bd4a-40198f792219_TOSC_dee5ca38-e252-41d1-86ca-aebc66ae36fa_SNAPS_','2022-05-17 16:34:40','2022-05-17 18:33:04','25_w1_o1_maxillaire_snapshot_0.png','2022-05-17 18:34:40','SYNCED','c0e2418d-8a03-4c3c-bc34-614d663c5fce',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.25.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'c1120aee-580c-477f-b742-b40b047b9a91','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_2ffbfbca-f236-4802-be93-8eb43d523274/scan_6313fe60-344e-44c5-9805-fd1382bb983f/4_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_2ffbfbca-f236-4802-be93-8eb43d523274_LESC_6313fe60-344e-44c5-9805-fd1382bb983f_SNAPS_','2022-01-19 19:08:57','2022-01-19 20:08:48','4_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-01-19 20:08:57','SYNCED','c1120aee-580c-477f-b742-b40b047b9a91',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.4.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'c14ac2f7-ec03-4ab2-8267-1c397129a864','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/8fc74d9e-a5a0-46bf-be3f-500548a130ad/session_5368829e-7dec-4775-a487-a1019f9604f4/occlusion_bb63a653-1b34-4d80-a4bf-7fda5c9b0360/scan_e3fea328-cb79-4ad5-a652-3eebe9ee3e12/14_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_8fc74d9e-a5a0-46bf-be3f-500548a130ad_ACT_5368829e-7dec-4775-a487-a1019f9604f4_SESS_bb63a653-1b34-4d80-a4bf-7fda5c9b0360_TOSC_e3fea328-cb79-4ad5-a652-3eebe9ee3e12_ZIP_','2022-02-01 10:42:11','2022-02-01 11:41:46','14_w1_o1_maxillaire_scan_file_0.zip','2022-02-01 11:42:11','SYNCED','c14ac2f7-ec03-4ab2-8267-1c397129a864',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.14.1.1.1\",\"modelMatrix\":\"-0.0269183,0.931537,-0.362649,0,-0.999638,-0.0250845,0.00976544,0,7.96669e-10,0.362781,0.931875,0,-6.3101,-33.0938,-17.1491,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'c15808cb-381a-47c9-ba70-a9a403b0e4bd','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/1c189ddc-0ee7-45e7-9d80-585dac08374a/session_01bd0635-6ec6-42cb-8561-8638bded352c/occlusion_2aa712ca-8b46-4a50-a03e-1c6a6a0c40fc/scan_2b27113d-3b20-4d7e-8591-1e87c6e97f79/29_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_1c189ddc-0ee7-45e7-9d80-585dac08374a_ACT_01bd0635-6ec6-42cb-8561-8638bded352c_SESS_2aa712ca-8b46-4a50-a03e-1c6a6a0c40fc_BOSC_2b27113d-3b20-4d7e-8591-1e87c6e97f79_SNAPS_','2022-06-03 14:01:22','2022-06-03 16:01:12','29_w1_o1_mandibule_snapshot_0.png','2022-06-03 16:01:22','SYNCED','c15808cb-381a-47c9-ba70-a9a403b0e4bd',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.29.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'c1706d9d-89f0-4794-af54-6d74e899ee8d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/computedocclusion_d7643aed-d242-47f6-8e1a-703d4672f109/18_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_OCC_d7643aed-d242-47f6-8e1a-703d4672f109_SNAPO__SNAPS_','2022-03-07 14:44:47','2022-03-07 15:44:20','18_w1_o1_snapshot_occ_file_0.png','2022-03-07 15:44:47','SYNCED','c1706d9d-89f0-4794-af54-6d74e899ee8d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'c1eb653c-d8dd-488d-b196-a7a488805ae6','','ZIP','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_c9079d19-8ffb-46f7-a51e-3a7a90ccae59_SESS_8ba0f3b1-408f-4a02-92a0-63f09123b68e_BOSC_30b22823-10be-472c-b053-59b470998f02_ZIP_','2022-01-28 17:15:46','2022-01-25 13:09:38','','2022-01-28 18:15:46','SYNCED','bc633195-8681-4e1b-b717-dddd5f11bde7',1,'2022-01-28 18:15:46','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.10.1.1.1\",\"modelMatrix\":\"-0.983812,-0.173715,0.0440174,0,0.179205,-0.953672,0.24165,0,1.67449e-9,0.245626,0.969365,0,14.6058,7.88415,-24.7234,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'c1ee6f0c-823c-43ab-892b-aa2b9c60a5d0','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/scan_7b00996b-90f8-4307-9a8c-263a28f1b341/4_w1_o4_maxillaire_scan_file_0.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_TOSC_7b00996b-90f8-4307-9a8c-263a28f1b341_ZIP_','2022-05-31 11:49:48','2022-05-31 13:49:39','4_w1_o4_maxillaire_scan_file_0.zip','2022-05-31 13:49:48','SYNCED','c1ee6f0c-823c-43ab-892b-aa2b9c60a5d0',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.4.1.4.1\",\"modelMatrix\":\"-0.976219,0.212414,-0.0433081,0,-0.216784,-0.956541,0.195024,0,9.94229e-10,0.199775,0.979842,0,22.5049,-19.3077,-18.1141,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'c202fc68-d539-4e94-bd22-11d4de172444','','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_OCC_764b8e22-8600-49e3-8d7c-d619725096ee_TOPLY__ZIP_','2022-02-04 18:20:41','2022-02-04 19:19:48','',NULL,'CREATED','c202fc68-d539-4e94-bd22-11d4de172444',0,'2022-02-04 19:20:41','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.13.1.1.3 Occlusion 2\",\"modelMatrix\":\"0.754335,0.643596,-0.129474,0,-0.65649,0.739519,-0.148771,0,2.61688e-9,0.197222,0.980359,0,-9.25272,-30.1421,-17.7968,1\",\"referenceScanID\":\"1.13.1.1.3\",\"title\":\"Maxillaire 1.13.1.1.3 Occlusion 2\"}'),(1001,'c21d6e1f-eb4c-4e11-b986-f98e0036cdad','','SNAPS','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_RISC_029ae158-d269-4f43-b5ee-add7ce3f59c5_SNAPS_','2022-04-21 13:44:33','2022-04-21 13:25:56','','2022-04-21 15:44:33','SYNCED','c21d6e1f-eb4c-4e11-b986-f98e0036cdad',0,'2022-04-21 15:44:33','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.22.1.1.4\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'c22c34d6-3e86-4fba-8c43-6789f89dcca5','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/computedocclusion_d5bff097-1085-4c55-afe3-1ce57126d88f/19_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_OCC_d5bff097-1085-4c55-afe3-1ce57126d88f_SNAPO__SNAPS_','2022-03-08 11:16:25','2022-03-08 12:15:58','19_w1_o1_snapshot_occ_file_0.png','2022-03-08 12:16:25','SYNCED','c22c34d6-3e86-4fba-8c43-6789f89dcca5',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'c22cf400-8aa1-42db-9cdb-0b4c8cf80b52','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a0c21836-ba79-4f15-9e35-02ef8211a9e5/session_0aac522d-3c38-465a-a1e0-014166c140ac/occlusion_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042/scan_b3e360d5-eb70-4046-910f-cbac3270fd6c/7_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_a0c21836-ba79-4f15-9e35-02ef8211a9e5_ACT_0aac522d-3c38-465a-a1e0-014166c140ac_SESS_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042_TOSC_b3e360d5-eb70-4046-910f-cbac3270fd6c_SNAPS_','2022-01-21 11:31:57','2022-01-21 12:31:32','7_w1_o1_maxillaire_snapshot_0.png','2022-01-21 12:31:57','SYNCED','c22cf400-8aa1-42db-9cdb-0b4c8cf80b52',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.7.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'c2e41fcc-1846-464a-b169-dcfb11da5d08','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/computedocclusion_42098ceb-3335-4f13-8aed-b29c37a5f57f/22_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_OCC_42098ceb-3335-4f13-8aed-b29c37a5f57f_TOMA__MATRX_','2022-04-21 11:29:06','2022-04-21 13:28:43','22_w1_o1_maxillaire_matrix_occ_file_0.m','2022-04-21 13:29:06','SYNCED','c2e41fcc-1846-464a-b169-dcfb11da5d08',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.22.1.1.1 Occlusion 6\",\"referenceScanID\":\"1.22.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.22.1.1.1 Occlusion 6\"}'),(1001,'c30979c0-872b-4f50-a4ed-19896daeb6d2','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/4a3954e0-1e2f-4721-9fdd-4180380dc19f/session_33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416/occlusion_3accbada-5a51-4d10-88d1-c3e7d8598d6f/computedocclusion_5775815f-f076-48af-be27-50e4dbfd3622/34_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_4a3954e0-1e2f-4721-9fdd-4180380dc19f_ACT_33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416_SESS_3accbada-5a51-4d10-88d1-c3e7d8598d6f_OCC_5775815f-f076-48af-be27-50e4dbfd3622_BOPLY__ZIP_','2022-06-28 10:56:07','2022-06-28 12:55:54','34_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-06-28 12:56:07','SYNCED','c30979c0-872b-4f50-a4ed-19896daeb6d2',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.34.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.234069,0.962585,-0.136536,0,-0.97222,0.231749,-0.0328721,0,9.44423e-10,0.140438,0.990089,0,-4.58165,-19.1006,-16.3325,1\",\"referenceScanID\":\"1.34.1.1.1\",\"title\":\"Mandibule 1.34.1.1.1 Occlusion 1\"}'),(1001,'c3304273-3e21-43cc-9d46-d2367b2cd27a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f4fc00ec-4af8-4a15-b427-f1c5aabf6260/session_498ae60a-23f0-44fc-9730-be499bfc4b46/occlusion_8f3d6c73-3468-45a5-85c7-93bba47ec9f7/computedocclusion_9c318e86-fa90-4cd9-8319-2503cde2b455/30_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_f4fc00ec-4af8-4a15-b427-f1c5aabf6260_ACT_498ae60a-23f0-44fc-9730-be499bfc4b46_SESS_8f3d6c73-3468-45a5-85c7-93bba47ec9f7_OCC_9c318e86-fa90-4cd9-8319-2503cde2b455_SNAPO__SNAPS_','2022-06-14 13:30:13','2022-06-14 15:29:56','30_w1_o1_snapshot_occ_file_0.png','2022-06-14 15:30:13','SYNCED','c3304273-3e21-43cc-9d46-d2367b2cd27a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'c36d61c2-2b14-4da2-9185-e643f1f6742b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_e6c95ef7-636d-4c88-8d02-e2d9840573db/13_w1_o1_mandibule_scan_file_8.zip','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_e6c95ef7-636d-4c88-8d02-e2d9840573db_ZIP_','2022-01-27 16:51:00','2022-01-27 17:49:39','13_w1_o1_mandibule_scan_file_8.zip','2022-01-27 17:51:00','SYNCED','bcef8d3e-9632-4976-8cda-4c6f3ac50e99',8,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.1\",\"modelMatrix\":\"-0.961822,0.259307,-0.0875072,0,-0.273675,-0.911329,0.307542,0,5.65717e-9,0.319749,0.947502,0,33.7925,-1.80222,-15.4388,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'c374da70-6cb6-437a-8ae4-040181827836','','SNAPS','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_c9079d19-8ffb-46f7-a51e-3a7a90ccae59_SESS_8ba0f3b1-408f-4a02-92a0-63f09123b68e_BOSC_30b22823-10be-472c-b053-59b470998f02_SNAPS_','2022-01-28 17:15:46','2022-01-25 13:09:36','','2022-01-28 18:15:46','SYNCED','6f4c2c37-2063-47e9-9b81-2912e4b09097',1,'2022-01-28 18:15:46','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.10.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'c398736b-e3ae-4eeb-8e0f-feb7cac2e342','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f9d03016-567a-4bd4-9cc5-dafeea34e365/session_a7bcb190-dd19-4f3b-8aab-266030bf4064/occlusion_c321e210-b67c-40e8-bece-f8946164a768/scan_e7993d2d-cc6b-42d8-af77-232b04342812/36_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_f9d03016-567a-4bd4-9cc5-dafeea34e365_ACT_a7bcb190-dd19-4f3b-8aab-266030bf4064_SESS_c321e210-b67c-40e8-bece-f8946164a768_TOSC_e7993d2d-cc6b-42d8-af77-232b04342812_ZIP_','2022-07-04 14:04:56','2022-07-04 16:04:46','36_w1_o1_maxillaire_scan_file_0.zip','2022-07-04 16:04:56','SYNCED','c398736b-e3ae-4eeb-8e0f-feb7cac2e342',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.36.1.1.1\",\"modelMatrix\":\"-0.740632,0.661068,-0.120222,0,-0.671911,-0.72868,0.132518,0,7.47193e-09,0.178926,0.983863,0,13.1843,-17.5524,-17.7657,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'c47f0341-13c6-4776-87a1-2fd20d6de1f6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5/occlusion_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa/scan_569997ca-080a-44fb-9a38-e48cedabde17/24_w2_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5_SESS_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa_RISC_569997ca-080a-44fb-9a38-e48cedabde17_ZIP_','2022-10-06 14:32:32','2022-10-06 16:32:23','24_w2_o1_mordu_posterieur_droit_scan_file_0.zip','2022-10-06 16:32:32','SYNCED','c47f0341-13c6-4776-87a1-2fd20d6de1f6',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.24.2.1.1\",\"modelMatrix\":\"0.91691,-0.222722,0.334487,0,0.254371,0.970138,-0.032408,0,-0.307894,0.0978427,0.941983,0,-3.31695,1.77755,-23.2937,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'c4ff0a0b-2408-4188-9880-ebaa94ad910a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/scan_48982add-ff93-4e3a-a453-012a73678b39/19_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_TOSC_48982add-ff93-4e3a-a453-012a73678b39_SNAPS_','2022-03-08 11:09:41','2022-03-08 12:05:21','19_w1_o1_maxillaire_snapshot_0.png','2022-03-08 12:09:41','SYNCED','c4ff0a0b-2408-4188-9880-ebaa94ad910a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.19.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'c502efab-3bf8-4a22-9770-a0bafe543472','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/occlusion_e08bbeeb-a30b-428c-bd4a-40198f792219/scan_ef1d20c7-5f61-4c35-8f0f-d85507cab786/25_w1_o1_mandibule_snapshot_2.png','SNAPS','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_SESS_e08bbeeb-a30b-428c-bd4a-40198f792219_BOSC_ef1d20c7-5f61-4c35-8f0f-d85507cab786_SNAPS_','2022-05-17 16:16:07','2022-05-17 18:15:56','25_w1_o1_mandibule_snapshot_2.png','2022-05-17 18:16:07','SYNCED','135e8c27-bf0a-4d0f-b495-291e99638543',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.25.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'c5123228-55c5-43a0-9a9c-7d17bd8cb24d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f4fc00ec-4af8-4a15-b427-f1c5aabf6260/session_498ae60a-23f0-44fc-9730-be499bfc4b46/occlusion_8f3d6c73-3468-45a5-85c7-93bba47ec9f7/scan_60c1cc80-0d70-4511-8993-70e3a3c146b8/30_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_f4fc00ec-4af8-4a15-b427-f1c5aabf6260_ACT_498ae60a-23f0-44fc-9730-be499bfc4b46_SESS_8f3d6c73-3468-45a5-85c7-93bba47ec9f7_BOSC_60c1cc80-0d70-4511-8993-70e3a3c146b8_ZIP_','2022-06-14 13:16:26','2022-06-14 15:16:18','30_w1_o1_mandibule_scan_file_0.zip','2022-06-14 15:16:26','SYNCED','c5123228-55c5-43a0-9a9c-7d17bd8cb24d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.30.1.1.1\",\"modelMatrix\":\"-0.0163336,0.974991,-0.221642,0,-0.999867,-0.0159273,0.0036207,0,-1.39559e-11,0.221671,0.975122,0,3.56533,-3.65104,-21.0782,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'c51cc335-f9b4-4a40-a708-fe3efb266be8','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/4a3954e0-1e2f-4721-9fdd-4180380dc19f/session_33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416/occlusion_3accbada-5a51-4d10-88d1-c3e7d8598d6f/scan_ca26b24d-fb66-43e1-8719-cc661811d143/34_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_4a3954e0-1e2f-4721-9fdd-4180380dc19f_ACT_33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416_SESS_3accbada-5a51-4d10-88d1-c3e7d8598d6f_BOSC_ca26b24d-fb66-43e1-8719-cc661811d143_ZIP_','2022-06-28 10:49:57','2022-06-28 12:49:36','34_w1_o1_mandibule_scan_file_0.zip','2022-06-28 12:49:57','SYNCED','c51cc335-f9b4-4a40-a708-fe3efb266be8',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.34.1.1.1\",\"modelMatrix\":\"0.234069,0.962585,-0.136536,0,-0.97222,0.231749,-0.0328721,0,9.44423e-10,0.140438,0.990089,0,-4.58165,-19.1006,-16.3325,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'c528e035-d66a-4a5a-af0f-3f0a50b070e9','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/45ff7437-0691-4427-a7da-8250862e4b96/session_4ff9c682-c09d-42ff-8c29-aeb13e066ed2/occlusion_934673c1-a4b9-4508-ac1b-a03092a0693e/computedocclusion_161f60a4-d4f2-41f1-98ad-a8ccad84216c/9_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_45ff7437-0691-4427-a7da-8250862e4b96_ACT_4ff9c682-c09d-42ff-8c29-aeb13e066ed2_SESS_934673c1-a4b9-4508-ac1b-a03092a0693e_OCC_161f60a4-d4f2-41f1-98ad-a8ccad84216c_BOMA__MATRX_','2022-01-24 19:55:58','2022-01-24 18:46:00','9_w1_o1_mandibule_matrix_occ_file_0.m','2022-01-24 20:55:58','SYNCED','c528e035-d66a-4a5a-af0f-3f0a50b070e9',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.9.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.9.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.9.1.1.1 Occlusion 1\"}'),(1001,'c58e0c5c-8de5-450c-92a2-c7f91466da07','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_1c86378e-7d31-4b12-82ff-af797020160f/4_w1_o2_mandibule_snapshot_1.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_BOSC_1c86378e-7d31-4b12-82ff-af797020160f_SNAPS_','2022-03-08 11:37:30','2022-03-08 12:37:20','4_w1_o2_mandibule_snapshot_1.png','2022-03-08 12:37:30','SYNCED','a13ef72a-3421-4e8c-a897-3f43da14e842',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.2.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'c62a941d-41df-44aa-8e43-9114b0708bfe','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_93b9b214-5793-480a-b05f-e0419802faf3/12_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_LESC_93b9b214-5793-480a-b05f-e0419802faf3_ZIP_','2022-02-04 12:18:02','2022-02-04 13:17:21','12_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-02-04 13:18:02','SYNCED','c62a941d-41df-44aa-8e43-9114b0708bfe',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.12.1.1.1\",\"modelMatrix\":\"-0.994934,0.10248,-0.000225791,0,-0.094588,-0.907034,0.405268,0,0.0347007,0.408441,0.914238,0,19.3653,-9.00903,-19.0684,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'c675f19c-ea90-43f3-977b-db1bed22b847','','MATRX','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_OCC_d8bec5dc-8405-473d-9ba5-ae6e461ed6fd_BOMA__MATRX_','2022-02-07 11:15:31','2022-02-04 19:13:44','','2022-02-07 12:15:31','SYNCED','c675f19c-ea90-43f3-977b-db1bed22b847',0,'2022-02-07 12:15:31','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.13.1.1.5 Occlusion 1\",\"referenceScanID\":\"1.13.1.1.5\",\"title\":\"Matrice Transfo. Mandibule 1.13.1.1.5 Occlusion 1\"}'),(1001,'c6a0ab44-7a00-4b6f-a666-47eee74159a8','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_16f04a07-72e8-4a39-9b55-3ae7405733af/24_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_TOSC_16f04a07-72e8-4a39-9b55-3ae7405733af_SNAPS_','2022-06-13 14:42:43','2022-06-13 16:42:29','24_w1_o1_maxillaire_snapshot_1.png','2022-06-13 16:42:43','SYNCED','ace017e9-ff30-403f-aee6-3daa66025d8d',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.4\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'c6a6cc47-17e5-4709-a61d-687818334a3d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/1c189ddc-0ee7-45e7-9d80-585dac08374a/session_01bd0635-6ec6-42cb-8561-8638bded352c/occlusion_2aa712ca-8b46-4a50-a03e-1c6a6a0c40fc/computedocclusion_727485e0-8637-4024-83d8-95544991f73f/29_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_1c189ddc-0ee7-45e7-9d80-585dac08374a_ACT_01bd0635-6ec6-42cb-8561-8638bded352c_SESS_2aa712ca-8b46-4a50-a03e-1c6a6a0c40fc_OCC_727485e0-8637-4024-83d8-95544991f73f_BOPLY__ZIP_','2022-06-03 14:07:08','2022-06-03 16:07:00','29_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-06-03 16:07:08','SYNCED','c6a6cc47-17e5-4709-a61d-687818334a3d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.29.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.32521,0.939942,-0.103669,0,-0.945642,0.323249,-0.035652,0,-2.34477e-09,0.109628,0.993973,0,-1.47724,-13.3603,-18.8662,1\",\"referenceScanID\":\"1.29.1.1.1\",\"title\":\"Mandibule 1.29.1.1.1 Occlusion 1\"}'),(1001,'c6c573d5-7bda-4cd0-a449-03697aa6e5d0','','SNAPS','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_OCC_d58ce31f-4b72-44ad-b0e0-3d5d7d789322_SNAPO__SNAPS_','2022-01-19 11:15:36','2022-01-19 12:06:18','',NULL,'CREATED','c6c573d5-7bda-4cd0-a449-03697aa6e5d0',0,'2022-01-19 12:15:36','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'c6f2af8e-25a2-4233-a0e5-d0a7fc9edcd6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/32710234-804f-46f5-899d-eed636f8a906/session_64c1427a-b91d-4675-94df-f36bd40e9b0f/occlusion_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a/scan_62c04472-88fd-4ac5-acbe-aefb92941897/33_w2_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_32710234-804f-46f5-899d-eed636f8a906_ACT_64c1427a-b91d-4675-94df-f36bd40e9b0f_SESS_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a_TOSC_62c04472-88fd-4ac5-acbe-aefb92941897_SNAPS_','2022-06-28 08:50:38','2022-06-28 10:50:29','33_w2_o1_maxillaire_snapshot_0.png','2022-06-28 10:50:38','SYNCED','c6f2af8e-25a2-4233-a0e5-d0a7fc9edcd6',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.33.2.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'c70c8d05-0624-44f5-bb93-2e1274c340ee','','ZIP','PATIENT_de078619-3946-4adb-a799-1c260e16face_ACT_24d0aeb5-3058-4070-aeea-97c289e41e3c_SESS_ea6da896-1504-41fc-890c-7c48575e9e40_BOSC_c4bbad69-6205-4593-a0c3-370703a57829_ZIP_','2022-01-19 17:01:43','2022-01-19 15:26:32','','2022-01-19 18:01:43','SYNCED','c70c8d05-0624-44f5-bb93-2e1274c340ee',0,'2022-01-19 18:01:43','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.2.1.1.2\",\"modelMatrix\":\"0.978702,-0.202702,0.0324652,0,0.205285,0.966386,-0.154779,0,-2.20111e-9,0.158147,0.987416,0,-22.9416,-8.01331,-23.5558,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'c75aec3c-48c9-4ed4-bff2-915eea965408','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_59fb6872-6b71-417d-a7ee-ab313b732b6c/13_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_TOSC_59fb6872-6b71-417d-a7ee-ab313b732b6c_SNAPS_','2022-02-04 17:54:27','2022-02-04 17:22:18','13_w1_o1_maxillaire_snapshot_0.png','2022-02-04 18:54:27','SYNCED','c75aec3c-48c9-4ed4-bff2-915eea965408',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.13.1.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'c75c9738-5102-44e8-984a-602d0317e781','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/scan_03839278-13f8-46e6-9581-ba11bc8bcb81/1_w1_o1_maxillaire_snapshot_3.png','SNAPS','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_TOSC_03839278-13f8-46e6-9581-ba11bc8bcb81_SNAPS_','2022-01-19 13:00:20','2022-01-19 11:24:48','1_w1_o1_maxillaire_snapshot_3.png','2022-01-19 14:00:20','SYNCED','99c7b58b-6259-4c43-ac2f-8b7f47f0b3e7',3,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.1.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'c7a07589-5ed0-4af7-87c4-ea2cb405806d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/computedocclusion_8e4092a3-64a2-4464-addd-03b3c8ba2289/24_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_8e4092a3-64a2-4464-addd-03b3c8ba2289_TOPLY__ZIP_','2022-05-13 16:21:25','2022-05-13 18:20:53','24_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-05-13 18:21:25','SYNCED','c7a07589-5ed0-4af7-87c4-ea2cb405806d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.1 Occlusion 3\",\"modelMatrix\":\"-0.664301,0.739768,-0.106997,0,-0.747465,-0.657459,0.0950925,0,-2.95103e-09,0.143147,0.989702,0,-2.99497,-15.0747,-18.5223,1\",\"referenceScanID\":\"1.24.1.1.1\",\"title\":\"Maxillaire 1.24.1.1.1 Occlusion 3\"}'),(1001,'c7d8c731-2671-41fa-98d3-647d17160f01','','SNAPS','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_c9079d19-8ffb-46f7-a51e-3a7a90ccae59_SESS_8ba0f3b1-408f-4a02-92a0-63f09123b68e_TOSC_44c8d5b1-b2de-4ba6-8ae5-8bc2a88e7918_SNAPS_','2022-01-28 17:15:46','2022-01-27 14:19:01','','2022-01-28 18:15:46','SYNCED','c7d8c731-2671-41fa-98d3-647d17160f01',0,'2022-01-28 18:15:46','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.10.1.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'c7e78dc4-b222-4213-bd88-e0e8eaf1dd57','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/computedocclusion_e15a2d21-e8f2-4d2a-9a68-13d92ae4b997/13_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_OCC_e15a2d21-e8f2-4d2a-9a68-13d92ae4b997_SNAPO__SNAPS_','2022-02-04 18:24:13','2022-02-04 19:23:45','13_w1_o1_snapshot_occ_file_0.png','2022-02-04 19:24:13','SYNCED','c7e78dc4-b222-4213-bd88-e0e8eaf1dd57',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'c86f80fd-4c67-4f5e-84af-6f5ec6d853db','','SNAPS','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_OCC_ff8547d7-27f8-4862-9b63-e713dd817f3f_SNAPO__SNAPS_','2022-09-09 17:04:16','2022-09-09 19:03:34','','2022-09-09 19:04:16','SYNCED','c86f80fd-4c67-4f5e-84af-6f5ec6d853db',0,'2022-09-09 19:04:16','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'c8762bec-33be-47d7-9c3e-51433bd71b0e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/593972a6-d7d6-4802-b87d-38aab371f71e/session_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480/occlusion_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3/scan_4d153a25-3b94-464b-9b18-2966d8ae2ce6/3_w1_o1_mordu_anterieur_scan_file_0.zip','ZIP','PATIENT_593972a6-d7d6-4802-b87d-38aab371f71e_ACT_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480_SESS_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3_FRSC_4d153a25-3b94-464b-9b18-2966d8ae2ce6_ZIP_','2022-01-19 15:20:34','2022-01-19 16:20:21','3_w1_o1_mordu_anterieur_scan_file_0.zip','2022-01-19 16:20:34','SYNCED','c8762bec-33be-47d7-9c3e-51433bd71b0e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.3.1.1.1\",\"modelMatrix\":\"0.89653,0.229211,0.450147,0,-0.272758,0.91602,0.216685,0,-0.358878,-0.338066,0.866924,0,1.8086,5.61363,-20.2678,1\",\"title\":\"Mordu anterieur ZIP\"}'),(1001,'c8a71142-0e60-4fcc-a999-a0463c9bf517','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f9d03016-567a-4bd4-9cc5-dafeea34e365/session_a7bcb190-dd19-4f3b-8aab-266030bf4064/occlusion_c321e210-b67c-40e8-bece-f8946164a768/computedocclusion_03fe87bc-2a25-4d16-a476-2df62bb3cf76/36_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_f9d03016-567a-4bd4-9cc5-dafeea34e365_ACT_a7bcb190-dd19-4f3b-8aab-266030bf4064_SESS_c321e210-b67c-40e8-bece-f8946164a768_OCC_03fe87bc-2a25-4d16-a476-2df62bb3cf76_BOMA__MATRX_','2022-07-04 14:13:55','2022-07-04 16:13:45','36_w1_o1_mandibule_matrix_occ_file_0.m','2022-07-04 16:13:55','SYNCED','c8a71142-0e60-4fcc-a999-a0463c9bf517',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.36.1.1.1 Occlusion 2\",\"referenceScanID\":\"1.36.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.36.1.1.1 Occlusion 2\"}'),(1001,'c8aa4e70-99b3-4d60-8f2e-2059fee00def','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_a9b96b88-7783-474e-b983-cddc79b7d3f5/4_w1_o2_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_RISC_a9b96b88-7783-474e-b983-cddc79b7d3f5_ZIP_','2022-03-08 11:47:15','2022-03-08 12:47:08','4_w1_o2_mordu_posterieur_droit_scan_file_0.zip','2022-03-08 12:47:15','SYNCED','c8aa4e70-99b3-4d60-8f2e-2059fee00def',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.4.1.2.2\",\"modelMatrix\":\"0.979441,0.00722501,0.202364,0,0.00782012,1.00012,-0.00660264,0,-0.20218,-0.00320662,0.979323,0,4.57004,2.13016,-23.6245,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'c8ce37c5-1498-4ce9-83f1-3399b3c814c5','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/scan_48982add-ff93-4e3a-a453-012a73678b39/19_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_TOSC_48982add-ff93-4e3a-a453-012a73678b39_ZIP_','2022-03-08 11:09:54','2022-03-08 12:09:40','19_w1_o1_maxillaire_scan_file_1.zip','2022-03-08 12:09:54','SYNCED','def2bf42-b3c1-466e-907c-cde40a0d406c',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.19.1.1.1\",\"modelMatrix\":\"0.985752,-0.166051,0.0268482,0,0.168208,0.973114,-0.157339,0,2.19633e-09,0.159614,0.98718,0,-32.9792,-5.96138,-23.3688,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'c8d3c8ee-e345-4e37-b916-cb7e2be4fdab','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/occlusion_a2220645-c79d-4dda-b6cc-772384a4106b/scan_fb5993c3-7f31-49de-8a74-e83ef447f0a1/38_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_RISC_fb5993c3-7f31-49de-8a74-e83ef447f0a1_SNAPS_','2022-07-12 10:57:17','2022-07-12 12:57:08','38_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-07-12 12:57:17','SYNCED','c8d3c8ee-e345-4e37-b916-cb7e2be4fdab',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.38.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'c90b714e-2b2b-4ae2-9df1-861bb6516007','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/4a3954e0-1e2f-4721-9fdd-4180380dc19f/session_33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416/occlusion_3accbada-5a51-4d10-88d1-c3e7d8598d6f/scan_5b8f2ae7-343d-4058-ad87-94f21d555fc8/34_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_4a3954e0-1e2f-4721-9fdd-4180380dc19f_ACT_33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416_SESS_3accbada-5a51-4d10-88d1-c3e7d8598d6f_LESC_5b8f2ae7-343d-4058-ad87-94f21d555fc8_SNAPS_','2022-06-28 10:55:54','2022-06-28 12:55:42','34_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-06-28 12:55:54','SYNCED','c90b714e-2b2b-4ae2-9df1-861bb6516007',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.34.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'c91a0549-18bc-4fab-9374-cbe168adb081','','ZIP','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_c9079d19-8ffb-46f7-a51e-3a7a90ccae59_SESS_8ba0f3b1-408f-4a02-92a0-63f09123b68e_FRSC_4186a7d8-3050-4b21-ad69-cfd42fea66c5_ZIP_','2022-01-28 17:15:46','2022-01-27 14:31:24','','2022-01-28 18:15:46','SYNCED','c91a0549-18bc-4fab-9374-cbe168adb081',0,'2022-01-28 18:15:46','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.10.1.1.1\",\"modelMatrix\":\"0.823215,-0.0512026,0.56388,0,0.14672,0.98994,-0.0955582,0,-0.549191,0.135533,0.820402,0,1.77147,-6.43067,-23.9082,1\",\"title\":\"Mordu anterieur ZIP\"}'),(1001,'c940a2b4-e919-4581-b76e-1599f04aeab3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_fde05ea2-d0fd-419b-ba13-bf1a1bd03a22/18_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_BOSC_fde05ea2-d0fd-419b-ba13-bf1a1bd03a22_SNAPS_','2022-03-07 14:28:30','2022-03-07 15:28:17','18_w1_o1_mandibule_snapshot_1.png','2022-03-07 15:28:30','SYNCED','bd6547b3-c0de-47d0-bbc5-60dbfff0774b',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.18.1.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'ca610a91-eb3b-4579-a3b4-cd6d6bbbf6f3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_2a7068fc-0efa-496f-ade9-aba5b0650655/12_w1_o1_mandibule_scan_file_8.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_2a7068fc-0efa-496f-ade9-aba5b0650655_ZIP_','2022-02-04 12:11:39','2022-02-04 13:11:22','12_w1_o1_mandibule_scan_file_8.zip','2022-02-04 13:11:39','SYNCED','44ebcd6f-57c2-4cce-96f5-f9faa1c6b373',8,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.5\",\"modelMatrix\":\"0.748154,-0.636082,0.188853,0,0.663525,0.717211,-0.21294,0,-1.38811e-9,0.284621,0.95864,0,2.11874,31.439,-28.6314,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'caacb054-2bbe-498f-a1e1-ef4bb90d5d30','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_b7947fff-2f4c-4016-bc7a-372a7c0dd0c6/4_w1_o2_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_FRSC_b7947fff-2f4c-4016-bc7a-372a7c0dd0c6_SNAPS_','2022-02-15 12:39:04','2022-02-15 13:38:55','4_w1_o2_mordu_anterieur_snapshot_0.png','2022-02-15 13:39:04','SYNCED','caacb054-2bbe-498f-a1e1-ef4bb90d5d30',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.4.1.2.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'caafeef9-9f16-4de4-9c3d-3cf817241096','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/scan_03839278-13f8-46e6-9581-ba11bc8bcb81/1_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_TOSC_03839278-13f8-46e6-9581-ba11bc8bcb81_ZIP_','2022-01-19 13:01:08','2022-01-19 10:32:04','1_w1_o1_maxillaire_scan_file_1.zip','2022-01-19 14:01:08','SYNCED','96dd75bb-5035-460a-8afc-04f3755604b1',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.1.1.1.1\",\"modelMatrix\":\"-0.0458664,0.939736,-0.33881,0,-0.998948,-0.0431478,0.0155564,0,5.55822e-11,0.339167,0.940726,0,-19.7451,-37.5507,-12.532,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'cb2e0202-0d5d-4951-9173-7cc21bd9682e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_d454a556-70ce-4c4c-8e13-114edfa03642/17_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_BOSC_d454a556-70ce-4c4c-8e13-114edfa03642_ZIP_','2022-02-11 16:04:48','2022-02-11 17:04:34','17_w1_o1_mandibule_scan_file_0.zip','2022-02-11 17:04:48','SYNCED','cb2e0202-0d5d-4951-9173-7cc21bd9682e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.17.1.1.2\",\"modelMatrix\":\"-0.981109,-0.182585,0.0639297,0,0.193454,-0.925989,0.324223,0,-2.83491e-09,0.330465,0.943818,0,24.0114,15.3472,-21.0981,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'cb713ac5-47f0-4c19-8363-a05f83d578d5','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/scan_f2bad12a-451d-406d-98b0-e431a37951dd/19_w1_o1_mandibule_scan_file_2.zip','ZIP','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_BOSC_f2bad12a-451d-406d-98b0-e431a37951dd_ZIP_','2022-03-08 10:48:39','2022-03-08 11:48:32','19_w1_o1_mandibule_scan_file_2.zip','2022-03-08 11:48:39','SYNCED','e3a545cc-fe2a-418f-9896-979b09c1f684',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.1.4\",\"modelMatrix\":\"-0.995468,-0.0869673,0.0384796,0,0.0951,-0.910339,0.402789,0,-2.6027e-09,0.404623,0.914484,0,25.5805,-21.2012,-23.2982,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'cb795e35-e3c3-4871-a194-cf67dc3a59ab','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/452a5200-3e06-4b74-8949-6abc7f2dda8a/session_3e95d626-668f-45f7-98ad-be2cf9d7b90b/occlusion_bce8310f-eee9-4f0a-a6b7-d592dec66be5/scan_49ae59fe-0bc4-4d86-b65e-d8788e2d12fb/26_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_452a5200-3e06-4b74-8949-6abc7f2dda8a_ACT_3e95d626-668f-45f7-98ad-be2cf9d7b90b_SESS_bce8310f-eee9-4f0a-a6b7-d592dec66be5_TOSC_49ae59fe-0bc4-4d86-b65e-d8788e2d12fb_SNAPS_','2022-05-24 09:24:36','2022-05-24 11:24:23','26_w1_o1_maxillaire_snapshot_0.png','2022-05-24 11:24:36','SYNCED','cb795e35-e3c3-4871-a194-cf67dc3a59ab',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.26.1.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'cb8d985b-abcc-47a0-9497-f7b41c5f0684','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_af1a113d-a181-4a3b-8ed8-44cff2f8fe53/24_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_LESC_af1a113d-a181-4a3b-8ed8-44cff2f8fe53_SNAPS_','2022-05-24 14:48:50','2022-05-24 16:48:42','24_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-05-24 16:48:50','SYNCED','cb8d985b-abcc-47a0-9497-f7b41c5f0684',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.24.1.1.4\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'cc51205b-8cc1-4d24-b9f1-09be34ecbe0c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/scan_2d226451-8adb-4007-be22-99a9b3af61d6/23_w1_o1_maxillaire_mlmeta_0_0.bin','LIFIM','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_TOSC_2d226451-8adb-4007-be22-99a9b3af61d6_LIFIM_','2022-05-25 08:32:44','2022-05-25 10:32:43','23_w1_o1_maxillaire_mlmeta_0_0.bin','2022-05-25 10:32:44','SYNCED','cc51205b-8cc1-4d24-b9f1-09be34ecbe0c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.23.1.1.1 Ligne de finition 0\",\"name\":\"Ligne de finition 0\",\"title\":\"Maxillaire LIFI_META\",\"toothNumber\":0,\"versionMarginLine\":1}'),(1001,'cda44172-1c1b-499f-9a5e-b73801de16de','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/computedocclusion_0d180e89-cc7f-4718-abf6-79b3ada7fd3c/4_w1_o2_snapshot_occ_file_0.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_OCC_0d180e89-cc7f-4718-abf6-79b3ada7fd3c_SNAPO__SNAPS_','2022-02-15 12:49:57','2022-02-15 13:49:40','4_w1_o2_snapshot_occ_file_0.png','2022-02-15 13:49:57','SYNCED','cda44172-1c1b-499f-9a5e-b73801de16de',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'cdac836c-5511-4e89-9ff7-910b974cff97','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/computedocclusion_704a0750-2a24-448f-8f30-928139977895/4_w1_o2_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_OCC_704a0750-2a24-448f-8f30-928139977895_TOPLY__ZIP_','2022-03-08 11:49:51','2022-03-08 12:49:34','4_w1_o2_maxillaire_occlusion_occ_file_0.zip','2022-03-08 12:49:51','SYNCED','cdac836c-5511-4e89-9ff7-910b974cff97',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.4.1.2.1 Occlusion 4\",\"modelMatrix\":\"-0.408152,0.902703,-0.13616,0,-0.912914,-0.403587,0.0608755,0,-1.7183e-09,0.149149,0.988815,0,3.7011,-24.744,-22.2405,1\",\"referenceScanID\":\"1.4.1.2.1\",\"title\":\"Maxillaire 1.4.1.2.1 Occlusion 4\"}'),(1001,'cdd9fdce-3676-419e-aab1-ed095f43e2bf','','SNAPS','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_c9079d19-8ffb-46f7-a51e-3a7a90ccae59_SESS_8ba0f3b1-408f-4a02-92a0-63f09123b68e_TOSC_cf1df2e4-52f9-48a2-8e0b-54a1e4ed5741_SNAPS_','2022-01-28 17:15:46','2022-01-26 15:40:38','','2022-01-28 18:15:46','SYNCED','cdd9fdce-3676-419e-aab1-ed095f43e2bf',0,'2022-01-28 18:15:46','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.10.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'ce37bace-32a2-4867-bd40-7b2deca8ec01','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_b28164eb-0070-4968-83be-bfabe1a0c839/13_w1_o1_mandibule_scan_file_7.zip','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_b28164eb-0070-4968-83be-bfabe1a0c839_ZIP_','2022-02-04 17:58:04','2022-02-04 17:11:51','13_w1_o1_mandibule_scan_file_7.zip','2022-02-04 18:58:04','SYNCED','d8a3bf39-16d1-435f-bafa-6c625f77d811',7,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.5\",\"modelMatrix\":\"-0.996857,-0.0768567,0.0192233,0,0.0792243,-0.967066,0.241882,0,1.71456e-9,0.242644,0.970115,0,23.7843,9.22152,-23.0024,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'ce384823-5411-4f27-874a-402787fad1e0','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7f47fd88-9ea0-4c08-9193-a54d4f158c7c/session_7873a396-419c-4215-83c7-fec9f2742ccf/occlusion_2e287bb0-e19a-414a-9177-23b335d286d9/computedocclusion_389a085b-21e0-4004-9d53-dfcb5c4bd2f1/16_w1_o2_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_7f47fd88-9ea0-4c08-9193-a54d4f158c7c_ACT_7873a396-419c-4215-83c7-fec9f2742ccf_SESS_2e287bb0-e19a-414a-9177-23b335d286d9_OCC_389a085b-21e0-4004-9d53-dfcb5c4bd2f1_TOPLY__ZIP_','2022-06-03 09:04:32','2022-06-03 11:04:23','16_w1_o2_maxillaire_occlusion_occ_file_0.zip','2022-06-03 11:04:32','SYNCED','ce384823-5411-4f27-874a-402787fad1e0',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.16.1.2.1 Occlusion 1\",\"modelMatrix\":\"-0.655868,0.747425,-0.105795,0,-0.754875,-0.649395,0.091919,0,-1.02677e-10,0.140149,0.99013,0,13.4773,-13.0045,-20.4999,1\",\"referenceScanID\":\"1.16.1.2.1\",\"title\":\"Maxillaire 1.16.1.2.1 Occlusion 1\"}'),(1001,'ce57e268-ef29-46a3-8c8b-42e7b9867106','','ZIP','PATIENT_de078619-3946-4adb-a799-1c260e16face_ACT_24d0aeb5-3058-4070-aeea-97c289e41e3c_SESS_ea6da896-1504-41fc-890c-7c48575e9e40_BOSC_00feff25-f8bf-405a-9778-d3fd08af5e37_ZIP_','2022-01-19 17:01:43','2022-01-19 15:19:16','','2022-01-19 18:01:43','SYNCED','ce57e268-ef29-46a3-8c8b-42e7b9867106',0,'2022-01-19 18:01:43','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.2.1.1.1\",\"modelMatrix\":\"-0.919032,0.392158,-0.0398959,0,-0.394182,-0.914313,0.093017,0,3.80829e-10,0.101212,0.994865,0,34.0249,-9.71726,-17.7856,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'ce602140-9361-4b52-8aa0-d906e30db451','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/scan_255c9e68-7cd6-413d-ba72-261666fdb488/19_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_BOSC_255c9e68-7cd6-413d-ba72-261666fdb488_SNAPS_','2022-03-08 10:56:17','2022-03-08 11:56:12','19_w1_o1_mandibule_snapshot_0.png','2022-03-08 11:56:17','SYNCED','ce602140-9361-4b52-8aa0-d906e30db451',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.1.6\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'cf28ba53-4f59-441d-8649-019294a3d1f4','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_e6c95ef7-636d-4c88-8d02-e2d9840573db/13_w1_o1_mandibule_scan_file_6.zip','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_e6c95ef7-636d-4c88-8d02-e2d9840573db_ZIP_','2022-01-27 16:41:46','2022-01-27 17:41:11','13_w1_o1_mandibule_scan_file_6.zip','2022-01-27 17:41:46','SYNCED','bcef8d3e-9632-4976-8cda-4c6f3ac50e99',6,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.1\",\"modelMatrix\":\"-0.988558,-0.14507,0.041326,0,0.150841,-0.950734,0.270835,0,9.21839e-10,0.27397,0.961738,0,25.2533,13.1486,-19.6942,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'cf2af2f0-fabb-4db7-9894-96d4f5cb4949','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/scan_7b00996b-90f8-4307-9a8c-263a28f1b341/4_w1_o4_maxillaire_scan_file_1.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_TOSC_7b00996b-90f8-4307-9a8c-263a28f1b341_ZIP_','2022-05-31 11:53:49','2022-05-31 13:53:38','4_w1_o4_maxillaire_scan_file_1.zip','2022-05-31 13:53:49','SYNCED','c1ee6f0c-823c-43ab-892b-aa2b9c60a5d0',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.4.1.4.1\",\"modelMatrix\":\"-0.981474,0.187393,-0.0399121,0,-0.191597,-0.959942,0.204454,0,1.75282e-09,0.208313,0.978062,0,21.6899,-19.6828,-18.7441,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'cf34344a-9be8-4726-893c-bb841db45a19','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_aa38e68a-4c1f-4e58-a176-2a4d533c35a0/24_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_LESC_aa38e68a-4c1f-4e58-a176-2a4d533c35a0_ZIP_','2022-05-13 16:15:35','2022-05-13 18:15:33','24_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-05-13 18:15:35','SYNCED','cf34344a-9be8-4726-893c-bb841db45a19',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.24.1.1.2\",\"modelMatrix\":\"0.792987,0.149859,-0.592819,0,-0.322886,0.925453,-0.206041,0,0.51664,0.348069,0.77858,0,-5.39761,-12.4459,-28.9289,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'cf705a27-0c7e-4999-a798-b56fcbd9f1e8','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/986374de-c4d7-4d6f-bf0c-2dc7e3b859a9/session_c81670ed-4144-4347-b19e-8057d11b5f7c/occlusion_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be/computedocclusion_7a5acfd0-87ca-4009-aa4e-677a88ceffde/28_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_986374de-c4d7-4d6f-bf0c-2dc7e3b859a9_ACT_c81670ed-4144-4347-b19e-8057d11b5f7c_SESS_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be_OCC_7a5acfd0-87ca-4009-aa4e-677a88ceffde_TOMA__MATRX_','2022-05-31 10:54:13','2022-05-31 12:53:55','28_w1_o1_maxillaire_matrix_occ_file_0.m','2022-05-31 12:54:13','SYNCED','cf705a27-0c7e-4999-a798-b56fcbd9f1e8',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.28.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.28.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.28.1.1.1 Occlusion 1\"}'),(2,'cf7bb88c-36b1-423a-963f-5fce81e44618','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a4b302c-278d-4e12-ace5-f095ba0bf856/session_6206892a-2e7e-4765-ac90-b49bfb465997/occlusion_3c30231c-7cd7-4431-985b-2eaf7f6925ae/scan_232c4a5c-d521-4972-9735-eb9d27cffedc/3_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_232c4a5c-d521-4972-9735-eb9d27cffedc_SNAPS_','2022-09-06 09:17:51','2022-08-30 10:43:18','3_w1_o1_maxillaire_snapshot_0.png','2022-09-06 11:17:51','SYNCED','cf7bb88c-36b1-423a-963f-5fce81e44618',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.3.1.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'cf8af902-82bc-44c4-8020-f0d36027bad0','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/scan_03839278-13f8-46e6-9581-ba11bc8bcb81/1_w1_o1_mandibule_scan_file_5.zip','ZIP','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_TOSC_03839278-13f8-46e6-9581-ba11bc8bcb81_ZIP_','2022-01-19 13:03:02','2022-01-19 11:35:09','1_w1_o1_mandibule_scan_file_5.zip','2022-01-19 14:03:02','SYNCED','96dd75bb-5035-460a-8afc-04f3755604b1',5,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.1.1.1.1\",\"modelMatrix\":\"-0.154277,0.952805,-0.261459,0,-0.988028,-0.148777,0.0408259,0,-2.59672e-9,0.264627,0.964351,0,-14.8611,-36.6101,-15.3158,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'d016dd8f-7e15-4fba-be82-5afa7a6f7562','','MATRX','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_OCC_764b8e22-8600-49e3-8d7c-d619725096ee_TOMA__MATRX_','2022-02-04 18:20:41','2022-02-04 19:19:48','',NULL,'CREATED','d016dd8f-7e15-4fba-be82-5afa7a6f7562',0,'2022-02-04 19:20:41','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.13.1.1.3 Occlusion 2\",\"referenceScanID\":\"1.13.1.1.3\",\"title\":\"Matrice Transfo. Maxillaire 1.13.1.1.3 Occlusion 2\"}'),(1001,'d0704949-1c54-410f-91db-b75d19a7c07a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/scan_9937f6fe-f500-4cc5-acd7-39dadc5ac2e7/22_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_TOSC_9937f6fe-f500-4cc5-acd7-39dadc5ac2e7_ZIP_','2022-04-21 11:00:56','2022-04-21 13:00:44','22_w1_o1_maxillaire_scan_file_0.zip','2022-04-21 13:00:56','SYNCED','d0704949-1c54-410f-91db-b75d19a7c07a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.22.1.1.1\",\"modelMatrix\":\"0.527598,0.839702,-0.128611,0,-0.849494,0.521516,-0.0798764,0,4.31898e-09,0.151397,0.988473,0,-4.53893,-22.22,-19.046,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'d0f522c1-5bc5-4263-89db-2be029063e53','','SNAPS','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_LESC_ecfd300a-08c2-4c42-a0d5-5dbf17a8210e_SNAPS_','2022-09-09 16:30:30','2022-09-09 18:16:24','','2022-09-09 18:30:30','SYNCED','d0f522c1-5bc5-4263-89db-2be029063e53',0,'2022-09-09 18:30:30','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.39.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'d12c0ffb-4772-4e5a-b8b0-1ff50ef71b30','','MATRX','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_fa1c1f6f-5c0d-45ca-8646-2a1ca68f51b4_BOMA__MATRX_','2022-05-16 17:51:11','2022-05-16 19:50:25','','2022-05-16 19:51:11','SYNCED','d12c0ffb-4772-4e5a-b8b0-1ff50ef71b30',0,'2022-05-16 19:51:11','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.24.1.1.1 Occlusion 6\",\"referenceScanID\":\"1.24.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.24.1.1.1 Occlusion 6\"}'),(1001,'d18a8fe2-fdcc-4d59-9de5-e651eb735d68','','MATRX','PATIENT_593972a6-d7d6-4802-b87d-38aab371f71e_ACT_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480_SESS_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3_OCC_4e1258a6-b789-451f-bfe8-8b395e1129d8_BOMA__MATRX_','2022-01-19 15:25:10','2022-01-19 16:24:43','',NULL,'CREATED','d18a8fe2-fdcc-4d59-9de5-e651eb735d68',0,'2022-01-19 16:25:10','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.3.1.1.1 Occlusion 3\",\"referenceScanID\":\"1.3.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.3.1.1.1 Occlusion 3\"}'),(2,'d2031406-88f1-4afa-a6e6-f33d22e6da2d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a4b302c-278d-4e12-ace5-f095ba0bf856/session_6206892a-2e7e-4765-ac90-b49bfb465997/occlusion_7ec70f78-dc80-40c5-b293-570a59f034c4/scan_dda8845a-2340-4d1a-8749-46d59887f64f/3_w1_o2_maxillaire_snapshot_0.png','SNAPS','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_7ec70f78-dc80-40c5-b293-570a59f034c4_TOSC_dda8845a-2340-4d1a-8749-46d59887f64f_SNAPS_','2022-09-06 09:17:45','2022-08-30 14:34:15','3_w1_o2_maxillaire_snapshot_0.png','2022-09-06 11:17:45','SYNCED','d2031406-88f1-4afa-a6e6-f33d22e6da2d',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.3.1.2.6\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'d240ab40-d14e-490e-b3b7-2c5295c6f83e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/occlusion_e08bbeeb-a30b-428c-bd4a-40198f792219/scan_dee5ca38-e252-41d1-86ca-aebc66ae36fa/25_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_SESS_e08bbeeb-a30b-428c-bd4a-40198f792219_TOSC_dee5ca38-e252-41d1-86ca-aebc66ae36fa_ZIP_','2022-05-17 16:33:19','2022-05-17 18:33:04','25_w1_o1_maxillaire_scan_file_0.zip','2022-05-17 18:33:19','SYNCED','d240ab40-d14e-490e-b3b7-2c5295c6f83e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.25.1.1.1\",\"modelMatrix\":\"0.892396,0.448703,-0.0479148,0,-0.451254,0.887351,-0.0947558,0,-1.45319e-09,0.106181,0.994347,0,6.57466,12.2314,-24.8702,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'d3ff533f-e540-46c8-8f68-b5341a94ad72','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_16f04a07-72e8-4a39-9b55-3ae7405733af/24_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_TOSC_16f04a07-72e8-4a39-9b55-3ae7405733af_ZIP_','2022-06-13 14:33:19','2022-06-13 16:33:04','24_w1_o1_maxillaire_scan_file_0.zip','2022-06-13 16:33:19','SYNCED','d3ff533f-e540-46c8-8f68-b5341a94ad72',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.4\",\"modelMatrix\":\"0.46942,0.845395,-0.254855,0,-0.882975,0.449442,-0.13549,0,8.41154e-09,0.288633,0.95744,0,-15.4576,-5.63133,-18.7255,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'d4530f2d-4f10-430c-8ae0-1b4e6f985d7b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_55f73d72-8321-42ec-88c8-d2988eeca0de/24_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_TOSC_55f73d72-8321-42ec-88c8-d2988eeca0de_SNAPS_','2022-05-13 13:58:49','2022-05-13 15:58:34','24_w1_o1_maxillaire_snapshot_0.png','2022-05-13 15:58:49','SYNCED','d4530f2d-4f10-430c-8ae0-1b4e6f985d7b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'d46bebca-c6ac-4423-92df-028395ab51da','','SNAPS','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_LESC_0e74383c-84a7-4c1f-b833-adf54ce6a402_SNAPS_','2022-09-10 08:18:26','2022-09-10 10:17:21','','2022-09-10 10:18:26','SYNCED','d46bebca-c6ac-4423-92df-028395ab51da',0,'2022-09-10 10:18:26','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.39.1.1.11\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'d4eb1177-3f71-4e20-b508-c25c3b720e0a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/computedocclusion_0d180e89-cc7f-4718-abf6-79b3ada7fd3c/4_w1_o2_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_OCC_0d180e89-cc7f-4718-abf6-79b3ada7fd3c_BOMA__MATRX_','2022-02-15 12:49:56','2022-02-15 13:49:40','4_w1_o2_mandibule_matrix_occ_file_0.m','2022-02-15 13:49:56','SYNCED','d4eb1177-3f71-4e20-b508-c25c3b720e0a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.4.1.2.2 Occlusion 3\",\"referenceScanID\":\"1.4.1.2.2\",\"title\":\"Matrice Transfo. Mandibule 1.4.1.2.2 Occlusion 3\"}'),(1001,'d4f0f735-c864-4a41-923a-5884d5da5ed5','','SNAPS','PATIENT_f9d03016-567a-4bd4-9cc5-dafeea34e365_ACT_a7bcb190-dd19-4f3b-8aab-266030bf4064_SESS_c321e210-b67c-40e8-bece-f8946164a768_LESC_25580af0-adbb-452a-8a44-6d9b1ca92471_SNAPS_','2022-07-04 14:10:45','2022-07-04 16:07:51','','2022-07-04 16:10:45','SYNCED','d4f0f735-c864-4a41-923a-5884d5da5ed5',0,'2022-07-04 16:10:45','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.36.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'d52266e7-9cf0-4ebf-8e8d-e471f317d0d3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_cfcda3c3-749c-4f3d-96e2-556ed558ceef/18_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_TOSC_cfcda3c3-749c-4f3d-96e2-556ed558ceef_ZIP_','2022-03-07 14:08:22','2022-03-07 15:08:06','18_w1_o1_maxillaire_scan_file_1.zip','2022-03-07 15:08:22','SYNCED','73c9cb73-3a98-4256-bc80-f01b135239bd',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.18.1.1.2\",\"modelMatrix\":\"-0.979743,-0.199678,0.0152522,0,0.20026,-0.976897,0.0746194,0,-1.52856e-10,0.0761623,0.997095,0,19.5629,-11.4708,-22.5064,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'d52438e1-2ecc-430e-99a2-d453d1778813','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/computedocclusion_e15a2d21-e8f2-4d2a-9a68-13d92ae4b997/13_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_OCC_e15a2d21-e8f2-4d2a-9a68-13d92ae4b997_TOPLY__ZIP_','2022-02-04 18:25:04','2022-02-04 19:23:45','13_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-02-04 19:25:04','SYNCED','d52438e1-2ecc-430e-99a2-d453d1778813',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.13.1.1.3 Occlusion 3\",\"modelMatrix\":\"0.754335,0.643596,-0.129474,0,-0.65649,0.739519,-0.148771,0,2.61688e-9,0.197222,0.980359,0,-9.25272,-30.1421,-17.7968,1\",\"referenceScanID\":\"1.13.1.1.3\",\"title\":\"Maxillaire 1.13.1.1.3 Occlusion 3\"}'),(1001,'d5774106-94dd-468b-b9eb-326b0cdd5bd8','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/scan_2d226451-8adb-4007-be22-99a9b3af61d6/23_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_TOSC_2d226451-8adb-4007-be22-99a9b3af61d6_SNAPS_','2022-05-13 10:06:29','2022-05-13 12:01:50','23_w1_o1_maxillaire_snapshot_0.png','2022-05-13 12:06:29','SYNCED','d5774106-94dd-468b-b9eb-326b0cdd5bd8',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.23.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'d59b9781-4075-49ae-8117-20a857071cad','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/8fc74d9e-a5a0-46bf-be3f-500548a130ad/session_5368829e-7dec-4775-a487-a1019f9604f4/order_91905e13-c34d-4643-94cb-a4d176eeb530/14_w1_couronne_prost_file_d59b9781-4075-49ae-8117-20a857071cad_0.pdf','PDF','PATIENT_8fc74d9e-a5a0-46bf-be3f-500548a130ad_ACT_5368829e-7dec-4775-a487-a1019f9604f4_PROST_91905e13-c34d-4643-94cb-a4d176eeb530_PDF_','2022-02-02 10:00:43','2022-02-02 11:00:41','14_w1_couronne_prost_file_d59b9781-4075-49ae-8117-20a857071cad_0.pdf','2022-02-02 11:00:43','SYNCED','d59b9781-4075-49ae-8117-20a857071cad',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.14.1.1 onlay 25 26\",\"title\":\"Couronne PDF\"}'),(1001,'d5c6e1ec-fe92-4f0f-a0a5-fcbce5f6d6eb','','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_ea89007b-3846-43ef-92f9-d5c7aa1a7dfa_TOPLY__ZIP_','2022-05-25 08:56:32','2022-05-13 18:35:18','','2022-05-25 10:56:32','SYNCED','d5c6e1ec-fe92-4f0f-a0a5-fcbce5f6d6eb',0,'2022-05-25 10:56:32','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.2 Occlusion 5\",\"modelMatrix\":\"-0.80453,0.576793,-0.141569,0,-0.593912,-0.781339,0.191773,0,-6.05286e-09,0.238367,0.971175,0,0.910551,-5.61768,-25.9513,1\",\"referenceScanID\":\"1.24.1.1.2\",\"title\":\"Maxillaire 1.24.1.1.2 Occlusion 5\"}'),(1001,'d65946b7-e2c1-4224-a955-3c0d6e3dd7be','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_0b63813c-7fbe-455b-a5e3-483908522ff0/4_w1_o2_mandibule_scan_file_0.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_BOSC_0b63813c-7fbe-455b-a5e3-483908522ff0_ZIP_','2022-02-15 12:48:20','2022-02-15 13:48:12','4_w1_o2_mandibule_scan_file_0.zip','2022-02-15 13:48:20','SYNCED','d65946b7-e2c1-4224-a955-3c0d6e3dd7be',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.2.2\",\"modelMatrix\":\"0.835361,0.540236,-0.10157,0,-0.549701,0.820977,-0.154353,0,-4.31854e-09,0.184774,0.982781,0,-13.6307,-23.1827,-19.2574,1\",\"title\":\"Mandibule ZIP\"}'),(2,'d672c49f-33f0-4b50-8c57-5a2a6d37856d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a4b302c-278d-4e12-ace5-f095ba0bf856/session_6206892a-2e7e-4765-ac90-b49bfb465997/occlusion_7ec70f78-dc80-40c5-b293-570a59f034c4/scan_b0d11b07-1362-4652-a13f-8f36c3c15cb1/3_w1_o2_maxillaire_snapshot_0.png','SNAPS','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_7ec70f78-dc80-40c5-b293-570a59f034c4_TOSC_b0d11b07-1362-4652-a13f-8f36c3c15cb1_SNAPS_','2022-09-06 09:17:58','2022-08-30 14:09:53','3_w1_o2_maxillaire_snapshot_0.png','2022-09-06 11:17:58','SYNCED','d672c49f-33f0-4b50-8c57-5a2a6d37856d',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.3.1.2.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'d6c60f40-e92e-4d3c-bc58-da059725bdd9','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/computedocclusion_8e4092a3-64a2-4464-addd-03b3c8ba2289/24_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_8e4092a3-64a2-4464-addd-03b3c8ba2289_TOMA__MATRX_','2022-05-13 16:21:26','2022-05-13 18:20:53','24_w1_o1_maxillaire_matrix_occ_file_0.m','2022-05-13 18:21:26','SYNCED','d6c60f40-e92e-4d3c-bc58-da059725bdd9',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.24.1.1.1 Occlusion 3\",\"referenceScanID\":\"1.24.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.24.1.1.1 Occlusion 3\"}'),(1001,'d6eeadf8-d732-4d5f-b7f0-294d6812442c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/order_266815a5-656b-4b9f-a6bf-817868764801/4_w1_guide_prost_file_d6eeadf8-d732-4d5f-b7f0-294d6812442c_0.pdf','PDF','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_PROST_266815a5-656b-4b9f-a6bf-817868764801_PDF_','2022-03-08 12:01:21','2022-03-08 13:01:20','4_w1_guide_prost_file_d6eeadf8-d732-4d5f-b7f0-294d6812442c_0.pdf','2022-03-08 13:01:21','SYNCED','d6eeadf8-d732-4d5f-b7f0-294d6812442c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.4.1.2 GUIDE\",\"title\":\"Guide PDF\"}'),(1001,'d7548f64-4e8b-4a78-96bb-e9b9eda1c14e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/computedocclusion_864c98a3-fcf7-466a-b999-13bd4dfb8c65/23_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_864c98a3-fcf7-466a-b999-13bd4dfb8c65_BOMA__MATRX_','2022-05-13 11:31:02','2022-05-13 13:30:43','23_w1_o1_mandibule_matrix_occ_file_0.m','2022-05-13 13:31:02','SYNCED','d7548f64-4e8b-4a78-96bb-e9b9eda1c14e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.23.1.1.1 Occlusion 3\",\"referenceScanID\":\"1.23.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.23.1.1.1 Occlusion 3\"}'),(1001,'d809f5d5-af2e-4333-bbfa-d7cdfd17091e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_cb7d52e7-16ce-470b-9b62-b1f627e9badc/18_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_RISC_cb7d52e7-16ce-470b-9b62-b1f627e9badc_SNAPS_','2022-03-07 14:33:35','2022-03-07 15:33:29','18_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-03-07 15:33:35','SYNCED','d809f5d5-af2e-4333-bbfa-d7cdfd17091e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.18.1.1.2\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'d867567d-31cf-44d7-aec4-159a77468723','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/scan_6f906ffa-4828-4d68-a894-572a056b896b/23_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_BOSC_6f906ffa-4828-4d68-a894-572a056b896b_ZIP_','2022-05-13 10:06:35','2022-05-13 12:06:28','23_w1_o1_mandibule_scan_file_0.zip','2022-05-13 12:06:35','SYNCED','d867567d-31cf-44d7-aec4-159a77468723',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.23.1.1.1\",\"modelMatrix\":\"0.99884,-0.00870968,0.0473501,0,0.0481445,0.180697,-0.98236,0,-1.26898e-10,0.9835,0.180907,0,0.872294,-19.7028,-3.24839,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'d881b47d-875f-42fd-b7ef-7e128912d6da','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/207d6dbc-c19b-4726-a9b3-16235ae554cc/session_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35/occlusion_dc5762a3-c453-4166-8c86-82d23ac9f8a6/computedocclusion_3a1fff1c-0427-409c-aa94-06326e554d82/27_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_207d6dbc-c19b-4726-a9b3-16235ae554cc_ACT_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35_SESS_dc5762a3-c453-4166-8c86-82d23ac9f8a6_OCC_3a1fff1c-0427-409c-aa94-06326e554d82_BOPLY__ZIP_','2022-05-30 11:09:30','2022-05-30 13:09:22','27_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-05-30 13:09:30','SYNCED','d881b47d-875f-42fd-b7ef-7e128912d6da',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.27.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.402641,0.884115,-0.23711,0,-0.915358,0.388898,-0.104298,0,-5.87371e-09,0.259036,0.965868,0,-10.1109,-5.75691,-20.9854,1\",\"referenceScanID\":\"1.27.1.1.1\",\"title\":\"Mandibule 1.27.1.1.1 Occlusion 1\"}'),(1001,'d8a3bf39-16d1-435f-bafa-6c625f77d811','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_b28164eb-0070-4968-83be-bfabe1a0c839/13_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_b28164eb-0070-4968-83be-bfabe1a0c839_ZIP_','2022-02-04 17:55:33','2022-02-04 16:57:50','13_w1_o1_mandibule_scan_file_0.zip','2022-02-04 18:55:33','SYNCED','d8a3bf39-16d1-435f-bafa-6c625f77d811',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.5\",\"modelMatrix\":\"-0.999116,-0.0392827,0.0149893,0,0.0420454,-0.933468,0.356187,0,-3.66865e-10,0.356503,0.934294,0,26.1512,5.7893,-22.5637,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'d8df268d-a27d-4d7b-9535-b65ee5b23682','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/57c4096f-98dd-49c8-bea5-a5b109ad3fd0/session_4f62e395-5623-4d5b-869c-1b2fc4d22b00/occlusion_1ac20dc7-b36b-4786-a05f-37091554dc5c/scan_1808e07b-25f9-4fb8-a923-34263a3c0386/31_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_57c4096f-98dd-49c8-bea5-a5b109ad3fd0_ACT_4f62e395-5623-4d5b-869c-1b2fc4d22b00_SESS_1ac20dc7-b36b-4786-a05f-37091554dc5c_RISC_1808e07b-25f9-4fb8-a923-34263a3c0386_SNAPS_','2022-06-16 11:03:37','2022-06-16 13:03:29','31_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-06-16 13:03:37','SYNCED','d8df268d-a27d-4d7b-9535-b65ee5b23682',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.31.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'d92cc933-7fc1-49b7-bc24-9bc4fe7931d7','','SNAPS','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_BOSC_3379235c-b42d-440c-84bc-d105a1d56127_SNAPS_','2022-03-09 07:54:47','2022-03-08 11:29:35','','2022-03-09 08:54:47','SYNCED','a6c18f23-3ae1-43e9-9a43-453be1c719a4',1,'2022-03-09 08:54:47','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'d9756905-f7f3-4ccf-ac0a-b8ee5c610fae','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/452a5200-3e06-4b74-8949-6abc7f2dda8a/session_3e95d626-668f-45f7-98ad-be2cf9d7b90b/occlusion_bce8310f-eee9-4f0a-a6b7-d592dec66be5/computedocclusion_7a922eb8-5139-40fe-8402-fc7ff4204a1a/26_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_452a5200-3e06-4b74-8949-6abc7f2dda8a_ACT_3e95d626-668f-45f7-98ad-be2cf9d7b90b_SESS_bce8310f-eee9-4f0a-a6b7-d592dec66be5_OCC_7a922eb8-5139-40fe-8402-fc7ff4204a1a_TOMA__MATRX_','2022-05-24 09:42:29','2022-05-24 11:42:09','26_w1_o1_maxillaire_matrix_occ_file_0.m','2022-05-24 11:42:29','SYNCED','d9756905-f7f3-4ccf-ac0a-b8ee5c610fae',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.26.1.1.2 Occlusion 1\",\"referenceScanID\":\"1.26.1.1.2\",\"title\":\"Matrice Transfo. Maxillaire 1.26.1.1.2 Occlusion 1\"}'),(1001,'d99083d3-0458-4b08-b79b-37595b0f769a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/scan_3743c984-7cdf-4a7a-bb8e-522e16ccb6e4/4_w1_o4_mordu_anterieur_scan_file_0.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_FRSC_3743c984-7cdf-4a7a-bb8e-522e16ccb6e4_ZIP_','2022-05-31 12:16:25','2022-05-31 14:16:17','4_w1_o4_mordu_anterieur_scan_file_0.zip','2022-05-31 14:16:25','SYNCED','d99083d3-0458-4b08-b79b-37595b0f769a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.4.1.4.2\",\"modelMatrix\":\"0.959139,-0.025927,-0.295322,0,-0.0956606,0.853045,-0.450374,0,0.269015,0.526962,0.845525,0,-1.74844,-19.2863,-24.404,1\",\"title\":\"Mordu anterieur ZIP\"}'),(1001,'d9ccfdbd-b935-4d26-9547-64ca54d80a2a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_2a7068fc-0efa-496f-ade9-aba5b0650655/12_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_2a7068fc-0efa-496f-ade9-aba5b0650655_SNAPS_','2022-02-04 11:56:18','2022-02-04 12:52:01','12_w1_o1_mandibule_snapshot_1.png','2022-02-04 12:56:18','SYNCED','7636e0d7-f242-431c-90a5-a65399d83ecd',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.5\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'da0f3442-c969-43de-950f-994ea320e2af','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/computedocclusion_00405f86-eefa-41f9-8d98-1fa9cbeef855/24_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_00405f86-eefa-41f9-8d98-1fa9cbeef855_TOMA__MATRX_','2022-05-25 09:03:41','2022-05-25 11:02:54','24_w1_o1_maxillaire_matrix_occ_file_0.m','2022-05-25 11:03:41','SYNCED','da0f3442-c969-43de-950f-994ea320e2af',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.24.1.1.3 Occlusion 4\",\"referenceScanID\":\"1.24.1.1.3\",\"title\":\"Matrice Transfo. Maxillaire 1.24.1.1.3 Occlusion 4\"}'),(1001,'da479b14-8eb4-4b25-8d5c-8c1663f2377b','','ZIP','PATIENT_a0c21836-ba79-4f15-9e35-02ef8211a9e5_ACT_0aac522d-3c38-465a-a1e0-014166c140ac_SESS_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042_RISC_1181b7d1-03e3-4847-bb73-0b48192e787c_ZIP_','2022-01-24 14:24:09','2022-01-21 13:00:20','','2022-01-24 15:24:09','SYNCED','da479b14-8eb4-4b25-8d5c-8c1663f2377b',0,'2022-01-24 15:24:09','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.7.1.1.1\",\"modelMatrix\":\"0.99999,-0.00511797,-0.00400404,0,-0.00485811,0.997898,0.0690524,0,0.0157011,-0.0656307,0.997676,0,13.9568,-1.10289,-20.5501,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'da905553-c6cb-4dc1-befd-c4d3bbb3d305','','MATRX','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_812fdd67-c9dc-4e0c-806a-0524a386b296_TOMA__MATRX_','2022-02-07 17:55:14','2022-02-07 18:54:30','',NULL,'CREATED','da905553-c6cb-4dc1-befd-c4d3bbb3d305',0,'2022-02-07 18:55:14','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.17.1.1.1 Occlusion 5\",\"referenceScanID\":\"1.17.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.17.1.1.1 Occlusion 5\"}'),(1001,'daf36a55-092f-478c-8a46-2b915ba5c4e3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/fa7fa96b-f393-4b9a-8198-144702462cfa/session_4bed076c-8541-4a2f-800a-5aeb4cb49de5/occlusion_16b82fca-4b65-4866-af87-1f6dbb42f5dc/scan_77280faa-6fb3-46f5-aa9e-fd5dd96b1535/35_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_fa7fa96b-f393-4b9a-8198-144702462cfa_ACT_4bed076c-8541-4a2f-800a-5aeb4cb49de5_SESS_16b82fca-4b65-4866-af87-1f6dbb42f5dc_TOSC_77280faa-6fb3-46f5-aa9e-fd5dd96b1535_SNAPS_','2022-06-28 15:01:18','2022-06-28 17:01:08','35_w1_o1_maxillaire_snapshot_0.png','2022-06-28 17:01:18','SYNCED','daf36a55-092f-478c-8a46-2b915ba5c4e3',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.35.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'db47d7c0-1482-49e9-84d8-430c31d68234','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/occlusion_e08bbeeb-a30b-428c-bd4a-40198f792219/scan_dee5ca38-e252-41d1-86ca-aebc66ae36fa/25_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_SESS_e08bbeeb-a30b-428c-bd4a-40198f792219_TOSC_dee5ca38-e252-41d1-86ca-aebc66ae36fa_SNAPS_','2022-05-17 16:34:51','2022-05-17 18:34:38','25_w1_o1_maxillaire_snapshot_1.png','2022-05-17 18:34:51','SYNCED','c0e2418d-8a03-4c3c-bc34-614d663c5fce',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.25.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'db484565-ee6f-4ebd-803a-ec8279d42cae','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_be8c90b6-055f-49b1-a5b6-cb782162d6cd/12_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_be8c90b6-055f-49b1-a5b6-cb782162d6cd_ZIP_','2022-02-04 12:32:21','2022-02-04 13:32:07','12_w1_o1_mandibule_scan_file_0.zip','2022-02-04 13:32:21','SYNCED','db484565-ee6f-4ebd-803a-ec8279d42cae',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.6\",\"modelMatrix\":\"0.950781,0.051843,0.305497,0,0.309865,-0.159074,-0.937379,0,-2.94009e-9,0.985905,-0.167308,0,-9.86712,-6.42496,-8.29468,1\",\"title\":\"Mandibule ZIP\"}'),(2,'dba08370-8684-42ca-8134-3b0149e3dccf','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a4b302c-278d-4e12-ace5-f095ba0bf856/session_6206892a-2e7e-4765-ac90-b49bfb465997/occlusion_7ec70f78-dc80-40c5-b293-570a59f034c4/scan_1075d1a0-1218-4048-a7c7-3aa9195b6f63/3_w1_o2_maxillaire_snapshot_0.png','SNAPS','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_7ec70f78-dc80-40c5-b293-570a59f034c4_TOSC_1075d1a0-1218-4048-a7c7-3aa9195b6f63_SNAPS_','2022-09-06 09:17:44','2022-08-30 14:28:40','3_w1_o2_maxillaire_snapshot_0.png','2022-09-06 11:17:44','SYNCED','dba08370-8684-42ca-8134-3b0149e3dccf',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.3.1.2.5\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'dbce789f-4cb2-4aef-aadf-d1bd30518bf6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/computedocclusion_42098ceb-3335-4f13-8aed-b29c37a5f57f/22_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_OCC_42098ceb-3335-4f13-8aed-b29c37a5f57f_SNAPO__SNAPS_','2022-04-21 11:29:06','2022-04-21 13:28:43','22_w1_o1_snapshot_occ_file_0.png','2022-04-21 13:29:06','SYNCED','dbce789f-4cb2-4aef-aadf-d1bd30518bf6',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'dbe67734-a656-4fa1-9d9c-579eb51a0bfd','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_71fd8305-087d-4c31-82c4-b83df7b3cc9a/4_w1_o2_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_RISC_71fd8305-087d-4c31-82c4-b83df7b3cc9a_ZIP_','2022-02-15 12:34:19','2022-02-15 13:34:13','4_w1_o2_mordu_posterieur_droit_scan_file_0.zip','2022-02-15 13:34:19','SYNCED','dbe67734-a656-4fa1-9d9c-579eb51a0bfd',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.4.1.2.1\",\"modelMatrix\":\"0.927872,-0.363784,-0.131913,0,0.34038,0.931216,-0.0727533,0,0.153214,0.028977,0.988638,0,-2.32644,-3.44317,-20.511,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(2,'dc09b93c-433c-4421-8b5d-3b83a4e73447','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a4b302c-278d-4e12-ace5-f095ba0bf856/session_6206892a-2e7e-4765-ac90-b49bfb465997/occlusion_7ec70f78-dc80-40c5-b293-570a59f034c4/scan_9ad9c2d5-a3f4-4d4d-a153-085fbf878be4/3_w1_o2_maxillaire_snapshot_0.png','SNAPS','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_7ec70f78-dc80-40c5-b293-570a59f034c4_TOSC_9ad9c2d5-a3f4-4d4d-a153-085fbf878be4_SNAPS_','2022-09-06 09:17:44','2022-08-30 14:24:49','3_w1_o2_maxillaire_snapshot_0.png','2022-09-06 11:17:44','SYNCED','dc09b93c-433c-4421-8b5d-3b83a4e73447',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.3.1.2.4\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'dc3fc819-a2b8-40e7-8072-0b7df70c932c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/e922efb9-8c03-445b-8a0f-449e3c43bdca/session_a2369349-1629-40ad-8784-d271bc3fbade/occlusion_292cc1aa-8b12-463b-87a1-7d9731cf886b/scan_500ef012-99d0-4604-93eb-ec789b5a245b/21_w1_o1_mordu_anterieur_scan_file_0.zip','ZIP','PATIENT_e922efb9-8c03-445b-8a0f-449e3c43bdca_ACT_a2369349-1629-40ad-8784-d271bc3fbade_SESS_292cc1aa-8b12-463b-87a1-7d9731cf886b_FRSC_500ef012-99d0-4604-93eb-ec789b5a245b_ZIP_','2022-04-21 08:49:51','2022-04-21 10:49:43','21_w1_o1_mordu_anterieur_scan_file_0.zip','2022-04-21 10:49:51','SYNCED','dc3fc819-a2b8-40e7-8072-0b7df70c932c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.21.1.1.1\",\"modelMatrix\":\"0.956454,0.0964215,0.281781,0,-0.0611791,0.99284,-0.0643537,0,-0.28551,0.0827021,0.958261,0,-0.70725,-2.21229,-23.8633,1\",\"title\":\"Mordu anterieur ZIP\"}'),(1001,'dc9ff3aa-6f6e-4469-b0a8-dcc249bfa4b4','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/c8418992-7324-4a11-9437-bf2bb0fa802f/session_ff05cb1f-6c46-4287-9cdd-81bf817a9c78/occlusion_f6f084bb-a5f1-4f39-860f-1483132c8283/scan_9263fb3c-bf3a-443f-8c9b-4d12244b4612/11_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_c8418992-7324-4a11-9437-bf2bb0fa802f_ACT_ff05cb1f-6c46-4287-9cdd-81bf817a9c78_SESS_f6f084bb-a5f1-4f39-860f-1483132c8283_TOSC_9263fb3c-bf3a-443f-8c9b-4d12244b4612_ZIP_','2022-01-25 15:45:56','2022-01-25 16:45:28','11_w1_o1_maxillaire_scan_file_1.zip','2022-01-25 16:45:56','SYNCED','1a099ce4-e506-42cd-880e-d56cf533b172',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.11.1.1.1\",\"modelMatrix\":\"-0.535894,0.83667,-0.113142,0,-0.844285,-0.531061,0.0718151,0,2.58505e-9,0.13401,0.99098,0,3.70979,-28.5186,-19.5102,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'dd789540-0fcc-444a-9272-95de333c1dd9','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/d100e894-0be9-4495-94e2-e469232f7817/session_2c8b85b5-c805-4b08-85e7-3d02dab72e99/occlusion_8a278cc5-a1c1-4dfb-9ee2-c971a6309afa/scan_aa48ecdd-c861-41de-8796-655dc3852c64/15_w1_o1_mordu_anterieur_scan_file_0.zip','ZIP','PATIENT_d100e894-0be9-4495-94e2-e469232f7817_ACT_2c8b85b5-c805-4b08-85e7-3d02dab72e99_SESS_8a278cc5-a1c1-4dfb-9ee2-c971a6309afa_FRSC_aa48ecdd-c861-41de-8796-655dc3852c64_ZIP_','2022-02-01 15:12:43','2022-02-01 16:12:36','15_w1_o1_mordu_anterieur_scan_file_0.zip','2022-02-01 16:12:43','SYNCED','dd789540-0fcc-444a-9272-95de333c1dd9',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.15.1.1.1\",\"modelMatrix\":\"0.941284,-0.141459,0.281826,0,0.145833,0.988213,-0.0183938,0,-0.306179,0.0589622,0.9598,0,-5.75767,2.45549,-20.0875,1\",\"title\":\"Mordu anterieur ZIP\"}'),(1001,'dda447e6-f5c6-4d58-af39-96132c12f6d4','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7f47fd88-9ea0-4c08-9193-a54d4f158c7c/session_7873a396-419c-4215-83c7-fec9f2742ccf/order_dd5621a5-4a8d-4ed9-acd5-6ff2b3da2096/16_w1_inlay_onlay_prost_file_dda447e6-f5c6-4d58-af39-96132c12f6d4_0.pdf','PDF','PATIENT_7f47fd88-9ea0-4c08-9193-a54d4f158c7c_ACT_7873a396-419c-4215-83c7-fec9f2742ccf_PROST_dd5621a5-4a8d-4ed9-acd5-6ff2b3da2096_PDF_','2022-06-16 15:39:33','2022-06-16 17:39:32','16_w1_inlay_onlay_prost_file_dda447e6-f5c6-4d58-af39-96132c12f6d4_0.pdf','2022-06-16 17:39:33','SYNCED','dda447e6-f5c6-4d58-af39-96132c12f6d4',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.16.1.2 Guillaume F2119/ONLAY14\",\"title\":\"Inlay/Onlay PDF\"}'),(1001,'ddea4642-9cf7-46ce-879d-961adf88d1f1','','MATRX','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_OCC_778ed9fd-f658-471d-9dd0-a48417419cba_BOMA__MATRX_','2022-05-12 12:32:06','2022-05-12 14:31:43','',NULL,'CREATED','ddea4642-9cf7-46ce-879d-961adf88d1f1',0,'2022-05-12 14:32:06','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.18.1.1.3 Occlusion 3\",\"referenceScanID\":\"1.18.1.1.3\",\"title\":\"Matrice Transfo. Mandibule 1.18.1.1.3 Occlusion 3\"}'),(1001,'de16ceab-33c6-440e-95f8-cbf86f8b10f1','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f9d03016-567a-4bd4-9cc5-dafeea34e365/session_a7bcb190-dd19-4f3b-8aab-266030bf4064/order_a98ace82-a988-47b9-9761-135ff04f54dd/36_w1_couronne_prost_file_de16ceab-33c6-440e-95f8-cbf86f8b10f1_0.pdf','PDF','PATIENT_f9d03016-567a-4bd4-9cc5-dafeea34e365_ACT_a7bcb190-dd19-4f3b-8aab-266030bf4064_PROST_a98ace82-a988-47b9-9761-135ff04f54dd_PDF_','2022-07-06 10:07:00','2022-07-06 12:06:59','36_w1_couronne_prost_file_de16ceab-33c6-440e-95f8-cbf86f8b10f1_0.pdf','2022-07-06 12:07:00','SYNCED','de16ceab-33c6-440e-95f8-cbf86f8b10f1',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.36.1.1 COURONNE HUGUETTE \",\"title\":\"Couronne PDF\"}'),(1001,'de17d2ed-be8c-4861-ab71-d479e3295ec5','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_b28164eb-0070-4968-83be-bfabe1a0c839/13_w1_o1_mandibule_scan_file_5.zip','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_b28164eb-0070-4968-83be-bfabe1a0c839_ZIP_','2022-02-04 17:57:22','2022-02-04 17:07:08','13_w1_o1_mandibule_scan_file_5.zip','2022-02-04 18:57:22','SYNCED','d8a3bf39-16d1-435f-bafa-6c625f77d811',5,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.5\",\"modelMatrix\":\"-0.999849,-0.0166313,0.00499618,0,0.0173655,-0.957574,0.287663,0,1.82324e-10,0.287707,0.957719,0,26.6518,7.14728,-23.0855,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'de18656c-8aaf-4dbb-a9ae-7bc48a2a6966','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/45ff7437-0691-4427-a7da-8250862e4b96/session_4ff9c682-c09d-42ff-8c29-aeb13e066ed2/occlusion_934673c1-a4b9-4508-ac1b-a03092a0693e/scan_da7dbb1d-043a-4c99-abde-d5ee77a3f819/9_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_45ff7437-0691-4427-a7da-8250862e4b96_ACT_4ff9c682-c09d-42ff-8c29-aeb13e066ed2_SESS_934673c1-a4b9-4508-ac1b-a03092a0693e_BOSC_da7dbb1d-043a-4c99-abde-d5ee77a3f819_ZIP_','2022-01-24 17:39:01','2022-01-24 18:38:35','9_w1_o1_mandibule_scan_file_0.zip','2022-01-24 18:39:01','SYNCED','de18656c-8aaf-4dbb-a9ae-7bc48a2a6966',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.9.1.1.1\",\"modelMatrix\":\"0.992217,-0.124118,0.00997001,0,0.124517,0.989032,-0.079446,0,2.73202e-10,0.0800691,0.996789,0,-25.6457,11.0526,-18.0123,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'deb5c89e-8f61-4c11-8184-606b8bdfaead','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_b28164eb-0070-4968-83be-bfabe1a0c839/13_w1_o1_mandibule_snapshot_3.png','SNAPS','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_b28164eb-0070-4968-83be-bfabe1a0c839_SNAPS_','2022-02-04 17:55:12','2022-02-04 17:11:48','13_w1_o1_mandibule_snapshot_3.png','2022-02-04 18:55:12','SYNCED','189a792c-fafa-4b60-958f-637d69400a83',3,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.5\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'deec4260-bb72-4bb5-b75e-65b987c69607','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/order_d80c4bf9-81ae-42b5-9ee1-61f21899ac9b/1_w1_inlay_onlay_prost_file_deec4260-bb72-4bb5-b75e-65b987c69607_0.pdf','PDF','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_PROST_d80c4bf9-81ae-42b5-9ee1-61f21899ac9b_PDF_','2022-01-19 13:51:13','2022-01-19 14:51:10','1_w1_inlay_onlay_prost_file_deec4260-bb72-4bb5-b75e-65b987c69607_0.pdf','2022-01-19 14:51:13','SYNCED','deec4260-bb72-4bb5-b75e-65b987c69607',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.1.1.1 INLAY ONLAY/ couronne\",\"title\":\"Inlay/Onlay PDF\"}'),(1001,'def2bf42-b3c1-466e-907c-cde40a0d406c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/scan_48982add-ff93-4e3a-a453-012a73678b39/19_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_TOSC_48982add-ff93-4e3a-a453-012a73678b39_ZIP_','2022-03-08 11:05:35','2022-03-08 12:05:22','19_w1_o1_maxillaire_scan_file_0.zip','2022-03-08 12:05:35','SYNCED','def2bf42-b3c1-466e-907c-cde40a0d406c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.19.1.1.1\",\"modelMatrix\":\"0.644651,-0.755898,0.11421,0,0.764477,0.637416,-0.0963085,0,6.32177e-09,0.149396,0.988777,0,-27.7951,21.8029,-23.7098,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'df157da1-7180-4164-8854-16b7d65b8e8d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/fa7fa96b-f393-4b9a-8198-144702462cfa/session_4bed076c-8541-4a2f-800a-5aeb4cb49de5/occlusion_16b82fca-4b65-4866-af87-1f6dbb42f5dc/scan_378056ed-259b-4069-96b1-1e6050e30f87/35_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_fa7fa96b-f393-4b9a-8198-144702462cfa_ACT_4bed076c-8541-4a2f-800a-5aeb4cb49de5_SESS_16b82fca-4b65-4866-af87-1f6dbb42f5dc_BOSC_378056ed-259b-4069-96b1-1e6050e30f87_SNAPS_','2022-06-28 14:57:35','2022-06-28 16:57:25','35_w1_o1_mandibule_snapshot_0.png','2022-06-28 16:57:35','SYNCED','df157da1-7180-4164-8854-16b7d65b8e8d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.35.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'df493b46-f498-46f5-862e-735db106fc71','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_2ffbfbca-f236-4802-be93-8eb43d523274/scan_eb904683-acc6-4e6d-8900-3982d403ba0f/4_w1_o1_mordu_anterieur_scan_file_0.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_2ffbfbca-f236-4802-be93-8eb43d523274_FRSC_eb904683-acc6-4e6d-8900-3982d403ba0f_ZIP_','2022-01-19 19:12:05','2022-01-19 20:11:50','4_w1_o1_mordu_anterieur_scan_file_0.zip','2022-01-19 20:12:05','SYNCED','df493b46-f498-46f5-862e-735db106fc71',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.4.1.1.1\",\"modelMatrix\":\"0.944627,-0.24972,0.217541,0,0.222196,0.967769,0.0883816,0,-0.242001,-0.0350135,0.972099,0,3.97072,-5.9587,-20.8635,1\",\"title\":\"Mordu anterieur ZIP\"}'),(1001,'df9355a9-ac0b-4315-85d3-727de19b8f4d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/207d6dbc-c19b-4726-a9b3-16235ae554cc/session_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35/occlusion_dc5762a3-c453-4166-8c86-82d23ac9f8a6/scan_5139ec2e-4608-4b67-b0d1-bc4dc3498038/27_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_207d6dbc-c19b-4726-a9b3-16235ae554cc_ACT_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35_SESS_dc5762a3-c453-4166-8c86-82d23ac9f8a6_BOSC_5139ec2e-4608-4b67-b0d1-bc4dc3498038_ZIP_','2022-05-30 11:02:22','2022-05-30 13:02:14','27_w1_o1_mandibule_scan_file_0.zip','2022-05-30 13:02:22','SYNCED','df9355a9-ac0b-4315-85d3-727de19b8f4d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.27.1.1.1\",\"modelMatrix\":\"-0.232956,0.962775,-0.137095,0,-0.972487,-0.23063,0.0328406,0,-2.55098e-10,0.140973,0.990013,0,-8.13445,-9.00778,-20.6942,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'e02dab35-c969-4a35-9860-2ecdcbced07a','','ZIP','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_OCC_87edc123-163f-46ce-be5c-45f2ff80b857_TOPLY__ZIP_','2022-05-12 12:27:26','2022-05-12 14:26:51','','2022-05-12 14:27:26','SYNCED','e02dab35-c969-4a35-9860-2ecdcbced07a',0,'2022-05-12 14:27:26','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.18.1.1.2 Occlusion 3\",\"modelMatrix\":\"-0.979743,-0.199678,0.0152522,0,0.20026,-0.976897,0.0746194,0,-1.52856e-10,0.0761623,0.997095,0,19.5629,-11.4708,-22.5064,1\",\"referenceScanID\":\"1.18.1.1.2\",\"title\":\"Maxillaire 1.18.1.1.2 Occlusion 3\"}'),(1001,'e04ce307-e72f-48f8-94a9-561f6c850f27','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/1c189ddc-0ee7-45e7-9d80-585dac08374a/session_01bd0635-6ec6-42cb-8561-8638bded352c/occlusion_2aa712ca-8b46-4a50-a03e-1c6a6a0c40fc/computedocclusion_727485e0-8637-4024-83d8-95544991f73f/29_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_1c189ddc-0ee7-45e7-9d80-585dac08374a_ACT_01bd0635-6ec6-42cb-8561-8638bded352c_SESS_2aa712ca-8b46-4a50-a03e-1c6a6a0c40fc_OCC_727485e0-8637-4024-83d8-95544991f73f_BOMA__MATRX_','2022-06-03 14:07:17','2022-06-03 16:07:00','29_w1_o1_mandibule_matrix_occ_file_0.m','2022-06-03 16:07:17','SYNCED','e04ce307-e72f-48f8-94a9-561f6c850f27',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.29.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.29.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.29.1.1.1 Occlusion 1\"}'),(1001,'e0ac4499-ea33-48d1-9fad-0a2fbc44beba','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7f47fd88-9ea0-4c08-9193-a54d4f158c7c/session_7873a396-419c-4215-83c7-fec9f2742ccf/occlusion_2e287bb0-e19a-414a-9177-23b335d286d9/scan_817e3173-ed5b-4bb7-93d5-bc02ec7eb79b/16_w1_o2_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_7f47fd88-9ea0-4c08-9193-a54d4f158c7c_ACT_7873a396-419c-4215-83c7-fec9f2742ccf_SESS_2e287bb0-e19a-414a-9177-23b335d286d9_RISC_817e3173-ed5b-4bb7-93d5-bc02ec7eb79b_SNAPS_','2022-06-03 09:04:19','2022-06-03 11:04:11','16_w1_o2_mordu_posterieur_droit_snapshot_0.png','2022-06-03 11:04:19','SYNCED','e0ac4499-ea33-48d1-9fad-0a2fbc44beba',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.16.1.2.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'e0de7869-99e5-443d-82a1-4896f3f8ef65','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_cfcda3c3-749c-4f3d-96e2-556ed558ceef/18_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_TOSC_cfcda3c3-749c-4f3d-96e2-556ed558ceef_SNAPS_','2022-03-07 14:12:04','2022-03-07 15:08:05','18_w1_o1_maxillaire_snapshot_1.png','2022-03-07 15:12:04','SYNCED','3dbf1334-fddd-48c1-8621-612a8780a8c5',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.18.1.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'e1289326-b1ea-4553-9c00-4b0b82338aa1','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_499bf817-e96f-4ff6-ae84-c5c2ccc847c2/17_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_FRSC_499bf817-e96f-4ff6-ae84-c5c2ccc847c2_SNAPS_','2022-02-07 11:47:26','2022-02-07 12:45:17','17_w1_o1_mordu_anterieur_snapshot_0.png','2022-02-07 12:47:26','SYNCED','e1289326-b1ea-4553-9c00-4b0b82338aa1',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.17.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'e1592d2a-cc52-41a2-a723-3212141cd2e6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/computedocclusion_864c98a3-fcf7-466a-b999-13bd4dfb8c65/23_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_864c98a3-fcf7-466a-b999-13bd4dfb8c65_TOMA__MATRX_','2022-05-13 11:31:02','2022-05-13 13:30:43','23_w1_o1_maxillaire_matrix_occ_file_0.m','2022-05-13 13:31:02','SYNCED','e1592d2a-cc52-41a2-a723-3212141cd2e6',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.23.1.1.1 Occlusion 3\",\"referenceScanID\":\"1.23.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.23.1.1.1 Occlusion 3\"}'),(1001,'e22b8e38-4ab3-40db-9c15-e6e24035c607','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/computedocclusion_7c70edbe-5cb4-4244-8baf-7caf2bd7d86b/12_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_OCC_7c70edbe-5cb4-4244-8baf-7caf2bd7d86b_TOMA__MATRX_','2022-02-04 17:59:48','2022-02-04 18:58:48','12_w1_o1_maxillaire_matrix_occ_file_0.m','2022-02-04 18:59:48','SYNCED','e22b8e38-4ab3-40db-9c15-e6e24035c607',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.12.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.12.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.12.1.1.1 Occlusion 1\"}'),(1001,'e2588ba3-68eb-4df3-8fcd-8b3a080fab73','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/computedocclusion_35af1bf5-285a-4bb1-a6db-fe9897defe51/23_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_35af1bf5-285a-4bb1-a6db-fe9897defe51_TOPLY__ZIP_','2022-05-13 12:11:23','2022-05-13 14:11:07','23_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-05-13 14:11:23','SYNCED','e2588ba3-68eb-4df3-8fcd-8b3a080fab73',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.23.1.1.1 Occlusion 4\",\"modelMatrix\":\"-0.996412,0.0371381,-0.0760535,0,-0.0846367,-0.43722,0.895363,0,9.59179e-10,0.898588,0.438794,0,-5.67604,-22.9357,-12.9416,1\",\"referenceScanID\":\"1.23.1.1.1\",\"title\":\"Maxillaire 1.23.1.1.1 Occlusion 4\"}'),(1001,'e30915c7-f064-425e-b6bc-e8a0412091b9','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_1ecf6aa5-37ac-49b0-ab34-94916ad9415a/4_w1_o2_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_LESC_1ecf6aa5-37ac-49b0-ab34-94916ad9415a_SNAPS_','2022-02-15 12:37:05','2022-02-15 13:36:57','4_w1_o2_mordu_posterieur_gauche_snapshot_0.png','2022-02-15 13:37:05','SYNCED','e30915c7-f064-425e-b6bc-e8a0412091b9',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.4.1.2.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'e3298d8e-e934-45ad-9f9f-25cbd9ed8f2d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/8fc74d9e-a5a0-46bf-be3f-500548a130ad/session_5368829e-7dec-4775-a487-a1019f9604f4/occlusion_bb63a653-1b34-4d80-a4bf-7fda5c9b0360/scan_bb2387c3-c044-46d4-bfeb-b3572a68a3e5/14_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_8fc74d9e-a5a0-46bf-be3f-500548a130ad_ACT_5368829e-7dec-4775-a487-a1019f9604f4_SESS_bb63a653-1b34-4d80-a4bf-7fda5c9b0360_BOSC_bb2387c3-c044-46d4-bfeb-b3572a68a3e5_SNAPS_','2022-02-01 10:46:36','2022-02-01 11:46:23','14_w1_o1_mandibule_snapshot_0.png','2022-02-01 11:46:36','SYNCED','e3298d8e-e934-45ad-9f9f-25cbd9ed8f2d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.14.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'e3598e66-59db-43ac-a342-a835944e8fab','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_4f8dc275-857c-482a-9886-5521591e9661/scan_df08df19-150c-437d-8ed4-bf2826644265/12_w1_o4_mandibule_snapshot_0.png','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_BOSC_df08df19-150c-437d-8ed4-bf2826644265_SNAPS_','2022-02-18 16:11:36','2022-02-18 17:11:27','12_w1_o4_mandibule_snapshot_0.png','2022-02-18 17:11:36','SYNCED','e3598e66-59db-43ac-a342-a835944e8fab',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.4.5\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'e3662c2b-ff0a-4b1b-8904-eb0cb9732936','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/scan_03839278-13f8-46e6-9581-ba11bc8bcb81/1_w1_o1_maxillaire_scan_file_7.zip','ZIP','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_TOSC_03839278-13f8-46e6-9581-ba11bc8bcb81_ZIP_','2022-01-19 13:03:57','2022-01-19 11:37:49','1_w1_o1_maxillaire_scan_file_7.zip','2022-01-19 14:03:57','SYNCED','96dd75bb-5035-460a-8afc-04f3755604b1',7,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.1.1.1.1\",\"modelMatrix\":\"-0.154277,0.952805,-0.261459,0,-0.988028,-0.148777,0.0408259,0,-2.59672e-9,0.264627,0.964351,0,-14.8611,-36.6101,-15.3158,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'e370e7fc-2c4d-4157-8338-09cb2bc8808e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/45ff7437-0691-4427-a7da-8250862e4b96/session_4ff9c682-c09d-42ff-8c29-aeb13e066ed2/occlusion_934673c1-a4b9-4508-ac1b-a03092a0693e/scan_00f98bb4-dc6f-4a78-b9c8-5f04e23fc139/9_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_45ff7437-0691-4427-a7da-8250862e4b96_ACT_4ff9c682-c09d-42ff-8c29-aeb13e066ed2_SESS_934673c1-a4b9-4508-ac1b-a03092a0693e_TOSC_00f98bb4-dc6f-4a78-b9c8-5f04e23fc139_SNAPS_','2022-01-24 17:38:35','2022-01-24 18:31:08','9_w1_o1_maxillaire_snapshot_0.png','2022-01-24 18:38:35','SYNCED','e370e7fc-2c4d-4157-8338-09cb2bc8808e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.9.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'e397dd7a-680a-49f0-ae9c-da305f7e5100','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/69640c87-271c-4a44-a6fa-67b01654cc27/session_5f9199b0-eb37-4ed3-8d1a-6c38505d4913/occlusion_991beec3-fe9e-4c98-a3d4-c98e4a4c2471/scan_6d0af0d8-98cb-48b6-aac5-3e0e3c3d7e7e/39_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_LESC_6d0af0d8-98cb-48b6-aac5-3e0e3c3d7e7e_ZIP_','2022-09-09 16:43:33','2022-09-09 18:43:26','39_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-09-09 18:43:33','SYNCED','e397dd7a-680a-49f0-ae9c-da305f7e5100',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.39.1.1.8\",\"modelMatrix\":\"-0.98286,-0.111748,0.143629,0,0.115984,-0.99272,0.0299558,0,0.143363,0.0449676,0.989187,0,5.06254,-2.04729,-19.6633,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'e3a545cc-fe2a-418f-9896-979b09c1f684','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/scan_f2bad12a-451d-406d-98b0-e431a37951dd/19_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_BOSC_f2bad12a-451d-406d-98b0-e431a37951dd_ZIP_','2022-03-08 10:38:42','2022-03-08 11:38:35','19_w1_o1_mandibule_scan_file_0.zip','2022-03-08 11:38:42','SYNCED','e3a545cc-fe2a-418f-9896-979b09c1f684',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.1.4\",\"modelMatrix\":\"-0.998204,0.0548186,-0.0241604,0,-0.0599066,-0.913424,0.402576,0,3.78577e-11,0.403301,0.915068,0,24.2056,-25.5191,-20.9382,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'e3ec894f-b87e-41a7-b76c-a7ed37c918eb','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/scan_a45e609a-ed7e-4f9d-a646-fcf505dd8590/22_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_RISC_a45e609a-ed7e-4f9d-a646-fcf505dd8590_ZIP_','2022-04-21 11:27:47','2022-04-21 13:27:39','22_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-04-21 13:27:47','SYNCED','e3ec894f-b87e-41a7-b76c-a7ed37c918eb',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.22.1.1.5\",\"modelMatrix\":\"0.993424,0.111096,0.0132563,0,-0.112903,0.993332,-0.0341294,0,-0.0193022,0.0309379,0.999333,0,-1.85407,1.90754,-17.5678,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'e3efe4e9-eeb8-40e0-acd8-86a52c7eb0ee','','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_aa16f8ea-198d-4240-ab78-5a1f54823f0c_SNAPO__SNAPS_','2022-05-16 17:48:36','2022-05-16 19:47:59','','2022-05-16 19:48:36','SYNCED','e3efe4e9-eeb8-40e0-acd8-86a52c7eb0ee',0,'2022-05-16 19:48:36','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'e40bcb5c-3738-4edb-9feb-03ede717d70b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/computedocclusion_35af1bf5-285a-4bb1-a6db-fe9897defe51/23_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_35af1bf5-285a-4bb1-a6db-fe9897defe51_BOMA__MATRX_','2022-05-13 12:11:24','2022-05-13 14:11:07','23_w1_o1_mandibule_matrix_occ_file_0.m','2022-05-13 14:11:24','SYNCED','e40bcb5c-3738-4edb-9feb-03ede717d70b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.23.1.1.1 Occlusion 4\",\"referenceScanID\":\"1.23.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.23.1.1.1 Occlusion 4\"}'),(1001,'e4232ec2-aa4d-453c-8af0-16f147580e79','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_77ec818f-d778-4945-9458-90665b5522ba/17_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_TOSC_77ec818f-d778-4945-9458-90665b5522ba_SNAPS_','2022-02-07 11:26:08','2022-02-07 12:23:51','17_w1_o1_maxillaire_snapshot_0.png','2022-02-07 12:26:08','SYNCED','e4232ec2-aa4d-453c-8af0-16f147580e79',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.17.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'e42442e0-81f6-430a-8b42-ea2bed13deea','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_b7947fff-2f4c-4016-bc7a-372a7c0dd0c6/4_w1_o2_mordu_anterieur_scan_file_0.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_FRSC_b7947fff-2f4c-4016-bc7a-372a7c0dd0c6_ZIP_','2022-02-15 12:39:04','2022-02-15 13:38:55','4_w1_o2_mordu_anterieur_scan_file_0.zip','2022-02-15 13:39:04','SYNCED','e42442e0-81f6-430a-8b42-ea2bed13deea',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.4.1.2.1\",\"modelMatrix\":\"0.970361,-0.225256,0.096734,0,0.204859,0.961856,0.161888,0,-0.128203,-0.156483,0.982256,0,-1.65524,4.31298,-18.4482,1\",\"title\":\"Mordu anterieur ZIP\"}'),(1001,'e44617c6-4aa4-43e0-84e8-4f0b2a0a8c5c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/de078619-3946-4adb-a799-1c260e16face/session_24d0aeb5-3058-4070-aeea-97c289e41e3c/occlusion_ea6da896-1504-41fc-890c-7c48575e9e40/computedocclusion_a15a6719-2996-4256-93d7-515e4d4f5bef/2_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_de078619-3946-4adb-a799-1c260e16face_ACT_24d0aeb5-3058-4070-aeea-97c289e41e3c_SESS_ea6da896-1504-41fc-890c-7c48575e9e40_OCC_a15a6719-2996-4256-93d7-515e4d4f5bef_BOMA__MATRX_','2022-01-19 14:47:20','2022-01-19 15:46:49','2_w1_o1_mandibule_matrix_occ_file_0.m','2022-01-19 15:47:20','SYNCED','e44617c6-4aa4-43e0-84e8-4f0b2a0a8c5c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.2.1.1.3 Occlusion 1\",\"referenceScanID\":\"1.2.1.1.3\",\"title\":\"Matrice Transfo. Mandibule 1.2.1.1.3 Occlusion 1\"}'),(1001,'e4853159-e478-4689-9445-7fa9525bde25','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_992e34fe-b7bb-45b7-a2c6-794c8211aba7/18_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_LESC_992e34fe-b7bb-45b7-a2c6-794c8211aba7_ZIP_','2022-05-10 14:04:37','2022-05-10 16:04:31','18_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-05-10 16:04:37','SYNCED','e4853159-e478-4689-9445-7fa9525bde25',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.18.1.1.2\",\"modelMatrix\":\"-0.999135,-0.0347651,-0.0295586,0,0.0306189,-0.992228,0.12593,0,-0.0285962,0.119602,0.991626,0,-0.722486,0.225612,-19.2577,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'e4bcc8ee-82bb-4e0a-851c-96cc266d0f0e','','MATRX','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_OCC_d8bec5dc-8405-473d-9ba5-ae6e461ed6fd_TOMA__MATRX_','2022-02-04 18:14:41','2022-02-04 19:13:44','',NULL,'CREATED','e4bcc8ee-82bb-4e0a-851c-96cc266d0f0e',0,'2022-02-04 19:14:41','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.13.1.1.3 Occlusion 1\",\"referenceScanID\":\"1.13.1.1.3\",\"title\":\"Matrice Transfo. Maxillaire 1.13.1.1.3 Occlusion 1\"}'),(1001,'e4d67437-8062-4193-9199-248b5fda7da6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/order_981d8297-b019-44ba-9c17-bd4a389d849e/23_w1_couronne_prost_file_e4d67437-8062-4193-9199-248b5fda7da6_0.pdf','PDF','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_PROST_981d8297-b019-44ba-9c17-bd4a389d849e_PDF_','2022-05-25 14:08:37','2022-05-25 16:08:34','23_w1_couronne_prost_file_e4d67437-8062-4193-9199-248b5fda7da6_0.pdf','2022-05-25 16:08:37','SYNCED','e4d67437-8062-4193-9199-248b5fda7da6',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.23.1.3 COURONNE\",\"title\":\"Couronne PDF\"}'),(1001,'e4e187e6-c079-4c36-a733-d1759629b786','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5/occlusion_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa/scan_e350f1fd-e88b-43c1-b1e6-a905c9a72ccf/24_w2_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5_SESS_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa_LESC_e350f1fd-e88b-43c1-b1e6-a905c9a72ccf_SNAPS_','2022-10-06 14:50:09','2022-10-06 16:49:56','24_w2_o1_mordu_posterieur_gauche_snapshot_0.png','2022-10-06 16:50:09','SYNCED','e4e187e6-c079-4c36-a733-d1759629b786',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.24.2.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'e536317a-fb9f-4f81-9857-b8e1097fa91e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/d100e894-0be9-4495-94e2-e469232f7817/session_2c8b85b5-c805-4b08-85e7-3d02dab72e99/occlusion_8a278cc5-a1c1-4dfb-9ee2-c971a6309afa/scan_aa48ecdd-c861-41de-8796-655dc3852c64/15_w1_o1_mordu_anterieur_scan_file_1.zip','ZIP','PATIENT_d100e894-0be9-4495-94e2-e469232f7817_ACT_2c8b85b5-c805-4b08-85e7-3d02dab72e99_SESS_8a278cc5-a1c1-4dfb-9ee2-c971a6309afa_FRSC_aa48ecdd-c861-41de-8796-655dc3852c64_ZIP_','2022-02-01 15:14:54','2022-02-01 16:14:46','15_w1_o1_mordu_anterieur_scan_file_1.zip','2022-02-01 16:14:54','SYNCED','dd789540-0fcc-444a-9272-95de333c1dd9',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.15.1.1.1\",\"modelMatrix\":\"0.873736,-0.19419,0.43295,0,0.194083,0.980319,0.0347743,0,-0.446341,0.0387479,0.901035,0,-1.75239,5.97219,-22.5035,1\",\"title\":\"Mordu anterieur ZIP\"}'),(1001,'e58f4dc9-d8b6-47d7-b69c-f152363ad6d6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/593972a6-d7d6-4802-b87d-38aab371f71e/session_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480/occlusion_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3/scan_ae54b48a-8f70-45c1-81cc-4ed8a6bc0e95/3_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_593972a6-d7d6-4802-b87d-38aab371f71e_ACT_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480_SESS_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3_LESC_ae54b48a-8f70-45c1-81cc-4ed8a6bc0e95_SNAPS_','2022-01-19 15:17:03','2022-01-19 16:16:52','3_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-01-19 16:17:03','SYNCED','e58f4dc9-d8b6-47d7-b69c-f152363ad6d6',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.3.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'e61e5643-077f-4631-9a52-30eee22319ec','','ZIP','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_OCC_778ed9fd-f658-471d-9dd0-a48417419cba_TOPLY__ZIP_','2022-05-12 12:32:06','2022-05-12 14:31:43','',NULL,'CREATED','e61e5643-077f-4631-9a52-30eee22319ec',0,'2022-05-12 14:32:06','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.18.1.1.2 Occlusion 3\",\"modelMatrix\":\"-0.979743,-0.199678,0.0152522,0,0.20026,-0.976897,0.0746194,0,-1.52856e-10,0.0761623,0.997095,0,19.5629,-11.4708,-22.5064,1\",\"referenceScanID\":\"1.18.1.1.2\",\"title\":\"Maxillaire 1.18.1.1.2 Occlusion 3\"}'),(1001,'e63b426b-22ba-46de-acad-83d77c91a3d9','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/32710234-804f-46f5-899d-eed636f8a906/session_64c1427a-b91d-4675-94df-f36bd40e9b0f/occlusion_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a/scan_50213132-9c82-471d-8981-66894edf36a4/33_w2_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_32710234-804f-46f5-899d-eed636f8a906_ACT_64c1427a-b91d-4675-94df-f36bd40e9b0f_SESS_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a_RISC_50213132-9c82-471d-8981-66894edf36a4_SNAPS_','2022-06-28 09:07:00','2022-06-28 11:06:49','33_w2_o1_mordu_posterieur_droit_snapshot_0.png','2022-06-28 11:07:00','SYNCED','e63b426b-22ba-46de-acad-83d77c91a3d9',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.33.2.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'e68ac351-cb78-4786-bf1a-30d6212ee9d2','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/order_e51223ad-68e7-4f67-bdfd-ba9a9e66f828/17_w1_inlay_onlay_prost_file_e68ac351-cb78-4786-bf1a-30d6212ee9d2_0.pdf','PDF','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_PROST_e51223ad-68e7-4f67-bdfd-ba9a9e66f828_PDF_','2022-02-07 18:11:31','2022-02-07 19:11:30','17_w1_inlay_onlay_prost_file_e68ac351-cb78-4786-bf1a-30d6212ee9d2_0.pdf','2022-02-07 19:11:31','SYNCED','e68ac351-cb78-4786-bf1a-30d6212ee9d2',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.17.1.1 INLAY ONLAY\",\"title\":\"Inlay/Onlay PDF\"}'),(1001,'e6abf173-fe8e-4a9f-8cfa-89df74594d41','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_44561518-16e3-45bd-af90-fefe4eca9d27/24_w1_o1_mordu_posterieur_droit_scan_file_1.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_LESC_44561518-16e3-45bd-af90-fefe4eca9d27_ZIP_','2022-06-14 11:57:25','2022-06-14 13:57:24','24_w1_o1_mordu_posterieur_droit_scan_file_1.zip','2022-06-14 13:57:25','SYNCED','8e3b2146-f0cf-465d-9fe3-fdbb0b0d4d1e',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.24.1.1.8\",\"modelMatrix\":\"0.998505,0.0288376,0.0356512,0,-0.0392148,0.994627,0.101591,0,-0.0393194,-0.099669,0.99422,0,9.20621,7.03609,-15.1186,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'e6df5905-90cd-4171-98df-82ec5234429c','','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_f9e18676-d6bb-44e8-b093-43cb88b0d897_TOPLY__ZIP_','2022-05-16 17:54:28','2022-05-16 19:53:29','','2022-05-16 19:54:28','SYNCED','e6df5905-90cd-4171-98df-82ec5234429c',0,'2022-05-16 19:54:28','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.2 Occlusion 6\",\"modelMatrix\":\"-0.80453,0.576793,-0.141569,0,-0.593912,-0.781339,0.191773,0,-6.05286e-09,0.238367,0.971175,0,0.910551,-5.61768,-25.9513,1\",\"referenceScanID\":\"1.24.1.1.2\",\"title\":\"Maxillaire 1.24.1.1.2 Occlusion 6\"}'),(1001,'e7c5902a-d085-4bd0-aec1-0e76eec8f7d6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/207d6dbc-c19b-4726-a9b3-16235ae554cc/session_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35/occlusion_dc5762a3-c453-4166-8c86-82d23ac9f8a6/scan_5139ec2e-4608-4b67-b0d1-bc4dc3498038/27_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_207d6dbc-c19b-4726-a9b3-16235ae554cc_ACT_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35_SESS_dc5762a3-c453-4166-8c86-82d23ac9f8a6_BOSC_5139ec2e-4608-4b67-b0d1-bc4dc3498038_ZIP_','2022-05-30 11:06:27','2022-05-30 13:06:20','27_w1_o1_mandibule_scan_file_1.zip','2022-05-30 13:06:27','SYNCED','df9355a9-ac0b-4315-85d3-727de19b8f4d',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.27.1.1.1\",\"modelMatrix\":\"0.402641,0.884115,-0.23711,0,-0.915358,0.388898,-0.104298,0,-5.87371e-09,0.259036,0.965868,0,-10.1109,-5.75691,-20.9854,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'e7ee6629-78a7-40cc-94c3-5a0026b3a530','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/computedocclusion_e9bfc750-6943-42bf-8c0b-b7e1dc1803c5/1_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_OCC_e9bfc750-6943-42bf-8c0b-b7e1dc1803c5_TOPLY__ZIP_','2022-01-19 13:04:29','2022-01-19 12:12:14','1_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-01-19 14:04:29','SYNCED','e7ee6629-78a7-40cc-94c3-5a0026b3a530',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.1.1.1.1 Occlusion 2\",\"referenceScanID\":\"1.1.1.1.1\",\"title\":\"Maxillaire 1.1.1.1.1 Occlusion 2\"}'),(1001,'e8450c51-4880-4af6-beea-c84d00047e07','','SNAPS','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_cb4cdc08-5d89-48dc-80a3-2e659c55f971_SNAPO__SNAPS_','2022-02-08 08:49:00','2022-02-07 18:52:17','','2022-02-08 09:49:00','SYNCED','e8450c51-4880-4af6-beea-c84d00047e07',0,'2022-02-08 09:49:00','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'e85f0e93-e68d-4b36-a493-4d8d0e78c389','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_b28164eb-0070-4968-83be-bfabe1a0c839/13_w1_o1_mandibule_scan_file_3.zip','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_b28164eb-0070-4968-83be-bfabe1a0c839_ZIP_','2022-02-04 17:56:42','2022-02-04 17:03:45','13_w1_o1_mandibule_scan_file_3.zip','2022-02-04 18:56:42','SYNCED','d8a3bf39-16d1-435f-bafa-6c625f77d811',3,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.5\",\"modelMatrix\":\"-0.980986,-0.182732,0.0653907,0,0.19408,-0.923628,0.33052,0,1.2429e-9,0.336927,0.941531,0,23.7056,9.64329,-24.5584,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'e8b27d4a-c73d-4aae-a076-b8e91ab6d2dc','','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_OCC_a525c976-46dd-42bc-abc1-c7cf71f9a1f1_SNAPO__SNAPS_','2022-02-07 11:15:31','2022-02-04 14:58:28','','2022-02-07 12:15:31','SYNCED','e8b27d4a-c73d-4aae-a076-b8e91ab6d2dc',0,'2022-02-07 12:15:31','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'e8ea88c0-a812-4c0a-a348-31d86458ae54','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_a9b96b88-7783-474e-b983-cddc79b7d3f5/4_w1_o2_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_RISC_a9b96b88-7783-474e-b983-cddc79b7d3f5_SNAPS_','2022-03-08 11:47:16','2022-03-08 12:47:08','4_w1_o2_mordu_posterieur_droit_snapshot_0.png','2022-03-08 12:47:16','SYNCED','e8ea88c0-a812-4c0a-a348-31d86458ae54',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.4.1.2.2\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'e96cd613-56e1-4c18-80c9-c4987032c9c0','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/207d6dbc-c19b-4726-a9b3-16235ae554cc/session_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35/order_9a96e3ab-0849-4183-8a9d-806264bf0357/27_w1_inlay_onlay_prost_file_e96cd613-56e1-4c18-80c9-c4987032c9c0_0.pdf','PDF','PATIENT_207d6dbc-c19b-4726-a9b3-16235ae554cc_ACT_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35_PROST_9a96e3ab-0849-4183-8a9d-806264bf0357_PDF_','2022-05-30 18:29:46','2022-05-30 20:29:44','27_w1_inlay_onlay_prost_file_e96cd613-56e1-4c18-80c9-c4987032c9c0_0.pdf','2022-05-30 20:29:46','SYNCED','e96cd613-56e1-4c18-80c9-c4987032c9c0',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.27.1.1 INLAY ONLAY\",\"title\":\"Inlay/Onlay PDF\"}'),(1001,'e979f187-4dd6-4438-8c70-f4b715113003','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/scan_03839278-13f8-46e6-9581-ba11bc8bcb81/1_w1_o1_maxillaire_scan_file_3.zip','ZIP','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_TOSC_03839278-13f8-46e6-9581-ba11bc8bcb81_ZIP_','2022-01-19 13:02:05','2022-01-19 11:24:51','1_w1_o1_maxillaire_scan_file_3.zip','2022-01-19 14:02:05','SYNCED','96dd75bb-5035-460a-8afc-04f3755604b1',3,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.1.1.1.1\",\"modelMatrix\":\"-0.182103,0.941427,-0.283822,0,-0.983279,-0.174352,0.0525636,0,6.31282e-11,0.288648,0.957435,0,-14.0793,-37.4463,-14.2584,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'e9920a50-f56c-4988-9358-0d2559e0924a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/593972a6-d7d6-4802-b87d-38aab371f71e/session_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480/occlusion_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3/scan_0bf938e8-3ff3-4e2d-981d-f2db30285d60/3_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_593972a6-d7d6-4802-b87d-38aab371f71e_ACT_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480_SESS_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3_TOSC_0bf938e8-3ff3-4e2d-981d-f2db30285d60_SNAPS_','2022-01-19 14:59:11','2022-01-19 15:58:38','3_w1_o1_maxillaire_snapshot_0.png','2022-01-19 15:59:11','SYNCED','e9920a50-f56c-4988-9358-0d2559e0924a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.3.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'e9a05c37-c44f-4221-9711-5a407611dea6','','SNAPS','PATIENT_593972a6-d7d6-4802-b87d-38aab371f71e_ACT_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480_SESS_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3_OCC_4e1258a6-b789-451f-bfe8-8b395e1129d8_SNAPO__SNAPS_','2022-01-19 15:25:10','2022-01-19 16:24:43','',NULL,'CREATED','e9a05c37-c44f-4221-9711-5a407611dea6',0,'2022-01-19 16:25:10','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'e9a23848-b5aa-446a-8434-7060c7e42649','','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_f9e18676-d6bb-44e8-b093-43cb88b0d897_BOPLY__ZIP_','2022-05-16 17:54:27','2022-05-16 19:53:29','','2022-05-16 19:54:27','SYNCED','e9a23848-b5aa-446a-8434-7060c7e42649',0,'2022-05-16 19:54:27','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.24.1.1.1 Occlusion 6\",\"modelMatrix\":\"0.852703,-0.521011,0.0380208,0,0.522396,0.850441,-0.062061,0,3.49638e-10,0.0727815,0.997348,0,-11.3911,-12.8136,-21.1334,1\",\"referenceScanID\":\"1.24.1.1.1\",\"title\":\"Mandibule 1.24.1.1.1 Occlusion 6\"}'),(2,'ea008e10-1582-49f9-b2b1-3c8c0920196f','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a4b302c-278d-4e12-ace5-f095ba0bf856/session_6206892a-2e7e-4765-ac90-b49bfb465997/occlusion_3c30231c-7cd7-4431-985b-2eaf7f6925ae/scan_f9a200bf-710b-4bad-a122-de56d5bc4da4/3_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_f9a200bf-710b-4bad-a122-de56d5bc4da4_SNAPS_','2022-09-06 09:17:46','2022-08-30 10:36:05','3_w1_o1_maxillaire_snapshot_0.png','2022-09-06 11:17:46','SYNCED','ea008e10-1582-49f9-b2b1-3c8c0920196f',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.3.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'ea19bf6b-5ad8-4dd5-adc3-dc2a465f9865','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/593972a6-d7d6-4802-b87d-38aab371f71e/session_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480/occlusion_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3/scan_20c281c1-af15-40ce-8892-18a2507513e3/3_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_593972a6-d7d6-4802-b87d-38aab371f71e_ACT_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480_SESS_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3_BOSC_20c281c1-af15-40ce-8892-18a2507513e3_SNAPS_','2022-01-19 15:09:22','2022-01-19 16:08:59','3_w1_o1_mandibule_snapshot_0.png','2022-01-19 16:09:22','SYNCED','ea19bf6b-5ad8-4dd5-adc3-dc2a465f9865',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.3.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'eab51643-8531-4bbc-802a-3636aa3154d7','','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_e2722784-a66c-4ece-91c0-2add756415ea_BOPLY__ZIP_','2022-05-13 16:32:18','2022-05-13 18:31:42','','2022-05-13 18:32:18','SYNCED','eab51643-8531-4bbc-802a-3636aa3154d7',0,'2022-05-13 18:32:18','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.24.1.1.1 Occlusion 5\",\"modelMatrix\":\"0.852703,-0.521011,0.0380208,0,0.522396,0.850441,-0.062061,0,3.49638e-10,0.0727815,0.997348,0,-11.3911,-12.8136,-21.1334,1\",\"referenceScanID\":\"1.24.1.1.1\",\"title\":\"Mandibule 1.24.1.1.1 Occlusion 5\"}'),(1001,'eb3ec761-7c19-432a-9f25-086fa12d2544','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/occlusion_a2220645-c79d-4dda-b6cc-772384a4106b/scan_0136d883-d517-448a-82a3-bfcdd5f4c35c/38_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_TOSC_0136d883-d517-448a-82a3-bfcdd5f4c35c_SNAPS_','2022-07-12 10:46:07','2022-07-12 12:45:57','38_w1_o1_maxillaire_snapshot_0.png','2022-07-12 12:46:07','SYNCED','eb3ec761-7c19-432a-9f25-086fa12d2544',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.38.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'eb6014ce-5d33-4a10-b35e-1f841cd09998','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/occlusion_e08bbeeb-a30b-428c-bd4a-40198f792219/scan_fba3c050-83af-4c2f-a411-0975c46179ac/25_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_SESS_e08bbeeb-a30b-428c-bd4a-40198f792219_LESC_fba3c050-83af-4c2f-a411-0975c46179ac_ZIP_','2022-05-17 16:40:17','2022-05-17 18:40:07','25_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-05-17 18:40:17','SYNCED','eb6014ce-5d33-4a10-b35e-1f841cd09998',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.25.1.1.1\",\"modelMatrix\":\"-0.925636,0.0344343,0.396784,0,0.0119039,-0.99138,0.131416,0,0.378859,0.126495,0.90871,0,-8.32311,-4.05601,-18.0214,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'eb698606-db72-4f5b-bb0b-c76c4e68784f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/32710234-804f-46f5-899d-eed636f8a906/session_64c1427a-b91d-4675-94df-f36bd40e9b0f/occlusion_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a/scan_3954e24e-9220-452b-a8fa-b1fbde6ebcad/33_w2_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_32710234-804f-46f5-899d-eed636f8a906_ACT_64c1427a-b91d-4675-94df-f36bd40e9b0f_SESS_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a_BOSC_3954e24e-9220-452b-a8fa-b1fbde6ebcad_ZIP_','2022-06-28 09:01:33','2022-06-28 11:01:24','33_w2_o1_mandibule_scan_file_1.zip','2022-06-28 11:01:33','SYNCED','f83e0257-49c2-409b-a1b0-0c5bb674c327',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.33.2.1.1\",\"modelMatrix\":\"-0.533445,0.844455,-0.0482858,0,-0.845835,-0.532575,0.0304525,0,-3.15807e-10,0.0570865,0.998369,0,-2.0165,-19.6501,-16.9464,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'ecb8a5ec-02b4-4daa-8826-d6aece5d4370','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f9d03016-567a-4bd4-9cc5-dafeea34e365/session_a7bcb190-dd19-4f3b-8aab-266030bf4064/occlusion_c321e210-b67c-40e8-bece-f8946164a768/scan_90f9c577-02d8-45f3-9ac5-6c6cfeef1fa2/36_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_f9d03016-567a-4bd4-9cc5-dafeea34e365_ACT_a7bcb190-dd19-4f3b-8aab-266030bf4064_SESS_c321e210-b67c-40e8-bece-f8946164a768_BOSC_90f9c577-02d8-45f3-9ac5-6c6cfeef1fa2_ZIP_','2022-07-04 13:58:40','2022-07-04 15:58:33','36_w1_o1_mandibule_scan_file_1.zip','2022-07-04 15:58:40','SYNCED','7eefa8d1-beb5-4db9-adf4-6f919d9dd7ee',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.36.1.1.1\",\"modelMatrix\":\"0.642095,-0.756672,0.12313,0,0.766625,0.633759,-0.103128,0,-2.36675e-09,0.160612,0.987018,0,-11.9604,2.52084,-21.6228,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'ed09c95c-b2a9-474b-91f8-8611eb396b93','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_7f58ef07-2de6-4bb2-982d-86ac2b5ae742/17_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_RISC_7f58ef07-2de6-4bb2-982d-86ac2b5ae742_ZIP_','2022-02-11 16:12:10','2022-02-11 17:12:03','17_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-02-11 17:12:10','SYNCED','ed09c95c-b2a9-474b-91f8-8611eb396b93',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.17.1.1.2\",\"modelMatrix\":\"0.957916,0.0181831,-0.285437,0,0.0542599,0.962852,0.267383,0,0.281945,-0.269525,0.920353,0,5.16715,11.3783,-23.6738,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'ed13abf3-a450-44e3-9d7c-cb0dad0e38e3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/scan_f2bad12a-451d-406d-98b0-e431a37951dd/19_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_BOSC_f2bad12a-451d-406d-98b0-e431a37951dd_SNAPS_','2022-03-08 10:43:45','2022-03-08 11:43:36','19_w1_o1_mandibule_snapshot_1.png','2022-03-08 11:43:45','SYNCED','8fb19261-9e70-4678-8a85-98e89dd98dcb',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.1.4\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'ed3a6299-1604-4ba4-8ce0-6c50eb2674e7','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/452a5200-3e06-4b74-8949-6abc7f2dda8a/session_3e95d626-668f-45f7-98ad-be2cf9d7b90b/occlusion_bce8310f-eee9-4f0a-a6b7-d592dec66be5/scan_49ae59fe-0bc4-4d86-b65e-d8788e2d12fb/26_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_452a5200-3e06-4b74-8949-6abc7f2dda8a_ACT_3e95d626-668f-45f7-98ad-be2cf9d7b90b_SESS_bce8310f-eee9-4f0a-a6b7-d592dec66be5_TOSC_49ae59fe-0bc4-4d86-b65e-d8788e2d12fb_ZIP_','2022-05-24 09:24:35','2022-05-24 11:24:25','26_w1_o1_maxillaire_scan_file_0.zip','2022-05-24 11:24:35','SYNCED','ed3a6299-1604-4ba4-8ce0-6c50eb2674e7',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.26.1.1.2\",\"modelMatrix\":\"-0.110794,0.979823,-0.166348,0,-0.993843,-0.109231,0.0185445,0,1.74782e-09,0.167378,0.985893,0,4.8554,-23.5105,-20.1597,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'ed62043e-efee-4d47-b4e6-8cd25a56d664','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/1c189ddc-0ee7-45e7-9d80-585dac08374a/session_01bd0635-6ec6-42cb-8561-8638bded352c/occlusion_2aa712ca-8b46-4a50-a03e-1c6a6a0c40fc/scan_1aa5441d-7ad8-4a5d-96d6-d07348ac58c4/29_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_1c189ddc-0ee7-45e7-9d80-585dac08374a_ACT_01bd0635-6ec6-42cb-8561-8638bded352c_SESS_2aa712ca-8b46-4a50-a03e-1c6a6a0c40fc_TOSC_1aa5441d-7ad8-4a5d-96d6-d07348ac58c4_ZIP_','2022-06-03 13:56:52','2022-06-03 15:56:42','29_w1_o1_maxillaire_scan_file_0.zip','2022-06-03 15:56:52','SYNCED','ed62043e-efee-4d47-b4e6-8cd25a56d664',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.29.1.1.1\",\"modelMatrix\":\"0.83472,0.522,-0.175383,0,-0.550675,0.791254,-0.265848,0,9.28981e-09,0.318487,0.947927,0,-14.455,-20.1962,-17.5787,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'ed676c0a-e5c3-450e-975d-f740a787e736','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7f47fd88-9ea0-4c08-9193-a54d4f158c7c/session_7873a396-419c-4215-83c7-fec9f2742ccf/occlusion_2e287bb0-e19a-414a-9177-23b335d286d9/computedocclusion_389a085b-21e0-4004-9d53-dfcb5c4bd2f1/16_w1_o2_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_7f47fd88-9ea0-4c08-9193-a54d4f158c7c_ACT_7873a396-419c-4215-83c7-fec9f2742ccf_SESS_2e287bb0-e19a-414a-9177-23b335d286d9_OCC_389a085b-21e0-4004-9d53-dfcb5c4bd2f1_BOMA__MATRX_','2022-06-03 09:04:39','2022-06-03 11:04:23','16_w1_o2_mandibule_matrix_occ_file_0.m','2022-06-03 11:04:39','SYNCED','ed676c0a-e5c3-450e-975d-f740a787e736',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.16.1.2.1 Occlusion 1\",\"referenceScanID\":\"1.16.1.2.1\",\"title\":\"Matrice Transfo. Mandibule 1.16.1.2.1 Occlusion 1\"}'),(1001,'ed70198e-0fdb-4e4d-989c-b5d7db128c36','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/593972a6-d7d6-4802-b87d-38aab371f71e/session_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480/occlusion_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3/computedocclusion_e23c031c-2c78-414b-840d-85b58e959fbe/3_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_593972a6-d7d6-4802-b87d-38aab371f71e_ACT_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480_SESS_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3_OCC_e23c031c-2c78-414b-840d-85b58e959fbe_BOPLY__ZIP_','2022-01-19 15:28:32','2022-01-19 16:26:52','3_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-01-19 16:28:32','SYNCED','ed70198e-0fdb-4e4d-989c-b5d7db128c36',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.3.1.1.1 Occlusion 4\",\"modelMatrix\":\"0.888791,-0.456948,0.035335,0,0.458312,0.886146,-0.0685242,0,1.93169e-9,0.0770982,0.997023,0,-18.6308,-12.394,-21.0367,1\",\"referenceScanID\":\"1.3.1.1.1\",\"title\":\"Mandibule 1.3.1.1.1 Occlusion 4\"}'),(1001,'ee39a90f-aee0-4d88-9d2c-8fdb22b5dc0f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_b28164eb-0070-4968-83be-bfabe1a0c839/13_w1_o1_mandibule_snapshot_2.png','SNAPS','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_b28164eb-0070-4968-83be-bfabe1a0c839_SNAPS_','2022-02-04 17:55:12','2022-02-04 17:07:06','13_w1_o1_mandibule_snapshot_2.png','2022-02-04 18:55:12','SYNCED','189a792c-fafa-4b60-958f-637d69400a83',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.5\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'ee3b303e-0d47-4654-a9f5-190db0b338bf','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/scan_2d226451-8adb-4007-be22-99a9b3af61d6/23_w1_o1_maxillaire_ml_2_0.xyz','LIFI','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_TOSC_2d226451-8adb-4007-be22-99a9b3af61d6_LIFI_','2022-05-25 10:46:42','2022-05-25 12:46:42','23_w1_o1_maxillaire_ml_2_0.xyz','2022-05-25 12:46:42','SYNCED','ee3b303e-0d47-4654-a9f5-190db0b338bf',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.23.1.1.1 Ligne de finition 2\",\"name\":\"Ligne de finition 2\",\"title\":\"Maxillaire LIFI\",\"toothNumber\":2,\"versionMarginLine\":1}'),(1001,'ee6ba447-6aa9-4446-ac83-1541e7fe80b7','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_f9c2783a-c405-481c-a97e-47bb9db0d0d2/17_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_RISC_f9c2783a-c405-481c-a97e-47bb9db0d0d2_ZIP_','2022-02-07 11:46:36','2022-02-07 12:42:42','17_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-02-07 12:46:36','SYNCED','ee6ba447-6aa9-4446-ac83-1541e7fe80b7',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.17.1.1.1\",\"modelMatrix\":\"0.919714,-0.387602,0.00723898,0,0.390371,0.920379,0.0713573,0,-0.0427756,-0.0528825,0.99751,0,-13.5446,12.0078,-15.4705,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'ee721166-4a03-458e-af6b-bb03c70245af','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/1c189ddc-0ee7-45e7-9d80-585dac08374a/session_01bd0635-6ec6-42cb-8561-8638bded352c/occlusion_2aa712ca-8b46-4a50-a03e-1c6a6a0c40fc/computedocclusion_727485e0-8637-4024-83d8-95544991f73f/29_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_1c189ddc-0ee7-45e7-9d80-585dac08374a_ACT_01bd0635-6ec6-42cb-8561-8638bded352c_SESS_2aa712ca-8b46-4a50-a03e-1c6a6a0c40fc_OCC_727485e0-8637-4024-83d8-95544991f73f_SNAPO__SNAPS_','2022-06-03 14:07:18','2022-06-03 16:07:00','29_w1_o1_snapshot_occ_file_0.png','2022-06-03 16:07:18','SYNCED','ee721166-4a03-458e-af6b-bb03c70245af',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'ee956b3f-3664-46f4-9af9-578e13e493a8','','LIFIM','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_OCC_8b14563e-0862-4cac-8045-e8aed2be886d_LIFIMO_LIFIM_','2022-07-19 13:44:35','2022-07-19 14:28:21','','2022-07-19 15:44:35','SYNCED','ee956b3f-3664-46f4-9af9-578e13e493a8',0,'2022-07-19 15:44:35','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.38.1.1.1 Occlusion 1 Ligne de finition 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"Maxillaire\",\"name\":\"Ligne de finition 0\",\"title\":\"Ligne finition metadata\",\"toothNumber\":1000}'),(1001,'ef040f11-a1d7-451f-b5fd-2aa8b64452be','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/computedocclusion_2de3d2bb-d512-4514-8bed-a879b73a6028/22_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_OCC_2de3d2bb-d512-4514-8bed-a879b73a6028_TOPLY__ZIP_','2022-04-21 11:29:38','2022-04-21 13:29:16','22_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-04-21 13:29:38','SYNCED','ef040f11-a1d7-451f-b5fd-2aa8b64452be',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.22.1.1.1 Occlusion 7\",\"modelMatrix\":\"0.527598,0.839702,-0.128611,0,-0.849494,0.521516,-0.0798764,0,4.31898e-09,0.151397,0.988473,0,-4.53893,-22.22,-19.046,1\",\"referenceScanID\":\"1.22.1.1.1\",\"title\":\"Maxillaire 1.22.1.1.1 Occlusion 7\"}'),(1001,'ef1ff025-2c19-4f71-be6d-071ff0cc7b45','','MATRX','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_ea89007b-3846-43ef-92f9-d5c7aa1a7dfa_BOMA__MATRX_','2022-05-25 08:56:33','2022-05-13 18:35:18','','2022-05-25 10:56:33','SYNCED','ef1ff025-2c19-4f71-be6d-071ff0cc7b45',0,'2022-05-25 10:56:33','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.24.1.1.1 Occlusion 5\",\"referenceScanID\":\"1.24.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.24.1.1.1 Occlusion 5\"}'),(1001,'ef2526bf-1d12-4d61-aa9f-fa114f53ea2d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/452a5200-3e06-4b74-8949-6abc7f2dda8a/session_3e95d626-668f-45f7-98ad-be2cf9d7b90b/occlusion_bce8310f-eee9-4f0a-a6b7-d592dec66be5/computedocclusion_d9818808-7d5e-47e6-9880-cc95357483ff/26_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_452a5200-3e06-4b74-8949-6abc7f2dda8a_ACT_3e95d626-668f-45f7-98ad-be2cf9d7b90b_SESS_bce8310f-eee9-4f0a-a6b7-d592dec66be5_OCC_d9818808-7d5e-47e6-9880-cc95357483ff_TOPLY__ZIP_','2022-05-24 09:43:00','2022-05-24 11:42:41','26_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-05-24 11:43:00','SYNCED','ef2526bf-1d12-4d61-aa9f-fa114f53ea2d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.26.1.1.2 Occlusion 2\",\"modelMatrix\":\"-0.139935,0.977576,-0.157365,0,-0.990161,-0.138156,0.0222396,0,1.70026e-09,0.158929,0.98729,0,5.50609,-23.1559,-20.3156,1\",\"referenceScanID\":\"1.26.1.1.2\",\"title\":\"Maxillaire 1.26.1.1.2 Occlusion 2\"}'),(1001,'ef26a6d3-7061-4506-acf3-4620973a1a94','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/scan_03839278-13f8-46e6-9581-ba11bc8bcb81/1_w1_o1_maxillaire_screenshot_ef26a6d3-7061-4506-acf3-4620973a1a94_0.png','SCREENS','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_TOSC_03839278-13f8-46e6-9581-ba11bc8bcb81_SCREENS_','2022-01-19 13:00:21','2022-01-19 11:35:32','1_w1_o1_maxillaire_screenshot_ef26a6d3-7061-4506-acf3-4620973a1a94_0.png','2022-01-19 14:00:21','SYNCED','ef26a6d3-7061-4506-acf3-4620973a1a94',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Screenshot 1.1.1.1.1 Maxillaire 1\",\"scanFileType\":\"PLY\",\"scanPosition\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"title\":\"Maxillaire 1\"}'),(1001,'efc2b340-c020-4758-98e3-38eac0dab96b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_72adeb31-f7a3-4840-9f93-f10e61c84bef/4_w1_o2_maxillaire_scan_file_1.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_TOSC_72adeb31-f7a3-4840-9f93-f10e61c84bef_ZIP_','2022-02-15 12:31:39','2022-02-15 13:31:27','4_w1_o2_maxillaire_scan_file_1.zip','2022-02-15 13:31:39','SYNCED','75ab6534-9048-449f-bd27-86687f417acf',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.4.1.2.1\",\"modelMatrix\":\"-0.408152,0.902703,-0.13616,0,-0.912914,-0.403587,0.0608755,0,-1.7183e-09,0.149149,0.988815,0,3.7011,-24.744,-22.2405,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'f03f1ba4-33a4-4ab0-a097-10b904df586c','','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_f9e18676-d6bb-44e8-b093-43cb88b0d897_SNAPO__SNAPS_','2022-05-16 17:54:29','2022-05-16 19:53:29','','2022-05-16 19:54:29','SYNCED','f03f1ba4-33a4-4ab0-a097-10b904df586c',0,'2022-05-16 19:54:29','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'f0c712f3-e19b-46a1-8fac-bf806fc55740','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_b28164eb-0070-4968-83be-bfabe1a0c839/13_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_b28164eb-0070-4968-83be-bfabe1a0c839_SNAPS_','2022-02-04 17:55:12','2022-02-04 17:02:34','13_w1_o1_mandibule_snapshot_1.png','2022-02-04 18:55:12','SYNCED','189a792c-fafa-4b60-958f-637d69400a83',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.5\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'f0cd4cd1-4c64-483f-8236-d4435df84e56','','SNAPS','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_c9079d19-8ffb-46f7-a51e-3a7a90ccae59_SESS_8ba0f3b1-408f-4a02-92a0-63f09123b68e_BOSC_3f14002f-c2c4-4c73-b111-290940b150eb_SNAPS_','2022-01-28 17:15:46','2022-01-27 14:52:22','','2022-01-28 18:15:46','SYNCED','f0cd4cd1-4c64-483f-8236-d4435df84e56',0,'2022-01-28 18:15:46','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.10.1.1.4\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'f0d7bfea-aa10-4ed7-be82-fe4f23b144de','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/order_6432beca-4bf1-4ec7-b2e2-fe40b055da41/17_w1_inlay_onlay_prost_file_f0d7bfea-aa10-4ed7-be82-fe4f23b144de_0.pdf','PDF','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_PROST_6432beca-4bf1-4ec7-b2e2-fe40b055da41_PDF_','2022-02-12 16:57:59','2022-02-12 17:57:58','17_w1_inlay_onlay_prost_file_f0d7bfea-aa10-4ed7-be82-fe4f23b144de_0.pdf','2022-02-12 17:57:59','SYNCED','f0d7bfea-aa10-4ed7-be82-fe4f23b144de',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.17.1.2 INLAY ONLAY\",\"title\":\"Inlay/Onlay PDF\"}'),(1001,'f0d8b7b1-1798-4024-8213-8245124507e6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/986374de-c4d7-4d6f-bf0c-2dc7e3b859a9/session_c81670ed-4144-4347-b19e-8057d11b5f7c/occlusion_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be/scan_67168b1b-2bef-47a9-8e7f-994731a82831/28_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_986374de-c4d7-4d6f-bf0c-2dc7e3b859a9_ACT_c81670ed-4144-4347-b19e-8057d11b5f7c_SESS_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be_BOSC_67168b1b-2bef-47a9-8e7f-994731a82831_ZIP_','2022-05-31 10:50:30','2022-05-31 12:50:23','28_w1_o1_mandibule_scan_file_1.zip','2022-05-31 12:50:30','SYNCED','5f547eb8-8e01-467b-8bc2-36624f0938f2',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.28.1.1.1\",\"modelMatrix\":\"-0.906695,-0.381018,0.180913,0,0.421787,-0.819056,0.3889,0,-1.14174e-08,0.428921,0.903342,0,15.4673,-8.13965,-18.6147,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'f0fbc62f-5d64-4616-a31b-4363cce2aea7','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_e6c95ef7-636d-4c88-8d02-e2d9840573db/13_w1_o1_mandibule_snapshot_2.png','SNAPS','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_e6c95ef7-636d-4c88-8d02-e2d9840573db_SNAPS_','2022-01-28 17:11:16','2022-01-27 17:49:35','13_w1_o1_mandibule_snapshot_2.png','2022-01-28 18:11:16','SYNCED','ac0f8bbb-d9a6-428c-a397-1febe6de5982',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'f10589f3-c72c-435a-a8b4-17403cd0e41a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/computedocclusion_0d180e89-cc7f-4718-abf6-79b3ada7fd3c/4_w1_o2_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_OCC_0d180e89-cc7f-4718-abf6-79b3ada7fd3c_BOPLY__ZIP_','2022-02-15 12:49:47','2022-02-15 13:49:40','4_w1_o2_mandibule_occlusion_occ_file_0.zip','2022-02-15 13:49:47','SYNCED','f10589f3-c72c-435a-a8b4-17403cd0e41a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.2.2 Occlusion 3\",\"modelMatrix\":\"0.835361,0.540236,-0.10157,0,-0.549701,0.820977,-0.154353,0,-4.31854e-09,0.184774,0.982781,0,-13.6307,-23.1827,-19.2574,1\",\"referenceScanID\":\"1.4.1.2.2\",\"title\":\"Mandibule 1.4.1.2.2 Occlusion 3\"}'),(1001,'f110d96d-9d12-4348-8731-edaab50ce873','','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_aa16f8ea-198d-4240-ab78-5a1f54823f0c_TOPLY__ZIP_','2022-05-16 17:48:35','2022-05-16 19:47:59','','2022-05-16 19:48:35','SYNCED','f110d96d-9d12-4348-8731-edaab50ce873',0,'2022-05-16 19:48:35','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.2 Occlusion 6\",\"modelMatrix\":\"-0.80453,0.576793,-0.141569,0,-0.593912,-0.781339,0.191773,0,-6.05286e-09,0.238367,0.971175,0,0.910551,-5.61768,-25.9513,1\",\"referenceScanID\":\"1.24.1.1.2\",\"title\":\"Maxillaire 1.24.1.1.2 Occlusion 6\"}'),(1001,'f16b55b9-49a6-4e3c-957a-cce9f0ee4540','','SNAPS','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_55831d43-1906-4a22-9b7a-ed4b2820c8b2_SESS_4f582d4c-81d0-4e01-8be3-9ff53b12c7f4_BOSC_b36554f3-43ab-43e8-bcdf-e12f8de33163_SNAPS_','2022-06-16 13:28:16','2022-06-16 15:25:24','','2022-06-16 15:28:16','SYNCED','f16b55b9-49a6-4e3c-957a-cce9f0ee4540',0,'2022-06-16 15:28:16','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.10.2.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'f1b4af70-0a68-4499-bbd3-2ae8dc65226e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/computedocclusion_77753fb3-75a1-45c2-9191-7a5d98206df2/24_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_77753fb3-75a1-45c2-9191-7a5d98206df2_BOMA__MATRX_','2022-06-14 12:07:17','2022-06-14 14:06:33','24_w1_o1_mandibule_matrix_occ_file_0.m','2022-06-14 14:07:17','SYNCED','f1b4af70-0a68-4499-bbd3-2ae8dc65226e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.24.1.1.1 Occlusion 5\",\"referenceScanID\":\"1.24.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.24.1.1.1 Occlusion 5\"}'),(1001,'f1c37058-860d-41f6-bc2d-7c6851b1e124','','SNAPS','PATIENT_02df4b55-8d30-46ac-b34e-449ffbc4269e_ACT_ef4d16ee-fe39-4081-920a-e42ecf24a857_SESS_d0ba750a-59bf-4ba0-b876-4c1bd25d5677_TOSC_3ac5d21b-7377-44ee-9096-b54f97336106_SNAPS_','2022-03-22 07:55:51','2022-03-19 11:45:58','','2022-03-22 08:55:51','SYNCED','f1c37058-860d-41f6-bc2d-7c6851b1e124',0,'2022-03-22 08:55:51','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.20.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'f1e9e673-dabe-4bb3-8a39-0e12c5205cb8','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7f47fd88-9ea0-4c08-9193-a54d4f158c7c/session_7873a396-419c-4215-83c7-fec9f2742ccf/occlusion_2e287bb0-e19a-414a-9177-23b335d286d9/scan_aa3849b7-bd16-41b9-8afe-0af192f363d1/16_w1_o2_mandibule_snapshot_0.png','SNAPS','PATIENT_7f47fd88-9ea0-4c08-9193-a54d4f158c7c_ACT_7873a396-419c-4215-83c7-fec9f2742ccf_SESS_2e287bb0-e19a-414a-9177-23b335d286d9_BOSC_aa3849b7-bd16-41b9-8afe-0af192f363d1_SNAPS_','2022-06-03 08:59:07','2022-06-03 10:58:58','16_w1_o2_mandibule_snapshot_0.png','2022-06-03 10:59:07','SYNCED','f1e9e673-dabe-4bb3-8a39-0e12c5205cb8',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.16.1.2.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'f1fe43f5-54e7-46ae-be34-78bb7cec9336','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/occlusion_e08bbeeb-a30b-428c-bd4a-40198f792219/scan_ef1d20c7-5f61-4c35-8f0f-d85507cab786/25_w1_o1_mandibule_scan_file_2.zip','ZIP','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_SESS_e08bbeeb-a30b-428c-bd4a-40198f792219_BOSC_ef1d20c7-5f61-4c35-8f0f-d85507cab786_ZIP_','2022-05-17 16:16:06','2022-05-17 18:15:57','25_w1_o1_mandibule_scan_file_2.zip','2022-05-17 18:16:06','SYNCED','69ad61a1-bbd5-4415-a55b-c7c378bdf30e',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.25.1.1.1\",\"modelMatrix\":\"0.999249,-0.0384184,0.00498743,0,0.0387408,0.990934,-0.128642,0,-2.07759e-10,0.128738,0.991679,0,-0.361214,-5.55952,-21.2055,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'f20230d6-c0ec-4d5c-ad01-3671a1db56f0','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/scan_2d226451-8adb-4007-be22-99a9b3af61d6/23_w1_o1_maxillaire_ml_0_0.xyz','LIFI','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_TOSC_2d226451-8adb-4007-be22-99a9b3af61d6_LIFI_','2022-05-25 08:32:43','2022-05-25 10:32:43','23_w1_o1_maxillaire_ml_0_0.xyz','2022-05-25 10:32:43','SYNCED','f20230d6-c0ec-4d5c-ad01-3671a1db56f0',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.23.1.1.1 Ligne de finition 0\",\"name\":\"Ligne de finition 0\",\"title\":\"Maxillaire LIFI\",\"toothNumber\":0,\"versionMarginLine\":1}'),(1001,'f27a70e5-90e5-49c4-9fb7-33040d0fd112','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/computedocclusion_8e4092a3-64a2-4464-addd-03b3c8ba2289/24_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_8e4092a3-64a2-4464-addd-03b3c8ba2289_BOMA__MATRX_','2022-05-13 16:21:25','2022-05-13 18:20:53','24_w1_o1_mandibule_matrix_occ_file_0.m','2022-05-13 18:21:25','SYNCED','f27a70e5-90e5-49c4-9fb7-33040d0fd112',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.24.1.1.1 Occlusion 3\",\"referenceScanID\":\"1.24.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.24.1.1.1 Occlusion 3\"}'),(1001,'f2a1652f-f48d-4f9a-9870-62514156e41f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/computedocclusion_35af1bf5-285a-4bb1-a6db-fe9897defe51/23_w1_o1_mlmeta_occ_file_to1000.bin','LIFIM','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_35af1bf5-285a-4bb1-a6db-fe9897defe51_LIFIMO_LIFIM_','2022-05-25 08:32:45','2022-05-25 10:32:43','23_w1_o1_mlmeta_occ_file_to1000.bin','2022-05-25 10:32:45','SYNCED','f2a1652f-f48d-4f9a-9870-62514156e41f',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.23.1.1.1 Occlusion 4 Ligne de finition 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"Maxillaire\",\"name\":\"Ligne de finition 0\",\"title\":\"Ligne finition metadata\",\"toothNumber\":1000}'),(1001,'f2b2fdde-fc11-4367-a51e-d62819941b89','','MATRX','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_f9e18676-d6bb-44e8-b093-43cb88b0d897_BOMA__MATRX_','2022-05-16 17:54:27','2022-05-16 19:53:29','','2022-05-16 19:54:27','SYNCED','f2b2fdde-fc11-4367-a51e-d62819941b89',0,'2022-05-16 19:54:27','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.24.1.1.1 Occlusion 6\",\"referenceScanID\":\"1.24.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.24.1.1.1 Occlusion 6\"}'),(1001,'f2e1df9d-8e84-470f-9c1c-5c95e60d6ccd','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/4a3954e0-1e2f-4721-9fdd-4180380dc19f/session_33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416/occlusion_3accbada-5a51-4d10-88d1-c3e7d8598d6f/computedocclusion_5775815f-f076-48af-be27-50e4dbfd3622/34_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_4a3954e0-1e2f-4721-9fdd-4180380dc19f_ACT_33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416_SESS_3accbada-5a51-4d10-88d1-c3e7d8598d6f_OCC_5775815f-f076-48af-be27-50e4dbfd3622_TOPLY__ZIP_','2022-06-28 10:56:19','2022-06-28 12:55:54','34_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-06-28 12:56:19','SYNCED','f2e1df9d-8e84-470f-9c1c-5c95e60d6ccd',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.34.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.433907,0.888246,-0.150809,0,-0.900958,0.427785,-0.0726306,0,2.15454e-09,0.167388,0.985891,0,-4.91739,-21.5763,-15.238,1\",\"referenceScanID\":\"1.34.1.1.1\",\"title\":\"Maxillaire 1.34.1.1.1 Occlusion 1\"}'),(1001,'f2e9f051-f3b7-4edf-b050-2381287f0885','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/d100e894-0be9-4495-94e2-e469232f7817/session_2c8b85b5-c805-4b08-85e7-3d02dab72e99/order_e0712535-48d0-4f86-b2a1-6f1ed1bd75f2/15_w1_couronne_prost_file_f2e9f051-f3b7-4edf-b050-2381287f0885_0.pdf','PDF','PATIENT_d100e894-0be9-4495-94e2-e469232f7817_ACT_2c8b85b5-c805-4b08-85e7-3d02dab72e99_PROST_e0712535-48d0-4f86-b2a1-6f1ed1bd75f2_PDF_','2022-02-02 09:18:58','2022-02-02 10:18:57','15_w1_couronne_prost_file_f2e9f051-f3b7-4edf-b050-2381287f0885_0.pdf','2022-02-02 10:18:58','SYNCED','f2e9f051-f3b7-4edf-b050-2381287f0885',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.15.1.1 COURONNE\",\"title\":\"Couronne PDF\"}'),(2,'f2f2b9e4-5a36-4782-baf5-f9502540c979','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a4b302c-278d-4e12-ace5-f095ba0bf856/session_6206892a-2e7e-4765-ac90-b49bfb465997/occlusion_7ec70f78-dc80-40c5-b293-570a59f034c4/scan_dda8845a-2340-4d1a-8749-46d59887f64f/3_w1_o2_maxillaire_scan_file_0.zip','ZIP','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_7ec70f78-dc80-40c5-b293-570a59f034c4_TOSC_dda8845a-2340-4d1a-8749-46d59887f64f_ZIP_','2022-09-06 09:17:36','2022-08-30 14:34:16','3_w1_o2_maxillaire_scan_file_0.zip','2022-09-06 11:17:36','SYNCED','f2f2b9e4-5a36-4782-baf5-f9502540c979',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.3.1.2.6\",\"modelMatrix\":\"0.915583,0.38648,-0.111091,0,-0.40213,0.879951,-0.252937,0,-5.80189e-09,0.276258,0.961084,0,-27.4108,-0.929837,-16.1625,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'f34bb951-2c16-4ce9-a46b-c1d1a0b11c3f','','SNAPS','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_RISC_4cf74467-a55c-46b5-99f6-e0f80fd19b31_SNAPS_','2022-09-09 16:30:10','2022-09-09 18:22:24','','2022-09-09 18:30:10','SYNCED','f34bb951-2c16-4ce9-a46b-c1d1a0b11c3f',0,'2022-09-09 18:30:10','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.39.1.1.3\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'f3984bdb-981c-4204-9097-9994babcb575','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/occlusion_a2220645-c79d-4dda-b6cc-772384a4106b/scan_0136d883-d517-448a-82a3-bfcdd5f4c35c/38_w1_o1_maxillaire_mlmeta_0_0.bin','LIFIM','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_TOSC_0136d883-d517-448a-82a3-bfcdd5f4c35c_LIFIM_','2022-07-19 12:28:52','2022-07-19 14:28:51','38_w1_o1_maxillaire_mlmeta_0_0.bin','2022-07-19 14:28:52','SYNCED','f3984bdb-981c-4204-9097-9994babcb575',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.38.1.1.1 Ligne de finition 0\",\"name\":\"Ligne de finition 0\",\"title\":\"Maxillaire LIFI_META\",\"toothNumber\":0,\"versionMarginLine\":1}'),(1001,'f3d3d31f-7e08-49c2-aaf5-83098cbf7010','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/452a5200-3e06-4b74-8949-6abc7f2dda8a/session_3e95d626-668f-45f7-98ad-be2cf9d7b90b/occlusion_bce8310f-eee9-4f0a-a6b7-d592dec66be5/computedocclusion_7a922eb8-5139-40fe-8402-fc7ff4204a1a/26_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_452a5200-3e06-4b74-8949-6abc7f2dda8a_ACT_3e95d626-668f-45f7-98ad-be2cf9d7b90b_SESS_bce8310f-eee9-4f0a-a6b7-d592dec66be5_OCC_7a922eb8-5139-40fe-8402-fc7ff4204a1a_BOMA__MATRX_','2022-05-24 09:42:29','2022-05-24 11:42:09','26_w1_o1_mandibule_matrix_occ_file_0.m','2022-05-24 11:42:29','SYNCED','f3d3d31f-7e08-49c2-aaf5-83098cbf7010',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.26.1.1.2 Occlusion 1\",\"referenceScanID\":\"1.26.1.1.2\",\"title\":\"Matrice Transfo. Mandibule 1.26.1.1.2 Occlusion 1\"}'),(1001,'f3f04913-1014-4fbf-9379-14c2f5249ed7','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_e6c95ef7-636d-4c88-8d02-e2d9840573db/13_w1_o1_mandibule_scan_file_3.zip','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_e6c95ef7-636d-4c88-8d02-e2d9840573db_ZIP_','2022-01-27 16:38:26','2022-01-27 17:37:32','13_w1_o1_mandibule_scan_file_3.zip','2022-01-27 17:38:26','SYNCED','bcef8d3e-9632-4976-8cda-4c6f3ac50e99',3,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.1\",\"modelMatrix\":\"-0.963479,0.243305,-0.111855,0,-0.267785,-0.8754,0.402451,0,1.23617e-9,0.417706,0.908582,0,32.4632,-3.53421,-16.2323,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'f43bccad-6647-495c-8c06-541b112b5a3a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/computedocclusion_77753fb3-75a1-45c2-9191-7a5d98206df2/24_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_77753fb3-75a1-45c2-9191-7a5d98206df2_BOPLY__ZIP_','2022-06-14 12:07:05','2022-06-14 14:06:33','24_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-06-14 14:07:05','SYNCED','f43bccad-6647-495c-8c06-541b112b5a3a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.24.1.1.1 Occlusion 5\",\"modelMatrix\":\"0.852703,-0.521011,0.0380208,0,0.522396,0.850441,-0.062061,0,3.49638e-10,0.0727815,0.997348,0,-11.3911,-12.8136,-21.1334,1\",\"referenceScanID\":\"1.24.1.1.1\",\"title\":\"Mandibule 1.24.1.1.1 Occlusion 5\"}'),(1001,'f4469121-0967-4f3a-87f1-84867a02fa3a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/computedocclusion_d7643aed-d242-47f6-8e1a-703d4672f109/18_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_OCC_d7643aed-d242-47f6-8e1a-703d4672f109_TOMA__MATRX_','2022-03-07 14:44:47','2022-03-07 15:44:20','18_w1_o1_maxillaire_matrix_occ_file_0.m','2022-03-07 15:44:47','SYNCED','f4469121-0967-4f3a-87f1-84867a02fa3a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.18.1.1.2 Occlusion 2\",\"referenceScanID\":\"1.18.1.1.2\",\"title\":\"Matrice Transfo. Maxillaire 1.18.1.1.2 Occlusion 2\"}'),(1001,'f4de6479-e66b-4594-a9fd-f161d4878d35','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/occlusion_a2220645-c79d-4dda-b6cc-772384a4106b/scan_38a668ff-3bd3-4238-90d7-65cc6f5a9ca7/38_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_BOSC_38a668ff-3bd3-4238-90d7-65cc6f5a9ca7_SNAPS_','2022-07-12 10:53:47','2022-07-12 12:53:37','38_w1_o1_mandibule_snapshot_0.png','2022-07-12 12:53:47','SYNCED','f4de6479-e66b-4594-a9fd-f161d4878d35',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.38.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'f4e25908-22f9-4c3d-adaa-8c0ca6a7da5b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a0c21836-ba79-4f15-9e35-02ef8211a9e5/session_0aac522d-3c38-465a-a1e0-014166c140ac/order_4bc73a7b-2ac9-49e5-8145-3584247ee5c6/7_w1_inlay_onlay_prost_file_f4e25908-22f9-4c3d-adaa-8c0ca6a7da5b_0.pdf','PDF','PATIENT_a0c21836-ba79-4f15-9e35-02ef8211a9e5_ACT_0aac522d-3c38-465a-a1e0-014166c140ac_PROST_4bc73a7b-2ac9-49e5-8145-3584247ee5c6_PDF_','2022-01-21 18:49:34','2022-01-21 19:49:33','7_w1_inlay_onlay_prost_file_f4e25908-22f9-4c3d-adaa-8c0ca6a7da5b_0.pdf','2022-01-21 19:49:34','SYNCED','f4e25908-22f9-4c3d-adaa-8c0ca6a7da5b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.7.1.1 INLAY ONLAY\",\"title\":\"Inlay/Onlay PDF\"}'),(1001,'f55e5c53-f6d4-474c-acc3-22cdd4738b6a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_2a7068fc-0efa-496f-ade9-aba5b0650655/12_w1_o1_mandibule_snapshot_4.png','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_2a7068fc-0efa-496f-ade9-aba5b0650655_SNAPS_','2022-02-04 12:08:21','2022-02-04 13:05:50','12_w1_o1_mandibule_snapshot_4.png','2022-02-04 13:08:21','SYNCED','7636e0d7-f242-431c-90a5-a65399d83ecd',4,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.5\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'f58132fd-293c-467a-8ea3-815a7cb06d04','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/1c189ddc-0ee7-45e7-9d80-585dac08374a/session_01bd0635-6ec6-42cb-8561-8638bded352c/occlusion_2aa712ca-8b46-4a50-a03e-1c6a6a0c40fc/scan_1aa5441d-7ad8-4a5d-96d6-d07348ac58c4/29_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_1c189ddc-0ee7-45e7-9d80-585dac08374a_ACT_01bd0635-6ec6-42cb-8561-8638bded352c_SESS_2aa712ca-8b46-4a50-a03e-1c6a6a0c40fc_TOSC_1aa5441d-7ad8-4a5d-96d6-d07348ac58c4_SNAPS_','2022-06-03 13:56:53','2022-06-03 15:56:41','29_w1_o1_maxillaire_snapshot_0.png','2022-06-03 15:56:53','SYNCED','f58132fd-293c-467a-8ea3-815a7cb06d04',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.29.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'f5e4f048-bc57-4a38-b5b1-178a940475e7','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/32939ecf-ba11-4fff-a074-5e86a9f7f313/session_4075a8d6-094f-4202-abe0-4c02b7a5a8e6/occlusion_51192c80-5065-420e-ae8f-bac335ac1de1/scan_2ca8702c-bb71-418c-b881-0d3d2af204d1/6_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_32939ecf-ba11-4fff-a074-5e86a9f7f313_ACT_4075a8d6-094f-4202-abe0-4c02b7a5a8e6_SESS_51192c80-5065-420e-ae8f-bac335ac1de1_TOSC_2ca8702c-bb71-418c-b881-0d3d2af204d1_ZIP_','2022-01-20 19:41:39','2022-01-20 11:35:40','6_w1_o1_maxillaire_scan_file_1.zip','2022-01-20 20:41:39','SYNCED','2343da36-b2ed-48aa-8bea-6bbf74dee09b',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.6.1.1.1\",\"modelMatrix\":\"0.263407,0.935947,-0.23371,0,-0.964685,0.25556,-0.0638147,0,-1.36335e-9,0.242266,0.97021,0,-14.4452,-22.3861,-20.5596,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'f607081f-4aac-486a-878c-3ce1c3471575','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/scan_a6e9f7d5-ea01-4016-a5c9-4b948fbd5ded/22_w1_o1_mordu_anterieur_scan_file_0.zip','ZIP','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_FRSC_a6e9f7d5-ea01-4016-a5c9-4b948fbd5ded_ZIP_','2022-04-21 11:14:43','2022-04-21 13:14:37','22_w1_o1_mordu_anterieur_scan_file_0.zip','2022-04-21 13:14:43','SYNCED','f607081f-4aac-486a-878c-3ce1c3471575',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.22.1.1.1\",\"modelMatrix\":\"0.989806,0.121067,-0.0719957,0,-0.121157,0.990849,-0.0388091,0,0.0754925,0.0614653,0.996787,0,-3.62325,-2.42384,-22.1442,1\",\"title\":\"Mordu anterieur ZIP\"}'),(1001,'f673b1c6-f2eb-45e8-891d-addf029e2a39','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/4a3954e0-1e2f-4721-9fdd-4180380dc19f/session_33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416/occlusion_3accbada-5a51-4d10-88d1-c3e7d8598d6f/scan_eb03dd9c-db3d-4d79-99ee-0715da7cea41/34_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_4a3954e0-1e2f-4721-9fdd-4180380dc19f_ACT_33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416_SESS_3accbada-5a51-4d10-88d1-c3e7d8598d6f_TOSC_eb03dd9c-db3d-4d79-99ee-0715da7cea41_SNAPS_','2022-06-28 10:53:49','2022-06-28 12:53:40','34_w1_o1_maxillaire_snapshot_0.png','2022-06-28 12:53:49','SYNCED','f673b1c6-f2eb-45e8-891d-addf029e2a39',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.34.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'f6f9c81e-5679-4d17-89e3-2a76bf2488aa','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7f47fd88-9ea0-4c08-9193-a54d4f158c7c/session_7873a396-419c-4215-83c7-fec9f2742ccf/occlusion_2e287bb0-e19a-414a-9177-23b335d286d9/scan_aa3849b7-bd16-41b9-8afe-0af192f363d1/16_w1_o2_mandibule_scan_file_0.zip','ZIP','PATIENT_7f47fd88-9ea0-4c08-9193-a54d4f158c7c_ACT_7873a396-419c-4215-83c7-fec9f2742ccf_SESS_2e287bb0-e19a-414a-9177-23b335d286d9_BOSC_aa3849b7-bd16-41b9-8afe-0af192f363d1_ZIP_','2022-06-03 08:59:06','2022-06-03 10:58:59','16_w1_o2_mandibule_scan_file_0.zip','2022-06-03 10:59:06','SYNCED','f6f9c81e-5679-4d17-89e3-2a76bf2488aa',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.16.1.2.1\",\"modelMatrix\":\"-0.765535,0.616965,-0.18251,0,-0.643394,-0.734089,0.217158,0,1.60274e-09,0.283668,0.958923,0,-0.17301,-6.28078,-19.6174,1\",\"title\":\"Mandibule ZIP\"}'),(2,'f70bac1d-ae30-46a3-aada-2a8219868f35','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a4b302c-278d-4e12-ace5-f095ba0bf856/session_6206892a-2e7e-4765-ac90-b49bfb465997/occlusion_7ec70f78-dc80-40c5-b293-570a59f034c4/scan_e57dd65c-d607-4b04-af86-37d5f5d568b7/3_w1_o2_maxillaire_scan_file_0.zip','ZIP','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_7ec70f78-dc80-40c5-b293-570a59f034c4_TOSC_e57dd65c-d607-4b04-af86-37d5f5d568b7_ZIP_','2022-09-06 09:17:38','2022-08-30 14:14:59','3_w1_o2_maxillaire_scan_file_0.zip','2022-09-06 11:17:38','SYNCED','f70bac1d-ae30-46a3-aada-2a8219868f35',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.3.1.2.2\",\"modelMatrix\":\"0.773027,0.611991,-0.167021,0,-0.634373,0.745753,-0.203527,0,-5.95185e-09,0.263286,0.964718,0,-27.929,-7.5745,-14.6669,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'f759e17c-cc77-4031-99a2-8486d474c84d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a4b302c-278d-4e12-ace5-f095ba0bf856/session_6206892a-2e7e-4765-ac90-b49bfb465997/occlusion_7ec70f78-dc80-40c5-b293-570a59f034c4/scan_b0d11b07-1362-4652-a13f-8f36c3c15cb1/3_w1_o2_maxillaire_scan_file_0.zip','ZIP','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_7ec70f78-dc80-40c5-b293-570a59f034c4_TOSC_b0d11b07-1362-4652-a13f-8f36c3c15cb1_ZIP_','2022-09-06 09:17:44','2022-08-30 14:09:54','3_w1_o2_maxillaire_scan_file_0.zip','2022-09-06 11:17:44','SYNCED','f759e17c-cc77-4031-99a2-8486d474c84d',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.3.1.2.1\",\"modelMatrix\":\"0.842593,0.522044,-0.132315,0,-0.538551,0.816767,-0.207014,0,1.00904e-08,0.245687,0.969349,0,-28.4936,-4.54451,-16.4936,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'f780bfd0-c586-4081-9517-73afda328a0b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_e8550560-cfe0-40a1-bfb3-992d471fbcb7/17_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_BOSC_e8550560-cfe0-40a1-bfb3-992d471fbcb7_ZIP_','2022-02-07 11:46:06','2022-02-07 12:38:32','17_w1_o1_mandibule_scan_file_1.zip','2022-02-07 12:46:06','SYNCED','66961639-a805-46f9-bc8c-5d51fa295ec0',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.17.1.1.1\",\"modelMatrix\":\"-0.980954,-0.188901,0.0452269,0,0.19424,-0.953992,0.228406,0,1.35057e-9,0.232841,0.972515,0,27.4349,19.1019,-20.1379,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'f795a9ab-dea1-4d0f-962a-1654168718cd','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/593972a6-d7d6-4802-b87d-38aab371f71e/session_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480/occlusion_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3/computedocclusion_e23c031c-2c78-414b-840d-85b58e959fbe/3_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_593972a6-d7d6-4802-b87d-38aab371f71e_ACT_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480_SESS_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3_OCC_e23c031c-2c78-414b-840d-85b58e959fbe_BOMA__MATRX_','2022-01-19 15:28:32','2022-01-19 16:26:52','3_w1_o1_mandibule_matrix_occ_file_0.m','2022-01-19 16:28:32','SYNCED','f795a9ab-dea1-4d0f-962a-1654168718cd',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.3.1.1.1 Occlusion 4\",\"referenceScanID\":\"1.3.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.3.1.1.1 Occlusion 4\"}'),(1001,'f811a353-ce90-4c41-a293-218aca035afe','','ZIP','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_LESC_f9eccc16-31b5-4a87-b758-9bf72196ca28_ZIP_','2022-09-09 16:40:45','2022-09-09 18:38:08','','2022-09-09 18:40:45','SYNCED','f811a353-ce90-4c41-a293-218aca035afe',0,'2022-09-09 18:40:45','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.39.1.1.7\",\"modelMatrix\":\"-0.998534,-0.0295595,-0.0448782,0,0.0250413,-0.998809,0.0416809,0,-0.0481085,0.0389288,0.998126,0,5.75387,1.30542,-7.10017,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'f83e0257-49c2-409b-a1b0-0c5bb674c327','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/32710234-804f-46f5-899d-eed636f8a906/session_64c1427a-b91d-4675-94df-f36bd40e9b0f/occlusion_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a/scan_3954e24e-9220-452b-a8fa-b1fbde6ebcad/33_w2_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_32710234-804f-46f5-899d-eed636f8a906_ACT_64c1427a-b91d-4675-94df-f36bd40e9b0f_SESS_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a_BOSC_3954e24e-9220-452b-a8fa-b1fbde6ebcad_ZIP_','2022-06-28 08:58:07','2022-06-28 10:57:59','33_w2_o1_mandibule_scan_file_0.zip','2022-06-28 10:58:07','SYNCED','f83e0257-49c2-409b-a1b0-0c5bb674c327',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.33.2.1.1\",\"modelMatrix\":\"-0.955279,-0.292367,0.0443062,0,0.295705,-0.944496,0.143132,0,1.412e-09,0.149833,0.988711,0,17.0211,-9.1751,-16.95,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'f8701aa9-49a2-44c6-b4c2-795209c7e987','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/de078619-3946-4adb-a799-1c260e16face/session_24d0aeb5-3058-4070-aeea-97c289e41e3c/occlusion_ea6da896-1504-41fc-890c-7c48575e9e40/computedocclusion_a15a6719-2996-4256-93d7-515e4d4f5bef/2_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_de078619-3946-4adb-a799-1c260e16face_ACT_24d0aeb5-3058-4070-aeea-97c289e41e3c_SESS_ea6da896-1504-41fc-890c-7c48575e9e40_OCC_a15a6719-2996-4256-93d7-515e4d4f5bef_SNAPO__SNAPS_','2022-01-19 14:46:53','2022-01-19 15:46:49','2_w1_o1_snapshot_occ_file_0.png','2022-01-19 15:46:53','SYNCED','f8701aa9-49a2-44c6-b4c2-795209c7e987',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'f8b5de1c-c1e9-41af-ac09-eb7ccc5fa3e2','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/occlusion_a2220645-c79d-4dda-b6cc-772384a4106b/computedocclusion_8b14563e-0862-4cac-8045-e8aed2be886d/38_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_OCC_8b14563e-0862-4cac-8045-e8aed2be886d_SNAPO__SNAPS_','2022-07-12 10:57:43','2022-07-12 12:57:24','38_w1_o1_snapshot_occ_file_0.png','2022-07-12 12:57:43','SYNCED','f8b5de1c-c1e9-41af-ac09-eb7ccc5fa3e2',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'f8ca0461-0d59-4723-99c3-d2d0f0b72a9e','','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_26ae7fce-0ea3-479f-9989-7d0a3a19aaf7_TOPLY__ZIP_','2022-02-08 08:49:00','2022-02-07 18:58:31','','2022-02-08 09:49:00','SYNCED','f8ca0461-0d59-4723-99c3-d2d0f0b72a9e',0,'2022-02-08 09:49:00','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.17.1.1.1 Occlusion 6\",\"modelMatrix\":\"0.149253,0.920186,-0.361913,0,-0.988799,0.138896,-0.0546284,0,-8.90892e-10,0.366013,0.93061,0,-24.4594,-29.735,-12.8678,1\",\"referenceScanID\":\"1.17.1.1.1\",\"title\":\"Maxillaire 1.17.1.1.1 Occlusion 6\"}'),(1001,'f95d73b2-8be1-4502-a945-43f4dcfb6ea1','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/fa7fa96b-f393-4b9a-8198-144702462cfa/session_4bed076c-8541-4a2f-800a-5aeb4cb49de5/order_1112ed78-72d8-46cc-b1ce-1f68268f698a/35_w1_autre_prost_file_f95d73b2-8be1-4502-a945-43f4dcfb6ea1_0.pdf','PDF','PATIENT_fa7fa96b-f393-4b9a-8198-144702462cfa_ACT_4bed076c-8541-4a2f-800a-5aeb4cb49de5_PROST_1112ed78-72d8-46cc-b1ce-1f68268f698a_PDF_','2022-06-28 17:28:44','2022-06-28 19:28:44','35_w1_autre_prost_file_f95d73b2-8be1-4502-a945-43f4dcfb6ea1_0.pdf','2022-06-28 19:28:44','SYNCED','f95d73b2-8be1-4502-a945-43f4dcfb6ea1',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.35.1.2 AUTRE FICHE DE PROTHESE\",\"title\":\"Autre PDF\"}'),(1001,'f95f4015-5a34-4219-86b1-162f0930c25d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/e922efb9-8c03-445b-8a0f-449e3c43bdca/session_a2369349-1629-40ad-8784-d271bc3fbade/occlusion_292cc1aa-8b12-463b-87a1-7d9731cf886b/scan_3d958f24-3e12-4683-9cee-1d6c2a7022c8/21_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_e922efb9-8c03-445b-8a0f-449e3c43bdca_ACT_a2369349-1629-40ad-8784-d271bc3fbade_SESS_292cc1aa-8b12-463b-87a1-7d9731cf886b_TOSC_3d958f24-3e12-4683-9cee-1d6c2a7022c8_ZIP_','2022-04-21 08:36:29','2022-04-21 10:36:15','21_w1_o1_maxillaire_scan_file_0.zip','2022-04-21 10:36:29','SYNCED','f95f4015-5a34-4219-86b1-162f0930c25d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.21.1.1.1\",\"modelMatrix\":\"0.849212,0.517954,-0.10277,0,-0.528051,0.832974,-0.165274,0,8.96425e-09,0.19462,0.980879,0,-9.21476,-26.546,-17.5027,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'f99e43ef-b2a5-4b33-a2a9-0c8979132292','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/e922efb9-8c03-445b-8a0f-449e3c43bdca/session_a2369349-1629-40ad-8784-d271bc3fbade/occlusion_292cc1aa-8b12-463b-87a1-7d9731cf886b/scan_d1ea0460-f48a-4dc1-a0ae-c13f265abac4/21_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_e922efb9-8c03-445b-8a0f-449e3c43bdca_ACT_a2369349-1629-40ad-8784-d271bc3fbade_SESS_292cc1aa-8b12-463b-87a1-7d9731cf886b_RISC_d1ea0460-f48a-4dc1-a0ae-c13f265abac4_SNAPS_','2022-04-21 08:52:46','2022-04-21 10:52:38','21_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-04-21 10:52:46','SYNCED','f99e43ef-b2a5-4b33-a2a9-0c8979132292',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.21.1.1.2\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'fa05c88b-194d-4b51-8a79-719b0ae7d42c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/45ff7437-0691-4427-a7da-8250862e4b96/session_4ff9c682-c09d-42ff-8c29-aeb13e066ed2/occlusion_934673c1-a4b9-4508-ac1b-a03092a0693e/computedocclusion_161f60a4-d4f2-41f1-98ad-a8ccad84216c/9_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_45ff7437-0691-4427-a7da-8250862e4b96_ACT_4ff9c682-c09d-42ff-8c29-aeb13e066ed2_SESS_934673c1-a4b9-4508-ac1b-a03092a0693e_OCC_161f60a4-d4f2-41f1-98ad-a8ccad84216c_BOPLY__ZIP_','2022-01-24 17:47:24','2022-01-24 18:46:00','9_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-01-24 18:47:24','SYNCED','fa05c88b-194d-4b51-8a79-719b0ae7d42c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.9.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.992217,-0.124118,0.00997001,0,0.124517,0.989032,-0.079446,0,2.73202e-10,0.0800691,0.996789,0,-25.6457,11.0526,-18.0123,1\",\"referenceScanID\":\"1.9.1.1.1\",\"title\":\"Mandibule 1.9.1.1.1 Occlusion 1\"}'),(1001,'fa5e32d4-c596-49b2-8e98-a7bdcac5bf56','','ZIP','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_c9079d19-8ffb-46f7-a51e-3a7a90ccae59_SESS_8ba0f3b1-408f-4a02-92a0-63f09123b68e_BOSC_cf1df2e4-52f9-48a2-8e0b-54a1e4ed5741_ZIP_','2022-01-28 17:15:46','2022-01-26 15:48:06','','2022-01-28 18:15:46','SYNCED','7161a896-678c-49ce-a8db-989109953ffa',1,'2022-01-28 18:15:46','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.10.1.1.2\",\"modelMatrix\":\"0.516833,0.814252,-0.264344,0,-0.856086,0.491576,-0.159588,0,2.51174e-9,0.308782,0.951133,0,-33.079,-33.4874,-21.0835,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'fa8b41d6-b611-47ca-acf8-4318b9074c9e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/computedocclusion_b903dd27-411a-4a7c-b357-1cc9a414dbdd/17_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_b903dd27-411a-4a7c-b357-1cc9a414dbdd_TOPLY__ZIP_','2022-02-12 16:54:19','2022-02-12 17:53:18','17_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-02-12 17:54:19','SYNCED','fa8b41d6-b611-47ca-acf8-4318b9074c9e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.17.1.1.1 Occlusion 7\",\"modelMatrix\":\"0.149253,0.920186,-0.361913,0,-0.988799,0.138896,-0.0546284,0,-8.90892e-10,0.366013,0.93061,0,-24.4594,-29.735,-12.8678,1\",\"referenceScanID\":\"1.17.1.1.1\",\"title\":\"Maxillaire 1.17.1.1.1 Occlusion 7\"}'),(2,'faab790e-f6a2-461e-be74-c3af932ec546','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a4b302c-278d-4e12-ace5-f095ba0bf856/session_6206892a-2e7e-4765-ac90-b49bfb465997/occlusion_3c30231c-7cd7-4431-985b-2eaf7f6925ae/scan_b42f4445-ea70-4de5-bf5c-892a7b6eaa24/3_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_b42f4445-ea70-4de5-bf5c-892a7b6eaa24_ZIP_','2022-09-06 09:17:49','2022-08-30 10:57:24','3_w1_o1_maxillaire_scan_file_0.zip','2022-09-06 11:17:49','SYNCED','faab790e-f6a2-461e-be74-c3af932ec546',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.3.1.1.5\",\"modelMatrix\":\"0.797969,0.575965,-0.177509,0,-0.602698,0.762575,-0.235021,0,1.5203e-09,0.294523,0.955644,0,-29.1176,-8.59099,-15.2129,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'fb2afa86-ebd5-4360-a84e-10047e56c6e5','','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_BOSC_a1a9cef4-72fe-4dbe-928c-3831f98ecfbc_SNAPS_','2022-02-19 17:53:25','2022-02-18 17:00:42','','2022-02-19 18:53:25','SYNCED','fb2afa86-ebd5-4360-a84e-10047e56c6e5',0,'2022-02-19 18:53:25','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.4.4\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'fb514e0a-4a68-4572-a981-ab7aef579399','','MATRX','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_f9e18676-d6bb-44e8-b093-43cb88b0d897_TOMA__MATRX_','2022-05-16 17:54:27','2022-05-16 19:53:29','','2022-05-16 19:54:27','SYNCED','fb514e0a-4a68-4572-a981-ab7aef579399',0,'2022-05-16 19:54:27','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.24.1.1.2 Occlusion 6\",\"referenceScanID\":\"1.24.1.1.2\",\"title\":\"Matrice Transfo. Maxillaire 1.24.1.1.2 Occlusion 6\"}'),(1001,'fb634fbc-4a12-4143-995a-30444e0920d5','','SNAPS','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_812fdd67-c9dc-4e0c-806a-0524a386b296_SNAPO__SNAPS_','2022-02-07 17:55:14','2022-02-07 18:54:30','',NULL,'CREATED','fb634fbc-4a12-4143-995a-30444e0920d5',0,'2022-02-07 18:55:14','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'fbf04e83-58dc-469d-8763-1e36a647f311','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_be8c90b6-055f-49b1-a5b6-cb782162d6cd/12_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_be8c90b6-055f-49b1-a5b6-cb782162d6cd_ZIP_','2022-02-04 12:36:39','2022-02-04 13:36:25','12_w1_o1_mandibule_scan_file_1.zip','2022-02-04 13:36:39','SYNCED','db484565-ee6f-4ebd-803a-ec8279d42cae',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.6\",\"modelMatrix\":\"0.960486,0.0347405,0.276151,0,0.278327,-0.119887,-0.952975,0,-8.55259e-10,0.992179,-0.124819,0,-10.7024,-4.92831,-8.67978,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'fc23e160-140e-4487-95b2-8256f03caa90','','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_BOSC_a1a9cef4-72fe-4dbe-928c-3831f98ecfbc_ZIP_','2022-02-19 17:53:25','2022-02-18 17:01:38','','2022-02-19 18:53:25','SYNCED','1f9724a7-2075-47b0-8aee-e88fec576ca0',1,'2022-02-19 18:53:25','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.4.4\",\"modelMatrix\":\"-0.161823,-0.983125,0.0853169,0,0.98682,-0.161217,0.0139907,0,1.50433e-09,0.0864564,0.996256,0,0.0443673,-1.75233,-25.0718,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'fc59d0dc-0943-467d-8352-a0f7755dbb8d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7f47fd88-9ea0-4c08-9193-a54d4f158c7c/session_7873a396-419c-4215-83c7-fec9f2742ccf/occlusion_2f21aacc-dc8f-459b-b89b-bd548ffc070d/scan_410077c0-79fe-4e07-b332-33923a495579/16_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_7f47fd88-9ea0-4c08-9193-a54d4f158c7c_ACT_7873a396-419c-4215-83c7-fec9f2742ccf_SESS_2f21aacc-dc8f-459b-b89b-bd548ffc070d_BOSC_410077c0-79fe-4e07-b332-33923a495579_ZIP_','2022-02-03 10:10:12','2022-02-03 11:09:58','16_w1_o1_mandibule_scan_file_0.zip','2022-02-03 11:10:12','SYNCED','fc59d0dc-0943-467d-8352-a0f7755dbb8d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.16.1.1.1\",\"modelMatrix\":\"-0.998404,-0.0400837,0.039781,0,0.0564733,-0.70865,0.703297,0,2.73067e-9,0.704421,0.709782,0,24.7943,-23.9674,-19.2602,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'fcc6273d-cb7c-4147-af7d-dc19391b2f5d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/4a3954e0-1e2f-4721-9fdd-4180380dc19f/session_33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416/occlusion_3accbada-5a51-4d10-88d1-c3e7d8598d6f/scan_5b8f2ae7-343d-4058-ad87-94f21d555fc8/34_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_4a3954e0-1e2f-4721-9fdd-4180380dc19f_ACT_33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416_SESS_3accbada-5a51-4d10-88d1-c3e7d8598d6f_LESC_5b8f2ae7-343d-4058-ad87-94f21d555fc8_ZIP_','2022-06-28 10:55:54','2022-06-28 12:55:43','34_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-06-28 12:55:54','SYNCED','fcc6273d-cb7c-4147-af7d-dc19391b2f5d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.34.1.1.1\",\"modelMatrix\":\"-0.999319,-0.0330582,0.0141399,0,0.0337212,-0.997499,0.0617378,0,0.0153684,0.0624693,0.997998,0,-10.3441,-5.62721,-16.36,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'fccdc302-ad1b-447a-b86e-8f65d743a2b8','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/d100e894-0be9-4495-94e2-e469232f7817/session_2c8b85b5-c805-4b08-85e7-3d02dab72e99/occlusion_8a278cc5-a1c1-4dfb-9ee2-c971a6309afa/scan_aa48ecdd-c861-41de-8796-655dc3852c64/15_w1_o1_mordu_anterieur_snapshot_1.png','SNAPS','PATIENT_d100e894-0be9-4495-94e2-e469232f7817_ACT_2c8b85b5-c805-4b08-85e7-3d02dab72e99_SESS_8a278cc5-a1c1-4dfb-9ee2-c971a6309afa_FRSC_aa48ecdd-c861-41de-8796-655dc3852c64_SNAPS_','2022-02-01 15:14:55','2022-02-01 16:14:45','15_w1_o1_mordu_anterieur_snapshot_1.png','2022-02-01 16:14:55','SYNCED','7a692e33-2ad7-4ef5-aed9-90e94767f73c',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.15.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'fd2cdb61-10d1-473a-8f64-34748ad30304','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/scan_03839278-13f8-46e6-9581-ba11bc8bcb81/1_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_TOSC_03839278-13f8-46e6-9581-ba11bc8bcb81_SNAPS_','2022-01-19 12:59:28','2022-01-19 10:32:02','1_w1_o1_maxillaire_snapshot_1.png','2022-01-19 13:59:28','SYNCED','99c7b58b-6259-4c43-ac2f-8b7f47f0b3e7',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.1.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'fd42880d-e255-4b8b-a78f-08b855431609','','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_OCC_e9a397c8-e329-4471-985b-0eb40ed458b0_BOPLY__ZIP_','2022-02-04 15:01:40','2022-02-04 14:50:30','','2022-02-04 16:01:40','SYNCED','fd42880d-e255-4b8b-a78f-08b855431609',0,'2022-02-04 16:01:40','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.990642,-0.135532,0.0161156,0,0.136487,0.983712,-0.11697,0,-9.70693e-10,0.118075,0.993005,0,-24.0456,-2.08013,-18.1911,1\",\"referenceScanID\":\"1.12.1.1.1\",\"title\":\"Mandibule 1.12.1.1.1 Occlusion 1\"}'),(1001,'fdb57445-483a-4c6d-abea-e77292f019f1','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/scan_2a38e9c2-6808-43f3-904a-decdb37d60d5/4_w1_o4_mandibule_snapshot_0.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_BOSC_2a38e9c2-6808-43f3-904a-decdb37d60d5_SNAPS_','2022-05-31 12:03:44','2022-05-31 14:03:34','4_w1_o4_mandibule_snapshot_0.png','2022-05-31 14:03:44','SYNCED','fdb57445-483a-4c6d-abea-e77292f019f1',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.4.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'fe44d179-8919-4503-b709-e7ff8b61138b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/occlusion_a2220645-c79d-4dda-b6cc-772384a4106b/scan_914fba31-85f1-4c6e-85e2-bacfd3c1770c/38_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_TOSC_914fba31-85f1-4c6e-85e2-bacfd3c1770c_SNAPS_','2022-07-12 11:04:03','2022-07-12 13:03:54','38_w1_o1_maxillaire_snapshot_0.png','2022-07-12 13:04:03','SYNCED','fe44d179-8919-4503-b709-e7ff8b61138b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.38.1.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'fe6be136-66d9-4519-810b-19985f1cab1d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_aa38e68a-4c1f-4e58-a176-2a4d533c35a0/24_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_LESC_aa38e68a-4c1f-4e58-a176-2a4d533c35a0_SNAPS_','2022-05-13 16:15:35','2022-05-13 18:15:33','24_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-05-13 18:15:35','SYNCED','fe6be136-66d9-4519-810b-19985f1cab1d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.24.1.1.2\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'fe7f7ae4-66d9-4cf2-9ae5-2a1d3d8f8566','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/order_d31038d5-f19d-49c8-ac30-c3ff15368799/4_w1_autre_prost_file_fe7f7ae4-66d9-4cf2-9ae5-2a1d3d8f8566_0.pdf','PDF','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_PROST_d31038d5-f19d-49c8-ac30-c3ff15368799_PDF_','2022-03-09 09:29:50','2022-03-09 10:29:49','4_w1_autre_prost_file_fe7f7ae4-66d9-4cf2-9ae5-2a1d3d8f8566_0.pdf','2022-03-09 10:29:50','SYNCED','fe7f7ae4-66d9-4cf2-9ae5-2a1d3d8f8566',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.4.1.3 AUTRE FICHE DE PROTHESE\",\"title\":\"Autre PDF\"}'),(1001,'fe809790-75be-4a2e-9d94-7358f686eecf','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/32710234-804f-46f5-899d-eed636f8a906/session_64c1427a-b91d-4675-94df-f36bd40e9b0f/occlusion_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a/scan_3954e24e-9220-452b-a8fa-b1fbde6ebcad/33_w2_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_32710234-804f-46f5-899d-eed636f8a906_ACT_64c1427a-b91d-4675-94df-f36bd40e9b0f_SESS_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a_BOSC_3954e24e-9220-452b-a8fa-b1fbde6ebcad_SNAPS_','2022-06-28 08:58:07','2022-06-28 10:57:58','33_w2_o1_mandibule_snapshot_0.png','2022-06-28 10:58:07','SYNCED','fe809790-75be-4a2e-9d94-7358f686eecf',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.33.2.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'fe88a495-d983-431f-8551-3e0e8c3fd862','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/scan_f4fff5f5-f728-44ae-ac48-f3e653594098/23_w1_o1_mordu_anterieur_scan_file_0.zip','ZIP','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_FRSC_f4fff5f5-f728-44ae-ac48-f3e653594098_ZIP_','2022-05-13 10:11:33','2022-05-13 12:11:24','23_w1_o1_mordu_anterieur_scan_file_0.zip','2022-05-13 12:11:33','SYNCED','fe88a495-d983-431f-8551-3e0e8c3fd862',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.23.1.1.1\",\"modelMatrix\":\"0.956904,0.0895054,0.281619,0,-0.0680922,0.996142,-0.0209514,0,-0.282628,0.0155317,0.95949,0,-2.27242,-4.61322,-27.6547,1\",\"title\":\"Mordu anterieur ZIP\"}'),(1001,'feac0ac0-84e3-4f77-9c7a-9d39da528b7b','','ZIP','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_c9079d19-8ffb-46f7-a51e-3a7a90ccae59_SESS_8ba0f3b1-408f-4a02-92a0-63f09123b68e_TOSC_44c8d5b1-b2de-4ba6-8ae5-8bc2a88e7918_ZIP_','2022-01-28 17:15:47','2022-01-27 14:22:56','','2022-01-28 18:15:47','SYNCED','99207aa8-492a-4329-8b5e-927534c1602d',1,'2022-01-28 18:15:47','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.10.1.1.3\",\"modelMatrix\":\"0.957201,0.279088,-0.0766582,0,-0.289425,0.923015,-0.253528,0,-5.64059e-9,0.264864,0.964286,0,-23.452,-0.94464,-20.6174,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'fefd8fca-ff85-408e-98c7-8fe4546323dc','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/scan_999aa1db-d517-4b25-8095-2a4a53e4d5af/4_w1_o4_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_FRSC_999aa1db-d517-4b25-8095-2a4a53e4d5af_SNAPS_','2022-05-31 12:07:26','2022-05-31 14:07:19','4_w1_o4_mordu_anterieur_snapshot_0.png','2022-05-31 14:07:26','SYNCED','fefd8fca-ff85-408e-98c7-8fe4546323dc',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.4.1.4.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'ff0fa2f4-c2ea-42f1-a9f5-24c597282c66','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/e922efb9-8c03-445b-8a0f-449e3c43bdca/session_a2369349-1629-40ad-8784-d271bc3fbade/occlusion_292cc1aa-8b12-463b-87a1-7d9731cf886b/computedocclusion_f9f6d9d2-cc34-43c3-9f5f-4b8e54b41bbb/21_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_e922efb9-8c03-445b-8a0f-449e3c43bdca_ACT_a2369349-1629-40ad-8784-d271bc3fbade_SESS_292cc1aa-8b12-463b-87a1-7d9731cf886b_OCC_f9f6d9d2-cc34-43c3-9f5f-4b8e54b41bbb_TOPLY__ZIP_','2022-04-21 08:53:14','2022-04-21 10:53:03','21_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-04-21 10:53:14','SYNCED','ff0fa2f4-c2ea-42f1-a9f5-24c597282c66',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.21.1.1.1 Occlusion 2\",\"modelMatrix\":\"0.849212,0.517954,-0.10277,0,-0.528051,0.832974,-0.165274,0,8.96425e-09,0.19462,0.980879,0,-9.21476,-26.546,-17.5027,1\",\"referenceScanID\":\"1.21.1.1.1\",\"title\":\"Maxillaire 1.21.1.1.1 Occlusion 2\"}'),(1001,'ff57c19c-ecf6-4a09-a5d4-53813aeb4259','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_55f73d72-8321-42ec-88c8-d2988eeca0de/24_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_TOSC_55f73d72-8321-42ec-88c8-d2988eeca0de_ZIP_','2022-05-13 13:58:49','2022-05-13 15:58:35','24_w1_o1_maxillaire_scan_file_0.zip','2022-05-13 15:58:49','SYNCED','ff57c19c-ecf6-4a09-a5d4-53813aeb4259',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.1\",\"modelMatrix\":\"-0.664301,0.739768,-0.106997,0,-0.747465,-0.657459,0.0950925,0,-2.95103e-09,0.143147,0.989702,0,-2.99497,-15.0747,-18.5223,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'ff86122f-338e-4008-a6e7-f802a3e88e36','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/452a5200-3e06-4b74-8949-6abc7f2dda8a/session_3e95d626-668f-45f7-98ad-be2cf9d7b90b/occlusion_bce8310f-eee9-4f0a-a6b7-d592dec66be5/scan_bd194eb4-5c69-43b1-94bb-66c7ae8aa0ce/26_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_452a5200-3e06-4b74-8949-6abc7f2dda8a_ACT_3e95d626-668f-45f7-98ad-be2cf9d7b90b_SESS_bce8310f-eee9-4f0a-a6b7-d592dec66be5_BOSC_bd194eb4-5c69-43b1-94bb-66c7ae8aa0ce_SNAPS_','2022-05-24 09:15:02','2022-05-24 11:15:00','26_w1_o1_maxillaire_snapshot_0.png','2022-05-24 11:15:02','SYNCED','ff86122f-338e-4008-a6e7-f802a3e88e36',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.26.1.1.2\",\"title\":\"Mandibule SNAPSHOT\"}');
/*!40000 ALTER TABLE `CondorFile` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8mb3_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `CondorFile_BEFORE_DELETE` BEFORE DELETE ON `CondorFile` FOR EACH ROW BEGIN
  UPDATE Session SET mandibuleOcclusionPlyID = NULL
  WHERE ownerID = OLD.ownerID AND mandibuleOcclusionPlyID = OLD.id;

  UPDATE Session SET mandibuleOcclusionStlID = NULL
  WHERE ownerID = OLD.ownerID AND mandibuleOcclusionStlID = OLD.id;

  UPDATE Session SET maxillaireOcclusionPlyID = NULL
  WHERE ownerID = OLD.ownerID AND maxillaireOcclusionPlyID = OLD.id;

  UPDATE Session SET maxillaireOcclusionStlID = NULL
  WHERE ownerID = OLD.ownerID AND maxillaireOcclusionStlID = OLD.id;

  UPDATE Session SET mandibuleOcclusionPointContactID = NULL
  WHERE ownerID = OLD.ownerID AND mandibuleOcclusionPointContactID = OLD.id;

  UPDATE Session SET maxillaireOcclusionPointContactID = NULL
  WHERE ownerID = OLD.ownerID AND maxillaireOcclusionPointContactID = OLD.id;

  UPDATE Session SET matrixTransformationMandibuleID = NULL
  WHERE ownerID = OLD.ownerID AND matrixTransformationMandibuleID = OLD.id;

  UPDATE Session SET matrixTransformationMaxillaireID = NULL
  WHERE ownerID = OLD.ownerID AND matrixTransformationMaxillaireID = OLD.id;

  UPDATE Session SET snapshotID = NULL
  WHERE ownerID = OLD.ownerID AND snapshotID = OLD.id;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `Config`
--

DROP TABLE IF EXISTS `Config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Config` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `fullRetrieve` tinyint(1) DEFAULT '0',
  `syncEnabled` tinyint(1) DEFAULT '1',
  `showOcclusionScan` tinyint(1) DEFAULT '1',
  `showOpenStlWarning` tinyint(1) DEFAULT '1',
  `showMarginLinesWarning` tinyint(1) DEFAULT '1',
  `showDeleteConfirmation` tinyint(1) DEFAULT '1',
  `showSyncInfo` tinyint(1) DEFAULT '1',
  `downloadAtFullRetrieve` tinyint(1) DEFAULT '1',
  `lagSound` tinyint(1) DEFAULT '0',
  `lostSound` tinyint(1) DEFAULT '0',
  `emailNotifications` tinyint(1) DEFAULT '1',
  `logout` mediumint DEFAULT '10',
  `language` varchar(2) DEFAULT NULL,
  `flipMaxillaryH` tinyint(1) DEFAULT '0',
  `flipMaxillaryV` tinyint(1) DEFAULT '0',
  `flipMandibleH` tinyint(1) DEFAULT '0',
  `flipMandibleV` tinyint(1) DEFAULT '0',
  `showFlipPopupMaxillary` tinyint(1) DEFAULT '1',
  `showFlipPopupMandible` tinyint(1) DEFAULT '1',
  `enableUserSharing` tinyint(1) DEFAULT '1',
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `diagnosticMode` tinyint(1) DEFAULT '0',
  `repairMode` tinyint(1) DEFAULT '0',
  `lostTrackingRectangle` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Config_Professional` (`ownerID`),
  CONSTRAINT `fk_Config_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Config`
--

LOCK TABLES `Config` WRITE;
/*!40000 ALTER TABLE `Config` DISABLE KEYS */;
INSERT INTO `Config` VALUES (1,1,0,1,1,1,1,1,1,1,1,1,1,10,'fr',0,0,0,0,1,1,0,'2022-06-21 09:44:19','2022-06-21 07:44:19','2022-06-21 09:44:19',0,0,1),(2,1,0,1,1,1,1,1,1,0,0,0,1,999,'fr',0,0,0,0,1,1,0,'2022-08-03 15:19:49','2022-08-03 13:19:49','2022-08-03 15:19:49',0,0,1),(3,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2022-08-03 14:09:52','2022-08-03 12:09:52','2022-08-03 14:09:51',0,0,1),(5,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-07-02 11:04:44',0,0,1),(6,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-07-02 11:05:21',0,0,1),(7,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-07-02 11:06:14',0,0,1),(8,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-07-02 11:06:33',0,0,1),(9,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-07-02 11:07:02',0,0,1),(28,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-07-15 10:57:02',0,0,1),(33,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-07-15 14:34:40',0,0,1),(59,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-07-17 14:12:08',0,0,1),(71,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-07-18 08:47:55',0,0,1),(155,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-07-31 12:21:56',0,0,1),(172,1,0,1,1,1,1,1,1,1,0,0,1,999,'fr',0,0,0,0,1,1,0,'2020-06-03 19:03:54','2020-06-03 17:03:54','2020-06-03 18:59:46',0,0,1),(177,1,0,1,1,1,1,1,1,1,0,0,1,990,'fr',0,0,0,0,1,1,0,'2021-03-05 17:04:59','2021-03-05 16:04:59','2021-03-05 17:04:59',0,0,1),(193,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-09-02 18:53:02',0,0,1),(224,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-09-09 15:29:44',0,0,1),(317,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-10-07 14:44:35',0,0,1),(339,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-10-11 20:04:31',0,0,1),(355,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-10-19 13:58:38',0,0,1),(375,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2020-01-02 14:50:32','2020-01-02 13:50:32','2020-01-02 14:50:31',0,0,1),(377,1,0,1,1,1,1,1,1,1,0,1,1,999,'fr',0,0,0,0,1,1,0,'2020-01-17 09:59:06','2020-01-17 08:59:06','2020-01-17 09:59:06',0,0,1),(421,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-11-25 11:28:35',0,0,1),(568,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2020-02-04 15:19:02','2020-02-04 14:19:02','2020-02-04 15:19:02',0,0,1),(652,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2020-03-12 14:49:16','2020-03-12 13:49:16','2020-03-12 14:49:16',0,0,1),(664,1,0,1,1,1,1,1,1,1,0,0,1,30,'fr',0,0,0,0,1,1,0,'2022-06-22 17:47:59','2022-06-22 15:47:59','2022-06-22 17:47:58',0,0,1),(681,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2020-05-29 09:10:28','2020-05-29 07:10:28','2020-05-29 09:10:28',0,0,1),(689,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2020-06-02 12:32:01','2020-06-02 10:32:01','2020-06-02 12:32:01',0,0,1),(722,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2020-07-28 20:37:10','2020-07-28 18:37:10','2020-07-28 20:37:09',0,0,1),(805,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2020-12-09 11:04:54','2020-12-09 10:04:54','2020-12-09 11:04:54',0,0,1),(838,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2021-01-22 14:37:07','2021-01-22 13:37:07','2021-01-22 14:37:07',0,0,1),(840,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2021-01-22 16:28:38','2021-01-22 15:28:38','2021-01-22 16:28:38',0,0,1),(850,1,0,1,1,1,1,1,1,1,0,0,1,999,'fr',0,0,0,0,1,1,0,'2022-06-21 09:47:07','2022-06-21 07:47:07','2022-06-21 09:47:06',0,0,1),(899,1,0,1,1,1,1,1,1,1,0,0,1,15,'fr',0,0,0,0,1,1,0,'2022-02-01 14:03:05','2022-02-01 13:03:05','2022-02-01 14:03:04',0,0,1),(916,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2021-04-28 14:05:53','2021-04-28 12:05:53','2021-04-28 14:05:53',0,0,1),(917,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2021-04-28 14:53:31','2021-04-28 12:53:31','2021-04-28 14:53:31',0,0,1),(918,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2021-04-29 16:03:23','2021-04-29 14:03:23','2021-04-29 16:03:23',0,0,1),(941,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2021-06-07 14:52:03','2021-06-07 12:52:03','2021-06-07 14:52:03',0,0,1),(979,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2021-10-26 20:44:12','2021-10-26 18:44:12','2021-10-26 20:44:12',0,0,1),(1001,1,0,1,1,1,1,1,1,0,0,0,1,10,'fr',0,0,0,0,1,1,0,'2022-01-19 10:08:56','2022-01-19 09:08:56','2022-01-19 10:08:55',0,0,1),(1002,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2022-01-19 14:02:15','2022-01-19 13:02:15','2022-01-19 14:02:15',0,0,1),(1003,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2022-01-19 14:18:14','2022-01-19 13:18:14','2022-01-19 14:18:14',0,0,1),(1004,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2022-01-19 14:32:52','2022-01-19 13:32:52','2022-01-19 14:32:52',0,0,1),(1005,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2022-01-19 14:38:49','2022-01-19 13:38:49','2022-01-19 14:38:49',0,0,1),(1006,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2022-01-19 14:41:15','2022-01-19 13:41:15','2022-01-19 14:41:15',0,0,1),(1007,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2022-01-19 14:44:27','2022-01-19 13:44:27','2022-01-19 14:44:27',0,0,1),(1055,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2022-06-17 17:21:32','2022-06-17 15:21:32','2022-06-17 17:21:32',0,0,1),(1068,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2022-07-20 11:30:20','2022-07-20 09:30:20','2022-07-20 11:30:20',0,0,1),(1069,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2022-07-20 12:23:33','2022-07-20 10:23:33','2022-07-20 12:23:33',0,0,1);
/*!40000 ALTER TABLE `Config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Contact`
--

DROP TABLE IF EXISTS `Contact`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Contact` (
  `ownerID` mediumint unsigned NOT NULL DEFAULT '0',
  `id` char(36) NOT NULL,
  `comments` text,
  `professionalID` mediumint unsigned NOT NULL,
  `officeID` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `status` enum('invitationSent','invitationReceived','accepted','rejected') DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  UNIQUE KEY `unique_contact_pro` (`ownerID`,`professionalID`),
  KEY `fk_Contact_Professionnal` (`ownerID`),
  KEY `fk_Contact_RefersTo` (`professionalID`),
  KEY `fk_Contact_Office` (`officeID`,`ownerID`),
  CONSTRAINT `fk_Contact_Office` FOREIGN KEY (`officeID`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Contact_Professionnal` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Contact_RefersTo` FOREIGN KEY (`professionalID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Contact`
--

LOCK TABLES `Contact` WRITE;
/*!40000 ALTER TABLE `Contact` DISABLE KEYS */;
INSERT INTO `Contact` VALUES (1001,'063b2598-9532-4c23-8632-dcb6eabfd800','',1001,NULL,NULL,'2022-10-07 09:52:00','2022-10-07 07:52:00','2022-01-19 10:08:49','accepted'),(2,'09445c09-6813-4c02-a2d8-597e200f19d6','',918,NULL,NULL,'2021-04-30 12:00:26','2021-04-30 10:00:26','2021-04-29 16:19:15','rejected'),(1001,'0aad257e-8c15-4d63-bc3b-eaa40de2ab9d','',689,NULL,NULL,'2022-01-19 14:19:11','2022-01-19 13:19:11','2022-01-19 14:19:11','rejected'),(2,'13b7bc85-543d-4b72-98de-8a1c59d6d91b','',177,NULL,NULL,'2021-11-12 14:01:56','2021-11-12 13:01:56','2021-09-22 10:20:35','rejected'),(2,'1418b81b-952d-4c95-a6be-d74e9dce3146','',5,NULL,NULL,'2021-04-21 14:26:48','2021-04-21 12:26:48','2019-07-08 15:47:14','accepted'),(1001,'1cf5633f-4276-4d42-b250-8261374eadf3','',6,NULL,NULL,'2022-01-19 14:19:05','2022-01-19 13:19:05','2022-01-19 14:19:05','rejected'),(1001,'20a6a17a-0b51-4f46-abff-a74bc9fe90e2','',1002,NULL,NULL,'2022-04-21 18:07:18','2022-04-21 16:07:18','2022-01-19 23:33:01','accepted'),(2,'24f6b3ed-92f7-4ac3-90af-eca51269434c','',838,NULL,NULL,'2021-04-29 16:19:16','2021-04-29 14:19:16','2021-04-29 16:19:16','rejected'),(1001,'25abc18a-3151-45ba-ae4a-281adc910cfa','',7,NULL,NULL,'2022-01-19 14:19:37','2022-01-19 13:19:37','2022-01-19 14:19:37','rejected'),(2,'28f7e34e-d2d9-411c-8ab3-d5ade71bf7cf','',6,NULL,NULL,'2019-07-26 06:43:50','2019-07-26 04:43:50','2019-07-08 15:47:14','accepted'),(2,'2e81aef5-1f9f-4961-ac42-12a07a248174','',899,NULL,NULL,'2022-09-03 14:19:29','2022-09-03 12:19:29','2021-10-12 14:15:29','invitationSent'),(2,'31ecedea-a5d4-4c31-91a1-431f8ab24ce7','',7,NULL,NULL,'2019-07-22 17:07:13','2019-07-22 15:07:13','2019-07-10 08:55:28','accepted'),(1001,'32f5ee73-396d-4587-a18b-0eb30283988e','',1007,NULL,NULL,'2022-01-19 14:44:28','2022-01-19 13:44:28','2022-01-19 14:44:27','invitationSent'),(2,'3f1e8647-e9a2-47dd-912c-d07a3ec2395e','',689,NULL,NULL,'2020-11-03 11:22:16','2020-11-03 10:22:16','2020-11-03 11:22:16','accepted'),(2,'46be3f53-48f5-43f2-8612-6bde541a8563','',3,NULL,NULL,'2022-08-03 14:11:48','2022-08-03 12:11:48','2019-07-03 09:49:55','accepted'),(1001,'50f7816a-f709-4b13-8ca4-9a488ef49bc3','',9,NULL,NULL,'2022-01-19 14:19:19','2022-01-19 13:19:19','2022-01-19 14:19:19','rejected'),(2,'58cd65c8-f596-48dc-a3e8-edf285a261d0','',355,NULL,NULL,'2020-07-10 10:30:44','2020-07-10 08:30:44','2020-02-12 11:06:25','accepted'),(2,'5a6cbc1d-3301-430e-a148-dacf698e04c1','',917,NULL,NULL,'2022-07-25 15:18:20','2022-07-25 13:18:20','2022-07-25 15:18:20','invitationSent'),(2,'7072c8ee-9f1e-4c66-b352-fdcadde0179f','',681,NULL,NULL,'2021-01-22 14:02:32','2021-01-22 13:02:32','2021-01-22 14:02:31','invitationSent'),(2,'70dd62c9-f43b-4878-a303-d6ef02077da6','',28,NULL,NULL,'2021-07-19 20:03:49','2021-07-19 18:03:49','2021-03-18 16:09:12','accepted'),(1001,'7167d8e6-01b3-425c-b437-c531690310a9','',8,NULL,NULL,'2022-01-19 14:19:24','2022-01-19 13:19:24','2022-01-19 14:19:24','rejected'),(2,'7b570538-d037-4c4d-aa87-e5bc533194f8','',1069,NULL,NULL,'2022-07-21 15:32:36','2022-07-21 13:32:36','2022-07-20 12:24:51','rejected'),(2,'7bfba8d7-dea9-4a5f-8929-13f2e61c1e5f','',722,NULL,NULL,'2022-09-06 11:28:03','2022-09-06 09:28:03','2022-03-14 16:16:00','accepted'),(1001,'7c99ac69-2895-4cbf-bc02-0d37da72256f','',1003,NULL,NULL,'2022-09-15 16:44:03','2022-09-15 14:44:03','2022-03-10 12:24:48','accepted'),(2,'845121ab-bd3d-460f-8459-afc674d99362','',8,NULL,NULL,'2019-07-22 19:36:25','2019-07-22 17:36:25','2019-07-08 15:47:14','accepted'),(1001,'89005fae-6c70-490f-8c2e-da16d56b2706','',1005,NULL,NULL,'2022-01-19 14:40:47','2022-01-19 13:40:47','2022-01-19 14:40:47','rejected'),(2,'8cbeba91-0f78-43e6-9ac8-00c828dc7b11','',375,NULL,NULL,'2022-05-23 19:20:34','2022-05-23 17:20:34','2020-02-04 14:48:36','accepted'),(2,'93ad4d00-b810-418e-ab4f-5f38046486cd','',1,NULL,NULL,'2022-06-21 09:44:25','2022-06-21 07:44:25','2019-11-25 11:21:43','accepted'),(2,'9648ff49-e522-44ba-9b8f-93895ee57d2b','',224,NULL,NULL,'2019-09-09 15:53:45','2019-09-09 13:53:45','2019-09-09 15:53:45','accepted'),(2,'99c73d5d-e50b-4a8e-a4b4-60fd2150b020','',317,NULL,NULL,'2020-06-15 15:54:53','2020-06-15 13:54:53','2019-12-09 11:58:51','accepted'),(2,'a0328b57-7e5d-4cd5-bc41-fb03b3636761','',1055,NULL,NULL,'2022-06-17 17:28:41','2022-06-17 15:28:41','2022-06-17 17:21:32','invitationSent'),(2,'a2cd44fa-b826-4e8a-99ce-1512ee17ddad','',664,NULL,NULL,'2022-08-24 20:09:47','2022-08-24 18:09:47','2022-04-14 15:16:05','rejected'),(2,'a55f3306-73a9-4861-b3fe-1b6011c849be','',941,NULL,NULL,'2021-06-07 14:56:56','2021-06-07 12:56:56','2021-06-07 14:56:56','rejected'),(2,'a6c317c0-5772-4c0a-9fa8-0cef815f4fad','',193,NULL,NULL,'2019-09-30 10:43:33','2019-09-30 08:43:33','2019-09-30 10:43:33','accepted'),(2,'a88f9aab-189e-4afc-9061-d199ad98f624','',805,NULL,NULL,'2021-04-28 14:39:58','2021-04-28 12:39:58','2021-04-28 14:39:57','invitationSent'),(2,'b26a32ea-ad6e-4f46-ae5d-f2f4a2af39ad','',155,NULL,NULL,'2020-07-01 10:29:24','2020-07-01 08:29:24','2019-08-27 15:24:41','accepted'),(2,'b29c282c-29a0-4337-bcae-a9998bf3da31','',916,NULL,NULL,'2022-07-25 15:42:13','2022-07-25 13:42:13','2022-07-25 15:22:29','rejected'),(2,'b4ad1a45-0211-4995-8543-ad852af15ce4','',568,NULL,NULL,'2020-02-04 15:20:30','2020-02-04 14:20:30','2020-02-04 15:19:02','invitationSent'),(2,'b6f285f2-0b59-4029-af8d-7e012de06045','',33,NULL,NULL,'2021-04-29 16:00:33','2021-04-29 14:00:33','2021-04-29 16:00:33','rejected'),(2,'be0d2da1-7bc2-4d9b-8280-6c727d2edfb6','',840,NULL,NULL,'2021-04-28 14:07:58','2021-04-28 12:07:58','2021-04-28 14:07:58','rejected'),(2,'c1218792-ad28-4579-b60d-ea36735880b7','',652,NULL,NULL,'2020-03-12 14:49:30','2020-03-12 13:49:30','2020-03-12 14:49:30','rejected'),(1001,'c169a275-0f4b-4fd7-ab1a-f40049ebd80d','',1006,NULL,NULL,'2022-01-19 14:44:00','2022-01-19 13:44:00','2022-01-19 14:41:16','invitationSent'),(2,'c221cdda-dad2-4ee8-99ec-d3097c841b68','',850,NULL,NULL,'2022-09-05 16:57:03','2022-09-05 14:57:03','2021-03-04 12:12:18','invitationSent'),(2,'c571c887-8c1f-4576-a747-36c26c3f6338','',172,NULL,NULL,'2022-03-06 18:01:46','2022-03-06 17:01:46','2019-12-17 15:10:34','accepted'),(1001,'c6c581ca-2ddb-4df9-8b5e-c0d70eb06d52','',1004,NULL,NULL,'2022-01-19 14:36:23','2022-01-19 13:36:23','2022-01-19 14:32:52','invitationSent'),(2,'c81b77de-6fb5-449b-8f09-78f75eedcd8c','',377,NULL,NULL,'2020-03-12 14:51:08','2020-03-12 13:51:08','2020-03-12 14:51:08','rejected'),(2,'d07578fc-3c54-49d7-a3eb-b581d2107f68','',2,NULL,NULL,'2022-09-06 11:28:31','2022-09-06 09:28:31','2019-07-01 08:54:35','accepted'),(2,'d6009fb8-cb91-4de4-9718-0e40048b745d','',1068,NULL,NULL,'2022-07-20 11:37:16','2022-07-20 09:37:16','2022-07-20 11:37:16','rejected'),(2,'e72f7319-b4e1-4049-aa99-f124db5c5af8','',9,NULL,NULL,'2020-01-24 14:39:37','2020-01-24 13:39:37','2019-07-08 15:47:14','accepted'),(1001,'e99aa607-7e81-4efd-aff1-7b2465e11210','',5,NULL,NULL,'2022-01-19 10:08:49','2022-01-19 09:08:49','2022-01-19 10:08:49','accepted'),(1001,'ea9c5639-4c6b-4ee0-b9a9-0a82b455c61b','',71,NULL,NULL,'2022-01-19 14:16:51','2022-01-19 13:16:51','2022-01-19 14:16:51','accepted'),(2,'f4ec0f13-701b-4afa-bdc6-8759982358c2','',339,NULL,NULL,'2019-10-15 10:41:49','2019-10-15 08:41:49','2019-10-15 10:41:49','accepted'),(2,'f590073f-6720-4045-807a-0a3b1ea8c91d','',421,NULL,NULL,'2021-05-03 12:01:37','2021-05-03 10:01:37','2021-05-03 11:13:01','accepted'),(1001,'fa6a418a-2908-463a-bd38-9f55ff81de84','',979,NULL,NULL,'2022-05-25 16:24:32','2022-05-25 14:24:32','2022-05-25 16:24:32','accepted'),(2,'fb3b468c-a371-4911-b472-a2869911ccef','',59,NULL,NULL,'2019-09-05 17:29:34','2019-09-05 15:29:34','2019-09-05 17:20:56','accepted');
/*!40000 ALTER TABLE `Contact` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ContactNotification`
--

DROP TABLE IF EXISTS `ContactNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ContactNotification` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `contactID` char(36) DEFAULT NULL,
  `rescueDisplayName` varchar(50) DEFAULT NULL,
  `event` enum('received','received_to_accepted','received_to_rejected','sent_to_accepted','sent_to_rejected','activation_timeout') NOT NULL DEFAULT 'received',
  `unread` tinyint(1) NOT NULL DEFAULT '1',
  `createdAt` datetime NOT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_ContactNotification_Professional` (`ownerID`),
  KEY `fk_ContactNotification_Contact` (`contactID`,`ownerID`),
  CONSTRAINT `fk_ContactNotification_Contact` FOREIGN KEY (`contactID`, `ownerID`) REFERENCES `Contact` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_ContactNotification_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ContactNotification`
--

LOCK TABLES `ContactNotification` WRITE;
/*!40000 ALTER TABLE `ContactNotification` DISABLE KEYS */;
INSERT INTO `ContactNotification` VALUES (1001,'4eb20b41-8483-474d-b75d-91595bf0a1fa','7c99ac69-2895-4cbf-bc02-0d37da72256f','Olivier DREUX','sent_to_accepted',0,'2022-03-10 12:24:48',NULL,'2022-05-25 16:02:08','2022-05-25 16:02:08','2022-05-25 14:02:08'),(2,'586c7e05-0e1a-4e96-b07d-1b8e45795888','b29c282c-29a0-4337-bcae-a9998bf3da31','alex wetting','sent_to_accepted',0,'2022-07-25 15:20:56',NULL,'2022-07-25 15:44:28','2022-07-25 15:20:56','2022-07-25 13:44:28'),(1001,'6e0f799f-6498-4603-9f94-5939fcd85f30','fa6a418a-2908-463a-bd38-9f55ff81de84','Brice Lacordaire','sent_to_accepted',0,'2022-05-25 16:24:32',NULL,'2022-05-25 16:24:48','2022-05-25 16:24:48','2022-05-25 14:24:48'),(2,'8fd30016-5a5b-4494-b933-90857012645a','7b570538-d037-4c4d-aa87-e5bc533194f8','LABELDENT TOULOUSE Laboratoire','sent_to_rejected',0,'2022-07-20 12:24:51',NULL,'2022-07-25 15:44:28','2022-07-20 12:24:51','2022-07-25 13:44:28'),(1001,'ed3644c5-4ccf-44e7-bf3c-0c12e1f76a9b','ea9c5639-4c6b-4ee0-b9a9-0a82b455c61b','Protilab Protilab','sent_to_accepted',0,'2022-01-19 14:16:51',NULL,'2022-01-19 14:47:46','2022-01-19 14:47:45','2022-01-19 13:47:46'),(1001,'ed94ed09-c77a-4fdb-9ea8-f1838734756f','20a6a17a-0b51-4f46-abff-a74bc9fe90e2','SEBASTIEN SEBASTIEN CHARMEUX','sent_to_accepted',0,'2022-01-19 23:33:01',NULL,'2022-01-20 20:43:17','2022-01-20 20:43:16','2022-01-20 19:43:17');
/*!40000 ALTER TABLE `ContactNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Credentials`
--

DROP TABLE IF EXISTS `Credentials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Credentials` (
  `id` char(36) NOT NULL DEFAULT '',
  `login` varchar(64) NOT NULL,
  `password` varchar(100) DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `un_Login` (`login`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Credentials`
--

LOCK TABLES `Credentials` WRITE;
/*!40000 ALTER TABLE `Credentials` DISABLE KEYS */;
INSERT INTO `Credentials` VALUES ('00000002-0000-0000-0000-000000000001','prod.sav','42adacbb60e86b5b5b63ea4fb9acc56aec15bf966e1cdeffa5d89c176892e8cf',NULL,'2022-09-06 09:17:30'),('00001001-0000-0000-0000-000000000001','SELARL MAIGRET','d923f3881f966fc93fff41e52282f94b7d5c0b69fd899a26cb7136a9bdc28894',NULL,'2022-10-07 07:21:30');
/*!40000 ALTER TABLE `Credentials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Discussion`
--

DROP TABLE IF EXISTS `Discussion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Discussion` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `selfImplied` tinyint(1) NOT NULL DEFAULT '0',
  `officeID` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Discussion_Professional` (`ownerID`),
  KEY `fk_Discussion_Office` (`officeID`,`ownerID`),
  CONSTRAINT `fk_Discussion_Office` FOREIGN KEY (`officeID`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Discussion_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Discussion`
--

LOCK TABLES `Discussion` WRITE;
/*!40000 ALTER TABLE `Discussion` DISABLE KEYS */;
INSERT INTO `Discussion` VALUES (1,'3bb3ca53-cf49-4698-9658-df729e5c5f9e',0,NULL,NULL,NULL,'2021-12-24 12:42:50','2021-12-24 13:42:50'),(2,'3bb3ca53-cf49-4698-9658-df729e5c5f9e',0,NULL,NULL,'2022-01-04 18:22:05','2022-01-04 17:22:05','2019-11-25 11:23:31'),(1001,'4d12bcc3-80f2-49dc-9159-54929f160ce6',0,NULL,NULL,'2022-07-12 19:44:23','2022-07-12 17:44:23','2022-01-19 14:51:11'),(1002,'4d12bcc3-80f2-49dc-9159-54929f160ce6',0,NULL,NULL,NULL,'2022-01-19 13:51:11','2022-01-19 14:51:11'),(2,'521142fd-7283-4541-aa70-733ace90c112',0,NULL,NULL,'2021-05-14 13:25:24','2021-05-14 11:25:24','2019-09-04 15:44:10'),(3,'521142fd-7283-4541-aa70-733ace90c112',0,NULL,NULL,NULL,'2021-12-24 12:42:50','2021-12-24 13:42:50'),(2,'5cde9543-ba84-400d-ae2b-8c834d912266',0,NULL,NULL,'2021-02-12 15:21:28','2021-02-12 14:21:28','2019-12-17 15:11:56'),(172,'5cde9543-ba84-400d-ae2b-8c834d912266',0,NULL,NULL,NULL,'2021-12-24 12:42:50','2021-12-24 13:42:50'),(2,'6885f3a8-c779-49e9-87ed-5d4c70e2ca06',0,NULL,NULL,'2019-09-30 17:16:23','2019-09-30 15:16:23','2019-09-30 11:17:48'),(193,'6885f3a8-c779-49e9-87ed-5d4c70e2ca06',0,NULL,NULL,NULL,'2021-12-24 12:42:50','2021-12-24 13:42:50'),(2,'a16198e0-da2f-45fe-97fb-93531b35cedb',1,NULL,NULL,'2022-09-06 11:21:34','2022-09-06 09:21:34','2019-07-01 17:37:26'),(2,'a18a6dc8-e71f-45cb-a7ad-b53500079bd4',0,NULL,NULL,'2019-09-12 16:13:26','2019-09-12 14:13:26','2019-09-09 16:10:00'),(224,'a18a6dc8-e71f-45cb-a7ad-b53500079bd4',0,NULL,NULL,NULL,'2021-12-24 12:42:50','2021-12-24 13:42:50'),(1001,'b7bd3e65-868f-46c5-9fcb-a956969c915b',0,NULL,NULL,'2022-07-25 14:40:46','2022-07-25 12:40:46','2022-07-06 12:07:00'),(1003,'b7bd3e65-868f-46c5-9fcb-a956969c915b',0,NULL,NULL,NULL,'2022-07-06 10:07:00','2022-07-06 12:07:00'),(2,'bdbff1f6-a77b-4ed9-8b95-fb64078e6edc',0,NULL,NULL,'2022-03-14 16:17:11','2022-03-14 15:17:11','2022-03-14 16:17:00'),(722,'bdbff1f6-a77b-4ed9-8b95-fb64078e6edc',0,NULL,NULL,NULL,'2022-07-28 12:06:53','2022-07-28 14:06:53'),(2,'be6e41b9-9ce8-4980-9ce7-be4b4450d1b3',0,NULL,NULL,'2022-04-29 14:50:48','2022-04-29 12:50:48','2019-09-05 17:30:24'),(59,'be6e41b9-9ce8-4980-9ce7-be4b4450d1b3',0,NULL,NULL,NULL,'2021-12-24 12:42:50','2021-12-24 13:42:50'),(979,'c751a124-f446-4f77-ae1f-151713493ae7',0,NULL,NULL,NULL,'2022-03-08 12:01:20','2022-03-08 13:01:20'),(1001,'c751a124-f446-4f77-ae1f-151713493ae7',0,NULL,NULL,'2022-05-27 14:44:31','2022-05-27 12:44:31','2022-03-08 13:01:20'),(71,'d88ad636-aad5-48a9-b3ac-93dc9837d792',0,NULL,NULL,NULL,'2022-05-25 11:20:15','2022-05-25 13:20:15'),(1001,'d88ad636-aad5-48a9-b3ac-93dc9837d792',0,NULL,NULL,'2022-05-27 15:25:38','2022-05-27 13:25:38','2022-05-25 13:20:15'),(2,'fe55386a-3ec2-4d00-bb80-02e0aec5e82f',0,NULL,NULL,'2019-09-03 10:19:11','2019-09-03 08:19:11','2019-08-27 15:25:58'),(155,'fe55386a-3ec2-4d00-bb80-02e0aec5e82f',0,NULL,NULL,NULL,'2021-12-24 12:42:50','2021-12-24 13:42:50');
/*!40000 ALTER TABLE `Discussion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Licence`
--

DROP TABLE IF EXISTS `Licence`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Licence` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `reference` varchar(45) DEFAULT NULL,
  `installKey` varchar(45) DEFAULT NULL,
  `activationDate` datetime DEFAULT NULL,
  `professionalID` mediumint unsigned NOT NULL,
  `cameraReference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`,`professionalID`),
  KEY `fk_Licence_Professional` (`professionalID`),
  CONSTRAINT `fk_Licence_Professional` FOREIGN KEY (`professionalID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Licence`
--

LOCK TABLES `Licence` WRITE;
/*!40000 ALTER TABLE `Licence` DISABLE KEYS */;
/*!40000 ALTER TABLE `Licence` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `MessageStatus`
--

DROP TABLE IF EXISTS `MessageStatus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `MessageStatus` (
  `ownerID` mediumint unsigned NOT NULL,
  `sentMessageID` char(36) NOT NULL,
  `contactID` char(36) NOT NULL,
  `status` enum('undelivered','delivered','transmitted') NOT NULL DEFAULT 'undelivered',
  `bcc` tinyint(1) NOT NULL DEFAULT '0',
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`sentMessageID`,`contactID`),
  KEY `fk_MessageStatus_SentMessage` (`sentMessageID`,`ownerID`),
  KEY `fk_MessageStatus_Contact` (`contactID`,`ownerID`),
  CONSTRAINT `fk_MessageStatus_Contact` FOREIGN KEY (`contactID`, `ownerID`) REFERENCES `Contact` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_MessageStatus_SentMessage` FOREIGN KEY (`sentMessageID`, `ownerID`) REFERENCES `SentMessage` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `MessageStatus`
--

LOCK TABLES `MessageStatus` WRITE;
/*!40000 ALTER TABLE `MessageStatus` DISABLE KEYS */;
INSERT INTO `MessageStatus` VALUES (2,'5e4892c0-1aa4-4bde-81d4-472ca5373648','d07578fc-3c54-49d7-a3eb-b581d2107f68','transmitted',0,'2022-09-06 09:21:34'),(1001,'01ac4bb0-ce03-44be-a97a-230edf030c67','7c99ac69-2895-4cbf-bc02-0d37da72256f','transmitted',0,'2022-07-25 12:40:45'),(1001,'0b9a9a9c-65cb-487d-aceb-036aed8a40c4','20a6a17a-0b51-4f46-abff-a74bc9fe90e2','transmitted',0,'2022-01-21 08:40:36'),(1001,'0c36ef86-6b38-4a2b-bc2d-9e650ac1b126','20a6a17a-0b51-4f46-abff-a74bc9fe90e2','transmitted',0,'2022-05-31 08:09:49'),(1001,'1867623e-8b65-4cce-a125-36dccd698680','20a6a17a-0b51-4f46-abff-a74bc9fe90e2','delivered',0,'2022-06-14 12:09:41'),(1001,'192a19f0-8bb0-42f0-8b73-8852839e51f1','20a6a17a-0b51-4f46-abff-a74bc9fe90e2','delivered',0,'2022-06-28 17:34:51'),(1001,'1a767aa4-c393-44dd-b68b-0be0e7c4f807','ea9c5639-4c6b-4ee0-b9a9-0a82b455c61b','transmitted',0,'2022-05-27 13:25:38'),(1001,'23471460-0eba-414d-919c-f438dab60c0e','20a6a17a-0b51-4f46-abff-a74bc9fe90e2','transmitted',0,'2022-05-31 08:09:48'),(1001,'2d5fc518-f8c5-4597-abbe-d93d423e0e16','fa6a418a-2908-463a-bd38-9f55ff81de84','delivered',0,'2022-05-25 14:26:13'),(1001,'30dad485-f7ea-45f0-9784-0606b7b4e27f','fa6a418a-2908-463a-bd38-9f55ff81de84','delivered',0,'2022-05-27 12:44:31'),(1001,'3315a657-e1b3-4b5e-9439-604889ff7a31','20a6a17a-0b51-4f46-abff-a74bc9fe90e2','transmitted',0,'2022-05-31 08:09:48'),(1001,'468c4cfe-1f69-48ec-83c2-c5f91162e49a','20a6a17a-0b51-4f46-abff-a74bc9fe90e2','delivered',0,'2022-06-28 17:28:45'),(1001,'4abb13b3-c67c-44ec-ba29-e1f6f06f53f5','20a6a17a-0b51-4f46-abff-a74bc9fe90e2','transmitted',0,'2022-06-14 07:27:05'),(1001,'506a2b0c-3283-491f-81ef-a5c7afb61d03','20a6a17a-0b51-4f46-abff-a74bc9fe90e2','transmitted',0,'2022-06-14 07:27:05'),(1001,'524eb417-8e09-488e-89f9-fcf908975e44','20a6a17a-0b51-4f46-abff-a74bc9fe90e2','transmitted',0,'2022-05-31 08:09:48'),(1001,'5334347c-4aa9-4833-99f6-40d6988556dd','20a6a17a-0b51-4f46-abff-a74bc9fe90e2','transmitted',0,'2022-05-31 08:09:49'),(1001,'5db226ec-0c8d-477f-8018-99e0c11dab59','20a6a17a-0b51-4f46-abff-a74bc9fe90e2','delivered',0,'2022-07-12 17:44:23'),(1001,'5dd32a88-dba5-4ef5-a30d-549596347bdd','fa6a418a-2908-463a-bd38-9f55ff81de84','delivered',0,'2022-05-27 12:44:30'),(1001,'5e7e0fa4-4cca-4c2f-aa2e-fb9ad00edc5d','20a6a17a-0b51-4f46-abff-a74bc9fe90e2','transmitted',0,'2022-05-31 08:09:48'),(1001,'71067748-1d04-41d4-9cce-1c6ea91c4821','fa6a418a-2908-463a-bd38-9f55ff81de84','delivered',0,'2022-05-27 12:44:29'),(1001,'7e64683b-ac83-4ff5-95a1-c86ac7ec9a1b','fa6a418a-2908-463a-bd38-9f55ff81de84','delivered',0,'2022-05-27 12:44:29'),(1001,'926f039a-c6f3-4ccc-b580-53dc8aa3d9fe','20a6a17a-0b51-4f46-abff-a74bc9fe90e2','delivered',0,'2022-06-28 17:31:32'),(1001,'95d845b0-eb98-48c0-afbe-cb5884290337','20a6a17a-0b51-4f46-abff-a74bc9fe90e2','transmitted',0,'2022-05-31 08:09:48'),(1001,'9ab6b817-d4c1-4866-9f23-07a898b5969b','20a6a17a-0b51-4f46-abff-a74bc9fe90e2','delivered',0,'2022-06-16 15:39:34'),(1001,'a339017d-5acb-4dbb-93db-2d99d2d379a6','20a6a17a-0b51-4f46-abff-a74bc9fe90e2','transmitted',0,'2022-01-21 08:40:37'),(1001,'a7581668-1afd-4b61-aade-956e013efa19','20a6a17a-0b51-4f46-abff-a74bc9fe90e2','transmitted',0,'2022-05-31 08:09:48'),(1001,'a7758839-f118-4a5a-a11e-3cfd860c3ece','fa6a418a-2908-463a-bd38-9f55ff81de84','delivered',0,'2022-05-27 12:44:28'),(1001,'b33c0113-608e-4359-a331-b141ed996aa9','20a6a17a-0b51-4f46-abff-a74bc9fe90e2','delivered',0,'2022-06-28 17:25:45'),(1001,'b3acf16d-687f-4a88-992b-d56583bb5e0e','20a6a17a-0b51-4f46-abff-a74bc9fe90e2','transmitted',0,'2022-05-31 08:09:48'),(1001,'b85098c0-3184-46f3-8f7f-59ea1d57475d','20a6a17a-0b51-4f46-abff-a74bc9fe90e2','transmitted',0,'2022-05-31 08:09:48'),(1001,'bfe2fdbe-397a-40db-b50f-311886285486','20a6a17a-0b51-4f46-abff-a74bc9fe90e2','transmitted',0,'2022-05-31 08:09:49'),(1001,'c06414cd-4982-4fd0-8e92-c5d72d3f92aa','20a6a17a-0b51-4f46-abff-a74bc9fe90e2','transmitted',0,'2022-01-26 13:42:06'),(1001,'c22a474b-0c0d-41e6-a724-66aa5f3a56b1','fa6a418a-2908-463a-bd38-9f55ff81de84','delivered',0,'2022-05-27 12:44:28'),(1001,'c8580070-df0b-409d-b97d-621467d29e66','20a6a17a-0b51-4f46-abff-a74bc9fe90e2','delivered',0,'2022-06-16 16:10:14'),(1001,'c9ccf5f2-c1e6-4dcc-bdc5-c15beff61900','20a6a17a-0b51-4f46-abff-a74bc9fe90e2','transmitted',0,'2022-05-31 08:09:48'),(1001,'ceb5e6af-6143-4afa-9760-7897751e9b6c','20a6a17a-0b51-4f46-abff-a74bc9fe90e2','transmitted',0,'2022-05-31 08:09:48'),(1001,'d04cd358-69c2-46d7-aa56-0cf63e2183b7','20a6a17a-0b51-4f46-abff-a74bc9fe90e2','delivered',0,'2022-06-14 17:10:42'),(1001,'d2a00c47-8df2-4c4f-8593-34c1b86b47cd','fa6a418a-2908-463a-bd38-9f55ff81de84','delivered',0,'2022-05-27 12:44:27'),(1001,'d90a6f22-babe-4443-9edc-5699f160bec4','20a6a17a-0b51-4f46-abff-a74bc9fe90e2','transmitted',0,'2022-06-14 07:27:05'),(1001,'e026d4b1-b8df-4282-9dc2-728e4658fcd2','20a6a17a-0b51-4f46-abff-a74bc9fe90e2','transmitted',0,'2022-01-26 13:42:06'),(1001,'ebbe1e2e-72a4-4582-a309-dbf2ec3fbdf9','20a6a17a-0b51-4f46-abff-a74bc9fe90e2','transmitted',0,'2022-05-31 08:09:48');
/*!40000 ALTER TABLE `MessageStatus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Occlusion`
--

DROP TABLE IF EXISTS `Occlusion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Occlusion` (
  `ownerID` mediumint unsigned NOT NULL DEFAULT '0',
  `id` char(36) NOT NULL,
  `sessionID` char(36) DEFAULT NULL,
  `occlusionType` enum('UNKNOWN','HEMI_ARCADE_POSTERIEUR_DROIT','HEMI_ARCADE_POSTERIEUR_GAUCHE','HEMI_ARCADE_ANTERIEUR','ARCADE_COMPLETE_ANTERIEUR','ARCADE_COMPLETE') DEFAULT 'HEMI_ARCADE_POSTERIEUR_DROIT',
  `deletedAt` datetime DEFAULT NULL,
  `createdAt` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `topScanID` char(36) DEFAULT NULL,
  `bottomScanID` char(36) DEFAULT NULL,
  `anteriorBiteScanID` char(36) DEFAULT NULL,
  `rightBiteScanID` char(36) DEFAULT NULL,
  `leftBiteScanID` char(36) DEFAULT NULL,
  `snapshotID` char(36) DEFAULT NULL,
  `mandibuleOcclusionPlyID` char(36) DEFAULT NULL,
  `maxillaireOcclusionPlyID` char(36) DEFAULT NULL,
  `matrixTransformationMandibuleID` char(36) DEFAULT NULL,
  `matrixTransformationMaxillaireID` char(36) DEFAULT NULL,
  `globalDisplayID` mediumint unsigned DEFAULT NULL,
  `displayID` mediumint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Occlusion_Session` (`sessionID`,`ownerID`),
  KEY `fk_Occlusion_topScan` (`topScanID`,`ownerID`),
  KEY `fk_Occlusion_bottomScan` (`bottomScanID`,`ownerID`),
  KEY `fk_Occlusion_anteriorBiteScanID` (`anteriorBiteScanID`,`ownerID`),
  KEY `fk_Occlusion_rightBiteScanID` (`rightBiteScanID`,`ownerID`),
  KEY `fk_Occlusion_leftBiteScanID` (`leftBiteScanID`,`ownerID`),
  KEY `fk_Occlusion_CondorFile_snapshot` (`snapshotID`,`ownerID`),
  KEY `fk_Occlusion_CondorFile_mandibulePly` (`mandibuleOcclusionPlyID`,`ownerID`),
  KEY `fk_Occlusion_CondorFile_matrixTransformationMandibule` (`matrixTransformationMandibuleID`,`ownerID`),
  KEY `fk_Occlusion_CondorFile_maxillairePly` (`maxillaireOcclusionPlyID`,`ownerID`),
  KEY `fk_Occlusion_CondorFile_matrixTransformationMaxillaire` (`matrixTransformationMaxillaireID`,`ownerID`),
  CONSTRAINT `fk_Occlusion_anteriorBiteScanID` FOREIGN KEY (`anteriorBiteScanID`, `ownerID`) REFERENCES `Scan` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_bottomScan` FOREIGN KEY (`bottomScanID`, `ownerID`) REFERENCES `Scan` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_CondorFile_mandibulePly` FOREIGN KEY (`mandibuleOcclusionPlyID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_CondorFile_matrixTransformationMandibule` FOREIGN KEY (`matrixTransformationMandibuleID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_CondorFile_matrixTransformationMaxillaire` FOREIGN KEY (`matrixTransformationMaxillaireID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_CondorFile_maxillairePly` FOREIGN KEY (`maxillaireOcclusionPlyID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_CondorFile_snapshot` FOREIGN KEY (`snapshotID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_leftBiteScanID` FOREIGN KEY (`leftBiteScanID`, `ownerID`) REFERENCES `Scan` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_rightBiteScanID` FOREIGN KEY (`rightBiteScanID`, `ownerID`) REFERENCES `Scan` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_Session` FOREIGN KEY (`sessionID`, `ownerID`) REFERENCES `Session` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_topScan` FOREIGN KEY (`topScanID`, `ownerID`) REFERENCES `Scan` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Occlusion`
--

LOCK TABLES `Occlusion` WRITE;
/*!40000 ALTER TABLE `Occlusion` DISABLE KEYS */;
INSERT INTO `Occlusion` VALUES (1001,'00405f86-eefa-41f9-8d98-1fa9cbeef855','80f6d4c0-5dc8-445a-ad5f-281f022f1444','ARCADE_COMPLETE',NULL,'2022-05-25 11:02:54','2022-05-25 11:03:42','2022-05-25 11:02:54','2022-05-25 09:03:42','0e451099-a0ad-463c-9441-7ded1297fa16','c76850a7-9433-47f8-825d-ced9f35dede0',NULL,'8cd7948c-ef59-4b88-a894-5b497d849e92','d1eece96-1e6b-468d-8dc5-8295ca2149a4','bcba0d65-c508-4d4c-9e7f-b39de190c5ed','30720071-8a94-43cc-8fd5-1a603f6e4072','6e0bfe0c-593a-4a2e-8782-7f1e18f4d6bd','0c0b6b4b-ea96-436e-870c-67030a45f51f','da0f3442-c969-43de-950f-994ea320e2af',1,4),(1001,'03b1a993-a7ec-4a83-9074-23671aa3417b','8052e101-fd65-454a-bce4-f65648f63218','HEMI_ARCADE_ANTERIEUR','2022-05-31 14:12:41','2022-05-31 14:08:05',NULL,'2022-05-31 14:08:05','2022-05-31 12:12:41','7b00996b-90f8-4307-9a8c-263a28f1b341','2a38e9c2-6808-43f3-904a-decdb37d60d5','999aa1db-d517-4b25-8095-2a4a53e4d5af',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1),(1001,'03fe87bc-2a25-4d16-a476-2df62bb3cf76','c321e210-b67c-40e8-bece-f8946164a768','HEMI_ARCADE_POSTERIEUR_GAUCHE',NULL,'2022-07-04 16:13:38','2022-07-04 16:14:03','2022-07-04 16:13:45','2022-07-04 14:14:03','e7993d2d-cc6b-42d8-af77-232b04342812','90f9c577-02d8-45f3-9ac5-6c6cfeef1fa2',NULL,NULL,'21fc87fa-c767-4333-893a-3f0ab5cd76f2','6c76bb80-76df-4010-a738-de9fd2f31989','a40d913c-74f9-49c2-a50f-cc2226955dfa','26c6a3a9-4104-4bbb-a17d-704486a1f413','c8a71142-0e60-4fcc-a999-a0463c9bf517','20fe8caf-9985-46f2-a4af-5f1b220a188f',1,2),(1001,'06c3dabc-18e7-44d1-90be-6c1152b44816','991beec3-fe9e-4c98-a3d4-c98e4a4c2471','ARCADE_COMPLETE','2022-09-09 18:28:10','2022-09-09 18:26:40',NULL,'2022-09-09 18:26:40','2022-09-09 16:30:34','b06956a5-97b1-485d-b20a-8c33bd91a0ed','5f9e4be9-4eec-45c8-937d-583b1a5e8642',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,5),(1001,'0bc29ff9-efea-448d-b521-2c39fd4faa78','8cb97702-2ace-4345-9345-11d142b6c7b3','HEMI_ARCADE_ANTERIEUR',NULL,'2022-03-08 12:17:37','2022-03-08 12:18:05','2022-03-08 12:17:37','2022-03-08 11:18:05','48982add-ff93-4e3a-a453-012a73678b39','f2bad12a-451d-406d-98b0-e431a37951dd','90beda40-67c7-49a2-88be-64610235c1c8',NULL,NULL,'27571368-d410-426c-bb87-4de2c6774315','2a8fdc87-7a3f-47e4-83f8-76543163cd17','3af8da16-1c78-4867-83f5-40af48dbf8ae','7b2c0599-a564-406a-a92c-1e8ebb63ae32','9026aa67-b409-4693-81c4-92607b3386a1',1,3),(1001,'0d180e89-cc7f-4718-abf6-79b3ada7fd3c','45c9b517-ce12-4983-bf97-4e6a7e7d04c3','ARCADE_COMPLETE',NULL,'2022-02-15 13:49:32','2022-02-15 13:49:57','2022-02-15 13:49:40','2022-02-15 12:49:57','72adeb31-f7a3-4840-9f93-f10e61c84bef','0b63813c-7fbe-455b-a5e3-483908522ff0',NULL,'71fd8305-087d-4c31-82c4-b83df7b3cc9a','1ecf6aa5-37ac-49b0-ab34-94916ad9415a','cda44172-1c1b-499f-9a5e-b73801de16de','f10589f3-c72c-435a-a8b4-17403cd0e41a','7f170f84-f1e1-4d43-8fcb-0fe153f8a949','d4eb1177-3f71-4e20-b508-c25c3b720e0a','31df9b40-ce6a-441c-a253-232bfee6d11d',1,3),(1001,'1500b3eb-4b86-46c1-9c9f-7efbd0224ac8',NULL,'HEMI_ARCADE_POSTERIEUR_GAUCHE','2022-05-25 10:56:37','2022-05-13 18:22:00','2022-05-25 10:56:37','2022-05-13 18:22:04','2022-05-25 08:56:37','909d9ecd-46b3-4692-868e-f6405507ecd1','c76850a7-9433-47f8-825d-ced9f35dede0',NULL,NULL,'aa38e68a-4c1f-4e58-a176-2a4d533c35a0',NULL,NULL,NULL,NULL,NULL,1,4),(1001,'161f60a4-d4f2-41f1-98ad-a8ccad84216c','934673c1-a4b9-4508-ac1b-a03092a0693e','HEMI_ARCADE_POSTERIEUR_DROIT',NULL,'2022-01-24 18:45:49','2022-01-24 20:55:58','2022-01-24 18:46:00','2022-01-24 19:55:58','00f98bb4-dc6f-4a78-b9c8-5f04e23fc139','da7dbb1d-043a-4c99-abde-d5ee77a3f819',NULL,'8d7fa4fe-ab8d-4b70-b921-fabf93cf9f25',NULL,'1a0767db-326c-4cdc-96d6-37bbfc6c059c','fa05c88b-194d-4b51-8a79-719b0ae7d42c','b60666c5-07cb-4f6c-ba71-538dcfe3d89d','c528e035-d66a-4a5a-af0f-3f0a50b070e9','43bf2afa-4f73-488a-b1fc-60b302be27b3',1,1),(1001,'18cabdbe-2107-495f-84aa-db7bb0d5b7ba','55b947cc-3654-4f0a-b3b9-0a706eb6f5d3','HEMI_ARCADE_POSTERIEUR_DROIT',NULL,'2022-01-19 16:20:43',NULL,'2022-01-19 16:20:43','2022-01-19 15:20:43','0bf938e8-3ff3-4e2d-981d-f2db30285d60','20c281c1-af15-40ce-8892-18a2507513e3',NULL,'7338a694-0f0d-4c09-8c45-b4e4129978cb',NULL,NULL,NULL,NULL,NULL,NULL,1,1),(1001,'2049d3a2-43e5-410e-9b6d-25b939807408','e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a','HEMI_ARCADE_POSTERIEUR_GAUCHE','2022-02-07 18:53:09','2022-02-07 12:46:50',NULL,'2022-02-07 12:46:50','2022-02-07 17:53:09','77ec818f-d778-4945-9458-90665b5522ba','e8550560-cfe0-40a1-bfb3-992d471fbcb7',NULL,NULL,'7b68804e-41db-41a7-9a19-d1aaecf91ab5',NULL,NULL,NULL,NULL,NULL,1,2),(1001,'20b2d6e6-0354-42ec-b580-0fb72644718d','45c9b517-ce12-4983-bf97-4e6a7e7d04c3','HEMI_ARCADE_ANTERIEUR',NULL,'2022-02-15 13:48:48',NULL,'2022-02-15 13:48:48','2022-02-15 12:48:48','72adeb31-f7a3-4840-9f93-f10e61c84bef','0b63813c-7fbe-455b-a5e3-483908522ff0','b7947fff-2f4c-4016-bc7a-372a7c0dd0c6',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,2),(1001,'26ae7fce-0ea3-479f-9989-7d0a3a19aaf7',NULL,'HEMI_ARCADE_ANTERIEUR','2022-02-07 19:01:29','2022-02-07 18:58:31','2022-02-07 19:01:29','2022-02-07 18:58:31','2022-02-07 18:01:29','77ec818f-d778-4945-9458-90665b5522ba','e8550560-cfe0-40a1-bfb3-992d471fbcb7','499bf817-e96f-4ff6-ae84-c5c2ccc847c2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,6),(1001,'275173ad-41e0-4234-ab77-e7b82a6478e6','8052e101-fd65-454a-bce4-f65648f63218','HEMI_ARCADE_ANTERIEUR','2022-05-31 16:53:15','2022-05-31 14:16:29',NULL,'2022-05-31 14:16:29','2022-05-31 14:53:15','7b00996b-90f8-4307-9a8c-263a28f1b341','2a38e9c2-6808-43f3-904a-decdb37d60d5','3743c984-7cdf-4a7a-bb8e-522e16ccb6e4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,4),(1001,'291e2ff1-be72-4d03-8342-c9402403ce50','80f6d4c0-5dc8-445a-ad5f-281f022f1444','HEMI_ARCADE_POSTERIEUR_GAUCHE','2022-05-13 18:16:04','2022-05-13 16:46:37',NULL,'2022-05-13 16:46:37','2022-05-13 16:16:04','909d9ecd-46b3-4692-868e-f6405507ecd1','c76850a7-9433-47f8-825d-ced9f35dede0',NULL,NULL,'d1eece96-1e6b-468d-8dc5-8295ca2149a4',NULL,NULL,NULL,NULL,NULL,1,1),(1001,'2de3d2bb-d512-4514-8bed-a879b73a6028','7eb5bc72-17d3-47d8-9061-8fb639403734','HEMI_ARCADE_POSTERIEUR_DROIT',NULL,'2022-04-21 13:29:11','2022-04-21 13:29:40','2022-04-21 13:29:16','2022-04-21 11:29:40','9937f6fe-f500-4cc5-acd7-39dadc5ac2e7','eafe4b37-e7ad-4f58-b931-a99f31f6d4a4',NULL,'a45e609a-ed7e-4f9d-a646-fcf505dd8590',NULL,'24b218af-fcc6-4d11-8bc7-0d12769286f9','7f961e41-617e-4e30-84ef-a53f823e5acf','ef040f11-a1d7-451f-b5fd-2aa8b64452be','4bf52f65-04f9-420f-bc0d-457f239f1bc0','65248dcf-9c3a-47ce-a2c2-9d6f5de84040',1,7),(1001,'2ea67e3e-211e-4f64-aa25-9f961d8bcb14','e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a','HEMI_ARCADE_ANTERIEUR','2022-02-07 18:53:01','2022-02-07 12:45:53',NULL,'2022-02-07 12:45:53','2022-02-07 17:53:01','77ec818f-d778-4945-9458-90665b5522ba','e8550560-cfe0-40a1-bfb3-992d471fbcb7','499bf817-e96f-4ff6-ae84-c5c2ccc847c2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1),(1001,'35af1bf5-285a-4bb1-a6db-fe9897defe51','c653584a-be75-45c7-92ec-e0eca5a2b6ca','HEMI_ARCADE_ANTERIEUR',NULL,'2022-05-13 14:11:07','2022-05-25 12:46:46','2022-05-25 12:46:42','2022-05-25 10:46:46','2d226451-8adb-4007-be22-99a9b3af61d6','6f906ffa-4828-4d68-a894-572a056b896b','f4fff5f5-f728-44ae-ac48-f3e653594098',NULL,NULL,'6b4f02ea-c57e-40cc-a471-e0a4dd200fcd','3208f8ef-621d-43b2-b795-42c3bda237c7','e2588ba3-68eb-4df3-8fcd-8b3a080fab73','e40bcb5c-3738-4edb-9feb-03ede717d70b','8b48514f-d8d7-4e30-a7b7-9ff34435a5d8',1,4),(1001,'389a085b-21e0-4004-9d53-dfcb5c4bd2f1','2e287bb0-e19a-414a-9177-23b335d286d9','HEMI_ARCADE_POSTERIEUR_DROIT',NULL,'2022-06-03 11:04:18','2022-06-03 11:04:40','2022-06-03 11:04:23','2022-06-03 09:04:40','05d5d943-3268-4239-ac7d-5efbc2d2ab9b','aa3849b7-bd16-41b9-8afe-0af192f363d1',NULL,'817e3173-ed5b-4bb7-93d5-bc02ec7eb79b',NULL,'7757fade-a1c3-4f58-b5f4-6a8c840a1026','a1b9dbd6-1067-4531-89ab-a474ccdccbfe','ce384823-5411-4f27-874a-402787fad1e0','ed676c0a-e5c3-450e-975d-f740a787e736','aa4c3fbb-0476-41cf-bb3e-f4c22e907f61',1,1),(1001,'3a1fff1c-0427-409c-aa94-06326e554d82','dc5762a3-c453-4166-8c86-82d23ac9f8a6','HEMI_ARCADE_POSTERIEUR_DROIT',NULL,'2022-05-30 13:09:17','2022-05-30 13:09:40','2022-05-30 13:09:22','2022-05-30 11:09:40','9a90e42e-88ee-4808-8ae4-399e7285a1d0','5139ec2e-4608-4b67-b0d1-bc4dc3498038',NULL,'db144753-52d9-4c43-950b-25093a3aee5f',NULL,'9ee0ae1d-fe0a-4553-9d50-11a13c8b42fc','d881b47d-875f-42fd-b7ef-7e128912d6da','63e9f9a7-c8a4-4bf2-9e7c-c06c335ff76a','452d955d-b844-42ed-9edf-9d005a4afa46','84e32701-3099-4943-babb-39906f06e7db',1,1),(1001,'42098ceb-3335-4f13-8aed-b29c37a5f57f','7eb5bc72-17d3-47d8-9061-8fb639403734','HEMI_ARCADE_POSTERIEUR_DROIT',NULL,'2022-04-21 13:28:38','2022-04-21 13:29:07','2022-04-21 13:28:43','2022-04-21 11:29:07','9937f6fe-f500-4cc5-acd7-39dadc5ac2e7','725ef2a4-4b53-4ec9-a807-17759213c882',NULL,'a45e609a-ed7e-4f9d-a646-fcf505dd8590',NULL,'dbce789f-4cb2-4aef-aadf-d1bd30518bf6','2b408b13-2a9b-4477-8eea-ca0d2ef357cf','7ec34b4e-bd8b-4125-bc39-a94b91122070','b85be850-5590-4c9b-b13b-3d6d94c2e3ab','c2e41fcc-1846-464a-b169-dcfb11da5d08',1,6),(1001,'426bd908-3163-4291-a697-20eacff771ab',NULL,'HEMI_ARCADE_POSTERIEUR_GAUCHE','2022-05-25 10:56:22','2022-05-16 19:57:11','2022-05-25 10:56:22','2022-05-16 19:57:11','2022-05-25 08:56:22','909d9ecd-46b3-4692-868e-f6405507ecd1','c76850a7-9433-47f8-825d-ced9f35dede0',NULL,NULL,'aa38e68a-4c1f-4e58-a176-2a4d533c35a0',NULL,NULL,NULL,NULL,NULL,1,6),(1001,'4772050e-43c9-4a54-967c-ed1b951c7263','8cb97702-2ace-4345-9345-11d142b6c7b3','HEMI_ARCADE_ANTERIEUR',NULL,'2022-03-08 12:12:28',NULL,'2022-03-08 12:12:28','2022-03-08 11:12:28','48982add-ff93-4e3a-a453-012a73678b39','f2bad12a-451d-406d-98b0-e431a37951dd','90beda40-67c7-49a2-88be-64610235c1c8',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1),(1001,'49b596d8-dc77-4f11-9e7e-f9b392bbf3a2','991beec3-fe9e-4c98-a3d4-c98e4a4c2471','ARCADE_COMPLETE','2022-09-09 18:25:15','2022-09-09 18:22:47',NULL,'2022-09-09 18:22:47','2022-09-09 16:30:34','b06956a5-97b1-485d-b20a-8c33bd91a0ed','5f9e4be9-4eec-45c8-937d-583b1a5e8642',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,3),(1001,'4aa37ef9-cd2d-4cfa-9436-a62cc782a27a',NULL,'HEMI_ARCADE_POSTERIEUR_GAUCHE','2022-02-04 14:56:12','2022-02-04 14:55:02','2022-02-04 14:56:12','2022-02-04 14:55:02','2022-02-04 13:56:12','4ed7adaa-3b77-4537-8479-4d0c4bd28c7b','2a7068fc-0efa-496f-ade9-aba5b0650655',NULL,NULL,'93b9b214-5793-480a-b05f-e0419802faf3',NULL,NULL,NULL,NULL,NULL,1,1),(1001,'4e1258a6-b789-451f-bfe8-8b395e1129d8','55b947cc-3654-4f0a-b3b9-0a706eb6f5d3','HEMI_ARCADE_POSTERIEUR_GAUCHE','2022-01-19 16:25:10','2022-01-19 16:22:35',NULL,'2022-01-19 16:24:43','2022-01-19 15:25:10','0bf938e8-3ff3-4e2d-981d-f2db30285d60','20c281c1-af15-40ce-8892-18a2507513e3',NULL,NULL,'ae54b48a-8f70-45c1-81cc-4ed8a6bc0e95','e9a05c37-c44f-4221-9711-5a407611dea6','98432173-1253-48fa-b893-e2dd7ab26a00','48ca5e89-974f-45f9-85f2-85c4644fb297','d18a8fe2-fdcc-4d59-9de5-e651eb735d68','80fac73f-4e14-44dd-b7e3-5b5fd926bcb2',1,3),(1001,'51c4be7c-2202-4744-892d-93b732a7be1a','8a278cc5-a1c1-4dfb-9ee2-c971a6309afa','HEMI_ARCADE_ANTERIEUR',NULL,'2022-02-01 16:17:14',NULL,'2022-02-01 16:17:14','2022-02-01 15:17:14','061005ca-b3b4-4cb2-bf80-5bae7b8fc987','6c418416-1c53-40cd-ba49-f56373b0bc1a','aa48ecdd-c861-41de-8796-655dc3852c64',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1),(1001,'56ee7835-4e9b-45e1-b543-c258a17bfbf3','7eb5bc72-17d3-47d8-9061-8fb639403734','HEMI_ARCADE_POSTERIEUR_GAUCHE',NULL,'2022-04-21 13:21:40',NULL,'2022-04-21 13:21:40','2022-04-21 11:21:41','9937f6fe-f500-4cc5-acd7-39dadc5ac2e7','eafe4b37-e7ad-4f58-b931-a99f31f6d4a4',NULL,NULL,'1a0b9502-8df2-41a2-89eb-2def508b7462',NULL,NULL,NULL,NULL,NULL,1,4),(1001,'5775815f-f076-48af-be27-50e4dbfd3622','3accbada-5a51-4d10-88d1-c3e7d8598d6f','HEMI_ARCADE_POSTERIEUR_GAUCHE',NULL,'2022-06-28 12:55:50','2022-06-28 12:56:23','2022-06-28 12:55:54','2022-06-28 10:56:23','eb03dd9c-db3d-4d79-99ee-0715da7cea41','ca26b24d-fb66-43e1-8719-cc661811d143',NULL,NULL,'5b8f2ae7-343d-4058-ad87-94f21d555fc8','831e4532-3962-4547-af55-74e75647063d','c30979c0-872b-4f50-a4ed-19896daeb6d2','f2e1df9d-8e84-470f-9c1c-5c95e60d6ccd','8f69f135-daef-4f4b-a1a0-3aa76fb92de1','77a65753-09fd-45ea-8312-8effe35d66c0',1,1),(1001,'5a35c667-586b-45b8-a4cf-220cf57f8246','991beec3-fe9e-4c98-a3d4-c98e4a4c2471','ARCADE_COMPLETE','2022-09-09 18:43:37','2022-09-09 18:34:14',NULL,'2022-09-09 18:34:14','2022-09-10 08:18:24','b06956a5-97b1-485d-b20a-8c33bd91a0ed','5f9e4be9-4eec-45c8-937d-583b1a5e8642',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,7),(1001,'6389aa25-3462-4f29-a9c7-f0d127e96f1e','55b947cc-3654-4f0a-b3b9-0a706eb6f5d3','HEMI_ARCADE_ANTERIEUR',NULL,'2022-01-19 16:21:39',NULL,'2022-01-19 16:21:39','2022-01-19 15:21:39','0bf938e8-3ff3-4e2d-981d-f2db30285d60','20c281c1-af15-40ce-8892-18a2507513e3','4d153a25-3b94-464b-9b18-2966d8ae2ce6',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,2),(1001,'65f9077d-c859-4b2c-9d4d-692d723315a5',NULL,'HEMI_ARCADE_ANTERIEUR','2022-05-13 14:07:43','2022-05-13 14:03:50','2022-05-13 14:07:43','2022-05-13 14:07:00','2022-05-13 12:07:43','2d226451-8adb-4007-be22-99a9b3af61d6','6f906ffa-4828-4d68-a894-572a056b896b','f4fff5f5-f728-44ae-ac48-f3e653594098',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,4),(1001,'661d7dec-36da-4ca5-bbbd-d03957f540ec','c653584a-be75-45c7-92ec-e0eca5a2b6ca','HEMI_ARCADE_ANTERIEUR','2022-05-13 14:03:24','2022-05-13 12:11:42',NULL,'2022-05-13 12:11:42','2022-05-13 12:03:24','2d226451-8adb-4007-be22-99a9b3af61d6','6f906ffa-4828-4d68-a894-572a056b896b','f4fff5f5-f728-44ae-ac48-f3e653594098',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1),(1001,'6960b50e-6f78-4f83-9303-8c985410457c','8052e101-fd65-454a-bce4-f65648f63218','HEMI_ARCADE_POSTERIEUR_GAUCHE',NULL,'2022-05-31 16:53:26','2022-05-31 16:56:08','2022-05-31 16:55:44','2022-05-31 14:56:08','7b00996b-90f8-4307-9a8c-263a28f1b341','2a38e9c2-6808-43f3-904a-decdb37d60d5',NULL,NULL,'f5ab063d-18f1-443e-b694-fd1ef20e9e78','81ab663b-3f7f-440e-bc5e-0b3f41373259','98489097-716a-4b58-9941-a5fc369a2d70','28ffc1de-2be4-4a19-87be-aecd0b0aa83f','bf27fa48-2bce-43eb-98c2-306272ec251f','4b90930b-b4dd-4eae-8b5f-8c8f04e970c6',1,5),(1001,'704a0750-2a24-448f-8f30-928139977895','45c9b517-ce12-4983-bf97-4e6a7e7d04c3','HEMI_ARCADE_POSTERIEUR_GAUCHE',NULL,'2022-03-08 12:49:34','2022-03-08 12:49:52','2022-03-08 12:49:34','2022-03-08 11:49:52','72adeb31-f7a3-4840-9f93-f10e61c84bef','1c86378e-7d31-4b12-82ff-af797020160f',NULL,NULL,'1ecf6aa5-37ac-49b0-ab34-94916ad9415a','b4e5f5b8-812b-4550-93b3-a8808b89d8cd','3b1b8529-9696-4bae-8527-ef23772fe66a','cdac836c-5511-4e89-9ff7-910b974cff97','8d091250-13fa-4e1e-89d6-2dae08a91119','853e2356-bdec-4762-8140-becfdb0d014d',1,4),(1001,'70f4220e-2a6b-4575-bd0e-09c14a13d758','1ac20dc7-b36b-4786-a05f-37091554dc5c','HEMI_ARCADE_POSTERIEUR_DROIT',NULL,'2022-06-16 13:03:51','2022-06-16 13:04:13','2022-06-16 13:03:55','2022-06-16 11:04:13','7d899967-a5be-43f7-acbd-42d4237792d4','e2e4ad7f-c1c9-4c11-a41c-d237b2e0023e',NULL,'1808e07b-25f9-4fb8-a923-34263a3c0386',NULL,'463c7b84-774c-483c-ab9a-89a270919932','b5b15730-75d0-4419-8b97-a0362238661d','a54c946c-a9df-45b0-aa2e-35efdf9f6439','8c0459bd-0102-41f8-9d98-758b74f6b263','4e0a4109-35b7-4c91-b28f-2ae7a227dbb7',1,1),(1001,'727485e0-8637-4024-83d8-95544991f73f','2aa712ca-8b46-4a50-a03e-1c6a6a0c40fc','HEMI_ARCADE_POSTERIEUR_GAUCHE',NULL,'2022-06-03 16:06:57','2022-06-03 16:07:18','2022-06-03 16:07:00','2022-06-03 14:07:18','1aa5441d-7ad8-4a5d-96d6-d07348ac58c4','2b27113d-3b20-4d7e-8591-1e87c6e97f79',NULL,NULL,'c38af399-ff7c-47c5-8f3f-7a96401d72b5','ee721166-4a03-458e-af6b-bb03c70245af','c6a6cc47-17e5-4709-a61d-687818334a3d','6f6a9b2c-99a5-4c89-9435-60646732a096','e04ce307-e72f-48f8-94a9-561f6c850f27','1485361c-1943-4401-8ed1-23059245eae1',1,1),(1001,'764b8e22-8600-49e3-8d7c-d619725096ee','b3ae2904-41ee-4eef-9639-bb150af1853a','HEMI_ARCADE_POSTERIEUR_DROIT','2022-02-04 19:20:41','2022-02-04 19:19:48',NULL,'2022-02-04 19:19:48','2022-02-04 18:20:41','59fb6872-6b71-417d-a7ee-ab313b732b6c','b28164eb-0070-4968-83be-bfabe1a0c839',NULL,'165dc4ed-fa76-4753-970f-5b2176e3e023',NULL,'5e2227aa-c48a-4337-a9f3-899cdb079950','86411b04-6731-49a3-b09f-936337ac02f5','c202fc68-d539-4e94-bd22-11d4de172444','5c552dd5-711b-49d9-8d67-2470cfd3aa77','d016dd8f-7e15-4fba-be82-5afa7a6f7562',1,2),(1001,'77753fb3-75a1-45c2-9191-7a5d98206df2','80f6d4c0-5dc8-445a-ad5f-281f022f1444','ARCADE_COMPLETE',NULL,'2022-06-14 14:06:33','2022-06-14 14:07:17','2022-06-14 14:06:33','2022-06-14 12:07:17','16f04a07-72e8-4a39-9b55-3ae7405733af','c76850a7-9433-47f8-825d-ced9f35dede0',NULL,'8cd7948c-ef59-4b88-a894-5b497d849e92','44561518-16e3-45bd-af90-fefe4eca9d27','7a1bc3ae-2bd2-4767-abb5-fe9c2bd23091','f43bccad-6647-495c-8c06-541b112b5a3a','3358903e-3e70-4a5e-927b-c3466331075a','f1b4af70-0a68-4499-bbd3-2ae8dc65226e','adcfc3f6-2557-4375-a3b5-51d331cc65fb',1,5),(1001,'778ed9fd-f658-471d-9dd0-a48417419cba','229f401f-4824-48cc-8a9f-7a5549d69acd','HEMI_ARCADE_POSTERIEUR_GAUCHE','2022-05-12 14:32:06','2022-05-12 14:31:43',NULL,'2022-05-12 14:31:43','2022-05-12 12:32:06','cfcda3c3-749c-4f3d-96e2-556ed558ceef','b1201d2a-0fbf-48bc-a1c2-f3649c1ca576',NULL,NULL,'f4b07389-264e-4772-afc3-29b2187ced21','8a4ad7fe-8660-4de4-87fc-e34225ca52a0','64b1a7cd-06d4-469c-b06d-4c38cfd82051','e61e5643-077f-4631-9a52-30eee22319ec','ddea4642-9cf7-46ce-879d-961adf88d1f1','081335b0-4cf5-4720-ac13-b858da5d8e93',1,3),(1001,'7a5acfd0-87ca-4009-aa4e-677a88ceffde','a843a9cf-5a96-4a4e-8679-2c4dddd5e6be','HEMI_ARCADE_POSTERIEUR_DROIT',NULL,'2022-05-31 12:53:50','2022-05-31 12:54:14','2022-05-31 12:53:55','2022-05-31 10:54:14','d969cedf-8de4-4e27-8d4d-f4a1e8eac60c','67168b1b-2bef-47a9-8e7f-994731a82831',NULL,'f6f4f4dc-826e-4efc-957c-61074915b6b6',NULL,'0b902cd8-144a-4a2d-a2da-dc9d7a13668b','8d4aee7a-6819-4016-b51b-71ba7ffaadea','80740dcf-ef50-473b-bf6b-dbd21bab0839','6c068fd4-9fc3-4964-b6e1-b872b9490c35','cf705a27-0c7e-4999-a798-b56fcbd9f1e8',1,1),(1001,'7a922eb8-5139-40fe-8402-fc7ff4204a1a','bce8310f-eee9-4f0a-a6b7-d592dec66be5','HEMI_ARCADE_POSTERIEUR_GAUCHE',NULL,'2022-05-24 11:42:05','2022-05-24 11:42:30','2022-05-24 11:42:09','2022-05-24 09:42:30','49ae59fe-0bc4-4d86-b65e-d8788e2d12fb','bd194eb4-5c69-43b1-94bb-66c7ae8aa0ce',NULL,NULL,'315ac573-ca2e-4c47-8969-e667ad225aa2','b015947f-1181-4536-b39a-ad5c494a9c91','1e34800f-6443-4433-a2fd-ac3d1de66258','08725014-e287-4ddd-9b4f-f24b8ede2c81','f3d3d31f-7e08-49c2-aaf5-83098cbf7010','d9756905-f7f3-4ccf-ac0a-b8ee5c610fae',1,1),(1001,'7c70edbe-5cb4-4244-8baf-7caf2bd7d86b','e2704ec5-66c8-4d68-ae48-c92185628c8b','HEMI_ARCADE_ANTERIEUR',NULL,'2022-02-04 18:58:48','2022-02-04 18:59:49','2022-02-04 18:58:48','2022-02-04 17:59:49','4ed7adaa-3b77-4537-8479-4d0c4bd28c7b','2a7068fc-0efa-496f-ade9-aba5b0650655','04abc032-a797-420b-8d5e-ee9528f5e291',NULL,NULL,'1307b63c-d68c-40b7-a3ff-4fc477f139dc','7cec7e1d-dea8-4323-9a35-77e7166c42eb','9e1292ba-2d2b-4b4c-8e8c-1c5231018cf4','643b4b45-c20a-4040-bf63-70edc63f19d1','e22b8e38-4ab3-40db-9c15-e6e24035c607',1,1),(1001,'7d65873b-5b24-42b5-8465-3cca6c8403c9','80f6d4c0-5dc8-445a-ad5f-281f022f1444','HEMI_ARCADE_POSTERIEUR_GAUCHE','2022-05-13 18:21:45','2022-05-13 16:47:11',NULL,'2022-05-13 16:47:11','2022-05-13 16:21:45','55f73d72-8321-42ec-88c8-d2988eeca0de','c76850a7-9433-47f8-825d-ced9f35dede0',NULL,NULL,'d1eece96-1e6b-468d-8dc5-8295ca2149a4',NULL,NULL,NULL,NULL,NULL,1,2),(1001,'7d8decb1-23db-4824-940f-8d8822d88813',NULL,'HEMI_ARCADE_POSTERIEUR_DROIT','2022-02-07 19:01:46','2022-02-07 18:48:45','2022-02-07 19:01:46','2022-02-07 18:48:45','2022-02-07 18:01:46','77ec818f-d778-4945-9458-90665b5522ba','e8550560-cfe0-40a1-bfb3-992d471fbcb7',NULL,'f9c2783a-c405-481c-a97e-47bb9db0d0d2',NULL,NULL,NULL,NULL,NULL,NULL,1,3),(1001,'7fcd3785-08a6-452b-b688-4de474e5288d','991beec3-fe9e-4c98-a3d4-c98e4a4c2471','ARCADE_COMPLETE','2022-09-09 18:43:51','2022-09-09 18:38:35',NULL,'2022-09-09 18:38:35','2022-09-10 08:18:17','b06956a5-97b1-485d-b20a-8c33bd91a0ed','5f9e4be9-4eec-45c8-937d-583b1a5e8642',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,8),(1001,'8123f730-2ea1-428f-8f1a-02de0e8417b3','c321e210-b67c-40e8-bece-f8946164a768','HEMI_ARCADE_POSTERIEUR_GAUCHE','2022-07-04 16:13:34','2022-07-04 16:09:13',NULL,'2022-07-04 16:09:13','2022-07-04 14:13:34','e7993d2d-cc6b-42d8-af77-232b04342812','90f9c577-02d8-45f3-9ac5-6c6cfeef1fa2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1),(1001,'812fdd67-c9dc-4e0c-806a-0524a386b296','e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a','HEMI_ARCADE_POSTERIEUR_GAUCHE','2022-02-07 18:55:14','2022-02-07 18:54:30',NULL,'2022-02-07 18:54:30','2022-02-07 17:55:14','77ec818f-d778-4945-9458-90665b5522ba','e8550560-cfe0-40a1-bfb3-992d471fbcb7',NULL,NULL,'7b68804e-41db-41a7-9a19-d1aaecf91ab5','fb634fbc-4a12-4143-995a-30444e0920d5','3091a3f3-f34b-4876-8a99-9c2aa5f3ac00','0604d07a-bebf-444d-b0d3-ef45e6312bb6','10b7f922-a161-46d6-acb1-9b8427a0b3e5','da905553-c6cb-4dc1-befd-c4d3bbb3d305',1,5),(1001,'84d73896-4c7a-4dc0-994a-b2a70e3d1cf2','d0fbd250-95c7-46e7-91e5-b4bc46c85b4a','HEMI_ARCADE_POSTERIEUR_DROIT',NULL,'2022-06-28 11:06:59','2022-06-28 11:07:21','2022-06-28 11:07:03','2022-06-28 09:07:21','62c04472-88fd-4ac5-acbe-aefb92941897','3954e24e-9220-452b-a8fa-b1fbde6ebcad',NULL,'50213132-9c82-471d-8981-66894edf36a4',NULL,'976c8ff2-0cca-43fe-8b36-f902660807ef','2505eb15-7090-4f82-ad06-2fbd8aea623a','204b529d-94bd-48ef-b172-5317b14df862','7aa382e0-3722-4b51-b555-ca86b2fdea0f','8b995262-9a19-4f27-a906-f0a97ad14a3e',1,1),(1001,'84f91089-dfc0-474d-83ec-74fb75c5f2db','7eb5bc72-17d3-47d8-9061-8fb639403734','HEMI_ARCADE_POSTERIEUR_GAUCHE',NULL,'2022-04-21 13:22:30',NULL,'2022-04-21 13:22:30','2022-04-21 11:22:30','9937f6fe-f500-4cc5-acd7-39dadc5ac2e7','eafe4b37-e7ad-4f58-b931-a99f31f6d4a4',NULL,NULL,'1a0b9502-8df2-41a2-89eb-2def508b7462',NULL,NULL,NULL,NULL,NULL,1,5),(1001,'864c98a3-fcf7-466a-b999-13bd4dfb8c65','c653584a-be75-45c7-92ec-e0eca5a2b6ca','HEMI_ARCADE_ANTERIEUR',NULL,'2022-05-13 12:18:25','2022-05-25 12:46:45','2022-05-25 12:46:42','2022-05-25 10:46:45','2d226451-8adb-4007-be22-99a9b3af61d6','6f906ffa-4828-4d68-a894-572a056b896b','f4fff5f5-f728-44ae-ac48-f3e653594098',NULL,NULL,'6b9eecc3-635f-4c15-8609-cf0c4f6d6dae','ad385cc8-79ad-4c40-91ea-1275223f15d9','b289e4d6-3c9a-4c99-9b03-22a1c45f557a','d7548f64-4e8b-4a78-96bb-e9b9eda1c14e','e1592d2a-cc52-41a2-a723-3212141cd2e6',1,3),(1001,'87edc123-163f-46ce-be5c-45f2ff80b857',NULL,'HEMI_ARCADE_POSTERIEUR_GAUCHE','2022-05-12 14:27:25','2022-05-12 14:26:50','2022-05-12 14:27:25','2022-05-12 14:26:51','2022-05-12 12:27:25','cfcda3c3-749c-4f3d-96e2-556ed558ceef','b1201d2a-0fbf-48bc-a1c2-f3649c1ca576',NULL,NULL,'992e34fe-b7bb-45b7-a2c6-794c8211aba7',NULL,NULL,NULL,NULL,NULL,1,3),(1001,'8b14563e-0862-4cac-8045-e8aed2be886d','a2220645-c79d-4dda-b6cc-772384a4106b','HEMI_ARCADE_POSTERIEUR_DROIT',NULL,'2022-07-12 12:57:17','2022-07-19 14:28:54','2022-07-19 14:28:51','2022-07-19 12:28:54','0136d883-d517-448a-82a3-bfcdd5f4c35c','38a668ff-3bd3-4238-90d7-65cc6f5a9ca7',NULL,'fb5993c3-7f31-49de-8a74-e83ef447f0a1',NULL,'f8b5de1c-c1e9-41af-ac09-eb7ccc5fa3e2','30e287e4-f479-42bb-a57e-e27ecab9f8ef','1a697c44-46ac-43a0-82b9-a46dbc74a391','9f084861-d8a3-4071-b9c8-235aab6b53fe','b8b1811e-1d8b-4e17-8c28-b529cbc427b9',1,1),(1001,'8e4092a3-64a2-4464-addd-03b3c8ba2289','80f6d4c0-5dc8-445a-ad5f-281f022f1444','HEMI_ARCADE_POSTERIEUR_GAUCHE',NULL,'2022-05-13 18:20:53','2022-05-13 18:21:26','2022-05-13 18:20:53','2022-05-13 16:21:26','55f73d72-8321-42ec-88c8-d2988eeca0de','c76850a7-9433-47f8-825d-ced9f35dede0',NULL,NULL,'aa38e68a-4c1f-4e58-a176-2a4d533c35a0','1759d630-e2be-4ef5-8fe0-f2f6a8a10873','4447b3ff-fae6-4112-b63c-3a9385ee2158','c7a07589-5ed0-4af7-87c4-ea2cb405806d','f27a70e5-90e5-49c4-9fb7-33040d0fd112','d6c60f40-e92e-4d3c-bc58-da059725bdd9',1,3),(1001,'9436e97c-307a-4421-b94d-bd707b03182d','991beec3-fe9e-4c98-a3d4-c98e4a4c2471','HEMI_ARCADE_POSTERIEUR_DROIT','2022-09-10 11:42:27','2022-09-09 18:59:48',NULL,'2022-09-09 18:59:48','2022-09-10 09:42:27','b06956a5-97b1-485d-b20a-8c33bd91a0ed','5f9e4be9-4eec-45c8-937d-583b1a5e8642',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,9),(1001,'9440baee-a8bf-406c-bc0a-f5e9596f197b',NULL,'HEMI_ARCADE_POSTERIEUR_DROIT','2022-05-13 18:14:02','2022-05-13 16:51:02','2022-05-13 18:14:02','2022-05-13 18:13:11','2022-05-13 16:14:02','909d9ecd-46b3-4692-868e-f6405507ecd1','c76850a7-9433-47f8-825d-ced9f35dede0',NULL,'aa38e68a-4c1f-4e58-a176-2a4d533c35a0',NULL,NULL,NULL,NULL,NULL,NULL,1,3),(1001,'94a0167c-6798-4c78-a76c-cb9fc91ccdda','16b82fca-4b65-4866-af87-1f6dbb42f5dc','HEMI_ARCADE_POSTERIEUR_GAUCHE',NULL,'2022-06-28 17:03:20','2022-06-28 17:03:45','2022-06-28 17:03:25','2022-06-28 15:03:45','77280faa-6fb3-46f5-aa9e-fd5dd96b1535','378056ed-259b-4069-96b1-1e6050e30f87',NULL,NULL,'07f2d366-54ce-478e-95a9-7ae35cfbc11a','01d3e05e-ff13-4067-b5bd-5ec37bbc3d2c','a8fe8aec-2370-4436-b402-eb13b571de0f','2e5771c3-2656-438e-88f4-f38de1cdf014','0abefe94-3f85-4adb-b30a-34fe734e64a2','848ef817-dbc7-482b-a5da-58b2b9fffcd1',1,1),(1001,'974a351f-bff2-41d7-9924-285cd73835c7','991beec3-fe9e-4c98-a3d4-c98e4a4c2471','HEMI_ARCADE_ANTERIEUR','2022-09-09 18:28:04','2022-09-09 18:25:43',NULL,'2022-09-09 18:25:43','2022-09-09 16:28:04','b06956a5-97b1-485d-b20a-8c33bd91a0ed','5f9e4be9-4eec-45c8-937d-583b1a5e8642','1ff80dd9-2d47-4292-adde-0923cb6fe572',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,4),(1001,'9bcf9f6b-12e4-401e-acb5-bcf602871eaa','991beec3-fe9e-4c98-a3d4-c98e4a4c2471','ARCADE_COMPLETE','2022-09-09 18:17:16','2022-09-09 18:16:38',NULL,'2022-09-09 18:16:38','2022-09-09 16:30:29','b06956a5-97b1-485d-b20a-8c33bd91a0ed','5f9e4be9-4eec-45c8-937d-583b1a5e8642',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1),(1001,'9c318e86-fa90-4cd9-8319-2503cde2b455','8f3d6c73-3468-45a5-85c7-93bba47ec9f7','HEMI_ARCADE_POSTERIEUR_GAUCHE',NULL,'2022-06-14 15:29:51','2022-06-14 15:30:13','2022-06-14 15:29:56','2022-06-14 13:30:13','0d368f7d-e2ae-489f-b39f-cfe87c4103c8','60c1cc80-0d70-4511-8993-70e3a3c146b8',NULL,NULL,'a7163552-20ad-4b45-ae78-be2b0453dbd3','c3304273-3e21-43cc-9d46-d2367b2cd27a','55f52934-bbd7-4e86-bd7e-fc42a74d3419','6217fbe5-09ba-48c5-9c84-c981fea99cac','8b0696ff-a902-4672-a040-5a87cb3b99b4','1050fd18-33ef-4994-bb2b-d74c35a009b6',1,1),(1001,'a15a6719-2996-4256-93d7-515e4d4f5bef','ea6da896-1504-41fc-890c-7c48575e9e40','HEMI_ARCADE_ANTERIEUR',NULL,'2022-01-19 15:46:32','2022-01-19 15:47:48','2022-01-19 15:46:49','2022-01-19 14:47:48','aa24138a-68e8-4bc3-9a5d-d617f0fe496b','cf9b0360-b96a-4e1a-a219-fdaa6228f9f7','e7e54c23-0fb4-457b-aa49-43078736514f',NULL,NULL,'f8701aa9-49a2-44c6-b4c2-795209c7e987','8a72c490-d57c-49ed-a392-7053d70d734d','9ee12909-baa5-4a11-9161-ac732edc1263','e44617c6-4aa4-43e0-84e8-4f0b2a0a8c5c','75bc0b22-b15a-42fa-8cf2-3584942783f6',1,1),(1001,'a503ab26-f707-4923-86b6-049c17f73533','e08bbeeb-a30b-428c-bd4a-40198f792219','HEMI_ARCADE_POSTERIEUR_GAUCHE',NULL,'2022-05-17 18:40:17','2022-05-17 18:40:46','2022-05-17 18:40:25','2022-05-17 16:40:46','dee5ca38-e252-41d1-86ca-aebc66ae36fa','6aeb3c55-f3f0-4e74-9793-ec74659a28ad',NULL,NULL,'fba3c050-83af-4c2f-a411-0975c46179ac','6d53bd96-2c20-488f-b9c5-69c68f762598','3fe128aa-0e1b-4e6e-80e7-4b10abe3f501','1aa1663d-b6c0-47cd-9157-0c17e591468c','86743da6-1ee0-44f8-a265-3c6de7c6342a','93e015c7-46c1-406e-be60-bf0c78428875',1,1),(1001,'a525c976-46dd-42bc-abc1-c7cf71f9a1f1',NULL,'HEMI_ARCADE_POSTERIEUR_GAUCHE','2022-02-04 18:56:35','2022-02-04 14:58:28','2022-02-04 18:56:35','2022-02-04 14:58:28','2022-02-04 17:56:35','4ed7adaa-3b77-4537-8479-4d0c4bd28c7b','2a7068fc-0efa-496f-ade9-aba5b0650655',NULL,NULL,'93b9b214-5793-480a-b05f-e0419802faf3',NULL,NULL,NULL,NULL,NULL,1,1),(1001,'aa16f8ea-198d-4240-ab78-5a1f54823f0c',NULL,'HEMI_ARCADE_POSTERIEUR_GAUCHE','2022-05-16 19:48:35','2022-05-16 19:47:59','2022-05-16 19:48:35','2022-05-16 19:47:59','2022-05-16 17:48:35','909d9ecd-46b3-4692-868e-f6405507ecd1','c76850a7-9433-47f8-825d-ced9f35dede0',NULL,NULL,'d1eece96-1e6b-468d-8dc5-8295ca2149a4',NULL,NULL,NULL,NULL,NULL,1,6),(1001,'ac3a5a7c-5db4-4c82-a2a9-9cb52e09f003','229f401f-4824-48cc-8a9f-7a5549d69acd','HEMI_ARCADE_POSTERIEUR_GAUCHE','2022-05-12 14:34:04','2022-05-12 14:33:33',NULL,'2022-05-12 14:33:34','2022-05-12 12:34:04','cfcda3c3-749c-4f3d-96e2-556ed558ceef','b1201d2a-0fbf-48bc-a1c2-f3649c1ca576',NULL,NULL,'f4b07389-264e-4772-afc3-29b2187ced21','30443cfd-cdb4-4ea3-87e5-17e124205f74','303d11e3-0d3a-4c62-9d15-3ebe2e7bb93b','a68c2300-df5c-4b80-adbc-59147c325c82','072a7fd4-ae0e-46ae-8a9f-0fa5cc08ca50','a4896c47-7cb7-4dae-83eb-fa24f032eea2',1,4),(1001,'b2d8902e-d149-4c45-8357-5405aa15a337','292cc1aa-8b12-463b-87a1-7d9731cf886b','HEMI_ARCADE_ANTERIEUR',NULL,'2022-04-21 10:49:58',NULL,'2022-04-21 10:49:58','2022-04-21 08:49:58','3d958f24-3e12-4683-9cee-1d6c2a7022c8','171c6386-cba0-454c-a194-380c61a2ad2d','500ef012-99d0-4604-93eb-ec789b5a245b',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1),(1001,'b35629de-38d8-4cdd-bf2c-b61c461410cb','e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a','HEMI_ARCADE_POSTERIEUR_GAUCHE',NULL,'2022-02-07 19:05:55','2022-02-07 19:09:04','2022-02-07 19:05:55','2022-02-07 18:09:04','77ec818f-d778-4945-9458-90665b5522ba','e8550560-cfe0-40a1-bfb3-992d471fbcb7',NULL,NULL,'7b68804e-41db-41a7-9a19-d1aaecf91ab5','9bc487be-aea8-4232-90ae-806369f205fd','2408b3ef-b412-436d-a442-1944dba562c5','a2b88e98-2d9c-4985-b0c8-0632851521ac','3a2cd8ae-78bd-4479-87b5-e22f52cf10d1','65fd3ecb-affa-479b-8a28-d81f4574f5ef',1,6),(1001,'b903dd27-411a-4a7c-b357-1cc9a414dbdd','e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a','ARCADE_COMPLETE',NULL,'2022-02-12 17:53:18','2022-02-12 17:54:34','2022-02-12 17:53:18','2022-02-12 16:54:34','77ec818f-d778-4945-9458-90665b5522ba','d454a556-70ce-4c4c-8e13-114edfa03642',NULL,'f9c2783a-c405-481c-a97e-47bb9db0d0d2','6c9ae07a-23c3-4355-87ff-b57ef558a4ea','3c40df65-b847-40a7-b508-d8fe1ff90b07','797ff92c-f041-4f92-b744-b31285c7e136','fa8b41d6-b611-47ca-acf8-4318b9074c9e','32c963db-937e-4097-9147-82e959d76ecf','502162a6-a0d3-4c4e-9cf3-8d014a530435',1,7),(1001,'bd3e7087-752f-461a-a711-005a9abca257','7eb5bc72-17d3-47d8-9061-8fb639403734','HEMI_ARCADE_ANTERIEUR',NULL,'2022-04-21 13:15:49',NULL,'2022-04-21 13:15:49','2022-04-21 11:15:49','9937f6fe-f500-4cc5-acd7-39dadc5ac2e7','eafe4b37-e7ad-4f58-b931-a99f31f6d4a4','a6e9f7d5-ea01-4016-a5c9-4b948fbd5ded',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,2),(1001,'bee9b09b-e04f-4934-bed5-ff87653c2d91','c653584a-be75-45c7-92ec-e0eca5a2b6ca','HEMI_ARCADE_ANTERIEUR','2022-05-13 14:03:30','2022-05-13 12:17:47',NULL,'2022-05-13 12:17:47','2022-05-13 12:03:30','2d226451-8adb-4007-be22-99a9b3af61d6','6f906ffa-4828-4d68-a894-572a056b896b','f4fff5f5-f728-44ae-ac48-f3e653594098',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,2),(1001,'c2720962-7f97-4c1d-9fd2-d99334c4961e','45c9b517-ce12-4983-bf97-4e6a7e7d04c3','HEMI_ARCADE_POSTERIEUR_DROIT',NULL,'2022-02-15 13:39:02',NULL,'2022-02-15 13:39:02','2022-02-15 12:39:02','72adeb31-f7a3-4840-9f93-f10e61c84bef','9418414d-48f1-4a41-baa8-98bf650edaa3',NULL,'71fd8305-087d-4c31-82c4-b83df7b3cc9a',NULL,NULL,NULL,NULL,NULL,NULL,1,1),(1001,'c7bccd1e-370e-4347-8296-1bcd4c30b631','991beec3-fe9e-4c98-a3d4-c98e4a4c2471','HEMI_ARCADE_ANTERIEUR',NULL,'2022-09-10 11:45:43','2022-09-10 11:46:18','2022-09-10 11:45:43','2022-09-10 09:46:18','b06956a5-97b1-485d-b20a-8c33bd91a0ed','5f9e4be9-4eec-45c8-937d-583b1a5e8642','1ff80dd9-2d47-4292-adde-0923cb6fe572',NULL,NULL,'ac8b0ff0-1835-4c06-b555-8cd869ed8dcf','1d22f124-58fe-452c-bb7d-54d19e0ed5d4','390337fd-721e-490f-b704-0a456bfdee04','53730f49-b109-4397-a05a-fa05be3beb52','7fddb7f4-ade9-4efb-85ae-77539683dea6',1,10),(1001,'cb4cdc08-5d89-48dc-80a3-2e659c55f971',NULL,'HEMI_ARCADE_ANTERIEUR','2022-02-07 19:01:58','2022-02-07 18:52:17','2022-02-07 19:01:58','2022-02-07 18:52:17','2022-02-07 18:01:58','77ec818f-d778-4945-9458-90665b5522ba','e8550560-cfe0-40a1-bfb3-992d471fbcb7','499bf817-e96f-4ff6-ae84-c5c2ccc847c2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,4),(1001,'cf412dab-1d83-4db0-ae1b-d2724d5be97d','a2220645-c79d-4dda-b6cc-772384a4106b','HEMI_ARCADE_POSTERIEUR_DROIT',NULL,'2022-07-12 13:04:08','2022-07-12 13:04:32','2022-07-12 13:04:14','2022-07-12 11:04:32','914fba31-85f1-4c6e-85e2-bacfd3c1770c','38a668ff-3bd3-4238-90d7-65cc6f5a9ca7',NULL,'fb5993c3-7f31-49de-8a74-e83ef447f0a1',NULL,'565d69de-f728-4686-a5e9-490a8f086cd5','815860cb-19c9-4171-93d6-ec345254eb3e','977518ea-ece1-49a3-8637-c97f53f5e63a','0ff1b82e-f12c-4a7b-a24b-df36ab306f9a','3b0eba2e-2de6-4ec7-83c9-1e2c7c8ff4da',1,2),(1001,'d45158b2-baf8-4d40-a209-516d1c72f58d','bb63a653-1b34-4d80-a4bf-7fda5c9b0360','HEMI_ARCADE_POSTERIEUR_GAUCHE',NULL,'2022-02-01 11:51:50',NULL,'2022-02-01 11:51:50','2022-02-01 10:51:50','e3fea328-cb79-4ad5-a652-3eebe9ee3e12','bb2387c3-c044-46d4-bfeb-b3572a68a3e5',NULL,NULL,'812e813b-02e0-44c6-bb91-8e662cd9a614',NULL,NULL,NULL,NULL,NULL,1,2),(1001,'d58ce31f-4b72-44ad-b0e0-3d5d7d789322','80157bb6-d98e-4928-a658-75f9654bf520','HEMI_ARCADE_POSTERIEUR_DROIT','2022-01-19 12:15:36','2022-01-19 12:04:21',NULL,'2022-01-19 12:06:18','2022-01-19 11:15:36','03839278-13f8-46e6-9581-ba11bc8bcb81','c1f909ab-5469-4839-84f1-d04759dd1237',NULL,'a628b7db-c954-4964-8d48-1e09fa34d82b',NULL,'c6c573d5-7bda-4cd0-a449-03697aa6e5d0','4e0b586d-010c-4f46-ba34-26a139bf9937','9b6af1b1-98f8-49a2-b094-91fd0cf4bb06','10ae0671-57c9-4c70-b4bc-4d8748fa1b1b','33116074-3803-4c9a-9b0b-7f2ec0ea7b7f',1,1),(1001,'d5bff097-1085-4c55-afe3-1ce57126d88f','8cb97702-2ace-4345-9345-11d142b6c7b3','HEMI_ARCADE_ANTERIEUR',NULL,'2022-03-08 12:15:58','2022-03-08 12:16:26','2022-03-08 12:15:58','2022-03-08 11:16:26','48982add-ff93-4e3a-a453-012a73678b39','f2bad12a-451d-406d-98b0-e431a37951dd','90beda40-67c7-49a2-88be-64610235c1c8',NULL,NULL,'c22c34d6-3e86-4fba-8c43-6789f89dcca5','8807cbe4-80d2-4af2-9e28-4ad511514e42','439d33c4-cacc-42ff-8ae1-ae3420efe92c','b07a13e9-d146-40aa-9c8c-d08b70786222','7210d8cd-3a05-4560-b55f-80951c90c08c',1,2),(1001,'d7643aed-d242-47f6-8e1a-703d4672f109','229f401f-4824-48cc-8a9f-7a5549d69acd','ARCADE_COMPLETE',NULL,'2022-03-07 15:44:12','2022-03-07 15:44:47','2022-03-07 15:44:20','2022-03-07 14:44:47','cfcda3c3-749c-4f3d-96e2-556ed558ceef','fde05ea2-d0fd-419b-ba13-bf1a1bd03a22',NULL,'cb7d52e7-16ce-470b-9b62-b1f627e9badc','f4b07389-264e-4772-afc3-29b2187ced21','c1706d9d-89f0-4794-af54-6d74e899ee8d','78950e09-dd44-4ad7-8aa0-6799130478b6','21df10c9-ac4a-4a75-8a15-e5c30db28180','7f150a86-6fec-4718-a058-cd12d7a38305','f4469121-0967-4f3a-87f1-84867a02fa3a',1,2),(1001,'d8bec5dc-8405-473d-9ba5-ae6e461ed6fd','b3ae2904-41ee-4eef-9639-bb150af1853a','HEMI_ARCADE_ANTERIEUR','2022-02-04 19:14:41','2022-02-04 19:10:57',NULL,'2022-02-04 19:13:45','2022-02-04 18:14:41','59fb6872-6b71-417d-a7ee-ab313b732b6c','b28164eb-0070-4968-83be-bfabe1a0c839','f62659c6-4f30-430c-95e4-d14e40327192',NULL,NULL,'050930b4-ded7-45ca-885c-5ac156ea0cf7','adc3b531-b8c6-4f79-a5cf-5afae533973d','6bb63a3b-8000-4f0c-89f0-23596bbf5507','c675f19c-ea90-43f3-977b-db1bed22b847','e4bcc8ee-82bb-4e0a-851c-96cc266d0f0e',1,1),(1001,'d9818808-7d5e-47e6-9880-cc95357483ff','bce8310f-eee9-4f0a-a6b7-d592dec66be5','HEMI_ARCADE_POSTERIEUR_GAUCHE',NULL,'2022-05-24 11:42:36','2022-05-24 11:43:01','2022-05-24 11:42:41','2022-05-24 09:43:01','49ae59fe-0bc4-4d86-b65e-d8788e2d12fb','bd194eb4-5c69-43b1-94bb-66c7ae8aa0ce',NULL,NULL,'315ac573-ca2e-4c47-8969-e667ad225aa2','21f16639-e10d-42f9-b1b1-ecd1dbc0e28b','01bd7ce5-4459-41fa-9f87-0c8c8693ddd6','ef2526bf-1d12-4d61-aa9f-fa114f53ea2d','05c15182-223b-47c3-a79a-728540db8292','2e01a63c-1021-4a88-8ff7-135b62add7d5',1,2),(1001,'e15a2d21-e8f2-4d2a-9a68-13d92ae4b997','b3ae2904-41ee-4eef-9639-bb150af1853a','HEMI_ARCADE_ANTERIEUR',NULL,'2022-02-04 19:23:45','2022-02-04 19:25:04','2022-02-04 19:23:45','2022-02-04 18:25:04','59fb6872-6b71-417d-a7ee-ab313b732b6c','b28164eb-0070-4968-83be-bfabe1a0c839','f62659c6-4f30-430c-95e4-d14e40327192',NULL,NULL,'c7e78dc4-b222-4213-bd88-e0e8eaf1dd57','0ed2aa3b-9a59-495c-9032-f6eb5757beb8','d52438e1-2ecc-430e-99a2-d453d1778813','29171666-f57b-4fcc-893b-6e01da2033fe','33b3a130-dc00-43ca-a57f-6d86e6efa62c',1,3),(1001,'e18e3c3f-c354-4bd4-93ba-b2ab990d59ca','8052e101-fd65-454a-bce4-f65648f63218','HEMI_ARCADE_POSTERIEUR_GAUCHE','2022-05-31 14:12:55','2022-05-31 14:12:09',NULL,'2022-05-31 14:12:09','2022-05-31 12:12:55','7b00996b-90f8-4307-9a8c-263a28f1b341','2a38e9c2-6808-43f3-904a-decdb37d60d5',NULL,NULL,'f5ab063d-18f1-443e-b694-fd1ef20e9e78',NULL,NULL,NULL,NULL,NULL,1,2),(1001,'e23c031c-2c78-414b-840d-85b58e959fbe','55b947cc-3654-4f0a-b3b9-0a706eb6f5d3','HEMI_ARCADE_ANTERIEUR',NULL,'2022-01-19 16:26:52','2022-01-19 16:28:32','2022-01-19 16:26:52','2022-01-19 15:28:32','0bf938e8-3ff3-4e2d-981d-f2db30285d60','20c281c1-af15-40ce-8892-18a2507513e3','4d153a25-3b94-464b-9b18-2966d8ae2ce6',NULL,NULL,'0736b41f-5f3b-4cc2-98dc-956017612fa7','ed70198e-0fdb-4e4d-989c-b5d7db128c36','ae8bfa69-d95e-46a3-bb3e-cc68442120e2','f795a9ab-dea1-4d0f-962a-1654168718cd','7b448472-93a0-4faf-a51d-7e632836d89d',1,4),(1001,'e2722784-a66c-4ece-91c0-2add756415ea',NULL,'HEMI_ARCADE_POSTERIEUR_GAUCHE','2022-05-13 18:32:17','2022-05-13 18:31:42','2022-05-13 18:32:17','2022-05-13 18:31:42','2022-05-13 16:32:17','909d9ecd-46b3-4692-868e-f6405507ecd1','c76850a7-9433-47f8-825d-ced9f35dede0',NULL,NULL,'aa38e68a-4c1f-4e58-a176-2a4d533c35a0',NULL,NULL,NULL,NULL,NULL,1,5),(1001,'e3775f5f-7eaa-40f6-a920-7eafdbde19d8','991beec3-fe9e-4c98-a3d4-c98e4a4c2471','ARCADE_COMPLETE','2022-09-09 18:38:28','2022-09-09 18:28:39',NULL,'2022-09-09 18:28:39','2022-09-09 16:38:28','b06956a5-97b1-485d-b20a-8c33bd91a0ed','5f9e4be9-4eec-45c8-937d-583b1a5e8642',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,6),(1001,'e51f8424-0e93-4ec5-8ed6-4c739f59940c','991beec3-fe9e-4c98-a3d4-c98e4a4c2471','ARCADE_COMPLETE','2022-09-09 18:22:37','2022-09-09 18:19:33',NULL,'2022-09-09 18:19:33','2022-09-09 16:30:34','b06956a5-97b1-485d-b20a-8c33bd91a0ed','5f9e4be9-4eec-45c8-937d-583b1a5e8642',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,2),(1001,'e9a397c8-e329-4471-985b-0eb40ed458b0',NULL,'HEMI_ARCADE_ANTERIEUR','2022-02-04 14:53:02','2022-02-04 14:50:30','2022-02-04 14:53:02','2022-02-04 14:50:30','2022-02-04 13:53:02','4ed7adaa-3b77-4537-8479-4d0c4bd28c7b','d87d63d7-4507-4391-b749-4b160c9363ed','04abc032-a797-420b-8d5e-ee9528f5e291',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1),(1001,'e9bfc750-6943-42bf-8c0b-b7e1dc1803c5','80157bb6-d98e-4928-a658-75f9654bf520','HEMI_ARCADE_ANTERIEUR',NULL,'2022-01-19 12:12:01','2022-01-19 14:04:54','2022-01-19 12:12:14','2022-01-19 13:04:54','03839278-13f8-46e6-9581-ba11bc8bcb81','c1f909ab-5469-4839-84f1-d04759dd1237','36a05dde-4390-4db1-9df5-ea42cd16ed7d',NULL,NULL,'7ca6f680-78d4-4290-b246-10418b29f7f5','21347aa2-1d83-49d6-a245-e30506990fbc','e7ee6629-78a7-40cc-94c3-5a0026b3a530','573423ef-791f-4a2f-aa1f-bb3662f66baa','3943b273-3c44-4676-9549-5fe85a49e6a8',1,2),(1001,'ea89007b-3846-43ef-92f9-d5c7aa1a7dfa',NULL,'HEMI_ARCADE_POSTERIEUR_GAUCHE','2022-05-25 10:56:32','2022-05-13 18:35:18','2022-05-25 10:56:32','2022-05-13 18:35:18','2022-05-25 08:56:32','909d9ecd-46b3-4692-868e-f6405507ecd1','c76850a7-9433-47f8-825d-ced9f35dede0',NULL,NULL,'aa38e68a-4c1f-4e58-a176-2a4d533c35a0',NULL,NULL,NULL,NULL,NULL,1,5),(1001,'eda12645-c63c-4940-a316-5f8af09f88ec','229f401f-4824-48cc-8a9f-7a5549d69acd','HEMI_ARCADE_POSTERIEUR_DROIT',NULL,'2022-03-07 15:38:44',NULL,'2022-03-07 15:38:44','2022-03-07 14:38:44','cfcda3c3-749c-4f3d-96e2-556ed558ceef','fde05ea2-d0fd-419b-ba13-bf1a1bd03a22',NULL,'f4b07389-264e-4772-afc3-29b2187ced21',NULL,NULL,NULL,NULL,NULL,NULL,1,1),(1001,'ef8de12b-a05c-4450-b4cd-8eeac315d65a','bb63a653-1b34-4d80-a4bf-7fda5c9b0360','HEMI_ARCADE_POSTERIEUR_GAUCHE',NULL,'2022-02-01 11:49:15',NULL,'2022-02-01 11:49:15','2022-02-01 10:49:15','e3fea328-cb79-4ad5-a652-3eebe9ee3e12','bb2387c3-c044-46d4-bfeb-b3572a68a3e5',NULL,NULL,'3e9aff47-e0ac-4b19-973d-d25c0bab00c9',NULL,NULL,NULL,NULL,NULL,1,1),(1001,'f5a1d90b-6b44-4581-b87d-e65eb26edb83','8052e101-fd65-454a-bce4-f65648f63218','HEMI_ARCADE_ANTERIEUR','2022-05-31 14:14:00','2022-05-31 14:13:16',NULL,'2022-05-31 14:13:16','2022-05-31 12:14:00','7b00996b-90f8-4307-9a8c-263a28f1b341','2a38e9c2-6808-43f3-904a-decdb37d60d5','999aa1db-d517-4b25-8095-2a4a53e4d5af',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,3),(1001,'f6834fbc-9e79-49cb-85ea-fbc67fdec249','7eb5bc72-17d3-47d8-9061-8fb639403734','HEMI_ARCADE_POSTERIEUR_DROIT',NULL,'2022-04-21 13:16:36',NULL,'2022-04-21 13:16:36','2022-04-21 17:37:46','9937f6fe-f500-4cc5-acd7-39dadc5ac2e7','725ef2a4-4b53-4ec9-a807-17759213c882',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,3),(1001,'f6e8847f-6218-4a44-ad6f-da702b32b2a8','7eb5bc72-17d3-47d8-9061-8fb639403734','HEMI_ARCADE_POSTERIEUR_DROIT',NULL,'2022-04-21 13:15:27',NULL,'2022-04-21 13:15:27','2022-04-21 17:37:46','9937f6fe-f500-4cc5-acd7-39dadc5ac2e7','eafe4b37-e7ad-4f58-b931-a99f31f6d4a4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1),(1001,'f9e18676-d6bb-44e8-b093-43cb88b0d897',NULL,'HEMI_ARCADE_POSTERIEUR_GAUCHE','2022-05-16 19:54:27','2022-05-16 19:53:29','2022-05-16 19:54:27','2022-05-16 19:53:29','2022-05-16 17:54:27','909d9ecd-46b3-4692-868e-f6405507ecd1','c76850a7-9433-47f8-825d-ced9f35dede0',NULL,NULL,'aa38e68a-4c1f-4e58-a176-2a4d533c35a0',NULL,NULL,NULL,NULL,NULL,1,6),(1001,'f9f6d9d2-cc34-43c3-9f5f-4b8e54b41bbb','292cc1aa-8b12-463b-87a1-7d9731cf886b','HEMI_ARCADE_POSTERIEUR_DROIT',NULL,'2022-04-21 10:52:59','2022-04-21 10:53:24','2022-04-21 10:53:03','2022-04-21 08:53:24','3d958f24-3e12-4683-9cee-1d6c2a7022c8','171c6386-cba0-454c-a194-380c61a2ad2d',NULL,'d1ea0460-f48a-4dc1-a0ae-c13f265abac4',NULL,'881fa71e-8ff2-48d9-90d7-929e8ee439ed','27492cd3-eb70-48a2-876e-dce55c90a17a','ff0fa2f4-c2ea-42f1-a9f5-24c597282c66','6e9fc174-28d5-42d8-bbc0-dd92bf08bde1','642f1d21-72b4-419c-b005-26b9f2557b21',1,2),(1001,'fa1c1f6f-5c0d-45ca-8646-2a1ca68f51b4',NULL,'HEMI_ARCADE_POSTERIEUR_GAUCHE','2022-05-16 19:51:10','2022-05-16 19:50:25','2022-05-16 19:51:10','2022-05-16 19:50:25','2022-05-16 17:51:10','909d9ecd-46b3-4692-868e-f6405507ecd1','c76850a7-9433-47f8-825d-ced9f35dede0',NULL,NULL,'d1eece96-1e6b-468d-8dc5-8295ca2149a4',NULL,NULL,NULL,NULL,NULL,1,6),(1001,'ff8547d7-27f8-4862-9b63-e713dd817f3f',NULL,'HEMI_ARCADE_POSTERIEUR_DROIT','2022-09-09 19:04:15','2022-09-09 19:03:34','2022-09-09 19:04:15','2022-09-09 19:03:34','2022-09-10 08:18:24','b06956a5-97b1-485d-b20a-8c33bd91a0ed','5f9e4be9-4eec-45c8-937d-583b1a5e8642',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,10);
/*!40000 ALTER TABLE `Occlusion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `OcclusionFile`
--

DROP TABLE IF EXISTS `OcclusionFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `OcclusionFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `fileID` char(36) NOT NULL,
  `occlusionID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `occlusionType` enum('OCCLUSION_RESULT','MANDIBULE_PLY','MAXILLAIRE_PLY','LEFT_BITE','RIGHT_BITE','ANTERIOR_BITE','SCREENSHOT','LIFI','MANDIBULE_MATRIX','MAXILLAIRE_MATRIX') DEFAULT 'OCCLUSION_RESULT',
  PRIMARY KEY (`fileID`,`occlusionID`,`ownerID`),
  KEY `fk_OcclusionFile_CondorFile` (`fileID`,`ownerID`),
  KEY `fk_OcclusionFile_Occlusion` (`occlusionID`,`ownerID`),
  CONSTRAINT `fk_OcclusionFile_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_OcclusionFile_Occlusion` FOREIGN KEY (`occlusionID`, `ownerID`) REFERENCES `Occlusion` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `OcclusionFile`
--

LOCK TABLES `OcclusionFile` WRITE;
/*!40000 ALTER TABLE `OcclusionFile` DISABLE KEYS */;
INSERT INTO `OcclusionFile` VALUES (1001,'01bd7ce5-4459-41fa-9f87-0c8c8693ddd6','d9818808-7d5e-47e6-9880-cc95357483ff','2022-05-24 09:42:41','OCCLUSION_RESULT'),(1001,'01d3e05e-ff13-4067-b5bd-5ec37bbc3d2c','94a0167c-6798-4c78-a76c-cb9fc91ccdda','2022-06-28 15:03:25','OCCLUSION_RESULT'),(1001,'050930b4-ded7-45ca-885c-5ac156ea0cf7','d8bec5dc-8405-473d-9ba5-ae6e461ed6fd','2022-02-04 18:13:44','OCCLUSION_RESULT'),(1001,'05c15182-223b-47c3-a79a-728540db8292','d9818808-7d5e-47e6-9880-cc95357483ff','2022-05-24 09:42:41','OCCLUSION_RESULT'),(1001,'0604d07a-bebf-444d-b0d3-ef45e6312bb6','812fdd67-c9dc-4e0c-806a-0524a386b296','2022-02-07 17:54:30','OCCLUSION_RESULT'),(1001,'072a7fd4-ae0e-46ae-8a9f-0fa5cc08ca50','ac3a5a7c-5db4-4c82-a2a9-9cb52e09f003','2022-05-12 12:33:34','OCCLUSION_RESULT'),(1001,'0736b41f-5f3b-4cc2-98dc-956017612fa7','e23c031c-2c78-414b-840d-85b58e959fbe','2022-01-19 15:26:52','OCCLUSION_RESULT'),(1001,'081335b0-4cf5-4720-ac13-b858da5d8e93','778ed9fd-f658-471d-9dd0-a48417419cba','2022-05-12 12:31:43','OCCLUSION_RESULT'),(1001,'08509c37-5e28-4b88-b2ce-fd2bd6b2e379','864c98a3-fcf7-466a-b999-13bd4dfb8c65','2022-05-25 08:32:43','OCCLUSION_RESULT'),(1001,'08725014-e287-4ddd-9b4f-f24b8ede2c81','7a922eb8-5139-40fe-8402-fc7ff4204a1a','2022-05-24 09:42:09','OCCLUSION_RESULT'),(1001,'0a6f7e88-646e-4386-a4b9-0847224e61ab','35af1bf5-285a-4bb1-a6db-fe9897defe51','2022-05-25 08:32:43','OCCLUSION_RESULT'),(1001,'0abefe94-3f85-4adb-b30a-34fe734e64a2','94a0167c-6798-4c78-a76c-cb9fc91ccdda','2022-06-28 15:03:25','OCCLUSION_RESULT'),(1001,'0b902cd8-144a-4a2d-a2da-dc9d7a13668b','7a5acfd0-87ca-4009-aa4e-677a88ceffde','2022-05-31 10:53:55','OCCLUSION_RESULT'),(1001,'0c0b6b4b-ea96-436e-870c-67030a45f51f','00405f86-eefa-41f9-8d98-1fa9cbeef855','2022-05-25 09:02:54','OCCLUSION_RESULT'),(1001,'0ed2aa3b-9a59-495c-9032-f6eb5757beb8','e15a2d21-e8f2-4d2a-9a68-13d92ae4b997','2022-02-04 18:23:45','OCCLUSION_RESULT'),(1001,'0ff1b82e-f12c-4a7b-a24b-df36ab306f9a','cf412dab-1d83-4db0-ae1b-d2724d5be97d','2022-07-12 11:04:14','OCCLUSION_RESULT'),(1001,'1050fd18-33ef-4994-bb2b-d74c35a009b6','9c318e86-fa90-4cd9-8319-2503cde2b455','2022-06-14 13:29:56','OCCLUSION_RESULT'),(1001,'10ae0671-57c9-4c70-b4bc-4d8748fa1b1b','d58ce31f-4b72-44ad-b0e0-3d5d7d789322','2022-01-19 11:06:18','OCCLUSION_RESULT'),(1001,'10b7f922-a161-46d6-acb1-9b8427a0b3e5','812fdd67-c9dc-4e0c-806a-0524a386b296','2022-02-07 17:54:30','OCCLUSION_RESULT'),(1001,'1147b9ad-8062-49b0-abb8-e21503c142a6','65f9077d-c859-4b2c-9d4d-692d723315a5','2022-05-13 12:07:00','OCCLUSION_RESULT'),(1001,'1307b63c-d68c-40b7-a3ff-4fc477f139dc','7c70edbe-5cb4-4244-8baf-7caf2bd7d86b','2022-02-04 17:58:48','OCCLUSION_RESULT'),(1001,'1427d616-5653-4d37-a57b-c647c2ad237c','87edc123-163f-46ce-be5c-45f2ff80b857','2022-05-12 12:26:51','OCCLUSION_RESULT'),(1001,'1485361c-1943-4401-8ed1-23059245eae1','727485e0-8637-4024-83d8-95544991f73f','2022-06-03 14:07:00','OCCLUSION_RESULT'),(1001,'1560fe3c-2fde-4b99-b398-f1c254efa26c','65f9077d-c859-4b2c-9d4d-692d723315a5','2022-05-13 12:07:00','OCCLUSION_RESULT'),(1001,'158c2a75-1b0f-417a-8ed0-a7fb6ac2a492','7d8decb1-23db-4824-940f-8d8822d88813','2022-02-07 17:48:45','OCCLUSION_RESULT'),(1001,'174df459-b65b-4330-9f93-b725dfc602d1','9440baee-a8bf-406c-bc0a-f5e9596f197b','2022-05-13 16:13:11','OCCLUSION_RESULT'),(1001,'1759d630-e2be-4ef5-8fe0-f2f6a8a10873','8e4092a3-64a2-4464-addd-03b3c8ba2289','2022-05-13 16:20:53','OCCLUSION_RESULT'),(1001,'175aa819-aaa5-44a2-bc16-b58049070c3b','864c98a3-fcf7-466a-b999-13bd4dfb8c65','2022-05-25 10:46:42','OCCLUSION_RESULT'),(1001,'1918f151-9602-438b-911f-8fa1ba5b7218','e9a397c8-e329-4471-985b-0eb40ed458b0','2022-02-04 13:50:30','OCCLUSION_RESULT'),(1001,'19ea170f-c063-4a37-972a-35885657c236','9440baee-a8bf-406c-bc0a-f5e9596f197b','2022-05-13 16:13:11','OCCLUSION_RESULT'),(1001,'1a0767db-326c-4cdc-96d6-37bbfc6c059c','161f60a4-d4f2-41f1-98ad-a8ccad84216c','2022-01-24 17:46:00','OCCLUSION_RESULT'),(1001,'1a697c44-46ac-43a0-82b9-a46dbc74a391','8b14563e-0862-4cac-8045-e8aed2be886d','2022-07-12 10:57:24','OCCLUSION_RESULT'),(1001,'1aa1663d-b6c0-47cd-9157-0c17e591468c','a503ab26-f707-4923-86b6-049c17f73533','2022-05-17 16:40:25','OCCLUSION_RESULT'),(1001,'1bfdf28b-74a5-4572-8ee8-9f2091668cf7','cb4cdc08-5d89-48dc-80a3-2e659c55f971','2022-02-07 17:52:17','OCCLUSION_RESULT'),(1001,'1cc7ae90-17d0-4892-b281-93a08c20fffa','1500b3eb-4b86-46c1-9c9f-7efbd0224ac8','2022-05-13 16:22:04','OCCLUSION_RESULT'),(1001,'1d033a05-b36d-48d3-a077-cba01c0ba281','35af1bf5-285a-4bb1-a6db-fe9897defe51','2022-05-25 10:45:09','OCCLUSION_RESULT'),(1001,'1d22f124-58fe-452c-bb7d-54d19e0ed5d4','c7bccd1e-370e-4347-8296-1bcd4c30b631','2022-09-10 09:45:43','OCCLUSION_RESULT'),(1001,'1e34800f-6443-4433-a2fd-ac3d1de66258','7a922eb8-5139-40fe-8402-fc7ff4204a1a','2022-05-24 09:42:09','OCCLUSION_RESULT'),(1001,'1ee80ca4-d94e-45b0-8e49-65d950ee4df9','fa1c1f6f-5c0d-45ca-8646-2a1ca68f51b4','2022-05-16 17:50:25','OCCLUSION_RESULT'),(1001,'204b529d-94bd-48ef-b172-5317b14df862','84d73896-4c7a-4dc0-994a-b2a70e3d1cf2','2022-06-28 09:07:03','OCCLUSION_RESULT'),(1001,'20f94b95-aaa7-41af-af0d-73dcf93e1a3c','26ae7fce-0ea3-479f-9989-7d0a3a19aaf7','2022-02-07 17:58:31','OCCLUSION_RESULT'),(1001,'20fe8caf-9985-46f2-a4af-5f1b220a188f','03fe87bc-2a25-4d16-a476-2df62bb3cf76','2022-07-04 14:13:45','OCCLUSION_RESULT'),(1001,'21347aa2-1d83-49d6-a245-e30506990fbc','e9bfc750-6943-42bf-8c0b-b7e1dc1803c5','2022-01-19 11:12:14','OCCLUSION_RESULT'),(1001,'21df10c9-ac4a-4a75-8a15-e5c30db28180','d7643aed-d242-47f6-8e1a-703d4672f109','2022-03-07 14:44:20','OCCLUSION_RESULT'),(1001,'21f16639-e10d-42f9-b1b1-ecd1dbc0e28b','d9818808-7d5e-47e6-9880-cc95357483ff','2022-05-24 09:42:41','OCCLUSION_RESULT'),(1001,'222e5132-509a-41d5-9b54-889df4e0023e','aa16f8ea-198d-4240-ab78-5a1f54823f0c','2022-05-16 17:47:59','OCCLUSION_RESULT'),(1001,'2408b3ef-b412-436d-a442-1944dba562c5','b35629de-38d8-4cdd-bf2c-b61c461410cb','2022-02-07 18:05:55','OCCLUSION_RESULT'),(1001,'2413d387-ed67-4527-b74d-3bc45541eadf','fa1c1f6f-5c0d-45ca-8646-2a1ca68f51b4','2022-05-16 17:50:25','OCCLUSION_RESULT'),(1001,'24532129-ed40-4cea-a3b3-8012bb0d2259','fa1c1f6f-5c0d-45ca-8646-2a1ca68f51b4','2022-05-16 17:50:25','OCCLUSION_RESULT'),(1001,'24b218af-fcc6-4d11-8bc7-0d12769286f9','2de3d2bb-d512-4514-8bed-a879b73a6028','2022-04-21 11:29:16','OCCLUSION_RESULT'),(1001,'2505eb15-7090-4f82-ad06-2fbd8aea623a','84d73896-4c7a-4dc0-994a-b2a70e3d1cf2','2022-06-28 09:07:03','OCCLUSION_RESULT'),(1001,'251f57eb-36ef-45d5-affe-51494469c59a','a525c976-46dd-42bc-abc1-c7cf71f9a1f1','2022-02-04 13:58:28','OCCLUSION_RESULT'),(1001,'25d4cc8b-2ba5-422c-b88a-0cecfa682ae3','65f9077d-c859-4b2c-9d4d-692d723315a5','2022-05-13 12:07:00','OCCLUSION_RESULT'),(1001,'26486b53-a539-40e3-b121-f2aa550df56e','e9a397c8-e329-4471-985b-0eb40ed458b0','2022-02-04 13:50:30','OCCLUSION_RESULT'),(1001,'26c6a3a9-4104-4bbb-a17d-704486a1f413','03fe87bc-2a25-4d16-a476-2df62bb3cf76','2022-07-04 14:13:45','OCCLUSION_RESULT'),(1001,'27492cd3-eb70-48a2-876e-dce55c90a17a','f9f6d9d2-cc34-43c3-9f5f-4b8e54b41bbb','2022-04-21 08:53:03','OCCLUSION_RESULT'),(1001,'27571368-d410-426c-bb87-4de2c6774315','0bc29ff9-efea-448d-b521-2c39fd4faa78','2022-03-08 11:17:37','OCCLUSION_RESULT'),(1001,'28a9fce2-d866-4a71-92dc-42eef3b92846','1500b3eb-4b86-46c1-9c9f-7efbd0224ac8','2022-05-13 16:22:04','OCCLUSION_RESULT'),(1001,'28ffc1de-2be4-4a19-87be-aecd0b0aa83f','6960b50e-6f78-4f83-9303-8c985410457c','2022-05-31 14:55:44','OCCLUSION_RESULT'),(1001,'29171666-f57b-4fcc-893b-6e01da2033fe','e15a2d21-e8f2-4d2a-9a68-13d92ae4b997','2022-02-04 18:23:45','OCCLUSION_RESULT'),(1001,'29214935-0f63-4c89-bfb3-06abb6bbb7ae','ff8547d7-27f8-4862-9b63-e713dd817f3f','2022-09-09 17:03:34','OCCLUSION_RESULT'),(1001,'2a8fdc87-7a3f-47e4-83f8-76543163cd17','0bc29ff9-efea-448d-b521-2c39fd4faa78','2022-03-08 11:17:37','OCCLUSION_RESULT'),(1001,'2b408b13-2a9b-4477-8eea-ca0d2ef357cf','42098ceb-3335-4f13-8aed-b29c37a5f57f','2022-04-21 11:28:43','OCCLUSION_RESULT'),(1001,'2bbd50df-4190-4607-a3d7-f1d8663a4cb1','7d8decb1-23db-4824-940f-8d8822d88813','2022-02-07 17:48:45','OCCLUSION_RESULT'),(1001,'2e01a63c-1021-4a88-8ff7-135b62add7d5','d9818808-7d5e-47e6-9880-cc95357483ff','2022-05-24 09:42:41','OCCLUSION_RESULT'),(1001,'2e5771c3-2656-438e-88f4-f38de1cdf014','94a0167c-6798-4c78-a76c-cb9fc91ccdda','2022-06-28 15:03:25','OCCLUSION_RESULT'),(1001,'303d11e3-0d3a-4c62-9d15-3ebe2e7bb93b','ac3a5a7c-5db4-4c82-a2a9-9cb52e09f003','2022-05-12 12:33:34','OCCLUSION_RESULT'),(1001,'30443cfd-cdb4-4ea3-87e5-17e124205f74','ac3a5a7c-5db4-4c82-a2a9-9cb52e09f003','2022-05-12 12:33:33','OCCLUSION_RESULT'),(1001,'30720071-8a94-43cc-8fd5-1a603f6e4072','00405f86-eefa-41f9-8d98-1fa9cbeef855','2022-05-25 09:02:54','OCCLUSION_RESULT'),(1001,'3091a3f3-f34b-4876-8a99-9c2aa5f3ac00','812fdd67-c9dc-4e0c-806a-0524a386b296','2022-02-07 17:54:30','OCCLUSION_RESULT'),(1001,'30e287e4-f479-42bb-a57e-e27ecab9f8ef','8b14563e-0862-4cac-8045-e8aed2be886d','2022-07-12 10:57:24','OCCLUSION_RESULT'),(1001,'31df9b40-ce6a-441c-a253-232bfee6d11d','0d180e89-cc7f-4718-abf6-79b3ada7fd3c','2022-02-15 12:49:40','OCCLUSION_RESULT'),(1001,'3208f8ef-621d-43b2-b795-42c3bda237c7','35af1bf5-285a-4bb1-a6db-fe9897defe51','2022-05-13 12:11:07','OCCLUSION_RESULT'),(1001,'3220ff46-caf1-419c-a89c-e443c01aed51','26ae7fce-0ea3-479f-9989-7d0a3a19aaf7','2022-02-07 17:58:31','OCCLUSION_RESULT'),(1001,'323c571d-5135-43a3-8d38-00a71feaa843','864c98a3-fcf7-466a-b999-13bd4dfb8c65','2022-05-25 08:32:43','OCCLUSION_RESULT'),(1001,'32c963db-937e-4097-9147-82e959d76ecf','b903dd27-411a-4a7c-b357-1cc9a414dbdd','2022-02-12 16:53:18','OCCLUSION_RESULT'),(1001,'33116074-3803-4c9a-9b0b-7f2ec0ea7b7f','d58ce31f-4b72-44ad-b0e0-3d5d7d789322','2022-01-19 11:06:18','OCCLUSION_RESULT'),(1001,'3358903e-3e70-4a5e-927b-c3466331075a','77753fb3-75a1-45c2-9191-7a5d98206df2','2022-06-14 12:06:33','OCCLUSION_RESULT'),(1001,'33b3a130-dc00-43ca-a57f-6d86e6efa62c','e15a2d21-e8f2-4d2a-9a68-13d92ae4b997','2022-02-04 18:23:45','OCCLUSION_RESULT'),(1001,'33c1a04d-cbe7-4edc-920a-e235f4da07ff','ff8547d7-27f8-4862-9b63-e713dd817f3f','2022-09-09 17:03:34','OCCLUSION_RESULT'),(1001,'390337fd-721e-490f-b704-0a456bfdee04','c7bccd1e-370e-4347-8296-1bcd4c30b631','2022-09-10 09:45:43','OCCLUSION_RESULT'),(1001,'3943b273-3c44-4676-9549-5fe85a49e6a8','e9bfc750-6943-42bf-8c0b-b7e1dc1803c5','2022-01-19 11:12:14','OCCLUSION_RESULT'),(1001,'3a2cd8ae-78bd-4479-87b5-e22f52cf10d1','b35629de-38d8-4cdd-bf2c-b61c461410cb','2022-02-07 18:05:55','OCCLUSION_RESULT'),(1001,'3af8da16-1c78-4867-83f5-40af48dbf8ae','0bc29ff9-efea-448d-b521-2c39fd4faa78','2022-03-08 11:17:37','OCCLUSION_RESULT'),(1001,'3b0eba2e-2de6-4ec7-83c9-1e2c7c8ff4da','cf412dab-1d83-4db0-ae1b-d2724d5be97d','2022-07-12 11:04:14','OCCLUSION_RESULT'),(1001,'3b1b8529-9696-4bae-8527-ef23772fe66a','704a0750-2a24-448f-8f30-928139977895','2022-03-08 11:49:34','OCCLUSION_RESULT'),(1001,'3c40df65-b847-40a7-b508-d8fe1ff90b07','b903dd27-411a-4a7c-b357-1cc9a414dbdd','2022-02-12 16:53:18','OCCLUSION_RESULT'),(1001,'3fe128aa-0e1b-4e6e-80e7-4b10abe3f501','a503ab26-f707-4923-86b6-049c17f73533','2022-05-17 16:40:25','OCCLUSION_RESULT'),(1001,'409dd0ba-1f03-4042-8f03-5144dba2e69e','8b14563e-0862-4cac-8045-e8aed2be886d','2022-07-19 12:28:21','OCCLUSION_RESULT'),(1001,'430563f9-b0c8-4cb8-80de-b74c4152c2d2','1500b3eb-4b86-46c1-9c9f-7efbd0224ac8','2022-05-13 16:22:04','OCCLUSION_RESULT'),(1001,'439d33c4-cacc-42ff-8ae1-ae3420efe92c','d5bff097-1085-4c55-afe3-1ce57126d88f','2022-03-08 11:15:58','OCCLUSION_RESULT'),(1001,'43bf2afa-4f73-488a-b1fc-60b302be27b3','161f60a4-d4f2-41f1-98ad-a8ccad84216c','2022-01-24 17:46:00','OCCLUSION_RESULT'),(1001,'4447b3ff-fae6-4112-b63c-3a9385ee2158','8e4092a3-64a2-4464-addd-03b3c8ba2289','2022-05-13 16:20:53','OCCLUSION_RESULT'),(1001,'44c9a086-ebd4-4513-b03b-df67f000a760','ff8547d7-27f8-4862-9b63-e713dd817f3f','2022-09-09 17:03:34','OCCLUSION_RESULT'),(1001,'45057e79-706b-4ee4-9c23-ad93f8923f71','e2722784-a66c-4ece-91c0-2add756415ea','2022-05-13 16:31:42','OCCLUSION_RESULT'),(1001,'452d955d-b844-42ed-9edf-9d005a4afa46','3a1fff1c-0427-409c-aa94-06326e554d82','2022-05-30 11:09:22','OCCLUSION_RESULT'),(1001,'45bad5da-e084-4bfd-828b-fd44fd367e7b','aa16f8ea-198d-4240-ab78-5a1f54823f0c','2022-05-16 17:47:59','OCCLUSION_RESULT'),(1001,'463c7b84-774c-483c-ab9a-89a270919932','70f4220e-2a6b-4575-bd0e-09c14a13d758','2022-06-16 11:03:55','OCCLUSION_RESULT'),(1001,'46812872-d002-4e9b-a255-b85e584a028a','cb4cdc08-5d89-48dc-80a3-2e659c55f971','2022-02-07 17:52:17','OCCLUSION_RESULT'),(1001,'47ac428d-e0c9-491a-a37b-11c7e4ec7b7b','fa1c1f6f-5c0d-45ca-8646-2a1ca68f51b4','2022-05-16 17:50:25','OCCLUSION_RESULT'),(1001,'47fc8529-a72e-460b-8907-3892e470eebb','35af1bf5-285a-4bb1-a6db-fe9897defe51','2022-05-25 10:46:42','OCCLUSION_RESULT'),(1001,'48a4df55-ee3e-4ecc-a344-338002adecd5','87edc123-163f-46ce-be5c-45f2ff80b857','2022-05-12 12:26:51','OCCLUSION_RESULT'),(1001,'48ca5e89-974f-45f9-85f2-85c4644fb297','4e1258a6-b789-451f-bfe8-8b395e1129d8','2022-01-19 15:24:43','OCCLUSION_RESULT'),(1001,'4a1a5a35-8969-4721-8ec6-7e6b023b1fdf','9440baee-a8bf-406c-bc0a-f5e9596f197b','2022-05-13 16:13:11','OCCLUSION_RESULT'),(1001,'4b05a0d4-2193-4350-856f-f38547af5710','ea89007b-3846-43ef-92f9-d5c7aa1a7dfa','2022-05-13 16:35:18','OCCLUSION_RESULT'),(1001,'4b90930b-b4dd-4eae-8b5f-8c8f04e970c6','6960b50e-6f78-4f83-9303-8c985410457c','2022-05-31 14:55:44','OCCLUSION_RESULT'),(1001,'4bc8bbc2-a943-4af1-a2a9-b06f461fcfcc','7d8decb1-23db-4824-940f-8d8822d88813','2022-02-07 17:48:45','OCCLUSION_RESULT'),(1001,'4bf52f65-04f9-420f-bc0d-457f239f1bc0','2de3d2bb-d512-4514-8bed-a879b73a6028','2022-04-21 11:29:16','OCCLUSION_RESULT'),(1001,'4e0a0002-d93c-4b33-ba51-9cc84cb7c62e','ea89007b-3846-43ef-92f9-d5c7aa1a7dfa','2022-05-13 16:35:18','OCCLUSION_RESULT'),(1001,'4e0a4109-35b7-4c91-b28f-2ae7a227dbb7','70f4220e-2a6b-4575-bd0e-09c14a13d758','2022-06-16 11:03:55','OCCLUSION_RESULT'),(1001,'4e0b586d-010c-4f46-ba34-26a139bf9937','d58ce31f-4b72-44ad-b0e0-3d5d7d789322','2022-01-19 11:06:18','OCCLUSION_RESULT'),(1001,'502162a6-a0d3-4c4e-9cf3-8d014a530435','b903dd27-411a-4a7c-b357-1cc9a414dbdd','2022-02-12 16:53:18','OCCLUSION_RESULT'),(1001,'51a9191a-3d52-4dbe-a549-0616a8adb43b','e9a397c8-e329-4471-985b-0eb40ed458b0','2022-02-04 13:50:30','OCCLUSION_RESULT'),(1001,'53730f49-b109-4397-a05a-fa05be3beb52','c7bccd1e-370e-4347-8296-1bcd4c30b631','2022-09-10 09:45:43','OCCLUSION_RESULT'),(1001,'55725ce5-4c86-45bc-a52a-0f716dd5a486','7d8decb1-23db-4824-940f-8d8822d88813','2022-02-07 17:48:45','OCCLUSION_RESULT'),(1001,'55f52934-bbd7-4e86-bd7e-fc42a74d3419','9c318e86-fa90-4cd9-8319-2503cde2b455','2022-06-14 13:29:56','OCCLUSION_RESULT'),(1001,'565d69de-f728-4686-a5e9-490a8f086cd5','cf412dab-1d83-4db0-ae1b-d2724d5be97d','2022-07-12 11:04:14','OCCLUSION_RESULT'),(1001,'573423ef-791f-4a2f-aa1f-bb3662f66baa','e9bfc750-6943-42bf-8c0b-b7e1dc1803c5','2022-01-19 11:12:14','OCCLUSION_RESULT'),(1001,'57ada530-ed64-430e-a2d9-f1e6307bf947','4aa37ef9-cd2d-4cfa-9436-a62cc782a27a','2022-02-04 13:55:02','OCCLUSION_RESULT'),(1001,'5adfa2d7-f3c9-4609-9d90-3a85c0853b42','87edc123-163f-46ce-be5c-45f2ff80b857','2022-05-12 12:26:51','OCCLUSION_RESULT'),(1001,'5c552dd5-711b-49d9-8d67-2470cfd3aa77','764b8e22-8600-49e3-8d7c-d619725096ee','2022-02-04 18:19:48','OCCLUSION_RESULT'),(1001,'5e045628-a37a-469c-89a3-80d0555bc569','864c98a3-fcf7-466a-b999-13bd4dfb8c65','2022-05-25 10:45:09','OCCLUSION_RESULT'),(1001,'5e2227aa-c48a-4337-a9f3-899cdb079950','764b8e22-8600-49e3-8d7c-d619725096ee','2022-02-04 18:19:48','OCCLUSION_RESULT'),(1001,'6217fbe5-09ba-48c5-9c84-c981fea99cac','9c318e86-fa90-4cd9-8319-2503cde2b455','2022-06-14 13:29:56','OCCLUSION_RESULT'),(1001,'63e9f9a7-c8a4-4bf2-9e7c-c06c335ff76a','3a1fff1c-0427-409c-aa94-06326e554d82','2022-05-30 11:09:22','OCCLUSION_RESULT'),(1001,'642f1d21-72b4-419c-b005-26b9f2557b21','f9f6d9d2-cc34-43c3-9f5f-4b8e54b41bbb','2022-04-21 08:53:03','OCCLUSION_RESULT'),(1001,'643b4b45-c20a-4040-bf63-70edc63f19d1','7c70edbe-5cb4-4244-8baf-7caf2bd7d86b','2022-02-04 17:58:48','OCCLUSION_RESULT'),(1001,'64b1a7cd-06d4-469c-b06d-4c38cfd82051','778ed9fd-f658-471d-9dd0-a48417419cba','2022-05-12 12:31:43','OCCLUSION_RESULT'),(1001,'65248dcf-9c3a-47ce-a2c2-9d6f5de84040','2de3d2bb-d512-4514-8bed-a879b73a6028','2022-04-21 11:29:16','OCCLUSION_RESULT'),(1001,'65a1c33d-5a70-4155-ac8d-4be3028e8eca','426bd908-3163-4291-a697-20eacff771ab','2022-05-16 17:57:11','OCCLUSION_RESULT'),(1001,'65fd3ecb-affa-479b-8a28-d81f4574f5ef','b35629de-38d8-4cdd-bf2c-b61c461410cb','2022-02-07 18:05:55','OCCLUSION_RESULT'),(1001,'67a26d2a-1c67-4353-aac9-8b3183eb074d','7d8decb1-23db-4824-940f-8d8822d88813','2022-02-07 17:48:45','OCCLUSION_RESULT'),(1001,'682c54ab-42b2-46a2-a6af-320afbdfdf82','ff8547d7-27f8-4862-9b63-e713dd817f3f','2022-09-09 17:03:34','OCCLUSION_RESULT'),(1001,'6b4f02ea-c57e-40cc-a471-e0a4dd200fcd','35af1bf5-285a-4bb1-a6db-fe9897defe51','2022-05-13 12:11:07','OCCLUSION_RESULT'),(1001,'6b9eecc3-635f-4c15-8609-cf0c4f6d6dae','864c98a3-fcf7-466a-b999-13bd4dfb8c65','2022-05-13 11:30:43','OCCLUSION_RESULT'),(1001,'6bb63a3b-8000-4f0c-89f0-23596bbf5507','d8bec5dc-8405-473d-9ba5-ae6e461ed6fd','2022-02-04 18:13:44','OCCLUSION_RESULT'),(1001,'6c068fd4-9fc3-4964-b6e1-b872b9490c35','7a5acfd0-87ca-4009-aa4e-677a88ceffde','2022-05-31 10:53:55','OCCLUSION_RESULT'),(1001,'6c76bb80-76df-4010-a738-de9fd2f31989','03fe87bc-2a25-4d16-a476-2df62bb3cf76','2022-07-04 14:13:45','OCCLUSION_RESULT'),(1001,'6d53bd96-2c20-488f-b9c5-69c68f762598','a503ab26-f707-4923-86b6-049c17f73533','2022-05-17 16:40:25','OCCLUSION_RESULT'),(1001,'6e0bfe0c-593a-4a2e-8782-7f1e18f4d6bd','00405f86-eefa-41f9-8d98-1fa9cbeef855','2022-05-25 09:02:54','OCCLUSION_RESULT'),(1001,'6e9fc174-28d5-42d8-bbc0-dd92bf08bde1','f9f6d9d2-cc34-43c3-9f5f-4b8e54b41bbb','2022-04-21 08:53:03','OCCLUSION_RESULT'),(1001,'6f6a9b2c-99a5-4c89-9435-60646732a096','727485e0-8637-4024-83d8-95544991f73f','2022-06-03 14:07:00','OCCLUSION_RESULT'),(1001,'7210d8cd-3a05-4560-b55f-80951c90c08c','d5bff097-1085-4c55-afe3-1ce57126d88f','2022-03-08 11:15:58','OCCLUSION_RESULT'),(1001,'7261116b-75a2-4416-a745-d880100deb03','4aa37ef9-cd2d-4cfa-9436-a62cc782a27a','2022-02-04 13:55:02','OCCLUSION_RESULT'),(1001,'749660e2-55a3-4b7b-8618-0ecb7ace7e8b','35af1bf5-285a-4bb1-a6db-fe9897defe51','2022-05-25 10:46:42','OCCLUSION_RESULT'),(1001,'74e3f855-5feb-462a-80ec-2a3e46acc509','65f9077d-c859-4b2c-9d4d-692d723315a5','2022-05-13 12:07:00','OCCLUSION_RESULT'),(1001,'75bc0b22-b15a-42fa-8cf2-3584942783f6','a15a6719-2996-4256-93d7-515e4d4f5bef','2022-01-19 14:46:49','OCCLUSION_RESULT'),(1001,'75ecadc3-8c76-453d-8277-1a2ae4e32db1','4aa37ef9-cd2d-4cfa-9436-a62cc782a27a','2022-02-04 13:55:02','OCCLUSION_RESULT'),(1001,'76d25260-1e03-445e-97e6-40a0f4ade327','e2722784-a66c-4ece-91c0-2add756415ea','2022-05-13 16:31:42','OCCLUSION_RESULT'),(1001,'7757fade-a1c3-4f58-b5f4-6a8c840a1026','389a085b-21e0-4004-9d53-dfcb5c4bd2f1','2022-06-03 09:04:23','OCCLUSION_RESULT'),(1001,'77a65753-09fd-45ea-8312-8effe35d66c0','5775815f-f076-48af-be27-50e4dbfd3622','2022-06-28 10:55:54','OCCLUSION_RESULT'),(1001,'78950e09-dd44-4ad7-8aa0-6799130478b6','d7643aed-d242-47f6-8e1a-703d4672f109','2022-03-07 14:44:20','OCCLUSION_RESULT'),(1001,'797ff92c-f041-4f92-b744-b31285c7e136','b903dd27-411a-4a7c-b357-1cc9a414dbdd','2022-02-12 16:53:18','OCCLUSION_RESULT'),(1001,'79944cf3-b4e5-436e-ac4e-af7ee9d2f8d1','e2722784-a66c-4ece-91c0-2add756415ea','2022-05-13 16:31:42','OCCLUSION_RESULT'),(1001,'7a1bc3ae-2bd2-4767-abb5-fe9c2bd23091','77753fb3-75a1-45c2-9191-7a5d98206df2','2022-06-14 12:06:33','OCCLUSION_RESULT'),(1001,'7a7c6ba9-78fb-4f22-8f83-8466156a75ac','426bd908-3163-4291-a697-20eacff771ab','2022-05-16 17:57:11','OCCLUSION_RESULT'),(1001,'7aa382e0-3722-4b51-b555-ca86b2fdea0f','84d73896-4c7a-4dc0-994a-b2a70e3d1cf2','2022-06-28 09:07:03','OCCLUSION_RESULT'),(1001,'7acff767-8dc0-4bd7-9333-8187e6479927','cb4cdc08-5d89-48dc-80a3-2e659c55f971','2022-02-07 17:52:17','OCCLUSION_RESULT'),(1001,'7ad19c15-8266-4c29-bd63-8c53155064ad','aa16f8ea-198d-4240-ab78-5a1f54823f0c','2022-05-16 17:47:59','OCCLUSION_RESULT'),(1001,'7b2c0599-a564-406a-a92c-1e8ebb63ae32','0bc29ff9-efea-448d-b521-2c39fd4faa78','2022-03-08 11:17:37','OCCLUSION_RESULT'),(1001,'7b448472-93a0-4faf-a51d-7e632836d89d','e23c031c-2c78-414b-840d-85b58e959fbe','2022-01-19 15:26:52','OCCLUSION_RESULT'),(1001,'7ca6f680-78d4-4290-b246-10418b29f7f5','e9bfc750-6943-42bf-8c0b-b7e1dc1803c5','2022-01-19 11:12:14','OCCLUSION_RESULT'),(1001,'7cec7e1d-dea8-4323-9a35-77e7166c42eb','7c70edbe-5cb4-4244-8baf-7caf2bd7d86b','2022-02-04 17:58:48','OCCLUSION_RESULT'),(1001,'7ec34b4e-bd8b-4125-bc39-a94b91122070','42098ceb-3335-4f13-8aed-b29c37a5f57f','2022-04-21 11:28:43','OCCLUSION_RESULT'),(1001,'7f150a86-6fec-4718-a058-cd12d7a38305','d7643aed-d242-47f6-8e1a-703d4672f109','2022-03-07 14:44:20','OCCLUSION_RESULT'),(1001,'7f170f84-f1e1-4d43-8fcb-0fe153f8a949','0d180e89-cc7f-4718-abf6-79b3ada7fd3c','2022-02-15 12:49:40','OCCLUSION_RESULT'),(1001,'7f961e41-617e-4e30-84ef-a53f823e5acf','2de3d2bb-d512-4514-8bed-a879b73a6028','2022-04-21 11:29:16','OCCLUSION_RESULT'),(1001,'7fddb7f4-ade9-4efb-85ae-77539683dea6','c7bccd1e-370e-4347-8296-1bcd4c30b631','2022-09-10 09:45:43','OCCLUSION_RESULT'),(1001,'800a13fa-89b5-4193-bf7b-bf2a1c5ec28f','864c98a3-fcf7-466a-b999-13bd4dfb8c65','2022-05-25 10:45:09','OCCLUSION_RESULT'),(1001,'803a5a7f-c846-41ee-9190-6d020a343c0b','9440baee-a8bf-406c-bc0a-f5e9596f197b','2022-05-13 16:13:11','OCCLUSION_RESULT'),(1001,'80740dcf-ef50-473b-bf6b-dbd21bab0839','7a5acfd0-87ca-4009-aa4e-677a88ceffde','2022-05-31 10:53:55','OCCLUSION_RESULT'),(1001,'80fac73f-4e14-44dd-b7e3-5b5fd926bcb2','4e1258a6-b789-451f-bfe8-8b395e1129d8','2022-01-19 15:24:43','OCCLUSION_RESULT'),(1001,'815860cb-19c9-4171-93d6-ec345254eb3e','cf412dab-1d83-4db0-ae1b-d2724d5be97d','2022-07-12 11:04:14','OCCLUSION_RESULT'),(1001,'81ab663b-3f7f-440e-bc5e-0b3f41373259','6960b50e-6f78-4f83-9303-8c985410457c','2022-05-31 14:55:44','OCCLUSION_RESULT'),(1001,'81ec8405-393a-486b-974a-31e4794db9ba','a525c976-46dd-42bc-abc1-c7cf71f9a1f1','2022-02-04 13:58:28','OCCLUSION_RESULT'),(1001,'829ffd44-c4bc-4933-8b47-bd648efb8221','a525c976-46dd-42bc-abc1-c7cf71f9a1f1','2022-02-04 13:58:28','OCCLUSION_RESULT'),(1001,'831e4532-3962-4547-af55-74e75647063d','5775815f-f076-48af-be27-50e4dbfd3622','2022-06-28 10:55:54','OCCLUSION_RESULT'),(1001,'84740299-1f4d-41e0-ac34-8854d80684e2','4aa37ef9-cd2d-4cfa-9436-a62cc782a27a','2022-02-04 13:55:02','OCCLUSION_RESULT'),(1001,'848ef817-dbc7-482b-a5da-58b2b9fffcd1','94a0167c-6798-4c78-a76c-cb9fc91ccdda','2022-06-28 15:03:25','OCCLUSION_RESULT'),(1001,'84e32701-3099-4943-babb-39906f06e7db','3a1fff1c-0427-409c-aa94-06326e554d82','2022-05-30 11:09:22','OCCLUSION_RESULT'),(1001,'853e2356-bdec-4762-8140-becfdb0d014d','704a0750-2a24-448f-8f30-928139977895','2022-03-08 11:49:34','OCCLUSION_RESULT'),(1001,'855f70ca-d5a8-443f-a159-e143b241ef33','e9a397c8-e329-4471-985b-0eb40ed458b0','2022-02-04 13:50:30','OCCLUSION_RESULT'),(1001,'86411b04-6731-49a3-b09f-936337ac02f5','764b8e22-8600-49e3-8d7c-d619725096ee','2022-02-04 18:19:48','OCCLUSION_RESULT'),(1001,'86743da6-1ee0-44f8-a265-3c6de7c6342a','a503ab26-f707-4923-86b6-049c17f73533','2022-05-17 16:40:25','OCCLUSION_RESULT'),(1001,'8807cbe4-80d2-4af2-9e28-4ad511514e42','d5bff097-1085-4c55-afe3-1ce57126d88f','2022-03-08 11:15:58','OCCLUSION_RESULT'),(1001,'881fa71e-8ff2-48d9-90d7-929e8ee439ed','f9f6d9d2-cc34-43c3-9f5f-4b8e54b41bbb','2022-04-21 08:53:03','OCCLUSION_RESULT'),(1001,'8a4ad7fe-8660-4de4-87fc-e34225ca52a0','778ed9fd-f658-471d-9dd0-a48417419cba','2022-05-12 12:31:43','OCCLUSION_RESULT'),(1001,'8a72c490-d57c-49ed-a392-7053d70d734d','a15a6719-2996-4256-93d7-515e4d4f5bef','2022-01-19 14:46:49','OCCLUSION_RESULT'),(1001,'8b0696ff-a902-4672-a040-5a87cb3b99b4','9c318e86-fa90-4cd9-8319-2503cde2b455','2022-06-14 13:29:56','OCCLUSION_RESULT'),(1001,'8b48514f-d8d7-4e30-a7b7-9ff34435a5d8','35af1bf5-285a-4bb1-a6db-fe9897defe51','2022-05-13 12:11:07','OCCLUSION_RESULT'),(1001,'8b995262-9a19-4f27-a906-f0a97ad14a3e','84d73896-4c7a-4dc0-994a-b2a70e3d1cf2','2022-06-28 09:07:03','OCCLUSION_RESULT'),(1001,'8c0459bd-0102-41f8-9d98-758b74f6b263','70f4220e-2a6b-4575-bd0e-09c14a13d758','2022-06-16 11:03:55','OCCLUSION_RESULT'),(1001,'8c489273-df3d-4efa-9d94-8ed6e0acc9ad','8b14563e-0862-4cac-8045-e8aed2be886d','2022-07-19 12:28:51','OCCLUSION_RESULT'),(1001,'8d091250-13fa-4e1e-89d6-2dae08a91119','704a0750-2a24-448f-8f30-928139977895','2022-03-08 11:49:34','OCCLUSION_RESULT'),(1001,'8d2fe9bc-4164-43b6-bdca-e21ff9b44241','cb4cdc08-5d89-48dc-80a3-2e659c55f971','2022-02-07 17:52:17','OCCLUSION_RESULT'),(1001,'8d4aee7a-6819-4016-b51b-71ba7ffaadea','7a5acfd0-87ca-4009-aa4e-677a88ceffde','2022-05-31 10:53:55','OCCLUSION_RESULT'),(1001,'8f69f135-daef-4f4b-a1a0-3aa76fb92de1','5775815f-f076-48af-be27-50e4dbfd3622','2022-06-28 10:55:54','OCCLUSION_RESULT'),(1001,'8fb05be8-f57e-46ea-9abd-c2f8b7e453bc','65f9077d-c859-4b2c-9d4d-692d723315a5','2022-05-13 12:07:00','OCCLUSION_RESULT'),(1001,'9026aa67-b409-4693-81c4-92607b3386a1','0bc29ff9-efea-448d-b521-2c39fd4faa78','2022-03-08 11:17:37','OCCLUSION_RESULT'),(1001,'911094e4-fe1d-4725-b083-95706a95ce27','426bd908-3163-4291-a697-20eacff771ab','2022-05-16 17:57:11','OCCLUSION_RESULT'),(1001,'92bf4f89-6d0d-4ee8-bd82-d36a90b3cacb','87edc123-163f-46ce-be5c-45f2ff80b857','2022-05-12 12:26:51','OCCLUSION_RESULT'),(1001,'93e015c7-46c1-406e-be60-bf0c78428875','a503ab26-f707-4923-86b6-049c17f73533','2022-05-17 16:40:25','OCCLUSION_RESULT'),(1001,'976c8ff2-0cca-43fe-8b36-f902660807ef','84d73896-4c7a-4dc0-994a-b2a70e3d1cf2','2022-