-- MySQL dump 10.13  Distrib 8.0.30, for Linux (x86_64)
--
-- Host: localhost    Database: condor
-- ------------------------------------------------------
-- Server version	8.0.30-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `Act`
--

DROP TABLE IF EXISTS `Act`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Act` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `title` varchar(64) DEFAULT NULL,
  `dateCreated` datetime DEFAULT NULL,
  `comments` mediumtext,
  `globalDisplayID` mediumint unsigned DEFAULT NULL,
  `displayID` mediumint unsigned DEFAULT NULL,
  `patientID` char(36) NOT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastAccessed` datetime NOT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Work_Patient` (`patientID`,`ownerID`),
  CONSTRAINT `fk_Act_Patient` FOREIGN KEY (`patientID`) REFERENCES `condor_patient_local`.`Patient` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Act`
--

LOCK TABLES `Act` WRITE;
/*!40000 ALTER TABLE `Act` DISABLE KEYS */;
INSERT INTO `Act` VALUES (1001,'00022a66-7220-4aec-bb84-ddea7664d49d','','2022-01-19 20:15:57','',1,1,'4000373f-1dfa-42e5-ad0d-797ed98bbf1a','','','2022-01-19 20:16:08','2022-01-19 20:15:57','2022-01-19 20:16:08','2022-01-19 19:16:08','2022-01-19 20:15:57'),(1001,'01b85cc7-ad9c-44db-a6c5-3f8d1493bb30','empreinte initiale 0056','2022-01-27 12:40:11','',1,1,'021a268a-4571-414a-bbef-2ea30a0a7fed','','',NULL,'2022-10-06 17:54:41','2022-10-06 17:54:43','2022-10-06 15:54:43','2022-03-08 11:18:09'),(1001,'01bd0635-6ec6-42cb-8561-8638bded352c','Vincent 1707: 27 CCC','2022-06-03 14:36:49','',1,1,'1c189ddc-0ee7-45e7-9d80-585dac08374a','','',NULL,'2022-06-07 13:43:29','2022-06-07 13:43:32','2022-06-07 11:43:32','2022-06-03 19:00:56'),(1001,'049862c5-29b2-4fcd-a5b1-4c8f1f6cf480','SEB01','2022-01-19 15:51:34','',1,1,'593972a6-d7d6-4802-b87d-38aab371f71e','','',NULL,'2022-06-28 19:39:53','2022-06-28 19:39:56','2022-06-28 17:39:56','2022-01-19 16:27:34'),(1001,'07012a03-2a1e-44e4-9bc9-17e726862bc2','EMPREINTE \"-','2022-11-29 11:23:47','',1,1,'a9e7a1ae-2d71-448f-80f6-19d916912a3c','','',NULL,'2022-12-14 16:00:45','2022-12-14 16:06:53','2022-12-14 15:06:53','2022-12-14 16:06:53'),(1001,'09e7d062-6ceb-4577-a66e-100bb8dad6d4','EMPREINTE CHASSIS MAND','2022-10-13 15:32:05','',1,1,'ccc47f1d-1705-4945-aa08-da5aa64d251f','','',NULL,'2022-10-18 19:03:51','2022-10-18 19:04:28','2022-10-18 17:04:28','2022-10-18 19:04:28'),(1001,'0aac522d-3c38-465a-a1e0-014166c140ac','0171','2022-01-21 12:24:08','',1,1,'a0c21836-ba79-4f15-9e35-02ef8211a9e5','','',NULL,'2022-07-12 19:48:58','2022-07-12 19:48:59','2022-07-12 17:48:59','2022-02-02 11:14:39'),(1001,'11fb4259-c305-4a08-b750-536f769f44b0','COURONNE fULLz 27','2022-10-21 18:02:11','',1,1,'1a8329eb-7dbc-4bfd-b669-6d92e13fec0c','','',NULL,'2022-10-21 19:24:18','2022-10-21 19:28:23','2022-10-21 17:28:23','2022-10-21 19:28:21'),(1001,'146b346d-b9f6-44b4-a722-edc0a0f231ed','CCC 47','2022-04-21 12:39:12','',1,1,'87f00f75-c29c-430a-a553-82cbedff21d9','','',NULL,'2022-04-21 19:37:08','2022-04-21 19:47:18','2022-04-21 17:47:18','2022-04-21 19:47:18'),(1001,'1f3e06be-a2ec-4423-831c-7b01979d5187','PIERRE 13 EMPREINTE','2022-07-12 12:38:36','',1,1,'55f86771-cc61-43c6-a8d5-5e4006a24fc9','','',NULL,'2022-07-19 15:44:40','2022-07-19 15:56:03','2022-07-19 13:56:03','2022-07-19 15:56:02'),(1001,'1f6a1e17-7d25-4906-b07f-ef2a5b507d38','EMP 13','2022-06-28 15:33:48','',1,3,'95cf30e7-fd74-43ff-9655-43abf2f63669','','',NULL,'2022-10-13 19:36:05','2022-10-13 19:36:10','2022-10-13 17:36:10','2022-10-06 15:17:41'),(1001,'21fafc95-3946-40ef-be71-2a5fab6db45c','LYDIE EMPREINTES ETUDE','2022-12-13 10:04:58','',1,1,'0c130e3d-4f69-4332-a7f5-f3765413e61c','','',NULL,'2023-03-15 11:57:50','2023-03-15 11:57:51','2023-03-15 10:57:51','2023-03-15 11:52:42'),(1001,'223a16b9-c15c-4bcc-9b2f-7373785fcc51','mai','2022-01-19 10:16:29','',1,1,'2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d','','',NULL,'2022-01-19 14:47:55','2022-01-19 14:51:12','2022-01-19 13:51:12','2022-01-19 14:51:11'),(1001,'243f3e73-b114-4c67-b8ef-627dec050f1b','','2022-11-10 11:22:17','',1,1,'51cb45a3-3668-47c1-80a8-c7de17b606a5','','','2022-11-10 11:22:23','2022-11-10 11:22:18',NULL,'2022-11-10 10:22:23','2022-11-10 11:22:23'),(1001,'24d0aeb5-3058-4070-aeea-97c289e41e3c','7502','2022-01-19 14:53:21','',1,1,'de078619-3946-4adb-a799-1c260e16face','','',NULL,'2022-01-28 19:01:28','2022-01-28 19:35:12','2022-01-28 18:35:12','2022-01-19 15:46:50'),(1001,'267349dd-4d0c-4356-a35b-f7060d5b6403','0010 Philippe/','2022-06-17 17:31:03','',1,1,'95cf30e7-fd74-43ff-9655-43abf2f63669','','','2022-06-20 13:57:13','2022-06-20 13:57:02','2022-06-20 13:57:13','2022-06-20 11:57:13','2022-06-20 13:57:11'),(1001,'2c8b85b5-c805-4b08-85e7-3d02dab72e99','16','2022-02-01 15:47:50','',1,1,'d100e894-0be9-4495-94e2-e469232f7817','','',NULL,'2022-12-02 14:36:19','2022-12-02 14:36:25','2022-12-02 13:36:25','2022-02-07 16:23:43'),(1001,'319a8f1d-33fc-4f87-a108-b3eabda0510f','EMP 23:pierre','2022-07-07 17:30:54','',1,1,'533d4409-e39d-4a27-a0af-b59e6cf76ce3','','',NULL,'2022-07-12 19:49:25','2022-07-12 19:49:26','2022-07-12 17:49:26','2022-07-07 18:14:07'),(1001,'33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416','INLAY35','2022-06-28 12:43:42','',1,1,'4a3954e0-1e2f-4721-9fdd-4180380dc19f','','',NULL,'2022-06-28 19:39:09','2022-06-28 19:39:09','2022-06-28 17:39:09','2022-06-28 19:31:31'),(1001,'3e95d626-668f-45f7-98ad-be2cf9d7b90b','Colette 3738/ 26 ','2022-05-24 10:54:46','',1,1,'452a5200-3e06-4b74-8949-6abc7f2dda8a','','',NULL,'2022-05-30 09:50:52','2022-05-30 09:50:53','2022-05-30 07:50:53','2022-05-25 13:20:15'),(1001,'4075a8d6-094f-4202-abe0-4c02b7a5a8e6','7267','2022-01-20 09:51:18','',1,1,'32939ecf-ba11-4fff-a074-5e86a9f7f313','','',NULL,'2022-02-08 10:11:23','2022-02-08 10:11:55','2022-02-08 09:11:55','2022-01-20 20:45:47'),(1001,'40a1b174-1058-4d27-b63a-4e8f565fb520','BENJAMIN m 45','2022-11-10 11:22:55','',1,1,'8b4b6de2-edd8-44e6-88c6-8a151914aca6','','',NULL,'2022-11-10 19:07:35','2022-11-10 19:10:27','2022-11-10 18:10:27','2022-11-10 19:10:26'),(2,'440a8315-0df8-4219-8d74-9470bfeeacbf','','2022-07-28 14:29:39','',371,1,'1095dc95-d70a-4936-8b50-ae8aa7963fc9','','','2022-08-30 10:32:23','2022-07-28 14:29:39',NULL,'2022-08-30 08:32:23','2022-08-30 10:32:23'),(1001,'498ae60a-23f0-44fc-9730-be499bfc4b46','EMPREINTE 38','2022-06-14 15:07:45','',1,1,'f4fc00ec-4af8-4a15-b427-f1c5aabf6260','','',NULL,'2022-06-17 08:43:02','2022-06-17 08:43:05','2022-06-17 06:43:05','2022-06-14 19:10:41'),(1001,'4bed076c-8541-4a2f-800a-5aeb4cb49de5','ONLAY 37','2022-06-28 16:52:59','',1,1,'fa7fa96b-f393-4b9a-8198-144702462cfa','','',NULL,'2022-06-28 19:40:34','2022-06-28 19:40:35','2022-06-28 17:40:35','2022-06-28 19:28:44'),(1001,'4df1e430-5cbb-4a6c-8292-747e35e6f1e8','EMPREINTES ETUDES','2023-04-13 11:33:41','',1,1,'98aa55d8-3848-48e0-9684-5597786b85c7','','',NULL,'2023-04-13 12:25:39',NULL,'2023-04-13 10:25:39','2023-04-13 12:25:34'),(1001,'4f4c72c4-9f78-40d6-9576-4281f6d06aa3','0010/Philippe 44/45/46/47','2022-06-17 17:31:56','',1,2,'95cf30e7-fd74-43ff-9655-43abf2f63669','','','2022-06-20 13:56:57','2022-06-20 13:56:44','2022-06-20 13:56:57','2022-06-20 11:56:57','2022-06-20 13:56:57'),(1001,'4f62e395-5623-4d5b-869c-1b2fc4d22b00','AMELIE 0355','2022-06-16 12:46:06','',1,1,'57c4096f-98dd-49c8-bea5-a5b109ad3fd0','','',NULL,'2022-06-18 10:23:25','2022-06-18 10:23:28','2022-06-18 08:23:28','2022-06-16 18:10:14'),(1001,'4fbadc34-458e-4383-9cea-ff5422d69287','EMP ETUDE','2022-10-28 11:51:23','',1,1,'a20364ca-68f6-43af-9d85-5203eb8e7fd3','','',NULL,'2022-10-28 11:51:23','2022-10-28 12:19:10','2022-10-28 10:19:10','2022-10-28 12:19:09'),(1001,'4ff9c682-c09d-42ff-8c29-aeb13e066ed2','0045','2022-01-24 18:24:06','',1,1,'45ff7437-0691-4427-a7da-8250862e4b96','','',NULL,'2022-10-13 19:36:21','2022-10-13 19:36:23','2022-10-13 17:36:23','2022-01-24 20:57:08'),(1001,'5368829e-7dec-4775-a487-a1019f9604f4','25 26','2022-02-01 11:32:26','',1,1,'8fc74d9e-a5a0-46bf-be3f-500548a130ad','','',NULL,'2022-03-19 11:42:26','2022-03-19 11:42:27','2022-03-19 10:42:27','2022-02-02 11:00:42'),(1001,'55831d43-1906-4a22-9b7a-ed4b2820c8b2','Genevieve 0125 / dent 11','2022-06-16 15:11:10','',1,2,'458c92d8-9da1-4df9-967f-d14fc7e6303d','','',NULL,'2022-06-16 18:06:44','2022-06-16 18:06:46','2022-06-16 16:06:46','2022-06-16 15:34:57'),(1001,'595a54fa-ae7d-4880-86a1-168b20242ecf','Empreinte d\'étude','2022-12-02 14:38:18','',1,1,'9efbbbe9-fd0a-44b1-988c-23571aad69fa','','',NULL,'2022-12-14 15:54:11','2022-12-14 15:58:20','2022-12-14 14:58:20','2022-12-14 15:58:19'),(1001,'5dd64d24-8e33-45bd-a282-c148c185c338','Anne  RP','2023-02-17 11:31:56','',1,1,'372000f2-2471-4a57-9b18-224d0788041f','','',NULL,'2023-02-17 18:54:11','2023-02-17 18:54:12','2023-02-17 17:54:12','2023-02-17 18:52:37'),(1001,'5f9199b0-eb37-4ed3-8d1a-6c38505d4913','Empreinte étude','2022-09-09 17:53:33','',1,1,'69640c87-271c-4a44-a6fa-67b01654cc27','','',NULL,'2022-09-10 10:16:36','2022-09-10 11:45:53','2022-09-10 09:45:53','2022-09-10 11:45:51'),(2,'6206892a-2e7e-4765-ac90-b49bfb465997','bouche','2022-08-30 10:32:28','',371,1,'6a4b302c-278d-4e12-ace5-f095ba0bf856','','',NULL,'2022-08-30 14:06:13','2022-09-06 11:17:33','2022-09-06 09:17:33','2022-08-30 14:34:16'),(1001,'62105a91-1675-4d36-88bd-34aa8fe2ce3c','Olivier empreinte 15','2023-02-17 10:23:32','',1,1,'490e4b04-6edd-4f47-a2ed-232689892eca','','',NULL,'2023-02-17 18:54:17','2023-02-17 18:54:21','2023-02-17 17:54:21','2023-02-17 17:21:27'),(1001,'64c1427a-b91d-4675-94df-f36bd40e9b0f','Inlay14','2022-06-28 09:56:17','',1,2,'32710234-804f-46f5-899d-eed636f8a906','','',NULL,'2022-07-21 17:33:38','2022-07-21 17:33:47','2022-07-21 15:33:47','2022-06-28 19:34:50'),(1001,'6aedf6fd-46d7-4259-88ba-5cf074ad5913','CATHERINE ONLAY 24','2023-03-07 18:54:59','',1,1,'4fa1a134-d246-43d7-aa8c-b42e24b62b49','','',NULL,'2023-03-15 10:29:01','2023-03-15 10:29:04','2023-03-15 09:29:04','2023-03-07 19:17:51'),(1001,'6b1bf3f0-e6ca-4308-90a1-40913836e82b','22 23 24 25','2023-03-31 16:51:22','',1,1,'7e3c8022-95d1-493b-ae19-1ef6f0fb92b7','','',NULL,'2023-03-31 16:51:22','2023-03-31 16:54:43','2023-03-31 14:54:43','2023-03-31 16:54:42'),(1001,'6cd9ac89-d152-4881-ae60-0aa4d933a545','EMP ETUDE','2022-03-07 14:53:56','',1,1,'7eca2942-3d65-4279-8dae-998594082bb0','','',NULL,'2022-05-12 14:23:16','2022-05-12 14:33:47','2022-05-12 12:33:47','2022-05-12 14:33:46'),(1001,'7873a396-419c-4215-83c7-fec9f2742ccf','EMP 46','2022-02-03 11:00:24','',1,1,'7f47fd88-9ea0-4c08-9193-a54d4f158c7c','','',NULL,'2022-06-17 08:40:38','2022-06-17 08:40:40','2022-06-17 06:40:40','2022-06-16 17:39:33'),(1001,'796aca94-b14e-4e17-bfc0-9f3f45ade8f3','0062 23 27','2022-05-13 15:50:48','',1,1,'f3295a8a-61a2-46d8-af67-c1d1e5901069','','',NULL,'2023-02-07 19:51:32','2023-02-07 19:51:36','2023-02-07 18:51:36','2022-06-14 14:09:40'),(1001,'7d5777ce-32ef-4f6a-85c5-0ac67029d64b','','2022-10-07 09:21:47','',1,1,'fad4ff40-5c01-4280-88a4-568c5b75c8dd','','','2022-10-07 09:22:49','2022-10-07 09:21:47',NULL,'2022-10-07 07:22:49','2022-10-07 09:22:49'),(1001,'7fe13e47-f2c8-4c59-ad95-d384d4cbaa35','7338/ Claire/ 16','2022-05-30 12:47:54','',1,1,'207d6dbc-c19b-4726-a9b3-16235ae554cc','','',NULL,'2022-06-15 11:06:33','2022-06-15 11:06:37','2022-06-15 09:06:37','2022-05-30 20:29:45'),(2,'81cd9cb1-6b36-47c0-8149-074211a960fe','','2021-12-24 13:42:51','',371,1,'c7f5dffb-2c97-44f8-926b-68aff9d64c15','','',NULL,'2021-12-24 13:42:51','2022-07-28 14:06:48','2022-07-28 12:06:48','2021-12-24 13:42:51'),(1001,'88257045-93fb-43fb-8b0a-f39fbf5f8e9d','EMPREINTE COMPLETE MAXILLAIRE','2022-10-18 14:29:32','',1,1,'204921b5-c765-4248-8e87-e3b0f7a46bff','','',NULL,'2022-10-19 15:42:30','2022-10-19 15:54:26','2022-10-19 13:54:26','2022-10-19 15:54:26'),(1001,'8b338ee6-5540-44a5-a587-286a7bfcbe14','EMP ETUDE','2022-10-07 12:24:17','',1,1,'76279ff4-e4a6-4996-8d4e-c948146544b1','','',NULL,'2022-10-07 19:40:57','2022-10-07 19:41:07','2022-10-07 17:41:07','2022-10-07 12:43:29'),(1001,'9869e99c-7b47-4662-9766-0388d668fbf3','EMP \'marienoelle 45','2023-03-10 18:13:32','',1,1,'39062d60-7a18-417a-9004-c58e9ce7d62a','','',NULL,'2023-03-20 10:04:24','2023-03-20 10:04:36','2023-03-20 09:04:36','2023-03-11 16:31:21'),(1001,'9b1d2a8e-c6de-4f5c-92c5-88005869d8e9','7304','2022-03-08 11:11:04','',1,1,'f6f52932-463d-4797-9974-ed4b8eb30a12','','',NULL,'2022-04-21 19:48:08','2022-04-21 19:48:10','2022-04-21 17:48:10','2022-04-15 16:06:50'),(1001,'9bf7b056-ca4f-4dab-937b-619d0eb20528','Valérie empreinte implant 37','2022-12-22 09:54:41','',1,1,'75ce481f-6c44-4d16-a477-ea40c4fa6022','','',NULL,'2022-12-22 10:10:19','2022-12-22 11:36:49','2022-12-22 10:36:49','2022-12-22 11:36:48'),(1001,'a2369349-1629-40ad-8784-d271bc3fbade','Bridge prov','2022-04-21 10:29:51','',1,1,'e922efb9-8c03-445b-8a0f-449e3c43bdca','','',NULL,'2022-04-21 14:12:25','2022-04-21 15:43:41','2022-04-21 13:43:41','2022-04-21 15:43:41'),(1001,'a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5','EMPREINTE 2526','2022-02-07 12:17:00','',1,1,'513ccf80-8cc1-47fa-b351-4e0414a0fda5','','',NULL,'2022-03-19 11:38:33','2022-03-19 11:38:35','2022-03-19 10:38:35','2022-02-12 17:57:58'),(1001,'a7bcb190-dd19-4f3b-8aab-266030bf4064','EMPREINTE CC zircone 35','2022-07-04 15:25:11','',1,1,'f9d03016-567a-4bd4-9cc5-dafeea34e365','','',NULL,'2022-09-08 10:24:15','2022-09-08 10:24:28','2022-09-08 08:24:28','2022-07-19 16:05:53'),(1001,'b1cf14ce-00a9-48b6-8654-dadde26073f1','empreintes etude 20/22','2022-10-20 12:35:56','',1,1,'9e399d73-4d2e-4bb8-af48-a4e597811faa','','',NULL,'2023-01-26 13:57:12','2023-01-26 14:02:18','2023-01-26 13:02:18','2023-01-26 14:02:18'),(1001,'b6039092-51ba-40dc-86e3-23be741dbb99','7280','2022-01-24 15:25:41','',1,1,'fa942554-dda6-4d2d-b578-ae9be6b3904d','','',NULL,'2022-01-28 19:12:39','2022-01-28 19:35:13','2022-01-28 18:35:13','2022-01-24 15:31:00'),(1001,'bc96e41e-0457-4067-9d27-c4eaa1a505b3','7050','2022-01-19 19:55:07','',1,1,'5c3e71a4-b9b8-4f4d-b447-42654db92f32','','',NULL,'2022-06-01 12:05:28','2022-06-01 12:05:40','2022-06-01 10:05:40','2022-05-31 16:58:18'),(1001,'c0df7d9c-0cc6-48c6-8595-92335a500fe2','Mara 7270/ 3637','2022-05-17 18:05:02','',1,1,'22c79f73-5e2c-4406-9e49-1a07f8ab0bc4','','',NULL,'2022-09-10 13:02:24','2022-09-10 13:02:27','2022-09-10 11:02:27','2022-06-09 13:25:00'),(1001,'c57164ce-3f15-42b7-a8dc-96ab6a136184','EMPREINTE ETUDE','2023-03-13 10:25:38','',1,1,'3a170256-4132-4b56-ad27-b2cc7790bbf8','','',NULL,'2023-03-15 11:49:45','2023-03-15 11:50:30','2023-03-15 10:50:30','2023-03-15 11:50:29'),(1001,'c81670ed-4144-4347-b19e-8057d11b5f7c','0677/ 14 15 16 17/ ONLAY','2022-05-31 12:21:05','',1,1,'986374de-c4d7-4d6f-bf0c-2dc7e3b859a9','','',NULL,'2022-06-15 11:06:07','2022-06-15 11:06:12','2022-06-15 09:06:12','2022-06-07 13:41:28'),(1001,'c9079d19-8ffb-46f7-a51e-3a7a90ccae59','0125','2022-01-25 12:49:06','',1,1,'458c92d8-9da1-4df9-967f-d14fc7e6303d','','','2022-01-28 18:13:56','2022-01-28 18:13:08','2022-01-28 18:13:56','2022-01-28 17:13:56','2022-01-27 14:52:24'),(1001,'cb98e8a0-e16d-4640-919e-9b968e57d3db','François GM emp etude','2023-03-20 14:16:22','',1,1,'7c3827a5-fcb4-4892-bab3-8d6a4e6382f0','','',NULL,'2023-03-20 16:03:28','2023-03-20 16:03:49','2023-03-20 15:03:49','2023-03-20 15:48:02'),(1001,'cf74bd5d-1b3d-4cfd-be59-3ad404dd8525','Manuel emp 14 15','2023-03-30 13:32:31','',1,1,'09688939-f53f-4f00-8366-687b244de26d','','',NULL,'2023-03-30 19:56:59','2023-03-30 20:03:07','2023-03-30 18:03:07','2023-03-30 20:03:07'),(1001,'cfefc247-4a56-4d5a-8350-5ab72a8af67a','1114  CCC12','2022-05-13 11:40:59','',1,1,'7a831424-620b-4719-a82e-263d8602fd6e','','',NULL,'2022-06-02 19:24:09','2022-06-02 19:24:19','2022-06-02 17:24:19','2022-05-25 16:26:12'),(2,'d0298050-98d9-4076-b3bd-110404d60135','','2022-09-06 11:17:53','',371,1,'6a47006e-5c4a-4fab-835f-67e3301b2acf','','',NULL,'2022-09-06 11:17:53',NULL,'2022-09-06 09:20:25','2022-09-06 11:20:25'),(1001,'d67ff95f-e960-4948-8959-f79c151da5ce','===','2022-06-28 09:54:35','',1,1,'32710234-804f-46f5-899d-eed636f8a906','','','2022-06-28 09:55:55','2022-06-28 09:54:35','2022-06-28 09:55:55','2022-06-28 07:55:55','2022-06-28 09:55:55'),(1001,'d9740504-a9ca-472a-83f2-a309fa225a98','BRIGITTE ONLAY 26','2023-03-02 13:58:26','',1,1,'ca43bf7b-f931-42fc-bb75-05929e4b6578','','',NULL,'2023-03-15 10:29:36','2023-03-15 10:29:40','2023-03-15 09:29:40','2023-03-11 16:28:20'),(1001,'dcedf77c-c664-46b3-91b3-902529b54810','empreinte 6929','2022-01-27 17:27:02','',1,1,'3fe29844-5082-4e50-a510-61af15cb5cba','','',NULL,'2022-03-19 11:41:25','2022-03-19 11:41:27','2022-03-19 10:41:27','2022-02-11 14:22:16'),(1001,'e0a7776f-79fe-4c85-85ab-9ca244e7ff95','eMPREINTE ETUDE','2022-10-11 15:58:32','',1,1,'5a33a64b-822d-40bf-ba8c-e11c11a50f88','','',NULL,'2022-10-11 16:15:00','2022-10-11 16:26:44','2022-10-11 14:26:44','2022-10-11 16:26:43'),(1001,'ef4d16ee-fe39-4081-920a-e42ecf24a857','0000','2022-03-19 11:44:39','',1,1,'02df4b55-8d30-46ac-b34e-449ffbc4269e','','',NULL,'2022-04-15 13:41:16','2022-04-15 13:41:29','2022-04-15 11:41:29','2022-04-15 13:41:28'),(1001,'ef503949-33e8-4db6-bbfa-456bd8b70b73','EMPREINTES D\'ETUDE','2022-11-28 17:34:08','',1,1,'3cc1b522-8e7d-4196-87a1-a8c234f0a399','','',NULL,'2022-11-28 17:34:08','2022-11-28 18:08:28','2022-11-28 17:08:28','2022-11-28 18:08:28'),(1001,'fb42cec6-0bb6-41e9-912d-0517ff8e0942','ONLAY 47 37','2022-10-07 13:28:10','',1,1,'3ed7a8e0-5b4d-4ecf-b4ae-f855b16c0f93','','',NULL,'2022-10-10 13:23:01','2022-10-10 13:23:13','2022-10-10 11:23:13','2022-10-07 19:39:42'),(1001,'fcd6a92e-e91c-4367-9fc7-5919a6acfcb5','Bridge 15 17','2022-10-06 15:16:54','',1,2,'f3295a8a-61a2-46d8-af67-c1d1e5901069','','',NULL,'2022-10-13 19:38:03','2022-10-13 19:38:04','2022-10-13 17:38:04','2022-10-08 16:15:10'),(1001,'ff05cb1f-6c46-4287-9cdd-81bf817a9c78','7172','2022-01-25 16:27:03','',1,1,'c8418992-7324-4a11-9437-bf2bb0fa802f','','',NULL,'2022-01-26 14:47:46','2022-01-26 14:47:48','2022-01-26 13:47:48','2022-01-25 16:45:57');
/*!40000 ALTER TABLE `Act` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AddressInfo`
--

DROP TABLE IF EXISTS `AddressInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AddressInfo` (
  `id` char(36) NOT NULL COMMENT '(DC2Type:guid)',
  `line_0` varchar(255) DEFAULT NULL,
  `line_1` varchar(255) DEFAULT NULL,
  `line_2` varchar(255) DEFAULT NULL,
  `detail` varchar(255) DEFAULT NULL,
  `cityName` varchar(255) DEFAULT NULL,
  `cityState` varchar(255) DEFAULT NULL,
  `cityZip` varchar(25) DEFAULT NULL,
  `countryName` varchar(255) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AddressInfo`
--

LOCK TABLES `AddressInfo` WRITE;
/*!40000 ALTER TABLE `AddressInfo` DISABLE KEYS */;
INSERT INTO `AddressInfo` VALUES ('00000001-0000-0000-0000-000000000001','Labege','','',NULL,'Labege','','31670','France',NULL,NULL,'2022-03-31 17:40:19'),('00000002-0000-0000-0000-000000000001','137 rue garance','','',NULL,'LABEGE','','31670','France',NULL,NULL,'2022-03-31 17:40:19'),('00000003-0000-0000-0000-000000000001','137 rue Garance','','',NULL,'Labège','','31670','France',NULL,NULL,'2022-03-31 17:40:19'),('00000005-0000-0000-0000-000000000001','','','',NULL,'HOENHEIM','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000006-0000-0000-0000-000000000001','','','',NULL,'Marseille','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000007-0000-0000-0000-000000000001','','','',NULL,'MERIGNAC','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000008-0000-0000-0000-000000000001','','','',NULL,'MERIGNAC','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000009-0000-0000-0000-000000000001','','','',NULL,'Villiers Sur Marne','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000028-0000-0000-0000-000000000001','','','',NULL,'lyon','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000033-0000-0000-0000-000000000001','','','',NULL,'','','','',NULL,NULL,'2022-03-31 17:40:19'),('00000059-0000-0000-0000-000000000001','','','',NULL,'LE TEIL','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000071-0000-0000-0000-000000000001','','','',NULL,'Paris ','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000155-0000-0000-0000-000000000001','','','',NULL,'ECOUFLANT','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000172-0000-0000-0000-000000000001','4 Chemin Couralis','','',NULL,'LAROIN','','64110','France',NULL,NULL,'2022-03-31 17:40:19'),('00000177-0000-0000-0000-000000000001','AVDA. JUAN CARAMUEL,1','','',NULL,'LEGANES','','28916','España',NULL,NULL,'2022-03-31 17:40:19'),('00000193-0000-0000-0000-000000000001','','','',NULL,'VIRIAT ','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000224-0000-0000-0000-000000000001','','','',NULL,'CUGNAUX','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000317-0000-0000-0000-000000000001','','','',NULL,'LONGWY','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000339-0000-0000-0000-000000000001','','','',NULL,'Paris','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000355-0000-0000-0000-000000000001','','','',NULL,'Parma','','','Italia',NULL,NULL,'2022-03-31 17:40:19'),('00000375-0000-0000-0000-000000000001','95, Avenue de la Marne','','',NULL,'Epinay sur Seine','','93800','France',NULL,NULL,'2022-03-31 17:40:19'),('00000377-0000-0000-0000-000000000001','51 rue moncey','','',NULL,'LYON','','69003','France',NULL,NULL,'2022-03-31 17:40:19'),('00000421-0000-0000-0000-000000000001','','','',NULL,'PARIS 17','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000568-0000-0000-0000-000000000001','','','',NULL,'Tlse','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000652-0000-0000-0000-000000000001','','','',NULL,'','','','',NULL,NULL,'2022-03-31 17:40:19'),('00000681-0000-0000-0000-000000000001','','','',NULL,'Chamalières ','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000689-0000-0000-0000-000000000001','','','',NULL,'CHAMBERY','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000805-0000-0000-0000-000000000001','137 rue Garance','','',NULL,'Labege','','31670','France',NULL,NULL,'2022-03-31 17:40:19'),('00000838-0000-0000-0000-000000000001','','','',NULL,'','','','',NULL,NULL,'2022-03-31 17:40:19'),('00000840-0000-0000-0000-000000000001','','','',NULL,'','','','',NULL,NULL,'2022-03-31 17:40:19'),('00000850-0000-0000-0000-000000000001','52 RUE DU BOURNO','','',NULL,'BOEGE','','74420','France',NULL,NULL,'2022-03-31 17:40:19'),('00000899-0000-0000-0000-000000000001','VIA E.TAZZOLI','','',NULL,'CASERTA','','81100','Italia',NULL,NULL,'2022-03-31 17:40:19'),('00000916-0000-0000-0000-000000000001','','','',NULL,'','','','',NULL,NULL,'2022-04-14 13:25:32'),('00000917-0000-0000-0000-000000000001','','','',NULL,'','','','',NULL,NULL,'2022-03-31 17:40:19'),('00000918-0000-0000-0000-000000000001','','','',NULL,'Paris','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000941-0000-0000-0000-000000000001','','','',NULL,'','','','',NULL,NULL,'2022-03-31 17:40:19'),('00000979-0000-0000-0000-000000000001','','','',NULL,'La crau','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00001001-0000-0000-0000-000000000001','111 BD RICHARD LENOIR','','',NULL,'PARIS','','75011','France',NULL,NULL,'2022-03-31 17:40:19'),('00001002-0000-0000-0000-000000000001','','','',NULL,'ETAMPES','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00001003-0000-0000-0000-000000000001','','','',NULL,'Paris','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00001004-0000-0000-0000-000000000001','','','',NULL,'PARIS','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00001005-0000-0000-0000-000000000001','','','',NULL,'','','','',NULL,NULL,'2022-03-31 17:40:19'),('00001006-0000-0000-0000-000000000001','','','',NULL,'Paris','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00001007-0000-0000-0000-000000000001','','','',NULL,'','','','',NULL,NULL,'2022-03-31 17:40:19'),('090a7130-6429-400d-8dad-f1a80580d071','','','',NULL,'','','','',NULL,NULL,'2022-07-20 09:30:20'),('4f6c5ebf-2e87-4fdf-9fd4-2583db44d18a','PRACTICANTE ANTONIO ASTRAY 4 BAJO. ','','',NULL,'TAPIA','','33740','España',NULL,NULL,'2022-03-31 17:40:19'),('8607fa5e-3b45-49bc-b05b-bc5ac3b97ff0','','','',NULL,'TOULOUSE','','','',NULL,NULL,'2022-07-20 10:24:12'),('96f58522-1a05-40cf-8221-02becbf44486','801 Wayne Avenue, Suite G200','','',NULL,'Silver Spring','','20910','United States',NULL,NULL,'2022-03-31 17:40:19'),('9eb45cea-671c-4d46-a2d1-ab73e98cfe99','','','',NULL,'Labege','','','',NULL,NULL,'2022-06-17 15:22:57');
/*!40000 ALTER TABLE `AddressInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Assistant`
--

DROP TABLE IF EXISTS `Assistant`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Assistant` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `patientRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'READ_ONLY',
  `actRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'READ_ONLY',
  `discussionRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'READ_ONLY',
  `credentialsID` char(36) DEFAULT NULL,
  `personInfoID` char(36) DEFAULT NULL COMMENT '(DC2Type:guid)',
  `phoneInfoID` char(36) DEFAULT NULL COMMENT '(DC2Type:guid)',
  `addressInfoID` char(36) DEFAULT NULL COMMENT '(DC2Type:guid)',
  `officeID` char(36) DEFAULT NULL,
  `tempPassword` varchar(32) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `lastConnection` timestamp NULL DEFAULT NULL,
  `firstConnection` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`,`ownerID`),
  UNIQUE KEY `UNIQ_4068FE723D139428` (`personInfoID`),
  UNIQUE KEY `UNIQ_4068FE72627FFEF6` (`phoneInfoID`),
  UNIQUE KEY `UNIQ_4068FE72A680FCCC` (`addressInfoID`),
  KEY `fk_Assistant_Professional` (`ownerID`),
  KEY `fk_Assistant_Office` (`officeID`,`ownerID`),
  KEY `fk_Assistant_Credentials_idx` (`credentialsID`,`id`),
  KEY `fk_Assistant_PersonInfo_idx` (`personInfoID`),
  KEY `fk_Assistant_PhoneInfo_idx` (`phoneInfoID`),
  KEY `fk_Assistant_AddressInfo_idx` (`addressInfoID`),
  CONSTRAINT `fk_Assistant_AddressInfo` FOREIGN KEY (`addressInfoID`) REFERENCES `AddressInfo` (`id`),
  CONSTRAINT `fk_Assistant_Credentials` FOREIGN KEY (`credentialsID`) REFERENCES `Credentials` (`id`),
  CONSTRAINT `fk_Assistant_Office` FOREIGN KEY (`officeID`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Assistant_PersonInfo` FOREIGN KEY (`personInfoID`) REFERENCES `PersonInfo` (`id`),
  CONSTRAINT `fk_Assistant_PhoneInfo` FOREIGN KEY (`phoneInfoID`) REFERENCES `PhoneInfo` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Assistant`
--

LOCK TABLES `Assistant` WRITE;
/*!40000 ALTER TABLE `Assistant` DISABLE KEYS */;
/*!40000 ALTER TABLE `Assistant` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8mb3_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `Assistant_AFTER_DELETE` AFTER DELETE ON `Assistant` FOR EACH ROW BEGIN
	DELETE FROM PersonInfo  WHERE ownerID = OLD.ownerID AND id = OLD.personInfoID;
	DELETE FROM AddressInfo WHERE ownerID = OLD.ownerID AND id = OLD.addressInfoID;
	DELETE FROM PhoneInfo   WHERE ownerID = OLD.ownerID AND id = OLD.phoneInfoID;
	DELETE FROM Credentials WHERE ownerID = OLD.ownerID AND id = OLD.credentialsID;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `CircleOrder`
--

DROP TABLE IF EXISTS `CircleOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CircleOrder` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `actID` char(36) NOT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `title` varchar(64) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `status` enum('not_sent','waiting_wow_api','sending_wow_api','sending_circle_api','sent','cancelled') NOT NULL DEFAULT 'waiting_wow_api',
  `createdAt` datetime NOT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `json` text NOT NULL,
  `metadata` text NOT NULL,
  `localDisplayID` int unsigned DEFAULT NULL,
  `globalDisplayID` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_CircleOrder_Act` (`actID`,`ownerID`),
  CONSTRAINT `fk_CircleOrder_Act` FOREIGN KEY (`actID`, `ownerID`) REFERENCES `Act` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CircleOrder`
--

LOCK TABLES `CircleOrder` WRITE;
/*!40000 ALTER TABLE `CircleOrder` DISABLE KEYS */;
/*!40000 ALTER TABLE `CircleOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CircleOrderFile`
--

DROP TABLE IF EXISTS `CircleOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CircleOrderFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `orderID` char(36) NOT NULL,
  `fileID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`orderID`,`fileID`),
  KEY `fk_CircleOrderFile_CircleOrder` (`orderID`,`ownerID`),
  KEY `fk_CircleOrderFile_CondorFile` (`fileID`,`ownerID`),
  CONSTRAINT `fk_CircleOrderFile_CircleOrder` FOREIGN KEY (`orderID`, `ownerID`) REFERENCES `CircleOrder` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_CircleOrderFile_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CircleOrderFile`
--

LOCK TABLES `CircleOrderFile` WRITE;
/*!40000 ALTER TABLE `CircleOrderFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `CircleOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CondorFile`
--

DROP TABLE IF EXISTS `CondorFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CondorFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `path` text NOT NULL,
  `type` varchar(250) NOT NULL,
  `tag` varchar(250) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `originalName` varchar(100) DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `status` enum('CREATED','UPDATED','SYNCED','ERROR') DEFAULT NULL,
  `originalID` char(36) NOT NULL,
  `version` mediumint NOT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `metadata` text,
  PRIMARY KEY (`id`,`ownerID`),
  UNIQUE KEY `un_CondorFile_version` (`ownerID`,`originalID`,`version`),
  KEY `fk_CondorFile_Professional` (`ownerID`),
  KEY `fk_CondorFile_CondorFile` (`originalID`,`ownerID`),
  CONSTRAINT `fk_CondorFile_CondorFile` FOREIGN KEY (`originalID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_CondorFile_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CondorFile`
--

LOCK TABLES `CondorFile` WRITE;
/*!40000 ALTER TABLE `CondorFile` DISABLE KEYS */;
INSERT INTO `CondorFile` VALUES (1001,'003ab455-3328-453e-97c0-364312a671b8','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/39062d60-7a18-417a-9004-c58e9ce7d62a/session_9869e99c-7b47-4662-9766-0388d668fbf3/occlusion_36832844-9579-46df-aea1-b9baf6ad8787/scan_bb3b1572-479e-47fd-a564-1953a5f394cf/61_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_39062d60-7a18-417a-9004-c58e9ce7d62a_ACT_9869e99c-7b47-4662-9766-0388d668fbf3_SESS_36832844-9579-46df-aea1-b9baf6ad8787_TOSC_bb3b1572-479e-47fd-a564-1953a5f394cf_ZIP_','2023-03-10 17:21:35','2023-03-10 18:21:11','61_w1_o1_maxillaire_scan_file_0.zip','2023-03-10 18:21:35','SYNCED','003ab455-3328-453e-97c0-364312a671b8',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.61.1.1.1\",\"modelMatrix\":\"0.664743,0.744444,-0.0626098,0,-0.747072,0.662405,-0.0557101,0,-1.26591e-09,0.083807,0.996482,0,1.3568,-6.90398,-24.3339,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'00514ba5-3006-428d-87e3-9ce7215b8e79','','SNAPS','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_RISC_b434cfd5-6ef9-4523-92e9-9f68fc4af6be_SNAPS_','2022-09-09 16:21:09','2022-09-09 18:15:02','','2022-09-09 18:21:09','SYNCED','00514ba5-3006-428d-87e3-9ce7215b8e79',0,'2022-09-09 18:21:09','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.39.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'00584c27-96a9-457d-a22f-65ec02fd60cc','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/9e399d73-4d2e-4bb8-af48-a4e597811faa/session_b1cf14ce-00a9-48b6-8654-dadde26073f1/order_44280b02-8a83-4785-a801-85b4cbe1e3c2/46_w1_autre_prost_file_00584c27-96a9-457d-a22f-65ec02fd60cc_0.pdf','PDF','PATIENT_9e399d73-4d2e-4bb8-af48-a4e597811faa_ACT_b1cf14ce-00a9-48b6-8654-dadde26073f1_PROST_44280b02-8a83-4785-a801-85b4cbe1e3c2_PDF_','2023-01-26 13:02:18','2023-01-26 14:02:17','46_w1_autre_prost_file_00584c27-96a9-457d-a22f-65ec02fd60cc_0.pdf','2023-01-26 14:02:18','SYNCED','00584c27-96a9-457d-a22f-65ec02fd60cc',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.46.1.2 AUTRE FICHE DE PROTHESE\",\"title\":\"Autre PDF\"}'),(1001,'0094b009-39bf-4b30-bd35-96e7bcdd4020','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/533d4409-e39d-4a27-a0af-b59e6cf76ce3/session_319a8f1d-33fc-4f87-a108-b3eabda0510f/occlusion_3b38f07b-42cb-40b1-933f-365e568702e4/scan_109ca2c4-8222-4d02-9ac7-b4b93937e1e2/37_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_533d4409-e39d-4a27-a0af-b59e6cf76ce3_ACT_319a8f1d-33fc-4f87-a108-b3eabda0510f_SESS_3b38f07b-42cb-40b1-933f-365e568702e4_TOSC_109ca2c4-8222-4d02-9ac7-b4b93937e1e2_ZIP_','2022-07-07 15:51:57','2022-07-07 17:51:47','37_w1_o1_maxillaire_scan_file_1.zip','2022-07-07 17:51:57','SYNCED','0192b393-b665-47d2-aaac-671ff4a06d5c',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.37.1.1.1\",\"modelMatrix\":\"0.644942,0.738261,-0.197535,0,-0.764231,0.623026,-0.166702,0,-1.14666e-08,0.258475,0.966018,0,3.62982,-26.4657,-16.9038,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'00af1aee-3448-458a-9664-8c6714a79a2b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/scan_03839278-13f8-46e6-9581-ba11bc8bcb81/1_w1_o1_maxillaire_screenshot_00af1aee-3448-458a-9664-8c6714a79a2b_0.png','SCREENS','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_TOSC_03839278-13f8-46e6-9581-ba11bc8bcb81_SCREENS_','2022-01-19 13:04:00','2022-01-19 11:36:07','1_w1_o1_maxillaire_screenshot_00af1aee-3448-458a-9664-8c6714a79a2b_0.png','2022-01-19 14:04:00','SYNCED','00af1aee-3448-458a-9664-8c6714a79a2b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Screenshot 1.1.1.1.1 Maxillaire 2\",\"scanFileType\":\"PLY\",\"scanPosition\":\"1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1\",\"title\":\"Maxillaire 2\"}'),(1001,'013be9a4-374c-4881-9ac7-daff0b32f1c4','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/de078619-3946-4adb-a799-1c260e16face/session_24d0aeb5-3058-4070-aeea-97c289e41e3c/occlusion_ea6da896-1504-41fc-890c-7c48575e9e40/scan_aa24138a-68e8-4bc3-9a5d-d617f0fe496b/2_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_de078619-3946-4adb-a799-1c260e16face_ACT_24d0aeb5-3058-4070-aeea-97c289e41e3c_SESS_ea6da896-1504-41fc-890c-7c48575e9e40_TOSC_aa24138a-68e8-4bc3-9a5d-d617f0fe496b_SNAPS_','2022-01-19 14:06:34','2022-01-19 15:06:15','2_w1_o1_maxillaire_snapshot_1.png','2022-01-19 15:06:34','SYNCED','2cdb0d7a-4a22-4953-a430-1bf6d75a218e',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.2.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'013cf31d-9e89-41e9-8564-e2451f564c94','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/9efbbbe9-fd0a-44b1-988c-23571aad69fa/session_595a54fa-ae7d-4880-86a1-168b20242ecf/occlusion_b84a2165-e2d4-47e5-b110-a34bcaa24341/scan_d98bf27f-7cdb-4186-a0f0-31f79c31fd57/53_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_9efbbbe9-fd0a-44b1-988c-23571aad69fa_ACT_595a54fa-ae7d-4880-86a1-168b20242ecf_SESS_b84a2165-e2d4-47e5-b110-a34bcaa24341_RISC_d98bf27f-7cdb-4186-a0f0-31f79c31fd57_SNAPS_','2022-12-02 14:17:00','2022-12-02 15:14:01','53_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-12-02 15:17:00','SYNCED','013cf31d-9e89-41e9-8564-e2451f564c94',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.53.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'0146e444-0b10-41fd-a443-8fcfb1d6b068','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/3a170256-4132-4b56-ad27-b2cc7790bbf8/session_c57164ce-3f15-42b7-a8dc-96ab6a136184/occlusion_4779508f-bef4-4a89-9555-58b917369f06/scan_83a01b11-6b2a-4d82-8a2a-6c0f5c234c86/62_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_3a170256-4132-4b56-ad27-b2cc7790bbf8_ACT_c57164ce-3f15-42b7-a8dc-96ab6a136184_SESS_4779508f-bef4-4a89-9555-58b917369f06_LESC_83a01b11-6b2a-4d82-8a2a-6c0f5c234c86_ZIP_','2023-03-13 09:48:17','2023-03-13 10:48:05','62_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2023-03-13 10:48:17','SYNCED','0146e444-0b10-41fd-a443-8fcfb1d6b068',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.62.1.1.1\",\"modelMatrix\":\"-0.957133,-0.270816,0.12197,0,0.251938,-0.959886,-0.102048,0,0.143079,-0.0733502,0.987303,0,14.0402,4.93227,-20.0448,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'018696d3-f17d-483a-953f-cf3375c8278e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_e6c95ef7-636d-4c88-8d02-e2d9840573db/13_w1_o1_mandibule_scan_file_4.zip','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_e6c95ef7-636d-4c88-8d02-e2d9840573db_ZIP_','2022-01-27 16:40:57','2022-01-27 17:37:48','13_w1_o1_mandibule_scan_file_4.zip','2022-01-27 17:40:57','SYNCED','bcef8d3e-9632-4976-8cda-4c6f3ac50e99',4,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.1\",\"modelMatrix\":\"-0.963479,0.243305,-0.111855,0,-0.267785,-0.8754,0.402451,0,1.23617e-9,0.417706,0.908582,0,32.4632,-3.53421,-16.2323,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'01871527-25ae-49af-96e9-808249dbae23','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/204921b5-c765-4248-8e87-e3b0f7a46bff/session_88257045-93fb-43fb-8b0a-f39fbf5f8e9d/occlusion_ad360501-c145-40e5-9b88-808cd7a61eed/scan_fbf36163-e1ef-42da-9ec3-02d6cc9846f2/45_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_204921b5-c765-4248-8e87-e3b0f7a46bff_ACT_88257045-93fb-43fb-8b0a-f39fbf5f8e9d_SESS_ad360501-c145-40e5-9b88-808cd7a61eed_TOSC_fbf36163-e1ef-42da-9ec3-02d6cc9846f2_SNAPS_','2022-10-18 12:38:55','2022-10-18 14:38:45','45_w1_o1_maxillaire_snapshot_0.png','2022-10-18 14:38:55','SYNCED','01871527-25ae-49af-96e9-808249dbae23',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.45.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'0192b393-b665-47d2-aaac-671ff4a06d5c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/533d4409-e39d-4a27-a0af-b59e6cf76ce3/session_319a8f1d-33fc-4f87-a108-b3eabda0510f/occlusion_3b38f07b-42cb-40b1-933f-365e568702e4/scan_109ca2c4-8222-4d02-9ac7-b4b93937e1e2/37_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_533d4409-e39d-4a27-a0af-b59e6cf76ce3_ACT_319a8f1d-33fc-4f87-a108-b3eabda0510f_SESS_3b38f07b-42cb-40b1-933f-365e568702e4_TOSC_109ca2c4-8222-4d02-9ac7-b4b93937e1e2_ZIP_','2022-07-07 15:42:21','2022-07-07 17:42:10','37_w1_o1_maxillaire_scan_file_0.zip','2022-07-07 17:42:21','SYNCED','0192b393-b665-47d2-aaac-671ff4a06d5c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.37.1.1.1\",\"modelMatrix\":\"0.645872,0.740889,-0.18421,0,-0.763445,0.626789,-0.155841,0,4.41234e-09,0.241287,0.970454,0,3.47315,-26.0398,-17.4387,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'01bd7ce5-4459-41fa-9f87-0c8c8693ddd6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/452a5200-3e06-4b74-8949-6abc7f2dda8a/session_3e95d626-668f-45f7-98ad-be2cf9d7b90b/occlusion_bce8310f-eee9-4f0a-a6b7-d592dec66be5/computedocclusion_d9818808-7d5e-47e6-9880-cc95357483ff/26_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_452a5200-3e06-4b74-8949-6abc7f2dda8a_ACT_3e95d626-668f-45f7-98ad-be2cf9d7b90b_SESS_bce8310f-eee9-4f0a-a6b7-d592dec66be5_OCC_d9818808-7d5e-47e6-9880-cc95357483ff_BOPLY__ZIP_','2022-05-24 09:42:49','2022-05-24 11:42:41','26_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-05-24 11:42:49','SYNCED','01bd7ce5-4459-41fa-9f87-0c8c8693ddd6',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.26.1.1.2 Occlusion 2\",\"modelMatrix\":\"-0.440993,0.868318,-0.227045,0,-0.89751,-0.426649,0.111559,0,-1.10485e-08,0.252972,0.967474,0,8.55795,-16.8564,-17.5092,1\",\"referenceScanID\":\"1.26.1.1.2\",\"title\":\"Mandibule 1.26.1.1.2 Occlusion 2\"}'),(1001,'01d3e05e-ff13-4067-b5bd-5ec37bbc3d2c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/fa7fa96b-f393-4b9a-8198-144702462cfa/session_4bed076c-8541-4a2f-800a-5aeb4cb49de5/occlusion_16b82fca-4b65-4866-af87-1f6dbb42f5dc/computedocclusion_94a0167c-6798-4c78-a76c-cb9fc91ccdda/35_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_fa7fa96b-f393-4b9a-8198-144702462cfa_ACT_4bed076c-8541-4a2f-800a-5aeb4cb49de5_SESS_16b82fca-4b65-4866-af87-1f6dbb42f5dc_OCC_94a0167c-6798-4c78-a76c-cb9fc91ccdda_SNAPO__SNAPS_','2022-06-28 15:03:44','2022-06-28 17:03:25','35_w1_o1_snapshot_occ_file_0.png','2022-06-28 17:03:44','SYNCED','01d3e05e-ff13-4067-b5bd-5ec37bbc3d2c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'02dc36dc-042f-48ff-af0e-10111549609e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/593972a6-d7d6-4802-b87d-38aab371f71e/session_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480/occlusion_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3/scan_ae54b48a-8f70-45c1-81cc-4ed8a6bc0e95/3_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_593972a6-d7d6-4802-b87d-38aab371f71e_ACT_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480_SESS_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3_LESC_ae54b48a-8f70-45c1-81cc-4ed8a6bc0e95_ZIP_','2022-01-19 15:17:03','2022-01-19 16:16:52','3_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-01-19 16:17:03','SYNCED','02dc36dc-042f-48ff-af0e-10111549609e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.3.1.1.1\",\"modelMatrix\":\"-0.862425,0.0225098,0.514183,0,-0.0216437,-0.999168,0.0310726,0,0.506555,0.0491997,0.857481,0,1.24261,3.48267,-26.4232,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'02ecdd01-5bae-4a1c-b19c-371817d7ed3f','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/09688939-f53f-4f00-8366-687b244de26d/session_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525/occlusion_9655a7e0-4673-41c9-90da-a48c008e2d62/scan_8b05f1fc-00db-4f53-b19b-e43d44dbd773/64_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_09688939-f53f-4f00-8366-687b244de26d_ACT_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525_SESS_9655a7e0-4673-41c9-90da-a48c008e2d62_TOSC_8b05f1fc-00db-4f53-b19b-e43d44dbd773_ZIP_','2023-03-30 12:05:12','2023-03-30 14:05:04','64_w1_o1_maxillaire_scan_file_1.zip','2023-03-30 14:05:12','SYNCED','dabeb240-9c8c-4cd5-9b5d-29ba55a7c08f',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.64.1.1.2\",\"modelMatrix\":\"0.932401,-0.356505,0.0594418,0,0.361426,0.919704,-0.153347,0,1.18293e-09,0.164464,0.986383,0,-0.151312,-4.2608,-23.1792,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'03092f68-444a-4dae-beef-805dbb3d21a7','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/75ce481f-6c44-4d16-a477-ea40c4fa6022/session_9bf7b056-ca4f-4dab-937b-619d0eb20528/occlusion_d7580529-3ede-4e27-a2ae-01849ba4d397/scan_ead7bba4-f70a-466e-948c-a630d4da7a7a/55_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_75ce481f-6c44-4d16-a477-ea40c4fa6022_ACT_9bf7b056-ca4f-4dab-937b-619d0eb20528_SESS_d7580529-3ede-4e27-a2ae-01849ba4d397_TOSC_ead7bba4-f70a-466e-948c-a630d4da7a7a_ZIP_','2022-12-22 10:10:12','2022-12-22 11:09:59','55_w1_o1_maxillaire_scan_file_0.zip','2022-12-22 11:10:12','SYNCED','03092f68-444a-4dae-beef-805dbb3d21a7',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.55.1.1.1\",\"modelMatrix\":\"0.900971,0.421505,-0.102884,0,-0.43388,0.875274,-0.213643,0,-3.56801e-09,0.237125,0.971479,0,-18.4873,3.56402,-20.1585,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'0359cef1-34e3-442d-b4c2-ec7e05a71749','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/490e4b04-6edd-4f47-a2ed-232689892eca/session_62105a91-1675-4d36-88bd-34aa8fe2ce3c/occlusion_03784c27-fd8d-4745-9c26-d84c490869b3/computedocclusion_8dab59f8-3c64-4520-912b-687d8f68ebb8/56_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_490e4b04-6edd-4f47-a2ed-232689892eca_ACT_62105a91-1675-4d36-88bd-34aa8fe2ce3c_SESS_03784c27-fd8d-4745-9c26-d84c490869b3_OCC_8dab59f8-3c64-4520-912b-687d8f68ebb8_TOPLY__ZIP_','2023-02-17 09:39:57','2023-02-17 10:39:41','56_w1_o1_maxillaire_occlusion_occ_file_0.zip','2023-02-17 10:39:57','SYNCED','0359cef1-34e3-442d-b4c2-ec7e05a71749',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.56.1.1.1 Occlusion 1\",\"modelMatrix\":\"-0.110774,0.92511,-0.363182,0,-0.993846,-0.103113,0.0404803,0,2.8158e-09,0.365431,0.930838,0,11.1652,-21.6233,-21.971,1\",\"referenceScanID\":\"1.56.1.1.1\",\"title\":\"Maxillaire 1.56.1.1.1 Occlusion 1\"}'),(1001,'035fa0d1-dd19-497e-b90c-3eacf018100b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f4fc00ec-4af8-4a15-b427-f1c5aabf6260/session_498ae60a-23f0-44fc-9730-be499bfc4b46/occlusion_8f3d6c73-3468-45a5-85c7-93bba47ec9f7/scan_0d368f7d-e2ae-489f-b39f-cfe87c4103c8/30_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_f4fc00ec-4af8-4a15-b427-f1c5aabf6260_ACT_498ae60a-23f0-44fc-9730-be499bfc4b46_SESS_8f3d6c73-3468-45a5-85c7-93bba47ec9f7_TOSC_0d368f7d-e2ae-489f-b39f-cfe87c4103c8_SNAPS_','2022-06-14 13:26:12','2022-06-14 15:26:01','30_w1_o1_maxillaire_snapshot_0.png','2022-06-14 15:26:12','SYNCED','035fa0d1-dd19-497e-b90c-3eacf018100b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.30.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'038c47f3-791b-4934-8a4c-80a05ce0fbab','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/de078619-3946-4adb-a799-1c260e16face/session_24d0aeb5-3058-4070-aeea-97c289e41e3c/occlusion_ea6da896-1504-41fc-890c-7c48575e9e40/scan_aa24138a-68e8-4bc3-9a5d-d617f0fe496b/2_w1_o1_maxillaire_scan_file_2.zip','ZIP','PATIENT_de078619-3946-4adb-a799-1c260e16face_ACT_24d0aeb5-3058-4070-aeea-97c289e41e3c_SESS_ea6da896-1504-41fc-890c-7c48575e9e40_TOSC_aa24138a-68e8-4bc3-9a5d-d617f0fe496b_ZIP_','2022-01-19 14:09:10','2022-01-19 15:08:52','2_w1_o1_maxillaire_scan_file_2.zip','2022-01-19 15:09:10','SYNCED','80d822aa-8c38-4390-bdc1-0b044f167d73',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.2.1.1.1\",\"modelMatrix\":\"0.999693,0.0234182,-0.00803445,0,-0.0247581,0.94559,-0.324418,0,2.12043e-11,0.324518,0.94588,0,-21.3098,-33.4944,-23.4708,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'03de4e84-e7ac-4237-a849-78f53f7de504','','LIFI','PATIENT_a9e7a1ae-2d71-448f-80f6-19d916912a3c_ACT_07012a03-2a1e-44e4-9bc9-17e726862bc2_SESS_ab83a8b7-1eb1-4b13-9594-40d6479b2b19_BOSC_e33a7de9-6d02-41e0-b621-fc99e53eb96c_LIFI_','2022-12-22 08:46:46','2022-12-14 16:06:40','','2022-12-22 09:46:46','SYNCED','03de4e84-e7ac-4237-a849-78f53f7de504',0,'2022-12-22 09:46:46','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Mandibule 1.52.1.1.1 Ligne de finition 0\",\"name\":\"Ligne de finition 0\",\"title\":\"Mandibule LIFI\",\"toothNumber\":0,\"versionMarginLine\":1}'),(1001,'03f624d5-fb67-488f-ba6a-0e018eebce48','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7f47fd88-9ea0-4c08-9193-a54d4f158c7c/session_7873a396-419c-4215-83c7-fec9f2742ccf/occlusion_2e287bb0-e19a-414a-9177-23b335d286d9/scan_aa3849b7-bd16-41b9-8afe-0af192f363d1/16_w1_o2_mandibule_snapshot_1.png','SNAPS','PATIENT_7f47fd88-9ea0-4c08-9193-a54d4f158c7c_ACT_7873a396-419c-4215-83c7-fec9f2742ccf_SESS_2e287bb0-e19a-414a-9177-23b335d286d9_BOSC_aa3849b7-bd16-41b9-8afe-0af192f363d1_SNAPS_','2022-06-03 09:01:34','2022-06-03 11:01:25','16_w1_o2_mandibule_snapshot_1.png','2022-06-03 11:01:34','SYNCED','f1e9e673-dabe-4bb3-8a39-0e12c5205cb8',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.16.1.2.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'047f4c53-4393-44be-97eb-c2314f6a7806','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/204921b5-c765-4248-8e87-e3b0f7a46bff/session_88257045-93fb-43fb-8b0a-f39fbf5f8e9d/occlusion_ad360501-c145-40e5-9b88-808cd7a61eed/scan_d41511d0-af3c-425b-97a6-996125f4f9ac/45_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_204921b5-c765-4248-8e87-e3b0f7a46bff_ACT_88257045-93fb-43fb-8b0a-f39fbf5f8e9d_SESS_ad360501-c145-40e5-9b88-808cd7a61eed_RISC_d41511d0-af3c-425b-97a6-996125f4f9ac_SNAPS_','2022-10-18 13:00:03','2022-10-18 14:59:57','45_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-10-18 15:00:03','SYNCED','047f4c53-4393-44be-97eb-c2314f6a7806',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.45.1.1.2\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'04c945b0-9b8d-4a3c-94dc-f12cd6df6b3b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3ed7a8e0-5b4d-4ecf-b4ae-f855b16c0f93/session_fb42cec6-0bb6-41e9-912d-0517ff8e0942/occlusion_fb214b2f-5e41-492d-85c4-d4a11a3947c5/scan_5246161b-13eb-438c-8365-2fc243141f9b/42_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_3ed7a8e0-5b4d-4ecf-b4ae-f855b16c0f93_ACT_fb42cec6-0bb6-41e9-912d-0517ff8e0942_SESS_fb214b2f-5e41-492d-85c4-d4a11a3947c5_TOSC_5246161b-13eb-438c-8365-2fc243141f9b_ZIP_','2022-10-07 11:52:08','2022-10-07 13:51:54','42_w1_o1_maxillaire_scan_file_0.zip','2022-10-07 13:52:08','SYNCED','04c945b0-9b8d-4a3c-94dc-f12cd6df6b3b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.42.1.1.1\",\"modelMatrix\":\"-0.20917,0.954234,-0.213743,0,-0.977879,-0.204112,0.0457199,0,-2.38677e-09,0.218578,0.97582,0,-7.51486,-31.7634,-17.5389,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'04e4a117-3200-4c26-85c5-6b14197f4b36','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_4f8dc275-857c-482a-9886-5521591e9661/scan_df08df19-150c-437d-8ed4-bf2826644265/12_w1_o4_mandibule_scan_file_2.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_BOSC_df08df19-150c-437d-8ed4-bf2826644265_ZIP_','2022-02-18 16:21:56','2022-02-18 17:21:46','12_w1_o4_mandibule_scan_file_2.zip','2022-02-18 17:21:56','SYNCED','68cf35d1-7f31-4f48-8b81-a07300151534',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.4.5\",\"modelMatrix\":\"0.544059,0.800225,-0.252267,0,-0.839047,0.518887,-0.163576,0,1.62336e-08,0.300659,0.953732,0,0.402905,-10.8858,-19.8968,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'04f31f25-40ed-4635-a2b0-b657241835d4','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_0b63813c-7fbe-455b-a5e3-483908522ff0/4_w1_o2_mandibule_snapshot_0.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_BOSC_0b63813c-7fbe-455b-a5e3-483908522ff0_SNAPS_','2022-02-15 12:48:20','2022-02-15 13:48:11','4_w1_o2_mandibule_snapshot_0.png','2022-02-15 13:48:20','SYNCED','04f31f25-40ed-4635-a2b0-b657241835d4',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.2.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'050930b4-ded7-45ca-885c-5ac156ea0cf7','','SNAPS','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_OCC_d8bec5dc-8405-473d-9ba5-ae6e461ed6fd_SNAPO__SNAPS_','2022-02-07 11:15:30','2022-02-04 19:13:44','','2022-02-07 12:15:30','SYNCED','050930b4-ded7-45ca-885c-5ac156ea0cf7',0,'2022-02-07 12:15:30','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'051228e7-6cef-4467-9eb1-162b5b927ca3','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/09688939-f53f-4f00-8366-687b244de26d/session_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525/occlusion_9655a7e0-4673-41c9-90da-a48c008e2d62/scan_9a0374bf-de8a-4ee1-9c7a-71fe30bbcb5e/64_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_09688939-f53f-4f00-8366-687b244de26d_ACT_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525_SESS_9655a7e0-4673-41c9-90da-a48c008e2d62_BOSC_9a0374bf-de8a-4ee1-9c7a-71fe30bbcb5e_ZIP_','2023-03-30 11:57:22','2023-03-30 13:57:14','64_w1_o1_mandibule_scan_file_0.zip','2023-03-30 13:57:22','SYNCED','051228e7-6cef-4467-9eb1-162b5b927ca3',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.64.1.1.1\",\"modelMatrix\":\"0.00866116,0.968633,-0.248344,0,-0.999963,0.0083898,-0.00215103,0,-3.25436e-10,0.248353,0.96867,0,-10.1539,-7.59641,-17.4221,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'05c15182-223b-47c3-a79a-728540db8292','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/452a5200-3e06-4b74-8949-6abc7f2dda8a/session_3e95d626-668f-45f7-98ad-be2cf9d7b90b/occlusion_bce8310f-eee9-4f0a-a6b7-d592dec66be5/computedocclusion_d9818808-7d5e-47e6-9880-cc95357483ff/26_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_452a5200-3e06-4b74-8949-6abc7f2dda8a_ACT_3e95d626-668f-45f7-98ad-be2cf9d7b90b_SESS_bce8310f-eee9-4f0a-a6b7-d592dec66be5_OCC_d9818808-7d5e-47e6-9880-cc95357483ff_BOMA__MATRX_','2022-05-24 09:42:42','2022-05-24 11:42:41','26_w1_o1_mandibule_matrix_occ_file_0.m','2022-05-24 11:42:42','SYNCED','05c15182-223b-47c3-a79a-728540db8292',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.26.1.1.2 Occlusion 2\",\"referenceScanID\":\"1.26.1.1.2\",\"title\":\"Matrice Transfo. Mandibule 1.26.1.1.2 Occlusion 2\"}'),(1001,'0604d07a-bebf-444d-b0d3-ef45e6312bb6','','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_812fdd67-c9dc-4e0c-806a-0524a386b296_TOPLY__ZIP_','2022-02-07 17:55:14','2022-02-07 18:54:30','',NULL,'CREATED','0604d07a-bebf-444d-b0d3-ef45e6312bb6',0,'2022-02-07 18:55:14','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.17.1.1.1 Occlusion 5\",\"modelMatrix\":\"0.149253,0.920186,-0.361913,0,-0.988799,0.138896,-0.0546284,0,-8.90892e-10,0.366013,0.93061,0,-24.4594,-29.735,-12.8678,1\",\"referenceScanID\":\"1.17.1.1.1\",\"title\":\"Maxillaire 1.17.1.1.1 Occlusion 5\"}'),(1001,'0662c673-162f-4815-9123-d13af60701a2','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/scan_122a451a-273e-4448-b25b-f36d8efeed30/54_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_BOSC_122a451a-273e-4448-b25b-f36d8efeed30_ZIP_','2023-03-15 10:29:05','2023-03-15 11:28:32','54_w1_o1_mandibule_scan_file_0.zip','2023-03-15 11:29:05','SYNCED','0662c673-162f-4815-9123-d13af60701a2',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.54.1.1.6\",\"modelMatrix\":\"-0.999599,0.0258183,-0.0116515,0,-0.0283256,-0.911116,0.411175,0,-3.36598e-10,0.41134,0.911482,0,17.4173,6.0967,-21.0427,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'0676681c-d4aa-4678-bd6a-191ea94beddc','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/4fa1a134-d246-43d7-aa8c-b42e24b62b49/session_6aedf6fd-46d7-4259-88ba-5cf074ad5913/occlusion_47192ebb-25b6-4c9e-a09f-8ed295e60a87/computedocclusion_d5964fd1-cca9-4595-8400-d624697bd9e7/60_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_4fa1a134-d246-43d7-aa8c-b42e24b62b49_ACT_6aedf6fd-46d7-4259-88ba-5cf074ad5913_SESS_47192ebb-25b6-4c9e-a09f-8ed295e60a87_OCC_d5964fd1-cca9-4595-8400-d624697bd9e7_BOMA__MATRX_','2023-03-07 18:12:21','2023-03-07 19:11:43','60_w1_o1_mandibule_matrix_occ_file_0.m','2023-03-07 19:12:21','SYNCED','0676681c-d4aa-4678-bd6a-191ea94beddc',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.60.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.60.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.60.1.1.1 Occlusion 1\"}'),(1001,'0685d014-cc4e-4c35-9a8d-26f4c105e66e','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_ce625ba7-4218-40af-b344-df718da13f83/54_w1_o1_maxillaire_occlusion_occ_file_8.zip','ZIP','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_ce625ba7-4218-40af-b344-df718da13f83_TOPLY__ZIP_','2023-03-15 10:34:39','2023-03-15 11:32:30','54_w1_o1_maxillaire_occlusion_occ_file_8.zip','2023-03-15 11:34:39','SYNCED','ad02dce8-3ff6-4167-add8-6925d6562d5e',8,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.54.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.78238,0.620977,-0.0476379,0,-0.622801,0.780088,-0.059844,0,1.97556e-09,0.0764897,0.99707,0,-23.5433,3.60536,-19.7037,1\",\"referenceScanID\":\"1.54.1.1.1\",\"title\":\"Maxillaire 1.54.1.1.1 Occlusion 1\"}'),(2,'0695b9bc-6ebd-4a37-904a-5b84f5f478d6','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a4b302c-278d-4e12-ace5-f095ba0bf856/session_6206892a-2e7e-4765-ac90-b49bfb465997/occlusion_3c30231c-7cd7-4431-985b-2eaf7f6925ae/scan_21743037-e185-4ce7-80aa-af01b0d42c2d/3_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_21743037-e185-4ce7-80aa-af01b0d42c2d_SNAPS_','2022-09-06 09:20:42','2022-08-30 11:00:57','3_w1_o1_maxillaire_snapshot_0.png','2022-09-06 11:20:42','SYNCED','0695b9bc-6ebd-4a37-904a-5b84f5f478d6',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.3.1.1.6\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'070c1477-6bea-43bc-b0d6-b09d919b40c3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_be8c90b6-055f-49b1-a5b6-cb782162d6cd/12_w1_o1_mandibule_snapshot_2.png','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_be8c90b6-055f-49b1-a5b6-cb782162d6cd_SNAPS_','2022-02-04 12:39:32','2022-02-04 13:39:18','12_w1_o1_mandibule_snapshot_2.png','2022-02-04 13:39:32','SYNCED','09a60bd0-5644-4c1f-85c2-b6dfce87f5a8',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.6\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'072a7fd4-ae0e-46ae-8a9f-0fa5cc08ca50','','MATRX','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_OCC_ac3a5a7c-5db4-4c82-a2a9-9cb52e09f003_BOMA__MATRX_','2022-05-12 12:34:04','2022-05-12 14:33:33','',NULL,'CREATED','072a7fd4-ae0e-46ae-8a9f-0fa5cc08ca50',0,'2022-05-12 14:34:04','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.18.1.1.3 Occlusion 4\",\"referenceScanID\":\"1.18.1.1.3\",\"title\":\"Matrice Transfo. Mandibule 1.18.1.1.3 Occlusion 4\"}'),(1001,'0736b41f-5f3b-4cc2-98dc-956017612fa7','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/593972a6-d7d6-4802-b87d-38aab371f71e/session_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480/occlusion_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3/computedocclusion_e23c031c-2c78-414b-840d-85b58e959fbe/3_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_593972a6-d7d6-4802-b87d-38aab371f71e_ACT_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480_SESS_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3_OCC_e23c031c-2c78-414b-840d-85b58e959fbe_SNAPO__SNAPS_','2022-01-19 15:27:39','2022-01-19 16:26:52','3_w1_o1_snapshot_occ_file_0.png','2022-01-19 16:27:39','SYNCED','0736b41f-5f3b-4cc2-98dc-956017612fa7',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'0762fe2e-9e63-40a1-abb3-1e750f01a542','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/75ce481f-6c44-4d16-a477-ea40c4fa6022/session_9bf7b056-ca4f-4dab-937b-619d0eb20528/occlusion_d7580529-3ede-4e27-a2ae-01849ba4d397/scan_ead7bba4-f70a-466e-948c-a630d4da7a7a/55_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_75ce481f-6c44-4d16-a477-ea40c4fa6022_ACT_9bf7b056-ca4f-4dab-937b-619d0eb20528_SESS_d7580529-3ede-4e27-a2ae-01849ba4d397_TOSC_ead7bba4-f70a-466e-948c-a630d4da7a7a_ZIP_','2022-12-22 10:18:34','2022-12-22 11:18:22','55_w1_o1_maxillaire_scan_file_1.zip','2022-12-22 11:18:34','SYNCED','03092f68-444a-4dae-beef-805dbb3d21a7',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.55.1.1.1\",\"modelMatrix\":\"0.88865,0.449708,-0.0897979,0,-0.458586,0.871446,-0.174011,0,4.65964e-10,0.195815,0.980641,0,-17.9697,3.74745,-19.8657,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'07c3f250-4079-4176-a60e-48bb3a8bdedc','','ZIP','PATIENT_f9d03016-567a-4bd4-9cc5-dafeea34e365_ACT_a7bcb190-dd19-4f3b-8aab-266030bf4064_SESS_c321e210-b67c-40e8-bece-f8946164a768_LESC_25580af0-adbb-452a-8a44-6d9b1ca92471_ZIP_','2022-07-04 14:10:44','2022-07-04 16:07:52','','2022-07-04 16:10:44','SYNCED','07c3f250-4079-4176-a60e-48bb3a8bdedc',0,'2022-07-04 16:10:44','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.36.1.1.1\",\"modelMatrix\":\"-0.873504,0.0779007,0.479365,0,-0.0412056,-0.992002,0.106292,0,0.485647,0.104683,0.871462,0,-7.19234,-4.29622,-17.1182,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'07d4419f-c602-4dc8-b5f4-8c1ce7a7959b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/scan_a628b7db-c954-4964-8d48-1e09fa34d82b/1_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_RISC_a628b7db-c954-4964-8d48-1e09fa34d82b_SNAPS_','2022-01-19 12:59:18','2022-01-19 12:03:50','1_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-01-19 13:59:18','SYNCED','07d4419f-c602-4dc8-b5f4-8c1ce7a7959b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.1.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'081335b0-4cf5-4720-ac13-b858da5d8e93','','MATRX','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_OCC_778ed9fd-f658-471d-9dd0-a48417419cba_TOMA__MATRX_','2022-05-12 12:32:06','2022-05-12 14:31:43','',NULL,'CREATED','081335b0-4cf5-4720-ac13-b858da5d8e93',0,'2022-05-12 14:32:06','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.18.1.1.2 Occlusion 3\",\"referenceScanID\":\"1.18.1.1.2\",\"title\":\"Matrice Transfo. Maxillaire 1.18.1.1.2 Occlusion 3\"}'),(1001,'08509c37-5e28-4b88-b2ce-fd2bd6b2e379','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/computedocclusion_864c98a3-fcf7-466a-b999-13bd4dfb8c65/23_w1_o1_ml_occ_file_to1000.xyz','LIFI','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_864c98a3-fcf7-466a-b999-13bd4dfb8c65_LIFIO_LIFI_','2022-05-25 08:32:45','2022-05-25 10:32:43','23_w1_o1_ml_occ_file_to1000.xyz','2022-05-25 10:32:45','SYNCED','08509c37-5e28-4b88-b2ce-fd2bd6b2e379',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.23.1.1.1 Occlusion 3 Ligne de finition 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"Maxillaire\",\"name\":\"Ligne de finition 0\",\"title\":\"Ligne finition\",\"toothNumber\":1000}'),(1001,'086ebbc5-5be9-48b1-baac-be846813e417','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/ca43bf7b-f931-42fc-bb75-05929e4b6578/session_d9740504-a9ca-472a-83f2-a309fa225a98/occlusion_d663165c-f330-4c61-8d1f-14869b6d5edd/scan_50db8169-6393-4f74-b798-2e2afc5648cb/59_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_ca43bf7b-f931-42fc-bb75-05929e4b6578_ACT_d9740504-a9ca-472a-83f2-a309fa225a98_SESS_d663165c-f330-4c61-8d1f-14869b6d5edd_TOSC_50db8169-6393-4f74-b798-2e2afc5648cb_ZIP_','2023-03-10 15:10:47','2023-03-10 16:10:31','59_w1_o1_maxillaire_scan_file_1.zip','2023-03-10 16:10:47','SYNCED','d9f9a845-cc33-4c3a-94cc-5542bdda4625',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.59.1.1.2\",\"modelMatrix\":\"0.696694,-0.715993,0.044405,0,0.717368,0.695358,-0.0431252,0,1.36208e-09,0.0618998,0.998082,0,-9.78657,6.4569,-24.1398,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'086ee5b6-e3e6-4beb-9c14-6fea397482f6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a0c21836-ba79-4f15-9e35-02ef8211a9e5/session_0aac522d-3c38-465a-a1e0-014166c140ac/occlusion_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042/scan_dda4ec6d-010a-4593-be9f-97cb59747424/7_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_a0c21836-ba79-4f15-9e35-02ef8211a9e5_ACT_0aac522d-3c38-465a-a1e0-014166c140ac_SESS_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042_BOSC_dda4ec6d-010a-4593-be9f-97cb59747424_ZIP_','2022-02-02 10:14:56','2022-02-02 11:14:39','7_w1_o1_mandibule_scan_file_1.zip','2022-02-02 11:14:56','SYNCED','54af140d-b148-43e6-84b4-455ce19fbd59',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.7.1.1.1\",\"modelMatrix\":\"-0.95397,-0.276542,0.116045,0,0.299903,-0.879659,0.369132,0,-4.3083e-9,0.386943,0.922104,0,13.6932,12.2039,-15.7846,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'08725014-e287-4ddd-9b4f-f24b8ede2c81','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/452a5200-3e06-4b74-8949-6abc7f2dda8a/session_3e95d626-668f-45f7-98ad-be2cf9d7b90b/occlusion_bce8310f-eee9-4f0a-a6b7-d592dec66be5/computedocclusion_7a922eb8-5139-40fe-8402-fc7ff4204a1a/26_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_452a5200-3e06-4b74-8949-6abc7f2dda8a_ACT_3e95d626-668f-45f7-98ad-be2cf9d7b90b_SESS_bce8310f-eee9-4f0a-a6b7-d592dec66be5_OCC_7a922eb8-5139-40fe-8402-fc7ff4204a1a_TOPLY__ZIP_','2022-05-24 09:42:29','2022-05-24 11:42:09','26_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-05-24 11:42:29','SYNCED','08725014-e287-4ddd-9b4f-f24b8ede2c81',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.26.1.1.2 Occlusion 1\",\"modelMatrix\":\"-0.139935,0.977576,-0.157365,0,-0.990161,-0.138156,0.0222396,0,1.70026e-09,0.158929,0.98729,0,5.50609,-23.1559,-20.3156,1\",\"referenceScanID\":\"1.26.1.1.2\",\"title\":\"Maxillaire 1.26.1.1.2 Occlusion 1\"}'),(1001,'08d66e35-60ec-40de-9630-bb1e03b53763','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/3a170256-4132-4b56-ad27-b2cc7790bbf8/session_c57164ce-3f15-42b7-a8dc-96ab6a136184/occlusion_4779508f-bef4-4a89-9555-58b917369f06/scan_dab06410-30fb-49be-bfaf-383db97cad4a/62_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_3a170256-4132-4b56-ad27-b2cc7790bbf8_ACT_c57164ce-3f15-42b7-a8dc-96ab6a136184_SESS_4779508f-bef4-4a89-9555-58b917369f06_TOSC_dab06410-30fb-49be-bfaf-383db97cad4a_SNAPS_','2023-03-13 09:32:42','2023-03-13 10:32:15','62_w1_o1_maxillaire_snapshot_0.png','2023-03-13 10:32:42','SYNCED','08d66e35-60ec-40de-9630-bb1e03b53763',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.62.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'0900dead-3491-44ec-92ff-5e09fb9ec644','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_2a7068fc-0efa-496f-ade9-aba5b0650655/12_w1_o1_mandibule_snapshot_2.png','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_2a7068fc-0efa-496f-ade9-aba5b0650655_SNAPS_','2022-02-04 12:01:40','2022-02-04 12:56:15','12_w1_o1_mandibule_snapshot_2.png','2022-02-04 13:01:40','SYNCED','7636e0d7-f242-431c-90a5-a65399d83ecd',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.5\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'09025a29-a970-4a55-ba45-df833fbfb496','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_ce625ba7-4218-40af-b344-df718da13f83/54_w1_o1_snapshot_occ_file_2.png','SNAPS','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_ce625ba7-4218-40af-b344-df718da13f83_SNAPO__SNAPS_','2023-03-15 10:17:55','2023-03-15 11:15:19','54_w1_o1_snapshot_occ_file_2.png','2023-03-15 11:17:55','SYNCED','7646ffac-dba0-4ac0-b4a3-8547134e5318',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'093a5406-8872-40b5-a600-40b1e8cb1279','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_ce625ba7-4218-40af-b344-df718da13f83/54_w1_o1_maxillaire_matrix_occ_file_1.m','MATRX','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_ce625ba7-4218-40af-b344-df718da13f83_TOMA__MATRX_','2023-03-15 10:16:46','2023-03-15 11:15:16','54_w1_o1_maxillaire_matrix_occ_file_1.m','2023-03-15 11:16:46','SYNCED','ccf7be44-96c0-48d2-80d6-833cb64e29bc',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.54.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.54.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.54.1.1.1 Occlusion 1\"}'),(1001,'09422c66-2d08-4848-b594-02ffb047e8ff','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5/occlusion_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa/computedocclusion_901f8265-7f99-4d24-a03f-5860f5bc155e/24_w2_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5_SESS_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa_OCC_901f8265-7f99-4d24-a03f-5860f5bc155e_BOMA__MATRX_','2022-10-07 14:32:17','2022-10-07 16:31:57','24_w2_o1_mandibule_matrix_occ_file_0.m','2022-10-07 16:32:17','SYNCED','09422c66-2d08-4848-b594-02ffb047e8ff',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.24.2.1.5 Occlusion 1\",\"referenceScanID\":\"1.24.2.1.5\",\"title\":\"Matrice Transfo. Mandibule 1.24.2.1.5 Occlusion 1\"}'),(1001,'0960c7db-412b-47c9-a02f-f06e2e0da8a8','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/458c92d8-9da1-4df9-967f-d14fc7e6303d/session_55831d43-1906-4a22-9b7a-ed4b2820c8b2/occlusion_4f582d4c-81d0-4e01-8be3-9ff53b12c7f4/scan_6d0788eb-96a4-43dc-aa97-e9dbd7601d00/10_w2_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_55831d43-1906-4a22-9b7a-ed4b2820c8b2_SESS_4f582d4c-81d0-4e01-8be3-9ff53b12c7f4_BOSC_6d0788eb-96a4-43dc-aa97-e9dbd7601d00_SNAPS_','2022-06-16 13:35:06','2022-06-16 15:34:56','10_w2_o1_mandibule_snapshot_0.png','2022-06-16 15:35:06','SYNCED','0960c7db-412b-47c9-a02f-f06e2e0da8a8',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.10.2.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'09743d0a-42f3-4648-83b5-586df5bea185','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/9e399d73-4d2e-4bb8-af48-a4e597811faa/session_b1cf14ce-00a9-48b6-8654-dadde26073f1/occlusion_1060c95f-48f4-4a37-9b82-03bfd8329730/scan_f1e1a23d-a279-4fec-8d2c-40dc846885d2/46_w1_o2_mandibule_scan_file_1.zip','ZIP','PATIENT_9e399d73-4d2e-4bb8-af48-a4e597811faa_ACT_b1cf14ce-00a9-48b6-8654-dadde26073f1_SESS_1060c95f-48f4-4a37-9b82-03bfd8329730_BOSC_f1e1a23d-a279-4fec-8d2c-40dc846885d2_ZIP_','2023-01-20 14:28:06','2023-01-20 15:27:55','46_w1_o2_mandibule_scan_file_1.zip','2023-01-20 15:28:06','SYNCED','d19eb871-16ba-4704-b168-fabbd44fda31',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.46.1.2.1\",\"modelMatrix\":\"0.898652,-0.437095,0.0370517,0,0.438663,0.89544,-0.0759047,0,-4.02422e-10,0.084465,0.996426,0,-18.1734,-0.285451,-19.9333,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'09a60bd0-5644-4c1f-85c2-b6dfce87f5a8','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_be8c90b6-055f-49b1-a5b6-cb782162d6cd/12_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_be8c90b6-055f-49b1-a5b6-cb782162d6cd_SNAPS_','2022-02-04 12:32:22','2022-02-04 13:32:06','12_w1_o1_mandibule_snapshot_0.png','2022-02-04 13:32:22','SYNCED','09a60bd0-5644-4c1f-85c2-b6dfce87f5a8',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.6\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'0a58d1c6-38a8-4015-b4eb-e52116984b09','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_2a7068fc-0efa-496f-ade9-aba5b0650655/12_w1_o1_mandibule_scan_file_4.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_2a7068fc-0efa-496f-ade9-aba5b0650655_ZIP_','2022-02-04 12:02:09','2022-02-04 12:57:18','12_w1_o1_mandibule_scan_file_4.zip','2022-02-04 13:02:09','SYNCED','44ebcd6f-57c2-4cce-96f5-f9faa1c6b373',4,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.5\",\"modelMatrix\":\"0.713807,-0.664318,0.221723,0,0.700343,0.677089,-0.225986,0,-4.22566e-9,0.316593,0.948562,0,3.53751,30.2884,-29.5645,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'0a69600b-9dec-4bda-bf5d-cf963cc65c76','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/4a3954e0-1e2f-4721-9fdd-4180380dc19f/session_33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416/occlusion_3accbada-5a51-4d10-88d1-c3e7d8598d6f/scan_eb03dd9c-db3d-4d79-99ee-0715da7cea41/34_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_4a3954e0-1e2f-4721-9fdd-4180380dc19f_ACT_33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416_SESS_3accbada-5a51-4d10-88d1-c3e7d8598d6f_TOSC_eb03dd9c-db3d-4d79-99ee-0715da7cea41_ZIP_','2022-06-28 10:53:48','2022-06-28 12:53:41','34_w1_o1_maxillaire_scan_file_0.zip','2022-06-28 12:53:48','SYNCED','0a69600b-9dec-4bda-bf5d-cf963cc65c76',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.34.1.1.1\",\"modelMatrix\":\"0.433907,0.888246,-0.150809,0,-0.900958,0.427785,-0.0726306,0,2.15454e-09,0.167388,0.985891,0,-4.91739,-21.5763,-15.238,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'0a6f7e88-646e-4386-a4b9-0847224e61ab','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/computedocclusion_35af1bf5-285a-4bb1-a6db-fe9897defe51/23_w1_o1_ml_occ_file_to1000.xyz','LIFI','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_35af1bf5-285a-4bb1-a6db-fe9897defe51_LIFIO_LIFI_','2022-05-25 08:32:46','2022-05-25 10:32:43','23_w1_o1_ml_occ_file_to1000.xyz','2022-05-25 10:32:46','SYNCED','0a6f7e88-646e-4386-a4b9-0847224e61ab',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.23.1.1.1 Occlusion 4 Ligne de finition 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"Maxillaire\",\"name\":\"Ligne de finition 0\",\"title\":\"Ligne finition\",\"toothNumber\":1000}'),(1001,'0a7f9b71-a36a-4208-a4f3-4b871a9a350a','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/372000f2-2471-4a57-9b18-224d0788041f/session_5dd64d24-8e33-45bd-a282-c148c185c338/occlusion_a61fbfda-1ac5-4747-9e0c-6ef664930816/scan_d714312c-15c4-47a6-8000-0e2c92bf1d7d/57_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_372000f2-2471-4a57-9b18-224d0788041f_ACT_5dd64d24-8e33-45bd-a282-c148c185c338_SESS_a61fbfda-1ac5-4747-9e0c-6ef664930816_RISC_d714312c-15c4-47a6-8000-0e2c92bf1d7d_SNAPS_','2023-02-17 10:55:20','2023-02-17 11:55:13','57_w1_o1_mordu_posterieur_droit_snapshot_0.png','2023-02-17 11:55:20','SYNCED','0a7f9b71-a36a-4208-a4f3-4b871a9a350a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.57.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'0a9ebab4-2df3-4fb9-9a55-13558575a869','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/order_862350ae-e3fa-4271-a22e-8c96d4c89f10/22_w1_autre_prost_file_0a9ebab4-2df3-4fb9-9a55-13558575a869_0.pdf','PDF','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_PROST_862350ae-e3fa-4271-a22e-8c96d4c89f10_PDF_','2022-04-21 17:47:19','2022-04-21 19:47:17','22_w1_autre_prost_file_0a9ebab4-2df3-4fb9-9a55-13558575a869_0.pdf','2022-04-21 19:47:19','SYNCED','0a9ebab4-2df3-4fb9-9a55-13558575a869',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.22.1.1 AUTRE FICHE DE PROTHESE\",\"title\":\"Autre PDF\"}'),(1001,'0aaf60aa-0ec5-4c3b-ab1d-1cc17e7e9980','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/ca43bf7b-f931-42fc-bb75-05929e4b6578/session_d9740504-a9ca-472a-83f2-a309fa225a98/occlusion_d663165c-f330-4c61-8d1f-14869b6d5edd/computedocclusion_f62e0c41-a151-4495-829e-f57ef5d37eb8/59_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_ca43bf7b-f931-42fc-bb75-05929e4b6578_ACT_d9740504-a9ca-472a-83f2-a309fa225a98_SESS_d663165c-f330-4c61-8d1f-14869b6d5edd_OCC_f62e0c41-a151-4495-829e-f57ef5d37eb8_TOMA__MATRX_','2023-03-10 15:13:46','2023-03-10 16:13:23','59_w1_o1_maxillaire_matrix_occ_file_0.m','2023-03-10 16:13:46','SYNCED','0aaf60aa-0ec5-4c3b-ab1d-1cc17e7e9980',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.59.1.1.2 Occlusion 1\",\"referenceScanID\":\"1.59.1.1.2\",\"title\":\"Matrice Transfo. Maxillaire 1.59.1.1.2 Occlusion 1\"}'),(1001,'0abefe94-3f85-4adb-b30a-34fe734e64a2','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/fa7fa96b-f393-4b9a-8198-144702462cfa/session_4bed076c-8541-4a2f-800a-5aeb4cb49de5/occlusion_16b82fca-4b65-4866-af87-1f6dbb42f5dc/computedocclusion_94a0167c-6798-4c78-a76c-cb9fc91ccdda/35_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_fa7fa96b-f393-4b9a-8198-144702462cfa_ACT_4bed076c-8541-4a2f-800a-5aeb4cb49de5_SESS_16b82fca-4b65-4866-af87-1f6dbb42f5dc_OCC_94a0167c-6798-4c78-a76c-cb9fc91ccdda_BOMA__MATRX_','2022-06-28 15:03:44','2022-06-28 17:03:25','35_w1_o1_mandibule_matrix_occ_file_0.m','2022-06-28 17:03:44','SYNCED','0abefe94-3f85-4adb-b30a-34fe734e64a2',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.35.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.35.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.35.1.1.1 Occlusion 1\"}'),(1001,'0b1ecbba-2084-479e-9a91-17377ffa6856','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/490e4b04-6edd-4f47-a2ed-232689892eca/session_62105a91-1675-4d36-88bd-34aa8fe2ce3c/occlusion_03784c27-fd8d-4745-9c26-d84c490869b3/scan_2b1e22f8-a080-4217-9229-4821ea93965d/56_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_490e4b04-6edd-4f47-a2ed-232689892eca_ACT_62105a91-1675-4d36-88bd-34aa8fe2ce3c_SESS_03784c27-fd8d-4745-9c26-d84c490869b3_BOSC_2b1e22f8-a080-4217-9229-4821ea93965d_ZIP_','2023-02-17 09:35:02','2023-02-17 10:34:55','56_w1_o1_mandibule_scan_file_0.zip','2023-02-17 10:35:02','SYNCED','0b1ecbba-2084-479e-9a91-17377ffa6856',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.56.1.1.1\",\"modelMatrix\":\"-0.932575,-0.347234,0.0986526,0,0.360977,-0.897072,0.254867,0,-3.57676e-09,0.273294,0.961931,0,23.3574,-4.74819,-17.6637,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'0b902cd8-144a-4a2d-a2da-dc9d7a13668b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/986374de-c4d7-4d6f-bf0c-2dc7e3b859a9/session_c81670ed-4144-4347-b19e-8057d11b5f7c/occlusion_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be/computedocclusion_7a5acfd0-87ca-4009-aa4e-677a88ceffde/28_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_986374de-c4d7-4d6f-bf0c-2dc7e3b859a9_ACT_c81670ed-4144-4347-b19e-8057d11b5f7c_SESS_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be_OCC_7a5acfd0-87ca-4009-aa4e-677a88ceffde_SNAPO__SNAPS_','2022-05-31 10:54:13','2022-05-31 12:53:55','28_w1_o1_snapshot_occ_file_0.png','2022-05-31 12:54:13','SYNCED','0b902cd8-144a-4a2d-a2da-dc9d7a13668b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'0ba98896-34dc-4662-8aca-beb999e99512','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/scan_03839278-13f8-46e6-9581-ba11bc8bcb81/1_w1_o1_maxillaire_snapshot_4.png','SNAPS','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_TOSC_03839278-13f8-46e6-9581-ba11bc8bcb81_SNAPS_','2022-01-19 13:00:20','2022-01-19 11:35:09','1_w1_o1_maxillaire_snapshot_4.png','2022-01-19 14:00:20','SYNCED','99c7b58b-6259-4c43-ac2f-8b7f47f0b3e7',4,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.1.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'0c0b6b4b-ea96-436e-870c-67030a45f51f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/computedocclusion_00405f86-eefa-41f9-8d98-1fa9cbeef855/24_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_00405f86-eefa-41f9-8d98-1fa9cbeef855_BOMA__MATRX_','2022-05-25 09:03:41','2022-05-25 11:02:54','24_w1_o1_mandibule_matrix_occ_file_0.m','2022-05-25 11:03:41','SYNCED','0c0b6b4b-ea96-436e-870c-67030a45f51f',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.24.1.1.1 Occlusion 4\",\"referenceScanID\":\"1.24.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.24.1.1.1 Occlusion 4\"}'),(1001,'0cc52590-1049-4b69-b1f4-fc0364e6ce81','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/order_220692cd-dfae-4cae-ae0f-48969e936e55/4_w1_autre_prost_file_0cc52590-1049-4b69-b1f4-fc0364e6ce81_0.pdf','PDF','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_PROST_220692cd-dfae-4cae-ae0f-48969e936e55_PDF_','2022-02-23 09:40:55','2022-02-23 10:40:54','4_w1_autre_prost_file_0cc52590-1049-4b69-b1f4-fc0364e6ce81_0.pdf','2022-02-23 10:40:55','SYNCED','0cc52590-1049-4b69-b1f4-fc0364e6ce81',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.4.1.1 AUTRE FICHE DE PROTHESE\",\"title\":\"Autre PDF\"}'),(1001,'0cc87d78-7cdd-490b-a798-076c185661ab','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a20364ca-68f6-43af-9d85-5203eb8e7fd3/session_4fbadc34-458e-4383-9cea-ff5422d69287/occlusion_56872db7-25ba-4ec4-a526-b4254011197f/scan_b8c939df-e321-4456-bce2-124f466e6783/49_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_a20364ca-68f6-43af-9d85-5203eb8e7fd3_ACT_4fbadc34-458e-4383-9cea-ff5422d69287_SESS_56872db7-25ba-4ec4-a526-b4254011197f_TOSC_b8c939df-e321-4456-bce2-124f466e6783_SNAPS_','2022-10-28 10:12:02','2022-10-28 12:12:02','49_w1_o1_maxillaire_snapshot_0.png','2022-10-28 12:12:02','SYNCED','0cc87d78-7cdd-490b-a798-076c185661ab',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.49.1.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'0cf20f0f-ac97-4211-869b-4b322cf0e13e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_e6c95ef7-636d-4c88-8d02-e2d9840573db/13_w1_o1_mandibule_scan_file_9.zip','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_e6c95ef7-636d-4c88-8d02-e2d9840573db_ZIP_','2022-01-27 16:54:08','2022-01-27 17:50:13','13_w1_o1_mandibule_scan_file_9.zip','2022-01-27 17:54:08','SYNCED','bcef8d3e-9632-4976-8cda-4c6f3ac50e99',9,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.1\",\"modelMatrix\":\"-0.961822,0.259307,-0.0875072,0,-0.273675,-0.911329,0.307542,0,5.65717e-9,0.319749,0.947502,0,33.7925,-1.80222,-15.4388,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'0d45e478-acd1-41de-ad65-75a3b7160d51','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/ca43bf7b-f931-42fc-bb75-05929e4b6578/session_d9740504-a9ca-472a-83f2-a309fa225a98/occlusion_d663165c-f330-4c61-8d1f-14869b6d5edd/scan_7b6a9df3-3f34-48df-a44e-e6d77507d049/59_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_ca43bf7b-f931-42fc-bb75-05929e4b6578_ACT_d9740504-a9ca-472a-83f2-a309fa225a98_SESS_d663165c-f330-4c61-8d1f-14869b6d5edd_TOSC_7b6a9df3-3f34-48df-a44e-e6d77507d049_SNAPS_','2023-03-02 14:54:31','2023-03-02 15:54:23','59_w1_o1_maxillaire_snapshot_0.png','2023-03-02 15:54:31','SYNCED','0d45e478-acd1-41de-ad65-75a3b7160d51',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.59.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'0d6de494-e1aa-4f47-b88c-b9723d086c97','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3cc1b522-8e7d-4196-87a1-a8c234f0a399/session_ef503949-33e8-4db6-bbfa-456bd8b70b73/occlusion_e8e2758f-faa4-4db7-93df-e94ddfbd8284/scan_f50e5124-f992-40b4-97cd-258bc3037b29/51_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_3cc1b522-8e7d-4196-87a1-a8c234f0a399_ACT_ef503949-33e8-4db6-bbfa-456bd8b70b73_SESS_e8e2758f-faa4-4db7-93df-e94ddfbd8284_TOSC_f50e5124-f992-40b4-97cd-258bc3037b29_ZIP_','2022-11-28 16:48:08','2022-11-28 17:47:54','51_w1_o1_maxillaire_scan_file_1.zip','2022-11-28 17:48:08','SYNCED','932bea04-3b46-4f5e-a6a7-39b40b8f36f2',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.51.1.1.1\",\"modelMatrix\":\"0.630822,0.711644,-0.309235,0,-0.775928,0.57856,-0.251405,0,-7.05967e-09,0.398536,0.917153,0,-31.3389,-23.6543,-12.4006,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'0dbd0737-62de-4709-b376-5c0e86141952','','SNAPS','PATIENT_1095dc95-d70a-4936-8b50-ae8aa7963fc9_ACT_440a8315-0df8-4219-8d74-9470bfeeacbf_SESS_8cfb01ae-a13a-442b-9752-d2219bf5d263_TOSC_807a5b2c-0545-475c-b38c-00561d7c62df_SNAPS_','2022-08-30 08:32:23','2022-07-28 14:33:13','',NULL,'CREATED','0dbd0737-62de-4709-b376-5c0e86141952',0,'2022-08-30 10:32:23','bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.2.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'0dc2708d-447b-4810-a0bf-4f90c23a850a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a9e7a1ae-2d71-448f-80f6-19d916912a3c/session_07012a03-2a1e-44e4-9bc9-17e726862bc2/occlusion_ab83a8b7-1eb1-4b13-9594-40d6479b2b19/scan_e33a7de9-6d02-41e0-b621-fc99e53eb96c/52_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_a9e7a1ae-2d71-448f-80f6-19d916912a3c_ACT_07012a03-2a1e-44e4-9bc9-17e726862bc2_SESS_ab83a8b7-1eb1-4b13-9594-40d6479b2b19_BOSC_e33a7de9-6d02-41e0-b621-fc99e53eb96c_ZIP_','2022-11-29 10:35:25','2022-11-29 11:35:18','52_w1_o1_mandibule_scan_file_1.zip','2022-11-29 11:35:25','SYNCED','f2bb5b23-86c9-420a-a191-087935901024',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.52.1.1.1\",\"modelMatrix\":\"-0.188011,0.944199,-0.270443,0,-0.982167,-0.180743,0.0517695,0,-4.05294e-09,0.275354,0.961343,0,2.74207,-13.7869,-19.8105,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'0e202590-c363-4913-9535-a4a43f96f003','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5/occlusion_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa/scan_6148a482-5ea5-4353-ace5-f0d520a32e6e/24_w2_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5_SESS_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa_TOSC_6148a482-5ea5-4353-ace5-f0d520a32e6e_ZIP_','2022-10-06 14:27:20','2022-10-06 16:27:08','24_w2_o1_maxillaire_scan_file_0.zip','2022-10-06 16:27:20','SYNCED','0e202590-c363-4913-9535-a4a43f96f003',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.2.1.1\",\"modelMatrix\":\"0.626985,0.76241,-0.160065,0,-0.779032,0.613607,-0.128824,0,4.39427e-09,0.205467,0.978664,0,0.203644,-29.5943,-18.0319,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'0e5e7fa9-337f-4ed4-b21e-329af32d059f','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/09688939-f53f-4f00-8366-687b244de26d/session_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525/occlusion_9655a7e0-4673-41c9-90da-a48c008e2d62/scan_8e48d6b3-b208-429e-bf9d-ca9d687d5008/64_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_09688939-f53f-4f00-8366-687b244de26d_ACT_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525_SESS_9655a7e0-4673-41c9-90da-a48c008e2d62_RISC_8e48d6b3-b208-429e-bf9d-ca9d687d5008_SNAPS_','2023-03-30 12:09:26','2023-03-30 14:07:59','64_w1_o1_mordu_posterieur_droit_snapshot_0.png','2023-03-30 14:09:26','SYNCED','0e5e7fa9-337f-4ed4-b21e-329af32d059f',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.64.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'0e7c83e5-0cfc-496c-a1f8-ed11502b47b7','','MATRX','PATIENT_9e399d73-4d2e-4bb8-af48-a4e597811faa_ACT_b1cf14ce-00a9-48b6-8654-dadde26073f1_SESS_3c4595e0-fbbb-4814-8851-1e014eb9a3b2_OCC_96299368-ebcf-4fb9-875d-9bbcfec8ffa0_BOMA__MATRX_','2022-10-27 17:31:09','2022-10-27 19:30:22','','2022-10-27 19:31:09','SYNCED','0e7c83e5-0cfc-496c-a1f8-ed11502b47b7',0,'2022-10-27 19:31:09','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.46.1.1.5 Occlusion 2\",\"referenceScanID\":\"1.46.1.1.5\",\"title\":\"Matrice Transfo. Mandibule 1.46.1.1.5 Occlusion 2\"}'),(1001,'0eb7d0da-dd5e-458e-b51d-1b6310760ce8','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a0c21836-ba79-4f15-9e35-02ef8211a9e5/session_0aac522d-3c38-465a-a1e0-014166c140ac/occlusion_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042/scan_e3c95f99-398c-470f-97a1-8755ccbe1568/7_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_a0c21836-ba79-4f15-9e35-02ef8211a9e5_ACT_0aac522d-3c38-465a-a1e0-014166c140ac_SESS_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042_BOSC_e3c95f99-398c-470f-97a1-8755ccbe1568_SNAPS_','2022-01-21 11:56:39','2022-01-21 12:56:07','7_w1_o1_mandibule_snapshot_0.png','2022-01-21 12:56:39','SYNCED','0eb7d0da-dd5e-458e-b51d-1b6310760ce8',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.7.1.1.4\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'0ed2aa3b-9a59-495c-9032-f6eb5757beb8','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/computedocclusion_e15a2d21-e8f2-4d2a-9a68-13d92ae4b997/13_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_OCC_e15a2d21-e8f2-4d2a-9a68-13d92ae4b997_BOPLY__ZIP_','2022-02-04 18:24:38','2022-02-04 19:23:45','13_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-02-04 19:24:38','SYNCED','0ed2aa3b-9a59-495c-9032-f6eb5757beb8',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.5 Occlusion 3\",\"modelMatrix\":\"-0.996857,-0.0768567,0.0192233,0,0.0792243,-0.967066,0.241882,0,1.71456e-9,0.242644,0.970115,0,23.7843,9.22152,-23.0024,1\",\"referenceScanID\":\"1.13.1.1.5\",\"title\":\"Mandibule 1.13.1.1.5 Occlusion 3\"}'),(1001,'0edbc492-cf54-4982-b5d4-eeb2bfb0a808','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/ca43bf7b-f931-42fc-bb75-05929e4b6578/session_d9740504-a9ca-472a-83f2-a309fa225a98/occlusion_d663165c-f330-4c61-8d1f-14869b6d5edd/scan_3de249d1-1631-4fd5-be9c-dd46b685c6c8/59_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_ca43bf7b-f931-42fc-bb75-05929e4b6578_ACT_d9740504-a9ca-472a-83f2-a309fa225a98_SESS_d663165c-f330-4c61-8d1f-14869b6d5edd_LESC_3de249d1-1631-4fd5-be9c-dd46b685c6c8_ZIP_','2023-03-10 15:13:02','2023-03-10 16:12:49','59_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2023-03-10 16:13:02','SYNCED','0edbc492-cf54-4982-b5d4-eeb2bfb0a808',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.59.1.1.2\",\"modelMatrix\":\"-0.863909,-0.00545388,0.503212,0,0.160179,-0.938896,0.274882,0,0.47789,0.345422,0.819581,0,11.8599,-11.2793,-25.6625,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'0f60baf0-d8b7-48e1-8898-d089ef9825d7','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/scan_ebc093ba-6f58-45ce-a427-c955985391bd/54_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_LESC_ebc093ba-6f58-45ce-a427-c955985391bd_ZIP_','2022-12-13 09:40:52','2022-12-13 10:40:46','54_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-12-13 10:40:52','SYNCED','0f60baf0-d8b7-48e1-8898-d089ef9825d7',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.54.1.1.3\",\"modelMatrix\":\"-0.936359,0.0177614,0.343389,0,0.0558495,-0.962865,0.263705,0,0.347433,0.270458,0.901444,0,10.1268,-6.63915,-22.7359,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'0f635b24-e282-4728-b2bd-09b18b20f4b4','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_19ce66b5-7943-4a9e-82cd-f21481da98cc/54_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_19ce66b5-7943-4a9e-82cd-f21481da98cc_BOPLY__ZIP_','2023-03-15 10:41:24','2023-03-15 11:40:15','54_w1_o1_mandibule_occlusion_occ_file_0.zip','2023-03-15 11:41:24','SYNCED','0f635b24-e282-4728-b2bd-09b18b20f4b4',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.54.1.1.6 Occlusion 2\",\"modelMatrix\":\"-0.999599,0.0258183,-0.0116515,0,-0.0283256,-0.911116,0.411175,0,-3.36598e-10,0.41134,0.911482,0,17.4173,6.0967,-21.0427,1\",\"referenceScanID\":\"1.54.1.1.6\",\"title\":\"Mandibule 1.54.1.1.6 Occlusion 2\"}'),(1001,'0f6e5816-9908-4996-af79-cabf91fcb4f3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/207d6dbc-c19b-4726-a9b3-16235ae554cc/session_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35/occlusion_dc5762a3-c453-4166-8c86-82d23ac9f8a6/scan_5139ec2e-4608-4b67-b0d1-bc4dc3498038/27_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_207d6dbc-c19b-4726-a9b3-16235ae554cc_ACT_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35_SESS_dc5762a3-c453-4166-8c86-82d23ac9f8a6_BOSC_5139ec2e-4608-4b67-b0d1-bc4dc3498038_SNAPS_','2022-05-30 11:02:22','2022-05-30 13:02:13','27_w1_o1_mandibule_snapshot_0.png','2022-05-30 13:02:22','SYNCED','0f6e5816-9908-4996-af79-cabf91fcb4f3',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.27.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'0fb9b2b5-52e1-425c-9211-c9f88b598a07','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/9e399d73-4d2e-4bb8-af48-a4e597811faa/session_b1cf14ce-00a9-48b6-8654-dadde26073f1/occlusion_1060c95f-48f4-4a37-9b82-03bfd8329730/computedocclusion_67e8fc2c-cca5-4b65-8153-f487421fc4e6/46_w1_o2_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_9e399d73-4d2e-4bb8-af48-a4e597811faa_ACT_b1cf14ce-00a9-48b6-8654-dadde26073f1_SESS_1060c95f-48f4-4a37-9b82-03bfd8329730_OCC_67e8fc2c-cca5-4b65-8153-f487421fc4e6_BOPLY__ZIP_','2023-01-20 14:42:59','2023-01-20 15:42:49','46_w1_o2_mandibule_occlusion_occ_file_0.zip','2023-01-20 15:42:59','SYNCED','0fb9b2b5-52e1-425c-9211-c9f88b598a07',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.46.1.2.1 Occlusion 2\",\"modelMatrix\":\"0.0332892,0.998141,-0.0510473,0,-0.999446,0.0332458,-0.00170027,0,1.03957e-10,0.0510756,0.998695,0,14.6086,-18.6661,-18.0979,1\",\"referenceScanID\":\"1.46.1.2.1\",\"title\":\"Mandibule 1.46.1.2.1 Occlusion 2\"}'),(1001,'0ff1b82e-f12c-4a7b-a24b-df36ab306f9a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/occlusion_a2220645-c79d-4dda-b6cc-772384a4106b/computedocclusion_cf412dab-1d83-4db0-ae1b-d2724d5be97d/38_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_OCC_cf412dab-1d83-4db0-ae1b-d2724d5be97d_BOMA__MATRX_','2022-07-12 11:04:31','2022-07-12 13:04:14','38_w1_o1_mandibule_matrix_occ_file_0.m','2022-07-12 13:04:31','SYNCED','0ff1b82e-f12c-4a7b-a24b-df36ab306f9a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.38.1.1.1 Occlusion 2\",\"referenceScanID\":\"1.38.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.38.1.1.1 Occlusion 2\"}'),(1001,'0ff208d3-7401-4404-859a-2ade4d5c04f3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/9e399d73-4d2e-4bb8-af48-a4e597811faa/session_b1cf14ce-00a9-48b6-8654-dadde26073f1/occlusion_3c4595e0-fbbb-4814-8851-1e014eb9a3b2/scan_b1dee2c4-60b1-47c3-83e3-10d67f02d4f2/46_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_9e399d73-4d2e-4bb8-af48-a4e597811faa_ACT_b1cf14ce-00a9-48b6-8654-dadde26073f1_SESS_3c4595e0-fbbb-4814-8851-1e014eb9a3b2_LESC_b1dee2c4-60b1-47c3-83e3-10d67f02d4f2_SNAPS_','2022-10-27 11:51:58','2022-10-27 13:51:51','46_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-10-27 13:51:58','SYNCED','0ff208d3-7401-4404-859a-2ade4d5c04f3',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.46.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'10411aa0-2d8f-4c2d-bb34-619517bed145','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/207d6dbc-c19b-4726-a9b3-16235ae554cc/session_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35/occlusion_dc5762a3-c453-4166-8c86-82d23ac9f8a6/scan_db144753-52d9-4c43-950b-25093a3aee5f/27_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_207d6dbc-c19b-4726-a9b3-16235ae554cc_ACT_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35_SESS_dc5762a3-c453-4166-8c86-82d23ac9f8a6_RISC_db144753-52d9-4c43-950b-25093a3aee5f_SNAPS_','2022-05-30 11:09:16','2022-05-30 13:09:07','27_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-05-30 13:09:16','SYNCED','10411aa0-2d8f-4c2d-bb34-619517bed145',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.27.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'1050fd18-33ef-4994-bb2b-d74c35a009b6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f4fc00ec-4af8-4a15-b427-f1c5aabf6260/session_498ae60a-23f0-44fc-9730-be499bfc4b46/occlusion_8f3d6c73-3468-45a5-85c7-93bba47ec9f7/computedocclusion_9c318e86-fa90-4cd9-8319-2503cde2b455/30_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_f4fc00ec-4af8-4a15-b427-f1c5aabf6260_ACT_498ae60a-23f0-44fc-9730-be499bfc4b46_SESS_8f3d6c73-3468-45a5-85c7-93bba47ec9f7_OCC_9c318e86-fa90-4cd9-8319-2503cde2b455_TOMA__MATRX_','2022-06-14 13:30:12','2022-06-14 15:29:56','30_w1_o1_maxillaire_matrix_occ_file_0.m','2022-06-14 15:30:12','SYNCED','1050fd18-33ef-4994-bb2b-d74c35a009b6',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.30.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.30.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.30.1.1.1 Occlusion 1\"}'),(1001,'10ae0671-57c9-4c70-b4bc-4d8748fa1b1b','','MATRX','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_OCC_d58ce31f-4b72-44ad-b0e0-3d5d7d789322_BOMA__MATRX_','2022-01-19 11:15:36','2022-01-19 12:06:18','',NULL,'CREATED','10ae0671-57c9-4c70-b4bc-4d8748fa1b1b',0,'2022-01-19 12:15:36','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.1.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.1.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.1.1.1.1 Occlusion 1\"}'),(1001,'10b7f922-a161-46d6-acb1-9b8427a0b3e5','','MATRX','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_812fdd67-c9dc-4e0c-806a-0524a386b296_BOMA__MATRX_','2022-02-07 17:55:14','2022-02-07 18:54:30','',NULL,'CREATED','10b7f922-a161-46d6-acb1-9b8427a0b3e5',0,'2022-02-07 18:55:14','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.17.1.1.1 Occlusion 5\",\"referenceScanID\":\"1.17.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.17.1.1.1 Occlusion 5\"}'),(1001,'10c08038-3e2c-431f-9a83-38c12641d5d6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/9efbbbe9-fd0a-44b1-988c-23571aad69fa/session_595a54fa-ae7d-4880-86a1-168b20242ecf/occlusion_b84a2165-e2d4-47e5-b110-a34bcaa24341/scan_d98bf27f-7cdb-4186-a0f0-31f79c31fd57/53_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_9efbbbe9-fd0a-44b1-988c-23571aad69fa_ACT_595a54fa-ae7d-4880-86a1-168b20242ecf_SESS_b84a2165-e2d4-47e5-b110-a34bcaa24341_RISC_d98bf27f-7cdb-4186-a0f0-31f79c31fd57_ZIP_','2022-12-02 14:16:53','2022-12-02 15:14:02','53_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-12-02 15:16:53','SYNCED','10c08038-3e2c-431f-9a83-38c12641d5d6',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.53.1.1.1\",\"modelMatrix\":\"0.967668,-0.171406,0.205001,0,0.126133,0.981,0.128819,0,-0.219499,-0.0934151,0.970249,0,-21.1225,11.8911,-25.4122,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'10d18c2a-96a4-4c73-984a-f7b73cfa9104','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/57c4096f-98dd-49c8-bea5-a5b109ad3fd0/session_4f62e395-5623-4d5b-869c-1b2fc4d22b00/occlusion_1ac20dc7-b36b-4786-a05f-37091554dc5c/scan_1808e07b-25f9-4fb8-a923-34263a3c0386/31_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_57c4096f-98dd-49c8-bea5-a5b109ad3fd0_ACT_4f62e395-5623-4d5b-869c-1b2fc4d22b00_SESS_1ac20dc7-b36b-4786-a05f-37091554dc5c_RISC_1808e07b-25f9-4fb8-a923-34263a3c0386_ZIP_','2022-06-16 11:03:37','2022-06-16 13:03:30','31_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-06-16 13:03:37','SYNCED','10d18c2a-96a4-4c73-984a-f7b73cfa9104',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.31.1.1.1\",\"modelMatrix\":\"0.993132,-0.00842034,0.116144,0,0.029398,0.983845,-0.174498,0,-0.11325,0.178838,0.977786,0,3.7926,-6.7524,-15.2927,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'11474084-e02d-4d01-b0c2-4dcae6ab6ef3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/8fc74d9e-a5a0-46bf-be3f-500548a130ad/session_5368829e-7dec-4775-a487-a1019f9604f4/occlusion_bb63a653-1b34-4d80-a4bf-7fda5c9b0360/scan_e3fea328-cb79-4ad5-a652-3eebe9ee3e12/14_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_8fc74d9e-a5a0-46bf-be3f-500548a130ad_ACT_5368829e-7dec-4775-a487-a1019f9604f4_SESS_bb63a653-1b34-4d80-a4bf-7fda5c9b0360_TOSC_e3fea328-cb79-4ad5-a652-3eebe9ee3e12_SNAPS_','2022-02-01 10:46:25','2022-02-01 11:41:44','14_w1_o1_maxillaire_snapshot_0.png','2022-02-01 11:46:25','SYNCED','11474084-e02d-4d01-b0c2-4dcae6ab6ef3',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.14.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'1147b9ad-8062-49b0-abb8-e21503c142a6','','MATRX','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_65f9077d-c859-4b2c-9d4d-692d723315a5_TOMA__MATRX_','2022-05-13 12:07:44','2022-05-13 14:07:00','','2022-05-13 14:07:44','SYNCED','1147b9ad-8062-49b0-abb8-e21503c142a6',0,'2022-05-13 14:07:44','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.23.1.1.1 Occlusion 4\",\"referenceScanID\":\"1.23.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.23.1.1.1 Occlusion 4\"}'),(1001,'11dc07f6-a7e5-45da-8192-128345b80de3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_b28164eb-0070-4968-83be-bfabe1a0c839/13_w1_o1_mandibule_scan_file_6.zip','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_b28164eb-0070-4968-83be-bfabe1a0c839_ZIP_','2022-02-04 17:57:42','2022-02-04 17:08:27','13_w1_o1_mandibule_scan_file_6.zip','2022-02-04 18:57:42','SYNCED','d8a3bf39-16d1-435f-bafa-6c625f77d811',6,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.5\",\"modelMatrix\":\"-0.999849,-0.0166313,0.00499618,0,0.0173655,-0.957574,0.287663,0,1.82324e-10,0.287707,0.957719,0,26.6518,7.14728,-23.0855,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'11e47ef6-f2ae-407d-b403-db46278386db','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/4fa1a134-d246-43d7-aa8c-b42e24b62b49/session_6aedf6fd-46d7-4259-88ba-5cf074ad5913/occlusion_47192ebb-25b6-4c9e-a09f-8ed295e60a87/computedocclusion_d5964fd1-cca9-4595-8400-d624697bd9e7/60_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_4fa1a134-d246-43d7-aa8c-b42e24b62b49_ACT_6aedf6fd-46d7-4259-88ba-5cf074ad5913_SESS_47192ebb-25b6-4c9e-a09f-8ed295e60a87_OCC_d5964fd1-cca9-4595-8400-d624697bd9e7_TOPLY__ZIP_','2023-03-07 18:12:19','2023-03-07 19:11:43','60_w1_o1_maxillaire_occlusion_occ_file_0.zip','2023-03-07 19:12:19','SYNCED','11e47ef6-f2ae-407d-b403-db46278386db',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.60.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.864717,0.477113,-0.156931,0,-0.502259,0.821424,-0.270182,0,1.00298e-09,0.312451,0.949934,0,-7.98216,-12.8874,-17.6266,1\",\"referenceScanID\":\"1.60.1.1.1\",\"title\":\"Maxillaire 1.60.1.1.1 Occlusion 1\"}'),(1001,'1233a0e0-8ac8-4dee-99db-60e06298d54e','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_ce625ba7-4218-40af-b344-df718da13f83/54_w1_o1_maxillaire_matrix_occ_file_5.m','MATRX','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_ce625ba7-4218-40af-b344-df718da13f83_TOMA__MATRX_','2023-03-15 10:35:05','2023-03-15 11:32:25','54_w1_o1_maxillaire_matrix_occ_file_5.m','2023-03-15 11:35:05','SYNCED','ccf7be44-96c0-48d2-80d6-833cb64e29bc',5,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.54.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.54.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.54.1.1.1 Occlusion 1\"}'),(1001,'1235c321-c4b0-4dda-93af-af7b0a1e20f9','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/9e399d73-4d2e-4bb8-af48-a4e597811faa/session_b1cf14ce-00a9-48b6-8654-dadde26073f1/occlusion_3c4595e0-fbbb-4814-8851-1e014eb9a3b2/scan_f26fe3ea-6f4e-4010-a7f6-4757c6679e52/46_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_9e399d73-4d2e-4bb8-af48-a4e597811faa_ACT_b1cf14ce-00a9-48b6-8654-dadde26073f1_SESS_3c4595e0-fbbb-4814-8851-1e014eb9a3b2_BOSC_f26fe3ea-6f4e-4010-a7f6-4757c6679e52_SNAPS_','2022-10-27 11:45:53','2022-10-27 13:44:12','46_w1_o1_mandibule_snapshot_0.png','2022-10-27 13:45:53','SYNCED','1235c321-c4b0-4dda-93af-af7b0a1e20f9',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.46.1.1.5\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'12baab0a-d356-422e-be17-302240a9b611','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a20364ca-68f6-43af-9d85-5203eb8e7fd3/session_4fbadc34-458e-4383-9cea-ff5422d69287/occlusion_56872db7-25ba-4ec4-a526-b4254011197f/scan_5f4e1975-6e1f-4ec2-98fd-cbe91cc2a66f/49_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_a20364ca-68f6-43af-9d85-5203eb8e7fd3_ACT_4fbadc34-458e-4383-9cea-ff5422d69287_SESS_56872db7-25ba-4ec4-a526-b4254011197f_BOSC_5f4e1975-6e1f-4ec2-98fd-cbe91cc2a66f_SNAPS_','2022-10-28 10:19:20','2022-10-28 12:19:07','49_w1_o1_mandibule_snapshot_0.png','2022-10-28 12:19:20','SYNCED','12baab0a-d356-422e-be17-302240a9b611',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.49.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'12e39583-f42e-4162-a7f2-f42b8732bef6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/scan_36a05dde-4390-4db1-9df5-ea42cd16ed7d/1_w1_o1_mordu_anterieur_scan_file_0.zip','ZIP','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_FRSC_36a05dde-4390-4db1-9df5-ea42cd16ed7d_ZIP_','2022-01-19 12:59:27','2022-01-19 12:11:01','1_w1_o1_mordu_anterieur_scan_file_0.zip','2022-01-19 13:59:27','SYNCED','12e39583-f42e-4162-a7f2-f42b8732bef6',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.1.1.1.1\",\"modelMatrix\":\"-0.283735,-0.96941,-0.010519,0,0.958521,-0.249899,-0.0306912,0,0.0509487,0.0174887,1.00037,0,-11.9297,20.5189,-27.6561,1\",\"title\":\"Mordu anterieur ZIP\"}'),(1001,'1307b63c-d68c-40b7-a3ff-4fc477f139dc','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/computedocclusion_7c70edbe-5cb4-4244-8baf-7caf2bd7d86b/12_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_OCC_7c70edbe-5cb4-4244-8baf-7caf2bd7d86b_SNAPO__SNAPS_','2022-02-04 17:59:24','2022-02-04 18:58:48','12_w1_o1_snapshot_occ_file_0.png','2022-02-04 18:59:24','SYNCED','1307b63c-d68c-40b7-a3ff-4fc477f139dc',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'130d086f-1d1d-481c-b56c-8a9bf2922153','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3cc1b522-8e7d-4196-87a1-a8c234f0a399/session_ef503949-33e8-4db6-bbfa-456bd8b70b73/occlusion_e8e2758f-faa4-4db7-93df-e94ddfbd8284/scan_5fef43a3-69e9-4c2c-be04-0f92eb1f6b80/51_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_3cc1b522-8e7d-4196-87a1-a8c234f0a399_ACT_ef503949-33e8-4db6-bbfa-456bd8b70b73_SESS_e8e2758f-faa4-4db7-93df-e94ddfbd8284_RISC_5fef43a3-69e9-4c2c-be04-0f92eb1f6b80_SNAPS_','2022-11-28 17:01:41','2022-11-28 18:01:34','51_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-11-28 18:01:41','SYNCED','130d086f-1d1d-481c-b56c-8a9bf2922153',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.51.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'13274aa9-059b-4fbd-be76-c9773cde9e63','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/69640c87-271c-4a44-a6fa-67b01654cc27/session_5f9199b0-eb37-4ed3-8d1a-6c38505d4913/occlusion_991beec3-fe9e-4c98-a3d4-c98e4a4c2471/scan_5f9e4be9-4eec-45c8-937d-583b1a5e8642/39_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_BOSC_5f9e4be9-4eec-45c8-937d-583b1a5e8642_SNAPS_','2022-09-09 16:15:03','2022-09-09 18:14:02','39_w1_o1_mandibule_snapshot_0.png','2022-09-09 18:15:03','SYNCED','13274aa9-059b-4fbd-be76-c9773cde9e63',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.39.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'135e8c27-bf0a-4d0f-b495-291e99638543','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/occlusion_e08bbeeb-a30b-428c-bd4a-40198f792219/scan_ef1d20c7-5f61-4c35-8f0f-d85507cab786/25_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_SESS_e08bbeeb-a30b-428c-bd4a-40198f792219_BOSC_ef1d20c7-5f61-4c35-8f0f-d85507cab786_SNAPS_','2022-05-17 16:11:04','2022-05-17 18:10:54','25_w1_o1_mandibule_snapshot_0.png','2022-05-17 18:11:04','SYNCED','135e8c27-bf0a-4d0f-b495-291e99638543',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.25.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'1365702e-32f4-4824-8026-76aab6d4734e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/9e399d73-4d2e-4bb8-af48-a4e597811faa/session_b1cf14ce-00a9-48b6-8654-dadde26073f1/occlusion_3c4595e0-fbbb-4814-8851-1e014eb9a3b2/computedocclusion_69c0f244-5ccf-4ce5-aa31-27a50e7c92a0/46_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_9e399d73-4d2e-4bb8-af48-a4e597811faa_ACT_b1cf14ce-00a9-48b6-8654-dadde26073f1_SESS_3c4595e0-fbbb-4814-8851-1e014eb9a3b2_OCC_69c0f244-5ccf-4ce5-aa31-27a50e7c92a0_SNAPO__SNAPS_','2022-10-27 17:25:22','2022-10-27 19:24:54','46_w1_o1_snapshot_occ_file_0.png','2022-10-27 19:25:22','SYNCED','1365702e-32f4-4824-8026-76aab6d4734e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'139a98b6-3c62-4c98-945a-aa912110ca13','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/1a8329eb-7dbc-4bfd-b669-6d92e13fec0c/session_11fb4259-c305-4a08-b750-536f769f44b0/occlusion_129468ab-1f43-4ba1-8939-49286128bf4d/scan_db9fa61f-1e5c-4cd6-99aa-28ce9533d305/47_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_1a8329eb-7dbc-4bfd-b669-6d92e13fec0c_ACT_11fb4259-c305-4a08-b750-536f769f44b0_SESS_129468ab-1f43-4ba1-8939-49286128bf4d_TOSC_db9fa61f-1e5c-4cd6-99aa-28ce9533d305_ZIP_','2022-10-21 16:06:58','2022-10-21 18:06:50','47_w1_o1_maxillaire_scan_file_0.zip','2022-10-21 18:06:58','SYNCED','139a98b6-3c62-4c98-945a-aa912110ca13',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.47.1.1.1\",\"modelMatrix\":\"0.447873,0.884973,-0.127409,0,-0.894097,0.443302,-0.0638219,0,7.75415e-10,0.1425,0.989795,0,-12.7197,-19.4979,-18.0681,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'13ce10ed-8276-4985-8d10-e17c4e977ae7','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_ce625ba7-4218-40af-b344-df718da13f83/54_w1_o1_mandibule_matrix_occ_file_7.m','MATRX','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_ce625ba7-4218-40af-b344-df718da13f83_BOMA__MATRX_','2023-03-15 10:35:05','2023-03-15 11:32:28','54_w1_o1_mandibule_matrix_occ_file_7.m','2023-03-15 11:35:05','SYNCED','45775437-46ca-4831-b788-61b2ad12ff31',7,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.54.1.1.4 Occlusion 1\",\"referenceScanID\":\"1.54.1.1.4\",\"title\":\"Matrice Transfo. Mandibule 1.54.1.1.4 Occlusion 1\"}'),(1001,'13d7e3e3-0c0d-43d7-9b8e-5a2bd67c455c','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/4fa1a134-d246-43d7-aa8c-b42e24b62b49/session_6aedf6fd-46d7-4259-88ba-5cf074ad5913/occlusion_47192ebb-25b6-4c9e-a09f-8ed295e60a87/scan_283f28e2-92dd-426a-bc9e-a4fe6fdb180c/60_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_4fa1a134-d246-43d7-aa8c-b42e24b62b49_ACT_6aedf6fd-46d7-4259-88ba-5cf074ad5913_SESS_47192ebb-25b6-4c9e-a09f-8ed295e60a87_TOSC_283f28e2-92dd-426a-bc9e-a4fe6fdb180c_ZIP_','2023-03-07 18:00:10','2023-03-07 18:59:55','60_w1_o1_maxillaire_scan_file_0.zip','2023-03-07 19:00:10','SYNCED','13d7e3e3-0c0d-43d7-9b8e-5a2bd67c455c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.60.1.1.1\",\"modelMatrix\":\"0.79931,0.579674,-0.158374,0,-0.600919,0.77105,-0.21066,0,8.01146e-09,0.263552,0.964645,0,-7.37492,-13.1349,-18.0132,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'1427d616-5653-4d37-a57b-c647c2ad237c','','MATRX','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_OCC_87edc123-163f-46ce-be5c-45f2ff80b857_TOMA__MATRX_','2022-05-12 12:27:27','2022-05-12 14:26:51','','2022-05-12 14:27:27','SYNCED','1427d616-5653-4d37-a57b-c647c2ad237c',0,'2022-05-12 14:27:27','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.18.1.1.2 Occlusion 3\",\"referenceScanID\":\"1.18.1.1.2\",\"title\":\"Matrice Transfo. Maxillaire 1.18.1.1.2 Occlusion 3\"}'),(1001,'1485361c-1943-4401-8ed1-23059245eae1','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/1c189ddc-0ee7-45e7-9d80-585dac08374a/session_01bd0635-6ec6-42cb-8561-8638bded352c/occlusion_2aa712ca-8b46-4a50-a03e-1c6a6a0c40fc/computedocclusion_727485e0-8637-4024-83d8-95544991f73f/29_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_1c189ddc-0ee7-45e7-9d80-585dac08374a_ACT_01bd0635-6ec6-42cb-8561-8638bded352c_SESS_2aa712ca-8b46-4a50-a03e-1c6a6a0c40fc_OCC_727485e0-8637-4024-83d8-95544991f73f_TOMA__MATRX_','2022-06-03 14:07:17','2022-06-03 16:07:00','29_w1_o1_maxillaire_matrix_occ_file_0.m','2022-06-03 16:07:17','SYNCED','1485361c-1943-4401-8ed1-23059245eae1',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.29.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.29.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.29.1.1.1 Occlusion 1\"}'),(1001,'14f6b226-0756-4917-acea-0e1df65468a2','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_ce625ba7-4218-40af-b344-df718da13f83/54_w1_o1_mandibule_occlusion_occ_file_2.zip','ZIP','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_ce625ba7-4218-40af-b344-df718da13f83_BOPLY__ZIP_','2023-03-15 10:16:25','2023-03-15 11:15:19','54_w1_o1_mandibule_occlusion_occ_file_2.zip','2023-03-15 11:16:25','SYNCED','d1adede1-c3da-47da-a47c-075f5a6fe836',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.54.1.1.4 Occlusion 1\",\"modelMatrix\":\"-0.999599,0.0258183,-0.0116515,0,-0.0283256,-0.911116,0.411175,0,-3.36598e-10,0.41134,0.911482,0,17.4173,6.0967,-21.0427,1\",\"referenceScanID\":\"1.54.1.1.4\",\"title\":\"Mandibule 1.54.1.1.4 Occlusion 1\"}'),(1001,'1534b13d-c7b3-496e-9c8e-5f6fa0e172a0','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_aa38e68a-4c1f-4e58-a176-2a4d533c35a0/24_w1_o1_mordu_posterieur_gauche_scan_file_1.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_LESC_aa38e68a-4c1f-4e58-a176-2a4d533c35a0_ZIP_','2022-05-13 16:15:40','2022-05-13 18:15:33','24_w1_o1_mordu_posterieur_gauche_scan_file_1.zip','2022-05-13 18:15:40','SYNCED','cf34344a-9be8-4726-893c-bb841db45a19',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.24.1.1.2\",\"modelMatrix\":\"0.792987,0.149859,-0.592819,0,-0.322886,0.925453,-0.206041,0,0.51664,0.348069,0.77858,0,-5.39761,-12.4459,-28.9289,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'1560fe3c-2fde-4b99-b398-f1c254efa26c','','ZIP','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_65f9077d-c859-4b2c-9d4d-692d723315a5_TOPLY__ZIP_','2022-05-13 12:07:45','2022-05-13 14:07:00','','2022-05-13 14:07:45','SYNCED','1560fe3c-2fde-4b99-b398-f1c254efa26c',0,'2022-05-13 14:07:45','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.23.1.1.1 Occlusion 4\",\"modelMatrix\":\"-0.996412,0.0371381,-0.0760535,0,-0.0846367,-0.43722,0.895363,0,9.59179e-10,0.898588,0.438794,0,-5.67604,-22.9357,-12.9416,1\",\"referenceScanID\":\"1.23.1.1.1\",\"title\":\"Maxillaire 1.23.1.1.1 Occlusion 4\"}'),(1001,'158c2a75-1b0f-417a-8ed0-a7fb6ac2a492','','SNAPS','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_7d8decb1-23db-4824-940f-8d8822d88813_SNAPO__SNAPS_','2022-02-08 08:48:58','2022-02-07 18:48:45','','2022-02-08 09:48:58','SYNCED','158c2a75-1b0f-417a-8ed0-a7fb6ac2a492',0,'2022-02-08 09:48:58','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'15a6f8e8-d619-49b9-ac67-6a80eb3f2f9f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/order_d9158af5-bd4d-41e7-8357-3f09c9b95671/25_w1_autre_prost_file_15a6f8e8-d619-49b9-ac67-6a80eb3f2f9f_0.pdf','PDF','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_PROST_d9158af5-bd4d-41e7-8357-3f09c9b95671_PDF_','2022-05-18 14:11:49','2022-05-18 16:11:48','25_w1_autre_prost_file_15a6f8e8-d619-49b9-ac67-6a80eb3f2f9f_0.pdf','2022-05-18 16:11:49','SYNCED','15a6f8e8-d619-49b9-ac67-6a80eb3f2f9f',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.25.1.1 AUTRE FICHE DE PROTHESE\",\"title\":\"Autre PDF\"}'),(1001,'16018492-cc0a-4455-8ff2-2df14caec1c1','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/372000f2-2471-4a57-9b18-224d0788041f/session_5dd64d24-8e33-45bd-a282-c148c185c338/order_75fc4e22-f3cf-4225-baef-84c335c9584f/57_w1_autre_prost_file_16018492-cc0a-4455-8ff2-2df14caec1c1_0.pdf','PDF','PATIENT_372000f2-2471-4a57-9b18-224d0788041f_ACT_5dd64d24-8e33-45bd-a282-c148c185c338_PROST_75fc4e22-f3cf-4225-baef-84c335c9584f_PDF_','2023-02-17 17:52:23','2023-02-17 18:52:22','57_w1_autre_prost_file_16018492-cc0a-4455-8ff2-2df14caec1c1_0.pdf','2023-02-17 18:52:23','SYNCED','16018492-cc0a-4455-8ff2-2df14caec1c1',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.57.1.1 AUTRE FICHE DE PROTHESE\",\"title\":\"Autre PDF\"}'),(1001,'16aca5f6-a7b2-4fba-8fb4-5317db833f5f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_731ce686-8c03-4019-bc8e-040c31652c88/4_w1_o2_mandibule_scan_file_0.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_BOSC_731ce686-8c03-4019-bc8e-040c31652c88_ZIP_','2022-03-08 12:00:04','2022-03-08 12:59:57','4_w1_o2_mandibule_scan_file_0.zip','2022-03-08 13:00:04','SYNCED','16aca5f6-a7b2-4fba-8fb4-5317db833f5f',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.2.4\",\"modelMatrix\":\"0.246751,0.968429,-0.0354996,0,-0.969079,0.246585,-0.00903904,0,3.89658e-10,0.0366323,0.999329,0,0.572804,7.07408,-21.9357,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'16bbc6bf-911d-4d19-a2a7-d67f58277348','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_71fd8305-087d-4c31-82c4-b83df7b3cc9a/4_w1_o2_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_RISC_71fd8305-087d-4c31-82c4-b83df7b3cc9a_SNAPS_','2022-02-15 12:34:19','2022-02-15 13:34:12','4_w1_o2_mordu_posterieur_droit_snapshot_0.png','2022-02-15 13:34:19','SYNCED','16bbc6bf-911d-4d19-a2a7-d67f58277348',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.4.1.2.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'171da663-6218-41e8-86cd-4cd60c1d6cd8','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/9efbbbe9-fd0a-44b1-988c-23571aad69fa/session_595a54fa-ae7d-4880-86a1-168b20242ecf/order_5ba72926-1c3d-4462-bcce-7755eea8a117/53_w1_autre_prost_file_171da663-6218-41e8-86cd-4cd60c1d6cd8_0.pdf','PDF','PATIENT_9efbbbe9-fd0a-44b1-988c-23571aad69fa_ACT_595a54fa-ae7d-4880-86a1-168b20242ecf_PROST_5ba72926-1c3d-4462-bcce-7755eea8a117_PDF_','2022-12-07 14:35:15','2022-12-07 15:35:13','53_w1_autre_prost_file_171da663-6218-41e8-86cd-4cd60c1d6cd8_0.pdf','2022-12-07 15:35:15','SYNCED','171da663-6218-41e8-86cd-4cd60c1d6cd8',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.53.1.1 AUTRE FICHE DE PROTHESE\",\"title\":\"Autre PDF\"}'),(1001,'174df459-b65b-4330-9f93-b725dfc602d1','','MATRX','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_9440baee-a8bf-406c-bc0a-f5e9596f197b_TOMA__MATRX_','2022-05-13 16:14:04','2022-05-13 18:13:11','','2022-05-13 18:14:04','SYNCED','174df459-b65b-4330-9f93-b725dfc602d1',0,'2022-05-13 18:14:04','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.24.1.1.2 Occlusion 3\",\"referenceScanID\":\"1.24.1.1.2\",\"title\":\"Matrice Transfo. Maxillaire 1.24.1.1.2 Occlusion 3\"}'),(1001,'1759d630-e2be-4ef5-8fe0-f2f6a8a10873','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/computedocclusion_8e4092a3-64a2-4464-addd-03b3c8ba2289/24_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_8e4092a3-64a2-4464-addd-03b3c8ba2289_SNAPO__SNAPS_','2022-05-13 16:21:26','2022-05-13 18:20:53','24_w1_o1_snapshot_occ_file_0.png','2022-05-13 18:21:26','SYNCED','1759d630-e2be-4ef5-8fe0-f2f6a8a10873',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'175aa819-aaa5-44a2-bc16-b58049070c3b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/computedocclusion_864c98a3-fcf7-466a-b999-13bd4dfb8c65/23_w1_o1_mlmeta_occ_file_to1002.bin','LIFIM','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_864c98a3-fcf7-466a-b999-13bd4dfb8c65_LIFIMO_LIFIM_','2022-05-25 10:46:45','2022-05-25 12:46:42','23_w1_o1_mlmeta_occ_file_to1002.bin','2022-05-25 12:46:45','SYNCED','175aa819-aaa5-44a2-bc16-b58049070c3b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.23.1.1.1 Occlusion 3 Ligne de finition 2\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"Maxillaire\",\"name\":\"Ligne de finition 2\",\"title\":\"Ligne finition metadata\",\"toothNumber\":1002}'),(1001,'17b7f3d2-9eaa-4daf-98f2-0e902832966d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_2a7068fc-0efa-496f-ade9-aba5b0650655/12_w1_o1_mandibule_snapshot_7.png','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_2a7068fc-0efa-496f-ade9-aba5b0650655_SNAPS_','2022-02-04 12:15:36','2022-02-04 13:14:57','12_w1_o1_mandibule_snapshot_7.png','2022-02-04 13:15:36','SYNCED','7636e0d7-f242-431c-90a5-a65399d83ecd',7,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.5\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'17fda618-cda1-4757-8ea4-c62a6ae8991c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_04d6e3f1-19ce-4851-a9d0-40419cea7542/scan_fef6f617-40e8-4052-8a2d-9af9e39ab22d/19_w1_o2_mandibule_snapshot_2.png','SNAPS','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_04d6e3f1-19ce-4851-a9d0-40419cea7542_BOSC_fef6f617-40e8-4052-8a2d-9af9e39ab22d_SNAPS_','2022-04-15 14:07:00','2022-04-15 16:06:47','19_w1_o2_mandibule_snapshot_2.png','2022-04-15 16:07:00','SYNCED','5a1c3667-dbf3-4de6-af8e-149a263ba435',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.2.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'184dbb4e-3a0e-49f0-b537-7c98d7ecf86d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/9e399d73-4d2e-4bb8-af48-a4e597811faa/session_b1cf14ce-00a9-48b6-8654-dadde26073f1/occlusion_3c4595e0-fbbb-4814-8851-1e014eb9a3b2/scan_f26fe3ea-6f4e-4010-a7f6-4757c6679e52/46_w1_o1_mandibule_scan_file_2.zip','ZIP','PATIENT_9e399d73-4d2e-4bb8-af48-a4e597811faa_ACT_b1cf14ce-00a9-48b6-8654-dadde26073f1_SESS_3c4595e0-fbbb-4814-8851-1e014eb9a3b2_BOSC_f26fe3ea-6f4e-4010-a7f6-4757c6679e52_ZIP_','2022-10-27 11:48:18','2022-10-27 13:48:13','46_w1_o1_mandibule_scan_file_2.zip','2022-10-27 13:48:18','SYNCED','e29d75a6-5a7a-4e53-b47a-4b7ba43164ba',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.46.1.1.5\",\"modelMatrix\":\"-0.739769,0.651616,-0.167743,0,-0.672861,-0.716412,0.184424,0,-9.61468e-10,0.249299,0.968427,0,-5.38889,-26.0403,-20.6172,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'189a792c-fafa-4b60-958f-637d69400a83','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_b28164eb-0070-4968-83be-bfabe1a0c839/13_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_b28164eb-0070-4968-83be-bfabe1a0c839_SNAPS_','2022-02-04 17:55:03','2022-02-04 16:57:48','13_w1_o1_mandibule_snapshot_0.png','2022-02-04 18:55:03','SYNCED','189a792c-fafa-4b60-958f-637d69400a83',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule SNAPSHOT\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'18c3af60-0e70-4145-8e6d-00bea7e76567','','ZIP','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_RISC_b434cfd5-6ef9-4523-92e9-9f68fc4af6be_ZIP_','2022-09-09 16:21:09','2022-09-09 18:15:03','','2022-09-09 18:21:09','SYNCED','18c3af60-0e70-4145-8e6d-00bea7e76567',0,'2022-09-09 18:21:09','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.39.1.1.1\",\"modelMatrix\":\"0.985198,0.107441,0.133561,0,-0.107614,0.993941,0.014647,0,-0.13347,-0.0238721,0.990949,0,4.2555,7.67257,-15.8185,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'1918f151-9602-438b-911f-8fa1ba5b7218','','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_OCC_e9a397c8-e329-4471-985b-0eb40ed458b0_TOPLY__ZIP_','2022-02-04 15:01:39','2022-02-04 14:50:30','','2022-02-04 16:01:39','SYNCED','1918f151-9602-438b-911f-8fa1ba5b7218',0,'2022-02-04 16:01:39','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.12.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.622652,0.772747,-0.123153,0,-0.782499,0.614892,-0.0979959,0,-5.00422e-9,0.157385,0.987537,0,-21.5256,-19.2669,-19.1349,1\",\"referenceScanID\":\"1.12.1.1.1\",\"title\":\"Maxillaire 1.12.1.1.1 Occlusion 1\"}'),(1001,'1927c87b-194f-4939-b2e1-0a49fcbd011f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_7048f93c-1091-4f02-bc64-b73347dfa962/24_w1_o1_mordu_posterieur_droit_snapshot_1.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_RISC_7048f93c-1091-4f02-bc64-b73347dfa962_SNAPS_','2022-06-13 15:02:10','2022-06-13 17:02:03','24_w1_o1_mordu_posterieur_droit_snapshot_1.png','2022-06-13 17:02:10','SYNCED','6ed13785-759e-4640-96b7-73753d0c8c51',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.24.1.1.3\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'196b0af5-8cf0-44bd-bad9-a4b7a53bd42b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/8fc74d9e-a5a0-46bf-be3f-500548a130ad/session_5368829e-7dec-4775-a487-a1019f9604f4/occlusion_bb63a653-1b34-4d80-a4bf-7fda5c9b0360/scan_812e813b-02e0-44c6-bb91-8e662cd9a614/14_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_8fc74d9e-a5a0-46bf-be3f-500548a130ad_ACT_5368829e-7dec-4775-a487-a1019f9604f4_SESS_bb63a653-1b34-4d80-a4bf-7fda5c9b0360_LESC_812e813b-02e0-44c6-bb91-8e662cd9a614_SNAPS_','2022-02-01 10:51:03','2022-02-01 11:50:54','14_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-02-01 11:51:03','SYNCED','196b0af5-8cf0-44bd-bad9-a4b7a53bd42b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.14.1.1.2\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'198065c3-4dda-432e-9e76-0641770f2cf5','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_77ec818f-d778-4945-9458-90665b5522ba/17_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_TOSC_77ec818f-d778-4945-9458-90665b5522ba_SNAPS_','2022-02-07 11:35:19','2022-02-07 12:26:05','17_w1_o1_maxillaire_snapshot_1.png','2022-02-07 12:35:19','SYNCED','e4232ec2-aa4d-453c-8af0-16f147580e79',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.17.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'19e8e3f1-4dc4-497e-8ebc-a5ddb5ed260d','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/09688939-f53f-4f00-8366-687b244de26d/session_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525/occlusion_9655a7e0-4673-41c9-90da-a48c008e2d62/computedocclusion_31e93f44-4fae-454e-8c7b-c76251c61d92/64_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_09688939-f53f-4f00-8366-687b244de26d_ACT_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525_SESS_9655a7e0-4673-41c9-90da-a48c008e2d62_OCC_31e93f44-4fae-454e-8c7b-c76251c61d92_SNAPO__SNAPS_','2023-03-30 12:19:49','2023-03-30 14:19:34','64_w1_o1_snapshot_occ_file_0.png','2023-03-30 14:19:49','SYNCED','19e8e3f1-4dc4-497e-8ebc-a5ddb5ed260d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'19ea170f-c063-4a37-972a-35885657c236','','MATRX','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_9440baee-a8bf-406c-bc0a-f5e9596f197b_BOMA__MATRX_','2022-05-13 16:14:03','2022-05-13 18:13:11','','2022-05-13 18:14:03','SYNCED','19ea170f-c063-4a37-972a-35885657c236',0,'2022-05-13 18:14:03','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.24.1.1.1 Occlusion 3\",\"referenceScanID\":\"1.24.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.24.1.1.1 Occlusion 3\"}'),(1001,'19efce12-e72c-47d3-a9df-2f948d922375','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_ce625ba7-4218-40af-b344-df718da13f83/54_w1_o1_snapshot_occ_file_8.png','SNAPS','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_ce625ba7-4218-40af-b344-df718da13f83_SNAPO__SNAPS_','2023-03-15 10:35:08','2023-03-15 11:32:30','54_w1_o1_snapshot_occ_file_8.png','2023-03-15 11:35:08','SYNCED','7646ffac-dba0-4ac0-b4a3-8547134e5318',8,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'1a0767db-326c-4cdc-96d6-37bbfc6c059c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/45ff7437-0691-4427-a7da-8250862e4b96/session_4ff9c682-c09d-42ff-8c29-aeb13e066ed2/occlusion_934673c1-a4b9-4508-ac1b-a03092a0693e/computedocclusion_161f60a4-d4f2-41f1-98ad-a8ccad84216c/9_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_45ff7437-0691-4427-a7da-8250862e4b96_ACT_4ff9c682-c09d-42ff-8c29-aeb13e066ed2_SESS_934673c1-a4b9-4508-ac1b-a03092a0693e_OCC_161f60a4-d4f2-41f1-98ad-a8ccad84216c_SNAPO__SNAPS_','2022-01-24 17:47:25','2022-01-24 18:46:00','9_w1_o1_snapshot_occ_file_0.png','2022-01-24 18:47:25','SYNCED','1a0767db-326c-4cdc-96d6-37bbfc6c059c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'1a099ce4-e506-42cd-880e-d56cf533b172','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/c8418992-7324-4a11-9437-bf2bb0fa802f/session_ff05cb1f-6c46-4287-9cdd-81bf817a9c78/occlusion_f6f084bb-a5f1-4f39-860f-1483132c8283/scan_9263fb3c-bf3a-443f-8c9b-4d12244b4612/11_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_c8418992-7324-4a11-9437-bf2bb0fa802f_ACT_ff05cb1f-6c46-4287-9cdd-81bf817a9c78_SESS_f6f084bb-a5f1-4f39-860f-1483132c8283_TOSC_9263fb3c-bf3a-443f-8c9b-4d12244b4612_ZIP_','2022-01-25 15:43:38','2022-01-25 16:42:41','11_w1_o1_maxillaire_scan_file_0.zip','2022-01-25 16:43:38','SYNCED','1a099ce4-e506-42cd-880e-d56cf533b172',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.11.1.1.1\",\"modelMatrix\":\"-0.665268,0.740224,-0.097398,0,-0.746605,-0.659583,0.0867872,0,6.12842e-9,0.130455,0.991454,0,7.84336,-27.4628,-19.7451,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'1a33cdc9-13ae-4967-b870-f6fd01e98f27','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_8cd7948c-ef59-4b88-a894-5b497d849e92/24_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_RISC_8cd7948c-ef59-4b88-a894-5b497d849e92_SNAPS_','2022-05-24 14:55:21','2022-05-24 16:55:13','24_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-05-24 16:55:21','SYNCED','1a33cdc9-13ae-4967-b870-f6fd01e98f27',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.24.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'1a697c44-46ac-43a0-82b9-a46dbc74a391','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/occlusion_a2220645-c79d-4dda-b6cc-772384a4106b/computedocclusion_8b14563e-0862-4cac-8045-e8aed2be886d/38_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_OCC_8b14563e-0862-4cac-8045-e8aed2be886d_TOPLY__ZIP_','2022-07-12 10:57:42','2022-07-12 12:57:24','38_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-07-12 12:57:42','SYNCED','1a697c44-46ac-43a0-82b9-a46dbc74a391',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.38.1.1.1 Occlusion 1\",\"modelMatrix\":\"-0.298707,0.922945,-0.242789,0,-0.954345,-0.288879,0.0759925,0,9.14042e-10,0.254404,0.967098,0,20.3691,-25.7421,-14.8867,1\",\"referenceScanID\":\"1.38.1.1.1\",\"title\":\"Maxillaire 1.38.1.1.1 Occlusion 1\"}'),(1001,'1aa1663d-b6c0-47cd-9157-0c17e591468c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/occlusion_e08bbeeb-a30b-428c-bd4a-40198f792219/computedocclusion_a503ab26-f707-4923-86b6-049c17f73533/25_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_SESS_e08bbeeb-a30b-428c-bd4a-40198f792219_OCC_a503ab26-f707-4923-86b6-049c17f73533_TOPLY__ZIP_','2022-05-17 16:40:45','2022-05-17 18:40:25','25_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-05-17 18:40:45','SYNCED','1aa1663d-b6c0-47cd-9157-0c17e591468c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.25.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.999921,-0.0124601,0.00173472,0,0.0125803,0.990369,-0.137881,0,5.51735e-11,0.137892,0.990447,0,12.823,6.75113,-24.6355,1\",\"referenceScanID\":\"1.25.1.1.1\",\"title\":\"Maxillaire 1.25.1.1.1 Occlusion 1\"}'),(1001,'1ab76985-608d-4f1d-ad18-01454909d344','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/9e399d73-4d2e-4bb8-af48-a4e597811faa/session_b1cf14ce-00a9-48b6-8654-dadde26073f1/occlusion_3c4595e0-fbbb-4814-8851-1e014eb9a3b2/scan_dde349dc-caa1-49dc-8205-ba84c97567bf/46_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_9e399d73-4d2e-4bb8-af48-a4e597811faa_ACT_b1cf14ce-00a9-48b6-8654-dadde26073f1_SESS_3c4595e0-fbbb-4814-8851-1e014eb9a3b2_TOSC_dde349dc-caa1-49dc-8205-ba84c97567bf_ZIP_','2022-11-24 13:33:31','2022-11-24 14:33:30','46_w1_o1_mandibule_scan_file_0.zip','2022-11-24 14:33:31','SYNCED','1ab76985-608d-4f1d-ad18-01454909d344',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.46.1.1.2\",\"modelMatrix\":\"-0.781388,0.613261,-0.115515,0,-0.624045,-0.767885,0.14464,0,3.896e-09,0.185107,0.982718,0,20.8068,-10.6268,-17.296,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'1adeef10-e657-429d-9941-9e8db25afe73','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/09688939-f53f-4f00-8366-687b244de26d/session_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525/occlusion_9655a7e0-4673-41c9-90da-a48c008e2d62/scan_8e48d6b3-b208-429e-bf9d-ca9d687d5008/64_w1_o1_mordu_posterieur_droit_scan_file_1.zip','ZIP','PATIENT_09688939-f53f-4f00-8366-687b244de26d_ACT_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525_SESS_9655a7e0-4673-41c9-90da-a48c008e2d62_RISC_8e48d6b3-b208-429e-bf9d-ca9d687d5008_ZIP_','2023-03-30 12:09:33','2023-03-30 14:09:25','64_w1_o1_mordu_posterieur_droit_scan_file_1.zip','2023-03-30 14:09:33','SYNCED','e1542843-d024-4ae9-b110-7906a5b22139',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.64.1.1.1\",\"modelMatrix\":\"0.966423,-0.140255,0.222136,0,0.164913,0.972222,-0.1433,0,-0.197443,0.188113,0.96449,0,-16.302,1.93176,-23.2504,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'1b1c80ec-bd70-4582-92be-8a778fef6d24','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/09688939-f53f-4f00-8366-687b244de26d/session_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525/occlusion_9655a7e0-4673-41c9-90da-a48c008e2d62/scan_9a0374bf-de8a-4ee1-9c7a-71fe30bbcb5e/64_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_09688939-f53f-4f00-8366-687b244de26d_ACT_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525_SESS_9655a7e0-4673-41c9-90da-a48c008e2d62_BOSC_9a0374bf-de8a-4ee1-9c7a-71fe30bbcb5e_SNAPS_','2023-03-30 11:57:22','2023-03-30 13:57:14','64_w1_o1_mandibule_snapshot_0.png','2023-03-30 13:57:22','SYNCED','1b1c80ec-bd70-4582-92be-8a778fef6d24',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.64.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'1b61bb56-dc55-455e-986f-bfe9aaa0de5a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3ed7a8e0-5b4d-4ecf-b4ae-f855b16c0f93/session_fb42cec6-0bb6-41e9-912d-0517ff8e0942/occlusion_fb214b2f-5e41-492d-85c4-d4a11a3947c5/computedocclusion_f6573412-d667-47a1-89b2-d0a46006380f/42_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_3ed7a8e0-5b4d-4ecf-b4ae-f855b16c0f93_ACT_fb42cec6-0bb6-41e9-912d-0517ff8e0942_SESS_fb214b2f-5e41-492d-85c4-d4a11a3947c5_OCC_f6573412-d667-47a1-89b2-d0a46006380f_TOPLY__ZIP_','2022-10-07 17:38:19','2022-10-07 19:37:42','42_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-10-07 19:38:19','SYNCED','1b61bb56-dc55-455e-986f-bfe9aaa0de5a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.42.1.1.1 Occlusion 5\",\"modelMatrix\":\"-0.20917,0.954234,-0.213743,0,-0.977879,-0.204112,0.0457199,0,-2.38677e-09,0.218578,0.97582,0,-7.51486,-31.7634,-17.5389,1\",\"referenceScanID\":\"1.42.1.1.1\",\"title\":\"Maxillaire 1.42.1.1.1 Occlusion 5\"}'),(1001,'1b9c8ae0-a860-49fe-a798-7ebbebcd8510','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7f47fd88-9ea0-4c08-9193-a54d4f158c7c/session_7873a396-419c-4215-83c7-fec9f2742ccf/occlusion_2e287bb0-e19a-414a-9177-23b335d286d9/scan_05d5d943-3268-4239-ac7d-5efbc2d2ab9b/16_w1_o2_maxillaire_scan_file_1.zip','ZIP','PATIENT_7f47fd88-9ea0-4c08-9193-a54d4f158c7c_ACT_7873a396-419c-4215-83c7-fec9f2742ccf_SESS_2e287bb0-e19a-414a-9177-23b335d286d9_TOSC_05d5d943-3268-4239-ac7d-5efbc2d2ab9b_ZIP_','2022-06-03 08:52:14','2022-06-03 10:52:05','16_w1_o2_maxillaire_scan_file_1.zip','2022-06-03 10:52:14','SYNCED','74b28d88-c271-4aef-ac3b-1c8d372ae615',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.16.1.2.1\",\"modelMatrix\":\"-0.655868,0.747425,-0.105795,0,-0.754875,-0.649395,0.091919,0,-1.02677e-10,0.140149,0.99013,0,13.4773,-13.0045,-20.4999,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'1bc4344e-c5ca-4ed5-b6d6-551607344b94','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_04abc032-a797-420b-8d5e-ee9528f5e291/12_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_FRSC_04abc032-a797-420b-8d5e-ee9528f5e291_SNAPS_','2022-02-04 12:19:29','2022-02-04 13:19:19','12_w1_o1_mordu_anterieur_snapshot_0.png','2022-02-04 13:19:29','SYNCED','1bc4344e-c5ca-4ed5-b6d6-551607344b94',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.12.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'1bfdf28b-74a5-4572-8ee8-9f2091668cf7','','MATRX','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_cb4cdc08-5d89-48dc-80a3-2e659c55f971_TOMA__MATRX_','2022-02-08 08:48:59','2022-02-07 18:52:17','','2022-02-08 09:48:59','SYNCED','1bfdf28b-74a5-4572-8ee8-9f2091668cf7',0,'2022-02-08 09:48:59','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.17.1.1.1 Occlusion 4\",\"referenceScanID\":\"1.17.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.17.1.1.1 Occlusion 4\"}'),(1001,'1c214d6e-a4e1-4115-b472-c4209df3992c','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/09688939-f53f-4f00-8366-687b244de26d/session_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525/order_63f4110b-42d8-49f6-b058-258bcc933b32/64_w1_autre_prost_file_1c214d6e-a4e1-4115-b472-c4209df3992c_0.pdf','PDF','PATIENT_09688939-f53f-4f00-8366-687b244de26d_ACT_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525_PROST_63f4110b-42d8-49f6-b058-258bcc933b32_PDF_','2023-03-30 18:03:08','2023-03-30 20:03:06','64_w1_autre_prost_file_1c214d6e-a4e1-4115-b472-c4209df3992c_0.pdf','2023-03-30 20:03:08','SYNCED','1c214d6e-a4e1-4115-b472-c4209df3992c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.64.1.1 AUTRE FICHE DE PROTHESE\",\"title\":\"Autre PDF\"}'),(1001,'1c6296d6-4a5b-4cfb-b3c5-73fe516033e7','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_16f04a07-72e8-4a39-9b55-3ae7405733af/24_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_TOSC_16f04a07-72e8-4a39-9b55-3ae7405733af_ZIP_','2022-06-13 14:42:43','2022-06-13 16:42:31','24_w1_o1_maxillaire_scan_file_1.zip','2022-06-13 16:42:43','SYNCED','d3ff533f-e540-46c8-8f68-b5341a94ad72',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.4\",\"modelMatrix\":\"0.56797,0.795218,-0.212224,0,-0.823049,0.548764,-0.146451,0,-1.57613e-08,0.25785,0.966185,0,-15.7017,-3.48081,-19.4449,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'1c676927-9bdf-4dde-88d2-e62e956f53e3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_e6c95ef7-636d-4c88-8d02-e2d9840573db/13_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_e6c95ef7-636d-4c88-8d02-e2d9840573db_SNAPS_','2022-01-28 17:11:15','2022-01-27 17:40:37','13_w1_o1_mandibule_snapshot_1.png','2022-01-28 18:11:15','SYNCED','ac0f8bbb-d9a6-428c-a397-1febe6de5982',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'1c7456f3-a02f-42dc-a4f0-35f09bbaa740','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_cb7d52e7-16ce-470b-9b62-b1f627e9badc/18_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_RISC_cb7d52e7-16ce-470b-9b62-b1f627e9badc_ZIP_','2022-03-07 14:33:35','2022-03-07 15:33:29','18_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-03-07 15:33:35','SYNCED','1c7456f3-a02f-42dc-a4f0-35f09bbaa740',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.18.1.1.2\",\"modelMatrix\":\"0.987719,0.0315531,0.160783,0,0.0010254,0.977441,-0.213889,0,-0.156434,0.208857,0.963571,0,3.95362,0.226955,-18.1408,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'1cb9b372-74dd-4ae5-ab0d-283626d588f0','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_2ffbfbca-f236-4802-be93-8eb43d523274/scan_eb904683-acc6-4e6d-8900-3982d403ba0f/4_w1_o1_mordu_anterieur_snapshot_1.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_2ffbfbca-f236-4802-be93-8eb43d523274_FRSC_eb904683-acc6-4e6d-8900-3982d403ba0f_SNAPS_','2022-01-19 19:13:34','2022-01-19 20:13:22','4_w1_o1_mordu_anterieur_snapshot_1.png','2022-01-19 20:13:34','SYNCED','416db3c9-b04a-404f-8271-79d9066b8d08',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.4.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'1cc7ae90-17d0-4892-b281-93a08c20fffa','','MATRX','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_1500b3eb-4b86-46c1-9c9f-7efbd0224ac8_TOMA__MATRX_','2022-05-25 08:56:38','2022-05-13 18:22:04','','2022-05-25 10:56:38','SYNCED','1cc7ae90-17d0-4892-b281-93a08c20fffa',0,'2022-05-25 10:56:38','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.24.1.1.2 Occlusion 4\",\"referenceScanID\":\"1.24.1.1.2\",\"title\":\"Matrice Transfo. Maxillaire 1.24.1.1.2 Occlusion 4\"}'),(1001,'1d033a05-b36d-48d3-a077-cba01c0ba281','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/computedocclusion_35af1bf5-285a-4bb1-a6db-fe9897defe51/23_w1_o1_mlmeta_occ_file_to1001.bin','LIFIM','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_35af1bf5-285a-4bb1-a6db-fe9897defe51_LIFIMO_LIFIM_','2022-05-25 10:45:11','2022-05-25 12:45:09','23_w1_o1_mlmeta_occ_file_to1001.bin','2022-05-25 12:45:11','SYNCED','1d033a05-b36d-48d3-a077-cba01c0ba281',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.23.1.1.1 Occlusion 4 Ligne de finition 1\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"Maxillaire\",\"name\":\"Ligne de finition 1\",\"title\":\"Ligne finition metadata\",\"toothNumber\":1001}'),(1001,'1d22f124-58fe-452c-bb7d-54d19e0ed5d4','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/69640c87-271c-4a44-a6fa-67b01654cc27/session_5f9199b0-eb37-4ed3-8d1a-6c38505d4913/occlusion_991beec3-fe9e-4c98-a3d4-c98e4a4c2471/computedocclusion_c7bccd1e-370e-4347-8296-1bcd4c30b631/39_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_OCC_c7bccd1e-370e-4347-8296-1bcd4c30b631_BOPLY__ZIP_','2022-09-10 09:46:17','2022-09-10 11:45:43','39_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-09-10 11:46:17','SYNCED','1d22f124-58fe-452c-bb7d-54d19e0ed5d4',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.39.1.1.1 Occlusion 10\",\"modelMatrix\":\"-0.977808,0.200729,-0.0599951,0,-0.209503,-0.936857,0.280013,0,3.36067e-09,0.286368,0.95812,0,23.2439,5.67049,-19.9331,1\",\"referenceScanID\":\"1.39.1.1.1\",\"title\":\"Mandibule 1.39.1.1.1 Occlusion 10\"}'),(1001,'1d255ba6-133d-4e2f-b133-667c46f08b4b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_8cd7948c-ef59-4b88-a894-5b497d849e92/24_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_RISC_8cd7948c-ef59-4b88-a894-5b497d849e92_ZIP_','2022-05-24 14:55:21','2022-05-24 16:55:14','24_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-05-24 16:55:21','SYNCED','1d255ba6-133d-4e2f-b133-667c46f08b4b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.24.1.1.1\",\"modelMatrix\":\"0.995776,-0.0533792,0.0847523,0,0.0415956,0.997888,-0.0407471,0,-0.0832184,0.0402666,0.995582,0,5.84452,-6.13542,-17.4079,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'1d77467f-1eb7-4fb2-8d86-69476c13ccff','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/scan_f2bad12a-451d-406d-98b0-e431a37951dd/19_w1_o1_mandibule_snapshot_2.png','SNAPS','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_BOSC_f2bad12a-451d-406d-98b0-e431a37951dd_SNAPS_','2022-03-08 10:48:39','2022-03-08 11:48:29','19_w1_o1_mandibule_snapshot_2.png','2022-03-08 11:48:39','SYNCED','8fb19261-9e70-4678-8a85-98e89dd98dcb',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.1.4\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'1e204833-d2dd-4476-a89b-bac41168472a','','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_BOSC_f8b316c9-3008-451e-bdae-0fb8163c2756_SNAPS_','2022-02-19 17:53:23','2022-02-18 16:58:19','','2022-02-19 18:53:23','SYNCED','1e204833-d2dd-4476-a89b-bac41168472a',0,'2022-02-19 18:53:23','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.4.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'1e2ab731-95d9-4ab4-b9e3-2a30e1ede882','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_04d6e3f1-19ce-4851-a9d0-40419cea7542/scan_9e43db2d-10a9-414e-ac07-6b7642412ce5/19_w1_o2_maxillaire_scan_file_1.zip','ZIP','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_04d6e3f1-19ce-4851-a9d0-40419cea7542_TOSC_9e43db2d-10a9-414e-ac07-6b7642412ce5_ZIP_','2022-04-15 11:41:49','2022-04-01 18:18:33','19_w1_o2_maxillaire_scan_file_1.zip','2022-04-15 13:41:49','SYNCED','bf1a3548-3c4b-44f2-98bd-9b8130cf0fb8',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.19.1.2.1\",\"modelMatrix\":\"0.233501,0.918982,-0.317724,0,-0.972357,0.220683,-0.076298,0,5.73627e-09,0.326757,0.945108,0,14.2402,-14.8737,-20.3712,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'1e34800f-6443-4433-a2fd-ac3d1de66258','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/452a5200-3e06-4b74-8949-6abc7f2dda8a/session_3e95d626-668f-45f7-98ad-be2cf9d7b90b/occlusion_bce8310f-eee9-4f0a-a6b7-d592dec66be5/computedocclusion_7a922eb8-5139-40fe-8402-fc7ff4204a1a/26_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_452a5200-3e06-4b74-8949-6abc7f2dda8a_ACT_3e95d626-668f-45f7-98ad-be2cf9d7b90b_SESS_bce8310f-eee9-4f0a-a6b7-d592dec66be5_OCC_7a922eb8-5139-40fe-8402-fc7ff4204a1a_BOPLY__ZIP_','2022-05-24 09:42:18','2022-05-24 11:42:09','26_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-05-24 11:42:18','SYNCED','1e34800f-6443-4433-a2fd-ac3d1de66258',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.26.1.1.2 Occlusion 1\",\"modelMatrix\":\"-0.440993,0.868318,-0.227045,0,-0.89751,-0.426649,0.111559,0,-1.10485e-08,0.252972,0.967474,0,8.55795,-16.8564,-17.5092,1\",\"referenceScanID\":\"1.26.1.1.2\",\"title\":\"Mandibule 1.26.1.1.2 Occlusion 1\"}'),(1001,'1e723f20-3875-49b6-b45e-d9be499a3768','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_f62659c6-4f30-430c-95e4-d14e40327192/13_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_FRSC_f62659c6-4f30-430c-95e4-d14e40327192_SNAPS_','2022-02-04 17:55:12','2022-02-04 17:27:11','13_w1_o1_mordu_anterieur_snapshot_0.png','2022-02-04 18:55:12','SYNCED','1e723f20-3875-49b6-b45e-d9be499a3768',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.13.1.1.2\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'1e88200b-6ed2-4ef3-a449-f66ac52fc40b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/occlusion_a2220645-c79d-4dda-b6cc-772384a4106b/scan_0136d883-d517-448a-82a3-bfcdd5f4c35c/38_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_TOSC_0136d883-d517-448a-82a3-bfcdd5f4c35c_ZIP_','2022-07-19 12:30:54','2022-07-19 14:30:45','38_w1_o1_maxillaire_scan_file_1.zip','2022-07-19 14:30:54','SYNCED','229065de-cf1c-4956-8237-67f43f93246b',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.38.1.1.1\",\"modelMatrix\":\"-0.298707,0.922945,-0.242789,0,-0.954345,-0.288879,0.0759925,0,9.14042e-10,0.254404,0.967098,0,20.3691,-25.7421,-14.8867,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'1ed03b1b-6b26-4ef7-b480-93870e62438f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_e6c95ef7-636d-4c88-8d02-e2d9840573db/13_w1_o1_mandibule_scan_file_2.zip','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_e6c95ef7-636d-4c88-8d02-e2d9840573db_ZIP_','2022-01-27 16:37:44','2022-01-27 17:37:15','13_w1_o1_mandibule_scan_file_2.zip','2022-01-27 17:37:44','SYNCED','bcef8d3e-9632-4976-8cda-4c6f3ac50e99',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.1\",\"modelMatrix\":\"-0.963479,0.243305,-0.111855,0,-0.267785,-0.8754,0.402451,0,1.23617e-9,0.417706,0.908582,0,32.4632,-3.53421,-16.2323,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'1ee80ca4-d94e-45b0-8e49-65d950ee4df9','','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_fa1c1f6f-5c0d-45ca-8646-2a1ca68f51b4_BOPLY__ZIP_','2022-05-16 17:51:10','2022-05-16 19:50:25','','2022-05-16 19:51:10','SYNCED','1ee80ca4-d94e-45b0-8e49-65d950ee4df9',0,'2022-05-16 19:51:10','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.24.1.1.1 Occlusion 6\",\"modelMatrix\":\"0.852703,-0.521011,0.0380208,0,0.522396,0.850441,-0.062061,0,3.49638e-10,0.0727815,0.997348,0,-11.3911,-12.8136,-21.1334,1\",\"referenceScanID\":\"1.24.1.1.1\",\"title\":\"Mandibule 1.24.1.1.1 Occlusion 6\"}'),(1001,'1ef50d07-0bdf-4786-9a09-f0d43d4157e4','','ZIP','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_c9079d19-8ffb-46f7-a51e-3a7a90ccae59_SESS_8ba0f3b1-408f-4a02-92a0-63f09123b68e_BOSC_3f14002f-c2c4-4c73-b111-290940b150eb_ZIP_','2022-01-28 17:15:43','2022-01-27 14:52:24','','2022-01-28 18:15:43','SYNCED','1ef50d07-0bdf-4786-9a09-f0d43d4157e4',0,'2022-01-28 18:15:43','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.10.1.1.4\",\"modelMatrix\":\"0.499842,0.862645,-0.0774669,0,-0.866117,0.497839,-0.0447067,0,1.10064e-9,0.0894417,0.995992,0,1.32298,-8.42824,-29.2225,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'1f2547b2-94d6-4ad3-8965-45ffd5789b90','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/order_be77a0f7-c81a-46c8-ba80-8ea4d3c3b1c8/4_w1_autre_prost_file_1f2547b2-94d6-4ad3-8965-45ffd5789b90_0.pdf','PDF','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_PROST_be77a0f7-c81a-46c8-ba80-8ea4d3c3b1c8_PDF_','2022-05-31 14:58:19','2022-05-31 16:58:18','4_w1_autre_prost_file_1f2547b2-94d6-4ad3-8965-45ffd5789b90_0.pdf','2022-05-31 16:58:19','SYNCED','1f2547b2-94d6-4ad3-8965-45ffd5789b90',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.4.1.5 AUTRE FICHE DE PROTHESE\",\"title\":\"Autre PDF\"}'),(1001,'1f6a5510-cff7-4ce9-975a-d7ad45db166d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/scan_f2bad12a-451d-406d-98b0-e431a37951dd/19_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_BOSC_f2bad12a-451d-406d-98b0-e431a37951dd_ZIP_','2022-03-08 10:43:45','2022-03-08 11:43:38','19_w1_o1_mandibule_scan_file_1.zip','2022-03-08 11:43:45','SYNCED','e3a545cc-fe2a-418f-9896-979b09c1f684',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.1.4\",\"modelMatrix\":\"-0.997126,0.0688557,-0.0316083,0,-0.075764,-0.906205,0.415996,0,-1.80164e-09,0.417195,0.908817,0,23.7521,-24.6217,-20.8001,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'1f7ddfe0-7f99-4153-b3c2-97663ca5b8ae','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/occlusion_e08bbeeb-a30b-428c-bd4a-40198f792219/scan_ef1d20c7-5f61-4c35-8f0f-d85507cab786/25_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_SESS_e08bbeeb-a30b-428c-bd4a-40198f792219_BOSC_ef1d20c7-5f61-4c35-8f0f-d85507cab786_ZIP_','2022-05-17 16:13:04','2022-05-17 18:12:54','25_w1_o1_mandibule_scan_file_1.zip','2022-05-17 18:13:04','SYNCED','69ad61a1-bbd5-4415-a55b-c7c378bdf30e',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.25.1.1.1\",\"modelMatrix\":\"0.706223,-0.70478,0.0673387,0,0.70799,0.703021,-0.0671707,0,-2.542e-09,0.0951126,0.995466,0,-2.01848,-3.90735,-21.641,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'1f8d4d2e-1df3-4232-9784-04f300109aab','','ZIP','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_LESC_ecfd300a-08c2-4c42-a0d5-5dbf17a8210e_ZIP_','2022-09-09 16:30:29','2022-09-09 18:16:24','','2022-09-09 18:30:29','SYNCED','1f8d4d2e-1df3-4232-9784-04f300109aab',0,'2022-09-09 18:30:29','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.39.1.1.1\",\"modelMatrix\":\"-0.957377,0.0514487,0.288511,0,-0.0471191,-0.998681,0.013968,0,0.285002,0.010975,0.957451,0,-24.7487,5.84229,-7.00493,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'1f9724a7-2075-47b0-8aee-e88fec576ca0','','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_BOSC_a1a9cef4-72fe-4dbe-928c-3831f98ecfbc_ZIP_','2022-02-19 17:53:23','2022-02-18 17:00:42','','2022-02-19 18:53:23','SYNCED','1f9724a7-2075-47b0-8aee-e88fec576ca0',0,'2022-02-19 18:53:23','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.4.4\",\"modelMatrix\":\"-0.484902,-0.858844,0.165097,0,0.874569,-0.476183,0.0915377,0,5.0731e-09,0.188776,0.98202,0,0.867766,-4.01351,-24.0032,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'1fc93c7d-617e-42e3-b407-18216c5a47ca','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/scan_1a0b9502-8df2-41a2-89eb-2def508b7462/22_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_RISC_1a0b9502-8df2-41a2-89eb-2def508b7462_ZIP_','2022-04-21 17:38:20','2022-04-21 19:38:19','22_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-04-21 19:38:20','SYNCED','1fc93c7d-617e-42e3-b407-18216c5a47ca',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.22.1.1.6\",\"modelMatrix\":\"-0.989729,0.00526289,-0.143837,0,-0.00941161,-1.00005,-0.00463951,0,-0.142672,0.0133764,0.989739,0,15.8973,1.46372,-15.7658,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'20010b5b-e8eb-499b-8bf9-25f8af288f05','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/c8418992-7324-4a11-9437-bf2bb0fa802f/session_ff05cb1f-6c46-4287-9cdd-81bf817a9c78/occlusion_f6f084bb-a5f1-4f39-860f-1483132c8283/scan_9263fb3c-bf3a-443f-8c9b-4d12244b4612/11_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_c8418992-7324-4a11-9437-bf2bb0fa802f_ACT_ff05cb1f-6c46-4287-9cdd-81bf817a9c78_SESS_f6f084bb-a5f1-4f39-860f-1483132c8283_TOSC_9263fb3c-bf3a-443f-8c9b-4d12244b4612_SNAPS_','2022-01-25 15:45:30','2022-01-25 16:42:39','11_w1_o1_maxillaire_snapshot_0.png','2022-01-25 16:45:30','SYNCED','20010b5b-e8eb-499b-8bf9-25f8af288f05',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.11.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'204b529d-94bd-48ef-b172-5317b14df862','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/32710234-804f-46f5-899d-eed636f8a906/session_64c1427a-b91d-4675-94df-f36bd40e9b0f/occlusion_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a/computedocclusion_84d73896-4c7a-4dc0-994a-b2a70e3d1cf2/33_w2_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_32710234-804f-46f5-899d-eed636f8a906_ACT_64c1427a-b91d-4675-94df-f36bd40e9b0f_SESS_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a_OCC_84d73896-4c7a-4dc0-994a-b2a70e3d1cf2_TOPLY__ZIP_','2022-06-28 09:07:13','2022-06-28 11:07:03','33_w2_o1_maxillaire_occlusion_occ_file_0.zip','2022-06-28 11:07:13','SYNCED','204b529d-94bd-48ef-b172-5317b14df862',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.33.2.1.1 Occlusion 1\",\"modelMatrix\":\"-0.712189,0.701711,-0.019724,0,-0.701988,-0.711908,0.0200107,0,1.61205e-10,0.0280974,0.999605,0,4.73611,1.67537,-20.9792,1\",\"referenceScanID\":\"1.33.2.1.1\",\"title\":\"Maxillaire 1.33.2.1.1 Occlusion 1\"}'),(1001,'204dc781-5a83-4f4b-930a-661b60965ae3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/scan_9937f6fe-f500-4cc5-acd7-39dadc5ac2e7/22_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_TOSC_9937f6fe-f500-4cc5-acd7-39dadc5ac2e7_SNAPS_','2022-04-21 11:00:57','2022-04-21 13:00:43','22_w1_o1_maxillaire_snapshot_0.png','2022-04-21 13:00:57','SYNCED','204dc781-5a83-4f4b-930a-661b60965ae3',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.22.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'207e5cb8-68ef-4605-9ab5-849eaf752db8','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_ce625ba7-4218-40af-b344-df718da13f83/54_w1_o1_mandibule_occlusion_occ_file_3.zip','ZIP','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_ce625ba7-4218-40af-b344-df718da13f83_BOPLY__ZIP_','2023-03-15 10:16:44','2023-03-15 11:16:15','54_w1_o1_mandibule_occlusion_occ_file_3.zip','2023-03-15 11:16:44','SYNCED','d1adede1-c3da-47da-a47c-075f5a6fe836',3,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.54.1.1.4 Occlusion 1\",\"modelMatrix\":\"-0.999599,0.0258183,-0.0116515,0,-0.0283256,-0.911116,0.411175,0,-3.36598e-10,0.41134,0.911482,0,17.4173,6.0967,-21.0427,1\",\"referenceScanID\":\"1.54.1.1.4\",\"title\":\"Mandibule 1.54.1.1.4 Occlusion 1\"}'),(1001,'20e88106-93f1-4036-9c08-787a1d2939bd','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a0c21836-ba79-4f15-9e35-02ef8211a9e5/session_0aac522d-3c38-465a-a1e0-014166c140ac/occlusion_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042/scan_e3c95f99-398c-470f-97a1-8755ccbe1568/7_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_a0c21836-ba79-4f15-9e35-02ef8211a9e5_ACT_0aac522d-3c38-465a-a1e0-014166c140ac_SESS_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042_BOSC_e3c95f99-398c-470f-97a1-8755ccbe1568_ZIP_','2022-01-21 11:56:39','2022-01-21 12:56:08','7_w1_o1_mandibule_scan_file_0.zip','2022-01-21 12:56:39','SYNCED','20e88106-93f1-4036-9c08-787a1d2939bd',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.7.1.1.4\",\"modelMatrix\":\"-0.958149,-0.275593,0.0774524,0,0.286269,-0.922414,0.259235,0,-4.63746e-10,0.270558,0.962704,0,17.7986,10.9536,-17.3493,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'20f94b95-aaa7-41af-af0d-73dcf93e1a3c','','SNAPS','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_26ae7fce-0ea3-479f-9989-7d0a3a19aaf7_SNAPO__SNAPS_','2022-02-08 08:48:59','2022-02-07 18:58:31','','2022-02-08 09:48:59','SYNCED','20f94b95-aaa7-41af-af0d-73dcf93e1a3c',0,'2022-02-08 09:48:59','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'20fe8caf-9985-46f2-a4af-5f1b220a188f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f9d03016-567a-4bd4-9cc5-dafeea34e365/session_a7bcb190-dd19-4f3b-8aab-266030bf4064/occlusion_c321e210-b67c-40e8-bece-f8946164a768/computedocclusion_03fe87bc-2a25-4d16-a476-2df62bb3cf76/36_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_f9d03016-567a-4bd4-9cc5-dafeea34e365_ACT_a7bcb190-dd19-4f3b-8aab-266030bf4064_SESS_c321e210-b67c-40e8-bece-f8946164a768_OCC_03fe87bc-2a25-4d16-a476-2df62bb3cf76_TOMA__MATRX_','2022-07-04 14:14:03','2022-07-04 16:13:45','36_w1_o1_maxillaire_matrix_occ_file_0.m','2022-07-04 16:14:03','SYNCED','20fe8caf-9985-46f2-a4af-5f1b220a188f',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.36.1.1.1 Occlusion 2\",\"referenceScanID\":\"1.36.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.36.1.1.1 Occlusion 2\"}'),(1001,'2112c7d9-9622-4dcd-890b-872964f9a44b','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/ca43bf7b-f931-42fc-bb75-05929e4b6578/session_d9740504-a9ca-472a-83f2-a309fa225a98/occlusion_d663165c-f330-4c61-8d1f-14869b6d5edd/scan_7b6a9df3-3f34-48df-a44e-e6d77507d049/59_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_ca43bf7b-f931-42fc-bb75-05929e4b6578_ACT_d9740504-a9ca-472a-83f2-a309fa225a98_SESS_d663165c-f330-4c61-8d1f-14869b6d5edd_TOSC_7b6a9df3-3f34-48df-a44e-e6d77507d049_SNAPS_','2023-03-02 15:00:44','2023-03-02 15:58:54','59_w1_o1_maxillaire_snapshot_1.png','2023-03-02 16:00:44','SYNCED','0d45e478-acd1-41de-ad65-75a3b7160d51',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.59.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'21239f73-353c-4554-bb20-e1a94cd15c1c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3cc1b522-8e7d-4196-87a1-a8c234f0a399/session_ef503949-33e8-4db6-bbfa-456bd8b70b73/occlusion_e8e2758f-faa4-4db7-93df-e94ddfbd8284/scan_5f8678dd-f28d-4301-80c1-57d01da5c2d2/51_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_3cc1b522-8e7d-4196-87a1-a8c234f0a399_ACT_ef503949-33e8-4db6-bbfa-456bd8b70b73_SESS_e8e2758f-faa4-4db7-93df-e94ddfbd8284_LESC_5f8678dd-f28d-4301-80c1-57d01da5c2d2_ZIP_','2022-11-28 17:06:28','2022-11-28 18:06:22','51_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-11-28 18:06:28','SYNCED','21239f73-353c-4554-bb20-e1a94cd15c1c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.51.1.1.1\",\"modelMatrix\":\"-0.992711,-0.119013,0.0083331,0,0.118234,-0.9826,-0.146379,0,0.023523,-0.14261,0.989198,0,-4.9432,3.26247,-17.2867,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'212e5401-b297-469c-b7b5-2cf6013be5d4','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/scan_7b00996b-90f8-4307-9a8c-263a28f1b341/4_w1_o4_maxillaire_scan_file_2.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_TOSC_7b00996b-90f8-4307-9a8c-263a28f1b341_ZIP_','2022-05-31 11:55:53','2022-05-31 13:55:42','4_w1_o4_maxillaire_scan_file_2.zip','2022-05-31 13:55:53','SYNCED','c1ee6f0c-823c-43ab-892b-aa2b9c60a5d0',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.4.1.4.1\",\"modelMatrix\":\"-0.970276,0.236528,-0.0511731,0,-0.242001,-0.948335,0.205173,0,4.08722e-09,0.211459,0.977387,0,20.8295,-20.7118,-18.5295,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'21347aa2-1d83-49d6-a245-e30506990fbc','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/computedocclusion_e9bfc750-6943-42bf-8c0b-b7e1dc1803c5/1_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_OCC_e9bfc750-6943-42bf-8c0b-b7e1dc1803c5_BOPLY__ZIP_','2022-01-19 13:04:53','2022-01-19 12:12:14','1_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-01-19 14:04:53','SYNCED','21347aa2-1d83-49d6-a245-e30506990fbc',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.1.1.1.1 Occlusion 2\",\"referenceScanID\":\"1.1.1.1.1\",\"title\":\"Mandibule 1.1.1.1.1 Occlusion 2\"}'),(1001,'214a2e75-f3aa-4102-ab22-e2344558a6ab','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/1c189ddc-0ee7-45e7-9d80-585dac08374a/session_01bd0635-6ec6-42cb-8561-8638bded352c/order_77d4416a-6efc-4760-97d5-48e41e9044fd/29_w1_couronne_prost_file_214a2e75-f3aa-4102-ab22-e2344558a6ab_0.pdf','PDF','PATIENT_1c189ddc-0ee7-45e7-9d80-585dac08374a_ACT_01bd0635-6ec6-42cb-8561-8638bded352c_PROST_77d4416a-6efc-4760-97d5-48e41e9044fd_PDF_','2022-06-03 17:00:57','2022-06-03 19:00:56','29_w1_couronne_prost_file_214a2e75-f3aa-4102-ab22-e2344558a6ab_0.pdf','2022-06-03 19:00:57','SYNCED','214a2e75-f3aa-4102-ab22-e2344558a6ab',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.29.1.1 COURONNE\",\"title\":\"Couronne PDF\"}'),(1001,'21764d52-2c8b-4d31-a0cd-af3f1985cd6e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a9e7a1ae-2d71-448f-80f6-19d916912a3c/session_07012a03-2a1e-44e4-9bc9-17e726862bc2/occlusion_ab83a8b7-1eb1-4b13-9594-40d6479b2b19/scan_e33a7de9-6d02-41e0-b621-fc99e53eb96c/52_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_a9e7a1ae-2d71-448f-80f6-19d916912a3c_ACT_07012a03-2a1e-44e4-9bc9-17e726862bc2_SESS_ab83a8b7-1eb1-4b13-9594-40d6479b2b19_BOSC_e33a7de9-6d02-41e0-b621-fc99e53eb96c_SNAPS_','2022-11-29 10:33:07','2022-11-29 11:32:58','52_w1_o1_mandibule_snapshot_0.png','2022-11-29 11:33:07','SYNCED','21764d52-2c8b-4d31-a0cd-af3f1985cd6e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.52.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'21d0e66c-3e52-4d85-a3f2-d70f5369923a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/scan_2d226451-8adb-4007-be22-99a9b3af61d6/23_w1_o1_maxillaire_ml_1_0.xyz','LIFI','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_TOSC_2d226451-8adb-4007-be22-99a9b3af61d6_LIFI_','2022-05-25 10:45:09','2022-05-25 12:45:09','23_w1_o1_maxillaire_ml_1_0.xyz','2022-05-25 12:45:09','SYNCED','21d0e66c-3e52-4d85-a3f2-d70f5369923a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.23.1.1.1 Ligne de finition 1\",\"name\":\"Ligne de finition 1\",\"title\":\"Maxillaire LIFI\",\"toothNumber\":1,\"versionMarginLine\":1}'),(1001,'21d7f973-4706-49b0-9bc6-8c798ab813b0','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_19ce66b5-7943-4a9e-82cd-f21481da98cc/54_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_19ce66b5-7943-4a9e-82cd-f21481da98cc_SNAPO__SNAPS_','2023-03-15 10:41:58','2023-03-15 11:40:15','54_w1_o1_snapshot_occ_file_0.png','2023-03-15 11:41:58','SYNCED','21d7f973-4706-49b0-9bc6-8c798ab813b0',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'21df10c9-ac4a-4a75-8a15-e5c30db28180','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/computedocclusion_d7643aed-d242-47f6-8e1a-703d4672f109/18_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_OCC_d7643aed-d242-47f6-8e1a-703d4672f109_TOPLY__ZIP_','2022-03-07 14:44:46','2022-03-07 15:44:20','18_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-03-07 15:44:46','SYNCED','21df10c9-ac4a-4a75-8a15-e5c30db28180',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.18.1.1.2 Occlusion 2\",\"modelMatrix\":\"-0.979743,-0.199678,0.0152522,0,0.20026,-0.976897,0.0746194,0,-1.52856e-10,0.0761623,0.997095,0,19.5629,-11.4708,-22.5064,1\",\"referenceScanID\":\"1.18.1.1.2\",\"title\":\"Maxillaire 1.18.1.1.2 Occlusion 2\"}'),(1001,'21f16639-e10d-42f9-b1b1-ecd1dbc0e28b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/452a5200-3e06-4b74-8949-6abc7f2dda8a/session_3e95d626-668f-45f7-98ad-be2cf9d7b90b/occlusion_bce8310f-eee9-4f0a-a6b7-d592dec66be5/computedocclusion_d9818808-7d5e-47e6-9880-cc95357483ff/26_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_452a5200-3e06-4b74-8949-6abc7f2dda8a_ACT_3e95d626-668f-45f7-98ad-be2cf9d7b90b_SESS_bce8310f-eee9-4f0a-a6b7-d592dec66be5_OCC_d9818808-7d5e-47e6-9880-cc95357483ff_SNAPO__SNAPS_','2022-05-24 09:43:00','2022-05-24 11:42:41','26_w1_o1_snapshot_occ_file_0.png','2022-05-24 11:43:00','SYNCED','21f16639-e10d-42f9-b1b1-ecd1dbc0e28b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'22087293-2aac-4313-989b-8aa120c20399','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/occlusion_e08bbeeb-a30b-428c-bd4a-40198f792219/scan_6aeb3c55-f3f0-4e74-9793-ec74659a28ad/25_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_SESS_e08bbeeb-a30b-428c-bd4a-40198f792219_BOSC_6aeb3c55-f3f0-4e74-9793-ec74659a28ad_ZIP_','2022-05-17 16:28:17','2022-05-17 18:28:16','25_w1_o1_maxillaire_scan_file_0.zip','2022-05-17 18:28:17','SYNCED','22087293-2aac-4313-989b-8aa120c20399',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.25.1.1.2\",\"modelMatrix\":\"-0.964287,0.263246,-0.0291771,0,-0.264858,-0.958419,0.106227,0,5.11078e-10,0.110162,0.993914,0,-2.81379,1.33022,-23.6936,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'222e5132-509a-41d5-9b54-889df4e0023e','','MATRX','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_aa16f8ea-198d-4240-ab78-5a1f54823f0c_TOMA__MATRX_','2022-05-16 17:48:36','2022-05-16 19:47:59','','2022-05-16 19:48:36','SYNCED','222e5132-509a-41d5-9b54-889df4e0023e',0,'2022-05-16 19:48:36','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.24.1.1.2 Occlusion 6\",\"referenceScanID\":\"1.24.1.1.2\",\"title\":\"Matrice Transfo. Maxillaire 1.24.1.1.2 Occlusion 6\"}'),(1001,'229065de-cf1c-4956-8237-67f43f93246b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/occlusion_a2220645-c79d-4dda-b6cc-772384a4106b/scan_0136d883-d517-448a-82a3-bfcdd5f4c35c/38_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_TOSC_0136d883-d517-448a-82a3-bfcdd5f4c35c_ZIP_','2022-07-12 10:46:07','2022-07-12 12:45:58','38_w1_o1_maxillaire_scan_file_0.zip','2022-07-12 12:46:07','SYNCED','229065de-cf1c-4956-8237-67f43f93246b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.38.1.1.1\",\"modelMatrix\":\"-0.298707,0.922945,-0.242789,0,-0.954345,-0.288879,0.0759925,0,9.14042e-10,0.254404,0.967098,0,20.3691,-25.7421,-14.8867,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'22ae53ab-f53d-40bd-b1c2-9fd46bcf26f5','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/32939ecf-ba11-4fff-a074-5e86a9f7f313/session_4075a8d6-094f-4202-abe0-4c02b7a5a8e6/occlusion_51192c80-5065-420e-ae8f-bac335ac1de1/scan_2ca8702c-bb71-418c-b881-0d3d2af204d1/6_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_32939ecf-ba11-4fff-a074-5e86a9f7f313_ACT_4075a8d6-094f-4202-abe0-4c02b7a5a8e6_SESS_51192c80-5065-420e-ae8f-bac335ac1de1_TOSC_2ca8702c-bb71-418c-b881-0d3d2af204d1_SNAPS_','2022-01-20 19:41:40','2022-01-20 11:35:38','6_w1_o1_maxillaire_snapshot_1.png','2022-01-20 20:41:40','SYNCED','b685e310-d84a-4a81-a008-eee4725a0bd6',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.6.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'22c1f3b0-28df-4b29-9dfc-dcf911a7a886','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/372000f2-2471-4a57-9b18-224d0788041f/session_5dd64d24-8e33-45bd-a282-c148c185c338/occlusion_a61fbfda-1ac5-4747-9e0c-6ef664930816/scan_d714312c-15c4-47a6-8000-0e2c92bf1d7d/57_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_372000f2-2471-4a57-9b18-224d0788041f_ACT_5dd64d24-8e33-45bd-a282-c148c185c338_SESS_a61fbfda-1ac5-4747-9e0c-6ef664930816_RISC_d714312c-15c4-47a6-8000-0e2c92bf1d7d_ZIP_','2023-02-17 10:55:19','2023-02-17 11:55:13','57_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2023-02-17 11:55:19','SYNCED','22c1f3b0-28df-4b29-9dfc-dcf911a7a886',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.57.1.1.1\",\"modelMatrix\":\"0.974203,0.16677,0.15637,0,-0.177609,0.983924,0.0547269,0,-0.139356,-0.0657232,0.986311,0,-9.14444,2.96331,-20.4782,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'230c7b3c-798a-4e8e-9487-522dcddd0350','','SNAPS','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_RISC_261fcec0-ce06-45e0-a8b7-6a5f785c988d_SNAPS_','2022-04-21 17:37:36','2022-04-21 13:11:18','','2022-04-21 19:37:36','SYNCED','230c7b3c-798a-4e8e-9487-522dcddd0350',0,'2022-04-21 19:37:36','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.22.1.1.2\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'233906f5-91b1-4c0f-be83-5e9f0253d3e5','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/98aa55d8-3848-48e0-9684-5597786b85c7/session_4df1e430-5cbb-4a6c-8292-747e35e6f1e8/occlusion_fcc5c65d-b0e4-4036-99c7-07318171986a/scan_73f03f13-af33-4847-ad0e-e28b8985bd6f/66_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_98aa55d8-3848-48e0-9684-5597786b85c7_ACT_4df1e430-5cbb-4a6c-8292-747e35e6f1e8_SESS_fcc5c65d-b0e4-4036-99c7-07318171986a_RISC_73f03f13-af33-4847-ad0e-e28b8985bd6f_SNAPS_','2023-04-13 10:04:29','2023-04-13 12:04:29','66_w1_o1_mordu_posterieur_droit_snapshot_0.png',NULL,'CREATED','233906f5-91b1-4c0f-be83-5e9f0253d3e5',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit SNAPSHOT\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'2343da36-b2ed-48aa-8bea-6bbf74dee09b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/32939ecf-ba11-4fff-a074-5e86a9f7f313/session_4075a8d6-094f-4202-abe0-4c02b7a5a8e6/occlusion_51192c80-5065-420e-ae8f-bac335ac1de1/scan_2ca8702c-bb71-418c-b881-0d3d2af204d1/6_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_32939ecf-ba11-4fff-a074-5e86a9f7f313_ACT_4075a8d6-094f-4202-abe0-4c02b7a5a8e6_SESS_51192c80-5065-420e-ae8f-bac335ac1de1_TOSC_2ca8702c-bb71-418c-b881-0d3d2af204d1_ZIP_','2022-01-20 10:13:02','2022-01-20 11:12:39','6_w1_o1_maxillaire_scan_file_0.zip','2022-01-20 11:13:02','SYNCED','2343da36-b2ed-48aa-8bea-6bbf74dee09b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.6.1.1.1\",\"modelMatrix\":\"0.299661,0.916001,-0.26673,0,-0.954046,0.287711,-0.0837784,0,7.6452e-9,0.279578,0.960123,0,-15.1089,-22.8916,-20.0563,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'2347ba2a-b6ae-4584-996b-ec0c44f04a55','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/scan_2d226451-8adb-4007-be22-99a9b3af61d6/23_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_TOSC_2d226451-8adb-4007-be22-99a9b3af61d6_ZIP_','2022-05-13 10:02:02','2022-05-13 12:01:51','23_w1_o1_maxillaire_scan_file_0.zip','2022-05-13 12:02:02','SYNCED','2347ba2a-b6ae-4584-996b-ec0c44f04a55',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.23.1.1.1\",\"modelMatrix\":\"-0.996412,0.0371381,-0.0760535,0,-0.0846367,-0.43722,0.895363,0,9.59179e-10,0.898588,0.438794,0,-5.67604,-22.9357,-12.9416,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'2408b3ef-b412-436d-a442-1944dba562c5','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/computedocclusion_b35629de-38d8-4cdd-bf2c-b61c461410cb/17_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_b35629de-38d8-4cdd-bf2c-b61c461410cb_BOPLY__ZIP_','2022-02-07 18:07:22','2022-02-07 19:05:55','17_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-02-07 19:07:22','SYNCED','2408b3ef-b412-436d-a442-1944dba562c5',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.17.1.1.1 Occlusion 6\",\"modelMatrix\":\"-0.980954,-0.188901,0.0452269,0,0.19424,-0.953992,0.228406,0,1.35057e-9,0.232841,0.972515,0,27.4349,19.1019,-20.1379,1\",\"referenceScanID\":\"1.17.1.1.1\",\"title\":\"Mandibule 1.17.1.1.1 Occlusion 6\"}'),(1001,'2413d387-ed67-4527-b74d-3bc45541eadf','','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_fa1c1f6f-5c0d-45ca-8646-2a1ca68f51b4_TOPLY__ZIP_','2022-05-16 17:51:10','2022-05-16 19:50:25','','2022-05-16 19:51:10','SYNCED','2413d387-ed67-4527-b74d-3bc45541eadf',0,'2022-05-16 19:51:10','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.2 Occlusion 6\",\"modelMatrix\":\"-0.80453,0.576793,-0.141569,0,-0.593912,-0.781339,0.191773,0,-6.05286e-09,0.238367,0.971175,0,0.910551,-5.61768,-25.9513,1\",\"referenceScanID\":\"1.24.1.1.2\",\"title\":\"Maxillaire 1.24.1.1.2 Occlusion 6\"}'),(1001,'241ff7c7-536a-43e6-9bad-9685fc523fa7','','SNAPS','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_LESC_f9eccc16-31b5-4a87-b758-9bf72196ca28_SNAPS_','2022-09-09 16:40:45','2022-09-09 18:38:08','','2022-09-09 18:40:45','SYNCED','241ff7c7-536a-43e6-9bad-9685fc523fa7',0,'2022-09-09 18:40:45','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.39.1.1.7\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'24532129-ed40-4cea-a3b3-8012bb0d2259','','MATRX','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_fa1c1f6f-5c0d-45ca-8646-2a1ca68f51b4_TOMA__MATRX_','2022-05-16 17:51:11','2022-05-16 19:50:25','','2022-05-16 19:51:11','SYNCED','24532129-ed40-4cea-a3b3-8012bb0d2259',0,'2022-05-16 19:51:11','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.24.1.1.2 Occlusion 6\",\"referenceScanID\":\"1.24.1.1.2\",\"title\":\"Matrice Transfo. Maxillaire 1.24.1.1.2 Occlusion 6\"}'),(1001,'24b218af-fcc6-4d11-8bc7-0d12769286f9','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/computedocclusion_2de3d2bb-d512-4514-8bed-a879b73a6028/22_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_OCC_2de3d2bb-d512-4514-8bed-a879b73a6028_SNAPO__SNAPS_','2022-04-21 11:29:39','2022-04-21 13:29:16','22_w1_o1_snapshot_occ_file_0.png','2022-04-21 13:29:39','SYNCED','24b218af-fcc6-4d11-8bc7-0d12769286f9',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'24e5a7c7-24f3-4b9c-97a8-51bdaa4d628b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_2a7068fc-0efa-496f-ade9-aba5b0650655/12_w1_o1_mandibule_scan_file_10.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_2a7068fc-0efa-496f-ade9-aba5b0650655_ZIP_','2022-02-04 12:15:35','2022-02-04 13:15:01','12_w1_o1_mandibule_scan_file_10.zip','2022-02-04 13:15:35','SYNCED','44ebcd6f-57c2-4cce-96f5-f9faa1c6b373',10,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.5\",\"modelMatrix\":\"0.821265,-0.551643,0.145651,0,0.570547,0.794053,-0.209655,0,5.91416e-9,0.255283,0.966866,0,-2.59195,32.4156,-27.5972,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'2505eb15-7090-4f82-ad06-2fbd8aea623a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/32710234-804f-46f5-899d-eed636f8a906/session_64c1427a-b91d-4675-94df-f36bd40e9b0f/occlusion_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a/computedocclusion_84d73896-4c7a-4dc0-994a-b2a70e3d1cf2/33_w2_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_32710234-804f-46f5-899d-eed636f8a906_ACT_64c1427a-b91d-4675-94df-f36bd40e9b0f_SESS_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a_OCC_84d73896-4c7a-4dc0-994a-b2a70e3d1cf2_BOPLY__ZIP_','2022-06-28 09:07:20','2022-06-28 11:07:03','33_w2_o1_mandibule_occlusion_occ_file_0.zip','2022-06-28 11:07:20','SYNCED','2505eb15-7090-4f82-ad06-2fbd8aea623a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.33.2.1.1 Occlusion 1\",\"modelMatrix\":\"-0.911542,-0.410478,0.0244887,0,0.411207,-0.909924,0.0542853,0,-6.94447e-10,0.0595532,0.998225,0,18.7622,-5.69322,-17.7897,1\",\"referenceScanID\":\"1.33.2.1.1\",\"title\":\"Mandibule 1.33.2.1.1 Occlusion 1\"}'),(1001,'251f57eb-36ef-45d5-affe-51494469c59a','','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_OCC_a525c976-46dd-42bc-abc1-c7cf71f9a1f1_TOPLY__ZIP_','2022-02-07 11:15:30','2022-02-04 14:58:28','','2022-02-07 12:15:30','SYNCED','251f57eb-36ef-45d5-affe-51494469c59a',0,'2022-02-07 12:15:30','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.12.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.622652,0.772747,-0.123153,0,-0.782499,0.614892,-0.0979959,0,-5.00422e-9,0.157385,0.987537,0,-21.5256,-19.2669,-19.1349,1\",\"referenceScanID\":\"1.12.1.1.1\",\"title\":\"Maxillaire 1.12.1.1.1 Occlusion 1\"}'),(1001,'253b7aa4-960b-44cb-8866-6a79764bcc0b','','ZIP','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_RISC_0f004b83-11e3-49ae-b25b-7872c0ac7485_ZIP_','2022-09-10 08:18:17','2022-09-09 18:36:23','','2022-09-10 10:18:17','SYNCED','253b7aa4-960b-44cb-8866-6a79764bcc0b',0,'2022-09-10 10:18:17','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.39.1.1.5\",\"modelMatrix\":\"0.95568,0.161732,0.244456,0,-0.161618,0.986149,0.00747179,0,-0.246206,-0.0383378,0.969701,0,-3.25243,1.23227,-19.9296,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'25463aa1-307a-4bfa-9fd6-936160ee84c1','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/9e399d73-4d2e-4bb8-af48-a4e597811faa/session_b1cf14ce-00a9-48b6-8654-dadde26073f1/occlusion_1060c95f-48f4-4a37-9b82-03bfd8329730/computedocclusion_67e8fc2c-cca5-4b65-8153-f487421fc4e6/46_w1_o2_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_9e399d73-4d2e-4bb8-af48-a4e597811faa_ACT_b1cf14ce-00a9-48b6-8654-dadde26073f1_SESS_1060c95f-48f4-4a37-9b82-03bfd8329730_OCC_67e8fc2c-cca5-4b65-8153-f487421fc4e6_BOMA__MATRX_','2023-01-20 14:43:19','2023-01-20 15:42:49','46_w1_o2_mandibule_matrix_occ_file_0.m','2023-01-20 15:43:19','SYNCED','25463aa1-307a-4bfa-9fd6-936160ee84c1',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.46.1.2.1 Occlusion 2\",\"referenceScanID\":\"1.46.1.2.1\",\"title\":\"Matrice Transfo. Mandibule 1.46.1.2.1 Occlusion 2\"}'),(1001,'257d0e5e-38b7-45cd-8c0c-d2e0641bfda7','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_f9c2783a-c405-481c-a97e-47bb9db0d0d2/17_w1_o1_mordu_posterieur_droit_snapshot_1.png','SNAPS','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_RISC_f9c2783a-c405-481c-a97e-47bb9db0d0d2_SNAPS_','2022-02-07 11:47:27','2022-02-07 12:44:03','17_w1_o1_mordu_posterieur_droit_snapshot_1.png','2022-02-07 12:47:27','SYNCED','6e5eb213-3b0b-4c68-a8b7-4d44d6e5a4a8',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.17.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'25d4cc8b-2ba5-422c-b88a-0cecfa682ae3','','MATRX','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_65f9077d-c859-4b2c-9d4d-692d723315a5_BOMA__MATRX_','2022-05-13 12:07:43','2022-05-13 14:07:00','','2022-05-13 14:07:43','SYNCED','25d4cc8b-2ba5-422c-b88a-0cecfa682ae3',0,'2022-05-13 14:07:43','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.23.1.1.1 Occlusion 4\",\"referenceScanID\":\"1.23.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.23.1.1.1 Occlusion 4\"}'),(1001,'25e74dd8-3937-4ae4-b200-5489bfb184fd','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/458c92d8-9da1-4df9-967f-d14fc7e6303d/session_55831d43-1906-4a22-9b7a-ed4b2820c8b2/occlusion_4f582d4c-81d0-4e01-8be3-9ff53b12c7f4/scan_19e6ea5c-af28-439b-bc57-b561cd42e12b/10_w2_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_55831d43-1906-4a22-9b7a-ed4b2820c8b2_SESS_4f582d4c-81d0-4e01-8be3-9ff53b12c7f4_TOSC_19e6ea5c-af28-439b-bc57-b561cd42e12b_SNAPS_','2022-06-16 13:27:31','2022-06-16 15:27:21','10_w2_o1_maxillaire_snapshot_1.png','2022-06-16 15:27:31','SYNCED','b6f46e96-4d05-4b63-8956-16b3af586d47',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.10.2.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'26486b53-a539-40e3-b121-f2aa550df56e','','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_OCC_e9a397c8-e329-4471-985b-0eb40ed458b0_SNAPO__SNAPS_','2022-02-04 15:01:39','2022-02-04 14:50:30','','2022-02-04 16:01:39','SYNCED','26486b53-a539-40e3-b121-f2aa550df56e',0,'2022-02-04 16:01:39','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'2669117e-8bb2-4f15-9ce3-d1ccf1251c13','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_0e451099-a0ad-463c-9441-7ded1297fa16/24_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_TOSC_0e451099-a0ad-463c-9441-7ded1297fa16_SNAPS_','2022-05-24 14:43:41','2022-05-24 16:43:24','24_w1_o1_maxillaire_snapshot_1.png','2022-05-24 16:43:41','SYNCED','2ae18efe-89ec-4910-93a7-b68bc09a8249',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'2691d8e3-20a3-4317-b7f8-6e9ccbee9aba','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/ca43bf7b-f931-42fc-bb75-05929e4b6578/session_d9740504-a9ca-472a-83f2-a309fa225a98/occlusion_d663165c-f330-4c61-8d1f-14869b6d5edd/scan_7b6a9df3-3f34-48df-a44e-e6d77507d049/59_w1_o1_maxillaire_snapshot_2.png','SNAPS','PATIENT_ca43bf7b-f931-42fc-bb75-05929e4b6578_ACT_d9740504-a9ca-472a-83f2-a309fa225a98_SESS_d663165c-f330-4c61-8d1f-14869b6d5edd_TOSC_7b6a9df3-3f34-48df-a44e-e6d77507d049_SNAPS_','2023-03-02 15:00:51','2023-03-02 16:00:43','59_w1_o1_maxillaire_snapshot_2.png','2023-03-02 16:00:51','SYNCED','0d45e478-acd1-41de-ad65-75a3b7160d51',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.59.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'2697d64a-9f2f-4500-84e9-a0315f87e33d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/452a5200-3e06-4b74-8949-6abc7f2dda8a/session_3e95d626-668f-45f7-98ad-be2cf9d7b90b/occlusion_bce8310f-eee9-4f0a-a6b7-d592dec66be5/scan_315ac573-ca2e-4c47-8969-e667ad225aa2/26_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_452a5200-3e06-4b74-8949-6abc7f2dda8a_ACT_3e95d626-668f-45f7-98ad-be2cf9d7b90b_SESS_bce8310f-eee9-4f0a-a6b7-d592dec66be5_LESC_315ac573-ca2e-4c47-8969-e667ad225aa2_ZIP_','2022-05-24 09:41:38','2022-05-24 11:41:30','26_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-05-24 11:41:38','SYNCED','2697d64a-9f2f-4500-84e9-a0315f87e33d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.26.1.1.1\",\"modelMatrix\":\"-0.940924,0.0532921,0.32678,0,0.0960697,-0.905072,0.4126,0,0.324812,0.421914,0.850326,0,-19.6107,-10.4836,-8.10302,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'26b478ab-c31b-4eb3-aa5d-fd54f1ef7690','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/scan_ebc093ba-6f58-45ce-a427-c955985391bd/54_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_LESC_ebc093ba-6f58-45ce-a427-c955985391bd_SNAPS_','2022-12-13 09:40:53','2022-12-13 10:40:45','54_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-12-13 10:40:53','SYNCED','26b478ab-c31b-4eb3-aa5d-fd54f1ef7690',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.54.1.1.3\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'26c6a3a9-4104-4bbb-a17d-704486a1f413','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f9d03016-567a-4bd4-9cc5-dafeea34e365/session_a7bcb190-dd19-4f3b-8aab-266030bf4064/occlusion_c321e210-b67c-40e8-bece-f8946164a768/computedocclusion_03fe87bc-2a25-4d16-a476-2df62bb3cf76/36_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_f9d03016-567a-4bd4-9cc5-dafeea34e365_ACT_a7bcb190-dd19-4f3b-8aab-266030bf4064_SESS_c321e210-b67c-40e8-bece-f8946164a768_OCC_03fe87bc-2a25-4d16-a476-2df62bb3cf76_TOPLY__ZIP_','2022-07-04 14:13:55','2022-07-04 16:13:45','36_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-07-04 16:13:55','SYNCED','26c6a3a9-4104-4bbb-a17d-704486a1f413',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.36.1.1.1 Occlusion 2\",\"modelMatrix\":\"-0.740632,0.661068,-0.120222,0,-0.671911,-0.72868,0.132518,0,7.47193e-09,0.178926,0.983863,0,13.1843,-17.5524,-17.7657,1\",\"referenceScanID\":\"1.36.1.1.1\",\"title\":\"Maxillaire 1.36.1.1.1 Occlusion 2\"}'),(2,'273ede87-068a-42c6-aa6e-0184f164e3fe','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a4b302c-278d-4e12-ace5-f095ba0bf856/session_6206892a-2e7e-4765-ac90-b49bfb465997/occlusion_7ec70f78-dc80-40c5-b293-570a59f034c4/scan_2ef30e56-ed6b-4233-94dd-08cbb9ef27df/3_w1_o2_maxillaire_snapshot_0.png','SNAPS','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_7ec70f78-dc80-40c5-b293-570a59f034c4_TOSC_2ef30e56-ed6b-4233-94dd-08cbb9ef27df_SNAPS_','2022-09-06 09:17:56','2022-08-30 14:20:46','3_w1_o2_maxillaire_snapshot_0.png','2022-09-06 11:17:56','SYNCED','273ede87-068a-42c6-aa6e-0184f164e3fe',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.3.1.2.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'27492cd3-eb70-48a2-876e-dce55c90a17a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/e922efb9-8c03-445b-8a0f-449e3c43bdca/session_a2369349-1629-40ad-8784-d271bc3fbade/occlusion_292cc1aa-8b12-463b-87a1-7d9731cf886b/computedocclusion_f9f6d9d2-cc34-43c3-9f5f-4b8e54b41bbb/21_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_e922efb9-8c03-445b-8a0f-449e3c43bdca_ACT_a2369349-1629-40ad-8784-d271bc3fbade_SESS_292cc1aa-8b12-463b-87a1-7d9731cf886b_OCC_f9f6d9d2-cc34-43c3-9f5f-4b8e54b41bbb_BOPLY__ZIP_','2022-04-21 08:53:24','2022-04-21 10:53:03','21_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-04-21 10:53:24','SYNCED','27492cd3-eb70-48a2-876e-dce55c90a17a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.21.1.1.1 Occlusion 2\",\"modelMatrix\":\"-0.976637,0.206889,-0.0581121,0,-0.214896,-0.94025,0.264102,0,1.90262e-09,0.27042,0.962742,0,12.5761,-24.3862,-20.0904,1\",\"referenceScanID\":\"1.21.1.1.1\",\"title\":\"Mandibule 1.21.1.1.1 Occlusion 2\"}'),(1001,'27571368-d410-426c-bb87-4de2c6774315','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/computedocclusion_0bc29ff9-efea-448d-b521-2c39fd4faa78/19_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_OCC_0bc29ff9-efea-448d-b521-2c39fd4faa78_SNAPO__SNAPS_','2022-03-08 11:18:05','2022-03-08 12:17:37','19_w1_o1_snapshot_occ_file_0.png','2022-03-08 12:18:05','SYNCED','27571368-d410-426c-bb87-4de2c6774315',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'275b4ec7-203d-4ed3-8a9d-92c88e8f67de','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5/occlusion_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa/computedocclusion_901f8265-7f99-4d24-a03f-5860f5bc155e/24_w2_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5_SESS_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa_OCC_901f8265-7f99-4d24-a03f-5860f5bc155e_BOPLY__ZIP_','2022-10-07 14:32:34','2022-10-07 16:31:57','24_w2_o1_mandibule_occlusion_occ_file_0.zip','2022-10-07 16:32:34','SYNCED','275b4ec7-203d-4ed3-8a9d-92c88e8f67de',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.24.2.1.5 Occlusion 1\",\"modelMatrix\":\"-0.3138,0.935395,-0.162988,0,-0.949489,-0.309143,0.0538666,0,-2.99524e-09,0.171659,0.985157,0,25.6088,-18.5365,-15.4613,1\",\"referenceScanID\":\"1.24.2.1.5\",\"title\":\"Mandibule 1.24.2.1.5 Occlusion 1\"}'),(1001,'276d2dbf-9239-44ea-b277-b87cc985f9b7','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3ed7a8e0-5b4d-4ecf-b4ae-f855b16c0f93/session_fb42cec6-0bb6-41e9-912d-0517ff8e0942/occlusion_fb214b2f-5e41-492d-85c4-d4a11a3947c5/scan_c3e17d3f-dc98-4f9a-8f77-01641069f720/42_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_3ed7a8e0-5b4d-4ecf-b4ae-f855b16c0f93_ACT_fb42cec6-0bb6-41e9-912d-0517ff8e0942_SESS_fb214b2f-5e41-492d-85c4-d4a11a3947c5_RISC_c3e17d3f-dc98-4f9a-8f77-01641069f720_ZIP_','2022-10-07 11:54:47','2022-10-07 13:54:40','42_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-10-07 13:54:47','SYNCED','276d2dbf-9239-44ea-b277-b87cc985f9b7',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.42.1.1.1\",\"modelMatrix\":\"0.973573,-0.116296,0.188651,0,0.106131,0.989127,0.114829,0,-0.202476,-0.0906363,0.975315,0,10.1329,1.51709,-16.0215,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'27783779-520f-4bd8-b471-a13cdf11718c','','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_BOSC_a1a9cef4-72fe-4dbe-928c-3831f98ecfbc_SNAPS_','2022-02-19 17:53:23','2022-02-18 17:01:38','','2022-02-19 18:53:23','SYNCED','fb2afa86-ebd5-4360-a84e-10047e56c6e5',1,'2022-02-19 18:53:23','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.4.4\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'279111aa-db84-4754-8277-7244a074df26','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_44561518-16e3-45bd-af90-fefe4eca9d27/24_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_RISC_44561518-16e3-45bd-af90-fefe4eca9d27_SNAPS_','2022-06-13 14:53:09','2022-06-13 16:53:02','24_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-06-13 16:53:09','SYNCED','279111aa-db84-4754-8277-7244a074df26',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.24.1.1.2\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'27b915e1-c25a-4eca-a403-ac238b3d04d5','','SNAPS','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_RISC_ceafbbd6-01e4-4f7a-9d71-a337153d555a_SNAPS_','2022-04-21 17:37:47','2022-04-21 13:10:25','','2022-04-21 19:37:47','SYNCED','27b915e1-c25a-4eca-a403-ac238b3d04d5',0,'2022-04-21 19:37:47','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.22.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'27d20733-0f26-4b51-b528-aef4f716d664','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/order_1f7b5476-a626-43ce-baf4-b1e445f56770/4_w1_autre_prost_file_27d20733-0f26-4b51-b528-aef4f716d664_0.pdf','PDF','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_PROST_1f7b5476-a626-43ce-baf4-b1e445f56770_PDF_','2022-03-09 09:37:43','2022-03-09 10:37:41','4_w1_autre_prost_file_27d20733-0f26-4b51-b528-aef4f716d664_0.pdf','2022-03-09 10:37:43','SYNCED','27d20733-0f26-4b51-b528-aef4f716d664',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.4.1.4 AUTRE FICHE DE PROTHESE\",\"title\":\"Autre PDF\"}'),(1001,'289d0553-c152-4c7e-9fdc-478e07f0302f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_7048f93c-1091-4f02-bc64-b73347dfa962/24_w1_o1_mordu_posterieur_droit_scan_file_1.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_RISC_7048f93c-1091-4f02-bc64-b73347dfa962_ZIP_','2022-06-13 15:02:10','2022-06-13 17:02:03','24_w1_o1_mordu_posterieur_droit_scan_file_1.zip','2022-06-13 17:02:10','SYNCED','91975b1f-684b-4717-9edb-bec57444b873',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.24.1.1.3\",\"modelMatrix\":\"0.998619,-0.0225373,-0.0518672,0,0.0274141,0.999152,0.0316937,0,0.0453051,-0.0346534,0.998169,0,-1.54115,-3.89745,-17.238,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'28a9fce2-d866-4a71-92dc-42eef3b92846','','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_1500b3eb-4b86-46c1-9c9f-7efbd0224ac8_SNAPO__SNAPS_','2022-05-25 08:56:39','2022-05-13 18:22:04','','2022-05-25 10:56:39','SYNCED','28a9fce2-d866-4a71-92dc-42eef3b92846',0,'2022-05-25 10:56:39','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'28cb3d03-2b1a-4f45-9d78-e221a6841249','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f4fc00ec-4af8-4a15-b427-f1c5aabf6260/session_498ae60a-23f0-44fc-9730-be499bfc4b46/occlusion_8f3d6c73-3468-45a5-85c7-93bba47ec9f7/scan_a7163552-20ad-4b45-ae78-be2b0453dbd3/30_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_f4fc00ec-4af8-4a15-b427-f1c5aabf6260_ACT_498ae60a-23f0-44fc-9730-be499bfc4b46_SESS_8f3d6c73-3468-45a5-85c7-93bba47ec9f7_LESC_a7163552-20ad-4b45-ae78-be2b0453dbd3_ZIP_','2022-06-14 13:29:51','2022-06-14 15:29:43','30_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-06-14 15:29:51','SYNCED','28cb3d03-2b1a-4f45-9d78-e221a6841249',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.30.1.1.1\",\"modelMatrix\":\"-0.940851,0.0844677,0.327584,0,-0.0316586,-0.987891,0.129627,0,0.337376,0.132286,0.936188,0,-6.40134,-4.82352,-19.1939,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'28ffb267-985a-45c9-98e6-5f2d57a9c656','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/452a5200-3e06-4b74-8949-6abc7f2dda8a/session_3e95d626-668f-45f7-98ad-be2cf9d7b90b/occlusion_bce8310f-eee9-4f0a-a6b7-d592dec66be5/scan_bd194eb4-5c69-43b1-94bb-66c7ae8aa0ce/26_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_452a5200-3e06-4b74-8949-6abc7f2dda8a_ACT_3e95d626-668f-45f7-98ad-be2cf9d7b90b_SESS_bce8310f-eee9-4f0a-a6b7-d592dec66be5_BOSC_bd194eb4-5c69-43b1-94bb-66c7ae8aa0ce_ZIP_','2022-05-24 09:15:07','2022-05-24 11:15:00','26_w1_o1_mandibule_scan_file_1.zip','2022-05-24 11:15:07','SYNCED','8d1bd14c-e811-4bca-828b-4f1629ec9192',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.26.1.1.2\",\"modelMatrix\":\"-0.440993,0.868318,-0.227045,0,-0.89751,-0.426649,0.111559,0,-1.10485e-08,0.252972,0.967474,0,8.55795,-16.8564,-17.5092,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'28ffc1de-2be4-4a19-87be-aecd0b0aa83f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/computedocclusion_6960b50e-6f78-4f83-9303-8c985410457c/4_w1_o4_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_OCC_6960b50e-6f78-4f83-9303-8c985410457c_TOPLY__ZIP_','2022-05-31 14:56:07','2022-05-31 16:55:44','4_w1_o4_maxillaire_occlusion_occ_file_0.zip','2022-05-31 16:56:07','SYNCED','28ffc1de-2be4-4a19-87be-aecd0b0aa83f',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.4.1.4.1 Occlusion 5\",\"modelMatrix\":\"-0.970276,0.236528,-0.0511731,0,-0.242001,-0.948335,0.205173,0,4.08722e-09,0.211459,0.977387,0,20.8295,-20.7118,-18.5295,1\",\"referenceScanID\":\"1.4.1.4.1\",\"title\":\"Maxillaire 1.4.1.4.1 Occlusion 5\"}'),(1001,'29171666-f57b-4fcc-893b-6e01da2033fe','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/computedocclusion_e15a2d21-e8f2-4d2a-9a68-13d92ae4b997/13_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_OCC_e15a2d21-e8f2-4d2a-9a68-13d92ae4b997_BOMA__MATRX_','2022-02-04 18:25:04','2022-02-04 19:23:45','13_w1_o1_mandibule_matrix_occ_file_0.m','2022-02-04 19:25:04','SYNCED','29171666-f57b-4fcc-893b-6e01da2033fe',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.13.1.1.5 Occlusion 3\",\"referenceScanID\":\"1.13.1.1.5\",\"title\":\"Matrice Transfo. Mandibule 1.13.1.1.5 Occlusion 3\"}'),(1001,'29214935-0f63-4c89-bfb3-06abb6bbb7ae','','ZIP','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_OCC_ff8547d7-27f8-4862-9b63-e713dd817f3f_TOPLY__ZIP_','2022-09-09 17:04:15','2022-09-09 19:03:34','','2022-09-09 19:04:15','SYNCED','29214935-0f63-4c89-bfb3-06abb6bbb7ae',0,'2022-09-09 19:04:15','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.39.1.1.1 Occlusion 10\",\"modelMatrix\":\"-0.226177,0.929302,-0.291961,0,-0.974086,-0.215779,0.0677916,0,7.55513e-09,0.299728,0.954025,0,-12.3361,-28.543,-16.1754,1\",\"referenceScanID\":\"1.39.1.1.1\",\"title\":\"Maxillaire 1.39.1.1.1 Occlusion 10\"}'),(1001,'29712bfe-3317-4e6f-9b73-f5b757e2f2cc','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/207d6dbc-c19b-4726-a9b3-16235ae554cc/session_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35/occlusion_dc5762a3-c453-4166-8c86-82d23ac9f8a6/scan_9a90e42e-88ee-4808-8ae4-399e7285a1d0/27_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_207d6dbc-c19b-4726-a9b3-16235ae554cc_ACT_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35_SESS_dc5762a3-c453-4166-8c86-82d23ac9f8a6_TOSC_9a90e42e-88ee-4808-8ae4-399e7285a1d0_ZIP_','2022-05-30 10:55:02','2022-05-30 12:54:52','27_w1_o1_maxillaire_scan_file_0.zip','2022-05-30 12:55:02','SYNCED','29712bfe-3317-4e6f-9b73-f5b757e2f2cc',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.27.1.1.1\",\"modelMatrix\":\"0.708736,0.675594,-0.203138,0,-0.705473,0.678719,-0.204077,0,4.95031e-09,0.287945,0.957647,0,-5.6101,-21.7145,-20.7773,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'29722a02-997e-45bb-8685-579d5915af43','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_4f8dc275-857c-482a-9886-5521591e9661/scan_df08df19-150c-437d-8ed4-bf2826644265/12_w1_o4_mandibule_snapshot_1.png','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_BOSC_df08df19-150c-437d-8ed4-bf2826644265_SNAPS_','2022-02-18 16:21:47','2022-02-18 17:15:35','12_w1_o4_mandibule_snapshot_1.png','2022-02-18 17:21:47','SYNCED','e3598e66-59db-43ac-a342-a835944e8fab',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.4.5\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'29f3b0e2-4a26-4b27-ba2e-8513c1c9d0f7','','SNAPS','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_d79359b0-a63e-4bdb-91ad-dec77d961970_SNAPS_','2022-02-04 11:29:38','2022-02-04 09:36:23','','2022-02-04 12:29:38','SYNCED','29f3b0e2-4a26-4b27-ba2e-8513c1c9d0f7',0,'2022-02-04 12:29:38','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'2a5b331f-c279-44c9-bbf8-96ec66d350f6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/75ce481f-6c44-4d16-a477-ea40c4fa6022/session_9bf7b056-ca4f-4dab-937b-619d0eb20528/occlusion_d7580529-3ede-4e27-a2ae-01849ba4d397/scan_ead7bba4-f70a-466e-948c-a630d4da7a7a/55_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_75ce481f-6c44-4d16-a477-ea40c4fa6022_ACT_9bf7b056-ca4f-4dab-937b-619d0eb20528_SESS_d7580529-3ede-4e27-a2ae-01849ba4d397_TOSC_ead7bba4-f70a-466e-948c-a630d4da7a7a_SNAPS_','2022-12-22 10:18:34','2022-12-22 11:18:21','55_w1_o1_maxillaire_snapshot_1.png','2022-12-22 11:18:34','SYNCED','6b090bc7-5f6e-4e97-a38a-63ef40edfbd3',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.55.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'2a8fdc87-7a3f-47e4-83f8-76543163cd17','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/computedocclusion_0bc29ff9-efea-448d-b521-2c39fd4faa78/19_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_OCC_0bc29ff9-efea-448d-b521-2c39fd4faa78_BOPLY__ZIP_','2022-03-08 11:17:53','2022-03-08 12:17:37','19_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-03-08 12:17:53','SYNCED','2a8fdc87-7a3f-47e4-83f8-76543163cd17',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.1.4 Occlusion 3\",\"modelMatrix\":\"-0.988793,0.145775,-0.0322113,0,-0.149292,-0.965503,0.213343,0,-2.16806e-09,0.215761,0.976446,0,23.0578,-21.2539,-25.059,1\",\"referenceScanID\":\"1.19.1.1.4\",\"title\":\"Mandibule 1.19.1.1.4 Occlusion 3\"}'),(1001,'2ae18efe-89ec-4910-93a7-b68bc09a8249','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_0e451099-a0ad-463c-9441-7ded1297fa16/24_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_TOSC_0e451099-a0ad-463c-9441-7ded1297fa16_SNAPS_','2022-05-24 14:34:54','2022-05-24 16:34:38','24_w1_o1_maxillaire_snapshot_0.png','2022-05-24 16:34:54','SYNCED','2ae18efe-89ec-4910-93a7-b68bc09a8249',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'2b1bef3b-fba2-449d-bd46-8eb969970512','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_ce625ba7-4218-40af-b344-df718da13f83/54_w1_o1_mandibule_occlusion_occ_file_4.zip','ZIP','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_ce625ba7-4218-40af-b344-df718da13f83_BOPLY__ZIP_','2023-03-15 10:26:39','2023-03-15 11:26:20','54_w1_o1_mandibule_occlusion_occ_file_4.zip','2023-03-15 11:26:39','SYNCED','d1adede1-c3da-47da-a47c-075f5a6fe836',4,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.54.1.1.4 Occlusion 1\",\"modelMatrix\":\"-0.999599,0.0258183,-0.0116515,0,-0.0283256,-0.911116,0.411175,0,-3.36598e-10,0.41134,0.911482,0,17.4173,6.0967,-21.0427,1\",\"referenceScanID\":\"1.54.1.1.4\",\"title\":\"Mandibule 1.54.1.1.4 Occlusion 1\"}'),(1001,'2b408b13-2a9b-4477-8eea-ca0d2ef357cf','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/computedocclusion_42098ceb-3335-4f13-8aed-b29c37a5f57f/22_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_OCC_42098ceb-3335-4f13-8aed-b29c37a5f57f_BOPLY__ZIP_','2022-04-21 11:28:51','2022-04-21 13:28:43','22_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-04-21 13:28:51','SYNCED','2b408b13-2a9b-4477-8eea-ca0d2ef357cf',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.22.1.1.2 Occlusion 6\",\"modelMatrix\":\"0.930866,0.359665,-0.0642588,0,-0.36536,0.916356,-0.163719,0,1.67408e-09,0.175878,0.984412,0,-11.7687,0.165278,-18.4217,1\",\"referenceScanID\":\"1.22.1.1.2\",\"title\":\"Mandibule 1.22.1.1.2 Occlusion 6\"}'),(1001,'2bbd50df-4190-4607-a3d7-f1d8663a4cb1','','MATRX','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_7d8decb1-23db-4824-940f-8d8822d88813_TOMA__MATRX_','2022-02-08 08:48:59','2022-02-07 18:48:45','','2022-02-08 09:48:59','SYNCED','2bbd50df-4190-4607-a3d7-f1d8663a4cb1',0,'2022-02-08 09:48:59','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.17.1.1.1 Occlusion 3\",\"referenceScanID\":\"1.17.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.17.1.1.1 Occlusion 3\"}'),(1001,'2c244ebd-a482-4040-8d47-befe574ac226','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a20364ca-68f6-43af-9d85-5203eb8e7fd3/session_4fbadc34-458e-4383-9cea-ff5422d69287/occlusion_56872db7-25ba-4ec4-a526-b4254011197f/scan_3360b3d3-3f88-47f7-a1ce-b4e540b8369c/49_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_a20364ca-68f6-43af-9d85-5203eb8e7fd3_ACT_4fbadc34-458e-4383-9cea-ff5422d69287_SESS_56872db7-25ba-4ec4-a526-b4254011197f_TOSC_3360b3d3-3f88-47f7-a1ce-b4e540b8369c_ZIP_','2022-10-28 10:08:06','2022-10-28 12:07:49','49_w1_o1_maxillaire_scan_file_1.zip','2022-10-28 12:08:06','SYNCED','93b583d3-838d-4554-b29d-bd2c88d92eac',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.49.1.1.1\",\"modelMatrix\":\"0.409616,0.893274,-0.18514,0,-0.912258,0.401092,-0.0831304,0,6.65698e-09,0.202947,0.97919,0,-22.4775,-11.9476,-18.3641,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'2c5f5cbb-b4e2-48d5-951b-8b45381f8520','','ZIP','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_LESC_0e74383c-84a7-4c1f-b833-adf54ce6a402_ZIP_','2022-09-10 08:18:25','2022-09-10 10:17:21','','2022-09-10 10:18:25','SYNCED','2c5f5cbb-b4e2-48d5-951b-8b45381f8520',0,'2022-09-10 10:18:25','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.39.1.1.11\",\"modelMatrix\":\"0.982905,0.0665172,0.172476,0,-0.0922199,0.979731,0.17838,0,-0.159442,-0.189045,0.968733,0,17.3596,5.98539,-12.3379,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'2c6b933a-f264-4897-b577-5fd0c5baa345','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/09688939-f53f-4f00-8366-687b244de26d/session_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525/occlusion_9655a7e0-4673-41c9-90da-a48c008e2d62/scan_8e48d6b3-b208-429e-bf9d-ca9d687d5008/64_w1_o1_mordu_posterieur_droit_snapshot_1.png','SNAPS','PATIENT_09688939-f53f-4f00-8366-687b244de26d_ACT_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525_SESS_9655a7e0-4673-41c9-90da-a48c008e2d62_RISC_8e48d6b3-b208-429e-bf9d-ca9d687d5008_SNAPS_','2023-03-30 12:14:00','2023-03-30 14:09:25','64_w1_o1_mordu_posterieur_droit_snapshot_1.png','2023-03-30 14:14:00','SYNCED','0e5e7fa9-337f-4ed4-b21e-329af32d059f',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.64.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'2c6d6160-5bc1-40c9-8604-7c7bf18ba87b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7f47fd88-9ea0-4c08-9193-a54d4f158c7c/session_7873a396-419c-4215-83c7-fec9f2742ccf/order_fea60d55-0fac-426f-9ae8-7c5f199dfe32/16_w1_inlay_onlay_prost_file_2c6d6160-5bc1-40c9-8604-7c7bf18ba87b_0.pdf','PDF','PATIENT_7f47fd88-9ea0-4c08-9193-a54d4f158c7c_ACT_7873a396-419c-4215-83c7-fec9f2742ccf_PROST_fea60d55-0fac-426f-9ae8-7c5f199dfe32_PDF_','2022-02-04 08:35:45','2022-02-04 09:35:44','16_w1_inlay_onlay_prost_file_2c6d6160-5bc1-40c9-8604-7c7bf18ba87b_0.pdf','2022-02-04 09:35:45','SYNCED','2c6d6160-5bc1-40c9-8604-7c7bf18ba87b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.16.1.1 INLAY ONLAY\",\"title\":\"Inlay/Onlay PDF\"}'),(1001,'2c913291-45f7-40f8-babb-b43e8e010db0','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/9e399d73-4d2e-4bb8-af48-a4e597811faa/session_b1cf14ce-00a9-48b6-8654-dadde26073f1/occlusion_3c4595e0-fbbb-4814-8851-1e014eb9a3b2/scan_dde349dc-caa1-49dc-8205-ba84c97567bf/46_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_9e399d73-4d2e-4bb8-af48-a4e597811faa_ACT_b1cf14ce-00a9-48b6-8654-dadde26073f1_SESS_3c4595e0-fbbb-4814-8851-1e014eb9a3b2_BOSC_dde349dc-caa1-49dc-8205-ba84c97567bf_SNAPS_','2022-11-24 13:34:02','2022-11-24 14:34:00','46_w1_o1_mandibule_snapshot_0.png','2022-11-24 14:34:02','SYNCED','2c913291-45f7-40f8-babb-b43e8e010db0',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.46.1.1.6\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'2c9dc5ab-4ca8-43c2-abc8-b66390f71327','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/533d4409-e39d-4a27-a0af-b59e6cf76ce3/session_319a8f1d-33fc-4f87-a108-b3eabda0510f/occlusion_3b38f07b-42cb-40b1-933f-365e568702e4/scan_450a38a9-baaa-443c-b15d-b73099c5ee33/37_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_533d4409-e39d-4a27-a0af-b59e6cf76ce3_ACT_319a8f1d-33fc-4f87-a108-b3eabda0510f_SESS_3b38f07b-42cb-40b1-933f-365e568702e4_BOSC_450a38a9-baaa-443c-b15d-b73099c5ee33_SNAPS_','2022-07-07 16:02:36','2022-07-07 18:02:27','37_w1_o1_mandibule_snapshot_0.png','2022-07-07 18:02:36','SYNCED','2c9dc5ab-4ca8-43c2-abc8-b66390f71327',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.37.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'2cc22f54-487a-4f31-9c45-34baa0398b64','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3cc1b522-8e7d-4196-87a1-a8c234f0a399/session_ef503949-33e8-4db6-bbfa-456bd8b70b73/occlusion_e8e2758f-faa4-4db7-93df-e94ddfbd8284/scan_f50e5124-f992-40b4-97cd-258bc3037b29/51_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_3cc1b522-8e7d-4196-87a1-a8c234f0a399_ACT_ef503949-33e8-4db6-bbfa-456bd8b70b73_SESS_e8e2758f-faa4-4db7-93df-e94ddfbd8284_TOSC_f50e5124-f992-40b4-97cd-258bc3037b29_SNAPS_','2022-11-28 16:47:55','2022-11-28 17:45:12','51_w1_o1_maxillaire_snapshot_0.png','2022-11-28 17:47:55','SYNCED','2cc22f54-487a-4f31-9c45-34baa0398b64',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.51.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'2cdb0d7a-4a22-4953-a430-1bf6d75a218e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/de078619-3946-4adb-a799-1c260e16face/session_24d0aeb5-3058-4070-aeea-97c289e41e3c/occlusion_ea6da896-1504-41fc-890c-7c48575e9e40/scan_aa24138a-68e8-4bc3-9a5d-d617f0fe496b/2_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_de078619-3946-4adb-a799-1c260e16face_ACT_24d0aeb5-3058-4070-aeea-97c289e41e3c_SESS_ea6da896-1504-41fc-890c-7c48575e9e40_TOSC_aa24138a-68e8-4bc3-9a5d-d617f0fe496b_SNAPS_','2022-01-19 14:01:46','2022-01-19 15:01:28','2_w1_o1_maxillaire_snapshot_0.png','2022-01-19 15:01:46','SYNCED','2cdb0d7a-4a22-4953-a430-1bf6d75a218e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.2.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'2d030be1-9ad7-4581-975c-79a53455eec0','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/7e3c8022-95d1-493b-ae19-1ef6f0fb92b7/session_6b1bf3f0-e6ca-4308-90a1-40913836e82b/occlusion_f99ad630-118e-4401-ab53-bf0f5d925052/scan_ed06ae65-ea48-4491-b69a-e35fe196bdb3/65_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_7e3c8022-95d1-493b-ae19-1ef6f0fb92b7_ACT_6b1bf3f0-e6ca-4308-90a1-40913836e82b_SESS_f99ad630-118e-4401-ab53-bf0f5d925052_BOSC_ed06ae65-ea48-4491-b69a-e35fe196bdb3_ZIP_','2023-03-31 14:54:50','2023-03-31 16:54:42','65_w1_o1_mandibule_scan_file_0.zip','2023-03-31 16:54:50','SYNCED','2d030be1-9ad7-4581-975c-79a53455eec0',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.65.1.1.1\",\"modelMatrix\":\"-0.497024,0.860176,-0.114303,0,-0.867737,-0.492693,0.0654708,0,-2.00275e-09,0.131726,0.991286,0,20.7778,-22.0263,-17.6433,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'2d19158c-3b80-44da-a89a-406e83a828ae','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_1c86378e-7d31-4b12-82ff-af797020160f/4_w1_o2_mandibule_snapshot_2.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_BOSC_1c86378e-7d31-4b12-82ff-af797020160f_SNAPS_','2022-03-08 11:40:04','2022-03-08 12:39:55','4_w1_o2_mandibule_snapshot_2.png','2022-03-08 12:40:04','SYNCED','a13ef72a-3421-4e8c-a897-3f43da14e842',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.2.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'2d3043c0-297c-496f-8bbc-bd852825beb8','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/75ce481f-6c44-4d16-a477-ea40c4fa6022/session_9bf7b056-ca4f-4dab-937b-619d0eb20528/occlusion_d7580529-3ede-4e27-a2ae-01849ba4d397/scan_a2d335cc-e544-4df4-9865-041740d97399/55_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_75ce481f-6c44-4d16-a477-ea40c4fa6022_ACT_9bf7b056-ca4f-4dab-937b-619d0eb20528_SESS_d7580529-3ede-4e27-a2ae-01849ba4d397_LESC_a2d335cc-e544-4df4-9865-041740d97399_SNAPS_','2022-12-22 10:34:40','2022-12-22 11:33:36','55_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-12-22 11:34:40','SYNCED','2d3043c0-297c-496f-8bbc-bd852825beb8',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.55.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'2d3ec2de-1984-4105-8e9d-9dc6be723be5','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a0c21836-ba79-4f15-9e35-02ef8211a9e5/session_0aac522d-3c38-465a-a1e0-014166c140ac/occlusion_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042/scan_b3e360d5-eb70-4046-910f-cbac3270fd6c/7_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_a0c21836-ba79-4f15-9e35-02ef8211a9e5_ACT_0aac522d-3c38-465a-a1e0-014166c140ac_SESS_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042_TOSC_b3e360d5-eb70-4046-910f-cbac3270fd6c_ZIP_','2022-01-21 11:45:25','2022-01-21 12:44:55','7_w1_o1_maxillaire_scan_file_1.zip','2022-01-21 12:45:25','SYNCED','7fc09fc3-81a3-49fd-a553-03ab9f8a113e',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.7.1.1.1\",\"modelMatrix\":\"-0.680945,0.720562,-0.130783,0,-0.732335,-0.669999,0.121606,0,-1.31378e-9,0.178584,0.983925,0,12.1717,-26.3212,-18.2196,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'2da411aa-1f1a-4e03-9645-da281ed894ff','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/occlusion_e08bbeeb-a30b-428c-bd4a-40198f792219/scan_fba3c050-83af-4c2f-a411-0975c46179ac/25_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_SESS_e08bbeeb-a30b-428c-bd4a-40198f792219_LESC_fba3c050-83af-4c2f-a411-0975c46179ac_SNAPS_','2022-05-17 16:40:17','2022-05-17 18:40:07','25_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-05-17 18:40:17','SYNCED','2da411aa-1f1a-4e03-9645-da281ed894ff',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.25.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'2ddc847f-ec82-429e-b529-37c074cacf57','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f4fc00ec-4af8-4a15-b427-f1c5aabf6260/session_498ae60a-23f0-44fc-9730-be499bfc4b46/occlusion_8f3d6c73-3468-45a5-85c7-93bba47ec9f7/scan_60c1cc80-0d70-4511-8993-70e3a3c146b8/30_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_f4fc00ec-4af8-4a15-b427-f1c5aabf6260_ACT_498ae60a-23f0-44fc-9730-be499bfc4b46_SESS_8f3d6c73-3468-45a5-85c7-93bba47ec9f7_BOSC_60c1cc80-0d70-4511-8993-70e3a3c146b8_ZIP_','2022-06-14 13:19:46','2022-06-14 15:19:39','30_w1_o1_mandibule_scan_file_1.zip','2022-06-14 15:19:46','SYNCED','c5123228-55c5-43a0-9a9c-7d17bd8cb24d',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.30.1.1.1\",\"modelMatrix\":\"-0.121583,0.970699,-0.207271,0,-0.992581,-0.118902,0.0253889,0,1.0676e-09,0.20882,0.977954,0,3.47051,-3.06677,-21.1986,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'2de8ced1-ba29-48f4-bc49-585a3648f21c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_6c9ae07a-23c3-4355-87ff-b57ef558a4ea/17_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_LESC_6c9ae07a-23c3-4355-87ff-b57ef558a4ea_SNAPS_','2022-02-11 16:09:33','2022-02-11 17:08:22','17_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-02-11 17:09:33','SYNCED','2de8ced1-ba29-48f4-bc49-585a3648f21c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.17.1.1.3\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'2e01a63c-1021-4a88-8ff7-135b62add7d5','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/452a5200-3e06-4b74-8949-6abc7f2dda8a/session_3e95d626-668f-45f7-98ad-be2cf9d7b90b/occlusion_bce8310f-eee9-4f0a-a6b7-d592dec66be5/computedocclusion_d9818808-7d5e-47e6-9880-cc95357483ff/26_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_452a5200-3e06-4b74-8949-6abc7f2dda8a_ACT_3e95d626-668f-45f7-98ad-be2cf9d7b90b_SESS_bce8310f-eee9-4f0a-a6b7-d592dec66be5_OCC_d9818808-7d5e-47e6-9880-cc95357483ff_TOMA__MATRX_','2022-05-24 09:43:00','2022-05-24 11:42:41','26_w1_o1_maxillaire_matrix_occ_file_0.m','2022-05-24 11:43:00','SYNCED','2e01a63c-1021-4a88-8ff7-135b62add7d5',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.26.1.1.2 Occlusion 2\",\"referenceScanID\":\"1.26.1.1.2\",\"title\":\"Matrice Transfo. Maxillaire 1.26.1.1.2 Occlusion 2\"}'),(1001,'2e04f411-6952-46e7-84ee-356ce3d09961','','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_BOSC_07148fa2-1d5b-4343-81f9-ef44df15e4c7_ZIP_','2022-02-19 17:53:23','2022-02-14 19:30:12','','2022-02-19 18:53:23','SYNCED','473be61f-e0c7-4b5b-97bc-a62aab17df37',1,'2022-02-19 18:53:23','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.4.2\",\"modelMatrix\":\"0.127972,0.961809,-0.241963,0,-0.991778,0.124105,-0.0312211,0,-1.70152e-09,0.243969,0.969783,0,5.86815,-42.128,-18.2425,1\",\"title\":\"Mandibule ZIP\"}'),(2,'2e4bff0b-2dc5-11ed-a752-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2e4bff0b-2dc5-11ed-a752-9ec33d03e6dd.png','SNAPS','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_21743037-e185-4ce7-80aa-af01b0d42c2d_SNAPS_','2022-09-06 09:20:42','2022-08-30 11:00:57','2e4bff0b-2dc5-11ed-a752-9ec33d03e6dd.png','2022-09-06 11:20:42','SYNCED','2e4bff0b-2dc5-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 371.3.1.1.6\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'2e4ec1fa-2dc5-11ed-a752-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2e4ec1fa-2dc5-11ed-a752-9ec33d03e6dd.png','SNAPS','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_b42f4445-ea70-4de5-bf5c-892a7b6eaa24_SNAPS_','2022-09-06 09:20:32','2022-08-30 10:57:23','2e4ec1fa-2dc5-11ed-a752-9ec33d03e6dd.png','2022-09-06 11:20:32','SYNCED','2e4ec1fa-2dc5-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 371.3.1.1.5\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'2e50706e-2dc5-11ed-a752-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2e50706e-2dc5-11ed-a752-9ec33d03e6dd.zip','ZIP','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_232c4a5c-d521-4972-9735-eb9d27cffedc_ZIP_','2022-09-06 09:20:42','2022-08-30 10:43:19','2e50706e-2dc5-11ed-a752-9ec33d03e6dd.zip','2022-09-06 11:20:42','SYNCED','2e50706e-2dc5-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 371.3.1.1.3\",\"modelMatrix\":\"0.807997,0.577429,-0.117121,0,-0.589187,0.791872,-0.160616,0,8.33841e-10,0.198783,0.980043,0,-28.159,-4.83121,-15.9851,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'2e5263fe-2dc5-11ed-a752-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2e5263fe-2dc5-11ed-a752-9ec33d03e6dd.zip','ZIP','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_53241704-034c-49e7-bd41-012398465214_ZIP_','2022-09-06 09:20:38','2022-08-30 10:39:58','2e5263fe-2dc5-11ed-a752-9ec33d03e6dd.zip','2022-09-06 11:20:38','SYNCED','2e5263fe-2dc5-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 371.3.1.1.2\",\"modelMatrix\":\"0.731042,0.662354,-0.163904,0,-0.682332,0.709638,-0.175604,0,-7.1534e-09,0.240211,0.970721,0,-27.4537,-9.8526,-16.0814,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'2e53e5e6-2dc5-11ed-a752-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2e53e5e6-2dc5-11ed-a752-9ec33d03e6dd.zip','ZIP','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_587e0605-ba57-4583-83e9-a1cc32707c91_ZIP_','2022-09-06 09:20:35','2022-08-30 10:53:39','2e53e5e6-2dc5-11ed-a752-9ec33d03e6dd.zip','2022-09-06 11:20:35','SYNCED','2e53e5e6-2dc5-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 371.3.1.1.4\",\"modelMatrix\":\"0.544914,0.827333,-0.136337,0,-0.838492,0.537663,-0.0886022,0,1.16965e-09,0.162599,0.986692,0,-24.1684,-16.3159,-16.3462,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'2e55ba84-2dc5-11ed-a752-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2e55ba84-2dc5-11ed-a752-9ec33d03e6dd.zip','ZIP','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_21743037-e185-4ce7-80aa-af01b0d42c2d_ZIP_','2022-09-06 09:17:55','2022-08-30 11:00:58','2e55ba84-2dc5-11ed-a752-9ec33d03e6dd.zip','2022-09-06 11:17:55','SYNCED','2e55ba84-2dc5-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 371.3.1.1.6\",\"modelMatrix\":\"0.884901,0.449075,-0.123616,0,-0.465778,0.853169,-0.234849,0,3.7488e-09,0.265396,0.96414,0,-28.3676,-3.7757,-16.7896,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'2e572fd3-2dc5-11ed-a752-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2e572fd3-2dc5-11ed-a752-9ec33d03e6dd.png','SNAPS','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_587e0605-ba57-4583-83e9-a1cc32707c91_SNAPS_','2022-09-06 09:17:50','2022-08-30 10:53:38','2e572fd3-2dc5-11ed-a752-9ec33d03e6dd.png','2022-09-06 11:17:50','SYNCED','2e572fd3-2dc5-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 371.3.1.1.4\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'2e5771c3-2656-438e-88f4-f38de1cdf014','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/fa7fa96b-f393-4b9a-8198-144702462cfa/session_4bed076c-8541-4a2f-800a-5aeb4cb49de5/occlusion_16b82fca-4b65-4866-af87-1f6dbb42f5dc/computedocclusion_94a0167c-6798-4c78-a76c-cb9fc91ccdda/35_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_fa7fa96b-f393-4b9a-8198-144702462cfa_ACT_4bed076c-8541-4a2f-800a-5aeb4cb49de5_SESS_16b82fca-4b65-4866-af87-1f6dbb42f5dc_OCC_94a0167c-6798-4c78-a76c-cb9fc91ccdda_TOPLY__ZIP_','2022-06-28 15:03:43','2022-06-28 17:03:25','35_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-06-28 17:03:43','SYNCED','2e5771c3-2656-438e-88f4-f38de1cdf014',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.35.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.09906,0.984988,-0.141374,0,-0.995081,0.0980552,-0.0140737,0,-1.38943e-09,0.142073,0.989856,0,-3.58695,-24.3271,-17.1724,1\",\"referenceScanID\":\"1.35.1.1.1\",\"title\":\"Maxillaire 1.35.1.1.1 Occlusion 1\"}'),(2,'2e58a3d5-2dc5-11ed-a752-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2e58a3d5-2dc5-11ed-a752-9ec33d03e6dd.png','SNAPS','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_53241704-034c-49e7-bd41-012398465214_SNAPS_','2022-09-06 09:17:50','2022-08-30 10:39:57','2e58a3d5-2dc5-11ed-a752-9ec33d03e6dd.png','2022-09-06 11:17:50','SYNCED','2e58a3d5-2dc5-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 371.3.1.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'2e5aa489-2dc5-11ed-a752-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2e5aa489-2dc5-11ed-a752-9ec33d03e6dd.zip','ZIP','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_f9a200bf-710b-4bad-a122-de56d5bc4da4_ZIP_','2022-09-06 09:20:32','2022-08-30 10:36:06','2e5aa489-2dc5-11ed-a752-9ec33d03e6dd.zip','2022-09-06 11:20:32','SYNCED','2e5aa489-2dc5-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 371.3.1.1.1\",\"modelMatrix\":\"0.68153,0.72027,-0.129336,0,-0.73179,0.670801,-0.120453,0,1.08731e-08,0.176739,0.984258,0,-27.3042,-9.55749,-15.1525,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'2e5c24fb-2dc5-11ed-a752-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2e5c24fb-2dc5-11ed-a752-9ec33d03e6dd.png','SNAPS','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_232c4a5c-d521-4972-9735-eb9d27cffedc_SNAPS_','2022-09-06 09:17:51','2022-08-30 10:43:18','2e5c24fb-2dc5-11ed-a752-9ec33d03e6dd.png','2022-09-06 11:17:51','SYNCED','2e5c24fb-2dc5-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 371.3.1.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'2e5d8de7-2dc5-11ed-a752-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2e5d8de7-2dc5-11ed-a752-9ec33d03e6dd.png','SNAPS','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_f9a200bf-710b-4bad-a122-de56d5bc4da4_SNAPS_','2022-09-06 09:17:46','2022-08-30 10:36:05','2e5d8de7-2dc5-11ed-a752-9ec33d03e6dd.png','2022-09-06 11:17:46','SYNCED','2e5d8de7-2dc5-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 371.3.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'2e5ef4e2-2dc5-11ed-a752-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/2e5ef4e2-2dc5-11ed-a752-9ec33d03e6dd.zip','ZIP','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_b42f4445-ea70-4de5-bf5c-892a7b6eaa24_ZIP_','2022-09-06 09:17:49','2022-08-30 10:57:24','2e5ef4e2-2dc5-11ed-a752-9ec33d03e6dd.zip','2022-09-06 11:17:49','SYNCED','2e5ef4e2-2dc5-11ed-a752-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 371.3.1.1.5\",\"modelMatrix\":\"0.797969,0.575965,-0.177509,0,-0.602698,0.762575,-0.235021,0,1.5203e-09,0.294523,0.955644,0,-29.1176,-8.59099,-15.2129,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'2e7ae315-b97e-4ae9-bc44-4dd1f711f7bc','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/09688939-f53f-4f00-8366-687b244de26d/session_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525/occlusion_9655a7e0-4673-41c9-90da-a48c008e2d62/scan_e8a97607-4009-48c5-b80b-9e6fdf2923ab/64_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_09688939-f53f-4f00-8366-687b244de26d_ACT_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525_SESS_9655a7e0-4673-41c9-90da-a48c008e2d62_TOSC_e8a97607-4009-48c5-b80b-9e6fdf2923ab_ZIP_','2023-03-30 11:43:36','2023-03-30 13:43:27','64_w1_o1_maxillaire_scan_file_0.zip','2023-03-30 13:43:36','SYNCED','2e7ae315-b97e-4ae9-bc44-4dd1f711f7bc',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.64.1.1.1\",\"modelMatrix\":\"0.460647,0.873533,-0.157302,0,-0.887583,0.453355,-0.0816383,0,-4.52836e-09,0.177225,0.98417,0,-5.15665,-26.4259,-23.755,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'2f456009-084f-47a4-8571-01bacb84934e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/scan_71f637a7-a4e5-4025-8ef3-6af04a8febfe/54_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_BOSC_71f637a7-a4e5-4025-8ef3-6af04a8febfe_SNAPS_','2022-12-13 09:37:11','2022-12-13 10:36:59','54_w1_o1_mandibule_snapshot_1.png','2022-12-13 10:37:11','SYNCED','61e3032d-2a22-4747-9fa6-a0eb3275ef87',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.54.1.1.4\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'2f656c4b-a2fa-4387-af79-da669c8f19dd','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/scan_a45e609a-ed7e-4f9d-a646-fcf505dd8590/22_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_RISC_a45e609a-ed7e-4f9d-a646-fcf505dd8590_SNAPS_','2022-04-21 11:27:47','2022-04-21 13:27:39','22_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-04-21 13:27:47','SYNCED','2f656c4b-a2fa-4387-af79-da669c8f19dd',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.22.1.1.5\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'2f75a784-e183-40f9-b781-9d47264b3a09','','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_BOSC_4aa73b1e-d6d0-436c-8abe-c649026c7ff2_SNAPS_','2022-02-19 17:53:23','2022-02-14 19:11:33','','2022-02-19 18:53:23','SYNCED','82b96208-37c7-4afb-8cb7-2139b6f0227e',1,'2022-02-19 18:53:23','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.4.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'2fb94557-be5e-48c5-9ff3-311d1acedadc','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/69640c87-271c-4a44-a6fa-67b01654cc27/session_5f9199b0-eb37-4ed3-8d1a-6c38505d4913/occlusion_991beec3-fe9e-4c98-a3d4-c98e4a4c2471/scan_6d0af0d8-98cb-48b6-aac5-3e0e3c3d7e7e/39_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_LESC_6d0af0d8-98cb-48b6-aac5-3e0e3c3d7e7e_SNAPS_','2022-09-09 16:43:33','2022-09-09 18:43:26','39_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-09-09 18:43:33','SYNCED','2fb94557-be5e-48c5-9ff3-311d1acedadc',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.39.1.1.8\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'2fd6a7b3-c6c9-4964-81b6-3e98bd0e2805','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/9efbbbe9-fd0a-44b1-988c-23571aad69fa/session_595a54fa-ae7d-4880-86a1-168b20242ecf/occlusion_b84a2165-e2d4-47e5-b110-a34bcaa24341/scan_25399088-5fa2-4516-946b-2a2df03a8440/53_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_9efbbbe9-fd0a-44b1-988c-23571aad69fa_ACT_595a54fa-ae7d-4880-86a1-168b20242ecf_SESS_b84a2165-e2d4-47e5-b110-a34bcaa24341_BOSC_25399088-5fa2-4516-946b-2a2df03a8440_ZIP_','2022-12-02 14:07:48','2022-12-02 15:07:28','53_w1_o1_mandibule_scan_file_0.zip','2022-12-02 15:07:48','SYNCED','2fd6a7b3-c6c9-4964-81b6-3e98bd0e2805',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.53.1.1.1\",\"modelMatrix\":\"-0.990609,0.10365,-0.089162,0,-0.136723,-0.750984,0.646011,0,9.14334e-09,0.652135,0.758103,0,24.3494,-3.00034,-19.6876,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'2feb5083-2342-4ea4-b23e-8a9e43aa5b65','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/fa7fa96b-f393-4b9a-8198-144702462cfa/session_4bed076c-8541-4a2f-800a-5aeb4cb49de5/occlusion_16b82fca-4b65-4866-af87-1f6dbb42f5dc/scan_07f2d366-54ce-478e-95a9-7ae35cfbc11a/35_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_fa7fa96b-f393-4b9a-8198-144702462cfa_ACT_4bed076c-8541-4a2f-800a-5aeb4cb49de5_SESS_16b82fca-4b65-4866-af87-1f6dbb42f5dc_LESC_07f2d366-54ce-478e-95a9-7ae35cfbc11a_SNAPS_','2022-06-28 15:03:04','2022-06-28 17:02:56','35_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-06-28 17:03:04','SYNCED','2feb5083-2342-4ea4-b23e-8a9e43aa5b65',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.35.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'303d11e3-0d3a-4c62-9d15-3ebe2e7bb93b','','ZIP','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_OCC_ac3a5a7c-5db4-4c82-a2a9-9cb52e09f003_BOPLY__ZIP_','2022-05-12 12:34:04','2022-05-12 14:33:34','','2022-05-12 14:34:04','SYNCED','303d11e3-0d3a-4c62-9d15-3ebe2e7bb93b',0,'2022-05-12 14:34:04','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.18.1.1.3 Occlusion 4\",\"modelMatrix\":\"-0.721265,0.622319,-0.304132,0,-0.69266,-0.648019,0.316692,0,5.59464e-09,0.439079,0.898449,0,-8.58806,-18.2472,-17.8803,1\",\"referenceScanID\":\"1.18.1.1.3\",\"title\":\"Mandibule 1.18.1.1.3 Occlusion 4\"}'),(1001,'30443cfd-cdb4-4ea3-87e5-17e124205f74','','SNAPS','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_OCC_ac3a5a7c-5db4-4c82-a2a9-9cb52e09f003_SNAPO__SNAPS_','2022-05-12 12:34:04','2022-05-12 14:33:33','',NULL,'CREATED','30443cfd-cdb4-4ea3-87e5-17e124205f74',0,'2022-05-12 14:34:04','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'306d6630-ab21-4773-9b55-279096ec07d2','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/32710234-804f-46f5-899d-eed636f8a906/session_64c1427a-b91d-4675-94df-f36bd40e9b0f/occlusion_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a/scan_3954e24e-9220-452b-a8fa-b1fbde6ebcad/33_w2_o1_mandibule_scan_file_2.zip','ZIP','PATIENT_32710234-804f-46f5-899d-eed636f8a906_ACT_64c1427a-b91d-4675-94df-f36bd40e9b0f_SESS_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a_BOSC_3954e24e-9220-452b-a8fa-b1fbde6ebcad_ZIP_','2022-06-28 09:03:24','2022-06-28 11:03:16','33_w2_o1_mandibule_scan_file_2.zip','2022-06-28 11:03:24','SYNCED','f83e0257-49c2-409b-a1b0-0c5bb674c327',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.33.2.1.1\",\"modelMatrix\":\"-0.911542,-0.410478,0.0244887,0,0.411207,-0.909924,0.0542853,0,-6.94447e-10,0.0595532,0.998225,0,18.7622,-5.69322,-17.7897,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'30720071-8a94-43cc-8fd5-1a603f6e4072','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/computedocclusion_00405f86-eefa-41f9-8d98-1fa9cbeef855/24_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_00405f86-eefa-41f9-8d98-1fa9cbeef855_BOPLY__ZIP_','2022-05-25 09:03:27','2022-05-25 11:02:54','24_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-05-25 11:03:27','SYNCED','30720071-8a94-43cc-8fd5-1a603f6e4072',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.24.1.1.1 Occlusion 4\",\"modelMatrix\":\"0.852703,-0.521011,0.0380208,0,0.522396,0.850441,-0.062061,0,3.49638e-10,0.0727815,0.997348,0,-11.3911,-12.8136,-21.1334,1\",\"referenceScanID\":\"1.24.1.1.1\",\"title\":\"Mandibule 1.24.1.1.1 Occlusion 4\"}'),(1001,'3091a3f3-f34b-4876-8a99-9c2aa5f3ac00','','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_812fdd67-c9dc-4e0c-806a-0524a386b296_BOPLY__ZIP_','2022-02-07 17:55:14','2022-02-07 18:54:30','',NULL,'CREATED','3091a3f3-f34b-4876-8a99-9c2aa5f3ac00',0,'2022-02-07 18:55:14','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.17.1.1.1 Occlusion 5\",\"modelMatrix\":\"-0.980954,-0.188901,0.0452269,0,0.19424,-0.953992,0.228406,0,1.35057e-9,0.232841,0.972515,0,27.4349,19.1019,-20.1379,1\",\"referenceScanID\":\"1.17.1.1.1\",\"title\":\"Mandibule 1.17.1.1.1 Occlusion 5\"}'),(1001,'30b88571-70e8-416c-bff4-b51ae86c7f7a','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/9e399d73-4d2e-4bb8-af48-a4e597811faa/session_b1cf14ce-00a9-48b6-8654-dadde26073f1/occlusion_1060c95f-48f4-4a37-9b82-03bfd8329730/computedocclusion_67e8fc2c-cca5-4b65-8153-f487421fc4e6/46_w1_o2_snapshot_occ_file_0.png','SNAPS','PATIENT_9e399d73-4d2e-4bb8-af48-a4e597811faa_ACT_b1cf14ce-00a9-48b6-8654-dadde26073f1_SESS_1060c95f-48f4-4a37-9b82-03bfd8329730_OCC_67e8fc2c-cca5-4b65-8153-f487421fc4e6_SNAPO__SNAPS_','2023-01-20 14:43:20','2023-01-20 15:42:49','46_w1_o2_snapshot_occ_file_0.png','2023-01-20 15:43:20','SYNCED','30b88571-70e8-416c-bff4-b51ae86c7f7a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'30d21ae5-2866-494e-8606-0d2109e784ca','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f9d03016-567a-4bd4-9cc5-dafeea34e365/session_a7bcb190-dd19-4f3b-8aab-266030bf4064/occlusion_c321e210-b67c-40e8-bece-f8946164a768/scan_90f9c577-02d8-45f3-9ac5-6c6cfeef1fa2/36_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_f9d03016-567a-4bd4-9cc5-dafeea34e365_ACT_a7bcb190-dd19-4f3b-8aab-266030bf4064_SESS_c321e210-b67c-40e8-bece-f8946164a768_BOSC_90f9c577-02d8-45f3-9ac5-6c6cfeef1fa2_SNAPS_','2022-07-04 13:53:56','2022-07-04 15:53:48','36_w1_o1_mandibule_snapshot_0.png','2022-07-04 15:53:56','SYNCED','30d21ae5-2866-494e-8606-0d2109e784ca',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.36.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'30e287e4-f479-42bb-a57e-e27ecab9f8ef','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/occlusion_a2220645-c79d-4dda-b6cc-772384a4106b/computedocclusion_8b14563e-0862-4cac-8045-e8aed2be886d/38_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_OCC_8b14563e-0862-4cac-8045-e8aed2be886d_BOPLY__ZIP_','2022-07-12 10:57:34','2022-07-12 12:57:24','38_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-07-12 12:57:34','SYNCED','30e287e4-f479-42bb-a57e-e27ecab9f8ef',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.38.1.1.1 Occlusion 1\",\"modelMatrix\":\"-0.751938,0.649871,-0.110711,0,-0.659234,-0.741259,0.12628,0,-8.33225e-09,0.167939,0.985797,0,9.41783,-30.192,-17.274,1\",\"referenceScanID\":\"1.38.1.1.1\",\"title\":\"Mandibule 1.38.1.1.1 Occlusion 1\"}'),(1001,'310be12a-f97b-4c8c-8065-7d80630c4591','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_ce625ba7-4218-40af-b344-df718da13f83/54_w1_o1_maxillaire_matrix_occ_file_4.m','MATRX','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_ce625ba7-4218-40af-b344-df718da13f83_TOMA__MATRX_','2023-03-15 10:27:03','2023-03-15 11:26:20','54_w1_o1_maxillaire_matrix_occ_file_4.m','2023-03-15 11:27:03','SYNCED','ccf7be44-96c0-48d2-80d6-833cb64e29bc',4,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.54.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.54.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.54.1.1.1 Occlusion 1\"}'),(1001,'315d2e9a-ddd6-479c-912b-2896b73d049c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_a1bc5849-382d-4646-be42-6c870a889494/24_w1_o1_mordu_anterieur_scan_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_FRSC_a1bc5849-382d-4646-be42-6c870a889494_ZIP_','2022-05-24 14:57:25','2022-05-24 16:57:18','24_w1_o1_mordu_anterieur_scan_file_0.zip','2022-05-24 16:57:25','SYNCED','315d2e9a-ddd6-479c-912b-2896b73d049c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.24.1.1.1\",\"modelMatrix\":\"0.965547,-0.014051,-0.254255,0,0.0237033,0.999946,-0.00528806,0,0.259318,-0.00901537,0.967193,0,-1.16124,-2.99844,-20.2046,1\",\"title\":\"Mordu anterieur ZIP\"}'),(1001,'317f0ec5-e31d-433b-8d49-a5a69338f5f2','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/de078619-3946-4adb-a799-1c260e16face/session_24d0aeb5-3058-4070-aeea-97c289e41e3c/occlusion_ea6da896-1504-41fc-890c-7c48575e9e40/scan_aa24138a-68e8-4bc3-9a5d-d617f0fe496b/2_w1_o1_maxillaire_snapshot_2.png','SNAPS','PATIENT_de078619-3946-4adb-a799-1c260e16face_ACT_24d0aeb5-3058-4070-aeea-97c289e41e3c_SESS_ea6da896-1504-41fc-890c-7c48575e9e40_TOSC_aa24138a-68e8-4bc3-9a5d-d617f0fe496b_SNAPS_','2022-01-19 14:09:10','2022-01-19 15:08:51','2_w1_o1_maxillaire_snapshot_2.png','2022-01-19 15:09:10','SYNCED','2cdb0d7a-4a22-4953-a430-1bf6d75a218e',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.2.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'31816ce0-6747-48aa-98ae-21ae0c6b8280','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/scan_2a38e9c2-6808-43f3-904a-decdb37d60d5/4_w1_o4_mandibule_scan_file_1.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_BOSC_2a38e9c2-6808-43f3-904a-decdb37d60d5_ZIP_','2022-05-31 12:05:57','2022-05-31 14:05:49','4_w1_o4_mandibule_scan_file_1.zip','2022-05-31 14:05:57','SYNCED','9d63c9e3-26ee-496a-aee1-ec6b35f881e5',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.4.1\",\"modelMatrix\":\"-0.693921,-0.706378,0.139651,0,0.720051,-0.680745,0.134584,0,-7.89603e-09,0.193947,0.981012,0,1.63985,-2.11708,-20.6571,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'3188c2ad-80df-4826-920c-b8f1b834ccf5','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_4ed7adaa-3b77-4537-8479-4d0c4bd28c7b/12_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_TOSC_4ed7adaa-3b77-4537-8479-4d0c4bd28c7b_ZIP_','2022-01-27 11:55:36','2022-01-27 12:55:01','12_w1_o1_maxillaire_scan_file_0.zip','2022-01-27 12:55:36','SYNCED','3188c2ad-80df-4826-920c-b8f1b834ccf5',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.12.1.1.1\",\"modelMatrix\":\"0.861363,0.502204,-0.0764579,0,-0.507991,0.85155,-0.129644,0,-4.79901e-9,0.15051,0.988608,0,-26.2767,-10.316,-20.7198,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'31df9b40-ce6a-441c-a253-232bfee6d11d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/computedocclusion_0d180e89-cc7f-4718-abf6-79b3ada7fd3c/4_w1_o2_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_OCC_0d180e89-cc7f-4718-abf6-79b3ada7fd3c_TOMA__MATRX_','2022-02-15 12:49:57','2022-02-15 13:49:40','4_w1_o2_maxillaire_matrix_occ_file_0.m','2022-02-15 13:49:57','SYNCED','31df9b40-ce6a-441c-a253-232bfee6d11d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.4.1.2.1 Occlusion 3\",\"referenceScanID\":\"1.4.1.2.1\",\"title\":\"Matrice Transfo. Maxillaire 1.4.1.2.1 Occlusion 3\"}'),(1001,'3208f8ef-621d-43b2-b795-42c3bda237c7','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/computedocclusion_35af1bf5-285a-4bb1-a6db-fe9897defe51/23_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_35af1bf5-285a-4bb1-a6db-fe9897defe51_BOPLY__ZIP_','2022-05-13 12:11:30','2022-05-13 14:11:07','23_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-05-13 14:11:30','SYNCED','3208f8ef-621d-43b2-b795-42c3bda237c7',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.23.1.1.1 Occlusion 4\",\"modelMatrix\":\"0.99884,-0.00870968,0.0473501,0,0.0481445,0.180697,-0.98236,0,-1.26898e-10,0.9835,0.180907,0,0.872294,-19.7028,-3.24839,1\",\"referenceScanID\":\"1.23.1.1.1\",\"title\":\"Mandibule 1.23.1.1.1 Occlusion 4\"}'),(1001,'3220ff46-caf1-419c-a89c-e443c01aed51','','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_26ae7fce-0ea3-479f-9989-7d0a3a19aaf7_BOPLY__ZIP_','2022-02-08 08:48:59','2022-02-07 18:58:31','','2022-02-08 09:48:59','SYNCED','3220ff46-caf1-419c-a89c-e443c01aed51',0,'2022-02-08 09:48:59','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.17.1.1.1 Occlusion 6\",\"modelMatrix\":\"-0.980954,-0.188901,0.0452269,0,0.19424,-0.953992,0.228406,0,1.35057e-9,0.232841,0.972515,0,27.4349,19.1019,-20.1379,1\",\"referenceScanID\":\"1.17.1.1.1\",\"title\":\"Mandibule 1.17.1.1.1 Occlusion 6\"}'),(1001,'323c571d-5135-43a3-8d38-00a71feaa843','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/computedocclusion_864c98a3-fcf7-466a-b999-13bd4dfb8c65/23_w1_o1_mlmeta_occ_file_to1000.bin','LIFIM','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_864c98a3-fcf7-466a-b999-13bd4dfb8c65_LIFIMO_LIFIM_','2022-05-25 08:32:44','2022-05-25 10:32:43','23_w1_o1_mlmeta_occ_file_to1000.bin','2022-05-25 10:32:44','SYNCED','323c571d-5135-43a3-8d38-00a71feaa843',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.23.1.1.1 Occlusion 3 Ligne de finition 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"Maxillaire\",\"name\":\"Ligne de finition 0\",\"title\":\"Ligne finition metadata\",\"toothNumber\":1000}'),(1001,'32a6b182-e758-48ff-8841-fb3488ac3fb5','','ZIP','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_55831d43-1906-4a22-9b7a-ed4b2820c8b2_SESS_4f582d4c-81d0-4e01-8be3-9ff53b12c7f4_BOSC_b36554f3-43ab-43e8-bcdf-e12f8de33163_ZIP_','2022-06-16 13:28:16','2022-06-16 15:25:25','','2022-06-16 15:28:16','SYNCED','32a6b182-e758-48ff-8841-fb3488ac3fb5',0,'2022-06-16 15:28:16','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.10.2.1.1\",\"modelMatrix\":\"-0.976999,0.178683,-0.116387,0,-0.213246,-0.818649,0.533236,0,8.11329e-09,0.54579,0.837922,0,-2.14335,-13.14,-16.6489,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'32c963db-937e-4097-9147-82e959d76ecf','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/computedocclusion_b903dd27-411a-4a7c-b357-1cc9a414dbdd/17_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_b903dd27-411a-4a7c-b357-1cc9a414dbdd_BOMA__MATRX_','2022-02-12 16:54:19','2022-02-12 17:53:18','17_w1_o1_mandibule_matrix_occ_file_0.m','2022-02-12 17:54:19','SYNCED','32c963db-937e-4097-9147-82e959d76ecf',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.17.1.1.2 Occlusion 7\",\"referenceScanID\":\"1.17.1.1.2\",\"title\":\"Matrice Transfo. Mandibule 1.17.1.1.2 Occlusion 7\"}'),(1001,'32e7ebda-fe42-4366-8d58-711e4a17f47f','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/09688939-f53f-4f00-8366-687b244de26d/session_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525/occlusion_9655a7e0-4673-41c9-90da-a48c008e2d62/computedocclusion_66955dfb-349e-49f8-89e5-06d0c4925036/64_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_09688939-f53f-4f00-8366-687b244de26d_ACT_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525_SESS_9655a7e0-4673-41c9-90da-a48c008e2d62_OCC_66955dfb-349e-49f8-89e5-06d0c4925036_TOPLY__ZIP_','2023-03-30 12:18:20','2023-03-30 14:18:05','64_w1_o1_maxillaire_occlusion_occ_file_0.zip','2023-03-30 14:18:20','SYNCED','32e7ebda-fe42-4366-8d58-711e4a17f47f',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.64.1.1.2 Occlusion 1\",\"modelMatrix\":\"0.932401,-0.356505,0.0594418,0,0.361426,0.919704,-0.153347,0,1.18293e-09,0.164464,0.986383,0,-0.151312,-4.2608,-23.1792,1\",\"referenceScanID\":\"1.64.1.1.2\",\"title\":\"Maxillaire 1.64.1.1.2 Occlusion 1\"}'),(1001,'330f51cf-ae9e-4420-bbab-1556708e4b2f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_e6c95ef7-636d-4c88-8d02-e2d9840573db/13_w1_o1_mandibule_scan_file_7.zip','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_e6c95ef7-636d-4c88-8d02-e2d9840573db_ZIP_','2022-01-27 16:49:56','2022-01-27 17:41:36','13_w1_o1_mandibule_scan_file_7.zip','2022-01-27 17:49:56','SYNCED','bcef8d3e-9632-4976-8cda-4c6f3ac50e99',7,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.1\",\"modelMatrix\":\"-0.988558,-0.14507,0.041326,0,0.150841,-0.950734,0.270835,0,9.21839e-10,0.27397,0.961738,0,25.2533,13.1486,-19.6942,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'33116074-3803-4c9a-9b0b-7f2ec0ea7b7f','','MATRX','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_OCC_d58ce31f-4b72-44ad-b0e0-3d5d7d789322_TOMA__MATRX_','2022-01-19 11:15:36','2022-01-19 12:06:18','',NULL,'CREATED','33116074-3803-4c9a-9b0b-7f2ec0ea7b7f',0,'2022-01-19 12:15:36','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.1.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.1.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.1.1.1.1 Occlusion 1\"}'),(1001,'3358903e-3e70-4a5e-927b-c3466331075a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/computedocclusion_77753fb3-75a1-45c2-9191-7a5d98206df2/24_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_77753fb3-75a1-45c2-9191-7a5d98206df2_TOPLY__ZIP_','2022-06-14 12:07:16','2022-06-14 14:06:33','24_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-06-14 14:07:16','SYNCED','3358903e-3e70-4a5e-927b-c3466331075a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.4 Occlusion 5\",\"modelMatrix\":\"0.468816,0.851463,-0.234993,0,-0.883296,0.451921,-0.124724,0,3.16254e-09,0.266041,0.963962,0,-15.9085,-5.48362,-18.8921,1\",\"referenceScanID\":\"1.24.1.1.4\",\"title\":\"Maxillaire 1.24.1.1.4 Occlusion 5\"}'),(1001,'33b3a130-dc00-43ca-a57f-6d86e6efa62c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/computedocclusion_e15a2d21-e8f2-4d2a-9a68-13d92ae4b997/13_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_OCC_e15a2d21-e8f2-4d2a-9a68-13d92ae4b997_TOMA__MATRX_','2022-02-04 18:25:04','2022-02-04 19:23:45','13_w1_o1_maxillaire_matrix_occ_file_0.m','2022-02-04 19:25:04','SYNCED','33b3a130-dc00-43ca-a57f-6d86e6efa62c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.13.1.1.3 Occlusion 3\",\"referenceScanID\":\"1.13.1.1.3\",\"title\":\"Matrice Transfo. Maxillaire 1.13.1.1.3 Occlusion 3\"}'),(1001,'33c1a04d-cbe7-4edc-920a-e235f4da07ff','','ZIP','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_OCC_ff8547d7-27f8-4862-9b63-e713dd817f3f_BOPLY__ZIP_','2022-09-09 17:04:15','2022-09-09 19:03:34','','2022-09-09 19:04:15','SYNCED','33c1a04d-cbe7-4edc-920a-e235f4da07ff',0,'2022-09-09 19:04:15','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.39.1.1.1 Occlusion 10\",\"modelMatrix\":\"-0.977808,0.200729,-0.0599951,0,-0.209503,-0.936857,0.280013,0,3.36067e-09,0.286368,0.95812,0,23.2439,5.67049,-19.9331,1\",\"referenceScanID\":\"1.39.1.1.1\",\"title\":\"Mandibule 1.39.1.1.1 Occlusion 10\"}'),(1001,'3404669d-d29f-41be-8f3a-d80595434b84','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_72adeb31-f7a3-4840-9f93-f10e61c84bef/4_w1_o2_maxillaire_snapshot_0.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_TOSC_72adeb31-f7a3-4840-9f93-f10e61c84bef_SNAPS_','2022-02-15 12:29:42','2022-02-15 13:29:29','4_w1_o2_maxillaire_snapshot_0.png','2022-02-15 13:29:42','SYNCED','3404669d-d29f-41be-8f3a-d80595434b84',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.4.1.2.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'344537a9-71f7-48c9-9243-57e6292e0241','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_2a7068fc-0efa-496f-ade9-aba5b0650655/12_w1_o1_mandibule_snapshot_6.png','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_2a7068fc-0efa-496f-ade9-aba5b0650655_SNAPS_','2022-02-04 12:11:39','2022-02-04 13:11:19','12_w1_o1_mandibule_snapshot_6.png','2022-02-04 13:11:39','SYNCED','7636e0d7-f242-431c-90a5-a65399d83ecd',6,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.5\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'34b47434-9215-4ffe-a7f7-4dea3dbc9904','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/scan_03839278-13f8-46e6-9581-ba11bc8bcb81/1_w1_o1_maxillaire_scan_file_4.zip','ZIP','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_BOSC_03839278-13f8-46e6-9581-ba11bc8bcb81_ZIP_','2022-01-19 13:02:33','2022-01-19 11:34:57','1_w1_o1_maxillaire_scan_file_4.zip','2022-01-19 14:02:33','SYNCED','96dd75bb-5035-460a-8afc-04f3755604b1',4,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.1.1.1.1\",\"modelMatrix\":\"-0.154277,0.952805,-0.261459,0,-0.988028,-0.148777,0.0408259,0,-2.59672e-9,0.264627,0.964351,0,-14.8611,-36.6101,-15.3158,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'34f73540-d33e-4cac-b0b5-c841527f88fa','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/39062d60-7a18-417a-9004-c58e9ce7d62a/session_9869e99c-7b47-4662-9766-0388d668fbf3/order_8d52ebe3-3a77-48e6-b388-728c70e0a461/61_w1_inlay_onlay_prost_file_34f73540-d33e-4cac-b0b5-c841527f88fa_0.pdf','PDF','PATIENT_39062d60-7a18-417a-9004-c58e9ce7d62a_ACT_9869e99c-7b47-4662-9766-0388d668fbf3_PROST_8d52ebe3-3a77-48e6-b388-728c70e0a461_PDF_','2023-03-11 15:31:21','2023-03-11 16:31:20','61_w1_inlay_onlay_prost_file_34f73540-d33e-4cac-b0b5-c841527f88fa_0.pdf','2023-03-11 16:31:21','SYNCED','34f73540-d33e-4cac-b0b5-c841527f88fa',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.61.1.1 INLAY ONLAY\",\"title\":\"Inlay/Onlay PDF\"}'),(1001,'352cc186-fca4-4aef-a7b3-20fcaf762580','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_9418414d-48f1-4a41-baa8-98bf650edaa3/4_w1_o2_mandibule_snapshot_0.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_BOSC_9418414d-48f1-4a41-baa8-98bf650edaa3_SNAPS_','2022-02-15 12:19:27','2022-02-15 13:19:18','4_w1_o2_mandibule_snapshot_0.png','2022-02-15 13:19:27','SYNCED','352cc186-fca4-4aef-a7b3-20fcaf762580',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.2.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'36168fc8-8ef4-4949-8aa2-4b37c94ba243','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_f4b07389-264e-4772-afc3-29b2187ced21/18_w1_o1_mordu_posterieur_gauche_scan_file_1.zip','ZIP','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_LESC_f4b07389-264e-4772-afc3-29b2187ced21_ZIP_','2022-03-07 14:43:38','2022-03-07 15:43:32','18_w1_o1_mordu_posterieur_gauche_scan_file_1.zip','2022-03-07 15:43:38','SYNCED','76566ef8-b89a-4fea-87e0-c9931b617c2a',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.18.1.1.1\",\"modelMatrix\":\"0.996698,-0.0718327,0.0141172,0,0.0785401,0.984466,0.159169,0,-0.022992,-0.160511,0.987162,0,-0.12545,-0.751174,-18.7896,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'364930dd-768b-468e-b083-7985c5a97ab0','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/ca43bf7b-f931-42fc-bb75-05929e4b6578/session_d9740504-a9ca-472a-83f2-a309fa225a98/occlusion_d663165c-f330-4c61-8d1f-14869b6d5edd/scan_2309dea5-c60e-4b30-bf0f-8b7989866185/59_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_ca43bf7b-f931-42fc-bb75-05929e4b6578_ACT_d9740504-a9ca-472a-83f2-a309fa225a98_SESS_d663165c-f330-4c61-8d1f-14869b6d5edd_LESC_2309dea5-c60e-4b30-bf0f-8b7989866185_SNAPS_','2023-03-10 14:25:32','2023-03-10 15:25:17','59_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2023-03-10 15:25:32','SYNCED','364930dd-768b-468e-b083-7985c5a97ab0',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.59.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'366fc470-5b13-4ffc-b7a3-48eab550846c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_04d6e3f1-19ce-4851-a9d0-40419cea7542/scan_fef6f617-40e8-4052-8a2d-9af9e39ab22d/19_w1_o2_mandibule_snapshot_1.png','SNAPS','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_04d6e3f1-19ce-4851-a9d0-40419cea7542_BOSC_fef6f617-40e8-4052-8a2d-9af9e39ab22d_SNAPS_','2022-04-15 14:02:29','2022-04-15 16:02:16','19_w1_o2_mandibule_snapshot_1.png','2022-04-15 16:02:29','SYNCED','5a1c3667-dbf3-4de6-af8e-149a263ba435',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.2.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'36a94f62-cceb-4886-91fa-b926e6c95a77','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_1c86378e-7d31-4b12-82ff-af797020160f/4_w1_o2_mandibule_scan_file_1.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_BOSC_1c86378e-7d31-4b12-82ff-af797020160f_ZIP_','2022-03-08 11:37:29','2022-03-08 12:37:22','4_w1_o2_mandibule_scan_file_1.zip','2022-03-08 12:37:29','SYNCED','bb22e8ec-52ef-47ae-acce-e63ab615a505',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.2.3\",\"modelMatrix\":\"0.9578,-0.285579,0.0326067,0,0.287435,0.951617,-0.108653,0,-5.99873e-10,0.113441,0.993545,0,-3.29225,5.66637,-21.5294,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'371bb9fd-905d-4943-84fd-cd6950c4032d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_59fb6872-6b71-417d-a7ee-ab313b732b6c/13_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_TOSC_59fb6872-6b71-417d-a7ee-ab313b732b6c_ZIP_','2022-02-04 17:55:02','2022-02-04 17:22:20','13_w1_o1_maxillaire_scan_file_0.zip','2022-02-04 18:55:02','SYNCED','371bb9fd-905d-4943-84fd-cd6950c4032d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.13.1.1.3\",\"modelMatrix\":\"0.754335,0.643596,-0.129474,0,-0.65649,0.739519,-0.148771,0,2.61688e-9,0.197222,0.980359,0,-9.25272,-30.1421,-17.7968,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'3776cf6f-78c5-4afd-b648-487e22bf22b0','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_7b68804e-41db-41a7-9a19-d1aaecf91ab5/17_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_LESC_7b68804e-41db-41a7-9a19-d1aaecf91ab5_ZIP_','2022-02-07 11:43:16','2022-02-07 12:40:31','17_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-02-07 12:43:16','SYNCED','3776cf6f-78c5-4afd-b648-487e22bf22b0',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.17.1.1.1\",\"modelMatrix\":\"-0.945111,-0.253993,0.211265,0,0.256252,-0.965583,0.00632607,0,0.202773,0.0563478,0.97742,0,13.1357,2.84484,-21.4488,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'379b2161-55d8-42d3-8e51-07c89c9a759a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/57c4096f-98dd-49c8-bea5-a5b109ad3fd0/session_4f62e395-5623-4d5b-869c-1b2fc4d22b00/occlusion_1ac20dc7-b36b-4786-a05f-37091554dc5c/scan_e2e4ad7f-c1c9-4c11-a41c-d237b2e0023e/31_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_57c4096f-98dd-49c8-bea5-a5b109ad3fd0_ACT_4f62e395-5623-4d5b-869c-1b2fc4d22b00_SESS_1ac20dc7-b36b-4786-a05f-37091554dc5c_BOSC_e2e4ad7f-c1c9-4c11-a41c-d237b2e0023e_ZIP_','2022-06-16 10:59:43','2022-06-16 12:59:34','31_w1_o1_mandibule_scan_file_0.zip','2022-06-16 12:59:43','SYNCED','379b2161-55d8-42d3-8e51-07c89c9a759a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.31.1.1.1\",\"modelMatrix\":\"0.252718,0.957401,-0.139701,0,-0.96754,0.25007,-0.0364895,0,-5.51629e-10,0.144388,0.989521,0,-10.0594,-15.8463,-16.5488,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'37e0d74e-736e-4545-a4af-6d91a77c9ce3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5/occlusion_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa/scan_e350f1fd-e88b-43c1-b1e6-a905c9a72ccf/24_w2_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5_SESS_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa_LESC_e350f1fd-e88b-43c1-b1e6-a905c9a72ccf_ZIP_','2022-10-06 14:50:09','2022-10-06 16:49:57','24_w2_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-10-06 16:50:09','SYNCED','37e0d74e-736e-4545-a4af-6d91a77c9ce3',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.24.2.1.1\",\"modelMatrix\":\"-0.94054,0.32818,0.335078,0,-0.444603,-0.933011,-0.187644,0,-0.036303,-0.212769,0.9642,0,23.8077,13.1309,-17.6168,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'3809472a-b874-44bf-95da-806137b1d16e','','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_d79359b0-a63e-4bdb-91ad-dec77d961970_ZIP_','2022-02-04 11:29:38','2022-02-04 09:36:23','','2022-02-04 12:29:38','SYNCED','3809472a-b874-44bf-95da-806137b1d16e',0,'2022-02-04 12:29:38','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.3\",\"modelMatrix\":\"-0.961822,0.259307,-0.0875072,0,-0.273675,-0.911329,0.307542,0,5.65717e-9,0.319749,0.947502,0,33.7925,-1.80222,-15.4388,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'3849fddc-f3cb-478d-a18e-2c953a47d6f2','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a9e7a1ae-2d71-448f-80f6-19d916912a3c/session_07012a03-2a1e-44e4-9bc9-17e726862bc2/occlusion_ab83a8b7-1eb1-4b13-9594-40d6479b2b19/scan_a1886540-b940-443f-ab31-a8c077fd49b6/52_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_a9e7a1ae-2d71-448f-80f6-19d916912a3c_ACT_07012a03-2a1e-44e4-9bc9-17e726862bc2_SESS_ab83a8b7-1eb1-4b13-9594-40d6479b2b19_BOSC_a1886540-b940-443f-ab31-a8c077fd49b6_ZIP_','2022-11-29 11:09:13','2022-11-29 12:09:12','52_w1_o1_maxillaire_scan_file_0.zip','2022-11-29 12:09:13','SYNCED','3849fddc-f3cb-478d-a18e-2c953a47d6f2',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.52.1.1.3\",\"modelMatrix\":\"-0.133335,0.962186,-0.237527,0,-0.991071,-0.129449,0.0319559,0,-4.94488e-10,0.239667,0.970855,0,-0.126405,-12.2612,-19.8023,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'3856e8f2-98c2-4dc1-939a-b53325f694b0','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a9e7a1ae-2d71-448f-80f6-19d916912a3c/session_07012a03-2a1e-44e4-9bc9-17e726862bc2/occlusion_ab83a8b7-1eb1-4b13-9594-40d6479b2b19/scan_e33a7de9-6d02-41e0-b621-fc99e53eb96c/52_w1_o1_mandibule_snapshot_4.png','SNAPS','PATIENT_a9e7a1ae-2d71-448f-80f6-19d916912a3c_ACT_07012a03-2a1e-44e4-9bc9-17e726862bc2_SESS_ab83a8b7-1eb1-4b13-9594-40d6479b2b19_BOSC_e33a7de9-6d02-41e0-b621-fc99e53eb96c_SNAPS_','2022-11-29 10:53:40','2022-11-29 11:53:30','52_w1_o1_mandibule_snapshot_4.png','2022-11-29 11:53:40','SYNCED','21764d52-2c8b-4d31-a0cd-af3f1985cd6e',4,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.52.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'3857c31f-4878-48ad-9ad9-5da851292116','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_909d9ecd-46b3-4692-868e-f6405507ecd1/24_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_TOSC_909d9ecd-46b3-4692-868e-f6405507ecd1_ZIP_','2022-05-13 14:40:37','2022-05-13 16:40:25','24_w1_o1_maxillaire_scan_file_0.zip','2022-05-13 16:40:37','SYNCED','3857c31f-4878-48ad-9ad9-5da851292116',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.2\",\"modelMatrix\":\"-0.781023,0.606576,-0.148558,0,-0.624502,-0.758603,0.185791,0,5.67908e-09,0.237882,0.971294,0,0.960311,-5.65425,-25.9345,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'390337fd-721e-490f-b704-0a456bfdee04','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/69640c87-271c-4a44-a6fa-67b01654cc27/session_5f9199b0-eb37-4ed3-8d1a-6c38505d4913/occlusion_991beec3-fe9e-4c98-a3d4-c98e4a4c2471/computedocclusion_c7bccd1e-370e-4347-8296-1bcd4c30b631/39_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_OCC_c7bccd1e-370e-4347-8296-1bcd4c30b631_TOPLY__ZIP_','2022-09-10 09:46:06','2022-09-10 11:45:43','39_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-09-10 11:46:06','SYNCED','390337fd-721e-490f-b704-0a456bfdee04',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.39.1.1.1 Occlusion 10\",\"modelMatrix\":\"-0.226177,0.929302,-0.291961,0,-0.974086,-0.215779,0.0677916,0,7.55513e-09,0.299728,0.954025,0,-12.3361,-28.543,-16.1754,1\",\"referenceScanID\":\"1.39.1.1.1\",\"title\":\"Maxillaire 1.39.1.1.1 Occlusion 10\"}'),(1001,'391def53-fd6d-47f4-9a89-7f3eeef7ecbe','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/69640c87-271c-4a44-a6fa-67b01654cc27/session_5f9199b0-eb37-4ed3-8d1a-6c38505d4913/occlusion_991beec3-fe9e-4c98-a3d4-c98e4a4c2471/scan_1ff80dd9-2d47-4292-adde-0923cb6fe572/39_w1_o1_mordu_anterieur_scan_file_0.zip','ZIP','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_FRSC_1ff80dd9-2d47-4292-adde-0923cb6fe572_ZIP_','2022-09-09 16:25:08','2022-09-09 18:25:01','39_w1_o1_mordu_anterieur_scan_file_0.zip','2022-09-09 18:25:08','SYNCED','391def53-fd6d-47f4-9a89-7f3eeef7ecbe',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.39.1.1.1\",\"modelMatrix\":\"0.79041,-0.155351,0.589854,0,0.108758,0.987952,0.0864821,0,-0.602972,-0.0109634,0.803053,0,3.79118,0.958309,-24.7208,1\",\"title\":\"Mordu anterieur ZIP\"}'),(1001,'3943b273-3c44-4676-9549-5fe85a49e6a8','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/computedocclusion_e9bfc750-6943-42bf-8c0b-b7e1dc1803c5/1_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_OCC_e9bfc750-6943-42bf-8c0b-b7e1dc1803c5_TOMA__MATRX_','2022-01-19 13:04:01','2022-01-19 12:12:14','1_w1_o1_maxillaire_matrix_occ_file_0.m','2022-01-19 14:04:01','SYNCED','3943b273-3c44-4676-9549-5fe85a49e6a8',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.1.1.1.1 Occlusion 2\",\"referenceScanID\":\"1.1.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.1.1.1.1 Occlusion 2\"}'),(1001,'395ffacb-e959-4db8-8895-8d4342bd04ad','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_165dc4ed-fa76-4753-970f-5b2176e3e023/13_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_RISC_165dc4ed-fa76-4753-970f-5b2176e3e023_SNAPS_','2022-02-04 17:55:12','2022-02-04 17:29:16','13_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-02-04 18:55:12','SYNCED','395ffacb-e959-4db8-8895-8d4342bd04ad',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.13.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'39cdef70-1950-497a-a4b8-6989adae5674','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f9d03016-567a-4bd4-9cc5-dafeea34e365/session_a7bcb190-dd19-4f3b-8aab-266030bf4064/occlusion_c321e210-b67c-40e8-bece-f8946164a768/scan_90f9c577-02d8-45f3-9ac5-6c6cfeef1fa2/36_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_f9d03016-567a-4bd4-9cc5-dafeea34e365_ACT_a7bcb190-dd19-4f3b-8aab-266030bf4064_SESS_c321e210-b67c-40e8-bece-f8946164a768_BOSC_90f9c577-02d8-45f3-9ac5-6c6cfeef1fa2_SNAPS_','2022-07-04 13:58:41','2022-07-04 15:58:32','36_w1_o1_mandibule_snapshot_1.png','2022-07-04 15:58:41','SYNCED','30d21ae5-2866-494e-8606-0d2109e784ca',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.36.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'3a16e517-144b-422c-8b55-f03ff1c5b7f7','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/occlusion_e08bbeeb-a30b-428c-bd4a-40198f792219/scan_ef1d20c7-5f61-4c35-8f0f-d85507cab786/25_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_SESS_e08bbeeb-a30b-428c-bd4a-40198f792219_BOSC_ef1d20c7-5f61-4c35-8f0f-d85507cab786_SNAPS_','2022-05-17 16:13:04','2022-05-17 18:12:53','25_w1_o1_mandibule_snapshot_1.png','2022-05-17 18:13:04','SYNCED','135e8c27-bf0a-4d0f-b495-291e99638543',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.25.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'3a2c2a2d-3f6a-4837-b856-033002eb1273','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_ce625ba7-4218-40af-b344-df718da13f83/54_w1_o1_mandibule_occlusion_occ_file_7.zip','ZIP','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_ce625ba7-4218-40af-b344-df718da13f83_BOPLY__ZIP_','2023-03-15 10:34:22','2023-03-15 11:32:28','54_w1_o1_mandibule_occlusion_occ_file_7.zip','2023-03-15 11:34:22','SYNCED','d1adede1-c3da-47da-a47c-075f5a6fe836',7,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.54.1.1.4 Occlusion 1\",\"modelMatrix\":\"-0.999599,0.0258183,-0.0116515,0,-0.0283256,-0.911116,0.411175,0,-3.36598e-10,0.41134,0.911482,0,17.4173,6.0967,-21.0427,1\",\"referenceScanID\":\"1.54.1.1.4\",\"title\":\"Mandibule 1.54.1.1.4 Occlusion 1\"}'),(1001,'3a2cd8ae-78bd-4479-87b5-e22f52cf10d1','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/computedocclusion_b35629de-38d8-4cdd-bf2c-b61c461410cb/17_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_b35629de-38d8-4cdd-bf2c-b61c461410cb_BOMA__MATRX_','2022-02-07 18:07:23','2022-02-07 19:05:55','17_w1_o1_mandibule_matrix_occ_file_0.m','2022-02-07 19:07:23','SYNCED','3a2cd8ae-78bd-4479-87b5-e22f52cf10d1',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.17.1.1.1 Occlusion 6\",\"referenceScanID\":\"1.17.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.17.1.1.1 Occlusion 6\"}'),(1001,'3a3b3288-ed82-415d-8fb9-20b3ce5b6990','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7f47fd88-9ea0-4c08-9193-a54d4f158c7c/session_7873a396-419c-4215-83c7-fec9f2742ccf/occlusion_2e287bb0-e19a-414a-9177-23b335d286d9/scan_817e3173-ed5b-4bb7-93d5-bc02ec7eb79b/16_w1_o2_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_7f47fd88-9ea0-4c08-9193-a54d4f158c7c_ACT_7873a396-419c-4215-83c7-fec9f2742ccf_SESS_2e287bb0-e19a-414a-9177-23b335d286d9_RISC_817e3173-ed5b-4bb7-93d5-bc02ec7eb79b_ZIP_','2022-06-03 09:04:19','2022-06-03 11:04:12','16_w1_o2_mordu_posterieur_droit_scan_file_0.zip','2022-06-03 11:04:19','SYNCED','3a3b3288-ed82-415d-8fb9-20b3ce5b6990',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.16.1.2.1\",\"modelMatrix\":\"0.970745,-0.237229,-0.0275537,0,0.239874,0.951918,0.193352,0,-0.0128356,-0.193843,0.980768,0,-5.81621,9.44461,-17.517,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'3a6d9be4-fd1a-4da7-a56f-657c83be58a6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/scan_2a38e9c2-6808-43f3-904a-decdb37d60d5/4_w1_o4_mandibule_snapshot_1.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_BOSC_2a38e9c2-6808-43f3-904a-decdb37d60d5_SNAPS_','2022-05-31 12:05:57','2022-05-31 14:05:48','4_w1_o4_mandibule_snapshot_1.png','2022-05-31 14:05:57','SYNCED','fdb57445-483a-4c6d-abea-e77292f019f1',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.4.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'3af8da16-1c78-4867-83f5-40af48dbf8ae','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/computedocclusion_0bc29ff9-efea-448d-b521-2c39fd4faa78/19_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_OCC_0bc29ff9-efea-448d-b521-2c39fd4faa78_TOPLY__ZIP_','2022-03-08 11:18:04','2022-03-08 12:17:37','19_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-03-08 12:18:04','SYNCED','3af8da16-1c78-4867-83f5-40af48dbf8ae',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.19.1.1.1 Occlusion 3\",\"modelMatrix\":\"0.985752,-0.166051,0.0268482,0,0.168208,0.973114,-0.157339,0,2.19633e-09,0.159614,0.98718,0,-32.9792,-5.96138,-23.3688,1\",\"referenceScanID\":\"1.19.1.1.1\",\"title\":\"Maxillaire 1.19.1.1.1 Occlusion 3\"}'),(1001,'3b0eba2e-2de6-4ec7-83c9-1e2c7c8ff4da','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/occlusion_a2220645-c79d-4dda-b6cc-772384a4106b/computedocclusion_cf412dab-1d83-4db0-ae1b-d2724d5be97d/38_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_OCC_cf412dab-1d83-4db0-ae1b-d2724d5be97d_TOMA__MATRX_','2022-07-12 11:04:31','2022-07-12 13:04:14','38_w1_o1_maxillaire_matrix_occ_file_0.m','2022-07-12 13:04:31','SYNCED','3b0eba2e-2de6-4ec7-83c9-1e2c7c8ff4da',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.38.1.1.3 Occlusion 2\",\"referenceScanID\":\"1.38.1.1.3\",\"title\":\"Matrice Transfo. Maxillaire 1.38.1.1.3 Occlusion 2\"}'),(1001,'3b1b8529-9696-4bae-8527-ef23772fe66a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/computedocclusion_704a0750-2a24-448f-8f30-928139977895/4_w1_o2_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_OCC_704a0750-2a24-448f-8f30-928139977895_BOPLY__ZIP_','2022-03-08 11:49:43','2022-03-08 12:49:34','4_w1_o2_mandibule_occlusion_occ_file_0.zip','2022-03-08 12:49:43','SYNCED','3b1b8529-9696-4bae-8527-ef23772fe66a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.2.3 Occlusion 4\",\"modelMatrix\":\"0.966621,-0.254359,0.0307347,0,0.256209,0.959641,-0.115955,0,1.29208e-09,0.119959,0.992779,0,-3.1268,5.20706,-21.613,1\",\"referenceScanID\":\"1.4.1.2.3\",\"title\":\"Mandibule 1.4.1.2.3 Occlusion 4\"}'),(1001,'3b51e795-dcfd-4ab7-87b5-b113cb1c8e09','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/4fa1a134-d246-43d7-aa8c-b42e24b62b49/session_6aedf6fd-46d7-4259-88ba-5cf074ad5913/occlusion_47192ebb-25b6-4c9e-a09f-8ed295e60a87/scan_08beae91-887f-4723-8e18-ef9fee36100e/60_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_4fa1a134-d246-43d7-aa8c-b42e24b62b49_ACT_6aedf6fd-46d7-4259-88ba-5cf074ad5913_SESS_47192ebb-25b6-4c9e-a09f-8ed295e60a87_BOSC_08beae91-887f-4723-8e18-ef9fee36100e_ZIP_','2023-03-07 18:07:00','2023-03-07 19:06:48','60_w1_o1_mandibule_scan_file_0.zip','2023-03-07 19:07:00','SYNCED','3b51e795-dcfd-4ab7-87b5-b113cb1c8e09',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.60.1.1.1\",\"modelMatrix\":\"-0.934961,-0.350818,0.0526851,0,0.354752,-0.924592,0.138853,0,-3.4757e-09,0.148513,0.98891,0,15.5016,1.56368,-18.1586,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'3b721ecd-c4ae-405a-9689-c48a7fb70e2b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/occlusion_e08bbeeb-a30b-428c-bd4a-40198f792219/scan_ef1d20c7-5f61-4c35-8f0f-d85507cab786/25_w1_o1_mandibule_snapshot_3.png','SNAPS','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_SESS_e08bbeeb-a30b-428c-bd4a-40198f792219_BOSC_ef1d20c7-5f61-4c35-8f0f-d85507cab786_SNAPS_','2022-05-17 16:18:51','2022-05-17 18:18:39','25_w1_o1_mandibule_snapshot_3.png','2022-05-17 18:18:51','SYNCED','135e8c27-bf0a-4d0f-b495-291e99638543',3,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.25.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'3ba9a25c-db9a-443b-a917-fb6c9cc3c459','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5a33a64b-822d-40bf-ba8c-e11c11a50f88/session_e0a7776f-79fe-4c85-85ab-9ca244e7ff95/occlusion_b3568df2-4c54-486e-b27f-2d92375e5d11/scan_247ba975-b9ca-41c4-8c63-f046d64da761/43_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_5a33a64b-822d-40bf-ba8c-e11c11a50f88_ACT_e0a7776f-79fe-4c85-85ab-9ca244e7ff95_SESS_b3568df2-4c54-486e-b27f-2d92375e5d11_BOSC_247ba975-b9ca-41c4-8c63-f046d64da761_ZIP_','2022-10-11 14:19:37','2022-10-11 16:19:26','43_w1_o1_mandibule_scan_file_0.zip','2022-10-11 16:19:37','SYNCED','3ba9a25c-db9a-443b-a917-fb6c9cc3c459',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.43.1.1.1\",\"modelMatrix\":\"-0.59285,0.762988,-0.257639,0,-0.805313,-0.561692,0.189667,0,-4.90946e-09,0.319925,0.947443,0,25.4067,-18.7883,-18.6039,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'3bb8eac0-63a6-4387-9a98-98544c546250','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/7c3827a5-fcb4-4892-bab3-8d6a4e6382f0/session_cb98e8a0-e16d-4640-919e-9b968e57d3db/occlusion_29633526-06c5-413c-8029-9f27d6a28b53/scan_ab6c69b1-8cac-45ec-8fee-f2371813f161/63_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_7c3827a5-fcb4-4892-bab3-8d6a4e6382f0_ACT_cb98e8a0-e16d-4640-919e-9b968e57d3db_SESS_29633526-06c5-413c-8029-9f27d6a28b53_TOSC_ab6c69b1-8cac-45ec-8fee-f2371813f161_SNAPS_','2023-03-20 14:34:20','2023-03-20 15:33:21','63_w1_o1_maxillaire_snapshot_1.png','2023-03-20 15:34:20','SYNCED','4c80ac2a-8eb6-49d9-a363-ce9ac5090d47',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.63.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'3bf97384-e1d6-4d83-b9a8-0e3c85f73174','','SNAPS','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_LESC_890154d7-23d4-4fb6-a767-967ce5a423f7_SNAPS_','2022-09-09 16:30:34','2022-09-09 18:19:24','','2022-09-09 18:30:34','SYNCED','3bf97384-e1d6-4d83-b9a8-0e3c85f73174',0,'2022-09-09 18:30:34','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.39.1.1.2\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'3c40df65-b847-40a7-b508-d8fe1ff90b07','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/computedocclusion_b903dd27-411a-4a7c-b357-1cc9a414dbdd/17_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_b903dd27-411a-4a7c-b357-1cc9a414dbdd_SNAPO__SNAPS_','2022-02-12 16:54:34','2022-02-12 17:53:18','17_w1_o1_snapshot_occ_file_0.png','2022-02-12 17:54:34','SYNCED','3c40df65-b847-40a7-b508-d8fe1ff90b07',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'3c4fadd2-de7f-4837-8bbb-4f30b68e8540','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/scan_c1f909ab-5469-4839-84f1-d04759dd1237/1_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_BOSC_c1f909ab-5469-4839-84f1-d04759dd1237_ZIP_','2022-01-19 13:00:20','2022-01-19 11:56:08','1_w1_o1_mandibule_scan_file_1.zip','2022-01-19 14:00:20','SYNCED','9dd0c754-d272-45ee-aa54-5d3030ae4573',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.1.1.1.1\",\"modelMatrix\":\"-0.89361,0.44322,-0.0708281,0,-0.448843,-0.882414,0.141013,0,3.36694e-10,0.157801,0.987471,0,37.1181,-2.30066,-14.9109,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'3c6ed131-ba11-4faa-961a-eaab48218ae3','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/3a170256-4132-4b56-ad27-b2cc7790bbf8/session_c57164ce-3f15-42b7-a8dc-96ab6a136184/occlusion_4779508f-bef4-4a89-9555-58b917369f06/computedocclusion_c02aa6d3-8bb3-4ebb-ae67-2dc59b73bc9f/62_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_3a170256-4132-4b56-ad27-b2cc7790bbf8_ACT_c57164ce-3f15-42b7-a8dc-96ab6a136184_SESS_4779508f-bef4-4a89-9555-58b917369f06_OCC_c02aa6d3-8bb3-4ebb-ae67-2dc59b73bc9f_BOMA__MATRX_','2023-03-14 09:15:25','2023-03-13 10:51:53','62_w1_o1_mandibule_matrix_occ_file_0.m','2023-03-14 10:15:25','SYNCED','3c6ed131-ba11-4faa-961a-eaab48218ae3',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.62.1.1.1 Occlusion 2\",\"referenceScanID\":\"1.62.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.62.1.1.1 Occlusion 2\"}'),(1001,'3cdf761f-0ac4-4f73-9f0e-c766ac406760','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_e6c95ef7-636d-4c88-8d02-e2d9840573db/13_w1_o1_mandibule_scan_file_5.zip','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_e6c95ef7-636d-4c88-8d02-e2d9840573db_ZIP_','2022-01-27 16:41:22','2022-01-27 17:40:39','13_w1_o1_mandibule_scan_file_5.zip','2022-01-27 17:41:22','SYNCED','bcef8d3e-9632-4976-8cda-4c6f3ac50e99',5,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.1\",\"modelMatrix\":\"-0.988558,-0.14507,0.041326,0,0.150841,-0.950734,0.270835,0,9.21839e-10,0.27397,0.961738,0,25.2533,13.1486,-19.6942,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'3d3712b8-d105-4369-a45d-93e76bd3c1f4','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_2ffbfbca-f236-4802-be93-8eb43d523274/scan_0bd54e85-3f0d-4955-9f02-7de656ad9f6f/4_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_2ffbfbca-f236-4802-be93-8eb43d523274_BOSC_0bd54e85-3f0d-4955-9f02-7de656ad9f6f_ZIP_','2022-01-19 19:04:35','2022-01-19 20:04:16','4_w1_o1_mandibule_scan_file_0.zip','2022-01-19 20:04:35','SYNCED','3d3712b8-d105-4369-a45d-93e76bd3c1f4',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.1.1\",\"modelMatrix\":\"-0.879502,0.457057,-0.13257,0,-0.475895,-0.844688,0.245003,0,-6.19601e-9,0.278571,0.960416,0,9.76271,-0.876021,-18.4238,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'3d3e6fc9-1b61-46d1-b1fb-dd751fd87239','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_ce625ba7-4218-40af-b344-df718da13f83/54_w1_o1_mandibule_matrix_occ_file_6.m','MATRX','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_ce625ba7-4218-40af-b344-df718da13f83_BOMA__MATRX_','2023-03-15 10:35:04','2023-03-15 11:32:26','54_w1_o1_mandibule_matrix_occ_file_6.m','2023-03-15 11:35:04','SYNCED','45775437-46ca-4831-b788-61b2ad12ff31',6,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.54.1.1.4 Occlusion 1\",\"referenceScanID\":\"1.54.1.1.4\",\"title\":\"Matrice Transfo. Mandibule 1.54.1.1.4 Occlusion 1\"}'),(1001,'3d5df199-9409-4f8d-bf73-4781ba4e8261','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/09688939-f53f-4f00-8366-687b244de26d/session_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525/occlusion_9655a7e0-4673-41c9-90da-a48c008e2d62/computedocclusion_31e93f44-4fae-454e-8c7b-c76251c61d92/64_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_09688939-f53f-4f00-8366-687b244de26d_ACT_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525_SESS_9655a7e0-4673-41c9-90da-a48c008e2d62_OCC_31e93f44-4fae-454e-8c7b-c76251c61d92_TOPLY__ZIP_','2023-03-30 12:19:49','2023-03-30 14:19:34','64_w1_o1_maxillaire_occlusion_occ_file_0.zip','2023-03-30 14:19:49','SYNCED','3d5df199-9409-4f8d-bf73-4781ba4e8261',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.64.1.1.1 Occlusion 3\",\"modelMatrix\":\"0.262761,0.950949,-0.163255,0,-0.964861,0.258973,-0.0444592,0,7.53834e-10,0.1692,0.985582,0,-0.434737,-26.6333,-23.8847,1\",\"referenceScanID\":\"1.64.1.1.1\",\"title\":\"Maxillaire 1.64.1.1.1 Occlusion 3\"}'),(1001,'3d6c789e-b9c2-4ef8-8fa6-d943d1f54eda','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/8fc74d9e-a5a0-46bf-be3f-500548a130ad/session_5368829e-7dec-4775-a487-a1019f9604f4/occlusion_bb63a653-1b34-4d80-a4bf-7fda5c9b0360/scan_3e9aff47-e0ac-4b19-973d-d25c0bab00c9/14_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_8fc74d9e-a5a0-46bf-be3f-500548a130ad_ACT_5368829e-7dec-4775-a487-a1019f9604f4_SESS_bb63a653-1b34-4d80-a4bf-7fda5c9b0360_LESC_3e9aff47-e0ac-4b19-973d-d25c0bab00c9_SNAPS_','2022-02-01 10:49:09','2022-02-01 11:48:59','14_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-02-01 11:49:09','SYNCED','3d6c789e-b9c2-4ef8-8fa6-d943d1f54eda',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.14.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'3d6d5801-910c-4d3d-9e99-e429d1716fc0','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/occlusion_e08bbeeb-a30b-428c-bd4a-40198f792219/scan_dee5ca38-e252-41d1-86ca-aebc66ae36fa/25_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_SESS_e08bbeeb-a30b-428c-bd4a-40198f792219_TOSC_dee5ca38-e252-41d1-86ca-aebc66ae36fa_ZIP_','2022-05-17 16:34:51','2022-05-17 18:34:39','25_w1_o1_maxillaire_scan_file_1.zip','2022-05-17 18:34:51','SYNCED','d240ab40-d14e-490e-b3b7-2c5295c6f83e',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.25.1.1.1\",\"modelMatrix\":\"0.999921,-0.0124601,0.00173472,0,0.0125803,0.990369,-0.137881,0,5.51735e-11,0.137892,0.990447,0,12.823,6.75113,-24.6355,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'3dbf1334-fddd-48c1-8621-612a8780a8c5','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_cfcda3c3-749c-4f3d-96e2-556ed558ceef/18_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_TOSC_cfcda3c3-749c-4f3d-96e2-556ed558ceef_SNAPS_','2022-03-07 14:03:59','2022-03-07 15:03:43','18_w1_o1_maxillaire_snapshot_0.png','2022-03-07 15:03:59','SYNCED','3dbf1334-fddd-48c1-8621-612a8780a8c5',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.18.1.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'3df3b792-f18b-49d4-beac-3217e8ae5db8','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/98aa55d8-3848-48e0-9684-5597786b85c7/session_4df1e430-5cbb-4a6c-8292-747e35e6f1e8/occlusion_fcc5c65d-b0e4-4036-99c7-07318171986a/computedocclusion_f2517330-f76d-418d-8d59-e56eb543a090/66_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_98aa55d8-3848-48e0-9684-5597786b85c7_ACT_4df1e430-5cbb-4a6c-8292-747e35e6f1e8_SESS_fcc5c65d-b0e4-4036-99c7-07318171986a_OCC_f2517330-f76d-418d-8d59-e56eb543a090_BOPLY__ZIP_','2023-04-13 10:07:20','2023-04-13 12:07:20','66_w1_o1_mandibule_occlusion_occ_file_0.zip',NULL,'CREATED','3df3b792-f18b-49d4-beac-3217e8ae5db8',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.66.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.66.1.1.1\",\"title\":\"Mandibule 1.66.1.1.1 Occlusion 1\"}'),(1001,'3dfb9122-354d-485f-b43b-e2274d9b20d4','','SNAPS','PATIENT_452a5200-3e06-4b74-8949-6abc7f2dda8a_ACT_3e95d626-668f-45f7-98ad-be2cf9d7b90b_SESS_bce8310f-eee9-4f0a-a6b7-d592dec66be5_TOSC_0cdd9706-bf86-43f6-8f49-976542e5b9e8_SNAPS_','2022-05-24 09:15:25','2022-05-24 11:07:54','','2022-05-24 11:15:25','SYNCED','3dfb9122-354d-485f-b43b-e2274d9b20d4',0,'2022-05-24 11:15:25','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.26.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'3e073d59-562e-47d2-8488-a683f9596818','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/order_db4fa824-a30d-4200-8214-b45494eafbf7/23_w1_couronne_prost_file_3e073d59-562e-47d2-8488-a683f9596818_0.pdf','PDF','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_PROST_db4fa824-a30d-4200-8214-b45494eafbf7_PDF_','2022-05-13 11:41:15','2022-05-13 13:41:14','23_w1_couronne_prost_file_3e073d59-562e-47d2-8488-a683f9596818_0.pdf','2022-05-13 13:41:15','SYNCED','3e073d59-562e-47d2-8488-a683f9596818',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.23.1.1 COURONNE\",\"title\":\"Couronne PDF\"}'),(1001,'3e0d35f8-875e-422d-bc56-7cb045ef8991','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5a33a64b-822d-40bf-ba8c-e11c11a50f88/session_e0a7776f-79fe-4c85-85ab-9ca244e7ff95/occlusion_b3568df2-4c54-486e-b27f-2d92375e5d11/scan_247ba975-b9ca-41c4-8c63-f046d64da761/43_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_5a33a64b-822d-40bf-ba8c-e11c11a50f88_ACT_e0a7776f-79fe-4c85-85ab-9ca244e7ff95_SESS_b3568df2-4c54-486e-b27f-2d92375e5d11_BOSC_247ba975-b9ca-41c4-8c63-f046d64da761_SNAPS_','2022-10-11 14:26:44','2022-10-11 16:24:34','43_w1_o1_mandibule_snapshot_1.png','2022-10-11 16:26:44','SYNCED','efbd6501-309a-4221-ba17-9bd17593040c',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.43.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'3e12665e-3464-414d-b006-973919ddbaa1','','ZIP','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_BOSC_3379235c-b42d-440c-84bc-d105a1d56127_ZIP_','2022-03-09 07:54:47','2022-03-08 11:29:35','','2022-03-09 08:54:47','SYNCED','91e77307-7833-49da-b522-a802584e820d',1,'2022-03-09 08:54:47','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.1.2\",\"modelMatrix\":\"0.688357,-0.67065,0.276395,0,0.725372,0.636426,-0.262291,0,-8.0385e-09,0.381039,0.924559,0,-11.574,-3.66965,-16.3105,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'3e2c7119-2016-4826-b6c9-1018d634c5f5','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/ca43bf7b-f931-42fc-bb75-05929e4b6578/session_d9740504-a9ca-472a-83f2-a309fa225a98/occlusion_d663165c-f330-4c61-8d1f-14869b6d5edd/computedocclusion_f62e0c41-a151-4495-829e-f57ef5d37eb8/59_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_ca43bf7b-f931-42fc-bb75-05929e4b6578_ACT_d9740504-a9ca-472a-83f2-a309fa225a98_SESS_d663165c-f330-4c61-8d1f-14869b6d5edd_OCC_f62e0c41-a151-4495-829e-f57ef5d37eb8_BOMA__MATRX_','2023-03-10 15:13:46','2023-03-10 16:13:23','59_w1_o1_mandibule_matrix_occ_file_0.m','2023-03-10 16:13:46','SYNCED','3e2c7119-2016-4826-b6c9-1018d634c5f5',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.59.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.59.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.59.1.1.1 Occlusion 1\"}'),(1001,'3eae79bc-22cb-44f1-966d-3975f4f05ac6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/458c92d8-9da1-4df9-967f-d14fc7e6303d/session_55831d43-1906-4a22-9b7a-ed4b2820c8b2/occlusion_4f582d4c-81d0-4e01-8be3-9ff53b12c7f4/scan_19e6ea5c-af28-439b-bc57-b561cd42e12b/10_w2_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_55831d43-1906-4a22-9b7a-ed4b2820c8b2_SESS_4f582d4c-81d0-4e01-8be3-9ff53b12c7f4_TOSC_19e6ea5c-af28-439b-bc57-b561cd42e12b_ZIP_','2022-06-16 13:27:31','2022-06-16 15:27:22','10_w2_o1_maxillaire_scan_file_1.zip','2022-06-16 15:27:31','SYNCED','9eb7d518-a769-4fd8-9066-a0f2ece8f396',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.10.2.1.1\",\"modelMatrix\":\"-0.212083,-0.899884,0.38109,0,0.977252,-0.195292,0.0827039,0,9.19492e-09,0.389961,0.920831,0,4.82955,-10.9388,-23.3718,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'3eeb0051-1568-4ea1-af00-8a66da98bd56','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/8b4b6de2-edd8-44e6-88c6-8a151914aca6/session_40a1b174-1058-4d27-b63a-4e8f565fb520/occlusion_8eba4eab-4337-436a-8eb6-b59e63415159/scan_08084ba8-1813-4cb8-97b6-125728b1dc52/48_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_8b4b6de2-edd8-44e6-88c6-8a151914aca6_ACT_40a1b174-1058-4d27-b63a-4e8f565fb520_SESS_8eba4eab-4337-436a-8eb6-b59e63415159_BOSC_08084ba8-1813-4cb8-97b6-125728b1dc52_SNAPS_','2022-11-10 10:29:09','2022-11-10 11:29:08','48_w1_o1_maxillaire_snapshot_0.png','2022-11-10 11:29:09','SYNCED','3eeb0051-1568-4ea1-af00-8a66da98bd56',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.48.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'3f0d80c9-c35b-4350-8560-6f0018887c71','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_d87d63d7-4507-4391-b749-4b160c9363ed/12_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_d87d63d7-4507-4391-b749-4b160c9363ed_ZIP_','2022-01-27 12:07:55','2022-01-27 13:07:41','12_w1_o1_mandibule_scan_file_0.zip','2022-01-27 13:07:55','SYNCED','3f0d80c9-c35b-4350-8560-6f0018887c71',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.1\",\"modelMatrix\":\"0.990642,-0.135532,0.0161156,0,0.136487,0.983712,-0.11697,0,-9.70693e-10,0.118075,0.993005,0,-24.0456,-2.08013,-18.1911,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'3f37a0d9-8c84-43c7-9b52-17754cc2eb0b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/order_e17d5c9a-174c-49e5-9c0e-69a4ff4d101c/24_w1_autre_prost_file_3f37a0d9-8c84-43c7-9b52-17754cc2eb0b_0.pdf','PDF','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_PROST_e17d5c9a-174c-49e5-9c0e-69a4ff4d101c_PDF_','2022-05-16 18:03:10','2022-05-16 20:03:08','24_w1_autre_prost_file_3f37a0d9-8c84-43c7-9b52-17754cc2eb0b_0.pdf','2022-05-16 20:03:10','SYNCED','3f37a0d9-8c84-43c7-9b52-17754cc2eb0b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.24.1.1 AUTRE FICHE DE PROTHESE\",\"title\":\"Autre PDF\"}'),(1001,'3f6d1843-a995-4df9-9c66-1b168ddacc91','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5/occlusion_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa/computedocclusion_4053e29d-7bcb-4280-9a77-c17e5d1256b3/24_w2_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5_SESS_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa_OCC_4053e29d-7bcb-4280-9a77-c17e5d1256b3_SNAPO__SNAPS_','2022-10-07 17:18:00','2022-10-07 19:17:23','24_w2_o1_snapshot_occ_file_0.png','2022-10-07 19:18:00','SYNCED','3f6d1843-a995-4df9-9c66-1b168ddacc91',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'3fbfad13-2341-4cbe-a30d-e5648594d8ec','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/9e399d73-4d2e-4bb8-af48-a4e597811faa/session_b1cf14ce-00a9-48b6-8654-dadde26073f1/occlusion_1060c95f-48f4-4a37-9b82-03bfd8329730/scan_f1e1a23d-a279-4fec-8d2c-40dc846885d2/46_w1_o2_mandibule_snapshot_1.png','SNAPS','PATIENT_9e399d73-4d2e-4bb8-af48-a4e597811faa_ACT_b1cf14ce-00a9-48b6-8654-dadde26073f1_SESS_1060c95f-48f4-4a37-9b82-03bfd8329730_BOSC_f1e1a23d-a279-4fec-8d2c-40dc846885d2_SNAPS_','2023-01-20 14:31:01','2023-01-20 15:27:54','46_w1_o2_mandibule_snapshot_1.png','2023-01-20 15:31:01','SYNCED','51783946-4939-4c6c-9e57-f1e450c81a9a',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.46.1.2.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'3fd39567-7451-4cea-b9da-8ae7227c54be','','SNAPS','PATIENT_a0c21836-ba79-4f15-9e35-02ef8211a9e5_ACT_0aac522d-3c38-465a-a1e0-014166c140ac_SESS_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042_RISC_1181b7d1-03e3-4847-bb73-0b48192e787c_SNAPS_','2022-01-24 14:24:09','2022-01-21 13:00:20','','2022-01-24 15:24:09','SYNCED','3fd39567-7451-4cea-b9da-8ae7227c54be',0,'2022-01-24 15:24:09','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.7.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'3fe128aa-0e1b-4e6e-80e7-4b10abe3f501','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/occlusion_e08bbeeb-a30b-428c-bd4a-40198f792219/computedocclusion_a503ab26-f707-4923-86b6-049c17f73533/25_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_SESS_e08bbeeb-a30b-428c-bd4a-40198f792219_OCC_a503ab26-f707-4923-86b6-049c17f73533_BOPLY__ZIP_','2022-05-17 16:40:33','2022-05-17 18:40:25','25_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-05-17 18:40:33','SYNCED','3fe128aa-0e1b-4e6e-80e7-4b10abe3f501',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.25.1.1.2 Occlusion 1\",\"modelMatrix\":\"-0.964287,0.263246,-0.0291771,0,-0.264858,-0.958419,0.106227,0,5.11078e-10,0.110162,0.993914,0,-2.81379,1.33022,-23.6936,1\",\"referenceScanID\":\"1.25.1.1.2\",\"title\":\"Mandibule 1.25.1.1.2 Occlusion 1\"}'),(1001,'3fefd4cc-db2f-4080-84eb-0b75c88cc393','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_14264009-2f96-4841-9c75-17adb3424f9f/18_w1_o1_mordu_anterieur_scan_file_1.zip','ZIP','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_FRSC_14264009-2f96-4841-9c75-17adb3424f9f_ZIP_','2022-03-07 14:38:04','2022-03-07 15:37:56','18_w1_o1_mordu_anterieur_scan_file_1.zip','2022-03-07 15:38:04','SYNCED','6acab9c1-fd86-4b22-a28b-e83dbe7f0bf2',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.18.1.1.1\",\"modelMatrix\":\"0.988862,-0.147596,0.0590464,0,0.14644,0.983189,-0.0983675,0,-0.0303973,0.107632,0.993494,0,-1.70108,-5.92658,-20.3766,1\",\"title\":\"Mordu anterieur ZIP\"}'),(1001,'4053d1d0-541a-4be3-b137-51501584b1e0','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/9efbbbe9-fd0a-44b1-988c-23571aad69fa/session_595a54fa-ae7d-4880-86a1-168b20242ecf/occlusion_b84a2165-e2d4-47e5-b110-a34bcaa24341/computedocclusion_9cad1eff-fefd-4d0a-b1af-fecfbc5a507f/53_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_9efbbbe9-fd0a-44b1-988c-23571aad69fa_ACT_595a54fa-ae7d-4880-86a1-168b20242ecf_SESS_b84a2165-e2d4-47e5-b110-a34bcaa24341_OCC_9cad1eff-fefd-4d0a-b1af-fecfbc5a507f_BOPLY__ZIP_','2022-12-02 14:17:34','2022-12-02 15:17:19','53_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-12-02 15:17:34','SYNCED','4053d1d0-541a-4be3-b137-51501584b1e0',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.53.1.1.1 Occlusion 1\",\"modelMatrix\":\"-0.98742,0.118552,-0.104631,0,-0.158121,-0.740324,0.653389,0,-3.87402e-09,0.661714,0.749757,0,24.7176,-2.96291,-19.4017,1\",\"referenceScanID\":\"1.53.1.1.1\",\"title\":\"Mandibule 1.53.1.1.1 Occlusion 1\"}'),(1001,'409dd0ba-1f03-4042-8f03-5144dba2e69e','','LIFI','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_OCC_8b14563e-0862-4cac-8045-e8aed2be886d_LIFIO_LIFI_','2022-07-19 13:44:34','2022-07-19 14:28:21','','2022-07-19 15:44:34','SYNCED','409dd0ba-1f03-4042-8f03-5144dba2e69e',0,'2022-07-19 15:44:34','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.38.1.1.1 Occlusion 1 Ligne de finition 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"Maxillaire\",\"name\":\"Ligne de finition 0\",\"title\":\"Ligne finition\",\"toothNumber\":1000}'),(1001,'40a065ff-ffc6-4101-a164-1207bc59e246','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/98aa55d8-3848-48e0-9684-5597786b85c7/session_4df1e430-5cbb-4a6c-8292-747e35e6f1e8/occlusion_fcc5c65d-b0e4-4036-99c7-07318171986a/computedocclusion_f2517330-f76d-418d-8d59-e56eb543a090/66_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_98aa55d8-3848-48e0-9684-5597786b85c7_ACT_4df1e430-5cbb-4a6c-8292-747e35e6f1e8_SESS_fcc5c65d-b0e4-4036-99c7-07318171986a_OCC_f2517330-f76d-418d-8d59-e56eb543a090_SNAPO__SNAPS_','2023-04-13 10:07:20','2023-04-13 12:07:20','66_w1_o1_snapshot_occ_file_0.png',NULL,'CREATED','40a065ff-ffc6-4101-a164-1207bc59e246',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'40e783b5-e3e2-4274-a04a-bc2ad2619648','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3ed7a8e0-5b4d-4ecf-b4ae-f855b16c0f93/session_fb42cec6-0bb6-41e9-912d-0517ff8e0942/occlusion_fb214b2f-5e41-492d-85c4-d4a11a3947c5/scan_a9ceb894-da65-4187-8ae3-efdbd6df27ca/42_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_3ed7a8e0-5b4d-4ecf-b4ae-f855b16c0f93_ACT_fb42cec6-0bb6-41e9-912d-0517ff8e0942_SESS_fb214b2f-5e41-492d-85c4-d4a11a3947c5_LESC_a9ceb894-da65-4187-8ae3-efdbd6df27ca_SNAPS_','2022-10-07 11:56:49','2022-10-07 13:56:42','42_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-10-07 13:56:49','SYNCED','40e783b5-e3e2-4274-a04a-bc2ad2619648',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.42.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'411fcadb-15cc-4199-a69b-4707b3ed32ea','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/scan_64badb85-f6d8-46a0-8cc4-2125845f9e47/22_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_RISC_64badb85-f6d8-46a0-8cc4-2125845f9e47_SNAPS_','2022-04-21 11:13:13','2022-04-21 13:13:07','22_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-04-21 13:13:13','SYNCED','411fcadb-15cc-4199-a69b-4707b3ed32ea',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.22.1.1.3\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'41685560-a818-4e12-b424-2a69f0942647','','LIFI','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_TOSC_47ae7109-ac97-4f1b-8dd7-cc22debd4324_LIFI_','2022-07-19 13:56:04','2022-07-19 15:55:49','','2022-07-19 15:56:04','SYNCED','41685560-a818-4e12-b424-2a69f0942647',0,'2022-07-19 15:56:04','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.38.1.1.4 Ligne de finition 0\",\"name\":\"Ligne de finition 0\",\"title\":\"Maxillaire LIFI\",\"toothNumber\":0,\"versionMarginLine\":1}'),(1001,'416db3c9-b04a-404f-8271-79d9066b8d08','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_2ffbfbca-f236-4802-be93-8eb43d523274/scan_eb904683-acc6-4e6d-8900-3982d403ba0f/4_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_2ffbfbca-f236-4802-be93-8eb43d523274_FRSC_eb904683-acc6-4e6d-8900-3982d403ba0f_SNAPS_','2022-01-19 19:13:25','2022-01-19 20:11:50','4_w1_o1_mordu_anterieur_snapshot_0.png','2022-01-19 20:13:25','SYNCED','416db3c9-b04a-404f-8271-79d9066b8d08',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.4.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'41a02d9d-2357-44a0-92d5-7989e1857c8e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3ed7a8e0-5b4d-4ecf-b4ae-f855b16c0f93/session_fb42cec6-0bb6-41e9-912d-0517ff8e0942/occlusion_fb214b2f-5e41-492d-85c4-d4a11a3947c5/computedocclusion_f6573412-d667-47a1-89b2-d0a46006380f/42_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_3ed7a8e0-5b4d-4ecf-b4ae-f855b16c0f93_ACT_fb42cec6-0bb6-41e9-912d-0517ff8e0942_SESS_fb214b2f-5e41-492d-85c4-d4a11a3947c5_OCC_f6573412-d667-47a1-89b2-d0a46006380f_SNAPO__SNAPS_','2022-10-07 17:38:20','2022-10-07 19:37:42','42_w1_o1_snapshot_occ_file_0.png','2022-10-07 19:38:20','SYNCED','41a02d9d-2357-44a0-92d5-7989e1857c8e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'41a0474e-586b-420d-a99d-9f71d974d74f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3cc1b522-8e7d-4196-87a1-a8c234f0a399/session_ef503949-33e8-4db6-bbfa-456bd8b70b73/occlusion_e8e2758f-faa4-4db7-93df-e94ddfbd8284/scan_f50e5124-f992-40b4-97cd-258bc3037b29/51_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_3cc1b522-8e7d-4196-87a1-a8c234f0a399_ACT_ef503949-33e8-4db6-bbfa-456bd8b70b73_SESS_e8e2758f-faa4-4db7-93df-e94ddfbd8284_TOSC_f50e5124-f992-40b4-97cd-258bc3037b29_SNAPS_','2022-11-28 16:48:08','2022-11-28 17:47:53','51_w1_o1_maxillaire_snapshot_1.png','2022-11-28 17:48:08','SYNCED','2cc22f54-487a-4f31-9c45-34baa0398b64',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.51.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'41ae43db-3ab4-4cbc-8b03-212f38763a9d','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/ca43bf7b-f931-42fc-bb75-05929e4b6578/session_d9740504-a9ca-472a-83f2-a309fa225a98/occlusion_d663165c-f330-4c61-8d1f-14869b6d5edd/computedocclusion_f62e0c41-a151-4495-829e-f57ef5d37eb8/59_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_ca43bf7b-f931-42fc-bb75-05929e4b6578_ACT_d9740504-a9ca-472a-83f2-a309fa225a98_SESS_d663165c-f330-4c61-8d1f-14869b6d5edd_OCC_f62e0c41-a151-4495-829e-f57ef5d37eb8_BOPLY__ZIP_','2023-03-10 15:14:03','2023-03-10 16:13:23','59_w1_o1_mandibule_occlusion_occ_file_0.zip','2023-03-10 16:14:03','SYNCED','41ae43db-3ab4-4cbc-8b03-212f38763a9d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.59.1.1.1 Occlusion 1\",\"modelMatrix\":\"-0.520765,0.849794,-0.0815696,0,-0.8537,-0.518383,0.0497582,0,-5.75738e-09,0.0955483,0.995425,0,-0.870521,-8.35265,-26.3418,1\",\"referenceScanID\":\"1.59.1.1.1\",\"title\":\"Mandibule 1.59.1.1.1 Occlusion 1\"}'),(1001,'41c5638d-f592-4140-a730-908ac2ac80bf','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/4fa1a134-d246-43d7-aa8c-b42e24b62b49/session_6aedf6fd-46d7-4259-88ba-5cf074ad5913/occlusion_47192ebb-25b6-4c9e-a09f-8ed295e60a87/computedocclusion_d5964fd1-cca9-4595-8400-d624697bd9e7/60_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_4fa1a134-d246-43d7-aa8c-b42e24b62b49_ACT_6aedf6fd-46d7-4259-88ba-5cf074ad5913_SESS_47192ebb-25b6-4c9e-a09f-8ed295e60a87_OCC_d5964fd1-cca9-4595-8400-d624697bd9e7_SNAPO__SNAPS_','2023-03-07 18:12:22','2023-03-07 19:11:43','60_w1_o1_snapshot_occ_file_0.png','2023-03-07 19:12:22','SYNCED','41c5638d-f592-4140-a730-908ac2ac80bf',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'41ee6338-a833-44aa-b5c3-9d77b239127c','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_ce625ba7-4218-40af-b344-df718da13f83/54_w1_o1_snapshot_occ_file_7.png','SNAPS','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_ce625ba7-4218-40af-b344-df718da13f83_SNAPO__SNAPS_','2023-03-15 10:35:08','2023-03-15 11:32:28','54_w1_o1_snapshot_occ_file_7.png','2023-03-15 11:35:08','SYNCED','7646ffac-dba0-4ac0-b4a3-8547134e5318',7,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(2,'4224c7b0-e556-43c5-a593-8800fdfac9a9','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a4b302c-278d-4e12-ace5-f095ba0bf856/session_6206892a-2e7e-4765-ac90-b49bfb465997/occlusion_3c30231c-7cd7-4431-985b-2eaf7f6925ae/scan_b42f4445-ea70-4de5-bf5c-892a7b6eaa24/3_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_b42f4445-ea70-4de5-bf5c-892a7b6eaa24_SNAPS_','2022-09-06 09:20:32','2022-08-30 10:57:23','3_w1_o1_maxillaire_snapshot_0.png','2022-09-06 11:20:32','SYNCED','4224c7b0-e556-43c5-a593-8800fdfac9a9',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.3.1.1.5\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'426a07b1-c2bc-4663-b618-0e098b82921b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/fa7fa96b-f393-4b9a-8198-144702462cfa/session_4bed076c-8541-4a2f-800a-5aeb4cb49de5/occlusion_16b82fca-4b65-4866-af87-1f6dbb42f5dc/scan_07f2d366-54ce-478e-95a9-7ae35cfbc11a/35_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_fa7fa96b-f393-4b9a-8198-144702462cfa_ACT_4bed076c-8541-4a2f-800a-5aeb4cb49de5_SESS_16b82fca-4b65-4866-af87-1f6dbb42f5dc_LESC_07f2d366-54ce-478e-95a9-7ae35cfbc11a_ZIP_','2022-06-28 15:03:03','2022-06-28 17:02:56','35_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-06-28 17:03:03','SYNCED','426a07b1-c2bc-4663-b618-0e098b82921b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.35.1.1.1\",\"modelMatrix\":\"-0.88792,-0.0581614,0.456915,0,0.00733581,-0.994324,-0.0876594,0,0.459946,-0.0914194,0.885415,0,-7.37981,3.84763,-17.9281,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'42734ae7-ac95-4d21-8d0c-77ddbb5cc9e1','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/533d4409-e39d-4a27-a0af-b59e6cf76ce3/session_319a8f1d-33fc-4f87-a108-b3eabda0510f/occlusion_3b38f07b-42cb-40b1-933f-365e568702e4/scan_109ca2c4-8222-4d02-9ac7-b4b93937e1e2/37_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_533d4409-e39d-4a27-a0af-b59e6cf76ce3_ACT_319a8f1d-33fc-4f87-a108-b3eabda0510f_SESS_3b38f07b-42cb-40b1-933f-365e568702e4_TOSC_109ca2c4-8222-4d02-9ac7-b4b93937e1e2_SNAPS_','2022-07-07 15:51:58','2022-07-07 17:51:45','37_w1_o1_maxillaire_snapshot_1.png','2022-07-07 17:51:58','SYNCED','6fa5ad33-3773-4801-9f0b-ed36985cc55e',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.37.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'42766eb5-7dc0-49a5-a9fb-7114c349afbc','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/204921b5-c765-4248-8e87-e3b0f7a46bff/session_88257045-93fb-43fb-8b0a-f39fbf5f8e9d/occlusion_ad360501-c145-40e5-9b88-808cd7a61eed/scan_00ace894-af8c-4aaf-b048-f7c417a9225b/45_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_204921b5-c765-4248-8e87-e3b0f7a46bff_ACT_88257045-93fb-43fb-8b0a-f39fbf5f8e9d_SESS_ad360501-c145-40e5-9b88-808cd7a61eed_BOSC_00ace894-af8c-4aaf-b048-f7c417a9225b_ZIP_','2022-10-18 12:54:30','2022-10-18 14:54:22','45_w1_o1_mandibule_scan_file_1.zip','2022-10-18 14:54:30','SYNCED','d4797409-fdd8-4183-8d75-20c2ec7c638c',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.45.1.1.1\",\"modelMatrix\":\"-0.252918,0.925451,-0.282087,0,-0.967488,-0.241929,0.0737423,0,-5.46414e-10,0.291566,0.956551,0,20.7805,-25.5815,-9.87275,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'428d14dc-d1d1-483e-971b-4a89b607834d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/533d4409-e39d-4a27-a0af-b59e6cf76ce3/session_319a8f1d-33fc-4f87-a108-b3eabda0510f/occlusion_3b38f07b-42cb-40b1-933f-365e568702e4/scan_109ca2c4-8222-4d02-9ac7-b4b93937e1e2/37_w1_o1_maxillaire_scan_file_2.zip','ZIP','PATIENT_533d4409-e39d-4a27-a0af-b59e6cf76ce3_ACT_319a8f1d-33fc-4f87-a108-b3eabda0510f_SESS_3b38f07b-42cb-40b1-933f-365e568702e4_TOSC_109ca2c4-8222-4d02-9ac7-b4b93937e1e2_ZIP_','2022-07-07 15:56:37','2022-07-07 17:56:26','37_w1_o1_maxillaire_scan_file_2.zip','2022-07-07 17:56:37','SYNCED','0192b393-b665-47d2-aaac-671ff4a06d5c',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.37.1.1.1\",\"modelMatrix\":\"0.661054,0.729657,-0.174953,0,-0.750338,0.642834,-0.154135,0,1.49368e-08,0.233165,0.972437,0,3.12705,-26.0579,-17.6521,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'42d933f2-4058-4b08-b0d7-6431c9f7a74c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/occlusion_a2220645-c79d-4dda-b6cc-772384a4106b/scan_fb5993c3-7f31-49de-8a74-e83ef447f0a1/38_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_RISC_fb5993c3-7f31-49de-8a74-e83ef447f0a1_ZIP_','2022-07-12 10:57:17','2022-07-12 12:57:08','38_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-07-12 12:57:17','SYNCED','42d933f2-4058-4b08-b0d7-6431c9f7a74c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.38.1.1.1\",\"modelMatrix\":\"0.993183,0.110435,0.0498648,0,-0.112648,0.989693,0.0756138,0,-0.031496,-0.0918607,0.995999,0,4.71151,5.45832,-20.0366,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'430252eb-3c0c-4c13-a493-cff214346392','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a20364ca-68f6-43af-9d85-5203eb8e7fd3/session_4fbadc34-458e-4383-9cea-ff5422d69287/occlusion_56872db7-25ba-4ec4-a526-b4254011197f/scan_3360b3d3-3f88-47f7-a1ce-b4e540b8369c/49_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_a20364ca-68f6-43af-9d85-5203eb8e7fd3_ACT_4fbadc34-458e-4383-9cea-ff5422d69287_SESS_56872db7-25ba-4ec4-a526-b4254011197f_TOSC_3360b3d3-3f88-47f7-a1ce-b4e540b8369c_SNAPS_','2022-10-28 10:04:24','2022-10-28 12:04:09','49_w1_o1_maxillaire_snapshot_0.png','2022-10-28 12:04:24','SYNCED','430252eb-3c0c-4c13-a493-cff214346392',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.49.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'430563f9-b0c8-4cb8-80de-b74c4152c2d2','','MATRX','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_1500b3eb-4b86-46c1-9c9f-7efbd0224ac8_BOMA__MATRX_','2022-05-25 08:56:38','2022-05-13 18:22:04','','2022-05-25 10:56:38','SYNCED','430563f9-b0c8-4cb8-80de-b74c4152c2d2',0,'2022-05-25 10:56:38','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.24.1.1.1 Occlusion 4\",\"referenceScanID\":\"1.24.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.24.1.1.1 Occlusion 4\"}'),(1001,'4347ec13-c6ed-41aa-b45f-2844488ba96b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/204921b5-c765-4248-8e87-e3b0f7a46bff/session_88257045-93fb-43fb-8b0a-f39fbf5f8e9d/occlusion_ad360501-c145-40e5-9b88-808cd7a61eed/scan_fbf36163-e1ef-42da-9ec3-02d6cc9846f2/45_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_204921b5-c765-4248-8e87-e3b0f7a46bff_ACT_88257045-93fb-43fb-8b0a-f39fbf5f8e9d_SESS_ad360501-c145-40e5-9b88-808cd7a61eed_TOSC_fbf36163-e1ef-42da-9ec3-02d6cc9846f2_ZIP_','2022-10-18 12:38:55','2022-10-18 14:38:46','45_w1_o1_maxillaire_scan_file_0.zip','2022-10-18 14:38:55','SYNCED','4347ec13-c6ed-41aa-b45f-2844488ba96b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.45.1.1.1\",\"modelMatrix\":\"0.793723,0.555547,-0.247734,0,-0.60828,0.724913,-0.32326,0,6.35954e-09,0.40727,0.913308,0,-17.0142,-7.83121,-12.7332,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'439d33c4-cacc-42ff-8ae1-ae3420efe92c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/computedocclusion_d5bff097-1085-4c55-afe3-1ce57126d88f/19_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_OCC_d5bff097-1085-4c55-afe3-1ce57126d88f_TOPLY__ZIP_','2022-03-08 11:16:24','2022-03-08 12:15:58','19_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-03-08 12:16:24','SYNCED','439d33c4-cacc-42ff-8ae1-ae3420efe92c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.19.1.1.1 Occlusion 2\",\"modelMatrix\":\"0.985752,-0.166051,0.0268482,0,0.168208,0.973114,-0.157339,0,2.19633e-09,0.159614,0.98718,0,-32.9792,-5.96138,-23.3688,1\",\"referenceScanID\":\"1.19.1.1.1\",\"title\":\"Maxillaire 1.19.1.1.1 Occlusion 2\"}'),(1001,'43bf2afa-4f73-488a-b1fc-60b302be27b3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/45ff7437-0691-4427-a7da-8250862e4b96/session_4ff9c682-c09d-42ff-8c29-aeb13e066ed2/occlusion_934673c1-a4b9-4508-ac1b-a03092a0693e/computedocclusion_161f60a4-d4f2-41f1-98ad-a8ccad84216c/9_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_45ff7437-0691-4427-a7da-8250862e4b96_ACT_4ff9c682-c09d-42ff-8c29-aeb13e066ed2_SESS_934673c1-a4b9-4508-ac1b-a03092a0693e_OCC_161f60a4-d4f2-41f1-98ad-a8ccad84216c_TOMA__MATRX_','2022-01-24 17:47:25','2022-01-24 18:46:00','9_w1_o1_maxillaire_matrix_occ_file_0.m','2022-01-24 18:47:25','SYNCED','43bf2afa-4f73-488a-b1fc-60b302be27b3',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.9.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.9.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.9.1.1.1 Occlusion 1\"}'),(1001,'43c446c4-2944-4827-8b74-5456466149e7','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/scan_a6e9f7d5-ea01-4016-a5c9-4b948fbd5ded/22_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_FRSC_a6e9f7d5-ea01-4016-a5c9-4b948fbd5ded_SNAPS_','2022-04-21 11:14:44','2022-04-21 13:14:37','22_w1_o1_mordu_anterieur_snapshot_0.png','2022-04-21 13:14:44','SYNCED','43c446c4-2944-4827-8b74-5456466149e7',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.22.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'43eafd97-707f-4454-9553-a0f6803a11fc','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/d100e894-0be9-4495-94e2-e469232f7817/session_2c8b85b5-c805-4b08-85e7-3d02dab72e99/occlusion_8a278cc5-a1c1-4dfb-9ee2-c971a6309afa/scan_061005ca-b3b4-4cb2-bf80-5bae7b8fc987/15_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_d100e894-0be9-4495-94e2-e469232f7817_ACT_2c8b85b5-c805-4b08-85e7-3d02dab72e99_SESS_8a278cc5-a1c1-4dfb-9ee2-c971a6309afa_TOSC_061005ca-b3b4-4cb2-bf80-5bae7b8fc987_SNAPS_','2022-02-01 15:15:50','2022-02-01 16:15:48','15_w1_o1_mandibule_snapshot_0.png','2022-02-01 16:15:50','SYNCED','43eafd97-707f-4454-9553-a0f6803a11fc',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.15.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'43faec45-d44e-4a5b-980c-14c82d42fdd3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_04d6e3f1-19ce-4851-a9d0-40419cea7542/scan_9e43db2d-10a9-414e-ac07-6b7642412ce5/19_w1_o2_maxillaire_snapshot_0.png','SNAPS','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_04d6e3f1-19ce-4851-a9d0-40419cea7542_TOSC_9e43db2d-10a9-414e-ac07-6b7642412ce5_SNAPS_','2022-04-15 11:41:27','2022-04-01 18:15:18','19_w1_o2_maxillaire_snapshot_0.png','2022-04-15 13:41:27','SYNCED','43faec45-d44e-4a5b-980c-14c82d42fdd3',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire SNAPSHOT\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'4427d55b-c065-48be-af93-9fe5797988df','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_77ec818f-d778-4945-9458-90665b5522ba/17_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_TOSC_77ec818f-d778-4945-9458-90665b5522ba_ZIP_','2022-02-07 11:28:27','2022-02-07 12:26:07','17_w1_o1_maxillaire_scan_file_1.zip','2022-02-07 12:28:27','SYNCED','6a291473-6bc6-401e-8fb7-01a4524ebec6',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.17.1.1.1\",\"modelMatrix\":\"0.149253,0.920186,-0.361913,0,-0.988799,0.138896,-0.0546284,0,-8.90892e-10,0.366013,0.93061,0,-24.4594,-29.735,-12.8678,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'44301718-8b73-40e6-9f06-c0e89b7e49e6','','SNAPS','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_TOSC_47ae7109-ac97-4f1b-8dd7-cc22debd4324_SNAPS_','2022-07-19 13:56:03','2022-07-19 15:55:49','','2022-07-19 15:56:03','SYNCED','44301718-8b73-40e6-9f06-c0e89b7e49e6',0,'2022-07-19 15:56:03','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.38.1.1.4\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'44327a80-c315-4ee4-8339-c54421e1de06','','ZIP','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_c9079d19-8ffb-46f7-a51e-3a7a90ccae59_SESS_8ba0f3b1-408f-4a02-92a0-63f09123b68e_LESC_f2611342-ebf4-4c08-b8d1-c7c38b1c7e7c_ZIP_','2022-01-28 17:15:43','2022-01-27 14:27:09','','2022-01-28 18:15:43','SYNCED','44327a80-c315-4ee4-8339-c54421e1de06',0,'2022-01-28 18:15:43','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.10.1.1.1\",\"modelMatrix\":\"-0.992699,0.089386,0.0835266,0,-0.0768384,-0.990191,0.106545,0,0.0930207,0.107778,0.990833,0,-5.72027,-7.8724,-16.0337,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'4447b3ff-fae6-4112-b63c-3a9385ee2158','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/computedocclusion_8e4092a3-64a2-4464-addd-03b3c8ba2289/24_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_8e4092a3-64a2-4464-addd-03b3c8ba2289_BOPLY__ZIP_','2022-05-13 16:21:12','2022-05-13 18:20:53','24_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-05-13 18:21:12','SYNCED','4447b3ff-fae6-4112-b63c-3a9385ee2158',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.24.1.1.1 Occlusion 3\",\"modelMatrix\":\"0.852703,-0.521011,0.0380208,0,0.522396,0.850441,-0.062061,0,3.49638e-10,0.0727815,0.997348,0,-11.3911,-12.8136,-21.1334,1\",\"referenceScanID\":\"1.24.1.1.1\",\"title\":\"Mandibule 1.24.1.1.1 Occlusion 3\"}'),(1001,'4484d278-10aa-429c-9763-c6998e83c1d6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f4fc00ec-4af8-4a15-b427-f1c5aabf6260/session_498ae60a-23f0-44fc-9730-be499bfc4b46/order_d76d0cba-8849-44b5-86bd-d723580b3cf9/30_w1_autre_prost_file_4484d278-10aa-429c-9763-c6998e83c1d6_0.pdf','PDF','PATIENT_f4fc00ec-4af8-4a15-b427-f1c5aabf6260_ACT_498ae60a-23f0-44fc-9730-be499bfc4b46_PROST_d76d0cba-8849-44b5-86bd-d723580b3cf9_PDF_','2022-06-14 17:10:42','2022-06-14 19:10:41','30_w1_autre_prost_file_4484d278-10aa-429c-9763-c6998e83c1d6_0.pdf','2022-06-14 19:10:42','SYNCED','4484d278-10aa-429c-9763-c6998e83c1d6',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.30.1.1 AUTRE FICHE DE PROTHESE\",\"title\":\"Autre PDF\"}'),(1001,'44912674-3117-4268-89c9-8b101f972579','','ZIP','PATIENT_452a5200-3e06-4b74-8949-6abc7f2dda8a_ACT_3e95d626-668f-45f7-98ad-be2cf9d7b90b_SESS_bce8310f-eee9-4f0a-a6b7-d592dec66be5_TOSC_0cdd9706-bf86-43f6-8f49-976542e5b9e8_ZIP_','2022-05-24 09:15:25','2022-05-24 11:07:55','','2022-05-24 11:15:25','SYNCED','44912674-3117-4268-89c9-8b101f972579',0,'2022-05-24 11:15:25','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.26.1.1.1\",\"modelMatrix\":\"-0.790076,0.350974,-0.502591,0,-0.61301,-0.452352,0.647764,0,1.88961e-08,0.819875,0.572542,0,3.3596,-22.5543,-15.4755,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'44c9a086-ebd4-4513-b03b-df67f000a760','','MATRX','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_OCC_ff8547d7-27f8-4862-9b63-e713dd817f3f_BOMA__MATRX_','2022-09-09 17:04:15','2022-09-09 19:03:34','','2022-09-09 19:04:15','SYNCED','44c9a086-ebd4-4513-b03b-df67f000a760',0,'2022-09-09 19:04:15','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.39.1.1.1 Occlusion 10\",\"referenceScanID\":\"1.39.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.39.1.1.1 Occlusion 10\"}'),(1001,'44ebcd6f-57c2-4cce-96f5-f9faa1c6b373','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_2a7068fc-0efa-496f-ade9-aba5b0650655/12_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_2a7068fc-0efa-496f-ade9-aba5b0650655_ZIP_','2022-02-04 11:45:00','2022-02-04 12:44:47','12_w1_o1_mandibule_scan_file_0.zip','2022-02-04 12:45:00','SYNCED','44ebcd6f-57c2-4cce-96f5-f9faa1c6b373',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.5\",\"modelMatrix\":\"0.625532,-0.7537,0.20161,0,0.780199,0.604286,-0.161642,0,3.06863e-9,0.258408,0.966036,0,4.64949,31.8294,-26.5993,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'45057e79-706b-4ee4-9c23-ad93f8923f71','','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_e2722784-a66c-4ece-91c0-2add756415ea_TOPLY__ZIP_','2022-05-13 16:32:18','2022-05-13 18:31:42','','2022-05-13 18:32:18','SYNCED','45057e79-706b-4ee4-9c23-ad93f8923f71',0,'2022-05-13 18:32:18','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.2 Occlusion 5\",\"modelMatrix\":\"-0.80453,0.576793,-0.141569,0,-0.593912,-0.781339,0.191773,0,-6.05286e-09,0.238367,0.971175,0,0.910551,-5.61768,-25.9513,1\",\"referenceScanID\":\"1.24.1.1.2\",\"title\":\"Maxillaire 1.24.1.1.2 Occlusion 5\"}'),(1001,'452d955d-b844-42ed-9edf-9d005a4afa46','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/207d6dbc-c19b-4726-a9b3-16235ae554cc/session_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35/occlusion_dc5762a3-c453-4166-8c86-82d23ac9f8a6/computedocclusion_3a1fff1c-0427-409c-aa94-06326e554d82/27_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_207d6dbc-c19b-4726-a9b3-16235ae554cc_ACT_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35_SESS_dc5762a3-c453-4166-8c86-82d23ac9f8a6_OCC_3a1fff1c-0427-409c-aa94-06326e554d82_BOMA__MATRX_','2022-05-30 11:09:39','2022-05-30 13:09:22','27_w1_o1_mandibule_matrix_occ_file_0.m','2022-05-30 13:09:39','SYNCED','452d955d-b844-42ed-9edf-9d005a4afa46',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.27.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.27.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.27.1.1.1 Occlusion 1\"}'),(1001,'4564d27e-534a-46c9-b716-84d963dd5c51','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/9e399d73-4d2e-4bb8-af48-a4e597811faa/session_b1cf14ce-00a9-48b6-8654-dadde26073f1/occlusion_1060c95f-48f4-4a37-9b82-03bfd8329730/scan_7887f7ce-288b-4f04-a7cd-7a7c58e2e5f9/46_w1_o2_mordu_posterieur_droit_scan_file_1.zip','ZIP','PATIENT_9e399d73-4d2e-4bb8-af48-a4e597811faa_ACT_b1cf14ce-00a9-48b6-8654-dadde26073f1_SESS_1060c95f-48f4-4a37-9b82-03bfd8329730_RISC_7887f7ce-288b-4f04-a7cd-7a7c58e2e5f9_ZIP_','2023-01-20 14:41:14','2023-01-20 15:41:02','46_w1_o2_mordu_posterieur_droit_scan_file_1.zip','2023-01-20 15:41:14','SYNCED','79e5e3fd-7e86-4318-a7e3-ac3877c1aeab',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.46.1.2.1\",\"modelMatrix\":\"0.958589,0.016011,0.282379,0,0.0447025,0.977426,-0.212962,0,-0.281268,0.210772,0.93539,0,-3.00877,-8.96422,-24.0471,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'45775437-46ca-4831-b788-61b2ad12ff31','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_ce625ba7-4218-40af-b344-df718da13f83/54_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_ce625ba7-4218-40af-b344-df718da13f83_BOMA__MATRX_','2022-12-13 09:54:36','2022-12-13 10:54:13','54_w1_o1_mandibule_matrix_occ_file_0.m','2022-12-13 10:54:36','SYNCED','45775437-46ca-4831-b788-61b2ad12ff31',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.54.1.1.4 Occlusion 1\",\"referenceScanID\":\"1.54.1.1.4\",\"title\":\"Matrice Transfo. Mandibule 1.54.1.1.4 Occlusion 1\"}'),(1001,'45bad5da-e084-4bfd-828b-fd44fd367e7b','','MATRX','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_aa16f8ea-198d-4240-ab78-5a1f54823f0c_BOMA__MATRX_','2022-05-16 17:48:36','2022-05-16 19:47:59','','2022-05-16 19:48:36','SYNCED','45bad5da-e084-4bfd-828b-fd44fd367e7b',0,'2022-05-16 19:48:36','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.24.1.1.1 Occlusion 6\",\"referenceScanID\":\"1.24.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.24.1.1.1 Occlusion 6\"}'),(1001,'45f03dcf-3df1-4525-81e4-1227e57bb655','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5/occlusion_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa/computedocclusion_901f8265-7f99-4d24-a03f-5860f5bc155e/24_w2_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5_SESS_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa_OCC_901f8265-7f99-4d24-a03f-5860f5bc155e_TOPLY__ZIP_','2022-10-07 14:32:17','2022-10-07 16:31:57','24_w2_o1_maxillaire_occlusion_occ_file_0.zip','2022-10-07 16:32:17','SYNCED','45f03dcf-3df1-4525-81e4-1227e57bb655',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.2.1.1 Occlusion 1\",\"modelMatrix\":\"0.626985,0.76241,-0.160065,0,-0.779032,0.613607,-0.128824,0,4.39427e-09,0.205467,0.978664,0,0.203644,-29.5943,-18.0319,1\",\"referenceScanID\":\"1.24.2.1.1\",\"title\":\"Maxillaire 1.24.2.1.1 Occlusion 1\"}'),(1001,'4637d7fd-a62e-492f-a536-68ef0089c543','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_04abc032-a797-420b-8d5e-ee9528f5e291/12_w1_o1_mordu_anterieur_scan_file_0.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_FRSC_04abc032-a797-420b-8d5e-ee9528f5e291_ZIP_','2022-02-04 12:19:28','2022-02-04 13:19:20','12_w1_o1_mordu_anterieur_scan_file_0.zip','2022-02-04 13:19:28','SYNCED','4637d7fd-a62e-492f-a536-68ef0089c543',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.12.1.1.1\",\"modelMatrix\":\"0.974766,-0.105993,0.210432,0,0.0700793,0.994301,0.0335315,0,-0.213467,-0.0385566,0.977398,0,1.51255,1.93508,-19.9759,1\",\"title\":\"Mordu anterieur ZIP\"}'),(1001,'463c7b84-774c-483c-ab9a-89a270919932','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/57c4096f-98dd-49c8-bea5-a5b109ad3fd0/session_4f62e395-5623-4d5b-869c-1b2fc4d22b00/occlusion_1ac20dc7-b36b-4786-a05f-37091554dc5c/computedocclusion_70f4220e-2a6b-4575-bd0e-09c14a13d758/31_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_57c4096f-98dd-49c8-bea5-a5b109ad3fd0_ACT_4f62e395-5623-4d5b-869c-1b2fc4d22b00_SESS_1ac20dc7-b36b-4786-a05f-37091554dc5c_OCC_70f4220e-2a6b-4575-bd0e-09c14a13d758_SNAPO__SNAPS_','2022-06-16 11:04:13','2022-06-16 13:03:55','31_w1_o1_snapshot_occ_file_0.png','2022-06-16 13:04:13','SYNCED','463c7b84-774c-483c-ab9a-89a270919932',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'46812872-d002-4e9b-a255-b85e584a028a','','MATRX','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_cb4cdc08-5d89-48dc-80a3-2e659c55f971_BOMA__MATRX_','2022-02-08 08:48:59','2022-02-07 18:52:17','','2022-02-08 09:48:59','SYNCED','46812872-d002-4e9b-a255-b85e584a028a',0,'2022-02-08 09:48:59','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.17.1.1.1 Occlusion 4\",\"referenceScanID\":\"1.17.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.17.1.1.1 Occlusion 4\"}'),(1001,'46be4566-2ed9-474b-bbd1-c7748e98f460','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_6c9ae07a-23c3-4355-87ff-b57ef558a4ea/17_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_LESC_6c9ae07a-23c3-4355-87ff-b57ef558a4ea_ZIP_','2022-02-11 16:08:30','2022-02-11 17:08:22','17_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-02-11 17:08:30','SYNCED','46be4566-2ed9-474b-bbd1-c7748e98f460',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.17.1.1.3\",\"modelMatrix\":\"-0.993498,0.071131,0.0881033,0,-0.069339,-0.99592,0.0645507,0,0.0903847,0.0556956,0.994024,0,-5.58281,0.770671,-18.0738,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'46c52597-fb12-4eb8-8207-0fcc41b12577','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/1a8329eb-7dbc-4bfd-b669-6d92e13fec0c/session_11fb4259-c305-4a08-b750-536f769f44b0/occlusion_129468ab-1f43-4ba1-8939-49286128bf4d/computedocclusion_25900e6e-058b-4aa5-bee3-f5d20493c6ee/47_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_1a8329eb-7dbc-4bfd-b669-6d92e13fec0c_ACT_11fb4259-c305-4a08-b750-536f769f44b0_SESS_129468ab-1f43-4ba1-8939-49286128bf4d_OCC_25900e6e-058b-4aa5-bee3-f5d20493c6ee_TOPLY__ZIP_','2022-10-21 16:20:04','2022-10-21 18:19:49','47_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-10-21 18:20:04','SYNCED','46c52597-fb12-4eb8-8207-0fcc41b12577',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.47.1.1.1 Occlusion 2\",\"modelMatrix\":\"0.447873,0.884973,-0.127409,0,-0.894097,0.443302,-0.0638219,0,7.75415e-10,0.1425,0.989795,0,-12.7197,-19.4979,-18.0681,1\",\"referenceScanID\":\"1.47.1.1.1\",\"title\":\"Maxillaire 1.47.1.1.1 Occlusion 2\"}'),(1001,'472bff43-975a-4314-a4e6-a81c63fb1fd8','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/09688939-f53f-4f00-8366-687b244de26d/session_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525/occlusion_9655a7e0-4673-41c9-90da-a48c008e2d62/scan_e8a97607-4009-48c5-b80b-9e6fdf2923ab/64_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_09688939-f53f-4f00-8366-687b244de26d_ACT_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525_SESS_9655a7e0-4673-41c9-90da-a48c008e2d62_TOSC_e8a97607-4009-48c5-b80b-9e6fdf2923ab_ZIP_','2023-03-30 11:46:28','2023-03-30 13:46:17','64_w1_o1_maxillaire_scan_file_1.zip','2023-03-30 13:46:28','SYNCED','2e7ae315-b97e-4ae9-bc44-4dd1f711f7bc',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.64.1.1.1\",\"modelMatrix\":\"0.773022,0.623358,-0.11774,0,-0.63438,0.759591,-0.143472,0,-5.16501e-09,0.185599,0.982626,0,-13.2232,-22.6524,-24.1371,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'473be61f-e0c7-4b5b-97bc-a62aab17df37','','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_BOSC_07148fa2-1d5b-4343-81f9-ef44df15e4c7_ZIP_','2022-02-19 17:53:23','2022-02-14 19:20:09','','2022-02-19 18:53:23','SYNCED','473be61f-e0c7-4b5b-97bc-a62aab17df37',0,'2022-02-19 18:53:23','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.4.2\",\"modelMatrix\":\"0.443894,0.860251,-0.25085,0,-0.896079,0.426146,-0.124264,0,5.11492e-09,0.279941,0.960017,0,-5.21707,-37.3792,-16.1535,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'47aada63-b6e9-4cc1-8444-3581a142320c','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/09688939-f53f-4f00-8366-687b244de26d/session_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525/occlusion_9655a7e0-4673-41c9-90da-a48c008e2d62/computedocclusion_66955dfb-349e-49f8-89e5-06d0c4925036/64_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_09688939-f53f-4f00-8366-687b244de26d_ACT_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525_SESS_9655a7e0-4673-41c9-90da-a48c008e2d62_OCC_66955dfb-349e-49f8-89e5-06d0c4925036_BOMA__MATRX_','2023-03-30 12:18:21','2023-03-30 14:18:05','64_w1_o1_mandibule_matrix_occ_file_0.m','2023-03-30 14:18:21','SYNCED','47aada63-b6e9-4cc1-8444-3581a142320c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.64.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.64.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.64.1.1.1 Occlusion 1\"}'),(1001,'47ac428d-e0c9-491a-a37b-11c7e4ec7b7b','','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_fa1c1f6f-5c0d-45ca-8646-2a1ca68f51b4_SNAPO__SNAPS_','2022-05-16 17:51:11','2022-05-16 19:50:25','','2022-05-16 19:51:11','SYNCED','47ac428d-e0c9-491a-a37b-11c7e4ec7b7b',0,'2022-05-16 19:51:11','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(2,'47f5a352-41b9-4799-8e13-91efabce0db2','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a4b302c-278d-4e12-ace5-f095ba0bf856/session_6206892a-2e7e-4765-ac90-b49bfb465997/occlusion_7ec70f78-dc80-40c5-b293-570a59f034c4/scan_2ef30e56-ed6b-4233-94dd-08cbb9ef27df/3_w1_o2_maxillaire_scan_file_0.zip','ZIP','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_7ec70f78-dc80-40c5-b293-570a59f034c4_TOSC_2ef30e56-ed6b-4233-94dd-08cbb9ef27df_ZIP_','2022-09-06 09:17:41','2022-08-30 14:20:47','3_w1_o2_maxillaire_scan_file_0.zip','2022-09-06 11:17:41','SYNCED','47f5a352-41b9-4799-8e13-91efabce0db2',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.3.1.2.3\",\"modelMatrix\":\"0.897523,0.421058,-0.131002,0,-0.440967,0.857003,-0.266636,0,8.30491e-10,0.29708,0.954853,0,-25.9823,-2.19041,-18.2404,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'47fc8529-a72e-460b-8907-3892e470eebb','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/computedocclusion_35af1bf5-285a-4bb1-a6db-fe9897defe51/23_w1_o1_ml_occ_file_to1002.xyz','LIFI','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_35af1bf5-285a-4bb1-a6db-fe9897defe51_LIFIO_LIFI_','2022-05-25 10:46:45','2022-05-25 12:46:42','23_w1_o1_ml_occ_file_to1002.xyz','2022-05-25 12:46:45','SYNCED','47fc8529-a72e-460b-8907-3892e470eebb',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.23.1.1.1 Occlusion 4 Ligne de finition 2\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"Maxillaire\",\"name\":\"Ligne de finition 2\",\"title\":\"Ligne finition\",\"toothNumber\":1002}'),(1001,'4856453d-650b-4118-b7c6-d473bd7effb5','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_ce625ba7-4218-40af-b344-df718da13f83/54_w1_o1_snapshot_occ_file_4.png','SNAPS','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_ce625ba7-4218-40af-b344-df718da13f83_SNAPO__SNAPS_','2023-03-15 10:27:03','2023-03-15 11:26:20','54_w1_o1_snapshot_occ_file_4.png','2023-03-15 11:27:03','SYNCED','7646ffac-dba0-4ac0-b4a3-8547134e5318',4,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'48568b30-23dd-4d00-b4de-f54ce8d90d30','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_49bd090f-1a01-4a79-8202-62487b9af783/18_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_BOSC_49bd090f-1a01-4a79-8202-62487b9af783_ZIP_','2022-03-07 14:12:06','2022-03-07 15:12:03','18_w1_o1_mandibule_scan_file_0.zip','2022-03-07 15:12:06','SYNCED','48568b30-23dd-4d00-b4de-f54ce8d90d30',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.18.1.1.1\",\"modelMatrix\":\"-0.740045,-0.667159,0.0850427,0,0.672558,-0.734105,0.0935762,0,1.1198e-09,0.126447,0.991973,0,3.45916,-3.12895,-14.1428,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'487b79f0-f02a-454f-9a94-0c92ab61e123','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/scan_f4fff5f5-f728-44ae-ac48-f3e653594098/23_w1_o1_mordu_anterieur_scan_file_1.zip','ZIP','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_FRSC_f4fff5f5-f728-44ae-ac48-f3e653594098_ZIP_','2022-05-13 10:16:21','2022-05-13 12:16:12','23_w1_o1_mordu_anterieur_scan_file_1.zip','2022-05-13 12:16:21','SYNCED','fe88a495-d983-431f-8551-3e0e8c3fd862',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.23.1.1.1\",\"modelMatrix\":\"0.949837,0.187085,0.26758,0,-0.160399,0.982293,-0.0587988,0,-0.268901,0.0218887,0.961844,0,-3.13315,-5.64448,-28.5361,1\",\"title\":\"Mordu anterieur ZIP\"}'),(1001,'4892453f-f1df-460d-9165-d67b3f21a627','','SNAPS','PATIENT_9e399d73-4d2e-4bb8-af48-a4e597811faa_ACT_b1cf14ce-00a9-48b6-8654-dadde26073f1_SESS_3c4595e0-fbbb-4814-8851-1e014eb9a3b2_BOSC_2e5c0a0e-9906-4afd-990f-353684746eeb_SNAPS_','2022-10-27 11:11:10','2022-10-27 13:10:46','','2022-10-27 13:11:10','SYNCED','4892453f-f1df-460d-9165-d67b3f21a627',0,'2022-10-27 13:11:10','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.46.1.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'48a4df55-ee3e-4ecc-a344-338002adecd5','','ZIP','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_OCC_87edc123-163f-46ce-be5c-45f2ff80b857_BOPLY__ZIP_','2022-05-12 12:27:26','2022-05-12 14:26:51','','2022-05-12 14:27:26','SYNCED','48a4df55-ee3e-4ecc-a344-338002adecd5',0,'2022-05-12 14:27:26','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.18.1.1.3 Occlusion 3\",\"modelMatrix\":\"-0.721265,0.622319,-0.304132,0,-0.69266,-0.648019,0.316692,0,5.59464e-09,0.439079,0.898449,0,-8.58806,-18.2472,-17.8803,1\",\"referenceScanID\":\"1.18.1.1.3\",\"title\":\"Mandibule 1.18.1.1.3 Occlusion 3\"}'),(1001,'48afa4c7-21ba-4151-9a0b-2ab41c611fc4','','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_a16e268c-a9f5-4f0b-8346-6f1984df70bb_ZIP_','2022-02-04 11:29:38','2022-02-02 11:14:58','','2022-02-04 12:29:38','SYNCED','48afa4c7-21ba-4151-9a0b-2ab41c611fc4',0,'2022-02-04 12:29:38','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.2\",\"modelMatrix\":\"-0.961822,0.259307,-0.0875072,0,-0.273675,-0.911329,0.307542,0,5.65717e-9,0.319749,0.947502,0,33.7925,-1.80222,-15.4388,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'48ca5e89-974f-45f9-85f2-85c4644fb297','','ZIP','PATIENT_593972a6-d7d6-4802-b87d-38aab371f71e_ACT_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480_SESS_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3_OCC_4e1258a6-b789-451f-bfe8-8b395e1129d8_TOPLY__ZIP_','2022-01-19 15:25:10','2022-01-19 16:24:43','',NULL,'CREATED','48ca5e89-974f-45f9-85f2-85c4644fb297',0,'2022-01-19 16:25:10','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.3.1.1.1 Occlusion 3\",\"modelMatrix\":\"-0.8207,0.559215,-0.117173,0,-0.571359,-0.803257,0.168307,0,5.51916e-9,0.205077,0.978746,0,22.3383,-22.9288,-32.0145,1\",\"referenceScanID\":\"1.3.1.1.1\",\"title\":\"Maxillaire 1.3.1.1.1 Occlusion 3\"}'),(1001,'492a076f-4aae-4415-bc89-4cd1857a9549','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_ce625ba7-4218-40af-b344-df718da13f83/54_w1_o1_maxillaire_matrix_occ_file_6.m','MATRX','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_ce625ba7-4218-40af-b344-df718da13f83_TOMA__MATRX_','2023-03-15 10:35:05','2023-03-15 11:32:26','54_w1_o1_maxillaire_matrix_occ_file_6.m','2023-03-15 11:35:05','SYNCED','ccf7be44-96c0-48d2-80d6-833cb64e29bc',6,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.54.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.54.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.54.1.1.1 Occlusion 1\"}'),(1001,'4950cdef-b657-4b19-9de2-3e3927bfbe80','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/4fa1a134-d246-43d7-aa8c-b42e24b62b49/session_6aedf6fd-46d7-4259-88ba-5cf074ad5913/occlusion_47192ebb-25b6-4c9e-a09f-8ed295e60a87/scan_08beae91-887f-4723-8e18-ef9fee36100e/60_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_4fa1a134-d246-43d7-aa8c-b42e24b62b49_ACT_6aedf6fd-46d7-4259-88ba-5cf074ad5913_SESS_47192ebb-25b6-4c9e-a09f-8ed295e60a87_BOSC_08beae91-887f-4723-8e18-ef9fee36100e_ZIP_','2023-03-07 18:08:57','2023-03-07 19:08:40','60_w1_o1_mandibule_scan_file_1.zip','2023-03-07 19:08:57','SYNCED','3b51e795-dcfd-4ab7-87b5-b113cb1c8e09',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.60.1.1.1\",\"modelMatrix\":\"-0.972406,0.231296,-0.0304828,0,-0.233296,-0.964069,0.127056,0,6.40341e-11,0.130662,0.991427,0,16.8846,-6.99953,-16.9641,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'498f6778-802a-47f0-b4ab-22e9392831be','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_a1bc5849-382d-4646-be42-6c870a889494/24_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_FRSC_a1bc5849-382d-4646-be42-6c870a889494_SNAPS_','2022-05-24 14:57:26','2022-05-24 16:57:17','24_w1_o1_mordu_anterieur_snapshot_0.png','2022-05-24 16:57:26','SYNCED','498f6778-802a-47f0-b4ab-22e9392831be',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.24.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'4a1a5a35-8969-4721-8ec6-7e6b023b1fdf','','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_9440baee-a8bf-406c-bc0a-f5e9596f197b_TOPLY__ZIP_','2022-05-13 16:14:03','2022-05-13 18:13:11','','2022-05-13 18:14:03','SYNCED','4a1a5a35-8969-4721-8ec6-7e6b023b1fdf',0,'2022-05-13 18:14:03','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.2 Occlusion 3\",\"modelMatrix\":\"-0.80453,0.576793,-0.141569,0,-0.593912,-0.781339,0.191773,0,-6.05286e-09,0.238367,0.971175,0,0.910551,-5.61768,-25.9513,1\",\"referenceScanID\":\"1.24.1.1.2\",\"title\":\"Maxillaire 1.24.1.1.2 Occlusion 3\"}'),(1001,'4ae955d0-02d4-45a8-a7af-12e38e935e6f','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/39062d60-7a18-417a-9004-c58e9ce7d62a/session_9869e99c-7b47-4662-9766-0388d668fbf3/occlusion_36832844-9579-46df-aea1-b9baf6ad8787/computedocclusion_a2f94254-4555-4b27-973a-d1034950f081/61_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_39062d60-7a18-417a-9004-c58e9ce7d62a_ACT_9869e99c-7b47-4662-9766-0388d668fbf3_SESS_36832844-9579-46df-aea1-b9baf6ad8787_OCC_a2f94254-4555-4b27-973a-d1034950f081_BOMA__MATRX_','2023-03-10 17:33:54','2023-03-10 18:33:29','61_w1_o1_mandibule_matrix_occ_file_0.m','2023-03-10 18:33:54','SYNCED','4ae955d0-02d4-45a8-a7af-12e38e935e6f',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.61.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.61.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.61.1.1.1 Occlusion 1\"}'),(1001,'4aea7a79-8371-4db5-8510-b9150d842cbe','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/986374de-c4d7-4d6f-bf0c-2dc7e3b859a9/session_c81670ed-4144-4347-b19e-8057d11b5f7c/occlusion_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be/scan_d969cedf-8de4-4e27-8d4d-f4a1e8eac60c/28_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_986374de-c4d7-4d6f-bf0c-2dc7e3b859a9_ACT_c81670ed-4144-4347-b19e-8057d11b5f7c_SESS_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be_TOSC_d969cedf-8de4-4e27-8d4d-f4a1e8eac60c_SNAPS_','2022-05-31 10:30:36','2022-05-31 12:30:23','28_w1_o1_maxillaire_snapshot_0.png','2022-05-31 12:30:36','SYNCED','4aea7a79-8371-4db5-8510-b9150d842cbe',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.28.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'4b05a0d4-2193-4350-856f-f38547af5710','','MATRX','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_ea89007b-3846-43ef-92f9-d5c7aa1a7dfa_TOMA__MATRX_','2022-05-25 08:56:32','2022-05-13 18:35:18','','2022-05-25 10:56:32','SYNCED','4b05a0d4-2193-4350-856f-f38547af5710',0,'2022-05-25 10:56:32','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.24.1.1.2 Occlusion 5\",\"referenceScanID\":\"1.24.1.1.2\",\"title\":\"Matrice Transfo. Maxillaire 1.24.1.1.2 Occlusion 5\"}'),(1001,'4b5e052c-6fa0-40dd-8626-da704f01e9f9','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5a33a64b-822d-40bf-ba8c-e11c11a50f88/session_e0a7776f-79fe-4c85-85ab-9ca244e7ff95/occlusion_b3568df2-4c54-486e-b27f-2d92375e5d11/scan_247ba975-b9ca-41c4-8c63-f046d64da761/43_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_5a33a64b-822d-40bf-ba8c-e11c11a50f88_ACT_e0a7776f-79fe-4c85-85ab-9ca244e7ff95_SESS_b3568df2-4c54-486e-b27f-2d92375e5d11_BOSC_247ba975-b9ca-41c4-8c63-f046d64da761_ZIP_','2022-10-11 14:24:51','2022-10-11 16:24:35','43_w1_o1_mandibule_scan_file_1.zip','2022-10-11 16:24:51','SYNCED','3ba9a25c-db9a-443b-a917-fb6c9cc3c459',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.43.1.1.1\",\"modelMatrix\":\"-0.587579,0.769182,-0.251217,0,-0.809167,-0.558544,0.182422,0,-1.48846e-08,0.310463,0.950585,0,25.9084,-18.4558,-18.8692,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'4b61e24a-44ff-4634-938e-a66421b991de','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/98aa55d8-3848-48e0-9684-5597786b85c7/session_4df1e430-5cbb-4a6c-8292-747e35e6f1e8/occlusion_fcc5c65d-b0e4-4036-99c7-07318171986a/scan_3b296950-48dd-4691-8dfd-0e5fe6997fdf/66_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_98aa55d8-3848-48e0-9684-5597786b85c7_ACT_4df1e430-5cbb-4a6c-8292-747e35e6f1e8_SESS_fcc5c65d-b0e4-4036-99c7-07318171986a_LESC_3b296950-48dd-4691-8dfd-0e5fe6997fdf_ZIP_','2023-04-13 10:07:03','2023-04-13 12:07:03','66_w1_o1_mordu_posterieur_gauche_scan_file_0.zip',NULL,'CREATED','4b61e24a-44ff-4634-938e-a66421b991de',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.66.1.1.1\",\"modelMatrix\":\"-0.990873,-0.140875,0.0138494,0,0.121047,-0.929598,-0.330425,0,0.0597641,-0.341066,0.943883,0,20.6826,13.3119,-17.1718,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'4b857ad9-9df3-4a2f-848a-64d97e7f4e49','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/scan_03839278-13f8-46e6-9581-ba11bc8bcb81/1_w1_o1_maxillaire_scan_file_6.zip','ZIP','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_TOSC_03839278-13f8-46e6-9581-ba11bc8bcb81_ZIP_','2022-01-19 13:03:29','2022-01-19 11:35:09','1_w1_o1_maxillaire_scan_file_6.zip','2022-01-19 14:03:29','SYNCED','96dd75bb-5035-460a-8afc-04f3755604b1',6,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.1.1.1.1\",\"modelMatrix\":\"-0.154277,0.952805,-0.261459,0,-0.988028,-0.148777,0.0408259,0,-2.59672e-9,0.264627,0.964351,0,-14.8611,-36.6101,-15.3158,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'4b90930b-b4dd-4eae-8b5f-8c8f04e970c6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/computedocclusion_6960b50e-6f78-4f83-9303-8c985410457c/4_w1_o4_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_OCC_6960b50e-6f78-4f83-9303-8c985410457c_TOMA__MATRX_','2022-05-31 14:55:58','2022-05-31 16:55:44','4_w1_o4_maxillaire_matrix_occ_file_0.m','2022-05-31 16:55:58','SYNCED','4b90930b-b4dd-4eae-8b5f-8c8f04e970c6',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.4.1.4.1 Occlusion 5\",\"referenceScanID\":\"1.4.1.4.1\",\"title\":\"Matrice Transfo. Maxillaire 1.4.1.4.1 Occlusion 5\"}'),(1001,'4bc8bbc2-a943-4af1-a2a9-b06f461fcfcc','','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_7d8decb1-23db-4824-940f-8d8822d88813_BOPLY__ZIP_','2022-02-08 08:48:59','2022-02-07 18:48:45','','2022-02-08 09:48:59','SYNCED','4bc8bbc2-a943-4af1-a2a9-b06f461fcfcc',0,'2022-02-08 09:48:59','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.17.1.1.1 Occlusion 3\",\"modelMatrix\":\"-0.980954,-0.188901,0.0452269,0,0.19424,-0.953992,0.228406,0,1.35057e-9,0.232841,0.972515,0,27.4349,19.1019,-20.1379,1\",\"referenceScanID\":\"1.17.1.1.1\",\"title\":\"Mandibule 1.17.1.1.1 Occlusion 3\"}'),(1001,'4bf52f65-04f9-420f-bc0d-457f239f1bc0','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/computedocclusion_2de3d2bb-d512-4514-8bed-a879b73a6028/22_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_OCC_2de3d2bb-d512-4514-8bed-a879b73a6028_BOMA__MATRX_','2022-04-21 11:29:39','2022-04-21 13:29:16','22_w1_o1_mandibule_matrix_occ_file_0.m','2022-04-21 13:29:39','SYNCED','4bf52f65-04f9-420f-bc0d-457f239f1bc0',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.22.1.1.1 Occlusion 7\",\"referenceScanID\":\"1.22.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.22.1.1.1 Occlusion 7\"}'),(1001,'4bf7dce1-a998-4b64-8333-9a01e60cea8a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/de078619-3946-4adb-a799-1c260e16face/session_24d0aeb5-3058-4070-aeea-97c289e41e3c/occlusion_ea6da896-1504-41fc-890c-7c48575e9e40/scan_aa24138a-68e8-4bc3-9a5d-d617f0fe496b/2_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_de078619-3946-4adb-a799-1c260e16face_ACT_24d0aeb5-3058-4070-aeea-97c289e41e3c_SESS_ea6da896-1504-41fc-890c-7c48575e9e40_TOSC_aa24138a-68e8-4bc3-9a5d-d617f0fe496b_ZIP_','2022-01-19 14:06:34','2022-01-19 15:06:17','2_w1_o1_maxillaire_scan_file_1.zip','2022-01-19 15:06:34','SYNCED','80d822aa-8c38-4390-bdc1-0b044f167d73',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.2.1.1.1\",\"modelMatrix\":\"0.999524,0.0288188,-0.0110138,0,-0.0308516,0.933663,-0.356821,0,-3.83807e-10,0.356991,0.934108,0,-21.932,-35.0893,-21.8585,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'4c4f5567-afa0-4bb0-9782-09482e7b807c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a47006e-5c4a-4fab-835f-67e3301b2acf/session_d0298050-98d9-4076-b3bd-110404d60135/occlusion_c5f98876-f420-4912-bd39-cfffac649936/scan_41295122-614f-4e97-b820-f8a9940950f4/4_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_6a47006e-5c4a-4fab-835f-67e3301b2acf_ACT_d0298050-98d9-4076-b3bd-110404d60135_SESS_c5f98876-f420-4912-bd39-cfffac649936_TOSC_41295122-614f-4e97-b820-f8a9940950f4_ZIP_','2022-09-06 09:20:25','2022-09-06 11:20:25','4_w1_o1_maxillaire_scan_file_0.zip',NULL,'CREATED','4c4f5567-afa0-4bb0-9782-09482e7b807c',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.4.1.1.1\",\"modelMatrix\":\"0.288216,-0.89868,0.330614,0,0.957565,0.270492,-0.0995111,0,-6.83428e-09,0.345265,0.938505,0,-3.52566,-41.0641,-17.0348,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'4c80ac2a-8eb6-49d9-a363-ce9ac5090d47','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/7c3827a5-fcb4-4892-bab3-8d6a4e6382f0/session_cb98e8a0-e16d-4640-919e-9b968e57d3db/occlusion_29633526-06c5-413c-8029-9f27d6a28b53/scan_ab6c69b1-8cac-45ec-8fee-f2371813f161/63_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_7c3827a5-fcb4-4892-bab3-8d6a4e6382f0_ACT_cb98e8a0-e16d-4640-919e-9b968e57d3db_SESS_29633526-06c5-413c-8029-9f27d6a28b53_TOSC_ab6c69b1-8cac-45ec-8fee-f2371813f161_SNAPS_','2023-03-20 14:30:59','2023-03-20 15:30:26','63_w1_o1_maxillaire_snapshot_0.png','2023-03-20 15:30:59','SYNCED','4c80ac2a-8eb6-49d9-a363-ce9ac5090d47',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.63.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'4c85fe3b-92ce-4c9f-bba8-70bca998d5fc','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7f47fd88-9ea0-4c08-9193-a54d4f158c7c/session_7873a396-419c-4215-83c7-fec9f2742ccf/occlusion_2e287bb0-e19a-414a-9177-23b335d286d9/scan_05d5d943-3268-4239-ac7d-5efbc2d2ab9b/16_w1_o2_maxillaire_snapshot_0.png','SNAPS','PATIENT_7f47fd88-9ea0-4c08-9193-a54d4f158c7c_ACT_7873a396-419c-4215-83c7-fec9f2742ccf_SESS_2e287bb0-e19a-414a-9177-23b335d286d9_TOSC_05d5d943-3268-4239-ac7d-5efbc2d2ab9b_SNAPS_','2022-06-03 08:48:49','2022-06-03 10:48:39','16_w1_o2_maxillaire_snapshot_0.png','2022-06-03 10:48:49','SYNCED','4c85fe3b-92ce-4c9f-bba8-70bca998d5fc',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.16.1.2.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'4cd7d72e-db82-4735-a148-092d6793803f','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_19ce66b5-7943-4a9e-82cd-f21481da98cc/54_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_19ce66b5-7943-4a9e-82cd-f21481da98cc_BOMA__MATRX_','2023-03-15 10:41:57','2023-03-15 11:40:15','54_w1_o1_mandibule_matrix_occ_file_0.m','2023-03-15 11:41:57','SYNCED','4cd7d72e-db82-4735-a148-092d6793803f',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.54.1.1.6 Occlusion 2\",\"referenceScanID\":\"1.54.1.1.6\",\"title\":\"Matrice Transfo. Mandibule 1.54.1.1.6 Occlusion 2\"}'),(1001,'4d069ae2-84d8-4d50-a251-f43a7ea92bf9','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/e922efb9-8c03-445b-8a0f-449e3c43bdca/session_a2369349-1629-40ad-8784-d271bc3fbade/occlusion_292cc1aa-8b12-463b-87a1-7d9731cf886b/scan_d1ea0460-f48a-4dc1-a0ae-c13f265abac4/21_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_e922efb9-8c03-445b-8a0f-449e3c43bdca_ACT_a2369349-1629-40ad-8784-d271bc3fbade_SESS_292cc1aa-8b12-463b-87a1-7d9731cf886b_RISC_d1ea0460-f48a-4dc1-a0ae-c13f265abac4_ZIP_','2022-04-21 08:52:46','2022-04-21 10:52:38','21_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-04-21 10:52:46','SYNCED','4d069ae2-84d8-4d50-a251-f43a7ea92bf9',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.21.1.1.2\",\"modelMatrix\":\"0.994753,-0.0885331,0.0483952,0,0.0823669,0.990498,0.108801,0,-0.0607708,-0.105244,0.99289,0,-13.9918,7.01422,-18.0194,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'4d100c2c-4fae-4fc3-9a34-d793e8c7f550','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/1a8329eb-7dbc-4bfd-b669-6d92e13fec0c/session_11fb4259-c305-4a08-b750-536f769f44b0/occlusion_129468ab-1f43-4ba1-8939-49286128bf4d/scan_9854edc6-add4-4448-8ef5-3a671649b8a9/47_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_1a8329eb-7dbc-4bfd-b669-6d92e13fec0c_ACT_11fb4259-c305-4a08-b750-536f769f44b0_SESS_129468ab-1f43-4ba1-8939-49286128bf4d_LESC_9854edc6-add4-4448-8ef5-3a671649b8a9_SNAPS_','2022-10-21 16:19:38','2022-10-21 18:19:30','47_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-10-21 18:19:38','SYNCED','4d100c2c-4fae-4fc3-9a34-d793e8c7f550',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.47.1.1.2\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'4d2887e9-9f2a-46be-8a39-4a7b9dc42bc6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_f9c2783a-c405-481c-a97e-47bb9db0d0d2/17_w1_o1_mordu_posterieur_droit_scan_file_1.zip','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_RISC_f9c2783a-c405-481c-a97e-47bb9db0d0d2_ZIP_','2022-02-07 11:47:25','2022-02-07 12:44:04','17_w1_o1_mordu_posterieur_droit_scan_file_1.zip','2022-02-07 12:47:25','SYNCED','ee6ba447-6aa9-4446-ac83-1541e7fe80b7',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.17.1.1.1\",\"modelMatrix\":\"0.958858,-0.278951,0.0584984,0,0.279373,0.96007,0.00245979,0,-0.0507895,0.023133,0.998345,0,-18.2614,12.5541,-16.0474,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'4d803815-9470-468e-afb5-8b1d9b629641','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/scan_1a0b9502-8df2-41a2-89eb-2def508b7462/22_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_RISC_1a0b9502-8df2-41a2-89eb-2def508b7462_SNAPS_','2022-04-21 17:38:20','2022-04-21 19:38:19','22_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-04-21 19:38:20','SYNCED','4d803815-9470-468e-afb5-8b1d9b629641',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.22.1.1.6\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'4d931155-9fb2-4358-a1c7-465f58401480','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_731ce686-8c03-4019-bc8e-040c31652c88/4_w1_o2_mandibule_snapshot_0.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_BOSC_731ce686-8c03-4019-bc8e-040c31652c88_SNAPS_','2022-03-08 12:00:04','2022-03-08 12:59:57','4_w1_o2_mandibule_snapshot_0.png','2022-03-08 13:00:04','SYNCED','4d931155-9fb2-4358-a1c7-465f58401480',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.2.4\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'4db49ccf-ee2d-45c8-a24a-6c481b66e4f6','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_ce625ba7-4218-40af-b344-df718da13f83/54_w1_o1_maxillaire_occlusion_occ_file_3.zip','ZIP','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_ce625ba7-4218-40af-b344-df718da13f83_TOPLY__ZIP_','2023-03-15 10:17:55','2023-03-15 11:16:15','54_w1_o1_maxillaire_occlusion_occ_file_3.zip','2023-03-15 11:17:55','SYNCED','ad02dce8-3ff6-4167-add8-6925d6562d5e',3,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.54.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.78238,0.620977,-0.0476379,0,-0.622801,0.780088,-0.059844,0,1.97556e-09,0.0764897,0.99707,0,-23.5433,3.60536,-19.7037,1\",\"referenceScanID\":\"1.54.1.1.1\",\"title\":\"Maxillaire 1.54.1.1.1 Occlusion 1\"}'),(1001,'4de4c841-84ef-4a04-bb69-6b6aef451fd1','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/98aa55d8-3848-48e0-9684-5597786b85c7/session_4df1e430-5cbb-4a6c-8292-747e35e6f1e8/occlusion_fcc5c65d-b0e4-4036-99c7-07318171986a/scan_9415795d-cf35-41d8-a989-d38dada847f9/66_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_98aa55d8-3848-48e0-9684-5597786b85c7_ACT_4df1e430-5cbb-4a6c-8292-747e35e6f1e8_SESS_fcc5c65d-b0e4-4036-99c7-07318171986a_TOSC_9415795d-cf35-41d8-a989-d38dada847f9_SNAPS_','2023-04-13 09:40:32','2023-04-13 11:40:32','66_w1_o1_maxillaire_snapshot_0.png',NULL,'CREATED','4de4c841-84ef-4a04-bb69-6b6aef451fd1',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire SNAPSHOT\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'4dfde161-5e5f-46cd-b413-649e565d2640','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_b28164eb-0070-4968-83be-bfabe1a0c839/13_w1_o1_mandibule_scan_file_4.zip','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_b28164eb-0070-4968-83be-bfabe1a0c839_ZIP_','2022-02-04 17:57:00','2022-02-04 17:03:59','13_w1_o1_mandibule_scan_file_4.zip','2022-02-04 18:57:00','SYNCED','d8a3bf39-16d1-435f-bafa-6c625f77d811',4,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.5\",\"modelMatrix\":\"-0.980986,-0.182732,0.0653907,0,0.19408,-0.923628,0.33052,0,1.2429e-9,0.336927,0.941531,0,23.7056,9.64329,-24.5584,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'4e0a0002-d93c-4b33-ba51-9cc84cb7c62e','','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_ea89007b-3846-43ef-92f9-d5c7aa1a7dfa_SNAPO__SNAPS_','2022-05-25 08:56:33','2022-05-13 18:35:18','','2022-05-25 10:56:33','SYNCED','4e0a0002-d93c-4b33-ba51-9cc84cb7c62e',0,'2022-05-25 10:56:33','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'4e0a4109-35b7-4c91-b28f-2ae7a227dbb7','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/57c4096f-98dd-49c8-bea5-a5b109ad3fd0/session_4f62e395-5623-4d5b-869c-1b2fc4d22b00/occlusion_1ac20dc7-b36b-4786-a05f-37091554dc5c/computedocclusion_70f4220e-2a6b-4575-bd0e-09c14a13d758/31_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_57c4096f-98dd-49c8-bea5-a5b109ad3fd0_ACT_4f62e395-5623-4d5b-869c-1b2fc4d22b00_SESS_1ac20dc7-b36b-4786-a05f-37091554dc5c_OCC_70f4220e-2a6b-4575-bd0e-09c14a13d758_TOMA__MATRX_','2022-06-16 11:04:12','2022-06-16 13:03:55','31_w1_o1_maxillaire_matrix_occ_file_0.m','2022-06-16 13:04:12','SYNCED','4e0a4109-35b7-4c91-b28f-2ae7a227dbb7',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.31.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.31.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.31.1.1.1 Occlusion 1\"}'),(1001,'4e0b586d-010c-4f46-ba34-26a139bf9937','','ZIP','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_OCC_d58ce31f-4b72-44ad-b0e0-3d5d7d789322_BOPLY__ZIP_','2022-01-19 11:15:36','2022-01-19 12:06:18','',NULL,'CREATED','4e0b586d-010c-4f46-ba34-26a139bf9937',0,'2022-01-19 12:15:36','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.1.1.1.1 Occlusion 1\",\"modelMatrix\":\"-0.89361,0.44322,-0.0708281,0,-0.448843,-0.882414,0.141013,0,3.36694e-10,0.157801,0.987471,0,37.1181,-2.30066,-14.9109,1\",\"referenceScanID\":\"1.1.1.1.1\",\"title\":\"Mandibule 1.1.1.1.1 Occlusion 1\"}'),(1001,'4e314863-9541-4695-89b3-e779d1c55265','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_ce625ba7-4218-40af-b344-df718da13f83/54_w1_o1_mandibule_occlusion_occ_file_5.zip','ZIP','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_ce625ba7-4218-40af-b344-df718da13f83_BOPLY__ZIP_','2023-03-15 10:33:05','2023-03-15 11:32:25','54_w1_o1_mandibule_occlusion_occ_file_5.zip','2023-03-15 11:33:05','SYNCED','d1adede1-c3da-47da-a47c-075f5a6fe836',5,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.54.1.1.4 Occlusion 1\",\"modelMatrix\":\"-0.999599,0.0258183,-0.0116515,0,-0.0283256,-0.911116,0.411175,0,-3.36598e-10,0.41134,0.911482,0,17.4173,6.0967,-21.0427,1\",\"referenceScanID\":\"1.54.1.1.4\",\"title\":\"Mandibule 1.54.1.1.4 Occlusion 1\"}'),(1001,'4ef0e4c6-7af6-4a33-bcf6-e71d605019ff','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5/occlusion_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa/computedocclusion_0dbd67b0-3e41-4bfc-bb6d-b848ad2e78c8/24_w2_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5_SESS_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa_OCC_0dbd67b0-3e41-4bfc-bb6d-b848ad2e78c8_TOPLY__ZIP_','2022-10-08 14:15:38','2022-10-08 16:15:02','24_w2_o1_maxillaire_occlusion_occ_file_0.zip','2022-10-08 16:15:38','SYNCED','4ef0e4c6-7af6-4a33-bcf6-e71d605019ff',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.2.1.1 Occlusion 3\",\"modelMatrix\":\"0.626985,0.76241,-0.160065,0,-0.779032,0.613607,-0.128824,0,4.39427e-09,0.205467,0.978664,0,0.203644,-29.5943,-18.0319,1\",\"referenceScanID\":\"1.24.2.1.1\",\"title\":\"Maxillaire 1.24.2.1.1 Occlusion 3\"}'),(1001,'4ef4a778-c652-4a4d-b0ab-26259314c303','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_6c9ae07a-23c3-4355-87ff-b57ef558a4ea/17_w1_o1_mordu_posterieur_gauche_scan_file_1.zip','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_LESC_6c9ae07a-23c3-4355-87ff-b57ef558a4ea_ZIP_','2022-02-11 16:09:43','2022-02-11 17:09:32','17_w1_o1_mordu_posterieur_gauche_scan_file_1.zip','2022-02-11 17:09:43','SYNCED','46be4566-2ed9-474b-bbd1-c7748e98f460',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.17.1.1.3\",\"modelMatrix\":\"-0.994733,0.0873893,0.0549181,0,-0.0832057,-0.992685,0.0917926,0,0.0599197,0.0833779,0.994272,0,-5.89408,0.0239513,-18.3172,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'4f07ebb2-0ea0-42e6-b14a-6848c5ddfa51','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3ed7a8e0-5b4d-4ecf-b4ae-f855b16c0f93/session_fb42cec6-0bb6-41e9-912d-0517ff8e0942/occlusion_fb214b2f-5e41-492d-85c4-d4a11a3947c5/scan_5246161b-13eb-438c-8365-2fc243141f9b/42_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_3ed7a8e0-5b4d-4ecf-b4ae-f855b16c0f93_ACT_fb42cec6-0bb6-41e9-912d-0517ff8e0942_SESS_fb214b2f-5e41-492d-85c4-d4a11a3947c5_TOSC_5246161b-13eb-438c-8365-2fc243141f9b_SNAPS_','2022-10-07 11:52:09','2022-10-07 13:51:53','42_w1_o1_maxillaire_snapshot_0.png','2022-10-07 13:52:09','SYNCED','4f07ebb2-0ea0-42e6-b14a-6848c5ddfa51',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.42.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'4f401606-db4e-4efa-be4f-fb461f5aedc5','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_f62659c6-4f30-430c-95e4-d14e40327192/13_w1_o1_mordu_anterieur_scan_file_0.zip','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_FRSC_f62659c6-4f30-430c-95e4-d14e40327192_ZIP_','2022-02-04 17:54:37','2022-02-04 17:27:12','13_w1_o1_mordu_anterieur_scan_file_0.zip','2022-02-04 18:54:37','SYNCED','4f401606-db4e-4efa-be4f-fb461f5aedc5',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.13.1.1.2\",\"modelMatrix\":\"0.953323,-0.314537,0.0701576,0,0.291713,0.949017,0.129459,0,-0.0833426,-0.0546414,0.990463,0,-9.41378,2.15841,-20.3131,1\",\"title\":\"Mordu anterieur ZIP\"}'),(1001,'4f77dab6-d9a8-464f-a28e-e9fc7afdbd4f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/32710234-804f-46f5-899d-eed636f8a906/session_64c1427a-b91d-4675-94df-f36bd40e9b0f/occlusion_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a/scan_3954e24e-9220-452b-a8fa-b1fbde6ebcad/33_w2_o1_mandibule_snapshot_2.png','SNAPS','PATIENT_32710234-804f-46f5-899d-eed636f8a906_ACT_64c1427a-b91d-4675-94df-f36bd40e9b0f_SESS_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a_BOSC_3954e24e-9220-452b-a8fa-b1fbde6ebcad_SNAPS_','2022-06-28 09:03:26','2022-06-28 11:03:14','33_w2_o1_mandibule_snapshot_2.png','2022-06-28 11:03:26','SYNCED','fe809790-75be-4a2e-9d94-7358f686eecf',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.33.2.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'4f78b537-b4c1-4a9a-92f0-2d1e738c56cf','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/8b4b6de2-edd8-44e6-88c6-8a151914aca6/session_40a1b174-1058-4d27-b63a-4e8f565fb520/occlusion_8eba4eab-4337-436a-8eb6-b59e63415159/scan_356a169f-0c3a-464b-82af-2d744e3bef4a/48_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_8b4b6de2-edd8-44e6-88c6-8a151914aca6_ACT_40a1b174-1058-4d27-b63a-4e8f565fb520_SESS_8eba4eab-4337-436a-8eb6-b59e63415159_TOSC_356a169f-0c3a-464b-82af-2d744e3bef4a_SNAPS_','2022-11-10 10:37:06','2022-11-10 11:36:59','48_w1_o1_maxillaire_snapshot_0.png','2022-11-10 11:37:06','SYNCED','4f78b537-b4c1-4a9a-92f0-2d1e738c56cf',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.48.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'4f8aa0a2-a0fd-4089-b2d6-acf518c06dd9','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/9e399d73-4d2e-4bb8-af48-a4e597811faa/session_b1cf14ce-00a9-48b6-8654-dadde26073f1/occlusion_3c4595e0-fbbb-4814-8851-1e014eb9a3b2/computedocclusion_69c0f244-5ccf-4ce5-aa31-27a50e7c92a0/46_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_9e399d73-4d2e-4bb8-af48-a4e597811faa_ACT_b1cf14ce-00a9-48b6-8654-dadde26073f1_SESS_3c4595e0-fbbb-4814-8851-1e014eb9a3b2_OCC_69c0f244-5ccf-4ce5-aa31-27a50e7c92a0_BOPLY__ZIP_','2022-10-27 17:25:11','2022-10-27 19:24:54','46_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-10-27 19:25:11','SYNCED','4f8aa0a2-a0fd-4089-b2d6-acf518c06dd9',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.46.1.1.2 Occlusion 1\",\"modelMatrix\":\"-0.781388,0.613261,-0.115515,0,-0.624045,-0.767885,0.14464,0,3.896e-09,0.185107,0.982718,0,20.8068,-10.6268,-17.296,1\",\"referenceScanID\":\"1.46.1.1.2\",\"title\":\"Mandibule 1.46.1.1.2 Occlusion 1\"}'),(1001,'502162a6-a0d3-4c4e-9cf3-8d014a530435','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/computedocclusion_b903dd27-411a-4a7c-b357-1cc9a414dbdd/17_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_b903dd27-411a-4a7c-b357-1cc9a414dbdd_TOMA__MATRX_','2022-02-12 16:54:33','2022-02-12 17:53:18','17_w1_o1_maxillaire_matrix_occ_file_0.m','2022-02-12 17:54:33','SYNCED','502162a6-a0d3-4c4e-9cf3-8d014a530435',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.17.1.1.1 Occlusion 7\",\"referenceScanID\":\"1.17.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.17.1.1.1 Occlusion 7\"}'),(1001,'5026a628-2699-41e4-bf38-53dbeed10fdb','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/scan_43a4533f-b510-4e1d-8a8e-bcb6dbd8b4d4/54_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_TOSC_43a4533f-b510-4e1d-8a8e-bcb6dbd8b4d4_ZIP_','2022-12-13 09:51:50','2022-12-13 10:51:40','54_w1_o1_maxillaire_scan_file_1.zip','2022-12-13 10:51:50','SYNCED','fc421aee-c023-41a7-a658-8399c5f347f9',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.54.1.1.1\",\"modelMatrix\":\"0.78238,0.620977,-0.0476379,0,-0.622801,0.780088,-0.059844,0,1.97556e-09,0.0764897,0.99707,0,-23.5433,3.60536,-19.7037,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'5065e06b-2a6d-4eed-ad88-93c9743302e9','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_04d6e3f1-19ce-4851-a9d0-40419cea7542/scan_fef6f617-40e8-4052-8a2d-9af9e39ab22d/19_w1_o2_mandibule_scan_file_2.zip','ZIP','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_04d6e3f1-19ce-4851-a9d0-40419cea7542_BOSC_fef6f617-40e8-4052-8a2d-9af9e39ab22d_ZIP_','2022-04-15 14:06:59','2022-04-15 16:06:50','19_w1_o2_mandibule_scan_file_2.zip','2022-04-15 16:06:59','SYNCED','6fc1ad7b-72f9-4540-9e11-3ded800f23dc',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.2.2\",\"modelMatrix\":\"0.922398,0.363551,-0.130433,0,-0.386241,0.868211,-0.311491,0,8.299e-09,0.337698,0.941255,0,3.01727,1.11171,-28.7776,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'510471aa-b2e2-4205-bdc2-67a8d1957d49','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/452a5200-3e06-4b74-8949-6abc7f2dda8a/session_3e95d626-668f-45f7-98ad-be2cf9d7b90b/order_de50ab2d-d622-4973-a0f1-fd569575b61a/26_w1_couronne_prost_file_510471aa-b2e2-4205-bdc2-67a8d1957d49_0.pdf','PDF','PATIENT_452a5200-3e06-4b74-8949-6abc7f2dda8a_ACT_3e95d626-668f-45f7-98ad-be2cf9d7b90b_PROST_de50ab2d-d622-4973-a0f1-fd569575b61a_PDF_','2022-05-25 11:20:17','2022-05-25 13:20:15','26_w1_couronne_prost_file_510471aa-b2e2-4205-bdc2-67a8d1957d49_0.pdf','2022-05-25 13:20:17','SYNCED','510471aa-b2e2-4205-bdc2-67a8d1957d49',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.26.1.1 COURONNE\",\"title\":\"Couronne PDF\"}'),(1001,'51783946-4939-4c6c-9e57-f1e450c81a9a','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/9e399d73-4d2e-4bb8-af48-a4e597811faa/session_b1cf14ce-00a9-48b6-8654-dadde26073f1/occlusion_1060c95f-48f4-4a37-9b82-03bfd8329730/scan_f1e1a23d-a279-4fec-8d2c-40dc846885d2/46_w1_o2_mandibule_snapshot_0.png','SNAPS','PATIENT_9e399d73-4d2e-4bb8-af48-a4e597811faa_ACT_b1cf14ce-00a9-48b6-8654-dadde26073f1_SESS_1060c95f-48f4-4a37-9b82-03bfd8329730_BOSC_f1e1a23d-a279-4fec-8d2c-40dc846885d2_SNAPS_','2023-01-20 14:25:38','2023-01-20 15:25:28','46_w1_o2_mandibule_snapshot_0.png','2023-01-20 15:25:38','SYNCED','51783946-4939-4c6c-9e57-f1e450c81a9a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.46.1.2.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'51860c04-fdfe-4bde-923f-956ac5bcfcbd','','ZIP','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_LESC_890154d7-23d4-4fb6-a767-967ce5a423f7_ZIP_','2022-09-09 16:30:34','2022-09-09 18:19:25','','2022-09-09 18:30:34','SYNCED','51860c04-fdfe-4bde-923f-956ac5bcfcbd',0,'2022-09-09 18:30:34','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.39.1.1.2\",\"modelMatrix\":\"-0.978812,0.196139,0.00396484,0,-0.202913,-0.944691,0.24922,0,0.0353639,0.263853,0.96888,0,-6.42769,0.929324,-20.8752,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'51a9191a-3d52-4dbe-a549-0616a8adb43b','','MATRX','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_OCC_e9a397c8-e329-4471-985b-0eb40ed458b0_TOMA__MATRX_','2022-02-04 15:01:39','2022-02-04 14:50:30','','2022-02-04 16:01:39','SYNCED','51a9191a-3d52-4dbe-a549-0616a8adb43b',0,'2022-02-04 16:01:39','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.12.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.12.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.12.1.1.1 Occlusion 1\"}'),(2,'526e9fb6-b6a0-4f25-9d0a-b3aab61ddd2e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a4b302c-278d-4e12-ace5-f095ba0bf856/session_6206892a-2e7e-4765-ac90-b49bfb465997/occlusion_3c30231c-7cd7-4431-985b-2eaf7f6925ae/scan_232c4a5c-d521-4972-9735-eb9d27cffedc/3_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_232c4a5c-d521-4972-9735-eb9d27cffedc_ZIP_','2022-09-06 09:20:42','2022-08-30 10:43:19','3_w1_o1_maxillaire_scan_file_0.zip','2022-09-06 11:20:42','SYNCED','526e9fb6-b6a0-4f25-9d0a-b3aab61ddd2e',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.3.1.1.3\",\"modelMatrix\":\"0.807997,0.577429,-0.117121,0,-0.589187,0.791872,-0.160616,0,8.33841e-10,0.198783,0.980043,0,-28.159,-4.83121,-15.9851,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'52c30d44-dd5d-4b6f-8fc9-709139c04709','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/order_3b627fcf-9786-459e-a2ac-911498e37f8e/23_w1_couronne_prost_file_52c30d44-dd5d-4b6f-8fc9-709139c04709_0.pdf','PDF','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_PROST_3b627fcf-9786-459e-a2ac-911498e37f8e_PDF_','2022-05-25 14:26:12','2022-05-25 16:26:11','23_w1_couronne_prost_file_52c30d44-dd5d-4b6f-8fc9-709139c04709_0.pdf','2022-05-25 16:26:12','SYNCED','52c30d44-dd5d-4b6f-8fc9-709139c04709',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.23.1.4 COURONNE\",\"title\":\"Couronne PDF\"}'),(1001,'531bfda0-1af5-4346-ab7a-4e8de5ff45cc','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/7c3827a5-fcb4-4892-bab3-8d6a4e6382f0/session_cb98e8a0-e16d-4640-919e-9b968e57d3db/occlusion_29633526-06c5-413c-8029-9f27d6a28b53/scan_ab6c69b1-8cac-45ec-8fee-f2371813f161/63_w1_o1_maxillaire_scan_file_2.zip','ZIP','PATIENT_7c3827a5-fcb4-4892-bab3-8d6a4e6382f0_ACT_cb98e8a0-e16d-4640-919e-9b968e57d3db_SESS_29633526-06c5-413c-8029-9f27d6a28b53_TOSC_ab6c69b1-8cac-45ec-8fee-f2371813f161_ZIP_','2023-03-20 14:41:00','2023-03-20 15:40:26','63_w1_o1_maxillaire_scan_file_2.zip','2023-03-20 15:41:00','SYNCED','7ab66a9c-a8b0-4143-a71a-8804137212c7',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.63.1.1.1\",\"modelMatrix\":\"0.821669,0.533092,-0.201674,0,-0.569964,0.768513,-0.290737,0,3.58936e-09,0.353837,0.935307,0,-1.48684,-30.577,-17.5286,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'53730f49-b109-4397-a05a-fa05be3beb52','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/69640c87-271c-4a44-a6fa-67b01654cc27/session_5f9199b0-eb37-4ed3-8d1a-6c38505d4913/occlusion_991beec3-fe9e-4c98-a3d4-c98e4a4c2471/computedocclusion_c7bccd1e-370e-4347-8296-1bcd4c30b631/39_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_OCC_c7bccd1e-370e-4347-8296-1bcd4c30b631_BOMA__MATRX_','2022-09-10 09:46:06','2022-09-10 11:45:43','39_w1_o1_mandibule_matrix_occ_file_0.m','2022-09-10 11:46:06','SYNCED','53730f49-b109-4397-a05a-fa05be3beb52',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.39.1.1.1 Occlusion 10\",\"referenceScanID\":\"1.39.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.39.1.1.1 Occlusion 10\"}'),(1001,'53765ced-c0e8-45b7-b737-e9877fe0801d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3ed7a8e0-5b4d-4ecf-b4ae-f855b16c0f93/session_fb42cec6-0bb6-41e9-912d-0517ff8e0942/occlusion_fb214b2f-5e41-492d-85c4-d4a11a3947c5/computedocclusion_8c8e81cc-f99d-4235-9ccb-11954c645cad/42_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_3ed7a8e0-5b4d-4ecf-b4ae-f855b16c0f93_ACT_fb42cec6-0bb6-41e9-912d-0517ff8e0942_SESS_fb214b2f-5e41-492d-85c4-d4a11a3947c5_OCC_8c8e81cc-f99d-4235-9ccb-11954c645cad_TOMA__MATRX_','2022-10-07 17:32:26','2022-10-07 19:31:47','42_w1_o1_maxillaire_matrix_occ_file_0.m','2022-10-07 19:32:26','SYNCED','53765ced-c0e8-45b7-b737-e9877fe0801d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.42.1.1.1 Occlusion 4\",\"referenceScanID\":\"1.42.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.42.1.1.1 Occlusion 4\"}'),(1001,'546a8041-4f76-419c-89fd-3181695f2b96','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/57c4096f-98dd-49c8-bea5-a5b109ad3fd0/session_4f62e395-5623-4d5b-869c-1b2fc4d22b00/occlusion_1ac20dc7-b36b-4786-a05f-37091554dc5c/scan_7d899967-a5be-43f7-acbd-42d4237792d4/31_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_57c4096f-98dd-49c8-bea5-a5b109ad3fd0_ACT_4f62e395-5623-4d5b-869c-1b2fc4d22b00_SESS_1ac20dc7-b36b-4786-a05f-37091554dc5c_TOSC_7d899967-a5be-43f7-acbd-42d4237792d4_SNAPS_','2022-06-16 10:52:48','2022-06-16 12:52:38','31_w1_o1_maxillaire_snapshot_0.png','2022-06-16 12:52:48','SYNCED','546a8041-4f76-419c-89fd-3181695f2b96',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.31.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'5486d4bc-5b14-4a94-ade5-1720c829818d','','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_BOSC_a1a9cef4-72fe-4dbe-928c-3831f98ecfbc_SNAPS_','2022-02-19 17:53:23','2022-02-18 17:01:56','','2022-02-19 18:53:23','SYNCED','fb2afa86-ebd5-4360-a84e-10047e56c6e5',2,'2022-02-19 18:53:23','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.4.4\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'54af140d-b148-43e6-84b4-455ce19fbd59','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a0c21836-ba79-4f15-9e35-02ef8211a9e5/session_0aac522d-3c38-465a-a1e0-014166c140ac/occlusion_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042/scan_dda4ec6d-010a-4593-be9f-97cb59747424/7_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_a0c21836-ba79-4f15-9e35-02ef8211a9e5_ACT_0aac522d-3c38-465a-a1e0-014166c140ac_SESS_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042_BOSC_dda4ec6d-010a-4593-be9f-97cb59747424_ZIP_','2022-01-21 11:50:26','2022-01-21 12:49:06','7_w1_o1_mandibule_scan_file_0.zip','2022-01-21 12:50:26','SYNCED','54af140d-b148-43e6-84b4-455ce19fbd59',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.7.1.1.1\",\"modelMatrix\":\"-0.95397,-0.276542,0.116045,0,0.299903,-0.879659,0.369132,0,-4.3083e-9,0.386943,0.922104,0,13.6932,12.2039,-15.7846,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'54dec040-bf2a-4f49-aa21-80bee5829b26','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_909d9ecd-46b3-4692-868e-f6405507ecd1/24_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_TOSC_909d9ecd-46b3-4692-868e-f6405507ecd1_ZIP_','2022-05-13 14:42:34','2022-05-13 16:42:23','24_w1_o1_maxillaire_scan_file_1.zip','2022-05-13 16:42:34','SYNCED','3857c31f-4878-48ad-9ad9-5da851292116',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.2\",\"modelMatrix\":\"-0.80453,0.576793,-0.141569,0,-0.593912,-0.781339,0.191773,0,-6.05286e-09,0.238367,0.971175,0,0.910551,-5.61768,-25.9513,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'5522b546-fb91-4268-9a1a-6471a732b617','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/order_9e0e25bb-7234-43a4-80d0-a7d7b71aafa4/19_w1_guide_prost_file_5522b546-fb91-4268-9a1a-6471a732b617_0.pdf','PDF','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_PROST_9e0e25bb-7234-43a4-80d0-a7d7b71aafa4_PDF_','2022-03-09 17:00:44','2022-03-09 18:00:42','19_w1_guide_prost_file_5522b546-fb91-4268-9a1a-6471a732b617_0.pdf','2022-03-09 18:00:44','SYNCED','5522b546-fb91-4268-9a1a-6471a732b617',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.19.1.2 GUIDE\",\"title\":\"Guide PDF\"}'),(1001,'55331df2-aca7-4a34-acaf-8e97458bf54f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/fa7fa96b-f393-4b9a-8198-144702462cfa/session_4bed076c-8541-4a2f-800a-5aeb4cb49de5/occlusion_16b82fca-4b65-4866-af87-1f6dbb42f5dc/scan_378056ed-259b-4069-96b1-1e6050e30f87/35_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_fa7fa96b-f393-4b9a-8198-144702462cfa_ACT_4bed076c-8541-4a2f-800a-5aeb4cb49de5_SESS_16b82fca-4b65-4866-af87-1f6dbb42f5dc_BOSC_378056ed-259b-4069-96b1-1e6050e30f87_ZIP_','2022-06-28 14:57:35','2022-06-28 16:57:25','35_w1_o1_mandibule_scan_file_0.zip','2022-06-28 16:57:35','SYNCED','55331df2-aca7-4a34-acaf-8e97458bf54f',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.35.1.1.1\",\"modelMatrix\":\"0.0975586,0.955587,-0.278094,0,-0.99523,0.0936725,-0.0272605,0,1.35871e-09,0.279427,0.960167,0,-3.44734,-12.1676,-17.3219,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'555d160f-6300-4261-bc81-6eaef9e1d1aa','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/9e399d73-4d2e-4bb8-af48-a4e597811faa/session_b1cf14ce-00a9-48b6-8654-dadde26073f1/occlusion_3c4595e0-fbbb-4814-8851-1e014eb9a3b2/computedocclusion_69c0f244-5ccf-4ce5-aa31-27a50e7c92a0/46_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_9e399d73-4d2e-4bb8-af48-a4e597811faa_ACT_b1cf14ce-00a9-48b6-8654-dadde26073f1_SESS_3c4595e0-fbbb-4814-8851-1e014eb9a3b2_OCC_69c0f244-5ccf-4ce5-aa31-27a50e7c92a0_BOMA__MATRX_','2022-10-27 17:25:21','2022-10-27 19:24:54','46_w1_o1_mandibule_matrix_occ_file_0.m','2022-10-27 19:25:21','SYNCED','555d160f-6300-4261-bc81-6eaef9e1d1aa',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.46.1.1.2 Occlusion 1\",\"referenceScanID\":\"1.46.1.1.2\",\"title\":\"Matrice Transfo. Mandibule 1.46.1.1.2 Occlusion 1\"}'),(1001,'55725ce5-4c86-45bc-a52a-0f716dd5a486','','MATRX','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_7d8decb1-23db-4824-940f-8d8822d88813_BOMA__MATRX_','2022-02-08 08:48:59','2022-02-07 18:48:45','','2022-02-08 09:48:59','SYNCED','55725ce5-4c86-45bc-a52a-0f716dd5a486',0,'2022-02-08 09:48:59','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.17.1.1.1 Occlusion 3\",\"referenceScanID\":\"1.17.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.17.1.1.1 Occlusion 3\"}'),(1001,'55f52934-bbd7-4e86-bd7e-fc42a74d3419','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f4fc00ec-4af8-4a15-b427-f1c5aabf6260/session_498ae60a-23f0-44fc-9730-be499bfc4b46/occlusion_8f3d6c73-3468-45a5-85c7-93bba47ec9f7/computedocclusion_9c318e86-fa90-4cd9-8319-2503cde2b455/30_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_f4fc00ec-4af8-4a15-b427-f1c5aabf6260_ACT_498ae60a-23f0-44fc-9730-be499bfc4b46_SESS_8f3d6c73-3468-45a5-85c7-93bba47ec9f7_OCC_9c318e86-fa90-4cd9-8319-2503cde2b455_BOPLY__ZIP_','2022-06-14 13:30:04','2022-06-14 15:29:56','30_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-06-14 15:30:04','SYNCED','55f52934-bbd7-4e86-bd7e-fc42a74d3419',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.30.1.1.1 Occlusion 1\",\"modelMatrix\":\"-0.121583,0.970699,-0.207271,0,-0.992581,-0.118902,0.0253889,0,1.0676e-09,0.20882,0.977954,0,3.47051,-3.06677,-21.1986,1\",\"referenceScanID\":\"1.30.1.1.1\",\"title\":\"Mandibule 1.30.1.1.1 Occlusion 1\"}'),(1001,'565d69de-f728-4686-a5e9-490a8f086cd5','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/occlusion_a2220645-c79d-4dda-b6cc-772384a4106b/computedocclusion_cf412dab-1d83-4db0-ae1b-d2724d5be97d/38_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_OCC_cf412dab-1d83-4db0-ae1b-d2724d5be97d_SNAPO__SNAPS_','2022-07-12 11:04:31','2022-07-12 13:04:14','38_w1_o1_snapshot_occ_file_0.png','2022-07-12 13:04:31','SYNCED','565d69de-f728-4686-a5e9-490a8f086cd5',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'566be85e-38a3-4083-ba96-401708153e00','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_9418414d-48f1-4a41-baa8-98bf650edaa3/4_w1_o2_mandibule_scan_file_0.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_BOSC_9418414d-48f1-4a41-baa8-98bf650edaa3_ZIP_','2022-02-15 12:19:26','2022-02-15 13:19:19','4_w1_o2_mandibule_scan_file_0.zip','2022-02-15 13:19:26','SYNCED','566be85e-38a3-4083-ba96-401708153e00',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.2.1\",\"modelMatrix\":\"0.979683,0.193592,-0.0523778,0,-0.200552,0.945681,-0.255862,0,-3.35472e-09,0.261168,0.965293,0,-13.8508,-18.7644,-17.2987,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'566d4aee-ea7d-451d-9729-c4ee36e069dc','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5/occlusion_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa/computedocclusion_0dbd67b0-3e41-4bfc-bb6d-b848ad2e78c8/24_w2_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5_SESS_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa_OCC_0dbd67b0-3e41-4bfc-bb6d-b848ad2e78c8_BOPLY__ZIP_','2022-10-08 14:15:26','2022-10-08 16:15:02','24_w2_o1_mandibule_occlusion_occ_file_0.zip','2022-10-08 16:15:26','SYNCED','566d4aee-ea7d-451d-9729-c4ee36e069dc',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.24.2.1.5 Occlusion 3\",\"modelMatrix\":\"-0.3138,0.935395,-0.162988,0,-0.949489,-0.309143,0.0538666,0,-2.99524e-09,0.171659,0.985157,0,25.6088,-18.5365,-15.4613,1\",\"referenceScanID\":\"1.24.2.1.5\",\"title\":\"Mandibule 1.24.2.1.5 Occlusion 3\"}'),(1001,'5674279a-1504-4f13-b0d4-2dc93452f497','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/9efbbbe9-fd0a-44b1-988c-23571aad69fa/session_595a54fa-ae7d-4880-86a1-168b20242ecf/occlusion_b84a2165-e2d4-47e5-b110-a34bcaa24341/scan_8c9464fc-bf15-473a-926a-02d3f3803deb/53_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_9efbbbe9-fd0a-44b1-988c-23571aad69fa_ACT_595a54fa-ae7d-4880-86a1-168b20242ecf_SESS_b84a2165-e2d4-47e5-b110-a34bcaa24341_TOSC_8c9464fc-bf15-473a-926a-02d3f3803deb_ZIP_','2022-12-02 13:57:12','2022-12-02 14:56:54','53_w1_o1_maxillaire_scan_file_0.zip','2022-12-02 14:57:12','SYNCED','5674279a-1504-4f13-b0d4-2dc93452f497',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.53.1.1.3\",\"modelMatrix\":\"0.595665,0.793857,-0.122368,0,-0.803233,0.588712,-0.0907461,0,6.47843e-09,0.152344,0.988327,0,-24.5118,-11.5932,-19.8899,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'573423ef-791f-4a2f-aa1f-bb3662f66baa','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/computedocclusion_e9bfc750-6943-42bf-8c0b-b7e1dc1803c5/1_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_OCC_e9bfc750-6943-42bf-8c0b-b7e1dc1803c5_BOMA__MATRX_','2022-01-19 13:04:53','2022-01-19 12:12:14','1_w1_o1_mandibule_matrix_occ_file_0.m','2022-01-19 14:04:53','SYNCED','573423ef-791f-4a2f-aa1f-bb3662f66baa',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.1.1.1.1 Occlusion 2\",\"referenceScanID\":\"1.1.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.1.1.1.1 Occlusion 2\"}'),(1001,'577389a9-bf6d-431b-a385-66474676ee79','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a9e7a1ae-2d71-448f-80f6-19d916912a3c/session_07012a03-2a1e-44e4-9bc9-17e726862bc2/occlusion_ab83a8b7-1eb1-4b13-9594-40d6479b2b19/scan_e33a7de9-6d02-41e0-b621-fc99e53eb96c/52_w1_o1_mandibule_snapshot_3.png','SNAPS','PATIENT_a9e7a1ae-2d71-448f-80f6-19d916912a3c_ACT_07012a03-2a1e-44e4-9bc9-17e726862bc2_SESS_ab83a8b7-1eb1-4b13-9594-40d6479b2b19_BOSC_e33a7de9-6d02-41e0-b621-fc99e53eb96c_SNAPS_','2022-11-29 10:49:47','2022-11-29 11:49:37','52_w1_o1_mandibule_snapshot_3.png','2022-11-29 11:49:47','SYNCED','21764d52-2c8b-4d31-a0cd-af3f1985cd6e',3,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.52.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'57829d11-dfc5-4c72-8ee9-4dc94c36f9e7','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/490e4b04-6edd-4f47-a2ed-232689892eca/session_62105a91-1675-4d36-88bd-34aa8fe2ce3c/occlusion_03784c27-fd8d-4745-9c26-d84c490869b3/computedocclusion_8dab59f8-3c64-4520-912b-687d8f68ebb8/56_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_490e4b04-6edd-4f47-a2ed-232689892eca_ACT_62105a91-1675-4d36-88bd-34aa8fe2ce3c_SESS_03784c27-fd8d-4745-9c26-d84c490869b3_OCC_8dab59f8-3c64-4520-912b-687d8f68ebb8_BOMA__MATRX_','2023-02-17 09:39:49','2023-02-17 10:39:41','56_w1_o1_mandibule_matrix_occ_file_0.m','2023-02-17 10:39:49','SYNCED','57829d11-dfc5-4c72-8ee9-4dc94c36f9e7',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.56.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.56.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.56.1.1.1 Occlusion 1\"}'),(1001,'579ff165-11f6-4035-96ba-aa4a2d120cc8','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_f4b07389-264e-4772-afc3-29b2187ced21/18_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_LESC_f4b07389-264e-4772-afc3-29b2187ced21_SNAPS_','2022-03-07 14:43:34','2022-03-07 15:43:32','18_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-03-07 15:43:34','SYNCED','579ff165-11f6-4035-96ba-aa4a2d120cc8',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.18.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'57ada530-ed64-430e-a2d9-f1e6307bf947','','MATRX','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_OCC_4aa37ef9-cd2d-4cfa-9436-a62cc782a27a_BOMA__MATRX_','2022-02-04 15:01:39','2022-02-04 14:55:02','','2022-02-04 16:01:39','SYNCED','57ada530-ed64-430e-a2d9-f1e6307bf947',0,'2022-02-04 16:01:39','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.12.1.1.5 Occlusion 1\",\"referenceScanID\":\"1.12.1.1.5\",\"title\":\"Matrice Transfo. Mandibule 1.12.1.1.5 Occlusion 1\"}'),(1001,'57d16105-76ab-4818-8b3b-97cd680f701e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/order_37a778ee-af03-4993-a8f5-8ce26e516db0/13_w1_amovible_prost_file_57d16105-76ab-4818-8b3b-97cd680f701e_0.pdf','PDF','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_PROST_37a778ee-af03-4993-a8f5-8ce26e516db0_PDF_','2022-02-04 18:28:43','2022-02-04 19:28:42','13_w1_amovible_prost_file_57d16105-76ab-4818-8b3b-97cd680f701e_0.pdf','2022-02-04 19:28:43','SYNCED','57d16105-76ab-4818-8b3b-97cd680f701e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.13.1.1 AMOVIBLE\",\"title\":\"Amovible PDF\"}'),(1001,'57da302c-26b5-42e6-bcf0-6a9456ce4145','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_e8550560-cfe0-40a1-bfb3-992d471fbcb7/17_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_BOSC_e8550560-cfe0-40a1-bfb3-992d471fbcb7_SNAPS_','2022-02-07 11:47:26','2022-02-07 12:38:30','17_w1_o1_mandibule_snapshot_1.png','2022-02-07 12:47:26','SYNCED','8c69c578-53d3-4a85-8b22-b7992c482bdd',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.17.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'5810288a-4f85-4cf7-a638-3fb6d3fdf0fd','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/207d6dbc-c19b-4726-a9b3-16235ae554cc/session_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35/occlusion_dc5762a3-c453-4166-8c86-82d23ac9f8a6/scan_5139ec2e-4608-4b67-b0d1-bc4dc3498038/27_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_207d6dbc-c19b-4726-a9b3-16235ae554cc_ACT_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35_SESS_dc5762a3-c453-4166-8c86-82d23ac9f8a6_BOSC_5139ec2e-4608-4b67-b0d1-bc4dc3498038_SNAPS_','2022-05-30 11:06:27','2022-05-30 13:06:19','27_w1_o1_mandibule_snapshot_1.png','2022-05-30 13:06:27','SYNCED','0f6e5816-9908-4996-af79-cabf91fcb4f3',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.27.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'58c340c6-87b7-4d1d-a161-277017ac45d3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_d454a556-70ce-4c4c-8e13-114edfa03642/17_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_BOSC_d454a556-70ce-4c4c-8e13-114edfa03642_SNAPS_','2022-02-11 16:04:48','2022-02-11 17:04:32','17_w1_o1_mandibule_snapshot_0.png','2022-02-11 17:04:48','SYNCED','58c340c6-87b7-4d1d-a161-277017ac45d3',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.17.1.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'58e80a01-c3d6-4ce8-856f-23172ac20767','','LIFIM','PATIENT_a9e7a1ae-2d71-448f-80f6-19d916912a3c_ACT_07012a03-2a1e-44e4-9bc9-17e726862bc2_SESS_ab83a8b7-1eb1-4b13-9594-40d6479b2b19_BOSC_e33a7de9-6d02-41e0-b621-fc99e53eb96c_LIFIM_','2022-12-22 08:46:48','2022-12-14 16:06:11','','2022-12-22 09:46:48','SYNCED','58e80a01-c3d6-4ce8-856f-23172ac20767',0,'2022-12-22 09:46:48','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Mandibule 1.52.1.1.1 Ligne de finition 0\",\"name\":\"Ligne de finition 0\",\"title\":\"Mandibule LIFI_META\",\"toothNumber\":0,\"versionMarginLine\":1}'),(1001,'595feda8-cae8-4964-818c-868a61418f19','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/57c4096f-98dd-49c8-bea5-a5b109ad3fd0/session_4f62e395-5623-4d5b-869c-1b2fc4d22b00/order_f2d38d5b-67ff-45ef-8aa5-61656f0530e5/31_w1_inlay_onlay_prost_file_595feda8-cae8-4964-818c-868a61418f19_0.pdf','PDF','PATIENT_57c4096f-98dd-49c8-bea5-a5b109ad3fd0_ACT_4f62e395-5623-4d5b-869c-1b2fc4d22b00_PROST_f2d38d5b-67ff-45ef-8aa5-61656f0530e5_PDF_','2022-06-16 16:10:14','2022-06-16 18:10:13','31_w1_inlay_onlay_prost_file_595feda8-cae8-4964-818c-868a61418f19_0.pdf','2022-06-16 18:10:14','SYNCED','595feda8-cae8-4964-818c-868a61418f19',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.31.1.1 AmelieP/0355/Dent 15/ONLAY\",\"title\":\"Inlay/Onlay PDF\"}'),(1001,'59c1b886-f135-4ef2-aa66-ed718733f9aa','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/9e399d73-4d2e-4bb8-af48-a4e597811faa/session_b1cf14ce-00a9-48b6-8654-dadde26073f1/occlusion_1060c95f-48f4-4a37-9b82-03bfd8329730/computedocclusion_67e8fc2c-cca5-4b65-8153-f487421fc4e6/46_w1_o2_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_9e399d73-4d2e-4bb8-af48-a4e597811faa_ACT_b1cf14ce-00a9-48b6-8654-dadde26073f1_SESS_1060c95f-48f4-4a37-9b82-03bfd8329730_OCC_67e8fc2c-cca5-4b65-8153-f487421fc4e6_TOMA__MATRX_','2023-01-20 14:43:20','2023-01-20 15:42:49','46_w1_o2_maxillaire_matrix_occ_file_0.m','2023-01-20 15:43:20','SYNCED','59c1b886-f135-4ef2-aa66-ed718733f9aa',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.46.1.2.2 Occlusion 2\",\"referenceScanID\":\"1.46.1.2.2\",\"title\":\"Matrice Transfo. Maxillaire 1.46.1.2.2 Occlusion 2\"}'),(1001,'5a015b83-2cc8-4b4a-bdff-8297760d8847','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/order_5b6bef74-4ccc-47db-a97c-d187ff9acae0/23_w1_couronne_prost_file_5a015b83-2cc8-4b4a-bdff-8297760d8847_0.pdf','PDF','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_PROST_5b6bef74-4ccc-47db-a97c-d187ff9acae0_PDF_','2022-05-25 10:43:06','2022-05-25 12:43:05','23_w1_couronne_prost_file_5a015b83-2cc8-4b4a-bdff-8297760d8847_0.pdf','2022-05-25 12:43:06','SYNCED','5a015b83-2cc8-4b4a-bdff-8297760d8847',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.23.1.2 COURONNE\",\"title\":\"Couronne PDF\"}'),(1001,'5a1c3667-dbf3-4de6-af8e-149a263ba435','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_04d6e3f1-19ce-4851-a9d0-40419cea7542/scan_fef6f617-40e8-4052-8a2d-9af9e39ab22d/19_w1_o2_mandibule_snapshot_0.png','SNAPS','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_04d6e3f1-19ce-4851-a9d0-40419cea7542_BOSC_fef6f617-40e8-4052-8a2d-9af9e39ab22d_SNAPS_','2022-04-15 13:53:56','2022-04-15 15:53:44','19_w1_o2_mandibule_snapshot_0.png','2022-04-15 15:53:56','SYNCED','5a1c3667-dbf3-4de6-af8e-149a263ba435',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.2.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'5a1f9ce5-306f-497e-8975-eefaafa1022b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/32710234-804f-46f5-899d-eed636f8a906/session_64c1427a-b91d-4675-94df-f36bd40e9b0f/occlusion_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a/scan_3954e24e-9220-452b-a8fa-b1fbde6ebcad/33_w2_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_32710234-804f-46f5-899d-eed636f8a906_ACT_64c1427a-b91d-4675-94df-f36bd40e9b0f_SESS_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a_BOSC_3954e24e-9220-452b-a8fa-b1fbde6ebcad_SNAPS_','2022-06-28 09:01:34','2022-06-28 11:01:22','33_w2_o1_mandibule_snapshot_1.png','2022-06-28 11:01:34','SYNCED','fe809790-75be-4a2e-9d94-7358f686eecf',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.33.2.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'5a5e59c6-da45-4e2d-991c-fb6f039cb431','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/scan_36a05dde-4390-4db1-9df5-ea42cd16ed7d/1_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_FRSC_36a05dde-4390-4db1-9df5-ea42cd16ed7d_SNAPS_','2022-01-19 12:59:17','2022-01-19 12:11:00','1_w1_o1_mordu_anterieur_snapshot_0.png','2022-01-19 13:59:17','SYNCED','5a5e59c6-da45-4e2d-991c-fb6f039cb431',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.1.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'5abb013c-c6bc-4140-b8b6-6a2c1514624a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/9e399d73-4d2e-4bb8-af48-a4e597811faa/session_b1cf14ce-00a9-48b6-8654-dadde26073f1/occlusion_3c4595e0-fbbb-4814-8851-1e014eb9a3b2/computedocclusion_69c0f244-5ccf-4ce5-aa31-27a50e7c92a0/46_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_9e399d73-4d2e-4bb8-af48-a4e597811faa_ACT_b1cf14ce-00a9-48b6-8654-dadde26073f1_SESS_3c4595e0-fbbb-4814-8851-1e014eb9a3b2_OCC_69c0f244-5ccf-4ce5-aa31-27a50e7c92a0_TOMA__MATRX_','2022-10-27 17:25:22','2022-10-27 19:24:54','46_w1_o1_maxillaire_matrix_occ_file_0.m','2022-10-27 19:25:22','SYNCED','5abb013c-c6bc-4140-b8b6-6a2c1514624a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.46.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.46.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.46.1.1.1 Occlusion 1\"}'),(1001,'5ac4b146-77ec-42e3-9705-fadde16d1ea0','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/4fa1a134-d246-43d7-aa8c-b42e24b62b49/session_6aedf6fd-46d7-4259-88ba-5cf074ad5913/occlusion_47192ebb-25b6-4c9e-a09f-8ed295e60a87/scan_283f28e2-92dd-426a-bc9e-a4fe6fdb180c/60_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_4fa1a134-d246-43d7-aa8c-b42e24b62b49_ACT_6aedf6fd-46d7-4259-88ba-5cf074ad5913_SESS_47192ebb-25b6-4c9e-a09f-8ed295e60a87_TOSC_283f28e2-92dd-426a-bc9e-a4fe6fdb180c_SNAPS_','2023-03-07 18:00:10','2023-03-07 18:59:54','60_w1_o1_maxillaire_snapshot_0.png','2023-03-07 19:00:10','SYNCED','5ac4b146-77ec-42e3-9705-fadde16d1ea0',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.60.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'5adfa2d7-f3c9-4609-9d90-3a85c0853b42','','MATRX','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_OCC_87edc123-163f-46ce-be5c-45f2ff80b857_BOMA__MATRX_','2022-05-12 12:27:26','2022-05-12 14:26:51','','2022-05-12 14:27:26','SYNCED','5adfa2d7-f3c9-4609-9d90-3a85c0853b42',0,'2022-05-12 14:27:26','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.18.1.1.3 Occlusion 3\",\"referenceScanID\":\"1.18.1.1.3\",\"title\":\"Matrice Transfo. Mandibule 1.18.1.1.3 Occlusion 3\"}'),(1001,'5b2bc9ab-725b-413f-9061-9637ee727888','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5/occlusion_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa/computedocclusion_0dbd67b0-3e41-4bfc-bb6d-b848ad2e78c8/24_w2_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5_SESS_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa_OCC_0dbd67b0-3e41-4bfc-bb6d-b848ad2e78c8_TOMA__MATRX_','2022-10-08 14:15:39','2022-10-08 16:15:02','24_w2_o1_maxillaire_matrix_occ_file_0.m','2022-10-08 16:15:39','SYNCED','5b2bc9ab-725b-413f-9061-9637ee727888',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.24.2.1.1 Occlusion 3\",\"referenceScanID\":\"1.24.2.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.24.2.1.1 Occlusion 3\"}'),(1001,'5b416896-9585-45b4-add3-28bf4c1bc4d7','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/490e4b04-6edd-4f47-a2ed-232689892eca/session_62105a91-1675-4d36-88bd-34aa8fe2ce3c/occlusion_03784c27-fd8d-4745-9c26-d84c490869b3/scan_396a7286-9ff9-463e-bd50-a344ec153ca3/56_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_490e4b04-6edd-4f47-a2ed-232689892eca_ACT_62105a91-1675-4d36-88bd-34aa8fe2ce3c_SESS_03784c27-fd8d-4745-9c26-d84c490869b3_TOSC_396a7286-9ff9-463e-bd50-a344ec153ca3_ZIP_','2023-02-17 09:29:53','2023-02-17 10:29:45','56_w1_o1_maxillaire_scan_file_0.zip','2023-02-17 10:29:53','SYNCED','5b416896-9585-45b4-add3-28bf4c1bc4d7',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.56.1.1.1\",\"modelMatrix\":\"-0.110774,0.92511,-0.363182,0,-0.993846,-0.103113,0.0404803,0,2.8158e-09,0.365431,0.930838,0,11.1652,-21.6233,-21.971,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'5be397c6-6389-4466-89bf-df569bbce2b9','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_04d6e3f1-19ce-4851-a9d0-40419cea7542/scan_9e43db2d-10a9-414e-ac07-6b7642412ce5/19_w1_o2_maxillaire_snapshot_1.png','SNAPS','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_04d6e3f1-19ce-4851-a9d0-40419cea7542_TOSC_9e43db2d-10a9-414e-ac07-6b7642412ce5_SNAPS_','2022-04-15 11:41:27','2022-04-01 18:18:31','19_w1_o2_maxillaire_snapshot_1.png','2022-04-15 13:41:27','SYNCED','43faec45-d44e-4a5b-980c-14c82d42fdd3',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.19.1.2.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'5c552dd5-711b-49d9-8d67-2470cfd3aa77','','MATRX','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_OCC_764b8e22-8600-49e3-8d7c-d619725096ee_BOMA__MATRX_','2022-02-04 18:20:41','2022-02-04 19:19:48','',NULL,'CREATED','5c552dd5-711b-49d9-8d67-2470cfd3aa77',0,'2022-02-04 19:20:41','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.13.1.1.5 Occlusion 2\",\"referenceScanID\":\"1.13.1.1.5\",\"title\":\"Matrice Transfo. Mandibule 1.13.1.1.5 Occlusion 2\"}'),(1001,'5d3dcc4f-6d2d-44ab-815b-4de5076cb320','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_0e451099-a0ad-463c-9441-7ded1297fa16/24_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_TOSC_0e451099-a0ad-463c-9441-7ded1297fa16_ZIP_','2022-05-24 14:34:54','2022-05-24 16:34:40','24_w1_o1_maxillaire_scan_file_0.zip','2022-05-24 16:34:54','SYNCED','5d3dcc4f-6d2d-44ab-815b-4de5076cb320',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.3\",\"modelMatrix\":\"-0.267728,0.945753,-0.184045,0,-0.963495,-0.262798,0.0511409,0,1.26612e-09,0.191018,0.981586,0,-10.2402,-22.3473,-17.4553,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'5de4d708-9268-44d3-8f75-05e78bdf5d20','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a4b302c-278d-4e12-ace5-f095ba0bf856/session_6206892a-2e7e-4765-ac90-b49bfb465997/occlusion_7ec70f78-dc80-40c5-b293-570a59f034c4/scan_e57dd65c-d607-4b04-af86-37d5f5d568b7/3_w1_o2_maxillaire_snapshot_0.png','SNAPS','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_7ec70f78-dc80-40c5-b293-570a59f034c4_TOSC_e57dd65c-d607-4b04-af86-37d5f5d568b7_SNAPS_','2022-09-06 09:17:56','2022-08-30 14:14:58','3_w1_o2_maxillaire_snapshot_0.png','2022-09-06 11:17:56','SYNCED','5de4d708-9268-44d3-8f75-05e78bdf5d20',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.3.1.2.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'5deb7cff-a8a8-4c00-af67-2cc45b57bc3c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f4fc00ec-4af8-4a15-b427-f1c5aabf6260/session_498ae60a-23f0-44fc-9730-be499bfc4b46/occlusion_8f3d6c73-3468-45a5-85c7-93bba47ec9f7/scan_0d368f7d-e2ae-489f-b39f-cfe87c4103c8/30_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_f4fc00ec-4af8-4a15-b427-f1c5aabf6260_ACT_498ae60a-23f0-44fc-9730-be499bfc4b46_SESS_8f3d6c73-3468-45a5-85c7-93bba47ec9f7_TOSC_0d368f7d-e2ae-489f-b39f-cfe87c4103c8_ZIP_','2022-06-14 13:26:11','2022-06-14 15:26:02','30_w1_o1_maxillaire_scan_file_0.zip','2022-06-14 15:26:11','SYNCED','5deb7cff-a8a8-4c00-af67-2cc45b57bc3c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.30.1.1.1\",\"modelMatrix\":\"-0.102207,0.992752,-0.0632283,0,-0.994763,-0.102001,0.00649642,0,1.08257e-11,0.0635612,0.997978,0,0.134114,-19.6177,-21.1524,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'5dfbb2b2-a700-4e05-b70f-a8db7b295be5','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a4b302c-278d-4e12-ace5-f095ba0bf856/session_6206892a-2e7e-4765-ac90-b49bfb465997/occlusion_3c30231c-7cd7-4431-985b-2eaf7f6925ae/scan_53241704-034c-49e7-bd41-012398465214/3_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_53241704-034c-49e7-bd41-012398465214_ZIP_','2022-09-06 09:20:38','2022-08-30 10:39:58','3_w1_o1_maxillaire_scan_file_0.zip','2022-09-06 11:20:38','SYNCED','5dfbb2b2-a700-4e05-b70f-a8db7b295be5',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.3.1.1.2\",\"modelMatrix\":\"0.731042,0.662354,-0.163904,0,-0.682332,0.709638,-0.175604,0,-7.1534e-09,0.240211,0.970721,0,-27.4537,-9.8526,-16.0814,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'5e045628-a37a-469c-89a3-80d0555bc569','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/computedocclusion_864c98a3-fcf7-466a-b999-13bd4dfb8c65/23_w1_o1_ml_occ_file_to1001.xyz','LIFI','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_864c98a3-fcf7-466a-b999-13bd4dfb8c65_LIFIO_LIFI_','2022-05-25 10:45:11','2022-05-25 12:45:09','23_w1_o1_ml_occ_file_to1001.xyz','2022-05-25 12:45:11','SYNCED','5e045628-a37a-469c-89a3-80d0555bc569',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.23.1.1.1 Occlusion 3 Ligne de finition 1\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"Maxillaire\",\"name\":\"Ligne de finition 1\",\"title\":\"Ligne finition\",\"toothNumber\":1001}'),(1001,'5e2227aa-c48a-4337-a9f3-899cdb079950','','SNAPS','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_OCC_764b8e22-8600-49e3-8d7c-d619725096ee_SNAPO__SNAPS_','2022-02-04 18:20:41','2022-02-04 19:19:48','',NULL,'CREATED','5e2227aa-c48a-4337-a9f3-899cdb079950',0,'2022-02-04 19:20:41','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'5e949756-e279-4f76-aa98-e944015eb62e','','LIFIM','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_TOSC_47ae7109-ac97-4f1b-8dd7-cc22debd4324_LIFIM_','2022-07-19 13:56:03','2022-07-19 15:55:49','','2022-07-19 15:56:03','SYNCED','5e949756-e279-4f76-aa98-e944015eb62e',0,'2022-07-19 15:56:03','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.38.1.1.4 Ligne de finition 0\",\"name\":\"Ligne de finition 0\",\"title\":\"Maxillaire LIFI_META\",\"toothNumber\":0,\"versionMarginLine\":1}'),(1001,'5eec5129-78cc-470e-82e3-9767204a05e4','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_1c86378e-7d31-4b12-82ff-af797020160f/4_w1_o2_mandibule_snapshot_3.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_BOSC_1c86378e-7d31-4b12-82ff-af797020160f_SNAPS_','2022-03-08 11:43:38','2022-03-08 12:43:29','4_w1_o2_mandibule_snapshot_3.png','2022-03-08 12:43:38','SYNCED','a13ef72a-3421-4e8c-a897-3f43da14e842',3,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.2.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'5f1cba97-c736-42be-b834-c71e914779a0','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_499bf817-e96f-4ff6-ae84-c5c2ccc847c2/17_w1_o1_mordu_anterieur_scan_file_0.zip','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_FRSC_499bf817-e96f-4ff6-ae84-c5c2ccc847c2_ZIP_','2022-02-07 11:46:52','2022-02-07 12:45:17','17_w1_o1_mordu_anterieur_scan_file_0.zip','2022-02-07 12:46:52','SYNCED','5f1cba97-c736-42be-b834-c71e914779a0',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.17.1.1.1\",\"modelMatrix\":\"0.960074,0.00808373,-0.276731,0,0.0920233,0.939826,0.279277,0,0.264214,-0.346635,0.921371,0,4.69226,8.36856,-31.3561,1\",\"title\":\"Mordu anterieur ZIP\"}'),(1001,'5f547eb8-8e01-467b-8bc2-36624f0938f2','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/986374de-c4d7-4d6f-bf0c-2dc7e3b859a9/session_c81670ed-4144-4347-b19e-8057d11b5f7c/occlusion_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be/scan_67168b1b-2bef-47a9-8e7f-994731a82831/28_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_986374de-c4d7-4d6f-bf0c-2dc7e3b859a9_ACT_c81670ed-4144-4347-b19e-8057d11b5f7c_SESS_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be_BOSC_67168b1b-2bef-47a9-8e7f-994731a82831_ZIP_','2022-05-31 10:45:14','2022-05-31 12:45:06','28_w1_o1_mandibule_scan_file_0.zip','2022-05-31 12:45:14','SYNCED','5f547eb8-8e01-467b-8bc2-36624f0938f2',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.28.1.1.1\",\"modelMatrix\":\"-0.884338,-0.414341,0.215098,0,0.466846,-0.784878,0.407456,0,8.2671e-09,0.460747,0.887532,0,11.4557,-5.93595,-19.3272,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'5fb5df68-7218-45fd-ba70-e0699bf168c3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_2ffbfbca-f236-4802-be93-8eb43d523274/scan_0bd54e85-3f0d-4955-9f02-7de656ad9f6f/4_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_2ffbfbca-f236-4802-be93-8eb43d523274_BOSC_0bd54e85-3f0d-4955-9f02-7de656ad9f6f_SNAPS_','2022-01-19 19:04:36','2022-01-19 20:04:15','4_w1_o1_mandibule_snapshot_0.png','2022-01-19 20:04:36','SYNCED','5fb5df68-7218-45fd-ba70-e0699bf168c3',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'5ff5a707-5e7c-47c4-8920-69e306d9f228','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_04d6e3f1-19ce-4851-a9d0-40419cea7542/scan_fef6f617-40e8-4052-8a2d-9af9e39ab22d/19_w1_o2_mandibule_scan_file_1.zip','ZIP','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_04d6e3f1-19ce-4851-a9d0-40419cea7542_BOSC_fef6f617-40e8-4052-8a2d-9af9e39ab22d_ZIP_','2022-04-15 14:02:29','2022-04-15 16:02:19','19_w1_o2_mandibule_scan_file_1.zip','2022-04-15 16:02:29','SYNCED','6fc1ad7b-72f9-4540-9e11-3ded800f23dc',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.2.2\",\"modelMatrix\":\"0.965818,0.246498,-0.080219,0,-0.259223,0.918408,-0.298882,0,-5.08029e-09,0.30946,0.950913,0,4.33301,1.42447,-28.5855,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'5ff5e58f-3f58-4a87-ac42-a542459a37c9','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_44561518-16e3-45bd-af90-fefe4eca9d27/24_w1_o1_mordu_posterieur_droit_snapshot_1.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_LESC_44561518-16e3-45bd-af90-fefe4eca9d27_SNAPS_','2022-06-14 11:57:26','2022-06-14 13:57:24','24_w1_o1_mordu_posterieur_droit_snapshot_1.png','2022-06-14 13:57:26','SYNCED','279111aa-db84-4754-8277-7244a074df26',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.24.1.1.8\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'602979f4-a95f-4ba9-aada-25d7c4560704','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/scan_f4fff5f5-f728-44ae-ac48-f3e653594098/23_w1_o1_mordu_anterieur_snapshot_1.png','SNAPS','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_FRSC_f4fff5f5-f728-44ae-ac48-f3e653594098_SNAPS_','2022-05-13 10:16:21','2022-05-13 12:16:11','23_w1_o1_mordu_anterieur_snapshot_1.png','2022-05-13 12:16:21','SYNCED','a0f1c5f4-8b35-4db9-8ae4-da64e546d1f6',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.23.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'60447bbb-b6df-40e5-8cd7-bf24d40d77e9','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/372000f2-2471-4a57-9b18-224d0788041f/session_5dd64d24-8e33-45bd-a282-c148c185c338/occlusion_a61fbfda-1ac5-4747-9e0c-6ef664930816/scan_a716cac5-0e02-481c-a14b-3fc981cdeb96/57_w1_o1_mandibule_scan_file_2.zip','ZIP','PATIENT_372000f2-2471-4a57-9b18-224d0788041f_ACT_5dd64d24-8e33-45bd-a282-c148c185c338_SESS_a61fbfda-1ac5-4747-9e0c-6ef664930816_BOSC_a716cac5-0e02-481c-a14b-3fc981cdeb96_ZIP_','2023-02-17 10:47:41','2023-02-17 11:47:35','57_w1_o1_mandibule_scan_file_2.zip','2023-02-17 11:47:41','SYNCED','c8d6f116-fd4d-4775-9778-21b0bc8a380a',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.57.1.1.1\",\"modelMatrix\":\"-0.418792,0.887285,-0.193232,0,-0.908082,-0.4092,0.0891151,0,7.57919e-09,0.212791,0.977098,0,-4.31242,-10.0713,-19.3584,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'604e49d8-63b3-4b19-90ef-e934ef7c9a28','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_2a7068fc-0efa-496f-ade9-aba5b0650655/12_w1_o1_mandibule_scan_file_9.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_2a7068fc-0efa-496f-ade9-aba5b0650655_ZIP_','2022-02-04 12:12:14','2022-02-04 13:11:40','12_w1_o1_mandibule_scan_file_9.zip','2022-02-04 13:12:14','SYNCED','44ebcd6f-57c2-4cce-96f5-f9faa1c6b373',9,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.5\",\"modelMatrix\":\"0.748154,-0.636082,0.188853,0,0.663525,0.717211,-0.21294,0,-1.38811e-9,0.284621,0.95864,0,2.11874,31.439,-28.6314,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'60742532-78b2-40bf-83c7-57de730dc104','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_ce625ba7-4218-40af-b344-df718da13f83/54_w1_o1_mandibule_occlusion_occ_file_1.zip','ZIP','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_ce625ba7-4218-40af-b344-df718da13f83_BOPLY__ZIP_','2023-03-15 10:15:38','2023-03-15 11:15:16','54_w1_o1_mandibule_occlusion_occ_file_1.zip','2023-03-15 11:15:38','SYNCED','d1adede1-c3da-47da-a47c-075f5a6fe836',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.54.1.1.4 Occlusion 1\",\"modelMatrix\":\"-0.999599,0.0258183,-0.0116515,0,-0.0283256,-0.911116,0.411175,0,-3.36598e-10,0.41134,0.911482,0,17.4173,6.0967,-21.0427,1\",\"referenceScanID\":\"1.54.1.1.4\",\"title\":\"Mandibule 1.54.1.1.4 Occlusion 1\"}'),(1001,'60959529-680d-4313-8700-3248303a4526','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/593972a6-d7d6-4802-b87d-38aab371f71e/session_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480/occlusion_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3/scan_7338a694-0f0d-4c09-8c45-b4e4129978cb/3_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_593972a6-d7d6-4802-b87d-38aab371f71e_ACT_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480_SESS_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3_RISC_7338a694-0f0d-4c09-8c45-b4e4129978cb_ZIP_','2022-01-19 15:15:35','2022-01-19 16:15:26','3_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-01-19 16:15:35','SYNCED','60959529-680d-4313-8700-3248303a4526',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.3.1.1.1\",\"modelMatrix\":\"0.977863,0.0243235,0.213697,0,-0.0290719,0.997638,0.0437543,0,-0.207464,-0.0668813,0.976072,0,-7.52046,-0.417257,-27.1865,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'609b90cc-f3a5-462f-8eea-961354b08703','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/09688939-f53f-4f00-8366-687b244de26d/session_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525/occlusion_9655a7e0-4673-41c9-90da-a48c008e2d62/scan_52f6127e-edc3-488d-ba7a-e80f19260f9b/64_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_09688939-f53f-4f00-8366-687b244de26d_ACT_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525_SESS_9655a7e0-4673-41c9-90da-a48c008e2d62_TOSC_52f6127e-edc3-488d-ba7a-e80f19260f9b_ZIP_','2023-03-30 12:17:55','2023-03-30 14:17:48','64_w1_o1_maxillaire_scan_file_0.zip','2023-03-30 14:17:55','SYNCED','609b90cc-f3a5-462f-8eea-961354b08703',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.64.1.1.4\",\"modelMatrix\":\"-0.600038,-0.796947,0.0695,0,0.799971,-0.597769,0.0521301,0,2.03629e-09,0.0868781,0.996219,0,-3.59427,12.1576,-23.7044,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'6143c873-c6d2-4d48-9435-4e1981effb46','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a9e7a1ae-2d71-448f-80f6-19d916912a3c/session_07012a03-2a1e-44e4-9bc9-17e726862bc2/occlusion_ab83a8b7-1eb1-4b13-9594-40d6479b2b19/scan_e33a7de9-6d02-41e0-b621-fc99e53eb96c/52_w1_o1_mandibule_scan_file_2.zip','ZIP','PATIENT_a9e7a1ae-2d71-448f-80f6-19d916912a3c_ACT_07012a03-2a1e-44e4-9bc9-17e726862bc2_SESS_ab83a8b7-1eb1-4b13-9594-40d6479b2b19_BOSC_e33a7de9-6d02-41e0-b621-fc99e53eb96c_ZIP_','2022-11-29 10:41:38','2022-11-29 11:41:31','52_w1_o1_mandibule_scan_file_2.zip','2022-11-29 11:41:38','SYNCED','f2bb5b23-86c9-420a-a191-087935901024',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.52.1.1.1\",\"modelMatrix\":\"-0.402014,0.865972,-0.297451,0,-0.915633,-0.38021,0.130598,0,6.81133e-09,0.324858,0.945763,0,4.56841,-14.108,-19.0773,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'6175a7d4-0904-42d7-b0bc-fd89c5dd6fbb','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/09688939-f53f-4f00-8366-687b244de26d/session_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525/occlusion_9655a7e0-4673-41c9-90da-a48c008e2d62/scan_8b05f1fc-00db-4f53-b19b-e43d44dbd773/64_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_09688939-f53f-4f00-8366-687b244de26d_ACT_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525_SESS_9655a7e0-4673-41c9-90da-a48c008e2d62_TOSC_8b05f1fc-00db-4f53-b19b-e43d44dbd773_SNAPS_','2023-03-30 12:05:04','2023-03-30 14:03:24','64_w1_o1_maxillaire_snapshot_0.png','2023-03-30 14:05:04','SYNCED','6175a7d4-0904-42d7-b0bc-fd89c5dd6fbb',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.64.1.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'61868b29-75e1-4d82-8528-52064d6c3eb2','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/75ce481f-6c44-4d16-a477-ea40c4fa6022/session_9bf7b056-ca4f-4dab-937b-619d0eb20528/occlusion_d7580529-3ede-4e27-a2ae-01849ba4d397/scan_f0249631-e141-477c-a453-a48959147fb4/55_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_75ce481f-6c44-4d16-a477-ea40c4fa6022_ACT_9bf7b056-ca4f-4dab-937b-619d0eb20528_SESS_d7580529-3ede-4e27-a2ae-01849ba4d397_RISC_f0249631-e141-477c-a453-a48959147fb4_ZIP_','2022-12-22 10:34:46','2022-12-22 11:34:40','55_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-12-22 11:34:46','SYNCED','61868b29-75e1-4d82-8528-52064d6c3eb2',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.55.1.1.1\",\"modelMatrix\":\"0.99757,-0.0292549,-0.0618613,0,0.0378844,0.990727,0.129631,0,0.0584827,-0.132686,0.989632,0,-9.13035,10.5407,-17.232,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'61e3032d-2a22-4747-9fa6-a0eb3275ef87','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/scan_71f637a7-a4e5-4025-8ef3-6af04a8febfe/54_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_BOSC_71f637a7-a4e5-4025-8ef3-6af04a8febfe_SNAPS_','2022-12-13 09:34:03','2022-12-13 10:33:51','54_w1_o1_mandibule_snapshot_0.png','2022-12-13 10:34:03','SYNCED','61e3032d-2a22-4747-9fa6-a0eb3275ef87',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.54.1.1.4\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'62110026-7393-4ad5-bf19-dfa00af5ad07','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_6c9ae07a-23c3-4355-87ff-b57ef558a4ea/17_w1_o1_mordu_posterieur_gauche_snapshot_1.png','SNAPS','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_LESC_6c9ae07a-23c3-4355-87ff-b57ef558a4ea_SNAPS_','2022-02-11 16:09:43','2022-02-11 17:09:32','17_w1_o1_mordu_posterieur_gauche_snapshot_1.png','2022-02-11 17:09:43','SYNCED','2de8ced1-ba29-48f4-bc49-585a3648f21c',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.17.1.1.3\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'62166d54-8239-45c4-af5b-13106fa4a222','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/45ff7437-0691-4427-a7da-8250862e4b96/session_4ff9c682-c09d-42ff-8c29-aeb13e066ed2/order_8e37acfc-d63e-497a-b841-276203d01db8/9_w1_inlay_onlay_prost_file_62166d54-8239-45c4-af5b-13106fa4a222_0.pdf','PDF','PATIENT_45ff7437-0691-4427-a7da-8250862e4b96_ACT_4ff9c682-c09d-42ff-8c29-aeb13e066ed2_PROST_8e37acfc-d63e-497a-b841-276203d01db8_PDF_','2022-01-24 19:57:10','2022-01-24 20:57:07','9_w1_inlay_onlay_prost_file_62166d54-8239-45c4-af5b-13106fa4a222_0.pdf','2022-01-24 20:57:10','SYNCED','62166d54-8239-45c4-af5b-13106fa4a222',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.9.1.1 INLAY ONLAY\",\"title\":\"Inlay/Onlay PDF\"}'),(1001,'6217fbe5-09ba-48c5-9c84-c981fea99cac','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f4fc00ec-4af8-4a15-b427-f1c5aabf6260/session_498ae60a-23f0-44fc-9730-be499bfc4b46/occlusion_8f3d6c73-3468-45a5-85c7-93bba47ec9f7/computedocclusion_9c318e86-fa90-4cd9-8319-2503cde2b455/30_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_f4fc00ec-4af8-4a15-b427-f1c5aabf6260_ACT_498ae60a-23f0-44fc-9730-be499bfc4b46_SESS_8f3d6c73-3468-45a5-85c7-93bba47ec9f7_OCC_9c318e86-fa90-4cd9-8319-2503cde2b455_TOPLY__ZIP_','2022-06-14 13:30:12','2022-06-14 15:29:56','30_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-06-14 15:30:12','SYNCED','6217fbe5-09ba-48c5-9c84-c981fea99cac',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.30.1.1.1 Occlusion 1\",\"modelMatrix\":\"-0.102207,0.992752,-0.0632283,0,-0.994763,-0.102001,0.00649642,0,1.08257e-11,0.0635612,0.997978,0,0.134114,-19.6177,-21.1524,1\",\"referenceScanID\":\"1.30.1.1.1\",\"title\":\"Maxillaire 1.30.1.1.1 Occlusion 1\"}'),(1001,'6234141f-64e4-4942-9db8-4603e56c7d72','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/372000f2-2471-4a57-9b18-224d0788041f/session_5dd64d24-8e33-45bd-a282-c148c185c338/occlusion_a61fbfda-1ac5-4747-9e0c-6ef664930816/scan_a716cac5-0e02-481c-a14b-3fc981cdeb96/57_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_372000f2-2471-4a57-9b18-224d0788041f_ACT_5dd64d24-8e33-45bd-a282-c148c185c338_SESS_a61fbfda-1ac5-4747-9e0c-6ef664930816_BOSC_a716cac5-0e02-481c-a14b-3fc981cdeb96_SNAPS_','2023-02-17 10:43:11','2023-02-17 11:43:02','57_w1_o1_mandibule_snapshot_0.png','2023-02-17 11:43:11','SYNCED','6234141f-64e4-4942-9db8-4603e56c7d72',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.57.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'6234b2dc-c74e-4c5b-b440-63b8dc9ddcba','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_ce625ba7-4218-40af-b344-df718da13f83/54_w1_o1_mandibule_matrix_occ_file_2.m','MATRX','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_ce625ba7-4218-40af-b344-df718da13f83_BOMA__MATRX_','2023-03-15 10:16:44','2023-03-15 11:15:19','54_w1_o1_mandibule_matrix_occ_file_2.m','2023-03-15 11:16:44','SYNCED','45775437-46ca-4831-b788-61b2ad12ff31',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.54.1.1.4 Occlusion 1\",\"referenceScanID\":\"1.54.1.1.4\",\"title\":\"Matrice Transfo. Mandibule 1.54.1.1.4 Occlusion 1\"}'),(1001,'62e04955-36d7-4e72-9a0b-cffb6a8463fe','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/scan_eafe4b37-e7ad-4f58-b931-a99f31f6d4a4/22_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_BOSC_eafe4b37-e7ad-4f58-b931-a99f31f6d4a4_SNAPS_','2022-04-21 10:47:54','2022-04-21 12:47:43','22_w1_o1_mandibule_snapshot_0.png','2022-04-21 12:47:54','SYNCED','62e04955-36d7-4e72-9a0b-cffb6a8463fe',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.22.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'636f5563-3dce-48da-97ef-4162f2b3051b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7f47fd88-9ea0-4c08-9193-a54d4f158c7c/session_7873a396-419c-4215-83c7-fec9f2742ccf/occlusion_2e287bb0-e19a-414a-9177-23b335d286d9/scan_aa3849b7-bd16-41b9-8afe-0af192f363d1/16_w1_o2_mandibule_scan_file_1.zip','ZIP','PATIENT_7f47fd88-9ea0-4c08-9193-a54d4f158c7c_ACT_7873a396-419c-4215-83c7-fec9f2742ccf_SESS_2e287bb0-e19a-414a-9177-23b335d286d9_BOSC_aa3849b7-bd16-41b9-8afe-0af192f363d1_ZIP_','2022-06-03 09:01:34','2022-06-03 11:01:26','16_w1_o2_mandibule_scan_file_1.zip','2022-06-03 11:01:34','SYNCED','f6f9c81e-5679-4d17-89e3-2a76bf2488aa',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.16.1.2.1\",\"modelMatrix\":\"-0.864845,0.473616,-0.166526,0,-0.502038,-0.815882,0.286869,0,-7.35692e-09,0.3317,0.943385,0,-0.119603,-7.43592,-19.1524,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'63b79dbb-70ef-4684-9dcd-0be1e85827c2','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_ce625ba7-4218-40af-b344-df718da13f83/54_w1_o1_mandibule_occlusion_occ_file_6.zip','ZIP','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_ce625ba7-4218-40af-b344-df718da13f83_BOPLY__ZIP_','2023-03-15 10:33:47','2023-03-15 11:32:27','54_w1_o1_mandibule_occlusion_occ_file_6.zip','2023-03-15 11:33:47','SYNCED','d1adede1-c3da-47da-a47c-075f5a6fe836',6,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.54.1.1.4 Occlusion 1\",\"modelMatrix\":\"-0.999599,0.0258183,-0.0116515,0,-0.0283256,-0.911116,0.411175,0,-3.36598e-10,0.41134,0.911482,0,17.4173,6.0967,-21.0427,1\",\"referenceScanID\":\"1.54.1.1.4\",\"title\":\"Mandibule 1.54.1.1.4 Occlusion 1\"}'),(1001,'63ba55f1-1de3-4eec-ac72-d886606ec033','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/452a5200-3e06-4b74-8949-6abc7f2dda8a/session_3e95d626-668f-45f7-98ad-be2cf9d7b90b/occlusion_bce8310f-eee9-4f0a-a6b7-d592dec66be5/scan_49ae59fe-0bc4-4d86-b65e-d8788e2d12fb/26_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_452a5200-3e06-4b74-8949-6abc7f2dda8a_ACT_3e95d626-668f-45f7-98ad-be2cf9d7b90b_SESS_bce8310f-eee9-4f0a-a6b7-d592dec66be5_TOSC_49ae59fe-0bc4-4d86-b65e-d8788e2d12fb_ZIP_','2022-05-24 09:36:31','2022-05-24 11:36:20','26_w1_o1_maxillaire_scan_file_1.zip','2022-05-24 11:36:31','SYNCED','ed3a6299-1604-4ba4-8ce0-6c50eb2674e7',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.26.1.1.2\",\"modelMatrix\":\"-0.139935,0.977576,-0.157365,0,-0.990161,-0.138156,0.0222396,0,1.70026e-09,0.158929,0.98729,0,5.50609,-23.1559,-20.3156,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'63ca9fe6-9ff7-4db0-abdf-7dae392624d8','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/9e399d73-4d2e-4bb8-af48-a4e597811faa/session_b1cf14ce-00a9-48b6-8654-dadde26073f1/occlusion_3c4595e0-fbbb-4814-8851-1e014eb9a3b2/scan_f0503cbf-d4f4-47f3-b287-f97b61ab8a74/46_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_9e399d73-4d2e-4bb8-af48-a4e597811faa_ACT_b1cf14ce-00a9-48b6-8654-dadde26073f1_SESS_3c4595e0-fbbb-4814-8851-1e014eb9a3b2_RISC_f0503cbf-d4f4-47f3-b287-f97b61ab8a74_SNAPS_','2022-10-27 11:51:52','2022-10-27 13:50:36','46_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-10-27 13:51:52','SYNCED','63ca9fe6-9ff7-4db0-abdf-7dae392624d8',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.46.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'63e9f9a7-c8a4-4bf2-9e7c-c06c335ff76a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/207d6dbc-c19b-4726-a9b3-16235ae554cc/session_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35/occlusion_dc5762a3-c453-4166-8c86-82d23ac9f8a6/computedocclusion_3a1fff1c-0427-409c-aa94-06326e554d82/27_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_207d6dbc-c19b-4726-a9b3-16235ae554cc_ACT_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35_SESS_dc5762a3-c453-4166-8c86-82d23ac9f8a6_OCC_3a1fff1c-0427-409c-aa94-06326e554d82_TOPLY__ZIP_','2022-05-30 11:09:39','2022-05-30 13:09:22','27_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-05-30 13:09:39','SYNCED','63e9f9a7-c8a4-4bf2-9e7c-c06c335ff76a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.27.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.708736,0.675594,-0.203138,0,-0.705473,0.678719,-0.204077,0,4.95031e-09,0.287945,0.957647,0,-5.6101,-21.7145,-20.7773,1\",\"referenceScanID\":\"1.27.1.1.1\",\"title\":\"Maxillaire 1.27.1.1.1 Occlusion 1\"}'),(1001,'63ec45c0-c5a3-4252-9782-a09310e05577','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/98aa55d8-3848-48e0-9684-5597786b85c7/session_4df1e430-5cbb-4a6c-8292-747e35e6f1e8/occlusion_fcc5c65d-b0e4-4036-99c7-07318171986a/scan_3b296950-48dd-4691-8dfd-0e5fe6997fdf/66_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_98aa55d8-3848-48e0-9684-5597786b85c7_ACT_4df1e430-5cbb-4a6c-8292-747e35e6f1e8_SESS_fcc5c65d-b0e4-4036-99c7-07318171986a_LESC_3b296950-48dd-4691-8dfd-0e5fe6997fdf_SNAPS_','2023-04-13 10:07:02','2023-04-13 12:07:02','66_w1_o1_mordu_posterieur_gauche_snapshot_0.png',NULL,'CREATED','63ec45c0-c5a3-4252-9782-a09310e05577',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche SNAPSHOT\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'63fde542-acb3-4b8f-82f2-355dcc8f8d55','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/8fc74d9e-a5a0-46bf-be3f-500548a130ad/session_5368829e-7dec-4775-a487-a1019f9604f4/occlusion_bb63a653-1b34-4d80-a4bf-7fda5c9b0360/scan_bb2387c3-c044-46d4-bfeb-b3572a68a3e5/14_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_8fc74d9e-a5a0-46bf-be3f-500548a130ad_ACT_5368829e-7dec-4775-a487-a1019f9604f4_SESS_bb63a653-1b34-4d80-a4bf-7fda5c9b0360_BOSC_bb2387c3-c044-46d4-bfeb-b3572a68a3e5_ZIP_','2022-02-01 10:46:35','2022-02-01 11:46:24','14_w1_o1_mandibule_scan_file_0.zip','2022-02-01 11:46:35','SYNCED','63fde542-acb3-4b8f-82f2-355dcc8f8d55',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.14.1.1.1\",\"modelMatrix\":\"0.729394,0.676142,-0.103997,0,-0.684093,0.720917,-0.110883,0,-1.15254e-9,0.152021,0.988377,0,-16.6301,-13.2651,-17.5315,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'6427bbad-56f9-4ea6-b032-c447d4b7eb29','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/9e399d73-4d2e-4bb8-af48-a4e597811faa/session_b1cf14ce-00a9-48b6-8654-dadde26073f1/order_27589f17-d627-4a78-8c2a-f30dd005b87a/46_w1_autre_prost_file_6427bbad-56f9-4ea6-b032-c447d4b7eb29_0.pdf','PDF','PATIENT_9e399d73-4d2e-4bb8-af48-a4e597811faa_ACT_b1cf14ce-00a9-48b6-8654-dadde26073f1_PROST_27589f17-d627-4a78-8c2a-f30dd005b87a_PDF_','2023-01-26 12:59:41','2023-01-26 13:59:39','46_w1_autre_prost_file_6427bbad-56f9-4ea6-b032-c447d4b7eb29_0.pdf','2023-01-26 13:59:41','SYNCED','6427bbad-56f9-4ea6-b032-c447d4b7eb29',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.46.1.1 AUTRE FICHE DE PROTHESE\",\"title\":\"Autre PDF\"}'),(1001,'642f1d21-72b4-419c-b005-26b9f2557b21','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/e922efb9-8c03-445b-8a0f-449e3c43bdca/session_a2369349-1629-40ad-8784-d271bc3fbade/occlusion_292cc1aa-8b12-463b-87a1-7d9731cf886b/computedocclusion_f9f6d9d2-cc34-43c3-9f5f-4b8e54b41bbb/21_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_e922efb9-8c03-445b-8a0f-449e3c43bdca_ACT_a2369349-1629-40ad-8784-d271bc3fbade_SESS_292cc1aa-8b12-463b-87a1-7d9731cf886b_OCC_f9f6d9d2-cc34-43c3-9f5f-4b8e54b41bbb_TOMA__MATRX_','2022-04-21 08:53:15','2022-04-21 10:53:03','21_w1_o1_maxillaire_matrix_occ_file_0.m','2022-04-21 10:53:15','SYNCED','642f1d21-72b4-419c-b005-26b9f2557b21',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.21.1.1.1 Occlusion 2\",\"referenceScanID\":\"1.21.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.21.1.1.1 Occlusion 2\"}'),(1001,'643b4b45-c20a-4040-bf63-70edc63f19d1','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/computedocclusion_7c70edbe-5cb4-4244-8baf-7caf2bd7d86b/12_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_OCC_7c70edbe-5cb4-4244-8baf-7caf2bd7d86b_BOMA__MATRX_','2022-02-04 17:59:49','2022-02-04 18:58:48','12_w1_o1_mandibule_matrix_occ_file_0.m','2022-02-04 18:59:49','SYNCED','643b4b45-c20a-4040-bf63-70edc63f19d1',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.12.1.1.5 Occlusion 1\",\"referenceScanID\":\"1.12.1.1.5\",\"title\":\"Matrice Transfo. Mandibule 1.12.1.1.5 Occlusion 1\"}'),(1001,'6450ccf2-fa7c-4da9-b0db-3bf64296703e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_2ffbfbca-f236-4802-be93-8eb43d523274/scan_dfbb6a00-3125-4e66-bba2-7ad562b73551/4_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_2ffbfbca-f236-4802-be93-8eb43d523274_TOSC_dfbb6a00-3125-4e66-bba2-7ad562b73551_ZIP_','2022-01-19 18:59:33','2022-01-19 19:59:10','4_w1_o1_maxillaire_scan_file_0.zip','2022-01-19 19:59:33','SYNCED','6450ccf2-fa7c-4da9-b0db-3bf64296703e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.4.1.1.1\",\"modelMatrix\":\"-0.389008,0.904422,-0.175195,0,-0.921234,-0.381909,0.0739794,0,-3.44075e-9,0.190174,0.98175,0,-3.07419,-20.917,-20.2976,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'645a79d8-6daf-4b69-a275-6548b7364752','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/39062d60-7a18-417a-9004-c58e9ce7d62a/session_9869e99c-7b47-4662-9766-0388d668fbf3/occlusion_36832844-9579-46df-aea1-b9baf6ad8787/scan_c4535e06-3294-424b-83ea-ac181cad8776/61_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_39062d60-7a18-417a-9004-c58e9ce7d62a_ACT_9869e99c-7b47-4662-9766-0388d668fbf3_SESS_36832844-9579-46df-aea1-b9baf6ad8787_RISC_c4535e06-3294-424b-83ea-ac181cad8776_ZIP_','2023-03-10 17:33:29','2023-03-10 18:33:17','61_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2023-03-10 18:33:29','SYNCED','645a79d8-6daf-4b69-a275-6548b7364752',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.61.1.1.1\",\"modelMatrix\":\"0.961402,-0.156274,0.228712,0,0.115609,0.98059,0.126441,0,-0.249858,-0.122293,0.965734,0,-7.22023,5.17128,-21.1968,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'64a2cdcc-5188-478e-9b53-93f8a3b2cb90','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/scan_f2bad12a-451d-406d-98b0-e431a37951dd/19_w1_o1_mandibule_scan_file_3.zip','ZIP','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_BOSC_f2bad12a-451d-406d-98b0-e431a37951dd_ZIP_','2022-03-08 10:52:49','2022-03-08 11:52:41','19_w1_o1_mandibule_scan_file_3.zip','2022-03-08 11:52:49','SYNCED','e3a545cc-fe2a-418f-9896-979b09c1f684',3,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.1.4\",\"modelMatrix\":\"-0.988793,0.145775,-0.0322113,0,-0.149292,-0.965503,0.213343,0,-2.16806e-09,0.215761,0.976446,0,23.0578,-21.2539,-25.059,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'64b1a7cd-06d4-469c-b06d-4c38cfd82051','','ZIP','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_OCC_778ed9fd-f658-471d-9dd0-a48417419cba_BOPLY__ZIP_','2022-05-12 12:32:06','2022-05-12 14:31:43','','2022-05-12 14:32:06','SYNCED','64b1a7cd-06d4-469c-b06d-4c38cfd82051',0,'2022-05-12 14:32:06','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.18.1.1.3 Occlusion 3\",\"modelMatrix\":\"-0.721265,0.622319,-0.304132,0,-0.69266,-0.648019,0.316692,0,5.59464e-09,0.439079,0.898449,0,-8.58806,-18.2472,-17.8803,1\",\"referenceScanID\":\"1.18.1.1.3\",\"title\":\"Mandibule 1.18.1.1.3 Occlusion 3\"}'),(1001,'6504ab72-95fe-47d4-9e8c-72f5662b1616','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/order_13ed86f9-f32c-434d-be1e-dd6b645457dd/38_w1_couronne_prost_file_6504ab72-95fe-47d4-9e8c-72f5662b1616_0.pdf','PDF','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_PROST_13ed86f9-f32c-434d-be1e-dd6b645457dd_PDF_','2022-07-12 17:44:23','2022-07-12 19:44:21','38_w1_couronne_prost_file_6504ab72-95fe-47d4-9e8c-72f5662b1616_0.pdf','2022-07-12 19:44:23','SYNCED','6504ab72-95fe-47d4-9e8c-72f5662b1616',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.38.1.1 COURONNE\",\"title\":\"Couronne PDF\"}'),(1001,'65248dcf-9c3a-47ce-a2c2-9d6f5de84040','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/computedocclusion_2de3d2bb-d512-4514-8bed-a879b73a6028/22_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_OCC_2de3d2bb-d512-4514-8bed-a879b73a6028_TOMA__MATRX_','2022-04-21 11:29:39','2022-04-21 13:29:16','22_w1_o1_maxillaire_matrix_occ_file_0.m','2022-04-21 13:29:39','SYNCED','65248dcf-9c3a-47ce-a2c2-9d6f5de84040',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.22.1.1.1 Occlusion 7\",\"referenceScanID\":\"1.22.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.22.1.1.1 Occlusion 7\"}'),(2,'65304f6c-7e3f-44de-9447-cad85ecf6541','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a4b302c-278d-4e12-ace5-f095ba0bf856/session_6206892a-2e7e-4765-ac90-b49bfb465997/occlusion_7ec70f78-dc80-40c5-b293-570a59f034c4/scan_1075d1a0-1218-4048-a7c7-3aa9195b6f63/3_w1_o2_maxillaire_scan_file_0.zip','ZIP','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_7ec70f78-dc80-40c5-b293-570a59f034c4_TOSC_1075d1a0-1218-4048-a7c7-3aa9195b6f63_ZIP_','2022-09-06 09:20:30','2022-08-30 14:28:41','3_w1_o2_maxillaire_scan_file_0.zip','2022-09-06 11:20:30','SYNCED','65304f6c-7e3f-44de-9447-cad85ecf6541',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.3.1.2.5\",\"modelMatrix\":\"0.456772,0.864302,-0.210572,0,-0.889584,0.443791,-0.108122,0,6.64111e-09,0.236708,0.971581,0,-22.1477,-20.4345,-15.1629,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'6559bc64-74fd-4af6-8b2d-bd6b8adfb920','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/4fa1a134-d246-43d7-aa8c-b42e24b62b49/session_6aedf6fd-46d7-4259-88ba-5cf074ad5913/occlusion_47192ebb-25b6-4c9e-a09f-8ed295e60a87/scan_283f28e2-92dd-426a-bc9e-a4fe6fdb180c/60_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_4fa1a134-d246-43d7-aa8c-b42e24b62b49_ACT_6aedf6fd-46d7-4259-88ba-5cf074ad5913_SESS_47192ebb-25b6-4c9e-a09f-8ed295e60a87_TOSC_283f28e2-92dd-426a-bc9e-a4fe6fdb180c_ZIP_','2023-03-07 18:02:30','2023-03-07 19:02:10','60_w1_o1_maxillaire_scan_file_1.zip','2023-03-07 19:02:30','SYNCED','13d7e3e3-0c0d-43d7-9b8e-5a2bd67c455c',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.60.1.1.1\",\"modelMatrix\":\"0.864717,0.477113,-0.156931,0,-0.502259,0.821424,-0.270182,0,1.00298e-09,0.312451,0.949934,0,-7.98216,-12.8874,-17.6266,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'6572a09e-0600-46b5-808e-1a6ed5da434e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/d100e894-0be9-4495-94e2-e469232f7817/session_2c8b85b5-c805-4b08-85e7-3d02dab72e99/occlusion_8a278cc5-a1c1-4dfb-9ee2-c971a6309afa/scan_6c418416-1c53-40cd-ba49-f56373b0bc1a/15_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_d100e894-0be9-4495-94e2-e469232f7817_ACT_2c8b85b5-c805-4b08-85e7-3d02dab72e99_SESS_8a278cc5-a1c1-4dfb-9ee2-c971a6309afa_BOSC_6c418416-1c53-40cd-ba49-f56373b0bc1a_ZIP_','2022-02-01 15:02:14','2022-02-01 16:01:54','15_w1_o1_mandibule_scan_file_0.zip','2022-02-01 16:02:14','SYNCED','6572a09e-0600-46b5-808e-1a6ed5da434e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.15.1.1.2\",\"modelMatrix\":\"-0.985432,0.141687,-0.0940649,0,-0.170069,-0.820979,0.545042,0,2.27757e-9,0.5531,0.833115,0,26.9779,0.977042,-14.8944,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'6591fbb8-1677-45c7-80e9-5726ea14667c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3ed7a8e0-5b4d-4ecf-b4ae-f855b16c0f93/session_fb42cec6-0bb6-41e9-912d-0517ff8e0942/occlusion_fb214b2f-5e41-492d-85c4-d4a11a3947c5/scan_d7407f25-706b-455d-bad0-4ca82328f452/42_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_3ed7a8e0-5b4d-4ecf-b4ae-f855b16c0f93_ACT_fb42cec6-0bb6-41e9-912d-0517ff8e0942_SESS_fb214b2f-5e41-492d-85c4-d4a11a3947c5_BOSC_d7407f25-706b-455d-bad0-4ca82328f452_SNAPS_','2022-10-07 11:44:22','2022-10-07 13:44:21','42_w1_o1_maxillaire_snapshot_0.png','2022-10-07 13:44:22','SYNCED','6591fbb8-1677-45c7-80e9-5726ea14667c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.42.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'65a1c33d-5a70-4155-ac8d-4be3028e8eca','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/discussion_4d12bcc3-80f2-49dc-9159-54929f160ce6/65a1c33d-5a70-4155-ac8d-4be3028e8eca.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_426bd908-3163-4291-a697-20eacff771ab_BOPLY__ZIP_','2022-05-25 08:56:24','2022-05-16 19:57:11','65a1c33d-5a70-4155-ac8d-4be3028e8eca.zip','2022-05-25 10:56:24','SYNCED','65a1c33d-5a70-4155-ac8d-4be3028e8eca',0,'2022-05-25 10:56:24','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.24.1.1.1 Occlusion 6\",\"modelMatrix\":\"0.852703,-0.521011,0.0380208,0,0.522396,0.850441,-0.062061,0,3.49638e-10,0.0727815,0.997348,0,-11.3911,-12.8136,-21.1334,1\",\"referenceScanID\":\"1.24.1.1.1\",\"title\":\"Mandibule 1.24.1.1.1 Occlusion 6\"}'),(1001,'65fd3ecb-affa-479b-8a28-d81f4574f5ef','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/computedocclusion_b35629de-38d8-4cdd-bf2c-b61c461410cb/17_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_b35629de-38d8-4cdd-bf2c-b61c461410cb_TOMA__MATRX_','2022-02-07 18:07:23','2022-02-07 19:05:55','17_w1_o1_maxillaire_matrix_occ_file_0.m','2022-02-07 19:07:23','SYNCED','65fd3ecb-affa-479b-8a28-d81f4574f5ef',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.17.1.1.1 Occlusion 6\",\"referenceScanID\":\"1.17.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.17.1.1.1 Occlusion 6\"}'),(1001,'6638ad2b-84e9-4c08-ad38-98e12dae4a45','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_fde05ea2-d0fd-419b-ba13-bf1a1bd03a22/18_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_BOSC_fde05ea2-d0fd-419b-ba13-bf1a1bd03a22_ZIP_','2022-03-07 14:25:30','2022-03-07 15:25:19','18_w1_o1_mandibule_scan_file_0.zip','2022-03-07 15:25:30','SYNCED','6638ad2b-84e9-4c08-ad38-98e12dae4a45',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.18.1.1.2\",\"modelMatrix\":\"0.885931,-0.458931,0.0671427,0,0.463817,0.876599,-0.128249,0,7.65783e-11,0.144761,0.989467,0,0.24241,21.5206,-16.5349,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'6663a1af-2944-4657-897b-ca9974703102','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/57c4096f-98dd-49c8-bea5-a5b109ad3fd0/session_4f62e395-5623-4d5b-869c-1b2fc4d22b00/occlusion_1ac20dc7-b36b-4786-a05f-37091554dc5c/scan_e2e4ad7f-c1c9-4c11-a41c-d237b2e0023e/31_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_57c4096f-98dd-49c8-bea5-a5b109ad3fd0_ACT_4f62e395-5623-4d5b-869c-1b2fc4d22b00_SESS_1ac20dc7-b36b-4786-a05f-37091554dc5c_BOSC_e2e4ad7f-c1c9-4c11-a41c-d237b2e0023e_SNAPS_','2022-06-16 10:59:43','2022-06-16 12:59:33','31_w1_o1_mandibule_snapshot_0.png','2022-06-16 12:59:43','SYNCED','6663a1af-2944-4657-897b-ca9974703102',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.31.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'6664ed29-0935-466e-abc8-468b0ac6dee3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/scan_725ef2a4-4b53-4ec9-a807-17759213c882/22_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_BOSC_725ef2a4-4b53-4ec9-a807-17759213c882_ZIP_','2022-04-21 11:05:31','2022-04-21 13:05:24','22_w1_o1_mandibule_scan_file_0.zip','2022-04-21 13:05:31','SYNCED','6664ed29-0935-466e-abc8-468b0ac6dee3',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.22.1.1.2\",\"modelMatrix\":\"0.930866,0.359665,-0.0642588,0,-0.36536,0.916356,-0.163719,0,1.67408e-09,0.175878,0.984412,0,-11.7687,0.165278,-18.4217,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'66758b71-914b-4cf4-ad19-830033ce9bd6','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_ce625ba7-4218-40af-b344-df718da13f83/54_w1_o1_maxillaire_matrix_occ_file_3.m','MATRX','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_ce625ba7-4218-40af-b344-df718da13f83_TOMA__MATRX_','2023-03-15 10:16:47','2023-03-15 11:16:15','54_w1_o1_maxillaire_matrix_occ_file_3.m','2023-03-15 11:16:47','SYNCED','ccf7be44-96c0-48d2-80d6-833cb64e29bc',3,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.54.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.54.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.54.1.1.1 Occlusion 1\"}'),(1001,'66961639-a805-46f9-bc8c-5d51fa295ec0','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_e8550560-cfe0-40a1-bfb3-992d471fbcb7/17_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_BOSC_e8550560-cfe0-40a1-bfb3-992d471fbcb7_ZIP_','2022-02-07 11:41:44','2022-02-07 12:35:18','17_w1_o1_mandibule_scan_file_0.zip','2022-02-07 12:41:44','SYNCED','66961639-a805-46f9-bc8c-5d51fa295ec0',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.17.1.1.1\",\"modelMatrix\":\"-0.999279,-0.0367359,0.00954126,0,0.0379548,-0.96719,0.251204,0,-7.36168e-10,0.251385,0.967887,0,30.9318,13.7449,-19.2031,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'66b1ce2c-2444-4a54-9fe5-0dadee0be0cb','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_4f8dc275-857c-482a-9886-5521591e9661/scan_ac56bd4c-2fb3-4bde-858c-86c2586bc3e9/12_w1_o4_maxillaire_snapshot_0.png','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_TOSC_ac56bd4c-2fb3-4bde-858c-86c2586bc3e9_SNAPS_','2022-02-14 10:22:02','2022-02-14 11:21:44','12_w1_o4_maxillaire_snapshot_0.png','2022-02-14 11:22:02','SYNCED','66b1ce2c-2444-4a54-9fe5-0dadee0be0cb',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.12.1.4.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'66d50d08-fde2-4aee-a895-3ed3fd20f65a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5a33a64b-822d-40bf-ba8c-e11c11a50f88/session_e0a7776f-79fe-4c85-85ab-9ca244e7ff95/occlusion_b3568df2-4c54-486e-b27f-2d92375e5d11/scan_9d41d296-c093-413a-a969-5832498f8c39/43_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_5a33a64b-822d-40bf-ba8c-e11c11a50f88_ACT_e0a7776f-79fe-4c85-85ab-9ca244e7ff95_SESS_b3568df2-4c54-486e-b27f-2d92375e5d11_TOSC_9d41d296-c093-413a-a969-5832498f8c39_SNAPS_','2022-10-11 14:10:11','2022-10-11 16:09:57','43_w1_o1_maxillaire_snapshot_0.png','2022-10-11 16:10:11','SYNCED','66d50d08-fde2-4aee-a895-3ed3fd20f65a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.43.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'66f0c509-0e47-49c8-8cae-0cbb6a788831','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_2a7068fc-0efa-496f-ade9-aba5b0650655/12_w1_o1_mandibule_scan_file_7.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_2a7068fc-0efa-496f-ade9-aba5b0650655_ZIP_','2022-02-04 12:08:35','2022-02-04 13:08:20','12_w1_o1_mandibule_scan_file_7.zip','2022-02-04 13:08:35','SYNCED','44ebcd6f-57c2-4cce-96f5-f9faa1c6b373',7,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.5\",\"modelMatrix\":\"0.812765,-0.55474,0.177983,0,0.582592,0.773907,-0.248301,0,-6.61608e-9,0.305502,0.952191,0,-2.30692,30.696,-29.3075,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'6703e7d5-5908-4d87-8d6c-4fb206bab958','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/fa7fa96b-f393-4b9a-8198-144702462cfa/session_4bed076c-8541-4a2f-800a-5aeb4cb49de5/occlusion_16b82fca-4b65-4866-af87-1f6dbb42f5dc/scan_77280faa-6fb3-46f5-aa9e-fd5dd96b1535/35_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_fa7fa96b-f393-4b9a-8198-144702462cfa_ACT_4bed076c-8541-4a2f-800a-5aeb4cb49de5_SESS_16b82fca-4b65-4866-af87-1f6dbb42f5dc_TOSC_77280faa-6fb3-46f5-aa9e-fd5dd96b1535_ZIP_','2022-06-28 15:01:18','2022-06-28 17:01:09','35_w1_o1_maxillaire_scan_file_0.zip','2022-06-28 17:01:18','SYNCED','6703e7d5-5908-4d87-8d6c-4fb206bab958',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.35.1.1.1\",\"modelMatrix\":\"0.09906,0.984988,-0.141374,0,-0.995081,0.0980552,-0.0140737,0,-1.38943e-09,0.142073,0.989856,0,-3.58695,-24.3271,-17.1724,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'67123426-d3c5-4808-9c1a-1d5dc553e574','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/9e399d73-4d2e-4bb8-af48-a4e597811faa/session_b1cf14ce-00a9-48b6-8654-dadde26073f1/occlusion_1060c95f-48f4-4a37-9b82-03bfd8329730/scan_b1026ef6-2b78-490a-891d-1bce15f88b4a/46_w1_o2_maxillaire_scan_file_0.zip','ZIP','PATIENT_9e399d73-4d2e-4bb8-af48-a4e597811faa_ACT_b1cf14ce-00a9-48b6-8654-dadde26073f1_SESS_1060c95f-48f4-4a37-9b82-03bfd8329730_TOSC_b1026ef6-2b78-490a-891d-1bce15f88b4a_ZIP_','2023-01-20 12:51:09','2023-01-20 13:50:41','46_w1_o2_maxillaire_scan_file_0.zip','2023-01-20 13:51:09','SYNCED','67123426-d3c5-4808-9c1a-1d5dc553e574',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.46.1.2.1\",\"modelMatrix\":\"-0.999978,-0.00661075,0.000792208,0,0.00665805,-0.992874,0.118982,0,3.47704e-12,0.118985,0.992896,0,12.1574,-10.279,-23.0403,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'674bf663-589f-4efa-8935-869a415dee68','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_0e451099-a0ad-463c-9441-7ded1297fa16/24_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_TOSC_0e451099-a0ad-463c-9441-7ded1297fa16_ZIP_','2022-05-24 14:43:40','2022-05-24 16:43:26','24_w1_o1_maxillaire_scan_file_1.zip','2022-05-24 16:43:40','SYNCED','5d3dcc4f-6d2d-44ab-815b-4de5076cb320',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.3\",\"modelMatrix\":\"-0.348415,0.927523,-0.135305,0,-0.93734,-0.344766,0.0502937,0,4.16863e-09,0.14435,0.989527,0,-8.01926,-22.8232,-18.3945,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'675b37ea-2917-45cd-8a16-d591bc39a814','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_04d6e3f1-19ce-4851-a9d0-40419cea7542/scan_e61be1a3-1cc4-4625-b318-5e591ee9846a/19_w1_o2_mordu_anterieur_scan_file_0.zip','ZIP','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_04d6e3f1-19ce-4851-a9d0-40419cea7542_FRSC_e61be1a3-1cc4-4625-b318-5e591ee9846a_ZIP_','2022-04-15 11:41:26','2022-04-01 18:21:10','19_w1_o2_mordu_anterieur_scan_file_0.zip','2022-04-15 13:41:26','SYNCED','675b37ea-2917-45cd-8a16-d591bc39a814',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.19.1.2.1\",\"modelMatrix\":\"0.854332,0.1505,0.504464,0,-0.137793,0.988812,0.0147122,0,-0.501422,-0.047782,0.864719,0,-2.93614,-3.90513,-30.1512,1\",\"title\":\"Mordu anterieur ZIP\"}'),(1001,'679107eb-7e9d-4180-ae79-9907a2a032e3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a0c21836-ba79-4f15-9e35-02ef8211a9e5/session_0aac522d-3c38-465a-a1e0-014166c140ac/occlusion_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042/scan_8e186cfd-8ea5-4242-96cb-5a138aa44971/7_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_a0c21836-ba79-4f15-9e35-02ef8211a9e5_ACT_0aac522d-3c38-465a-a1e0-014166c140ac_SESS_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042_FRSC_8e186cfd-8ea5-4242-96cb-5a138aa44971_SNAPS_','2022-01-21 12:04:48','2022-01-21 13:03:11','7_w1_o1_mordu_anterieur_snapshot_0.png','2022-01-21 13:04:48','SYNCED','679107eb-7e9d-4180-ae79-9907a2a032e3',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.7.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'67a26d2a-1c67-4353-aac9-8b3183eb074d','','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_7d8decb1-23db-4824-940f-8d8822d88813_TOPLY__ZIP_','2022-02-08 08:49:00','2022-02-07 18:48:45','','2022-02-08 09:49:00','SYNCED','67a26d2a-1c67-4353-aac9-8b3183eb074d',0,'2022-02-08 09:49:00','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.17.1.1.1 Occlusion 3\",\"modelMatrix\":\"0.149253,0.920186,-0.361913,0,-0.988799,0.138896,-0.0546284,0,-8.90892e-10,0.366013,0.93061,0,-24.4594,-29.735,-12.8678,1\",\"referenceScanID\":\"1.17.1.1.1\",\"title\":\"Maxillaire 1.17.1.1.1 Occlusion 3\"}'),(1001,'67dec3ff-5824-4997-9c0b-d7b18cdb2cbd','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_d1eece96-1e6b-468d-8dc5-8295ca2149a4/24_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_LESC_d1eece96-1e6b-468d-8dc5-8295ca2149a4_ZIP_','2022-05-13 14:46:30','2022-05-13 16:46:23','24_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-05-13 16:46:30','SYNCED','67dec3ff-5824-4997-9c0b-d7b18cdb2cbd',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.24.1.1.1\",\"modelMatrix\":\"-0.988881,0.00916675,0.152174,0,-0.0148994,-0.99946,-0.0232662,0,0.148013,-0.0324218,0.988115,0,-9.88635,-3.09015,-15.7074,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'67fc2ea9-f9ad-45cc-93ad-297eb169820f','','LIFI','PATIENT_a9e7a1ae-2d71-448f-80f6-19d916912a3c_ACT_07012a03-2a1e-44e4-9bc9-17e726862bc2_SESS_ab83a8b7-1eb1-4b13-9594-40d6479b2b19_BOSC_e33a7de9-6d02-41e0-b621-fc99e53eb96c_LIFI_','2022-12-22 08:46:49','2022-12-14 16:02:13','','2022-12-22 09:46:49','SYNCED','67fc2ea9-f9ad-45cc-93ad-297eb169820f',0,'2022-12-22 09:46:49','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Mandibule 1.52.1.1.1 Ligne de finition 0\",\"name\":\"Ligne de finition 0\",\"title\":\"Mandibule LIFI\",\"toothNumber\":0,\"versionMarginLine\":1}'),(1001,'682c54ab-42b2-46a2-a6af-320afbdfdf82','','MATRX','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_OCC_ff8547d7-27f8-4862-9b63-e713dd817f3f_TOMA__MATRX_','2022-09-09 17:04:16','2022-09-09 19:03:34','','2022-09-09 19:04:16','SYNCED','682c54ab-42b2-46a2-a6af-320afbdfdf82',0,'2022-09-09 19:04:16','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.39.1.1.1 Occlusion 10\",\"referenceScanID\":\"1.39.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.39.1.1.1 Occlusion 10\"}'),(1001,'683c73b6-a453-4c29-a8cb-6a99b6d7e3d3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/45ff7437-0691-4427-a7da-8250862e4b96/session_4ff9c682-c09d-42ff-8c29-aeb13e066ed2/occlusion_934673c1-a4b9-4508-ac1b-a03092a0693e/scan_00f98bb4-dc6f-4a78-b9c8-5f04e23fc139/9_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_45ff7437-0691-4427-a7da-8250862e4b96_ACT_4ff9c682-c09d-42ff-8c29-aeb13e066ed2_SESS_934673c1-a4b9-4508-ac1b-a03092a0693e_TOSC_00f98bb4-dc6f-4a78-b9c8-5f04e23fc139_ZIP_','2022-01-24 17:38:28','2022-01-24 18:31:10','9_w1_o1_maxillaire_scan_file_0.zip','2022-01-24 18:38:28','SYNCED','683c73b6-a453-4c29-a8cb-6a99b6d7e3d3',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.9.1.1.1\",\"modelMatrix\":\"-0.0573042,0.992846,-0.104756,0,-0.998357,-0.0569879,0.00601286,0,4.73835e-10,0.104929,0.99448,0,6.4536,-23.1032,-18.5679,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'6850312f-6b70-474f-927d-240c003f6d0d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/9e399d73-4d2e-4bb8-af48-a4e597811faa/session_b1cf14ce-00a9-48b6-8654-dadde26073f1/occlusion_3c4595e0-fbbb-4814-8851-1e014eb9a3b2/scan_b1dee2c4-60b1-47c3-83e3-10d67f02d4f2/46_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_9e399d73-4d2e-4bb8-af48-a4e597811faa_ACT_b1cf14ce-00a9-48b6-8654-dadde26073f1_SESS_3c4595e0-fbbb-4814-8851-1e014eb9a3b2_LESC_b1dee2c4-60b1-47c3-83e3-10d67f02d4f2_ZIP_','2022-10-27 11:51:58','2022-10-27 13:51:52','46_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-10-27 13:51:58','SYNCED','6850312f-6b70-474f-927d-240c003f6d0d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.46.1.1.1\",\"modelMatrix\":\"-0.976638,-0.0106179,0.215712,0,0.0237325,-0.99259,0.117218,0,0.213962,0.121725,0.969396,0,12.4086,-5.02246,-22.7991,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'685e7310-189c-40af-ac57-e8cbef5c2417','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_e6c95ef7-636d-4c88-8d02-e2d9840573db/13_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_e6c95ef7-636d-4c88-8d02-e2d9840573db_ZIP_','2022-01-27 16:37:23','2022-01-27 17:36:59','13_w1_o1_mandibule_scan_file_1.zip','2022-01-27 17:37:23','SYNCED','bcef8d3e-9632-4976-8cda-4c6f3ac50e99',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.1\",\"modelMatrix\":\"-0.963479,0.243305,-0.111855,0,-0.267785,-0.8754,0.402451,0,1.23617e-9,0.417706,0.908582,0,32.4632,-3.53421,-16.2323,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'68a7881a-ea83-4e50-b8af-b28454591c34','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/scan_7b00996b-90f8-4307-9a8c-263a28f1b341/4_w1_o4_maxillaire_snapshot_0.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_TOSC_7b00996b-90f8-4307-9a8c-263a28f1b341_SNAPS_','2022-05-31 11:49:49','2022-05-31 13:49:39','4_w1_o4_maxillaire_snapshot_0.png','2022-05-31 13:49:49','SYNCED','68a7881a-ea83-4e50-b8af-b28454591c34',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.4.1.4.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'68cf35d1-7f31-4f48-8b81-a07300151534','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_4f8dc275-857c-482a-9886-5521591e9661/scan_df08df19-150c-437d-8ed4-bf2826644265/12_w1_o4_mandibule_scan_file_0.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_BOSC_df08df19-150c-437d-8ed4-bf2826644265_ZIP_','2022-02-18 16:11:36','2022-02-18 17:11:28','12_w1_o4_mandibule_scan_file_0.zip','2022-02-18 17:11:36','SYNCED','68cf35d1-7f31-4f48-8b81-a07300151534',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.4.5\",\"modelMatrix\":\"0.547289,0.783506,-0.294268,0,-0.836944,0.512345,-0.192425,0,2.01316e-08,0.351598,0.936151,0,-3.99458,-15.7075,-19.0924,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'68e7c3a1-6552-416d-a849-77f78c6c1539','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/scan_eafe4b37-e7ad-4f58-b931-a99f31f6d4a4/22_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_BOSC_eafe4b37-e7ad-4f58-b931-a99f31f6d4a4_ZIP_','2022-04-21 10:47:53','2022-04-21 12:47:44','22_w1_o1_mandibule_scan_file_0.zip','2022-04-21 12:47:53','SYNCED','68e7c3a1-6552-416d-a849-77f78c6c1539',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.22.1.1.1\",\"modelMatrix\":\"0.547665,-0.836383,0.0229432,0,0.836697,0.547459,-0.0150176,0,4.65993e-10,0.0274211,0.999624,0,6.28122,8.42122,-22.362,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'69031f67-5df5-4275-9366-6c75582ef750','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/32939ecf-ba11-4fff-a074-5e86a9f7f313/session_4075a8d6-094f-4202-abe0-4c02b7a5a8e6/order_920b9d76-bc23-467b-a3c6-2d7b175a8e1a/6_w1_couronne_prost_file_69031f67-5df5-4275-9366-6c75582ef750_0.pdf','PDF','PATIENT_32939ecf-ba11-4fff-a074-5e86a9f7f313_ACT_4075a8d6-094f-4202-abe0-4c02b7a5a8e6_PROST_920b9d76-bc23-467b-a3c6-2d7b175a8e1a_PDF_','2022-01-20 19:45:48','2022-01-20 20:45:47','6_w1_couronne_prost_file_69031f67-5df5-4275-9366-6c75582ef750_0.pdf','2022-01-20 20:45:48','SYNCED','69031f67-5df5-4275-9366-6c75582ef750',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.6.1.1 COURONNE\",\"title\":\"Couronne PDF\"}'),(1001,'6974ab95-46cb-426f-8746-1817174fc5bf','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3ed7a8e0-5b4d-4ecf-b4ae-f855b16c0f93/session_fb42cec6-0bb6-41e9-912d-0517ff8e0942/occlusion_fb214b2f-5e41-492d-85c4-d4a11a3947c5/scan_c3e17d3f-dc98-4f9a-8f77-01641069f720/42_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_3ed7a8e0-5b4d-4ecf-b4ae-f855b16c0f93_ACT_fb42cec6-0bb6-41e9-912d-0517ff8e0942_SESS_fb214b2f-5e41-492d-85c4-d4a11a3947c5_RISC_c3e17d3f-dc98-4f9a-8f77-01641069f720_SNAPS_','2022-10-07 11:54:47','2022-10-07 13:54:39','42_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-10-07 13:54:47','SYNCED','6974ab95-46cb-426f-8746-1817174fc5bf',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.42.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'697b7f82-bb89-492f-b79f-63826892538f','','LIFI','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_TOSC_0136d883-d517-448a-82a3-bfcdd5f4c35c_LIFI_','2022-07-19 13:44:35','2022-07-19 14:28:21','','2022-07-19 15:44:35','SYNCED','697b7f82-bb89-492f-b79f-63826892538f',0,'2022-07-19 15:44:35','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.38.1.1.1 Ligne de finition 0\",\"name\":\"Ligne de finition 0\",\"title\":\"Maxillaire LIFI\",\"toothNumber\":0,\"versionMarginLine\":1}'),(1001,'69a8428e-386d-4f89-953d-72fb9eeaee3f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_af1a113d-a181-4a3b-8ed8-44cff2f8fe53/24_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_LESC_af1a113d-a181-4a3b-8ed8-44cff2f8fe53_ZIP_','2022-05-24 14:48:50','2022-05-24 16:48:43','24_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-05-24 16:48:50','SYNCED','69a8428e-386d-4f89-953d-72fb9eeaee3f',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.24.1.1.4\",\"modelMatrix\":\"-0.985409,-0.126722,0.12268,0,0.122972,-0.991323,0.0219164,0,0.117897,0.0357085,0.992207,0,-7.36216,-1.4312,-17.9903,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'69ad61a1-bbd5-4415-a55b-c7c378bdf30e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/occlusion_e08bbeeb-a30b-428c-bd4a-40198f792219/scan_ef1d20c7-5f61-4c35-8f0f-d85507cab786/25_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_SESS_e08bbeeb-a30b-428c-bd4a-40198f792219_BOSC_ef1d20c7-5f61-4c35-8f0f-d85507cab786_ZIP_','2022-05-17 16:11:04','2022-05-17 18:10:54','25_w1_o1_mandibule_scan_file_0.zip','2022-05-17 18:11:04','SYNCED','69ad61a1-bbd5-4415-a55b-c7c378bdf30e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.25.1.1.1\",\"modelMatrix\":\"0.987554,-0.156623,0.0143947,0,0.157283,0.983409,-0.0903818,0,-2.60027e-10,0.0915209,0.995803,0,-0.804564,-4.57332,-21.3253,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'69c9ccea-1877-446a-8d1a-7547bfd4f16e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3cc1b522-8e7d-4196-87a1-a8c234f0a399/session_ef503949-33e8-4db6-bbfa-456bd8b70b73/occlusion_e8e2758f-faa4-4db7-93df-e94ddfbd8284/scan_5fef43a3-69e9-4c2c-be04-0f92eb1f6b80/51_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_3cc1b522-8e7d-4196-87a1-a8c234f0a399_ACT_ef503949-33e8-4db6-bbfa-456bd8b70b73_SESS_e8e2758f-faa4-4db7-93df-e94ddfbd8284_RISC_5fef43a3-69e9-4c2c-be04-0f92eb1f6b80_ZIP_','2022-11-28 17:01:41','2022-11-28 18:01:34','51_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-11-28 18:01:41','SYNCED','69c9ccea-1877-446a-8d1a-7547bfd4f16e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.51.1.1.1\",\"modelMatrix\":\"0.988349,0.0178057,0.150029,0,-0.00372091,0.995269,-0.098841,0,-0.152165,0.0955298,0.983731,0,-10.0851,-3.31119,-22.8899,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'69e26dc2-cd36-4482-bdd3-656e011afd54','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_44561518-16e3-45bd-af90-fefe4eca9d27/24_w1_o1_mordu_posterieur_gauche_scan_file_2.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_LESC_44561518-16e3-45bd-af90-fefe4eca9d27_ZIP_','2022-06-14 11:57:30','2022-06-14 13:57:24','24_w1_o1_mordu_posterieur_gauche_scan_file_2.zip','2022-06-14 13:57:30','SYNCED','8e3b2146-f0cf-465d-9fe3-fdbb0b0d4d1e',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.24.1.1.8\",\"modelMatrix\":\"0.998505,0.0288376,0.0356512,0,-0.0392148,0.994627,0.101591,0,-0.0393194,-0.099669,0.99422,0,9.20621,7.03609,-15.1186,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'6a291473-6bc6-401e-8fb7-01a4524ebec6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_77ec818f-d778-4945-9458-90665b5522ba/17_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_TOSC_77ec818f-d778-4945-9458-90665b5522ba_ZIP_','2022-02-07 11:25:29','2022-02-07 12:23:53','17_w1_o1_maxillaire_scan_file_0.zip','2022-02-07 12:25:29','SYNCED','6a291473-6bc6-401e-8fb7-01a4524ebec6',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.17.1.1.1\",\"modelMatrix\":\"0.181283,0.917783,-0.353285,0,-0.983431,0.169181,-0.0651236,0,3.73031e-9,0.359238,0.933246,0,-25.409,-29.3409,-13.62,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'6a7c327b-919b-43af-9cea-a2ff628c91c8','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_d87d63d7-4507-4391-b749-4b160c9363ed/12_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_d87d63d7-4507-4391-b749-4b160c9363ed_SNAPS_','2022-01-27 12:07:55','2022-01-27 13:07:39','12_w1_o1_mandibule_snapshot_0.png','2022-01-27 13:07:55','SYNCED','6a7c327b-919b-43af-9cea-a2ff628c91c8',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'6acab9c1-fd86-4b22-a28b-e83dbe7f0bf2','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_14264009-2f96-4841-9c75-17adb3424f9f/18_w1_o1_mordu_anterieur_scan_file_0.zip','ZIP','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_FRSC_14264009-2f96-4841-9c75-17adb3424f9f_ZIP_','2022-03-07 14:35:30','2022-03-07 15:35:21','18_w1_o1_mordu_anterieur_scan_file_0.zip','2022-03-07 15:35:30','SYNCED','6acab9c1-fd86-4b22-a28b-e83dbe7f0bf2',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.18.1.1.1\",\"modelMatrix\":\"0.984075,-0.0589972,0.176695,0,0.0739748,0.992259,-0.124267,0,-0.161791,0.111986,0.976715,0,0.555039,-6.34584,-20.5488,1\",\"title\":\"Mordu anterieur ZIP\"}'),(1001,'6ad1749f-c063-4da8-8e6c-523b8c92cd1d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3ed7a8e0-5b4d-4ecf-b4ae-f855b16c0f93/session_fb42cec6-0bb6-41e9-912d-0517ff8e0942/occlusion_fb214b2f-5e41-492d-85c4-d4a11a3947c5/computedocclusion_8c8e81cc-f99d-4235-9ccb-11954c645cad/42_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_3ed7a8e0-5b4d-4ecf-b4ae-f855b16c0f93_ACT_fb42cec6-0bb6-41e9-912d-0517ff8e0942_SESS_fb214b2f-5e41-492d-85c4-d4a11a3947c5_OCC_8c8e81cc-f99d-4235-9ccb-11954c645cad_BOMA__MATRX_','2022-10-07 17:32:25','2022-10-07 19:31:47','42_w1_o1_mandibule_matrix_occ_file_0.m','2022-10-07 19:32:25','SYNCED','6ad1749f-c063-4da8-8e6c-523b8c92cd1d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.42.1.1.1 Occlusion 4\",\"referenceScanID\":\"1.42.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.42.1.1.1 Occlusion 4\"}'),(1001,'6b090bc7-5f6e-4e97-a38a-63ef40edfbd3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/75ce481f-6c44-4d16-a477-ea40c4fa6022/session_9bf7b056-ca4f-4dab-937b-619d0eb20528/occlusion_d7580529-3ede-4e27-a2ae-01849ba4d397/scan_ead7bba4-f70a-466e-948c-a630d4da7a7a/55_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_75ce481f-6c44-4d16-a477-ea40c4fa6022_ACT_9bf7b056-ca4f-4dab-937b-619d0eb20528_SESS_d7580529-3ede-4e27-a2ae-01849ba4d397_TOSC_ead7bba4-f70a-466e-948c-a630d4da7a7a_SNAPS_','2022-12-22 10:10:12','2022-12-22 11:09:58','55_w1_o1_maxillaire_snapshot_0.png','2022-12-22 11:10:12','SYNCED','6b090bc7-5f6e-4e97-a38a-63ef40edfbd3',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.55.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'6b4e9480-26b4-4d05-b592-372c05f53a4e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/d100e894-0be9-4495-94e2-e469232f7817/session_2c8b85b5-c805-4b08-85e7-3d02dab72e99/occlusion_8a278cc5-a1c1-4dfb-9ee2-c971a6309afa/scan_b1a27ca1-b17d-4071-99c1-940f9efedb70/15_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_d100e894-0be9-4495-94e2-e469232f7817_ACT_2c8b85b5-c805-4b08-85e7-3d02dab72e99_SESS_8a278cc5-a1c1-4dfb-9ee2-c971a6309afa_RISC_b1a27ca1-b17d-4071-99c1-940f9efedb70_SNAPS_','2022-02-01 15:11:23','2022-02-01 16:11:12','15_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-02-01 16:11:23','SYNCED','6b4e9480-26b4-4d05-b592-372c05f53a4e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.15.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'6b4f02ea-c57e-40cc-a471-e0a4dd200fcd','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/computedocclusion_35af1bf5-285a-4bb1-a6db-fe9897defe51/23_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_35af1bf5-285a-4bb1-a6db-fe9897defe51_SNAPO__SNAPS_','2022-05-13 12:11:30','2022-05-13 14:11:07','23_w1_o1_snapshot_occ_file_0.png','2022-05-13 14:11:30','SYNCED','6b4f02ea-c57e-40cc-a471-e0a4dd200fcd',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'6b9eecc3-635f-4c15-8609-cf0c4f6d6dae','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/computedocclusion_864c98a3-fcf7-466a-b999-13bd4dfb8c65/23_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_864c98a3-fcf7-466a-b999-13bd4dfb8c65_SNAPO__SNAPS_','2022-05-13 11:31:02','2022-05-13 13:30:43','23_w1_o1_snapshot_occ_file_0.png','2022-05-13 13:31:02','SYNCED','6b9eecc3-635f-4c15-8609-cf0c4f6d6dae',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'6ba1ffaa-7f81-420c-bdc5-28b53161c4f3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_2ffbfbca-f236-4802-be93-8eb43d523274/scan_6313fe60-344e-44c5-9805-fd1382bb983f/4_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_2ffbfbca-f236-4802-be93-8eb43d523274_LESC_6313fe60-344e-44c5-9805-fd1382bb983f_ZIP_','2022-01-19 19:08:56','2022-01-19 20:08:48','4_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-01-19 20:08:56','SYNCED','6ba1ffaa-7f81-420c-bdc5-28b53161c4f3',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.4.1.1.1\",\"modelMatrix\":\"-0.888388,0.450171,0.0688823,0,-0.45893,-0.884246,-0.102551,0,0.0130484,-0.124404,0.992342,0,-6.81792,15.0877,-17.8786,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'6bb63a3b-8000-4f0c-89f0-23596bbf5507','','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_OCC_d8bec5dc-8405-473d-9ba5-ae6e461ed6fd_TOPLY__ZIP_','2022-02-04 18:14:41','2022-02-04 19:13:44','',NULL,'CREATED','6bb63a3b-8000-4f0c-89f0-23596bbf5507',0,'2022-02-04 19:14:41','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.13.1.1.3 Occlusion 1\",\"modelMatrix\":\"0.754335,0.643596,-0.129474,0,-0.65649,0.739519,-0.148771,0,2.61688e-9,0.197222,0.980359,0,-9.25272,-30.1421,-17.7968,1\",\"referenceScanID\":\"1.13.1.1.3\",\"title\":\"Maxillaire 1.13.1.1.3 Occlusion 1\"}'),(1001,'6bc7e08a-0082-4460-9fa9-8c680f43839c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/69640c87-271c-4a44-a6fa-67b01654cc27/session_5f9199b0-eb37-4ed3-8d1a-6c38505d4913/occlusion_991beec3-fe9e-4c98-a3d4-c98e4a4c2471/scan_1ff80dd9-2d47-4292-adde-0923cb6fe572/39_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_FRSC_1ff80dd9-2d47-4292-adde-0923cb6fe572_SNAPS_','2022-09-09 16:25:08','2022-09-09 18:25:01','39_w1_o1_mordu_anterieur_snapshot_0.png','2022-09-09 18:25:08','SYNCED','6bc7e08a-0082-4460-9fa9-8c680f43839c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.39.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'6bef7307-6041-4583-80e6-174b322938f2','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/3a170256-4132-4b56-ad27-b2cc7790bbf8/session_c57164ce-3f15-42b7-a8dc-96ab6a136184/occlusion_4779508f-bef4-4a89-9555-58b917369f06/scan_efe707fb-c25b-4c26-9f34-5c9796ec4755/62_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_3a170256-4132-4b56-ad27-b2cc7790bbf8_ACT_c57164ce-3f15-42b7-a8dc-96ab6a136184_SESS_4779508f-bef4-4a89-9555-58b917369f06_RISC_efe707fb-c25b-4c26-9f34-5c9796ec4755_SNAPS_','2023-03-13 09:51:13','2023-03-13 10:50:59','62_w1_o1_mordu_posterieur_droit_snapshot_0.png','2023-03-13 10:51:13','SYNCED','6bef7307-6041-4583-80e6-174b322938f2',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.62.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'6c068fd4-9fc3-4964-b6e1-b872b9490c35','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/986374de-c4d7-4d6f-bf0c-2dc7e3b859a9/session_c81670ed-4144-4347-b19e-8057d11b5f7c/occlusion_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be/computedocclusion_7a5acfd0-87ca-4009-aa4e-677a88ceffde/28_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_986374de-c4d7-4d6f-bf0c-2dc7e3b859a9_ACT_c81670ed-4144-4347-b19e-8057d11b5f7c_SESS_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be_OCC_7a5acfd0-87ca-4009-aa4e-677a88ceffde_BOMA__MATRX_','2022-05-31 10:54:13','2022-05-31 12:53:55','28_w1_o1_mandibule_matrix_occ_file_0.m','2022-05-31 12:54:13','SYNCED','6c068fd4-9fc3-4964-b6e1-b872b9490c35',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.28.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.28.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.28.1.1.1 Occlusion 1\"}'),(1001,'6c6fd223-601d-4256-8405-c41834d00e44','','LIFIM','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_TOSC_0136d883-d517-448a-82a3-bfcdd5f4c35c_LIFIM_','2022-07-19 13:44:35','2022-07-19 14:28:21','','2022-07-19 15:44:35','SYNCED','6c6fd223-601d-4256-8405-c41834d00e44',0,'2022-07-19 15:44:35','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.38.1.1.1 Ligne de finition 0\",\"name\":\"Ligne de finition 0\",\"title\":\"Maxillaire LIFI_META\",\"toothNumber\":0,\"versionMarginLine\":1}'),(1001,'6c76bb80-76df-4010-a738-de9fd2f31989','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f9d03016-567a-4bd4-9cc5-dafeea34e365/session_a7bcb190-dd19-4f3b-8aab-266030bf4064/occlusion_c321e210-b67c-40e8-bece-f8946164a768/computedocclusion_03fe87bc-2a25-4d16-a476-2df62bb3cf76/36_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_f9d03016-567a-4bd4-9cc5-dafeea34e365_ACT_a7bcb190-dd19-4f3b-8aab-266030bf4064_SESS_c321e210-b67c-40e8-bece-f8946164a768_OCC_03fe87bc-2a25-4d16-a476-2df62bb3cf76_SNAPO__SNAPS_','2022-07-04 14:14:03','2022-07-04 16:13:45','36_w1_o1_snapshot_occ_file_0.png','2022-07-04 16:14:03','SYNCED','6c76bb80-76df-4010-a738-de9fd2f31989',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'6cb58ceb-84fb-4e3c-b51f-6899bf3415cf','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5a33a64b-822d-40bf-ba8c-e11c11a50f88/session_e0a7776f-79fe-4c85-85ab-9ca244e7ff95/occlusion_b3568df2-4c54-486e-b27f-2d92375e5d11/scan_9d41d296-c093-413a-a969-5832498f8c39/43_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_5a33a64b-822d-40bf-ba8c-e11c11a50f88_ACT_e0a7776f-79fe-4c85-85ab-9ca244e7ff95_SESS_b3568df2-4c54-486e-b27f-2d92375e5d11_TOSC_9d41d296-c093-413a-a969-5832498f8c39_ZIP_','2022-10-11 14:10:10','2022-10-11 16:09:57','43_w1_o1_maxillaire_scan_file_0.zip','2022-10-11 16:10:10','SYNCED','6cb58ceb-84fb-4e3c-b51f-6899bf3415cf',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.43.1.1.1\",\"modelMatrix\":\"-0.198645,0.951805,-0.233683,0,-0.980072,-0.192916,0.047364,0,-1.18318e-09,0.238435,0.971158,0,-15.6461,-34.2768,-13.571,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'6cb94e93-83e4-40e4-8ae3-964cb8f6b7a4','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5/occlusion_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa/computedocclusion_4053e29d-7bcb-4280-9a77-c17e5d1256b3/24_w2_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5_SESS_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa_OCC_4053e29d-7bcb-4280-9a77-c17e5d1256b3_TOPLY__ZIP_','2022-10-07 17:17:43','2022-10-07 19:17:23','24_w2_o1_maxillaire_occlusion_occ_file_0.zip','2022-10-07 19:17:43','SYNCED','6cb94e93-83e4-40e4-8ae3-964cb8f6b7a4',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.2.1.1 Occlusion 2\",\"modelMatrix\":\"0.626985,0.76241,-0.160065,0,-0.779032,0.613607,-0.128824,0,4.39427e-09,0.205467,0.978664,0,0.203644,-29.5943,-18.0319,1\",\"referenceScanID\":\"1.24.2.1.1\",\"title\":\"Maxillaire 1.24.2.1.1 Occlusion 2\"}'),(1001,'6d53bd96-2c20-488f-b9c5-69c68f762598','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/occlusion_e08bbeeb-a30b-428c-bd4a-40198f792219/computedocclusion_a503ab26-f707-4923-86b6-049c17f73533/25_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_SESS_e08bbeeb-a30b-428c-bd4a-40198f792219_OCC_a503ab26-f707-4923-86b6-049c17f73533_SNAPO__SNAPS_','2022-05-17 16:40:46','2022-05-17 18:40:25','25_w1_o1_snapshot_occ_file_0.png','2022-05-17 18:40:46','SYNCED','6d53bd96-2c20-488f-b9c5-69c68f762598',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'6d736fe2-1310-4fb3-bde6-77b8f5a985e1','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/fa942554-dda6-4d2d-b578-ae9be6b3904d/session_b6039092-51ba-40dc-86e3-23be741dbb99/occlusion_e6bd34f2-af0e-48a6-9872-ec017a776e77/scan_1c59283c-95f4-431e-8b66-62a243009081/8_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_fa942554-dda6-4d2d-b578-ae9be6b3904d_ACT_b6039092-51ba-40dc-86e3-23be741dbb99_SESS_e6bd34f2-af0e-48a6-9872-ec017a776e77_TOSC_1c59283c-95f4-431e-8b66-62a243009081_ZIP_','2022-01-24 17:23:27','2022-01-24 15:31:00','8_w1_o1_maxillaire_scan_file_0.zip','2022-01-24 18:23:27','SYNCED','6d736fe2-1310-4fb3-bde6-77b8f5a985e1',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.8.1.1.1\",\"modelMatrix\":\"-0.782965,0.61189,-0.112058,0,-0.622066,-0.770157,0.141042,0,-1.63504e-9,0.180138,0.983641,0,9.34468,-28.5555,-17.9359,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'6d7ab355-db18-40f5-a21a-830289e55df4','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/occlusion_a2220645-c79d-4dda-b6cc-772384a4106b/scan_914fba31-85f1-4c6e-85e2-bacfd3c1770c/38_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_TOSC_914fba31-85f1-4c6e-85e2-bacfd3c1770c_ZIP_','2022-07-12 11:04:03','2022-07-12 13:03:55','38_w1_o1_maxillaire_scan_file_0.zip','2022-07-12 13:04:03','SYNCED','6d7ab355-db18-40f5-a21a-830289e55df4',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.38.1.1.3\",\"modelMatrix\":\"0.292113,0.953283,-0.0769574,0,-0.956384,0.291166,-0.0235055,0,3.79853e-10,0.0804671,0.996757,0,-4.50082,-22.5707,-20.6555,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'6dae25df-ce2e-48a8-8501-220d7a313308','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_4f8dc275-857c-482a-9886-5521591e9661/scan_000f859e-bd0c-453b-b60b-dddef781cd58/12_w1_o4_maxillaire_snapshot_0.png','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_TOSC_000f859e-bd0c-453b-b60b-dddef781cd58_SNAPS_','2022-02-14 17:57:22','2022-02-14 18:48:08','12_w1_o4_maxillaire_snapshot_0.png','2022-02-14 18:57:22','SYNCED','6dae25df-ce2e-48a8-8501-220d7a313308',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.12.1.4.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'6dddc0b6-858d-41c2-badc-3eac78bfa8d2','','ZIP','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_TOSC_47ae7109-ac97-4f1b-8dd7-cc22debd4324_ZIP_','2022-07-19 13:56:03','2022-07-19 15:55:49','','2022-07-19 15:56:03','SYNCED','6dddc0b6-858d-41c2-badc-3eac78bfa8d2',0,'2022-07-19 15:56:03','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.38.1.1.4\",\"modelMatrix\":\"-0.298707,0.922945,-0.242789,0,-0.954345,-0.288879,0.0759925,0,9.14042e-10,0.254404,0.967098,0,20.3691,-25.7421,-14.8867,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'6e0bfe0c-593a-4a2e-8782-7f1e18f4d6bd','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/computedocclusion_00405f86-eefa-41f9-8d98-1fa9cbeef855/24_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_00405f86-eefa-41f9-8d98-1fa9cbeef855_TOPLY__ZIP_','2022-05-25 09:03:40','2022-05-25 11:02:54','24_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-05-25 11:03:40','SYNCED','6e0bfe0c-593a-4a2e-8782-7f1e18f4d6bd',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.3 Occlusion 4\",\"modelMatrix\":\"-0.348415,0.927523,-0.135305,0,-0.93734,-0.344766,0.0502937,0,4.16863e-09,0.14435,0.989527,0,-8.01926,-22.8232,-18.3945,1\",\"referenceScanID\":\"1.24.1.1.3\",\"title\":\"Maxillaire 1.24.1.1.3 Occlusion 4\"}'),(1001,'6e5eb213-3b0b-4c68-a8b7-4d44d6e5a4a8','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_f9c2783a-c405-481c-a97e-47bb9db0d0d2/17_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_RISC_f9c2783a-c405-481c-a97e-47bb9db0d0d2_SNAPS_','2022-02-07 11:47:27','2022-02-07 12:42:41','17_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-02-07 12:47:27','SYNCED','6e5eb213-3b0b-4c68-a8b7-4d44d6e5a4a8',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.17.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'6e5f597c-a4b6-42b0-b7fc-80e18211ffe8','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/593972a6-d7d6-4802-b87d-38aab371f71e/session_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480/occlusion_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3/scan_20c281c1-af15-40ce-8892-18a2507513e3/3_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_593972a6-d7d6-4802-b87d-38aab371f71e_ACT_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480_SESS_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3_BOSC_20c281c1-af15-40ce-8892-18a2507513e3_ZIP_','2022-01-19 15:09:22','2022-01-19 16:09:00','3_w1_o1_mandibule_scan_file_0.zip','2022-01-19 16:09:22','SYNCED','6e5f597c-a4b6-42b0-b7fc-80e18211ffe8',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.3.1.1.1\",\"modelMatrix\":\"0.888791,-0.456948,0.035335,0,0.458312,0.886146,-0.0685242,0,1.93169e-9,0.0770982,0.997023,0,-18.6308,-12.394,-21.0367,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'6e9fc174-28d5-42d8-bbc0-dd92bf08bde1','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/e922efb9-8c03-445b-8a0f-449e3c43bdca/session_a2369349-1629-40ad-8784-d271bc3fbade/occlusion_292cc1aa-8b12-463b-87a1-7d9731cf886b/computedocclusion_f9f6d9d2-cc34-43c3-9f5f-4b8e54b41bbb/21_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_e922efb9-8c03-445b-8a0f-449e3c43bdca_ACT_a2369349-1629-40ad-8784-d271bc3fbade_SESS_292cc1aa-8b12-463b-87a1-7d9731cf886b_OCC_f9f6d9d2-cc34-43c3-9f5f-4b8e54b41bbb_BOMA__MATRX_','2022-04-21 08:53:14','2022-04-21 10:53:03','21_w1_o1_mandibule_matrix_occ_file_0.m','2022-04-21 10:53:14','SYNCED','6e9fc174-28d5-42d8-bbc0-dd92bf08bde1',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.21.1.1.1 Occlusion 2\",\"referenceScanID\":\"1.21.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.21.1.1.1 Occlusion 2\"}'),(1001,'6ea47676-7e50-4901-a27e-4e9be929837a','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_ce625ba7-4218-40af-b344-df718da13f83/54_w1_o1_maxillaire_occlusion_occ_file_6.zip','ZIP','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_ce625ba7-4218-40af-b344-df718da13f83_TOPLY__ZIP_','2023-03-15 10:33:24','2023-03-15 11:32:27','54_w1_o1_maxillaire_occlusion_occ_file_6.zip','2023-03-15 11:33:24','SYNCED','ad02dce8-3ff6-4167-add8-6925d6562d5e',6,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.54.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.78238,0.620977,-0.0476379,0,-0.622801,0.780088,-0.059844,0,1.97556e-09,0.0764897,0.99707,0,-23.5433,3.60536,-19.7037,1\",\"referenceScanID\":\"1.54.1.1.1\",\"title\":\"Maxillaire 1.54.1.1.1 Occlusion 1\"}'),(1001,'6ea9e383-3ea1-4941-8ef6-8abaca903e97','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/490e4b04-6edd-4f47-a2ed-232689892eca/session_62105a91-1675-4d36-88bd-34aa8fe2ce3c/occlusion_03784c27-fd8d-4745-9c26-d84c490869b3/scan_396a7286-9ff9-463e-bd50-a344ec153ca3/56_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_490e4b04-6edd-4f47-a2ed-232689892eca_ACT_62105a91-1675-4d36-88bd-34aa8fe2ce3c_SESS_03784c27-fd8d-4745-9c26-d84c490869b3_TOSC_396a7286-9ff9-463e-bd50-a344ec153ca3_SNAPS_','2023-02-17 09:29:53','2023-02-17 10:29:45','56_w1_o1_maxillaire_snapshot_0.png','2023-02-17 10:29:53','SYNCED','6ea9e383-3ea1-4941-8ef6-8abaca903e97',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.56.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'6ed107a2-54c1-4786-af15-8fac44ad82df','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_2ffbfbca-f236-4802-be93-8eb43d523274/scan_0bd54e85-3f0d-4955-9f02-7de656ad9f6f/4_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_2ffbfbca-f236-4802-be93-8eb43d523274_BOSC_0bd54e85-3f0d-4955-9f02-7de656ad9f6f_SNAPS_','2022-01-19 19:08:49','2022-01-19 20:06:56','4_w1_o1_mandibule_snapshot_1.png','2022-01-19 20:08:49','SYNCED','5fb5df68-7218-45fd-ba70-e0699bf168c3',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'6ed13785-759e-4640-96b7-73753d0c8c51','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_7048f93c-1091-4f02-bc64-b73347dfa962/24_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_RISC_7048f93c-1091-4f02-bc64-b73347dfa962_SNAPS_','2022-06-13 15:00:13','2022-06-13 17:00:06','24_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-06-13 17:00:13','SYNCED','6ed13785-759e-4640-96b7-73753d0c8c51',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.24.1.1.3\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'6edb9cce-0310-4291-9dac-49fec98d18b9','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/e922efb9-8c03-445b-8a0f-449e3c43bdca/session_a2369349-1629-40ad-8784-d271bc3fbade/occlusion_292cc1aa-8b12-463b-87a1-7d9731cf886b/scan_500ef012-99d0-4604-93eb-ec789b5a245b/21_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_e922efb9-8c03-445b-8a0f-449e3c43bdca_ACT_a2369349-1629-40ad-8784-d271bc3fbade_SESS_292cc1aa-8b12-463b-87a1-7d9731cf886b_FRSC_500ef012-99d0-4604-93eb-ec789b5a245b_SNAPS_','2022-04-21 08:49:51','2022-04-21 10:49:43','21_w1_o1_mordu_anterieur_snapshot_0.png','2022-04-21 10:49:51','SYNCED','6edb9cce-0310-4291-9dac-49fec98d18b9',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.21.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'6f3fad33-5703-4627-aee6-c2e3c90c18e0','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/ccc47f1d-1705-4945-aa08-da5aa64d251f/session_09e7d062-6ceb-4577-a66e-100bb8dad6d4/occlusion_eb899adb-91e6-4341-90ff-6ebabd7bbe76/scan_30ef0426-9437-4021-b70c-62779b73e0eb/44_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_ccc47f1d-1705-4945-aa08-da5aa64d251f_ACT_09e7d062-6ceb-4577-a66e-100bb8dad6d4_SESS_eb899adb-91e6-4341-90ff-6ebabd7bbe76_BOSC_30ef0426-9437-4021-b70c-62779b73e0eb_ZIP_','2022-10-18 17:04:30','2022-10-18 19:04:28','44_w1_o1_maxillaire_scan_file_0.zip','2022-10-18 19:04:30','SYNCED','6f3fad33-5703-4627-aee6-c2e3c90c18e0',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.44.1.1.4\",\"modelMatrix\":\"-0.955362,-0.284213,0.0806551,0,0.295436,-0.919071,0.260817,0,-1.31391e-09,0.273004,0.962013,0,5.48815,-13.59,-19.5533,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'6f443a61-eeb4-44be-bfc5-ee4485048d0a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3cc1b522-8e7d-4196-87a1-a8c234f0a399/session_ef503949-33e8-4db6-bbfa-456bd8b70b73/occlusion_e8e2758f-faa4-4db7-93df-e94ddfbd8284/scan_faa0b909-907b-4833-9e89-c2e8eec90e95/51_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_3cc1b522-8e7d-4196-87a1-a8c234f0a399_ACT_ef503949-33e8-4db6-bbfa-456bd8b70b73_SESS_e8e2758f-faa4-4db7-93df-e94ddfbd8284_RISC_faa0b909-907b-4833-9e89-c2e8eec90e95_ZIP_','2022-11-28 17:08:35','2022-11-28 18:08:28','51_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-11-28 18:08:35','SYNCED','6f443a61-eeb4-44be-bfc5-ee4485048d0a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.51.1.1.2\",\"modelMatrix\":\"0.996888,0.00970904,0.0754564,0,-0.0131565,0.99933,-0.0369956,0,-0.0780063,0.035836,0.996465,0,-5.8334,0.275944,-18.8739,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'6f4c2c37-2063-47e9-9b81-2912e4b09097','','SNAPS','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_c9079d19-8ffb-46f7-a51e-3a7a90ccae59_SESS_8ba0f3b1-408f-4a02-92a0-63f09123b68e_BOSC_30b22823-10be-472c-b053-59b470998f02_SNAPS_','2022-01-28 17:15:44','2022-01-25 13:06:26','','2022-01-28 18:15:44','SYNCED','6f4c2c37-2063-47e9-9b81-2912e4b09097',0,'2022-01-28 18:15:44','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.10.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'6f5add67-1bbf-40d4-9310-3952928c43c9','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3ed7a8e0-5b4d-4ecf-b4ae-f855b16c0f93/session_fb42cec6-0bb6-41e9-912d-0517ff8e0942/occlusion_fb214b2f-5e41-492d-85c4-d4a11a3947c5/computedocclusion_8c8e81cc-f99d-4235-9ccb-11954c645cad/42_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_3ed7a8e0-5b4d-4ecf-b4ae-f855b16c0f93_ACT_fb42cec6-0bb6-41e9-912d-0517ff8e0942_SESS_fb214b2f-5e41-492d-85c4-d4a11a3947c5_OCC_8c8e81cc-f99d-4235-9ccb-11954c645cad_TOPLY__ZIP_','2022-10-07 17:32:25','2022-10-07 19:31:47','42_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-10-07 19:32:25','SYNCED','6f5add67-1bbf-40d4-9310-3952928c43c9',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.42.1.1.1 Occlusion 4\",\"modelMatrix\":\"-0.20917,0.954234,-0.213743,0,-0.977879,-0.204112,0.0457199,0,-2.38677e-09,0.218578,0.97582,0,-7.51486,-31.7634,-17.5389,1\",\"referenceScanID\":\"1.42.1.1.1\",\"title\":\"Maxillaire 1.42.1.1.1 Occlusion 4\"}'),(1001,'6f6a9b2c-99a5-4c89-9435-60646732a096','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/1c189ddc-0ee7-45e7-9d80-585dac08374a/session_01bd0635-6ec6-42cb-8561-8638bded352c/occlusion_2aa712ca-8b46-4a50-a03e-1c6a6a0c40fc/computedocclusion_727485e0-8637-4024-83d8-95544991f73f/29_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_1c189ddc-0ee7-45e7-9d80-585dac08374a_ACT_01bd0635-6ec6-42cb-8561-8638bded352c_SESS_2aa712ca-8b46-4a50-a03e-1c6a6a0c40fc_OCC_727485e0-8637-4024-83d8-95544991f73f_TOPLY__ZIP_','2022-06-03 14:07:17','2022-06-03 16:07:00','29_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-06-03 16:07:17','SYNCED','6f6a9b2c-99a5-4c89-9435-60646732a096',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.29.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.83472,0.522,-0.175383,0,-0.550675,0.791254,-0.265848,0,9.28981e-09,0.318487,0.947927,0,-14.455,-20.1962,-17.5787,1\",\"referenceScanID\":\"1.29.1.1.1\",\"title\":\"Maxillaire 1.29.1.1.1 Occlusion 1\"}'),(1001,'6fa5ad33-3773-4801-9f0b-ed36985cc55e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/533d4409-e39d-4a27-a0af-b59e6cf76ce3/session_319a8f1d-33fc-4f87-a108-b3eabda0510f/occlusion_3b38f07b-42cb-40b1-933f-365e568702e4/scan_109ca2c4-8222-4d02-9ac7-b4b93937e1e2/37_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_533d4409-e39d-4a27-a0af-b59e6cf76ce3_ACT_319a8f1d-33fc-4f87-a108-b3eabda0510f_SESS_3b38f07b-42cb-40b1-933f-365e568702e4_TOSC_109ca2c4-8222-4d02-9ac7-b4b93937e1e2_SNAPS_','2022-07-07 15:42:22','2022-07-07 17:42:09','37_w1_o1_maxillaire_snapshot_0.png','2022-07-07 17:42:22','SYNCED','6fa5ad33-3773-4801-9f0b-ed36985cc55e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.37.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'6fc1ad7b-72f9-4540-9e11-3ded800f23dc','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_04d6e3f1-19ce-4851-a9d0-40419cea7542/scan_fef6f617-40e8-4052-8a2d-9af9e39ab22d/19_w1_o2_mandibule_scan_file_0.zip','ZIP','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_04d6e3f1-19ce-4851-a9d0-40419cea7542_BOSC_fef6f617-40e8-4052-8a2d-9af9e39ab22d_ZIP_','2022-04-15 13:53:56','2022-04-15 15:53:47','19_w1_o2_mandibule_scan_file_0.zip','2022-04-15 15:53:56','SYNCED','6fc1ad7b-72f9-4540-9e11-3ded800f23dc',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.2.2\",\"modelMatrix\":\"0.985295,0.161582,-0.0555372,0,-0.17086,0.931792,-0.320266,0,1.66291e-09,0.325046,0.945698,0,4.81481,0.667092,-28.1591,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'701053d2-5dcc-443f-b666-c76eaf06528b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/de078619-3946-4adb-a799-1c260e16face/session_24d0aeb5-3058-4070-aeea-97c289e41e3c/occlusion_ea6da896-1504-41fc-890c-7c48575e9e40/scan_e7e54c23-0fb4-457b-aa49-43078736514f/2_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_de078619-3946-4adb-a799-1c260e16face_ACT_24d0aeb5-3058-4070-aeea-97c289e41e3c_SESS_ea6da896-1504-41fc-890c-7c48575e9e40_FRSC_e7e54c23-0fb4-457b-aa49-43078736514f_SNAPS_','2022-01-19 14:46:11','2022-01-19 15:45:59','2_w1_o1_mordu_anterieur_snapshot_0.png','2022-01-19 15:46:11','SYNCED','701053d2-5dcc-443f-b666-c76eaf06528b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.2.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'7033216f-6fae-4a9f-a27c-a4df8e40a06c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/d100e894-0be9-4495-94e2-e469232f7817/session_2c8b85b5-c805-4b08-85e7-3d02dab72e99/occlusion_8a278cc5-a1c1-4dfb-9ee2-c971a6309afa/scan_061005ca-b3b4-4cb2-bf80-5bae7b8fc987/15_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_d100e894-0be9-4495-94e2-e469232f7817_ACT_2c8b85b5-c805-4b08-85e7-3d02dab72e99_SESS_8a278cc5-a1c1-4dfb-9ee2-c971a6309afa_TOSC_061005ca-b3b4-4cb2-bf80-5bae7b8fc987_ZIP_','2022-02-01 15:15:50','2022-02-01 16:15:48','15_w1_o1_mandibule_scan_file_0.zip','2022-02-01 16:15:50','SYNCED','7033216f-6fae-4a9f-a27c-a4df8e40a06c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.15.1.1.1\",\"modelMatrix\":\"0.727689,0.636405,-0.255846,0,-0.685907,0.675172,-0.271431,0,1.4085e-8,0.373004,0.92783,0,-4.62287,-39.5325,-13.5601,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'707cc62e-7061-456a-8160-495b8b08c922','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_2ffbfbca-f236-4802-be93-8eb43d523274/scan_0bd54e85-3f0d-4955-9f02-7de656ad9f6f/4_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_2ffbfbca-f236-4802-be93-8eb43d523274_BOSC_0bd54e85-3f0d-4955-9f02-7de656ad9f6f_ZIP_','2022-01-19 19:08:46','2022-01-19 20:06:58','4_w1_o1_mandibule_scan_file_1.zip','2022-01-19 20:08:46','SYNCED','3d3712b8-d105-4369-a45d-93e76bd3c1f4',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.1.1\",\"modelMatrix\":\"-0.761239,0.619606,-0.191322,0,-0.648472,-0.727353,0.224592,0,-2.36675e-9,0.295035,0.955486,0,12.5557,-2.69168,-18.0113,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'70b5974b-73f4-4b7d-a247-890b7852597b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/d100e894-0be9-4495-94e2-e469232f7817/session_2c8b85b5-c805-4b08-85e7-3d02dab72e99/occlusion_8a278cc5-a1c1-4dfb-9ee2-c971a6309afa/scan_061005ca-b3b4-4cb2-bf80-5bae7b8fc987/15_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_d100e894-0be9-4495-94e2-e469232f7817_ACT_2c8b85b5-c805-4b08-85e7-3d02dab72e99_SESS_8a278cc5-a1c1-4dfb-9ee2-c971a6309afa_TOSC_061005ca-b3b4-4cb2-bf80-5bae7b8fc987_ZIP_','2022-02-01 15:16:31','2022-02-01 16:15:48','15_w1_o1_maxillaire_scan_file_1.zip','2022-02-01 16:16:31','SYNCED','7033216f-6fae-4a9f-a27c-a4df8e40a06c',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.15.1.1.1\",\"modelMatrix\":\"0.727689,0.636405,-0.255846,0,-0.685907,0.675172,-0.271431,0,1.4085e-8,0.373004,0.92783,0,-4.62287,-39.5325,-13.5601,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'71025541-ae2b-4806-8961-2faf3306885e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/scan_7b00996b-90f8-4307-9a8c-263a28f1b341/4_w1_o4_maxillaire_snapshot_2.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_TOSC_7b00996b-90f8-4307-9a8c-263a28f1b341_SNAPS_','2022-05-31 12:03:36','2022-05-31 13:55:41','4_w1_o4_maxillaire_snapshot_2.png','2022-05-31 14:03:36','SYNCED','68a7881a-ea83-4e50-b8af-b28454591c34',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.4.1.4.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'7161a896-678c-49ce-a8db-989109953ffa','','ZIP','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_c9079d19-8ffb-46f7-a51e-3a7a90ccae59_SESS_8ba0f3b1-408f-4a02-92a0-63f09123b68e_TOSC_cf1df2e4-52f9-48a2-8e0b-54a1e4ed5741_ZIP_','2022-01-28 17:15:44','2022-01-26 15:40:40','','2022-01-28 18:15:44','SYNCED','7161a896-678c-49ce-a8db-989109953ffa',0,'2022-01-28 18:15:44','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.10.1.1.1\",\"modelMatrix\":\"0.588218,0.770346,-0.246102,0,-0.808703,0.560319,-0.179005,0,-8.9354e-9,0.304318,0.952571,0,-34.3596,-30.1664,-22.2111,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'71a2825f-f78b-4482-8e0d-c6100f1cdb56','','SNAPS','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_LESC_273e24bd-58e9-4983-8fdc-d9f60e8e0de7_SNAPS_','2022-09-09 16:40:53','2022-09-09 18:33:56','','2022-09-09 18:40:53','SYNCED','71a2825f-f78b-4482-8e0d-c6100f1cdb56',0,'2022-09-09 18:40:53','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.39.1.1.6\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'71ce59d2-c248-4631-93f9-1335cd3337ca','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/4a3954e0-1e2f-4721-9fdd-4180380dc19f/session_33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416/occlusion_3accbada-5a51-4d10-88d1-c3e7d8598d6f/scan_ca26b24d-fb66-43e1-8719-cc661811d143/34_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_4a3954e0-1e2f-4721-9fdd-4180380dc19f_ACT_33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416_SESS_3accbada-5a51-4d10-88d1-c3e7d8598d6f_BOSC_ca26b24d-fb66-43e1-8719-cc661811d143_SNAPS_','2022-06-28 10:49:58','2022-06-28 12:49:35','34_w1_o1_mandibule_snapshot_0.png','2022-06-28 12:49:58','SYNCED','71ce59d2-c248-4631-93f9-1335cd3337ca',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.34.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'71d2bbfb-3fa6-4836-a72d-8509a8c942a5','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/45ff7437-0691-4427-a7da-8250862e4b96/session_4ff9c682-c09d-42ff-8c29-aeb13e066ed2/occlusion_934673c1-a4b9-4508-ac1b-a03092a0693e/scan_8d7fa4fe-ab8d-4b70-b921-fabf93cf9f25/9_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_45ff7437-0691-4427-a7da-8250862e4b96_ACT_4ff9c682-c09d-42ff-8c29-aeb13e066ed2_SESS_934673c1-a4b9-4508-ac1b-a03092a0693e_RISC_8d7fa4fe-ab8d-4b70-b921-fabf93cf9f25_ZIP_','2022-01-24 17:46:37','2022-01-24 18:45:22','9_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-01-24 18:46:37','SYNCED','71d2bbfb-3fa6-4836-a72d-8509a8c942a5',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.9.1.1.1\",\"modelMatrix\":\"0.826976,-0.148071,0.532511,0,0.10609,0.988222,0.10819,0,-0.552279,-0.0391122,0.839577,0,-10.1803,17.2042,-30.0662,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'7210d8cd-3a05-4560-b55f-80951c90c08c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/computedocclusion_d5bff097-1085-4c55-afe3-1ce57126d88f/19_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_OCC_d5bff097-1085-4c55-afe3-1ce57126d88f_TOMA__MATRX_','2022-03-08 11:16:25','2022-03-08 12:15:58','19_w1_o1_maxillaire_matrix_occ_file_0.m','2022-03-08 12:16:25','SYNCED','7210d8cd-3a05-4560-b55f-80951c90c08c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.19.1.1.1 Occlusion 2\",\"referenceScanID\":\"1.19.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.19.1.1.1 Occlusion 2\"}'),(1001,'72226bb6-e398-4d1a-8cab-cf476af66ce4','','ZIP','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_RISC_ceafbbd6-01e4-4f7a-9d71-a337153d555a_ZIP_','2022-04-21 17:37:46','2022-04-21 13:10:25','','2022-04-21 19:37:46','SYNCED','72226bb6-e398-4d1a-8cab-cf476af66ce4',0,'2022-04-21 19:37:46','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.22.1.1.1\",\"modelMatrix\":\"0.993112,-0.0138798,-0.115616,0,0.00933857,0.999845,-0.0107109,0,0.116842,0.0114836,0.99324,0,1.35324,-2.01758,-16.5083,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'7261116b-75a2-4416-a745-d880100deb03','','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_OCC_4aa37ef9-cd2d-4cfa-9436-a62cc782a27a_BOPLY__ZIP_','2022-02-04 15:01:39','2022-02-04 14:55:02','','2022-02-04 16:01:39','SYNCED','7261116b-75a2-4416-a745-d880100deb03',0,'2022-02-04 16:01:39','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.5 Occlusion 1\",\"modelMatrix\":\"0.821265,-0.551643,0.145651,0,0.570547,0.794053,-0.209655,0,5.91416e-9,0.255283,0.966866,0,-2.59195,32.4156,-27.5972,1\",\"referenceScanID\":\"1.12.1.1.5\",\"title\":\"Mandibule 1.12.1.1.5 Occlusion 1\"}'),(1001,'729cdd5a-8314-463b-bbd8-cea619e1e925','','ZIP','PATIENT_02df4b55-8d30-46ac-b34e-449ffbc4269e_ACT_ef4d16ee-fe39-4081-920a-e42ecf24a857_SESS_d0ba750a-59bf-4ba0-b876-4c1bd25d5677_TOSC_3ac5d21b-7377-44ee-9096-b54f97336106_ZIP_','2022-03-22 07:55:51','2022-03-19 11:45:59','','2022-03-22 08:55:51','SYNCED','729cdd5a-8314-463b-bbd8-cea619e1e925',0,'2022-03-22 08:55:51','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.20.1.1.1\",\"modelMatrix\":\"-0.999974,-0.00712961,0.00050452,0,0.00714744,-0.99748,0.0705857,0,-2.84132e-11,0.0705875,0.997506,0,3.4575,-1.85207,-18.1678,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'73c9cb73-3a98-4256-bc80-f01b135239bd','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_cfcda3c3-749c-4f3d-96e2-556ed558ceef/18_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_TOSC_cfcda3c3-749c-4f3d-96e2-556ed558ceef_ZIP_','2022-03-07 14:03:59','2022-03-07 15:03:44','18_w1_o1_maxillaire_scan_file_0.zip','2022-03-07 15:03:59','SYNCED','73c9cb73-3a98-4256-bc80-f01b135239bd',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.18.1.1.2\",\"modelMatrix\":\"-0.437675,-0.897964,0.0458401,0,0.899133,-0.437106,0.0223138,0,4.2805e-10,0.0509825,0.9987,0,19.3367,8.64495,-23.6403,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'749660e2-55a3-4b7b-8618-0ecb7ace7e8b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/computedocclusion_35af1bf5-285a-4bb1-a6db-fe9897defe51/23_w1_o1_mlmeta_occ_file_to1002.bin','LIFIM','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_35af1bf5-285a-4bb1-a6db-fe9897defe51_LIFIMO_LIFIM_','2022-05-25 10:46:44','2022-05-25 12:46:42','23_w1_o1_mlmeta_occ_file_to1002.bin','2022-05-25 12:46:44','SYNCED','749660e2-55a3-4b7b-8618-0ecb7ace7e8b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.23.1.1.1 Occlusion 4 Ligne de finition 2\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"Maxillaire\",\"name\":\"Ligne de finition 2\",\"title\":\"Ligne finition metadata\",\"toothNumber\":1002}'),(1001,'74b28d88-c271-4aef-ac3b-1c8d372ae615','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7f47fd88-9ea0-4c08-9193-a54d4f158c7c/session_7873a396-419c-4215-83c7-fec9f2742ccf/occlusion_2e287bb0-e19a-414a-9177-23b335d286d9/scan_05d5d943-3268-4239-ac7d-5efbc2d2ab9b/16_w1_o2_maxillaire_scan_file_0.zip','ZIP','PATIENT_7f47fd88-9ea0-4c08-9193-a54d4f158c7c_ACT_7873a396-419c-4215-83c7-fec9f2742ccf_SESS_2e287bb0-e19a-414a-9177-23b335d286d9_TOSC_05d5d943-3268-4239-ac7d-5efbc2d2ab9b_ZIP_','2022-06-03 08:48:48','2022-06-03 10:48:40','16_w1_o2_maxillaire_scan_file_0.zip','2022-06-03 10:48:48','SYNCED','74b28d88-c271-4aef-ac3b-1c8d372ae615',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.16.1.2.1\",\"modelMatrix\":\"-0.661751,0.738844,-0.12726,0,-0.749723,-0.652148,0.112327,0,-3.86758e-09,0.169743,0.985488,0,12.6776,-13.3436,-20.1604,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'74bd34f8-e238-4590-af84-a5ffe916f057','','MATRX','PATIENT_9e399d73-4d2e-4bb8-af48-a4e597811faa_ACT_b1cf14ce-00a9-48b6-8654-dadde26073f1_SESS_3c4595e0-fbbb-4814-8851-1e014eb9a3b2_OCC_96299368-ebcf-4fb9-875d-9bbcfec8ffa0_TOMA__MATRX_','2022-10-27 17:31:09','2022-10-27 19:30:22','','2022-10-27 19:31:09','SYNCED','74bd34f8-e238-4590-af84-a5ffe916f057',0,'2022-10-27 19:31:09','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.46.1.1.1 Occlusion 2\",\"referenceScanID\":\"1.46.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.46.1.1.1 Occlusion 2\"}'),(1001,'74e3f855-5feb-462a-80ec-2a3e46acc509','','SNAPS','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_65f9077d-c859-4b2c-9d4d-692d723315a5_SNAPO__SNAPS_','2022-05-13 12:07:45','2022-05-13 14:07:00','','2022-05-13 14:07:45','SYNCED','74e3f855-5feb-462a-80ec-2a3e46acc509',0,'2022-05-13 14:07:45','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'74e3feba-f624-4451-927e-e5f83d567991','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/scan_2d226451-8adb-4007-be22-99a9b3af61d6/23_w1_o1_maxillaire_mlmeta_2_0.bin','LIFIM','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_TOSC_2d226451-8adb-4007-be22-99a9b3af61d6_LIFIM_','2022-05-25 10:46:43','2022-05-25 12:46:42','23_w1_o1_maxillaire_mlmeta_2_0.bin','2022-05-25 12:46:43','SYNCED','74e3feba-f624-4451-927e-e5f83d567991',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.23.1.1.1 Ligne de finition 2\",\"name\":\"Ligne de finition 2\",\"title\":\"Maxillaire LIFI_META\",\"toothNumber\":2,\"versionMarginLine\":1}'),(1001,'751ef869-ac5e-4de2-8c62-b985199a3d83','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_ce625ba7-4218-40af-b344-df718da13f83/54_w1_o1_snapshot_occ_file_5.png','SNAPS','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_ce625ba7-4218-40af-b344-df718da13f83_SNAPO__SNAPS_','2023-03-15 10:35:07','2023-03-15 11:32:25','54_w1_o1_snapshot_occ_file_5.png','2023-03-15 11:35:07','SYNCED','7646ffac-dba0-4ac0-b4a3-8547134e5318',5,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'7573d58d-2de6-4dec-89dc-7d1280fae1e5','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/372000f2-2471-4a57-9b18-224d0788041f/session_5dd64d24-8e33-45bd-a282-c148c185c338/occlusion_a61fbfda-1ac5-4747-9e0c-6ef664930816/scan_a716cac5-0e02-481c-a14b-3fc981cdeb96/57_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_372000f2-2471-4a57-9b18-224d0788041f_ACT_5dd64d24-8e33-45bd-a282-c148c185c338_SESS_a61fbfda-1ac5-4747-9e0c-6ef664930816_BOSC_a716cac5-0e02-481c-a14b-3fc981cdeb96_SNAPS_','2023-02-17 10:46:00','2023-02-17 11:45:52','57_w1_o1_mandibule_snapshot_1.png','2023-02-17 11:46:00','SYNCED','6234141f-64e4-4942-9db8-4603e56c7d72',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.57.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'7581879e-bdd8-413f-b525-f9cecc54fe29','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/order_37a778ee-af03-4993-a8f5-8ce26e516db0/13_w1_autre_prost_file_7581879e-bdd8-413f-b525-f9cecc54fe29_0.pdf','PDF','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_PROST_37a778ee-af03-4993-a8f5-8ce26e516db0_PDF_','2022-02-04 18:28:44','2022-02-04 19:28:41','13_w1_autre_prost_file_7581879e-bdd8-413f-b525-f9cecc54fe29_0.pdf','2022-02-04 19:28:44','SYNCED','7581879e-bdd8-413f-b525-f9cecc54fe29',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.13.1.1 AUTRE FICHE DE PROTHESE\",\"title\":\"Autre PDF\"}'),(1001,'75ab6534-9048-449f-bd27-86687f417acf','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_72adeb31-f7a3-4840-9f93-f10e61c84bef/4_w1_o2_maxillaire_scan_file_0.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_TOSC_72adeb31-f7a3-4840-9f93-f10e61c84bef_ZIP_','2022-02-15 12:29:42','2022-02-15 13:29:31','4_w1_o2_maxillaire_scan_file_0.zip','2022-02-15 13:29:42','SYNCED','75ab6534-9048-449f-bd27-86687f417acf',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.4.1.2.1\",\"modelMatrix\":\"-0.490235,0.86217,-0.1278,0,-0.871591,-0.484936,0.0718825,0,1.34143e-09,0.146629,0.989192,0,5.4499,-24.2387,-22.3553,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'75bc0b22-b15a-42fa-8cf2-3584942783f6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/de078619-3946-4adb-a799-1c260e16face/session_24d0aeb5-3058-4070-aeea-97c289e41e3c/occlusion_ea6da896-1504-41fc-890c-7c48575e9e40/computedocclusion_a15a6719-2996-4256-93d7-515e4d4f5bef/2_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_de078619-3946-4adb-a799-1c260e16face_ACT_24d0aeb5-3058-4070-aeea-97c289e41e3c_SESS_ea6da896-1504-41fc-890c-7c48575e9e40_OCC_a15a6719-2996-4256-93d7-515e4d4f5bef_TOMA__MATRX_','2022-01-19 14:47:19','2022-01-19 15:46:49','2_w1_o1_maxillaire_matrix_occ_file_0.m','2022-01-19 15:47:19','SYNCED','75bc0b22-b15a-42fa-8cf2-3584942783f6',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.2.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.2.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.2.1.1.1 Occlusion 1\"}'),(1001,'75e9d535-e503-486c-8ceb-2a7cd0b59233','','SNAPS','PATIENT_de078619-3946-4adb-a799-1c260e16face_ACT_24d0aeb5-3058-4070-aeea-97c289e41e3c_SESS_ea6da896-1504-41fc-890c-7c48575e9e40_BOSC_c4bbad69-6205-4593-a0c3-370703a57829_SNAPS_','2022-01-19 17:01:43','2022-01-19 15:26:31','','2022-01-19 18:01:43','SYNCED','75e9d535-e503-486c-8ceb-2a7cd0b59233',0,'2022-01-19 18:01:43','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.2.1.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'75ecadc3-8c76-453d-8277-1a2ae4e32db1','','MATRX','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_OCC_4aa37ef9-cd2d-4cfa-9436-a62cc782a27a_TOMA__MATRX_','2022-02-04 15:01:40','2022-02-04 14:55:02','','2022-02-04 16:01:40','SYNCED','75ecadc3-8c76-453d-8277-1a2ae4e32db1',0,'2022-02-04 16:01:40','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.12.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.12.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.12.1.1.1 Occlusion 1\"}'),(1001,'7636e0d7-f242-431c-90a5-a65399d83ecd','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_2a7068fc-0efa-496f-ade9-aba5b0650655/12_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_2a7068fc-0efa-496f-ade9-aba5b0650655_SNAPS_','2022-02-04 11:45:00','2022-02-04 12:44:46','12_w1_o1_mandibule_snapshot_0.png','2022-02-04 12:45:00','SYNCED','7636e0d7-f242-431c-90a5-a65399d83ecd',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.5\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'7646ffac-dba0-4ac0-b4a3-8547134e5318','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_ce625ba7-4218-40af-b344-df718da13f83/54_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_ce625ba7-4218-40af-b344-df718da13f83_SNAPO__SNAPS_','2022-12-13 09:54:36','2022-12-13 10:54:13','54_w1_o1_snapshot_occ_file_0.png','2022-12-13 10:54:36','SYNCED','7646ffac-dba0-4ac0-b4a3-8547134e5318',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'7654ca8f-01b8-415b-9e19-c4f63283bc46','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/order_d440ce89-b623-4846-8974-44335ef5ecc8/24_w1_autre_prost_file_7654ca8f-01b8-415b-9e19-c4f63283bc46_0.pdf','PDF','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_PROST_d440ce89-b623-4846-8974-44335ef5ecc8_PDF_','2022-06-14 12:09:41','2022-06-14 14:09:39','24_w1_autre_prost_file_7654ca8f-01b8-415b-9e19-c4f63283bc46_0.pdf','2022-06-14 14:09:41','SYNCED','7654ca8f-01b8-415b-9e19-c4f63283bc46',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.24.1.2 AUTRE FICHE DE PROTHESE\",\"title\":\"Autre PDF\"}'),(1001,'76566ef8-b89a-4fea-87e0-c9931b617c2a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_f4b07389-264e-4772-afc3-29b2187ced21/18_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_LESC_f4b07389-264e-4772-afc3-29b2187ced21_ZIP_','2022-03-07 14:43:33','2022-03-07 15:43:32','18_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-03-07 15:43:33','SYNCED','76566ef8-b89a-4fea-87e0-c9931b617c2a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.18.1.1.1\",\"modelMatrix\":\"0.996698,-0.0718327,0.0141172,0,0.0785401,0.984466,0.159169,0,-0.022992,-0.160511,0.987162,0,-0.12545,-0.751174,-18.7896,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'76d25260-1e03-445e-97e6-40a0f4ade327','','MATRX','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_e2722784-a66c-4ece-91c0-2add756415ea_TOMA__MATRX_','2022-05-13 16:32:18','2022-05-13 18:31:42','','2022-05-13 18:32:18','SYNCED','76d25260-1e03-445e-97e6-40a0f4ade327',0,'2022-05-13 18:32:18','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.24.1.1.2 Occlusion 5\",\"referenceScanID\":\"1.24.1.1.2\",\"title\":\"Matrice Transfo. Maxillaire 1.24.1.1.2 Occlusion 5\"}'),(1001,'77111087-863e-4bc1-9206-3fb43c583a59','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/9e399d73-4d2e-4bb8-af48-a4e597811faa/session_b1cf14ce-00a9-48b6-8654-dadde26073f1/occlusion_3c4595e0-fbbb-4814-8851-1e014eb9a3b2/computedocclusion_69c0f244-5ccf-4ce5-aa31-27a50e7c92a0/46_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_9e399d73-4d2e-4bb8-af48-a4e597811faa_ACT_b1cf14ce-00a9-48b6-8654-dadde26073f1_SESS_3c4595e0-fbbb-4814-8851-1e014eb9a3b2_OCC_69c0f244-5ccf-4ce5-aa31-27a50e7c92a0_TOPLY__ZIP_','2022-10-27 17:25:20','2022-10-27 19:24:54','46_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-10-27 19:25:20','SYNCED','77111087-863e-4bc1-9206-3fb43c583a59',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.46.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.197055,0.962993,-0.183884,0,-0.980393,0.193558,-0.0369598,0,-7.5192e-10,0.187561,0.982253,0,-14.46,-22.1585,-21.3006,1\",\"referenceScanID\":\"1.46.1.1.1\",\"title\":\"Maxillaire 1.46.1.1.1 Occlusion 1\"}'),(1001,'7757fade-a1c3-4f58-b5f4-6a8c840a1026','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7f47fd88-9ea0-4c08-9193-a54d4f158c7c/session_7873a396-419c-4215-83c7-fec9f2742ccf/occlusion_2e287bb0-e19a-414a-9177-23b335d286d9/computedocclusion_389a085b-21e0-4004-9d53-dfcb5c4bd2f1/16_w1_o2_snapshot_occ_file_0.png','SNAPS','PATIENT_7f47fd88-9ea0-4c08-9193-a54d4f158c7c_ACT_7873a396-419c-4215-83c7-fec9f2742ccf_SESS_2e287bb0-e19a-414a-9177-23b335d286d9_OCC_389a085b-21e0-4004-9d53-dfcb5c4bd2f1_SNAPO__SNAPS_','2022-06-03 09:04:40','2022-06-03 11:04:23','16_w1_o2_snapshot_occ_file_0.png','2022-06-03 11:04:40','SYNCED','7757fade-a1c3-4f58-b5f4-6a8c840a1026',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'777d7cb7-d27f-4bce-8bf5-a0f676432652','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/ca43bf7b-f931-42fc-bb75-05929e4b6578/session_d9740504-a9ca-472a-83f2-a309fa225a98/occlusion_d663165c-f330-4c61-8d1f-14869b6d5edd/scan_7b6a9df3-3f34-48df-a44e-e6d77507d049/59_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_ca43bf7b-f931-42fc-bb75-05929e4b6578_ACT_d9740504-a9ca-472a-83f2-a309fa225a98_SESS_d663165c-f330-4c61-8d1f-14869b6d5edd_TOSC_7b6a9df3-3f34-48df-a44e-e6d77507d049_ZIP_','2023-03-02 14:59:03','2023-03-02 15:58:55','59_w1_o1_maxillaire_scan_file_1.zip','2023-03-02 15:59:03','SYNCED','f52eb675-fd57-4711-8ca9-d361fe2835b9',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.59.1.1.1\",\"modelMatrix\":\"0.846822,0.512569,-0.142003,0,-0.531876,0.816083,-0.226089,0,-1.19752e-09,0.266985,0.963701,0,-11.9425,-9.62171,-20.3001,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'777edb3b-7fa9-4b96-8362-66c3f7d19d17','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a20364ca-68f6-43af-9d85-5203eb8e7fd3/session_4fbadc34-458e-4383-9cea-ff5422d69287/occlusion_56872db7-25ba-4ec4-a526-b4254011197f/scan_5f4e1975-6e1f-4ec2-98fd-cbe91cc2a66f/49_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_a20364ca-68f6-43af-9d85-5203eb8e7fd3_ACT_4fbadc34-458e-4383-9cea-ff5422d69287_SESS_56872db7-25ba-4ec4-a526-b4254011197f_BOSC_5f4e1975-6e1f-4ec2-98fd-cbe91cc2a66f_ZIP_','2022-10-28 10:19:19','2022-10-28 12:19:09','49_w1_o1_mandibule_scan_file_0.zip','2022-10-28 12:19:19','SYNCED','777edb3b-7fa9-4b96-8362-66c3f7d19d17',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.49.1.1.1\",\"modelMatrix\":\"-0.43711,0.895804,-0.0804302,0,-0.899408,-0.435359,0.0390889,0,3.45282e-09,0.0894257,0.995993,0,17.6848,-11.4701,-19.2736,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'77a65753-09fd-45ea-8312-8effe35d66c0','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/4a3954e0-1e2f-4721-9fdd-4180380dc19f/session_33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416/occlusion_3accbada-5a51-4d10-88d1-c3e7d8598d6f/computedocclusion_5775815f-f076-48af-be27-50e4dbfd3622/34_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_4a3954e0-1e2f-4721-9fdd-4180380dc19f_ACT_33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416_SESS_3accbada-5a51-4d10-88d1-c3e7d8598d6f_OCC_5775815f-f076-48af-be27-50e4dbfd3622_TOMA__MATRX_','2022-06-28 10:56:21','2022-06-28 12:55:54','34_w1_o1_maxillaire_matrix_occ_file_0.m','2022-06-28 12:56:21','SYNCED','77a65753-09fd-45ea-8312-8effe35d66c0',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.34.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.34.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.34.1.1.1 Occlusion 1\"}'),(1001,'784402ca-fe1d-4e66-b557-451567a65f76','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/76279ff4-e4a6-4996-8d4e-c948146544b1/session_8b338ee6-5540-44a5-a587-286a7bfcbe14/occlusion_24569ac1-9195-47ea-beb2-d1d0f5543534/scan_8d33ab62-e242-47c7-aabd-f2419afc2e33/41_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_76279ff4-e4a6-4996-8d4e-c948146544b1_ACT_8b338ee6-5540-44a5-a587-286a7bfcbe14_SESS_24569ac1-9195-47ea-beb2-d1d0f5543534_TOSC_8d33ab62-e242-47c7-aabd-f2419afc2e33_SNAPS_','2022-10-07 10:43:44','2022-10-07 12:43:28','41_w1_o1_maxillaire_snapshot_1.png','2022-10-07 12:43:44','SYNCED','9874ecd8-2c70-4875-b676-418a9914ab9b',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.41.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'78950e09-dd44-4ad7-8aa0-6799130478b6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/computedocclusion_d7643aed-d242-47f6-8e1a-703d4672f109/18_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_OCC_d7643aed-d242-47f6-8e1a-703d4672f109_BOPLY__ZIP_','2022-03-07 14:44:31','2022-03-07 15:44:20','18_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-03-07 15:44:31','SYNCED','78950e09-dd44-4ad7-8aa0-6799130478b6',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.18.1.1.2 Occlusion 2\",\"modelMatrix\":\"0.919793,-0.387127,0.064141,0,0.392404,0.907422,-0.150346,0,2.24171e-09,0.163456,0.986551,0,-1.76441,21.4524,-16.898,1\",\"referenceScanID\":\"1.18.1.1.2\",\"title\":\"Mandibule 1.18.1.1.2 Occlusion 2\"}'),(1001,'78b30e73-697a-4e5e-a78a-f61b56edca9b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/8b4b6de2-edd8-44e6-88c6-8a151914aca6/session_40a1b174-1058-4d27-b63a-4e8f565fb520/occlusion_8eba4eab-4337-436a-8eb6-b59e63415159/scan_3ba099cf-ef99-4ea0-a76b-4d1262455a66/48_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_8b4b6de2-edd8-44e6-88c6-8a151914aca6_ACT_40a1b174-1058-4d27-b63a-4e8f565fb520_SESS_8eba4eab-4337-436a-8eb6-b59e63415159_RISC_3ba099cf-ef99-4ea0-a76b-4d1262455a66_SNAPS_','2022-11-10 10:39:55','2022-11-10 11:39:46','48_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-11-10 11:39:55','SYNCED','78b30e73-697a-4e5e-a78a-f61b56edca9b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.48.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'78ff9d6a-3440-4a6b-9ddd-9624803ae57d','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/490e4b04-6edd-4f47-a2ed-232689892eca/session_62105a91-1675-4d36-88bd-34aa8fe2ce3c/occlusion_03784c27-fd8d-4745-9c26-d84c490869b3/scan_89b022e7-c9b7-4155-aeeb-c65e7e38d330/56_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_490e4b04-6edd-4f47-a2ed-232689892eca_ACT_62105a91-1675-4d36-88bd-34aa8fe2ce3c_SESS_03784c27-fd8d-4745-9c26-d84c490869b3_RISC_89b022e7-c9b7-4155-aeeb-c65e7e38d330_SNAPS_','2023-02-17 09:39:25','2023-02-17 10:37:14','56_w1_o1_mordu_posterieur_droit_snapshot_0.png','2023-02-17 10:39:25','SYNCED','78ff9d6a-3440-4a6b-9ddd-9624803ae57d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.56.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'790aca80-4fa1-460e-aeab-bb9ee832e180','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/4fa1a134-d246-43d7-aa8c-b42e24b62b49/session_6aedf6fd-46d7-4259-88ba-5cf074ad5913/occlusion_47192ebb-25b6-4c9e-a09f-8ed295e60a87/scan_25306a61-fcfc-41ce-8fbc-858e3f355c73/60_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_4fa1a134-d246-43d7-aa8c-b42e24b62b49_ACT_6aedf6fd-46d7-4259-88ba-5cf074ad5913_SESS_47192ebb-25b6-4c9e-a09f-8ed295e60a87_LESC_25306a61-fcfc-41ce-8fbc-858e3f355c73_ZIP_','2023-03-07 18:11:46','2023-03-07 19:11:29','60_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2023-03-07 19:11:46','SYNCED','790aca80-4fa1-460e-aeab-bb9ee832e180',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.60.1.1.1\",\"modelMatrix\":\"-0.921225,-0.216003,0.326248,0,0.183672,-0.976106,-0.0888948,0,0.34315,-0.0275402,0.941165,0,12.8212,12.6114,-24.3826,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(2,'7915052b-1509-4287-8888-c0b5f15b4551','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a4b302c-278d-4e12-ace5-f095ba0bf856/session_6206892a-2e7e-4765-ac90-b49bfb465997/occlusion_3c30231c-7cd7-4431-985b-2eaf7f6925ae/scan_587e0605-ba57-4583-83e9-a1cc32707c91/3_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_587e0605-ba57-4583-83e9-a1cc32707c91_ZIP_','2022-09-06 09:20:35','2022-08-30 10:53:39','3_w1_o1_maxillaire_scan_file_0.zip','2022-09-06 11:20:35','SYNCED','7915052b-1509-4287-8888-c0b5f15b4551',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.3.1.1.4\",\"modelMatrix\":\"0.544914,0.827333,-0.136337,0,-0.838492,0.537663,-0.0886022,0,1.16965e-09,0.162599,0.986692,0,-24.1684,-16.3159,-16.3462,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'797ff92c-f041-4f92-b744-b31285c7e136','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/computedocclusion_b903dd27-411a-4a7c-b357-1cc9a414dbdd/17_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_b903dd27-411a-4a7c-b357-1cc9a414dbdd_BOPLY__ZIP_','2022-02-12 16:54:33','2022-02-12 17:53:18','17_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-02-12 17:54:33','SYNCED','797ff92c-f041-4f92-b744-b31285c7e136',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.17.1.1.2 Occlusion 7\",\"modelMatrix\":\"-0.981109,-0.182585,0.0639297,0,0.193454,-0.925989,0.324223,0,-2.83491e-09,0.330465,0.943818,0,24.0114,15.3472,-21.0981,1\",\"referenceScanID\":\"1.17.1.1.2\",\"title\":\"Mandibule 1.17.1.1.2 Occlusion 7\"}'),(1001,'79944cf3-b4e5-436e-ac4e-af7ee9d2f8d1','','MATRX','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_e2722784-a66c-4ece-91c0-2add756415ea_BOMA__MATRX_','2022-05-13 16:32:18','2022-05-13 18:31:42','','2022-05-13 18:32:18','SYNCED','79944cf3-b4e5-436e-ac4e-af7ee9d2f8d1',0,'2022-05-13 18:32:18','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.24.1.1.1 Occlusion 5\",\"referenceScanID\":\"1.24.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.24.1.1.1 Occlusion 5\"}'),(1001,'79e5e3fd-7e86-4318-a7e3-ac3877c1aeab','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/9e399d73-4d2e-4bb8-af48-a4e597811faa/session_b1cf14ce-00a9-48b6-8654-dadde26073f1/occlusion_1060c95f-48f4-4a37-9b82-03bfd8329730/scan_7887f7ce-288b-4f04-a7cd-7a7c58e2e5f9/46_w1_o2_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_9e399d73-4d2e-4bb8-af48-a4e597811faa_ACT_b1cf14ce-00a9-48b6-8654-dadde26073f1_SESS_1060c95f-48f4-4a37-9b82-03bfd8329730_RISC_7887f7ce-288b-4f04-a7cd-7a7c58e2e5f9_ZIP_','2023-01-20 14:39:09','2023-01-20 15:38:55','46_w1_o2_mordu_posterieur_droit_scan_file_0.zip','2023-01-20 15:39:09','SYNCED','79e5e3fd-7e86-4318-a7e3-ac3877c1aeab',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.46.1.2.1\",\"modelMatrix\":\"0.954775,0.00721595,0.293304,0,0.0312594,0.990466,-0.145818,0,-0.295725,0.138107,0.944915,0,-2.09617,-7.18076,-24.17,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'7a1bc3ae-2bd2-4767-abb5-fe9c2bd23091','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/computedocclusion_77753fb3-75a1-45c2-9191-7a5d98206df2/24_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_77753fb3-75a1-45c2-9191-7a5d98206df2_SNAPO__SNAPS_','2022-06-14 12:07:17','2022-06-14 14:06:33','24_w1_o1_snapshot_occ_file_0.png','2022-06-14 14:07:17','SYNCED','7a1bc3ae-2bd2-4767-abb5-fe9c2bd23091',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'7a404f59-71cc-4f37-9054-92b986bb31bf','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_4f8dc275-857c-482a-9886-5521591e9661/scan_df08df19-150c-437d-8ed4-bf2826644265/12_w1_o4_mandibule_snapshot_2.png','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_BOSC_df08df19-150c-437d-8ed4-bf2826644265_SNAPS_','2022-02-18 16:21:56','2022-02-18 17:21:44','12_w1_o4_mandibule_snapshot_2.png','2022-02-18 17:21:56','SYNCED','e3598e66-59db-43ac-a342-a835944e8fab',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.4.5\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'7a595e00-281d-43ac-9398-931bcff2f9ef','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_ce625ba7-4218-40af-b344-df718da13f83/54_w1_o1_maxillaire_matrix_occ_file_7.m','MATRX','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_ce625ba7-4218-40af-b344-df718da13f83_TOMA__MATRX_','2023-03-15 10:35:06','2023-03-15 11:32:28','54_w1_o1_maxillaire_matrix_occ_file_7.m','2023-03-15 11:35:06','SYNCED','ccf7be44-96c0-48d2-80d6-833cb64e29bc',7,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.54.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.54.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.54.1.1.1 Occlusion 1\"}'),(1001,'7a692e33-2ad7-4ef5-aed9-90e94767f73c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/d100e894-0be9-4495-94e2-e469232f7817/session_2c8b85b5-c805-4b08-85e7-3d02dab72e99/occlusion_8a278cc5-a1c1-4dfb-9ee2-c971a6309afa/scan_aa48ecdd-c861-41de-8796-655dc3852c64/15_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_d100e894-0be9-4495-94e2-e469232f7817_ACT_2c8b85b5-c805-4b08-85e7-3d02dab72e99_SESS_8a278cc5-a1c1-4dfb-9ee2-c971a6309afa_FRSC_aa48ecdd-c861-41de-8796-655dc3852c64_SNAPS_','2022-02-01 15:12:44','2022-02-01 16:12:35','15_w1_o1_mordu_anterieur_snapshot_0.png','2022-02-01 16:12:44','SYNCED','7a692e33-2ad7-4ef5-aed9-90e94767f73c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.15.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'7a6dd0cf-9494-4f37-ab1d-2d816a28bd12','','SNAPS','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_c9079d19-8ffb-46f7-a51e-3a7a90ccae59_SESS_8ba0f3b1-408f-4a02-92a0-63f09123b68e_FRSC_4186a7d8-3050-4b21-ad69-cfd42fea66c5_SNAPS_','2022-01-28 17:15:44','2022-01-27 14:31:23','','2022-01-28 18:15:44','SYNCED','7a6dd0cf-9494-4f37-ab1d-2d816a28bd12',0,'2022-01-28 18:15:44','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.10.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'7a767a56-d808-44ed-af8b-93032cc3c01c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f9d03016-567a-4bd4-9cc5-dafeea34e365/session_a7bcb190-dd19-4f3b-8aab-266030bf4064/occlusion_c321e210-b67c-40e8-bece-f8946164a768/scan_21fc87fa-c767-4333-893a-3f0ab5cd76f2/36_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_f9d03016-567a-4bd4-9cc5-dafeea34e365_ACT_a7bcb190-dd19-4f3b-8aab-266030bf4064_SESS_c321e210-b67c-40e8-bece-f8946164a768_LESC_21fc87fa-c767-4333-893a-3f0ab5cd76f2_ZIP_','2022-07-04 14:12:22','2022-07-04 16:12:15','36_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-07-04 16:12:22','SYNCED','7a767a56-d808-44ed-af8b-93032cc3c01c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.36.1.1.2\",\"modelMatrix\":\"-0.948221,-0.169468,0.273029,0,0.11428,-0.973508,-0.184035,0,0.296364,-0.154065,0.944322,0,10.6477,7.79999,-20.1688,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'7a7c6ba9-78fb-4f22-8f83-8466156a75ac','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/discussion_4d12bcc3-80f2-49dc-9159-54929f160ce6/7a7c6ba9-78fb-4f22-8f83-8466156a75ac.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_426bd908-3163-4291-a697-20eacff771ab_TOPLY__ZIP_','2022-05-25 08:56:22','2022-05-16 19:57:11','7a7c6ba9-78fb-4f22-8f83-8466156a75ac.zip','2022-05-25 10:56:22','SYNCED','7a7c6ba9-78fb-4f22-8f83-8466156a75ac',0,'2022-05-25 10:56:22','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.2 Occlusion 6\",\"modelMatrix\":\"-0.80453,0.576793,-0.141569,0,-0.593912,-0.781339,0.191773,0,-6.05286e-09,0.238367,0.971175,0,0.910551,-5.61768,-25.9513,1\",\"referenceScanID\":\"1.24.1.1.2\",\"title\":\"Maxillaire 1.24.1.1.2 Occlusion 6\"}'),(1001,'7aa382e0-3722-4b51-b555-ca86b2fdea0f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/32710234-804f-46f5-899d-eed636f8a906/session_64c1427a-b91d-4675-94df-f36bd40e9b0f/occlusion_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a/computedocclusion_84d73896-4c7a-4dc0-994a-b2a70e3d1cf2/33_w2_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_32710234-804f-46f5-899d-eed636f8a906_ACT_64c1427a-b91d-4675-94df-f36bd40e9b0f_SESS_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a_OCC_84d73896-4c7a-4dc0-994a-b2a70e3d1cf2_BOMA__MATRX_','2022-06-28 09:07:06','2022-06-28 11:07:03','33_w2_o1_mandibule_matrix_occ_file_0.m','2022-06-28 11:07:06','SYNCED','7aa382e0-3722-4b51-b555-ca86b2fdea0f',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.33.2.1.1 Occlusion 1\",\"referenceScanID\":\"1.33.2.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.33.2.1.1 Occlusion 1\"}'),(1001,'7ab66a9c-a8b0-4143-a71a-8804137212c7','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/7c3827a5-fcb4-4892-bab3-8d6a4e6382f0/session_cb98e8a0-e16d-4640-919e-9b968e57d3db/occlusion_29633526-06c5-413c-8029-9f27d6a28b53/scan_ab6c69b1-8cac-45ec-8fee-f2371813f161/63_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_7c3827a5-fcb4-4892-bab3-8d6a4e6382f0_ACT_cb98e8a0-e16d-4640-919e-9b968e57d3db_SESS_29633526-06c5-413c-8029-9f27d6a28b53_TOSC_ab6c69b1-8cac-45ec-8fee-f2371813f161_ZIP_','2023-03-20 14:30:58','2023-03-20 15:30:28','63_w1_o1_maxillaire_scan_file_0.zip','2023-03-20 15:30:58','SYNCED','7ab66a9c-a8b0-4143-a71a-8804137212c7',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.63.1.1.1\",\"modelMatrix\":\"0.798598,0.563409,-0.211688,0,-0.601865,0.747572,-0.280883,0,-1.99881e-08,0.35172,0.936105,0,-3.91165,-31.3445,-16.3859,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'7acf4ab0-73d8-49c2-9c8f-dba8bbbd8784','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_ce625ba7-4218-40af-b344-df718da13f83/54_w1_o1_maxillaire_occlusion_occ_file_7.zip','ZIP','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_ce625ba7-4218-40af-b344-df718da13f83_TOPLY__ZIP_','2023-03-15 10:34:05','2023-03-15 11:32:28','54_w1_o1_maxillaire_occlusion_occ_file_7.zip','2023-03-15 11:34:05','SYNCED','ad02dce8-3ff6-4167-add8-6925d6562d5e',7,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.54.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.78238,0.620977,-0.0476379,0,-0.622801,0.780088,-0.059844,0,1.97556e-09,0.0764897,0.99707,0,-23.5433,3.60536,-19.7037,1\",\"referenceScanID\":\"1.54.1.1.1\",\"title\":\"Maxillaire 1.54.1.1.1 Occlusion 1\"}'),(1001,'7acff767-8dc0-4bd7-9333-8187e6479927','','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_cb4cdc08-5d89-48dc-80a3-2e659c55f971_BOPLY__ZIP_','2022-02-08 08:49:00','2022-02-07 18:52:17','','2022-02-08 09:49:00','SYNCED','7acff767-8dc0-4bd7-9333-8187e6479927',0,'2022-02-08 09:49:00','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.17.1.1.1 Occlusion 4\",\"modelMatrix\":\"-0.980954,-0.188901,0.0452269,0,0.19424,-0.953992,0.228406,0,1.35057e-9,0.232841,0.972515,0,27.4349,19.1019,-20.1379,1\",\"referenceScanID\":\"1.17.1.1.1\",\"title\":\"Mandibule 1.17.1.1.1 Occlusion 4\"}'),(1001,'7ad19c15-8266-4c29-bd63-8c53155064ad','','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_aa16f8ea-198d-4240-ab78-5a1f54823f0c_BOPLY__ZIP_','2022-05-16 17:48:35','2022-05-16 19:47:59','','2022-05-16 19:48:35','SYNCED','7ad19c15-8266-4c29-bd63-8c53155064ad',0,'2022-05-16 19:48:35','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.24.1.1.1 Occlusion 6\",\"modelMatrix\":\"0.852703,-0.521011,0.0380208,0,0.522396,0.850441,-0.062061,0,3.49638e-10,0.0727815,0.997348,0,-11.3911,-12.8136,-21.1334,1\",\"referenceScanID\":\"1.24.1.1.1\",\"title\":\"Mandibule 1.24.1.1.1 Occlusion 6\"}'),(1001,'7af23859-5ba5-41ff-8a79-87df077d50d3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f4fc00ec-4af8-4a15-b427-f1c5aabf6260/session_498ae60a-23f0-44fc-9730-be499bfc4b46/occlusion_8f3d6c73-3468-45a5-85c7-93bba47ec9f7/scan_a7163552-20ad-4b45-ae78-be2b0453dbd3/30_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_f4fc00ec-4af8-4a15-b427-f1c5aabf6260_ACT_498ae60a-23f0-44fc-9730-be499bfc4b46_SESS_8f3d6c73-3468-45a5-85c7-93bba47ec9f7_LESC_a7163552-20ad-4b45-ae78-be2b0453dbd3_SNAPS_','2022-06-14 13:29:52','2022-06-14 15:29:43','30_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-06-14 15:29:52','SYNCED','7af23859-5ba5-41ff-8a79-87df077d50d3',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.30.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'7b06349b-4ad9-4d66-bf24-7760cd5a84be','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_2ffbfbca-f236-4802-be93-8eb43d523274/scan_dfbb6a00-3125-4e66-bba2-7ad562b73551/4_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_2ffbfbca-f236-4802-be93-8eb43d523274_TOSC_dfbb6a00-3125-4e66-bba2-7ad562b73551_SNAPS_','2022-01-19 18:59:33','2022-01-19 19:59:09','4_w1_o1_maxillaire_snapshot_0.png','2022-01-19 19:59:33','SYNCED','7b06349b-4ad9-4d66-bf24-7760cd5a84be',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.4.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'7b1b7e50-5b0a-456a-9574-72b61f8238d2','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_2a7068fc-0efa-496f-ade9-aba5b0650655/12_w1_o1_mandibule_scan_file_3.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_2a7068fc-0efa-496f-ade9-aba5b0650655_ZIP_','2022-02-04 12:01:55','2022-02-04 12:57:01','12_w1_o1_mandibule_scan_file_3.zip','2022-02-04 13:01:55','SYNCED','44ebcd6f-57c2-4cce-96f5-f9faa1c6b373',3,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.5\",\"modelMatrix\":\"0.713807,-0.664318,0.221723,0,0.700343,0.677089,-0.225986,0,-4.22566e-9,0.316593,0.948562,0,3.53751,30.2884,-29.5645,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'7b2c0599-a564-406a-a92c-1e8ebb63ae32','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/computedocclusion_0bc29ff9-efea-448d-b521-2c39fd4faa78/19_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_OCC_0bc29ff9-efea-448d-b521-2c39fd4faa78_BOMA__MATRX_','2022-03-08 11:18:04','2022-03-08 12:17:37','19_w1_o1_mandibule_matrix_occ_file_0.m','2022-03-08 12:18:04','SYNCED','7b2c0599-a564-406a-a92c-1e8ebb63ae32',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.19.1.1.4 Occlusion 3\",\"referenceScanID\":\"1.19.1.1.4\",\"title\":\"Matrice Transfo. Mandibule 1.19.1.1.4 Occlusion 3\"}'),(1001,'7b448472-93a0-4faf-a51d-7e632836d89d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/593972a6-d7d6-4802-b87d-38aab371f71e/session_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480/occlusion_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3/computedocclusion_e23c031c-2c78-414b-840d-85b58e959fbe/3_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_593972a6-d7d6-4802-b87d-38aab371f71e_ACT_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480_SESS_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3_OCC_e23c031c-2c78-414b-840d-85b58e959fbe_TOMA__MATRX_','2022-01-19 15:28:10','2022-01-19 16:26:52','3_w1_o1_maxillaire_matrix_occ_file_0.m','2022-01-19 16:28:10','SYNCED','7b448472-93a0-4faf-a51d-7e632836d89d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.3.1.1.1 Occlusion 4\",\"referenceScanID\":\"1.3.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.3.1.1.1 Occlusion 4\"}'),(1001,'7b4cca84-e8d2-407c-be53-278f95c64d9b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/scan_1a0b9502-8df2-41a2-89eb-2def508b7462/22_w1_o1_mordu_posterieur_droit_scan_file_1.zip','ZIP','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_RISC_1a0b9502-8df2-41a2-89eb-2def508b7462_ZIP_','2022-04-21 17:38:25','2022-04-21 19:38:19','22_w1_o1_mordu_posterieur_droit_scan_file_1.zip','2022-04-21 19:38:25','SYNCED','1fc93c7d-617e-42e3-b407-18216c5a47ca',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.22.1.1.6\",\"modelMatrix\":\"-0.989729,0.00526289,-0.143837,0,-0.00941161,-1.00005,-0.00463951,0,-0.142672,0.0133764,0.989739,0,15.8973,1.46372,-15.7658,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'7b5038ae-c222-48fe-8fb4-8f9809bd6073','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/9efbbbe9-fd0a-44b1-988c-23571aad69fa/session_595a54fa-ae7d-4880-86a1-168b20242ecf/occlusion_b84a2165-e2d4-47e5-b110-a34bcaa24341/computedocclusion_9cad1eff-fefd-4d0a-b1af-fecfbc5a507f/53_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_9efbbbe9-fd0a-44b1-988c-23571aad69fa_ACT_595a54fa-ae7d-4880-86a1-168b20242ecf_SESS_b84a2165-e2d4-47e5-b110-a34bcaa24341_OCC_9cad1eff-fefd-4d0a-b1af-fecfbc5a507f_TOPLY__ZIP_','2022-12-02 14:17:51','2022-12-02 15:17:19','53_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-12-02 15:17:51','SYNCED','7b5038ae-c222-48fe-8fb4-8f9809bd6073',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.53.1.1.3 Occlusion 1\",\"modelMatrix\":\"0.595665,0.793857,-0.122368,0,-0.803233,0.588712,-0.0907461,0,6.47843e-09,0.152344,0.988327,0,-24.5118,-11.5932,-19.8899,1\",\"referenceScanID\":\"1.53.1.1.3\",\"title\":\"Maxillaire 1.53.1.1.3 Occlusion 1\"}'),(1001,'7b9e55a3-04eb-45e7-834a-a40c15653db2','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/ccc47f1d-1705-4945-aa08-da5aa64d251f/session_09e7d062-6ceb-4577-a66e-100bb8dad6d4/occlusion_eb899adb-91e6-4341-90ff-6ebabd7bbe76/scan_30ef0426-9437-4021-b70c-62779b73e0eb/44_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_ccc47f1d-1705-4945-aa08-da5aa64d251f_ACT_09e7d062-6ceb-4577-a66e-100bb8dad6d4_SESS_eb899adb-91e6-4341-90ff-6ebabd7bbe76_BOSC_30ef0426-9437-4021-b70c-62779b73e0eb_SNAPS_','2022-10-18 17:04:30','2022-10-18 19:04:28','44_w1_o1_maxillaire_snapshot_0.png','2022-10-18 19:04:30','SYNCED','7b9e55a3-04eb-45e7-834a-a40c15653db2',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.44.1.1.4\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'7ca6f680-78d4-4290-b246-10418b29f7f5','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/computedocclusion_e9bfc750-6943-42bf-8c0b-b7e1dc1803c5/1_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_OCC_e9bfc750-6943-42bf-8c0b-b7e1dc1803c5_SNAPO__SNAPS_','2022-01-19 13:04:01','2022-01-19 12:12:14','1_w1_o1_snapshot_occ_file_0.png','2022-01-19 14:04:01','SYNCED','7ca6f680-78d4-4290-b246-10418b29f7f5',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'7cec7e1d-dea8-4323-9a35-77e7166c42eb','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/computedocclusion_7c70edbe-5cb4-4244-8baf-7caf2bd7d86b/12_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_OCC_7c70edbe-5cb4-4244-8baf-7caf2bd7d86b_BOPLY__ZIP_','2022-02-04 17:59:24','2022-02-04 18:58:48','12_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-02-04 18:59:24','SYNCED','7cec7e1d-dea8-4323-9a35-77e7166c42eb',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.5 Occlusion 1\",\"modelMatrix\":\"0.821265,-0.551643,0.145651,0,0.570547,0.794053,-0.209655,0,5.91416e-9,0.255283,0.966866,0,-2.59195,32.4156,-27.5972,1\",\"referenceScanID\":\"1.12.1.1.5\",\"title\":\"Mandibule 1.12.1.1.5 Occlusion 1\"}'),(1001,'7d450445-455d-49e5-9ca6-17391bd11056','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_4f8dc275-857c-482a-9886-5521591e9661/scan_ac56bd4c-2fb3-4bde-858c-86c2586bc3e9/12_w1_o4_maxillaire_scan_file_0.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_TOSC_ac56bd4c-2fb3-4bde-858c-86c2586bc3e9_ZIP_','2022-02-14 10:22:01','2022-02-14 11:21:45','12_w1_o4_maxillaire_scan_file_0.zip','2022-02-14 11:22:01','SYNCED','7d450445-455d-49e5-9ca6-17391bd11056',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.12.1.4.1\",\"modelMatrix\":\"0.289939,0.931295,-0.220513,0,-0.957045,0.282138,-0.0668048,0,-2.02843e-09,0.23041,0.973094,0,-18.1704,-26.1606,-18.7028,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'7d79d13e-7e3b-499a-bbc1-358a91ff1968','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/09688939-f53f-4f00-8366-687b244de26d/session_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525/occlusion_9655a7e0-4673-41c9-90da-a48c008e2d62/scan_8b05f1fc-00db-4f53-b19b-e43d44dbd773/64_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_09688939-f53f-4f00-8366-687b244de26d_ACT_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525_SESS_9655a7e0-4673-41c9-90da-a48c008e2d62_TOSC_8b05f1fc-00db-4f53-b19b-e43d44dbd773_SNAPS_','2023-03-30 12:05:12','2023-03-30 14:05:03','64_w1_o1_maxillaire_snapshot_1.png','2023-03-30 14:05:12','SYNCED','6175a7d4-0904-42d7-b0bc-fd89c5dd6fbb',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.64.1.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'7df1de62-5ae6-4d7c-95b4-229ef75c4f04','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/39062d60-7a18-417a-9004-c58e9ce7d62a/session_9869e99c-7b47-4662-9766-0388d668fbf3/occlusion_36832844-9579-46df-aea1-b9baf6ad8787/computedocclusion_a2f94254-4555-4b27-973a-d1034950f081/61_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_39062d60-7a18-417a-9004-c58e9ce7d62a_ACT_9869e99c-7b47-4662-9766-0388d668fbf3_SESS_36832844-9579-46df-aea1-b9baf6ad8787_OCC_a2f94254-4555-4b27-973a-d1034950f081_SNAPO__SNAPS_','2023-03-10 17:33:55','2023-03-10 18:33:29','61_w1_o1_snapshot_occ_file_0.png','2023-03-10 18:33:55','SYNCED','7df1de62-5ae6-4d7c-95b4-229ef75c4f04',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'7e7f59a1-a263-4606-8568-c16cfdaf8ab8','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_ce625ba7-4218-40af-b344-df718da13f83/54_w1_o1_maxillaire_matrix_occ_file_8.m','MATRX','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_ce625ba7-4218-40af-b344-df718da13f83_TOMA__MATRX_','2023-03-15 10:35:06','2023-03-15 11:32:30','54_w1_o1_maxillaire_matrix_occ_file_8.m','2023-03-15 11:35:06','SYNCED','ccf7be44-96c0-48d2-80d6-833cb64e29bc',8,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.54.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.54.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.54.1.1.1 Occlusion 1\"}'),(1001,'7ec34b4e-bd8b-4125-bc39-a94b91122070','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/computedocclusion_42098ceb-3335-4f13-8aed-b29c37a5f57f/22_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_OCC_42098ceb-3335-4f13-8aed-b29c37a5f57f_TOPLY__ZIP_','2022-04-21 11:29:04','2022-04-21 13:28:43','22_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-04-21 13:29:04','SYNCED','7ec34b4e-bd8b-4125-bc39-a94b91122070',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.22.1.1.1 Occlusion 6\",\"modelMatrix\":\"0.527598,0.839702,-0.128611,0,-0.849494,0.521516,-0.0798764,0,4.31898e-09,0.151397,0.988473,0,-4.53893,-22.22,-19.046,1\",\"referenceScanID\":\"1.22.1.1.1\",\"title\":\"Maxillaire 1.22.1.1.1 Occlusion 6\"}'),(1001,'7eefa8d1-beb5-4db9-adf4-6f919d9dd7ee','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f9d03016-567a-4bd4-9cc5-dafeea34e365/session_a7bcb190-dd19-4f3b-8aab-266030bf4064/occlusion_c321e210-b67c-40e8-bece-f8946164a768/scan_90f9c577-02d8-45f3-9ac5-6c6cfeef1fa2/36_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_f9d03016-567a-4bd4-9cc5-dafeea34e365_ACT_a7bcb190-dd19-4f3b-8aab-266030bf4064_SESS_c321e210-b67c-40e8-bece-f8946164a768_BOSC_90f9c577-02d8-45f3-9ac5-6c6cfeef1fa2_ZIP_','2022-07-04 13:53:56','2022-07-04 15:53:48','36_w1_o1_mandibule_scan_file_0.zip','2022-07-04 15:53:56','SYNCED','7eefa8d1-beb5-4db9-adf4-6f919d9dd7ee',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.36.1.1.1\",\"modelMatrix\":\"-0.990067,0.139225,-0.0195784,0,-0.140595,-0.980421,0.137871,0,7.05379e-10,0.139254,0.990257,0,10.6502,0.270883,-21.469,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'7f119dba-eb12-43c6-9fec-3f65fc8a09f7','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/204921b5-c765-4248-8e87-e3b0f7a46bff/session_88257045-93fb-43fb-8b0a-f39fbf5f8e9d/occlusion_ad360501-c145-40e5-9b88-808cd7a61eed/scan_46cadb07-fc0d-4016-8a0a-b8b7e8c6a0d4/45_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_204921b5-c765-4248-8e87-e3b0f7a46bff_ACT_88257045-93fb-43fb-8b0a-f39fbf5f8e9d_SESS_ad360501-c145-40e5-9b88-808cd7a61eed_RISC_46cadb07-fc0d-4016-8a0a-b8b7e8c6a0d4_SNAPS_','2022-10-18 12:56:51','2022-10-18 14:56:45','45_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-10-18 14:56:51','SYNCED','7f119dba-eb12-43c6-9fec-3f65fc8a09f7',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.45.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'7f150a86-6fec-4718-a058-cd12d7a38305','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/computedocclusion_d7643aed-d242-47f6-8e1a-703d4672f109/18_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_OCC_d7643aed-d242-47f6-8e1a-703d4672f109_BOMA__MATRX_','2022-03-07 14:44:32','2022-03-07 15:44:20','18_w1_o1_mandibule_matrix_occ_file_0.m','2022-03-07 15:44:32','SYNCED','7f150a86-6fec-4718-a058-cd12d7a38305',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.18.1.1.2 Occlusion 2\",\"referenceScanID\":\"1.18.1.1.2\",\"title\":\"Matrice Transfo. Mandibule 1.18.1.1.2 Occlusion 2\"}'),(1001,'7f170f84-f1e1-4d43-8fcb-0fe153f8a949','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/computedocclusion_0d180e89-cc7f-4718-abf6-79b3ada7fd3c/4_w1_o2_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_OCC_0d180e89-cc7f-4718-abf6-79b3ada7fd3c_TOPLY__ZIP_','2022-02-15 12:49:56','2022-02-15 13:49:40','4_w1_o2_maxillaire_occlusion_occ_file_0.zip','2022-02-15 13:49:56','SYNCED','7f170f84-f1e1-4d43-8fcb-0fe153f8a949',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.4.1.2.1 Occlusion 3\",\"modelMatrix\":\"-0.408152,0.902703,-0.13616,0,-0.912914,-0.403587,0.0608755,0,-1.7183e-09,0.149149,0.988815,0,3.7011,-24.744,-22.2405,1\",\"referenceScanID\":\"1.4.1.2.1\",\"title\":\"Maxillaire 1.4.1.2.1 Occlusion 3\"}'),(1001,'7f6909e3-14ac-4be4-8b7c-81f83f2e4495','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/3a170256-4132-4b56-ad27-b2cc7790bbf8/session_c57164ce-3f15-42b7-a8dc-96ab6a136184/occlusion_4779508f-bef4-4a89-9555-58b917369f06/computedocclusion_c02aa6d3-8bb3-4ebb-ae67-2dc59b73bc9f/62_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_3a170256-4132-4b56-ad27-b2cc7790bbf8_ACT_c57164ce-3f15-42b7-a8dc-96ab6a136184_SESS_4779508f-bef4-4a89-9555-58b917369f06_OCC_c02aa6d3-8bb3-4ebb-ae67-2dc59b73bc9f_TOPLY__ZIP_','2023-03-14 09:15:58','2023-03-13 10:51:53','62_w1_o1_maxillaire_occlusion_occ_file_0.zip','2023-03-14 10:15:58','SYNCED','7f6909e3-14ac-4be4-8b7c-81f83f2e4495',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.62.1.1.1 Occlusion 2\",\"referenceScanID\":\"1.62.1.1.1\",\"title\":\"Maxillaire 1.62.1.1.1 Occlusion 2\"}'),(1001,'7f6a360e-6853-4644-b9e8-38e216b20de4','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/533d4409-e39d-4a27-a0af-b59e6cf76ce3/session_319a8f1d-33fc-4f87-a108-b3eabda0510f/occlusion_3b38f07b-42cb-40b1-933f-365e568702e4/scan_450a38a9-baaa-443c-b15d-b73099c5ee33/37_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_533d4409-e39d-4a27-a0af-b59e6cf76ce3_ACT_319a8f1d-33fc-4f87-a108-b3eabda0510f_SESS_3b38f07b-42cb-40b1-933f-365e568702e4_BOSC_450a38a9-baaa-443c-b15d-b73099c5ee33_ZIP_','2022-07-07 16:02:36','2022-07-07 18:02:28','37_w1_o1_mandibule_scan_file_0.zip','2022-07-07 18:02:36','SYNCED','7f6a360e-6853-4644-b9e8-38e216b20de4',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.37.1.1.1\",\"modelMatrix\":\"-0.86819,0.468903,-0.16241,0,-0.496233,-0.820374,0.284146,0,-2.07609e-10,0.327285,0.944926,0,12.7312,-21.9778,-18.4361,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'7f961e41-617e-4e30-84ef-a53f823e5acf','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/computedocclusion_2de3d2bb-d512-4514-8bed-a879b73a6028/22_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_OCC_2de3d2bb-d512-4514-8bed-a879b73a6028_BOPLY__ZIP_','2022-04-21 11:29:26','2022-04-21 13:29:16','22_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-04-21 13:29:26','SYNCED','7f961e41-617e-4e30-84ef-a53f823e5acf',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.22.1.1.1 Occlusion 7\",\"modelMatrix\":\"0.955284,-0.295231,0.0164688,0,0.29569,0.953801,-0.0532056,0,-9.04209e-10,0.0556961,0.998448,0,-1.05738,9.66348,-22.4364,1\",\"referenceScanID\":\"1.22.1.1.1\",\"title\":\"Mandibule 1.22.1.1.1 Occlusion 7\"}'),(1001,'7f962851-c777-4bcf-aed9-3de954af09bb','','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_BOSC_a1a9cef4-72fe-4dbe-928c-3831f98ecfbc_ZIP_','2022-02-19 17:53:24','2022-02-18 17:01:56','','2022-02-19 18:53:24','SYNCED','1f9724a7-2075-47b0-8aee-e88fec576ca0',2,'2022-02-19 18:53:24','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.4.4\",\"modelMatrix\":\"-0.253847,-0.962806,0.0925531,0,0.967245,-0.252682,0.0242899,0,2.7793e-10,0.0956874,0.995411,0,0.0328966,-2.05616,-25.0668,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'7fb6e5a5-0050-48c4-95d0-034a5b68e153','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/593972a6-d7d6-4802-b87d-38aab371f71e/session_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480/occlusion_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3/scan_4d153a25-3b94-464b-9b18-2966d8ae2ce6/3_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_593972a6-d7d6-4802-b87d-38aab371f71e_ACT_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480_SESS_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3_FRSC_4d153a25-3b94-464b-9b18-2966d8ae2ce6_SNAPS_','2022-01-19 15:20:34','2022-01-19 16:20:20','3_w1_o1_mordu_anterieur_snapshot_0.png','2022-01-19 16:20:34','SYNCED','7fb6e5a5-0050-48c4-95d0-034a5b68e153',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.3.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'7fc09fc3-81a3-49fd-a553-03ab9f8a113e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a0c21836-ba79-4f15-9e35-02ef8211a9e5/session_0aac522d-3c38-465a-a1e0-014166c140ac/occlusion_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042/scan_b3e360d5-eb70-4046-910f-cbac3270fd6c/7_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_a0c21836-ba79-4f15-9e35-02ef8211a9e5_ACT_0aac522d-3c38-465a-a1e0-014166c140ac_SESS_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042_TOSC_b3e360d5-eb70-4046-910f-cbac3270fd6c_ZIP_','2022-01-21 11:31:57','2022-01-21 12:31:33','7_w1_o1_maxillaire_scan_file_0.zip','2022-01-21 12:31:57','SYNCED','7fc09fc3-81a3-49fd-a553-03ab9f8a113e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.7.1.1.1\",\"modelMatrix\":\"-0.77677,0.624884,-0.0784113,0,-0.629784,-0.770726,0.0967117,0,3.07242e-9,0.124505,0.992219,0,14.2813,-22.8909,-20.0873,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'7fddb7f4-ade9-4efb-85ae-77539683dea6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/69640c87-271c-4a44-a6fa-67b01654cc27/session_5f9199b0-eb37-4ed3-8d1a-6c38505d4913/occlusion_991beec3-fe9e-4c98-a3d4-c98e4a4c2471/computedocclusion_c7bccd1e-370e-4347-8296-1bcd4c30b631/39_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_OCC_c7bccd1e-370e-4347-8296-1bcd4c30b631_TOMA__MATRX_','2022-09-10 09:46:17','2022-09-10 11:45:43','39_w1_o1_maxillaire_matrix_occ_file_0.m','2022-09-10 11:46:17','SYNCED','7fddb7f4-ade9-4efb-85ae-77539683dea6',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.39.1.1.1 Occlusion 10\",\"referenceScanID\":\"1.39.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.39.1.1.1 Occlusion 10\"}'),(1001,'7fec2d30-959d-47cf-ba48-d5cb7d8e334e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/scan_eafe4b37-e7ad-4f58-b931-a99f31f6d4a4/22_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_BOSC_eafe4b37-e7ad-4f58-b931-a99f31f6d4a4_SNAPS_','2022-04-21 10:50:46','2022-04-21 12:50:36','22_w1_o1_mandibule_snapshot_1.png','2022-04-21 12:50:46','SYNCED','62e04955-36d7-4e72-9a0b-cffb6a8463fe',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.22.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'80093ded-a48f-45ee-95e5-aea0e4d6100f','','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_BOSC_4aa73b1e-d6d0-436c-8abe-c649026c7ff2_ZIP_','2022-02-19 17:53:24','2022-02-14 19:11:35','','2022-02-19 18:53:24','SYNCED','a47f7028-b44e-4922-80ba-98156019677c',1,'2022-02-19 18:53:24','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.4.1\",\"modelMatrix\":\"-0.860708,-0.503908,0.0725143,0,0.509098,-0.851933,0.122596,0,2.77008e-09,0.142437,0.989804,0,18.9902,16.8499,-23.097,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'800a13fa-89b5-4193-bf7b-bf2a1c5ec28f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/computedocclusion_864c98a3-fcf7-466a-b999-13bd4dfb8c65/23_w1_o1_mlmeta_occ_file_to1001.bin','LIFIM','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_864c98a3-fcf7-466a-b999-13bd4dfb8c65_LIFIMO_LIFIM_','2022-05-25 10:45:10','2022-05-25 12:45:09','23_w1_o1_mlmeta_occ_file_to1001.bin','2022-05-25 12:45:10','SYNCED','800a13fa-89b5-4193-bf7b-bf2a1c5ec28f',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.23.1.1.1 Occlusion 3 Ligne de finition 1\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"Maxillaire\",\"name\":\"Ligne de finition 1\",\"title\":\"Ligne finition metadata\",\"toothNumber\":1001}'),(1001,'803a5a7f-c846-41ee-9190-6d020a343c0b','','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_9440baee-a8bf-406c-bc0a-f5e9596f197b_SNAPO__SNAPS_','2022-05-13 16:14:04','2022-05-13 18:13:11','','2022-05-13 18:14:04','SYNCED','803a5a7f-c846-41ee-9190-6d020a343c0b',0,'2022-05-13 18:14:04','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'805f8530-5ec9-44a3-af49-6734dc6d92b1','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/9e399d73-4d2e-4bb8-af48-a4e597811faa/session_b1cf14ce-00a9-48b6-8654-dadde26073f1/occlusion_1060c95f-48f4-4a37-9b82-03bfd8329730/scan_7887f7ce-288b-4f04-a7cd-7a7c58e2e5f9/46_w1_o2_mordu_posterieur_droit_snapshot_1.png','SNAPS','PATIENT_9e399d73-4d2e-4bb8-af48-a4e597811faa_ACT_b1cf14ce-00a9-48b6-8654-dadde26073f1_SESS_1060c95f-48f4-4a37-9b82-03bfd8329730_RISC_7887f7ce-288b-4f04-a7cd-7a7c58e2e5f9_SNAPS_','2023-01-20 14:41:14','2023-01-20 15:41:01','46_w1_o2_mordu_posterieur_droit_snapshot_1.png','2023-01-20 15:41:14','SYNCED','a74a17e1-08c2-4a1c-9618-7a1a097d89b8',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.46.1.2.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'80740dcf-ef50-473b-bf6b-dbd21bab0839','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/986374de-c4d7-4d6f-bf0c-2dc7e3b859a9/session_c81670ed-4144-4347-b19e-8057d11b5f7c/occlusion_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be/computedocclusion_7a5acfd0-87ca-4009-aa4e-677a88ceffde/28_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_986374de-c4d7-4d6f-bf0c-2dc7e3b859a9_ACT_c81670ed-4144-4347-b19e-8057d11b5f7c_SESS_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be_OCC_7a5acfd0-87ca-4009-aa4e-677a88ceffde_TOPLY__ZIP_','2022-05-31 10:54:12','2022-05-31 12:53:55','28_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-05-31 12:54:12','SYNCED','80740dcf-ef50-473b-bf6b-dbd21bab0839',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.28.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.881614,0.469845,-0.0447426,0,-0.471971,0.877644,-0.0835766,0,-1.4504e-09,0.0947996,0.995496,0,-11.2843,-18.9837,-19.8455,1\",\"referenceScanID\":\"1.28.1.1.1\",\"title\":\"Maxillaire 1.28.1.1.1 Occlusion 1\"}'),(1001,'8092dcf3-d2f4-4b48-8165-79c4350ba9e2','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_2a7068fc-0efa-496f-ade9-aba5b0650655/12_w1_o1_mandibule_scan_file_5.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_2a7068fc-0efa-496f-ade9-aba5b0650655_ZIP_','2022-02-04 12:03:03','2022-02-04 13:01:39','12_w1_o1_mandibule_scan_file_5.zip','2022-02-04 13:03:03','SYNCED','44ebcd6f-57c2-4cce-96f5-f9faa1c6b373',5,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.5\",\"modelMatrix\":\"0.733745,-0.643824,0.217047,0,0.679425,0.695298,-0.2344,0,-4.52824e-9,0.319456,0.947601,0,1.99189,29.7441,-29.4896,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'80d822aa-8c38-4390-bdc1-0b044f167d73','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/de078619-3946-4adb-a799-1c260e16face/session_24d0aeb5-3058-4070-aeea-97c289e41e3c/occlusion_ea6da896-1504-41fc-890c-7c48575e9e40/scan_aa24138a-68e8-4bc3-9a5d-d617f0fe496b/2_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_de078619-3946-4adb-a799-1c260e16face_ACT_24d0aeb5-3058-4070-aeea-97c289e41e3c_SESS_ea6da896-1504-41fc-890c-7c48575e9e40_TOSC_aa24138a-68e8-4bc3-9a5d-d617f0fe496b_ZIP_','2022-01-19 14:01:46','2022-01-19 15:01:29','2_w1_o1_maxillaire_scan_file_0.zip','2022-01-19 15:01:46','SYNCED','80d822aa-8c38-4390-bdc1-0b044f167d73',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.2.1.1.1\",\"modelMatrix\":\"0.994941,0.0949868,-0.0327181,0,-0.100464,0.9407,-0.324023,0,5.62813e-10,0.325671,0.945483,0,-20.9401,-37.2969,-22.6714,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'80ec1edf-c2f7-4914-86c8-ba85dac6448a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_909d9ecd-46b3-4692-868e-f6405507ecd1/24_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_TOSC_909d9ecd-46b3-4692-868e-f6405507ecd1_SNAPS_','2022-05-13 14:40:37','2022-05-13 16:40:24','24_w1_o1_maxillaire_snapshot_0.png','2022-05-13 16:40:37','SYNCED','80ec1edf-c2f7-4914-86c8-ba85dac6448a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'80fac73f-4e14-44dd-b7e3-5b5fd926bcb2','','MATRX','PATIENT_593972a6-d7d6-4802-b87d-38aab371f71e_ACT_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480_SESS_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3_OCC_4e1258a6-b789-451f-bfe8-8b395e1129d8_TOMA__MATRX_','2022-01-19 15:25:10','2022-01-19 16:24:43','',NULL,'CREATED','80fac73f-4e14-44dd-b7e3-5b5fd926bcb2',0,'2022-01-19 16:25:10','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.3.1.1.1 Occlusion 3\",\"referenceScanID\":\"1.3.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.3.1.1.1 Occlusion 3\"}'),(1001,'815207c9-ab46-4aa9-b775-bd7ebd5b8929','','LIFIM','PATIENT_a9e7a1ae-2d71-448f-80f6-19d916912a3c_ACT_07012a03-2a1e-44e4-9bc9-17e726862bc2_SESS_ab83a8b7-1eb1-4b13-9594-40d6479b2b19_BOSC_e33a7de9-6d02-41e0-b621-fc99e53eb96c_LIFIM_','2022-12-22 08:46:51','2022-12-14 16:02:13','','2022-12-22 09:46:51','SYNCED','815207c9-ab46-4aa9-b775-bd7ebd5b8929',0,'2022-12-22 09:46:51','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Mandibule 1.52.1.1.1 Ligne de finition 0\",\"name\":\"Ligne de finition 0\",\"title\":\"Mandibule LIFI_META\",\"toothNumber\":0,\"versionMarginLine\":1}'),(1001,'815860cb-19c9-4171-93d6-ec345254eb3e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/occlusion_a2220645-c79d-4dda-b6cc-772384a4106b/computedocclusion_cf412dab-1d83-4db0-ae1b-d2724d5be97d/38_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_OCC_cf412dab-1d83-4db0-ae1b-d2724d5be97d_BOPLY__ZIP_','2022-07-12 11:04:23','2022-07-12 13:04:14','38_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-07-12 13:04:23','SYNCED','815860cb-19c9-4171-93d6-ec345254eb3e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.38.1.1.1 Occlusion 2\",\"modelMatrix\":\"-0.751938,0.649871,-0.110711,0,-0.659234,-0.741259,0.12628,0,-8.33225e-09,0.167939,0.985797,0,9.41783,-30.192,-17.274,1\",\"referenceScanID\":\"1.38.1.1.1\",\"title\":\"Mandibule 1.38.1.1.1 Occlusion 2\"}'),(1001,'815d4a5a-3f95-4f4d-bdb2-1da2d1652a51','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_fde05ea2-d0fd-419b-ba13-bf1a1bd03a22/18_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_BOSC_fde05ea2-d0fd-419b-ba13-bf1a1bd03a22_ZIP_','2022-03-07 14:28:30','2022-03-07 15:28:18','18_w1_o1_mandibule_scan_file_1.zip','2022-03-07 15:28:30','SYNCED','6638ad2b-84e9-4c08-ad38-98e12dae4a45',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.18.1.1.2\",\"modelMatrix\":\"0.919793,-0.387127,0.064141,0,0.392404,0.907422,-0.150346,0,2.24171e-09,0.163456,0.986551,0,-1.76441,21.4524,-16.898,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'81ab663b-3f7f-440e-bc5e-0b3f41373259','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/computedocclusion_6960b50e-6f78-4f83-9303-8c985410457c/4_w1_o4_snapshot_occ_file_0.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_OCC_6960b50e-6f78-4f83-9303-8c985410457c_SNAPO__SNAPS_','2022-05-31 14:56:07','2022-05-31 16:55:44','4_w1_o4_snapshot_occ_file_0.png','2022-05-31 16:56:07','SYNCED','81ab663b-3f7f-440e-bc5e-0b3f41373259',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'81ec8405-393a-486b-974a-31e4794db9ba','','MATRX','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_OCC_a525c976-46dd-42bc-abc1-c7cf71f9a1f1_BOMA__MATRX_','2022-02-07 11:15:30','2022-02-04 14:58:28','','2022-02-07 12:15:30','SYNCED','81ec8405-393a-486b-974a-31e4794db9ba',0,'2022-02-07 12:15:30','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.12.1.1.5 Occlusion 1\",\"referenceScanID\":\"1.12.1.1.5\",\"title\":\"Matrice Transfo. Mandibule 1.12.1.1.5 Occlusion 1\"}'),(1001,'821eca02-2a97-4215-9d0f-d9f7f84e99bd','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/3a170256-4132-4b56-ad27-b2cc7790bbf8/session_c57164ce-3f15-42b7-a8dc-96ab6a136184/occlusion_4779508f-bef4-4a89-9555-58b917369f06/scan_dab06410-30fb-49be-bfaf-383db97cad4a/62_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_3a170256-4132-4b56-ad27-b2cc7790bbf8_ACT_c57164ce-3f15-42b7-a8dc-96ab6a136184_SESS_4779508f-bef4-4a89-9555-58b917369f06_TOSC_dab06410-30fb-49be-bfaf-383db97cad4a_ZIP_','2023-03-13 09:32:41','2023-03-13 10:32:16','62_w1_o1_maxillaire_scan_file_0.zip','2023-03-13 10:32:41','SYNCED','821eca02-2a97-4215-9d0f-d9f7f84e99bd',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.62.1.1.1\",\"modelMatrix\":\"-0.635311,0.756865,-0.153414,0,-0.772256,-0.622649,0.126209,0,-2.88253e-09,0.198656,0.980069,0,8.16694,-28.1785,-21.24,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'8272c05b-a14a-42a3-8ded-f56123c74479','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/75ce481f-6c44-4d16-a477-ea40c4fa6022/session_9bf7b056-ca4f-4dab-937b-619d0eb20528/occlusion_d7580529-3ede-4e27-a2ae-01849ba4d397/scan_6c5747b1-979b-4f6b-af3c-f657f990065d/55_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_75ce481f-6c44-4d16-a477-ea40c4fa6022_ACT_9bf7b056-ca4f-4dab-937b-619d0eb20528_SESS_d7580529-3ede-4e27-a2ae-01849ba4d397_LESC_6c5747b1-979b-4f6b-af3c-f657f990065d_SNAPS_','2022-12-22 10:36:55','2022-12-22 11:36:48','55_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-12-22 11:36:55','SYNCED','8272c05b-a14a-42a3-8ded-f56123c74479',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.55.1.1.2\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'829ffd44-c4bc-4933-8b47-bd648efb8221','','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_OCC_a525c976-46dd-42bc-abc1-c7cf71f9a1f1_BOPLY__ZIP_','2022-02-07 11:15:31','2022-02-04 14:58:28','','2022-02-07 12:15:31','SYNCED','829ffd44-c4bc-4933-8b47-bd648efb8221',0,'2022-02-07 12:15:31','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.5 Occlusion 1\",\"modelMatrix\":\"0.821265,-0.551643,0.145651,0,0.570547,0.794053,-0.209655,0,5.91416e-9,0.255283,0.966866,0,-2.59195,32.4156,-27.5972,1\",\"referenceScanID\":\"1.12.1.1.5\",\"title\":\"Mandibule 1.12.1.1.5 Occlusion 1\"}'),(1001,'82b96208-37c7-4afb-8cb7-2139b6f0227e','','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_BOSC_4aa73b1e-d6d0-436c-8abe-c649026c7ff2_SNAPS_','2022-02-19 17:53:24','2022-02-14 18:57:20','','2022-02-19 18:53:24','SYNCED','82b96208-37c7-4afb-8cb7-2139b6f0227e',0,'2022-02-19 18:53:24','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.4.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'82de4186-a7d9-4d61-87ed-a4ef94f0ce68','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/533d4409-e39d-4a27-a0af-b59e6cf76ce3/session_319a8f1d-33fc-4f87-a108-b3eabda0510f/occlusion_3b38f07b-42cb-40b1-933f-365e568702e4/scan_109ca2c4-8222-4d02-9ac7-b4b93937e1e2/37_w1_o1_maxillaire_scan_file_3.zip','ZIP','PATIENT_533d4409-e39d-4a27-a0af-b59e6cf76ce3_ACT_319a8f1d-33fc-4f87-a108-b3eabda0510f_SESS_3b38f07b-42cb-40b1-933f-365e568702e4_TOSC_109ca2c4-8222-4d02-9ac7-b4b93937e1e2_ZIP_','2022-07-07 16:05:55','2022-07-07 18:05:44','37_w1_o1_maxillaire_scan_file_3.zip','2022-07-07 18:05:55','SYNCED','0192b393-b665-47d2-aaac-671ff4a06d5c',3,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.37.1.1.1\",\"modelMatrix\":\"0.575392,0.796207,-0.187024,0,-0.817878,0.560146,-0.131575,0,-7.09343e-09,0.22867,0.973504,0,5.4577,-25.4107,-17.9502,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'82e8db17-5fea-47ae-80d5-6e8bb12e5f9c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/order_e183d0b1-c9b1-419a-b14b-8ccde159219c/19_w1_autre_prost_file_82e8db17-5fea-47ae-80d5-6e8bb12e5f9c_0.pdf','PDF','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_PROST_e183d0b1-c9b1-419a-b14b-8ccde159219c_PDF_','2022-03-09 08:01:40','2022-03-09 09:01:37','19_w1_autre_prost_file_82e8db17-5fea-47ae-80d5-6e8bb12e5f9c_0.pdf','2022-03-09 09:01:40','SYNCED','82e8db17-5fea-47ae-80d5-6e8bb12e5f9c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.19.1.1 AUTRE FICHE DE PROTHESE\",\"title\":\"Autre PDF\"}'),(1001,'831e4532-3962-4547-af55-74e75647063d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/4a3954e0-1e2f-4721-9fdd-4180380dc19f/session_33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416/occlusion_3accbada-5a51-4d10-88d1-c3e7d8598d6f/computedocclusion_5775815f-f076-48af-be27-50e4dbfd3622/34_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_4a3954e0-1e2f-4721-9fdd-4180380dc19f_ACT_33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416_SESS_3accbada-5a51-4d10-88d1-c3e7d8598d6f_OCC_5775815f-f076-48af-be27-50e4dbfd3622_SNAPO__SNAPS_','2022-06-28 10:56:23','2022-06-28 12:55:54','34_w1_o1_snapshot_occ_file_0.png','2022-06-28 12:56:23','SYNCED','831e4532-3962-4547-af55-74e75647063d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'83246ce2-0d72-4319-a131-12ed4b4419a9','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_c76850a7-9433-47f8-825d-ced9f35dede0/24_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_BOSC_c76850a7-9433-47f8-825d-ced9f35dede0_SNAPS_','2022-05-13 14:11:03','2022-05-13 16:10:50','24_w1_o1_mandibule_snapshot_0.png','2022-05-13 16:11:03','SYNCED','83246ce2-0d72-4319-a131-12ed4b4419a9',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.24.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'833d41bc-57cd-41cd-85e4-fc650bc0c886','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a0c21836-ba79-4f15-9e35-02ef8211a9e5/session_0aac522d-3c38-465a-a1e0-014166c140ac/occlusion_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042/scan_c3e689b6-6028-4fc6-9373-eab430b52625/7_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_a0c21836-ba79-4f15-9e35-02ef8211a9e5_ACT_0aac522d-3c38-465a-a1e0-014166c140ac_SESS_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042_LESC_c3e689b6-6028-4fc6-9373-eab430b52625_SNAPS_','2022-01-21 12:04:49','2022-01-21 13:04:33','7_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-01-21 13:04:49','SYNCED','833d41bc-57cd-41cd-85e4-fc650bc0c886',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.7.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'8377bb86-2de2-4f02-98e6-a05de34ae0a6','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/372000f2-2471-4a57-9b18-224d0788041f/session_5dd64d24-8e33-45bd-a282-c148c185c338/occlusion_a61fbfda-1ac5-4747-9e0c-6ef664930816/computedocclusion_7eb0f2bf-a2c1-4938-b124-5a10e3cdb809/57_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_372000f2-2471-4a57-9b18-224d0788041f_ACT_5dd64d24-8e33-45bd-a282-c148c185c338_SESS_a61fbfda-1ac5-4747-9e0c-6ef664930816_OCC_7eb0f2bf-a2c1-4938-b124-5a10e3cdb809_BOMA__MATRX_','2023-02-17 10:55:37','2023-02-17 11:55:24','57_w1_o1_mandibule_matrix_occ_file_0.m','2023-02-17 11:55:37','SYNCED','8377bb86-2de2-4f02-98e6-a05de34ae0a6',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.57.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.57.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.57.1.1.1 Occlusion 1\"}'),(1001,'83b22557-d465-4536-b879-b5e8ba185d00','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/e922efb9-8c03-445b-8a0f-449e3c43bdca/session_a2369349-1629-40ad-8784-d271bc3fbade/order_08c2f5cb-1a54-4450-97e5-7e8bb6d72785/21_w1_autre_prost_file_83b22557-d465-4536-b879-b5e8ba185d00_0.pdf','PDF','PATIENT_e922efb9-8c03-445b-8a0f-449e3c43bdca_ACT_a2369349-1629-40ad-8784-d271bc3fbade_PROST_08c2f5cb-1a54-4450-97e5-7e8bb6d72785_PDF_','2022-04-21 13:43:42','2022-04-21 15:43:40','21_w1_autre_prost_file_83b22557-d465-4536-b879-b5e8ba185d00_0.pdf','2022-04-21 15:43:42','SYNCED','83b22557-d465-4536-b879-b5e8ba185d00',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.21.1.1 AUTRE FICHE DE PROTHESE\",\"title\":\"Autre PDF\"}'),(1001,'8455543e-ffff-43df-bb30-d3cae8c01e44','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/scan_7b00996b-90f8-4307-9a8c-263a28f1b341/4_w1_o4_maxillaire_snapshot_1.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_TOSC_7b00996b-90f8-4307-9a8c-263a28f1b341_SNAPS_','2022-05-31 11:53:50','2022-05-31 13:53:37','4_w1_o4_maxillaire_snapshot_1.png','2022-05-31 13:53:50','SYNCED','68a7881a-ea83-4e50-b8af-b28454591c34',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.4.1.4.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'84740299-1f4d-41e0-ac34-8854d80684e2','','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_OCC_4aa37ef9-cd2d-4cfa-9436-a62cc782a27a_TOPLY__ZIP_','2022-02-04 15:01:40','2022-02-04 14:55:02','','2022-02-04 16:01:40','SYNCED','84740299-1f4d-41e0-ac34-8854d80684e2',0,'2022-02-04 16:01:40','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.12.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.622652,0.772747,-0.123153,0,-0.782499,0.614892,-0.0979959,0,-5.00422e-9,0.157385,0.987537,0,-21.5256,-19.2669,-19.1349,1\",\"referenceScanID\":\"1.12.1.1.1\",\"title\":\"Maxillaire 1.12.1.1.1 Occlusion 1\"}'),(1001,'848ef817-dbc7-482b-a5da-58b2b9fffcd1','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/fa7fa96b-f393-4b9a-8198-144702462cfa/session_4bed076c-8541-4a2f-800a-5aeb4cb49de5/occlusion_16b82fca-4b65-4866-af87-1f6dbb42f5dc/computedocclusion_94a0167c-6798-4c78-a76c-cb9fc91ccdda/35_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_fa7fa96b-f393-4b9a-8198-144702462cfa_ACT_4bed076c-8541-4a2f-800a-5aeb4cb49de5_SESS_16b82fca-4b65-4866-af87-1f6dbb42f5dc_OCC_94a0167c-6798-4c78-a76c-cb9fc91ccdda_TOMA__MATRX_','2022-06-28 15:03:44','2022-06-28 17:03:25','35_w1_o1_maxillaire_matrix_occ_file_0.m','2022-06-28 17:03:44','SYNCED','848ef817-dbc7-482b-a5da-58b2b9fffcd1',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.35.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.35.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.35.1.1.1 Occlusion 1\"}'),(1001,'84e32701-3099-4943-babb-39906f06e7db','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/207d6dbc-c19b-4726-a9b3-16235ae554cc/session_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35/occlusion_dc5762a3-c453-4166-8c86-82d23ac9f8a6/computedocclusion_3a1fff1c-0427-409c-aa94-06326e554d82/27_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_207d6dbc-c19b-4726-a9b3-16235ae554cc_ACT_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35_SESS_dc5762a3-c453-4166-8c86-82d23ac9f8a6_OCC_3a1fff1c-0427-409c-aa94-06326e554d82_TOMA__MATRX_','2022-05-30 11:09:39','2022-05-30 13:09:22','27_w1_o1_maxillaire_matrix_occ_file_0.m','2022-05-30 13:09:39','SYNCED','84e32701-3099-4943-babb-39906f06e7db',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.27.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.27.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.27.1.1.1 Occlusion 1\"}'),(1001,'84ef7dee-68bc-4559-a55c-25087ddf3f5a','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/9e399d73-4d2e-4bb8-af48-a4e597811faa/session_b1cf14ce-00a9-48b6-8654-dadde26073f1/occlusion_1060c95f-48f4-4a37-9b82-03bfd8329730/scan_eeb9263d-a9fc-46b4-942f-4d60ccb7716a/46_w1_o2_maxillaire_scan_file_0.zip','ZIP','PATIENT_9e399d73-4d2e-4bb8-af48-a4e597811faa_ACT_b1cf14ce-00a9-48b6-8654-dadde26073f1_SESS_1060c95f-48f4-4a37-9b82-03bfd8329730_TOSC_eeb9263d-a9fc-46b4-942f-4d60ccb7716a_ZIP_','2023-01-20 14:36:38','2023-01-20 15:36:17','46_w1_o2_maxillaire_scan_file_0.zip','2023-01-20 15:36:38','SYNCED','84ef7dee-68bc-4559-a55c-25087ddf3f5a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.46.1.2.2\",\"modelMatrix\":\"-0.455133,0.876235,-0.158324,0,-0.890423,-0.447881,0.0809262,0,7.81185e-10,0.177808,0.984065,0,6.79824,-33.2886,-19.4373,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'85261bd8-46e8-496a-bb3c-88c96e0ac5cb','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/09688939-f53f-4f00-8366-687b244de26d/session_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525/occlusion_9655a7e0-4673-41c9-90da-a48c008e2d62/scan_e8a97607-4009-48c5-b80b-9e6fdf2923ab/64_w1_o1_maxillaire_snapshot_2.png','SNAPS','PATIENT_09688939-f53f-4f00-8366-687b244de26d_ACT_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525_SESS_9655a7e0-4673-41c9-90da-a48c008e2d62_TOSC_e8a97607-4009-48c5-b80b-9e6fdf2923ab_SNAPS_','2023-03-30 11:48:31','2023-03-30 13:48:16','64_w1_o1_maxillaire_snapshot_2.png','2023-03-30 13:48:31','SYNCED','f092819c-0803-46cf-8485-b4106f5f883d',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.64.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'853e2356-bdec-4762-8140-becfdb0d014d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/computedocclusion_704a0750-2a24-448f-8f30-928139977895/4_w1_o2_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_OCC_704a0750-2a24-448f-8f30-928139977895_TOMA__MATRX_','2022-03-08 11:49:51','2022-03-08 12:49:34','4_w1_o2_maxillaire_matrix_occ_file_0.m','2022-03-08 12:49:51','SYNCED','853e2356-bdec-4762-8140-becfdb0d014d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.4.1.2.1 Occlusion 4\",\"referenceScanID\":\"1.4.1.2.1\",\"title\":\"Matrice Transfo. Maxillaire 1.4.1.2.1 Occlusion 4\"}'),(1001,'855f70ca-d5a8-443f-a159-e143b241ef33','','MATRX','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_OCC_e9a397c8-e329-4471-985b-0eb40ed458b0_BOMA__MATRX_','2022-02-04 15:01:40','2022-02-04 14:50:30','','2022-02-04 16:01:40','SYNCED','855f70ca-d5a8-443f-a159-e143b241ef33',0,'2022-02-04 16:01:40','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.12.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.12.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.12.1.1.1 Occlusion 1\"}'),(1001,'857f1cd7-a7cf-432d-ad31-31819c36b9f2','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/1c189ddc-0ee7-45e7-9d80-585dac08374a/session_01bd0635-6ec6-42cb-8561-8638bded352c/occlusion_2aa712ca-8b46-4a50-a03e-1c6a6a0c40fc/scan_2b27113d-3b20-4d7e-8591-1e87c6e97f79/29_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_1c189ddc-0ee7-45e7-9d80-585dac08374a_ACT_01bd0635-6ec6-42cb-8561-8638bded352c_SESS_2aa712ca-8b46-4a50-a03e-1c6a6a0c40fc_BOSC_2b27113d-3b20-4d7e-8591-1e87c6e97f79_ZIP_','2022-06-03 14:01:21','2022-06-03 16:01:13','29_w1_o1_mandibule_scan_file_0.zip','2022-06-03 16:01:21','SYNCED','857f1cd7-a7cf-432d-ad31-31819c36b9f2',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.29.1.1.1\",\"modelMatrix\":\"0.32521,0.939942,-0.103669,0,-0.945642,0.323249,-0.035652,0,-2.34477e-09,0.109628,0.993973,0,-1.47724,-13.3603,-18.8662,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'85ce73d9-1bb5-4991-8b1e-4b3013ada305','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/372000f2-2471-4a57-9b18-224d0788041f/session_5dd64d24-8e33-45bd-a282-c148c185c338/occlusion_a61fbfda-1ac5-4747-9e0c-6ef664930816/scan_555337af-b76d-49d5-a00a-d713c3576848/57_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_372000f2-2471-4a57-9b18-224d0788041f_ACT_5dd64d24-8e33-45bd-a282-c148c185c338_SESS_a61fbfda-1ac5-4747-9e0c-6ef664930816_TOSC_555337af-b76d-49d5-a00a-d713c3576848_ZIP_','2023-02-17 10:53:29','2023-02-17 11:53:22','57_w1_o1_maxillaire_scan_file_0.zip','2023-02-17 11:53:29','SYNCED','85ce73d9-1bb5-4991-8b1e-4b3013ada305',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.57.1.1.1\",\"modelMatrix\":\"0.954594,0.28713,-0.0794169,0,-0.297911,0.92005,-0.254475,0,6.91305e-09,0.26658,0.963813,0,6.25595,-2.61273,-21.3503,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'86054f2a-3ab1-4f70-867a-b472125f0c5f','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/372000f2-2471-4a57-9b18-224d0788041f/session_5dd64d24-8e33-45bd-a282-c148c185c338/occlusion_a61fbfda-1ac5-4747-9e0c-6ef664930816/computedocclusion_7eb0f2bf-a2c1-4938-b124-5a10e3cdb809/57_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_372000f2-2471-4a57-9b18-224d0788041f_ACT_5dd64d24-8e33-45bd-a282-c148c185c338_SESS_a61fbfda-1ac5-4747-9e0c-6ef664930816_OCC_7eb0f2bf-a2c1-4938-b124-5a10e3cdb809_TOMA__MATRX_','2023-02-17 10:55:37','2023-02-17 11:55:24','57_w1_o1_maxillaire_matrix_occ_file_0.m','2023-02-17 11:55:37','SYNCED','86054f2a-3ab1-4f70-867a-b472125f0c5f',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.57.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.57.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.57.1.1.1 Occlusion 1\"}'),(1001,'863f9ad3-76a4-468a-a090-fce9d97f5f46','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/9e399d73-4d2e-4bb8-af48-a4e597811faa/session_b1cf14ce-00a9-48b6-8654-dadde26073f1/occlusion_1060c95f-48f4-4a37-9b82-03bfd8329730/scan_dc6d76c9-cfba-4cfe-a7e7-1abff537cc46/46_w1_o2_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_9e399d73-4d2e-4bb8-af48-a4e597811faa_ACT_b1cf14ce-00a9-48b6-8654-dadde26073f1_SESS_1060c95f-48f4-4a37-9b82-03bfd8329730_LESC_dc6d76c9-cfba-4cfe-a7e7-1abff537cc46_SNAPS_','2023-01-20 13:56:41','2023-01-20 14:56:30','46_w1_o2_mordu_posterieur_gauche_snapshot_0.png','2023-01-20 14:56:41','SYNCED','863f9ad3-76a4-468a-a090-fce9d97f5f46',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.46.1.2.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'86411b04-6731-49a3-b09f-936337ac02f5','','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_OCC_764b8e22-8600-49e3-8d7c-d619725096ee_BOPLY__ZIP_','2022-02-04 18:20:41','2022-02-04 19:19:48','',NULL,'CREATED','86411b04-6731-49a3-b09f-936337ac02f5',0,'2022-02-04 19:20:41','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.5 Occlusion 2\",\"modelMatrix\":\"-0.996857,-0.0768567,0.0192233,0,0.0792243,-0.967066,0.241882,0,1.71456e-9,0.242644,0.970115,0,23.7843,9.22152,-23.0024,1\",\"referenceScanID\":\"1.13.1.1.5\",\"title\":\"Mandibule 1.13.1.1.5 Occlusion 2\"}'),(1001,'86743da6-1ee0-44f8-a265-3c6de7c6342a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/occlusion_e08bbeeb-a30b-428c-bd4a-40198f792219/computedocclusion_a503ab26-f707-4923-86b6-049c17f73533/25_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_SESS_e08bbeeb-a30b-428c-bd4a-40198f792219_OCC_a503ab26-f707-4923-86b6-049c17f73533_BOMA__MATRX_','2022-05-17 16:40:45','2022-05-17 18:40:25','25_w1_o1_mandibule_matrix_occ_file_0.m','2022-05-17 18:40:45','SYNCED','86743da6-1ee0-44f8-a265-3c6de7c6342a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.25.1.1.2 Occlusion 1\",\"referenceScanID\":\"1.25.1.1.2\",\"title\":\"Matrice Transfo. Mandibule 1.25.1.1.2 Occlusion 1\"}'),(1001,'868e124f-836f-40bb-b3c7-e53f71d4adf9','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/scan_71f637a7-a4e5-4025-8ef3-6af04a8febfe/54_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_BOSC_71f637a7-a4e5-4025-8ef3-6af04a8febfe_ZIP_','2022-12-13 09:37:11','2022-12-13 10:37:01','54_w1_o1_mandibule_scan_file_1.zip','2022-12-13 10:37:11','SYNCED','dfc86907-5d8b-40ce-9b7d-a4a2247a5b37',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.54.1.1.4\",\"modelMatrix\":\"-0.999599,0.0258183,-0.0116515,0,-0.0283256,-0.911116,0.411175,0,-3.36598e-10,0.41134,0.911482,0,17.4173,6.0967,-21.0427,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'86b21cde-953e-4edc-8019-a33d5fb66b55','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/8b4b6de2-edd8-44e6-88c6-8a151914aca6/session_40a1b174-1058-4d27-b63a-4e8f565fb520/occlusion_8eba4eab-4337-436a-8eb6-b59e63415159/computedocclusion_95fe0a5e-fe67-469d-aab1-023211e73996/48_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_8b4b6de2-edd8-44e6-88c6-8a151914aca6_ACT_40a1b174-1058-4d27-b63a-4e8f565fb520_SESS_8eba4eab-4337-436a-8eb6-b59e63415159_OCC_95fe0a5e-fe67-469d-aab1-023211e73996_BOPLY__ZIP_','2022-11-10 10:40:03','2022-11-10 11:39:57','48_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-11-10 11:40:03','SYNCED','86b21cde-953e-4edc-8019-a33d5fb66b55',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.48.1.1.1 Occlusion 1\",\"modelMatrix\":\"-0.906301,-0.394535,0.151527,0,0.422633,-0.846048,0.324936,0,7.6702e-09,0.35853,0.933518,0,0.185115,-5.31291,-22.554,1\",\"referenceScanID\":\"1.48.1.1.1\",\"title\":\"Mandibule 1.48.1.1.1 Occlusion 1\"}'),(1001,'86b2d86f-7b8b-44a7-923f-09446c74ced8','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/76279ff4-e4a6-4996-8d4e-c948146544b1/session_8b338ee6-5540-44a5-a587-286a7bfcbe14/occlusion_24569ac1-9195-47ea-beb2-d1d0f5543534/scan_b5b6924f-99a6-45ea-bd78-e085f00bc519/41_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_76279ff4-e4a6-4996-8d4e-c948146544b1_ACT_8b338ee6-5540-44a5-a587-286a7bfcbe14_SESS_24569ac1-9195-47ea-beb2-d1d0f5543534_BOSC_b5b6924f-99a6-45ea-bd78-e085f00bc519_SNAPS_','2022-10-07 10:40:37','2022-10-07 12:40:26','41_w1_o1_mandibule_snapshot_0.png','2022-10-07 12:40:37','SYNCED','86b2d86f-7b8b-44a7-923f-09446c74ced8',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.41.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'871e24f4-6581-4908-8713-9be13e9edaee','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/69640c87-271c-4a44-a6fa-67b01654cc27/session_5f9199b0-eb37-4ed3-8d1a-6c38505d4913/occlusion_991beec3-fe9e-4c98-a3d4-c98e4a4c2471/scan_b06956a5-97b1-485d-b20a-8c33bd91a0ed/39_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_TOSC_b06956a5-97b1-485d-b20a-8c33bd91a0ed_SNAPS_','2022-09-09 16:14:04','2022-09-09 18:04:15','39_w1_o1_maxillaire_snapshot_0.png','2022-09-09 18:14:04','SYNCED','871e24f4-6581-4908-8713-9be13e9edaee',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.39.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'87755a4f-dd8f-4169-b738-20996e645f56','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/scan_f2bad12a-451d-406d-98b0-e431a37951dd/19_w1_o1_mandibule_scan_file_4.zip','ZIP','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_BOSC_f2bad12a-451d-406d-98b0-e431a37951dd_ZIP_','2022-03-08 11:20:54','2022-03-08 12:20:45','19_w1_o1_mandibule_scan_file_4.zip','2022-03-08 12:20:54','SYNCED','e3a545cc-fe2a-418f-9896-979b09c1f684',4,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.1.4\",\"modelMatrix\":\"-0.997375,0.0673092,-0.0266838,0,-0.0724055,-0.927175,0.367565,0,1.7712e-09,0.368533,0.929615,0,24.2057,-23.2621,-22.074,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'87793239-db83-47f0-aaf5-9d71d182412c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a9e7a1ae-2d71-448f-80f6-19d916912a3c/session_07012a03-2a1e-44e4-9bc9-17e726862bc2/occlusion_ab83a8b7-1eb1-4b13-9594-40d6479b2b19/scan_e33a7de9-6d02-41e0-b621-fc99e53eb96c/52_w1_o1_mandibule_scan_file_3.zip','ZIP','PATIENT_a9e7a1ae-2d71-448f-80f6-19d916912a3c_ACT_07012a03-2a1e-44e4-9bc9-17e726862bc2_SESS_ab83a8b7-1eb1-4b13-9594-40d6479b2b19_BOSC_e33a7de9-6d02-41e0-b621-fc99e53eb96c_ZIP_','2022-11-29 10:49:46','2022-11-29 11:49:39','52_w1_o1_mandibule_scan_file_3.zip','2022-11-29 11:49:46','SYNCED','f2bb5b23-86c9-420a-a191-087935901024',3,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.52.1.1.1\",\"modelMatrix\":\"-0.53956,0.824006,-0.172884,0,-0.841947,-0.528063,0.110793,0,-4.37339e-09,0.205339,0.978691,0,5.37466,-10.5225,-21.0272,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'87bda901-4876-4455-b2fb-8e60ef75b135','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/986374de-c4d7-4d6f-bf0c-2dc7e3b859a9/session_c81670ed-4144-4347-b19e-8057d11b5f7c/occlusion_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be/scan_67168b1b-2bef-47a9-8e7f-994731a82831/28_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_986374de-c4d7-4d6f-bf0c-2dc7e3b859a9_ACT_c81670ed-4144-4347-b19e-8057d11b5f7c_SESS_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be_BOSC_67168b1b-2bef-47a9-8e7f-994731a82831_SNAPS_','2022-05-31 10:50:31','2022-05-31 12:50:22','28_w1_o1_mandibule_snapshot_1.png','2022-05-31 12:50:31','SYNCED','bb28b621-dccb-4c99-8175-e391881f0c0e',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.28.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'87de1c3d-bc9e-4ad8-b453-1999183a60da','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/69640c87-271c-4a44-a6fa-67b01654cc27/session_5f9199b0-eb37-4ed3-8d1a-6c38505d4913/occlusion_991beec3-fe9e-4c98-a3d4-c98e4a4c2471/scan_5f9e4be9-4eec-45c8-937d-583b1a5e8642/39_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_BOSC_5f9e4be9-4eec-45c8-937d-583b1a5e8642_ZIP_','2022-09-09 16:14:15','2022-09-09 18:14:04','39_w1_o1_mandibule_scan_file_0.zip','2022-09-09 18:14:15','SYNCED','87de1c3d-bc9e-4ad8-b453-1999183a60da',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.39.1.1.1\",\"modelMatrix\":\"-0.977808,0.200729,-0.0599951,0,-0.209503,-0.936857,0.280013,0,3.36067e-09,0.286368,0.95812,0,23.2439,5.67049,-19.9331,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'87f8ddbc-407e-47c4-9fb5-a72ab20b2c82','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/scan_c1f909ab-5469-4839-84f1-d04759dd1237/1_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_BOSC_c1f909ab-5469-4839-84f1-d04759dd1237_SNAPS_','2022-01-19 12:59:28','2022-01-19 11:56:05','1_w1_o1_mandibule_snapshot_1.png','2022-01-19 13:59:28','SYNCED','ae626f34-952a-4c2f-ac1a-1aad95d218b5',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.1.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'8807cbe4-80d2-4af2-9e28-4ad511514e42','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/computedocclusion_d5bff097-1085-4c55-afe3-1ce57126d88f/19_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_OCC_d5bff097-1085-4c55-afe3-1ce57126d88f_BOPLY__ZIP_','2022-03-08 11:16:13','2022-03-08 12:15:58','19_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-03-08 12:16:13','SYNCED','8807cbe4-80d2-4af2-9e28-4ad511514e42',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.1.4 Occlusion 2\",\"modelMatrix\":\"-0.988793,0.145775,-0.0322113,0,-0.149292,-0.965503,0.213343,0,-2.16806e-09,0.215761,0.976446,0,23.0578,-21.2539,-25.059,1\",\"referenceScanID\":\"1.19.1.1.4\",\"title\":\"Mandibule 1.19.1.1.4 Occlusion 2\"}'),(1001,'88162920-1788-49ea-ae0d-e172762106ef','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/scan_999aa1db-d517-4b25-8095-2a4a53e4d5af/4_w1_o4_mordu_anterieur_scan_file_0.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_FRSC_999aa1db-d517-4b25-8095-2a4a53e4d5af_ZIP_','2022-05-31 12:07:26','2022-05-31 14:07:19','4_w1_o4_mordu_anterieur_scan_file_0.zip','2022-05-31 14:07:26','SYNCED','88162920-1788-49ea-ae0d-e172762106ef',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.4.1.4.1\",\"modelMatrix\":\"0.942484,-0.00016389,-0.32861,0,0.0846161,0.979005,0.174406,0,0.323822,-0.205455,0.928457,0,-2.77743,12.6811,-23.5226,1\",\"title\":\"Mordu anterieur ZIP\"}'),(1001,'881fa71e-8ff2-48d9-90d7-929e8ee439ed','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/e922efb9-8c03-445b-8a0f-449e3c43bdca/session_a2369349-1629-40ad-8784-d271bc3fbade/occlusion_292cc1aa-8b12-463b-87a1-7d9731cf886b/computedocclusion_f9f6d9d2-cc34-43c3-9f5f-4b8e54b41bbb/21_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_e922efb9-8c03-445b-8a0f-449e3c43bdca_ACT_a2369349-1629-40ad-8784-d271bc3fbade_SESS_292cc1aa-8b12-463b-87a1-7d9731cf886b_OCC_f9f6d9d2-cc34-43c3-9f5f-4b8e54b41bbb_SNAPO__SNAPS_','2022-04-21 08:53:24','2022-04-21 10:53:03','21_w1_o1_snapshot_occ_file_0.png','2022-04-21 10:53:24','SYNCED','881fa71e-8ff2-48d9-90d7-929e8ee439ed',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'8828114d-b2b9-4aee-b553-1025354571bd','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a0c21836-ba79-4f15-9e35-02ef8211a9e5/session_0aac522d-3c38-465a-a1e0-014166c140ac/occlusion_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042/scan_dda4ec6d-010a-4593-be9f-97cb59747424/7_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_a0c21836-ba79-4f15-9e35-02ef8211a9e5_ACT_0aac522d-3c38-465a-a1e0-014166c140ac_SESS_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042_BOSC_dda4ec6d-010a-4593-be9f-97cb59747424_SNAPS_','2022-01-21 11:56:13','2022-01-21 12:49:05','7_w1_o1_mandibule_snapshot_0.png','2022-01-21 12:56:13','SYNCED','8828114d-b2b9-4aee-b553-1025354571bd',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.7.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'883e54e7-1599-4931-8155-5059841504be','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a4b302c-278d-4e12-ace5-f095ba0bf856/session_6206892a-2e7e-4765-ac90-b49bfb465997/occlusion_7ec70f78-dc80-40c5-b293-570a59f034c4/scan_9ad9c2d5-a3f4-4d4d-a153-085fbf878be4/3_w1_o2_maxillaire_scan_file_0.zip','ZIP','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_7ec70f78-dc80-40c5-b293-570a59f034c4_TOSC_9ad9c2d5-a3f4-4d4d-a153-085fbf878be4_ZIP_','2022-09-06 09:20:27','2022-08-30 14:24:50','3_w1_o2_maxillaire_scan_file_0.zip','2022-09-06 11:20:27','SYNCED','883e54e7-1599-4931-8155-5059841504be',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.3.1.2.4\",\"modelMatrix\":\"0.899865,0.418474,-0.122975,0,-0.436169,0.863358,-0.25371,0,-2.79404e-09,0.281943,0.959431,0,-27.175,-4.50248,-15.2315,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'88640868-b443-422b-9ce1-edb6ee0d5186','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/scan_6ea822c6-54a6-4a11-823d-b366ee2d3af3/54_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_RISC_6ea822c6-54a6-4a11-823d-b366ee2d3af3_ZIP_','2022-12-13 09:53:39','2022-12-13 10:53:33','54_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-12-13 10:53:39','SYNCED','88640868-b443-422b-9ce1-edb6ee0d5186',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.54.1.1.1\",\"modelMatrix\":\"0.968072,-0.100035,0.232209,0,0.112701,0.992328,-0.0501975,0,-0.22392,0.0727084,0.971374,0,7.21946,-4.70336,-17.9475,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'888bb95f-87d1-41f4-8484-d4032b4e50da','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/69640c87-271c-4a44-a6fa-67b01654cc27/session_5f9199b0-eb37-4ed3-8d1a-6c38505d4913/occlusion_991beec3-fe9e-4c98-a3d4-c98e4a4c2471/scan_b06956a5-97b1-485d-b20a-8c33bd91a0ed/39_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_TOSC_b06956a5-97b1-485d-b20a-8c33bd91a0ed_ZIP_','2022-09-09 16:04:32','2022-09-09 18:04:17','39_w1_o1_maxillaire_scan_file_0.zip','2022-09-09 18:04:32','SYNCED','888bb95f-87d1-41f4-8484-d4032b4e50da',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.39.1.1.1\",\"modelMatrix\":\"-0.226177,0.929302,-0.291961,0,-0.974086,-0.215779,0.0677916,0,7.55513e-09,0.299728,0.954025,0,-12.3361,-28.543,-16.1754,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'88efb696-eab9-4f14-8212-702210d91d21','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/de078619-3946-4adb-a799-1c260e16face/session_24d0aeb5-3058-4070-aeea-97c289e41e3c/occlusion_ea6da896-1504-41fc-890c-7c48575e9e40/scan_cf9b0360-b96a-4e1a-a219-fdaa6228f9f7/2_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_de078619-3946-4adb-a799-1c260e16face_ACT_24d0aeb5-3058-4070-aeea-97c289e41e3c_SESS_ea6da896-1504-41fc-890c-7c48575e9e40_BOSC_cf9b0360-b96a-4e1a-a219-fdaa6228f9f7_ZIP_','2022-01-19 14:38:49','2022-01-19 15:38:26','2_w1_o1_mandibule_scan_file_0.zip','2022-01-19 15:38:49','SYNCED','88efb696-eab9-4f14-8212-702210d91d21',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.2.1.1.3\",\"modelMatrix\":\"0.874383,0.484915,-0.0176853,0,-0.485237,0.873802,-0.0318683,0,-9.67484e-11,0.0364466,0.999336,0,-5.867,-23.6052,-21.5014,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'88fc0d88-3578-4e5d-8232-72899553634d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5a33a64b-822d-40bf-ba8c-e11c11a50f88/session_e0a7776f-79fe-4c85-85ab-9ca244e7ff95/occlusion_b3568df2-4c54-486e-b27f-2d92375e5d11/scan_247ba975-b9ca-41c4-8c63-f046d64da761/43_w1_o1_mandibule_scan_file_2.zip','ZIP','PATIENT_5a33a64b-822d-40bf-ba8c-e11c11a50f88_ACT_e0a7776f-79fe-4c85-85ab-9ca244e7ff95_SESS_b3568df2-4c54-486e-b27f-2d92375e5d11_BOSC_247ba975-b9ca-41c4-8c63-f046d64da761_ZIP_','2022-10-11 14:26:55','2022-10-11 16:26:43','43_w1_o1_mandibule_scan_file_2.zip','2022-10-11 16:26:55','SYNCED','3ba9a25c-db9a-443b-a917-fb6c9cc3c459',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.43.1.1.1\",\"modelMatrix\":\"-0.647586,0.736517,-0.195386,0,-0.761993,-0.625935,0.16605,0,-8.9215e-09,0.256414,0.966567,0,26.4523,-15.617,-20.2306,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'8929cc33-5776-4799-a4b1-27a26c789c50','','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_BOSC_f8b316c9-3008-451e-bdae-0fb8163c2756_ZIP_','2022-02-19 17:53:24','2022-02-18 16:58:20','','2022-02-19 18:53:24','SYNCED','8929cc33-5776-4799-a4b1-27a26c789c50',0,'2022-02-19 18:53:24','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.4.3\",\"modelMatrix\":\"0.472687,-0.855054,0.213187,0,0.88123,0.458647,-0.114352,0,3.40632e-10,0.24192,0.970296,0,-25.6765,11.8374,-25.3711,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'8973e491-6d80-40a4-bc85-a683da016b38','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5/order_91244c8f-7f97-48da-b467-a8573c445713/24_w2_bridge_prost_file_8973e491-6d80-40a4-bc85-a683da016b38_0.pdf','PDF','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5_PROST_91244c8f-7f97-48da-b467-a8573c445713_PDF_','2022-10-07 17:24:40','2022-10-07 19:24:39','24_w2_bridge_prost_file_8973e491-6d80-40a4-bc85-a683da016b38_0.pdf','2022-10-07 19:24:40','SYNCED','8973e491-6d80-40a4-bc85-a683da016b38',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.24.2.1 BRIDGE\",\"title\":\"Bridge PDF\"}'),(1001,'89ef84d7-f87e-42c3-9de6-209f884ce814','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/490e4b04-6edd-4f47-a2ed-232689892eca/session_62105a91-1675-4d36-88bd-34aa8fe2ce3c/order_b11dc8d6-e6dd-4909-828a-f37cd72df06b/56_w1_inlay_onlay_prost_file_89ef84d7-f87e-42c3-9de6-209f884ce814_0.pdf','PDF','PATIENT_490e4b04-6edd-4f47-a2ed-232689892eca_ACT_62105a91-1675-4d36-88bd-34aa8fe2ce3c_PROST_b11dc8d6-e6dd-4909-828a-f37cd72df06b_PDF_','2023-02-17 16:21:28','2023-02-17 17:21:26','56_w1_inlay_onlay_prost_file_89ef84d7-f87e-42c3-9de6-209f884ce814_0.pdf','2023-02-17 17:21:28','SYNCED','89ef84d7-f87e-42c3-9de6-209f884ce814',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.56.1.1 INLAY ONLAY\",\"title\":\"Inlay/Onlay PDF\"}'),(1001,'8a1c834b-07aa-49e7-9b05-4fab52a0e619','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3cc1b522-8e7d-4196-87a1-a8c234f0a399/session_ef503949-33e8-4db6-bbfa-456bd8b70b73/occlusion_e8e2758f-faa4-4db7-93df-e94ddfbd8284/scan_faa0b909-907b-4833-9e89-c2e8eec90e95/51_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_3cc1b522-8e7d-4196-87a1-a8c234f0a399_ACT_ef503949-33e8-4db6-bbfa-456bd8b70b73_SESS_e8e2758f-faa4-4db7-93df-e94ddfbd8284_RISC_faa0b909-907b-4833-9e89-c2e8eec90e95_SNAPS_','2022-11-28 17:08:35','2022-11-28 18:08:27','51_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-11-28 18:08:35','SYNCED','8a1c834b-07aa-49e7-9b05-4fab52a0e619',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.51.1.1.2\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'8a4ad7fe-8660-4de4-87fc-e34225ca52a0','','SNAPS','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_OCC_778ed9fd-f658-471d-9dd0-a48417419cba_SNAPO__SNAPS_','2022-05-12 12:32:06','2022-05-12 14:31:43','',NULL,'CREATED','8a4ad7fe-8660-4de4-87fc-e34225ca52a0',0,'2022-05-12 14:32:06','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'8a72c490-d57c-49ed-a392-7053d70d734d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/de078619-3946-4adb-a799-1c260e16face/session_24d0aeb5-3058-4070-aeea-97c289e41e3c/occlusion_ea6da896-1504-41fc-890c-7c48575e9e40/computedocclusion_a15a6719-2996-4256-93d7-515e4d4f5bef/2_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_de078619-3946-4adb-a799-1c260e16face_ACT_24d0aeb5-3058-4070-aeea-97c289e41e3c_SESS_ea6da896-1504-41fc-890c-7c48575e9e40_OCC_a15a6719-2996-4256-93d7-515e4d4f5bef_BOPLY__ZIP_','2022-01-19 14:47:19','2022-01-19 15:46:49','2_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-01-19 15:47:19','SYNCED','8a72c490-d57c-49ed-a392-7053d70d734d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.2.1.1.3 Occlusion 1\",\"modelMatrix\":\"0.874383,0.484915,-0.0176853,0,-0.485237,0.873802,-0.0318683,0,-9.67484e-11,0.0364466,0.999336,0,-5.867,-23.6052,-21.5014,1\",\"referenceScanID\":\"1.2.1.1.3\",\"title\":\"Mandibule 1.2.1.1.3 Occlusion 1\"}'),(1001,'8aa4c440-2665-4042-8dfd-a5325566690b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/e922efb9-8c03-445b-8a0f-449e3c43bdca/session_a2369349-1629-40ad-8784-d271bc3fbade/occlusion_292cc1aa-8b12-463b-87a1-7d9731cf886b/scan_171c6386-cba0-454c-a194-380c61a2ad2d/21_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_e922efb9-8c03-445b-8a0f-449e3c43bdca_ACT_a2369349-1629-40ad-8784-d271bc3fbade_SESS_292cc1aa-8b12-463b-87a1-7d9731cf886b_BOSC_171c6386-cba0-454c-a194-380c61a2ad2d_ZIP_','2022-04-21 08:45:31','2022-04-21 10:45:21','21_w1_o1_mandibule_scan_file_0.zip','2022-04-21 10:45:31','SYNCED','8aa4c440-2665-4042-8dfd-a5325566690b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.21.1.1.1\",\"modelMatrix\":\"-0.976637,0.206889,-0.0581121,0,-0.214896,-0.94025,0.264102,0,1.90262e-09,0.27042,0.962742,0,12.5761,-24.3862,-20.0904,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'8ab0f382-00a1-414e-85cf-03b8c8c61c1a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/9efbbbe9-fd0a-44b1-988c-23571aad69fa/session_595a54fa-ae7d-4880-86a1-168b20242ecf/occlusion_b84a2165-e2d4-47e5-b110-a34bcaa24341/scan_8c9464fc-bf15-473a-926a-02d3f3803deb/53_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_9efbbbe9-fd0a-44b1-988c-23571aad69fa_ACT_595a54fa-ae7d-4880-86a1-168b20242ecf_SESS_b84a2165-e2d4-47e5-b110-a34bcaa24341_TOSC_8c9464fc-bf15-473a-926a-02d3f3803deb_SNAPS_','2022-12-02 14:07:28','2022-12-02 14:56:52','53_w1_o1_maxillaire_snapshot_0.png','2022-12-02 15:07:28','SYNCED','8ab0f382-00a1-414e-85cf-03b8c8c61c1a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.53.1.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'8abd4aff-4149-4b51-88d0-1fbc53ed918e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a9e7a1ae-2d71-448f-80f6-19d916912a3c/session_07012a03-2a1e-44e4-9bc9-17e726862bc2/occlusion_ab83a8b7-1eb1-4b13-9594-40d6479b2b19/scan_a1886540-b940-443f-ab31-a8c077fd49b6/52_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_a9e7a1ae-2d71-448f-80f6-19d916912a3c_ACT_07012a03-2a1e-44e4-9bc9-17e726862bc2_SESS_ab83a8b7-1eb1-4b13-9594-40d6479b2b19_BOSC_a1886540-b940-443f-ab31-a8c077fd49b6_SNAPS_','2022-11-29 11:09:14','2022-11-29 12:09:12','52_w1_o1_maxillaire_snapshot_0.png','2022-11-29 12:09:14','SYNCED','8abd4aff-4149-4b51-88d0-1fbc53ed918e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.52.1.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'8b0696ff-a902-4672-a040-5a87cb3b99b4','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f4fc00ec-4af8-4a15-b427-f1c5aabf6260/session_498ae60a-23f0-44fc-9730-be499bfc4b46/occlusion_8f3d6c73-3468-45a5-85c7-93bba47ec9f7/computedocclusion_9c318e86-fa90-4cd9-8319-2503cde2b455/30_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_f4fc00ec-4af8-4a15-b427-f1c5aabf6260_ACT_498ae60a-23f0-44fc-9730-be499bfc4b46_SESS_8f3d6c73-3468-45a5-85c7-93bba47ec9f7_OCC_9c318e86-fa90-4cd9-8319-2503cde2b455_BOMA__MATRX_','2022-06-14 13:30:12','2022-06-14 15:29:56','30_w1_o1_mandibule_matrix_occ_file_0.m','2022-06-14 15:30:12','SYNCED','8b0696ff-a902-4672-a040-5a87cb3b99b4',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.30.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.30.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.30.1.1.1 Occlusion 1\"}'),(1001,'8b42d22a-98cb-4e9c-a858-7b70d7c0d02d','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/98aa55d8-3848-48e0-9684-5597786b85c7/session_4df1e430-5cbb-4a6c-8292-747e35e6f1e8/occlusion_fcc5c65d-b0e4-4036-99c7-07318171986a/scan_7f834d30-6edc-49a1-b9dc-728cf5d87890/66_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_98aa55d8-3848-48e0-9684-5597786b85c7_ACT_4df1e430-5cbb-4a6c-8292-747e35e6f1e8_SESS_fcc5c65d-b0e4-4036-99c7-07318171986a_BOSC_7f834d30-6edc-49a1-b9dc-728cf5d87890_ZIP_','2023-04-13 10:02:26','2023-04-13 12:02:26','66_w1_o1_mandibule_scan_file_0.zip',NULL,'CREATED','8b42d22a-98cb-4e9c-a858-7b70d7c0d02d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.66.1.1.1\",\"modelMatrix\":\"-0.923812,-0.379561,0.0500422,0,0.382846,-0.915886,0.120753,0,6.6084e-11,0.130711,0.99142,0,7.56438,20.0402,-22.0421,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'8b4811ff-6b4d-4a89-8bc6-aea9d3654444','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/7c3827a5-fcb4-4892-bab3-8d6a4e6382f0/session_cb98e8a0-e16d-4640-919e-9b968e57d3db/occlusion_29633526-06c5-413c-8029-9f27d6a28b53/scan_17a5344a-a805-47a7-ab5e-4f0f9f2b7ff0/63_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_7c3827a5-fcb4-4892-bab3-8d6a4e6382f0_ACT_cb98e8a0-e16d-4640-919e-9b968e57d3db_SESS_29633526-06c5-413c-8029-9f27d6a28b53_BOSC_17a5344a-a805-47a7-ab5e-4f0f9f2b7ff0_ZIP_','2023-03-20 14:48:33','2023-03-20 15:48:02','63_w1_o1_mandibule_scan_file_0.zip','2023-03-20 15:48:33','SYNCED','8b4811ff-6b4d-4a89-8bc6-aea9d3654444',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.63.1.1.1\",\"modelMatrix\":\"-0.896858,0.424423,-0.124545,0,-0.442319,-0.860571,0.25253,0,5.95706e-09,0.281572,0.95954,0,26.6491,-2.7541,-18.0083,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'8b48514f-d8d7-4e30-a7b7-9ff34435a5d8','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/computedocclusion_35af1bf5-285a-4bb1-a6db-fe9897defe51/23_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_35af1bf5-285a-4bb1-a6db-fe9897defe51_TOMA__MATRX_','2022-05-13 12:11:24','2022-05-13 14:11:07','23_w1_o1_maxillaire_matrix_occ_file_0.m','2022-05-13 14:11:24','SYNCED','8b48514f-d8d7-4e30-a7b7-9ff34435a5d8',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.23.1.1.1 Occlusion 4\",\"referenceScanID\":\"1.23.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.23.1.1.1 Occlusion 4\"}'),(1001,'8b55178c-b238-40bd-8ce4-2f27f23d3b91','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/occlusion_e08bbeeb-a30b-428c-bd4a-40198f792219/scan_6aeb3c55-f3f0-4e74-9793-ec74659a28ad/25_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_SESS_e08bbeeb-a30b-428c-bd4a-40198f792219_BOSC_6aeb3c55-f3f0-4e74-9793-ec74659a28ad_ZIP_','2022-05-17 16:28:24','2022-05-17 18:28:16','25_w1_o1_mandibule_scan_file_1.zip','2022-05-17 18:28:24','SYNCED','22087293-2aac-4313-989b-8aa120c20399',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.25.1.1.2\",\"modelMatrix\":\"-0.964287,0.263246,-0.0291771,0,-0.264858,-0.958419,0.106227,0,5.11078e-10,0.110162,0.993914,0,-2.81379,1.33022,-23.6936,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'8b995262-9a19-4f27-a906-f0a97ad14a3e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/32710234-804f-46f5-899d-eed636f8a906/session_64c1427a-b91d-4675-94df-f36bd40e9b0f/occlusion_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a/computedocclusion_84d73896-4c7a-4dc0-994a-b2a70e3d1cf2/33_w2_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_32710234-804f-46f5-899d-eed636f8a906_ACT_64c1427a-b91d-4675-94df-f36bd40e9b0f_SESS_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a_OCC_84d73896-4c7a-4dc0-994a-b2a70e3d1cf2_TOMA__MATRX_','2022-06-28 09:07:13','2022-06-28 11:07:03','33_w2_o1_maxillaire_matrix_occ_file_0.m','2022-06-28 11:07:13','SYNCED','8b995262-9a19-4f27-a906-f0a97ad14a3e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.33.2.1.1 Occlusion 1\",\"referenceScanID\":\"1.33.2.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.33.2.1.1 Occlusion 1\"}'),(1001,'8c039687-ab70-4517-86c7-e23040f284be','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/ccc47f1d-1705-4945-aa08-da5aa64d251f/session_09e7d062-6ceb-4577-a66e-100bb8dad6d4/occlusion_eb899adb-91e6-4341-90ff-6ebabd7bbe76/scan_30ef0426-9437-4021-b70c-62779b73e0eb/44_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_ccc47f1d-1705-4945-aa08-da5aa64d251f_ACT_09e7d062-6ceb-4577-a66e-100bb8dad6d4_SESS_eb899adb-91e6-4341-90ff-6ebabd7bbe76_BOSC_30ef0426-9437-4021-b70c-62779b73e0eb_ZIP_','2022-10-18 17:04:34','2022-10-18 19:04:28','44_w1_o1_mandibule_scan_file_1.zip','2022-10-18 19:04:34','SYNCED','6f3fad33-5703-4627-aee6-c2e3c90c18e0',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.44.1.1.4\",\"modelMatrix\":\"-0.955362,-0.284213,0.0806551,0,0.295436,-0.919071,0.260817,0,-1.31391e-09,0.273004,0.962013,0,5.48815,-13.59,-19.5533,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'8c0459bd-0102-41f8-9d98-758b74f6b263','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/57c4096f-98dd-49c8-bea5-a5b109ad3fd0/session_4f62e395-5623-4d5b-869c-1b2fc4d22b00/occlusion_1ac20dc7-b36b-4786-a05f-37091554dc5c/computedocclusion_70f4220e-2a6b-4575-bd0e-09c14a13d758/31_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_57c4096f-98dd-49c8-bea5-a5b109ad3fd0_ACT_4f62e395-5623-4d5b-869c-1b2fc4d22b00_SESS_1ac20dc7-b36b-4786-a05f-37091554dc5c_OCC_70f4220e-2a6b-4575-bd0e-09c14a13d758_BOMA__MATRX_','2022-06-16 11:04:12','2022-06-16 13:03:55','31_w1_o1_mandibule_matrix_occ_file_0.m','2022-06-16 13:04:12','SYNCED','8c0459bd-0102-41f8-9d98-758b74f6b263',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.31.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.31.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.31.1.1.1 Occlusion 1\"}'),(1001,'8c2859ce-3386-4052-b715-178d980197db','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_992e34fe-b7bb-45b7-a2c6-794c8211aba7/18_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_LESC_992e34fe-b7bb-45b7-a2c6-794c8211aba7_SNAPS_','2022-05-10 14:04:37','2022-05-10 16:04:30','18_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-05-10 16:04:37','SYNCED','8c2859ce-3386-4052-b715-178d980197db',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.18.1.1.2\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'8c489273-df3d-4efa-9d94-8ed6e0acc9ad','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/occlusion_a2220645-c79d-4dda-b6cc-772384a4106b/computedocclusion_8b14563e-0862-4cac-8045-e8aed2be886d/38_w1_o1_mlmeta_occ_file_to1000.bin','LIFIM','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_OCC_8b14563e-0862-4cac-8045-e8aed2be886d_LIFIMO_LIFIM_','2022-07-19 12:28:52','2022-07-19 14:28:51','38_w1_o1_mlmeta_occ_file_to1000.bin','2022-07-19 14:28:52','SYNCED','8c489273-df3d-4efa-9d94-8ed6e0acc9ad',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.38.1.1.1 Occlusion 1 Ligne de finition 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"Maxillaire\",\"name\":\"Ligne de finition 0\",\"title\":\"Ligne finition metadata\",\"toothNumber\":1000}'),(1001,'8c5e3045-d56c-4c59-b5d8-d6c8dc5854b4','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/98aa55d8-3848-48e0-9684-5597786b85c7/session_4df1e430-5cbb-4a6c-8292-747e35e6f1e8/occlusion_fcc5c65d-b0e4-4036-99c7-07318171986a/computedocclusion_f2517330-f76d-418d-8d59-e56eb543a090/66_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_98aa55d8-3848-48e0-9684-5597786b85c7_ACT_4df1e430-5cbb-4a6c-8292-747e35e6f1e8_SESS_fcc5c65d-b0e4-4036-99c7-07318171986a_OCC_f2517330-f76d-418d-8d59-e56eb543a090_TOPLY__ZIP_','2023-04-13 10:07:20','2023-04-13 12:07:20','66_w1_o1_maxillaire_occlusion_occ_file_0.zip',NULL,'CREATED','8c5e3045-d56c-4c59-b5d8-d6c8dc5854b4',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.66.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.66.1.1.1\",\"title\":\"Maxillaire 1.66.1.1.1 Occlusion 1\"}'),(1001,'8c67e607-f4c9-46bb-81c6-75ee3f55af66','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/986374de-c4d7-4d6f-bf0c-2dc7e3b859a9/session_c81670ed-4144-4347-b19e-8057d11b5f7c/occlusion_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be/scan_d969cedf-8de4-4e27-8d4d-f4a1e8eac60c/28_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_986374de-c4d7-4d6f-bf0c-2dc7e3b859a9_ACT_c81670ed-4144-4347-b19e-8057d11b5f7c_SESS_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be_TOSC_d969cedf-8de4-4e27-8d4d-f4a1e8eac60c_ZIP_','2022-05-31 10:30:35','2022-05-31 12:30:24','28_w1_o1_maxillaire_scan_file_0.zip','2022-05-31 12:30:35','SYNCED','8c67e607-f4c9-46bb-81c6-75ee3f55af66',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.28.1.1.1\",\"modelMatrix\":\"0.881614,0.469845,-0.0447426,0,-0.471971,0.877644,-0.0835766,0,-1.4504e-09,0.0947996,0.995496,0,-11.2843,-18.9837,-19.8455,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'8c69c578-53d3-4a85-8b22-b7992c482bdd','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_e8550560-cfe0-40a1-bfb3-992d471fbcb7/17_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_BOSC_e8550560-cfe0-40a1-bfb3-992d471fbcb7_SNAPS_','2022-02-07 11:46:52','2022-02-07 12:35:17','17_w1_o1_mandibule_snapshot_0.png','2022-02-07 12:46:52','SYNCED','8c69c578-53d3-4a85-8b22-b7992c482bdd',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.17.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'8cb87f22-d35d-4793-a20a-50613112660e','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/9e399d73-4d2e-4bb8-af48-a4e597811faa/session_b1cf14ce-00a9-48b6-8654-dadde26073f1/occlusion_1060c95f-48f4-4a37-9b82-03bfd8329730/scan_b1026ef6-2b78-490a-891d-1bce15f88b4a/46_w1_o2_maxillaire_snapshot_0.png','SNAPS','PATIENT_9e399d73-4d2e-4bb8-af48-a4e597811faa_ACT_b1cf14ce-00a9-48b6-8654-dadde26073f1_SESS_1060c95f-48f4-4a37-9b82-03bfd8329730_TOSC_b1026ef6-2b78-490a-891d-1bce15f88b4a_SNAPS_','2023-01-20 12:51:09','2023-01-20 13:50:40','46_w1_o2_maxillaire_snapshot_0.png','2023-01-20 13:51:09','SYNCED','8cb87f22-d35d-4793-a20a-50613112660e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.46.1.2.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'8cfaf9f9-8080-49e9-b968-1ab9f1cb1d34','','LIFIM','PATIENT_a9e7a1ae-2d71-448f-80f6-19d916912a3c_ACT_07012a03-2a1e-44e4-9bc9-17e726862bc2_SESS_ab83a8b7-1eb1-4b13-9594-40d6479b2b19_BOSC_e33a7de9-6d02-41e0-b621-fc99e53eb96c_LIFIM_','2022-12-22 08:46:51','2022-12-14 16:06:40','','2022-12-22 09:46:51','SYNCED','8cfaf9f9-8080-49e9-b968-1ab9f1cb1d34',0,'2022-12-22 09:46:51','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Mandibule 1.52.1.1.1 Ligne de finition 0\",\"name\":\"Ligne de finition 0\",\"title\":\"Mandibule LIFI_META\",\"toothNumber\":0,\"versionMarginLine\":1}'),(1001,'8cfef9ee-a9b8-4ffb-ba60-2be8fa0abd6a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/scan_f5ab063d-18f1-443e-b694-fd1ef20e9e78/4_w1_o4_mordu_posterieur_gauche_scan_file_1.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_LESC_f5ab063d-18f1-443e-b694-fd1ef20e9e78_ZIP_','2022-05-31 12:11:51','2022-05-31 14:11:43','4_w1_o4_mordu_posterieur_gauche_scan_file_1.zip','2022-05-31 14:11:51','SYNCED','9faedb0a-5c1a-4ea6-b027-8e5f8df16abc',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.4.1.4.1\",\"modelMatrix\":\"-0.975851,0.154861,0.174589,0,-0.121783,-0.985808,0.0697992,0,0.182191,0.0739001,0.982648,0,-4.64098,-3.66848,-19.0455,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'8d091250-13fa-4e1e-89d6-2dae08a91119','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/computedocclusion_704a0750-2a24-448f-8f30-928139977895/4_w1_o2_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_OCC_704a0750-2a24-448f-8f30-928139977895_BOMA__MATRX_','2022-03-08 11:49:51','2022-03-08 12:49:34','4_w1_o2_mandibule_matrix_occ_file_0.m','2022-03-08 12:49:51','SYNCED','8d091250-13fa-4e1e-89d6-2dae08a91119',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.4.1.2.3 Occlusion 4\",\"referenceScanID\":\"1.4.1.2.3\",\"title\":\"Matrice Transfo. Mandibule 1.4.1.2.3 Occlusion 4\"}'),(1001,'8d1bd14c-e811-4bca-828b-4f1629ec9192','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/452a5200-3e06-4b74-8949-6abc7f2dda8a/session_3e95d626-668f-45f7-98ad-be2cf9d7b90b/occlusion_bce8310f-eee9-4f0a-a6b7-d592dec66be5/scan_bd194eb4-5c69-43b1-94bb-66c7ae8aa0ce/26_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_452a5200-3e06-4b74-8949-6abc7f2dda8a_ACT_3e95d626-668f-45f7-98ad-be2cf9d7b90b_SESS_bce8310f-eee9-4f0a-a6b7-d592dec66be5_BOSC_bd194eb4-5c69-43b1-94bb-66c7ae8aa0ce_ZIP_','2022-05-24 13:01:24','2022-05-24 11:15:00','26_w1_o1_maxillaire_scan_file_0.zip','2022-05-24 15:01:24','SYNCED','8d1bd14c-e811-4bca-828b-4f1629ec9192',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.26.1.1.2\",\"modelMatrix\":\"-0.440993,0.868318,-0.227045,0,-0.89751,-0.426649,0.111559,0,-1.10485e-08,0.252972,0.967474,0,8.55795,-16.8564,-17.5092,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'8d28fe7d-78b8-4718-992a-cf4d0a619f5a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/scan_90beda40-67c7-49a2-88be-64610235c1c8/19_w1_o1_mordu_anterieur_scan_file_0.zip','ZIP','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_FRSC_90beda40-67c7-49a2-88be-64610235c1c8_ZIP_','2022-03-08 11:12:11','2022-03-08 12:12:03','19_w1_o1_mordu_anterieur_scan_file_0.zip','2022-03-08 12:12:11','SYNCED','8d28fe7d-78b8-4718-992a-cf4d0a619f5a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.19.1.1.1\",\"modelMatrix\":\"0.98938,-0.145581,-0.0368645,0,0.141631,0.988719,0.0299436,0,0.0330974,-0.0356012,0.998872,0,-1.19359,1.82809,-19.3955,1\",\"title\":\"Mordu anterieur ZIP\"}'),(1001,'8d2fe9bc-4164-43b6-bdca-e21ff9b44241','','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_cb4cdc08-5d89-48dc-80a3-2e659c55f971_TOPLY__ZIP_','2022-02-08 08:49:00','2022-02-07 18:52:17','','2022-02-08 09:49:00','SYNCED','8d2fe9bc-4164-43b6-bdca-e21ff9b44241',0,'2022-02-08 09:49:00','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.17.1.1.1 Occlusion 4\",\"modelMatrix\":\"0.149253,0.920186,-0.361913,0,-0.988799,0.138896,-0.0546284,0,-8.90892e-10,0.366013,0.93061,0,-24.4594,-29.735,-12.8678,1\",\"referenceScanID\":\"1.17.1.1.1\",\"title\":\"Maxillaire 1.17.1.1.1 Occlusion 4\"}'),(1001,'8d4aee7a-6819-4016-b51b-71ba7ffaadea','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/986374de-c4d7-4d6f-bf0c-2dc7e3b859a9/session_c81670ed-4144-4347-b19e-8057d11b5f7c/occlusion_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be/computedocclusion_7a5acfd0-87ca-4009-aa4e-677a88ceffde/28_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_986374de-c4d7-4d6f-bf0c-2dc7e3b859a9_ACT_c81670ed-4144-4347-b19e-8057d11b5f7c_SESS_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be_OCC_7a5acfd0-87ca-4009-aa4e-677a88ceffde_BOPLY__ZIP_','2022-05-31 10:54:03','2022-05-31 12:53:55','28_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-05-31 12:54:03','SYNCED','8d4aee7a-6819-4016-b51b-71ba7ffaadea',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.28.1.1.1 Occlusion 1\",\"modelMatrix\":\"-0.906695,-0.381018,0.180913,0,0.421787,-0.819056,0.3889,0,-1.14174e-08,0.428921,0.903342,0,15.4673,-8.13965,-18.6147,1\",\"referenceScanID\":\"1.28.1.1.1\",\"title\":\"Mandibule 1.28.1.1.1 Occlusion 1\"}'),(1001,'8dee1a22-5c57-440d-a9c7-a5399fa77ed9','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_7b68804e-41db-41a7-9a19-d1aaecf91ab5/17_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_LESC_7b68804e-41db-41a7-9a19-d1aaecf91ab5_SNAPS_','2022-02-07 11:46:36','2022-02-07 12:40:30','17_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-02-07 12:46:36','SYNCED','8dee1a22-5c57-440d-a9c7-a5399fa77ed9',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.17.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'8e3b2146-f0cf-465d-9fe3-fdbb0b0d4d1e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_44561518-16e3-45bd-af90-fefe4eca9d27/24_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_RISC_44561518-16e3-45bd-af90-fefe4eca9d27_ZIP_','2022-06-13 14:53:08','2022-06-13 16:53:03','24_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-06-13 16:53:08','SYNCED','8e3b2146-f0cf-465d-9fe3-fdbb0b0d4d1e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.24.1.1.2\",\"modelMatrix\":\"0.997486,0.0216524,0.0587864,0,-0.0311832,0.997277,0.0740198,0,-0.0642751,-0.0708235,0.995562,0,8.9883,6.43936,-14.8856,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'8e862ac1-432a-45be-97fa-1ea4891400dc','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_16f04a07-72e8-4a39-9b55-3ae7405733af/24_w1_o1_maxillaire_snapshot_3.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_TOSC_16f04a07-72e8-4a39-9b55-3ae7405733af_SNAPS_','2022-06-13 14:49:08','2022-06-13 16:48:54','24_w1_o1_maxillaire_snapshot_3.png','2022-06-13 16:49:08','SYNCED','ace017e9-ff30-403f-aee6-3daa66025d8d',3,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.4\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'8ea607dc-1d2b-4e4a-b322-adf646386525','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/8b4b6de2-edd8-44e6-88c6-8a151914aca6/session_40a1b174-1058-4d27-b63a-4e8f565fb520/occlusion_8eba4eab-4337-436a-8eb6-b59e63415159/computedocclusion_95fe0a5e-fe67-469d-aab1-023211e73996/48_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_8b4b6de2-edd8-44e6-88c6-8a151914aca6_ACT_40a1b174-1058-4d27-b63a-4e8f565fb520_SESS_8eba4eab-4337-436a-8eb6-b59e63415159_OCC_95fe0a5e-fe67-469d-aab1-023211e73996_TOPLY__ZIP_','2022-11-10 10:40:09','2022-11-10 11:39:57','48_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-11-10 11:40:09','SYNCED','8ea607dc-1d2b-4e4a-b322-adf646386525',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.48.1.1.1 Occlusion 1\",\"modelMatrix\":\"-0.526021,0.80673,-0.269239,0,-0.850472,-0.498966,0.166525,0,5.70245e-09,0.316575,0.948567,0,9.33839,-11.7194,-21.0173,1\",\"referenceScanID\":\"1.48.1.1.1\",\"title\":\"Maxillaire 1.48.1.1.1 Occlusion 1\"}'),(1001,'8eda3198-1641-40d1-9780-28a91fd9f253','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/1a8329eb-7dbc-4bfd-b669-6d92e13fec0c/session_11fb4259-c305-4a08-b750-536f769f44b0/occlusion_129468ab-1f43-4ba1-8939-49286128bf4d/scan_be01aaf8-9fe4-4356-a76d-15d6d39e3fe3/47_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_1a8329eb-7dbc-4bfd-b669-6d92e13fec0c_ACT_11fb4259-c305-4a08-b750-536f769f44b0_SESS_129468ab-1f43-4ba1-8939-49286128bf4d_BOSC_be01aaf8-9fe4-4356-a76d-15d6d39e3fe3_ZIP_','2022-10-21 16:12:13','2022-10-21 18:12:05','47_w1_o1_mandibule_scan_file_0.zip','2022-10-21 18:12:13','SYNCED','8eda3198-1641-40d1-9780-28a91fd9f253',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.47.1.1.1\",\"modelMatrix\":\"-0.871132,0.482801,-0.0896172,0,-0.491048,-0.856502,0.158983,0,2.98549e-09,0.182502,0.983205,0,19.8346,-16.4076,-15.1435,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'8f22f90d-c07d-4fc3-b9fb-4529ff268063','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/57c4096f-98dd-49c8-bea5-a5b109ad3fd0/session_4f62e395-5623-4d5b-869c-1b2fc4d22b00/occlusion_1ac20dc7-b36b-4786-a05f-37091554dc5c/scan_7d899967-a5be-43f7-acbd-42d4237792d4/31_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_57c4096f-98dd-49c8-bea5-a5b109ad3fd0_ACT_4f62e395-5623-4d5b-869c-1b2fc4d22b00_SESS_1ac20dc7-b36b-4786-a05f-37091554dc5c_TOSC_7d899967-a5be-43f7-acbd-42d4237792d4_ZIP_','2022-06-16 10:52:48','2022-06-16 12:52:39','31_w1_o1_maxillaire_scan_file_0.zip','2022-06-16 12:52:48','SYNCED','8f22f90d-c07d-4fc3-b9fb-4529ff268063',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.31.1.1.1\",\"modelMatrix\":\"0.997887,0.0642305,-0.00984649,0,-0.0649809,0.986364,-0.151209,0,-4.81543e-10,0.151529,0.988453,0,-2.47476,-6.56649,-21.1676,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'8f26da38-e26c-4658-9fd5-f0e614308ff9','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_2a7068fc-0efa-496f-ade9-aba5b0650655/12_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_2a7068fc-0efa-496f-ade9-aba5b0650655_ZIP_','2022-02-04 11:52:26','2022-02-04 12:52:03','12_w1_o1_mandibule_scan_file_1.zip','2022-02-04 12:52:26','SYNCED','44ebcd6f-57c2-4cce-96f5-f9faa1c6b373',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.5\",\"modelMatrix\":\"0.860642,-0.488202,0.144758,0,0.509211,0.825133,-0.244663,0,-4.02363e-9,0.284279,0.958741,0,-6.04134,30.4631,-28.4285,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'8f3ff963-3c36-45c7-aeef-20558e20e496','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_4ed7adaa-3b77-4537-8479-4d0c4bd28c7b/12_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_TOSC_4ed7adaa-3b77-4537-8479-4d0c4bd28c7b_SNAPS_','2022-01-27 11:58:08','2022-01-27 12:54:59','12_w1_o1_maxillaire_snapshot_0.png','2022-01-27 12:58:08','SYNCED','8f3ff963-3c36-45c7-aeef-20558e20e496',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.12.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'8f69f135-daef-4f4b-a1a0-3aa76fb92de1','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/4a3954e0-1e2f-4721-9fdd-4180380dc19f/session_33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416/occlusion_3accbada-5a51-4d10-88d1-c3e7d8598d6f/computedocclusion_5775815f-f076-48af-be27-50e4dbfd3622/34_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_4a3954e0-1e2f-4721-9fdd-4180380dc19f_ACT_33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416_SESS_3accbada-5a51-4d10-88d1-c3e7d8598d6f_OCC_5775815f-f076-48af-be27-50e4dbfd3622_BOMA__MATRX_','2022-06-28 10:56:19','2022-06-28 12:55:54','34_w1_o1_mandibule_matrix_occ_file_0.m','2022-06-28 12:56:19','SYNCED','8f69f135-daef-4f4b-a1a0-3aa76fb92de1',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.34.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.34.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.34.1.1.1 Occlusion 1\"}'),(1001,'8fad8e23-1383-4caa-82af-9d2868bbffb8','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_ce625ba7-4218-40af-b344-df718da13f83/54_w1_o1_maxillaire_matrix_occ_file_2.m','MATRX','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_ce625ba7-4218-40af-b344-df718da13f83_TOMA__MATRX_','2023-03-15 10:16:47','2023-03-15 11:15:19','54_w1_o1_maxillaire_matrix_occ_file_2.m','2023-03-15 11:16:47','SYNCED','ccf7be44-96c0-48d2-80d6-833cb64e29bc',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.54.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.54.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.54.1.1.1 Occlusion 1\"}'),(1001,'8fb05be8-f57e-46ea-9abd-c2f8b7e453bc','','ZIP','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_65f9077d-c859-4b2c-9d4d-692d723315a5_BOPLY__ZIP_','2022-05-13 12:07:43','2022-05-13 14:07:00','','2022-05-13 14:07:43','SYNCED','8fb05be8-f57e-46ea-9abd-c2f8b7e453bc',0,'2022-05-13 14:07:43','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.23.1.1.1 Occlusion 4\",\"modelMatrix\":\"0.99884,-0.00870968,0.0473501,0,0.0481445,0.180697,-0.98236,0,-1.26898e-10,0.9835,0.180907,0,0.872294,-19.7028,-3.24839,1\",\"referenceScanID\":\"1.23.1.1.1\",\"title\":\"Mandibule 1.23.1.1.1 Occlusion 4\"}'),(1001,'8fb19261-9e70-4678-8a85-98e89dd98dcb','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/scan_f2bad12a-451d-406d-98b0-e431a37951dd/19_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_BOSC_f2bad12a-451d-406d-98b0-e431a37951dd_SNAPS_','2022-03-08 10:38:42','2022-03-08 11:38:34','19_w1_o1_mandibule_snapshot_0.png','2022-03-08 11:38:42','SYNCED','8fb19261-9e70-4678-8a85-98e89dd98dcb',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.1.4\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'8fccf724-5a93-4f6d-8056-653d4b6b830f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/45ff7437-0691-4427-a7da-8250862e4b96/session_4ff9c682-c09d-42ff-8c29-aeb13e066ed2/occlusion_934673c1-a4b9-4508-ac1b-a03092a0693e/scan_8d7fa4fe-ab8d-4b70-b921-fabf93cf9f25/9_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_45ff7437-0691-4427-a7da-8250862e4b96_ACT_4ff9c682-c09d-42ff-8c29-aeb13e066ed2_SESS_934673c1-a4b9-4508-ac1b-a03092a0693e_RISC_8d7fa4fe-ab8d-4b70-b921-fabf93cf9f25_SNAPS_','2022-01-24 17:46:38','2022-01-24 18:45:21','9_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-01-24 18:46:38','SYNCED','8fccf724-5a93-4f6d-8056-653d4b6b830f',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.9.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'9009fa0f-5f5b-491f-b430-198a7ef6e5a6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_93b9b214-5793-480a-b05f-e0419802faf3/12_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_LESC_93b9b214-5793-480a-b05f-e0419802faf3_SNAPS_','2022-02-04 12:19:20','2022-02-04 13:17:21','12_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-02-04 13:19:20','SYNCED','9009fa0f-5f5b-491f-b430-198a7ef6e5a6',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.12.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'901c6e3e-fe86-4c38-9bde-1921d9f62a90','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/scan_3743c984-7cdf-4a7a-bb8e-522e16ccb6e4/4_w1_o4_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_FRSC_3743c984-7cdf-4a7a-bb8e-522e16ccb6e4_SNAPS_','2022-05-31 12:16:25','2022-05-31 14:16:17','4_w1_o4_mordu_anterieur_snapshot_0.png','2022-05-31 14:16:25','SYNCED','901c6e3e-fe86-4c38-9bde-1921d9f62a90',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.4.1.4.2\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'9026aa67-b409-4693-81c4-92607b3386a1','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/computedocclusion_0bc29ff9-efea-448d-b521-2c39fd4faa78/19_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_OCC_0bc29ff9-efea-448d-b521-2c39fd4faa78_TOMA__MATRX_','2022-03-08 11:18:04','2022-03-08 12:17:37','19_w1_o1_maxillaire_matrix_occ_file_0.m','2022-03-08 12:18:04','SYNCED','9026aa67-b409-4693-81c4-92607b3386a1',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.19.1.1.1 Occlusion 3\",\"referenceScanID\":\"1.19.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.19.1.1.1 Occlusion 3\"}'),(1001,'902ec464-8030-4908-b872-2aa60ec542d8','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/207d6dbc-c19b-4726-a9b3-16235ae554cc/session_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35/occlusion_dc5762a3-c453-4166-8c86-82d23ac9f8a6/scan_9a90e42e-88ee-4808-8ae4-399e7285a1d0/27_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_207d6dbc-c19b-4726-a9b3-16235ae554cc_ACT_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35_SESS_dc5762a3-c453-4166-8c86-82d23ac9f8a6_TOSC_9a90e42e-88ee-4808-8ae4-399e7285a1d0_SNAPS_','2022-05-30 10:55:02','2022-05-30 12:54:51','27_w1_o1_maxillaire_snapshot_0.png','2022-05-30 12:55:02','SYNCED','902ec464-8030-4908-b872-2aa60ec542d8',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.27.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'9055105b-b138-4723-8426-bb8b57a97a50','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/533d4409-e39d-4a27-a0af-b59e6cf76ce3/session_319a8f1d-33fc-4f87-a108-b3eabda0510f/occlusion_3b38f07b-42cb-40b1-933f-365e568702e4/scan_109ca2c4-8222-4d02-9ac7-b4b93937e1e2/37_w1_o1_maxillaire_snapshot_3.png','SNAPS','PATIENT_533d4409-e39d-4a27-a0af-b59e6cf76ce3_ACT_319a8f1d-33fc-4f87-a108-b3eabda0510f_SESS_3b38f07b-42cb-40b1-933f-365e568702e4_TOSC_109ca2c4-8222-4d02-9ac7-b4b93937e1e2_SNAPS_','2022-07-07 16:05:55','2022-07-07 18:05:43','37_w1_o1_maxillaire_snapshot_3.png','2022-07-07 18:05:55','SYNCED','6fa5ad33-3773-4801-9f0b-ed36985cc55e',3,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.37.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'911094e4-fe1d-4725-b083-95706a95ce27','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/discussion_4d12bcc3-80f2-49dc-9159-54929f160ce6/911094e4-fe1d-4725-b083-95706a95ce27.m','MATRX','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_426bd908-3163-4291-a697-20eacff771ab_BOMA__MATRX_','2022-05-25 08:56:23','2022-05-16 19:57:11','911094e4-fe1d-4725-b083-95706a95ce27.m','2022-05-25 10:56:23','SYNCED','911094e4-fe1d-4725-b083-95706a95ce27',0,'2022-05-25 10:56:23','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.24.1.1.1 Occlusion 6\",\"referenceScanID\":\"1.24.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.24.1.1.1 Occlusion 6\"}'),(1001,'91975b1f-684b-4717-9edb-bec57444b873','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_7048f93c-1091-4f02-bc64-b73347dfa962/24_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_RISC_7048f93c-1091-4f02-bc64-b73347dfa962_ZIP_','2022-06-13 15:00:13','2022-06-13 17:00:06','24_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-06-13 17:00:13','SYNCED','91975b1f-684b-4717-9edb-bec57444b873',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.24.1.1.3\",\"modelMatrix\":\"0.996985,-0.00432956,0.0671889,0,0.0129732,0.991367,0.136127,0,-0.0794612,-0.13248,0.988467,0,-1.91791,-2.8084,-17.3973,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'91bc9544-42d1-4de0-9184-79f217dab1d6','','ZIP','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_RISC_4cf74467-a55c-46b5-99f6-e0f80fd19b31_ZIP_','2022-09-09 16:30:10','2022-09-09 18:22:24','','2022-09-09 18:30:10','SYNCED','91bc9544-42d1-4de0-9184-79f217dab1d6',0,'2022-09-09 18:30:10','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.39.1.1.3\",\"modelMatrix\":\"0.972701,0.23083,0.0172,0,-0.230455,0.970014,-0.0774539,0,-0.0280687,0.0762563,0.996881,0,12.3932,2.3166,-17.9958,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'91c78cb3-fa9c-4ddc-a426-8d7913857428','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/scan_f2bad12a-451d-406d-98b0-e431a37951dd/19_w1_o1_mandibule_snapshot_4.png','SNAPS','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_BOSC_f2bad12a-451d-406d-98b0-e431a37951dd_SNAPS_','2022-03-08 11:20:54','2022-03-08 12:20:43','19_w1_o1_mandibule_snapshot_4.png','2022-03-08 12:20:54','SYNCED','8fb19261-9e70-4678-8a85-98e89dd98dcb',4,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.1.4\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'91e406d3-a205-49ce-8101-9fdaade0241b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/32710234-804f-46f5-899d-eed636f8a906/session_64c1427a-b91d-4675-94df-f36bd40e9b0f/occlusion_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a/scan_62c04472-88fd-4ac5-acbe-aefb92941897/33_w2_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_32710234-804f-46f5-899d-eed636f8a906_ACT_64c1427a-b91d-4675-94df-f36bd40e9b0f_SESS_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a_TOSC_62c04472-88fd-4ac5-acbe-aefb92941897_ZIP_','2022-06-28 08:50:38','2022-06-28 10:50:30','33_w2_o1_maxillaire_scan_file_0.zip','2022-06-28 10:50:38','SYNCED','91e406d3-a205-49ce-8101-9fdaade0241b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.33.2.1.1\",\"modelMatrix\":\"-0.712189,0.701711,-0.019724,0,-0.701988,-0.711908,0.0200107,0,1.61205e-10,0.0280974,0.999605,0,4.73611,1.67537,-20.9792,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'91e77307-7833-49da-b522-a802584e820d','','ZIP','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_BOSC_3379235c-b42d-440c-84bc-d105a1d56127_ZIP_','2022-03-09 07:54:47','2022-03-08 11:27:31','','2022-03-09 08:54:47','SYNCED','91e77307-7833-49da-b522-a802584e820d',0,'2022-03-09 08:54:47','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.1.2\",\"modelMatrix\":\"0.663561,-0.696268,0.273675,0,0.748123,0.617567,-0.242741,0,7.59721e-10,0.365816,0.930687,0,-11.4517,-3.047,-16.5035,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'920a762b-6fe8-4198-8bb1-e0c244ac1799','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/4a3954e0-1e2f-4721-9fdd-4180380dc19f/session_33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416/order_bfcc9c3f-f8b9-4984-af13-110825822614/34_w1_inlay_onlay_prost_file_920a762b-6fe8-4198-8bb1-e0c244ac1799_0.pdf','PDF','PATIENT_4a3954e0-1e2f-4721-9fdd-4180380dc19f_ACT_33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416_PROST_bfcc9c3f-f8b9-4984-af13-110825822614_PDF_','2022-06-28 17:31:32','2022-06-28 19:31:31','34_w1_inlay_onlay_prost_file_920a762b-6fe8-4198-8bb1-e0c244ac1799_0.pdf','2022-06-28 19:31:32','SYNCED','920a762b-6fe8-4198-8bb1-e0c244ac1799',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.34.1.1 INLAY ONLAY35 Marie josé\",\"title\":\"Inlay/Onlay PDF\"}'),(1001,'920f3016-ec04-481a-9403-cbf6252efb92','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_49bd090f-1a01-4a79-8202-62487b9af783/18_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_BOSC_49bd090f-1a01-4a79-8202-62487b9af783_ZIP_','2022-03-07 14:12:46','2022-03-07 15:12:44','18_w1_o1_mandibule_scan_file_1.zip','2022-03-07 15:12:46','SYNCED','48568b30-23dd-4d00-b4de-f54ce8d90d30',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.18.1.1.1\",\"modelMatrix\":\"-0.740045,-0.667159,0.0850427,0,0.672558,-0.734105,0.0935762,0,1.1198e-09,0.126447,0.991973,0,3.45916,-3.12895,-14.1428,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'921054d1-47e8-4f1e-bc8a-31fbbe128b59','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/09688939-f53f-4f00-8366-687b244de26d/session_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525/occlusion_9655a7e0-4673-41c9-90da-a48c008e2d62/computedocclusion_66955dfb-349e-49f8-89e5-06d0c4925036/64_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_09688939-f53f-4f00-8366-687b244de26d_ACT_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525_SESS_9655a7e0-4673-41c9-90da-a48c008e2d62_OCC_66955dfb-349e-49f8-89e5-06d0c4925036_TOMA__MATRX_','2023-03-30 12:18:21','2023-03-30 14:18:05','64_w1_o1_maxillaire_matrix_occ_file_0.m','2023-03-30 14:18:21','SYNCED','921054d1-47e8-4f1e-bc8a-31fbbe128b59',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.64.1.1.2 Occlusion 1\",\"referenceScanID\":\"1.64.1.1.2\",\"title\":\"Matrice Transfo. Maxillaire 1.64.1.1.2 Occlusion 1\"}'),(1001,'921fb52f-b180-40cb-95ac-af03083394e1','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/32710234-804f-46f5-899d-eed636f8a906/session_64c1427a-b91d-4675-94df-f36bd40e9b0f/occlusion_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a/scan_50213132-9c82-471d-8981-66894edf36a4/33_w2_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_32710234-804f-46f5-899d-eed636f8a906_ACT_64c1427a-b91d-4675-94df-f36bd40e9b0f_SESS_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a_RISC_50213132-9c82-471d-8981-66894edf36a4_ZIP_','2022-06-28 09:06:59','2022-06-28 11:06:50','33_w2_o1_mordu_posterieur_droit_scan_file_0.zip','2022-06-28 11:06:59','SYNCED','921fb52f-b180-40cb-95ac-af03083394e1',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.33.2.1.1\",\"modelMatrix\":\"0.833161,-0.0337151,0.555659,0,0.0430126,0.998334,-0.0149013,0,-0.551502,0.0488838,0.831315,0,-6.43315,-1.37286,-28.8896,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'9257a2cf-84d1-4817-925f-de9451a2228d','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/7c3827a5-fcb4-4892-bab3-8d6a4e6382f0/session_cb98e8a0-e16d-4640-919e-9b968e57d3db/occlusion_29633526-06c5-413c-8029-9f27d6a28b53/scan_ab6c69b1-8cac-45ec-8fee-f2371813f161/63_w1_o1_maxillaire_snapshot_2.png','SNAPS','PATIENT_7c3827a5-fcb4-4892-bab3-8d6a4e6382f0_ACT_cb98e8a0-e16d-4640-919e-9b968e57d3db_SESS_29633526-06c5-413c-8029-9f27d6a28b53_TOSC_ab6c69b1-8cac-45ec-8fee-f2371813f161_SNAPS_','2023-03-20 14:48:02','2023-03-20 15:40:24','63_w1_o1_maxillaire_snapshot_2.png','2023-03-20 15:48:02','SYNCED','4c80ac2a-8eb6-49d9-a363-ce9ac5090d47',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.63.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'926c10eb-7fb9-451f-a515-0fb23610d5ce','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_16f04a07-72e8-4a39-9b55-3ae7405733af/24_w1_o1_maxillaire_scan_file_2.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_TOSC_16f04a07-72e8-4a39-9b55-3ae7405733af_ZIP_','2022-06-13 14:45:22','2022-06-13 16:45:10','24_w1_o1_maxillaire_scan_file_2.zip','2022-06-13 16:45:22','SYNCED','d3ff533f-e540-46c8-8f68-b5341a94ad72',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.4\",\"modelMatrix\":\"0.522347,0.830611,-0.192972,0,-0.852733,0.508797,-0.118206,0,-1.09725e-09,0.226298,0.974058,0,-16.4252,-3.89119,-19.4472,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'92ac3820-79bd-4cff-bb6b-9e1be8e150cd','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3ed7a8e0-5b4d-4ecf-b4ae-f855b16c0f93/session_fb42cec6-0bb6-41e9-912d-0517ff8e0942/occlusion_fb214b2f-5e41-492d-85c4-d4a11a3947c5/scan_d7407f25-706b-455d-bad0-4ca82328f452/42_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_3ed7a8e0-5b4d-4ecf-b4ae-f855b16c0f93_ACT_fb42cec6-0bb6-41e9-912d-0517ff8e0942_SESS_fb214b2f-5e41-492d-85c4-d4a11a3947c5_BOSC_d7407f25-706b-455d-bad0-4ca82328f452_ZIP_','2022-10-07 11:44:32','2022-10-07 13:44:21','42_w1_o1_mandibule_scan_file_1.zip','2022-10-07 13:44:32','SYNCED','9b7a5ef7-049f-4ec1-9fae-f0cd8c13a8e9',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.42.1.1.1\",\"modelMatrix\":\"0.937148,-0.341928,0.0695603,0,0.348932,0.918338,-0.186823,0,2.8506e-09,0.199352,0.979928,0,-15.4329,23.391,-18.8334,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'92bcedb3-36d9-4116-a27b-d3bafd34b67b','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/98aa55d8-3848-48e0-9684-5597786b85c7/session_4df1e430-5cbb-4a6c-8292-747e35e6f1e8/occlusion_fcc5c65d-b0e4-4036-99c7-07318171986a/scan_9415795d-cf35-41d8-a989-d38dada847f9/66_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_98aa55d8-3848-48e0-9684-5597786b85c7_ACT_4df1e430-5cbb-4a6c-8292-747e35e6f1e8_SESS_fcc5c65d-b0e4-4036-99c7-07318171986a_TOSC_9415795d-cf35-41d8-a989-d38dada847f9_SNAPS_','2023-04-13 09:43:40','2023-04-13 11:43:40','66_w1_o1_maxillaire_snapshot_1.png',NULL,'CREATED','4de4c841-84ef-4a04-bb69-6b6aef451fd1',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.66.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'92be922c-d588-45df-a4be-47304ce445f7','','SNAPS','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_RISC_0f004b83-11e3-49ae-b25b-7872c0ac7485_SNAPS_','2022-09-10 08:18:17','2022-09-09 18:36:22','','2022-09-10 10:18:17','SYNCED','92be922c-d588-45df-a4be-47304ce445f7',0,'2022-09-10 10:18:17','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.39.1.1.5\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'92bf4f89-6d0d-4ee8-bd82-d36a90b3cacb','','SNAPS','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_OCC_87edc123-163f-46ce-be5c-45f2ff80b857_SNAPO__SNAPS_','2022-05-12 12:27:27','2022-05-12 14:26:51','','2022-05-12 14:27:27','SYNCED','92bf4f89-6d0d-4ee8-bd82-d36a90b3cacb',0,'2022-05-12 14:27:27','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'93208781-7d31-457e-9d61-61f5954a03e4','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_14264009-2f96-4841-9c75-17adb3424f9f/18_w1_o1_mordu_anterieur_snapshot_1.png','SNAPS','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_FRSC_14264009-2f96-4841-9c75-17adb3424f9f_SNAPS_','2022-03-07 14:38:04','2022-03-07 15:37:55','18_w1_o1_mordu_anterieur_snapshot_1.png','2022-03-07 15:38:04','SYNCED','9519696c-cd0e-413e-a068-1fb998797b48',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.18.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'932962cd-4bdf-4b00-9073-71f7803ce0f1','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/8b4b6de2-edd8-44e6-88c6-8a151914aca6/session_40a1b174-1058-4d27-b63a-4e8f565fb520/occlusion_8eba4eab-4337-436a-8eb6-b59e63415159/scan_356a169f-0c3a-464b-82af-2d744e3bef4a/48_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_8b4b6de2-edd8-44e6-88c6-8a151914aca6_ACT_40a1b174-1058-4d27-b63a-4e8f565fb520_SESS_8eba4eab-4337-436a-8eb6-b59e63415159_TOSC_356a169f-0c3a-464b-82af-2d744e3bef4a_ZIP_','2022-11-10 10:37:06','2022-11-10 11:36:59','48_w1_o1_maxillaire_scan_file_0.zip','2022-11-10 11:37:06','SYNCED','932962cd-4bdf-4b00-9073-71f7803ce0f1',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.48.1.1.1\",\"modelMatrix\":\"-0.526021,0.80673,-0.269239,0,-0.850472,-0.498966,0.166525,0,5.70245e-09,0.316575,0.948567,0,9.33839,-11.7194,-21.0173,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'932bea04-3b46-4f5e-a6a7-39b40b8f36f2','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3cc1b522-8e7d-4196-87a1-a8c234f0a399/session_ef503949-33e8-4db6-bbfa-456bd8b70b73/occlusion_e8e2758f-faa4-4db7-93df-e94ddfbd8284/scan_f50e5124-f992-40b4-97cd-258bc3037b29/51_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_3cc1b522-8e7d-4196-87a1-a8c234f0a399_ACT_ef503949-33e8-4db6-bbfa-456bd8b70b73_SESS_e8e2758f-faa4-4db7-93df-e94ddfbd8284_TOSC_f50e5124-f992-40b4-97cd-258bc3037b29_ZIP_','2022-11-28 16:45:31','2022-11-28 17:45:14','51_w1_o1_maxillaire_scan_file_0.zip','2022-11-28 17:45:31','SYNCED','932bea04-3b46-4f5e-a6a7-39b40b8f36f2',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.51.1.1.1\",\"modelMatrix\":\"0.640988,0.705762,-0.301717,0,-0.767551,0.589389,-0.251967,0,-8.30491e-10,0.393091,0.9195,0,-31.6037,-22.9644,-12.5807,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'937d393b-c2fe-4320-9988-a9d0e1e7f153','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/ca43bf7b-f931-42fc-bb75-05929e4b6578/session_d9740504-a9ca-472a-83f2-a309fa225a98/occlusion_d663165c-f330-4c61-8d1f-14869b6d5edd/scan_3de249d1-1631-4fd5-be9c-dd46b685c6c8/59_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_ca43bf7b-f931-42fc-bb75-05929e4b6578_ACT_d9740504-a9ca-472a-83f2-a309fa225a98_SESS_d663165c-f330-4c61-8d1f-14869b6d5edd_LESC_3de249d1-1631-4fd5-be9c-dd46b685c6c8_SNAPS_','2023-03-10 15:13:03','2023-03-10 16:12:48','59_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2023-03-10 16:13:03','SYNCED','937d393b-c2fe-4320-9988-a9d0e1e7f153',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.59.1.1.2\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(2,'93825ccc-d1f9-49ef-a00c-3634f15f5219','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a4b302c-278d-4e12-ace5-f095ba0bf856/session_6206892a-2e7e-4765-ac90-b49bfb465997/occlusion_3c30231c-7cd7-4431-985b-2eaf7f6925ae/scan_21743037-e185-4ce7-80aa-af01b0d42c2d/3_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_21743037-e185-4ce7-80aa-af01b0d42c2d_ZIP_','2022-09-06 09:17:55','2022-08-30 11:00:58','3_w1_o1_maxillaire_scan_file_0.zip','2022-09-06 11:17:55','SYNCED','93825ccc-d1f9-49ef-a00c-3634f15f5219',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.3.1.1.6\",\"modelMatrix\":\"0.884901,0.449075,-0.123616,0,-0.465778,0.853169,-0.234849,0,3.7488e-09,0.265396,0.96414,0,-28.3676,-3.7757,-16.7896,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'93a19afa-3bad-4510-bfa1-ee7dff7e1a61','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/593972a6-d7d6-4802-b87d-38aab371f71e/session_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480/occlusion_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3/scan_7338a694-0f0d-4c09-8c45-b4e4129978cb/3_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_593972a6-d7d6-4802-b87d-38aab371f71e_ACT_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480_SESS_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3_RISC_7338a694-0f0d-4c09-8c45-b4e4129978cb_SNAPS_','2022-01-19 15:16:53','2022-01-19 16:15:25','3_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-01-19 16:16:53','SYNCED','93a19afa-3bad-4510-bfa1-ee7dff7e1a61',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.3.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'93b583d3-838d-4554-b29d-bd2c88d92eac','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a20364ca-68f6-43af-9d85-5203eb8e7fd3/session_4fbadc34-458e-4383-9cea-ff5422d69287/occlusion_56872db7-25ba-4ec4-a526-b4254011197f/scan_3360b3d3-3f88-47f7-a1ce-b4e540b8369c/49_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_a20364ca-68f6-43af-9d85-5203eb8e7fd3_ACT_4fbadc34-458e-4383-9cea-ff5422d69287_SESS_56872db7-25ba-4ec4-a526-b4254011197f_TOSC_3360b3d3-3f88-47f7-a1ce-b4e540b8369c_ZIP_','2022-10-28 10:04:23','2022-10-28 12:04:10','49_w1_o1_maxillaire_scan_file_0.zip','2022-10-28 12:04:23','SYNCED','93b583d3-838d-4554-b29d-bd2c88d92eac',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.49.1.1.1\",\"modelMatrix\":\"0.355329,0.906621,-0.227551,0,-0.934741,0.344639,-0.0865001,0,-4.22439e-09,0.243437,0.969917,0,-21.9243,-14.9075,-17.7406,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'93d056fd-9cb6-4d4f-906f-4a02f6e3bbca','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/de078619-3946-4adb-a799-1c260e16face/session_24d0aeb5-3058-4070-aeea-97c289e41e3c/occlusion_ea6da896-1504-41fc-890c-7c48575e9e40/scan_cf9b0360-b96a-4e1a-a219-fdaa6228f9f7/2_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_de078619-3946-4adb-a799-1c260e16face_ACT_24d0aeb5-3058-4070-aeea-97c289e41e3c_SESS_ea6da896-1504-41fc-890c-7c48575e9e40_BOSC_cf9b0360-b96a-4e1a-a219-fdaa6228f9f7_SNAPS_','2022-01-19 14:38:49','2022-01-19 15:38:24','2_w1_o1_mandibule_snapshot_0.png','2022-01-19 15:38:49','SYNCED','93d056fd-9cb6-4d4f-906f-4a02f6e3bbca',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.2.1.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'93e015c7-46c1-406e-be60-bf0c78428875','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/occlusion_e08bbeeb-a30b-428c-bd4a-40198f792219/computedocclusion_a503ab26-f707-4923-86b6-049c17f73533/25_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_SESS_e08bbeeb-a30b-428c-bd4a-40198f792219_OCC_a503ab26-f707-4923-86b6-049c17f73533_TOMA__MATRX_','2022-05-17 16:40:45','2022-05-17 18:40:25','25_w1_o1_maxillaire_matrix_occ_file_0.m','2022-05-17 18:40:45','SYNCED','93e015c7-46c1-406e-be60-bf0c78428875',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.25.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.25.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.25.1.1.1 Occlusion 1\"}'),(1001,'93ed2900-e60f-4603-869c-35779261d045','','SNAPS','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_c9079d19-8ffb-46f7-a51e-3a7a90ccae59_SESS_8ba0f3b1-408f-4a02-92a0-63f09123b68e_LESC_f2611342-ebf4-4c08-b8d1-c7c38b1c7e7c_SNAPS_','2022-01-28 17:15:44','2022-01-27 14:27:08','','2022-01-28 18:15:44','SYNCED','93ed2900-e60f-4603-869c-35779261d045',0,'2022-01-28 18:15:44','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.10.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'940229ab-a331-4a49-b7b3-b9e41fcf61a5','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3cc1b522-8e7d-4196-87a1-a8c234f0a399/session_ef503949-33e8-4db6-bbfa-456bd8b70b73/occlusion_e8e2758f-faa4-4db7-93df-e94ddfbd8284/scan_196c009b-c574-426c-a21b-072953b20ef0/51_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_3cc1b522-8e7d-4196-87a1-a8c234f0a399_ACT_ef503949-33e8-4db6-bbfa-456bd8b70b73_SESS_e8e2758f-faa4-4db7-93df-e94ddfbd8284_BOSC_196c009b-c574-426c-a21b-072953b20ef0_SNAPS_','2022-11-28 17:01:35','2022-11-28 17:59:41','51_w1_o1_mandibule_snapshot_0.png','2022-11-28 18:01:35','SYNCED','940229ab-a331-4a49-b7b3-b9e41fcf61a5',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.51.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'941b2895-4d14-4eff-bae6-5aa44f38a0c6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_4f8dc275-857c-482a-9886-5521591e9661/scan_df08df19-150c-437d-8ed4-bf2826644265/12_w1_o4_mandibule_scan_file_1.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_BOSC_df08df19-150c-437d-8ed4-bf2826644265_ZIP_','2022-02-18 16:15:50','2022-02-18 17:15:36','12_w1_o4_mandibule_scan_file_1.zip','2022-02-18 17:15:50','SYNCED','68cf35d1-7f31-4f48-8b81-a07300151534',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.4.5\",\"modelMatrix\":\"0.569927,0.756194,-0.321488,0,-0.821696,0.524495,-0.222984,0,1.64912e-08,0.39125,0.920285,0,0.42327,-12.328,-18.8879,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'94d782f6-776b-412d-a94b-b5886a048a58','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/76279ff4-e4a6-4996-8d4e-c948146544b1/session_8b338ee6-5540-44a5-a587-286a7bfcbe14/occlusion_24569ac1-9195-47ea-beb2-d1d0f5543534/scan_8d33ab62-e242-47c7-aabd-f2419afc2e33/41_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_76279ff4-e4a6-4996-8d4e-c948146544b1_ACT_8b338ee6-5540-44a5-a587-286a7bfcbe14_SESS_24569ac1-9195-47ea-beb2-d1d0f5543534_TOSC_8d33ab62-e242-47c7-aabd-f2419afc2e33_ZIP_','2022-10-07 10:33:30','2022-10-07 12:33:17','41_w1_o1_maxillaire_scan_file_0.zip','2022-10-07 12:33:30','SYNCED','94d782f6-776b-412d-a94b-b5886a048a58',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.41.1.1.1\",\"modelMatrix\":\"-0.531312,0.815152,-0.230725,0,-0.847176,-0.511229,0.144701,0,6.87207e-10,0.272346,0.962199,0,-2.88734,-33.0451,-16.5435,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'94f85e53-53fa-4619-b521-dd644a72254d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/593972a6-d7d6-4802-b87d-38aab371f71e/session_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480/occlusion_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3/scan_0bf938e8-3ff3-4e2d-981d-f2db30285d60/3_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_593972a6-d7d6-4802-b87d-38aab371f71e_ACT_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480_SESS_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3_TOSC_0bf938e8-3ff3-4e2d-981d-f2db30285d60_ZIP_','2022-01-19 14:59:11','2022-01-19 15:58:40','3_w1_o1_maxillaire_scan_file_0.zip','2022-01-19 15:59:11','SYNCED','94f85e53-53fa-4619-b521-dd644a72254d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.3.1.1.1\",\"modelMatrix\":\"-0.8207,0.559215,-0.117173,0,-0.571359,-0.803257,0.168307,0,5.51916e-9,0.205077,0.978746,0,22.3383,-22.9288,-32.0145,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'9505a7cb-ab3e-4498-837a-c1d9163e0965','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_2a7068fc-0efa-496f-ade9-aba5b0650655/12_w1_o1_mandibule_snapshot_3.png','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_2a7068fc-0efa-496f-ade9-aba5b0650655_SNAPS_','2022-02-04 12:01:55','2022-02-04 13:01:37','12_w1_o1_mandibule_snapshot_3.png','2022-02-04 13:01:55','SYNCED','7636e0d7-f242-431c-90a5-a65399d83ecd',3,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.5\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'9519696c-cd0e-413e-a068-1fb998797b48','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_14264009-2f96-4841-9c75-17adb3424f9f/18_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_FRSC_14264009-2f96-4841-9c75-17adb3424f9f_SNAPS_','2022-03-07 14:37:56','2022-03-07 15:35:21','18_w1_o1_mordu_anterieur_snapshot_0.png','2022-03-07 15:37:56','SYNCED','9519696c-cd0e-413e-a068-1fb998797b48',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.18.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'9520544f-1e40-4c5c-96e3-0a4d3a25bb2e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3ed7a8e0-5b4d-4ecf-b4ae-f855b16c0f93/session_fb42cec6-0bb6-41e9-912d-0517ff8e0942/occlusion_fb214b2f-5e41-492d-85c4-d4a11a3947c5/computedocclusion_f6573412-d667-47a1-89b2-d0a46006380f/42_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_3ed7a8e0-5b4d-4ecf-b4ae-f855b16c0f93_ACT_fb42cec6-0bb6-41e9-912d-0517ff8e0942_SESS_fb214b2f-5e41-492d-85c4-d4a11a3947c5_OCC_f6573412-d667-47a1-89b2-d0a46006380f_TOMA__MATRX_','2022-10-07 17:38:20','2022-10-07 19:37:42','42_w1_o1_maxillaire_matrix_occ_file_0.m','2022-10-07 19:38:20','SYNCED','9520544f-1e40-4c5c-96e3-0a4d3a25bb2e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.42.1.1.1 Occlusion 5\",\"referenceScanID\":\"1.42.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.42.1.1.1 Occlusion 5\"}'),(1001,'95267990-f2d4-4cd6-b572-9f6c8fd29601','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/scan_f5ab063d-18f1-443e-b694-fd1ef20e9e78/4_w1_o4_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_LESC_f5ab063d-18f1-443e-b694-fd1ef20e9e78_SNAPS_','2022-05-31 12:11:44','2022-05-31 14:09:38','4_w1_o4_mordu_posterieur_gauche_snapshot_0.png','2022-05-31 14:11:44','SYNCED','95267990-f2d4-4cd6-b572-9f6c8fd29601',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.4.1.4.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'9536f005-a147-4c1b-81e6-1e7123ebdb38','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_b28164eb-0070-4968-83be-bfabe1a0c839/13_w1_o1_mandibule_scan_file_2.zip','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_b28164eb-0070-4968-83be-bfabe1a0c839_ZIP_','2022-02-04 17:56:22','2022-02-04 17:02:36','13_w1_o1_mandibule_scan_file_2.zip','2022-02-04 18:56:22','SYNCED','d8a3bf39-16d1-435f-bafa-6c625f77d811',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.5\",\"modelMatrix\":\"-0.980986,-0.182732,0.0653907,0,0.19408,-0.923628,0.33052,0,1.2429e-9,0.336927,0.941531,0,23.7056,9.64329,-24.5584,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'956b67f4-07f0-44b2-b8a6-306c6e892e15','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/09688939-f53f-4f00-8366-687b244de26d/session_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525/occlusion_9655a7e0-4673-41c9-90da-a48c008e2d62/computedocclusion_66955dfb-349e-49f8-89e5-06d0c4925036/64_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_09688939-f53f-4f00-8366-687b244de26d_ACT_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525_SESS_9655a7e0-4673-41c9-90da-a48c008e2d62_OCC_66955dfb-349e-49f8-89e5-06d0c4925036_BOPLY__ZIP_','2023-03-30 12:18:13','2023-03-30 14:18:05','64_w1_o1_mandibule_occlusion_occ_file_0.zip','2023-03-30 14:18:13','SYNCED','956b67f4-07f0-44b2-b8a6-306c6e892e15',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.64.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.00866116,0.968633,-0.248344,0,-0.999963,0.0083898,-0.00215103,0,-3.25436e-10,0.248353,0.96867,0,-10.1539,-7.59641,-17.4221,1\",\"referenceScanID\":\"1.64.1.1.1\",\"title\":\"Mandibule 1.64.1.1.1 Occlusion 1\"}'),(1001,'9579dfbd-0050-46ef-a609-46a26b77d0e9','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/scan_43a4533f-b510-4e1d-8a8e-bcb6dbd8b4d4/54_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_TOSC_43a4533f-b510-4e1d-8a8e-bcb6dbd8b4d4_SNAPS_','2022-12-13 09:51:51','2022-12-13 10:51:39','54_w1_o1_maxillaire_snapshot_1.png','2022-12-13 10:51:51','SYNCED','f857267a-a651-4ddd-9d8e-e5a3c3805875',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.54.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'95abe106-c7e0-46e2-a418-b9230da7dc76','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/ca43bf7b-f931-42fc-bb75-05929e4b6578/session_d9740504-a9ca-472a-83f2-a309fa225a98/occlusion_d663165c-f330-4c61-8d1f-14869b6d5edd/scan_50db8169-6393-4f74-b798-2e2afc5648cb/59_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_ca43bf7b-f931-42fc-bb75-05929e4b6578_ACT_d9740504-a9ca-472a-83f2-a309fa225a98_SESS_d663165c-f330-4c61-8d1f-14869b6d5edd_TOSC_50db8169-6393-4f74-b798-2e2afc5648cb_SNAPS_','2023-03-10 15:10:47','2023-03-10 16:10:30','59_w1_o1_maxillaire_snapshot_1.png','2023-03-10 16:10:47','SYNCED','d47aa112-54db-4d19-aff6-b7ebe01a8d27',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.59.1.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'95fef142-c1a4-400e-aaa1-9da1f54d0f99','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a9e7a1ae-2d71-448f-80f6-19d916912a3c/session_07012a03-2a1e-44e4-9bc9-17e726862bc2/occlusion_ab83a8b7-1eb1-4b13-9594-40d6479b2b19/scan_e33a7de9-6d02-41e0-b621-fc99e53eb96c/52_w1_o1_mandibule_scan_file_4.zip','ZIP','PATIENT_a9e7a1ae-2d71-448f-80f6-19d916912a3c_ACT_07012a03-2a1e-44e4-9bc9-17e726862bc2_SESS_ab83a8b7-1eb1-4b13-9594-40d6479b2b19_BOSC_e33a7de9-6d02-41e0-b621-fc99e53eb96c_ZIP_','2022-11-29 10:53:39','2022-11-29 11:53:32','52_w1_o1_mandibule_scan_file_4.zip','2022-11-29 11:53:39','SYNCED','f2bb5b23-86c9-420a-a191-087935901024',4,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.52.1.1.1\",\"modelMatrix\":\"-0.793457,0.598697,-0.109494,0,-0.608627,-0.780511,0.142745,0,-5.66587e-10,0.179903,0.983684,0,7.26468,-7.84251,-21.652,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'96dd75bb-5035-460a-8afc-04f3755604b1','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/scan_03839278-13f8-46e6-9581-ba11bc8bcb81/1_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_TOSC_03839278-13f8-46e6-9581-ba11bc8bcb81_ZIP_','2022-01-19 13:00:44','2022-01-19 10:24:18','1_w1_o1_maxillaire_scan_file_0.zip','2022-01-19 14:00:44','SYNCED','96dd75bb-5035-460a-8afc-04f3755604b1',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.1.1.1.1\",\"modelMatrix\":\"-0.169937,0.932851,-0.317664,0,-0.985455,-0.160866,0.0547797,0,-2.44953e-9,0.322353,0.94662,0,-14.6828,-39.2953,-12.5174,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'976c8ff2-0cca-43fe-8b36-f902660807ef','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/32710234-804f-46f5-899d-eed636f8a906/session_64c1427a-b91d-4675-94df-f36bd40e9b0f/occlusion_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a/computedocclusion_84d73896-4c7a-4dc0-994a-b2a70e3d1cf2/33_w2_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_32710234-804f-46f5-899d-eed636f8a906_ACT_64c1427a-b91d-4675-94df-f36bd40e9b0f_SESS_d0fbd250-95c7-46e7-91e5-b4bc46c85b4a_OCC_84d73896-4c7a-4dc0-994a-b2a70e3d1cf2_SNAPO__SNAPS_','2022-06-28 09:07:20','2022-06-28 11:07:03','33_w2_o1_snapshot_occ_file_0.png','2022-06-28 11:07:20','SYNCED','976c8ff2-0cca-43fe-8b36-f902660807ef',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'97714910-7f35-4b7d-95cd-64c6cf044087','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/scan_6f906ffa-4828-4d68-a894-572a056b896b/23_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_BOSC_6f906ffa-4828-4d68-a894-572a056b896b_SNAPS_','2022-05-13 10:06:36','2022-05-13 12:06:28','23_w1_o1_mandibule_snapshot_0.png','2022-05-13 12:06:36','SYNCED','97714910-7f35-4b7d-95cd-64c6cf044087',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.23.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'977518ea-ece1-49a3-8637-c97f53f5e63a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/occlusion_a2220645-c79d-4dda-b6cc-772384a4106b/computedocclusion_cf412dab-1d83-4db0-ae1b-d2724d5be97d/38_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_OCC_cf412dab-1d83-4db0-ae1b-d2724d5be97d_TOPLY__ZIP_','2022-07-12 11:04:31','2022-07-12 13:04:14','38_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-07-12 13:04:31','SYNCED','977518ea-ece1-49a3-8637-c97f53f5e63a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.38.1.1.3 Occlusion 2\",\"modelMatrix\":\"0.292113,0.953283,-0.0769574,0,-0.956384,0.291166,-0.0235055,0,3.79853e-10,0.0804671,0.996757,0,-4.50082,-22.5707,-20.6555,1\",\"referenceScanID\":\"1.38.1.1.3\",\"title\":\"Maxillaire 1.38.1.1.3 Occlusion 2\"}'),(1001,'9791ebc4-1ba3-48c6-918f-eb0a1f569c6c','','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_OCC_4aa37ef9-cd2d-4cfa-9436-a62cc782a27a_SNAPO__SNAPS_','2022-02-04 15:01:40','2022-02-04 14:55:02','','2022-02-04 16:01:40','SYNCED','9791ebc4-1ba3-48c6-918f-eb0a1f569c6c',0,'2022-02-04 16:01:40','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'97ab18d6-cb04-45a3-bc1e-20cc9ec07748','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a9e7a1ae-2d71-448f-80f6-19d916912a3c/session_07012a03-2a1e-44e4-9bc9-17e726862bc2/occlusion_ab83a8b7-1eb1-4b13-9594-40d6479b2b19/scan_e33a7de9-6d02-41e0-b621-fc99e53eb96c/52_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_a9e7a1ae-2d71-448f-80f6-19d916912a3c_ACT_07012a03-2a1e-44e4-9bc9-17e726862bc2_SESS_ab83a8b7-1eb1-4b13-9594-40d6479b2b19_BOSC_e33a7de9-6d02-41e0-b621-fc99e53eb96c_SNAPS_','2022-11-29 10:35:26','2022-11-29 11:35:17','52_w1_o1_mandibule_snapshot_1.png','2022-11-29 11:35:26','SYNCED','21764d52-2c8b-4d31-a0cd-af3f1985cd6e',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.52.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'97cbafa8-978a-4607-a2ab-e4b13a4afa8b','','SNAPS','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_c9079d19-8ffb-46f7-a51e-3a7a90ccae59_SESS_8ba0f3b1-408f-4a02-92a0-63f09123b68e_TOSC_44c8d5b1-b2de-4ba6-8ae5-8bc2a88e7918_SNAPS_','2022-01-28 17:15:44','2022-01-27 14:22:54','','2022-01-28 18:15:44','SYNCED','c7d8c731-2671-41fa-98d3-647d17160f01',1,'2022-01-28 18:15:44','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.10.1.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'982cc9f2-d1b9-4a80-8b75-25968f952051','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/09688939-f53f-4f00-8366-687b244de26d/session_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525/occlusion_9655a7e0-4673-41c9-90da-a48c008e2d62/scan_e8a97607-4009-48c5-b80b-9e6fdf2923ab/64_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_09688939-f53f-4f00-8366-687b244de26d_ACT_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525_SESS_9655a7e0-4673-41c9-90da-a48c008e2d62_TOSC_e8a97607-4009-48c5-b80b-9e6fdf2923ab_SNAPS_','2023-03-30 11:48:18','2023-03-30 13:46:15','64_w1_o1_maxillaire_snapshot_1.png','2023-03-30 13:48:18','SYNCED','f092819c-0803-46cf-8485-b4106f5f883d',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.64.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'98310ed4-08ed-4c33-9bbc-a4d6de7ad7d2','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/7e3c8022-95d1-493b-ae19-1ef6f0fb92b7/session_6b1bf3f0-e6ca-4308-90a1-40913836e82b/occlusion_f99ad630-118e-4401-ab53-bf0f5d925052/scan_ed06ae65-ea48-4491-b69a-e35fe196bdb3/65_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_7e3c8022-95d1-493b-ae19-1ef6f0fb92b7_ACT_6b1bf3f0-e6ca-4308-90a1-40913836e82b_SESS_f99ad630-118e-4401-ab53-bf0f5d925052_BOSC_ed06ae65-ea48-4491-b69a-e35fe196bdb3_SNAPS_','2023-03-31 14:54:50','2023-03-31 16:54:42','65_w1_o1_mandibule_snapshot_0.png','2023-03-31 16:54:50','SYNCED','98310ed4-08ed-4c33-9bbc-a4d6de7ad7d2',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.65.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'98432173-1253-48fa-b893-e2dd7ab26a00','','ZIP','PATIENT_593972a6-d7d6-4802-b87d-38aab371f71e_ACT_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480_SESS_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3_OCC_4e1258a6-b789-451f-bfe8-8b395e1129d8_BOPLY__ZIP_','2022-01-19 15:25:10','2022-01-19 16:24:43','',NULL,'CREATED','98432173-1253-48fa-b893-e2dd7ab26a00',0,'2022-01-19 16:25:10','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.3.1.1.1 Occlusion 3\",\"modelMatrix\":\"0.888791,-0.456948,0.035335,0,0.458312,0.886146,-0.0685242,0,1.93169e-9,0.0770982,0.997023,0,-18.6308,-12.394,-21.0367,1\",\"referenceScanID\":\"1.3.1.1.1\",\"title\":\"Mandibule 1.3.1.1.1 Occlusion 3\"}'),(1001,'98489097-716a-4b58-9941-a5fc369a2d70','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/computedocclusion_6960b50e-6f78-4f83-9303-8c985410457c/4_w1_o4_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_OCC_6960b50e-6f78-4f83-9303-8c985410457c_BOPLY__ZIP_','2022-05-31 14:55:58','2022-05-31 16:55:44','4_w1_o4_mandibule_occlusion_occ_file_0.zip','2022-05-31 16:55:58','SYNCED','98489097-716a-4b58-9941-a5fc369a2d70',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.4.1 Occlusion 5\",\"modelMatrix\":\"-0.693921,-0.706378,0.139651,0,0.720051,-0.680745,0.134584,0,-7.89603e-09,0.193947,0.981012,0,1.63985,-2.11708,-20.6571,1\",\"referenceScanID\":\"1.4.1.4.1\",\"title\":\"Mandibule 1.4.1.4.1 Occlusion 5\"}'),(1001,'9874ecd8-2c70-4875-b676-418a9914ab9b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/76279ff4-e4a6-4996-8d4e-c948146544b1/session_8b338ee6-5540-44a5-a587-286a7bfcbe14/occlusion_24569ac1-9195-47ea-beb2-d1d0f5543534/scan_8d33ab62-e242-47c7-aabd-f2419afc2e33/41_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_76279ff4-e4a6-4996-8d4e-c948146544b1_ACT_8b338ee6-5540-44a5-a587-286a7bfcbe14_SESS_24569ac1-9195-47ea-beb2-d1d0f5543534_TOSC_8d33ab62-e242-47c7-aabd-f2419afc2e33_SNAPS_','2022-10-07 10:40:27','2022-10-07 12:33:16','41_w1_o1_maxillaire_snapshot_0.png','2022-10-07 12:40:27','SYNCED','9874ecd8-2c70-4875-b676-418a9914ab9b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.41.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'98a6633c-fa30-4868-b16b-6c13202e785f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/1a8329eb-7dbc-4bfd-b669-6d92e13fec0c/session_11fb4259-c305-4a08-b750-536f769f44b0/occlusion_129468ab-1f43-4ba1-8939-49286128bf4d/computedocclusion_25900e6e-058b-4aa5-bee3-f5d20493c6ee/47_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_1a8329eb-7dbc-4bfd-b669-6d92e13fec0c_ACT_11fb4259-c305-4a08-b750-536f769f44b0_SESS_129468ab-1f43-4ba1-8939-49286128bf4d_OCC_25900e6e-058b-4aa5-bee3-f5d20493c6ee_SNAPO__SNAPS_','2022-10-21 16:20:05','2022-10-21 18:19:49','47_w1_o1_snapshot_occ_file_0.png','2022-10-21 18:20:05','SYNCED','98a6633c-fa30-4868-b16b-6c13202e785f',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'98c072ca-22a9-42b4-a866-73453f18585c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3ed7a8e0-5b4d-4ecf-b4ae-f855b16c0f93/session_fb42cec6-0bb6-41e9-912d-0517ff8e0942/occlusion_fb214b2f-5e41-492d-85c4-d4a11a3947c5/computedocclusion_f6573412-d667-47a1-89b2-d0a46006380f/42_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_3ed7a8e0-5b4d-4ecf-b4ae-f855b16c0f93_ACT_fb42cec6-0bb6-41e9-912d-0517ff8e0942_SESS_fb214b2f-5e41-492d-85c4-d4a11a3947c5_OCC_f6573412-d667-47a1-89b2-d0a46006380f_BOPLY__ZIP_','2022-10-07 17:38:06','2022-10-07 19:37:42','42_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-10-07 19:38:06','SYNCED','98c072ca-22a9-42b4-a866-73453f18585c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.42.1.1.1 Occlusion 5\",\"modelMatrix\":\"0.937148,-0.341928,0.0695603,0,0.348932,0.918338,-0.186823,0,2.8506e-09,0.199352,0.979928,0,-15.4329,23.391,-18.8334,1\",\"referenceScanID\":\"1.42.1.1.1\",\"title\":\"Mandibule 1.42.1.1.1 Occlusion 5\"}'),(1001,'98f855f4-0cfa-45fd-83b1-cb78eb2bbb18','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/09688939-f53f-4f00-8366-687b244de26d/session_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525/occlusion_9655a7e0-4673-41c9-90da-a48c008e2d62/computedocclusion_31e93f44-4fae-454e-8c7b-c76251c61d92/64_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_09688939-f53f-4f00-8366-687b244de26d_ACT_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525_SESS_9655a7e0-4673-41c9-90da-a48c008e2d62_OCC_31e93f44-4fae-454e-8c7b-c76251c61d92_BOMA__MATRX_','2023-03-30 12:19:49','2023-03-30 14:19:34','64_w1_o1_mandibule_matrix_occ_file_0.m','2023-03-30 14:19:49','SYNCED','98f855f4-0cfa-45fd-83b1-cb78eb2bbb18',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.64.1.1.1 Occlusion 3\",\"referenceScanID\":\"1.64.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.64.1.1.1 Occlusion 3\"}'),(1001,'991794d6-a992-4ea5-ba7c-7cdbd73c93fc','','ZIP','PATIENT_9e399d73-4d2e-4bb8-af48-a4e597811faa_ACT_b1cf14ce-00a9-48b6-8654-dadde26073f1_SESS_3c4595e0-fbbb-4814-8851-1e014eb9a3b2_BOSC_d1a74b95-c20b-47e3-afdf-01d847bb5b0b_ZIP_','2022-10-27 10:51:52','2022-10-20 12:56:24','','2022-10-27 12:51:52','SYNCED','991794d6-a992-4ea5-ba7c-7cdbd73c93fc',0,'2022-10-27 12:51:52','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.46.1.1.1\",\"modelMatrix\":\"-0.806372,-0.585058,0.0864387,0,0.591409,-0.797713,0.117857,0,4.84563e-09,0.146157,0.989261,0,14.6681,12.6186,-20.7693,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'99207aa8-492a-4329-8b5e-927534c1602d','','ZIP','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_c9079d19-8ffb-46f7-a51e-3a7a90ccae59_SESS_8ba0f3b1-408f-4a02-92a0-63f09123b68e_TOSC_44c8d5b1-b2de-4ba6-8ae5-8bc2a88e7918_ZIP_','2022-01-28 17:15:44','2022-01-27 14:19:03','','2022-01-28 18:15:44','SYNCED','99207aa8-492a-4329-8b5e-927534c1602d',0,'2022-01-28 18:15:44','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.10.1.1.3\",\"modelMatrix\":\"0.836207,0.53764,-0.108173,0,-0.548414,0.819779,-0.164939,0,-1.06729e-8,0.197247,0.980354,0,-22.3668,-9.22041,-17.6362,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'994cb9e0-2e19-495f-a47d-a8e5a7508218','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/de078619-3946-4adb-a799-1c260e16face/session_24d0aeb5-3058-4070-aeea-97c289e41e3c/occlusion_ea6da896-1504-41fc-890c-7c48575e9e40/scan_e7e54c23-0fb4-457b-aa49-43078736514f/2_w1_o1_mordu_anterieur_scan_file_0.zip','ZIP','PATIENT_de078619-3946-4adb-a799-1c260e16face_ACT_24d0aeb5-3058-4070-aeea-97c289e41e3c_SESS_ea6da896-1504-41fc-890c-7c48575e9e40_FRSC_e7e54c23-0fb4-457b-aa49-43078736514f_ZIP_','2022-01-19 14:46:11','2022-01-19 15:46:00','2_w1_o1_mordu_anterieur_scan_file_0.zip','2022-01-19 15:46:11','SYNCED','994cb9e0-2e19-495f-a47d-a8e5a7508218',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.2.1.1.1\",\"modelMatrix\":\"0.980065,-0.204958,-0.0526448,0,0.112398,0.463376,0.872879,0,-0.167578,-0.862155,0.486365,0,-2.15237,17.6189,-29.4292,1\",\"title\":\"Mordu anterieur ZIP\"}'),(1001,'99a0b8cd-a334-482e-ac9b-0519766a21e8','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_ce625ba7-4218-40af-b344-df718da13f83/54_w1_o1_mandibule_matrix_occ_file_3.m','MATRX','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_ce625ba7-4218-40af-b344-df718da13f83_BOMA__MATRX_','2023-03-15 10:16:45','2023-03-15 11:16:15','54_w1_o1_mandibule_matrix_occ_file_3.m','2023-03-15 11:16:45','SYNCED','45775437-46ca-4831-b788-61b2ad12ff31',3,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.54.1.1.4 Occlusion 1\",\"referenceScanID\":\"1.54.1.1.4\",\"title\":\"Matrice Transfo. Mandibule 1.54.1.1.4 Occlusion 1\"}'),(1001,'99aa407a-9007-4792-83d2-b6b40da84b1b','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/9e399d73-4d2e-4bb8-af48-a4e597811faa/session_b1cf14ce-00a9-48b6-8654-dadde26073f1/occlusion_1060c95f-48f4-4a37-9b82-03bfd8329730/scan_f1e1a23d-a279-4fec-8d2c-40dc846885d2/46_w1_o2_mandibule_snapshot_2.png','SNAPS','PATIENT_9e399d73-4d2e-4bb8-af48-a4e597811faa_ACT_b1cf14ce-00a9-48b6-8654-dadde26073f1_SESS_1060c95f-48f4-4a37-9b82-03bfd8329730_BOSC_f1e1a23d-a279-4fec-8d2c-40dc846885d2_SNAPS_','2023-01-20 14:31:12','2023-01-20 15:30:58','46_w1_o2_mandibule_snapshot_2.png','2023-01-20 15:31:12','SYNCED','51783946-4939-4c6c-9e57-f1e450c81a9a',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.46.1.2.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'99c7b58b-6259-4c43-ac2f-8b7f47f0b3e7','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/scan_03839278-13f8-46e6-9581-ba11bc8bcb81/1_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_TOSC_03839278-13f8-46e6-9581-ba11bc8bcb81_SNAPS_','2022-01-19 12:59:18','2022-01-19 10:24:17','1_w1_o1_maxillaire_snapshot_0.png','2022-01-19 13:59:18','SYNCED','99c7b58b-6259-4c43-ac2f-8b7f47f0b3e7',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire SNAPSHOT\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'99d5bac9-4284-4b3c-9a3f-dfd010dadc87','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/9e399d73-4d2e-4bb8-af48-a4e597811faa/session_b1cf14ce-00a9-48b6-8654-dadde26073f1/occlusion_3c4595e0-fbbb-4814-8851-1e014eb9a3b2/scan_f26fe3ea-6f4e-4010-a7f6-4757c6679e52/46_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_9e399d73-4d2e-4bb8-af48-a4e597811faa_ACT_b1cf14ce-00a9-48b6-8654-dadde26073f1_SESS_3c4595e0-fbbb-4814-8851-1e014eb9a3b2_BOSC_f26fe3ea-6f4e-4010-a7f6-4757c6679e52_ZIP_','2022-10-27 11:45:59','2022-10-27 13:45:52','46_w1_o1_mandibule_scan_file_1.zip','2022-10-27 13:45:59','SYNCED','e29d75a6-5a7a-4e53-b47a-4b7ba43164ba',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.46.1.1.5\",\"modelMatrix\":\"-0.691259,0.70798,-0.144654,0,-0.722607,-0.677267,0.138379,0,4.56755e-11,0.200184,0.979758,0,-4.95856,-24.955,-22.6403,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'99d7dad4-e061-45ed-9525-24dea27e54ab','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/39062d60-7a18-417a-9004-c58e9ce7d62a/session_9869e99c-7b47-4662-9766-0388d668fbf3/occlusion_36832844-9579-46df-aea1-b9baf6ad8787/scan_c4535e06-3294-424b-83ea-ac181cad8776/61_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_39062d60-7a18-417a-9004-c58e9ce7d62a_ACT_9869e99c-7b47-4662-9766-0388d668fbf3_SESS_36832844-9579-46df-aea1-b9baf6ad8787_RISC_c4535e06-3294-424b-83ea-ac181cad8776_SNAPS_','2023-03-10 17:33:29','2023-03-10 18:33:17','61_w1_o1_mordu_posterieur_droit_snapshot_0.png','2023-03-10 18:33:29','SYNCED','99d7dad4-e061-45ed-9525-24dea27e54ab',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.61.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'99e9c64c-195f-4a43-beb2-035ad896a764','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/scan_a628b7db-c954-4964-8d48-1e09fa34d82b/1_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_RISC_a628b7db-c954-4964-8d48-1e09fa34d82b_ZIP_','2022-01-19 12:59:17','2022-01-19 12:03:51','1_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-01-19 13:59:17','SYNCED','99e9c64c-195f-4a43-beb2-035ad896a764',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.1.1.1.1\",\"modelMatrix\":\"0.975619,0.193926,0.102839,0,-0.205915,0.968059,0.140778,0,-0.0760501,-0.158929,0.984692,0,-11.6702,-2.08029,-19.9288,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'99f295b4-4108-47db-b222-799cca91ea98','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/1a8329eb-7dbc-4bfd-b669-6d92e13fec0c/session_11fb4259-c305-4a08-b750-536f769f44b0/order_fa05221b-8e51-4f48-818a-52a8fe72db63/47_w1_autre_prost_file_99f295b4-4108-47db-b222-799cca91ea98_0.pdf','PDF','PATIENT_1a8329eb-7dbc-4bfd-b669-6d92e13fec0c_ACT_11fb4259-c305-4a08-b750-536f769f44b0_PROST_fa05221b-8e51-4f48-818a-52a8fe72db63_PDF_','2022-10-21 17:28:22','2022-10-21 19:28:21','47_w1_autre_prost_file_99f295b4-4108-47db-b222-799cca91ea98_0.pdf','2022-10-21 19:28:22','SYNCED','99f295b4-4108-47db-b222-799cca91ea98',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.47.1.1 AUTRE FICHE DE PROTHESE\",\"title\":\"Autre PDF\"}'),(1001,'9a047db2-2e3a-4f43-99fa-c96ed8734e9c','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/39062d60-7a18-417a-9004-c58e9ce7d62a/session_9869e99c-7b47-4662-9766-0388d668fbf3/occlusion_36832844-9579-46df-aea1-b9baf6ad8787/scan_bb3b1572-479e-47fd-a564-1953a5f394cf/61_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_39062d60-7a18-417a-9004-c58e9ce7d62a_ACT_9869e99c-7b47-4662-9766-0388d668fbf3_SESS_36832844-9579-46df-aea1-b9baf6ad8787_TOSC_bb3b1572-479e-47fd-a564-1953a5f394cf_SNAPS_','2023-03-10 17:22:11','2023-03-10 18:21:11','61_w1_o1_maxillaire_snapshot_0.png','2023-03-10 18:22:11','SYNCED','9a047db2-2e3a-4f43-99fa-c96ed8734e9c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.61.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'9abc1c1f-f67c-4c58-a434-a2b7ccfc7ce3','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/98aa55d8-3848-48e0-9684-5597786b85c7/session_4df1e430-5cbb-4a6c-8292-747e35e6f1e8/occlusion_fcc5c65d-b0e4-4036-99c7-07318171986a/scan_9415795d-cf35-41d8-a989-d38dada847f9/66_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_98aa55d8-3848-48e0-9684-5597786b85c7_ACT_4df1e430-5cbb-4a6c-8292-747e35e6f1e8_SESS_fcc5c65d-b0e4-4036-99c7-07318171986a_TOSC_9415795d-cf35-41d8-a989-d38dada847f9_ZIP_','2023-04-13 09:40:33','2023-04-13 11:40:33','66_w1_o1_maxillaire_scan_file_0.zip',NULL,'CREATED','9abc1c1f-f67c-4c58-a434-a2b7ccfc7ce3',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.66.1.1.1\",\"modelMatrix\":\"-0.32124,0.936521,-0.140478,0,-0.946998,-0.317686,0.0476527,0,-4.98375e-11,0.14834,0.988936,0,-9.30542,-32.2961,-19.4237,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'9b00be28-351f-4e83-96bc-90186ce29940','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/490e4b04-6edd-4f47-a2ed-232689892eca/session_62105a91-1675-4d36-88bd-34aa8fe2ce3c/occlusion_03784c27-fd8d-4745-9c26-d84c490869b3/computedocclusion_8dab59f8-3c64-4520-912b-687d8f68ebb8/56_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_490e4b04-6edd-4f47-a2ed-232689892eca_ACT_62105a91-1675-4d36-88bd-34aa8fe2ce3c_SESS_03784c27-fd8d-4745-9c26-d84c490869b3_OCC_8dab59f8-3c64-4520-912b-687d8f68ebb8_BOPLY__ZIP_','2023-02-17 09:39:48','2023-02-17 10:39:41','56_w1_o1_mandibule_occlusion_occ_file_0.zip','2023-02-17 10:39:48','SYNCED','9b00be28-351f-4e83-96bc-90186ce29940',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.56.1.1.1 Occlusion 1\",\"modelMatrix\":\"-0.932575,-0.347234,0.0986526,0,0.360977,-0.897072,0.254867,0,-3.57676e-09,0.273294,0.961931,0,23.3574,-4.74819,-17.6637,1\",\"referenceScanID\":\"1.56.1.1.1\",\"title\":\"Mandibule 1.56.1.1.1 Occlusion 1\"}'),(1001,'9b224217-9a8a-452f-b50f-bd96620b3ed4','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a0c21836-ba79-4f15-9e35-02ef8211a9e5/session_0aac522d-3c38-465a-a1e0-014166c140ac/occlusion_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042/scan_c3e689b6-6028-4fc6-9373-eab430b52625/7_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_a0c21836-ba79-4f15-9e35-02ef8211a9e5_ACT_0aac522d-3c38-465a-a1e0-014166c140ac_SESS_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042_LESC_c3e689b6-6028-4fc6-9373-eab430b52625_ZIP_','2022-01-21 12:04:47','2022-01-21 13:04:33','7_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-01-21 13:04:47','SYNCED','9b224217-9a8a-452f-b50f-bd96620b3ed4',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.7.1.1.1\",\"modelMatrix\":\"-0.976609,-0.0506279,0.213734,0,0.0565187,-0.996245,0.0558216,0,0.207631,0.0707217,0.975304,0,5.92907,-1.09381,-19.0899,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'9b41cfe4-14a3-4577-80f8-bcdd6cf985e5','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/computedocclusion_864c98a3-fcf7-466a-b999-13bd4dfb8c65/23_w1_o1_ml_occ_file_to1002.xyz','LIFI','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_864c98a3-fcf7-466a-b999-13bd4dfb8c65_LIFIO_LIFI_','2022-05-25 10:46:43','2022-05-25 12:46:42','23_w1_o1_ml_occ_file_to1002.xyz','2022-05-25 12:46:43','SYNCED','9b41cfe4-14a3-4577-80f8-bcdd6cf985e5',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.23.1.1.1 Occlusion 3 Ligne de finition 2\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"Maxillaire\",\"name\":\"Ligne de finition 2\",\"title\":\"Ligne finition\",\"toothNumber\":1002}'),(1001,'9b548519-68c0-45b3-83c4-c58081ddab21','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_1ecf6aa5-37ac-49b0-ab34-94916ad9415a/4_w1_o2_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_LESC_1ecf6aa5-37ac-49b0-ab34-94916ad9415a_ZIP_','2022-02-15 12:37:05','2022-02-15 13:36:58','4_w1_o2_mordu_posterieur_gauche_scan_file_0.zip','2022-02-15 13:37:05','SYNCED','9b548519-68c0-45b3-83c4-c58081ddab21',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.4.1.2.1\",\"modelMatrix\":\"-0.977205,-0.173965,0.16006,0,0.160172,-0.983412,0.0139735,0,0.141616,0.0574546,0.987233,0,-8.00566,-2.7193,-19.0144,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'9b6af1b1-98f8-49a2-b094-91fd0cf4bb06','','ZIP','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_OCC_d58ce31f-4b72-44ad-b0e0-3d5d7d789322_TOPLY__ZIP_','2022-01-19 11:15:36','2022-01-19 12:06:18','',NULL,'CREATED','9b6af1b1-98f8-49a2-b094-91fd0cf4bb06',0,'2022-01-19 12:15:36','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.1.1.1.1 Occlusion 1\",\"modelMatrix\":\"-0.154277,0.952805,-0.261459,0,-0.988028,-0.148777,0.0408259,0,-2.59672e-9,0.264627,0.964351,0,-14.8611,-36.6101,-15.3158,1\",\"referenceScanID\":\"1.1.1.1.1\",\"title\":\"Maxillaire 1.1.1.1.1 Occlusion 1\"}'),(1001,'9b7a5ef7-049f-4ec1-9fae-f0cd8c13a8e9','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3ed7a8e0-5b4d-4ecf-b4ae-f855b16c0f93/session_fb42cec6-0bb6-41e9-912d-0517ff8e0942/occlusion_fb214b2f-5e41-492d-85c4-d4a11a3947c5/scan_d7407f25-706b-455d-bad0-4ca82328f452/42_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_3ed7a8e0-5b4d-4ecf-b4ae-f855b16c0f93_ACT_fb42cec6-0bb6-41e9-912d-0517ff8e0942_SESS_fb214b2f-5e41-492d-85c4-d4a11a3947c5_BOSC_d7407f25-706b-455d-bad0-4ca82328f452_ZIP_','2022-10-07 14:29:56','2022-10-07 13:44:21','42_w1_o1_maxillaire_scan_file_0.zip','2022-10-07 16:29:56','SYNCED','9b7a5ef7-049f-4ec1-9fae-f0cd8c13a8e9',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.42.1.1.1\",\"modelMatrix\":\"0.937148,-0.341928,0.0695603,0,0.348932,0.918338,-0.186823,0,2.8506e-09,0.199352,0.979928,0,-15.4329,23.391,-18.8334,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'9bbce8ff-b16a-41dd-963a-6e305278cbb6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/75ce481f-6c44-4d16-a477-ea40c4fa6022/session_9bf7b056-ca4f-4dab-937b-619d0eb20528/occlusion_d7580529-3ede-4e27-a2ae-01849ba4d397/scan_f0249631-e141-477c-a453-a48959147fb4/55_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_75ce481f-6c44-4d16-a477-ea40c4fa6022_ACT_9bf7b056-ca4f-4dab-937b-619d0eb20528_SESS_d7580529-3ede-4e27-a2ae-01849ba4d397_RISC_f0249631-e141-477c-a453-a48959147fb4_SNAPS_','2022-12-22 10:34:47','2022-12-22 11:34:40','55_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-12-22 11:34:47','SYNCED','9bbce8ff-b16a-41dd-963a-6e305278cbb6',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.55.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'9bc487be-aea8-4232-90ae-806369f205fd','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/computedocclusion_b35629de-38d8-4cdd-bf2c-b61c461410cb/17_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_b35629de-38d8-4cdd-bf2c-b61c461410cb_SNAPO__SNAPS_','2022-02-07 18:07:23','2022-02-07 19:05:55','17_w1_o1_snapshot_occ_file_0.png','2022-02-07 19:07:23','SYNCED','9bc487be-aea8-4232-90ae-806369f205fd',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'9c197d27-028f-4f29-873a-a3f68074f173','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/scan_90beda40-67c7-49a2-88be-64610235c1c8/19_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_FRSC_90beda40-67c7-49a2-88be-64610235c1c8_SNAPS_','2022-03-08 11:12:11','2022-03-08 12:12:02','19_w1_o1_mordu_anterieur_snapshot_0.png','2022-03-08 12:12:11','SYNCED','9c197d27-028f-4f29-873a-a3f68074f173',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.19.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'9c340b50-641f-431f-9364-924943886fa2','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/39062d60-7a18-417a-9004-c58e9ce7d62a/session_9869e99c-7b47-4662-9766-0388d668fbf3/occlusion_36832844-9579-46df-aea1-b9baf6ad8787/scan_711f176e-9d6b-4c0e-8fa0-892b4ad57c05/61_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_39062d60-7a18-417a-9004-c58e9ce7d62a_ACT_9869e99c-7b47-4662-9766-0388d668fbf3_SESS_36832844-9579-46df-aea1-b9baf6ad8787_BOSC_711f176e-9d6b-4c0e-8fa0-892b4ad57c05_ZIP_','2023-03-10 17:18:09','2023-03-10 18:17:55','61_w1_o1_mandibule_scan_file_0.zip','2023-03-10 18:18:09','SYNCED','9c340b50-641f-431f-9364-924943886fa2',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.61.1.1.1\",\"modelMatrix\":\"-0.689128,-0.713925,0.124157,0,0.72464,-0.678937,0.118072,0,-9.1022e-10,0.171335,0.985213,0,0.0991868,-2.63599,-21.8939,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'9c88f124-fffa-4cb6-82d2-13d9261bbb22','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/372000f2-2471-4a57-9b18-224d0788041f/session_5dd64d24-8e33-45bd-a282-c148c185c338/occlusion_a61fbfda-1ac5-4747-9e0c-6ef664930816/computedocclusion_7eb0f2bf-a2c1-4938-b124-5a10e3cdb809/57_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_372000f2-2471-4a57-9b18-224d0788041f_ACT_5dd64d24-8e33-45bd-a282-c148c185c338_SESS_a61fbfda-1ac5-4747-9e0c-6ef664930816_OCC_7eb0f2bf-a2c1-4938-b124-5a10e3cdb809_TOPLY__ZIP_','2023-02-17 10:55:36','2023-02-17 11:55:24','57_w1_o1_maxillaire_occlusion_occ_file_0.zip','2023-02-17 11:55:36','SYNCED','9c88f124-fffa-4cb6-82d2-13d9261bbb22',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.57.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.954594,0.28713,-0.0794169,0,-0.297911,0.92005,-0.254475,0,6.91305e-09,0.26658,0.963813,0,6.25595,-2.61273,-21.3503,1\",\"referenceScanID\":\"1.57.1.1.1\",\"title\":\"Maxillaire 1.57.1.1.1 Occlusion 1\"}'),(1001,'9d43dac3-97f5-4a79-b584-939560103edf','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/1a8329eb-7dbc-4bfd-b669-6d92e13fec0c/session_11fb4259-c305-4a08-b750-536f769f44b0/occlusion_129468ab-1f43-4ba1-8939-49286128bf4d/scan_db9fa61f-1e5c-4cd6-99aa-28ce9533d305/47_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_1a8329eb-7dbc-4bfd-b669-6d92e13fec0c_ACT_11fb4259-c305-4a08-b750-536f769f44b0_SESS_129468ab-1f43-4ba1-8939-49286128bf4d_TOSC_db9fa61f-1e5c-4cd6-99aa-28ce9533d305_SNAPS_','2022-10-21 16:06:58','2022-10-21 18:06:49','47_w1_o1_maxillaire_snapshot_0.png','2022-10-21 18:06:58','SYNCED','9d43dac3-97f5-4a79-b584-939560103edf',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.47.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'9d4d6431-d42e-4d0f-aeb9-24b3faf6a0d2','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/c8418992-7324-4a11-9437-bf2bb0fa802f/session_ff05cb1f-6c46-4287-9cdd-81bf817a9c78/occlusion_f6f084bb-a5f1-4f39-860f-1483132c8283/scan_9263fb3c-bf3a-443f-8c9b-4d12244b4612/11_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_c8418992-7324-4a11-9437-bf2bb0fa802f_ACT_ff05cb1f-6c46-4287-9cdd-81bf817a9c78_SESS_f6f084bb-a5f1-4f39-860f-1483132c8283_TOSC_9263fb3c-bf3a-443f-8c9b-4d12244b4612_SNAPS_','2022-01-25 15:45:57','2022-01-25 16:45:25','11_w1_o1_maxillaire_snapshot_1.png','2022-01-25 16:45:57','SYNCED','20010b5b-e8eb-499b-8bf9-25f8af288f05',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.11.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'9d63c9e3-26ee-496a-aee1-ec6b35f881e5','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/scan_2a38e9c2-6808-43f3-904a-decdb37d60d5/4_w1_o4_mandibule_scan_file_0.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_BOSC_2a38e9c2-6808-43f3-904a-decdb37d60d5_ZIP_','2022-05-31 12:03:44','2022-05-31 14:03:35','4_w1_o4_mandibule_scan_file_0.zip','2022-05-31 14:03:44','SYNCED','9d63c9e3-26ee-496a-aee1-ec6b35f881e5',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.4.1\",\"modelMatrix\":\"-0.629357,-0.770163,0.103726,0,0.777116,-0.623726,0.0840038,0,8.35188e-10,0.133476,0.991052,0,1.59326,-0.77893,-20.701,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'9d6855d8-8a5f-4524-991e-ab57f21501ab','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/e922efb9-8c03-445b-8a0f-449e3c43bdca/session_a2369349-1629-40ad-8784-d271bc3fbade/occlusion_292cc1aa-8b12-463b-87a1-7d9731cf886b/scan_171c6386-cba0-454c-a194-380c61a2ad2d/21_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_e922efb9-8c03-445b-8a0f-449e3c43bdca_ACT_a2369349-1629-40ad-8784-d271bc3fbade_SESS_292cc1aa-8b12-463b-87a1-7d9731cf886b_BOSC_171c6386-cba0-454c-a194-380c61a2ad2d_SNAPS_','2022-04-21 08:45:31','2022-04-21 10:45:20','21_w1_o1_mandibule_snapshot_0.png','2022-04-21 10:45:31','SYNCED','9d6855d8-8a5f-4524-991e-ab57f21501ab',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.21.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'9d940f19-6e8d-4761-abbf-0ca8fa9825c1','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/75ce481f-6c44-4d16-a477-ea40c4fa6022/session_9bf7b056-ca4f-4dab-937b-619d0eb20528/occlusion_d7580529-3ede-4e27-a2ae-01849ba4d397/scan_6c5747b1-979b-4f6b-af3c-f657f990065d/55_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_75ce481f-6c44-4d16-a477-ea40c4fa6022_ACT_9bf7b056-ca4f-4dab-937b-619d0eb20528_SESS_d7580529-3ede-4e27-a2ae-01849ba4d397_LESC_6c5747b1-979b-4f6b-af3c-f657f990065d_ZIP_','2022-12-22 10:36:55','2022-12-22 11:36:48','55_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-12-22 11:36:55','SYNCED','9d940f19-6e8d-4761-abbf-0ca8fa9825c1',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.55.1.1.2\",\"modelMatrix\":\"-0.958643,-0.0451453,0.279642,0,-0.00104892,-0.983811,-0.178087,0,0.284655,-0.173508,0.943444,0,-1.97418,2.54687,-19.1961,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'9da55c92-8a3b-4fdf-8179-7bf0b39c8461','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_ce625ba7-4218-40af-b344-df718da13f83/54_w1_o1_snapshot_occ_file_1.png','SNAPS','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_ce625ba7-4218-40af-b344-df718da13f83_SNAPO__SNAPS_','2023-03-15 10:17:55','2023-03-15 11:15:16','54_w1_o1_snapshot_occ_file_1.png','2023-03-15 11:17:55','SYNCED','7646ffac-dba0-4ac0-b4a3-8547134e5318',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'9db18e41-2237-4adc-8007-8d9bafdcf55f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_2a7068fc-0efa-496f-ade9-aba5b0650655/12_w1_o1_mandibule_snapshot_5.png','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_2a7068fc-0efa-496f-ade9-aba5b0650655_SNAPS_','2022-02-04 12:08:36','2022-02-04 13:08:17','12_w1_o1_mandibule_snapshot_5.png','2022-02-04 13:08:36','SYNCED','7636e0d7-f242-431c-90a5-a65399d83ecd',5,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.5\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'9dd0c754-d272-45ee-aa54-5d3030ae4573','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/scan_c1f909ab-5469-4839-84f1-d04759dd1237/1_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_BOSC_c1f909ab-5469-4839-84f1-d04759dd1237_ZIP_','2022-01-19 12:59:55','2022-01-19 11:51:31','1_w1_o1_mandibule_scan_file_0.zip','2022-01-19 13:59:55','SYNCED','9dd0c754-d272-45ee-aa54-5d3030ae4573',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.1.1.1.1\",\"modelMatrix\":\"-0.978511,0.202624,-0.0382083,0,-0.206195,-0.961565,0.18132,0,1.68873e-9,0.185302,0.982682,0,35.5572,6.72193,-16.6463,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'9e1292ba-2d2b-4b4c-8e8c-1c5231018cf4','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/computedocclusion_7c70edbe-5cb4-4244-8baf-7caf2bd7d86b/12_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_OCC_7c70edbe-5cb4-4244-8baf-7caf2bd7d86b_TOPLY__ZIP_','2022-02-04 17:59:48','2022-02-04 18:58:48','12_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-02-04 18:59:48','SYNCED','9e1292ba-2d2b-4b4c-8e8c-1c5231018cf4',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.12.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.622652,0.772747,-0.123153,0,-0.782499,0.614892,-0.0979959,0,-5.00422e-9,0.157385,0.987537,0,-21.5256,-19.2669,-19.1349,1\",\"referenceScanID\":\"1.12.1.1.1\",\"title\":\"Maxillaire 1.12.1.1.1 Occlusion 1\"}'),(1001,'9e13d9e3-cdab-4d9f-ad77-b8a3cbfbd2c9','','MATRX','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_26ae7fce-0ea3-479f-9989-7d0a3a19aaf7_BOMA__MATRX_','2022-02-08 08:49:00','2022-02-07 18:58:31','','2022-02-08 09:49:00','SYNCED','9e13d9e3-cdab-4d9f-ad77-b8a3cbfbd2c9',0,'2022-02-08 09:49:00','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.17.1.1.1 Occlusion 6\",\"referenceScanID\":\"1.17.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.17.1.1.1 Occlusion 6\"}'),(2,'9e45c2ae-5076-435b-8537-ce6255f263b3','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a47006e-5c4a-4fab-835f-67e3301b2acf/session_d0298050-98d9-4076-b3bd-110404d60135/occlusion_c5f98876-f420-4912-bd39-cfffac649936/scan_41295122-614f-4e97-b820-f8a9940950f4/4_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_6a47006e-5c4a-4fab-835f-67e3301b2acf_ACT_d0298050-98d9-4076-b3bd-110404d60135_SESS_c5f98876-f420-4912-bd39-cfffac649936_TOSC_41295122-614f-4e97-b820-f8a9940950f4_SNAPS_','2022-09-06 09:20:24','2022-09-06 11:20:24','4_w1_o1_maxillaire_snapshot_0.png',NULL,'CREATED','9e45c2ae-5076-435b-8537-ce6255f263b3',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire SNAPSHOT\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'9eb7d518-a769-4fd8-9066-a0f2ece8f396','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/458c92d8-9da1-4df9-967f-d14fc7e6303d/session_55831d43-1906-4a22-9b7a-ed4b2820c8b2/occlusion_4f582d4c-81d0-4e01-8be3-9ff53b12c7f4/scan_19e6ea5c-af28-439b-bc57-b561cd42e12b/10_w2_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_55831d43-1906-4a22-9b7a-ed4b2820c8b2_SESS_4f582d4c-81d0-4e01-8be3-9ff53b12c7f4_TOSC_19e6ea5c-af28-439b-bc57-b561cd42e12b_ZIP_','2022-06-16 13:17:46','2022-06-16 15:17:36','10_w2_o1_maxillaire_scan_file_0.zip','2022-06-16 15:17:46','SYNCED','9eb7d518-a769-4fd8-9066-a0f2ece8f396',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.10.2.1.1\",\"modelMatrix\":\"-0.0964683,-0.959476,0.264765,0,0.995336,-0.0929927,0.0256611,0,-1.25281e-09,0.266005,0.963971,0,4.90102,-7.21788,-24.7307,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'9ee0ae1d-fe0a-4553-9d50-11a13c8b42fc','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/207d6dbc-c19b-4726-a9b3-16235ae554cc/session_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35/occlusion_dc5762a3-c453-4166-8c86-82d23ac9f8a6/computedocclusion_3a1fff1c-0427-409c-aa94-06326e554d82/27_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_207d6dbc-c19b-4726-a9b3-16235ae554cc_ACT_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35_SESS_dc5762a3-c453-4166-8c86-82d23ac9f8a6_OCC_3a1fff1c-0427-409c-aa94-06326e554d82_SNAPO__SNAPS_','2022-05-30 11:09:40','2022-05-30 13:09:22','27_w1_o1_snapshot_occ_file_0.png','2022-05-30 13:09:40','SYNCED','9ee0ae1d-fe0a-4553-9d50-11a13c8b42fc',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'9ee12909-baa5-4a11-9161-ac732edc1263','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/de078619-3946-4adb-a799-1c260e16face/session_24d0aeb5-3058-4070-aeea-97c289e41e3c/occlusion_ea6da896-1504-41fc-890c-7c48575e9e40/computedocclusion_a15a6719-2996-4256-93d7-515e4d4f5bef/2_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_de078619-3946-4adb-a799-1c260e16face_ACT_24d0aeb5-3058-4070-aeea-97c289e41e3c_SESS_ea6da896-1504-41fc-890c-7c48575e9e40_OCC_a15a6719-2996-4256-93d7-515e4d4f5bef_TOPLY__ZIP_','2022-01-19 14:47:45','2022-01-19 15:46:49','2_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-01-19 15:47:45','SYNCED','9ee12909-baa5-4a11-9161-ac732edc1263',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.2.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.999693,0.0234182,-0.00803445,0,-0.0247581,0.94559,-0.324418,0,2.12043e-11,0.324518,0.94588,0,-21.3098,-33.4944,-23.4708,1\",\"referenceScanID\":\"1.2.1.1.1\",\"title\":\"Maxillaire 1.2.1.1.1 Occlusion 1\"}'),(1001,'9f084861-d8a3-4071-b9c8-235aab6b53fe','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/occlusion_a2220645-c79d-4dda-b6cc-772384a4106b/computedocclusion_8b14563e-0862-4cac-8045-e8aed2be886d/38_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_OCC_8b14563e-0862-4cac-8045-e8aed2be886d_BOMA__MATRX_','2022-07-12 10:57:42','2022-07-12 12:57:24','38_w1_o1_mandibule_matrix_occ_file_0.m','2022-07-12 12:57:42','SYNCED','9f084861-d8a3-4071-b9c8-235aab6b53fe',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.38.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.38.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.38.1.1.1 Occlusion 1\"}'),(1001,'9f17447e-2bf5-4910-b523-3614c2e84d88','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/ca43bf7b-f931-42fc-bb75-05929e4b6578/session_d9740504-a9ca-472a-83f2-a309fa225a98/occlusion_d663165c-f330-4c61-8d1f-14869b6d5edd/scan_7b6a9df3-3f34-48df-a44e-e6d77507d049/59_w1_o1_maxillaire_snapshot_3.png','SNAPS','PATIENT_ca43bf7b-f931-42fc-bb75-05929e4b6578_ACT_d9740504-a9ca-472a-83f2-a309fa225a98_SESS_d663165c-f330-4c61-8d1f-14869b6d5edd_TOSC_7b6a9df3-3f34-48df-a44e-e6d77507d049_SNAPS_','2023-03-02 15:03:46','2023-03-02 16:03:37','59_w1_o1_maxillaire_snapshot_3.png','2023-03-02 16:03:46','SYNCED','0d45e478-acd1-41de-ad65-75a3b7160d51',3,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.59.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'9f3b5ad5-8e3e-47a3-b26f-763409e2b9d9','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/8b4b6de2-edd8-44e6-88c6-8a151914aca6/session_40a1b174-1058-4d27-b63a-4e8f565fb520/occlusion_8eba4eab-4337-436a-8eb6-b59e63415159/scan_08084ba8-1813-4cb8-97b6-125728b1dc52/48_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_8b4b6de2-edd8-44e6-88c6-8a151914aca6_ACT_40a1b174-1058-4d27-b63a-4e8f565fb520_SESS_8eba4eab-4337-436a-8eb6-b59e63415159_BOSC_08084ba8-1813-4cb8-97b6-125728b1dc52_ZIP_','2022-11-10 18:07:32','2022-11-10 11:29:08','48_w1_o1_maxillaire_scan_file_0.zip','2022-11-10 19:07:32','SYNCED','9f3b5ad5-8e3e-47a3-b26f-763409e2b9d9',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.48.1.1.1\",\"modelMatrix\":\"-0.906301,-0.394535,0.151527,0,0.422633,-0.846048,0.324936,0,7.6702e-09,0.35853,0.933518,0,0.185115,-5.31291,-22.554,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'9f767c47-1f3f-419b-800a-e52cc2aafb11','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/discussion_4d12bcc3-80f2-49dc-9159-54929f160ce6/9f767c47-1f3f-419b-800a-e52cc2aafb11.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_426bd908-3163-4291-a697-20eacff771ab_SNAPO__SNAPS_','2022-05-25 08:56:24','2022-05-16 19:57:11','9f767c47-1f3f-419b-800a-e52cc2aafb11.png','2022-05-25 10:56:24','SYNCED','9f767c47-1f3f-419b-800a-e52cc2aafb11',0,'2022-05-25 10:56:24','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'9f899abf-8146-4e60-b6b9-0479f28a9141','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/scan_255c9e68-7cd6-413d-ba72-261666fdb488/19_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_BOSC_255c9e68-7cd6-413d-ba72-261666fdb488_ZIP_','2022-03-08 10:56:17','2022-03-08 11:56:13','19_w1_o1_mandibule_scan_file_0.zip','2022-03-08 11:56:17','SYNCED','9f899abf-8146-4e60-b6b9-0479f28a9141',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.1.6\",\"modelMatrix\":\"0.960036,-0.234632,0.152577,0,0.279878,0.804832,-0.523368,0,4.54095e-09,0.545155,0.838335,0,-2.16511,-15.3211,-15.1064,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'9faedb0a-5c1a-4ea6-b027-8e5f8df16abc','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/scan_f5ab063d-18f1-443e-b694-fd1ef20e9e78/4_w1_o4_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_LESC_f5ab063d-18f1-443e-b694-fd1ef20e9e78_ZIP_','2022-05-31 12:09:43','2022-05-31 14:09:38','4_w1_o4_mordu_posterieur_gauche_scan_file_0.zip','2022-05-31 14:09:43','SYNCED','9faedb0a-5c1a-4ea6-b027-8e5f8df16abc',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.4.1.4.1\",\"modelMatrix\":\"-0.998155,0.0210725,0.0625312,0,-0.00999653,-0.998165,0.0577016,0,0.0604331,0.0572825,0.996378,0,-3.01752,-2.21358,-18.2835,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'9fda0c62-4059-465e-9bb8-0b511c6fcdf4','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_ce625ba7-4218-40af-b344-df718da13f83/54_w1_o1_maxillaire_occlusion_occ_file_4.zip','ZIP','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_ce625ba7-4218-40af-b344-df718da13f83_TOPLY__ZIP_','2023-03-15 10:27:01','2023-03-15 11:26:20','54_w1_o1_maxillaire_occlusion_occ_file_4.zip','2023-03-15 11:27:01','SYNCED','ad02dce8-3ff6-4167-add8-6925d6562d5e',4,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.54.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.78238,0.620977,-0.0476379,0,-0.622801,0.780088,-0.059844,0,1.97556e-09,0.0764897,0.99707,0,-23.5433,3.60536,-19.7037,1\",\"referenceScanID\":\"1.54.1.1.1\",\"title\":\"Maxillaire 1.54.1.1.1 Occlusion 1\"}'),(1001,'9fe8afd4-2328-4751-9d29-f1bedd1325b2','','ZIP','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_RISC_029ae158-d269-4f43-b5ee-add7ce3f59c5_ZIP_','2022-04-21 13:44:33','2022-04-21 13:25:56','','2022-04-21 15:44:33','SYNCED','9fe8afd4-2328-4751-9d29-f1bedd1325b2',0,'2022-04-21 15:44:33','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.22.1.1.4\",\"modelMatrix\":\"0.998263,0.0528348,0.0197903,0,-0.0571413,0.993325,0.10153,0,-0.0145614,-0.102565,0.994636,0,5.1608,4.26452,-17.249,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'9ff81c89-8932-4154-acbf-a1b46fe30571','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f4fc00ec-4af8-4a15-b427-f1c5aabf6260/session_498ae60a-23f0-44fc-9730-be499bfc4b46/occlusion_8f3d6c73-3468-45a5-85c7-93bba47ec9f7/scan_60c1cc80-0d70-4511-8993-70e3a3c146b8/30_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_f4fc00ec-4af8-4a15-b427-f1c5aabf6260_ACT_498ae60a-23f0-44fc-9730-be499bfc4b46_SESS_8f3d6c73-3468-45a5-85c7-93bba47ec9f7_BOSC_60c1cc80-0d70-4511-8993-70e3a3c146b8_SNAPS_','2022-06-14 13:16:26','2022-06-14 15:16:17','30_w1_o1_mandibule_snapshot_0.png','2022-06-14 15:16:26','SYNCED','9ff81c89-8932-4154-acbf-a1b46fe30571',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.30.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'a0351106-572b-4d51-a84c-7d3d1c8d4bc2','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/4fa1a134-d246-43d7-aa8c-b42e24b62b49/session_6aedf6fd-46d7-4259-88ba-5cf074ad5913/occlusion_47192ebb-25b6-4c9e-a09f-8ed295e60a87/scan_283f28e2-92dd-426a-bc9e-a4fe6fdb180c/60_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_4fa1a134-d246-43d7-aa8c-b42e24b62b49_ACT_6aedf6fd-46d7-4259-88ba-5cf074ad5913_SESS_47192ebb-25b6-4c9e-a09f-8ed295e60a87_TOSC_283f28e2-92dd-426a-bc9e-a4fe6fdb180c_SNAPS_','2023-03-07 18:02:30','2023-03-07 19:02:09','60_w1_o1_maxillaire_snapshot_1.png','2023-03-07 19:02:30','SYNCED','5ac4b146-77ec-42e3-9705-fadde16d1ea0',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.60.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'a0900aa8-5d3a-417a-b72a-99a7368de3b7','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_2ffbfbca-f236-4802-be93-8eb43d523274/scan_eb904683-acc6-4e6d-8900-3982d403ba0f/4_w1_o1_mordu_anterieur_scan_file_1.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_2ffbfbca-f236-4802-be93-8eb43d523274_FRSC_eb904683-acc6-4e6d-8900-3982d403ba0f_ZIP_','2022-01-19 19:13:33','2022-01-19 20:13:23','4_w1_o1_mordu_anterieur_scan_file_1.zip','2022-01-19 20:13:33','SYNCED','df493b46-f498-46f5-862e-735db106fc71',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.4.1.1.1\",\"modelMatrix\":\"0.92977,-0.258814,0.27194,0,0.220301,0.966039,0.0839037,0,-0.29607,-0.0183757,0.958759,0,4.8152,-6.1951,-20.4448,1\",\"title\":\"Mordu anterieur ZIP\"}'),(2,'a0e5b4b9-4dd7-461c-9ae7-afaffaa18202','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a4b302c-278d-4e12-ace5-f095ba0bf856/session_6206892a-2e7e-4765-ac90-b49bfb465997/occlusion_3c30231c-7cd7-4431-985b-2eaf7f6925ae/scan_587e0605-ba57-4583-83e9-a1cc32707c91/3_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_587e0605-ba57-4583-83e9-a1cc32707c91_SNAPS_','2022-09-06 09:17:50','2022-08-30 10:53:38','3_w1_o1_maxillaire_snapshot_0.png','2022-09-06 11:17:50','SYNCED','a0e5b4b9-4dd7-461c-9ae7-afaffaa18202',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.3.1.1.4\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'a0f1c5f4-8b35-4db9-8ae4-da64e546d1f6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/scan_f4fff5f5-f728-44ae-ac48-f3e653594098/23_w1_o1_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_FRSC_f4fff5f5-f728-44ae-ac48-f3e653594098_SNAPS_','2022-05-13 10:11:34','2022-05-13 12:11:24','23_w1_o1_mordu_anterieur_snapshot_0.png','2022-05-13 12:11:34','SYNCED','a0f1c5f4-8b35-4db9-8ae4-da64e546d1f6',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.23.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'a11db9db-de18-4c30-95d8-aec6ae5499fe','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/8b4b6de2-edd8-44e6-88c6-8a151914aca6/session_40a1b174-1058-4d27-b63a-4e8f565fb520/occlusion_8eba4eab-4337-436a-8eb6-b59e63415159/computedocclusion_95fe0a5e-fe67-469d-aab1-023211e73996/48_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_8b4b6de2-edd8-44e6-88c6-8a151914aca6_ACT_40a1b174-1058-4d27-b63a-4e8f565fb520_SESS_8eba4eab-4337-436a-8eb6-b59e63415159_OCC_95fe0a5e-fe67-469d-aab1-023211e73996_BOMA__MATRX_','2022-11-10 10:40:10','2022-11-10 11:39:57','48_w1_o1_mandibule_matrix_occ_file_0.m','2022-11-10 11:40:10','SYNCED','a11db9db-de18-4c30-95d8-aec6ae5499fe',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.48.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.48.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.48.1.1.1 Occlusion 1\"}'),(1001,'a13ef72a-3421-4e8c-a897-3f43da14e842','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_1c86378e-7d31-4b12-82ff-af797020160f/4_w1_o2_mandibule_snapshot_0.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_BOSC_1c86378e-7d31-4b12-82ff-af797020160f_SNAPS_','2022-03-08 11:34:09','2022-03-08 12:34:00','4_w1_o2_mandibule_snapshot_0.png','2022-03-08 12:34:09','SYNCED','a13ef72a-3421-4e8c-a897-3f43da14e842',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.2.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'a1744e13-506f-49aa-94ed-484f1aed9d14','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/9e399d73-4d2e-4bb8-af48-a4e597811faa/session_b1cf14ce-00a9-48b6-8654-dadde26073f1/occlusion_3c4595e0-fbbb-4814-8851-1e014eb9a3b2/scan_dde349dc-caa1-49dc-8205-ba84c97567bf/46_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_9e399d73-4d2e-4bb8-af48-a4e597811faa_ACT_b1cf14ce-00a9-48b6-8654-dadde26073f1_SESS_3c4595e0-fbbb-4814-8851-1e014eb9a3b2_BOSC_dde349dc-caa1-49dc-8205-ba84c97567bf_ZIP_','2022-11-24 13:34:01','2022-11-24 14:34:00','46_w1_o1_maxillaire_scan_file_1.zip','2022-11-24 14:34:01','SYNCED','1ab76985-608d-4f1d-ad18-01454909d344',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.46.1.1.6\",\"modelMatrix\":\"-0.781388,0.613261,-0.115515,0,-0.624045,-0.767885,0.14464,0,3.896e-09,0.185107,0.982718,0,20.8068,-10.6268,-17.296,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'a1b9dbd6-1067-4531-89ab-a474ccdccbfe','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7f47fd88-9ea0-4c08-9193-a54d4f158c7c/session_7873a396-419c-4215-83c7-fec9f2742ccf/occlusion_2e287bb0-e19a-414a-9177-23b335d286d9/computedocclusion_389a085b-21e0-4004-9d53-dfcb5c4bd2f1/16_w1_o2_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_7f47fd88-9ea0-4c08-9193-a54d4f158c7c_ACT_7873a396-419c-4215-83c7-fec9f2742ccf_SESS_2e287bb0-e19a-414a-9177-23b335d286d9_OCC_389a085b-21e0-4004-9d53-dfcb5c4bd2f1_BOPLY__ZIP_','2022-06-03 09:04:39','2022-06-03 11:04:23','16_w1_o2_mandibule_occlusion_occ_file_0.zip','2022-06-03 11:04:39','SYNCED','a1b9dbd6-1067-4531-89ab-a474ccdccbfe',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.16.1.2.1 Occlusion 1\",\"modelMatrix\":\"-0.864845,0.473616,-0.166526,0,-0.502038,-0.815882,0.286869,0,-7.35692e-09,0.3317,0.943385,0,-0.119603,-7.43592,-19.1524,1\",\"referenceScanID\":\"1.16.1.2.1\",\"title\":\"Mandibule 1.16.1.2.1 Occlusion 1\"}'),(1001,'a1e37bd8-7e7c-4e4e-8506-870b2a3e0594','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/39062d60-7a18-417a-9004-c58e9ce7d62a/session_9869e99c-7b47-4662-9766-0388d668fbf3/occlusion_36832844-9579-46df-aea1-b9baf6ad8787/computedocclusion_a2f94254-4555-4b27-973a-d1034950f081/61_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_39062d60-7a18-417a-9004-c58e9ce7d62a_ACT_9869e99c-7b47-4662-9766-0388d668fbf3_SESS_36832844-9579-46df-aea1-b9baf6ad8787_OCC_a2f94254-4555-4b27-973a-d1034950f081_TOMA__MATRX_','2023-03-10 17:33:54','2023-03-10 18:33:29','61_w1_o1_maxillaire_matrix_occ_file_0.m','2023-03-10 18:33:54','SYNCED','a1e37bd8-7e7c-4e4e-8506-870b2a3e0594',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.61.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.61.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.61.1.1.1 Occlusion 1\"}'),(1001,'a21ef8f4-f744-47a0-a25e-660ba3f7901b','','SNAPS','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_c9079d19-8ffb-46f7-a51e-3a7a90ccae59_SESS_8ba0f3b1-408f-4a02-92a0-63f09123b68e_BOSC_cf1df2e4-52f9-48a2-8e0b-54a1e4ed5741_SNAPS_','2022-01-28 17:15:45','2022-01-26 15:48:06','','2022-01-28 18:15:45','SYNCED','cdd9fdce-3676-419e-aab1-ed095f43e2bf',1,'2022-01-28 18:15:45','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.10.1.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'a25ff0a9-2187-4450-a8c0-3e7dd53302af','','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_BOSC_07148fa2-1d5b-4343-81f9-ef44df15e4c7_SNAPS_','2022-02-19 17:53:24','2022-02-14 19:20:08','','2022-02-19 18:53:24','SYNCED','a25ff0a9-2187-4450-a8c0-3e7dd53302af',0,'2022-02-19 18:53:24','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.4.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'a27566e2-5edb-4da7-b379-b24af5d20c36','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_c76850a7-9433-47f8-825d-ced9f35dede0/24_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_BOSC_c76850a7-9433-47f8-825d-ced9f35dede0_ZIP_','2022-05-13 14:11:03','2022-05-13 16:10:51','24_w1_o1_mandibule_scan_file_0.zip','2022-05-13 16:11:03','SYNCED','a27566e2-5edb-4da7-b379-b24af5d20c36',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.24.1.1.1\",\"modelMatrix\":\"0.852703,-0.521011,0.0380208,0,0.522396,0.850441,-0.062061,0,3.49638e-10,0.0727815,0.997348,0,-11.3911,-12.8136,-21.1334,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'a2b88e98-2d9c-4985-b0c8-0632851521ac','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/computedocclusion_b35629de-38d8-4cdd-bf2c-b61c461410cb/17_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_b35629de-38d8-4cdd-bf2c-b61c461410cb_TOPLY__ZIP_','2022-02-07 18:09:03','2022-02-07 19:05:55','17_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-02-07 19:09:03','SYNCED','a2b88e98-2d9c-4985-b0c8-0632851521ac',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.17.1.1.1 Occlusion 6\",\"modelMatrix\":\"0.149253,0.920186,-0.361913,0,-0.988799,0.138896,-0.0546284,0,-8.90892e-10,0.366013,0.93061,0,-24.4594,-29.735,-12.8678,1\",\"referenceScanID\":\"1.17.1.1.1\",\"title\":\"Maxillaire 1.17.1.1.1 Occlusion 6\"}'),(1001,'a2bd934e-395a-4ab4-b7f9-5187518d5460','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_ce625ba7-4218-40af-b344-df718da13f83/54_w1_o1_snapshot_occ_file_6.png','SNAPS','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_ce625ba7-4218-40af-b344-df718da13f83_SNAPO__SNAPS_','2023-03-15 10:35:08','2023-03-15 11:32:26','54_w1_o1_snapshot_occ_file_6.png','2023-03-15 11:35:08','SYNCED','7646ffac-dba0-4ac0-b4a3-8547134e5318',6,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'a2e618eb-cf61-4c3b-8bdc-f71bb9c9e421','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/372000f2-2471-4a57-9b18-224d0788041f/session_5dd64d24-8e33-45bd-a282-c148c185c338/occlusion_a61fbfda-1ac5-4747-9e0c-6ef664930816/scan_a716cac5-0e02-481c-a14b-3fc981cdeb96/57_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_372000f2-2471-4a57-9b18-224d0788041f_ACT_5dd64d24-8e33-45bd-a282-c148c185c338_SESS_a61fbfda-1ac5-4747-9e0c-6ef664930816_BOSC_a716cac5-0e02-481c-a14b-3fc981cdeb96_ZIP_','2023-02-17 10:46:00','2023-02-17 11:45:54','57_w1_o1_mandibule_scan_file_1.zip','2023-02-17 11:46:00','SYNCED','c8d6f116-fd4d-4775-9778-21b0bc8a380a',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.57.1.1.1\",\"modelMatrix\":\"0.217078,0.961138,-0.170559,0,-0.976154,0.213739,-0.0379291,0,6.60661e-10,0.174726,0.984617,0,-6.98534,-5.72342,-20.6581,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'a3123ce9-0a29-44e7-bcac-a52435f09641','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/scan_64badb85-f6d8-46a0-8cc4-2125845f9e47/22_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_RISC_64badb85-f6d8-46a0-8cc4-2125845f9e47_ZIP_','2022-04-21 11:13:13','2022-04-21 13:13:07','22_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-04-21 13:13:13','SYNCED','a3123ce9-0a29-44e7-bcac-a52435f09641',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.22.1.1.3\",\"modelMatrix\":\"0.985334,-0.166578,0.0259059,0,0.170153,0.983505,-0.0709395,0,-0.0130759,0.0706275,0.997151,0,-0.724133,-4.65401,-17.4344,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'a353c4ca-59ef-4c7c-a4bd-45852b0bd715','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/order_8a9c0203-cf65-4431-a383-136329150bbd/12_w1_autre_prost_file_a353c4ca-59ef-4c7c-a4bd-45852b0bd715_0.pdf','PDF','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_PROST_8a9c0203-cf65-4431-a383-136329150bbd_PDF_','2022-02-04 18:06:55','2022-02-04 19:06:54','12_w1_autre_prost_file_a353c4ca-59ef-4c7c-a4bd-45852b0bd715_0.pdf','2022-02-04 19:06:55','SYNCED','a353c4ca-59ef-4c7c-a4bd-45852b0bd715',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.12.1.1 AUTRE FICHE DE PROTHESE\",\"title\":\"Autre PDF\"}'),(1001,'a360a2dd-98b2-4d38-8590-55792ba9a418','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/scan_eafe4b37-e7ad-4f58-b931-a99f31f6d4a4/22_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_BOSC_eafe4b37-e7ad-4f58-b931-a99f31f6d4a4_ZIP_','2022-04-21 10:50:46','2022-04-21 12:50:37','22_w1_o1_mandibule_scan_file_1.zip','2022-04-21 12:50:46','SYNCED','68e7c3a1-6552-416d-a849-77f78c6c1539',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.22.1.1.1\",\"modelMatrix\":\"0.955284,-0.295231,0.0164688,0,0.29569,0.953801,-0.0532056,0,-9.04209e-10,0.0556961,0.998448,0,-1.05738,9.66348,-22.4364,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'a36b0070-fd2e-4bed-b8ef-f49b7a04b0eb','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_ce625ba7-4218-40af-b344-df718da13f83/54_w1_o1_mandibule_matrix_occ_file_1.m','MATRX','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_ce625ba7-4218-40af-b344-df718da13f83_BOMA__MATRX_','2023-03-15 10:16:44','2023-03-15 11:15:16','54_w1_o1_mandibule_matrix_occ_file_1.m','2023-03-15 11:16:44','SYNCED','45775437-46ca-4831-b788-61b2ad12ff31',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.54.1.1.4 Occlusion 1\",\"referenceScanID\":\"1.54.1.1.4\",\"title\":\"Matrice Transfo. Mandibule 1.54.1.1.4 Occlusion 1\"}'),(1001,'a3983784-e00f-4a0d-ac07-1fa9e1c16ad9','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_d1eece96-1e6b-468d-8dc5-8295ca2149a4/24_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_LESC_d1eece96-1e6b-468d-8dc5-8295ca2149a4_SNAPS_','2022-05-13 14:46:32','2022-05-13 16:46:22','24_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-05-13 16:46:32','SYNCED','a3983784-e00f-4a0d-ac07-1fa9e1c16ad9',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.24.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'a3e66aa6-7b7c-4d22-b55c-65dba960ada3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_16f04a07-72e8-4a39-9b55-3ae7405733af/24_w1_o1_maxillaire_scan_file_3.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_TOSC_16f04a07-72e8-4a39-9b55-3ae7405733af_ZIP_','2022-06-13 14:49:07','2022-06-13 16:48:56','24_w1_o1_maxillaire_scan_file_3.zip','2022-06-13 16:49:07','SYNCED','d3ff533f-e540-46c8-8f68-b5341a94ad72',3,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.4\",\"modelMatrix\":\"0.468816,0.851463,-0.234993,0,-0.883296,0.451921,-0.124724,0,3.16254e-09,0.266041,0.963962,0,-15.9085,-5.48362,-18.8921,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'a3f2a1f8-ae1e-48e1-a6ab-515fa04c3b55','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f9d03016-567a-4bd4-9cc5-dafeea34e365/session_a7bcb190-dd19-4f3b-8aab-266030bf4064/occlusion_c321e210-b67c-40e8-bece-f8946164a768/scan_e7993d2d-cc6b-42d8-af77-232b04342812/36_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_f9d03016-567a-4bd4-9cc5-dafeea34e365_ACT_a7bcb190-dd19-4f3b-8aab-266030bf4064_SESS_c321e210-b67c-40e8-bece-f8946164a768_TOSC_e7993d2d-cc6b-42d8-af77-232b04342812_SNAPS_','2022-07-04 14:04:56','2022-07-04 16:04:45','36_w1_o1_maxillaire_snapshot_0.png','2022-07-04 16:04:56','SYNCED','a3f2a1f8-ae1e-48e1-a6ab-515fa04c3b55',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.36.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'a40d913c-74f9-49c2-a50f-cc2226955dfa','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f9d03016-567a-4bd4-9cc5-dafeea34e365/session_a7bcb190-dd19-4f3b-8aab-266030bf4064/occlusion_c321e210-b67c-40e8-bece-f8946164a768/computedocclusion_03fe87bc-2a25-4d16-a476-2df62bb3cf76/36_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_f9d03016-567a-4bd4-9cc5-dafeea34e365_ACT_a7bcb190-dd19-4f3b-8aab-266030bf4064_SESS_c321e210-b67c-40e8-bece-f8946164a768_OCC_03fe87bc-2a25-4d16-a476-2df62bb3cf76_BOPLY__ZIP_','2022-07-04 14:14:02','2022-07-04 16:13:45','36_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-07-04 16:14:02','SYNCED','a40d913c-74f9-49c2-a50f-cc2226955dfa',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.36.1.1.1 Occlusion 2\",\"modelMatrix\":\"0.642095,-0.756672,0.12313,0,0.766625,0.633759,-0.103128,0,-2.36675e-09,0.160612,0.987018,0,-11.9604,2.52084,-21.6228,1\",\"referenceScanID\":\"1.36.1.1.1\",\"title\":\"Mandibule 1.36.1.1.1 Occlusion 2\"}'),(1001,'a4310095-689c-47d1-a99d-3dfc77d2344e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/occlusion_a2220645-c79d-4dda-b6cc-772384a4106b/scan_0136d883-d517-448a-82a3-bfcdd5f4c35c/38_w1_o1_maxillaire_ml_0_0.xyz','LIFI','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_TOSC_0136d883-d517-448a-82a3-bfcdd5f4c35c_LIFI_','2022-07-19 12:28:52','2022-07-19 14:28:51','38_w1_o1_maxillaire_ml_0_0.xyz','2022-07-19 14:28:52','SYNCED','a4310095-689c-47d1-a99d-3dfc77d2344e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.38.1.1.1 Ligne de finition 0\",\"name\":\"Ligne de finition 0\",\"title\":\"Maxillaire LIFI\",\"toothNumber\":0,\"versionMarginLine\":1}'),(1001,'a4650e1f-2299-484d-b4d0-8ef10d8b811c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/204921b5-c765-4248-8e87-e3b0f7a46bff/session_88257045-93fb-43fb-8b0a-f39fbf5f8e9d/occlusion_ad360501-c145-40e5-9b88-808cd7a61eed/scan_fbf36163-e1ef-42da-9ec3-02d6cc9846f2/45_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_204921b5-c765-4248-8e87-e3b0f7a46bff_ACT_88257045-93fb-43fb-8b0a-f39fbf5f8e9d_SESS_ad360501-c145-40e5-9b88-808cd7a61eed_TOSC_fbf36163-e1ef-42da-9ec3-02d6cc9846f2_SNAPS_','2022-10-18 12:45:04','2022-10-18 14:42:14','45_w1_o1_maxillaire_snapshot_1.png','2022-10-18 14:45:04','SYNCED','01871527-25ae-49af-96e9-808249dbae23',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.45.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'a47f7028-b44e-4922-80ba-98156019677c','','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_BOSC_4aa73b1e-d6d0-436c-8abe-c649026c7ff2_ZIP_','2022-02-19 17:53:24','2022-02-14 18:57:22','','2022-02-19 18:53:24','SYNCED','a47f7028-b44e-4922-80ba-98156019677c',0,'2022-02-19 18:53:24','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.4.1\",\"modelMatrix\":\"-0.464753,-0.88126,0.0859365,0,0.88544,-0.462559,0.0451066,0,5.93096e-10,0.0970551,0.995279,0,4.38335,16.2715,-22.6813,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'a4896c47-7cb7-4dae-83eb-fa24f032eea2','','MATRX','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_OCC_ac3a5a7c-5db4-4c82-a2a9-9cb52e09f003_TOMA__MATRX_','2022-05-12 12:34:04','2022-05-12 14:33:33','',NULL,'CREATED','a4896c47-7cb7-4dae-83eb-fa24f032eea2',0,'2022-05-12 14:34:04','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.18.1.1.2 Occlusion 4\",\"referenceScanID\":\"1.18.1.1.2\",\"title\":\"Matrice Transfo. Maxillaire 1.18.1.1.2 Occlusion 4\"}'),(1001,'a517137b-b7a8-4943-9382-ebbdbf922a1e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/1a8329eb-7dbc-4bfd-b669-6d92e13fec0c/session_11fb4259-c305-4a08-b750-536f769f44b0/occlusion_129468ab-1f43-4ba1-8939-49286128bf4d/scan_be01aaf8-9fe4-4356-a76d-15d6d39e3fe3/47_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_1a8329eb-7dbc-4bfd-b669-6d92e13fec0c_ACT_11fb4259-c305-4a08-b750-536f769f44b0_SESS_129468ab-1f43-4ba1-8939-49286128bf4d_BOSC_be01aaf8-9fe4-4356-a76d-15d6d39e3fe3_SNAPS_','2022-10-21 16:13:47','2022-10-21 18:12:05','47_w1_o1_mandibule_snapshot_0.png','2022-10-21 18:13:47','SYNCED','a517137b-b7a8-4943-9382-ebbdbf922a1e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.47.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'a54c946c-a9df-45b0-aa2e-35efdf9f6439','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/57c4096f-98dd-49c8-bea5-a5b109ad3fd0/session_4f62e395-5623-4d5b-869c-1b2fc4d22b00/occlusion_1ac20dc7-b36b-4786-a05f-37091554dc5c/computedocclusion_70f4220e-2a6b-4575-bd0e-09c14a13d758/31_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_57c4096f-98dd-49c8-bea5-a5b109ad3fd0_ACT_4f62e395-5623-4d5b-869c-1b2fc4d22b00_SESS_1ac20dc7-b36b-4786-a05f-37091554dc5c_OCC_70f4220e-2a6b-4575-bd0e-09c14a13d758_TOPLY__ZIP_','2022-06-16 11:04:11','2022-06-16 13:03:55','31_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-06-16 13:04:11','SYNCED','a54c946c-a9df-45b0-aa2e-35efdf9f6439',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.31.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.997887,0.0642305,-0.00984649,0,-0.0649809,0.986364,-0.151209,0,-4.81543e-10,0.151529,0.988453,0,-2.47476,-6.56649,-21.1676,1\",\"referenceScanID\":\"1.31.1.1.1\",\"title\":\"Maxillaire 1.31.1.1.1 Occlusion 1\"}'),(1001,'a54e4171-5c5e-4511-b121-ee88f35a82f8','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_ce625ba7-4218-40af-b344-df718da13f83/54_w1_o1_mandibule_matrix_occ_file_4.m','MATRX','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_ce625ba7-4218-40af-b344-df718da13f83_BOMA__MATRX_','2023-03-15 10:27:01','2023-03-15 11:26:20','54_w1_o1_mandibule_matrix_occ_file_4.m','2023-03-15 11:27:01','SYNCED','45775437-46ca-4831-b788-61b2ad12ff31',4,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.54.1.1.4 Occlusion 1\",\"referenceScanID\":\"1.54.1.1.4\",\"title\":\"Matrice Transfo. Mandibule 1.54.1.1.4 Occlusion 1\"}'),(1001,'a56e4135-1746-4816-a932-a6665dce1074','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_ce625ba7-4218-40af-b344-df718da13f83/54_w1_o1_mandibule_matrix_occ_file_5.m','MATRX','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_ce625ba7-4218-40af-b344-df718da13f83_BOMA__MATRX_','2023-03-15 10:35:03','2023-03-15 11:32:25','54_w1_o1_mandibule_matrix_occ_file_5.m','2023-03-15 11:35:03','SYNCED','45775437-46ca-4831-b788-61b2ad12ff31',5,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.54.1.1.4 Occlusion 1\",\"referenceScanID\":\"1.54.1.1.4\",\"title\":\"Matrice Transfo. Mandibule 1.54.1.1.4 Occlusion 1\"}'),(1001,'a592e8f8-a0ee-44b9-9aa2-9e88a48ddca9','','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_1500b3eb-4b86-46c1-9c9f-7efbd0224ac8_BOPLY__ZIP_','2022-05-25 08:56:38','2022-05-13 18:22:04','','2022-05-25 10:56:38','SYNCED','a592e8f8-a0ee-44b9-9aa2-9e88a48ddca9',0,'2022-05-25 10:56:38','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.24.1.1.1 Occlusion 4\",\"modelMatrix\":\"0.852703,-0.521011,0.0380208,0,0.522396,0.850441,-0.062061,0,3.49638e-10,0.0727815,0.997348,0,-11.3911,-12.8136,-21.1334,1\",\"referenceScanID\":\"1.24.1.1.1\",\"title\":\"Mandibule 1.24.1.1.1 Occlusion 4\"}'),(1001,'a5a65004-12be-4f11-9b79-c3b1d218f4df','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_b1201d2a-0fbf-48bc-a1c2-f3649c1ca576/18_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_BOSC_b1201d2a-0fbf-48bc-a1c2-f3649c1ca576_ZIP_','2022-05-10 14:00:12','2022-05-10 16:00:02','18_w1_o1_mandibule_scan_file_0.zip','2022-05-10 16:00:12','SYNCED','a5a65004-12be-4f11-9b79-c3b1d218f4df',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.18.1.1.3\",\"modelMatrix\":\"-0.721265,0.622319,-0.304132,0,-0.69266,-0.648019,0.316692,0,5.59464e-09,0.439079,0.898449,0,-8.58806,-18.2472,-17.8803,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'a5ed4ec1-1055-4583-8f19-2ee0942ee99d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/d100e894-0be9-4495-94e2-e469232f7817/session_2c8b85b5-c805-4b08-85e7-3d02dab72e99/occlusion_8a278cc5-a1c1-4dfb-9ee2-c971a6309afa/scan_6c418416-1c53-40cd-ba49-f56373b0bc1a/15_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_d100e894-0be9-4495-94e2-e469232f7817_ACT_2c8b85b5-c805-4b08-85e7-3d02dab72e99_SESS_8a278cc5-a1c1-4dfb-9ee2-c971a6309afa_BOSC_6c418416-1c53-40cd-ba49-f56373b0bc1a_SNAPS_','2022-02-01 15:02:14','2022-02-01 16:01:53','15_w1_o1_mandibule_snapshot_0.png','2022-02-01 16:02:14','SYNCED','a5ed4ec1-1055-4583-8f19-2ee0942ee99d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.15.1.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'a6877aaa-6599-4bba-a1a9-275adfcb1c68','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_4ed7adaa-3b77-4537-8479-4d0c4bd28c7b/12_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_TOSC_4ed7adaa-3b77-4537-8479-4d0c4bd28c7b_ZIP_','2022-01-27 11:58:32','2022-01-27 12:58:07','12_w1_o1_maxillaire_scan_file_1.zip','2022-01-27 12:58:32','SYNCED','3188c2ad-80df-4826-920c-b8f1b834ccf5',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.12.1.1.1\",\"modelMatrix\":\"0.622652,0.772747,-0.123153,0,-0.782499,0.614892,-0.0979959,0,-5.00422e-9,0.157385,0.987537,0,-21.5256,-19.2669,-19.1349,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'a68a9b64-1e64-43ce-b4bd-a56d3a3ef762','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f9d03016-567a-4bd4-9cc5-dafeea34e365/session_a7bcb190-dd19-4f3b-8aab-266030bf4064/occlusion_c321e210-b67c-40e8-bece-f8946164a768/scan_21fc87fa-c767-4333-893a-3f0ab5cd76f2/36_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_f9d03016-567a-4bd4-9cc5-dafeea34e365_ACT_a7bcb190-dd19-4f3b-8aab-266030bf4064_SESS_c321e210-b67c-40e8-bece-f8946164a768_LESC_21fc87fa-c767-4333-893a-3f0ab5cd76f2_SNAPS_','2022-07-04 14:12:22','2022-07-04 16:12:14','36_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-07-04 16:12:22','SYNCED','a68a9b64-1e64-43ce-b4bd-a56d3a3ef762',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.36.1.1.2\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'a68c2300-df5c-4b80-adbc-59147c325c82','','ZIP','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_OCC_ac3a5a7c-5db4-4c82-a2a9-9cb52e09f003_TOPLY__ZIP_','2022-05-12 12:34:04','2022-05-12 14:33:34','',NULL,'CREATED','a68c2300-df5c-4b80-adbc-59147c325c82',0,'2022-05-12 14:34:04','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.18.1.1.2 Occlusion 4\",\"modelMatrix\":\"-0.979743,-0.199678,0.0152522,0,0.20026,-0.976897,0.0746194,0,-1.52856e-10,0.0761623,0.997095,0,19.5629,-11.4708,-22.5064,1\",\"referenceScanID\":\"1.18.1.1.2\",\"title\":\"Maxillaire 1.18.1.1.2 Occlusion 4\"}'),(1001,'a6c18f23-3ae1-43e9-9a43-453be1c719a4','','SNAPS','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_BOSC_3379235c-b42d-440c-84bc-d105a1d56127_SNAPS_','2022-03-09 07:54:47','2022-03-08 11:27:31','','2022-03-09 08:54:47','SYNCED','a6c18f23-3ae1-43e9-9a43-453be1c719a4',0,'2022-03-09 08:54:47','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'a6c9d6d8-9079-4d06-9fa7-7e2c397cc64c','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_19ce66b5-7943-4a9e-82cd-f21481da98cc/54_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_19ce66b5-7943-4a9e-82cd-f21481da98cc_TOPLY__ZIP_','2023-03-15 10:41:57','2023-03-15 11:40:15','54_w1_o1_maxillaire_occlusion_occ_file_0.zip','2023-03-15 11:41:57','SYNCED','a6c9d6d8-9079-4d06-9fa7-7e2c397cc64c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.54.1.1.2 Occlusion 2\",\"modelMatrix\":\"0.78238,0.620977,-0.0476379,0,-0.622801,0.780088,-0.059844,0,1.97556e-09,0.0764897,0.99707,0,-23.5433,3.60536,-19.7037,1\",\"referenceScanID\":\"1.54.1.1.2\",\"title\":\"Maxillaire 1.54.1.1.2 Occlusion 2\"}'),(1001,'a74a17e1-08c2-4a1c-9618-7a1a097d89b8','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/9e399d73-4d2e-4bb8-af48-a4e597811faa/session_b1cf14ce-00a9-48b6-8654-dadde26073f1/occlusion_1060c95f-48f4-4a37-9b82-03bfd8329730/scan_7887f7ce-288b-4f04-a7cd-7a7c58e2e5f9/46_w1_o2_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_9e399d73-4d2e-4bb8-af48-a4e597811faa_ACT_b1cf14ce-00a9-48b6-8654-dadde26073f1_SESS_1060c95f-48f4-4a37-9b82-03bfd8329730_RISC_7887f7ce-288b-4f04-a7cd-7a7c58e2e5f9_SNAPS_','2023-01-20 14:41:02','2023-01-20 15:38:55','46_w1_o2_mordu_posterieur_droit_snapshot_0.png','2023-01-20 15:41:02','SYNCED','a74a17e1-08c2-4a1c-9618-7a1a097d89b8',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.46.1.2.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'a7627f82-464a-4b42-b301-214bc0cb5f5f','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/490e4b04-6edd-4f47-a2ed-232689892eca/session_62105a91-1675-4d36-88bd-34aa8fe2ce3c/occlusion_03784c27-fd8d-4745-9c26-d84c490869b3/scan_2b1e22f8-a080-4217-9229-4821ea93965d/56_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_490e4b04-6edd-4f47-a2ed-232689892eca_ACT_62105a91-1675-4d36-88bd-34aa8fe2ce3c_SESS_03784c27-fd8d-4745-9c26-d84c490869b3_BOSC_2b1e22f8-a080-4217-9229-4821ea93965d_SNAPS_','2023-02-17 09:35:02','2023-02-17 10:34:54','56_w1_o1_mandibule_snapshot_0.png','2023-02-17 10:35:02','SYNCED','a7627f82-464a-4b42-b301-214bc0cb5f5f',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.56.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'a8374abc-5fc4-4fa5-ae16-6f40012d91fe','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_4f8dc275-857c-482a-9886-5521591e9661/scan_000f859e-bd0c-453b-b60b-dddef781cd58/12_w1_o4_maxillaire_scan_file_0.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_TOSC_000f859e-bd0c-453b-b60b-dddef781cd58_ZIP_','2022-02-14 17:48:23','2022-02-14 18:48:10','12_w1_o4_maxillaire_scan_file_0.zip','2022-02-14 18:48:23','SYNCED','a8374abc-5fc4-4fa5-ae16-6f40012d91fe',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.12.1.4.2\",\"modelMatrix\":\"0.391933,0.866585,-0.308901,0,-0.919994,0.369179,-0.131597,0,-2.19795e-09,0.335764,0.941946,0,-18.947,-18.6547,-19.6427,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'a8876c47-7256-480c-887f-a31e06590e3b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/458c92d8-9da1-4df9-967f-d14fc7e6303d/session_55831d43-1906-4a22-9b7a-ed4b2820c8b2/occlusion_4f582d4c-81d0-4e01-8be3-9ff53b12c7f4/scan_6d0788eb-96a4-43dc-aa97-e9dbd7601d00/10_w2_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_55831d43-1906-4a22-9b7a-ed4b2820c8b2_SESS_4f582d4c-81d0-4e01-8be3-9ff53b12c7f4_BOSC_6d0788eb-96a4-43dc-aa97-e9dbd7601d00_ZIP_','2022-06-16 13:35:06','2022-06-16 15:34:57','10_w2_o1_mandibule_scan_file_0.zip','2022-06-16 15:35:06','SYNCED','a8876c47-7256-480c-887f-a31e06590e3b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.10.2.1.2\",\"modelMatrix\":\"0.582885,-0.72158,0.373587,0,0.812555,0.517624,-0.267992,0,3.71467e-09,0.459768,0.888039,0,16.6062,-17.753,-20.882,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'a88d2462-16b1-4e78-a728-a01f093e8cf3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3cc1b522-8e7d-4196-87a1-a8c234f0a399/session_ef503949-33e8-4db6-bbfa-456bd8b70b73/occlusion_e8e2758f-faa4-4db7-93df-e94ddfbd8284/scan_196c009b-c574-426c-a21b-072953b20ef0/51_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_3cc1b522-8e7d-4196-87a1-a8c234f0a399_ACT_ef503949-33e8-4db6-bbfa-456bd8b70b73_SESS_e8e2758f-faa4-4db7-93df-e94ddfbd8284_BOSC_196c009b-c574-426c-a21b-072953b20ef0_ZIP_','2022-11-28 16:59:53','2022-11-28 17:59:42','51_w1_o1_mandibule_scan_file_0.zip','2022-11-28 17:59:53','SYNCED','a88d2462-16b1-4e78-a728-a01f093e8cf3',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.51.1.1.1\",\"modelMatrix\":\"-0.891818,0.410107,-0.19098,0,-0.452395,-0.808454,0.376485,0,6.91464e-09,0.422154,0.906524,0,28.4542,-3.61715,-13.9473,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'a88ec234-530c-4987-8fc0-9de5bb04a904','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_49bd090f-1a01-4a79-8202-62487b9af783/18_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_BOSC_49bd090f-1a01-4a79-8202-62487b9af783_SNAPS_','2022-03-07 14:12:06','2022-03-07 15:12:03','18_w1_o1_mandibule_snapshot_0.png','2022-03-07 15:12:06','SYNCED','a88ec234-530c-4987-8fc0-9de5bb04a904',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.18.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'a8e5687e-19fc-4dcf-955c-ddab334d6346','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/computedocclusion_35af1bf5-285a-4bb1-a6db-fe9897defe51/23_w1_o1_ml_occ_file_to1001.xyz','LIFI','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_35af1bf5-285a-4bb1-a6db-fe9897defe51_LIFIO_LIFI_','2022-05-25 10:45:10','2022-05-25 12:45:09','23_w1_o1_ml_occ_file_to1001.xyz','2022-05-25 12:45:10','SYNCED','a8e5687e-19fc-4dcf-955c-ddab334d6346',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.23.1.1.1 Occlusion 4 Ligne de finition 1\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"Maxillaire\",\"name\":\"Ligne de finition 1\",\"title\":\"Ligne finition\",\"toothNumber\":1001}'),(1001,'a8e57a61-55b2-4aa0-9a71-87da91116564','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/discussion_4d12bcc3-80f2-49dc-9159-54929f160ce6/a8e57a61-55b2-4aa0-9a71-87da91116564.m','MATRX','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_426bd908-3163-4291-a697-20eacff771ab_TOMA__MATRX_','2022-05-25 08:56:22','2022-05-16 19:57:11','a8e57a61-55b2-4aa0-9a71-87da91116564.m','2022-05-25 10:56:22','SYNCED','a8e57a61-55b2-4aa0-9a71-87da91116564',0,'2022-05-25 10:56:22','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.24.1.1.2 Occlusion 6\",\"referenceScanID\":\"1.24.1.1.2\",\"title\":\"Matrice Transfo. Maxillaire 1.24.1.1.2 Occlusion 6\"}'),(1001,'a8fe8aec-2370-4436-b402-eb13b571de0f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/fa7fa96b-f393-4b9a-8198-144702462cfa/session_4bed076c-8541-4a2f-800a-5aeb4cb49de5/occlusion_16b82fca-4b65-4866-af87-1f6dbb42f5dc/computedocclusion_94a0167c-6798-4c78-a76c-cb9fc91ccdda/35_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_fa7fa96b-f393-4b9a-8198-144702462cfa_ACT_4bed076c-8541-4a2f-800a-5aeb4cb49de5_SESS_16b82fca-4b65-4866-af87-1f6dbb42f5dc_OCC_94a0167c-6798-4c78-a76c-cb9fc91ccdda_BOPLY__ZIP_','2022-06-28 15:03:34','2022-06-28 17:03:25','35_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-06-28 17:03:34','SYNCED','a8fe8aec-2370-4436-b402-eb13b571de0f',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.35.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.0975586,0.955587,-0.278094,0,-0.99523,0.0936725,-0.0272605,0,1.35871e-09,0.279427,0.960167,0,-3.44734,-12.1676,-17.3219,1\",\"referenceScanID\":\"1.35.1.1.1\",\"title\":\"Mandibule 1.35.1.1.1 Occlusion 1\"}'),(1001,'a900e9f0-e758-490c-a69c-2b93fe9c89eb','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/1a8329eb-7dbc-4bfd-b669-6d92e13fec0c/session_11fb4259-c305-4a08-b750-536f769f44b0/occlusion_129468ab-1f43-4ba1-8939-49286128bf4d/scan_430d66d5-4ccd-49c5-9614-7474c1a1d4a4/47_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_1a8329eb-7dbc-4bfd-b669-6d92e13fec0c_ACT_11fb4259-c305-4a08-b750-536f769f44b0_SESS_129468ab-1f43-4ba1-8939-49286128bf4d_LESC_430d66d5-4ccd-49c5-9614-7474c1a1d4a4_SNAPS_','2022-10-21 16:16:08','2022-10-21 18:16:01','47_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-10-21 18:16:08','SYNCED','a900e9f0-e758-490c-a69c-2b93fe9c89eb',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.47.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'a9375253-136d-4fb3-b6ba-de6ab06fadf3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_165dc4ed-fa76-4753-970f-5b2176e3e023/13_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_RISC_165dc4ed-fa76-4753-970f-5b2176e3e023_ZIP_','2022-02-04 17:55:11','2022-02-04 17:29:17','13_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-02-04 18:55:11','SYNCED','a9375253-136d-4fb3-b6ba-de6ab06fadf3',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.13.1.1.1\",\"modelMatrix\":\"0.998253,0.0534818,-0.0245601,0,-0.056238,0.998273,0.0259443,0,0.0195181,-0.024499,0.999383,0,-18.0163,0.483915,-16.2776,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'a97341f9-0b44-49b6-b4a3-32de704dc98d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_16f04a07-72e8-4a39-9b55-3ae7405733af/24_w1_o1_maxillaire_snapshot_2.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_TOSC_16f04a07-72e8-4a39-9b55-3ae7405733af_SNAPS_','2022-06-13 14:45:22','2022-06-13 16:45:09','24_w1_o1_maxillaire_snapshot_2.png','2022-06-13 16:45:22','SYNCED','ace017e9-ff30-403f-aee6-3daa66025d8d',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.4\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'a97cae90-ec12-4953-9507-bec2b3c4c454','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f4fc00ec-4af8-4a15-b427-f1c5aabf6260/session_498ae60a-23f0-44fc-9730-be499bfc4b46/occlusion_8f3d6c73-3468-45a5-85c7-93bba47ec9f7/scan_60c1cc80-0d70-4511-8993-70e3a3c146b8/30_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_f4fc00ec-4af8-4a15-b427-f1c5aabf6260_ACT_498ae60a-23f0-44fc-9730-be499bfc4b46_SESS_8f3d6c73-3468-45a5-85c7-93bba47ec9f7_BOSC_60c1cc80-0d70-4511-8993-70e3a3c146b8_SNAPS_','2022-06-14 13:19:48','2022-06-14 15:19:38','30_w1_o1_mandibule_snapshot_1.png','2022-06-14 15:19:48','SYNCED','9ff81c89-8932-4154-acbf-a1b46fe30571',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.30.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'a97e2cb6-17d0-493c-bf3b-0f57286e4530','','MATRX','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_OCC_a525c976-46dd-42bc-abc1-c7cf71f9a1f1_TOMA__MATRX_','2022-02-07 11:15:31','2022-02-04 14:58:28','','2022-02-07 12:15:31','SYNCED','a97e2cb6-17d0-493c-bf3b-0f57286e4530',0,'2022-02-07 12:15:31','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.12.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.12.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.12.1.1.1 Occlusion 1\"}'),(1001,'aa168bde-c31c-4abb-806c-d353cb934df4','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/09688939-f53f-4f00-8366-687b244de26d/session_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525/occlusion_9655a7e0-4673-41c9-90da-a48c008e2d62/scan_52f6127e-edc3-488d-ba7a-e80f19260f9b/64_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_09688939-f53f-4f00-8366-687b244de26d_ACT_cf74bd5d-1b3d-4cfd-be59-3ad404dd8525_SESS_9655a7e0-4673-41c9-90da-a48c008e2d62_TOSC_52f6127e-edc3-488d-ba7a-e80f19260f9b_SNAPS_','2023-03-30 12:17:56','2023-03-30 14:17:48','64_w1_o1_maxillaire_snapshot_0.png','2023-03-30 14:17:56','SYNCED','aa168bde-c31c-4abb-806c-d353cb934df4',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.64.1.1.4\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'aa4c3fbb-0476-41cf-bb3e-f4c22e907f61','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7f47fd88-9ea0-4c08-9193-a54d4f158c7c/session_7873a396-419c-4215-83c7-fec9f2742ccf/occlusion_2e287bb0-e19a-414a-9177-23b335d286d9/computedocclusion_389a085b-21e0-4004-9d53-dfcb5c4bd2f1/16_w1_o2_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_7f47fd88-9ea0-4c08-9193-a54d4f158c7c_ACT_7873a396-419c-4215-83c7-fec9f2742ccf_SESS_2e287bb0-e19a-414a-9177-23b335d286d9_OCC_389a085b-21e0-4004-9d53-dfcb5c4bd2f1_TOMA__MATRX_','2022-06-03 09:04:40','2022-06-03 11:04:23','16_w1_o2_maxillaire_matrix_occ_file_0.m','2022-06-03 11:04:40','SYNCED','aa4c3fbb-0476-41cf-bb3e-f4c22e907f61',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.16.1.2.1 Occlusion 1\",\"referenceScanID\":\"1.16.1.2.1\",\"title\":\"Matrice Transfo. Maxillaire 1.16.1.2.1 Occlusion 1\"}'),(1001,'aa8c868e-3e96-48bf-8efd-588c479cb684','','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_9440baee-a8bf-406c-bc0a-f5e9596f197b_BOPLY__ZIP_','2022-05-13 16:14:03','2022-05-13 18:13:11','','2022-05-13 18:14:03','SYNCED','aa8c868e-3e96-48bf-8efd-588c479cb684',0,'2022-05-13 18:14:03','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.24.1.1.1 Occlusion 3\",\"modelMatrix\":\"0.852703,-0.521011,0.0380208,0,0.522396,0.850441,-0.062061,0,3.49638e-10,0.0727815,0.997348,0,-11.3911,-12.8136,-21.1334,1\",\"referenceScanID\":\"1.24.1.1.1\",\"title\":\"Mandibule 1.24.1.1.1 Occlusion 3\"}'),(1001,'aaada05c-7c17-4fd4-9b5b-8535148a93da','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/e922efb9-8c03-445b-8a0f-449e3c43bdca/session_a2369349-1629-40ad-8784-d271bc3fbade/occlusion_292cc1aa-8b12-463b-87a1-7d9731cf886b/scan_877e5641-7010-4a8d-99a9-8005d48d7ec6/21_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_e922efb9-8c03-445b-8a0f-449e3c43bdca_ACT_a2369349-1629-40ad-8784-d271bc3fbade_SESS_292cc1aa-8b12-463b-87a1-7d9731cf886b_LESC_877e5641-7010-4a8d-99a9-8005d48d7ec6_SNAPS_','2022-04-21 08:47:27','2022-04-21 10:47:20','21_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-04-21 10:47:27','SYNCED','aaada05c-7c17-4fd4-9b5b-8535148a93da',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.21.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(2,'aabf7c65-29e7-457f-9f52-8c1f1255556e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a4b302c-278d-4e12-ace5-f095ba0bf856/session_6206892a-2e7e-4765-ac90-b49bfb465997/occlusion_3c30231c-7cd7-4431-985b-2eaf7f6925ae/scan_53241704-034c-49e7-bd41-012398465214/3_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_53241704-034c-49e7-bd41-012398465214_SNAPS_','2022-09-06 09:17:50','2022-08-30 10:39:57','3_w1_o1_maxillaire_snapshot_0.png','2022-09-06 11:17:50','SYNCED','aabf7c65-29e7-457f-9f52-8c1f1255556e',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.3.1.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'aafe4d65-1e01-4ca4-bc19-034f5c3f3ed4','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/533d4409-e39d-4a27-a0af-b59e6cf76ce3/session_319a8f1d-33fc-4f87-a108-b3eabda0510f/occlusion_3b38f07b-42cb-40b1-933f-365e568702e4/scan_109ca2c4-8222-4d02-9ac7-b4b93937e1e2/37_w1_o1_maxillaire_snapshot_2.png','SNAPS','PATIENT_533d4409-e39d-4a27-a0af-b59e6cf76ce3_ACT_319a8f1d-33fc-4f87-a108-b3eabda0510f_SESS_3b38f07b-42cb-40b1-933f-365e568702e4_TOSC_109ca2c4-8222-4d02-9ac7-b4b93937e1e2_SNAPS_','2022-07-07 15:56:37','2022-07-07 17:56:25','37_w1_o1_maxillaire_snapshot_2.png','2022-07-07 17:56:37','SYNCED','6fa5ad33-3773-4801-9f0b-ed36985cc55e',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.37.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'ab4d888e-67b6-4e2d-b756-d99726b47b1b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_72adeb31-f7a3-4840-9f93-f10e61c84bef/4_w1_o2_maxillaire_snapshot_1.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_TOSC_72adeb31-f7a3-4840-9f93-f10e61c84bef_SNAPS_','2022-02-15 12:31:40','2022-02-15 13:31:26','4_w1_o2_maxillaire_snapshot_1.png','2022-02-15 13:31:40','SYNCED','3404669d-d29f-41be-8f3a-d80595434b84',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.4.1.2.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'ab65d598-59fd-4e20-9463-d269c06e6c71','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/204921b5-c765-4248-8e87-e3b0f7a46bff/session_88257045-93fb-43fb-8b0a-f39fbf5f8e9d/occlusion_ad360501-c145-40e5-9b88-808cd7a61eed/scan_00ace894-af8c-4aaf-b048-f7c417a9225b/45_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_204921b5-c765-4248-8e87-e3b0f7a46bff_ACT_88257045-93fb-43fb-8b0a-f39fbf5f8e9d_SESS_ad360501-c145-40e5-9b88-808cd7a61eed_BOSC_00ace894-af8c-4aaf-b048-f7c417a9225b_SNAPS_','2022-10-18 12:54:31','2022-10-18 14:54:21','45_w1_o1_mandibule_snapshot_1.png','2022-10-18 14:54:31','SYNCED','e84553af-673e-45e8-8939-aee7afb1d2a6',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.45.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'abe9bf28-5109-4b6b-96f0-9db3d075c9ff','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/fa942554-dda6-4d2d-b578-ae9be6b3904d/session_b6039092-51ba-40dc-86e3-23be741dbb99/occlusion_e6bd34f2-af0e-48a6-9872-ec017a776e77/scan_1c59283c-95f4-431e-8b66-62a243009081/8_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_fa942554-dda6-4d2d-b578-ae9be6b3904d_ACT_b6039092-51ba-40dc-86e3-23be741dbb99_SESS_e6bd34f2-af0e-48a6-9872-ec017a776e77_TOSC_1c59283c-95f4-431e-8b66-62a243009081_SNAPS_','2022-01-24 17:22:53','2022-01-24 15:30:59','8_w1_o1_maxillaire_snapshot_0.png','2022-01-24 18:22:53','SYNCED','abe9bf28-5109-4b6b-96f0-9db3d075c9ff',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.8.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'ac0f8bbb-d9a6-428c-a397-1febe6de5982','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_e6c95ef7-636d-4c88-8d02-e2d9840573db/13_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_e6c95ef7-636d-4c88-8d02-e2d9840573db_SNAPS_','2022-01-27 16:36:58','2022-01-27 17:36:33','13_w1_o1_mandibule_snapshot_0.png','2022-01-27 17:36:58','SYNCED','ac0f8bbb-d9a6-428c-a397-1febe6de5982',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'ac34dc6a-7c17-41be-8a8f-f01a61c13e0d','','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_4f8dc275-857c-482a-9886-5521591e9661_BOSC_07148fa2-1d5b-4343-81f9-ef44df15e4c7_SNAPS_','2022-02-19 17:53:24','2022-02-14 19:30:10','','2022-02-19 18:53:24','SYNCED','a25ff0a9-2187-4450-a8c0-3e7dd53302af',1,'2022-02-19 18:53:24','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.4.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'ac8b0ff0-1835-4c06-b555-8cd869ed8dcf','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/69640c87-271c-4a44-a6fa-67b01654cc27/session_5f9199b0-eb37-4ed3-8d1a-6c38505d4913/occlusion_991beec3-fe9e-4c98-a3d4-c98e4a4c2471/computedocclusion_c7bccd1e-370e-4347-8296-1bcd4c30b631/39_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_OCC_c7bccd1e-370e-4347-8296-1bcd4c30b631_SNAPO__SNAPS_','2022-09-10 09:46:18','2022-09-10 11:45:43','39_w1_o1_snapshot_occ_file_0.png','2022-09-10 11:46:18','SYNCED','ac8b0ff0-1835-4c06-b555-8cd869ed8dcf',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'ace017e9-ff30-403f-aee6-3daa66025d8d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_16f04a07-72e8-4a39-9b55-3ae7405733af/24_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_TOSC_16f04a07-72e8-4a39-9b55-3ae7405733af_SNAPS_','2022-06-13 14:42:32','2022-06-13 16:33:03','24_w1_o1_maxillaire_snapshot_0.png','2022-06-13 16:42:32','SYNCED','ace017e9-ff30-403f-aee6-3daa66025d8d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.4\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'ad02dce8-3ff6-4167-add8-6925d6562d5e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_ce625ba7-4218-40af-b344-df718da13f83/54_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_ce625ba7-4218-40af-b344-df718da13f83_TOPLY__ZIP_','2022-12-13 09:54:35','2022-12-13 10:54:13','54_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-12-13 10:54:35','SYNCED','ad02dce8-3ff6-4167-add8-6925d6562d5e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.54.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.78238,0.620977,-0.0476379,0,-0.622801,0.780088,-0.059844,0,1.97556e-09,0.0764897,0.99707,0,-23.5433,3.60536,-19.7037,1\",\"referenceScanID\":\"1.54.1.1.1\",\"title\":\"Maxillaire 1.54.1.1.1 Occlusion 1\"}'),(1001,'ad385cc8-79ad-4c40-91ea-1275223f15d9','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/computedocclusion_864c98a3-fcf7-466a-b999-13bd4dfb8c65/23_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_864c98a3-fcf7-466a-b999-13bd4dfb8c65_BOPLY__ZIP_','2022-05-13 11:30:53','2022-05-13 13:30:43','23_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-05-13 13:30:53','SYNCED','ad385cc8-79ad-4c40-91ea-1275223f15d9',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.23.1.1.1 Occlusion 3\",\"modelMatrix\":\"0.99884,-0.00870968,0.0473501,0,0.0481445,0.180697,-0.98236,0,-1.26898e-10,0.9835,0.180907,0,0.872294,-19.7028,-3.24839,1\",\"referenceScanID\":\"1.23.1.1.1\",\"title\":\"Mandibule 1.23.1.1.1 Occlusion 3\"}'),(1001,'ad3ef871-3da5-4513-a26a-7990242d318d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_be8c90b6-055f-49b1-a5b6-cb782162d6cd/12_w1_o1_mandibule_scan_file_2.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_be8c90b6-055f-49b1-a5b6-cb782162d6cd_ZIP_','2022-02-04 12:39:32','2022-02-04 13:39:20','12_w1_o1_mandibule_scan_file_2.zip','2022-02-04 13:39:32','SYNCED','db484565-ee6f-4ebd-803a-ec8279d42cae',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.6\",\"modelMatrix\":\"0.955358,0.0799776,0.284419,0,0.29545,-0.258613,-0.919689,0,2.43157e-9,0.962664,-0.270698,0,-10.6442,-5.98327,-7.98243,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'adc3b531-b8c6-4f79-a5cf-5afae533973d','','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_OCC_d8bec5dc-8405-473d-9ba5-ae6e461ed6fd_BOPLY__ZIP_','2022-02-07 11:15:31','2022-02-04 19:13:44','','2022-02-07 12:15:31','SYNCED','adc3b531-b8c6-4f79-a5cf-5afae533973d',0,'2022-02-07 12:15:31','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.5 Occlusion 1\",\"modelMatrix\":\"-0.996857,-0.0768567,0.0192233,0,0.0792243,-0.967066,0.241882,0,1.71456e-9,0.242644,0.970115,0,23.7843,9.22152,-23.0024,1\",\"referenceScanID\":\"1.13.1.1.5\",\"title\":\"Mandibule 1.13.1.1.5 Occlusion 1\"}'),(1001,'adcfc3f6-2557-4375-a3b5-51d331cc65fb','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/computedocclusion_77753fb3-75a1-45c2-9191-7a5d98206df2/24_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_77753fb3-75a1-45c2-9191-7a5d98206df2_TOMA__MATRX_','2022-06-14 12:07:17','2022-06-14 14:06:33','24_w1_o1_maxillaire_matrix_occ_file_0.m','2022-06-14 14:07:17','SYNCED','adcfc3f6-2557-4375-a3b5-51d331cc65fb',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.24.1.1.4 Occlusion 5\",\"referenceScanID\":\"1.24.1.1.4\",\"title\":\"Matrice Transfo. Maxillaire 1.24.1.1.4 Occlusion 5\"}'),(1001,'ade9d190-3348-49ba-bd8d-53db215d4d2b','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/ca43bf7b-f931-42fc-bb75-05929e4b6578/session_d9740504-a9ca-472a-83f2-a309fa225a98/occlusion_d663165c-f330-4c61-8d1f-14869b6d5edd/scan_ffe14381-1016-473f-8c9f-eb36dcf0655c/59_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_ca43bf7b-f931-42fc-bb75-05929e4b6578_ACT_d9740504-a9ca-472a-83f2-a309fa225a98_SESS_d663165c-f330-4c61-8d1f-14869b6d5edd_BOSC_ffe14381-1016-473f-8c9f-eb36dcf0655c_ZIP_','2023-03-10 14:49:02','2023-03-10 15:48:43','59_w1_o1_mandibule_scan_file_0.zip','2023-03-10 15:49:02','SYNCED','ade9d190-3348-49ba-bd8d-53db215d4d2b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.59.1.1.1\",\"modelMatrix\":\"-0.520765,0.849794,-0.0815696,0,-0.8537,-0.518383,0.0497582,0,-5.75738e-09,0.0955483,0.995425,0,-0.870521,-8.35265,-26.3418,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'ae18282f-9453-4966-8fff-7648d7fefeeb','','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_e2722784-a66c-4ece-91c0-2add756415ea_SNAPO__SNAPS_','2022-05-13 16:32:19','2022-05-13 18:31:42','','2022-05-13 18:32:19','SYNCED','ae18282f-9453-4966-8fff-7648d7fefeeb',0,'2022-05-13 18:32:19','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'ae581db1-9e8e-4239-b0e7-e1568d8e0752','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/occlusion_e08bbeeb-a30b-428c-bd4a-40198f792219/scan_6aeb3c55-f3f0-4e74-9793-ec74659a28ad/25_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_SESS_e08bbeeb-a30b-428c-bd4a-40198f792219_BOSC_6aeb3c55-f3f0-4e74-9793-ec74659a28ad_SNAPS_','2022-05-17 16:28:18','2022-05-17 18:28:16','25_w1_o1_maxillaire_snapshot_0.png','2022-05-17 18:28:18','SYNCED','ae581db1-9e8e-4239-b0e7-e1568d8e0752',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.25.1.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'ae626f34-952a-4c2f-ac1a-1aad95d218b5','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/scan_c1f909ab-5469-4839-84f1-d04759dd1237/1_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_BOSC_c1f909ab-5469-4839-84f1-d04759dd1237_SNAPS_','2022-01-19 12:59:18','2022-01-19 11:51:29','1_w1_o1_mandibule_snapshot_0.png','2022-01-19 13:59:18','SYNCED','ae626f34-952a-4c2f-ac1a-1aad95d218b5',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule SNAPSHOT\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'ae6834f1-5c38-4d74-8b62-368c72c64c85','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/8b4b6de2-edd8-44e6-88c6-8a151914aca6/session_40a1b174-1058-4d27-b63a-4e8f565fb520/occlusion_8eba4eab-4337-436a-8eb6-b59e63415159/computedocclusion_95fe0a5e-fe67-469d-aab1-023211e73996/48_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_8b4b6de2-edd8-44e6-88c6-8a151914aca6_ACT_40a1b174-1058-4d27-b63a-4e8f565fb520_SESS_8eba4eab-4337-436a-8eb6-b59e63415159_OCC_95fe0a5e-fe67-469d-aab1-023211e73996_SNAPO__SNAPS_','2022-11-10 10:40:10','2022-11-10 11:39:57','48_w1_o1_snapshot_occ_file_0.png','2022-11-10 11:40:10','SYNCED','ae6834f1-5c38-4d74-8b62-368c72c64c85',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'ae8bfa69-d95e-46a3-bb3e-cc68442120e2','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/593972a6-d7d6-4802-b87d-38aab371f71e/session_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480/occlusion_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3/computedocclusion_e23c031c-2c78-414b-840d-85b58e959fbe/3_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_593972a6-d7d6-4802-b87d-38aab371f71e_ACT_049862c5-29b2-4fcd-a5b1-4c8f1f6cf480_SESS_55b947cc-3654-4f0a-b3b9-0a706eb6f5d3_OCC_e23c031c-2c78-414b-840d-85b58e959fbe_TOPLY__ZIP_','2022-01-19 15:28:10','2022-01-19 16:26:52','3_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-01-19 16:28:10','SYNCED','ae8bfa69-d95e-46a3-bb3e-cc68442120e2',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.3.1.1.1 Occlusion 4\",\"modelMatrix\":\"-0.8207,0.559215,-0.117173,0,-0.571359,-0.803257,0.168307,0,5.51916e-9,0.205077,0.978746,0,22.3383,-22.9288,-32.0145,1\",\"referenceScanID\":\"1.3.1.1.1\",\"title\":\"Maxillaire 1.3.1.1.1 Occlusion 4\"}'),(1001,'aec4123b-775e-4569-bf8d-760edec2a13f','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/39062d60-7a18-417a-9004-c58e9ce7d62a/session_9869e99c-7b47-4662-9766-0388d668fbf3/occlusion_36832844-9579-46df-aea1-b9baf6ad8787/computedocclusion_a2f94254-4555-4b27-973a-d1034950f081/61_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_39062d60-7a18-417a-9004-c58e9ce7d62a_ACT_9869e99c-7b47-4662-9766-0388d668fbf3_SESS_36832844-9579-46df-aea1-b9baf6ad8787_OCC_a2f94254-4555-4b27-973a-d1034950f081_BOPLY__ZIP_','2023-03-10 17:33:39','2023-03-10 18:33:29','61_w1_o1_mandibule_occlusion_occ_file_0.zip','2023-03-10 18:33:39','SYNCED','aec4123b-775e-4569-bf8d-760edec2a13f',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.61.1.1.1 Occlusion 1\",\"modelMatrix\":\"-0.689128,-0.713925,0.124157,0,0.72464,-0.678937,0.118072,0,-9.1022e-10,0.171335,0.985213,0,0.0991868,-2.63599,-21.8939,1\",\"referenceScanID\":\"1.61.1.1.1\",\"title\":\"Mandibule 1.61.1.1.1 Occlusion 1\"}'),(1001,'aeedd47c-9240-4459-ae55-e34079970397','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/9efbbbe9-fd0a-44b1-988c-23571aad69fa/session_595a54fa-ae7d-4880-86a1-168b20242ecf/occlusion_b84a2165-e2d4-47e5-b110-a34bcaa24341/scan_25399088-5fa2-4516-946b-2a2df03a8440/53_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_9efbbbe9-fd0a-44b1-988c-23571aad69fa_ACT_595a54fa-ae7d-4880-86a1-168b20242ecf_SESS_b84a2165-e2d4-47e5-b110-a34bcaa24341_BOSC_25399088-5fa2-4516-946b-2a2df03a8440_ZIP_','2022-12-02 14:10:40','2022-12-02 15:10:25','53_w1_o1_mandibule_scan_file_1.zip','2022-12-02 15:10:40','SYNCED','2fd6a7b3-c6c9-4964-81b6-3e98bd0e2805',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.53.1.1.1\",\"modelMatrix\":\"-0.98742,0.118552,-0.104631,0,-0.158121,-0.740324,0.653389,0,-3.87402e-09,0.661714,0.749757,0,24.7176,-2.96291,-19.4017,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'af36dfd2-569c-44fd-a25a-90ce0d6a707a','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_19ce66b5-7943-4a9e-82cd-f21481da98cc/54_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_19ce66b5-7943-4a9e-82cd-f21481da98cc_TOMA__MATRX_','2023-03-15 10:41:57','2023-03-15 11:40:15','54_w1_o1_maxillaire_matrix_occ_file_0.m','2023-03-15 11:41:57','SYNCED','af36dfd2-569c-44fd-a25a-90ce0d6a707a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.54.1.1.2 Occlusion 2\",\"referenceScanID\":\"1.54.1.1.2\",\"title\":\"Matrice Transfo. Maxillaire 1.54.1.1.2 Occlusion 2\"}'),(1001,'aff7447b-86b3-422c-9e1f-a47c18457200','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/986374de-c4d7-4d6f-bf0c-2dc7e3b859a9/session_c81670ed-4144-4347-b19e-8057d11b5f7c/occlusion_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be/scan_f6f4f4dc-826e-4efc-957c-61074915b6b6/28_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_986374de-c4d7-4d6f-bf0c-2dc7e3b859a9_ACT_c81670ed-4144-4347-b19e-8057d11b5f7c_SESS_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be_RISC_f6f4f4dc-826e-4efc-957c-61074915b6b6_SNAPS_','2022-05-31 10:52:55','2022-05-31 12:52:42','28_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-05-31 12:52:55','SYNCED','aff7447b-86b3-422c-9e1f-a47c18457200',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.28.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'b015947f-1181-4536-b39a-ad5c494a9c91','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/452a5200-3e06-4b74-8949-6abc7f2dda8a/session_3e95d626-668f-45f7-98ad-be2cf9d7b90b/occlusion_bce8310f-eee9-4f0a-a6b7-d592dec66be5/computedocclusion_7a922eb8-5139-40fe-8402-fc7ff4204a1a/26_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_452a5200-3e06-4b74-8949-6abc7f2dda8a_ACT_3e95d626-668f-45f7-98ad-be2cf9d7b90b_SESS_bce8310f-eee9-4f0a-a6b7-d592dec66be5_OCC_7a922eb8-5139-40fe-8402-fc7ff4204a1a_SNAPO__SNAPS_','2022-05-24 09:42:30','2022-05-24 11:42:09','26_w1_o1_snapshot_occ_file_0.png','2022-05-24 11:42:30','SYNCED','b015947f-1181-4536-b39a-ad5c494a9c91',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'b063bf1d-2827-4087-91da-6acd14dc3a54','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/9efbbbe9-fd0a-44b1-988c-23571aad69fa/session_595a54fa-ae7d-4880-86a1-168b20242ecf/occlusion_b84a2165-e2d4-47e5-b110-a34bcaa24341/computedocclusion_9cad1eff-fefd-4d0a-b1af-fecfbc5a507f/53_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_9efbbbe9-fd0a-44b1-988c-23571aad69fa_ACT_595a54fa-ae7d-4880-86a1-168b20242ecf_SESS_b84a2165-e2d4-47e5-b110-a34bcaa24341_OCC_9cad1eff-fefd-4d0a-b1af-fecfbc5a507f_TOMA__MATRX_','2022-12-02 14:17:34','2022-12-02 15:17:19','53_w1_o1_maxillaire_matrix_occ_file_0.m','2022-12-02 15:17:34','SYNCED','b063bf1d-2827-4087-91da-6acd14dc3a54',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.53.1.1.3 Occlusion 1\",\"referenceScanID\":\"1.53.1.1.3\",\"title\":\"Matrice Transfo. Maxillaire 1.53.1.1.3 Occlusion 1\"}'),(1001,'b07a13e9-d146-40aa-9c8c-d08b70786222','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/computedocclusion_d5bff097-1085-4c55-afe3-1ce57126d88f/19_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_OCC_d5bff097-1085-4c55-afe3-1ce57126d88f_BOMA__MATRX_','2022-03-08 11:16:25','2022-03-08 12:15:58','19_w1_o1_mandibule_matrix_occ_file_0.m','2022-03-08 12:16:25','SYNCED','b07a13e9-d146-40aa-9c8c-d08b70786222',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.19.1.1.4 Occlusion 2\",\"referenceScanID\":\"1.19.1.1.4\",\"title\":\"Matrice Transfo. Mandibule 1.19.1.1.4 Occlusion 2\"}'),(1001,'b0a26d3e-e20e-4fb7-bfea-a91cdaa7612c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/45ff7437-0691-4427-a7da-8250862e4b96/session_4ff9c682-c09d-42ff-8c29-aeb13e066ed2/occlusion_934673c1-a4b9-4508-ac1b-a03092a0693e/scan_da7dbb1d-043a-4c99-abde-d5ee77a3f819/9_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_45ff7437-0691-4427-a7da-8250862e4b96_ACT_4ff9c682-c09d-42ff-8c29-aeb13e066ed2_SESS_934673c1-a4b9-4508-ac1b-a03092a0693e_BOSC_da7dbb1d-043a-4c99-abde-d5ee77a3f819_SNAPS_','2022-01-24 17:45:23','2022-01-24 18:38:33','9_w1_o1_mandibule_snapshot_0.png','2022-01-24 18:45:23','SYNCED','b0a26d3e-e20e-4fb7-bfea-a91cdaa7612c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.9.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'b0d60de6-eac4-43cf-9570-f016304a31af','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_ce625ba7-4218-40af-b344-df718da13f83/54_w1_o1_maxillaire_occlusion_occ_file_1.zip','ZIP','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_ce625ba7-4218-40af-b344-df718da13f83_TOPLY__ZIP_','2023-03-15 10:17:05','2023-03-15 11:15:16','54_w1_o1_maxillaire_occlusion_occ_file_1.zip','2023-03-15 11:17:05','SYNCED','ad02dce8-3ff6-4167-add8-6925d6562d5e',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.54.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.78238,0.620977,-0.0476379,0,-0.622801,0.780088,-0.059844,0,1.97556e-09,0.0764897,0.99707,0,-23.5433,3.60536,-19.7037,1\",\"referenceScanID\":\"1.54.1.1.1\",\"title\":\"Maxillaire 1.54.1.1.1 Occlusion 1\"}'),(1001,'b1612f1f-e70c-4dd6-bc02-855001953261','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/8fc74d9e-a5a0-46bf-be3f-500548a130ad/session_5368829e-7dec-4775-a487-a1019f9604f4/occlusion_bb63a653-1b34-4d80-a4bf-7fda5c9b0360/scan_812e813b-02e0-44c6-bb91-8e662cd9a614/14_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_8fc74d9e-a5a0-46bf-be3f-500548a130ad_ACT_5368829e-7dec-4775-a487-a1019f9604f4_SESS_bb63a653-1b34-4d80-a4bf-7fda5c9b0360_LESC_812e813b-02e0-44c6-bb91-8e662cd9a614_ZIP_','2022-02-01 10:51:03','2022-02-01 11:50:55','14_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-02-01 11:51:03','SYNCED','b1612f1f-e70c-4dd6-bc02-855001953261',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.14.1.1.2\",\"modelMatrix\":\"-0.957323,-0.238085,0.152849,0,0.225415,-0.962796,-0.158324,0,0.18139,-0.128793,0.975546,0,8.77435,4.5508,-19.3933,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'b1664c01-41f8-480b-af72-ad73284a731d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/occlusion_e08bbeeb-a30b-428c-bd4a-40198f792219/scan_ef1d20c7-5f61-4c35-8f0f-d85507cab786/25_w1_o1_mandibule_scan_file_3.zip','ZIP','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_SESS_e08bbeeb-a30b-428c-bd4a-40198f792219_BOSC_ef1d20c7-5f61-4c35-8f0f-d85507cab786_ZIP_','2022-05-17 16:18:50','2022-05-17 18:18:41','25_w1_o1_mandibule_scan_file_3.zip','2022-05-17 18:18:50','SYNCED','69ad61a1-bbd5-4415-a55b-c7c378bdf30e',3,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.25.1.1.1\",\"modelMatrix\":\"0.997472,-0.0698388,0.0130886,0,0.0710547,0.980404,-0.183739,0,8.96814e-10,0.184205,0.982888,0,-0.267312,-6.63349,-20.8465,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'b17592fe-1e18-4770-87fb-a47d85c6d47c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/9efbbbe9-fd0a-44b1-988c-23571aad69fa/session_595a54fa-ae7d-4880-86a1-168b20242ecf/occlusion_b84a2165-e2d4-47e5-b110-a34bcaa24341/computedocclusion_9cad1eff-fefd-4d0a-b1af-fecfbc5a507f/53_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_9efbbbe9-fd0a-44b1-988c-23571aad69fa_ACT_595a54fa-ae7d-4880-86a1-168b20242ecf_SESS_b84a2165-e2d4-47e5-b110-a34bcaa24341_OCC_9cad1eff-fefd-4d0a-b1af-fecfbc5a507f_SNAPO__SNAPS_','2022-12-02 14:17:52','2022-12-02 15:17:19','53_w1_o1_snapshot_occ_file_0.png','2022-12-02 15:17:52','SYNCED','b17592fe-1e18-4770-87fb-a47d85c6d47c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'b1b20d81-2ce7-4745-8d89-ddf4a21226dd','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a0c21836-ba79-4f15-9e35-02ef8211a9e5/session_0aac522d-3c38-465a-a1e0-014166c140ac/occlusion_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042/scan_8e186cfd-8ea5-4242-96cb-5a138aa44971/7_w1_o1_mordu_anterieur_scan_file_0.zip','ZIP','PATIENT_a0c21836-ba79-4f15-9e35-02ef8211a9e5_ACT_0aac522d-3c38-465a-a1e0-014166c140ac_SESS_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042_FRSC_8e186cfd-8ea5-4242-96cb-5a138aa44971_ZIP_','2022-01-21 12:04:41','2022-01-21 13:03:11','7_w1_o1_mordu_anterieur_scan_file_0.zip','2022-01-21 13:04:41','SYNCED','b1b20d81-2ce7-4745-8d89-ddf4a21226dd',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.7.1.1.1\",\"modelMatrix\":\"0.98688,-0.164233,0.0363058,0,0.15534,0.985548,0.047494,0,-0.0446001,-0.0421189,0.998213,0,7.95826,-0.82504,-21.4697,1\",\"title\":\"Mordu anterieur ZIP\"}'),(1001,'b1c51b5d-3ce0-4f2b-bf4c-ff8dc11c8e7d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5/occlusion_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa/scan_6148a482-5ea5-4353-ace5-f0d520a32e6e/24_w2_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5_SESS_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa_TOSC_6148a482-5ea5-4353-ace5-f0d520a32e6e_SNAPS_','2022-10-06 14:27:21','2022-10-06 16:27:07','24_w2_o1_maxillaire_snapshot_0.png','2022-10-06 16:27:21','SYNCED','b1c51b5d-3ce0-4f2b-bf4c-ff8dc11c8e7d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.2.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'b26387fc-4b61-45cd-a25b-6b8ea99d2a1d','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/490e4b04-6edd-4f47-a2ed-232689892eca/session_62105a91-1675-4d36-88bd-34aa8fe2ce3c/occlusion_03784c27-fd8d-4745-9c26-d84c490869b3/scan_89b022e7-c9b7-4155-aeeb-c65e7e38d330/56_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_490e4b04-6edd-4f47-a2ed-232689892eca_ACT_62105a91-1675-4d36-88bd-34aa8fe2ce3c_SESS_03784c27-fd8d-4745-9c26-d84c490869b3_RISC_89b022e7-c9b7-4155-aeeb-c65e7e38d330_ZIP_','2023-02-17 09:37:20','2023-02-17 10:37:14','56_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2023-02-17 10:37:20','SYNCED','b26387fc-4b61-45cd-a25b-6b8ea99d2a1d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.56.1.1.1\",\"modelMatrix\":\"0.996013,0.0835323,0.031516,0,-0.0792086,0.988664,-0.129318,0,-0.0410591,0.124776,0.991104,0,-9.84743,-5.35184,-18.362,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'b289e4d6-3c9a-4c99-9b03-22a1c45f557a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/computedocclusion_864c98a3-fcf7-466a-b999-13bd4dfb8c65/23_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_OCC_864c98a3-fcf7-466a-b999-13bd4dfb8c65_TOPLY__ZIP_','2022-05-13 11:31:01','2022-05-13 13:30:43','23_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-05-13 13:31:01','SYNCED','b289e4d6-3c9a-4c99-9b03-22a1c45f557a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.23.1.1.1 Occlusion 3\",\"modelMatrix\":\"-0.996412,0.0371381,-0.0760535,0,-0.0846367,-0.43722,0.895363,0,9.59179e-10,0.898588,0.438794,0,-5.67604,-22.9357,-12.9416,1\",\"referenceScanID\":\"1.23.1.1.1\",\"title\":\"Maxillaire 1.23.1.1.1 Occlusion 3\"}'),(1001,'b2acc793-4bfb-4782-8e11-283897626385','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7f47fd88-9ea0-4c08-9193-a54d4f158c7c/session_7873a396-419c-4215-83c7-fec9f2742ccf/occlusion_2e287bb0-e19a-414a-9177-23b335d286d9/scan_05d5d943-3268-4239-ac7d-5efbc2d2ab9b/16_w1_o2_maxillaire_snapshot_1.png','SNAPS','PATIENT_7f47fd88-9ea0-4c08-9193-a54d4f158c7c_ACT_7873a396-419c-4215-83c7-fec9f2742ccf_SESS_2e287bb0-e19a-414a-9177-23b335d286d9_TOSC_05d5d943-3268-4239-ac7d-5efbc2d2ab9b_SNAPS_','2022-06-03 08:58:59','2022-06-03 10:52:04','16_w1_o2_maxillaire_snapshot_1.png','2022-06-03 10:58:59','SYNCED','4c85fe3b-92ce-4c9f-bba8-70bca998d5fc',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.16.1.2.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'b2edc514-dfe1-4669-9903-5360d4916e4f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/e922efb9-8c03-445b-8a0f-449e3c43bdca/session_a2369349-1629-40ad-8784-d271bc3fbade/occlusion_292cc1aa-8b12-463b-87a1-7d9731cf886b/scan_877e5641-7010-4a8d-99a9-8005d48d7ec6/21_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_e922efb9-8c03-445b-8a0f-449e3c43bdca_ACT_a2369349-1629-40ad-8784-d271bc3fbade_SESS_292cc1aa-8b12-463b-87a1-7d9731cf886b_LESC_877e5641-7010-4a8d-99a9-8005d48d7ec6_ZIP_','2022-04-21 08:47:27','2022-04-21 10:47:20','21_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-04-21 10:47:27','SYNCED','b2edc514-dfe1-4669-9903-5360d4916e4f',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.21.1.1.1\",\"modelMatrix\":\"-0.948339,0.00379469,0.317975,0,-0.0111445,-0.999965,-0.00926301,0,0.317098,-0.00901499,0.948056,0,-5.63961,2.22475,-16.982,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'b3011f97-dcc2-4aef-a6d3-3a07077686c6','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/7c3827a5-fcb4-4892-bab3-8d6a4e6382f0/session_cb98e8a0-e16d-4640-919e-9b968e57d3db/occlusion_29633526-06c5-413c-8029-9f27d6a28b53/scan_ab6c69b1-8cac-45ec-8fee-f2371813f161/63_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_7c3827a5-fcb4-4892-bab3-8d6a4e6382f0_ACT_cb98e8a0-e16d-4640-919e-9b968e57d3db_SESS_29633526-06c5-413c-8029-9f27d6a28b53_TOSC_ab6c69b1-8cac-45ec-8fee-f2371813f161_ZIP_','2023-03-20 14:34:20','2023-03-20 15:33:22','63_w1_o1_maxillaire_scan_file_1.zip','2023-03-20 15:34:20','SYNCED','7ab66a9c-a8b0-4143-a71a-8804137212c7',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.63.1.1.1\",\"modelMatrix\":\"0.782654,0.574945,-0.238519,0,-0.622458,0.722913,-0.299905,0,-2.5026e-08,0.38319,0.92367,0,-2.27916,-32.3022,-15.4528,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'b371f5a8-1821-4778-bc62-c98e0ef00388','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/scan_725ef2a4-4b53-4ec9-a807-17759213c882/22_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_BOSC_725ef2a4-4b53-4ec9-a807-17759213c882_SNAPS_','2022-04-21 11:05:32','2022-04-21 13:05:23','22_w1_o1_mandibule_snapshot_0.png','2022-04-21 13:05:32','SYNCED','b371f5a8-1821-4778-bc62-c98e0ef00388',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.22.1.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'b3b10ee1-2648-4394-a6e4-81a5e5e3e4df','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/8fc74d9e-a5a0-46bf-be3f-500548a130ad/session_5368829e-7dec-4775-a487-a1019f9604f4/occlusion_bb63a653-1b34-4d80-a4bf-7fda5c9b0360/scan_3e9aff47-e0ac-4b19-973d-d25c0bab00c9/14_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_8fc74d9e-a5a0-46bf-be3f-500548a130ad_ACT_5368829e-7dec-4775-a487-a1019f9604f4_SESS_bb63a653-1b34-4d80-a4bf-7fda5c9b0360_LESC_3e9aff47-e0ac-4b19-973d-d25c0bab00c9_ZIP_','2022-02-01 10:49:08','2022-02-01 11:48:59','14_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-02-01 11:49:08','SYNCED','b3b10ee1-2648-4394-a6e4-81a5e5e3e4df',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.14.1.1.1\",\"modelMatrix\":\"-0.98904,-0.0675101,0.130562,0,0.0772743,-0.993194,0.094479,0,0.12585,0.0953193,0.986968,0,12.8128,-2.54273,-17.2464,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'b3c1c9e6-2468-4942-a4b5-2c0391c8432d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/occlusion_a2220645-c79d-4dda-b6cc-772384a4106b/scan_38a668ff-3bd3-4238-90d7-65cc6f5a9ca7/38_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_BOSC_38a668ff-3bd3-4238-90d7-65cc6f5a9ca7_ZIP_','2022-07-12 10:53:47','2022-07-12 12:53:38','38_w1_o1_mandibule_scan_file_0.zip','2022-07-12 12:53:47','SYNCED','b3c1c9e6-2468-4942-a4b5-2c0391c8432d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.38.1.1.1\",\"modelMatrix\":\"-0.751938,0.649871,-0.110711,0,-0.659234,-0.741259,0.12628,0,-8.33225e-09,0.167939,0.985797,0,9.41783,-30.192,-17.274,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'b3d1eb03-0878-4061-a3de-1743fcf3cb27','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5/occlusion_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa/scan_ed5a4177-ead5-4d92-9183-f1964ddc29f9/24_w2_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5_SESS_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa_BOSC_ed5a4177-ead5-4d92-9183-f1964ddc29f9_ZIP_','2022-10-07 09:00:17','2022-10-07 11:00:01','24_w2_o1_mandibule_scan_file_0.zip','2022-10-07 11:00:17','SYNCED','b3d1eb03-0878-4061-a3de-1743fcf3cb27',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.24.2.1.5\",\"modelMatrix\":\"-0.3138,0.935395,-0.162988,0,-0.949489,-0.309143,0.0538666,0,-2.99524e-09,0.171659,0.985157,0,25.6088,-18.5365,-15.4613,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'b491ccb9-a206-434b-99cb-610beb966dfa','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/occlusion_a2220645-c79d-4dda-b6cc-772384a4106b/computedocclusion_8b14563e-0862-4cac-8045-e8aed2be886d/38_w1_o1_ml_occ_file_to1000.xyz','LIFI','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_OCC_8b14563e-0862-4cac-8045-e8aed2be886d_LIFIO_LIFI_','2022-07-19 12:28:52','2022-07-19 14:28:51','38_w1_o1_ml_occ_file_to1000.xyz','2022-07-19 14:28:52','SYNCED','b491ccb9-a206-434b-99cb-610beb966dfa',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.38.1.1.1 Occlusion 1 Ligne de finition 0\",\"isOcclusionMarginLine\":true,\"lifi_scan_type\":\"Maxillaire\",\"name\":\"Ligne de finition 0\",\"title\":\"Ligne finition\",\"toothNumber\":1000}'),(1001,'b4a6f377-44d7-41f7-9706-0f52f21f7088','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5/occlusion_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa/computedocclusion_4053e29d-7bcb-4280-9a77-c17e5d1256b3/24_w2_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5_SESS_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa_OCC_4053e29d-7bcb-4280-9a77-c17e5d1256b3_TOMA__MATRX_','2022-10-07 17:17:44','2022-10-07 19:17:23','24_w2_o1_maxillaire_matrix_occ_file_0.m','2022-10-07 19:17:44','SYNCED','b4a6f377-44d7-41f7-9706-0f52f21f7088',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.24.2.1.1 Occlusion 2\",\"referenceScanID\":\"1.24.2.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.24.2.1.1 Occlusion 2\"}'),(1001,'b4c4bc2f-dfa5-4960-af29-45ce6a03ffc7','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3ed7a8e0-5b4d-4ecf-b4ae-f855b16c0f93/session_fb42cec6-0bb6-41e9-912d-0517ff8e0942/order_a1d7d1a0-0aea-46c7-aa86-21636881944e/42_w1_inlay_onlay_prost_file_b4c4bc2f-dfa5-4960-af29-45ce6a03ffc7_0.pdf','PDF','PATIENT_3ed7a8e0-5b4d-4ecf-b4ae-f855b16c0f93_ACT_fb42cec6-0bb6-41e9-912d-0517ff8e0942_PROST_a1d7d1a0-0aea-46c7-aa86-21636881944e_PDF_','2022-10-07 17:39:45','2022-10-07 19:39:42','42_w1_inlay_onlay_prost_file_b4c4bc2f-dfa5-4960-af29-45ce6a03ffc7_0.pdf','2022-10-07 19:39:45','SYNCED','b4c4bc2f-dfa5-4960-af29-45ce6a03ffc7',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.42.1.1 INLAY ONLAY\",\"title\":\"Inlay/Onlay PDF\"}'),(1001,'b4cc54aa-aa6f-4638-ab86-cb7cd20e7285','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5/occlusion_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa/scan_569997ca-080a-44fb-9a38-e48cedabde17/24_w2_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5_SESS_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa_RISC_569997ca-080a-44fb-9a38-e48cedabde17_SNAPS_','2022-10-06 14:32:32','2022-10-06 16:32:23','24_w2_o1_mordu_posterieur_droit_snapshot_0.png','2022-10-06 16:32:32','SYNCED','b4cc54aa-aa6f-4638-ab86-cb7cd20e7285',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.24.2.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'b4e5f5b8-812b-4550-93b3-a8808b89d8cd','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/computedocclusion_704a0750-2a24-448f-8f30-928139977895/4_w1_o2_snapshot_occ_file_0.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_OCC_704a0750-2a24-448f-8f30-928139977895_SNAPO__SNAPS_','2022-03-08 11:49:51','2022-03-08 12:49:34','4_w1_o2_snapshot_occ_file_0.png','2022-03-08 12:49:51','SYNCED','b4e5f5b8-812b-4550-93b3-a8808b89d8cd',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'b51aa40c-9bbb-44c4-a878-efb405af40a5','','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_ea89007b-3846-43ef-92f9-d5c7aa1a7dfa_BOPLY__ZIP_','2022-05-25 08:56:32','2022-05-13 18:35:18','','2022-05-25 10:56:32','SYNCED','b51aa40c-9bbb-44c4-a878-efb405af40a5',0,'2022-05-25 10:56:32','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.24.1.1.1 Occlusion 5\",\"modelMatrix\":\"0.852703,-0.521011,0.0380208,0,0.522396,0.850441,-0.062061,0,3.49638e-10,0.0727815,0.997348,0,-11.3911,-12.8136,-21.1334,1\",\"referenceScanID\":\"1.24.1.1.1\",\"title\":\"Mandibule 1.24.1.1.1 Occlusion 5\"}'),(1001,'b56142e2-9251-472d-8a53-e28db53e1b40','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/3a170256-4132-4b56-ad27-b2cc7790bbf8/session_c57164ce-3f15-42b7-a8dc-96ab6a136184/occlusion_4779508f-bef4-4a89-9555-58b917369f06/scan_83a01b11-6b2a-4d82-8a2a-6c0f5c234c86/62_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_3a170256-4132-4b56-ad27-b2cc7790bbf8_ACT_c57164ce-3f15-42b7-a8dc-96ab6a136184_SESS_4779508f-bef4-4a89-9555-58b917369f06_LESC_83a01b11-6b2a-4d82-8a2a-6c0f5c234c86_SNAPS_','2023-03-13 09:48:18','2023-03-13 10:48:05','62_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2023-03-13 10:48:18','SYNCED','b56142e2-9251-472d-8a53-e28db53e1b40',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.62.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'b5b15730-75d0-4419-8b97-a0362238661d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/57c4096f-98dd-49c8-bea5-a5b109ad3fd0/session_4f62e395-5623-4d5b-869c-1b2fc4d22b00/occlusion_1ac20dc7-b36b-4786-a05f-37091554dc5c/computedocclusion_70f4220e-2a6b-4575-bd0e-09c14a13d758/31_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_57c4096f-98dd-49c8-bea5-a5b109ad3fd0_ACT_4f62e395-5623-4d5b-869c-1b2fc4d22b00_SESS_1ac20dc7-b36b-4786-a05f-37091554dc5c_OCC_70f4220e-2a6b-4575-bd0e-09c14a13d758_BOPLY__ZIP_','2022-06-16 11:04:03','2022-06-16 13:03:55','31_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-06-16 13:04:03','SYNCED','b5b15730-75d0-4419-8b97-a0362238661d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.31.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.252718,0.957401,-0.139701,0,-0.96754,0.25007,-0.0364895,0,-5.51629e-10,0.144388,0.989521,0,-10.0594,-15.8463,-16.5488,1\",\"referenceScanID\":\"1.31.1.1.1\",\"title\":\"Mandibule 1.31.1.1.1 Occlusion 1\"}'),(1001,'b5f2d1e9-c850-486b-9609-5e65632eea3c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/d100e894-0be9-4495-94e2-e469232f7817/session_2c8b85b5-c805-4b08-85e7-3d02dab72e99/occlusion_8a278cc5-a1c1-4dfb-9ee2-c971a6309afa/scan_b1a27ca1-b17d-4071-99c1-940f9efedb70/15_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_d100e894-0be9-4495-94e2-e469232f7817_ACT_2c8b85b5-c805-4b08-85e7-3d02dab72e99_SESS_8a278cc5-a1c1-4dfb-9ee2-c971a6309afa_RISC_b1a27ca1-b17d-4071-99c1-940f9efedb70_ZIP_','2022-02-01 15:11:23','2022-02-01 16:11:12','15_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-02-01 16:11:23','SYNCED','b5f2d1e9-c850-486b-9609-5e65632eea3c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.15.1.1.1\",\"modelMatrix\":\"0.985583,-0.0324105,0.163583,0,0.0137503,0.991881,0.127662,0,-0.168661,-0.122999,0.978237,0,-7.43884,5.93846,-19.4808,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'b60666c5-07cb-4f6c-ba71-538dcfe3d89d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/45ff7437-0691-4427-a7da-8250862e4b96/session_4ff9c682-c09d-42ff-8c29-aeb13e066ed2/occlusion_934673c1-a4b9-4508-ac1b-a03092a0693e/computedocclusion_161f60a4-d4f2-41f1-98ad-a8ccad84216c/9_w1_o1_maxillaire_occlusion_occ_file_0.zip','ZIP','PATIENT_45ff7437-0691-4427-a7da-8250862e4b96_ACT_4ff9c682-c09d-42ff-8c29-aeb13e066ed2_SESS_934673c1-a4b9-4508-ac1b-a03092a0693e_OCC_161f60a4-d4f2-41f1-98ad-a8ccad84216c_TOPLY__ZIP_','2022-01-24 19:55:57','2022-01-24 18:46:00','9_w1_o1_maxillaire_occlusion_occ_file_0.zip','2022-01-24 20:55:57','SYNCED','b60666c5-07cb-4f6c-ba71-538dcfe3d89d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.9.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.9.1.1.1\",\"title\":\"Maxillaire 1.9.1.1.1 Occlusion 1\"}'),(1001,'b60d5f74-99b5-43dd-8f13-25a0c83717d3','','ZIP','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_LESC_273e24bd-58e9-4983-8fdc-d9f60e8e0de7_ZIP_','2022-09-09 16:40:52','2022-09-09 18:33:57','','2022-09-09 18:40:52','SYNCED','b60d5f74-99b5-43dd-8f13-25a0c83717d3',0,'2022-09-09 18:40:52','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.39.1.1.6\",\"modelMatrix\":\"-0.988587,0.144207,0.0409559,0,-0.137967,-0.977474,0.158097,0,0.0605711,0.154154,0.986583,0,-2.607,0.716326,-19.8323,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'b6303ea4-a27b-45d8-8859-2f8f8edda5cb','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7a831424-620b-4719-a82e-263d8602fd6e/session_cfefc247-4a56-4d5a-8350-5ab72a8af67a/occlusion_c653584a-be75-45c7-92ec-e0eca5a2b6ca/scan_2d226451-8adb-4007-be22-99a9b3af61d6/23_w1_o1_maxillaire_mlmeta_1_0.bin','LIFIM','PATIENT_7a831424-620b-4719-a82e-263d8602fd6e_ACT_cfefc247-4a56-4d5a-8350-5ab72a8af67a_SESS_c653584a-be75-45c7-92ec-e0eca5a2b6ca_TOSC_2d226451-8adb-4007-be22-99a9b3af61d6_LIFIM_','2022-05-25 10:45:09','2022-05-25 12:45:09','23_w1_o1_maxillaire_mlmeta_1_0.bin','2022-05-25 12:45:09','SYNCED','b6303ea4-a27b-45d8-8859-2f8f8edda5cb',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Ligne de finition Maxillaire 1.23.1.1.1 Ligne de finition 1\",\"name\":\"Ligne de finition 1\",\"title\":\"Maxillaire LIFI_META\",\"toothNumber\":1,\"versionMarginLine\":1}'),(1001,'b64e0fdb-e616-4122-b3bb-e9044f480643','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/3a170256-4132-4b56-ad27-b2cc7790bbf8/session_c57164ce-3f15-42b7-a8dc-96ab6a136184/occlusion_4779508f-bef4-4a89-9555-58b917369f06/scan_3b35af3c-c4f8-4cc0-8b4a-a7d896e6db3b/62_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_3a170256-4132-4b56-ad27-b2cc7790bbf8_ACT_c57164ce-3f15-42b7-a8dc-96ab6a136184_SESS_4779508f-bef4-4a89-9555-58b917369f06_BOSC_3b35af3c-c4f8-4cc0-8b4a-a7d896e6db3b_ZIP_','2023-03-13 09:45:20','2023-03-13 10:44:53','62_w1_o1_mandibule_scan_file_0.zip','2023-03-13 10:45:20','SYNCED','b64e0fdb-e616-4122-b3bb-e9044f480643',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.62.1.1.1\",\"modelMatrix\":\"-0.690124,0.692869,-0.208953,0,-0.723691,-0.660732,0.199261,0,1.37434e-09,0.288733,0.95741,0,28.3608,-8.0358,-14.5703,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'b685e310-d84a-4a81-a008-eee4725a0bd6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/32939ecf-ba11-4fff-a074-5e86a9f7f313/session_4075a8d6-094f-4202-abe0-4c02b7a5a8e6/occlusion_51192c80-5065-420e-ae8f-bac335ac1de1/scan_2ca8702c-bb71-418c-b881-0d3d2af204d1/6_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_32939ecf-ba11-4fff-a074-5e86a9f7f313_ACT_4075a8d6-094f-4202-abe0-4c02b7a5a8e6_SESS_51192c80-5065-420e-ae8f-bac335ac1de1_TOSC_2ca8702c-bb71-418c-b881-0d3d2af204d1_SNAPS_','2022-01-20 10:13:02','2022-01-20 11:12:37','6_w1_o1_maxillaire_snapshot_0.png','2022-01-20 11:13:02','SYNCED','b685e310-d84a-4a81-a008-eee4725a0bd6',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.6.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'b6d0c906-79cf-49c8-a1fa-4ed6e5c7355c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/452a5200-3e06-4b74-8949-6abc7f2dda8a/session_3e95d626-668f-45f7-98ad-be2cf9d7b90b/occlusion_bce8310f-eee9-4f0a-a6b7-d592dec66be5/scan_315ac573-ca2e-4c47-8969-e667ad225aa2/26_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_452a5200-3e06-4b74-8949-6abc7f2dda8a_ACT_3e95d626-668f-45f7-98ad-be2cf9d7b90b_SESS_bce8310f-eee9-4f0a-a6b7-d592dec66be5_LESC_315ac573-ca2e-4c47-8969-e667ad225aa2_SNAPS_','2022-05-24 09:41:39','2022-05-24 11:41:30','26_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-05-24 11:41:39','SYNCED','b6d0c906-79cf-49c8-a1fa-4ed6e5c7355c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.26.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'b6f46e96-4d05-4b63-8956-16b3af586d47','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/458c92d8-9da1-4df9-967f-d14fc7e6303d/session_55831d43-1906-4a22-9b7a-ed4b2820c8b2/occlusion_4f582d4c-81d0-4e01-8be3-9ff53b12c7f4/scan_19e6ea5c-af28-439b-bc57-b561cd42e12b/10_w2_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_55831d43-1906-4a22-9b7a-ed4b2820c8b2_SESS_4f582d4c-81d0-4e01-8be3-9ff53b12c7f4_TOSC_19e6ea5c-af28-439b-bc57-b561cd42e12b_SNAPS_','2022-06-16 13:17:46','2022-06-16 15:17:36','10_w2_o1_maxillaire_snapshot_0.png','2022-06-16 15:17:46','SYNCED','b6f46e96-4d05-4b63-8956-16b3af586d47',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.10.2.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'b7961fca-a9d4-4c9d-931d-5fe3f9d81fdc','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/order_e3c9da81-d0b0-45c1-aa29-4e7a3db51e51/54_w1_autre_prost_file_b7961fca-a9d4-4c9d-931d-5fe3f9d81fdc_0.pdf','PDF','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_PROST_e3c9da81-d0b0-45c1-aa29-4e7a3db51e51_PDF_','2022-12-22 09:10:00','2022-12-22 10:09:59','54_w1_autre_prost_file_b7961fca-a9d4-4c9d-931d-5fe3f9d81fdc_0.pdf','2022-12-22 10:10:00','SYNCED','b7961fca-a9d4-4c9d-931d-5fe3f9d81fdc',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.54.1.1 AUTRE FICHE DE PROTHESE\",\"title\":\"Autre PDF\"}'),(1001,'b79c08d2-6a61-4a8a-a196-1be264af0e42','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/scan_03839278-13f8-46e6-9581-ba11bc8bcb81/1_w1_o1_maxillaire_scan_file_2.zip','ZIP','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_TOSC_03839278-13f8-46e6-9581-ba11bc8bcb81_ZIP_','2022-01-19 13:01:35','2022-01-19 11:09:50','1_w1_o1_maxillaire_scan_file_2.zip','2022-01-19 14:01:35','SYNCED','96dd75bb-5035-460a-8afc-04f3755604b1',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.1.1.1.1\",\"modelMatrix\":\"-0.183277,0.932835,-0.310209,0,-0.983061,-0.173913,0.0578337,0,-6.22287e-9,0.315554,0.948908,0,-14.0294,-37.4355,-13.2447,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'b7bee708-79bb-43ec-832d-02b35be06369','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/32710234-804f-46f5-899d-eed636f8a906/session_64c1427a-b91d-4675-94df-f36bd40e9b0f/order_52f078fa-727c-4bbd-a020-8c414d4fe6a5/33_w2_inlay_onlay_prost_file_b7bee708-79bb-43ec-832d-02b35be06369_0.pdf','PDF','PATIENT_32710234-804f-46f5-899d-eed636f8a906_ACT_64c1427a-b91d-4675-94df-f36bd40e9b0f_PROST_52f078fa-727c-4bbd-a020-8c414d4fe6a5_PDF_','2022-06-28 17:34:51','2022-06-28 19:34:49','33_w2_inlay_onlay_prost_file_b7bee708-79bb-43ec-832d-02b35be06369_0.pdf','2022-06-28 19:34:51','SYNCED','b7bee708-79bb-43ec-832d-02b35be06369',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.33.2.1 INLAY ONLAY 14 Claire\",\"title\":\"Inlay/Onlay PDF\"}'),(1001,'b7cf2866-aec2-4f49-8f97-82fca065a1f3','','SNAPS','PATIENT_de078619-3946-4adb-a799-1c260e16face_ACT_24d0aeb5-3058-4070-aeea-97c289e41e3c_SESS_ea6da896-1504-41fc-890c-7c48575e9e40_BOSC_00feff25-f8bf-405a-9778-d3fd08af5e37_SNAPS_','2022-01-19 17:01:43','2022-01-19 15:19:15','','2022-01-19 18:01:43','SYNCED','b7cf2866-aec2-4f49-8f97-82fca065a1f3',0,'2022-01-19 18:01:43','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.2.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'b812ac8b-f89d-4997-a934-b84fc86cdf84','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/6a4b302c-278d-4e12-ace5-f095ba0bf856/session_6206892a-2e7e-4765-ac90-b49bfb465997/occlusion_3c30231c-7cd7-4431-985b-2eaf7f6925ae/scan_f9a200bf-710b-4bad-a122-de56d5bc4da4/3_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_6a4b302c-278d-4e12-ace5-f095ba0bf856_ACT_6206892a-2e7e-4765-ac90-b49bfb465997_SESS_3c30231c-7cd7-4431-985b-2eaf7f6925ae_TOSC_f9a200bf-710b-4bad-a122-de56d5bc4da4_ZIP_','2022-09-06 09:20:32','2022-08-30 10:36:06','3_w1_o1_maxillaire_scan_file_0.zip','2022-09-06 11:20:32','SYNCED','b812ac8b-f89d-4997-a934-b84fc86cdf84',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.3.1.1.1\",\"modelMatrix\":\"0.68153,0.72027,-0.129336,0,-0.73179,0.670801,-0.120453,0,1.08731e-08,0.176739,0.984258,0,-27.3042,-9.55749,-15.1525,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'b84f27be-e2df-4069-8159-d734bcbcec08','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/513ccf80-8cc1-47fa-b351-4e0414a0fda5/session_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5/occlusion_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a/scan_7f58ef07-2de6-4bb2-982d-86ac2b5ae742/17_w1_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_RISC_7f58ef07-2de6-4bb2-982d-86ac2b5ae742_SNAPS_','2022-02-11 16:12:11','2022-02-11 17:12:03','17_w1_o1_mordu_posterieur_droit_snapshot_0.png','2022-02-11 17:12:11','SYNCED','b84f27be-e2df-4069-8159-d734bcbcec08',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.17.1.1.2\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'b85116ff-ba7b-4dc5-a868-287b0ab403b1','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_2a7068fc-0efa-496f-ade9-aba5b0650655/12_w1_o1_mandibule_scan_file_6.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_2a7068fc-0efa-496f-ade9-aba5b0650655_ZIP_','2022-02-04 12:06:15','2022-02-04 13:05:53','12_w1_o1_mandibule_scan_file_6.zip','2022-02-04 13:06:15','SYNCED','44ebcd6f-57c2-4cce-96f5-f9faa1c6b373',6,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.5\",\"modelMatrix\":\"0.712702,-0.661388,0.233712,0,0.701467,0.671982,-0.237455,0,2.34471e-9,0.333176,0.942865,0,3.59767,30.1121,-30.1698,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'b85be850-5590-4c9b-b13b-3d6d94c2e3ab','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/computedocclusion_42098ceb-3335-4f13-8aed-b29c37a5f57f/22_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_OCC_42098ceb-3335-4f13-8aed-b29c37a5f57f_BOMA__MATRX_','2022-04-21 11:29:05','2022-04-21 13:28:43','22_w1_o1_mandibule_matrix_occ_file_0.m','2022-04-21 13:29:05','SYNCED','b85be850-5590-4c9b-b13b-3d6d94c2e3ab',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.22.1.1.2 Occlusion 6\",\"referenceScanID\":\"1.22.1.1.2\",\"title\":\"Matrice Transfo. Mandibule 1.22.1.1.2 Occlusion 6\"}'),(1001,'b8629303-55d9-4e62-9233-49367e1d7bb6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/986374de-c4d7-4d6f-bf0c-2dc7e3b859a9/session_c81670ed-4144-4347-b19e-8057d11b5f7c/order_8125a57d-e19e-4264-ba12-984e020c452e/28_w1_inlay_onlay_prost_file_b8629303-55d9-4e62-9233-49367e1d7bb6_0.pdf','PDF','PATIENT_986374de-c4d7-4d6f-bf0c-2dc7e3b859a9_ACT_c81670ed-4144-4347-b19e-8057d11b5f7c_PROST_8125a57d-e19e-4264-ba12-984e020c452e_PDF_','2022-06-07 11:41:29','2022-06-07 13:41:28','28_w1_inlay_onlay_prost_file_b8629303-55d9-4e62-9233-49367e1d7bb6_0.pdf','2022-06-07 13:41:29','SYNCED','b8629303-55d9-4e62-9233-49367e1d7bb6',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.28.1.1 INLAY ONLAY\",\"title\":\"Inlay/Onlay PDF\"}'),(1001,'b874f86b-93dd-4bf0-963c-c9cf446e4836','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_b1201d2a-0fbf-48bc-a1c2-f3649c1ca576/18_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_BOSC_b1201d2a-0fbf-48bc-a1c2-f3649c1ca576_SNAPS_','2022-05-10 14:00:12','2022-05-10 16:00:00','18_w1_o1_mandibule_snapshot_0.png','2022-05-10 16:00:12','SYNCED','b874f86b-93dd-4bf0-963c-c9cf446e4836',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.18.1.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'b8b1811e-1d8b-4e17-8c28-b529cbc427b9','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/55f86771-cc61-43c6-a8d5-5e4006a24fc9/session_1f3e06be-a2ec-4423-831c-7b01979d5187/occlusion_a2220645-c79d-4dda-b6cc-772384a4106b/computedocclusion_8b14563e-0862-4cac-8045-e8aed2be886d/38_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_55f86771-cc61-43c6-a8d5-5e4006a24fc9_ACT_1f3e06be-a2ec-4423-831c-7b01979d5187_SESS_a2220645-c79d-4dda-b6cc-772384a4106b_OCC_8b14563e-0862-4cac-8045-e8aed2be886d_TOMA__MATRX_','2022-07-12 10:57:43','2022-07-12 12:57:24','38_w1_o1_maxillaire_matrix_occ_file_0.m','2022-07-12 12:57:43','SYNCED','b8b1811e-1d8b-4e17-8c28-b529cbc427b9',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.38.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.38.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.38.1.1.1 Occlusion 1\"}'),(1001,'b8b7a966-6291-445c-85e0-39e995878daa','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_be8c90b6-055f-49b1-a5b6-cb782162d6cd/12_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_be8c90b6-055f-49b1-a5b6-cb782162d6cd_SNAPS_','2022-02-04 12:36:39','2022-02-04 13:36:24','12_w1_o1_mandibule_snapshot_1.png','2022-02-04 13:36:39','SYNCED','09a60bd0-5644-4c1f-85c2-b6dfce87f5a8',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.6\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'b92bcf1f-2d56-46b6-b871-378a0142816d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7f47fd88-9ea0-4c08-9193-a54d4f158c7c/session_7873a396-419c-4215-83c7-fec9f2742ccf/occlusion_2f21aacc-dc8f-459b-b89b-bd548ffc070d/scan_410077c0-79fe-4e07-b332-33923a495579/16_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_7f47fd88-9ea0-4c08-9193-a54d4f158c7c_ACT_7873a396-419c-4215-83c7-fec9f2742ccf_SESS_2f21aacc-dc8f-459b-b89b-bd548ffc070d_BOSC_410077c0-79fe-4e07-b332-33923a495579_SNAPS_','2022-02-03 10:10:12','2022-02-03 11:09:56','16_w1_o1_mandibule_snapshot_0.png','2022-02-03 11:10:12','SYNCED','b92bcf1f-2d56-46b6-b871-378a0142816d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.16.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'b96d1194-073e-457b-8576-4bc1f1670ab3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_1c86378e-7d31-4b12-82ff-af797020160f/4_w1_o2_mandibule_scan_file_2.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_BOSC_1c86378e-7d31-4b12-82ff-af797020160f_ZIP_','2022-03-08 11:40:04','2022-03-08 12:39:57','4_w1_o2_mandibule_scan_file_2.zip','2022-03-08 12:40:04','SYNCED','bb22e8ec-52ef-47ae-acce-e63ab615a505',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.2.3\",\"modelMatrix\":\"0.911616,-0.405119,0.069536,0,0.411044,0.898477,-0.154217,0,-1.58245e-09,0.169169,0.985587,0,-2.41197,4.44675,-21.7512,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'b973e12b-eb72-4f9d-acda-04165903bf1d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/452a5200-3e06-4b74-8949-6abc7f2dda8a/session_3e95d626-668f-45f7-98ad-be2cf9d7b90b/occlusion_bce8310f-eee9-4f0a-a6b7-d592dec66be5/scan_49ae59fe-0bc4-4d86-b65e-d8788e2d12fb/26_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_452a5200-3e06-4b74-8949-6abc7f2dda8a_ACT_3e95d626-668f-45f7-98ad-be2cf9d7b90b_SESS_bce8310f-eee9-4f0a-a6b7-d592dec66be5_TOSC_49ae59fe-0bc4-4d86-b65e-d8788e2d12fb_SNAPS_','2022-05-24 09:36:31','2022-05-24 11:36:18','26_w1_o1_maxillaire_snapshot_1.png','2022-05-24 11:36:31','SYNCED','cb795e35-e3c3-4871-a194-cf67dc3a59ab',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.26.1.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'b9abf4b4-7e6d-4a36-9942-e4d261fc2b13','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/3a170256-4132-4b56-ad27-b2cc7790bbf8/session_c57164ce-3f15-42b7-a8dc-96ab6a136184/occlusion_4779508f-bef4-4a89-9555-58b917369f06/scan_3b35af3c-c4f8-4cc0-8b4a-a7d896e6db3b/62_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_3a170256-4132-4b56-ad27-b2cc7790bbf8_ACT_c57164ce-3f15-42b7-a8dc-96ab6a136184_SESS_4779508f-bef4-4a89-9555-58b917369f06_BOSC_3b35af3c-c4f8-4cc0-8b4a-a7d896e6db3b_SNAPS_','2023-03-13 09:45:21','2023-03-13 10:44:52','62_w1_o1_mandibule_snapshot_0.png','2023-03-13 10:45:21','SYNCED','b9abf4b4-7e6d-4a36-9942-e4d261fc2b13',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.62.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'b9fe2aeb-5be3-4c12-bb79-46f1198412a3','','ZIP','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_RISC_261fcec0-ce06-45e0-a8b7-6a5f785c988d_ZIP_','2022-04-21 17:37:36','2022-04-21 13:11:18','','2022-04-21 19:37:36','SYNCED','b9fe2aeb-5be3-4c12-bb79-46f1198412a3',0,'2022-04-21 19:37:36','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.22.1.1.2\",\"modelMatrix\":\"0.990398,-0.0591629,0.125496,0,0.0595402,0.997139,-0.0424849,0,-0.124893,0.0474083,0.99119,0,3.88654,-0.889286,-9.53459,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'ba4a6637-3a12-44b7-ba1f-a50120fc6f3e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/fa7fa96b-f393-4b9a-8198-144702462cfa/session_4bed076c-8541-4a2f-800a-5aeb4cb49de5/order_85b54577-74c9-4914-ab8b-326faaeee445/35_w1_autre_prost_file_ba4a6637-3a12-44b7-ba1f-a50120fc6f3e_0.pdf','PDF','PATIENT_fa7fa96b-f393-4b9a-8198-144702462cfa_ACT_4bed076c-8541-4a2f-800a-5aeb4cb49de5_PROST_85b54577-74c9-4914-ab8b-326faaeee445_PDF_','2022-06-28 17:25:45','2022-06-28 19:25:43','35_w1_autre_prost_file_ba4a6637-3a12-44b7-ba1f-a50120fc6f3e_0.pdf','2022-06-28 19:25:45','SYNCED','ba4a6637-3a12-44b7-ba1f-a50120fc6f3e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.35.1.1 AUTRE FICHE DE PROTHESE\",\"title\":\"Autre PDF\"}'),(1001,'ba8e7087-a08c-4b5b-8b58-ad211b2b2bcb','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/8b4b6de2-edd8-44e6-88c6-8a151914aca6/session_40a1b174-1058-4d27-b63a-4e8f565fb520/order_369c86f7-3632-4aac-ad24-eb7d279d0a1d/48_w1_inlay_onlay_prost_file_ba8e7087-a08c-4b5b-8b58-ad211b2b2bcb_0.pdf','PDF','PATIENT_8b4b6de2-edd8-44e6-88c6-8a151914aca6_ACT_40a1b174-1058-4d27-b63a-4e8f565fb520_PROST_369c86f7-3632-4aac-ad24-eb7d279d0a1d_PDF_','2022-11-10 18:10:27','2022-11-10 19:10:26','48_w1_inlay_onlay_prost_file_ba8e7087-a08c-4b5b-8b58-ad211b2b2bcb_0.pdf','2022-11-10 19:10:27','SYNCED','ba8e7087-a08c-4b5b-8b58-ad211b2b2bcb',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.48.1.1 Benjamin ONLAY 45 16\",\"title\":\"Inlay/Onlay PDF\"}'),(1001,'bab4efeb-320f-419c-8066-203fc2212abd','','MATRX','PATIENT_513ccf80-8cc1-47fa-b351-4e0414a0fda5_ACT_a3b4f5f2-6b8c-4202-8856-ae1cf0aa34c5_SESS_e60585c8-59a5-4fb5-bd48-c1c3ca8ce70a_OCC_26ae7fce-0ea3-479f-9989-7d0a3a19aaf7_TOMA__MATRX_','2022-02-08 08:49:00','2022-02-07 18:58:31','','2022-02-08 09:49:00','SYNCED','bab4efeb-320f-419c-8066-203fc2212abd',0,'2022-02-08 09:49:00','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.17.1.1.1 Occlusion 6\",\"referenceScanID\":\"1.17.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.17.1.1.1 Occlusion 6\"}'),(1001,'bb22e8ec-52ef-47ae-acce-e63ab615a505','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_1c86378e-7d31-4b12-82ff-af797020160f/4_w1_o2_mandibule_scan_file_0.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_BOSC_1c86378e-7d31-4b12-82ff-af797020160f_ZIP_','2022-03-08 11:34:08','2022-03-08 12:34:01','4_w1_o2_mandibule_scan_file_0.zip','2022-03-08 12:34:08','SYNCED','bb22e8ec-52ef-47ae-acce-e63ab615a505',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.2.3\",\"modelMatrix\":\"0.770557,-0.629916,0.097197,0,0.637371,0.761545,-0.117507,0,1.23863e-09,0.152497,0.988304,0,-0.31229,4.52166,-21.9424,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'bb28b621-dccb-4c99-8175-e391881f0c0e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/986374de-c4d7-4d6f-bf0c-2dc7e3b859a9/session_c81670ed-4144-4347-b19e-8057d11b5f7c/occlusion_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be/scan_67168b1b-2bef-47a9-8e7f-994731a82831/28_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_986374de-c4d7-4d6f-bf0c-2dc7e3b859a9_ACT_c81670ed-4144-4347-b19e-8057d11b5f7c_SESS_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be_BOSC_67168b1b-2bef-47a9-8e7f-994731a82831_SNAPS_','2022-05-31 10:45:14','2022-05-31 12:45:05','28_w1_o1_mandibule_snapshot_0.png','2022-05-31 12:45:14','SYNCED','bb28b621-dccb-4c99-8175-e391881f0c0e',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.28.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'bb5d8a2c-ca49-4c79-82f5-e0afa03412b2','','ZIP','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_c9079d19-8ffb-46f7-a51e-3a7a90ccae59_SESS_8ba0f3b1-408f-4a02-92a0-63f09123b68e_BOSC_cf1df2e4-52f9-48a2-8e0b-54a1e4ed5741_ZIP_','2022-01-28 17:15:45','2022-01-26 15:48:06','','2022-01-28 18:15:45','SYNCED','7161a896-678c-49ce-a8db-989109953ffa',2,'2022-01-28 18:15:45','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.10.1.1.2\",\"modelMatrix\":\"0.516833,0.814252,-0.264344,0,-0.856086,0.491576,-0.159588,0,2.51174e-9,0.308782,0.951133,0,-33.079,-33.4874,-21.0835,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'bbbe68f7-b908-4db3-9434-4a1f290691ec','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/e922efb9-8c03-445b-8a0f-449e3c43bdca/session_a2369349-1629-40ad-8784-d271bc3fbade/occlusion_292cc1aa-8b12-463b-87a1-7d9731cf886b/scan_3d958f24-3e12-4683-9cee-1d6c2a7022c8/21_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_e922efb9-8c03-445b-8a0f-449e3c43bdca_ACT_a2369349-1629-40ad-8784-d271bc3fbade_SESS_292cc1aa-8b12-463b-87a1-7d9731cf886b_TOSC_3d958f24-3e12-4683-9cee-1d6c2a7022c8_SNAPS_','2022-04-21 08:36:29','2022-04-21 10:36:14','21_w1_o1_maxillaire_snapshot_0.png','2022-04-21 10:36:29','SYNCED','bbbe68f7-b908-4db3-9434-4a1f290691ec',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.21.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'bbd7ad1a-7152-41fb-ab32-93f20d16de8f','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/372000f2-2471-4a57-9b18-224d0788041f/session_5dd64d24-8e33-45bd-a282-c148c185c338/occlusion_a61fbfda-1ac5-4747-9e0c-6ef664930816/scan_555337af-b76d-49d5-a00a-d713c3576848/57_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_372000f2-2471-4a57-9b18-224d0788041f_ACT_5dd64d24-8e33-45bd-a282-c148c185c338_SESS_a61fbfda-1ac5-4747-9e0c-6ef664930816_TOSC_555337af-b76d-49d5-a00a-d713c3576848_SNAPS_','2023-02-17 10:53:29','2023-02-17 11:53:21','57_w1_o1_maxillaire_snapshot_0.png','2023-02-17 11:53:29','SYNCED','bbd7ad1a-7152-41fb-ab32-93f20d16de8f',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.57.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'bc3ef2fe-37e6-4917-bb61-0bdfc03e79ad','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/scan_f5ab063d-18f1-443e-b694-fd1ef20e9e78/4_w1_o4_mordu_posterieur_gauche_snapshot_1.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_LESC_f5ab063d-18f1-443e-b694-fd1ef20e9e78_SNAPS_','2022-05-31 12:11:51','2022-05-31 14:11:43','4_w1_o4_mordu_posterieur_gauche_snapshot_1.png','2022-05-31 14:11:51','SYNCED','95267990-f2d4-4cd6-b572-9f6c8fd29601',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.4.1.4.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'bc41e869-1823-4f51-9784-f364bea77540','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/1c189ddc-0ee7-45e7-9d80-585dac08374a/session_01bd0635-6ec6-42cb-8561-8638bded352c/occlusion_2aa712ca-8b46-4a50-a03e-1c6a6a0c40fc/scan_c38af399-ff7c-47c5-8f3f-7a96401d72b5/29_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_1c189ddc-0ee7-45e7-9d80-585dac08374a_ACT_01bd0635-6ec6-42cb-8561-8638bded352c_SESS_2aa712ca-8b46-4a50-a03e-1c6a6a0c40fc_LESC_c38af399-ff7c-47c5-8f3f-7a96401d72b5_SNAPS_','2022-06-03 14:04:22','2022-06-03 16:04:13','29_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-06-03 16:04:22','SYNCED','bc41e869-1823-4f51-9784-f364bea77540',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.29.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'bc4c63e5-2bf2-445a-8b4a-4c898080d492','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/8b4b6de2-edd8-44e6-88c6-8a151914aca6/session_40a1b174-1058-4d27-b63a-4e8f565fb520/occlusion_8eba4eab-4337-436a-8eb6-b59e63415159/computedocclusion_95fe0a5e-fe67-469d-aab1-023211e73996/48_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_8b4b6de2-edd8-44e6-88c6-8a151914aca6_ACT_40a1b174-1058-4d27-b63a-4e8f565fb520_SESS_8eba4eab-4337-436a-8eb6-b59e63415159_OCC_95fe0a5e-fe67-469d-aab1-023211e73996_TOMA__MATRX_','2022-11-10 10:40:10','2022-11-10 11:39:57','48_w1_o1_maxillaire_matrix_occ_file_0.m','2022-11-10 11:40:10','SYNCED','bc4c63e5-2bf2-445a-8b4a-4c898080d492',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.48.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.48.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.48.1.1.1 Occlusion 1\"}'),(1001,'bc633195-8681-4e1b-b717-dddd5f11bde7','','ZIP','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_c9079d19-8ffb-46f7-a51e-3a7a90ccae59_SESS_8ba0f3b1-408f-4a02-92a0-63f09123b68e_BOSC_30b22823-10be-472c-b053-59b470998f02_ZIP_','2022-01-28 17:15:46','2022-01-25 13:06:28','','2022-01-28 18:15:46','SYNCED','bc633195-8681-4e1b-b717-dddd5f11bde7',0,'2022-01-28 18:15:46','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.10.1.1.1\",\"modelMatrix\":\"-0.954688,-0.285844,0.0828552,0,0.29761,-0.916944,0.265787,0,8.3528e-9,0.278402,0.960465,0,13.1987,7.96464,-25.1028,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'bcba0d65-c508-4d4c-9e7f-b39de190c5ed','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/computedocclusion_00405f86-eefa-41f9-8d98-1fa9cbeef855/24_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_00405f86-eefa-41f9-8d98-1fa9cbeef855_SNAPO__SNAPS_','2022-05-25 09:03:41','2022-05-25 11:02:54','24_w1_o1_snapshot_occ_file_0.png','2022-05-25 11:03:41','SYNCED','bcba0d65-c508-4d4c-9e7f-b39de190c5ed',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'bcc40a26-24c9-4920-b007-02a587a94afd','','SNAPS','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_a16e268c-a9f5-4f0b-8346-6f1984df70bb_SNAPS_','2022-02-04 11:29:39','2022-02-02 11:14:58','','2022-02-04 12:29:39','SYNCED','bcc40a26-24c9-4920-b007-02a587a94afd',0,'2022-02-04 12:29:39','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'bcc5ce7c-04f8-4198-9751-bdfc90e79289','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a0c21836-ba79-4f15-9e35-02ef8211a9e5/session_0aac522d-3c38-465a-a1e0-014166c140ac/occlusion_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042/scan_b3e360d5-eb70-4046-910f-cbac3270fd6c/7_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_a0c21836-ba79-4f15-9e35-02ef8211a9e5_ACT_0aac522d-3c38-465a-a1e0-014166c140ac_SESS_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042_TOSC_b3e360d5-eb70-4046-910f-cbac3270fd6c_SNAPS_','2022-01-21 11:45:25','2022-01-21 12:44:52','7_w1_o1_maxillaire_snapshot_1.png','2022-01-21 12:45:25','SYNCED','c22cf400-8aa1-42db-9cdb-0b4c8cf80b52',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.7.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'bcc6d6b1-4cdb-40f6-9e05-410c5f790a07','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/scan_48982add-ff93-4e3a-a453-012a73678b39/19_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_TOSC_48982add-ff93-4e3a-a453-012a73678b39_SNAPS_','2022-03-08 11:09:54','2022-03-08 12:09:38','19_w1_o1_maxillaire_snapshot_1.png','2022-03-08 12:09:54','SYNCED','c4ff0a0b-2408-4188-9880-ebaa94ad910a',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.19.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'bcef8d3e-9632-4976-8cda-4c6f3ac50e99','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_e6c95ef7-636d-4c88-8d02-e2d9840573db/13_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_e6c95ef7-636d-4c88-8d02-e2d9840573db_ZIP_','2022-01-27 16:36:57','2022-01-27 17:36:35','13_w1_o1_mandibule_scan_file_0.zip','2022-01-27 17:36:57','SYNCED','bcef8d3e-9632-4976-8cda-4c6f3ac50e99',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.1\",\"modelMatrix\":\"-0.963479,0.243305,-0.111855,0,-0.267785,-0.8754,0.402451,0,1.23617e-9,0.417706,0.908582,0,32.4632,-3.53421,-16.2323,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'bd021490-fb1b-4029-b41d-302afd373e89','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/4fa1a134-d246-43d7-aa8c-b42e24b62b49/session_6aedf6fd-46d7-4259-88ba-5cf074ad5913/occlusion_47192ebb-25b6-4c9e-a09f-8ed295e60a87/scan_08beae91-887f-4723-8e18-ef9fee36100e/60_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_4fa1a134-d246-43d7-aa8c-b42e24b62b49_ACT_6aedf6fd-46d7-4259-88ba-5cf074ad5913_SESS_47192ebb-25b6-4c9e-a09f-8ed295e60a87_BOSC_08beae91-887f-4723-8e18-ef9fee36100e_SNAPS_','2023-03-07 18:08:57','2023-03-07 19:08:40','60_w1_o1_mandibule_snapshot_1.png','2023-03-07 19:08:57','SYNCED','c6a41fad-c98c-41bb-86d1-7cc292203d86',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.60.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'bd322705-4dbd-4e04-9721-e8cec5163a45','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/9efbbbe9-fd0a-44b1-988c-23571aad69fa/session_595a54fa-ae7d-4880-86a1-168b20242ecf/order_4d85b845-3cf8-4cb8-b9e2-289bc2658dda/53_w1_autre_prost_file_bd322705-4dbd-4e04-9721-e8cec5163a45_0.pdf','PDF','PATIENT_9efbbbe9-fd0a-44b1-988c-23571aad69fa_ACT_595a54fa-ae7d-4880-86a1-168b20242ecf_PROST_4d85b845-3cf8-4cb8-b9e2-289bc2658dda_PDF_','2022-12-14 14:58:21','2022-12-14 15:58:19','53_w1_autre_prost_file_bd322705-4dbd-4e04-9721-e8cec5163a45_0.pdf','2022-12-14 15:58:21','SYNCED','bd322705-4dbd-4e04-9721-e8cec5163a45',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"COMMANDE 1.53.1.3 AUTRE FICHE DE PROTHESE\",\"title\":\"Autre PDF\"}'),(1001,'bd5e6662-24ee-41e1-984f-ae69a2181d96','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_4ed7adaa-3b77-4537-8479-4d0c4bd28c7b/12_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_TOSC_4ed7adaa-3b77-4537-8479-4d0c4bd28c7b_SNAPS_','2022-01-27 11:58:32','2022-01-27 12:58:04','12_w1_o1_maxillaire_snapshot_1.png','2022-01-27 12:58:32','SYNCED','8f3ff963-3c36-45c7-aeef-20558e20e496',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.12.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'bd6002bf-c415-4f2f-bc32-a5d650a91be7','','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_OCC_1500b3eb-4b86-46c1-9c9f-7efbd0224ac8_TOPLY__ZIP_','2022-05-25 08:56:38','2022-05-13 18:22:04','','2022-05-25 10:56:38','SYNCED','bd6002bf-c415-4f2f-bc32-a5d650a91be7',0,'2022-05-25 10:56:38','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.2 Occlusion 4\",\"modelMatrix\":\"-0.80453,0.576793,-0.141569,0,-0.593912,-0.781339,0.191773,0,-6.05286e-09,0.238367,0.971175,0,0.910551,-5.61768,-25.9513,1\",\"referenceScanID\":\"1.24.1.1.2\",\"title\":\"Maxillaire 1.24.1.1.2 Occlusion 4\"}'),(1001,'bd6547b3-c0de-47d0-bbc5-60dbfff0774b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/scan_fde05ea2-d0fd-419b-ba13-bf1a1bd03a22/18_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_BOSC_fde05ea2-d0fd-419b-ba13-bf1a1bd03a22_SNAPS_','2022-03-07 14:25:30','2022-03-07 15:25:17','18_w1_o1_mandibule_snapshot_0.png','2022-03-07 15:25:30','SYNCED','bd6547b3-c0de-47d0-bbc5-60dbfff0774b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.18.1.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'bd950b62-1dff-4500-a7bd-87564d6d797c','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/986374de-c4d7-4d6f-bf0c-2dc7e3b859a9/session_c81670ed-4144-4347-b19e-8057d11b5f7c/occlusion_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be/scan_f6f4f4dc-826e-4efc-957c-61074915b6b6/28_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_986374de-c4d7-4d6f-bf0c-2dc7e3b859a9_ACT_c81670ed-4144-4347-b19e-8057d11b5f7c_SESS_a843a9cf-5a96-4a4e-8679-2c4dddd5e6be_RISC_f6f4f4dc-826e-4efc-957c-61074915b6b6_ZIP_','2022-05-31 10:52:50','2022-05-31 12:52:42','28_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-05-31 12:52:50','SYNCED','bd950b62-1dff-4500-a7bd-87564d6d797c',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.28.1.1.1\",\"modelMatrix\":\"0.989642,-0.0901087,0.109351,0,0.0882222,0.994872,0.0512598,0,-0.113313,-0.0463427,0.992693,0,6.92822,1.84947,-16.9683,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(2,'bda6bdd6-862a-42a9-a75d-a4bcb49f2d6b','','ZIP','PATIENT_1095dc95-d70a-4936-8b50-ae8aa7963fc9_ACT_440a8315-0df8-4219-8d74-9470bfeeacbf_SESS_8cfb01ae-a13a-442b-9752-d2219bf5d263_TOSC_807a5b2c-0545-475c-b38c-00561d7c62df_ZIP_','2022-08-30 08:32:23','2022-07-28 14:33:14','',NULL,'CREATED','bda6bdd6-862a-42a9-a75d-a4bcb49f2d6b',0,'2022-08-30 10:32:23','bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 371.2.1.1.1\",\"modelMatrix\":\"0.781299,-0.551197,0.292837,0,0.624157,0.689971,-0.366563,0,-3.73229e-09,0.469172,0.883107,0,9.52285,-32.0404,-18.9641,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'bdacdfeb-45f7-4ecd-a130-0d654c6fa37f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_04d6e3f1-19ce-4851-a9d0-40419cea7542/scan_e61be1a3-1cc4-4625-b318-5e591ee9846a/19_w1_o2_mordu_anterieur_snapshot_0.png','SNAPS','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_04d6e3f1-19ce-4851-a9d0-40419cea7542_FRSC_e61be1a3-1cc4-4625-b318-5e591ee9846a_SNAPS_','2022-04-15 11:41:18','2022-04-01 18:21:10','19_w1_o2_mordu_anterieur_snapshot_0.png','2022-04-15 13:41:18','SYNCED','bdacdfeb-45f7-4ecd-a130-0d654c6fa37f',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu anterieur 1.19.1.2.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}'),(1001,'bddcd9b3-c70e-46f1-8f8d-64ad558320cb','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/1c189ddc-0ee7-45e7-9d80-585dac08374a/session_01bd0635-6ec6-42cb-8561-8638bded352c/occlusion_2aa712ca-8b46-4a50-a03e-1c6a6a0c40fc/scan_c38af399-ff7c-47c5-8f3f-7a96401d72b5/29_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_1c189ddc-0ee7-45e7-9d80-585dac08374a_ACT_01bd0635-6ec6-42cb-8561-8638bded352c_SESS_2aa712ca-8b46-4a50-a03e-1c6a6a0c40fc_LESC_c38af399-ff7c-47c5-8f3f-7a96401d72b5_ZIP_','2022-06-03 14:04:21','2022-06-03 16:04:14','29_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-06-03 16:04:21','SYNCED','bddcd9b3-c70e-46f1-8f8d-64ad558320cb',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.29.1.1.1\",\"modelMatrix\":\"-0.981057,0.00668509,-0.194821,0,-0.0578871,-0.967667,0.241749,0,-0.184897,0.252197,0.950592,0,-11.5718,-8.39478,-24.1213,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'be597cd8-a226-4cc2-affe-df9ddb8e42a3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_2a7068fc-0efa-496f-ade9-aba5b0650655/12_w1_o1_mandibule_scan_file_2.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_BOSC_2a7068fc-0efa-496f-ade9-aba5b0650655_ZIP_','2022-02-04 11:57:21','2022-02-04 12:56:17','12_w1_o1_mandibule_scan_file_2.zip','2022-02-04 12:57:21','SYNCED','44ebcd6f-57c2-4cce-96f5-f9faa1c6b373',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.12.1.1.5\",\"modelMatrix\":\"0.713807,-0.664318,0.221723,0,0.700343,0.677089,-0.225986,0,-4.22566e-9,0.316593,0.948562,0,3.53751,30.2884,-29.5645,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'beb8e4d6-e895-4b9c-972f-5a6d0d1b39cd','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/3a170256-4132-4b56-ad27-b2cc7790bbf8/session_c57164ce-3f15-42b7-a8dc-96ab6a136184/occlusion_4779508f-bef4-4a89-9555-58b917369f06/computedocclusion_c02aa6d3-8bb3-4ebb-ae67-2dc59b73bc9f/62_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_3a170256-4132-4b56-ad27-b2cc7790bbf8_ACT_c57164ce-3f15-42b7-a8dc-96ab6a136184_SESS_4779508f-bef4-4a89-9555-58b917369f06_OCC_c02aa6d3-8bb3-4ebb-ae67-2dc59b73bc9f_SNAPO__SNAPS_','2023-03-14 09:16:27','2023-03-13 10:51:53','62_w1_o1_snapshot_occ_file_0.png','2023-03-14 10:16:27','SYNCED','beb8e4d6-e895-4b9c-972f-5a6d0d1b39cd',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'bf0bcfa3-f531-46fe-9ee8-0c42f01196a3','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_b28164eb-0070-4968-83be-bfabe1a0c839/13_w1_o1_mandibule_scan_file_1.zip','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_b28164eb-0070-4968-83be-bfabe1a0c839_ZIP_','2022-02-04 17:55:53','2022-02-04 16:58:23','13_w1_o1_mandibule_scan_file_1.zip','2022-02-04 18:55:53','SYNCED','d8a3bf39-16d1-435f-bafa-6c625f77d811',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.5\",\"modelMatrix\":\"-0.999116,-0.0392827,0.0149893,0,0.0420454,-0.933468,0.356187,0,-3.66865e-10,0.356503,0.934294,0,26.1512,5.7893,-22.5637,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'bf19efc9-b89f-4603-b2a2-1ce7bcd94152','','ZIP','PATIENT_69640c87-271c-4a44-a6fa-67b01654cc27_ACT_5f9199b0-eb37-4ed3-8d1a-6c38505d4913_SESS_991beec3-fe9e-4c98-a3d4-c98e4a4c2471_LESC_0e74383c-84a7-4c1f-b833-adf54ce6a402_ZIP_','2022-09-10 08:18:25','2022-09-10 10:17:21','','2022-09-10 10:18:25','SYNCED','2c5f5cbb-b4e2-48d5-951b-8b45381f8520',1,'2022-09-10 10:18:25','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.39.1.1.11\",\"modelMatrix\":\"0.982905,0.0665172,0.172476,0,-0.0922199,0.979731,0.17838,0,-0.159442,-0.189045,0.968733,0,17.3596,5.98539,-12.3379,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'bf1a3548-3c4b-44f2-98bd-9b8130cf0fb8','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_04d6e3f1-19ce-4851-a9d0-40419cea7542/scan_9e43db2d-10a9-414e-ac07-6b7642412ce5/19_w1_o2_maxillaire_scan_file_0.zip','ZIP','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_04d6e3f1-19ce-4851-a9d0-40419cea7542_TOSC_9e43db2d-10a9-414e-ac07-6b7642412ce5_ZIP_','2022-04-15 11:41:38','2022-04-01 18:15:20','19_w1_o2_maxillaire_scan_file_0.zip','2022-04-15 13:41:38','SYNCED','bf1a3548-3c4b-44f2-98bd-9b8130cf0fb8',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.19.1.2.1\",\"modelMatrix\":\"0.318649,0.89091,-0.323639,0,-0.947873,0.299499,-0.108798,0,3.80085e-09,0.341437,0.939905,0,13.7443,-16.4334,-19.6973,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'bf27fa48-2bce-43eb-98c2-306272ec251f','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/computedocclusion_6960b50e-6f78-4f83-9303-8c985410457c/4_w1_o4_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_OCC_6960b50e-6f78-4f83-9303-8c985410457c_BOMA__MATRX_','2022-05-31 14:55:58','2022-05-31 16:55:44','4_w1_o4_mandibule_matrix_occ_file_0.m','2022-05-31 16:55:58','SYNCED','bf27fa48-2bce-43eb-98c2-306272ec251f',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.4.1.4.1 Occlusion 5\",\"referenceScanID\":\"1.4.1.4.1\",\"title\":\"Matrice Transfo. Mandibule 1.4.1.4.1 Occlusion 5\"}'),(1001,'bf2dec6c-e829-4736-9db7-bda108ca2719','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/207d6dbc-c19b-4726-a9b3-16235ae554cc/session_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35/occlusion_dc5762a3-c453-4166-8c86-82d23ac9f8a6/scan_db144753-52d9-4c43-950b-25093a3aee5f/27_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_207d6dbc-c19b-4726-a9b3-16235ae554cc_ACT_7fe13e47-f2c8-4c59-ad95-d384d4cbaa35_SESS_dc5762a3-c453-4166-8c86-82d23ac9f8a6_RISC_db144753-52d9-4c43-950b-25093a3aee5f_ZIP_','2022-05-30 11:09:16','2022-05-30 13:09:08','27_w1_o1_mordu_posterieur_droit_scan_file_0.zip','2022-05-30 13:09:16','SYNCED','bf2dec6c-e829-4736-9db7-bda108ca2719',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.27.1.1.1\",\"modelMatrix\":\"0.996158,-0.023589,0.0912871,0,0.0456219,0.945925,-0.313373,0,-0.0751123,0.323645,0.945278,0,4.22253,-9.63293,-15.9528,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'bf5f3197-46fe-4c2d-9679-cdcce7bb8d90','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5/occlusion_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa/computedocclusion_901f8265-7f99-4d24-a03f-5860f5bc155e/24_w2_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5_SESS_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa_OCC_901f8265-7f99-4d24-a03f-5860f5bc155e_TOMA__MATRX_','2022-10-07 14:32:18','2022-10-07 16:31:57','24_w2_o1_maxillaire_matrix_occ_file_0.m','2022-10-07 16:32:18','SYNCED','bf5f3197-46fe-4c2d-9679-cdcce7bb8d90',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.24.2.1.1 Occlusion 1\",\"referenceScanID\":\"1.24.2.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.24.2.1.1 Occlusion 1\"}'),(1001,'bf650fa6-3b37-4142-ba9f-2bdb57a0b0a0','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_909d9ecd-46b3-4692-868e-f6405507ecd1/24_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_TOSC_909d9ecd-46b3-4692-868e-f6405507ecd1_SNAPS_','2022-05-13 14:42:34','2022-05-13 16:42:22','24_w1_o1_maxillaire_snapshot_1.png','2022-05-13 16:42:34','SYNCED','80ec1edf-c2f7-4914-86c8-ba85dac6448a',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'bf977ba6-1388-455d-8a60-6aeb33b3bae6','','ZIP','PATIENT_9e399d73-4d2e-4bb8-af48-a4e597811faa_ACT_b1cf14ce-00a9-48b6-8654-dadde26073f1_SESS_3c4595e0-fbbb-4814-8851-1e014eb9a3b2_OCC_96299368-ebcf-4fb9-875d-9bbcfec8ffa0_BOPLY__ZIP_','2022-10-27 17:31:08','2022-10-27 19:30:22','','2022-10-27 19:31:08','SYNCED','bf977ba6-1388-455d-8a60-6aeb33b3bae6',0,'2022-10-27 19:31:08','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.46.1.1.5 Occlusion 2\",\"modelMatrix\":\"-0.739769,0.651616,-0.167743,0,-0.672861,-0.716412,0.184424,0,-9.61468e-10,0.249299,0.968427,0,-5.38889,-26.0403,-20.6172,1\",\"referenceScanID\":\"1.46.1.1.5\",\"title\":\"Mandibule 1.46.1.1.5 Occlusion 2\"}'),(1001,'bfbd620d-ea20-449f-aa53-6517b2fdaa2e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_1c86378e-7d31-4b12-82ff-af797020160f/4_w1_o2_mandibule_scan_file_3.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_BOSC_1c86378e-7d31-4b12-82ff-af797020160f_ZIP_','2022-03-08 11:43:38','2022-03-08 12:43:31','4_w1_o2_mandibule_scan_file_3.zip','2022-03-08 12:43:38','SYNCED','bb22e8ec-52ef-47ae-acce-e63ab615a505',3,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.2.3\",\"modelMatrix\":\"0.966621,-0.254359,0.0307347,0,0.256209,0.959641,-0.115955,0,1.29208e-09,0.119959,0.992779,0,-3.1268,5.20706,-21.613,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'bfbe666e-8f72-4da8-8054-ee175d7a8ba1','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d/session_223a16b9-c15c-4bcc-9b2f-7373785fcc51/occlusion_80157bb6-d98e-4928-a658-75f9654bf520/scan_03839278-13f8-46e6-9581-ba11bc8bcb81/1_w1_o1_maxillaire_snapshot_2.png','SNAPS','PATIENT_2ed3ebb7-b7e4-46db-b9ac-6c5223ca3b7d_ACT_223a16b9-c15c-4bcc-9b2f-7373785fcc51_SESS_80157bb6-d98e-4928-a658-75f9654bf520_TOSC_03839278-13f8-46e6-9581-ba11bc8bcb81_SNAPS_','2022-01-19 12:59:56','2022-01-19 11:09:47','1_w1_o1_maxillaire_snapshot_2.png','2022-01-19 13:59:56','SYNCED','99c7b58b-6259-4c43-ac2f-8b7f47f0b3e7',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.1.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'c0104148-b00b-48dc-8336-d2def7604c23','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/scan_f2bad12a-451d-406d-98b0-e431a37951dd/19_w1_o1_mandibule_snapshot_3.png','SNAPS','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_BOSC_f2bad12a-451d-406d-98b0-e431a37951dd_SNAPS_','2022-03-08 10:52:49','2022-03-08 11:52:38','19_w1_o1_mandibule_snapshot_3.png','2022-03-08 11:52:49','SYNCED','8fb19261-9e70-4678-8a85-98e89dd98dcb',3,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.19.1.1.4\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'c0525ada-69d4-48cd-8a40-bc519e5e134a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/204921b5-c765-4248-8e87-e3b0f7a46bff/session_88257045-93fb-43fb-8b0a-f39fbf5f8e9d/occlusion_ad360501-c145-40e5-9b88-808cd7a61eed/scan_fbf36163-e1ef-42da-9ec3-02d6cc9846f2/45_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_204921b5-c765-4248-8e87-e3b0f7a46bff_ACT_88257045-93fb-43fb-8b0a-f39fbf5f8e9d_SESS_ad360501-c145-40e5-9b88-808cd7a61eed_TOSC_fbf36163-e1ef-42da-9ec3-02d6cc9846f2_ZIP_','2022-10-18 12:42:27','2022-10-18 14:42:15','45_w1_o1_maxillaire_scan_file_1.zip','2022-10-18 14:42:27','SYNCED','4347ec13-c6ed-41aa-b45f-2844488ba96b',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.45.1.1.1\",\"modelMatrix\":\"0.862969,0.458231,-0.212858,0,-0.505256,0.782651,-0.363558,0,-4.9207e-10,0.421287,0.906927,0,-16.5834,-5.58645,-14.2641,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'c0cdf5d8-4fde-44b3-a0a6-864890a22097','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/372000f2-2471-4a57-9b18-224d0788041f/session_5dd64d24-8e33-45bd-a282-c148c185c338/occlusion_a61fbfda-1ac5-4747-9e0c-6ef664930816/computedocclusion_7eb0f2bf-a2c1-4938-b124-5a10e3cdb809/57_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_372000f2-2471-4a57-9b18-224d0788041f_ACT_5dd64d24-8e33-45bd-a282-c148c185c338_SESS_a61fbfda-1ac5-4747-9e0c-6ef664930816_OCC_7eb0f2bf-a2c1-4938-b124-5a10e3cdb809_BOPLY__ZIP_','2023-02-17 10:55:30','2023-02-17 11:55:24','57_w1_o1_mandibule_occlusion_occ_file_0.zip','2023-02-17 11:55:30','SYNCED','c0cdf5d8-4fde-44b3-a0a6-864890a22097',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.57.1.1.1 Occlusion 1\",\"modelMatrix\":\"-0.418792,0.887285,-0.193232,0,-0.908082,-0.4092,0.0891151,0,7.57919e-09,0.212791,0.977098,0,-4.31242,-10.0713,-19.3584,1\",\"referenceScanID\":\"1.57.1.1.1\",\"title\":\"Mandibule 1.57.1.1.1 Occlusion 1\"}'),(1001,'c0e2418d-8a03-4c3c-bc34-614d663c5fce','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/occlusion_e08bbeeb-a30b-428c-bd4a-40198f792219/scan_dee5ca38-e252-41d1-86ca-aebc66ae36fa/25_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_SESS_e08bbeeb-a30b-428c-bd4a-40198f792219_TOSC_dee5ca38-e252-41d1-86ca-aebc66ae36fa_SNAPS_','2022-05-17 16:34:40','2022-05-17 18:33:04','25_w1_o1_maxillaire_snapshot_0.png','2022-05-17 18:34:40','SYNCED','c0e2418d-8a03-4c3c-bc34-614d663c5fce',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.25.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'c1120aee-580c-477f-b742-b40b047b9a91','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_2ffbfbca-f236-4802-be93-8eb43d523274/scan_6313fe60-344e-44c5-9805-fd1382bb983f/4_w1_o1_mordu_posterieur_gauche_snapshot_0.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_2ffbfbca-f236-4802-be93-8eb43d523274_LESC_6313fe60-344e-44c5-9805-fd1382bb983f_SNAPS_','2022-01-19 19:08:57','2022-01-19 20:08:48','4_w1_o1_mordu_posterieur_gauche_snapshot_0.png','2022-01-19 20:08:57','SYNCED','c1120aee-580c-477f-b742-b40b047b9a91',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.4.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}'),(1001,'c14ac2f7-ec03-4ab2-8267-1c397129a864','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/8fc74d9e-a5a0-46bf-be3f-500548a130ad/session_5368829e-7dec-4775-a487-a1019f9604f4/occlusion_bb63a653-1b34-4d80-a4bf-7fda5c9b0360/scan_e3fea328-cb79-4ad5-a652-3eebe9ee3e12/14_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_8fc74d9e-a5a0-46bf-be3f-500548a130ad_ACT_5368829e-7dec-4775-a487-a1019f9604f4_SESS_bb63a653-1b34-4d80-a4bf-7fda5c9b0360_TOSC_e3fea328-cb79-4ad5-a652-3eebe9ee3e12_ZIP_','2022-02-01 10:42:11','2022-02-01 11:41:46','14_w1_o1_maxillaire_scan_file_0.zip','2022-02-01 11:42:11','SYNCED','c14ac2f7-ec03-4ab2-8267-1c397129a864',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.14.1.1.1\",\"modelMatrix\":\"-0.0269183,0.931537,-0.362649,0,-0.999638,-0.0250845,0.00976544,0,7.96669e-10,0.362781,0.931875,0,-6.3101,-33.0938,-17.1491,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'c15808cb-381a-47c9-ba70-a9a403b0e4bd','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/1c189ddc-0ee7-45e7-9d80-585dac08374a/session_01bd0635-6ec6-42cb-8561-8638bded352c/occlusion_2aa712ca-8b46-4a50-a03e-1c6a6a0c40fc/scan_2b27113d-3b20-4d7e-8591-1e87c6e97f79/29_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_1c189ddc-0ee7-45e7-9d80-585dac08374a_ACT_01bd0635-6ec6-42cb-8561-8638bded352c_SESS_2aa712ca-8b46-4a50-a03e-1c6a6a0c40fc_BOSC_2b27113d-3b20-4d7e-8591-1e87c6e97f79_SNAPS_','2022-06-03 14:01:22','2022-06-03 16:01:12','29_w1_o1_mandibule_snapshot_0.png','2022-06-03 16:01:22','SYNCED','c15808cb-381a-47c9-ba70-a9a403b0e4bd',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.29.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'c1706d9d-89f0-4794-af54-6d74e899ee8d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/7eca2942-3d65-4279-8dae-998594082bb0/session_6cd9ac89-d152-4881-ae60-0aa4d933a545/occlusion_229f401f-4824-48cc-8a9f-7a5549d69acd/computedocclusion_d7643aed-d242-47f6-8e1a-703d4672f109/18_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_7eca2942-3d65-4279-8dae-998594082bb0_ACT_6cd9ac89-d152-4881-ae60-0aa4d933a545_SESS_229f401f-4824-48cc-8a9f-7a5549d69acd_OCC_d7643aed-d242-47f6-8e1a-703d4672f109_SNAPO__SNAPS_','2022-03-07 14:44:47','2022-03-07 15:44:20','18_w1_o1_snapshot_occ_file_0.png','2022-03-07 15:44:47','SYNCED','c1706d9d-89f0-4794-af54-6d74e899ee8d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'c17202cb-8a06-49f1-8c63-30b130420dff','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/9e399d73-4d2e-4bb8-af48-a4e597811faa/session_b1cf14ce-00a9-48b6-8654-dadde26073f1/occlusion_3c4595e0-fbbb-4814-8851-1e014eb9a3b2/scan_81e1cec8-829c-49a8-b117-60631f4120bb/46_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_9e399d73-4d2e-4bb8-af48-a4e597811faa_ACT_b1cf14ce-00a9-48b6-8654-dadde26073f1_SESS_3c4595e0-fbbb-4814-8851-1e014eb9a3b2_TOSC_81e1cec8-829c-49a8-b117-60631f4120bb_SNAPS_','2022-10-20 10:45:48','2022-10-20 12:45:36','46_w1_o1_maxillaire_snapshot_0.png','2022-10-20 12:45:48','SYNCED','c17202cb-8a06-49f1-8c63-30b130420dff',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.46.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'c1eb653c-d8dd-488d-b196-a7a488805ae6','','ZIP','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_c9079d19-8ffb-46f7-a51e-3a7a90ccae59_SESS_8ba0f3b1-408f-4a02-92a0-63f09123b68e_BOSC_30b22823-10be-472c-b053-59b470998f02_ZIP_','2022-01-28 17:15:46','2022-01-25 13:09:38','','2022-01-28 18:15:46','SYNCED','bc633195-8681-4e1b-b717-dddd5f11bde7',1,'2022-01-28 18:15:46','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.10.1.1.1\",\"modelMatrix\":\"-0.983812,-0.173715,0.0440174,0,0.179205,-0.953672,0.24165,0,1.67449e-9,0.245626,0.969365,0,14.6058,7.88415,-24.7234,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'c1ee6f0c-823c-43ab-892b-aa2b9c60a5d0','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_8052e101-fd65-454a-bce4-f65648f63218/scan_7b00996b-90f8-4307-9a8c-263a28f1b341/4_w1_o4_maxillaire_scan_file_0.zip','ZIP','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_8052e101-fd65-454a-bce4-f65648f63218_TOSC_7b00996b-90f8-4307-9a8c-263a28f1b341_ZIP_','2022-05-31 11:49:48','2022-05-31 13:49:39','4_w1_o4_maxillaire_scan_file_0.zip','2022-05-31 13:49:48','SYNCED','c1ee6f0c-823c-43ab-892b-aa2b9c60a5d0',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.4.1.4.1\",\"modelMatrix\":\"-0.976219,0.212414,-0.0433081,0,-0.216784,-0.956541,0.195024,0,9.94229e-10,0.199775,0.979842,0,22.5049,-19.3077,-18.1141,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'c202fc68-d539-4e94-bd22-11d4de172444','','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_OCC_764b8e22-8600-49e3-8d7c-d619725096ee_TOPLY__ZIP_','2022-02-04 18:20:41','2022-02-04 19:19:48','',NULL,'CREATED','c202fc68-d539-4e94-bd22-11d4de172444',0,'2022-02-04 19:20:41','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.13.1.1.3 Occlusion 2\",\"modelMatrix\":\"0.754335,0.643596,-0.129474,0,-0.65649,0.739519,-0.148771,0,2.61688e-9,0.197222,0.980359,0,-9.25272,-30.1421,-17.7968,1\",\"referenceScanID\":\"1.13.1.1.3\",\"title\":\"Maxillaire 1.13.1.1.3 Occlusion 2\"}'),(1001,'c21d6e1f-eb4c-4e11-b986-f98e0036cdad','','SNAPS','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_RISC_029ae158-d269-4f43-b5ee-add7ce3f59c5_SNAPS_','2022-04-21 13:44:33','2022-04-21 13:25:56','','2022-04-21 15:44:33','SYNCED','c21d6e1f-eb4c-4e11-b986-f98e0036cdad',0,'2022-04-21 15:44:33','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.22.1.1.4\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1001,'c22c34d6-3e86-4fba-8c43-6789f89dcca5','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/computedocclusion_d5bff097-1085-4c55-afe3-1ce57126d88f/19_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_OCC_d5bff097-1085-4c55-afe3-1ce57126d88f_SNAPO__SNAPS_','2022-03-08 11:16:25','2022-03-08 12:15:58','19_w1_o1_snapshot_occ_file_0.png','2022-03-08 12:16:25','SYNCED','c22c34d6-3e86-4fba-8c43-6789f89dcca5',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'c22cf400-8aa1-42db-9cdb-0b4c8cf80b52','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/a0c21836-ba79-4f15-9e35-02ef8211a9e5/session_0aac522d-3c38-465a-a1e0-014166c140ac/occlusion_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042/scan_b3e360d5-eb70-4046-910f-cbac3270fd6c/7_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_a0c21836-ba79-4f15-9e35-02ef8211a9e5_ACT_0aac522d-3c38-465a-a1e0-014166c140ac_SESS_5fce6fae-c3c1-4c4e-83c6-4a714c2c0042_TOSC_b3e360d5-eb70-4046-910f-cbac3270fd6c_SNAPS_','2022-01-21 11:31:57','2022-01-21 12:31:32','7_w1_o1_maxillaire_snapshot_0.png','2022-01-21 12:31:57','SYNCED','c22cf400-8aa1-42db-9cdb-0b4c8cf80b52',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.7.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'c2e41fcc-1846-464a-b169-dcfb11da5d08','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/87f00f75-c29c-430a-a553-82cbedff21d9/session_146b346d-b9f6-44b4-a722-edc0a0f231ed/occlusion_7eb5bc72-17d3-47d8-9061-8fb639403734/computedocclusion_42098ceb-3335-4f13-8aed-b29c37a5f57f/22_w1_o1_maxillaire_matrix_occ_file_0.m','MATRX','PATIENT_87f00f75-c29c-430a-a553-82cbedff21d9_ACT_146b346d-b9f6-44b4-a722-edc0a0f231ed_SESS_7eb5bc72-17d3-47d8-9061-8fb639403734_OCC_42098ceb-3335-4f13-8aed-b29c37a5f57f_TOMA__MATRX_','2022-04-21 11:29:06','2022-04-21 13:28:43','22_w1_o1_maxillaire_matrix_occ_file_0.m','2022-04-21 13:29:06','SYNCED','c2e41fcc-1846-464a-b169-dcfb11da5d08',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.22.1.1.1 Occlusion 6\",\"referenceScanID\":\"1.22.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 1.22.1.1.1 Occlusion 6\"}'),(1001,'c30979c0-872b-4f50-a4ed-19896daeb6d2','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/4a3954e0-1e2f-4721-9fdd-4180380dc19f/session_33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416/occlusion_3accbada-5a51-4d10-88d1-c3e7d8598d6f/computedocclusion_5775815f-f076-48af-be27-50e4dbfd3622/34_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_4a3954e0-1e2f-4721-9fdd-4180380dc19f_ACT_33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416_SESS_3accbada-5a51-4d10-88d1-c3e7d8598d6f_OCC_5775815f-f076-48af-be27-50e4dbfd3622_BOPLY__ZIP_','2022-06-28 10:56:07','2022-06-28 12:55:54','34_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-06-28 12:56:07','SYNCED','c30979c0-872b-4f50-a4ed-19896daeb6d2',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.34.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.234069,0.962585,-0.136536,0,-0.97222,0.231749,-0.0328721,0,9.44423e-10,0.140438,0.990089,0,-4.58165,-19.1006,-16.3325,1\",\"referenceScanID\":\"1.34.1.1.1\",\"title\":\"Mandibule 1.34.1.1.1 Occlusion 1\"}'),(1001,'c3145bbe-5da6-4795-912e-283b8f3c5475','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/ca43bf7b-f931-42fc-bb75-05929e4b6578/session_d9740504-a9ca-472a-83f2-a309fa225a98/occlusion_d663165c-f330-4c61-8d1f-14869b6d5edd/computedocclusion_f62e0c41-a151-4495-829e-f57ef5d37eb8/59_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_ca43bf7b-f931-42fc-bb75-05929e4b6578_ACT_d9740504-a9ca-472a-83f2-a309fa225a98_SESS_d663165c-f330-4c61-8d1f-14869b6d5edd_OCC_f62e0c41-a151-4495-829e-f57ef5d37eb8_SNAPO__SNAPS_','2023-03-10 15:14:03','2023-03-10 16:13:23','59_w1_o1_snapshot_occ_file_0.png','2023-03-10 16:14:03','SYNCED','c3145bbe-5da6-4795-912e-283b8f3c5475',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'c3304273-3e21-43cc-9d46-d2367b2cd27a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f4fc00ec-4af8-4a15-b427-f1c5aabf6260/session_498ae60a-23f0-44fc-9730-be499bfc4b46/occlusion_8f3d6c73-3468-45a5-85c7-93bba47ec9f7/computedocclusion_9c318e86-fa90-4cd9-8319-2503cde2b455/30_w1_o1_snapshot_occ_file_0.png','SNAPS','PATIENT_f4fc00ec-4af8-4a15-b427-f1c5aabf6260_ACT_498ae60a-23f0-44fc-9730-be499bfc4b46_SESS_8f3d6c73-3468-45a5-85c7-93bba47ec9f7_OCC_9c318e86-fa90-4cd9-8319-2503cde2b455_SNAPO__SNAPS_','2022-06-14 13:30:13','2022-06-14 15:29:56','30_w1_o1_snapshot_occ_file_0.png','2022-06-14 15:30:13','SYNCED','c3304273-3e21-43cc-9d46-d2367b2cd27a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1001,'c36d61c2-2b14-4da2-9185-e643f1f6742b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3fe29844-5082-4e50-a510-61af15cb5cba/session_dcedf77c-c664-46b3-91b3-902529b54810/occlusion_b3ae2904-41ee-4eef-9639-bb150af1853a/scan_e6c95ef7-636d-4c88-8d02-e2d9840573db/13_w1_o1_mandibule_scan_file_8.zip','ZIP','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_BOSC_e6c95ef7-636d-4c88-8d02-e2d9840573db_ZIP_','2022-01-27 16:51:00','2022-01-27 17:49:39','13_w1_o1_mandibule_scan_file_8.zip','2022-01-27 17:51:00','SYNCED','bcef8d3e-9632-4976-8cda-4c6f3ac50e99',8,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.13.1.1.1\",\"modelMatrix\":\"-0.961822,0.259307,-0.0875072,0,-0.273675,-0.911329,0.307542,0,5.65717e-9,0.319749,0.947502,0,33.7925,-1.80222,-15.4388,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'c374da70-6cb6-437a-8ae4-040181827836','','SNAPS','PATIENT_458c92d8-9da1-4df9-967f-d14fc7e6303d_ACT_c9079d19-8ffb-46f7-a51e-3a7a90ccae59_SESS_8ba0f3b1-408f-4a02-92a0-63f09123b68e_BOSC_30b22823-10be-472c-b053-59b470998f02_SNAPS_','2022-01-28 17:15:46','2022-01-25 13:09:36','','2022-01-28 18:15:46','SYNCED','6f4c2c37-2063-47e9-9b81-2912e4b09097',1,'2022-01-28 18:15:46','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.10.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'c398736b-e3ae-4eeb-8e0f-feb7cac2e342','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f9d03016-567a-4bd4-9cc5-dafeea34e365/session_a7bcb190-dd19-4f3b-8aab-266030bf4064/occlusion_c321e210-b67c-40e8-bece-f8946164a768/scan_e7993d2d-cc6b-42d8-af77-232b04342812/36_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_f9d03016-567a-4bd4-9cc5-dafeea34e365_ACT_a7bcb190-dd19-4f3b-8aab-266030bf4064_SESS_c321e210-b67c-40e8-bece-f8946164a768_TOSC_e7993d2d-cc6b-42d8-af77-232b04342812_ZIP_','2022-07-04 14:04:56','2022-07-04 16:04:46','36_w1_o1_maxillaire_scan_file_0.zip','2022-07-04 16:04:56','SYNCED','c398736b-e3ae-4eeb-8e0f-feb7cac2e342',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.36.1.1.1\",\"modelMatrix\":\"-0.740632,0.661068,-0.120222,0,-0.671911,-0.72868,0.132518,0,7.47193e-09,0.178926,0.983863,0,13.1843,-17.5524,-17.7657,1\",\"title\":\"Maxillaire ZIP\"}'),(1001,'c39da37e-4667-466c-b9db-fab10209d8c7','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/3ed7a8e0-5b4d-4ecf-b4ae-f855b16c0f93/session_fb42cec6-0bb6-41e9-912d-0517ff8e0942/occlusion_fb214b2f-5e41-492d-85c4-d4a11a3947c5/computedocclusion_f6573412-d667-47a1-89b2-d0a46006380f/42_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_3ed7a8e0-5b4d-4ecf-b4ae-f855b16c0f93_ACT_fb42cec6-0bb6-41e9-912d-0517ff8e0942_SESS_fb214b2f-5e41-492d-85c4-d4a11a3947c5_OCC_f6573412-d667-47a1-89b2-d0a46006380f_BOMA__MATRX_','2022-10-07 17:38:20','2022-10-07 19:37:42','42_w1_o1_mandibule_matrix_occ_file_0.m','2022-10-07 19:38:20','SYNCED','c39da37e-4667-466c-b9db-fab10209d8c7',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.42.1.1.1 Occlusion 5\",\"referenceScanID\":\"1.42.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.42.1.1.1 Occlusion 5\"}'),(1001,'c4219553-f53a-48f8-820d-9c01d2eaa22b','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/1a8329eb-7dbc-4bfd-b669-6d92e13fec0c/session_11fb4259-c305-4a08-b750-536f769f44b0/occlusion_129468ab-1f43-4ba1-8939-49286128bf4d/scan_430d66d5-4ccd-49c5-9614-7474c1a1d4a4/47_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_1a8329eb-7dbc-4bfd-b669-6d92e13fec0c_ACT_11fb4259-c305-4a08-b750-536f769f44b0_SESS_129468ab-1f43-4ba1-8939-49286128bf4d_LESC_430d66d5-4ccd-49c5-9614-7474c1a1d4a4_ZIP_','2022-10-21 16:16:08','2022-10-21 18:16:02','47_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-10-21 18:16:08','SYNCED','c4219553-f53a-48f8-820d-9c01d2eaa22b',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.47.1.1.1\",\"modelMatrix\":\"-0.996217,0.042145,0.0758341,0,-0.033984,-0.98612,0.159554,0,0.0801279,0.160705,0.984283,0,-15.9177,-3.14082,-18.5496,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'c4558dcb-a90e-4000-a6ce-32ab19092a21','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/9e399d73-4d2e-4bb8-af48-a4e597811faa/session_b1cf14ce-00a9-48b6-8654-dadde26073f1/occlusion_3c4595e0-fbbb-4814-8851-1e014eb9a3b2/scan_dde349dc-caa1-49dc-8205-ba84c97567bf/46_w1_o1_mandibule_scan_file_2.zip','ZIP','PATIENT_9e399d73-4d2e-4bb8-af48-a4e597811faa_ACT_b1cf14ce-00a9-48b6-8654-dadde26073f1_SESS_3c4595e0-fbbb-4814-8851-1e014eb9a3b2_BOSC_dde349dc-caa1-49dc-8205-ba84c97567bf_ZIP_','2022-11-24 13:34:08','2022-11-24 14:34:00','46_w1_o1_mandibule_scan_file_2.zip','2022-11-24 14:34:08','SYNCED','1ab76985-608d-4f1d-ad18-01454909d344',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.46.1.1.6\",\"modelMatrix\":\"-0.781388,0.613261,-0.115515,0,-0.624045,-0.767885,0.14464,0,3.896e-09,0.185107,0.982718,0,20.8068,-10.6268,-17.296,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'c47f0341-13c6-4776-87a1-2fd20d6de1f6','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5/occlusion_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa/scan_569997ca-080a-44fb-9a38-e48cedabde17/24_w2_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_fcd6a92e-e91c-4367-9fc7-5919a6acfcb5_SESS_fe052e34-f4e8-4ee4-baa3-bd9d396de3fa_RISC_569997ca-080a-44fb-9a38-e48cedabde17_ZIP_','2022-10-06 14:32:32','2022-10-06 16:32:23','24_w2_o1_mordu_posterieur_droit_scan_file_0.zip','2022-10-06 16:32:32','SYNCED','c47f0341-13c6-4776-87a1-2fd20d6de1f6',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur droit 1.24.2.1.1\",\"modelMatrix\":\"0.91691,-0.222722,0.334487,0,0.254371,0.970138,-0.032408,0,-0.307894,0.0978427,0.941983,0,-3.31695,1.77755,-23.2937,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1001,'c4cc127a-8115-4a9f-867d-4b2c34cda777','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/98aa55d8-3848-48e0-9684-5597786b85c7/session_4df1e430-5cbb-4a6c-8292-747e35e6f1e8/occlusion_fcc5c65d-b0e4-4036-99c7-07318171986a/computedocclusion_f2517330-f76d-418d-8d59-e56eb543a090/66_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_98aa55d8-3848-48e0-9684-5597786b85c7_ACT_4df1e430-5cbb-4a6c-8292-747e35e6f1e8_SESS_fcc5c65d-b0e4-4036-99c7-07318171986a_OCC_f2517330-f76d-418d-8d59-e56eb543a090_BOMA__MATRX_','2023-04-13 10:07:20','2023-04-13 12:07:20','66_w1_o1_mandibule_matrix_occ_file_0.m',NULL,'CREATED','c4cc127a-8115-4a9f-867d-4b2c34cda777',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.66.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.66.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.66.1.1.1 Occlusion 1\"}'),(1001,'c4ff0a0b-2408-4188-9880-ebaa94ad910a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f6f52932-463d-4797-9974-ed4b8eb30a12/session_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9/occlusion_8cb97702-2ace-4345-9345-11d142b6c7b3/scan_48982add-ff93-4e3a-a453-012a73678b39/19_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_f6f52932-463d-4797-9974-ed4b8eb30a12_ACT_9b1d2a8e-c6de-4f5c-92c5-88005869d8e9_SESS_8cb97702-2ace-4345-9345-11d142b6c7b3_TOSC_48982add-ff93-4e3a-a453-012a73678b39_SNAPS_','2022-03-08 11:09:41','2022-03-08 12:05:21','19_w1_o1_maxillaire_snapshot_0.png','2022-03-08 12:09:41','SYNCED','c4ff0a0b-2408-4188-9880-ebaa94ad910a',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.19.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'c502efab-3bf8-4a22-9770-a0bafe543472','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/22c79f73-5e2c-4406-9e49-1a07f8ab0bc4/session_c0df7d9c-0cc6-48c6-8595-92335a500fe2/occlusion_e08bbeeb-a30b-428c-bd4a-40198f792219/scan_ef1d20c7-5f61-4c35-8f0f-d85507cab786/25_w1_o1_mandibule_snapshot_2.png','SNAPS','PATIENT_22c79f73-5e2c-4406-9e49-1a07f8ab0bc4_ACT_c0df7d9c-0cc6-48c6-8595-92335a500fe2_SESS_e08bbeeb-a30b-428c-bd4a-40198f792219_BOSC_ef1d20c7-5f61-4c35-8f0f-d85507cab786_SNAPS_','2022-05-17 16:16:07','2022-05-17 18:15:56','25_w1_o1_mandibule_snapshot_2.png','2022-05-17 18:16:07','SYNCED','135e8c27-bf0a-4d0f-b495-291e99638543',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.25.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'c5123228-55c5-43a0-9a9c-7d17bd8cb24d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f4fc00ec-4af8-4a15-b427-f1c5aabf6260/session_498ae60a-23f0-44fc-9730-be499bfc4b46/occlusion_8f3d6c73-3468-45a5-85c7-93bba47ec9f7/scan_60c1cc80-0d70-4511-8993-70e3a3c146b8/30_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_f4fc00ec-4af8-4a15-b427-f1c5aabf6260_ACT_498ae60a-23f0-44fc-9730-be499bfc4b46_SESS_8f3d6c73-3468-45a5-85c7-93bba47ec9f7_BOSC_60c1cc80-0d70-4511-8993-70e3a3c146b8_ZIP_','2022-06-14 13:16:26','2022-06-14 15:16:18','30_w1_o1_mandibule_scan_file_0.zip','2022-06-14 15:16:26','SYNCED','c5123228-55c5-43a0-9a9c-7d17bd8cb24d',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.30.1.1.1\",\"modelMatrix\":\"-0.0163336,0.974991,-0.221642,0,-0.999867,-0.0159273,0.0036207,0,-1.39559e-11,0.221671,0.975122,0,3.56533,-3.65104,-21.0782,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'c51cc335-f9b4-4a40-a708-fe3efb266be8','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/4a3954e0-1e2f-4721-9fdd-4180380dc19f/session_33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416/occlusion_3accbada-5a51-4d10-88d1-c3e7d8598d6f/scan_ca26b24d-fb66-43e1-8719-cc661811d143/34_w1_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_4a3954e0-1e2f-4721-9fdd-4180380dc19f_ACT_33ccdfc6-ac73-4b94-8fe6-1a7f95bd7416_SESS_3accbada-5a51-4d10-88d1-c3e7d8598d6f_BOSC_ca26b24d-fb66-43e1-8719-cc661811d143_ZIP_','2022-06-28 10:49:57','2022-06-28 12:49:36','34_w1_o1_mandibule_scan_file_0.zip','2022-06-28 12:49:57','SYNCED','c51cc335-f9b4-4a40-a708-fe3efb266be8',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.34.1.1.1\",\"modelMatrix\":\"0.234069,0.962585,-0.136536,0,-0.97222,0.231749,-0.0328721,0,9.44423e-10,0.140438,0.990089,0,-4.58165,-19.1006,-16.3325,1\",\"title\":\"Mandibule ZIP\"}'),(1001,'c528e035-d66a-4a5a-af0f-3f0a50b070e9','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/45ff7437-0691-4427-a7da-8250862e4b96/session_4ff9c682-c09d-42ff-8c29-aeb13e066ed2/occlusion_934673c1-a4b9-4508-ac1b-a03092a0693e/computedocclusion_161f60a4-d4f2-41f1-98ad-a8ccad84216c/9_w1_o1_mandibule_matrix_occ_file_0.m','MATRX','PATIENT_45ff7437-0691-4427-a7da-8250862e4b96_ACT_4ff9c682-c09d-42ff-8c29-aeb13e066ed2_SESS_934673c1-a4b9-4508-ac1b-a03092a0693e_OCC_161f60a4-d4f2-41f1-98ad-a8ccad84216c_BOMA__MATRX_','2022-01-24 19:55:58','2022-01-24 18:46:00','9_w1_o1_mandibule_matrix_occ_file_0.m','2022-01-24 20:55:58','SYNCED','c528e035-d66a-4a5a-af0f-3f0a50b070e9',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.9.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.9.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 1.9.1.1.1 Occlusion 1\"}'),(1001,'c58e0c5c-8de5-450c-92a2-c7f91466da07','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/5c3e71a4-b9b8-4f4d-b447-42654db92f32/session_bc96e41e-0457-4067-9d27-c4eaa1a505b3/occlusion_45c9b517-ce12-4983-bf97-4e6a7e7d04c3/scan_1c86378e-7d31-4b12-82ff-af797020160f/4_w1_o2_mandibule_snapshot_1.png','SNAPS','PATIENT_5c3e71a4-b9b8-4f4d-b447-42654db92f32_ACT_bc96e41e-0457-4067-9d27-c4eaa1a505b3_SESS_45c9b517-ce12-4983-bf97-4e6a7e7d04c3_BOSC_1c86378e-7d31-4b12-82ff-af797020160f_SNAPS_','2022-03-08 11:37:30','2022-03-08 12:37:20','4_w1_o2_mandibule_snapshot_1.png','2022-03-08 12:37:30','SYNCED','a13ef72a-3421-4e8c-a897-3f43da14e842',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.4.1.2.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'c5f7a167-7858-4b11-bca6-5afb7a8e1137','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/0c130e3d-4f69-4332-a7f5-f3765413e61c/session_21fafc95-3946-40ef-be71-2a5fab6db45c/occlusion_4411b66d-5c1e-4d60-80c4-ef2dcb56c598/computedocclusion_ce625ba7-4218-40af-b344-df718da13f83/54_w1_o1_maxillaire_occlusion_occ_file_2.zip','ZIP','PATIENT_0c130e3d-4f69-4332-a7f5-f3765413e61c_ACT_21fafc95-3946-40ef-be71-2a5fab6db45c_SESS_4411b66d-5c1e-4d60-80c4-ef2dcb56c598_OCC_ce625ba7-4218-40af-b344-df718da13f83_TOPLY__ZIP_','2023-03-15 10:17:28','2023-03-15 11:15:19','54_w1_o1_maxillaire_occlusion_occ_file_2.zip','2023-03-15 11:17:28','SYNCED','ad02dce8-3ff6-4167-add8-6925d6562d5e',2,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.54.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.78238,0.620977,-0.0476379,0,-0.622801,0.780088,-0.059844,0,1.97556e-09,0.0764897,0.99707,0,-23.5433,3.60536,-19.7037,1\",\"referenceScanID\":\"1.54.1.1.1\",\"title\":\"Maxillaire 1.54.1.1.1 Occlusion 1\"}'),(1001,'c60133f0-3c0f-4659-99d2-d1dd1ce7d65e','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/9e399d73-4d2e-4bb8-af48-a4e597811faa/session_b1cf14ce-00a9-48b6-8654-dadde26073f1/occlusion_3c4595e0-fbbb-4814-8851-1e014eb9a3b2/scan_f26fe3ea-6f4e-4010-a7f6-4757c6679e52/46_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_9e399d73-4d2e-4bb8-af48-a4e597811faa_ACT_b1cf14ce-00a9-48b6-8654-dadde26073f1_SESS_3c4595e0-fbbb-4814-8851-1e014eb9a3b2_BOSC_f26fe3ea-6f4e-4010-a7f6-4757c6679e52_SNAPS_','2022-10-27 11:45:59','2022-10-27 13:45:51','46_w1_o1_mandibule_snapshot_1.png','2022-10-27 13:45:59','SYNCED','1235c321-c4b0-4dda-93af-af7b0a1e20f9',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.46.1.1.5\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'c62a941d-41df-44aa-8e43-9114b0708bfe','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/021a268a-4571-414a-bbef-2ea30a0a7fed/session_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30/occlusion_e2704ec5-66c8-4d68-ae48-c92185628c8b/scan_93b9b214-5793-480a-b05f-e0419802faf3/12_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','ZIP','PATIENT_021a268a-4571-414a-bbef-2ea30a0a7fed_ACT_01b85cc7-ad9c-44db-a6c5-3f8d1493bb30_SESS_e2704ec5-66c8-4d68-ae48-c92185628c8b_LESC_93b9b214-5793-480a-b05f-e0419802faf3_ZIP_','2022-02-04 12:18:02','2022-02-04 13:17:21','12_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','2022-02-04 13:18:02','SYNCED','c62a941d-41df-44aa-8e43-9114b0708bfe',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mordu posterieur gauche 1.12.1.1.1\",\"modelMatrix\":\"-0.994934,0.10248,-0.000225791,0,-0.094588,-0.907034,0.405268,0,0.0347007,0.408441,0.914238,0,19.3653,-9.00903,-19.0684,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1001,'c641e31f-10c5-41ee-b89e-d22c41dd2e6a','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/1a8329eb-7dbc-4bfd-b669-6d92e13fec0c/session_11fb4259-c305-4a08-b750-536f769f44b0/occlusion_129468ab-1f43-4ba1-8939-49286128bf4d/scan_be01aaf8-9fe4-4356-a76d-15d6d39e3fe3/47_w1_o1_mandibule_snapshot_1.png','SNAPS','PATIENT_1a8329eb-7dbc-4bfd-b669-6d92e13fec0c_ACT_11fb4259-c305-4a08-b750-536f769f44b0_SESS_129468ab-1f43-4ba1-8939-49286128bf4d_BOSC_be01aaf8-9fe4-4356-a76d-15d6d39e3fe3_SNAPS_','2022-10-21 16:13:54','2022-10-21 18:13:46','47_w1_o1_mandibule_snapshot_1.png','2022-10-21 18:13:54','SYNCED','a517137b-b7a8-4943-9382-ebbdbf922a1e',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.47.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'c675f19c-ea90-43f3-977b-db1bed22b847','','MATRX','PATIENT_3fe29844-5082-4e50-a510-61af15cb5cba_ACT_dcedf77c-c664-46b3-91b3-902529b54810_SESS_b3ae2904-41ee-4eef-9639-bb150af1853a_OCC_d8bec5dc-8405-473d-9ba5-ae6e461ed6fd_BOMA__MATRX_','2022-02-07 11:15:31','2022-02-04 19:13:44','','2022-02-07 12:15:31','SYNCED','c675f19c-ea90-43f3-977b-db1bed22b847',0,'2022-02-07 12:15:31','bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.13.1.1.5 Occlusion 1\",\"referenceScanID\":\"1.13.1.1.5\",\"title\":\"Matrice Transfo. Mandibule 1.13.1.1.5 Occlusion 1\"}'),(1001,'c6a0ab44-7a00-4b6f-a666-47eee74159a8','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/f3295a8a-61a2-46d8-af67-c1d1e5901069/session_796aca94-b14e-4e17-bfc0-9f3f45ade8f3/occlusion_80f6d4c0-5dc8-445a-ad5f-281f022f1444/scan_16f04a07-72e8-4a39-9b55-3ae7405733af/24_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_f3295a8a-61a2-46d8-af67-c1d1e5901069_ACT_796aca94-b14e-4e17-bfc0-9f3f45ade8f3_SESS_80f6d4c0-5dc8-445a-ad5f-281f022f1444_TOSC_16f04a07-72e8-4a39-9b55-3ae7405733af_SNAPS_','2022-06-13 14:42:43','2022-06-13 16:42:29','24_w1_o1_maxillaire_snapshot_1.png','2022-06-13 16:42:43','SYNCED','ace017e9-ff30-403f-aee6-3daa66025d8d',1,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Maxillaire 1.24.1.1.4\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1001,'c6a41fad-c98c-41bb-86d1-7cc292203d86','/var/.data/2023/bf33766c-f63b-45f7-847c-6feda618051b/4fa1a134-d246-43d7-aa8c-b42e24b62b49/session_6aedf6fd-46d7-4259-88ba-5cf074ad5913/occlusion_47192ebb-25b6-4c9e-a09f-8ed295e60a87/scan_08beae91-887f-4723-8e18-ef9fee36100e/60_w1_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_4fa1a134-d246-43d7-aa8c-b42e24b62b49_ACT_6aedf6fd-46d7-4259-88ba-5cf074ad5913_SESS_47192ebb-25b6-4c9e-a09f-8ed295e60a87_BOSC_08beae91-887f-4723-8e18-ef9fee36100e_SNAPS_','2023-03-07 18:07:01','2023-03-07 19:06:47','60_w1_o1_mandibule_snapshot_0.png','2023-03-07 19:07:01','SYNCED','c6a41fad-c98c-41bb-86d1-7cc292203d86',0,NULL,'bf33766c-f63b-45f7-847c-6feda618051b','bf33766c-f63b-45f7-847c-6feda618051b','{\"displayTitle\":\"Mandibule 1.60.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1001,'c6a6cc47-17e5-4709-a61d-687818334a3d','/var/.data/2022/bf33766c-f63b-45f7-847c-6feda618051b/1c189ddc-0ee7-45e7-9d80-585dac08374a/session_01bd0635-6ec6-42cb-8561-8638bded352c/occlusion_2aa712ca-8b46-4a50-a03e-1c6a6a0c40fc/computedocclusion_727485e0-8637-4024-83d8-95544991f73f/29_w1_o1_mandibule_occlusion_occ_file_0.zip','ZIP','PATIENT_1c189ddc-0ee7-45e7-9d80-585dac08374a_ACT_01bd0635-6ec6-42cb-8561-8638bded352c_SESS_2aa712ca-8b46-4a50-a03e-1c6a6a0c40fc_OCC_727485e0-8637-4024-83d8-95544991f73f_BOPLY__ZIP_','2022-06-03 14:07:08','2022-06-03 16:07:00','29_w1_o1_mandibule_occlusion_occ_file_0.zip','2022-06-03 16:07:08'