-- MySQL dump 10.13  Distrib 8.0.27, for Linux (x86_64)
--
-- Host: localhost    Database: condor
-- ------------------------------------------------------
-- Server version	8.0.27-0ubuntu0.20.04.1

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `Act`
--

DROP TABLE IF EXISTS `Act`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Act` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `title` varchar(64) DEFAULT NULL,
  `dateCreated` datetime DEFAULT NULL,
  `comments` mediumtext,
  `globalDisplayID` mediumint unsigned DEFAULT NULL,
  `displayID` mediumint unsigned DEFAULT NULL,
  `patientID` char(36) NOT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastAccessed` datetime NOT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Work_Patient` (`patientID`,`ownerID`),
  CONSTRAINT `fk_Act_Patient` FOREIGN KEY (`patientID`) REFERENCES `condor_patient_local`.`Patient` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Act`
--

LOCK TABLES `Act` WRITE;
/*!40000 ALTER TABLE `Act` DISABLE KEYS */;
/*!40000 ALTER TABLE `Act` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AddressInfo`
--

DROP TABLE IF EXISTS `AddressInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AddressInfo` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `line_0` varchar(255) DEFAULT NULL,
  `line_1` varchar(255) DEFAULT NULL,
  `line_2` varchar(255) DEFAULT NULL,
  `detail` varchar(255) DEFAULT NULL,
  `cityName` varchar(255) DEFAULT NULL,
  `cityState` varchar(255) DEFAULT NULL,
  `cityZip` varchar(25) DEFAULT NULL,
  `countryName` varchar(255) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_AddressInfo_Professional` (`ownerID`),
  CONSTRAINT `fk_AddressInfo_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AddressInfo`
--

LOCK TABLES `AddressInfo` WRITE;
/*!40000 ALTER TABLE `AddressInfo` DISABLE KEYS */;
/*!40000 ALTER TABLE `AddressInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Assistant`
--

DROP TABLE IF EXISTS `Assistant`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Assistant` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `patientRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'READ_ONLY',
  `actRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'READ_ONLY',
  `discussionRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'READ_ONLY',
  `credentialsID` mediumint unsigned DEFAULT NULL,
  `personInfoID` mediumint unsigned DEFAULT NULL,
  `phoneInfoID` mediumint unsigned DEFAULT NULL,
  `addressInfoID` mediumint unsigned DEFAULT NULL,
  `officeID` char(36) DEFAULT NULL,
  `tempPassword` varchar(32) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `lastConnection` timestamp NULL DEFAULT NULL,
  `firstConnection` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Assistant_Professional` (`ownerID`),
  KEY `fk_Assistant_Credentials` (`credentialsID`,`ownerID`),
  KEY `fk_Assistant_PersonInfo` (`personInfoID`,`ownerID`),
  KEY `fk_Assistant_PhoneInfo` (`phoneInfoID`,`ownerID`),
  KEY `fk_Assistant_AddressInfo` (`addressInfoID`,`ownerID`),
  KEY `fk_Assistant_Office` (`officeID`,`ownerID`),
  CONSTRAINT `fk_Assistant_AddressInfo` FOREIGN KEY (`addressInfoID`, `ownerID`) REFERENCES `AddressInfo` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Assistant_Credentials` FOREIGN KEY (`credentialsID`, `ownerID`) REFERENCES `Credentials` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Assistant_Office` FOREIGN KEY (`officeID`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Assistant_PersonInfo` FOREIGN KEY (`personInfoID`, `ownerID`) REFERENCES `PersonInfo` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Assistant_PhoneInfo` FOREIGN KEY (`phoneInfoID`, `ownerID`) REFERENCES `PhoneInfo` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Assistant_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Assistant`
--

LOCK TABLES `Assistant` WRITE;
/*!40000 ALTER TABLE `Assistant` DISABLE KEYS */;
/*!40000 ALTER TABLE `Assistant` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `Assistant_AFTER_DELETE` AFTER DELETE ON `Assistant` FOR EACH ROW BEGIN
	DELETE FROM PersonInfo  WHERE ownerID = OLD.ownerID AND id = OLD.personInfoID;
	DELETE FROM AddressInfo WHERE ownerID = OLD.ownerID AND id = OLD.addressInfoID;
	DELETE FROM PhoneInfo   WHERE ownerID = OLD.ownerID AND id = OLD.phoneInfoID;
	DELETE FROM Credentials WHERE ownerID = OLD.ownerID AND id = OLD.credentialsID;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `CircleOrder`
--

DROP TABLE IF EXISTS `CircleOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CircleOrder` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `actID` char(36) NOT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `title` varchar(64) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `status` enum('not_sent','waiting_wow_api','sending_wow_api','sending_circle_api','sent','cancelled') NOT NULL DEFAULT 'waiting_wow_api',
  `createdAt` datetime NOT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `json` text NOT NULL,
  `metadata` text NOT NULL,
  `localDisplayID` int unsigned DEFAULT NULL,
  `globalDisplayID` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_CircleOrder_Act` (`actID`,`ownerID`),
  CONSTRAINT `fk_CircleOrder_Act` FOREIGN KEY (`actID`, `ownerID`) REFERENCES `Act` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CircleOrder`
--

LOCK TABLES `CircleOrder` WRITE;
/*!40000 ALTER TABLE `CircleOrder` DISABLE KEYS */;
/*!40000 ALTER TABLE `CircleOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CircleOrderFile`
--

DROP TABLE IF EXISTS `CircleOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CircleOrderFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `orderID` char(36) NOT NULL,
  `fileID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`orderID`,`fileID`),
  KEY `fk_CircleOrderFile_CircleOrder` (`orderID`,`ownerID`),
  KEY `fk_CircleOrderFile_CondorFile` (`fileID`,`ownerID`),
  CONSTRAINT `fk_CircleOrderFile_CircleOrder` FOREIGN KEY (`orderID`, `ownerID`) REFERENCES `CircleOrder` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_CircleOrderFile_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CircleOrderFile`
--

LOCK TABLES `CircleOrderFile` WRITE;
/*!40000 ALTER TABLE `CircleOrderFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `CircleOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CondorFile`
--

DROP TABLE IF EXISTS `CondorFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CondorFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `path` text NOT NULL,
  `type` varchar(250) NOT NULL,
  `tag` varchar(250) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `originalName` varchar(100) DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `status` enum('CREATED','UPDATED','SYNCED','ERROR') DEFAULT NULL,
  `originalID` char(36) NOT NULL,
  `version` mediumint NOT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `metadata` text,
  PRIMARY KEY (`id`,`ownerID`),
  UNIQUE KEY `un_CondorFile_version` (`ownerID`,`originalID`,`version`),
  KEY `fk_CondorFile_Professional` (`ownerID`),
  KEY `fk_CondorFile_CondorFile` (`originalID`,`ownerID`),
  CONSTRAINT `fk_CondorFile_CondorFile` FOREIGN KEY (`originalID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_CondorFile_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CondorFile`
--

LOCK TABLES `CondorFile` WRITE;
/*!40000 ALTER TABLE `CondorFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `CondorFile` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `CondorFile_BEFORE_DELETE` BEFORE DELETE ON `CondorFile` FOR EACH ROW BEGIN
  UPDATE Session SET mandibuleOcclusionPlyID = NULL
  WHERE ownerID = OLD.ownerID AND mandibuleOcclusionPlyID = OLD.id;

  UPDATE Session SET mandibuleOcclusionStlID = NULL
  WHERE ownerID = OLD.ownerID AND mandibuleOcclusionStlID = OLD.id;

  UPDATE Session SET maxillaireOcclusionPlyID = NULL
  WHERE ownerID = OLD.ownerID AND maxillaireOcclusionPlyID = OLD.id;

  UPDATE Session SET maxillaireOcclusionStlID = NULL
  WHERE ownerID = OLD.ownerID AND maxillaireOcclusionStlID = OLD.id;

  UPDATE Session SET mandibuleOcclusionPointContactID = NULL
  WHERE ownerID = OLD.ownerID AND mandibuleOcclusionPointContactID = OLD.id;

  UPDATE Session SET maxillaireOcclusionPointContactID = NULL
  WHERE ownerID = OLD.ownerID AND maxillaireOcclusionPointContactID = OLD.id;

  UPDATE Session SET matrixTransformationMandibuleID = NULL
  WHERE ownerID = OLD.ownerID AND matrixTransformationMandibuleID = OLD.id;

  UPDATE Session SET matrixTransformationMaxillaireID = NULL
  WHERE ownerID = OLD.ownerID AND matrixTransformationMaxillaireID = OLD.id;

  UPDATE Session SET snapshotID = NULL
  WHERE ownerID = OLD.ownerID AND snapshotID = OLD.id;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `Config`
--

DROP TABLE IF EXISTS `Config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Config` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `fullRetrieve` tinyint(1) DEFAULT '0',
  `syncEnabled` tinyint(1) DEFAULT '1',
  `showOcclusionScan` tinyint(1) DEFAULT '1',
  `showOpenStlWarning` tinyint(1) DEFAULT '1',
  `showMarginLinesWarning` tinyint(1) DEFAULT '1',
  `showDeleteConfirmation` tinyint(1) DEFAULT '1',
  `showSyncInfo` tinyint(1) DEFAULT '1',
  `downloadAtFullRetrieve` tinyint(1) DEFAULT '1',
  `lagSound` tinyint(1) DEFAULT '0',
  `lostSound` tinyint(1) DEFAULT '0',
  `emailNotifications` tinyint(1) DEFAULT '1',
  `logout` mediumint DEFAULT '10',
  `language` varchar(2) DEFAULT NULL,
  `flipMaxillaryH` tinyint(1) DEFAULT '0',
  `flipMaxillaryV` tinyint(1) DEFAULT '0',
  `flipMandibleH` tinyint(1) DEFAULT '0',
  `flipMandibleV` tinyint(1) DEFAULT '0',
  `showFlipPopupMaxillary` tinyint(1) DEFAULT '1',
  `showFlipPopupMandible` tinyint(1) DEFAULT '1',
  `enableUserSharing` tinyint(1) DEFAULT '1',
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `diagnosticMode` tinyint(1) DEFAULT '0',
  `repairMode` tinyint(1) DEFAULT '0',
  `lostTrackingRectangle` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Config_Professional` (`ownerID`),
  CONSTRAINT `fk_Config_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Config`
--

LOCK TABLES `Config` WRITE;
/*!40000 ALTER TABLE `Config` DISABLE KEYS */;
/*!40000 ALTER TABLE `Config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Contact`
--

DROP TABLE IF EXISTS `Contact`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Contact` (
  `ownerID` mediumint unsigned NOT NULL DEFAULT '0',
  `id` char(36) NOT NULL,
  `comments` text,
  `professionalID` mediumint unsigned NOT NULL,
  `officeID` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `status` enum('invitationSent','invitationReceived','accepted','rejected') DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  UNIQUE KEY `unique_contact_pro` (`ownerID`,`professionalID`),
  KEY `fk_Contact_Professionnal` (`ownerID`),
  KEY `fk_Contact_RefersTo` (`professionalID`),
  KEY `fk_Contact_Office` (`officeID`,`ownerID`),
  CONSTRAINT `fk_Contact_Office` FOREIGN KEY (`officeID`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Contact_Professionnal` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Contact_RefersTo` FOREIGN KEY (`professionalID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Contact`
--

LOCK TABLES `Contact` WRITE;
/*!40000 ALTER TABLE `Contact` DISABLE KEYS */;
/*!40000 ALTER TABLE `Contact` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ContactNotification`
--

DROP TABLE IF EXISTS `ContactNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ContactNotification` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `contactID` char(36) DEFAULT NULL,
  `rescueDisplayName` varchar(50) DEFAULT NULL,
  `event` enum('received','received_to_accepted','received_to_rejected','sent_to_accepted','sent_to_rejected','activation_timeout') NOT NULL DEFAULT 'received',
  `unread` tinyint(1) NOT NULL DEFAULT '1',
  `createdAt` datetime NOT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_ContactNotification_Professional` (`ownerID`),
  KEY `fk_ContactNotification_Contact` (`contactID`,`ownerID`),
  CONSTRAINT `fk_ContactNotification_Contact` FOREIGN KEY (`contactID`, `ownerID`) REFERENCES `Contact` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_ContactNotification_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ContactNotification`
--

LOCK TABLES `ContactNotification` WRITE;
/*!40000 ALTER TABLE `ContactNotification` DISABLE KEYS */;
/*!40000 ALTER TABLE `ContactNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Credentials`
--

DROP TABLE IF EXISTS `Credentials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Credentials` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` mediumint unsigned NOT NULL,
  `login` varchar(64) NOT NULL,
  `password` varchar(1024) NOT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`ownerID`),
  UNIQUE KEY `un_Login` (`login`),
  KEY `fk_Credentials_Professional` (`ownerID`),
  CONSTRAINT `fk_Credentials_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Credentials`
--

LOCK TABLES `Credentials` WRITE;
/*!40000 ALTER TABLE `Credentials` DISABLE KEYS */;
/*!40000 ALTER TABLE `Credentials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Discussion`
--

DROP TABLE IF EXISTS `Discussion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Discussion` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `selfImplied` tinyint(1) NOT NULL DEFAULT '0',
  `officeID` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Discussion_Professional` (`ownerID`),
  KEY `fk_Discussion_Office` (`officeID`,`ownerID`),
  CONSTRAINT `fk_Discussion_Office` FOREIGN KEY (`officeID`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Discussion_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Discussion`
--

LOCK TABLES `Discussion` WRITE;
/*!40000 ALTER TABLE `Discussion` DISABLE KEYS */;
/*!40000 ALTER TABLE `Discussion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Licence`
--

DROP TABLE IF EXISTS `Licence`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Licence` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `reference` varchar(45) DEFAULT NULL,
  `installKey` varchar(45) DEFAULT NULL,
  `activationDate` datetime DEFAULT NULL,
  `professionalID` mediumint unsigned NOT NULL,
  `cameraReference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`,`professionalID`),
  KEY `fk_Licence_Professional` (`professionalID`),
  CONSTRAINT `fk_Licence_Professional` FOREIGN KEY (`professionalID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Licence`
--

LOCK TABLES `Licence` WRITE;
/*!40000 ALTER TABLE `Licence` DISABLE KEYS */;
/*!40000 ALTER TABLE `Licence` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `MessageStatus`
--

DROP TABLE IF EXISTS `MessageStatus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `MessageStatus` (
  `ownerID` mediumint unsigned NOT NULL,
  `sentMessageID` char(36) NOT NULL,
  `contactID` char(36) NOT NULL,
  `status` enum('undelivered','delivered','transmitted') NOT NULL DEFAULT 'undelivered',
  `bcc` tinyint(1) NOT NULL DEFAULT '0',
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`sentMessageID`,`contactID`),
  KEY `fk_MessageStatus_SentMessage` (`sentMessageID`,`ownerID`),
  KEY `fk_MessageStatus_Contact` (`contactID`,`ownerID`),
  CONSTRAINT `fk_MessageStatus_Contact` FOREIGN KEY (`contactID`, `ownerID`) REFERENCES `Contact` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_MessageStatus_SentMessage` FOREIGN KEY (`sentMessageID`, `ownerID`) REFERENCES `SentMessage` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `MessageStatus`
--

LOCK TABLES `MessageStatus` WRITE;
/*!40000 ALTER TABLE `MessageStatus` DISABLE KEYS */;
/*!40000 ALTER TABLE `MessageStatus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Occlusion`
--

DROP TABLE IF EXISTS `Occlusion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Occlusion` (
  `ownerID` mediumint unsigned NOT NULL DEFAULT '0',
  `id` char(36) NOT NULL,
  `sessionID` char(36) DEFAULT NULL,
  `occlusionType` enum('UNKNOWN','HEMI_ARCADE_POSTERIEUR_DROIT','HEMI_ARCADE_POSTERIEUR_GAUCHE','HEMI_ARCADE_ANTERIEUR','ARCADE_COMPLETE_ANTERIEUR','ARCADE_COMPLETE') DEFAULT 'HEMI_ARCADE_POSTERIEUR_DROIT',
  `deletedAt` datetime DEFAULT NULL,
  `createdAt` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `topScanID` char(36) DEFAULT NULL,
  `bottomScanID` char(36) DEFAULT NULL,
  `anteriorBiteScanID` char(36) DEFAULT NULL,
  `rightBiteScanID` char(36) DEFAULT NULL,
  `leftBiteScanID` char(36) DEFAULT NULL,
  `snapshotID` char(36) DEFAULT NULL,
  `mandibuleOcclusionPlyID` char(36) DEFAULT NULL,
  `maxillaireOcclusionPlyID` char(36) DEFAULT NULL,
  `matrixTransformationMandibuleID` char(36) DEFAULT NULL,
  `matrixTransformationMaxillaireID` char(36) DEFAULT NULL,
  `globalDisplayID` mediumint unsigned DEFAULT NULL,
  `displayID` mediumint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Occlusion_Session` (`sessionID`,`ownerID`),
  KEY `fk_Occlusion_topScan` (`topScanID`,`ownerID`),
  KEY `fk_Occlusion_bottomScan` (`bottomScanID`,`ownerID`),
  KEY `fk_Occlusion_anteriorBiteScanID` (`anteriorBiteScanID`,`ownerID`),
  KEY `fk_Occlusion_rightBiteScanID` (`rightBiteScanID`,`ownerID`),
  KEY `fk_Occlusion_leftBiteScanID` (`leftBiteScanID`,`ownerID`),
  KEY `fk_Occlusion_CondorFile_snapshot` (`snapshotID`,`ownerID`),
  KEY `fk_Occlusion_CondorFile_mandibulePly` (`mandibuleOcclusionPlyID`,`ownerID`),
  KEY `fk_Occlusion_CondorFile_matrixTransformationMandibule` (`matrixTransformationMandibuleID`,`ownerID`),
  KEY `fk_Occlusion_CondorFile_maxillairePly` (`maxillaireOcclusionPlyID`,`ownerID`),
  KEY `fk_Occlusion_CondorFile_matrixTransformationMaxillaire` (`matrixTransformationMaxillaireID`,`ownerID`),
  CONSTRAINT `fk_Occlusion_anteriorBiteScanID` FOREIGN KEY (`anteriorBiteScanID`, `ownerID`) REFERENCES `Scan` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_bottomScan` FOREIGN KEY (`bottomScanID`, `ownerID`) REFERENCES `Scan` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_CondorFile_mandibulePly` FOREIGN KEY (`mandibuleOcclusionPlyID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_CondorFile_matrixTransformationMandibule` FOREIGN KEY (`matrixTransformationMandibuleID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_CondorFile_matrixTransformationMaxillaire` FOREIGN KEY (`matrixTransformationMaxillaireID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_CondorFile_maxillairePly` FOREIGN KEY (`maxillaireOcclusionPlyID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_CondorFile_snapshot` FOREIGN KEY (`snapshotID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_leftBiteScanID` FOREIGN KEY (`leftBiteScanID`, `ownerID`) REFERENCES `Scan` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_rightBiteScanID` FOREIGN KEY (`rightBiteScanID`, `ownerID`) REFERENCES `Scan` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_Session` FOREIGN KEY (`sessionID`, `ownerID`) REFERENCES `Session` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_topScan` FOREIGN KEY (`topScanID`, `ownerID`) REFERENCES `Scan` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Occlusion`
--

LOCK TABLES `Occlusion` WRITE;
/*!40000 ALTER TABLE `Occlusion` DISABLE KEYS */;
/*!40000 ALTER TABLE `Occlusion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `OcclusionFile`
--

DROP TABLE IF EXISTS `OcclusionFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `OcclusionFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `fileID` char(36) NOT NULL,
  `occlusionID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `occlusionType` enum('OCCLUSION_RESULT','MANDIBULE_PLY','MAXILLAIRE_PLY','LEFT_BITE','RIGHT_BITE','ANTERIOR_BITE','SCREENSHOT','LIFI','MANDIBULE_MATRIX','MAXILLAIRE_MATRIX') DEFAULT 'OCCLUSION_RESULT',
  PRIMARY KEY (`fileID`,`occlusionID`,`ownerID`),
  KEY `fk_OcclusionFile_CondorFile` (`fileID`,`ownerID`),
  KEY `fk_OcclusionFile_Occlusion` (`occlusionID`,`ownerID`),
  CONSTRAINT `fk_OcclusionFile_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_OcclusionFile_Occlusion` FOREIGN KEY (`occlusionID`, `ownerID`) REFERENCES `Occlusion` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `OcclusionFile`
--

LOCK TABLES `OcclusionFile` WRITE;
/*!40000 ALTER TABLE `OcclusionFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `OcclusionFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Office`
--

DROP TABLE IF EXISTS `Office`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Office` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `mainPhone` varchar(45) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `cityName` varchar(255) DEFAULT NULL,
  `cityZip` varchar(25) DEFAULT NULL,
  `address` text,
  `country` varchar(75) DEFAULT NULL,
  `reassignedTo` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Office_Professional_idx` (`ownerID`),
  KEY `fk_Office_Office_reassignedTo` (`reassignedTo`,`ownerID`),
  CONSTRAINT `fk_Office_Office_reassignedTo` FOREIGN KEY (`reassignedTo`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Office_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Office`
--

LOCK TABLES `Office` WRITE;
/*!40000 ALTER TABLE `Office` DISABLE KEYS */;
/*!40000 ALTER TABLE `Office` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `Office_BEFORE_DELETE` BEFORE DELETE ON `Office` FOR EACH ROW BEGIN		
  UPDATE Assistant SET officeID = NULL 
  WHERE ownerID = OLD.ownerID AND officeID = OLD.id;

  UPDATE Contact SET officeID = NULL 
  WHERE ownerID = OLD.ownerID AND officeID = OLD.id;

  UPDATE Discussion SET officeID = NULL 
  WHERE ownerID = OLD.ownerID AND officeID = OLD.id;

  UPDATE Patient SET officeID = NULL 
  WHERE ownerID = OLD.ownerID AND officeID = OLD.id;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `PersonInfo`
--

DROP TABLE IF EXISTS `PersonInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PersonInfo` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `firstName` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `sex` enum('M','F') DEFAULT NULL,
  `birthDate` date DEFAULT NULL,
  `salutation` varchar(45) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `picturePath` varchar(255) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_PersonInfo_Professional` (`ownerID`),
  CONSTRAINT `fk_PersonInfo_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PersonInfo`
--

LOCK TABLES `PersonInfo` WRITE;
/*!40000 ALTER TABLE `PersonInfo` DISABLE KEYS */;
/*!40000 ALTER TABLE `PersonInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PhoneInfo`
--

DROP TABLE IF EXISTS `PhoneInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PhoneInfo` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `mainPhone` varchar(45) DEFAULT NULL,
  `cellular` varchar(45) DEFAULT NULL,
  `fax` varchar(45) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_PhoneInfo_Professional` (`ownerID`),
  CONSTRAINT `fk_PhoneInfo_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PhoneInfo`
--

LOCK TABLES `PhoneInfo` WRITE;
/*!40000 ALTER TABLE `PhoneInfo` DISABLE KEYS */;
/*!40000 ALTER TABLE `PhoneInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Professional`
--

DROP TABLE IF EXISTS `Professional`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Professional` (
  `id` mediumint unsigned NOT NULL,
  `UUID` char(36) NOT NULL,
  `credentialsID` mediumint unsigned DEFAULT NULL,
  `comments` text,
  `status` enum('created','confirmed') NOT NULL DEFAULT 'created',
  `accessCode` varchar(45) DEFAULT NULL,
  `personInfoID` mediumint unsigned DEFAULT NULL,
  `phoneInfoID` mediumint unsigned DEFAULT NULL,
  `addressInfoID` mediumint unsigned DEFAULT NULL,
  `configID` mediumint unsigned DEFAULT NULL,
  `syncInfoID` mediumint unsigned DEFAULT NULL,
  `surgeryName` varchar(255) DEFAULT NULL,
  `type` enum('Undefined','Prothesist','Dentist','Demo','Other') NOT NULL DEFAULT 'Undefined',
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastConnection` timestamp NULL DEFAULT NULL,
  `lastConnectionChecked` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `limitedContactID` char(36) DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `directoryVisible` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `fk_Professional_Credentials` (`credentialsID`,`id`),
  KEY `fk_Professional_PersonInfo` (`personInfoID`,`id`),
  KEY `fk_Professional_PhoneInfo` (`phoneInfoID`,`id`),
  KEY `fk_Professional_AddressInfo` (`addressInfoID`,`id`),
  KEY `fk_Professional_Config` (`configID`,`id`),
  KEY `fk_Professional_SyncInfo` (`syncInfoID`,`id`),
  CONSTRAINT `fk_Professional_AddressInfo` FOREIGN KEY (`addressInfoID`, `id`) REFERENCES `AddressInfo` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Professional_Config` FOREIGN KEY (`configID`, `id`) REFERENCES `Config` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Professional_Credentials` FOREIGN KEY (`credentialsID`, `id`) REFERENCES `Credentials` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Professional_PersonInfo` FOREIGN KEY (`personInfoID`, `id`) REFERENCES `PersonInfo` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Professional_PhoneInfo` FOREIGN KEY (`phoneInfoID`, `id`) REFERENCES `PhoneInfo` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Professional_SyncInfo` FOREIGN KEY (`syncInfoID`, `id`) REFERENCES `SyncInfo` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Professional`
--

LOCK TABLES `Professional` WRITE;
/*!40000 ALTER TABLE `Professional` DISABLE KEYS */;
/*!40000 ALTER TABLE `Professional` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProfessionalPatient`
--

DROP TABLE IF EXISTS `ProfessionalPatient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProfessionalPatient` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `ownerID` mediumint unsigned NOT NULL DEFAULT '0',
  `patientID` char(36) DEFAULT NULL,
  `officeID` char(36) DEFAULT NULL,
  `enablePatientSharing` tinyint(1) DEFAULT '0',
  `pinned` tinyint(1) NOT NULL DEFAULT '0',
  `theme` enum('NONE','ADULT','BOY','GIRL','BABY') DEFAULT 'NONE',
  PRIMARY KEY (`id`),
  KEY `unique_Patient_Pro` (`ownerID`,`patientID`),
  CONSTRAINT `fk_Patient_Pro` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProfessionalPatient`
--

LOCK TABLES `ProfessionalPatient` WRITE;
/*!40000 ALTER TABLE `ProfessionalPatient` DISABLE KEYS */;
/*!40000 ALTER TABLE `ProfessionalPatient` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrder`
--

DROP TABLE IF EXISTS `ProstheticOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticOrder` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `currentDeliveryDate` datetime DEFAULT NULL,
  `previousDeliveryDate` datetime DEFAULT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `title` varchar(64) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `status` enum('not_sent','sent','date_validated','date_edited','validated','cancelled') NOT NULL DEFAULT 'sent',
  `unread` tinyint(1) DEFAULT '0',
  `createdAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `actID` char(36) NOT NULL,
  `localDisplayID` mediumint unsigned DEFAULT NULL,
  `globalDisplayID` mediumint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `idx_Order_Work` (`ownerID`),
  KEY `fk_Order_Act` (`actID`,`ownerID`),
  CONSTRAINT `fk_Order_Act` FOREIGN KEY (`actID`, `ownerID`) REFERENCES `Act` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrder`
--

LOCK TABLES `ProstheticOrder` WRITE;
/*!40000 ALTER TABLE `ProstheticOrder` DISABLE KEYS */;
/*!40000 ALTER TABLE `ProstheticOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrderFile`
--

DROP TABLE IF EXISTS `ProstheticOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticOrderFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `orderID` char(36) NOT NULL,
  `fileID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`orderID`,`fileID`),
  KEY `fk_ProstheticOrderFile_ProstheticOrder` (`orderID`,`ownerID`),
  KEY `fk_ProstheticOrderFile_CondorFile` (`fileID`,`ownerID`),
  CONSTRAINT `fk_ProstheticOrderFile_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_ProstheticOrderFile_ProstheticOrder` FOREIGN KEY (`orderID`, `ownerID`) REFERENCES `ProstheticOrder` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrderFile`
--

LOCK TABLES `ProstheticOrderFile` WRITE;
/*!40000 ALTER TABLE `ProstheticOrderFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `ProstheticOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrderRecipient`
--

DROP TABLE IF EXISTS `ProstheticOrderRecipient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticOrderRecipient` (
  `ownerID` mediumint unsigned NOT NULL,
  `orderID` char(36) NOT NULL,
  `recipientID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`orderID`,`recipientID`),
  KEY `fk_ProstheticOrderRecipient_ProstheticOrder` (`orderID`,`ownerID`),
  KEY `fk_ProstheticOrderRecipient_Contact` (`recipientID`,`ownerID`),
  CONSTRAINT `fk_ProstheticOrderRecipient_Contact` FOREIGN KEY (`recipientID`, `ownerID`) REFERENCES `Contact` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_ProstheticOrderRecipient_ProstheticOrder` FOREIGN KEY (`orderID`, `ownerID`) REFERENCES `ProstheticOrder` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrderRecipient`
--

LOCK TABLES `ProstheticOrderRecipient` WRITE;
/*!40000 ALTER TABLE `ProstheticOrderRecipient` DISABLE KEYS */;
/*!40000 ALTER TABLE `ProstheticOrderRecipient` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticSheet`
--

DROP TABLE IF EXISTS `ProstheticSheet`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticSheet` (
  `id` char(36) NOT NULL,
  `ownerID` mediumint unsigned NOT NULL,
  `orderID` char(36) NOT NULL,
  `json` text NOT NULL,
  `pdfFileID` char(36) DEFAULT NULL,
  `dateCreated` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_ProstheticSheet_ProstheticOrder` (`orderID`),
  KEY `fk_ProstheticSheet_CondorFile` (`pdfFileID`),
  CONSTRAINT `fk_ProstheticSheet_CondorFile` FOREIGN KEY (`pdfFileID`) REFERENCES `CondorFile` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_ProstheticSheet_ProstheticOrder` FOREIGN KEY (`orderID`) REFERENCES `ProstheticOrder` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticSheet`
--

LOCK TABLES `ProstheticSheet` WRITE;
/*!40000 ALTER TABLE `ProstheticSheet` DISABLE KEYS */;
/*!40000 ALTER TABLE `ProstheticSheet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ReceivedAttachment`
--

DROP TABLE IF EXISTS `ReceivedAttachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ReceivedAttachment` (
  `ownerID` mediumint unsigned NOT NULL,
  `receivedMessageID` char(36) NOT NULL,
  `fileID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`fileID`,`receivedMessageID`),
  KEY `fk_ReceivedAttachment_ReceivedMessage` (`receivedMessageID`,`ownerID`),
  KEY `fk_ReceivedAttachment_CondorFile` (`fileID`,`ownerID`),
  CONSTRAINT `fk_ReceivedAttachment_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_ReceivedAttachment_ReceivedMessage` FOREIGN KEY (`receivedMessageID`, `ownerID`) REFERENCES `ReceivedMessage` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ReceivedAttachment`
--

LOCK TABLES `ReceivedAttachment` WRITE;
/*!40000 ALTER TABLE `ReceivedAttachment` DISABLE KEYS */;
/*!40000 ALTER TABLE `ReceivedAttachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ReceivedMessage`
--

DROP TABLE IF EXISTS `ReceivedMessage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ReceivedMessage` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `created` datetime DEFAULT NULL,
  `messageTransmitted` tinyint(1) NOT NULL DEFAULT '0',
  `messageSubject` varchar(45) NOT NULL,
  `body` text,
  `fromID` mediumint unsigned NOT NULL,
  `originMessageID` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `discussionID` char(36) NOT NULL,
  `readStatus` enum('Read','Unread') DEFAULT 'Unread',
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_ReceivedMessage_Discussion` (`discussionID`,`ownerID`),
  CONSTRAINT `fk_ReceivedMessage_Discussion` FOREIGN KEY (`discussionID`, `ownerID`) REFERENCES `Discussion` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ReceivedMessage`
--

LOCK TABLES `ReceivedMessage` WRITE;
/*!40000 ALTER TABLE `ReceivedMessage` DISABLE KEYS */;
/*!40000 ALTER TABLE `ReceivedMessage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Scan`
--

DROP TABLE IF EXISTS `Scan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Scan` (
  `ownerID` mediumint unsigned NOT NULL DEFAULT '0',
  `id` char(36) NOT NULL,
  `scanType` enum('MAXILLAIRE','MANDIBULE','MORDU_ANTERIEUR','MORDU_POSTERIEUR_GAUCHE','MORDU_POSTERIEUR_DROIT') DEFAULT 'MAXILLAIRE',
  `comments` mediumtext,
  `cameraX` decimal(10,0) DEFAULT NULL,
  `cameraY` decimal(10,0) DEFAULT NULL,
  `cameraZ` decimal(10,0) DEFAULT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `validated` tinyint(1) NOT NULL DEFAULT '0',
  `status` enum('in_progress','none') NOT NULL DEFAULT 'in_progress',
  `dateCreated` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `sessionID` char(36) DEFAULT NULL,
  `displayID` mediumint unsigned DEFAULT NULL,
  `globalDisplayID` mediumint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Scan_Work` (`ownerID`),
  KEY `fk_Scan_Session` (`sessionID`,`ownerID`),
  CONSTRAINT `fk_Scan_Session` FOREIGN KEY (`sessionID`, `ownerID`) REFERENCES `Session` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Scan`
--

LOCK TABLES `Scan` WRITE;
/*!40000 ALTER TABLE `Scan` DISABLE KEYS */;
/*!40000 ALTER TABLE `Scan` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `Scan_AFTER_UPDATE` AFTER UPDATE ON `Scan` FOR EACH ROW BEGIN
    IF NEW.deletedAt IS NOT NULL THEN
      UPDATE Occlusion SET topScanID = NULL
	  WHERE topScanID = new.id;

	  UPDATE Occlusion SET bottomScanID = NULL
	  WHERE bottomScanID = new.id;

	  UPDATE Occlusion SET leftBiteScanID = NULL
	  WHERE leftBiteScanID = new.id;

	  UPDATE Occlusion SET rightBiteScanID = NULL
	  WHERE rightBiteScanID = new.id;

	  UPDATE Occlusion SET anteriorBiteScanID = NULL
	  WHERE anteriorBiteScanID = new.id;
    END IF;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `Scan_BEFORE_DELETE` BEFORE DELETE ON `Scan` FOR EACH ROW BEGIN
  UPDATE Occlusion SET topScanID = NULL
  WHERE topScanID = OLD.id;

  UPDATE Occlusion SET bottomScanID = NULL
  WHERE bottomScanID = OLD.id;

  UPDATE Occlusion SET leftBiteScanID = NULL
  WHERE leftBiteScanID = OLD.id;

  UPDATE Occlusion SET rightBiteScanID = NULL
  WHERE rightBiteScanID = OLD.id;

  UPDATE Occlusion SET anteriorBiteScanID = NULL
  WHERE anteriorBiteScanID = OLD.id;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `ScanFile`
--

DROP TABLE IF EXISTS `ScanFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ScanFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `fileID` char(36) NOT NULL,
  `scanID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`fileID`,`scanID`,`ownerID`),
  KEY `fk_ScanFile_Scan` (`scanID`,`ownerID`),
  KEY `fk_ScanFile_CondorFile` (`fileID`,`ownerID`),
  CONSTRAINT `fk_ScanFile_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_ScanFile_Scan` FOREIGN KEY (`scanID`, `ownerID`) REFERENCES `Scan` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ScanFile`
--

LOCK TABLES `ScanFile` WRITE;
/*!40000 ALTER TABLE `ScanFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `ScanFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SentAttachment`
--

DROP TABLE IF EXISTS `SentAttachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SentAttachment` (
  `ownerID` mediumint unsigned NOT NULL DEFAULT '0',
  `sentMessageID` char(36) NOT NULL,
  `fileID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`sentMessageID`,`fileID`),
  KEY `fk_SentAttachment_SentMessage` (`sentMessageID`,`ownerID`),
  KEY `fk_SentAttachment_CondorFile` (`fileID`,`ownerID`),
  CONSTRAINT `fk_SentAttachment_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_SentAttachment_SentMessage` FOREIGN KEY (`sentMessageID`, `ownerID`) REFERENCES `SentMessage` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SentAttachment`
--

LOCK TABLES `SentAttachment` WRITE;
/*!40000 ALTER TABLE `SentAttachment` DISABLE KEYS */;
/*!40000 ALTER TABLE `SentAttachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SentMessage`
--

DROP TABLE IF EXISTS `SentMessage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SentMessage` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `created` datetime DEFAULT NULL,
  `subject` varchar(45) NOT NULL,
  `body` text,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `discussionID` char(36) NOT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_SentMessage_Discussion` (`discussionID`,`ownerID`),
  CONSTRAINT `fk_SentMessage_Discussion` FOREIGN KEY (`discussionID`, `ownerID`) REFERENCES `Discussion` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SentMessage`
--

LOCK TABLES `SentMessage` WRITE;
/*!40000 ALTER TABLE `SentMessage` DISABLE KEYS */;
/*!40000 ALTER TABLE `SentMessage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SentOrderNotification`
--

DROP TABLE IF EXISTS `SentOrderNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SentOrderNotification` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `orderID` char(36) DEFAULT NULL,
  `recipientID` char(36) DEFAULT NULL,
  `rescueData` text,
  `deliveryDate` datetime DEFAULT NULL,
  `event` enum('edited','validated','cancelled') NOT NULL DEFAULT 'edited',
  `unread` tinyint(1) NOT NULL DEFAULT '1',
  `createdAt` datetime NOT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_SentOrderNotification_Professional` (`ownerID`),
  KEY `fk_SentOrderNotification_Contact` (`recipientID`,`ownerID`),
  KEY `fk_SentOrderNotification_ProstheticOrder` (`orderID`,`ownerID`),
  CONSTRAINT `fk_SentOrderNotification_Contact` FOREIGN KEY (`recipientID`, `ownerID`) REFERENCES `Contact` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_SentOrderNotification_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_SentOrderNotification_ProstheticOrder` FOREIGN KEY (`orderID`, `ownerID`) REFERENCES `ProstheticOrder` (`id`, `ownerID`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SentOrderNotification`
--

LOCK TABLES `SentOrderNotification` WRITE;
/*!40000 ALTER TABLE `SentOrderNotification` DISABLE KEYS */;
/*!40000 ALTER TABLE `SentOrderNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Session`
--

DROP TABLE IF EXISTS `Session`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Session` (
  `ownerID` mediumint unsigned NOT NULL DEFAULT '0',
  `id` char(36) NOT NULL,
  `comments` mediumtext,
  `actID` char(36) NOT NULL,
  `globalDisplayID` mediumint unsigned DEFAULT NULL,
  `displayID` mediumint unsigned DEFAULT NULL,
  `mandibuleOcclusionPlyID` char(36) DEFAULT NULL,
  `maxillaireOcclusionPlyID` char(36) DEFAULT NULL,
  `matrixTransformationMandibuleID` char(36) DEFAULT NULL,
  `matrixTransformationMaxillaireID` char(36) DEFAULT NULL,
  `snapshotID` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `createdAt` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Occlusion_Work` (`actID`,`ownerID`),
  KEY `fk_Session_CondorFile_mandibulePly` (`mandibuleOcclusionPlyID`,`ownerID`),
  KEY `fk_Session_CondorFile_matrixTransformationMandibule` (`matrixTransformationMandibuleID`,`ownerID`),
  KEY `fk_Session_CondorFile_maxillairePly` (`maxillaireOcclusionPlyID`,`ownerID`),
  KEY `fk_Session_CondorFile_matrixTransformationMaxillaire` (`matrixTransformationMaxillaireID`,`ownerID`),
  KEY `fk_Session_CondorFile_maxillairePointContact` (`ownerID`),
  KEY `fk_Session_CondorFile_snapshot` (`snapshotID`,`ownerID`),
  CONSTRAINT `fk_Session_Act` FOREIGN KEY (`actID`, `ownerID`) REFERENCES `Act` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Session_CondorFile_mandibulePly` FOREIGN KEY (`mandibuleOcclusionPlyID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Session_CondorFile_matrixTransformationMandibule` FOREIGN KEY (`matrixTransformationMandibuleID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Session_CondorFile_matrixTransformationMaxillaire` FOREIGN KEY (`matrixTransformationMaxillaireID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Session_CondorFile_maxillairePly` FOREIGN KEY (`maxillaireOcclusionPlyID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Session_CondorFile_snapshot` FOREIGN KEY (`snapshotID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Session`
--

LOCK TABLES `Session` WRITE;
/*!40000 ALTER TABLE `Session` DISABLE KEYS */;
/*!40000 ALTER TABLE `Session` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SharedOffices`
--

DROP TABLE IF EXISTS `SharedOffices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SharedOffices` (
  `ownerID` mediumint unsigned NOT NULL,
  `office1ID` char(36) NOT NULL,
  `office2ID` char(36) NOT NULL,
  `sharedDataType` enum('ALL','CONTACTS') NOT NULL DEFAULT 'CONTACTS',
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  PRIMARY KEY (`office1ID`,`office2ID`,`ownerID`),
  KEY `fk_SharedOffices_Office_1` (`office1ID`,`ownerID`),
  KEY `fk_SharedOffices_Office_2` (`office2ID`,`ownerID`),
  CONSTRAINT `fk_SharedOffices_Office_1` FOREIGN KEY (`office1ID`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_SharedOffices_Office_2` FOREIGN KEY (`office2ID`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SharedOffices`
--

LOCK TABLES `SharedOffices` WRITE;
/*!40000 ALTER TABLE `SharedOffices` DISABLE KEYS */;
/*!40000 ALTER TABLE `SharedOffices` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `SharedOffices_BEFORE_INSERT` BEFORE INSERT ON `SharedOffices` FOR EACH ROW BEGIN
    IF EXISTS (
		SELECT 1 FROM SharedOffices WHERE
		(office1ID=NEW.office2ID AND office2ID=NEW.office1ID)
		OR
		(office1ID=NEW.office1ID AND office2ID=NEW.office2ID)
	) THEN
        SIGNAL SQLSTATE '45000' SET MESSAGE_TEXT = 'Try to insert an existing pair of keys';
    END IF;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `SmilersOrder`
--

DROP TABLE IF EXISTS `SmilersOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SmilersOrder` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `actID` char(36) NOT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `title` varchar(64) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `status` enum('not_sent','waiting_wow_api','sending_wow_api','sending_smilers_api','sent','cancelled') NOT NULL DEFAULT 'waiting_wow_api',
  `createdAt` datetime NOT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `json` text NOT NULL,
  `metadata` text NOT NULL,
  `tag` varchar(250) DEFAULT NULL,
  `localDisplayID` int unsigned DEFAULT NULL,
  `globalDisplayID` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_SmilersOrder_Act` (`actID`,`ownerID`),
  CONSTRAINT `fk_SmilersOrder_Act` FOREIGN KEY (`actID`, `ownerID`) REFERENCES `Act` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SmilersOrder`
--

LOCK TABLES `SmilersOrder` WRITE;
/*!40000 ALTER TABLE `SmilersOrder` DISABLE KEYS */;
/*!40000 ALTER TABLE `SmilersOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SmilersOrderFile`
--

DROP TABLE IF EXISTS `SmilersOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SmilersOrderFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `orderID` char(36) NOT NULL,
  `fileID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`orderID`,`fileID`),
  KEY `fk_SmilersOrderFile_SmilersOrder` (`orderID`,`ownerID`),
  KEY `fk_SmilersOrderFile_CondorFile` (`fileID`,`ownerID`),
  CONSTRAINT `fk_SmilersOrderFile_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_SmilersOrderFile_SmilersOrder` FOREIGN KEY (`orderID`, `ownerID`) REFERENCES `SmilersOrder` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SmilersOrderFile`
--

LOCK TABLES `SmilersOrderFile` WRITE;
/*!40000 ALTER TABLE `SmilersOrderFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `SmilersOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SyncInfo`
--

DROP TABLE IF EXISTS `SyncInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SyncInfo` (
  `id` mediumint unsigned NOT NULL,
  `ownerID` mediumint unsigned NOT NULL,
  `patientsLastRetrieved` datetime DEFAULT NULL,
  `actsLastRetrieved` datetime DEFAULT NULL,
  `sessionsLastRetrieved` datetime DEFAULT NULL,
  `scansLastRetrieved` datetime DEFAULT NULL,
  `ordersLastRetrieved` datetime DEFAULT NULL,
  `assistantsLastRetrieved` datetime DEFAULT NULL,
  `contactsLastRetrieved` datetime DEFAULT NULL,
  `discussionsLastRetrieved` datetime DEFAULT NULL,
  `messagesLastRetrieved` datetime DEFAULT NULL,
  `notificationsLastRetrieved` datetime DEFAULT NULL,
  `occlusionsLastRetrieved` datetime DEFAULT NULL,
  `circleordersLastRetrieved` datetime DEFAULT NULL,
  `smilersordersLastRetrieved` datetime DEFAULT NULL,
  `prostheticSheetsLastRetrieved` datetime DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `idx_SyncInfo_Professional` (`ownerID`),
  CONSTRAINT `fk_SyncInfo_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SyncInfo`
--

LOCK TABLES `SyncInfo` WRITE;
/*!40000 ALTER TABLE `SyncInfo` DISABLE KEYS */;
/*!40000 ALTER TABLE `SyncInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SystemNotification`
--

DROP TABLE IF EXISTS `SystemNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SystemNotification` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `event` enum('no_connection_for_x_days') NOT NULL DEFAULT 'no_connection_for_x_days',
  `unread` tinyint(1) NOT NULL DEFAULT '1',
  `createdAt` datetime NOT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_SystemNotification_Professional` (`ownerID`),
  CONSTRAINT `fk_SystemNotification_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SystemNotification`
--

LOCK TABLES `SystemNotification` WRITE;
/*!40000 ALTER TABLE `SystemNotification` DISABLE KEYS */;
/*!40000 ALTER TABLE `SystemNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Token`
--

DROP TABLE IF EXISTS `Token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Token` (
  `id` char(36) NOT NULL,
  `ownerID` mediumint unsigned NOT NULL,
  `created` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `token` char(41) NOT NULL,
  `credentialsId` mediumint unsigned NOT NULL,
  `context` varchar(40) DEFAULT NULL,
  `device` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  UNIQUE KEY `un_Token` (`token`),
  KEY `fk_Token_Credentials` (`credentialsId`,`ownerID`),
  CONSTRAINT `fk_Token_Credentials` FOREIGN KEY (`credentialsId`, `ownerID`) REFERENCES `Credentials` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Token`
--

LOCK TABLES `Token` WRITE;
/*!40000 ALTER TABLE `Token` DISABLE KEYS */;
/*!40000 ALTER TABLE `Token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ToothInfo`
--

DROP TABLE IF EXISTS `ToothInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ToothInfo` (
  `ownerID` mediumint unsigned NOT NULL,
  `toothNumber` tinyint unsigned NOT NULL,
  `prostheticSheetID` char(36) NOT NULL,
  `toothColor` tinytext,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`toothNumber`,`prostheticSheetID`),
  KEY `idx_ToothInfo_Order` (`ownerID`),
  KEY `fk_ToothInfo_ProstheticSheet` (`prostheticSheetID`),
  CONSTRAINT `fk_ToothInfo_ProstheticSheet` FOREIGN KEY (`prostheticSheetID`) REFERENCES `ProstheticSheet` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ToothInfo`
--

LOCK TABLES `ToothInfo` WRITE;
/*!40000 ALTER TABLE `ToothInfo` DISABLE KEYS */;
/*!40000 ALTER TABLE `ToothInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `__db_version__`
--

DROP TABLE IF EXISTS `__db_version__`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `__db_version__` (
  `id` int NOT NULL AUTO_INCREMENT,
  `version_major` int NOT NULL DEFAULT '0',
  `version_minor` int NOT NULL DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `migration_file` varchar(1024) DEFAULT NULL,
  `commit` varchar(255) DEFAULT NULL,
  `version_core` varchar(255) DEFAULT NULL,
  `version_IHM` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `__db_version__`
--

LOCK TABLES `__db_version__` WRITE;
/*!40000 ALTER TABLE `__db_version__` DISABLE KEYS */;
INSERT INTO `__db_version__` VALUES (1,1,15,'v1.15','','','1.9.0','2.0.4'),(2,1,18,'v1.18','migration_fileconstraint_local','','1.9.0','2.0.4'),(3,1,19,'v1.19','migration_fileconstraint_local','','1.9.0','2.0.4'),(4,1,20,'v1.20','migration_globalDisplayID_local','','1.9','2.0.4'),(5,1,21,'v1.21','migration_config_show_open_stl_warning_local','','1.9','2.0.4'),(6,1,22,'v1.22','migration_resetcontact_local','','1.9','2.0.4'),(7,1,23,'v1.23','migration_token_context_device_local','','1.9','2.0.4'),(8,1,24,'v1.24','migration_config_lag_and_lost_sound_local','','1.9','2.0.4'),(9,1,25,'v1.25','migration_fix_unset_scan_creator_local','','1.9.0','2.0.4'),(10,1,26,'v1.26','migration_fix_wrong_original_files_local','','1.9.0','2.0.4'),(11,1,27,'v1.27','migration_occlusion_display_id_local','','1.9','2.0.4'),(12,1,28,'v1.28','migration_selfdiscussions_local','','1.9','2.0.4'),(13,1,29,'v1.29','migration_config_show_delete_confirmation_local','','1.9','2.0.4'),(14,1,30,'v1.30','migration_config_email_notifications_local','','1.9','2.0.4'),(15,1,31,'v1.31','migration_config_last_synced_local','','1.9','2.0.4'),(16,1,32,'v1.32','migration_lastmodified_local','','1.9','2.0.4'),(17,1,33,'v1.33','migration_config_add_fields_flip_local','','1.9','2.0.4'),(18,1,34,'v1.34','migration_unread_local','','1.9','2.0.4'),(19,1,35,'v1.35','migration_work_last_accessed_local','','1.9','2.0.4'),(20,1,36,'v1.36','migration_config_show_sync_info_local','','1.9','2.0.4'),(21,1,37,'v1.37','migration_config_clean_deprecated_fields_local','','1.9','2.0.4'),(22,1,38,'v1.38','migration_act_refonte_local','','1.9','2.0.4'),(23,1,39,'v1.39','migration_fix_duplicate_screenshot_path_local','','1.9','2.0.4'),(24,1,40,'v1.40','migration_rework_local','','1.9.0','2.0.4'),(25,1,41,'v1.41','migration_sync_info_local','','1.9.0','1.1-3'),(26,1,42,'v1.42','migration_config_popup_flip','','1.9','2.0.4'),(27,1,43,'v1.43','migration_mark_contacts_invisible_local','','1.9','3.2.1'),(28,1,44,'v1.44','migration_config_show_margin_lines_warning_local','','1.9','2.0.4'),(29,1,45,'v1.45','migration_contact_invitation_local','','1.9','2.3.0'),(30,1,46,'v1.46','migration_received_order_local','','1.9','3.3.0'),(31,1,47,'v1.47','migration_merge_discussions_local','','1.9','3.3.1'),(32,1,48,'v1.48','migration_office_rename_email_local','','1.9','3.3.1'),(33,1,49,'v1.49','migration_contact_cannot_reject_self_local','','1.9','3.3.1'),(34,1,50,'v1.50','migration_discussion_deletedat_not_null_local','','1.9','3.3.1'),(35,1,51,'v1.51','migration_reset_condor_file_trigger_local','','1.9','3.3.1'),(36,1,52,'v1.52','migration_system_notification_local','','1.9','2.3.0'),(37,1,53,'v1.53','migration_add_last_connection_checked_professional_local','','1.9','3.4.0'),(38,1,54,'v1.54','migration_endless_scans_local','','1.9','3.4.0'),(39,1,55,'v1.55','migration_rename_act_session_local','','1.9','3.4.0'),(40,1,56,'v1.56','migration_sessionId_local','','1.9','3.4.0'),(41,1,57,'v1.57','migration_session_created_at_local','','1.9','3.4.0'),(42,1,58,'v1.58','migration_order_display_id_local','','1.9','3.4.0'),(43,1,59,'v1.59','migration_pin_patient_local','','1.9','1.0.0'),(44,1,60,'v1.60','migration_enable_upload_local','','3.4.0','1.0.1'),(45,1,61,'v1.61','migration_remove_occlusion_contact_local','','3.4.1','1.1.0'),(46,1,62,'v1.62','migration_scanid_local','','3.4.1','1.1.0'),(47,1,63,'v1.63','migration_circleorder_local','','3.4.1','1.1.0'),(48,1,64,'v1.64','migration_smilersorder_local','','4.1.0','2.1.0'),(49,1,65,'v1.65','migration_demo_professional','','4.1.0','2.1.0'),(50,1,66,'v1.66','migration_tracking_rectangle','','4.1.0','2.1.1'),(51,1,67,'v1.67','migration_fix_status_circle_smilers','','4.1.0','2.1.1'),(52,1,68,'v1.68','migration_remove_scansID_session_local','','4.2.0','2.1.1'),(53,1,69,'v1.69','migration_externalize_occlusion_local','','4.2.0','2.1.1'),(54,1,70,'v1.70','migration_scan_occlusion_trigger_local','','4.2.0','2.1.1'),(55,1,74,'v1.74','migration_fix_xxxinfo_local','','4.3.0','2.2.3'),(56,1,71,'v1.71','migration_add_date_created_scan_local','','4.2.0','2.1.1'),(57,1,72,'v1.72','migration_scan_status_local','','4.2.0','2.1.1'),(58,1,73,'v1.73','migration_remove_patient_personnal_data_local','','4.2.0','2.1.1'),(59,1,75,'v1.75','migration_add_displayid_occlusion_local','','4.3.0','2.3.3'),(60,1,76,'v1.76','migration_add_table_ProstheticSheet_local','','4.4.0','2.3.4'),(61,1,77,'v1.77','migration_status_smilers_circle_local','','4.2.0','2.4.0'),(62,1,78,'v1.78','migration_condor_local_1.78_patient_theme','','4.4.0','2.4.0'),(63,1,79,'v1.79','migration_condor_local_1.79_fix_order_recipient','','4.5.0','2.4.4'),(64,1,80,'v1.80','migration_condor_local_1.80_fix_order','','4.5.0','2.4.4'),(65,1,81,'v1.81','migration_condor_local_1.81_fix_theme_null','','4.5.0','2.4.4');
/*!40000 ALTER TABLE `__db_version__` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping routines for database 'condor'
--
/*!50003 DROP FUNCTION IF EXISTS `generateid` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `generateid`(maxchars int) RETURNS char(36) CHARSET utf8mb3
BEGIN

  DECLARE AllChars char(16);
  DECLARE currentStr CHAR(36);
  DECLARE p1 int;
  
  SET AllChars = 'abcdef0123456789'; 
  SET currentStr = '';
  SET p1 = 0;

  charLoop: LOOP
  
    IF p1 < maxchars THEN
	  SET currentStr = CONCAT(currentStr, substring(AllChars, (RAND()*15)+1, 1));
	  SET p1 = p1 + 1;
      
      ITERATE charLoop;
    END IF;
    
    LEAVE charLoop;
    
  END LOOP charLoop;
  
  RETURN currentStr;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `drop_fk_if_exists` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `drop_fk_if_exists`(in theTable varchar(128), in theFKName varchar(128) )
BEGIN
 IF((SELECT COUNT(*) AS fk_exists
     FROM information_schema.table_constraints
     WHERE TABLE_SCHEMA = DATABASE() AND table_name = theTable AND constraint_name = theFKName AND constraint_type = 'FOREIGN KEY') > 0)
 THEN
   SET @s = CONCAT('ALTER TABLE ', theTable, ' DROP FOREIGN KEY ' , theFKName);
   PREPARE stmt FROM @s;
   EXECUTE stmt;
 END IF;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `drop_index_if_exists` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `drop_index_if_exists`(in theTable varchar(128), in theIndexName varchar(128) )
BEGIN
 IF((SELECT COUNT(*) AS index_exists
     FROM information_schema.statistics
     WHERE TABLE_SCHEMA = DATABASE() and table_name = theTable AND index_name = theIndexName) > 0)
 THEN
   SET @s = CONCAT('DROP INDEX ' , theIndexName , ' ON ' , theTable);
   PREPARE stmt FROM @s;
   EXECUTE stmt;
 END IF;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `fixOrderFrom176` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `fixOrderFrom176`()
    NO SQL
BEGIN
    SET @script_ok = (SELECT COUNT(*) FROM __db_version__ WHERE version_major = '1' AND version_minor = '76');

	IF (@script_ok = 0) THEN
        SET @count_bad_date = (SELECT COUNT(*) FROM ProstheticOrder WHERE createdAt IS NULL);
        IF (@count_bad_date > 0) THEN
            CALL `script176`();
        ELSE
            SET @count_bad_toothinfo = (SELECT COUNT(*) FROM ToothInfo WHERE prostheticSheetID = '');
            IF (@count_bad_toothinfo > 0) THEN
                DELETE FROM ToothInfo WHERE prostheticSheetID = '';

                ALTER TABLE ToothInfo ADD PRIMARY KEY (ownerID, toothNumber, prostheticSheetID);
                ALTER TABLE ToothInfo DROP COLUMN orderID;

                INSERT INTO `__db_version__`(`version_major`, `version_minor`, `title`, `commit`, `migration_file`, `version_core`, `version_IHM`) VALUES
                    (1, 76, 'v1.76', '', 'migration_condor_local_1.76_add_table_ProstheticSheet_from_180', '4.4.0', '2.3.4');
            END IF;
        END IF;
    END IF;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `FixOrderRecipient` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `FixOrderRecipient`()
    NO SQL
BEGIN
    DECLARE CurOrderOwnerID MEDIUMINT(8) UNSIGNED;
    DECLARE CurOrderUuid CHAR(36);
    DECLARE CurOrderId VARCHAR(255);

    DECLARE NbRecipient INT(8);
    DECLARE DID CHAR(36);
    DECLARE RecipientOwnerId MEDIUMINT(8) UNSIGNED;
    DECLARE RecipientContactId CHAR(36);

    DECLARE exit_loop BOOLEAN DEFAULT FALSE;

    DECLARE CUR CURSOR FOR
        SELECT ownerId, uuid, id
        FROM DebugOrderData
        WHERE id IS NOT NULL;

    DECLARE CONTINUE HANDLER FOR NOT FOUND SET exit_loop = TRUE;

    OPEN CUR;
    read_loop: LOOP
        FETCH CUR INTO CurOrderOwnerID, CurOrderUuid, CurOrderId;

        
        
        IF exit_loop THEN
            CLOSE CUR;
            LEAVE read_loop;
        END IF;

        SET NbRecipient = (SELECT COUNT(*) FROM ProstheticOrderRecipient WHERE orderID = CurOrderUuid);

        IF NbRecipient = 0 THEN
            SET DID = (SELECT discussionID FROM SentMessage WHERE LOCATE(CurOrderId, body) > 0);

            IF DID IS NOT NULL THEN
                SET RecipientOwnerId = (SELECT ownerID FROM Discussion WHERE id = DID AND ownerID != CurOrderOwnerID);

                IF RecipientOwnerId IS NOT NULL THEN
                    SET RecipientContactId = (SELECT id FROM Contact WHERE ownerID = CurOrderOwnerID AND professionalID = RecipientOwnerId);

                    IF RecipientContactId IS NOT NULL THEN
                        INSERT INTO ProstheticOrderRecipient VALUES (CurOrderOwnerID, CurOrderUuid , RecipientContactId, NOW());
                    END IF;
                END IF;
            END IF;
        END IF;
    END LOOP;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `getUsedScansForOcclusion` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `getUsedScansForOcclusion`()
    NO SQL
BLOCK1: BEGIN

  DECLARE CurFileID CHAR(36);
  DECLARE CurFileMetadata TEXT;
  DECLARE CurOwnerID MEDIUMINT(8) UNSIGNED;
  DECLARE CurFileTag TEXT;
  
  DECLARE exit_loop BOOLEAN DEFAULT FALSE;

  DECLARE read_sessionid TEXT;

  DECLARE CUR CURSOR FOR
          SELECT CondorFile.id, CondorFile.metadata, CondorFile.ownerID, CondorFile.tag
          FROM CondorFile WHERE tag LIKE '%_OCC_%' AND metadata LIKE '%"referenceScanID":"%' AND deletedAt IS NULL;
          
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET exit_loop = TRUE;

  OPEN CUR;
  read_loop: LOOP

	  FETCH CUR INTO CurFileID, CurFileMetadata, CurOwnerID, CurFileTag;

		IF exit_loop THEN
			CLOSE CUR;
			LEAVE read_loop;
		END IF;
		
    
		SET @refScanDelimiter = SUBSTRING_INDEX(CurFileMetadata, '"referenceScanID":"', -1); 
		SET @refScanID = SUBSTRING_INDEX(@refScanDelimiter, ':', 1);
        
		SET @actDelemiter = SUBSTRING_INDEX(CurFileTag, '_ACT_', -1); 
        SET @curActID = SUBSTRING_INDEX(@actDelemiter, '_', 1);
		SET @sessionDelemiter = SUBSTRING_INDEX(CurFileTag, '_SESS_', -1); 
        SET @curSessionID = SUBSTRING_INDEX(@sessionDelemiter, '_', 1);
        
        
        
		IF @curActID is NOT NULL AND @curSessionID is NOT NULL THEN
        
			SET @actOwnerID = (SELECT ownerID FROM Act WHERE id = @curActID);
			SET @sessionOwnerID = (SELECT ownerID FROM Session WHERE id = @curSessionID);
            
            
            IF @actOwnerID = CurOwnerID AND @sessionOwnerID = CurOwnerID THEN
            
				SET @scanNo = SUBSTRING_INDEX(@refScanID,'.',-1);
				SET @scanType = '';
				SET @findTopScan = CurFileTag LIKE '%_TOPLY_%';
				SET @findBottomScan = CurFileTag LIKE '%_BOPLY_%';
				
				IF @findTopScan > 0 THEN
					SET @scanType = 'MAXILLAIRE';
				ELSEIF @findBottomScan > 0 THEN
					SET @scanType = 'MANDIBULE';
				ELSE 
					ITERATE read_loop;
				END IF;
                 
                SET @scanID = (SELECT id FROM Scan WHERE ownerID = CurOwnerID AND sessionID = @curSessionID AND displayID = @scanNo AND scanType = @scanType AND deletedAt IS NULL );
				SET @occlusionID =  SUBSTRING_INDEX(SUBSTRING_INDEX(CurFileTag, '_OCC_', -1), '_', 1); 
				
				IF @occlusionID IS NULL THEN 
					ITERATE read_loop;
				END IF;
	
				IF @findTopScan > 0 THEN
					UPDATE Occlusion SET topScanID = @scanID WHERE id = @occlusionID;
				ELSEIF @findBottomScan > 0 THEN
					UPDATE Occlusion SET bottomScanID = @scanID WHERE id = @occlusionID;
				END IF; 
                
            END IF;
		
        END IF;
         
  END LOOP;

END BLOCK1 ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `migrateLifiOcclusionFiles` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `migrateLifiOcclusionFiles`()
    NO SQL
BEGIN

  DECLARE CurOwnerID MEDIUMINT(8) UNSIGNED;
  DECLARE CurFilePath TEXT;
  DECLARE CurFileID CHAR(36);
  DECLARE CurFileTag VARCHAR(250);
  DECLARE CurFileType VARCHAR(250);
  DECLARE CurFileMetadata TEXT;
  
  DECLARE exit_loop BOOLEAN DEFAULT FALSE;
  
  DECLARE read_sessionid TEXT;

  
  DECLARE CUR CURSOR FOR
          SELECT CondorFile.ownerID, CondorFile.id, CondorFile.tag, CondorFile.path, CondorFile.type, CondorFile.metadata
          FROM CondorFile
	  WHERE type LIKE '%LIFI%' AND metadata LIKE '%"isOcclusionMarginLine":true%' AND id NOT IN (SELECT fileID FROM ReceivedAttachment);

  DECLARE CONTINUE HANDLER FOR NOT FOUND SET exit_loop = TRUE;
  
  OPEN CUR;
  read_loop: LOOP

  FETCH CUR INTO CurOwnerID, CurFileID, CurFileTag, CurFilePath, CurFileType, CurFileMetadata;

	
	
	IF exit_loop THEN
		CLOSE CUR;
		LEAVE read_loop;
	END IF;
		
	SET @sessionDelimiter = SUBSTRING_INDEX(CurFileTag, '_SESS_', -1);
        SET @curSessionID = SUBSTRING_INDEX(@sessionDelimiter, '_', 1);
        
	SELECT ownerID, id INTO @occlusionOwnerID, @occlusionID FROM Occlusion WHERE sessionID = @curSessionID;
      
	
        
	IF @occlusionID IS NOT NULL AND @occlusionOwnerID = CurOwnerID THEN

		SET @pleft = SUBSTRING_INDEX(CurFileTag, @curSessionID, 1);
		SET @newTag = CONCAT(@pleft, @curSessionID, '_OCC_', @occlusionID, '_', CurFileType, 'O_', CurFileType, '_');
            
		SET @filename = SUBSTRING_INDEX(CurFilePath, '/', -1);
		SET @scanPath = SUBSTRING_INDEX(CurFilePath, '/', -2);
		SET @sessionPath = SUBSTRING_INDEX(CurFilePath, @scanPath, 1);
		SET @newFilePath = CONCAT(@sessionPath, 'computedocclusion_', @occlusionID, '/', @filename);

		UPDATE CondorFile SET tag = @newTag, path = @newFilePath WHERE id = CurFileID;
             
		
		INSERT INTO OcclusionFile(ownerID, fileID, occlusionID, lastUpdated)
		VALUES (CurOwnerID, CurFileID, @occlusionID, CURRENT_TIMESTAMP);

		
		SET @scanID = (SELECT scanID FROM ScanFile WHERE fileID = CurFileID);

		IF @scanID IS NOT NULL THEN
			SET @scanType = (SELECT scanType FROM Scan WHERE id = @scanID);

			IF @scanType is not NULL THEN
				SET @currentMetadata = SUBSTRING_INDEX(CurFileMetadata, '}', 1);
				SET @lifiScanType = CONCAT('"lifi_scan_type":"', @scanType, '"');
				SET @newMetadata = CONCAT(@currentMetadata, ',', @lifiScanType, '}');

				UPDATE CondorFile SET metadata = @newMetadata WHERE id = CurFileID;
			END IF;

		END IF;

            
            DELETE FROM ScanFile WHERE fileID = CurFileID;

	END IF;

  END LOOP;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `migrateOcclusions` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `migrateOcclusions`()
    NO SQL
BEGIN
  DECLARE CurOwnerID MEDIUMINT(8) UNSIGNED;
  DECLARE CurSessionID CHAR(36);
  DECLARE CurMandibuleOcclusionPlyID CHAR(36);
  DECLARE CurMaxillaireOcclusionPlyID CHAR(36);
  DECLARE CurMatrixTransformationMandibuleID CHAR(36);
  DECLARE CurMatrixTransformationMaxillaireID CHAR(36);
  DECLARE CurSnapshotID CHAR(36);
  
  
  DECLARE TopScanID CHAR(36);
  DECLARE BottomScanID CHAR(36);
  DECLARE CheckIntegrity BOOLEAN DEFAULT FALSE;

  DECLARE NewOcclusionID CHAR(36);
  DECLARE exit_loop BOOLEAN DEFAULT FALSE;

  
  DECLARE CUR CURSOR FOR
          SELECT Session.ownerID, Session.id, Session.mandibuleOcclusionPlyID, Session.maxillaireOcclusionPlyID,
					Session.matrixTransformationMandibuleID, Session.matrixTransformationMaxillaireID, Session.snapshotID
          FROM Session WHERE deletedAt IS NULL AND mandibuleOcclusionPlyID IS NOT NULL AND maxillaireOcclusionPlyID IS NOT NULL AND
					matrixTransformationMandibuleID IS NOT NULL AND matrixTransformationMaxillaireID IS NOT NULL AND snapshotID IS NOT NULL;
          
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET exit_loop = TRUE;

  OPEN CUR;
  read_loop: LOOP

  FETCH CUR INTO CurOwnerID, CurSessionID, CurMandibuleOcclusionPlyID, CurMaxillaireOcclusionPlyID,
					CurMatrixTransformationMandibuleID, CurMatrixTransformationMaxillaireID, CurSnapshotID;

    
    
    IF exit_loop THEN
	CLOSE CUR;
	LEAVE read_loop;
    END IF;

	SET TopScanID = (SELECT scanID from ScanFile WHERE fileID = CurMaxillaireOcclusionPlyID);
    SET BottomScanID = (SELECT scanID from ScanFile WHERE fileID = CurMandibuleOcclusionPlyID);

    
	
	

	
	
    
    SET NewOcclusionID = concat(left(CurSessionID, length(CurSessionID) - 9), 'migraoccl');
	
	INSERT INTO Occlusion(ownerID, id, sessionID, occlusionType, deletedAt, createdAt, lastSynced, lastModified, lastUpdated, topScanID, bottomScanID, 
							anteriorBiteScanID, rightBiteScanID, leftBiteScanID, snapshotID, mandibuleOcclusionPlyID, maxillaireOcclusionPlyID, matrixTransformationMandibuleID, 
							matrixTransformationMaxillaireID)
							VALUES (CurOwnerID, NewOcclusionID, CurSessionID, NULL, NULL, CURRENT_TIMESTAMP, NULL, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP, TopScanID, BottomScanID,
							NULL, NULL, NULL, CurSnapshotID, CurMandibuleOcclusionPlyID, CurMaxillaireOcclusionPlyID, CurMatrixTransformationMandibuleID,
							CurMatrixTransformationMaxillaireID);
	
	
	INSERT INTO OcclusionFile(ownerID, fileID, occlusionID, lastUpdated)
							VALUES (CurOwnerID, CurMandibuleOcclusionPlyID, NewOcclusionID, CURRENT_TIMESTAMP);
	INSERT INTO OcclusionFile(ownerID, fileID, occlusionID, lastUpdated)
							VALUES (CurOwnerID, CurMaxillaireOcclusionPlyID, NewOcclusionID, CURRENT_TIMESTAMP);
	INSERT INTO OcclusionFile(ownerID, fileID, occlusionID, lastUpdated)
							VALUES (CurOwnerID, CurMatrixTransformationMandibuleID, NewOcclusionID, CURRENT_TIMESTAMP);
	INSERT INTO OcclusionFile(ownerID, fileID, occlusionID, lastUpdated)
							VALUES (CurOwnerID, CurMatrixTransformationMaxillaireID, NewOcclusionID, CURRENT_TIMESTAMP);
	INSERT INTO OcclusionFile(ownerID, fileID, occlusionID, lastUpdated)
							VALUES (CurOwnerID, CurSnapshotID, NewOcclusionID, CURRENT_TIMESTAMP);          
    


  END LOOP;
  
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `script176` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `script176`()
    NO SQL
BEGIN
    
    DROP TABLE IF EXISTS `ProstheticSheet`;
    CREATE TABLE `ProstheticSheet` (
        `id` char(36) NOT NULL,
        `ownerID` mediumint(8) unsigned NOT NULL,
        `orderID` char(36) NOT NULL,
        `json` TEXT NOT NULL,
        `pdfFileID` char(36) DEFAULT NULL,
        `dateCreated` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
        `deletedAt` datetime DEFAULT NULL,
        `lastSynced` datetime DEFAULT NULL,
        `lastModified` datetime NOT NULL,
        `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`,`ownerID`),
        CONSTRAINT `fk_ProstheticSheet_ProstheticOrder` FOREIGN KEY (`orderID`) REFERENCES `ProstheticOrder` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
        CONSTRAINT `fk_ProstheticSheet_CondorFile` FOREIGN KEY (`pdfFileID`) REFERENCES `CondorFile` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

    
    UPDATE ProstheticOrder SET createdAt = lastUpdated WHERE createdAt IS NULL;

    
    INSERT INTO ProstheticSheet (id, ownerID, orderID, json, dateCreated, deletedAt, lastSynced, lastModified, lastUpdated)
    SELECT
        PO.id as id,
        PO.ownerID,
        PO.id as orderID,
        CONCAT('{"sheetTitle":"', PO.title, '",', RIGHT(PO.json, LENGTH(PO.json)-1)), 
        PO.createdAt as dateCreated,
        PO.deletedAt,
        PO.lastSynced,
        PO.lastModified,
        PO.lastUpdated
    FROM ProstheticOrder AS PO;

    CREATE TEMPORARY TABLE PDF_ID_TMP
    SELECT POF1.orderID, POF1.fileID, CF1.version, T.maxVersion
    FROM ProstheticOrderFile AS POF1
    INNER JOIN CondorFile AS CF1 ON POF1.fileID = CF1.id
    INNER JOIN (
        SELECT POF2.orderID, MAX(CF2.version) AS maxVersion
        FROM ProstheticOrderFile AS POF2
        INNER JOIN CondorFile AS CF2 ON POF2.fileID = CF2.id
        WHERE CF2.type = 'PDF'
        GROUP BY POF2.orderID
    ) T ON POF1.orderID = T.orderID
    WHERE CF1.type = 'PDF' AND CF1.version = T.maxVersion;

    UPDATE ProstheticSheet AS PS
    INNER JOIN PDF_ID_TMP AS PDF ON PDF.orderID = PS.orderID
    SET PS.pdfFileID = PDF.fileID;

    DROP TEMPORARY TABLE PDF_ID_TMP;

    
    
    

    ALTER TABLE SyncInfo ADD prostheticSheetsLastRetrieved DATETIME NULL AFTER smilersordersLastRetrieved;

    ALTER TABLE ProstheticOrder DROP COLUMN json;

    ALTER TABLE ToothInfo ADD prostheticSheetID char(36) NOT NULL AFTER toothNumber;

    UPDATE ToothInfo AS TI
    INNER JOIN ProstheticSheet AS PS on TI.orderID = PS.orderID
    SET TI.prostheticSheetID = PS.id;

    
    
    

    
    ALTER TABLE ToothInfo DROP FOREIGN KEY fk_ToothInfo_Order;

    
    ALTER TABLE ToothInfo ADD CONSTRAINT `fk_ToothInfo_ProstheticSheet` FOREIGN KEY (`prostheticSheetID`) REFERENCES `ProstheticSheet` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

    ALTER TABLE ToothInfo DROP PRIMARY KEY;
    ALTER TABLE ToothInfo ADD PRIMARY KEY (ownerID, toothNumber, prostheticSheetID);

    ALTER TABLE ToothInfo DROP COLUMN orderID;

    
    
    

    INSERT INTO `__db_version__`(`version_major`, `version_minor`, `title`, `commit`, `migration_file`, `version_core`, `version_IHM`) VALUES
    (1, 76, 'v1.76', '', 'migration_condor_local_1.76_add_table_ProstheticSheet_from_180', '4.4.0', '2.3.4');

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `updateOcclusionsCondorFilesTag` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `updateOcclusionsCondorFilesTag`()
    NO SQL
BEGIN

  DECLARE CurFilePath TEXT;
  DECLARE CurFileID CHAR(36);
  DECLARE CurFileTag VARCHAR(250);
  DECLARE exit_loop BOOLEAN DEFAULT FALSE;
  
  DECLARE read_sessionid TEXT;

  
  DECLARE CUR CURSOR FOR
          SELECT CondorFile.id, CondorFile.tag, CondorFile.path
          FROM CondorFile 
	  WHERE tag REGEXP '_TOMA_|_BOMA_|_TOPLY_|_BOPLY_|_SNAPO_' AND id NOT IN (SELECT fileID FROM ReceivedAttachment);

  DECLARE CONTINUE HANDLER FOR NOT FOUND SET exit_loop = TRUE;

  OPEN CUR;
  read_loop: LOOP

  FETCH CUR INTO CurFileID, CurFileTag, CurFilePath;

	
	
	IF exit_loop THEN
		CLOSE CUR;
		LEAVE read_loop;
	END IF;
		
        SET @sessionDelimiter = SUBSTRING_INDEX(CurFileTag, '_SESS_', -1); 
        SET @curSessionID = SUBSTRING_INDEX(@sessionDelimiter, '_', 1);
        
        
	Set @occlusionID = (SELECT id FROM Occlusion WHERE sessionID = @curSessionID AND deletedAt IS NULL);
      
	IF @occlusionID is not NULL THEN

		SET @pleft = SUBSTRING_INDEX(CurFileTag, @curSessionID, 1); 
		SET @pright = SUBSTRING_INDEX(CurFileTag, @curSessionID, -1); 
		SET @newTag = CONCAT(@pleft, @curSessionID, '_OCC_', @occlusionID, @pright);

		SET @filename = SUBSTRING_INDEX(CurFilePath, '/', -1);
		SET @sessionPath = SUBSTRING_INDEX(CurFilePath, @filename, 1);
		SET @newFilePath = CONCAT(@sessionPath, 'computedocclusion_', @occlusionID, '/', @filename);

		UPDATE CondorFile SET tag = @newTag, path = @newFilePath WHERE id = CurFileID;
        END IF;
        
  END LOOP;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `updateScanDisplayID` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `updateScanDisplayID`()
    NO SQL
BEGIN
  DECLARE CurOwnerID MEDIUMINT(8) UNSIGNED;
  DECLARE CurID CHAR(36);
  DECLARE CurSessionID CHAR(36);
  DECLARE CurLastSync DATETIME;

  DECLARE CurScanType
  ENUM('MAXILLAIRE', 'MANDIBULE', 'MORDU_ANTERIEUR', 'MORDU_POSTERIEUR_GAUCHE', 'MORDU_POSTERIEUR_DROIT');

  DECLARE CurNbSyncScan INT;
  DECLARE CurMaxDisplayID INT;

  DECLARE exit_loop BOOLEAN DEFAULT FALSE;

  DECLARE CUR CURSOR FOR
          SELECT Scan.ownerID, Scan.id, Scan.sessionID, Scan.scanType, Scan.lastSynced
          FROM Scan;

  DECLARE CONTINUE HANDLER FOR NOT FOUND SET exit_loop = TRUE;

  OPEN CUR;
  read_loop: LOOP

  FETCH CUR INTO CurOwnerID, CurID, CurSessionID, CurScanType, CurLastSync;

    
    
    IF exit_loop THEN
	CLOSE CUR;
	LEAVE read_loop;
    END IF;

    IF CurLastSync IS NULL THEN

	SET CurNbSyncScan = (SELECT COUNT(*)
				FROM Scan
				WHERE ownerID = CurOwnerID AND sessionID = CurSessionID AND scanType = CurScanType AND lastSynced IS NOT NULL);


	SET CurMaxDisplayID = (SELECT MAX(displayID)
				FROM Scan
				WHERE ownerID = CurOwnerID AND sessionID = CurSessionID AND scanType = CurScanType);

    	IF CurMaxDisplayID IS NULL OR CurMaxDisplayID = 0 THEN
		
        	SET CurMaxDisplayID = CurNbSyncScan;
    	END IF;

    	UPDATE Scan
    	SET displayID = (CurMaxDisplayID + 1)
    	WHERE ownerID = CurOwnerID AND id = CurID;

    END IF;

  END LOOP;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2022-01-04 14:54:13
