-- MySQL dump 10.13  Distrib 8.0.28, for Linux (x86_64)
--
-- Host: localhost    Database: condor
-- ------------------------------------------------------
-- Server version	8.0.28-0ubuntu0.20.04.3

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `Act`
--

DROP TABLE IF EXISTS `Act`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Act` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `title` varchar(64) DEFAULT NULL,
  `dateCreated` datetime DEFAULT NULL,
  `comments` mediumtext,
  `globalDisplayID` mediumint unsigned DEFAULT NULL,
  `displayID` mediumint unsigned DEFAULT NULL,
  `patientID` char(36) NOT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastAccessed` datetime NOT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Work_Patient` (`patientID`,`ownerID`),
  CONSTRAINT `fk_Act_Patient` FOREIGN KEY (`patientID`) REFERENCES `condor_patient_local`.`Patient` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Act`
--

LOCK TABLES `Act` WRITE;
/*!40000 ALTER TABLE `Act` DISABLE KEYS */;
/*!40000 ALTER TABLE `Act` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AddressInfo`
--

DROP TABLE IF EXISTS `AddressInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AddressInfo` (
  `id` char(36) NOT NULL COMMENT '(DC2Type:guid)',
  `line_0` varchar(255) DEFAULT NULL,
  `line_1` varchar(255) DEFAULT NULL,
  `line_2` varchar(255) DEFAULT NULL,
  `detail` varchar(255) DEFAULT NULL,
  `cityName` varchar(255) DEFAULT NULL,
  `cityState` varchar(255) DEFAULT NULL,
  `cityZip` varchar(25) DEFAULT NULL,
  `countryName` varchar(255) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AddressInfo`
--

LOCK TABLES `AddressInfo` WRITE;
/*!40000 ALTER TABLE `AddressInfo` DISABLE KEYS */;
INSERT INTO `AddressInfo` VALUES ('00000001-0000-0000-0000-000000000001','Labege','','',NULL,'Labege','','31670','France',NULL,NULL,'2022-02-28 17:23:42'),('00000002-0000-0000-0000-000000000001','137 rue garance','','',NULL,'LABEGE','','31670','France',NULL,NULL,'2022-02-28 17:23:42'),('00000003-0000-0000-0000-000000000001','137 rue Garance','','',NULL,'Labège','','31670','France',NULL,NULL,'2022-02-28 17:23:42'),('00000004-0000-0000-0000-000000000001','','','',NULL,'','','','',NULL,NULL,'2022-02-28 17:23:42'),('00000005-0000-0000-0000-000000000001','','','',NULL,'HOENHEIM','','','France',NULL,NULL,'2022-02-28 17:23:42'),('00000006-0000-0000-0000-000000000001','','','',NULL,'Marseille','','','France',NULL,NULL,'2022-02-28 17:23:42'),('00000007-0000-0000-0000-000000000001','','','',NULL,'MERIGNAC','','','France',NULL,NULL,'2022-02-28 17:23:42'),('00000008-0000-0000-0000-000000000001','','','',NULL,'MERIGNAC','','','France',NULL,NULL,'2022-02-28 17:23:42'),('00000009-0000-0000-0000-000000000001','','','',NULL,'Villiers Sur Marne','','','France',NULL,NULL,'2022-02-28 17:23:42'),('00000010-0000-0000-0000-000000000001','','','',NULL,'Toulouse','','','France',NULL,NULL,'2022-02-28 17:23:42'),('00000011-0000-0000-0000-000000000001','137 rue Garance','','',NULL,'Labège','','31670','France',NULL,NULL,'2022-02-28 17:23:42'),('00000017-0000-0000-0000-000000000001','2 rue de lyon ','','',NULL,'Montmerle sur saone','','01090','France',NULL,NULL,'2022-02-28 17:23:42'),('00000036-0000-0000-0000-000000000001','6 George Davaris Street 1st Floor','','',NULL,'Nicosia','','2024','Kypros',NULL,NULL,'2022-02-28 17:23:42'),('00000048-0000-0000-0000-000000000001','30 rue du 22 novembre','','',NULL,'strasbourg','','67000','France',NULL,NULL,'2022-02-28 17:23:42'),('00000058-0000-0000-0000-000000000001','386 rue vincent d\'indy','','',NULL,'Le teil','','07400','France',NULL,NULL,'2022-02-28 17:23:42'),('00000061-0000-0000-0000-000000000001','12 PLACE DE L\'HOTEL DE VILLE','','',NULL,'ANNEMASSE','','74100','France',NULL,NULL,'2022-02-28 17:23:42'),('00000080-0000-0000-0000-000000000001','402 rue des granitiers','','',NULL,'Plaintel','','22940','France',NULL,NULL,'2022-02-28 17:23:42'),('00000086-0000-0000-0000-000000000001','AVENIDA JUAN CARAMUEL. 1','','',NULL,'LEGANES','','28919','España',NULL,NULL,'2022-02-28 17:23:42'),('00000090-0000-0000-0000-000000000001','','','',NULL,'Aubagne','','','France',NULL,NULL,'2022-02-28 17:23:42'),('00000100-0000-0000-0000-000000000001','3 Place de la Croute','','',NULL,'Coutances','','50200','France',NULL,NULL,'2022-02-28 17:23:42'),('00000117-0000-0000-0000-000000000001','160 boulevard de la république','','',NULL,'Saint-Cloud','','92210','France',NULL,NULL,'2022-02-28 17:23:42'),('00000135-0000-0000-0000-000000000001','RUE MARECHAL JOFFRE','','',NULL,'LEXY','','54270','France',NULL,NULL,'2022-02-28 17:23:42'),('00000154-0000-0000-0000-000000000001','61 avenue Jean XXIII','','',NULL,'Angers','','49000','France',NULL,NULL,'2022-02-28 17:23:42'),('00000163-0000-0000-0000-000000000001','','','',NULL,'','','','France',NULL,NULL,'2022-02-28 17:23:42'),('00000169-0000-0000-0000-000000000001','Busaiteen','','',NULL,'78','','112233','Al-Baḥrayn',NULL,NULL,'2022-02-28 17:23:42'),('00000172-0000-0000-0000-000000000001','4 Chemin Couralis','','',NULL,'LAROIN','','64110','France',NULL,NULL,'2022-02-28 17:23:42'),('00000176-0000-0000-0000-000000000001','10 rocade de l\'oasis','','',NULL,'St denis','','97400','Réunion',NULL,NULL,'2022-02-28 17:23:42'),('00000177-0000-0000-0000-000000000001','AVDA. JUAN CARAMUEL,1','','',NULL,'LEGANES','','28916','España',NULL,NULL,'2022-02-28 17:23:42'),('00000196-0000-0000-0000-000000000001','12 rue de la poule blanche','','',NULL,'ormes','','45140','France',NULL,NULL,'2022-02-28 17:23:42'),('00000211-0000-0000-0000-000000000001','4 place de la liberté','','',NULL,'ballancourt','','91610','France',NULL,NULL,'2022-02-28 17:23:42'),('00000220-0000-0000-0000-000000000001','1','','',NULL,'1','','1','Portugal',NULL,NULL,'2022-02-28 17:23:42'),('00000245-0000-0000-0000-000000000001','74 Rue Vauban','','',NULL,'LYON','','69006','France',NULL,NULL,'2022-02-28 17:23:42'),('00000254-0000-0000-0000-000000000001','90, rue de l\'Abbé Groult','','',NULL,'Paris','','75015','France',NULL,NULL,'2022-02-28 17:23:42'),('00000270-0000-0000-0000-000000000001','VIA PORTA DI FERRO,17','','',NULL,'MIRABELLA ECLANO','','83036','Italia',NULL,NULL,'2022-02-28 17:23:42'),('00000281-0000-0000-0000-000000000001','24 AVE DE VILLIERS','','',NULL,'PARIS','','75017','France',NULL,NULL,'2022-02-28 17:23:42'),('00000289-0000-0000-0000-000000000001','','','',NULL,'','','','France',NULL,NULL,'2022-02-28 17:23:42'),('00000296-0000-0000-0000-000000000001','FERROCARRIL N 20','','',NULL,'GETAFE','','28904','España',NULL,NULL,'2022-02-28 17:23:42'),('00000297-0000-0000-0000-000000000001','40 rue abou el wakt','','',NULL,'Casablanca','','20000','Al-maɣréb',NULL,NULL,'2022-02-28 17:23:42'),('00000300-0000-0000-0000-000000000001','108 avenue victor Tuby','','',NULL,'VENCE ','','06140','France',NULL,NULL,'2022-02-28 17:23:42'),('00000310-0000-0000-0000-000000000001','1, rue Titus','','',NULL,'Nimes','','30000','France',NULL,NULL,'2022-02-28 17:23:42'),('00000318-0000-0000-0000-000000000001','via Roma,158','','',NULL,'Salerno','','84121','Italia',NULL,NULL,'2022-02-28 17:23:42'),('00000321-0000-0000-0000-000000000001','','','',NULL,'','','','',NULL,NULL,'2022-02-28 17:23:42'),('00000330-0000-0000-0000-000000000001','cc port royal','','',NULL,'le grau du roi','','30240','France',NULL,NULL,'2022-02-28 17:23:42'),('00000352-0000-0000-0000-000000000001','219 Rue La Fayette','','',NULL,'PARIS','','75010','France',NULL,NULL,'2022-02-28 17:23:42'),('00000375-0000-0000-0000-000000000001','95, Avenue de la Marne','','',NULL,'Epinay sur Seine','','93800','France',NULL,NULL,'2022-02-28 17:23:42'),('00000376-0000-0000-0000-000000000001','6 rue pasteur ','','',NULL,'marchiennes','','59870','France',NULL,NULL,'2022-02-28 17:23:42'),('00000378-0000-0000-0000-000000000001','7F-1, No.536, Sec 2, Taiwan Blvd, Taichung, Taiwan','','',NULL,'Taichung','','403','Táiwān',NULL,NULL,'2022-02-28 17:23:42'),('00000415-0000-0000-0000-000000000001','5 rue du Louis d\'Or','','',NULL,'RENNES','','35000','France',NULL,NULL,'2022-02-28 17:23:42'),('00000437-0000-0000-0000-000000000001','via L.Ricciardelli,23','','',NULL,'Caserta','','81100','Italia',NULL,NULL,'2022-02-28 17:23:42'),('00000442-0000-0000-0000-000000000001','lot la colline 2 imm le matignon 2 et N 5 Sidi Maarouf ','','',NULL,'Casablanca ','','20000','Al-maɣréb',NULL,NULL,'2022-02-28 17:23:42'),('00000448-0000-0000-0000-000000000001','','','',NULL,'','','','France',NULL,NULL,'2022-02-28 17:23:42'),('00000461-0000-0000-0000-000000000001','via Canal,18','','',NULL,'San Michele Tagliamento','','30028','Italia',NULL,NULL,'2022-02-28 17:23:42'),('00000467-0000-0000-0000-000000000001','114 RUE DE LA REPUBLIQUE','','',NULL,'EPAGNY METZ TESSY','','74330','France',NULL,NULL,'2022-02-28 17:23:42'),('00000472-0000-0000-0000-000000000001','Via Passe Buole 172','','',NULL,'Torino','','10135','Italia',NULL,NULL,'2022-02-28 17:23:42'),('00000512-0000-0000-0000-000000000001','29bis bld Thiers','','',NULL,'Chaumont','','52000','France',NULL,NULL,'2022-02-28 17:23:42'),('00000597-0000-0000-0000-000000000001','100 East Granada Blvd','','',NULL,'Ormond Beach','','32176','United States',NULL,NULL,'2022-02-28 17:23:42'),('00000650-0000-0000-0000-000000000001','','','',NULL,'','','','France',NULL,NULL,'2022-02-28 17:23:42'),('00000689-0000-0000-0000-000000000001','','','',NULL,'CHAMBERY','','','France',NULL,NULL,'2022-02-28 17:23:42');
/*!40000 ALTER TABLE `AddressInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Assistant`
--

DROP TABLE IF EXISTS `Assistant`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Assistant` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `patientRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'READ_ONLY',
  `actRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'READ_ONLY',
  `discussionRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'READ_ONLY',
  `credentialsID` char(36) DEFAULT NULL,
  `personInfoID` char(36) DEFAULT NULL COMMENT '(DC2Type:guid)',
  `phoneInfoID` char(36) DEFAULT NULL COMMENT '(DC2Type:guid)',
  `addressInfoID` char(36) DEFAULT NULL COMMENT '(DC2Type:guid)',
  `officeID` char(36) DEFAULT NULL,
  `tempPassword` varchar(32) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `lastConnection` timestamp NULL DEFAULT NULL,
  `firstConnection` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`,`ownerID`),
  UNIQUE KEY `UNIQ_4068FE723D139428` (`personInfoID`),
  UNIQUE KEY `UNIQ_4068FE72627FFEF6` (`phoneInfoID`),
  UNIQUE KEY `UNIQ_4068FE72A680FCCC` (`addressInfoID`),
  KEY `fk_Assistant_Professional` (`ownerID`),
  KEY `fk_Assistant_Office` (`officeID`,`ownerID`),
  KEY `fk_Assistant_Credentials_idx` (`credentialsID`,`id`),
  KEY `fk_Assistant_PersonInfo_idx` (`personInfoID`),
  KEY `fk_Assistant_PhoneInfo_idx` (`phoneInfoID`),
  KEY `fk_Assistant_AddressInfo_idx` (`addressInfoID`),
  CONSTRAINT `fk_Assistant_AddressInfo` FOREIGN KEY (`addressInfoID`) REFERENCES `AddressInfo` (`id`),
  CONSTRAINT `fk_Assistant_Credentials` FOREIGN KEY (`credentialsID`) REFERENCES `Credentials` (`id`),
  CONSTRAINT `fk_Assistant_Office` FOREIGN KEY (`officeID`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Assistant_PersonInfo` FOREIGN KEY (`personInfoID`) REFERENCES `PersonInfo` (`id`),
  CONSTRAINT `fk_Assistant_PhoneInfo` FOREIGN KEY (`phoneInfoID`) REFERENCES `PhoneInfo` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Assistant`
--

LOCK TABLES `Assistant` WRITE;
/*!40000 ALTER TABLE `Assistant` DISABLE KEYS */;
/*!40000 ALTER TABLE `Assistant` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `Assistant_AFTER_DELETE` AFTER DELETE ON `Assistant` FOR EACH ROW BEGIN
	DELETE FROM PersonInfo  WHERE ownerID = OLD.ownerID AND id = OLD.personInfoID;
	DELETE FROM AddressInfo WHERE ownerID = OLD.ownerID AND id = OLD.addressInfoID;
	DELETE FROM PhoneInfo   WHERE ownerID = OLD.ownerID AND id = OLD.phoneInfoID;
	DELETE FROM Credentials WHERE ownerID = OLD.ownerID AND id = OLD.credentialsID;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `CircleOrder`
--

DROP TABLE IF EXISTS `CircleOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CircleOrder` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `actID` char(36) NOT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `title` varchar(64) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `status` enum('not_sent','waiting_wow_api','sending_wow_api','sending_circle_api','sent','cancelled') NOT NULL DEFAULT 'waiting_wow_api',
  `createdAt` datetime NOT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `json` text NOT NULL,
  `metadata` text NOT NULL,
  `localDisplayID` int unsigned DEFAULT NULL,
  `globalDisplayID` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_CircleOrder_Act` (`actID`,`ownerID`),
  CONSTRAINT `fk_CircleOrder_Act` FOREIGN KEY (`actID`, `ownerID`) REFERENCES `Act` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CircleOrder`
--

LOCK TABLES `CircleOrder` WRITE;
/*!40000 ALTER TABLE `CircleOrder` DISABLE KEYS */;
/*!40000 ALTER TABLE `CircleOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CircleOrderFile`
--

DROP TABLE IF EXISTS `CircleOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CircleOrderFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `orderID` char(36) NOT NULL,
  `fileID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`orderID`,`fileID`),
  KEY `fk_CircleOrderFile_CircleOrder` (`orderID`,`ownerID`),
  KEY `fk_CircleOrderFile_CondorFile` (`fileID`,`ownerID`),
  CONSTRAINT `fk_CircleOrderFile_CircleOrder` FOREIGN KEY (`orderID`, `ownerID`) REFERENCES `CircleOrder` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_CircleOrderFile_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CircleOrderFile`
--

LOCK TABLES `CircleOrderFile` WRITE;
/*!40000 ALTER TABLE `CircleOrderFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `CircleOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CondorFile`
--

DROP TABLE IF EXISTS `CondorFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CondorFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `path` text NOT NULL,
  `type` varchar(250) NOT NULL,
  `tag` varchar(250) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `originalName` varchar(100) DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `status` enum('CREATED','UPDATED','SYNCED','ERROR') DEFAULT NULL,
  `originalID` char(36) NOT NULL,
  `version` mediumint NOT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `metadata` text,
  PRIMARY KEY (`id`,`ownerID`),
  UNIQUE KEY `un_CondorFile_version` (`ownerID`,`originalID`,`version`),
  KEY `fk_CondorFile_Professional` (`ownerID`),
  KEY `fk_CondorFile_CondorFile` (`originalID`,`ownerID`),
  CONSTRAINT `fk_CondorFile_CondorFile` FOREIGN KEY (`originalID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_CondorFile_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CondorFile`
--

LOCK TABLES `CondorFile` WRITE;
/*!40000 ALTER TABLE `CondorFile` DISABLE KEYS */;
INSERT INTO `CondorFile` VALUES (1,'0ed82613-5a79-4604-913a-a3db744d4a86','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/0ed82613-5a79-4604-913a-a3db744d4a86.bin','LIFIM','PATIENT_a9f09701-5b24-428b-bc90-90198be00a3b_ACT_d6292dcd-1fc4-46dc-aa57-869c0a087873_SESS_4ecb4fae-2dbf-44dc-9f7d-f9d015882c2b_TOSC_fb0931e8-c251-4246-93a2-6cc1d14d4bed_LIFIM_','2022-01-04 17:09:37','2022-01-04 18:09:32','0ed82613-5a79-4604-913a-a3db744d4a86.bin','2022-01-04 18:09:37','SYNCED','0ed82613-5a79-4604-913a-a3db744d4a86',0,NULL,'','','{\"displayTitle\":\"Ligne de finition Maxillaire 9.2.1.1.1 Ligne de finition 0\",\"name\":\"Ligne de finition 0\",\"title\":\"Maxillaire LIFI_META\",\"toothNumber\":0,\"versionMarginLine\":1}'),(1,'1775923a-9c97-4da7-98bd-bbb25af16874','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/1775923a-9c97-4da7-98bd-bbb25af16874.zip','ZIP','PATIENT_deb9364f-5940-46e8-927e-153c8a6ece22_ACT_790cdffb-0d7a-4eed-b8f6-d3230f7b7b7f_SESS_d196a096-7807-4361-9938-5ae3c32ac055_OCC_87e10acc-48ca-4a0d-b949-9d8c1b3f9a45_TOPLY__ZIP_','2022-01-04 17:06:33','2022-01-04 18:06:26','1775923a-9c97-4da7-98bd-bbb25af16874.zip','2022-01-04 18:06:33','SYNCED','1775923a-9c97-4da7-98bd-bbb25af16874',0,NULL,'','','{\"displayTitle\":\"Maxillaire 9.1.1.1.1 Occlusion 1\",\"modelMatrix\":\"-0.727155,0.667901,-0.158599,0,-0.686473,-0.707482,0.167998,0,1.10923e-08,0.231034,0.972946,0,8.50849,-12.4174,-13.6064,1\",\"referenceScanID\":\"9.1.1.1.1\",\"title\":\"Maxillaire 9.1.1.1.1 Occlusion 1\"}'),(1,'1b6beae2-6c83-11eb-9029-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/1b6beae2-6c83-11eb-9029-226cec7cb58a.ply','PLY','PATIENT_a730394c-024c-4469-9597-1dc64fff623b_ACT_5e6241cd-e16c-4454-8465-f82b0ebdfe75_SESS_989a5231-a11e-4601-a8bd-e423054384eb_BOSC_39f27bc4-9f14-491b-b262-aac225ef7c62_PLY_','2020-12-16 11:08:55','2020-01-31 13:56:13','1b6beae2-6c83-11eb-9029-226cec7cb58a.ply','2020-12-16 12:08:55','SYNCED','1b6beae2-6c83-11eb-9029-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 25.1.1.5.1.1\",\"modelMatrix\":\"-0.9694,0.229963,-0.0859114,0,-0.245487,-0.908099,0.339254,0,-2.69273e-9,0.349963,0.936764,0,-10.095,17.3673,-17.2107,1\",\"title\":\"MANDIBULE PLY\"}'),(1,'1b6f3f7d-6c83-11eb-9029-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/1b6f3f7d-6c83-11eb-9029-226cec7cb58a.ply','PLY','PATIENT_a730394c-024c-4469-9597-1dc64fff623b_ACT_5e6241cd-e16c-4454-8465-f82b0ebdfe75_SESS_989a5231-a11e-4601-a8bd-e423054384eb_TOSC_02475aea-8b57-48b4-94c3-c5e05b1b7939_PLY_','2021-02-11 15:57:56','2020-01-31 13:53:19','1b6f3f7d-6c83-11eb-9029-226cec7cb58a.ply','2021-02-11 16:57:56','SYNCED','1b6f3f7d-6c83-11eb-9029-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 25.1.1.5.1.1\",\"modelMatrix\":\"-0.160952,-0.956561,0.243076,0,0.986962,-0.155995,0.0396405,0,-5.32502e-10,0.246287,0.969197,0,-18.079,-27.2361,-18.8082,1\",\"title\":\"MAXILLAIRE PLY\"}'),(1,'1b70ab90-6c83-11eb-9029-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/1b70ab90-6c83-11eb-9029-226cec7cb58a.pdf','PDF','PATIENT_a730394c-024c-4469-9597-1dc64fff623b_ACT_5e6241cd-e16c-4454-8465-f82b0ebdfe75_PROST_ea8b00af-c24b-437d-89d6-226a3f4c526a_PDF_','2021-02-11 16:06:06','2021-02-11 17:06:06','1b70ab90-6c83-11eb-9029-226cec7cb58a.pdf','2021-02-11 17:06:06','SYNCED','1b70ab90-6c83-11eb-9029-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"AUTRE FICHE PROTHÉTIQUE 25.1.1.5.3 AUTRE FICHE PROTHÉTIQUE\",\"title\":\"Autre PDF\"}'),(1,'1b78edc7-6c83-11eb-9029-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/1b78edc7-6c83-11eb-9029-226cec7cb58a.json','JSON','PATIENT_a730394c-024c-4469-9597-1dc64fff623b_ACT_5e6241cd-e16c-4454-8465-f82b0ebdfe75_PROST_ea8b00af-c24b-437d-89d6-226a3f4c526a_JSON_','2021-02-11 16:06:06','2021-02-11 17:06:06','1b78edc7-6c83-11eb-9029-226cec7cb58a.json','2021-02-11 17:06:06','SYNCED','1b78edc7-6c83-11eb-9029-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"AUTRE FICHE PROTHÉTIQUE 25.1.1.5.3 AUTRE FICHE PROTHÉTIQUE\",\"title\":\"Autre JSON\"}'),(1,'1b7c4a09-6c83-11eb-9029-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/1b7c4a09-6c83-11eb-9029-226cec7cb58a.png','SNAPS','PATIENT_a730394c-024c-4469-9597-1dc64fff623b_ACT_5e6241cd-e16c-4454-8465-f82b0ebdfe75_SESS_989a5231-a11e-4601-a8bd-e423054384eb_BOSC_39f27bc4-9f14-491b-b262-aac225ef7c62_SNAPS_','2021-02-11 16:04:24','2020-01-31 13:56:13','1b7c4a09-6c83-11eb-9029-226cec7cb58a.png','2021-02-11 17:04:24','SYNCED','1b7c4a09-6c83-11eb-9029-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 25.1.1.5.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(1,'1b7ec902-6c83-11eb-9029-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/1b7ec902-6c83-11eb-9029-226cec7cb58a.png','SNAPS','PATIENT_a730394c-024c-4469-9597-1dc64fff623b_ACT_5e6241cd-e16c-4454-8465-f82b0ebdfe75_SESS_989a5231-a11e-4601-a8bd-e423054384eb_TOSC_02475aea-8b57-48b4-94c3-c5e05b1b7939_SNAPS_','2021-02-11 16:04:58','2020-01-31 13:53:19','1b7ec902-6c83-11eb-9029-226cec7cb58a.png','2021-02-11 17:04:58','SYNCED','1b7ec902-6c83-11eb-9029-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 25.1.1.5.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(1,'231e1450-52f5-11ea-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_c694559e-df5a-4c0e-b44a-30814d8c3663/231e1450-52f5-11ea-947d-226cec7cb58a.json','JSON','PATIENT_301f1364-81a6-49fd-80b7-17e87e15498d_ACT_6135bbc8-356a-44ee-986e-d702327367f2_PROST_4b5674e6-56be-438d-9be4-43375f975ea2_JSON_','2020-02-19 08:52:28','2020-02-19 09:52:27','231e1450-52f5-11ea-947d-226cec7cb58a.json','2020-02-19 09:52:28','SYNCED','231e1450-52f5-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"COURONNE 1.58.2.5 TEST SAV\",\"title\":\"Couronne JSON\"}'),(1,'231fb1de-52f5-11ea-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_c694559e-df5a-4c0e-b44a-30814d8c3663/231fb1de-52f5-11ea-947d-226cec7cb58a.pdf','PDF','PATIENT_301f1364-81a6-49fd-80b7-17e87e15498d_ACT_6135bbc8-356a-44ee-986e-d702327367f2_PROST_4b5674e6-56be-438d-9be4-43375f975ea2_PDF_','2020-02-19 08:52:29','2020-02-19 09:52:27','231fb1de-52f5-11ea-947d-226cec7cb58a.pdf','2020-02-19 09:52:29','SYNCED','231fb1de-52f5-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"COURONNE 1.58.2.5 TEST SAV\",\"title\":\"Couronne PDF\"}'),(1,'2b69902d-7db5-49bc-b867-d07508b7b4f5','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/2b69902d-7db5-49bc-b867-d07508b7b4f5.m','MATRX','PATIENT_deb9364f-5940-46e8-927e-153c8a6ece22_ACT_790cdffb-0d7a-4eed-b8f6-d3230f7b7b7f_SESS_d196a096-7807-4361-9938-5ae3c32ac055_OCC_87e10acc-48ca-4a0d-b949-9d8c1b3f9a45_BOMA__MATRX_','2022-01-04 17:06:34','2022-01-04 18:06:26','2b69902d-7db5-49bc-b867-d07508b7b4f5.m','2022-01-04 18:06:34','SYNCED','2b69902d-7db5-49bc-b867-d07508b7b4f5',0,NULL,'','','{\"displayTitle\":\"Matrice Transfo. Mandibule 9.1.1.1.1 Occlusion 1\",\"referenceScanID\":\"9.1.1.1.1\",\"title\":\"Matrice Transfo. Mandibule 9.1.1.1.1 Occlusion 1\"}'),(1,'42d0dd0a-200c-11ea-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/42d0dd0a-200c-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_748f33bc-b650-401f-9675-62687a24326b_ACT_7a0488d2-a1a7-4567-9b8a-100e1c51833a_SESS_5ff28bf4-5eef-450b-99dd-2ab84e10563e_BOSC_c0fc360d-ce29-43c2-b1f7-0ee9cafbfcf9_SNAPS_','2020-11-23 20:19:26','2019-12-16 14:57:19','42d0dd0a-200c-11ea-947d-226cec7cb58a.png','2020-11-23 21:19:26','SYNCED','42d0dd0a-200c-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.48.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(1,'42d3f726-200c-11ea-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/42d3f726-200c-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_748f33bc-b650-401f-9675-62687a24326b_ACT_7a0488d2-a1a7-4567-9b8a-100e1c51833a_SESS_5ff28bf4-5eef-450b-99dd-2ab84e10563e_BOSC_c0fc360d-ce29-43c2-b1f7-0ee9cafbfcf9_PLY_','2020-11-23 20:19:26','2019-12-16 14:57:19','42d3f726-200c-11ea-947d-226cec7cb58a.ply','2020-11-23 21:19:26','SYNCED','42d3f726-200c-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.48.1.1.1\",\"modelMatrix\":\"0.994685,-0.0670997,0.0781056,0,0.10297,0.648178,-0.754495,0,-1.39776e-10,0.758527,0.651642,0,-13.6664,-14.2297,-12.375,1\",\"title\":\"MANDIBULE PLY\"}'),(1,'4901ed4a-c329-45c0-9640-d3c8bebb7194','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/4901ed4a-c329-45c0-9640-d3c8bebb7194.zip','ZIP','PATIENT_deb9364f-5940-46e8-927e-153c8a6ece22_ACT_790cdffb-0d7a-4eed-b8f6-d3230f7b7b7f_SESS_d196a096-7807-4361-9938-5ae3c32ac055_OCC_87e10acc-48ca-4a0d-b949-9d8c1b3f9a45_BOPLY__ZIP_','2022-01-04 17:06:34','2022-01-04 18:06:26','4901ed4a-c329-45c0-9640-d3c8bebb7194.zip','2022-01-04 18:06:34','SYNCED','4901ed4a-c329-45c0-9640-d3c8bebb7194',0,NULL,'','','{\"displayTitle\":\"Mandibule 9.1.1.1.1 Occlusion 1\",\"modelMatrix\":\"0.986191,0.149244,-0.0717836,0,-0.16561,0.888734,-0.427463,0,2.78764e-09,0.433449,0.901178,0,-7.50122,-7.54044,-17.7088,1\",\"referenceScanID\":\"9.1.1.1.1\",\"title\":\"Mandibule 9.1.1.1.1 Occlusion 1\"}'),(1,'4e2caf6d-52f4-11ea-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_c694559e-df5a-4c0e-b44a-30814d8c3663/4e2caf6d-52f4-11ea-947d-226cec7cb58a.json','JSON','PATIENT_301f1364-81a6-49fd-80b7-17e87e15498d_ACT_6135bbc8-356a-44ee-986e-d702327367f2_PROST_a25cab40-a2c8-4269-a28a-33c5a5aa2e09_JSON_','2020-02-19 08:46:30','2020-02-19 09:46:30','4e2caf6d-52f4-11ea-947d-226cec7cb58a.json','2020-02-19 09:46:30','SYNCED','4e2caf6d-52f4-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"COURONNE 1.58.2.3 TEST SAV\",\"title\":\"Couronne JSON\"}'),(1,'4e2e5fe1-52f4-11ea-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_c694559e-df5a-4c0e-b44a-30814d8c3663/4e2e5fe1-52f4-11ea-947d-226cec7cb58a.pdf','PDF','PATIENT_301f1364-81a6-49fd-80b7-17e87e15498d_ACT_6135bbc8-356a-44ee-986e-d702327367f2_PROST_a25cab40-a2c8-4269-a28a-33c5a5aa2e09_PDF_','2020-02-19 08:46:31','2020-02-19 09:46:30','4e2e5fe1-52f4-11ea-947d-226cec7cb58a.pdf','2020-02-19 09:46:31','SYNCED','4e2e5fe1-52f4-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"COURONNE 1.58.2.3 TEST SAV\",\"title\":\"Couronne PDF\"}'),(1,'511f9d67-1fee-428e-b194-b2225996f40d','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/511f9d67-1fee-428e-b194-b2225996f40d.png','SNAPS','PATIENT_deb9364f-5940-46e8-927e-153c8a6ece22_ACT_790cdffb-0d7a-4eed-b8f6-d3230f7b7b7f_SESS_d196a096-7807-4361-9938-5ae3c32ac055_BOSC_a1647e89-16d2-44fb-8700-7d808c69efa0_SNAPS_','2022-01-04 17:04:47','2022-01-04 18:04:45','511f9d67-1fee-428e-b194-b2225996f40d.png','2022-01-04 18:04:47','SYNCED','511f9d67-1fee-428e-b194-b2225996f40d',0,NULL,'','','{\"displayTitle\":\"Mandibule 9.1.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1,'524a3a44-a97d-4d0e-857f-64877f93125b','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/524a3a44-a97d-4d0e-857f-64877f93125b.zip','ZIP','PATIENT_deb9364f-5940-46e8-927e-153c8a6ece22_ACT_790cdffb-0d7a-4eed-b8f6-d3230f7b7b7f_SESS_d196a096-7807-4361-9938-5ae3c32ac055_TOSC_24cd9b2e-31f0-4563-866d-f1f23b6bd6c1_ZIP_','2022-01-04 17:04:15','2022-01-04 18:04:13','524a3a44-a97d-4d0e-857f-64877f93125b.zip','2022-01-04 18:04:15','SYNCED','524a3a44-a97d-4d0e-857f-64877f93125b',0,NULL,'','','{\"displayTitle\":\"Maxillaire 9.1.1.1.1\",\"modelMatrix\":\"-0.727155,0.667901,-0.158599,0,-0.686473,-0.707482,0.167998,0,1.10923e-08,0.231034,0.972946,0,8.50849,-12.4174,-13.6064,1\",\"title\":\"Maxillaire ZIP\"}'),(1,'5c634110-decf-407a-b0d8-202b054a0c53','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/5c634110-decf-407a-b0d8-202b054a0c53.pdf','PDF','PATIENT_deb9364f-5940-46e8-927e-153c8a6ece22_ACT_790cdffb-0d7a-4eed-b8f6-d3230f7b7b7f_PROST_41c66641-788b-496e-a40d-0825d00bbd69_PDF_','2022-01-04 17:12:29','2022-01-04 18:12:28','5c634110-decf-407a-b0d8-202b054a0c53.pdf','2022-01-04 18:12:29','SYNCED','5c634110-decf-407a-b0d8-202b054a0c53',0,NULL,'','','{\"displayTitle\":\"COMMANDE 9.1.1.1 BRIDGE SUR IMPLANT test envoi\",\"title\":\"Bridge sur Implant PDF\"}'),(1,'5f312d28-d2f9-11e9-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_27bfc45b-1b14-4914-a7ca-cc01be7e4836/5f312d28-d2f9-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_420a9cf8-870a-4aa3-91e3-4edd18384b26_ACT_2c705097-bff1-4f91-85be-71377d2445c5_SESS_044c9e50-f9e3-40e1-9ac1-e0cc693e3919_TOSC_16127adf-802d-4002-ba61-0f817df6edb9_PLY_','2020-11-23 20:19:26','2019-09-09 13:52:20','5f312d28-d2f9-11e9-947d-226cec7cb58a.ply','2020-11-23 21:19:26','SYNCED','5f312d28-d2f9-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 5.1.1.1\",\"modelMatrix\":\"0.699014,-0.689049,0.191285,0,0.715108,0.673542,-0.186981,0,3.4824e-9,0.267492,0.96356,0,-12.1084,13.1635,-16.1118,1\",\"title\":\"MAXILLAIRE PLY\"}'),(1,'5f32b673-d2f9-11e9-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_27bfc45b-1b14-4914-a7ca-cc01be7e4836/5f32b673-d2f9-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_420a9cf8-870a-4aa3-91e3-4edd18384b26_ACT_2c705097-bff1-4f91-85be-71377d2445c5_SESS_044c9e50-f9e3-40e1-9ac1-e0cc693e3919_TOSC_16127adf-802d-4002-ba61-0f817df6edb9_SNAPS_','2020-11-23 20:19:26','2019-09-09 13:52:20','5f32b673-d2f9-11e9-947d-226cec7cb58a.png','2020-11-23 21:19:26','SYNCED','5f32b673-d2f9-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 5.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(1,'5f343790-d2f9-11e9-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_27bfc45b-1b14-4914-a7ca-cc01be7e4836/5f343790-d2f9-11e9-947d-226cec7cb58a.stl','STL','PATIENT_420a9cf8-870a-4aa3-91e3-4edd18384b26_ACT_2c705097-bff1-4f91-85be-71377d2445c5_SESS_044c9e50-f9e3-40e1-9ac1-e0cc693e3919_TOSC_16127adf-802d-4002-ba61-0f817df6edb9_STL_','2020-11-23 20:19:26','2019-09-09 13:52:20','5f343790-d2f9-11e9-947d-226cec7cb58a.stl','2020-11-23 21:19:26','SYNCED','5f343790-d2f9-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 5.1.1.1\",\"modelMatrix\":\"0.699014,-0.689049,0.191285,0,0.715108,0.673542,-0.186981,0,3.4824e-9,0.267492,0.96356,0,-12.1084,13.1635,-16.1118,1\",\"title\":\"MAXILLAIRE STL\"}'),(1,'6cf1bbb8-81f9-4bf1-9194-221274bd1678','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/6cf1bbb8-81f9-4bf1-9194-221274bd1678.png','SNAPS','PATIENT_a9f09701-5b24-428b-bc90-90198be00a3b_ACT_d6292dcd-1fc4-46dc-aa57-869c0a087873_SESS_4ecb4fae-2dbf-44dc-9f7d-f9d015882c2b_TOSC_fb0931e8-c251-4246-93a2-6cc1d14d4bed_SNAPS_','2022-01-04 17:09:34','2022-01-04 18:09:32','6cf1bbb8-81f9-4bf1-9194-221274bd1678.png','2022-01-04 18:09:34','SYNCED','6cf1bbb8-81f9-4bf1-9194-221274bd1678',0,NULL,'','','{\"displayTitle\":\"Maxillaire 9.2.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1,'70c5c12a-7745-11eb-9452-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/70c5c12a-7745-11eb-9452-226cec7cb58a.png','SNAPS','PATIENT_2aa6e500-959c-4ad7-b322-62edde25b391_ACT_b7bc042d-95d4-45b7-a66e-ac5645f21987_SESS_0a59fcbd-fe82-4c25-9569-c973303fa798_TOSC_3ee06446-29d1-41ad-8f5b-2df57494deda_SNAPS_','2021-02-16 16:37:57','2019-07-09 17:20:20','70c5c12a-7745-11eb-9452-226cec7cb58a.png','2021-02-16 17:37:57','SYNCED','70c5c12a-7745-11eb-9452-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 14.2.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(1,'70c8fe38-7745-11eb-9452-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/70c8fe38-7745-11eb-9452-226cec7cb58a.json','JSON','PATIENT_2aa6e500-959c-4ad7-b322-62edde25b391_ACT_b7bc042d-95d4-45b7-a66e-ac5645f21987_PROST_98424f0b-a089-49c6-8e1b-f960eb6dd6ba_JSON_','2021-02-25 08:41:35','2021-02-25 09:41:25','70c8fe38-7745-11eb-9452-226cec7cb58a.json','2021-02-25 09:41:35','SYNCED','70c8fe38-7745-11eb-9452-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"COURONNE 14.2.1.1.1 COURONNE\",\"title\":\"Couronne JSON\"}'),(1,'70cb6e30-7745-11eb-9452-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/70cb6e30-7745-11eb-9452-226cec7cb58a.png','SNAPS','PATIENT_2aa6e500-959c-4ad7-b322-62edde25b391_ACT_b7bc042d-95d4-45b7-a66e-ac5645f21987_SESS_0a59fcbd-fe82-4c25-9569-c973303fa798_BOSC_980fc19a-c1d5-43e0-8886-b39817252ba5_SNAPS_','2021-02-14 10:05:53','2019-07-09 17:23:46','70cb6e30-7745-11eb-9452-226cec7cb58a.png','2021-02-14 11:05:53','SYNCED','70cb6e30-7745-11eb-9452-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 14.2.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(1,'70cdf6b6-7745-11eb-9452-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/70cdf6b6-7745-11eb-9452-226cec7cb58a.ply','PLY','PATIENT_2aa6e500-959c-4ad7-b322-62edde25b391_ACT_b7bc042d-95d4-45b7-a66e-ac5645f21987_SESS_0a59fcbd-fe82-4c25-9569-c973303fa798_BOSC_980fc19a-c1d5-43e0-8886-b39817252ba5_PLY_','2021-02-14 10:07:51','2019-07-09 17:23:46','70cdf6b6-7745-11eb-9452-226cec7cb58a.ply','2021-02-14 11:07:51','SYNCED','70cdf6b6-7745-11eb-9452-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 14.2.1.1\",\"modelMatrix\":\"-0.983484,-0.176157,0.0415677,0,0.180995,-0.957196,0.225869,0,3.50663e-9,0.229662,0.97327,0,-27.5532,10.9078,-22.7908,1\",\"title\":\"MANDIBULE PLY\"}'),(1,'70d28461-7745-11eb-9452-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/70d28461-7745-11eb-9452-226cec7cb58a.ply','PLY','PATIENT_2aa6e500-959c-4ad7-b322-62edde25b391_ACT_b7bc042d-95d4-45b7-a66e-ac5645f21987_SESS_0a59fcbd-fe82-4c25-9569-c973303fa798_TOSC_3ee06446-29d1-41ad-8f5b-2df57494deda_PLY_','2021-02-14 10:09:06','2019-07-09 17:20:20','70d28461-7745-11eb-9452-226cec7cb58a.ply','2021-02-14 11:09:06','SYNCED','70d28461-7745-11eb-9452-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 14.2.1.1\",\"modelMatrix\":\"0.130338,-0.958063,0.255201,0,0.99147,0.125946,-0.0335486,0,3.6959e-9,0.257397,0.966306,0,-23.6704,-35.4409,-23.9508,1\",\"title\":\"MAXILLAIRE PLY\"}'),(1,'70d505f2-7745-11eb-9452-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/70d505f2-7745-11eb-9452-226cec7cb58a.pdf','PDF','PATIENT_2aa6e500-959c-4ad7-b322-62edde25b391_ACT_b7bc042d-95d4-45b7-a66e-ac5645f21987_PROST_98424f0b-a089-49c6-8e1b-f960eb6dd6ba_PDF_','2021-02-25 08:41:35','2021-02-25 09:41:25','70d505f2-7745-11eb-9452-226cec7cb58a.pdf','2021-02-25 09:41:35','SYNCED','70d505f2-7745-11eb-9452-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"COURONNE 14.2.1.1.1 COURONNE\",\"title\":\"Couronne PDF\"}'),(1,'7b979677-9030-47ab-bed9-fc2f33e5bc22','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/7b979677-9030-47ab-bed9-fc2f33e5bc22.png','SNAPS','PATIENT_deb9364f-5940-46e8-927e-153c8a6ece22_ACT_790cdffb-0d7a-4eed-b8f6-d3230f7b7b7f_SESS_d196a096-7807-4361-9938-5ae3c32ac055_OCC_87e10acc-48ca-4a0d-b949-9d8c1b3f9a45_SNAPO__SNAPS_','2022-01-04 17:06:34','2022-01-04 18:06:26','7b979677-9030-47ab-bed9-fc2f33e5bc22.png','2022-01-04 18:06:34','SYNCED','7b979677-9030-47ab-bed9-fc2f33e5bc22',0,NULL,'','','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}'),(1,'89135902-4496-4732-8b78-1b69c93e072f','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/89135902-4496-4732-8b78-1b69c93e072f.xyz','LIFI','PATIENT_a9f09701-5b24-428b-bc90-90198be00a3b_ACT_d6292dcd-1fc4-46dc-aa57-869c0a087873_SESS_4ecb4fae-2dbf-44dc-9f7d-f9d015882c2b_TOSC_fb0931e8-c251-4246-93a2-6cc1d14d4bed_LIFI_','2022-01-04 17:09:37','2022-01-04 18:09:32','89135902-4496-4732-8b78-1b69c93e072f.xyz','2022-01-04 18:09:37','SYNCED','89135902-4496-4732-8b78-1b69c93e072f',0,NULL,'','','{\"displayTitle\":\"Ligne de finition Maxillaire 9.2.1.1.1 Ligne de finition 0\",\"name\":\"Ligne de finition 0\",\"title\":\"Maxillaire LIFI\",\"toothNumber\":0,\"versionMarginLine\":1}'),(1,'967c77a0-52f5-11ea-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_c694559e-df5a-4c0e-b44a-30814d8c3663/967c77a0-52f5-11ea-947d-226cec7cb58a.pdf','PDF','PATIENT_301f1364-81a6-49fd-80b7-17e87e15498d_ACT_6135bbc8-356a-44ee-986e-d702327367f2_PROST_74a4f544-2b8d-4a9b-8c48-f04d932c60c9_PDF_','2020-02-19 08:55:42','2020-02-19 09:55:41','967c77a0-52f5-11ea-947d-226cec7cb58a.pdf','2020-02-19 09:55:42','SYNCED','967c77a0-52f5-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"COURONNE 1.58.2.6 COURONNE\",\"title\":\"Couronne PDF\"}'),(1,'967e29a6-52f5-11ea-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_c694559e-df5a-4c0e-b44a-30814d8c3663/967e29a6-52f5-11ea-947d-226cec7cb58a.json','JSON','PATIENT_301f1364-81a6-49fd-80b7-17e87e15498d_ACT_6135bbc8-356a-44ee-986e-d702327367f2_PROST_74a4f544-2b8d-4a9b-8c48-f04d932c60c9_JSON_','2020-02-19 08:55:41','2020-02-19 09:55:41','967e29a6-52f5-11ea-947d-226cec7cb58a.json','2020-02-19 09:55:41','SYNCED','967e29a6-52f5-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"COURONNE 1.58.2.6 COURONNE\",\"title\":\"Couronne JSON\"}'),(1,'9c4ee5de-0f6d-11ea-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/9c4ee5de-0f6d-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_cadfb79e-7de5-4015-97e3-269a77999943_ACT_087c4066-ec0b-4035-93aa-10a106e71f3b_SESS_076eb8ca-e04f-483c-b1b1-7caa3017af15_TOSC_619e33ae-800e-448c-a6e2-89895e888cf8_PLY_','2020-11-23 20:19:26','2019-07-01 17:33:08','9c4ee5de-0f6d-11ea-947d-226cec7cb58a.ply','2020-11-23 21:19:26','SYNCED','9c4ee5de-0f6d-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.2.1.1\",\"modelMatrix\":\"-0.556781,-0.811499,0.177381,0,0.830659,-0.543938,0.118897,0,-9.27662e-10,0.213543,0.976934,0,11.8106,-25.434,-16.8691,1\",\"title\":\"MAXILLAIRE PLY\"}'),(1,'9c50bfc0-0f6d-11ea-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/9c50bfc0-0f6d-11ea-947d-226cec7cb58a.pdf','PDF','PATIENT_cadfb79e-7de5-4015-97e3-269a77999943_ACT_087c4066-ec0b-4035-93aa-10a106e71f3b_PROST_514d3577-62f6-47d3-8fb0-0a9e4d86c6b7_PDF_','2019-12-15 21:03:21','2019-11-25 11:23:31','9c50bfc0-0f6d-11ea-947d-226cec7cb58a.pdf','2019-12-15 22:03:21','SYNCED','9c50bfc0-0f6d-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"IMPLANT CROWN 1.2.1 IMPLANT CROWN\",\"title\":\"Couronne sur Implant PDF\"}'),(1,'9c55df9d-0f6d-11ea-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/9c55df9d-0f6d-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_cadfb79e-7de5-4015-97e3-269a77999943_ACT_087c4066-ec0b-4035-93aa-10a106e71f3b_SESS_076eb8ca-e04f-483c-b1b1-7caa3017af15_BOSC_e859af83-557d-42ea-8d43-af2a6081cb66_SNAPS_','2020-11-23 20:19:26','2019-07-01 17:48:58','9c55df9d-0f6d-11ea-947d-226cec7cb58a.png','2020-11-23 21:19:26','SYNCED','9c55df9d-0f6d-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.2.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(1,'9c57fdda-0f6d-11ea-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/9c57fdda-0f6d-11ea-947d-226cec7cb58a.stl','STL','PATIENT_cadfb79e-7de5-4015-97e3-269a77999943_ACT_087c4066-ec0b-4035-93aa-10a106e71f3b_SESS_076eb8ca-e04f-483c-b1b1-7caa3017af15_TOSC_619e33ae-800e-448c-a6e2-89895e888cf8_STL_','2020-11-23 20:19:26','2019-07-01 17:33:08','9c57fdda-0f6d-11ea-947d-226cec7cb58a.stl','2020-11-23 21:19:26','SYNCED','9c57fdda-0f6d-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.2.1.1\",\"modelMatrix\":\"-0.556781,-0.811499,0.177381,0,0.830659,-0.543938,0.118897,0,-9.27662e-10,0.213543,0.976934,0,11.8106,-25.434,-16.8691,1\",\"title\":\"MAXILLAIRE STL\"}'),(1,'9c59d928-0f6d-11ea-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/9c59d928-0f6d-11ea-947d-226cec7cb58a.json','JSON','PATIENT_cadfb79e-7de5-4015-97e3-269a77999943_ACT_087c4066-ec0b-4035-93aa-10a106e71f3b_PROST_514d3577-62f6-47d3-8fb0-0a9e4d86c6b7_JSON_','2019-12-15 21:03:21','2019-11-25 11:23:31','9c59d928-0f6d-11ea-947d-226cec7cb58a.json','2019-12-15 22:03:21','SYNCED','9c59d928-0f6d-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"IMPLANT CROWN 1.2.1 IMPLANT CROWN\",\"title\":\"Couronne sur Implant JSON\"}'),(1,'9c5bb198-0f6d-11ea-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/9c5bb198-0f6d-11ea-947d-226cec7cb58a.stl','STL','PATIENT_cadfb79e-7de5-4015-97e3-269a77999943_ACT_087c4066-ec0b-4035-93aa-10a106e71f3b_SESS_076eb8ca-e04f-483c-b1b1-7caa3017af15_BOSC_e859af83-557d-42ea-8d43-af2a6081cb66_STL_','2020-11-23 20:19:26','2019-07-01 17:48:58','9c5bb198-0f6d-11ea-947d-226cec7cb58a.stl','2020-11-23 21:19:26','SYNCED','9c5bb198-0f6d-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.2.1.1\",\"modelMatrix\":\"-0.778686,-0.623945,0.0658784,0,0.627414,-0.774382,0.0817621,0,-3.45927e-9,0.105,0.994472,0,-24.8819,4.63759,-26.8087,1\",\"title\":\"MANDIBULE STL\"}'),(1,'9c5d73fb-0f6d-11ea-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/9c5d73fb-0f6d-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_cadfb79e-7de5-4015-97e3-269a77999943_ACT_087c4066-ec0b-4035-93aa-10a106e71f3b_SESS_076eb8ca-e04f-483c-b1b1-7caa3017af15_BOSC_e859af83-557d-42ea-8d43-af2a6081cb66_PLY_','2020-11-23 20:19:26','2019-07-01 17:48:58','9c5d73fb-0f6d-11ea-947d-226cec7cb58a.ply','2020-11-23 21:19:26','SYNCED','9c5d73fb-0f6d-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.2.1.1\",\"modelMatrix\":\"-0.778686,-0.623945,0.0658784,0,0.627414,-0.774382,0.0817621,0,-3.45927e-9,0.105,0.994472,0,-24.8819,4.63759,-26.8087,1\",\"title\":\"MANDIBULE PLY\"}'),(1,'9c60ed3f-0f6d-11ea-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/9c60ed3f-0f6d-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_cadfb79e-7de5-4015-97e3-269a77999943_ACT_087c4066-ec0b-4035-93aa-10a106e71f3b_SESS_076eb8ca-e04f-483c-b1b1-7caa3017af15_TOSC_619e33ae-800e-448c-a6e2-89895e888cf8_SNAPS_','2020-11-23 20:19:26','2019-07-01 17:33:08','9c60ed3f-0f6d-11ea-947d-226cec7cb58a.png','2020-11-23 21:19:26','SYNCED','9c60ed3f-0f6d-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.2.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(1,'9e661861-d15d-41fa-b8d5-fd4fa1216cf3','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/9e661861-d15d-41fa-b8d5-fd4fa1216cf3.pdf','PDF','PATIENT_a9f09701-5b24-428b-bc90-90198be00a3b_ACT_d6292dcd-1fc4-46dc-aa57-869c0a087873_PROST_b837914a-512d-401a-9135-90efadefadf6_PDF_','2022-01-04 17:17:18','2022-01-04 18:17:17','9e661861-d15d-41fa-b8d5-fd4fa1216cf3.pdf','2022-01-04 18:17:18','SYNCED','9e661861-d15d-41fa-b8d5-fd4fa1216cf3',0,NULL,'','','{\"displayTitle\":\"COMMANDE 9.2.1.1 COURONNE SUR IMPLANT\",\"title\":\"Couronne sur Implant PDF\"}'),(1,'9eeee60f-d2f8-11e9-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_27bfc45b-1b14-4914-a7ca-cc01be7e4836/9eeee60f-d2f8-11e9-947d-226cec7cb58a.stl','STL','PATIENT_420a9cf8-870a-4aa3-91e3-4edd18384b26_ACT_2c705097-bff1-4f91-85be-71377d2445c5_SESS_044c9e50-f9e3-40e1-9ac1-e0cc693e3919_BOSTL__STL_','2020-11-23 20:19:26','2019-09-09 13:54:15','9eeee60f-d2f8-11e9-947d-226cec7cb58a.stl','2020-11-23 21:19:26','SYNCED','9eeee60f-d2f8-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Occlusion Mandible 5.1.1.1\",\"title\":\"Occlusion Mandible STL\"}'),(1,'9ef00a1e-d2f8-11e9-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_27bfc45b-1b14-4914-a7ca-cc01be7e4836/9ef00a1e-d2f8-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_420a9cf8-870a-4aa3-91e3-4edd18384b26_ACT_2c705097-bff1-4f91-85be-71377d2445c5_SESS_044c9e50-f9e3-40e1-9ac1-e0cc693e3919_RISC_c80efb5e-d10d-4812-8a06-b126d3b2d876_SNAPS_','2020-11-23 20:19:26','2019-09-09 13:54:03','9ef00a1e-d2f8-11e9-947d-226cec7cb58a.png','2020-11-23 21:19:26','SYNCED','9ef00a1e-d2f8-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MORDU_POSTERIEUR_DROIT 5.1.1.1\",\"title\":\"MORDU_POSTERIEUR_DROIT SNAPSHOT\"}'),(1,'9ef14755-d2f8-11e9-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_27bfc45b-1b14-4914-a7ca-cc01be7e4836/9ef14755-d2f8-11e9-947d-226cec7cb58a.json','JSON','PATIENT_420a9cf8-870a-4aa3-91e3-4edd18384b26_ACT_2c705097-bff1-4f91-85be-71377d2445c5_PROST_003fb487-7387-4847-a52b-4100117c91b6_JSON_','2019-12-15 21:03:21','2019-09-09 13:54:55','9ef14755-d2f8-11e9-947d-226cec7cb58a.json','2019-12-15 22:03:21','SYNCED','9ef14755-d2f8-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"CROWN 5.1.1 CROWN\",\"title\":\"Couronne JSON\"}'),(1,'9ef2bf13-d2f8-11e9-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_27bfc45b-1b14-4914-a7ca-cc01be7e4836/9ef2bf13-d2f8-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_420a9cf8-870a-4aa3-91e3-4edd18384b26_ACT_2c705097-bff1-4f91-85be-71377d2445c5_SESS_044c9e50-f9e3-40e1-9ac1-e0cc693e3919_OCC_044c9e50-f9e3-40e1-9ac1-e0cmigraoccl_BOPLY__PLY_','2020-11-23 20:20:01','2019-09-09 13:54:15','9ef2bf13-d2f8-11e9-947d-226cec7cb58a.ply','2020-11-23 21:20:01','SYNCED','9ef2bf13-d2f8-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Occlusion Mandible 5.1.1.1\",\"title\":\"Occlusion Mandible PLY\"}'),(1,'9ef42a93-d2f8-11e9-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_27bfc45b-1b14-4914-a7ca-cc01be7e4836/9ef42a93-d2f8-11e9-947d-226cec7cb58a.stl','STL','PATIENT_420a9cf8-870a-4aa3-91e3-4edd18384b26_ACT_2c705097-bff1-4f91-85be-71377d2445c5_SESS_044c9e50-f9e3-40e1-9ac1-e0cc693e3919_BOSC_02aa796c-c4a0-461e-9800-96494613700e_STL_','2020-11-23 20:19:26','2019-09-09 13:53:11','9ef42a93-d2f8-11e9-947d-226cec7cb58a.stl','2020-11-23 21:19:26','SYNCED','9ef42a93-d2f8-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 5.1.1.1\",\"modelMatrix\":\"0.977566,-0.204396,0.050863,0,0.210629,0.948635,-0.236064,0,4.65372e-9,0.241481,0.970406,0,-18.2786,2.75037,-17.0393,1\",\"title\":\"MANDIBULE STL\"}'),(1,'9ef5fa77-d2f8-11e9-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_27bfc45b-1b14-4914-a7ca-cc01be7e4836/9ef5fa77-d2f8-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_420a9cf8-870a-4aa3-91e3-4edd18384b26_ACT_2c705097-bff1-4f91-85be-71377d2445c5_SESS_044c9e50-f9e3-40e1-9ac1-e0cc693e3919_TOSC_16127adf-802d-4002-ba61-0f817df6edb9_PLY_','2020-11-23 20:19:26','2019-09-09 13:52:20','9ef5fa77-d2f8-11e9-947d-226cec7cb58a.ply','2020-11-23 21:19:26','SYNCED','9ef5fa77-d2f8-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 5.1.1.1\",\"modelMatrix\":\"0.699014,-0.689049,0.191285,0,0.715108,0.673542,-0.186981,0,3.4824e-9,0.267492,0.96356,0,-12.1084,13.1635,-16.1118,1\",\"title\":\"MAXILLAIRE PLY\"}'),(1,'9ef817f9-d2f8-11e9-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_27bfc45b-1b14-4914-a7ca-cc01be7e4836/9ef817f9-d2f8-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_420a9cf8-870a-4aa3-91e3-4edd18384b26_ACT_2c705097-bff1-4f91-85be-71377d2445c5_SESS_044c9e50-f9e3-40e1-9ac1-e0cc693e3919_OCC_044c9e50-f9e3-40e1-9ac1-e0cmigraoccl_TOPLY__PLY_','2020-11-23 20:20:01','2019-09-09 13:54:15','9ef817f9-d2f8-11e9-947d-226cec7cb58a.ply','2020-11-23 21:20:01','SYNCED','9ef817f9-d2f8-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Occlusion Maxilla 5.1.1.1\",\"title\":\"Occlusion Maxilla PLY\"}'),(1,'9ef98b11-d2f8-11e9-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_27bfc45b-1b14-4914-a7ca-cc01be7e4836/9ef98b11-d2f8-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_420a9cf8-870a-4aa3-91e3-4edd18384b26_ACT_2c705097-bff1-4f91-85be-71377d2445c5_SESS_044c9e50-f9e3-40e1-9ac1-e0cc693e3919_TOSC_16127adf-802d-4002-ba61-0f817df6edb9_SNAPS_','2020-11-23 20:19:26','2019-09-09 13:52:20','9ef98b11-d2f8-11e9-947d-226cec7cb58a.png','2020-11-23 21:19:26','SYNCED','9ef98b11-d2f8-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 5.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(1,'9efb1498-d2f8-11e9-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_27bfc45b-1b14-4914-a7ca-cc01be7e4836/9efb1498-d2f8-11e9-947d-226cec7cb58a.stl','STL','PATIENT_420a9cf8-870a-4aa3-91e3-4edd18384b26_ACT_2c705097-bff1-4f91-85be-71377d2445c5_SESS_044c9e50-f9e3-40e1-9ac1-e0cc693e3919_RISC_c80efb5e-d10d-4812-8a06-b126d3b2d876_STL_','2020-11-23 20:19:26','2019-09-09 13:54:03','9efb1498-d2f8-11e9-947d-226cec7cb58a.stl','2020-11-23 21:19:26','SYNCED','9efb1498-d2f8-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MORDU_POSTERIEUR_DROIT 5.1.1.1\",\"modelMatrix\":\"0.997041,0.00505937,-0.0771076,0,0.0018396,0.996057,0.0887989,0,0.0768442,-0.0885698,0.993061,0,-25.0783,0.603185,-17.5727,1\",\"title\":\"MORDU_POSTERIEUR_DROIT STL\"}'),(1,'9efc8085-d2f8-11e9-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_27bfc45b-1b14-4914-a7ca-cc01be7e4836/9efc8085-d2f8-11e9-947d-226cec7cb58a.ply','CONTACT','PATIENT_420a9cf8-870a-4aa3-91e3-4edd18384b26_ACT_2c705097-bff1-4f91-85be-71377d2445c5_SESS_044c9e50-f9e3-40e1-9ac1-e0cc693e3919_BOCO__CONTACT_','2020-11-23 20:19:26','2019-09-09 13:54:15','9efc8085-d2f8-11e9-947d-226cec7cb58a.ply','2020-11-23 21:19:26','SYNCED','9efc8085-d2f8-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Occlusion Mandible Contact Points 5.1.1.1\",\"title\":\"Occlusion Mandible Contact Points CONTACT\"}'),(1,'9efd8d64-d2f8-11e9-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_27bfc45b-1b14-4914-a7ca-cc01be7e4836/9efd8d64-d2f8-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_420a9cf8-870a-4aa3-91e3-4edd18384b26_ACT_2c705097-bff1-4f91-85be-71377d2445c5_SESS_044c9e50-f9e3-40e1-9ac1-e0cc693e3919_RISC_c80efb5e-d10d-4812-8a06-b126d3b2d876_PLY_','2020-11-23 20:19:26','2019-09-09 13:54:03','9efd8d64-d2f8-11e9-947d-226cec7cb58a.ply','2020-11-23 21:19:26','SYNCED','9efd8d64-d2f8-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MORDU_POSTERIEUR_DROIT 5.1.1.1\",\"modelMatrix\":\"0.997041,0.00505937,-0.0771076,0,0.0018396,0.996057,0.0887989,0,0.0768442,-0.0885698,0.993061,0,-25.0783,0.603185,-17.5727,1\",\"title\":\"MORDU_POSTERIEUR_DROIT PLY\"}'),(1,'9efec958-d2f8-11e9-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_27bfc45b-1b14-4914-a7ca-cc01be7e4836/9efec958-d2f8-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_420a9cf8-870a-4aa3-91e3-4edd18384b26_ACT_2c705097-bff1-4f91-85be-71377d2445c5_SESS_044c9e50-f9e3-40e1-9ac1-e0cc693e3919_BOSC_02aa796c-c4a0-461e-9800-96494613700e_SNAPS_','2020-11-23 20:19:26','2019-09-09 13:53:11','9efec958-d2f8-11e9-947d-226cec7cb58a.png','2020-11-23 21:19:26','SYNCED','9efec958-d2f8-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 5.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(1,'9f003ab0-d2f8-11e9-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_27bfc45b-1b14-4914-a7ca-cc01be7e4836/9f003ab0-d2f8-11e9-947d-226cec7cb58a.m','MATRX','PATIENT_420a9cf8-870a-4aa3-91e3-4edd18384b26_ACT_2c705097-bff1-4f91-85be-71377d2445c5_SESS_044c9e50-f9e3-40e1-9ac1-e0cc693e3919_OCC_044c9e50-f9e3-40e1-9ac1-e0cmigraoccl_TOMA__MATRX_','2020-11-23 20:20:01','2019-09-09 13:54:15','9f003ab0-d2f8-11e9-947d-226cec7cb58a.m','2020-11-23 21:20:01','SYNCED','9f003ab0-d2f8-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxilla Transformation Matrix 5.1.1.1\",\"title\":\"Maxilla Transformation Matrix MATRIX\"}'),(1,'9f01d2ce-d2f8-11e9-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_27bfc45b-1b14-4914-a7ca-cc01be7e4836/9f01d2ce-d2f8-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_420a9cf8-870a-4aa3-91e3-4edd18384b26_ACT_2c705097-bff1-4f91-85be-71377d2445c5_SESS_044c9e50-f9e3-40e1-9ac1-e0cc693e3919_BOSC_02aa796c-c4a0-461e-9800-96494613700e_PLY_','2020-11-23 20:19:26','2019-09-09 13:53:11','9f01d2ce-d2f8-11e9-947d-226cec7cb58a.ply','2020-11-23 21:19:26','SYNCED','9f01d2ce-d2f8-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 5.1.1.1\",\"modelMatrix\":\"0.977566,-0.204396,0.050863,0,0.210629,0.948635,-0.236064,0,4.65372e-9,0.241481,0.970406,0,-18.2786,2.75037,-17.0393,1\",\"title\":\"MANDIBULE PLY\"}'),(1,'9f03438b-d2f8-11e9-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_27bfc45b-1b14-4914-a7ca-cc01be7e4836/9f03438b-d2f8-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_420a9cf8-870a-4aa3-91e3-4edd18384b26_ACT_2c705097-bff1-4f91-85be-71377d2445c5_SESS_044c9e50-f9e3-40e1-9ac1-e0cc693e3919_OCC_044c9e50-f9e3-40e1-9ac1-e0cmigraoccl_SNAPO__SNAPS_','2020-11-23 20:20:01','2019-09-09 13:54:15','9f03438b-d2f8-11e9-947d-226cec7cb58a.png','2020-11-23 21:20:01','SYNCED','9f03438b-d2f8-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Snapshot 5.1.1.1\",\"title\":\"Snapshot SNAPSHOT\"}'),(1,'9f04b15e-d2f8-11e9-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_27bfc45b-1b14-4914-a7ca-cc01be7e4836/9f04b15e-d2f8-11e9-947d-226cec7cb58a.stl','STL','PATIENT_420a9cf8-870a-4aa3-91e3-4edd18384b26_ACT_2c705097-bff1-4f91-85be-71377d2445c5_SESS_044c9e50-f9e3-40e1-9ac1-e0cc693e3919_TOSTL__STL_','2020-11-23 20:19:26','2019-09-09 13:54:15','9f04b15e-d2f8-11e9-947d-226cec7cb58a.stl','2020-11-23 21:19:26','SYNCED','9f04b15e-d2f8-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Occlusion Maxilla 5.1.1.1\",\"title\":\"Occlusion Maxilla STL\"}'),(1,'9f061859-d2f8-11e9-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_27bfc45b-1b14-4914-a7ca-cc01be7e4836/9f061859-d2f8-11e9-947d-226cec7cb58a.ply','CONTACT','PATIENT_420a9cf8-870a-4aa3-91e3-4edd18384b26_ACT_2c705097-bff1-4f91-85be-71377d2445c5_SESS_044c9e50-f9e3-40e1-9ac1-e0cc693e3919_TOCO__CONTACT_','2020-11-23 20:19:26','2019-09-09 13:54:15','9f061859-d2f8-11e9-947d-226cec7cb58a.ply','2020-11-23 21:19:26','SYNCED','9f061859-d2f8-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Occlusion Maxilla Contact Points 5.1.1.1\",\"title\":\"Occlusion Maxilla Contact Points CONTACT\"}'),(1,'9f0734ec-d2f8-11e9-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_27bfc45b-1b14-4914-a7ca-cc01be7e4836/9f0734ec-d2f8-11e9-947d-226cec7cb58a.stl','STL','PATIENT_420a9cf8-870a-4aa3-91e3-4edd18384b26_ACT_2c705097-bff1-4f91-85be-71377d2445c5_SESS_044c9e50-f9e3-40e1-9ac1-e0cc693e3919_TOSC_16127adf-802d-4002-ba61-0f817df6edb9_STL_','2020-11-23 20:19:26','2019-09-09 13:52:20','9f0734ec-d2f8-11e9-947d-226cec7cb58a.stl','2020-11-23 21:19:26','SYNCED','9f0734ec-d2f8-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 5.1.1.1\",\"modelMatrix\":\"0.699014,-0.689049,0.191285,0,0.715108,0.673542,-0.186981,0,3.4824e-9,0.267492,0.96356,0,-12.1084,13.1635,-16.1118,1\",\"title\":\"MAXILLAIRE STL\"}'),(1,'9f085904-d2f8-11e9-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_27bfc45b-1b14-4914-a7ca-cc01be7e4836/9f085904-d2f8-11e9-947d-226cec7cb58a.m','MATRX','PATIENT_420a9cf8-870a-4aa3-91e3-4edd18384b26_ACT_2c705097-bff1-4f91-85be-71377d2445c5_SESS_044c9e50-f9e3-40e1-9ac1-e0cc693e3919_OCC_044c9e50-f9e3-40e1-9ac1-e0cmigraoccl_BOMA__MATRX_','2020-11-23 20:20:01','2019-09-09 13:54:15','9f085904-d2f8-11e9-947d-226cec7cb58a.m','2020-11-23 21:20:01','SYNCED','9f085904-d2f8-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandible Transformation Matrix 5.1.1.1\",\"title\":\"Mandible Transformation Matrix MATRIX\"}'),(1,'9f0a1ebf-d2f8-11e9-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_27bfc45b-1b14-4914-a7ca-cc01be7e4836/9f0a1ebf-d2f8-11e9-947d-226cec7cb58a.pdf','PDF','PATIENT_420a9cf8-870a-4aa3-91e3-4edd18384b26_ACT_2c705097-bff1-4f91-85be-71377d2445c5_PROST_003fb487-7387-4847-a52b-4100117c91b6_PDF_','2019-12-15 21:03:21','2019-09-09 13:54:55','9f0a1ebf-d2f8-11e9-947d-226cec7cb58a.pdf','2019-12-15 22:03:21','SYNCED','9f0a1ebf-d2f8-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"CROWN 5.1.1 CROWN\",\"title\":\"Couronne PDF\"}'),(1,'a13f6a75-c3e1-40b7-886c-443a5559b3c4','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/a13f6a75-c3e1-40b7-886c-443a5559b3c4.zip','ZIP','PATIENT_deb9364f-5940-46e8-927e-153c8a6ece22_ACT_790cdffb-0d7a-4eed-b8f6-d3230f7b7b7f_SESS_d196a096-7807-4361-9938-5ae3c32ac055_LESC_88fdf17b-5e15-484a-a53b-219025fd1eb2_ZIP_','2022-01-04 17:05:07','2022-01-04 18:05:06','a13f6a75-c3e1-40b7-886c-443a5559b3c4.zip','2022-01-04 18:05:07','SYNCED','a13f6a75-c3e1-40b7-886c-443a5559b3c4',0,NULL,'','','{\"displayTitle\":\"Mordu posterieur gauche 9.1.1.1.1\",\"modelMatrix\":\"-0.995438,-0.0381698,-0.0866569,0,0.0340621,-0.998405,0.0444346,0,-0.0891334,0.0415943,0.995247,0,10.015,-3.15961,-15.4123,1\",\"title\":\"Mordu posterieur gauche ZIP\"}'),(1,'a5632e02-7160-4bf9-be22-52212d381e60','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/a5632e02-7160-4bf9-be22-52212d381e60.png','SNAPS','PATIENT_deb9364f-5940-46e8-927e-153c8a6ece22_ACT_790cdffb-0d7a-4eed-b8f6-d3230f7b7b7f_SESS_d196a096-7807-4361-9938-5ae3c32ac055_TOSC_24cd9b2e-31f0-4563-866d-f1f23b6bd6c1_SNAPS_','2022-01-04 17:04:15','2022-01-04 18:04:13','a5632e02-7160-4bf9-be22-52212d381e60.png','2022-01-04 18:04:15','SYNCED','a5632e02-7160-4bf9-be22-52212d381e60',0,NULL,'','','{\"displayTitle\":\"Maxillaire 9.1.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1,'ab8a7a6d-d2f8-11e9-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_27bfc45b-1b14-4914-a7ca-cc01be7e4836/ab8a7a6d-d2f8-11e9-947d-226cec7cb58a.pdf','PDF','PATIENT_420a9cf8-870a-4aa3-91e3-4edd18384b26_ACT_2c705097-bff1-4f91-85be-71377d2445c5_PROST_0002a210-1ab5-44a7-bbbf-757b363dd744_PDF_','2019-12-15 21:03:21','2019-09-09 13:55:17','ab8a7a6d-d2f8-11e9-947d-226cec7cb58a.pdf','2019-12-15 22:03:21','SYNCED','ab8a7a6d-d2f8-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"INLAY ONLAY 5.1.1 INLAY ONLAY\",\"title\":\"Inlay/Onlay PDF\"}'),(1,'ab8bbe5f-d2f8-11e9-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_27bfc45b-1b14-4914-a7ca-cc01be7e4836/ab8bbe5f-d2f8-11e9-947d-226cec7cb58a.json','JSON','PATIENT_420a9cf8-870a-4aa3-91e3-4edd18384b26_ACT_2c705097-bff1-4f91-85be-71377d2445c5_PROST_0002a210-1ab5-44a7-bbbf-757b363dd744_JSON_','2019-12-15 21:03:21','2019-09-09 13:55:17','ab8bbe5f-d2f8-11e9-947d-226cec7cb58a.json','2019-12-15 22:03:21','SYNCED','ab8bbe5f-d2f8-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"INLAY ONLAY 5.1.1 INLAY ONLAY\",\"title\":\"Inlay/Onlay JSON\"}'),(1,'abc5f451-4a84-4b1a-a638-c3301e985061','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/abc5f451-4a84-4b1a-a638-c3301e985061.zip','ZIP','PATIENT_deb9364f-5940-46e8-927e-153c8a6ece22_ACT_790cdffb-0d7a-4eed-b8f6-d3230f7b7b7f_SESS_d196a096-7807-4361-9938-5ae3c32ac055_BOSC_a1647e89-16d2-44fb-8700-7d808c69efa0_ZIP_','2022-01-04 17:04:47','2022-01-04 18:04:46','abc5f451-4a84-4b1a-a638-c3301e985061.zip','2022-01-04 18:04:47','SYNCED','abc5f451-4a84-4b1a-a638-c3301e985061',0,NULL,'','','{\"displayTitle\":\"Mandibule 9.1.1.1.1\",\"modelMatrix\":\"0.986191,0.149244,-0.0717836,0,-0.16561,0.888734,-0.427463,0,2.78764e-09,0.433449,0.901178,0,-7.50122,-7.54044,-17.7088,1\",\"title\":\"Mandibule ZIP\"}'),(1,'b5126a58-6d82-11ec-9377-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/b5126a58-6d82-11ec-9377-226cec7cb58a.pdf','PDF','PATIENT_bfff99cf-e91f-4eed-bb3a-06bece8eaf9f_ACT_b7c84d8c-fbc4-465a-ac48-6c183da143a6_PROST_802d0fb1-8694-41b7-8790-de8a2aac4073_PDF_','2022-01-04 17:21:09','2022-01-04 18:21:07','b5126a58-6d82-11ec-9377-226cec7cb58a.pdf','2022-01-04 18:21:09','SYNCED','b5126a58-6d82-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"COMMANDE 20.1.1.2.1 BRIDGE SUR IMPLANT\",\"title\":\"Bridge sur Implant PDF\"}'),(1,'b517441f-6d82-11ec-9377-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/b517441f-6d82-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_bfff99cf-e91f-4eed-bb3a-06bece8eaf9f_ACT_b7c84d8c-fbc4-465a-ac48-6c183da143a6_SESS_11809b61-25e7-46d5-bf47-cd02b888e7ae_TOSC_7d7a0827-7efd-49c9-821e-fe36b7e07a14_SNAPS_','2021-02-11 15:59:41','2020-03-12 15:25:00','b517441f-6d82-11ec-9377-226cec7cb58a.png','2021-02-11 16:59:41','SYNCED','b517441f-6d82-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 20.1.1.2.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(1,'b51ad64d-6d82-11ec-9377-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/b51ad64d-6d82-11ec-9377-226cec7cb58a.ply','PLY','PATIENT_bfff99cf-e91f-4eed-bb3a-06bece8eaf9f_ACT_b7c84d8c-fbc4-465a-ac48-6c183da143a6_SESS_11809b61-25e7-46d5-bf47-cd02b888e7ae_TOSC_7d7a0827-7efd-49c9-821e-fe36b7e07a14_PLY_','2021-02-11 16:12:52','2020-03-12 15:25:00','b51ad64d-6d82-11ec-9377-226cec7cb58a.ply','2021-02-11 17:12:52','SYNCED','b51ad64d-6d82-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 20.1.1.2.1.1\",\"modelMatrix\":\"0.176498,-0.938781,0.29587,0,0.984301,0.168335,-0.0530533,0,2.44693e-9,0.300589,0.953754,0,-17.1177,-30.9431,-23.3501,1\",\"title\":\"MAXILLAIRE PLY\"}'),(1,'c7f8f656-d2f9-11e9-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_27bfc45b-1b14-4914-a7ca-cc01be7e4836/c7f8f656-d2f9-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_420a9cf8-870a-4aa3-91e3-4edd18384b26_ACT_2c705097-bff1-4f91-85be-71377d2445c5_SESS_044c9e50-f9e3-40e1-9ac1-e0cc693e3919_TOSC_16127adf-802d-4002-ba61-0f817df6edb9_PLY_','2020-11-23 20:19:26','2019-09-09 13:52:20','c7f8f656-d2f9-11e9-947d-226cec7cb58a.ply','2020-11-23 21:19:26','SYNCED','c7f8f656-d2f9-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 5.1.1.1\",\"modelMatrix\":\"0.699014,-0.689049,0.191285,0,0.715108,0.673542,-0.186981,0,3.4824e-9,0.267492,0.96356,0,-12.1084,13.1635,-16.1118,1\",\"title\":\"MAXILLAIRE PLY\"}'),(1,'c7fa52fb-d2f9-11e9-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_27bfc45b-1b14-4914-a7ca-cc01be7e4836/c7fa52fb-d2f9-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_420a9cf8-870a-4aa3-91e3-4edd18384b26_ACT_2c705097-bff1-4f91-85be-71377d2445c5_SESS_044c9e50-f9e3-40e1-9ac1-e0cc693e3919_TOSC_16127adf-802d-4002-ba61-0f817df6edb9_SNAPS_','2020-11-23 20:19:26','2019-09-09 13:52:20','c7fa52fb-d2f9-11e9-947d-226cec7cb58a.png','2020-11-23 21:19:26','SYNCED','c7fa52fb-d2f9-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 5.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(1,'c7fb7a13-d2f9-11e9-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_27bfc45b-1b14-4914-a7ca-cc01be7e4836/c7fb7a13-d2f9-11e9-947d-226cec7cb58a.pdf','PDF','PATIENT_420a9cf8-870a-4aa3-91e3-4edd18384b26_ACT_2c705097-bff1-4f91-85be-71377d2445c5_PROST_db74ac5c-6e2c-401c-a39c-90fe64c95afb_PDF_','2019-12-15 21:03:21','2019-09-09 14:03:14','c7fb7a13-d2f9-11e9-947d-226cec7cb58a.pdf','2019-12-15 22:03:21','SYNCED','c7fb7a13-d2f9-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"CROWN 5.1.1 CROWN\",\"title\":\"Couronne PDF\"}'),(1,'c7fcad60-d2f9-11e9-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_27bfc45b-1b14-4914-a7ca-cc01be7e4836/c7fcad60-d2f9-11e9-947d-226cec7cb58a.json','JSON','PATIENT_420a9cf8-870a-4aa3-91e3-4edd18384b26_ACT_2c705097-bff1-4f91-85be-71377d2445c5_PROST_db74ac5c-6e2c-401c-a39c-90fe64c95afb_JSON_','2019-12-15 21:03:21','2019-09-09 14:03:14','c7fcad60-d2f9-11e9-947d-226cec7cb58a.json','2019-12-15 22:03:21','SYNCED','c7fcad60-d2f9-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"CROWN 5.1.1 CROWN\",\"title\":\"Couronne JSON\"}'),(1,'c7fddf4d-d2f9-11e9-947d-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_27bfc45b-1b14-4914-a7ca-cc01be7e4836/c7fddf4d-d2f9-11e9-947d-226cec7cb58a.stl','STL','PATIENT_420a9cf8-870a-4aa3-91e3-4edd18384b26_ACT_2c705097-bff1-4f91-85be-71377d2445c5_SESS_044c9e50-f9e3-40e1-9ac1-e0cc693e3919_TOSC_16127adf-802d-4002-ba61-0f817df6edb9_STL_','2020-11-23 20:19:26','2019-09-09 13:52:20','c7fddf4d-d2f9-11e9-947d-226cec7cb58a.stl','2020-11-23 21:19:26','SYNCED','c7fddf4d-d2f9-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 5.1.1.1\",\"modelMatrix\":\"0.699014,-0.689049,0.191285,0,0.715108,0.673542,-0.186981,0,3.4824e-9,0.267492,0.96356,0,-12.1084,13.1635,-16.1118,1\",\"title\":\"MAXILLAIRE STL\"}'),(1,'cc632090-c3fb-4514-b2b4-98f3ea617ff8','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/cc632090-c3fb-4514-b2b4-98f3ea617ff8.m','MATRX','PATIENT_deb9364f-5940-46e8-927e-153c8a6ece22_ACT_790cdffb-0d7a-4eed-b8f6-d3230f7b7b7f_SESS_d196a096-7807-4361-9938-5ae3c32ac055_OCC_87e10acc-48ca-4a0d-b949-9d8c1b3f9a45_TOMA__MATRX_','2022-01-04 17:06:34','2022-01-04 18:06:26','cc632090-c3fb-4514-b2b4-98f3ea617ff8.m','2022-01-04 18:06:34','SYNCED','cc632090-c3fb-4514-b2b4-98f3ea617ff8',0,NULL,'','','{\"displayTitle\":\"Matrice Transfo. Maxillaire 9.1.1.1.1 Occlusion 1\",\"referenceScanID\":\"9.1.1.1.1\",\"title\":\"Matrice Transfo. Maxillaire 9.1.1.1.1 Occlusion 1\"}'),(1,'d7683e95-c742-4f93-9466-8b626d306032','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/d7683e95-c742-4f93-9466-8b626d306032.ply','PLY','PATIENT_a9f09701-5b24-428b-bc90-90198be00a3b_ACT_d6292dcd-1fc4-46dc-aa57-869c0a087873_SESS_4ecb4fae-2dbf-44dc-9f7d-f9d015882c2b_TOSC_fb0931e8-c251-4246-93a2-6cc1d14d4bed_PLY_','2022-01-04 17:09:37','2022-01-04 18:09:32','d7683e95-c742-4f93-9466-8b626d306032.ply','2022-01-04 18:09:37','SYNCED','d7683e95-c742-4f93-9466-8b626d306032',0,NULL,'','','{\"displayTitle\":\"Maxillaire 9.2.1.1.1\",\"modelMatrix\":\"0.745306,-0.659524,0.0977101,0,0.666723,0.737259,-0.109227,0,3.87132e-10,0.146553,0.989203,0,-31.4908,-2.28884,-22.4832,1\",\"title\":\"Maxillaire PLY\"}'),(1,'f1d25c24-6d80-11ec-9377-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/f1d25c24-6d80-11ec-9377-226cec7cb58a.ply','PLY','PATIENT_9a7fb011-3358-4d3c-a11d-cb262db47e63_ACT_8d3d24a8-8497-455b-a175-3c2ad080b066_SESS_4c947a81-1ce1-4f4b-9ced-98099e5c9e41_BOSC_1c6e5ffe-c555-4036-96c1-ff9513f7fd5d_PLY_','2021-12-30 18:04:09','2019-07-09 12:42:55','f1d25c24-6d80-11ec-9377-226cec7cb58a.ply','2021-12-30 19:04:09','SYNCED','f1d25c24-6d80-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 11.1.2.1\",\"modelMatrix\":\"-0.909132,-0.380167,0.170155,0,0.416509,-0.829806,0.371405,0,-8.74546e-9,0.408527,0.912746,0,10.0823,12.935,-19.3284,1\",\"title\":\"MANDIBULE PLY\"}'),(1,'f1d61263-6d80-11ec-9377-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/f1d61263-6d80-11ec-9377-226cec7cb58a.ply','PLY','PATIENT_9a7fb011-3358-4d3c-a11d-cb262db47e63_ACT_8d3d24a8-8497-455b-a175-3c2ad080b066_SESS_4c947a81-1ce1-4f4b-9ced-98099e5c9e41_TOSC_6c77a427-9c36-4753-9c20-b37adb53412f_PLY_','2021-12-30 18:04:11','2019-07-09 12:38:40','f1d61263-6d80-11ec-9377-226cec7cb58a.ply','2021-12-30 19:04:11','SYNCED','f1d61263-6d80-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 11.1.2.1\",\"modelMatrix\":\"0.745306,-0.659524,0.0977101,0,0.666723,0.737259,-0.109227,0,3.87132e-10,0.146553,0.989203,0,-31.4908,-2.28884,-22.4832,1\",\"title\":\"MAXILLAIRE PLY\"}'),(1,'f1db099c-6d80-11ec-9377-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/f1db099c-6d80-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_9a7fb011-3358-4d3c-a11d-cb262db47e63_ACT_8d3d24a8-8497-455b-a175-3c2ad080b066_SESS_4c947a81-1ce1-4f4b-9ced-98099e5c9e41_TOSC_6c77a427-9c36-4753-9c20-b37adb53412f_SNAPS_','2021-12-30 18:14:38','2019-07-09 12:38:40','f1db099c-6d80-11ec-9377-226cec7cb58a.png','2021-12-30 19:14:38','SYNCED','f1db099c-6d80-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 11.1.2.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(1,'f1e16f6a-6d80-11ec-9377-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/f1e16f6a-6d80-11ec-9377-226cec7cb58a.bin','LIFIM','PATIENT_9a7fb011-3358-4d3c-a11d-cb262db47e63_ACT_8d3d24a8-8497-455b-a175-3c2ad080b066_SESS_4c947a81-1ce1-4f4b-9ced-98099e5c9e41_TOSC_6c77a427-9c36-4753-9c20-b37adb53412f_LIFIM_','2021-02-16 17:44:06','2020-12-29 11:51:31','f1e16f6a-6d80-11ec-9377-226cec7cb58a.bin','2021-02-16 18:44:06','SYNCED','f1e16f6a-6d80-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Ligne de finition Maxillaire 11.1.2.1.1 Sans nom 0\",\"name\":\"Sans nom 0\",\"title\":\"Maxillaire LIFI_META\",\"toothNumber\":0,\"versionMarginLine\":1}'),(1,'f1e67a14-6d80-11ec-9377-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/f1e67a14-6d80-11ec-9377-226cec7cb58a.xyz','LIFI','PATIENT_9a7fb011-3358-4d3c-a11d-cb262db47e63_ACT_8d3d24a8-8497-455b-a175-3c2ad080b066_SESS_4c947a81-1ce1-4f4b-9ced-98099e5c9e41_TOSC_6c77a427-9c36-4753-9c20-b37adb53412f_LIFI_','2021-02-16 17:44:05','2020-12-29 11:51:31','f1e67a14-6d80-11ec-9377-226cec7cb58a.xyz','2021-02-16 18:44:05','SYNCED','f1e67a14-6d80-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Ligne de finition Maxillaire 11.1.2.1.1 Sans nom 0\",\"name\":\"Sans nom 0\",\"title\":\"Maxillaire LIFI\",\"toothNumber\":0,\"versionMarginLine\":1}'),(1,'f1ea2916-6d80-11ec-9377-226cec7cb58a','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/f1ea2916-6d80-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_9a7fb011-3358-4d3c-a11d-cb262db47e63_ACT_8d3d24a8-8497-455b-a175-3c2ad080b066_SESS_4c947a81-1ce1-4f4b-9ced-98099e5c9e41_BOSC_1c6e5ffe-c555-4036-96c1-ff9513f7fd5d_SNAPS_','2022-01-03 18:15:35','2019-07-09 12:42:55','f1ea2916-6d80-11ec-9377-226cec7cb58a.png','2022-01-03 19:15:35','SYNCED','f1ea2916-6d80-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 11.1.2.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(1,'f57842f1-47bd-48c9-acd5-44086b66051b','/var/.data/2022/11644397-36f2-491f-aabf-b61c5414e0a5/discussion_3bb3ca53-cf49-4698-9658-df729e5c5f9e/f57842f1-47bd-48c9-acd5-44086b66051b.png','SNAPS','PATIENT_deb9364f-5940-46e8-927e-153c8a6ece22_ACT_790cdffb-0d7a-4eed-b8f6-d3230f7b7b7f_SESS_d196a096-7807-4361-9938-5ae3c32ac055_LESC_88fdf17b-5e15-484a-a53b-219025fd1eb2_SNAPS_','2022-01-04 17:05:08','2022-01-04 18:05:05','f57842f1-47bd-48c9-acd5-44086b66051b.png','2022-01-04 18:05:08','SYNCED','f57842f1-47bd-48c9-acd5-44086b66051b',0,NULL,'','','{\"displayTitle\":\"Mordu posterieur gauche 9.1.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}');
/*!40000 ALTER TABLE `CondorFile` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `CondorFile_BEFORE_DELETE` BEFORE DELETE ON `CondorFile` FOR EACH ROW BEGIN
  UPDATE Session SET mandibuleOcclusionPlyID = NULL
  WHERE ownerID = OLD.ownerID AND mandibuleOcclusionPlyID = OLD.id;

  UPDATE Session SET mandibuleOcclusionStlID = NULL
  WHERE ownerID = OLD.ownerID AND mandibuleOcclusionStlID = OLD.id;

  UPDATE Session SET maxillaireOcclusionPlyID = NULL
  WHERE ownerID = OLD.ownerID AND maxillaireOcclusionPlyID = OLD.id;

  UPDATE Session SET maxillaireOcclusionStlID = NULL
  WHERE ownerID = OLD.ownerID AND maxillaireOcclusionStlID = OLD.id;

  UPDATE Session SET mandibuleOcclusionPointContactID = NULL
  WHERE ownerID = OLD.ownerID AND mandibuleOcclusionPointContactID = OLD.id;

  UPDATE Session SET maxillaireOcclusionPointContactID = NULL
  WHERE ownerID = OLD.ownerID AND maxillaireOcclusionPointContactID = OLD.id;

  UPDATE Session SET matrixTransformationMandibuleID = NULL
  WHERE ownerID = OLD.ownerID AND matrixTransformationMandibuleID = OLD.id;

  UPDATE Session SET matrixTransformationMaxillaireID = NULL
  WHERE ownerID = OLD.ownerID AND matrixTransformationMaxillaireID = OLD.id;

  UPDATE Session SET snapshotID = NULL
  WHERE ownerID = OLD.ownerID AND snapshotID = OLD.id;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `Config`
--

DROP TABLE IF EXISTS `Config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Config` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `fullRetrieve` tinyint(1) DEFAULT '0',
  `syncEnabled` tinyint(1) DEFAULT '1',
  `showOcclusionScan` tinyint(1) DEFAULT '1',
  `showOpenStlWarning` tinyint(1) DEFAULT '1',
  `showMarginLinesWarning` tinyint(1) DEFAULT '1',
  `showDeleteConfirmation` tinyint(1) DEFAULT '1',
  `showSyncInfo` tinyint(1) DEFAULT '1',
  `downloadAtFullRetrieve` tinyint(1) DEFAULT '1',
  `lagSound` tinyint(1) DEFAULT '0',
  `lostSound` tinyint(1) DEFAULT '0',
  `emailNotifications` tinyint(1) DEFAULT '1',
  `logout` mediumint DEFAULT '10',
  `language` varchar(2) DEFAULT NULL,
  `flipMaxillaryH` tinyint(1) DEFAULT '0',
  `flipMaxillaryV` tinyint(1) DEFAULT '0',
  `flipMandibleH` tinyint(1) DEFAULT '0',
  `flipMandibleV` tinyint(1) DEFAULT '0',
  `showFlipPopupMaxillary` tinyint(1) DEFAULT '1',
  `showFlipPopupMandible` tinyint(1) DEFAULT '1',
  `enableUserSharing` tinyint(1) DEFAULT '1',
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `diagnosticMode` tinyint(1) DEFAULT '0',
  `repairMode` tinyint(1) DEFAULT '0',
  `lostTrackingRectangle` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Config_Professional` (`ownerID`),
  CONSTRAINT `fk_Config_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Config`
--

LOCK TABLES `Config` WRITE;
/*!40000 ALTER TABLE `Config` DISABLE KEYS */;
INSERT INTO `Config` VALUES (1,1,0,1,1,1,1,1,1,0,0,0,1,10,NULL,0,0,0,0,1,1,0,'2022-02-01 19:05:30','2022-02-01 18:05:30','2022-02-01 19:05:29',0,0,1),(2,1,0,1,1,1,1,1,1,1,0,0,1,999,'fr',0,0,0,0,1,1,0,'2022-01-31 12:16:12','2022-01-31 11:16:12','2022-01-31 12:16:12',0,0,1),(3,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2021-12-10 14:54:16','2021-12-10 13:54:16','2021-12-10 14:54:16',0,0,1),(4,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-07-01 15:21:36',0,0,1),(5,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-07-02 11:04:44',0,0,1),(6,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-07-02 11:05:21',0,0,1),(7,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-07-02 11:06:14',0,0,1),(8,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-07-02 11:06:33',0,0,1),(9,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-07-02 11:07:02',0,0,1),(10,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-07-02 11:16:13',0,0,1),(11,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-07-08 19:45:00',0,0,1),(17,1,0,1,1,1,1,0,1,1,1,0,1,999,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-11-08 09:32:23',0,0,1),(36,1,0,1,1,1,1,0,1,1,1,1,1,999,'fr',0,0,0,0,1,1,0,'2021-11-23 14:23:18','2021-11-23 13:23:18','2021-11-23 14:23:17',0,0,1),(48,1,0,1,1,1,1,0,1,1,1,0,1,30,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-10-14 14:10:36',0,0,1),(58,1,0,1,1,1,1,1,1,1,0,1,1,999,'fr',0,0,0,0,1,1,0,'2020-01-14 12:22:53','2020-01-14 11:22:53','2019-10-21 16:43:39',0,0,1),(61,1,0,1,1,1,1,1,1,1,1,1,1,120,'fr',0,0,0,0,1,1,0,'2019-12-18 10:50:51','2019-12-18 09:50:51','2019-10-22 11:05:00',0,0,1),(80,1,0,1,1,1,1,0,1,1,0,0,1,999,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-09-13 13:55:01',0,0,1),(86,1,0,1,1,1,0,0,1,1,0,0,1,999,'fr',0,0,0,0,1,1,0,'2019-12-16 16:47:05','2019-12-16 15:47:05','2019-11-19 16:34:38',0,0,1),(90,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-07-19 11:35:20',0,0,1),(100,1,0,1,1,1,1,1,1,1,0,1,1,999,'fr',0,0,0,0,1,1,0,'2020-03-02 12:25:36','2020-03-02 11:25:36','2019-07-22 09:40:45',0,0,1),(117,1,0,1,1,1,1,1,1,1,1,1,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-07-23 16:51:07',0,0,1),(135,1,0,1,1,1,1,1,1,1,0,0,1,60,'fr',0,0,0,0,1,1,0,'2020-07-03 12:36:29','2020-07-03 10:36:29','2020-07-03 10:40:37',0,0,1),(154,1,0,1,1,1,1,1,1,1,1,1,1,999,'fr',0,0,0,0,1,1,0,'2020-01-09 14:40:44','2020-01-09 13:40:44','2019-07-31 12:23:33',0,0,1),(163,1,0,1,1,1,1,1,1,1,0,1,1,200,'fr',0,0,0,0,1,1,0,'2021-12-16 22:25:56','2021-12-16 21:25:56','2020-12-16 21:27:40',0,0,1),(169,1,0,1,1,1,1,1,1,1,1,1,1,900,'fr',0,0,0,0,1,1,0,'2020-07-08 14:12:49','2020-07-08 12:12:49','2020-07-08 13:25:21',0,0,1),(172,1,0,1,1,1,1,1,1,1,0,0,1,999,'fr',0,0,0,0,1,1,0,'2020-06-03 19:03:54','2020-06-03 17:03:54','2020-06-03 18:59:46',0,0,1),(176,1,0,1,1,1,1,0,1,1,1,1,1,240,'fr',0,0,0,0,1,1,0,'2020-06-26 09:32:02','2020-06-26 07:32:02','2020-06-26 09:28:16',0,0,1),(177,1,0,1,1,1,1,1,1,1,0,0,1,990,'fr',0,0,0,0,1,1,0,'2021-03-05 17:04:59','2021-03-05 16:04:59','2021-03-05 17:04:59',0,0,1),(196,1,0,1,1,1,1,1,1,1,1,1,1,999,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-09-04 09:53:00',0,0,1),(211,1,0,1,1,1,1,1,1,1,1,1,1,999,'fr',0,0,0,0,1,1,0,'2020-01-10 15:16:53','2020-01-10 14:16:53','2019-09-09 16:32:57',0,0,1),(220,1,0,1,1,1,1,0,1,1,0,0,1,600,'fr',0,0,0,0,1,1,0,'2020-11-11 12:34:16','2020-11-11 11:34:16','2020-11-11 12:34:16',0,0,1),(245,1,0,1,1,1,1,1,1,1,0,1,1,200,'fr',0,0,0,0,1,1,0,'2020-01-17 11:23:07','2020-01-17 10:23:07','2019-09-16 14:33:17',0,0,1),(254,1,0,1,1,1,1,1,1,1,0,0,1,99,'fr',0,0,0,0,1,1,0,'2019-12-19 16:35:13','2019-12-19 15:35:13','2019-09-17 16:46:42',0,0,1),(270,1,0,1,1,1,1,1,1,1,0,0,1,100,'fr',0,0,0,0,1,1,0,'2020-01-16 17:31:02','2020-01-16 16:31:02','2020-01-16 17:31:01',0,0,1),(281,1,0,1,1,1,1,1,1,1,1,1,1,99,'fr',0,0,0,0,1,1,0,'2020-01-08 15:07:46','2020-01-08 14:07:46','2019-09-26 13:30:40',0,0,1),(289,1,0,1,1,1,1,1,1,1,1,0,1,999,'fr',0,0,0,0,1,1,0,'2020-07-09 18:20:17','2020-07-09 16:20:17','2020-07-09 18:20:16',0,0,1),(296,1,0,1,1,1,1,1,1,1,0,1,1,999,'fr',0,0,0,0,1,1,0,'2019-12-18 10:21:08','2019-12-18 09:21:08','2019-12-16 17:13:13',0,0,1),(297,1,0,1,1,1,1,1,1,1,0,1,1,10,'fr',0,0,0,0,1,1,0,'2020-11-02 17:25:54','2020-11-02 16:25:54','2020-11-02 17:25:54',0,0,1),(300,1,0,1,1,1,1,0,1,1,1,1,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-10-09 10:03:08',0,0,1),(310,1,0,1,1,1,1,1,1,1,1,0,1,999,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-10-24 11:52:36',0,0,1),(318,1,0,1,1,1,1,0,1,1,0,1,1,999,'fr',0,0,0,0,1,1,0,'2022-02-01 12:28:16','2022-02-01 11:28:16','2022-02-01 12:28:15',0,0,1),(321,1,0,1,1,1,1,0,1,1,0,0,1,999,'fr',0,0,0,0,1,1,0,'2020-10-29 17:06:44','2020-10-29 16:06:44','2020-10-29 17:06:43',0,0,1),(330,1,0,1,1,1,1,1,1,1,1,1,1,999,'fr',0,0,0,0,1,1,0,'2020-11-05 13:26:05','2020-11-05 12:26:05','2020-11-05 13:26:02',0,0,1),(352,1,0,1,1,1,1,0,1,1,1,1,1,10,'fr',0,0,0,0,1,1,0,'2020-11-03 11:26:49','2020-11-03 10:26:49','2020-11-03 11:26:16',0,0,1),(375,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2020-01-02 14:50:32','2020-01-02 13:50:32','2020-01-02 14:50:31',0,0,1),(376,1,0,1,1,1,1,1,1,1,0,1,1,20,'fr',0,0,0,0,1,1,0,'2020-01-10 10:49:21','2020-01-10 09:49:21','2020-01-10 10:49:20',0,0,1),(378,1,0,1,1,1,1,1,1,1,1,1,1,10,'fr',0,0,0,0,1,1,0,'2022-01-13 08:10:42','2022-01-13 07:10:42','2022-01-13 08:10:38',0,0,1),(415,1,0,1,1,1,1,1,1,1,0,1,1,999,'fr',0,0,0,0,1,1,0,'2020-01-15 11:05:56','2020-01-15 10:05:56','2019-11-22 15:07:58',0,0,1),(437,1,0,1,1,1,1,0,1,1,0,0,1,999,'fr',0,0,0,0,1,1,0,'2020-07-31 11:22:10','2020-07-31 09:22:10','2020-07-31 11:16:53',0,0,0),(442,1,0,1,1,1,1,0,1,1,1,1,1,60,'fr',0,0,0,0,1,1,0,'2020-08-03 14:47:56','2020-08-03 12:47:56','2020-08-03 14:47:56',0,0,1),(448,1,0,1,1,1,1,0,1,1,0,0,1,999,'fr',0,0,0,0,1,1,0,'2020-02-11 15:21:11','2020-02-11 14:21:11','2020-02-11 15:21:10',0,0,1),(461,1,0,1,1,1,1,1,1,1,0,0,1,999,'fr',0,0,0,0,1,1,0,'2020-02-13 10:41:12','2020-02-13 09:41:12','2020-02-13 10:41:11',0,0,1),(467,1,0,1,1,1,1,1,1,1,1,1,1,999,'fr',0,0,0,0,1,1,0,'2020-02-07 16:15:25','2020-02-07 15:15:25','2020-02-07 16:15:24',0,0,1),(472,1,0,1,1,1,1,1,1,1,1,1,1,20,'fr',0,0,0,0,1,1,0,'2020-02-12 10:05:13','2020-02-12 09:05:13','2020-02-12 10:05:13',0,0,1),(512,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2020-01-20 14:41:35','2020-01-20 13:41:35','2020-01-20 14:41:35',0,0,1),(597,1,0,1,1,1,1,0,1,1,1,1,1,10,'fr',0,0,0,0,1,1,0,'2020-09-03 17:31:21','2020-09-03 15:31:21','2020-06-30 23:42:34',0,0,1),(650,1,0,1,1,1,1,1,1,1,1,1,1,900,'fr',0,0,0,0,1,1,0,'2022-01-19 10:39:19','2022-01-19 09:39:19','2022-01-19 10:39:18',0,0,0),(689,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2020-06-02 12:32:01','2020-06-02 10:32:01','2020-06-02 12:32:01',0,0,1);
/*!40000 ALTER TABLE `Config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Contact`
--

DROP TABLE IF EXISTS `Contact`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Contact` (
  `ownerID` mediumint unsigned NOT NULL DEFAULT '0',
  `id` char(36) NOT NULL,
  `comments` text,
  `professionalID` mediumint unsigned NOT NULL,
  `officeID` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `status` enum('invitationSent','invitationReceived','accepted','rejected') DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  UNIQUE KEY `unique_contact_pro` (`ownerID`,`professionalID`),
  KEY `fk_Contact_Professionnal` (`ownerID`),
  KEY `fk_Contact_RefersTo` (`professionalID`),
  KEY `fk_Contact_Office` (`officeID`,`ownerID`),
  CONSTRAINT `fk_Contact_Office` FOREIGN KEY (`officeID`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Contact_Professionnal` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Contact_RefersTo` FOREIGN KEY (`professionalID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Contact`
--

LOCK TABLES `Contact` WRITE;
/*!40000 ALTER TABLE `Contact` DISABLE KEYS */;
INSERT INTO `Contact` VALUES (1,'0092016d-6e30-4542-8724-4182c315c04d','',90,NULL,NULL,'2020-04-28 05:04:13','2020-04-28 03:04:13','2020-04-28 05:04:13','accepted'),(1,'055a8728-e66f-4235-8613-e83bb3f9d694','',289,NULL,NULL,'2022-02-02 15:55:24','2022-02-02 14:55:24','2020-02-19 09:45:25','accepted'),(1,'1aef94c5-cf25-4cd1-ab24-f82dff19c1af','',321,NULL,NULL,'2021-03-13 07:26:31','2021-03-13 06:26:31','2019-10-21 15:21:30','invitationReceived'),(1,'1f21689e-5778-4e87-8c76-6fdcf9dabfc8','',211,NULL,NULL,'2020-01-15 18:28:17','2020-01-15 17:28:17','2019-09-09 15:03:30','invitationReceived'),(1,'23497991-150e-4999-b191-65cd323b957d','',177,NULL,NULL,'2021-11-12 14:01:56','2021-11-12 13:01:56','2020-01-28 10:24:23','invitationReceived'),(1,'27d87e76-17d0-4067-b8e6-1e8eb6f9cf32','',254,NULL,NULL,'2021-07-02 18:52:42','2021-07-02 16:52:42','2020-01-28 16:17:05','invitationReceived'),(1,'2dc641d7-4401-49c2-b372-23710526bbb7','',3,NULL,NULL,'2021-12-10 14:54:22','2021-12-10 13:54:22','2019-09-09 13:51:24','accepted'),(1,'2de8abcb-424b-4e41-ac2c-893089331499','',169,NULL,NULL,'2020-08-11 08:57:22','2020-08-11 06:57:22','2019-08-27 11:03:48','rejected'),(1,'2edcc277-3b15-44c5-83e3-b2142b8bd32b','',36,NULL,NULL,'2022-01-27 11:54:11','2022-01-27 10:54:11','2019-10-10 09:26:10','rejected'),(1,'30e154c4-4c25-403b-b354-dc7aa3283541','',80,NULL,NULL,'2019-10-14 16:11:31','2019-10-14 14:11:31','2019-08-12 18:00:22','invitationReceived'),(1,'33a9eab4-f261-4880-aea7-3a6f40cdf4d3','',650,NULL,NULL,'2022-02-02 15:55:24','2022-02-02 14:55:24','2020-05-05 11:58:25','rejected'),(1,'35834c73-d6b1-4b81-90cb-e13be9dcd9c6','',448,NULL,NULL,'2022-02-02 13:03:58','2022-02-02 12:03:58','2020-02-11 15:21:49','invitationReceived'),(1,'3ae40b7f-8df6-4ccf-ab3c-7d7f7ca987e9','',117,NULL,NULL,'2019-07-23 17:38:37','2019-07-23 15:38:37','2019-07-23 16:49:42','rejected'),(1,'3f5406bb-eb32-4155-9e51-d39cbff1a33c','',58,NULL,NULL,'2020-02-17 09:16:30','2020-02-17 08:16:30','2019-10-15 19:26:16','rejected'),(1,'4073b4f8-5a13-463a-b8b2-fd74fb2b1f33','',196,NULL,NULL,'2019-11-06 13:01:18','2019-11-06 12:01:18','2019-10-14 18:22:33','invitationReceived'),(1,'40d868dd-1886-4e2c-a9e5-7dcc99c49585','',281,NULL,NULL,'2020-01-22 17:07:22','2020-01-22 16:07:22','2019-12-05 10:37:56','invitationReceived'),(1,'444ede8f-e1f3-48b8-a604-30b923b5e392','',415,NULL,NULL,'2021-12-18 17:59:16','2021-12-18 16:59:16','2019-12-12 11:55:52','rejected'),(1,'45de56c1-599d-48c9-8607-eab7dbce7bd2','',442,NULL,NULL,'2021-10-06 16:30:14','2021-10-06 14:30:14','2020-03-05 18:05:22','rejected'),(1,'498c17ae-66a2-49c6-b4b7-e668ab75d5e0','',154,NULL,NULL,'2020-03-03 11:08:03','2020-03-03 10:08:03','2019-08-27 11:42:25','invitationReceived'),(1,'4d58a0fa-6496-48fb-95c3-6977cb5cfa09','',296,NULL,NULL,'2020-06-30 13:16:34','2020-06-30 11:16:34','2019-11-13 17:03:45','invitationReceived'),(1,'4deb2718-ea9b-446a-ad59-61009d26cfdf','',2,NULL,NULL,'2022-01-31 12:18:20','2022-01-31 11:18:20','2019-11-25 11:21:43','accepted'),(1,'50f30a96-df7f-434c-8c13-56be872e789d','',472,NULL,NULL,'2021-12-10 09:19:17','2021-12-10 08:19:17','2020-03-05 18:28:22','invitationReceived'),(1,'5c6d6417-d756-4602-a1e5-ca1b580e043d','',4,NULL,NULL,'2019-07-19 11:35:35','2019-07-19 09:35:35','2019-07-19 11:35:35','rejected'),(1,'637f3e4a-c434-4c45-aa0e-09ce966559ab','',9,NULL,NULL,'2020-01-24 14:39:36','2020-01-24 13:39:36','2019-07-02 11:34:52','accepted'),(1,'67638795-a9eb-4c6e-b8af-06a5729ca527','',378,NULL,NULL,'2022-01-13 08:11:06','2022-01-13 07:11:06','2019-11-07 10:36:21','invitationReceived'),(1,'6e374c6c-f1c3-410e-9885-237405d1c047','',11,NULL,NULL,'2020-12-09 11:10:32','2020-12-09 10:10:32','2019-07-30 10:26:55','rejected'),(1,'708fa721-6af9-4872-ba3e-a07ac7a8ed60','',220,NULL,NULL,'2021-03-31 00:14:56','2021-03-30 22:14:56','2020-05-06 22:52:19','invitationReceived'),(1,'71d38fee-a416-46c6-99e1-cf9bd718ef3e','',437,NULL,NULL,'2022-01-25 06:44:12','2022-01-25 05:44:12','2020-02-21 10:32:34','invitationReceived'),(1,'7b26ef46-c97a-4603-96c3-325b2e4e69c1','',689,NULL,NULL,'2020-11-23 12:52:44','2020-11-23 11:52:44','2020-11-23 12:52:44','accepted'),(1,'7d52dde0-2634-4a9f-83ae-dfe914bdfcc5','',17,NULL,NULL,'2019-11-08 09:44:16','2019-11-08 08:44:16','2019-08-30 13:47:02','invitationReceived'),(1,'7e93f539-1c54-4f6f-a88f-e92e8c33e347','',330,NULL,NULL,'2022-02-02 08:31:42','2022-02-02 07:31:42','2019-11-22 17:30:22','invitationReceived'),(1,'858d6d1f-4485-4da1-acd5-0b046fe74a18','',375,NULL,NULL,'2020-10-06 12:09:00','2020-10-06 10:09:00','2020-01-14 13:22:55','rejected'),(1,'874f2d06-fce4-430c-aa8a-af8a5041311d','',172,NULL,NULL,'2022-02-02 12:13:53','2022-02-02 11:13:53','2019-10-16 14:40:35','invitationReceived'),(1,'9315f74f-fa56-4148-b701-636b1e00d6c3','',300,NULL,NULL,'2019-11-07 10:24:20','2019-11-07 09:24:20','2019-10-03 13:39:14','invitationReceived'),(1,'946d96c7-212e-4b74-82fb-bd835fb04066','',100,NULL,NULL,'2020-03-15 11:33:08','2020-03-15 10:33:08','2019-07-30 10:01:05','invitationReceived'),(1,'959e88c9-630e-46e5-87c5-ecb853dbb5fb','',5,NULL,NULL,'2021-04-21 14:26:49','2021-04-21 12:26:49','2019-10-08 17:12:37','accepted'),(1,'971fb5f8-8a7d-4658-ac68-debcd55def70','',297,NULL,NULL,'2020-11-03 18:37:22','2020-11-03 17:37:22','2019-10-03 13:14:12','invitationReceived'),(1,'99ac8e6f-b7d8-4630-b843-13e871782915','',6,NULL,NULL,'2019-09-05 09:04:17','2019-09-05 07:04:17','2019-09-05 09:04:17','accepted'),(1,'9d896b6b-1d56-49e9-b035-6c655dd9be24','',176,NULL,NULL,'2020-06-26 15:50:39','2020-06-26 13:50:39','2020-01-24 07:44:58','rejected'),(1,'9ede665e-cd90-450e-9e29-39a383cab0c4','',597,NULL,NULL,'2020-09-29 21:11:06','2020-09-29 19:11:06','2020-02-27 20:08:41','invitationReceived'),(1,'a221354e-5c1e-4613-9287-ffebe42e79fb','',86,NULL,NULL,'2020-02-29 22:05:09','2020-02-29 21:05:09','2019-07-22 12:31:58','invitationReceived'),(1,'a7e86184-b194-4fef-b3c3-aa8926daaf7a','',61,NULL,NULL,'2020-06-29 17:49:39','2020-06-29 15:49:39','2019-08-07 10:26:38','invitationReceived'),(1,'b2c8e066-3da2-4c91-867c-1a3f948c1449','',48,NULL,NULL,'2019-12-04 14:52:17','2019-12-04 13:52:17','2019-07-16 16:50:56','invitationReceived'),(1,'b6904986-d9b6-4f4e-a4fe-b9f92667cc31','',318,NULL,NULL,'2022-02-01 12:29:04','2022-02-01 11:29:04','2019-10-22 20:38:41','invitationReceived'),(1,'b9416e1b-95f5-4de7-84c3-2932811ce3cf','',512,NULL,NULL,'2021-12-20 09:18:02','2021-12-20 08:18:02','2020-02-06 17:45:21','invitationReceived'),(1,'bd158562-315c-491b-88b9-c98d47682a8f','',135,NULL,NULL,'2020-07-03 13:19:46','2020-07-03 11:19:46','2019-09-18 11:42:44','invitationReceived'),(1,'c55936ae-7ee1-4115-a1b5-090a9e9997f5','',310,NULL,NULL,'2019-12-11 12:15:59','2019-12-11 11:15:59','2019-11-07 11:56:57','invitationReceived'),(1,'c55d38ce-5ee7-4353-8d11-d72a520277f3','',7,NULL,NULL,'2019-07-22 17:07:13','2019-07-22 15:07:13','2019-07-09 11:31:58','accepted'),(1,'c7aa70ac-95d8-462d-b33c-61a67e3cfdf6','',461,NULL,NULL,'2022-01-27 17:29:47','2022-01-27 16:29:47','2020-02-13 10:40:46','invitationReceived'),(1,'d2537ce9-ea6c-47e1-9767-6ec61bd01543','',376,NULL,NULL,'2020-02-19 16:10:30','2020-02-19 15:10:30','2019-12-04 15:42:36','invitationReceived'),(1,'dca43f45-d2ac-4bc8-bc72-4ba314468386','',8,NULL,NULL,'2019-07-22 19:36:25','2019-07-22 17:36:25','2019-07-02 18:19:09','accepted'),(1,'ddad117e-c74d-4ae4-b609-2f760d002bc9','',467,NULL,NULL,'2020-06-15 16:02:36','2020-06-15 14:02:36','2020-02-26 18:04:07','invitationReceived'),(1,'e278f7c6-66e1-4639-9c94-1dd8eed3b9be','',10,NULL,NULL,'2019-07-02 16:18:57','2019-07-02 14:18:57','2019-07-02 16:18:57','accepted'),(1,'e8d8243f-dc9d-44d2-99fb-1548e0616d93','',245,NULL,NULL,'2020-03-12 19:02:58','2020-03-12 18:02:58','2019-09-19 10:47:18','rejected'),(1,'ea8257fe-2cf8-4318-80fb-0b786223475d','',163,NULL,NULL,'2021-12-16 23:15:31','2021-12-16 22:15:31','2019-09-02 15:31:49','invitationReceived'),(1,'f500d902-5839-4413-bb1f-d87e82d5fb48','',270,NULL,NULL,'2020-10-28 14:49:51','2020-10-28 13:49:51','2020-01-23 18:13:12','rejected'),(1,'fdbe1a22-b94b-457a-8b03-0fc7be9aee4c','',1,NULL,NULL,'2022-02-02 15:55:21','2022-02-02 14:55:21','2019-06-28 18:00:23','accepted'),(1,'ffbfdea6-aedb-4603-8f7e-62e232ba5c39','',352,NULL,NULL,'2020-11-24 20:10:36','2020-11-24 19:10:36','2019-11-26 17:01:14','rejected');
/*!40000 ALTER TABLE `Contact` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ContactNotification`
--

DROP TABLE IF EXISTS `ContactNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ContactNotification` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `contactID` char(36) DEFAULT NULL,
  `rescueDisplayName` varchar(50) DEFAULT NULL,
  `event` enum('received','received_to_accepted','received_to_rejected','sent_to_accepted','sent_to_rejected','activation_timeout') NOT NULL DEFAULT 'received',
  `unread` tinyint(1) NOT NULL DEFAULT '1',
  `createdAt` datetime NOT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_ContactNotification_Professional` (`ownerID`),
  KEY `fk_ContactNotification_Contact` (`contactID`,`ownerID`),
  CONSTRAINT `fk_ContactNotification_Contact` FOREIGN KEY (`contactID`, `ownerID`) REFERENCES `Contact` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_ContactNotification_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ContactNotification`
--

LOCK TABLES `ContactNotification` WRITE;
/*!40000 ALTER TABLE `ContactNotification` DISABLE KEYS */;
INSERT INTO `ContactNotification` VALUES (1,'0199a80d-bf78-4232-82bd-bb91717217fb','bd158562-315c-491b-88b9-c98d47682a8f','Thierry Raeven','received',0,'2019-09-18 11:42:44',NULL,'2019-11-25 11:21:19','2019-09-18 11:42:44','2019-11-25 10:21:19'),(1,'06488b04-bab5-4777-ba2b-9adaa2677b61','708fa721-6af9-4872-ba3e-a07ac7a8ed60','Rui Goncalves','received',0,'2020-05-06 22:52:19',NULL,'2020-05-14 09:23:15','2020-05-06 22:52:19','2020-05-14 07:23:15'),(1,'0d68017a-739b-4eea-a3c1-455edf3b1ee7','9315f74f-fa56-4148-b701-636b1e00d6c3','IOAN ZISU','received',0,'2019-10-03 13:39:14',NULL,'2019-11-25 11:21:19','2019-10-03 13:39:14','2019-11-25 10:21:19'),(1,'142960b2-7d3a-443f-85d3-2c497d6218bd','b2c8e066-3da2-4c91-867c-1a3f948c1449','CHRISTIAN VALLE','received',0,'2019-07-16 16:50:56',NULL,'2019-07-17 09:06:28','2019-07-16 16:50:56','2019-07-17 07:06:28'),(1,'253813ee-9873-4de1-8f19-7a3592c015fc','a7e86184-b194-4fef-b3c3-aa8926daaf7a','SONYA ALVES','received',0,'2019-08-07 10:26:38',NULL,'2019-08-27 15:25:21','2019-08-07 10:26:38','2019-08-27 13:25:21'),(1,'25390c69-2b5b-4661-ae8c-f1983060ebd3','40d868dd-1886-4e2c-a9e5-7dcc99c49585','CECILE DE VAUREIX','received',0,'2019-12-05 10:37:56',NULL,'2020-01-09 11:24:10','2019-12-05 10:37:56','2020-01-09 10:24:10'),(1,'348d4707-b99f-4a4b-abe4-07821791919e','498c17ae-66a2-49c6-b4b7-e668ab75d5e0','Marie Lemartinel','received',0,'2019-08-27 11:42:25',NULL,'2019-08-27 15:25:21','2019-08-27 11:42:25','2019-08-27 13:25:21'),(1,'34aa82f7-d293-4730-a7f1-c78caae5123a','c55936ae-7ee1-4115-a1b5-090a9e9997f5','CORINNE MARTEL','received',0,'2019-11-07 11:56:57',NULL,'2019-11-25 11:21:19','2019-11-07 11:56:57','2019-11-25 10:21:19'),(1,'37aa3095-2636-429d-8090-19850b5e5000','71d38fee-a416-46c6-99e1-cf9bd718ef3e','MICHELE PIOMBINO','received',0,'2020-02-21 10:32:34',NULL,'2020-11-23 12:53:29','2020-02-21 10:32:34','2020-11-23 11:53:29'),(1,'3d3b102c-0b46-4860-a1c5-3a5124dd6546','30e154c4-4c25-403b-b354-dc7aa3283541','Ludovic Bretel','received',0,'2019-08-12 18:00:22',NULL,'2019-08-27 15:25:21','2019-08-12 18:00:22','2019-08-27 13:25:21'),(1,'4f637a60-0631-4e2a-b655-c63bb9244491','7e93f539-1c54-4f6f-a88f-e92e8c33e347','francois crebassa','received',0,'2019-11-22 17:30:23',NULL,'2019-11-25 11:21:19','2019-11-22 17:30:23','2019-11-25 10:21:19'),(1,'5490723b-ff8c-4e7c-b08f-9ff37743a04b','1f21689e-5778-4e87-8c76-6fdcf9dabfc8','OLIVIER BAUDELOT','received',0,'2019-09-09 15:03:30',NULL,'2019-11-25 11:21:19','2019-09-09 15:03:30','2019-11-25 10:21:19'),(1,'5af5d4a9-b364-4c99-88a8-881bc2d94e66','874f2d06-fce4-430c-aa8a-af8a5041311d','Franck Dr LE BOURHIS','received',0,'2019-10-16 14:40:35',NULL,'2019-11-25 11:21:19','2019-10-16 14:40:35','2019-11-25 10:21:19'),(1,'6d8de6a8-6cfe-47ab-8cec-9afd2f339db2','50f30a96-df7f-434c-8c13-56be872e789d','Gian Luca D\'Uggento','received',0,'2020-03-05 18:28:22',NULL,'2020-11-23 12:53:30','2020-03-05 18:28:22','2020-11-23 11:53:30'),(1,'83eb801c-9731-4eda-ad3b-70ee7a731c25','d2537ce9-ea6c-47e1-9767-6ec61bd01543','EMELINE DELTOMBE','received',0,'2019-12-04 15:42:36',NULL,'2020-01-09 11:24:10','2019-12-04 15:42:36','2020-01-09 10:24:10'),(1,'934da5ad-6a5d-4c59-8910-9039cbdd5bf0','946d96c7-212e-4b74-82fb-bd835fb04066','Caroline Rougé Périllon','received',0,'2019-07-30 10:01:05',NULL,'2019-07-30 10:08:41','2019-07-30 10:01:05','2019-07-30 08:08:41'),(1,'ab4deb3b-c4a3-47d0-b3c9-a6e0e1c66d56','23497991-150e-4999-b191-65cd323b957d','OLIVA VERONICA','received',0,'2020-01-28 10:24:23',NULL,'2020-01-28 17:24:34','2020-01-28 10:24:23','2020-01-28 16:24:34'),(1,'ab50306b-223b-40ee-9b7c-9a873113a0e4','c7aa70ac-95d8-462d-b33c-61a67e3cfdf6','NERIO TONIETTO','received',0,'2020-02-13 10:40:46',NULL,'2020-02-19 09:45:12','2020-02-13 10:40:46','2020-02-19 08:45:12'),(1,'ac2a455a-864f-44a7-b6b6-285c44efcd27','b6904986-d9b6-4f4e-a4fe-b9f92667cc31','Edoardo Marchese','received',0,'2019-10-22 20:38:41',NULL,'2019-11-25 11:21:19','2019-10-22 20:38:41','2019-11-25 10:21:19'),(1,'b333ba48-8eeb-4188-ab05-4cb2156dafd5','971fb5f8-8a7d-4658-ac68-debcd55def70','YOUSSEF LARAKI','received',0,'2019-10-03 13:14:12',NULL,'2019-11-25 11:21:19','2019-10-03 13:14:12','2019-11-25 10:21:19'),(1,'b43e3435-2668-4084-9ba1-0429f9bf06e6','27d87e76-17d0-4067-b8e6-1e8eb6f9cf32','JÉROME NOËL','received',0,'2020-01-28 16:17:05',NULL,'2020-01-28 17:24:34','2020-01-28 16:17:05','2020-01-28 16:24:34'),(1,'cdeef431-0a85-46dc-9008-067aa729f813','67638795-a9eb-4c6e-b8af-06a5729ca527','YILING HSIAO','received',0,'2019-11-07 10:36:21',NULL,'2019-11-25 11:21:19','2019-11-07 10:36:21','2019-11-25 10:21:19'),(1,'ce027c39-f483-4a73-89d7-72ce455d8ebb','4d58a0fa-6496-48fb-95c3-6977cb5cfa09','OSCAR PARRALEJO SERRANO','received',0,'2019-11-13 17:03:45',NULL,'2019-11-25 11:21:19','2019-11-13 17:03:45','2019-11-25 10:21:19'),(1,'e3d14e9e-b479-485a-9ff7-718891c8ec94','b9416e1b-95f5-4de7-84c3-2932811ce3cf','Jean-Christophe Schlick','received',0,'2020-02-06 17:45:21',NULL,'2020-02-19 09:45:12','2020-02-06 17:45:21','2020-02-19 08:45:12'),(1,'e69d252d-6027-4067-a344-b6be2a223172','ea8257fe-2cf8-4318-80fb-0b786223475d','Jerôme Meyrand','received',0,'2019-09-02 15:31:49',NULL,'2019-09-05 14:22:53','2019-09-02 15:31:49','2019-09-05 12:22:53'),(1,'ea85de6f-da06-4e55-a9a6-b9a63391e5b3','ddad117e-c74d-4ae4-b609-2f760d002bc9','Alain GRIOTIER','received',0,'2020-02-26 18:04:07',NULL,'2020-11-23 12:53:30','2020-02-26 18:04:07','2020-11-23 11:53:30'),(1,'ecd679de-369b-4162-be62-5f97c9ebb75e','1aef94c5-cf25-4cd1-ab24-f82dff19c1af','michelangelo rizzo','received',0,'2019-10-21 15:21:30',NULL,'2019-11-25 11:21:19','2019-10-21 15:21:30','2019-11-25 10:21:19'),(1,'f04d6e59-d537-4527-91eb-fbd5eca23845','35834c73-d6b1-4b81-90cb-e13be9dcd9c6','Stephane ARTERO','received',0,'2020-02-11 15:21:49',NULL,'2020-02-19 09:45:12','2020-02-11 15:21:49','2020-02-19 08:45:12'),(1,'f61d38ed-c2ef-43b6-8036-16af9a4c7c46','4073b4f8-5a13-463a-b8b2-fd74fb2b1f33','Christine SALDANA','received',0,'2019-10-14 18:22:33',NULL,'2019-11-25 11:21:19','2019-10-14 18:22:33','2019-11-25 10:21:19'),(1,'fb3a6d72-c486-41b1-9769-3de03161d339','7d52dde0-2634-4a9f-83ae-dfe914bdfcc5','ORIANE GUERY','received',0,'2019-08-30 13:47:02',NULL,'2019-09-05 14:22:53','2019-08-30 13:47:02','2019-09-05 12:22:53'),(1,'fc120823-d218-49bf-b1c7-27c47ac3dfc9','9ede665e-cd90-450e-9e29-39a383cab0c4','Jason Lomoriello','received',0,'2020-02-27 20:08:41',NULL,'2020-11-23 12:53:30','2020-02-27 20:08:41','2020-11-23 11:53:30'),(1,'fe4c3e56-bbb1-4236-85f2-701c9a3e913b','a221354e-5c1e-4613-9287-ffebe42e79fb','BIOTECH DENTAL BIOTECH','received',0,'2019-07-22 12:31:58',NULL,'2019-07-29 15:25:34','2019-07-22 12:31:58','2019-07-29 13:25:34');
/*!40000 ALTER TABLE `ContactNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Credentials`
--

DROP TABLE IF EXISTS `Credentials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Credentials` (
  `id` char(36) NOT NULL DEFAULT '',
  `login` varchar(64) NOT NULL,
  `password` varchar(100) DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `un_Login` (`login`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Credentials`
--

LOCK TABLES `Credentials` WRITE;
/*!40000 ALTER TABLE `Credentials` DISABLE KEYS */;
INSERT INTO `Credentials` VALUES ('00000001-0000-0000-0000-000000000001','Condor-si','29a2c02a04ebfb0a366bf2c7b19b97155e8436c3ccb378852224b528fe070d75',NULL,'2022-02-28 17:23:40');
/*!40000 ALTER TABLE `Credentials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Discussion`
--

DROP TABLE IF EXISTS `Discussion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Discussion` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `selfImplied` tinyint(1) NOT NULL DEFAULT '0',
  `officeID` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Discussion_Professional` (`ownerID`),
  KEY `fk_Discussion_Office` (`officeID`,`ownerID`),
  CONSTRAINT `fk_Discussion_Office` FOREIGN KEY (`officeID`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Discussion_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Discussion`
--

LOCK TABLES `Discussion` WRITE;
/*!40000 ALTER TABLE `Discussion` DISABLE KEYS */;
INSERT INTO `Discussion` VALUES (1,'1328a4be-f7f1-4cc8-8d93-2cb91f830d19',0,NULL,NULL,'2021-04-16 16:01:13','2021-04-16 14:01:13','2021-04-16 16:01:06'),(330,'1328a4be-f7f1-4cc8-8d93-2cb91f830d19',0,NULL,NULL,NULL,'2022-02-01 17:09:35','2022-02-01 18:09:35'),(1,'27bfc45b-1b14-4914-a7ca-cc01be7e4836',0,NULL,NULL,'2019-09-09 14:10:11','2019-09-09 12:10:11','2019-09-09 13:54:55'),(3,'27bfc45b-1b14-4914-a7ca-cc01be7e4836',0,NULL,NULL,NULL,'2022-02-01 17:09:35','2022-02-01 18:09:35'),(1,'3bb3ca53-cf49-4698-9658-df729e5c5f9e',0,NULL,NULL,'2022-01-04 18:22:05','2022-01-04 17:22:05','2019-11-25 11:23:31'),(2,'3bb3ca53-cf49-4698-9658-df729e5c5f9e',0,NULL,NULL,NULL,'2022-02-01 17:09:35','2022-02-01 18:09:35'),(1,'c694559e-df5a-4c0e-b44a-30814d8c3663',0,NULL,NULL,'2020-10-20 09:34:11','2020-10-20 07:34:11','2020-02-19 09:46:29'),(289,'c694559e-df5a-4c0e-b44a-30814d8c3663',0,NULL,NULL,NULL,'2022-02-01 17:09:35','2022-02-01 18:09:35');
/*!40000 ALTER TABLE `Discussion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Licence`
--

DROP TABLE IF EXISTS `Licence`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Licence` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `reference` varchar(45) DEFAULT NULL,
  `installKey` varchar(45) DEFAULT NULL,
  `activationDate` datetime DEFAULT NULL,
  `professionalID` mediumint unsigned NOT NULL,
  `cameraReference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`,`professionalID`),
  KEY `fk_Licence_Professional` (`professionalID`),
  CONSTRAINT `fk_Licence_Professional` FOREIGN KEY (`professionalID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Licence`
--

LOCK TABLES `Licence` WRITE;
/*!40000 ALTER TABLE `Licence` DISABLE KEYS */;
/*!40000 ALTER TABLE `Licence` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `MessageStatus`
--

DROP TABLE IF EXISTS `MessageStatus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `MessageStatus` (
  `ownerID` mediumint unsigned NOT NULL,
  `sentMessageID` char(36) NOT NULL,
  `contactID` char(36) NOT NULL,
  `status` enum('undelivered','delivered','transmitted') NOT NULL DEFAULT 'undelivered',
  `bcc` tinyint(1) NOT NULL DEFAULT '0',
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`sentMessageID`,`contactID`),
  KEY `fk_MessageStatus_SentMessage` (`sentMessageID`,`ownerID`),
  KEY `fk_MessageStatus_Contact` (`contactID`,`ownerID`),
  CONSTRAINT `fk_MessageStatus_Contact` FOREIGN KEY (`contactID`, `ownerID`) REFERENCES `Contact` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_MessageStatus_SentMessage` FOREIGN KEY (`sentMessageID`, `ownerID`) REFERENCES `SentMessage` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `MessageStatus`
--

LOCK TABLES `MessageStatus` WRITE;
/*!40000 ALTER TABLE `MessageStatus` DISABLE KEYS */;
INSERT INTO `MessageStatus` VALUES (1,'58b70136-5c0d-49d4-a13f-f5d29dbc7117','4deb2718-ea9b-446a-ad59-61009d26cfdf','transmitted',0,'2022-01-04 17:17:19'),(1,'5a692170-da64-4c2b-a924-c5467e6ae357','4deb2718-ea9b-446a-ad59-61009d26cfdf','transmitted',0,'2022-01-04 17:07:21'),(1,'852bcfe2-36dd-41d4-beae-f3dce91585d3','4deb2718-ea9b-446a-ad59-61009d26cfdf','transmitted',0,'2022-01-04 17:12:35'),(1,'d8fcb11a-d876-4b81-96ce-a11910f38ea9','4deb2718-ea9b-446a-ad59-61009d26cfdf','transmitted',0,'2022-01-04 16:57:39'),(1,'e88d045e-d649-4191-8f79-9db9ae16fbe8','4deb2718-ea9b-446a-ad59-61009d26cfdf','transmitted',0,'2022-01-04 16:59:09');
/*!40000 ALTER TABLE `MessageStatus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Occlusion`
--

DROP TABLE IF EXISTS `Occlusion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Occlusion` (
  `ownerID` mediumint unsigned NOT NULL DEFAULT '0',
  `id` char(36) NOT NULL,
  `sessionID` char(36) DEFAULT NULL,
  `occlusionType` enum('UNKNOWN','HEMI_ARCADE_POSTERIEUR_DROIT','HEMI_ARCADE_POSTERIEUR_GAUCHE','HEMI_ARCADE_ANTERIEUR','ARCADE_COMPLETE_ANTERIEUR','ARCADE_COMPLETE') DEFAULT 'HEMI_ARCADE_POSTERIEUR_DROIT',
  `deletedAt` datetime DEFAULT NULL,
  `createdAt` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `topScanID` char(36) DEFAULT NULL,
  `bottomScanID` char(36) DEFAULT NULL,
  `anteriorBiteScanID` char(36) DEFAULT NULL,
  `rightBiteScanID` char(36) DEFAULT NULL,
  `leftBiteScanID` char(36) DEFAULT NULL,
  `snapshotID` char(36) DEFAULT NULL,
  `mandibuleOcclusionPlyID` char(36) DEFAULT NULL,
  `maxillaireOcclusionPlyID` char(36) DEFAULT NULL,
  `matrixTransformationMandibuleID` char(36) DEFAULT NULL,
  `matrixTransformationMaxillaireID` char(36) DEFAULT NULL,
  `globalDisplayID` mediumint unsigned DEFAULT NULL,
  `displayID` mediumint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Occlusion_Session` (`sessionID`,`ownerID`),
  KEY `fk_Occlusion_topScan` (`topScanID`,`ownerID`),
  KEY `fk_Occlusion_bottomScan` (`bottomScanID`,`ownerID`),
  KEY `fk_Occlusion_anteriorBiteScanID` (`anteriorBiteScanID`,`ownerID`),
  KEY `fk_Occlusion_rightBiteScanID` (`rightBiteScanID`,`ownerID`),
  KEY `fk_Occlusion_leftBiteScanID` (`leftBiteScanID`,`ownerID`),
  KEY `fk_Occlusion_CondorFile_snapshot` (`snapshotID`,`ownerID`),
  KEY `fk_Occlusion_CondorFile_mandibulePly` (`mandibuleOcclusionPlyID`,`ownerID`),
  KEY `fk_Occlusion_CondorFile_matrixTransformationMandibule` (`matrixTransformationMandibuleID`,`ownerID`),
  KEY `fk_Occlusion_CondorFile_maxillairePly` (`maxillaireOcclusionPlyID`,`ownerID`),
  KEY `fk_Occlusion_CondorFile_matrixTransformationMaxillaire` (`matrixTransformationMaxillaireID`,`ownerID`),
  CONSTRAINT `fk_Occlusion_anteriorBiteScanID` FOREIGN KEY (`anteriorBiteScanID`, `ownerID`) REFERENCES `Scan` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_bottomScan` FOREIGN KEY (`bottomScanID`, `ownerID`) REFERENCES `Scan` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_CondorFile_mandibulePly` FOREIGN KEY (`mandibuleOcclusionPlyID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_CondorFile_matrixTransformationMandibule` FOREIGN KEY (`matrixTransformationMandibuleID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_CondorFile_matrixTransformationMaxillaire` FOREIGN KEY (`matrixTransformationMaxillaireID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_CondorFile_maxillairePly` FOREIGN KEY (`maxillaireOcclusionPlyID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_CondorFile_snapshot` FOREIGN KEY (`snapshotID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_leftBiteScanID` FOREIGN KEY (`leftBiteScanID`, `ownerID`) REFERENCES `Scan` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_rightBiteScanID` FOREIGN KEY (`rightBiteScanID`, `ownerID`) REFERENCES `Scan` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_Session` FOREIGN KEY (`sessionID`, `ownerID`) REFERENCES `Session` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_topScan` FOREIGN KEY (`topScanID`, `ownerID`) REFERENCES `Scan` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Occlusion`
--

LOCK TABLES `Occlusion` WRITE;
/*!40000 ALTER TABLE `Occlusion` DISABLE KEYS */;
/*!40000 ALTER TABLE `Occlusion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `OcclusionFile`
--

DROP TABLE IF EXISTS `OcclusionFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `OcclusionFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `fileID` char(36) NOT NULL,
  `occlusionID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `occlusionType` enum('OCCLUSION_RESULT','MANDIBULE_PLY','MAXILLAIRE_PLY','LEFT_BITE','RIGHT_BITE','ANTERIOR_BITE','SCREENSHOT','LIFI','MANDIBULE_MATRIX','MAXILLAIRE_MATRIX') DEFAULT 'OCCLUSION_RESULT',
  PRIMARY KEY (`fileID`,`occlusionID`,`ownerID`),
  KEY `fk_OcclusionFile_CondorFile` (`fileID`,`ownerID`),
  KEY `fk_OcclusionFile_Occlusion` (`occlusionID`,`ownerID`),
  CONSTRAINT `fk_OcclusionFile_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_OcclusionFile_Occlusion` FOREIGN KEY (`occlusionID`, `ownerID`) REFERENCES `Occlusion` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `OcclusionFile`
--

LOCK TABLES `OcclusionFile` WRITE;
/*!40000 ALTER TABLE `OcclusionFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `OcclusionFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Office`
--

DROP TABLE IF EXISTS `Office`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Office` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `mainPhone` varchar(45) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `cityName` varchar(255) DEFAULT NULL,
  `cityZip` varchar(25) DEFAULT NULL,
  `address` text,
  `country` varchar(75) DEFAULT NULL,
  `reassignedTo` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Office_Professional_idx` (`ownerID`),
  KEY `fk_Office_Office_reassignedTo` (`reassignedTo`,`ownerID`),
  CONSTRAINT `fk_Office_Office_reassignedTo` FOREIGN KEY (`reassignedTo`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Office_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Office`
--

LOCK TABLES `Office` WRITE;
/*!40000 ALTER TABLE `Office` DISABLE KEYS */;
INSERT INTO `Office` VALUES (597,'00aac975-7fe5-43d1-8b33-cef5ee766800','3863016534','Video Dental Enterprise','','Ormond Beach','32176','100 East Granada Blvd','United States',NULL,NULL,'2020-09-03 17:34:19','2020-09-03 15:34:19','2020-02-20 22:14:49'),(281,'030d04b7-7d74-4929-b104-5c2c2e6ca273','0142275230','DE VAUREIX','','PARIS','75017','24 AVE DE VILLIERS','France',NULL,NULL,'2019-09-26 13:29:47','2019-09-26 11:29:47','2019-09-26 13:29:47'),(3,'07a4901a-a73e-414b-bafe-ff42d883049b','542138759','Condor','','Labège','31670','137 rue Garance','France',NULL,NULL,'2019-07-01 14:13:31','2019-07-01 12:13:31','2019-07-01 14:13:31'),(7,'12faf4c9-95d6-4c4f-b641-481c29111d9a','0664864059','DENTAL CUB','','MERIGNAC','33700','10 av jean mazaryck,','France',NULL,NULL,'2019-07-09 11:35:13','2019-07-09 09:35:13','2019-07-09 11:35:13'),(90,'19147644-d707-48a3-ba70-baa57ba321fd','0699662350','Cabinet (default)','','Aubagne','13400','Aubagne','France',NULL,NULL,'2019-07-20 08:31:27','2019-07-20 06:31:27','2019-07-20 08:31:27'),(297,'1bccd198-9e8f-4ef2-a829-2c5d1ed363b9','661172362','cabinet dr laraki','','Casablanca','20000','40 rue abou el wakt','Al-maɣréb',NULL,NULL,'2020-11-02 12:18:20','2020-11-02 11:18:20','2019-10-01 18:19:59'),(289,'1d87c673-6147-4bbd-b306-938f070cf56c','382269122','GERARD LEICK','','GORCY','54730','4 RUE DU CHATEAU','France',NULL,NULL,'2019-09-30 11:35:45','2019-09-30 09:35:45','2018-03-31 07:57:08'),(321,'21f364aa-02e1-48ca-bbc0-555e6bdad379','089878511',' dr. rizzo michelangelo','www.dottmichelangelorizzo.com','baronissi','84081','via aldo moro 1F','Italia',NULL,NULL,'2019-10-16 10:03:33','2019-10-16 08:03:33','2019-01-14 09:04:33'),(80,'23499414-fe85-4a6a-9829-ec1034eb73f2','296321142','Cabinet Dentaire Plaintel','','Plaintel','22940','402 rue des granitiers','France',NULL,NULL,'2019-07-18 13:47:08','2019-07-18 11:47:08','2019-07-18 13:47:08'),(177,'27f156ab-dc42-4425-ae10-2443070d284b','660474450','BIOTECH','','LEGANES','28916','AVDA. JUAN CARAMUEL,1','España',NULL,NULL,'2019-08-26 11:09:47','2019-08-26 09:09:47','2019-08-26 11:09:47'),(376,'2dac5f60-c6d4-4c7d-adc9-ca0f19ae13d8','0637114521','chateau des cimes','','marchiennes','59870','6 rue pasteur ','France',NULL,NULL,'2019-10-28 14:12:43','2019-10-28 13:12:43','2018-03-21 15:00:56'),(318,'3ae3c9c5-4719-428c-af65-f5c02cdb3208','','','','','','','',NULL,NULL,'2019-10-21 10:49:46','2019-10-21 08:49:46','2019-10-21 00:00:00'),(472,'3cbd96ba-10c7-4c78-a39e-1bc7c0f280ea','3478736446','D\'Uggento','','Torino','10135','Via Passe Buole 172','Italia',NULL,NULL,'2019-12-23 19:12:08','2019-12-23 18:12:08','2019-12-23 19:12:08'),(176,'3cc9aa7d-bb1b-473b-8e82-c7987f39736f','692118957','Dr JAN','','St denis','97400','10 rocade de l\'oasis','Réunion',NULL,NULL,'2019-08-27 14:06:56','2019-08-27 12:06:56','2019-08-23 17:54:52'),(437,'434c0de5-4a27-4746-85ff-fe51a687354a','3355346398','Studio dentistico Piombino','','Caserta','81100','via L.Ricciardelli,23','Italia',NULL,NULL,'2019-12-11 12:51:14','2019-12-11 11:51:14','2019-12-11 12:51:14'),(378,'4d01395a-1961-44d8-a54f-22b1b5f9f9fb','0912932347','BIOTECH','','Taichung','403','7F-1, No.536, Sec 2, Taiwan Blvd, Taichung, Taiwan','Táiwān',NULL,NULL,'2019-11-07 10:31:40','2019-11-07 09:31:40','2019-10-29 06:48:17'),(300,'4eb4eb50-6520-412d-8247-0f8f5c3beb1c','0493246425','CABINET ZISU','','VENCE ','06140','108 avenue victor Tuby','France',NULL,NULL,'2019-10-02 14:24:08','2019-10-02 12:24:08','2019-10-02 14:24:08'),(254,'538d4a0f-4548-4cf0-a082-a81431c291e3','0148568894','Selarl Cabinet du Docteur NOEL','','Paris','75015','90, rue de l\'Abbé Groult','France',NULL,NULL,'2019-09-17 16:46:35','2019-09-17 14:46:35','2017-12-05 15:40:03'),(9,'544e3fb2-5e62-472f-b606-7185054c1396','0149698526','Laboratoire LDA','www.laboratoirelda.com','Villiers Sur Marne','94350','1 rue de la fraternité','France',NULL,NULL,'2019-07-02 11:36:03','2019-07-02 09:36:03','2019-07-02 11:36:03'),(211,'59fc5356-08c2-4b0f-9568-7524f5baa900','676815885','cabinet dentaire baudelot','','ballancourt','91610','4 place de la liberté','France',NULL,NULL,'2019-09-04 13:13:57','2019-09-04 11:13:57','2019-09-04 13:13:57'),(11,'5acfc32b-1bbc-4d32-a61c-a9970e819bf2','00000000000000000','Condor','','Labège','31670','137 rue Garance','France',NULL,NULL,'2019-07-03 10:05:55','2019-07-03 08:05:55','2019-07-03 10:05:55'),(48,'5bf9a860-d918-4d15-86cd-ccab06fc7742','0388222811','valle christian','','strasbourg','67000','30 rue du 22 novembre','France',NULL,NULL,'2019-07-16 16:36:56','2019-07-16 14:36:56','2019-07-16 16:36:56'),(172,'5d22dd41-4a03-4813-a2a3-86598c1101c0','0559830648','SELARL du Dr Franck LE BOURHIS','','LAROIN','64110','4 Chemin Couralis','France',NULL,NULL,'2019-08-19 17:44:04','2019-08-19 15:44:04','2019-01-21 17:43:09'),(296,'6a30a3e0-2d4a-400d-8943-cd2fda7097ae','916842187','CENTRO ODONTOLOGICO MEDICO S.A.','','GETAFE','28904','FERROCARRIL N 20','España',NULL,NULL,'2019-10-01 17:14:15','2019-10-01 15:14:15','2018-05-29 12:30:18'),(512,'6a8b52c1-f539-40a0-8352-b65e84245251','123456987','toto','','fr','df','dg','France',NULL,NULL,'2020-01-17 11:09:16','2020-01-17 10:09:16','2020-01-17 11:08:50'),(36,'6e1375ca-3c76-4db4-b75a-5724a49c3539','00447375389999','Billericay Dental Care','','Billericay','cm12 9bx','Crown yard, High street','United Kingdom',NULL,NULL,'2021-11-23 14:28:09','2021-11-23 13:28:09','2021-11-23 14:28:09'),(415,'75374ab3-4cb4-4ea2-8cdb-0d8ff3e5baa0','0299670707','Docteur Philippe NOZAIS','','RENNES','35000','5 rue du Louis d\'Or','France',NULL,NULL,'2019-11-22 14:49:24','2019-11-22 13:49:24','2019-11-22 14:49:24'),(352,'7bd1efcd-c957-4592-9ecf-622e87685c89','146076695','SELARL Dr. SAWAF','','PARIS','75010','219 Rue La Fayette','France',NULL,NULL,'2019-10-18 17:50:52','2019-10-18 15:50:52','2019-10-18 17:50:52'),(467,'89d2bbfe-414a-40cc-ae4a-4e83e87c2cdd','0450220025','GRIOTINE','','EPAGNY METZ TESSY','74330','114 RUE DE LA REPUBLIQUE','France',NULL,NULL,'2019-12-20 15:10:34','2019-12-20 14:10:34','2018-09-18 14:27:42'),(163,'8ec1b161-3ff1-4576-ab53-1461e43533e6','478421239','Dr Meyrand Jerôme','','Lyon','69002','106 rue du Président Edouard Herriot','France',NULL,NULL,'2019-08-07 10:12:46','2019-08-07 08:12:46','2017-02-24 14:07:32'),(448,'90a5629a-a113-4b43-84ca-6331049219b9','0603280216','cabinet du Bosphore','','Marseille','13015','42 boulevard du Bosphore','Federated States of Micronesia',NULL,NULL,'2019-12-13 09:29:15','2019-12-13 08:29:15','2017-06-12 13:31:47'),(154,'9f2347c2-35ed-47d0-969c-e945129d0c27','0688570810','Dr Lemartinel','','Angers','49000','61 avenue Jean XXIII','France',NULL,NULL,'2019-07-31 12:19:05','2019-07-31 10:19:05','2019-07-31 12:19:05'),(6,'a1984274-1ad9-41d4-b536-d4407f8fca00','0491776127','Cabinet (default)','','Marseille','','','France',NULL,NULL,'2019-07-07 06:24:25','2019-07-07 04:24:25','2019-07-02 11:05:21'),(375,'a67878c9-0724-4c0b-b082-d252b2a443a0','142357044','Selarl Cabinet du Dr BOKOBZA','','Epinay sur Seine','93800','95, Avenue de la Marne','France',NULL,NULL,'2019-10-28 13:23:57','2019-10-28 12:23:57','2018-01-26 09:24:01'),(86,'aaeeb462-2dad-40f4-9f14-b2175248ff4f','660474450','CENTRAL BIOTECH','','LEGANES','28919','AVENIDA JUAN CARAMUEL. 1','España',NULL,NULL,'2019-08-16 22:14:09','2019-08-16 20:14:09','2019-07-19 10:53:08'),(100,'b6e58950-d760-4419-b13b-7228c22dd9b9','233170622','Rougé Périllon','','Coutances','50200','3 Place de la Croute','France',NULL,NULL,'2019-07-19 17:27:23','2019-07-19 15:27:23','2019-07-19 17:27:23'),(689,'b9db0008-e73d-4e5a-ac76-2c93df3250ae','04 79 26 15 66','Cabinet (default)','','CHAMBERY','73000','1 Place de la Libération','France',NULL,NULL,'2020-11-03 08:32:27','2020-11-03 07:32:27','2020-11-03 08:32:27'),(1,'bf407538-bec8-49af-b04a-68926a6b1a6e','123322332','Labege','','Labege','31670','Labege','France',NULL,NULL,'2019-06-28 18:00:23','2019-06-28 16:00:23','2019-06-28 18:00:23'),(10,'c34e18ba-d8ce-4f47-8c86-9e9ce44fc7d8','0674334568','Cabinet (default)','','Toulouse','','','France',NULL,NULL,'2019-07-02 16:18:38','2019-07-02 14:18:38','2019-07-02 11:16:13'),(8,'c54ab53e-cc43-42dd-a0f6-824b6dc657ad','0664143389','LABEL DENT','','MERIGNAC','','10 AV JAN MASARYK','France',NULL,NULL,'2019-07-22 16:59:15','2019-07-22 14:59:15','2019-07-22 16:59:15'),(169,'c5988d74-6b6c-418f-91b3-f3f87e8379e2','17333080','LAMAR DENTAL CENTER W.L.L','','78','112233','Busaiteen','Al-Baḥrayn',NULL,NULL,'2019-08-19 15:02:26','2019-08-19 13:02:26','2019-08-19 13:48:42'),(330,'c5a6f72e-8c65-40f4-a8f6-696f8f0e41ca','466531389','crebassa','','le grau du roi','30240','cc port royal','France',NULL,NULL,'2019-10-10 17:11:07','2019-10-10 15:11:07','2019-01-23 10:07:51'),(58,'c7adb33f-85de-4585-bbf6-c25cc4c03957','475462479','DR LANTHEAUME','','Le teil','07400','28 Bis Rue Vincent Touchet','France',NULL,NULL,'2019-07-17 19:32:22','2019-07-17 17:32:22','2019-07-17 19:32:22'),(220,'c95c0af2-bede-465f-b963-e3970b9b1fa4','912554208','Rui Goncalves','','1','1','1','Portugal',NULL,NULL,'2019-09-07 14:36:15','2019-09-07 12:36:15','2019-09-07 14:36:15'),(245,'cd4e9fb3-25e7-48f9-99ec-c395f04e9165','0478525977','scm PMH','','LYON','69006','74 Rue Vauban','France',NULL,NULL,'2019-09-16 14:24:16','2019-09-16 12:24:16','2019-09-16 14:24:16'),(270,'dbb440b9-cc40-44ac-9631-30b739a3360b','3280648631','STUDIO ODONTOIATRICO PALERMO ROSSETTI','','MIRABELLA ECLANO','83036','VIA PORTA DI FERRO,17','Italia',NULL,NULL,'2019-09-23 10:59:23','2019-09-23 08:59:23','2019-09-23 10:59:23'),(461,'de43e011-d07f-49df-85a4-8acec7da0fab','0431520201','Studio Dentistico dott.Nerio Tonietto','','San Michele Tagliamento','30028','via Canal,18','Italia',NULL,NULL,'2019-12-19 12:13:12','2019-12-19 11:13:12','2019-12-19 12:13:12'),(442,'e0cc1643-4fd3-415d-8dae-a88021ec073d','661458376','cabinet dentaire la colline ','','Casablanca ','20000','lot la colline 2 imm le matignon 2 et N 5 Sidi Maarouf ','Al-maɣréb',NULL,NULL,'2019-12-12 13:37:20','2019-12-12 12:37:20','2019-12-12 13:37:20'),(17,'e3192ca3-a3b7-40c2-a175-5001764a2c3c','0699795775','LUCIANI','','Montmerle sur saone','01090','2 rue de lyon ','France',NULL,NULL,'2019-07-11 17:01:09','2019-07-11 15:01:09','2019-07-11 17:01:09'),(650,'e31a6984-65b4-4dbf-b8a6-10627debbd79','00000000','toto','','toto','toto','toto','France',NULL,NULL,'2020-03-11 09:33:44','2020-03-11 08:33:44','2020-03-11 09:32:45'),(61,'e4a8fa12-2d1f-4d1b-9e52-3a1b635914b5','0450921643','Cabinet Dentaire de l\'hotel de ville','','ANNEMASSE','74100','12 PLACE DE L\'HOTEL DE VILLE','France',NULL,NULL,'2019-07-17 14:46:11','2019-07-17 12:46:11','2019-07-17 14:46:11'),(5,'e563f7db-c71c-416d-a74d-2b979f6eade2','0388334408','LABORATOIRE DENTAL BIOTECH','https://laboratoire-labeldent.fr/','WOLFISHEIM','67202','5 impasse Joffre','France',NULL,NULL,'2021-04-21 14:26:48','2021-04-21 12:26:48','2021-04-21 14:26:48'),(135,'ea4731f5-6c94-4a12-bd79-4dbdcc656a61','382255179','LAMBRECHTS-RAEVEN','','LEXY','54270','RUE MARECHAL JOFFRE','France',NULL,NULL,'2019-07-25 13:50:01','2019-07-25 11:50:01','2019-07-25 13:50:01'),(196,'eabce936-4dfd-4dc6-8a45-6c9a4c0737c4','0238747321','saldana','','ormes','45140','12 rue de la poule blanche','France',NULL,NULL,'2019-09-04 09:46:46','2019-09-04 07:46:46','2019-09-04 09:46:46'),(2,'f841d3b8-276b-4ad1-859c-ba7e25ffe059','056139839','Scan4all','','LABEGE','31670','137 rue garance','France',NULL,NULL,'2021-04-28 16:09:09','2021-04-28 14:09:09','2021-04-28 16:09:09'),(310,'f9a8c395-8e4f-4b37-a6c6-7b017480d271','0466676511','Cabinet Martel','','Nimes','30000','1, rue Titus','France',NULL,NULL,'2019-10-03 16:53:42','2019-10-03 14:53:42','2019-10-03 16:53:42'),(4,'fdb3fdd6-d97a-4f1a-ac7d-207988fec0d0','','Cabinet (default)','','','','','',NULL,NULL,'2019-07-01 15:21:36','2019-07-01 13:21:36','2019-07-01 15:21:36'),(117,'fefef86d-d237-43da-9e3c-690dd3789ed7','147717254','corvisier','','Saint-Cloud','92210','160 boulevard de la république','France',NULL,NULL,'2019-07-23 16:45:25','2019-07-23 14:45:25','2019-07-23 16:45:25');
/*!40000 ALTER TABLE `Office` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `Office_BEFORE_DELETE` BEFORE DELETE ON `Office` FOR EACH ROW BEGIN		
  UPDATE Assistant SET officeID = NULL 
  WHERE ownerID = OLD.ownerID AND officeID = OLD.id;

  UPDATE Contact SET officeID = NULL 
  WHERE ownerID = OLD.ownerID AND officeID = OLD.id;

  UPDATE Discussion SET officeID = NULL 
  WHERE ownerID = OLD.ownerID AND officeID = OLD.id;

  UPDATE Patient SET officeID = NULL 
  WHERE ownerID = OLD.ownerID AND officeID = OLD.id;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `PersonInfo`
--

DROP TABLE IF EXISTS `PersonInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PersonInfo` (
  `id` char(36) NOT NULL COMMENT '(DC2Type:guid)',
  `firstName` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `sex` enum('M','F') DEFAULT NULL,
  `birthDate` date DEFAULT NULL,
  `salutation` varchar(45) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `picturePath` varchar(255) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PersonInfo`
--

LOCK TABLES `PersonInfo` WRITE;
/*!40000 ALTER TABLE `PersonInfo` DISABLE KEYS */;
INSERT INTO `PersonInfo` VALUES ('00000001-0000-0000-0000-000000000001','labege','SI','si@condorscan.pro','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000002-0000-0000-0000-000000000001','WoW','SAV','service@wow-scan.pro','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000003-0000-0000-0000-000000000001','c2w','prod-test','thomas.besson@condorscan.pro','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000004-0000-0000-0000-000000000001','','','poubelle@jc2l.fr','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000005-0000-0000-0000-000000000001','Dental Biotech Strasbourg','Laboratoire','cfao@dentalbiotech.fr','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000006-0000-0000-0000-000000000001','Gilles','Philip','laboratoirephilip@yahoo.fr','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000007-0000-0000-0000-000000000001','DENTAL CUB','LABORATOIRE','cfao@dentalcub.fr','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000008-0000-0000-0000-000000000001','LABEL DENT','LABORATOIRE','label.dent@orange.fr','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000009-0000-0000-0000-000000000001','Laboratoire','LDA','cfao@laboratoirelda.com','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000010-0000-0000-0000-000000000001','veronique','Querbes','veronique.querbes@condorscan.pro','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000011-0000-0000-0000-000000000001','IVVQ','Condor','t.b@condorscan.pro','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000017-0000-0000-0000-000000000001','ORIANE','GUERY','oriane.luciani@gmail.com','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000036-0000-0000-0000-000000000001','Khetab','George','george.khetab@gmail.com','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000048-0000-0000-0000-000000000001','CHRISTIAN','VALLE','cabdent3rcp@gmail.com','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000058-0000-0000-0000-000000000001','Guillaume','Lantheaume','dr.lantheaume.guillaume@gmail.com','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000061-0000-0000-0000-000000000001','SONYA','ALVES','dralvesaccueil@gmail.com','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000080-0000-0000-0000-000000000001','Ludovic','Bretel','gaelludo.bretel@orange.fr','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000086-0000-0000-0000-000000000001','BIOTECH DENTAL','BIOTECH','ios.clinica.ios@gmail.com','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000090-0000-0000-0000-000000000001','David','Lela Luzolo','dllconseiljuridique@free.fr','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000100-0000-0000-0000-000000000001','Caroline','Rougé Périllon','cabinet.rouge.perillon@gmail.com','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000117-0000-0000-0000-000000000001','marie','corvisier','dr.corvisier@gmail.com','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000135-0000-0000-0000-000000000001','Thierry','Raeven','traeven33@gmail.com','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000154-0000-0000-0000-000000000001','Marie','Lemartinel','dr.lemartinel@gmail.com','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000163-0000-0000-0000-000000000001','Jerôme','Meyrand','meyrand.jerome@wanadoo.fr','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000169-0000-0000-0000-000000000001','LMR','LMR','lamarclinic@gmail.com','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000172-0000-0000-0000-000000000001','Franck','Dr LE BOURHIS','francklebourhis@gmail.com','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000176-0000-0000-0000-000000000001','ANTOINE','JAN','docteur.antoine.jan@gmail.com','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000177-0000-0000-0000-000000000001','OLIVA','VERONICA','v.oliva@biotech-dental.com','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000196-0000-0000-0000-000000000001','Christine','SALDANA','cabinetdentaire.saldana@bbox.fr','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000211-0000-0000-0000-000000000001','OLIVIER','BAUDELOT','cabinetdentaire.baudelot@orange.fr','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000220-0000-0000-0000-000000000001','Rui','Goncalves','ruimpg@gmail.com','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000245-0000-0000-0000-000000000001','JULIEN','MARCHAND','scm.pmh@outlook.com','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000254-0000-0000-0000-000000000001','JÉROME','NOËL','drjnoel@yahoo.fr','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000270-0000-0000-0000-000000000001','Guerino','Paolantoni','info@biotech-dental.it','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000281-0000-0000-0000-000000000001','CECILE','DE VAUREIX','cecile.devaureix@gmail.com','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000289-0000-0000-0000-000000000001','GERARD','LEICK','ge.leick@orange.fr','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000296-0000-0000-0000-000000000001','OSCAR','PARRALEJO SERRANO','clinicascom@hotmail.com','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000297-0000-0000-0000-000000000001','Anouar','Chkalante','cabinet.dr.chkalante@gmail.com','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000300-0000-0000-0000-000000000001','IOAN','ZISU','drzisu@gmail.com','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000310-0000-0000-0000-000000000001','CORINNE','MARTEL','cabinet.martel30@orange.fr','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000318-0000-0000-0000-000000000001','Edoardo','Marchese','edoardo.marchese@inwind.it','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000321-0000-0000-0000-000000000001','michelangelo','rizzo','dr.rizzomichelangelo@gmail.com','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000330-0000-0000-0000-000000000001','francois','crebassa','crebassasel@free.fr','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000352-0000-0000-0000-000000000001','MOHAMED HAYSAM','SAWAF','cabinetsawaf@gmail.com','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000375-0000-0000-0000-000000000001','LAURENT','BOKOBZA','docboko@orange.fr','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000376-0000-0000-0000-000000000001','EMELINE','DELTOMBE','emeline.deltombe@gmail.com','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000378-0000-0000-0000-000000000001','YILING','HSIAO','candy@biotech-taiwan.com','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000415-0000-0000-0000-000000000001','Philippe','NOZAIS','phnozais@mac.com','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000437-0000-0000-0000-000000000001','MICHELE','PIOMBINO','studiopiombino@tiscali.it','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000442-0000-0000-0000-000000000001','MOHAMED KAMAL','ZEHRAOUI','cdcolline@gmail.com.disabled','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000448-0000-0000-0000-000000000001','Stephane','ARTERO','artero.s@me.com','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000461-0000-0000-0000-000000000001','NERIO','TONIETTO','toniettonerio@libero.it','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000467-0000-0000-0000-000000000001','Alain','GRIOTIER','griotine74@gmail.com','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000472-0000-0000-0000-000000000001','Gian Luca','D\'Uggento','studiodentisticoduggento@gmail.com','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000512-0000-0000-0000-000000000001','Jean-Christophe','Schlick','doc.jcs52@gmail.com','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000597-0000-0000-0000-000000000001','QuickscanWow','Trial','accounting@denterpriseintl.com','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000650-0000-0000-0000-000000000001','Richard','OLLIER','ollier.richard@gmail.com','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41'),('00000689-0000-0000-0000-000000000001','BY AXE ORTHO','SMILERS LAB','axe-ortho@outlook.fr','',NULL,'','','',NULL,NULL,'2022-02-28 17:23:41');
/*!40000 ALTER TABLE `PersonInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PhoneInfo`
--

DROP TABLE IF EXISTS `PhoneInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PhoneInfo` (
  `id` char(36) NOT NULL COMMENT '(DC2Type:guid)',
  `mainPhone` varchar(45) DEFAULT NULL,
  `cellular` varchar(45) DEFAULT NULL,
  `fax` varchar(45) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PhoneInfo`
--

LOCK TABLES `PhoneInfo` WRITE;
/*!40000 ALTER TABLE `PhoneInfo` DISABLE KEYS */;
INSERT INTO `PhoneInfo` VALUES ('00000001-0000-0000-0000-000000000001','123322332','','',NULL,NULL,'2022-02-28 17:23:41'),('00000002-0000-0000-0000-000000000001','056139839','','',NULL,NULL,'2022-02-28 17:23:41'),('00000003-0000-0000-0000-000000000001','542138759','','',NULL,NULL,'2022-02-28 17:23:41'),('00000004-0000-0000-0000-000000000001','','','',NULL,NULL,'2022-02-28 17:23:41'),('00000005-0000-0000-0000-000000000001','0388334408','','',NULL,NULL,'2022-02-28 17:23:41'),('00000006-0000-0000-0000-000000000001','0491776127','','',NULL,NULL,'2022-02-28 17:23:41'),('00000007-0000-0000-0000-000000000001','0664864059','','',NULL,NULL,'2022-02-28 17:23:41'),('00000008-0000-0000-0000-000000000001','0664143389','','',NULL,NULL,'2022-02-28 17:23:41'),('00000009-0000-0000-0000-000000000001','0149698526','','',NULL,NULL,'2022-02-28 17:23:41'),('00000010-0000-0000-0000-000000000001','0674334568','','',NULL,NULL,'2022-02-28 17:23:41'),('00000011-0000-0000-0000-000000000001','00000000000000000','','',NULL,NULL,'2022-02-28 17:23:41'),('00000017-0000-0000-0000-000000000001','0699795775','','',NULL,NULL,'2022-02-28 17:23:41'),('00000036-0000-0000-0000-000000000001','07375389999','','',NULL,NULL,'2022-02-28 17:23:41'),('00000048-0000-0000-0000-000000000001','0388222811','','',NULL,NULL,'2022-02-28 17:23:41'),('00000058-0000-0000-0000-000000000001','475462479','','',NULL,NULL,'2022-02-28 17:23:41'),('00000061-0000-0000-0000-000000000001','0450921643','','',NULL,NULL,'2022-02-28 17:23:41'),('00000080-0000-0000-0000-000000000001','0296321142','','',NULL,NULL,'2022-02-28 17:23:41'),('00000086-0000-0000-0000-000000000001','660474450','','',NULL,NULL,'2022-02-28 17:23:41'),('00000090-0000-0000-0000-000000000001','0699662350','','',NULL,NULL,'2022-02-28 17:23:41'),('00000100-0000-0000-0000-000000000001','233170622','','',NULL,NULL,'2022-02-28 17:23:41'),('00000117-0000-0000-0000-000000000001','147717254','','',NULL,NULL,'2022-02-28 17:23:41'),('00000135-0000-0000-0000-000000000001','382255179','','',NULL,NULL,'2022-02-28 17:23:41'),('00000154-0000-0000-0000-000000000001','0688570810','','',NULL,NULL,'2022-02-28 17:23:41'),('00000163-0000-0000-0000-000000000001','478421239','','',NULL,NULL,'2022-02-28 17:23:41'),('00000169-0000-0000-0000-000000000001','17333080','','',NULL,NULL,'2022-02-28 17:23:41'),('00000172-0000-0000-0000-000000000001','0559830648','','',NULL,NULL,'2022-02-28 17:23:41'),('00000176-0000-0000-0000-000000000001','0692118957','','',NULL,NULL,'2022-02-28 17:23:41'),('00000177-0000-0000-0000-000000000001','660474450','','',NULL,NULL,'2022-02-28 17:23:41'),('00000196-0000-0000-0000-000000000001','0238747321','','',NULL,NULL,'2022-02-28 17:23:41'),('00000211-0000-0000-0000-000000000001','676815885','','',NULL,NULL,'2022-02-28 17:23:41'),('00000220-0000-0000-0000-000000000001','912554208','','',NULL,NULL,'2022-02-28 17:23:41'),('00000245-0000-0000-0000-000000000001','0478525977','','',NULL,NULL,'2022-02-28 17:23:41'),('00000254-0000-0000-0000-000000000001','0148568894','','',NULL,NULL,'2022-02-28 17:23:41'),('00000270-0000-0000-0000-000000000001','3925668438','','',NULL,NULL,'2022-02-28 17:23:41'),('00000281-0000-0000-0000-000000000001','0142275230','','',NULL,NULL,'2022-02-28 17:23:41'),('00000289-0000-0000-0000-000000000001','0382269122','','',NULL,NULL,'2022-02-28 17:23:41'),('00000296-0000-0000-0000-000000000001','916842187','','',NULL,NULL,'2022-02-28 17:23:41'),('00000297-0000-0000-0000-000000000001','0663475656','','',NULL,NULL,'2022-02-28 17:23:41'),('00000300-0000-0000-0000-000000000001','0493246425','','',NULL,NULL,'2022-02-28 17:23:41'),('00000310-0000-0000-0000-000000000001','0466676511','','',NULL,NULL,'2022-02-28 17:23:41'),('00000318-0000-0000-0000-000000000001','3296125572','','',NULL,NULL,'2022-02-28 17:23:41'),('00000321-0000-0000-0000-000000000001','089878511','','',NULL,NULL,'2022-02-28 17:23:41'),('00000330-0000-0000-0000-000000000001','466531389','','',NULL,NULL,'2022-02-28 17:23:41'),('00000352-0000-0000-0000-000000000001','146076695','','',NULL,NULL,'2022-02-28 17:23:41'),('00000375-0000-0000-0000-000000000001','0142357044','','',NULL,NULL,'2022-02-28 17:23:41'),('00000376-0000-0000-0000-000000000001','0637114521','','',NULL,NULL,'2022-02-28 17:23:41'),('00000378-0000-0000-0000-000000000001','0912932347','','',NULL,NULL,'2022-02-28 17:23:41'),('00000415-0000-0000-0000-000000000001','0299670707','','',NULL,NULL,'2022-02-28 17:23:41'),('00000437-0000-0000-0000-000000000001','3355346398','','',NULL,NULL,'2022-02-28 17:23:41'),('00000442-0000-0000-0000-000000000001','661458376','','',NULL,NULL,'2022-02-28 17:23:41'),('00000448-0000-0000-0000-000000000001','0603280216','','',NULL,NULL,'2022-02-28 17:23:41'),('00000461-0000-0000-0000-000000000001','0431520201','','',NULL,NULL,'2022-02-28 17:23:41'),('00000467-0000-0000-0000-000000000001','0450220025','','',NULL,NULL,'2022-02-28 17:23:41'),('00000472-0000-0000-0000-000000000001','3478736446','','',NULL,NULL,'2022-02-28 17:23:41'),('00000512-0000-0000-0000-000000000001','631981737','','',NULL,NULL,'2022-02-28 17:23:41'),('00000597-0000-0000-0000-000000000001','18003232690','','',NULL,NULL,'2022-02-28 17:23:41'),('00000650-0000-0000-0000-000000000001','0473931729','','',NULL,NULL,'2022-02-28 17:23:41'),('00000689-0000-0000-0000-000000000001','04 79 26 15 66','','',NULL,NULL,'2022-02-28 17:23:41');
/*!40000 ALTER TABLE `PhoneInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Professional`
--

DROP TABLE IF EXISTS `Professional`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Professional` (
  `id` mediumint unsigned NOT NULL,
  `UUID` char(36) NOT NULL,
  `credentialsID` char(36) DEFAULT NULL,
  `comments` text,
  `personInfoID` char(36) DEFAULT NULL COMMENT '(DC2Type:guid)',
  `phoneInfoID` char(36) DEFAULT NULL COMMENT '(DC2Type:guid)',
  `addressInfoID` char(36) DEFAULT NULL COMMENT '(DC2Type:guid)',
  `configID` mediumint unsigned DEFAULT NULL,
  `syncInfoID` mediumint unsigned DEFAULT NULL,
  `surgeryName` varchar(255) DEFAULT NULL,
  `type` enum('Undefined','Prothesist','Dentist','Demo','Other') NOT NULL DEFAULT 'Undefined',
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastConnection` timestamp NULL DEFAULT NULL,
  `lastConnectionChecked` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `limitedContactID` char(36) DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `directoryVisible` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_AB84A8523D139428` (`personInfoID`),
  UNIQUE KEY `UNIQ_AB84A852627FFEF6` (`phoneInfoID`),
  UNIQUE KEY `UNIQ_AB84A852A680FCCC` (`addressInfoID`),
  KEY `fk_Professional_Credentials` (`credentialsID`,`id`),
  KEY `fk_Professional_PersonInfo` (`personInfoID`,`id`),
  KEY `fk_Professional_PhoneInfo` (`phoneInfoID`,`id`),
  KEY `fk_Professional_AddressInfo` (`addressInfoID`,`id`),
  KEY `fk_Professional_Config` (`configID`,`id`),
  KEY `fk_Professional_SyncInfo` (`syncInfoID`,`id`),
  CONSTRAINT `fk_Professional_AddressInfo` FOREIGN KEY (`addressInfoID`) REFERENCES `AddressInfo` (`id`),
  CONSTRAINT `fk_Professional_Config` FOREIGN KEY (`configID`, `id`) REFERENCES `Config` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Professional_Credentials` FOREIGN KEY (`credentialsID`) REFERENCES `Credentials` (`id`),
  CONSTRAINT `fk_Professional_PersonInfo` FOREIGN KEY (`personInfoID`) REFERENCES `PersonInfo` (`id`),
  CONSTRAINT `fk_Professional_PhoneInfo` FOREIGN KEY (`phoneInfoID`) REFERENCES `PhoneInfo` (`id`),
  CONSTRAINT `fk_Professional_SyncInfo` FOREIGN KEY (`syncInfoID`, `id`) REFERENCES `SyncInfo` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Professional`
--

LOCK TABLES `Professional` WRITE;
/*!40000 ALTER TABLE `Professional` DISABLE KEYS */;
INSERT INTO `Professional` VALUES (1,'11644397-36f2-491f-aabf-b61c5414e0a5','00000001-0000-0000-0000-000000000001','','00000001-0000-0000-0000-000000000001','00000001-0000-0000-0000-000000000001','00000001-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2022-02-02 15:55:31',NULL,'2022-02-01 18:06:30','2022-02-28 17:23:42',NULL,'2022-02-01 19:06:30',1),(2,'bf19c334-c71b-4e23-9ce0-73ddec5fe103',NULL,'','00000002-0000-0000-0000-000000000001','00000002-0000-0000-0000-000000000001','00000002-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2022-01-31 12:18:20',NULL,NULL,'2022-02-28 17:23:42',NULL,'2022-01-31 12:17:06',1),(3,'7655b09e-027b-49c5-9b6c-832c6e41cee8',NULL,'','00000003-0000-0000-0000-000000000001','00000003-0000-0000-0000-000000000001','00000003-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2021-12-10 14:54:22',NULL,NULL,'2022-02-28 17:23:42',NULL,'2021-12-10 14:53:52',1),(4,'f9956579-5087-49cb-8cae-a68c167b00d6',NULL,'','00000004-0000-0000-0000-000000000001','00000004-0000-0000-0000-000000000001','00000004-0000-0000-0000-000000000001',1,1,'','Other',NULL,'2019-07-01 15:21:36',NULL,NULL,'2022-02-28 17:23:42',NULL,'2019-07-01 15:21:36',1),(5,'35997e6a-79be-404d-8b2c-46fa78f0f219',NULL,'','00000005-0000-0000-0000-000000000001','00000005-0000-0000-0000-000000000001','00000005-0000-0000-0000-000000000001',1,1,'','Other',NULL,'2020-02-21 15:56:57',NULL,NULL,'2022-02-28 17:23:42',NULL,'2020-02-21 15:56:57',1),(6,'372fe703-e954-4df2-a079-51315f137deb',NULL,'','00000006-0000-0000-0000-000000000001','00000006-0000-0000-0000-000000000001','00000006-0000-0000-0000-000000000001',1,1,'','Other',NULL,'2019-07-26 06:43:50',NULL,NULL,'2022-02-28 17:23:42',NULL,'2019-07-02 11:05:21',1),(7,'14d1a5e5-e2aa-42ab-9b88-6ff9da357d9b',NULL,'','00000007-0000-0000-0000-000000000001','00000007-0000-0000-0000-000000000001','00000007-0000-0000-0000-000000000001',1,1,'','Other',NULL,'2019-07-22 17:07:13',NULL,NULL,'2022-02-28 17:23:42',NULL,'2019-07-22 17:07:13',1),(8,'48539f38-473c-4be5-b635-3fb0fd42b27e',NULL,'','00000008-0000-0000-0000-000000000001','00000008-0000-0000-0000-000000000001','00000008-0000-0000-0000-000000000001',1,1,'','Other',NULL,'2019-07-22 19:36:25',NULL,NULL,'2022-02-28 17:23:42',NULL,'2019-07-22 19:36:25',1),(9,'1dab4f0e-ae37-4417-a649-d2a1322d368a',NULL,'','00000009-0000-0000-0000-000000000001','00000009-0000-0000-0000-000000000001','00000009-0000-0000-0000-000000000001',1,1,'','Other',NULL,'2020-01-24 14:39:35',NULL,NULL,'2022-02-28 17:23:42',NULL,'2019-07-11 10:05:09',1),(10,'2fb08d08-4149-492e-b8ba-d6cdca165170',NULL,'','00000010-0000-0000-0000-000000000001','00000010-0000-0000-0000-000000000001','00000010-0000-0000-0000-000000000001',1,1,'','Other',NULL,'2019-07-02 16:18:49',NULL,NULL,'2022-02-28 17:23:42',NULL,'2019-07-02 11:16:13',1),(11,'9073bbcf-3ad7-4cbb-b538-10d515250299',NULL,'','00000011-0000-0000-0000-000000000001','00000011-0000-0000-0000-000000000001','00000011-0000-0000-0000-000000000001',1,1,'','Undefined',NULL,'2020-12-09 11:10:32',NULL,NULL,'2022-02-28 17:23:42',NULL,'2019-07-09 14:58:50',1),(17,'6aa94614-d087-4d34-9779-1a625bc58f2e',NULL,'','00000017-0000-0000-0000-000000000001','00000017-0000-0000-0000-000000000001','00000017-0000-0000-0000-000000000001',1,1,'','Undefined',NULL,'2020-06-01 19:47:46',NULL,NULL,'2022-02-28 17:23:42',NULL,'2019-11-08 09:44:14',1),(36,'7c3106f8-f113-475c-bf9e-ab869a9d0e62',NULL,'','00000036-0000-0000-0000-000000000001','00000036-0000-0000-0000-000000000001','00000036-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2022-01-27 11:54:11',NULL,NULL,'2022-02-28 17:23:42',NULL,'2022-01-27 10:34:10',1),(48,'d2453838-70bf-472d-846f-a745ee53ea42',NULL,'','00000048-0000-0000-0000-000000000001','00000048-0000-0000-0000-000000000001','00000048-0000-0000-0000-000000000001',1,1,'','Undefined',NULL,'2020-06-01 19:47:46',NULL,NULL,'2022-02-28 17:23:42',NULL,'2019-12-04 14:52:16',1),(58,'112d2a1b-0c28-43c0-a1d5-2d8d5d2bc12d',NULL,'','00000058-0000-0000-0000-000000000001','00000058-0000-0000-0000-000000000001','00000058-0000-0000-0000-000000000001',1,1,'','Undefined',NULL,'2020-06-01 19:47:46',NULL,NULL,'2022-02-28 17:23:42',NULL,'2020-02-17 09:16:28',1),(61,'03716840-e53a-4ca9-8336-17c665bb0817',NULL,'','00000061-0000-0000-0000-000000000001','00000061-0000-0000-0000-000000000001','00000061-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2020-06-29 17:49:39',NULL,NULL,'2022-02-28 17:23:42',NULL,'2020-06-29 17:04:07',1),(80,'29fa928f-a3c3-4f3b-897b-f570d898e70e',NULL,'','00000080-0000-0000-0000-000000000001','00000080-0000-0000-0000-000000000001','00000080-0000-0000-0000-000000000001',1,1,'','Undefined',NULL,'2020-06-01 19:47:46',NULL,NULL,'2022-02-28 17:23:42',NULL,'2019-10-14 16:11:29',1),(86,'7c3054cc-885b-4074-b46a-645c7e8463b9',NULL,'','00000086-0000-0000-0000-000000000001','00000086-0000-0000-0000-000000000001','00000086-0000-0000-0000-000000000001',1,1,'','Undefined',NULL,'2020-06-01 19:47:46',NULL,NULL,'2022-02-28 17:23:42',NULL,'2020-02-29 22:05:08',1),(90,'2aa4983c-9c5f-4cab-a4e8-7f8bce33f0bc',NULL,'','00000090-0000-0000-0000-000000000001','00000090-0000-0000-0000-000000000001','00000090-0000-0000-0000-000000000001',1,1,'','Undefined',NULL,'2020-06-01 19:47:46',NULL,NULL,'2022-02-28 17:23:42',NULL,'2019-07-19 11:35:20',1),(100,'a749c170-319d-41da-86a4-dfa0e6eeb98e',NULL,'','00000100-0000-0000-0000-000000000001','00000100-0000-0000-0000-000000000001','00000100-0000-0000-0000-000000000001',1,1,'','Undefined',NULL,'2020-06-01 19:47:46',NULL,NULL,'2022-02-28 17:23:42',NULL,'2020-03-15 11:33:08',1),(117,'64acfb41-e813-445c-b9a5-41685f5ae37a',NULL,'','00000117-0000-0000-0000-000000000001','00000117-0000-0000-0000-000000000001','00000117-0000-0000-0000-000000000001',1,1,'','Undefined',NULL,'2020-06-01 19:47:46',NULL,NULL,'2022-02-28 17:23:42',NULL,'2019-07-23 17:38:37',1),(135,'25a033fe-048e-4153-b453-cea9d0f2385c',NULL,'','00000135-0000-0000-0000-000000000001','00000135-0000-0000-0000-000000000001','00000135-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2020-07-03 13:19:46',NULL,NULL,'2022-02-28 17:23:42',NULL,'2020-07-03 12:36:33',1),(154,'c5d10414-5e57-4274-96d1-683537464fb3',NULL,'','00000154-0000-0000-0000-000000000001','00000154-0000-0000-0000-000000000001','00000154-0000-0000-0000-000000000001',1,1,'','Undefined',NULL,'2020-06-01 19:47:46',NULL,NULL,'2022-02-28 17:23:42',NULL,'2020-03-03 11:08:01',1),(163,'af4a9c1b-956e-4f70-b8f8-f40cadc590ff',NULL,'','00000163-0000-0000-0000-000000000001','00000163-0000-0000-0000-000000000001','00000163-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2021-12-16 23:15:31',NULL,NULL,'2022-02-28 17:23:42',NULL,'2021-12-16 22:51:45',1),(169,'ed9b274d-c573-4f8f-9729-f016b045e0b0',NULL,'','00000169-0000-0000-0000-000000000001','00000169-0000-0000-0000-000000000001','00000169-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2020-08-11 08:57:22',NULL,NULL,'2022-02-28 17:23:42',NULL,'2020-08-11 08:50:50',1),(172,'36701f7c-94a7-4ef6-a635-25b6dc5e0f86',NULL,'','00000172-0000-0000-0000-000000000001','00000172-0000-0000-0000-000000000001','00000172-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2022-02-02 12:13:53',NULL,NULL,'2022-02-28 17:23:42',NULL,'2022-02-02 12:10:34',1),(176,'a60703c0-4832-4896-8ffb-a074885ee958',NULL,'','00000176-0000-0000-0000-000000000001','00000176-0000-0000-0000-000000000001','00000176-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2020-06-26 15:50:39',NULL,NULL,'2022-02-28 17:23:42',NULL,'2020-06-26 15:34:39',1),(177,'99a046a4-f05a-4eab-995e-4f0fda8261e2',NULL,'','00000177-0000-0000-0000-000000000001','00000177-0000-0000-0000-000000000001','00000177-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2021-11-12 14:01:55',NULL,NULL,'2022-02-28 17:23:42',NULL,'2021-01-12 18:18:25',1),(196,'4625d6a2-6fb3-47c7-ba9f-49d2502c4b6b',NULL,'','00000196-0000-0000-0000-000000000001','00000196-0000-0000-0000-000000000001','00000196-0000-0000-0000-000000000001',1,1,'','Undefined',NULL,'2020-06-01 19:47:46',NULL,NULL,'2022-02-28 17:23:42',NULL,'2019-11-06 13:01:17',1),(211,'54009839-7a10-41cb-bda1-41be5341133c',NULL,'','00000211-0000-0000-0000-000000000001','00000211-0000-0000-0000-000000000001','00000211-0000-0000-0000-000000000001',1,1,'','Undefined',NULL,'2020-06-01 19:47:46',NULL,NULL,'2022-02-28 17:23:42',NULL,'2020-01-15 18:28:17',1),(220,'e44d8f16-8a1f-4abb-ab4c-fd413128f5da',NULL,'','00000220-0000-0000-0000-000000000001','00000220-0000-0000-0000-000000000001','00000220-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2021-03-31 00:14:56',NULL,NULL,'2022-02-28 17:23:42',NULL,'2021-03-31 00:09:01',1),(245,'5af7bf9a-5a6f-42be-bf1f-f08ad10d8515',NULL,'','00000245-0000-0000-0000-000000000001','00000245-0000-0000-0000-000000000001','00000245-0000-0000-0000-000000000001',1,1,'','Undefined',NULL,'2020-06-01 19:47:46',NULL,NULL,'2022-02-28 17:23:42',NULL,'2020-03-12 19:02:58',1),(254,'15bfecbd-079f-40a5-a98b-c2e3f642d019',NULL,'','00000254-0000-0000-0000-000000000001','00000254-0000-0000-0000-000000000001','00000254-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2021-07-02 18:52:42',NULL,NULL,'2022-02-28 17:23:42',NULL,'2021-07-02 11:49:45',1),(270,'075b6e69-5d72-4985-a21a-f68757abdae8',NULL,'','00000270-0000-0000-0000-000000000001','00000270-0000-0000-0000-000000000001','00000270-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2020-10-28 14:49:51',NULL,NULL,'2022-02-28 17:23:42',NULL,'2020-10-28 14:49:21',1),(281,'e27138a6-eba7-4174-b924-698bb33d1709',NULL,'','00000281-0000-0000-0000-000000000001','00000281-0000-0000-0000-000000000001','00000281-0000-0000-0000-000000000001',1,1,'','Undefined',NULL,'2020-06-01 19:47:46',NULL,NULL,'2022-02-28 17:23:42',NULL,'2020-01-22 17:07:20',1),(289,'bfe19bae-ec92-480d-ab1c-f375d9df5ca4',NULL,'','00000289-0000-0000-0000-000000000001','00000289-0000-0000-0000-000000000001','00000289-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2022-02-02 15:55:24',NULL,NULL,'2022-02-28 17:23:42',NULL,'2022-02-02 12:59:00',1),(296,'f7a87159-d6e8-4c0b-8df2-ec453ae177d4',NULL,'','00000296-0000-0000-0000-000000000001','00000296-0000-0000-0000-000000000001','00000296-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2020-06-30 13:16:34',NULL,NULL,'2022-02-28 17:23:42',NULL,'2020-06-30 13:08:55',1),(297,'a3deadf8-82b7-48b1-9559-db184cdcd959',NULL,'','00000297-0000-0000-0000-000000000001','00000297-0000-0000-0000-000000000001','00000297-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2020-11-03 18:37:22',NULL,NULL,'2022-02-28 17:23:42',NULL,'2020-11-03 18:30:43',1),(300,'7ad10910-09e0-47db-bb4d-e7a2c509bb94',NULL,'','00000300-0000-0000-0000-000000000001','00000300-0000-0000-0000-000000000001','00000300-0000-0000-0000-000000000001',1,1,'','Undefined',NULL,'2020-06-01 19:47:46',NULL,NULL,'2022-02-28 17:23:42',NULL,'2019-11-07 10:24:19',1),(310,'a31c69f7-a237-4e91-98c5-6e7a0c626d76',NULL,'','00000310-0000-0000-0000-000000000001','00000310-0000-0000-0000-000000000001','00000310-0000-0000-0000-000000000001',1,1,'','Undefined',NULL,'2020-06-01 19:47:46',NULL,NULL,'2022-02-28 17:23:42',NULL,'2019-12-11 12:15:47',1),(318,'b7c7a936-38a7-47b0-99cc-31f32291f009',NULL,'','00000318-0000-0000-0000-000000000001','00000318-0000-0000-0000-000000000001','00000318-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2022-02-01 12:29:04',NULL,NULL,'2022-02-28 17:23:42',NULL,'2022-02-01 12:28:16',1),(321,'3d18a6be-69fa-4739-b8dd-76b2ae7ae9eb',NULL,'','00000321-0000-0000-0000-000000000001','00000321-0000-0000-0000-000000000001','00000321-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2021-03-13 07:26:31',NULL,NULL,'2022-02-28 17:23:42',NULL,'2021-03-13 07:24:39',1),(330,'62ebb61d-ff7f-480e-9a35-e5aee7ffd855',NULL,'','00000330-0000-0000-0000-000000000001','00000330-0000-0000-0000-000000000001','00000330-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2022-02-02 08:31:42',NULL,NULL,'2022-02-28 17:23:42',NULL,'2022-02-02 08:31:41',1),(352,'a7aef489-30cd-4dfb-b9e5-0ee813600c45',NULL,'','00000352-0000-0000-0000-000000000001','00000352-0000-0000-0000-000000000001','00000352-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2020-11-24 20:10:36',NULL,NULL,'2022-02-28 17:23:42',NULL,'2020-11-24 14:50:57',1),(375,'4143cd0b-67ef-4dd8-baf4-06622a105550',NULL,'','00000375-0000-0000-0000-000000000001','00000375-0000-0000-0000-000000000001','00000375-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2020-10-06 12:09:00',NULL,NULL,'2022-02-28 17:23:42',NULL,'2020-10-06 12:05:00',1),(376,'ebef95fb-6b43-4da2-a293-d06a12ba2a2d',NULL,'','00000376-0000-0000-0000-000000000001','00000376-0000-0000-0000-000000000001','00000376-0000-0000-0000-000000000001',1,1,'','Undefined',NULL,'2020-06-01 19:47:46',NULL,NULL,'2022-02-28 17:23:42',NULL,'2020-02-19 16:10:28',1),(378,'52fa50f6-ff1f-433e-bf74-66891409f1cf',NULL,'','00000378-0000-0000-0000-000000000001','00000378-0000-0000-0000-000000000001','00000378-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2022-01-13 08:11:06',NULL,NULL,'2022-02-28 17:23:42',NULL,'2022-01-13 08:09:06',1),(415,'0a6d4f7b-130d-40f4-9386-c17fb50c8f67',NULL,'','00000415-0000-0000-0000-000000000001','00000415-0000-0000-0000-000000000001','00000415-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2021-12-18 17:59:16',NULL,NULL,'2022-02-28 17:23:42',NULL,'2021-12-18 17:54:34',1),(437,'4cb42521-d57a-4eb5-a95a-7ae9a67f8072',NULL,'','00000437-0000-0000-0000-000000000001','00000437-0000-0000-0000-000000000001','00000437-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2022-01-25 06:44:12',NULL,NULL,'2022-02-28 17:23:42',NULL,'2022-01-24 12:00:12',1),(442,'ae31bb4e-fba9-43bb-8871-7b7b438c7176',NULL,'','00000442-0000-0000-0000-000000000001','00000442-0000-0000-0000-000000000001','00000442-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2021-10-06 16:30:14',NULL,NULL,'2022-02-28 17:23:42',NULL,'2020-10-09 13:44:52',1),(448,'f7c8f616-e72a-44a0-95f5-959fa733e848',NULL,'','00000448-0000-0000-0000-000000000001','00000448-0000-0000-0000-000000000001','00000448-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2022-02-02 13:03:58',NULL,NULL,'2022-02-28 17:23:42',NULL,'2022-02-02 12:33:58',1),(461,'899283ad-262a-48e9-be97-8ee21fceb50b',NULL,'','00000461-0000-0000-0000-000000000001','00000461-0000-0000-0000-000000000001','00000461-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2022-01-27 17:29:47',NULL,NULL,'2022-02-28 17:23:42',NULL,'2022-01-27 16:46:43',1),(467,'f53b1bca-6d59-4def-bb0c-53fc22d4df14',NULL,'','00000467-0000-0000-0000-000000000001','00000467-0000-0000-0000-000000000001','00000467-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2020-06-15 16:02:36',NULL,NULL,'2022-02-28 17:23:42',NULL,'2020-06-15 16:01:55',1),(472,'0ba04c1d-215d-4c1b-8f56-80b0bbf13858',NULL,'','00000472-0000-0000-0000-000000000001','00000472-0000-0000-0000-000000000001','00000472-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2021-12-10 09:19:17',NULL,NULL,'2022-02-28 17:23:42',NULL,'2021-12-10 08:44:52',1),(512,'d971020b-f0fc-4769-955d-7439c14f0a48',NULL,'','00000512-0000-0000-0000-000000000001','00000512-0000-0000-0000-000000000001','00000512-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2021-12-20 09:18:02',NULL,NULL,'2022-02-28 17:23:42',NULL,'2021-12-19 17:44:53',1),(597,'6a64bac3-a12f-4701-bd0b-b6d4e900958d',NULL,'','00000597-0000-0000-0000-000000000001','00000597-0000-0000-0000-000000000001','00000597-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2020-09-29 21:11:06',NULL,NULL,'2022-02-28 17:23:42',NULL,'2020-09-29 21:10:47',1),(650,'d5797499-29a6-4def-9d8e-c60228a0efc2',NULL,'','00000650-0000-0000-0000-000000000001','00000650-0000-0000-0000-000000000001','00000650-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2022-02-02 15:55:24',NULL,NULL,'2022-02-28 17:23:42',NULL,'2022-02-02 11:57:22',1),(689,'464a0019-6c2e-403e-b0a5-f1b453741d76',NULL,'','00000689-0000-0000-0000-000000000001','00000689-0000-0000-0000-000000000001','00000689-0000-0000-0000-000000000001',1,1,'','Prothesist',NULL,'2020-11-03 08:29:54',NULL,NULL,'2022-02-28 17:23:42',NULL,'2020-11-03 08:29:54',1);
/*!40000 ALTER TABLE `Professional` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProfessionalEnvInfos`
--

DROP TABLE IF EXISTS `ProfessionalEnvInfos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProfessionalEnvInfos` (
  `id` char(36) NOT NULL COMMENT '(DC2Type:guid)',
  `professionalID` mediumint unsigned NOT NULL DEFAULT '0' COMMENT 'Le professionnel propriétaire des informations',
  `accessCode` varchar(45) DEFAULT NULL,
  `status` enum('created','confirmed','blocked') NOT NULL DEFAULT 'created',
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `preventDuplicateProfessionalEnvInfos` (`professionalID`),
  KEY `fk_ProfessionalEnvInfos_RefersTo_idx` (`professionalID`),
  CONSTRAINT `FK_A15010B8C37A46A` FOREIGN KEY (`professionalID`) REFERENCES `Professional` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProfessionalEnvInfos`
--

LOCK TABLES `ProfessionalEnvInfos` WRITE;
/*!40000 ALTER TABLE `ProfessionalEnvInfos` DISABLE KEYS */;
INSERT INTO `ProfessionalEnvInfos` VALUES ('0d696203-c1d5-4915-b8e8-a324ea34a999',310,NULL,'confirmed','2022-02-28 17:23:42'),('131f33cf-c9b0-48df-9dce-55064c0f7d3b',80,NULL,'confirmed','2022-02-28 17:23:42'),('196c3302-b2c7-4d83-aac2-e4e1601131b0',7,NULL,'confirmed','2022-02-28 17:23:42'),('19e0026c-be7e-4a6b-8517-b1373a97114f',437,NULL,'confirmed','2022-02-28 17:23:42'),('1d8beed7-5198-4767-8a2d-cb720477b3f8',378,NULL,'confirmed','2022-02-28 17:23:42'),('1f281c0d-2ecb-487d-9afe-95cf60af21fd',177,NULL,'confirmed','2022-02-28 17:23:42'),('2d867a92-dc4c-4820-8e73-ddc9c00a26d7',36,NULL,'confirmed','2022-02-28 17:23:42'),('2fd8d3b4-9300-42c7-b3f1-63e73a80f8cc',689,NULL,'confirmed','2022-02-28 17:23:42'),('30d73f73-aab8-41eb-ab1c-9744f42aff09',9,NULL,'confirmed','2022-02-28 17:23:42'),('33c6b6ce-f6b5-4a48-bcda-ad217d866c3c',17,NULL,'confirmed','2022-02-28 17:23:42'),('3a4977cf-a830-454f-8667-e1876f1686d8',318,NULL,'confirmed','2022-02-28 17:23:42'),('3b5580b0-d173-45e9-8e32-953475ab8cba',254,NULL,'confirmed','2022-02-28 17:23:42'),('3b7d6ebc-7736-42ee-babe-07ddc1acb0c8',512,NULL,'confirmed','2022-02-28 17:23:42'),('42959726-2c01-4076-838e-1690ecce5c5c',48,NULL,'confirmed','2022-02-28 17:23:42'),('4608f33f-ee27-4af6-9195-cd0636acaa4a',11,NULL,'confirmed','2022-02-28 17:23:42'),('47eae2d4-9669-4c87-b2a9-4793a2a4567f',176,NULL,'confirmed','2022-02-28 17:23:42'),('4dda4d61-9959-4da8-96bb-169ba4fbf519',90,NULL,'confirmed','2022-02-28 17:23:42'),('511b7baf-771a-496c-84c3-e074fcfb4f8c',154,NULL,'confirmed','2022-02-28 17:23:42'),('55bc52e7-9d50-40a2-8cc3-19dca95d013f',375,NULL,'confirmed','2022-02-28 17:23:42'),('5ac60ca5-2ee9-4df4-bf59-c4a04a65261a',300,NULL,'confirmed','2022-02-28 17:23:42'),('5fb2f90a-be1f-4800-9c98-cb7ebf1d5915',3,NULL,'confirmed','2022-02-28 17:23:42'),('60731df0-7457-48c0-932b-ebe63e7b74b2',117,NULL,'confirmed','2022-02-28 17:23:42'),('63fd94ec-bca4-498b-8f71-f0737c579c5a',2,NULL,'confirmed','2022-02-28 17:23:42'),('6633682d-d649-4611-b67f-f6e74faaa99e',86,NULL,'confirmed','2022-02-28 17:23:42'),('6a5ceb7f-5a6b-447a-b938-0198f8b4d6c2',472,NULL,'confirmed','2022-02-28 17:23:42'),('6d822f1b-a301-4fcd-b886-a1b73f9358b8',442,NULL,'confirmed','2022-02-28 17:23:42'),('7075cd8d-b262-42a1-88c4-1348493d345b',376,NULL,'confirmed','2022-02-28 17:23:42'),('708a2e08-9488-40fd-a918-5c94114c40bf',8,NULL,'confirmed','2022-02-28 17:23:42'),('732d5b37-6e89-40db-ba0b-170b279c80ea',163,NULL,'confirmed','2022-02-28 17:23:42'),('7ce436af-9abc-4571-a9f8-61a317fd5304',461,NULL,'confirmed','2022-02-28 17:23:42'),('812c03b2-8ef4-447a-8b3c-bfb0119818e5',650,NULL,'confirmed','2022-02-28 17:23:42'),('905a750f-983d-4e91-a485-9a07396f5115',4,'97ea5dfd','created','2022-02-28 17:23:42'),('90e8ebf8-e926-4cac-b2a4-c9d635bfaf37',415,NULL,'confirmed','2022-02-28 17:23:42'),('97edf71f-0bd8-4cd2-b63e-55d789acaed8',61,NULL,'confirmed','2022-02-28 17:23:42'),('9acb2ce3-100b-4a94-8d40-c98ebfaa61aa',5,NULL,'confirmed','2022-02-28 17:23:42'),('a40e1ec2-ada0-426b-9ce4-07da1e638060',10,NULL,'confirmed','2022-02-28 17:23:42'),('a77dc946-f7e8-4007-a6ea-7bbb82ee1b74',6,NULL,'confirmed','2022-02-28 17:23:42'),('ab0c4779-6438-48cf-9a44-1eb16ccac3e0',196,NULL,'confirmed','2022-02-28 17:23:42'),('b361d9d3-26ff-4ccb-8e85-358096835010',297,NULL,'confirmed','2022-02-28 17:23:42'),('b54b2d86-c3bb-4080-937a-4a16273ee5f3',296,NULL,'confirmed','2022-02-28 17:23:42'),('c3ae9eea-cf86-4a38-86f9-30e385db0aa2',321,NULL,'confirmed','2022-02-28 17:23:42'),('d1a05e59-62dd-4ea5-9af6-d346f7cb5d28',220,NULL,'confirmed','2022-02-28 17:23:42'),('d3761d69-18a8-4a70-ad60-230e65509165',597,NULL,'confirmed','2022-02-28 17:23:42'),('d39b3ace-ab34-4100-8c88-a79d44785f7d',352,NULL,'confirmed','2022-02-28 17:23:42'),('d5153c89-af6c-4e08-be88-b78587557e1c',211,NULL,'confirmed','2022-02-28 17:23:42'),('d6ee8910-2888-4295-a00a-2f7573b0b415',270,NULL,'confirmed','2022-02-28 17:23:42'),('dc70d764-9fa5-4443-82c3-980c1951b66e',172,NULL,'confirmed','2022-02-28 17:23:42'),('ddae7237-a207-4b6e-a7ce-d3803b6eaea4',169,NULL,'confirmed','2022-02-28 17:23:42'),('e327d790-8c5e-446c-b5de-37266ea383bf',135,NULL,'confirmed','2022-02-28 17:23:42'),('ea254f9a-cf92-4021-a96b-1f0d2c898189',100,NULL,'confirmed','2022-02-28 17:23:42'),('ebb99899-37d3-44d3-906d-4d52db225fb9',281,NULL,'confirmed','2022-02-28 17:23:42'),('ed21f6eb-0b3a-40ad-a557-535d7f2681a8',58,NULL,'confirmed','2022-02-28 17:23:42'),('ee1ac7cb-1cac-460f-a62b-37f9c1d7214f',467,NULL,'confirmed','2022-02-28 17:23:42'),('f7a13cce-491f-4229-9134-b734b8aa75b8',448,NULL,'confirmed','2022-02-28 17:23:42'),('f7bec851-025f-4c6a-88d4-b2e5775e3c2a',245,NULL,'confirmed','2022-02-28 17:23:42'),('f7f388d7-c458-459c-8f7b-3b34dafe955c',330,NULL,'confirmed','2022-02-28 17:23:42'),('f98acb2b-0b3a-4c10-9c99-d6a10f7bc981',289,NULL,'confirmed','2022-02-28 17:23:42'),('fabae590-8ba4-487a-a1fa-09848ca7a2b9',1,NULL,'confirmed','2022-02-28 17:23:42');
/*!40000 ALTER TABLE `ProfessionalEnvInfos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProfessionalPatient`
--

DROP TABLE IF EXISTS `ProfessionalPatient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProfessionalPatient` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `ownerID` mediumint unsigned NOT NULL DEFAULT '0',
  `patientID` char(36) DEFAULT NULL,
  `officeID` char(36) DEFAULT NULL,
  `enablePatientSharing` tinyint(1) DEFAULT '0',
  `pinned` tinyint(1) NOT NULL DEFAULT '0',
  `theme` enum('NONE','ADULT','BOY','GIRL','BABY') DEFAULT 'NONE',
  PRIMARY KEY (`id`),
  KEY `unique_Patient_Pro` (`ownerID`,`patientID`),
  CONSTRAINT `fk_Patient_Pro` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProfessionalPatient`
--

LOCK TABLES `ProfessionalPatient` WRITE;
/*!40000 ALTER TABLE `ProfessionalPatient` DISABLE KEYS */;
/*!40000 ALTER TABLE `ProfessionalPatient` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrder`
--

DROP TABLE IF EXISTS `ProstheticOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticOrder` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `currentDeliveryDate` datetime DEFAULT NULL,
  `previousDeliveryDate` datetime DEFAULT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `title` varchar(64) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `status` enum('not_sent','sent','date_validated','date_edited','validated','cancelled') NOT NULL DEFAULT 'sent',
  `unread` tinyint(1) DEFAULT '0',
  `createdAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `actID` char(36) NOT NULL,
  `localDisplayID` mediumint unsigned DEFAULT NULL,
  `globalDisplayID` mediumint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `idx_Order_Work` (`ownerID`),
  KEY `fk_Order_Act` (`actID`,`ownerID`),
  CONSTRAINT `fk_Order_Act` FOREIGN KEY (`actID`, `ownerID`) REFERENCES `Act` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrder`
--

LOCK TABLES `ProstheticOrder` WRITE;
/*!40000 ALTER TABLE `ProstheticOrder` DISABLE KEYS */;
/*!40000 ALTER TABLE `ProstheticOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrderFile`
--

DROP TABLE IF EXISTS `ProstheticOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticOrderFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `orderID` char(36) NOT NULL,
  `fileID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`orderID`,`fileID`),
  KEY `fk_ProstheticOrderFile_ProstheticOrder` (`orderID`,`ownerID`),
  KEY `fk_ProstheticOrderFile_CondorFile` (`fileID`,`ownerID`),
  CONSTRAINT `fk_ProstheticOrderFile_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_ProstheticOrderFile_ProstheticOrder` FOREIGN KEY (`orderID`, `ownerID`) REFERENCES `ProstheticOrder` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrderFile`
--

LOCK TABLES `ProstheticOrderFile` WRITE;
/*!40000 ALTER TABLE `ProstheticOrderFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `ProstheticOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrderRecipient`
--

DROP TABLE IF EXISTS `ProstheticOrderRecipient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticOrderRecipient` (
  `ownerID` mediumint unsigned NOT NULL,
  `orderID` char(36) NOT NULL,
  `recipientID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`orderID`,`recipientID`),
  KEY `fk_ProstheticOrderRecipient_ProstheticOrder` (`orderID`,`ownerID`),
  KEY `fk_ProstheticOrderRecipient_Contact` (`recipientID`,`ownerID`),
  CONSTRAINT `fk_ProstheticOrderRecipient_Contact` FOREIGN KEY (`recipientID`, `ownerID`) REFERENCES `Contact` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_ProstheticOrderRecipient_ProstheticOrder` FOREIGN KEY (`orderID`, `ownerID`) REFERENCES `ProstheticOrder` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrderRecipient`
--

LOCK TABLES `ProstheticOrderRecipient` WRITE;
/*!40000 ALTER TABLE `ProstheticOrderRecipient` DISABLE KEYS */;
/*!40000 ALTER TABLE `ProstheticOrderRecipient` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticSheet`
--

DROP TABLE IF EXISTS `ProstheticSheet`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticSheet` (
  `id` char(36) NOT NULL,
  `ownerID` mediumint unsigned NOT NULL,
  `orderID` char(36) NOT NULL,
  `json` text NOT NULL,
  `pdfFileID` char(36) DEFAULT NULL,
  `dateCreated` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_ProstheticSheet_ProstheticOrder` (`orderID`),
  KEY `fk_ProstheticSheet_CondorFile` (`pdfFileID`),
  CONSTRAINT `fk_ProstheticSheet_CondorFile` FOREIGN KEY (`pdfFileID`) REFERENCES `CondorFile` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_ProstheticSheet_ProstheticOrder` FOREIGN KEY (`orderID`) REFERENCES `ProstheticOrder` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticSheet`
--

LOCK TABLES `ProstheticSheet` WRITE;
/*!40000 ALTER TABLE `ProstheticSheet` DISABLE KEYS */;
/*!40000 ALTER TABLE `ProstheticSheet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ReceivedAttachment`
--

DROP TABLE IF EXISTS `ReceivedAttachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ReceivedAttachment` (
  `ownerID` mediumint unsigned NOT NULL,
  `receivedMessageID` char(36) NOT NULL,
  `fileID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`fileID`,`receivedMessageID`),
  KEY `fk_ReceivedAttachment_ReceivedMessage` (`receivedMessageID`,`ownerID`),
  KEY `fk_ReceivedAttachment_CondorFile` (`fileID`,`ownerID`),
  CONSTRAINT `fk_ReceivedAttachment_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_ReceivedAttachment_ReceivedMessage` FOREIGN KEY (`receivedMessageID`, `ownerID`) REFERENCES `ReceivedMessage` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ReceivedAttachment`
--

LOCK TABLES `ReceivedAttachment` WRITE;
/*!40000 ALTER TABLE `ReceivedAttachment` DISABLE KEYS */;
INSERT INTO `ReceivedAttachment` VALUES (1,'0cbc6e5d-6c83-11eb-9029-226cec7cb58a','1b6beae2-6c83-11eb-9029-226cec7cb58a','2022-02-01 17:09:39'),(1,'0cbc6e5d-6c83-11eb-9029-226cec7cb58a','1b6f3f7d-6c83-11eb-9029-226cec7cb58a','2022-02-01 17:09:39'),(1,'0cbc6e5d-6c83-11eb-9029-226cec7cb58a','1b70ab90-6c83-11eb-9029-226cec7cb58a','2022-02-01 17:09:39'),(1,'0cbc6e5d-6c83-11eb-9029-226cec7cb58a','1b78edc7-6c83-11eb-9029-226cec7cb58a','2022-02-01 17:09:39'),(1,'0cbc6e5d-6c83-11eb-9029-226cec7cb58a','1b7c4a09-6c83-11eb-9029-226cec7cb58a','2022-02-01 17:09:39'),(1,'0cbc6e5d-6c83-11eb-9029-226cec7cb58a','1b7ec902-6c83-11eb-9029-226cec7cb58a','2022-02-01 17:09:39'),(1,'231a29a3-52f5-11ea-947d-226cec7cb58a','231e1450-52f5-11ea-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'231a29a3-52f5-11ea-947d-226cec7cb58a','231fb1de-52f5-11ea-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'42c5bf59-200c-11ea-947d-226cec7cb58a','42d0dd0a-200c-11ea-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'42c5bf59-200c-11ea-947d-226cec7cb58a','42d3f726-200c-11ea-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'4e26f607-52f4-11ea-947d-226cec7cb58a','4e2caf6d-52f4-11ea-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'4e26f607-52f4-11ea-947d-226cec7cb58a','4e2e5fe1-52f4-11ea-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'5f2cf2cc-d2f9-11e9-947d-226cec7cb58a','5f312d28-d2f9-11e9-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'5f2cf2cc-d2f9-11e9-947d-226cec7cb58a','5f32b673-d2f9-11e9-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'5f2cf2cc-d2f9-11e9-947d-226cec7cb58a','5f343790-d2f9-11e9-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'44f69a53-7745-11eb-9452-226cec7cb58a','70c5c12a-7745-11eb-9452-226cec7cb58a','2022-02-01 17:09:39'),(1,'44f69a53-7745-11eb-9452-226cec7cb58a','70c8fe38-7745-11eb-9452-226cec7cb58a','2022-02-01 17:09:39'),(1,'44f69a53-7745-11eb-9452-226cec7cb58a','70cb6e30-7745-11eb-9452-226cec7cb58a','2022-02-01 17:09:39'),(1,'44f69a53-7745-11eb-9452-226cec7cb58a','70cdf6b6-7745-11eb-9452-226cec7cb58a','2022-02-01 17:09:39'),(1,'44f69a53-7745-11eb-9452-226cec7cb58a','70d28461-7745-11eb-9452-226cec7cb58a','2022-02-01 17:09:39'),(1,'44f69a53-7745-11eb-9452-226cec7cb58a','70d505f2-7745-11eb-9452-226cec7cb58a','2022-02-01 17:09:39'),(1,'9678b0bc-52f5-11ea-947d-226cec7cb58a','967c77a0-52f5-11ea-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'9678b0bc-52f5-11ea-947d-226cec7cb58a','967e29a6-52f5-11ea-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'9c486357-0f6d-11ea-947d-226cec7cb58a','9c4ee5de-0f6d-11ea-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'9c486357-0f6d-11ea-947d-226cec7cb58a','9c50bfc0-0f6d-11ea-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'9c486357-0f6d-11ea-947d-226cec7cb58a','9c55df9d-0f6d-11ea-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'9c486357-0f6d-11ea-947d-226cec7cb58a','9c57fdda-0f6d-11ea-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'9c486357-0f6d-11ea-947d-226cec7cb58a','9c59d928-0f6d-11ea-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'9c486357-0f6d-11ea-947d-226cec7cb58a','9c5bb198-0f6d-11ea-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'9c486357-0f6d-11ea-947d-226cec7cb58a','9c5d73fb-0f6d-11ea-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'9c486357-0f6d-11ea-947d-226cec7cb58a','9c60ed3f-0f6d-11ea-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'9ee9e018-d2f8-11e9-947d-226cec7cb58a','9eeee60f-d2f8-11e9-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'9ee9e018-d2f8-11e9-947d-226cec7cb58a','9ef00a1e-d2f8-11e9-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'9ee9e018-d2f8-11e9-947d-226cec7cb58a','9ef14755-d2f8-11e9-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'9ee9e018-d2f8-11e9-947d-226cec7cb58a','9ef2bf13-d2f8-11e9-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'9ee9e018-d2f8-11e9-947d-226cec7cb58a','9ef42a93-d2f8-11e9-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'9ee9e018-d2f8-11e9-947d-226cec7cb58a','9ef5fa77-d2f8-11e9-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'9ee9e018-d2f8-11e9-947d-226cec7cb58a','9ef817f9-d2f8-11e9-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'9ee9e018-d2f8-11e9-947d-226cec7cb58a','9ef98b11-d2f8-11e9-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'9ee9e018-d2f8-11e9-947d-226cec7cb58a','9efb1498-d2f8-11e9-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'9ee9e018-d2f8-11e9-947d-226cec7cb58a','9efc8085-d2f8-11e9-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'9ee9e018-d2f8-11e9-947d-226cec7cb58a','9efd8d64-d2f8-11e9-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'9ee9e018-d2f8-11e9-947d-226cec7cb58a','9efec958-d2f8-11e9-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'9ee9e018-d2f8-11e9-947d-226cec7cb58a','9f003ab0-d2f8-11e9-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'9ee9e018-d2f8-11e9-947d-226cec7cb58a','9f01d2ce-d2f8-11e9-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'9ee9e018-d2f8-11e9-947d-226cec7cb58a','9f03438b-d2f8-11e9-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'9ee9e018-d2f8-11e9-947d-226cec7cb58a','9f04b15e-d2f8-11e9-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'9ee9e018-d2f8-11e9-947d-226cec7cb58a','9f061859-d2f8-11e9-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'9ee9e018-d2f8-11e9-947d-226cec7cb58a','9f0734ec-d2f8-11e9-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'9ee9e018-d2f8-11e9-947d-226cec7cb58a','9f085904-d2f8-11e9-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'9ee9e018-d2f8-11e9-947d-226cec7cb58a','9f0a1ebf-d2f8-11e9-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'ab8690aa-d2f8-11e9-947d-226cec7cb58a','ab8a7a6d-d2f8-11e9-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'ab8690aa-d2f8-11e9-947d-226cec7cb58a','ab8bbe5f-d2f8-11e9-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'b50b7cda-6d82-11ec-9377-226cec7cb58a','b5126a58-6d82-11ec-9377-226cec7cb58a','2022-02-01 17:09:40'),(1,'b50b7cda-6d82-11ec-9377-226cec7cb58a','b517441f-6d82-11ec-9377-226cec7cb58a','2022-02-01 17:09:40'),(1,'b50b7cda-6d82-11ec-9377-226cec7cb58a','b51ad64d-6d82-11ec-9377-226cec7cb58a','2022-02-01 17:09:40'),(1,'c7f461ee-d2f9-11e9-947d-226cec7cb58a','c7f8f656-d2f9-11e9-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'c7f461ee-d2f9-11e9-947d-226cec7cb58a','c7fa52fb-d2f9-11e9-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'c7f461ee-d2f9-11e9-947d-226cec7cb58a','c7fb7a13-d2f9-11e9-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'c7f461ee-d2f9-11e9-947d-226cec7cb58a','c7fcad60-d2f9-11e9-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'c7f461ee-d2f9-11e9-947d-226cec7cb58a','c7fddf4d-d2f9-11e9-947d-226cec7cb58a','2022-02-01 17:09:39'),(1,'f1cb2f35-6d80-11ec-9377-226cec7cb58a','f1d25c24-6d80-11ec-9377-226cec7cb58a','2022-02-01 17:09:40'),(1,'f1cb2f35-6d80-11ec-9377-226cec7cb58a','f1d61263-6d80-11ec-9377-226cec7cb58a','2022-02-01 17:09:40'),(1,'f1cb2f35-6d80-11ec-9377-226cec7cb58a','f1db099c-6d80-11ec-9377-226cec7cb58a','2022-02-01 17:09:40'),(1,'f1cb2f35-6d80-11ec-9377-226cec7cb58a','f1e16f6a-6d80-11ec-9377-226cec7cb58a','2022-02-01 17:09:40'),(1,'f1cb2f35-6d80-11ec-9377-226cec7cb58a','f1e67a14-6d80-11ec-9377-226cec7cb58a','2022-02-01 17:09:40'),(1,'f1cb2f35-6d80-11ec-9377-226cec7cb58a','f1ea2916-6d80-11ec-9377-226cec7cb58a','2022-02-01 17:09:40');
/*!40000 ALTER TABLE `ReceivedAttachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ReceivedMessage`
--

DROP TABLE IF EXISTS `ReceivedMessage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ReceivedMessage` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `created` datetime DEFAULT NULL,
  `messageTransmitted` tinyint(1) NOT NULL DEFAULT '0',
  `messageSubject` varchar(45) NOT NULL,
  `body` text,
  `fromID` mediumint unsigned NOT NULL,
  `originMessageID` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `discussionID` char(36) NOT NULL,
  `readStatus` enum('Read','Unread') DEFAULT 'Unread',
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_ReceivedMessage_Discussion` (`discussionID`,`ownerID`),
  CONSTRAINT `fk_ReceivedMessage_Discussion` FOREIGN KEY (`discussionID`, `ownerID`) REFERENCES `Discussion` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ReceivedMessage`
--

LOCK TABLES `ReceivedMessage` WRITE;
/*!40000 ALTER TABLE `ReceivedMessage` DISABLE KEYS */;
INSERT INTO `ReceivedMessage` VALUES (1,'0cbc6e5d-6c83-11eb-9029-226cec7cb58a','2021-02-11 17:06:06',1,'#','Commande n° 25.1.1.5.3',2,NULL,NULL,'2021-02-14 12:23:06','2021-02-14 11:23:06','2021-02-11 17:06:06','3bb3ca53-cf49-4698-9658-df729e5c5f9e','Read'),(1,'231a29a3-52f5-11ea-947d-226cec7cb58a','2020-02-19 09:52:27',1,'#','Commande n° 1.58.2.5',289,NULL,NULL,'2020-10-20 09:34:11','2020-10-20 07:34:11','2020-02-19 09:52:27','c694559e-df5a-4c0e-b44a-30814d8c3663','Read'),(1,'42c5bf59-200c-11ea-947d-226cec7cb58a','2019-12-16 14:59:31',1,'#','mERCI',2,NULL,NULL,'2019-12-19 14:24:07','2019-12-19 13:24:07','2019-12-16 14:59:31','3bb3ca53-cf49-4698-9658-df729e5c5f9e','Read'),(1,'44f69a53-7745-11eb-9452-226cec7cb58a','2021-02-25 09:41:25',1,'#','Commande n° 14.2.1.2',2,NULL,NULL,'2021-03-09 20:36:18','2021-03-09 19:36:18','2021-02-25 09:41:25','3bb3ca53-cf49-4698-9658-df729e5c5f9e','Read'),(1,'4e26f607-52f4-11ea-947d-226cec7cb58a','2020-02-19 09:46:30',1,'#','Commande n° 1.58.2.3',289,NULL,NULL,'2020-10-20 09:34:11','2020-10-20 07:34:11','2020-02-19 09:46:30','c694559e-df5a-4c0e-b44a-30814d8c3663','Read'),(1,'5f2cf2cc-d2f9-11e9-947d-226cec7cb58a','2019-09-09 14:00:19',1,'#','#',3,NULL,NULL,'2019-09-09 14:02:11','2019-09-09 12:02:11','2019-09-09 14:00:19','27bfc45b-1b14-4914-a7ca-cc01be7e4836','Read'),(1,'8a6030c2-5333-11ea-947d-226cec7cb58a','2020-02-19 17:19:11',1,'6d564d05-157e-41e4-91ce-abf10b350750','est ce que tout est ok ?',289,NULL,NULL,'2020-10-20 09:34:11','2020-10-20 07:34:11','2020-02-19 17:19:11','c694559e-df5a-4c0e-b44a-30814d8c3663','Read'),(1,'9678b0bc-52f5-11ea-947d-226cec7cb58a','2020-02-19 09:55:41',1,'#','Commande n° 1.58.2.6',289,NULL,NULL,'2020-10-20 09:34:11','2020-10-20 07:34:11','2020-02-19 09:55:41','c694559e-df5a-4c0e-b44a-30814d8c3663','Read'),(1,'9c486357-0f6d-11ea-947d-226cec7cb58a','2019-11-25 11:23:31',1,'#','order n° 1.2.1.1',2,NULL,NULL,'2019-11-28 19:16:58','2019-11-28 18:16:58','2019-11-25 11:23:31','3bb3ca53-cf49-4698-9658-df729e5c5f9e','Read'),(1,'9ee9e018-d2f8-11e9-947d-226cec7cb58a','2019-09-09 13:54:55',1,'#','order n° 5.1.1.1',3,NULL,NULL,'2019-09-09 14:02:11','2019-09-09 12:02:11','2019-09-09 13:54:55','27bfc45b-1b14-4914-a7ca-cc01be7e4836','Read'),(1,'a61f605a-6d7f-11ec-9377-226cec7cb58a','2022-01-04 17:59:15',1,'#','yeah\n',2,NULL,NULL,'2022-01-04 18:00:01','2022-01-04 17:00:01','2022-01-04 17:59:15','3bb3ca53-cf49-4698-9658-df729e5c5f9e','Read'),(1,'ab8690aa-d2f8-11e9-947d-226cec7cb58a','2019-09-09 13:55:17',1,'#','order n° 5.1.1.2',3,NULL,NULL,'2019-09-09 14:02:11','2019-09-09 12:02:11','2019-09-09 13:55:17','27bfc45b-1b14-4914-a7ca-cc01be7e4836','Read'),(1,'b50b7cda-6d82-11ec-9377-226cec7cb58a','2022-01-04 18:21:08',1,'#','Commande n° 20.1.1.2.1',2,NULL,NULL,'2022-01-04 18:22:05','2022-01-04 17:22:05','2022-01-04 18:21:08','3bb3ca53-cf49-4698-9658-df729e5c5f9e','Read'),(1,'c7f461ee-d2f9-11e9-947d-226cec7cb58a','2019-09-09 14:03:14',1,'#','order n° 5.1.1.3',3,NULL,NULL,'2019-09-09 14:10:11','2019-09-09 12:10:11','2019-09-09 14:03:14','27bfc45b-1b14-4914-a7ca-cc01be7e4836','Read'),(1,'f1cb2f35-6d80-11ec-9377-226cec7cb58a','2022-01-04 18:08:31',1,'#','bien reçu, + test envoi de prod vers pc schein fichiers',2,NULL,NULL,'2022-01-04 18:09:43','2022-01-04 17:09:43','2022-01-04 18:08:31','3bb3ca53-cf49-4698-9658-df729e5c5f9e','Read');
/*!40000 ALTER TABLE `ReceivedMessage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Scan`
--

DROP TABLE IF EXISTS `Scan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Scan` (
  `ownerID` mediumint unsigned NOT NULL DEFAULT '0',
  `id` char(36) NOT NULL,
  `scanType` enum('MAXILLAIRE','MANDIBULE','MORDU_ANTERIEUR','MORDU_POSTERIEUR_GAUCHE','MORDU_POSTERIEUR_DROIT') DEFAULT 'MAXILLAIRE',
  `comments` mediumtext,
  `cameraX` decimal(10,0) DEFAULT NULL,
  `cameraY` decimal(10,0) DEFAULT NULL,
  `cameraZ` decimal(10,0) DEFAULT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `validated` tinyint(1) NOT NULL DEFAULT '0',
  `status` enum('in_progress','none') NOT NULL DEFAULT 'in_progress',
  `dateCreated` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `sessionID` char(36) DEFAULT NULL,
  `displayID` mediumint unsigned DEFAULT NULL,
  `globalDisplayID` mediumint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Scan_Work` (`ownerID`),
  KEY `fk_Scan_Session` (`sessionID`,`ownerID`),
  CONSTRAINT `fk_Scan_Session` FOREIGN KEY (`sessionID`, `ownerID`) REFERENCES `Session` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Scan`
--

LOCK TABLES `Scan` WRITE;
/*!40000 ALTER TABLE `Scan` DISABLE KEYS */;
/*!40000 ALTER TABLE `Scan` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `Scan_AFTER_UPDATE` AFTER UPDATE ON `Scan` FOR EACH ROW BEGIN
    IF NEW.deletedAt IS NOT NULL THEN
      UPDATE Occlusion SET topScanID = NULL
	  WHERE topScanID = new.id;

	  UPDATE Occlusion SET bottomScanID = NULL
	  WHERE bottomScanID = new.id;

	  UPDATE Occlusion SET leftBiteScanID = NULL
	  WHERE leftBiteScanID = new.id;

	  UPDATE Occlusion SET rightBiteScanID = NULL
	  WHERE rightBiteScanID = new.id;

	  UPDATE Occlusion SET anteriorBiteScanID = NULL
	  WHERE anteriorBiteScanID = new.id;
    END IF;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `Scan_BEFORE_DELETE` BEFORE DELETE ON `Scan` FOR EACH ROW BEGIN
  UPDATE Occlusion SET topScanID = NULL
  WHERE topScanID = OLD.id;

  UPDATE Occlusion SET bottomScanID = NULL
  WHERE bottomScanID = OLD.id;

  UPDATE Occlusion SET leftBiteScanID = NULL
  WHERE leftBiteScanID = OLD.id;

  UPDATE Occlusion SET rightBiteScanID = NULL
  WHERE rightBiteScanID = OLD.id;

  UPDATE Occlusion SET anteriorBiteScanID = NULL
  WHERE anteriorBiteScanID = OLD.id;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `ScanFile`
--

DROP TABLE IF EXISTS `ScanFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ScanFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `fileID` char(36) NOT NULL,
  `scanID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`fileID`,`scanID`,`ownerID`),
  KEY `fk_ScanFile_Scan` (`scanID`,`ownerID`),
  KEY `fk_ScanFile_CondorFile` (`fileID`,`ownerID`),
  CONSTRAINT `fk_ScanFile_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_ScanFile_Scan` FOREIGN KEY (`scanID`, `ownerID`) REFERENCES `Scan` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ScanFile`
--

LOCK TABLES `ScanFile` WRITE;
/*!40000 ALTER TABLE `ScanFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `ScanFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SentAttachment`
--

DROP TABLE IF EXISTS `SentAttachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SentAttachment` (
  `ownerID` mediumint unsigned NOT NULL DEFAULT '0',
  `sentMessageID` char(36) NOT NULL,
  `fileID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`sentMessageID`,`fileID`),
  KEY `fk_SentAttachment_SentMessage` (`sentMessageID`,`ownerID`),
  KEY `fk_SentAttachment_CondorFile` (`fileID`,`ownerID`),
  CONSTRAINT `fk_SentAttachment_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_SentAttachment_SentMessage` FOREIGN KEY (`sentMessageID`, `ownerID`) REFERENCES `SentMessage` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SentAttachment`
--

LOCK TABLES `SentAttachment` WRITE;
/*!40000 ALTER TABLE `SentAttachment` DISABLE KEYS */;
INSERT INTO `SentAttachment` VALUES (1,'58b70136-5c0d-49d4-a13f-f5d29dbc7117','0ed82613-5a79-4604-913a-a3db744d4a86','2022-02-01 17:09:40'),(1,'58b70136-5c0d-49d4-a13f-f5d29dbc7117','6cf1bbb8-81f9-4bf1-9194-221274bd1678','2022-02-01 17:09:40'),(1,'58b70136-5c0d-49d4-a13f-f5d29dbc7117','89135902-4496-4732-8b78-1b69c93e072f','2022-02-01 17:09:40'),(1,'58b70136-5c0d-49d4-a13f-f5d29dbc7117','9e661861-d15d-41fa-b8d5-fd4fa1216cf3','2022-02-01 17:09:40'),(1,'58b70136-5c0d-49d4-a13f-f5d29dbc7117','d7683e95-c742-4f93-9466-8b626d306032','2022-02-01 17:09:40'),(1,'5a692170-da64-4c2b-a924-c5467e6ae357','1775923a-9c97-4da7-98bd-bbb25af16874','2022-02-01 17:09:39'),(1,'5a692170-da64-4c2b-a924-c5467e6ae357','2b69902d-7db5-49bc-b867-d07508b7b4f5','2022-02-01 17:09:39'),(1,'5a692170-da64-4c2b-a924-c5467e6ae357','4901ed4a-c329-45c0-9640-d3c8bebb7194','2022-02-01 17:09:39'),(1,'5a692170-da64-4c2b-a924-c5467e6ae357','511f9d67-1fee-428e-b194-b2225996f40d','2022-02-01 17:09:39'),(1,'5a692170-da64-4c2b-a924-c5467e6ae357','524a3a44-a97d-4d0e-857f-64877f93125b','2022-02-01 17:09:39'),(1,'5a692170-da64-4c2b-a924-c5467e6ae357','7b979677-9030-47ab-bed9-fc2f33e5bc22','2022-02-01 17:09:39'),(1,'5a692170-da64-4c2b-a924-c5467e6ae357','a13f6a75-c3e1-40b7-886c-443a5559b3c4','2022-02-01 17:09:39'),(1,'5a692170-da64-4c2b-a924-c5467e6ae357','a5632e02-7160-4bf9-be22-52212d381e60','2022-02-01 17:09:39'),(1,'5a692170-da64-4c2b-a924-c5467e6ae357','abc5f451-4a84-4b1a-a638-c3301e985061','2022-02-01 17:09:39'),(1,'5a692170-da64-4c2b-a924-c5467e6ae357','cc632090-c3fb-4514-b2b4-98f3ea617ff8','2022-02-01 17:09:40'),(1,'5a692170-da64-4c2b-a924-c5467e6ae357','f57842f1-47bd-48c9-acd5-44086b66051b','2022-02-01 17:09:40'),(1,'852bcfe2-36dd-41d4-beae-f3dce91585d3','1775923a-9c97-4da7-98bd-bbb25af16874','2022-02-01 17:09:40'),(1,'852bcfe2-36dd-41d4-beae-f3dce91585d3','2b69902d-7db5-49bc-b867-d07508b7b4f5','2022-02-01 17:09:40'),(1,'852bcfe2-36dd-41d4-beae-f3dce91585d3','4901ed4a-c329-45c0-9640-d3c8bebb7194','2022-02-01 17:09:40'),(1,'852bcfe2-36dd-41d4-beae-f3dce91585d3','511f9d67-1fee-428e-b194-b2225996f40d','2022-02-01 17:09:40'),(1,'852bcfe2-36dd-41d4-beae-f3dce91585d3','524a3a44-a97d-4d0e-857f-64877f93125b','2022-02-01 17:09:40'),(1,'852bcfe2-36dd-41d4-beae-f3dce91585d3','5c634110-decf-407a-b0d8-202b054a0c53','2022-02-01 17:09:40'),(1,'852bcfe2-36dd-41d4-beae-f3dce91585d3','7b979677-9030-47ab-bed9-fc2f33e5bc22','2022-02-01 17:09:40'),(1,'852bcfe2-36dd-41d4-beae-f3dce91585d3','a13f6a75-c3e1-40b7-886c-443a5559b3c4','2022-02-01 17:09:40'),(1,'852bcfe2-36dd-41d4-beae-f3dce91585d3','a5632e02-7160-4bf9-be22-52212d381e60','2022-02-01 17:09:40'),(1,'852bcfe2-36dd-41d4-beae-f3dce91585d3','abc5f451-4a84-4b1a-a638-c3301e985061','2022-02-01 17:09:40'),(1,'852bcfe2-36dd-41d4-beae-f3dce91585d3','cc632090-c3fb-4514-b2b4-98f3ea617ff8','2022-02-01 17:09:40'),(1,'852bcfe2-36dd-41d4-beae-f3dce91585d3','f57842f1-47bd-48c9-acd5-44086b66051b','2022-02-01 17:09:40');
/*!40000 ALTER TABLE `SentAttachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SentMessage`
--

DROP TABLE IF EXISTS `SentMessage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SentMessage` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `created` datetime DEFAULT NULL,
  `subject` varchar(45) NOT NULL,
  `body` text,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `discussionID` char(36) NOT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_SentMessage_Discussion` (`discussionID`,`ownerID`),
  CONSTRAINT `fk_SentMessage_Discussion` FOREIGN KEY (`discussionID`, `ownerID`) REFERENCES `Discussion` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SentMessage`
--

LOCK TABLES `SentMessage` WRITE;
/*!40000 ALTER TABLE `SentMessage` DISABLE KEYS */;
INSERT INTO `SentMessage` VALUES (1,'58b70136-5c0d-49d4-a13f-f5d29dbc7117','2022-01-04 18:17:18','#','Commande n° 9.2.1.1',NULL,'2022-01-04 18:17:19','2022-01-04 17:17:19','2022-01-04 18:17:18','3bb3ca53-cf49-4698-9658-df729e5c5f9e'),(1,'5a692170-da64-4c2b-a924-c5467e6ae357','2022-01-04 18:07:19','#','test envoi fichier via discussions sans commande',NULL,'2022-01-04 18:07:21','2022-01-04 17:07:21','2022-01-04 18:07:19','3bb3ca53-cf49-4698-9658-df729e5c5f9e'),(1,'852bcfe2-36dd-41d4-beae-f3dce91585d3','2022-01-04 18:12:28','#','Commande n° 9.1.1.1',NULL,'2022-01-04 18:12:35','2022-01-04 17:12:35','2022-01-04 18:12:28','3bb3ca53-cf49-4698-9658-df729e5c5f9e'),(1,'d8fcb11a-d876-4b81-96ce-a11910f38ea9','2022-01-04 17:47:48','#','test\n',NULL,'2022-01-04 17:57:39','2022-01-04 16:57:39','2022-01-04 17:47:48','3bb3ca53-cf49-4698-9658-df729e5c5f9e'),(1,'e88d045e-d649-4191-8f79-9db9ae16fbe8','2022-01-04 17:59:08','#','cool',NULL,'2022-01-04 17:59:09','2022-01-04 16:59:09','2022-01-04 17:59:08','3bb3ca53-cf49-4698-9658-df729e5c5f9e');
/*!40000 ALTER TABLE `SentMessage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SentOrderNotification`
--

DROP TABLE IF EXISTS `SentOrderNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SentOrderNotification` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `orderID` char(36) DEFAULT NULL,
  `recipientID` char(36) DEFAULT NULL,
  `rescueData` text,
  `deliveryDate` datetime DEFAULT NULL,
  `event` enum('edited','validated','cancelled') NOT NULL DEFAULT 'edited',
  `unread` tinyint(1) NOT NULL DEFAULT '1',
  `createdAt` datetime NOT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_SentOrderNotification_Professional` (`ownerID`),
  KEY `fk_SentOrderNotification_Contact` (`recipientID`,`ownerID`),
  KEY `fk_SentOrderNotification_ProstheticOrder` (`orderID`,`ownerID`),
  CONSTRAINT `fk_SentOrderNotification_Contact` FOREIGN KEY (`recipientID`, `ownerID`) REFERENCES `Contact` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_SentOrderNotification_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_SentOrderNotification_ProstheticOrder` FOREIGN KEY (`orderID`, `ownerID`) REFERENCES `ProstheticOrder` (`id`, `ownerID`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SentOrderNotification`
--

LOCK TABLES `SentOrderNotification` WRITE;
/*!40000 ALTER TABLE `SentOrderNotification` DISABLE KEYS */;
/*!40000 ALTER TABLE `SentOrderNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Session`
--

DROP TABLE IF EXISTS `Session`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Session` (
  `ownerID` mediumint unsigned NOT NULL DEFAULT '0',
  `id` char(36) NOT NULL,
  `comments` mediumtext,
  `actID` char(36) NOT NULL,
  `globalDisplayID` mediumint unsigned DEFAULT NULL,
  `displayID` mediumint unsigned DEFAULT NULL,
  `mandibuleOcclusionPlyID` char(36) DEFAULT NULL,
  `maxillaireOcclusionPlyID` char(36) DEFAULT NULL,
  `matrixTransformationMandibuleID` char(36) DEFAULT NULL,
  `matrixTransformationMaxillaireID` char(36) DEFAULT NULL,
  `snapshotID` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `createdAt` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Occlusion_Work` (`actID`,`ownerID`),
  KEY `fk_Session_CondorFile_mandibulePly` (`mandibuleOcclusionPlyID`,`ownerID`),
  KEY `fk_Session_CondorFile_matrixTransformationMandibule` (`matrixTransformationMandibuleID`,`ownerID`),
  KEY `fk_Session_CondorFile_maxillairePly` (`maxillaireOcclusionPlyID`,`ownerID`),
  KEY `fk_Session_CondorFile_matrixTransformationMaxillaire` (`matrixTransformationMaxillaireID`,`ownerID`),
  KEY `fk_Session_CondorFile_maxillairePointContact` (`ownerID`),
  KEY `fk_Session_CondorFile_snapshot` (`snapshotID`,`ownerID`),
  CONSTRAINT `fk_Session_Act` FOREIGN KEY (`actID`, `ownerID`) REFERENCES `Act` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Session_CondorFile_mandibulePly` FOREIGN KEY (`mandibuleOcclusionPlyID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Session_CondorFile_matrixTransformationMandibule` FOREIGN KEY (`matrixTransformationMandibuleID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Session_CondorFile_matrixTransformationMaxillaire` FOREIGN KEY (`matrixTransformationMaxillaireID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Session_CondorFile_maxillairePly` FOREIGN KEY (`maxillaireOcclusionPlyID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Session_CondorFile_snapshot` FOREIGN KEY (`snapshotID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Session`
--

LOCK TABLES `Session` WRITE;
/*!40000 ALTER TABLE `Session` DISABLE KEYS */;
/*!40000 ALTER TABLE `Session` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SharedOffices`
--

DROP TABLE IF EXISTS `SharedOffices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SharedOffices` (
  `ownerID` mediumint unsigned NOT NULL,
  `office1ID` char(36) NOT NULL,
  `office2ID` char(36) NOT NULL,
  `sharedDataType` enum('ALL','CONTACTS') NOT NULL DEFAULT 'CONTACTS',
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  PRIMARY KEY (`office1ID`,`office2ID`,`ownerID`),
  KEY `fk_SharedOffices_Office_1` (`office1ID`,`ownerID`),
  KEY `fk_SharedOffices_Office_2` (`office2ID`,`ownerID`),
  CONSTRAINT `fk_SharedOffices_Office_1` FOREIGN KEY (`office1ID`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_SharedOffices_Office_2` FOREIGN KEY (`office2ID`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SharedOffices`
--

LOCK TABLES `SharedOffices` WRITE;
/*!40000 ALTER TABLE `SharedOffices` DISABLE KEYS */;
/*!40000 ALTER TABLE `SharedOffices` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `SharedOffices_BEFORE_INSERT` BEFORE INSERT ON `SharedOffices` FOR EACH ROW BEGIN
    IF EXISTS (
		SELECT 1 FROM SharedOffices WHERE
		(office1ID=NEW.office2ID AND office2ID=NEW.office1ID)
		OR
		(office1ID=NEW.office1ID AND office2ID=NEW.office2ID)
	) THEN
        SIGNAL SQLSTATE '45000' SET MESSAGE_TEXT = 'Try to insert an existing pair of keys';
    END IF;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `SmilersOrder`
--

DROP TABLE IF EXISTS `SmilersOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SmilersOrder` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `actID` char(36) NOT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `title` varchar(64) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `status` enum('not_sent','waiting_wow_api','sending_wow_api','sending_smilers_api','sent','cancelled') NOT NULL DEFAULT 'waiting_wow_api',
  `createdAt` datetime NOT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `json` text NOT NULL,
  `metadata` text NOT NULL,
  `tag` varchar(250) DEFAULT NULL,
  `localDisplayID` int unsigned DEFAULT NULL,
  `globalDisplayID` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_SmilersOrder_Act` (`actID`,`ownerID`),
  CONSTRAINT `fk_SmilersOrder_Act` FOREIGN KEY (`actID`, `ownerID`) REFERENCES `Act` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SmilersOrder`
--

LOCK TABLES `SmilersOrder` WRITE;
/*!40000 ALTER TABLE `SmilersOrder` DISABLE KEYS */;
/*!40000 ALTER TABLE `SmilersOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SmilersOrderFile`
--

DROP TABLE IF EXISTS `SmilersOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SmilersOrderFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `orderID` char(36) NOT NULL,
  `fileID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`orderID`,`fileID`),
  KEY `fk_SmilersOrderFile_SmilersOrder` (`orderID`,`ownerID`),
  KEY `fk_SmilersOrderFile_CondorFile` (`fileID`,`ownerID`),
  CONSTRAINT `fk_SmilersOrderFile_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_SmilersOrderFile_SmilersOrder` FOREIGN KEY (`orderID`, `ownerID`) REFERENCES `SmilersOrder` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SmilersOrderFile`
--

LOCK TABLES `SmilersOrderFile` WRITE;
/*!40000 ALTER TABLE `SmilersOrderFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `SmilersOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SyncInfo`
--

DROP TABLE IF EXISTS `SyncInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SyncInfo` (
  `id` mediumint unsigned NOT NULL,
  `ownerID` mediumint unsigned NOT NULL,
  `patientsLastRetrieved` datetime DEFAULT NULL,
  `actsLastRetrieved` datetime DEFAULT NULL,
  `sessionsLastRetrieved` datetime DEFAULT NULL,
  `scansLastRetrieved` datetime DEFAULT NULL,
  `ordersLastRetrieved` datetime DEFAULT NULL,
  `assistantsLastRetrieved` datetime DEFAULT NULL,
  `contactsLastRetrieved` datetime DEFAULT NULL,
  `discussionsLastRetrieved` datetime DEFAULT NULL,
  `messagesLastRetrieved` datetime DEFAULT NULL,
  `notificationsLastRetrieved` datetime DEFAULT NULL,
  `occlusionsLastRetrieved` datetime DEFAULT NULL,
  `circleordersLastRetrieved` datetime DEFAULT NULL,
  `smilersordersLastRetrieved` datetime DEFAULT NULL,
  `prostheticSheetsLastRetrieved` datetime DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `idx_SyncInfo_Professional` (`ownerID`),
  CONSTRAINT `fk_SyncInfo_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SyncInfo`
--

LOCK TABLES `SyncInfo` WRITE;
/*!40000 ALTER TABLE `SyncInfo` DISABLE KEYS */;
INSERT INTO `SyncInfo` VALUES (1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,8,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,11,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,17,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,36,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,48,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,58,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,61,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,80,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,86,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,90,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,117,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,135,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,154,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,163,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,169,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,172,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,176,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,177,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,196,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,211,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,220,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,245,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,254,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,270,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,281,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,289,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,296,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,297,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,300,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,310,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,318,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,321,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,330,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,352,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,375,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,376,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,378,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,415,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,437,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,442,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,448,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,461,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,467,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,472,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,512,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,597,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,650,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,689,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `SyncInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SystemNotification`
--

DROP TABLE IF EXISTS `SystemNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SystemNotification` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `event` enum('no_connection_for_x_days') NOT NULL DEFAULT 'no_connection_for_x_days',
  `unread` tinyint(1) NOT NULL DEFAULT '1',
  `createdAt` datetime NOT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_SystemNotification_Professional` (`ownerID`),
  CONSTRAINT `fk_SystemNotification_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SystemNotification`
--

LOCK TABLES `SystemNotification` WRITE;
/*!40000 ALTER TABLE `SystemNotification` DISABLE KEYS */;
/*!40000 ALTER TABLE `SystemNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Token`
--

DROP TABLE IF EXISTS `Token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Token` (
  `id` char(36) NOT NULL,
  `ownerID` mediumint unsigned NOT NULL,
  `created` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `token` char(200) NOT NULL,
  `credentialsId` char(36) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '',
  `context` varchar(40) DEFAULT NULL,
  `device` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  UNIQUE KEY `un_Token` (`token`),
  KEY `IDX_9EF68E3F818B3C83` (`credentialsId`),
  CONSTRAINT `fk_Token_Credentials` FOREIGN KEY (`credentialsId`) REFERENCES `Credentials` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Token`
--

LOCK TABLES `Token` WRITE;
/*!40000 ALTER TABLE `Token` DISABLE KEYS */;
INSERT INTO `Token` VALUES ('3987d569-b8bf-446f-9d96-64acc663bdf6',1,NULL,'2022-02-28 17:23:40','abdb66bfb7626fb1ca890b234807c5066e0a4b35','00000001-0000-0000-0000-000000000001',NULL,NULL);
/*!40000 ALTER TABLE `Token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ToothInfo`
--

DROP TABLE IF EXISTS `ToothInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ToothInfo` (
  `ownerID` mediumint unsigned NOT NULL,
  `toothNumber` tinyint unsigned NOT NULL,
  `prostheticSheetID` char(36) NOT NULL,
  `toothColor` tinytext,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`toothNumber`,`prostheticSheetID`),
  KEY `idx_ToothInfo_Order` (`ownerID`),
  KEY `fk_ToothInfo_ProstheticSheet` (`prostheticSheetID`),
  CONSTRAINT `fk_ToothInfo_ProstheticSheet` FOREIGN KEY (`prostheticSheetID`) REFERENCES `ProstheticSheet` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ToothInfo`
--

LOCK TABLES `ToothInfo` WRITE;
/*!40000 ALTER TABLE `ToothInfo` DISABLE KEYS */;
/*!40000 ALTER TABLE `ToothInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `__db_version__`
--

DROP TABLE IF EXISTS `__db_version__`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `__db_version__` (
  `id` int NOT NULL AUTO_INCREMENT,
  `version_major` int NOT NULL DEFAULT '0',
  `version_minor` int NOT NULL DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `migration_file` varchar(1024) DEFAULT NULL,
  `commit` varchar(255) DEFAULT NULL,
  `version_core` varchar(255) DEFAULT NULL,
  `version_IHM` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=71 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `__db_version__`
--

LOCK TABLES `__db_version__` WRITE;
/*!40000 ALTER TABLE `__db_version__` DISABLE KEYS */;
INSERT INTO `__db_version__` VALUES (1,1,15,'v1.15','','','1.9.0','2.0.4'),(2,1,18,'v1.18','migration_fileconstraint_local','','1.9.0','2.0.4'),(3,1,19,'v1.19','migration_fileconstraint_local','','1.9.0','2.0.4'),(4,1,20,'v1.20','migration_globalDisplayID_local','','1.9','2.0.4'),(5,1,21,'v1.21','migration_config_show_open_stl_warning_local','','1.9','2.0.4'),(6,1,22,'v1.22','migration_resetcontact_local','','1.9','2.0.4'),(7,1,23,'v1.23','migration_token_context_device_local','','1.9','2.0.4'),(8,1,24,'v1.24','migration_config_lag_and_lost_sound_local','','1.9','2.0.4'),(9,1,25,'v1.25','migration_fix_unset_scan_creator_local','','1.9.0','2.0.4'),(10,1,26,'v1.26','migration_fix_wrong_original_files_local','','1.9.0','2.0.4'),(11,1,27,'v1.27','migration_occlusion_display_id_local','','1.9','2.0.4'),(12,1,28,'v1.28','migration_selfdiscussions_local','','1.9','2.0.4'),(13,1,29,'v1.29','migration_config_show_delete_confirmation_local','','1.9','2.0.4'),(14,1,30,'v1.30','migration_config_email_notifications_local','','1.9','2.0.4'),(15,1,31,'v1.31','migration_config_last_synced_local','','1.9','2.0.4'),(16,1,32,'v1.32','migration_lastmodified_local','','1.9','2.0.4'),(17,1,33,'v1.33','migration_config_add_fields_flip_local','','1.9','2.0.4'),(18,1,34,'v1.34','migration_unread_local','','1.9','2.0.4'),(19,1,35,'v1.35','migration_work_last_accessed_local','','1.9','2.0.4'),(20,1,36,'v1.36','migration_config_show_sync_info_local','','1.9','2.0.4'),(21,1,37,'v1.37','migration_config_clean_deprecated_fields_local','','1.9','2.0.4'),(22,1,38,'v1.38','migration_act_refonte_local','','1.9','2.0.4'),(23,1,39,'v1.39','migration_fix_duplicate_screenshot_path_local','','1.9','2.0.4'),(24,1,40,'v1.40','migration_rework_local','','1.9.0','2.0.4'),(25,1,41,'v1.41','migration_sync_info_local','','1.9.0','1.1-3'),(26,1,42,'v1.42','migration_config_popup_flip','','1.9','2.0.4'),(27,1,43,'v1.43','migration_mark_contacts_invisible_local','','1.9','3.2.1'),(28,1,44,'v1.44','migration_config_show_margin_lines_warning_local','','1.9','2.0.4'),(29,1,45,'v1.45','migration_contact_invitation_local','','1.9','2.3.0'),(30,1,46,'v1.46','migration_received_order_local','','1.9','3.3.0'),(31,1,47,'v1.47','migration_merge_discussions_local','','1.9','3.3.1'),(32,1,48,'v1.48','migration_office_rename_email_local','','1.9','3.3.1'),(33,1,49,'v1.49','migration_contact_cannot_reject_self_local','','1.9','3.3.1'),(34,1,50,'v1.50','migration_discussion_deletedat_not_null_local','','1.9','3.3.1'),(35,1,51,'v1.51','migration_reset_condor_file_trigger_local','','1.9','3.3.1'),(36,1,52,'v1.52','migration_system_notification_local','','1.9','2.3.0'),(37,1,53,'v1.53','migration_add_last_connection_checked_professional_local','','1.9','3.4.0'),(38,1,54,'v1.54','migration_endless_scans_local','','1.9','3.4.0'),(39,1,55,'v1.55','migration_rename_act_session_local','','1.9','3.4.0'),(40,1,56,'v1.56','migration_sessionId_local','','1.9','3.4.0'),(41,1,57,'v1.57','migration_session_created_at_local','','1.9','3.4.0'),(42,1,58,'v1.58','migration_order_display_id_local','','1.9','3.4.0'),(43,1,59,'v1.59','migration_pin_patient_local','','1.9','1.0.0'),(44,1,60,'v1.60','migration_enable_upload_local','','3.4.0','1.0.1'),(45,1,61,'v1.61','migration_remove_occlusion_contact_local','','3.4.1','1.1.0'),(46,1,62,'v1.62','migration_scanid_local','','3.4.1','1.1.0'),(47,1,63,'v1.63','migration_circleorder_local','','3.4.1','1.1.0'),(48,1,64,'v1.64','migration_smilersorder_local','','4.1.0','2.1.0'),(49,1,65,'v1.65','migration_demo_professional','','4.1.0','2.1.0'),(50,1,66,'v1.66','migration_tracking_rectangle','','4.1.0','2.1.1'),(51,1,67,'v1.67','migration_fix_status_circle_smilers','','4.1.0','2.1.1'),(52,1,68,'v1.68','migration_remove_scansID_session_local','','4.2.0','2.1.1'),(53,1,69,'v1.69','migration_externalize_occlusion_local','','4.2.0','2.1.1'),(54,1,70,'v1.70','migration_scan_occlusion_trigger_local','','4.2.0','2.1.1'),(55,1,74,'v1.74','migration_fix_xxxinfo_local','','4.3.0','2.2.3'),(56,1,71,'v1.71','migration_add_date_created_scan_local','','4.2.0','2.1.1'),(57,1,72,'v1.72','migration_scan_status_local','','4.2.0','2.1.1'),(58,1,73,'v1.73','migration_remove_patient_personnal_data_local','','4.2.0','2.1.1'),(59,1,75,'v1.75','migration_add_displayid_occlusion_local','','4.3.0','2.3.3'),(60,1,76,'v1.76','migration_add_table_ProstheticSheet_local','','4.4.0','2.3.4'),(61,1,77,'v1.77','migration_status_smilers_circle_local','','4.2.0','2.4.0'),(62,1,78,'v1.78','migration_condor_local_1.78_patient_theme','','4.4.0','2.4.0'),(63,1,79,'v1.79','migration_condor_local_1.79_fix_order_recipient','','4.5.0','2.4.4'),(64,1,80,'v1.80','migration_condor_local_1.80_fix_order','','4.5.0','2.4.4'),(65,1,81,'v1.81','migration_condor_local_1.81_fix_theme_null','','4.5.0','2.4.4'),(66,1,82,'v1.82','migration_condor_local_1.82_fix_wow_data','','5.0.0','3.0.1'),(67,1,83,'v1.83','migration_condor_local_1.83_remove_ownerid','','5.0.0','3.0.1'),(68,1,84,'v1.84','migration_condor_local_1.84_generate_professional_env_infos','','5.0.0','3.0.1'),(69,1,85,'v1.85','migration_condor_local_1.85_add_updatedat_professional_env_infos','','5.0.0','3.0.1'),(70,1,86,'v1.86','migration_condor_local_1.86_update_token','','5.0.0','3.0.1');
/*!40000 ALTER TABLE `__db_version__` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping routines for database 'condor'
--
/*!50003 DROP FUNCTION IF EXISTS `generateid` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `generateid`(maxchars int) RETURNS char(36) CHARSET utf8mb3
BEGIN

  DECLARE AllChars char(16);
  DECLARE currentStr CHAR(36);
  DECLARE p1 int;
  
  SET AllChars = 'abcdef0123456789'; 
  SET currentStr = '';
  SET p1 = 0;

  charLoop: LOOP
  
    IF p1 < maxchars THEN
	  SET currentStr = CONCAT(currentStr, substring(AllChars, (RAND()*15)+1, 1));
	  SET p1 = p1 + 1;
      
      ITERATE charLoop;
    END IF;
    
    LEAVE charLoop;
    
  END LOOP charLoop;
  
  RETURN currentStr;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `uuid_v4` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `uuid_v4`() RETURNS char(36) CHARSET utf8mb4
    NO SQL
BEGIN
    
    SET @h1 = LPAD(HEX(FLOOR(RAND() * 0xffff)), 4, '0');
    SET @h2 = LPAD(HEX(FLOOR(RAND() * 0xffff)), 4, '0');
    SET @h3 = LPAD(HEX(FLOOR(RAND() * 0xffff)), 4, '0');
    SET @h6 = LPAD(HEX(FLOOR(RAND() * 0xffff)), 4, '0');
    SET @h7 = LPAD(HEX(FLOOR(RAND() * 0xffff)), 4, '0');
    SET @h8 = LPAD(HEX(FLOOR(RAND() * 0xffff)), 4, '0');

    
    SET @h4 = CONCAT('4', LPAD(HEX(FLOOR(RAND() * 0x0fff)), 3, '0'));

    
    SET @h5 = CONCAT(HEX(FLOOR(RAND() * 4 + 8)),
                LPAD(HEX(FLOOR(RAND() * 0x0fff)), 3, '0'));

    
    RETURN LOWER(CONCAT(
        @h1, @h2, '-', @h3, '-', @h4, '-', @h5, '-', @h6, @h7, @h8
    ));
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `drop_fk_if_exists` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `drop_fk_if_exists`(in theTable varchar(128), in theFKName varchar(128) )
BEGIN
 IF((SELECT COUNT(*) AS fk_exists
     FROM information_schema.table_constraints
     WHERE TABLE_SCHEMA = DATABASE() AND table_name = theTable AND constraint_name = theFKName AND constraint_type = 'FOREIGN KEY') > 0)
 THEN
   SET @s = CONCAT('ALTER TABLE ', theTable, ' DROP FOREIGN KEY ' , theFKName);
   PREPARE stmt FROM @s;
   EXECUTE stmt;
 END IF;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `drop_index_if_exists` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `drop_index_if_exists`(in theTable varchar(128), in theIndexName varchar(128) )
BEGIN
 IF((SELECT COUNT(*) AS index_exists
     FROM information_schema.statistics
     WHERE TABLE_SCHEMA = DATABASE() and table_name = theTable AND index_name = theIndexName) > 0)
 THEN
   SET @s = CONCAT('DROP INDEX ' , theIndexName , ' ON ' , theTable);
   PREPARE stmt FROM @s;
   EXECUTE stmt;
 END IF;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `fixOrderFrom176` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `fixOrderFrom176`()
    NO SQL
BEGIN
    SET @script_ok = (SELECT COUNT(*) FROM __db_version__ WHERE version_major = '1' AND version_minor = '76');

	IF (@script_ok = 0) THEN
        SET @count_bad_date = (SELECT COUNT(*) FROM ProstheticOrder WHERE createdAt IS NULL);
        IF (@count_bad_date > 0) THEN
            CALL `script176`();
        ELSE
            SET @count_bad_toothinfo = (SELECT COUNT(*) FROM ToothInfo WHERE prostheticSheetID = '');
            IF (@count_bad_toothinfo > 0) THEN
                DELETE FROM ToothInfo WHERE prostheticSheetID = '';

                ALTER TABLE ToothInfo ADD PRIMARY KEY (ownerID, toothNumber, prostheticSheetID);
                ALTER TABLE ToothInfo DROP COLUMN orderID;

                INSERT INTO `__db_version__`(`version_major`, `version_minor`, `title`, `commit`, `migration_file`, `version_core`, `version_IHM`) VALUES
                    (1, 76, 'v1.76', '', 'migration_condor_local_1.76_add_table_ProstheticSheet_from_180', '4.4.0', '2.3.4');
            END IF;
        END IF;
    END IF;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `FixOrderRecipient` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `FixOrderRecipient`()
    NO SQL
BEGIN
    DECLARE CurOrderOwnerID MEDIUMINT(8) UNSIGNED;
    DECLARE CurOrderUuid CHAR(36);
    DECLARE CurOrderId VARCHAR(255);

    DECLARE NbRecipient INT(8);
    DECLARE DID CHAR(36);
    DECLARE RecipientOwnerId MEDIUMINT(8) UNSIGNED;
    DECLARE RecipientContactId CHAR(36);

    DECLARE exit_loop BOOLEAN DEFAULT FALSE;

    DECLARE CUR CURSOR FOR
        SELECT ownerId, uuid, id
        FROM DebugOrderData
        WHERE id IS NOT NULL;

    DECLARE CONTINUE HANDLER FOR NOT FOUND SET exit_loop = TRUE;

    OPEN CUR;
    read_loop: LOOP
        FETCH CUR INTO CurOrderOwnerID, CurOrderUuid, CurOrderId;

        
        
        IF exit_loop THEN
            CLOSE CUR;
            LEAVE read_loop;
        END IF;

        SET NbRecipient = (SELECT COUNT(*) FROM ProstheticOrderRecipient WHERE orderID = CurOrderUuid);

        IF NbRecipient = 0 THEN
            SET DID = (SELECT discussionID FROM SentMessage WHERE LOCATE(CurOrderId, body) > 0);

            IF DID IS NOT NULL THEN
                SET RecipientOwnerId = (SELECT ownerID FROM Discussion WHERE id = DID AND ownerID != CurOrderOwnerID);

                IF RecipientOwnerId IS NOT NULL THEN
                    SET RecipientContactId = (SELECT id FROM Contact WHERE ownerID = CurOrderOwnerID AND professionalID = RecipientOwnerId);

                    IF RecipientContactId IS NOT NULL THEN
                        INSERT INTO ProstheticOrderRecipient VALUES (CurOrderOwnerID, CurOrderUuid , RecipientContactId, NOW());
                    END IF;
                END IF;
            END IF;
        END IF;
    END LOOP;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `getUsedScansForOcclusion` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `getUsedScansForOcclusion`()
    NO SQL
BLOCK1: BEGIN

  DECLARE CurFileID CHAR(36);
  DECLARE CurFileMetadata TEXT;
  DECLARE CurOwnerID MEDIUMINT(8) UNSIGNED;
  DECLARE CurFileTag TEXT;
  
  DECLARE exit_loop BOOLEAN DEFAULT FALSE;

  DECLARE read_sessionid TEXT;

  DECLARE CUR CURSOR FOR
          SELECT CondorFile.id, CondorFile.metadata, CondorFile.ownerID, CondorFile.tag
          FROM CondorFile WHERE tag LIKE '%_OCC_%' AND metadata LIKE '%"referenceScanID":"%' AND deletedAt IS NULL;
          
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET exit_loop = TRUE;

  OPEN CUR;
  read_loop: LOOP

	  FETCH CUR INTO CurFileID, CurFileMetadata, CurOwnerID, CurFileTag;

		IF exit_loop THEN
			CLOSE CUR;
			LEAVE read_loop;
		END IF;
		
    
		SET @refScanDelimiter = SUBSTRING_INDEX(CurFileMetadata, '"referenceScanID":"', -1); 
		SET @refScanID = SUBSTRING_INDEX(@refScanDelimiter, ':', 1);
        
		SET @actDelemiter = SUBSTRING_INDEX(CurFileTag, '_ACT_', -1); 
        SET @curActID = SUBSTRING_INDEX(@actDelemiter, '_', 1);
		SET @sessionDelemiter = SUBSTRING_INDEX(CurFileTag, '_SESS_', -1); 
        SET @curSessionID = SUBSTRING_INDEX(@sessionDelemiter, '_', 1);
        
        
        
		IF @curActID is NOT NULL AND @curSessionID is NOT NULL THEN
        
			SET @actOwnerID = (SELECT ownerID FROM Act WHERE id = @curActID);
			SET @sessionOwnerID = (SELECT ownerID FROM Session WHERE id = @curSessionID);
            
            
            IF @actOwnerID = CurOwnerID AND @sessionOwnerID = CurOwnerID THEN
            
				SET @scanNo = SUBSTRING_INDEX(@refScanID,'.',-1);
				SET @scanType = '';
				SET @findTopScan = CurFileTag LIKE '%_TOPLY_%';
				SET @findBottomScan = CurFileTag LIKE '%_BOPLY_%';
				
				IF @findTopScan > 0 THEN
					SET @scanType = 'MAXILLAIRE';
				ELSEIF @findBottomScan > 0 THEN
					SET @scanType = 'MANDIBULE';
				ELSE 
					ITERATE read_loop;
				END IF;
                 
                SET @scanID = (SELECT id FROM Scan WHERE ownerID = CurOwnerID AND sessionID = @curSessionID AND displayID = @scanNo AND scanType = @scanType AND deletedAt IS NULL );
				SET @occlusionID =  SUBSTRING_INDEX(SUBSTRING_INDEX(CurFileTag, '_OCC_', -1), '_', 1); 
				
				IF @occlusionID IS NULL THEN 
					ITERATE read_loop;
				END IF;
	
				IF @findTopScan > 0 THEN
					UPDATE Occlusion SET topScanID = @scanID WHERE id = @occlusionID;
				ELSEIF @findBottomScan > 0 THEN
					UPDATE Occlusion SET bottomScanID = @scanID WHERE id = @occlusionID;
				END IF; 
                
            END IF;
		
        END IF;
         
  END LOOP;

END BLOCK1 ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `migrateLifiOcclusionFiles` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `migrateLifiOcclusionFiles`()
    NO SQL
BEGIN

  DECLARE CurOwnerID MEDIUMINT(8) UNSIGNED;
  DECLARE CurFilePath TEXT;
  DECLARE CurFileID CHAR(36);
  DECLARE CurFileTag VARCHAR(250);
  DECLARE CurFileType VARCHAR(250);
  DECLARE CurFileMetadata TEXT;
  
  DECLARE exit_loop BOOLEAN DEFAULT FALSE;
  
  DECLARE read_sessionid TEXT;

  
  DECLARE CUR CURSOR FOR
          SELECT CondorFile.ownerID, CondorFile.id, CondorFile.tag, CondorFile.path, CondorFile.type, CondorFile.metadata
          FROM CondorFile
	  WHERE type LIKE '%LIFI%' AND metadata LIKE '%"isOcclusionMarginLine":true%' AND id NOT IN (SELECT fileID FROM ReceivedAttachment);

  DECLARE CONTINUE HANDLER FOR NOT FOUND SET exit_loop = TRUE;
  
  OPEN CUR;
  read_loop: LOOP

  FETCH CUR INTO CurOwnerID, CurFileID, CurFileTag, CurFilePath, CurFileType, CurFileMetadata;

	
	
	IF exit_loop THEN
		CLOSE CUR;
		LEAVE read_loop;
	END IF;
		
	SET @sessionDelimiter = SUBSTRING_INDEX(CurFileTag, '_SESS_', -1);
        SET @curSessionID = SUBSTRING_INDEX(@sessionDelimiter, '_', 1);
        
	SELECT ownerID, id INTO @occlusionOwnerID, @occlusionID FROM Occlusion WHERE sessionID = @curSessionID;
      
	
        
	IF @occlusionID IS NOT NULL AND @occlusionOwnerID = CurOwnerID THEN

		SET @pleft = SUBSTRING_INDEX(CurFileTag, @curSessionID, 1);
		SET @newTag = CONCAT(@pleft, @curSessionID, '_OCC_', @occlusionID, '_', CurFileType, 'O_', CurFileType, '_');
            
		SET @filename = SUBSTRING_INDEX(CurFilePath, '/', -1);
		SET @scanPath = SUBSTRING_INDEX(CurFilePath, '/', -2);
		SET @sessionPath = SUBSTRING_INDEX(CurFilePath, @scanPath, 1);
		SET @newFilePath = CONCAT(@sessionPath, 'computedocclusion_', @occlusionID, '/', @filename);

		UPDATE CondorFile SET tag = @newTag, path = @newFilePath WHERE id = CurFileID;
             
		
		INSERT INTO OcclusionFile(ownerID, fileID, occlusionID, lastUpdated)
		VALUES (CurOwnerID, CurFileID, @occlusionID, CURRENT_TIMESTAMP);

		
		SET @scanID = (SELECT scanID FROM ScanFile WHERE fileID = CurFileID);

		IF @scanID IS NOT NULL THEN
			SET @scanType = (SELECT scanType FROM Scan WHERE id = @scanID);

			IF @scanType is not NULL THEN
				SET @currentMetadata = SUBSTRING_INDEX(CurFileMetadata, '}', 1);
				SET @lifiScanType = CONCAT('"lifi_scan_type":"', @scanType, '"');
				SET @newMetadata = CONCAT(@currentMetadata, ',', @lifiScanType, '}');

				UPDATE CondorFile SET metadata = @newMetadata WHERE id = CurFileID;
			END IF;

		END IF;

            
            DELETE FROM ScanFile WHERE fileID = CurFileID;

	END IF;

  END LOOP;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `migrateOcclusions` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `migrateOcclusions`()
    NO SQL
BEGIN
  DECLARE CurOwnerID MEDIUMINT(8) UNSIGNED;
  DECLARE CurSessionID CHAR(36);
  DECLARE CurMandibuleOcclusionPlyID CHAR(36);
  DECLARE CurMaxillaireOcclusionPlyID CHAR(36);
  DECLARE CurMatrixTransformationMandibuleID CHAR(36);
  DECLARE CurMatrixTransformationMaxillaireID CHAR(36);
  DECLARE CurSnapshotID CHAR(36);
  
  
  DECLARE TopScanID CHAR(36);
  DECLARE BottomScanID CHAR(36);
  DECLARE CheckIntegrity BOOLEAN DEFAULT FALSE;

  DECLARE NewOcclusionID CHAR(36);
  DECLARE exit_loop BOOLEAN DEFAULT FALSE;

  
  DECLARE CUR CURSOR FOR
          SELECT Session.ownerID, Session.id, Session.mandibuleOcclusionPlyID, Session.maxillaireOcclusionPlyID,
					Session.matrixTransformationMandibuleID, Session.matrixTransformationMaxillaireID, Session.snapshotID
          FROM Session WHERE deletedAt IS NULL AND mandibuleOcclusionPlyID IS NOT NULL AND maxillaireOcclusionPlyID IS NOT NULL AND
					matrixTransformationMandibuleID IS NOT NULL AND matrixTransformationMaxillaireID IS NOT NULL AND snapshotID IS NOT NULL;
          
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET exit_loop = TRUE;

  OPEN CUR;
  read_loop: LOOP

  FETCH CUR INTO CurOwnerID, CurSessionID, CurMandibuleOcclusionPlyID, CurMaxillaireOcclusionPlyID,
					CurMatrixTransformationMandibuleID, CurMatrixTransformationMaxillaireID, CurSnapshotID;

    
    
    IF exit_loop THEN
	CLOSE CUR;
	LEAVE read_loop;
    END IF;

	SET TopScanID = (SELECT scanID from ScanFile WHERE fileID = CurMaxillaireOcclusionPlyID);
    SET BottomScanID = (SELECT scanID from ScanFile WHERE fileID = CurMandibuleOcclusionPlyID);

    
	
	

	
	
    
    SET NewOcclusionID = concat(left(CurSessionID, length(CurSessionID) - 9), 'migraoccl');
	
	INSERT INTO Occlusion(ownerID, id, sessionID, occlusionType, deletedAt, createdAt, lastSynced, lastModified, lastUpdated, topScanID, bottomScanID, 
							anteriorBiteScanID, rightBiteScanID, leftBiteScanID, snapshotID, mandibuleOcclusionPlyID, maxillaireOcclusionPlyID, matrixTransformationMandibuleID, 
							matrixTransformationMaxillaireID)
							VALUES (CurOwnerID, NewOcclusionID, CurSessionID, NULL, NULL, CURRENT_TIMESTAMP, NULL, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP, TopScanID, BottomScanID,
							NULL, NULL, NULL, CurSnapshotID, CurMandibuleOcclusionPlyID, CurMaxillaireOcclusionPlyID, CurMatrixTransformationMandibuleID,
							CurMatrixTransformationMaxillaireID);
	
	
	INSERT INTO OcclusionFile(ownerID, fileID, occlusionID, lastUpdated)
							VALUES (CurOwnerID, CurMandibuleOcclusionPlyID, NewOcclusionID, CURRENT_TIMESTAMP);
	INSERT INTO OcclusionFile(ownerID, fileID, occlusionID, lastUpdated)
							VALUES (CurOwnerID, CurMaxillaireOcclusionPlyID, NewOcclusionID, CURRENT_TIMESTAMP);
	INSERT INTO OcclusionFile(ownerID, fileID, occlusionID, lastUpdated)
							VALUES (CurOwnerID, CurMatrixTransformationMandibuleID, NewOcclusionID, CURRENT_TIMESTAMP);
	INSERT INTO OcclusionFile(ownerID, fileID, occlusionID, lastUpdated)
							VALUES (CurOwnerID, CurMatrixTransformationMaxillaireID, NewOcclusionID, CURRENT_TIMESTAMP);
	INSERT INTO OcclusionFile(ownerID, fileID, occlusionID, lastUpdated)
							VALUES (CurOwnerID, CurSnapshotID, NewOcclusionID, CURRENT_TIMESTAMP);          
    


  END LOOP;
  
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `script176` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `script176`()
    NO SQL
BEGIN
    
    DROP TABLE IF EXISTS `ProstheticSheet`;
    CREATE TABLE `ProstheticSheet` (
        `id` char(36) NOT NULL,
        `ownerID` mediumint(8) unsigned NOT NULL,
        `orderID` char(36) NOT NULL,
        `json` TEXT NOT NULL,
        `pdfFileID` char(36) DEFAULT NULL,
        `dateCreated` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
        `deletedAt` datetime DEFAULT NULL,
        `lastSynced` datetime DEFAULT NULL,
        `lastModified` datetime NOT NULL,
        `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`,`ownerID`),
        CONSTRAINT `fk_ProstheticSheet_ProstheticOrder` FOREIGN KEY (`orderID`) REFERENCES `ProstheticOrder` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
        CONSTRAINT `fk_ProstheticSheet_CondorFile` FOREIGN KEY (`pdfFileID`) REFERENCES `CondorFile` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

    
    UPDATE ProstheticOrder SET createdAt = lastUpdated WHERE createdAt IS NULL;

    
    INSERT INTO ProstheticSheet (id, ownerID, orderID, json, dateCreated, deletedAt, lastSynced, lastModified, lastUpdated)
    SELECT
        PO.id as id,
        PO.ownerID,
        PO.id as orderID,
        CONCAT('{"sheetTitle":"', PO.title, '",', RIGHT(PO.json, LENGTH(PO.json)-1)), 
        PO.createdAt as dateCreated,
        PO.deletedAt,
        PO.lastSynced,
        PO.lastModified,
        PO.lastUpdated
    FROM ProstheticOrder AS PO;

    CREATE TEMPORARY TABLE PDF_ID_TMP
    SELECT POF1.orderID, POF1.fileID, CF1.version, T.maxVersion
    FROM ProstheticOrderFile AS POF1
    INNER JOIN CondorFile AS CF1 ON POF1.fileID = CF1.id
    INNER JOIN (
        SELECT POF2.orderID, MAX(CF2.version) AS maxVersion
        FROM ProstheticOrderFile AS POF2
        INNER JOIN CondorFile AS CF2 ON POF2.fileID = CF2.id
        WHERE CF2.type = 'PDF'
        GROUP BY POF2.orderID
    ) T ON POF1.orderID = T.orderID
    WHERE CF1.type = 'PDF' AND CF1.version = T.maxVersion;

    UPDATE ProstheticSheet AS PS
    INNER JOIN PDF_ID_TMP AS PDF ON PDF.orderID = PS.orderID
    SET PS.pdfFileID = PDF.fileID;

    DROP TEMPORARY TABLE PDF_ID_TMP;

    
    
    

    ALTER TABLE SyncInfo ADD prostheticSheetsLastRetrieved DATETIME NULL AFTER smilersordersLastRetrieved;

    ALTER TABLE ProstheticOrder DROP COLUMN json;

    ALTER TABLE ToothInfo ADD prostheticSheetID char(36) NOT NULL AFTER toothNumber;

    UPDATE ToothInfo AS TI
    INNER JOIN ProstheticSheet AS PS on TI.orderID = PS.orderID
    SET TI.prostheticSheetID = PS.id;

    
    
    

    
    ALTER TABLE ToothInfo DROP FOREIGN KEY fk_ToothInfo_Order;

    
    ALTER TABLE ToothInfo ADD CONSTRAINT `fk_ToothInfo_ProstheticSheet` FOREIGN KEY (`prostheticSheetID`) REFERENCES `ProstheticSheet` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

    ALTER TABLE ToothInfo DROP PRIMARY KEY;
    ALTER TABLE ToothInfo ADD PRIMARY KEY (ownerID, toothNumber, prostheticSheetID);

    ALTER TABLE ToothInfo DROP COLUMN orderID;

    
    
    

    INSERT INTO `__db_version__`(`version_major`, `version_minor`, `title`, `commit`, `migration_file`, `version_core`, `version_IHM`) VALUES
    (1, 76, 'v1.76', '', 'migration_condor_local_1.76_add_table_ProstheticSheet_from_180', '4.4.0', '2.3.4');

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `updateOcclusionsCondorFilesTag` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `updateOcclusionsCondorFilesTag`()
    NO SQL
BEGIN

  DECLARE CurFilePath TEXT;
  DECLARE CurFileID CHAR(36);
  DECLARE CurFileTag VARCHAR(250);
  DECLARE exit_loop BOOLEAN DEFAULT FALSE;
  
  DECLARE read_sessionid TEXT;

  
  DECLARE CUR CURSOR FOR
          SELECT CondorFile.id, CondorFile.tag, CondorFile.path
          FROM CondorFile 
	  WHERE tag REGEXP '_TOMA_|_BOMA_|_TOPLY_|_BOPLY_|_SNAPO_' AND id NOT IN (SELECT fileID FROM ReceivedAttachment);

  DECLARE CONTINUE HANDLER FOR NOT FOUND SET exit_loop = TRUE;

  OPEN CUR;
  read_loop: LOOP

  FETCH CUR INTO CurFileID, CurFileTag, CurFilePath;

	
	
	IF exit_loop THEN
		CLOSE CUR;
		LEAVE read_loop;
	END IF;
		
        SET @sessionDelimiter = SUBSTRING_INDEX(CurFileTag, '_SESS_', -1); 
        SET @curSessionID = SUBSTRING_INDEX(@sessionDelimiter, '_', 1);
        
        
	Set @occlusionID = (SELECT id FROM Occlusion WHERE sessionID = @curSessionID AND deletedAt IS NULL);
      
	IF @occlusionID is not NULL THEN

		SET @pleft = SUBSTRING_INDEX(CurFileTag, @curSessionID, 1); 
		SET @pright = SUBSTRING_INDEX(CurFileTag, @curSessionID, -1); 
		SET @newTag = CONCAT(@pleft, @curSessionID, '_OCC_', @occlusionID, @pright);

		SET @filename = SUBSTRING_INDEX(CurFilePath, '/', -1);
		SET @sessionPath = SUBSTRING_INDEX(CurFilePath, @filename, 1);
		SET @newFilePath = CONCAT(@sessionPath, 'computedocclusion_', @occlusionID, '/', @filename);

		UPDATE CondorFile SET tag = @newTag, path = @newFilePath WHERE id = CurFileID;
        END IF;
        
  END LOOP;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `updateScanDisplayID` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `updateScanDisplayID`()
    NO SQL
BEGIN
  DECLARE CurOwnerID MEDIUMINT(8) UNSIGNED;
  DECLARE CurID CHAR(36);
  DECLARE CurSessionID CHAR(36);
  DECLARE CurLastSync DATETIME;

  DECLARE CurScanType
  ENUM('MAXILLAIRE', 'MANDIBULE', 'MORDU_ANTERIEUR', 'MORDU_POSTERIEUR_GAUCHE', 'MORDU_POSTERIEUR_DROIT');

  DECLARE CurNbSyncScan INT;
  DECLARE CurMaxDisplayID INT;

  DECLARE exit_loop BOOLEAN DEFAULT FALSE;

  DECLARE CUR CURSOR FOR
          SELECT Scan.ownerID, Scan.id, Scan.sessionID, Scan.scanType, Scan.lastSynced
          FROM Scan;

  DECLARE CONTINUE HANDLER FOR NOT FOUND SET exit_loop = TRUE;

  OPEN CUR;
  read_loop: LOOP

  FETCH CUR INTO CurOwnerID, CurID, CurSessionID, CurScanType, CurLastSync;

    
    
    IF exit_loop THEN
	CLOSE CUR;
	LEAVE read_loop;
    END IF;

    IF CurLastSync IS NULL THEN

	SET CurNbSyncScan = (SELECT COUNT(*)
				FROM Scan
				WHERE ownerID = CurOwnerID AND sessionID = CurSessionID AND scanType = CurScanType AND lastSynced IS NOT NULL);


	SET CurMaxDisplayID = (SELECT MAX(displayID)
				FROM Scan
				WHERE ownerID = CurOwnerID AND sessionID = CurSessionID AND scanType = CurScanType);

    	IF CurMaxDisplayID IS NULL OR CurMaxDisplayID = 0 THEN
		
        	SET CurMaxDisplayID = CurNbSyncScan;
    	END IF;

    	UPDATE Scan
    	SET displayID = (CurMaxDisplayID + 1)
    	WHERE ownerID = CurOwnerID AND id = CurID;

    END IF;

  END LOOP;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2022-03-22 11:50:36
