-- MySQL dump 10.13  Distrib 8.0.30, for Linux (x86_64)
--
-- Host: localhost    Database: wow_client
-- ------------------------------------------------------
-- Server version	8.0.30-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `Camera`
--

DROP TABLE IF EXISTS `Camera`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Camera` (
  `reference` char(13) NOT NULL,
  PRIMARY KEY (`reference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Camera`
--

LOCK TABLES `Camera` WRITE;
/*!40000 ALTER TABLE `Camera` DISABLE KEYS */;
INSERT INTO `Camera` VALUES ('1915020WO0206'),('1928021WO0755'),('1928021WO0782'),('2005021WO0910'),('2005021WO0911'),('2005021WO0925'),('2005021WO0948'),('2005021WO0974'),('2005021WO1284'),('2005021WO1380'),('2005021WO1392'),('2005021WO1421'),('2005021WO1422'),('2005021WO1429'),('2041022WO1569'),('2049022WO1785'),('2118022WO2357');
/*!40000 ALTER TABLE `Camera` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CameraAccess`
--

DROP TABLE IF EXISTS `CameraAccess`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CameraAccess` (
  `professionalId` mediumint unsigned NOT NULL,
  `computerMac` char(17) NOT NULL,
  `cameraReference` char(13) NOT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`professionalId`,`computerMac`,`cameraReference`),
  KEY `computerMac` (`computerMac`),
  KEY `cameraReference` (`cameraReference`),
  CONSTRAINT `CameraAccess_ibfk_1` FOREIGN KEY (`professionalId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `CameraAccess_ibfk_2` FOREIGN KEY (`computerMac`) REFERENCES `Computer` (`mac`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `CameraAccess_ibfk_3` FOREIGN KEY (`cameraReference`) REFERENCES `Camera` (`reference`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CameraAccess`
--

LOCK TABLES `CameraAccess` WRITE;
/*!40000 ALTER TABLE `CameraAccess` DISABLE KEYS */;
INSERT INTO `CameraAccess` VALUES (2,'00:d8:61:09:29:69','1928021WO0782','2020-07-13 14:24:41.000','2020-07-13 16:24:41.000'),(2,'00:d8:61:09:29:69','2005021WO0910','2020-12-03 10:52:46.000','2020-12-03 11:52:46.000'),(2,'00:d8:61:09:29:69','2005021WO0911','2020-11-17 09:39:55.000','2020-11-17 10:39:55.000'),(2,'00:d8:61:09:29:69','2005021WO0948','2020-05-27 11:37:30.000','2020-05-27 13:37:30.000'),(2,'00:d8:61:09:29:69','2005021WO0974','2020-07-16 07:41:19.000','2020-07-16 09:41:19.000'),(2,'00:d8:61:09:29:69','2005021WO1380','2020-05-27 13:55:11.000','2020-05-27 15:55:11.000'),(2,'00:d8:61:09:29:69','2005021WO1392','2020-05-27 14:13:23.000','2020-05-27 16:13:23.000'),(2,'00:d8:61:09:29:69','2005021WO1421','2020-05-27 13:59:27.000','2020-05-27 15:59:27.000'),(2,'00:d8:61:09:29:69','2005021WO1422','2020-05-27 12:11:54.000','2020-05-27 14:11:54.000'),(2,'00:d8:61:09:29:69','2005021WO1429','2020-05-27 12:16:40.000','2020-05-27 14:16:40.000'),(2,'00:d8:61:09:29:69','2049022WO1785','2021-06-18 11:31:53.000','2021-06-18 13:31:53.000'),(682,'00:d8:61:09:29:69','1915020WO0206','2020-10-22 10:43:13.000','2020-10-22 12:43:13.000'),(682,'00:d8:61:09:29:69','1928021WO0755','2021-01-11 11:41:41.000','2021-01-11 12:41:41.000'),(682,'00:d8:61:09:29:69','1928021WO0782','2020-05-29 09:54:44.000','2020-05-29 11:54:44.000'),(682,'00:d8:61:09:29:69','2005021WO0910','2020-12-09 13:48:24.000','2020-12-09 14:48:24.000'),(682,'00:d8:61:09:29:69','2005021WO0911','2020-11-12 14:00:55.000','2020-11-12 15:00:55.000'),(682,'00:d8:61:09:29:69','2005021WO0925','2021-03-24 08:43:29.000','2021-03-24 09:43:29.000'),(682,'00:d8:61:09:29:69','2005021WO1284','2022-05-11 13:09:58.000','2022-05-11 15:09:58.000'),(682,'00:d8:61:09:29:69','2041022WO1569','2021-04-06 14:10:36.000','2021-04-06 16:10:36.000'),(682,'00:d8:61:09:29:69','2118022WO2357','2022-05-17 14:24:42.000','2022-05-17 16:24:42.000');
/*!40000 ALTER TABLE `CameraAccess` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Computer`
--

DROP TABLE IF EXISTS `Computer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Computer` (
  `mac` char(76) NOT NULL,
  `condorVersionId` varchar(16) DEFAULT NULL,
  `graphicsCard` varchar(50) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`mac`),
  KEY `condorVersionId` (`condorVersionId`),
  CONSTRAINT `Computer_ibfk_1` FOREIGN KEY (`condorVersionId`) REFERENCES `CondorVersion` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Computer`
--

LOCK TABLES `Computer` WRITE;
/*!40000 ALTER TABLE `Computer` DISABLE KEYS */;
INSERT INTO `Computer` VALUES ('00:d8:61:09:29:69','v4.0.0','NVIDIA GeForce RTX 2070 with Max-Q Design','2023-04-20 11:01:57.949','2022-04-06 14:09:42.000');
/*!40000 ALTER TABLE `Computer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CondorVersion`
--

DROP TABLE IF EXISTS `CondorVersion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CondorVersion` (
  `id` varchar(16) NOT NULL,
  `dbVersion` varchar(10) DEFAULT NULL,
  `ihmVersion` varchar(10) DEFAULT NULL,
  `coreVersion` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CondorVersion`
--

LOCK TABLES `CondorVersion` WRITE;
/*!40000 ALTER TABLE `CondorVersion` DISABLE KEYS */;
INSERT INTO `CondorVersion` VALUES ('v0.1.1',NULL,NULL,NULL),('v0.1.2',NULL,NULL,NULL),('v1.0.0',NULL,NULL,NULL),('v2.0.0',NULL,NULL,NULL),('v2.1.1',NULL,NULL,NULL),('v2.2.2',NULL,NULL,NULL),('v2.3.3',NULL,NULL,NULL),('v2.4.4',NULL,NULL,NULL),('v3.0.0',NULL,NULL,NULL),('v3.0.1',NULL,NULL,NULL),('v4.0.0','','','');
/*!40000 ALTER TABLE `CondorVersion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `License`
--

DROP TABLE IF EXISTS `License`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `License` (
  `number` char(23) NOT NULL,
  `professionalId` mediumint unsigned NOT NULL,
  `enabled` enum('NONE','SOFTWARE','WEB','ALL') NOT NULL DEFAULT 'ALL',
  `licenseType` enum('PROD','DEMO') NOT NULL DEFAULT 'PROD',
  PRIMARY KEY (`number`),
  KEY `professionalId` (`professionalId`),
  CONSTRAINT `License_ibfk_1` FOREIGN KEY (`professionalId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `License`
--

LOCK TABLES `License` WRITE;
/*!40000 ALTER TABLE `License` DISABLE KEYS */;
INSERT INTO `License` VALUES ('JLHSPHQWNGPSZUGZBFUQQ86',682,'ALL','PROD'),('YAI1AER3LAHNEERAEWEEP1T',2,'ALL','PROD');
/*!40000 ALTER TABLE `License` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `LicenseAccess`
--

DROP TABLE IF EXISTS `LicenseAccess`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LicenseAccess` (
  `professionalId` mediumint unsigned NOT NULL,
  `licenseNumber` char(23) NOT NULL,
  `computerMac` char(17) NOT NULL,
  `condorVersionId` varchar(16) NOT NULL,
  `globalId` mediumint unsigned DEFAULT NULL,
  `status` enum('VALID','REPAIR') NOT NULL DEFAULT 'VALID',
  `activationDate` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`professionalId`,`licenseNumber`,`computerMac`),
  KEY `licenseNumber` (`licenseNumber`),
  KEY `computerMac` (`computerMac`),
  KEY `condorVersionId` (`condorVersionId`),
  CONSTRAINT `LicenseAccess_ibfk_1` FOREIGN KEY (`professionalId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `LicenseAccess_ibfk_2` FOREIGN KEY (`licenseNumber`) REFERENCES `License` (`number`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `LicenseAccess_ibfk_3` FOREIGN KEY (`computerMac`) REFERENCES `Computer` (`mac`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `LicenseAccess_ibfk_4` FOREIGN KEY (`condorVersionId`) REFERENCES `CondorVersion` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LicenseAccess`
--

LOCK TABLES `LicenseAccess` WRITE;
/*!40000 ALTER TABLE `LicenseAccess` DISABLE KEYS */;
INSERT INTO `LicenseAccess` VALUES (2,'YAI1AER3LAHNEERAEWEEP1T','00:d8:61:09:29:69','v2.3.3',49,'VALID','2019-07-12 00:00:00.000','2021-06-18 08:34:51.000','2021-06-18 10:34:51.000'),(682,'JLHSPHQWNGPSZUGZBFUQQ86','00:d8:61:09:29:69','v4.0.0',1,'VALID','2020-05-29 11:54:43.000','2023-04-12 13:31:03.060','2023-04-12 15:31:03.061');
/*!40000 ALTER TABLE `LicenseAccess` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Professional`
--

DROP TABLE IF EXISTS `Professional`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Professional` (
  `id` mediumint unsigned NOT NULL,
  `firstName` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `mainPhone` varchar(45) DEFAULT NULL,
  `country` varchar(75) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Professional`
--

LOCK TABLES `Professional` WRITE;
/*!40000 ALTER TABLE `Professional` DISABLE KEYS */;
INSERT INTO `Professional` VALUES (2,'Sophie','MOURIGAL','056139839','France'),(682,'MARC GERALD','CHOUKROUN','607350295','France');
/*!40000 ALTER TABLE `Professional` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `__db_version__`
--

DROP TABLE IF EXISTS `__db_version__`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `__db_version__` (
  `id` int NOT NULL AUTO_INCREMENT,
  `versionMajor` int NOT NULL,
  `versionMinor` int NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `migrationFile` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `__db_version__`
--

LOCK TABLES `__db_version__` WRITE;
/*!40000 ALTER TABLE `__db_version__` DISABLE KEYS */;
INSERT INTO `__db_version__` VALUES (1,1,0,'v1.0','migration_wow_client_1.0_create_wow_client_from_condor');
/*!40000 ALTER TABLE `__db_version__` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping routines for database 'wow_client'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-04-20 17:14:35
