-- MySQL dump 10.13  Distrib 8.0.27, for Linux (x86_64)
--
-- Host: localhost    Database: condor
-- ------------------------------------------------------
-- Server version	8.0.27-0ubuntu0.20.04.1

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `Act`
--

DROP TABLE IF EXISTS `Act`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Act` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `title` varchar(64) DEFAULT NULL,
  `dateCreated` datetime DEFAULT NULL,
  `comments` mediumtext,
  `globalDisplayID` mediumint unsigned DEFAULT NULL,
  `displayID` mediumint unsigned DEFAULT NULL,
  `patientID` char(36) NOT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastAccessed` datetime NOT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Work_Patient` (`patientID`,`ownerID`),
  CONSTRAINT `fk_Act_Patient` FOREIGN KEY (`patientID`) REFERENCES `condor_patient_local`.`Patient` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Act`
--

LOCK TABLES `Act` WRITE;
/*!40000 ALTER TABLE `Act` DISABLE KEYS */;
INSERT INTO `Act` VALUES (1070,'0384da3d-ecfb-491d-b4c6-55a01abee13b','PLAQUE PALATINE','2022-10-10 15:34:41','',1,1,'9d774be1-a55f-4825-ab1b-d07f47fea0d7','','',NULL,'2022-10-13 08:40:18','2022-10-13 08:47:59','2022-10-13 06:47:59','2022-10-10 15:34:42'),(1070,'2c6fd0d6-7657-4a9a-ab01-1ca685fe9373','','2022-07-21 10:27:41','',1,1,'e7759074-9318-45d5-bcd1-33d350e0b5a3','','','2022-07-21 10:27:45','2022-07-21 10:27:41',NULL,'2022-07-21 08:27:45','2022-07-21 10:27:45'),(2,'317b641b-5518-4198-9556-97fc2489ffeb','','2021-06-24 15:46:32','',409,1,'962f1518-7af1-402d-b050-a4fb49c5c5b8','','','2021-06-24 15:47:27','2021-06-24 15:46:32','2021-06-24 15:47:27','2021-06-24 13:47:27','2021-06-24 15:46:32'),(1070,'3a07530a-c8e3-4403-a4ac-311ed81204d1','TEST','2022-09-28 09:44:22','',1,1,'959e5762-b4e5-4295-a332-8a831a0fbf4a','','',NULL,'2022-09-28 12:19:24','2022-10-03 11:41:33','2022-10-03 09:41:33','2022-09-28 12:52:56'),(1070,'73bcc057-45f9-4b30-beee-c755ad473b8b','PLAQUE PALATINE','2022-10-11 09:33:02','',1,1,'e0f46c84-c106-4642-bfeb-a5b36b5820ae','','',NULL,'2022-10-13 08:59:30','2022-10-13 09:18:51','2022-10-13 07:18:51','2022-10-13 08:59:36'),(1070,'7a6d9986-071b-44b7-b838-56876454bad4','TEST 2','2022-09-28 11:35:55','',1,2,'959e5762-b4e5-4295-a332-8a831a0fbf4a','','',NULL,'2022-09-28 11:35:55','2022-10-03 11:41:31','2022-10-03 09:41:31','2022-09-28 12:19:08'),(1070,'8463efb2-00a2-451c-a82d-11d0968960c9','EMPREINTE','2022-07-21 10:10:50','',1,1,'5c0b4788-810f-4d15-8d45-7d5d359e7cdd','','','2022-07-21 10:14:07','2022-07-21 10:10:50','2022-07-21 10:14:07','2022-07-21 08:14:07','2022-07-21 10:13:53'),(1070,'8532a281-c902-48f3-94fd-a2a4f4101fb7','Plaque palatine','2022-10-04 15:42:15','',1,1,'1ddf5934-ea4d-477a-9ec0-1d9144b1467d','','',NULL,'2022-10-13 08:37:51','2022-10-13 08:47:59','2022-10-13 06:47:59','2022-10-04 16:03:29'),(1070,'9944d852-48ee-43ef-902e-6898dfddd53d','PLAQUE PALATINE','2022-10-10 09:59:47','',1,1,'d988cd8e-9d0f-42ab-99e2-fdcb685ac84a','','',NULL,'2022-10-13 08:35:24','2022-10-13 08:47:59','2022-10-13 06:47:59','2022-10-10 09:59:47'),(2,'cea83c4d-fcc2-4d2c-b98d-b94ce3ad5d51','','2021-06-24 15:47:28','',409,1,'616990f6-4bb6-40d6-a637-926ee3cbfb23','','',NULL,'2021-06-24 15:47:28','2021-06-24 15:48:28','2021-06-24 13:48:28','2021-06-24 15:48:26'),(2,'d1b217f0-7ea8-4abe-8052-9d91aae0f74d','','2022-07-12 14:27:17','',409,1,'43bfdd66-40e9-4024-8259-412b8743b170','','',NULL,'2022-07-12 14:27:17',NULL,'2022-07-12 12:28:29','2022-07-12 14:28:29'),(1070,'fdc3ebc0-c2b2-440e-bad8-5b030b506f78','PLAQUE PALATINE','2022-10-05 16:10:25','',1,1,'4ef31c58-7de3-427d-ae5c-24505cfef470','','',NULL,'2022-10-13 08:35:35','2022-10-13 08:48:00','2022-10-13 06:48:00','2022-10-05 16:17:31'),(1070,'fed44659-c88d-4999-98a9-6fbf04832e0c','EMPREINTE','2022-07-21 10:14:05','',1,2,'5c0b4788-810f-4d15-8d45-7d5d359e7cdd','','',NULL,'2022-07-21 16:14:33','2022-07-21 16:14:34','2022-07-21 14:14:34','2022-07-21 15:46:40');
/*!40000 ALTER TABLE `Act` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AddressInfo`
--

DROP TABLE IF EXISTS `AddressInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AddressInfo` (
  `id` char(36) NOT NULL COMMENT '(DC2Type:guid)',
  `line_0` varchar(255) DEFAULT NULL,
  `line_1` varchar(255) DEFAULT NULL,
  `line_2` varchar(255) DEFAULT NULL,
  `detail` varchar(255) DEFAULT NULL,
  `cityName` varchar(255) DEFAULT NULL,
  `cityState` varchar(255) DEFAULT NULL,
  `cityZip` varchar(25) DEFAULT NULL,
  `countryName` varchar(255) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AddressInfo`
--

LOCK TABLES `AddressInfo` WRITE;
/*!40000 ALTER TABLE `AddressInfo` DISABLE KEYS */;
INSERT INTO `AddressInfo` VALUES ('00000001-0000-0000-0000-000000000001','Labege','','',NULL,'Labege','','31670','France',NULL,NULL,'2022-03-31 17:40:19'),('00000002-0000-0000-0000-000000000001','137 rue garance','','',NULL,'LABEGE','','31670','France',NULL,NULL,'2022-03-31 17:40:19'),('00000003-0000-0000-0000-000000000001','137 rue Garance','','',NULL,'Labège','','31670','France',NULL,NULL,'2022-03-31 17:40:19'),('00000005-0000-0000-0000-000000000001','','','',NULL,'HOENHEIM','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000006-0000-0000-0000-000000000001','','','',NULL,'Marseille','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000007-0000-0000-0000-000000000001','','','',NULL,'MERIGNAC','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000008-0000-0000-0000-000000000001','','','',NULL,'MERIGNAC','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000009-0000-0000-0000-000000000001','','','',NULL,'Villiers Sur Marne','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000028-0000-0000-0000-000000000001','','','',NULL,'lyon','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000033-0000-0000-0000-000000000001','','','',NULL,'','','','',NULL,NULL,'2022-03-31 17:40:19'),('00000059-0000-0000-0000-000000000001','','','',NULL,'LE TEIL','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000155-0000-0000-0000-000000000001','','','',NULL,'ECOUFLANT','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000172-0000-0000-0000-000000000001','4 Chemin Couralis','','',NULL,'LAROIN','','64110','France',NULL,NULL,'2022-03-31 17:40:19'),('00000177-0000-0000-0000-000000000001','AVDA. JUAN CARAMUEL,1','','',NULL,'LEGANES','','28916','España',NULL,NULL,'2022-03-31 17:40:19'),('00000193-0000-0000-0000-000000000001','','','',NULL,'VIRIAT ','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000224-0000-0000-0000-000000000001','','','',NULL,'CUGNAUX','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000317-0000-0000-0000-000000000001','','','',NULL,'LONGWY','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000339-0000-0000-0000-000000000001','','','',NULL,'Paris','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000355-0000-0000-0000-000000000001','','','',NULL,'Parma','','','Italia',NULL,NULL,'2022-03-31 17:40:19'),('00000375-0000-0000-0000-000000000001','95, Avenue de la Marne','','',NULL,'Epinay sur Seine','','93800','France',NULL,NULL,'2022-03-31 17:40:19'),('00000377-0000-0000-0000-000000000001','51 rue moncey','','',NULL,'LYON','','69003','France',NULL,NULL,'2022-03-31 17:40:19'),('00000421-0000-0000-0000-000000000001','','','',NULL,'PARIS 17','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000568-0000-0000-0000-000000000001','','','',NULL,'Tlse','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000652-0000-0000-0000-000000000001','','','',NULL,'','','','',NULL,NULL,'2022-03-31 17:40:19'),('00000681-0000-0000-0000-000000000001','','','',NULL,'Chamalières ','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000689-0000-0000-0000-000000000001','','','',NULL,'CHAMBERY','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000805-0000-0000-0000-000000000001','137 rue Garance','','',NULL,'Labege','','31670','France',NULL,NULL,'2022-03-31 17:40:19'),('00000838-0000-0000-0000-000000000001','','','',NULL,'','','','',NULL,NULL,'2022-03-31 17:40:19'),('00000840-0000-0000-0000-000000000001','','','',NULL,'','','','',NULL,NULL,'2022-03-31 17:40:19'),('00000850-0000-0000-0000-000000000001','52 RUE DU BOURNO','','',NULL,'BOEGE','','74420','France',NULL,NULL,'2022-03-31 17:40:19'),('00000916-0000-0000-0000-000000000001','','','',NULL,'','','','',NULL,NULL,'2022-03-31 17:40:19'),('00000917-0000-0000-0000-000000000001','','','',NULL,'','','','',NULL,NULL,'2022-03-31 17:40:19'),('00000918-0000-0000-0000-000000000001','','','',NULL,'Paris','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000941-0000-0000-0000-000000000001','','','',NULL,'','','','',NULL,NULL,'2022-03-31 17:40:19'),('1b9fb50b-ca87-4650-b356-f1c97e4c9375','','','',NULL,'','','','',NULL,NULL,'2022-07-21 14:25:09'),('2c2079e2-cd33-4289-ba15-499df332f244','PRACTICANTE ANTONIO ASTRAY 4 BAJO. ','','',NULL,'TAPIA','','33740','España',NULL,NULL,'2022-03-31 17:40:19'),('4587f1db-25f0-44f9-8512-01f705ae9949','VIA E.TAZZOLI','','',NULL,'CASERTA','','81100','Italia',NULL,NULL,'2022-03-31 17:40:19'),('523a5c43-599a-4b9c-82bd-b755e6a0bbc8','4 RUE DES DOMELIERS','','',NULL,'COMPIEGNE','','60200','France',NULL,NULL,'2022-07-21 08:05:05'),('b6281cbf-cfa6-4e42-8486-21b558c137ee','','','',NULL,'Labege','','','',NULL,NULL,'2022-06-17 15:22:57'),('cfa37f9c-eac1-4f2b-bf21-1672b9605bd9','801 Wayne Avenue, Suite G200','','',NULL,'Silver Spring','','20910','United States',NULL,NULL,'2022-03-31 17:40:19'),('fa832402-c7cd-411d-acc9-f4ff9c9c4898','4 RUE DES DOMELIERS','','',NULL,'COMPIEGNE','','60200','',NULL,NULL,'2022-07-21 08:27:57');
/*!40000 ALTER TABLE `AddressInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Assistant`
--

DROP TABLE IF EXISTS `Assistant`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Assistant` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `patientRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'READ_ONLY',
  `actRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'READ_ONLY',
  `discussionRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'READ_ONLY',
  `credentialsID` char(36) DEFAULT NULL,
  `personInfoID` char(36) DEFAULT NULL COMMENT '(DC2Type:guid)',
  `phoneInfoID` char(36) DEFAULT NULL COMMENT '(DC2Type:guid)',
  `addressInfoID` char(36) DEFAULT NULL COMMENT '(DC2Type:guid)',
  `officeID` char(36) DEFAULT NULL,
  `tempPassword` varchar(32) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `lastConnection` timestamp NULL DEFAULT NULL,
  `firstConnection` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`,`ownerID`),
  UNIQUE KEY `UNIQ_4068FE723D139428` (`personInfoID`),
  UNIQUE KEY `UNIQ_4068FE72627FFEF6` (`phoneInfoID`),
  UNIQUE KEY `UNIQ_4068FE72A680FCCC` (`addressInfoID`),
  KEY `fk_Assistant_Professional` (`ownerID`),
  KEY `fk_Assistant_Office` (`officeID`,`ownerID`),
  KEY `fk_Assistant_Credentials_idx` (`credentialsID`,`id`),
  KEY `fk_Assistant_PersonInfo_idx` (`personInfoID`),
  KEY `fk_Assistant_PhoneInfo_idx` (`phoneInfoID`),
  KEY `fk_Assistant_AddressInfo_idx` (`addressInfoID`),
  CONSTRAINT `fk_Assistant_AddressInfo` FOREIGN KEY (`addressInfoID`) REFERENCES `AddressInfo` (`id`),
  CONSTRAINT `fk_Assistant_Credentials` FOREIGN KEY (`credentialsID`) REFERENCES `Credentials` (`id`),
  CONSTRAINT `fk_Assistant_Office` FOREIGN KEY (`officeID`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Assistant_PersonInfo` FOREIGN KEY (`personInfoID`) REFERENCES `PersonInfo` (`id`),
  CONSTRAINT `fk_Assistant_PhoneInfo` FOREIGN KEY (`phoneInfoID`) REFERENCES `PhoneInfo` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Assistant`
--

LOCK TABLES `Assistant` WRITE;
/*!40000 ALTER TABLE `Assistant` DISABLE KEYS */;
INSERT INTO `Assistant` VALUES (1070,'bb400151-f8fe-4758-a9bc-273e9be9e993','READ_WRITE','READ_WRITE','READ_WRITE','601c3968-b0ac-4247-9552-d9c1fba94fe8','ce4b1d1b-e147-4ad3-9be6-d07eddb2116c','eec29aa8-fa3d-42af-8302-cece042df329','fa832402-c7cd-411d-acc9-f4ff9c9c4898','ce5c9575-3e13-44d4-a543-61e770347bd6','',NULL,'2022-10-13 08:47:51','2022-10-13 06:47:51','2022-10-13 08:34:07','2022-10-13 06:34:07',0);
/*!40000 ALTER TABLE `Assistant` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `Assistant_AFTER_DELETE` AFTER DELETE ON `Assistant` FOR EACH ROW BEGIN
	DELETE FROM PersonInfo  WHERE ownerID = OLD.ownerID AND id = OLD.personInfoID;
	DELETE FROM AddressInfo WHERE ownerID = OLD.ownerID AND id = OLD.addressInfoID;
	DELETE FROM PhoneInfo   WHERE ownerID = OLD.ownerID AND id = OLD.phoneInfoID;
	DELETE FROM Credentials WHERE ownerID = OLD.ownerID AND id = OLD.credentialsID;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `CircleOrder`
--

DROP TABLE IF EXISTS `CircleOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CircleOrder` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `actID` char(36) NOT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `title` varchar(64) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `status` enum('not_sent','waiting_wow_api','sending_wow_api','sending_circle_api','sent','cancelled') NOT NULL DEFAULT 'waiting_wow_api',
  `createdAt` datetime NOT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `json` text NOT NULL,
  `metadata` text NOT NULL,
  `localDisplayID` int unsigned DEFAULT NULL,
  `globalDisplayID` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_CircleOrder_Act` (`actID`,`ownerID`),
  CONSTRAINT `fk_CircleOrder_Act` FOREIGN KEY (`actID`, `ownerID`) REFERENCES `Act` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CircleOrder`
--

LOCK TABLES `CircleOrder` WRITE;
/*!40000 ALTER TABLE `CircleOrder` DISABLE KEYS */;
/*!40000 ALTER TABLE `CircleOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CircleOrderFile`
--

DROP TABLE IF EXISTS `CircleOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CircleOrderFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `orderID` char(36) NOT NULL,
  `fileID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`orderID`,`fileID`),
  KEY `fk_CircleOrderFile_CircleOrder` (`orderID`,`ownerID`),
  KEY `fk_CircleOrderFile_CondorFile` (`fileID`,`ownerID`),
  CONSTRAINT `fk_CircleOrderFile_CircleOrder` FOREIGN KEY (`orderID`, `ownerID`) REFERENCES `CircleOrder` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_CircleOrderFile_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CircleOrderFile`
--

LOCK TABLES `CircleOrderFile` WRITE;
/*!40000 ALTER TABLE `CircleOrderFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `CircleOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CondorFile`
--

DROP TABLE IF EXISTS `CondorFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CondorFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `path` text NOT NULL,
  `type` varchar(250) NOT NULL,
  `tag` varchar(250) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `originalName` varchar(100) DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `status` enum('CREATED','UPDATED','SYNCED','ERROR') DEFAULT NULL,
  `originalID` char(36) NOT NULL,
  `version` mediumint NOT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `metadata` text,
  PRIMARY KEY (`id`,`ownerID`),
  UNIQUE KEY `un_CondorFile_version` (`ownerID`,`originalID`,`version`),
  KEY `fk_CondorFile_Professional` (`ownerID`),
  KEY `fk_CondorFile_CondorFile` (`originalID`,`ownerID`),
  CONSTRAINT `fk_CondorFile_CondorFile` FOREIGN KEY (`originalID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_CondorFile_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CondorFile`
--

LOCK TABLES `CondorFile` WRITE;
/*!40000 ALTER TABLE `CondorFile` DISABLE KEYS */;
INSERT INTO `CondorFile` VALUES (1070,'016dd378-6bd3-4763-80e5-7b4b1ddd19de','','ZIP','PATIENT_959e5762-b4e5-4295-a332-8a831a0fbf4a_ACT_3a07530a-c8e3-4403-a4ac-311ed81204d1_SESS_e9fbefb3-e2af-4fe4-ac5f-0495636df2cc_TOSC_3149b0eb-455c-46a0-9f32-ee7d54043dae_ZIP_','2022-09-28 10:20:02','2022-09-28 09:53:31','',NULL,'CREATED','3c5dbf34-9f19-4d76-9d84-5abfb1cdb3a5',1,'2022-09-28 12:20:02','bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993','{\"displayTitle\":\"Maxillaire 1.3.1.1.4\",\"modelMatrix\":\"0.38359,-0.891401,0.241375,0,0.923503,0.370256,-0.100259,0,-1.68184e-09,0.261369,0.965239,0,7.27518,-0.903465,-15.2348,1\",\"title\":\"Maxillaire ZIP\"}'),(1070,'0258594c-75cd-4ee3-8d5d-a60808aee731','/var/.data/2022/ff8a242d-bd49-4bed-a171-ee187c282fc0/e0f46c84-c106-4642-bfeb-a5b36b5820ae/session_73bcc057-45f9-4b30-beee-c755ad473b8b/occlusion_d3b06f3d-a4b5-4db4-81f7-39b33c210472/scan_87171523-80e9-4f42-a13e-91213d9fba55/9_w1_o1_maxillaire_snapshot_2.png','SNAPS','PATIENT_e0f46c84-c106-4642-bfeb-a5b36b5820ae_ACT_73bcc057-45f9-4b30-beee-c755ad473b8b_SESS_d3b06f3d-a4b5-4db4-81f7-39b33c210472_TOSC_87171523-80e9-4f42-a13e-91213d9fba55_SNAPS_','2022-10-11 08:32:33','2022-10-11 10:32:24','9_w1_o1_maxillaire_snapshot_2.png','2022-10-11 10:32:33','SYNCED','903be239-1532-467c-b347-3dbedcddd39c',2,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993','{\"displayTitle\":\"Maxillaire 1.9.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1070,'0e914012-d52b-4d16-858d-c13cfeafdbd5','','ZIP','PATIENT_959e5762-b4e5-4295-a332-8a831a0fbf4a_ACT_7a6d9986-071b-44b7-b838-56876454bad4_SESS_3666e5c7-80c2-4717-8bcb-4635d69b4a96_TOSC_25167fd5-d99b-4723-9e78-c5acb6642934_ZIP_','2022-09-28 09:41:44','2022-09-28 11:41:14','',NULL,'CREATED','0e914012-d52b-4d16-858d-c13cfeafdbd5',0,'2022-09-28 11:41:44','bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993','{\"displayTitle\":\"Maxillaire 1.3.2.1.1\",\"modelMatrix\":\"0.124254,0.985547,-0.115146,0,-0.992251,0.123414,-0.0144191,0,6.77959e-10,0.116046,0.993244,0,14.243,-17.6922,-19.7866,1\",\"title\":\"Maxillaire ZIP\"}'),(1070,'135e9338-31af-4b45-a4b2-cf5ee024ac47','/var/.data/2022/ff8a242d-bd49-4bed-a171-ee187c282fc0/959e5762-b4e5-4295-a332-8a831a0fbf4a/session_3a07530a-c8e3-4403-a4ac-311ed81204d1/occlusion_ea7ca0ea-51ca-4a55-8cf5-cfec2f762fa2/scan_521bad12-deec-4508-b53a-7e46a707e6a8/3_w1_o2_mandibule_snapshot_0.png','SNAPS','PATIENT_959e5762-b4e5-4295-a332-8a831a0fbf4a_ACT_3a07530a-c8e3-4403-a4ac-311ed81204d1_SESS_ea7ca0ea-51ca-4a55-8cf5-cfec2f762fa2_BOSC_521bad12-deec-4508-b53a-7e46a707e6a8_SNAPS_','2022-10-03 09:48:47','2022-09-28 12:39:31','3_w1_o2_mandibule_snapshot_0.png','2022-10-03 11:48:47','SYNCED','135e9338-31af-4b45-a4b2-cf5ee024ac47',0,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993','{\"displayTitle\":\"Mandibule 1.3.1.2.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1070,'18e2773c-052d-4be7-a3a2-65773980b3ac','/var/.data/2022/ff8a242d-bd49-4bed-a171-ee187c282fc0/e0f46c84-c106-4642-bfeb-a5b36b5820ae/session_73bcc057-45f9-4b30-beee-c755ad473b8b/occlusion_d3b06f3d-a4b5-4db4-81f7-39b33c210472/scan_87171523-80e9-4f42-a13e-91213d9fba55/9_w1_o1_maxillaire_snapshot_1.png','SNAPS','PATIENT_e0f46c84-c106-4642-bfeb-a5b36b5820ae_ACT_73bcc057-45f9-4b30-beee-c755ad473b8b_SESS_d3b06f3d-a4b5-4db4-81f7-39b33c210472_TOSC_87171523-80e9-4f42-a13e-91213d9fba55_SNAPS_','2022-10-11 08:24:31','2022-10-11 10:24:21','9_w1_o1_maxillaire_snapshot_1.png','2022-10-11 10:24:31','SYNCED','903be239-1532-467c-b347-3dbedcddd39c',1,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993','{\"displayTitle\":\"Maxillaire 1.9.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1070,'1c64f0eb-a022-4aa4-a0ea-bbde3f08399b','','SNAPS','PATIENT_959e5762-b4e5-4295-a332-8a831a0fbf4a_ACT_3a07530a-c8e3-4403-a4ac-311ed81204d1_SESS_e9fbefb3-e2af-4fe4-ac5f-0495636df2cc_TOSC_4d78c4e6-43de-4778-a97a-744a71ad8f47_SNAPS_','2022-09-28 10:20:10','2022-09-28 09:52:56','',NULL,'CREATED','1c64f0eb-a022-4aa4-a0ea-bbde3f08399b',0,'2022-09-28 12:20:10','ff8a242d-bd49-4bed-a171-ee187c282fc0','ff8a242d-bd49-4bed-a171-ee187c282fc0','{\"displayTitle\":\"Maxillaire 1.3.1.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1070,'20618dbb-604f-4e4e-810f-ffed65022dd2','/var/.data/2022/ff8a242d-bd49-4bed-a171-ee187c282fc0/959e5762-b4e5-4295-a332-8a831a0fbf4a/session_3a07530a-c8e3-4403-a4ac-311ed81204d1/occlusion_ea7ca0ea-51ca-4a55-8cf5-cfec2f762fa2/scan_c0b45e70-6cd8-404b-a997-a61d85ce9721/3_w1_o2_mandibule_scan_file_0.zip','ZIP','PATIENT_959e5762-b4e5-4295-a332-8a831a0fbf4a_ACT_3a07530a-c8e3-4403-a4ac-311ed81204d1_SESS_ea7ca0ea-51ca-4a55-8cf5-cfec2f762fa2_BOSC_c0b45e70-6cd8-404b-a997-a61d85ce9721_ZIP_','2022-10-03 09:50:30','2022-09-28 12:52:56','3_w1_o2_mandibule_scan_file_0.zip','2022-10-03 11:50:30','SYNCED','20618dbb-604f-4e4e-810f-ffed65022dd2',0,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993','{\"displayTitle\":\"Mandibule 1.3.1.2.2\",\"modelMatrix\":\"-0.811858,0.565966,-0.143416,0,-0.583854,-0.786985,0.199422,0,1.2285e-08,0.245636,0.969362,0,10.8738,-25.2042,-13.9702,1\",\"title\":\"Mandibule ZIP\"}'),(2,'27e8ca83-ab81-4826-8827-f8b8fefb8cfa','/var/.data/2021/bf19c334-c71b-4e23-9ce0-73ddec5fe103/616990f6-4bb6-40d6-a637-926ee3cbfb23/session_cea83c4d-fcc2-4d2c-b98d-b94ce3ad5d51/occlusion_8f3430ca-19b8-49d4-bc0a-125d43decc54/scan_35890e97-f371-4a18-8c62-354841cfea22/2_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_616990f6-4bb6-40d6-a637-926ee3cbfb23_ACT_cea83c4d-fcc2-4d2c-b98d-b94ce3ad5d51_SESS_8f3430ca-19b8-49d4-bc0a-125d43decc54_TOSC_35890e97-f371-4a18-8c62-354841cfea22_SNAPS_','2022-07-12 12:26:49','2021-06-24 15:48:26','2_w1_o1_maxillaire_snapshot_0.png','2022-07-12 14:26:49','SYNCED','27e8ca83-ab81-4826-8827-f8b8fefb8cfa',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 409.2.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'35aee314-e69d-42b2-b02d-9e9316055b2a','/var/.data/2021/bf19c334-c71b-4e23-9ce0-73ddec5fe103/616990f6-4bb6-40d6-a637-926ee3cbfb23/session_cea83c4d-fcc2-4d2c-b98d-b94ce3ad5d51/occlusion_8f3430ca-19b8-49d4-bc0a-125d43decc54/scan_35890e97-f371-4a18-8c62-354841cfea22/2_w1_o1_maxillaire_scan_file_0.ply','PLY','PATIENT_616990f6-4bb6-40d6-a637-926ee3cbfb23_ACT_cea83c4d-fcc2-4d2c-b98d-b94ce3ad5d51_SESS_8f3430ca-19b8-49d4-bc0a-125d43decc54_TOSC_35890e97-f371-4a18-8c62-354841cfea22_PLY_','2022-07-12 12:26:49','2021-06-24 15:48:26','2_w1_o1_maxillaire_scan_file_0.ply','2022-07-12 14:26:49','SYNCED','35aee314-e69d-42b2-b02d-9e9316055b2a',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 409.2.1.1.1\",\"modelMatrix\":\"-0.908388,-0.36451,0.204848,0,0.418127,-0.791904,0.445036,0,-6.18927e-9,0.489919,0.871768,0,-25.2441,-9.56708,-19.514,1\",\"title\":\"Maxillaire PLY\"}'),(1070,'3c5dbf34-9f19-4d76-9d84-5abfb1cdb3a5','','ZIP','PATIENT_959e5762-b4e5-4295-a332-8a831a0fbf4a_ACT_3a07530a-c8e3-4403-a4ac-311ed81204d1_SESS_e9fbefb3-e2af-4fe4-ac5f-0495636df2cc_TOSC_3149b0eb-455c-46a0-9f32-ee7d54043dae_ZIP_','2022-09-28 10:20:02','2022-09-28 09:52:57','',NULL,'CREATED','3c5dbf34-9f19-4d76-9d84-5abfb1cdb3a5',0,'2022-09-28 12:20:02','ff8a242d-bd49-4bed-a171-ee187c282fc0','ff8a242d-bd49-4bed-a171-ee187c282fc0','{\"displayTitle\":\"Maxillaire 1.3.1.1.4\",\"modelMatrix\":\"0.38359,-0.891401,0.241375,0,0.923503,0.370256,-0.100259,0,-1.68184e-09,0.261369,0.965239,0,7.27518,-0.903465,-15.2348,1\",\"title\":\"Maxillaire ZIP\"}'),(1070,'46043760-926f-4ae1-a719-69ffa9110c63','/var/.data/2022/ff8a242d-bd49-4bed-a171-ee187c282fc0/959e5762-b4e5-4295-a332-8a831a0fbf4a/session_3a07530a-c8e3-4403-a4ac-311ed81204d1/occlusion_ea7ca0ea-51ca-4a55-8cf5-cfec2f762fa2/scan_c8b44d90-bd34-4895-ad41-bdd76ff0b475/3_w1_o2_maxillaire_scan_file_0.zip','ZIP','PATIENT_959e5762-b4e5-4295-a332-8a831a0fbf4a_ACT_3a07530a-c8e3-4403-a4ac-311ed81204d1_SESS_ea7ca0ea-51ca-4a55-8cf5-cfec2f762fa2_TOSC_c8b44d90-bd34-4895-ad41-bdd76ff0b475_ZIP_','2022-10-03 09:52:51','2022-09-28 12:31:10','3_w1_o2_maxillaire_scan_file_0.zip','2022-10-03 11:52:51','SYNCED','46043760-926f-4ae1-a719-69ffa9110c63',0,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993','{\"displayTitle\":\"Maxillaire 1.3.1.2.2\",\"modelMatrix\":\"0.242664,0.953957,-0.176295,0,-0.97011,0.238623,-0.0440984,0,-3.4137e-09,0.181727,0.983349,0,-7.18678,-31.1174,-15.118,1\",\"title\":\"Maxillaire ZIP\"}'),(1070,'4e495cd7-63c8-454c-9bf0-7d67561e6cb3','/var/.data/2022/ff8a242d-bd49-4bed-a171-ee187c282fc0/959e5762-b4e5-4295-a332-8a831a0fbf4a/session_3a07530a-c8e3-4403-a4ac-311ed81204d1/occlusion_ea7ca0ea-51ca-4a55-8cf5-cfec2f762fa2/scan_c8b44d90-bd34-4895-ad41-bdd76ff0b475/3_w1_o2_maxillaire_snapshot_0.png','SNAPS','PATIENT_959e5762-b4e5-4295-a332-8a831a0fbf4a_ACT_3a07530a-c8e3-4403-a4ac-311ed81204d1_SESS_ea7ca0ea-51ca-4a55-8cf5-cfec2f762fa2_TOSC_c8b44d90-bd34-4895-ad41-bdd76ff0b475_SNAPS_','2022-10-03 09:47:07','2022-09-28 12:31:09','3_w1_o2_maxillaire_snapshot_0.png','2022-10-03 11:47:07','SYNCED','4e495cd7-63c8-454c-9bf0-7d67561e6cb3',0,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993','{\"displayTitle\":\"Maxillaire 1.3.1.2.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'50518be0-3eb3-4029-88c2-d0a0d6456005','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/43bfdd66-40e9-4024-8259-412b8743b170/session_d1b217f0-7ea8-4abe-8052-9d91aae0f74d/occlusion_bf6aab3b-87a2-40d8-88a0-1b221d68e62e/scan_31f454d0-a75f-4f4e-a3a4-bfd0a475806a/3_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_43bfdd66-40e9-4024-8259-412b8743b170_ACT_d1b217f0-7ea8-4abe-8052-9d91aae0f74d_SESS_bf6aab3b-87a2-40d8-88a0-1b221d68e62e_TOSC_31f454d0-a75f-4f4e-a3a4-bfd0a475806a_ZIP_','2022-07-12 12:28:29','2022-07-12 14:28:29','3_w1_o1_maxillaire_scan_file_0.zip',NULL,'CREATED','50518be0-3eb3-4029-88c2-d0a0d6456005',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire 409.3.1.1.1\",\"modelMatrix\":\"-0.156564,-0.974571,0.160312,0,0.987668,-0.154488,0.0254124,0,-3.34565e-10,0.162313,0.986739,0,-3.02741,-22.7247,-18.3996,1\",\"title\":\"Maxillaire ZIP\"}'),(1070,'542f6fdd-deb5-4069-9ffd-1920238b4944','','SNAPS','PATIENT_959e5762-b4e5-4295-a332-8a831a0fbf4a_ACT_3a07530a-c8e3-4403-a4ac-311ed81204d1_SESS_e9fbefb3-e2af-4fe4-ac5f-0495636df2cc_TOSC_b9f77799-d642-4773-a67d-d83f37e0c814_SNAPS_','2022-09-28 10:20:18','2022-09-28 09:52:45','',NULL,'CREATED','542f6fdd-deb5-4069-9ffd-1920238b4944',0,'2022-09-28 12:20:18','bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993','{\"displayTitle\":\"Maxillaire 1.3.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1070,'55e7cd59-5166-47a6-b030-0fcdac85813a','','SNAPS','PATIENT_959e5762-b4e5-4295-a332-8a831a0fbf4a_ACT_3a07530a-c8e3-4403-a4ac-311ed81204d1_SESS_e9fbefb3-e2af-4fe4-ac5f-0495636df2cc_TOSC_3149b0eb-455c-46a0-9f32-ee7d54043dae_SNAPS_','2022-09-28 10:20:02','2022-09-28 09:52:57','',NULL,'CREATED','55e7cd59-5166-47a6-b030-0fcdac85813a',0,'2022-09-28 12:20:02','ff8a242d-bd49-4bed-a171-ee187c282fc0','ff8a242d-bd49-4bed-a171-ee187c282fc0','{\"displayTitle\":\"Maxillaire 1.3.1.1.4\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1070,'67721e35-4f2b-4d59-8fc9-27a5080677ac','/var/.data/2022/ff8a242d-bd49-4bed-a171-ee187c282fc0/1ddf5934-ea4d-477a-9ec0-1d9144b1467d/session_8532a281-c902-48f3-94fd-a2a4f4101fb7/occlusion_ce4d3ca4-dc3a-46cb-aa8a-108d7be41a7f/scan_36baf7e7-c8ea-4a9d-a7b2-703b4c4491db/5_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_1ddf5934-ea4d-477a-9ec0-1d9144b1467d_ACT_8532a281-c902-48f3-94fd-a2a4f4101fb7_SESS_ce4d3ca4-dc3a-46cb-aa8a-108d7be41a7f_TOSC_36baf7e7-c8ea-4a9d-a7b2-703b4c4491db_SNAPS_','2022-10-05 14:17:32','2022-10-04 16:03:28','5_w1_o1_maxillaire_snapshot_0.png','2022-10-05 16:17:32','SYNCED','67721e35-4f2b-4d59-8fc9-27a5080677ac',0,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993','{\"displayTitle\":\"Maxillaire 1.5.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1070,'6e0f3643-79b8-4ea3-9648-dd038133461a','/var/.data/2022/ff8a242d-bd49-4bed-a171-ee187c282fc0/4ef31c58-7de3-427d-ae5c-24505cfef470/session_fdc3ebc0-c2b2-440e-bad8-5b030b506f78/occlusion_2209d1b9-4da1-4054-814c-5a760347d91d/scan_9a0912c7-d649-4d0a-bc0d-b26ae74ab1f4/6_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_4ef31c58-7de3-427d-ae5c-24505cfef470_ACT_fdc3ebc0-c2b2-440e-bad8-5b030b506f78_SESS_2209d1b9-4da1-4054-814c-5a760347d91d_TOSC_9a0912c7-d649-4d0a-bc0d-b26ae74ab1f4_ZIP_','2022-10-05 14:19:17','2022-10-05 16:17:31','6_w1_o1_maxillaire_scan_file_0.zip','2022-10-05 16:19:17','SYNCED','6e0f3643-79b8-4ea3-9648-dd038133461a',0,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993','{\"displayTitle\":\"Maxillaire 1.6.1.1.1\",\"modelMatrix\":\"-0.491595,0.83993,-0.229895,0,-0.870824,-0.474155,0.129779,0,3.32941e-09,0.263997,0.964524,0,-9.22817,-27.1671,-15.1952,1\",\"title\":\"Maxillaire ZIP\"}'),(1070,'70f41a6e-b645-414e-ad3f-15b109417c41','/var/.data/2022/ff8a242d-bd49-4bed-a171-ee187c282fc0/959e5762-b4e5-4295-a332-8a831a0fbf4a/session_7a6d9986-071b-44b7-b838-56876454bad4/occlusion_3666e5c7-80c2-4717-8bcb-4635d69b4a96/scan_311bf037-40e8-468f-8a4a-808858eebfc0/3_w2_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_959e5762-b4e5-4295-a332-8a831a0fbf4a_ACT_7a6d9986-071b-44b7-b838-56876454bad4_SESS_3666e5c7-80c2-4717-8bcb-4635d69b4a96_TOSC_311bf037-40e8-468f-8a4a-808858eebfc0_ZIP_','2022-10-03 09:43:41','2022-09-28 12:05:01','3_w2_o1_maxillaire_scan_file_0.zip','2022-10-03 11:43:41','SYNCED','70f41a6e-b645-414e-ad3f-15b109417c41',0,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993','{\"displayTitle\":\"Maxillaire 1.3.2.1.3\",\"modelMatrix\":\"-0.598058,0.793179,-0.114864,0,-0.801453,-0.591884,0.0857138,0,1.81723e-09,0.14332,0.989676,0,20.1062,-8.85285,-20.6562,1\",\"title\":\"Maxillaire ZIP\"}'),(1070,'72fa704c-5190-4948-97eb-06a12bf88d88','/var/.data/2022/ff8a242d-bd49-4bed-a171-ee187c282fc0/959e5762-b4e5-4295-a332-8a831a0fbf4a/session_7a6d9986-071b-44b7-b838-56876454bad4/occlusion_3666e5c7-80c2-4717-8bcb-4635d69b4a96/scan_b9b9342b-1007-4281-a39d-27fce0f4ba30/3_w2_o1_mandibule_scan_file_0.zip','ZIP','PATIENT_959e5762-b4e5-4295-a332-8a831a0fbf4a_ACT_7a6d9986-071b-44b7-b838-56876454bad4_SESS_3666e5c7-80c2-4717-8bcb-4635d69b4a96_BOSC_b9b9342b-1007-4281-a39d-27fce0f4ba30_ZIP_','2022-10-03 09:45:41','2022-09-28 11:57:56','3_w2_o1_mandibule_scan_file_0.zip','2022-10-03 11:45:41','SYNCED','72fa704c-5190-4948-97eb-06a12bf88d88',0,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993','{\"displayTitle\":\"Mandibule 1.3.2.1.1\",\"modelMatrix\":\"0.860016,0.496848,-0.116252,0,-0.510267,0.837399,-0.195934,0,-1.13202e-09,0.227826,0.973702,0,-21.9697,2.21765,-20.5591,1\",\"title\":\"Mandibule ZIP\"}'),(1070,'74cd0086-0d00-4ace-97ab-4159da8b8e39','/var/.data/2022/ff8a242d-bd49-4bed-a171-ee187c282fc0/959e5762-b4e5-4295-a332-8a831a0fbf4a/session_7a6d9986-071b-44b7-b838-56876454bad4/occlusion_3666e5c7-80c2-4717-8bcb-4635d69b4a96/scan_3504d59a-bb7a-48ed-a241-cbf017371fe1/3_w2_o1_mordu_posterieur_droit_scan_file_0.zip','ZIP','PATIENT_959e5762-b4e5-4295-a332-8a831a0fbf4a_ACT_7a6d9986-071b-44b7-b838-56876454bad4_SESS_3666e5c7-80c2-4717-8bcb-4635d69b4a96_RISC_3504d59a-bb7a-48ed-a241-cbf017371fe1_ZIP_','2022-10-03 09:44:10','2022-09-28 12:08:47','3_w2_o1_mordu_posterieur_droit_scan_file_0.zip','2022-10-03 11:44:10','SYNCED','74cd0086-0d00-4ace-97ab-4159da8b8e39',0,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993','{\"displayTitle\":\"Mordu posterieur droit 1.3.2.1.1\",\"modelMatrix\":\"0.99841,-0.0545713,0.0121108,0,0.0550152,0.998505,-0.0022271,0,-0.0122653,0.00299018,0.999924,0,-1.79325,1.87485,-12.7643,1\",\"title\":\"Mordu posterieur droit ZIP\"}'),(1070,'83f70326-23c7-4dbf-9860-8381656dc944','/var/.data/2022/ff8a242d-bd49-4bed-a171-ee187c282fc0/959e5762-b4e5-4295-a332-8a831a0fbf4a/session_3a07530a-c8e3-4403-a4ac-311ed81204d1/occlusion_e9fbefb3-e2af-4fe4-ac5f-0495636df2cc/scan_30d758b6-ddfe-4e9e-8a14-4e24d25340f8/3_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_959e5762-b4e5-4295-a332-8a831a0fbf4a_ACT_3a07530a-c8e3-4403-a4ac-311ed81204d1_SESS_e9fbefb3-e2af-4fe4-ac5f-0495636df2cc_TOSC_30d758b6-ddfe-4e9e-8a14-4e24d25340f8_ZIP_','2022-10-03 09:54:42','2022-09-28 10:25:04','3_w1_o1_maxillaire_scan_file_0.zip','2022-10-03 11:54:42','SYNCED','83f70326-23c7-4dbf-9860-8381656dc944',0,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993','{\"displayTitle\":\"Maxillaire 1.3.1.1.6\",\"modelMatrix\":\"-0.828998,0.447288,-0.335701,0,-0.559251,-0.663032,0.497622,0,-8.3229e-09,0.600269,0.799798,0,18.97,-5.74566,-17.7227,1\",\"title\":\"Maxillaire ZIP\"}'),(1070,'871dac18-caf7-4512-ad99-8286e63acba8','','ZIP','PATIENT_959e5762-b4e5-4295-a332-8a831a0fbf4a_ACT_3a07530a-c8e3-4403-a4ac-311ed81204d1_SESS_e9fbefb3-e2af-4fe4-ac5f-0495636df2cc_TOSC_3433b381-75f3-4923-a597-d5a8ae24ecfc_ZIP_','2022-09-28 10:20:14','2022-09-28 09:52:56','',NULL,'CREATED','871dac18-caf7-4512-ad99-8286e63acba8',0,'2022-09-28 12:20:14','ff8a242d-bd49-4bed-a171-ee187c282fc0','ff8a242d-bd49-4bed-a171-ee187c282fc0','{\"displayTitle\":\"Maxillaire 1.3.1.1.2\",\"modelMatrix\":\"0.38359,-0.891401,0.241375,0,0.923503,0.370256,-0.100259,0,-1.68184e-09,0.261369,0.965239,0,7.27518,-0.903465,-15.2348,1\",\"title\":\"Maxillaire ZIP\"}'),(1070,'903be239-1532-467c-b347-3dbedcddd39c','/var/.data/2022/ff8a242d-bd49-4bed-a171-ee187c282fc0/e0f46c84-c106-4642-bfeb-a5b36b5820ae/session_73bcc057-45f9-4b30-beee-c755ad473b8b/occlusion_d3b06f3d-a4b5-4db4-81f7-39b33c210472/scan_87171523-80e9-4f42-a13e-91213d9fba55/9_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_e0f46c84-c106-4642-bfeb-a5b36b5820ae_ACT_73bcc057-45f9-4b30-beee-c755ad473b8b_SESS_d3b06f3d-a4b5-4db4-81f7-39b33c210472_TOSC_87171523-80e9-4f42-a13e-91213d9fba55_SNAPS_','2022-10-11 08:20:42','2022-10-11 10:19:07','9_w1_o1_maxillaire_snapshot_0.png','2022-10-11 10:20:42','SYNCED','903be239-1532-467c-b347-3dbedcddd39c',0,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993','{\"displayTitle\":\"Maxillaire 1.9.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1070,'93369612-fcc2-40f5-973b-2e25a1aad15f','/var/.data/2022/ff8a242d-bd49-4bed-a171-ee187c282fc0/959e5762-b4e5-4295-a332-8a831a0fbf4a/session_7a6d9986-071b-44b7-b838-56876454bad4/occlusion_3666e5c7-80c2-4717-8bcb-4635d69b4a96/scan_b9b9342b-1007-4281-a39d-27fce0f4ba30/3_w2_o1_mandibule_snapshot_0.png','SNAPS','PATIENT_959e5762-b4e5-4295-a332-8a831a0fbf4a_ACT_7a6d9986-071b-44b7-b838-56876454bad4_SESS_3666e5c7-80c2-4717-8bcb-4635d69b4a96_BOSC_b9b9342b-1007-4281-a39d-27fce0f4ba30_SNAPS_','2022-10-03 09:41:33','2022-09-28 11:57:55','3_w2_o1_mandibule_snapshot_0.png','2022-10-03 11:41:33','SYNCED','93369612-fcc2-40f5-973b-2e25a1aad15f',0,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993','{\"displayTitle\":\"Mandibule 1.3.2.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(1070,'96a9cd8f-c93d-469b-bc0f-b1f73f5ed48d','/var/.data/2022/ff8a242d-bd49-4bed-a171-ee187c282fc0/4ef31c58-7de3-427d-ae5c-24505cfef470/session_fdc3ebc0-c2b2-440e-bad8-5b030b506f78/occlusion_2209d1b9-4da1-4054-814c-5a760347d91d/scan_9a0912c7-d649-4d0a-bc0d-b26ae74ab1f4/6_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_4ef31c58-7de3-427d-ae5c-24505cfef470_ACT_fdc3ebc0-c2b2-440e-bad8-5b030b506f78_SESS_2209d1b9-4da1-4054-814c-5a760347d91d_TOSC_9a0912c7-d649-4d0a-bc0d-b26ae74ab1f4_SNAPS_','2022-10-05 14:19:17','2022-10-05 16:17:30','6_w1_o1_maxillaire_snapshot_0.png','2022-10-05 16:19:17','SYNCED','96a9cd8f-c93d-469b-bc0f-b1f73f5ed48d',0,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993','{\"displayTitle\":\"Maxillaire 1.6.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1070,'a471032c-be9c-41e2-867c-cdc2b0a0aacc','/var/.data/2022/ff8a242d-bd49-4bed-a171-ee187c282fc0/959e5762-b4e5-4295-a332-8a831a0fbf4a/session_7a6d9986-071b-44b7-b838-56876454bad4/occlusion_3666e5c7-80c2-4717-8bcb-4635d69b4a96/scan_311bf037-40e8-468f-8a4a-808858eebfc0/3_w2_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_959e5762-b4e5-4295-a332-8a831a0fbf4a_ACT_7a6d9986-071b-44b7-b838-56876454bad4_SESS_3666e5c7-80c2-4717-8bcb-4635d69b4a96_TOSC_311bf037-40e8-468f-8a4a-808858eebfc0_SNAPS_','2022-10-03 09:41:32','2022-09-28 12:04:59','3_w2_o1_maxillaire_snapshot_0.png','2022-10-03 11:41:32','SYNCED','a471032c-be9c-41e2-867c-cdc2b0a0aacc',0,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993','{\"displayTitle\":\"Maxillaire 1.3.2.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1070,'b182ab37-719d-4f9e-a021-5e3d36cbf4a9','/var/.data/2022/ff8a242d-bd49-4bed-a171-ee187c282fc0/e0f46c84-c106-4642-bfeb-a5b36b5820ae/session_73bcc057-45f9-4b30-beee-c755ad473b8b/occlusion_d3b06f3d-a4b5-4db4-81f7-39b33c210472/scan_87171523-80e9-4f42-a13e-91213d9fba55/9_w1_o1_maxillaire_scan_file_1.zip','ZIP','PATIENT_e0f46c84-c106-4642-bfeb-a5b36b5820ae_ACT_73bcc057-45f9-4b30-beee-c755ad473b8b_SESS_d3b06f3d-a4b5-4db4-81f7-39b33c210472_TOSC_87171523-80e9-4f42-a13e-91213d9fba55_ZIP_','2022-10-11 08:24:30','2022-10-11 10:24:22','9_w1_o1_maxillaire_scan_file_1.zip','2022-10-11 10:24:30','SYNCED','b31a604f-aad9-4b46-ae60-d0f8236024dc',1,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993','{\"displayTitle\":\"Maxillaire 1.9.1.1.1\",\"modelMatrix\":\"-0.999989,0.00469548,-0.000418206,0,-0.00471407,-0.996046,0.0887135,0,-4.51328e-12,0.0887144,0.996057,0,19.5477,-15.186,-20.2479,1\",\"title\":\"Maxillaire ZIP\"}'),(1070,'b2d0f595-cf10-4c2c-a0af-576b1acc91e1','','SNAPS','PATIENT_959e5762-b4e5-4295-a332-8a831a0fbf4a_ACT_3a07530a-c8e3-4403-a4ac-311ed81204d1_SESS_e9fbefb3-e2af-4fe4-ac5f-0495636df2cc_TOSC_3433b381-75f3-4923-a597-d5a8ae24ecfc_SNAPS_','2022-09-28 10:20:14','2022-09-28 09:52:56','',NULL,'CREATED','b2d0f595-cf10-4c2c-a0af-576b1acc91e1',0,'2022-09-28 12:20:14','ff8a242d-bd49-4bed-a171-ee187c282fc0','ff8a242d-bd49-4bed-a171-ee187c282fc0','{\"displayTitle\":\"Maxillaire 1.3.1.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1070,'b31a604f-aad9-4b46-ae60-d0f8236024dc','/var/.data/2022/ff8a242d-bd49-4bed-a171-ee187c282fc0/e0f46c84-c106-4642-bfeb-a5b36b5820ae/session_73bcc057-45f9-4b30-beee-c755ad473b8b/occlusion_d3b06f3d-a4b5-4db4-81f7-39b33c210472/scan_87171523-80e9-4f42-a13e-91213d9fba55/9_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_e0f46c84-c106-4642-bfeb-a5b36b5820ae_ACT_73bcc057-45f9-4b30-beee-c755ad473b8b_SESS_d3b06f3d-a4b5-4db4-81f7-39b33c210472_TOSC_87171523-80e9-4f42-a13e-91213d9fba55_ZIP_','2022-10-11 08:20:42','2022-10-11 10:19:08','9_w1_o1_maxillaire_scan_file_0.zip','2022-10-11 10:20:42','SYNCED','b31a604f-aad9-4b46-ae60-d0f8236024dc',0,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993','{\"displayTitle\":\"Maxillaire 1.9.1.1.1\",\"modelMatrix\":\"-0.979008,0.203109,-0.017009,0,-0.203819,-0.975594,0.0816994,0,6.44278e-10,0.0834512,0.996512,0,16.5942,-18.6664,-19.9574,1\",\"title\":\"Maxillaire ZIP\"}'),(1070,'b8a66c39-1515-46c0-a8a6-d91c5072c595','','ZIP','PATIENT_959e5762-b4e5-4295-a332-8a831a0fbf4a_ACT_3a07530a-c8e3-4403-a4ac-311ed81204d1_SESS_e9fbefb3-e2af-4fe4-ac5f-0495636df2cc_TOSC_b9f77799-d642-4773-a67d-d83f37e0c814_ZIP_','2022-09-28 10:20:18','2022-09-28 09:52:45','',NULL,'CREATED','b8a66c39-1515-46c0-a8a6-d91c5072c595',0,'2022-09-28 12:20:18','bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993','{\"displayTitle\":\"Maxillaire 1.3.1.1.1\",\"modelMatrix\":\"0.38359,-0.891401,0.241375,0,0.923503,0.370256,-0.100259,0,-1.68184e-09,0.261369,0.965239,0,7.27518,-0.903465,-15.2348,1\",\"title\":\"Maxillaire ZIP\"}'),(1070,'c7b982b0-290e-4de0-8b65-2312e7e50d0a','/var/.data/2022/ff8a242d-bd49-4bed-a171-ee187c282fc0/959e5762-b4e5-4295-a332-8a831a0fbf4a/session_3a07530a-c8e3-4403-a4ac-311ed81204d1/occlusion_e9fbefb3-e2af-4fe4-ac5f-0495636df2cc/scan_7cf94db9-9efe-4581-b4a5-28fec7ee4559/3_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_959e5762-b4e5-4295-a332-8a831a0fbf4a_ACT_3a07530a-c8e3-4403-a4ac-311ed81204d1_SESS_e9fbefb3-e2af-4fe4-ac5f-0495636df2cc_TOSC_7cf94db9-9efe-4581-b4a5-28fec7ee4559_SNAPS_','2022-10-03 09:52:51','2022-09-28 09:57:35','3_w1_o1_maxillaire_snapshot_0.png','2022-10-03 11:52:51','SYNCED','c7b982b0-290e-4de0-8b65-2312e7e50d0a',0,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993','{\"displayTitle\":\"Maxillaire 1.3.1.1.5\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1070,'d014d1ea-ae79-475d-879c-b4baa0fd0bb4','/var/.data/2022/ff8a242d-bd49-4bed-a171-ee187c282fc0/959e5762-b4e5-4295-a332-8a831a0fbf4a/session_3a07530a-c8e3-4403-a4ac-311ed81204d1/occlusion_ea7ca0ea-51ca-4a55-8cf5-cfec2f762fa2/scan_c0b45e70-6cd8-404b-a997-a61d85ce9721/3_w1_o2_mandibule_snapshot_0.png','SNAPS','PATIENT_959e5762-b4e5-4295-a332-8a831a0fbf4a_ACT_3a07530a-c8e3-4403-a4ac-311ed81204d1_SESS_ea7ca0ea-51ca-4a55-8cf5-cfec2f762fa2_BOSC_c0b45e70-6cd8-404b-a997-a61d85ce9721_SNAPS_','2022-10-03 09:47:07','2022-09-28 12:52:54','3_w1_o2_mandibule_snapshot_0.png','2022-10-03 11:47:07','SYNCED','d014d1ea-ae79-475d-879c-b4baa0fd0bb4',0,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993','{\"displayTitle\":\"Mandibule 1.3.1.2.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(1070,'d1137d2c-21ea-4b96-9cda-905c965b58a9','/var/.data/2022/ff8a242d-bd49-4bed-a171-ee187c282fc0/959e5762-b4e5-4295-a332-8a831a0fbf4a/session_3a07530a-c8e3-4403-a4ac-311ed81204d1/occlusion_ea7ca0ea-51ca-4a55-8cf5-cfec2f762fa2/scan_521bad12-deec-4508-b53a-7e46a707e6a8/3_w1_o2_mandibule_scan_file_0.zip','ZIP','PATIENT_959e5762-b4e5-4295-a332-8a831a0fbf4a_ACT_3a07530a-c8e3-4403-a4ac-311ed81204d1_SESS_ea7ca0ea-51ca-4a55-8cf5-cfec2f762fa2_BOSC_521bad12-deec-4508-b53a-7e46a707e6a8_ZIP_','2022-10-03 09:47:06','2022-09-28 12:39:33','3_w1_o2_mandibule_scan_file_0.zip','2022-10-03 11:47:06','SYNCED','d1137d2c-21ea-4b96-9cda-905c965b58a9',0,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993','{\"displayTitle\":\"Mandibule 1.3.1.2.1\",\"modelMatrix\":\"0.912433,-0.391244,0.119974,0,0.409226,0.87234,-0.267501,0,6.52231e-09,0.293174,0.956059,0,-6.73916,17.8151,-21.0892,1\",\"title\":\"Mandibule ZIP\"}'),(1070,'dfcd1aa1-f018-48b8-b0ee-4f8dec4766f3','/var/.data/2022/ff8a242d-bd49-4bed-a171-ee187c282fc0/959e5762-b4e5-4295-a332-8a831a0fbf4a/session_3a07530a-c8e3-4403-a4ac-311ed81204d1/occlusion_e9fbefb3-e2af-4fe4-ac5f-0495636df2cc/scan_7cf94db9-9efe-4581-b4a5-28fec7ee4559/3_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_959e5762-b4e5-4295-a332-8a831a0fbf4a_ACT_3a07530a-c8e3-4403-a4ac-311ed81204d1_SESS_e9fbefb3-e2af-4fe4-ac5f-0495636df2cc_TOSC_7cf94db9-9efe-4581-b4a5-28fec7ee4559_ZIP_','2022-10-03 09:48:46','2022-09-28 09:57:36','3_w1_o1_maxillaire_scan_file_0.zip','2022-10-03 11:48:46','SYNCED','dfcd1aa1-f018-48b8-b0ee-4f8dec4766f3',0,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993','{\"displayTitle\":\"Maxillaire 1.3.1.1.5\",\"modelMatrix\":\"-0.65776,0.59281,-0.46468,0,-0.753227,-0.517675,0.405785,0,1.29582e-08,0.616919,0.787027,0,0.614547,-30.8752,-12.6542,1\",\"title\":\"Maxillaire ZIP\"}'),(1070,'e42db71f-5f8f-48fe-927f-1c02f44ce74b','/var/.data/2022/ff8a242d-bd49-4bed-a171-ee187c282fc0/959e5762-b4e5-4295-a332-8a831a0fbf4a/session_3a07530a-c8e3-4403-a4ac-311ed81204d1/occlusion_e9fbefb3-e2af-4fe4-ac5f-0495636df2cc/scan_30d758b6-ddfe-4e9e-8a14-4e24d25340f8/3_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_959e5762-b4e5-4295-a332-8a831a0fbf4a_ACT_3a07530a-c8e3-4403-a4ac-311ed81204d1_SESS_e9fbefb3-e2af-4fe4-ac5f-0495636df2cc_TOSC_30d758b6-ddfe-4e9e-8a14-4e24d25340f8_SNAPS_','2022-10-03 09:48:46','2022-09-28 10:25:02','3_w1_o1_maxillaire_snapshot_0.png','2022-10-03 11:48:46','SYNCED','e42db71f-5f8f-48fe-927f-1c02f44ce74b',0,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993','{\"displayTitle\":\"Maxillaire 1.3.1.1.6\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1070,'eae18c2a-a124-494e-b74d-367ddd672894','','ZIP','PATIENT_959e5762-b4e5-4295-a332-8a831a0fbf4a_ACT_3a07530a-c8e3-4403-a4ac-311ed81204d1_SESS_e9fbefb3-e2af-4fe4-ac5f-0495636df2cc_TOSC_4d78c4e6-43de-4778-a97a-744a71ad8f47_ZIP_','2022-09-28 10:20:10','2022-09-28 09:52:56','',NULL,'CREATED','eae18c2a-a124-494e-b74d-367ddd672894',0,'2022-09-28 12:20:10','ff8a242d-bd49-4bed-a171-ee187c282fc0','ff8a242d-bd49-4bed-a171-ee187c282fc0','{\"displayTitle\":\"Maxillaire 1.3.1.1.3\",\"modelMatrix\":\"0.38359,-0.891401,0.241375,0,0.923503,0.370256,-0.100259,0,-1.68184e-09,0.261369,0.965239,0,7.27518,-0.903465,-15.2348,1\",\"title\":\"Maxillaire ZIP\"}'),(1070,'ed2dc359-0368-4546-be96-237419080291','/var/.data/2022/ff8a242d-bd49-4bed-a171-ee187c282fc0/e0f46c84-c106-4642-bfeb-a5b36b5820ae/session_73bcc057-45f9-4b30-beee-c755ad473b8b/occlusion_d3b06f3d-a4b5-4db4-81f7-39b33c210472/scan_87171523-80e9-4f42-a13e-91213d9fba55/9_w1_o1_maxillaire_scan_file_2.zip','ZIP','PATIENT_e0f46c84-c106-4642-bfeb-a5b36b5820ae_ACT_73bcc057-45f9-4b30-beee-c755ad473b8b_SESS_d3b06f3d-a4b5-4db4-81f7-39b33c210472_TOSC_87171523-80e9-4f42-a13e-91213d9fba55_ZIP_','2022-10-11 08:32:32','2022-10-11 10:32:25','9_w1_o1_maxillaire_scan_file_2.zip','2022-10-11 10:32:32','SYNCED','b31a604f-aad9-4b46-ae60-d0f8236024dc',2,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993','{\"displayTitle\":\"Maxillaire 1.9.1.1.1\",\"modelMatrix\":\"-0.999588,-0.0286441,0.00208468,0,0.0287199,-0.996951,0.0725567,0,1.56715e-11,0.0725866,0.997362,0,19.9315,-14.1558,-20.4871,1\",\"title\":\"Maxillaire ZIP\"}'),(1070,'ef72c69a-cbce-448c-b0d1-ed1482052bf7','','SNAPS','PATIENT_959e5762-b4e5-4295-a332-8a831a0fbf4a_ACT_7a6d9986-071b-44b7-b838-56876454bad4_SESS_3666e5c7-80c2-4717-8bcb-4635d69b4a96_TOSC_25167fd5-d99b-4723-9e78-c5acb6642934_SNAPS_','2022-09-28 09:41:44','2022-09-28 11:41:13','',NULL,'CREATED','ef72c69a-cbce-448c-b0d1-ed1482052bf7',0,'2022-09-28 11:41:44','bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993','{\"displayTitle\":\"Maxillaire 1.3.2.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'f01e9a2b-b7af-4333-905b-4804006558f1','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/43bfdd66-40e9-4024-8259-412b8743b170/session_d1b217f0-7ea8-4abe-8052-9d91aae0f74d/occlusion_bf6aab3b-87a2-40d8-88a0-1b221d68e62e/scan_31f454d0-a75f-4f4e-a3a4-bfd0a475806a/3_w1_o1_maxillaire_snapshot_0.png','SNAPS','PATIENT_43bfdd66-40e9-4024-8259-412b8743b170_ACT_d1b217f0-7ea8-4abe-8052-9d91aae0f74d_SESS_bf6aab3b-87a2-40d8-88a0-1b221d68e62e_TOSC_31f454d0-a75f-4f4e-a3a4-bfd0a475806a_SNAPS_','2022-07-12 12:28:29','2022-07-12 14:28:29','3_w1_o1_maxillaire_snapshot_0.png',NULL,'CREATED','f01e9a2b-b7af-4333-905b-4804006558f1',0,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103','{\"displayTitle\":\"Maxillaire SNAPSHOT\",\"title\":\"Maxillaire SNAPSHOT\"}'),(1070,'f1ca63b0-423b-42b1-9293-fecb66f0c028','/var/.data/2022/ff8a242d-bd49-4bed-a171-ee187c282fc0/959e5762-b4e5-4295-a332-8a831a0fbf4a/session_7a6d9986-071b-44b7-b838-56876454bad4/occlusion_3666e5c7-80c2-4717-8bcb-4635d69b4a96/scan_3504d59a-bb7a-48ed-a241-cbf017371fe1/3_w2_o1_mordu_posterieur_droit_snapshot_0.png','SNAPS','PATIENT_959e5762-b4e5-4295-a332-8a831a0fbf4a_ACT_7a6d9986-071b-44b7-b838-56876454bad4_SESS_3666e5c7-80c2-4717-8bcb-4635d69b4a96_RISC_3504d59a-bb7a-48ed-a241-cbf017371fe1_SNAPS_','2022-10-03 09:41:33','2022-09-28 12:08:47','3_w2_o1_mordu_posterieur_droit_snapshot_0.png','2022-10-03 11:41:33','SYNCED','f1ca63b0-423b-42b1-9293-fecb66f0c028',0,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993','{\"displayTitle\":\"Mordu posterieur droit 1.3.2.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}'),(1070,'f5d1f38f-62c0-465e-8172-9c84cedbcacf','/var/.data/2022/ff8a242d-bd49-4bed-a171-ee187c282fc0/1ddf5934-ea4d-477a-9ec0-1d9144b1467d/session_8532a281-c902-48f3-94fd-a2a4f4101fb7/occlusion_ce4d3ca4-dc3a-46cb-aa8a-108d7be41a7f/scan_36baf7e7-c8ea-4a9d-a7b2-703b4c4491db/5_w1_o1_maxillaire_scan_file_0.zip','ZIP','PATIENT_1ddf5934-ea4d-477a-9ec0-1d9144b1467d_ACT_8532a281-c902-48f3-94fd-a2a4f4101fb7_SESS_ce4d3ca4-dc3a-46cb-aa8a-108d7be41a7f_TOSC_36baf7e7-c8ea-4a9d-a7b2-703b4c4491db_ZIP_','2022-10-05 14:12:48','2022-10-04 16:03:29','5_w1_o1_maxillaire_scan_file_0.zip','2022-10-05 16:12:48','SYNCED','f5d1f38f-62c0-465e-8172-9c84cedbcacf',0,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993','{\"displayTitle\":\"Maxillaire 1.5.1.1.1\",\"modelMatrix\":\"-0.411413,0.892983,-0.18254,0,-0.911449,-0.403078,0.0823954,0,-5.51622e-09,0.200274,0.97974,0,28.2121,-6.72873,-13.2155,1\",\"title\":\"Maxillaire ZIP\"}');
/*!40000 ALTER TABLE `CondorFile` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `CondorFile_BEFORE_DELETE` BEFORE DELETE ON `CondorFile` FOR EACH ROW BEGIN
  UPDATE Session SET mandibuleOcclusionPlyID = NULL
  WHERE ownerID = OLD.ownerID AND mandibuleOcclusionPlyID = OLD.id;

  UPDATE Session SET mandibuleOcclusionStlID = NULL
  WHERE ownerID = OLD.ownerID AND mandibuleOcclusionStlID = OLD.id;

  UPDATE Session SET maxillaireOcclusionPlyID = NULL
  WHERE ownerID = OLD.ownerID AND maxillaireOcclusionPlyID = OLD.id;

  UPDATE Session SET maxillaireOcclusionStlID = NULL
  WHERE ownerID = OLD.ownerID AND maxillaireOcclusionStlID = OLD.id;

  UPDATE Session SET mandibuleOcclusionPointContactID = NULL
  WHERE ownerID = OLD.ownerID AND mandibuleOcclusionPointContactID = OLD.id;

  UPDATE Session SET maxillaireOcclusionPointContactID = NULL
  WHERE ownerID = OLD.ownerID AND maxillaireOcclusionPointContactID = OLD.id;

  UPDATE Session SET matrixTransformationMandibuleID = NULL
  WHERE ownerID = OLD.ownerID AND matrixTransformationMandibuleID = OLD.id;

  UPDATE Session SET matrixTransformationMaxillaireID = NULL
  WHERE ownerID = OLD.ownerID AND matrixTransformationMaxillaireID = OLD.id;

  UPDATE Session SET snapshotID = NULL
  WHERE ownerID = OLD.ownerID AND snapshotID = OLD.id;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `Config`
--

DROP TABLE IF EXISTS `Config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Config` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `fullRetrieve` tinyint(1) DEFAULT '0',
  `syncEnabled` tinyint(1) DEFAULT '1',
  `showOcclusionScan` tinyint(1) DEFAULT '1',
  `showOpenStlWarning` tinyint(1) DEFAULT '1',
  `showMarginLinesWarning` tinyint(1) DEFAULT '1',
  `showDeleteConfirmation` tinyint(1) DEFAULT '1',
  `showSyncInfo` tinyint(1) DEFAULT '1',
  `downloadAtFullRetrieve` tinyint(1) DEFAULT '1',
  `lagSound` tinyint(1) DEFAULT '0',
  `lostSound` tinyint(1) DEFAULT '0',
  `emailNotifications` tinyint(1) DEFAULT '1',
  `logout` mediumint DEFAULT '10',
  `language` varchar(2) DEFAULT NULL,
  `flipMaxillaryH` tinyint(1) DEFAULT '0',
  `flipMaxillaryV` tinyint(1) DEFAULT '0',
  `flipMandibleH` tinyint(1) DEFAULT '0',
  `flipMandibleV` tinyint(1) DEFAULT '0',
  `showFlipPopupMaxillary` tinyint(1) DEFAULT '1',
  `showFlipPopupMandible` tinyint(1) DEFAULT '1',
  `enableUserSharing` tinyint(1) DEFAULT '1',
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `diagnosticMode` tinyint(1) DEFAULT '0',
  `repairMode` tinyint(1) DEFAULT '0',
  `lostTrackingRectangle` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Config_Professional` (`ownerID`),
  CONSTRAINT `fk_Config_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Config`
--

LOCK TABLES `Config` WRITE;
/*!40000 ALTER TABLE `Config` DISABLE KEYS */;
INSERT INTO `Config` VALUES (1,1,0,1,1,1,1,1,1,1,1,1,1,10,'fr',0,0,0,0,1,1,0,'2022-06-21 09:44:19','2022-06-21 07:44:19','2022-06-21 09:44:19',0,0,1),(2,1,0,1,1,1,1,1,1,0,0,0,1,999,'fr',0,0,0,0,1,1,0,'2022-07-12 14:26:52','2022-07-12 12:26:52','2022-07-12 14:26:51',0,0,1),(3,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2022-06-10 14:10:15','2022-06-10 12:10:15','2022-06-10 14:10:14',0,0,1),(5,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-07-02 11:04:44',0,0,1),(6,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-07-02 11:05:21',0,0,1),(7,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-07-02 11:06:14',0,0,1),(8,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-07-02 11:06:33',0,0,1),(9,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-07-02 11:07:02',0,0,1),(28,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-07-15 10:57:02',0,0,1),(33,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-07-15 14:34:40',0,0,1),(59,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-07-17 14:12:08',0,0,1),(155,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-07-31 12:21:56',0,0,1),(172,1,0,1,1,1,1,1,1,1,0,0,1,999,'fr',0,0,0,0,1,1,0,'2020-06-03 19:03:54','2020-06-03 17:03:54','2020-06-03 18:59:46',0,0,1),(177,1,0,1,1,1,1,1,1,1,0,0,1,990,'fr',0,0,0,0,1,1,0,'2021-03-05 17:04:59','2021-03-05 16:04:59','2021-03-05 17:04:59',0,0,1),(193,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-09-02 18:53:02',0,0,1),(224,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-09-09 15:29:44',0,0,1),(317,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-10-07 14:44:35',0,0,1),(339,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-10-11 20:04:31',0,0,1),(355,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-10-19 13:58:38',0,0,1),(375,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2020-01-02 14:50:32','2020-01-02 13:50:32','2020-01-02 14:50:31',0,0,1),(377,1,0,1,1,1,1,1,1,1,0,1,1,999,'fr',0,0,0,0,1,1,0,'2020-01-17 09:59:06','2020-01-17 08:59:06','2020-01-17 09:59:06',0,0,1),(421,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2019-12-15 22:02:47','2019-12-15 21:02:47','2019-11-25 11:28:35',0,0,1),(568,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2020-02-04 15:19:02','2020-02-04 14:19:02','2020-02-04 15:19:02',0,0,1),(652,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2020-03-12 14:49:16','2020-03-12 13:49:16','2020-03-12 14:49:16',0,0,1),(664,1,0,1,1,1,1,1,1,1,0,0,1,30,'fr',0,0,0,0,1,1,0,'2022-06-22 17:47:59','2022-06-22 15:47:59','2022-06-22 17:47:58',0,0,1),(681,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2020-05-29 09:10:28','2020-05-29 07:10:28','2020-05-29 09:10:28',0,0,1),(689,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2020-06-02 12:32:01','2020-06-02 10:32:01','2020-06-02 12:32:01',0,0,1),(722,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2020-07-28 20:37:10','2020-07-28 18:37:10','2020-07-28 20:37:09',0,0,1),(805,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2020-12-09 11:04:54','2020-12-09 10:04:54','2020-12-09 11:04:54',0,0,1),(838,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2021-01-22 14:37:07','2021-01-22 13:37:07','2021-01-22 14:37:07',0,0,1),(840,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2021-01-22 16:28:38','2021-01-22 15:28:38','2021-01-22 16:28:38',0,0,1),(850,1,0,1,1,1,1,1,1,1,0,0,1,999,'fr',0,0,0,0,1,1,0,'2022-06-21 09:47:07','2022-06-21 07:47:07','2022-06-21 09:47:06',0,0,1),(899,1,0,1,1,1,1,1,1,1,0,0,1,15,'fr',0,0,0,0,1,1,0,'2022-02-01 14:03:05','2022-02-01 13:03:05','2022-02-01 14:03:04',0,0,1),(916,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2021-04-28 14:05:53','2021-04-28 12:05:53','2021-04-28 14:05:53',0,0,1),(917,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2021-04-28 14:53:31','2021-04-28 12:53:31','2021-04-28 14:53:31',0,0,1),(918,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2021-04-29 16:03:23','2021-04-29 14:03:23','2021-04-29 16:03:23',0,0,1),(941,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2021-06-07 14:52:03','2021-06-07 12:52:03','2021-06-07 14:52:03',0,0,1),(1055,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2022-06-17 17:21:32','2022-06-17 15:21:32','2022-06-17 17:21:32',0,0,1),(1070,1,0,1,1,1,1,1,1,0,0,1,1,10,'fr',0,0,0,0,1,1,0,'2022-10-10 15:34:40','2022-10-10 13:34:40','2022-10-10 10:19:22',0,0,1),(1071,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,1,1,0,'2022-07-21 16:25:09','2022-07-21 14:25:09','2022-07-21 16:25:09',0,0,1);
/*!40000 ALTER TABLE `Config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Contact`
--

DROP TABLE IF EXISTS `Contact`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Contact` (
  `ownerID` mediumint unsigned NOT NULL DEFAULT '0',
  `id` char(36) NOT NULL,
  `comments` text,
  `professionalID` mediumint unsigned NOT NULL,
  `officeID` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `status` enum('invitationSent','invitationReceived','accepted','rejected') DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  UNIQUE KEY `unique_contact_pro` (`ownerID`,`professionalID`),
  KEY `fk_Contact_Professionnal` (`ownerID`),
  KEY `fk_Contact_RefersTo` (`professionalID`),
  KEY `fk_Contact_Office` (`officeID`,`ownerID`),
  CONSTRAINT `fk_Contact_Office` FOREIGN KEY (`officeID`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Contact_Professionnal` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Contact_RefersTo` FOREIGN KEY (`professionalID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Contact`
--

LOCK TABLES `Contact` WRITE;
/*!40000 ALTER TABLE `Contact` DISABLE KEYS */;
INSERT INTO `Contact` VALUES (2,'09445c09-6813-4c02-a2d8-597e200f19d6','',918,NULL,NULL,'2021-04-30 12:00:26','2021-04-30 10:00:26','2021-04-29 16:19:15','rejected'),(2,'13b7bc85-543d-4b72-98de-8a1c59d6d91b','',177,NULL,NULL,'2021-11-12 14:01:56','2021-11-12 13:01:56','2021-09-22 10:20:35','rejected'),(2,'1418b81b-952d-4c95-a6be-d74e9dce3146','',5,NULL,NULL,'2021-04-21 14:26:48','2021-04-21 12:26:48','2019-07-08 15:47:14','accepted'),(1070,'18c82251-53ed-4e33-8982-13237dbec1c2','',7,NULL,NULL,'2022-07-21 10:05:05','2022-07-21 08:05:05','2022-07-21 10:05:05','accepted'),(1070,'207bb3e6-8139-4526-bf4b-e22aaada8b7a','',6,NULL,NULL,'2022-07-21 10:05:05','2022-07-21 08:05:05','2022-07-21 10:05:05','accepted'),(2,'24f6b3ed-92f7-4ac3-90af-eca51269434c','',838,NULL,NULL,'2021-04-29 16:19:16','2021-04-29 14:19:16','2021-04-29 16:19:16','rejected'),(2,'28f7e34e-d2d9-411c-8ab3-d5ade71bf7cf','',6,NULL,NULL,'2019-07-26 06:43:50','2019-07-26 04:43:50','2019-07-08 15:47:14','accepted'),(2,'2e81aef5-1f9f-4961-ac42-12a07a248174','',899,NULL,NULL,'2022-06-18 13:30:59','2022-06-18 11:30:59','2021-10-12 14:15:29','invitationSent'),(2,'31ecedea-a5d4-4c31-91a1-431f8ab24ce7','',7,NULL,NULL,'2019-07-22 17:07:13','2019-07-22 15:07:13','2019-07-10 08:55:28','accepted'),(2,'3f1e8647-e9a2-47dd-912c-d07a3ec2395e','',689,NULL,NULL,'2020-11-03 11:22:16','2020-11-03 10:22:16','2020-11-03 11:22:16','accepted'),(2,'46be3f53-48f5-43f2-8612-6bde541a8563','',3,NULL,NULL,'2022-06-10 14:11:40','2022-06-10 12:11:40','2019-07-03 09:49:55','accepted'),(1070,'4c418310-b63e-4be6-b03a-107dfe02a3f9','',1070,NULL,NULL,'2022-10-13 10:23:30','2022-10-13 08:23:30','2022-07-21 10:05:05','accepted'),(2,'58cd65c8-f596-48dc-a3e8-edf285a261d0','',355,NULL,NULL,'2020-07-10 10:30:44','2020-07-10 08:30:44','2020-02-12 11:06:25','accepted'),(2,'5a6cbc1d-3301-430e-a148-dacf698e04c1','',917,NULL,NULL,'2021-04-29 16:00:34','2021-04-29 14:00:34','2021-04-29 16:00:34','rejected'),(2,'7072c8ee-9f1e-4c66-b352-fdcadde0179f','',681,NULL,NULL,'2021-01-22 14:02:32','2021-01-22 13:02:32','2021-01-22 14:02:31','invitationSent'),(2,'70dd62c9-f43b-4878-a303-d6ef02077da6','',28,NULL,NULL,'2021-07-19 20:03:49','2021-07-19 18:03:49','2021-03-18 16:09:12','accepted'),(2,'7bfba8d7-dea9-4a5f-8929-13f2e61c1e5f','',722,NULL,NULL,'2022-03-14 16:16:00','2022-03-14 15:16:00','2022-03-14 16:16:00','accepted'),(2,'845121ab-bd3d-460f-8459-afc674d99362','',8,NULL,NULL,'2019-07-22 19:36:25','2019-07-22 17:36:25','2019-07-08 15:47:14','accepted'),(2,'8cbeba91-0f78-43e6-9ac8-00c828dc7b11','',375,NULL,NULL,'2022-05-23 19:20:34','2022-05-23 17:20:34','2020-02-04 14:48:36','accepted'),(2,'93ad4d00-b810-418e-ab4f-5f38046486cd','',1,NULL,NULL,'2022-06-21 09:44:25','2022-06-21 07:44:25','2019-11-25 11:21:43','accepted'),(2,'9648ff49-e522-44ba-9b8f-93895ee57d2b','',224,NULL,NULL,'2019-09-09 15:53:45','2019-09-09 13:53:45','2019-09-09 15:53:45','accepted'),(2,'99c73d5d-e50b-4a8e-a4b4-60fd2150b020','',317,NULL,NULL,'2020-06-15 15:54:53','2020-06-15 13:54:53','2019-12-09 11:58:51','accepted'),(2,'a0328b57-7e5d-4cd5-bc41-fb03b3636761','',1055,NULL,NULL,'2022-06-17 17:28:41','2022-06-17 15:28:41','2022-06-17 17:21:32','invitationSent'),(2,'a2cd44fa-b826-4e8a-99ce-1512ee17ddad','',664,NULL,NULL,'2022-06-27 22:14:11','2022-06-27 20:14:11','2022-04-14 15:16:05','rejected'),(2,'a55f3306-73a9-4861-b3fe-1b6011c849be','',941,NULL,NULL,'2021-06-07 14:56:56','2021-06-07 12:56:56','2021-06-07 14:56:56','rejected'),(2,'a6c317c0-5772-4c0a-9fa8-0cef815f4fad','',193,NULL,NULL,'2019-09-30 10:43:33','2019-09-30 08:43:33','2019-09-30 10:43:33','accepted'),(2,'a88f9aab-189e-4afc-9061-d199ad98f624','',805,NULL,NULL,'2021-04-28 14:39:58','2021-04-28 12:39:58','2021-04-28 14:39:57','invitationSent'),(1070,'ad97b46a-45e0-42dc-9ee7-8c8cc6a24a84','',1071,NULL,NULL,'2022-07-21 16:25:12','2022-07-21 14:25:12','2022-07-21 16:25:09','invitationSent'),(2,'b26a32ea-ad6e-4f46-ae5d-f2f4a2af39ad','',155,NULL,NULL,'2020-07-01 10:29:24','2020-07-01 08:29:24','2019-08-27 15:24:41','accepted'),(2,'b29c282c-29a0-4337-bcae-a9998bf3da31','',916,NULL,NULL,'2021-04-28 14:07:51','2021-04-28 12:07:51','2021-04-28 14:07:50','rejected'),(2,'b4ad1a45-0211-4995-8543-ad852af15ce4','',568,NULL,NULL,'2020-02-04 15:20:30','2020-02-04 14:20:30','2020-02-04 15:19:02','invitationSent'),(2,'b6f285f2-0b59-4029-af8d-7e012de06045','',33,NULL,NULL,'2021-04-29 16:00:33','2021-04-29 14:00:33','2021-04-29 16:00:33','rejected'),(2,'be0d2da1-7bc2-4d9b-8280-6c727d2edfb6','',840,NULL,NULL,'2021-04-28 14:07:58','2021-04-28 12:07:58','2021-04-28 14:07:58','rejected'),(2,'c1218792-ad28-4579-b60d-ea36735880b7','',652,NULL,NULL,'2020-03-12 14:49:30','2020-03-12 13:49:30','2020-03-12 14:49:30','rejected'),(2,'c221cdda-dad2-4ee8-99ec-d3097c841b68','',850,NULL,NULL,'2022-07-12 14:28:22','2022-07-12 12:28:22','2021-03-04 12:12:18','invitationSent'),(2,'c571c887-8c1f-4576-a747-36c26c3f6338','',172,NULL,NULL,'2022-03-06 18:01:46','2022-03-06 17:01:46','2019-12-17 15:10:34','accepted'),(1070,'c5f79cfd-7597-40a2-940e-c1ea158a4785','',9,NULL,NULL,'2022-07-21 10:05:05','2022-07-21 08:05:05','2022-07-21 10:05:05','accepted'),(2,'c81b77de-6fb5-449b-8f09-78f75eedcd8c','',377,NULL,NULL,'2020-03-12 14:51:08','2020-03-12 13:51:08','2020-03-12 14:51:08','rejected'),(1070,'cbfcd1ba-fa48-4fab-8bc7-647e0fe4a1dd','',689,NULL,NULL,'2022-07-21 10:05:05','2022-07-21 08:05:05','2022-07-21 10:05:05','accepted'),(2,'d07578fc-3c54-49d7-a3eb-b581d2107f68','',2,NULL,NULL,'2022-07-12 14:28:30','2022-07-12 12:28:30','2019-07-01 08:54:35','accepted'),(2,'e72f7319-b4e1-4049-aa99-f124db5c5af8','',9,NULL,NULL,'2020-01-24 14:39:37','2020-01-24 13:39:37','2019-07-08 15:47:14','accepted'),(1070,'f46a85ac-f2d2-42ab-9d32-8021c41cdfa8','',5,NULL,NULL,'2022-07-21 10:05:05','2022-07-21 08:05:05','2022-07-21 10:05:05','accepted'),(2,'f4ec0f13-701b-4afa-bdc6-8759982358c2','',339,NULL,NULL,'2019-10-15 10:41:49','2019-10-15 08:41:49','2019-10-15 10:41:49','accepted'),(2,'f590073f-6720-4045-807a-0a3b1ea8c91d','',421,NULL,NULL,'2021-05-03 12:01:37','2021-05-03 10:01:37','2021-05-03 11:13:01','accepted'),(2,'fb3b468c-a371-4911-b472-a2869911ccef','',59,NULL,NULL,'2019-09-05 17:29:34','2019-09-05 15:29:34','2019-09-05 17:20:56','accepted'),(1070,'fc33821e-5f45-4e2a-90f8-f6d6dbd432b6','',8,NULL,NULL,'2022-07-21 10:05:05','2022-07-21 08:05:05','2022-07-21 10:05:05','accepted');
/*!40000 ALTER TABLE `Contact` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ContactNotification`
--

DROP TABLE IF EXISTS `ContactNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ContactNotification` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `contactID` char(36) DEFAULT NULL,
  `rescueDisplayName` varchar(50) DEFAULT NULL,
  `event` enum('received','received_to_accepted','received_to_rejected','sent_to_accepted','sent_to_rejected','activation_timeout') NOT NULL DEFAULT 'received',
  `unread` tinyint(1) NOT NULL DEFAULT '1',
  `createdAt` datetime NOT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_ContactNotification_Professional` (`ownerID`),
  KEY `fk_ContactNotification_Contact` (`contactID`,`ownerID`),
  CONSTRAINT `fk_ContactNotification_Contact` FOREIGN KEY (`contactID`, `ownerID`) REFERENCES `Contact` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_ContactNotification_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ContactNotification`
--

LOCK TABLES `ContactNotification` WRITE;
/*!40000 ALTER TABLE `ContactNotification` DISABLE KEYS */;
/*!40000 ALTER TABLE `ContactNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Credentials`
--

DROP TABLE IF EXISTS `Credentials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Credentials` (
  `id` char(36) NOT NULL DEFAULT '',
  `login` varchar(64) NOT NULL,
  `password` varchar(100) DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `un_Login` (`login`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Credentials`
--

LOCK TABLES `Credentials` WRITE;
/*!40000 ALTER TABLE `Credentials` DISABLE KEYS */;
INSERT INTO `Credentials` VALUES ('00000002-0000-0000-0000-000000000001','prod.sav','42adacbb60e86b5b5b63ea4fb9acc56aec15bf966e1cdeffa5d89c176892e8cf',NULL,'2022-07-12 12:26:46'),('0c1df5f3-d1f7-47cf-8ef2-6256c08b396a','BELODENTO60','7f88bc9025d1f84de50d7d43a557d8de8ceb8b73490233d904e5d3238d029c4c',NULL,'2022-10-13 08:23:28'),('601c3968-b0ac-4247-9552-d9c1fba94fe8','sandrams@odento.fr','516e84710c58f64c1394eb85b887286bda5c6b39ecb5f4d22ccb4811f9f10a83',NULL,'2022-10-13 07:18:49');
/*!40000 ALTER TABLE `Credentials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Discussion`
--

DROP TABLE IF EXISTS `Discussion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Discussion` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `selfImplied` tinyint(1) NOT NULL DEFAULT '0',
  `officeID` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Discussion_Professional` (`ownerID`),
  KEY `fk_Discussion_Office` (`officeID`,`ownerID`),
  CONSTRAINT `fk_Discussion_Office` FOREIGN KEY (`officeID`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Discussion_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Discussion`
--

LOCK TABLES `Discussion` WRITE;
/*!40000 ALTER TABLE `Discussion` DISABLE KEYS */;
INSERT INTO `Discussion` VALUES (1,'3bb3ca53-cf49-4698-9658-df729e5c5f9e',0,NULL,NULL,NULL,'2021-06-24 13:46:36','2021-06-24 15:46:36'),(2,'3bb3ca53-cf49-4698-9658-df729e5c5f9e',0,NULL,NULL,'2022-01-04 18:22:05','2022-01-04 17:22:05','2019-11-25 11:23:31'),(2,'521142fd-7283-4541-aa70-733ace90c112',0,NULL,NULL,'2021-05-14 13:25:24','2021-05-14 11:25:24','2019-09-04 15:44:10'),(3,'521142fd-7283-4541-aa70-733ace90c112',0,NULL,NULL,NULL,'2021-06-24 13:46:36','2021-06-24 15:46:36'),(2,'5cde9543-ba84-400d-ae2b-8c834d912266',0,NULL,NULL,'2021-02-12 15:21:28','2021-02-12 14:21:28','2019-12-17 15:11:56'),(172,'5cde9543-ba84-400d-ae2b-8c834d912266',0,NULL,NULL,NULL,'2021-06-24 13:46:36','2021-06-24 15:46:36'),(2,'6885f3a8-c779-49e9-87ed-5d4c70e2ca06',0,NULL,NULL,'2019-09-30 17:16:23','2019-09-30 15:16:23','2019-09-30 11:17:48'),(193,'6885f3a8-c779-49e9-87ed-5d4c70e2ca06',0,NULL,NULL,NULL,'2021-06-24 13:46:36','2021-06-24 15:46:36'),(2,'a16198e0-da2f-45fe-97fb-93531b35cedb',1,NULL,NULL,'2022-06-01 10:42:46','2022-06-01 08:42:46','2019-07-01 17:37:26'),(2,'a18a6dc8-e71f-45cb-a7ad-b53500079bd4',0,NULL,NULL,'2019-09-12 16:13:26','2019-09-12 14:13:26','2019-09-09 16:10:00'),(224,'a18a6dc8-e71f-45cb-a7ad-b53500079bd4',0,NULL,NULL,NULL,'2021-06-24 13:46:36','2021-06-24 15:46:36'),(2,'bdbff1f6-a77b-4ed9-8b95-fb64078e6edc',0,NULL,NULL,'2022-03-14 16:17:11','2022-03-14 15:17:11','2022-03-14 16:17:00'),(722,'bdbff1f6-a77b-4ed9-8b95-fb64078e6edc',0,NULL,NULL,NULL,'2022-07-12 12:26:52','2022-07-12 14:26:52'),(2,'be6e41b9-9ce8-4980-9ce7-be4b4450d1b3',0,NULL,NULL,'2022-04-29 14:50:48','2022-04-29 12:50:48','2019-09-05 17:30:24'),(59,'be6e41b9-9ce8-4980-9ce7-be4b4450d1b3',0,NULL,NULL,NULL,'2021-06-24 13:46:36','2021-06-24 15:46:36'),(2,'fe55386a-3ec2-4d00-bb80-02e0aec5e82f',0,NULL,NULL,'2019-09-03 10:19:11','2019-09-03 08:19:11','2019-08-27 15:25:58'),(155,'fe55386a-3ec2-4d00-bb80-02e0aec5e82f',0,NULL,NULL,NULL,'2021-06-24 13:46:36','2021-06-24 15:46:36');
/*!40000 ALTER TABLE `Discussion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Licence`
--

DROP TABLE IF EXISTS `Licence`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Licence` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `reference` varchar(45) DEFAULT NULL,
  `installKey` varchar(45) DEFAULT NULL,
  `activationDate` datetime DEFAULT NULL,
  `professionalID` mediumint unsigned NOT NULL,
  `cameraReference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`,`professionalID`),
  KEY `fk_Licence_Professional` (`professionalID`),
  CONSTRAINT `fk_Licence_Professional` FOREIGN KEY (`professionalID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Licence`
--

LOCK TABLES `Licence` WRITE;
/*!40000 ALTER TABLE `Licence` DISABLE KEYS */;
/*!40000 ALTER TABLE `Licence` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `MessageStatus`
--

DROP TABLE IF EXISTS `MessageStatus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `MessageStatus` (
  `ownerID` mediumint unsigned NOT NULL,
  `sentMessageID` char(36) NOT NULL,
  `contactID` char(36) NOT NULL,
  `status` enum('undelivered','delivered','transmitted') NOT NULL DEFAULT 'undelivered',
  `bcc` tinyint(1) NOT NULL DEFAULT '0',
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`sentMessageID`,`contactID`),
  KEY `fk_MessageStatus_SentMessage` (`sentMessageID`,`ownerID`),
  KEY `fk_MessageStatus_Contact` (`contactID`,`ownerID`),
  CONSTRAINT `fk_MessageStatus_Contact` FOREIGN KEY (`contactID`, `ownerID`) REFERENCES `Contact` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_MessageStatus_SentMessage` FOREIGN KEY (`sentMessageID`, `ownerID`) REFERENCES `SentMessage` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `MessageStatus`
--

LOCK TABLES `MessageStatus` WRITE;
/*!40000 ALTER TABLE `MessageStatus` DISABLE KEYS */;
/*!40000 ALTER TABLE `MessageStatus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Occlusion`
--

DROP TABLE IF EXISTS `Occlusion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Occlusion` (
  `ownerID` mediumint unsigned NOT NULL DEFAULT '0',
  `id` char(36) NOT NULL,
  `sessionID` char(36) DEFAULT NULL,
  `occlusionType` enum('UNKNOWN','HEMI_ARCADE_POSTERIEUR_DROIT','HEMI_ARCADE_POSTERIEUR_GAUCHE','HEMI_ARCADE_ANTERIEUR','ARCADE_COMPLETE_ANTERIEUR','ARCADE_COMPLETE') DEFAULT 'HEMI_ARCADE_POSTERIEUR_DROIT',
  `deletedAt` datetime DEFAULT NULL,
  `createdAt` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `topScanID` char(36) DEFAULT NULL,
  `bottomScanID` char(36) DEFAULT NULL,
  `anteriorBiteScanID` char(36) DEFAULT NULL,
  `rightBiteScanID` char(36) DEFAULT NULL,
  `leftBiteScanID` char(36) DEFAULT NULL,
  `snapshotID` char(36) DEFAULT NULL,
  `mandibuleOcclusionPlyID` char(36) DEFAULT NULL,
  `maxillaireOcclusionPlyID` char(36) DEFAULT NULL,
  `matrixTransformationMandibuleID` char(36) DEFAULT NULL,
  `matrixTransformationMaxillaireID` char(36) DEFAULT NULL,
  `globalDisplayID` mediumint unsigned DEFAULT NULL,
  `displayID` mediumint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Occlusion_Session` (`sessionID`,`ownerID`),
  KEY `fk_Occlusion_topScan` (`topScanID`,`ownerID`),
  KEY `fk_Occlusion_bottomScan` (`bottomScanID`,`ownerID`),
  KEY `fk_Occlusion_anteriorBiteScanID` (`anteriorBiteScanID`,`ownerID`),
  KEY `fk_Occlusion_rightBiteScanID` (`rightBiteScanID`,`ownerID`),
  KEY `fk_Occlusion_leftBiteScanID` (`leftBiteScanID`,`ownerID`),
  KEY `fk_Occlusion_CondorFile_snapshot` (`snapshotID`,`ownerID`),
  KEY `fk_Occlusion_CondorFile_mandibulePly` (`mandibuleOcclusionPlyID`,`ownerID`),
  KEY `fk_Occlusion_CondorFile_matrixTransformationMandibule` (`matrixTransformationMandibuleID`,`ownerID`),
  KEY `fk_Occlusion_CondorFile_maxillairePly` (`maxillaireOcclusionPlyID`,`ownerID`),
  KEY `fk_Occlusion_CondorFile_matrixTransformationMaxillaire` (`matrixTransformationMaxillaireID`,`ownerID`),
  CONSTRAINT `fk_Occlusion_anteriorBiteScanID` FOREIGN KEY (`anteriorBiteScanID`, `ownerID`) REFERENCES `Scan` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_bottomScan` FOREIGN KEY (`bottomScanID`, `ownerID`) REFERENCES `Scan` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_CondorFile_mandibulePly` FOREIGN KEY (`mandibuleOcclusionPlyID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_CondorFile_matrixTransformationMandibule` FOREIGN KEY (`matrixTransformationMandibuleID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_CondorFile_matrixTransformationMaxillaire` FOREIGN KEY (`matrixTransformationMaxillaireID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_CondorFile_maxillairePly` FOREIGN KEY (`maxillaireOcclusionPlyID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_CondorFile_snapshot` FOREIGN KEY (`snapshotID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_leftBiteScanID` FOREIGN KEY (`leftBiteScanID`, `ownerID`) REFERENCES `Scan` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_rightBiteScanID` FOREIGN KEY (`rightBiteScanID`, `ownerID`) REFERENCES `Scan` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_Session` FOREIGN KEY (`sessionID`, `ownerID`) REFERENCES `Session` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Occlusion_topScan` FOREIGN KEY (`topScanID`, `ownerID`) REFERENCES `Scan` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Occlusion`
--

LOCK TABLES `Occlusion` WRITE;
/*!40000 ALTER TABLE `Occlusion` DISABLE KEYS */;
/*!40000 ALTER TABLE `Occlusion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `OcclusionFile`
--

DROP TABLE IF EXISTS `OcclusionFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `OcclusionFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `fileID` char(36) NOT NULL,
  `occlusionID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `occlusionType` enum('OCCLUSION_RESULT','MANDIBULE_PLY','MAXILLAIRE_PLY','LEFT_BITE','RIGHT_BITE','ANTERIOR_BITE','SCREENSHOT','LIFI','MANDIBULE_MATRIX','MAXILLAIRE_MATRIX') DEFAULT 'OCCLUSION_RESULT',
  PRIMARY KEY (`fileID`,`occlusionID`,`ownerID`),
  KEY `fk_OcclusionFile_CondorFile` (`fileID`,`ownerID`),
  KEY `fk_OcclusionFile_Occlusion` (`occlusionID`,`ownerID`),
  CONSTRAINT `fk_OcclusionFile_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_OcclusionFile_Occlusion` FOREIGN KEY (`occlusionID`, `ownerID`) REFERENCES `Occlusion` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `OcclusionFile`
--

LOCK TABLES `OcclusionFile` WRITE;
/*!40000 ALTER TABLE `OcclusionFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `OcclusionFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Office`
--

DROP TABLE IF EXISTS `Office`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Office` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `mainPhone` varchar(45) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `cityName` varchar(255) DEFAULT NULL,
  `cityZip` varchar(25) DEFAULT NULL,
  `address` text,
  `country` varchar(75) DEFAULT NULL,
  `reassignedTo` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Office_Professional_idx` (`ownerID`),
  KEY `fk_Office_Office_reassignedTo` (`reassignedTo`,`ownerID`),
  CONSTRAINT `fk_Office_Office_reassignedTo` FOREIGN KEY (`reassignedTo`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Office_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Office`
--

LOCK TABLES `Office` WRITE;
/*!40000 ALTER TABLE `Office` DISABLE KEYS */;
INSERT INTO `Office` VALUES (3,'07a4901a-a73e-414b-bafe-ff42d883049b','542138759','Condor','','Labège','31670','137 rue Garance','France',NULL,NULL,'2019-07-01 14:13:31','2019-07-01 12:13:31','2019-07-01 14:13:31'),(7,'12faf4c9-95d6-4c4f-b641-481c29111d9a','0664864059','DENTAL CUB','','MERIGNAC','33700','10 av jean mazaryck,','France',NULL,NULL,'2019-07-09 11:35:13','2019-07-09 09:35:13','2019-07-09 11:35:13'),(224,'179ab10a-4b77-4b31-a7c1-386f7e9d1cef','0660850205','Cabinet (default)','','LABEGE','','RUE GARANCE','France',NULL,NULL,'2019-09-09 15:36:36','2019-09-09 13:36:36','2019-09-09 15:36:36'),(33,'1968410e-356a-468d-9571-2a80bed10822','','Cabinet (default)','','','','','',NULL,NULL,'2019-07-15 14:34:40','2019-07-15 12:34:40','2019-07-15 14:34:40'),(918,'1bfbf5f0-617e-4681-9665-42e6063278dc','0142502324','Cabinet (default)','','Paris','','','France',NULL,NULL,'2021-04-29 16:05:22','2021-04-29 14:05:22','2021-04-29 16:03:23'),(377,'1d4a2a5f-e540-458c-9db2-a070d38387b7','437578841','cabinet dentaire place guichard','','LYON','69003','51 rue moncey','France',NULL,NULL,'2019-10-28 15:10:33','2019-10-28 14:10:33','2018-03-07 14:03:02'),(1071,'261b309e-4203-447f-a526-8c22bec4e5e2','','','','','','','',NULL,NULL,'2022-07-21 16:25:09','2022-07-21 14:25:09','2022-07-21 16:25:09'),(177,'27f156ab-dc42-4425-ae10-2443070d284b','660474450','BIOTECH','','LEGANES','28916','AVDA. JUAN CARAMUEL,1','España',NULL,NULL,'2019-08-26 11:09:47','2019-08-26 09:09:47','2019-08-26 11:09:47'),(840,'2c822df5-84aa-43f3-9549-f6136016045e','','Cabinet (default)','','','','','',NULL,NULL,'2021-01-22 16:28:38','2021-01-22 15:28:38','2021-01-22 16:28:38'),(355,'3d7661f6-e77c-493d-9c2d-45d83cac165e','+390521221362','GIANLUCA DALLATANA','www.uniontech.it','Parma','43122','Rocco Bormioli, 5/A','Italia',NULL,NULL,'2019-10-23 12:56:54','2019-10-23 10:56:54','2019-10-23 12:56:54'),(681,'41ba57f5-3de1-4a9c-b28c-4a17c7f8885f','0627204198','Cabinet (default)','','Chamalières ','','','France',NULL,NULL,'2020-06-02 22:16:29','2020-06-02 20:16:29','2020-05-29 09:10:29'),(850,'4778c062-a392-4a7a-9245-e0c304734aa7','0450943901','BOURDELLE','','BOEGE','74420','52 RUE DU BOURNO','France',NULL,NULL,'2021-02-01 14:49:44','2021-02-01 13:49:44','2021-02-01 14:49:44'),(838,'5212d490-e583-4634-b55a-d6698ab60fcf','','Cabinet (default)','','','','','',NULL,NULL,'2021-01-22 14:37:07','2021-01-22 13:37:07','2021-01-22 14:37:07'),(9,'544e3fb2-5e62-472f-b606-7185054c1396','0149698526','Laboratoire LDA','www.laboratoirelda.com','Villiers Sur Marne','94350','1 rue de la fraternité','France',NULL,NULL,'2019-07-02 11:36:03','2019-07-02 09:36:03','2019-07-02 11:36:03'),(916,'57d938bf-ab8f-4d46-b023-177d0f9591ea','','Cabinet (default)','','','','','',NULL,NULL,'2021-04-28 14:05:53','2021-04-28 12:05:53','2021-04-28 14:05:53'),(664,'59496d67-82f7-4828-86cd-392d0852da35','3015880768','Miles of Smiles Implant Dentistry','','Silver Spring','20910','801 Wayne Avenue, Suite G200','United States of America',NULL,NULL,'2022-05-26 20:50:07','2022-05-26 18:50:07','2022-05-26 20:50:06'),(172,'5d22dd41-4a03-4813-a2a3-86598c1101c0','0559830648','SELARL du Dr Franck LE BOURHIS','','LAROIN','64110','4 Chemin Couralis','France',NULL,NULL,'2019-08-19 17:44:04','2019-08-19 15:44:04','2019-01-21 17:43:09'),(339,'5e42d964-fa5c-4aac-b7ee-0cf0d98d7666','0659598581','Cabinet (default)','','Paris','','','France',NULL,NULL,'2019-10-15 10:41:09','2019-10-15 08:41:09','2019-10-11 20:04:31'),(155,'60100516-06c3-4737-a33b-8fba3b71bd66','0241437031','LEMOUEL SAS','www.laboratoire-lemouel.fr','ECOUFLANT','49000','22 BOULEVARD DE L INDUSTRIE, ZI ECOUFLANT','France',NULL,NULL,'2019-08-27 14:26:48','2019-08-27 12:26:48','2019-08-27 14:26:48'),(805,'6fc12d0b-3ff2-4acc-bdf3-e20c109a2c69','000000000','Scan4all','','Labege','31670','137 rue Garance','France',NULL,NULL,'2020-12-09 11:04:46','2020-12-09 10:04:46','2020-12-09 11:04:46'),(317,'8c4a7314-8b79-4f22-aeba-b48e799bb261','0382254814','Cabinet (default)','','LONGWY','','','France',NULL,NULL,'2019-12-09 11:58:34','2019-12-09 10:58:34','2019-10-07 14:44:35'),(652,'8dcd144c-a1e8-4ee1-86e3-68eeb19b8d6a','','Cabinet (default)','','','','','',NULL,NULL,'2020-03-12 14:49:16','2020-03-12 13:49:16','2020-03-12 14:49:16'),(1055,'99c0664c-eab4-4a4e-af99-98c7a20afb7f','0645024712','','','Labege','','','France',NULL,NULL,'2022-06-17 17:22:57','2022-06-17 15:22:57','2022-06-17 17:21:32'),(6,'a1984274-1ad9-41d4-b536-d4407f8fca00','0491776127','Cabinet (default)','','Marseille','','','France',NULL,NULL,'2019-07-07 06:24:25','2019-07-07 04:24:25','2019-07-02 11:05:21'),(917,'a631c201-cdb6-4682-bfab-0b15792820f5','','Cabinet (default)','','','','','',NULL,NULL,'2021-04-28 14:53:31','2021-04-28 12:53:31','2021-04-28 14:53:31'),(375,'a67878c9-0724-4c0b-b082-d252b2a443a0','142357044','Selarl Cabinet du Dr BOKOBZA','','Epinay sur Seine','93800','95, Avenue de la Marne','France',NULL,NULL,'2019-10-28 13:23:57','2019-10-28 12:23:57','2018-01-26 09:24:01'),(59,'ac14fa6c-ded0-4127-8d99-c18fee62921e','0475490647','Cabinet (default)','','LE TEIL','','','France',NULL,NULL,'2019-09-05 17:19:00','2019-09-05 15:19:00','2019-07-17 14:12:08'),(941,'b3b0ca74-a736-4743-a3f4-d7e5476a707a','','Cabinet (default)','','','','','',NULL,NULL,'2021-06-07 14:52:03','2021-06-07 12:52:03','2021-06-07 14:52:03'),(689,'b9db0008-e73d-4e5a-ac76-2c93df3250ae','04 79 26 15 66','Cabinet (default)','','CHAMBERY','73000','1 Place de la Libération','France',NULL,NULL,'2020-11-03 08:32:27','2020-11-03 07:32:27','2020-11-03 08:32:27'),(1,'bf407538-bec8-49af-b04a-68926a6b1a6e','123322332','Labege','','Labege','31670','Labege','France',NULL,NULL,'2019-06-28 18:00:23','2019-06-28 16:00:23','2019-06-28 18:00:23'),(8,'c54ab53e-cc43-42dd-a0f6-824b6dc657ad','0664143389','LABEL DENT','','MERIGNAC','','10 AV JAN MASARYK','France',NULL,NULL,'2019-07-22 16:59:15','2019-07-22 14:59:15','2019-07-22 16:59:15'),(1070,'ce5c9575-3e13-44d4-a543-61e770347bd6','0374951935','ODENTO COMPIEGNE','','COMPIEGNE','60200','4 RUE DES DOMELIERS','France',NULL,NULL,'2022-07-21 10:05:05','2022-07-21 08:05:05','2022-07-21 10:05:05'),(421,'da7eeae6-df32-400f-ae71-6f40ab17da2a','0142502324','Cabinet (default)','','PARIS','75017','109 rue Lemercier','France',NULL,NULL,'2021-05-03 11:17:11','2021-05-03 09:17:11','2021-05-03 11:17:11'),(899,'dbdc6c75-bf45-4e27-8a4b-89ff2d15213a','3388397462','LABORATORIO ODONTOTECNICO CIRO GHIDELLI S.N.C.','','CASERTA','81100','VIA E.TAZZOLI','Italia',NULL,NULL,'2021-04-03 11:51:29','2021-04-03 09:51:29','2021-04-03 11:51:29'),(193,'dc905db3-c0a3-44b2-a0f3-f3c08fdd6bb7','0663713747','Cabinet (default)','','VIRIAT ','','','France',NULL,NULL,'2019-09-05 21:11:53','2019-09-05 19:11:53','2019-09-02 18:53:02'),(5,'e563f7db-c71c-416d-a74d-2b979f6eade2','0388334408','LABORATOIRE DENTAL BIOTECH','https://laboratoire-labeldent.fr/','WOLFISHEIM','67202','5 impasse Joffre','France',NULL,NULL,'2021-04-21 14:26:48','2021-04-21 12:26:48','2021-04-21 14:26:48'),(722,'ee984970-dbfc-4218-ae19-4fadfaefad61','984157663','DENTAL TAPIA','','TAPIA','33740','PRACTICANTE ANTONIO ASTRAY 4 BAJO. ','España',NULL,NULL,'2020-06-30 18:05:49','2020-06-30 16:05:49','2020-06-30 18:05:49'),(568,'eef5f794-8bf3-4eae-8903-b87f4f171f1e','0102030405','Cabinet (default)','','Tlse','','','France',NULL,NULL,'2020-02-04 15:19:54','2020-02-04 14:19:54','2020-02-04 15:19:02'),(28,'f42c5519-fed3-4edd-81bb-22977bba879e','0437289392','Cabinet (default)','','lyon','','','France',NULL,NULL,'2019-07-18 14:19:16','2019-07-18 12:19:16','2019-07-15 10:57:02'),(2,'f841d3b8-276b-4ad1-859c-ba7e25ffe059','056139839','Scan4all','','LABEGE','31670','137 rue garance','France',NULL,NULL,'2021-04-28 16:09:09','2021-04-28 14:09:09','2021-04-28 16:09:09');
/*!40000 ALTER TABLE `Office` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `Office_BEFORE_DELETE` BEFORE DELETE ON `Office` FOR EACH ROW BEGIN		
  UPDATE Assistant SET officeID = NULL 
  WHERE ownerID = OLD.ownerID AND officeID = OLD.id;

  UPDATE Contact SET officeID = NULL 
  WHERE ownerID = OLD.ownerID AND officeID = OLD.id;

  UPDATE Discussion SET officeID = NULL 
  WHERE ownerID = OLD.ownerID AND officeID = OLD.id;

  UPDATE Patient SET officeID = NULL 
  WHERE ownerID = OLD.ownerID AND officeID = OLD.id;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `PersonInfo`
--

DROP TABLE IF EXISTS `PersonInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PersonInfo` (
  `id` char(36) NOT NULL COMMENT '(DC2Type:guid)',
  `firstName` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `sex` enum('M','F') DEFAULT NULL,
  `birthDate` date DEFAULT NULL,
  `salutation` varchar(45) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `picturePath` varchar(255) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PersonInfo`
--

LOCK TABLES `PersonInfo` WRITE;
/*!40000 ALTER TABLE `PersonInfo` DISABLE KEYS */;
INSERT INTO `PersonInfo` VALUES ('00000001-0000-0000-0000-000000000001','labege','SI','si@condorscan.pro','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000002-0000-0000-0000-000000000001','Sophie','MOURIGAL','sophie.mourigal@condorscan.pro','',NULL,'','','',NULL,NULL,'2022-04-27 07:49:43'),('00000003-0000-0000-0000-000000000001','c2w','prod-test','thomas.besson@condorscan.pro','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000005-0000-0000-0000-000000000001','Dental Biotech Strasbourg','Laboratoire','cfao@dentalbiotech.fr','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000006-0000-0000-0000-000000000001','Gilles','Philip','laboratoirephilip@yahoo.fr','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000007-0000-0000-0000-000000000001','DENTAL CUB','LABORATOIRE','cfao@dentalcub.fr','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000008-0000-0000-0000-000000000001','LABEL DENT','LABORATOIRE','label.dent@orange.fr','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000009-0000-0000-0000-000000000001','Laboratoire','LDA','cfao@laboratoirelda.com','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000028-0000-0000-0000-000000000001','clovis coulon','Laboratoire cdv','cdvscan@gmail.com','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000033-0000-0000-0000-000000000001','','','info@webert.fr','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000059-0000-0000-0000-000000000001','RIEUX  ','LABORATOIRE','laboratoire-rieux@orange.fr','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000155-0000-0000-0000-000000000001','LEMOUEL','LABORATOIRE','lemouel@aol.com','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000172-0000-0000-0000-000000000001','Franck','Dr LE BOURHIS','francklebourhis@gmail.com','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000177-0000-0000-0000-000000000001','OLIVA','VERONICA','v.oliva@biotech-dental.com','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000193-0000-0000-0000-000000000001','ADT Prothèses Dentaires','Laboratoire ','taponard.sebastien@yahoo.fr','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000224-0000-0000-0000-000000000001','Muriel','LIMONDIN','muriel.limondin@condorscan.pro','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000317-0000-0000-0000-000000000001','Herblot Moreau','Laboratoire','contact@ldhm.fr','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000339-0000-0000-0000-000000000001','Léopold','Lanne','prod@3dcelo.com','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000355-0000-0000-0000-000000000001','GIANLUCA','DALLATANA','gianluca@uniontech.it','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000375-0000-0000-0000-000000000001','LAURENT','BOKOBZA','doc.boko@wanadoo.fr','',NULL,'','','',NULL,NULL,'2022-05-05 13:47:55'),('00000377-0000-0000-0000-000000000001','place guichard','cabinet','cabinetdentaireplaceguichard@gmail.com','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000421-0000-0000-0000-000000000001','Webert','Laboratoire','numerique@webert.fr','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000568-0000-0000-0000-000000000001','SAV','labosav','admin@wow-scan.pro','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000652-0000-0000-0000-000000000001','','','cabinetdentaireguichard@orange.fr','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000681-0000-0000-0000-000000000001','Dental lab’s','Laboratoire ','mils5@hotmail.fr','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000689-0000-0000-0000-000000000001','BY AXE ORTHO','SMILERS LAB','axe-ortho@outlook.fr','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000805-0000-0000-0000-000000000001','Demo','dr','jonathan.nave@scan4all.fr','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000838-0000-0000-0000-000000000001','','','denatllabs@gmail.com','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000840-0000-0000-0000-000000000001','','','dealm46@hotmail.fr','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000850-0000-0000-0000-000000000001','FLORENCE','BOURDELLE','drbourdelle@yahoo.com','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000916-0000-0000-0000-000000000001','','','alexandre.wetting@scan4all.fr','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000917-0000-0000-0000-000000000001','','','jonathan.nave@secure4all.eu','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000918-0000-0000-0000-000000000001','Webert','Laboratoire','evan_gaillon@yahoo.fr','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('00000941-0000-0000-0000-000000000001','','','awetting@yahoo.fr','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('1c82a32f-0fbb-4da9-8f5d-291ec1ddbe22','MARCOS','MORADAS','marcosmords@gmail.com','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('7ba6e72a-9d76-4dec-b0f0-a07f09b828c8','Sammy','Noumbissi','drsammy@milesofsmilesdental.net','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('8c118cb9-910c-4658-a99f-d32de0154b59','','','info@dental-institut.com','',NULL,'','','',NULL,NULL,'2022-07-21 14:25:09'),('badfd0b0-e793-4e31-938e-b25010a6e7a5','CIRO','GHIDELLI','digitalcamcaserta@gmail.com','',NULL,'','','',NULL,NULL,'2022-03-31 17:40:19'),('ce4b1d1b-e147-4ad3-9be6-d07eddb2116c','Sandra','MARQUES SANTOS','sandrams@odento.fr','',NULL,'','','',NULL,NULL,'2022-07-21 08:08:04'),('da78d926-7eb0-4d56-bcfe-381fd5a0a71b','Anne Charlotte','COUVREUR','marouaneb@odento.fr','',NULL,'','','',NULL,NULL,'2022-07-21 08:06:34'),('dc902cdb-398c-4c27-9929-91dd6bc04ed9','john','Couanouz','natux.54@gmail.com','',NULL,'','','',NULL,NULL,'2022-06-17 15:28:41');
/*!40000 ALTER TABLE `PersonInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PhoneInfo`
--

DROP TABLE IF EXISTS `PhoneInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PhoneInfo` (
  `id` char(36) NOT NULL COMMENT '(DC2Type:guid)',
  `mainPhone` varchar(45) DEFAULT NULL,
  `cellular` varchar(45) DEFAULT NULL,
  `fax` varchar(45) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PhoneInfo`
--

LOCK TABLES `PhoneInfo` WRITE;
/*!40000 ALTER TABLE `PhoneInfo` DISABLE KEYS */;
INSERT INTO `PhoneInfo` VALUES ('00000001-0000-0000-0000-000000000001','123322332','','',NULL,NULL,'2022-03-31 17:40:19'),('00000002-0000-0000-0000-000000000001','056139839','','',NULL,NULL,'2022-03-31 17:40:19'),('00000003-0000-0000-0000-000000000001','542138759','','',NULL,NULL,'2022-03-31 17:40:19'),('00000005-0000-0000-0000-000000000001','0388334408','','',NULL,NULL,'2022-03-31 17:40:19'),('00000006-0000-0000-0000-000000000001','0491776127','','',NULL,NULL,'2022-03-31 17:40:19'),('00000007-0000-0000-0000-000000000001','0664864059','','',NULL,NULL,'2022-03-31 17:40:19'),('00000008-0000-0000-0000-000000000001','0664143389','','',NULL,NULL,'2022-03-31 17:40:19'),('00000009-0000-0000-0000-000000000001','0149698526','','',NULL,NULL,'2022-03-31 17:40:19'),('00000028-0000-0000-0000-000000000001','0437289392','','',NULL,NULL,'2022-03-31 17:40:19'),('00000033-0000-0000-0000-000000000001','','','',NULL,NULL,'2022-03-31 17:40:19'),('00000059-0000-0000-0000-000000000001','0475490647','','',NULL,NULL,'2022-03-31 17:40:19'),('00000155-0000-0000-0000-000000000001','0241437031','','',NULL,NULL,'2022-03-31 17:40:19'),('00000172-0000-0000-0000-000000000001','0559830648','','',NULL,NULL,'2022-03-31 17:40:19'),('00000177-0000-0000-0000-000000000001','660474450','','',NULL,NULL,'2022-03-31 17:40:19'),('00000193-0000-0000-0000-000000000001','0663713747','','',NULL,NULL,'2022-03-31 17:40:19'),('00000224-0000-0000-0000-000000000001','0660850205','','',NULL,NULL,'2022-03-31 17:40:19'),('00000317-0000-0000-0000-000000000001','0382254814','','',NULL,NULL,'2022-03-31 17:40:19'),('00000339-0000-0000-0000-000000000001','0659598581','','',NULL,NULL,'2022-03-31 17:40:19'),('00000355-0000-0000-0000-000000000001','+390521221362','','',NULL,NULL,'2022-03-31 17:40:19'),('00000375-0000-0000-0000-000000000001','0142357044','','',NULL,NULL,'2022-03-31 17:40:19'),('00000377-0000-0000-0000-000000000001','0437578841','','',NULL,NULL,'2022-03-31 17:40:19'),('00000421-0000-0000-0000-000000000001','0142502324','','',NULL,NULL,'2022-03-31 17:40:19'),('00000568-0000-0000-0000-000000000001','0102030405','','',NULL,NULL,'2022-03-31 17:40:19'),('00000652-0000-0000-0000-000000000001','','','',NULL,NULL,'2022-03-31 17:40:19'),('00000681-0000-0000-0000-000000000001','0627204198','','',NULL,NULL,'2022-03-31 17:40:19'),('00000689-0000-0000-0000-000000000001','04 79 26 15 66','','',NULL,NULL,'2022-03-31 17:40:19'),('00000805-0000-0000-0000-000000000001','000000000','','',NULL,NULL,'2022-03-31 17:40:19'),('00000838-0000-0000-0000-000000000001','','','',NULL,NULL,'2022-03-31 17:40:19'),('00000840-0000-0000-0000-000000000001','','','',NULL,NULL,'2022-03-31 17:40:19'),('00000850-0000-0000-0000-000000000001','0450943901','','',NULL,NULL,'2022-03-31 17:40:19'),('00000916-0000-0000-0000-000000000001','','','',NULL,NULL,'2022-03-31 17:40:19'),('00000917-0000-0000-0000-000000000001','','','',NULL,NULL,'2022-03-31 17:40:19'),('00000918-0000-0000-0000-000000000001','0142502324','','',NULL,NULL,'2022-03-31 17:40:19'),('00000941-0000-0000-0000-000000000001','','','',NULL,NULL,'2022-03-31 17:40:19'),('2d5bbc4d-525b-4390-9305-f3c8a521b6a2','3015880768','','',NULL,NULL,'2022-03-31 17:40:19'),('360ec816-4362-44a5-83e9-daca84c68586','0374951935','','',NULL,NULL,'2022-07-21 08:05:05'),('42df56dc-3aee-4efc-93d1-b9440245784e','0645024712','','',NULL,NULL,'2022-06-17 15:22:57'),('474509a3-dedf-4a2b-92bc-2e0597685d20','','','',NULL,NULL,'2022-07-21 14:25:09'),('aaf0de04-32ef-4d2b-b90f-bf6e25f5f3a8','3388397462','','',NULL,NULL,'2022-03-31 17:40:19'),('b5b89b67-652d-431c-b39c-efa3736dbd8a','984157663','','',NULL,NULL,'2022-03-31 17:40:19'),('eec29aa8-fa3d-42af-8302-cece042df329','0374951935','','',NULL,NULL,'2022-07-21 08:08:04');
/*!40000 ALTER TABLE `PhoneInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Professional`
--

DROP TABLE IF EXISTS `Professional`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Professional` (
  `id` mediumint unsigned NOT NULL,
  `UUID` char(36) NOT NULL,
  `credentialsID` char(36) DEFAULT NULL,
  `comments` text,
  `personInfoID` char(36) DEFAULT NULL COMMENT '(DC2Type:guid)',
  `phoneInfoID` char(36) DEFAULT NULL COMMENT '(DC2Type:guid)',
  `addressInfoID` char(36) DEFAULT NULL COMMENT '(DC2Type:guid)',
  `configID` mediumint unsigned DEFAULT NULL,
  `syncInfoID` mediumint unsigned DEFAULT NULL,
  `surgeryName` varchar(255) DEFAULT NULL,
  `type` enum('Undefined','Prothesist','Dentist','Demo','Other') NOT NULL DEFAULT 'Undefined',
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastConnection` timestamp NULL DEFAULT NULL,
  `lastConnectionChecked` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `limitedContactID` char(36) DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `directoryVisible` tinyint(1) NOT NULL DEFAULT '1',
  `statusGalaxy` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_AB84A8523D139428` (`personInfoID`),
  UNIQUE KEY `UNIQ_AB84A852627FFEF6` (`phoneInfoID`),
  UNIQUE KEY `UNIQ_AB84A852A680FCCC` (`addressInfoID`),
  KEY `fk_Professional_Credentials` (`credentialsID`,`id`),
  KEY `fk_Professional_PersonInfo` (`personInfoID`,`id`),
  KEY `fk_Professional_PhoneInfo` (`phoneInfoID`,`id`),
  KEY `fk_Professional_AddressInfo` (`addressInfoID`,`id`),
  KEY `fk_Professional_Config` (`configID`,`id`),
  KEY `fk_Professional_SyncInfo` (`syncInfoID`,`id`),
  CONSTRAINT `fk_Professional_AddressInfo` FOREIGN KEY (`addressInfoID`) REFERENCES `AddressInfo` (`id`),
  CONSTRAINT `fk_Professional_Config` FOREIGN KEY (`configID`, `id`) REFERENCES `Config` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Professional_Credentials` FOREIGN KEY (`credentialsID`) REFERENCES `Credentials` (`id`),
  CONSTRAINT `fk_Professional_PersonInfo` FOREIGN KEY (`personInfoID`) REFERENCES `PersonInfo` (`id`),
  CONSTRAINT `fk_Professional_PhoneInfo` FOREIGN KEY (`phoneInfoID`) REFERENCES `PhoneInfo` (`id`),
  CONSTRAINT `fk_Professional_SyncInfo` FOREIGN KEY (`syncInfoID`, `id`) REFERENCES `SyncInfo` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Professional`
--

LOCK TABLES `Professional` WRITE;
/*!40000 ALTER TABLE `Professional` DISABLE KEYS */;
INSERT INTO `Professional` VALUES (1,'11644397-36f2-491f-aabf-b61c5414e0a5',NULL,'','00000001-0000-0000-0000-000000000001','00000001-0000-0000-0000-000000000001','00000001-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2022-06-21 09:44:25',NULL,NULL,'2022-06-21 07:44:25',NULL,'2022-06-21 09:44:25',1,0),(2,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','00000002-0000-0000-0000-000000000001','','00000002-0000-0000-0000-000000000001','00000002-0000-0000-0000-000000000001','00000002-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2022-07-12 14:28:31',NULL,NULL,'2022-07-12 12:28:31',NULL,'2022-07-12 14:28:30',1,0),(3,'7655b09e-027b-49c5-9b6c-832c6e41cee8',NULL,'','00000003-0000-0000-0000-000000000001','00000003-0000-0000-0000-000000000001','00000003-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2022-06-10 14:11:40',NULL,NULL,'2022-06-10 12:11:40',NULL,'2022-06-10 14:11:40',1,0),(5,'35997e6a-79be-404d-8b2c-46fa78f0f219',NULL,'','00000005-0000-0000-0000-000000000001','00000005-0000-0000-0000-000000000001','00000005-0000-0000-0000-000000000001',1,1,'','Other',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2020-02-21 15:56:57',1,0),(6,'372fe703-e954-4df2-a079-51315f137deb',NULL,'','00000006-0000-0000-0000-000000000001','00000006-0000-0000-0000-000000000001','00000006-0000-0000-0000-000000000001',1,1,'','Other',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2019-07-02 11:05:21',1,0),(7,'14d1a5e5-e2aa-42ab-9b88-6ff9da357d9b',NULL,'','00000007-0000-0000-0000-000000000001','00000007-0000-0000-0000-000000000001','00000007-0000-0000-0000-000000000001',1,1,'','Other',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2019-07-22 17:07:13',1,0),(8,'48539f38-473c-4be5-b635-3fb0fd42b27e',NULL,'','00000008-0000-0000-0000-000000000001','00000008-0000-0000-0000-000000000001','00000008-0000-0000-0000-000000000001',1,1,'','Other',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2019-07-22 19:36:25',1,0),(9,'1dab4f0e-ae37-4417-a649-d2a1322d368a',NULL,'','00000009-0000-0000-0000-000000000001','00000009-0000-0000-0000-000000000001','00000009-0000-0000-0000-000000000001',1,1,'','Other',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2019-07-11 10:05:09',1,0),(28,'b7646046-2641-4ccc-bdc4-f6d0a3752e88',NULL,'','00000028-0000-0000-0000-000000000001','00000028-0000-0000-0000-000000000001','00000028-0000-0000-0000-000000000001',1,1,'','Prothesist',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2019-07-15 10:57:02',1,0),(33,'ee68ea43-b4c3-4606-bc91-26457c3a7696',NULL,'','00000033-0000-0000-0000-000000000001','00000033-0000-0000-0000-000000000001','00000033-0000-0000-0000-000000000001',1,1,'','Undefined',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2019-07-15 14:34:40',1,0),(59,'023166d9-f822-4bb1-96cb-6fa7d892bf0b',NULL,'','00000059-0000-0000-0000-000000000001','00000059-0000-0000-0000-000000000001','00000059-0000-0000-0000-000000000001',1,1,'','Undefined',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2019-07-17 14:12:08',1,0),(155,'1bf8fcdd-496d-4839-ba78-f2b29eda6b93',NULL,'','00000155-0000-0000-0000-000000000001','00000155-0000-0000-0000-000000000001','00000155-0000-0000-0000-000000000001',1,1,'','Prothesist',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2019-08-27 14:27:01',1,0),(172,'36701f7c-94a7-4ef6-a635-25b6dc5e0f86',NULL,'','00000172-0000-0000-0000-000000000001','00000172-0000-0000-0000-000000000001','00000172-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2022-03-06 18:00:17',1,0),(177,'99a046a4-f05a-4eab-995e-4f0fda8261e2',NULL,'','00000177-0000-0000-0000-000000000001','00000177-0000-0000-0000-000000000001','00000177-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2021-01-12 18:18:25',1,0),(193,'eba81f34-ad3a-4498-b307-4af657800052',NULL,'','00000193-0000-0000-0000-000000000001','00000193-0000-0000-0000-000000000001','00000193-0000-0000-0000-000000000001',1,1,'','Undefined',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2019-09-02 18:53:02',1,0),(224,'765081bc-b5ad-428e-bfa7-7edfee9d51a1',NULL,'','00000224-0000-0000-0000-000000000001','00000224-0000-0000-0000-000000000001','00000224-0000-0000-0000-000000000001',1,1,'','Undefined',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2019-09-09 15:29:44',1,0),(317,'5fceb3e9-78c3-4c50-b1e1-6c0da17eb225',NULL,'','00000317-0000-0000-0000-000000000001','00000317-0000-0000-0000-000000000001','00000317-0000-0000-0000-000000000001',1,1,'','Prothesist',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2020-02-20 11:00:43',1,0),(339,'4d0904f5-35be-427c-8aa8-ded12c7970cb',NULL,'','00000339-0000-0000-0000-000000000001','00000339-0000-0000-0000-000000000001','00000339-0000-0000-0000-000000000001',1,1,'','Undefined',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2019-10-11 20:04:31',1,0),(355,'e8b64997-f348-44d2-82fc-581fc0df922d',NULL,'','00000355-0000-0000-0000-000000000001','00000355-0000-0000-0000-000000000001','00000355-0000-0000-0000-000000000001',1,1,'','Prothesist',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2019-10-23 12:56:25',1,0),(375,'4143cd0b-67ef-4dd8-baf4-06622a105550',NULL,'','00000375-0000-0000-0000-000000000001','00000375-0000-0000-0000-000000000001','00000375-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2022-05-23 19:20:34',NULL,NULL,'2022-05-23 17:20:34',NULL,'2022-05-23 19:20:34',1,0),(377,'9a8d2a6d-1088-45a9-8beb-31c22d464bc7',NULL,'','00000377-0000-0000-0000-000000000001','00000377-0000-0000-0000-000000000001','00000377-0000-0000-0000-000000000001',1,1,'','Undefined',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2020-03-03 11:05:55',1,0),(421,'7d471c64-3d84-43de-8868-70ea1e0ccec3',NULL,'','00000421-0000-0000-0000-000000000001','00000421-0000-0000-0000-000000000001','00000421-0000-0000-0000-000000000001',1,1,'','Prothesist',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2021-05-03 11:17:22',1,0),(568,'808ee592-c31d-4f88-91ea-1ee291bfd399',NULL,'','00000568-0000-0000-0000-000000000001','00000568-0000-0000-0000-000000000001','00000568-0000-0000-0000-000000000001',1,1,'','Undefined',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2020-02-04 15:19:02',1,0),(652,'6c360fb9-b9ee-4b93-8401-ed12ceecc15c',NULL,'','00000652-0000-0000-0000-000000000001','00000652-0000-0000-0000-000000000001','00000652-0000-0000-0000-000000000001',1,1,'','Undefined',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2020-03-12 14:49:16',1,0),(664,'f01a2b76-66cc-4161-908b-fc9d31389d9c',NULL,'','7ba6e72a-9d76-4dec-b0f0-a07f09b828c8','2d5bbc4d-525b-4390-9305-f3c8a521b6a2','cfa37f9c-eac1-4f2b-bf21-1672b9605bd9',1,1,'','Dentist',NULL,'2022-06-27 22:14:11',NULL,NULL,'2022-06-27 20:14:11',NULL,'2022-06-27 22:14:11',1,0),(681,'9ad57f69-9244-4c24-a8c6-c01070203722',NULL,'','00000681-0000-0000-0000-000000000001','00000681-0000-0000-0000-000000000001','00000681-0000-0000-0000-000000000001',1,1,'','Prothesist',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2020-05-29 09:10:28',1,0),(689,'464a0019-6c2e-403e-b0a5-f1b453741d76',NULL,'','00000689-0000-0000-0000-000000000001','00000689-0000-0000-0000-000000000001','00000689-0000-0000-0000-000000000001',1,1,'','Prothesist',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2020-11-03 08:29:54',1,0),(722,'47eb7b9c-26fc-423f-8bbe-bb1c0dd2226d',NULL,'','1c82a32f-0fbb-4da9-8f5d-291ec1ddbe22','b5b89b67-652d-431c-b39c-efa3736dbd8a','2c2079e2-cd33-4289-ba15-499df332f244',1,1,'','Dentist',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2022-03-14 16:10:41',1,0),(805,'55bdf9b4-bec6-4509-9668-d40f4626751c',NULL,'','00000805-0000-0000-0000-000000000001','00000805-0000-0000-0000-000000000001','00000805-0000-0000-0000-000000000001',1,1,'','Demo',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19','02095f64-af38-442a-b557-b604cfb57242','2020-12-09 11:12:20',0,0),(838,'8444f74b-f40e-46ef-acd4-b76564241dbf',NULL,'','00000838-0000-0000-0000-000000000001','00000838-0000-0000-0000-000000000001','00000838-0000-0000-0000-000000000001',1,1,'','Undefined',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2021-01-22 14:37:07',1,0),(840,'1a59dba2-9f1b-4bb3-85e2-d968d953a0c0',NULL,'','00000840-0000-0000-0000-000000000001','00000840-0000-0000-0000-000000000001','00000840-0000-0000-0000-000000000001',1,1,'','Undefined',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2021-01-22 16:28:38',1,0),(850,'5c0aa172-fd66-4ac8-8745-1a60912c6cae',NULL,'','00000850-0000-0000-0000-000000000001','00000850-0000-0000-0000-000000000001','00000850-0000-0000-0000-000000000001',1,1,'','Dentist',NULL,'2022-07-12 14:28:22',NULL,NULL,'2022-07-12 12:28:22',NULL,'2022-07-12 14:28:22',1,0),(899,'f5c65add-f981-447c-9d92-ded78e2c702b',NULL,'','badfd0b0-e793-4e31-938e-b25010a6e7a5','aaf0de04-32ef-4d2b-b90f-bf6e25f5f3a8','4587f1db-25f0-44f9-8512-01f705ae9949',1,1,'','Prothesist',NULL,'2022-06-18 13:30:59',NULL,NULL,'2022-06-18 11:30:59',NULL,'2022-06-18 13:30:59',1,0),(916,'9c30070b-103c-4956-8991-5573d2eda9e4',NULL,'','00000916-0000-0000-0000-000000000001','00000916-0000-0000-0000-000000000001','00000916-0000-0000-0000-000000000001',1,1,'','Undefined',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2021-04-28 14:05:53',1,0),(917,'b7ac955b-37e2-4eb6-a8d5-c2ce45f937e0',NULL,'','00000917-0000-0000-0000-000000000001','00000917-0000-0000-0000-000000000001','00000917-0000-0000-0000-000000000001',1,1,'','Undefined',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2021-04-28 14:53:31',1,0),(918,'72135d4e-320c-4081-a88b-7c3e918a487a',NULL,'','00000918-0000-0000-0000-000000000001','00000918-0000-0000-0000-000000000001','00000918-0000-0000-0000-000000000001',1,1,'','Undefined',NULL,'2022-03-31 19:40:20',NULL,NULL,'2022-03-31 17:40:20',NULL,'2021-04-29 16:03:23',1,0),(941,'a415b291-bd46-4c16-8864-95f0b7346d20',NULL,'','00000941-0000-0000-0000-000000000001','00000941-0000-0000-0000-000000000001','00000941-0000-0000-0000-000000000001',1,1,'','Undefined',NULL,'2022-03-31 19:40:19',NULL,NULL,'2022-03-31 17:40:19',NULL,'2021-06-07 14:52:03',1,0),(1055,'c48efc6d-2492-4ec5-91cb-dd4a5768da36',NULL,'','dc902cdb-398c-4c27-9929-91dd6bc04ed9','42df56dc-3aee-4efc-93d1-b9440245784e','b6281cbf-cfa6-4e42-8486-21b558c137ee',1,1,'','Prothesist',NULL,'2022-06-17 17:28:41',NULL,NULL,'2022-06-17 15:28:41',NULL,'2022-06-17 17:28:41',1,0),(1070,'ff8a242d-bd49-4bed-a171-ee187c282fc0','0c1df5f3-d1f7-47cf-8ef2-6256c08b396a','','da78d926-7eb0-4d56-bcfe-381fd5a0a71b','360ec816-4362-44a5-83e9-daca84c68586','523a5c43-599a-4b9c-82bd-b755e6a0bbc8',1,1,'','Dentist',NULL,'2022-10-13 10:23:38',NULL,NULL,'2022-10-13 08:23:38',NULL,'2022-10-13 10:23:30',1,0),(1071,'2c6d072b-4cf6-47ec-8559-923b326ad34b',NULL,'','8c118cb9-910c-4658-a99f-d32de0154b59','474509a3-dedf-4a2b-92bc-2e0597685d20','1b9fb50b-ca87-4650-b356-f1c97e4c9375',1,1,'','Undefined',NULL,'2022-07-21 16:25:12',NULL,NULL,'2022-07-21 14:25:12',NULL,'2022-07-21 16:25:09',1,0);
/*!40000 ALTER TABLE `Professional` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProfessionalEnvInfos`
--

DROP TABLE IF EXISTS `ProfessionalEnvInfos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProfessionalEnvInfos` (
  `id` char(36) NOT NULL COMMENT '(DC2Type:guid)',
  `professionalID` mediumint unsigned NOT NULL DEFAULT '0' COMMENT 'Le professionnel propriétaire des informations',
  `accessCode` varchar(45) DEFAULT NULL,
  `status` enum('created','confirmed','blocked') NOT NULL DEFAULT 'created',
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `preventDuplicateProfessionalEnvInfos` (`professionalID`),
  KEY `fk_ProfessionalEnvInfos_RefersTo_idx` (`professionalID`),
  CONSTRAINT `FK_A15010B8C37A46A` FOREIGN KEY (`professionalID`) REFERENCES `Professional` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProfessionalEnvInfos`
--

LOCK TABLES `ProfessionalEnvInfos` WRITE;
/*!40000 ALTER TABLE `ProfessionalEnvInfos` DISABLE KEYS */;
INSERT INTO `ProfessionalEnvInfos` VALUES ('07c1bfa6-756a-4d86-9da5-75cdd26c33d9',1055,NULL,'confirmed','2022-07-12 12:26:51'),('1264f628-979e-430f-a2db-139e9b3dcd57',59,NULL,'confirmed','2022-07-12 12:23:59'),('26d898f1-8831-4515-95b6-de1fbe0e1be8',805,NULL,'confirmed','2022-07-12 12:23:59'),('271f2f73-77e5-4ba7-b21e-c92185fa427d',33,'9e78c77f','created','2022-07-12 12:23:59'),('2737d2c3-a830-4118-85ce-d0a61ab21386',840,'91196e2d','created','2022-07-12 12:23:59'),('29a5bce6-3396-41d8-9e89-cb385d5b711e',652,'2d03a8b3','created','2022-07-12 12:23:59'),('2fa7bf18-2c89-468f-91e9-a164a15b429d',224,NULL,'confirmed','2022-07-12 12:23:59'),('31dea6c0-ac26-4659-953d-6880060de4be',421,NULL,'confirmed','2022-07-12 12:23:59'),('354a1a78-e479-48e8-bd3d-26f71569f627',7,NULL,'confirmed','2022-07-12 12:23:59'),('37564108-9f27-4df5-9c76-58abdde14b68',722,NULL,'confirmed','2022-07-12 12:26:51'),('3db1ab5c-9fbc-46df-bfc5-1c98afc41910',155,NULL,'confirmed','2022-07-12 12:23:59'),('56a6aad0-521f-40a5-b53f-9a2c0c7f6ff7',355,NULL,'confirmed','2022-07-12 12:23:59'),('5d37dcf7-3933-462c-89de-8718f7de4214',172,NULL,'confirmed','2022-07-12 12:23:59'),('7068b673-3f09-496b-ba5c-17d2ba005a8b',8,NULL,'confirmed','2022-07-12 12:23:59'),('71cf8f68-779f-475e-8dbf-a7e2e08d6b1f',28,NULL,'confirmed','2022-07-12 12:23:59'),('7346597f-65ab-4cb9-8acc-efd97e3ea7ab',339,NULL,'confirmed','2022-07-12 12:23:59'),('796e484c-fd30-406f-8d05-191185c551a8',850,NULL,'confirmed','2022-07-12 12:23:59'),('7ce7b0d0-fd5b-4ef7-90fb-e05869ab6f4d',193,NULL,'confirmed','2022-07-12 12:23:59'),('8877391c-8425-48b7-b436-e966029150a4',916,'0a1720e5','created','2022-07-12 12:23:59'),('89f8ca7b-5681-4c8b-8c62-511291dbe611',377,NULL,'confirmed','2022-07-12 12:23:59'),('8c57d4f8-83d5-4874-a631-1441d9c70422',689,NULL,'confirmed','2022-07-12 12:23:59'),('97270245-45e5-4251-ae32-56addfb05a6e',9,NULL,'confirmed','2022-07-12 12:23:59'),('97d6f832-117a-49c6-afa9-6eccf5907f6e',6,NULL,'confirmed','2022-07-12 12:23:59'),('9eb93fd2-62ee-4017-93fe-2f30c325422f',177,NULL,'confirmed','2022-07-12 12:23:59'),('a46364bb-0a7e-49e2-9bf5-0642ffd1ec54',941,'3f807fd2','created','2022-07-12 12:23:59'),('a7f3a401-3c2f-4919-abf2-40e78ff60d1a',899,NULL,'confirmed','2022-07-12 12:26:51'),('ba10a6c9-13be-4dc1-9067-6e59ec83538a',568,NULL,'confirmed','2022-07-12 12:23:59'),('bbd87f3c-48a4-4686-aaa4-ed80c9962772',5,NULL,'confirmed','2022-07-12 12:23:59'),('c58c8a2e-6242-4260-8b25-4cbf58f7d696',2,NULL,'confirmed','2022-07-12 12:23:59'),('c99f945a-88e6-48f0-8f79-ef6f127b8e18',317,NULL,'confirmed','2022-07-12 12:23:59'),('ca883ab8-c5fd-4f45-bf82-2dcf931155ec',681,NULL,'confirmed','2022-07-12 12:23:59'),('cc56e693-1be1-4d7e-a0ea-d7a9e2ace663',3,NULL,'confirmed','2022-07-12 12:23:59'),('dcc22e35-50c0-4925-ac5d-09233b6d0dba',1,NULL,'confirmed','2022-07-12 12:23:59'),('de50c815-2c07-45e7-a808-ab0e0c35352d',1070,NULL,'confirmed','2022-07-21 08:05:06'),('e153bef8-16e2-4f3e-b1d8-357fc6d541b1',664,NULL,'confirmed','2022-07-12 12:26:51'),('e30a822c-af3c-4e35-b9f5-b077a87f1f9d',1071,'e484179d','created','2022-07-21 14:25:11'),('f36593e8-0959-445a-9f05-7304230a5628',918,NULL,'confirmed','2022-07-12 12:23:59'),('f873de5d-6e7b-4f48-bf7b-8d4f771aab95',375,NULL,'confirmed','2022-07-12 12:23:59'),('fa6419ae-9139-46e1-9645-8915f9bd4577',917,'b83216c0','created','2022-07-12 12:23:59'),('ffc4ec9b-9fbc-4cb3-8506-58dcdd1946ea',838,'0a05c99f','created','2022-07-12 12:23:59');
/*!40000 ALTER TABLE `ProfessionalEnvInfos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProfessionalPatient`
--

DROP TABLE IF EXISTS `ProfessionalPatient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProfessionalPatient` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `ownerID` mediumint unsigned NOT NULL DEFAULT '0',
  `patientID` char(36) DEFAULT NULL,
  `officeID` char(36) DEFAULT NULL,
  `enablePatientSharing` tinyint(1) DEFAULT '0',
  `pinned` tinyint(1) NOT NULL DEFAULT '0',
  `theme` enum('NONE','ADULT','BOY','GIRL','BABY') DEFAULT 'NONE',
  PRIMARY KEY (`id`),
  KEY `unique_Patient_Pro` (`ownerID`,`patientID`),
  CONSTRAINT `fk_Patient_Pro` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProfessionalPatient`
--

LOCK TABLES `ProfessionalPatient` WRITE;
/*!40000 ALTER TABLE `ProfessionalPatient` DISABLE KEYS */;
INSERT INTO `ProfessionalPatient` VALUES (1,2,'962f1518-7af1-402d-b050-a4fb49c5c5b8','f841d3b8-276b-4ad1-859c-ba7e25ffe059',0,0,'NONE'),(2,2,'616990f6-4bb6-40d6-a637-926ee3cbfb23','f841d3b8-276b-4ad1-859c-ba7e25ffe059',0,0,'NONE'),(3,2,'43bfdd66-40e9-4024-8259-412b8743b170','f841d3b8-276b-4ad1-859c-ba7e25ffe059',0,0,'NONE'),(4,1070,'5c0b4788-810f-4d15-8d45-7d5d359e7cdd','ce5c9575-3e13-44d4-a543-61e770347bd6',0,0,'GIRL'),(5,1070,'e7759074-9318-45d5-bcd1-33d350e0b5a3','ce5c9575-3e13-44d4-a543-61e770347bd6',0,0,'NONE'),(6,1070,'959e5762-b4e5-4295-a332-8a831a0fbf4a','ce5c9575-3e13-44d4-a543-61e770347bd6',0,0,'GIRL'),(7,1070,'9c02f604-22db-491d-9239-90efde367312','ce5c9575-3e13-44d4-a543-61e770347bd6',0,0,'BOY'),(8,1070,'1ddf5934-ea4d-477a-9ec0-1d9144b1467d','ce5c9575-3e13-44d4-a543-61e770347bd6',0,0,'BOY'),(9,1070,'4ef31c58-7de3-427d-ae5c-24505cfef470','ce5c9575-3e13-44d4-a543-61e770347bd6',0,0,'BABY'),(10,1070,'d988cd8e-9d0f-42ab-99e2-fdcb685ac84a','ce5c9575-3e13-44d4-a543-61e770347bd6',0,0,'BOY'),(11,1070,'9d774be1-a55f-4825-ab1b-d07f47fea0d7','ce5c9575-3e13-44d4-a543-61e770347bd6',0,0,'GIRL'),(12,1070,'e0f46c84-c106-4642-bfeb-a5b36b5820ae','ce5c9575-3e13-44d4-a543-61e770347bd6',0,0,'GIRL'),(13,1070,'85f9266a-1e42-4669-9ace-c68914229450','ce5c9575-3e13-44d4-a543-61e770347bd6',0,0,'ADULT'),(14,1070,'1c129203-428b-4abf-9590-05156c541ef4','ce5c9575-3e13-44d4-a543-61e770347bd6',0,0,'ADULT'),(15,1070,'e13c999d-6ee9-46c9-9078-d4f1d92a124d','ce5c9575-3e13-44d4-a543-61e770347bd6',0,0,'ADULT'),(16,1070,'72fd320a-ac9e-4cb7-9e45-df60e7483550','ce5c9575-3e13-44d4-a543-61e770347bd6',0,0,'ADULT'),(17,1070,'40a79232-5988-45ff-9778-8c8c18afa1c5','ce5c9575-3e13-44d4-a543-61e770347bd6',0,0,'ADULT'),(18,1070,'2d21e70c-4fb9-4add-a60d-dd2e1f166ead','ce5c9575-3e13-44d4-a543-61e770347bd6',0,0,'ADULT'),(19,1070,'0a5d2238-a9d8-4d69-9619-8c05329ca74a','ce5c9575-3e13-44d4-a543-61e770347bd6',0,0,'ADULT');
/*!40000 ALTER TABLE `ProfessionalPatient` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrder`
--

DROP TABLE IF EXISTS `ProstheticOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticOrder` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `currentDeliveryDate` datetime DEFAULT NULL,
  `previousDeliveryDate` datetime DEFAULT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `title` varchar(64) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `status` enum('not_sent','sent','date_validated','date_edited','validated','cancelled') NOT NULL DEFAULT 'sent',
  `unread` tinyint(1) DEFAULT '0',
  `createdAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `actID` char(36) NOT NULL,
  `localDisplayID` mediumint unsigned DEFAULT NULL,
  `globalDisplayID` mediumint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `idx_Order_Work` (`ownerID`),
  KEY `fk_Order_Act` (`actID`,`ownerID`),
  CONSTRAINT `fk_Order_Act` FOREIGN KEY (`actID`, `ownerID`) REFERENCES `Act` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrder`
--

LOCK TABLES `ProstheticOrder` WRITE;
/*!40000 ALTER TABLE `ProstheticOrder` DISABLE KEYS */;
/*!40000 ALTER TABLE `ProstheticOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrderFile`
--

DROP TABLE IF EXISTS `ProstheticOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticOrderFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `orderID` char(36) NOT NULL,
  `fileID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`orderID`,`fileID`),
  KEY `fk_ProstheticOrderFile_ProstheticOrder` (`orderID`,`ownerID`),
  KEY `fk_ProstheticOrderFile_CondorFile` (`fileID`,`ownerID`),
  CONSTRAINT `fk_ProstheticOrderFile_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_ProstheticOrderFile_ProstheticOrder` FOREIGN KEY (`orderID`, `ownerID`) REFERENCES `ProstheticOrder` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrderFile`
--

LOCK TABLES `ProstheticOrderFile` WRITE;
/*!40000 ALTER TABLE `ProstheticOrderFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `ProstheticOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrderRecipient`
--

DROP TABLE IF EXISTS `ProstheticOrderRecipient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticOrderRecipient` (
  `ownerID` mediumint unsigned NOT NULL,
  `orderID` char(36) NOT NULL,
  `recipientID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`orderID`,`recipientID`),
  KEY `fk_ProstheticOrderRecipient_ProstheticOrder` (`orderID`,`ownerID`),
  KEY `fk_ProstheticOrderRecipient_Contact` (`recipientID`,`ownerID`),
  CONSTRAINT `fk_ProstheticOrderRecipient_Contact` FOREIGN KEY (`recipientID`, `ownerID`) REFERENCES `Contact` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_ProstheticOrderRecipient_ProstheticOrder` FOREIGN KEY (`orderID`, `ownerID`) REFERENCES `ProstheticOrder` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrderRecipient`
--

LOCK TABLES `ProstheticOrderRecipient` WRITE;
/*!40000 ALTER TABLE `ProstheticOrderRecipient` DISABLE KEYS */;
/*!40000 ALTER TABLE `ProstheticOrderRecipient` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticSheet`
--

DROP TABLE IF EXISTS `ProstheticSheet`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticSheet` (
  `id` char(36) NOT NULL,
  `ownerID` mediumint unsigned NOT NULL,
  `orderID` char(36) NOT NULL,
  `json` text NOT NULL,
  `pdfFileID` char(36) DEFAULT NULL,
  `dateCreated` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_ProstheticSheet_ProstheticOrder` (`orderID`),
  KEY `fk_ProstheticSheet_CondorFile` (`pdfFileID`),
  CONSTRAINT `fk_ProstheticSheet_CondorFile` FOREIGN KEY (`pdfFileID`) REFERENCES `CondorFile` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_ProstheticSheet_ProstheticOrder` FOREIGN KEY (`orderID`) REFERENCES `ProstheticOrder` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticSheet`
--

LOCK TABLES `ProstheticSheet` WRITE;
/*!40000 ALTER TABLE `ProstheticSheet` DISABLE KEYS */;
/*!40000 ALTER TABLE `ProstheticSheet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ReceivedAttachment`
--

DROP TABLE IF EXISTS `ReceivedAttachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ReceivedAttachment` (
  `ownerID` mediumint unsigned NOT NULL,
  `receivedMessageID` char(36) NOT NULL,
  `fileID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`fileID`,`receivedMessageID`),
  KEY `fk_ReceivedAttachment_ReceivedMessage` (`receivedMessageID`,`ownerID`),
  KEY `fk_ReceivedAttachment_CondorFile` (`fileID`,`ownerID`),
  CONSTRAINT `fk_ReceivedAttachment_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_ReceivedAttachment_ReceivedMessage` FOREIGN KEY (`receivedMessageID`, `ownerID`) REFERENCES `ReceivedMessage` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ReceivedAttachment`
--

LOCK TABLES `ReceivedAttachment` WRITE;
/*!40000 ALTER TABLE `ReceivedAttachment` DISABLE KEYS */;
/*!40000 ALTER TABLE `ReceivedAttachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ReceivedMessage`
--

DROP TABLE IF EXISTS `ReceivedMessage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ReceivedMessage` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `created` datetime DEFAULT NULL,
  `messageTransmitted` tinyint(1) NOT NULL DEFAULT '0',
  `messageSubject` varchar(45) NOT NULL,
  `body` text,
  `fromID` mediumint unsigned NOT NULL,
  `originMessageID` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `discussionID` char(36) NOT NULL,
  `readStatus` enum('Read','Unread') DEFAULT 'Unread',
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_ReceivedMessage_Discussion` (`discussionID`,`ownerID`),
  CONSTRAINT `fk_ReceivedMessage_Discussion` FOREIGN KEY (`discussionID`, `ownerID`) REFERENCES `Discussion` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ReceivedMessage`
--

LOCK TABLES `ReceivedMessage` WRITE;
/*!40000 ALTER TABLE `ReceivedMessage` DISABLE KEYS */;
/*!40000 ALTER TABLE `ReceivedMessage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Scan`
--

DROP TABLE IF EXISTS `Scan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Scan` (
  `ownerID` mediumint unsigned NOT NULL DEFAULT '0',
  `id` char(36) NOT NULL,
  `scanType` enum('MAXILLAIRE','MANDIBULE','MORDU_ANTERIEUR','MORDU_POSTERIEUR_GAUCHE','MORDU_POSTERIEUR_DROIT') DEFAULT 'MAXILLAIRE',
  `comments` mediumtext,
  `cameraX` decimal(10,0) DEFAULT NULL,
  `cameraY` decimal(10,0) DEFAULT NULL,
  `cameraZ` decimal(10,0) DEFAULT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `validated` tinyint(1) NOT NULL DEFAULT '0',
  `status` enum('in_progress','none') NOT NULL DEFAULT 'in_progress',
  `dateCreated` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `sessionID` char(36) DEFAULT NULL,
  `displayID` mediumint unsigned DEFAULT NULL,
  `globalDisplayID` mediumint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Scan_Work` (`ownerID`),
  KEY `fk_Scan_Session` (`sessionID`,`ownerID`),
  CONSTRAINT `fk_Scan_Session` FOREIGN KEY (`sessionID`, `ownerID`) REFERENCES `Session` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Scan`
--

LOCK TABLES `Scan` WRITE;
/*!40000 ALTER TABLE `Scan` DISABLE KEYS */;
INSERT INTO `Scan` VALUES (1070,'008acbcb-f43a-433d-8deb-10128a09785f','MAXILLAIRE','',NULL,NULL,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993',0,'none','2022-07-21 15:44:26','2022-07-21 15:46:40',NULL,'2022-07-21 13:46:40','2022-07-21 15:44:26','b218d0b0-9a2a-49ea-b229-6495a2a4ae37',1,1),(1070,'13853683-1e26-4890-947b-64b363344c9d','MAXILLAIRE','',NULL,NULL,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993',0,'none','2022-09-28 11:33:56','2022-09-28 12:31:24',NULL,'2022-09-28 10:31:24','2022-09-28 11:33:56','ea7ca0ea-51ca-4a55-8cf5-cfec2f762fa2',1,1),(1070,'25167fd5-d99b-4723-9e78-c5acb6642934','MAXILLAIRE','',NULL,NULL,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993',0,'none','2022-09-28 11:36:01','2022-09-28 11:41:44',NULL,'2022-09-28 09:41:44','2022-09-28 11:41:14','3666e5c7-80c2-4717-8bcb-4635d69b4a96',1,1),(1070,'2b509607-0f55-4877-9ca6-4704b578eb62','MAXILLAIRE','',NULL,NULL,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993',0,'none','2022-07-21 15:32:57','2022-07-21 15:39:54',NULL,'2022-07-21 13:39:54','2022-07-21 15:32:57','3a46ea6c-42e7-433a-95cf-cd20cf156420',1,1),(1070,'2cb1b1ff-7d9d-4e3b-bc88-7c50487f0ac9','MANDIBULE','',NULL,NULL,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993',0,'none','2022-09-28 09:45:49','2022-09-28 09:50:19',NULL,'2022-09-28 07:50:19','2022-09-28 09:45:49','e9fbefb3-e2af-4fe4-ac5f-0495636df2cc',2,1),(1070,'30d758b6-ddfe-4e9e-8a14-4e24d25340f8','MAXILLAIRE','',NULL,NULL,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993',0,'none','2022-09-28 10:02:36',NULL,'2022-10-03 11:54:43','2022-10-03 09:54:43','2022-09-28 10:25:04','e9fbefb3-e2af-4fe4-ac5f-0495636df2cc',6,1),(1070,'311bf037-40e8-468f-8a4a-808858eebfc0','MAXILLAIRE','',NULL,NULL,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993',0,'none','2022-09-28 11:59:46',NULL,'2022-10-03 11:43:41','2022-10-03 09:43:41','2022-09-28 12:05:01','3666e5c7-80c2-4717-8bcb-4635d69b4a96',3,1),(1070,'3149b0eb-455c-46a0-9f32-ee7d54043dae','MAXILLAIRE','',NULL,NULL,NULL,'ff8a242d-bd49-4bed-a171-ee187c282fc0','bb400151-f8fe-4758-a9bc-273e9be9e993',1,'none','2022-09-28 09:52:57','2022-09-28 12:20:02',NULL,'2022-09-28 10:20:02','2022-09-28 09:53:31','e9fbefb3-e2af-4fe4-ac5f-0495636df2cc',4,1),(2,'31f454d0-a75f-4f4e-a3a4-bfd0a475806a','MAXILLAIRE','',NULL,NULL,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103',1,'none','2022-07-12 14:27:21',NULL,NULL,'2022-07-12 12:28:29','2022-07-12 14:28:29','bf6aab3b-87a2-40d8-88a0-1b221d68e62e',1,409),(1070,'3320ffdc-35fb-4b50-972f-b5c22aa09391','MAXILLAIRE','',NULL,NULL,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993',0,'none','2022-09-28 11:41:49','2022-09-28 11:51:06',NULL,'2022-09-28 09:51:06','2022-09-28 11:41:49','3666e5c7-80c2-4717-8bcb-4635d69b4a96',2,1),(1070,'3433b381-75f3-4923-a597-d5a8ae24ecfc','MAXILLAIRE','',NULL,NULL,NULL,'ff8a242d-bd49-4bed-a171-ee187c282fc0','ff8a242d-bd49-4bed-a171-ee187c282fc0',1,'none','2022-09-28 09:52:56','2022-09-28 12:20:14',NULL,'2022-09-28 10:20:14','2022-09-28 09:52:56','e9fbefb3-e2af-4fe4-ac5f-0495636df2cc',2,1),(1070,'3504d59a-bb7a-48ed-a241-cbf017371fe1','MORDU_POSTERIEUR_DROIT','',NULL,NULL,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993',0,'none','2022-09-28 12:05:43',NULL,'2022-10-03 11:44:11','2022-10-03 09:44:11','2022-09-28 12:08:47','3666e5c7-80c2-4717-8bcb-4635d69b4a96',1,1),(2,'35890e97-f371-4a18-8c62-354841cfea22','MAXILLAIRE','',NULL,NULL,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103',1,'none','2021-06-24 15:47:30',NULL,'2022-07-12 14:26:49','2022-07-12 12:26:49','2021-06-24 15:48:26','8f3430ca-19b8-49d4-bc0a-125d43decc54',1,409),(1070,'36baf7e7-c8ea-4a9d-a7b2-703b4c4491db','MAXILLAIRE','',NULL,NULL,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993',0,'none','2022-10-04 15:42:21',NULL,'2022-10-05 16:17:33','2022-10-05 14:17:33','2022-10-04 16:03:29','ce4d3ca4-dc3a-46cb-aa8a-108d7be41a7f',1,1),(1070,'44ccc0d7-4dd1-4e59-bcd1-960249ca8fcd','MAXILLAIRE','',NULL,NULL,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993',0,'none','2022-10-10 10:18:38',NULL,'2022-10-10 15:34:43','2022-10-10 13:34:43','2022-10-10 10:18:38','4e8bb869-cbd8-4f20-a300-bc069b6cfa71',2,1),(1070,'4d78c4e6-43de-4778-a97a-744a71ad8f47','MAXILLAIRE','',NULL,NULL,NULL,'ff8a242d-bd49-4bed-a171-ee187c282fc0','ff8a242d-bd49-4bed-a171-ee187c282fc0',1,'none','2022-09-28 09:52:56','2022-09-28 12:20:10',NULL,'2022-09-28 10:20:10','2022-09-28 09:52:56','e9fbefb3-e2af-4fe4-ac5f-0495636df2cc',3,1),(1070,'521bad12-deec-4508-b53a-7e46a707e6a8','MANDIBULE','',NULL,NULL,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993',0,'none','2022-09-28 12:31:54',NULL,'2022-10-03 11:48:47','2022-10-03 09:48:47','2022-09-28 12:39:33','ea7ca0ea-51ca-4a55-8cf5-cfec2f762fa2',1,1),(1070,'5864f038-0740-4bea-bcb3-6e45282a2085','MAXILLAIRE','',NULL,NULL,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993',0,'none','2022-10-10 10:17:11',NULL,'2022-10-10 10:18:28','2022-10-10 08:18:28','2022-10-10 10:17:11','4e8bb869-cbd8-4f20-a300-bc069b6cfa71',1,1),(1070,'5d5c7d13-1b7d-4083-8ad7-d7c9466f5b0f','MANDIBULE','',NULL,NULL,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993',0,'none','2022-07-21 15:41:13','2022-07-21 15:44:23',NULL,'2022-07-21 13:44:23','2022-07-21 15:41:13','b218d0b0-9a2a-49ea-b229-6495a2a4ae37',1,1),(1070,'65c74e5c-fee5-4bd8-987d-85d5fa05d382','MANDIBULE','',NULL,NULL,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993',0,'none','2022-09-28 09:44:30','2022-09-28 09:45:44',NULL,'2022-09-28 07:45:44','2022-09-28 09:44:30','e9fbefb3-e2af-4fe4-ac5f-0495636df2cc',1,1),(1070,'72ff3b14-d8f3-4975-a7cb-4b6d3b4858ab','MAXILLAIRE','',NULL,NULL,NULL,'ff8a242d-bd49-4bed-a171-ee187c282fc0','ff8a242d-bd49-4bed-a171-ee187c282fc0',1,'none','2022-07-21 10:12:27','2022-07-21 10:13:30',NULL,'2022-07-21 08:13:30','2022-07-21 10:12:27','c79bcfde-2b96-4152-b7ff-be8fb2f49261',1,1),(1070,'7cf94db9-9efe-4581-b4a5-28fec7ee4559','MAXILLAIRE','',NULL,NULL,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993',0,'none','2022-09-28 09:53:39',NULL,'2022-10-03 11:52:53','2022-10-03 09:52:53','2022-09-28 09:57:36','e9fbefb3-e2af-4fe4-ac5f-0495636df2cc',5,1),(1070,'85a92f8c-4ecf-4366-8339-752e58524d68','MANDIBULE','',NULL,NULL,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993',0,'none','2022-09-28 09:58:22','2022-09-28 10:02:30',NULL,'2022-09-28 08:02:30','2022-09-28 09:58:22','e9fbefb3-e2af-4fe4-ac5f-0495636df2cc',3,1),(1070,'87171523-80e9-4f42-a13e-91213d9fba55','MAXILLAIRE','',NULL,NULL,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993',0,'none','2022-10-11 10:12:07',NULL,'2022-10-11 10:32:33','2022-10-11 08:32:33','2022-10-11 10:32:25','d3b06f3d-a4b5-4db4-81f7-39b33c210472',1,1),(1070,'9a0912c7-d649-4d0a-bc0d-b26ae74ab1f4','MAXILLAIRE','',NULL,NULL,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993',0,'none','2022-10-05 16:10:28',NULL,'2022-10-05 16:19:17','2022-10-05 14:19:17','2022-10-05 16:17:31','2209d1b9-4da1-4054-814c-5a760347d91d',1,1),(2,'a7f52934-fccf-4e08-bd4c-b65c890a3fb5','MAXILLAIRE','',NULL,NULL,NULL,'bf19c334-c71b-4e23-9ce0-73ddec5fe103','bf19c334-c71b-4e23-9ce0-73ddec5fe103',1,'none','2021-06-24 15:46:35','2021-06-24 15:49:31',NULL,'2021-06-24 13:49:31','2021-06-24 15:46:35','ae710858-ba34-4d33-8c42-3028ce12760f',1,409),(1070,'b9b9342b-1007-4281-a39d-27fce0f4ba30','MANDIBULE','',NULL,NULL,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993',0,'none','2022-09-28 11:51:12',NULL,'2022-10-03 11:45:42','2022-10-03 09:45:42','2022-09-28 11:57:56','3666e5c7-80c2-4717-8bcb-4635d69b4a96',1,1),(1070,'b9f77799-d642-4773-a67d-d83f37e0c814','MAXILLAIRE','',NULL,NULL,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993',0,'none','2022-09-28 09:51:05','2022-09-28 12:20:18',NULL,'2022-09-28 10:20:18','2022-09-28 09:52:45','e9fbefb3-e2af-4fe4-ac5f-0495636df2cc',1,1),(1070,'bb5eb4a4-c536-43b3-85db-ea47cf0d83ea','MAXILLAIRE','',NULL,NULL,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993',0,'none','2022-10-10 15:34:59',NULL,'2022-10-11 09:30:19','2022-10-11 07:30:19','2022-10-10 15:34:59','b98288d5-cb60-443a-8de1-2b0562c07a1c',1,1),(1070,'c0b45e70-6cd8-404b-a997-a61d85ce9721','MANDIBULE','',NULL,NULL,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993',0,'none','2022-09-28 12:39:48',NULL,'2022-10-03 11:50:31','2022-10-03 09:50:31','2022-09-28 12:52:56','ea7ca0ea-51ca-4a55-8cf5-cfec2f762fa2',2,1),(1070,'c8b44d90-bd34-4895-ad41-bdd76ff0b475','MAXILLAIRE','',NULL,NULL,NULL,'bb400151-f8fe-4758-a9bc-273e9be9e993','bb400151-f8fe-4758-a9bc-273e9be9e993',0,'none','2022-09-28 12:22:21',NULL,'2022-10-03 11:52:51','2022-10-03 09:52:51','2022-09-28 12:31:10','ea7ca0ea-51ca-4a55-8cf5-cfec2f762fa2',2,1);
/*!40000 ALTER TABLE `Scan` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `Scan_AFTER_UPDATE` AFTER UPDATE ON `Scan` FOR EACH ROW BEGIN
    IF NEW.deletedAt IS NOT NULL THEN
      UPDATE Occlusion SET topScanID = NULL
	  WHERE topScanID = new.id;

	  UPDATE Occlusion SET bottomScanID = NULL
	  WHERE bottomScanID = new.id;

	  UPDATE Occlusion SET leftBiteScanID = NULL
	  WHERE leftBiteScanID = new.id;

	  UPDATE Occlusion SET rightBiteScanID = NULL
	  WHERE rightBiteScanID = new.id;

	  UPDATE Occlusion SET anteriorBiteScanID = NULL
	  WHERE anteriorBiteScanID = new.id;
    END IF;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `Scan_BEFORE_DELETE` BEFORE DELETE ON `Scan` FOR EACH ROW BEGIN
  UPDATE Occlusion SET topScanID = NULL
  WHERE topScanID = OLD.id;

  UPDATE Occlusion SET bottomScanID = NULL
  WHERE bottomScanID = OLD.id;

  UPDATE Occlusion SET leftBiteScanID = NULL
  WHERE leftBiteScanID = OLD.id;

  UPDATE Occlusion SET rightBiteScanID = NULL
  WHERE rightBiteScanID = OLD.id;

  UPDATE Occlusion SET anteriorBiteScanID = NULL
  WHERE anteriorBiteScanID = OLD.id;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `ScanFile`
--

DROP TABLE IF EXISTS `ScanFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ScanFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `fileID` char(36) NOT NULL,
  `scanID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`fileID`,`scanID`,`ownerID`),
  KEY `fk_ScanFile_Scan` (`scanID`,`ownerID`),
  KEY `fk_ScanFile_CondorFile` (`fileID`,`ownerID`),
  CONSTRAINT `fk_ScanFile_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_ScanFile_Scan` FOREIGN KEY (`scanID`, `ownerID`) REFERENCES `Scan` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ScanFile`
--

LOCK TABLES `ScanFile` WRITE;
/*!40000 ALTER TABLE `ScanFile` DISABLE KEYS */;
INSERT INTO `ScanFile` VALUES (1070,'016dd378-6bd3-4763-80e5-7b4b1ddd19de','3149b0eb-455c-46a0-9f32-ee7d54043dae','2022-09-28 07:53:31'),(1070,'0258594c-75cd-4ee3-8d5d-a60808aee731','87171523-80e9-4f42-a13e-91213d9fba55','2022-10-11 08:32:24'),(1070,'0e914012-d52b-4d16-858d-c13cfeafdbd5','25167fd5-d99b-4723-9e78-c5acb6642934','2022-09-28 09:41:13'),(1070,'135e9338-31af-4b45-a4b2-cf5ee024ac47','521bad12-deec-4508-b53a-7e46a707e6a8','2022-09-28 10:39:31'),(1070,'18e2773c-052d-4be7-a3a2-65773980b3ac','87171523-80e9-4f42-a13e-91213d9fba55','2022-10-11 08:24:21'),(1070,'1c64f0eb-a022-4aa4-a0ea-bbde3f08399b','4d78c4e6-43de-4778-a97a-744a71ad8f47','2022-09-28 07:52:56'),(1070,'20618dbb-604f-4e4e-810f-ffed65022dd2','c0b45e70-6cd8-404b-a997-a61d85ce9721','2022-09-28 10:52:54'),(2,'27e8ca83-ab81-4826-8827-f8b8fefb8cfa','35890e97-f371-4a18-8c62-354841cfea22','2021-06-24 13:48:26'),(2,'35aee314-e69d-42b2-b02d-9e9316055b2a','35890e97-f371-4a18-8c62-354841cfea22','2021-06-24 13:48:26'),(1070,'3c5dbf34-9f19-4d76-9d84-5abfb1cdb3a5','3149b0eb-455c-46a0-9f32-ee7d54043dae','2022-09-28 07:52:57'),(1070,'46043760-926f-4ae1-a719-69ffa9110c63','c8b44d90-bd34-4895-ad41-bdd76ff0b475','2022-09-28 10:31:09'),(1070,'4e495cd7-63c8-454c-9bf0-7d67561e6cb3','c8b44d90-bd34-4895-ad41-bdd76ff0b475','2022-09-28 10:31:09'),(2,'50518be0-3eb3-4029-88c2-d0a0d6456005','31f454d0-a75f-4f4e-a3a4-bfd0a475806a','2022-07-12 12:28:29'),(1070,'542f6fdd-deb5-4069-9ffd-1920238b4944','b9f77799-d642-4773-a67d-d83f37e0c814','2022-09-28 07:52:45'),(1070,'55e7cd59-5166-47a6-b030-0fcdac85813a','3149b0eb-455c-46a0-9f32-ee7d54043dae','2022-09-28 07:52:57'),(1070,'67721e35-4f2b-4d59-8fc9-27a5080677ac','36baf7e7-c8ea-4a9d-a7b2-703b4c4491db','2022-10-04 14:03:28'),(1070,'6e0f3643-79b8-4ea3-9648-dd038133461a','9a0912c7-d649-4d0a-bc0d-b26ae74ab1f4','2022-10-05 14:17:30'),(1070,'70f41a6e-b645-414e-ad3f-15b109417c41','311bf037-40e8-468f-8a4a-808858eebfc0','2022-09-28 10:04:59'),(1070,'72fa704c-5190-4948-97eb-06a12bf88d88','b9b9342b-1007-4281-a39d-27fce0f4ba30','2022-09-28 09:57:55'),(1070,'74cd0086-0d00-4ace-97ab-4159da8b8e39','3504d59a-bb7a-48ed-a241-cbf017371fe1','2022-09-28 10:08:47'),(1070,'83f70326-23c7-4dbf-9860-8381656dc944','30d758b6-ddfe-4e9e-8a14-4e24d25340f8','2022-09-28 08:25:02'),(1070,'871dac18-caf7-4512-ad99-8286e63acba8','3433b381-75f3-4923-a597-d5a8ae24ecfc','2022-09-28 07:52:56'),(1070,'903be239-1532-467c-b347-3dbedcddd39c','87171523-80e9-4f42-a13e-91213d9fba55','2022-10-11 08:19:07'),(1070,'93369612-fcc2-40f5-973b-2e25a1aad15f','b9b9342b-1007-4281-a39d-27fce0f4ba30','2022-09-28 09:57:55'),(1070,'96a9cd8f-c93d-469b-bc0f-b1f73f5ed48d','9a0912c7-d649-4d0a-bc0d-b26ae74ab1f4','2022-10-05 14:17:30'),(1070,'a471032c-be9c-41e2-867c-cdc2b0a0aacc','311bf037-40e8-468f-8a4a-808858eebfc0','2022-09-28 10:04:59'),(1070,'b182ab37-719d-4f9e-a021-5e3d36cbf4a9','87171523-80e9-4f42-a13e-91213d9fba55','2022-10-11 08:24:21'),(1070,'b2d0f595-cf10-4c2c-a0af-576b1acc91e1','3433b381-75f3-4923-a597-d5a8ae24ecfc','2022-09-28 07:52:56'),(1070,'b31a604f-aad9-4b46-ae60-d0f8236024dc','87171523-80e9-4f42-a13e-91213d9fba55','2022-10-11 08:19:07'),(1070,'b8a66c39-1515-46c0-a8a6-d91c5072c595','b9f77799-d642-4773-a67d-d83f37e0c814','2022-09-28 07:52:45'),(1070,'c7b982b0-290e-4de0-8b65-2312e7e50d0a','7cf94db9-9efe-4581-b4a5-28fec7ee4559','2022-09-28 07:57:35'),(1070,'d014d1ea-ae79-475d-879c-b4baa0fd0bb4','c0b45e70-6cd8-404b-a997-a61d85ce9721','2022-09-28 10:52:54'),(1070,'d1137d2c-21ea-4b96-9cda-905c965b58a9','521bad12-deec-4508-b53a-7e46a707e6a8','2022-09-28 10:39:31'),(1070,'dfcd1aa1-f018-48b8-b0ee-4f8dec4766f3','7cf94db9-9efe-4581-b4a5-28fec7ee4559','2022-09-28 07:57:35'),(1070,'e42db71f-5f8f-48fe-927f-1c02f44ce74b','30d758b6-ddfe-4e9e-8a14-4e24d25340f8','2022-09-28 08:25:02'),(1070,'eae18c2a-a124-494e-b74d-367ddd672894','4d78c4e6-43de-4778-a97a-744a71ad8f47','2022-09-28 07:52:56'),(1070,'ed2dc359-0368-4546-be96-237419080291','87171523-80e9-4f42-a13e-91213d9fba55','2022-10-11 08:32:24'),(1070,'ef72c69a-cbce-448c-b0d1-ed1482052bf7','25167fd5-d99b-4723-9e78-c5acb6642934','2022-09-28 09:41:13'),(2,'f01e9a2b-b7af-4333-905b-4804006558f1','31f454d0-a75f-4f4e-a3a4-bfd0a475806a','2022-07-12 12:28:29'),(1070,'f1ca63b0-423b-42b1-9293-fecb66f0c028','3504d59a-bb7a-48ed-a241-cbf017371fe1','2022-09-28 10:08:47'),(1070,'f5d1f38f-62c0-465e-8172-9c84cedbcacf','36baf7e7-c8ea-4a9d-a7b2-703b4c4491db','2022-10-04 14:03:28');
/*!40000 ALTER TABLE `ScanFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SentAttachment`
--

DROP TABLE IF EXISTS `SentAttachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SentAttachment` (
  `ownerID` mediumint unsigned NOT NULL DEFAULT '0',
  `sentMessageID` char(36) NOT NULL,
  `fileID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`sentMessageID`,`fileID`),
  KEY `fk_SentAttachment_SentMessage` (`sentMessageID`,`ownerID`),
  KEY `fk_SentAttachment_CondorFile` (`fileID`,`ownerID`),
  CONSTRAINT `fk_SentAttachment_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_SentAttachment_SentMessage` FOREIGN KEY (`sentMessageID`, `ownerID`) REFERENCES `SentMessage` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SentAttachment`
--

LOCK TABLES `SentAttachment` WRITE;
/*!40000 ALTER TABLE `SentAttachment` DISABLE KEYS */;
/*!40000 ALTER TABLE `SentAttachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SentMessage`
--

DROP TABLE IF EXISTS `SentMessage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SentMessage` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `created` datetime DEFAULT NULL,
  `subject` varchar(45) NOT NULL,
  `body` text,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `discussionID` char(36) NOT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_SentMessage_Discussion` (`discussionID`,`ownerID`),
  CONSTRAINT `fk_SentMessage_Discussion` FOREIGN KEY (`discussionID`, `ownerID`) REFERENCES `Discussion` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SentMessage`
--

LOCK TABLES `SentMessage` WRITE;
/*!40000 ALTER TABLE `SentMessage` DISABLE KEYS */;
/*!40000 ALTER TABLE `SentMessage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SentOrderNotification`
--

DROP TABLE IF EXISTS `SentOrderNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SentOrderNotification` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `orderID` char(36) DEFAULT NULL,
  `recipientID` char(36) DEFAULT NULL,
  `rescueData` text,
  `deliveryDate` datetime DEFAULT NULL,
  `event` enum('edited','validated','cancelled') NOT NULL DEFAULT 'edited',
  `unread` tinyint(1) NOT NULL DEFAULT '1',
  `createdAt` datetime NOT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_SentOrderNotification_Professional` (`ownerID`),
  KEY `fk_SentOrderNotification_Contact` (`recipientID`,`ownerID`),
  KEY `fk_SentOrderNotification_ProstheticOrder` (`orderID`,`ownerID`),
  CONSTRAINT `fk_SentOrderNotification_Contact` FOREIGN KEY (`recipientID`, `ownerID`) REFERENCES `Contact` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_SentOrderNotification_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_SentOrderNotification_ProstheticOrder` FOREIGN KEY (`orderID`, `ownerID`) REFERENCES `ProstheticOrder` (`id`, `ownerID`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SentOrderNotification`
--

LOCK TABLES `SentOrderNotification` WRITE;
/*!40000 ALTER TABLE `SentOrderNotification` DISABLE KEYS */;
/*!40000 ALTER TABLE `SentOrderNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Session`
--

DROP TABLE IF EXISTS `Session`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Session` (
  `ownerID` mediumint unsigned NOT NULL DEFAULT '0',
  `id` char(36) NOT NULL,
  `comments` mediumtext,
  `actID` char(36) NOT NULL,
  `globalDisplayID` mediumint unsigned DEFAULT NULL,
  `displayID` mediumint unsigned DEFAULT NULL,
  `mandibuleOcclusionPlyID` char(36) DEFAULT NULL,
  `maxillaireOcclusionPlyID` char(36) DEFAULT NULL,
  `matrixTransformationMandibuleID` char(36) DEFAULT NULL,
  `matrixTransformationMaxillaireID` char(36) DEFAULT NULL,
  `snapshotID` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `createdAt` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Occlusion_Work` (`actID`,`ownerID`),
  KEY `fk_Session_CondorFile_mandibulePly` (`mandibuleOcclusionPlyID`,`ownerID`),
  KEY `fk_Session_CondorFile_matrixTransformationMandibule` (`matrixTransformationMandibuleID`,`ownerID`),
  KEY `fk_Session_CondorFile_maxillairePly` (`maxillaireOcclusionPlyID`,`ownerID`),
  KEY `fk_Session_CondorFile_matrixTransformationMaxillaire` (`matrixTransformationMaxillaireID`,`ownerID`),
  KEY `fk_Session_CondorFile_maxillairePointContact` (`ownerID`),
  KEY `fk_Session_CondorFile_snapshot` (`snapshotID`,`ownerID`),
  CONSTRAINT `fk_Session_Act` FOREIGN KEY (`actID`, `ownerID`) REFERENCES `Act` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_Session_CondorFile_mandibulePly` FOREIGN KEY (`mandibuleOcclusionPlyID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Session_CondorFile_matrixTransformationMandibule` FOREIGN KEY (`matrixTransformationMandibuleID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Session_CondorFile_matrixTransformationMaxillaire` FOREIGN KEY (`matrixTransformationMaxillaireID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Session_CondorFile_maxillairePly` FOREIGN KEY (`maxillaireOcclusionPlyID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Session_CondorFile_snapshot` FOREIGN KEY (`snapshotID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Session`
--

LOCK TABLES `Session` WRITE;
/*!40000 ALTER TABLE `Session` DISABLE KEYS */;
INSERT INTO `Session` VALUES (1070,'0f5c4a59-4ba6-450c-b1af-60f260538067','Sous dossier 2','fed44659-c88d-4999-98a9-6fbf04832e0c',1,2,NULL,NULL,NULL,NULL,NULL,'2022-07-21 10:26:07','2022-07-21 10:26:07','2022-07-21 08:26:07','2022-07-21 10:25:58','2022-07-21 10:25:58'),(1070,'2209d1b9-4da1-4054-814c-5a760347d91d','Sous dossier 1','fdc3ebc0-c2b2-440e-bad8-5b030b506f78',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-05 16:17:35','2022-10-05 14:17:35','2022-10-05 16:17:31','2022-10-05 16:10:25'),(1070,'2b80b6e9-92bb-44ac-805a-0fc33a5482ee','Sous dossier 2','73bcc057-45f9-4b30-beee-c755ad473b8b',1,2,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-13 09:18:53','2022-10-13 07:18:53','2022-10-13 08:59:35','2022-10-13 08:59:35'),(1070,'3666e5c7-80c2-4717-8bcb-4635d69b4a96','Sous dossier 1','7a6d9986-071b-44b7-b838-56876454bad4',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-03 11:41:32','2022-10-03 09:41:32','2022-09-28 12:08:47','2022-09-28 11:35:55'),(1070,'3a46ea6c-42e7-433a-95cf-cd20cf156420','Sous dossier 1','fed44659-c88d-4999-98a9-6fbf04832e0c',1,1,NULL,NULL,NULL,NULL,NULL,'2022-07-21 15:40:40','2022-07-21 15:40:40','2022-07-21 13:40:40','2022-07-21 15:39:54','2022-07-21 10:14:05'),(1070,'43aeabda-c8ed-48bc-afa5-944faf56b227','Sous dossier 2','8463efb2-00a2-451c-a82d-11d0968960c9',1,2,NULL,NULL,NULL,NULL,NULL,'2022-07-21 10:14:07','2022-07-21 10:14:07','2022-07-21 08:14:07','2022-07-21 10:13:33','2022-07-21 10:13:33'),(1070,'4e8bb869-cbd8-4f20-a300-bc069b6cfa71','Sous dossier 1','9944d852-48ee-43ef-902e-6898dfddd53d',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-10 10:18:27','2022-10-10 08:18:27','2022-10-10 09:59:47','2022-10-10 09:59:47'),(1070,'663dd3fd-394d-441f-91d2-05191b204962','Sous dossier 3','73bcc057-45f9-4b30-beee-c755ad473b8b',1,3,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-13 09:18:51','2022-10-13 07:18:51','2022-10-13 08:59:36','2022-10-13 08:59:36'),(1070,'83c089fd-71f7-41a8-b874-1591def47b38','Sous dossier 3','fed44659-c88d-4999-98a9-6fbf04832e0c',1,3,NULL,NULL,NULL,NULL,NULL,'2022-07-21 15:40:33','2022-07-21 15:40:33','2022-07-21 13:40:33','2022-07-21 15:40:12','2022-07-21 15:40:12'),(2,'8f3430ca-19b8-49d4-bc0a-125d43decc54','Sous dossier 1','cea83c4d-fcc2-4d2c-b98d-b94ce3ad5d51',409,1,NULL,NULL,NULL,NULL,NULL,NULL,'2021-06-24 15:48:28','2021-06-24 13:48:28','2021-06-24 15:48:26','2021-06-24 15:47:28'),(2,'ae710858-ba34-4d33-8c42-3028ce12760f','Sous dossier 1','317b641b-5518-4198-9556-97fc2489ffeb',409,1,NULL,NULL,NULL,NULL,NULL,'2021-06-24 15:49:31','2021-06-24 15:46:35','2021-06-24 13:49:31','2021-06-24 15:46:32','2021-06-24 15:46:32'),(1070,'b218d0b0-9a2a-49ea-b229-6495a2a4ae37','Sous dossier 5','fed44659-c88d-4999-98a9-6fbf04832e0c',1,5,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-21 16:06:11','2022-07-21 14:06:11','2022-07-21 15:46:40','2022-07-21 15:40:14'),(1070,'b98288d5-cb60-443a-8de1-2b0562c07a1c','Sous dossier 1','0384da3d-ecfb-491d-b4c6-55a01abee13b',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-10 15:34:45','2022-10-10 13:34:45','2022-10-10 15:34:41','2022-10-10 15:34:41'),(2,'bf6aab3b-87a2-40d8-88a0-1b221d68e62e','Sous dossier 1','d1b217f0-7ea8-4abe-8052-9d91aae0f74d',409,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-12 12:28:29','2022-07-12 14:28:29','2022-07-12 14:27:17'),(1070,'c79bcfde-2b96-4152-b7ff-be8fb2f49261','Sous dossier 1','8463efb2-00a2-451c-a82d-11d0968960c9',1,1,NULL,NULL,NULL,NULL,NULL,'2022-07-21 10:13:41','2022-07-21 10:13:41','2022-07-21 08:13:41','2022-07-21 10:13:30','2022-07-21 10:10:50'),(1070,'ce4d3ca4-dc3a-46cb-aa8a-108d7be41a7f','Sous dossier 1','8532a281-c902-48f3-94fd-a2a4f4101fb7',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-04 16:03:32','2022-10-04 14:03:32','2022-10-04 16:03:29','2022-10-04 15:42:15'),(1070,'d3b06f3d-a4b5-4db4-81f7-39b33c210472','Sous dossier 1','73bcc057-45f9-4b30-beee-c755ad473b8b',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-11 10:32:27','2022-10-11 08:32:27','2022-10-11 10:32:25','2022-10-11 09:33:02'),(1070,'e012d1cf-0c3a-47ba-967b-ab39afcbd19e','Sous dossier 2','7a6d9986-071b-44b7-b838-56876454bad4',1,2,NULL,NULL,NULL,NULL,NULL,'2022-09-28 12:19:08',NULL,'2022-09-28 10:19:08','2022-09-28 12:18:56','2022-09-28 12:18:56'),(1070,'e9fbefb3-e2af-4fe4-ac5f-0495636df2cc','Sous dossier 1','3a07530a-c8e3-4403-a4ac-311ed81204d1',1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-03 11:41:36','2022-10-03 09:41:36','2022-09-28 12:20:18','2022-09-28 09:44:22'),(1070,'ea7ca0ea-51ca-4a55-8cf5-cfec2f762fa2','Sous dossier 2','3a07530a-c8e3-4403-a4ac-311ed81204d1',1,2,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-03 11:41:33','2022-10-03 09:41:33','2022-09-28 12:52:56','2022-09-28 11:33:53'),(1070,'f485cc8f-1edf-4448-a64d-670a87541e0a','Sous dossier 1','2c6fd0d6-7657-4a9a-ab01-1ca685fe9373',1,1,NULL,NULL,NULL,NULL,NULL,'2022-07-21 10:27:45',NULL,'2022-07-21 08:27:45','2022-07-21 10:27:41','2022-07-21 10:27:41'),(1070,'fcd55245-7935-4543-b1f8-b68c7cbd6cea','Sous dossier 4','fed44659-c88d-4999-98a9-6fbf04832e0c',1,4,NULL,NULL,NULL,NULL,NULL,'2022-07-21 15:40:23',NULL,'2022-07-21 13:40:23','2022-07-21 15:40:13','2022-07-21 15:40:13');
/*!40000 ALTER TABLE `Session` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SharedOffices`
--

DROP TABLE IF EXISTS `SharedOffices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SharedOffices` (
  `ownerID` mediumint unsigned NOT NULL,
  `office1ID` char(36) NOT NULL,
  `office2ID` char(36) NOT NULL,
  `sharedDataType` enum('ALL','CONTACTS') NOT NULL DEFAULT 'CONTACTS',
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  PRIMARY KEY (`office1ID`,`office2ID`,`ownerID`),
  KEY `fk_SharedOffices_Office_1` (`office1ID`,`ownerID`),
  KEY `fk_SharedOffices_Office_2` (`office2ID`,`ownerID`),
  CONSTRAINT `fk_SharedOffices_Office_1` FOREIGN KEY (`office1ID`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_SharedOffices_Office_2` FOREIGN KEY (`office2ID`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SharedOffices`
--

LOCK TABLES `SharedOffices` WRITE;
/*!40000 ALTER TABLE `SharedOffices` DISABLE KEYS */;
/*!40000 ALTER TABLE `SharedOffices` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `SharedOffices_BEFORE_INSERT` BEFORE INSERT ON `SharedOffices` FOR EACH ROW BEGIN
    IF EXISTS (
		SELECT 1 FROM SharedOffices WHERE
		(office1ID=NEW.office2ID AND office2ID=NEW.office1ID)
		OR
		(office1ID=NEW.office1ID AND office2ID=NEW.office2ID)
	) THEN
        SIGNAL SQLSTATE '45000' SET MESSAGE_TEXT = 'Try to insert an existing pair of keys';
    END IF;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `SmilersOrder`
--

DROP TABLE IF EXISTS `SmilersOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SmilersOrder` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `actID` char(36) NOT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `title` varchar(64) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `status` enum('not_sent','waiting_wow_api','sending_wow_api','sending_smilers_api','sent','cancelled') NOT NULL DEFAULT 'waiting_wow_api',
  `createdAt` datetime NOT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `json` text NOT NULL,
  `metadata` text NOT NULL,
  `tag` varchar(250) DEFAULT NULL,
  `localDisplayID` int unsigned DEFAULT NULL,
  `globalDisplayID` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_SmilersOrder_Act` (`actID`,`ownerID`),
  CONSTRAINT `fk_SmilersOrder_Act` FOREIGN KEY (`actID`, `ownerID`) REFERENCES `Act` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SmilersOrder`
--

LOCK TABLES `SmilersOrder` WRITE;
/*!40000 ALTER TABLE `SmilersOrder` DISABLE KEYS */;
/*!40000 ALTER TABLE `SmilersOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SmilersOrderFile`
--

DROP TABLE IF EXISTS `SmilersOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SmilersOrderFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `orderID` char(36) NOT NULL,
  `fileID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`orderID`,`fileID`),
  KEY `fk_SmilersOrderFile_SmilersOrder` (`orderID`,`ownerID`),
  KEY `fk_SmilersOrderFile_CondorFile` (`fileID`,`ownerID`),
  CONSTRAINT `fk_SmilersOrderFile_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_SmilersOrderFile_SmilersOrder` FOREIGN KEY (`orderID`, `ownerID`) REFERENCES `SmilersOrder` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SmilersOrderFile`
--

LOCK TABLES `SmilersOrderFile` WRITE;
/*!40000 ALTER TABLE `SmilersOrderFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `SmilersOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SyncInfo`
--

DROP TABLE IF EXISTS `SyncInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SyncInfo` (
  `id` mediumint unsigned NOT NULL,
  `ownerID` mediumint unsigned NOT NULL,
  `patientsLastRetrieved` datetime DEFAULT NULL,
  `actsLastRetrieved` datetime DEFAULT NULL,
  `sessionsLastRetrieved` datetime DEFAULT NULL,
  `scansLastRetrieved` datetime DEFAULT NULL,
  `ordersLastRetrieved` datetime DEFAULT NULL,
  `assistantsLastRetrieved` datetime DEFAULT NULL,
  `contactsLastRetrieved` datetime DEFAULT NULL,
  `discussionsLastRetrieved` datetime DEFAULT NULL,
  `messagesLastRetrieved` datetime DEFAULT NULL,
  `notificationsLastRetrieved` datetime DEFAULT NULL,
  `occlusionsLastRetrieved` datetime DEFAULT NULL,
  `circleordersLastRetrieved` datetime DEFAULT NULL,
  `smilersordersLastRetrieved` datetime DEFAULT NULL,
  `prostheticSheetsLastRetrieved` datetime DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `idx_SyncInfo_Professional` (`ownerID`),
  CONSTRAINT `fk_SyncInfo_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SyncInfo`
--

LOCK TABLES `SyncInfo` WRITE;
/*!40000 ALTER TABLE `SyncInfo` DISABLE KEYS */;
INSERT INTO `SyncInfo` VALUES (1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,8,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,28,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,33,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,59,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,155,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,172,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,177,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,193,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,224,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,317,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,339,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,355,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,375,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,377,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,421,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,568,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,652,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,664,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,681,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,689,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,722,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,805,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,838,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,850,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,899,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,916,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,917,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,918,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,941,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,1055,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,1070,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1,1071,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `SyncInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SystemNotification`
--

DROP TABLE IF EXISTS `SystemNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SystemNotification` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `event` enum('no_connection_for_x_days') NOT NULL DEFAULT 'no_connection_for_x_days',
  `unread` tinyint(1) NOT NULL DEFAULT '1',
  `createdAt` datetime NOT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_SystemNotification_Professional` (`ownerID`),
  CONSTRAINT `fk_SystemNotification_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SystemNotification`
--

LOCK TABLES `SystemNotification` WRITE;
/*!40000 ALTER TABLE `SystemNotification` DISABLE KEYS */;
/*!40000 ALTER TABLE `SystemNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Token`
--

DROP TABLE IF EXISTS `Token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Token` (
  `id` char(36) NOT NULL,
  `ownerID` mediumint unsigned NOT NULL,
  `created` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `token` char(200) NOT NULL,
  `credentialsId` char(36) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '',
  `context` varchar(40) DEFAULT NULL,
  `device` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  UNIQUE KEY `un_Token` (`token`),
  KEY `IDX_9EF68E3F818B3C83` (`credentialsId`),
  CONSTRAINT `fk_Token_Credentials` FOREIGN KEY (`credentialsId`) REFERENCES `Credentials` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Token`
--

LOCK TABLES `Token` WRITE;
/*!40000 ALTER TABLE `Token` DISABLE KEYS */;
INSERT INTO `Token` VALUES ('27019185-0ee7-49e6-914d-2104902d5e69',1070,NULL,'2022-10-13 08:23:28','faa2483467a1f0305fe34bdf62830303ecb798f7','0c1df5f3-d1f7-47cf-8ef2-6256c08b396a',NULL,NULL),('892ec227-b54b-4d6c-bab3-150c82bdc5c8',2,NULL,'2022-07-12 12:26:46','5a82849b9844d826dfa8919e4826989362ed4375','00000002-0000-0000-0000-000000000001',NULL,NULL);
/*!40000 ALTER TABLE `Token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ToothInfo`
--

DROP TABLE IF EXISTS `ToothInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ToothInfo` (
  `ownerID` mediumint unsigned NOT NULL,
  `toothNumber` tinyint unsigned NOT NULL,
  `prostheticSheetID` char(36) NOT NULL,
  `toothColor` tinytext,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`toothNumber`,`prostheticSheetID`),
  KEY `idx_ToothInfo_Order` (`ownerID`),
  KEY `fk_ToothInfo_ProstheticSheet` (`prostheticSheetID`),
  CONSTRAINT `fk_ToothInfo_ProstheticSheet` FOREIGN KEY (`prostheticSheetID`) REFERENCES `ProstheticSheet` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ToothInfo`
--

LOCK TABLES `ToothInfo` WRITE;
/*!40000 ALTER TABLE `ToothInfo` DISABLE KEYS */;
/*!40000 ALTER TABLE `ToothInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `__db_version__`
--

DROP TABLE IF EXISTS `__db_version__`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `__db_version__` (
  `id` int NOT NULL AUTO_INCREMENT,
  `version_major` int NOT NULL DEFAULT '0',
  `version_minor` int NOT NULL DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `migration_file` varchar(1024) DEFAULT NULL,
  `commit` varchar(255) DEFAULT NULL,
  `version_core` varchar(255) DEFAULT NULL,
  `version_IHM` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=72 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `__db_version__`
--

LOCK TABLES `__db_version__` WRITE;
/*!40000 ALTER TABLE `__db_version__` DISABLE KEYS */;
INSERT INTO `__db_version__` VALUES (1,1,15,'v1.15','','','1.9.0','2.0.4'),(2,1,18,'v1.18','migration_fileconstraint_local','','1.9.0','2.0.4'),(3,1,19,'v1.19','migration_fileconstraint_local','','1.9.0','2.0.4'),(4,1,20,'v1.20','migration_globalDisplayID_local','','1.9','2.0.4'),(5,1,21,'v1.21','migration_config_show_open_stl_warning_local','','1.9','2.0.4'),(6,1,22,'v1.22','migration_resetcontact_local','','1.9','2.0.4'),(7,1,23,'v1.23','migration_token_context_device_local','','1.9','2.0.4'),(8,1,24,'v1.24','migration_config_lag_and_lost_sound_local','','1.9','2.0.4'),(9,1,25,'v1.25','migration_fix_unset_scan_creator_local','','1.9.0','2.0.4'),(10,1,26,'v1.26','migration_fix_wrong_original_files_local','','1.9.0','2.0.4'),(11,1,27,'v1.27','migration_occlusion_display_id_local','','1.9','2.0.4'),(12,1,28,'v1.28','migration_selfdiscussions_local','','1.9','2.0.4'),(13,1,29,'v1.29','migration_config_show_delete_confirmation_local','','1.9','2.0.4'),(14,1,30,'v1.30','migration_config_email_notifications_local','','1.9','2.0.4'),(15,1,31,'v1.31','migration_config_last_synced_local','','1.9','2.0.4'),(16,1,32,'v1.32','migration_lastmodified_local','','1.9','2.0.4'),(17,1,33,'v1.33','migration_config_add_fields_flip_local','','1.9','2.0.4'),(18,1,34,'v1.34','migration_unread_local','','1.9','2.0.4'),(19,1,35,'v1.35','migration_work_last_accessed_local','','1.9','2.0.4'),(20,1,36,'v1.36','migration_config_show_sync_info_local','','1.9','2.0.4'),(21,1,37,'v1.37','migration_config_clean_deprecated_fields_local','','1.9','2.0.4'),(22,1,38,'v1.38','migration_act_refonte_local','','1.9','2.0.4'),(23,1,39,'v1.39','migration_fix_duplicate_screenshot_path_local','','1.9','2.0.4'),(24,1,40,'v1.40','migration_rework_local','','1.9.0','2.0.4'),(25,1,41,'v1.41','migration_sync_info_local','','1.9.0','1.1-3'),(26,1,42,'v1.42','migration_config_popup_flip','','1.9','2.0.4'),(27,1,43,'v1.43','migration_mark_contacts_invisible_local','','1.9','3.2.1'),(28,1,44,'v1.44','migration_config_show_margin_lines_warning_local','','1.9','2.0.4'),(29,1,45,'v1.45','migration_contact_invitation_local','','1.9','2.3.0'),(30,1,46,'v1.46','migration_received_order_local','','1.9','3.3.0'),(31,1,47,'v1.47','migration_merge_discussions_local','','1.9','3.3.1'),(32,1,48,'v1.48','migration_office_rename_email_local','','1.9','3.3.1'),(33,1,49,'v1.49','migration_contact_cannot_reject_self_local','','1.9','3.3.1'),(34,1,50,'v1.50','migration_discussion_deletedat_not_null_local','','1.9','3.3.1'),(35,1,51,'v1.51','migration_reset_condor_file_trigger_local','','1.9','3.3.1'),(36,1,52,'v1.52','migration_system_notification_local','','1.9','2.3.0'),(37,1,53,'v1.53','migration_add_last_connection_checked_professional_local','','1.9','3.4.0'),(38,1,54,'v1.54','migration_endless_scans_local','','1.9','3.4.0'),(39,1,55,'v1.55','migration_rename_act_session_local','','1.9','3.4.0'),(40,1,56,'v1.56','migration_sessionId_local','','1.9','3.4.0'),(41,1,57,'v1.57','migration_session_created_at_local','','1.9','3.4.0'),(42,1,58,'v1.58','migration_order_display_id_local','','1.9','3.4.0'),(43,1,59,'v1.59','migration_pin_patient_local','','1.9','1.0.0'),(44,1,60,'v1.60','migration_enable_upload_local','','3.4.0','1.0.1'),(45,1,61,'v1.61','migration_remove_occlusion_contact_local','','3.4.1','1.1.0'),(46,1,62,'v1.62','migration_scanid_local','','3.4.1','1.1.0'),(47,1,63,'v1.63','migration_circleorder_local','','3.4.1','1.1.0'),(48,1,64,'v1.64','migration_smilersorder_local','','4.1.0','2.1.0'),(49,1,65,'v1.65','migration_demo_professional','','4.1.0','2.1.0'),(50,1,66,'v1.66','migration_tracking_rectangle','','4.1.0','2.1.1'),(51,1,67,'v1.67','migration_fix_status_circle_smilers','','4.1.0','2.1.1'),(52,1,68,'v1.68','migration_remove_scansID_session_local','','4.2.0','2.1.1'),(53,1,69,'v1.69','migration_externalize_occlusion_local','','4.2.0','2.1.1'),(54,1,70,'v1.70','migration_scan_occlusion_trigger_local','','4.2.0','2.1.1'),(55,1,74,'v1.74','migration_fix_xxxinfo_local','','4.3.0','2.2.3'),(56,1,71,'v1.71','migration_add_date_created_scan_local','','4.2.0','2.1.1'),(57,1,72,'v1.72','migration_scan_status_local','','4.2.0','2.1.1'),(58,1,73,'v1.73','migration_remove_patient_personnal_data_local','','4.2.0','2.1.1'),(59,1,75,'v1.75','migration_add_displayid_occlusion_local','','4.3.0','2.3.3'),(60,1,76,'v1.76','migration_add_table_ProstheticSheet_local','','4.4.0','2.3.4'),(61,1,77,'v1.77','migration_status_smilers_circle_local','','4.2.0','2.4.0'),(62,1,78,'v1.78','migration_condor_local_1.78_patient_theme','','4.4.0','2.4.0'),(63,1,79,'v1.79','migration_condor_local_1.79_fix_order_recipient','','4.5.0','2.4.4'),(64,1,80,'v1.80','migration_condor_local_1.80_fix_order','','4.5.0','2.4.4'),(65,1,81,'v1.81','migration_condor_local_1.81_fix_theme_null','','4.5.0','2.4.4'),(66,1,82,'v1.82','migration_condor_local_1.82_fix_wow_data','','5.0.0','3.0.1'),(67,1,83,'v1.83','migration_condor_local_1.83_remove_ownerid','','5.0.0','3.0.1'),(68,1,84,'v1.84','migration_condor_local_1.84_generate_professional_env_infos','','5.0.0','3.0.1'),(69,1,85,'v1.85','migration_condor_local_1.85_add_updatedat_professional_env_infos','','5.0.0','3.0.1'),(70,1,86,'v1.86','migration_condor_local_1.86_update_token','','5.0.0','3.0.1'),(71,1,87,'v1.87','migration_condor_local_1.87_add_galaxy_status','','5.0.0','3.0.1');
/*!40000 ALTER TABLE `__db_version__` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping routines for database 'condor'
--
/*!50003 DROP FUNCTION IF EXISTS `generateid` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `generateid`(maxchars int) RETURNS char(36) CHARSET utf8mb3
BEGIN

  DECLARE AllChars char(16);
  DECLARE currentStr CHAR(36);
  DECLARE p1 int;
  
  SET AllChars = 'abcdef0123456789'; 
  SET currentStr = '';
  SET p1 = 0;

  charLoop: LOOP
  
    IF p1 < maxchars THEN
	  SET currentStr = CONCAT(currentStr, substring(AllChars, (RAND()*15)+1, 1));
	  SET p1 = p1 + 1;
      
      ITERATE charLoop;
    END IF;
    
    LEAVE charLoop;
    
  END LOOP charLoop;
  
  RETURN currentStr;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `uuid_v4` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `uuid_v4`() RETURNS char(36) CHARSET utf8mb4
    NO SQL
BEGIN
    
    SET @h1 = LPAD(HEX(FLOOR(RAND() * 0xffff)), 4, '0');
    SET @h2 = LPAD(HEX(FLOOR(RAND() * 0xffff)), 4, '0');
    SET @h3 = LPAD(HEX(FLOOR(RAND() * 0xffff)), 4, '0');
    SET @h6 = LPAD(HEX(FLOOR(RAND() * 0xffff)), 4, '0');
    SET @h7 = LPAD(HEX(FLOOR(RAND() * 0xffff)), 4, '0');
    SET @h8 = LPAD(HEX(FLOOR(RAND() * 0xffff)), 4, '0');

    
    SET @h4 = CONCAT('4', LPAD(HEX(FLOOR(RAND() * 0x0fff)), 3, '0'));

    
    SET @h5 = CONCAT(HEX(FLOOR(RAND() * 4 + 8)),
                LPAD(HEX(FLOOR(RAND() * 0x0fff)), 3, '0'));

    
    RETURN LOWER(CONCAT(
        @h1, @h2, '-', @h3, '-', @h4, '-', @h5, '-', @h6, @h7, @h8
    ));
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `drop_fk_if_exists` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `drop_fk_if_exists`(in theTable varchar(128), in theFKName varchar(128) )
BEGIN
 IF((SELECT COUNT(*) AS fk_exists
     FROM information_schema.table_constraints
     WHERE TABLE_SCHEMA = DATABASE() AND table_name = theTable AND constraint_name = theFKName AND constraint_type = 'FOREIGN KEY') > 0)
 THEN
   SET @s = CONCAT('ALTER TABLE ', theTable, ' DROP FOREIGN KEY ' , theFKName);
   PREPARE stmt FROM @s;
   EXECUTE stmt;
 END IF;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `drop_index_if_exists` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `drop_index_if_exists`(in theTable varchar(128), in theIndexName varchar(128) )
BEGIN
 IF((SELECT COUNT(*) AS index_exists
     FROM information_schema.statistics
     WHERE TABLE_SCHEMA = DATABASE() and table_name = theTable AND index_name = theIndexName) > 0)
 THEN
   SET @s = CONCAT('DROP INDEX ' , theIndexName , ' ON ' , theTable);
   PREPARE stmt FROM @s;
   EXECUTE stmt;
 END IF;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `fixOrderFrom176` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `fixOrderFrom176`()
    NO SQL
BEGIN
    SET @script_ok = (SELECT COUNT(*) FROM __db_version__ WHERE version_major = '1' AND version_minor = '76');

	IF (@script_ok = 0) THEN
        SET @count_bad_date = (SELECT COUNT(*) FROM ProstheticOrder WHERE createdAt IS NULL);
        IF (@count_bad_date > 0) THEN
            CALL `script176`();
        ELSE
            SET @count_bad_toothinfo = (SELECT COUNT(*) FROM ToothInfo WHERE prostheticSheetID = '');
            IF (@count_bad_toothinfo > 0) THEN
                DELETE FROM ToothInfo WHERE prostheticSheetID = '';

                ALTER TABLE ToothInfo ADD PRIMARY KEY (ownerID, toothNumber, prostheticSheetID);
                ALTER TABLE ToothInfo DROP COLUMN orderID;

                INSERT INTO `__db_version__`(`version_major`, `version_minor`, `title`, `commit`, `migration_file`, `version_core`, `version_IHM`) VALUES
                    (1, 76, 'v1.76', '', 'migration_condor_local_1.76_add_table_ProstheticSheet_from_180', '4.4.0', '2.3.4');
            END IF;
        END IF;
    END IF;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `FixOrderRecipient` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `FixOrderRecipient`()
    NO SQL
BEGIN
    DECLARE CurOrderOwnerID MEDIUMINT(8) UNSIGNED;
    DECLARE CurOrderUuid CHAR(36);
    DECLARE CurOrderId VARCHAR(255);

    DECLARE NbRecipient INT(8);
    DECLARE DID CHAR(36);
    DECLARE RecipientOwnerId MEDIUMINT(8) UNSIGNED;
    DECLARE RecipientContactId CHAR(36);

    DECLARE exit_loop BOOLEAN DEFAULT FALSE;

    DECLARE CUR CURSOR FOR
        SELECT ownerId, uuid, id
        FROM DebugOrderData
        WHERE id IS NOT NULL;

    DECLARE CONTINUE HANDLER FOR NOT FOUND SET exit_loop = TRUE;

    OPEN CUR;
    read_loop: LOOP
        FETCH CUR INTO CurOrderOwnerID, CurOrderUuid, CurOrderId;

        
        
        IF exit_loop THEN
            CLOSE CUR;
            LEAVE read_loop;
        END IF;

        SET NbRecipient = (SELECT COUNT(*) FROM ProstheticOrderRecipient WHERE orderID = CurOrderUuid);

        IF NbRecipient = 0 THEN
            SET DID = (SELECT discussionID FROM SentMessage WHERE LOCATE(CurOrderId, body) > 0);

            IF DID IS NOT NULL THEN
                SET RecipientOwnerId = (SELECT ownerID FROM Discussion WHERE id = DID AND ownerID != CurOrderOwnerID);

                IF RecipientOwnerId IS NOT NULL THEN
                    SET RecipientContactId = (SELECT id FROM Contact WHERE ownerID = CurOrderOwnerID AND professionalID = RecipientOwnerId);

                    IF RecipientContactId IS NOT NULL THEN
                        INSERT INTO ProstheticOrderRecipient VALUES (CurOrderOwnerID, CurOrderUuid , RecipientContactId, NOW());
                    END IF;
                END IF;
            END IF;
        END IF;
    END LOOP;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `getUsedScansForOcclusion` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `getUsedScansForOcclusion`()
    NO SQL
BLOCK1: BEGIN

  DECLARE CurFileID CHAR(36);
  DECLARE CurFileMetadata TEXT;
  DECLARE CurOwnerID MEDIUMINT(8) UNSIGNED;
  DECLARE CurFileTag TEXT;
  
  DECLARE exit_loop BOOLEAN DEFAULT FALSE;

  DECLARE read_sessionid TEXT;

  DECLARE CUR CURSOR FOR
          SELECT CondorFile.id, CondorFile.metadata, CondorFile.ownerID, CondorFile.tag
          FROM CondorFile WHERE tag LIKE '%_OCC_%' AND metadata LIKE '%"referenceScanID":"%' AND deletedAt IS NULL;
          
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET exit_loop = TRUE;

  OPEN CUR;
  read_loop: LOOP

	  FETCH CUR INTO CurFileID, CurFileMetadata, CurOwnerID, CurFileTag;

		IF exit_loop THEN
			CLOSE CUR;
			LEAVE read_loop;
		END IF;
		
    
		SET @refScanDelimiter = SUBSTRING_INDEX(CurFileMetadata, '"referenceScanID":"', -1); 
		SET @refScanID = SUBSTRING_INDEX(@refScanDelimiter, ':', 1);
        
		SET @actDelemiter = SUBSTRING_INDEX(CurFileTag, '_ACT_', -1); 
        SET @curActID = SUBSTRING_INDEX(@actDelemiter, '_', 1);
		SET @sessionDelemiter = SUBSTRING_INDEX(CurFileTag, '_SESS_', -1); 
        SET @curSessionID = SUBSTRING_INDEX(@sessionDelemiter, '_', 1);
        
        
        
		IF @curActID is NOT NULL AND @curSessionID is NOT NULL THEN
        
			SET @actOwnerID = (SELECT ownerID FROM Act WHERE id = @curActID);
			SET @sessionOwnerID = (SELECT ownerID FROM Session WHERE id = @curSessionID);
            
            
            IF @actOwnerID = CurOwnerID AND @sessionOwnerID = CurOwnerID THEN
            
				SET @scanNo = SUBSTRING_INDEX(@refScanID,'.',-1);
				SET @scanType = '';
				SET @findTopScan = CurFileTag LIKE '%_TOPLY_%';
				SET @findBottomScan = CurFileTag LIKE '%_BOPLY_%';
				
				IF @findTopScan > 0 THEN
					SET @scanType = 'MAXILLAIRE';
				ELSEIF @findBottomScan > 0 THEN
					SET @scanType = 'MANDIBULE';
				ELSE 
					ITERATE read_loop;
				END IF;
                 
                SET @scanID = (SELECT id FROM Scan WHERE ownerID = CurOwnerID AND sessionID = @curSessionID AND displayID = @scanNo AND scanType = @scanType AND deletedAt IS NULL );
				SET @occlusionID =  SUBSTRING_INDEX(SUBSTRING_INDEX(CurFileTag, '_OCC_', -1), '_', 1); 
				
				IF @occlusionID IS NULL THEN 
					ITERATE read_loop;
				END IF;
	
				IF @findTopScan > 0 THEN
					UPDATE Occlusion SET topScanID = @scanID WHERE id = @occlusionID;
				ELSEIF @findBottomScan > 0 THEN
					UPDATE Occlusion SET bottomScanID = @scanID WHERE id = @occlusionID;
				END IF; 
                
            END IF;
		
        END IF;
         
  END LOOP;

END BLOCK1 ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `migrateLifiOcclusionFiles` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `migrateLifiOcclusionFiles`()
    NO SQL
BEGIN

  DECLARE CurOwnerID MEDIUMINT(8) UNSIGNED;
  DECLARE CurFilePath TEXT;
  DECLARE CurFileID CHAR(36);
  DECLARE CurFileTag VARCHAR(250);
  DECLARE CurFileType VARCHAR(250);
  DECLARE CurFileMetadata TEXT;
  
  DECLARE exit_loop BOOLEAN DEFAULT FALSE;
  
  DECLARE read_sessionid TEXT;

  
  DECLARE CUR CURSOR FOR
          SELECT CondorFile.ownerID, CondorFile.id, CondorFile.tag, CondorFile.path, CondorFile.type, CondorFile.metadata
          FROM CondorFile
	  WHERE type LIKE '%LIFI%' AND metadata LIKE '%"isOcclusionMarginLine":true%' AND id NOT IN (SELECT fileID FROM ReceivedAttachment);

  DECLARE CONTINUE HANDLER FOR NOT FOUND SET exit_loop = TRUE;
  
  OPEN CUR;
  read_loop: LOOP

  FETCH CUR INTO CurOwnerID, CurFileID, CurFileTag, CurFilePath, CurFileType, CurFileMetadata;

	
	
	IF exit_loop THEN
		CLOSE CUR;
		LEAVE read_loop;
	END IF;
		
	SET @sessionDelimiter = SUBSTRING_INDEX(CurFileTag, '_SESS_', -1);
        SET @curSessionID = SUBSTRING_INDEX(@sessionDelimiter, '_', 1);
        
	SELECT ownerID, id INTO @occlusionOwnerID, @occlusionID FROM Occlusion WHERE sessionID = @curSessionID;
      
	
        
	IF @occlusionID IS NOT NULL AND @occlusionOwnerID = CurOwnerID THEN

		SET @pleft = SUBSTRING_INDEX(CurFileTag, @curSessionID, 1);
		SET @newTag = CONCAT(@pleft, @curSessionID, '_OCC_', @occlusionID, '_', CurFileType, 'O_', CurFileType, '_');
            
		SET @filename = SUBSTRING_INDEX(CurFilePath, '/', -1);
		SET @scanPath = SUBSTRING_INDEX(CurFilePath, '/', -2);
		SET @sessionPath = SUBSTRING_INDEX(CurFilePath, @scanPath, 1);
		SET @newFilePath = CONCAT(@sessionPath, 'computedocclusion_', @occlusionID, '/', @filename);

		UPDATE CondorFile SET tag = @newTag, path = @newFilePath WHERE id = CurFileID;
             
		
		INSERT INTO OcclusionFile(ownerID, fileID, occlusionID, lastUpdated)
		VALUES (CurOwnerID, CurFileID, @occlusionID, CURRENT_TIMESTAMP);

		
		SET @scanID = (SELECT scanID FROM ScanFile WHERE fileID = CurFileID);

		IF @scanID IS NOT NULL THEN
			SET @scanType = (SELECT scanType FROM Scan WHERE id = @scanID);

			IF @scanType is not NULL THEN
				SET @currentMetadata = SUBSTRING_INDEX(CurFileMetadata, '}', 1);
				SET @lifiScanType = CONCAT('"lifi_scan_type":"', @scanType, '"');
				SET @newMetadata = CONCAT(@currentMetadata, ',', @lifiScanType, '}');

				UPDATE CondorFile SET metadata = @newMetadata WHERE id = CurFileID;
			END IF;

		END IF;

            
            DELETE FROM ScanFile WHERE fileID = CurFileID;

	END IF;

  END LOOP;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `migrateOcclusions` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `migrateOcclusions`()
    NO SQL
BEGIN
  DECLARE CurOwnerID MEDIUMINT(8) UNSIGNED;
  DECLARE CurSessionID CHAR(36);
  DECLARE CurMandibuleOcclusionPlyID CHAR(36);
  DECLARE CurMaxillaireOcclusionPlyID CHAR(36);
  DECLARE CurMatrixTransformationMandibuleID CHAR(36);
  DECLARE CurMatrixTransformationMaxillaireID CHAR(36);
  DECLARE CurSnapshotID CHAR(36);
  
  
  DECLARE TopScanID CHAR(36);
  DECLARE BottomScanID CHAR(36);
  DECLARE CheckIntegrity BOOLEAN DEFAULT FALSE;

  DECLARE NewOcclusionID CHAR(36);
  DECLARE exit_loop BOOLEAN DEFAULT FALSE;

  
  DECLARE CUR CURSOR FOR
          SELECT Session.ownerID, Session.id, Session.mandibuleOcclusionPlyID, Session.maxillaireOcclusionPlyID,
					Session.matrixTransformationMandibuleID, Session.matrixTransformationMaxillaireID, Session.snapshotID
          FROM Session WHERE deletedAt IS NULL AND mandibuleOcclusionPlyID IS NOT NULL AND maxillaireOcclusionPlyID IS NOT NULL AND
					matrixTransformationMandibuleID IS NOT NULL AND matrixTransformationMaxillaireID IS NOT NULL AND snapshotID IS NOT NULL;
          
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET exit_loop = TRUE;

  OPEN CUR;
  read_loop: LOOP

  FETCH CUR INTO CurOwnerID, CurSessionID, CurMandibuleOcclusionPlyID, CurMaxillaireOcclusionPlyID,
					CurMatrixTransformationMandibuleID, CurMatrixTransformationMaxillaireID, CurSnapshotID;

    
    
    IF exit_loop THEN
	CLOSE CUR;
	LEAVE read_loop;
    END IF;

	SET TopScanID = (SELECT scanID from ScanFile WHERE fileID = CurMaxillaireOcclusionPlyID);
    SET BottomScanID = (SELECT scanID from ScanFile WHERE fileID = CurMandibuleOcclusionPlyID);

    
	
	

	
	
    
    SET NewOcclusionID = concat(left(CurSessionID, length(CurSessionID) - 9), 'migraoccl');
	
	INSERT INTO Occlusion(ownerID, id, sessionID, occlusionType, deletedAt, createdAt, lastSynced, lastModified, lastUpdated, topScanID, bottomScanID, 
							anteriorBiteScanID, rightBiteScanID, leftBiteScanID, snapshotID, mandibuleOcclusionPlyID, maxillaireOcclusionPlyID, matrixTransformationMandibuleID, 
							matrixTransformationMaxillaireID)
							VALUES (CurOwnerID, NewOcclusionID, CurSessionID, NULL, NULL, CURRENT_TIMESTAMP, NULL, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP, TopScanID, BottomScanID,
							NULL, NULL, NULL, CurSnapshotID, CurMandibuleOcclusionPlyID, CurMaxillaireOcclusionPlyID, CurMatrixTransformationMandibuleID,
							CurMatrixTransformationMaxillaireID);
	
	
	INSERT INTO OcclusionFile(ownerID, fileID, occlusionID, lastUpdated)
							VALUES (CurOwnerID, CurMandibuleOcclusionPlyID, NewOcclusionID, CURRENT_TIMESTAMP);
	INSERT INTO OcclusionFile(ownerID, fileID, occlusionID, lastUpdated)
							VALUES (CurOwnerID, CurMaxillaireOcclusionPlyID, NewOcclusionID, CURRENT_TIMESTAMP);
	INSERT INTO OcclusionFile(ownerID, fileID, occlusionID, lastUpdated)
							VALUES (CurOwnerID, CurMatrixTransformationMandibuleID, NewOcclusionID, CURRENT_TIMESTAMP);
	INSERT INTO OcclusionFile(ownerID, fileID, occlusionID, lastUpdated)
							VALUES (CurOwnerID, CurMatrixTransformationMaxillaireID, NewOcclusionID, CURRENT_TIMESTAMP);
	INSERT INTO OcclusionFile(ownerID, fileID, occlusionID, lastUpdated)
							VALUES (CurOwnerID, CurSnapshotID, NewOcclusionID, CURRENT_TIMESTAMP);          
    


  END LOOP;
  
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `script176` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `script176`()
    NO SQL
BEGIN
    
    DROP TABLE IF EXISTS `ProstheticSheet`;
    CREATE TABLE `ProstheticSheet` (
        `id` char(36) NOT NULL,
        `ownerID` mediumint(8) unsigned NOT NULL,
        `orderID` char(36) NOT NULL,
        `json` TEXT NOT NULL,
        `pdfFileID` char(36) DEFAULT NULL,
        `dateCreated` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
        `deletedAt` datetime DEFAULT NULL,
        `lastSynced` datetime DEFAULT NULL,
        `lastModified` datetime NOT NULL,
        `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`,`ownerID`),
        CONSTRAINT `fk_ProstheticSheet_ProstheticOrder` FOREIGN KEY (`orderID`) REFERENCES `ProstheticOrder` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
        CONSTRAINT `fk_ProstheticSheet_CondorFile` FOREIGN KEY (`pdfFileID`) REFERENCES `CondorFile` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

    
    UPDATE ProstheticOrder SET createdAt = lastUpdated WHERE createdAt IS NULL;

    
    INSERT INTO ProstheticSheet (id, ownerID, orderID, json, dateCreated, deletedAt, lastSynced, lastModified, lastUpdated)
    SELECT
        PO.id as id,
        PO.ownerID,
        PO.id as orderID,
        CONCAT('{"sheetTitle":"', PO.title, '",', RIGHT(PO.json, LENGTH(PO.json)-1)), 
        PO.createdAt as dateCreated,
        PO.deletedAt,
        PO.lastSynced,
        PO.lastModified,
        PO.lastUpdated
    FROM ProstheticOrder AS PO;

    CREATE TEMPORARY TABLE PDF_ID_TMP
    SELECT POF1.orderID, POF1.fileID, CF1.version, T.maxVersion
    FROM ProstheticOrderFile AS POF1
    INNER JOIN CondorFile AS CF1 ON POF1.fileID = CF1.id
    INNER JOIN (
        SELECT POF2.orderID, MAX(CF2.version) AS maxVersion
        FROM ProstheticOrderFile AS POF2
        INNER JOIN CondorFile AS CF2 ON POF2.fileID = CF2.id
        WHERE CF2.type = 'PDF'
        GROUP BY POF2.orderID
    ) T ON POF1.orderID = T.orderID
    WHERE CF1.type = 'PDF' AND CF1.version = T.maxVersion;

    UPDATE ProstheticSheet AS PS
    INNER JOIN PDF_ID_TMP AS PDF ON PDF.orderID = PS.orderID
    SET PS.pdfFileID = PDF.fileID;

    DROP TEMPORARY TABLE PDF_ID_TMP;

    
    
    

    ALTER TABLE SyncInfo ADD prostheticSheetsLastRetrieved DATETIME NULL AFTER smilersordersLastRetrieved;

    ALTER TABLE ProstheticOrder DROP COLUMN json;

    ALTER TABLE ToothInfo ADD prostheticSheetID char(36) NOT NULL AFTER toothNumber;

    UPDATE ToothInfo AS TI
    INNER JOIN ProstheticSheet AS PS on TI.orderID = PS.orderID
    SET TI.prostheticSheetID = PS.id;

    
    
    

    
    ALTER TABLE ToothInfo DROP FOREIGN KEY fk_ToothInfo_Order;

    
    ALTER TABLE ToothInfo ADD CONSTRAINT `fk_ToothInfo_ProstheticSheet` FOREIGN KEY (`prostheticSheetID`) REFERENCES `ProstheticSheet` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

    ALTER TABLE ToothInfo DROP PRIMARY KEY;
    ALTER TABLE ToothInfo ADD PRIMARY KEY (ownerID, toothNumber, prostheticSheetID);

    ALTER TABLE ToothInfo DROP COLUMN orderID;

    
    
    

    INSERT INTO `__db_version__`(`version_major`, `version_minor`, `title`, `commit`, `migration_file`, `version_core`, `version_IHM`) VALUES
    (1, 76, 'v1.76', '', 'migration_condor_local_1.76_add_table_ProstheticSheet_from_180', '4.4.0', '2.3.4');

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `updateOcclusionsCondorFilesTag` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `updateOcclusionsCondorFilesTag`()
    NO SQL
BEGIN

  DECLARE CurFilePath TEXT;
  DECLARE CurFileID CHAR(36);
  DECLARE CurFileTag VARCHAR(250);
  DECLARE exit_loop BOOLEAN DEFAULT FALSE;
  
  DECLARE read_sessionid TEXT;

  
  DECLARE CUR CURSOR FOR
          SELECT CondorFile.id, CondorFile.tag, CondorFile.path
          FROM CondorFile 
	  WHERE tag REGEXP '_TOMA_|_BOMA_|_TOPLY_|_BOPLY_|_SNAPO_' AND id NOT IN (SELECT fileID FROM ReceivedAttachment);

  DECLARE CONTINUE HANDLER FOR NOT FOUND SET exit_loop = TRUE;

  OPEN CUR;
  read_loop: LOOP

  FETCH CUR INTO CurFileID, CurFileTag, CurFilePath;

	
	
	IF exit_loop THEN
		CLOSE CUR;
		LEAVE read_loop;
	END IF;
		
        SET @sessionDelimiter = SUBSTRING_INDEX(CurFileTag, '_SESS_', -1); 
        SET @curSessionID = SUBSTRING_INDEX(@sessionDelimiter, '_', 1);
        
        
	Set @occlusionID = (SELECT id FROM Occlusion WHERE sessionID = @curSessionID AND deletedAt IS NULL);
      
	IF @occlusionID is not NULL THEN

		SET @pleft = SUBSTRING_INDEX(CurFileTag, @curSessionID, 1); 
		SET @pright = SUBSTRING_INDEX(CurFileTag, @curSessionID, -1); 
		SET @newTag = CONCAT(@pleft, @curSessionID, '_OCC_', @occlusionID, @pright);

		SET @filename = SUBSTRING_INDEX(CurFilePath, '/', -1);
		SET @sessionPath = SUBSTRING_INDEX(CurFilePath, @filename, 1);
		SET @newFilePath = CONCAT(@sessionPath, 'computedocclusion_', @occlusionID, '/', @filename);

		UPDATE CondorFile SET tag = @newTag, path = @newFilePath WHERE id = CurFileID;
        END IF;
        
  END LOOP;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `updateScanDisplayID` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `updateScanDisplayID`()
    NO SQL
BEGIN
  DECLARE CurOwnerID MEDIUMINT(8) UNSIGNED;
  DECLARE CurID CHAR(36);
  DECLARE CurSessionID CHAR(36);
  DECLARE CurLastSync DATETIME;

  DECLARE CurScanType
  ENUM('MAXILLAIRE', 'MANDIBULE', 'MORDU_ANTERIEUR', 'MORDU_POSTERIEUR_GAUCHE', 'MORDU_POSTERIEUR_DROIT');

  DECLARE CurNbSyncScan INT;
  DECLARE CurMaxDisplayID INT;

  DECLARE exit_loop BOOLEAN DEFAULT FALSE;

  DECLARE CUR CURSOR FOR
          SELECT Scan.ownerID, Scan.id, Scan.sessionID, Scan.scanType, Scan.lastSynced
          FROM Scan;

  DECLARE CONTINUE HANDLER FOR NOT FOUND SET exit_loop = TRUE;

  OPEN CUR;
  read_loop: LOOP

  FETCH CUR INTO CurOwnerID, CurID, CurSessionID, CurScanType, CurLastSync;

    
    
    IF exit_loop THEN
	CLOSE CUR;
	LEAVE read_loop;
    END IF;

    IF CurLastSync IS NULL THEN

	SET CurNbSyncScan = (SELECT COUNT(*)
				FROM Scan
				WHERE ownerID = CurOwnerID AND sessionID = CurSessionID AND scanType = CurScanType AND lastSynced IS NOT NULL);


	SET CurMaxDisplayID = (SELECT MAX(displayID)
				FROM Scan
				WHERE ownerID = CurOwnerID AND sessionID = CurSessionID AND scanType = CurScanType);

    	IF CurMaxDisplayID IS NULL OR CurMaxDisplayID = 0 THEN
		
        	SET CurMaxDisplayID = CurNbSyncScan;
    	END IF;

    	UPDATE Scan
    	SET displayID = (CurMaxDisplayID + 1)
    	WHERE ownerID = CurOwnerID AND id = CurID;

    END IF;

  END LOOP;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2022-10-13 10:24:18
