-- MySQL dump 10.13  Distrib 8.0.27, for Linux (x86_64)
--
-- Host: localhost    Database: condor_patient_local
-- ------------------------------------------------------
-- Server version	8.0.27-0ubuntu0.20.04.1

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `AddressInfo`
--

DROP TABLE IF EXISTS `AddressInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AddressInfo` (
  `id` varchar(36) NOT NULL,
  `line_0` varchar(255) DEFAULT NULL,
  `line_1` varchar(255) DEFAULT NULL,
  `line_2` varchar(255) DEFAULT NULL,
  `detail` varchar(255) DEFAULT NULL,
  `cityName` varchar(255) DEFAULT NULL,
  `cityState` varchar(255) DEFAULT NULL,
  `cityZip` varchar(25) DEFAULT NULL,
  `countryName` varchar(255) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AddressInfo`
--

LOCK TABLES `AddressInfo` WRITE;
/*!40000 ALTER TABLE `AddressInfo` DISABLE KEYS */;
INSERT INTO `AddressInfo` VALUES ('03c94848-811a-43be-ae4c-c3aaaffe6944','','','',NULL,'','','','',NULL,NULL,'2022-07-12 12:27:17'),('105b50a9-770a-4cbb-9434-46ebfa959197','','','',NULL,'','','','',NULL,NULL,'2021-06-24 13:46:32'),('1509c0e6-82a0-4472-a729-de5876aa17aa','','','',NULL,'','','','',NULL,NULL,'2022-10-12 08:30:04'),('1a93e441-16c2-4c95-b626-739a193f36d1','','','',NULL,'','','','',NULL,NULL,'2022-10-05 14:10:17'),('1b0d05ad-71be-419b-94d0-e8862ab5f06a','','','',NULL,'','','','',NULL,NULL,'2022-10-05 14:10:17'),('269254f9-a4f8-4f40-9dd8-cf211740ee4c','','','',NULL,'','','','',NULL,NULL,'2022-10-12 10:40:15'),('281c6286-21d8-47d8-bca1-895ed670d346','','','',NULL,'','','','',NULL,NULL,'2022-07-21 08:10:39'),('29e23add-a5dd-476c-b8bd-89a30a9ae05b','','','',NULL,'','','','',NULL,NULL,'2022-10-12 08:29:16'),('2a3dfc97-4870-4010-b7d7-6156069f8de9','','','',NULL,'','','','',NULL,NULL,'2022-10-12 10:40:13'),('2cf7493b-cf53-46fb-80db-7a78c9eb338e','','','',NULL,'','','','',NULL,NULL,'2022-10-11 08:09:58'),('3059c75e-edb2-441a-b99c-d6c298c90970','','','',NULL,'','','','',NULL,NULL,'2022-09-28 07:44:22'),('3394e340-a6a6-4579-a911-9720f18dfd46','','','',NULL,'','','','',NULL,NULL,'2021-06-24 13:47:28'),('37561c3c-b436-407e-93be-adddd1bebe98','','','',NULL,'','','','',NULL,NULL,'2022-07-12 12:27:17'),('3b93645d-46db-4a1d-a409-ba6fdaca1fc3','','','',NULL,'','','','',NULL,NULL,'2022-10-10 08:18:24'),('40545d25-b818-480e-824c-880547f77008','','','',NULL,'','','','',NULL,NULL,'2022-10-10 13:34:41'),('45d23b3e-e3bd-494a-86bd-f4a81462dfc1','','','',NULL,'','','','',NULL,NULL,'2022-09-28 07:44:22'),('46e248c7-40fe-4538-8eaf-7269dcebfcd1','','','',NULL,'','','','',NULL,NULL,'2022-07-21 08:27:41'),('4e17e76e-3a51-45a0-8e96-64b9da4d4eef','','','',NULL,'','','','',NULL,NULL,'2021-06-24 13:46:32'),('55863c1d-293b-4f3c-8e9e-a4fa74c8fea6','','','',NULL,'','','','',NULL,NULL,'2022-10-04 13:41:52'),('7651fc1a-b936-46f2-ad6f-359ef94152b9','','','',NULL,'','','','',NULL,NULL,'2022-10-04 07:49:32'),('83449328-e3a8-45a0-8891-ce7755f79866','','','',NULL,'','','','',NULL,NULL,'2022-10-12 10:40:12'),('8fef2126-85a8-4161-a6e8-5643468792eb','','','',NULL,'','','','',NULL,NULL,'2022-10-12 08:31:59'),('925b363e-d156-4269-a217-b641c8c101b6','','','',NULL,'','','','',NULL,NULL,'2022-10-12 10:40:12'),('9aed3b9c-91da-4b5f-8bcf-ab1f0446761f','','','',NULL,'','','','',NULL,NULL,'2022-10-12 10:40:15'),('9e241fac-4181-48ee-a46e-5b0d83f0beb7','','','',NULL,'','','','',NULL,NULL,'2022-10-12 08:29:16'),('a648c21c-c7b7-4d08-8489-33e808a66f8b','','','',NULL,'','','','',NULL,NULL,'2022-10-12 08:31:59'),('a694b067-2374-475c-bbd7-43b4bc306afd','','','',NULL,'','','','',NULL,NULL,'2022-10-04 07:49:32'),('acd9085e-2587-409c-977d-4204238232db','','','',NULL,'','','','',NULL,NULL,'2022-10-10 08:18:24'),('b53ed185-c17b-4efb-9637-aedac9246de1','','','',NULL,'','','','',NULL,NULL,'2022-10-12 08:27:22'),('c851df88-9f11-4c98-971b-9447d35e9078','','','',NULL,'','','','',NULL,NULL,'2022-10-12 10:40:13'),('ce2d98ce-7f5d-4727-903c-c314335f46a2','','','',NULL,'','','','',NULL,NULL,'2022-07-21 08:10:39'),('dad1783a-dda0-45fd-98e3-d8920fb2b53a','','','',NULL,'','','','',NULL,NULL,'2022-07-21 08:27:41'),('e13affc0-093d-492c-96a1-89b79130000a','','','',NULL,'','','','',NULL,NULL,'2022-10-12 08:27:22'),('e630a1b4-28cb-4992-98d7-dc9f13e7f78e','','','',NULL,'','','','',NULL,NULL,'2021-06-24 13:47:28'),('ed9115a6-97d8-4529-bd61-6c6f0bd8ffde','','','',NULL,'','','','',NULL,NULL,'2022-10-10 13:34:41'),('f3c6f630-3abe-4647-a894-3e556adf9443','','','',NULL,'','','','',NULL,NULL,'2022-10-12 08:30:04'),('f90d0359-2801-415f-876e-f566ccfc3de2','','','',NULL,'','','','',NULL,NULL,'2022-10-04 13:41:52'),('fa79eb62-cc8a-4ddd-9e92-fc834ce789f5','','','',NULL,'','','','',NULL,NULL,'2022-10-11 08:09:58');
/*!40000 ALTER TABLE `AddressInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `DownloadRequest`
--

DROP TABLE IF EXISTS `DownloadRequest`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DownloadRequest` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `patientID` char(36) NOT NULL,
  `createdAt` datetime NOT NULL,
  `sentAt` datetime DEFAULT NULL,
  `token` char(40) DEFAULT NULL,
  `locale` char(5) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_DownloadRequest_Patient` (`patientID`),
  CONSTRAINT `fk_DownloadRequest_Patient` FOREIGN KEY (`patientID`) REFERENCES `Patient` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DownloadRequest`
--

LOCK TABLES `DownloadRequest` WRITE;
/*!40000 ALTER TABLE `DownloadRequest` DISABLE KEYS */;
/*!40000 ALTER TABLE `DownloadRequest` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `EmergencyContact`
--

DROP TABLE IF EXISTS `EmergencyContact`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `EmergencyContact` (
  `id` varchar(36) NOT NULL,
  `personInfoID` varchar(36) DEFAULT NULL,
  `phoneInfoID` varchar(36) DEFAULT NULL,
  `addressInfoID` varchar(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_EmergencyContact_AddressInfo` (`addressInfoID`),
  KEY `fk_EmergencyContact_PersonInfo` (`personInfoID`),
  KEY `fk_EmergencyContact_PhoneInfo` (`phoneInfoID`),
  CONSTRAINT `fk_EmergencyContact_AddressInfo` FOREIGN KEY (`addressInfoID`) REFERENCES `AddressInfo` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_EmergencyContact_PersonInfo` FOREIGN KEY (`personInfoID`) REFERENCES `PersonInfo` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_EmergencyContact_PhoneInfo` FOREIGN KEY (`phoneInfoID`) REFERENCES `PhoneInfo` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `EmergencyContact`
--

LOCK TABLES `EmergencyContact` WRITE;
/*!40000 ALTER TABLE `EmergencyContact` DISABLE KEYS */;
INSERT INTO `EmergencyContact` VALUES ('06a6aae5-f410-425e-86e7-307c67a1f080','5fe2a535-526b-45be-842e-d6b2af75b63a','8f69d2af-97ba-4481-a990-a27b2e50ae08','269254f9-a4f8-4f40-9dd8-cf211740ee4c',NULL,NULL,'2022-10-12 10:40:15'),('0c1ea41f-e846-4922-9dc3-1cc878afe378','43d4d038-95ee-477b-8815-89936215ae47','ccf2c3fb-bcbe-407c-a39a-38cbe87d59d5','8fef2126-85a8-4161-a6e8-5643468792eb',NULL,NULL,'2022-10-12 08:31:59'),('0c938535-decc-48c1-9b61-27e793fe7531','8c94e017-dd36-41b1-8601-f4aeb02f16e6','ce2694bf-7db6-4cee-8185-8935ddc5b7e4','f90d0359-2801-415f-876e-f566ccfc3de2',NULL,NULL,'2022-10-04 13:41:52'),('29df7175-5e7b-4533-93a7-809105f71844','9b14802d-bf56-47ae-9aab-1f7acd7d253c','ce757a61-8a1b-48c9-a9fb-17a49de8e21d','3b93645d-46db-4a1d-a409-ba6fdaca1fc3',NULL,NULL,'2022-10-10 08:18:24'),('2cb436f5-5371-44d1-9507-39a381be6938','d3eff9cb-ec22-49ff-aa9a-0194a6226921','343409fe-7796-48c2-839f-644f0fcc61a1','2a3dfc97-4870-4010-b7d7-6156069f8de9',NULL,NULL,'2022-10-12 10:40:13'),('38a80a96-a2f7-4aa8-a75f-d4167467ff98','6cd8a356-fd95-4ef0-8b95-9dcb8132d0a8','a76a0d7d-9c66-493b-97a5-785565355206','ce2d98ce-7f5d-4727-903c-c314335f46a2',NULL,NULL,'2022-07-21 08:10:39'),('45d11536-208e-4bd6-ad56-1b6381b190b7','8c2ca647-1b5d-48bd-ba1f-7cd20b32dae8','b2c19a4b-ffe2-4125-8253-c6495db62b17','03c94848-811a-43be-ae4c-c3aaaffe6944',NULL,NULL,'2022-07-12 12:27:17'),('4e7024a0-ade4-49b1-bdcb-80e0678cd683','6c1c1f17-6e4b-4e4b-a966-ce46bc9c46a5','ee9d72b0-0e35-48e6-9425-c24c929316eb','1b0d05ad-71be-419b-94d0-e8862ab5f06a',NULL,NULL,'2022-10-05 14:10:17'),('502f20a6-6b53-4fdc-bcb5-2212465904c0','160c58a6-375d-41ea-a014-d866e73bde06','586d6718-26eb-4db6-b9e3-c390f654430d','40545d25-b818-480e-824c-880547f77008',NULL,NULL,'2022-10-10 13:34:41'),('54d613e6-3364-4e9c-a134-d22d1e68a19d','6539ae37-0db7-4d16-a2f2-f5c94fd4ab69','cd012d1c-ce5d-4832-97aa-d4485c6af6e5','dad1783a-dda0-45fd-98e3-d8920fb2b53a',NULL,NULL,'2022-07-21 08:27:41'),('7769d592-6793-4fb6-adfd-00d7f247a3bc','2f3d341a-e9a4-4b63-bbdf-da69da872ff8','449a7141-5088-4e67-be86-4e463dafe72e','f3c6f630-3abe-4647-a894-3e556adf9443',NULL,NULL,'2022-10-12 08:30:04'),('90166234-ae9d-4213-af61-7d2f6bd4074f','767f73ff-d8f5-428c-af7e-8b04029a23e4','d84760fb-ccd7-435a-8b1f-95db51ca7731','7651fc1a-b936-46f2-ad6f-359ef94152b9',NULL,NULL,'2022-10-04 07:49:32'),('915f9aad-8094-4d6c-9d4f-b093250d77ad','6f525ab9-c3d4-468c-9f07-717300e5ae22','4118632d-f34c-41b7-b594-f844117ffb09','45d23b3e-e3bd-494a-86bd-f4a81462dfc1',NULL,NULL,'2022-09-28 07:44:22'),('9dd34e7d-6243-4570-88e3-459b30271858','8a082b75-7112-420f-869b-34a9a75625f1','469cf73f-0607-4f41-8e67-05de2e9dee54','fa79eb62-cc8a-4ddd-9e92-fc834ce789f5',NULL,NULL,'2022-10-11 08:09:58'),('ac16a019-21d7-42ad-bdee-40efe686e2ed','3193f1f1-a3d8-4420-a906-934a6d299099','832d5485-7141-41d6-9589-91b0078c6df2','29e23add-a5dd-476c-b8bd-89a30a9ae05b',NULL,NULL,'2022-10-12 08:29:16'),('aeb60826-489f-4281-a305-032822522638','05ec8915-91c0-4872-ad3d-b19b5379ef66','157334a6-4ee2-4151-9521-6a1524d3b56f','83449328-e3a8-45a0-8891-ce7755f79866',NULL,NULL,'2022-10-12 10:40:12'),('bbeec0f9-069b-46ec-bdbe-1bf59907042c','0840c2b1-249b-4ead-8109-901de1b19852','4ccd019f-3e00-4401-81d7-fd1cd4390775','4e17e76e-3a51-45a0-8e96-64b9da4d4eef',NULL,NULL,'2021-06-24 13:46:32'),('e6d33db5-9cca-4aa6-9969-d612613d84f7','ec9474b1-1578-4fd8-93d1-0b3ae08b052e','0e551072-9a68-419f-a766-6be23a579e8f','e630a1b4-28cb-4992-98d7-dc9f13e7f78e',NULL,NULL,'2021-06-24 13:47:28'),('e880ff01-48e3-44b4-9f78-d688feb3434b','1bce9321-0d62-402f-ab84-4e8bbf3f1317','19e60c3b-6d97-4c96-a167-0b6ec28b6193','b53ed185-c17b-4efb-9637-aedac9246de1',NULL,NULL,'2022-10-12 08:27:22');
/*!40000 ALTER TABLE `EmergencyContact` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `EmergencyContact_AFTER_DELETE` AFTER DELETE ON `EmergencyContact` FOR EACH ROW BEGIN
	DELETE FROM PersonInfo 	WHERE id = OLD.personInfoID;
	DELETE FROM AddressInfo	WHERE id = OLD.addressInfoID;
	DELETE FROM PhoneInfo   WHERE id = OLD.phoneInfoID;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `Patient`
--

DROP TABLE IF EXISTS `Patient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Patient` (
  `id` varchar(36) NOT NULL,
  `globalDisplayID` mediumint unsigned DEFAULT NULL,
  `displayID` mediumint unsigned DEFAULT NULL,
  `socialSecurity` varchar(255) DEFAULT NULL,
  `allergies` varchar(255) DEFAULT NULL,
  `personInfoID` varchar(36) DEFAULT NULL,
  `phoneInfoID` varchar(36) DEFAULT NULL,
  `addressInfoID` varchar(36) DEFAULT NULL,
  `emergencyContactID` varchar(36) DEFAULT NULL,
  `practitionerID` varchar(36) DEFAULT NULL,
  `comments` text,
  `privateComments` text,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_Patient_AddressInfo` (`addressInfoID`),
  KEY `fk_Patient_EmergencyContact` (`emergencyContactID`),
  KEY `fk_Patient_PersonInfo` (`personInfoID`),
  KEY `fk_Patient_PhoneInfo` (`phoneInfoID`),
  KEY `fk_Patient_Practitioner` (`practitionerID`),
  CONSTRAINT `fk_Patient_AddressInfo` FOREIGN KEY (`addressInfoID`) REFERENCES `AddressInfo` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Patient_EmergencyContact` FOREIGN KEY (`emergencyContactID`) REFERENCES `EmergencyContact` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Patient_PersonInfo` FOREIGN KEY (`personInfoID`) REFERENCES `PersonInfo` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Patient_PhoneInfo` FOREIGN KEY (`phoneInfoID`) REFERENCES `PhoneInfo` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Patient_Practitioner` FOREIGN KEY (`practitionerID`) REFERENCES `Practitioner` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Patient`
--

LOCK TABLES `Patient` WRITE;
/*!40000 ALTER TABLE `Patient` DISABLE KEYS */;
INSERT INTO `Patient` VALUES ('0a5d2238-a9d8-4d69-9619-8c05329ca74a',1,16,'','','1a77adb4-2694-43c3-bef8-26980b382af2','abc3e352-7e9a-4c39-8fe8-f95454935e25','9aed3b9c-91da-4b5f-8bcf-ab1f0446761f','06a6aae5-f410-425e-86e7-307c67a1f080','84697a67-e746-4d11-b962-b54cc13ae9c1','','',NULL,NULL,NULL,'2022-10-12 12:40:15','2022-10-12 10:40:15','2022-10-12 12:40:15'),('1c129203-428b-4abf-9590-05156c541ef4',1,11,'','','5302f986-3c35-4e61-b193-67e3ec9ae27d','ebb99555-26d6-489f-94ec-3268440260cc','925b363e-d156-4269-a217-b641c8c101b6','aeb60826-489f-4281-a305-032822522638','c72b9123-fea9-46c7-a777-9cb9d5339e32','','',NULL,NULL,NULL,'2022-10-12 12:40:12','2022-10-12 10:40:12','2022-10-12 12:40:12'),('1ddf5934-ea4d-477a-9ec0-1d9144b1467d',1,5,'','','19a8da1f-5c70-4b6f-9c61-2460fba07783','e435d1d0-d9bb-4da7-8abc-e517557c3270','55863c1d-293b-4f3c-8e9e-a4fa74c8fea6','0c938535-decc-48c1-9b61-27e793fe7531','8f798b9c-141f-4039-8875-9587c1eb71b9','','',NULL,NULL,NULL,'2022-10-04 15:41:52','2022-10-04 13:41:52','2022-10-04 15:41:52'),('2d21e70c-4fb9-4add-a60d-dd2e1f166ead',1,15,'','','f3b90917-e873-4bee-afd4-15998354cd44','34728b26-cadd-430f-81c8-0d1ccfbd3ff2','a648c21c-c7b7-4d08-8489-33e808a66f8b','0c1ea41f-e846-4922-9dc3-1cc878afe378','c8dd8b28-e79d-4688-be73-abc7a0ea703d','','',NULL,NULL,NULL,'2022-10-12 12:40:14','2022-10-12 10:40:14','2022-10-12 10:31:59'),('40a79232-5988-45ff-9778-8c8c18afa1c5',1,14,'','','85c33b53-db08-4330-a7a4-96495fe6882f','102e5945-f1a9-4987-a712-62d973d0f543','c851df88-9f11-4c98-971b-9447d35e9078','2cb436f5-5371-44d1-9507-39a381be6938','c95376d9-77b0-4cf3-a00d-4eb8a93ade65','','',NULL,NULL,NULL,'2022-10-12 12:40:13','2022-10-12 10:40:13','2022-10-12 12:40:13'),('43bfdd66-40e9-4024-8259-412b8743b170',409,3,'','','772c85e2-ef96-4e9d-93d1-b5b2e4183473','06bd1600-76e6-49e0-9091-47b5c5d69f70','37561c3c-b436-407e-93be-adddd1bebe98','45d11536-208e-4bd6-ad56-1b6381b190b7','d20a66c2-44c8-4801-9a37-9247de726536','','',NULL,NULL,NULL,NULL,'2022-07-12 12:27:17','2022-07-12 14:27:17'),('4ef31c58-7de3-427d-ae5c-24505cfef470',1,6,'','','e3ca020f-9a3e-42f4-9c51-6abe6d47d3d9','57ef41e6-4cec-4c73-b9fe-2acaf3a90491','1a93e441-16c2-4c95-b626-739a193f36d1','4e7024a0-ade4-49b1-bdcb-80e0678cd683','64fc6380-f1ab-43f5-ba27-3d7d1d37ef52','','',NULL,NULL,NULL,'2022-10-05 16:10:17','2022-10-05 14:10:17','2022-10-05 16:10:17'),('5c0b4788-810f-4d15-8d45-7d5d359e7cdd',1,1,'','','ebb38859-f038-4627-9312-9406a704a269','267b9b8c-9176-49f3-b0fc-b1c590182284','281c6286-21d8-47d8-bca1-895ed670d346','38a80a96-a2f7-4aa8-a75f-d4167467ff98','146abc6d-9cf3-422f-81b5-bb4879456b1f','','',NULL,NULL,NULL,'2022-07-21 15:32:51','2022-07-21 13:32:51','2022-07-21 10:10:39'),('616990f6-4bb6-40d6-a637-926ee3cbfb23',409,2,'','','769b12c3-9013-410d-84a5-6621e9c0dd1d','2c3776c5-e690-4195-8429-54703c6462f4','3394e340-a6a6-4579-a911-9720f18dfd46','e6d33db5-9cca-4aa6-9969-d612613d84f7','0adc461f-222b-4583-a969-9c4763afca51','','',NULL,NULL,NULL,'2021-06-24 15:47:29','2021-06-24 13:47:29','2021-06-24 15:47:28'),('72fd320a-ac9e-4cb7-9e45-df60e7483550',1,13,'','','e246d004-3912-4bed-8db5-b7c44bc8c2ae','32d7ec2b-d821-4e19-89a8-67d789eb6e77','1509c0e6-82a0-4472-a729-de5876aa17aa','7769d592-6793-4fb6-adfd-00d7f247a3bc','37151bb3-0584-4959-82d4-d239b0e0678c','','',NULL,NULL,NULL,'2022-10-12 12:40:13','2022-10-12 10:40:13','2022-10-12 10:30:04'),('85f9266a-1e42-4669-9ace-c68914229450',1,10,'','','9c64b82a-fc5d-4297-98c5-b97c93299cf0','7577a455-fad0-4dd5-8e21-63c340dd6348','e13affc0-093d-492c-96a1-89b79130000a','e880ff01-48e3-44b4-9f78-d688feb3434b','fb52518d-97ed-4512-a7af-910afccdca80','','',NULL,NULL,NULL,'2022-10-12 10:27:24','2022-10-12 08:27:24','2022-10-12 10:27:22'),('959e5762-b4e5-4295-a332-8a831a0fbf4a',1,3,'','','86f29f35-ee55-45f8-8436-dafdfbe8bdd6','b38b2755-512d-42a5-9cad-1b1b7c556306','3059c75e-edb2-441a-b99c-d6c298c90970','915f9aad-8094-4d6c-9d4f-b093250d77ad','118dd5bd-dca5-459e-9cd5-988ad9569a72','','',NULL,NULL,NULL,'2022-10-03 11:41:29','2022-10-03 09:41:29','2022-09-28 10:28:01'),('962f1518-7af1-402d-b050-a4fb49c5c5b8',409,1,'','','f3b6a6af-36bd-4e8a-8ffa-2a19b2851370','0c457621-5885-445b-9acc-85f80a60f3a1','105b50a9-770a-4cbb-9434-46ebfa959197','bbeec0f9-069b-46ec-bdbe-1bf59907042c','e5e66389-2915-4334-9209-d458dc0c1935','','',NULL,NULL,'2021-06-24 15:47:26','2021-06-24 15:47:26','2021-06-24 13:47:26','2021-06-24 15:46:32'),('9c02f604-22db-491d-9239-90efde367312',1,4,'','','c644228d-ed67-45b9-b687-70f922211257','e8920cde-b202-418b-b8a7-508829246c6b','a694b067-2374-475c-bbd7-43b4bc306afd','90166234-ae9d-4213-af61-7d2f6bd4074f','8640b389-0af4-4249-b604-cce7153eb4c5','','',NULL,NULL,'2022-10-04 15:40:57','2022-10-04 15:40:57','2022-10-04 13:40:57','2022-10-04 09:49:32'),('9d774be1-a55f-4825-ab1b-d07f47fea0d7',1,8,'','','6e3775ca-2f70-4524-87d2-7c3c5f6676d9','f4450f83-5de8-4175-8775-95c4d9c3c79f','ed9115a6-97d8-4529-bd61-6c6f0bd8ffde','502f20a6-6b53-4fdc-bcb5-2212465904c0','8bdebf9c-92ad-44fb-bee6-f107b83a77b2','','',NULL,NULL,NULL,'2022-10-10 15:34:41','2022-10-10 13:34:41','2022-10-10 15:34:41'),('d988cd8e-9d0f-42ab-99e2-fdcb685ac84a',1,7,'','','304e24ed-14dc-4bf8-9bfa-ec625ec77ac2','6de1b0e9-e4bb-43c7-9d11-4359e2169102','acd9085e-2587-409c-977d-4204238232db','29df7175-5e7b-4533-93a7-809105f71844','6277a498-db1b-43a5-b399-16dfac0eca50','','',NULL,NULL,NULL,'2022-10-10 10:18:24','2022-10-10 08:18:24','2022-10-10 10:18:24'),('e0f46c84-c106-4642-bfeb-a5b36b5820ae',1,9,'','','e8ce2cd5-a646-4ce1-aeb1-002938ed9170','432a9bf1-4499-45ad-8b0d-6b7070c392ce','2cf7493b-cf53-46fb-80db-7a78c9eb338e','9dd34e7d-6243-4570-88e3-459b30271858','7e8897fc-d3b2-45d7-a22e-3462623af33a','','',NULL,NULL,NULL,'2022-10-11 10:09:58','2022-10-11 08:09:58','2022-10-11 10:09:58'),('e13c999d-6ee9-46c9-9078-d4f1d92a124d',1,12,'','','2c8c78ba-6bf4-4447-986e-86cdbcbef77a','658aba88-1171-41c3-9487-6b2bf0a0a9dc','9e241fac-4181-48ee-a46e-5b0d83f0beb7','ac16a019-21d7-42ad-bdee-40efe686e2ed','22e74c6e-9acc-4907-8770-3cc434987db0','','',NULL,NULL,NULL,'2022-10-12 12:40:12','2022-10-12 10:40:12','2022-10-12 10:29:16'),('e7759074-9318-45d5-bcd1-33d350e0b5a3',1,2,'','','b2cc2cbb-1f53-4f76-b80c-736b97ca53d1','29333eb8-fa19-48cb-82df-86e320e93028','46e248c7-40fe-4538-8eaf-7269dcebfcd1','54d613e6-3364-4e9c-a134-d22d1e68a19d','02985d94-c4ce-4ff2-9213-f853951e140e','','',NULL,NULL,'2022-07-21 10:27:45',NULL,'2022-07-21 08:27:45','2022-07-21 10:27:41');
/*!40000 ALTER TABLE `Patient` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `Patient_AFTER_DELETE` AFTER DELETE ON `Patient` FOR EACH ROW BEGIN
	DELETE FROM PersonInfo  	 WHERE id = OLD.personInfoID;
	DELETE FROM AddressInfo 	 WHERE id = OLD.addressInfoID;
	DELETE FROM PhoneInfo   	 WHERE id = OLD.phoneInfoID;
	DELETE FROM EmergencyContact     WHERE id = OLD.emergencyContactID;
	DELETE FROM Practitioner 	 WHERE id = OLD.practitionerID;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `PatientCredentials`
--

DROP TABLE IF EXISTS `PatientCredentials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PatientCredentials` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `patientID` char(36) NOT NULL,
  `accessCode` varchar(128) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `un_AccessCode` (`accessCode`),
  KEY `fk_PatientCredentials_Patient` (`patientID`),
  CONSTRAINT `fk_PatientCredentials_Patient` FOREIGN KEY (`patientID`) REFERENCES `Patient` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PatientCredentials`
--

LOCK TABLES `PatientCredentials` WRITE;
/*!40000 ALTER TABLE `PatientCredentials` DISABLE KEYS */;
/*!40000 ALTER TABLE `PatientCredentials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PatientToken`
--

DROP TABLE IF EXISTS `PatientToken`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PatientToken` (
  `id` char(36) NOT NULL,
  `created` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `token` char(41) NOT NULL,
  `patientCredentialsId` mediumint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `un_Token` (`token`),
  KEY `fk_PatientToken_PatientCredentials` (`patientCredentialsId`),
  CONSTRAINT `fk_PatientToken_PatientCredentials` FOREIGN KEY (`patientCredentialsId`) REFERENCES `PatientCredentials` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PatientToken`
--

LOCK TABLES `PatientToken` WRITE;
/*!40000 ALTER TABLE `PatientToken` DISABLE KEYS */;
/*!40000 ALTER TABLE `PatientToken` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PersonInfo`
--

DROP TABLE IF EXISTS `PersonInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PersonInfo` (
  `id` varchar(36) NOT NULL,
  `firstName` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `sex` enum('M','F') DEFAULT NULL,
  `birthDate` date DEFAULT NULL,
  `salutation` varchar(45) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `picturePath` varchar(255) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PersonInfo`
--

LOCK TABLES `PersonInfo` WRITE;
/*!40000 ALTER TABLE `PersonInfo` DISABLE KEYS */;
INSERT INTO `PersonInfo` VALUES ('05ec8915-91c0-4872-ad3d-b19b5379ef66','','','','',NULL,'','','',NULL,NULL,'2022-10-12 10:40:12'),('0840c2b1-249b-4ead-8109-901de1b19852','','','','',NULL,'','','',NULL,NULL,'2021-06-24 13:46:32'),('160c58a6-375d-41ea-a014-d866e73bde06','','','','',NULL,'','','',NULL,NULL,'2022-10-10 13:34:41'),('19a8da1f-5c70-4b6f-9c61-2460fba07783','NAHEL','AIZAB','','M','2012-04-26','','','',NULL,NULL,'2022-10-04 13:41:52'),('1a77adb4-2694-43c3-bef8-26980b382af2','MARIANA','BORGES','','F','2008-09-01','','','',NULL,NULL,'2022-10-12 10:40:15'),('1bce9321-0d62-402f-ab84-4e8bbf3f1317','NO_FIRSTNAME','NO_LASTNAME','','',NULL,'','','',NULL,NULL,'2022-10-12 08:27:22'),('2c8c78ba-6bf4-4447-986e-86cdbcbef77a','SELMA','OSMANI','','F','2012-11-18','','','',NULL,NULL,'2022-10-12 08:29:16'),('2f3d341a-e9a4-4b63-bbdf-da69da872ff8','NO_FIRSTNAME','NO_LASTNAME','','',NULL,'','','',NULL,NULL,'2022-10-12 08:30:04'),('304e24ed-14dc-4bf8-9bfa-ec625ec77ac2','WASSYM','BEN HAMADI','','M','2017-06-06','','','',NULL,NULL,'2022-10-10 08:18:24'),('3193f1f1-a3d8-4420-a906-934a6d299099','NO_FIRSTNAME','NO_LASTNAME','','',NULL,'','','',NULL,NULL,'2022-10-12 08:29:16'),('43d4d038-95ee-477b-8815-89936215ae47','NO_FIRSTNAME','NO_LASTNAME','','',NULL,'','','',NULL,NULL,'2022-10-12 08:31:59'),('5302f986-3c35-4e61-b193-67e3ec9ae27d','LINA','ANOUMOU','','F','2007-12-15','','','',NULL,NULL,'2022-10-12 10:40:12'),('5fe2a535-526b-45be-842e-d6b2af75b63a','','','','',NULL,'','','',NULL,NULL,'2022-10-12 10:40:15'),('6539ae37-0db7-4d16-a2f2-f5c94fd4ab69','NO_FIRSTNAME','NO_LASTNAME','','',NULL,'','','',NULL,NULL,'2022-07-21 08:27:41'),('6c1c1f17-6e4b-4e4b-a966-ce46bc9c46a5','','','','',NULL,'','','',NULL,NULL,'2022-10-05 14:10:17'),('6cd8a356-fd95-4ef0-8b95-9dcb8132d0a8','','','','',NULL,'','','',NULL,NULL,'2022-07-21 08:10:39'),('6e3775ca-2f70-4524-87d2-7c3c5f6676d9','SOUMIA','GAOUA','','F','2013-02-06','','','',NULL,NULL,'2022-10-10 13:34:41'),('6f525ab9-c3d4-468c-9f07-717300e5ae22','NO_FIRSTNAME','NO_LASTNAME','','',NULL,'','','',NULL,NULL,'2022-09-28 07:44:22'),('767f73ff-d8f5-428c-af7e-8b04029a23e4','','','','',NULL,'','','',NULL,NULL,'2022-10-04 07:49:32'),('769b12c3-9013-410d-84a5-6621e9c0dd1d','','','','',NULL,'','','',NULL,NULL,'2021-06-24 13:47:28'),('772c85e2-ef96-4e9d-93d1-b5b2e4183473','NO_FIRSTNAME','NO_LASTNAME','','',NULL,'','','',NULL,NULL,'2022-07-12 12:27:17'),('85c33b53-db08-4330-a7a4-96495fe6882f','ELANUR','CAKIROGLU','','F','2008-08-07','','','',NULL,NULL,'2022-10-12 10:40:13'),('86f29f35-ee55-45f8-8436-dafdfbe8bdd6','LAURENA','MAINOT','','F','1995-10-17','','','',NULL,NULL,'2022-09-28 08:28:02'),('8a082b75-7112-420f-869b-34a9a75625f1','NO_FIRSTNAME','NO_LASTNAME','','',NULL,'','','',NULL,NULL,'2022-10-11 08:09:58'),('8c2ca647-1b5d-48bd-ba1f-7cd20b32dae8','NO_FIRSTNAME','NO_LASTNAME','','',NULL,'','','',NULL,NULL,'2022-07-12 12:27:17'),('8c94e017-dd36-41b1-8601-f4aeb02f16e6','','','','',NULL,'','','',NULL,NULL,'2022-10-04 13:41:52'),('9b14802d-bf56-47ae-9aab-1f7acd7d253c','NO_FIRSTNAME','NO_LASTNAME','','',NULL,'','','',NULL,NULL,'2022-10-10 08:18:24'),('9c64b82a-fc5d-4297-98c5-b97c93299cf0','TIFFANY','CLARISSE OVIGNY','','F','2014-11-28','','','',NULL,NULL,'2022-10-12 08:27:22'),('b2cc2cbb-1f53-4f76-b80c-736b97ca53d1','NO_FIRSTNAME','NO_LASTNAME','','',NULL,'','','',NULL,NULL,'2022-07-21 08:27:41'),('c644228d-ed67-45b9-b687-70f922211257','THEO','PESQUET','','M','2014-12-15','','','',NULL,NULL,'2022-10-04 07:49:32'),('d3eff9cb-ec22-49ff-aa9a-0194a6226921','','','','',NULL,'','','',NULL,NULL,'2022-10-12 10:40:13'),('e246d004-3912-4bed-8db5-b7c44bc8c2ae','CHARLIE','MOSKA','','M','2014-09-17','','','',NULL,NULL,'2022-10-12 08:30:04'),('e3ca020f-9a3e-42f4-9c51-6abe6d47d3d9','FADI','AKHARAZ','','M','2015-07-29','','','',NULL,NULL,'2022-10-05 14:10:17'),('e8ce2cd5-a646-4ce1-aeb1-002938ed9170','JULIETTE','LEVESQUE','','F','2016-01-12','','','',NULL,NULL,'2022-10-11 08:09:58'),('ebb38859-f038-4627-9312-9406a704a269','test','Test','','F','2022-07-21','','','',NULL,NULL,'2022-07-21 08:10:39'),('ec9474b1-1578-4fd8-93d1-0b3ae08b052e','','','','',NULL,'','','',NULL,NULL,'2021-06-24 13:47:28'),('f3b6a6af-36bd-4e8a-8ffa-2a19b2851370','','','','',NULL,'','','',NULL,NULL,'2021-06-24 13:46:32'),('f3b90917-e873-4bee-afd4-15998354cd44','LIANA','MONORY','','F','2014-08-09','','','',NULL,NULL,'2022-10-12 08:31:59');
/*!40000 ALTER TABLE `PersonInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PhoneInfo`
--

DROP TABLE IF EXISTS `PhoneInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PhoneInfo` (
  `id` varchar(36) NOT NULL,
  `mainPhone` varchar(45) DEFAULT NULL,
  `cellular` varchar(45) DEFAULT NULL,
  `fax` varchar(45) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PhoneInfo`
--

LOCK TABLES `PhoneInfo` WRITE;
/*!40000 ALTER TABLE `PhoneInfo` DISABLE KEYS */;
INSERT INTO `PhoneInfo` VALUES ('06bd1600-76e6-49e0-9091-47b5c5d69f70','','','',NULL,NULL,'2022-07-12 12:27:17'),('09afe20d-265f-4805-b846-e1e6e5d4917c','','','',NULL,NULL,'2022-07-12 12:27:17'),('0c457621-5885-445b-9acc-85f80a60f3a1','','','',NULL,NULL,'2021-06-24 13:46:32'),('0e551072-9a68-419f-a766-6be23a579e8f','','','',NULL,NULL,'2021-06-24 13:47:28'),('102e5945-f1a9-4987-a712-62d973d0f543','','','',NULL,NULL,'2022-10-12 10:40:13'),('14415ff9-a5d2-4dae-94fc-ce1485dc4aa4','','','',NULL,NULL,'2022-09-28 07:44:22'),('157334a6-4ee2-4151-9521-6a1524d3b56f','','','',NULL,NULL,'2022-10-12 10:40:12'),('189aa6ea-5411-43b9-94ae-00697d2b34ad','','','',NULL,NULL,'2022-10-04 07:49:32'),('19e60c3b-6d97-4c96-a167-0b6ec28b6193','','','',NULL,NULL,'2022-10-12 08:27:22'),('20ce808a-bb82-4738-9a79-542fd826de79','','','',NULL,NULL,'2022-10-12 08:30:04'),('267b9b8c-9176-49f3-b0fc-b1c590182284','','','',NULL,NULL,'2022-07-21 08:10:39'),('29333eb8-fa19-48cb-82df-86e320e93028','','','',NULL,NULL,'2022-07-21 08:27:41'),('2c3776c5-e690-4195-8429-54703c6462f4','','','',NULL,NULL,'2021-06-24 13:47:28'),('2f027e86-5a54-4ce3-8031-19736163df09','','','',NULL,NULL,'2022-10-12 08:31:59'),('31836dbb-721c-4c9f-9483-a37fbba936ad','','','',NULL,NULL,'2022-07-21 08:27:41'),('32d7ec2b-d821-4e19-89a8-67d789eb6e77','','','',NULL,NULL,'2022-10-12 08:30:04'),('343409fe-7796-48c2-839f-644f0fcc61a1','','','',NULL,NULL,'2022-10-12 10:40:13'),('34728b26-cadd-430f-81c8-0d1ccfbd3ff2','','','',NULL,NULL,'2022-10-12 08:31:59'),('3f752136-ea3f-479b-9a82-9667ee0c07f7','','','',NULL,NULL,'2022-10-10 08:18:24'),('4118632d-f34c-41b7-b594-f844117ffb09','','','',NULL,NULL,'2022-09-28 07:44:22'),('432a9bf1-4499-45ad-8b0d-6b7070c392ce','','','',NULL,NULL,'2022-10-11 08:09:58'),('449a7141-5088-4e67-be86-4e463dafe72e','','','',NULL,NULL,'2022-10-12 08:30:04'),('469cf73f-0607-4f41-8e67-05de2e9dee54','','','',NULL,NULL,'2022-10-11 08:09:58'),('4ccd019f-3e00-4401-81d7-fd1cd4390775','','','',NULL,NULL,'2021-06-24 13:46:32'),('57ef41e6-4cec-4c73-b9fe-2acaf3a90491','','','',NULL,NULL,'2022-10-05 14:10:17'),('583935f6-11e7-4247-8378-b12d6709e5f9','','','',NULL,NULL,'2022-10-12 10:40:12'),('586d6718-26eb-4db6-b9e3-c390f654430d','','','',NULL,NULL,'2022-10-10 13:34:41'),('5fc5a623-664c-4894-868a-a5a5ee028fa9','','','',NULL,NULL,'2022-10-05 14:10:17'),('60fc98a5-ee65-4f36-b953-2dda9894849d','','','',NULL,NULL,'2021-06-24 13:47:28'),('610fa87d-00fa-4c5d-9a66-0a41edc878d5','','','',NULL,NULL,'2022-10-12 08:27:22'),('658aba88-1171-41c3-9487-6b2bf0a0a9dc','','','',NULL,NULL,'2022-10-12 08:29:16'),('6de1b0e9-e4bb-43c7-9d11-4359e2169102','','','',NULL,NULL,'2022-10-10 08:18:24'),('7577a455-fad0-4dd5-8e21-63c340dd6348','','','',NULL,NULL,'2022-10-12 08:27:22'),('832d5485-7141-41d6-9589-91b0078c6df2','','','',NULL,NULL,'2022-10-12 08:29:16'),('8b73e944-e8e4-42ae-8785-ff07bcd85b5b','','','',NULL,NULL,'2022-10-12 10:40:15'),('8d643e0d-4f44-49d1-a2b9-f850ac736b90','','','',NULL,NULL,'2022-10-04 13:41:52'),('8f69d2af-97ba-4481-a990-a27b2e50ae08','','','',NULL,NULL,'2022-10-12 10:40:15'),('a76a0d7d-9c66-493b-97a5-785565355206','','','',NULL,NULL,'2022-07-21 08:10:39'),('abc3e352-7e9a-4c39-8fe8-f95454935e25','','','',NULL,NULL,'2022-10-12 10:40:15'),('b2c19a4b-ffe2-4125-8253-c6495db62b17','','','',NULL,NULL,'2022-07-12 12:27:17'),('b38b2755-512d-42a5-9cad-1b1b7c556306','','','',NULL,NULL,'2022-09-28 07:44:22'),('c8a35e09-1c3b-4ff8-9fb0-5e12516e3a9c','','','',NULL,NULL,'2022-10-11 08:09:58'),('ccf2c3fb-bcbe-407c-a39a-38cbe87d59d5','','','',NULL,NULL,'2022-10-12 08:31:59'),('cd012d1c-ce5d-4832-97aa-d4485c6af6e5','','','',NULL,NULL,'2022-07-21 08:27:41'),('ce2694bf-7db6-4cee-8185-8935ddc5b7e4','','','',NULL,NULL,'2022-10-04 13:41:52'),('ce757a61-8a1b-48c9-a9fb-17a49de8e21d','','','',NULL,NULL,'2022-10-10 08:18:24'),('d2660c0f-40d5-4cf9-98de-c8a81f7fbf34','','','',NULL,NULL,'2022-10-10 13:34:41'),('d84760fb-ccd7-435a-8b1f-95db51ca7731','','','',NULL,NULL,'2022-10-04 07:49:32'),('e435d1d0-d9bb-4da7-8abc-e517557c3270','','','',NULL,NULL,'2022-10-04 13:41:52'),('e8920cde-b202-418b-b8a7-508829246c6b','','','',NULL,NULL,'2022-10-04 07:49:32'),('ebb99555-26d6-489f-94ec-3268440260cc','','','',NULL,NULL,'2022-10-12 10:40:12'),('ee9d72b0-0e35-48e6-9425-c24c929316eb','','','',NULL,NULL,'2022-10-05 14:10:17'),('f2a7dd85-267f-4025-a3e6-563179b619bd','','','',NULL,NULL,'2021-06-24 13:46:32'),('f4450f83-5de8-4175-8775-95c4d9c3c79f','','','',NULL,NULL,'2022-10-10 13:34:41'),('f45ca6e5-75ab-4dd1-8139-31f6f3008eb5','','','',NULL,NULL,'2022-10-12 08:29:16'),('f685a55d-9eac-4706-bf4e-30cf8f195cf4','','','',NULL,NULL,'2022-07-21 08:10:39'),('f9cd5cac-1726-436a-bdaa-3d481b9d6b80','','','',NULL,NULL,'2022-10-12 10:40:13');
/*!40000 ALTER TABLE `PhoneInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Practitioner`
--

DROP TABLE IF EXISTS `Practitioner`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Practitioner` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `phoneInfoID` varchar(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_Practitioner_PhoneInfo` (`phoneInfoID`),
  CONSTRAINT `fk_Practitioner_PhoneInfo` FOREIGN KEY (`phoneInfoID`) REFERENCES `PhoneInfo` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Practitioner`
--

LOCK TABLES `Practitioner` WRITE;
/*!40000 ALTER TABLE `Practitioner` DISABLE KEYS */;
INSERT INTO `Practitioner` VALUES ('02985d94-c4ce-4ff2-9213-f853951e140e','','31836dbb-721c-4c9f-9483-a37fbba936ad',NULL,NULL,'2022-07-21 08:27:41'),('0adc461f-222b-4583-a969-9c4763afca51','','60fc98a5-ee65-4f36-b953-2dda9894849d',NULL,NULL,'2021-06-24 13:47:28'),('118dd5bd-dca5-459e-9cd5-988ad9569a72','','14415ff9-a5d2-4dae-94fc-ce1485dc4aa4',NULL,NULL,'2022-09-28 07:44:22'),('146abc6d-9cf3-422f-81b5-bb4879456b1f','','f685a55d-9eac-4706-bf4e-30cf8f195cf4',NULL,NULL,'2022-07-21 08:10:39'),('22e74c6e-9acc-4907-8770-3cc434987db0','','f45ca6e5-75ab-4dd1-8139-31f6f3008eb5',NULL,NULL,'2022-10-12 08:29:16'),('37151bb3-0584-4959-82d4-d239b0e0678c','','20ce808a-bb82-4738-9a79-542fd826de79',NULL,NULL,'2022-10-12 08:30:04'),('6277a498-db1b-43a5-b399-16dfac0eca50','','3f752136-ea3f-479b-9a82-9667ee0c07f7',NULL,NULL,'2022-10-10 08:18:24'),('64fc6380-f1ab-43f5-ba27-3d7d1d37ef52','','5fc5a623-664c-4894-868a-a5a5ee028fa9',NULL,NULL,'2022-10-05 14:10:17'),('7e8897fc-d3b2-45d7-a22e-3462623af33a','','c8a35e09-1c3b-4ff8-9fb0-5e12516e3a9c',NULL,NULL,'2022-10-11 08:09:58'),('84697a67-e746-4d11-b962-b54cc13ae9c1','','8b73e944-e8e4-42ae-8785-ff07bcd85b5b',NULL,NULL,'2022-10-12 10:40:15'),('8640b389-0af4-4249-b604-cce7153eb4c5','','189aa6ea-5411-43b9-94ae-00697d2b34ad',NULL,NULL,'2022-10-04 07:49:32'),('8bdebf9c-92ad-44fb-bee6-f107b83a77b2','','d2660c0f-40d5-4cf9-98de-c8a81f7fbf34',NULL,NULL,'2022-10-10 13:34:41'),('8f798b9c-141f-4039-8875-9587c1eb71b9','','8d643e0d-4f44-49d1-a2b9-f850ac736b90',NULL,NULL,'2022-10-04 13:41:52'),('c72b9123-fea9-46c7-a777-9cb9d5339e32','','583935f6-11e7-4247-8378-b12d6709e5f9',NULL,NULL,'2022-10-12 10:40:12'),('c8dd8b28-e79d-4688-be73-abc7a0ea703d','','2f027e86-5a54-4ce3-8031-19736163df09',NULL,NULL,'2022-10-12 08:31:59'),('c95376d9-77b0-4cf3-a00d-4eb8a93ade65','','f9cd5cac-1726-436a-bdaa-3d481b9d6b80',NULL,NULL,'2022-10-12 10:40:13'),('d20a66c2-44c8-4801-9a37-9247de726536','','09afe20d-265f-4805-b846-e1e6e5d4917c',NULL,NULL,'2022-07-12 12:27:17'),('e5e66389-2915-4334-9209-d458dc0c1935','','f2a7dd85-267f-4025-a3e6-563179b619bd',NULL,NULL,'2021-06-24 13:46:32'),('fb52518d-97ed-4512-a7af-910afccdca80','','610fa87d-00fa-4c5d-9a66-0a41edc878d5',NULL,NULL,'2022-10-12 08:27:22');
/*!40000 ALTER TABLE `Practitioner` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `Practitioner_AFTER_DELETE` AFTER DELETE ON `Practitioner` FOR EACH ROW BEGIN
	DELETE FROM PhoneInfo WHERE id = OLD.phoneInfoID;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `__db_version__`
--

DROP TABLE IF EXISTS `__db_version__`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `__db_version__` (
  `id` int NOT NULL AUTO_INCREMENT,
  `version_major` int NOT NULL DEFAULT '0',
  `version_minor` int NOT NULL DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `migration_file` varchar(1024) DEFAULT NULL,
  `commit` varchar(255) DEFAULT NULL,
  `version_core` varchar(255) DEFAULT NULL,
  `version_IHM` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `__db_version__`
--

LOCK TABLES `__db_version__` WRITE;
/*!40000 ALTER TABLE `__db_version__` DISABLE KEYS */;
INSERT INTO `__db_version__` VALUES (1,1,0,'v1.0','migration_initial_patient_cleanup_local','','4.2.0','2.1.1'),(2,1,1,'v1.1','migration_add_version_and_patient_credentials','','4.2.0','2.1.1'),(3,1,2,'v1.2','migration_add_patient_download_request','','4.2.0','2.1.1'),(4,1,3,'v1.3','migration_patient_trigger_local','','4.3.0','2.2.2');
/*!40000 ALTER TABLE `__db_version__` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping routines for database 'condor_patient_local'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2022-10-13 10:24:18
