-- MySQL dump 10.13  Distrib 8.0.28, for Linux (x86_64)
--
-- Host: localhost    Database: condor
-- ------------------------------------------------------
-- Server version	8.0.28-0ubuntu0.20.04.3

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `Act`
--

DROP TABLE IF EXISTS `Act`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Act` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `title` varchar(64) DEFAULT NULL,
  `dateCreated` datetime DEFAULT NULL,
  `comments` mediumtext,
  `globalDisplayID` mediumint unsigned DEFAULT NULL,
  `displayID` mediumint unsigned DEFAULT NULL,
  `patientID` char(36) NOT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastAccessed` datetime NOT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_Work_Patient` (`patientID`,`ownerID`),
  CONSTRAINT `fk_Act_Patient` FOREIGN KEY (`patientID`) REFERENCES `condor_patient_local`.`Patient` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Act`
--

LOCK TABLES `Act` WRITE;
/*!40000 ALTER TABLE `Act` DISABLE KEYS */;
INSERT INTO `Act` VALUES (2,'7cf3d815-4034-4483-b6cd-a323547e3de1','','2022-04-05 10:18:20','',456,1,'d4923384-c197-410d-990a-1fa1d8bbbaa1','','','2022-04-05 10:23:08','2022-04-05 10:18:20',NULL,'2022-04-05 08:23:08','2022-04-05 10:23:08'),(2,'9523140a-cc7b-4fe8-b76d-eec8fee73f95','dgdfg','2022-03-31 12:08:04','',456,1,'73b2fec8-e730-4e3a-b806-9461f222222e','','',NULL,'2022-04-05 10:16:53','2022-04-05 10:16:56','2022-04-05 08:16:56','2022-04-05 10:16:56'),(2,'ee6f943a-7cab-46d0-b223-fd379650024c','1530010CR0267','2022-04-05 11:21:44','',32,1,'5b3365d0-2ad4-4d78-9c7c-89ff37d5905d','','',NULL,'2022-04-07 11:35:53','2022-04-07 11:35:54','2022-04-07 09:35:54','2022-04-05 11:25:45');
/*!40000 ALTER TABLE `Act` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AddressInfo`
--

DROP TABLE IF EXISTS `AddressInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AddressInfo` (
  `id` char(36) NOT NULL COMMENT '(DC2Type:guid)',
  `line_0` varchar(255) DEFAULT NULL,
  `line_1` varchar(255) DEFAULT NULL,
  `line_2` varchar(255) DEFAULT NULL,
  `detail` varchar(255) DEFAULT NULL,
  `cityName` varchar(255) DEFAULT NULL,
  `cityState` varchar(255) DEFAULT NULL,
  `cityZip` varchar(25) DEFAULT NULL,
  `countryName` varchar(255) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AddressInfo`
--

LOCK TABLES `AddressInfo` WRITE;
/*!40000 ALTER TABLE `AddressInfo` DISABLE KEYS */;
INSERT INTO `AddressInfo` VALUES ('00000001-0000-0000-0000-000000000001','Labege','','',NULL,'Labege','','31670','France',NULL,NULL,'2022-03-31 17:40:19'),('00000002-0000-0000-0000-000000000001','137 rue garance','','',NULL,'LABEGE','','31670','France',NULL,NULL,'2022-03-31 17:40:19'),('00000002-0000-0000-0000-000000000002','','','',NULL,'','','','',NULL,NULL,'2022-04-05 07:52:44'),('00000003-0000-0000-0000-000000000001','137 rue Garance','','',NULL,'Labège','','31670','France',NULL,NULL,'2022-03-31 17:40:19'),('00000005-0000-0000-0000-000000000001','','','',NULL,'HOENHEIM','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000006-0000-0000-0000-000000000001','','','',NULL,'Marseille','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000007-0000-0000-0000-000000000001','','','',NULL,'MERIGNAC','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000008-0000-0000-0000-000000000001','','','',NULL,'MERIGNAC','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000009-0000-0000-0000-000000000001','','','',NULL,'Villiers Sur Marne','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000028-0000-0000-0000-000000000001','','','',NULL,'lyon','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000033-0000-0000-0000-000000000001','','','',NULL,'','','','',NULL,NULL,'2022-03-31 17:40:19'),('00000059-0000-0000-0000-000000000001','','','',NULL,'LE TEIL','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000155-0000-0000-0000-000000000001','','','',NULL,'ECOUFLANT','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000172-0000-0000-0000-000000000001','4 Chemin Couralis','','',NULL,'LAROIN','','64110','France',NULL,NULL,'2022-03-31 17:40:19'),('00000177-0000-0000-0000-000000000001','AVDA. JUAN CARAMUEL,1','','',NULL,'LEGANES','','28916','España',NULL,NULL,'2022-03-31 17:40:19'),('00000193-0000-0000-0000-000000000001','','','',NULL,'VIRIAT ','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000224-0000-0000-0000-000000000001','','','',NULL,'CUGNAUX','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000317-0000-0000-0000-000000000001','','','',NULL,'LONGWY','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000339-0000-0000-0000-000000000001','','','',NULL,'Paris','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000355-0000-0000-0000-000000000001','','','',NULL,'Parma','','','Italia',NULL,NULL,'2022-03-31 17:40:19'),('00000375-0000-0000-0000-000000000001','95, Avenue de la Marne','','',NULL,'Epinay sur Seine','','93800','France',NULL,NULL,'2022-03-31 17:40:19'),('00000377-0000-0000-0000-000000000001','51 rue moncey','','',NULL,'LYON','','69003','France',NULL,NULL,'2022-03-31 17:40:19'),('00000421-0000-0000-0000-000000000001','','','',NULL,'PARIS 17','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000568-0000-0000-0000-000000000001','','','',NULL,'Tlse','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000652-0000-0000-0000-000000000001','','','',NULL,'','','','',NULL,NULL,'2022-03-31 17:40:19'),('00000664-0000-0000-0000-000000000001','801 Wayne Avenue, Suite G200','','',NULL,'Silver Spring','','20910','United States',NULL,NULL,'2022-03-31 17:40:19'),('00000681-0000-0000-0000-000000000001','','','',NULL,'Chamalières ','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000689-0000-0000-0000-000000000001','','','',NULL,'CHAMBERY','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000722-0000-0000-0000-000000000001','PRACTICANTE ANTONIO ASTRAY 4 BAJO. ','','',NULL,'TAPIA','','33740','España',NULL,NULL,'2022-03-31 17:40:19'),('00000805-0000-0000-0000-000000000001','137 rue Garance','','',NULL,'Labege','','31670','France',NULL,NULL,'2022-03-31 17:40:19'),('00000838-0000-0000-0000-000000000001','','','',NULL,'','','','',NULL,NULL,'2022-03-31 17:40:19'),('00000840-0000-0000-0000-000000000001','','','',NULL,'','','','',NULL,NULL,'2022-03-31 17:40:19'),('00000850-0000-0000-0000-000000000001','52 RUE DU BOURNO','','',NULL,'BOEGE','','74420','France',NULL,NULL,'2022-03-31 17:40:19'),('00000899-0000-0000-0000-000000000001','VIA E.TAZZOLI','','',NULL,'CASERTA','','81100','Italia',NULL,NULL,'2022-03-31 17:40:19'),('00000916-0000-0000-0000-000000000001','','','',NULL,'','','','',NULL,NULL,'2022-03-31 17:40:19'),('00000917-0000-0000-0000-000000000001','','','',NULL,'','','','',NULL,NULL,'2022-03-31 17:40:19'),('00000918-0000-0000-0000-000000000001','','','',NULL,'Paris','','','France',NULL,NULL,'2022-03-31 17:40:19'),('00000941-0000-0000-0000-000000000001','','','',NULL,'','','','',NULL,NULL,'2022-03-31 17:40:19');
/*!40000 ALTER TABLE `AddressInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Assistant`
--

DROP TABLE IF EXISTS `Assistant`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Assistant` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `patientRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'READ_ONLY',
  `actRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'READ_ONLY',
  `discussionRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'READ_ONLY',
  `credentialsID` char(36) DEFAULT NULL,
  `personInfoID` char(36) DEFAULT NULL COMMENT '(DC2Type:guid)',
  `phoneInfoID` char(36) DEFAULT NULL COMMENT '(DC2Type:guid)',
  `addressInfoID` char(36) DEFAULT NULL COMMENT '(DC2Type:guid)',
  `officeID` char(36) DEFAULT NULL,
  `tempPassword` varchar(32) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `lastConnection` timestamp NULL DEFAULT NULL,
  `firstConnection` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`,`ownerID`),
  UNIQUE KEY `UNIQ_4068FE723D139428` (`personInfoID`),
  UNIQUE KEY `UNIQ_4068FE72627FFEF6` (`phoneInfoID`),
  UNIQUE KEY `UNIQ_4068FE72A680FCCC` (`addressInfoID`),
  KEY `fk_Assistant_Professional` (`ownerID`),
  KEY `fk_Assistant_Office` (`officeID`,`ownerID`),
  KEY `fk_Assistant_Credentials_idx` (`credentialsID`,`id`),
  KEY `fk_Assistant_PersonInfo_idx` (`personInfoID`),
  KEY `fk_Assistant_PhoneInfo_idx` (`phoneInfoID`),
  KEY `fk_Assistant_AddressInfo_idx` (`addressInfoID`),
  CONSTRAINT `fk_Assistant_AddressInfo` FOREIGN KEY (`addressInfoID`) REFERENCES `AddressInfo` (`id`),
  CONSTRAINT `fk_Assistant_Credentials` FOREIGN KEY (`credentialsID`) REFERENCES `Credentials` (`id`),
  CONSTRAINT `fk_Assistant_Office` FOREIGN KEY (`officeID`, `ownerID`) REFERENCES `Office` (`id`, `ownerID`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Assistant_PersonInfo` FOREIGN KEY (`personInfoID`) REFERENCES `PersonInfo` (`id`),
  CONSTRAINT `fk_Assistant_PhoneInfo` FOREIGN KEY (`phoneInfoID`) REFERENCES `PhoneInfo` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Assistant`
--

LOCK TABLES `Assistant` WRITE;
/*!40000 ALTER TABLE `Assistant` DISABLE KEYS */;
INSERT INTO `Assistant` VALUES (2,'f89574d0-a4d6-47da-bf72-2c4663e408f0','READ_WRITE','READ_ONLY','NOTHING',NULL,'00000002-0000-0000-0000-000000000002','00000002-0000-0000-0000-000000000002','00000002-0000-0000-0000-000000000002','f841d3b8-276b-4ad1-859c-ba7e25ffe059','',NULL,'2022-04-05 10:11:55','2022-04-05 08:11:55','2020-12-09 19:29:03',NULL,0);
/*!40000 ALTER TABLE `Assistant` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `Assistant_AFTER_DELETE` AFTER DELETE ON `Assistant` FOR EACH ROW BEGIN
	DELETE FROM PersonInfo  WHERE ownerID = OLD.ownerID AND id = OLD.personInfoID;
	DELETE FROM AddressInfo WHERE ownerID = OLD.ownerID AND id = OLD.addressInfoID;
	DELETE FROM PhoneInfo   WHERE ownerID = OLD.ownerID AND id = OLD.phoneInfoID;
	DELETE FROM Credentials WHERE ownerID = OLD.ownerID AND id = OLD.credentialsID;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `CircleOrder`
--

DROP TABLE IF EXISTS `CircleOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CircleOrder` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `actID` char(36) NOT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `title` varchar(64) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `status` enum('not_sent','waiting_wow_api','sending_wow_api','sending_circle_api','sent','cancelled') NOT NULL DEFAULT 'waiting_wow_api',
  `createdAt` datetime NOT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastModified` datetime NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `json` text NOT NULL,
  `metadata` text NOT NULL,
  `localDisplayID` int unsigned DEFAULT NULL,
  `globalDisplayID` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`,`ownerID`),
  KEY `fk_CircleOrder_Act` (`actID`,`ownerID`),
  CONSTRAINT `fk_CircleOrder_Act` FOREIGN KEY (`actID`, `ownerID`) REFERENCES `Act` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CircleOrder`
--

LOCK TABLES `CircleOrder` WRITE;
/*!40000 ALTER TABLE `CircleOrder` DISABLE KEYS */;
/*!40000 ALTER TABLE `CircleOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CircleOrderFile`
--

DROP TABLE IF EXISTS `CircleOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CircleOrderFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `orderID` char(36) NOT NULL,
  `fileID` char(36) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ownerID`,`orderID`,`fileID`),
  KEY `fk_CircleOrderFile_CircleOrder` (`orderID`,`ownerID`),
  KEY `fk_CircleOrderFile_CondorFile` (`fileID`,`ownerID`),
  CONSTRAINT `fk_CircleOrderFile_CircleOrder` FOREIGN KEY (`orderID`, `ownerID`) REFERENCES `CircleOrder` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_CircleOrderFile_CondorFile` FOREIGN KEY (`fileID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CircleOrderFile`
--

LOCK TABLES `CircleOrderFile` WRITE;
/*!40000 ALTER TABLE `CircleOrderFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `CircleOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CondorFile`
--

DROP TABLE IF EXISTS `CondorFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CondorFile` (
  `ownerID` mediumint unsigned NOT NULL,
  `id` char(36) NOT NULL,
  `path` text NOT NULL,
  `type` varchar(250) NOT NULL,
  `tag` varchar(250) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  `originalName` varchar(100) DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `status` enum('CREATED','UPDATED','SYNCED','ERROR') DEFAULT NULL,
  `originalID` char(36) NOT NULL,
  `version` mediumint NOT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `metadata` text,
  PRIMARY KEY (`id`,`ownerID`),
  UNIQUE KEY `un_CondorFile_version` (`ownerID`,`originalID`,`version`),
  KEY `fk_CondorFile_Professional` (`ownerID`),
  KEY `fk_CondorFile_CondorFile` (`originalID`,`ownerID`),
  CONSTRAINT `fk_CondorFile_CondorFile` FOREIGN KEY (`originalID`, `ownerID`) REFERENCES `CondorFile` (`id`, `ownerID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_CondorFile_Professional` FOREIGN KEY (`ownerID`) REFERENCES `Professional` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CondorFile`
--

LOCK TABLES `CondorFile` WRITE;
/*!40000 ALTER TABLE `CondorFile` DISABLE KEYS */;
INSERT INTO `CondorFile` VALUES (2,'00045fa7-979b-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/00045fa7-979b-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_8e0fa860-808d-408c-b6a9-f15670797e86_SESS_9eccd5ad-22e1-4c9e-aa28-9e198895075c_TOSC_1db04197-2f6a-4ce2-ba32-efc29e65fee7_PLY_','2021-04-07 11:59:13','2021-04-07 13:59:11','00045fa7-979b-11eb-9377-226cec7cb58a.ply','2021-04-07 13:59:13','SYNCED','00045fa7-979b-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.3.15.1.2\",\"modelMatrix\":\"0.657151,0.683291,-0.318223,0,-0.753759,0.595715,-0.277437,0,2.03765e-8,0.422181,0.906511,0,-2.98665,-40.8869,-12.7893,1\",\"title\":\"Maxillaire PLY\"}'),(2,'00057e37-5a11-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/00057e37-5a11-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_b2d2515e-7d0a-4904-9d27-ac4e02fba617_SESS_056eaabd-a59c-4879-8f67-008ffb433a0e_BOSC_64e9b74c-2b40-4d4f-84c0-3cb17f506dfb_PLY_','2020-12-16 10:50:58','2020-02-28 10:53:37','00057e37-5a11-11ea-947d-226cec7cb58a.ply','2020-12-16 11:50:58','SYNCED','00057e37-5a11-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"modelMatrix\":\"-0.986366,0.159782,-0.0394005,0,-0.164568,-0.957679,0.236154,0,-1.97894e-9,0.239418,0.970917,0,-9.74739,15.3465,-17.9971,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0007b61c-5a11-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0007b61c-5a11-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_dc626d03-a041-4b5f-9433-09664a7ed4e6_ACT_b2d2515e-7d0a-4904-9d27-ac4e02fba617_SESS_056eaabd-a59c-4879-8f67-008ffb433a0e_TOSC_2eff0026-ccc9-423b-81b5-015ae60a0ea6_PLY_','2020-12-16 10:50:58','2020-02-28 10:50:49','0007b61c-5a11-11ea-947d-226cec7cb58a.ply','2020-12-16 11:50:58','SYNCED','0007b61c-5a11-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"modelMatrix\":\"0.535435,-0.797983,0.276644,0,0.844576,0.505897,-0.175384,0,1.04442e-8,0.327554,0.944832,0,-8.58789,-33.1869,-15.6023,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'00086c11-49e0-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/00086c11-49e0-11eb-94ee-226cec7cb58a.ply','PLY','PATIENT_836e646b-aced-4afc-8098-8f62cbfcc633_ACT_07e1346a-f756-4caf-86d0-cf4b71d869d4_SESS_fd59e2e1-d67b-4117-a766-c9f14d08d5a4_BOSC_d925981c-539a-45af-a583-6b32fea88c18_PLY_','2020-12-29 14:13:02','2020-12-29 15:02:19','00086c11-49e0-11eb-94ee-226cec7cb58a.ply','2020-12-29 15:13:02','SYNCED','00086c11-49e0-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.56.1.1\",\"modelMatrix\":\"-0.97076,0.214537,-0.107696,0,-0.240051,-0.867581,0.435522,0,-4.41641e-9,0.44864,0.893713,0,-18.1756,16.2784,-21.2528,1\",\"title\":\"Mandibule PLY\"}'),(2,'0008ed7a-979b-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0008ed7a-979b-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_8e0fa860-808d-408c-b6a9-f15670797e86_SESS_9eccd5ad-22e1-4c9e-aa28-9e198895075c_TOSC_ba9e4333-c0a1-4ebe-a2fb-b95b40e480d7_SNAPS_','2021-04-07 11:55:33','2021-04-07 13:55:32','0008ed7a-979b-11eb-9377-226cec7cb58a.png','2021-04-07 13:55:33','SYNCED','0008ed7a-979b-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.3.15.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'000963b7-5a11-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/000963b7-5a11-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_dc626d03-a041-4b5f-9433-09664a7ed4e6_ACT_b2d2515e-7d0a-4904-9d27-ac4e02fba617_SESS_056eaabd-a59c-4879-8f67-008ffb433a0e_TOSC_2eff0026-ccc9-423b-81b5-015ae60a0ea6_SNAPS_','2020-12-16 10:50:59','2020-02-28 10:50:49','000963b7-5a11-11ea-947d-226cec7cb58a.png','2020-12-16 11:50:59','SYNCED','000963b7-5a11-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'000af9d4-5a11-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/000af9d4-5a11-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_b2d2515e-7d0a-4904-9d27-ac4e02fba617_SESS_056eaabd-a59c-4879-8f67-008ffb433a0e_BOSC_64e9b74c-2b40-4d4f-84c0-3cb17f506dfb_SNAPS_','2020-12-16 10:50:59','2020-02-28 10:53:37','000af9d4-5a11-11ea-947d-226cec7cb58a.png','2020-12-16 11:50:59','SYNCED','000af9d4-5a11-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'000c270f-979b-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/000c270f-979b-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_8e0fa860-808d-408c-b6a9-f15670797e86_SESS_9eccd5ad-22e1-4c9e-aa28-9e198895075c_BOSC_7fae000c-c714-499f-992d-65d84b5b6f0e_PLY_','2021-04-07 12:15:01','2021-04-07 14:14:58','000c270f-979b-11eb-9377-226cec7cb58a.ply','2021-04-07 14:15:01','SYNCED','000c270f-979b-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.15.1.3\",\"modelMatrix\":\"-0.99784,0.0646844,-0.0114916,0,-0.0656972,-0.982456,0.174539,0,9.43953e-10,0.174917,0.984583,0,29.7334,10.374,-20.5571,1\",\"title\":\"Mandibule PLY\"}'),(2,'000eb559-49e0-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/000eb559-49e0-11eb-94ee-226cec7cb58a.png','SNAPS','PATIENT_836e646b-aced-4afc-8098-8f62cbfcc633_ACT_07e1346a-f756-4caf-86d0-cf4b71d869d4_SESS_fd59e2e1-d67b-4117-a766-c9f14d08d5a4_TOSC_f1965ba6-2df6-461d-bfe3-4d8755274c1b_SNAPS_','2020-12-29 14:13:02','2020-12-29 14:57:18','000eb559-49e0-11eb-94ee-226cec7cb58a.png','2020-12-29 15:13:02','SYNCED','000eb559-49e0-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.36.56.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'000fe904-49e0-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/000fe904-49e0-11eb-94ee-226cec7cb58a.png','SNAPS','PATIENT_836e646b-aced-4afc-8098-8f62cbfcc633_ACT_07e1346a-f756-4caf-86d0-cf4b71d869d4_SESS_fd59e2e1-d67b-4117-a766-c9f14d08d5a4_TOSC_f3100ed9-3420-4587-940c-af4d7f22d809_SNAPS_','2020-12-29 14:13:02','2020-12-29 14:59:53','000fe904-49e0-11eb-94ee-226cec7cb58a.png','2020-12-29 15:13:02','SYNCED','000fe904-49e0-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.36.56.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0010d9ec-dffc-4a1f-b561-bcfbea9379ac','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0010d9ec-dffc-4a1f-b561-bcfbea9379ac.ply','PLY','PATIENT_cb792ec3-1780-40fa-b01b-45b72329970a_ACT_bf1e82a2-d47f-4e1e-8585-5081cd72732d_SESS_af593c0e-7054-4435-96a3-d0215b9a1fc1_BOSC_94fdbaee-e5c4-4b24-b8c9-eaf73f18c1eb_PLY_','2021-12-07 08:38:04','2019-08-19 14:20:37','0010d9ec-dffc-4a1f-b561-bcfbea9379ac.ply','2021-12-07 09:38:04','SYNCED','0010d9ec-dffc-4a1f-b561-bcfbea9379ac',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 130.1.1.1\",\"modelMatrix\":\"-0.99907,0.0406562,-0.0143341,0,-0.0431091,-0.942224,0.332197,0,-7.93217e-11,0.332506,0.943101,0,-14.6704,12.686,-25.0713,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0011091b-49e0-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0011091b-49e0-11eb-94ee-226cec7cb58a.png','SNAPS','PATIENT_836e646b-aced-4afc-8098-8f62cbfcc633_ACT_07e1346a-f756-4caf-86d0-cf4b71d869d4_SESS_fd59e2e1-d67b-4117-a766-c9f14d08d5a4_BOSC_e7794d49-cb02-41d4-bde0-12c7f98cca81_SNAPS_','2020-12-29 14:13:03','2020-12-29 15:04:51','0011091b-49e0-11eb-94ee-226cec7cb58a.png','2020-12-29 15:13:03','SYNCED','0011091b-49e0-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.56.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'00124db0-49e0-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/00124db0-49e0-11eb-94ee-226cec7cb58a.ply','PLY','PATIENT_836e646b-aced-4afc-8098-8f62cbfcc633_ACT_07e1346a-f756-4caf-86d0-cf4b71d869d4_SESS_fd59e2e1-d67b-4117-a766-c9f14d08d5a4_TOSC_f3100ed9-3420-4587-940c-af4d7f22d809_PLY_','2020-12-29 14:13:02','2020-12-29 14:59:53','00124db0-49e0-11eb-94ee-226cec7cb58a.ply','2020-12-29 15:13:02','SYNCED','00124db0-49e0-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.36.56.1.3\",\"modelMatrix\":\"0.410491,-0.86432,0.290598,0,0.911864,0.389089,-0.130818,0,1.51851e-8,0.318686,0.94786,0,-9.21418,-27.5806,-20.0334,1\",\"title\":\"Maxillaire PLY\"}'),(2,'00136684-49e0-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/00136684-49e0-11eb-94ee-226cec7cb58a.png','SNAPS','PATIENT_836e646b-aced-4afc-8098-8f62cbfcc633_ACT_07e1346a-f756-4caf-86d0-cf4b71d869d4_SESS_fd59e2e1-d67b-4117-a766-c9f14d08d5a4_BOSC_d925981c-539a-45af-a583-6b32fea88c18_SNAPS_','2020-12-29 14:13:02','2020-12-29 15:02:19','00136684-49e0-11eb-94ee-226cec7cb58a.png','2020-12-29 15:13:02','SYNCED','00136684-49e0-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.56.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'00147f99-49e0-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/00147f99-49e0-11eb-94ee-226cec7cb58a.ply','PLY','PATIENT_836e646b-aced-4afc-8098-8f62cbfcc633_ACT_07e1346a-f756-4caf-86d0-cf4b71d869d4_SESS_fd59e2e1-d67b-4117-a766-c9f14d08d5a4_TOSC_f1965ba6-2df6-461d-bfe3-4d8755274c1b_PLY_','2020-12-29 14:13:01','2020-12-29 14:57:18','00147f99-49e0-11eb-94ee-226cec7cb58a.ply','2020-12-29 15:13:01','SYNCED','00147f99-49e0-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.36.56.1.2\",\"modelMatrix\":\"0.517861,-0.780293,0.350661,0,0.855465,0.472355,-0.212275,0,6.48511e-10,0.409907,0.912127,0,-2.87548,-31.7401,-21.9158,1\",\"title\":\"Maxillaire PLY\"}'),(2,'001593b1-49e0-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/001593b1-49e0-11eb-94ee-226cec7cb58a.ply','PLY','PATIENT_836e646b-aced-4afc-8098-8f62cbfcc633_ACT_07e1346a-f756-4caf-86d0-cf4b71d869d4_SESS_fd59e2e1-d67b-4117-a766-c9f14d08d5a4_TOSC_0b40271d-1057-453f-b76e-97ad134bc6be_PLY_','2020-12-29 14:13:02','2020-12-29 14:54:42','001593b1-49e0-11eb-94ee-226cec7cb58a.ply','2020-12-29 15:13:02','SYNCED','001593b1-49e0-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.36.56.1.1\",\"modelMatrix\":\"0.232581,-0.935146,0.267223,0,0.972577,0.22363,-0.0639035,0,8.87722e-10,0.274758,0.961513,0,-13.0284,-31.9308,-12.3694,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0016b281-49e0-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0016b281-49e0-11eb-94ee-226cec7cb58a.ply','PLY','PATIENT_836e646b-aced-4afc-8098-8f62cbfcc633_ACT_07e1346a-f756-4caf-86d0-cf4b71d869d4_SESS_fd59e2e1-d67b-4117-a766-c9f14d08d5a4_BOSC_e7794d49-cb02-41d4-bde0-12c7f98cca81_PLY_','2020-12-29 14:13:03','2020-12-29 15:04:51','0016b281-49e0-11eb-94ee-226cec7cb58a.ply','2020-12-29 15:13:03','SYNCED','0016b281-49e0-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.56.1.2\",\"modelMatrix\":\"-0.999361,-0.0351583,0.00642901,0,0.0357413,-0.983061,0.179762,0,-1.03631e-10,0.179876,0.983689,0,-18.2276,12.5461,-19.5607,1\",\"title\":\"Mandibule PLY\"}'),(2,'0016c365-438a-4e5f-9834-86e65c446348','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0016c365-438a-4e5f-9834-86e65c446348.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_2e136b79-6886-4f2a-b8b4-effe8e330226_SESS_2b9d3f75-c75f-47e7-8d78-6795d0921fc8_BOSC_3719cd94-efb7-43b8-afb1-a40ffa67d6e1_SNAPS_','2022-01-18 13:34:22','2022-01-18 14:34:16','0016c365-438a-4e5f-9834-86e65c446348.png','2022-01-18 14:34:22','SYNCED','0016c365-438a-4e5f-9834-86e65c446348',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.14.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0017ce41-49e0-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0017ce41-49e0-11eb-94ee-226cec7cb58a.png','SNAPS','PATIENT_836e646b-aced-4afc-8098-8f62cbfcc633_ACT_07e1346a-f756-4caf-86d0-cf4b71d869d4_SESS_fd59e2e1-d67b-4117-a766-c9f14d08d5a4_BOSC_991bbd3c-e40c-4b68-8320-40c65acef8c3_SNAPS_','2020-12-29 14:13:02','2020-12-29 15:12:24','0017ce41-49e0-11eb-94ee-226cec7cb58a.png','2020-12-29 15:13:02','SYNCED','0017ce41-49e0-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.56.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0018e421-49e0-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0018e421-49e0-11eb-94ee-226cec7cb58a.ply','PLY','PATIENT_836e646b-aced-4afc-8098-8f62cbfcc633_ACT_07e1346a-f756-4caf-86d0-cf4b71d869d4_SESS_fd59e2e1-d67b-4117-a766-c9f14d08d5a4_BOSC_991bbd3c-e40c-4b68-8320-40c65acef8c3_PLY_','2020-12-29 14:13:01','2020-12-29 15:12:24','0018e421-49e0-11eb-94ee-226cec7cb58a.ply','2020-12-29 15:13:01','SYNCED','0018e421-49e0-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.56.1.3\",\"modelMatrix\":\"-0.99518,0.0927649,-0.0318155,0,-0.0980691,-0.941354,0.322856,0,-1.19782e-9,0.324419,0.945913,0,-12.0113,17.4914,-17.7518,1\",\"title\":\"Mandibule PLY\"}'),(2,'0019f454-49e0-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0019f454-49e0-11eb-94ee-226cec7cb58a.png','SNAPS','PATIENT_836e646b-aced-4afc-8098-8f62cbfcc633_ACT_07e1346a-f756-4caf-86d0-cf4b71d869d4_SESS_fd59e2e1-d67b-4117-a766-c9f14d08d5a4_TOSC_0b40271d-1057-453f-b76e-97ad134bc6be_SNAPS_','2020-12-29 14:13:02','2020-12-29 14:54:42','0019f454-49e0-11eb-94ee-226cec7cb58a.png','2020-12-29 15:13:02','SYNCED','0019f454-49e0-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.36.56.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'00237f4b-0377-452a-8155-cb57df7c1043','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/00237f4b-0377-452a-8155-cb57df7c1043.ply','PLY','PATIENT_ad69c69a-426c-43c4-ae82-563304c2d0e6_ACT_be3b0b0d-107b-4498-9198-80777cbfbfd0_SESS_f98ef1f9-f488-4e6f-b23e-4fe84cba7b84_TOSC_ac903740-4c92-4747-b05f-1fdc6741795f_PLY_','2021-03-17 15:19:07','2021-03-17 15:39:30','00237f4b-0377-452a-8155-cb57df7c1043.ply','2021-03-17 16:19:07','SYNCED','00237f4b-0377-452a-8155-cb57df7c1043',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.94.1.2\",\"modelMatrix\":\"0.821899,-0.523554,0.22444,0,0.569633,0.755413,-0.323835,0,-1.02655e-8,0.394009,0.919107,0,12.1864,-30.8168,-16.4318,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0026f8f7-79ad-42f4-9381-a74d12908bd7','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0026f8f7-79ad-42f4-9381-a74d12908bd7.ply','PLY','PATIENT_d175f0ac-06f6-49a0-9ab4-bbd562516521_ACT_aa317266-3fb3-41c2-9073-a3de3bc4c25e_SESS_dfe9ad46-537f-4906-b524-e43990804e77_BOSC_60eb325b-c417-4cd5-b583-f6a1b33e83ee_PLY_','2021-01-06 11:01:41','2019-12-13 15:44:19','0026f8f7-79ad-42f4-9381-a74d12908bd7.ply','2021-01-06 12:01:41','SYNCED','0026f8f7-79ad-42f4-9381-a74d12908bd7',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 232.7.1.1\",\"modelMatrix\":\"-0.848858,0.512865,-0.1281,0,-0.528621,-0.823557,0.205703,0,7.31659e-9,0.24233,0.970194,0,-5.95898,17.4392,-19.223,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0036f03b-3a64-4a5c-bae7-df4dc58eb733','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0036f03b-3a64-4a5c-bae7-df4dc58eb733.ply','PLY','PATIENT_31590453-d088-4fec-8a78-3f7cffc3f3bc_ACT_f97a8f4e-31ca-4629-af01-578fbf3e7e49_SESS_9a2bd988-7a13-49ec-a900-83b0011cafa2_BOSC_93ed771d-48a0-4d1e-82b4-ff5e666b769f_PLY_','2021-12-07 08:38:04','2019-07-17 09:51:00','0036f03b-3a64-4a5c-bae7-df4dc58eb733.ply','2021-12-07 09:38:04','SYNCED','0036f03b-3a64-4a5c-bae7-df4dc58eb733',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 85.1.1.1\",\"modelMatrix\":\"-0.991168,-0.131404,0.0178513,0,0.132611,-0.982147,0.133425,0,-3.69299e-10,0.134614,0.990898,0,-16.3221,17.8337,-30.4683,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'00371ee1-a8ca-4afc-b20f-2e02bf391a21','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/00371ee1-a8ca-4afc-b20f-2e02bf391a21.ply','PLY','PATIENT_343826f8-7cce-45d2-8258-6107aa20f75e_ACT_bb36d322-c65b-4ae0-b3dc-e09d65e84b0a_SESS_dba76120-3278-40ff-89a9-22d765e29192_BOSC_0cdc978c-51df-44a3-aee8-9923c666fb7b_PLY_','2021-02-09 09:38:31','2021-02-09 10:38:07','00371ee1-a8ca-4afc-b20f-2e02bf391a21.ply','2021-02-09 10:38:31','SYNCED','00371ee1-a8ca-4afc-b20f-2e02bf391a21',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.32.1.3\",\"modelMatrix\":\"-0.92636,0.371135,-0.0641561,0,-0.376639,-0.912822,0.157795,0,-4.67292e-10,0.170339,0.985386,0,-11.6251,23.3761,-19.5115,1\",\"title\":\"Mandibule PLY\"}'),(2,'004387ae-384c-4caf-82c8-bf51c3de3e55','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/004387ae-384c-4caf-82c8-bf51c3de3e55.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_2e136b79-6886-4f2a-b8b4-effe8e330226_SESS_2b9d3f75-c75f-47e7-8d78-6795d0921fc8_BOSC_23227fc5-f888-4206-970e-8cca48a68603_ZIP_','2022-01-18 13:34:19','2022-01-18 14:31:43','004387ae-384c-4caf-82c8-bf51c3de3e55.zip','2022-01-18 14:34:19','SYNCED','004387ae-384c-4caf-82c8-bf51c3de3e55',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.14.1.1\",\"modelMatrix\":\"-0.904094,-0.403411,0.140974,0,0.427333,-0.853482,0.298253,0,-1.25439e-8,0.329892,0.944019,0,-23.0416,-2.28001,-21.8568,1\",\"title\":\"Mandibule ZIP\"}'),(2,'00460d20-8eb7-428c-a40a-98964f04a2e4','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/00460d20-8eb7-428c-a40a-98964f04a2e4.ply','PLY','PATIENT_55452abe-c899-4508-a6ad-a6862da81096_ACT_10244838-8d43-4b45-843e-1b1867b80fe9_SESS_a27242e6-79e3-49b8-9935-388a52c32306_TOSC_01c314a1-8c78-4274-8e37-28f8743f052f_PLY_','2020-12-08 10:47:03','2020-06-17 09:22:55','00460d20-8eb7-428c-a40a-98964f04a2e4.ply','2020-12-08 11:47:03','SYNCED','7ce02404-d34e-4a70-a1bd-2a27a1511971',1,NULL,'','','{\"displayTitle\":\"Maxillaire 32.1.1.1.4\",\"modelMatrix\":\"0.687928,-0.691083,0.221718,0,0.725779,0.655042,-0.210155,0,8.17336e-9,0.305489,0.952196,0,2.20199,-35.8443,-19.104,1\",\"title\":\"Maxillaire PLY\"}'),(2,'004ca9e0-ab9d-43c7-a982-3a23ceec469b','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/004ca9e0-ab9d-43c7-a982-3a23ceec469b.png','SNAPS','PATIENT_3ba502e6-1fd1-40ed-8e72-2db58e8c52bb_ACT_b85cc5f1-bba2-42c7-bfd1-3860fa4c9507_SESS_967609c2-b1ec-4e0c-9d19-428e57756ad6_BOSC_0dd0f29f-95ee-44ce-9cb5-6ea8a07d3a17_SNAPS_','2020-12-07 11:59:57','2020-07-27 15:09:44','004ca9e0-ab9d-43c7-a982-3a23ceec469b.png','2020-12-07 12:59:57','SYNCED','004ca9e0-ab9d-43c7-a982-3a23ceec469b',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.21.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'00574883-3085-4d90-b0aa-55688b7ca235','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/00574883-3085-4d90-b0aa-55688b7ca235.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_257dd477-2627-4db8-8086-959f71dc1e31_SESS_462a1c28-8f0c-4894-8ead-76198e14d14d_TOSC_879f5bc3-0040-418e-8eec-f5f8dc46eed6_PLY_','2021-04-26 07:16:50','2021-04-26 09:16:48','00574883-3085-4d90-b0aa-55688b7ca235.ply','2021-04-26 09:16:50','SYNCED','00574883-3085-4d90-b0aa-55688b7ca235',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.97.1.1\",\"modelMatrix\":\"0.661742,-0.681122,0.313322,0,0.749732,0.601184,-0.27655,0,-2.99024e-9,0.417913,0.908487,0,3.26752,-33.3779,-19.5847,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0058e42a-d6ac-4dfd-812a-3aecfc2c19ab','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0058e42a-d6ac-4dfd-812a-3aecfc2c19ab.png','SNAPS','PATIENT_7e22cea3-2410-4096-b67b-f5ff86cbbbfb_ACT_d48657d8-c0fb-4222-a110-dd1ebaab432f_SESS_24b5a3e6-f587-4413-b376-cbd60fa510d0_BOSC_30426bf2-811f-48e5-a2f5-c4937f82b5a6_SNAPS_','2021-09-20 11:55:39','2021-09-20 13:55:36','0058e42a-d6ac-4dfd-812a-3aecfc2c19ab.png','2021-09-20 13:55:39','SYNCED','0058e42a-d6ac-4dfd-812a-3aecfc2c19ab',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.398.1.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'00672b1b-af43-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/00672b1b-af43-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_4604a2b4-48cf-4b3a-9a4d-0b64e4cd6242_SESS_f94041da-6491-4d2d-853e-a3c26b26c4b7_BOSC_a2649343-62ca-4088-9859-c62a93db421b_PLY_','2021-05-07 14:40:37','2021-05-07 16:40:35','00672b1b-af43-11eb-9377-226cec7cb58a.ply','2021-05-07 16:40:37','SYNCED','00672b1b-af43-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.150.1.1\",\"modelMatrix\":\"-0.971172,-0.221298,0.0886169,0,0.238382,-0.901573,0.361027,0,-1.48573e-9,0.371744,0.928335,0,-25.7477,8.2231,-19.1647,1\",\"title\":\"Mandibule PLY\"}'),(2,'006a43be-af43-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/006a43be-af43-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_4604a2b4-48cf-4b3a-9a4d-0b64e4cd6242_SESS_f94041da-6491-4d2d-853e-a3c26b26c4b7_TOSC_486db6da-7d59-4372-8cb4-0c01221e605b_SNAPS_','2021-05-07 14:29:42','2021-05-07 16:29:35','006a43be-af43-11eb-9377-226cec7cb58a.png','2021-05-07 16:29:42','SYNCED','006a43be-af43-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.150.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'006abab7-d16c-4189-b05d-e0bfb0b871d6','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/006abab7-d16c-4189-b05d-e0bfb0b871d6.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_54ef530e-fe95-453d-b6ca-fcf4e17dfdf6_SESS_1e5ae9d8-b0b0-4c65-992b-0f2fdad9ac99_TOSC_1d8dc494-6f8e-4d9c-9543-0a0c9aabad7a_SNAPS_','2021-04-27 09:40:58','2021-04-27 11:40:57','006abab7-d16c-4189-b05d-e0bfb0b871d6.png','2021-04-27 11:40:58','SYNCED','006abab7-d16c-4189-b05d-e0bfb0b871d6',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.113.1.4\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'006cf59d-af43-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/006cf59d-af43-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_4604a2b4-48cf-4b3a-9a4d-0b64e4cd6242_SESS_f94041da-6491-4d2d-853e-a3c26b26c4b7_BOSC_dae16867-f3e1-48e2-9e3c-686ba3a64ea1_SNAPS_','2021-05-07 14:45:24','2021-05-07 16:45:23','006cf59d-af43-11eb-9377-226cec7cb58a.png','2021-05-07 16:45:24','SYNCED','006cf59d-af43-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.150.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'00707fe6-af43-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/00707fe6-af43-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_4604a2b4-48cf-4b3a-9a4d-0b64e4cd6242_SESS_f94041da-6491-4d2d-853e-a3c26b26c4b7_BOSC_feaa5658-b97d-4b9d-b50a-a64c9bd02709_SNAPS_','2021-05-07 14:38:20','2021-05-07 16:38:18','00707fe6-af43-11eb-9377-226cec7cb58a.png','2021-05-07 16:38:20','SYNCED','00707fe6-af43-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.150.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0072875a-4e1e-4db7-b8c8-2f820d8b2ba7','','PLY','PATIENT_55452abe-c899-4508-a6ad-a6862da81096_ACT_10244838-8d43-4b45-843e-1b1867b80fe9_SESS_a27242e6-79e3-49b8-9935-388a52c32306_TOSC_4f13b604-10d9-4f30-b6b6-1270427ec1ab_PLY_','2020-12-08 10:47:03','2020-06-17 09:13:25','','2020-12-08 11:47:03','SYNCED','0072875a-4e1e-4db7-b8c8-2f820d8b2ba7',0,NULL,'','','{\"displayTitle\":\"Maxillaire 32.1.1.1.2\",\"modelMatrix\":\"0.461522,-0.839354,0.287198,0,0.887129,0.436668,-0.149413,0,-3.26597e-9,0.323739,0.946146,0,-6.86067,-39.0227,-19.0746,1\",\"title\":\"Maxillaire PLY\"}'),(2,'007324cb-af43-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/007324cb-af43-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_4604a2b4-48cf-4b3a-9a4d-0b64e4cd6242_SESS_f94041da-6491-4d2d-853e-a3c26b26c4b7_BOSC_dae16867-f3e1-48e2-9e3c-686ba3a64ea1_PLY_','2021-05-07 14:45:25','2021-05-07 16:45:23','007324cb-af43-11eb-9377-226cec7cb58a.ply','2021-05-07 16:45:25','SYNCED','007324cb-af43-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.150.1.3\",\"modelMatrix\":\"-0.62524,-0.772629,0.110093,0,0.780433,-0.618987,0.0882003,0,-4.43749e-9,0.141066,0.99,0,-22.1299,-5.73637,-19.0067,1\",\"title\":\"Mandibule PLY\"}'),(2,'0077da32-af43-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0077da32-af43-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_4604a2b4-48cf-4b3a-9a4d-0b64e4cd6242_SESS_f94041da-6491-4d2d-853e-a3c26b26c4b7_BOSC_b4129e7b-e439-48cd-94f8-0f6a0fa91159_PLY_','2021-05-07 14:42:50','2021-05-07 16:42:46','0077da32-af43-11eb-9377-226cec7cb58a.ply','2021-05-07 16:42:50','SYNCED','0077da32-af43-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.150.1.2\",\"modelMatrix\":\"-0.977685,-0.195308,0.0773715,0,0.210076,-0.908959,0.360085,0,-1.02191e-9,0.368304,0.929706,0,-26.2422,8.27002,-17.8113,1\",\"title\":\"Mandibule PLY\"}'),(2,'007a9170-af43-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/007a9170-af43-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_4604a2b4-48cf-4b3a-9a4d-0b64e4cd6242_SESS_f94041da-6491-4d2d-853e-a3c26b26c4b7_TOSC_700bc86d-c916-48d8-9e2a-2535f908a5ea_SNAPS_','2021-05-07 14:27:06','2021-05-07 16:27:05','007a9170-af43-11eb-9377-226cec7cb58a.png','2021-05-07 16:27:06','SYNCED','007a9170-af43-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.150.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'007e567b-af43-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/007e567b-af43-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_4604a2b4-48cf-4b3a-9a4d-0b64e4cd6242_SESS_f94041da-6491-4d2d-853e-a3c26b26c4b7_BOSC_b4129e7b-e439-48cd-94f8-0f6a0fa91159_SNAPS_','2021-05-07 14:42:49','2021-05-07 16:42:46','007e567b-af43-11eb-9377-226cec7cb58a.png','2021-05-07 16:42:49','SYNCED','007e567b-af43-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.150.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'008391e8-af43-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/008391e8-af43-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_4604a2b4-48cf-4b3a-9a4d-0b64e4cd6242_SESS_f94041da-6491-4d2d-853e-a3c26b26c4b7_TOSC_486db6da-7d59-4372-8cb4-0c01221e605b_PLY_','2021-05-07 14:29:42','2021-05-07 16:29:35','008391e8-af43-11eb-9377-226cec7cb58a.ply','2021-05-07 16:29:42','SYNCED','008391e8-af43-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.150.1.2\",\"modelMatrix\":\"0.472197,-0.821785,0.318904,0,0.881493,0.440212,-0.17083,0,-1.61853e-9,0.361777,0.932265,0,-2.3822,-35.5391,-18.2214,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0086387f-af43-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0086387f-af43-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_4604a2b4-48cf-4b3a-9a4d-0b64e4cd6242_SESS_f94041da-6491-4d2d-853e-a3c26b26c4b7_BOSC_feaa5658-b97d-4b9d-b50a-a64c9bd02709_PLY_','2021-05-07 14:38:20','2021-05-07 16:38:18','0086387f-af43-11eb-9377-226cec7cb58a.ply','2021-05-07 16:38:20','SYNCED','0086387f-af43-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.150.1.3\",\"modelMatrix\":\"0.807546,-0.521947,0.274664,0,0.589804,0.714638,-0.376064,0,1.25002e-8,0.465687,0.884949,0,8.93079,-31.4322,-20.8501,1\",\"title\":\"Maxillaire PLY\"}'),(2,'008765bb-af75-4240-ad7b-4d05be3367fe','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/008765bb-af75-4240-ad7b-4d05be3367fe.png','SNAPS','PATIENT_8f2a30ae-f5f0-42c4-9e6c-369d6d815a83_ACT_d8442e32-491d-4b5e-88dd-348895bccb5f_SESS_6134d13f-57ab-4858-bdd8-c5d63443974b_TOSC_652ab7ba-3e4d-4273-975b-6a93c47a9ab3_SNAPS_','2021-08-05 07:30:31','2019-12-02 14:04:18','008765bb-af75-4240-ad7b-4d05be3367fe.png','2021-08-05 09:30:31','SYNCED','008765bb-af75-4240-ad7b-4d05be3367fe',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 222.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0088f13b-af43-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0088f13b-af43-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_4604a2b4-48cf-4b3a-9a4d-0b64e4cd6242_SESS_f94041da-6491-4d2d-853e-a3c26b26c4b7_BOSC_a2649343-62ca-4088-9859-c62a93db421b_SNAPS_','2021-05-07 14:40:36','2021-05-07 16:40:35','0088f13b-af43-11eb-9377-226cec7cb58a.png','2021-05-07 16:40:36','SYNCED','0088f13b-af43-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.150.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'008c5b7d-6c80-4464-b459-8707c9166c07','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/008c5b7d-6c80-4464-b459-8707c9166c07.ply','PLY','PATIENT_d4967e19-0c25-4372-a1c0-fce39834d889_ACT_7a6e9856-edb8-4cfb-8c77-b4c448b6babc_SESS_dc71eec0-e740-48be-9129-148506c48a96_BOSC_fd67ce7b-31e0-461d-8306-962f7bf7d302_PLY_','2021-01-26 08:44:43','2021-01-26 09:44:18','008c5b7d-6c80-4464-b459-8707c9166c07.ply','2021-01-26 09:44:43','SYNCED','008c5b7d-6c80-4464-b459-8707c9166c07',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.22.1.3\",\"modelMatrix\":\"-0.93802,0.344479,-0.0381299,0,-0.346582,-0.932325,0.103198,0,-5.93968e-10,0.110017,0.99393,0,-6.81685,17.335,-20.6895,1\",\"title\":\"Mandibule PLY\"}'),(2,'008d817f-24e0-419f-b377-214a171b907a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/008d817f-24e0-419f-b377-214a171b907a.ply','PLY','PATIENT_9a85396a-bf2e-429d-90b8-e6390f6c2bff_ACT_65c82d4e-bd81-4ed9-81b2-5861f9e63c77_SESS_93240eae-0122-4833-bb58-d5b0b3bdc35c_TOSC_aee56a44-470e-4188-8b43-4591725f27be_PLY_','2021-03-29 13:50:59','2021-03-29 15:31:41','008d817f-24e0-419f-b377-214a171b907a.ply','2021-03-29 15:50:59','SYNCED','008d817f-24e0-419f-b377-214a171b907a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.13.1.2\",\"modelMatrix\":\"-0.0690242,-0.957411,0.280356,0,0.997615,-0.0662425,0.0193976,0,-1.99868e-9,0.281026,0.9597,0,-17.2126,-15.6541,-20.2764,1\",\"title\":\"Maxillaire PLY\"}'),(2,'008dd458-fcea-4159-bc56-f9c209d6d2fc','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/008dd458-fcea-4159-bc56-f9c209d6d2fc.png','SNAPS','PATIENT_37924e66-6fca-42d1-866c-8897f314ef35_ACT_b97bc99b-fc77-46b8-82b7-151aef0aec54_SESS_f2ff3c9a-d754-4dd6-9785-85c513b9862b_FRSC_a7270607-d7cb-4657-bf0e-3f62029d18f8_SNAPS_','2021-12-07 08:38:04','2019-09-05 11:48:28','008dd458-fcea-4159-bc56-f9c209d6d2fc.png','2021-12-07 09:38:04','SYNCED','008dd458-fcea-4159-bc56-f9c209d6d2fc',0,NULL,'','','{\"displayTitle\":\"MORDU_ANTERIEUR 145.1.1.1\",\"title\":\"MORDU_ANTERIEUR SNAPSHOT\"}'),(2,'009792bb-af43-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/009792bb-af43-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_4604a2b4-48cf-4b3a-9a4d-0b64e4cd6242_SESS_f94041da-6491-4d2d-853e-a3c26b26c4b7_TOSC_700bc86d-c916-48d8-9e2a-2535f908a5ea_PLY_','2021-05-07 14:27:07','2021-05-07 16:27:05','009792bb-af43-11eb-9377-226cec7cb58a.ply','2021-05-07 16:27:07','SYNCED','009792bb-af43-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.150.1.1\",\"modelMatrix\":\"0.825119,-0.496913,0.268806,0,0.564959,0.725738,-0.392589,0,-1.23116e-9,0.475797,0.879555,0,8.45334,-31.6084,-20.0243,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0098c1b0-6221-46a4-9741-b3d423ab7be5','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0098c1b0-6221-46a4-9741-b3d423ab7be5.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_f202055f-ac20-4cbc-94d0-4d2d8fc61c91_SESS_b9a0ed7c-42f5-420b-aed4-367b56b4c33e_BOSC_ee7e176e-175f-4b6b-86a9-1fe7797387f3_SNAPS_','2021-04-22 11:37:50','2021-04-22 13:37:49','0098c1b0-6221-46a4-9741-b3d423ab7be5.png','2021-04-22 13:37:50','SYNCED','0098c1b0-6221-46a4-9741-b3d423ab7be5',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.88.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'009abdb0-7e60-4ff3-9e08-d2a6086bb81a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/009abdb0-7e60-4ff3-9e08-d2a6086bb81a.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_90c93879-61c0-4889-afd1-8ea1d0830968_SESS_096ec595-b272-4e19-88f1-82ddc44d87e6_BOSC_62f9c593-a740-4f0f-82b8-f6459a4336d4_SNAPS_','2021-09-28 14:23:01','2021-09-28 16:22:56','009abdb0-7e60-4ff3-9e08-d2a6086bb81a.png','2021-09-28 16:23:01','SYNCED','009abdb0-7e60-4ff3-9e08-d2a6086bb81a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.22.32.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'009b6017-5601-4616-9bb2-5f607153d95a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/009b6017-5601-4616-9bb2-5f607153d95a.ply','PLY','PATIENT_84ae5037-530d-4b80-b4fe-be5f7a87fcac_ACT_0c055014-70ef-4bc9-a40d-cc25beebe0b1_SESS_54041e61-6c3e-474c-9e65-d3ee1065b0ea_BOSC_1f65ceae-de4f-4c74-ad64-1b7c91e8965d_PLY_','2021-03-30 11:30:18','2021-03-30 12:16:23','009b6017-5601-4616-9bb2-5f607153d95a.ply','2021-03-30 13:30:18','SYNCED','009b6017-5601-4616-9bb2-5f607153d95a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.20.1.2\",\"modelMatrix\":\"-0.945835,-0.31577,0.0754054,0,0.324649,-0.919968,0.219687,0,1.05052e-9,0.232267,0.972652,0,-20.7542,8.44465,-16.8141,1\",\"title\":\"Mandibule PLY\"}'),(2,'009d2bd7-8900-43a5-a9ce-a358c2219d76','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/009d2bd7-8900-43a5-a9ce-a358c2219d76.png','SNAPS','PATIENT_b5175e9d-08f4-4415-b50b-283660874b04_ACT_fe12f57f-8a89-45ce-8931-e0345a73fb44_SESS_e5517215-0e90-4775-92a9-416fcb299a3e_BOSC_272ffb6f-91b1-4d53-813e-3ba8fd42aab8_SNAPS_','2020-12-29 09:50:00','2020-12-29 10:49:38','009d2bd7-8900-43a5-a9ce-a358c2219d76.png','2020-12-29 10:50:00','SYNCED','009d2bd7-8900-43a5-a9ce-a358c2219d76',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.51.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'00a07565-3f1d-4e19-899f-92e12faee654','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/00a07565-3f1d-4e19-899f-92e12faee654.ply','PLY','PATIENT_491f6fac-4e7b-45ff-853c-c5880019fa93_ACT_61c527a3-56f3-4776-8cbd-02a3124364d4_SESS_ccd013fe-71ee-415b-8735-209f53c9eeeb_TOSC_c2365fda-e48c-4578-9778-b189e4c33936_PLY_','2021-01-26 14:45:35','2021-01-26 15:20:20','00a07565-3f1d-4e19-899f-92e12faee654.ply','2021-01-26 15:45:35','SYNCED','00a07565-3f1d-4e19-899f-92e12faee654',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.24.1.2\",\"modelMatrix\":\"0.512078,-0.797582,0.318808,0,0.858939,0.475499,-0.190066,0,-4.89957e-9,0.371165,0.928567,0,-4.25485,-31.1212,-20.0564,1\",\"title\":\"Maxillaire PLY\"}'),(2,'00a4e5b1-8e40-4c39-a4ff-6ec3a3377136','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/00a4e5b1-8e40-4c39-a4ff-6ec3a3377136.ply','PLY','PATIENT_39e11d81-2352-46cd-b84f-804c1eabbb73_ACT_54502317-c9f2-4b3f-aa83-b277d11b57b5_SESS_58a6c424-0070-4888-9a9f-76e675670047_TOSC_0669b7a3-7d6c-4a94-b638-246368bae685_PLY_','2021-02-25 12:53:45','2021-02-25 13:43:29','00a4e5b1-8e40-4c39-a4ff-6ec3a3377136.ply','2021-02-25 13:53:45','SYNCED','00a4e5b1-8e40-4c39-a4ff-6ec3a3377136',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.53.1.3\",\"modelMatrix\":\"0.760866,-0.605589,0.233119,0,0.648908,0.710072,-0.27334,0,2.39128e-8,0.359249,0.933242,0,5.84741,-32.6857,-19.2845,1\",\"title\":\"Maxillaire PLY\"}'),(2,'00a5d051-aafe-4963-8874-4934e74674dc','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/00a5d051-aafe-4963-8874-4934e74674dc.ply','PLY','PATIENT_491f6fac-4e7b-45ff-853c-c5880019fa93_ACT_61c527a3-56f3-4776-8cbd-02a3124364d4_SESS_ccd013fe-71ee-415b-8735-209f53c9eeeb_BOSC_d5af1c96-afad-4b25-a8b1-9ce4e2eee1d1_PLY_','2021-01-26 14:45:37','2021-01-26 15:35:54','00a5d051-aafe-4963-8874-4934e74674dc.ply','2021-01-26 15:45:37','SYNCED','00a5d051-aafe-4963-8874-4934e74674dc',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.24.1.1\",\"modelMatrix\":\"-0.955774,0.289329,-0.0527746,0,-0.294103,-0.94026,0.171507,0,3.06658e-9,0.179443,0.983768,0,-13.1166,20.5093,-16.1415,1\",\"title\":\"Mandibule PLY\"}'),(2,'00a7f400-298c-415b-9800-317bdcf8df65','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/00a7f400-298c-415b-9800-317bdcf8df65.png','SNAPS','PATIENT_5a36b509-d87e-4dda-807e-a616406aaa4c_ACT_285e7e26-b813-4dd7-84e7-f265f6e87fd6_SESS_7bf03134-a6b7-430c-ad8b-e85f04d49949_BOSC_c7be66cf-5138-4859-857c-d5eccd76506b_SNAPS_','2022-03-22 14:16:29','2022-03-22 15:16:25','00a7f400-298c-415b-9800-317bdcf8df65.png','2022-03-22 15:16:29','SYNCED','00a7f400-298c-415b-9800-317bdcf8df65',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.412.1.1.13\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'00a86396-528d-4cb3-b45d-f04917e29e89','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/00a86396-528d-4cb3-b45d-f04917e29e89.ply','PLY','PATIENT_aa33ba4f-57d4-473c-99f1-9ce301adcba9_ACT_950b6d17-2c4c-4052-969e-e70f65959620_SESS_7f9de4d9-f433-4a03-a9d6-dc607602722c_TOSC_f4fe35a7-d9e5-4661-a2b8-e2ed0374685b_PLY_','2021-01-06 11:01:42','2019-12-13 16:13:35','00a86396-528d-4cb3-b45d-f04917e29e89.ply','2021-01-06 12:01:42','SYNCED','00a86396-528d-4cb3-b45d-f04917e29e89',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 232.28.1.1\",\"modelMatrix\":\"0.599587,-0.754989,0.265496,0,0.80031,0.565632,-0.198908,0,-4.76656e-9,0.331742,0.94337,0,1.80296,-36.2041,-18.9692,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'00a98a54-6a71-4a9d-86aa-fbfe9e7e8bff','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/00a98a54-6a71-4a9d-86aa-fbfe9e7e8bff.png','SNAPS','PATIENT_72b315b2-aa50-4850-ba10-6553f6ea4ff1_ACT_ae5f4ba0-b39f-4474-ba5c-35072e2b2e69_SESS_984d3625-f60e-46cc-a1bc-b41b3dd6a003_BOSC_923877cf-e92d-48fa-a352-53a301e1b21a_SNAPS_','2021-01-22 08:47:52','2021-01-22 09:37:57','00a98a54-6a71-4a9d-86aa-fbfe9e7e8bff.png','2021-01-22 09:47:52','SYNCED','00a98a54-6a71-4a9d-86aa-fbfe9e7e8bff',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.15.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'00be63fe-c4dc-4b74-85d3-32c4ef71fbcf','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/00be63fe-c4dc-4b74-85d3-32c4ef71fbcf.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_7e31dc23-e958-4dce-a295-bc79e0259c7b_SNAPS_','2020-12-16 11:05:18','2020-01-24 14:15:19','00be63fe-c4dc-4b74-85d3-32c4ef71fbcf.png','2020-12-16 12:05:18','SYNCED','00be63fe-c4dc-4b74-85d3-32c4ef71fbcf',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.16\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'00c5afe5-4d04-4a16-af2f-50196331a593','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/00c5afe5-4d04-4a16-af2f-50196331a593.ply','PLY','PATIENT_6d10d353-f9ee-49ee-96fd-c0d65ddc167b_ACT_4eccb6a1-44bb-4070-bff3-a6c627532096_SESS_164654c4-25e0-4f02-abba-5ef5057ee2b9_BOSC_21ba6f8e-090f-470b-a76e-4e331bd27d2f_PLY_','2021-09-15 08:21:19','2021-09-15 10:21:17','00c5afe5-4d04-4a16-af2f-50196331a593.ply','2021-09-15 10:21:19','SYNCED','00c5afe5-4d04-4a16-af2f-50196331a593',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.385.1.1.1\",\"modelMatrix\":\"-0.963728,-0.23175,0.132366,0,0.266888,-0.836847,0.477973,0,-2.60046e-9,0.495963,0.868344,0,-17.6113,3.28806,-19.0002,1\",\"title\":\"Mandibule PLY\"}'),(2,'00cc5701-a837-4eed-b15f-41cdca298f6c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/00cc5701-a837-4eed-b15f-41cdca298f6c.stl','STL','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_BOSC_3c967e5f-226a-49e0-8aaa-a64bdd6bd888_STL_','2021-12-07 08:38:04','2019-11-14 11:37:33','00cc5701-a837-4eed-b15f-41cdca298f6c.stl','2021-12-07 09:38:04','SYNCED','00cc5701-a837-4eed-b15f-41cdca298f6c',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 202.1.1.1\",\"modelMatrix\":\"0.625309,0.779918,-0.0267683,0,-0.780377,0.624941,-0.0214492,0,8.88769e-10,0.0343017,0.999411,0,18.605,4.26683,-30.1581,1\",\"title\":\"MANDIBULE STL\"}'),(2,'00ce9163-483a-42f0-a669-594a3618d0e0','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/00ce9163-483a-42f0-a669-594a3618d0e0.ply','PLY','PATIENT_8d565568-bbb5-4fd1-8ede-55e39e995ccf_ACT_91ce882c-e314-4560-a2d9-37c4670ad1f1_SESS_51a75dc9-2077-4669-9515-a135280c2521_BOSC_9e44801d-4a0c-4630-a348-bf9df7d4fe81_PLY_','2020-12-30 12:48:29','2020-12-30 13:44:28','00ce9163-483a-42f0-a669-594a3618d0e0.ply','2020-12-30 13:48:29','SYNCED','00ce9163-483a-42f0-a669-594a3618d0e0',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.60.1.2\",\"modelMatrix\":\"-0.994801,0.0955143,-0.0353376,0,-0.101842,-0.932994,0.345182,0,-2.69318e-10,0.346986,0.93787,0,-8.61289,15.204,-18.0761,1\",\"title\":\"Mandibule PLY\"}'),(2,'00ce9540-d255-4a34-8b13-3c22e692383f','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/00ce9540-d255-4a34-8b13-3c22e692383f.png','SNAPS','PATIENT_72f539f4-2d06-47fa-b0b8-1291879a4818_ACT_d55baca2-6f09-4446-a148-dcdcfcaf57d8_SESS_5efdc987-8bdd-454f-b282-82efcf807bae_TOSC_a3a8b1cb-3fe8-4a12-ae47-0a86ec64a47d_SNAPS_','2021-08-05 07:30:31','2019-11-26 11:23:27','00ce9540-d255-4a34-8b13-3c22e692383f.png','2021-08-05 09:30:31','SYNCED','00ce9540-d255-4a34-8b13-3c22e692383f',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 86.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'00d80db4-423d-438a-8824-df487e24af32','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/00d80db4-423d-438a-8824-df487e24af32.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_5b014f5c-e8f3-4a1a-b603-2fe2f403b6ff_SESS_688e1fdc-fe0f-4a17-b81a-5073ff1261b2_BOSC_ecbe9fd9-a4e8-438d-9830-8d668e151361_PLY_','2021-04-27 07:25:26','2021-04-27 09:25:24','00d80db4-423d-438a-8824-df487e24af32.ply','2021-04-27 09:25:26','SYNCED','00d80db4-423d-438a-8824-df487e24af32',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.109.1.2\",\"modelMatrix\":\"-0.542306,-0.821591,0.175763,0,0.840181,-0.530307,0.113449,0,2.16605e-9,0.209196,0.977874,0,-24.1677,-13.3336,-15.1609,1\",\"title\":\"Mandibule PLY\"}'),(2,'00db8693-de3e-4b54-ab3e-ef1f8ccbaf90','','SNAPS','PATIENT_c99d352c-a346-4446-b7d9-4cacf017b67a_ACT_2b22a50e-19be-4908-85ec-2b3c28f8a0a3_SESS_98d25a16-10f9-498a-b3ce-02ed35bb57db_BOSC_f8c7ea3d-e8d3-4562-8cc9-7f56875943af_SNAPS_','2022-03-04 13:40:19','2019-07-09 13:26:08','','2022-03-04 14:40:19','SYNCED','00db8693-de3e-4b54-ab3e-ef1f8ccbaf90',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 12.2.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'00e26269-60f2-41c2-bc11-e6e6078715b8','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/00e26269-60f2-41c2-bc11-e6e6078715b8.ply','PLY','PATIENT_2723e13b-24b4-474f-97a7-0d782b6e6f62_ACT_1b19b5ef-5efa-43cf-9f25-74f18102addf_SESS_3f05bea5-6f8a-4370-8c23-525f24a560f5_TOSC_f4b9963e-9d04-4d62-8263-23174ecefc34_PLY_','2020-11-24 09:56:59','2020-11-24 10:55:00','00e26269-60f2-41c2-bc11-e6e6078715b8.ply','2020-11-24 10:56:59','SYNCED','00e26269-60f2-41c2-bc11-e6e6078715b8',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.67.1.1.17\",\"modelMatrix\":\"0.803924,-0.57281,0.159982,0,0.594732,0.774292,-0.216254,0,-1.00524e-8,0.268998,0.963141,0,3.52004,-31.0332,-19.5022,1\",\"title\":\"Maxillaire PLY\"}'),(2,'00e32b92-a858-4fb9-a2d7-c9143ad1a255','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/00e32b92-a858-4fb9-a2d7-c9143ad1a255.ply','PLY','PATIENT_dbda7760-f2f9-4791-9f9d-be009bb35b1e_ACT_ffdb4e6a-04ae-4972-8f71-ecba65562e29_SESS_504a17a4-8142-4881-a975-50c3158dbcbc_BOSC_7fdeaa2e-d925-4849-aaeb-c372eed477a2_PLY_','2021-03-19 15:34:37','2021-03-19 16:33:21','00e32b92-a858-4fb9-a2d7-c9143ad1a255.ply','2021-03-19 16:34:37','SYNCED','00e32b92-a858-4fb9-a2d7-c9143ad1a255',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.101.1.3\",\"modelMatrix\":\"0.923884,-0.382446,0.0131573,0,0.382672,0.923338,-0.0317656,0,-9.35159e-10,0.0343827,0.999409,0,6.25844,-22.2279,-18.9306,1\",\"title\":\"Mandibule PLY\"}'),(2,'00e5db7c-c706-4ff4-9e11-6cd288794cdc','','SNAPS','PATIENT_c7b0d417-236c-47d8-a68a-c50573406e7f_ACT_6fbd34aa-198e-41fc-bd31-6d32e9cb2a63_SESS_45d9fc14-280f-4061-b402-5fb09f88b9a6_TOSC_86628812-50cc-40ea-bc65-2cdde7e6ef61_SNAPS_','2021-03-29 09:14:35','2021-03-29 11:14:34','','2021-03-29 11:14:35','SYNCED','00e5db7c-c706-4ff4-9e11-6cd288794cdc',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.293.1.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'00e72ba1-e3c3-4148-834e-d313cbe23f4f','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/00e72ba1-e3c3-4148-834e-d313cbe23f4f.ply','PLY','PATIENT_67c10a45-b4ec-42ba-ae2c-900a195adb87_ACT_86b9837f-894c-450e-be34-50dce2fbdc92_SESS_11baa7ef-ca17-442b-a5da-1d859ce1c951_BOSC_cda8c336-ec40-4e26-8336-664a2f417b06_PLY_','2021-12-07 08:38:05','2019-10-14 11:15:29','00e72ba1-e3c3-4148-834e-d313cbe23f4f.ply','2021-12-07 09:38:05','SYNCED','00e72ba1-e3c3-4148-834e-d313cbe23f4f',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.19.1.1\",\"modelMatrix\":\"-0.888695,0.432995,-0.150785,0,-0.458498,-0.839263,0.292262,0,-7.26766e-9,0.328866,0.944377,0,-7.01934,24.555,-16.6179,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'00eb9493-7cf9-4f10-a3b6-b4be4d9ff573','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/00eb9493-7cf9-4f10-a3b6-b4be4d9ff573.png','SNAPS','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_aab352b3-f896-484e-b823-b003f886e707_SESS_454ec56d-1b46-41c6-8814-9bf697c0e0c5_TOSC_40312bd4-45f7-4775-8da3-5be630be3fd4_SNAPS_','2020-12-07 11:59:58','2020-08-26 13:47:13','00eb9493-7cf9-4f10-a3b6-b4be4d9ff573.png','2020-12-07 12:59:58','SYNCED','1715383e-a4b6-439b-9d10-d2e5e7f8b57a',1,NULL,'','','{\"displayTitle\":\"Maxillaire 216.26.64.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'00ef85a8-d54f-47a0-ab98-2553f61c0c87','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/00ef85a8-d54f-47a0-ab98-2553f61c0c87.ply','PLY','PATIENT_c492daba-3b06-4146-ac74-45e279804dc4_ACT_f50b069c-0ac3-4dc7-bc52-6b6b6795221b_SESS_42584b60-4e45-4b33-b10b-29f02cb1966e_TOSC_d35e01ba-54a2-418a-addb-39352efcc93e_PLY_','2021-01-22 09:29:30','2021-01-22 10:10:40','00ef85a8-d54f-47a0-ab98-2553f61c0c87.ply','2021-01-22 10:29:30','SYNCED','00ef85a8-d54f-47a0-ab98-2553f61c0c87',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.16.1.1\",\"modelMatrix\":\"0.526928,-0.823612,0.209786,0,0.84991,0.510624,-0.130064,0,-8.85277e-9,0.246834,0.969058,0,-8.45831,-35.0106,-16.1623,1\",\"title\":\"Maxillaire PLY\"}'),(2,'00f419ed-978c-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/00f419ed-978c-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_c7a6f6ba-bf16-4193-bed4-711092e6844c_SESS_09f61616-e0f4-4e63-a2ec-573869a1da0e_BOSC_67ca2c4e-d8f2-465c-8f7f-f6d0666e9e93_SNAPS_','2021-04-07 10:00:48','2021-04-07 12:00:47','00f419ed-978c-11eb-9377-226cec7cb58a.png','2021-04-07 12:00:48','SYNCED','00f419ed-978c-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.13.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'00f837e2-978c-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/00f837e2-978c-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_c7a6f6ba-bf16-4193-bed4-711092e6844c_SESS_09f61616-e0f4-4e63-a2ec-573869a1da0e_BOSC_192d466b-1fad-421a-9b0b-8cd1b84186ed_SNAPS_','2021-04-07 10:27:22','2021-04-07 12:27:20','00f837e2-978c-11eb-9377-226cec7cb58a.png','2021-04-07 12:27:22','SYNCED','00f837e2-978c-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.13.1.4\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'00f8b3e7-8f79-477e-8645-486359247ca0','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/00f8b3e7-8f79-477e-8645-486359247ca0.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_33382f44-8f0f-4c22-988b-651420fbeabc_SESS_7b2d35d1-5b80-4f87-9ca5-b00ddbafec19_BOSC_731cee98-2ce5-4496-8b45-3b5204d1bc93_PLY_','2021-04-27 08:20:45','2021-04-27 10:20:43','00f8b3e7-8f79-477e-8645-486359247ca0.ply','2021-04-27 10:20:45','SYNCED','00f8b3e7-8f79-477e-8645-486359247ca0',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.111.1.3\",\"modelMatrix\":\"-0.985509,-0.155703,0.0672896,0,0.169622,-0.904645,0.390956,0,1.59771e-9,0.396705,0.917946,0,-25.6514,7.02969,-18.5016,1\",\"title\":\"Mandibule PLY\"}'),(2,'00fb3492-978c-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/00fb3492-978c-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_c7a6f6ba-bf16-4193-bed4-711092e6844c_SESS_09f61616-e0f4-4e63-a2ec-573869a1da0e_BOSC_67ca2c4e-d8f2-465c-8f7f-f6d0666e9e93_PLY_','2021-04-07 10:23:28','2021-04-07 12:23:27','00fb3492-978c-11eb-9377-226cec7cb58a.ply','2021-04-07 12:23:28','SYNCED','00fb3492-978c-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.13.1.2\",\"modelMatrix\":\"-0.999978,-0.00645101,0.00123211,0,0.00656762,-0.982224,0.1876,0,-7.18056e-11,0.187604,0.982245,0,28.1374,16.0675,-17.2408,1\",\"title\":\"Mandibule PLY\"}'),(2,'00ff458e-978c-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/00ff458e-978c-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_c7a6f6ba-bf16-4193-bed4-711092e6844c_SESS_09f61616-e0f4-4e63-a2ec-573869a1da0e_TOSC_910ccb90-9897-44b3-954f-7f492c3f7703_PLY_','2021-04-07 10:22:08','2021-04-07 12:22:06','00ff458e-978c-11eb-9377-226cec7cb58a.ply','2021-04-07 12:22:08','SYNCED','00ff458e-978c-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.3.13.1.2\",\"modelMatrix\":\"0.0321973,0.888933,-0.456905,0,-0.999482,0.028636,-0.0147187,0,5.45164e-10,0.457142,0.889394,0,-18.5478,-33.9557,-10.5157,1\",\"title\":\"Maxillaire PLY\"}'),(2,'01035ea4-978c-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01035ea4-978c-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_c7a6f6ba-bf16-4193-bed4-711092e6844c_SESS_09f61616-e0f4-4e63-a2ec-573869a1da0e_BOSC_be7992af-7764-4f1d-8629-bd01d1529bc5_PLY_','2021-04-07 10:23:56','2021-04-07 12:23:55','01035ea4-978c-11eb-9377-226cec7cb58a.ply','2021-04-07 12:23:56','SYNCED','01035ea4-978c-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.13.1.3\",\"modelMatrix\":\"-0.802248,0.594144,-0.0582399,0,-0.596991,-0.798421,0.0782639,0,4.57143e-9,0.0975557,0.99523,0,29.3859,-8.78817,-17.9697,1\",\"title\":\"Mandibule PLY\"}'),(2,'0106c5b4-978c-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0106c5b4-978c-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_c7a6f6ba-bf16-4193-bed4-711092e6844c_SESS_09f61616-e0f4-4e63-a2ec-573869a1da0e_TOSC_910ccb90-9897-44b3-954f-7f492c3f7703_SNAPS_','2021-04-07 10:11:10','2021-04-07 12:11:08','0106c5b4-978c-11eb-9377-226cec7cb58a.png','2021-04-07 12:11:10','SYNCED','0106c5b4-978c-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.3.13.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0106f27b-76ec-4cc3-8c16-bf68325c6b9a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0106f27b-76ec-4cc3-8c16-bf68325c6b9a.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_4d5f9849-771f-4905-b4af-9f54867d3981_SESS_634356c8-f0f1-4841-b539-8f2ec59be200_BOSC_7cba2d58-2100-46e7-99be-c0c289fca438_PLY_','2020-12-16 10:51:02','2020-05-27 13:42:11','0106f27b-76ec-4cc3-8c16-bf68325c6b9a.ply','2020-12-16 11:51:02','SYNCED','0106f27b-76ec-4cc3-8c16-bf68325c6b9a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 216.1.14.1.1\",\"modelMatrix\":\"-0.862183,0.505,-0.0402044,0,-0.506597,-0.859463,0.0684243,0,1.4102e-9,0.0793617,0.996846,0,-7.23584,17.3611,-20.1938,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'010a89c8-1d6e-4abe-a1fa-4f0414c2f603','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/010a89c8-1d6e-4abe-a1fa-4f0414c2f603.ply','PLY','PATIENT_111e5366-f505-4c14-8460-77c6ab607391_ACT_33226c8d-5b17-49e9-bbb5-b43ebf32c6f2_SESS_7653ac0f-d48f-4909-90a0-43f9d801d46b_BOSC_69a16244-a5a8-49a9-930a-c2caafaa4bbc_PLY_','2020-12-29 10:27:25','2020-12-29 11:16:08','010a89c8-1d6e-4abe-a1fa-4f0414c2f603.ply','2020-12-29 11:27:25','SYNCED','010a89c8-1d6e-4abe-a1fa-4f0414c2f603',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.52.1.1\",\"modelMatrix\":\"-0.996786,0.0780213,-0.0181612,0,-0.0801072,-0.970832,0.225983,0,9.88658e-10,0.226712,0.973962,0,-10.4233,14.5494,-22.0575,1\",\"title\":\"Mandibule PLY\"}'),(2,'010b5090-978c-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/010b5090-978c-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_c7a6f6ba-bf16-4193-bed4-711092e6844c_SESS_09f61616-e0f4-4e63-a2ec-573869a1da0e_TOSC_455dcafc-7dea-4dc3-a9de-0fce53e1e4ca_PLY_','2021-04-07 10:22:45','2021-04-07 12:22:43','010b5090-978c-11eb-9377-226cec7cb58a.ply','2021-04-07 12:22:45','SYNCED','010b5090-978c-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.3.13.1.1\",\"modelMatrix\":\"0.48449,0.749278,-0.451499,0,-0.874797,0.414974,-0.250054,0,1.32341e-8,0.516119,0.856517,0,2.36001,-44.8249,-9.31304,1\",\"title\":\"Maxillaire PLY\"}'),(2,'010eb3fc-978c-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/010eb3fc-978c-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_c7a6f6ba-bf16-4193-bed4-711092e6844c_SESS_09f61616-e0f4-4e63-a2ec-573869a1da0e_TOSC_455dcafc-7dea-4dc3-a9de-0fce53e1e4ca_SNAPS_','2021-04-07 10:07:43','2021-04-07 12:07:42','010eb3fc-978c-11eb-9377-226cec7cb58a.png','2021-04-07 12:07:43','SYNCED','010eb3fc-978c-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.3.13.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'01113cef-978c-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01113cef-978c-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_c7a6f6ba-bf16-4193-bed4-711092e6844c_SESS_09f61616-e0f4-4e63-a2ec-573869a1da0e_TOSC_42513984-15c4-4fe2-8fa6-bc16a1699f2a_PLY_','2021-04-07 10:19:53','2021-04-07 12:19:52','01113cef-978c-11eb-9377-226cec7cb58a.ply','2021-04-07 12:19:53','SYNCED','01113cef-978c-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.3.13.1.3\",\"modelMatrix\":\"0.0536139,0.90731,-0.417029,0,-0.998562,0.0487145,-0.0223908,0,-1.60128e-9,0.41763,0.908617,0,-17.3385,-35.0255,-13.0402,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0113bd30-7ce2-4aa9-9486-8614725aba21','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0113bd30-7ce2-4aa9-9486-8614725aba21.png','SNAPS','PATIENT_92b3f707-ae23-4f49-9654-96036c75ea6b_ACT_4963373a-2fca-48b1-b9af-45e15215cce0_SESS_3bdf0f77-b6e4-41bb-b3a3-f6a07896de62_BOSC_67e9058b-6b35-4e45-a903-119708e47fa9_SNAPS_','2020-12-15 10:05:27','2020-12-15 11:04:59','0113bd30-7ce2-4aa9-9486-8614725aba21.png','2020-12-15 11:05:27','SYNCED','0113bd30-7ce2-4aa9-9486-8614725aba21',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.35.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'01142418-978c-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01142418-978c-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_c7a6f6ba-bf16-4193-bed4-711092e6844c_SESS_09f61616-e0f4-4e63-a2ec-573869a1da0e_BOSC_be7992af-7764-4f1d-8629-bd01d1529bc5_SNAPS_','2021-04-07 10:04:46','2021-04-07 12:04:45','01142418-978c-11eb-9377-226cec7cb58a.png','2021-04-07 12:04:46','SYNCED','01142418-978c-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.13.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'01144904-fc8f-45f5-89ad-07fe1d3f6bb8','','ZIP','PATIENT_e94cc8a4-9fe0-4d90-8c07-d76eeaa42853_ACT_21ffe993-35ca-4b76-a4e3-1d47e64dae53_SESS_1a461b7d-da71-46dd-8fa2-c198bafd2f96_BOSC_3b2e26ef-0e15-4221-8c1a-91282c0b3ba0_ZIP_','2021-12-09 14:50:21','2021-12-09 15:50:19','','2021-12-09 15:50:21','SYNCED','01144904-fc8f-45f5-89ad-07fe1d3f6bb8',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.407.2.1.5\",\"modelMatrix\":\"-0.817777,-0.569324,0.0843264,0,0.575535,-0.808952,0.119819,0,-4.32234e-10,0.146518,0.989208,0,7.39922,31.8963,-20.1996,1\",\"title\":\"Mandibule ZIP\"}'),(2,'01150867-d311-4c25-9df3-61e52425ce8b','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01150867-d311-4c25-9df3-61e52425ce8b.png','SNAPS','PATIENT_ef8d3999-ba32-41ec-a94f-71185b37aab5_ACT_1d33193c-5e2e-4bb2-ac6a-3df2fa6be87f_SESS_3dceee06-b7f5-42ec-8014-95fac522bfcc_BOSC_e32b4d64-2748-4b14-9b29-b8b71b988ee7_SNAPS_','2021-02-26 15:25:25','2021-02-26 16:25:24','01150867-d311-4c25-9df3-61e52425ce8b.png','2021-02-26 16:25:25','SYNCED','01150867-d311-4c25-9df3-61e52425ce8b',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.1.1.1.6\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0116892a-1ea4-4b0d-b496-6937e5940ec6','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0116892a-1ea4-4b0d-b496-6937e5940ec6.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_d900c420-60b3-4a84-bfbd-d3d0e55ebe13_SESS_f0c3c51b-96a1-44cc-9426-1972a04546db_BOSC_5ce25e85-4b2f-4555-b230-d9b8cdfc7218_SNAPS_','2021-10-08 08:09:26','2021-10-08 10:09:22','0116892a-1ea4-4b0d-b496-6937e5940ec6.png','2021-10-08 10:09:26','SYNCED','0116892a-1ea4-4b0d-b496-6937e5940ec6',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.194.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'01172a32-978c-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01172a32-978c-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_c7a6f6ba-bf16-4193-bed4-711092e6844c_SESS_09f61616-e0f4-4e63-a2ec-573869a1da0e_TOSC_42513984-15c4-4fe2-8fa6-bc16a1699f2a_SNAPS_','2021-04-07 10:16:44','2021-04-07 12:16:42','01172a32-978c-11eb-9377-226cec7cb58a.png','2021-04-07 12:16:44','SYNCED','01172a32-978c-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.3.13.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'011a58ef-978c-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/011a58ef-978c-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_c7a6f6ba-bf16-4193-bed4-711092e6844c_SESS_09f61616-e0f4-4e63-a2ec-573869a1da0e_BOSC_192d466b-1fad-421a-9b0b-8cd1b84186ed_PLY_','2021-04-07 10:27:23','2021-04-07 12:27:20','011a58ef-978c-11eb-9377-226cec7cb58a.ply','2021-04-07 12:27:23','SYNCED','011a58ef-978c-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.13.1.4\",\"modelMatrix\":\"-0.995993,-0.0855918,0.025919,0,0.0894301,-0.953245,0.288663,0,-2.05607e-9,0.289824,0.95708,0,15.8708,9.69028,-18.4659,1\",\"title\":\"Mandibule PLY\"}'),(2,'011c1cf4-c86d-45a1-880b-d3f612380ddf','','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_fd0bdb2f-2db9-4f06-bf93-a57aa8ce8899_SESS_13ee09be-048a-4261-b4bc-5b538cb77095_TOSC_532d6103-c519-43b8-9191-56258bed0631_SNAPS_','2021-05-06 08:52:29','2021-05-06 10:49:54','','2021-05-06 10:52:29','SYNCED','011c1cf4-c86d-45a1-880b-d3f612380ddf',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.140.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'011da522-8663-11eb-9452-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/011da522-8663-11eb-9452-226cec7cb58a.ply','PLY','PATIENT_681a67f5-f447-48f3-97a7-090f50bc610d_ACT_1a62bc4b-f10a-4655-bcd5-3b77a01c0069_SESS_774a9d14-b0f7-415d-b441-dcdb30185bda_TOSC_aa57872d-a004-4ab2-83c1-025607e98d84_PLY_','2021-03-16 14:20:51','2021-03-16 14:59:33','011da522-8663-11eb-9452-226cec7cb58a.ply','2021-03-16 15:20:51','SYNCED','011da522-8663-11eb-9452-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.83.1.2\",\"modelMatrix\":\"0.797264,-0.548054,0.252995,0,0.603631,0.72386,-0.334151,0,4.28224e-9,0.419123,0.90793,0,7.54478,-31.8679,-16.435,1\",\"title\":\"Maxillaire PLY\"}'),(2,'011e2bf0-ba54-4df7-ad0a-1edcb026e5d5','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/011e2bf0-ba54-4df7-ad0a-1edcb026e5d5.zip','ZIP','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_835f7e4d-6a54-4e10-a33e-739e6cd229a8_SESS_945ba64a-8904-4998-958d-23ad1abc6f43_BOSC_b65526f5-a731-46e1-8935-58710ddeb3f3_ZIP_','2021-09-30 11:50:13','2021-09-30 13:50:11','011e2bf0-ba54-4df7-ad0a-1edcb026e5d5.zip','2021-09-30 13:50:13','SYNCED','8e0c5d2e-d720-4c7b-81a0-8617ad41b6b3',1,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.22.35.1.1\",\"modelMatrix\":\"0.99996,0.00854211,-0.00280021,0,-0.00898937,0.950207,-0.311489,0,2.64514e-10,0.311502,0.950245,0,-16.8109,17.9642,-20.0366,1\",\"title\":\"Mandibule ZIP\"}'),(2,'01203cbd-8663-11eb-9452-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01203cbd-8663-11eb-9452-226cec7cb58a.png','SNAPS','PATIENT_681a67f5-f447-48f3-97a7-090f50bc610d_ACT_1a62bc4b-f10a-4655-bcd5-3b77a01c0069_SESS_774a9d14-b0f7-415d-b441-dcdb30185bda_BOSC_f0d35a06-14c9-4793-9343-ff0478492375_SNAPS_','2021-03-16 14:20:51','2021-03-16 15:19:13','01203cbd-8663-11eb-9452-226cec7cb58a.png','2021-03-16 15:20:51','SYNCED','01203cbd-8663-11eb-9452-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.83.1.4\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'01232894-8663-11eb-9452-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01232894-8663-11eb-9452-226cec7cb58a.png','SNAPS','PATIENT_681a67f5-f447-48f3-97a7-090f50bc610d_ACT_1a62bc4b-f10a-4655-bcd5-3b77a01c0069_SESS_774a9d14-b0f7-415d-b441-dcdb30185bda_TOSC_42b28bc4-2bdd-4c65-a3d2-2e978beadf45_SNAPS_','2021-03-16 14:20:51','2021-03-16 15:02:16','01232894-8663-11eb-9452-226cec7cb58a.png','2021-03-16 15:20:51','SYNCED','01232894-8663-11eb-9452-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.83.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'012341f0-0616-4598-9e73-d37118bb8c9a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/012341f0-0616-4598-9e73-d37118bb8c9a.png','SNAPS','PATIENT_b53b7691-d0c6-4f1d-9b95-0414149845d6_ACT_5373a409-2eb0-4923-b385-13a82e0f1d31_SESS_b1cca53f-2b0f-4029-a605-2ab2a26d58fb_TOSC_4738d7a1-4ec8-4feb-9c09-4cc47c7c4840_SNAPS_','2021-03-19 12:57:47','2021-03-19 13:42:09','012341f0-0616-4598-9e73-d37118bb8c9a.png','2021-03-19 13:57:47','SYNCED','012341f0-0616-4598-9e73-d37118bb8c9a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.100.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0125962e-8663-11eb-9452-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0125962e-8663-11eb-9452-226cec7cb58a.ply','PLY','PATIENT_681a67f5-f447-48f3-97a7-090f50bc610d_ACT_1a62bc4b-f10a-4655-bcd5-3b77a01c0069_SESS_774a9d14-b0f7-415d-b441-dcdb30185bda_TOSC_b4db5fea-af9c-46e2-a23d-5ace85e4c05b_PLY_','2021-03-16 14:20:52','2021-03-16 14:45:45','0125962e-8663-11eb-9452-226cec7cb58a.ply','2021-03-16 15:20:52','SYNCED','0125962e-8663-11eb-9452-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.83.1.1\",\"modelMatrix\":\"0.606628,-0.7321,0.309889,0,0.794986,0.558642,-0.236467,0,-7.18119e-9,0.389805,0.920897,0,-1.27248,-34.9464,-19.8731,1\",\"title\":\"Maxillaire PLY\"}'),(2,'012852cd-8663-11eb-9452-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/012852cd-8663-11eb-9452-226cec7cb58a.ply','PLY','PATIENT_681a67f5-f447-48f3-97a7-090f50bc610d_ACT_1a62bc4b-f10a-4655-bcd5-3b77a01c0069_SESS_774a9d14-b0f7-415d-b441-dcdb30185bda_BOSC_4416480e-b972-493b-a38a-a74218b1fef2_PLY_','2021-03-16 14:20:52','2021-03-16 15:16:53','012852cd-8663-11eb-9452-226cec7cb58a.ply','2021-03-16 15:20:52','SYNCED','012852cd-8663-11eb-9452-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.83.1.3\",\"modelMatrix\":\"0.868083,-0.484923,0.106213,0,0.496419,0.847981,-0.185734,0,2.93076e-9,0.213958,0.976843,0,2.75479,-22.7369,-21.0217,1\",\"title\":\"Mandibule PLY\"}'),(2,'012aa3cc-8663-11eb-9452-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/012aa3cc-8663-11eb-9452-226cec7cb58a.png','SNAPS','PATIENT_681a67f5-f447-48f3-97a7-090f50bc610d_ACT_1a62bc4b-f10a-4655-bcd5-3b77a01c0069_SESS_774a9d14-b0f7-415d-b441-dcdb30185bda_TOSC_aa57872d-a004-4ab2-83c1-025607e98d84_SNAPS_','2021-03-16 14:20:51','2021-03-16 14:59:33','012aa3cc-8663-11eb-9452-226cec7cb58a.png','2021-03-16 15:20:51','SYNCED','012aa3cc-8663-11eb-9452-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.83.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'012d249c-8663-11eb-9452-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/012d249c-8663-11eb-9452-226cec7cb58a.ply','PLY','PATIENT_681a67f5-f447-48f3-97a7-090f50bc610d_ACT_1a62bc4b-f10a-4655-bcd5-3b77a01c0069_SESS_774a9d14-b0f7-415d-b441-dcdb30185bda_BOSC_f0d35a06-14c9-4793-9343-ff0478492375_PLY_','2021-03-16 14:20:50','2021-03-16 15:19:13','012d249c-8663-11eb-9452-226cec7cb58a.ply','2021-03-16 15:20:50','SYNCED','012d249c-8663-11eb-9452-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.83.1.4\",\"modelMatrix\":\"-0.979924,-0.173571,0.0980941,0,0.199373,-0.853109,0.482136,0,2.86074e-9,0.492014,0.870587,0,-28.587,4.35263,-16.2124,1\",\"title\":\"Mandibule PLY\"}'),(2,'012fe851-8663-11eb-9452-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/012fe851-8663-11eb-9452-226cec7cb58a.ply','PLY','PATIENT_681a67f5-f447-48f3-97a7-090f50bc610d_ACT_1a62bc4b-f10a-4655-bcd5-3b77a01c0069_SESS_774a9d14-b0f7-415d-b441-dcdb30185bda_TOSC_42b28bc4-2bdd-4c65-a3d2-2e978beadf45_PLY_','2021-03-16 14:20:51','2021-03-16 15:02:16','012fe851-8663-11eb-9452-226cec7cb58a.ply','2021-03-16 15:20:51','SYNCED','012fe851-8663-11eb-9452-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.83.1.3\",\"modelMatrix\":\"0.347594,-0.904091,0.248593,0,0.937645,0.335155,-0.0921559,0,-5.67644e-9,0.265125,0.964214,0,-10.1871,-34.6105,-11.9031,1\",\"title\":\"Maxillaire PLY\"}'),(2,'01302c29-b853-4d5f-b1a5-c9bbc9191c08','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01302c29-b853-4d5f-b1a5-c9bbc9191c08.ply','PLY','PATIENT_c70835e4-d6c1-41ca-a478-23eb5a4ecb56_ACT_6c371eee-bf6e-43fe-8c73-87ac3ea899ae_SESS_e5a6d824-9316-4b39-8f1d-972bee03fb74_TOSC_5b46d891-ecf0-4edb-9086-b2050ccc08f4_PLY_','2020-12-08 10:47:06','2020-06-26 16:01:12','01302c29-b853-4d5f-b1a5-c9bbc9191c08.ply','2020-12-08 11:47:06','SYNCED','01302c29-b853-4d5f-b1a5-c9bbc9191c08',0,NULL,'','','{\"displayTitle\":\"Maxillaire 88.2.4.1.1\",\"modelMatrix\":\"0.695222,-0.700239,0.162273,0,0.718795,0.677274,-0.156951,0,7.87798e-10,0.225757,0.974184,0,4.20353,-31.7505,-13.2145,1\",\"title\":\"Maxillaire PLY\"}'),(2,'013285e3-8663-11eb-9452-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/013285e3-8663-11eb-9452-226cec7cb58a.ply','PLY','PATIENT_681a67f5-f447-48f3-97a7-090f50bc610d_ACT_1a62bc4b-f10a-4655-bcd5-3b77a01c0069_SESS_774a9d14-b0f7-415d-b441-dcdb30185bda_BOSC_db689cf0-551e-4172-a57c-c0e344c5da2c_PLY_','2021-03-16 14:20:52','2021-03-16 15:20:49','013285e3-8663-11eb-9452-226cec7cb58a.ply','2021-03-16 15:20:52','SYNCED','013285e3-8663-11eb-9452-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.83.1.2\",\"modelMatrix\":\"-0.993511,-0.11174,0.0212022,0,0.113733,-0.976095,0.185211,0,2.73765e-10,0.18642,0.98247,0,-11.9297,11.9102,-23.127,1\",\"title\":\"Mandibule PLY\"}'),(2,'01378fa2-8663-11eb-9452-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01378fa2-8663-11eb-9452-226cec7cb58a.png','SNAPS','PATIENT_681a67f5-f447-48f3-97a7-090f50bc610d_ACT_1a62bc4b-f10a-4655-bcd5-3b77a01c0069_SESS_774a9d14-b0f7-415d-b441-dcdb30185bda_BOSC_4416480e-b972-493b-a38a-a74218b1fef2_SNAPS_','2021-03-16 14:20:52','2021-03-16 15:16:53','01378fa2-8663-11eb-9452-226cec7cb58a.png','2021-03-16 15:20:52','SYNCED','01378fa2-8663-11eb-9452-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.83.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'01393ced-348d-492b-aa5e-945d51eeeb72','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01393ced-348d-492b-aa5e-945d51eeeb72.zip','ZIP','PATIENT_1829dacc-d5a9-49fd-b839-bbafdac5d6d5_ACT_67ab9710-81c8-4504-bef5-f4622da2f42e_SESS_8ce2ba43-bdcd-4a3b-8850-1b6b9aa5dec8_BOSC_3c330ef6-7b40-4d8d-9b87-66ff357a58f3_ZIP_','2021-09-29 14:11:52','2021-09-29 16:11:44','01393ced-348d-492b-aa5e-945d51eeeb72.zip','2021-09-29 16:11:52','SYNCED','01393ced-348d-492b-aa5e-945d51eeeb72',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.403.1.1.3\",\"modelMatrix\":\"-0.957351,-0.276185,0.0848598,0,0.288928,-0.915128,0.281179,0,-5.00959e-9,0.293706,0.955896,0,-18.5657,9.93289,-20.1405,1\",\"title\":\"Mandibule ZIP\"}'),(2,'013a470e-8663-11eb-9452-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/013a470e-8663-11eb-9452-226cec7cb58a.png','SNAPS','PATIENT_681a67f5-f447-48f3-97a7-090f50bc610d_ACT_1a62bc4b-f10a-4655-bcd5-3b77a01c0069_SESS_774a9d14-b0f7-415d-b441-dcdb30185bda_TOSC_b4db5fea-af9c-46e2-a23d-5ace85e4c05b_SNAPS_','2021-03-16 14:20:51','2021-03-16 14:45:45','013a470e-8663-11eb-9452-226cec7cb58a.png','2021-03-16 15:20:51','SYNCED','013a470e-8663-11eb-9452-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.83.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'013d9c8a-8663-11eb-9452-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/013d9c8a-8663-11eb-9452-226cec7cb58a.png','SNAPS','PATIENT_681a67f5-f447-48f3-97a7-090f50bc610d_ACT_1a62bc4b-f10a-4655-bcd5-3b77a01c0069_SESS_774a9d14-b0f7-415d-b441-dcdb30185bda_BOSC_db689cf0-551e-4172-a57c-c0e344c5da2c_SNAPS_','2021-03-16 14:20:51','2021-03-16 15:20:49','013d9c8a-8663-11eb-9452-226cec7cb58a.png','2021-03-16 15:20:51','SYNCED','013d9c8a-8663-11eb-9452-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.83.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'01419ad5-a3bb-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01419ad5-a3bb-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_79406c13-00e4-4a57-b938-5ac4cd1a9f2f_ACT_dbfeadf7-7793-42fb-be76-63e1515647d5_SESS_e53f2bc1-2f26-4656-aae6-7e1b2bbb1f50_TOSC_24085d39-bee0-4389-b5b7-8eea2c1764e2_PLY_','2022-03-04 13:40:19','2019-07-11 12:41:28','01419ad5-a3bb-11e9-a33b-226cec7cb58a.ply','2022-03-04 14:40:19','SYNCED','01419ad5-a3bb-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 40.1.1.1\",\"modelMatrix\":\"0.852576,-0.486267,0.191461,0,0.522603,0.793299,-0.312351,0,-1.89462e-9,0.366361,0.930473,0,5.3154,-32.6559,-18.1157,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'01422984-a3bb-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01422984-a3bb-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_79406c13-00e4-4a57-b938-5ac4cd1a9f2f_ACT_dbfeadf7-7793-42fb-be76-63e1515647d5_SESS_e53f2bc1-2f26-4656-aae6-7e1b2bbb1f50_TOSC_24085d39-bee0-4389-b5b7-8eea2c1764e2_STL_','2022-03-04 13:40:19','2019-07-11 12:41:28','01422984-a3bb-11e9-a33b-226cec7cb58a.stl','2022-03-04 14:40:19','SYNCED','01422984-a3bb-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 40.1.1.1\",\"modelMatrix\":\"0.852576,-0.486267,0.191461,0,0.522603,0.793299,-0.312351,0,-1.89462e-9,0.366361,0.930473,0,5.3154,-32.6559,-18.1157,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'014284fe-1b1b-4fbf-82ac-d4ec75315ef9','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/014284fe-1b1b-4fbf-82ac-d4ec75315ef9.ply','PLY','PATIENT_924bf1a2-20af-4047-90c0-8d8b8a5fceb6_ACT_d32cbe7d-f29f-48b8-8656-3065d72e68bb_SESS_f6828a70-e523-4c66-97ef-ce1749bd1c5a_TOSC_e2bae541-1651-4b4d-8f92-c46b87c5a5e2_PLY_','2021-01-06 11:01:43','2019-12-12 14:49:32','014284fe-1b1b-4fbf-82ac-d4ec75315ef9.ply','2021-01-06 12:01:43','SYNCED','014284fe-1b1b-4fbf-82ac-d4ec75315ef9',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 232.15.1.1\",\"modelMatrix\":\"0.430033,-0.826966,0.362213,0,0.902813,0.393905,-0.172532,0,-7.69649e-9,0.401205,0.915988,0,3.46065,-33.3907,-24.753,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0142b109-a3bb-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0142b109-a3bb-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_79406c13-00e4-4a57-b938-5ac4cd1a9f2f_ACT_dbfeadf7-7793-42fb-be76-63e1515647d5_SESS_e53f2bc1-2f26-4656-aae6-7e1b2bbb1f50_BOSC_0a7999fe-aef8-4205-b3b5-74d2746c93bf_STL_','2022-03-04 13:40:20','2019-07-11 12:46:11','0142b109-a3bb-11e9-a33b-226cec7cb58a.stl','2022-03-04 14:40:20','SYNCED','0142b109-a3bb-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 40.1.1.1\",\"modelMatrix\":\"-0.998063,-0.0615553,0.00903301,0,0.0622145,-0.987487,0.14491,0,-1.34323e-10,0.145191,0.989404,0,-18.6543,17.3715,-22.9564,1\",\"title\":\"MANDIBULE STL\"}'),(2,'01436f08-a3bb-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01436f08-a3bb-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_79406c13-00e4-4a57-b938-5ac4cd1a9f2f_ACT_dbfeadf7-7793-42fb-be76-63e1515647d5_SESS_e53f2bc1-2f26-4656-aae6-7e1b2bbb1f50_BOSC_0a7999fe-aef8-4205-b3b5-74d2746c93bf_PLY_','2022-03-04 13:40:20','2019-07-11 12:46:11','01436f08-a3bb-11e9-a33b-226cec7cb58a.ply','2022-03-04 14:40:20','SYNCED','01436f08-a3bb-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 40.1.1.1\",\"modelMatrix\":\"-0.998063,-0.0615553,0.00903301,0,0.0622145,-0.987487,0.14491,0,-1.34323e-10,0.145191,0.989404,0,-18.6543,17.3715,-22.9564,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0143eb07-a3bb-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0143eb07-a3bb-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_79406c13-00e4-4a57-b938-5ac4cd1a9f2f_ACT_dbfeadf7-7793-42fb-be76-63e1515647d5_SESS_e53f2bc1-2f26-4656-aae6-7e1b2bbb1f50_TOSC_24085d39-bee0-4389-b5b7-8eea2c1764e2_SNAPS_','2022-03-04 13:40:20','2019-07-11 12:41:28','0143eb07-a3bb-11e9-a33b-226cec7cb58a.png','2022-03-04 14:40:20','SYNCED','0143eb07-a3bb-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 40.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'01446165-a3bb-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01446165-a3bb-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_79406c13-00e4-4a57-b938-5ac4cd1a9f2f_ACT_dbfeadf7-7793-42fb-be76-63e1515647d5_SESS_e53f2bc1-2f26-4656-aae6-7e1b2bbb1f50_BOSC_0a7999fe-aef8-4205-b3b5-74d2746c93bf_SNAPS_','2022-03-04 13:40:20','2019-07-11 12:46:11','01446165-a3bb-11e9-a33b-226cec7cb58a.png','2022-03-04 14:40:20','SYNCED','01446165-a3bb-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 40.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0145cac6-37fe-41cc-89ac-96a274604409','','PLY','PATIENT_ff8b75bc-a347-4fee-9d19-a4c1ecf5e68a_ACT_b51396b7-92a0-4113-9eaf-c5df430440d2_SESS_581a99e4-5e12-414c-9d5a-f8fb9a920369_TOSC_b6de0019-1e3f-4448-9675-349eba3512a6_PLY_','2021-04-06 07:51:12','2021-04-06 09:51:05','','2021-04-06 09:51:12','SYNCED','0145cac6-37fe-41cc-89ac-96a274604409',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.320.1.1.2\",\"modelMatrix\":\"0.902041,-0.356729,0.243037,0,0.431651,0.745473,-0.507885,0,1.70857e-8,0.56304,0.82643,0,15.8157,-31.9223,-22.776,1\",\"title\":\"Maxillaire PLY\"}'),(2,'014c3055-9c2a-4c0c-aaea-96419fc70d57','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/014c3055-9c2a-4c0c-aaea-96419fc70d57.png','SNAPS','PATIENT_70311767-96f2-478b-b301-288b4fcffd6d_ACT_ef042218-af83-44b7-ae52-dbbba702b880_SESS_5a85653f-f035-44d0-99d5-440eb0b744f9_TOSC_75aeceaa-d62c-4628-95e9-d39b65466104_SNAPS_','2021-01-19 13:09:00','2021-01-19 13:59:47','014c3055-9c2a-4c0c-aaea-96419fc70d57.png','2021-01-19 14:09:00','SYNCED','014c3055-9c2a-4c0c-aaea-96419fc70d57',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.13.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'014fb16a-bb80-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/014fb16a-bb80-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_0cc4ef86-2202-4a20-b6c2-a4a99611d672_ACT_6dbe0125-35d1-43be-a391-4c002f0a608b_SESS_6da4a058-e436-4f39-8590-980b0a6c1507_BOSC_13443d0f-6309-4191-9274-7a1fb40fa266_SNAPS_','2020-12-08 10:47:08','2020-07-01 11:45:17','014fb16a-bb80-11ea-947d-226cec7cb58a.png','2020-12-08 11:47:08','SYNCED','014fb16a-bb80-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 88.2.16.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0151aa3d-bb80-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0151aa3d-bb80-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_0cc4ef86-2202-4a20-b6c2-a4a99611d672_ACT_6dbe0125-35d1-43be-a391-4c002f0a608b_SESS_6da4a058-e436-4f39-8590-980b0a6c1507_BOSC_13443d0f-6309-4191-9274-7a1fb40fa266_PLY_','2020-12-08 10:47:08','2020-07-01 11:45:17','0151aa3d-bb80-11ea-947d-226cec7cb58a.ply','2020-12-08 11:47:08','SYNCED','0151aa3d-bb80-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 88.2.16.1.2\",\"modelMatrix\":\"-0.996011,-0.0838118,0.0306109,0,0.0892269,-0.935564,0.3417,0,7.1054e-10,0.343068,0.93931,0,-18.4921,10.4375,-19.0431,1\",\"title\":\"Mandibule PLY\"}'),(2,'0155496e-832b-4abc-9f16-71361f6b1ceb','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0155496e-832b-4abc-9f16-71361f6b1ceb.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_f470dafa-c083-4592-a53e-8777d59036b8_SESS_6bd449f9-60f6-432a-9a96-152827e027fc_BOSC_bb17653a-7b2a-44d9-99a4-a12bc92d1642_SNAPS_','2021-04-29 07:35:49','2021-04-29 09:35:48','0155496e-832b-4abc-9f16-71361f6b1ceb.png','2021-04-29 09:35:49','SYNCED','0155496e-832b-4abc-9f16-71361f6b1ceb',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.125.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'01562426-a85d-4668-a64e-b9e33ca1d42b','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01562426-a85d-4668-a64e-b9e33ca1d42b.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_9ac41709-266d-46c7-a5d6-c38801e11232_SESS_d5fff860-73d3-4cdc-9e34-2bd0e66bbd7c_BOSC_eceb447b-bf3e-4aa0-83cb-5e3c1ace204f_PLY_','2020-12-08 10:47:08','2020-06-05 10:13:07','01562426-a85d-4668-a64e-b9e33ca1d42b.ply','2020-12-08 11:47:08','SYNCED','01562426-a85d-4668-a64e-b9e33ca1d42b',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.20.1.1\",\"modelMatrix\":\"-0.981676,-0.18988,0.0160604,0,0.190558,-0.978183,0.0827362,0,-8.06272e-10,0.0842806,0.996442,0,-12.1911,10.9783,-21.3539,1\",\"title\":\"Mandibule PLY\"}'),(2,'015e6ef6-0c48-4bc3-9405-88ca2aa1305c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/015e6ef6-0c48-4bc3-9405-88ca2aa1305c.png','SNAPS','PATIENT_b03ac277-fc15-4e16-b5aa-c61591d4bcee_ACT_b57bb6cd-4742-4546-b915-f857d8f016fb_SESS_bda42e66-c504-4c31-8601-ce98935731ff_BOSC_ff6f191b-2484-4bfb-b333-e9724313c7ba_SNAPS_','2021-09-29 14:43:39','2021-09-29 16:43:32','015e6ef6-0c48-4bc3-9405-88ca2aa1305c.png','2021-09-29 16:43:39','SYNCED','015e6ef6-0c48-4bc3-9405-88ca2aa1305c',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.162.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'016077a5-a897-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/016077a5-a897-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_3397764f-98bb-416e-97fc-bdb90c785356_ACT_de792429-7cc9-4684-8574-cc42108e6cdc_SESS_72e329ac-390b-427a-9384-d6296c240328_BOSC_4a3bd60c-26c1-4c98-9437-2a88544e3b0c_PLY_','2021-12-07 08:38:05','2019-07-17 17:36:34','016077a5-a897-11e9-a33b-226cec7cb58a.ply','2021-12-07 09:38:05','SYNCED','016077a5-a897-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 96.1.1.1\",\"modelMatrix\":\"-0.960118,-0.275272,0.0489776,0,0.279596,-0.945272,0.168187,0,1.14725e-9,0.175173,0.984538,0,-23.2468,15.9017,-28.9485,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'016115d5-a897-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/016115d5-a897-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_3397764f-98bb-416e-97fc-bdb90c785356_ACT_de792429-7cc9-4684-8574-cc42108e6cdc_SESS_72e329ac-390b-427a-9384-d6296c240328_BOSC_4a3bd60c-26c1-4c98-9437-2a88544e3b0c_SNAPS_','2021-12-07 08:38:06','2019-07-17 17:36:34','016115d5-a897-11e9-a33b-226cec7cb58a.png','2021-12-07 09:38:06','SYNCED','016115d5-a897-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 96.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'01618b44-c1fc-4501-b531-f1f113613211','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01618b44-c1fc-4501-b531-f1f113613211.png','SNAPS','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_2a2b96a4-a0e0-43e8-880c-4a576a26100c_SESS_28b7bd97-0dfa-43d9-b4aa-09587119b68a_BOSC_3f08005c-4379-4946-87cd-15f582d0ca08_SNAPS_','2020-12-23 09:07:04','2019-12-20 15:00:36','01618b44-c1fc-4501-b531-f1f113613211.png','2020-12-23 10:07:04','SYNCED','01618b44-c1fc-4501-b531-f1f113613211',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0161b62b-a897-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0161b62b-a897-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_3397764f-98bb-416e-97fc-bdb90c785356_ACT_de792429-7cc9-4684-8574-cc42108e6cdc_SESS_72e329ac-390b-427a-9384-d6296c240328_TOSC_67399eca-d324-41ca-93d7-653a6817b1e3_SNAPS_','2021-12-07 08:38:08','2019-07-17 17:30:12','0161b62b-a897-11e9-a33b-226cec7cb58a.png','2021-12-07 09:38:08','SYNCED','0161b62b-a897-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 96.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'01624971-a897-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01624971-a897-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_3397764f-98bb-416e-97fc-bdb90c785356_ACT_de792429-7cc9-4684-8574-cc42108e6cdc_SESS_72e329ac-390b-427a-9384-d6296c240328_TOSC_67399eca-d324-41ca-93d7-653a6817b1e3_PLY_','2021-12-07 08:38:09','2019-07-17 17:30:12','01624971-a897-11e9-a33b-226cec7cb58a.ply','2021-12-07 09:38:09','SYNCED','01624971-a897-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 96.1.1.1\",\"modelMatrix\":\"0.508608,-0.834618,0.211498,0,0.860998,0.493024,-0.124936,0,-1.21187e-9,0.245643,0.96936,0,0.947789,-33.9751,-13.4366,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0162ee1a-a897-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0162ee1a-a897-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_3397764f-98bb-416e-97fc-bdb90c785356_ACT_de792429-7cc9-4684-8574-cc42108e6cdc_SESS_72e329ac-390b-427a-9384-d6296c240328_TOSC_67399eca-d324-41ca-93d7-653a6817b1e3_STL_','2021-12-07 08:38:09','2019-07-17 17:30:12','0162ee1a-a897-11e9-a33b-226cec7cb58a.stl','2021-12-07 09:38:09','SYNCED','0162ee1a-a897-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 96.1.1.1\",\"modelMatrix\":\"0.508608,-0.834618,0.211498,0,0.860998,0.493024,-0.124936,0,-1.21187e-9,0.245643,0.96936,0,0.947789,-33.9751,-13.4366,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'016375bb-a897-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/016375bb-a897-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_3397764f-98bb-416e-97fc-bdb90c785356_ACT_de792429-7cc9-4684-8574-cc42108e6cdc_SESS_72e329ac-390b-427a-9384-d6296c240328_BOSC_4a3bd60c-26c1-4c98-9437-2a88544e3b0c_STL_','2021-12-07 08:38:09','2019-07-17 17:36:34','016375bb-a897-11e9-a33b-226cec7cb58a.stl','2021-12-07 09:38:09','SYNCED','016375bb-a897-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 96.1.1.1\",\"modelMatrix\":\"-0.960118,-0.275272,0.0489776,0,0.279596,-0.945272,0.168187,0,1.14725e-9,0.175173,0.984538,0,-23.2468,15.9017,-28.9485,1\",\"title\":\"MANDIBULE STL\"}'),(2,'01648f6a-9504-415f-803d-f83bc9e231a1','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01648f6a-9504-415f-803d-f83bc9e231a1.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_80b318af-d67d-44d1-b260-7d411c065f0f_SESS_4b58d2d7-b749-4b44-a9a5-6caa8efd1fab_BOSC_20a35dae-6d67-40c4-9fc8-3228111a1870_ZIP_','2022-03-23 14:44:08','2022-03-23 15:44:06','01648f6a-9504-415f-803d-f83bc9e231a1.zip','2022-03-23 15:44:08','SYNCED','01648f6a-9504-415f-803d-f83bc9e231a1',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.37.1.3\",\"modelMatrix\":\"-0.917201,-0.379042,0.122755,0,0.398424,-0.872583,0.282592,0,8.93388e-09,0.308102,0.951353,0,-27.3001,6.89806,-22.4251,1\",\"title\":\"Mandibule ZIP\"}'),(2,'016eaedc-245d-40b8-a603-c91b408e4c4a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/016eaedc-245d-40b8-a603-c91b408e4c4a.zip','ZIP','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_12ac9ce7-33ab-45e2-82e5-2a5dada45468_SESS_f22f6974-2b02-43d4-bb0a-9461e9307f27_BOSC_66651d1c-6fcc-4c35-8059-c94f339d3d51_ZIP_','2021-10-18 14:34:49','2021-10-18 16:34:46','016eaedc-245d-40b8-a603-c91b408e4c4a.zip','2021-10-18 16:34:49','SYNCED','016eaedc-245d-40b8-a603-c91b408e4c4a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.203.1.1\",\"modelMatrix\":\"-0.657479,-0.739426,0.14481,0,0.753472,-0.645222,0.126361,0,7.17413e-9,0.19219,0.981358,0,-16.5235,-8.8918,-26.9218,1\",\"title\":\"Mandibule ZIP\"}'),(2,'01704f46-bc9e-48bb-b351-c1a5bdd3a82e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01704f46-bc9e-48bb-b351-c1a5bdd3a82e.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_fe014672-eebb-47d5-bc89-50bca95c000a_SESS_7bc9cf66-766f-4646-b3f9-a0d7d8971652_TOSC_5bbf71a3-d663-4d65-92e3-05a78199892c_SNAPS_','2021-05-06 09:32:58','2021-05-06 11:32:57','01704f46-bc9e-48bb-b351-c1a5bdd3a82e.png','2021-05-06 11:32:58','SYNCED','01704f46-bc9e-48bb-b351-c1a5bdd3a82e',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.141.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'017c1f28-ea77-4cc3-a054-b334d970041e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/017c1f28-ea77-4cc3-a054-b334d970041e.png','SNAPS','PATIENT_9dd40e28-840f-4ed2-88cc-481cb0a074ed_ACT_bfee7a61-da12-41b2-9cb6-13dd70bd0dd0_SESS_1fff64f8-b90d-4877-bfda-e7aecb08cedd_BOSC_3db0fb65-dc51-4cc1-97a0-d4718823b721_SNAPS_','2020-12-30 09:52:04','2020-12-30 10:45:10','017c1f28-ea77-4cc3-a054-b334d970041e.png','2020-12-30 10:52:04','SYNCED','017c1f28-ea77-4cc3-a054-b334d970041e',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.58.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'017f773a-81fa-425c-b101-4e51407f100c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/017f773a-81fa-425c-b101-4e51407f100c.png','SNAPS','PATIENT_1cd14489-1dd6-462a-b246-8cb9f44e2c2e_ACT_39768527-49df-4f1f-9c8d-e1d614508e81_SESS_9fba44e9-d238-431a-95ae-368483f5f8a1_TOSC_80c86987-8a65-45fa-b31e-4569115022a7_SNAPS_','2020-12-29 12:49:31','2020-12-29 13:40:32','017f773a-81fa-425c-b101-4e51407f100c.png','2020-12-29 13:49:31','SYNCED','017f773a-81fa-425c-b101-4e51407f100c',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.36.55.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'01809b0c-12b1-4570-ae7b-1fd91c4bd4a7','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01809b0c-12b1-4570-ae7b-1fd91c4bd4a7.ply','PLY','PATIENT_d092ea90-a92a-44ef-ab64-86b00ed2679d_ACT_0b3dc7d8-a1d6-472a-9a63-2fff5248f3ca_SESS_25fdbbaf-7212-464e-80d5-3b9c2e167114_BOSC_a07657f5-9587-42e7-9c4f-78b225655636_PLY_','2021-03-19 11:19:02','2021-03-19 12:13:49','01809b0c-12b1-4570-ae7b-1fd91c4bd4a7.ply','2021-03-19 12:19:02','SYNCED','01809b0c-12b1-4570-ae7b-1fd91c4bd4a7',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.99.1.2\",\"modelMatrix\":\"-0.220797,-0.969355,0.107703,0,0.97532,-0.219446,0.0243822,0,-1.60492e-10,0.110428,0.993884,0,-16.8672,-11.6916,-23.3953,1\",\"title\":\"Mandibule PLY\"}'),(2,'0185abba-25af-4bd2-8937-b1b0a965ff92','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0185abba-25af-4bd2-8937-b1b0a965ff92.stl','STL','PATIENT_fb6c4a59-c72c-46ad-a554-ed6056e6aa8f_ACT_a993018f-4e2c-4c41-9e18-5b2cd8a5a5ad_SESS_5f263ed3-a107-4539-bca7-bbee330b804d_TOSC_342bc4aa-a803-43f4-abaf-5ad83033bd39_STL_','2021-12-07 08:38:09','2019-07-24 15:05:25','0185abba-25af-4bd2-8937-b1b0a965ff92.stl','2021-12-07 09:38:09','SYNCED','0185abba-25af-4bd2-8937-b1b0a965ff92',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 113.1.1.1\",\"modelMatrix\":\"0.357983,-0.903725,0.234795,0,0.933728,0.34648,-0.0900185,0,-4.06751e-10,0.25146,0.967868,0,-9.76076,-32.0819,-16.3726,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'0186d571-c9f0-4355-815f-b5a468076ff5','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0186d571-c9f0-4355-815f-b5a468076ff5.ply','PLY','PATIENT_37f3a9ff-0dee-4382-a85f-6b3681a26f31_ACT_81f97418-3b4c-4601-9a31-b81a0c70776e_SESS_4002654c-e62d-4a6c-835f-34b7c5bc98b1_BOSC_68eb9ff8-77c6-40ad-90b0-3d254aad9cb8_PLY_','2020-12-02 10:31:39','2020-11-10 09:35:36','0186d571-c9f0-4355-815f-b5a468076ff5.ply','2020-12-02 11:31:39','SYNCED','0186d571-c9f0-4355-815f-b5a468076ff5',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.12.1.1\",\"modelMatrix\":\"-0.988272,0.148228,-0.0367138,0,-0.152707,-0.959284,0.237601,0,-4.44533e-9,0.24042,0.970669,0,-16.6591,21.854,-18.901,1\",\"title\":\"Mandibule PLY\"}'),(2,'0187f6b7-178f-416b-b8cf-edafed4c1029','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0187f6b7-178f-416b-b8cf-edafed4c1029.ply','PLY','PATIENT_e3fa8bf8-1cee-48c7-a3f5-07478493ec6a_ACT_614c2222-ba8b-4c16-81a7-97d232a666ef_SESS_bec5fcc6-4d9e-4ee7-9f3a-c5f17e1ec08d_TOSC_6455871b-9d0c-4146-991a-7ad17e6ac598_PLY_','2021-02-12 14:10:49','2021-02-12 14:59:26','0187f6b7-178f-416b-b8cf-edafed4c1029.ply','2021-02-12 15:10:49','SYNCED','0187f6b7-178f-416b-b8cf-edafed4c1029',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.40.1.1\",\"modelMatrix\":\"0.700073,-0.653336,0.288183,0,0.714071,0.640529,-0.282534,0,-1.29649e-8,0.403578,0.914945,0,6.75144,-36.8472,-18.4661,1\",\"title\":\"Maxillaire PLY\"}'),(2,'018925f8-393c-422d-93eb-c2dab79c4aa1','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/018925f8-393c-422d-93eb-c2dab79c4aa1.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_69cc74d6-d976-48e9-8eec-693ff64095cf_SESS_448f3142-44dc-4a92-a676-47ac91eb67c2_TOSC_afaf0b37-9e06-4145-9144-05f4aee82d07_SNAPS_','2022-01-05 09:57:03','2022-01-05 10:56:58','018925f8-393c-422d-93eb-c2dab79c4aa1.png','2022-01-05 10:57:03','SYNCED','018925f8-393c-422d-93eb-c2dab79c4aa1',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.2.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0189bcf0-6c42-4403-9bf7-68b00b3aa4f1','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0189bcf0-6c42-4403-9bf7-68b00b3aa4f1.png','SNAPS','PATIENT_c3201c9f-df8d-44d0-a0cc-15b8ae863ba7_ACT_d15f22a0-322b-4b71-b93c-4243b9a6de4e_SESS_446de0f6-3624-4658-9045-47ff34c3aa44_TOSC_b7df3346-26cd-4e54-92b0-0ef8d5982ef3_SNAPS_','2021-03-24 15:35:13','2021-03-24 15:51:32','0189bcf0-6c42-4403-9bf7-68b00b3aa4f1.png','2021-03-24 16:35:13','SYNCED','0189bcf0-6c42-4403-9bf7-68b00b3aa4f1',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.117.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0189d750-88f4-4976-9a2f-f317e6e7fec2','','ZIP','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_13f3a131-93f7-443d-ae8e-7b012eb31332_SESS_bb85405e-aa07-4734-bb15-899c9f42c17b_TOSC_5499c5c5-c413-4a7f-86c4-3a0786a292d8_ZIP_','2021-11-04 08:46:43','2021-11-04 09:46:35','','2021-11-04 09:46:43','SYNCED','0189d750-88f4-4976-9a2f-f317e6e7fec2',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.207.1.1\",\"modelMatrix\":\"0.711334,-0.647533,0.273322,0,0.702854,0.655345,-0.27662,0,-1.68047e-9,0.388875,0.921291,0,8.10458,-38.0257,-13.9397,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'018a8b10-e63e-4c51-af48-2ff72556a8d9','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/018a8b10-e63e-4c51-af48-2ff72556a8d9.png','SNAPS','PATIENT_5c80bb82-cd1d-4202-9fc6-c13526366fc8_ACT_6066594a-d06a-4b97-bae9-ebdb32112fe7_SESS_e204bb8f-c910-4b70-bfcf-eae6b8d95982_BOSC_76ab1d35-56b1-47da-a6ec-cb7a11ada6ab_SNAPS_','2021-04-02 10:16:41','2021-04-02 12:16:07','018a8b10-e63e-4c51-af48-2ff72556a8d9.png','2021-04-02 12:16:41','SYNCED','018a8b10-e63e-4c51-af48-2ff72556a8d9',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.27.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0196d2a5-bb55-4489-959e-17a336782716','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0196d2a5-bb55-4489-959e-17a336782716.png','SNAPS','PATIENT_c7b0d417-236c-47d8-a68a-c50573406e7f_ACT_6fbd34aa-198e-41fc-bd31-6d32e9cb2a63_SESS_45d9fc14-280f-4061-b402-5fb09f88b9a6_TOSC_7db90bf5-d313-45d5-9168-f2915a4d90d1_SNAPS_','2021-03-29 09:29:42','2021-03-29 11:11:28','0196d2a5-bb55-4489-959e-17a336782716.png','2021-03-29 11:29:42','SYNCED','0196d2a5-bb55-4489-959e-17a336782716',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.9.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'01976d11-0796-4cef-9551-3bbddcdae9de','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01976d11-0796-4cef-9551-3bbddcdae9de.ply','PLY','PATIENT_e065ef95-3928-430d-bee5-6cc04ce694eb_ACT_6a0d8669-2b24-41a6-afc8-67c5db36fb79_SESS_e76e5d56-ee93-4811-a647-b126bbe2deae_TOSC_ca6b5df7-fb08-4f83-81bd-3c81148d907e_PLY_','2020-12-07 12:00:02','2020-08-20 15:24:32','01976d11-0796-4cef-9551-3bbddcdae9de.ply','2020-12-07 13:00:02','SYNCED','01976d11-0796-4cef-9551-3bbddcdae9de',0,NULL,'','','{\"displayTitle\":\"Maxillaire 61.1.19.1.2\",\"modelMatrix\":\"0.436139,-0.868671,0.234932,0,0.899879,0.421013,-0.113863,0,-1.24077e-8,0.261071,0.96532,0,-8.84137,-33.4867,-13.7065,1\",\"title\":\"Maxillaire PLY\"}'),(2,'019c2b94-3c2c-4e3c-9ae9-36406c1953d9','','SNAPS','PATIENT_1829dacc-d5a9-49fd-b839-bbafdac5d6d5_ACT_67ab9710-81c8-4504-bef5-f4622da2f42e_SESS_8ce2ba43-bdcd-4a3b-8850-1b6b9aa5dec8_TOSC_e897d8a4-6f81-49d3-9c6a-9b066b1c1654_SNAPS_','2021-09-29 14:23:06','2021-09-29 16:23:01','','2021-09-29 16:23:06','SYNCED','019c2b94-3c2c-4e3c-9ae9-36406c1953d9',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.403.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'01a6507e-9a01-43e6-b350-f0c1ec49dfa2','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01a6507e-9a01-43e6-b350-f0c1ec49dfa2.png','SNAPS','PATIENT_9f0bc98f-84b9-4844-b9fb-b12110dd0976_ACT_432fb1ee-981b-4c2d-9c57-3b8cb1b80e59_SESS_246facfb-36cd-4f62-9172-0d30480d5c59_TOSC_347deda0-8141-447f-a797-18e7cebbd4e3_SNAPS_','2021-03-16 13:35:56','2021-03-16 14:23:10','01a6507e-9a01-43e6-b350-f0c1ec49dfa2.png','2021-03-16 14:35:56','SYNCED','01a6507e-9a01-43e6-b350-f0c1ec49dfa2',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.82.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'01aeaed2-12a9-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01aeaed2-12a9-11eb-94ee-226cec7cb58a.png','SNAPS','PATIENT_bfff99cf-e91f-4eed-bb3a-06bece8eaf9f_ACT_cb82e38f-42ee-4080-91b2-e394804b2bfd_SESS_dfa0139b-bec6-44de-8cdb-fd857eb95e51_BOSC_ce7345fd-b881-4de2-ae3c-352b7612c2b2_SNAPS_','2020-12-02 10:31:39','2020-06-16 13:59:35','01aeaed2-12a9-11eb-94ee-226cec7cb58a.png','2020-12-02 11:31:39','SYNCED','01aeaed2-12a9-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 20.1.1.3.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'01b2052d-12a9-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01b2052d-12a9-11eb-94ee-226cec7cb58a.ply','PLY','PATIENT_bfff99cf-e91f-4eed-bb3a-06bece8eaf9f_ACT_cb82e38f-42ee-4080-91b2-e394804b2bfd_SESS_dfa0139b-bec6-44de-8cdb-fd857eb95e51_BOSC_ce7345fd-b881-4de2-ae3c-352b7612c2b2_PLY_','2020-12-02 10:31:39','2020-06-16 13:59:35','01b2052d-12a9-11eb-94ee-226cec7cb58a.ply','2020-12-02 11:31:39','SYNCED','01b2052d-12a9-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 20.1.1.3.1.1\",\"modelMatrix\":\"-0.993172,0.11359,-0.0265794,0,-0.116658,-0.96705,0.226285,0,1.90146e-10,0.22784,0.973699,0,-2.66472,16.6321,-21.087,1\",\"title\":\"Mandibule PLY\"}'),(2,'01b22b0f-ea8e-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01b22b0f-ea8e-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_3e53fe02-afc4-4a4e-baa1-8e748cae6c31_ACT_7c221ea4-4cae-4db9-9833-48b1955c6d3e_SESS_759f7cb5-cf25-43d3-8a49-15e06ae98c56_BOSC_54df7545-92b5-4c41-b7f3-fb58a9c6a435_SNAPS_','2021-12-07 08:38:09','2019-10-09 14:11:34','01b22b0f-ea8e-11e9-947d-226cec7cb58a.png','2021-12-07 09:38:09','SYNCED','01b22b0f-ea8e-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 182.2.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'01b39498-ea8e-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01b39498-ea8e-11e9-947d-226cec7cb58a.stl','STL','PATIENT_3e53fe02-afc4-4a4e-baa1-8e748cae6c31_ACT_7c221ea4-4cae-4db9-9833-48b1955c6d3e_SESS_759f7cb5-cf25-43d3-8a49-15e06ae98c56_TOSC_5960393d-c5d2-4c4b-b829-7f09cf5858e1_STL_','2021-12-07 08:38:09','2019-10-09 14:07:14','01b39498-ea8e-11e9-947d-226cec7cb58a.stl','2021-12-07 09:38:09','SYNCED','01b39498-ea8e-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 182.2.1.1\",\"modelMatrix\":\"-0.161793,-0.932839,0.321923,0,0.986825,-0.152942,0.0527802,0,-3.54057e-10,0.326221,0.945294,0,-25.7894,-27.5189,-29.8912,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'01b4e4af-ea8e-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01b4e4af-ea8e-11e9-947d-226cec7cb58a.stl','STL','PATIENT_3e53fe02-afc4-4a4e-baa1-8e748cae6c31_ACT_7c221ea4-4cae-4db9-9833-48b1955c6d3e_SESS_759f7cb5-cf25-43d3-8a49-15e06ae98c56_BOSC_54df7545-92b5-4c41-b7f3-fb58a9c6a435_STL_','2021-12-07 08:38:09','2019-10-09 14:11:34','01b4e4af-ea8e-11e9-947d-226cec7cb58a.stl','2021-12-07 09:38:09','SYNCED','01b4e4af-ea8e-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 182.2.1.1\",\"modelMatrix\":\"-0.999066,-0.0420892,0.00980389,0,0.0432159,-0.973018,0.226646,0,-7.14046e-10,0.226858,0.973928,0,-16.0175,16.5323,-26.7006,1\",\"title\":\"MANDIBULE STL\"}'),(2,'01b6756f-ea8e-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01b6756f-ea8e-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_3e53fe02-afc4-4a4e-baa1-8e748cae6c31_ACT_7c221ea4-4cae-4db9-9833-48b1955c6d3e_SESS_759f7cb5-cf25-43d3-8a49-15e06ae98c56_TOSC_5960393d-c5d2-4c4b-b829-7f09cf5858e1_PLY_','2021-12-07 08:38:10','2019-10-09 14:07:14','01b6756f-ea8e-11e9-947d-226cec7cb58a.ply','2021-12-07 09:38:10','SYNCED','01b6756f-ea8e-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 182.2.1.1\",\"modelMatrix\":\"-0.161793,-0.932839,0.321923,0,0.986825,-0.152942,0.0527802,0,-3.54057e-10,0.326221,0.945294,0,-25.7894,-27.5189,-29.8912,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'01b7c19c-ea8e-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01b7c19c-ea8e-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_3e53fe02-afc4-4a4e-baa1-8e748cae6c31_ACT_7c221ea4-4cae-4db9-9833-48b1955c6d3e_SESS_759f7cb5-cf25-43d3-8a49-15e06ae98c56_TOSC_5960393d-c5d2-4c4b-b829-7f09cf5858e1_SNAPS_','2021-12-07 08:38:10','2019-10-09 14:07:14','01b7c19c-ea8e-11e9-947d-226cec7cb58a.png','2021-12-07 09:38:10','SYNCED','01b7c19c-ea8e-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 182.2.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'01b90682-ea8e-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01b90682-ea8e-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_3e53fe02-afc4-4a4e-baa1-8e748cae6c31_ACT_7c221ea4-4cae-4db9-9833-48b1955c6d3e_SESS_759f7cb5-cf25-43d3-8a49-15e06ae98c56_BOSC_54df7545-92b5-4c41-b7f3-fb58a9c6a435_PLY_','2021-12-07 08:38:10','2019-10-09 14:11:34','01b90682-ea8e-11e9-947d-226cec7cb58a.ply','2021-12-07 09:38:10','SYNCED','01b90682-ea8e-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 182.2.1.1\",\"modelMatrix\":\"-0.999066,-0.0420892,0.00980389,0,0.0432159,-0.973018,0.226646,0,-7.14046e-10,0.226858,0.973928,0,-16.0175,16.5323,-26.7006,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'01b9dabc-6dcd-4429-8e2f-0bb79ab0f845','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01b9dabc-6dcd-4429-8e2f-0bb79ab0f845.ply','PLY','PATIENT_0a66945b-1a85-401b-ad4b-8f12d5db9a24_ACT_cb5e78e7-76fe-4b53-a205-f9848e191205_SESS_b910b3e0-439a-469f-8215-5ef68253dded_BOSC_f55a2f95-8884-4a24-8c9d-7fc71862595c_PLY_','2022-03-04 13:40:20','2019-07-11 10:51:33','01b9dabc-6dcd-4429-8e2f-0bb79ab0f845.ply','2022-03-04 14:40:20','SYNCED','01b9dabc-6dcd-4429-8e2f-0bb79ab0f845',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 38.1.1.1\",\"modelMatrix\":\"-0.973864,0.219502,-0.0583813,0,-0.227133,-0.941144,0.250318,0,-1.74617e-9,0.257036,0.966402,0,-15.9619,18.2817,-25.4787,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'01bb05bc-112e-46de-8b80-20e0cacad764','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01bb05bc-112e-46de-8b80-20e0cacad764.png','SNAPS','PATIENT_183e1e44-c049-45b8-8e15-90b510c1c43f_ACT_739b3c65-5057-49d0-8174-dd85b45325e6_SESS_06e71475-7dc6-49b7-a980-0689aaae3a5d_TOSC_71ce3b04-6516-4d5a-bca5-570015244774_SNAPS_','2020-12-16 10:51:08','2020-03-12 14:47:11','01bb05bc-112e-46de-8b80-20e0cacad764.png','2020-12-16 11:51:08','SYNCED','01bb05bc-112e-46de-8b80-20e0cacad764',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'01c192c9-7e5e-47c5-896f-2f5113be5438','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01c192c9-7e5e-47c5-896f-2f5113be5438.png','SNAPS','PATIENT_55452abe-c899-4508-a6ad-a6862da81096_ACT_f590af08-ea0d-4176-af23-aa19fbbc81bd_SESS_1d2eedba-7320-43b2-9232-c9ff66bfa1bc_BOSC_e1dcc7f2-79a1-40ea-af89-0f957b30b166_SNAPS_','2020-12-08 10:47:12','2020-06-22 09:29:47','01c192c9-7e5e-47c5-896f-2f5113be5438.png','2020-12-08 11:47:12','SYNCED','01c192c9-7e5e-47c5-896f-2f5113be5438',0,NULL,'','','{\"displayTitle\":\"Mandibule 32.1.2.1.7\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'01c47ede-905e-4276-89a3-b08a58a552f1','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01c47ede-905e-4276-89a3-b08a58a552f1.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_545458c4-a572-4ba8-9afc-ce88de5ea182_SESS_4ee2efd2-7632-46a5-a38b-3641ad222066_BOSC_176ac5fd-b4f0-481a-a1b6-8206cbfd6d1b_PLY_','2021-04-14 08:39:16','2021-04-14 10:39:14','01c47ede-905e-4276-89a3-b08a58a552f1.ply','2021-04-14 10:39:16','SYNCED','01c47ede-905e-4276-89a3-b08a58a552f1',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.58.1.1\",\"modelMatrix\":\"-0.757994,-0.648813,0.0669855,0,0.652262,-0.753986,0.0778438,0,8.19924e-9,0.102697,0.994713,0,-18.9266,3.26407,-18.9936,1\",\"title\":\"Mandibule PLY\"}'),(2,'01cb46b7-f296-4599-83d9-dd4169f3f3dc','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01cb46b7-f296-4599-83d9-dd4169f3f3dc.ply','PLY','PATIENT_4ed0364e-d067-4452-8839-8e909c61b1ea_ACT_439d6b4b-8f66-4316-a9b9-00cd70637694_SESS_14bc0526-ec82-440b-a6a4-b544d274a55b_TOSC_c880d341-0837-4d73-9aaa-da9b4f978b1d_PLY_','2020-12-08 10:54:34','2020-06-08 10:18:25','01cb46b7-f296-4599-83d9-dd4169f3f3dc.ply','2020-12-08 11:54:34','SYNCED','01cb46b7-f296-4599-83d9-dd4169f3f3dc',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.29.1.1\",\"modelMatrix\":\"0.533222,-0.821323,0.202738,0,0.845976,0.517683,-0.127787,0,-4.71109e-9,0.23965,0.970859,0,-4.15096,-32.3971,-14.4051,1\",\"title\":\"Maxillaire PLY\"}'),(2,'01d038c2-4ea0-42af-af44-37836db46c9f','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01d038c2-4ea0-42af-af44-37836db46c9f.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_9dcc3d38-3a64-4848-aae9-3d6efca8c19b_SESS_aa4cef4d-d6e9-4c23-9795-622754bff084_TOSC_d43250a2-6d8e-4a0f-9b2e-ab7dbb091b9d_PLY_','2021-04-16 07:46:44','2021-04-16 09:46:42','01d038c2-4ea0-42af-af44-37836db46c9f.ply','2021-04-16 09:46:44','SYNCED','01d038c2-4ea0-42af-af44-37836db46c9f',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.71.1.2\",\"modelMatrix\":\"0.751943,-0.605801,0.259975,0,0.659228,0.691002,-0.296538,0,-1.31828e-9,0.394363,0.918955,0,9.48202,-33.6987,-19.5003,1\",\"title\":\"Maxillaire PLY\"}'),(2,'01e251e6-49df-45f1-9b6d-a7f082e265c9','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01e251e6-49df-45f1-9b6d-a7f082e265c9.png','SNAPS','PATIENT_4fe1eb6d-1c3d-424a-a21d-38f6611e1e6a_ACT_8174253b-4f7a-444d-afdf-edab34a43ee8_SESS_9a6d9806-b486-4063-a4ad-790eeb3af292_BOSC_334e9492-6b0e-4288-abee-2ad3f2820b84_SNAPS_','2021-01-15 10:48:01','2021-01-15 11:42:27','01e251e6-49df-45f1-9b6d-a7f082e265c9.png','2021-01-15 11:48:01','SYNCED','01e251e6-49df-45f1-9b6d-a7f082e265c9',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.7.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'01ed3b45-d152-4f2d-a528-b0148ba0c358','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01ed3b45-d152-4f2d-a528-b0148ba0c358.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_7e5aa64e-d017-4a70-970a-fe68db3e7c38_SESS_b9ea5d03-2206-42ef-8da3-4d72a97c7b00_TOSC_ff4b3fdf-95a5-45b5-894d-ac82fa231e4a_PLY_','2021-08-31 08:01:04','2021-08-31 10:01:00','01ed3b45-d152-4f2d-a528-b0148ba0c358.ply','2021-08-31 10:01:04','SYNCED','01ed3b45-d152-4f2d-a528-b0148ba0c358',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.189.1.1\",\"modelMatrix\":\"0.212707,-0.938157,0.273163,0,0.977116,0.204226,-0.0594645,0,-2.01121e-9,0.279561,0.960128,0,-17.9778,-32.5722,-15.6799,1\",\"title\":\"Maxillaire PLY\"}'),(2,'01ef3f57-b136-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01ef3f57-b136-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_64c7fd99-6753-4e45-90f5-ecf7a34ff48c_ACT_2e528630-1806-4d7e-a255-1699c9fdcd28_SESS_aa55adeb-bb57-4e86-87e6-ea423db4eab5_TOSC_10d097be-4df9-4d3b-84bd-88416166ad49_PLY_','2020-12-08 10:54:35','2020-06-18 09:25:05','01ef3f57-b136-11ea-947d-226cec7cb58a.ply','2020-12-08 11:54:35','SYNCED','01ef3f57-b136-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.61.1.1\",\"modelMatrix\":\"0.422553,-0.886488,0.188647,0,0.906338,0.413299,-0.0879512,0,1.83295e-9,0.208142,0.978099,0,-4.19759,-35.1844,-19.8637,1\",\"title\":\"Maxillaire PLY\"}'),(2,'01f0ffcc-1f20-45f7-b2a2-4dcd2bdf614d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01f0ffcc-1f20-45f7-b2a2-4dcd2bdf614d.png','SNAPS','PATIENT_2c31ad8e-22ad-441e-9c15-c34ef23d4519_ACT_e319cb73-6f62-4156-8701-64f342c4711e_SESS_df356414-5249-4c0a-a80c-c8031597086a_TOSC_5ba2bba1-a95a-4d62-9570-f28eeb93be5a_SNAPS_','2020-12-23 09:07:07','2019-12-31 12:04:33','01f0ffcc-1f20-45f7-b2a2-4dcd2bdf614d.png','2020-12-23 10:07:07','SYNCED','01f0ffcc-1f20-45f7-b2a2-4dcd2bdf614d',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'01f17a83-b136-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01f17a83-b136-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_64c7fd99-6753-4e45-90f5-ecf7a34ff48c_ACT_2e528630-1806-4d7e-a255-1699c9fdcd28_SESS_aa55adeb-bb57-4e86-87e6-ea423db4eab5_TOSC_10d097be-4df9-4d3b-84bd-88416166ad49_SNAPS_','2020-12-08 10:54:36','2020-06-18 09:25:05','01f17a83-b136-11ea-947d-226cec7cb58a.png','2020-12-08 11:54:36','SYNCED','01f17a83-b136-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.61.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'01f372e2-b136-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01f372e2-b136-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_2e528630-1806-4d7e-a255-1699c9fdcd28_SESS_aa55adeb-bb57-4e86-87e6-ea423db4eab5_BOSC_cb6a7309-e36f-4913-b35d-db5c1f576027_SNAPS_','2020-12-08 10:54:36','2020-06-18 09:29:24','01f372e2-b136-11ea-947d-226cec7cb58a.png','2020-12-08 11:54:36','SYNCED','01f372e2-b136-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.61.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'01f38cf9-df75-44f2-9c75-38a3c6900a77','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01f38cf9-df75-44f2-9c75-38a3c6900a77.zip','ZIP','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_3024afc1-dff4-4d2c-9c45-fe6abc4f5657_SESS_76b09760-7e9e-44b9-aa6c-12b86eb45342_BOSC_fe7b02fc-ddbf-4df3-b71f-8ab4eba3e9a4_ZIP_','2021-10-07 14:24:27','2021-10-07 16:24:24','01f38cf9-df75-44f2-9c75-38a3c6900a77.zip','2021-10-07 16:24:27','SYNCED','01f38cf9-df75-44f2-9c75-38a3c6900a77',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.192.1.3\",\"modelMatrix\":\"-0.957397,-0.278422,0.076634,0,0.288776,-0.923069,0.254069,0,3.68549e-9,0.265375,0.964145,0,-23.5961,9.68214,-19.3023,1\",\"title\":\"Mandibule ZIP\"}'),(2,'01f52e07-b136-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01f52e07-b136-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_2e528630-1806-4d7e-a255-1699c9fdcd28_SESS_aa55adeb-bb57-4e86-87e6-ea423db4eab5_BOSC_cb6a7309-e36f-4913-b35d-db5c1f576027_PLY_','2020-12-08 10:54:37','2020-06-18 09:29:24','01f52e07-b136-11ea-947d-226cec7cb58a.ply','2020-12-08 11:54:37','SYNCED','01f52e07-b136-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.61.1.1\",\"modelMatrix\":\"-0.982259,0.180477,-0.0509406,0,-0.187528,-0.945325,0.266823,0,-1.06424e-9,0.271642,0.962398,0,-15.2483,14.687,-20.9958,1\",\"title\":\"Mandibule PLY\"}'),(2,'01f66df4-7745-11eb-9452-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01f66df4-7745-11eb-9452-226cec7cb58a.png','SNAPS','PATIENT_2aa6e500-959c-4ad7-b322-62edde25b391_ACT_b7bc042d-95d4-45b7-a66e-ac5645f21987_SESS_0a59fcbd-fe82-4c25-9569-c973303fa798_TOSC_3ee06446-29d1-41ad-8f5b-2df57494deda_SNAPS_','2021-02-16 16:37:57','2019-07-09 17:20:20','01f66df4-7745-11eb-9452-226cec7cb58a.png','2021-02-16 17:37:57','SYNCED','01f66df4-7745-11eb-9452-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 14.2.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'01f6ba87-1b58-4252-a2fa-6509d2ab884b','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01f6ba87-1b58-4252-a2fa-6509d2ab884b.ply','PLY','PATIENT_d7c2f496-2763-411d-b982-129051affb67_ACT_e364d383-4373-49f0-a225-ca5a58e2fdbc_SESS_c4fffe2d-f925-425f-b593-d6a2cfbe7341_BOSC_f2bea834-4c7a-40e7-832c-dea7d0447263_PLY_','2021-02-26 10:38:55','2021-02-26 11:33:42','01f6ba87-1b58-4252-a2fa-6509d2ab884b.ply','2021-02-26 11:38:55','SYNCED','01f6ba87-1b58-4252-a2fa-6509d2ab884b',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.59.1.2\",\"modelMatrix\":\"-0.999999,-0.00121855,0.000414412,0,0.00128709,-0.946747,0.321976,0,1.52174e-11,0.321977,0.946748,0,-20.0268,13.3713,-15.7363,1\",\"title\":\"Mandibule PLY\"}'),(2,'01f954a1-7745-11eb-9452-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01f954a1-7745-11eb-9452-226cec7cb58a.pdf','PDF','PATIENT_2aa6e500-959c-4ad7-b322-62edde25b391_ACT_b7bc042d-95d4-45b7-a66e-ac5645f21987_PROST_08d972da-0641-4e2a-bffa-76522851fd4e_PDF_','2021-02-25 08:39:41','2021-02-25 09:39:39','01f954a1-7745-11eb-9452-226cec7cb58a.pdf','2021-02-25 09:39:41','SYNCED','01f954a1-7745-11eb-9452-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"INLAY CORE 14.2.1.1.1 INLAY CORE\",\"title\":\"Inlay Core PDF\"}'),(2,'01fc1c79-7745-11eb-9452-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01fc1c79-7745-11eb-9452-226cec7cb58a.png','SNAPS','PATIENT_2aa6e500-959c-4ad7-b322-62edde25b391_ACT_b7bc042d-95d4-45b7-a66e-ac5645f21987_SESS_0a59fcbd-fe82-4c25-9569-c973303fa798_BOSC_980fc19a-c1d5-43e0-8886-b39817252ba5_SNAPS_','2021-02-14 10:05:53','2019-07-09 17:23:46','01fc1c79-7745-11eb-9452-226cec7cb58a.png','2021-02-14 11:05:53','SYNCED','01fc1c79-7745-11eb-9452-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 14.2.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'01fed449-1667-471f-a968-211ba60a76b5','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/01fed449-1667-471f-a968-211ba60a76b5.png','SNAPS','PATIENT_196f3637-95c1-4658-beca-3c3b12c69741_ACT_0ab405cb-3901-4eb7-8b5a-6e292c293888_SESS_8f034154-5a36-4a74-b2b8-e5eb50522190_BOSC_dd2c4455-43fa-4b9d-8f7d-b8e42b33aeb0_SNAPS_','2020-12-15 12:58:24','2020-12-15 13:58:23','01fed449-1667-471f-a968-211ba60a76b5.png','2020-12-15 13:58:24','SYNCED','01fed449-1667-471f-a968-211ba60a76b5',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.37.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0200c4b7-7745-11eb-9452-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0200c4b7-7745-11eb-9452-226cec7cb58a.ply','PLY','PATIENT_2aa6e500-959c-4ad7-b322-62edde25b391_ACT_b7bc042d-95d4-45b7-a66e-ac5645f21987_SESS_0a59fcbd-fe82-4c25-9569-c973303fa798_BOSC_980fc19a-c1d5-43e0-8886-b39817252ba5_PLY_','2021-02-14 10:07:51','2019-07-09 17:23:46','0200c4b7-7745-11eb-9452-226cec7cb58a.ply','2021-02-14 11:07:51','SYNCED','0200c4b7-7745-11eb-9452-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 14.2.1.1\",\"modelMatrix\":\"-0.983484,-0.176157,0.0415677,0,0.180995,-0.957196,0.225869,0,3.50663e-9,0.229662,0.97327,0,-27.5532,10.9078,-22.7908,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0203a5a9-7745-11eb-9452-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0203a5a9-7745-11eb-9452-226cec7cb58a.ply','PLY','PATIENT_2aa6e500-959c-4ad7-b322-62edde25b391_ACT_b7bc042d-95d4-45b7-a66e-ac5645f21987_SESS_0a59fcbd-fe82-4c25-9569-c973303fa798_TOSC_3ee06446-29d1-41ad-8f5b-2df57494deda_PLY_','2021-02-14 10:09:06','2019-07-09 17:20:20','0203a5a9-7745-11eb-9452-226cec7cb58a.ply','2021-02-14 11:09:06','SYNCED','0203a5a9-7745-11eb-9452-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 14.2.1.1\",\"modelMatrix\":\"0.130338,-0.958063,0.255201,0,0.99147,0.125946,-0.0335486,0,3.6959e-9,0.257397,0.966306,0,-23.6704,-35.4409,-23.9508,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'020490ba-0ee5-4918-ace7-22a6c501a128','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/020490ba-0ee5-4918-ace7-22a6c501a128.png','SNAPS','PATIENT_ea4696ad-9b3f-41bd-91e7-65151af81fdd_ACT_faf04d51-f559-4b26-a6c7-9faad21fd00f_SESS_581924a3-8f7b-463f-b03d-e26104e3fccc_BOSC_df805c77-55d4-4baf-a369-71e6cfcebefd_SNAPS_','2021-07-02 08:51:45','2021-07-02 10:51:44','020490ba-0ee5-4918-ace7-22a6c501a128.png','2021-07-02 10:51:45','SYNCED','020490ba-0ee5-4918-ace7-22a6c501a128',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.371.4.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'02062874-7745-11eb-9452-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02062874-7745-11eb-9452-226cec7cb58a.json','JSON','PATIENT_2aa6e500-959c-4ad7-b322-62edde25b391_ACT_b7bc042d-95d4-45b7-a66e-ac5645f21987_PROST_08d972da-0641-4e2a-bffa-76522851fd4e_JSON_','2021-02-25 08:39:42','2021-02-25 09:39:39','02062874-7745-11eb-9452-226cec7cb58a.json','2021-02-25 09:39:42','SYNCED','02062874-7745-11eb-9452-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"INLAY CORE 14.2.1.1.1 INLAY CORE\",\"title\":\"Inlay Core JSON\"}'),(2,'020b084a-1bd2-46d0-903d-8bddefeba51c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/020b084a-1bd2-46d0-903d-8bddefeba51c.png','SNAPS','PATIENT_458a8d5d-1247-431f-9ae5-c8251b474042_ACT_33a956c9-6fa5-4721-959b-c0eba3bafa3d_SESS_7af60a07-7446-4574-a777-e18b27254176_BOSC_0dfc5923-8fb2-45d8-a0c2-67c5c0461d71_SNAPS_','2020-12-02 10:31:41','2020-11-20 09:43:57','020b084a-1bd2-46d0-903d-8bddefeba51c.png','2020-12-02 11:31:41','SYNCED','020b084a-1bd2-46d0-903d-8bddefeba51c',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.24.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'020e2dc9-06f7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/020e2dc9-06f7-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_db56cba1-23ff-48bf-b86e-4ceff749087f_TOSC_ee6a9a11-5f12-4108-99f0-f79ed91ada60_SNAPS_','2021-12-07 08:38:10','2019-11-14 14:35:28','020e2dc9-06f7-11ea-947d-226cec7cb58a.png','2021-12-07 09:38:10','SYNCED','020e2dc9-06f7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 202.1.1.2\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'020f9fcd-06f7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/020f9fcd-06f7-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_db56cba1-23ff-48bf-b86e-4ceff749087f_BOSC_61758c9e-f753-4e49-aa06-7f9b9fb5d0c0_PLY_','2021-12-07 08:38:10','2019-11-14 15:29:16','020f9fcd-06f7-11ea-947d-226cec7cb58a.ply','2021-12-07 09:38:10','SYNCED','020f9fcd-06f7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 202.1.1.2\",\"modelMatrix\":\"-0.784347,0.614172,-0.0871374,0,-0.620322,-0.77657,0.110178,0,-1.89916e-9,0.140471,0.990085,0,-4.05211,19.878,-15.8828,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'021029ce-f7b9-4309-8c1a-01232074867d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/021029ce-f7b9-4309-8c1a-01232074867d.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_cf7510f6-bfb5-4e90-af14-79e2643fc837_SNAPS_','2020-12-16 11:05:25','2020-01-24 13:50:45','021029ce-f7b9-4309-8c1a-01232074867d.png','2020-12-16 12:05:25','SYNCED','021029ce-f7b9-4309-8c1a-01232074867d',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.8\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'02109474-8126-4200-8c77-264b90ceb7c3','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02109474-8126-4200-8c77-264b90ceb7c3.ply','PLY','PATIENT_3c4177d7-90df-4748-802b-fdc4b19eefe1_ACT_e83c88ff-64bd-4195-acd1-2626e201f8a9_SESS_2a210fa4-ec74-4417-82cf-08f486f4fc93_BOSC_b802d2fa-0469-4e71-aef0-df8836074079_PLY_','2021-01-08 13:35:38','2021-01-08 14:33:47','02109474-8126-4200-8c77-264b90ceb7c3.ply','2021-01-08 14:35:38','SYNCED','02109474-8126-4200-8c77-264b90ceb7c3',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.71.1.3\",\"modelMatrix\":\"-0.963115,0.261208,-0.0646617,0,-0.269092,-0.934895,0.231432,0,-2.86804e-9,0.240296,0.9707,0,-11.5453,19.8433,-16.8069,1\",\"title\":\"Mandibule PLY\"}'),(2,'02111727-06f7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02111727-06f7-11ea-947d-226cec7cb58a.stl','STL','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_db56cba1-23ff-48bf-b86e-4ceff749087f_TOSC_ee6a9a11-5f12-4108-99f0-f79ed91ada60_STL_','2021-12-07 08:38:10','2019-11-14 14:35:28','02111727-06f7-11ea-947d-226cec7cb58a.stl','2021-12-07 09:38:10','SYNCED','02111727-06f7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 202.1.1.2\",\"modelMatrix\":\"0.387292,-0.880586,0.27308,0,0.921957,0.369913,-0.114715,0,-3.27977e-9,0.296196,0.955127,0,-3.7782,-36.0627,-16.3793,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'02118e1a-6e10-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02118e1a-6e10-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_69cc74d6-d976-48e9-8eec-693ff64095cf_SESS_448f3142-44dc-4a92-a676-47ac91eb67c2_TOSC_afaf0b37-9e06-4145-9144-05f4aee82d07_SNAPS_','2022-01-05 09:57:03','2022-01-05 10:56:58','02118e1a-6e10-11ec-9377-226cec7cb58a.png','2022-01-05 10:57:03','SYNCED','02118e1a-6e10-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.2.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0211d5ee-1cf8-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0211d5ee-1cf8-11eb-94ee-226cec7cb58a.png','SNAPS','PATIENT_196f3637-95c1-4658-beca-3c3b12c69741_ACT_0c1906ae-b137-4388-8a42-0ab9a792bdc7_SESS_0bb91c40-4a67-4087-911f-6c3fe2520568_TOSC_f5df16ca-1026-45e0-a272-c6f62c54e37d_SNAPS_','2020-12-02 10:31:42','2020-11-02 11:11:34','0211d5ee-1cf8-11eb-94ee-226cec7cb58a.png','2020-12-02 11:31:42','SYNCED','0211d5ee-1cf8-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.36.1.1.4\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0211de51-8772-4990-92c7-1e6029238302','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0211de51-8772-4990-92c7-1e6029238302.png','SNAPS','PATIENT_1fe53bd5-165d-4f83-8b14-5ccfa106502b_ACT_160645fc-3820-4053-baf9-297adc7a3bd0_SESS_e51149df-9a1e-4ccd-b213-42584b7c91f8_TOSC_8c462e06-1f0c-43f2-a258-219811582fb3_SNAPS_','2021-01-06 11:01:48','2019-12-11 16:12:25','0211de51-8772-4990-92c7-1e6029238302.png','2021-01-06 12:01:48','SYNCED','0211de51-8772-4990-92c7-1e6029238302',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 232.3.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0212747b-06f7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0212747b-06f7-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_db56cba1-23ff-48bf-b86e-4ceff749087f_BOSC_61758c9e-f753-4e49-aa06-7f9b9fb5d0c0_SNAPS_','2021-12-07 08:38:11','2019-11-14 15:29:16','0212747b-06f7-11ea-947d-226cec7cb58a.png','2021-12-07 09:38:11','SYNCED','0212747b-06f7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 202.1.1.2\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0212e151-1cf8-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0212e151-1cf8-11eb-94ee-226cec7cb58a.png','SNAPS','PATIENT_196f3637-95c1-4658-beca-3c3b12c69741_ACT_0c1906ae-b137-4388-8a42-0ab9a792bdc7_SESS_0bb91c40-4a67-4087-911f-6c3fe2520568_BOSC_6a2c6033-545a-455a-8780-95d24ccf008f_SNAPS_','2020-12-02 10:31:42','2020-11-02 11:19:17','0212e151-1cf8-11eb-94ee-226cec7cb58a.png','2020-12-02 11:31:42','SYNCED','0212e151-1cf8-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.1.1.4\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0213b009-06f7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0213b009-06f7-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_db56cba1-23ff-48bf-b86e-4ceff749087f_TOSC_ee6a9a11-5f12-4108-99f0-f79ed91ada60_PLY_','2021-12-07 08:38:11','2019-11-14 14:35:28','0213b009-06f7-11ea-947d-226cec7cb58a.ply','2021-12-07 09:38:11','SYNCED','0213b009-06f7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 202.1.1.2\",\"modelMatrix\":\"0.387292,-0.880586,0.27308,0,0.921957,0.369913,-0.114715,0,-3.27977e-9,0.296196,0.955127,0,-3.7782,-36.0627,-16.3793,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0214e61b-06f7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0214e61b-06f7-11ea-947d-226cec7cb58a.stl','STL','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_db56cba1-23ff-48bf-b86e-4ceff749087f_BOSC_61758c9e-f753-4e49-aa06-7f9b9fb5d0c0_STL_','2021-12-07 08:38:11','2019-11-14 15:29:16','0214e61b-06f7-11ea-947d-226cec7cb58a.stl','2021-12-07 09:38:11','SYNCED','0214e61b-06f7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 202.1.1.2\",\"modelMatrix\":\"-0.784347,0.614172,-0.0871374,0,-0.620322,-0.77657,0.110178,0,-1.89916e-9,0.140471,0.990085,0,-4.05211,19.878,-15.8828,1\",\"title\":\"MANDIBULE STL\"}'),(2,'021679ec-1cf8-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/021679ec-1cf8-11eb-94ee-226cec7cb58a.ply','PLY','PATIENT_196f3637-95c1-4658-beca-3c3b12c69741_ACT_0c1906ae-b137-4388-8a42-0ab9a792bdc7_SESS_0bb91c40-4a67-4087-911f-6c3fe2520568_TOSC_f5df16ca-1026-45e0-a272-c6f62c54e37d_PLY_','2020-12-02 10:31:43','2020-11-02 11:11:34','021679ec-1cf8-11eb-94ee-226cec7cb58a.ply','2020-12-02 11:31:43','SYNCED','021679ec-1cf8-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.36.1.1.4\",\"modelMatrix\":\"0.731347,-0.641029,0.232836,0,0.682005,0.687407,-0.249682,0,8.17281e-9,0.341399,0.939918,0,8.565,-37.1764,-16.639,1\",\"title\":\"Maxillaire PLY\"}'),(2,'02171709-6e10-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02171709-6e10-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_69cc74d6-d976-48e9-8eec-693ff64095cf_SESS_448f3142-44dc-4a92-a676-47ac91eb67c2_BOSC_7f372b8c-0d1b-4f52-951e-435466a35b56_ZIP_','2022-01-05 10:11:54','2022-01-05 11:11:52','02171709-6e10-11ec-9377-226cec7cb58a.zip','2022-01-05 11:11:54','SYNCED','02171709-6e10-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.2.1.3\",\"modelMatrix\":\"-0.679911,-0.721934,0.128576,0,0.733294,-0.669378,0.119215,0,-5.86875e-9,0.17534,0.984508,0,-19.6634,-7.83033,-20.0632,1\",\"title\":\"Mandibule ZIP\"}'),(2,'02179875-1cf8-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02179875-1cf8-11eb-94ee-226cec7cb58a.ply','PLY','PATIENT_196f3637-95c1-4658-beca-3c3b12c69741_ACT_0c1906ae-b137-4388-8a42-0ab9a792bdc7_SESS_0bb91c40-4a67-4087-911f-6c3fe2520568_BOSC_6a2c6033-545a-455a-8780-95d24ccf008f_PLY_','2020-12-02 10:31:43','2020-11-02 11:19:17','02179875-1cf8-11eb-94ee-226cec7cb58a.ply','2020-12-02 11:31:43','SYNCED','02179875-1cf8-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.1.1.4\",\"modelMatrix\":\"-0.930203,0.35254,-0.102166,0,-0.367046,-0.893442,0.25892,0,7.98697e-9,0.278348,0.96048,0,-4.86982,16.3929,-17.7774,1\",\"title\":\"Mandibule PLY\"}'),(2,'021adcc9-c2e1-456f-ba28-704638d97c92','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/021adcc9-c2e1-456f-ba28-704638d97c92.zip','ZIP','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_6e211e38-21f0-4228-981c-d0b1f0a4fed3_SESS_b40dbc55-3caa-4858-a407-09eca28423f4_TOSC_6898ad2c-6d59-448b-a39d-aeb6a27881ea_ZIP_','2021-09-28 10:22:37','2021-09-28 12:22:34','021adcc9-c2e1-456f-ba28-704638d97c92.zip','2021-09-28 12:22:37','SYNCED','3f8cada2-95a4-4f37-b59e-b94d7ef87f28',1,NULL,'','','{\"displayTitle\":\"Maxillaire 19.3.22.28.1.1\",\"modelMatrix\":\"-0.240704,0.903346,-0.355004,0,-0.970599,-0.224025,0.0880391,0,4.4449e-9,0.365757,0.93071,0,-14.1083,-34.7835,-15.113,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'021b452f-6e10-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/021b452f-6e10-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_69cc74d6-d976-48e9-8eec-693ff64095cf_SESS_448f3142-44dc-4a92-a676-47ac91eb67c2_TOSC_02a6a3fe-d446-418e-902f-e354b32cf598_SNAPS_','2022-01-05 10:03:28','2022-01-05 11:03:23','021b452f-6e10-11ec-9377-226cec7cb58a.png','2022-01-05 11:03:28','SYNCED','021b452f-6e10-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.2.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'021cc598-3998-4d2c-a77f-cb3cca432a8e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/021cc598-3998-4d2c-a77f-cb3cca432a8e.stl','STL','PATIENT_2aa6e500-959c-4ad7-b322-62edde25b391_ACT_b7bc042d-95d4-45b7-a66e-ac5645f21987_SESS_0a59fcbd-fe82-4c25-9569-c973303fa798_BOSC_980fc19a-c1d5-43e0-8886-b39817252ba5_STL_','2022-03-04 13:40:21','2019-07-09 17:23:46','021cc598-3998-4d2c-a77f-cb3cca432a8e.stl','2022-03-04 14:40:21','SYNCED','021cc598-3998-4d2c-a77f-cb3cca432a8e',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 14.2.1.1\",\"modelMatrix\":\"-0.983484,-0.176157,0.0415677,0,0.180995,-0.957196,0.225869,0,3.50663e-9,0.229662,0.97327,0,-27.5532,10.9078,-22.7908,1\",\"title\":\"MANDIBULE STL\"}'),(2,'022131a9-6e10-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/022131a9-6e10-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_69cc74d6-d976-48e9-8eec-693ff64095cf_SESS_448f3142-44dc-4a92-a676-47ac91eb67c2_BOSC_99ffd9d4-25f4-4da0-819a-a4174cab52f2_ZIP_','2022-01-05 10:08:53','2022-01-05 11:08:51','022131a9-6e10-11ec-9377-226cec7cb58a.zip','2022-01-05 11:08:53','SYNCED','022131a9-6e10-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.2.1.2\",\"modelMatrix\":\"-0.983542,-0.175976,0.0409607,0,0.18068,-0.957934,0.222972,0,-1.84335e-9,0.226703,0.973964,0,-24.2056,14.9385,-16.2862,1\",\"title\":\"Mandibule ZIP\"}'),(2,'0222741b-ac63-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0222741b-ac63-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_e35fbaa5-d7a0-42a5-b618-26a8a2103a86_ACT_f4db7c6b-fe9c-42e0-85b8-af618a6208c6_SESS_93bd4bb1-0e40-4467-8ba8-a836ea5e5b3d_BOSC_fe736191-fc66-465e-9b51-1a35c1a5534c_SNAPS_','2021-12-07 08:39:07','2019-07-22 13:36:37','0222741b-ac63-11e9-a33b-226cec7cb58a.png','2021-12-07 09:39:07','SYNCED','0222741b-ac63-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 107.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0223167e-ac63-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0223167e-ac63-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_e35fbaa5-d7a0-42a5-b618-26a8a2103a86_ACT_f4db7c6b-fe9c-42e0-85b8-af618a6208c6_SESS_93bd4bb1-0e40-4467-8ba8-a836ea5e5b3d_BOSC_fe736191-fc66-465e-9b51-1a35c1a5534c_STL_','2021-12-07 08:39:07','2019-07-22 13:36:37','0223167e-ac63-11e9-a33b-226cec7cb58a.stl','2021-12-07 09:39:07','SYNCED','0223167e-ac63-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 107.1.1.1\",\"modelMatrix\":\"-0.845958,0.532498,-0.0282894,0,-0.533249,-0.844767,0.0448789,0,-4.56777e-10,0.053051,0.998592,0,0.756341,22.1609,-20.24,1\",\"title\":\"MANDIBULE STL\"}'),(2,'0223913b-e124-49ed-8ee1-8812cbcff43a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0223913b-e124-49ed-8ee1-8812cbcff43a.ply','PLY','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_ccd32ea4-335e-423f-9503-0afc9e98b47c_SESS_3b2dce22-ba8a-4771-939a-5c34f694ed45_TOSC_cafd4f6c-5d81-4edd-aceb-ea770c23e8d5_PLY_','2020-12-07 12:00:07','2020-08-13 14:46:35','0223913b-e124-49ed-8ee1-8812cbcff43a.ply','2020-12-07 13:00:07','SYNCED','19c95734-abe9-4053-bb39-73134574b9cf',1,NULL,'','','{\"displayTitle\":\"Maxillaire 216.26.9.1.1\",\"modelMatrix\":\"0.798065,-0.554595,0.235621,0,0.602571,0.734523,-0.312064,0,-3.91223e-9,0.391025,0.92038,0,5.53926,-27.6233,-10.8944,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0223d121-ac63-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0223d121-ac63-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_e35fbaa5-d7a0-42a5-b618-26a8a2103a86_ACT_f4db7c6b-fe9c-42e0-85b8-af618a6208c6_SESS_93bd4bb1-0e40-4467-8ba8-a836ea5e5b3d_BOSC_fe736191-fc66-465e-9b51-1a35c1a5534c_PLY_','2021-12-07 08:39:08','2019-07-22 13:36:37','0223d121-ac63-11e9-a33b-226cec7cb58a.ply','2021-12-07 09:39:08','SYNCED','0223d121-ac63-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 107.1.1.1\",\"modelMatrix\":\"-0.845958,0.532498,-0.0282894,0,-0.533249,-0.844767,0.0448789,0,-4.56777e-10,0.053051,0.998592,0,0.756341,22.1609,-20.24,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'02247312-ac63-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02247312-ac63-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_e35fbaa5-d7a0-42a5-b618-26a8a2103a86_ACT_f4db7c6b-fe9c-42e0-85b8-af618a6208c6_SESS_93bd4bb1-0e40-4467-8ba8-a836ea5e5b3d_TOSC_35f55190-dfb3-41ee-9998-ac885f266e67_PLY_','2021-12-07 08:39:08','2019-07-22 13:27:50','02247312-ac63-11e9-a33b-226cec7cb58a.ply','2021-12-07 09:39:08','SYNCED','02247312-ac63-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 107.1.1.1\",\"modelMatrix\":\"0.331814,-0.868099,0.369193,0,0.943345,0.305347,-0.129861,0,6.70804e-9,0.391366,0.920235,0,-9.20109,-35.7061,-22.4628,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'02250f1a-ac63-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02250f1a-ac63-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_e35fbaa5-d7a0-42a5-b618-26a8a2103a86_ACT_f4db7c6b-fe9c-42e0-85b8-af618a6208c6_SESS_93bd4bb1-0e40-4467-8ba8-a836ea5e5b3d_TOSC_35f55190-dfb3-41ee-9998-ac885f266e67_SNAPS_','2021-12-07 08:39:08','2019-07-22 13:27:50','02250f1a-ac63-11e9-a33b-226cec7cb58a.png','2021-12-07 09:39:08','SYNCED','02250f1a-ac63-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 107.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0225947c-ac63-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0225947c-ac63-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_e35fbaa5-d7a0-42a5-b618-26a8a2103a86_ACT_f4db7c6b-fe9c-42e0-85b8-af618a6208c6_SESS_93bd4bb1-0e40-4467-8ba8-a836ea5e5b3d_TOSC_35f55190-dfb3-41ee-9998-ac885f266e67_STL_','2021-12-07 08:39:08','2019-07-22 13:27:50','0225947c-ac63-11e9-a33b-226cec7cb58a.stl','2021-12-07 09:39:08','SYNCED','0225947c-ac63-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 107.1.1.1\",\"modelMatrix\":\"0.331814,-0.868099,0.369193,0,0.943345,0.305347,-0.129861,0,6.70804e-9,0.391366,0.920235,0,-9.20109,-35.7061,-22.4628,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'0226146d-1b4d-41e9-8190-8efc6d758ad5','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0226146d-1b4d-41e9-8190-8efc6d758ad5.ply','PLY','PATIENT_bfe2f5ef-b8ba-4b0d-9ad7-cbfc8fa83859_ACT_c0e69491-c418-41cd-8f0d-cf8648b2e12b_SESS_e0a28906-ad9e-45ae-820f-8947728fae2d_BOSC_1a830b8f-7761-4dad-ae23-30e78282c977_PLY_','2021-01-11 12:54:18','2021-01-11 13:53:32','0226146d-1b4d-41e9-8190-8efc6d758ad5.ply','2021-01-11 13:54:18','SYNCED','0226146d-1b4d-41e9-8190-8efc6d758ad5',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.72.1.3\",\"modelMatrix\":\"-0.751834,-0.65786,0.044338,0,0.659353,-0.750132,0.0505568,0,4.68013e-9,0.0672447,0.997736,0,-20.1741,1.77525,-20.0938,1\",\"title\":\"Mandibule PLY\"}'),(2,'022859be-6e10-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/022859be-6e10-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_69cc74d6-d976-48e9-8eec-693ff64095cf_SESS_448f3142-44dc-4a92-a676-47ac91eb67c2_TOSC_afaf0b37-9e06-4145-9144-05f4aee82d07_ZIP_','2022-01-05 09:57:02','2022-01-05 10:56:59','022859be-6e10-11ec-9377-226cec7cb58a.zip','2022-01-05 10:57:02','SYNCED','022859be-6e10-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.2.1.1\",\"modelMatrix\":\"0.659378,-0.711187,0.24379,0,0.751812,0.623748,-0.213817,0,3.25936e-9,0.32427,0.945964,0,0.481209,-36.5428,-22.3051,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'022d80dc-6e10-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/022d80dc-6e10-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_69cc74d6-d976-48e9-8eec-693ff64095cf_SESS_448f3142-44dc-4a92-a676-47ac91eb67c2_BOSC_9fbc5121-2bc1-44da-b882-ce0470a69154_SNAPS_','2022-01-05 10:06:22','2022-01-05 11:06:14','022d80dc-6e10-11ec-9377-226cec7cb58a.png','2022-01-05 11:06:22','SYNCED','022d80dc-6e10-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.2.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0230ec8a-2af4-491d-9d2d-c973587b52c3','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0230ec8a-2af4-491d-9d2d-c973587b52c3.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_8f59d7a9-370a-4f32-836b-029d659589c2_SESS_5a2ce6c4-d074-4792-9c7a-3c8e2c1d5da3_TOSC_dc983fa1-27c4-4e8c-a502-9e5e289e42a4_SNAPS_','2021-04-08 12:17:18','2021-04-08 14:17:15','0230ec8a-2af4-491d-9d2d-c973587b52c3.png','2021-04-08 14:17:18','SYNCED','0230ec8a-2af4-491d-9d2d-c973587b52c3',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.40.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0234935d-4a2a-48cb-853d-d7cce95c0250','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0234935d-4a2a-48cb-853d-d7cce95c0250.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_87665c02-e5d9-49bf-8298-2fbddb730821_SESS_c5feb751-c308-430d-aca7-7ec47a49a052_BOSC_9cc6c0cf-c24e-47ca-ba31-2e6106e1a26a_PLY_','2020-12-16 10:51:12','2020-02-11 16:07:19','0234935d-4a2a-48cb-853d-d7cce95c0250.ply','2020-12-16 11:51:12','SYNCED','0234935d-4a2a-48cb-853d-d7cce95c0250',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"modelMatrix\":\"0.916965,0.381068,-0.118166,0,-0.398969,0.875823,-0.271584,0,3.07065e-9,0.296178,0.955133,0,17.4106,-13.4374,-18.4509,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0237ad98-6e10-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0237ad98-6e10-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_69cc74d6-d976-48e9-8eec-693ff64095cf_SESS_448f3142-44dc-4a92-a676-47ac91eb67c2_TOSC_45db60dd-9c7b-4cc5-9fd6-15862341cd31_SNAPS_','2022-01-05 10:00:30','2022-01-05 11:00:25','0237ad98-6e10-11ec-9377-226cec7cb58a.png','2022-01-05 11:00:30','SYNCED','0237ad98-6e10-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.2.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0237c4d2-471c-4c3c-ba08-83c366dc0aa4','','STL','PATIENT_c99d352c-a346-4446-b7d9-4cacf017b67a_ACT_2b22a50e-19be-4908-85ec-2b3c28f8a0a3_SESS_98d25a16-10f9-498a-b3ce-02ed35bb57db_BOSC_f8c7ea3d-e8d3-4562-8cc9-7f56875943af_STL_','2022-03-04 13:40:21','2019-07-09 13:26:08','','2022-03-04 14:40:21','SYNCED','0237c4d2-471c-4c3c-ba08-83c366dc0aa4',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 12.2.1.1\",\"modelMatrix\":\"-0.137502,-0.989748,0.0386197,0,0.990501,-0.137398,0.00536123,0,8.09006e-11,0.03899,0.99924,0,-24.6771,-17.3281,-26.6846,1\",\"title\":\"MANDIBULE STL\"}'),(2,'0239f36e-08b6-493f-a832-9d057c82dbe7','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0239f36e-08b6-493f-a832-9d057c82dbe7.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_7c21ea68-39da-4a12-abf1-9c2ba9f91b77_SESS_1fbf37e8-086a-47a0-bd17-1cfc93779d05_TOSC_fd553443-6b31-4714-8fa9-e9242e20ce0d_SNAPS_','2021-11-15 15:05:46','2021-11-15 16:05:42','0239f36e-08b6-493f-a832-9d057c82dbe7.png','2021-11-15 16:05:46','SYNCED','0239f36e-08b6-493f-a832-9d057c82dbe7',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.212.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'023e789e-89c4-409d-8131-f3adb26a6a60','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/023e789e-89c4-409d-8131-f3adb26a6a60.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_a652bfa0-2f48-4a5c-baee-0b1742d0f575_SNAPS_','2020-12-16 11:05:29','2020-01-24 13:33:07','023e789e-89c4-409d-8131-f3adb26a6a60.png','2020-12-16 12:05:29','SYNCED','023e789e-89c4-409d-8131-f3adb26a6a60',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.2\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'024053b9-6e10-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/024053b9-6e10-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_69cc74d6-d976-48e9-8eec-693ff64095cf_SESS_448f3142-44dc-4a92-a676-47ac91eb67c2_BOSC_9fbc5121-2bc1-44da-b882-ce0470a69154_ZIP_','2022-01-05 10:06:22','2022-01-05 11:06:15','024053b9-6e10-11ec-9377-226cec7cb58a.zip','2022-01-05 11:06:22','SYNCED','024053b9-6e10-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.2.1.1\",\"modelMatrix\":\"-0.985966,-0.155018,0.0619702,0,0.166946,-0.915522,0.36599,0,-3.16143e-10,0.3712,0.928553,0,-26.9448,6.61461,-16.9858,1\",\"title\":\"Mandibule ZIP\"}'),(2,'02420166-cdcc-4867-920a-0f1f2b14d241','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02420166-cdcc-4867-920a-0f1f2b14d241.stl','STL','PATIENT_0c1246d6-d8e8-4416-8498-e34a2e9ddfd8_ACT_628664ea-6869-485b-9c25-5b14151d796d_SESS_fbdbf097-6fee-4478-995f-6221a0d4627a_BOSC_5f094bfc-a13f-4914-8a09-41fcf18a809b_STL_','2021-01-06 11:01:52','2019-12-13 15:04:06','02420166-cdcc-4867-920a-0f1f2b14d241.stl','2021-01-06 12:01:52','SYNCED','02420166-cdcc-4867-920a-0f1f2b14d241',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 232.17.1.1\",\"modelMatrix\":\"-0.993781,-0.1046,0.0381808,0,0.11135,-0.933534,0.340757,0,-1.46497e-9,0.342889,0.939376,0,-16.9627,10.4973,-25.7872,1\",\"title\":\"MANDIBULE STL\"}'),(2,'024291a9-2f42-4ef1-a11c-bf1170931ade','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/024291a9-2f42-4ef1-a11c-bf1170931ade.ply','PLY','PATIENT_dd05555d-d207-41c7-8056-e1abbe098943_ACT_9e66533f-75f9-44e6-943a-10b3e14be2be_SESS_3f193960-fc07-4ebb-b5c8-20872a9f6e72_BOSC_fcb9fbd2-75dd-4725-a7c9-43161649c4d8_PLY_','2020-12-09 12:41:33','2020-12-09 13:41:31','024291a9-2f42-4ef1-a11c-bf1170931ade.ply','2020-12-09 13:41:33','SYNCED','024291a9-2f42-4ef1-a11c-bf1170931ade',0,NULL,'','','{\"displayTitle\":\"Mandibule 311.1.1.1.2\",\"modelMatrix\":\"-0.902403,-0.430841,0.00671541,0,0.430893,-0.902293,0.0140638,0,6.22262e-11,0.0155848,0.999879,0,-22.2622,15.1263,-21.4595,1\",\"title\":\"Mandibule PLY\"}'),(2,'02452ad0-6e10-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02452ad0-6e10-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_69cc74d6-d976-48e9-8eec-693ff64095cf_SESS_448f3142-44dc-4a92-a676-47ac91eb67c2_TOSC_45db60dd-9c7b-4cc5-9fd6-15862341cd31_ZIP_','2022-01-05 10:00:30','2022-01-05 11:00:26','02452ad0-6e10-11ec-9377-226cec7cb58a.zip','2022-01-05 11:00:30','SYNCED','02452ad0-6e10-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.2.1.2\",\"modelMatrix\":\"0.848192,-0.466252,0.251356,0,0.529689,0.74661,-0.402496,0,-7.01461e-9,0.474535,0.880237,0,15.9947,-32.7287,-23.1213,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'02492cb5-6e10-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02492cb5-6e10-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_69cc74d6-d976-48e9-8eec-693ff64095cf_SESS_448f3142-44dc-4a92-a676-47ac91eb67c2_BOSC_7f372b8c-0d1b-4f52-951e-435466a35b56_SNAPS_','2022-01-05 10:11:55','2022-01-05 11:11:51','02492cb5-6e10-11ec-9377-226cec7cb58a.png','2022-01-05 11:11:55','SYNCED','02492cb5-6e10-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.2.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'024a447f-3ed2-48ab-80b0-d357a870d0d9','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/024a447f-3ed2-48ab-80b0-d357a870d0d9.ply','PLY','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_d53d56ca-d231-4a6a-8d20-8a01b8a7b21b_SESS_ccf1dc26-aa6a-4410-889e-08df94bce4dc_TOSC_85b2971b-787c-489e-96dc-863a8668618f_PLY_','2020-12-07 12:00:09','2020-08-25 15:00:42','024a447f-3ed2-48ab-80b0-d357a870d0d9.ply','2020-12-07 13:00:09','SYNCED','024a447f-3ed2-48ab-80b0-d357a870d0d9',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.26.63.1.1\",\"modelMatrix\":\"0.450725,-0.865923,0.216852,0,0.892663,0.437223,-0.109493,0,4.88383e-9,0.242927,0.970045,0,-4.46608,-34.8702,-15.4839,1\",\"title\":\"Maxillaire PLY\"}'),(2,'024d0ea3-6e10-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/024d0ea3-6e10-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_69cc74d6-d976-48e9-8eec-693ff64095cf_SESS_448f3142-44dc-4a92-a676-47ac91eb67c2_TOSC_02a6a3fe-d446-418e-902f-e354b32cf598_ZIP_','2022-01-05 10:03:28','2022-01-05 11:03:24','024d0ea3-6e10-11ec-9377-226cec7cb58a.zip','2022-01-05 11:03:28','SYNCED','024d0ea3-6e10-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.2.1.3\",\"modelMatrix\":\"0.776523,-0.575238,0.257125,0,0.630089,0.708925,-0.316881,0,-1.16617e-8,0.408077,0.912948,0,8.39088,-37.6162,-20.1499,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'024ec9a5-8769-437d-96ef-d19b70108b25','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/024ec9a5-8769-437d-96ef-d19b70108b25.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_d4795da6-b2be-4f2f-9538-c27ed33cf9e1_SESS_4db404f1-b42a-47d7-a023-3500473c2c18_BOSC_21e8d710-033c-4b4c-9d8a-2b4081b69cbc_PLY_','2021-04-27 14:19:47','2021-04-27 16:19:45','024ec9a5-8769-437d-96ef-d19b70108b25.ply','2021-04-27 16:19:47','SYNCED','024ec9a5-8769-437d-96ef-d19b70108b25',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.119.1.2\",\"modelMatrix\":\"-0.953105,-0.242695,0.180803,0,0.30264,-0.764321,0.569405,0,1.52064e-8,0.597421,0.801928,0,-20.4722,2.44338,-12.9017,1\",\"title\":\"Mandibule PLY\"}'),(2,'024f4642-7b0a-45ee-8035-c29a4f579c79','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/024f4642-7b0a-45ee-8035-c29a4f579c79.ply','PLY','PATIENT_692639c0-d4f6-4694-b258-abc36019cdc3_ACT_7caaa747-a460-4998-b323-219c8f4a3b0c_SESS_36d0dd98-7978-480f-b052-dac1660b428e_TOSC_46b605a9-3374-43cf-95ae-3916b27b02c5_PLY_','2020-12-08 17:24:52','2020-06-30 11:01:11','024f4642-7b0a-45ee-8035-c29a4f579c79.ply','2020-12-08 18:24:52','SYNCED','024f4642-7b0a-45ee-8035-c29a4f579c79',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.100.1.1\",\"modelMatrix\":\"0.565414,-0.781442,0.263921,0,0.824807,0.535687,-0.180921,0,1.09736e-9,0.319979,0.947425,0,-2.57761,-34.5484,-20.5066,1\",\"title\":\"Maxillaire PLY\"}'),(2,'024f5c1e-b31c-4b3c-a6f1-fe3355ae187c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/024f5c1e-b31c-4b3c-a6f1-fe3355ae187c.png','SNAPS','PATIENT_d092ea90-a92a-44ef-ab64-86b00ed2679d_ACT_0b3dc7d8-a1d6-472a-9a63-2fff5248f3ca_SESS_25fdbbaf-7212-464e-80d5-3b9c2e167114_BOSC_a07657f5-9587-42e7-9c4f-78b225655636_SNAPS_','2021-03-19 11:19:00','2021-03-19 12:13:49','024f5c1e-b31c-4b3c-a6f1-fe3355ae187c.png','2021-03-19 12:19:00','SYNCED','024f5c1e-b31c-4b3c-a6f1-fe3355ae187c',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.99.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'02510356-6e10-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02510356-6e10-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_69cc74d6-d976-48e9-8eec-693ff64095cf_SESS_448f3142-44dc-4a92-a676-47ac91eb67c2_BOSC_99ffd9d4-25f4-4da0-819a-a4174cab52f2_SNAPS_','2022-01-05 10:08:53','2022-01-05 11:08:50','02510356-6e10-11ec-9377-226cec7cb58a.png','2022-01-05 11:08:53','SYNCED','02510356-6e10-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.2.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'02593d3e-f3be-4730-8319-4ec709a53c4c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02593d3e-f3be-4730-8319-4ec709a53c4c.ply','PLY','PATIENT_a3acfcfe-5cd1-4929-8600-142a2ad8bb10_ACT_2cd3b6b9-8c95-49ab-8a65-a76cc56fbe1b_SESS_38c3c9b4-3a80-4815-9698-bbbc12583a97_TOSC_23223319-dae4-463f-9f04-d67af277d2c3_PLY_','2021-02-18 09:08:09','2021-02-18 09:45:13','02593d3e-f3be-4730-8319-4ec709a53c4c.ply','2021-02-18 10:08:09','SYNCED','02593d3e-f3be-4730-8319-4ec709a53c4c',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.47.1.2\",\"modelMatrix\":\"0.60877,-0.751667,0.253763,0,0.793346,0.576788,-0.194724,0,1.64235e-9,0.319864,0.947463,0,-1.78128,-37.4215,-19.7641,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0259c074-b4a6-44a6-886a-91ba6ae26428','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0259c074-b4a6-44a6-886a-91ba6ae26428.png','SNAPS','PATIENT_bfe2f5ef-b8ba-4b0d-9ad7-cbfc8fa83859_ACT_c0e69491-c418-41cd-8f0d-cf8648b2e12b_SESS_e0a28906-ad9e-45ae-820f-8947728fae2d_BOSC_fbe31048-5b1e-466d-8064-bf56e7c65cbc_SNAPS_','2021-01-11 12:54:18','2021-01-11 10:02:12','0259c074-b4a6-44a6-886a-91ba6ae26428.png','2021-01-11 13:54:18','SYNCED','0259c074-b4a6-44a6-886a-91ba6ae26428',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.72.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'025bdd04-e236-4915-848e-06f3e8232787','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/025bdd04-e236-4915-848e-06f3e8232787.ply','PLY','PATIENT_3ba502e6-1fd1-40ed-8e72-2db58e8c52bb_ACT_cffc8286-917f-47aa-b5d1-a282ed5c54bd_SESS_176febd5-da68-4715-802e-945c38e04419_BOSC_042f9c15-6e8b-4f7b-a4a0-9f2cc5d7cb2c_PLY_','2020-12-07 12:00:09','2020-07-29 09:29:43','025bdd04-e236-4915-848e-06f3e8232787.ply','2020-12-07 13:00:09','SYNCED','025bdd04-e236-4915-848e-06f3e8232787',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.29.1.1\",\"modelMatrix\":\"-0.881893,-0.4527,0.131631,0,0.471449,-0.846821,0.24623,0,-5.17587e-9,0.279206,0.960231,0,-19.5399,7.11183,-18.8401,1\",\"title\":\"Mandibule PLY\"}'),(2,'025c0a5f-f6a9-4196-996f-1a8240d030b2','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/025c0a5f-f6a9-4196-996f-1a8240d030b2.stl','STL','PATIENT_d1fbcf37-7232-4ed6-99e0-35ce505a6eed_ACT_1a9de72b-91ea-4ac2-a68d-1f48d60d3620_SESS_6cdfbecb-293c-4466-9415-108f9f941cde_TOSC_9c8388f2-53cf-4c6c-970a-22814a4166bd_STL_','2021-12-07 08:39:08','2019-09-10 09:52:45','025c0a5f-f6a9-4196-996f-1a8240d030b2.stl','2021-12-07 09:39:08','SYNCED','025c0a5f-f6a9-4196-996f-1a8240d030b2',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 149.1.1.1\",\"modelMatrix\":\"0.501696,-0.825919,0.257214,0,0.865044,0.479005,-0.149175,0,4.28886e-9,0.297342,0.954771,0,-2.56852,-36.3065,-16.0373,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'026319a2-46b6-44e1-85f7-b2c605bb0dc6','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/026319a2-46b6-44e1-85f7-b2c605bb0dc6.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_7e5aa64e-d017-4a70-970a-fe68db3e7c38_SESS_b9ea5d03-2206-42ef-8da3-4d72a97c7b00_TOSC_ff4b3fdf-95a5-45b5-894d-ac82fa231e4a_SNAPS_','2021-08-31 08:01:02','2021-08-31 10:01:00','026319a2-46b6-44e1-85f7-b2c605bb0dc6.png','2021-08-31 10:01:02','SYNCED','026319a2-46b6-44e1-85f7-b2c605bb0dc6',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.189.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'02631cd3-fd15-43b3-b466-681e05d02809','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02631cd3-fd15-43b3-b466-681e05d02809.png','SNAPS','PATIENT_0880e4ab-6c5d-4b3d-9c49-8064a77d5d3f_ACT_7afe7778-e5f3-4e25-9a55-35d809c89b51_SESS_32c67196-65ac-4a5b-8953-2160d87c6f98_TOSC_5f3a674e-652e-4215-b499-e54093d56b85_SNAPS_','2021-01-06 11:01:53','2019-12-12 14:17:37','02631cd3-fd15-43b3-b466-681e05d02809.png','2021-01-06 12:01:53','SYNCED','02631cd3-fd15-43b3-b466-681e05d02809',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 232.13.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'02707d3e-586a-45bc-8034-55f17379d6aa','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02707d3e-586a-45bc-8034-55f17379d6aa.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_f92ed3c4-058c-4b9e-9eb9-41aa4081126e_SESS_5ff81632-8afc-4443-ae0f-1722a0365361_TOSC_a7efaa70-1ea3-45f1-af54-66f01b5f1b87_PLY_','2021-04-26 09:12:16','2021-04-26 11:09:37','02707d3e-586a-45bc-8034-55f17379d6aa.ply','2021-04-26 11:12:16','SYNCED','97a8b402-4296-482a-9578-dddf814d3b04',1,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.100.1.2\",\"modelMatrix\":\"-0.293065,-0.918012,0.267146,0,0.956092,-0.281393,0.0818866,0,4.68555e-9,0.279414,0.960171,0,-21.2702,-14.1112,-18.1914,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0279a09f-6f3f-4f5d-a09f-d2c8b1f4ae88','','PLY','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_13648b48-b47d-4bcd-85a0-5211df734260_SESS_9a6d7c2c-addd-4900-a36e-a849376b43ad_BOSC_9fd88533-352d-4cca-9cb9-e5e1a2370af3_PLY_','2021-04-07 08:51:43','2021-04-07 10:51:38','','2021-04-07 10:51:43','SYNCED','0279a09f-6f3f-4f5d-a09f-d2c8b1f4ae88',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.10.1.2\",\"modelMatrix\":\"-0.996711,0.080539,-0.00895779,0,-0.0810356,-0.990603,0.110178,0,-4.52244e-10,0.110541,0.993872,0,30.877,12.2413,-16.2193,1\",\"title\":\"Mandibule PLY\"}'),(2,'027fe691-a73e-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/027fe691-a73e-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_54ef530e-fe95-453d-b6ca-fcf4e17dfdf6_SESS_1e5ae9d8-b0b0-4c65-992b-0f2fdad9ac99_TOSC_1d8dc494-6f8e-4d9c-9543-0a0c9aabad7a_SNAPS_','2021-04-27 09:40:58','2021-04-27 11:40:57','027fe691-a73e-11eb-9377-226cec7cb58a.png','2021-04-27 11:40:58','SYNCED','027fe691-a73e-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.113.1.4\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'02814746-b058-416a-b0f2-e858e7071c2d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02814746-b058-416a-b0f2-e858e7071c2d.ply','PLY','PATIENT_89c88118-827d-4c69-a01a-e71fa0de5341_ACT_2bcd6cff-7e33-484d-ae1f-14db83791ca8_SESS_cc616314-745e-4ae9-b1b7-4470a7570057_TOSC_b91f5e42-1586-44df-9091-bedc810494d0_PLY_','2020-12-23 09:07:12','2020-01-02 14:33:16','02814746-b058-416a-b0f2-e858e7071c2d.ply','2020-12-23 10:07:12','SYNCED','02814746-b058-416a-b0f2-e858e7071c2d',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"modelMatrix\":\"0.586986,-0.75518,0.291806,0,0.809597,0.547532,-0.211569,0,-9.01964e-9,0.360434,0.932785,0,2.01759,-30.6166,-20.1209,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0282cd14-3d65-4a52-a16c-9edfaa817e20','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0282cd14-3d65-4a52-a16c-9edfaa817e20.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_58c144fe-8c9c-4f63-9e0e-7b03219c004a_SESS_a4fc02e7-77ba-43ef-93e2-33b52eb59b18_BOSC_7e05faef-d603-4dab-9b67-7253e4a2969b_SNAPS_','2022-02-23 13:27:56','2022-02-23 14:27:53','0282cd14-3d65-4a52-a16c-9edfaa817e20.png','2022-02-23 14:27:56','SYNCED','0282cd14-3d65-4a52-a16c-9edfaa817e20',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.23.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0282dbf1-a73e-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0282dbf1-a73e-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_54ef530e-fe95-453d-b6ca-fcf4e17dfdf6_SESS_1e5ae9d8-b0b0-4c65-992b-0f2fdad9ac99_BOSC_31facbde-1c5d-4afe-b0f8-8d727f9f995e_SNAPS_','2021-04-27 09:50:11','2021-04-27 11:50:09','0282dbf1-a73e-11eb-9377-226cec7cb58a.png','2021-04-27 11:50:11','SYNCED','0282dbf1-a73e-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.113.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0283948d-6d1c-4a62-8608-b4ff1f8dcb3c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0283948d-6d1c-4a62-8608-b4ff1f8dcb3c.ply','PLY','PATIENT_21e550b9-3b4e-4a28-83a2-b7283f869d44_ACT_c3692735-3a6f-430f-8b82-587c85f133b2_SESS_0725d6a5-46dc-450b-abc0-879bcd3e5a78_TOSC_9ebc5b91-3541-4fdd-b5b9-dca8f1722134_PLY_','2020-12-08 17:24:53','2020-07-20 09:40:21','0283948d-6d1c-4a62-8608-b4ff1f8dcb3c.ply','2020-12-08 18:24:53','SYNCED','0283948d-6d1c-4a62-8608-b4ff1f8dcb3c',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.7.1.1\",\"modelMatrix\":\"0.793734,-0.555254,0.248352,0,0.608265,0.72456,-0.324079,0,9.99094e-9,0.408297,0.912849,0,7.13591,-30.5258,-19.4551,1\",\"title\":\"Maxillaire PLY\"}'),(2,'028560af-a73e-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/028560af-a73e-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_54ef530e-fe95-453d-b6ca-fcf4e17dfdf6_SESS_1e5ae9d8-b0b0-4c65-992b-0f2fdad9ac99_TOSC_348ee4b0-c969-4b48-a58f-289cedfcf12c_SNAPS_','2021-04-27 09:34:05','2021-04-27 11:34:04','028560af-a73e-11eb-9377-226cec7cb58a.png','2021-04-27 11:34:05','SYNCED','028560af-a73e-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.113.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0287eb33-a73e-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0287eb33-a73e-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_54ef530e-fe95-453d-b6ca-fcf4e17dfdf6_SESS_1e5ae9d8-b0b0-4c65-992b-0f2fdad9ac99_BOSC_4533333a-73d6-43bb-8bdb-f2e9dc9a28f3_SNAPS_','2021-04-27 09:46:06','2021-04-27 11:46:03','0287eb33-a73e-11eb-9377-226cec7cb58a.png','2021-04-27 11:46:06','SYNCED','0287eb33-a73e-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.113.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'028ddcb2-a73e-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/028ddcb2-a73e-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_54ef530e-fe95-453d-b6ca-fcf4e17dfdf6_SESS_1e5ae9d8-b0b0-4c65-992b-0f2fdad9ac99_TOSC_1d8dc494-6f8e-4d9c-9543-0a0c9aabad7a_PLY_','2021-04-27 09:40:58','2021-04-27 11:40:57','028ddcb2-a73e-11eb-9377-226cec7cb58a.ply','2021-04-27 11:40:58','SYNCED','028ddcb2-a73e-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.113.1.4\",\"modelMatrix\":\"0.370928,-0.87679,0.306025,0,0.928662,0.350209,-0.122233,0,-9.90255e-9,0.329533,0.944144,0,-6.87899,-37.3742,-15.8375,1\",\"title\":\"Maxillaire PLY\"}'),(2,'028e61ca-6ea1-40ad-93e8-ba63e8faa225','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/028e61ca-6ea1-40ad-93e8-ba63e8faa225.ply','PLY','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_BOSC_3d01b460-102f-4924-9743-d521a9112c5e_PLY_','2021-12-07 08:39:08','2019-11-15 14:02:46','028e61ca-6ea1-40ad-93e8-ba63e8faa225.ply','2021-12-07 09:39:08','SYNCED','028e61ca-6ea1-40ad-93e8-ba63e8faa225',0,NULL,'','','{\"displayTitle\":\"Mandibola 0\",\"modelMatrix\":\"-0.88619,0.453016,-0.0971796,0,-0.463322,-0.866478,0.185874,0,1.2747e-9,0.209745,0.977756,0,-6.68917,19.8563,-19.6101,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0290c313-a73e-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0290c313-a73e-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_54ef530e-fe95-453d-b6ca-fcf4e17dfdf6_SESS_1e5ae9d8-b0b0-4c65-992b-0f2fdad9ac99_BOSC_c6154eaf-0c06-4cbd-85c3-01e7f400c0e4_PLY_','2021-04-27 09:43:46','2021-04-27 11:43:44','0290c313-a73e-11eb-9377-226cec7cb58a.ply','2021-04-27 11:43:46','SYNCED','0290c313-a73e-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.113.1.1\",\"modelMatrix\":\"0.615761,-0.767141,0.179812,0,0.787933,0.599513,-0.140521,0,2.5389e-9,0.228207,0.973613,0,4.20359,-29.4081,-22.2737,1\",\"title\":\"Mandibule PLY\"}'),(2,'0293bc43-a73e-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0293bc43-a73e-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_54ef530e-fe95-453d-b6ca-fcf4e17dfdf6_SESS_1e5ae9d8-b0b0-4c65-992b-0f2fdad9ac99_TOSC_e5044b14-be44-4052-9639-648e0231e427_SNAPS_','2021-04-27 09:25:49','2021-04-27 11:25:48','0293bc43-a73e-11eb-9377-226cec7cb58a.png','2021-04-27 11:25:49','SYNCED','0293bc43-a73e-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.113.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0296abae-a73e-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0296abae-a73e-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_54ef530e-fe95-453d-b6ca-fcf4e17dfdf6_SESS_1e5ae9d8-b0b0-4c65-992b-0f2fdad9ac99_BOSC_31facbde-1c5d-4afe-b0f8-8d727f9f995e_PLY_','2021-04-27 09:50:12','2021-04-27 11:50:09','0296abae-a73e-11eb-9377-226cec7cb58a.ply','2021-04-27 11:50:12','SYNCED','0296abae-a73e-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.113.1.3\",\"modelMatrix\":\"0.375746,-0.913242,0.157494,0,0.926723,0.37028,-0.0638568,0,2.1321e-10,0.169947,0.985453,0,-11.713,-17.0927,-22.6856,1\",\"title\":\"Mandibule PLY\"}'),(2,'0299d0bb-a73e-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0299d0bb-a73e-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_54ef530e-fe95-453d-b6ca-fcf4e17dfdf6_SESS_1e5ae9d8-b0b0-4c65-992b-0f2fdad9ac99_BOSC_4533333a-73d6-43bb-8bdb-f2e9dc9a28f3_PLY_','2021-04-27 09:46:07','2021-04-27 11:46:03','0299d0bb-a73e-11eb-9377-226cec7cb58a.ply','2021-04-27 11:46:07','SYNCED','0299d0bb-a73e-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.113.1.2\",\"modelMatrix\":\"-0.576851,-0.808342,0.117582,0,0.816849,-0.570844,0.0830355,0,-4.13636e-9,0.143946,0.989586,0,-24.7497,-10.9781,-18.8445,1\",\"title\":\"Mandibule PLY\"}'),(2,'029e511c-a73e-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/029e511c-a73e-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_54ef530e-fe95-453d-b6ca-fcf4e17dfdf6_SESS_1e5ae9d8-b0b0-4c65-992b-0f2fdad9ac99_TOSC_e5044b14-be44-4052-9639-648e0231e427_PLY_','2021-04-27 09:25:50','2021-04-27 11:25:48','029e511c-a73e-11eb-9377-226cec7cb58a.ply','2021-04-27 11:25:50','SYNCED','029e511c-a73e-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.113.1.1\",\"modelMatrix\":\"0.724397,-0.61743,0.306642,0,0.689383,0.64879,-0.322216,0,-4.51618e-9,0.444806,0.895627,0,6.56648,-36.6097,-15.8068,1\",\"title\":\"Maxillaire PLY\"}'),(2,'02a0e260-e5bf-46ce-b9a4-88f5573e0717','','STL','PATIENT_28755122-fae1-4f95-b068-985d91181935_ACT_666c9397-f546-4de3-9c7b-9ecd62b9600e_SESS_d13984ab-a578-49fa-a6e0-ea9b2ecd3e86_TOSC_ec40cee1-48ab-4ec1-8dd8-c1f3dfddba2e_STL_','2021-12-07 08:39:08','2019-09-19 13:53:42','','2021-12-07 09:39:08','SYNCED','02a0e260-e5bf-46ce-b9a4-88f5573e0717',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 156.1.1.1\",\"modelMatrix\":\"0.440016,-0.817257,0.372126,0,0.89799,0.400456,-0.182342,0,1.76863e-9,0.414399,0.910095,0,-12.4219,-35.018,-18.1277,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'02a24a5e-62e3-466c-8b2c-5ef7bd7fe232','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02a24a5e-62e3-466c-8b2c-5ef7bd7fe232.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_841657c8-818e-4374-b5ec-175945e8d5f7_SESS_a0da55e3-a7da-4ebc-95a9-ce0da5574bd4_TOSC_368abae5-bea2-473f-b535-2b5adb15a198_PLY_','2021-04-26 14:11:17','2021-04-26 16:08:57','02a24a5e-62e3-466c-8b2c-5ef7bd7fe232.ply','2021-04-26 16:11:17','SYNCED','863383eb-4af0-4638-91dc-eb628c773248',1,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.108.1.1\",\"modelMatrix\":\"0.891524,-0.411037,0.19035,0,0.452973,0.808987,-0.37464,0,-9.43695e-9,0.420224,0.90742,0,15.7681,-30.1781,-9.10383,1\",\"title\":\"Maxillaire PLY\"}'),(2,'02a2bd35-a73e-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02a2bd35-a73e-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_54ef530e-fe95-453d-b6ca-fcf4e17dfdf6_SESS_1e5ae9d8-b0b0-4c65-992b-0f2fdad9ac99_TOSC_348ee4b0-c969-4b48-a58f-289cedfcf12c_PLY_','2021-04-27 09:34:06','2021-04-27 11:34:04','02a2bd35-a73e-11eb-9377-226cec7cb58a.ply','2021-04-27 11:34:06','SYNCED','02a2bd35-a73e-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.113.1.3\",\"modelMatrix\":\"0.772352,-0.544887,0.326453,0,0.635195,0.662543,-0.396943,0,-2.27415e-8,0.513941,0.857825,0,12.3787,-34.7362,-24.3479,1\",\"title\":\"Maxillaire PLY\"}'),(2,'02a6047c-0921-420d-9edb-36b8201b25f2','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02a6047c-0921-420d-9edb-36b8201b25f2.ply','PLY','PATIENT_2c31ad8e-22ad-441e-9c15-c34ef23d4519_ACT_e319cb73-6f62-4156-8701-64f342c4711e_SESS_df356414-5249-4c0a-a80c-c8031597086a_TOSC_5ba2bba1-a95a-4d62-9570-f28eeb93be5a_PLY_','2020-12-23 09:07:13','2019-12-31 12:04:33','02a6047c-0921-420d-9edb-36b8201b25f2.ply','2020-12-23 10:07:13','SYNCED','02a6047c-0921-420d-9edb-36b8201b25f2',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"modelMatrix\":\"0.39383,-0.903426,0.169465,0,0.919183,0.387079,-0.0726083,0,6.05217e-9,0.184364,0.982858,0,-5.61266,-37.8332,-12.0176,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'02a60cab-a73e-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02a60cab-a73e-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_54ef530e-fe95-453d-b6ca-fcf4e17dfdf6_SESS_1e5ae9d8-b0b0-4c65-992b-0f2fdad9ac99_BOSC_c6154eaf-0c06-4cbd-85c3-01e7f400c0e4_SNAPS_','2021-04-27 09:43:45','2021-04-27 11:43:44','02a60cab-a73e-11eb-9377-226cec7cb58a.png','2021-04-27 11:43:45','SYNCED','02a60cab-a73e-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.113.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'02a6ec68-f271-4ba4-baa3-8795401f86f3','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02a6ec68-f271-4ba4-baa3-8795401f86f3.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_80b318af-d67d-44d1-b260-7d411c065f0f_SESS_4b58d2d7-b749-4b44-a9a5-6caa8efd1fab_BOSC_a088b278-94f1-4068-83bb-8166baa4c10c_ZIP_','2022-03-23 14:40:11','2022-03-23 15:40:08','02a6ec68-f271-4ba4-baa3-8795401f86f3.zip','2022-03-23 15:40:11','SYNCED','02a6ec68-f271-4ba4-baa3-8795401f86f3',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.37.1.2\",\"modelMatrix\":\"-0.4741,-0.872098,0.121133,0,0.880471,-0.469592,0.0652256,0,1.52336e-09,0.137578,0.990491,0,-22.9091,-9.37537,-26.2562,1\",\"title\":\"Mandibule ZIP\"}'),(2,'02a77634-6cdc-4800-8694-0f262e960210','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02a77634-6cdc-4800-8694-0f262e960210.ply','PLY','PATIENT_f3e2711a-4a50-43c0-81ed-79aff7c7e3d9_ACT_249106b8-8e78-48ce-bb17-76612bb11c46_SESS_b11270a1-ab24-43c5-9863-edf1a7287b62_BOSC_9f85bdda-ea29-4d91-9258-6cee6b592767_PLY_','2021-08-05 07:30:36','2019-11-27 16:29:12','02a77634-6cdc-4800-8694-0f262e960210.ply','2021-08-05 09:30:36','SYNCED','02a77634-6cdc-4800-8694-0f262e960210',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 215.1.1.1\",\"modelMatrix\":\"-0.968845,0.241292,-0.0558279,0,-0.247667,-0.94391,0.218393,0,1.7506e-9,0.225415,0.974263,0,-9.94713,14.5908,-20.83,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'02b68124-ed2f-4697-83af-d7e4c87702cc','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02b68124-ed2f-4697-83af-d7e4c87702cc.stl','STL','PATIENT_1969ff5c-b071-4e17-bd50-2d86bc0b2bd0_ACT_f7bcfec5-5f8f-4f3d-967d-8810b57e2806_SESS_fa8a0221-3753-40a2-94ff-8934c2312429_BOSC_4c98422a-5015-4d09-be04-64925d568756_STL_','2021-12-07 08:39:08','2019-07-15 16:01:39','02b68124-ed2f-4697-83af-d7e4c87702cc.stl','2021-12-07 09:39:08','SYNCED','02b68124-ed2f-4697-83af-d7e4c87702cc',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 67.1.1.1\",\"modelMatrix\":\"-0.990578,0.129356,-0.0449653,0,-0.136948,-0.935661,0.325245,0,-4.06082e-9,0.328339,0.94456,0,-17.8969,15.7399,-24.9614,1\",\"title\":\"MANDIBULE STL\"}'),(2,'02c33ed2-443f-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02c33ed2-443f-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_b8905467-2e71-4779-bf51-94e66a47e3d5_ACT_6eae5d88-d0ca-4468-9daa-5a0f413d86b9_SESS_b15b868d-7cb1-47f7-ab0a-8d9fec9d4f75_TOSC_d0105e2f-8fc5-4727-a781-64e95f4045a1_PLY_','2020-12-16 10:51:15','2020-01-31 16:30:16','02c33ed2-443f-11ea-947d-226cec7cb58a.ply','2020-12-16 11:51:15','SYNCED','02c33ed2-443f-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"modelMatrix\":\"0.829413,-0.505608,0.237562,0,0.558637,0.75068,-0.35271,0,1.29213e-8,0.425253,0.905074,0,8.20583,-34.0391,-14.6529,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'02c595e7-443f-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02c595e7-443f-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_6eae5d88-d0ca-4468-9daa-5a0f413d86b9_SESS_b15b868d-7cb1-47f7-ab0a-8d9fec9d4f75_BOSC_ff44a32e-4ba1-4ada-8859-b02299c5ae80_PLY_','2020-12-16 10:51:15','2020-01-31 16:33:11','02c595e7-443f-11ea-947d-226cec7cb58a.ply','2020-12-16 11:51:15','SYNCED','02c595e7-443f-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"modelMatrix\":\"0.963003,-0.267113,0.035706,0,0.269489,0.954513,-0.127593,0,-1.21015e-9,0.132495,0.991184,0,4.97835,-20.0727,-26.9542,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'02c917a6-443f-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02c917a6-443f-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_b8905467-2e71-4779-bf51-94e66a47e3d5_ACT_6eae5d88-d0ca-4468-9daa-5a0f413d86b9_SESS_b15b868d-7cb1-47f7-ab0a-8d9fec9d4f75_TOSC_d0105e2f-8fc5-4727-a781-64e95f4045a1_SNAPS_','2020-12-16 10:51:15','2020-01-31 16:30:16','02c917a6-443f-11ea-947d-226cec7cb58a.png','2020-12-16 11:51:15','SYNCED','02c917a6-443f-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'02ca89d7-443f-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02ca89d7-443f-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_6eae5d88-d0ca-4468-9daa-5a0f413d86b9_SESS_b15b868d-7cb1-47f7-ab0a-8d9fec9d4f75_BOSC_ff44a32e-4ba1-4ada-8859-b02299c5ae80_SNAPS_','2020-12-16 10:51:15','2020-01-31 16:33:11','02ca89d7-443f-11ea-947d-226cec7cb58a.png','2020-12-16 11:51:15','SYNCED','02ca89d7-443f-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'02d47f3e-85b6-4966-b3db-20028be34168','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02d47f3e-85b6-4966-b3db-20028be34168.zip','ZIP','PATIENT_c5fc71e0-642a-48fb-8632-a1fa63c73346_ACT_64ab40c7-e0ce-490a-8b8b-f4c9733ac2f9_SESS_275168d2-b7b4-4de6-853f-8c55ca922b76_TOSC_f854bcf7-c78c-49df-ad4b-c7d2ef6599a8_ZIP_','2021-09-21 15:11:13','2021-09-21 17:11:10','02d47f3e-85b6-4966-b3db-20028be34168.zip','2021-09-21 17:11:13','SYNCED','02d47f3e-85b6-4966-b3db-20028be34168',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.361.128.1.1.2\",\"modelMatrix\":\"-0.82937,0.555583,-0.0589198,0,-0.558699,-0.824746,0.0874645,0,-7.01117e-10,0.105459,0.994424,0,-11.2208,-9.51309,-23.7279,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'02db7dc4-2300-4cd9-8d2d-d50c75f6ab7d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02db7dc4-2300-4cd9-8d2d-d50c75f6ab7d.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_d62da735-3cc1-4b05-b947-212a56506d14_SESS_cf9111fc-ad09-4292-92c8-97bd12dd863c_TOSC_596abc39-c9bf-4caa-baa5-eab64e7f8aab_SNAPS_','2022-01-05 15:11:51','2022-01-05 16:11:47','02db7dc4-2300-4cd9-8d2d-d50c75f6ab7d.png','2022-01-05 16:11:51','SYNCED','02db7dc4-2300-4cd9-8d2d-d50c75f6ab7d',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.7.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'02e30020-43b9-4c46-aba6-ba296164eb06','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02e30020-43b9-4c46-aba6-ba296164eb06.ply','PLY','PATIENT_65aec455-5850-4919-b33e-adf034461605_ACT_4db788cc-c25d-47f0-b487-2f1508ba00ba_SESS_73664137-22fd-4cd0-b83a-df3e14525b13_TOSC_64028690-18ed-4722-99d4-b9f4b7b03b37_PLY_','2020-11-25 14:45:37','2020-11-25 15:45:34','02e30020-43b9-4c46-aba6-ba296164eb06.ply','2020-11-25 15:45:37','SYNCED','02e30020-43b9-4c46-aba6-ba296164eb06',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.68.1.1.16\",\"modelMatrix\":\"0.632246,-0.739453,0.231245,0,0.774767,0.603428,-0.188707,0,-2.23813e-9,0.298471,0.954419,0,1.95022,-32.8319,-16.3806,1\",\"title\":\"Maxillaire PLY\"}'),(2,'02e4316e-9c4b-4e94-95c4-04866620eed2','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02e4316e-9c4b-4e94-95c4-04866620eed2.stl','STL','PATIENT_3dd35559-3891-4145-925d-2ca9ff021c92_ACT_3f91c745-f4b2-4db3-bf4a-7af2f4b090ed_SESS_1cdccc16-cfc5-47a6-a81f-5e3c5e4d5dec_TOSC_51300324-40f1-43a2-8068-12999ba32625_STL_','2021-12-07 08:39:09','2019-07-11 16:22:06','02e4316e-9c4b-4e94-95c4-04866620eed2.stl','2021-12-07 09:39:09','SYNCED','02e4316e-9c4b-4e94-95c4-04866620eed2',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 44.1.1.1\",\"modelMatrix\":\"0.827496,-0.544818,0.135734,0,0.561472,0.802952,-0.200045,0,-7.66774e-10,0.241747,0.970339,0,8.0114,-34.6695,-20.3847,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'02e6c1be-d1e7-43e2-a03c-402955622ed7','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02e6c1be-d1e7-43e2-a03c-402955622ed7.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_58c144fe-8c9c-4f63-9e0e-7b03219c004a_SESS_a4fc02e7-77ba-43ef-93e2-33b52eb59b18_TOSC_d192fa95-6ac5-40c2-acad-bd5f38a008d5_ZIP_','2022-02-23 13:10:40','2022-02-23 14:10:30','02e6c1be-d1e7-43e2-a03c-402955622ed7.zip','2022-02-23 14:10:40','SYNCED','02e6c1be-d1e7-43e2-a03c-402955622ed7',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.23.1.1\",\"modelMatrix\":\"0.623007,-0.750019,0.222112,0,0.782216,0.597363,-0.176904,0,2.57738e-09,0.283952,0.958839,0,6.67091,-35.1942,-16.5486,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'02ebe51e-d5c2-4d3a-85e9-392a10d43730','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02ebe51e-d5c2-4d3a-85e9-392a10d43730.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_2d9b5fe7-78b8-422d-a10f-cf3311e9f849_SESS_fcb1ba46-99ba-4c38-8a32-4d104102a9af_TOSC_35016ba1-a3f2-403c-9f4d-33dc754ae40f_SNAPS_','2022-01-05 12:37:24','2022-01-05 13:37:19','02ebe51e-d5c2-4d3a-85e9-392a10d43730.png','2022-01-05 13:37:24','SYNCED','02ebe51e-d5c2-4d3a-85e9-392a10d43730',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.4.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'02f7aea9-70c5-45d2-8fde-91480117fcfc','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02f7aea9-70c5-45d2-8fde-91480117fcfc.ply','PLY','PATIENT_f6b8f770-e3c3-495b-81be-6f92a2e90b58_ACT_ef9a71c5-5d5c-4f0e-ae3f-364b877cd1bc_SESS_b6e8b00a-7cef-4920-91e2-8d913070aa8c_TOSC_5b7d0cee-0f47-4ceb-8301-4e46bee37936_PLY_','2021-02-12 10:13:26','2021-02-12 10:55:16','02f7aea9-70c5-45d2-8fde-91480117fcfc.ply','2021-02-12 11:13:26','SYNCED','02f7aea9-70c5-45d2-8fde-91480117fcfc',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.38.1.2\",\"modelMatrix\":\"0.193737,-0.910893,0.364335,0,0.981054,0.179882,-0.0719483,0,-3.48732e-9,0.371371,0.928484,0,-13.8936,-32.5389,-15.96,1\",\"title\":\"Maxillaire PLY\"}'),(2,'02f90fac-ce62-4d12-9c6a-a9c20a8171dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02f90fac-ce62-4d12-9c6a-a9c20a8171dd.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_a22705a2-39a7-4ee0-914b-9c266eb48bb4_SESS_76bff937-78cb-46f1-a94e-49440d302ccf_BOSC_a0755c52-6a44-4bd2-817b-76e1ad6f43f2_PLY_','2021-08-13 07:31:23','2021-08-13 09:31:21','02f90fac-ce62-4d12-9c6a-a9c20a8171dd.ply','2021-08-13 09:31:23','SYNCED','02f90fac-ce62-4d12-9c6a-a9c20a8171dd',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.185.1.3\",\"modelMatrix\":\"-0.9975,-0.0705414,0.00424974,0,0.0706693,-0.995695,0.0599853,0,-4.15077e-10,0.0601356,0.99819,0,-17.8375,15.1076,-21.2449,1\",\"title\":\"Mandibule PLY\"}'),(2,'02fa9da3-63c7-43d7-a091-b01525868394','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/02fa9da3-63c7-43d7-a091-b01525868394.ply','PLY','PATIENT_65c10ac4-7d4a-4144-8ea2-8008ed2089e6_ACT_a811e5a3-b5e3-41e8-8b18-bd36921ff325_SESS_85e741ad-bf6f-4357-a3b5-3387b968ad37_BOSC_35106607-1852-4bc8-a496-ff33951f1a37_PLY_','2020-12-02 10:31:47','2020-11-16 09:29:19','02fa9da3-63c7-43d7-a091-b01525868394.ply','2020-12-02 11:31:47','SYNCED','02fa9da3-63c7-43d7-a091-b01525868394',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.21.1.1\",\"modelMatrix\":\"-0.971644,0.220675,-0.0849117,0,-0.236448,-0.906829,0.348931,0,2.34048e-9,0.359114,0.933294,0,-13.4163,17.2701,-18.9244,1\",\"title\":\"Mandibule PLY\"}'),(2,'030b5a43-c395-415c-b2fb-bfd86dc0a1f1','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/030b5a43-c395-415c-b2fb-bfd86dc0a1f1.ply','PLY','PATIENT_ccc00cdd-6862-49a0-a8b9-ec6471536e71_ACT_cbf6bad3-e84b-4487-b5ca-34461e4c29ab_SESS_2b2d2a2f-1f54-4773-8355-e1542edf294d_TOSC_bca4e258-fa03-4fdd-9a4b-c2f464de3696_PLY_','2022-03-04 13:40:21','2019-07-10 10:42:29','030b5a43-c395-415c-b2fb-bfd86dc0a1f1.ply','2022-03-04 14:40:21','SYNCED','030b5a43-c395-415c-b2fb-bfd86dc0a1f1',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 21.1.1.1\",\"modelMatrix\":\"0.744984,0.597525,-0.296585,0,-0.667082,0.667304,-0.33122,0,-1.11805e-9,0.4446,0.895729,0,-2.59196,-39.1301,-12.3044,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'031a5592-e432-4125-a98d-b194f5dc6c20','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/031a5592-e432-4125-a98d-b194f5dc6c20.ply','PLY','PATIENT_2ac72e33-091d-4649-96e8-f9bc99ea57c0_ACT_5bfbe4d6-7b72-41f4-b198-068789d9ff99_SESS_33193015-3738-487c-9c1b-d03f67cbb74e_BOSC_23ed6029-6896-45f3-a016-1da98e9d1892_PLY_','2021-01-26 09:44:28','2021-01-26 10:44:26','031a5592-e432-4125-a98d-b194f5dc6c20.ply','2021-01-26 10:44:28','SYNCED','031a5592-e432-4125-a98d-b194f5dc6c20',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.23.1.3\",\"modelMatrix\":\"-0.989681,0.133586,-0.0518331,0,-0.143289,-0.92266,0.358004,0,-3.45533e-10,0.361737,0.93228,0,-12.6493,15.6416,-18.3991,1\",\"title\":\"Mandibule PLY\"}'),(2,'031f830f-da1b-400d-8155-f04a50a62940','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/031f830f-da1b-400d-8155-f04a50a62940.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_809dd353-5e51-4fec-8bb1-1d58fff5cb3a_SESS_5fbd8442-5156-4124-9963-71c4d589d0c4_BOSC_e5fa819a-ad30-438d-9107-9c9ac89776a0_PLY_','2020-12-08 17:24:58','2020-07-10 10:30:18','031f830f-da1b-400d-8155-f04a50a62940.ply','2020-12-08 18:24:58','SYNCED','031f830f-da1b-400d-8155-f04a50a62940',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.129.1.1\",\"modelMatrix\":\"-0.998198,-0.0592297,0.00964542,0,0.0600099,-0.98522,0.160441,0,8.21993e-10,0.16073,0.986998,0,-17.5198,14.854,-23.567,1\",\"title\":\"Mandibule PLY\"}'),(2,'0329c5e5-1c5f-45f6-960d-f8e77f661165','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0329c5e5-1c5f-45f6-960d-f8e77f661165.png','SNAPS','PATIENT_fa5a6926-d741-45d2-a950-8a99ff95e665_ACT_9972bffd-d1d8-40b7-b0c0-980f096cbeae_SESS_cd629b65-77b1-4eaa-b23c-f841cb2ddd76_TOSC_dafae007-3c90-4e88-b092-a2bb18c421fa_SNAPS_','2020-12-29 08:56:34','2020-12-29 09:43:02','0329c5e5-1c5f-45f6-960d-f8e77f661165.png','2020-12-29 09:56:34','SYNCED','0329c5e5-1c5f-45f6-960d-f8e77f661165',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.36.49.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'032b8fee-9d6a-4a3e-8f71-6d2bdec5aa51','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/032b8fee-9d6a-4a3e-8f71-6d2bdec5aa51.ply','PLY','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_13648b48-b47d-4bcd-85a0-5211df734260_SESS_9a6d7c2c-addd-4900-a36e-a849376b43ad_BOSC_4ed89cbe-84b4-405e-8003-4aed365705dd_PLY_','2021-04-07 08:59:43','2021-04-07 10:59:42','032b8fee-9d6a-4a3e-8f71-6d2bdec5aa51.ply','2021-04-07 10:59:43','SYNCED','3cd3b9a7-dcd5-47c3-8ed6-a803b4135340',1,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.10.1.3\",\"modelMatrix\":\"-0.992327,0.123009,-0.0124737,0,-0.12364,-0.987264,0.100113,0,5.67271e-10,0.100887,0.994898,0,31.8603,8.88959,-19.4695,1\",\"title\":\"Mandibule PLY\"}'),(2,'032e23bc-b0f8-4425-8e57-aba08e903f67','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/032e23bc-b0f8-4425-8e57-aba08e903f67.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_06140603-23cb-4a53-811e-e71525830447_SESS_749f09e4-a715-4b27-aa2f-2debc4beab4a_TOSC_cb467059-21ce-498d-8995-b079af7e44c4_SNAPS_','2021-04-14 15:12:50','2021-04-14 17:12:49','032e23bc-b0f8-4425-8e57-aba08e903f67.png','2021-04-14 17:12:50','SYNCED','032e23bc-b0f8-4425-8e57-aba08e903f67',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.63.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0331f8b4-efb5-4595-9488-2e832194da4c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0331f8b4-efb5-4595-9488-2e832194da4c.ply','PLY','PATIENT_2e0a8247-f698-45b5-87fe-8b1e7c952f36_ACT_2093b149-d159-4a7d-93f3-2496bed2b973_SESS_88cb1b33-3ac7-4233-bfd7-abadfde43d9b_BOSC_6cd7e07d-264f-4e92-8900-ba12b21ba9f7_PLY_','2020-12-02 10:31:47','2020-10-30 11:50:43','0331f8b4-efb5-4595-9488-2e832194da4c.ply','2020-12-02 11:31:47','SYNCED','0331f8b4-efb5-4595-9488-2e832194da4c',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.35.13.1.2\",\"modelMatrix\":\"-0.908463,-0.388949,0.153019,0,0.417966,-0.845392,0.332591,0,2.59502e-9,0.366103,0.930574,0,-18.1142,5.79776,-20.7719,1\",\"title\":\"Mandibule PLY\"}'),(2,'03374e91-b842-46f6-9177-76e731f02a2d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03374e91-b842-46f6-9177-76e731f02a2d.ply','PLY','PATIENT_53100b02-c94b-47bc-8b64-ebba6073de50_ACT_8464161e-f420-42dd-97a7-8d8a43e0d890_SESS_24b4b44e-82d8-423d-a1e9-3be90a46aad3_TOSC_f4706931-83dd-4c85-aba6-b8279066b046_PLY_','2020-12-08 17:24:58','2020-06-17 11:37:38','03374e91-b842-46f6-9177-76e731f02a2d.ply','2020-12-08 18:24:58','SYNCED','03374e91-b842-46f6-9177-76e731f02a2d',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.50.1.1\",\"modelMatrix\":\"0.386935,-0.884941,0.259152,0,0.922107,0.37134,-0.108746,0,-6.18261e-9,0.281044,0.959695,0,-8.83839,-30.6419,-16.7318,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0337f521-0177-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0337f521-0177-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_4196aec4-665a-43ec-823c-c46b273b499c_ACT_4fea5157-9778-4ede-818a-ed0fde944998_SESS_55cdee94-4e99-4007-9e55-e77ae266154e_TOSC_b44b6acf-5ee7-4d6e-8471-b71e5b40cd8a_SNAPS_','2021-12-07 08:39:10','2019-11-07 16:50:46','0337f521-0177-11ea-947d-226cec7cb58a.png','2021-12-07 09:39:10','SYNCED','0337f521-0177-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.27.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'03398035-0177-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03398035-0177-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_4196aec4-665a-43ec-823c-c46b273b499c_ACT_4fea5157-9778-4ede-818a-ed0fde944998_SESS_55cdee94-4e99-4007-9e55-e77ae266154e_BOSC_967d5eed-a778-4446-ab11-1947eaaee7fa_SNAPS_','2021-12-07 08:39:10','2019-11-07 16:55:09','03398035-0177-11ea-947d-226cec7cb58a.png','2021-12-07 09:39:10','SYNCED','03398035-0177-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.27.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0339edda-c73f-45a8-b7b2-45272e39dc7b','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0339edda-c73f-45a8-b7b2-45272e39dc7b.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_6b1515ab-7ae8-43fc-93e5-c06097ffda7b_SESS_6104ffbc-5b1c-4db6-920e-9c035b702344_BOSC_2e2570ad-5817-425b-a3f5-76a414449d02_SNAPS_','2021-07-22 07:33:36','2021-07-22 09:33:35','0339edda-c73f-45a8-b7b2-45272e39dc7b.png','2021-07-22 09:33:36','SYNCED','0339edda-c73f-45a8-b7b2-45272e39dc7b',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.175.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'033afab2-0177-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/033afab2-0177-11ea-947d-226cec7cb58a.stl','STL','PATIENT_4196aec4-665a-43ec-823c-c46b273b499c_ACT_4fea5157-9778-4ede-818a-ed0fde944998_SESS_55cdee94-4e99-4007-9e55-e77ae266154e_TOSC_b44b6acf-5ee7-4d6e-8471-b71e5b40cd8a_STL_','2021-12-07 08:39:10','2019-11-07 16:50:46','033afab2-0177-11ea-947d-226cec7cb58a.stl','2021-12-07 09:39:10','SYNCED','033afab2-0177-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.27.1.1\",\"modelMatrix\":\"-0.197011,-0.964941,0.173423,0,0.980401,-0.193904,0.0348493,0,-2.98387e-9,0.17689,0.984231,0,-21.0383,-19.6249,-19.194,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'033c5308-0177-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/033c5308-0177-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_4196aec4-665a-43ec-823c-c46b273b499c_ACT_4fea5157-9778-4ede-818a-ed0fde944998_SESS_55cdee94-4e99-4007-9e55-e77ae266154e_BOSC_967d5eed-a778-4446-ab11-1947eaaee7fa_PLY_','2021-12-07 08:39:10','2019-11-07 16:55:09','033c5308-0177-11ea-947d-226cec7cb58a.ply','2021-12-07 09:39:10','SYNCED','033c5308-0177-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.27.1.1\",\"modelMatrix\":\"-0.8845,0.436467,-0.164789,0,-0.46654,-0.827487,0.312419,0,2.07177e-9,0.353215,0.935542,0,-1.91759,19.8062,-21.4267,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'033dac0e-0177-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/033dac0e-0177-11ea-947d-226cec7cb58a.stl','STL','PATIENT_4196aec4-665a-43ec-823c-c46b273b499c_ACT_4fea5157-9778-4ede-818a-ed0fde944998_SESS_55cdee94-4e99-4007-9e55-e77ae266154e_BOSC_967d5eed-a778-4446-ab11-1947eaaee7fa_STL_','2021-12-07 08:39:10','2019-11-07 16:55:09','033dac0e-0177-11ea-947d-226cec7cb58a.stl','2021-12-07 09:39:10','SYNCED','033dac0e-0177-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.27.1.1\",\"modelMatrix\":\"-0.8845,0.436467,-0.164789,0,-0.46654,-0.827487,0.312419,0,2.07177e-9,0.353215,0.935542,0,-1.91759,19.8062,-21.4267,1\",\"title\":\"MANDIBULE STL\"}'),(2,'033f0f1a-0177-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/033f0f1a-0177-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_4196aec4-665a-43ec-823c-c46b273b499c_ACT_4fea5157-9778-4ede-818a-ed0fde944998_SESS_55cdee94-4e99-4007-9e55-e77ae266154e_TOSC_b44b6acf-5ee7-4d6e-8471-b71e5b40cd8a_PLY_','2021-12-07 08:39:10','2019-11-07 16:50:46','033f0f1a-0177-11ea-947d-226cec7cb58a.ply','2021-12-07 09:39:10','SYNCED','033f0f1a-0177-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.27.1.1\",\"modelMatrix\":\"-0.197011,-0.964941,0.173423,0,0.980401,-0.193904,0.0348493,0,-2.98387e-9,0.17689,0.984231,0,-21.0383,-19.6249,-19.194,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'033f6fc4-f385-400d-bba5-1761f305a6d6','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/033f6fc4-f385-400d-bba5-1761f305a6d6.ply','PLY','PATIENT_a915430b-c826-4613-83b7-d2eb7dfb9852_ACT_02adb446-2a26-4a1d-8b4d-b3200861026a_SESS_aad8dd1c-3c0b-4087-b086-7fd13483ea50_BOSC_a6cbebdd-c2ef-4000-84cb-4bdeb4fad978_PLY_','2021-09-20 13:48:13','2021-09-20 15:44:43','033f6fc4-f385-400d-bba5-1761f305a6d6.ply','2021-09-20 15:48:13','SYNCED','adae95fb-58a7-47c5-85fe-e58dbd8339fc',1,NULL,'','','{\"displayTitle\":\"Mandibule 22.400.1.1.2\",\"modelMatrix\":\"-0.868807,-0.476042,0.136228,0,0.495151,-0.835279,0.239029,0,3.0771e-9,0.275124,0.961409,0,-20.3426,7.58965,-19.13,1\",\"title\":\"Mandibule PLY\"}'),(2,'0342dd04-1062-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0342dd04-1062-11ea-947d-226cec7cb58a.stl','STL','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_fd694b3f-abde-4e46-91f7-7c62bfdcafa4_SESS_73a3f5b9-e905-4911-a163-2022e1de3380_TOSC_7e853b2b-25e6-4eb0-8bb9-1268c49445de_STL_','2021-08-05 07:30:38','2019-11-26 16:32:17','0342dd04-1062-11ea-947d-226cec7cb58a.stl','2021-08-05 09:30:38','SYNCED','0342dd04-1062-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"modelMatrix\":\"0.706199,-0.660159,0.255876,0,0.708014,0.658468,-0.25522,0,9.24341e-9,0.3614,0.932411,0,5.93232,-33.6673,-18.6426,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'034466e3-1062-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/034466e3-1062-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_fd694b3f-abde-4e46-91f7-7c62bfdcafa4_SESS_73a3f5b9-e905-4911-a163-2022e1de3380_TOSC_7e853b2b-25e6-4eb0-8bb9-1268c49445de_SNAPS_','2021-08-05 07:30:38','2019-11-26 16:32:17','034466e3-1062-11ea-947d-226cec7cb58a.png','2021-08-05 09:30:38','SYNCED','034466e3-1062-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0344a3fe-955d-4624-8a2a-f6a3401ce240','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0344a3fe-955d-4624-8a2a-f6a3401ce240.png','SNAPS','PATIENT_96afd601-d8c2-4e20-abec-292b75f99b16_ACT_1b95d362-259d-45d0-b12b-f82c49c26c12_SESS_812c317a-661f-4f64-916c-40d448feeca0_BOSC_9f368c08-fead-4763-876d-df309790e365_SNAPS_','2021-08-05 07:30:38','2019-12-05 15:38:54','0344a3fe-955d-4624-8a2a-f6a3401ce240.png','2021-08-05 09:30:38','SYNCED','0344a3fe-955d-4624-8a2a-f6a3401ce240',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 224.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0345f68d-1062-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0345f68d-1062-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_fd694b3f-abde-4e46-91f7-7c62bfdcafa4_SESS_73a3f5b9-e905-4911-a163-2022e1de3380_TOSC_7e853b2b-25e6-4eb0-8bb9-1268c49445de_PLY_','2021-08-05 07:30:38','2019-11-26 16:32:17','0345f68d-1062-11ea-947d-226cec7cb58a.ply','2021-08-05 09:30:38','SYNCED','0345f68d-1062-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"modelMatrix\":\"0.706199,-0.660159,0.255876,0,0.708014,0.658468,-0.25522,0,9.24341e-9,0.3614,0.932411,0,5.93232,-33.6673,-18.6426,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'034d06b8-7ba9-40ff-b74d-5772ee58d2b2','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/034d06b8-7ba9-40ff-b74d-5772ee58d2b2.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_dcea2419-687c-4fd2-bdc4-648efc507ebd_SESS_30bc559f-4455-43a2-b911-8ba645b91742_BOSC_8d745730-da6f-4ae3-9bec-f6cde3d4482c_PLY_','2020-12-16 10:51:18','2020-02-25 10:09:33','034d06b8-7ba9-40ff-b74d-5772ee58d2b2.ply','2020-12-16 11:51:18','SYNCED','034d06b8-7ba9-40ff-b74d-5772ee58d2b2',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"modelMatrix\":\"-0.771816,0.62585,-0.112307,0,-0.635846,-0.759681,0.136323,0,4.26647e-10,0.176627,0.984278,0,4.95209,18.4492,-14.5417,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'034e033e-4c10-43c9-9af2-287ec2a0d3a3','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/034e033e-4c10-43c9-9af2-287ec2a0d3a3.ply','PLY','PATIENT_72f539f4-2d06-47fa-b0b8-1291879a4818_ACT_d55baca2-6f09-4446-a148-dcdcfcaf57d8_SESS_5efdc987-8bdd-454f-b282-82efcf807bae_TOSC_c46ccd65-b88a-4797-a341-a681e8b71e58_PLY_','2021-08-05 07:30:38','2019-11-26 11:09:34','034e033e-4c10-43c9-9af2-287ec2a0d3a3.ply','2021-08-05 09:30:38','SYNCED','034e033e-4c10-43c9-9af2-287ec2a0d3a3',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 86.1.1.1.1\",\"modelMatrix\":\"0.717624,-0.654422,0.238218,0,0.696431,0.674336,-0.245467,0,-5.45333e-9,0.342056,0.93968,0,5.31256,-35.5973,-17.3929,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'034fd9bb-6566-4930-b469-67314b071791','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/034fd9bb-6566-4930-b469-67314b071791.stl','STL','PATIENT_1da4d746-be7d-4b76-83ab-ea0f893a037f_ACT_675a182e-b3d8-4879-885d-947de50cff0a_SESS_781a5087-c565-4f1b-95e2-54358316e8e3_BOSC_3086b448-bff8-4477-a088-31bb38c3dd89_STL_','2021-01-06 11:01:56','2019-12-13 09:37:48','034fd9bb-6566-4930-b469-67314b071791.stl','2021-01-06 12:01:56','SYNCED','034fd9bb-6566-4930-b469-67314b071791',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 232.18.1.1\",\"modelMatrix\":\"-0.942506,0.316866,-0.106197,0,-0.334189,-0.893652,0.299505,0,7.67262e-10,0.317775,0.948166,0,-6.417,23.0731,-15.4771,1\",\"title\":\"MANDIBULE STL\"}'),(2,'036045ee-1175-4e06-a413-65db2f4ea4f5','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/036045ee-1175-4e06-a413-65db2f4ea4f5.png','SNAPS','PATIENT_65aec455-5850-4919-b33e-adf034461605_ACT_4db788cc-c25d-47f0-b487-2f1508ba00ba_SESS_964bd77b-b063-4bda-8449-7b9e321e3779_BOSC_4b5a300b-764b-43f3-8e3e-2d0e93e6aa0d_SNAPS_','2020-11-26 09:38:11','2020-11-26 10:38:09','036045ee-1175-4e06-a413-65db2f4ea4f5.png','2020-11-26 10:38:11','SYNCED','036045ee-1175-4e06-a413-65db2f4ea4f5',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.68.1.2.18\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'03669af3-de65-4cf1-9129-2f2627737ae6','','PLY','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_bbcf9601-35a5-4e92-8051-508627f546f9_SESS_c6899cdb-16f1-41af-a8be-ece7a59af067_BOSC_d0d28b27-3fa4-4cd9-83f8-b93865a43eff_PLY_','2021-03-30 13:51:34','2021-03-30 15:51:33','','2021-03-30 15:51:34','SYNCED','03669af3-de65-4cf1-9129-2f2627737ae6',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.8.1.1\",\"modelMatrix\":\"-0.998671,0.0502218,-0.0115835,0,-0.0515403,-0.973122,0.224447,0,-1.35375e-10,0.224746,0.974417,0,29.0448,14.8918,-17.2889,1\",\"title\":\"Mandibule PLY\"}'),(2,'0378d7cb-9603-4d84-b4c4-7034c77e89f3','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0378d7cb-9603-4d84-b4c4-7034c77e89f3.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_b26acc56-a577-4417-999c-e42ddbe0f439_SESS_780d6204-201e-43a1-b2d8-ac1f6d770354_TOSC_eb33f189-0bc1-409b-a815-65e0a6ea03ad_SNAPS_','2021-04-07 13:48:29','2021-04-07 15:48:28','0378d7cb-9603-4d84-b4c4-7034c77e89f3.png','2021-04-07 15:48:29','SYNCED','0378d7cb-9603-4d84-b4c4-7034c77e89f3',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.3.18.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0385cb63-995e-11ec-94a4-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0385cb63-995e-11ec-94a4-9ec33d03e6dd.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_662f2eed-7229-4d2c-95b4-a921836cab63_SESS_a472767f-846b-4a2a-a470-e12044349f9d_TOSC_4a1135e1-e951-45aa-aab5-c8705927b6e2_ZIP_','2022-02-25 08:44:23','2022-02-25 09:44:16','0385cb63-995e-11ec-94a4-9ec33d03e6dd.zip','2022-02-25 09:44:23','SYNCED','0385cb63-995e-11ec-94a4-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.28.1.1\",\"modelMatrix\":\"0.717335,-0.658323,0.228126,0,0.696729,0.677793,-0.234873,0,3.49502e-09,0.327425,0.944877,0,9.19637,-36.2392,-14.7549,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'0385d212-b65a-4d27-a904-db6a140d03d7','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0385d212-b65a-4d27-a904-db6a140d03d7.png','SNAPS','PATIENT_86cf9c07-e5b3-42c7-9dc5-a35893bf96ff_ACT_e1c856ec-8779-4a27-81d8-1efe32d9844f_SESS_7c0138d5-1de3-4242-9ef7-4bca4877562b_TOSC_9923ee7c-ad25-4680-b8fb-caf7e3f4292f_SNAPS_','2021-03-24 12:36:45','2021-03-24 13:23:57','0385d212-b65a-4d27-a904-db6a140d03d7.png','2021-03-24 13:36:45','SYNCED','0385d212-b65a-4d27-a904-db6a140d03d7',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.114.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'038782bf-995e-11ec-94a4-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/038782bf-995e-11ec-94a4-9ec33d03e6dd.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_662f2eed-7229-4d2c-95b4-a921836cab63_SESS_a472767f-846b-4a2a-a470-e12044349f9d_TOSC_d0db079a-dd4c-4153-b7d0-cec87d4fc3cd_ZIP_','2022-03-01 11:09:38','2022-03-01 12:09:36','038782bf-995e-11ec-94a4-9ec33d03e6dd.zip','2022-03-01 12:09:38','SYNCED','038782bf-995e-11ec-94a4-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.28.1.2\",\"modelMatrix\":\"0.408573,-0.899205,0.156519,0,0.912726,0.40252,-0.070064,0,-4.60548e-09,0.171485,0.985187,0,-6.95177,-31.4789,-12.6239,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'038938c6-995e-11ec-94a4-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/038938c6-995e-11ec-94a4-9ec33d03e6dd.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_662f2eed-7229-4d2c-95b4-a921836cab63_SESS_a472767f-846b-4a2a-a470-e12044349f9d_BOSC_a1d08b8e-89bd-4187-959c-e1e65cfe24db_SNAPS_','2022-03-01 12:35:35','2022-03-01 13:35:31','038938c6-995e-11ec-94a4-9ec33d03e6dd.png','2022-03-01 13:35:35','SYNCED','038938c6-995e-11ec-94a4-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.28.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'038a636d-995e-11ec-94a4-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/038a636d-995e-11ec-94a4-9ec33d03e6dd.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_662f2eed-7229-4d2c-95b4-a921836cab63_SESS_a472767f-846b-4a2a-a470-e12044349f9d_BOSC_a1d08b8e-89bd-4187-959c-e1e65cfe24db_ZIP_','2022-03-01 12:35:34','2022-03-01 13:35:32','038a636d-995e-11ec-94a4-9ec33d03e6dd.zip','2022-03-01 13:35:34','SYNCED','038a636d-995e-11ec-94a4-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.28.1.1\",\"modelMatrix\":\"0.497831,-0.852523,0.159276,0,0.867274,0.489363,-0.0914271,0,-8.2905e-09,0.183651,0.982992,0,-5.07198,-21.9679,-26.7648,1\",\"title\":\"Mandibule ZIP\"}'),(2,'038b78d5-995e-11ec-94a4-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/038b78d5-995e-11ec-94a4-9ec33d03e6dd.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_662f2eed-7229-4d2c-95b4-a921836cab63_SESS_a472767f-846b-4a2a-a470-e12044349f9d_TOSC_d0db079a-dd4c-4153-b7d0-cec87d4fc3cd_SNAPS_','2022-03-01 11:09:38','2022-03-01 12:09:35','038b78d5-995e-11ec-94a4-9ec33d03e6dd.png','2022-03-01 12:09:38','SYNCED','038b78d5-995e-11ec-94a4-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.28.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'038c9792-995e-11ec-94a4-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/038c9792-995e-11ec-94a4-9ec33d03e6dd.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_662f2eed-7229-4d2c-95b4-a921836cab63_SESS_a472767f-846b-4a2a-a470-e12044349f9d_BOSC_8fa8a1d0-b7cf-4a00-bc92-8f6d983da3b5_ZIP_','2022-03-01 12:47:42','2022-03-01 13:47:39','038c9792-995e-11ec-94a4-9ec33d03e6dd.zip','2022-03-01 13:47:42','SYNCED','038c9792-995e-11ec-94a4-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.28.1.3\",\"modelMatrix\":\"-0.957674,-0.284119,0.046224,0,0.287855,-0.945246,0.153784,0,-6.66816e-09,0.160581,0.987023,0,-25.7123,9.48879,-21.8601,1\",\"title\":\"Mandibule ZIP\"}'),(2,'038d74e5-ead7-4cb1-91d2-6e4d990fac1c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/038d74e5-ead7-4cb1-91d2-6e4d990fac1c.png','SNAPS','PATIENT_3fae9447-e15b-4704-9907-1bf5e90f95dc_ACT_f9754ae5-b96b-4910-900e-5b70d2c7b9be_SESS_54470e11-bfb2-4144-9c34-70a077f1fb4f_TOSC_ad4f4efe-fe4a-46bd-a3d3-c82d4719c821_SNAPS_','2020-12-16 11:05:36','2020-01-22 15:30:10','038d74e5-ead7-4cb1-91d2-6e4d990fac1c.png','2020-12-16 12:05:36','SYNCED','038d74e5-ead7-4cb1-91d2-6e4d990fac1c',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'038daa77-1a33-4b91-8616-f465e1ff0ee0','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/038daa77-1a33-4b91-8616-f465e1ff0ee0.ply','PLY','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_b05e55da-a2aa-45bd-a260-fed7b7a6d00d_SESS_f4f98487-4310-4f4c-86d5-3ef8c90a5a92_BOSC_8d31c937-5ba6-4c4f-8177-009a38066430_PLY_','2020-12-07 12:00:15','2020-08-21 13:36:52','038daa77-1a33-4b91-8616-f465e1ff0ee0.ply','2020-12-07 13:00:15','SYNCED','038daa77-1a33-4b91-8616-f465e1ff0ee0',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.26.40.1.1\",\"modelMatrix\":\"-0.772369,0.634631,-0.026262,0,-0.635174,-0.771709,0.0319345,0,2.39979e-9,0.0413461,0.999145,0,-0.0586285,20.0238,-21.6193,1\",\"title\":\"Mandibule PLY\"}'),(2,'038dd620-995e-11ec-94a4-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/038dd620-995e-11ec-94a4-9ec33d03e6dd.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_662f2eed-7229-4d2c-95b4-a921836cab63_SESS_a472767f-846b-4a2a-a470-e12044349f9d_TOSC_0c42673b-8a35-4df5-bed1-0899213e8b89_ZIP_','2022-03-01 12:32:11','2022-03-01 13:32:08','038dd620-995e-11ec-94a4-9ec33d03e6dd.zip','2022-03-01 13:32:11','SYNCED','038dd620-995e-11ec-94a4-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.28.1.3\",\"modelMatrix\":\"-0.487018,-0.855951,0.173671,0,0.873392,-0.477293,0.096842,0,-4.29783e-09,0.198847,0.980031,0,-22.9039,-8.05158,-19.3283,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'038f0767-995e-11ec-94a4-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/038f0767-995e-11ec-94a4-9ec33d03e6dd.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_662f2eed-7229-4d2c-95b4-a921836cab63_SESS_a472767f-846b-4a2a-a470-e12044349f9d_TOSC_0c42673b-8a35-4df5-bed1-0899213e8b89_SNAPS_','2022-03-01 12:32:11','2022-03-01 13:32:07','038f0767-995e-11ec-94a4-9ec33d03e6dd.png','2022-03-01 13:32:11','SYNCED','038f0767-995e-11ec-94a4-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.28.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0390403b-995e-11ec-94a4-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0390403b-995e-11ec-94a4-9ec33d03e6dd.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_662f2eed-7229-4d2c-95b4-a921836cab63_SESS_a472767f-846b-4a2a-a470-e12044349f9d_BOSC_9e789b85-7034-4925-90b0-5a71733e1e40_ZIP_','2022-03-01 12:41:01','2022-03-01 13:40:59','0390403b-995e-11ec-94a4-9ec33d03e6dd.zip','2022-03-01 13:41:01','SYNCED','0390403b-995e-11ec-94a4-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.28.1.2\",\"modelMatrix\":\"-0.771899,-0.633169,0.0571717,0,0.635745,-0.768771,0.0694159,0,-2.23489e-10,0.0899287,0.995948,0,-19.3093,2.18037,-18.0909,1\",\"title\":\"Mandibule ZIP\"}'),(2,'0391a444-995e-11ec-94a4-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0391a444-995e-11ec-94a4-9ec33d03e6dd.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_662f2eed-7229-4d2c-95b4-a921836cab63_SESS_a472767f-846b-4a2a-a470-e12044349f9d_TOSC_4a1135e1-e951-45aa-aab5-c8705927b6e2_SNAPS_','2022-02-25 08:44:24','2022-02-25 09:44:15','0391a444-995e-11ec-94a4-9ec33d03e6dd.png','2022-02-25 09:44:24','SYNCED','0391a444-995e-11ec-94a4-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.28.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0392ec83-995e-11ec-94a4-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0392ec83-995e-11ec-94a4-9ec33d03e6dd.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_662f2eed-7229-4d2c-95b4-a921836cab63_SESS_a472767f-846b-4a2a-a470-e12044349f9d_BOSC_8fa8a1d0-b7cf-4a00-bc92-8f6d983da3b5_SNAPS_','2022-03-01 12:47:42','2022-03-01 13:47:38','0392ec83-995e-11ec-94a4-9ec33d03e6dd.png','2022-03-01 13:47:42','SYNCED','0392ec83-995e-11ec-94a4-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.28.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'03946a0f-995e-11ec-94a4-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03946a0f-995e-11ec-94a4-9ec33d03e6dd.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_662f2eed-7229-4d2c-95b4-a921836cab63_SESS_a472767f-846b-4a2a-a470-e12044349f9d_BOSC_9e789b85-7034-4925-90b0-5a71733e1e40_SNAPS_','2022-03-01 12:41:01','2022-03-01 13:40:58','03946a0f-995e-11ec-94a4-9ec33d03e6dd.png','2022-03-01 13:41:01','SYNCED','03946a0f-995e-11ec-94a4-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.28.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'03974bf9-1bf9-437a-bea2-c300d18e1b5f','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03974bf9-1bf9-437a-bea2-c300d18e1b5f.ply','PLY','PATIENT_196f3637-95c1-4658-beca-3c3b12c69741_ACT_0c1906ae-b137-4388-8a42-0ab9a792bdc7_SESS_0bb91c40-4a67-4087-911f-6c3fe2520568_BOSC_bdcd1830-7fd4-4395-a219-0df69bfdc468_PLY_','2020-12-02 10:31:33','2020-11-02 10:25:28','03974bf9-1bf9-437a-bea2-c300d18e1b5f.ply','2020-12-02 11:31:33','SYNCED','03974bf9-1bf9-437a-bea2-c300d18e1b5f',0,'2020-12-02 11:31:33','','','{\"displayTitle\":\"Mandibule 216.36.1.1.1\",\"modelMatrix\":\"0.637938,-0.75994,0.124605,0,0.770087,0.629532,-0.103223,0,-5.53639e-9,0.161807,0.986822,0,-2.29998,-20.2501,-18.7963,1\",\"title\":\"Mandibule PLY\"}'),(2,'03991044-160a-49b1-b013-2880aa408cb1','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03991044-160a-49b1-b013-2880aa408cb1.png','SNAPS','PATIENT_7999473e-e556-4557-832b-32238063b37a_ACT_f34901e5-54f1-492c-a4a2-44e130fbc20a_SESS_8648b8e9-7e51-4f6c-9088-9a7c72129004_TOSC_bfbd315e-e829-4a93-bd33-52d402fc8de3_SNAPS_','2020-12-16 11:05:36','2020-01-21 11:20:29','03991044-160a-49b1-b013-2880aa408cb1.png','2020-12-16 12:05:36','SYNCED','03991044-160a-49b1-b013-2880aa408cb1',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'03a3b3af-99bb-4dda-8987-8e72e798bd15','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03a3b3af-99bb-4dda-8987-8e72e798bd15.stl','STL','PATIENT_d4ea044b-3514-42f4-ae88-c9548bd72102_ACT_0a1e2259-cccc-4340-b89c-6e8977a2ad52_SESS_182b8b60-e273-40dd-805e-e07693857391_TOSC_83030167-26ca-4b08-8d8e-d25579056e48_STL_','2021-12-07 08:39:10','2019-09-03 11:21:50','03a3b3af-99bb-4dda-8987-8e72e798bd15.stl','2021-12-07 09:39:10','SYNCED','03a3b3af-99bb-4dda-8987-8e72e798bd15',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 141.1.1.1\",\"modelMatrix\":\"0.709399,-0.630954,0.314086,0,0.704807,0.635065,-0.316132,0,-1.15324e-8,0.445634,0.895215,0,5.20191,-38.0091,-16.2605,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'03a8257a-4fbf-4342-943e-9d75cfbec73a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03a8257a-4fbf-4342-943e-9d75cfbec73a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_96c001fd-4a17-407c-8805-99c83e400baa_SESS_083c6b3e-1523-4b0e-89d6-dacb191f73be_BOSC_761f74a6-4176-4b04-a93f-9ca5a6724c65_SNAPS_','2021-11-15 13:06:57','2021-11-15 14:06:53','03a8257a-4fbf-4342-943e-9d75cfbec73a.png','2021-11-15 14:06:57','SYNCED','03a8257a-4fbf-4342-943e-9d75cfbec73a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.210.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'03b26a68-3418-4a9b-8f1a-a6c7f2ac50ad','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03b26a68-3418-4a9b-8f1a-a6c7f2ac50ad.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_ea4a3a9b-6d56-4a52-9798-e58ef69a1c50_SESS_0e3e1f2d-82a0-48d6-9e58-92c43b556187_BOSC_82eb3191-7f7b-427c-a69b-bbce1ba4f36d_SNAPS_','2021-05-07 09:42:12','2021-05-07 11:42:11','03b26a68-3418-4a9b-8f1a-a6c7f2ac50ad.png','2021-05-07 11:42:12','SYNCED','03b26a68-3418-4a9b-8f1a-a6c7f2ac50ad',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.145.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'03bb76d0-5f38-41a5-a56d-592393136017','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03bb76d0-5f38-41a5-a56d-592393136017.stl','STL','PATIENT_67c10a45-b4ec-42ba-ae2c-900a195adb87_ACT_86b9837f-894c-450e-be34-50dce2fbdc92_SESS_11baa7ef-ca17-442b-a5da-1d859ce1c951_TOSC_ac047e44-8462-4977-a9f4-84b2517681ab_STL_','2021-12-07 08:39:11','2019-10-14 11:11:56','03bb76d0-5f38-41a5-a56d-592393136017.stl','2021-12-07 09:39:11','SYNCED','03bb76d0-5f38-41a5-a56d-592393136017',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.19.1.1\",\"modelMatrix\":\"0.534199,-0.8234,0.191423,0,0.845359,0.520323,-0.120964,0,9.34479e-10,0.22644,0.974025,0,-3.96586,-29.2976,-17.9656,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'03c804f6-d717-45f5-8e9e-af1b23da7fa5','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03c804f6-d717-45f5-8e9e-af1b23da7fa5.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_835f7e4d-6a54-4e10-a33e-739e6cd229a8_SESS_945ba64a-8904-4998-958d-23ad1abc6f43_BOSC_bcc549da-2b2a-4cfa-974a-4cffc14a68a9_SNAPS_','2021-09-30 11:53:27','2021-09-30 13:53:22','03c804f6-d717-45f5-8e9e-af1b23da7fa5.png','2021-09-30 13:53:27','SYNCED','03c804f6-d717-45f5-8e9e-af1b23da7fa5',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.22.35.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'03c94c70-77f5-4035-9fd6-b9c627d7d233','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03c94c70-77f5-4035-9fd6-b9c627d7d233.ply','PLY','PATIENT_d057767a-48b8-47b4-b560-db225cf00938_ACT_c3fa7e61-3ce9-4cee-851c-8ac67b865e76_SESS_c9e83e51-62fb-483a-af48-a6e75bc9093a_TOSC_30c24f2e-ae7b-48f0-a01d-39798dfca852_PLY_','2020-12-08 17:25:04','2020-06-05 09:43:01','03c94c70-77f5-4035-9fd6-b9c627d7d233.ply','2020-12-08 18:25:04','SYNCED','03c94c70-77f5-4035-9fd6-b9c627d7d233',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.19.1.1\",\"modelMatrix\":\"0.853389,-0.463184,0.239139,0,0.521274,0.758288,-0.391499,0,5.00323e-9,0.458759,0.888561,0,10.6874,-29.9189,-21.418,1\",\"title\":\"Maxillaire PLY\"}'),(2,'03c9a6db-d1a9-4d4f-a7bb-fd13ed40e2c2','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03c9a6db-d1a9-4d4f-a7bb-fd13ed40e2c2.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_fc01947f-e3b0-40f5-9997-e421a1d3d41a_SESS_2d7b9447-91f6-49df-acc2-4e816ea369dc_BOSC_bfb85153-3967-45fb-afd1-ba7ab9980a3b_SNAPS_','2021-04-26 12:47:38','2021-04-26 14:47:36','03c9a6db-d1a9-4d4f-a7bb-fd13ed40e2c2.png','2021-04-26 14:47:38','SYNCED','03c9a6db-d1a9-4d4f-a7bb-fd13ed40e2c2',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.105.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'03d0117e-3130-4bbe-8bb3-336b2831f77a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03d0117e-3130-4bbe-8bb3-336b2831f77a.png','SNAPS','PATIENT_7fcdb9e0-636c-4d7e-b8af-e3ce69be84ce_ACT_16bd83ca-3f07-4021-80cc-302935ee3226_SESS_3ade4a4b-4a11-440c-8f17-176f1f9542ed_BOSC_20e24c2c-6e01-442a-9367-5b5485e0f99f_SNAPS_','2021-12-07 08:39:11','2019-10-25 10:30:05','03d0117e-3130-4bbe-8bb3-336b2831f77a.png','2021-12-07 09:39:11','SYNCED','03d0117e-3130-4bbe-8bb3-336b2831f77a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 195.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'03dcfe70-04a6-4674-b685-96769dbd71fb','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03dcfe70-04a6-4674-b685-96769dbd71fb.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_927475bb-2147-4e4c-806a-caf515453040_SESS_14f4370e-54b4-45d6-91f8-6d4dffa99c1f_BOSC_c98d3490-6269-4400-8150-94f7cc8a0471_PLY_','2020-12-08 17:25:05','2020-07-08 09:57:47','03dcfe70-04a6-4674-b685-96769dbd71fb.ply','2020-12-08 18:25:05','SYNCED','03dcfe70-04a6-4674-b685-96769dbd71fb',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.123.1.1\",\"modelMatrix\":\"-0.994986,-0.0934516,0.0356238,0,0.100011,-0.929726,0.354412,0,1.10039e-9,0.356198,0.93441,0,-11.5404,15.4921,-19.6611,1\",\"title\":\"Mandibule PLY\"}'),(2,'03dd200a-296b-45cc-86d0-5edc592674b2','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03dd200a-296b-45cc-86d0-5edc592674b2.png','SNAPS','PATIENT_a28124a5-5a15-49be-8b28-d3f28826653d_ACT_2c77a989-d1c0-4ddd-9485-05e6e6e906cf_SESS_289ef78d-71de-454c-ab79-4baea1efb016_BOSC_2d153d35-a953-4a8b-841a-ff2021ef5289_SNAPS_','2022-03-04 13:40:21','2019-07-10 16:45:53','03dd200a-296b-45cc-86d0-5edc592674b2.png','2022-03-04 14:40:21','SYNCED','03dd200a-296b-45cc-86d0-5edc592674b2',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 30.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'03de6717-b600-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03de6717-b600-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_d4f9fa0a-dbee-45fc-9280-0b8369c4b8f0_ACT_e1dd1d25-014a-484e-a179-9cab342b2081_SESS_420541a1-e514-40a2-aecc-ad0115afbaf0_BOSC_939cdabf-be56-4797-902d-ca98528c14b9_PLY_','2020-12-08 17:25:06','2020-06-24 11:46:28','03de6717-b600-11ea-947d-226cec7cb58a.ply','2020-12-08 18:25:06','SYNCED','03de6717-b600-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 32.3.10.1.1\",\"modelMatrix\":\"-0.145036,0.987285,-0.0650661,0,-0.989426,-0.144722,0.0095378,0,-9.77693e-10,0.0657614,0.997835,0,16.535,10.1018,-18.201,1\",\"title\":\"Mandibule PLY\"}'),(2,'03df81e0-f0c5-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03df81e0-f0c5-11e9-947d-226cec7cb58a.stl','STL','PATIENT_a129d44a-65d0-4ac1-a000-e9b31e66968b_ACT_5787cc1a-6794-4c24-ae9e-643e33ebe9f5_SESS_f3211a9e-3be7-4908-9f34-f373542de71a_TOSC_729bc0f7-9290-41ee-b4eb-003d98543423_STL_','2021-12-07 08:39:11','2019-10-17 11:57:02','03df81e0-f0c5-11e9-947d-226cec7cb58a.stl','2021-12-07 09:39:11','SYNCED','03df81e0-f0c5-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 190.1.1.1\",\"modelMatrix\":\"0.464407,-0.815054,0.346429,0,0.885622,0.427403,-0.181662,0,-2.60889e-9,0.39117,0.920318,0,-5.51707,-31.5894,-22.9935,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'03e12e47-b600-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03e12e47-b600-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_d4f9fa0a-dbee-45fc-9280-0b8369c4b8f0_ACT_e1dd1d25-014a-484e-a179-9cab342b2081_SESS_420541a1-e514-40a2-aecc-ad0115afbaf0_BOSC_939cdabf-be56-4797-902d-ca98528c14b9_SNAPS_','2020-12-08 17:25:06','2020-06-24 11:46:28','03e12e47-b600-11ea-947d-226cec7cb58a.png','2020-12-08 18:25:06','SYNCED','03e12e47-b600-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 32.3.10.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'03e1445a-f0c5-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03e1445a-f0c5-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_a129d44a-65d0-4ac1-a000-e9b31e66968b_ACT_5787cc1a-6794-4c24-ae9e-643e33ebe9f5_SESS_f3211a9e-3be7-4908-9f34-f373542de71a_TOSC_729bc0f7-9290-41ee-b4eb-003d98543423_PLY_','2021-12-07 08:39:11','2019-10-17 11:57:02','03e1445a-f0c5-11e9-947d-226cec7cb58a.ply','2021-12-07 09:39:11','SYNCED','03e1445a-f0c5-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 190.1.1.1\",\"modelMatrix\":\"0.464407,-0.815054,0.346429,0,0.885622,0.427403,-0.181662,0,-2.60889e-9,0.39117,0.920318,0,-5.51707,-31.5894,-22.9935,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'03e2a61f-f0c5-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03e2a61f-f0c5-11e9-947d-226cec7cb58a.stl','STL','PATIENT_a129d44a-65d0-4ac1-a000-e9b31e66968b_ACT_5787cc1a-6794-4c24-ae9e-643e33ebe9f5_SESS_f3211a9e-3be7-4908-9f34-f373542de71a_BOSC_b3edb1d0-8d9f-4ca2-8489-d8be05f5d777_STL_','2021-12-07 08:39:11','2019-10-17 12:00:40','03e2a61f-f0c5-11e9-947d-226cec7cb58a.stl','2021-12-07 09:39:11','SYNCED','03e2a61f-f0c5-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 190.1.1.1\",\"modelMatrix\":\"-0.309364,0.927218,-0.211095,0,-0.950944,-0.301645,0.0686741,0,-1.17902e-9,0.221985,0.97505,0,11.5286,16.0503,-13.2994,1\",\"title\":\"MANDIBULE STL\"}'),(2,'03e341be-b600-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03e341be-b600-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_ca59e41d-e3d5-47c9-a4f6-0e35dc47d61f_ACT_e1dd1d25-014a-484e-a179-9cab342b2081_SESS_420541a1-e514-40a2-aecc-ad0115afbaf0_TOSC_1ca05080-de19-43b6-92b3-1749aebf8c0f_PLY_','2020-12-08 17:25:07','2020-06-24 11:36:14','03e341be-b600-11ea-947d-226cec7cb58a.ply','2020-12-08 18:25:07','SYNCED','03e341be-b600-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 32.3.10.1.1\",\"modelMatrix\":\"0.698767,-0.681484,0.217494,0,0.715349,0.665687,-0.212453,0,4.63226e-9,0.30404,0.952659,0,3.18304,-37.558,-15.9886,1\",\"title\":\"Maxillaire PLY\"}'),(2,'03e44672-f0c5-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03e44672-f0c5-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_a129d44a-65d0-4ac1-a000-e9b31e66968b_ACT_5787cc1a-6794-4c24-ae9e-643e33ebe9f5_SESS_f3211a9e-3be7-4908-9f34-f373542de71a_BOSC_b3edb1d0-8d9f-4ca2-8489-d8be05f5d777_SNAPS_','2021-12-07 08:39:11','2019-10-17 12:00:40','03e44672-f0c5-11e9-947d-226cec7cb58a.png','2021-12-07 09:39:11','SYNCED','03e44672-f0c5-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 190.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'03e53563-b600-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03e53563-b600-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_ca59e41d-e3d5-47c9-a4f6-0e35dc47d61f_ACT_e1dd1d25-014a-484e-a179-9cab342b2081_SESS_420541a1-e514-40a2-aecc-ad0115afbaf0_TOSC_1ca05080-de19-43b6-92b3-1749aebf8c0f_SNAPS_','2020-12-08 17:25:08','2020-06-24 11:36:14','03e53563-b600-11ea-947d-226cec7cb58a.png','2020-12-08 18:25:08','SYNCED','03e53563-b600-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 32.3.10.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'03e5ac51-f0c5-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03e5ac51-f0c5-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_a129d44a-65d0-4ac1-a000-e9b31e66968b_ACT_5787cc1a-6794-4c24-ae9e-643e33ebe9f5_SESS_f3211a9e-3be7-4908-9f34-f373542de71a_BOSC_b3edb1d0-8d9f-4ca2-8489-d8be05f5d777_PLY_','2021-12-07 08:39:11','2019-10-17 12:00:40','03e5ac51-f0c5-11e9-947d-226cec7cb58a.ply','2021-12-07 09:39:11','SYNCED','03e5ac51-f0c5-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 190.1.1.1\",\"modelMatrix\":\"-0.309364,0.927218,-0.211095,0,-0.950944,-0.301645,0.0686741,0,-1.17902e-9,0.221985,0.97505,0,11.5286,16.0503,-13.2994,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'03e74ea5-f0c5-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03e74ea5-f0c5-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_a129d44a-65d0-4ac1-a000-e9b31e66968b_ACT_5787cc1a-6794-4c24-ae9e-643e33ebe9f5_SESS_f3211a9e-3be7-4908-9f34-f373542de71a_TOSC_729bc0f7-9290-41ee-b4eb-003d98543423_SNAPS_','2021-12-07 08:39:11','2019-10-17 11:57:02','03e74ea5-f0c5-11e9-947d-226cec7cb58a.png','2021-12-07 09:39:11','SYNCED','03e74ea5-f0c5-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 190.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'03ed6046-2e4e-4598-a796-f96d619bee72','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03ed6046-2e4e-4598-a796-f96d619bee72.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_3d7227af-6070-46c5-943f-08a7bb6e1818_SESS_3b32b461-7193-46a6-a0e1-5a45287847a3_BOSC_7162e86c-b6bf-4ecd-a098-9e046369bbde_SNAPS_','2021-10-11 11:53:07','2021-10-11 13:53:03','03ed6046-2e4e-4598-a796-f96d619bee72.png','2021-10-11 13:53:07','SYNCED','03ed6046-2e4e-4598-a796-f96d619bee72',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.197.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'03f1e6c8-6a88-45de-86a0-5e5d7ca9f085','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03f1e6c8-6a88-45de-86a0-5e5d7ca9f085.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_19655c2d-7e57-4d56-ae6d-8ebe0a18278d_SESS_1817de76-2ba3-4628-8095-6d41ed293221_TOSC_1fb980a7-798d-4600-a28d-01ddb999d2b5_SNAPS_','2021-05-10 07:10:14','2021-05-10 09:10:13','03f1e6c8-6a88-45de-86a0-5e5d7ca9f085.png','2021-05-10 09:10:14','SYNCED','03f1e6c8-6a88-45de-86a0-5e5d7ca9f085',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.151.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'03f2ab2c-18c3-4e42-883f-6925bd3259e8','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03f2ab2c-18c3-4e42-883f-6925bd3259e8.ply','PLY','PATIENT_bfe2f5ef-b8ba-4b0d-9ad7-cbfc8fa83859_ACT_c0e69491-c418-41cd-8f0d-cf8648b2e12b_SESS_e0a28906-ad9e-45ae-820f-8947728fae2d_TOSC_ca29f1e6-88c2-4fbd-80bc-972f10b04f4f_PLY_','2021-01-11 12:54:18','2021-01-11 09:57:05','03f2ab2c-18c3-4e42-883f-6925bd3259e8.ply','2021-01-11 13:54:18','SYNCED','03f2ab2c-18c3-4e42-883f-6925bd3259e8',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.36.72.1.3\",\"modelMatrix\":\"0.931708,-0.35224,0.088585,0,0.363208,0.903572,-0.22724,0,1.03637e-9,0.243896,0.969801,0,14.0966,-30.011,-16.9836,1\",\"title\":\"Maxillaire PLY\"}'),(2,'03fe6582-6741-40d0-a4e3-ff8bd3ec634f','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/03fe6582-6741-40d0-a4e3-ff8bd3ec634f.png','SNAPS','PATIENT_5a36b509-d87e-4dda-807e-a616406aaa4c_ACT_285e7e26-b813-4dd7-84e7-f265f6e87fd6_SESS_7bf03134-a6b7-430c-ad8b-e85f04d49949_TOSC_fb2f0559-46a6-4056-899a-1d099977c044_SNAPS_','2022-03-22 09:33:50','2022-03-22 10:30:03','03fe6582-6741-40d0-a4e3-ff8bd3ec634f.png','2022-03-22 10:33:50','SYNCED','03fe6582-6741-40d0-a4e3-ff8bd3ec634f',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.412.1.1.6\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0404116f-91e9-4aad-a4e7-f62202b30f2c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0404116f-91e9-4aad-a4e7-f62202b30f2c.stl','STL','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_TOSC_2afbfc00-2e27-4ab9-a065-45aed0e6c370_STL_','2021-12-07 08:39:11','2019-11-14 13:43:03','0404116f-91e9-4aad-a4e7-f62202b30f2c.stl','2021-12-07 09:39:11','SYNCED','0404116f-91e9-4aad-a4e7-f62202b30f2c',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 202.1.1.1\",\"modelMatrix\":\"0.725705,-0.591258,0.351805,0,0.688006,0.623655,-0.371082,0,2.43361e-13,0.51134,0.859379,0,12.7041,-31.2192,-23.6108,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'0405004d-d904-4c16-bc68-1973a1576c85','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0405004d-d904-4c16-bc68-1973a1576c85.ply','PLY','PATIENT_df5cd3e3-f012-41db-937e-54f6102a7215_ACT_de0c93fe-463b-44c5-a3d4-058f2138bc94_SESS_0e0aba24-d37b-41e0-a159-d57412935ff8_BOSC_27984250-2b58-4874-9026-5e21a138804a_PLY_','2021-01-06 11:01:58','2019-12-12 14:08:41','0405004d-d904-4c16-bc68-1973a1576c85.ply','2021-01-06 12:01:58','SYNCED','0405004d-d904-4c16-bc68-1973a1576c85',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 232.12.1.1\",\"modelMatrix\":\"-0.978446,0.200348,-0.0500315,0,-0.2065,-0.949294,0.237061,0,5.4752e-9,0.242283,0.970206,0,-13.1689,16.8327,-20.9766,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'04073fe5-ee60-42f3-a1d0-7dd737fe0819','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04073fe5-ee60-42f3-a1d0-7dd737fe0819.png','SNAPS','PATIENT_616d49d3-a832-4fbb-b7a0-b899bb7635f2_ACT_6f85958d-4e32-4241-800b-3947d40ffb8a_SESS_35a8eb3f-9c5e-41a5-9f7c-9763bdbdf4cc_BOSC_d6a24d80-3ee5-4320-b70c-c1e195029072_SNAPS_','2020-12-29 15:15:59','2020-12-29 16:12:50','04073fe5-ee60-42f3-a1d0-7dd737fe0819.png','2020-12-29 16:15:59','SYNCED','04073fe5-ee60-42f3-a1d0-7dd737fe0819',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.57.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'040c10d2-0ec1-4f8c-a283-21c1c22c0d7c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/040c10d2-0ec1-4f8c-a283-21c1c22c0d7c.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_b4a79376-8645-457c-ab79-8cada0f59b2f_SESS_fc5a1184-f939-4a05-a5d1-f6a1859a789f_BOSC_4ef53d76-bb3e-44ba-92a5-570e643927f2_PLY_','2021-04-09 13:39:22','2021-04-09 15:37:23','040c10d2-0ec1-4f8c-a283-21c1c22c0d7c.ply','2021-04-09 15:39:22','SYNCED','c69ebb5c-4663-48f6-ae07-7b8321009e1c',1,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.49.1.1\",\"modelMatrix\":\"-0.915261,-0.388511,0.106568,0,0.402862,-0.882658,0.242112,0,-1.03526e-10,0.264528,0.964378,0,-17.3253,7.42328,-18.8417,1\",\"title\":\"Mandibule PLY\"}'),(2,'0415d2c2-a8c8-4edf-80f6-5fbf5d927ad1','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0415d2c2-a8c8-4edf-80f6-5fbf5d927ad1.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_662f2eed-7229-4d2c-95b4-a921836cab63_SESS_a472767f-846b-4a2a-a470-e12044349f9d_TOSC_4a1135e1-e951-45aa-aab5-c8705927b6e2_ZIP_','2022-02-25 08:44:23','2022-02-25 09:44:16','0415d2c2-a8c8-4edf-80f6-5fbf5d927ad1.zip','2022-02-25 09:44:23','SYNCED','0415d2c2-a8c8-4edf-80f6-5fbf5d927ad1',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.28.1.1\",\"modelMatrix\":\"0.717335,-0.658323,0.228126,0,0.696729,0.677793,-0.234873,0,3.49502e-09,0.327425,0.944877,0,9.19637,-36.2392,-14.7549,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'041a9380-0a78-443a-b03c-5fbea65d849c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/041a9380-0a78-443a-b03c-5fbea65d849c.png','SNAPS','PATIENT_5c1d1b29-e536-4d2c-beb8-8ede5f6132f3_ACT_1627ff2d-c6b2-459b-8c2b-83ca4f8bf83e_SESS_49c178ef-1ea0-4f30-b362-f3796c219e2f_TOSC_fa35c953-82a2-4e5e-969b-d0c8d10d3a8e_SNAPS_','2020-12-08 17:25:10','2020-06-24 09:10:23','041a9380-0a78-443a-b03c-5fbea65d849c.png','2020-12-08 18:25:10','SYNCED','041a9380-0a78-443a-b03c-5fbea65d849c',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.77.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'041b5616-71d7-4258-8dbe-ec7321954b88','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/041b5616-71d7-4258-8dbe-ec7321954b88.zip','ZIP','PATIENT_5a36b509-d87e-4dda-807e-a616406aaa4c_ACT_285e7e26-b813-4dd7-84e7-f265f6e87fd6_SESS_7bf03134-a6b7-430c-ad8b-e85f04d49949_TOSC_65c42b0e-01c3-4fc2-9067-ffc710d4de93_ZIP_','2022-03-22 09:59:11','2022-03-22 10:59:07','041b5616-71d7-4258-8dbe-ec7321954b88.zip','2022-03-22 10:59:11','SYNCED','041b5616-71d7-4258-8dbe-ec7321954b88',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.412.1.1.13\",\"modelMatrix\":\"0.812595,-0.515717,0.271524,0,0.582828,0.719026,-0.378566,0,4.16945e-09,0.465873,0.884852,0,11.977,-30.5649,-20.227,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'041c8a65-6c9d-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/041c8a65-6c9d-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_091298b7-bb6a-4d73-8330-9e1ffb78a173_ACT_17237e33-aae3-4912-bd0e-fb05236293e5_SESS_ce069186-0026-443f-8f06-571c4200cd09_TOSC_efe8b668-5e48-4fab-9bd4-9995dd4ea49f_SNAPS_','2022-01-03 13:38:22','2022-01-03 14:38:17','041c8a65-6c9d-11ec-9377-226cec7cb58a.png','2022-01-03 14:38:22','SYNCED','041c8a65-6c9d-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.167.4.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'041d5b11-6edf-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/041d5b11-6edf-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_bdd54078-e520-419a-9fac-96aa70ec8abb_SESS_11ec5091-732e-4d40-bf52-3ba352b66f63_BOSC_38bc4587-962e-46db-9e98-369892e462cb_SNAPS_','2022-01-06 10:53:52','2022-01-06 11:53:48','041d5b11-6edf-11ec-9377-226cec7cb58a.png','2022-01-06 11:53:52','SYNCED','041d5b11-6edf-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.11.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'04201853-6c9d-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04201853-6c9d-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_091298b7-bb6a-4d73-8330-9e1ffb78a173_ACT_17237e33-aae3-4912-bd0e-fb05236293e5_SESS_ce069186-0026-443f-8f06-571c4200cd09_BOSC_549f5a82-7c37-4960-bf20-017659688b6c_ZIP_','2022-01-03 13:48:39','2022-01-03 14:48:35','04201853-6c9d-11ec-9377-226cec7cb58a.zip','2022-01-03 14:48:39','SYNCED','04201853-6c9d-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.167.4.1.1\",\"modelMatrix\":\"0.448133,-0.887643,0.106144,0,0.893967,0.444963,-0.0532085,0,1.53749e-9,0.118734,0.992926,0,-8.13704,-18.6422,-28.02,1\",\"title\":\"Mandibule ZIP\"}'),(2,'04220326-6edf-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04220326-6edf-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_bdd54078-e520-419a-9fac-96aa70ec8abb_SESS_11ec5091-732e-4d40-bf52-3ba352b66f63_BOSC_38bc4587-962e-46db-9e98-369892e462cb_ZIP_','2022-01-06 10:53:52','2022-01-06 11:53:49','04220326-6edf-11ec-9377-226cec7cb58a.zip','2022-01-06 11:53:52','SYNCED','04220326-6edf-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.11.1.3\",\"modelMatrix\":\"-0.88446,-0.453983,0.107843,0,0.466616,-0.860514,0.204414,0,-3.16772e-9,0.231118,0.972926,0,-23.6007,7.00916,-17.161,1\",\"title\":\"Mandibule ZIP\"}'),(2,'0424ec47-41f2-486d-9f6a-513f1ec59d26','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0424ec47-41f2-486d-9f6a-513f1ec59d26.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_e67c44fa-320d-4cec-929c-0fac66b8a7ca_SESS_584f4de7-5dda-471a-8bd1-a202eb080ef8_TOSC_2ba7bd87-daec-4f84-8049-a1f5d84c1280_PLY_','2020-12-16 10:51:22','2020-02-12 15:10:21','0424ec47-41f2-486d-9f6a-513f1ec59d26.ply','2020-12-16 11:51:22','SYNCED','0424ec47-41f2-486d-9f6a-513f1ec59d26',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.3\",\"modelMatrix\":\"0.593925,-0.79189,0.141996,0,0.80452,0.584601,-0.104827,0,-5.06499e-9,0.176498,0.984301,0,-2.50945,-35.0588,-15.1893,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0425d26e-6edf-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0425d26e-6edf-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_bdd54078-e520-419a-9fac-96aa70ec8abb_SESS_11ec5091-732e-4d40-bf52-3ba352b66f63_TOSC_fe6ee21e-2c12-4071-83f6-10ddaea0fa37_SNAPS_','2022-01-06 10:48:01','2022-01-06 11:45:13','0425d26e-6edf-11ec-9377-226cec7cb58a.png','2022-01-06 11:48:01','SYNCED','0425d26e-6edf-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.11.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0425e73a-dfb3-49c8-aad7-4655160c94e0','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0425e73a-dfb3-49c8-aad7-4655160c94e0.png','SNAPS','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_06ede66b-fe62-4fae-adf6-cb0ad7e5eb0d_SESS_6b5b6f6d-0889-4a5a-9272-79df97f4a3b2_BOSC_250eaf91-0236-42a8-be74-add31ed4f999_SNAPS_','2020-12-16 11:05:39','2020-01-23 15:06:03','0425e73a-dfb3-49c8-aad7-4655160c94e0.png','2020-12-16 12:05:39','SYNCED','0425e73a-dfb3-49c8-aad7-4655160c94e0',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'04279aba-6c9d-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04279aba-6c9d-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_091298b7-bb6a-4d73-8330-9e1ffb78a173_ACT_17237e33-aae3-4912-bd0e-fb05236293e5_SESS_ce069186-0026-443f-8f06-571c4200cd09_TOSC_aa33da56-6fdf-42c5-b114-5b7ca0bab72d_SNAPS_','2022-01-03 13:45:30','2022-01-03 14:45:26','04279aba-6c9d-11ec-9377-226cec7cb58a.png','2022-01-03 14:45:30','SYNCED','04279aba-6c9d-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.167.4.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0429696f-6edf-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0429696f-6edf-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_bdd54078-e520-419a-9fac-96aa70ec8abb_SESS_11ec5091-732e-4d40-bf52-3ba352b66f63_TOSC_197f80b1-5e51-4946-8ea6-68a1581e4840_ZIP_','2022-01-06 09:05:07','2022-01-06 10:05:03','0429696f-6edf-11ec-9377-226cec7cb58a.zip','2022-01-06 10:05:07','SYNCED','0429696f-6edf-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.11.1.1\",\"modelMatrix\":\"0.854367,-0.446808,0.265369,0,0.519671,0.734576,-0.436281,0,-2.93726e-10,0.510648,0.85979,0,15.328,-33.0733,-19.4002,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'042b7384-6c9d-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/042b7384-6c9d-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_091298b7-bb6a-4d73-8330-9e1ffb78a173_ACT_17237e33-aae3-4912-bd0e-fb05236293e5_SESS_ce069186-0026-443f-8f06-571c4200cd09_BOSC_549f5a82-7c37-4960-bf20-017659688b6c_SNAPS_','2022-01-03 13:48:39','2022-01-03 14:48:34','042b7384-6c9d-11ec-9377-226cec7cb58a.png','2022-01-03 14:48:39','SYNCED','042b7384-6c9d-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.167.4.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'042c1a91-b423-412a-bec6-43da25eee13e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/042c1a91-b423-412a-bec6-43da25eee13e.png','SNAPS','PATIENT_c3200a0b-bb6f-47b9-a904-b694d5fcb884_ACT_e1b08a74-3216-4586-a7b2-25b9de6f9141_SESS_dc1ff7b1-44c9-4469-b9a0-4cecc95a3b61_TOSC_a659ad79-6963-4c59-b880-2823ce1357bf_SNAPS_','2021-03-26 12:48:13','2021-03-26 13:28:58','042c1a91-b423-412a-bec6-43da25eee13e.png','2021-03-26 13:48:13','SYNCED','042c1a91-b423-412a-bec6-43da25eee13e',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.2.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'042e2b11-6edf-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/042e2b11-6edf-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_bdd54078-e520-419a-9fac-96aa70ec8abb_SESS_11ec5091-732e-4d40-bf52-3ba352b66f63_BOSC_cfc660c1-8c74-4d30-a8cb-28ccb258cf9c_ZIP_','2022-01-06 10:48:03','2022-01-06 11:48:00','042e2b11-6edf-11ec-9377-226cec7cb58a.zip','2022-01-06 11:48:03','SYNCED','042e2b11-6edf-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.11.1.1\",\"modelMatrix\":\"0.107662,-0.978487,0.175987,0,0.994188,0.105962,-0.0190578,0,1.54188e-9,0.177016,0.984208,0,-7.0971,-20.148,-30.6075,1\",\"title\":\"Mandibule ZIP\"}'),(2,'04308099-ecbb-4116-8f76-f81146bc23b6','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04308099-ecbb-4116-8f76-f81146bc23b6.png','SNAPS','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_d2f7b7b4-32ff-450c-90d1-a5f55fa4b594_SESS_7a7679ff-68b2-4367-b7ea-cd532163d818_BOSC_9292d259-554f-400e-b12c-c0f437df6c89_SNAPS_','2020-12-16 11:05:39','2020-01-15 15:14:14','04308099-ecbb-4116-8f76-f81146bc23b6.png','2020-12-16 12:05:39','SYNCED','04308099-ecbb-4116-8f76-f81146bc23b6',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0433b0d5-6c9d-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0433b0d5-6c9d-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_091298b7-bb6a-4d73-8330-9e1ffb78a173_ACT_17237e33-aae3-4912-bd0e-fb05236293e5_SESS_ce069186-0026-443f-8f06-571c4200cd09_TOSC_2dfd0193-84d1-4feb-baab-cad4398f78d2_SNAPS_','2022-01-03 13:42:15','2022-01-03 14:42:09','0433b0d5-6c9d-11ec-9377-226cec7cb58a.png','2022-01-03 14:42:15','SYNCED','0433b0d5-6c9d-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.167.4.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0434713b-6edf-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0434713b-6edf-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_bdd54078-e520-419a-9fac-96aa70ec8abb_SESS_11ec5091-732e-4d40-bf52-3ba352b66f63_TOSC_e4bb8c30-edd1-4ef2-82d6-1252a38f03ad_ZIP_','2022-01-06 10:42:24','2022-01-06 11:42:21','0434713b-6edf-11ec-9377-226cec7cb58a.zip','2022-01-06 11:42:24','SYNCED','0434713b-6edf-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.11.1.2\",\"modelMatrix\":\"0.750974,-0.600577,0.274491,0,0.660332,0.683016,-0.31217,0,-1.89067e-9,0.415687,0.909508,0,8.8203,-37.4509,-16.8455,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'04349c48-e08a-4d7f-838b-7e8dc9b5483b','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04349c48-e08a-4d7f-838b-7e8dc9b5483b.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_f92ed3c4-058c-4b9e-9eb9-41aa4081126e_SESS_5ff81632-8afc-4443-ae0f-1722a0365361_BOSC_7d2ec63c-4378-41a0-b769-46932c028efd_PLY_','2021-04-26 09:17:12','2021-04-26 11:17:10','04349c48-e08a-4d7f-838b-7e8dc9b5483b.ply','2021-04-26 11:17:12','SYNCED','04349c48-e08a-4d7f-838b-7e8dc9b5483b',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.100.1.2\",\"modelMatrix\":\"-0.157468,-0.971931,0.174796,0,0.987524,-0.154982,0.0278725,0,-1.76181e-10,0.177004,0.98421,0,-21.8004,-18.4057,-24.4416,1\",\"title\":\"Mandibule PLY\"}'),(2,'04362805-097b-444d-94e1-ae1a5b306452','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04362805-097b-444d-94e1-ae1a5b306452.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_65f4a956-9ca2-478c-b6d0-2370f22d916d_SESS_cb0f6e65-f31f-4d56-a640-dac5c88ef39a_TOSC_45fe7a2e-b5ae-478c-b315-f4156b118567_SNAPS_','2022-03-08 15:39:39','2022-03-08 16:39:35','04362805-097b-444d-94e1-ae1a5b306452.png','2022-03-08 16:39:39','SYNCED','04362805-097b-444d-94e1-ae1a5b306452',0,NULL,'','','{\"displayTitle\":\"Maxilla 19.4.30.1.3\",\"title\":\"Maxilla SNAPSHOT\"}'),(2,'0437b031-6edf-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0437b031-6edf-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_bdd54078-e520-419a-9fac-96aa70ec8abb_SESS_11ec5091-732e-4d40-bf52-3ba352b66f63_TOSC_197f80b1-5e51-4946-8ea6-68a1581e4840_SNAPS_','2022-01-06 09:05:07','2022-01-06 10:05:02','0437b031-6edf-11ec-9377-226cec7cb58a.png','2022-01-06 10:05:07','SYNCED','0437b031-6edf-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.11.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0437f989-6c9d-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0437f989-6c9d-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_091298b7-bb6a-4d73-8330-9e1ffb78a173_ACT_17237e33-aae3-4912-bd0e-fb05236293e5_SESS_ce069186-0026-443f-8f06-571c4200cd09_BOSC_ef4e53ff-8dcd-43f2-bf9a-97b0c50ec733_SNAPS_','2022-01-03 13:51:55','2022-01-03 14:51:51','0437f989-6c9d-11ec-9377-226cec7cb58a.png','2022-01-03 14:51:55','SYNCED','0437f989-6c9d-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.167.4.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'043acd2f-6edf-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/043acd2f-6edf-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_bdd54078-e520-419a-9fac-96aa70ec8abb_SESS_11ec5091-732e-4d40-bf52-3ba352b66f63_TOSC_e4bb8c30-edd1-4ef2-82d6-1252a38f03ad_SNAPS_','2022-01-06 10:42:24','2022-01-06 11:42:20','043acd2f-6edf-11ec-9377-226cec7cb58a.png','2022-01-06 11:42:24','SYNCED','043acd2f-6edf-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.11.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'043b0873-6c9d-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/043b0873-6c9d-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_091298b7-bb6a-4d73-8330-9e1ffb78a173_ACT_17237e33-aae3-4912-bd0e-fb05236293e5_SESS_ce069186-0026-443f-8f06-571c4200cd09_TOSC_aa33da56-6fdf-42c5-b114-5b7ca0bab72d_ZIP_','2022-01-03 13:45:30','2022-01-03 14:45:28','043b0873-6c9d-11ec-9377-226cec7cb58a.zip','2022-01-03 14:45:30','SYNCED','043b0873-6c9d-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.167.4.1.3\",\"modelMatrix\":\"0.847329,-0.473955,0.239584,0,0.531068,0.756204,-0.38226,0,-8.67388e-9,0.451136,0.892455,0,12.3515,-31.6782,-18.883,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'043df721-6edf-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/043df721-6edf-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_bdd54078-e520-419a-9fac-96aa70ec8abb_SESS_11ec5091-732e-4d40-bf52-3ba352b66f63_BOSC_cfc660c1-8c74-4d30-a8cb-28ccb258cf9c_SNAPS_','2022-01-06 10:48:03','2022-01-06 11:47:59','043df721-6edf-11ec-9377-226cec7cb58a.png','2022-01-06 11:48:03','SYNCED','043df721-6edf-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.11.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0441344f-6edf-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0441344f-6edf-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_bdd54078-e520-419a-9fac-96aa70ec8abb_SESS_11ec5091-732e-4d40-bf52-3ba352b66f63_BOSC_f39ce54e-715f-4eb1-83f0-fb83981a81bb_ZIP_','2022-01-06 10:51:11','2022-01-06 11:51:07','0441344f-6edf-11ec-9377-226cec7cb58a.zip','2022-01-06 11:51:11','SYNCED','0441344f-6edf-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.11.1.2\",\"modelMatrix\":\"-0.961065,-0.255213,0.105922,0,0.276321,-0.887651,0.368406,0,9.42416e-9,0.383331,0.923611,0,-22.1353,5.54796,-22.5063,1\",\"title\":\"Mandibule ZIP\"}'),(2,'04430350-6c9d-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04430350-6c9d-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_091298b7-bb6a-4d73-8330-9e1ffb78a173_ACT_17237e33-aae3-4912-bd0e-fb05236293e5_SESS_ce069186-0026-443f-8f06-571c4200cd09_BOSC_91d3dd73-9f3c-4b50-aa8f-30e9ded5cf6a_ZIP_','2022-01-03 13:55:27','2022-01-03 14:55:21','04430350-6c9d-11ec-9377-226cec7cb58a.zip','2022-01-03 14:55:27','SYNCED','04430350-6c9d-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.167.4.1.3\",\"modelMatrix\":\"-0.953891,-0.288375,0.0832587,0,0.300153,-0.916458,0.264597,0,-2.04594e-10,0.277387,0.960758,0,-21.7106,3.52318,-18.4388,1\",\"title\":\"Mandibule ZIP\"}'),(2,'0444a47b-46e7-449f-9e7c-d362465890bf','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0444a47b-46e7-449f-9e7c-d362465890bf.png','SNAPS','PATIENT_d69ddf10-a601-42dc-820a-f460242af90d_ACT_de1a5cff-fd0c-4847-ad05-dca4d654941d_SESS_d04f9fad-2c0c-450d-9694-7bd24a88e7d5_TOSC_89e34fa8-57ff-412d-9498-f6d544ee4c5f_SNAPS_','2021-12-07 08:39:12','2019-10-09 11:08:21','0444a47b-46e7-449f-9e7c-d362465890bf.png','2021-12-07 09:39:12','SYNCED','0444a47b-46e7-449f-9e7c-d362465890bf',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 181.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'044518bb-6edf-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/044518bb-6edf-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_bdd54078-e520-419a-9fac-96aa70ec8abb_SESS_11ec5091-732e-4d40-bf52-3ba352b66f63_BOSC_f39ce54e-715f-4eb1-83f0-fb83981a81bb_SNAPS_','2022-01-06 10:51:12','2022-01-06 11:51:06','044518bb-6edf-11ec-9377-226cec7cb58a.png','2022-01-06 11:51:12','SYNCED','044518bb-6edf-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.11.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0445d55b-6c9d-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0445d55b-6c9d-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_091298b7-bb6a-4d73-8330-9e1ffb78a173_ACT_17237e33-aae3-4912-bd0e-fb05236293e5_SESS_ce069186-0026-443f-8f06-571c4200cd09_BOSC_ef4e53ff-8dcd-43f2-bf9a-97b0c50ec733_ZIP_','2022-01-03 13:51:55','2022-01-03 14:51:52','0445d55b-6c9d-11ec-9377-226cec7cb58a.zip','2022-01-03 14:51:55','SYNCED','0445d55b-6c9d-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.167.4.1.2\",\"modelMatrix\":\"-0.921313,-0.368123,0.125173,0,0.388822,-0.872266,0.296596,0,3.34977e-9,0.321927,0.946764,0,-22.7719,2.36299,-21.6831,1\",\"title\":\"Mandibule ZIP\"}'),(2,'0447d585-3f63-4fb3-ba33-1cce4406499c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0447d585-3f63-4fb3-ba33-1cce4406499c.ply','PLY','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_085fdf08-d777-4c3e-bf1b-ba3c5d9a1188_SESS_e47de5cc-baee-41be-b434-97cd36e2cf62_BOSC_ee261dd0-3674-4619-a271-d353528625fe_PLY_','2020-12-23 09:07:21','2019-12-16 13:59:58','0447d585-3f63-4fb3-ba33-1cce4406499c.ply','2020-12-23 10:07:21','SYNCED','0447d585-3f63-4fb3-ba33-1cce4406499c',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.1.1.2\",\"modelMatrix\":\"0.476071,-0.877969,0.0502743,0,0.879407,0.475292,-0.0272162,0,-1.22536e-11,0.0571685,0.998364,0,-9.06333,-19.0344,-18.1046,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'04485f78-6edf-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04485f78-6edf-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_bdd54078-e520-419a-9fac-96aa70ec8abb_SESS_11ec5091-732e-4d40-bf52-3ba352b66f63_TOSC_fe6ee21e-2c12-4071-83f6-10ddaea0fa37_ZIP_','2022-01-06 10:45:24','2022-01-06 11:45:14','04485f78-6edf-11ec-9377-226cec7cb58a.zip','2022-01-06 11:45:24','SYNCED','04485f78-6edf-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.11.1.3\",\"modelMatrix\":\"0.817966,-0.505585,0.274437,0,0.575267,0.718886,-0.390219,0,-1.38464e-8,0.47706,0.878871,0,12.3651,-32.0674,-16.8283,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'0448cf7b-6c9d-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0448cf7b-6c9d-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_091298b7-bb6a-4d73-8330-9e1ffb78a173_ACT_17237e33-aae3-4912-bd0e-fb05236293e5_SESS_ce069186-0026-443f-8f06-571c4200cd09_TOSC_efe8b668-5e48-4fab-9bd4-9995dd4ea49f_ZIP_','2022-01-03 13:38:21','2022-01-03 14:38:18','0448cf7b-6c9d-11ec-9377-226cec7cb58a.zip','2022-01-03 14:38:21','SYNCED','0448cf7b-6c9d-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.167.4.1.1\",\"modelMatrix\":\"0.46157,-0.844888,0.270401,0,0.887104,0.439605,-0.140693,0,-3.53993e-9,0.304814,0.952412,0,-10.6283,-36.0712,-16.9087,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'044c515a-6c9d-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/044c515a-6c9d-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_091298b7-bb6a-4d73-8330-9e1ffb78a173_ACT_17237e33-aae3-4912-bd0e-fb05236293e5_SESS_ce069186-0026-443f-8f06-571c4200cd09_TOSC_2dfd0193-84d1-4feb-baab-cad4398f78d2_ZIP_','2022-01-03 13:42:14','2022-01-03 14:42:10','044c515a-6c9d-11ec-9377-226cec7cb58a.zip','2022-01-03 14:42:14','SYNCED','044c515a-6c9d-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.167.4.1.2\",\"modelMatrix\":\"0.40539,-0.879588,0.248965,0,0.914144,0.390065,-0.110407,0,2.94121e-9,0.272348,0.962199,0,-7.64516,-30.1258,-15.9718,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'044db94b-884c-44c4-b504-360b9a943f6e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/044db94b-884c-44c4-b504-360b9a943f6e.png','SNAPS','PATIENT_9bdadecd-3730-4989-a33e-fe0feac57f3a_ACT_8a64410e-90d6-4583-b2ff-11e95ddfbac1_SESS_d3cea504-daed-416f-9289-b020834e9ba0_BOSC_4e110fb1-3423-418e-9ab7-839b18527427_SNAPS_','2020-12-16 10:51:23','2020-05-28 10:07:23','044db94b-884c-44c4-b504-360b9a943f6e.png','2020-12-16 11:51:23','SYNCED','044db94b-884c-44c4-b504-360b9a943f6e',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 49.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'044eaa94-e3a3-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/044eaa94-e3a3-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_b05e55da-a2aa-45bd-a260-fed7b7a6d00d_SESS_f4f98487-4310-4f4c-86d5-3ef8c90a5a92_BOSC_8d31c937-5ba6-4c4f-8177-009a38066430_PLY_','2020-12-07 12:00:22','2020-08-21 13:36:52','044eaa94-e3a3-11ea-947d-226cec7cb58a.ply','2020-12-07 13:00:22','SYNCED','044eaa94-e3a3-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.26.40.1.1\",\"modelMatrix\":\"-0.772369,0.634631,-0.026262,0,-0.635174,-0.771709,0.0319345,0,2.39979e-9,0.0413461,0.999145,0,-0.0586285,20.0238,-21.6193,1\",\"title\":\"Mandibule PLY\"}'),(2,'0450522d-6c9d-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0450522d-6c9d-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_091298b7-bb6a-4d73-8330-9e1ffb78a173_ACT_17237e33-aae3-4912-bd0e-fb05236293e5_SESS_ce069186-0026-443f-8f06-571c4200cd09_BOSC_91d3dd73-9f3c-4b50-aa8f-30e9ded5cf6a_SNAPS_','2022-01-03 13:55:27','2022-01-03 14:55:19','0450522d-6c9d-11ec-9377-226cec7cb58a.png','2022-01-03 14:55:27','SYNCED','0450522d-6c9d-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.167.4.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'04517826-e3a3-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04517826-e3a3-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_b05e55da-a2aa-45bd-a260-fed7b7a6d00d_SESS_f4f98487-4310-4f4c-86d5-3ef8c90a5a92_TOSC_6d1b801a-e325-46ea-acb7-d587e242670c_SNAPS_','2020-12-07 12:00:22','2020-08-21 13:33:46','04517826-e3a3-11ea-947d-226cec7cb58a.png','2020-12-07 13:00:22','SYNCED','04517826-e3a3-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.26.40.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0454f1a8-e3a3-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0454f1a8-e3a3-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_b05e55da-a2aa-45bd-a260-fed7b7a6d00d_SESS_f4f98487-4310-4f4c-86d5-3ef8c90a5a92_TOSC_6d1b801a-e325-46ea-acb7-d587e242670c_PLY_','2020-12-07 12:00:22','2020-08-21 13:33:46','0454f1a8-e3a3-11ea-947d-226cec7cb58a.ply','2020-12-07 13:00:22','SYNCED','0454f1a8-e3a3-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.26.40.1.1\",\"modelMatrix\":\"0.167512,-0.9489,0.267447,0,0.98587,0.161231,-0.0454427,0,-4.55849e-9,0.27128,0.9625,0,-16.5049,-30.3361,-20.1077,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0456e8a7-f0c3-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0456e8a7-f0c3-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_2b864ce0-3cc8-4b80-969d-f9b27f99086e_ACT_17d544b7-b276-47e6-81d5-535312f6ff69_SESS_ab2dadf7-83a6-4b5b-bf14-291c389c43be_TOSC_27584331-5553-42cf-bbc0-5510faa74c16_SNAPS_','2021-12-07 08:39:12','2019-10-17 11:40:31','0456e8a7-f0c3-11e9-947d-226cec7cb58a.png','2021-12-07 09:39:12','SYNCED','0456e8a7-f0c3-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 189.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'04570271-e3a3-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04570271-e3a3-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_b05e55da-a2aa-45bd-a260-fed7b7a6d00d_SESS_f4f98487-4310-4f4c-86d5-3ef8c90a5a92_BOSC_8d31c937-5ba6-4c4f-8177-009a38066430_SNAPS_','2020-12-07 12:00:22','2020-08-21 13:36:52','04570271-e3a3-11ea-947d-226cec7cb58a.png','2020-12-07 13:00:22','SYNCED','04570271-e3a3-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.26.40.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0458ff02-f0c3-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0458ff02-f0c3-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_2b864ce0-3cc8-4b80-969d-f9b27f99086e_ACT_17d544b7-b276-47e6-81d5-535312f6ff69_SESS_ab2dadf7-83a6-4b5b-bf14-291c389c43be_BOSC_9deb8500-8c7a-4b84-bd3b-1d6728f4672e_PLY_','2021-12-07 08:39:12','2019-10-17 11:44:44','0458ff02-f0c3-11e9-947d-226cec7cb58a.ply','2021-12-07 09:39:12','SYNCED','0458ff02-f0c3-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 189.1.1.1\",\"modelMatrix\":\"-0.8128,0.579395,-0.0604814,0,-0.582544,-0.808407,0.0843873,0,-3.8587e-9,0.103823,0.994596,0,-4.46482,19.662,-23.6504,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'045cc40c-90e3-4762-8836-c1875a5b72b6','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/045cc40c-90e3-4762-8836-c1875a5b72b6.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_f4fade88-9b6b-4d3c-b86d-70413fa3f1c8_SESS_6df99adb-0102-41e4-8799-371d34609080_BOSC_fdc353ad-cf71-4357-844a-c7bdfc65f951_SNAPS_','2020-12-08 17:25:13','2020-06-08 10:41:44','045cc40c-90e3-4762-8836-c1875a5b72b6.png','2020-12-08 18:25:13','SYNCED','045cc40c-90e3-4762-8836-c1875a5b72b6',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.31.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'045ce80f-f0c3-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/045ce80f-f0c3-11e9-947d-226cec7cb58a.stl','STL','PATIENT_2b864ce0-3cc8-4b80-969d-f9b27f99086e_ACT_17d544b7-b276-47e6-81d5-535312f6ff69_SESS_ab2dadf7-83a6-4b5b-bf14-291c389c43be_TOSC_27584331-5553-42cf-bbc0-5510faa74c16_STL_','2021-12-07 08:39:12','2019-10-17 11:40:31','045ce80f-f0c3-11e9-947d-226cec7cb58a.stl','2021-12-07 09:39:12','SYNCED','045ce80f-f0c3-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 189.1.1.1\",\"modelMatrix\":\"0.459882,-0.856748,0.233436,0,0.88798,0.443706,-0.120895,0,-4.43804e-9,0.262884,0.964827,0,-3.81265,-37.5853,-16.1998,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'045f3223-f0c3-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/045f3223-f0c3-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_2b864ce0-3cc8-4b80-969d-f9b27f99086e_ACT_17d544b7-b276-47e6-81d5-535312f6ff69_SESS_ab2dadf7-83a6-4b5b-bf14-291c389c43be_BOSC_9deb8500-8c7a-4b84-bd3b-1d6728f4672e_SNAPS_','2021-12-07 08:39:12','2019-10-17 11:44:44','045f3223-f0c3-11e9-947d-226cec7cb58a.png','2021-12-07 09:39:12','SYNCED','045f3223-f0c3-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 189.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'04600015-86e5-4df0-b6e2-3584d5b0359f','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04600015-86e5-4df0-b6e2-3584d5b0359f.ply','PLY','PATIENT_65aec455-5850-4919-b33e-adf034461605_ACT_4db788cc-c25d-47f0-b487-2f1508ba00ba_SESS_73664137-22fd-4cd0-b83a-df3e14525b13_TOSC_1744026f-a5e7-46f3-8833-bf9c98780702_PLY_','2020-11-25 13:01:58','2020-11-25 14:01:56','04600015-86e5-4df0-b6e2-3584d5b0359f.ply','2020-11-25 14:01:58','SYNCED','04600015-86e5-4df0-b6e2-3584d5b0359f',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.68.1.1.6\",\"modelMatrix\":\"0.544712,-0.807725,0.225542,0,0.838623,0.524643,-0.146497,0,-3.78532e-9,0.268943,0.963156,0,-4.83413,-31.6405,-17.1263,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0460a698-f0c3-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0460a698-f0c3-11e9-947d-226cec7cb58a.stl','STL','PATIENT_2b864ce0-3cc8-4b80-969d-f9b27f99086e_ACT_17d544b7-b276-47e6-81d5-535312f6ff69_SESS_ab2dadf7-83a6-4b5b-bf14-291c389c43be_BOSC_9deb8500-8c7a-4b84-bd3b-1d6728f4672e_STL_','2021-12-07 08:39:12','2019-10-17 11:44:44','0460a698-f0c3-11e9-947d-226cec7cb58a.stl','2021-12-07 09:39:12','SYNCED','0460a698-f0c3-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 189.1.1.1\",\"modelMatrix\":\"-0.8128,0.579395,-0.0604814,0,-0.582544,-0.808407,0.0843873,0,-3.8587e-9,0.103823,0.994596,0,-4.46482,19.662,-23.6504,1\",\"title\":\"MANDIBULE STL\"}'),(2,'046225a2-f0c3-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/046225a2-f0c3-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_2b864ce0-3cc8-4b80-969d-f9b27f99086e_ACT_17d544b7-b276-47e6-81d5-535312f6ff69_SESS_ab2dadf7-83a6-4b5b-bf14-291c389c43be_TOSC_27584331-5553-42cf-bbc0-5510faa74c16_PLY_','2021-12-07 08:39:12','2019-10-17 11:40:31','046225a2-f0c3-11e9-947d-226cec7cb58a.ply','2021-12-07 09:39:12','SYNCED','046225a2-f0c3-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 189.1.1.1\",\"modelMatrix\":\"0.459882,-0.856748,0.233436,0,0.88798,0.443706,-0.120895,0,-4.43804e-9,0.262884,0.964827,0,-3.81265,-37.5853,-16.1998,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'046a5062-66c6-4469-b24c-e8862a88aa24','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/046a5062-66c6-4469-b24c-e8862a88aa24.ply','PLY','PATIENT_227c16ab-62f2-4f76-a1f4-3a753d883af7_ACT_b819729a-c589-41ec-af68-d13a0bb8c21a_SESS_caed56fc-3a88-41c5-ba84-693c72fc12d4_BOSC_6907490c-7dfd-42e8-aa94-7f0cf85bc022_PLY_','2021-12-07 08:39:12','2019-09-18 11:01:55','046a5062-66c6-4469-b24c-e8862a88aa24.ply','2021-12-07 09:39:12','SYNCED','046a5062-66c6-4469-b24c-e8862a88aa24',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 152.1.1.1\",\"modelMatrix\":\"-0.989073,-0.139013,0.0490826,0,0.147424,-0.932646,0.329297,0,-2.72371e-9,0.332935,0.94295,0,-15.4641,10.9591,-35.7228,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'04789813-b1d6-4a3b-984e-6957cad39b1d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04789813-b1d6-4a3b-984e-6957cad39b1d.ply','PLY','PATIENT_e065ef95-3928-430d-bee5-6cc04ce694eb_ACT_240cf220-796d-4cb9-9f4d-71fe39c25b15_SESS_5ee3f7be-2e5f-46f9-b87c-a8f2f381d0c7_BOSC_f483efb3-cd1b-4d13-9784-7be5d2e63581_PLY_','2020-12-07 12:00:23','2020-08-20 09:22:30','04789813-b1d6-4a3b-984e-6957cad39b1d.ply','2020-12-07 13:00:23','SYNCED','04789813-b1d6-4a3b-984e-6957cad39b1d',0,NULL,'','','{\"displayTitle\":\"Mandibule 61.1.12.1.1\",\"modelMatrix\":\"-0.85431,-0.50647,0.116797,0,0.519763,-0.832462,0.191974,0,-1.08022e-8,0.224712,0.974425,0,-20.7977,7.30408,-20.1882,1\",\"title\":\"Mandibule PLY\"}'),(2,'0479052a-dfd0-4ca6-be10-1c2567cc06c8','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0479052a-dfd0-4ca6-be10-1c2567cc06c8.zip','ZIP','PATIENT_e94cc8a4-9fe0-4d90-8c07-d76eeaa42853_ACT_3136504d-6bf4-4c82-9fc2-9b1d38edd21c_SESS_4e5b170c-9984-49fd-b13d-dea599bf05f4_TOSC_708c9550-02c8-4740-b657-4cbb2754b5d2_ZIP_','2021-12-10 08:41:07','2021-12-10 09:41:01','0479052a-dfd0-4ca6-be10-1c2567cc06c8.zip','2021-12-10 09:41:07','SYNCED','0479052a-dfd0-4ca6-be10-1c2567cc06c8',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.407.3.1.3\",\"modelMatrix\":\"0.70436,-0.662297,0.255421,0,0.709843,0.657181,-0.253448,0,-8.09831e-9,0.359828,0.933019,0,2.72858,-35.706,-13.5599,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'048f5d03-944e-4d7c-a55d-be0f591c7649','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/048f5d03-944e-4d7c-a55d-be0f591c7649.png','SNAPS','PATIENT_5a36b509-d87e-4dda-807e-a616406aaa4c_ACT_285e7e26-b813-4dd7-84e7-f265f6e87fd6_SESS_7bf03134-a6b7-430c-ad8b-e85f04d49949_BOSC_7f144bd6-7e2b-4927-948d-0565c2ea7ca8_SNAPS_','2022-03-22 14:12:23','2022-03-22 15:12:19','048f5d03-944e-4d7c-a55d-be0f591c7649.png','2022-03-22 15:12:23','SYNCED','048f5d03-944e-4d7c-a55d-be0f591c7649',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.412.1.1.12\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'04968faf-f510-484a-afe2-756f5ac231de','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04968faf-f510-484a-afe2-756f5ac231de.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_69115389-c079-4b46-a0cb-99aeac2bb2f0_SESS_cc7c6c40-2620-4c44-8a1d-7816b3246f75_TOSC_4686cfeb-c19b-4832-a339-f3f5de7c6fcc_SNAPS_','2021-09-14 08:39:47','2021-09-14 10:39:46','04968faf-f510-484a-afe2-756f5ac231de.png','2021-09-14 10:39:47','SYNCED','04968faf-f510-484a-afe2-756f5ac231de',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.3.22.23.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'049a27ff-5494-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/049a27ff-5494-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_d9a8ab1f-8d67-4ff5-815a-2852ad6a6366_SESS_7b7df491-2844-4c63-9ecb-fad2d62250c9_BOSC_627ceba9-0608-4d11-84fa-5a02ca9cfb9f_SNAPS_','2020-12-16 10:51:25','2020-02-21 11:21:32','049a27ff-5494-11ea-947d-226cec7cb58a.png','2020-12-16 11:51:25','SYNCED','049a27ff-5494-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.2.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'049c6bdb-a88b-4640-8ec4-12ea24f06592','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/049c6bdb-a88b-4640-8ec4-12ea24f06592.png','SNAPS','PATIENT_e2cd92c5-cc74-46aa-84c4-623d1fe83196_ACT_86c35137-f28e-4bf2-ab31-eb82baafceea_SESS_059aa0ef-1c0b-4aeb-8da7-47a8fa73c953_BOSC_338f981c-b813-40d1-b9b6-00b72842f41b_SNAPS_','2021-01-18 13:42:22','2021-01-18 14:34:27','049c6bdb-a88b-4640-8ec4-12ea24f06592.png','2021-01-18 14:42:22','SYNCED','049c6bdb-a88b-4640-8ec4-12ea24f06592',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.10.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'049d424a-5494-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/049d424a-5494-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_d9a8ab1f-8d67-4ff5-815a-2852ad6a6366_SESS_7b7df491-2844-4c63-9ecb-fad2d62250c9_TOSC_f56e1805-31be-4bfa-88fa-9fab9cdb84bd_SNAPS_','2020-12-16 10:51:26','2020-02-21 11:18:26','049d424a-5494-11ea-947d-226cec7cb58a.png','2020-12-16 11:51:26','SYNCED','049d424a-5494-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.2.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'049f3632-5488-4be4-ba80-6c2aeba2293d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/049f3632-5488-4be4-ba80-6c2aeba2293d.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_a805b750-e0de-4e7c-bad6-1e411ddf0de7_SESS_242bf73f-4d6c-46b0-b269-3d90ddf046f5_TOSC_54ea3f82-bfa8-4595-8980-1a7e4a7edf0b_ZIP_','2022-03-30 08:17:41','2022-03-30 10:17:38','049f3632-5488-4be4-ba80-6c2aeba2293d.zip','2022-03-30 10:17:41','SYNCED','049f3632-5488-4be4-ba80-6c2aeba2293d',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.43.1.1\",\"modelMatrix\":\"0.809827,-0.527608,0.256537,0,0.586669,0.728299,-0.354119,0,-2.29051e-08,0.437277,0.899327,0,8.88497,-28.6886,-20.8284,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'049fa184-5494-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/049fa184-5494-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_d9a8ab1f-8d67-4ff5-815a-2852ad6a6366_SESS_7b7df491-2844-4c63-9ecb-fad2d62250c9_BOSC_627ceba9-0608-4d11-84fa-5a02ca9cfb9f_PLY_','2020-12-16 10:51:26','2020-02-21 11:21:32','049fa184-5494-11ea-947d-226cec7cb58a.ply','2020-12-16 11:51:26','SYNCED','049fa184-5494-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.2.1.1\",\"modelMatrix\":\"-0.986573,0.15367,-0.0553063,0,-0.163319,-0.928283,0.334092,0,-3.57181e-9,0.338639,0.940916,0,-16.9453,9.6915,-23.7858,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'04a0db96-7f9f-44d0-9386-f119ac895ef9','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04a0db96-7f9f-44d0-9386-f119ac895ef9.ply','PLY','PATIENT_0cc4ef86-2202-4a20-b6c2-a4a99611d672_ACT_f0b1b1aa-c548-4b0b-a3b9-3179421d336e_SESS_4e1313be-6317-4f1d-800e-ece66d02092f_TOSC_8001f5f2-f644-456a-89d4-8bd6b33aba6e_PLY_','2020-12-08 17:25:16','2020-06-26 15:31:40','04a0db96-7f9f-44d0-9386-f119ac895ef9.ply','2020-12-08 18:25:16','SYNCED','04a0db96-7f9f-44d0-9386-f119ac895ef9',0,NULL,'','','{\"displayTitle\":\"Maxillaire 88.2.1.1.1\",\"modelMatrix\":\"-0.154453,-0.959857,0.234133,0,0.988,-0.150054,0.0366019,0,1.77502e-9,0.236977,0.971515,0,-19.5529,-20.2861,-19.394,1\",\"title\":\"Maxillaire PLY\"}'),(2,'04a15384-5494-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04a15384-5494-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_d9a8ab1f-8d67-4ff5-815a-2852ad6a6366_SESS_7b7df491-2844-4c63-9ecb-fad2d62250c9_TOSC_f56e1805-31be-4bfa-88fa-9fab9cdb84bd_PLY_','2020-12-16 10:51:26','2020-02-21 11:18:26','04a15384-5494-11ea-947d-226cec7cb58a.ply','2020-12-16 11:51:26','SYNCED','04a15384-5494-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.2.1.1\",\"modelMatrix\":\"0.0112247,-0.959526,0.281395,0,0.999937,0.0107711,-0.00315878,0,-6.58271e-11,0.281413,0.959587,0,-20.6165,-31.9941,-18.0386,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'04aa994c-e917-4c97-af31-a14baa8e40b1','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04aa994c-e917-4c97-af31-a14baa8e40b1.zip','ZIP','PATIENT_091298b7-bb6a-4d73-8330-9e1ffb78a173_ACT_a098c80b-e1c3-4d0e-82bd-243c8708e7e8_SESS_268b62e4-ea1d-489b-bf14-3f96697ac51d_BOSC_bb6afaa8-74e9-40a4-bad8-944905591806_ZIP_','2022-01-04 15:52:27','2022-01-04 16:52:24','04aa994c-e917-4c97-af31-a14baa8e40b1.zip','2022-01-04 16:52:27','SYNCED','04aa994c-e917-4c97-af31-a14baa8e40b1',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.167.5.1.3\",\"modelMatrix\":\"-0.983829,-0.168817,0.0598459,0,0.179111,-0.927286,0.328724,0,-3.98946e-9,0.334127,0.942528,0,-27.7651,9.4356,-14.5887,1\",\"title\":\"Mandibule ZIP\"}'),(2,'04aabb83-2e0b-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04aabb83-2e0b-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_0331d3a8-cc7b-44e0-ae03-7f8543b4c613_ACT_c0b56124-1fc8-48f6-8278-8568f573053c_SESS_6511d2dc-171a-49fb-a3e2-c2b4bc29fe2c_TOSC_d2eea46d-7385-4d24-88ff-0305a578392e_PLY_','2020-12-23 09:07:23','2020-01-03 10:22:43','04aabb83-2e0b-11ea-947d-226cec7cb58a.ply','2020-12-23 10:07:23','SYNCED','04aabb83-2e0b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"modelMatrix\":\"0.528568,-0.805771,0.267111,0,0.848891,0.501719,-0.166319,0,-2.26092e-8,0.314659,0.949205,0,-0.578565,-33.1292,-19.5329,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'04abc13c-2197-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04abc13c-2197-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_7237dc5d-0c61-4cb9-b1db-a73cd6a11ada_ACT_c3ed1bf2-28aa-48d2-a107-07a01b82e9af_SESS_558f874e-8228-460b-a7fa-2ee26150b988_TOSC_64e8cb05-12f0-4e95-9fe8-974f57289a89_SNAPS_','2020-12-23 09:07:23','2019-12-18 14:01:21','04abc13c-2197-11ea-947d-226cec7cb58a.png','2020-12-23 10:07:23','SYNCED','04abc13c-2197-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 21.1.268.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'04ace40a-2e0b-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04ace40a-2e0b-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_c0b56124-1fc8-48f6-8278-8568f573053c_SESS_6511d2dc-171a-49fb-a3e2-c2b4bc29fe2c_BOSC_be022936-d035-4126-a288-8428a90afb91_SNAPS_','2020-12-23 09:07:23','2020-01-03 10:25:34','04ace40a-2e0b-11ea-947d-226cec7cb58a.png','2020-12-23 10:07:23','SYNCED','04ace40a-2e0b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'04ad6081-2197-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04ad6081-2197-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_ccc00cdd-6862-49a0-a8b9-ec6471536e71_ACT_c3ed1bf2-28aa-48d2-a107-07a01b82e9af_SESS_558f874e-8228-460b-a7fa-2ee26150b988_BOSC_a0b56ba5-ce3a-450f-9b5e-2191a833df5b_SNAPS_','2020-12-23 09:07:24','2019-12-18 14:05:03','04ad6081-2197-11ea-947d-226cec7cb58a.png','2020-12-23 10:07:24','SYNCED','04ad6081-2197-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 21.1.268.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'04ae6190-2e0b-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04ae6190-2e0b-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_c0b56124-1fc8-48f6-8278-8568f573053c_SESS_6511d2dc-171a-49fb-a3e2-c2b4bc29fe2c_BOSC_be022936-d035-4126-a288-8428a90afb91_PLY_','2020-12-23 09:07:24','2020-01-03 10:25:34','04ae6190-2e0b-11ea-947d-226cec7cb58a.ply','2020-12-23 10:07:24','SYNCED','04ae6190-2e0b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"modelMatrix\":\"-0.970459,0.231899,-0.066572,0,-0.241266,-0.932784,0.267777,0,-6.31081e-9,0.275928,0.961178,0,-16.7368,17.5553,-18.0188,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'04ae8cce-ca97-4787-bde2-a2d961645932','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04ae8cce-ca97-4787-bde2-a2d961645932.png','SNAPS','PATIENT_74a66f39-c9db-4c13-9dbf-7acfc0ea9391_ACT_bd746a5b-c1c4-42fa-88a3-345da35d47a0_SESS_a64913b8-d6d8-4c57-8ded-53d9f86e010a_TOSC_672a3a90-85f2-4c6a-89a3-22bebfee164c_SNAPS_','2021-12-07 08:39:12','2019-10-25 10:50:35','04ae8cce-ca97-4787-bde2-a2d961645932.png','2021-12-07 09:39:12','SYNCED','0f3334a9-68bd-49f8-a15e-a6a0ec4d2dfd',1,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 196.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'04b02e67-2e0b-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04b02e67-2e0b-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_0331d3a8-cc7b-44e0-ae03-7f8543b4c613_ACT_c0b56124-1fc8-48f6-8278-8568f573053c_SESS_6511d2dc-171a-49fb-a3e2-c2b4bc29fe2c_TOSC_d2eea46d-7385-4d24-88ff-0305a578392e_SNAPS_','2020-12-23 09:07:24','2020-01-03 10:22:43','04b02e67-2e0b-11ea-947d-226cec7cb58a.png','2020-12-23 10:07:24','SYNCED','04b02e67-2e0b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'04b21ebf-7a71-11eb-9452-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04b21ebf-7a71-11eb-9452-226cec7cb58a.ply','PLY','PATIENT_fcb9ebae-bca1-4605-b6a6-1084f550d200_ACT_040a130a-22f2-4b21-a8d6-f9f7b4a3b028_SESS_1f64668b-3dff-415d-bec8-f5512663e61c_BOSC_ed9b0350-fb5f-4696-843f-732cf58b1aba_PLY_','2021-03-01 09:31:59','2021-03-01 10:29:06','04b21ebf-7a71-11eb-9452-226cec7cb58a.ply','2021-03-01 10:31:59','SYNCED','04b21ebf-7a71-11eb-9452-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.64.1.2\",\"modelMatrix\":\"-0.992717,-0.118963,0.0189868,0,0.120469,-0.98031,0.15646,0,6.33404e-10,0.157607,0.987502,0,-13.6476,14.2248,-18.7381,1\",\"title\":\"Mandibule PLY\"}'),(2,'04b2255c-2197-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04b2255c-2197-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_7237dc5d-0c61-4cb9-b1db-a73cd6a11ada_ACT_c3ed1bf2-28aa-48d2-a107-07a01b82e9af_SESS_558f874e-8228-460b-a7fa-2ee26150b988_TOSC_64e8cb05-12f0-4e95-9fe8-974f57289a89_PLY_','2020-12-23 09:07:25','2019-12-18 14:01:21','04b2255c-2197-11ea-947d-226cec7cb58a.ply','2020-12-23 10:07:25','SYNCED','04b2255c-2197-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 21.1.268.1.1.1\",\"modelMatrix\":\"0.407314,-0.880262,0.24338,0,0.913288,0.392584,-0.108544,0,5.90618e-9,0.266487,0.963838,0,-4.3112,-32.8215,-20.569,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'04b3c844-2197-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04b3c844-2197-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_ccc00cdd-6862-49a0-a8b9-ec6471536e71_ACT_c3ed1bf2-28aa-48d2-a107-07a01b82e9af_SESS_558f874e-8228-460b-a7fa-2ee26150b988_BOSC_a0b56ba5-ce3a-450f-9b5e-2191a833df5b_PLY_','2020-12-23 09:07:25','2019-12-18 14:05:03','04b3c844-2197-11ea-947d-226cec7cb58a.ply','2020-12-23 10:07:25','SYNCED','04b3c844-2197-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 21.1.268.1.1.1\",\"modelMatrix\":\"-0.95347,0.285062,-0.0981548,0,-0.301487,-0.901524,0.31042,0,-5.42887e-9,0.325569,0.945518,0,-7.5727,16.8436,-20.4036,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'04b8115f-7a71-11eb-9452-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04b8115f-7a71-11eb-9452-226cec7cb58a.ply','PLY','PATIENT_fcb9ebae-bca1-4605-b6a6-1084f550d200_ACT_040a130a-22f2-4b21-a8d6-f9f7b4a3b028_SESS_1f64668b-3dff-415d-bec8-f5512663e61c_TOSC_fea5b7eb-028e-40ff-8266-c8c9b4be9297_PLY_','2021-03-01 09:31:59','2021-03-01 10:21:03','04b8115f-7a71-11eb-9452-226cec7cb58a.ply','2021-03-01 10:31:59','SYNCED','04b8115f-7a71-11eb-9452-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.64.1.2\",\"modelMatrix\":\"0.132373,-0.938528,0.318814,0,0.9912,0.125338,-0.0425769,0,-3.62267e-9,0.321644,0.94686,0,-16.1165,-28.8323,-15.0986,1\",\"title\":\"Maxillaire PLY\"}'),(2,'04bdb3c6-2144-4818-84a5-a4db4df1b7b9','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04bdb3c6-2144-4818-84a5-a4db4df1b7b9.png','SNAPS','PATIENT_e065ef95-3928-430d-bee5-6cc04ce694eb_ACT_954f1ec1-7aef-4040-b9dd-b5444defd142_SESS_4548180c-fe80-4299-96ba-a0d317e8a98a_TOSC_4a5b5a76-b73a-40dc-baaf-7d25efa90f10_SNAPS_','2020-12-07 12:00:26','2020-09-02 16:27:01','04bdb3c6-2144-4818-84a5-a4db4df1b7b9.png','2020-12-07 13:00:26','SYNCED','04bdb3c6-2144-4818-84a5-a4db4df1b7b9',0,NULL,'','','{\"displayTitle\":\"Maxillaire 61.1.25.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'04c13f31-7a71-11eb-9452-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04c13f31-7a71-11eb-9452-226cec7cb58a.png','SNAPS','PATIENT_fcb9ebae-bca1-4605-b6a6-1084f550d200_ACT_040a130a-22f2-4b21-a8d6-f9f7b4a3b028_SESS_1f64668b-3dff-415d-bec8-f5512663e61c_BOSC_87ff7d37-a776-4f09-9153-138e78fe0df4_SNAPS_','2021-03-01 09:31:58','2021-03-01 10:31:38','04c13f31-7a71-11eb-9452-226cec7cb58a.png','2021-03-01 10:31:58','SYNCED','04c13f31-7a71-11eb-9452-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.64.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'04c69345-1499-498e-b315-51cfccad4ba2','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04c69345-1499-498e-b315-51cfccad4ba2.stl','STL','PATIENT_a951fff6-cb01-45e2-9da5-6b824792106c_ACT_aae68188-e6dc-4e55-a08c-a7bbaf441a12_SESS_efcfe50e-78d9-4126-b2c0-f59373cb399c_TOSC_6801e179-f17f-4b52-a428-23baefe0e101_STL_','2022-03-04 13:40:21','2019-07-10 15:40:11','04c69345-1499-498e-b315-51cfccad4ba2.stl','2022-03-04 14:40:21','SYNCED','04c69345-1499-498e-b315-51cfccad4ba2',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 28.1.1.1\",\"modelMatrix\":\"0.99658,-0.0806812,0.0178831,0,0.0826393,0.972966,-0.215659,0,-8.65997e-10,0.216399,0.976305,0,-28.8034,-20.3675,-16.9924,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'04ca700d-7a71-11eb-9452-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04ca700d-7a71-11eb-9452-226cec7cb58a.ply','PLY','PATIENT_fcb9ebae-bca1-4605-b6a6-1084f550d200_ACT_040a130a-22f2-4b21-a8d6-f9f7b4a3b028_SESS_1f64668b-3dff-415d-bec8-f5512663e61c_TOSC_342de737-9fe8-4590-a99e-ad7daee3e2e7_PLY_','2021-03-01 09:31:59','2021-03-01 10:24:06','04ca700d-7a71-11eb-9452-226cec7cb58a.ply','2021-03-01 10:31:59','SYNCED','04ca700d-7a71-11eb-9452-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.64.1.3\",\"modelMatrix\":\"0.726644,-0.616101,0.303988,0,0.687014,0.651639,-0.321523,0,-1.64676e-9,0.442477,0.89678,0,4.01266,-34.7681,-17.4703,1\",\"title\":\"Maxillaire PLY\"}'),(2,'04ceddb3-e373-437e-998f-7c8fd63b7087','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04ceddb3-e373-437e-998f-7c8fd63b7087.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_f470dafa-c083-4592-a53e-8777d59036b8_SESS_6bd449f9-60f6-432a-9a96-152827e027fc_BOSC_3b497030-2274-4f6f-a0f5-471b22e27ecf_SNAPS_','2021-04-29 07:31:10','2021-04-29 09:31:09','04ceddb3-e373-437e-998f-7c8fd63b7087.png','2021-04-29 09:31:10','SYNCED','04ceddb3-e373-437e-998f-7c8fd63b7087',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.125.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'04cf545e-4315-4f40-bad2-cd6e74c0cf2a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04cf545e-4315-4f40-bad2-cd6e74c0cf2a.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_a5a2350a-e52a-4822-ba7f-485fdcf5baee_SESS_11fac5a9-3d15-481c-8777-04bf23428031_TOSC_cd20869a-efb5-4355-8f4e-a3c069de73b8_SNAPS_','2022-03-01 13:03:23','2022-03-01 14:03:19','04cf545e-4315-4f40-bad2-cd6e74c0cf2a.png','2022-03-01 14:03:23','SYNCED','04cf545e-4315-4f40-bad2-cd6e74c0cf2a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.29.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'04cfcc3e-7a71-11eb-9452-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04cfcc3e-7a71-11eb-9452-226cec7cb58a.png','SNAPS','PATIENT_fcb9ebae-bca1-4605-b6a6-1084f550d200_ACT_040a130a-22f2-4b21-a8d6-f9f7b4a3b028_SESS_1f64668b-3dff-415d-bec8-f5512663e61c_BOSC_ed9b0350-fb5f-4696-843f-732cf58b1aba_SNAPS_','2021-03-01 09:32:00','2021-03-01 10:29:06','04cfcc3e-7a71-11eb-9452-226cec7cb58a.png','2021-03-01 10:32:00','SYNCED','04cfcc3e-7a71-11eb-9452-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.64.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'04d11491-a995-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04d11491-a995-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_04e9224e-668d-4fa4-a4af-48f0c21bedb5_SESS_3ca16ceb-c2d2-41f1-a5b2-ca89d985280b_TOSC_54faa18b-df53-4424-bb8c-a3fc0b45c5c3_SNAPS_','2021-04-30 08:43:30','2021-04-30 10:43:28','04d11491-a995-11eb-9377-226cec7cb58a.png','2021-04-30 10:43:30','SYNCED','04d11491-a995-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.132.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'04d63205-02da-4bf9-b481-6494ed514d98','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04d63205-02da-4bf9-b481-6494ed514d98.ply','PLY','PATIENT_068fa927-65ba-41f8-a806-53e0dcc2959b_ACT_a50fd995-2816-4bae-887e-7b0ebcbfc3f5_SESS_6dc4ce39-c651-4e40-a616-1b4cdb235cff_TOSC_eb523328-ab5b-47d5-8795-28bd970f16b2_PLY_','2020-12-08 17:25:21','2020-06-16 14:30:20','04d63205-02da-4bf9-b481-6494ed514d98.ply','2020-12-08 18:25:21','SYNCED','04d63205-02da-4bf9-b481-6494ed514d98',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.46.1.1\",\"modelMatrix\":\"0.737114,-0.639776,0.2176,0,0.675769,0.697854,-0.237353,0,-7.16491e-9,0.322003,0.946739,0,1.34245,-32.5258,-20.2498,1\",\"title\":\"Maxillaire PLY\"}'),(2,'04d6d3ba-7a71-11eb-9452-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04d6d3ba-7a71-11eb-9452-226cec7cb58a.ply','PLY','PATIENT_fcb9ebae-bca1-4605-b6a6-1084f550d200_ACT_040a130a-22f2-4b21-a8d6-f9f7b4a3b028_SESS_1f64668b-3dff-415d-bec8-f5512663e61c_TOSC_04d71c1a-b27d-44cf-a061-49ab91357639_PLY_','2021-03-01 09:31:59','2021-03-01 10:17:29','04d6d3ba-7a71-11eb-9452-226cec7cb58a.ply','2021-03-01 10:31:59','SYNCED','04d6d3ba-7a71-11eb-9452-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.64.1.1\",\"modelMatrix\":\"0.637207,-0.688596,0.346126,0,0.770693,0.569329,-0.286176,0,3.03036e-9,0.44911,0.893476,0,4.51853,-32.035,-19.4413,1\",\"title\":\"Maxillaire PLY\"}'),(2,'04d6f90c-a995-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04d6f90c-a995-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_04e9224e-668d-4fa4-a4af-48f0c21bedb5_SESS_3ca16ceb-c2d2-41f1-a5b2-ca89d985280b_BOSC_ae93a7c8-29fa-45e4-958c-d38e8c93795c_SNAPS_','2021-04-30 09:17:22','2021-04-30 11:17:21','04d6f90c-a995-11eb-9377-226cec7cb58a.png','2021-04-30 11:17:22','SYNCED','04d6f90c-a995-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.132.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'04d8b3fb-09cf-46f4-99bb-284289c8e047','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04d8b3fb-09cf-46f4-99bb-284289c8e047.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_1e9082cc-8473-424d-8f80-809d19d8fa92_SESS_8f17541a-e1be-4b10-bc64-1ca24bc6e870_TOSC_970f4599-0136-4664-84c5-72a06bea668e_PLY_','2021-04-09 14:18:47','2021-04-09 16:16:21','04d8b3fb-09cf-46f4-99bb-284289c8e047.ply','2021-04-09 16:18:47','SYNCED','6cef46fa-4cea-457a-9980-a83d81598811',1,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.50.1.3\",\"modelMatrix\":\"0.857136,-0.48228,0.180895,0,0.515089,0.80254,-0.301019,0,-3.31542e-9,0.351191,0.936304,0,11.9553,-31.5046,-16.6385,1\",\"title\":\"Maxillaire PLY\"}'),(2,'04dcb8e1-7a71-11eb-9452-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04dcb8e1-7a71-11eb-9452-226cec7cb58a.png','SNAPS','PATIENT_fcb9ebae-bca1-4605-b6a6-1084f550d200_ACT_040a130a-22f2-4b21-a8d6-f9f7b4a3b028_SESS_1f64668b-3dff-415d-bec8-f5512663e61c_TOSC_342de737-9fe8-4590-a99e-ad7daee3e2e7_SNAPS_','2021-03-01 09:31:58','2021-03-01 10:24:06','04dcb8e1-7a71-11eb-9452-226cec7cb58a.png','2021-03-01 10:31:58','SYNCED','04dcb8e1-7a71-11eb-9452-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.64.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'04dd6707-a995-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04dd6707-a995-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_04e9224e-668d-4fa4-a4af-48f0c21bedb5_SESS_3ca16ceb-c2d2-41f1-a5b2-ca89d985280b_TOSC_5f5a5409-0eaa-4a3a-bc36-b31469804a41_PLY_','2021-04-30 09:08:51','2021-04-30 11:08:49','04dd6707-a995-11eb-9377-226cec7cb58a.ply','2021-04-30 11:08:51','SYNCED','04dd6707-a995-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.132.1.3\",\"modelMatrix\":\"0.0113391,-0.945176,0.326364,0,0.999936,0.0107182,-0.00370092,0,4.24573e-10,0.326385,0.945237,0,-18.2626,-26.9998,-16.7489,1\",\"title\":\"Maxillaire PLY\"}'),(2,'04ddf064-e61a-4da7-83d9-ca50c2c0b1be','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04ddf064-e61a-4da7-83d9-ca50c2c0b1be.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_a78941e1-e63b-4f03-84db-3c4fcdb64d89_SESS_caf59252-3532-421e-9b72-5abe78045a36_BOSC_8dab0ada-8b66-421f-a822-76bf8bad5ce6_SNAPS_','2020-12-16 10:51:29','2020-02-20 15:04:39','04ddf064-e61a-4da7-83d9-ca50c2c0b1be.png','2020-12-16 11:51:29','SYNCED','04ddf064-e61a-4da7-83d9-ca50c2c0b1be',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'04de354b-2687-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04de354b-2687-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_c67d69f6-f79f-4441-871a-9375ed7badb3_SESS_05816a17-88ae-449b-a23e-6eca2f08686c_TOSC_a1b6048e-fd65-4783-b120-80f13b9d2967_SNAPS_','2021-10-06 09:12:41','2021-10-06 11:12:37','04de354b-2687-11ec-9377-226cec7cb58a.png','2021-10-06 11:12:41','SYNCED','04de354b-2687-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.191.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'04e01dca-2bcc-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04e01dca-2bcc-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_c9dbaf18-0fb2-4968-b361-68c173abadee_ACT_4e71ec6a-14de-49f1-94a7-a434f3d543ed_SESS_e5cc07c8-892b-4ec6-9fac-a0b5b66356ec_TOSC_ba50136d-7065-4cc2-b2a3-3deb58d91911_SNAPS_','2020-12-23 09:07:25','2019-12-31 13:49:05','04e01dca-2bcc-11ea-947d-226cec7cb58a.png','2020-12-23 10:07:25','SYNCED','04e01dca-2bcc-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'04e1b277-7a71-11eb-9452-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04e1b277-7a71-11eb-9452-226cec7cb58a.ply','PLY','PATIENT_fcb9ebae-bca1-4605-b6a6-1084f550d200_ACT_040a130a-22f2-4b21-a8d6-f9f7b4a3b028_SESS_1f64668b-3dff-415d-bec8-f5512663e61c_BOSC_95438ee6-bdc9-40f5-9c20-1b82ee4ad906_PLY_','2021-03-01 09:32:02','2021-03-01 10:26:27','04e1b277-7a71-11eb-9452-226cec7cb58a.ply','2021-03-01 10:32:02','SYNCED','04e1b277-7a71-11eb-9452-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.64.1.1\",\"modelMatrix\":\"-0.992925,0.114345,-0.0320118,0,-0.118741,-0.956161,0.267686,0,1.27207e-11,0.269593,0.962974,0,-16.9332,19.1561,-18.225,1\",\"title\":\"Mandibule PLY\"}'),(2,'04e1d676-2bcc-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04e1d676-2bcc-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_c9dbaf18-0fb2-4968-b361-68c173abadee_ACT_4e71ec6a-14de-49f1-94a7-a434f3d543ed_SESS_e5cc07c8-892b-4ec6-9fac-a0b5b66356ec_TOSC_920f7df6-b178-46f7-bda7-aad391070154_PLY_','2020-12-23 09:07:26','2019-12-31 13:46:07','04e1d676-2bcc-11ea-947d-226cec7cb58a.ply','2020-12-23 10:07:26','SYNCED','04e1d676-2bcc-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"modelMatrix\":\"-0.983141,0.178659,-0.0389306,0,-0.182851,-0.960599,0.209319,0,-7.61736e-10,0.212908,0.977072,0,-3.10135,17.6651,-20.0538,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'04e25742-b8c5-43a9-adae-660e823dbf22','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04e25742-b8c5-43a9-adae-660e823dbf22.stl','STL','PATIENT_a20c5079-e26f-4d25-a4f7-898bb7b44b4f_ACT_2d40ced0-53bf-41a0-b55d-a8170b2031a3_SESS_0e2721b3-8710-485f-8ea8-bded33c4312d_TOSC_ac4cee3f-45d4-431b-899a-1094f9f31a8d_STL_','2022-03-25 10:15:56','2019-08-20 15:17:46','04e25742-b8c5-43a9-adae-660e823dbf22.stl','2022-03-25 11:15:56','SYNCED','04e25742-b8c5-43a9-adae-660e823dbf22',0,'2022-03-25 11:15:56','','','{\"displayTitle\":\"MAXILLAIRE 129.1.1.1.1\",\"modelMatrix\":\"0.63609,-0.729718,0.250801,0,0.771615,0.601552,-0.206751,0,-3.92588e-9,0.325035,0.945702,0,0.907116,-34.8798,-16.1821,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'04e2c90d-a995-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04e2c90d-a995-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_04e9224e-668d-4fa4-a4af-48f0c21bedb5_SESS_3ca16ceb-c2d2-41f1-a5b2-ca89d985280b_TOSC_5f5a5409-0eaa-4a3a-bc36-b31469804a41_SNAPS_','2021-04-30 09:08:50','2021-04-30 11:08:49','04e2c90d-a995-11eb-9377-226cec7cb58a.png','2021-04-30 11:08:50','SYNCED','04e2c90d-a995-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.132.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'04e34e26-2bcc-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04e34e26-2bcc-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_c9dbaf18-0fb2-4968-b361-68c173abadee_ACT_4e71ec6a-14de-49f1-94a7-a434f3d543ed_SESS_e5cc07c8-892b-4ec6-9fac-a0b5b66356ec_TOSC_ba50136d-7065-4cc2-b2a3-3deb58d91911_PLY_','2020-12-23 09:07:26','2019-12-31 13:49:05','04e34e26-2bcc-11ea-947d-226cec7cb58a.ply','2020-12-23 10:07:26','SYNCED','04e34e26-2bcc-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"modelMatrix\":\"0.415761,-0.84638,0.33284,0,0.909474,0.386918,-0.152156,0,6.77872e-9,0.36597,0.930627,0,-3.74244,-34.9458,-21.6852,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'04e391a6-a046-4294-80d4-117017463b34','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04e391a6-a046-4294-80d4-117017463b34.ply','PLY','PATIENT_5b3365d0-2ad4-4d78-9c7c-89ff37d5905d_ACT_ee6f943a-7cab-46d0-b223-fd379650024c_SESS_9f9fe29b-f6ed-4a4c-b9f0-7e6258af0943_TOSC_22f8b8e5-7986-446c-96a1-339297e92a72_PLY_','2020-12-08 17:25:23','2020-06-19 11:27:48','04e391a6-a046-4294-80d4-117017463b34.ply','2020-12-08 18:25:23','SYNCED','04e391a6-a046-4294-80d4-117017463b34',0,NULL,'','','{\"displayTitle\":\"Maxillaire 32.2.1.1.16\",\"modelMatrix\":\"0.747156,-0.59428,0.297637,0,0.664648,0.668053,-0.334585,0,1.20826e-8,0.447812,0.894128,0,-3.03345,-34.6967,-18.4218,1\",\"title\":\"Maxillaire PLY\"}'),(2,'04e39710-2687-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04e39710-2687-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_c67d69f6-f79f-4441-871a-9375ed7badb3_SESS_05816a17-88ae-449b-a23e-6eca2f08686c_TOSC_3b6f0b79-f192-4aea-b6bd-d66440c19311_ZIP_','2021-10-06 09:09:20','2021-10-06 11:09:17','04e39710-2687-11ec-9377-226cec7cb58a.zip','2021-10-06 11:09:20','SYNCED','04e39710-2687-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.191.1.2\",\"modelMatrix\":\"0.694727,-0.670188,0.261155,0,0.719273,0.647317,-0.252242,0,-1.02501e-8,0.363081,0.931757,0,5.87727,-36.01,-23.4067,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'04e578a1-2bcc-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04e578a1-2bcc-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_c9dbaf18-0fb2-4968-b361-68c173abadee_ACT_4e71ec6a-14de-49f1-94a7-a434f3d543ed_SESS_e5cc07c8-892b-4ec6-9fac-a0b5b66356ec_TOSC_920f7df6-b178-46f7-bda7-aad391070154_SNAPS_','2020-12-23 09:07:26','2019-12-31 13:46:07','04e578a1-2bcc-11ea-947d-226cec7cb58a.png','2020-12-23 10:07:26','SYNCED','04e578a1-2bcc-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'04e72dc0-a995-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04e72dc0-a995-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_04e9224e-668d-4fa4-a4af-48f0c21bedb5_SESS_3ca16ceb-c2d2-41f1-a5b2-ca89d985280b_TOSC_54faa18b-df53-4424-bb8c-a3fc0b45c5c3_PLY_','2021-04-30 08:43:31','2021-04-30 10:43:29','04e72dc0-a995-11eb-9377-226cec7cb58a.ply','2021-04-30 10:43:31','SYNCED','04e72dc0-a995-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.132.1.1\",\"modelMatrix\":\"0.664074,-0.692299,0.282361,0,0.747667,0.614896,-0.250792,0,4.56098e-9,0.377656,0.925946,0,0.541779,-39.0943,-13.5645,1\",\"title\":\"Maxillaire PLY\"}'),(2,'04e7e042-2687-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04e7e042-2687-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_c67d69f6-f79f-4441-871a-9375ed7badb3_SESS_05816a17-88ae-449b-a23e-6eca2f08686c_BOSC_bf20dd2f-38df-4fee-a5d2-04d969d5fee0_SNAPS_','2021-10-06 09:22:41','2021-10-06 11:22:37','04e7e042-2687-11ec-9377-226cec7cb58a.png','2021-10-06 11:22:41','SYNCED','04e7e042-2687-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.191.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'04e8c630-7a71-11eb-9452-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04e8c630-7a71-11eb-9452-226cec7cb58a.png','SNAPS','PATIENT_fcb9ebae-bca1-4605-b6a6-1084f550d200_ACT_040a130a-22f2-4b21-a8d6-f9f7b4a3b028_SESS_1f64668b-3dff-415d-bec8-f5512663e61c_TOSC_fea5b7eb-028e-40ff-8266-c8c9b4be9297_SNAPS_','2021-03-01 09:31:58','2021-03-01 10:21:03','04e8c630-7a71-11eb-9452-226cec7cb58a.png','2021-03-01 10:31:58','SYNCED','04e8c630-7a71-11eb-9452-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.64.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'04eb0c0f-2687-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04eb0c0f-2687-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_c67d69f6-f79f-4441-871a-9375ed7badb3_SESS_05816a17-88ae-449b-a23e-6eca2f08686c_BOSC_707802f3-2144-4186-bb36-18e88d8c4f9e_ZIP_','2021-10-06 09:19:23','2021-10-06 11:19:19','04eb0c0f-2687-11ec-9377-226cec7cb58a.zip','2021-10-06 11:19:23','SYNCED','04eb0c0f-2687-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.191.1.2\",\"modelMatrix\":\"-0.847458,-0.520276,0.105486,0,0.530862,-0.830559,0.168396,0,-1.04442e-9,0.198708,0.980059,0,-21.0926,-2.12077,-21.2309,1\",\"title\":\"Mandibule ZIP\"}'),(2,'04eb2d39-417d-4bc9-8cc0-bee600d82c1c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04eb2d39-417d-4bc9-8cc0-bee600d82c1c.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_835f7e4d-6a54-4e10-a33e-739e6cd229a8_SESS_945ba64a-8904-4998-958d-23ad1abc6f43_BOSC_26b71d87-60ba-41ed-a5e1-e893e131d2fd_SNAPS_','2021-09-30 11:58:47','2021-09-30 13:58:43','04eb2d39-417d-4bc9-8cc0-bee600d82c1c.png','2021-09-30 13:58:47','SYNCED','04eb2d39-417d-4bc9-8cc0-bee600d82c1c',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.22.35.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'04ecede3-a995-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04ecede3-a995-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_04e9224e-668d-4fa4-a4af-48f0c21bedb5_SESS_3ca16ceb-c2d2-41f1-a5b2-ca89d985280b_TOSC_74304c00-b7f3-4d64-8ede-5bd76b215604_SNAPS_','2021-04-30 08:58:08','2021-04-30 10:58:07','04ecede3-a995-11eb-9377-226cec7cb58a.png','2021-04-30 10:58:08','SYNCED','04ecede3-a995-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.132.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'04ed2d8c-7a71-11eb-9452-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04ed2d8c-7a71-11eb-9452-226cec7cb58a.png','SNAPS','PATIENT_fcb9ebae-bca1-4605-b6a6-1084f550d200_ACT_040a130a-22f2-4b21-a8d6-f9f7b4a3b028_SESS_1f64668b-3dff-415d-bec8-f5512663e61c_TOSC_04d71c1a-b27d-44cf-a061-49ab91357639_SNAPS_','2021-03-01 09:31:58','2021-03-01 10:17:29','04ed2d8c-7a71-11eb-9452-226cec7cb58a.png','2021-03-01 10:31:58','SYNCED','04ed2d8c-7a71-11eb-9452-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.64.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'04ee1269-2687-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04ee1269-2687-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_c67d69f6-f79f-4441-871a-9375ed7badb3_SESS_05816a17-88ae-449b-a23e-6eca2f08686c_TOSC_3b6f0b79-f192-4aea-b6bd-d66440c19311_SNAPS_','2021-10-06 09:09:20','2021-10-06 11:09:16','04ee1269-2687-11ec-9377-226cec7cb58a.png','2021-10-06 11:09:20','SYNCED','04ee1269-2687-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.191.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'04f09014-a995-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04f09014-a995-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_04e9224e-668d-4fa4-a4af-48f0c21bedb5_SESS_3ca16ceb-c2d2-41f1-a5b2-ca89d985280b_BOSC_46d7d0c9-3c5f-47e7-8d74-2fb09fed930e_PLY_','2021-04-30 09:12:26','2021-04-30 11:12:21','04f09014-a995-11eb-9377-226cec7cb58a.ply','2021-04-30 11:12:26','SYNCED','04f09014-a995-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.132.1.1\",\"modelMatrix\":\"-0.588431,-0.791208,0.166552,0,0.808548,-0.575811,0.121211,0,7.94388e-10,0.20599,0.978554,0,-22.9455,-9.93498,-23.1997,1\",\"title\":\"Mandibule PLY\"}'),(2,'04f1b934-7a71-11eb-9452-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04f1b934-7a71-11eb-9452-226cec7cb58a.ply','PLY','PATIENT_fcb9ebae-bca1-4605-b6a6-1084f550d200_ACT_040a130a-22f2-4b21-a8d6-f9f7b4a3b028_SESS_1f64668b-3dff-415d-bec8-f5512663e61c_BOSC_87ff7d37-a776-4f09-9153-138e78fe0df4_PLY_','2021-03-01 09:31:59','2021-03-01 10:31:38','04f1b934-7a71-11eb-9452-226cec7cb58a.ply','2021-03-01 10:31:59','SYNCED','04f1b934-7a71-11eb-9452-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.64.1.3\",\"modelMatrix\":\"-0.991607,-0.120556,0.0467168,0,0.129291,-0.924612,0.358297,0,-3.21472e-10,0.36133,0.932438,0,-14.4309,12.9694,-16.2519,1\",\"title\":\"Mandibule PLY\"}'),(2,'04f28938-2687-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04f28938-2687-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_c67d69f6-f79f-4441-871a-9375ed7badb3_SESS_05816a17-88ae-449b-a23e-6eca2f08686c_TOSC_a1b6048e-fd65-4783-b120-80f13b9d2967_ZIP_','2021-10-06 09:12:41','2021-10-06 11:12:38','04f28938-2687-11ec-9377-226cec7cb58a.zip','2021-10-06 11:12:41','SYNCED','04f28938-2687-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.191.1.3\",\"modelMatrix\":\"0.928759,-0.299602,0.218281,0,0.370685,0.750657,-0.546907,0,-1.28137e-9,0.588858,0.808237,0,14.5361,-37.5097,-22.7518,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'04f4031a-a995-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04f4031a-a995-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_04e9224e-668d-4fa4-a4af-48f0c21bedb5_SESS_3ca16ceb-c2d2-41f1-a5b2-ca89d985280b_BOSC_587bdd77-54b7-4d59-928a-090300eb0ce3_SNAPS_','2021-04-30 09:15:09','2021-04-30 11:15:08','04f4031a-a995-11eb-9377-226cec7cb58a.png','2021-04-30 11:15:09','SYNCED','04f4031a-a995-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.132.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'04f507b5-8bd9-4216-91a4-4df747b11226','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04f507b5-8bd9-4216-91a4-4df747b11226.png','SNAPS','PATIENT_dc79f3b2-d683-43ed-b1fa-7c071f41f22f_ACT_b951b408-da73-41a1-be4c-5976b8fd8339_SESS_70eca243-d3b9-437e-a3be-2cba7f50d4a2_TOSC_a0048acf-12b0-4191-9b3f-848665b63760_SNAPS_','2021-12-07 08:39:13','2019-10-01 09:39:55','04f507b5-8bd9-4216-91a4-4df747b11226.png','2021-12-07 09:39:13','SYNCED','04f507b5-8bd9-4216-91a4-4df747b11226',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 169.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'04f5bee4-7a71-11eb-9452-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04f5bee4-7a71-11eb-9452-226cec7cb58a.png','SNAPS','PATIENT_fcb9ebae-bca1-4605-b6a6-1084f550d200_ACT_040a130a-22f2-4b21-a8d6-f9f7b4a3b028_SESS_1f64668b-3dff-415d-bec8-f5512663e61c_BOSC_95438ee6-bdc9-40f5-9c20-1b82ee4ad906_SNAPS_','2021-03-01 09:32:00','2021-03-01 10:26:27','04f5bee4-7a71-11eb-9452-226cec7cb58a.png','2021-03-01 10:32:00','SYNCED','04f5bee4-7a71-11eb-9452-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.64.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'04f7e5c6-2687-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04f7e5c6-2687-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_c67d69f6-f79f-4441-871a-9375ed7badb3_SESS_05816a17-88ae-449b-a23e-6eca2f08686c_TOSC_4298ad2e-05e1-4f66-b4b2-88d921169eb3_ZIP_','2021-10-06 09:04:13','2021-10-06 11:04:09','04f7e5c6-2687-11ec-9377-226cec7cb58a.zip','2021-10-06 11:04:13','SYNCED','04f7e5c6-2687-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.191.1.1\",\"modelMatrix\":\"-0.194726,-0.954409,0.226241,0,0.980858,-0.189476,0.0449148,0,2.60851e-9,0.230656,0.973035,0,-21.4637,-20.1346,-16.2821,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'04f9cb93-b9d4-4edd-a399-9cc6d0ceeb8a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04f9cb93-b9d4-4edd-a399-9cc6d0ceeb8a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_cbdea198-bc36-4a11-9d8d-5d6cceb2efb9_SESS_0b224b12-b809-4c65-b652-42bd01939028_BOSC_273b3528-b66d-44f5-9551-2ad9fed6ad1c_SNAPS_','2021-04-30 10:07:05','2021-04-30 12:07:04','04f9cb93-b9d4-4edd-a399-9cc6d0ceeb8a.png','2021-04-30 12:07:05','SYNCED','04f9cb93-b9d4-4edd-a399-9cc6d0ceeb8a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.133.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'04fa0567-a995-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04fa0567-a995-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_04e9224e-668d-4fa4-a4af-48f0c21bedb5_SESS_3ca16ceb-c2d2-41f1-a5b2-ca89d985280b_TOSC_74304c00-b7f3-4d64-8ede-5bd76b215604_PLY_','2021-04-30 08:58:09','2021-04-30 10:58:07','04fa0567-a995-11eb-9377-226cec7cb58a.ply','2021-04-30 10:58:09','SYNCED','04fa0567-a995-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.132.1.2\",\"modelMatrix\":\"0.585749,-0.741156,0.328003,0,0.810492,0.535639,-0.23705,0,-1.36934e-8,0.404696,0.914451,0,2.97538,-32.7889,-13.9501,1\",\"title\":\"Maxillaire PLY\"}'),(2,'04fbf379-2687-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04fbf379-2687-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_c67d69f6-f79f-4441-871a-9375ed7badb3_SESS_05816a17-88ae-449b-a23e-6eca2f08686c_BOSC_94c4e8d7-d74c-4f50-8ade-dcde528a22e6_SNAPS_','2021-10-06 09:16:33','2021-10-06 11:16:29','04fbf379-2687-11ec-9377-226cec7cb58a.png','2021-10-06 11:16:33','SYNCED','04fbf379-2687-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.191.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'04fcd9e0-a995-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04fcd9e0-a995-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_04e9224e-668d-4fa4-a4af-48f0c21bedb5_SESS_3ca16ceb-c2d2-41f1-a5b2-ca89d985280b_BOSC_ae93a7c8-29fa-45e4-958c-d38e8c93795c_PLY_','2021-04-30 09:17:23','2021-04-30 11:17:21','04fcd9e0-a995-11eb-9377-226cec7cb58a.ply','2021-04-30 11:17:23','SYNCED','04fcd9e0-a995-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.132.1.3\",\"modelMatrix\":\"-0.488231,-0.841094,0.23279,0,0.872714,-0.470541,0.130232,0,1.23989e-8,0.266742,0.963768,0,-19.8004,-11.331,-22.3568,1\",\"title\":\"Mandibule PLY\"}'),(2,'04ff6061-2687-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/04ff6061-2687-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_c67d69f6-f79f-4441-871a-9375ed7badb3_SESS_05816a17-88ae-449b-a23e-6eca2f08686c_BOSC_94c4e8d7-d74c-4f50-8ade-dcde528a22e6_ZIP_','2021-10-06 09:16:32','2021-10-06 11:16:30','04ff6061-2687-11ec-9377-226cec7cb58a.zip','2021-10-06 11:16:32','SYNCED','04ff6061-2687-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.191.1.1\",\"modelMatrix\":\"-0.387351,-0.915223,0.111022,0,0.921932,-0.384532,0.046646,0,1.05466e-9,0.120423,0.992723,0,-14.2983,-7.88185,-31.0221,1\",\"title\":\"Mandibule ZIP\"}'),(2,'0500d570-a995-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0500d570-a995-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_04e9224e-668d-4fa4-a4af-48f0c21bedb5_SESS_3ca16ceb-c2d2-41f1-a5b2-ca89d985280b_BOSC_46d7d0c9-3c5f-47e7-8d74-2fb09fed930e_SNAPS_','2021-04-30 09:12:22','2021-04-30 11:12:21','0500d570-a995-11eb-9377-226cec7cb58a.png','2021-04-30 11:12:22','SYNCED','0500d570-a995-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.132.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0502a471-2687-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0502a471-2687-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_c67d69f6-f79f-4441-871a-9375ed7badb3_SESS_05816a17-88ae-449b-a23e-6eca2f08686c_TOSC_4298ad2e-05e1-4f66-b4b2-88d921169eb3_SNAPS_','2021-10-06 09:04:13','2021-10-06 11:04:08','0502a471-2687-11ec-9377-226cec7cb58a.png','2021-10-06 11:04:13','SYNCED','0502a471-2687-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.191.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'05036e58-a995-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05036e58-a995-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_04e9224e-668d-4fa4-a4af-48f0c21bedb5_SESS_3ca16ceb-c2d2-41f1-a5b2-ca89d985280b_BOSC_587bdd77-54b7-4d59-928a-090300eb0ce3_PLY_','2021-04-30 09:15:10','2021-04-30 11:15:08','05036e58-a995-11eb-9377-226cec7cb58a.ply','2021-04-30 11:15:10','SYNCED','05036e58-a995-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.132.1.2\",\"modelMatrix\":\"-0.832379,-0.51994,0.191851,0,0.554207,-0.780914,0.288147,0,-1.48462e-8,0.346173,0.938171,0,-24.854,5.30054,-24.1554,1\",\"title\":\"Mandibule PLY\"}'),(2,'050780a4-2687-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/050780a4-2687-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_c67d69f6-f79f-4441-871a-9375ed7badb3_SESS_05816a17-88ae-449b-a23e-6eca2f08686c_BOSC_707802f3-2144-4186-bb36-18e88d8c4f9e_SNAPS_','2021-10-06 09:19:23','2021-10-06 11:19:18','050780a4-2687-11ec-9377-226cec7cb58a.png','2021-10-06 11:19:23','SYNCED','050780a4-2687-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.191.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'050917c3-4e76-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/050917c3-4e76-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_e67c44fa-320d-4cec-929c-0fac66b8a7ca_SESS_584f4de7-5dda-471a-8bd1-a202eb080ef8_BOSC_a839179b-0053-4b45-954c-a0b9c9e06bd4_SNAPS_','2020-12-16 10:51:30','2020-02-12 10:43:23','050917c3-4e76-11ea-947d-226cec7cb58a.png','2020-12-16 11:51:30','SYNCED','050917c3-4e76-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'050aa20b-2687-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/050aa20b-2687-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_c67d69f6-f79f-4441-871a-9375ed7badb3_SESS_05816a17-88ae-449b-a23e-6eca2f08686c_BOSC_bf20dd2f-38df-4fee-a5d2-04d969d5fee0_ZIP_','2021-10-06 09:22:41','2021-10-06 11:22:38','050aa20b-2687-11ec-9377-226cec7cb58a.zip','2021-10-06 11:22:41','SYNCED','050aa20b-2687-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.191.1.3\",\"modelMatrix\":\"-0.987404,-0.150774,0.0479669,0,0.158221,-0.940935,0.299346,0,3.31115e-9,0.303165,0.952938,0,-25.7133,11.1015,-15.3495,1\",\"title\":\"Mandibule ZIP\"}'),(2,'050ad2e3-4e76-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/050ad2e3-4e76-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_e67c44fa-320d-4cec-929c-0fac66b8a7ca_SESS_584f4de7-5dda-471a-8bd1-a202eb080ef8_BOSC_a839179b-0053-4b45-954c-a0b9c9e06bd4_PLY_','2020-12-16 10:51:31','2020-02-12 10:43:23','050ad2e3-4e76-11ea-947d-226cec7cb58a.ply','2020-12-16 11:51:31','SYNCED','050ad2e3-4e76-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"modelMatrix\":\"-0.624188,0.772523,-0.116608,0,-0.781274,-0.617196,0.093162,0,4.23084e-9,0.149253,0.988799,0,6.53274,19.1368,-15.6158,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'050e2b7a-2327-4ff8-baf7-f05746c9dede','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/050e2b7a-2327-4ff8-baf7-f05746c9dede.ply','PLY','PATIENT_e59ead4f-6d7f-4544-b131-7556c84126e3_ACT_0ed9f14e-49d8-4e25-a03f-2a8098a828e6_SESS_4c39a20a-7176-4fe7-a0b2-7833965d5a0a_TOSC_d59d5721-5cb3-4066-b632-4d04b0f885f0_PLY_','2020-12-02 10:31:56','2020-11-13 10:43:23','050e2b7a-2327-4ff8-baf7-f05746c9dede.ply','2020-12-02 11:31:56','SYNCED','050e2b7a-2327-4ff8-baf7-f05746c9dede',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.36.16.1.1\",\"modelMatrix\":\"0.413711,-0.882557,0.223463,0,0.910408,0.401055,-0.101547,0,-1.6019e-9,0.245454,0.969408,0,-9.02932,-36.515,-13.8588,1\",\"title\":\"Maxillaire PLY\"}'),(2,'05100225-8dc1-4a91-b78b-a1091a7c1419','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05100225-8dc1-4a91-b78b-a1091a7c1419.ply','PLY','PATIENT_65e670b6-609f-4697-82f7-d6369b741ae8_ACT_28a77483-cc52-44e2-b19e-8f83d023e912_SESS_dbf06994-741c-4cf5-a417-99fd47c86050_BOSC_e78adcdf-212d-4f53-a4f8-2fec9c871d38_PLY_','2021-03-17 11:25:47','2021-03-17 12:25:02','05100225-8dc1-4a91-b78b-a1091a7c1419.ply','2021-03-17 12:25:47','SYNCED','05100225-8dc1-4a91-b78b-a1091a7c1419',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.89.1.3\",\"modelMatrix\":\"-0.601088,-0.797425,0.0529719,0,0.799183,-0.599766,0.0398417,0,-2.17123e-10,0.0662826,0.997801,0,-22.9442,-6.16674,-21.3724,1\",\"title\":\"Mandibule PLY\"}'),(2,'05109f66-45b6-48c8-a2ad-503ed27290e2','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05109f66-45b6-48c8-a2ad-503ed27290e2.ply','PLY','PATIENT_a1640bab-46fa-4eed-8e6a-cdfd4aef486a_ACT_ebfbc058-3452-4bfb-b1ab-5e934163bb6d_SESS_af40f930-4869-41d3-adc2-971caf2ed1dc_TOSC_ef349130-ff31-4985-9a6b-57d594f78a74_PLY_','2021-03-17 12:14:31','2021-03-17 13:01:27','05109f66-45b6-48c8-a2ad-503ed27290e2.ply','2021-03-17 13:14:31','SYNCED','05109f66-45b6-48c8-a2ad-503ed27290e2',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.90.1.1\",\"modelMatrix\":\"0.598447,-0.750813,0.279538,0,0.801162,0.560837,-0.208807,0,-1.17308e-8,0.348915,0.937154,0,-3.29604,-35.6612,-14.1677,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0528672f-ce5c-47e6-b68c-851de9645bc8','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0528672f-ce5c-47e6-b68c-851de9645bc8.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_a805b750-e0de-4e7c-bad6-1e411ddf0de7_SESS_242bf73f-4d6c-46b0-b269-3d90ddf046f5_BOSC_dff4eecc-97dd-488c-b04f-16ca5bfe9bdb_ZIP_','2022-03-30 08:59:28','2022-03-30 10:59:24','0528672f-ce5c-47e6-b68c-851de9645bc8.zip','2022-03-30 10:59:28','SYNCED','0528672f-ce5c-47e6-b68c-851de9645bc8',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.43.1.3\",\"modelMatrix\":\"0.157966,-0.975852,0.150861,0,0.987445,0.156111,-0.0241338,0,4.9219e-10,0.152779,0.98826,0,-7.66549,-21.0254,-28.0139,1\",\"title\":\"Mandibule ZIP\"}'),(2,'052d3463-9885-4125-8532-1a1ac4b4b09d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/052d3463-9885-4125-8532-1a1ac4b4b09d.ply','PLY','PATIENT_dffebdef-29f0-48d3-a06b-c16d19da2836_ACT_877296c2-8eeb-49fe-afdb-abb4d477d113_SESS_61ce92e0-cf8d-4d3a-bf40-f61b2dcf18e5_BOSC_5a5f0eb0-57c6-4b92-87a4-2943a6799cc5_PLY_','2021-12-07 08:39:13','2019-07-15 13:20:18','052d3463-9885-4125-8532-1a1ac4b4b09d.ply','2021-12-07 09:39:13','SYNCED','052d3463-9885-4125-8532-1a1ac4b4b09d',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 63.3.1.1\",\"modelMatrix\":\"-0.986489,-0.155414,0.0518306,0,0.163829,-0.935819,0.312095,0,4.70652e-10,0.316369,0.948636,0,-26.4296,10.9661,-21.217,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'052db0eb-95c2-400e-8ef3-8df8f701ecb8','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/052db0eb-95c2-400e-8ef3-8df8f701ecb8.png','SNAPS','PATIENT_2e0a8247-f698-45b5-87fe-8b1e7c952f36_ACT_2093b149-d159-4a7d-93f3-2496bed2b973_SESS_88cb1b33-3ac7-4233-bfd7-abadfde43d9b_BOSC_399d4bfe-e926-4fd2-8bd5-ebb627f686c4_SNAPS_','2020-12-02 10:31:56','2020-10-30 11:45:11','052db0eb-95c2-400e-8ef3-8df8f701ecb8.png','2020-12-02 11:31:56','SYNCED','052db0eb-95c2-400e-8ef3-8df8f701ecb8',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.35.13.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0531f268-cba5-4840-864f-11f7158e49dc','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0531f268-cba5-4840-864f-11f7158e49dc.stl','STL','PATIENT_978991c3-73ec-4272-81bb-35e9fa062036_ACT_f94467b8-6cae-452e-880a-7e1c05d160ee_SESS_f0f0a818-08c6-47f4-9ea1-3e8b8fc3b874_TOSC_6e628d10-e5df-4cf1-a696-e2ffa827067f_STL_','2021-12-07 08:39:13','2019-09-02 10:14:21','0531f268-cba5-4840-864f-11f7158e49dc.stl','2021-12-07 09:39:13','SYNCED','0531f268-cba5-4840-864f-11f7158e49dc',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 135.1.1.1\",\"modelMatrix\":\"0.366572,-0.755427,0.543098,0,0.93039,0.297637,-0.213979,0,-2.72584e-9,0.583731,0.811947,0,-4.62399,-42.8038,-15.7739,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'053856db-646e-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/053856db-646e-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_bfff99cf-e91f-4eed-bb3a-06bece8eaf9f_ACT_b7c84d8c-fbc4-465a-ac48-6c183da143a6_SESS_11809b61-25e7-46d5-bf47-cd02b888e7ae_TOSC_7d7a0827-7efd-49c9-821e-fe36b7e07a14_SNAPS_','2020-12-16 10:51:31','2020-03-12 15:25:00','053856db-646e-11ea-947d-226cec7cb58a.png','2020-12-16 11:51:31','SYNCED','053856db-646e-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 20.1.1.2.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'053a4961-646e-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/053a4961-646e-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_bfff99cf-e91f-4eed-bb3a-06bece8eaf9f_ACT_b7c84d8c-fbc4-465a-ac48-6c183da143a6_SESS_11809b61-25e7-46d5-bf47-cd02b888e7ae_BOSC_1ed09b04-4bda-4908-ab68-9037606cc0e9_PLY_','2020-12-16 10:51:32','2020-03-12 15:30:12','053a4961-646e-11ea-947d-226cec7cb58a.ply','2020-12-16 11:51:32','SYNCED','053a4961-646e-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 20.1.1.2.1.1\",\"modelMatrix\":\"-0.995741,-0.0876824,0.0284807,0,0.0921919,-0.947035,0.307613,0,-7.69095e-10,0.308929,0.951085,0,-20.4083,9.58921,-23.1594,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'053c019f-646e-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/053c019f-646e-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_bfff99cf-e91f-4eed-bb3a-06bece8eaf9f_ACT_b7c84d8c-fbc4-465a-ac48-6c183da143a6_SESS_11809b61-25e7-46d5-bf47-cd02b888e7ae_BOSC_1ed09b04-4bda-4908-ab68-9037606cc0e9_SNAPS_','2020-12-16 10:51:32','2020-03-12 15:30:12','053c019f-646e-11ea-947d-226cec7cb58a.png','2020-12-16 11:51:32','SYNCED','053c019f-646e-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 20.1.1.2.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'053c7d1b-b458-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/053c7d1b-b458-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_55452abe-c899-4508-a6ad-a6862da81096_ACT_f590af08-ea0d-4176-af23-aa19fbbc81bd_SESS_1d2eedba-7320-43b2-9232-c9ff66bfa1bc_BOSC_aca77b9b-0dc3-4e2d-bf30-b2ff5f675163_PLY_','2020-12-08 17:25:26','2020-06-19 16:20:33','053c7d1b-b458-11ea-947d-226cec7cb58a.ply','2020-12-08 18:25:26','SYNCED','053c7d1b-b458-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 32.1.2.1.5\",\"modelMatrix\":\"-0.955156,0.279354,-0.0981713,0,-0.296102,-0.901132,0.316678,0,3.04469e-9,0.331546,0.943439,0,-11.1182,19.6322,-16.0254,1\",\"title\":\"Mandibule PLY\"}'),(2,'053e254c-646e-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/053e254c-646e-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_bfff99cf-e91f-4eed-bb3a-06bece8eaf9f_ACT_b7c84d8c-fbc4-465a-ac48-6c183da143a6_SESS_11809b61-25e7-46d5-bf47-cd02b888e7ae_TOSC_7d7a0827-7efd-49c9-821e-fe36b7e07a14_PLY_','2020-12-16 10:51:32','2020-03-12 15:25:00','053e254c-646e-11ea-947d-226cec7cb58a.ply','2020-12-16 11:51:32','SYNCED','053e254c-646e-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 20.1.1.2.1.1\",\"modelMatrix\":\"0.176498,-0.938781,0.29587,0,0.984301,0.168335,-0.0530533,0,2.44693e-9,0.300589,0.953754,0,-17.1177,-30.9431,-23.3501,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'053eac4f-b458-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/053eac4f-b458-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_55452abe-c899-4508-a6ad-a6862da81096_ACT_f590af08-ea0d-4176-af23-aa19fbbc81bd_SESS_1d2eedba-7320-43b2-9232-c9ff66bfa1bc_BOSC_1bdd85f4-0e84-4a79-9ea4-bb4f021f3c49_SNAPS_','2020-12-08 17:25:26','2020-06-19 16:15:24','053eac4f-b458-11ea-947d-226cec7cb58a.png','2020-12-08 18:25:26','SYNCED','053eac4f-b458-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 32.1.2.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0540b888-b458-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0540b888-b458-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_55452abe-c899-4508-a6ad-a6862da81096_ACT_f590af08-ea0d-4176-af23-aa19fbbc81bd_SESS_1d2eedba-7320-43b2-9232-c9ff66bfa1bc_TOSC_35dabc89-32b6-4d4b-9b48-de4ad10f2aca_PLY_','2020-12-08 17:25:27','2020-06-19 16:06:53','0540b888-b458-11ea-947d-226cec7cb58a.ply','2020-12-08 18:25:27','SYNCED','0540b888-b458-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 32.1.2.1.5\",\"modelMatrix\":\"0.636117,-0.73527,0.233951,0,0.771593,0.606172,-0.192874,0,9.88983e-9,0.303205,0.952925,0,3.06615,-35.8859,-17.5375,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0542ac6f-b458-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0542ac6f-b458-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_55452abe-c899-4508-a6ad-a6862da81096_ACT_f590af08-ea0d-4176-af23-aa19fbbc81bd_SESS_1d2eedba-7320-43b2-9232-c9ff66bfa1bc_BOSC_ece024aa-82f8-433b-b734-ac29b6ebcd00_PLY_','2020-12-08 17:25:27','2020-06-19 16:12:52','0542ac6f-b458-11ea-947d-226cec7cb58a.ply','2020-12-08 18:25:27','SYNCED','0542ac6f-b458-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 32.1.2.1.2\",\"modelMatrix\":\"-0.995566,0.0905506,-0.0254862,0,-0.0940689,-0.95833,0.269729,0,1.80004e-9,0.270931,0.962599,0,-15.8216,17.8842,-15.9832,1\",\"title\":\"Mandibule PLY\"}'),(2,'0542d4c4-4fd8-4e6e-98ba-a926e09bbcea','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0542d4c4-4fd8-4e6e-98ba-a926e09bbcea.png','SNAPS','PATIENT_091298b7-bb6a-4d73-8330-9e1ffb78a173_ACT_a680ea13-c867-4308-a6a0-d698651bfb1f_SESS_0a88b7a3-7330-4b69-af74-1277b49a6cce_TOSC_2a240179-fca4-4e12-a0d0-584ca169137a_SNAPS_','2022-01-03 10:40:02','2022-01-03 11:39:57','0542d4c4-4fd8-4e6e-98ba-a926e09bbcea.png','2022-01-03 11:40:02','SYNCED','0542d4c4-4fd8-4e6e-98ba-a926e09bbcea',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.167.3.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'05449a8d-a940-4f30-9536-e1ea14e3154c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05449a8d-a940-4f30-9536-e1ea14e3154c.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_49b35b4c-e75b-4f62-9f62-e821dc363b94_SESS_349401f7-fafa-4197-8e57-5dd5504a8f25_BOSC_8ab1e3f1-9fc4-4ff7-ab2c-1b3038cfb6cf_ZIP_','2022-03-31 07:23:44','2022-03-31 09:23:41','05449a8d-a940-4f30-9536-e1ea14e3154c.zip','2022-03-31 09:23:44','SYNCED','05449a8d-a940-4f30-9536-e1ea14e3154c',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.47.1.1\",\"modelMatrix\":\"-0.695762,-0.71382,0.0798545,0,0.718272,-0.691449,0.0773519,0,-3.02496e-11,0.111176,0.993801,0,-26.091,-0.659685,-25.377,1\",\"title\":\"Mandibule ZIP\"}'),(2,'0546ba9c-b458-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0546ba9c-b458-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_55452abe-c899-4508-a6ad-a6862da81096_ACT_f590af08-ea0d-4176-af23-aa19fbbc81bd_SESS_1d2eedba-7320-43b2-9232-c9ff66bfa1bc_TOSC_b3643dde-2480-4540-83d2-ebd2bd65cc09_PLY_','2020-12-08 17:25:27','2020-06-19 16:01:42','0546ba9c-b458-11ea-947d-226cec7cb58a.ply','2020-12-08 18:25:27','SYNCED','0546ba9c-b458-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 32.1.2.1.3\",\"modelMatrix\":\"0.330719,-0.910747,0.247314,0,0.943729,0.319161,-0.0866684,0,9.10467e-9,0.26206,0.965052,0,-9.89599,-34.7171,-15.5031,1\",\"title\":\"Maxillaire PLY\"}'),(2,'054903e5-b458-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/054903e5-b458-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_55452abe-c899-4508-a6ad-a6862da81096_ACT_f590af08-ea0d-4176-af23-aa19fbbc81bd_SESS_1d2eedba-7320-43b2-9232-c9ff66bfa1bc_BOSC_c828d4fd-b0ac-499d-a41f-a02e358a5185_SNAPS_','2020-12-08 17:25:27','2020-06-19 16:17:37','054903e5-b458-11ea-947d-226cec7cb58a.png','2020-12-08 18:25:27','SYNCED','054903e5-b458-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 32.1.2.1.4\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'05494205-b06d-4039-9742-77e5f08a2a4e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05494205-b06d-4039-9742-77e5f08a2a4e.ply','PLY','PATIENT_bbd4e212-1201-4bce-b1de-a2494ec3f418_ACT_2ddf9f74-937c-4089-a4f1-5e46b8faffd4_SESS_982962a5-ec57-4402-b8fd-6e8652ccde33_BOSC_893829f3-0c89-4da1-9273-d0b8fab443a1_PLY_','2021-01-19 15:02:47','2021-01-19 15:45:12','05494205-b06d-4039-9742-77e5f08a2a4e.ply','2021-01-19 16:02:47','SYNCED','05494205-b06d-4039-9742-77e5f08a2a4e',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.14.1.1\",\"modelMatrix\":\"-0.944917,-0.325839,0.0309994,0,0.32731,-0.94067,0.0894927,0,-2.59172e-9,0.0947096,0.995505,0,-21.8583,5.55908,-23.1854,1\",\"title\":\"Mandibule PLY\"}'),(2,'054aecc8-b458-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/054aecc8-b458-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_55452abe-c899-4508-a6ad-a6862da81096_ACT_f590af08-ea0d-4176-af23-aa19fbbc81bd_SESS_1d2eedba-7320-43b2-9232-c9ff66bfa1bc_BOSC_aca77b9b-0dc3-4e2d-bf30-b2ff5f675163_SNAPS_','2020-12-08 17:25:28','2020-06-19 16:20:33','054aecc8-b458-11ea-947d-226cec7cb58a.png','2020-12-08 18:25:28','SYNCED','054aecc8-b458-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 32.1.2.1.5\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'054c7b46-8e49-4b26-9fe5-2629b21cc10e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/054c7b46-8e49-4b26-9fe5-2629b21cc10e.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_9d55e20d-c9a3-47c1-be07-a1b8b8e1ad46_SESS_f4c4cf33-1da8-4a4f-a33c-5f4ad5b9b16d_BOSC_a577cccc-2b82-47f4-ad7c-b1b671b00bee_PLY_','2020-12-16 11:05:45','2020-01-31 14:08:56','054c7b46-8e49-4b26-9fe5-2629b21cc10e.ply','2020-12-16 12:05:45','SYNCED','054c7b46-8e49-4b26-9fe5-2629b21cc10e',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.2\",\"modelMatrix\":\"-0.722198,0.687827,-0.0729651,0,-0.691686,-0.718169,0.0761838,0,-3.43021e-9,0.105489,0.99442,0,5.72091,19.7596,-24.2097,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'055016ad-b458-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/055016ad-b458-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_55452abe-c899-4508-a6ad-a6862da81096_ACT_f590af08-ea0d-4176-af23-aa19fbbc81bd_SESS_1d2eedba-7320-43b2-9232-c9ff66bfa1bc_TOSC_6ec865e4-2e39-4354-8f54-93de344eda38_SNAPS_','2020-12-08 17:25:29','2020-06-19 15:56:58','055016ad-b458-11ea-947d-226cec7cb58a.png','2020-12-08 18:25:29','SYNCED','055016ad-b458-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 32.1.2.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0552c58c-b458-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0552c58c-b458-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_55452abe-c899-4508-a6ad-a6862da81096_ACT_f590af08-ea0d-4176-af23-aa19fbbc81bd_SESS_1d2eedba-7320-43b2-9232-c9ff66bfa1bc_BOSC_b04a6178-f491-4396-b4f2-e20368f5ce62_SNAPS_','2020-12-08 17:25:29','2020-06-19 16:10:11','0552c58c-b458-11ea-947d-226cec7cb58a.png','2020-12-08 18:25:29','SYNCED','0552c58c-b458-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 32.1.2.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'05549b40-b458-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05549b40-b458-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_55452abe-c899-4508-a6ad-a6862da81096_ACT_f590af08-ea0d-4176-af23-aa19fbbc81bd_SESS_1d2eedba-7320-43b2-9232-c9ff66bfa1bc_BOSC_c828d4fd-b0ac-499d-a41f-a02e358a5185_PLY_','2020-12-08 17:25:29','2020-06-19 16:17:37','05549b40-b458-11ea-947d-226cec7cb58a.ply','2020-12-08 18:25:29','SYNCED','05549b40-b458-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 32.1.2.1.4\",\"modelMatrix\":\"-0.993472,0.10522,-0.0440725,0,-0.114077,-0.916335,0.383818,0,-2.64253e-9,0.38634,0.922356,0,-11.1225,15.7404,-19.0416,1\",\"title\":\"Mandibule PLY\"}'),(2,'055683bc-b458-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/055683bc-b458-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_55452abe-c899-4508-a6ad-a6862da81096_ACT_f590af08-ea0d-4176-af23-aa19fbbc81bd_SESS_1d2eedba-7320-43b2-9232-c9ff66bfa1bc_BOSC_ece024aa-82f8-433b-b734-ac29b6ebcd00_SNAPS_','2020-12-08 17:25:29','2020-06-19 16:12:52','055683bc-b458-11ea-947d-226cec7cb58a.png','2020-12-08 18:25:29','SYNCED','055683bc-b458-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 32.1.2.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'05584c16-b458-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05584c16-b458-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_55452abe-c899-4508-a6ad-a6862da81096_ACT_f590af08-ea0d-4176-af23-aa19fbbc81bd_SESS_1d2eedba-7320-43b2-9232-c9ff66bfa1bc_TOSC_b3643dde-2480-4540-83d2-ebd2bd65cc09_SNAPS_','2020-12-08 17:25:30','2020-06-19 16:01:42','05584c16-b458-11ea-947d-226cec7cb58a.png','2020-12-08 18:25:30','SYNCED','05584c16-b458-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 32.1.2.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0558d8fa-7d84-45c4-b1d4-e47eada66fde','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0558d8fa-7d84-45c4-b1d4-e47eada66fde.ply','PLY','PATIENT_616956a0-ee92-4787-8709-9c0704d6a0bd_ACT_4f198b58-27bd-4e69-a1a4-f2466c194213_SESS_2c7c3146-15a4-4af6-84d2-baffa844529a_TOSC_79060181-55f6-4f3f-9c6d-21f04a9b412d_PLY_','2021-03-31 07:31:07','2021-03-31 09:13:56','0558d8fa-7d84-45c4-b1d4-e47eada66fde.ply','2021-03-31 09:31:07','SYNCED','0558d8fa-7d84-45c4-b1d4-e47eada66fde',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.25.1.2\",\"modelMatrix\":\"0.719062,-0.640424,0.269829,0,0.694946,0.662647,-0.279193,0,1.2296e-8,0.388274,0.921544,0,5.59736,-33.0441,-14.716,1\",\"title\":\"Maxillaire PLY\"}'),(2,'055a0f93-b458-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/055a0f93-b458-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_55452abe-c899-4508-a6ad-a6862da81096_ACT_f590af08-ea0d-4176-af23-aa19fbbc81bd_SESS_1d2eedba-7320-43b2-9232-c9ff66bfa1bc_TOSC_35dabc89-32b6-4d4b-9b48-de4ad10f2aca_SNAPS_','2020-12-08 17:25:30','2020-06-19 16:06:53','055a0f93-b458-11ea-947d-226cec7cb58a.png','2020-12-08 18:25:30','SYNCED','055a0f93-b458-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 32.1.2.1.5\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'055a5da8-4b8b-4d66-b326-e5fab09edc01','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/055a5da8-4b8b-4d66-b326-e5fab09edc01.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_bdd54078-e520-419a-9fac-96aa70ec8abb_SESS_11ec5091-732e-4d40-bf52-3ba352b66f63_BOSC_38bc4587-962e-46db-9e98-369892e462cb_SNAPS_','2022-01-06 10:53:52','2022-01-06 11:53:48','055a5da8-4b8b-4d66-b326-e5fab09edc01.png','2022-01-06 11:53:52','SYNCED','055a5da8-4b8b-4d66-b326-e5fab09edc01',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.11.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'055bcc0a-a674-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/055bcc0a-a674-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_0f6f5d9e-5919-4328-8a3c-f4137207e768_SESS_9c1305c5-f9e6-4f8f-9130-f13a12247bac_BOSC_b0037503-a60f-4612-9a3d-577ba6146004_SNAPS_','2021-04-26 09:39:47','2021-04-26 11:39:46','055bcc0a-a674-11eb-9377-226cec7cb58a.png','2021-04-26 11:39:47','SYNCED','055bcc0a-a674-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.101.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'055bd105-b458-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/055bd105-b458-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_55452abe-c899-4508-a6ad-a6862da81096_ACT_f590af08-ea0d-4176-af23-aa19fbbc81bd_SESS_1d2eedba-7320-43b2-9232-c9ff66bfa1bc_TOSC_8b85d5a4-dd79-457b-9852-56c8768536a0_PLY_','2020-12-08 17:25:30','2020-06-19 15:59:12','055bd105-b458-11ea-947d-226cec7cb58a.ply','2020-12-08 18:25:30','SYNCED','055bd105-b458-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 32.1.2.1.2\",\"modelMatrix\":\"0.596995,-0.770818,0.222343,0,0.802245,0.573609,-0.165458,0,1.0765e-8,0.277151,0.960826,0,1.48948,-34.0978,-17.776,1\",\"title\":\"Maxillaire PLY\"}'),(2,'055d79df-b458-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/055d79df-b458-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_55452abe-c899-4508-a6ad-a6862da81096_ACT_f590af08-ea0d-4176-af23-aa19fbbc81bd_SESS_1d2eedba-7320-43b2-9232-c9ff66bfa1bc_BOSC_b04a6178-f491-4396-b4f2-e20368f5ce62_PLY_','2020-12-08 17:25:30','2020-06-19 16:10:11','055d79df-b458-11ea-947d-226cec7cb58a.ply','2020-12-08 18:25:30','SYNCED','055d79df-b458-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 32.1.2.1.1\",\"modelMatrix\":\"-0.988854,0.135495,-0.0617095,0,-0.148885,-0.899917,0.409857,0,3.59111e-9,0.414476,0.91006,0,-16.7389,15.8074,-20.8868,1\",\"title\":\"Mandibule PLY\"}'),(2,'055e3c5b-ae71-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/055e3c5b-ae71-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_990e0778-94d9-4a9c-a5ce-29a3e517f9ac_SESS_c6ceec92-b632-4832-a472-65c076613b60_TOSC_d09370ed-daa7-4e79-9874-616c56f97f5a_PLY_','2021-05-06 13:32:48','2021-05-06 15:32:47','055e3c5b-ae71-11eb-9377-226cec7cb58a.ply','2021-05-06 15:32:48','SYNCED','055e3c5b-ae71-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.143.1.3\",\"modelMatrix\":\"0.838569,-0.466546,0.281311,0,0.544795,0.718126,-0.433005,0,-6.47236e-9,0.516362,0.856371,0,13.2832,-35.8306,-17.958,1\",\"title\":\"Maxillaire PLY\"}'),(2,'055f0c1e-a674-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/055f0c1e-a674-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_0f6f5d9e-5919-4328-8a3c-f4137207e768_SESS_9c1305c5-f9e6-4f8f-9130-f13a12247bac_BOSC_6d4c9a8c-fb48-42ed-a9eb-5734588f24b4_PLY_','2021-04-26 09:44:03','2021-04-26 11:43:58','055f0c1e-a674-11eb-9377-226cec7cb58a.ply','2021-04-26 11:44:03','SYNCED','055f0c1e-a674-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.101.1.3\",\"modelMatrix\":\"-0.581915,-0.796673,0.163362,0,0.81325,-0.570053,0.116892,0,-9.86675e-9,0.200876,0.979617,0,-22.5036,-0.43356,-24.0638,1\",\"title\":\"Mandibule PLY\"}'),(2,'055f42cd-b458-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/055f42cd-b458-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_55452abe-c899-4508-a6ad-a6862da81096_ACT_f590af08-ea0d-4176-af23-aa19fbbc81bd_SESS_1d2eedba-7320-43b2-9232-c9ff66bfa1bc_BOSC_1bdd85f4-0e84-4a79-9ea4-bb4f021f3c49_PLY_','2020-12-08 17:25:31','2020-06-19 16:15:24','055f42cd-b458-11ea-947d-226cec7cb58a.ply','2020-12-08 18:25:31','SYNCED','055f42cd-b458-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 32.1.2.1.3\",\"modelMatrix\":\"-0.965328,0.244877,-0.090428,0,-0.26104,-0.905556,0.334403,0,2.64955e-9,0.346414,0.938082,0,-8.71656,16.6512,-20.0737,1\",\"title\":\"Mandibule PLY\"}'),(2,'0561241c-b458-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0561241c-b458-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_55452abe-c899-4508-a6ad-a6862da81096_ACT_f590af08-ea0d-4176-af23-aa19fbbc81bd_SESS_1d2eedba-7320-43b2-9232-c9ff66bfa1bc_TOSC_8b3a6976-8e6c-4ffd-9532-153cb838f7ab_PLY_','2020-12-08 17:25:31','2020-06-19 16:04:19','0561241c-b458-11ea-947d-226cec7cb58a.ply','2020-12-08 18:25:31','SYNCED','0561241c-b458-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 32.1.2.1.4\",\"modelMatrix\":\"0.735038,-0.646559,0.204157,0,0.678026,0.700926,-0.221324,0,8.17528e-9,0.301105,0.953591,0,7.36087,-32.4604,-19.4725,1\",\"title\":\"Maxillaire PLY\"}'),(2,'05613316-ae71-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05613316-ae71-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_990e0778-94d9-4a9c-a5ce-29a3e517f9ac_SESS_c6ceec92-b632-4832-a472-65c076613b60_TOSC_d09370ed-daa7-4e79-9874-616c56f97f5a_SNAPS_','2021-05-06 13:32:48','2021-05-06 15:32:47','05613316-ae71-11eb-9377-226cec7cb58a.png','2021-05-06 15:32:48','SYNCED','05613316-ae71-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.143.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0561a584-a674-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0561a584-a674-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_0f6f5d9e-5919-4328-8a3c-f4137207e768_SESS_9c1305c5-f9e6-4f8f-9130-f13a12247bac_BOSC_9e93f5e3-2954-4068-9f9c-cb9b1ef8db95_PLY_','2021-04-26 09:41:48','2021-04-26 11:41:47','0561a584-a674-11eb-9377-226cec7cb58a.ply','2021-04-26 11:41:48','SYNCED','0561a584-a674-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.101.1.2\",\"modelMatrix\":\"0.867885,-0.490457,0.0789175,0,0.496765,0.856863,-0.137875,0,2.93169e-10,0.158863,0.987301,0,3.06324,-27.3697,-25.1697,1\",\"title\":\"Mandibule PLY\"}'),(2,'0562db7b-9ccb-42d4-b4de-2287830bf34a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0562db7b-9ccb-42d4-b4de-2287830bf34a.png','SNAPS','PATIENT_b87a45f4-e9da-42dd-a118-319f1cadc208_ACT_e48ea1a6-dafa-457d-b928-ddb5957d68d3_SESS_0b023d1b-96d3-44b5-b2a9-50a025917cea_TOSC_c41f71a3-52ee-4451-83e9-f2bc1af1e94e_SNAPS_','2021-12-07 08:39:13','2019-07-26 09:12:09','0562db7b-9ccb-42d4-b4de-2287830bf34a.png','2021-12-07 09:39:13','SYNCED','0562db7b-9ccb-42d4-b4de-2287830bf34a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 72.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'05641569-ae71-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05641569-ae71-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_990e0778-94d9-4a9c-a5ce-29a3e517f9ac_SESS_c6ceec92-b632-4832-a472-65c076613b60_BOSC_e0f00f76-aa45-4cf0-850c-2a251c0f1069_PLY_','2021-05-06 13:35:24','2021-05-06 15:35:22','05641569-ae71-11eb-9377-226cec7cb58a.ply','2021-05-06 15:35:24','SYNCED','05641569-ae71-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.143.1.1\",\"modelMatrix\":\"-0.685747,-0.719781,0.108008,0,0.72784,-0.678155,0.101762,0,-1.09927e-9,0.148396,0.988928,0,-18.8719,-4.19385,-23.0616,1\",\"title\":\"Mandibule PLY\"}'),(2,'05643c22-a674-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05643c22-a674-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_0f6f5d9e-5919-4328-8a3c-f4137207e768_SESS_9c1305c5-f9e6-4f8f-9130-f13a12247bac_TOSC_db857767-7ac9-4fdf-8734-9dc9826d07bd_SNAPS_','2021-04-26 09:28:57','2021-04-26 11:28:56','05643c22-a674-11eb-9377-226cec7cb58a.png','2021-04-26 11:28:57','SYNCED','05643c22-a674-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.101.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0565bcd1-b458-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0565bcd1-b458-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_55452abe-c899-4508-a6ad-a6862da81096_ACT_f590af08-ea0d-4176-af23-aa19fbbc81bd_SESS_1d2eedba-7320-43b2-9232-c9ff66bfa1bc_TOSC_6ec865e4-2e39-4354-8f54-93de344eda38_PLY_','2020-12-08 17:25:31','2020-06-19 15:56:58','0565bcd1-b458-11ea-947d-226cec7cb58a.ply','2020-12-08 18:25:31','SYNCED','0565bcd1-b458-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 32.1.2.1.1\",\"modelMatrix\":\"0.648444,-0.735487,0.196416,0,0.761263,0.626488,-0.167307,0,4.39752e-9,0.258014,0.966141,0,0.0852617,-37.3999,-14.7163,1\",\"title\":\"Maxillaire PLY\"}'),(2,'05669f26-ae71-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05669f26-ae71-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_990e0778-94d9-4a9c-a5ce-29a3e517f9ac_SESS_c6ceec92-b632-4832-a472-65c076613b60_TOSC_7ee335d7-28dd-451b-b729-d20cfdc46545_SNAPS_','2021-05-06 13:30:10','2021-05-06 15:30:09','05669f26-ae71-11eb-9377-226cec7cb58a.png','2021-05-06 15:30:10','SYNCED','05669f26-ae71-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.143.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0566e696-a674-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0566e696-a674-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_0f6f5d9e-5919-4328-8a3c-f4137207e768_SESS_9c1305c5-f9e6-4f8f-9130-f13a12247bac_BOSC_6d4c9a8c-fb48-42ed-a9eb-5734588f24b4_SNAPS_','2021-04-26 09:43:59','2021-04-26 11:43:58','0566e696-a674-11eb-9377-226cec7cb58a.png','2021-04-26 11:43:59','SYNCED','0566e696-a674-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.101.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0567ae53-b458-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0567ae53-b458-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_55452abe-c899-4508-a6ad-a6862da81096_ACT_f590af08-ea0d-4176-af23-aa19fbbc81bd_SESS_1d2eedba-7320-43b2-9232-c9ff66bfa1bc_TOSC_8b3a6976-8e6c-4ffd-9532-153cb838f7ab_SNAPS_','2020-12-08 17:25:32','2020-06-19 16:04:19','0567ae53-b458-11ea-947d-226cec7cb58a.png','2020-12-08 18:25:32','SYNCED','0567ae53-b458-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 32.1.2.1.4\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0569654e-a674-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0569654e-a674-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_0f6f5d9e-5919-4328-8a3c-f4137207e768_SESS_9c1305c5-f9e6-4f8f-9130-f13a12247bac_TOSC_1f20f464-95c4-4005-a802-2db7ba45f3de_SNAPS_','2021-04-26 09:36:30','2021-04-26 11:36:26','0569654e-a674-11eb-9377-226cec7cb58a.png','2021-04-26 11:36:30','SYNCED','0569654e-a674-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.101.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'056975a8-ae71-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/056975a8-ae71-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_990e0778-94d9-4a9c-a5ce-29a3e517f9ac_SESS_c6ceec92-b632-4832-a472-65c076613b60_BOSC_915f0f12-a869-4799-998e-90d841e43653_SNAPS_','2021-05-06 13:39:08','2021-05-06 15:39:07','056975a8-ae71-11eb-9377-226cec7cb58a.png','2021-05-06 15:39:08','SYNCED','056975a8-ae71-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.143.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0569b563-b458-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0569b563-b458-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_55452abe-c899-4508-a6ad-a6862da81096_ACT_f590af08-ea0d-4176-af23-aa19fbbc81bd_SESS_1d2eedba-7320-43b2-9232-c9ff66bfa1bc_TOSC_8b85d5a4-dd79-457b-9852-56c8768536a0_SNAPS_','2020-12-08 17:25:32','2020-06-19 15:59:12','0569b563-b458-11ea-947d-226cec7cb58a.png','2020-12-08 18:25:32','SYNCED','0569b563-b458-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 32.1.2.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'056b1ec9-4c92-41b6-82c7-7b16e6b36a3c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/056b1ec9-4c92-41b6-82c7-7b16e6b36a3c.png','SNAPS','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_ab66693b-09f2-4d4b-a830-b9ae3e00e2fb_SESS_97039037-c1d2-4de4-af88-846a17da426f_TOSC_3ed48739-4129-4286-b1ff-1d52cde23cfe_SNAPS_','2020-12-07 12:00:32','2020-08-12 15:45:56','056b1ec9-4c92-41b6-82c7-7b16e6b36a3c.png','2020-12-07 13:00:32','SYNCED','056b1ec9-4c92-41b6-82c7-7b16e6b36a3c',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.26.8.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'056bf7b7-a674-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/056bf7b7-a674-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_0f6f5d9e-5919-4328-8a3c-f4137207e768_SESS_9c1305c5-f9e6-4f8f-9130-f13a12247bac_TOSC_40878156-a986-40e4-b5c5-ad38a4c9fed4_SNAPS_','2021-04-26 09:33:42','2021-04-26 11:33:41','056bf7b7-a674-11eb-9377-226cec7cb58a.png','2021-04-26 11:33:42','SYNCED','056bf7b7-a674-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.101.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'056c5ba8-ae71-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/056c5ba8-ae71-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_990e0778-94d9-4a9c-a5ce-29a3e517f9ac_SESS_c6ceec92-b632-4832-a472-65c076613b60_BOSC_915f0f12-a869-4799-998e-90d841e43653_PLY_','2021-05-06 13:39:08','2021-05-06 15:39:07','056c5ba8-ae71-11eb-9377-226cec7cb58a.ply','2021-05-06 15:39:08','SYNCED','056c5ba8-ae71-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.143.1.2\",\"modelMatrix\":\"-0.969866,-0.213529,0.117326,0,0.243639,-0.850005,0.467046,0,1.10602e-9,0.481557,0.876415,0,-27.0449,0.953867,-17.8826,1\",\"title\":\"Mandibule PLY\"}'),(2,'056e8285-a674-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/056e8285-a674-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_0f6f5d9e-5919-4328-8a3c-f4137207e768_SESS_9c1305c5-f9e6-4f8f-9130-f13a12247bac_BOSC_b0037503-a60f-4612-9a3d-577ba6146004_PLY_','2021-04-26 09:39:48','2021-04-26 11:39:46','056e8285-a674-11eb-9377-226cec7cb58a.ply','2021-04-26 11:39:48','SYNCED','056e8285-a674-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.101.1.1\",\"modelMatrix\":\"-0.398676,-0.915435,0.0551087,0,0.917092,-0.397955,0.0239567,0,2.89045e-9,0.0600907,0.998193,0,-17.3795,-4.30682,-18.8804,1\",\"title\":\"Mandibule PLY\"}'),(2,'056f3581-ae71-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/056f3581-ae71-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_990e0778-94d9-4a9c-a5ce-29a3e517f9ac_SESS_c6ceec92-b632-4832-a472-65c076613b60_BOSC_e0f00f76-aa45-4cf0-850c-2a251c0f1069_SNAPS_','2021-05-06 13:35:23','2021-05-06 15:35:22','056f3581-ae71-11eb-9377-226cec7cb58a.png','2021-05-06 15:35:23','SYNCED','056f3581-ae71-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.143.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0570f61c-a674-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0570f61c-a674-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_0f6f5d9e-5919-4328-8a3c-f4137207e768_SESS_9c1305c5-f9e6-4f8f-9130-f13a12247bac_TOSC_db857767-7ac9-4fdf-8734-9dc9826d07bd_PLY_','2021-04-26 09:28:58','2021-04-26 11:28:56','0570f61c-a674-11eb-9377-226cec7cb58a.ply','2021-04-26 11:28:58','SYNCED','0570f61c-a674-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.101.1.1\",\"modelMatrix\":\"0.857767,-0.448138,0.251807,0,0.514038,0.747802,-0.420187,0,-1.41223e-8,0.489861,0.8718,0,11.7901,-32.226,-22.4754,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0572076d-ae71-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0572076d-ae71-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_990e0778-94d9-4a9c-a5ce-29a3e517f9ac_SESS_c6ceec92-b632-4832-a472-65c076613b60_TOSC_86321f6f-5aa0-4319-b082-f68653d73d99_PLY_','2021-05-06 13:27:40','2021-05-06 15:27:37','0572076d-ae71-11eb-9377-226cec7cb58a.ply','2021-05-06 15:27:40','SYNCED','0572076d-ae71-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.143.1.1\",\"modelMatrix\":\"0.620574,-0.718164,0.314846,0,0.784148,0.568355,-0.249169,0,5.6323e-9,0.401514,0.915853,0,4.89559,-35.8462,-23.2888,1\",\"title\":\"Maxillaire PLY\"}'),(2,'05735932-a674-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05735932-a674-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_0f6f5d9e-5919-4328-8a3c-f4137207e768_SESS_9c1305c5-f9e6-4f8f-9130-f13a12247bac_TOSC_40878156-a986-40e4-b5c5-ad38a4c9fed4_PLY_','2021-04-26 09:36:30','2021-04-26 11:34:12','05735932-a674-11eb-9377-226cec7cb58a.ply','2021-04-26 11:36:30','SYNCED','05735932-a674-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.101.1.2\",\"modelMatrix\":\"0.898636,-0.403618,0.171892,0,0.438696,0.826781,-0.352107,0,1.00347e-8,0.391824,0.92004,0,12.8138,-31.0224,-23.4473,1\",\"title\":\"Maxillaire PLY\"}'),(2,'05755e4b-ae71-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05755e4b-ae71-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_990e0778-94d9-4a9c-a5ce-29a3e517f9ac_SESS_c6ceec92-b632-4832-a472-65c076613b60_TOSC_86321f6f-5aa0-4319-b082-f68653d73d99_SNAPS_','2021-05-06 13:27:38','2021-05-06 15:27:37','05755e4b-ae71-11eb-9377-226cec7cb58a.png','2021-05-06 15:27:38','SYNCED','05755e4b-ae71-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.143.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0575c532-ee5c-4204-adb3-37ddf2f3e229','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0575c532-ee5c-4204-adb3-37ddf2f3e229.png','SNAPS','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_db56cba1-23ff-48bf-b86e-4ceff749087f_TOSC_98d2d011-681b-459b-9f74-1d29047fb345_SNAPS_','2021-12-07 08:39:13','2019-11-14 15:15:13','0575c532-ee5c-4204-adb3-37ddf2f3e229.png','2021-12-07 09:39:13','SYNCED','0575c532-ee5c-4204-adb3-37ddf2f3e229',0,NULL,'','','{\"displayTitle\":\"Mascella 0\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0575e3b8-a674-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0575e3b8-a674-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_0f6f5d9e-5919-4328-8a3c-f4137207e768_SESS_9c1305c5-f9e6-4f8f-9130-f13a12247bac_BOSC_9e93f5e3-2954-4068-9f9c-cb9b1ef8db95_SNAPS_','2021-04-26 09:41:48','2021-04-26 11:41:47','0575e3b8-a674-11eb-9377-226cec7cb58a.png','2021-04-26 11:41:48','SYNCED','0575e3b8-a674-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.101.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'05780bc0-ae71-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05780bc0-ae71-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_990e0778-94d9-4a9c-a5ce-29a3e517f9ac_SESS_c6ceec92-b632-4832-a472-65c076613b60_BOSC_cd692edf-b492-479e-b55d-e2a3dded11cd_PLY_','2021-05-06 13:43:03','2021-05-06 15:43:02','05780bc0-ae71-11eb-9377-226cec7cb58a.ply','2021-05-06 15:43:03','SYNCED','05780bc0-ae71-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.143.1.3\",\"modelMatrix\":\"-0.90865,-0.407084,0.0929416,0,0.417559,-0.885855,0.20225,0,-4.49441e-9,0.222583,0.974914,0,-21.612,4.78308,-17.4181,1\",\"title\":\"Mandibule PLY\"}'),(2,'0578d9f9-a674-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0578d9f9-a674-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_0f6f5d9e-5919-4328-8a3c-f4137207e768_SESS_9c1305c5-f9e6-4f8f-9130-f13a12247bac_TOSC_1f20f464-95c4-4005-a802-2db7ba45f3de_PLY_','2021-04-26 09:39:47','2021-04-26 11:37:21','0578d9f9-a674-11eb-9377-226cec7cb58a.ply','2021-04-26 11:39:47','SYNCED','0578d9f9-a674-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.101.1.3\",\"modelMatrix\":\"0.814229,-0.513171,0.271454,0,0.580544,0.719736,-0.380721,0,-1.28304e-8,0.467585,0.883948,0,7.39822,-31.1296,-20.5662,1\",\"title\":\"Maxillaire PLY\"}'),(2,'057b42d2-ae71-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/057b42d2-ae71-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_990e0778-94d9-4a9c-a5ce-29a3e517f9ac_SESS_c6ceec92-b632-4832-a472-65c076613b60_TOSC_7ee335d7-28dd-451b-b729-d20cfdc46545_PLY_','2021-05-06 13:30:10','2021-05-06 15:30:09','057b42d2-ae71-11eb-9377-226cec7cb58a.ply','2021-05-06 15:30:10','SYNCED','057b42d2-ae71-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.143.1.2\",\"modelMatrix\":\"0.672862,-0.670482,0.312586,0,0.739768,0.609842,-0.284315,0,1.40657e-8,0.422547,0.906341,0,4.71937,-33.2597,-23.0012,1\",\"title\":\"Maxillaire PLY\"}'),(2,'057e8837-ae71-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/057e8837-ae71-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_990e0778-94d9-4a9c-a5ce-29a3e517f9ac_SESS_c6ceec92-b632-4832-a472-65c076613b60_BOSC_cd692edf-b492-479e-b55d-e2a3dded11cd_SNAPS_','2021-05-06 13:43:03','2021-05-06 15:43:02','057e8837-ae71-11eb-9377-226cec7cb58a.png','2021-05-06 15:43:03','SYNCED','057e8837-ae71-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.143.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'057ecc11-e2c0-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/057ecc11-e2c0-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_4e982f06-0694-4d7a-880f-b38f44a5a687_SESS_4fbe8cc6-0004-4169-9d18-35e9e2666af2_TOSC_9a4b4d74-f739-4338-9f1d-d809e08fff32_SNAPS_','2020-12-07 12:00:33','2020-08-20 10:34:26','057ecc11-e2c0-11ea-947d-226cec7cb58a.png','2020-12-07 13:00:33','SYNCED','057ecc11-e2c0-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.26.32.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0580cf70-e2c0-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0580cf70-e2c0-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_4e982f06-0694-4d7a-880f-b38f44a5a687_SESS_4fbe8cc6-0004-4169-9d18-35e9e2666af2_TOSC_9a4b4d74-f739-4338-9f1d-d809e08fff32_PLY_','2020-12-07 12:00:33','2020-08-20 10:34:26','0580cf70-e2c0-11ea-947d-226cec7cb58a.ply','2020-12-07 13:00:33','SYNCED','0580cf70-e2c0-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.26.32.1.1\",\"modelMatrix\":\"0.698711,-0.670714,0.24889,0,0.715405,0.655063,-0.243083,0,-1.47446e-8,0.347902,0.937531,0,1.31579,-30.8325,-18.7463,1\",\"title\":\"Maxillaire PLY\"}'),(2,'05839b63-fa5f-4961-ba6b-658448303dc1','','ZIP','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_ce690655-bec7-46d5-bd7c-187550233f81_SESS_63d135d7-8c41-4dac-9114-2987aea6980f_TOSC_f30b6bd1-f166-4175-85cd-bb140dc12b3e_ZIP_','2021-09-28 15:15:32','2021-09-28 17:15:29','','2021-09-28 17:15:32','SYNCED','05839b63-fa5f-4961-ba6b-658448303dc1',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.3.22.33.1.2\",\"modelMatrix\":\"0.0763271,0.855492,-0.51216,0,-0.997083,0.0654883,-0.039206,0,2.70108e-11,0.513658,0.857995,0,-20.3093,-31.6819,-11.2027,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'0584ae39-541e-49fb-9985-7e4d4f11c5a1','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0584ae39-541e-49fb-9985-7e4d4f11c5a1.ply','PLY','PATIENT_3ad9cfe2-ced1-4335-8486-de64579500c5_ACT_0e611a8f-0067-46b6-bc16-dacc1c9e98bd_SESS_b1a878c4-ee6a-43fb-a324-98539f51a4d1_BOSC_22f26f4f-6203-49e5-90fa-3dc0f932794c_PLY_','2020-12-29 09:24:21','2020-12-29 10:21:12','0584ae39-541e-49fb-9985-7e4d4f11c5a1.ply','2020-12-29 10:24:21','SYNCED','0584ae39-541e-49fb-9985-7e4d4f11c5a1',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.50.1.2\",\"modelMatrix\":\"-0.987416,0.156613,-0.0219506,0,-0.158144,-0.977858,0.137055,0,2.93081e-10,0.138802,0.99032,0,-11.4948,15.9695,-19.5803,1\",\"title\":\"Mandibule PLY\"}'),(2,'058f1b61-1b86-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/058f1b61-1b86-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_e3fabe3e-78bc-46f6-916d-f5ab3c906e6e_SESS_a2b793ce-4a77-415b-afdb-290379922784_TOSC_3b978bd9-75ba-4885-9053-6196e27eb3eb_ZIP_','2021-09-22 08:31:11','2021-09-22 10:31:07','058f1b61-1b86-11ec-9377-226cec7cb58a.zip','2021-09-22 10:31:11','SYNCED','058f1b61-1b86-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.3.22.25.1.1\",\"modelMatrix\":\"0.0709463,0.880333,-0.469021,0,-0.99748,0.0626141,-0.0333593,0,-4.2752e-9,0.470205,0.882557,0,-14.7842,-36.5305,-10.8867,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'059312d2-4e76-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/059312d2-4e76-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_e67c44fa-320d-4cec-929c-0fac66b8a7ca_SESS_584f4de7-5dda-471a-8bd1-a202eb080ef8_BOSC_a839179b-0053-4b45-954c-a0b9c9e06bd4_SNAPS_','2020-12-16 10:51:33','2020-02-12 10:43:23','059312d2-4e76-11ea-947d-226cec7cb58a.png','2020-12-16 11:51:33','SYNCED','059312d2-4e76-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'05932082-1b86-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05932082-1b86-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_e3fabe3e-78bc-46f6-916d-f5ab3c906e6e_SESS_a2b793ce-4a77-415b-afdb-290379922784_BOSC_f36097a4-9e1d-4428-81de-e78978e8f441_SNAPS_','2021-09-22 09:04:03','2021-09-22 11:03:59','05932082-1b86-11ec-9377-226cec7cb58a.png','2021-09-22 11:04:03','SYNCED','05932082-1b86-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.22.25.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'059549a1-4e76-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/059549a1-4e76-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_e67c44fa-320d-4cec-929c-0fac66b8a7ca_SESS_584f4de7-5dda-471a-8bd1-a202eb080ef8_BOSC_a839179b-0053-4b45-954c-a0b9c9e06bd4_PLY_','2020-12-16 10:51:34','2020-02-12 10:43:23','059549a1-4e76-11ea-947d-226cec7cb58a.ply','2020-12-16 11:51:34','SYNCED','059549a1-4e76-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"modelMatrix\":\"-0.624188,0.772523,-0.116608,0,-0.781274,-0.617196,0.093162,0,4.23084e-9,0.149253,0.988799,0,6.53274,19.1368,-15.6158,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'05971abb-575f-45bf-b722-b552c1326f73','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05971abb-575f-45bf-b722-b552c1326f73.png','SNAPS','PATIENT_bbd4e212-1201-4bce-b1de-a2494ec3f418_ACT_2ddf9f74-937c-4089-a4f1-5e46b8faffd4_SESS_982962a5-ec57-4402-b8fd-6e8652ccde33_TOSC_894acb19-69ae-4b0a-a9df-303f5f6f11f1_SNAPS_','2021-01-19 15:02:46','2021-01-19 15:38:05','05971abb-575f-45bf-b722-b552c1326f73.png','2021-01-19 16:02:46','SYNCED','05971abb-575f-45bf-b722-b552c1326f73',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.14.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0598e767-1b86-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0598e767-1b86-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_e3fabe3e-78bc-46f6-916d-f5ab3c906e6e_SESS_a2b793ce-4a77-415b-afdb-290379922784_TOSC_0523afed-2c23-416d-8bb6-ce2c83a606e8_SNAPS_','2021-09-22 08:35:29','2021-09-22 10:35:21','0598e767-1b86-11ec-9377-226cec7cb58a.png','2021-09-22 10:35:29','SYNCED','0598e767-1b86-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.3.22.25.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'059a1f48-d5a7-49e7-9654-a836345e240b','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/059a1f48-d5a7-49e7-9654-a836345e240b.ply','PLY','PATIENT_f9067b2a-2220-4c45-b359-06fe6f75333a_ACT_ffa3979e-477a-4285-83c7-4c2aabc66158_SESS_7a465a8d-b69a-4fc2-b90f-51dd805cc0ef_TOSC_e5fbec3c-413d-431f-af01-7a02733d4ced_PLY_','2020-12-30 14:43:55','2020-12-30 15:22:10','059a1f48-d5a7-49e7-9654-a836345e240b.ply','2020-12-30 15:43:55','SYNCED','059a1f48-d5a7-49e7-9654-a836345e240b',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.36.62.1.2\",\"modelMatrix\":\"0.795175,-0.550634,0.253967,0,0.60638,0.722072,-0.333038,0,-1.4637e-8,0.418824,0.908068,0,7.34534,-27.8308,-18.9147,1\",\"title\":\"Maxillaire PLY\"}'),(2,'059cb7b1-1b86-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/059cb7b1-1b86-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_e3fabe3e-78bc-46f6-916d-f5ab3c906e6e_SESS_a2b793ce-4a77-415b-afdb-290379922784_BOSC_f36097a4-9e1d-4428-81de-e78978e8f441_ZIP_','2021-09-22 09:04:03','2021-09-22 11:04:00','059cb7b1-1b86-11ec-9377-226cec7cb58a.zip','2021-09-22 11:04:03','SYNCED','059cb7b1-1b86-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.22.25.1.3\",\"modelMatrix\":\"0.986248,0.160694,-0.0386187,0,-0.165269,0.958945,-0.230459,0,3.6724e-12,0.233672,0.972315,0,-27.2332,13.5754,-20.5967,1\",\"title\":\"Mandibule ZIP\"}'),(2,'05a05fb0-3065-45b8-b2e9-73a5f61a68d8','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05a05fb0-3065-45b8-b2e9-73a5f61a68d8.ply','PLY','PATIENT_3b6c641e-e0e0-4ac9-a267-62cd4bf53002_ACT_9f504d88-30d7-4cc8-8a7b-e1a782b7333d_SESS_06405aeb-31bb-4979-8850-9a8d7791d3f5_BOSC_694acae1-ce4b-4771-bbad-31c5138b919a_PLY_','2021-03-11 13:53:38','2021-03-11 14:45:32','05a05fb0-3065-45b8-b2e9-73a5f61a68d8.ply','2021-03-11 14:53:38','SYNCED','05a05fb0-3065-45b8-b2e9-73a5f61a68d8',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.72.1.2\",\"modelMatrix\":\"0.425478,-0.903544,0.0507572,0,0.904969,0.424808,-0.0238638,0,1.26279e-9,0.0560872,0.998426,0,-8.3822,-21.7734,-19.0048,1\",\"title\":\"Mandibule PLY\"}'),(2,'05a07ace-1b86-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05a07ace-1b86-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_e3fabe3e-78bc-46f6-916d-f5ab3c906e6e_SESS_a2b793ce-4a77-415b-afdb-290379922784_BOSC_f034b2db-0fd9-4910-aa0e-ce77f04eec5b_SNAPS_','2021-09-22 08:54:40','2021-09-22 10:54:33','05a07ace-1b86-11ec-9377-226cec7cb58a.png','2021-09-22 10:54:40','SYNCED','05a07ace-1b86-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.22.25.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'05a430b8-1b86-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05a430b8-1b86-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_e3fabe3e-78bc-46f6-916d-f5ab3c906e6e_SESS_a2b793ce-4a77-415b-afdb-290379922784_TOSC_eccc81af-f817-4ced-a973-173203b5e134_SNAPS_','2021-09-22 08:40:12','2021-09-22 10:40:07','05a430b8-1b86-11ec-9377-226cec7cb58a.png','2021-09-22 10:40:12','SYNCED','05a430b8-1b86-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.3.22.25.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'05a790e6-4522-4e4d-a3aa-50954d8ecea7','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05a790e6-4522-4e4d-a3aa-50954d8ecea7.png','SNAPS','PATIENT_6592423c-c895-4f90-ae97-d29a34961d34_ACT_6628cbc8-0118-491e-93d0-25211a465bc4_SESS_6e23570d-ebd1-4a63-9ffe-aa47019113cd_TOSC_457faa66-0e03-48aa-8993-67dd0d38bb88_SNAPS_','2022-03-04 13:40:22','2019-07-09 13:14:08','05a790e6-4522-4e4d-a3aa-50954d8ecea7.png','2022-03-04 14:40:22','SYNCED','05a790e6-4522-4e4d-a3aa-50954d8ecea7',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 11.2.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'05a82aa9-1b86-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05a82aa9-1b86-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_e3fabe3e-78bc-46f6-916d-f5ab3c906e6e_SESS_a2b793ce-4a77-415b-afdb-290379922784_TOSC_3b978bd9-75ba-4885-9053-6196e27eb3eb_SNAPS_','2021-09-22 08:31:11','2021-09-22 10:31:06','05a82aa9-1b86-11ec-9377-226cec7cb58a.png','2021-09-22 10:31:11','SYNCED','05a82aa9-1b86-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.3.22.25.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'05aba5aa-1b86-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05aba5aa-1b86-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_e3fabe3e-78bc-46f6-916d-f5ab3c906e6e_SESS_a2b793ce-4a77-415b-afdb-290379922784_TOSC_0523afed-2c23-416d-8bb6-ce2c83a606e8_ZIP_','2021-09-22 08:35:28','2021-09-22 10:35:23','05aba5aa-1b86-11ec-9377-226cec7cb58a.zip','2021-09-22 10:35:28','SYNCED','05aba5aa-1b86-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.3.22.25.1.2\",\"modelMatrix\":\"0.00598739,0.888212,-0.459395,0,-0.999982,0.00531817,-0.00275062,0,-1.45899e-11,0.459403,0.888228,0,-13.4382,-38.7015,-11.0139,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'05abdc47-105e-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05abdc47-105e-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_fd694b3f-abde-4e46-91f7-7c62bfdcafa4_SESS_73a3f5b9-e905-4911-a163-2022e1de3380_TOSC_e19a083d-61ad-4910-8a4a-2676147e39fe_SNAPS_','2021-08-05 07:30:41','2019-11-26 16:00:47','05abdc47-105e-11ea-947d-226cec7cb58a.png','2021-08-05 09:30:41','SYNCED','05abdc47-105e-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'05ad6cf6-105e-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05ad6cf6-105e-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_fd694b3f-abde-4e46-91f7-7c62bfdcafa4_SESS_73a3f5b9-e905-4911-a163-2022e1de3380_TOSC_e19a083d-61ad-4910-8a4a-2676147e39fe_PLY_','2021-08-05 07:30:41','2019-11-26 16:00:47','05ad6cf6-105e-11ea-947d-226cec7cb58a.ply','2021-08-05 09:30:41','SYNCED','05ad6cf6-105e-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"modelMatrix\":\"0.812499,-0.533535,0.234916,0,0.582962,0.74361,-0.327413,0,1.71683e-8,0.40297,0.915213,0,9.90536,-33.4042,-14.2184,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'05aef557-105e-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05aef557-105e-11ea-947d-226cec7cb58a.stl','STL','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_fd694b3f-abde-4e46-91f7-7c62bfdcafa4_SESS_73a3f5b9-e905-4911-a163-2022e1de3380_TOSC_e19a083d-61ad-4910-8a4a-2676147e39fe_STL_','2021-08-05 07:30:41','2019-11-26 16:00:47','05aef557-105e-11ea-947d-226cec7cb58a.stl','2021-08-05 09:30:41','SYNCED','05aef557-105e-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"modelMatrix\":\"0.812499,-0.533535,0.234916,0,0.582962,0.74361,-0.327413,0,1.71683e-8,0.40297,0.915213,0,9.90536,-33.4042,-14.2184,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'05af4c06-1b86-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05af4c06-1b86-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_e3fabe3e-78bc-46f6-916d-f5ab3c906e6e_SESS_a2b793ce-4a77-415b-afdb-290379922784_BOSC_f034b2db-0fd9-4910-aa0e-ce77f04eec5b_ZIP_','2021-09-22 08:54:37','2021-09-22 10:54:34','05af4c06-1b86-11ec-9377-226cec7cb58a.zip','2021-09-22 10:54:37','SYNCED','05af4c06-1b86-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.22.25.1.1\",\"modelMatrix\":\"0.954205,0.297963,-0.0266591,0,-0.299153,0.950409,-0.0850342,0,-1.4509e-10,0.0891152,0.996021,0,-25.6892,8.35468,-17.5713,1\",\"title\":\"Mandibule ZIP\"}'),(2,'05b320fa-1b86-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05b320fa-1b86-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_e3fabe3e-78bc-46f6-916d-f5ab3c906e6e_SESS_a2b793ce-4a77-415b-afdb-290379922784_BOSC_ab063f99-4e86-489c-9c84-c303723b0638_ZIP_','2021-09-22 09:12:07','2021-09-22 11:12:04','05b320fa-1b86-11ec-9377-226cec7cb58a.zip','2021-09-22 11:12:07','SYNCED','05b320fa-1b86-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.22.25.1.4\",\"modelMatrix\":\"0.995637,0.0892625,-0.0271725,0,-0.0933067,0.952483,-0.289946,0,7.47e-10,0.291217,0.956657,0,-20.345,12.1044,-19.2229,1\",\"title\":\"Mandibule ZIP\"}'),(2,'05b6f801-1b86-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05b6f801-1b86-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_e3fabe3e-78bc-46f6-916d-f5ab3c906e6e_SESS_a2b793ce-4a77-415b-afdb-290379922784_TOSC_eccc81af-f817-4ced-a973-173203b5e134_ZIP_','2021-09-22 08:40:11','2021-09-22 10:40:08','05b6f801-1b86-11ec-9377-226cec7cb58a.zip','2021-09-22 10:40:11','SYNCED','05b6f801-1b86-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.3.22.25.1.3\",\"modelMatrix\":\"-0.051454,0.872257,-0.486334,0,-0.998675,-0.0449406,0.025057,0,5.81731e-10,0.486979,0.873413,0,-17.1753,-35.2933,-11.7196,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'05ba64d4-1b86-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05ba64d4-1b86-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_e3fabe3e-78bc-46f6-916d-f5ab3c906e6e_SESS_a2b793ce-4a77-415b-afdb-290379922784_BOSC_ab063f99-4e86-489c-9c84-c303723b0638_SNAPS_','2021-09-22 09:12:07','2021-09-22 11:12:03','05ba64d4-1b86-11ec-9377-226cec7cb58a.png','2021-09-22 11:12:07','SYNCED','05ba64d4-1b86-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.22.25.1.4\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'05bd2d42-7573-46aa-ab15-885cb56d17f3','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05bd2d42-7573-46aa-ab15-885cb56d17f3.png','SNAPS','PATIENT_2723e13b-24b4-474f-97a7-0d782b6e6f62_ACT_1b19b5ef-5efa-43cf-9f25-74f18102addf_SESS_3f05bea5-6f8a-4370-8c23-525f24a560f5_BOSC_e6b7640d-ddc0-4b6b-a06e-2bd94639bdb2_SNAPS_','2020-11-25 10:33:16','2020-11-25 11:33:15','05bd2d42-7573-46aa-ab15-885cb56d17f3.png','2020-11-25 11:33:16','SYNCED','05bd2d42-7573-46aa-ab15-885cb56d17f3',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.67.1.1.17\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'05bdb6f7-1ff7-4e46-9625-c4219d557f38','','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_46a43677-79f5-4380-978e-b4c0a828359c_SESS_aaa55e0a-27fc-41a1-bbb1-2c4ece8d0301_TOSC_b204a7ca-26e5-4d59-948e-618ec649a0df_PLY_','2021-04-27 11:43:10','2021-04-27 13:43:08','','2021-04-27 13:43:10','SYNCED','05bdb6f7-1ff7-4e46-9625-c4219d557f38',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.114.1.2\",\"modelMatrix\":\"0.781766,-0.543297,0.306055,0,0.623572,0.681127,-0.383699,0,8.62637e-9,0.49081,0.871267,0,12.93,-39.6335,-24.1122,1\",\"title\":\"Maxillaire PLY\"}'),(2,'05c075c8-cb33-41c2-b465-ad4a47b94914','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05c075c8-cb33-41c2-b465-ad4a47b94914.png','SNAPS','PATIENT_e6fbcde1-419a-40a3-94bc-3b9e3d5fbdd1_ACT_30f278da-08b7-477b-a7eb-7b521d5284c0_SESS_8ddfebd4-f167-4d55-9345-caaa6f426341_TOSC_a2cf68da-9724-498a-9a3b-7ac16319411f_SNAPS_','2021-03-11 09:23:31','2021-03-10 16:16:30','05c075c8-cb33-41c2-b465-ad4a47b94914.png','2021-03-11 10:23:31','SYNCED','05c075c8-cb33-41c2-b465-ad4a47b94914',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.71.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'05c19518-b190-4426-ab89-a0202b41adb8','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05c19518-b190-4426-ab89-a0202b41adb8.png','SNAPS','PATIENT_74341905-5b86-4180-9dd8-e689d6ed33e3_ACT_959ae692-c0ad-4eea-94fd-cc2e30eeed43_SESS_35fc8e2a-49eb-4e3f-a21a-ce61a5a33aa4_TOSC_6f41aebe-658f-4da7-b488-94c69caff6b7_SNAPS_','2020-12-18 15:29:57','2020-12-18 16:18:55','05c19518-b190-4426-ab89-a0202b41adb8.png','2020-12-18 16:29:57','SYNCED','05c19518-b190-4426-ab89-a0202b41adb8',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.36.45.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'05c23165-9b27-44d2-a2d5-fdabbb8ecdde','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05c23165-9b27-44d2-a2d5-fdabbb8ecdde.png','SNAPS','PATIENT_646c094b-bf87-4519-b09e-91d893e678c2_ACT_21ff3681-9b45-4eee-8e11-e33d469644a4_SESS_a6d0b662-6c60-45a5-954a-e05433afaa4d_TOSC_1754f902-36cd-4996-8aaf-124e27f2de74_SNAPS_','2021-03-30 07:57:34','2021-03-30 09:47:54','05c23165-9b27-44d2-a2d5-fdabbb8ecdde.png','2021-03-30 09:57:34','SYNCED','05c23165-9b27-44d2-a2d5-fdabbb8ecdde',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.16.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'05caca0f-3b10-4228-914c-c378834c7b2a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05caca0f-3b10-4228-914c-c378834c7b2a.stl','STL','PATIENT_dfbf8ad5-0860-4209-8b85-003bb4250cea_ACT_8cf2d43b-73ce-4c11-9178-da113e274d32_SESS_b49d130d-87ee-424a-9a76-0420a20e43ad_TOSC_8370aa9d-f601-405d-b4ad-04ba67eedf23_STL_','2021-12-07 08:39:13','2019-08-27 10:31:44','05caca0f-3b10-4228-914c-c378834c7b2a.stl','2021-12-07 09:39:13','SYNCED','8db23c6e-b97d-4ddc-a1cb-a99e972e5f54',2,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 133.1.1.1\",\"modelMatrix\":\"0.892058,-0.420264,0.166163,0,0.45192,0.829571,-0.327993,0,1.40793e-8,0.367681,0.929952,0,10.6768,-36.1223,-16.9831,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'05cf745d-b9e4-4bb1-bb01-81bc64d8d291','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05cf745d-b9e4-4bb1-bb01-81bc64d8d291.ply','PLY','PATIENT_6fbef17a-e01a-4300-aba6-4e50b486f9f0_ACT_8063e0e7-21c7-4245-b3d7-f8a8d363b4be_SESS_fa5ac751-1bae-4b58-b37f-00cc2d53ead7_BOSC_e20d10d4-0eed-4fbb-b430-df8d98c091df_PLY_','2021-03-23 13:09:58','2021-03-23 14:06:48','05cf745d-b9e4-4bb1-bb01-81bc64d8d291.ply','2021-03-23 14:09:58','SYNCED','05cf745d-b9e4-4bb1-bb01-81bc64d8d291',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.106.1.2\",\"modelMatrix\":\"-0.669281,-0.725818,0.158906,0,0.74301,-0.653795,0.143138,0,2.63514e-9,0.213868,0.976863,0,-27.1258,-5.38967,-19.8387,1\",\"title\":\"Mandibule PLY\"}'),(2,'05d7c128-146d-4399-8a0f-7564363f79b0','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05d7c128-146d-4399-8a0f-7564363f79b0.ply','PLY','PATIENT_5f861654-dd88-4404-b6ce-ab61dd80d65a_ACT_283ffdd7-9872-400e-8864-ceb7a283e06c_SESS_053ae2bd-f330-4080-9666-9491f24cbd51_TOSC_d0ec3bf9-0b1d-4ac2-953b-6e06c3399146_PLY_','2021-12-07 08:39:13','2019-09-03 11:40:46','05d7c128-146d-4399-8a0f-7564363f79b0.ply','2021-12-07 09:39:13','SYNCED','05d7c128-146d-4399-8a0f-7564363f79b0',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 142.1.1.1\",\"modelMatrix\":\"0.497483,-0.760571,0.417185,0,0.867474,0.436175,-0.239249,0,-7.18833e-10,0.480919,0.876765,0,-1.44043,-33.7094,-16.4454,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'05dba170-2610-464c-bd48-c4b2d0848609','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05dba170-2610-464c-bd48-c4b2d0848609.png','SNAPS','PATIENT_e3fa8bf8-1cee-48c7-a3f5-07478493ec6a_ACT_614c2222-ba8b-4c16-81a7-97d232a666ef_SESS_bec5fcc6-4d9e-4ee7-9f3a-c5f17e1ec08d_TOSC_6455871b-9d0c-4146-991a-7ad17e6ac598_SNAPS_','2021-02-12 14:10:49','2021-02-12 14:59:26','05dba170-2610-464c-bd48-c4b2d0848609.png','2021-02-12 15:10:49','SYNCED','05dba170-2610-464c-bd48-c4b2d0848609',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.40.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'05ec1b46-2050-4be9-be12-817f265a328d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05ec1b46-2050-4be9-be12-817f265a328d.png','SNAPS','PATIENT_bfff99cf-e91f-4eed-bb3a-06bece8eaf9f_ACT_ee7a5012-1ec5-43b8-82bd-f42cb859f757_SESS_0b92af6d-d56a-4d56-941a-44824081e629_BOSC_dad20e14-4c4a-4ce3-8d10-65382dc7bdfc_SNAPS_','2021-06-07 11:39:06','2019-12-18 13:42:54','05ec1b46-2050-4be9-be12-817f265a328d.png','2021-06-07 13:39:06','SYNCED','05ec1b46-2050-4be9-be12-817f265a328d',0,'2021-06-07 13:39:06','','','{\"displayTitle\":\"MANDIBULE 20.1.268.1.1.2\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'05eefaa6-45b9-46c4-8a54-9081e076f7ea','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05eefaa6-45b9-46c4-8a54-9081e076f7ea.png','SNAPS','PATIENT_a10e3f5d-314e-4b48-9f85-704e43cd8e68_ACT_c18fcc45-0d8e-4d09-98c9-44de0d8535be_SESS_ccecfdc2-f538-407e-a5e3-2522a945ca39_TOSC_f47aa494-8830-4011-b50d-9159de431d77_SNAPS_','2022-03-04 13:40:22','2019-07-09 15:51:52','05eefaa6-45b9-46c4-8a54-9081e076f7ea.png','2022-03-04 14:40:22','SYNCED','05eefaa6-45b9-46c4-8a54-9081e076f7ea',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 13.3.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'05f04aab-5cac-4302-beeb-322612d5bb54','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05f04aab-5cac-4302-beeb-322612d5bb54.png','SNAPS','PATIENT_196f3637-95c1-4658-beca-3c3b12c69741_ACT_0c1906ae-b137-4388-8a42-0ab9a792bdc7_SESS_0bb91c40-4a67-4087-911f-6c3fe2520568_BOSC_73ab50d8-9dde-4c3d-b28a-46c5a01e3bbd_SNAPS_','2020-12-02 10:32:01','2020-11-03 10:13:09','05f04aab-5cac-4302-beeb-322612d5bb54.png','2020-12-02 11:32:01','SYNCED','05f04aab-5cac-4302-beeb-322612d5bb54',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.1.1.6\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'05fc69ea-2053-4dc8-8ac5-646659032fb3','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/05fc69ea-2053-4dc8-8ac5-646659032fb3.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_2bcb2d5c-f267-4fb1-b3ab-05757e4b389e_SESS_615ce60b-a94d-4c3e-8939-d8d0bd698c89_TOSC_a6a0935a-9cd2-42f9-8078-fc9dda3a5e1b_SNAPS_','2020-12-08 17:25:40','2020-07-06 11:33:09','05fc69ea-2053-4dc8-8ac5-646659032fb3.png','2020-12-08 18:25:40','SYNCED','05fc69ea-2053-4dc8-8ac5-646659032fb3',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.112.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'061a9f24-14a1-44e9-b51b-c7ef092534c2','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/061a9f24-14a1-44e9-b51b-c7ef092534c2.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_58c144fe-8c9c-4f63-9e0e-7b03219c004a_SESS_a4fc02e7-77ba-43ef-93e2-33b52eb59b18_BOSC_648dbeb8-6a06-4ede-9505-19b9bdcf4ad8_SNAPS_','2022-02-23 13:34:39','2022-02-23 14:34:19','061a9f24-14a1-44e9-b51b-c7ef092534c2.png','2022-02-23 14:34:39','SYNCED','061a9f24-14a1-44e9-b51b-c7ef092534c2',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.23.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0628a45c-453f-47cf-9533-b2eb105ee6f7','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0628a45c-453f-47cf-9533-b2eb105ee6f7.zip','ZIP','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_ce690655-bec7-46d5-bd7c-187550233f81_SESS_63d135d7-8c41-4dac-9114-2987aea6980f_BOSC_8b5df360-d700-410d-8c27-c8e7f868232b_ZIP_','2021-09-28 14:56:46','2021-09-28 16:56:43','0628a45c-453f-47cf-9533-b2eb105ee6f7.zip','2021-09-28 16:56:46','SYNCED','0628a45c-453f-47cf-9533-b2eb105ee6f7',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.22.33.1.1\",\"modelMatrix\":\"0.971175,-0.223139,0.0838357,0,0.238369,0.909127,-0.341568,0,-9.39381e-10,0.351706,0.93611,0,-11.9064,18.9652,-20.6831,1\",\"title\":\"Mandibule ZIP\"}'),(2,'0629f91c-ac7c-457e-89dc-680458f958fc','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0629f91c-ac7c-457e-89dc-680458f958fc.ply','PLY','PATIENT_2f6dceee-f79b-4bb5-85f5-1f34af9ce343_ACT_acf65c07-7da6-466d-9343-e002ccf7eec8_SESS_8602d619-adf2-4766-ab48-ee020dce7847_BOSC_34882108-901d-451f-86ca-86f258cf11d6_PLY_','2021-09-17 11:42:45','2021-09-17 13:42:40','0629f91c-ac7c-457e-89dc-680458f958fc.ply','2021-09-17 13:42:45','SYNCED','0629f91c-ac7c-457e-89dc-680458f958fc',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.394.1.1.4\",\"modelMatrix\":\"-0.944023,-0.317071,0.0910351,0,0.329881,-0.907364,0.260516,0,-1.07644e-9,0.275964,0.961168,0,-29.6148,5.9211,-21.5061,1\",\"title\":\"Mandibule PLY\"}'),(2,'062ee129-6acc-460d-8e22-034809eb81aa','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/062ee129-6acc-460d-8e22-034809eb81aa.ply','PLY','PATIENT_e065ef95-3928-430d-bee5-6cc04ce694eb_ACT_ca7776e9-768c-4099-b75f-75f82d1f3a0a_SESS_98910827-d321-4fa7-907a-a15948dc4bfa_TOSC_d7451ff4-edb4-4cb9-b5e2-5ca8f29e1d1e_PLY_','2020-12-07 12:00:35','2020-08-19 14:38:26','062ee129-6acc-460d-8e22-034809eb81aa.ply','2020-12-07 13:00:35','SYNCED','062ee129-6acc-460d-8e22-034809eb81aa',0,NULL,'','','{\"displayTitle\":\"Maxillaire 61.1.10.1.1\",\"modelMatrix\":\"0.74643,-0.636115,0.195448,0,0.665464,0.713511,-0.219228,0,-3.64287e-9,0.293702,0.955897,0,5.56446,-32.954,-18.9035,1\",\"title\":\"Maxillaire PLY\"}'),(2,'062fc25d-a854-42ef-9652-d7f53e20b3a4','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/062fc25d-a854-42ef-9652-d7f53e20b3a4.png','SNAPS','PATIENT_f82bdf23-f527-4499-8b2a-0904e9dfb64b_ACT_2075991e-94c8-49f4-b6c2-d76a08a3a1c1_SESS_b7006968-457e-4a9a-944c-433381865ee3_BOSC_f84c12f7-cd72-4195-b326-fc05de346951_SNAPS_','2021-03-25 08:54:57','2021-03-25 09:50:58','062fc25d-a854-42ef-9652-d7f53e20b3a4.png','2021-03-25 09:54:57','SYNCED','062fc25d-a854-42ef-9652-d7f53e20b3a4',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.119.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'062fcb8d-e5a1-4414-a268-fe3422b1c0d8','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/062fcb8d-e5a1-4414-a268-fe3422b1c0d8.ply','PLY','PATIENT_3ba502e6-1fd1-40ed-8e72-2db58e8c52bb_ACT_e72415b7-6a44-4656-b8a1-5a09dc1716d7_SESS_4f7ce129-26d5-443f-b267-d620cc21970b_BOSC_6b46f1e9-d94f-45e1-98a6-4c897039432b_PLY_','2020-12-08 17:25:40','2020-07-20 10:01:26','062fcb8d-e5a1-4414-a268-fe3422b1c0d8.ply','2020-12-08 18:25:40','SYNCED','062fcb8d-e5a1-4414-a268-fe3422b1c0d8',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.8.1.1\",\"modelMatrix\":\"-0.919881,0.388838,-0.0512175,0,-0.392196,-0.912004,0.120129,0,1.75559e-9,0.130591,0.991436,0,-8.07474,19.2282,-20.1606,1\",\"title\":\"Mandibule PLY\"}'),(2,'063a0c7d-99dd-4312-853f-f50409c4819f','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/063a0c7d-99dd-4312-853f-f50409c4819f.png','SNAPS','PATIENT_341d502b-dcb3-4c44-a1eb-3ace1aa0adef_ACT_0df31212-0278-4efa-a431-76c7e411f4e3_SESS_341c098a-021c-4efb-946f-0e12c83bc164_TOSC_7db23a32-d7b4-473e-89d0-259dde1d179e_SNAPS_','2020-12-02 10:32:02','2020-11-16 10:09:05','063a0c7d-99dd-4312-853f-f50409c4819f.png','2020-12-02 11:32:02','SYNCED','063a0c7d-99dd-4312-853f-f50409c4819f',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.36.22.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'063ff7c3-56c8-4eb7-9705-d05dfab764c4','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/063ff7c3-56c8-4eb7-9705-d05dfab764c4.png','SNAPS','PATIENT_2df9c598-3519-4719-a1e4-f4e150a235a9_ACT_ceb083f7-ec86-4eba-9690-123a703c3abc_SESS_ea3ce5df-3ae9-45ef-896c-5661af24bc30_TOSC_4114ee21-40cc-4ffd-84df-2b8954d95607_SNAPS_','2021-12-30 18:03:03','2019-11-21 15:39:30','063ff7c3-56c8-4eb7-9705-d05dfab764c4.png','2021-12-30 19:03:03','SYNCED','b4c99326-ad69-456f-99a3-02956ba9f6fc',1,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 207.3.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'064511d4-de05-47d5-ab00-2c6d71e57b74','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/064511d4-de05-47d5-ab00-2c6d71e57b74.ply','PLY','PATIENT_646c094b-bf87-4519-b09e-91d893e678c2_ACT_21ff3681-9b45-4eee-8e11-e33d469644a4_SESS_a6d0b662-6c60-45a5-954a-e05433afaa4d_TOSC_9b803464-3730-427a-8f64-a0b07174dcbe_PLY_','2021-03-30 07:57:35','2021-03-30 09:50:26','064511d4-de05-47d5-ab00-2c6d71e57b74.ply','2021-03-30 09:57:35','SYNCED','064511d4-de05-47d5-ab00-2c6d71e57b74',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.16.1.3\",\"modelMatrix\":\"0.260771,-0.922795,0.283633,0,0.965401,0.249263,-0.0766142,0,2.80428e-9,0.293798,0.955867,0,-9.9136,-32.909,-12.302,1\",\"title\":\"Maxillaire PLY\"}'),(2,'064b7941-7f89-4734-9d8c-ec08f02c7341','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/064b7941-7f89-4734-9d8c-ec08f02c7341.ply','PLY','PATIENT_3ac6da53-88c5-4d65-a37f-cd3cf5633739_ACT_da9e0457-4df9-4f0a-bb9c-aad3c411f3d3_SESS_0c5f0696-5850-4695-ad77-7936edc4a982_TOSC_911b6879-e0aa-4583-9dd8-dd8a73e14931_PLY_','2021-03-26 14:13:34','2021-03-26 14:57:43','064b7941-7f89-4734-9d8c-ec08f02c7341.ply','2021-03-26 15:13:34','SYNCED','064b7941-7f89-4734-9d8c-ec08f02c7341',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.5.1.3\",\"modelMatrix\":\"0.81207,-0.520146,0.264556,0,0.583559,0.723825,-0.368151,0,6.15109e-9,0.453349,0.891333,0,7.77244,-32.3579,-14.6098,1\",\"title\":\"Maxillaire PLY\"}'),(2,'064d57f3-a9c5-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/064d57f3-a9c5-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_7011fdc9-a359-4718-ad84-e3cb43a750cc_SESS_3cfcad15-248b-4804-82c8-5fefb697ebe6_BOSC_c08b8527-b34a-40c6-bc74-e15b94424b7f_SNAPS_','2021-04-30 14:48:45','2021-04-30 16:48:44','064d57f3-a9c5-11eb-9377-226cec7cb58a.png','2021-04-30 16:48:45','SYNCED','064d57f3-a9c5-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.134.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'064e2281-7291-4aee-ba8e-6f4b13ad7ebd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/064e2281-7291-4aee-ba8e-6f4b13ad7ebd.png','SNAPS','PATIENT_cd4b2e13-f289-44dc-ade2-921f4a012dd3_ACT_9f4a49e8-ceec-4098-b3f0-5babed40e507_SESS_e5259ae0-da57-40d3-8b09-64d35fa6bb82_TOSC_37860b52-678c-464d-81d9-81c00e579a42_SNAPS_','2021-01-07 10:57:40','2021-01-07 10:26:19','064e2281-7291-4aee-ba8e-6f4b13ad7ebd.png','2021-01-07 11:57:40','SYNCED','064e2281-7291-4aee-ba8e-6f4b13ad7ebd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.36.68.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'065164c8-a9c5-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/065164c8-a9c5-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_7011fdc9-a359-4718-ad84-e3cb43a750cc_SESS_3cfcad15-248b-4804-82c8-5fefb697ebe6_TOSC_38bb7dd5-09e1-4851-9be4-3b5932225a72_SNAPS_','2021-04-30 14:33:52','2021-04-30 16:33:51','065164c8-a9c5-11eb-9377-226cec7cb58a.png','2021-04-30 16:33:52','SYNCED','065164c8-a9c5-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.134.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'06547d4e-a9c5-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/06547d4e-a9c5-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_7011fdc9-a359-4718-ad84-e3cb43a750cc_SESS_3cfcad15-248b-4804-82c8-5fefb697ebe6_BOSC_c08b8527-b34a-40c6-bc74-e15b94424b7f_PLY_','2021-04-30 14:48:46','2021-04-30 16:48:44','06547d4e-a9c5-11eb-9377-226cec7cb58a.ply','2021-04-30 16:48:46','SYNCED','06547d4e-a9c5-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.134.1.1\",\"modelMatrix\":\"0.139496,-0.984801,0.103482,0,0.990223,0.138733,-0.0145779,0,4.84891e-10,0.104504,0.994524,0,-13.0627,-14.2028,-24.0517,1\",\"title\":\"Mandibule PLY\"}'),(2,'0654fce2-bb36-4400-b04e-63a71c2927ce','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0654fce2-bb36-4400-b04e-63a71c2927ce.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_c8b6b6cc-4661-4246-b38d-814a4bbf05fd_SESS_c15a9ac2-1676-46fd-bc2b-64f4577dc6ac_TOSC_a8ed1054-1191-40bf-8623-2eb78fb6d254_SNAPS_','2021-07-22 07:42:25','2021-07-22 09:42:24','0654fce2-bb36-4400-b04e-63a71c2927ce.png','2021-07-22 09:42:25','SYNCED','0654fce2-bb36-4400-b04e-63a71c2927ce',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.176.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'065768a9-a9c5-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/065768a9-a9c5-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_7011fdc9-a359-4718-ad84-e3cb43a750cc_SESS_3cfcad15-248b-4804-82c8-5fefb697ebe6_BOSC_4beec14c-edb8-4fed-a648-80973c5a193b_PLY_','2021-04-30 15:01:31','2021-04-30 17:01:29','065768a9-a9c5-11eb-9377-226cec7cb58a.ply','2021-04-30 17:01:31','SYNCED','065768a9-a9c5-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.134.1.3\",\"modelMatrix\":\"-0.89684,-0.421136,0.135363,0,0.442356,-0.853818,0.274438,0,1.08938e-9,0.306006,0.95203,0,-20.2295,5.4204,-23.8644,1\",\"title\":\"Mandibule PLY\"}'),(2,'06584bc9-ada0-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/06584bc9-ada0-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_e026af60-94d3-482b-abdc-c97b7bc2f29b_SESS_c48b54d5-b7d5-4218-a02e-e1c120823987_TOSC_a0f4f8e1-00f5-4b99-a941-f7341e8ef681_PLY_','2021-05-05 12:35:33','2021-05-05 14:35:31','06584bc9-ada0-11eb-9377-226cec7cb58a.ply','2021-05-05 14:35:33','SYNCED','06584bc9-ada0-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.136.1.2\",\"modelMatrix\":\"-0.0121623,-0.959097,0.282816,0,0.999926,-0.0116657,0.00343995,0,-5.49115e-11,0.282837,0.959168,0,-17.6835,-26.0397,-16.542,1\",\"title\":\"Maxillaire PLY\"}'),(2,'065a24b3-a9c5-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/065a24b3-a9c5-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_7011fdc9-a359-4718-ad84-e3cb43a750cc_SESS_3cfcad15-248b-4804-82c8-5fefb697ebe6_BOSC_4beec14c-edb8-4fed-a648-80973c5a193b_SNAPS_','2021-04-30 15:01:30','2021-04-30 17:01:29','065a24b3-a9c5-11eb-9377-226cec7cb58a.png','2021-04-30 17:01:30','SYNCED','065a24b3-a9c5-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.134.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'065ce6c7-a9c5-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/065ce6c7-a9c5-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_7011fdc9-a359-4718-ad84-e3cb43a750cc_SESS_3cfcad15-248b-4804-82c8-5fefb697ebe6_BOSC_3b7b1feb-0353-4334-91ec-bf55dae952a0_SNAPS_','2021-04-30 14:59:08','2021-04-30 16:59:07','065ce6c7-a9c5-11eb-9377-226cec7cb58a.png','2021-04-30 16:59:08','SYNCED','065ce6c7-a9c5-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.134.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'065d8ffa-ada0-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/065d8ffa-ada0-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_e026af60-94d3-482b-abdc-c97b7bc2f29b_SESS_c48b54d5-b7d5-4218-a02e-e1c120823987_BOSC_72ad874f-ac82-463a-85f9-2677f3987953_PLY_','2021-05-05 12:41:18','2021-05-05 14:41:17','065d8ffa-ada0-11eb-9377-226cec7cb58a.ply','2021-05-05 14:41:18','SYNCED','065d8ffa-ada0-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.136.1.1\",\"modelMatrix\":\"-0.765195,-0.628728,0.138482,0,0.643798,-0.747283,0.164595,0,5.09359e-9,0.215102,0.976592,0,-16.9662,-3.91473,-22.8569,1\",\"title\":\"Mandibule PLY\"}'),(2,'065fcf0a-a9c5-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/065fcf0a-a9c5-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_7011fdc9-a359-4718-ad84-e3cb43a750cc_SESS_3cfcad15-248b-4804-82c8-5fefb697ebe6_TOSC_1645a20b-f557-4cab-a8d1-90a3e6bdfabf_SNAPS_','2021-04-30 14:36:34','2021-04-30 16:36:33','065fcf0a-a9c5-11eb-9377-226cec7cb58a.png','2021-04-30 16:36:34','SYNCED','065fcf0a-a9c5-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.134.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'06627c6f-ada0-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/06627c6f-ada0-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_e026af60-94d3-482b-abdc-c97b7bc2f29b_SESS_c48b54d5-b7d5-4218-a02e-e1c120823987_BOSC_72ad874f-ac82-463a-85f9-2677f3987953_SNAPS_','2021-05-05 12:41:17','2021-05-05 14:41:17','06627c6f-ada0-11eb-9377-226cec7cb58a.png','2021-05-05 14:41:17','SYNCED','06627c6f-ada0-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.136.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'06628517-a9c5-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/06628517-a9c5-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_7011fdc9-a359-4718-ad84-e3cb43a750cc_SESS_3cfcad15-248b-4804-82c8-5fefb697ebe6_TOSC_82e91986-1faa-4c5e-abc9-7cc01b03641c_PLY_','2021-04-30 14:31:17','2021-04-30 16:31:15','06628517-a9c5-11eb-9377-226cec7cb58a.ply','2021-04-30 16:31:17','SYNCED','06628517-a9c5-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.134.1.1\",\"modelMatrix\":\"0.387853,-0.873218,0.29506,0,0.921721,0.367443,-0.124159,0,1.53769e-9,0.320119,0.947378,0,-9.29389,-36.8066,-20.7033,1\",\"title\":\"Maxillaire PLY\"}'),(2,'066516ae-da48-4d25-8d7c-061717ebb48c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/066516ae-da48-4d25-8d7c-061717ebb48c.png','SNAPS','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_0ddbb940-8c37-4403-b0e9-1fe058ea5261_SESS_10c77bce-3658-442c-bda4-03d5e4618ea0_BOSC_372e3005-b44d-4f87-93a6-f97178c97192_SNAPS_','2020-12-16 11:05:47','2020-01-15 15:00:46','066516ae-da48-4d25-8d7c-061717ebb48c.png','2020-12-16 12:05:47','SYNCED','066516ae-da48-4d25-8d7c-061717ebb48c',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'06657675-a9c5-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/06657675-a9c5-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_7011fdc9-a359-4718-ad84-e3cb43a750cc_SESS_3cfcad15-248b-4804-82c8-5fefb697ebe6_BOSC_3b7b1feb-0353-4334-91ec-bf55dae952a0_PLY_','2021-04-30 14:59:09','2021-04-30 16:59:07','06657675-a9c5-11eb-9377-226cec7cb58a.ply','2021-04-30 16:59:09','SYNCED','06657675-a9c5-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.134.1.2\",\"modelMatrix\":\"-0.943745,-0.297638,0.144071,0,0.330674,-0.849462,0.41118,0,-1.01559e-8,0.43569,0.900097,0,-28.802,-0.921955,-22.0814,1\",\"title\":\"Mandibule PLY\"}'),(2,'06668e85-ada0-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/06668e85-ada0-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_e026af60-94d3-482b-abdc-c97b7bc2f29b_SESS_c48b54d5-b7d5-4218-a02e-e1c120823987_BOSC_b8a01979-d977-4458-bb24-1405f805fb47_PLY_','2021-05-05 12:46:21','2021-05-05 14:46:19','06668e85-ada0-11eb-9377-226cec7cb58a.ply','2021-05-05 14:46:21','SYNCED','06668e85-ada0-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.136.1.3\",\"modelMatrix\":\"0.0414906,-0.979,0.199594,0,0.999139,0.0406543,-0.0082884,0,6.05929e-10,0.199766,0.979844,0,-8.2788,-19.5991,-22.4088,1\",\"title\":\"Mandibule PLY\"}'),(2,'066846ff-a9c5-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/066846ff-a9c5-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_7011fdc9-a359-4718-ad84-e3cb43a750cc_SESS_3cfcad15-248b-4804-82c8-5fefb697ebe6_TOSC_82e91986-1faa-4c5e-abc9-7cc01b03641c_SNAPS_','2021-04-30 14:31:16','2021-04-30 16:31:15','066846ff-a9c5-11eb-9377-226cec7cb58a.png','2021-04-30 16:31:16','SYNCED','066846ff-a9c5-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.134.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'066a0ae1-ada0-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/066a0ae1-ada0-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_e026af60-94d3-482b-abdc-c97b7bc2f29b_SESS_c48b54d5-b7d5-4218-a02e-e1c120823987_BOSC_b8a01979-d977-4458-bb24-1405f805fb47_SNAPS_','2021-05-05 12:46:20','2021-05-05 14:46:19','066a0ae1-ada0-11eb-9377-226cec7cb58a.png','2021-05-05 14:46:20','SYNCED','066a0ae1-ada0-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.136.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'066c322b-a9c5-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/066c322b-a9c5-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_7011fdc9-a359-4718-ad84-e3cb43a750cc_SESS_3cfcad15-248b-4804-82c8-5fefb697ebe6_TOSC_38bb7dd5-09e1-4851-9be4-3b5932225a72_PLY_','2021-04-30 14:33:53','2021-04-30 16:33:51','066c322b-a9c5-11eb-9377-226cec7cb58a.ply','2021-04-30 16:33:53','SYNCED','066c322b-a9c5-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.134.1.2\",\"modelMatrix\":\"0.105041,-0.957333,0.269222,0,0.994468,0.101119,-0.0284367,0,5.79781e-10,0.27072,0.962658,0,-17.4298,-29.5233,-16.7703,1\",\"title\":\"Maxillaire PLY\"}'),(2,'066d104d-ada0-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/066d104d-ada0-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_e026af60-94d3-482b-abdc-c97b7bc2f29b_SESS_c48b54d5-b7d5-4218-a02e-e1c120823987_TOSC_7294d2b6-64a4-4c4f-8946-07ac79d4dec2_SNAPS_','2021-05-05 12:38:34','2021-05-05 14:38:33','066d104d-ada0-11eb-9377-226cec7cb58a.png','2021-05-05 14:38:34','SYNCED','066d104d-ada0-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.136.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'066da2fc-4c14-42e7-90c9-728b1a3b2266','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/066da2fc-4c14-42e7-90c9-728b1a3b2266.stl','STL','PATIENT_dec054d6-9cc2-469e-ac1b-f0b2fcd7b449_ACT_91242394-1612-4b65-bd03-91bfa48432f6_SESS_df03db5c-f821-47c5-add4-bdce62ba0dc4_BOSC_610aeb0c-c528-49a1-9d82-3a6a8bda7e7e_STL_','2021-12-30 18:03:03','2019-10-11 16:42:33','066da2fc-4c14-42e7-90c9-728b1a3b2266.stl','2021-12-30 19:03:03','SYNCED','066da2fc-4c14-42e7-90c9-728b1a3b2266',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 186.1.1.1\",\"modelMatrix\":\"-0.927884,0.360288,-0.0960432,0,-0.372869,-0.896575,0.239003,0,5.95159e-9,0.257579,0.966257,0,-10.3635,18.4555,-21.2926,1\",\"title\":\"MANDIBULE STL\"}'),(2,'066f25e6-a9c5-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/066f25e6-a9c5-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_7011fdc9-a359-4718-ad84-e3cb43a750cc_SESS_3cfcad15-248b-4804-82c8-5fefb697ebe6_TOSC_1645a20b-f557-4cab-a8d1-90a3e6bdfabf_PLY_','2021-04-30 14:36:35','2021-04-30 16:36:33','066f25e6-a9c5-11eb-9377-226cec7cb58a.ply','2021-04-30 16:36:35','SYNCED','066f25e6-a9c5-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.134.1.3\",\"modelMatrix\":\"0.497969,-0.832298,0.243531,0,0.867195,0.47793,-0.139843,0,2.89204e-9,0.280826,0.959759,0,-2.63477,-32.3396,-17.2819,1\",\"title\":\"Maxillaire PLY\"}'),(2,'066fb44e-36dd-4ed6-88b3-a9124e4e57fe','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/066fb44e-36dd-4ed6-88b3-a9124e4e57fe.ply','PLY','PATIENT_d092ea90-a92a-44ef-ab64-86b00ed2679d_ACT_0b3dc7d8-a1d6-472a-9a63-2fff5248f3ca_SESS_25fdbbaf-7212-464e-80d5-3b9c2e167114_TOSC_a82c7483-3976-4704-bcb1-edc758337507_PLY_','2021-03-19 11:19:01','2021-03-19 12:03:06','066fb44e-36dd-4ed6-88b3-a9124e4e57fe.ply','2021-03-19 12:19:01','SYNCED','066fb44e-36dd-4ed6-88b3-a9124e4e57fe',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.99.1.3\",\"modelMatrix\":\"0.17374,-0.930284,0.323089,0,0.984792,0.164123,-0.0570003,0,-8.78636e-10,0.328079,0.94465,0,-15.7769,-36.2459,-8.99046,1\",\"title\":\"Maxillaire PLY\"}'),(2,'067031d2-ada0-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/067031d2-ada0-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_e026af60-94d3-482b-abdc-c97b7bc2f29b_SESS_c48b54d5-b7d5-4218-a02e-e1c120823987_BOSC_0980e017-bb95-489d-8916-89a1baced599_PLY_','2021-05-05 12:43:48','2021-05-05 14:43:46','067031d2-ada0-11eb-9377-226cec7cb58a.ply','2021-05-05 14:43:48','SYNCED','067031d2-ada0-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.136.1.2\",\"modelMatrix\":\"-0.16717,-0.963863,0.20742,0,0.985928,-0.163429,0.0351694,0,3.89904e-9,0.210381,0.97762,0,-20.3737,-26.8238,-24.5198,1\",\"title\":\"Mandibule PLY\"}'),(2,'0672272a-17b1-4395-b662-0f9eaed49d18','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0672272a-17b1-4395-b662-0f9eaed49d18.png','SNAPS','PATIENT_c5ca25aa-9a7e-487b-8c81-71ee4806e9cc_ACT_47209e86-3635-4fb7-b0a3-93fe47c45dfb_SESS_9bcf3e23-3fa5-4090-b7f9-f6783acc4b40_BOSC_e3dc90fd-5f3f-4af9-b1f8-11769dd37d01_SNAPS_','2021-03-17 13:03:11','2021-03-17 14:00:39','0672272a-17b1-4395-b662-0f9eaed49d18.png','2021-03-17 14:03:11','SYNCED','0672272a-17b1-4395-b662-0f9eaed49d18',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.92.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'06736699-ada0-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/06736699-ada0-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_e026af60-94d3-482b-abdc-c97b7bc2f29b_SESS_c48b54d5-b7d5-4218-a02e-e1c120823987_TOSC_7294d2b6-64a4-4c4f-8946-07ac79d4dec2_PLY_','2021-05-05 12:38:36','2021-05-05 14:38:33','06736699-ada0-11eb-9377-226cec7cb58a.ply','2021-05-05 14:38:36','SYNCED','06736699-ada0-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.136.1.3\",\"modelMatrix\":\"0.80851,-0.488022,0.328854,0,0.588482,0.67049,-0.45181,0,-4.74942e-9,0.558818,0.82929,0,15.707,-32.3156,-22.8986,1\",\"title\":\"Maxillaire PLY\"}'),(2,'06766b94-ada0-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/06766b94-ada0-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_e026af60-94d3-482b-abdc-c97b7bc2f29b_SESS_c48b54d5-b7d5-4218-a02e-e1c120823987_BOSC_0980e017-bb95-489d-8916-89a1baced599_SNAPS_','2021-05-05 12:43:47','2021-05-05 14:43:46','06766b94-ada0-11eb-9377-226cec7cb58a.png','2021-05-05 14:43:47','SYNCED','06766b94-ada0-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.136.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0677366b-5dea-47ad-9259-d3554e2f22af','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0677366b-5dea-47ad-9259-d3554e2f22af.ply','PLY','PATIENT_5b3365d0-2ad4-4d78-9c7c-89ff37d5905d_ACT_ee6f943a-7cab-46d0-b223-fd379650024c_SESS_9f9fe29b-f6ed-4a4c-b9f0-7e6258af0943_BOSC_1e683af5-1242-487e-bddf-81d388b62774_PLY_','2020-12-08 17:25:41','2020-06-19 09:57:00','0677366b-5dea-47ad-9259-d3554e2f22af.ply','2020-12-08 18:25:41','SYNCED','0677366b-5dea-47ad-9259-d3554e2f22af',0,NULL,'','','{\"displayTitle\":\"Mandibule 32.2.1.1.7\",\"modelMatrix\":\"-0.990581,0.135612,-0.0189406,0,-0.136928,-0.981058,0.137022,0,7.26077e-10,0.138325,0.990387,0,-7.76055,19.6683,-25.8918,1\",\"title\":\"Mandibule PLY\"}'),(2,'067924f7-ada0-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/067924f7-ada0-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_e026af60-94d3-482b-abdc-c97b7bc2f29b_SESS_c48b54d5-b7d5-4218-a02e-e1c120823987_TOSC_8bc9807b-46a6-49cf-a6c5-f5c647f0e741_SNAPS_','2021-05-05 12:31:31','2021-05-05 14:31:29','067924f7-ada0-11eb-9377-226cec7cb58a.png','2021-05-05 14:31:31','SYNCED','067924f7-ada0-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.136.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'067a6b4e-32ff-42aa-ac48-e2935e48be97','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/067a6b4e-32ff-42aa-ac48-e2935e48be97.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_6c5d4194-c28f-4dc4-a836-110a650573fc_SESS_25a8e928-4efc-485b-85c9-f8544e3e5dce_TOSC_16ebd117-f410-4008-a168-17e349bef404_SNAPS_','2021-04-23 13:11:59','2021-04-23 15:11:58','067a6b4e-32ff-42aa-ac48-e2935e48be97.png','2021-04-23 15:11:59','SYNCED','067a6b4e-32ff-42aa-ac48-e2935e48be97',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.96.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'067b9457-0f00-41e6-ba3b-3722dbf6572b','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/067b9457-0f00-41e6-ba3b-3722dbf6572b.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_43dc61b8-8a78-42d9-8ed9-0050f80eadb4_SESS_1296078b-02a5-4737-9afa-e4afb6771314_BOSC_45ec4140-ab16-4b14-818c-75d4340894b4_PLY_','2020-12-16 10:51:36','2020-02-11 15:03:54','067b9457-0f00-41e6-ba3b-3722dbf6572b.ply','2020-12-16 11:51:36','SYNCED','067b9457-0f00-41e6-ba3b-3722dbf6572b',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"modelMatrix\":\"-0.568087,0.812234,-0.13249,0,-0.822969,-0.560677,0.0914565,0,2.42039e-9,0.16099,0.986956,0,8.61376,18.4525,-15.6196,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'067bc1bc-c84e-44a2-aabb-688d8b329838','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/067bc1bc-c84e-44a2-aabb-688d8b329838.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_c6940e84-1289-4740-8fe2-41746cad3866_SESS_c542eccb-6b38-4ef0-b74f-9b6c27689b67_BOSC_c7a6a65a-5965-4dc2-8cc3-3d90526eb0d2_PLY_','2021-04-26 13:59:48','2021-04-26 15:59:46','067bc1bc-c84e-44a2-aabb-688d8b329838.ply','2021-04-26 15:59:48','SYNCED','067bc1bc-c84e-44a2-aabb-688d8b329838',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.107.1.2\",\"modelMatrix\":\"-0.413737,-0.896698,0.157335,0,0.910396,-0.407512,0.0715021,0,5.23787e-9,0.17282,0.984953,0,-17.2747,-6.99758,-22.5347,1\",\"title\":\"Mandibule PLY\"}'),(2,'067c1bea-ada0-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/067c1bea-ada0-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_e026af60-94d3-482b-abdc-c97b7bc2f29b_SESS_c48b54d5-b7d5-4218-a02e-e1c120823987_TOSC_a0f4f8e1-00f5-4b99-a941-f7341e8ef681_SNAPS_','2021-05-05 12:35:32','2021-05-05 14:35:31','067c1bea-ada0-11eb-9377-226cec7cb58a.png','2021-05-05 14:35:32','SYNCED','067c1bea-ada0-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.136.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'067e4c8c-1e44-427f-b201-9baf4a22eb93','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/067e4c8c-1e44-427f-b201-9baf4a22eb93.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_8a46fe73-45f9-48a6-b7b5-7f571298b5c3_SESS_88277293-7807-4a9d-8a3b-4bada1cecf0b_BOSC_52fafe7f-87d6-4fd9-b56c-45060a2faf31_SNAPS_','2021-04-09 12:57:24','2021-04-09 14:57:22','067e4c8c-1e44-427f-b201-9baf4a22eb93.png','2021-04-09 14:57:24','SYNCED','067e4c8c-1e44-427f-b201-9baf4a22eb93',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.48.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'067f6ce2-ada0-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/067f6ce2-ada0-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_e026af60-94d3-482b-abdc-c97b7bc2f29b_SESS_c48b54d5-b7d5-4218-a02e-e1c120823987_TOSC_8bc9807b-46a6-49cf-a6c5-f5c647f0e741_PLY_','2021-05-05 12:31:31','2021-05-05 14:31:29','067f6ce2-ada0-11eb-9377-226cec7cb58a.ply','2021-05-05 14:31:31','SYNCED','067f6ce2-ada0-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.136.1.1\",\"modelMatrix\":\"0.713008,-0.634104,0.299219,0,0.701156,0.644822,-0.304277,0,-8.89195e-9,0.426751,0.904369,0,3.89204,-37.7574,-18.5678,1\",\"title\":\"Maxillaire PLY\"}'),(2,'067fe954-e8ca-4079-8dc6-80a7598a251e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/067fe954-e8ca-4079-8dc6-80a7598a251e.png','SNAPS','PATIENT_9c424d0a-91b9-4df7-b470-de67439e396c_ACT_27b123e3-580b-4c73-a18e-db6c5799c87b_SESS_ad1b540b-47c5-4f1b-8964-4de0d1b0ca5a_TOSC_c64878e0-59d2-4428-b6e2-b60781726630_SNAPS_','2021-01-11 13:52:43','2021-01-11 14:30:49','067fe954-e8ca-4079-8dc6-80a7598a251e.png','2021-01-11 14:52:43','SYNCED','067fe954-e8ca-4079-8dc6-80a7598a251e',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.36.73.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'06809e77-b64c-4409-a269-be8a435c83b7','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/06809e77-b64c-4409-a269-be8a435c83b7.ply','PLY','PATIENT_a0f28085-2afd-48f0-9f0b-723f452f5b02_ACT_5ce1670d-66c0-458c-9351-ebca90788280_SESS_1d9b4870-a0a0-40ed-9c3d-30cfee2dbbc4_TOSC_2aeee805-aece-4d62-b4c4-041868806582_PLY_','2021-03-01 10:46:56','2021-03-01 11:27:58','06809e77-b64c-4409-a269-be8a435c83b7.ply','2021-03-01 11:46:56','SYNCED','06809e77-b64c-4409-a269-be8a435c83b7',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.66.1.2\",\"modelMatrix\":\"0.089037,-0.941715,0.324416,0,0.996028,0.0841818,-0.0290002,0,-3.05429e-11,0.325709,0.94547,0,-16.3573,-29.7528,-17.0517,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0681b0e2-5712-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0681b0e2-5712-11eb-94ee-226cec7cb58a.png','SNAPS','PATIENT_d8a78ca7-378e-4f4c-97b5-1f1082842006_ACT_b1867e3f-247b-4070-a2a1-304aef08103e_SESS_e2676d2e-fa47-47f2-819d-e5c3934828b8_TOSC_27f2b91e-2ece-4c1a-ae40-df130290b90f_SNAPS_','2021-01-15 09:13:43','2021-01-15 10:01:25','0681b0e2-5712-11eb-94ee-226cec7cb58a.png','2021-01-15 10:13:43','SYNCED','0681b0e2-5712-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.6.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0683b20b-5712-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0683b20b-5712-11eb-94ee-226cec7cb58a.png','SNAPS','PATIENT_d8a78ca7-378e-4f4c-97b5-1f1082842006_ACT_b1867e3f-247b-4070-a2a1-304aef08103e_SESS_e2676d2e-fa47-47f2-819d-e5c3934828b8_BOSC_948d3f76-f424-42ad-a41d-4a1f9dcbcca4_SNAPS_','2021-01-15 09:13:42','2021-01-15 10:13:06','0683b20b-5712-11eb-94ee-226cec7cb58a.png','2021-01-15 10:13:42','SYNCED','0683b20b-5712-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.6.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0684f3b5-5712-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0684f3b5-5712-11eb-94ee-226cec7cb58a.ply','PLY','PATIENT_d8a78ca7-378e-4f4c-97b5-1f1082842006_ACT_b1867e3f-247b-4070-a2a1-304aef08103e_SESS_e2676d2e-fa47-47f2-819d-e5c3934828b8_BOSC_948d3f76-f424-42ad-a41d-4a1f9dcbcca4_PLY_','2021-01-15 09:13:42','2021-01-15 10:13:06','0684f3b5-5712-11eb-94ee-226cec7cb58a.ply','2021-01-15 10:13:42','SYNCED','0684f3b5-5712-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.6.1.3\",\"modelMatrix\":\"0.473347,-0.880866,0.00406378,0,0.880876,0.473342,-0.00218371,0,3.57395e-11,0.00461334,0.999989,0,-11.3223,-20.6956,-22.0069,1\",\"title\":\"Mandibule PLY\"}'),(2,'068757e7-bbcd-4032-9f43-d0507eaf91fd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/068757e7-bbcd-4032-9f43-d0507eaf91fd.stl','STL','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_aceb6871-e01a-4e37-9c9f-33adfe6e0268_SESS_1ad73395-8cbd-4dcc-9a8e-cf3241e4e156_BOSC_0b40cf8a-581b-4ca9-90a5-cd0340988c9a_STL_','2021-08-05 07:30:43','2019-11-29 09:24:56','068757e7-bbcd-4032-9f43-d0507eaf91fd.stl','2021-08-05 09:30:43','SYNCED','068757e7-bbcd-4032-9f43-d0507eaf91fd',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.1.1\",\"modelMatrix\":\"-0.993012,0.110987,-0.0401215,0,-0.118017,-0.933866,0.337589,0,-1.6142e-9,0.339965,0.940438,0,-15.1095,16.5385,-18.8615,1\",\"title\":\"MANDIBULE STL\"}'),(2,'06889e28-5712-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/06889e28-5712-11eb-94ee-226cec7cb58a.png','SNAPS','PATIENT_d8a78ca7-378e-4f4c-97b5-1f1082842006_ACT_b1867e3f-247b-4070-a2a1-304aef08103e_SESS_e2676d2e-fa47-47f2-819d-e5c3934828b8_TOSC_1f2dc7f9-692f-4b9c-9470-d73c3ed6c4de_SNAPS_','2021-01-15 09:13:43','2021-01-15 10:03:53','06889e28-5712-11eb-94ee-226cec7cb58a.png','2021-01-15 10:13:43','SYNCED','06889e28-5712-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.6.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'068931c2-1eab-40a2-a1f1-5699b6e343d5','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/068931c2-1eab-40a2-a1f1-5699b6e343d5.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_5ad242bb-5a07-4058-af0c-1a216312b460_SESS_9907d5cc-0f31-4af6-b39d-3faa513150c7_TOSC_d6af3f0f-b0c3-4d73-8050-524d80eaf51d_SNAPS_','2022-03-29 08:00:46','2022-03-29 10:00:42','068931c2-1eab-40a2-a1f1-5699b6e343d5.png','2022-03-29 10:00:46','SYNCED','068931c2-1eab-40a2-a1f1-5699b6e343d5',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.42.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'068cb63d-5712-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/068cb63d-5712-11eb-94ee-226cec7cb58a.ply','PLY','PATIENT_d8a78ca7-378e-4f4c-97b5-1f1082842006_ACT_b1867e3f-247b-4070-a2a1-304aef08103e_SESS_e2676d2e-fa47-47f2-819d-e5c3934828b8_TOSC_1f2dc7f9-692f-4b9c-9470-d73c3ed6c4de_PLY_','2021-01-15 09:13:43','2021-01-15 10:03:53','068cb63d-5712-11eb-94ee-226cec7cb58a.ply','2021-01-15 10:13:43','SYNCED','068cb63d-5712-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.6.1.3\",\"modelMatrix\":\"0.74415,-0.592088,0.309311,0,0.668013,0.659571,-0.344565,0,8.68919e-10,0.463032,0.886342,0,6.93961,-32.9306,-24.6454,1\",\"title\":\"Maxillaire PLY\"}'),(2,'068e33a2-5712-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/068e33a2-5712-11eb-94ee-226cec7cb58a.ply','PLY','PATIENT_d8a78ca7-378e-4f4c-97b5-1f1082842006_ACT_b1867e3f-247b-4070-a2a1-304aef08103e_SESS_e2676d2e-fa47-47f2-819d-e5c3934828b8_TOSC_27f2b91e-2ece-4c1a-ae40-df130290b90f_PLY_','2021-01-15 09:13:42','2021-01-15 10:01:25','068e33a2-5712-11eb-94ee-226cec7cb58a.ply','2021-01-15 10:13:42','SYNCED','068e33a2-5712-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.6.1.2\",\"modelMatrix\":\"0.575608,-0.779437,0.247292,0,0.817726,0.548656,-0.174072,0,-1.36385e-8,0.302415,0.953176,0,-0.440982,-34.0438,-15.6441,1\",\"title\":\"Maxillaire PLY\"}'),(2,'068f6a23-5712-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/068f6a23-5712-11eb-94ee-226cec7cb58a.ply','PLY','PATIENT_d8a78ca7-378e-4f4c-97b5-1f1082842006_ACT_b1867e3f-247b-4070-a2a1-304aef08103e_SESS_e2676d2e-fa47-47f2-819d-e5c3934828b8_BOSC_94b601ef-0d5a-4b6f-821b-85f6a1525535_PLY_','2021-01-15 09:13:42','2021-01-15 10:07:47','068f6a23-5712-11eb-94ee-226cec7cb58a.ply','2021-01-15 10:13:42','SYNCED','068f6a23-5712-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.6.1.1\",\"modelMatrix\":\"-0.994712,0.0946934,-0.0397751,0,-0.102708,-0.917093,0.385217,0,9.47428e-10,0.387265,0.921969,0,-14.5673,13.7756,-22.4648,1\",\"title\":\"Mandibule PLY\"}'),(2,'0690d4a9-5712-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0690d4a9-5712-11eb-94ee-226cec7cb58a.png','SNAPS','PATIENT_d8a78ca7-378e-4f4c-97b5-1f1082842006_ACT_b1867e3f-247b-4070-a2a1-304aef08103e_SESS_e2676d2e-fa47-47f2-819d-e5c3934828b8_BOSC_60ab0a90-da56-438a-ab78-85c9c16b37ee_SNAPS_','2021-01-15 09:13:43','2021-01-15 10:10:33','0690d4a9-5712-11eb-94ee-226cec7cb58a.png','2021-01-15 10:13:43','SYNCED','0690d4a9-5712-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.6.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'06922704-b0dd-47dd-8a77-30d60d082d13','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/06922704-b0dd-47dd-8a77-30d60d082d13.ply','PLY','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_e57a553c-41cd-4055-bba6-11b42bb48377_SESS_af29201d-4894-416b-baa6-9f7d35184ac2_TOSC_9e11c925-4fb4-4a41-b9cb-ba10c6894c24_PLY_','2020-12-07 12:00:36','2020-08-19 15:28:47','06922704-b0dd-47dd-8a77-30d60d082d13.ply','2020-12-07 13:00:36','SYNCED','06922704-b0dd-47dd-8a77-30d60d082d13',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.26.31.1.2\",\"modelMatrix\":\"0.818009,-0.481965,0.313961,0,0.575206,0.68541,-0.446489,0,-2.66049e-9,0.545824,0.8379,0,6.24036,-30.8183,-18.5957,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0694927a-5712-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0694927a-5712-11eb-94ee-226cec7cb58a.ply','PLY','PATIENT_d8a78ca7-378e-4f4c-97b5-1f1082842006_ACT_b1867e3f-247b-4070-a2a1-304aef08103e_SESS_e2676d2e-fa47-47f2-819d-e5c3934828b8_BOSC_60ab0a90-da56-438a-ab78-85c9c16b37ee_PLY_','2021-01-15 09:13:44','2021-01-15 10:10:33','0694927a-5712-11eb-94ee-226cec7cb58a.ply','2021-01-15 10:13:44','SYNCED','0694927a-5712-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.6.1.2\",\"modelMatrix\":\"-0.979957,0.196594,-0.0321865,0,-0.199211,-0.967081,0.158332,0,-6.63232e-10,0.16157,0.986861,0,-16.2162,21.4579,-19.3592,1\",\"title\":\"Mandibule PLY\"}'),(2,'0695cbdb-5712-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0695cbdb-5712-11eb-94ee-226cec7cb58a.ply','PLY','PATIENT_d8a78ca7-378e-4f4c-97b5-1f1082842006_ACT_b1867e3f-247b-4070-a2a1-304aef08103e_SESS_e2676d2e-fa47-47f2-819d-e5c3934828b8_TOSC_6ff120e0-b192-4272-8380-5205fc5dc15a_PLY_','2021-01-15 09:13:43','2021-01-15 09:58:27','0695cbdb-5712-11eb-94ee-226cec7cb58a.ply','2021-01-15 10:13:43','SYNCED','0695cbdb-5712-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.6.1.1\",\"modelMatrix\":\"0.782828,-0.577417,0.231885,0,0.622239,0.726438,-0.29173,0,-3.61533e-9,0.372662,0.927967,0,6.43442,-28.6005,-14.0248,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0696fbb7-5712-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0696fbb7-5712-11eb-94ee-226cec7cb58a.png','SNAPS','PATIENT_d8a78ca7-378e-4f4c-97b5-1f1082842006_ACT_b1867e3f-247b-4070-a2a1-304aef08103e_SESS_e2676d2e-fa47-47f2-819d-e5c3934828b8_BOSC_94b601ef-0d5a-4b6f-821b-85f6a1525535_SNAPS_','2021-01-15 09:13:43','2021-01-15 10:07:47','0696fbb7-5712-11eb-94ee-226cec7cb58a.png','2021-01-15 10:13:43','SYNCED','0696fbb7-5712-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.6.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'06982767-5712-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/06982767-5712-11eb-94ee-226cec7cb58a.png','SNAPS','PATIENT_d8a78ca7-378e-4f4c-97b5-1f1082842006_ACT_b1867e3f-247b-4070-a2a1-304aef08103e_SESS_e2676d2e-fa47-47f2-819d-e5c3934828b8_TOSC_6ff120e0-b192-4272-8380-5205fc5dc15a_SNAPS_','2021-01-15 09:13:43','2021-01-15 09:58:27','06982767-5712-11eb-94ee-226cec7cb58a.png','2021-01-15 10:13:43','SYNCED','06982767-5712-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.6.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'069aa549-dbf5-4c8e-9e5e-3168ef119e40','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/069aa549-dbf5-4c8e-9e5e-3168ef119e40.png','SNAPS','PATIENT_6a7ac0d5-4055-49d3-b19e-fbc32b5410dd_ACT_c72227a2-3fec-44f5-8e89-c70affa7f8cf_SESS_0a005038-7623-4b99-80e9-39456f57a72f_TOSC_09cd7123-4135-4a29-b8b8-df15812e9d7e_SNAPS_','2021-03-17 09:20:58','2021-03-17 10:12:03','069aa549-dbf5-4c8e-9e5e-3168ef119e40.png','2021-03-17 10:20:58','SYNCED','069aa549-dbf5-4c8e-9e5e-3168ef119e40',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.86.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'069b8a71-ba19-4ef0-a85d-96a4c85d246f','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/069b8a71-ba19-4ef0-a85d-96a4c85d246f.png','SNAPS','PATIENT_fea6b50d-4d9d-47ff-a2b1-0da37346c8f1_ACT_b7b7e6ff-bf44-457b-b976-80d211486aab_SESS_89ce2ca9-f0e3-44c1-a64e-f181b040f91f_TOSC_83232914-b640-4689-9a19-b93d882ad27a_SNAPS_','2020-12-08 17:25:42','2020-06-23 10:11:55','069b8a71-ba19-4ef0-a85d-96a4c85d246f.png','2020-12-08 18:25:42','SYNCED','069b8a71-ba19-4ef0-a85d-96a4c85d246f',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.72.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'06a21d26-dfa1-4b93-8991-16cc83809bfd','','PLY','PATIENT_c6ba0056-47cd-4525-86da-242a4f71535d_ACT_892a54a8-b3ab-4b0d-9191-0615fa775061_SESS_c947c8af-3810-41ed-b05a-fa549a4840fc_TOSC_a6906c4b-99b3-4000-a7ec-8cf86f891cd4_PLY_','2021-04-02 12:31:29','2021-04-02 14:31:27','','2021-04-02 14:31:29','SYNCED','06a21d26-dfa1-4b93-8991-16cc83809bfd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.319.1.1.2\",\"modelMatrix\":\"0.904104,-0.365776,0.220919,0,0.427314,0.773903,-0.467416,0,-2.12997e-8,0.516994,0.855989,0,13.5296,-32.5848,-17.7848,1\",\"title\":\"Maxillaire PLY\"}'),(2,'06a30cce-17c1-4805-91ea-76e37bb32731','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/06a30cce-17c1-4805-91ea-76e37bb32731.png','SNAPS','PATIENT_2f6dceee-f79b-4bb5-85f5-1f34af9ce343_ACT_acf65c07-7da6-466d-9343-e002ccf7eec8_SESS_8602d619-adf2-4766-ab48-ee020dce7847_TOSC_42c5fc9a-8d7c-4e78-88bd-9d1203a9529c_SNAPS_','2021-09-17 10:15:06','2021-09-17 12:15:05','06a30cce-17c1-4805-91ea-76e37bb32731.png','2021-09-17 12:15:06','SYNCED','06a30cce-17c1-4805-91ea-76e37bb32731',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.394.1.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'06b296a9-c36e-4c13-a852-95308d86aa57','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/06b296a9-c36e-4c13-a852-95308d86aa57.ply','PLY','PATIENT_d4f9fa0a-dbee-45fc-9280-0b8369c4b8f0_ACT_e1dd1d25-014a-484e-a179-9cab342b2081_SESS_420541a1-e514-40a2-aecc-ad0115afbaf0_BOSC_939cdabf-be56-4797-902d-ca98528c14b9_PLY_','2020-12-08 17:25:42','2020-06-24 11:46:28','06b296a9-c36e-4c13-a852-95308d86aa57.ply','2020-12-08 18:25:42','SYNCED','06b296a9-c36e-4c13-a852-95308d86aa57',0,NULL,'','','{\"displayTitle\":\"Mandibule 32.3.10.1.1\",\"modelMatrix\":\"-0.145036,0.987285,-0.0650661,0,-0.989426,-0.144722,0.0095378,0,-9.77693e-10,0.0657614,0.997835,0,16.535,10.1018,-18.201,1\",\"title\":\"Mandibule PLY\"}'),(2,'06b8557c-ec59-4644-a9f1-da49565f61b0','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/06b8557c-ec59-4644-a9f1-da49565f61b0.stl','STL','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_BOSC_354fcd1e-1b9b-4433-a96d-a079f19a9534_STL_','2021-12-30 18:03:03','2019-11-15 13:57:45','06b8557c-ec59-4644-a9f1-da49565f61b0.stl','2021-12-30 19:03:03','SYNCED','06b8557c-ec59-4644-a9f1-da49565f61b0',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 202.1.1.1\",\"modelMatrix\":\"-0.943152,0.327826,-0.0547245,0,-0.332363,-0.930279,0.155293,0,3.18135e-9,0.164653,0.986352,0,-9.12563,17.863,-21.143,1\",\"title\":\"MANDIBULE STL\"}'),(2,'06b8cf84-289b-4144-868c-a07bef93e7a0','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/06b8cf84-289b-4144-868c-a07bef93e7a0.ply','PLY','PATIENT_24e6296f-61e8-4047-8ff5-f9ed012a1232_ACT_eda2d23f-44a6-4af8-860c-2bddc040e439_SESS_24b4dd62-660c-4500-aadc-c90c5e1d3168_BOSC_459b9814-3e40-4e6f-baf4-65e771a13f53_PLY_','2022-03-04 13:40:22','2019-07-10 10:58:41','06b8cf84-289b-4144-868c-a07bef93e7a0.ply','2022-03-04 14:40:22','SYNCED','06b8cf84-289b-4144-868c-a07bef93e7a0',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 22.1.1.1\",\"modelMatrix\":\"-0.996483,0.0828682,-0.0124428,0,-0.0837971,-0.985436,0.147965,0,4.60215e-10,0.148487,0.988914,0,-19.9973,18.5808,-24.8957,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'06c0e563-9fb4-48e4-a020-45a4985dc3a8','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/06c0e563-9fb4-48e4-a020-45a4985dc3a8.png','SNAPS','PATIENT_ddf803cd-534e-4462-a98f-452841304f52_ACT_b391c978-c88a-4f6d-ba94-9ed543204dce_SESS_ed91e1ca-a79b-47a0-8342-487076ff127f_BOSC_df8b4d3f-bbb7-446a-ac64-de05b53430f3_SNAPS_','2020-12-16 09:03:08','2020-12-16 09:50:14','06c0e563-9fb4-48e4-a020-45a4985dc3a8.png','2020-12-16 10:03:08','SYNCED','06c0e563-9fb4-48e4-a020-45a4985dc3a8',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.39.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'06c5ee2c-801e-4ddd-b41a-4f16ad987ab5','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/06c5ee2c-801e-4ddd-b41a-4f16ad987ab5.ply','PLY','PATIENT_1cd14489-1dd6-462a-b246-8cb9f44e2c2e_ACT_39768527-49df-4f1f-9c8d-e1d614508e81_SESS_9fba44e9-d238-431a-95ae-368483f5f8a1_BOSC_7fcbf0db-4611-465d-9f8d-1a011e753e9d_PLY_','2020-12-29 12:49:30','2020-12-29 13:48:42','06c5ee2c-801e-4ddd-b41a-4f16ad987ab5.ply','2020-12-29 13:49:30','SYNCED','06c5ee2c-801e-4ddd-b41a-4f16ad987ab5',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.55.1.3\",\"modelMatrix\":\"-0.999001,-0.0432912,0.0110577,0,0.0446811,-0.967925,0.247233,0,-1.03132e-9,0.24748,0.968893,0,-14.4246,12.3189,-19.4935,1\",\"title\":\"Mandibule PLY\"}'),(2,'06c6a0c7-4657-4672-918d-1448cede9f80','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/06c6a0c7-4657-4672-918d-1448cede9f80.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_d4795da6-b2be-4f2f-9538-c27ed33cf9e1_SESS_4db404f1-b42a-47d7-a023-3500473c2c18_BOSC_9c895c55-a365-44f0-8029-7010d03114ac_SNAPS_','2021-04-27 14:21:54','2021-04-27 16:21:53','06c6a0c7-4657-4672-918d-1448cede9f80.png','2021-04-27 16:21:54','SYNCED','06c6a0c7-4657-4672-918d-1448cede9f80',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.119.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'06ca1d21-368e-44b1-9e8d-a550d7b6829b','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/06ca1d21-368e-44b1-9e8d-a550d7b6829b.png','SNAPS','PATIENT_b300e71e-93ef-48e1-8eb9-e4f1c516a9d5_ACT_47fe2ba9-f5ad-42b7-b29b-475d98d6c3d9_SESS_0ebe1667-9b32-41d1-b4c9-a74f9fad08a2_TOSC_b0443fa1-e270-464d-8cfb-000049160b31_SNAPS_','2021-01-06 11:02:03','2019-12-13 14:48:23','06ca1d21-368e-44b1-9e8d-a550d7b6829b.png','2021-01-06 12:02:03','SYNCED','06ca1d21-368e-44b1-9e8d-a550d7b6829b',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 232.20.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'06d3d7f8-e212-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/06d3d7f8-e212-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_9f209306-6fc2-4865-9b41-2503c70e4e82_SESS_360e2b7c-c3bf-422a-9a48-fd86cdcc3b12_BOSC_c20c1c39-b3b1-45bc-a46b-4b0ef5a5c4d4_SNAPS_','2020-12-07 12:00:37','2020-08-19 13:32:22','06d3d7f8-e212-11ea-947d-226cec7cb58a.png','2020-12-07 13:00:37','SYNCED','06d3d7f8-e212-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.26.27.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'06d4171d-f4af-4a47-8d29-7a22eccf6dc5','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/06d4171d-f4af-4a47-8d29-7a22eccf6dc5.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_773270a3-7e98-4b50-9f8b-756c9e838ed2_SESS_6cc064e5-04a3-489f-949a-94066ce1e3d7_TOSC_b280d5da-9f20-418b-8b0c-65d2c1a49752_PLY_','2021-04-16 09:37:01','2021-04-16 11:34:39','06d4171d-f4af-4a47-8d29-7a22eccf6dc5.ply','2021-04-16 11:37:01','SYNCED','367a7229-9c01-446a-b799-b2a913b838c6',1,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.76.1.2\",\"modelMatrix\":\"0.564016,-0.789605,0.241681,0,0.825764,0.539319,-0.165074,0,5.71317e-9,0.292676,0.956212,0,2.52214,-33.8001,-14.81,1\",\"title\":\"Maxillaire PLY\"}'),(2,'06d5bef1-e212-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/06d5bef1-e212-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_9f209306-6fc2-4865-9b41-2503c70e4e82_SESS_360e2b7c-c3bf-422a-9a48-fd86cdcc3b12_BOSC_c20c1c39-b3b1-45bc-a46b-4b0ef5a5c4d4_PLY_','2020-12-07 12:00:37','2020-08-19 13:32:22','06d5bef1-e212-11ea-947d-226cec7cb58a.ply','2020-12-07 13:00:37','SYNCED','06d5bef1-e212-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.26.27.1.2\",\"modelMatrix\":\"-0.900485,-0.402815,0.163912,0,0.434888,-0.834075,0.339399,0,-1.21998e-8,0.376907,0.926251,0,-19.6692,5.4514,-16.5944,1\",\"title\":\"Mandibule PLY\"}'),(2,'06d62337-73ab-493d-8ce7-f73bb52dc2b5','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/06d62337-73ab-493d-8ce7-f73bb52dc2b5.png','SNAPS','PATIENT_2e0a8247-f698-45b5-87fe-8b1e7c952f36_ACT_a005c34f-a90a-4fde-8c2e-5bace0d77f0c_SESS_01c37b91-46ba-4fa6-9762-3f7aa6619929_TOSC_3c571cc3-50b0-4e54-88cc-55c4902db06a_SNAPS_','2020-12-02 10:32:03','2020-10-28 16:10:30','06d62337-73ab-493d-8ce7-f73bb52dc2b5.png','2020-12-02 11:32:03','SYNCED','06d62337-73ab-493d-8ce7-f73bb52dc2b5',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.35.9.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'06dca245-24e4-40d8-bd3e-97ffe3c8885c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/06dca245-24e4-40d8-bd3e-97ffe3c8885c.ply','PLY','PATIENT_2d2ab769-b0eb-4c9d-9324-a61bb1c00027_ACT_c1d82192-2383-4fea-b6a0-d56adafa5cfe_SESS_6274ad03-e876-4fad-b568-81bb2ec0a215_BOSC_a50442b3-5855-4580-9614-e22a7cbf1390_PLY_','2021-01-08 09:02:27','2021-01-08 09:56:02','06dca245-24e4-40d8-bd3e-97ffe3c8885c.ply','2021-01-08 10:02:27','SYNCED','06dca245-24e4-40d8-bd3e-97ffe3c8885c',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.70.1.1\",\"modelMatrix\":\"-0.995612,0.0920577,-0.0167809,0,-0.0935747,-0.979472,0.178545,0,-9.72451e-10,0.179332,0.983789,0,-10.2671,16.2962,-20.3347,1\",\"title\":\"Mandibule PLY\"}'),(2,'06e27317-2a7e-4544-9d1a-db19e4005220','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/06e27317-2a7e-4544-9d1a-db19e4005220.png','SNAPS','PATIENT_86cf9c07-e5b3-42c7-9dc5-a35893bf96ff_ACT_e1c856ec-8779-4a27-81d8-1efe32d9844f_SESS_7c0138d5-1de3-4242-9ef7-4bca4877562b_BOSC_75bebf5e-ef27-4845-ac7f-6a3589bd132d_SNAPS_','2021-03-24 12:36:45','2021-03-24 13:33:29','06e27317-2a7e-4544-9d1a-db19e4005220.png','2021-03-24 13:36:45','SYNCED','06e27317-2a7e-4544-9d1a-db19e4005220',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.114.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'06ea002b-0a78-441d-aed0-69ebed1b8e67','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/06ea002b-0a78-441d-aed0-69ebed1b8e67.ply','PLY','PATIENT_ee4744a4-0cfa-43ac-9f41-9b2f812ad53d_ACT_93fe39b1-22fa-40c6-9508-a1e59ecdb3de_SESS_c3b612b4-bea4-4d2f-a26e-e720114fd914_TOSC_b3afedf8-e464-4f33-8738-3aa38dc38a08_PLY_','2021-12-30 18:03:04','2019-07-15 17:26:54','06ea002b-0a78-441d-aed0-69ebed1b8e67.ply','2021-12-30 19:03:04','SYNCED','7ec36ae8-ef6e-47b4-a27f-9b8d4535a3f2',1,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 72.1.1.1\",\"modelMatrix\":\"0.889398,-0.416987,0.187334,0,0.457134,0.811287,-0.364475,0,-6.35333e-9,0.4098,0.912175,0,13.6667,-40.099,-11.6335,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'06ec7c3f-4f45-452f-8f49-2cd390b8ee92','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/06ec7c3f-4f45-452f-8f49-2cd390b8ee92.png','SNAPS','PATIENT_b66c8b16-da16-4738-b82d-c2ca14d347df_ACT_e05ca76e-09b0-4832-915f-5d8f769e2ea5_SESS_540861f8-5ba9-4984-8617-509dd1da3f0e_TOSC_374a902c-e2a4-4899-a882-226cd0645ca1_SNAPS_','2020-12-23 09:07:31','2019-12-18 14:09:59','06ec7c3f-4f45-452f-8f49-2cd390b8ee92.png','2020-12-23 10:07:31','SYNCED','06ec7c3f-4f45-452f-8f49-2cd390b8ee92',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 20.1.267.1.1.2\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'06f90cc5-c69a-4972-ad1f-0d89327cc77b','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/06f90cc5-c69a-4972-ad1f-0d89327cc77b.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_8747c9b4-dc00-463c-b735-eeef3cc36d84_SESS_af348d2b-d0fb-41f5-94f5-a93139e5636d_TOSC_a10e47d6-23ee-4a35-9ed5-d6bd42c09b3e_ZIP_','2022-02-23 09:41:17','2022-02-23 10:41:15','06f90cc5-c69a-4972-ad1f-0d89327cc77b.zip','2022-02-23 10:41:17','SYNCED','06f90cc5-c69a-4972-ad1f-0d89327cc77b',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.21.1.4\",\"modelMatrix\":\"0.745367,-0.609368,0.270367,0,0.666654,0.681317,-0.30229,0,1.24417e-08,0.405559,0.914069,0,5.79782,-40.3189,-15.6621,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'06fc1af4-ec75-4f0f-b304-b2fbb3f258e4','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/06fc1af4-ec75-4f0f-b304-b2fbb3f258e4.png','SNAPS','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_e8fe153e-6183-4290-888f-5e919f880ad3_SESS_58365649-bae7-453c-bfbd-91775e46c6ad_TOSC_8f7eb0b9-e4ab-411c-af9b-73dfbaf995f5_SNAPS_','2020-12-07 12:00:37','2020-08-19 10:58:30','06fc1af4-ec75-4f0f-b304-b2fbb3f258e4.png','2020-12-07 13:00:37','SYNCED','06fc1af4-ec75-4f0f-b304-b2fbb3f258e4',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.26.25.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'06fd3671-30b6-472a-a7b2-663f003673d7','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/06fd3671-30b6-472a-a7b2-663f003673d7.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_63cad8a7-ad8a-45a0-9b8c-0cd14133beb1_SESS_301fa620-c944-4147-9b90-4343dc3a468b_TOSC_f75e676b-5fa5-4e04-a767-dcdbfe755df8_SNAPS_','2020-12-16 10:51:38','2020-05-20 14:59:27','06fd3671-30b6-472a-a7b2-663f003673d7.png','2020-12-16 11:51:38','SYNCED','06fd3671-30b6-472a-a7b2-663f003673d7',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 216.1.2.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'07034e7f-9850-47b6-bbda-171d61ce6047','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07034e7f-9850-47b6-bbda-171d61ce6047.ply','PLY','PATIENT_1726cd89-f2a1-4528-bf69-d3a18a5aaa71_ACT_afbd2d3d-fdc4-4c89-b445-f65a75119d97_SESS_71887ae7-34c5-4a58-9942-d643739a52f4_TOSC_4d480282-a30b-422f-b05b-c7b46744b349_PLY_','2020-12-16 10:51:38','2020-02-05 13:27:27','07034e7f-9850-47b6-bbda-171d61ce6047.ply','2020-12-16 11:51:38','SYNCED','07034e7f-9850-47b6-bbda-171d61ce6047',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"modelMatrix\":\"0.912101,-0.386215,0.137513,0,0.409965,0.85926,-0.305943,0,-4.03176e-9,0.335426,0.942066,0,12.5029,-25.914,-17.5718,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'07078b77-9aa6-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07078b77-9aa6-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_346179d4-644c-4816-83f1-b1c374c2c119_SESS_e736d7e4-27ed-44f2-be3d-a50efcf33db4_TOSC_e953b5a5-0174-441b-9d65-1dd36187779c_PLY_','2020-12-16 10:51:38','2020-05-20 16:24:51','07078b77-9aa6-11ea-947d-226cec7cb58a.ply','2020-12-16 11:51:38','SYNCED','07078b77-9aa6-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 216.1.7.1.1\",\"modelMatrix\":\"-0.361508,-0.898338,0.249601,0,0.932369,-0.348313,0.0967778,0,-4.5028e-9,0.267706,0.963501,0,-27.2562,-17.9704,-21.7141,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0709ad38-9aa6-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0709ad38-9aa6-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_346179d4-644c-4816-83f1-b1c374c2c119_SESS_e736d7e4-27ed-44f2-be3d-a50efcf33db4_TOSC_e953b5a5-0174-441b-9d65-1dd36187779c_SNAPS_','2020-12-16 10:51:39','2020-05-20 16:24:51','0709ad38-9aa6-11ea-947d-226cec7cb58a.png','2020-12-16 11:51:39','SYNCED','0709ad38-9aa6-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 216.1.7.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'070a1f7f-3193-44e5-b2ca-2fc8e55458c2','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/070a1f7f-3193-44e5-b2ca-2fc8e55458c2.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_16d7b282-66e1-4355-9b60-0bafa1ca8e98_SESS_220665e1-59d7-472e-9aaf-149ee093a8e1_TOSC_43b0bf3c-4e11-4230-b40a-c0d9f728e658_SNAPS_','2020-12-16 10:51:39','2020-05-27 16:14:40','070a1f7f-3193-44e5-b2ca-2fc8e55458c2.png','2020-12-16 11:51:39','SYNCED','070a1f7f-3193-44e5-b2ca-2fc8e55458c2',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 216.1.18.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'070abf44-a38e-4718-a888-78d19638df0e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/070abf44-a38e-4718-a888-78d19638df0e.ply','PLY','PATIENT_f6a9d20f-4172-4d39-ba1f-4f41db70ecf7_ACT_fd08bf2b-a80c-4955-aae7-db4757ea760f_SESS_835f8695-828f-44c2-b917-01ed20fcf20f_BOSC_9587fc84-7571-48b4-ae98-413ef6e5f2f5_PLY_','2021-12-30 18:03:04','2019-07-30 13:42:54','070abf44-a38e-4718-a888-78d19638df0e.ply','2021-12-30 19:03:04','SYNCED','070abf44-a38e-4718-a888-78d19638df0e',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 117.1.1.1\",\"modelMatrix\":\"-0.986844,-0.157745,0.0354338,0,0.161676,-0.962851,0.216282,0,3.75321e-9,0.219166,0.975688,0,-20.0397,10.0574,-26.2799,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'070b8cde-9aa6-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/070b8cde-9aa6-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_346179d4-644c-4816-83f1-b1c374c2c119_SESS_e736d7e4-27ed-44f2-be3d-a50efcf33db4_BOSC_28317be3-724b-40c0-acd2-71b025a48fb8_SNAPS_','2020-12-16 10:51:39','2020-05-20 16:27:12','070b8cde-9aa6-11ea-947d-226cec7cb58a.png','2020-12-16 11:51:39','SYNCED','070b8cde-9aa6-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 216.1.7.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'070d80b9-9aa6-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/070d80b9-9aa6-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_346179d4-644c-4816-83f1-b1c374c2c119_SESS_e736d7e4-27ed-44f2-be3d-a50efcf33db4_BOSC_28317be3-724b-40c0-acd2-71b025a48fb8_PLY_','2020-12-16 10:51:40','2020-05-20 16:27:12','070d80b9-9aa6-11ea-947d-226cec7cb58a.ply','2020-12-16 11:51:40','SYNCED','070d80b9-9aa6-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 216.1.7.1.1\",\"modelMatrix\":\"-0.96938,0.227565,-0.0922842,0,-0.245565,-0.898324,0.364296,0,-1.63901e-10,0.375803,0.9267,0,-16.5924,16.96,-16.3113,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'070ec948-1901-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/070ec948-1901-11eb-94ee-226cec7cb58a.png','SNAPS','PATIENT_2e0a8247-f698-45b5-87fe-8b1e7c952f36_ACT_a60b1c03-b566-4964-b12a-ced51431efdd_SESS_b7580fc5-6611-43c1-baaa-cfa1effddd41_TOSC_82f37fe4-2b10-4682-a9bf-9d249ae573f0_SNAPS_','2020-12-02 10:32:05','2020-10-28 10:29:10','070ec948-1901-11eb-94ee-226cec7cb58a.png','2020-12-02 11:32:05','SYNCED','070ec948-1901-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.35.2.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'070ffcfe-60d6-4721-9340-64ab318365b3','','PLY','PATIENT_af619d80-08a4-4cb1-b92b-68a76a27f62b_ACT_07261ac3-bc31-42a4-ac05-781b7bdfc7da_SESS_a9f12e9b-c9c3-4afc-97a5-170b879fd704_BOSC_ad826a01-60d1-42f4-8f9b-398f97c6681c_PLY_','2021-09-17 13:22:19','2021-09-17 15:22:13','','2021-09-17 15:22:19','SYNCED','070ffcfe-60d6-4721-9340-64ab318365b3',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.395.1.1.1\",\"modelMatrix\":\"-0.864707,-0.48173,0.14219,0,0.502276,-0.829335,0.24479,0,3.21902e-9,0.28309,0.959093,0,-25.2421,3.9099,-19.1231,1\",\"title\":\"Mandibule PLY\"}'),(2,'0710005b-aadd-4c8d-aeb5-a4c43f941002','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0710005b-aadd-4c8d-aeb5-a4c43f941002.png','SNAPS','PATIENT_18401d60-483b-4b93-9647-53c77e9930bd_ACT_c1277707-2973-4f51-a731-cb23e64a7a44_SESS_bc075a83-0346-4556-9154-f07079993cd8_TOSC_5a00f895-d081-4305-b452-88e1f51d797f_SNAPS_','2020-12-08 17:25:47','2020-06-05 10:35:25','0710005b-aadd-4c8d-aeb5-a4c43f941002.png','2020-12-08 18:25:47','SYNCED','0710005b-aadd-4c8d-aeb5-a4c43f941002',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.22.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'07128b0d-1901-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07128b0d-1901-11eb-94ee-226cec7cb58a.png','SNAPS','PATIENT_2e0a8247-f698-45b5-87fe-8b1e7c952f36_ACT_a60b1c03-b566-4964-b12a-ced51431efdd_SESS_b7580fc5-6611-43c1-baaa-cfa1effddd41_BOSC_e1a03e3f-bc3b-40f6-9e23-66b3d9506e2d_SNAPS_','2020-12-02 10:32:05','2020-10-28 10:34:36','07128b0d-1901-11eb-94ee-226cec7cb58a.png','2020-12-02 11:32:05','SYNCED','07128b0d-1901-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.35.2.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'07159b8f-4d9b-4dc8-b555-167f0c71a9cf','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07159b8f-4d9b-4dc8-b555-167f0c71a9cf.ply','PLY','PATIENT_e7a45a68-ba38-4e97-bfd2-34fd3e8d0d4a_ACT_ebf70c6b-8993-444f-b73a-7b93ad4320dc_SESS_d591e9f4-fee5-48a1-bf3f-02ffa1a384cc_BOSC_d476a1e0-d16e-4fc3-bdfd-fe557cbf8869_PLY_','2022-03-04 13:40:22','2019-07-10 17:46:46','07159b8f-4d9b-4dc8-b555-167f0c71a9cf.ply','2022-03-04 14:40:22','SYNCED','07159b8f-4d9b-4dc8-b555-167f0c71a9cf',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 35.1.1.1\",\"modelMatrix\":\"-0.950688,-0.294787,0.0963967,0,0.310148,-0.903603,0.295482,0,6.14392e-9,0.310809,0.950472,0,-21.4337,9.7346,-28.879,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'07165dff-1901-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07165dff-1901-11eb-94ee-226cec7cb58a.ply','PLY','PATIENT_2e0a8247-f698-45b5-87fe-8b1e7c952f36_ACT_a60b1c03-b566-4964-b12a-ced51431efdd_SESS_b7580fc5-6611-43c1-baaa-cfa1effddd41_BOSC_e1a03e3f-bc3b-40f6-9e23-66b3d9506e2d_PLY_','2020-12-02 10:32:05','2020-10-28 10:34:36','07165dff-1901-11eb-94ee-226cec7cb58a.ply','2020-12-02 11:32:05','SYNCED','07165dff-1901-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.35.2.1.1\",\"modelMatrix\":\"-0.947586,-0.291646,0.130474,0,0.319501,-0.864973,0.386963,0,4.82352e-9,0.408367,0.912818,0,-22.1626,6.2235,-20.1639,1\",\"title\":\"Mandibule PLY\"}'),(2,'07179781-1901-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07179781-1901-11eb-94ee-226cec7cb58a.ply','PLY','PATIENT_2e0a8247-f698-45b5-87fe-8b1e7c952f36_ACT_a60b1c03-b566-4964-b12a-ced51431efdd_SESS_b7580fc5-6611-43c1-baaa-cfa1effddd41_TOSC_82f37fe4-2b10-4682-a9bf-9d249ae573f0_PLY_','2020-12-02 10:32:05','2020-10-28 10:29:10','07179781-1901-11eb-94ee-226cec7cb58a.ply','2020-12-02 11:32:05','SYNCED','07179781-1901-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.35.2.1.1\",\"modelMatrix\":\"0.0483946,-0.96853,0.244148,0,0.998828,0.0469266,-0.0118293,0,8.9802e-10,0.244435,0.969666,0,-17.5135,-25.597,-19.3306,1\",\"title\":\"Maxillaire PLY\"}'),(2,'071b8999-ce23-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/071b8999-ce23-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_6df72f48-6933-4986-9961-403150b72460_ACT_8066fb46-4e88-4174-a7b5-ced23d87937b_SESS_59d4c3ec-651e-4d62-b38d-23c6193830fb_BOSC_6c729960-d05e-4459-88a9-b2710ad7af41_PLY_','2021-12-30 18:03:05','2019-09-03 10:13:47','071b8999-ce23-11e9-947d-226cec7cb58a.ply','2021-12-30 19:03:05','SYNCED','071b8999-ce23-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 140.1.1.1\",\"modelMatrix\":\"0.507186,-0.860924,0.0396495,0,0.861836,0.506649,-0.0233335,0,4.80862e-10,0.0460058,0.998941,0,-7.8918,-25.1397,-25.2686,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'071cb9b4-ce23-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/071cb9b4-ce23-11e9-947d-226cec7cb58a.stl','STL','PATIENT_6df72f48-6933-4986-9961-403150b72460_ACT_8066fb46-4e88-4174-a7b5-ced23d87937b_SESS_59d4c3ec-651e-4d62-b38d-23c6193830fb_TOSC_c6783949-8a9a-42ca-814a-9600e7796d81_STL_','2021-12-30 18:03:05','2019-09-03 10:05:40','071cb9b4-ce23-11e9-947d-226cec7cb58a.stl','2021-12-30 19:03:05','SYNCED','071cb9b4-ce23-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 140.1.1.1\",\"modelMatrix\":\"0.413128,-0.815308,0.405707,0,0.910673,0.369866,-0.18405,0,-5.23369e-9,0.445503,0.895281,0,-9.9541,-42.7607,-15.8659,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'071e282b-ce23-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/071e282b-ce23-11e9-947d-226cec7cb58a.stl','STL','PATIENT_6df72f48-6933-4986-9961-403150b72460_ACT_8066fb46-4e88-4174-a7b5-ced23d87937b_SESS_59d4c3ec-651e-4d62-b38d-23c6193830fb_BOSC_6c729960-d05e-4459-88a9-b2710ad7af41_STL_','2021-12-30 18:03:05','2019-09-03 10:13:47','071e282b-ce23-11e9-947d-226cec7cb58a.stl','2021-12-30 19:03:05','SYNCED','071e282b-ce23-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 140.1.1.1\",\"modelMatrix\":\"0.507186,-0.860924,0.0396495,0,0.861836,0.506649,-0.0233335,0,4.80862e-10,0.0460058,0.998941,0,-7.8918,-25.1397,-25.2686,1\",\"title\":\"MANDIBULE STL\"}'),(2,'071f8cc5-ce23-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/071f8cc5-ce23-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_6df72f48-6933-4986-9961-403150b72460_ACT_8066fb46-4e88-4174-a7b5-ced23d87937b_SESS_59d4c3ec-651e-4d62-b38d-23c6193830fb_TOSC_c6783949-8a9a-42ca-814a-9600e7796d81_SNAPS_','2021-12-30 18:03:06','2019-09-03 10:05:40','071f8cc5-ce23-11e9-947d-226cec7cb58a.png','2021-12-30 19:03:06','SYNCED','071f8cc5-ce23-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 140.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'071ff6c8-e267-441a-854b-a686e8ad198d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/071ff6c8-e267-441a-854b-a686e8ad198d.png','SNAPS','PATIENT_dde53ea4-f623-42e4-9864-d8e77d9deabe_ACT_c658c808-2655-4213-a8a0-1c34d5830ee5_SESS_ad32c977-4115-45c7-9168-d19d87c66102_TOSC_b289381b-23ec-4a96-9206-71132277e1ca_SNAPS_','2021-12-30 18:03:06','2019-11-22 08:14:15','071ff6c8-e267-441a-854b-a686e8ad198d.png','2021-12-30 19:03:06','SYNCED','071ff6c8-e267-441a-854b-a686e8ad198d',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 208.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0720db1c-ce23-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0720db1c-ce23-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_6df72f48-6933-4986-9961-403150b72460_ACT_8066fb46-4e88-4174-a7b5-ced23d87937b_SESS_59d4c3ec-651e-4d62-b38d-23c6193830fb_TOSC_c6783949-8a9a-42ca-814a-9600e7796d81_PLY_','2021-12-30 18:03:06','2019-09-03 10:05:40','0720db1c-ce23-11e9-947d-226cec7cb58a.ply','2021-12-30 19:03:06','SYNCED','0720db1c-ce23-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 140.1.1.1\",\"modelMatrix\":\"0.413128,-0.815308,0.405707,0,0.910673,0.369866,-0.18405,0,-5.23369e-9,0.445503,0.895281,0,-9.9541,-42.7607,-15.8659,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'07221d26-ce23-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07221d26-ce23-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_6df72f48-6933-4986-9961-403150b72460_ACT_8066fb46-4e88-4174-a7b5-ced23d87937b_SESS_59d4c3ec-651e-4d62-b38d-23c6193830fb_BOSC_6c729960-d05e-4459-88a9-b2710ad7af41_SNAPS_','2021-12-30 18:03:06','2019-09-03 10:13:47','07221d26-ce23-11e9-947d-226cec7cb58a.png','2021-12-30 19:03:06','SYNCED','07221d26-ce23-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 140.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0723bea1-afcc-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0723bea1-afcc-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_b336036e-8165-40a2-ad14-ad02e4f39442_SESS_dae5cfb6-da12-4d11-a6d5-8fccb3f422e8_BOSC_9a21e55b-ef8a-4e8a-821b-47835ca1b041_PLY_','2020-12-08 17:25:51','2020-06-16 14:22:02','0723bea1-afcc-11ea-947d-226cec7cb58a.ply','2020-12-08 18:25:51','SYNCED','0723bea1-afcc-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.45.1.1\",\"modelMatrix\":\"-0.930409,0.347186,-0.117475,0,-0.366522,-0.881325,0.298208,0,7.75683e-9,0.320513,0.947244,0,-6.12106,15.9318,-17.978,1\",\"title\":\"Mandibule PLY\"}'),(2,'0723ff37-9197-4832-a5bd-0249f71008a8','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0723ff37-9197-4832-a5bd-0249f71008a8.ply','PLY','PATIENT_924bf1a2-20af-4047-90c0-8d8b8a5fceb6_ACT_d32cbe7d-f29f-48b8-8656-3065d72e68bb_SESS_f6828a70-e523-4c66-97ef-ce1749bd1c5a_BOSC_f40350c1-69dd-4af5-b5d7-9659a15cdfe3_PLY_','2021-01-06 11:02:05','2019-12-12 14:52:47','0723ff37-9197-4832-a5bd-0249f71008a8.ply','2021-01-06 12:02:05','SYNCED','0723ff37-9197-4832-a5bd-0249f71008a8',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 232.15.1.1\",\"modelMatrix\":\"-0.929789,0.36215,-0.0658759,0,-0.368093,-0.914778,0.1664,0,-1.5773e-9,0.178965,0.983855,0,-10.7689,18.4021,-20.0851,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'072658c1-afcc-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/072658c1-afcc-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_8bcf85e1-fc5f-4380-8edf-2af92062ab93_ACT_b336036e-8165-40a2-ad14-ad02e4f39442_SESS_dae5cfb6-da12-4d11-a6d5-8fccb3f422e8_TOSC_d4456386-8148-4cde-b08b-a50fd192b97f_PLY_','2020-12-08 17:25:51','2020-06-16 14:19:13','072658c1-afcc-11ea-947d-226cec7cb58a.ply','2020-12-08 18:25:51','SYNCED','072658c1-afcc-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.45.1.1\",\"modelMatrix\":\"0.615035,-0.759864,0.210566,0,0.7885,0.592699,-0.164243,0,1.1844e-8,0.267046,0.963684,0,4.77243,-33.0107,-18.0758,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0727edbf-cae2-43d1-9f65-e73d902e0dae','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0727edbf-cae2-43d1-9f65-e73d902e0dae.ply','PLY','PATIENT_c30dd79a-8ef2-482c-8fe6-9c33a39cfff2_ACT_c1ee43c4-7708-4c9f-950b-7e9bfa7afaf3_SESS_ab31f180-9314-4a7c-9461-50ac67b8d619_BOSC_6631cb53-f53e-464d-b96f-d14530a4f28c_PLY_','2021-12-30 18:03:06','2019-10-07 14:01:58','0727edbf-cae2-43d1-9f65-e73d902e0dae.ply','2021-12-30 19:03:06','SYNCED','0727edbf-cae2-43d1-9f65-e73d902e0dae',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 179.1.1.1\",\"modelMatrix\":\"-0.630789,0.766308,-0.121975,0,-0.775954,-0.622947,0.0991559,0,-3.01434e-9,0.157193,0.987568,0,3.97328,20.3738,-21.0195,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0728a220-afcc-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0728a220-afcc-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_b336036e-8165-40a2-ad14-ad02e4f39442_SESS_dae5cfb6-da12-4d11-a6d5-8fccb3f422e8_BOSC_9a21e55b-ef8a-4e8a-821b-47835ca1b041_SNAPS_','2020-12-08 17:25:52','2020-06-16 14:22:02','0728a220-afcc-11ea-947d-226cec7cb58a.png','2020-12-08 18:25:52','SYNCED','0728a220-afcc-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.45.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'072aa625-afcc-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/072aa625-afcc-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_8bcf85e1-fc5f-4380-8edf-2af92062ab93_ACT_b336036e-8165-40a2-ad14-ad02e4f39442_SESS_dae5cfb6-da12-4d11-a6d5-8fccb3f422e8_TOSC_d4456386-8148-4cde-b08b-a50fd192b97f_SNAPS_','2020-12-08 17:25:52','2020-06-16 14:19:13','072aa625-afcc-11ea-947d-226cec7cb58a.png','2020-12-08 18:25:52','SYNCED','072aa625-afcc-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.45.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'072be3ae-eb85-48e5-995d-29cbe44036a2','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/072be3ae-eb85-48e5-995d-29cbe44036a2.png','SNAPS','PATIENT_3b6c641e-e0e0-4ac9-a267-62cd4bf53002_ACT_9f504d88-30d7-4cc8-8a7b-e1a782b7333d_SESS_06405aeb-31bb-4979-8850-9a8d7791d3f5_BOSC_585d6780-8ae5-4794-8460-99b82991cc53_SNAPS_','2021-03-11 13:53:38','2021-03-11 14:42:54','072be3ae-eb85-48e5-995d-29cbe44036a2.png','2021-03-11 14:53:38','SYNCED','072be3ae-eb85-48e5-995d-29cbe44036a2',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.72.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0730523b-f935-48ca-a27d-f43c8f7106a3','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0730523b-f935-48ca-a27d-f43c8f7106a3.ply','PLY','PATIENT_5b3365d0-2ad4-4d78-9c7c-89ff37d5905d_ACT_ee6f943a-7cab-46d0-b223-fd379650024c_SESS_9f9fe29b-f6ed-4a4c-b9f0-7e6258af0943_BOSC_a24e1c9a-fc20-4b47-95ea-b65893ed0057_PLY_','2020-12-08 17:25:53','2020-06-19 09:37:06','0730523b-f935-48ca-a27d-f43c8f7106a3.ply','2020-12-08 18:25:53','SYNCED','0730523b-f935-48ca-a27d-f43c8f7106a3',0,NULL,'','','{\"displayTitle\":\"Mandibule 32.2.1.1.2\",\"modelMatrix\":\"-0.981866,0.180374,-0.0583554,0,-0.189579,-0.934192,0.302234,0,9.10093e-10,0.307817,0.951446,0,-14.3185,16.6541,-20.7588,1\",\"title\":\"Mandibule PLY\"}'),(2,'07327741-2029-4a36-90fb-43db40f32f23','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07327741-2029-4a36-90fb-43db40f32f23.png','SNAPS','PATIENT_6f774e34-628a-432f-a083-4ae3151ad4fc_ACT_dd20d07d-616c-4443-bf7a-9e9c8ba53652_SESS_244064a6-07ba-4d2b-8dd6-e362cf0e5c84_TOSC_6b668b41-8654-4f4f-b7e0-6282c5af5cf2_SNAPS_','2021-02-15 12:35:11','2021-02-15 13:22:03','07327741-2029-4a36-90fb-43db40f32f23.png','2021-02-15 13:35:11','SYNCED','07327741-2029-4a36-90fb-43db40f32f23',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.43.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0733db09-1f13-47cf-aeca-b3de74c10ed5','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0733db09-1f13-47cf-aeca-b3de74c10ed5.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_55f1a8e4-5274-4adb-b918-fed276b0c174_SESS_0be04311-9b2b-4582-a73e-a1fa84412331_TOSC_4436adfe-268d-4e32-883d-e0d0e8e1b1a0_PLY_','2021-04-08 10:18:50','2021-04-08 12:18:48','0733db09-1f13-47cf-aeca-b3de74c10ed5.ply','2021-04-08 12:18:50','SYNCED','0733db09-1f13-47cf-aeca-b3de74c10ed5',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.37.1.2\",\"modelMatrix\":\"0.533993,-0.807943,0.249156,0,0.845489,0.510281,-0.157362,0,1.00916e-8,0.294689,0.955593,0,-0.0921516,-37.6428,-14.4288,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0739c22e-f506-43b0-9847-919adf92ea99','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0739c22e-f506-43b0-9847-919adf92ea99.stl','STL','PATIENT_7bac4a06-9561-47ca-9cb2-d9c7ebf15731_ACT_4e02d446-89ce-4e03-9ebc-cd89a36784ec_SESS_bc7540fa-3b0e-4c71-bf91-69247ca18910_TOSC_00dd3495-ff4f-47d9-afd9-114212d9f7f0_STL_','2021-06-07 11:39:06','2019-12-11 16:00:21','0739c22e-f506-43b0-9847-919adf92ea99.stl','2021-06-07 13:39:06','SYNCED','0739c22e-f506-43b0-9847-919adf92ea99',0,'2021-06-07 13:39:06','','','{\"displayTitle\":\"MAXILLAIRE 232.2.1.1.1\",\"modelMatrix\":\"0.740543,-0.632643,0.226625,0,0.672009,0.697162,-0.249737,0,-1.02448e-9,0.337235,0.941421,0,12.5185,-30.8019,-20.7293,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'073af1d4-edda-47a7-a4bb-75ee0498a3d8','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/073af1d4-edda-47a7-a4bb-75ee0498a3d8.ply','PLY','PATIENT_616956a0-ee92-4787-8709-9c0704d6a0bd_ACT_4f198b58-27bd-4e69-a1a4-f2466c194213_SESS_2c7c3146-15a4-4af6-84d2-baffa844529a_BOSC_d57bd070-dec2-4d3d-aba5-27da1b70b039_PLY_','2021-03-31 07:31:08','2021-03-31 09:24:18','073af1d4-edda-47a7-a4bb-75ee0498a3d8.ply','2021-03-31 09:31:08','SYNCED','073af1d4-edda-47a7-a4bb-75ee0498a3d8',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.25.1.3\",\"modelMatrix\":\"-0.994383,-0.0977669,0.0405415,0,0.105839,-0.91854,0.380896,0,1.8793e-10,0.383047,0.923729,0,-24.5626,12.4068,-18.4901,1\",\"title\":\"Mandibule PLY\"}'),(2,'074a1ecc-b5fc-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/074a1ecc-b5fc-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_b2389b0b-ad3b-4420-9daa-220fca93b282_SESS_6131a96c-7899-4898-8dc4-6cf315fa2904_BOSC_d38a07bf-f392-42e2-b1ea-138cd7aac47a_PLY_','2020-12-08 17:25:53','2020-06-24 11:20:41','074a1ecc-b5fc-11ea-947d-226cec7cb58a.ply','2020-12-08 18:25:53','SYNCED','074a1ecc-b5fc-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.80.1.1\",\"modelMatrix\":\"0.0342917,0.989389,-0.141187,0,-0.999412,0.0339478,-0.0048444,0,5.43602e-10,0.14127,0.989971,0,15.8168,12.6736,-15.0859,1\",\"title\":\"Mandibule PLY\"}'),(2,'074c4b4b-b5fc-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/074c4b4b-b5fc-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_1639db5d-5396-4c46-a0d9-111262afadbd_ACT_b2389b0b-ad3b-4420-9daa-220fca93b282_SESS_6131a96c-7899-4898-8dc4-6cf315fa2904_TOSC_f7e6ffb3-018e-44eb-88fa-946c9bc2dd5f_PLY_','2020-12-08 17:25:54','2020-06-24 11:13:33','074c4b4b-b5fc-11ea-947d-226cec7cb58a.ply','2020-12-08 18:25:54','SYNCED','074c4b4b-b5fc-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.80.1.1\",\"modelMatrix\":\"0.799657,-0.540781,0.260968,0,0.600457,0.720184,-0.347543,0,1.74459e-8,0.434615,0.900616,0,9.72776,-27.6993,-11.9755,1\",\"title\":\"Maxillaire PLY\"}'),(2,'074e6644-b5fc-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/074e6644-b5fc-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_1639db5d-5396-4c46-a0d9-111262afadbd_ACT_b2389b0b-ad3b-4420-9daa-220fca93b282_SESS_6131a96c-7899-4898-8dc4-6cf315fa2904_TOSC_f7e6ffb3-018e-44eb-88fa-946c9bc2dd5f_SNAPS_','2020-12-08 17:25:54','2020-06-24 11:13:33','074e6644-b5fc-11ea-947d-226cec7cb58a.png','2020-12-08 18:25:54','SYNCED','074e6644-b5fc-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.80.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'07503f5b-b5fc-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07503f5b-b5fc-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_b2389b0b-ad3b-4420-9daa-220fca93b282_SESS_6131a96c-7899-4898-8dc4-6cf315fa2904_BOSC_d38a07bf-f392-42e2-b1ea-138cd7aac47a_SNAPS_','2020-12-08 17:25:54','2020-06-24 11:20:41','07503f5b-b5fc-11ea-947d-226cec7cb58a.png','2020-12-08 18:25:54','SYNCED','07503f5b-b5fc-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.80.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'07504852-6436-4d1b-b6dc-5f6ffec6322f','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07504852-6436-4d1b-b6dc-5f6ffec6322f.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_f92ed3c4-058c-4b9e-9eb9-41aa4081126e_SESS_5ff81632-8afc-4443-ae0f-1722a0365361_BOSC_7d2ec63c-4378-41a0-b769-46932c028efd_SNAPS_','2021-04-26 09:17:11','2021-04-26 11:17:10','07504852-6436-4d1b-b6dc-5f6ffec6322f.png','2021-04-26 11:17:11','SYNCED','07504852-6436-4d1b-b6dc-5f6ffec6322f',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.100.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'07659b93-1e8f-41d6-b4f6-2f9cba2d4b5a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07659b93-1e8f-41d6-b4f6-2f9cba2d4b5a.png','SNAPS','PATIENT_978991c3-73ec-4272-81bb-35e9fa062036_ACT_f94467b8-6cae-452e-880a-7e1c05d160ee_SESS_f0f0a818-08c6-47f4-9ea1-3e8b8fc3b874_BOSC_4586ec2b-739b-4247-a727-a063f25c2074_SNAPS_','2021-12-30 18:03:07','2019-09-02 10:26:52','07659b93-1e8f-41d6-b4f6-2f9cba2d4b5a.png','2021-12-30 19:03:07','SYNCED','07659b93-1e8f-41d6-b4f6-2f9cba2d4b5a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 135.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'07678823-bee8-4826-8909-258f5307302d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07678823-bee8-4826-8909-258f5307302d.stl','STL','PATIENT_d81819be-bc30-4092-b5e9-498e0cbb7c78_ACT_e2efb8df-4ec9-4c9d-98df-c9d1978d79fb_SESS_1d7bc7d7-a77e-46e6-aaa2-768afa5219c9_BOSC_ed4417fc-f174-43ac-be0d-27c541079eb3_STL_','2021-12-30 18:03:07','2019-07-15 16:35:44','07678823-bee8-4826-8909-258f5307302d.stl','2021-12-30 19:03:07','SYNCED','07678823-bee8-4826-8909-258f5307302d',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 71.1.1.1\",\"modelMatrix\":\"0.790377,0.608579,-0.0702491,0,-0.61262,0.785164,-0.0906326,0,-4.49984e-9,0.11467,0.993404,0,24.9918,-1.2555,-21.4061,1\",\"title\":\"MANDIBULE STL\"}'),(2,'0769d775-6333-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0769d775-6333-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_e94cc8a4-9fe0-4d90-8c07-d76eeaa42853_ACT_46a90cb4-1b84-4df0-aa10-463f2ced7912_SESS_fff96630-89cd-4b8d-b2b0-936f73ba3bcb_TOSC_4fe01730-ee29-424e-8ab2-5ab2286fedcc_SNAPS_','2021-12-22 13:21:42','2021-12-22 14:21:36','0769d775-6333-11ec-9377-226cec7cb58a.png','2021-12-22 14:21:42','SYNCED','0769d775-6333-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.407.7.2.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'07740dd2-6333-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07740dd2-6333-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_e94cc8a4-9fe0-4d90-8c07-d76eeaa42853_ACT_46a90cb4-1b84-4df0-aa10-463f2ced7912_SESS_fff96630-89cd-4b8d-b2b0-936f73ba3bcb_BOSC_2f94dcb1-e9b9-402b-87b9-15c314eb7090_SNAPS_','2021-12-22 14:16:24','2021-12-22 15:16:18','07740dd2-6333-11ec-9377-226cec7cb58a.png','2021-12-22 15:16:24','SYNCED','07740dd2-6333-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.407.7.2.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'077564fb-0ca5-4cd7-8b95-1271de79f701','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/077564fb-0ca5-4cd7-8b95-1271de79f701.png','SNAPS','PATIENT_bc50bff3-dacb-4f7a-a7c8-b971782c6d1d_ACT_be5de36f-b43d-47f3-b178-801c7822bb7d_SESS_df767eeb-30cd-456e-91c0-aa5269ac29d4_TOSC_8e88295e-926b-4397-8ead-e6454a4c2c67_SNAPS_','2021-08-05 07:30:45','2019-11-27 12:13:25','077564fb-0ca5-4cd7-8b95-1271de79f701.png','2021-08-05 09:30:45','SYNCED','077564fb-0ca5-4cd7-8b95-1271de79f701',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 212.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'07781f3b-6333-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07781f3b-6333-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_e94cc8a4-9fe0-4d90-8c07-d76eeaa42853_ACT_46a90cb4-1b84-4df0-aa10-463f2ced7912_SESS_fff96630-89cd-4b8d-b2b0-936f73ba3bcb_BOSC_a26b67d0-34e2-4646-a75b-27d14cfebd19_ZIP_','2021-12-22 14:06:41','2021-12-22 15:06:38','07781f3b-6333-11ec-9377-226cec7cb58a.zip','2021-12-22 15:06:41','SYNCED','07781f3b-6333-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.407.7.2.1\",\"modelMatrix\":\"0.883294,-0.443361,0.15239,0,0.46882,0.835328,-0.287114,0,1.83892e-9,0.325049,0.945697,0,10.5084,-33.4651,-20.7885,1\",\"title\":\"Mandibule ZIP\"}'),(2,'0782b215-3eb4-4339-aba7-47e30da87988','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0782b215-3eb4-4339-aba7-47e30da87988.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_6f9b06e7-95a1-4b2c-974a-63ad638a404a_SESS_00bc2be9-26ee-40d0-b135-3cea0ac87ae2_TOSC_495620a4-e965-44a8-a639-2e2dd9d954b6_PLY_','2020-12-16 10:51:43','2020-05-22 14:10:19','0782b215-3eb4-4339-aba7-47e30da87988.ply','2020-12-16 11:51:43','SYNCED','0782b215-3eb4-4339-aba7-47e30da87988',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 216.1.9.1.1\",\"modelMatrix\":\"0.15418,-0.953114,0.260387,0,0.988043,0.148729,-0.0406322,0,2.59738e-9,0.263538,0.964649,0,-18.7177,-25.5279,-13.8068,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0783951f-2337-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0783951f-2337-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_aff4eaff-030a-4db3-bb48-829132017f6c_ACT_2ff44845-9186-4589-bd19-c7c20e898d46_SESS_0df16f53-eb00-4ebd-9c14-fe6fa158742f_TOSC_baa7f31c-3db8-49ce-8afe-d9403ad64066_PLY_','2020-12-23 09:07:35','2019-12-20 15:42:18','0783951f-2337-11ea-947d-226cec7cb58a.ply','2020-12-23 10:07:35','SYNCED','0783951f-2337-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"modelMatrix\":\"0.707269,-0.66098,0.25075,0,0.706944,0.661284,-0.250865,0,-3.49905e-9,0.354695,0.934982,0,2.10528,-31.4426,-12.8581,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'07856f3d-2337-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07856f3d-2337-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_aff4eaff-030a-4db3-bb48-829132017f6c_ACT_2ff44845-9186-4589-bd19-c7c20e898d46_SESS_0df16f53-eb00-4ebd-9c14-fe6fa158742f_TOSC_baa7f31c-3db8-49ce-8afe-d9403ad64066_SNAPS_','2020-12-23 09:07:35','2019-12-20 15:42:18','07856f3d-2337-11ea-947d-226cec7cb58a.png','2020-12-23 10:07:35','SYNCED','07856f3d-2337-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0786ca96-a28a-4e3c-a20b-c4d936052ce2','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0786ca96-a28a-4e3c-a20b-c4d936052ce2.ply','PLY','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_8e0fa860-808d-408c-b6a9-f15670797e86_SESS_9eccd5ad-22e1-4c9e-aa28-9e198895075c_BOSC_4a4ef6e8-6682-46cd-bb7b-55c88a77534b_PLY_','2021-04-07 12:10:41','2021-04-07 14:10:39','0786ca96-a28a-4e3c-a20b-c4d936052ce2.ply','2021-04-07 14:10:41','SYNCED','8a3ab4ca-cf74-44ba-85b5-3e648181abd9',1,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.15.1.2\",\"modelMatrix\":\"-0.956513,-0.287228,0.0508238,0,0.29169,-0.941881,0.166662,0,5.84493e-9,0.174239,0.984703,0,15.7894,19.5097,-19.3772,1\",\"title\":\"Mandibule PLY\"}'),(2,'078c2194-1616-4645-8e23-4bcc8fdbafc9','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/078c2194-1616-4645-8e23-4bcc8fdbafc9.ply','PLY','PATIENT_ecb022a6-467a-466f-8c28-303b6d69ac67_ACT_20ec3354-21f6-4b54-84fe-d6276ccfe88c_SESS_a3398e51-3c47-4c0e-a01e-b388ec40968a_BOSC_d2088495-0a54-44e7-b118-1dc6edf8f0b5_PLY_','2021-01-04 08:53:26','2021-01-04 09:47:42','078c2194-1616-4645-8e23-4bcc8fdbafc9.ply','2021-01-04 09:53:26','SYNCED','078c2194-1616-4645-8e23-4bcc8fdbafc9',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.65.1.1\",\"modelMatrix\":\"-0.999377,0.0345122,-0.0073153,0,-0.035279,-0.977657,0.207227,0,-2.5149e-10,0.207356,0.978266,0,-14.4544,13.8232,-19.444,1\",\"title\":\"Mandibule PLY\"}'),(2,'0793262e-99c0-471d-a612-875db30dcc74','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0793262e-99c0-471d-a612-875db30dcc74.png','SNAPS','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_1b04f888-3de3-4ebf-ab9c-e34753a7524d_SESS_7e214c47-5f56-495a-9e3e-c7bd35d49b80_BOSC_d5baa18b-a4d3-4edf-8b22-58c2d6f3e1cd_SNAPS_','2020-12-23 09:07:36','2020-01-02 15:50:24','0793262e-99c0-471d-a612-875db30dcc74.png','2020-12-23 10:07:36','SYNCED','0793262e-99c0-471d-a612-875db30dcc74',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'079ab9c7-9455-4089-aa38-1041ebaccbce','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/079ab9c7-9455-4089-aa38-1041ebaccbce.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_80b318af-d67d-44d1-b260-7d411c065f0f_SESS_4b58d2d7-b749-4b44-a9a5-6caa8efd1fab_BOSC_285fd317-370a-4173-98ab-d7ae93ba4d31_SNAPS_','2022-03-23 14:36:45','2022-03-23 15:36:41','079ab9c7-9455-4089-aa38-1041ebaccbce.png','2022-03-23 15:36:45','SYNCED','079ab9c7-9455-4089-aa38-1041ebaccbce',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.37.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'079ac2fc-6333-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/079ac2fc-6333-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_e94cc8a4-9fe0-4d90-8c07-d76eeaa42853_ACT_46a90cb4-1b84-4df0-aa10-463f2ced7912_SESS_fff96630-89cd-4b8d-b2b0-936f73ba3bcb_TOSC_4fe01730-ee29-424e-8ab2-5ab2286fedcc_ZIP_','2021-12-22 13:21:42','2021-12-22 14:21:37','079ac2fc-6333-11ec-9377-226cec7cb58a.zip','2021-12-22 14:21:42','SYNCED','079ac2fc-6333-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.407.7.2.1\",\"modelMatrix\":\"0.658851,-0.674204,0.333713,0,0.752274,0.590476,-0.29227,0,1.05609e-9,0.443606,0.896222,0,5.85397,-33.3106,-17.0352,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'079e7f1a-6333-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/079e7f1a-6333-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_e94cc8a4-9fe0-4d90-8c07-d76eeaa42853_ACT_46a90cb4-1b84-4df0-aa10-463f2ced7912_SESS_fff96630-89cd-4b8d-b2b0-936f73ba3bcb_TOSC_c311ea56-12df-49bf-8f81-eacaa4c78e10_SNAPS_','2021-12-22 13:28:41','2021-12-22 14:28:36','079e7f1a-6333-11ec-9377-226cec7cb58a.png','2021-12-22 14:28:41','SYNCED','079e7f1a-6333-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.407.7.2.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'07a1920d-0d99-475c-8594-7849c71b16fc','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07a1920d-0d99-475c-8594-7849c71b16fc.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_4de71ba9-2d22-47bd-a861-952024a15f21_SESS_c6917367-0b2b-4b87-8918-9b9d9c2ae72d_TOSC_4f3182d7-a824-486c-9e9b-96687e06f172_PLY_','2021-07-20 08:19:30','2021-07-20 10:16:48','07a1920d-0d99-475c-8594-7849c71b16fc.ply','2021-07-20 10:19:30','SYNCED','810cbb01-9845-463a-a94a-b13dea521cb8',1,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.168.1.3\",\"modelMatrix\":\"0.833192,-0.452065,0.318477,0,0.552983,0.681137,-0.479856,0,8.03931e-9,0.575925,0.817503,0,8.45429,-42.3219,-33.8924,1\",\"title\":\"Maxillaire PLY\"}'),(2,'07a22ba4-6333-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07a22ba4-6333-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_e94cc8a4-9fe0-4d90-8c07-d76eeaa42853_ACT_46a90cb4-1b84-4df0-aa10-463f2ced7912_SESS_fff96630-89cd-4b8d-b2b0-936f73ba3bcb_TOSC_c311ea56-12df-49bf-8f81-eacaa4c78e10_ZIP_','2021-12-22 13:28:41','2021-12-22 14:28:37','07a22ba4-6333-11ec-9377-226cec7cb58a.zip','2021-12-22 14:28:41','SYNCED','07a22ba4-6333-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.407.7.2.2\",\"modelMatrix\":\"0.701947,-0.670726,0.239578,0,0.712229,0.661042,-0.236119,0,1.2204e-9,0.336378,0.941727,0,0.550383,-40.6273,-14.923,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'07a5f4d8-f064-424f-a9bf-ec562f83cbd2','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07a5f4d8-f064-424f-a9bf-ec562f83cbd2.png','SNAPS','PATIENT_be48faa5-408d-4557-9d5f-60c67821aff4_ACT_9f77cb0d-bdf4-4451-a561-df188dcfd90b_SESS_ae5d102d-69f4-4a1f-ad3d-ce4a77600f7b_TOSC_aed6d770-14a0-4a08-b1dc-657cd2564cc8_SNAPS_','2020-12-16 10:51:44','2020-02-05 11:31:58','07a5f4d8-f064-424f-a9bf-ec562f83cbd2.png','2020-12-16 11:51:44','SYNCED','07a5f4d8-f064-424f-a9bf-ec562f83cbd2',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'07a61e95-6333-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07a61e95-6333-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_e94cc8a4-9fe0-4d90-8c07-d76eeaa42853_ACT_46a90cb4-1b84-4df0-aa10-463f2ced7912_SESS_fff96630-89cd-4b8d-b2b0-936f73ba3bcb_BOSC_683f2ba8-1a79-4b2c-af1f-05f12019e8da_ZIP_','2021-12-22 14:24:18','2021-12-22 15:24:16','07a61e95-6333-11ec-9377-226cec7cb58a.zip','2021-12-22 15:24:18','SYNCED','07a61e95-6333-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.407.7.2.4\",\"modelMatrix\":\"-0.556745,-0.801888,0.21682,0,0.830683,-0.537445,0.145318,0,5.39281e-9,0.261014,0.965335,0,-27.884,-9.30374,-26.8498,1\",\"title\":\"Mandibule ZIP\"}'),(2,'07a64a34-992c-4c47-a96c-7584fa9656f8','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07a64a34-992c-4c47-a96c-7584fa9656f8.stl','STL','PATIENT_fcf8c111-84a1-4f17-859c-ea2ad21d373b_ACT_d27c23bb-fa1e-4cd8-bacc-e2b65114a20e_SESS_844480c5-a8a8-4eb3-a014-e1424d66a1ca_TOSC_6ee11505-19ec-4ef6-8ea1-4eca73d57bad_STL_','2021-12-30 18:03:08','2019-11-18 11:53:39','07a64a34-992c-4c47-a96c-7584fa9656f8.stl','2021-12-30 19:03:08','SYNCED','07a64a34-992c-4c47-a96c-7584fa9656f8',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 168.1.1.1.1\",\"modelMatrix\":\"0.416599,-0.850788,0.320321,0,0.90909,0.389881,-0.14679,0,-7.49928e-9,0.352353,0.935867,0,-8.21069,-35.5188,-22.7189,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'07a92fbe-d5ff-45d3-9538-794d56da4123','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07a92fbe-d5ff-45d3-9538-794d56da4123.png','SNAPS','PATIENT_f6b8f770-e3c3-495b-81be-6f92a2e90b58_ACT_ef9a71c5-5d5c-4f0e-ae3f-364b877cd1bc_SESS_b6e8b00a-7cef-4920-91e2-8d913070aa8c_TOSC_cc75fe0c-990a-44b7-b6d1-2ab4361205b9_SNAPS_','2021-02-12 10:13:26','2021-02-12 11:00:57','07a92fbe-d5ff-45d3-9538-794d56da4123.png','2021-02-12 11:13:26','SYNCED','07a92fbe-d5ff-45d3-9538-794d56da4123',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.38.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'07aa2644-6333-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07aa2644-6333-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_e94cc8a4-9fe0-4d90-8c07-d76eeaa42853_ACT_46a90cb4-1b84-4df0-aa10-463f2ced7912_SESS_fff96630-89cd-4b8d-b2b0-936f73ba3bcb_TOSC_345c6fe9-46ec-414c-bb76-3b47f7e195f4_SNAPS_','2021-12-22 13:36:35','2021-12-22 14:36:30','07aa2644-6333-11ec-9377-226cec7cb58a.png','2021-12-22 14:36:35','SYNCED','07aa2644-6333-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.407.7.2.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'07af75f3-6333-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07af75f3-6333-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_e94cc8a4-9fe0-4d90-8c07-d76eeaa42853_ACT_46a90cb4-1b84-4df0-aa10-463f2ced7912_SESS_fff96630-89cd-4b8d-b2b0-936f73ba3bcb_BOSC_683f2ba8-1a79-4b2c-af1f-05f12019e8da_SNAPS_','2021-12-22 14:24:18','2021-12-22 15:24:14','07af75f3-6333-11ec-9377-226cec7cb58a.png','2021-12-22 15:24:18','SYNCED','07af75f3-6333-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.407.7.2.4\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'07b3f029-6333-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07b3f029-6333-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_e94cc8a4-9fe0-4d90-8c07-d76eeaa42853_ACT_46a90cb4-1b84-4df0-aa10-463f2ced7912_SESS_fff96630-89cd-4b8d-b2b0-936f73ba3bcb_BOSC_2f94dcb1-e9b9-402b-87b9-15c314eb7090_ZIP_','2021-12-22 14:16:23','2021-12-22 15:16:20','07b3f029-6333-11ec-9377-226cec7cb58a.zip','2021-12-22 15:16:23','SYNCED','07b3f029-6333-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.407.7.2.3\",\"modelMatrix\":\"0.616118,-0.767671,0.176293,0,0.787654,0.600488,-0.1379,0,-2.79237e-9,0.22382,0.97463,0,2.23345,-31.5051,-23.1436,1\",\"title\":\"Mandibule ZIP\"}'),(2,'07b799af-6333-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07b799af-6333-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_e94cc8a4-9fe0-4d90-8c07-d76eeaa42853_ACT_46a90cb4-1b84-4df0-aa10-463f2ced7912_SESS_fff96630-89cd-4b8d-b2b0-936f73ba3bcb_BOSC_a26b67d0-34e2-4646-a75b-27d14cfebd19_SNAPS_','2021-12-22 14:06:41','2021-12-22 15:06:37','07b799af-6333-11ec-9377-226cec7cb58a.png','2021-12-22 15:06:41','SYNCED','07b799af-6333-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.407.7.2.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'07ba4b9d-8de6-4eeb-bf9d-c5e0d3dbb45e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07ba4b9d-8de6-4eeb-bf9d-c5e0d3dbb45e.ply','PLY','PATIENT_fcf8c111-84a1-4f17-859c-ea2ad21d373b_ACT_d27c23bb-fa1e-4cd8-bacc-e2b65114a20e_SESS_844480c5-a8a8-4eb3-a014-e1424d66a1ca_BOSC_ee5e8d11-7fd2-4e32-9bcd-156edaa7ec82_PLY_','2021-12-30 18:03:08','2019-11-18 16:56:47','07ba4b9d-8de6-4eeb-bf9d-c5e0d3dbb45e.ply','2021-12-30 19:03:08','SYNCED','07ba4b9d-8de6-4eeb-bf9d-c5e0d3dbb45e',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 168.1.1.1.1\",\"modelMatrix\":\"-0.971915,0.222709,-0.0760346,0,-0.235331,-0.919788,0.314022,0,-6.61285e-9,0.323096,0.946366,0,-2.26085,16.2906,-29.2499,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'07ba9e9b-7d23-4d41-9d64-ff7b638fab28','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07ba9e9b-7d23-4d41-9d64-ff7b638fab28.png','SNAPS','PATIENT_2807a523-f049-4cb4-b87c-145d1c34703d_ACT_c814024c-0941-4b02-94bd-294d8fdb06f3_SESS_c5963919-b6e6-43fd-af82-eed8f169475a_TOSC_788c4f2e-8c8f-48d6-ba56-ec592372f47b_SNAPS_','2020-12-16 10:51:45','2020-02-21 10:33:47','07ba9e9b-7d23-4d41-9d64-ff7b638fab28.png','2020-12-16 11:51:45','SYNCED','07ba9e9b-7d23-4d41-9d64-ff7b638fab28',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'07bad787-6333-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07bad787-6333-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_e94cc8a4-9fe0-4d90-8c07-d76eeaa42853_ACT_46a90cb4-1b84-4df0-aa10-463f2ced7912_SESS_fff96630-89cd-4b8d-b2b0-936f73ba3bcb_TOSC_345c6fe9-46ec-414c-bb76-3b47f7e195f4_ZIP_','2021-12-22 13:36:35','2021-12-22 14:36:32','07bad787-6333-11ec-9377-226cec7cb58a.zip','2021-12-22 14:36:35','SYNCED','07bad787-6333-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.407.7.2.3\",\"modelMatrix\":\"0.477061,-0.831625,0.284274,0,0.87887,0.451417,-0.154307,0,9.10449e-9,0.323453,0.946244,0,-0.934762,-34.3799,-11.8898,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'07c0251a-b50d-4923-8ec7-171e918b3e4c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07c0251a-b50d-4923-8ec7-171e918b3e4c.ply','PLY','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_TOSC_86e65ef7-65a9-4ebf-9283-0d4408367194_PLY_','2021-12-30 18:03:08','2019-11-15 10:55:18','07c0251a-b50d-4923-8ec7-171e918b3e4c.ply','2021-12-30 19:03:08','SYNCED','07c0251a-b50d-4923-8ec7-171e918b3e4c',0,NULL,'','','{\"displayTitle\":\"Mascella 0\",\"modelMatrix\":\"0.475206,-0.843721,0.249629,0,0.879875,0.45568,-0.134821,0,-8.41607e-10,0.28371,0.95891,0,-4.59861,-35.7904,-16.6972,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'07c222e2-60da-4409-81d7-c39e72305d8f','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07c222e2-60da-4409-81d7-c39e72305d8f.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_286e8799-fbd7-4c7c-879b-d327de892ffe_SESS_14697c6d-cabe-47fc-be78-cd0bf76c8e7f_BOSC_0e4496f5-7e38-4371-8991-ae4a3975f5d5_ZIP_','2022-03-23 13:09:16','2022-03-23 14:09:13','07c222e2-60da-4409-81d7-c39e72305d8f.zip','2022-03-23 14:09:16','SYNCED','07c222e2-60da-4409-81d7-c39e72305d8f',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.36.1.1\",\"modelMatrix\":\"-0.996693,-0.0800309,0.0140839,0,0.0812607,-0.981609,0.172745,0,-1.19077e-09,0.173318,0.984866,0,-19.8118,7.19895,-23.1734,1\",\"title\":\"Mandibule ZIP\"}'),(2,'07c43def-f436-4229-8858-ef373f119139','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07c43def-f436-4229-8858-ef373f119139.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_8e0fa860-808d-408c-b6a9-f15670797e86_SESS_9eccd5ad-22e1-4c9e-aa28-9e198895075c_BOSC_e6ee605c-bc43-485f-a6ee-b3af27250ccf_SNAPS_','2021-04-07 12:06:11','2021-04-07 14:06:08','07c43def-f436-4229-8858-ef373f119139.png','2021-04-07 14:06:11','SYNCED','07c43def-f436-4229-8858-ef373f119139',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.15.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'07c4d5e6-593a-4f3a-b073-de15c5c8d1a5','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07c4d5e6-593a-4f3a-b073-de15c5c8d1a5.png','SNAPS','PATIENT_95e4ff6d-7100-48d0-935f-08c3371d3f80_ACT_37b3ec2f-500c-49ed-8c3c-a7e4c917cdd2_SESS_d8048054-32d9-4927-94dd-09a8174b6fb8_BOSC_b0807140-904c-496e-a01d-b1a34d3dcae2_SNAPS_','2020-12-16 11:05:54','2020-01-29 10:11:02','07c4d5e6-593a-4f3a-b073-de15c5c8d1a5.png','2020-12-16 12:05:54','SYNCED','07c4d5e6-593a-4f3a-b073-de15c5c8d1a5',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 96.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'07c980e6-f43f-40eb-9793-b0ea0a174827','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07c980e6-f43f-40eb-9793-b0ea0a174827.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_09d24a58-9527-462c-9a5f-c3b275accf6a_SESS_212a263e-d8f6-4398-ace0-66b19141e6ec_BOSC_b16ff229-dbe9-499a-a332-38e88b399c52_SNAPS_','2021-04-06 13:53:14','2021-04-06 15:53:13','07c980e6-f43f-40eb-9793-b0ea0a174827.png','2021-04-06 15:53:14','SYNCED','07c980e6-f43f-40eb-9793-b0ea0a174827',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.32.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'07c9e130-fadc-4135-a4dd-9f7e1be03a42','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07c9e130-fadc-4135-a4dd-9f7e1be03a42.png','SNAPS','PATIENT_6592423c-c895-4f90-ae97-d29a34961d34_ACT_6628cbc8-0118-491e-93d0-25211a465bc4_SESS_6e23570d-ebd1-4a63-9ffe-aa47019113cd_BOSC_d05e0ee7-1b6e-4b5f-b812-2f7e5503a36c_SNAPS_','2022-03-04 13:40:22','2019-07-09 13:19:01','07c9e130-fadc-4135-a4dd-9f7e1be03a42.png','2022-03-04 14:40:22','SYNCED','07c9e130-fadc-4135-a4dd-9f7e1be03a42',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 11.2.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'07d6b2c6-e1b5-43d1-86e9-71f6ba535066','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07d6b2c6-e1b5-43d1-86e9-71f6ba535066.png','SNAPS','PATIENT_819e0ef8-8a2d-4056-87eb-b0140b49b138_ACT_dcb00f7d-2ebb-4a3e-b55a-0a5d6542a290_SESS_aef83cd5-09b8-4a48-899c-22a2ab0c2d9c_TOSC_07ee40f7-97e9-4d9a-8fe2-d2c6e4b8f2d8_SNAPS_','2020-12-23 09:07:38','2019-12-20 15:48:39','07d6b2c6-e1b5-43d1-86e9-71f6ba535066.png','2020-12-23 10:07:38','SYNCED','07d6b2c6-e1b5-43d1-86e9-71f6ba535066',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'07db12d6-169d-4c33-82b7-510c5efee44e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07db12d6-169d-4c33-82b7-510c5efee44e.png','SNAPS','PATIENT_42f1168d-7e4d-4574-9695-1bb3c7af4f61_ACT_5f10eca4-62d0-44ae-96ec-54c8413298eb_SESS_1e0d7fa4-8337-4681-a87b-a30c32238dc0_BOSC_7bb27809-7253-4bf4-9c66-0ad2ff3bed50_SNAPS_','2021-12-30 18:03:08','2019-07-16 16:55:45','07db12d6-169d-4c33-82b7-510c5efee44e.png','2021-12-30 19:03:08','SYNCED','07db12d6-169d-4c33-82b7-510c5efee44e',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 82.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'07dd4207-cf11-446b-96cd-9299c9b8319d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07dd4207-cf11-446b-96cd-9299c9b8319d.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_73781e42-8bd6-4f3d-87d9-97ed7e33ec40_SESS_da5ab09d-90f5-43a7-91ef-c03b81b122d1_BOSC_d511bbf6-37c7-49ae-8053-6b1b81f8f1b9_SNAPS_','2021-04-07 13:17:30','2021-04-07 15:17:29','07dd4207-cf11-446b-96cd-9299c9b8319d.png','2021-04-07 15:17:30','SYNCED','07dd4207-cf11-446b-96cd-9299c9b8319d',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.17.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'07e48eec-70fc-4a59-baaa-d7fa7daaeaf0','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07e48eec-70fc-4a59-baaa-d7fa7daaeaf0.stl','STL','PATIENT_dde53ea4-f623-42e4-9864-d8e77d9deabe_ACT_c658c808-2655-4213-a8a0-1c34d5830ee5_SESS_ad32c977-4115-45c7-9168-d19d87c66102_TOSC_f15a7ce9-78df-4165-9e1c-12667b7323cd_STL_','2021-12-30 18:03:09','2019-11-22 08:47:53','07e48eec-70fc-4a59-baaa-d7fa7daaeaf0.stl','2021-12-30 19:03:09','SYNCED','07e48eec-70fc-4a59-baaa-d7fa7daaeaf0',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 208.1.1.1\",\"modelMatrix\":\"0.743035,-0.627516,0.232643,0,0.669253,0.696697,-0.258291,0,3.81443e-9,0.347616,0.937637,0,7.40466,-40.2943,-15.8547,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'07e4d38f-9e28-11ec-94a4-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07e4d38f-9e28-11ec-94a4-9ec33d03e6dd.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_a5a2350a-e52a-4822-ba7f-485fdcf5baee_SESS_11fac5a9-3d15-481c-8777-04bf23428031_TOSC_cd20869a-efb5-4355-8f4e-a3c069de73b8_SNAPS_','2022-03-01 13:03:23','2022-03-01 14:03:19','07e4d38f-9e28-11ec-94a4-9ec33d03e6dd.png','2022-03-01 14:03:23','SYNCED','07e4d38f-9e28-11ec-94a4-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.29.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'07e67a8b-9e28-11ec-94a4-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07e67a8b-9e28-11ec-94a4-9ec33d03e6dd.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_a5a2350a-e52a-4822-ba7f-485fdcf5baee_SESS_11fac5a9-3d15-481c-8777-04bf23428031_BOSC_1c292592-6252-48d9-90fd-761680b37a20_ZIP_','2022-03-01 13:18:34','2022-03-01 14:18:30','07e67a8b-9e28-11ec-94a4-9ec33d03e6dd.zip','2022-03-01 14:18:34','SYNCED','07e67a8b-9e28-11ec-94a4-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.29.1.3\",\"modelMatrix\":\"-0.999117,-0.0383332,0.0172113,0,0.0420198,-0.91146,0.409237,0,4.35536e-10,0.409599,0.912266,0,-23.4647,8.30686,-20.7951,1\",\"title\":\"Mandibule ZIP\"}'),(2,'07e68dc5-2391-4bc1-a096-0530f3c3060b','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07e68dc5-2391-4bc1-a096-0530f3c3060b.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_e5f1c2aa-5cd5-42b0-bae4-c7c20d558f23_SESS_99a900a8-53a6-4b5a-9bed-10588f7a7523_BOSC_1fec4525-7219-421e-b946-bb32e5447f31_SNAPS_','2021-05-31 08:14:46','2021-05-31 10:14:44','07e68dc5-2391-4bc1-a096-0530f3c3060b.png','2021-05-31 10:14:46','SYNCED','07e68dc5-2391-4bc1-a096-0530f3c3060b',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.164.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'07e7f644-9e28-11ec-94a4-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07e7f644-9e28-11ec-94a4-9ec33d03e6dd.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_a5a2350a-e52a-4822-ba7f-485fdcf5baee_SESS_11fac5a9-3d15-481c-8777-04bf23428031_BOSC_1c292592-6252-48d9-90fd-761680b37a20_SNAPS_','2022-03-01 13:18:34','2022-03-01 14:18:29','07e7f644-9e28-11ec-94a4-9ec33d03e6dd.png','2022-03-01 14:18:34','SYNCED','07e7f644-9e28-11ec-94a4-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.29.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'07e9870a-9e28-11ec-94a4-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07e9870a-9e28-11ec-94a4-9ec33d03e6dd.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_a5a2350a-e52a-4822-ba7f-485fdcf5baee_SESS_11fac5a9-3d15-481c-8777-04bf23428031_BOSC_076b85b2-38d3-4b3f-9936-b0db299e3b2e_ZIP_','2022-03-01 13:11:25','2022-03-01 14:11:23','07e9870a-9e28-11ec-94a4-9ec33d03e6dd.zip','2022-03-01 14:11:25','SYNCED','07e9870a-9e28-11ec-94a4-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.29.1.1\",\"modelMatrix\":\"-0.787857,-0.610712,0.0794525,0,0.615858,-0.781273,0.101642,0,-2.67721e-09,0.129011,0.991643,0,-21.5944,-0.720711,-23.0443,1\",\"title\":\"Mandibule ZIP\"}'),(2,'07e9e164-38f9-43c7-b154-5224032b853d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07e9e164-38f9-43c7-b154-5224032b853d.png','SNAPS','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_aceb6871-e01a-4e37-9c9f-33adfe6e0268_SESS_1ad73395-8cbd-4dcc-9a8e-cf3241e4e156_BOSC_0b40cf8a-581b-4ca9-90a5-cd0340988c9a_SNAPS_','2021-08-05 07:30:47','2019-11-29 09:24:56','07e9e164-38f9-43c7-b154-5224032b853d.png','2021-08-05 09:30:47','SYNCED','07e9e164-38f9-43c7-b154-5224032b853d',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'07ead34f-9e28-11ec-94a4-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07ead34f-9e28-11ec-94a4-9ec33d03e6dd.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_a5a2350a-e52a-4822-ba7f-485fdcf5baee_SESS_11fac5a9-3d15-481c-8777-04bf23428031_TOSC_ceafdb60-df92-4e74-af92-72aaa417a4dc_SNAPS_','2022-03-01 13:07:47','2022-03-01 14:07:43','07ead34f-9e28-11ec-94a4-9ec33d03e6dd.png','2022-03-01 14:07:47','SYNCED','07ead34f-9e28-11ec-94a4-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.29.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'07ec48cb-9e28-11ec-94a4-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07ec48cb-9e28-11ec-94a4-9ec33d03e6dd.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_a5a2350a-e52a-4822-ba7f-485fdcf5baee_SESS_11fac5a9-3d15-481c-8777-04bf23428031_BOSC_b6b3bd52-7b22-405b-b4fc-a50dcaf7d172_SNAPS_','2022-03-01 13:14:56','2022-03-01 14:14:53','07ec48cb-9e28-11ec-94a4-9ec33d03e6dd.png','2022-03-01 14:14:56','SYNCED','07ec48cb-9e28-11ec-94a4-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.29.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'07edc173-9e28-11ec-94a4-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07edc173-9e28-11ec-94a4-9ec33d03e6dd.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_a5a2350a-e52a-4822-ba7f-485fdcf5baee_SESS_11fac5a9-3d15-481c-8777-04bf23428031_BOSC_076b85b2-38d3-4b3f-9936-b0db299e3b2e_SNAPS_','2022-03-01 13:11:25','2022-03-01 14:11:22','07edc173-9e28-11ec-94a4-9ec33d03e6dd.png','2022-03-01 14:11:25','SYNCED','07edc173-9e28-11ec-94a4-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.29.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'07efacb6-9e28-11ec-94a4-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07efacb6-9e28-11ec-94a4-9ec33d03e6dd.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_a5a2350a-e52a-4822-ba7f-485fdcf5baee_SESS_11fac5a9-3d15-481c-8777-04bf23428031_TOSC_cd20869a-efb5-4355-8f4e-a3c069de73b8_ZIP_','2022-03-01 13:03:23','2022-03-01 14:03:20','07efacb6-9e28-11ec-94a4-9ec33d03e6dd.zip','2022-03-01 14:03:23','SYNCED','07efacb6-9e28-11ec-94a4-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.29.1.2\",\"modelMatrix\":\"0.749354,-0.62003,0.232446,0,0.66217,0.701666,-0.263051,0,1.61812e-08,0.351037,0.936362,0,2.85631,-35.0719,-22.9406,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'07f09693-6b9d-4978-88e4-26362e17e6de','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07f09693-6b9d-4978-88e4-26362e17e6de.ply','PLY','PATIENT_6a6173bb-c795-4193-b301-3f6a45189419_ACT_b2858777-a38c-4af8-a3d5-3fe72af908b0_SESS_9193e314-ea10-43e8-8a8e-c89822ad7b51_TOSC_3d9386f8-10de-4288-b889-24ac93359843_PLY_','2020-12-08 17:26:01','2020-07-03 11:00:17','07f09693-6b9d-4978-88e4-26362e17e6de.ply','2020-12-08 18:26:01','SYNCED','07f09693-6b9d-4978-88e4-26362e17e6de',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.111.1.1\",\"modelMatrix\":\"0.199457,-0.934822,0.293811,0,0.979907,0.19028,-0.0598043,0,-4.11532e-9,0.299836,0.953991,0,-14.089,-34.3738,-15.7664,1\",\"title\":\"Maxillaire PLY\"}'),(2,'07f0a94c-f1e5-4235-a547-38ac0a1b3e4c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07f0a94c-f1e5-4235-a547-38ac0a1b3e4c.png','SNAPS','PATIENT_961e5084-1756-4d47-8e90-a6b717094efe_ACT_e9340f44-a13c-41df-99f2-1472c63e5f38_SESS_6cd9c521-7e64-409c-93d7-2039dee96ec0_BOSC_4f8722e2-7d5c-4b81-b12b-385283da44bd_SNAPS_','2020-12-16 11:05:55','2020-01-21 13:54:56','07f0a94c-f1e5-4235-a547-38ac0a1b3e4c.png','2020-12-16 12:05:55','SYNCED','07f0a94c-f1e5-4235-a547-38ac0a1b3e4c',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 199.1.3.1.2\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'07f0eb12-9e28-11ec-94a4-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07f0eb12-9e28-11ec-94a4-9ec33d03e6dd.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_a5a2350a-e52a-4822-ba7f-485fdcf5baee_SESS_11fac5a9-3d15-481c-8777-04bf23428031_TOSC_9b076072-280f-4b5b-a460-35c95c0c9f68_SNAPS_','2022-03-01 12:57:35','2022-03-01 13:57:31','07f0eb12-9e28-11ec-94a4-9ec33d03e6dd.png','2022-03-01 13:57:35','SYNCED','07f0eb12-9e28-11ec-94a4-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.29.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'07f191b5-6320-49aa-b7f6-c05327b7b025','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07f191b5-6320-49aa-b7f6-c05327b7b025.ply','PLY','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_BOSC_a9a62eef-7474-4307-b60b-7a50c1cea0c8_PLY_','2021-12-30 18:03:09','2019-11-15 14:00:22','07f191b5-6320-49aa-b7f6-c05327b7b025.ply','2021-12-30 19:03:09','SYNCED','07f191b5-6320-49aa-b7f6-c05327b7b025',0,NULL,'','','{\"displayTitle\":\"Mandibola 0\",\"modelMatrix\":\"-0.994025,-0.105788,0.0268761,0,0.109149,-0.96342,0.244763,0,4.14586e-10,0.246234,0.96921,0,-15.6582,8.51879,-29.1663,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'07f2ad8d-9e28-11ec-94a4-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07f2ad8d-9e28-11ec-94a4-9ec33d03e6dd.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_a5a2350a-e52a-4822-ba7f-485fdcf5baee_SESS_11fac5a9-3d15-481c-8777-04bf23428031_TOSC_9b076072-280f-4b5b-a460-35c95c0c9f68_ZIP_','2022-03-01 12:57:35','2022-03-01 13:57:32','07f2ad8d-9e28-11ec-94a4-9ec33d03e6dd.zip','2022-03-01 13:57:35','SYNCED','07f2ad8d-9e28-11ec-94a4-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.29.1.1\",\"modelMatrix\":\"0.50589,-0.827835,0.242414,0,0.862598,0.485502,-0.142169,0,-6.16807e-09,0.281028,0.9597,0,-0.924128,-30.9906,-22.4846,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'07f49544-9e28-11ec-94a4-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07f49544-9e28-11ec-94a4-9ec33d03e6dd.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_a5a2350a-e52a-4822-ba7f-485fdcf5baee_SESS_11fac5a9-3d15-481c-8777-04bf23428031_BOSC_b6b3bd52-7b22-405b-b4fc-a50dcaf7d172_ZIP_','2022-03-01 13:14:56','2022-03-01 14:14:54','07f49544-9e28-11ec-94a4-9ec33d03e6dd.zip','2022-03-01 14:14:56','SYNCED','07f49544-9e28-11ec-94a4-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.29.1.2\",\"modelMatrix\":\"-0.992295,-0.113279,0.0501871,0,0.123899,-0.907243,0.401943,0,-3.17941e-09,0.405064,0.914288,0,-25.8508,7.10788,-16.8156,1\",\"title\":\"Mandibule ZIP\"}'),(2,'07f5f4e7-9e28-11ec-94a4-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07f5f4e7-9e28-11ec-94a4-9ec33d03e6dd.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_a5a2350a-e52a-4822-ba7f-485fdcf5baee_SESS_11fac5a9-3d15-481c-8777-04bf23428031_TOSC_ceafdb60-df92-4e74-af92-72aaa417a4dc_ZIP_','2022-03-01 13:07:47','2022-03-01 14:07:43','07f5f4e7-9e28-11ec-94a4-9ec33d03e6dd.zip','2022-03-01 14:07:47','SYNCED','07f5f4e7-9e28-11ec-94a4-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.29.1.3\",\"modelMatrix\":\"0.845093,-0.485845,0.223095,0,0.534618,0.767996,-0.352655,0,7.84638e-09,0.417297,0.90877,0,13.7087,-32.8209,-22.4137,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'07f92f93-041a-4717-9ddb-520cfdbd2905','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07f92f93-041a-4717-9ddb-520cfdbd2905.ply','PLY','PATIENT_b3c8ff23-e845-45b0-a992-48c610e95f19_ACT_cc20c13e-b334-481e-a606-cd0de87d95ae_SESS_8f0b3737-3a1c-41c8-8963-7fe7b125bd86_BOSC_41805ccf-577f-4a83-b554-3f7a6cb844b7_PLY_','2021-12-30 18:03:09','2019-09-23 12:32:41','07f92f93-041a-4717-9ddb-520cfdbd2905.ply','2021-12-30 19:03:09','SYNCED','07f92f93-041a-4717-9ddb-520cfdbd2905',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 161.6.1.1\",\"modelMatrix\":\"0.271411,-0.961353,0.0462216,0,0.962463,0.271098,-0.0130343,0,9.55236e-13,0.0480242,0.998846,0,-10.3082,-25.8097,-17.6044,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'07fc2983-e5e7-444b-a6a4-14cadbd8f286','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/07fc2983-e5e7-444b-a6a4-14cadbd8f286.png','SNAPS','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_bbd6c708-e7be-443c-93ab-eb1285e51fe4_SESS_8966eee1-d22b-4e86-835c-607819f15da6_TOSC_e923234a-811e-44be-8079-61870828163a_SNAPS_','2020-12-16 11:05:56','2020-01-21 11:10:27','07fc2983-e5e7-444b-a6a4-14cadbd8f286.png','2020-12-16 12:05:56','SYNCED','07fc2983-e5e7-444b-a6a4-14cadbd8f286',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'080378c6-2d72-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/080378c6-2d72-11eb-94ee-226cec7cb58a.png','SNAPS','PATIENT_13210a90-6734-476f-9b18-06c93775873c_ACT_1ac807ea-a996-41e0-9c98-43dbc7664a7e_SESS_c23746b0-3e7f-4371-ba47-95bf9f25ba8b_TOSC_9e39c44f-a337-4910-aee7-e61eb9a4f05a_SNAPS_','2020-11-24 08:27:05','2020-11-23 10:44:36','080378c6-2d72-11eb-94ee-226cec7cb58a.png','2020-11-24 09:27:05','SYNCED','080378c6-2d72-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.36.27.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'08047cbe-2d72-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/08047cbe-2d72-11eb-94ee-226cec7cb58a.ply','PLY','PATIENT_13210a90-6734-476f-9b18-06c93775873c_ACT_1ac807ea-a996-41e0-9c98-43dbc7664a7e_SESS_c23746b0-3e7f-4371-ba47-95bf9f25ba8b_BOSC_47442479-d8c4-474d-932a-3688e5a5a132_PLY_','2020-11-24 08:27:05','2020-11-23 10:50:30','08047cbe-2d72-11eb-94ee-226cec7cb58a.ply','2020-11-24 09:27:05','SYNCED','08047cbe-2d72-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.27.1.1\",\"modelMatrix\":\"-0.974305,0.22081,-0.0444147,0,-0.225232,-0.955174,0.192128,0,1.11753e-9,0.197195,0.980364,0,-7.54503,15.7897,-25.5047,1\",\"title\":\"Mandibule PLY\"}'),(2,'080574df-2d72-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/080574df-2d72-11eb-94ee-226cec7cb58a.png','SNAPS','PATIENT_13210a90-6734-476f-9b18-06c93775873c_ACT_1ac807ea-a996-41e0-9c98-43dbc7664a7e_SESS_c23746b0-3e7f-4371-ba47-95bf9f25ba8b_BOSC_47442479-d8c4-474d-932a-3688e5a5a132_SNAPS_','2020-11-24 08:27:05','2020-11-23 10:50:30','080574df-2d72-11eb-94ee-226cec7cb58a.png','2020-11-24 09:27:05','SYNCED','080574df-2d72-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.27.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0805d80c-adf0-4408-bc7e-09a6929000fa','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0805d80c-adf0-4408-bc7e-09a6929000fa.stl','STL','PATIENT_0ef241a1-4320-47aa-87f1-f774661cb469_ACT_b8784c02-311f-47ea-925f-610d5e3dea61_SESS_0c914052-c9c6-4d08-92b7-188e991cbe37_BOSC_b9140416-81ca-4a60-8fcb-c6e3b103a0a1_STL_','2021-12-30 18:03:10','2019-07-15 11:01:06','0805d80c-adf0-4408-bc7e-09a6929000fa.stl','2021-12-30 19:03:10','SYNCED','0805d80c-adf0-4408-bc7e-09a6929000fa',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 62.1.1.1\",\"modelMatrix\":\"-0.764791,0.641119,-0.0637199,0,-0.644278,-0.761042,0.0756389,0,3.48635e-10,0.0989013,0.995097,0,-1.11618,30.2034,-25.3022,1\",\"title\":\"MANDIBULE STL\"}'),(2,'08065946-2d72-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/08065946-2d72-11eb-94ee-226cec7cb58a.ply','PLY','PATIENT_13210a90-6734-476f-9b18-06c93775873c_ACT_1ac807ea-a996-41e0-9c98-43dbc7664a7e_SESS_c23746b0-3e7f-4371-ba47-95bf9f25ba8b_TOSC_9e39c44f-a337-4910-aee7-e61eb9a4f05a_PLY_','2020-11-24 08:27:06','2020-11-23 10:44:36','08065946-2d72-11eb-94ee-226cec7cb58a.ply','2020-11-24 09:27:06','SYNCED','08065946-2d72-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.36.27.1.1\",\"modelMatrix\":\"0.748419,-0.620219,0.234941,0,0.663226,0.699888,-0.265119,0,-5.65197e-9,0.354239,0.935155,0,3.91359,-29.1658,-20.8734,1\",\"title\":\"Maxillaire PLY\"}'),(2,'080cbc57-2373-4b61-8d3f-dc669c5005aa','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/080cbc57-2373-4b61-8d3f-dc669c5005aa.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_06140603-23cb-4a53-811e-e71525830447_SESS_749f09e4-a715-4b27-aa2f-2debc4beab4a_TOSC_22c33e68-74fa-4b7d-98a6-f683e5c5530c_PLY_','2021-04-14 15:10:32','2021-04-14 17:10:30','080cbc57-2373-4b61-8d3f-dc669c5005aa.ply','2021-04-14 17:10:32','SYNCED','080cbc57-2373-4b61-8d3f-dc669c5005aa',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.63.1.2\",\"modelMatrix\":\"0.852888,-0.491138,0.177105,0,0.522094,0.802317,-0.289318,0,-5.22916e-9,0.339221,0.940707,0,9.69263,-31.1056,-18.403,1\",\"title\":\"Maxillaire PLY\"}'),(2,'080d2eb7-4344-495b-b276-00d44e5bc5b1','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/080d2eb7-4344-495b-b276-00d44e5bc5b1.png','SNAPS','PATIENT_1726cd89-f2a1-4528-bf69-d3a18a5aaa71_ACT_afbd2d3d-fdc4-4c89-b445-f65a75119d97_SESS_71887ae7-34c5-4a58-9942-d643739a52f4_TOSC_4d480282-a30b-422f-b05b-c7b46744b349_SNAPS_','2020-12-16 10:51:48','2020-02-05 13:27:27','080d2eb7-4344-495b-b276-00d44e5bc5b1.png','2020-12-16 11:51:48','SYNCED','080d2eb7-4344-495b-b276-00d44e5bc5b1',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0812d904-f788-4d10-9a73-87ece4db1817','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0812d904-f788-4d10-9a73-87ece4db1817.ply','PLY','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_bbcf9601-35a5-4e92-8051-508627f546f9_SESS_c6899cdb-16f1-41af-a8be-ece7a59af067_BOSC_d0d28b27-3fa4-4cd9-83f8-b93865a43eff_PLY_','2021-03-30 14:00:13','2021-03-30 16:00:12','0812d904-f788-4d10-9a73-87ece4db1817.ply','2021-03-30 16:00:13','SYNCED','03669af3-de65-4cf1-9129-2f2627737ae6',1,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.8.1.1\",\"modelMatrix\":\"-0.998671,0.0502218,-0.0115835,0,-0.0515403,-0.973122,0.224447,0,-1.35375e-10,0.224746,0.974417,0,29.0448,14.8918,-17.2889,1\",\"title\":\"Mandibule PLY\"}'),(2,'0813e6d6-d3e4-4ea9-8471-d48733eff1c2','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0813e6d6-d3e4-4ea9-8471-d48733eff1c2.png','SNAPS','PATIENT_639098f4-47e7-4689-ae2d-8e309459f01f_ACT_503c189c-eae7-406b-ad30-d7cf8d8f3382_SESS_fd734a44-ec1f-4f1c-a4fb-fed2c88b1e8c_BOSC_e3b9e763-d745-4ece-a1ba-66350c8dcfe5_SNAPS_','2022-03-04 13:40:22','2019-07-10 09:31:49','0813e6d6-d3e4-4ea9-8471-d48733eff1c2.png','2022-03-04 14:40:22','SYNCED','0813e6d6-d3e4-4ea9-8471-d48733eff1c2',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 18.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0819d289-51d6-4b84-a343-55d99f2d1666','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0819d289-51d6-4b84-a343-55d99f2d1666.ply','PLY','PATIENT_b37bdc99-aed1-4eb9-8f9f-8979303a45fe_ACT_0d2259ea-1ffb-4942-b410-869e6f020dfc_SESS_cfc9f7f3-dd40-483b-8f0d-cb732c3cd2a4_TOSC_2157f3d0-631d-4d74-94ba-8e50061d3655_PLY_','2020-12-30 15:07:08','2020-12-30 15:51:37','0819d289-51d6-4b84-a343-55d99f2d1666.ply','2020-12-30 16:07:08','SYNCED','0819d289-51d6-4b84-a343-55d99f2d1666',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.36.63.1.1\",\"modelMatrix\":\"0.714193,-0.641371,0.280305,0,0.699948,0.654424,-0.286009,0,7.3025e-9,0.400465,0.916312,0,5.18599,-32.2538,-14.9439,1\",\"title\":\"Maxillaire PLY\"}'),(2,'081b8c9d-b71c-4a7d-8b9d-7b98f8e0c45c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/081b8c9d-b71c-4a7d-8b9d-7b98f8e0c45c.png','SNAPS','PATIENT_639098f4-47e7-4689-ae2d-8e309459f01f_ACT_503c189c-eae7-406b-ad30-d7cf8d8f3382_SESS_fd734a44-ec1f-4f1c-a4fb-fed2c88b1e8c_TOSC_e5e94b7e-50b9-4aea-ae2b-e4d7621d5f13_SNAPS_','2022-03-04 13:40:23','2019-07-10 09:27:27','081b8c9d-b71c-4a7d-8b9d-7b98f8e0c45c.png','2022-03-04 14:40:23','SYNCED','081b8c9d-b71c-4a7d-8b9d-7b98f8e0c45c',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 18.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'081f5a2b-5993-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/081f5a2b-5993-11eb-94ee-226cec7cb58a.png','SNAPS','PATIENT_e2cd92c5-cc74-46aa-84c4-623d1fe83196_ACT_86c35137-f28e-4bf2-ab31-eb82baafceea_SESS_059aa0ef-1c0b-4aeb-8da7-47a8fa73c953_BOSC_338f981c-b813-40d1-b9b6-00b72842f41b_SNAPS_','2021-01-18 13:42:22','2021-01-18 14:34:27','081f5a2b-5993-11eb-94ee-226cec7cb58a.png','2021-01-18 14:42:22','SYNCED','081f5a2b-5993-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.10.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'082490ea-5993-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/082490ea-5993-11eb-94ee-226cec7cb58a.ply','PLY','PATIENT_e2cd92c5-cc74-46aa-84c4-623d1fe83196_ACT_86c35137-f28e-4bf2-ab31-eb82baafceea_SESS_059aa0ef-1c0b-4aeb-8da7-47a8fa73c953_TOSC_9b63f70c-bf2d-4b53-b181-27bad88cfc75_PLY_','2021-01-18 13:42:21','2021-01-18 14:29:44','082490ea-5993-11eb-94ee-226cec7cb58a.ply','2021-01-18 14:42:21','SYNCED','082490ea-5993-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.10.1.2\",\"modelMatrix\":\"0.617085,-0.735745,0.27908,0,0.786897,0.576972,-0.218855,0,2.53506e-9,0.354659,0.934996,0,-3.3557,-37.5121,-16.92,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0824ba29-ead7-4031-b12c-9b3490c60630','','PLY','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_73781e42-8bd6-4f3d-87d9-97ed7e33ec40_SESS_da5ab09d-90f5-43a7-91ef-c03b81b122d1_BOSC_f79f73c3-a561-4a76-b383-3454aedb1186_PLY_','2021-04-07 13:27:42','2021-04-07 15:27:41','','2021-04-07 15:27:42','SYNCED','0824ba29-ead7-4031-b12c-9b3490c60630',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.17.1.3\",\"modelMatrix\":\"-0.990731,0.135538,-0.00897944,0,-0.135836,-0.988564,0.0654925,0,2.70733e-10,0.0661052,0.997813,0,33.3425,11.6636,-16.186,1\",\"title\":\"Mandibule PLY\"}'),(2,'082b67c9-ff60-4cc9-8a2b-1014b00868b5','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/082b67c9-ff60-4cc9-8a2b-1014b00868b5.ply','PLY','PATIENT_4773658d-d1ab-4c36-9f2c-aabcb1138faf_ACT_adfc2456-5ca6-428d-8ac3-0bc2870b8b9c_SESS_17dbbddd-1aa1-4213-a12d-f369195e1cae_TOSC_2a1b3dc6-28a0-44aa-a9d0-684d925a36b1_PLY_','2021-03-17 12:36:26','2021-03-17 13:27:07','082b67c9-ff60-4cc9-8a2b-1014b00868b5.ply','2021-03-17 13:36:26','SYNCED','082b67c9-ff60-4cc9-8a2b-1014b00868b5',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.91.1.3\",\"modelMatrix\":\"0.785193,-0.576365,0.226442,0,0.619252,0.730814,-0.287122,0,1.49923e-9,0.36567,0.930744,0,8.9004,-32.3016,-13.1809,1\",\"title\":\"Maxillaire PLY\"}'),(2,'082c7dfc-54d4-48d6-b643-4b2fddf9ec29','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/082c7dfc-54d4-48d6-b643-4b2fddf9ec29.png','SNAPS','PATIENT_5a36b509-d87e-4dda-807e-a616406aaa4c_ACT_285e7e26-b813-4dd7-84e7-f265f6e87fd6_SESS_7bf03134-a6b7-430c-ad8b-e85f04d49949_TOSC_8462b1cb-de44-4474-9f72-b96b695d69f7_SNAPS_','2022-03-22 10:48:47','2022-03-22 11:48:42','082c7dfc-54d4-48d6-b643-4b2fddf9ec29.png','2022-03-22 11:48:47','SYNCED','082c7dfc-54d4-48d6-b643-4b2fddf9ec29',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.412.1.1.19\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'082e6303-5993-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/082e6303-5993-11eb-94ee-226cec7cb58a.png','SNAPS','PATIENT_e2cd92c5-cc74-46aa-84c4-623d1fe83196_ACT_86c35137-f28e-4bf2-ab31-eb82baafceea_SESS_059aa0ef-1c0b-4aeb-8da7-47a8fa73c953_TOSC_1bab9860-8437-4129-9814-cfb1a5caeafa_SNAPS_','2021-01-18 13:42:22','2021-01-18 14:32:09','082e6303-5993-11eb-94ee-226cec7cb58a.png','2021-01-18 14:42:22','SYNCED','082e6303-5993-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.10.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0831c029-79d7-4907-975f-f3446d0827eb','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0831c029-79d7-4907-975f-f3446d0827eb.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_7a0a525d-de41-4920-8e06-b5f8df73ecff_SESS_a267e15b-a98e-41d7-8093-dc4ef642db92_BOSC_74e6332d-bbf2-4361-a49c-10dc017eee13_SNAPS_','2022-01-05 09:47:25','2022-01-05 10:47:15','0831c029-79d7-4907-975f-f3446d0827eb.png','2022-01-05 10:47:25','SYNCED','0831c029-79d7-4907-975f-f3446d0827eb',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.1.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0832000e-5993-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0832000e-5993-11eb-94ee-226cec7cb58a.ply','PLY','PATIENT_e2cd92c5-cc74-46aa-84c4-623d1fe83196_ACT_86c35137-f28e-4bf2-ab31-eb82baafceea_SESS_059aa0ef-1c0b-4aeb-8da7-47a8fa73c953_TOSC_0d4d31f5-276a-486c-917e-f8a4b9933d1b_PLY_','2021-01-18 13:42:21','2021-01-18 14:26:27','0832000e-5993-11eb-94ee-226cec7cb58a.ply','2021-01-18 14:42:21','SYNCED','0832000e-5993-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.10.1.1\",\"modelMatrix\":\"0.337824,-0.874132,0.348953,0,0.941209,0.313748,-0.125248,0,-3.47363e-9,0.37075,0.928733,0,-10.951,-30.0672,-16.6744,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0833dd44-5993-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0833dd44-5993-11eb-94ee-226cec7cb58a.ply','PLY','PATIENT_e2cd92c5-cc74-46aa-84c4-623d1fe83196_ACT_86c35137-f28e-4bf2-ab31-eb82baafceea_SESS_059aa0ef-1c0b-4aeb-8da7-47a8fa73c953_BOSC_338f981c-b813-40d1-b9b6-00b72842f41b_PLY_','2021-01-18 13:42:21','2021-01-18 14:34:27','0833dd44-5993-11eb-94ee-226cec7cb58a.ply','2021-01-18 14:42:21','SYNCED','0833dd44-5993-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.10.1.1\",\"modelMatrix\":\"-0.999945,0.0100799,-0.00281664,0,-0.010466,-0.963053,0.269108,0,-2.35203e-10,0.269123,0.963106,0,-13.4754,13.1267,-26.7706,1\",\"title\":\"Mandibule PLY\"}'),(2,'08368f66-5993-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/08368f66-5993-11eb-94ee-226cec7cb58a.png','SNAPS','PATIENT_e2cd92c5-cc74-46aa-84c4-623d1fe83196_ACT_86c35137-f28e-4bf2-ab31-eb82baafceea_SESS_059aa0ef-1c0b-4aeb-8da7-47a8fa73c953_TOSC_0d4d31f5-276a-486c-917e-f8a4b9933d1b_SNAPS_','2021-01-18 13:42:21','2021-01-18 14:26:27','08368f66-5993-11eb-94ee-226cec7cb58a.png','2021-01-18 14:42:21','SYNCED','08368f66-5993-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.10.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0837c219-5993-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0837c219-5993-11eb-94ee-226cec7cb58a.png','SNAPS','PATIENT_e2cd92c5-cc74-46aa-84c4-623d1fe83196_ACT_86c35137-f28e-4bf2-ab31-eb82baafceea_SESS_059aa0ef-1c0b-4aeb-8da7-47a8fa73c953_BOSC_3ce06399-5373-4c39-8fa4-4d45a0a4c445_SNAPS_','2021-01-18 13:42:21','2021-01-18 14:39:15','0837c219-5993-11eb-94ee-226cec7cb58a.png','2021-01-18 14:42:21','SYNCED','0837c219-5993-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.10.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0839044e-5993-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0839044e-5993-11eb-94ee-226cec7cb58a.png','SNAPS','PATIENT_e2cd92c5-cc74-46aa-84c4-623d1fe83196_ACT_86c35137-f28e-4bf2-ab31-eb82baafceea_SESS_059aa0ef-1c0b-4aeb-8da7-47a8fa73c953_TOSC_9b63f70c-bf2d-4b53-b181-27bad88cfc75_SNAPS_','2021-01-18 13:42:22','2021-01-18 14:29:44','0839044e-5993-11eb-94ee-226cec7cb58a.png','2021-01-18 14:42:22','SYNCED','0839044e-5993-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.10.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'083dd161-25f3-4df1-89f2-d55b4627d0b1','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/083dd161-25f3-4df1-89f2-d55b4627d0b1.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_54ef530e-fe95-453d-b6ca-fcf4e17dfdf6_SESS_1e5ae9d8-b0b0-4c65-992b-0f2fdad9ac99_BOSC_31facbde-1c5d-4afe-b0f8-8d727f9f995e_SNAPS_','2021-04-27 09:50:11','2021-04-27 11:50:09','083dd161-25f3-4df1-89f2-d55b4627d0b1.png','2021-04-27 11:50:11','SYNCED','b34839cf-6f87-4c8b-bb3e-ac5d5a1df0d5',1,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.113.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0840931d-5993-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0840931d-5993-11eb-94ee-226cec7cb58a.ply','PLY','PATIENT_e2cd92c5-cc74-46aa-84c4-623d1fe83196_ACT_86c35137-f28e-4bf2-ab31-eb82baafceea_SESS_059aa0ef-1c0b-4aeb-8da7-47a8fa73c953_TOSC_1bab9860-8437-4129-9814-cfb1a5caeafa_PLY_','2021-01-18 13:42:22','2021-01-18 14:32:09','0840931d-5993-11eb-94ee-226cec7cb58a.ply','2021-01-18 14:42:22','SYNCED','0840931d-5993-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.10.1.3\",\"modelMatrix\":\"0.571035,-0.774143,0.273169,0,0.820925,0.538494,-0.190016,0,7.65378e-9,0.332757,0.943012,0,3.31276,-28.8985,-24.0754,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0841d143-5993-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0841d143-5993-11eb-94ee-226cec7cb58a.ply','PLY','PATIENT_e2cd92c5-cc74-46aa-84c4-623d1fe83196_ACT_86c35137-f28e-4bf2-ab31-eb82baafceea_SESS_059aa0ef-1c0b-4aeb-8da7-47a8fa73c953_BOSC_3ce06399-5373-4c39-8fa4-4d45a0a4c445_PLY_','2021-01-18 13:42:21','2021-01-18 14:39:15','0841d143-5993-11eb-94ee-226cec7cb58a.ply','2021-01-18 14:42:21','SYNCED','0841d143-5993-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.10.1.3\",\"modelMatrix\":\"-0.999664,0.0249395,-0.00698825,0,-0.0259,-0.962589,0.269725,0,3.64503e-10,0.269816,0.962912,0,-10.9299,14.2251,-18.3478,1\",\"title\":\"Mandibule PLY\"}'),(2,'08447644-5993-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/08447644-5993-11eb-94ee-226cec7cb58a.ply','PLY','PATIENT_e2cd92c5-cc74-46aa-84c4-623d1fe83196_ACT_86c35137-f28e-4bf2-ab31-eb82baafceea_SESS_059aa0ef-1c0b-4aeb-8da7-47a8fa73c953_BOSC_be53c600-e66b-49a2-87f0-8585d9449925_PLY_','2021-01-18 13:42:22','2021-01-18 14:36:58','08447644-5993-11eb-94ee-226cec7cb58a.ply','2021-01-18 14:42:22','SYNCED','08447644-5993-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.10.1.2\",\"modelMatrix\":\"-0.994008,-0.105582,0.028286,0,0.109305,-0.960149,0.257229,0,-2.47939e-9,0.258779,0.965936,0,-14.2373,12.1541,-20.8643,1\",\"title\":\"Mandibule PLY\"}'),(2,'0844cda3-c469-4d04-ae25-beb9cb613208','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0844cda3-c469-4d04-ae25-beb9cb613208.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_1db7f4f1-8c75-447b-9ef1-5d9a11c7c478_SESS_d8569756-ff35-4a62-828f-758652325d70_BOSC_17e2f7d5-bcbc-4d9c-9a17-0b08f1c7ac16_SNAPS_','2022-03-31 09:34:46','2022-03-31 11:34:42','0844cda3-c469-4d04-ae25-beb9cb613208.png','2022-03-31 11:34:46','SYNCED','0844cda3-c469-4d04-ae25-beb9cb613208',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.50.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0845b03a-5993-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0845b03a-5993-11eb-94ee-226cec7cb58a.png','SNAPS','PATIENT_e2cd92c5-cc74-46aa-84c4-623d1fe83196_ACT_86c35137-f28e-4bf2-ab31-eb82baafceea_SESS_059aa0ef-1c0b-4aeb-8da7-47a8fa73c953_BOSC_be53c600-e66b-49a2-87f0-8585d9449925_SNAPS_','2021-01-18 13:42:22','2021-01-18 14:36:58','0845b03a-5993-11eb-94ee-226cec7cb58a.png','2021-01-18 14:42:22','SYNCED','0845b03a-5993-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.10.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0849454f-c2e1-4fa3-bfb5-5b3c664bc4ee','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0849454f-c2e1-4fa3-bfb5-5b3c664bc4ee.png','SNAPS','PATIENT_fa5a6926-d741-45d2-a950-8a99ff95e665_ACT_9972bffd-d1d8-40b7-b0c0-980f096cbeae_SESS_cd629b65-77b1-4eaa-b23c-f841cb2ddd76_TOSC_2edbb13c-1e8d-4048-83df-0fa0ab2e5f9e_SNAPS_','2020-12-29 08:56:35','2020-12-29 09:48:17','0849454f-c2e1-4fa3-bfb5-5b3c664bc4ee.png','2020-12-29 09:56:35','SYNCED','0849454f-c2e1-4fa3-bfb5-5b3c664bc4ee',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.36.49.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'084cc778-61ef-43e8-8fe9-5ae1e7b6891c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/084cc778-61ef-43e8-8fe9-5ae1e7b6891c.png','SNAPS','PATIENT_492648bb-d190-48e7-ae8c-6b3a3748a733_ACT_2d69d1ac-c55f-45a6-a3b9-750eacd6c2b1_SESS_7bfad63b-d134-4619-9af5-a68f5c5d02e5_TOSC_42514db7-7238-4ec7-b8de-c3af1f29968a_SNAPS_','2020-12-23 09:07:42','2019-12-31 13:59:00','084cc778-61ef-43e8-8fe9-5ae1e7b6891c.png','2020-12-23 10:07:42','SYNCED','084cc778-61ef-43e8-8fe9-5ae1e7b6891c',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'084e11c2-86b8-4d8a-a2cc-7002fd7ced13','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/084e11c2-86b8-4d8a-a2cc-7002fd7ced13.stl','STL','PATIENT_74e69d84-8a8c-4dfb-8447-bb46b9f0b090_ACT_283f3801-2a5b-4acd-a56e-8ccd852b3058_SESS_cf940c68-5a78-423f-a99d-4cd17151306b_BOSC_8c74792e-c70d-4eb4-bcc7-0d60f21bb9c5_STL_','2022-02-01 11:47:23','2019-07-11 16:53:05','084e11c2-86b8-4d8a-a2cc-7002fd7ced13.stl','2022-02-01 12:47:23','SYNCED','084e11c2-86b8-4d8a-a2cc-7002fd7ced13',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 45.1.1.1\",\"modelMatrix\":\"-0.977292,0.204453,-0.0556692,0,-0.211897,-0.942962,0.256753,0,-2.55443e-9,0.262718,0.964873,0,-12.1169,19.1399,-22.4071,1\",\"title\":\"MANDIBULE STL\"}'),(2,'084f280a-9b38-4561-9486-15582d48ff26','','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_64a812ac-7801-4feb-b71a-5041b6f7c446_SESS_f2e01db8-8255-4065-b89c-d658bcbfb30a_TOSC_1030688b-da15-46a2-a5e7-3e3eec49b979_SNAPS_','2021-04-09 07:46:03','2021-04-09 09:46:01','','2021-04-09 09:46:03','SYNCED','084f280a-9b38-4561-9486-15582d48ff26',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.43.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'08595e39-dbef-45aa-ae87-ab9cd0fa7fd4','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/08595e39-dbef-45aa-ae87-ab9cd0fa7fd4.zip','ZIP','PATIENT_b03ac277-fc15-4e16-b5aa-c61591d4bcee_ACT_b57bb6cd-4742-4546-b915-f857d8f016fb_SESS_bda42e66-c504-4c31-8601-ce98935731ff_BOSC_ff6f191b-2484-4bfb-b333-e9724313c7ba_ZIP_','2021-09-29 14:43:39','2021-09-29 16:43:33','08595e39-dbef-45aa-ae87-ab9cd0fa7fd4.zip','2021-09-29 16:43:39','SYNCED','08595e39-dbef-45aa-ae87-ab9cd0fa7fd4',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.162.1.1.1\",\"modelMatrix\":\"-0.552455,-0.817712,0.161682,0,0.833543,-0.541962,0.10716,0,-9.12672e-9,0.19397,0.981007,0,-29.4341,-2.14644,-16.0987,1\",\"title\":\"Mandibule ZIP\"}'),(2,'085f0553-d07b-4828-b8c3-75ce5054bc88','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/085f0553-d07b-4828-b8c3-75ce5054bc88.ply','PLY','PATIENT_bd1eba7e-0abe-41fc-859e-90761a16482e_ACT_896e85b9-5776-4f4b-a605-57a738ffaf31_SESS_eecc3c10-e747-4234-b94e-6ef19f29289b_TOSC_812ce4dd-b0ec-47f5-9700-e3e460e62931_PLY_','2021-01-15 08:42:11','2021-01-15 08:49:27','085f0553-d07b-4828-b8c3-75ce5054bc88.ply','2021-01-15 09:42:11','SYNCED','085f0553-d07b-4828-b8c3-75ce5054bc88',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.5.1.1\",\"modelMatrix\":\"0.72875,-0.629331,0.269939,0,0.68478,0.66974,-0.287272,0,-7.30689e-9,0.394198,0.919026,0,0.949961,-33.8362,-21.7363,1\",\"title\":\"Maxillaire PLY\"}'),(2,'085f1425-6f95-11eb-8b86-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/085f1425-6f95-11eb-8b86-226cec7cb58a.ply','PLY','PATIENT_535a2cf4-1171-440b-8805-d93111a63349_ACT_1d498c24-dbfd-41c2-bc1e-234a77c6ff3a_SESS_275e74d1-81a2-4dfe-afc6-4398859514a7_BOSC_d22127c9-6ba6-482b-a417-e4f7c15477d1_PLY_','2021-02-15 13:52:28','2021-02-15 14:47:33','085f1425-6f95-11eb-8b86-226cec7cb58a.ply','2021-02-15 14:52:28','SYNCED','085f1425-6f95-11eb-8b86-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.44.1.1\",\"modelMatrix\":\"-0.841025,-0.539001,0.0464156,0,0.540996,-0.837924,0.0721571,0,-1.3368e-9,0.0857965,0.996313,0,-22.534,-0.446038,-20.4611,1\",\"title\":\"Mandibule PLY\"}'),(2,'08680d07-6f95-11eb-8b86-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/08680d07-6f95-11eb-8b86-226cec7cb58a.png','SNAPS','PATIENT_535a2cf4-1171-440b-8805-d93111a63349_ACT_1d498c24-dbfd-41c2-bc1e-234a77c6ff3a_SESS_275e74d1-81a2-4dfe-afc6-4398859514a7_TOSC_fc4283e9-707b-415e-bd85-5d58f1f2630c_SNAPS_','2021-02-15 13:52:26','2021-02-15 13:43:46','08680d07-6f95-11eb-8b86-226cec7cb58a.png','2021-02-15 14:52:26','SYNCED','08680d07-6f95-11eb-8b86-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.44.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0868bf57-28db-4571-b251-5ceda9b91f61','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0868bf57-28db-4571-b251-5ceda9b91f61.ply','PLY','PATIENT_79c7f350-c6e2-400a-8a40-2bc389f7254a_ACT_167d783d-a345-4c3f-bd59-637367de9675_SESS_a88ee2e3-d5a6-4626-bca5-c8fcece089f9_BOSC_75703640-6025-495a-929c-bfc9a7044d82_PLY_','2020-12-14 12:52:07','2020-12-14 13:48:32','0868bf57-28db-4571-b251-5ceda9b91f61.ply','2020-12-14 13:52:07','SYNCED','0868bf57-28db-4571-b251-5ceda9b91f61',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.31.1.1\",\"modelMatrix\":\"-0.996733,-0.079649,0.0134103,0,0.08077,-0.982899,0.165488,0,-1.06696e-9,0.16603,0.986121,0,-13.2788,18.204,-19.255,1\",\"title\":\"Mandibule PLY\"}'),(2,'086d25c0-6f95-11eb-8b86-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/086d25c0-6f95-11eb-8b86-226cec7cb58a.ply','PLY','PATIENT_535a2cf4-1171-440b-8805-d93111a63349_ACT_1d498c24-dbfd-41c2-bc1e-234a77c6ff3a_SESS_275e74d1-81a2-4dfe-afc6-4398859514a7_BOSC_e44fde0a-e71d-4535-943d-b69c01e59225_PLY_','2021-02-15 13:52:27','2021-02-15 14:52:05','086d25c0-6f95-11eb-8b86-226cec7cb58a.ply','2021-02-15 14:52:27','SYNCED','086d25c0-6f95-11eb-8b86-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.44.1.3\",\"modelMatrix\":\"-0.996179,-0.0840432,0.0237389,0,0.0873315,-0.95867,0.270786,0,8.55557e-10,0.271825,0.962347,0,-14.3189,8.42103,-25.0834,1\",\"title\":\"Mandibule PLY\"}'),(2,'08735c64-afe6-40c9-98da-fb5ae2b9f1d7','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/08735c64-afe6-40c9-98da-fb5ae2b9f1d7.ply','PLY','PATIENT_222a3317-e53e-4ad3-afa4-3534b4d5f485_ACT_f8ccc284-4287-4008-bb4e-e2a6bf6a2083_SESS_d57a84a2-f520-460d-bdda-446bcb2d4001_TOSC_4508144e-bc94-4b75-bdc1-a9c8557538d0_PLY_','2020-12-03 09:15:11','2020-12-03 09:46:11','08735c64-afe6-40c9-98da-fb5ae2b9f1d7.ply','2020-12-03 10:15:11','SYNCED','08735c64-afe6-40c9-98da-fb5ae2b9f1d7',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.67.3.1.1\",\"modelMatrix\":\"0.525377,-0.8295,0.189497,0,0.85087,0.512182,-0.117006,0,-6.68389e-9,0.22271,0.974885,0,-4.11176,-33.2998,-17.3498,1\",\"title\":\"Maxillaire PLY\"}'),(2,'08759cf1-6f95-11eb-8b86-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/08759cf1-6f95-11eb-8b86-226cec7cb58a.png','SNAPS','PATIENT_535a2cf4-1171-440b-8805-d93111a63349_ACT_1d498c24-dbfd-41c2-bc1e-234a77c6ff3a_SESS_275e74d1-81a2-4dfe-afc6-4398859514a7_BOSC_e44fde0a-e71d-4535-943d-b69c01e59225_SNAPS_','2021-02-15 13:52:26','2021-02-15 14:52:05','08759cf1-6f95-11eb-8b86-226cec7cb58a.png','2021-02-15 14:52:26','SYNCED','08759cf1-6f95-11eb-8b86-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.44.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0877e08d-c331-4a1f-a611-c028b0f9f040','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0877e08d-c331-4a1f-a611-c028b0f9f040.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_cbdea198-bc36-4a11-9d8d-5d6cceb2efb9_SESS_0b224b12-b809-4c65-b652-42bd01939028_TOSC_66131c6c-7530-4fb8-9006-27912bd1975b_SNAPS_','2021-04-30 09:50:51','2021-04-30 11:50:50','0877e08d-c331-4a1f-a611-c028b0f9f040.png','2021-04-30 11:50:51','SYNCED','0877e08d-c331-4a1f-a611-c028b0f9f040',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.133.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'087da115-6f95-11eb-8b86-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/087da115-6f95-11eb-8b86-226cec7cb58a.png','SNAPS','PATIENT_535a2cf4-1171-440b-8805-d93111a63349_ACT_1d498c24-dbfd-41c2-bc1e-234a77c6ff3a_SESS_275e74d1-81a2-4dfe-afc6-4398859514a7_BOSC_d22127c9-6ba6-482b-a417-e4f7c15477d1_SNAPS_','2021-02-15 13:52:28','2021-02-15 14:47:33','087da115-6f95-11eb-8b86-226cec7cb58a.png','2021-02-15 14:52:28','SYNCED','087da115-6f95-11eb-8b86-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.44.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'088009b1-f6b8-4649-a5f6-3406b3f2c32f','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/088009b1-f6b8-4649-a5f6-3406b3f2c32f.png','SNAPS','PATIENT_e065ef95-3928-430d-bee5-6cc04ce694eb_ACT_16a80821-8351-4656-aae6-c9380c3a5576_SESS_6aba71e1-eb75-4e0c-bb94-f5214fbf9fa0_BOSC_60d5ffc4-dd50-404a-8528-4b2f673e231f_SNAPS_','2020-12-07 12:00:48','2020-08-20 14:54:50','088009b1-f6b8-4649-a5f6-3406b3f2c32f.png','2020-12-07 13:00:48','SYNCED','088009b1-f6b8-4649-a5f6-3406b3f2c32f',0,NULL,'','','{\"displayTitle\":\"Mandibule 61.1.18.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'088336f4-74ed-4a45-9449-0310a81fe5be','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/088336f4-74ed-4a45-9449-0310a81fe5be.ply','PLY','PATIENT_95405121-f140-4116-92ca-cae7d44f9bba_ACT_3d2ec6af-c315-4775-9d50-cf24a2a45658_SESS_faa85dca-33e7-48ff-9dc3-1ff7d89b3feb_BOSC_27f5e407-f1e1-4db7-84b3-b7d173106c32_PLY_','2022-02-01 11:47:23','2019-07-16 08:44:55','088336f4-74ed-4a45-9449-0310a81fe5be.ply','2022-02-01 12:47:23','SYNCED','088336f4-74ed-4a45-9449-0310a81fe5be',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 73.1.1.1\",\"modelMatrix\":\"-0.972787,-0.226138,0.0504687,0,0.231701,-0.94943,0.211891,0,1.66262e-9,0.217818,0.975989,0,-25.3697,10.0166,-23.5228,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0886433a-7f49-40d9-a00d-2af61e20ca9a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0886433a-7f49-40d9-a00d-2af61e20ca9a.stl','STL','PATIENT_ff96c5bd-a3bf-4f05-92e4-56f76b83b454_ACT_d737feed-a81f-42f0-a536-f47f5a256ae6_SESS_4ac56d86-9375-40ed-956b-affb4721bd49_TOSC_c703c340-c05c-4271-a8ef-688293b8a817_STL_','2021-12-30 18:03:11','2019-11-18 11:46:57','0886433a-7f49-40d9-a00d-2af61e20ca9a.stl','2021-12-30 19:03:11','SYNCED','0886433a-7f49-40d9-a00d-2af61e20ca9a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 203.1.1.1\",\"modelMatrix\":\"0.689837,-0.645555,0.327696,0,0.723965,0.615123,-0.312248,0,-5.68395e-9,0.45264,0.891693,0,6.49575,-35.8846,-20.1313,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'088e48c5-1420-4874-84ef-ebf83f4c1841','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/088e48c5-1420-4874-84ef-ebf83f4c1841.png','SNAPS','PATIENT_8b3de562-f831-4ca2-b21a-b804d3e29f3b_ACT_c6ae0323-89f5-46dd-bd5a-5411b7e5f2b4_SESS_8df332ef-98aa-41c1-af19-12c79aa2505c_BOSC_6787f1cb-eec5-4606-852d-f78306c9861b_SNAPS_','2021-09-20 10:05:17','2021-09-16 15:16:27','088e48c5-1420-4874-84ef-ebf83f4c1841.png','2021-09-20 12:05:17','SYNCED','088e48c5-1420-4874-84ef-ebf83f4c1841',0,'2021-09-20 12:05:17','','','{\"displayTitle\":\"Mandibule 22.389.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'089f4da8-3eba-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/089f4da8-3eba-11eb-94ee-226cec7cb58a.ply','PLY','PATIENT_196f3637-95c1-4658-beca-3c3b12c69741_ACT_29ecd90a-b462-4c90-a54e-9c65afd028db_SESS_d2de0dfe-b3eb-49d7-9931-f76c3fe5e356_BOSC_d332f383-827f-47e2-a08e-d32bf07eb8dd_PLY_','2020-12-15 09:38:00','2020-12-15 10:37:58','089f4da8-3eba-11eb-94ee-226cec7cb58a.ply','2020-12-15 10:38:00','SYNCED','089f4da8-3eba-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.34.1.3\",\"modelMatrix\":\"-0.991048,0.124086,-0.0492687,0,-0.133509,-0.921097,0.365725,0,-7.97833e-10,0.369029,0.929418,0,-20.1382,16.8537,-19.1244,1\",\"title\":\"Mandibule PLY\"}'),(2,'08a2e2e0-3eba-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/08a2e2e0-3eba-11eb-94ee-226cec7cb58a.png','SNAPS','PATIENT_196f3637-95c1-4658-beca-3c3b12c69741_ACT_29ecd90a-b462-4c90-a54e-9c65afd028db_SESS_d2de0dfe-b3eb-49d7-9931-f76c3fe5e356_BOSC_d332f383-827f-47e2-a08e-d32bf07eb8dd_SNAPS_','2020-12-15 09:37:59','2020-12-15 10:37:58','08a2e2e0-3eba-11eb-94ee-226cec7cb58a.png','2020-12-15 10:37:59','SYNCED','08a2e2e0-3eba-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.34.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'08aa3e88-3d9d-4183-80ef-98ee2b20bfbe','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/08aa3e88-3d9d-4183-80ef-98ee2b20bfbe.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_662f2eed-7229-4d2c-95b4-a921836cab63_SESS_a472767f-846b-4a2a-a470-e12044349f9d_TOSC_d0db079a-dd4c-4153-b7d0-cec87d4fc3cd_ZIP_','2022-03-01 11:09:38','2022-03-01 12:09:36','08aa3e88-3d9d-4183-80ef-98ee2b20bfbe.zip','2022-03-01 12:09:38','SYNCED','08aa3e88-3d9d-4183-80ef-98ee2b20bfbe',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.28.1.2\",\"modelMatrix\":\"0.408573,-0.899205,0.156519,0,0.912726,0.40252,-0.070064,0,-4.60548e-09,0.171485,0.985187,0,-6.95177,-31.4789,-12.6239,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'08af026d-f438-4397-ab86-35e189222735','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/08af026d-f438-4397-ab86-35e189222735.ply','PLY','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_8d653271-32c7-44b9-8871-ff413f597bf4_SESS_73a88555-3377-4c81-b14e-4c5adf325290_BOSC_3cbc8dfc-4fb7-49d2-9ba6-629967fdb1d9_PLY_','2020-12-23 09:07:43','2020-01-03 10:41:35','08af026d-f438-4397-ab86-35e189222735.ply','2020-12-23 10:07:43','SYNCED','08af026d-f438-4397-ab86-35e189222735',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"modelMatrix\":\"-0.969936,0.233808,-0.0675202,0,-0.243362,-0.931857,0.269106,0,4.03347e-9,0.277448,0.960741,0,-12.5278,17.1631,-16.7395,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'08b08c83-1deb-45de-bccb-220770199f99','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/08b08c83-1deb-45de-bccb-220770199f99.ply','PLY','PATIENT_85f75944-a935-4d81-b144-df694a135914_ACT_dfa89c7a-56d5-41f7-a023-17e952b5b982_SESS_d7124024-9d62-42cf-9ec0-f190cdbd0557_TOSC_092a4e45-f5df-44d6-9079-20dc1ad9493d_PLY_','2021-12-30 18:03:12','2019-10-15 11:09:08','08b08c83-1deb-45de-bccb-220770199f99.ply','2021-12-30 19:03:12','SYNCED','08b08c83-1deb-45de-bccb-220770199f99',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 188.1.1.1\",\"modelMatrix\":\"0.765088,-0.598485,0.237604,0,0.643926,0.711097,-0.282312,0,-9.24433e-9,0.368993,0.929432,0,9.6311,-27.6002,-27.1971,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'08bf70f3-2f4e-4031-9f92-94cd50a198f6','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/08bf70f3-2f4e-4031-9f92-94cd50a198f6.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_686a9728-96b1-463a-a519-cfca1c50f437_SESS_8e42653c-d3a6-40a2-b213-84582d26632a_BOSC_d120c432-1653-4ae0-a5db-4599414be49f_SNAPS_','2021-05-27 09:43:49','2021-05-27 11:43:47','08bf70f3-2f4e-4031-9f92-94cd50a198f6.png','2021-05-27 11:43:49','SYNCED','08bf70f3-2f4e-4031-9f92-94cd50a198f6',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.155.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'08cef3ac-6f95-11eb-8b86-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/08cef3ac-6f95-11eb-8b86-226cec7cb58a.ply','PLY','PATIENT_535a2cf4-1171-440b-8805-d93111a63349_ACT_1d498c24-dbfd-41c2-bc1e-234a77c6ff3a_SESS_275e74d1-81a2-4dfe-afc6-4398859514a7_TOSC_31c4abe7-9b9e-4b46-8514-f6a0efc8d9bb_PLY_','2021-02-15 13:52:28','2021-02-15 14:07:47','08cef3ac-6f95-11eb-8b86-226cec7cb58a.ply','2021-02-15 14:52:28','SYNCED','08cef3ac-6f95-11eb-8b86-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.44.1.2\",\"modelMatrix\":\"0.254274,-0.91149,0.323312,0,0.967132,0.239645,-0.0850039,0,1.4842e-9,0.3343,0.942467,0,-12.8771,-34.9455,-11.6715,1\",\"title\":\"Maxillaire PLY\"}'),(2,'08d14961-54b4-4960-964d-ca83a60e7925','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/08d14961-54b4-4960-964d-ca83a60e7925.ply','PLY','PATIENT_79e8d925-ff60-4d5d-8629-97b38436217b_ACT_184c1d95-dbfa-4362-a1b6-11a4406e576e_SESS_4aeb8e71-0b1b-4a3f-8d23-adcdeb027d37_BOSC_22d93dfe-0405-4c85-a61b-e84a4114d83d_PLY_','2021-03-30 08:30:16','2021-03-30 10:29:10','08d14961-54b4-4960-964d-ca83a60e7925.ply','2021-03-30 10:30:16','SYNCED','08d14961-54b4-4960-964d-ca83a60e7925',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.17.1.3\",\"modelMatrix\":\"-0.675555,-0.728864,0.11128,0,0.73731,-0.667816,0.10196,0,-4.74356e-9,0.150927,0.988545,0,-20.4696,-1.94461,-22.7891,1\",\"title\":\"Mandibule PLY\"}'),(2,'08d5cbf1-9d48-4ca5-a39e-a6b8cf5c4e50','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/08d5cbf1-9d48-4ca5-a39e-a6b8cf5c4e50.ply','PLY','PATIENT_851dba8f-96f3-4f86-878b-546b851640a1_ACT_0e8ad969-76dd-41ae-9ccf-e9ac9d930078_SESS_e0026ffb-3903-44b2-8f95-982029c38406_BOSC_5e9dab91-789c-4ef3-9007-73cd6807eba6_PLY_','2020-11-27 10:52:13','2020-11-27 11:45:04','08d5cbf1-9d48-4ca5-a39e-a6b8cf5c4e50.ply','2020-11-27 11:52:13','SYNCED','08d5cbf1-9d48-4ca5-a39e-a6b8cf5c4e50',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.67.2.1.2\",\"modelMatrix\":\"-0.895126,0.439376,-0.0754826,0,-0.445812,-0.882203,0.151558,0,4.8214e-9,0.169315,0.985562,0,-5.25888,20.691,-18.5899,1\",\"title\":\"Mandibule PLY\"}'),(2,'08d73f34-6f95-11eb-8b86-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/08d73f34-6f95-11eb-8b86-226cec7cb58a.ply','PLY','PATIENT_535a2cf4-1171-440b-8805-d93111a63349_ACT_1d498c24-dbfd-41c2-bc1e-234a77c6ff3a_SESS_275e74d1-81a2-4dfe-afc6-4398859514a7_BOSC_c2dc749f-6cc7-4c07-9eee-5fa39189ce02_PLY_','2021-02-15 13:52:28','2021-02-15 14:49:51','08d73f34-6f95-11eb-8b86-226cec7cb58a.ply','2021-02-15 14:52:28','SYNCED','08d73f34-6f95-11eb-8b86-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.44.1.2\",\"modelMatrix\":\"-0.985921,0.160519,-0.0468428,0,-0.167214,-0.946444,0.276193,0,-2.28212e-9,0.280137,0.95996,0,-12.1526,17.2103,-18.9837,1\",\"title\":\"Mandibule PLY\"}'),(2,'08d980d6-35fa-4894-b5b9-f921a0786ae4','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/08d980d6-35fa-4894-b5b9-f921a0786ae4.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_dbafeb18-79ca-426c-b73a-0c3fcdddc854_SESS_46c23bf5-8a3d-4cbb-b75b-dd360411bfb5_TOSC_d81503fd-80f1-40e4-86ac-a358f7292294_PLY_','2021-04-27 08:58:02','2021-04-27 10:57:55','08d980d6-35fa-4894-b5b9-f921a0786ae4.ply','2021-04-27 10:58:02','SYNCED','08d980d6-35fa-4894-b5b9-f921a0786ae4',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.112.1.3\",\"modelMatrix\":\"0.852927,-0.469456,0.22831,0,0.52203,0.76703,-0.373029,0,-1.30845e-8,0.437351,0.899291,0,13.4418,-27.8024,-18.0393,1\",\"title\":\"Maxillaire PLY\"}'),(2,'08e04386-6f95-11eb-8b86-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/08e04386-6f95-11eb-8b86-226cec7cb58a.png','SNAPS','PATIENT_535a2cf4-1171-440b-8805-d93111a63349_ACT_1d498c24-dbfd-41c2-bc1e-234a77c6ff3a_SESS_275e74d1-81a2-4dfe-afc6-4398859514a7_TOSC_a593cbb8-a8d0-4075-8e68-9cdd36436732_SNAPS_','2021-02-15 13:52:27','2021-02-15 14:10:22','08e04386-6f95-11eb-8b86-226cec7cb58a.png','2021-02-15 14:52:27','SYNCED','08e04386-6f95-11eb-8b86-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.44.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'08e0f7c9-6ce8-43bb-8606-08521e8e70c8','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/08e0f7c9-6ce8-43bb-8606-08521e8e70c8.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_11101b3c-2101-42ce-97c5-aec79796db62_SESS_0855b14f-76dd-4f90-a794-b6e424964bfb_TOSC_d9139df7-c760-480c-abbb-bfadaad2b510_SNAPS_','2021-04-07 12:31:18','2021-04-07 14:31:16','08e0f7c9-6ce8-43bb-8606-08521e8e70c8.png','2021-04-07 14:31:18','SYNCED','08e0f7c9-6ce8-43bb-8606-08521e8e70c8',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.3.16.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'08ebe2e8-bc7b-445e-892c-13c4c77980e6','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/08ebe2e8-bc7b-445e-892c-13c4c77980e6.ply','PLY','PATIENT_5f861654-dd88-4404-b6ce-ab61dd80d65a_ACT_283ffdd7-9872-400e-8864-ceb7a283e06c_SESS_053ae2bd-f330-4080-9666-9491f24cbd51_BOSC_f0fbcaab-7c1c-4425-8080-75a125de3ce0_PLY_','2022-02-01 11:47:23','2019-09-03 11:47:55','08ebe2e8-bc7b-445e-892c-13c4c77980e6.ply','2022-02-01 12:47:23','SYNCED','08ebe2e8-bc7b-445e-892c-13c4c77980e6',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 142.1.1.1\",\"modelMatrix\":\"0.396607,-0.901233,0.174591,0,0.917989,0.389368,-0.07543,0,-2.63711e-10,0.190188,0.981748,0,-7.58146,-29.449,-25.838,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'08f1f2bb-6f95-11eb-8b86-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/08f1f2bb-6f95-11eb-8b86-226cec7cb58a.png','SNAPS','PATIENT_535a2cf4-1171-440b-8805-d93111a63349_ACT_1d498c24-dbfd-41c2-bc1e-234a77c6ff3a_SESS_275e74d1-81a2-4dfe-afc6-4398859514a7_TOSC_31c4abe7-9b9e-4b46-8514-f6a0efc8d9bb_SNAPS_','2021-02-15 13:52:27','2021-02-15 14:07:47','08f1f2bb-6f95-11eb-8b86-226cec7cb58a.png','2021-02-15 14:52:27','SYNCED','08f1f2bb-6f95-11eb-8b86-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.44.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'08f42ee9-535b-433a-bb87-54b01737ca69','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/08f42ee9-535b-433a-bb87-54b01737ca69.png','SNAPS','PATIENT_0cc4ef86-2202-4a20-b6c2-a4a99611d672_ACT_44a86be7-5a36-4315-83dd-5bdea1c0fe89_SESS_27eb34f2-a17f-46b3-8c3c-c8c43be4e2e2_BOSC_8fc9fbb3-34aa-43cc-afcb-b747e82c46b0_SNAPS_','2020-12-08 17:26:07','2020-07-07 12:05:36','08f42ee9-535b-433a-bb87-54b01737ca69.png','2020-12-08 18:26:07','SYNCED','08f42ee9-535b-433a-bb87-54b01737ca69',0,NULL,'','','{\"displayTitle\":\"Mandibule 88.2.30.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0904cc22-a438-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0904cc22-a438-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_6c5d4194-c28f-4dc4-a836-110a650573fc_SESS_25a8e928-4efc-485b-85c9-f8544e3e5dce_TOSC_16ebd117-f410-4008-a168-17e349bef404_SNAPS_','2021-04-23 13:11:59','2021-04-23 15:11:58','0904cc22-a438-11eb-9377-226cec7cb58a.png','2021-04-23 15:11:59','SYNCED','0904cc22-a438-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.96.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'09065e45-bcce-474f-9685-638c5b59691f','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09065e45-bcce-474f-9685-638c5b59691f.png','SNAPS','PATIENT_491f6fac-4e7b-45ff-853c-c5880019fa93_ACT_61c527a3-56f3-4776-8cbd-02a3124364d4_SESS_ccd013fe-71ee-415b-8735-209f53c9eeeb_BOSC_ea3b0bbc-5515-4956-8f9c-80da8e25f936_SNAPS_','2021-01-26 14:45:37','2021-01-26 15:39:48','09065e45-bcce-474f-9685-638c5b59691f.png','2021-01-26 15:45:37','SYNCED','09065e45-bcce-474f-9685-638c5b59691f',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.24.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'090a2d20-a438-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/090a2d20-a438-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_6c5d4194-c28f-4dc4-a836-110a650573fc_SESS_25a8e928-4efc-485b-85c9-f8544e3e5dce_TOSC_f320589d-85aa-4db8-ac24-338cae156a6c_PLY_','2021-04-23 13:14:15','2021-04-23 15:14:13','090a2d20-a438-11eb-9377-226cec7cb58a.ply','2021-04-23 15:14:15','SYNCED','090a2d20-a438-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.96.1.3\",\"modelMatrix\":\"0.805313,-0.527569,0.270447,0,0.59285,0.716637,-0.367369,0,-6.37144e-10,0.456182,0.889887,0,7.84553,-33.4421,-18.1765,1\",\"title\":\"Maxillaire PLY\"}'),(2,'090fa969-a438-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/090fa969-a438-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_6c5d4194-c28f-4dc4-a836-110a650573fc_SESS_25a8e928-4efc-485b-85c9-f8544e3e5dce_BOSC_f4c7c824-11d2-467d-be2d-efc54d58916f_SNAPS_','2021-04-23 13:21:31','2021-04-23 15:21:28','090fa969-a438-11eb-9377-226cec7cb58a.png','2021-04-23 15:21:31','SYNCED','090fa969-a438-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.96.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'09104522-10f7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09104522-10f7-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_7da1c98d-8103-4b55-a8f3-84a1ce2c951b_ACT_0559baca-076e-4d10-b98d-839b7104e5e1_SESS_4a20a374-7067-4593-a215-f2557a95fac7_TOSC_09eed85a-5f33-4efb-b954-ac02193fa2c0_SNAPS_','2021-08-05 07:30:48','2019-11-27 10:14:43','09104522-10f7-11ea-947d-226cec7cb58a.png','2021-08-05 09:30:48','SYNCED','09104522-10f7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 211.3.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0911d952-10f7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0911d952-10f7-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_7da1c98d-8103-4b55-a8f3-84a1ce2c951b_ACT_0559baca-076e-4d10-b98d-839b7104e5e1_SESS_4a20a374-7067-4593-a215-f2557a95fac7_TOSC_09eed85a-5f33-4efb-b954-ac02193fa2c0_PLY_','2021-08-05 07:30:48','2019-11-27 10:14:43','0911d952-10f7-11ea-947d-226cec7cb58a.ply','2021-08-05 09:30:48','SYNCED','0911d952-10f7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 211.3.1.1\",\"modelMatrix\":\"0.737304,-0.660437,0.142149,0,0.675561,0.720797,-0.15514,0,-4.95262e-9,0.210416,0.977612,0,7.08308,-31.9606,-20.2196,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'091321e1-10f7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/091321e1-10f7-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_7da1c98d-8103-4b55-a8f3-84a1ce2c951b_ACT_0559baca-076e-4d10-b98d-839b7104e5e1_SESS_4a20a374-7067-4593-a215-f2557a95fac7_BOSC_0b356503-8997-4830-a758-349a99a0de63_PLY_','2021-08-05 07:30:48','2019-11-27 10:17:59','091321e1-10f7-11ea-947d-226cec7cb58a.ply','2021-08-05 09:30:48','SYNCED','091321e1-10f7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 211.3.1.1\",\"modelMatrix\":\"-0.923899,0.369196,-0.100526,0,-0.382638,-0.891444,0.242726,0,9.50099e-10,0.262719,0.964872,0,-15.1679,21.9347,-16.8309,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'09148312-10f7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09148312-10f7-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_7da1c98d-8103-4b55-a8f3-84a1ce2c951b_ACT_0559baca-076e-4d10-b98d-839b7104e5e1_SESS_4a20a374-7067-4593-a215-f2557a95fac7_BOSC_0b356503-8997-4830-a758-349a99a0de63_SNAPS_','2021-08-05 07:30:48','2019-11-27 10:17:59','09148312-10f7-11ea-947d-226cec7cb58a.png','2021-08-05 09:30:48','SYNCED','09148312-10f7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 211.3.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0914f8ba-a438-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0914f8ba-a438-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_6c5d4194-c28f-4dc4-a836-110a650573fc_SESS_25a8e928-4efc-485b-85c9-f8544e3e5dce_TOSC_bafed43a-2694-4eca-bba7-c6461a70d989_PLY_','2021-04-23 13:09:02','2021-04-23 15:09:01','0914f8ba-a438-11eb-9377-226cec7cb58a.ply','2021-04-23 15:09:02','SYNCED','0914f8ba-a438-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.96.1.1\",\"modelMatrix\":\"0.6863,-0.659923,0.305769,0,0.727319,0.622705,-0.288524,0,1.66318e-8,0.420406,0.907336,0,5.25067,-33.4083,-22.6631,1\",\"title\":\"Maxillaire PLY\"}'),(2,'09154c5d-299f-413b-a8d3-714be594dcca','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09154c5d-299f-413b-a8d3-714be594dcca.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_a2523d32-776d-4d4d-949a-7f1e94b7ef48_SESS_0ba4fe3a-a81f-4c66-9997-b004f8df74dd_TOSC_c83f955c-85bb-4532-bc1c-2d65a6833267_PLY_','2021-04-28 08:34:59','2021-04-28 10:34:57','09154c5d-299f-413b-a8d3-714be594dcca.ply','2021-04-28 10:34:59','SYNCED','09154c5d-299f-413b-a8d3-714be594dcca',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.121.1.2\",\"modelMatrix\":\"0.654359,-0.692186,0.304455,0,0.756184,0.598979,-0.263458,0,6.75428e-9,0.40262,0.915367,0,3.75389,-33.6882,-18.8837,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0915c26e-10f7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0915c26e-10f7-11ea-947d-226cec7cb58a.stl','STL','PATIENT_7da1c98d-8103-4b55-a8f3-84a1ce2c951b_ACT_0559baca-076e-4d10-b98d-839b7104e5e1_SESS_4a20a374-7067-4593-a215-f2557a95fac7_TOSC_09eed85a-5f33-4efb-b954-ac02193fa2c0_STL_','2021-08-05 07:30:48','2019-11-27 10:14:43','0915c26e-10f7-11ea-947d-226cec7cb58a.stl','2021-08-05 09:30:48','SYNCED','0915c26e-10f7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 211.3.1.1\",\"modelMatrix\":\"0.737304,-0.660437,0.142149,0,0.675561,0.720797,-0.15514,0,-4.95262e-9,0.210416,0.977612,0,7.08308,-31.9606,-20.2196,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'09171781-10f7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09171781-10f7-11ea-947d-226cec7cb58a.stl','STL','PATIENT_7da1c98d-8103-4b55-a8f3-84a1ce2c951b_ACT_0559baca-076e-4d10-b98d-839b7104e5e1_SESS_4a20a374-7067-4593-a215-f2557a95fac7_BOSC_0b356503-8997-4830-a758-349a99a0de63_STL_','2021-08-05 07:30:49','2019-11-27 10:17:59','09171781-10f7-11ea-947d-226cec7cb58a.stl','2021-08-05 09:30:49','SYNCED','09171781-10f7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 211.3.1.1\",\"modelMatrix\":\"-0.923899,0.369196,-0.100526,0,-0.382638,-0.891444,0.242726,0,9.50099e-10,0.262719,0.964872,0,-15.1679,21.9347,-16.8309,1\",\"title\":\"MANDIBULE STL\"}'),(2,'091a751e-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/091a751e-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_7e31dc23-e958-4dce-a295-bc79e0259c7b_SNAPS_','2020-12-16 11:05:59','2020-01-24 14:15:19','091a751e-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:05:59','SYNCED','091a751e-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.16\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'091aca18-2370-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/091aca18-2370-11eb-94ee-226cec7cb58a.png','SNAPS','PATIENT_e7d00f8c-583d-463b-bcf0-f0cece8f4723_ACT_dc5bd605-ebd8-4028-83b1-237c381260a7_SESS_fbf11919-596b-49e8-bf54-4613cb6cf648_TOSC_f4f23a6a-16be-47a9-ba96-88d76685d40c_SNAPS_','2020-12-02 10:32:12','2020-11-10 17:11:26','091aca18-2370-11eb-94ee-226cec7cb58a.png','2020-12-02 11:32:12','SYNCED','091aca18-2370-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 64.1.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'091c8201-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/091c8201-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_cf7510f6-bfb5-4e90-af14-79e2643fc837_SNAPS_','2020-12-16 11:05:59','2020-01-24 13:50:45','091c8201-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:05:59','SYNCED','091c8201-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.8\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'091d6936-2370-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/091d6936-2370-11eb-94ee-226cec7cb58a.png','SNAPS','PATIENT_e7d00f8c-583d-463b-bcf0-f0cece8f4723_ACT_dc5bd605-ebd8-4028-83b1-237c381260a7_SESS_fbf11919-596b-49e8-bf54-4613cb6cf648_BOSC_e197d115-be97-4b28-aac6-1b8f49b3a48e_SNAPS_','2020-12-02 10:32:12','2020-11-10 17:14:53','091d6936-2370-11eb-94ee-226cec7cb58a.png','2020-12-02 11:32:12','SYNCED','091d6936-2370-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 64.1.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'091e39d3-a438-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/091e39d3-a438-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_6c5d4194-c28f-4dc4-a836-110a650573fc_SESS_25a8e928-4efc-485b-85c9-f8544e3e5dce_BOSC_460bf072-2b17-42dd-8c01-5dfe115788d5_SNAPS_','2021-04-23 13:29:56','2021-04-23 15:29:55','091e39d3-a438-11eb-9377-226cec7cb58a.png','2021-04-23 15:29:56','SYNCED','091e39d3-a438-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.96.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'091e3a55-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/091e3a55-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_a652bfa0-2f48-4a5c-baee-0b1742d0f575_SNAPS_','2020-12-16 11:06:00','2020-01-24 13:33:07','091e3a55-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:00','SYNCED','091e3a55-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.2\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'091eb1c2-3e2c-4344-8669-f86189559628','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/091eb1c2-3e2c-4344-8669-f86189559628.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_41b5fad2-aede-461d-818a-1d1c157ae13e_SESS_70c6b1cf-09d9-4f7c-a7e2-662b48f5f835_BOSC_907d1eef-7b5a-4d17-b7bb-9bc2715e680a_PLY_','2021-05-03 08:15:52','2021-05-03 10:15:50','091eb1c2-3e2c-4344-8669-f86189559628.ply','2021-05-03 10:15:52','SYNCED','091eb1c2-3e2c-4344-8669-f86189559628',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.135.1.2\",\"modelMatrix\":\"-0.98692,-0.150505,0.0577585,0,0.161207,-0.921401,0.3536,0,5.61326e-10,0.358286,0.933612,0,-26.9127,6.19355,-20.3469,1\",\"title\":\"Mandibule PLY\"}'),(2,'091f50c4-c5bb-4db9-a6d0-176a63f0ec4d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/091f50c4-c5bb-4db9-a6d0-176a63f0ec4d.png','SNAPS','PATIENT_ddf803cd-534e-4462-a98f-452841304f52_ACT_b391c978-c88a-4f6d-ba94-9ed543204dce_SESS_ed91e1ca-a79b-47a0-8342-487076ff127f_TOSC_2d6486fa-5c93-4d39-8514-9d1d754342c6_SNAPS_','2020-12-16 09:03:08','2020-12-16 09:42:24','091f50c4-c5bb-4db9-a6d0-176a63f0ec4d.png','2020-12-16 10:03:08','SYNCED','091f50c4-c5bb-4db9-a6d0-176a63f0ec4d',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.36.39.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'091ff0a2-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/091ff0a2-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_2bed089e-68c3-431b-99b5-222a86530979_PLY_','2020-12-16 11:06:00','2020-01-24 14:18:24','091ff0a2-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:00','SYNCED','091ff0a2-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.17\",\"modelMatrix\":\"-0.908515,0.388306,-0.154331,0,-0.417851,-0.844276,0.335556,0,-1.75121e-8,0.369345,0.929292,0,-7.51411,22.2665,-17.6662,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'092051ef-2370-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/092051ef-2370-11eb-94ee-226cec7cb58a.ply','PLY','PATIENT_e7d00f8c-583d-463b-bcf0-f0cece8f4723_ACT_dc5bd605-ebd8-4028-83b1-237c381260a7_SESS_fbf11919-596b-49e8-bf54-4613cb6cf648_TOSC_f4f23a6a-16be-47a9-ba96-88d76685d40c_PLY_','2020-12-02 10:32:12','2020-11-10 17:11:26','092051ef-2370-11eb-94ee-226cec7cb58a.ply','2020-12-02 11:32:12','SYNCED','092051ef-2370-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 64.1.1.1.1\",\"modelMatrix\":\"0.677217,-0.693414,0.246076,0,0.735783,0.638221,-0.226489,0,7.08793e-9,0.334441,0.942417,0,-0.0153187,-32.8939,-15.6203,1\",\"title\":\"Maxillaire PLY\"}'),(2,'09216550-a438-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09216550-a438-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_6c5d4194-c28f-4dc4-a836-110a650573fc_SESS_25a8e928-4efc-485b-85c9-f8544e3e5dce_TOSC_f320589d-85aa-4db8-ac24-338cae156a6c_SNAPS_','2021-04-23 13:14:14','2021-04-23 15:14:13','09216550-a438-11eb-9377-226cec7cb58a.png','2021-04-23 15:14:14','SYNCED','09216550-a438-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.96.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0921659a-2370-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0921659a-2370-11eb-94ee-226cec7cb58a.ply','PLY','PATIENT_e7d00f8c-583d-463b-bcf0-f0cece8f4723_ACT_dc5bd605-ebd8-4028-83b1-237c381260a7_SESS_fbf11919-596b-49e8-bf54-4613cb6cf648_BOSC_e197d115-be97-4b28-aac6-1b8f49b3a48e_PLY_','2020-12-02 10:32:13','2020-11-10 17:14:53','0921659a-2370-11eb-94ee-226cec7cb58a.ply','2020-12-02 11:32:13','SYNCED','0921659a-2370-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 64.1.1.1.1\",\"modelMatrix\":\"-0.948351,-0.295874,0.114409,0,0.317223,-0.884525,0.34203,0,6.32333e-9,0.360658,0.932698,0,-22.4216,7.86572,-18.3231,1\",\"title\":\"Mandibule PLY\"}'),(2,'09219e50-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09219e50-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_e44fbbcb-7ace-4649-8a05-a692408f5313_SNAPS_','2020-12-16 11:06:00','2020-01-24 12:28:27','09219e50-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:00','SYNCED','09219e50-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.10\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'092357d4-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/092357d4-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_8f0d3062-1121-4e4e-b9ed-921f4dc3427f_PLY_','2020-12-16 11:06:00','2020-01-24 13:44:39','092357d4-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:00','SYNCED','092357d4-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.6\",\"modelMatrix\":\"-0.945861,0.317991,-0.0650353,0,-0.324573,-0.926679,0.189524,0,4.02151e-10,0.200372,0.97972,0,-9.97534,16.089,-15.7728,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0924f01e-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0924f01e-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_abfa29ed-6ab0-4bc3-bba5-0eb65b7afeb5_SNAPS_','2020-12-16 11:06:01','2020-01-24 14:02:24','0924f01e-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:01','SYNCED','0924f01e-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.12\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'09259063-6f95-11eb-8b86-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09259063-6f95-11eb-8b86-226cec7cb58a.ply','PLY','PATIENT_535a2cf4-1171-440b-8805-d93111a63349_ACT_1d498c24-dbfd-41c2-bc1e-234a77c6ff3a_SESS_275e74d1-81a2-4dfe-afc6-4398859514a7_TOSC_fc4283e9-707b-415e-bd85-5d58f1f2630c_PLY_','2021-02-15 13:52:27','2021-02-15 13:43:46','09259063-6f95-11eb-8b86-226cec7cb58a.ply','2021-02-15 14:52:27','SYNCED','09259063-6f95-11eb-8b86-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.44.1.1\",\"modelMatrix\":\"0.353448,-0.89018,0.287496,0,0.935454,0.336342,-0.108626,0,-8.69656e-10,0.307333,0.951602,0,-12.4634,-32.7136,-16.5731,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0925d4a1-ed22-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0925d4a1-ed22-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_8c048862-a41c-4126-bc34-483a4bba0079_SESS_142407e6-2e5d-465d-8654-844bd4956f1e_BOSC_d62ee36d-2300-41ea-8586-0e048de189bc_SNAPS_','2020-12-07 12:00:51','2020-09-02 15:40:37','0925d4a1-ed22-11ea-947d-226cec7cb58a.png','2020-12-07 13:00:51','SYNCED','0925d4a1-ed22-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.26.66.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0926b5fb-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0926b5fb-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_ded13e4f-345b-4d5a-a99e-d24ba3e66dda_PLY_','2020-12-16 11:06:01','2020-01-24 12:08:35','0926b5fb-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:01','SYNCED','0926b5fb-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.3\",\"modelMatrix\":\"0.773921,-0.571864,0.272062,0,0.633282,0.698864,-0.332481,0,-1.40391e-9,0.429606,0.903017,0,7.71486,-28.8235,-19.6118,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0926c281-4a3b-4c7b-865f-5675c16be627','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0926c281-4a3b-4c7b-865f-5675c16be627.ply','PLY','PATIENT_79406c13-00e4-4a57-b938-5ac4cd1a9f2f_ACT_dbfeadf7-7793-42fb-be76-63e1515647d5_SESS_e53f2bc1-2f26-4656-aae6-7e1b2bbb1f50_TOSC_c094cf0d-a010-4bed-ae80-ef79a2a5a509_PLY_','2022-02-01 11:47:23','2019-07-11 13:34:49','0926c281-4a3b-4c7b-865f-5675c16be627.ply','2022-02-01 12:47:23','SYNCED','0926c281-4a3b-4c7b-865f-5675c16be627',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 40.1.1.1\",\"modelMatrix\":\"0.756185,-0.607693,0.242679,0,0.654357,0.702259,-0.280443,0,-3.89043e-9,0.370866,0.928686,0,6.44214,-42.93,-15.4868,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'09281a47-a438-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09281a47-a438-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_6c5d4194-c28f-4dc4-a836-110a650573fc_SESS_25a8e928-4efc-485b-85c9-f8544e3e5dce_BOSC_f4c7c824-11d2-467d-be2d-efc54d58916f_PLY_','2021-04-23 13:21:32','2021-04-23 15:21:28','09281a47-a438-11eb-9377-226cec7cb58a.ply','2021-04-23 15:21:32','SYNCED','09281a47-a438-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.96.1.1\",\"modelMatrix\":\"-0.866762,-0.492077,0.0811446,0,0.498722,-0.855212,0.141026,0,1.08645e-9,0.162705,0.986675,0,-22.4833,1.12447,-22.606,1\",\"title\":\"Mandibule PLY\"}'),(2,'0928565e-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0928565e-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_27ed9780-6a38-4d69-9839-e42c0698e136_PLY_','2020-12-16 11:06:01','2020-01-24 12:20:58','0928565e-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:01','SYNCED','0928565e-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.7\",\"modelMatrix\":\"0.698056,-0.652176,0.295609,0,0.716043,0.635793,-0.288183,0,-2.02374e-9,0.412837,0.910805,0,2.04657,-33.7628,-14.7611,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0928c2b6-ed22-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0928c2b6-ed22-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_8c048862-a41c-4126-bc34-483a4bba0079_SESS_142407e6-2e5d-465d-8654-844bd4956f1e_BOSC_d62ee36d-2300-41ea-8586-0e048de189bc_PLY_','2020-12-07 12:00:52','2020-09-02 15:40:37','0928c2b6-ed22-11ea-947d-226cec7cb58a.ply','2020-12-07 13:00:52','SYNCED','0928c2b6-ed22-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.26.66.1.2\",\"modelMatrix\":\"-0.928327,-0.357486,0.102045,0,0.371765,-0.89267,0.254815,0,-3.78501e-9,0.274489,0.96159,0,-23.3864,8.25848,-18.2315,1\",\"title\":\"Mandibule PLY\"}'),(2,'092a1409-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/092a1409-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_27ed9780-6a38-4d69-9839-e42c0698e136_SNAPS_','2020-12-16 11:06:01','2020-01-24 12:20:58','092a1409-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:01','SYNCED','092a1409-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.7\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'092bd013-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/092bd013-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_880ad313-09b0-46e2-864d-098e649dc55c_SNAPS_','2020-12-16 11:06:02','2020-01-24 12:06:05','092bd013-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:02','SYNCED','092bd013-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.2\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'092cdcf0-1044-468a-82ab-bb36c89570c9','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/092cdcf0-1044-468a-82ab-bb36c89570c9.stl','STL','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_db56cba1-23ff-48bf-b86e-4ceff749087f_BOSC_2ae10500-9760-472b-aee1-1fe00e33da53_STL_','2021-12-30 18:03:12','2019-11-14 16:13:51','092cdcf0-1044-468a-82ab-bb36c89570c9.stl','2021-12-30 19:03:12','SYNCED','092cdcf0-1044-468a-82ab-bb36c89570c9',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 202.1.1.2\",\"modelMatrix\":\"-0.997327,0.0686079,-0.0251209,0,-0.0730623,-0.936523,0.342909,0,-3.2719e-10,0.343828,0.939033,0,-17.3342,21.6229,-21.2219,1\",\"title\":\"MANDIBULE STL\"}'),(2,'092d687a-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/092d687a-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_6079dc2b-a3c3-468c-a7a3-54b4ec6bc8c2_SNAPS_','2020-12-16 11:06:02','2020-01-24 13:29:57','092d687a-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:02','SYNCED','092d687a-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'092e2255-a438-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/092e2255-a438-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_6c5d4194-c28f-4dc4-a836-110a650573fc_SESS_25a8e928-4efc-485b-85c9-f8544e3e5dce_TOSC_16ebd117-f410-4008-a168-17e349bef404_PLY_','2021-04-23 13:12:00','2021-04-23 15:11:58','092e2255-a438-11eb-9377-226cec7cb58a.ply','2021-04-23 15:12:00','SYNCED','092e2255-a438-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.96.1.2\",\"modelMatrix\":\"0.773754,-0.584822,0.243493,0,0.633487,0.714313,-0.297408,0,-2.04254e-9,0.38437,0.923179,0,6.19348,-35.3112,-14.1466,1\",\"title\":\"Maxillaire PLY\"}'),(2,'092f2e35-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/092f2e35-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_d49854df-257e-4070-b2e6-624cd798c324_PLY_','2020-12-16 11:06:02','2020-01-24 14:09:56','092f2e35-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:02','SYNCED','092f2e35-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.14\",\"modelMatrix\":\"-0.877455,0.455405,-0.150594,0,-0.479659,-0.833087,0.275487,0,-7.69801e-9,0.313962,0.949436,0,-12.6135,20.4154,-19.4439,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0930cb3c-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0930cb3c-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_4dd9e802-7e05-49b9-a508-4fb2c24adc7c_SNAPS_','2020-12-16 11:06:03','2020-01-24 13:10:47','0930cb3c-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:03','SYNCED','0930cb3c-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.15\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'09321dbf-f711-469b-ac19-f9f2582cf246','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09321dbf-f711-469b-ac19-f9f2582cf246.png','SNAPS','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_450bfdb1-08a7-4b1d-9f4c-85bffcfdfbb9_SESS_5b82df4c-23e7-4e3c-9e28-021571b7b493_TOSC_a8a681ba-b47d-4680-bfec-62efde273dfe_SNAPS_','2020-12-07 12:00:53','2020-08-14 10:32:55','09321dbf-f711-469b-ac19-f9f2582cf246.png','2020-12-07 13:00:53','SYNCED','09321dbf-f711-469b-ac19-f9f2582cf246',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.26.16.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0932a07b-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0932a07b-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_b21b9f7d-63e5-4a3f-b6d5-51109cd9e4b9_PLY_','2020-12-16 11:06:03','2020-01-24 12:11:17','0932a07b-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:03','SYNCED','0932a07b-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.4\",\"modelMatrix\":\"0.839685,-0.489853,0.234465,0,0.543074,0.757395,-0.362523,0,-1.05621e-8,0.431736,0.902,0,4.73178,-29.3929,-15.7552,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'09344ef2-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09344ef2-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_fbddb62c-dc01-42a6-a3ba-06432b6eae2e_PLY_','2020-12-16 11:06:03','2020-01-24 13:53:34','09344ef2-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:03','SYNCED','09344ef2-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.9\",\"modelMatrix\":\"-0.94086,0.336342,-0.0406949,0,-0.338795,-0.934048,0.113013,0,1.53005e-9,0.120117,0.99276,0,-6.00259,16.597,-18.5459,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'09348856-6f95-11eb-8b86-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09348856-6f95-11eb-8b86-226cec7cb58a.png','SNAPS','PATIENT_535a2cf4-1171-440b-8805-d93111a63349_ACT_1d498c24-dbfd-41c2-bc1e-234a77c6ff3a_SESS_275e74d1-81a2-4dfe-afc6-4398859514a7_BOSC_c2dc749f-6cc7-4c07-9eee-5fa39189ce02_SNAPS_','2021-02-15 13:52:27','2021-02-15 14:49:51','09348856-6f95-11eb-8b86-226cec7cb58a.png','2021-02-15 14:52:27','SYNCED','09348856-6f95-11eb-8b86-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.44.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0934ff37-eaf9-43d9-b2f9-992bd24ed7ad','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0934ff37-eaf9-43d9-b2f9-992bd24ed7ad.ply','PLY','PATIENT_7b440206-2418-40f8-88df-02a195f1bee3_ACT_5bb3cd77-ebd6-4519-ae80-4c7145b088e9_SESS_b5ba6d18-0c6f-4f4e-9bf4-ae02e03b1cc7_BOSC_19519ae8-6c7b-4728-9514-67633745e5c3_PLY_','2020-12-17 12:45:23','2020-12-17 13:42:08','0934ff37-eaf9-43d9-b2f9-992bd24ed7ad.ply','2020-12-17 13:45:23','SYNCED','0934ff37-eaf9-43d9-b2f9-992bd24ed7ad',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.43.1.1\",\"modelMatrix\":\"-0.949276,-0.307995,0.0633589,0,0.314445,-0.929806,0.191274,0,-3.08199e-9,0.201495,0.97949,0,-17.934,6.51587,-18.7282,1\",\"title\":\"Mandibule PLY\"}'),(2,'0936428c-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0936428c-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_6d7a38e4-c6c2-43e5-a6bc-969002959047_PLY_','2020-12-16 11:06:03','2020-01-24 13:20:22','0936428c-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:03','SYNCED','0936428c-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.18\",\"modelMatrix\":\"0.618528,-0.754039,0.221019,0,0.785763,0.593555,-0.173979,0,1.02333e-8,0.281279,0.959626,0,2.58563,-34.2137,-12.9019,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'09369cbc-a438-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09369cbc-a438-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_6c5d4194-c28f-4dc4-a836-110a650573fc_SESS_25a8e928-4efc-485b-85c9-f8544e3e5dce_TOSC_bafed43a-2694-4eca-bba7-c6461a70d989_SNAPS_','2021-04-23 13:09:02','2021-04-23 15:09:01','09369cbc-a438-11eb-9377-226cec7cb58a.png','2021-04-23 15:09:02','SYNCED','09369cbc-a438-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.96.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'093844e5-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/093844e5-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_999173f9-2453-4343-bad0-801edb58e455_SNAPS_','2020-12-16 11:06:04','2020-01-24 13:41:55','093844e5-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:04','SYNCED','093844e5-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.5\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0938d1cf-6f95-11eb-8b86-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0938d1cf-6f95-11eb-8b86-226cec7cb58a.ply','PLY','PATIENT_535a2cf4-1171-440b-8805-d93111a63349_ACT_1d498c24-dbfd-41c2-bc1e-234a77c6ff3a_SESS_275e74d1-81a2-4dfe-afc6-4398859514a7_TOSC_a593cbb8-a8d0-4075-8e68-9cdd36436732_PLY_','2021-02-15 13:52:27','2021-02-15 14:10:22','0938d1cf-6f95-11eb-8b86-226cec7cb58a.ply','2021-02-15 14:52:27','SYNCED','0938d1cf-6f95-11eb-8b86-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.44.1.3\",\"modelMatrix\":\"0.369541,-0.877143,0.306692,0,0.929215,0.348832,-0.121969,0,-4.72176e-9,0.330055,0.943962,0,-7.03379,-32.4071,-15.3988,1\",\"title\":\"Maxillaire PLY\"}'),(2,'093a26f8-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/093a26f8-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_6079dc2b-a3c3-468c-a7a3-54b4ec6bc8c2_PLY_','2020-12-16 11:06:04','2020-01-24 13:29:57','093a26f8-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:04','SYNCED','093a26f8-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.1\",\"modelMatrix\":\"-0.921683,0.3664,-0.127478,0,-0.387943,-0.870501,0.302866,0,-9.17098e-9,0.328601,0.944469,0,-3.80924,18.7754,-18.1748,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'093bd886-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/093bd886-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_999173f9-2453-4343-bad0-801edb58e455_PLY_','2020-12-16 11:06:04','2020-01-24 13:41:55','093bd886-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:04','SYNCED','093bd886-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.5\",\"modelMatrix\":\"-0.549516,0.829949,-0.0959998,0,-0.835483,-0.545876,0.0631412,0,3.52985e-9,0.114903,0.993377,0,5.74486,27.9373,-23.7628,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'093d76f1-a438-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/093d76f1-a438-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_6c5d4194-c28f-4dc4-a836-110a650573fc_SESS_25a8e928-4efc-485b-85c9-f8544e3e5dce_BOSC_82c8a946-d815-4fe4-83fd-233785afefa6_PLY_','2021-04-23 13:26:06','2021-04-23 15:26:05','093d76f1-a438-11eb-9377-226cec7cb58a.ply','2021-04-23 15:26:06','SYNCED','093d76f1-a438-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.96.1.2\",\"modelMatrix\":\"-0.569372,-0.799273,0.192298,0,0.82208,-0.553576,0.133186,0,-3.11333e-9,0.233917,0.972257,0,-21.5451,-13.5802,-20.5549,1\",\"title\":\"Mandibule PLY\"}'),(2,'093d8717-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/093d8717-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_fdb6ffdd-d519-4f22-9036-58453f3d05ae_SNAPS_','2020-12-16 11:06:04','2020-01-24 13:04:15','093d8717-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:04','SYNCED','093d8717-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.13\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'093f7734-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/093f7734-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_255dc983-95c1-4174-8ec2-30f7a6795843_PLY_','2020-12-16 11:06:04','2020-01-24 13:23:24','093f7734-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:04','SYNCED','093f7734-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.19\",\"modelMatrix\":\"0.803356,-0.549076,0.230511,0,0.5955,0.740728,-0.31097,0,2.29095e-8,0.387089,0.922042,0,7.5171,-32.5339,-14.9323,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'093fd03b-b0a7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/093fd03b-b0a7-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_a956d8cc-0010-4cd8-a41b-1273e5303ab7_SESS_1af6c295-df5e-445d-b07c-952827b78105_TOSC_8dccec77-694b-46e3-82dd-e9fb43e0eacd_PLY_','2020-12-08 17:26:19','2020-06-17 16:29:53','093fd03b-b0a7-11ea-947d-226cec7cb58a.ply','2020-12-08 18:26:19','SYNCED','093fd03b-b0a7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.57.1.3\",\"modelMatrix\":\"0.703843,-0.649845,0.286889,0,0.710355,0.643888,-0.284259,0,2.77769e-8,0.403867,0.914818,0,-0.0651417,-35.3856,-18.1424,1\",\"title\":\"Maxillaire PLY\"}'),(2,'09415b13-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09415b13-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_dd6db312-ea21-47ef-ad39-f6ecd63b9542_PLY_','2020-12-16 11:06:05','2020-01-24 12:25:57','09415b13-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:05','SYNCED','09415b13-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.9\",\"modelMatrix\":\"-0.244305,-0.931546,0.269328,0,0.969698,-0.234693,0.0678542,0,-4.37568e-9,0.277744,0.960655,0,-21.6114,-25.954,-15.8035,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0941b94d-a438-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0941b94d-a438-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_6c5d4194-c28f-4dc4-a836-110a650573fc_SESS_25a8e928-4efc-485b-85c9-f8544e3e5dce_BOSC_460bf072-2b17-42dd-8c01-5dfe115788d5_PLY_','2021-04-23 13:29:56','2021-04-23 15:29:55','0941b94d-a438-11eb-9377-226cec7cb58a.ply','2021-04-23 15:29:56','SYNCED','0941b94d-a438-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.96.1.3\",\"modelMatrix\":\"0.971945,-0.232698,0.0342557,0,0.235206,0.961582,-0.141555,0,9.02373e-10,0.145641,0.989337,0,8.23034,-18.9256,-25.9345,1\",\"title\":\"Mandibule PLY\"}'),(2,'0941f40f-b0a7-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0941f40f-b0a7-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_a956d8cc-0010-4cd8-a41b-1273e5303ab7_SESS_1af6c295-df5e-445d-b07c-952827b78105_TOSC_8dccec77-694b-46e3-82dd-e9fb43e0eacd_SNAPS_','2020-12-08 17:26:20','2020-06-17 16:29:53','0941f40f-b0a7-11ea-947d-226cec7cb58a.png','2020-12-08 18:26:20','SYNCED','0941f40f-b0a7-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.57.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0942f42b-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0942f42b-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_c907ff3b-bdf9-48e3-91f7-2a2cfde88396_PLY_','2020-12-16 11:06:05','2020-01-24 14:06:58','0942f42b-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:05','SYNCED','0942f42b-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.13\",\"modelMatrix\":\"-0.892631,0.441307,-0.0919626,0,-0.450787,-0.873859,0.182101,0,-3.08498e-9,0.204004,0.97897,0,-12.3901,24.0432,-16.9874,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0944ca68-f867-4678-a961-d55a16784c6a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0944ca68-f867-4678-a961-d55a16784c6a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_c1f60464-42d7-46e4-8357-6ba1a5d1fd90_SESS_94029fe2-e43d-47fc-ad49-a49f80ee7786_TOSC_3ece2766-7666-45ae-8695-5b6c1a33afd6_SNAPS_','2021-05-27 13:59:59','2021-05-27 15:59:57','0944ca68-f867-4678-a961-d55a16784c6a.png','2021-05-27 15:59:59','SYNCED','0944ca68-f867-4678-a961-d55a16784c6a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.158.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0944cf6f-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0944cf6f-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_9433adaa-ab6a-4e7d-98f6-a92b36da2982_PLY_','2020-12-16 11:06:05','2020-01-24 13:47:43','0944cf6f-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:05','SYNCED','0944cf6f-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.7\",\"modelMatrix\":\"-0.966309,0.237118,-0.100111,0,-0.257385,-0.890219,0.37585,0,1.04382e-8,0.388954,0.921257,0,-10.9841,12.471,-21.7873,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0944fbb4-a438-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0944fbb4-a438-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_6c5d4194-c28f-4dc4-a836-110a650573fc_SESS_25a8e928-4efc-485b-85c9-f8544e3e5dce_BOSC_82c8a946-d815-4fe4-83fd-233785afefa6_SNAPS_','2021-04-23 13:26:06','2021-04-23 15:26:05','0944fbb4-a438-11eb-9377-226cec7cb58a.png','2021-04-23 15:26:06','SYNCED','0944fbb4-a438-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.96.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0946e20a-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0946e20a-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_bdc35573-704d-4584-86aa-734054708738_PLY_','2020-12-16 11:06:05','2020-01-24 12:13:30','0946e20a-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:05','SYNCED','0946e20a-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.5\",\"modelMatrix\":\"0.772204,-0.598445,0.213456,0,0.635374,0.727323,-0.259424,0,-5.82845e-9,0.335953,0.941879,0,4.92343,-32.8078,-12.8591,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0948b512-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0948b512-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_fdb6ffdd-d519-4f22-9036-58453f3d05ae_PLY_','2020-12-16 11:06:05','2020-01-24 13:04:15','0948b512-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:05','SYNCED','0948b512-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.13\",\"modelMatrix\":\"0.764589,-0.559255,0.320371,0,0.644518,0.663442,-0.380055,0,-2.27391e-9,0.497071,0.86771,0,4.60887,-31.9303,-15.34,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'094a266f-927f-4e53-b102-25279975c706','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/094a266f-927f-4e53-b102-25279975c706.ply','PLY','PATIENT_491f6fac-4e7b-45ff-853c-c5880019fa93_ACT_61c527a3-56f3-4776-8cbd-02a3124364d4_SESS_ccd013fe-71ee-415b-8735-209f53c9eeeb_TOSC_2e529730-4636-492e-a5f1-a7aafffe05fd_PLY_','2021-01-26 14:45:36','2021-01-26 15:23:54','094a266f-927f-4e53-b102-25279975c706.ply','2021-01-26 15:45:36','SYNCED','094a266f-927f-4e53-b102-25279975c706',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.24.1.3\",\"modelMatrix\":\"0.508097,-0.801019,0.316553,0,0.8613,0.472536,-0.18674,0,4.95098e-9,0.367529,0.930012,0,-4.68743,-34.1847,-16.3807,1\",\"title\":\"Maxillaire PLY\"}'),(2,'094a6077-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/094a6077-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_b21b9f7d-63e5-4a3f-b6d5-51109cd9e4b9_SNAPS_','2020-12-16 11:06:06','2020-01-24 12:11:17','094a6077-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:06','SYNCED','094a6077-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.4\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'094bfe24-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/094bfe24-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_c907ff3b-bdf9-48e3-91f7-2a2cfde88396_SNAPS_','2020-12-16 11:06:06','2020-01-24 14:06:58','094bfe24-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:06','SYNCED','094bfe24-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.13\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'094e4cdd-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/094e4cdd-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_f97f8ae6-f86e-4501-9828-8fcb5cddd959_PLY_','2020-12-16 11:06:06','2020-01-24 13:35:51','094e4cdd-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:06','SYNCED','094e4cdd-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.3\",\"modelMatrix\":\"-0.980712,0.185973,-0.0601507,0,-0.195459,-0.933118,0.301806,0,2.10146e-9,0.307741,0.95147,0,-13.392,16.0456,-15.9342,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'094f6f67-b060-45f9-9d74-a0c2eb67b6e1','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/094f6f67-b060-45f9-9d74-a0c2eb67b6e1.png','SNAPS','PATIENT_2e0a8247-f698-45b5-87fe-8b1e7c952f36_ACT_a433fe53-88db-42f4-8f67-6c6d2488c283_SESS_cfc8f487-d196-4456-8530-e036a0501e0b_TOSC_5771ac38-285d-44d7-b478-eca9dbea9066_SNAPS_','2020-12-02 10:32:16','2020-10-30 10:56:44','094f6f67-b060-45f9-9d74-a0c2eb67b6e1.png','2020-12-02 11:32:16','SYNCED','094f6f67-b060-45f9-9d74-a0c2eb67b6e1',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.35.12.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0950087f-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0950087f-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_9433adaa-ab6a-4e7d-98f6-a92b36da2982_SNAPS_','2020-12-16 11:06:06','2020-01-24 13:47:43','0950087f-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:06','SYNCED','0950087f-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.7\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'09520c54-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09520c54-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_1ce67bad-2826-4e28-bcd1-486703f20e5a_PLY_','2020-12-16 11:06:07','2020-01-24 13:38:51','09520c54-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:07','SYNCED','09520c54-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.4\",\"modelMatrix\":\"-0.939122,0.329617,-0.0969661,0,-0.343583,-0.900947,0.265039,0,8.3637e-10,0.28222,0.95935,0,-13.935,19.2088,-19.8511,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0952ebf3-af37-4b19-805f-7c04d43ccb4f','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0952ebf3-af37-4b19-805f-7c04d43ccb4f.stl','STL','PATIENT_8fa2891d-7bba-4605-bf05-54a276fd00f4_ACT_16441b00-310c-4cfa-bf2b-0ab01025332e_SESS_feeefb5e-69b6-4e19-ac4c-f3518e1a16dd_BOSC_96402078-5732-47ce-ad74-262452997f01_STL_','2022-02-01 11:47:23','2019-08-01 15:34:42','0952ebf3-af37-4b19-805f-7c04d43ccb4f.stl','2022-02-01 12:47:23','SYNCED','0952ebf3-af37-4b19-805f-7c04d43ccb4f',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 122.1.1.1\",\"modelMatrix\":\"-0.638379,0.767866,-0.0534277,0,-0.769722,-0.63684,0.044311,0,3.01333e-9,0.0694117,0.997588,0,1.05865,23.8827,-24.4654,1\",\"title\":\"MANDIBULE STL\"}'),(2,'0953c13d-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0953c13d-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_e44fbbcb-7ace-4649-8a05-a692408f5313_PLY_','2020-12-16 11:06:07','2020-01-24 12:28:27','0953c13d-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:07','SYNCED','0953c13d-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.10\",\"modelMatrix\":\"0.646919,-0.714202,0.26723,0,0.762559,0.605895,-0.226705,0,-4.91168e-9,0.350438,0.936586,0,1.79064,-37.1221,-11.862,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'09557735-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09557735-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_7ae48595-66f5-4167-ac7e-1725a9a86df3_PLY_','2020-12-16 11:06:07','2020-01-24 12:57:34','09557735-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:07','SYNCED','09557735-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.11\",\"modelMatrix\":\"0.436917,-0.872535,0.218601,0,0.899502,0.423818,-0.106181,0,-4.25041e-9,0.243024,0.97002,0,-7.36178,-38.4439,-10.849,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'095728e9-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/095728e9-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_c3e53fec-023d-4ec4-b5c4-43c4206d722c_SNAPS_','2020-12-16 11:06:07','2020-01-24 12:18:40','095728e9-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:07','SYNCED','095728e9-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.6\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0958c554-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0958c554-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_575489f2-70fd-4452-b245-51aee46eaf3b_PLY_','2020-12-16 11:06:08','2020-01-24 13:16:59','0958c554-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:08','SYNCED','0958c554-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.17\",\"modelMatrix\":\"0.636562,-0.748708,0.185003,0,0.771226,0.617976,-0.152699,0,9.10946e-9,0.239881,0.970802,0,1.80356,-35.1325,-15.6973,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'095c0a90-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/095c0a90-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_f248a996-fb72-4dfc-8d99-73472d18b95f_PLY_','2020-12-16 11:06:08','2020-01-24 14:12:44','095c0a90-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:08','SYNCED','095c0a90-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.15\",\"modelMatrix\":\"-0.872558,0.487073,-0.0374617,0,-0.488511,-0.869988,0.0669125,0,-3.04951e-9,0.0766855,0.997055,0,1.41659,15.9367,-23.17,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'095dd9ea-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/095dd9ea-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_7e31dc23-e958-4dce-a295-bc79e0259c7b_PLY_','2020-12-16 11:06:08','2020-01-24 14:15:19','095dd9ea-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:08','SYNCED','095dd9ea-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.16\",\"modelMatrix\":\"-0.819033,0.555924,-0.141893,0,-0.573747,-0.793591,0.202555,0,-4.53486e-9,0.24731,0.968936,0,-5.34247,26.0523,-15.7637,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'096001a3-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/096001a3-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_ecd07bc0-5a3c-4525-8dfe-74f5499a2099_SNAPS_','2020-12-16 11:06:08','2020-01-24 13:56:20','096001a3-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:08','SYNCED','096001a3-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.10\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'096201c1-e81c-416e-8cee-b2c9c0233d87','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/096201c1-e81c-416e-8cee-b2c9c0233d87.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_29fe1a4b-29de-45a5-b47c-01ce55f37ac2_SESS_47bd7b30-9506-4273-9771-aca249d894a1_TOSC_7ea1bc33-d4cc-48c0-b69b-f894c9a09217_SNAPS_','2021-10-11 09:55:47','2021-10-11 11:55:42','096201c1-e81c-416e-8cee-b2c9c0233d87.png','2021-10-11 11:55:47','SYNCED','096201c1-e81c-416e-8cee-b2c9c0233d87',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.196.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'09621771-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09621771-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_f02f8b98-ed67-4fe5-8f44-8cbdfc993303_SNAPS_','2020-12-16 11:06:09','2020-01-24 14:33:28','09621771-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:09','SYNCED','09621771-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.19\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'09646cb4-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09646cb4-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_4eecda62-fb52-471f-9f18-1a2492b214fc_SNAPS_','2020-12-16 11:06:09','2020-01-24 13:07:18','09646cb4-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:09','SYNCED','09646cb4-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.14\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'09667d16-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09667d16-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_571cb779-07f1-4b4a-b54a-afe301c423c4_SNAPS_','2020-12-16 11:06:09','2020-01-24 12:01:54','09667d16-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:09','SYNCED','09667d16-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'09687a38-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09687a38-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_53dc197c-f7a3-4a3b-bc99-114403c3dab5_SNAPS_','2020-12-16 11:06:09','2020-01-24 13:13:27','09687a38-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:09','SYNCED','09687a38-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.16\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'096a453b-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/096a453b-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_bdc35573-704d-4584-86aa-734054708738_SNAPS_','2020-12-16 11:06:09','2020-01-24 12:13:30','096a453b-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:09','SYNCED','096a453b-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.5\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'096be345-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/096be345-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_1ce67bad-2826-4e28-bcd1-486703f20e5a_SNAPS_','2020-12-16 11:06:10','2020-01-24 13:38:51','096be345-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:10','SYNCED','096be345-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.4\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'096d7d36-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/096d7d36-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_27f590bb-6f49-467c-bd68-6ffb3b5b8066_SNAPS_','2020-12-16 11:06:10','2020-01-24 13:59:00','096d7d36-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:10','SYNCED','096d7d36-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.11\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'096dc0ac-b505-4611-8485-8995b123a6c7','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/096dc0ac-b505-4611-8485-8995b123a6c7.ply','PLY','PATIENT_bc50bff3-dacb-4f7a-a7c8-b971782c6d1d_ACT_be5de36f-b43d-47f3-b178-801c7822bb7d_SESS_df767eeb-30cd-456e-91c0-aa5269ac29d4_TOSC_53a2bf92-5fc4-4a57-94e3-611738da6165_PLY_','2021-08-05 07:30:49','2019-11-27 11:58:23','096dc0ac-b505-4611-8485-8995b123a6c7.ply','2021-08-05 09:30:49','SYNCED','096dc0ac-b505-4611-8485-8995b123a6c7',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 212.1.1.1\",\"modelMatrix\":\"0.456078,-0.842561,0.286504,0,0.88994,0.431797,-0.146828,0,3.98182e-9,0.321936,0.946761,0,-7.04778,-36.9499,-18.3322,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'096f3115-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/096f3115-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_4eecda62-fb52-471f-9f18-1a2492b214fc_PLY_','2020-12-16 11:06:10','2020-01-24 13:07:18','096f3115-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:10','SYNCED','096f3115-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.14\",\"modelMatrix\":\"0.312532,-0.914912,0.25546,0,0.949907,0.301018,-0.0840496,0,-3.17512e-9,0.268932,0.963159,0,-11.048,-35.2208,-13.1547,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0970a26e-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0970a26e-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_ecd07bc0-5a3c-4525-8dfe-74f5499a2099_PLY_','2020-12-16 11:06:10','2020-01-24 13:56:20','0970a26e-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:10','SYNCED','0970a26e-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.10\",\"modelMatrix\":\"-0.982085,0.182693,-0.0461722,0,-0.188437,-0.952148,0.240637,0,-1.51594e-9,0.245027,0.969516,0,-9.41129,20.9673,-17.7008,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0972b6fc-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0972b6fc-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_cf7510f6-bfb5-4e90-af14-79e2643fc837_PLY_','2020-12-16 11:06:11','2020-01-24 13:50:45','0972b6fc-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:11','SYNCED','0972b6fc-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.8\",\"modelMatrix\":\"-0.923862,0.371489,-0.092063,0,-0.382726,-0.896735,0.222231,0,3.17344e-9,0.240545,0.970638,0,-10.9376,19.3585,-14.9569,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'09740696-c62b-4a87-bdbd-9188ce22702d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09740696-c62b-4a87-bdbd-9188ce22702d.ply','PLY','PATIENT_3243881f-6187-468b-b049-6f86e8fe403c_ACT_0ab405cb-3901-4eb7-8b5a-6e292c293888_SESS_8f034154-5a36-4a74-b2b8-e5eb50522190_BOSC_1964c8af-cfac-4e9c-a219-9b2660680dad_PLY_','2020-12-15 12:48:50','2020-12-15 13:48:50','09740696-c62b-4a87-bdbd-9188ce22702d.ply','2020-12-15 13:48:50','SYNCED','09740696-c62b-4a87-bdbd-9188ce22702d',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.37.1.1\",\"modelMatrix\":\"-0.852329,0.506403,-0.130734,0,-0.523006,-0.825272,0.213053,0,-7.10202e-9,0.249966,0.968255,0,-8.64532,21.2331,-18.5317,1\",\"title\":\"Mandibule PLY\"}'),(2,'097417ba-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/097417ba-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_53dc197c-f7a3-4a3b-bc99-114403c3dab5_PLY_','2020-12-16 11:06:11','2020-01-24 13:13:27','097417ba-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:11','SYNCED','097417ba-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.16\",\"modelMatrix\":\"0.607836,-0.756955,0.239906,0,0.794063,0.579431,-0.183642,0,-6.20592e-9,0.302125,0.953268,0,-1.1237,-37.4176,-9.48596,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0975da4c-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0975da4c-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_f248a996-fb72-4dfc-8d99-73472d18b95f_SNAPS_','2020-12-16 11:06:11','2020-01-24 14:12:44','0975da4c-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:11','SYNCED','0975da4c-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.15\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'09779c3e-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09779c3e-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_10e00968-b057-4488-9fbb-ab792652fb58_PLY_','2020-12-16 11:06:11','2020-01-24 13:00:37','09779c3e-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:11','SYNCED','09779c3e-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.12\",\"modelMatrix\":\"0.700054,-0.65545,0.283389,0,0.71409,0.642567,-0.277819,0,2.01743e-8,0.396853,0.917882,0,5.2451,-33.7225,-14.8914,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'09791f82-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09791f82-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_7ae48595-66f5-4167-ac7e-1725a9a86df3_SNAPS_','2020-12-16 11:06:11','2020-01-24 12:57:34','09791f82-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:11','SYNCED','09791f82-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.11\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'097ad9a0-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/097ad9a0-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_6d7a38e4-c6c2-43e5-a6bc-969002959047_SNAPS_','2020-12-16 11:06:12','2020-01-24 13:20:22','097ad9a0-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:12','SYNCED','097ad9a0-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.18\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'097b804e-b805-4a0a-b908-fb135aa3c776','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/097b804e-b805-4a0a-b908-fb135aa3c776.png','SNAPS','PATIENT_2b864ce0-3cc8-4b80-969d-f9b27f99086e_ACT_17d544b7-b276-47e6-81d5-535312f6ff69_SESS_ab2dadf7-83a6-4b5b-bf14-291c389c43be_TOSC_27584331-5553-42cf-bbc0-5510faa74c16_SNAPS_','2021-12-30 18:03:15','2019-10-17 11:40:31','097b804e-b805-4a0a-b908-fb135aa3c776.png','2021-12-30 19:03:15','SYNCED','097b804e-b805-4a0a-b908-fb135aa3c776',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 189.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'097c5092-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/097c5092-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_b70478b1-5f48-4ae4-a41f-d5061b66be45_PLY_','2020-12-16 11:06:12','2020-01-24 13:27:05','097c5092-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:12','SYNCED','097c5092-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.20\",\"modelMatrix\":\"0.71648,-0.659174,0.228357,0,0.697608,0.677006,-0.234535,0,7.74296e-9,0.327343,0.944906,0,3.01042,-33.152,-13.3403,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'097df11d-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/097df11d-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_c3e53fec-023d-4ec4-b5c4-43c4206d722c_PLY_','2020-12-16 11:06:12','2020-01-24 12:18:40','097df11d-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:12','SYNCED','097df11d-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.6\",\"modelMatrix\":\"0.851157,-0.445757,0.277187,0,0.524912,0.722806,-0.449465,0,1.36924e-9,0.528063,0.849205,0,11.5637,-29.0554,-17.1155,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'097fa696-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/097fa696-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_b70478b1-5f48-4ae4-a41f-d5061b66be45_SNAPS_','2020-12-16 11:06:13','2020-01-24 13:27:05','097fa696-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:13','SYNCED','097fa696-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.20\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'09816a9e-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09816a9e-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_880ad313-09b0-46e2-864d-098e649dc55c_PLY_','2020-12-16 11:06:13','2020-01-24 12:06:05','09816a9e-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:13','SYNCED','09816a9e-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.2\",\"modelMatrix\":\"0.791241,-0.576961,0.202615,0,0.611504,0.746545,-0.262169,0,-1.22118e-8,0.331339,0.943512,0,5.50772,-30.857,-10.9295,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'098348a8-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/098348a8-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_a838ef29-02aa-4db9-944e-273b898e0f4b_SNAPS_','2020-12-16 11:06:13','2020-01-24 14:27:27','098348a8-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:13','SYNCED','098348a8-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.18\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0984dffe-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0984dffe-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_27f590bb-6f49-467c-bd68-6ffb3b5b8066_PLY_','2020-12-16 11:06:13','2020-01-24 13:59:00','0984dffe-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:13','SYNCED','0984dffe-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.11\",\"modelMatrix\":\"-0.712164,0.694418,-0.102987,0,-0.702013,-0.704459,0.104476,0,7.40534e-9,0.146702,0.989181,0,4.66919,16.09,-17.0977,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0986a467-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0986a467-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_255dc983-95c1-4174-8ec2-30f7a6795843_SNAPS_','2020-12-16 11:06:14','2020-01-24 13:23:24','0986a467-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:14','SYNCED','0986a467-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.19\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0987655b-bbdc-4dcf-b967-dcd27e73c400','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0987655b-bbdc-4dcf-b967-dcd27e73c400.ply','PLY','PATIENT_5fd84c90-9973-4c06-abf0-2b0c76fc777b_ACT_ea84379f-205b-43ad-9618-5ba5d8b6452b_SESS_c742703f-9c2f-4bf4-9514-b3f3a86c4d38_BOSC_f3ebb32d-b2da-4049-a073-b7bc7f16ff40_PLY_','2021-02-10 08:31:13','2021-02-10 09:25:41','0987655b-bbdc-4dcf-b967-dcd27e73c400.ply','2021-02-10 09:31:13','SYNCED','0987655b-bbdc-4dcf-b967-dcd27e73c400',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.35.1.1\",\"modelMatrix\":\"-0.849148,-0.525392,0.0539507,0,0.528155,-0.844706,0.0867399,0,1.38068e-9,0.102149,0.994769,0,-20.4372,4.33061,-19.8803,1\",\"title\":\"Mandibule PLY\"}'),(2,'09893c2a-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09893c2a-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_571cb779-07f1-4b4a-b54a-afe301c423c4_PLY_','2020-12-16 11:06:14','2020-01-24 12:01:54','09893c2a-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:14','SYNCED','09893c2a-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.1\",\"modelMatrix\":\"0.302959,-0.9422,0.143095,0,0.953004,0.299524,-0.0454898,0,1.70815e-9,0.150152,0.988663,0,-12.5834,-25.8801,-16.6298,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'098c5bca-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/098c5bca-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_f97f8ae6-f86e-4501-9828-8fcb5cddd959_SNAPS_','2020-12-16 11:06:14','2020-01-24 13:35:51','098c5bca-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:14','SYNCED','098c5bca-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.3\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'098c6de3-96e0-4f8e-b3df-272543748f8d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/098c6de3-96e0-4f8e-b3df-272543748f8d.ply','PLY','PATIENT_373ac25e-dd7b-4c18-a1aa-b0e7ff6cd2ac_ACT_a72bddb8-cde0-49e8-86bc-f0cb9ca3574a_SESS_220f1c73-4b99-47ba-b3a7-861726336458_BOSC_753fec4a-a114-4a80-af2f-9e5a55be2bbb_PLY_','2021-03-26 14:49:35','2021-03-26 15:43:04','098c6de3-96e0-4f8e-b3df-272543748f8d.ply','2021-03-26 15:49:35','SYNCED','098c6de3-96e0-4f8e-b3df-272543748f8d',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.6.1.2\",\"modelMatrix\":\"-0.860651,-0.471554,0.192136,0,0.509195,-0.797029,0.324752,0,-9.66776e-9,0.377333,0.926078,0,-20.5634,-2.44243,-22.3333,1\",\"title\":\"Mandibule PLY\"}'),(2,'098e9e41-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/098e9e41-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_f02f8b98-ed67-4fe5-8f44-8cbdfc993303_PLY_','2020-12-16 11:06:14','2020-01-24 14:33:28','098e9e41-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:14','SYNCED','098e9e41-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.19\",\"modelMatrix\":\"-0.934629,0.347969,-0.0733966,0,-0.355625,-0.914506,0.192896,0,5.37018e-9,0.206388,0.97847,0,-3.99166,21.7512,-15.2256,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'098f7f0e-7ad3-4782-9052-ccf5225e8d82','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/098f7f0e-7ad3-4782-9052-ccf5225e8d82.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_9a9432ed-3d6c-435f-ac9d-9b00f454c491_SESS_4e7c04b1-5224-4747-97db-a99a763e441f_TOSC_2cee6b9b-252b-43e7-8b88-64e9ef3243a1_SNAPS_','2021-10-14 11:46:55','2021-10-14 13:46:51','098f7f0e-7ad3-4782-9052-ccf5225e8d82.png','2021-10-14 13:46:55','SYNCED','098f7f0e-7ad3-4782-9052-ccf5225e8d82',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.201.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0990c612-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0990c612-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_fbddb62c-dc01-42a6-a3ba-06432b6eae2e_SNAPS_','2020-12-16 11:06:14','2020-01-24 13:53:34','0990c612-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:14','SYNCED','0990c612-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.9\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'099288c7-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/099288c7-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_34b02c4d-5fa9-4b9d-98b4-48d85a686fde_PLY_','2020-12-16 11:06:15','2020-01-24 12:23:27','099288c7-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:15','SYNCED','099288c7-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.8\",\"modelMatrix\":\"0.783445,-0.550086,0.289171,0,0.621462,0.693465,-0.364543,0,-2.17087e-8,0.465308,0.885149,0,0.758246,-31.3396,-14.8588,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0994a9b1-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0994a9b1-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_4dd9e802-7e05-49b9-a508-4fb2c24adc7c_PLY_','2020-12-16 11:06:15','2020-01-24 13:10:47','0994a9b1-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:15','SYNCED','0994a9b1-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.15\",\"modelMatrix\":\"0.787294,-0.562412,0.252708,0,0.616578,0.71813,-0.322677,0,-1.88464e-9,0.409856,0.91215,0,6.51226,-30.0623,-19.6356,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0996b175-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0996b175-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_dd6db312-ea21-47ef-ad39-f6ecd63b9542_SNAPS_','2020-12-16 11:06:15','2020-01-24 12:25:57','0996b175-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:15','SYNCED','0996b175-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.9\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'099875c6-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/099875c6-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_34b02c4d-5fa9-4b9d-98b4-48d85a686fde_SNAPS_','2020-12-16 11:06:15','2020-01-24 12:23:27','099875c6-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:15','SYNCED','099875c6-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.8\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'099a65e4-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/099a65e4-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_2bed089e-68c3-431b-99b5-222a86530979_SNAPS_','2020-12-16 11:06:16','2020-01-24 14:18:24','099a65e4-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:16','SYNCED','099a65e4-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.17\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'099c61b0-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/099c61b0-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_ded13e4f-345b-4d5a-a99e-d24ba3e66dda_SNAPS_','2020-12-16 11:06:16','2020-01-24 12:08:35','099c61b0-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:16','SYNCED','099c61b0-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.3\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'099e3158-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/099e3158-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_a838ef29-02aa-4db9-944e-273b898e0f4b_PLY_','2020-12-16 11:06:16','2020-01-24 14:27:27','099e3158-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:16','SYNCED','099e3158-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.18\",\"modelMatrix\":\"-0.955862,0.253688,-0.148222,0,-0.293815,-0.825318,0.482206,0,2.27161e-9,0.504473,0.863428,0,-15.0526,11.7182,-21.373,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'099ee61d-5ad2-49e4-a657-b874c095f1cf','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/099ee61d-5ad2-49e4-a657-b874c095f1cf.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_a5b3ced1-6ef9-4401-91c8-24befcfc9e27_SESS_69f1f3c6-3d25-466b-858e-18b1df634705_TOSC_8e8ab948-ca37-4825-87a4-a48d4bd02547_SNAPS_','2022-01-18 13:50:00','2022-01-18 14:49:54','099ee61d-5ad2-49e4-a657-b874c095f1cf.png','2022-01-18 14:50:00','SYNCED','099ee61d-5ad2-49e4-a657-b874c095f1cf',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.15.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'099ff65f-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/099ff65f-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_8f0d3062-1121-4e4e-b9ed-921f4dc3427f_SNAPS_','2020-12-16 11:06:16','2020-01-24 13:44:39','099ff65f-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:16','SYNCED','099ff65f-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.6\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'09a1b3ca-efc8-4db6-a80f-6b48053e95ae','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09a1b3ca-efc8-4db6-a80f-6b48053e95ae.png','SNAPS','PATIENT_2e0a8247-f698-45b5-87fe-8b1e7c952f36_ACT_9de12ccb-56c6-44f8-9eb2-442a8ab403b9_SESS_ee60d82c-90a6-4dd2-b5b3-5e5ba64c79ca_BOSC_0466f45c-9e19-4f9c-bc42-8922b71bb216_SNAPS_','2020-12-02 10:32:22','2020-11-05 16:48:30','09a1b3ca-efc8-4db6-a80f-6b48053e95ae.png','2020-12-02 11:32:22','SYNCED','09a1b3ca-efc8-4db6-a80f-6b48053e95ae',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.35.14.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'09a1e7b2-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09a1e7b2-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_575489f2-70fd-4452-b245-51aee46eaf3b_SNAPS_','2020-12-16 11:06:17','2020-01-24 13:16:59','09a1e7b2-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:17','SYNCED','09a1e7b2-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.17\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'09a3e6ca-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09a3e6ca-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_a7d50cc0-3fca-4680-bdad-29b328f5b62a_SNAPS_','2020-12-16 11:06:17','2020-01-24 14:39:39','09a3e6ca-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:17','SYNCED','09a3e6ca-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.20\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'09a610e3-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09a610e3-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_TOSC_10e00968-b057-4488-9fbb-ab792652fb58_SNAPS_','2020-12-16 11:06:17','2020-01-24 13:00:37','09a610e3-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:17','SYNCED','09a610e3-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.61.1.1.12\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'09a8210e-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09a8210e-3eaf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_d49854df-257e-4070-b2e6-624cd798c324_SNAPS_','2020-12-16 11:06:17','2020-01-24 14:09:56','09a8210e-3eaf-11ea-947d-226cec7cb58a.png','2020-12-16 12:06:17','SYNCED','09a8210e-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.14\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'09aa4b30-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09aa4b30-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_a652bfa0-2f48-4a5c-baee-0b1742d0f575_PLY_','2020-12-16 11:06:18','2020-01-24 13:33:07','09aa4b30-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:18','SYNCED','09aa4b30-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.2\",\"modelMatrix\":\"-0.795971,0.604782,-0.0258706,0,-0.605335,-0.795243,0.0340179,0,-1.94414e-9,0.0427376,0.999086,0,-1.93611,20.8759,-18.0257,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'09ac61d4-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09ac61d4-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_a7d50cc0-3fca-4680-bdad-29b328f5b62a_PLY_','2020-12-16 11:06:18','2020-01-24 14:39:39','09ac61d4-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:18','SYNCED','09ac61d4-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.20\",\"modelMatrix\":\"-0.778745,0.624547,-0.0591346,0,-0.62734,-0.775278,0.0734063,0,-3.70358e-9,0.0942623,0.995547,0,0.709204,23.0661,-18.9816,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'09ae5421-3eaf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09ae5421-3eaf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_abfa29ed-6ab0-4bc3-bba5-0eb65b7afeb5_PLY_','2020-12-16 11:06:18','2020-01-24 14:02:24','09ae5421-3eaf-11ea-947d-226cec7cb58a.ply','2020-12-16 12:06:18','SYNCED','09ae5421-3eaf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.12\",\"modelMatrix\":\"-0.464623,0.882387,-0.0742891,0,-0.885508,-0.462985,0.0389793,0,-2.99715e-9,0.0838943,0.996475,0,4.71474,15.989,-23.0544,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'09b38a97-cae3-4f8c-9985-94559da6c4da','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09b38a97-cae3-4f8c-9985-94559da6c4da.png','SNAPS','PATIENT_e6cb123a-be87-4228-97b3-06d5473ed349_ACT_99e7b9d4-2a93-4741-8341-cb9c68abefa5_SESS_caf7693c-1b52-401d-830a-1bf478ab6c0c_TOSC_96e4357a-6c6d-444f-822c-5d8dcc74e000_SNAPS_','2020-12-08 17:26:40','2020-06-18 09:44:18','09b38a97-cae3-4f8c-9985-94559da6c4da.png','2020-12-08 18:26:40','SYNCED','09b38a97-cae3-4f8c-9985-94559da6c4da',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.62.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'09b474c4-ec01-4d13-aadc-ffa1c5c46525','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09b474c4-ec01-4d13-aadc-ffa1c5c46525.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_e96b1c26-a3f9-441c-9c71-ab866b5a8ca6_SESS_3d88b948-c120-4ba9-b403-4ed3513d3c34_BOSC_66428b71-4828-41db-8a07-c4924a837aea_PLY_','2020-12-08 17:26:40','2020-06-23 10:02:56','09b474c4-ec01-4d13-aadc-ffa1c5c46525.ply','2020-12-08 18:26:40','SYNCED','09b474c4-ec01-4d13-aadc-ffa1c5c46525',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.71.1.1\",\"modelMatrix\":\"-0.891047,0.449551,-0.0627607,0,-0.453911,-0.882489,0.123202,0,-9.60683e-10,0.138267,0.990395,0,-3.37018,17.8377,-15.9218,1\",\"title\":\"Mandibule PLY\"}'),(2,'09b79c8d-68bd-4b99-8e34-1a218553e3fc','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09b79c8d-68bd-4b99-8e34-1a218553e3fc.ply','PLY','PATIENT_2e96b047-789a-4c40-9501-4fcae191cc7e_ACT_cda50aaf-54ba-4d75-bfa1-6b9506445a20_SESS_201e32b7-d790-47ae-95b1-f7d8437c1d49_TOSC_1b9c1daf-2b69-4cf2-bac9-1384add7efa8_PLY_','2020-12-16 11:06:18','2020-01-28 17:20:24','09b79c8d-68bd-4b99-8e34-1a218553e3fc.ply','2020-12-16 12:06:18','SYNCED','09b79c8d-68bd-4b99-8e34-1a218553e3fc',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 96.1.1.1.1\",\"modelMatrix\":\"0.782286,-0.579533,0.228408,0,0.622919,0.7278,-0.286844,0,1.04789e-9,0.366674,0.930349,0,6.67217,-34.335,-18.3093,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'09c0561f-ef97-46e8-a16d-67acd8fabff9','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09c0561f-ef97-46e8-a16d-67acd8fabff9.ply','PLY','PATIENT_3ba502e6-1fd1-40ed-8e72-2db58e8c52bb_ACT_3fe362dd-8dec-45e9-82f6-ba7e5bba15b4_SESS_fa9df930-628e-466c-8173-ef75f35ce9d9_BOSC_39cf2235-0bac-4fb9-a1b1-9d161e2be905_PLY_','2020-12-02 10:32:23','2020-10-21 14:42:34','09c0561f-ef97-46e8-a16d-67acd8fabff9.ply','2020-12-02 11:32:23','SYNCED','09c0561f-ef97-46e8-a16d-67acd8fabff9',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.33.1.1\",\"modelMatrix\":\"-0.975594,0.207519,-0.0717808,0,-0.219582,-0.921995,0.318919,0,-3.00641e-9,0.326897,0.94506,0,-11.8421,19.1294,-15.4341,1\",\"title\":\"Mandibule PLY\"}'),(2,'09ca79ed-f088-4581-af0b-13553fdbdbef','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09ca79ed-f088-4581-af0b-13553fdbdbef.png','SNAPS','PATIENT_e065ef95-3928-430d-bee5-6cc04ce694eb_ACT_cba674c5-f014-4236-9422-427c7b90639e_SESS_1a4f017f-94d2-4f46-8e86-4d9759e2bb66_BOSC_bdeb509b-1ff7-4e0f-a40f-7ad0fb9f48b1_SNAPS_','2020-12-07 12:01:06','2020-08-20 09:55:25','09ca79ed-f088-4581-af0b-13553fdbdbef.png','2020-12-07 13:01:06','SYNCED','09ca79ed-f088-4581-af0b-13553fdbdbef',0,NULL,'','','{\"displayTitle\":\"Mandibule 61.1.15.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'09d23dc0-e61a-4ce0-9838-02a5aec9ff59','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09d23dc0-e61a-4ce0-9838-02a5aec9ff59.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_14a18b73-9cb7-4d14-a69a-f71e0a316c16_SESS_aef76ead-c4ff-48ca-9f5f-ac9ca36a1096_TOSC_c968557a-0174-4fb5-915b-9b0563789eac_SNAPS_','2022-03-31 07:52:22','2022-03-31 09:52:18','09d23dc0-e61a-4ce0-9838-02a5aec9ff59.png','2022-03-31 09:52:22','SYNCED','09d23dc0-e61a-4ce0-9838-02a5aec9ff59',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.48.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'09d9cf2b-e21d-4fc0-9b75-e824d4413f92','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09d9cf2b-e21d-4fc0-9b75-e824d4413f92.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_e00b14aa-32a6-4999-a249-2004f9d70bc8_SESS_7d7ec1e6-7a80-4456-a949-5e8c50c562f0_TOSC_eac378d7-1028-4fca-9989-943d81bbf888_SNAPS_','2021-05-05 13:23:38','2021-05-05 15:23:37','09d9cf2b-e21d-4fc0-9b75-e824d4413f92.png','2021-05-05 15:23:38','SYNCED','09d9cf2b-e21d-4fc0-9b75-e824d4413f92',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.137.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'09e2f829-c9be-4abf-9bb3-d906193de809','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09e2f829-c9be-4abf-9bb3-d906193de809.ply','PLY','PATIENT_2e0a8247-f698-45b5-87fe-8b1e7c952f36_ACT_9de12ccb-56c6-44f8-9eb2-442a8ab403b9_SESS_ee60d82c-90a6-4dd2-b5b3-5e5ba64c79ca_BOSC_0466f45c-9e19-4f9c-bc42-8922b71bb216_PLY_','2020-12-02 10:32:23','2020-11-05 16:48:30','09e2f829-c9be-4abf-9bb3-d906193de809.ply','2020-12-02 11:32:23','SYNCED','09e2f829-c9be-4abf-9bb3-d906193de809',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.35.14.1.2\",\"modelMatrix\":\"-0.844927,-0.497355,0.196815,0,0.534882,-0.785648,0.310899,0,-5.37714e-9,0.36796,0.929842,0,-27.3135,-1.93759,-19.9013,1\",\"title\":\"Mandibule PLY\"}'),(2,'09ea1b5c-228c-4801-9864-eb023f29fe59','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09ea1b5c-228c-4801-9864-eb023f29fe59.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_82cabf0f-e610-4541-b7b5-f032d1e3c3c8_SESS_0b9702a6-1d15-41f9-ac87-79bd939f52d8_BOSC_17f6aa7a-db86-4744-8209-fd4db34cfb53_ZIP_','2022-02-07 13:25:16','2022-02-07 14:25:14','09ea1b5c-228c-4801-9864-eb023f29fe59.zip','2022-02-07 14:25:16','SYNCED','09ea1b5c-228c-4801-9864-eb023f29fe59',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.19.1.2\",\"modelMatrix\":\"-0.99299,-0.115414,0.0255052,0,0.118199,-0.969597,0.21427,0,-9.47948e-10,0.215782,0.976441,0,-25.0528,10.5654,-18.8271,1\",\"title\":\"Mandibule ZIP\"}'),(2,'09f7e33b-5277-4039-9bcb-546fafc179a7','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09f7e33b-5277-4039-9bcb-546fafc179a7.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_16d7b282-66e1-4355-9b60-0bafa1ca8e98_SESS_220665e1-59d7-472e-9aaf-149ee093a8e1_BOSC_58e07cde-2422-4a97-afcb-b86f55db1dc4_PLY_','2020-12-16 10:52:14','2020-05-27 16:17:07','09f7e33b-5277-4039-9bcb-546fafc179a7.ply','2020-12-16 11:52:14','SYNCED','09f7e33b-5277-4039-9bcb-546fafc179a7',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 216.1.18.1.1\",\"modelMatrix\":\"-0.99972,0.022192,-0.00822923,0,-0.0236686,-0.937349,0.347588,0,-1.14021e-10,0.347685,0.937611,0,-10.9063,13.0068,-20.0127,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'09fbe17c-3b8e-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09fbe17c-3b8e-11eb-94ee-226cec7cb58a.ply','PLY','PATIENT_482e1dae-4065-495d-8572-96cc5264aa25_ACT_69947cc5-0ea8-474a-8942-7a074b04a79a_SESS_ddb69746-f0b3-43fb-b437-7e5cd295f0a3_BOSC_d8263bda-8e33-49cf-8fd0-880d246a089f_PLY_','2020-12-11 08:50:58','2020-12-11 09:43:31','09fbe17c-3b8e-11eb-94ee-226cec7cb58a.ply','2020-12-11 09:50:58','SYNCED','09fbe17c-3b8e-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.29.1.1\",\"modelMatrix\":\"-0.978596,-0.1974,0.058169,0,0.205792,-0.938689,0.276609,0,4.35198e-9,0.282659,0.95922,0,-18.0283,8.49246,-25.8242,1\",\"title\":\"Mandibule PLY\"}'),(2,'09fbefc5-e1bf-4b40-ad4f-f25b67895098','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09fbefc5-e1bf-4b40-ad4f-f25b67895098.png','SNAPS','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_BOSC_6b91b69b-0088-4a4e-bb54-ae2789304ed8_SNAPS_','2021-12-30 18:03:15','2019-11-15 13:40:45','09fbefc5-e1bf-4b40-ad4f-f25b67895098.png','2021-12-30 19:03:15','SYNCED','09fbefc5-e1bf-4b40-ad4f-f25b67895098',0,NULL,'','','{\"displayTitle\":\"Mandibola 0\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'09fdbcaa-da85-47dc-b04f-05e2e495acb8','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09fdbcaa-da85-47dc-b04f-05e2e495acb8.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_eba88ec3-fbf7-4b32-9ddf-3375525d6fd9_SESS_9b99fbc3-67a8-47d0-80a0-686fe6baade1_TOSC_66684ab1-8dba-48bb-a307-b324b8075b3a_PLY_','2021-05-06 12:27:35','2021-05-06 14:27:32','09fdbcaa-da85-47dc-b04f-05e2e495acb8.ply','2021-05-06 14:27:35','SYNCED','09fdbcaa-da85-47dc-b04f-05e2e495acb8',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.142.1.1\",\"modelMatrix\":\"0.569169,-0.762226,0.308313,0,0.82222,0.527639,-0.213425,0,-1.24625e-8,0.374977,0.927034,0,-2.71241,-36.2188,-19.0032,1\",\"title\":\"Maxillaire PLY\"}'),(2,'09ffd9e0-ce08-465a-a2b9-b62cadc5749e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/09ffd9e0-ce08-465a-a2b9-b62cadc5749e.zip','ZIP','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_29fe1a4b-29de-45a5-b47c-01ce55f37ac2_SESS_47bd7b30-9506-4273-9771-aca249d894a1_TOSC_de0af1b9-fdab-4a0f-84bd-a1b2a4731395_ZIP_','2021-10-11 10:05:48','2021-10-11 12:05:44','09ffd9e0-ce08-465a-a2b9-b62cadc5749e.zip','2021-10-11 12:05:48','SYNCED','09ffd9e0-ce08-465a-a2b9-b62cadc5749e',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.196.1.3\",\"modelMatrix\":\"0.571443,-0.763576,0.300675,0,0.820642,0.531705,-0.209371,0,3.1187e-9,0.36639,0.930461,0,6.22039,-35.94,-16.5668,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'0a00a270-9ad1-47af-b0ab-128fec38241e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a00a270-9ad1-47af-b0ab-128fec38241e.ply','PLY','PATIENT_77df9d3b-1263-4977-9ccc-286cac817ae8_ACT_b6197058-add2-4c61-ab3b-b8da15d9bb13_SESS_35096ba8-a837-42da-ad6e-e6bdbbf74116_BOSC_12ebb0d0-3e96-45d3-ae51-5c0312466e23_PLY_','2022-02-01 11:47:24','2019-07-17 13:31:26','0a00a270-9ad1-47af-b0ab-128fec38241e.ply','2022-02-01 12:47:24','SYNCED','0a00a270-9ad1-47af-b0ab-128fec38241e',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 87.1.1.1\",\"modelMatrix\":\"-0.613858,0.784002,-0.0922982,0,-0.789416,-0.609648,0.071772,0,-2.39726e-9,0.11692,0.993141,0,10.2466,26.5157,-24.9078,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0a049627-3b8e-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a049627-3b8e-11eb-94ee-226cec7cb58a.png','SNAPS','PATIENT_482e1dae-4065-495d-8572-96cc5264aa25_ACT_69947cc5-0ea8-474a-8942-7a074b04a79a_SESS_ddb69746-f0b3-43fb-b437-7e5cd295f0a3_TOSC_7af02e47-b0e2-4778-9cdb-0071dc4c50b3_SNAPS_','2020-12-11 08:50:58','2020-12-11 09:29:34','0a049627-3b8e-11eb-94ee-226cec7cb58a.png','2020-12-11 09:50:58','SYNCED','0a049627-3b8e-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.36.29.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0a0bc00a-3b8e-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a0bc00a-3b8e-11eb-94ee-226cec7cb58a.ply','PLY','PATIENT_482e1dae-4065-495d-8572-96cc5264aa25_ACT_69947cc5-0ea8-474a-8942-7a074b04a79a_SESS_ddb69746-f0b3-43fb-b437-7e5cd295f0a3_TOSC_7af02e47-b0e2-4778-9cdb-0071dc4c50b3_PLY_','2020-12-11 08:50:58','2020-12-11 09:29:34','0a0bc00a-3b8e-11eb-94ee-226cec7cb58a.ply','2020-12-11 09:50:58','SYNCED','0a0bc00a-3b8e-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.36.29.1.1\",\"modelMatrix\":\"0.422598,-0.859933,0.286228,0,0.906317,0.40097,-0.133463,0,-3.93856e-9,0.315815,0.948821,0,-5.88302,-32.3731,-14.9231,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0a0daba1-88b9-4aca-a32e-33ee62cf03ec','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a0daba1-88b9-4aca-a32e-33ee62cf03ec.png','SNAPS','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_aaaeb032-2111-434f-b0d7-0923a56dbb56_SESS_1f381489-037a-46af-8034-d00e0aa3d9ea_BOSC_a2ae7933-dd79-48fa-9694-203d29380116_SNAPS_','2020-12-16 11:06:19','2020-01-20 16:11:47','0a0daba1-88b9-4aca-a32e-33ee62cf03ec.png','2020-12-16 12:06:19','SYNCED','0a0daba1-88b9-4aca-a32e-33ee62cf03ec',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.1.1.1.2\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0a0e3082-3b8e-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a0e3082-3b8e-11eb-94ee-226cec7cb58a.png','SNAPS','PATIENT_482e1dae-4065-495d-8572-96cc5264aa25_ACT_69947cc5-0ea8-474a-8942-7a074b04a79a_SESS_ddb69746-f0b3-43fb-b437-7e5cd295f0a3_BOSC_d8263bda-8e33-49cf-8fd0-880d246a089f_SNAPS_','2020-12-11 08:50:58','2020-12-11 09:43:31','0a0e3082-3b8e-11eb-94ee-226cec7cb58a.png','2020-12-11 09:50:58','SYNCED','0a0e3082-3b8e-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.29.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0a0e580d-e5fe-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a0e580d-e5fe-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_f8552962-190e-4ebd-a858-ecf408e2a47e_SESS_41fda676-39ef-4869-b503-2c72dc95f312_BOSC_8a3141ac-b952-4d64-a635-f0522be44322_SNAPS_','2020-12-07 12:01:07','2020-08-24 13:35:38','0a0e580d-e5fe-11ea-947d-226cec7cb58a.png','2020-12-07 13:01:07','SYNCED','0a0e580d-e5fe-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.26.47.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0a117f1e-de06-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a117f1e-de06-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_d2c071b7-7c84-4226-801b-47c72779f450_SESS_d24e8ab5-a662-4fc8-9858-6dee96968a00_TOSC_c0fb58b5-4212-4983-9505-117e19e18ae1_SNAPS_','2020-12-07 12:01:07','2020-08-14 10:10:05','0a117f1e-de06-11ea-947d-226cec7cb58a.png','2020-12-07 13:01:07','SYNCED','0a117f1e-de06-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.26.14.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0a13c9bc-de06-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a13c9bc-de06-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_d2c071b7-7c84-4226-801b-47c72779f450_SESS_d24e8ab5-a662-4fc8-9858-6dee96968a00_TOSC_c0fb58b5-4212-4983-9505-117e19e18ae1_PLY_','2020-12-07 12:01:07','2020-08-14 10:10:05','0a13c9bc-de06-11ea-947d-226cec7cb58a.ply','2020-12-07 13:01:07','SYNCED','0a13c9bc-de06-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.26.14.1.1\",\"modelMatrix\":\"0.377516,-0.907157,0.18587,0,0.926003,0.369833,-0.0757762,0,-5.38634e-9,0.200723,0.979648,0,-5.57475,-32.1081,-13.0947,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0a147708-e5fe-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a147708-e5fe-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_f8552962-190e-4ebd-a858-ecf408e2a47e_SESS_41fda676-39ef-4869-b503-2c72dc95f312_TOSC_0529933a-5250-4c4e-b923-33a0fa6560f4_PLY_','2020-12-07 12:01:07','2020-08-24 13:33:15','0a147708-e5fe-11ea-947d-226cec7cb58a.ply','2020-12-07 13:01:07','SYNCED','0a147708-e5fe-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.26.47.1.1\",\"modelMatrix\":\"0.73954,-0.62111,0.259427,0,0.673112,0.682406,-0.285029,0,-1.96403e-8,0.385414,0.922744,0,6.97313,-30.8637,-18.0716,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0a15db80-de06-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a15db80-de06-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_d2c071b7-7c84-4226-801b-47c72779f450_SESS_d24e8ab5-a662-4fc8-9858-6dee96968a00_BOSC_41e3db43-9da8-4e2b-accc-045a07353c7f_SNAPS_','2020-12-07 12:01:07','2020-08-14 10:13:08','0a15db80-de06-11ea-947d-226cec7cb58a.png','2020-12-07 13:01:07','SYNCED','0a15db80-de06-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.26.14.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0a16aaa5-e5fe-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a16aaa5-e5fe-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_f8552962-190e-4ebd-a858-ecf408e2a47e_SESS_41fda676-39ef-4869-b503-2c72dc95f312_TOSC_0529933a-5250-4c4e-b923-33a0fa6560f4_SNAPS_','2020-12-07 12:01:07','2020-08-24 13:33:15','0a16aaa5-e5fe-11ea-947d-226cec7cb58a.png','2020-12-07 13:01:07','SYNCED','0a16aaa5-e5fe-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.26.47.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0a17d813-de06-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a17d813-de06-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_d2c071b7-7c84-4226-801b-47c72779f450_SESS_d24e8ab5-a662-4fc8-9858-6dee96968a00_BOSC_41e3db43-9da8-4e2b-accc-045a07353c7f_PLY_','2020-12-07 12:01:08','2020-08-14 10:13:08','0a17d813-de06-11ea-947d-226cec7cb58a.ply','2020-12-07 13:01:08','SYNCED','0a17d813-de06-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.26.14.1.2\",\"modelMatrix\":\"-0.971018,-0.23053,0.0630868,0,0.239006,-0.936581,0.256305,0,-4.62811e-10,0.263955,0.964535,0,-16.6558,7.40096,-16.1065,1\",\"title\":\"Mandibule PLY\"}'),(2,'0a192b1d-e5fe-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a192b1d-e5fe-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_f8552962-190e-4ebd-a858-ecf408e2a47e_SESS_41fda676-39ef-4869-b503-2c72dc95f312_BOSC_8a3141ac-b952-4d64-a635-f0522be44322_PLY_','2020-12-07 12:01:08','2020-08-24 13:35:38','0a192b1d-e5fe-11ea-947d-226cec7cb58a.ply','2020-12-07 13:01:08','SYNCED','0a192b1d-e5fe-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.26.47.1.1\",\"modelMatrix\":\"-0.999317,0.0359507,-0.00851485,0,-0.0369453,-0.972415,0.230314,0,-3.31733e-10,0.230472,0.973079,0,-16.0576,11.1415,-18.0668,1\",\"title\":\"Mandibule PLY\"}'),(2,'0a1a84d1-bab1-40dd-9cb2-5aa5253bc2ac','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a1a84d1-bab1-40dd-9cb2-5aa5253bc2ac.ply','PLY','PATIENT_f8a91590-fa42-4e9b-b0ef-fc22e154a86c_ACT_915ea130-aff4-4670-a980-e91d2db119e8_SESS_10f28a40-a52f-442d-8439-339c44f3e4fa_TOSC_5eebc004-8043-4878-971a-233bc24927b6_PLY_','2020-12-08 17:26:42','2020-07-03 11:57:29','0a1a84d1-bab1-40dd-9cb2-5aa5253bc2ac.ply','2020-12-08 18:26:42','SYNCED','0a1a84d1-bab1-40dd-9cb2-5aa5253bc2ac',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.113.1.1\",\"modelMatrix\":\"0.774333,-0.58554,0.239899,0,0.632778,0.716527,-0.293565,0,9.25205e-9,0.37912,0.925348,0,9.30549,-27.4145,-18.628,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0a266eb0-5858-4ca0-837c-6042b0018e41','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a266eb0-5858-4ca0-837c-6042b0018e41.ply','PLY','PATIENT_9c424d0a-91b9-4df7-b470-de67439e396c_ACT_27b123e3-580b-4c73-a18e-db6c5799c87b_SESS_ad1b540b-47c5-4f1b-8964-4de0d1b0ca5a_BOSC_9e082639-4ed3-4f9f-9f97-2fc22db3f939_PLY_','2021-01-11 13:52:44','2021-01-11 14:35:32','0a266eb0-5858-4ca0-837c-6042b0018e41.ply','2021-01-11 14:52:44','SYNCED','0a266eb0-5858-4ca0-837c-6042b0018e41',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.73.1.2\",\"modelMatrix\":\"-0.95303,0.288295,-0.0928456,0,-0.302876,-0.907147,0.292148,0,3.36617e-9,0.306546,0.951856,0,-11.8856,17.5787,-15.9675,1\",\"title\":\"Mandibule PLY\"}'),(2,'0a2783ba-62d1-41a7-b99b-6d1cd2c5a7dc','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a2783ba-62d1-41a7-b99b-6d1cd2c5a7dc.ply','PLY','PATIENT_ff96c5bd-a3bf-4f05-92e4-56f76b83b454_ACT_d737feed-a81f-42f0-a536-f47f5a256ae6_SESS_4ac56d86-9375-40ed-956b-affb4721bd49_TOSC_c703c340-c05c-4271-a8ef-688293b8a817_PLY_','2021-12-30 18:03:15','2019-11-18 11:46:57','0a2783ba-62d1-41a7-b99b-6d1cd2c5a7dc.ply','2021-12-30 19:03:15','SYNCED','0a2783ba-62d1-41a7-b99b-6d1cd2c5a7dc',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 203.1.1.1\",\"modelMatrix\":\"0.689837,-0.645555,0.327696,0,0.723965,0.615123,-0.312248,0,-5.68395e-9,0.45264,0.891693,0,6.49575,-35.8846,-20.1313,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0a29fdf4-586b-4b87-aa3d-8e35e23bcdaa','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a29fdf4-586b-4b87-aa3d-8e35e23bcdaa.png','SNAPS','PATIENT_b4908dda-5d76-4e35-849e-e08780817f2e_ACT_daf35305-351d-42c6-9799-5882d57a3476_SESS_758b6d2c-f72a-49d9-9fea-a57718467959_TOSC_771664cd-d750-49a0-aa43-8b0cb7d8c509_SNAPS_','2022-02-01 11:47:24','2019-07-22 16:54:02','0a29fdf4-586b-4b87-aa3d-8e35e23bcdaa.png','2022-02-01 12:47:24','SYNCED','0a29fdf4-586b-4b87-aa3d-8e35e23bcdaa',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 109.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0a2d8e9d-460a-4c22-9efa-293ed82495ec','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a2d8e9d-460a-4c22-9efa-293ed82495ec.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_65b9d490-aed6-4c41-be15-53e25c84af4d_SESS_9f48c8ba-9786-4871-bcb0-7f121f65e446_TOSC_637eb2be-61e2-43af-b2fe-1bbd0b7c3d54_PLY_','2020-12-16 10:52:16','2020-03-12 15:29:55','0a2d8e9d-460a-4c22-9efa-293ed82495ec.ply','2020-12-16 11:52:16','SYNCED','0a2d8e9d-460a-4c22-9efa-293ed82495ec',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.2\",\"modelMatrix\":\"0.537018,-0.801869,0.261952,0,0.843571,0.51047,-0.166759,0,-1.01997e-8,0.310528,0.950564,0,-2.7145,-33.1247,-16.8876,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0a2dd17a-1525-4edd-a666-620f0e7973f0','','ZIP','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_3f09e7e7-5070-43bb-8bce-03f3623dfb5a_SESS_489e5187-e6d6-4fb9-954a-0b6267595591_BOSC_e7718a2d-353c-4214-9338-49f8cc46b58a_ZIP_','2021-09-22 09:40:43','2021-09-22 11:40:40','','2021-09-22 11:40:43','SYNCED','0a2dd17a-1525-4edd-a666-620f0e7973f0',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.22.26.1.3\",\"modelMatrix\":\"0.932115,-0.353124,0.0804077,0,0.362163,0.908851,-0.206949,0,-1.3916e-9,0.222021,0.975042,0,-8.99574,23.8795,-19.2562,1\",\"title\":\"Mandibule ZIP\"}'),(2,'0a2e51f9-9d27-4532-8397-0931fcf4eba9','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a2e51f9-9d27-4532-8397-0931fcf4eba9.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_fad54488-341f-4146-8637-3470378cf2f9_SESS_10cfc2a6-e17a-49a7-beff-60b736bf2445_TOSC_0ddf5fb9-5f33-4f92-a00e-4ba4b0f1945f_SNAPS_','2022-01-20 13:40:06','2022-01-20 14:40:02','0a2e51f9-9d27-4532-8397-0931fcf4eba9.png','2022-01-20 14:40:06','SYNCED','0a2e51f9-9d27-4532-8397-0931fcf4eba9',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.17.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0a37bf48-5abe-4a4f-a2ff-9bf486298169','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a37bf48-5abe-4a4f-a2ff-9bf486298169.ply','PLY','PATIENT_bd1eba7e-0abe-41fc-859e-90761a16482e_ACT_896e85b9-5776-4f4b-a605-57a738ffaf31_SESS_eecc3c10-e747-4234-b94e-6ef19f29289b_BOSC_0484d990-f971-4f1f-93cc-e989c8b4f368_PLY_','2021-01-15 08:42:10','2021-01-15 09:39:40','0a37bf48-5abe-4a4f-a2ff-9bf486298169.ply','2021-01-15 09:42:10','SYNCED','0a37bf48-5abe-4a4f-a2ff-9bf486298169',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.5.1.2\",\"modelMatrix\":\"-0.865474,0.484944,-0.125634,0,-0.500954,-0.837815,0.217052,0,-2.95403e-9,0.25079,0.968042,0,-0.744143,17.8504,-20.8929,1\",\"title\":\"Mandibule PLY\"}'),(2,'0a3b2b66-a02c-42f1-b214-6bb66e68b5c1','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a3b2b66-a02c-42f1-b214-6bb66e68b5c1.ply','PLY','PATIENT_896c58b2-09d0-4924-afd4-804b68c496b7_ACT_22ff036e-5aec-4cfd-9224-cc3b88c546b5_SESS_0e888239-d087-47ba-82ab-1f79eddb5b0c_BOSC_ea82ec27-ce8d-43f2-a778-3b5bb5cfba24_PLY_','2021-12-30 18:03:16','2019-10-31 09:12:42','0a3b2b66-a02c-42f1-b214-6bb66e68b5c1.ply','2021-12-30 19:03:16','SYNCED','0a3b2b66-a02c-42f1-b214-6bb66e68b5c1',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 197.1.1.1\",\"modelMatrix\":\"-0.807339,0.581042,-0.102932,0,-0.590088,-0.794961,0.140828,0,1.04965e-9,0.174435,0.984669,0,-0.44251,20.671,-15.2433,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0a3bbdb9-aa1e-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a3bbdb9-aa1e-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_e51cf9a2-03cb-4e48-928a-2755186e1db6_ACT_000dfdf1-07e2-4cb4-9351-56d36d0f2b2f_SESS_bcaa9cd4-a73e-45a0-aa14-14571985bf99_TOSC_4898a0f1-e758-4945-8096-35453addad4f_STL_','2022-02-01 11:47:24','2019-07-19 16:11:04','0a3bbdb9-aa1e-11e9-a33b-226cec7cb58a.stl','2022-02-01 12:47:24','SYNCED','0a3bbdb9-aa1e-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 102.1.1.1\",\"modelMatrix\":\"0.604138,-0.726749,0.326884,0,0.796879,0.55097,-0.247821,0,1.17685e-8,0.410205,0.911993,0,4.5742,-36.6945,-23.86,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'0a3c58fe-aa1e-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a3c58fe-aa1e-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_e51cf9a2-03cb-4e48-928a-2755186e1db6_ACT_000dfdf1-07e2-4cb4-9351-56d36d0f2b2f_SESS_bcaa9cd4-a73e-45a0-aa14-14571985bf99_BOSC_45a59966-4c7e-47ea-b045-6b04d1ecd1ad_STL_','2022-02-01 11:47:24','2019-07-19 16:16:54','0a3c58fe-aa1e-11e9-a33b-226cec7cb58a.stl','2022-02-01 12:47:24','SYNCED','0a3c58fe-aa1e-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 102.1.1.1\",\"modelMatrix\":\"-0.983759,0.173515,-0.045952,0,-0.179497,-0.950975,0.251847,0,-9.75582e-10,0.256005,0.966676,0,-12.4899,15.7274,-23.3581,1\",\"title\":\"MANDIBULE STL\"}'),(2,'0a3cf32d-aa1e-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a3cf32d-aa1e-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_e51cf9a2-03cb-4e48-928a-2755186e1db6_ACT_000dfdf1-07e2-4cb4-9351-56d36d0f2b2f_SESS_bcaa9cd4-a73e-45a0-aa14-14571985bf99_BOSC_45a59966-4c7e-47ea-b045-6b04d1ecd1ad_PLY_','2022-02-01 11:47:24','2019-07-19 16:16:54','0a3cf32d-aa1e-11e9-a33b-226cec7cb58a.ply','2022-02-01 12:47:24','SYNCED','0a3cf32d-aa1e-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 102.1.1.1\",\"modelMatrix\":\"-0.983759,0.173515,-0.045952,0,-0.179497,-0.950975,0.251847,0,-9.75582e-10,0.256005,0.966676,0,-12.4899,15.7274,-23.3581,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0a3d6f24-aa1e-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a3d6f24-aa1e-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_e51cf9a2-03cb-4e48-928a-2755186e1db6_ACT_000dfdf1-07e2-4cb4-9351-56d36d0f2b2f_SESS_bcaa9cd4-a73e-45a0-aa14-14571985bf99_TOSC_4898a0f1-e758-4945-8096-35453addad4f_SNAPS_','2022-02-01 11:47:25','2019-07-19 16:11:04','0a3d6f24-aa1e-11e9-a33b-226cec7cb58a.png','2022-02-01 12:47:25','SYNCED','0a3d6f24-aa1e-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 102.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0a3dbafe-aa1e-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a3dbafe-aa1e-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_e51cf9a2-03cb-4e48-928a-2755186e1db6_ACT_000dfdf1-07e2-4cb4-9351-56d36d0f2b2f_SESS_bcaa9cd4-a73e-45a0-aa14-14571985bf99_BOSC_45a59966-4c7e-47ea-b045-6b04d1ecd1ad_SNAPS_','2022-02-01 11:47:25','2019-07-19 16:16:54','0a3dbafe-aa1e-11e9-a33b-226cec7cb58a.png','2022-02-01 12:47:25','SYNCED','0a3dbafe-aa1e-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 102.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0a3e440c-aa1e-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a3e440c-aa1e-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_e51cf9a2-03cb-4e48-928a-2755186e1db6_ACT_000dfdf1-07e2-4cb4-9351-56d36d0f2b2f_SESS_bcaa9cd4-a73e-45a0-aa14-14571985bf99_TOSC_4898a0f1-e758-4945-8096-35453addad4f_PLY_','2022-02-01 11:47:25','2019-07-19 16:11:04','0a3e440c-aa1e-11e9-a33b-226cec7cb58a.ply','2022-02-01 12:47:25','SYNCED','0a3e440c-aa1e-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 102.1.1.1\",\"modelMatrix\":\"0.604138,-0.726749,0.326884,0,0.796879,0.55097,-0.247821,0,1.17685e-8,0.410205,0.911993,0,4.5742,-36.6945,-23.86,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0a40591e-7bd9-4f42-a24b-9279f5b1385b','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a40591e-7bd9-4f42-a24b-9279f5b1385b.ply','PLY','PATIENT_3ac6da53-88c5-4d65-a37f-cd3cf5633739_ACT_da9e0457-4df9-4f0a-bb9c-aad3c411f3d3_SESS_0c5f0696-5850-4695-ad77-7936edc4a982_BOSC_45c46f4c-1533-4c11-b74d-9a273add85b0_PLY_','2021-03-26 14:13:34','2021-03-26 15:05:13','0a40591e-7bd9-4f42-a24b-9279f5b1385b.ply','2021-03-26 15:13:34','SYNCED','0a40591e-7bd9-4f42-a24b-9279f5b1385b',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.5.1.3\",\"modelMatrix\":\"0.616499,-0.769618,0.166185,0,0.787355,0.602611,-0.130123,0,-1.3858e-8,0.211067,0.977472,0,-3.65512,-21.9877,-26.864,1\",\"title\":\"Mandibule PLY\"}'),(2,'0a43bcc3-1570-4e97-9d83-654609834105','','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_b4a79376-8645-457c-ab79-8cada0f59b2f_SESS_fc5a1184-f939-4a05-a5d1-f6a1859a789f_BOSC_9d174d73-74f5-42a5-a549-165cfb0fe8b3_PLY_','2021-04-09 13:39:24','2021-04-09 15:39:21','','2021-04-09 15:39:24','SYNCED','0a43bcc3-1570-4e97-9d83-654609834105',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.49.1.2\",\"modelMatrix\":\"-0.787167,-0.616234,0.0249931,0,0.61674,-0.78652,0.0318995,0,6.97854e-11,0.0405244,0.999179,0,-20.9135,-2.9868,-23.6414,1\",\"title\":\"Mandibule PLY\"}'),(2,'0a44ad48-adf2-4087-8fd9-459a8dd94130','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a44ad48-adf2-4087-8fd9-459a8dd94130.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_3cb05e41-ba49-4185-9208-8ea1be47a6a3_SESS_17bc041f-1826-42b3-a480-fb2f537131d2_TOSC_8266eab2-5cba-44ea-af73-801c76731ba7_PLY_','2021-07-21 09:36:24','2021-07-21 09:22:19','0a44ad48-adf2-4087-8fd9-459a8dd94130.ply','2021-07-21 11:36:24','SYNCED','871d8b2f-cd2b-4811-afb2-b259d1c2eb25',1,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.171.1.1\",\"modelMatrix\":\"0.344221,-0.909556,0.232851,0,0.938889,0.333467,-0.0853691,0,-2.02516e-9,0.248007,0.968758,0,-16.6282,-34.1729,-16.2368,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0a469f9b-35e9-4dd1-a1a7-de1d7cec26b5','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a469f9b-35e9-4dd1-a1a7-de1d7cec26b5.ply','PLY','PATIENT_79c7f350-c6e2-400a-8a40-2bc389f7254a_ACT_167d783d-a345-4c3f-bd59-637367de9675_SESS_a88ee2e3-d5a6-4626-bca5-c8fcece089f9_TOSC_fd02a356-80f3-468a-967d-a316b22a84ac_PLY_','2020-12-14 12:52:07','2020-12-14 13:41:52','0a469f9b-35e9-4dd1-a1a7-de1d7cec26b5.ply','2020-12-14 13:52:07','SYNCED','0a469f9b-35e9-4dd1-a1a7-de1d7cec26b5',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.36.31.1.1\",\"modelMatrix\":\"0.379449,-0.893426,0.240436,0,0.925213,0.366412,-0.0986075,0,1.02017e-8,0.259871,0.965643,0,-10.5709,-33.5591,-12.8985,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0a49f8c4-9bda-496f-bce7-7387a3efc25d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a49f8c4-9bda-496f-bce7-7387a3efc25d.png','SNAPS','PATIENT_2e0a8247-f698-45b5-87fe-8b1e7c952f36_ACT_33f1a5b8-4fcd-4390-9752-9c1e1b325a33_SESS_28e3bb53-053b-45f5-96e4-03581def36b7_TOSC_ec9a90f1-6286-4d4a-917f-5df2df3eb777_SNAPS_','2020-12-02 10:32:26','2020-10-29 11:33:13','0a49f8c4-9bda-496f-bce7-7387a3efc25d.png','2020-12-02 11:32:26','SYNCED','0a49f8c4-9bda-496f-bce7-7387a3efc25d',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.35.10.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0a53b979-b46b-4ead-ab32-a83227e9a517','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a53b979-b46b-4ead-ab32-a83227e9a517.png','SNAPS','PATIENT_3ba502e6-1fd1-40ed-8e72-2db58e8c52bb_ACT_cffc8286-917f-47aa-b5d1-a282ed5c54bd_SESS_176febd5-da68-4715-802e-945c38e04419_BOSC_042f9c15-6e8b-4f7b-a4a0-9f2cc5d7cb2c_SNAPS_','2020-12-07 12:01:10','2020-07-29 09:29:43','0a53b979-b46b-4ead-ab32-a83227e9a517.png','2020-12-07 13:01:10','SYNCED','0a53b979-b46b-4ead-ab32-a83227e9a517',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.29.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0a56cc75-ea9d-4b2d-b06b-7fee06373b89','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a56cc75-ea9d-4b2d-b06b-7fee06373b89.ply','PLY','PATIENT_2723e13b-24b4-474f-97a7-0d782b6e6f62_ACT_1b19b5ef-5efa-43cf-9f25-74f18102addf_SESS_3f05bea5-6f8a-4370-8c23-525f24a560f5_TOSC_b18c6460-bd39-4db5-bb2e-67d9af0b7a4b_PLY_','2020-11-24 09:00:18','2020-11-24 09:58:27','0a56cc75-ea9d-4b2d-b06b-7fee06373b89.ply','2020-11-24 10:00:18','SYNCED','0a56cc75-ea9d-4b2d-b06b-7fee06373b89',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.67.1.1.11\",\"modelMatrix\":\"0.412786,-0.860762,0.297819,0,0.910828,0.390096,-0.134971,0,3.84475e-10,0.326977,0.945032,0,-2.08855,-28.9208,-18.5631,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0a5bd22d-de04-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a5bd22d-de04-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_924a5252-7f02-42d9-a373-20c27402698f_SESS_2429395d-e5d7-4da0-9751-08798c01e4c3_TOSC_092acd03-1b30-460c-b59a-341c3f2c0181_SNAPS_','2020-12-07 12:01:10','2020-08-14 09:54:34','0a5bd22d-de04-11ea-947d-226cec7cb58a.png','2020-12-07 13:01:10','SYNCED','0a5bd22d-de04-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.26.13.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0a5dc5c3-de04-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a5dc5c3-de04-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_924a5252-7f02-42d9-a373-20c27402698f_SESS_2429395d-e5d7-4da0-9751-08798c01e4c3_BOSC_f759f098-8d1d-431b-b4b3-927334a64725_PLY_','2020-12-07 12:01:10','2020-08-14 09:57:14','0a5dc5c3-de04-11ea-947d-226cec7cb58a.ply','2020-12-07 13:01:10','SYNCED','0a5dc5c3-de04-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.26.13.1.1\",\"modelMatrix\":\"-0.909482,-0.399633,0.114616,0,0.415744,-0.874237,0.250734,0,3.06588e-10,0.275688,0.961247,0,-21.9617,3.87145,-18.2718,1\",\"title\":\"Mandibule PLY\"}'),(2,'0a5ddb9d-f06b-4469-bad6-069d0ac84241','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a5ddb9d-f06b-4469-bad6-069d0ac84241.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_96214f4b-9456-4208-b81d-5b82b21b335a_SESS_07baa47f-dbc6-44a6-834f-d97971fa404b_BOSC_d16f3392-688b-4393-8cc1-b59599a49b32_PLY_','2020-12-16 10:52:18','2020-02-11 16:39:55','0a5ddb9d-f06b-4469-bad6-069d0ac84241.ply','2020-12-16 11:52:18','SYNCED','0a5ddb9d-f06b-4469-bad6-069d0ac84241',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"modelMatrix\":\"-0.999002,0.0429314,-0.0123,0,-0.0446586,-0.960364,0.275147,0,-5.53983e-11,0.275422,0.961323,0,-15.3569,15.881,-14.8301,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0a5fe9b4-de04-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a5fe9b4-de04-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_924a5252-7f02-42d9-a373-20c27402698f_SESS_2429395d-e5d7-4da0-9751-08798c01e4c3_BOSC_f759f098-8d1d-431b-b4b3-927334a64725_SNAPS_','2020-12-07 12:01:11','2020-08-14 09:57:14','0a5fe9b4-de04-11ea-947d-226cec7cb58a.png','2020-12-07 13:01:11','SYNCED','0a5fe9b4-de04-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.26.13.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0a609f98-6598-4d34-812d-800d7c05b0d8','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a609f98-6598-4d34-812d-800d7c05b0d8.png','SNAPS','PATIENT_b4cb3c13-3480-4913-93e3-7083e05bbdbb_ACT_5d174e13-88f7-4d7c-bd79-7d7f57587e6f_SESS_748ea73c-8474-42a5-833c-d156b5dfeaaa_TOSC_298184ab-f830-4501-a09b-9c579fff1125_SNAPS_','2021-02-25 10:54:39','2021-02-25 11:34:14','0a609f98-6598-4d34-812d-800d7c05b0d8.png','2021-02-25 11:54:39','SYNCED','0a609f98-6598-4d34-812d-800d7c05b0d8',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.52.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0a61e863-de04-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a61e863-de04-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_924a5252-7f02-42d9-a373-20c27402698f_SESS_2429395d-e5d7-4da0-9751-08798c01e4c3_TOSC_092acd03-1b30-460c-b59a-341c3f2c0181_PLY_','2020-12-07 12:01:11','2020-08-14 09:54:34','0a61e863-de04-11ea-947d-226cec7cb58a.ply','2020-12-07 13:01:11','SYNCED','0a61e863-de04-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.26.13.1.1\",\"modelMatrix\":\"0.336051,-0.92257,0.189564,0,0.941844,0.329174,-0.0676366,0,-2.67478e-9,0.201269,0.979536,0,-9.98126,-28.3101,-13.5651,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0a771b74-1dca-49b6-a679-60477a0c38ea','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a771b74-1dca-49b6-a679-60477a0c38ea.png','SNAPS','PATIENT_2723e13b-24b4-474f-97a7-0d782b6e6f62_ACT_1b19b5ef-5efa-43cf-9f25-74f18102addf_SESS_3f05bea5-6f8a-4370-8c23-525f24a560f5_BOSC_4c826e0e-6638-410b-a6d0-0060478381e5_SNAPS_','2020-11-25 09:11:06','2020-11-25 10:11:05','0a771b74-1dca-49b6-a679-60477a0c38ea.png','2020-11-25 10:11:06','SYNCED','0a771b74-1dca-49b6-a679-60477a0c38ea',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.67.1.1.12\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0a784696-e5f0-4e0f-b4e2-62abfc51436f','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a784696-e5f0-4e0f-b4e2-62abfc51436f.ply','PLY','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_fd694b3f-abde-4e46-91f7-7c62bfdcafa4_SESS_73a3f5b9-e905-4911-a163-2022e1de3380_TOSC_33c23c80-0963-40c0-a315-0461c3cb686a_PLY_','2021-08-19 22:26:44','2019-11-26 15:43:14','0a784696-e5f0-4e0f-b4e2-62abfc51436f.ply','2021-08-20 00:26:44','SYNCED','0a784696-e5f0-4e0f-b4e2-62abfc51436f',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"modelMatrix\":\"-0.314282,-0.917164,0.245023,0,0.94933,-0.303633,0.0811166,0,-3.23617e-9,0.258102,0.966118,0,-26.7208,-19.9951,-15.3285,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0a7a3f65-54ae-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a7a3f65-54ae-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_442eff8f-6b66-481a-8ed8-4880ab72f3b4_SESS_c4721828-5af5-4858-8ec9-8b9a91b74be2_BOSC_f2121c2c-4949-41e2-bde3-d951dcca0a00_PLY_','2020-12-16 10:52:18','2020-02-21 14:16:09','0a7a3f65-54ae-11ea-947d-226cec7cb58a.ply','2020-12-16 11:52:18','SYNCED','0a7a3f65-54ae-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"modelMatrix\":\"-0.487776,0.872338,-0.0331893,0,-0.872969,-0.487423,0.0185447,0,-8.62903e-10,0.0380189,0.999277,0,7.91763,20.7783,-20.3288,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0a7c381c-54ae-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a7c381c-54ae-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_feae2a9b-ce74-4748-a769-afb48091183f_ACT_442eff8f-6b66-481a-8ed8-4880ab72f3b4_SESS_c4721828-5af5-4858-8ec9-8b9a91b74be2_TOSC_486af8d6-7715-463b-9719-5d135f018413_SNAPS_','2020-12-16 10:52:18','2020-02-21 14:13:11','0a7c381c-54ae-11ea-947d-226cec7cb58a.png','2020-12-16 11:52:18','SYNCED','0a7c381c-54ae-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0a7cbddd-a52d-4b28-97ad-a282c142b342','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a7cbddd-a52d-4b28-97ad-a282c142b342.png','SNAPS','PATIENT_74341905-5b86-4180-9dd8-e689d6ed33e3_ACT_959ae692-c0ad-4eea-94fd-cc2e30eeed43_SESS_35fc8e2a-49eb-4e3f-a21a-ce61a5a33aa4_BOSC_001bba83-8025-4d1d-9e84-ac2b12d51d20_SNAPS_','2020-12-18 15:29:57','2020-12-18 16:29:32','0a7cbddd-a52d-4b28-97ad-a282c142b342.png','2020-12-18 16:29:57','SYNCED','0a7cbddd-a52d-4b28-97ad-a282c142b342',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.45.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0a7dc2a5-54ae-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a7dc2a5-54ae-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_442eff8f-6b66-481a-8ed8-4880ab72f3b4_SESS_c4721828-5af5-4858-8ec9-8b9a91b74be2_BOSC_f2121c2c-4949-41e2-bde3-d951dcca0a00_SNAPS_','2020-12-16 10:52:19','2020-02-21 14:16:09','0a7dc2a5-54ae-11ea-947d-226cec7cb58a.png','2020-12-16 11:52:19','SYNCED','0a7dc2a5-54ae-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0a800105-54ae-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a800105-54ae-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_feae2a9b-ce74-4748-a769-afb48091183f_ACT_442eff8f-6b66-481a-8ed8-4880ab72f3b4_SESS_c4721828-5af5-4858-8ec9-8b9a91b74be2_TOSC_486af8d6-7715-463b-9719-5d135f018413_PLY_','2020-12-16 10:52:19','2020-02-21 14:13:11','0a800105-54ae-11ea-947d-226cec7cb58a.ply','2020-12-16 11:52:19','SYNCED','0a800105-54ae-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"modelMatrix\":\"0.677827,-0.692328,0.24745,0,0.735221,0.638283,-0.228133,0,-4.58298e-9,0.336566,0.94166,0,-0.962451,-31.9979,-15.8202,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0a805314-5926-4886-b6c5-5b11b7362de3','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a805314-5926-4886-b6c5-5b11b7362de3.ply','PLY','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_13648b48-b47d-4bcd-85a0-5211df734260_SESS_9a6d7c2c-addd-4900-a36e-a849376b43ad_BOSC_9fd88533-352d-4cca-9cb9-e5e1a2370af3_PLY_','2021-04-07 09:00:16','2021-04-07 11:00:15','0a805314-5926-4886-b6c5-5b11b7362de3.ply','2021-04-07 11:00:16','SYNCED','0279a09f-6f3f-4f5d-a09f-d2c8b1f4ae88',1,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.10.1.2\",\"modelMatrix\":\"-0.996711,0.080539,-0.00895779,0,-0.0810356,-0.990603,0.110178,0,-4.52244e-10,0.110541,0.993872,0,30.877,12.2413,-16.2193,1\",\"title\":\"Mandibule PLY\"}'),(2,'0a815076-f55e-4794-8456-f05fabee8aa0','','ZIP','PATIENT_5d20dc12-2bc8-4b92-9b5c-529fbc249b12_ACT_3a496830-66d9-4faf-9a96-8d5024a5fa1d_SESS_253fb7e2-0c36-4acf-8cd5-200858a094bc_TOSC_6b3bc4c1-e12c-4966-9f28-c7f980873266_ZIP_','2021-09-29 09:25:09','2021-09-29 11:25:06','','2021-09-29 11:25:09','SYNCED','0a815076-f55e-4794-8456-f05fabee8aa0',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.402.1.1.1\",\"modelMatrix\":\"0.798853,-0.589451,0.119928,0,0.601527,0.782815,-0.159269,0,-8.6319e-9,0.199372,0.979924,0,-3.256,-32.9369,-16.5188,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'0a82f573-6a32-4b8d-8584-3156d278b7be','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a82f573-6a32-4b8d-8584-3156d278b7be.ply','PLY','PATIENT_d9860777-a354-46c2-bb39-b2f150617cc7_ACT_007fc3da-8408-4668-b268-90b0cc4e0512_SESS_e5c0ff5f-1b35-473b-bb5b-6a699181486e_BOSC_e2acb957-0e34-46cc-88b6-368e2a1956df_PLY_','2020-12-23 09:07:50','2019-12-18 14:32:59','0a82f573-6a32-4b8d-8584-3156d278b7be.ply','2020-12-23 10:07:50','SYNCED','0a82f573-6a32-4b8d-8584-3156d278b7be',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 21.1.268.1.1.1\",\"modelMatrix\":\"-0.223239,0.966774,-0.124547,0,-0.974764,-0.221409,0.0285235,0,-3.13958e-10,0.127771,0.991804,0,11.8882,16.7578,-23.1337,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0a889874-9b6e-4be0-a2b9-55a5f419a324','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a889874-9b6e-4be0-a2b9-55a5f419a324.ply','PLY','PATIENT_878a5537-ff9c-4571-a968-f11b3b1e2055_ACT_6c0855be-3e79-42b9-84ff-3f2afe3afb78_SESS_eb76868f-5b66-47aa-8517-3a782fe0b86f_BOSC_28318e36-8937-4aa6-8ea5-8d0ebd1423c1_PLY_','2022-02-01 11:47:25','2019-07-19 12:00:00','0a889874-9b6e-4be0-a2b9-55a5f419a324.ply','2022-02-01 12:47:25','SYNCED','0a889874-9b6e-4be0-a2b9-55a5f419a324',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 99.1.1.1\",\"modelMatrix\":\"-0.961114,-0.274262,0.0322554,0,0.276153,-0.954535,0.112261,0,2.84132e-10,0.116803,0.993155,0,-29.2489,12.1179,-27.6354,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0a8afc39-e60d-4b35-8d4a-6650162d9278','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a8afc39-e60d-4b35-8d4a-6650162d9278.png','SNAPS','PATIENT_158e4d86-5a2b-4f2f-a26f-d927998b7946_ACT_1d8ad4fd-f2a3-407c-97f0-a15fe6d90d00_SESS_f151be04-535c-4a24-a25c-c6b2ede819f9_BOSC_2ca58b64-0cfb-4efc-a784-ceb09920bcb2_SNAPS_','2021-09-29 09:22:23','2021-09-29 11:22:19','0a8afc39-e60d-4b35-8d4a-6650162d9278.png','2021-09-29 11:22:23','SYNCED','0a8afc39-e60d-4b35-8d4a-6650162d9278',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.156.1.1.4\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0a8ccbff-82ef-443a-b57e-031ad8b27082','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a8ccbff-82ef-443a-b57e-031ad8b27082.ply','PLY','PATIENT_dde53ea4-f623-42e4-9864-d8e77d9deabe_ACT_c658c808-2655-4213-a8a0-1c34d5830ee5_SESS_ad32c977-4115-45c7-9168-d19d87c66102_BOSC_a2b7dde6-1c31-47e4-ba81-afc2bb602260_PLY_','2021-12-30 18:03:17','2019-11-22 08:23:12','0a8ccbff-82ef-443a-b57e-031ad8b27082.ply','2021-12-30 19:03:17','SYNCED','0a8ccbff-82ef-443a-b57e-031ad8b27082',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 208.1.1.1\",\"modelMatrix\":\"-0.852783,0.513392,-0.0958648,0,-0.522266,-0.838293,0.156533,0,-6.56088e-9,0.183556,0.983009,0,2.08999,21.5508,-19.8589,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0a8e5b6f-230d-4194-b6d4-79080ff49ed4','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a8e5b6f-230d-4194-b6d4-79080ff49ed4.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_875a1e66-4203-4e71-88bf-db0512ab80f6_SESS_7f1064b6-9587-413e-9479-70a1b3fd3a59_BOSC_14de9ac8-8c68-4e57-ac56-e3dbb6a01a02_SNAPS_','2021-04-28 09:07:14','2021-04-28 11:07:13','0a8e5b6f-230d-4194-b6d4-79080ff49ed4.png','2021-04-28 11:07:14','SYNCED','0a8e5b6f-230d-4194-b6d4-79080ff49ed4',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.122.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0a9b54f5-f9bc-4b77-8f5c-e69129e9dc34','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a9b54f5-f9bc-4b77-8f5c-e69129e9dc34.png','SNAPS','PATIENT_3ac6da53-88c5-4d65-a37f-cd3cf5633739_ACT_da9e0457-4df9-4f0a-bb9c-aad3c411f3d3_SESS_0c5f0696-5850-4695-ad77-7936edc4a982_BOSC_45c46f4c-1533-4c11-b74d-9a273add85b0_SNAPS_','2021-03-26 14:13:34','2021-03-26 15:05:13','0a9b54f5-f9bc-4b77-8f5c-e69129e9dc34.png','2021-03-26 15:13:34','SYNCED','0a9b54f5-f9bc-4b77-8f5c-e69129e9dc34',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.5.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0a9ebfae-d216-4a6c-8ce4-a615d55a0894','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0a9ebfae-d216-4a6c-8ce4-a615d55a0894.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_d118891c-ba7a-4cdd-a593-8c5698cbe22b_SESS_4091b25f-0966-41e6-83f9-36a673a07b16_TOSC_72e4015f-f7b9-43ad-9610-f3bc18069043_PLY_','2021-04-29 09:00:36','2021-04-29 11:00:34','0a9ebfae-d216-4a6c-8ce4-a615d55a0894.ply','2021-04-29 11:00:36','SYNCED','0a9ebfae-d216-4a6c-8ce4-a615d55a0894',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.127.1.2\",\"modelMatrix\":\"-0.142809,-0.955026,0.259869,0,0.98975,-0.137798,0.0374958,0,-7.46764e-10,0.26256,0.964916,0,-20.4813,-21.7697,-16.6717,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0aa97dd4-9327-48f4-b08f-772ddac538a6','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0aa97dd4-9327-48f4-b08f-772ddac538a6.png','SNAPS','PATIENT_2e0a8247-f698-45b5-87fe-8b1e7c952f36_ACT_c322bb17-cc99-4952-afee-c301664dae46_SESS_60be00eb-1942-4992-8625-acc1bb1fcca5_BOSC_cef1cc94-0154-44a9-aa98-009e5a8728f2_SNAPS_','2020-12-02 10:32:27','2020-10-28 15:52:25','0aa97dd4-9327-48f4-b08f-772ddac538a6.png','2020-12-02 11:32:27','SYNCED','0aa97dd4-9327-48f4-b08f-772ddac538a6',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.35.8.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0ab0510a-ebff-4fd2-8cf5-e1390d2efd4a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0ab0510a-ebff-4fd2-8cf5-e1390d2efd4a.ply','PLY','PATIENT_b05365ce-c2cb-486f-87ab-07c0f40087a7_ACT_2b904d7d-0977-4bc2-b584-6dc212301d2b_SESS_dd04506b-ac97-4cab-91c9-a8dc8ded2291_TOSC_94919845-a791-4233-8ef5-d18f569e2ced_PLY_','2021-03-16 11:08:14','2021-03-16 11:59:57','0ab0510a-ebff-4fd2-8cf5-e1390d2efd4a.ply','2021-03-16 12:08:14','SYNCED','0ab0510a-ebff-4fd2-8cf5-e1390d2efd4a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.78.1.3\",\"modelMatrix\":\"0.819462,-0.512261,0.257042,0,0.573134,0.732427,-0.367517,0,2.71644e-9,0.448486,0.89379,0,6.0144,-31.3275,-20.2972,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0abd403b-e3d0-4b19-a2ea-2754d03e67a4','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0abd403b-e3d0-4b19-a2ea-2754d03e67a4.png','SNAPS','PATIENT_5395de2a-3e1b-4529-9228-013d95e10923_ACT_af49ac58-70c2-4dcc-bdb7-2e4609c4f4cf_SESS_92e8f968-bfab-4e1b-aae8-78b9df3a1997_BOSC_61f6ebe7-4914-4b1e-b3bd-6776c67192d6_SNAPS_','2020-12-09 11:14:29','2020-12-09 12:14:28','0abd403b-e3d0-4b19-a2ea-2754d03e67a4.png','2020-12-09 12:14:29','SYNCED','0abd403b-e3d0-4b19-a2ea-2754d03e67a4',0,NULL,'','','{\"displayTitle\":\"Mandibule 310.1.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0abdf84f-c0ae-4588-a20c-7a202fa4c830','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0abdf84f-c0ae-4588-a20c-7a202fa4c830.ply','PLY','PATIENT_373ac25e-dd7b-4c18-a1aa-b0e7ff6cd2ac_ACT_a72bddb8-cde0-49e8-86bc-f0cb9ca3574a_SESS_220f1c73-4b99-47ba-b3a7-861726336458_BOSC_ebf54479-376c-4d41-a4e9-b33b8bdee2d8_PLY_','2021-03-26 14:49:33','2021-03-26 15:49:00','0abdf84f-c0ae-4588-a20c-7a202fa4c830.ply','2021-03-26 15:49:33','SYNCED','0abdf84f-c0ae-4588-a20c-7a202fa4c830',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.6.1.3\",\"modelMatrix\":\"0.669168,-0.739056,0.0775218,0,0.743111,0.665517,-0.0698081,0,1.48646e-10,0.104321,0.994544,0,-0.473555,-23.2613,-26.8008,1\",\"title\":\"Mandibule PLY\"}'),(2,'0ac35cc6-229f-4934-8320-7b0b31342e89','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0ac35cc6-229f-4934-8320-7b0b31342e89.ply','PLY','PATIENT_d0bd4250-0d30-49aa-bcfb-0be6d6dc5263_ACT_d33fc66c-5456-4d42-bcc1-8def7e0790c2_SESS_677522a0-efd4-40a2-89b9-2d3510422364_BOSC_c329395e-a9dd-410a-b2e7-c4770cb1cd17_PLY_','2021-01-25 13:48:38','2021-01-25 14:46:08','0ac35cc6-229f-4934-8320-7b0b31342e89.ply','2021-01-25 14:48:38','SYNCED','0ac35cc6-229f-4934-8320-7b0b31342e89',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.20.1.2\",\"modelMatrix\":\"-0.909829,0.403347,-0.0975846,0,-0.414984,-0.884316,0.213949,0,-4.06018e-9,0.235153,0.971958,0,-6.84997,16.6852,-18.5942,1\",\"title\":\"Mandibule PLY\"}'),(2,'0acb7283-1d94-428b-916d-677f332440cc','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0acb7283-1d94-428b-916d-677f332440cc.ply','PLY','PATIENT_67c10a45-b4ec-42ba-ae2c-900a195adb87_ACT_86b9837f-894c-450e-be34-50dce2fbdc92_SESS_11baa7ef-ca17-442b-a5da-1d859ce1c951_TOSC_ac047e44-8462-4977-a9f4-84b2517681ab_PLY_','2021-12-30 18:03:17','2019-10-14 11:11:56','0acb7283-1d94-428b-916d-677f332440cc.ply','2021-12-30 19:03:17','SYNCED','0acb7283-1d94-428b-916d-677f332440cc',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.19.1.1\",\"modelMatrix\":\"0.534199,-0.8234,0.191423,0,0.845359,0.520323,-0.120964,0,9.34479e-10,0.22644,0.974025,0,-3.96586,-29.2976,-17.9656,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0acbffd9-1150-40cb-b4a4-8eca5cf94553','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0acbffd9-1150-40cb-b4a4-8eca5cf94553.ply','PLY','PATIENT_8d82ec2a-5aab-4c9b-b6ad-36b7d5ee6b2e_ACT_10218071-9e0c-43c4-85ff-32ab432e2d0c_SESS_24753abd-8bfd-4d4a-9076-ac7545bfde80_TOSC_eda85daf-d64f-445f-9ca4-6a217ed99fe0_PLY_','2022-02-01 11:47:26','2019-07-22 12:15:15','0acbffd9-1150-40cb-b4a4-8eca5cf94553.ply','2022-02-01 12:47:26','SYNCED','0acbffd9-1150-40cb-b4a4-8eca5cf94553',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 105.1.1.1\",\"modelMatrix\":\"0.444408,-0.849926,0.283069,0,0.895824,0.421638,-0.140427,0,-1.23332e-8,0.315987,0.948763,0,-6.05735,-35.8179,-18.2183,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0ad6aad5-93c2-449b-91ff-2b177af292e2','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0ad6aad5-93c2-449b-91ff-2b177af292e2.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_8b1a8041-7252-4342-a894-c9a378f280ee_SESS_d97ea491-294b-4f2b-b9e3-d090d3f4fc43_BOSC_15765cd4-8b8e-4f67-95af-ebc92fe8dba3_PLY_','2021-04-26 13:33:46','2021-04-26 15:33:44','0ad6aad5-93c2-449b-91ff-2b177af292e2.ply','2021-04-26 15:33:46','SYNCED','0ad6aad5-93c2-449b-91ff-2b177af292e2',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.106.1.1\",\"modelMatrix\":\"-0.948859,-0.308734,0.065958,0,0.315701,-0.927919,0.198241,0,3.58415e-9,0.208925,0.977931,0,-29.9854,2.49843,-16.8696,1\",\"title\":\"Mandibule PLY\"}'),(2,'0ade33e3-5937-487e-abb4-c7a88ed05f5c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0ade33e3-5937-487e-abb4-c7a88ed05f5c.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_954b47ba-ba6d-4313-94a7-de9f691b5962_SESS_ed6d5298-a7f9-49d9-aeb4-e11336e2e533_TOSC_90121022-d02d-4551-80e5-6210908427db_SNAPS_','2022-02-24 10:22:18','2022-02-24 11:22:11','0ade33e3-5937-487e-abb4-c7a88ed05f5c.png','2022-02-24 11:22:18','SYNCED','0ade33e3-5937-487e-abb4-c7a88ed05f5c',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.25.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0adf659c-e355-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0adf659c-e355-11e9-947d-226cec7cb58a.stl','STL','PATIENT_7dec86c0-1085-463b-888a-3363184a2fec_ACT_054e3d99-a38e-4dbd-adc8-33dbc93198c7_SESS_853ab549-f561-4849-8acd-2ec1e14f57fc_TOSC_5916611b-ff0e-465b-ad25-89420f1e6066_STL_','2022-02-01 11:47:26','2019-09-30 09:31:25','0adf659c-e355-11e9-947d-226cec7cb58a.stl','2022-02-01 12:47:26','SYNCED','0adf659c-e355-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 45.1.1.1\",\"modelMatrix\":\"0.531945,-0.755195,0.383034,0,0.846779,0.474413,-0.240621,0,1.30923e-9,0.452342,0.891844,0,-0.207042,-33.9745,-18.8016,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'0ae17ece-e355-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0ae17ece-e355-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_7dec86c0-1085-463b-888a-3363184a2fec_ACT_054e3d99-a38e-4dbd-adc8-33dbc93198c7_SESS_853ab549-f561-4849-8acd-2ec1e14f57fc_TOSC_5916611b-ff0e-465b-ad25-89420f1e6066_SNAPS_','2022-02-01 11:47:26','2019-09-30 09:31:25','0ae17ece-e355-11e9-947d-226cec7cb58a.png','2022-02-01 12:47:26','SYNCED','0ae17ece-e355-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 45.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0ae2ee37-e355-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0ae2ee37-e355-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_7dec86c0-1085-463b-888a-3363184a2fec_ACT_054e3d99-a38e-4dbd-adc8-33dbc93198c7_SESS_853ab549-f561-4849-8acd-2ec1e14f57fc_TOSC_5916611b-ff0e-465b-ad25-89420f1e6066_PLY_','2022-02-01 11:47:26','2019-09-30 09:31:25','0ae2ee37-e355-11e9-947d-226cec7cb58a.ply','2022-02-01 12:47:26','SYNCED','0ae2ee37-e355-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 45.1.1.1\",\"modelMatrix\":\"0.531945,-0.755195,0.383034,0,0.846779,0.474413,-0.240621,0,1.30923e-9,0.452342,0.891844,0,-0.207042,-33.9745,-18.8016,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0ae2f61e-97a1-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0ae2f61e-97a1-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_11101b3c-2101-42ce-97c5-aec79796db62_SESS_0855b14f-76dd-4f90-a794-b6e424964bfb_TOSC_d9139df7-c760-480c-abbb-bfadaad2b510_SNAPS_','2021-04-07 12:31:18','2021-04-07 14:31:16','0ae2f61e-97a1-11eb-9377-226cec7cb58a.png','2021-04-07 14:31:18','SYNCED','0ae2f61e-97a1-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.3.16.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0ae48b23-e355-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0ae48b23-e355-11e9-947d-226cec7cb58a.stl','STL','PATIENT_7dec86c0-1085-463b-888a-3363184a2fec_ACT_054e3d99-a38e-4dbd-adc8-33dbc93198c7_SESS_853ab549-f561-4849-8acd-2ec1e14f57fc_BOSC_c199af24-d81f-409c-bf2d-51044e8d1a0e_STL_','2022-02-01 11:47:26','2019-09-30 09:35:36','0ae48b23-e355-11e9-947d-226cec7cb58a.stl','2022-02-01 12:47:26','SYNCED','0ae48b23-e355-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 45.1.1.1\",\"modelMatrix\":\"-0.737863,0.672926,-0.0522281,0,-0.67495,-0.735651,0.0570963,0,1.38662e-9,0.0773806,0.997002,0,-7.34162,26.1681,-26.7786,1\",\"title\":\"MANDIBULE STL\"}'),(2,'0ae61a27-e355-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0ae61a27-e355-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_7dec86c0-1085-463b-888a-3363184a2fec_ACT_054e3d99-a38e-4dbd-adc8-33dbc93198c7_SESS_853ab549-f561-4849-8acd-2ec1e14f57fc_BOSC_c199af24-d81f-409c-bf2d-51044e8d1a0e_PLY_','2022-02-01 11:47:27','2019-09-30 09:35:36','0ae61a27-e355-11e9-947d-226cec7cb58a.ply','2022-02-01 12:47:27','SYNCED','0ae61a27-e355-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 45.1.1.1\",\"modelMatrix\":\"-0.737863,0.672926,-0.0522281,0,-0.67495,-0.735651,0.0570963,0,1.38662e-9,0.0773806,0.997002,0,-7.34162,26.1681,-26.7786,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0ae6419e-97a1-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0ae6419e-97a1-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_11101b3c-2101-42ce-97c5-aec79796db62_SESS_0855b14f-76dd-4f90-a794-b6e424964bfb_BOSC_135cda03-b49f-42f5-ad0e-df63245cf7d6_SNAPS_','2021-04-07 12:43:02','2021-04-07 14:43:00','0ae6419e-97a1-11eb-9377-226cec7cb58a.png','2021-04-07 14:43:02','SYNCED','0ae6419e-97a1-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.16.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0ae76b4e-e355-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0ae76b4e-e355-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_7dec86c0-1085-463b-888a-3363184a2fec_ACT_054e3d99-a38e-4dbd-adc8-33dbc93198c7_SESS_853ab549-f561-4849-8acd-2ec1e14f57fc_BOSC_c199af24-d81f-409c-bf2d-51044e8d1a0e_SNAPS_','2022-02-01 11:47:27','2019-09-30 09:35:36','0ae76b4e-e355-11e9-947d-226cec7cb58a.png','2022-02-01 12:47:27','SYNCED','0ae76b4e-e355-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 45.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0ae76e33-dfec-4e0c-8471-68f81312dcc4','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0ae76e33-dfec-4e0c-8471-68f81312dcc4.png','SNAPS','PATIENT_1fff6898-79c5-4b7a-8ae6-ae2af9a8cbe4_ACT_c988658e-e313-4d11-9672-2c295b7584a6_SESS_db3f12ec-05bf-4d4c-a595-6a4620d49fae_TOSC_ec53d847-39f7-424f-8508-5ef0c1545647_SNAPS_','2022-02-01 11:47:28','2019-09-23 16:37:49','0ae76e33-dfec-4e0c-8471-68f81312dcc4.png','2022-02-01 12:47:28','SYNCED','0ae76e33-dfec-4e0c-8471-68f81312dcc4',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 162.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0ae8b1e9-1ccf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0ae8b1e9-1ccf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_0dc4f506-9fce-480c-982e-216990922429_ACT_ed8a1fc3-a794-4c54-a67e-f97b524d231f_SESS_855c3013-3b21-4f57-9d52-c7a464ee9f30_TOSC_ae0bb8f3-9c17-435e-b1bd-87507c964bae_SNAPS_','2021-01-06 11:02:17','2019-12-12 11:54:12','0ae8b1e9-1ccf-11ea-947d-226cec7cb58a.png','2021-01-06 12:02:17','SYNCED','0ae8b1e9-1ccf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 232.10.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0ae90fbb-97a1-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0ae90fbb-97a1-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_11101b3c-2101-42ce-97c5-aec79796db62_SESS_0855b14f-76dd-4f90-a794-b6e424964bfb_TOSC_c0bcc34a-857c-47da-9d2a-8cc01b964c7c_SNAPS_','2021-04-07 12:24:05','2021-04-07 14:24:03','0ae90fbb-97a1-11eb-9377-226cec7cb58a.png','2021-04-07 14:24:05','SYNCED','0ae90fbb-97a1-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.3.16.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0aea0507-1ccf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0aea0507-1ccf-11ea-947d-226cec7cb58a.stl','STL','PATIENT_0dc4f506-9fce-480c-982e-216990922429_ACT_ed8a1fc3-a794-4c54-a67e-f97b524d231f_SESS_855c3013-3b21-4f57-9d52-c7a464ee9f30_BOSC_6209ee8c-34a1-499e-b00b-1711f30ddf77_STL_','2021-01-06 11:02:18','2019-12-12 12:01:26','0aea0507-1ccf-11ea-947d-226cec7cb58a.stl','2021-01-06 12:02:18','SYNCED','0aea0507-1ccf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 232.10.1.1\",\"modelMatrix\":\"-0.992458,0.121287,-0.017786,0,-0.122584,-0.981956,0.143998,0,3.27737e-10,0.145093,0.989418,0,-15.0188,19.9604,-23.0852,1\",\"title\":\"MANDIBULE STL\"}'),(2,'0aeab801-ad5e-4d50-811d-33a771aa12a9','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0aeab801-ad5e-4d50-811d-33a771aa12a9.ply','PLY','PATIENT_d4967e19-0c25-4372-a1c0-fce39834d889_ACT_7a6e9856-edb8-4cfb-8c77-b4c448b6babc_SESS_dc71eec0-e740-48be-9129-148506c48a96_TOSC_e2c23907-8e40-448f-a840-6a81807d42b7_PLY_','2021-01-26 08:44:44','2021-01-26 09:40:46','0aeab801-ad5e-4d50-811d-33a771aa12a9.ply','2021-01-26 09:44:44','SYNCED','0aeab801-ad5e-4d50-811d-33a771aa12a9',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.22.1.2\",\"modelMatrix\":\"-0.984627,0.17208,-0.0299732,0,-0.174671,-0.970022,0.16896,0,-1.29655e-9,0.171598,0.985167,0,-17.3745,16.9423,-18.0338,1\",\"title\":\"Mandibule PLY\"}'),(2,'0aeb8512-1ccf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0aeb8512-1ccf-11ea-947d-226cec7cb58a.stl','STL','PATIENT_0dc4f506-9fce-480c-982e-216990922429_ACT_ed8a1fc3-a794-4c54-a67e-f97b524d231f_SESS_855c3013-3b21-4f57-9d52-c7a464ee9f30_TOSC_ae0bb8f3-9c17-435e-b1bd-87507c964bae_STL_','2021-01-06 11:02:18','2019-12-12 11:54:12','0aeb8512-1ccf-11ea-947d-226cec7cb58a.stl','2021-01-06 12:02:18','SYNCED','0aeb8512-1ccf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 232.10.1.1\",\"modelMatrix\":\"0.528126,-0.820693,0.218051,0,0.849166,0.510418,-0.135613,0,7.4386e-9,0.256782,0.966469,0,1.61407,-37.5502,-19.5006,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'0aec3969-97a1-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0aec3969-97a1-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_11101b3c-2101-42ce-97c5-aec79796db62_SESS_0855b14f-76dd-4f90-a794-b6e424964bfb_BOSC_5ca76776-4365-43ce-bdfd-c355cf7406f5_PLY_','2021-04-07 12:47:10','2021-04-07 14:47:08','0aec3969-97a1-11eb-9377-226cec7cb58a.ply','2021-04-07 14:47:10','SYNCED','0aec3969-97a1-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.16.1.3\",\"modelMatrix\":\"-0.9202,-0.385522,0.0678526,0,0.391448,-0.906271,0.159505,0,-2.27736e-9,0.173337,0.984863,0,19.0002,26.7435,-17.2453,1\",\"title\":\"Mandibule PLY\"}'),(2,'0aed0572-1ccf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0aed0572-1ccf-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_0dc4f506-9fce-480c-982e-216990922429_ACT_ed8a1fc3-a794-4c54-a67e-f97b524d231f_SESS_855c3013-3b21-4f57-9d52-c7a464ee9f30_BOSC_6209ee8c-34a1-499e-b00b-1711f30ddf77_SNAPS_','2021-01-06 11:02:18','2019-12-12 12:01:26','0aed0572-1ccf-11ea-947d-226cec7cb58a.png','2021-01-06 12:02:18','SYNCED','0aed0572-1ccf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 232.10.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0aee7d8c-1ccf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0aee7d8c-1ccf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_0dc4f506-9fce-480c-982e-216990922429_ACT_ed8a1fc3-a794-4c54-a67e-f97b524d231f_SESS_855c3013-3b21-4f57-9d52-c7a464ee9f30_TOSC_ae0bb8f3-9c17-435e-b1bd-87507c964bae_PLY_','2021-01-06 11:02:18','2019-12-12 11:54:12','0aee7d8c-1ccf-11ea-947d-226cec7cb58a.ply','2021-01-06 12:02:18','SYNCED','0aee7d8c-1ccf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 232.10.1.1\",\"modelMatrix\":\"0.528126,-0.820693,0.218051,0,0.849166,0.510418,-0.135613,0,7.4386e-9,0.256782,0.966469,0,1.61407,-37.5502,-19.5006,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0aeeebc6-87f7-4b7d-9daa-d65ef707290d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0aeeebc6-87f7-4b7d-9daa-d65ef707290d.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_2e136b79-6886-4f2a-b8b4-effe8e330226_SESS_2b9d3f75-c75f-47e7-8d78-6795d0921fc8_BOSC_13b831d0-c7f2-49cc-b5ed-92838546bbec_SNAPS_','2022-01-18 13:37:37','2022-01-18 14:37:33','0aeeebc6-87f7-4b7d-9daa-d65ef707290d.png','2022-01-18 14:37:37','SYNCED','0aeeebc6-87f7-4b7d-9daa-d65ef707290d',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.14.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0af0067b-1ccf-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0af0067b-1ccf-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_0dc4f506-9fce-480c-982e-216990922429_ACT_ed8a1fc3-a794-4c54-a67e-f97b524d231f_SESS_855c3013-3b21-4f57-9d52-c7a464ee9f30_BOSC_6209ee8c-34a1-499e-b00b-1711f30ddf77_PLY_','2021-01-06 11:02:18','2019-12-12 12:01:26','0af0067b-1ccf-11ea-947d-226cec7cb58a.ply','2021-01-06 12:02:18','SYNCED','0af0067b-1ccf-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 232.10.1.1\",\"modelMatrix\":\"-0.992458,0.121287,-0.017786,0,-0.122584,-0.981956,0.143998,0,3.27737e-10,0.145093,0.989418,0,-15.0188,19.9604,-23.0852,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0af0254f-97a1-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0af0254f-97a1-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_11101b3c-2101-42ce-97c5-aec79796db62_SESS_0855b14f-76dd-4f90-a794-b6e424964bfb_TOSC_c0bcc34a-857c-47da-9d2a-8cc01b964c7c_PLY_','2021-04-07 12:54:32','2021-04-07 14:54:30','0af0254f-97a1-11eb-9377-226cec7cb58a.ply','2021-04-07 14:54:32','SYNCED','0af0254f-97a1-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.3.16.1.1\",\"modelMatrix\":\"0.356315,0.885747,-0.297474,0,-0.934366,0.337775,-0.11344,0,-2.92993e-9,0.31837,0.947966,0,10.6372,-37.3326,-13.2677,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0af35f16-97a1-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0af35f16-97a1-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_11101b3c-2101-42ce-97c5-aec79796db62_SESS_0855b14f-76dd-4f90-a794-b6e424964bfb_BOSC_c3c43369-c169-48fb-8984-0b37f4988fbd_PLY_','2021-04-07 12:55:34','2021-04-07 14:55:33','0af35f16-97a1-11eb-9377-226cec7cb58a.ply','2021-04-07 14:55:34','SYNCED','0af35f16-97a1-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.16.1.1\",\"modelMatrix\":\"-0.49757,-0.866577,0.0383218,0,0.867424,-0.497084,0.0219821,0,-2.13303e-9,0.0441789,0.999023,0,-2.61732,33.6221,-16.734,1\",\"title\":\"Mandibule PLY\"}'),(2,'0af66b7b-ba51-43d8-88c9-d104cd77ec5c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0af66b7b-ba51-43d8-88c9-d104cd77ec5c.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_e5f1c2aa-5cd5-42b0-bae4-c7c20d558f23_SESS_99a900a8-53a6-4b5a-9bed-10588f7a7523_TOSC_d8c1a728-96ac-4e54-80d7-012a50698b6a_SNAPS_','2021-05-31 08:07:30','2021-05-31 10:07:28','0af66b7b-ba51-43d8-88c9-d104cd77ec5c.png','2021-05-31 10:07:30','SYNCED','0af66b7b-ba51-43d8-88c9-d104cd77ec5c',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.164.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0af69edc-97a1-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0af69edc-97a1-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_11101b3c-2101-42ce-97c5-aec79796db62_SESS_0855b14f-76dd-4f90-a794-b6e424964bfb_TOSC_c8df0854-4a7f-4452-9efe-4eff28dc8dc7_SNAPS_','2021-04-07 12:27:16','2021-04-07 14:27:14','0af69edc-97a1-11eb-9377-226cec7cb58a.png','2021-04-07 14:27:16','SYNCED','0af69edc-97a1-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.3.16.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0af74f43-54bb-4bb8-b55d-c34b0de5ce5b','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0af74f43-54bb-4bb8-b55d-c34b0de5ce5b.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_1a8f8e24-4f8c-415e-9785-f7c253cd36bb_SESS_862bc675-f1b3-4839-b6c5-331442ee62f4_TOSC_045e1453-700e-49e9-a127-0bb45c72971d_SNAPS_','2021-04-26 08:43:32','2021-04-26 10:43:29','0af74f43-54bb-4bb8-b55d-c34b0de5ce5b.png','2021-04-26 10:43:32','SYNCED','7ce28d7d-512f-479d-baca-cbe7c7fc6638',1,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.99.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0af92cc2-dda7-4441-8281-2da2b6ed926a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0af92cc2-dda7-4441-8281-2da2b6ed926a.png','SNAPS','PATIENT_5eb7abc4-d0cc-450f-9e7a-604c0f9351ff_ACT_10ab35a8-5264-4163-af13-7213405a8e68_SESS_90aa3626-8319-4317-a65b-5406f818f772_BOSC_073d37c3-c84a-4a22-a7ac-4e8fd5757bba_SNAPS_','2022-03-04 13:40:23','2019-07-11 11:08:20','0af92cc2-dda7-4441-8281-2da2b6ed926a.png','2022-03-04 14:40:23','SYNCED','0af92cc2-dda7-4441-8281-2da2b6ed926a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 39.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0afa9656-97a1-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0afa9656-97a1-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_11101b3c-2101-42ce-97c5-aec79796db62_SESS_0855b14f-76dd-4f90-a794-b6e424964bfb_BOSC_135cda03-b49f-42f5-ad0e-df63245cf7d6_PLY_','2021-04-07 12:56:00','2021-04-07 14:55:59','0afa9656-97a1-11eb-9377-226cec7cb58a.ply','2021-04-07 14:56:00','SYNCED','0afa9656-97a1-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.16.1.2\",\"modelMatrix\":\"1,-0.000467072,0.000237162,0,0.000523834,0.891641,-0.452743,0,-4.13846e-12,0.452743,0.891641,0,-15.5849,14.8698,-19.1465,1\",\"title\":\"Mandibule PLY\"}'),(2,'0afde6fa-97a1-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0afde6fa-97a1-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_11101b3c-2101-42ce-97c5-aec79796db62_SESS_0855b14f-76dd-4f90-a794-b6e424964bfb_BOSC_5ca76776-4365-43ce-bdfd-c355cf7406f5_SNAPS_','2021-04-07 12:47:09','2021-04-07 14:47:08','0afde6fa-97a1-11eb-9377-226cec7cb58a.png','2021-04-07 14:47:09','SYNCED','0afde6fa-97a1-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.16.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0afed30c-4432-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0afed30c-4432-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_02187354-bba8-452a-b51b-9fdee38ff259_ACT_52815b84-f366-4ee6-a46d-a6e9066ada25_SESS_9425e6c4-f103-4ced-928e-fa239e582e3d_BOSC_72662b68-6568-4dec-9645-da3b21fbb2b2_PLY_','2020-12-16 10:52:23','2020-01-31 14:57:07','0afed30c-4432-11ea-947d-226cec7cb58a.ply','2020-12-16 11:52:23','SYNCED','0afed30c-4432-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"modelMatrix\":\"-0.863798,0.48712,-0.128711,0,-0.503838,-0.835137,0.220666,0,-4.71987e-9,0.25546,0.966819,0,-0.651488,14.7576,-24.5508,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0b013a2b-97a1-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b013a2b-97a1-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_11101b3c-2101-42ce-97c5-aec79796db62_SESS_0855b14f-76dd-4f90-a794-b6e424964bfb_TOSC_d9139df7-c760-480c-abbb-bfadaad2b510_PLY_','2021-04-07 12:55:14','2021-04-07 14:55:13','0b013a2b-97a1-11eb-9377-226cec7cb58a.ply','2021-04-07 14:55:14','SYNCED','0b013a2b-97a1-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.3.16.1.3\",\"modelMatrix\":\"0.517902,0.768866,-0.374996,0,-0.85544,0.465488,-0.227031,0,1.65565e-8,0.438366,0.898796,0,3.40685,-39.2871,-11.3267,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0b036349-4432-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b036349-4432-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_02187354-bba8-452a-b51b-9fdee38ff259_ACT_52815b84-f366-4ee6-a46d-a6e9066ada25_SESS_9425e6c4-f103-4ced-928e-fa239e582e3d_BOSC_72662b68-6568-4dec-9645-da3b21fbb2b2_SNAPS_','2020-12-16 10:52:24','2020-01-31 14:57:07','0b036349-4432-11ea-947d-226cec7cb58a.png','2020-12-16 11:52:24','SYNCED','0b036349-4432-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0b04eeff-15a6-45cc-bf5b-4baa9c42ea3d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b04eeff-15a6-45cc-bf5b-4baa9c42ea3d.png','SNAPS','PATIENT_21f6476a-e07a-40e0-8ac4-f05e512f3e7d_ACT_9f394a6f-c380-47c1-9eab-ff46399f6197_SESS_c9ec17f4-bf0a-492f-87da-1f7550b49119_BOSC_e0c0ae20-9b2e-46bf-936c-fada35e02d52_SNAPS_','2020-12-16 11:08:15','2020-01-21 14:31:03','0b04eeff-15a6-45cc-bf5b-4baa9c42ea3d.png','2020-12-16 12:08:15','SYNCED','0b04eeff-15a6-45cc-bf5b-4baa9c42ea3d',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0b052877-4432-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b052877-4432-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_52815b84-f366-4ee6-a46d-a6e9066ada25_SESS_9425e6c4-f103-4ced-928e-fa239e582e3d_TOSC_6bc03acb-0176-4c4c-8675-d848ebe274b8_SNAPS_','2020-12-16 10:52:24','2020-01-31 15:00:05','0b052877-4432-11ea-947d-226cec7cb58a.png','2020-12-16 11:52:24','SYNCED','0b052877-4432-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.2\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0b072065-4432-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b072065-4432-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_52815b84-f366-4ee6-a46d-a6e9066ada25_SESS_9425e6c4-f103-4ced-928e-fa239e582e3d_TOSC_6bc03acb-0176-4c4c-8675-d848ebe274b8_PLY_','2020-12-16 10:52:24','2020-01-31 15:00:05','0b072065-4432-11ea-947d-226cec7cb58a.ply','2020-12-16 11:52:24','SYNCED','0b072065-4432-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.2\",\"modelMatrix\":\"0.953728,-0.286941,0.089826,0,0.300672,0.910172,-0.284927,0,-2.68992e-9,0.298751,0.954331,0,19.8908,-32.196,-15.5893,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0b08572e-0b11-4628-babd-05a506c24060','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b08572e-0b11-4628-babd-05a506c24060.stl','STL','PATIENT_b07384f8-83d9-4f6c-859b-96adaea8e7c0_ACT_c06769e9-07b5-4084-85aa-73bd7bfc7f7b_SESS_33427a38-fc45-41ba-9b48-8437b5d15a18_BOSC_928b0458-34c3-4dc2-b7ba-8ad33d28b263_STL_','2021-08-19 22:26:58','2019-12-06 09:42:41','0b08572e-0b11-4628-babd-05a506c24060.stl','2021-08-20 00:26:58','SYNCED','0b08572e-0b11-4628-babd-05a506c24060',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 225.1.1.1\",\"modelMatrix\":\"-0.838557,0.526228,-0.14109,0,-0.544814,-0.80995,0.21716,0,-1.4875e-9,0.258968,0.965886,0,-7.8237,20.7557,-18.7482,1\",\"title\":\"MANDIBULE STL\"}'),(2,'0b1162e4-205e-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b1162e4-205e-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_a818194f-f315-47d9-811f-4569a6c04938_SESS_0c53cc6b-69b0-4ced-ac82-98f7e8c9e249_BOSC_5b0f05a9-ea88-4372-b4a3-bc438e033218_SNAPS_','2021-09-28 13:04:50','2021-09-28 15:04:45','0b1162e4-205e-11ec-9377-226cec7cb58a.png','2021-09-28 15:04:50','SYNCED','0b1162e4-205e-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.22.30.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0b133cd2-4c34-46d2-b011-4ed64564e26f','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b133cd2-4c34-46d2-b011-4ed64564e26f.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_54ef530e-fe95-453d-b6ca-fcf4e17dfdf6_SESS_1e5ae9d8-b0b0-4c65-992b-0f2fdad9ac99_TOSC_348ee4b0-c969-4b48-a58f-289cedfcf12c_SNAPS_','2021-04-27 09:34:05','2021-04-27 11:34:04','0b133cd2-4c34-46d2-b011-4ed64564e26f.png','2021-04-27 11:34:05','SYNCED','0b133cd2-4c34-46d2-b011-4ed64564e26f',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.113.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0b1439bc-0811-4e07-beac-fe9e648f3198','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b1439bc-0811-4e07-beac-fe9e648f3198.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_95d5930b-0b43-4f24-bf97-a2271403ddf0_SESS_57d899f4-623d-4b8f-a193-44c933d6643b_BOSC_8a4bca17-af39-46c2-9ad8-703685246f4f_SNAPS_','2020-12-08 17:26:56','2020-06-26 16:06:20','0b1439bc-0811-4e07-beac-fe9e648f3198.png','2020-12-08 18:26:56','SYNCED','0b1439bc-0811-4e07-beac-fe9e648f3198',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.87.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0b1680fe-205e-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b1680fe-205e-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_a818194f-f315-47d9-811f-4569a6c04938_SESS_0c53cc6b-69b0-4ced-ac82-98f7e8c9e249_BOSC_4b87b2d4-c807-41b9-b390-92effc5aa71a_ZIP_','2021-09-28 13:08:40','2021-09-28 15:08:37','0b1680fe-205e-11ec-9377-226cec7cb58a.zip','2021-09-28 15:08:40','SYNCED','0b1680fe-205e-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.22.30.1.2\",\"modelMatrix\":\"0.989602,-0.134266,0.0515759,0,0.143831,0.92379,-0.354857,0,1.77114e-9,0.358586,0.933497,0,-14.9799,16.3617,-19.7376,1\",\"title\":\"Mandibule ZIP\"}'),(2,'0b18e22f-5ce4-43b6-b86d-b4c763f38708','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b18e22f-5ce4-43b6-b86d-b4c763f38708.png','SNAPS','PATIENT_43c1b7ed-7638-4b84-9b7f-a4db0a8e6871_ACT_102b396e-2a8d-40cd-b532-d6908f96afba_SESS_55df8386-161d-41e5-9193-6a8cff216403_TOSC_85b8be30-aa98-423b-818b-9883c20eb25f_SNAPS_','2021-01-06 13:36:42','2021-01-06 14:36:41','0b18e22f-5ce4-43b6-b86d-b4c763f38708.png','2021-01-06 14:36:42','SYNCED','0b18e22f-5ce4-43b6-b86d-b4c763f38708',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.123.2.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0b19b30d-205e-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b19b30d-205e-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_a818194f-f315-47d9-811f-4569a6c04938_SESS_0c53cc6b-69b0-4ced-ac82-98f7e8c9e249_TOSC_7cb820c7-bc37-42cf-a6cc-add6bf6c8fc4_SNAPS_','2021-09-28 12:55:03','2021-09-28 14:54:58','0b19b30d-205e-11ec-9377-226cec7cb58a.png','2021-09-28 14:55:03','SYNCED','0b19b30d-205e-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.3.22.30.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0b1a573c-dc01-48bf-8e24-1490b5fa13f2','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b1a573c-dc01-48bf-8e24-1490b5fa13f2.png','SNAPS','PATIENT_e7d00f8c-583d-463b-bcf0-f0cece8f4723_ACT_dc5bd605-ebd8-4028-83b1-237c381260a7_SESS_fbf11919-596b-49e8-bf54-4613cb6cf648_TOSC_f4f23a6a-16be-47a9-ba96-88d76685d40c_SNAPS_','2020-12-02 10:32:30','2020-11-10 17:11:26','0b1a573c-dc01-48bf-8e24-1490b5fa13f2.png','2020-12-02 11:32:30','SYNCED','0b1a573c-dc01-48bf-8e24-1490b5fa13f2',0,NULL,'','','{\"displayTitle\":\"Maxillaire 64.1.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0b1b7a3e-08f9-45a3-8852-353f7c2f6c9e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b1b7a3e-08f9-45a3-8852-353f7c2f6c9e.ply','PLY','PATIENT_fb16dcc9-db70-4594-aac7-ba84a6cbc732_ACT_bc733c99-f7ec-456c-9a8f-b0ed68bdb68b_SESS_0b42597c-73b4-477f-b407-e0ad884ac5d4_BOSC_77567166-3778-4d1e-b977-763196d42b91_PLY_','2020-12-15 15:15:35','2020-12-15 15:58:00','0b1b7a3e-08f9-45a3-8852-353f7c2f6c9e.ply','2020-12-15 16:15:35','SYNCED','0b1b7a3e-08f9-45a3-8852-353f7c2f6c9e',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.38.1.1\",\"modelMatrix\":\"-0.929948,-0.360775,0.0709853,0,0.367692,-0.912453,0.179532,0,3.94952e-9,0.193056,0.981188,0,-23.7748,11.4977,-14.861,1\",\"title\":\"Mandibule PLY\"}'),(2,'0b1d4451-205e-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b1d4451-205e-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_a818194f-f315-47d9-811f-4569a6c04938_SESS_0c53cc6b-69b0-4ced-ac82-98f7e8c9e249_BOSC_5b0f05a9-ea88-4372-b4a3-bc438e033218_ZIP_','2021-09-28 13:04:50','2021-09-28 15:04:47','0b1d4451-205e-11ec-9377-226cec7cb58a.zip','2021-09-28 15:04:50','SYNCED','0b1d4451-205e-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.22.30.1.1\",\"modelMatrix\":\"0.993491,-0.110551,0.0274787,0,0.113914,0.964153,-0.239652,0,1.90775e-10,0.241222,0.97047,0,-14.962,21.2754,-20.7611,1\",\"title\":\"Mandibule ZIP\"}'),(2,'0b1e9486-97a1-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b1e9486-97a1-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_11101b3c-2101-42ce-97c5-aec79796db62_SESS_0855b14f-76dd-4f90-a794-b6e424964bfb_TOSC_c8df0854-4a7f-4452-9efe-4eff28dc8dc7_PLY_','2021-04-07 12:54:51','2021-04-07 14:54:50','0b1e9486-97a1-11eb-9377-226cec7cb58a.ply','2021-04-07 14:54:51','SYNCED','0b1e9486-97a1-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.3.16.1.2\",\"modelMatrix\":\"0.302231,0.870729,-0.387928,0,-0.953235,0.276072,-0.122996,0,-2.39919e-9,0.406959,0.913446,0,8.50523,-38.1467,-12.4774,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0b1f2701-a4b5-4b39-9fb9-ae4a1d00a32b','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b1f2701-a4b5-4b39-9fb9-ae4a1d00a32b.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_b00211df-b759-499d-a716-90cc64f59960_SESS_dce81dda-337b-44fe-8f17-479774d63561_BOSC_be27de6b-cc1c-4285-925d-a407776c482d_PLY_','2021-04-23 11:46:58','2021-04-23 13:46:56','0b1f2701-a4b5-4b39-9fb9-ae4a1d00a32b.ply','2021-04-23 13:46:58','SYNCED','0b1f2701-a4b5-4b39-9fb9-ae4a1d00a32b',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.94.1.1\",\"modelMatrix\":\"-0.881329,-0.460941,0.103886,0,0.472503,-0.859764,0.193772,0,-5.85367e-9,0.219863,0.975531,0,-24.1317,-7.51725,-21.4714,1\",\"title\":\"Mandibule PLY\"}'),(2,'0b202a29-205e-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b202a29-205e-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_a818194f-f315-47d9-811f-4569a6c04938_SESS_0c53cc6b-69b0-4ced-ac82-98f7e8c9e249_TOSC_4d3558d3-eb17-4e8f-ae98-9bb91ce0d632_SNAPS_','2021-09-28 12:58:53','2021-09-28 14:58:47','0b202a29-205e-11ec-9377-226cec7cb58a.png','2021-09-28 14:58:53','SYNCED','0b202a29-205e-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.3.22.30.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0b212cb6-97a1-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b212cb6-97a1-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_11101b3c-2101-42ce-97c5-aec79796db62_SESS_0855b14f-76dd-4f90-a794-b6e424964bfb_BOSC_c3c43369-c169-48fb-8984-0b37f4988fbd_SNAPS_','2021-04-07 12:39:43','2021-04-07 14:39:42','0b212cb6-97a1-11eb-9377-226cec7cb58a.png','2021-04-07 14:39:43','SYNCED','0b212cb6-97a1-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.16.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0b249944-205e-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b249944-205e-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_a818194f-f315-47d9-811f-4569a6c04938_SESS_0c53cc6b-69b0-4ced-ac82-98f7e8c9e249_TOSC_361493e9-b7e6-4fc7-9337-39db83c44172_ZIP_','2021-09-28 12:49:40','2021-09-28 14:49:35','0b249944-205e-11ec-9377-226cec7cb58a.zip','2021-09-28 14:49:40','SYNCED','0b249944-205e-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.3.22.30.1.1\",\"modelMatrix\":\"-0.140863,0.941519,-0.306103,0,-0.990029,-0.133961,0.0435528,0,-5.02176e-10,0.309186,0.951002,0,-14.7207,-36.9867,-18.267,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'0b254f03-8ca1-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b254f03-8ca1-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_785b2632-9f19-49ff-a48a-6954f917316e_ACT_2d39ec8f-f34c-40fd-a7ae-afc0a3c4fdb6_SESS_3287a70c-ee75-4c66-813e-a769def8222b_TOSC_aba3e414-0e56-4124-b8e5-810d144fd680_SNAPS_','2021-03-24 13:00:50','2021-03-24 13:46:19','0b254f03-8ca1-11eb-9377-226cec7cb58a.png','2021-03-24 14:00:50','SYNCED','0b254f03-8ca1-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.115.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0b285e54-205e-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b285e54-205e-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_a818194f-f315-47d9-811f-4569a6c04938_SESS_0c53cc6b-69b0-4ced-ac82-98f7e8c9e249_BOSC_9eb052fb-3b23-485c-8641-625e405a2ef3_SNAPS_','2021-09-28 13:13:17','2021-09-28 15:13:12','0b285e54-205e-11ec-9377-226cec7cb58a.png','2021-09-28 15:13:17','SYNCED','0b285e54-205e-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.22.30.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0b2b97dc-205e-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b2b97dc-205e-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_a818194f-f315-47d9-811f-4569a6c04938_SESS_0c53cc6b-69b0-4ced-ac82-98f7e8c9e249_BOSC_9eb052fb-3b23-485c-8641-625e405a2ef3_ZIP_','2021-09-28 13:13:17','2021-09-28 15:13:14','0b2b97dc-205e-11ec-9377-226cec7cb58a.zip','2021-09-28 15:13:17','SYNCED','0b2b97dc-205e-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.22.30.1.3\",\"modelMatrix\":\"0.943572,0.328571,-0.0413858,0,-0.331167,0.936175,-0.117918,0,1.50503e-9,0.12497,0.992161,0,-21.0117,14.9204,-20.1921,1\",\"title\":\"Mandibule ZIP\"}'),(2,'0b2baa94-4781-4b84-b73e-36c352bc2454','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b2baa94-4781-4b84-b73e-36c352bc2454.ply','PLY','PATIENT_373efe94-53bb-432c-a2ed-a739e05b9789_ACT_1205fdc3-20e3-46cd-9d9e-df0aab481b6b_SESS_ddaac425-10bf-47b8-986b-406244cbf15f_TOSC_763c476b-a024-4cc6-ac33-f598773d84db_PLY_','2020-12-16 11:08:15','2020-01-21 13:43:08','0b2baa94-4781-4b84-b73e-36c352bc2454.ply','2020-12-16 12:08:15','SYNCED','0b2baa94-4781-4b84-b73e-36c352bc2454',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.1.1.1.1\",\"modelMatrix\":\"0.612646,-0.7273,0.309353,0,0.790357,0.563767,-0.239795,0,-1.72881e-9,0.391409,0.920217,0,1.55771,-31.3894,-15.1173,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0b2c768b-8ca1-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b2c768b-8ca1-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_785b2632-9f19-49ff-a48a-6954f917316e_ACT_2d39ec8f-f34c-40fd-a7ae-afc0a3c4fdb6_SESS_3287a70c-ee75-4c66-813e-a769def8222b_BOSC_47a6f5a0-8615-4321-80b3-c72f52b32d2b_SNAPS_','2021-03-24 13:00:50','2021-03-24 13:59:27','0b2c768b-8ca1-11eb-9377-226cec7cb58a.png','2021-03-24 14:00:50','SYNCED','0b2c768b-8ca1-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.115.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0b2fb33a-8ca1-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b2fb33a-8ca1-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_785b2632-9f19-49ff-a48a-6954f917316e_ACT_2d39ec8f-f34c-40fd-a7ae-afc0a3c4fdb6_SESS_3287a70c-ee75-4c66-813e-a769def8222b_TOSC_dd12e46a-ef17-4fa7-8b87-62e1a3e117a9_PLY_','2021-03-24 13:00:50','2021-03-24 13:51:20','0b2fb33a-8ca1-11eb-9377-226cec7cb58a.ply','2021-03-24 14:00:50','SYNCED','0b2fb33a-8ca1-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.115.1.3\",\"modelMatrix\":\"0.795579,-0.531185,0.29137,0,0.60585,0.697532,-0.382616,0,2.60158e-8,0.480928,0.87676,0,7.11212,-35.1265,-15.6111,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0b30a181-205e-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b30a181-205e-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_a818194f-f315-47d9-811f-4569a6c04938_SESS_0c53cc6b-69b0-4ced-ac82-98f7e8c9e249_TOSC_7cb820c7-bc37-42cf-a6cc-add6bf6c8fc4_ZIP_','2021-09-28 12:55:03','2021-09-28 14:54:59','0b30a181-205e-11ec-9377-226cec7cb58a.zip','2021-09-28 14:55:03','SYNCED','0b30a181-205e-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.3.22.30.1.2\",\"modelMatrix\":\"0.686257,0.689446,-0.231767,0,-0.727359,0.650486,-0.21867,0,-3.76349e-9,0.318642,0.947875,0,-0.3514,-36.1185,-16.2428,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'0b3323f6-8ca1-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b3323f6-8ca1-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_785b2632-9f19-49ff-a48a-6954f917316e_ACT_2d39ec8f-f34c-40fd-a7ae-afc0a3c4fdb6_SESS_3287a70c-ee75-4c66-813e-a769def8222b_BOSC_bed3430c-0f3c-4e0b-bf8d-0933d54d0bcd_PLY_','2021-03-24 13:00:51','2021-03-24 13:56:46','0b3323f6-8ca1-11eb-9377-226cec7cb58a.ply','2021-03-24 14:00:51','SYNCED','0b3323f6-8ca1-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.115.1.2\",\"modelMatrix\":\"-0.932928,-0.343087,0.109256,0,0.360063,-0.888943,0.283083,0,-1.95482e-9,0.303435,0.952852,0,-20.8234,6.56875,-29.3208,1\",\"title\":\"Mandibule PLY\"}'),(2,'0b34a74b-eadd-444a-8da0-7a5a13956fb5','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b34a74b-eadd-444a-8da0-7a5a13956fb5.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_e55e8db9-13ed-447a-892b-db1528f5ca8a_SESS_a3b4b2b0-eb45-4849-8055-c35d4651a7c5_TOSC_d331a511-6f49-4421-b556-b8ca7bba5df7_PLY_','2021-07-21 12:13:44','2021-07-21 14:13:42','0b34a74b-eadd-444a-8da0-7a5a13956fb5.ply','2021-07-21 14:13:44','SYNCED','0b34a74b-eadd-444a-8da0-7a5a13956fb5',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.173.1.2\",\"modelMatrix\":\"0.798161,-0.544396,0.258016,0,0.602444,0.721254,-0.341838,0,3.9573e-10,0.428282,0.903645,0,8.95861,-34.0352,-20.738,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0b351a31-205e-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b351a31-205e-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_a818194f-f315-47d9-811f-4569a6c04938_SESS_0c53cc6b-69b0-4ced-ac82-98f7e8c9e249_TOSC_361493e9-b7e6-4fc7-9337-39db83c44172_SNAPS_','2021-09-28 12:49:41','2021-09-28 14:49:34','0b351a31-205e-11ec-9377-226cec7cb58a.png','2021-09-28 14:49:41','SYNCED','0b351a31-205e-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.3.22.30.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0b36b7b7-8ca1-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b36b7b7-8ca1-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_785b2632-9f19-49ff-a48a-6954f917316e_ACT_2d39ec8f-f34c-40fd-a7ae-afc0a3c4fdb6_SESS_3287a70c-ee75-4c66-813e-a769def8222b_TOSC_dd12e46a-ef17-4fa7-8b87-62e1a3e117a9_SNAPS_','2021-03-24 13:00:51','2021-03-24 13:51:20','0b36b7b7-8ca1-11eb-9377-226cec7cb58a.png','2021-03-24 14:00:51','SYNCED','0b36b7b7-8ca1-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.115.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0b38c97f-205e-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b38c97f-205e-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_a818194f-f315-47d9-811f-4569a6c04938_SESS_0c53cc6b-69b0-4ced-ac82-98f7e8c9e249_TOSC_4d3558d3-eb17-4e8f-ae98-9bb91ce0d632_ZIP_','2021-09-28 12:58:53','2021-09-28 14:58:49','0b38c97f-205e-11ec-9377-226cec7cb58a.zip','2021-09-28 14:58:53','SYNCED','0b38c97f-205e-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.3.22.30.1.3\",\"modelMatrix\":\"-0.277992,0.84937,-0.448655,0,-0.960583,-0.245807,0.12984,0,1.61727e-9,0.467065,0.884223,0,-12.9845,-36.5946,-11.1243,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'0b39579d-8ca1-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b39579d-8ca1-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_785b2632-9f19-49ff-a48a-6954f917316e_ACT_2d39ec8f-f34c-40fd-a7ae-afc0a3c4fdb6_SESS_3287a70c-ee75-4c66-813e-a769def8222b_TOSC_aba3e414-0e56-4124-b8e5-810d144fd680_PLY_','2021-03-24 13:00:51','2021-03-24 13:46:19','0b39579d-8ca1-11eb-9377-226cec7cb58a.ply','2021-03-24 14:00:51','SYNCED','0b39579d-8ca1-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.115.1.1\",\"modelMatrix\":\"0.891684,-0.380314,0.245483,0,0.452659,0.749172,-0.483572,0,-1.72508e-8,0.542313,0.840176,0,11.4568,-33.137,-14.1407,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0b3b84de-aba0-44cd-9dd7-b1579b305d30','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b3b84de-aba0-44cd-9dd7-b1579b305d30.png','SNAPS','PATIENT_7da1c98d-8103-4b55-a8f3-84a1ce2c951b_ACT_0559baca-076e-4d10-b98d-839b7104e5e1_SESS_4a20a374-7067-4593-a215-f2557a95fac7_TOSC_09eed85a-5f33-4efb-b954-ac02193fa2c0_SNAPS_','2022-03-21 12:59:59','2019-11-27 10:14:43','0b3b84de-aba0-44cd-9dd7-b1579b305d30.png','2022-03-21 13:59:59','SYNCED','0b3b84de-aba0-44cd-9dd7-b1579b305d30',0,'2022-03-21 13:59:59','','','{\"displayTitle\":\"MAXILLAIRE 211.3.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0b3bc472-205e-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b3bc472-205e-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_a818194f-f315-47d9-811f-4569a6c04938_SESS_0c53cc6b-69b0-4ced-ac82-98f7e8c9e249_BOSC_4b87b2d4-c807-41b9-b390-92effc5aa71a_SNAPS_','2021-09-28 13:08:40','2021-09-28 15:08:36','0b3bc472-205e-11ec-9377-226cec7cb58a.png','2021-09-28 15:08:40','SYNCED','0b3bc472-205e-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.22.30.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0b3d17b8-8ca1-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b3d17b8-8ca1-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_785b2632-9f19-49ff-a48a-6954f917316e_ACT_2d39ec8f-f34c-40fd-a7ae-afc0a3c4fdb6_SESS_3287a70c-ee75-4c66-813e-a769def8222b_BOSC_47a6f5a0-8615-4321-80b3-c72f52b32d2b_PLY_','2021-03-24 13:00:50','2021-03-24 13:59:27','0b3d17b8-8ca1-11eb-9377-226cec7cb58a.ply','2021-03-24 14:00:50','SYNCED','0b3d17b8-8ca1-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.115.1.3\",\"modelMatrix\":\"-0.594651,0.803425,-0.029986,0,-0.803984,-0.594237,0.0221785,0,1.89468e-9,0.0372967,0.999304,0,5.57031,22.7437,-20.3754,1\",\"title\":\"Mandibule PLY\"}'),(2,'0b405f3e-9445-423a-ad92-b9c03e771b14','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b405f3e-9445-423a-ad92-b9c03e771b14.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_95d6af56-dcdc-4669-b45d-978263096204_SESS_00d8d0f6-ec30-4333-9579-e394d310e93a_TOSC_1ae11341-8709-45ae-98d8-7986921894e4_ZIP_','2022-03-31 08:33:36','2022-03-31 10:33:33','0b405f3e-9445-423a-ad92-b9c03e771b14.zip','2022-03-31 10:33:36','SYNCED','0b405f3e-9445-423a-ad92-b9c03e771b14',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.49.1.1\",\"modelMatrix\":\"0.524707,-0.809588,0.263153,0,0.851283,0.499008,-0.1622,0,-1.72449e-11,0.309125,0.951021,0,2.20471,-43.6214,-18.6376,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'0b40ad65-8ca1-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b40ad65-8ca1-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_785b2632-9f19-49ff-a48a-6954f917316e_ACT_2d39ec8f-f34c-40fd-a7ae-afc0a3c4fdb6_SESS_3287a70c-ee75-4c66-813e-a769def8222b_BOSC_bed3430c-0f3c-4e0b-bf8d-0933d54d0bcd_SNAPS_','2021-03-24 13:00:51','2021-03-24 13:56:46','0b40ad65-8ca1-11eb-9377-226cec7cb58a.png','2021-03-24 14:00:51','SYNCED','0b40ad65-8ca1-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.115.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0b40f41c-d16c-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b40f41c-d16c-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_3ba502e6-1fd1-40ed-8e72-2db58e8c52bb_ACT_48903e92-a862-448a-b062-3fd9d15fd587_SESS_d78eaaa3-f8d3-4f0f-9aef-f1bd5e3b88fb_TOSC_ecc64fb7-d42c-4cfd-8d83-061117499472_SNAPS_','2020-12-07 12:01:16','2020-07-29 09:17:31','0b40f41c-d16c-11ea-947d-226cec7cb58a.png','2020-12-07 13:01:16','SYNCED','0b40f41c-d16c-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.28.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0b41d10e-b38b-4d04-adaf-1257f8ee0909','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b41d10e-b38b-4d04-adaf-1257f8ee0909.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_d0f20639-a432-47cd-9454-251a59a1e0c9_SESS_b6dc05a1-1fb1-4be1-9a88-e217ff97bec5_TOSC_55edd8f6-6615-4786-aa85-aaeb006076a6_PLY_','2020-12-08 17:26:56','2020-06-17 16:59:37','0b41d10e-b38b-4d04-adaf-1257f8ee0909.ply','2020-12-08 18:26:56','SYNCED','0b41d10e-b38b-4d04-adaf-1257f8ee0909',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.58.1.1\",\"modelMatrix\":\"0.261294,-0.942155,0.209928,0,0.965259,0.25504,-0.0568273,0,-5.36025e-9,0.217484,0.976064,0,-16.4813,-32.5088,-14.9848,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0b43cca0-8ca1-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b43cca0-8ca1-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_785b2632-9f19-49ff-a48a-6954f917316e_ACT_2d39ec8f-f34c-40fd-a7ae-afc0a3c4fdb6_SESS_3287a70c-ee75-4c66-813e-a769def8222b_TOSC_8380ebab-ec3a-49d1-be60-b8a6a900345a_PLY_','2021-03-24 13:00:51','2021-03-24 13:48:50','0b43cca0-8ca1-11eb-9377-226cec7cb58a.ply','2021-03-24 14:00:51','SYNCED','0b43cca0-8ca1-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.115.1.2\",\"modelMatrix\":\"0.594818,-0.743874,0.304701,0,0.80386,0.550431,-0.225465,0,1.27962e-8,0.379048,0.925377,0,-0.955275,-34.9036,-18.5823,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0b43f79a-d16c-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b43f79a-d16c-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_3ba502e6-1fd1-40ed-8e72-2db58e8c52bb_ACT_48903e92-a862-448a-b062-3fd9d15fd587_SESS_d78eaaa3-f8d3-4f0f-9aef-f1bd5e3b88fb_BOSC_39dbabbf-aa71-4b44-802c-96da82bd0185_SNAPS_','2020-12-07 12:01:16','2020-07-29 09:20:44','0b43f79a-d16c-11ea-947d-226cec7cb58a.png','2020-12-07 13:01:16','SYNCED','0b43f79a-d16c-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.28.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0b46bcf7-8ca1-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b46bcf7-8ca1-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_785b2632-9f19-49ff-a48a-6954f917316e_ACT_2d39ec8f-f34c-40fd-a7ae-afc0a3c4fdb6_SESS_3287a70c-ee75-4c66-813e-a769def8222b_BOSC_5a1c2bee-aa2e-429e-918d-e417f3934fcc_PLY_','2021-03-24 13:00:51','2021-03-24 13:54:27','0b46bcf7-8ca1-11eb-9377-226cec7cb58a.ply','2021-03-24 14:00:51','SYNCED','0b46bcf7-8ca1-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.115.1.1\",\"modelMatrix\":\"0.950026,0.312039,-0.00906758,0,-0.31217,0.949625,-0.0275953,0,-3.7077e-11,0.0290469,0.999578,0,21.45,-13.1575,-22.8373,1\",\"title\":\"Mandibule PLY\"}'),(2,'0b46fda0-d16c-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b46fda0-d16c-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_3ba502e6-1fd1-40ed-8e72-2db58e8c52bb_ACT_48903e92-a862-448a-b062-3fd9d15fd587_SESS_d78eaaa3-f8d3-4f0f-9aef-f1bd5e3b88fb_TOSC_ecc64fb7-d42c-4cfd-8d83-061117499472_PLY_','2020-12-07 12:01:16','2020-07-29 09:17:31','0b46fda0-d16c-11ea-947d-226cec7cb58a.ply','2020-12-07 13:01:16','SYNCED','0b46fda0-d16c-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.28.1.1\",\"modelMatrix\":\"0.464353,-0.859023,0.215537,0,0.88565,0.450392,-0.113007,0,-2.05929e-9,0.243365,0.969935,0,-4.6497,-32.4726,-14.4407,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0b498d46-d16c-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b498d46-d16c-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_3ba502e6-1fd1-40ed-8e72-2db58e8c52bb_ACT_48903e92-a862-448a-b062-3fd9d15fd587_SESS_d78eaaa3-f8d3-4f0f-9aef-f1bd5e3b88fb_BOSC_39dbabbf-aa71-4b44-802c-96da82bd0185_PLY_','2020-12-07 12:01:17','2020-07-29 09:20:44','0b498d46-d16c-11ea-947d-226cec7cb58a.ply','2020-12-07 13:01:17','SYNCED','0b498d46-d16c-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.28.1.1\",\"modelMatrix\":\"-0.939354,-0.318396,0.127432,0,0.34295,-0.872099,0.349041,0,1.40475e-9,0.371576,0.928403,0,-21.4172,6.73081,-19.2134,1\",\"title\":\"Mandibule PLY\"}'),(2,'0b499398-03c5-48dd-af38-b46563a0a3e7','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b499398-03c5-48dd-af38-b46563a0a3e7.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_c7a6f6ba-bf16-4193-bed4-711092e6844c_SESS_09f61616-e0f4-4e63-a2ec-573869a1da0e_BOSC_67ca2c4e-d8f2-465c-8f7f-f6d0666e9e93_SNAPS_','2021-04-07 10:00:48','2021-04-07 12:00:47','0b499398-03c5-48dd-af38-b46563a0a3e7.png','2021-04-07 12:00:48','SYNCED','0b499398-03c5-48dd-af38-b46563a0a3e7',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.13.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0b4b1110-2107-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b4b1110-2107-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_158e4d86-5a2b-4f2f-a26f-d927998b7946_ACT_1d8ad4fd-f2a3-407c-97f0-a15fe6d90d00_SESS_f151be04-535c-4a24-a25c-c6b2ede819f9_BOSC_2ca58b64-0cfb-4efc-a784-ceb09920bcb2_SNAPS_','2021-09-29 09:22:23','2021-09-29 11:22:19','0b4b1110-2107-11ec-9377-226cec7cb58a.png','2021-09-29 11:22:23','SYNCED','0b4b1110-2107-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.156.1.1.4\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0b4b65fc-f709-457d-8282-62a98911c407','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b4b65fc-f709-457d-8282-62a98911c407.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_e270753f-f697-414d-90de-b0188dc66067_SESS_9c20d55e-b419-45f5-85e4-ca583f9b9592_TOSC_d504e730-f270-4ea2-bef9-468fc22b9094_SNAPS_','2021-09-30 10:06:11','2021-09-30 12:06:06','0b4b65fc-f709-457d-8282-62a98911c407.png','2021-09-30 12:06:11','SYNCED','0b4b65fc-f709-457d-8282-62a98911c407',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.3.22.34.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0b4b9e3f-8ca1-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b4b9e3f-8ca1-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_785b2632-9f19-49ff-a48a-6954f917316e_ACT_2d39ec8f-f34c-40fd-a7ae-afc0a3c4fdb6_SESS_3287a70c-ee75-4c66-813e-a769def8222b_BOSC_5a1c2bee-aa2e-429e-918d-e417f3934fcc_SNAPS_','2021-03-24 13:00:52','2021-03-24 13:54:27','0b4b9e3f-8ca1-11eb-9377-226cec7cb58a.png','2021-03-24 14:00:52','SYNCED','0b4b9e3f-8ca1-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.115.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0b4c35da-dc9d-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b4c35da-dc9d-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_97a9879b-cc00-4009-abc2-5c74c09ea957_SESS_d83458f3-a55b-471f-897b-554877deea45_TOSC_c6bdfeb6-698b-43ed-868a-f939580d6c43_SNAPS_','2020-12-07 12:01:17','2020-08-12 15:09:01','0b4c35da-dc9d-11ea-947d-226cec7cb58a.png','2020-12-07 13:01:17','SYNCED','0b4c35da-dc9d-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.26.5.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0b4dcde7-2107-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b4dcde7-2107-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_158e4d86-5a2b-4f2f-a26f-d927998b7946_ACT_1d8ad4fd-f2a3-407c-97f0-a15fe6d90d00_SESS_f151be04-535c-4a24-a25c-c6b2ede819f9_BOSC_57ba6116-eb24-4c54-9529-2a0088671ff1_SNAPS_','2021-09-29 07:49:38','2021-09-29 09:49:35','0b4dcde7-2107-11ec-9377-226cec7cb58a.png','2021-09-29 09:49:38','SYNCED','0b4dcde7-2107-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.156.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0b4e5abc-dc9d-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b4e5abc-dc9d-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_97a9879b-cc00-4009-abc2-5c74c09ea957_SESS_d83458f3-a55b-471f-897b-554877deea45_BOSC_7b722665-a873-4c8d-8765-80893e15fe5c_SNAPS_','2020-12-07 12:01:17','2020-08-12 15:04:29','0b4e5abc-dc9d-11ea-947d-226cec7cb58a.png','2020-12-07 13:01:17','SYNCED','0b4e5abc-dc9d-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.26.5.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0b4ff6e9-401f-4b7a-aeff-f31ff5892c64','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b4ff6e9-401f-4b7a-aeff-f31ff5892c64.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_5f391d47-0318-410b-8b2c-92b8c0335a76_SESS_308c4574-20c3-4cb9-956d-856d7ce95788_BOSC_99081977-6a54-4517-9335-9b69a33b705c_PLY_','2021-05-28 13:16:18','2021-05-28 15:16:17','0b4ff6e9-401f-4b7a-aeff-f31ff5892c64.ply','2021-05-28 15:16:18','SYNCED','0b4ff6e9-401f-4b7a-aeff-f31ff5892c64',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.162.1.2\",\"modelMatrix\":\"-0.948149,-0.294824,0.118711,0,0.317826,-0.879529,0.354141,0,1.00215e-8,0.373508,0.927627,0,-23.3965,5.8857,-18.0074,1\",\"title\":\"Mandibule PLY\"}'),(2,'0b507b84-2107-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b507b84-2107-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_158e4d86-5a2b-4f2f-a26f-d927998b7946_ACT_1d8ad4fd-f2a3-407c-97f0-a15fe6d90d00_SESS_f151be04-535c-4a24-a25c-c6b2ede819f9_TOSC_ef1af696-fd37-4c70-95cf-9649ed339562_SNAPS_','2021-09-28 12:34:05','2021-09-28 14:34:00','0b507b84-2107-11ec-9377-226cec7cb58a.png','2021-09-28 14:34:05','SYNCED','0b507b84-2107-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.156.1.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0b5090f7-dc9d-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b5090f7-dc9d-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_97a9879b-cc00-4009-abc2-5c74c09ea957_SESS_d83458f3-a55b-471f-897b-554877deea45_TOSC_c6bdfeb6-698b-43ed-868a-f939580d6c43_PLY_','2020-12-07 12:01:17','2020-08-12 15:09:01','0b5090f7-dc9d-11ea-947d-226cec7cb58a.ply','2020-12-07 13:01:17','SYNCED','0b5090f7-dc9d-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.26.5.1.1\",\"modelMatrix\":\"0.467071,-0.855471,0.223639,0,0.88422,0.451885,-0.118133,0,3.7511e-10,0.252922,0.967487,0,1.60785,-32.2904,-13.5698,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0b51dde7-8ca1-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b51dde7-8ca1-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_785b2632-9f19-49ff-a48a-6954f917316e_ACT_2d39ec8f-f34c-40fd-a7ae-afc0a3c4fdb6_SESS_3287a70c-ee75-4c66-813e-a769def8222b_TOSC_8380ebab-ec3a-49d1-be60-b8a6a900345a_SNAPS_','2021-03-24 13:00:51','2021-03-24 13:48:50','0b51dde7-8ca1-11eb-9377-226cec7cb58a.png','2021-03-24 14:00:51','SYNCED','0b51dde7-8ca1-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.115.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0b528650-dc9d-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b528650-dc9d-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_97a9879b-cc00-4009-abc2-5c74c09ea957_SESS_d83458f3-a55b-471f-897b-554877deea45_BOSC_7b722665-a873-4c8d-8765-80893e15fe5c_PLY_','2020-12-07 12:01:17','2020-08-12 15:04:29','0b528650-dc9d-11ea-947d-226cec7cb58a.ply','2020-12-07 13:01:17','SYNCED','0b528650-dc9d-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.26.5.1.1\",\"modelMatrix\":\"-0.93722,-0.313994,0.151747,0,0.34874,-0.843843,0.407811,0,-1.00133e-8,0.435129,0.900368,0,-17.3057,4.80305,-18.6151,1\",\"title\":\"Mandibule PLY\"}'),(2,'0b53a0f1-2107-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b53a0f1-2107-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_158e4d86-5a2b-4f2f-a26f-d927998b7946_ACT_1d8ad4fd-f2a3-407c-97f0-a15fe6d90d00_SESS_f151be04-535c-4a24-a25c-c6b2ede819f9_BOSC_8ead219f-21a8-44b2-8c28-e42b7396cbc2_SNAPS_','2021-09-29 09:18:34','2021-09-29 11:18:31','0b53a0f1-2107-11ec-9377-226cec7cb58a.png','2021-09-29 11:18:34','SYNCED','0b53a0f1-2107-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.156.1.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0b56a488-2107-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b56a488-2107-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_158e4d86-5a2b-4f2f-a26f-d927998b7946_ACT_1d8ad4fd-f2a3-407c-97f0-a15fe6d90d00_SESS_f151be04-535c-4a24-a25c-c6b2ede819f9_BOSC_2ca58b64-0cfb-4efc-a784-ceb09920bcb2_ZIP_','2021-09-29 09:22:23','2021-09-29 11:22:20','0b56a488-2107-11ec-9377-226cec7cb58a.zip','2021-09-29 11:22:23','SYNCED','0b56a488-2107-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.156.1.1.4\",\"modelMatrix\":\"-0.619539,-0.778861,0.0977093,0,0.784966,-0.614721,0.0771177,0,9.35771e-10,0.124476,0.992223,0,-24.9538,-2.96805,-19.0491,1\",\"title\":\"Mandibule ZIP\"}'),(2,'0b573a4a-17e3-489a-a3e3-6eecae93624e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b573a4a-17e3-489a-a3e3-6eecae93624e.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_875a1e66-4203-4e71-88bf-db0512ab80f6_SESS_7f1064b6-9587-413e-9479-70a1b3fd3a59_TOSC_ee1a327c-8a4f-4fda-9cb9-002baaef9f72_SNAPS_','2021-04-28 09:08:08','2021-04-28 10:53:50','0b573a4a-17e3-489a-a3e3-6eecae93624e.png','2021-04-28 11:08:08','SYNCED','0b573a4a-17e3-489a-a3e3-6eecae93624e',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.122.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0b58a0f5-2107-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b58a0f5-2107-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_158e4d86-5a2b-4f2f-a26f-d927998b7946_ACT_1d8ad4fd-f2a3-407c-97f0-a15fe6d90d00_SESS_f151be04-535c-4a24-a25c-c6b2ede819f9_TOSC_ef1af696-fd37-4c70-95cf-9649ed339562_ZIP_','2021-09-28 12:34:05','2021-09-28 14:34:02','0b58a0f5-2107-11ec-9377-226cec7cb58a.zip','2021-09-28 14:34:05','SYNCED','0b58a0f5-2107-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.156.1.1.2\",\"modelMatrix\":\"0.770658,-0.603909,0.203423,0,0.637249,0.730337,-0.246009,0,1.55089e-8,0.31922,0.947681,0,-3.01222,-38.3238,-14.3336,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'0b58abba-2429-4b5c-9908-279936772e7f','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b58abba-2429-4b5c-9908-279936772e7f.png','SNAPS','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_81c2c22e-dd27-48c4-9451-1a7c8ae2a3a8_BOSC_f2c387e7-d80a-4eb5-83bb-7389bfba262a_SNAPS_','2021-12-30 18:03:19','2019-11-14 14:06:05','0b58abba-2429-4b5c-9908-279936772e7f.png','2021-12-30 19:03:19','SYNCED','0b58abba-2429-4b5c-9908-279936772e7f',0,NULL,'','','{\"displayTitle\":\"Mandibola 0\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0b58fc6f-8d9e-46fb-81be-df888ad18717','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b58fc6f-8d9e-46fb-81be-df888ad18717.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_8a46fe73-45f9-48a6-b7b5-7f571298b5c3_SESS_88277293-7807-4a9d-8a3b-4bada1cecf0b_BOSC_8a613359-a7fc-487e-8874-ffbe824311ba_PLY_','2021-04-09 13:03:00','2021-04-09 15:02:58','0b58fc6f-8d9e-46fb-81be-df888ad18717.ply','2021-04-09 15:03:00','SYNCED','0b58fc6f-8d9e-46fb-81be-df888ad18717',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.48.1.3\",\"modelMatrix\":\"-0.801175,-0.580819,0.144111,0,0.598431,-0.777597,0.192935,0,1.07819e-9,0.240816,0.970571,0,-19.3869,-1.76891,-25.055,1\",\"title\":\"Mandibule PLY\"}'),(2,'0b5b3028-06d3-473e-bb3d-6e9720dc2667','','SNAPS','PATIENT_879371c7-65d9-408b-b9fa-ec206f0cf519_ACT_4c9e4ce5-aba6-4a79-8d09-6e7f10bcfa7a_SESS_bb6754a5-dedd-48d5-844c-a289a547261c_TOSC_5c172493-63a5-4361-ad05-302f2fe4e605_SNAPS_','2021-03-16 12:52:00','2021-03-16 13:51:57','','2021-03-16 13:52:00','SYNCED','0b5b3028-06d3-473e-bb3d-6e9720dc2667',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.230.1.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0b5b353a-2107-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b5b353a-2107-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_158e4d86-5a2b-4f2f-a26f-d927998b7946_ACT_1d8ad4fd-f2a3-407c-97f0-a15fe6d90d00_SESS_f151be04-535c-4a24-a25c-c6b2ede819f9_BOSC_57ba6116-eb24-4c54-9529-2a0088671ff1_ZIP_','2021-09-29 07:49:38','2021-09-29 09:49:36','0b5b353a-2107-11ec-9377-226cec7cb58a.zip','2021-09-29 09:49:38','SYNCED','0b5b353a-2107-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.156.1.1.1\",\"modelMatrix\":\"-0.872109,-0.478351,0.102988,0,0.489312,-0.852573,0.183557,0,1.07885e-9,0.210475,0.977599,0,-26.444,3.12124,-18.4071,1\",\"title\":\"Mandibule ZIP\"}'),(2,'0b5b4578-e5ff-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b5b4578-e5ff-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_5f520719-1078-4f95-9356-dbe52c462f0f_SESS_09155edc-1b2f-4d99-835a-2835ec05445d_TOSC_496ae9be-7a8c-48b8-80c0-89c7d78a0809_SNAPS_','2020-12-07 12:01:18','2020-08-24 13:41:12','0b5b4578-e5ff-11ea-947d-226cec7cb58a.png','2020-12-07 13:01:18','SYNCED','0b5b4578-e5ff-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.26.48.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0b5bf255-7fbc-4c15-8a66-c5aa681d31c0','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b5bf255-7fbc-4c15-8a66-c5aa681d31c0.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_ca78eb22-df1e-48d4-8515-50e71ad93a32_SESS_1304bb45-ec25-4d29-80c5-d1cc4ba1a4c6_TOSC_9738bed4-045f-4cc2-93a3-cf36dcaba006_PLY_','2021-07-22 09:08:27','2021-07-22 11:08:24','0b5bf255-7fbc-4c15-8a66-c5aa681d31c0.ply','2021-07-22 11:08:27','SYNCED','0b5bf255-7fbc-4c15-8a66-c5aa681d31c0',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.177.1.4\",\"modelMatrix\":\"0.746273,-0.618653,0.245651,0,0.66564,0.693595,-0.275408,0,-4.45902e-10,0.369045,0.929411,0,7.76524,-30.5512,-24.5681,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0b5c05a0-857e-4e49-952f-35939b71c280','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b5c05a0-857e-4e49-952f-35939b71c280.png','SNAPS','PATIENT_13210a90-6734-476f-9b18-06c93775873c_ACT_1ac807ea-a996-41e0-9c98-43dbc7664a7e_SESS_c23746b0-3e7f-4371-ba47-95bf9f25ba8b_TOSC_5e84fe91-9891-490c-b35a-a7b3750ee3db_SNAPS_','2020-11-24 08:32:43','2020-11-23 10:47:57','0b5c05a0-857e-4e49-952f-35939b71c280.png','2020-11-24 09:32:43','SYNCED','0b5c05a0-857e-4e49-952f-35939b71c280',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.36.27.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0b5e1cae-e5ff-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b5e1cae-e5ff-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_5f520719-1078-4f95-9356-dbe52c462f0f_SESS_09155edc-1b2f-4d99-835a-2835ec05445d_BOSC_5bf5f25b-b050-47c4-89a0-e0b4cd299117_SNAPS_','2020-12-07 12:01:18','2020-08-24 13:43:28','0b5e1cae-e5ff-11ea-947d-226cec7cb58a.png','2020-12-07 13:01:18','SYNCED','0b5e1cae-e5ff-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.26.48.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0b5e1d51-2107-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b5e1d51-2107-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_158e4d86-5a2b-4f2f-a26f-d927998b7946_ACT_1d8ad4fd-f2a3-407c-97f0-a15fe6d90d00_SESS_f151be04-535c-4a24-a25c-c6b2ede819f9_BOSC_8ead219f-21a8-44b2-8c28-e42b7396cbc2_ZIP_','2021-09-29 09:18:34','2021-09-29 11:18:32','0b5e1d51-2107-11ec-9377-226cec7cb58a.zip','2021-09-29 11:18:34','SYNCED','0b5e1d51-2107-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.156.1.1.3\",\"modelMatrix\":\"-0.678349,-0.718803,0.152199,0,0.73474,-0.663635,0.140518,0,1.09141e-9,0.207147,0.97831,0,-28.0587,-1.28332,-20.778,1\",\"title\":\"Mandibule ZIP\"}'),(2,'0b5ef729-dc99-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b5ef729-dc99-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_7b9a08c2-e9ed-4149-a7d7-51ede7904549_SESS_4faba830-1668-4d9b-aec8-1a024d4cfdce_TOSC_3684d697-561f-40ee-8f0e-2d77b950bd1f_PLY_','2020-12-07 12:01:18','2020-08-12 14:37:06','0b5ef729-dc99-11ea-947d-226cec7cb58a.ply','2020-12-07 13:01:18','SYNCED','0b5ef729-dc99-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.26.2.1.1\",\"modelMatrix\":\"0.419592,-0.881899,0.214935,0,0.907713,0.40766,-0.0993544,0,2.41118e-9,0.236788,0.971561,0,-4.54808,-33.047,-16.4071,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0b605d5a-e5ff-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b605d5a-e5ff-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_5f520719-1078-4f95-9356-dbe52c462f0f_SESS_09155edc-1b2f-4d99-835a-2835ec05445d_TOSC_496ae9be-7a8c-48b8-80c0-89c7d78a0809_PLY_','2020-12-07 12:01:18','2020-08-24 13:41:12','0b605d5a-e5ff-11ea-947d-226cec7cb58a.ply','2020-12-07 13:01:18','SYNCED','0b605d5a-e5ff-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.26.48.1.1\",\"modelMatrix\":\"0.723386,-0.626636,0.289896,0,0.690444,0.656534,-0.303728,0,6.00147e-9,0.419869,0.907585,0,6.95584,-29.7929,-16.4814,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0b60e18f-2107-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b60e18f-2107-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_158e4d86-5a2b-4f2f-a26f-d927998b7946_ACT_1d8ad4fd-f2a3-407c-97f0-a15fe6d90d00_SESS_f151be04-535c-4a24-a25c-c6b2ede819f9_TOSC_8f75cc7e-54e5-4931-a75b-b7b50c3da1ba_SNAPS_','2021-09-28 12:39:53','2021-09-28 14:39:46','0b60e18f-2107-11ec-9377-226cec7cb58a.png','2021-09-28 14:39:53','SYNCED','0b60e18f-2107-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.156.1.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0b6145b2-dc99-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b6145b2-dc99-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_7b9a08c2-e9ed-4149-a7d7-51ede7904549_SESS_4faba830-1668-4d9b-aec8-1a024d4cfdce_BOSC_d268b574-5c60-488f-8cfd-ad7658baec1d_PLY_','2020-12-07 12:01:18','2020-08-12 14:39:32','0b6145b2-dc99-11ea-947d-226cec7cb58a.ply','2020-12-07 13:01:18','SYNCED','0b6145b2-dc99-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.26.2.1.1\",\"modelMatrix\":\"-0.938306,-0.330149,0.102877,0,0.345806,-0.895822,0.279144,0,-1.40603e-9,0.297498,0.954722,0,-22.426,4.95812,-20.3288,1\",\"title\":\"Mandibule PLY\"}'),(2,'0b61ca08-900c-49af-aabf-b6dd4f27f22a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b61ca08-900c-49af-aabf-b6dd4f27f22a.ply','PLY','PATIENT_f05214ba-ab57-4134-9b22-72efa03ad5e5_ACT_e86252cd-ce57-4a39-9999-b7a1764511a3_SESS_9c5a13e9-92e4-43e0-a7c5-63ff085682f3_TOSC_88559979-22ef-4fe9-9723-6478cf6cfcb0_PLY_','2021-01-18 14:44:07','2021-01-18 15:22:49','0b61ca08-900c-49af-aabf-b6dd4f27f22a.ply','2021-01-18 15:44:07','SYNCED','0b61ca08-900c-49af-aabf-b6dd4f27f22a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.11.1.2\",\"modelMatrix\":\"0.803505,-0.5284,0.274176,0,0.595297,0.71321,-0.37007,0,-1.08305e-8,0.46057,0.887624,0,13.9955,-27.9075,-19.602,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0b6291c9-e5ff-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b6291c9-e5ff-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_5f520719-1078-4f95-9356-dbe52c462f0f_SESS_09155edc-1b2f-4d99-835a-2835ec05445d_BOSC_5bf5f25b-b050-47c4-89a0-e0b4cd299117_PLY_','2020-12-07 12:01:18','2020-08-24 13:43:28','0b6291c9-e5ff-11ea-947d-226cec7cb58a.ply','2020-12-07 13:01:18','SYNCED','0b6291c9-e5ff-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.26.48.1.1\",\"modelMatrix\":\"-0.998961,-0.044349,0.0104578,0,0.0455653,-0.972295,0.229273,0,-1.49495e-10,0.229512,0.973306,0,-22.2775,12.8888,-21.7882,1\",\"title\":\"Mandibule PLY\"}'),(2,'0b633f8a-dc99-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b633f8a-dc99-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_7b9a08c2-e9ed-4149-a7d7-51ede7904549_SESS_4faba830-1668-4d9b-aec8-1a024d4cfdce_TOSC_3684d697-561f-40ee-8f0e-2d77b950bd1f_SNAPS_','2020-12-07 12:01:19','2020-08-12 14:37:06','0b633f8a-dc99-11ea-947d-226cec7cb58a.png','2020-12-07 13:01:19','SYNCED','0b633f8a-dc99-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.26.2.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0b63b752-2107-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b63b752-2107-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_158e4d86-5a2b-4f2f-a26f-d927998b7946_ACT_1d8ad4fd-f2a3-407c-97f0-a15fe6d90d00_SESS_f151be04-535c-4a24-a25c-c6b2ede819f9_TOSC_893b00e6-394e-4c37-849e-ff632341bf04_SNAPS_','2021-09-28 12:25:57','2021-09-28 14:25:52','0b63b752-2107-11ec-9377-226cec7cb58a.png','2021-09-28 14:25:57','SYNCED','0b63b752-2107-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.156.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0b653af8-dc99-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b653af8-dc99-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_7b9a08c2-e9ed-4149-a7d7-51ede7904549_SESS_4faba830-1668-4d9b-aec8-1a024d4cfdce_BOSC_d268b574-5c60-488f-8cfd-ad7658baec1d_SNAPS_','2020-12-07 12:01:19','2020-08-12 14:39:32','0b653af8-dc99-11ea-947d-226cec7cb58a.png','2020-12-07 13:01:19','SYNCED','0b653af8-dc99-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.26.2.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0b664347-238f-4e4a-9f23-086121d3f217','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b664347-238f-4e4a-9f23-086121d3f217.png','SNAPS','PATIENT_24254e31-6416-4992-849a-65fd39a3c48b_ACT_eaa35f64-391a-4f9b-90dc-2d17dd84adb2_SESS_5b387acc-b34f-409c-ac13-ca045112ae9e_TOSC_a57f7b3a-fec8-4ef9-9261-b1fae98e4f5d_SNAPS_','2020-12-08 17:26:57','2020-06-29 11:49:53','0b664347-238f-4e4a-9f23-086121d3f217.png','2020-12-08 18:26:57','SYNCED','0b664347-238f-4e4a-9f23-086121d3f217',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.92.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0b67268a-fbb9-402e-bfe9-8f4c11d45147','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b67268a-fbb9-402e-bfe9-8f4c11d45147.ply','PLY','PATIENT_ad96d2f7-b54a-42c5-92d8-f2091d8b69d7_ACT_49ae6d20-8b36-477b-9284-1d843860f993_SESS_8414a55f-2681-4546-a350-d22fa70319fb_TOSC_40353bc1-6cfb-46de-9a48-63dc360d928b_PLY_','2021-01-25 08:54:06','2021-01-25 09:51:43','0b67268a-fbb9-402e-bfe9-8f4c11d45147.ply','2021-01-25 09:54:06','SYNCED','0b67268a-fbb9-402e-bfe9-8f4c11d45147',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.17.1.2\",\"modelMatrix\":\"-0.972399,0.229966,-0.0394587,0,-0.233326,-0.958393,0.164446,0,-1.57881e-9,0.169114,0.985597,0,-11.05,18.2658,-16.8883,1\",\"title\":\"Mandibule PLY\"}'),(2,'0b6785c2-2107-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b6785c2-2107-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_158e4d86-5a2b-4f2f-a26f-d927998b7946_ACT_1d8ad4fd-f2a3-407c-97f0-a15fe6d90d00_SESS_f151be04-535c-4a24-a25c-c6b2ede819f9_TOSC_8f75cc7e-54e5-4931-a75b-b7b50c3da1ba_ZIP_','2021-09-28 12:39:54','2021-09-28 14:39:46','0b6785c2-2107-11ec-9377-226cec7cb58a.zip','2021-09-28 14:39:54','SYNCED','0b6785c2-2107-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.156.1.1.3\",\"modelMatrix\":\"0.759061,-0.613761,0.217079,0,0.651019,0.71562,-0.253106,0,-3.37398e-9,0.333446,0.942769,0,3.1511,-32.9963,-14.619,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'0b67f7a5-623c-47cf-bcd6-0ce990868faa','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b67f7a5-623c-47cf-bcd6-0ce990868faa.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_f58020b9-8ec6-4223-832f-c4637a8599d4_SESS_43d8b0c5-f94c-4938-b8e5-30b6d133ea4c_TOSC_d0768335-287d-419f-8e05-861fffda8b8b_SNAPS_','2021-04-14 13:59:27','2021-04-14 15:59:25','0b67f7a5-623c-47cf-bcd6-0ce990868faa.png','2021-04-14 15:59:27','SYNCED','36d87028-2fcb-464c-9925-3a29404fe5f1',1,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.61.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0b68ba6a-736c-4c0c-a023-d2d387d9d960','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b68ba6a-736c-4c0c-a023-d2d387d9d960.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_fad54488-341f-4146-8637-3470378cf2f9_SESS_10cfc2a6-e17a-49a7-beff-60b736bf2445_BOSC_1a96ec43-e5a7-4d2c-a872-4fc072bf18a7_ZIP_','2022-01-20 13:52:24','2022-01-20 14:52:22','0b68ba6a-736c-4c0c-a023-d2d387d9d960.zip','2022-01-20 14:52:24','SYNCED','0b68ba6a-736c-4c0c-a023-d2d387d9d960',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.17.1.1\",\"modelMatrix\":\"-0.865529,-0.489053,0.108107,0,0.500859,-0.845127,0.186819,0,1.06252e-9,0.215844,0.976428,0,-25.4948,-0.895544,-20.0429,1\",\"title\":\"Mandibule ZIP\"}'),(2,'0b6a0516-2107-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b6a0516-2107-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_158e4d86-5a2b-4f2f-a26f-d927998b7946_ACT_1d8ad4fd-f2a3-407c-97f0-a15fe6d90d00_SESS_f151be04-535c-4a24-a25c-c6b2ede819f9_TOSC_893b00e6-394e-4c37-849e-ff632341bf04_ZIP_','2021-09-28 12:25:57','2021-09-28 14:25:54','0b6a0516-2107-11ec-9377-226cec7cb58a.zip','2021-09-28 14:25:57','SYNCED','0b6a0516-2107-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.156.1.1.1\",\"modelMatrix\":\"0.782977,-0.579756,0.225454,0,0.622051,0.729741,-0.28378,0,8.30031e-9,0.362437,0.932008,0,-0.623997,-34.0777,-12.9616,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'0b6a859d-0537-427e-8475-f78d8635a6e7','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b6a859d-0537-427e-8475-f78d8635a6e7.png','SNAPS','PATIENT_79d89cb8-7533-4691-ae26-03fb32120e14_ACT_b7fb2f2e-15a1-423d-9ec6-5cd6b7c3b3df_SESS_71ea43ce-6134-4395-adb6-356a0a54fc0d_BOSC_9e97800a-23cd-4169-a16d-dfb593a68d22_SNAPS_','2021-08-19 22:26:59','2019-12-05 16:20:59','0b6a859d-0537-427e-8475-f78d8635a6e7.png','2021-08-20 00:26:59','SYNCED','0b6a859d-0537-427e-8475-f78d8635a6e7',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 224.2.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0b7b75d6-7d01-48c4-985c-bbc3b5dd7e1f','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b7b75d6-7d01-48c4-985c-bbc3b5dd7e1f.ply','PLY','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_7561767d-78ee-49ff-a934-2d624c6b0424_SESS_5dff0cb4-f3ba-4256-96f1-fa63c03bee84_TOSC_a883e069-2e97-4f45-9b0d-95418f69949e_PLY_','2021-03-30 11:45:36','2021-03-30 13:45:35','0b7b75d6-7d01-48c4-985c-bbc3b5dd7e1f.ply','2021-03-30 13:45:36','SYNCED','b57ae173-fc31-4ed1-9a0d-9d6e0eb0b397',1,NULL,'','','{\"displayTitle\":\"Maxillaire 19.3.4.1.4\",\"modelMatrix\":\"0.458395,0.775017,-0.434997,0,-0.888748,0.399735,-0.224361,0,-3.88181e-9,0.489449,0.872032,0,4.24184,-38.4304,-10.3209,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0b7e2a2b-5d58-45fb-b1f8-6879ab11907a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b7e2a2b-5d58-45fb-b1f8-6879ab11907a.ply','PLY','PATIENT_84817142-00fa-404c-bc75-3c1bd55648b7_ACT_14643d0c-fc35-45b4-a60e-26d206653526_SESS_833387df-f92e-416d-ae3b-2e3142fb69b7_BOSC_c5d598e8-9735-4593-bfb5-1db057ca39c5_PLY_','2021-08-19 22:27:00','2019-11-27 15:46:20','0b7e2a2b-5d58-45fb-b1f8-6879ab11907a.ply','2021-08-20 00:27:00','SYNCED','0b7e2a2b-5d58-45fb-b1f8-6879ab11907a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 214.1.1.1\",\"modelMatrix\":\"0.80106,0.594921,-0.0661184,0,-0.598584,0.796158,-0.0884835,0,7.48337e-10,0.110458,0.993881,0,17.6514,-9.67322,-19.9118,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0b8099d9-4912-4743-b343-e36c3e1d2907','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b8099d9-4912-4743-b343-e36c3e1d2907.ply','PLY','PATIENT_82264787-d7b8-474d-a028-13cda13d0872_ACT_97d041b6-f662-492b-93e5-d406a1da3b3d_SESS_c6f79f6a-f3a1-41bd-a329-6d0bd267ef73_BOSC_b2eabac2-54a9-47a9-b3ab-d3103eedebfa_PLY_','2020-12-17 13:13:32','2020-12-17 14:08:19','0b8099d9-4912-4743-b343-e36c3e1d2907.ply','2020-12-17 14:13:32','SYNCED','0b8099d9-4912-4743-b343-e36c3e1d2907',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.44.1.1\",\"modelMatrix\":\"-0.99711,-0.0751199,0.0113823,0,0.0759774,-0.985857,0.149379,0,6.35682e-10,0.149812,0.988715,0,-20.028,14.8487,-14.4533,1\",\"title\":\"Mandibule PLY\"}'),(2,'0b816468-e200-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b816468-e200-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_9f209306-6fc2-4865-9b41-2503c70e4e82_SESS_360e2b7c-c3bf-422a-9a48-fd86cdcc3b12_TOSC_e405513b-9501-4129-80e3-0c62a99c2e4f_PLY_','2020-12-07 12:01:19','2020-08-19 11:36:41','0b816468-e200-11ea-947d-226cec7cb58a.ply','2020-12-07 13:01:19','SYNCED','0b816468-e200-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.26.27.1.1\",\"modelMatrix\":\"0.301776,-0.937489,0.173337,0,0.953379,0.296746,-0.0548669,0,-7.9029e-9,0.181814,0.983333,0,-10.6252,-33.1912,-12.7555,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0b836c78-e200-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b836c78-e200-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_9f209306-6fc2-4865-9b41-2503c70e4e82_SESS_360e2b7c-c3bf-422a-9a48-fd86cdcc3b12_BOSC_edceaf6b-ea2e-4675-900b-079d7b53c62b_PLY_','2020-12-07 12:01:20','2020-08-19 11:40:06','0b836c78-e200-11ea-947d-226cec7cb58a.ply','2020-12-07 13:01:20','SYNCED','0b836c78-e200-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.26.27.1.1\",\"modelMatrix\":\"-0.945963,0.319909,-0.0530346,0,-0.324275,-0.933226,0.154711,0,1.61166e-9,0.163548,0.986535,0,-12.651,19.7937,-19.728,1\",\"title\":\"Mandibule PLY\"}'),(2,'0b854857-e200-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b854857-e200-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_9f209306-6fc2-4865-9b41-2503c70e4e82_SESS_360e2b7c-c3bf-422a-9a48-fd86cdcc3b12_TOSC_e405513b-9501-4129-80e3-0c62a99c2e4f_SNAPS_','2020-12-07 12:01:20','2020-08-19 11:36:41','0b854857-e200-11ea-947d-226cec7cb58a.png','2020-12-07 13:01:20','SYNCED','0b854857-e200-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.26.27.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0b875761-e200-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b875761-e200-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_9f209306-6fc2-4865-9b41-2503c70e4e82_SESS_360e2b7c-c3bf-422a-9a48-fd86cdcc3b12_BOSC_edceaf6b-ea2e-4675-900b-079d7b53c62b_SNAPS_','2020-12-07 12:01:20','2020-08-19 11:40:06','0b875761-e200-11ea-947d-226cec7cb58a.png','2020-12-07 13:01:20','SYNCED','0b875761-e200-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.26.27.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0b8a18da-033b-4b1a-9913-bbdfa805212c','','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_a805b750-e0de-4e7c-bad6-1e411ddf0de7_SESS_242bf73f-4d6c-46b0-b269-3d90ddf046f5_TOSC_5d8ade5a-a340-4eef-99fb-42f37551d04a_ZIP_','2022-03-30 08:29:38','2022-03-30 10:29:35','','2022-03-30 10:29:38','SYNCED','0b8a18da-033b-4b1a-9913-bbdfa805212c',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.43.1.3\",\"modelMatrix\":\"0.795501,-0.563948,0.221676,0,0.605952,0.740358,-0.291018,0,-1.15701e-08,0.36583,0.930682,0,11.1902,-35.1047,-14.0228,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'0b8e31a8-2600-4d81-84c2-d7d22dc6cd2e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b8e31a8-2600-4d81-84c2-d7d22dc6cd2e.ply','PLY','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_34e49160-7a4d-43c1-98f1-9f8e2bef3340_SESS_db56cba1-23ff-48bf-b86e-4ceff749087f_BOSC_deb9190a-00b3-492c-b89c-ef991e01aea9_PLY_','2021-12-30 18:03:19','2019-11-14 16:17:04','0b8e31a8-2600-4d81-84c2-d7d22dc6cd2e.ply','2021-12-30 19:03:19','SYNCED','0b8e31a8-2600-4d81-84c2-d7d22dc6cd2e',0,NULL,'','','{\"displayTitle\":\"Mandibola 0\",\"modelMatrix\":\"-0.999059,-0.0412759,0.0133204,0,0.043372,-0.950775,0.306832,0,-6.57848e-10,0.307121,0.951671,0,-17.8359,10.6222,-25.5632,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0b8fc569-6e23-4cee-ade6-f4aea247fe97','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b8fc569-6e23-4cee-ade6-f4aea247fe97.stl','STL','PATIENT_cadfb79e-7de5-4015-97e3-269a77999943_ACT_087c4066-ec0b-4035-93aa-10a106e71f3b_SESS_e1ed2519-b566-46fa-a753-50431597c10e_BOSC_4fd01687-5e39-44cf-a8ab-2b5bb73babf9_STL_','2021-12-30 18:03:20','2019-11-05 14:19:36','0b8fc569-6e23-4cee-ade6-f4aea247fe97.stl','2021-12-30 19:03:20','SYNCED','0b8fc569-6e23-4cee-ade6-f4aea247fe97',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.2.1.3\",\"modelMatrix\":\"-0.992812,0.112429,-0.0410465,0,-0.119688,-0.932602,0.340481,0,5.5892e-10,0.342947,0.939355,0,-18.6668,10.2624,-15.7975,1\",\"title\":\"MANDIBULE STL\"}'),(2,'0b96516c-911c-4627-b109-20d02830b081','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b96516c-911c-4627-b109-20d02830b081.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_4dd752e2-cde1-481a-a4a4-9bcb66e3abb9_SESS_500c8c91-4cdd-401c-8352-8297691a9cc7_BOSC_9427c5f0-a53d-4ca1-a3f2-fbfa67ce07b8_SNAPS_','2021-05-27 13:48:33','2021-05-27 15:48:32','0b96516c-911c-4627-b109-20d02830b081.png','2021-05-27 15:48:33','SYNCED','0b96516c-911c-4627-b109-20d02830b081',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.157.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0b99e236-a963-4406-bf18-15f43d76a7cb','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0b99e236-a963-4406-bf18-15f43d76a7cb.ply','PLY','PATIENT_4d2ff420-445f-4f6c-a090-c3b148f59e55_ACT_14aea70f-0403-40a0-b351-d60d5b01eb39_SESS_87409468-4c74-49d2-a719-0a27a09993ae_TOSC_b13a5f4c-b98d-4e1c-9490-ec61643df6e8_PLY_','2021-12-30 18:03:20','2019-11-21 09:56:09','0b99e236-a963-4406-bf18-15f43d76a7cb.ply','2021-12-30 19:03:20','SYNCED','9a80f1f9-0a45-431b-84cc-c5ab41051930',1,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 207.6.1.1\",\"modelMatrix\":\"0.515463,-0.799056,0.309529,0,0.856912,0.48066,-0.186193,0,-1.84802e-9,0.361214,0.932483,0,-6.60408,-39.4109,-23.0604,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0ba3eb1b-ca69-443f-b1f4-27de053c4875','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0ba3eb1b-ca69-443f-b1f4-27de053c4875.ply','PLY','PATIENT_fd4825c4-beed-452a-8641-25e55e983249_ACT_855e8123-60a7-46bf-bbe7-5b619e7e3c83_SESS_c128ff5c-e71a-4dbf-a87d-029519b521d9_TOSC_df9431b2-2fe3-4aea-a54f-e4072dcbfdfc_PLY_','2020-12-08 17:26:59','2020-06-17 11:47:50','0ba3eb1b-ca69-443f-b1f4-27de053c4875.ply','2020-12-08 18:26:59','SYNCED','0ba3eb1b-ca69-443f-b1f4-27de053c4875',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.51.1.1\",\"modelMatrix\":\"0.277343,-0.929712,0.242315,0,0.960771,0.268377,-0.0699484,0,-2.97217e-9,0.252209,0.967673,0,-8.23271,-33.3182,-12.0221,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0ba4b336-09b5-4d70-ad6e-d3ec1cb439c3','','LIFIM','PATIENT_9a7fb011-3358-4d3c-a11d-cb262db47e63_ACT_8d3d24a8-8497-455b-a175-3c2ad080b066_SESS_4c947a81-1ce1-4f4b-9ced-98099e5c9e41_TOSC_6c77a427-9c36-4753-9c20-b37adb53412f_LIFIM_','2020-11-23 20:19:26','2020-06-24 16:18:23','','2020-11-23 21:19:26','SYNCED','0ba4b336-09b5-4d70-ad6e-d3ec1cb439c3',0,NULL,'','','{\"displayTitle\":\"Margin line Maxilla 11.1.2.1.1 Sans nom 0\",\"name\":\"Sans nom 0\",\"title\":\"Maxillaire LIFI_META\",\"toothNumber\":0}'),(2,'0ba7c697-3236-429d-9a81-5cd3d9738593','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0ba7c697-3236-429d-9a81-5cd3d9738593.png','SNAPS','PATIENT_ebaef17c-16cb-4f80-a524-d7025782104f_ACT_7398381b-4b26-49ad-bbe4-521897a13cfc_SESS_76113035-010d-4824-86c8-ba584465891c_BOSC_8edd8e97-b515-4712-b72c-07e34bbb0d12_SNAPS_','2022-02-01 11:47:28','2019-07-19 12:05:16','0ba7c697-3236-429d-9a81-5cd3d9738593.png','2022-02-01 12:47:28','SYNCED','0ba7c697-3236-429d-9a81-5cd3d9738593',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 100.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0ba96783-3cfc-430b-aad8-ce9f7dc69393','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0ba96783-3cfc-430b-aad8-ce9f7dc69393.ply','PLY','PATIENT_4d2e9fca-544c-4fb9-85f2-602ba219c257_ACT_a78bfdb6-db3d-4c2d-aefa-ac2518575b04_SESS_86e9b775-4bce-49b9-990c-987afc4d07b2_BOSC_07a2bb3b-0b56-42e5-86ff-ba5851b33c0a_PLY_','2022-02-01 11:47:29','2019-07-15 10:40:43','0ba96783-3cfc-430b-aad8-ce9f7dc69393.ply','2022-02-01 12:47:29','SYNCED','0ba96783-3cfc-430b-aad8-ce9f7dc69393',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 61.1.1.1\",\"modelMatrix\":\"0.284999,0.95791,-0.0344173,0,-0.958528,0.284816,-0.0102333,0,3.89863e-10,0.0359064,0.999355,0,20.2451,11.1207,-24.5276,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0ba98f2a-c390-4f2f-98bb-69118cc65cb5','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0ba98f2a-c390-4f2f-98bb-69118cc65cb5.png','SNAPS','PATIENT_24508ae5-050d-4367-a6bf-e8b3afbe9bd4_ACT_69dea633-e25c-4e85-87a6-e51ed662f863_SESS_0212c0aa-313c-4751-acec-87455cd29190_TOSC_30539282-2b84-4eac-984b-c59ed72c5e96_SNAPS_','2021-12-30 18:03:20','2019-10-09 12:07:56','0ba98f2a-c390-4f2f-98bb-69118cc65cb5.png','2021-12-30 19:03:20','SYNCED','0ba98f2a-c390-4f2f-98bb-69118cc65cb5',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 183.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0bab1881-6303-4a0e-98a5-12baee15b775','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bab1881-6303-4a0e-98a5-12baee15b775.png','SNAPS','PATIENT_0bec7ef8-f644-4d84-a2ed-56f8f1364672_ACT_a78941e1-e63b-4f03-84db-3c4fcdb64d89_SESS_caf59252-3532-421e-9b72-5abe78045a36_TOSC_38bb1323-feb0-4bb1-8cda-5daf12e12eed_SNAPS_','2020-12-16 10:52:27','2020-02-20 15:01:23','0bab1881-6303-4a0e-98a5-12baee15b775.png','2020-12-16 11:52:27','SYNCED','0bab1881-6303-4a0e-98a5-12baee15b775',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0bab9084-9165-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bab9084-9165-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_66b1d09a-a057-4c0c-8cf3-b44067707c25_SESS_c051925e-f943-40b5-9772-e8f0c9e67f55_TOSC_8e08be1e-6124-4e1d-8041-380782cca4a1_PLY_','2021-03-30 14:33:36','2021-03-30 16:33:35','0bab9084-9165-11eb-9377-226cec7cb58a.ply','2021-03-30 16:33:36','SYNCED','0bab9084-9165-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.3.9.1.3\",\"modelMatrix\":\"0.523977,0.777018,-0.348842,0,-0.851732,0.478014,-0.214604,0,1.19108e-8,0.409568,0.91228,0,-0.514121,-40.095,-14.3903,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0baefee8-0fca-48e2-a364-08ee9da7bb98','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0baefee8-0fca-48e2-a364-08ee9da7bb98.png','SNAPS','PATIENT_643cd316-03a1-40a6-9e5d-dcb921b255e1_ACT_4e1c1695-cccd-41d5-a514-216c852e0aed_SESS_96d7b868-62c1-4fbf-98d5-550387438665_TOSC_f1f1801f-7045-486c-a1ad-fb9e8ffac994_SNAPS_','2021-03-24 11:13:55','2021-03-24 12:02:42','0baefee8-0fca-48e2-a364-08ee9da7bb98.png','2021-03-24 12:13:55','SYNCED','0baefee8-0fca-48e2-a364-08ee9da7bb98',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.113.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0bb025a0-9165-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bb025a0-9165-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_66b1d09a-a057-4c0c-8cf3-b44067707c25_SESS_c051925e-f943-40b5-9772-e8f0c9e67f55_TOSC_b2d208f5-bf91-4aac-bc0a-053c4df99dea_SNAPS_','2021-03-30 14:18:32','2021-03-30 16:18:30','0bb025a0-9165-11eb-9377-226cec7cb58a.png','2021-03-30 16:18:32','SYNCED','0bb025a0-9165-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.3.9.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0bb2e75f-9165-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bb2e75f-9165-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_66b1d09a-a057-4c0c-8cf3-b44067707c25_SESS_c051925e-f943-40b5-9772-e8f0c9e67f55_TOSC_8e08be1e-6124-4e1d-8041-380782cca4a1_SNAPS_','2021-03-30 14:22:51','2021-03-30 16:22:50','0bb2e75f-9165-11eb-9377-226cec7cb58a.png','2021-03-30 16:22:51','SYNCED','0bb2e75f-9165-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.3.9.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0bb3156f-784a-4694-959a-d31bf2bef86a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bb3156f-784a-4694-959a-d31bf2bef86a.png','SNAPS','PATIENT_785b2632-9f19-49ff-a48a-6954f917316e_ACT_2d39ec8f-f34c-40fd-a7ae-afc0a3c4fdb6_SESS_3287a70c-ee75-4c66-813e-a769def8222b_TOSC_aba3e414-0e56-4124-b8e5-810d144fd680_SNAPS_','2021-03-24 13:00:50','2021-03-24 13:46:19','0bb3156f-784a-4694-959a-d31bf2bef86a.png','2021-03-24 14:00:50','SYNCED','0bb3156f-784a-4694-959a-d31bf2bef86a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.115.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0bb4cb26-6fd8-4a47-a122-eb9b4cc4fea0','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bb4cb26-6fd8-4a47-a122-eb9b4cc4fea0.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_c1ea63a0-3b74-4cad-b2ed-89a623512570_SESS_95093fcc-c6a9-4c7b-bdef-f89b356f3bf8_BOSC_5dcea0e2-212c-4f51-beb2-79a000735304_SNAPS_','2021-04-13 11:47:58','2021-04-13 13:47:57','0bb4cb26-6fd8-4a47-a122-eb9b4cc4fea0.png','2021-04-13 13:47:58','SYNCED','0bb4cb26-6fd8-4a47-a122-eb9b4cc4fea0',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.53.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0bb591a0-c9cc-4325-b9c9-f63771f5eb21','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bb591a0-c9cc-4325-b9c9-f63771f5eb21.png','SNAPS','PATIENT_091298b7-bb6a-4d73-8330-9e1ffb78a173_ACT_882ac909-1de5-40f3-a561-bd180bccb533_SESS_45560b36-916f-4b33-89a9-82459536ff5b_TOSC_3b6dbb50-312e-42d8-9b26-421decdbd479_SNAPS_','2022-01-04 16:04:06','2022-01-04 17:04:02','0bb591a0-c9cc-4325-b9c9-f63771f5eb21.png','2022-01-04 17:04:06','SYNCED','0bb591a0-c9cc-4325-b9c9-f63771f5eb21',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.167.6.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0bb61988-58b3-4729-bdb3-fd12fb9dd66b','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bb61988-58b3-4729-bdb3-fd12fb9dd66b.ply','PLY','PATIENT_79800714-3a11-492a-968f-622bbd8e9783_ACT_41d4d758-4903-4b9f-9879-b0cd991263dc_SESS_efbdcdeb-533e-4337-a4bf-4b566a4f1c96_BOSC_53a4caf7-9375-48e7-bac4-e4aacc743450_PLY_','2021-01-19 08:52:57','2021-01-19 09:50:22','0bb61988-58b3-4729-bdb3-fd12fb9dd66b.ply','2021-01-19 09:52:57','SYNCED','0bb61988-58b3-4729-bdb3-fd12fb9dd66b',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.12.1.2\",\"modelMatrix\":\"-0.965767,0.255861,-0.0427615,0,-0.25941,-0.952556,0.159198,0,1.61657e-9,0.164841,0.98632,0,-6.94906,11.1035,-26.413,1\",\"title\":\"Mandibule PLY\"}'),(2,'0bb6b8ea-9165-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bb6b8ea-9165-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_66b1d09a-a057-4c0c-8cf3-b44067707c25_SESS_c051925e-f943-40b5-9772-e8f0c9e67f55_BOSC_dad16a68-6c47-4f18-8a27-cae20e57462a_PLY_','2021-03-30 14:32:36','2021-03-30 16:32:35','0bb6b8ea-9165-11eb-9377-226cec7cb58a.ply','2021-03-30 16:32:36','SYNCED','0bb6b8ea-9165-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.9.1.3\",\"modelMatrix\":\"-0.997858,0.0652499,-0.00465625,0,-0.0654158,-0.995327,0.0710268,0,-7.98151e-11,0.0711793,0.997464,0,31.1052,12.3162,-16.0965,1\",\"title\":\"Mandibule PLY\"}'),(2,'0bb9288c-8a9a-4002-a834-5003ac3a7a95','','PLY','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_66b1d09a-a057-4c0c-8cf3-b44067707c25_SESS_c051925e-f943-40b5-9772-e8f0c9e67f55_BOSC_dad16a68-6c47-4f18-8a27-cae20e57462a_PLY_','2021-03-30 14:31:23','2021-03-30 16:31:20','','2021-03-30 16:31:23','SYNCED','0bb9288c-8a9a-4002-a834-5003ac3a7a95',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.9.1.3\",\"modelMatrix\":\"-0.997858,0.0652499,-0.00465625,0,-0.0654158,-0.995327,0.0710268,0,-7.98151e-11,0.0711793,0.997464,0,31.1052,12.3162,-16.0965,1\",\"title\":\"Mandibule PLY\"}'),(2,'0bb9969e-9165-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bb9969e-9165-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_66b1d09a-a057-4c0c-8cf3-b44067707c25_SESS_c051925e-f943-40b5-9772-e8f0c9e67f55_BOSC_69fddebb-236b-4528-9679-c399b590b99b_SNAPS_','2021-03-30 14:10:29','2021-03-30 16:10:28','0bb9969e-9165-11eb-9377-226cec7cb58a.png','2021-03-30 16:10:29','SYNCED','0bb9969e-9165-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.9.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0bbce3c6-9165-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bbce3c6-9165-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_66b1d09a-a057-4c0c-8cf3-b44067707c25_SESS_c051925e-f943-40b5-9772-e8f0c9e67f55_BOSC_69fddebb-236b-4528-9679-c399b590b99b_PLY_','2021-03-30 14:28:08','2021-03-30 16:28:07','0bbce3c6-9165-11eb-9377-226cec7cb58a.ply','2021-03-30 16:28:08','SYNCED','0bbce3c6-9165-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.9.1.1\",\"modelMatrix\":\"0.978519,-0.19367,0.0706572,0,0.206157,0.919252,-0.335373,0,-2.50361e-9,0.342736,0.939432,0,-14.718,17.2353,-19.6833,1\",\"title\":\"Mandibule PLY\"}'),(2,'0bbfc511-a30e-4e3c-aa07-087b335b578d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bbfc511-a30e-4e3c-aa07-087b335b578d.ply','PLY','PATIENT_8892a729-7b98-4726-983e-ec6c473dd682_ACT_e46254d7-795e-424f-a471-1b87c829a36f_SESS_8daa3164-f6a4-4b97-ba38-aecfd72f5632_TOSC_c6fc7f3a-ee08-4834-b1ce-bcb8a5fd6fba_PLY_','2020-12-16 10:52:27','2020-02-14 14:43:08','0bbfc511-a30e-4e3c-aa07-087b335b578d.ply','2020-12-16 11:52:27','SYNCED','0bbfc511-a30e-4e3c-aa07-087b335b578d',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.1\",\"modelMatrix\":\"0.568058,-0.811431,0.137443,0,0.822989,0.56008,-0.094868,0,2.47527e-9,0.167004,0.985956,0,-0.876338,-36.6533,-14.0626,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0bbff75c-9165-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bbff75c-9165-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_66b1d09a-a057-4c0c-8cf3-b44067707c25_SESS_c051925e-f943-40b5-9772-e8f0c9e67f55_TOSC_b2d208f5-bf91-4aac-bc0a-053c4df99dea_PLY_','2021-03-30 14:33:18','2021-03-30 16:33:16','0bbff75c-9165-11eb-9377-226cec7cb58a.ply','2021-03-30 16:33:18','SYNCED','0bbff75c-9165-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.3.9.1.2\",\"modelMatrix\":\"-0.297127,0.900354,-0.317929,0,-0.954838,-0.280172,0.0989332,0,-3.519e-10,0.332966,0.942939,0,-7.49684,-36.1491,-13.639,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0bc111fa-beaf-46a2-91be-1662bc947dd6','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bc111fa-beaf-46a2-91be-1662bc947dd6.png','SNAPS','PATIENT_5d30a2cb-9ff4-4a6a-a943-84be7cc64b67_ACT_d1d4ebb3-1d3e-4726-a8be-9860f3742ec4_SESS_895f4d84-2131-429b-842c-38796c8f28d2_TOSC_fdb713d3-b366-4f63-b65e-83c72fa9ae2c_SNAPS_','2022-03-04 13:40:23','2019-07-10 09:03:22','0bc111fa-beaf-46a2-91be-1662bc947dd6.png','2022-03-04 14:40:23','SYNCED','5bd6f1d5-33cf-4e79-b057-9bc309f51770',1,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 15.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0bc2dc7c-9165-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bc2dc7c-9165-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_66b1d09a-a057-4c0c-8cf3-b44067707c25_SESS_c051925e-f943-40b5-9772-e8f0c9e67f55_TOSC_a5180641-2d54-4dd2-8758-298675f8de99_SNAPS_','2021-03-30 14:14:24','2021-03-30 16:14:20','0bc2dc7c-9165-11eb-9377-226cec7cb58a.png','2021-03-30 16:14:24','SYNCED','0bc2dc7c-9165-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.3.9.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0bc2ec9a-4e76-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bc2ec9a-4e76-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_e67c44fa-320d-4cec-929c-0fac66b8a7ca_SESS_584f4de7-5dda-471a-8bd1-a202eb080ef8_TOSC_2ba7bd87-daec-4f84-8049-a1f5d84c1280_PLY_','2020-12-16 10:52:28','2020-02-12 15:10:21','0bc2ec9a-4e76-11ea-947d-226cec7cb58a.ply','2020-12-16 11:52:28','SYNCED','0bc2ec9a-4e76-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.3\",\"modelMatrix\":\"0.593925,-0.79189,0.141996,0,0.80452,0.584601,-0.104827,0,-5.06499e-9,0.176498,0.984301,0,-2.50945,-35.0588,-15.1893,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0bc4ef14-915e-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bc4ef14-915e-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_b5692467-bb25-410d-a7a3-6f286a4cd43b_ACT_90966155-0dc2-4e74-8253-1e3e7f501816_SESS_c86a4072-7e01-44e6-bcb6-da6adf2117a8_TOSC_56765c64-8a69-4d4d-8f98-9d7fa9445977_SNAPS_','2021-03-30 13:43:01','2021-03-30 15:17:50','0bc4ef14-915e-11eb-9377-226cec7cb58a.png','2021-03-30 15:43:01','SYNCED','0bc4ef14-915e-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.22.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0bc56f08-9165-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bc56f08-9165-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_66b1d09a-a057-4c0c-8cf3-b44067707c25_SESS_c051925e-f943-40b5-9772-e8f0c9e67f55_BOSC_a73d0616-93db-417c-a15c-1ff4dff3e8cb_SNAPS_','2021-03-30 14:26:58','2021-03-30 16:26:57','0bc56f08-9165-11eb-9377-226cec7cb58a.png','2021-03-30 16:26:58','SYNCED','0bc56f08-9165-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.9.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0bc5e16f-7357-4bc8-ae23-8aaf4ef00301','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bc5e16f-7357-4bc8-ae23-8aaf4ef00301.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_04e9224e-668d-4fa4-a4af-48f0c21bedb5_SESS_3ca16ceb-c2d2-41f1-a5b2-ca89d985280b_TOSC_54faa18b-df53-4424-bb8c-a3fc0b45c5c3_SNAPS_','2021-04-30 08:43:30','2021-04-30 10:43:28','0bc5e16f-7357-4bc8-ae23-8aaf4ef00301.png','2021-04-30 10:43:30','SYNCED','0bc5e16f-7357-4bc8-ae23-8aaf4ef00301',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.132.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0bc6f2d5-4e76-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bc6f2d5-4e76-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_e67c44fa-320d-4cec-929c-0fac66b8a7ca_SESS_584f4de7-5dda-471a-8bd1-a202eb080ef8_TOSC_2ba7bd87-daec-4f84-8049-a1f5d84c1280_SNAPS_','2020-12-16 10:52:28','2020-02-12 15:10:21','0bc6f2d5-4e76-11ea-947d-226cec7cb58a.png','2020-12-16 11:52:28','SYNCED','0bc6f2d5-4e76-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.3\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0bc89dfb-3470-4ef1-a7e7-41700dba34dc','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bc89dfb-3470-4ef1-a7e7-41700dba34dc.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_9c2ca0a2-ec23-4697-8917-881c190ee1bc_SESS_38027b0a-039c-4c1f-a9b1-23eb23cbcc81_TOSC_182c11ae-3608-4a79-ad26-390815e4c7ff_PLY_','2021-04-29 11:30:52','2021-04-29 13:30:42','0bc89dfb-3470-4ef1-a7e7-41700dba34dc.ply','2021-04-29 13:30:52','SYNCED','0bc89dfb-3470-4ef1-a7e7-41700dba34dc',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.128.1.2\",\"modelMatrix\":\"0.776261,-0.534744,0.333868,0,0.630412,0.65846,-0.41111,0,-2.31077e-9,0.529603,0.848246,0,11.2133,-36.7181,-22.2476,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0bc8a64a-9165-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bc8a64a-9165-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_66b1d09a-a057-4c0c-8cf3-b44067707c25_SESS_c051925e-f943-40b5-9772-e8f0c9e67f55_BOSC_dad16a68-6c47-4f18-8a27-cae20e57462a_SNAPS_','2021-03-30 14:31:21','2021-03-30 16:31:20','0bc8a64a-9165-11eb-9377-226cec7cb58a.png','2021-03-30 16:31:21','SYNCED','0bc8a64a-9165-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.9.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0bc8c522-4e76-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bc8c522-4e76-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_e67c44fa-320d-4cec-929c-0fac66b8a7ca_SESS_584f4de7-5dda-471a-8bd1-a202eb080ef8_BOSC_a839179b-0053-4b45-954c-a0b9c9e06bd4_SNAPS_','2020-12-16 10:52:28','2020-02-12 10:43:23','0bc8c522-4e76-11ea-947d-226cec7cb58a.png','2020-12-16 11:52:28','SYNCED','0bc8c522-4e76-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0bc9cb6d-ac4a-4b45-bcad-c833102de033','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bc9cb6d-ac4a-4b45-bcad-c833102de033.stl','STL','PATIENT_61967112-3a78-48fd-bc51-0c68d4fe392d_ACT_41259790-3c8e-4f1f-ac65-03a90c5da37b_SESS_85c43b2b-59af-425b-82b7-7afb265e62f2_TOSC_9ac76aa6-15c9-4d28-aa8f-771eaacb5e63_STL_','2021-12-30 18:03:21','2019-11-22 08:02:51','0bc9cb6d-ac4a-4b45-bcad-c833102de033.stl','2021-12-30 19:03:21','SYNCED','0bc9cb6d-ac4a-4b45-bcad-c833102de033',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 202.4.1.1\",\"modelMatrix\":\"0.643115,-0.717199,0.268383,0,0.76577,0.602323,-0.225396,0,8.23696e-9,0.350475,0.936572,0,-1.42724,-37.9988,-20.7265,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'0bcc102d-9165-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bcc102d-9165-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_66b1d09a-a057-4c0c-8cf3-b44067707c25_SESS_c051925e-f943-40b5-9772-e8f0c9e67f55_TOSC_a5180641-2d54-4dd2-8758-298675f8de99_PLY_','2021-03-30 14:32:59','2021-03-30 16:32:58','0bcc102d-9165-11eb-9377-226cec7cb58a.ply','2021-03-30 16:32:59','SYNCED','0bcc102d-9165-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.3.9.1.1\",\"modelMatrix\":\"0.125884,0.887563,-0.443153,0,-0.992045,0.112626,-0.0562332,0,7.69831e-10,0.446707,0.89468,0,-14.2882,-36.8271,-11.3557,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0bcc4090-4e76-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bcc4090-4e76-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_e67c44fa-320d-4cec-929c-0fac66b8a7ca_SESS_584f4de7-5dda-471a-8bd1-a202eb080ef8_BOSC_a839179b-0053-4b45-954c-a0b9c9e06bd4_PLY_','2020-12-16 10:52:29','2020-02-12 10:43:23','0bcc4090-4e76-11ea-947d-226cec7cb58a.ply','2020-12-16 11:52:29','SYNCED','0bcc4090-4e76-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"modelMatrix\":\"-0.624188,0.772523,-0.116608,0,-0.781274,-0.617196,0.093162,0,4.23084e-9,0.149253,0.988799,0,6.53274,19.1368,-15.6158,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0bcc51bc-915e-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bcc51bc-915e-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_b5692467-bb25-410d-a7a3-6f286a4cd43b_ACT_90966155-0dc2-4e74-8253-1e3e7f501816_SESS_c86a4072-7e01-44e6-bcb6-da6adf2117a8_BOSC_2b3b8d36-cbe0-4e91-baca-de5c261203a6_PLY_','2021-03-30 13:43:01','2021-03-30 15:39:14','0bcc51bc-915e-11eb-9377-226cec7cb58a.ply','2021-03-30 15:43:01','SYNCED','0bcc51bc-915e-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.22.1.3\",\"modelMatrix\":\"-0.992523,-0.108102,0.0566678,0,0.122054,-0.879064,0.460814,0,1.62548e-10,0.464285,0.885686,0,-22.688,7.93274,-19.5599,1\",\"title\":\"Mandibule PLY\"}'),(2,'0bcf5472-915e-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bcf5472-915e-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_b5692467-bb25-410d-a7a3-6f286a4cd43b_ACT_90966155-0dc2-4e74-8253-1e3e7f501816_SESS_c86a4072-7e01-44e6-bcb6-da6adf2117a8_BOSC_9dc5a124-f7bf-492e-8665-71ee3dafff1b_PLY_','2021-03-30 13:43:05','2021-03-30 15:35:23','0bcf5472-915e-11eb-9377-226cec7cb58a.ply','2021-03-30 15:43:05','SYNCED','0bcf5472-915e-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.22.1.2\",\"modelMatrix\":\"-0.974304,-0.22278,0.033177,0,0.225237,-0.963676,0.143513,0,2.73436e-9,0.147298,0.989092,0,-16.9886,9.9423,-24.4128,1\",\"title\":\"Mandibule PLY\"}'),(2,'0bd058b5-9165-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bd058b5-9165-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_66b1d09a-a057-4c0c-8cf3-b44067707c25_SESS_c051925e-f943-40b5-9772-e8f0c9e67f55_BOSC_a73d0616-93db-417c-a15c-1ff4dff3e8cb_PLY_','2021-03-30 14:27:33','2021-03-30 16:27:32','0bd058b5-9165-11eb-9377-226cec7cb58a.ply','2021-03-30 16:27:33','SYNCED','0bd058b5-9165-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.9.1.2\",\"modelMatrix\":\"0.0231098,0.999718,-0.00548402,0,-0.999733,0.0231094,-0.000126768,0,7.62537e-12,0.00548549,0.999985,0,13.9085,-32.6141,-19.7251,1\",\"title\":\"Mandibule PLY\"}'),(2,'0bd26b64-915e-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bd26b64-915e-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_b5692467-bb25-410d-a7a3-6f286a4cd43b_ACT_90966155-0dc2-4e74-8253-1e3e7f501816_SESS_c86a4072-7e01-44e6-bcb6-da6adf2117a8_TOSC_1e04df42-be14-41c8-b724-5fa4cf59c5e3_SNAPS_','2021-03-30 13:43:02','2021-03-30 15:21:22','0bd26b64-915e-11eb-9377-226cec7cb58a.png','2021-03-30 15:43:02','SYNCED','0bd26b64-915e-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.22.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0bd54e01-cd62-4165-b800-b0c1e5141b37','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bd54e01-cd62-4165-b800-b0c1e5141b37.ply','PLY','PATIENT_6cd6a42b-39d2-4994-8d0a-a6c3a5239659_ACT_45cecd49-817c-4e0f-b944-ee8ee96af87f_SESS_260ed56d-913e-4f34-ac67-a46a0f2beead_TOSC_47292505-0df4-4420-80ac-3778c50417da_PLY_','2021-02-25 13:58:22','2021-02-25 14:27:00','0bd54e01-cd62-4165-b800-b0c1e5141b37.ply','2021-02-25 14:58:22','SYNCED','0bd54e01-cd62-4165-b800-b0c1e5141b37',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.54.1.1\",\"modelMatrix\":\"0.393689,-0.859403,0.326244,0,0.919244,0.36806,-0.139722,0,3.43942e-9,0.354905,0.934902,0,-7.21359,-30.8332,-18.3173,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0bd5cd0c-915e-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bd5cd0c-915e-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_b5692467-bb25-410d-a7a3-6f286a4cd43b_ACT_90966155-0dc2-4e74-8253-1e3e7f501816_SESS_c86a4072-7e01-44e6-bcb6-da6adf2117a8_BOSC_e525034c-8580-4165-8c84-6bb7d9cf911d_PLY_','2021-03-30 13:43:04','2021-03-30 15:27:26','0bd5cd0c-915e-11eb-9377-226cec7cb58a.ply','2021-03-30 15:43:04','SYNCED','0bd5cd0c-915e-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.22.1.1\",\"modelMatrix\":\"-0.987106,-0.148373,0.0600541,0,0.160066,-0.914998,0.370347,0,-3.81711e-10,0.375184,0.92695,0,-28.2315,7.74163,-21.271,1\",\"title\":\"Mandibule PLY\"}'),(2,'0bd8c4ad-915e-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bd8c4ad-915e-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_b5692467-bb25-410d-a7a3-6f286a4cd43b_ACT_90966155-0dc2-4e74-8253-1e3e7f501816_SESS_c86a4072-7e01-44e6-bcb6-da6adf2117a8_BOSC_e525034c-8580-4165-8c84-6bb7d9cf911d_SNAPS_','2021-03-30 13:43:04','2021-03-30 15:27:26','0bd8c4ad-915e-11eb-9377-226cec7cb58a.png','2021-03-30 15:43:04','SYNCED','0bd8c4ad-915e-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.22.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0bdbc4d6-915e-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bdbc4d6-915e-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_b5692467-bb25-410d-a7a3-6f286a4cd43b_ACT_90966155-0dc2-4e74-8253-1e3e7f501816_SESS_c86a4072-7e01-44e6-bcb6-da6adf2117a8_BOSC_9dc5a124-f7bf-492e-8665-71ee3dafff1b_SNAPS_','2021-03-30 13:43:04','2021-03-30 15:35:23','0bdbc4d6-915e-11eb-9377-226cec7cb58a.png','2021-03-30 15:43:04','SYNCED','0bdbc4d6-915e-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.22.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0bdce612-c6b1-41de-9758-413b285136c6','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bdce612-c6b1-41de-9758-413b285136c6.ply','PLY','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_e57a553c-41cd-4055-bba6-11b42bb48377_SESS_af29201d-4894-416b-baa6-9f7d35184ac2_BOSC_166c0704-315e-4bc1-a428-858ebc1b3953_PLY_','2020-12-07 12:01:23','2020-08-19 15:26:01','0bdce612-c6b1-41de-9758-413b285136c6.ply','2020-12-07 13:01:23','SYNCED','0bdce612-c6b1-41de-9758-413b285136c6',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.26.31.1.1\",\"modelMatrix\":\"-0.961701,0.259417,-0.0885133,0,-0.274101,-0.910178,0.310554,0,5.65805e-9,0.322922,0.946426,0,-6.58128,15.8015,-21.3267,1\",\"title\":\"Mandibule PLY\"}'),(2,'0bddd38c-0fa2-4658-bcdb-35ece7ac47aa','','PLY','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_13648b48-b47d-4bcd-85a0-5211df734260_SESS_9a6d7c2c-addd-4900-a36e-a849376b43ad_TOSC_743b310b-f9aa-494e-a25b-c4c7904464a2_PLY_','2021-04-07 08:26:06','2021-04-07 10:26:03','','2021-04-07 10:26:06','SYNCED','0bddd38c-0fa2-4658-bcdb-35ece7ac47aa',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.3.10.1.2\",\"modelMatrix\":\"0.584751,0.759365,-0.285361,0,-0.811212,0.547378,-0.205698,0,1.144e-8,0.35177,0.936086,0,-0.35607,-35.7548,-15.4001,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0bdf628a-915e-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bdf628a-915e-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_b5692467-bb25-410d-a7a3-6f286a4cd43b_ACT_90966155-0dc2-4e74-8253-1e3e7f501816_SESS_c86a4072-7e01-44e6-bcb6-da6adf2117a8_BOSC_2b3b8d36-cbe0-4e91-baca-de5c261203a6_SNAPS_','2021-03-30 13:43:01','2021-03-30 15:39:14','0bdf628a-915e-11eb-9377-226cec7cb58a.png','2021-03-30 15:43:01','SYNCED','0bdf628a-915e-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.22.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0bdfda11-aaf2-48f6-88a5-d3b086210608','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bdfda11-aaf2-48f6-88a5-d3b086210608.stl','STL','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_fd694b3f-abde-4e46-91f7-7c62bfdcafa4_SESS_73a3f5b9-e905-4911-a163-2022e1de3380_TOSC_457a2de3-d779-43f0-a00d-b2e6ff55cf7a_STL_','2021-08-19 22:27:06','2019-11-26 16:43:24','0bdfda11-aaf2-48f6-88a5-d3b086210608.stl','2021-08-20 00:27:06','SYNCED','0bdfda11-aaf2-48f6-88a5-d3b086210608',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1\",\"modelMatrix\":\"0.818284,-0.543486,0.187172,0,0.574814,0.773688,-0.266452,0,-1.39837e-9,0.325622,0.9455,0,13.2322,-32.4371,-9.58114,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'0be26f51-915e-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0be26f51-915e-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_b5692467-bb25-410d-a7a3-6f286a4cd43b_ACT_90966155-0dc2-4e74-8253-1e3e7f501816_SESS_c86a4072-7e01-44e6-bcb6-da6adf2117a8_TOSC_1e04df42-be14-41c8-b724-5fa4cf59c5e3_PLY_','2021-03-30 13:43:02','2021-03-30 15:21:22','0be26f51-915e-11eb-9377-226cec7cb58a.ply','2021-03-30 15:43:02','SYNCED','0be26f51-915e-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.22.1.3\",\"modelMatrix\":\"0.648878,-0.696176,0.307077,0,0.760893,0.593688,-0.26187,0,-2.00495e-8,0.403575,0.914947,0,2.6247,-32.974,-21.2139,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0be2ba47-6397-47d5-b9a8-80de61e83cb1','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0be2ba47-6397-47d5-b9a8-80de61e83cb1.ply','PLY','PATIENT_60337f02-8dc5-49ce-b0bb-1548b081473d_ACT_21efaafa-313e-4152-b6df-df2a1f68fd61_SESS_4bc32c9d-46a9-4dcc-9d12-f6e805212837_TOSC_9bf554d7-2ad7-46ce-8daf-0e2cddda153d_PLY_','2022-02-01 11:47:30','2019-09-19 11:43:22','0be2ba47-6397-47d5-b9a8-80de61e83cb1.ply','2022-02-01 12:47:30','SYNCED','0be2ba47-6397-47d5-b9a8-80de61e83cb1',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 154.1.1.1\",\"modelMatrix\":\"0.613971,-0.717439,0.329121,0,0.789328,0.558053,-0.256004,0,8.15742e-10,0.416963,0.908923,0,-4.20645,-38.7581,-20.2512,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0be55ea6-915e-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0be55ea6-915e-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_b5692467-bb25-410d-a7a3-6f286a4cd43b_ACT_90966155-0dc2-4e74-8253-1e3e7f501816_SESS_c86a4072-7e01-44e6-bcb6-da6adf2117a8_TOSC_276415f5-7387-4acb-a54e-8ad097a8c55a_PLY_','2021-03-30 13:43:01','2021-03-30 15:13:14','0be55ea6-915e-11eb-9377-226cec7cb58a.ply','2021-03-30 15:43:01','SYNCED','0be55ea6-915e-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.22.1.1\",\"modelMatrix\":\"0.745158,-0.607449,0.275218,0,0.666888,0.678743,-0.307519,0,-1.47888e-9,0.41269,0.910871,0,5.17202,-35.3793,-15.8985,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0be5769b-37a8-4dd2-b1c2-9a5f090380e1','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0be5769b-37a8-4dd2-b1c2-9a5f090380e1.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_4f88b07b-6058-4353-9fad-d225198e8b8f_SESS_c41ce2cc-5005-4e6c-902a-8cf79e5ff82f_BOSC_8e174bf1-cdc7-46c4-ace3-d1d79a3e7683_SNAPS_','2021-04-28 09:33:08','2021-04-28 11:33:07','0be5769b-37a8-4dd2-b1c2-9a5f090380e1.png','2021-04-28 11:33:08','SYNCED','0be5769b-37a8-4dd2-b1c2-9a5f090380e1',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.123.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0be63229-a7c0-4cb6-8f9c-8e8509dff31a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0be63229-a7c0-4cb6-8f9c-8e8509dff31a.png','SNAPS','PATIENT_cbd259d8-b167-4ae5-b02e-593bafa6de29_ACT_950b6d17-2c4c-4052-969e-e70f65959620_SESS_7f9de4d9-f433-4a03-a9d6-dc607602722c_BOSC_1a254ae0-0561-4e8f-b72b-420fd73295a2_SNAPS_','2021-01-06 11:02:52','2019-12-13 16:18:00','0be63229-a7c0-4cb6-8f9c-8e8509dff31a.png','2021-01-06 12:02:52','SYNCED','0be63229-a7c0-4cb6-8f9c-8e8509dff31a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 232.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0be80684-915e-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0be80684-915e-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_b5692467-bb25-410d-a7a3-6f286a4cd43b_ACT_90966155-0dc2-4e74-8253-1e3e7f501816_SESS_c86a4072-7e01-44e6-bcb6-da6adf2117a8_TOSC_56765c64-8a69-4d4d-8f98-9d7fa9445977_PLY_','2021-03-30 13:43:01','2021-03-30 15:17:50','0be80684-915e-11eb-9377-226cec7cb58a.ply','2021-03-30 15:43:01','SYNCED','0be80684-915e-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.22.1.2\",\"modelMatrix\":\"0.837807,-0.49406,0.232345,0,0.545966,0.758154,-0.356542,0,-9.62921e-9,0.425566,0.904927,0,7.26584,-29.0486,-19.363,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0beb7b74-915e-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0beb7b74-915e-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_b5692467-bb25-410d-a7a3-6f286a4cd43b_ACT_90966155-0dc2-4e74-8253-1e3e7f501816_SESS_c86a4072-7e01-44e6-bcb6-da6adf2117a8_TOSC_276415f5-7387-4acb-a54e-8ad097a8c55a_SNAPS_','2021-03-30 13:43:02','2021-03-30 15:13:14','0beb7b74-915e-11eb-9377-226cec7cb58a.png','2021-03-30 15:43:02','SYNCED','0beb7b74-915e-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.22.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0beb92b7-8756-4fd8-a119-5dab4a710814','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0beb92b7-8756-4fd8-a119-5dab4a710814.png','SNAPS','PATIENT_bd1eba7e-0abe-41fc-859e-90761a16482e_ACT_896e85b9-5776-4f4b-a605-57a738ffaf31_SESS_eecc3c10-e747-4234-b94e-6ef19f29289b_TOSC_a0c8a85b-4b2d-492f-ad63-03fbd49b6ab8_SNAPS_','2021-01-15 08:42:11','2021-01-15 09:20:48','0beb92b7-8756-4fd8-a119-5dab4a710814.png','2021-01-15 09:42:11','SYNCED','0beb92b7-8756-4fd8-a119-5dab4a710814',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.5.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0bec5f8f-eb23-4785-8a10-09a63a5039cc','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bec5f8f-eb23-4785-8a10-09a63a5039cc.ply','PLY','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_8dbee3c4-faff-4b40-b8d0-42cf19ca2719_SESS_edb7426a-3c83-43c9-a94e-3cdb103e995c_BOSC_b6f632f4-21e2-4c71-9a52-26f0f53c1a8f_PLY_','2021-04-07 15:16:30','2021-04-07 17:16:29','0bec5f8f-eb23-4785-8a10-09a63a5039cc.ply','2021-04-07 17:16:30','SYNCED','8070e3f9-682d-4ea7-9216-05794247e0b0',1,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.19.1.1\",\"modelMatrix\":\"-0.795701,-0.587279,0.148201,0,0.60569,-0.771514,0.194693,0,3.96812e-9,0.244681,0.969604,0,12.6889,27.5485,-20.0509,1\",\"title\":\"Mandibule PLY\"}'),(2,'0bed3dc8-beb6-4ec0-9372-af0c7c4d6aa0','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bed3dc8-beb6-4ec0-9372-af0c7c4d6aa0.zip','ZIP','PATIENT_091298b7-bb6a-4d73-8330-9e1ffb78a173_ACT_46811654-c690-427c-9472-125b25b959b3_SESS_cc05c731-5ab1-44f3-9aa6-3c34199bca64_TOSC_aaa3e82a-678a-4c72-9645-2dbaeb0be771_ZIP_','2022-01-03 09:52:59','2022-01-03 10:52:56','0bed3dc8-beb6-4ec0-9372-af0c7c4d6aa0.zip','2022-01-03 10:52:59','SYNCED','0bed3dc8-beb6-4ec0-9372-af0c7c4d6aa0',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.167.2.1.2\",\"modelMatrix\":\"0.445074,-0.875338,0.188924,0,0.895494,0.435057,-0.0938982,0,-3.2103e-9,0.210972,0.977492,0,-7.5194,-37.6912,-16.9146,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'0bee1206-bf5a-4e13-9d6e-0a26614de441','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bee1206-bf5a-4e13-9d6e-0a26614de441.ply','PLY','PATIENT_615446e9-77f9-45e7-8f94-bd45699eaa81_ACT_cd7fb1a5-dd0c-4c70-b6b5-abfa53741e5a_SESS_36e1c186-e134-4a75-9aaa-3997db781a60_BOSC_2bed089e-68c3-431b-99b5-222a86530979_PLY_','2020-12-16 11:08:19','2020-01-24 14:18:24','0bee1206-bf5a-4e13-9d6e-0a26614de441.ply','2020-12-16 12:08:19','SYNCED','0bee1206-bf5a-4e13-9d6e-0a26614de441',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 283.61.1.1.17\",\"modelMatrix\":\"-0.908515,0.388306,-0.154331,0,-0.417851,-0.844276,0.335556,0,-1.75121e-8,0.369345,0.929292,0,-7.51411,22.2665,-17.6662,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0bee9f9d-45b0-4d08-90d0-87abd498c3ce','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bee9f9d-45b0-4d08-90d0-87abd498c3ce.ply','PLY','PATIENT_73c985ea-640e-4a47-9491-9a3c21b4ebfa_ACT_99775151-85d6-49ff-9af3-ee5666eb91fc_SESS_025831f2-5bfc-4fa7-b28a-299157e186f5_BOSC_0071a755-cc77-4079-8393-0af914eb4e0c_PLY_','2021-03-01 10:13:49','2021-03-01 11:08:15','0bee9f9d-45b0-4d08-90d0-87abd498c3ce.ply','2021-03-01 11:13:49','SYNCED','0bee9f9d-45b0-4d08-90d0-87abd498c3ce',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.65.1.1\",\"modelMatrix\":\"-0.999983,0.00542127,-0.00206371,0,-0.00580078,-0.93456,0.355758,0,4.55335e-11,0.355764,0.934576,0,-18.7768,9.98937,-19.6885,1\",\"title\":\"Mandibule PLY\"}'),(2,'0bf8cf83-d5fb-41ae-8c2c-1a337e7f2bdf','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bf8cf83-d5fb-41ae-8c2c-1a337e7f2bdf.png','SNAPS','PATIENT_7ba92652-afee-4923-b0e5-5c6f639eef34_ACT_93c1572c-ea31-4ce0-b14b-8e4f7c735ddd_SESS_b63f2baa-6b1c-4cba-9fb5-a0a17d070a93_TOSC_ffefc120-28a3-4bcf-a765-da1144bf03bd_SNAPS_','2020-12-16 11:08:19','2020-01-15 14:32:58','0bf8cf83-d5fb-41ae-8c2c-1a337e7f2bdf.png','2020-12-16 12:08:19','SYNCED','0bf8cf83-d5fb-41ae-8c2c-1a337e7f2bdf',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0bfa82ed-012f-456a-aa49-90a1b78759eb','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0bfa82ed-012f-456a-aa49-90a1b78759eb.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_9dcc3d38-3a64-4848-aae9-3d6efca8c19b_SESS_aa4cef4d-d6e9-4c23-9795-622754bff084_BOSC_81776d8f-a5db-4862-adfc-b1160f6a8663_SNAPS_','2021-04-16 07:57:06','2021-04-16 09:57:05','0bfa82ed-012f-456a-aa49-90a1b78759eb.png','2021-04-16 09:57:06','SYNCED','0bfa82ed-012f-456a-aa49-90a1b78759eb',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.71.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0c02309a-7dd0-453a-a493-2c95cc73a124','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c02309a-7dd0-453a-a493-2c95cc73a124.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_b7d39927-945d-4f11-927d-bdd01de3a358_SESS_aae3fab3-ee92-474f-b0e8-279f3beef36d_BOSC_c53f57a1-e0a3-4410-a658-c4b4933c09ce_ZIP_','2022-01-05 13:27:08','2022-01-05 14:27:00','0c02309a-7dd0-453a-a493-2c95cc73a124.zip','2022-01-05 14:27:08','SYNCED','0c02309a-7dd0-453a-a493-2c95cc73a124',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.5.1.1\",\"modelMatrix\":\"-0.88807,-0.432323,0.156294,0,0.459708,-0.835168,0.301931,0,8.05189e-9,0.339986,0.94043,0,-20.0274,6.79076,-18.9929,1\",\"title\":\"Mandibule ZIP\"}'),(2,'0c08b06e-5acf-42d5-8e80-9e9b4311ed63','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c08b06e-5acf-42d5-8e80-9e9b4311ed63.png','SNAPS','PATIENT_0379f83f-2e06-4f1d-9d08-c90cd857fe89_ACT_76b3beac-11ce-4742-97fb-ea0345b94d35_SESS_49e44a0d-d303-43e0-94c7-f81e248f7980_TOSC_59c30d46-edc5-471c-be16-62769625224d_SNAPS_','2020-12-16 11:08:20','2020-01-23 14:39:53','0c08b06e-5acf-42d5-8e80-9e9b4311ed63.png','2020-12-16 12:08:20','SYNCED','0c08b06e-5acf-42d5-8e80-9e9b4311ed63',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.1.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0c0c560f-10cb-42b2-b389-611c48199d3e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c0c560f-10cb-42b2-b389-611c48199d3e.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_9f8db8ae-7ab2-4471-841f-da891d322f5a_SESS_88cef6cd-2e57-45a9-a2db-0e3cc2c23de7_BOSC_808c9c18-a8fc-463b-9131-f6564bf63023_SNAPS_','2021-05-07 12:51:13','2021-05-07 14:51:12','0c0c560f-10cb-42b2-b389-611c48199d3e.png','2021-05-07 14:51:13','SYNCED','0c0c560f-10cb-42b2-b389-611c48199d3e',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.148.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0c0def62-d293-4f15-aa73-f7dea560f04e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c0def62-d293-4f15-aa73-f7dea560f04e.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_f92ed3c4-058c-4b9e-9eb9-41aa4081126e_SESS_5ff81632-8afc-4443-ae0f-1722a0365361_TOSC_2247471e-114f-4408-aec1-8310c850dad8_SNAPS_','2021-04-26 09:12:17','2021-04-26 11:12:15','0c0def62-d293-4f15-aa73-f7dea560f04e.png','2021-04-26 11:12:17','SYNCED','0c0def62-d293-4f15-aa73-f7dea560f04e',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.100.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0c0e1423-1f0a-461b-bd2e-e3694974e047','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c0e1423-1f0a-461b-bd2e-e3694974e047.png','SNAPS','PATIENT_44a40db9-fa62-4f37-b30f-2597aedddfc1_ACT_dd06e401-0833-4c76-a105-5255d7d720a6_SESS_491c2bb3-be90-4554-837f-0329032959c5_TOSC_8ac6b28f-485f-424a-bda3-28c649cc98a2_SNAPS_','2020-12-02 10:32:36','2020-11-02 13:47:49','0c0e1423-1f0a-461b-bd2e-e3694974e047.png','2020-12-02 11:32:36','SYNCED','0c0e1423-1f0a-461b-bd2e-e3694974e047',0,NULL,'','','{\"displayTitle\":\"Maxilla 1.16.9.1.1\",\"title\":\"Maxilla SNAPSHOT\"}'),(2,'0c19ea99-2c4d-477c-ae9e-c1ac80296ad2','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c19ea99-2c4d-477c-ae9e-c1ac80296ad2.ply','PLY','PATIENT_0cc4ef86-2202-4a20-b6c2-a4a99611d672_ACT_8e932d08-b390-4a0d-a0bc-1d8397692541_SESS_72797c78-f87a-4ed7-b4a5-e6627fcfa3c8_TOSC_1f1fc717-d295-40a6-a4a5-e8b292102646_PLY_','2020-12-08 17:27:04','2020-06-30 10:27:28','0c19ea99-2c4d-477c-ae9e-c1ac80296ad2.ply','2020-12-08 18:27:04','SYNCED','0c19ea99-2c4d-477c-ae9e-c1ac80296ad2',0,NULL,'','','{\"displayTitle\":\"Maxillaire 88.2.9.1.1\",\"modelMatrix\":\"-0.238544,-0.928868,0.283376,0,0.971132,-0.228162,0.0696069,0,7.86269e-9,0.291799,0.956479,0,-25.1999,-26.805,-18.5473,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0c1a933a-b747-47b1-9aef-e59cb8a6c5c4','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c1a933a-b747-47b1-9aef-e59cb8a6c5c4.png','SNAPS','PATIENT_70311767-96f2-478b-b301-288b4fcffd6d_ACT_ef042218-af83-44b7-ae52-dbbba702b880_SESS_5a85653f-f035-44d0-99d5-440eb0b744f9_BOSC_6818727a-dc0d-48ee-be73-9876087c5cfd_SNAPS_','2021-01-19 13:09:01','2021-01-19 14:05:00','0c1a933a-b747-47b1-9aef-e59cb8a6c5c4.png','2021-01-19 14:09:01','SYNCED','0c1a933a-b747-47b1-9aef-e59cb8a6c5c4',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.13.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0c1b3106-dc95-400f-adca-0f6d1860b395','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c1b3106-dc95-400f-adca-0f6d1860b395.png','SNAPS','PATIENT_96afd601-d8c2-4e20-abec-292b75f99b16_ACT_1b95d362-259d-45d0-b12b-f82c49c26c12_SESS_812c317a-661f-4f64-916c-40d448feeca0_TOSC_efb79c65-d8d5-4616-88c4-87020d1d032c_SNAPS_','2021-08-19 22:27:07','2019-12-05 15:34:21','0c1b3106-dc95-400f-adca-0f6d1860b395.png','2021-08-20 00:27:07','SYNCED','0c1b3106-dc95-400f-adca-0f6d1860b395',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 224.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0c1cb5f2-fb80-42d2-a8ad-760b4cc179bf','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c1cb5f2-fb80-42d2-a8ad-760b4cc179bf.ply','PLY','PATIENT_d2a58201-ab6d-462b-990c-287178c6b7e6_ACT_5b1e42c7-27a4-4ce5-b0d4-9ecfd1e65242_SESS_7ab5d6a7-b793-47b7-ac57-faf4c65524ca_BOSC_d82f1e96-d5e8-43f1-a7a2-cbbfce773e77_PLY_','2021-03-18 15:22:29','2021-03-18 16:17:56','0c1cb5f2-fb80-42d2-a8ad-760b4cc179bf.ply','2021-03-18 16:22:29','SYNCED','0c1cb5f2-fb80-42d2-a8ad-760b4cc179bf',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.97.1.2\",\"modelMatrix\":\"-0.994036,-0.105827,0.026325,0,0.109052,-0.964639,0.239958,0,-6.30429e-10,0.241398,0.970426,0,-26.4607,14.376,-15.5522,1\",\"title\":\"Mandibule PLY\"}'),(2,'0c1e2b77-6232-499e-afb7-96936d9913bc','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c1e2b77-6232-499e-afb7-96936d9913bc.png','SNAPS','PATIENT_55452abe-c899-4508-a6ad-a6862da81096_ACT_10244838-8d43-4b45-843e-1b1867b80fe9_SESS_a27242e6-79e3-49b8-9935-388a52c32306_BOSC_c8c05cc5-ac7c-4b2a-9eea-e2f370f9081e_SNAPS_','2020-12-08 17:27:04','2020-06-17 10:27:27','0c1e2b77-6232-499e-afb7-96936d9913bc.png','2020-12-08 18:27:04','SYNCED','0c1e2b77-6232-499e-afb7-96936d9913bc',0,NULL,'','','{\"displayTitle\":\"Mandibule 32.1.1.1.11\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0c2ed37b-22c6-488e-b36e-126a48f7dc9b','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c2ed37b-22c6-488e-b36e-126a48f7dc9b.stl','STL','PATIENT_aa5e1eb6-28e8-427f-b638-8f78e6c6a67c_ACT_87cb19c3-f54a-4c63-ac5f-47eef98d329e_SESS_d040337d-b8cd-499c-a0b9-2c3d9c4a35b7_TOSC_797d271a-88c8-4866-af1b-ff8894ed3efd_STL_','2021-12-30 18:03:21','2019-11-22 08:56:44','0c2ed37b-22c6-488e-b36e-126a48f7dc9b.stl','2021-12-30 19:03:21','SYNCED','0c2ed37b-22c6-488e-b36e-126a48f7dc9b',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 202.1.2.1\",\"modelMatrix\":\"0.707649,-0.653658,0.26826,0,0.706564,0.654663,-0.268672,0,2.23066e-9,0.379668,0.925123,0,5.9275,-38.3022,-16.0092,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'0c317f25-6317-487a-a1a9-ed4e6da002b7','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c317f25-6317-487a-a1a9-ed4e6da002b7.png','SNAPS','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_73c89c5c-4f86-40a7-8368-f41b3c1ccf7a_SESS_db9ab031-4725-4b7f-baf0-20f9e3b4911f_BOSC_23fb14cf-4c52-421e-9b80-217198438f1a_SNAPS_','2020-12-16 10:52:31','2020-05-20 17:05:29','0c317f25-6317-487a-a1a9-ed4e6da002b7.png','2020-12-16 11:52:31','SYNCED','0c317f25-6317-487a-a1a9-ed4e6da002b7',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 216.1.8.1.2\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0c3488d6-850e-4e3c-bcb5-fb577dd4c285','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c3488d6-850e-4e3c-bcb5-fb577dd4c285.png','SNAPS','PATIENT_1d77fb2e-459b-4e9b-8a7c-24c3c00e3836_ACT_2124bc7a-dee4-4a6d-b070-0e0912857e88_SESS_c11cefba-9ae6-4fae-abd6-1c26f353a78a_TOSC_d17fafd2-9efc-4e1a-856e-6cf5d93b9bb0_SNAPS_','2021-02-15 15:52:19','2021-02-15 16:32:06','0c3488d6-850e-4e3c-bcb5-fb577dd4c285.png','2021-02-15 16:52:19','SYNCED','0c3488d6-850e-4e3c-bcb5-fb577dd4c285',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.45.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0c3ea86a-eab2-4e15-97ea-8650b94816fd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c3ea86a-eab2-4e15-97ea-8650b94816fd.ply','PLY','PATIENT_da138baf-c251-430a-bd5b-ebe7cb84baf4_ACT_d83a842b-6af8-4f4d-93e6-529df0125616_SESS_f088949e-a87a-470b-a75b-112472c71556_BOSC_d308b128-dadc-4b88-bda6-647b96dc9fb4_PLY_','2020-12-29 08:26:59','2020-12-29 09:21:46','0c3ea86a-eab2-4e15-97ea-8650b94816fd.ply','2020-12-29 09:26:59','SYNCED','0c3ea86a-eab2-4e15-97ea-8650b94816fd',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.48.1.1\",\"modelMatrix\":\"-0.997607,0.062986,-0.0285019,0,-0.0691346,-0.908884,0.41128,0,1.54047e-9,0.412266,0.911063,0,-17.6085,16.3483,-16.8891,1\",\"title\":\"Mandibule PLY\"}'),(2,'0c41fe1b-9044-45fd-8a89-d4cc7dbf39c7','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c41fe1b-9044-45fd-8a89-d4cc7dbf39c7.ply','PLY','PATIENT_a6e96a3a-d3aa-4375-96e4-a7b79957722a_ACT_98d418ab-2b00-4bf4-a897-e36863d7647b_SESS_5625e79f-f6fb-44a0-a4eb-4b41fdee4c6c_TOSC_a6d32f0d-f14e-4a5a-80d6-d56cdac2aaf1_PLY_','2021-02-09 16:08:56','2021-02-09 16:38:59','0c41fe1b-9044-45fd-8a89-d4cc7dbf39c7.ply','2021-02-09 17:08:56','SYNCED','0c41fe1b-9044-45fd-8a89-d4cc7dbf39c7',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.34.1.3\",\"modelMatrix\":\"0.53448,-0.808637,0.245841,0,0.845181,0.51137,-0.155466,0,3.25112e-9,0.290874,0.956761,0,-5.82517,-31.8198,-21.574,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0c442111-2283-4b31-861e-d97d875822e8','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c442111-2283-4b31-861e-d97d875822e8.ply','PLY','PATIENT_2e0a8247-f698-45b5-87fe-8b1e7c952f36_ACT_a433fe53-88db-42f4-8f67-6c6d2488c283_SESS_cfc8f487-d196-4456-8530-e036a0501e0b_TOSC_5771ac38-285d-44d7-b478-eca9dbea9066_PLY_','2020-12-02 10:32:36','2020-10-30 10:56:44','0c442111-2283-4b31-861e-d97d875822e8.ply','2020-12-02 11:32:36','SYNCED','0c442111-2283-4b31-861e-d97d875822e8',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.35.12.1.2\",\"modelMatrix\":\"0.653321,-0.710166,0.262367,0,0.757081,0.612835,-0.226408,0,-1.35337e-8,0.34655,0.938031,0,-8.58895,-23.3184,-19.2505,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0c45f002-a6fa-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c45f002-a6fa-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_8ca476e2-f154-4773-b8ee-bd913f841508_ACT_1a0ba8c5-d07a-459e-ab6b-3b12a8dd9c78_SESS_b98d3f70-5095-426f-882b-b559702fb364_TOSC_4025d533-0f08-4afb-b679-8aa40e41cf88_STL_','2022-02-01 11:47:30','2019-07-15 16:11:50','0c45f002-a6fa-11e9-a33b-226cec7cb58a.stl','2022-02-01 12:47:30','SYNCED','0c45f002-a6fa-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 69.1.1.1\",\"modelMatrix\":\"0.60991,-0.766529,0.201105,0,0.792471,0.589944,-0.154777,0,-4.87518e-9,0.25377,0.967265,0,-2.37103,-28.3661,-22.361,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'0c46d86f-a6fa-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c46d86f-a6fa-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_8ca476e2-f154-4773-b8ee-bd913f841508_ACT_1a0ba8c5-d07a-459e-ab6b-3b12a8dd9c78_SESS_b98d3f70-5095-426f-882b-b559702fb364_BOSC_2d5eef3f-efbe-4452-b985-bd847a341882_PLY_','2022-02-01 11:47:30','2019-07-15 16:18:37','0c46d86f-a6fa-11e9-a33b-226cec7cb58a.ply','2022-02-01 12:47:30','SYNCED','0c46d86f-a6fa-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 69.1.1.1\",\"modelMatrix\":\"0.837957,0.543912,-0.0445969,0,-0.545737,0.835154,-0.0684767,0,-4.06017e-9,0.0817187,0.996655,0,19.8578,-8.37496,-22.8433,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0c477b91-a6fa-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c477b91-a6fa-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_8ca476e2-f154-4773-b8ee-bd913f841508_ACT_1a0ba8c5-d07a-459e-ab6b-3b12a8dd9c78_SESS_b98d3f70-5095-426f-882b-b559702fb364_BOSC_2d5eef3f-efbe-4452-b985-bd847a341882_STL_','2022-02-01 11:47:30','2019-07-15 16:18:37','0c477b91-a6fa-11e9-a33b-226cec7cb58a.stl','2022-02-01 12:47:30','SYNCED','0c477b91-a6fa-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 69.1.1.1\",\"modelMatrix\":\"0.837957,0.543912,-0.0445969,0,-0.545737,0.835154,-0.0684767,0,-4.06017e-9,0.0817187,0.996655,0,19.8578,-8.37496,-22.8433,1\",\"title\":\"MANDIBULE STL\"}'),(2,'0c48725f-a6fa-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c48725f-a6fa-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_8ca476e2-f154-4773-b8ee-bd913f841508_ACT_1a0ba8c5-d07a-459e-ab6b-3b12a8dd9c78_SESS_b98d3f70-5095-426f-882b-b559702fb364_TOSC_4025d533-0f08-4afb-b679-8aa40e41cf88_PLY_','2022-02-01 11:47:31','2019-07-15 16:11:50','0c48725f-a6fa-11e9-a33b-226cec7cb58a.ply','2022-02-01 12:47:31','SYNCED','0c48725f-a6fa-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 69.1.1.1\",\"modelMatrix\":\"0.60991,-0.766529,0.201105,0,0.792471,0.589944,-0.154777,0,-4.87518e-9,0.25377,0.967265,0,-2.37103,-28.3661,-22.361,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0c491e5e-a6fa-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c491e5e-a6fa-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_8ca476e2-f154-4773-b8ee-bd913f841508_ACT_1a0ba8c5-d07a-459e-ab6b-3b12a8dd9c78_SESS_b98d3f70-5095-426f-882b-b559702fb364_TOSC_4025d533-0f08-4afb-b679-8aa40e41cf88_SNAPS_','2022-02-01 11:47:31','2019-07-15 16:11:50','0c491e5e-a6fa-11e9-a33b-226cec7cb58a.png','2022-02-01 12:47:31','SYNCED','0c491e5e-a6fa-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 69.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0c49d34f-a6fa-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c49d34f-a6fa-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_8ca476e2-f154-4773-b8ee-bd913f841508_ACT_1a0ba8c5-d07a-459e-ab6b-3b12a8dd9c78_SESS_b98d3f70-5095-426f-882b-b559702fb364_BOSC_2d5eef3f-efbe-4452-b985-bd847a341882_SNAPS_','2022-02-01 11:47:31','2019-07-15 16:18:37','0c49d34f-a6fa-11e9-a33b-226cec7cb58a.png','2022-02-01 12:47:31','SYNCED','0c49d34f-a6fa-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 69.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0c4bab29-4019-4c6c-9260-7bc2b4bf0fb2','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c4bab29-4019-4c6c-9260-7bc2b4bf0fb2.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_c6940e84-1289-4740-8fe2-41746cad3866_SESS_c542eccb-6b38-4ef0-b74f-9b6c27689b67_TOSC_071b1832-7e18-42b9-964b-ec2131d4a6d4_PLY_','2021-04-26 13:57:12','2021-04-26 15:54:45','0c4bab29-4019-4c6c-9260-7bc2b4bf0fb2.ply','2021-04-26 15:57:12','SYNCED','57873285-f3e9-4d77-bffc-29bce2a3c130',1,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.107.1.3\",\"modelMatrix\":\"-0.125282,-0.943428,0.306999,0,0.992121,-0.119133,0.0387669,0,1.8856e-9,0.309437,0.95092,0,-17.6389,-22.5457,-16.4937,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0c4eb163-f040-48ba-bb07-0caf6d0481c8','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c4eb163-f040-48ba-bb07-0caf6d0481c8.png','SNAPS','PATIENT_ef8d3999-ba32-41ec-a94f-71185b37aab5_ACT_1d33193c-5e2e-4bb2-ac6a-3df2fa6be87f_SESS_3dceee06-b7f5-42ec-8014-95fac522bfcc_BOSC_8a9a0429-1cf3-408a-8b03-aa96f823bd76_SNAPS_','2021-02-26 14:57:16','2021-02-26 15:57:14','0c4eb163-f040-48ba-bb07-0caf6d0481c8.png','2021-02-26 15:57:16','SYNCED','0c4eb163-f040-48ba-bb07-0caf6d0481c8',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.1.1.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0c4f772a-b082-4e4f-84eb-2bcc6b8b9603','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c4f772a-b082-4e4f-84eb-2bcc6b8b9603.ply','PLY','PATIENT_141b1475-3306-4024-b054-f1b3cdb531d5_ACT_90eb1f5e-e440-4982-897f-28a9060bd18e_SESS_bc3acb03-43bd-41b3-afe5-c19d7fc6166a_TOSC_76208100-ccc8-47d3-9e04-c8c937509004_PLY_','2020-12-08 17:27:06','2020-07-02 14:33:19','0c4f772a-b082-4e4f-84eb-2bcc6b8b9603.ply','2020-12-08 18:27:06','SYNCED','0c4f772a-b082-4e4f-84eb-2bcc6b8b9603',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.108.1.1\",\"modelMatrix\":\"0.694767,-0.680635,0.232453,0,0.719235,0.657481,-0.224545,0,1.14311e-8,0.323195,0.946332,0,4.69553,-33.5994,-16.8832,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0c537490-5cc1-4ce3-a5a9-f9dbc5cd4784','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c537490-5cc1-4ce3-a5a9-f9dbc5cd4784.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_3cb05e41-ba49-4185-9208-8ea1be47a6a3_SESS_17bc041f-1826-42b3-a480-fb2f537131d2_BOSC_b4e52648-507c-437b-a38c-7d4b2a798a26_PLY_','2021-07-21 10:06:05','2021-07-21 12:06:03','0c537490-5cc1-4ce3-a5a9-f9dbc5cd4784.ply','2021-07-21 12:06:05','SYNCED','0c537490-5cc1-4ce3-a5a9-f9dbc5cd4784',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.171.1.3\",\"modelMatrix\":\"-0.872639,-0.470998,0.129077,0,0.488365,-0.841608,0.230643,0,2.30919e-9,0.264305,0.964439,0,-24.0046,2.27571,-15.4362,1\",\"title\":\"Mandibule PLY\"}'),(2,'0c53e63e-528c-4250-b5ca-66ef16935f13','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c53e63e-528c-4250-b5ca-66ef16935f13.ply','PLY','PATIENT_2f28ecf2-8a3a-41d4-86bb-cf55c01ad025_ACT_78f6ee3e-94b9-419c-8442-ddf8e957291f_SESS_99544d16-2b44-4c4f-98f5-39f771e05aca_TOSC_ae9c9f76-fe29-4c87-818e-300ac9a5cb92_PLY_','2021-12-30 18:03:23','2019-10-17 14:01:41','0c53e63e-528c-4250-b5ca-66ef16935f13.ply','2021-12-30 19:03:23','SYNCED','0c53e63e-528c-4250-b5ca-66ef16935f13',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 192.1.1.1\",\"modelMatrix\":\"0.649646,-0.741198,0.169073,0,0.760237,0.633376,-0.144478,0,-2.45723e-10,0.222395,0.974957,0,3.93746,-32.6789,-17.2413,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0c5c911e-b03a-11ec-94a4-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c5c911e-b03a-11ec-94a4-9ec33d03e6dd.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_4dc94f28-c98b-4ab5-bc96-814c9b4c87df_SESS_efc3e060-268b-43fe-9ca9-0e4440922bb0_BOSC_4cab63a5-b362-4863-8ce8-01c95b45ddb6_SNAPS_','2022-03-30 14:59:23','2022-03-30 16:59:19','0c5c911e-b03a-11ec-94a4-9ec33d03e6dd.png','2022-03-30 16:59:23','SYNCED','0c5c911e-b03a-11ec-94a4-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.46.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0c5e89e2-b03a-11ec-94a4-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c5e89e2-b03a-11ec-94a4-9ec33d03e6dd.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_4dc94f28-c98b-4ab5-bc96-814c9b4c87df_SESS_efc3e060-268b-43fe-9ca9-0e4440922bb0_BOSC_4cab63a5-b362-4863-8ce8-01c95b45ddb6_ZIP_','2022-03-30 14:59:23','2022-03-30 16:59:20','0c5e89e2-b03a-11ec-94a4-9ec33d03e6dd.zip','2022-03-30 16:59:23','SYNCED','0c5e89e2-b03a-11ec-94a4-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.46.1.3\",\"modelMatrix\":\"-0.886286,-0.423168,0.188216,0,0.463138,-0.809798,0.360181,0,-1.06381e-08,0.406394,0.913698,0,-31.2689,-2.74632,-19.7539,1\",\"title\":\"Mandibule ZIP\"}'),(2,'0c5ff650-b03a-11ec-94a4-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c5ff650-b03a-11ec-94a4-9ec33d03e6dd.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_4dc94f28-c98b-4ab5-bc96-814c9b4c87df_SESS_efc3e060-268b-43fe-9ca9-0e4440922bb0_TOSC_662310d4-0aff-4b83-a206-ea02df08c0df_ZIP_','2022-03-30 14:45:49','2022-03-30 16:45:45','0c5ff650-b03a-11ec-94a4-9ec33d03e6dd.zip','2022-03-30 16:45:49','SYNCED','0c5ff650-b03a-11ec-94a4-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.46.1.3\",\"modelMatrix\":\"0.339983,-0.898091,0.279007,0,0.940431,0.324676,-0.100866,0,-8.86361e-10,0.29668,0.954977,0,-9.19,-36.3761,-15.211,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'0c5fff67-702f-11eb-8b86-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c5fff67-702f-11eb-8b86-226cec7cb58a.png','SNAPS','PATIENT_0ad96cc8-7750-4095-8696-c47826920a6f_ACT_7fed929d-0a89-4ae8-a9e2-fedb6ba7b10d_SESS_63df4f4a-a457-4878-8467-650ee33f0dba_TOSC_ab548984-09fc-40e6-a3dd-498e8f3a8544_SNAPS_','2021-02-16 08:15:06','2021-02-16 09:12:05','0c5fff67-702f-11eb-8b86-226cec7cb58a.png','2021-02-16 09:15:06','SYNCED','0c5fff67-702f-11eb-8b86-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.46.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0c615829-7f5b-4022-a454-b7d407305676','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c615829-7f5b-4022-a454-b7d407305676.png','SNAPS','PATIENT_ecdf47e8-c89a-46f6-90f6-5aa78020d4b4_ACT_085fdf08-d777-4c3e-bf1b-ba3c5d9a1188_SESS_e47de5cc-baee-41be-b434-97cd36e2cf62_TOSC_eab1d47f-40b8-45b2-bcdc-30a8ce009e99_SNAPS_','2020-12-23 09:08:07','2019-12-16 13:52:07','0c615829-7f5b-4022-a454-b7d407305676.png','2020-12-23 10:08:07','SYNCED','0c615829-7f5b-4022-a454-b7d407305676',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0c618361-b03a-11ec-94a4-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c618361-b03a-11ec-94a4-9ec33d03e6dd.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_4dc94f28-c98b-4ab5-bc96-814c9b4c87df_SESS_efc3e060-268b-43fe-9ca9-0e4440922bb0_TOSC_8d639dac-1c1b-42c5-9919-4ff9187a8021_SNAPS_','2022-03-30 14:41:55','2022-03-30 16:41:49','0c618361-b03a-11ec-94a4-9ec33d03e6dd.png','2022-03-30 16:41:55','SYNCED','0c618361-b03a-11ec-94a4-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.46.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0c62e412-b03a-11ec-94a4-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c62e412-b03a-11ec-94a4-9ec33d03e6dd.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_4dc94f28-c98b-4ab5-bc96-814c9b4c87df_SESS_efc3e060-268b-43fe-9ca9-0e4440922bb0_TOSC_9e5f36e0-6f9a-4929-a75a-1774f7fe5e31_SNAPS_','2022-03-30 14:29:20','2022-03-30 16:29:15','0c62e412-b03a-11ec-94a4-9ec33d03e6dd.png','2022-03-30 16:29:20','SYNCED','0c62e412-b03a-11ec-94a4-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.46.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0c644ea3-b03a-11ec-94a4-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c644ea3-b03a-11ec-94a4-9ec33d03e6dd.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_4dc94f28-c98b-4ab5-bc96-814c9b4c87df_SESS_efc3e060-268b-43fe-9ca9-0e4440922bb0_BOSC_ef9d90a4-734d-45ab-acc4-1c9e7ac940e0_SNAPS_','2022-03-30 14:52:04','2022-03-30 16:51:59','0c644ea3-b03a-11ec-94a4-9ec33d03e6dd.png','2022-03-30 16:52:04','SYNCED','0c644ea3-b03a-11ec-94a4-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.46.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0c65a847-b03a-11ec-94a4-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c65a847-b03a-11ec-94a4-9ec33d03e6dd.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_4dc94f28-c98b-4ab5-bc96-814c9b4c87df_SESS_efc3e060-268b-43fe-9ca9-0e4440922bb0_BOSC_ef9d90a4-734d-45ab-acc4-1c9e7ac940e0_ZIP_','2022-03-30 14:52:03','2022-03-30 16:52:00','0c65a847-b03a-11ec-94a4-9ec33d03e6dd.zip','2022-03-30 16:52:03','SYNCED','0c65a847-b03a-11ec-94a4-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.46.1.1\",\"modelMatrix\":\"-0.916111,-0.387312,0.103583,0,0.400924,-0.885008,0.236688,0,-1.29116e-09,0.258361,0.966048,0,-20.9585,0.785545,-26.2346,1\",\"title\":\"Mandibule ZIP\"}'),(2,'0c65ec23-702f-11eb-8b86-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c65ec23-702f-11eb-8b86-226cec7cb58a.ply','PLY','PATIENT_0ad96cc8-7750-4095-8696-c47826920a6f_ACT_7fed929d-0a89-4ae8-a9e2-fedb6ba7b10d_SESS_63df4f4a-a457-4878-8467-650ee33f0dba_BOSC_282fc6fb-0c99-4971-a33c-be21cdb798d5_PLY_','2021-02-16 08:15:05','2021-02-16 09:14:42','0c65ec23-702f-11eb-8b86-226cec7cb58a.ply','2021-02-16 09:15:05','SYNCED','0c65ec23-702f-11eb-8b86-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.46.1.1\",\"modelMatrix\":\"-0.881444,-0.446555,0.153771,0,0.472289,-0.833416,0.286986,0,-3.30525e-10,0.325586,0.945512,0,-17.1339,4.89531,-14.8223,1\",\"title\":\"Mandibule PLY\"}'),(2,'0c66ef7b-b03a-11ec-94a4-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c66ef7b-b03a-11ec-94a4-9ec33d03e6dd.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_4dc94f28-c98b-4ab5-bc96-814c9b4c87df_SESS_efc3e060-268b-43fe-9ca9-0e4440922bb0_TOSC_662310d4-0aff-4b83-a206-ea02df08c0df_SNAPS_','2022-03-30 14:45:49','2022-03-30 16:45:45','0c66ef7b-b03a-11ec-94a4-9ec33d03e6dd.png','2022-03-30 16:45:49','SYNCED','0c66ef7b-b03a-11ec-94a4-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.46.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0c670a03-27c7-4e38-aa20-0fcb40fa9524','','PLY','PATIENT_4a57245d-6e77-4964-b7d8-90b076a0cc2f_ACT_228bda14-5f97-4178-bc44-1b2b2c2cf538_SESS_eca8e6f4-1035-4461-8a8b-013cf52db9f8_TOSC_d4f6a6da-6e8d-46d8-9489-c66e79239a58_PLY_','2020-12-02 10:32:37','2020-11-12 11:35:43','','2020-12-02 11:32:37','SYNCED','0c670a03-27c7-4e38-aa20-0fcb40fa9524',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.49.1.1.1\",\"modelMatrix\":\"0.73508,-0.633349,0.241924,0,0.677981,0.686689,-0.262298,0,2.8094e-10,0.35683,0.934169,0,7.07135,-35.5038,-17.2669,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0c683204-b03a-11ec-94a4-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c683204-b03a-11ec-94a4-9ec33d03e6dd.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_4dc94f28-c98b-4ab5-bc96-814c9b4c87df_SESS_efc3e060-268b-43fe-9ca9-0e4440922bb0_BOSC_96806395-3801-490b-bc87-4aeb6a5eae93_SNAPS_','2022-03-30 14:59:20','2022-03-30 16:55:58','0c683204-b03a-11ec-94a4-9ec33d03e6dd.png','2022-03-30 16:59:20','SYNCED','0c683204-b03a-11ec-94a4-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.46.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0c69b76b-b03a-11ec-94a4-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c69b76b-b03a-11ec-94a4-9ec33d03e6dd.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_4dc94f28-c98b-4ab5-bc96-814c9b4c87df_SESS_efc3e060-268b-43fe-9ca9-0e4440922bb0_BOSC_96806395-3801-490b-bc87-4aeb6a5eae93_ZIP_','2022-03-30 14:56:02','2022-03-30 16:55:58','0c69b76b-b03a-11ec-94a4-9ec33d03e6dd.zip','2022-03-30 16:56:02','SYNCED','0c69b76b-b03a-11ec-94a4-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.46.1.2\",\"modelMatrix\":\"0.445942,-0.892972,0.0611188,0,0.895062,0.444901,-0.0304509,0,-8.53346e-10,0.0682844,0.997666,0,-7.38143,-21.2461,-23.2667,1\",\"title\":\"Mandibule ZIP\"}'),(2,'0c6b26ed-b03a-11ec-94a4-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c6b26ed-b03a-11ec-94a4-9ec33d03e6dd.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_4dc94f28-c98b-4ab5-bc96-814c9b4c87df_SESS_efc3e060-268b-43fe-9ca9-0e4440922bb0_TOSC_8d639dac-1c1b-42c5-9919-4ff9187a8021_ZIP_','2022-03-30 14:41:55','2022-03-30 16:41:50','0c6b26ed-b03a-11ec-94a4-9ec33d03e6dd.zip','2022-03-30 16:41:55','SYNCED','0c6b26ed-b03a-11ec-94a4-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.46.1.2\",\"modelMatrix\":\"0.776908,-0.558799,0.290099,0,0.629614,0.689526,-0.357966,0,-3.29387e-09,0.460757,0.887526,0,9.25061,-34.1588,-16.1988,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'0c6c6102-702f-11eb-8b86-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c6c6102-702f-11eb-8b86-226cec7cb58a.ply','PLY','PATIENT_0ad96cc8-7750-4095-8696-c47826920a6f_ACT_7fed929d-0a89-4ae8-a9e2-fedb6ba7b10d_SESS_63df4f4a-a457-4878-8467-650ee33f0dba_TOSC_ab548984-09fc-40e6-a3dd-498e8f3a8544_PLY_','2021-02-16 08:15:05','2021-02-16 09:12:05','0c6c6102-702f-11eb-8b86-226cec7cb58a.ply','2021-02-16 09:15:05','SYNCED','0c6c6102-702f-11eb-8b86-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.46.1.1\",\"modelMatrix\":\"0.0420028,-0.948264,0.314691,0,0.999117,0.0398649,-0.0132296,0,4.55421e-10,0.314969,0.949102,0,-19.6835,-30.8454,-10.4223,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0c6cca35-4bff-472d-ab8e-9b5c330976ff','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c6cca35-4bff-472d-ab8e-9b5c330976ff.png','SNAPS','PATIENT_996965ea-3a75-428c-b1aa-94b2684471af_ACT_70b0e208-05f7-4132-90c0-2e144bdfb654_SESS_d3f26179-3e3d-4ae8-bb48-e1553ae0b81a_BOSC_bd963764-d088-40d2-a67a-3371277753a7_SNAPS_','2021-03-04 15:46:14','2021-03-04 16:10:51','0c6cca35-4bff-472d-ab8e-9b5c330976ff.png','2021-03-04 16:46:14','SYNCED','0c6cca35-4bff-472d-ab8e-9b5c330976ff',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.68.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0c6d820b-b03a-11ec-94a4-9ec33d03e6dd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c6d820b-b03a-11ec-94a4-9ec33d03e6dd.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_4dc94f28-c98b-4ab5-bc96-814c9b4c87df_SESS_efc3e060-268b-43fe-9ca9-0e4440922bb0_TOSC_9e5f36e0-6f9a-4929-a75a-1774f7fe5e31_ZIP_','2022-03-30 14:29:20','2022-03-30 16:29:16','0c6d820b-b03a-11ec-94a4-9ec33d03e6dd.zip','2022-03-30 16:29:20','SYNCED','0c6d820b-b03a-11ec-94a4-9ec33d03e6dd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.46.1.1\",\"modelMatrix\":\"0.224942,-0.956337,0.186601,0,0.974372,0.220778,-0.0430783,0,-1.75949e-09,0.191509,0.981491,0,-13.3759,-31.4649,-12.0747,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'0c7510f5-702f-11eb-8b86-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c7510f5-702f-11eb-8b86-226cec7cb58a.png','SNAPS','PATIENT_0ad96cc8-7750-4095-8696-c47826920a6f_ACT_7fed929d-0a89-4ae8-a9e2-fedb6ba7b10d_SESS_63df4f4a-a457-4878-8467-650ee33f0dba_BOSC_282fc6fb-0c99-4971-a33c-be21cdb798d5_SNAPS_','2021-02-16 08:15:05','2021-02-16 09:14:42','0c7510f5-702f-11eb-8b86-226cec7cb58a.png','2021-02-16 09:15:05','SYNCED','0c7510f5-702f-11eb-8b86-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.46.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0c77a091-25e9-49fe-ad96-2d1913a47629','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c77a091-25e9-49fe-ad96-2d1913a47629.stl','STL','PATIENT_de132740-d90a-46fb-9843-ca1070f94f10_ACT_64ad6d77-7b96-44e1-932d-0031115fd156_SESS_bb5725cd-9c7f-452c-a8b4-0cb1c79cef27_TOSC_c93ccf4d-eb64-44f1-b9fa-036840d78ee2_STL_','2022-03-04 13:40:23','2019-07-08 16:19:23','0c77a091-25e9-49fe-ad96-2d1913a47629.stl','2022-03-04 14:40:23','SYNCED','0c77a091-25e9-49fe-ad96-2d1913a47629',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 5.2.1.1\",\"modelMatrix\":\"0.773297,0.595388,-0.218002,0,-0.634044,0.726151,-0.265881,0,-6.56596e-9,0.343828,0.939033,0,-5.15819,-34.3656,-18.2744,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'0c785e03-4f7b-4c25-abdc-f0eb3d58ccdf','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c785e03-4f7b-4c25-abdc-f0eb3d58ccdf.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_598aca15-caa7-4096-bc8d-887a75e7f68f_SESS_9aceab97-46c5-417c-b309-f2697df16b91_TOSC_d93ca7e9-a7ef-4c41-b106-c15559c43586_SNAPS_','2021-04-27 07:36:18','2021-04-27 09:36:17','0c785e03-4f7b-4c25-abdc-f0eb3d58ccdf.png','2021-04-27 09:36:18','SYNCED','0c785e03-4f7b-4c25-abdc-f0eb3d58ccdf',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.110.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0c79da95-d0a5-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c79da95-d0a5-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_3ba502e6-1fd1-40ed-8e72-2db58e8c52bb_ACT_966148a1-3982-4810-9164-4734147c332f_SESS_cfa79f32-7f59-4afc-9ca7-9b439e2ad4c9_TOSC_1d6778b1-fec6-4bde-9f38-bf8fcf9879d8_SNAPS_','2020-12-07 12:01:26','2020-07-28 09:36:14','0c79da95-d0a5-11ea-947d-226cec7cb58a.png','2020-12-07 13:01:26','SYNCED','0c79da95-d0a5-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.24.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0c7ba467-6cc1-494e-9d53-f8858a18f83c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c7ba467-6cc1-494e-9d53-f8858a18f83c.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_686a01b2-789e-419f-8f7f-d1582e9cb9ff_SESS_f377f5d8-4680-4da3-aa7d-c1dc2f577d0d_BOSC_b27e1f2d-723b-4751-83ac-ce0f54bdcc86_PLY_','2021-04-30 08:31:59','2021-04-30 10:31:57','0c7ba467-6cc1-494e-9d53-f8858a18f83c.ply','2021-04-30 10:31:59','SYNCED','0c7ba467-6cc1-494e-9d53-f8858a18f83c',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.131.1.3\",\"modelMatrix\":\"-0.729108,-0.66292,0.170112,0,0.684399,-0.706227,0.181225,0,-1.35779e-8,0.248558,0.968617,0,-26.022,-1.83061,-25.0498,1\",\"title\":\"Mandibule PLY\"}'),(2,'0c7be6e0-e262-44c5-b7d6-4410b48db7f7','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c7be6e0-e262-44c5-b7d6-4410b48db7f7.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_c1ea63a0-3b74-4cad-b2ed-89a623512570_SESS_95093fcc-c6a9-4c7b-bdef-f89b356f3bf8_BOSC_8c7005c5-c216-4e62-b9e8-9f4fc0cf12d1_SNAPS_','2021-04-13 11:51:12','2021-04-13 13:51:11','0c7be6e0-e262-44c5-b7d6-4410b48db7f7.png','2021-04-13 13:51:12','SYNCED','0c7be6e0-e262-44c5-b7d6-4410b48db7f7',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.53.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0c7beab5-d0a5-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c7beab5-d0a5-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_3ba502e6-1fd1-40ed-8e72-2db58e8c52bb_ACT_966148a1-3982-4810-9164-4734147c332f_SESS_cfa79f32-7f59-4afc-9ca7-9b439e2ad4c9_TOSC_1d6778b1-fec6-4bde-9f38-bf8fcf9879d8_PLY_','2020-12-07 12:01:26','2020-07-28 09:36:14','0c7beab5-d0a5-11ea-947d-226cec7cb58a.ply','2020-12-07 13:01:26','SYNCED','0c7beab5-d0a5-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.24.1.2\",\"modelMatrix\":\"0.50542,-0.818329,0.273657,0,0.862874,0.479328,-0.160292,0,-1.02951e-8,0.317146,0.948377,0,-8.7821,-22.6551,-20.0896,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0c7bf196-452a-49fb-89bb-0ebdfe33bd53','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c7bf196-452a-49fb-89bb-0ebdfe33bd53.png','SNAPS','PATIENT_f366662e-4444-4f1a-a132-37b6d8ecc850_ACT_35cae365-54c2-448f-a188-26c90d41bb9d_SESS_9b59de13-1b53-468a-9aab-438a223015c1_BOSC_3febb610-b690-430f-85e8-01026217f82a_SNAPS_','2022-02-01 11:47:31','2019-10-02 11:58:56','0c7bf196-452a-49fb-89bb-0ebdfe33bd53.png','2022-02-01 12:47:31','SYNCED','0c7bf196-452a-49fb-89bb-0ebdfe33bd53',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 173.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0c7c472b-541f-4f41-b1bc-99c00a263d5f','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c7c472b-541f-4f41-b1bc-99c00a263d5f.zip','ZIP','PATIENT_5a36b509-d87e-4dda-807e-a616406aaa4c_ACT_285e7e26-b813-4dd7-84e7-f265f6e87fd6_SESS_7bf03134-a6b7-430c-ad8b-e85f04d49949_TOSC_4552ecaf-bc22-4b93-8b59-7dfaeaca84f8_ZIP_','2022-03-22 10:58:57','2022-03-22 11:58:54','0c7c472b-541f-4f41-b1bc-99c00a263d5f.zip','2022-03-22 11:58:57','SYNCED','0c7c472b-541f-4f41-b1bc-99c00a263d5f',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.412.1.1.21\",\"modelMatrix\":\"0.787882,-0.545076,0.286591,0,0.615826,0.697365,-0.366661,0,4.00746e-09,0.465376,0.885113,0,11.9874,-29.944,-19.4062,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'0c7d52f7-c2a2-4649-b100-d89ea67d13d9','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c7d52f7-c2a2-4649-b100-d89ea67d13d9.ply','PLY','PATIENT_e7a45a68-ba38-4e97-bfd2-34fd3e8d0d4a_ACT_ebf70c6b-8993-444f-b73a-7b93ad4320dc_SESS_d591e9f4-fee5-48a1-bf3f-02ffa1a384cc_TOSC_201fd16e-db34-4267-a853-bdfdf68f9fa4_PLY_','2022-03-04 13:40:23','2019-07-10 17:50:52','0c7d52f7-c2a2-4649-b100-d89ea67d13d9.ply','2022-03-04 14:40:23','SYNCED','0c7d52f7-c2a2-4649-b100-d89ea67d13d9',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 35.1.1.1\",\"modelMatrix\":\"0.536438,-0.798106,0.274337,0,0.843939,0.507305,-0.174378,0,-6.00634e-9,0.325067,0.945691,0,-0.0281093,-41.6067,-18.5317,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0c84ebf8-f6e6-4b12-ae0f-288e45160496','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c84ebf8-f6e6-4b12-ae0f-288e45160496.png','SNAPS','PATIENT_4ed0364e-d067-4452-8839-8e909c61b1ea_ACT_439d6b4b-8f66-4316-a9b9-00cd70637694_SESS_14bc0526-ec82-440b-a6a4-b544d274a55b_TOSC_c880d341-0837-4d73-9aaa-da9b4f978b1d_SNAPS_','2020-12-08 17:27:07','2020-06-08 10:18:25','0c84ebf8-f6e6-4b12-ae0f-288e45160496.png','2020-12-08 18:27:07','SYNCED','0c84ebf8-f6e6-4b12-ae0f-288e45160496',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.29.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0c90361c-ce3c-4981-9f82-c132f2a29b99','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0c90361c-ce3c-4981-9f82-c132f2a29b99.png','SNAPS','PATIENT_4a57245d-6e77-4964-b7d8-90b076a0cc2f_ACT_228bda14-5f97-4178-bc44-1b2b2c2cf538_SESS_eca8e6f4-1035-4461-8a8b-013cf52db9f8_TOSC_a1898e5b-5544-4b73-9b66-0fd1c25101e5_SNAPS_','2020-12-02 10:32:38','2020-11-12 14:01:14','0c90361c-ce3c-4981-9f82-c132f2a29b99.png','2020-12-02 11:32:38','SYNCED','0c90361c-ce3c-4981-9f82-c132f2a29b99',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.36.14.1.4\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0ca7ddab-1e67-4f0d-a913-1a71468e9ed7','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0ca7ddab-1e67-4f0d-a913-1a71468e9ed7.png','SNAPS','PATIENT_3ac6da53-88c5-4d65-a37f-cd3cf5633739_ACT_da9e0457-4df9-4f0a-bb9c-aad3c411f3d3_SESS_0c5f0696-5850-4695-ad77-7936edc4a982_BOSC_08b7386d-d6f1-4021-96a3-1c198ac2f997_SNAPS_','2021-03-26 14:13:33','2021-03-26 15:09:10','0ca7ddab-1e67-4f0d-a913-1a71468e9ed7.png','2021-03-26 15:13:33','SYNCED','0ca7ddab-1e67-4f0d-a913-1a71468e9ed7',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.5.1.4\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0ca8850d-5c90-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0ca8850d-5c90-11eb-94ee-226cec7cb58a.png','SNAPS','PATIENT_72b315b2-aa50-4850-ba10-6553f6ea4ff1_ACT_ae5f4ba0-b39f-4474-ba5c-35072e2b2e69_SESS_984d3625-f60e-46cc-a1bc-b41b3dd6a003_BOSC_923877cf-e92d-48fa-a352-53a301e1b21a_SNAPS_','2021-01-22 08:47:52','2021-01-22 09:37:57','0ca8850d-5c90-11eb-94ee-226cec7cb58a.png','2021-01-22 09:47:52','SYNCED','0ca8850d-5c90-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.15.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0ca89e91-1e87-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0ca89e91-1e87-11eb-94ee-226cec7cb58a.png','SNAPS','PATIENT_90de7ec0-5b83-4267-8f0d-91a8e0414ec2_ACT_1d9026f1-8f91-44a7-a01f-afc4d42f5617_SESS_b2157cc1-e306-4916-925a-5ba0ccd25b29_TOSC_a87fc691-6679-416d-a098-24fa225144c4_SNAPS_','2020-12-02 10:32:38','2020-11-04 10:51:10','0ca89e91-1e87-11eb-94ee-226cec7cb58a.png','2020-12-02 11:32:38','SYNCED','0ca89e91-1e87-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.36.5.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0cab5f08-5c90-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cab5f08-5c90-11eb-94ee-226cec7cb58a.png','SNAPS','PATIENT_72b315b2-aa50-4850-ba10-6553f6ea4ff1_ACT_ae5f4ba0-b39f-4474-ba5c-35072e2b2e69_SESS_984d3625-f60e-46cc-a1bc-b41b3dd6a003_BOSC_803e07b1-e5db-4775-894a-717009f3b51a_SNAPS_','2021-01-22 08:47:52','2021-01-22 09:42:08','0cab5f08-5c90-11eb-94ee-226cec7cb58a.png','2021-01-22 09:47:52','SYNCED','0cab5f08-5c90-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.15.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0caca546-1e87-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0caca546-1e87-11eb-94ee-226cec7cb58a.ply','PLY','PATIENT_90de7ec0-5b83-4267-8f0d-91a8e0414ec2_ACT_1d9026f1-8f91-44a7-a01f-afc4d42f5617_SESS_b2157cc1-e306-4916-925a-5ba0ccd25b29_BOSC_00e6578c-9e29-451e-a0f4-da01ad96d963_PLY_','2020-12-02 10:32:38','2020-11-04 11:11:31','0caca546-1e87-11eb-94ee-226cec7cb58a.ply','2020-12-02 11:32:38','SYNCED','0caca546-1e87-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.5.1.1\",\"modelMatrix\":\"-0.999964,0.00826623,-0.00194727,0,-0.00849249,-0.973322,0.229284,0,4.33437e-11,0.229293,0.973358,0,-13.5215,12.8936,-22.8712,1\",\"title\":\"Mandibule PLY\"}'),(2,'0cacef34-5c90-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cacef34-5c90-11eb-94ee-226cec7cb58a.ply','PLY','PATIENT_72b315b2-aa50-4850-ba10-6553f6ea4ff1_ACT_ae5f4ba0-b39f-4474-ba5c-35072e2b2e69_SESS_984d3625-f60e-46cc-a1bc-b41b3dd6a003_TOSC_0df570d4-74db-41e3-9168-5fc1e6f8bdb3_PLY_','2021-01-22 08:47:52','2021-01-22 09:28:12','0cacef34-5c90-11eb-94ee-226cec7cb58a.ply','2021-01-22 09:47:52','SYNCED','0cacef34-5c90-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.15.1.3\",\"modelMatrix\":\"0.505467,-0.809104,0.299754,0,0.862846,0.473985,-0.1756,0,-4.56884e-9,0.347402,0.937716,0,-5.88463,-31.4689,-15.2536,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0cad672c-f06a-4267-a5aa-d191f38c206b','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cad672c-f06a-4267-a5aa-d191f38c206b.png','SNAPS','PATIENT_5b3365d0-2ad4-4d78-9c7c-89ff37d5905d_ACT_ee6f943a-7cab-46d0-b223-fd379650024c_SESS_9f9fe29b-f6ed-4a4c-b9f0-7e6258af0943_BOSC_e1ca57b2-a512-4669-8d69-99efdb61fc57_SNAPS_','2020-12-08 17:27:08','2020-06-19 09:54:17','0cad672c-f06a-4267-a5aa-d191f38c206b.png','2020-12-08 18:27:08','SYNCED','0cad672c-f06a-4267-a5aa-d191f38c206b',0,NULL,'','','{\"displayTitle\":\"Mandibule 32.2.1.1.6\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0cada961-2a3b-4020-be61-1a0ce935591d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cada961-2a3b-4020-be61-1a0ce935591d.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_c31e0d58-bcff-41fc-9bac-036702d876fa_SESS_ca1389b2-27d7-4094-80bb-0b64fa55902e_TOSC_c9417702-4e6b-4e91-ae10-1ead05517903_PLY_','2021-03-26 10:27:54','2021-03-26 11:27:53','0cada961-2a3b-4020-be61-1a0ce935591d.ply','2021-03-26 11:27:54','SYNCED','0cada961-2a3b-4020-be61-1a0ce935591d',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.1.1.3\",\"modelMatrix\":\"0.926758,-0.313442,0.207061,0,0.37566,0.773266,-0.510823,0,-1.41713e-9,0.551193,0.834378,0,14.3109,-38.6052,-16.024,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0cadd5d0-1e87-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cadd5d0-1e87-11eb-94ee-226cec7cb58a.ply','PLY','PATIENT_90de7ec0-5b83-4267-8f0d-91a8e0414ec2_ACT_1d9026f1-8f91-44a7-a01f-afc4d42f5617_SESS_b2157cc1-e306-4916-925a-5ba0ccd25b29_TOSC_a87fc691-6679-416d-a098-24fa225144c4_PLY_','2020-12-02 10:32:39','2020-11-04 10:51:10','0cadd5d0-1e87-11eb-94ee-226cec7cb58a.ply','2020-12-02 11:32:39','SYNCED','0cadd5d0-1e87-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.36.5.1.1\",\"modelMatrix\":\"0.578741,-0.789161,0.205631,0,0.815512,0.560041,-0.145929,0,-7.9195e-9,0.25215,0.967688,0,1.03034,-35.4063,-14.5258,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0cae04bf-5c90-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cae04bf-5c90-11eb-94ee-226cec7cb58a.ply','PLY','PATIENT_72b315b2-aa50-4850-ba10-6553f6ea4ff1_ACT_ae5f4ba0-b39f-4474-ba5c-35072e2b2e69_SESS_984d3625-f60e-46cc-a1bc-b41b3dd6a003_BOSC_803e07b1-e5db-4775-894a-717009f3b51a_PLY_','2021-01-22 08:47:52','2021-01-22 09:42:08','0cae04bf-5c90-11eb-94ee-226cec7cb58a.ply','2021-01-22 09:47:52','SYNCED','0cae04bf-5c90-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.15.1.2\",\"modelMatrix\":\"-0.996673,-0.0806679,0.0116503,0,0.0815048,-0.986438,0.142464,0,-1.26437e-10,0.14294,0.989731,0,-18.5322,16.6757,-20.8876,1\",\"title\":\"Mandibule PLY\"}'),(2,'0cae20c7-35a7-4417-82f8-b7a969d1c7ef','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cae20c7-35a7-4417-82f8-b7a969d1c7ef.ply','PLY','PATIENT_9c424d0a-91b9-4df7-b470-de67439e396c_ACT_27b123e3-580b-4c73-a18e-db6c5799c87b_SESS_ad1b540b-47c5-4f1b-8964-4de0d1b0ca5a_TOSC_b7074bf1-198e-4486-a5d5-8bf6061c83e3_PLY_','2021-01-11 13:52:42','2021-01-11 14:11:31','0cae20c7-35a7-4417-82f8-b7a969d1c7ef.ply','2021-01-11 14:52:42','SYNCED','0cae20c7-35a7-4417-82f8-b7a969d1c7ef',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.36.73.1.1\",\"modelMatrix\":\"0.18242,-0.949701,0.254541,0,0.983221,0.176201,-0.0472258,0,1.28774e-9,0.258884,0.965908,0,-11.6622,-34.2979,-15.3767,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0caeb8a8-1e87-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0caeb8a8-1e87-11eb-94ee-226cec7cb58a.png','SNAPS','PATIENT_90de7ec0-5b83-4267-8f0d-91a8e0414ec2_ACT_1d9026f1-8f91-44a7-a01f-afc4d42f5617_SESS_b2157cc1-e306-4916-925a-5ba0ccd25b29_BOSC_00e6578c-9e29-451e-a0f4-da01ad96d963_SNAPS_','2020-12-02 10:32:39','2020-11-04 11:11:31','0caeb8a8-1e87-11eb-94ee-226cec7cb58a.png','2020-12-02 11:32:39','SYNCED','0caeb8a8-1e87-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.36.5.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0caf6d44-5c90-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0caf6d44-5c90-11eb-94ee-226cec7cb58a.ply','PLY','PATIENT_72b315b2-aa50-4850-ba10-6553f6ea4ff1_ACT_ae5f4ba0-b39f-4474-ba5c-35072e2b2e69_SESS_984d3625-f60e-46cc-a1bc-b41b3dd6a003_BOSC_9e3ca523-7268-4a39-8eea-f5a90525de7a_PLY_','2021-01-22 08:47:51','2021-01-22 09:45:15','0caf6d44-5c90-11eb-94ee-226cec7cb58a.ply','2021-01-22 09:47:51','SYNCED','0caf6d44-5c90-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.15.1.3\",\"modelMatrix\":\"-0.853128,0.516415,-0.0740908,0,-0.521703,-0.84448,0.121159,0,3.78947e-9,0.142017,0.989864,0,-6.70249,19.241,-23.534,1\",\"title\":\"Mandibule PLY\"}'),(2,'0cb0199e-ac79-40a3-b817-44757893bfe2','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cb0199e-ac79-40a3-b817-44757893bfe2.stl','STL','PATIENT_e54147b7-fada-4c55-bff0-b2e1d5220517_ACT_2195a047-9f4e-4d6a-91a6-76e7d65445d7_SESS_c0d7afbe-1996-4b7b-a52f-1a475877cc5f_BOSC_0eb647a5-f323-4df2-a962-e0baa4732bd7_STL_','2021-01-06 11:02:56','2019-12-12 15:06:02','0cb0199e-ac79-40a3-b817-44757893bfe2.stl','2021-01-06 12:02:56','SYNCED','0cb0199e-ac79-40a3-b817-44757893bfe2',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 232.16.1.1\",\"modelMatrix\":\"-0.998738,-0.0486526,0.0124307,0,0.0502155,-0.967653,0.247235,0,3.26126e-10,0.247547,0.968876,0,-11.8928,12.3194,-21.409,1\",\"title\":\"MANDIBULE STL\"}'),(2,'0cb03e33-4681-4d07-9c9c-5f6f59eb7e80','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cb03e33-4681-4d07-9c9c-5f6f59eb7e80.ply','PLY','PATIENT_4ddddcc8-b2a0-446f-933f-caa8be0ea01f_ACT_0d77e86e-ff82-4aeb-baf6-8263e4f9c8d4_SESS_8e2af3be-39ab-4c2e-8dd5-7a8294818783_BOSC_2cc88ae5-0c77-4f32-9fb0-1f9669803234_PLY_','2020-12-16 10:52:34','2020-05-20 11:22:04','0cb03e33-4681-4d07-9c9c-5f6f59eb7e80.ply','2020-12-16 11:52:34','SYNCED','0cb03e33-4681-4d07-9c9c-5f6f59eb7e80',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 216.1.1.1.1\",\"modelMatrix\":\"0.828724,0.55577,-0.0658566,0,-0.559658,0.822966,-0.0975183,0,6.2995e-9,0.117673,0.993052,0,20.6538,-7.21197,-17.6945,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0cb0c2b8-5c90-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cb0c2b8-5c90-11eb-94ee-226cec7cb58a.ply','PLY','PATIENT_72b315b2-aa50-4850-ba10-6553f6ea4ff1_ACT_ae5f4ba0-b39f-4474-ba5c-35072e2b2e69_SESS_984d3625-f60e-46cc-a1bc-b41b3dd6a003_BOSC_923877cf-e92d-48fa-a352-53a301e1b21a_PLY_','2021-01-22 08:47:52','2021-01-22 09:37:57','0cb0c2b8-5c90-11eb-94ee-226cec7cb58a.ply','2021-01-22 09:47:52','SYNCED','0cb0c2b8-5c90-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.15.1.1\",\"modelMatrix\":\"-0.916349,0.399087,-0.0321751,0,-0.400382,-0.913385,0.0736387,0,1.21829e-10,0.080361,0.996766,0,-9.99589,12.7231,-25.2041,1\",\"title\":\"Mandibule PLY\"}'),(2,'0cb20ece-5c90-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cb20ece-5c90-11eb-94ee-226cec7cb58a.png','SNAPS','PATIENT_72b315b2-aa50-4850-ba10-6553f6ea4ff1_ACT_ae5f4ba0-b39f-4474-ba5c-35072e2b2e69_SESS_984d3625-f60e-46cc-a1bc-b41b3dd6a003_BOSC_9e3ca523-7268-4a39-8eea-f5a90525de7a_SNAPS_','2021-01-22 08:47:51','2021-01-22 09:45:15','0cb20ece-5c90-11eb-94ee-226cec7cb58a.png','2021-01-22 09:47:51','SYNCED','0cb20ece-5c90-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.15.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0cb375bd-5c90-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cb375bd-5c90-11eb-94ee-226cec7cb58a.png','SNAPS','PATIENT_72b315b2-aa50-4850-ba10-6553f6ea4ff1_ACT_ae5f4ba0-b39f-4474-ba5c-35072e2b2e69_SESS_984d3625-f60e-46cc-a1bc-b41b3dd6a003_TOSC_1c5a60b5-27b9-4ad1-b8e2-1eb5f55d3caf_SNAPS_','2021-01-22 08:47:51','2021-01-22 09:21:58','0cb375bd-5c90-11eb-94ee-226cec7cb58a.png','2021-01-22 09:47:51','SYNCED','0cb375bd-5c90-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.15.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0cb4b627-5c90-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cb4b627-5c90-11eb-94ee-226cec7cb58a.ply','PLY','PATIENT_72b315b2-aa50-4850-ba10-6553f6ea4ff1_ACT_ae5f4ba0-b39f-4474-ba5c-35072e2b2e69_SESS_984d3625-f60e-46cc-a1bc-b41b3dd6a003_TOSC_24586f9a-85db-4d53-99d3-25a36baec099_PLY_','2021-01-22 08:47:51','2021-01-22 09:25:03','0cb4b627-5c90-11eb-94ee-226cec7cb58a.ply','2021-01-22 09:47:51','SYNCED','0cb4b627-5c90-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.15.1.2\",\"modelMatrix\":\"0.528088,-0.78085,0.33376,0,0.84919,0.48559,-0.207556,0,2.36767e-9,0.393033,0.919524,0,-1.79876,-30.6272,-26.3973,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0cb50dce-9b2f-4f2e-997e-616c47c7a05f','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cb50dce-9b2f-4f2e-997e-616c47c7a05f.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_d62da735-3cc1-4b05-b947-212a56506d14_SESS_cf9111fc-ad09-4292-92c8-97bd12dd863c_TOSC_596abc39-c9bf-4caa-baa5-eab64e7f8aab_ZIP_','2022-01-05 15:11:50','2022-01-05 16:11:48','0cb50dce-9b2f-4f2e-997e-616c47c7a05f.zip','2022-01-05 16:11:50','SYNCED','0cb50dce-9b2f-4f2e-997e-616c47c7a05f',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.7.1.2\",\"modelMatrix\":\"0.767197,-0.567977,0.298011,0,0.641411,0.679362,-0.356453,0,-1.04413e-8,0.464617,0.885512,0,9.62448,-32.4448,-17.2151,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'0cb72b04-5c90-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cb72b04-5c90-11eb-94ee-226cec7cb58a.ply','PLY','PATIENT_72b315b2-aa50-4850-ba10-6553f6ea4ff1_ACT_ae5f4ba0-b39f-4474-ba5c-35072e2b2e69_SESS_984d3625-f60e-46cc-a1bc-b41b3dd6a003_TOSC_1c5a60b5-27b9-4ad1-b8e2-1eb5f55d3caf_PLY_','2021-01-22 08:47:51','2021-01-22 09:21:58','0cb72b04-5c90-11eb-94ee-226cec7cb58a.ply','2021-01-22 09:47:51','SYNCED','0cb72b04-5c90-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.15.1.1\",\"modelMatrix\":\"0.819673,-0.52232,0.2352,0,0.572832,0.747394,-0.33655,0,1.33812e-8,0.410591,0.91182,0,11.4991,-31.5612,-22.1219,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0cb80604-d416-4b7d-9f65-37f78767efe2','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cb80604-d416-4b7d-9f65-37f78767efe2.ply','PLY','PATIENT_1d58b7eb-aabb-49b7-af4b-a7640ab8b773_ACT_8f055129-8594-4c8a-bc12-219d87d22a06_SESS_3628e936-617f-4318-b5dd-1208227360d9_TOSC_69fdc649-1f71-43fb-991b-b1d026a1328e_PLY_','2020-12-07 12:01:27','2020-08-21 11:02:59','0cb80604-d416-4b7d-9f65-37f78767efe2.ply','2020-12-07 13:01:27','SYNCED','0cb80604-d416-4b7d-9f65-37f78767efe2',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.26.39.1.1\",\"modelMatrix\":\"0.828983,-0.510925,0.22747,0,0.559274,0.757318,-0.337167,0,-5.27888e-9,0.406724,0.913551,0,9.70067,-32.3021,-17.4631,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0cb916e8-5c90-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cb916e8-5c90-11eb-94ee-226cec7cb58a.png','SNAPS','PATIENT_72b315b2-aa50-4850-ba10-6553f6ea4ff1_ACT_ae5f4ba0-b39f-4474-ba5c-35072e2b2e69_SESS_984d3625-f60e-46cc-a1bc-b41b3dd6a003_TOSC_0df570d4-74db-41e3-9168-5fc1e6f8bdb3_SNAPS_','2021-01-22 08:47:51','2021-01-22 09:28:12','0cb916e8-5c90-11eb-94ee-226cec7cb58a.png','2021-01-22 09:47:51','SYNCED','0cb916e8-5c90-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.15.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0cba3ab7-5c90-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cba3ab7-5c90-11eb-94ee-226cec7cb58a.png','SNAPS','PATIENT_72b315b2-aa50-4850-ba10-6553f6ea4ff1_ACT_ae5f4ba0-b39f-4474-ba5c-35072e2b2e69_SESS_984d3625-f60e-46cc-a1bc-b41b3dd6a003_TOSC_24586f9a-85db-4d53-99d3-25a36baec099_SNAPS_','2021-01-22 08:47:51','2021-01-22 09:25:03','0cba3ab7-5c90-11eb-94ee-226cec7cb58a.png','2021-01-22 09:47:51','SYNCED','0cba3ab7-5c90-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.15.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0cc3c2de-1b64-404e-95e2-b13361393b78','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cc3c2de-1b64-404e-95e2-b13361393b78.ply','PLY','PATIENT_a2f7d1b6-87f5-47b9-98af-09ba76b22f19_ACT_e96b1c26-a3f9-441c-9c71-ab866b5a8ca6_SESS_3d88b948-c120-4ba9-b403-4ed3513d3c34_TOSC_fbad6161-4dfb-47f7-a1da-2b7e64ca3ab1_PLY_','2021-06-07 11:39:08','2020-06-23 09:59:20','0cc3c2de-1b64-404e-95e2-b13361393b78.ply','2021-06-07 13:39:08','SYNCED','0cc3c2de-1b64-404e-95e2-b13361393b78',0,'2021-06-07 13:39:08','','','{\"displayTitle\":\"Maxillaire 216.1.71.1.1\",\"modelMatrix\":\"0.574504,-0.791124,0.20992,0,0.818501,0.555289,-0.147343,0,5.06123e-9,0.256469,0.966552,0,-3.20966,-31.1106,-17.4037,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0cc8b930-1c49-40f4-849f-25c5ab4b41ce','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cc8b930-1c49-40f4-849f-25c5ab4b41ce.ply','PLY','PATIENT_72f539f4-2d06-47fa-b0b8-1291879a4818_ACT_d55baca2-6f09-4446-a148-dcdcfcaf57d8_SESS_5efdc987-8bdd-454f-b282-82efcf807bae_TOSC_d4b9e0ad-bc1d-4120-8cc6-d9bbcfa6e59e_PLY_','2021-08-19 22:27:15','2019-11-26 11:54:50','0cc8b930-1c49-40f4-849f-25c5ab4b41ce.ply','2021-08-20 00:27:15','SYNCED','0cc8b930-1c49-40f4-849f-25c5ab4b41ce',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 86.1.1.1.1\",\"modelMatrix\":\"-0.0622311,-0.963833,0.259139,0,0.998062,-0.0600968,0.0161578,0,-1.30401e-9,0.259642,0.965705,0,-18.9601,-24.0529,-25.4983,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0cce8376-2d3f-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cce8376-2d3f-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_c4b2ab75-de84-4ead-837c-d8e600b338c4_SESS_4576ed53-a7e8-4fb1-a55f-f2d13c3acb65_BOSC_dac163bd-d09c-4923-afcb-5ed73f7f4734_PLY_','2020-12-23 09:08:09','2020-01-02 10:05:09','0cce8376-2d3f-11ea-947d-226cec7cb58a.ply','2020-12-23 10:08:09','SYNCED','0cce8376-2d3f-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"modelMatrix\":\"-0.96203,0.269205,-0.0450329,0,-0.272945,-0.948845,0.158724,0,-2.34857e-10,0.164989,0.986295,0,-14.5519,22.5128,-14.11,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0cd01242-2d3f-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cd01242-2d3f-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_dd21fc57-5706-4bab-afe0-722c1578f1f6_ACT_c4b2ab75-de84-4ead-837c-d8e600b338c4_SESS_4576ed53-a7e8-4fb1-a55f-f2d13c3acb65_TOSC_4dd88361-dbce-44b6-a693-7c5311fc4b07_PLY_','2020-12-23 09:08:09','2020-01-02 10:01:25','0cd01242-2d3f-11ea-947d-226cec7cb58a.ply','2020-12-23 10:08:09','SYNCED','0cd01242-2d3f-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"modelMatrix\":\"0.727828,-0.61277,0.307863,0,0.68576,0.65036,-0.326749,0,-2.1555e-9,0.448937,0.893563,0,6.39389,-28.6894,-19.2638,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0cd19247-2d3f-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cd19247-2d3f-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_c4b2ab75-de84-4ead-837c-d8e600b338c4_SESS_4576ed53-a7e8-4fb1-a55f-f2d13c3acb65_BOSC_dac163bd-d09c-4923-afcb-5ed73f7f4734_SNAPS_','2020-12-23 09:08:10','2020-01-02 10:05:09','0cd19247-2d3f-11ea-947d-226cec7cb58a.png','2020-12-23 10:08:10','SYNCED','0cd19247-2d3f-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0cd3a14a-247c-4e87-ae56-840b04ecce06','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cd3a14a-247c-4e87-ae56-840b04ecce06.png','SNAPS','PATIENT_9243b0db-6a51-43bc-9684-db6d75efe77d_ACT_f25f7924-fb03-4ba2-96c4-c2b66c61bc2d_SESS_c577848c-5e45-4e04-af91-d3c2810d2480_BOSC_ee921a4a-bb66-44f1-a13f-786c6fe9e5cd_SNAPS_','2022-03-04 13:40:23','2019-07-10 12:07:50','0cd3a14a-247c-4e87-ae56-840b04ecce06.png','2022-03-04 14:40:23','SYNCED','0cd3a14a-247c-4e87-ae56-840b04ecce06',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 26.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0cd4f18d-2835-4cd7-9778-6e44d3a73b9a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cd4f18d-2835-4cd7-9778-6e44d3a73b9a.ply','PLY','PATIENT_bd1eba7e-0abe-41fc-859e-90761a16482e_ACT_896e85b9-5776-4f4b-a605-57a738ffaf31_SESS_eecc3c10-e747-4234-b94e-6ef19f29289b_TOSC_69501f21-cfd6-4ee7-b1ee-39c81c09300e_PLY_','2021-01-15 08:42:11','2021-01-15 09:33:25','0cd4f18d-2835-4cd7-9778-6e44d3a73b9a.ply','2021-01-15 09:42:11','SYNCED','0cd4f18d-2835-4cd7-9778-6e44d3a73b9a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.5.1.3\",\"modelMatrix\":\"0.749588,-0.633018,0.193406,0,0.661905,0.716875,-0.219027,0,-1.12484e-9,0.292197,0.956358,0,8.72064,-34.0239,-23.6843,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0cd64172-2d3f-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cd64172-2d3f-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_dd21fc57-5706-4bab-afe0-722c1578f1f6_ACT_c4b2ab75-de84-4ead-837c-d8e600b338c4_SESS_4576ed53-a7e8-4fb1-a55f-f2d13c3acb65_TOSC_4dd88361-dbce-44b6-a693-7c5311fc4b07_SNAPS_','2020-12-23 09:08:10','2020-01-02 10:01:25','0cd64172-2d3f-11ea-947d-226cec7cb58a.png','2020-12-23 10:08:10','SYNCED','0cd64172-2d3f-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 1.16.267.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0cda629b-6aff-479e-826f-f453629054f1','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cda629b-6aff-479e-826f-f453629054f1.ply','PLY','PATIENT_be301dae-5c7e-4b03-b929-70a80b42395d_ACT_d711943f-43de-4c7a-91a9-6cbafd17a8f3_SESS_77d93af5-856f-466b-b06f-025212b773a8_BOSC_18945b15-c41e-44f3-9d15-747d7ff88e9d_PLY_','2020-12-23 09:08:10','2019-12-20 13:59:47','0cda629b-6aff-479e-826f-f453629054f1.ply','2020-12-23 10:08:10','SYNCED','0cda629b-6aff-479e-826f-f453629054f1',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 1.16.267.1.1.1\",\"modelMatrix\":\"-0.712111,0.664676,-0.22606,0,-0.702067,-0.674186,0.229294,0,-6.27336e-9,0.321992,0.946743,0,1.81909,18.8773,-20.6364,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0cdcde34-d216-48b4-ba4d-e002dd066bf1','','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_9dcc3d38-3a64-4848-aae9-3d6efca8c19b_SESS_aa4cef4d-d6e9-4c23-9795-622754bff084_TOSC_c1b22f0f-249b-4212-aeaf-da8f93ee8bbe_PLY_','2021-04-16 07:44:28','2021-04-16 09:41:20','','2021-04-16 09:44:28','SYNCED','0cdcde34-d216-48b4-ba4d-e002dd066bf1',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.71.1.1\",\"modelMatrix\":\"0.800284,-0.52756,0.285,0,0.59962,0.704109,-0.380376,0,-2.76309e-8,0.475301,0.879823,0,11.0227,-40.3436,-22.3066,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0cdd3e2f-881a-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cdd3e2f-881a-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_82cabf0f-e610-4541-b7b5-f032d1e3c3c8_SESS_0b9702a6-1d15-41f9-ac87-79bd939f52d8_BOSC_17f6aa7a-db86-4744-8209-fd4db34cfb53_ZIP_','2022-02-07 13:25:16','2022-02-07 14:25:14','0cdd3e2f-881a-11ec-9377-226cec7cb58a.zip','2022-02-07 14:25:16','SYNCED','0cdd3e2f-881a-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.19.1.2\",\"modelMatrix\":\"-0.99299,-0.115414,0.0255052,0,0.118199,-0.969597,0.21427,0,-9.47948e-10,0.215782,0.976441,0,-25.0528,10.5654,-18.8271,1\",\"title\":\"Mandibule ZIP\"}'),(2,'0cde93fe-f762-4d72-ac90-bf56c1a85e2a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cde93fe-f762-4d72-ac90-bf56c1a85e2a.png','SNAPS','PATIENT_1d3a5311-b69a-4276-8b4a-369d086f6371_ACT_28ab8610-8893-458c-8518-76753ca69a12_SESS_79751b02-c9d7-4b56-93d1-2104702255fc_TOSC_1db7a6a6-6a80-4ca5-aa44-23d538f2db22_SNAPS_','2022-02-01 11:47:32','2019-07-29 11:10:59','0cde93fe-f762-4d72-ac90-bf56c1a85e2a.png','2022-02-01 12:47:32','SYNCED','0cde93fe-f762-4d72-ac90-bf56c1a85e2a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 115.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0ceb4070-eb54-4385-a435-15a5aff1a2b6','','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_06dc3749-6d34-435a-9d3d-16ea121020cf_SESS_4ee8f4ed-e86b-456a-a551-711571bb691c_BOSC_e369e531-4d85-495c-939c-739f82e43fc7_SNAPS_','2021-03-30 08:49:34','2021-03-30 10:49:32','','2021-03-30 10:49:34','SYNCED','0ceb4070-eb54-4385-a435-15a5aff1a2b6',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0cfc3f89-06a6-483e-90a0-2b1d60a8ede0','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cfc3f89-06a6-483e-90a0-2b1d60a8ede0.png','SNAPS','PATIENT_7afceb75-c859-449d-98fc-db1d3941b795_ACT_43f2649c-a6d8-46e8-9a60-f6c6e927308f_SESS_6724c6e2-b258-4fed-8224-afbb51fadbe9_TOSC_585ef489-0439-4c6c-a2b8-503d9056495d_SNAPS_','2022-02-01 11:47:32','2019-07-22 16:50:56','0cfc3f89-06a6-483e-90a0-2b1d60a8ede0.png','2022-02-01 12:47:32','SYNCED','0cfc3f89-06a6-483e-90a0-2b1d60a8ede0',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 108.2.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0cfdb578-881a-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0cfdb578-881a-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_82cabf0f-e610-4541-b7b5-f032d1e3c3c8_SESS_0b9702a6-1d15-41f9-ac87-79bd939f52d8_BOSC_68b2b071-f01d-429e-9298-df60d53b4535_SNAPS_','2022-02-07 13:22:48','2022-02-07 14:22:44','0cfdb578-881a-11ec-9377-226cec7cb58a.png','2022-02-07 14:22:48','SYNCED','0cfdb578-881a-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.19.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0d00071d-6e6b-4079-8073-f04f67bb5687','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d00071d-6e6b-4079-8073-f04f67bb5687.png','SNAPS','PATIENT_d8a78ca7-378e-4f4c-97b5-1f1082842006_ACT_b1867e3f-247b-4070-a2a1-304aef08103e_SESS_e2676d2e-fa47-47f2-819d-e5c3934828b8_TOSC_27f2b91e-2ece-4c1a-ae40-df130290b90f_SNAPS_','2021-01-15 09:13:43','2021-01-15 10:01:25','0d00071d-6e6b-4079-8073-f04f67bb5687.png','2021-01-15 10:13:43','SYNCED','0d00071d-6e6b-4079-8073-f04f67bb5687',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.6.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0d01363a-881a-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d01363a-881a-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_82cabf0f-e610-4541-b7b5-f032d1e3c3c8_SESS_0b9702a6-1d15-41f9-ac87-79bd939f52d8_TOSC_aa573aee-9a68-420f-8735-49609fbb4ef1_SNAPS_','2022-02-07 13:19:00','2022-02-07 14:18:53','0d01363a-881a-11ec-9377-226cec7cb58a.png','2022-02-07 14:19:00','SYNCED','0d01363a-881a-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.19.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0d04957a-881a-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d04957a-881a-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_82cabf0f-e610-4541-b7b5-f032d1e3c3c8_SESS_0b9702a6-1d15-41f9-ac87-79bd939f52d8_TOSC_aa573aee-9a68-420f-8735-49609fbb4ef1_ZIP_','2022-02-07 13:19:00','2022-02-07 14:18:54','0d04957a-881a-11ec-9377-226cec7cb58a.zip','2022-02-07 14:19:00','SYNCED','0d04957a-881a-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.19.1.3\",\"modelMatrix\":\"0.761494,-0.57586,0.297511,0,0.648172,0.676539,-0.349525,0,1.90297e-8,0.458999,0.888437,0,7.86671,-36.1467,-25.1626,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'0d084f93-881a-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d084f93-881a-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_82cabf0f-e610-4541-b7b5-f032d1e3c3c8_SESS_0b9702a6-1d15-41f9-ac87-79bd939f52d8_BOSC_c6bb62c7-4692-4227-8ffa-56087e92e7b2_ZIP_','2022-02-07 13:27:53','2022-02-07 14:27:51','0d084f93-881a-11ec-9377-226cec7cb58a.zip','2022-02-07 14:27:53','SYNCED','0d084f93-881a-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.19.1.3\",\"modelMatrix\":\"-0.960949,-0.273728,0.0406225,0,0.276726,-0.950539,0.141064,0,1.34503e-9,0.146797,0.989167,0,-27.0478,12.23,-19.3297,1\",\"title\":\"Mandibule ZIP\"}'),(2,'0d099f15-72b3-11eb-8b86-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d099f15-72b3-11eb-8b86-226cec7cb58a.png','SNAPS','PATIENT_48038a91-56dd-4701-a85c-dd609735ad55_ACT_2e1fa45b-9441-4f5b-995d-aa2017b395c0_SESS_36d7edf2-2691-4b60-b2d3-1ac51a909565_TOSC_5240e1e1-2370-4e41-bbbf-53ee5ca1f379_SNAPS_','2021-02-19 13:06:11','2021-02-19 13:57:37','0d099f15-72b3-11eb-8b86-226cec7cb58a.png','2021-02-19 14:06:11','SYNCED','0d099f15-72b3-11eb-8b86-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.50.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0d0ab0bc-9934-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d0ab0bc-9934-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_8a46fe73-45f9-48a6-b7b5-7f571298b5c3_SESS_88277293-7807-4a9d-8a3b-4bada1cecf0b_BOSC_52fafe7f-87d6-4fd9-b56c-45060a2faf31_SNAPS_','2021-04-09 12:57:24','2021-04-09 14:57:22','0d0ab0bc-9934-11eb-9377-226cec7cb58a.png','2021-04-09 14:57:24','SYNCED','0d0ab0bc-9934-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.48.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0d0c37b0-62bf-4dce-8aa7-7c4e2449550d','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d0c37b0-62bf-4dce-8aa7-7c4e2449550d.png','SNAPS','PATIENT_8a7af7e9-9415-4cc6-b6d7-27441f26e70d_ACT_3fd60465-563d-46c3-bd52-7f68d8c51532_SESS_9af36735-7dab-4aa1-843a-5117d8357962_BOSC_d6c56a23-03f7-4bac-af21-c975510554ec_SNAPS_','2021-03-23 11:04:27','2021-03-23 12:04:06','0d0c37b0-62bf-4dce-8aa7-7c4e2449550d.png','2021-03-23 12:04:27','SYNCED','0d0c37b0-62bf-4dce-8aa7-7c4e2449550d',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.105.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0d0d55ba-881a-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d0d55ba-881a-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_82cabf0f-e610-4541-b7b5-f032d1e3c3c8_SESS_0b9702a6-1d15-41f9-ac87-79bd939f52d8_BOSC_17f6aa7a-db86-4744-8209-fd4db34cfb53_SNAPS_','2022-02-07 13:25:16','2022-02-07 14:25:13','0d0d55ba-881a-11ec-9377-226cec7cb58a.png','2022-02-07 14:25:16','SYNCED','0d0d55ba-881a-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.19.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0d0dd037-9934-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d0dd037-9934-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_8a46fe73-45f9-48a6-b7b5-7f571298b5c3_SESS_88277293-7807-4a9d-8a3b-4bada1cecf0b_BOSC_8a613359-a7fc-487e-8874-ffbe824311ba_PLY_','2021-04-09 13:03:00','2021-04-09 15:02:58','0d0dd037-9934-11eb-9377-226cec7cb58a.ply','2021-04-09 15:03:00','SYNCED','0d0dd037-9934-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.48.1.3\",\"modelMatrix\":\"-0.801175,-0.580819,0.144111,0,0.598431,-0.777597,0.192935,0,1.07819e-9,0.240816,0.970571,0,-19.3869,-1.76891,-25.055,1\",\"title\":\"Mandibule PLY\"}'),(2,'0d0e1d42-72b3-11eb-8b86-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d0e1d42-72b3-11eb-8b86-226cec7cb58a.png','SNAPS','PATIENT_48038a91-56dd-4701-a85c-dd609735ad55_ACT_2e1fa45b-9441-4f5b-995d-aa2017b395c0_SESS_36d7edf2-2691-4b60-b2d3-1ac51a909565_BOSC_9e4ad6c1-b899-431d-8a2d-4f688a5ab760_SNAPS_','2021-02-19 13:06:10','2021-02-19 14:05:27','0d0e1d42-72b3-11eb-8b86-226cec7cb58a.png','2021-02-19 14:06:10','SYNCED','0d0e1d42-72b3-11eb-8b86-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.50.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0d104114-a9f4-41aa-ace6-a82bb068f685','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d104114-a9f4-41aa-ace6-a82bb068f685.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_c45d0739-b5b3-4445-9c9a-8bdb8a4186dc_SESS_cf02e77d-d403-4734-86b9-e7bee008a9f5_BOSC_ca5f4763-c5ce-47d4-ad0c-aac6a9def49f_SNAPS_','2021-03-30 12:21:14','2021-03-30 14:21:13','0d104114-a9f4-41aa-ace6-a82bb068f685.png','2021-03-30 14:21:14','SYNCED','0d104114-a9f4-41aa-ace6-a82bb068f685',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.6.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0d107fd7-b558-40ed-badd-039cb6608142','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d107fd7-b558-40ed-badd-039cb6608142.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_88e54a5c-ca2b-4e9f-822b-6086e7725256_SESS_8c157a5b-34f0-49fc-b5c0-837bf265dfac_BOSC_ac9ec2eb-33af-4b1d-9e6b-66dfb571ea36_SNAPS_','2021-04-14 08:15:19','2021-04-14 10:15:18','0d107fd7-b558-40ed-badd-039cb6608142.png','2021-04-14 10:15:19','SYNCED','0d107fd7-b558-40ed-badd-039cb6608142',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.57.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0d10afd4-72b3-11eb-8b86-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d10afd4-72b3-11eb-8b86-226cec7cb58a.ply','PLY','PATIENT_48038a91-56dd-4701-a85c-dd609735ad55_ACT_2e1fa45b-9441-4f5b-995d-aa2017b395c0_SESS_36d7edf2-2691-4b60-b2d3-1ac51a909565_TOSC_dd31da43-938f-4be7-9025-67626c30a5b8_PLY_','2021-02-19 13:06:09','2021-02-19 13:52:32','0d10afd4-72b3-11eb-8b86-226cec7cb58a.ply','2021-02-19 14:06:09','SYNCED','0d10afd4-72b3-11eb-8b86-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.50.1.1\",\"modelMatrix\":\"0.498609,-0.802714,0.327168,0,0.866827,0.46173,-0.188191,0,-4.82906e-9,0.377432,0.926037,0,-4.19782,-38.7888,-19.8692,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0d11123d-9934-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d11123d-9934-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_8a46fe73-45f9-48a6-b7b5-7f571298b5c3_SESS_88277293-7807-4a9d-8a3b-4bada1cecf0b_BOSC_b20dacbd-b7c4-4984-aeef-074c2ccb9756_SNAPS_','2021-04-09 13:00:26','2021-04-09 15:00:23','0d11123d-9934-11eb-9377-226cec7cb58a.png','2021-04-09 15:00:26','SYNCED','0d11123d-9934-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.48.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0d117968-881a-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d117968-881a-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_82cabf0f-e610-4541-b7b5-f032d1e3c3c8_SESS_0b9702a6-1d15-41f9-ac87-79bd939f52d8_BOSC_c6bb62c7-4692-4227-8ffa-56087e92e7b2_SNAPS_','2022-02-07 13:27:53','2022-02-07 14:27:50','0d117968-881a-11ec-9377-226cec7cb58a.png','2022-02-07 14:27:53','SYNCED','0d117968-881a-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.19.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0d13a711-d28d-4d0f-ae15-a0de1173508a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d13a711-d28d-4d0f-ae15-a0de1173508a.stl','STL','PATIENT_e2ad6866-17be-4ec9-ace3-df2075baed98_ACT_628664ea-6869-485b-9c25-5b14151d796d_SESS_fbdbf097-6fee-4478-995f-6221a0d4627a_TOSC_b4e1ae2c-0f1b-44b1-b43f-287c75583c96_STL_','2021-01-06 11:02:57','2019-12-13 15:00:07','0d13a711-d28d-4d0f-ae15-a0de1173508a.stl','2021-01-06 12:02:57','SYNCED','0d13a711-d28d-4d0f-ae15-a0de1173508a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 232.21.1.1\",\"modelMatrix\":\"0.346437,-0.905252,0.245969,0,0.938073,0.334316,-0.0908383,0,1.42618e-9,0.262207,0.965012,0,-10.2143,-32.7421,-18.0217,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'0d150b71-9934-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d150b71-9934-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_8a46fe73-45f9-48a6-b7b5-7f571298b5c3_SESS_88277293-7807-4a9d-8a3b-4bada1cecf0b_TOSC_8a42ef25-37c3-44c4-8977-6fcb00475ea5_PLY_','2021-04-09 13:03:59','2021-04-09 14:47:48','0d150b71-9934-11eb-9377-226cec7cb58a.ply','2021-04-09 15:03:59','SYNCED','0d150b71-9934-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.48.1.1\",\"modelMatrix\":\"0.557255,-0.751359,0.353449,0,0.830341,0.504249,-0.237205,0,3.12973e-9,0.425667,0.90488,0,3.50444,-37.9011,-25.6764,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0d150da5-881a-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d150da5-881a-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_82cabf0f-e610-4541-b7b5-f032d1e3c3c8_SESS_0b9702a6-1d15-41f9-ac87-79bd939f52d8_TOSC_b63781c6-cb72-47f6-b0b2-72a921335369_ZIP_','2022-02-07 13:15:44','2022-02-07 14:15:41','0d150da5-881a-11ec-9377-226cec7cb58a.zip','2022-02-07 14:15:44','SYNCED','0d150da5-881a-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.19.1.2\",\"modelMatrix\":\"0.273554,-0.928425,0.251387,0,0.961857,0.264046,-0.0714947,0,-2.78249e-10,0.261356,0.965243,0,-10.2796,-36.2222,-14.7162,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'0d1510b8-72b3-11eb-8b86-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d1510b8-72b3-11eb-8b86-226cec7cb58a.ply','PLY','PATIENT_48038a91-56dd-4701-a85c-dd609735ad55_ACT_2e1fa45b-9441-4f5b-995d-aa2017b395c0_SESS_36d7edf2-2691-4b60-b2d3-1ac51a909565_BOSC_0f3a7132-dfda-4967-937d-975bc9578197_PLY_','2021-02-19 13:06:10','2021-02-19 14:00:05','0d1510b8-72b3-11eb-8b86-226cec7cb58a.ply','2021-02-19 14:06:10','SYNCED','0d1510b8-72b3-11eb-8b86-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.50.1.1\",\"modelMatrix\":\"-0.999117,-0.0412622,0.00796415,0,0.0420238,-0.98101,0.189348,0,8.12177e-10,0.189515,0.981878,0,-18.2226,14.4124,-20.5418,1\",\"title\":\"Mandibule PLY\"}'),(2,'0d1893cc-881a-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d1893cc-881a-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_82cabf0f-e610-4541-b7b5-f032d1e3c3c8_SESS_0b9702a6-1d15-41f9-ac87-79bd939f52d8_BOSC_68b2b071-f01d-429e-9298-df60d53b4535_ZIP_','2022-02-07 13:22:48','2022-02-07 14:22:45','0d1893cc-881a-11ec-9377-226cec7cb58a.zip','2022-02-07 14:22:48','SYNCED','0d1893cc-881a-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.4.19.1.1\",\"modelMatrix\":\"-0.0609238,-0.994787,0.0817707,0,0.998142,-0.0607191,0.00499106,0,-6.21633e-10,0.0819229,0.996639,0,-15.3469,-12.9977,-21.0094,1\",\"title\":\"Mandibule ZIP\"}'),(2,'0d18b12e-9934-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d18b12e-9934-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_8a46fe73-45f9-48a6-b7b5-7f571298b5c3_SESS_88277293-7807-4a9d-8a3b-4bada1cecf0b_TOSC_d6b5c1d9-66bd-48a8-b3c6-24cb224dcec4_SNAPS_','2021-04-09 12:54:09','2021-04-09 14:54:08','0d18b12e-9934-11eb-9377-226cec7cb58a.png','2021-04-09 14:54:09','SYNCED','0d18b12e-9934-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.48.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0d1a7788-72b3-11eb-8b86-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d1a7788-72b3-11eb-8b86-226cec7cb58a.png','SNAPS','PATIENT_48038a91-56dd-4701-a85c-dd609735ad55_ACT_2e1fa45b-9441-4f5b-995d-aa2017b395c0_SESS_36d7edf2-2691-4b60-b2d3-1ac51a909565_TOSC_dd31da43-938f-4be7-9025-67626c30a5b8_SNAPS_','2021-02-19 13:06:10','2021-02-19 13:52:32','0d1a7788-72b3-11eb-8b86-226cec7cb58a.png','2021-02-19 14:06:10','SYNCED','0d1a7788-72b3-11eb-8b86-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.50.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0d1bae2d-881a-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d1bae2d-881a-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_82cabf0f-e610-4541-b7b5-f032d1e3c3c8_SESS_0b9702a6-1d15-41f9-ac87-79bd939f52d8_TOSC_7fa2025c-2b90-4e63-b5af-cd026ce326ac_ZIP_','2022-02-07 13:11:58','2022-02-07 14:11:56','0d1bae2d-881a-11ec-9377-226cec7cb58a.zip','2022-02-07 14:11:58','SYNCED','0d1bae2d-881a-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.19.1.1\",\"modelMatrix\":\"-0.120905,-0.95273,0.278726,0,0.992664,-0.116041,0.0339486,0,2.5104e-9,0.280786,0.95977,0,-21.281,-20.2635,-16.65,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'0d1be7bb-9934-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d1be7bb-9934-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_8a46fe73-45f9-48a6-b7b5-7f571298b5c3_SESS_88277293-7807-4a9d-8a3b-4bada1cecf0b_TOSC_19a84c46-c65e-4ebe-8c27-eb08ae7efc66_SNAPS_','2021-04-09 12:50:59','2021-04-09 14:50:58','0d1be7bb-9934-11eb-9377-226cec7cb58a.png','2021-04-09 14:50:59','SYNCED','0d1be7bb-9934-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.48.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0d1ef8d3-881a-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d1ef8d3-881a-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_82cabf0f-e610-4541-b7b5-f032d1e3c3c8_SESS_0b9702a6-1d15-41f9-ac87-79bd939f52d8_TOSC_b63781c6-cb72-47f6-b0b2-72a921335369_SNAPS_','2022-02-07 13:15:44','2022-02-07 14:15:40','0d1ef8d3-881a-11ec-9377-226cec7cb58a.png','2022-02-07 14:15:44','SYNCED','0d1ef8d3-881a-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.19.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0d20fbf3-72b3-11eb-8b86-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d20fbf3-72b3-11eb-8b86-226cec7cb58a.ply','PLY','PATIENT_48038a91-56dd-4701-a85c-dd609735ad55_ACT_2e1fa45b-9441-4f5b-995d-aa2017b395c0_SESS_36d7edf2-2691-4b60-b2d3-1ac51a909565_TOSC_ec46dc97-c1b9-4d11-8c71-c6c4c58bcfb4_PLY_','2021-02-19 13:06:11','2021-02-19 13:55:11','0d20fbf3-72b3-11eb-8b86-226cec7cb58a.ply','2021-02-19 14:06:11','SYNCED','0d20fbf3-72b3-11eb-8b86-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.50.1.2\",\"modelMatrix\":\"0.682388,-0.688171,0.246512,0,0.730991,0.642415,-0.230122,0,-1.89027e-9,0.337231,0.941422,0,6.05426,-30.193,-16.7574,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0d21db67-685f-47c9-89de-758bb6affea7','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d21db67-685f-47c9-89de-758bb6affea7.ply','PLY','PATIENT_9243b0db-6a51-43bc-9684-db6d75efe77d_ACT_f25f7924-fb03-4ba2-96c4-c2b66c61bc2d_SESS_c577848c-5e45-4e04-af91-d3c2810d2480_BOSC_ee921a4a-bb66-44f1-a13f-786c6fe9e5cd_PLY_','2022-03-04 13:40:24','2019-07-10 12:07:50','0d21db67-685f-47c9-89de-758bb6affea7.ply','2022-03-04 14:40:24','SYNCED','0d21db67-685f-47c9-89de-758bb6affea7',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 26.1.1.1\",\"modelMatrix\":\"0.351244,0.928713,-0.118826,0,-0.936284,0.348404,-0.0445771,0,1.42707e-9,0.126912,0.991914,0,6.81309,-34.1121,-21.355,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0d2204e6-9934-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d2204e6-9934-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_8a46fe73-45f9-48a6-b7b5-7f571298b5c3_SESS_88277293-7807-4a9d-8a3b-4bada1cecf0b_BOSC_52fafe7f-87d6-4fd9-b56c-45060a2faf31_PLY_','2021-04-09 13:00:26','2021-04-09 14:58:00','0d2204e6-9934-11eb-9377-226cec7cb58a.ply','2021-04-09 15:00:26','SYNCED','0d2204e6-9934-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.48.1.1\",\"modelMatrix\":\"-0.945685,-0.298246,0.129339,0,0.325084,-0.867614,0.376253,0,-3.15144e-9,0.397863,0.917445,0,-25.4696,3.20553,-17.4343,1\",\"title\":\"Mandibule PLY\"}'),(2,'0d224f8e-881a-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d224f8e-881a-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_82cabf0f-e610-4541-b7b5-f032d1e3c3c8_SESS_0b9702a6-1d15-41f9-ac87-79bd939f52d8_TOSC_7fa2025c-2b90-4e63-b5af-cd026ce326ac_SNAPS_','2022-02-07 13:11:59','2022-02-07 14:11:55','0d224f8e-881a-11ec-9377-226cec7cb58a.png','2022-02-07 14:11:59','SYNCED','0d224f8e-881a-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.19.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0d2569c0-9934-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d2569c0-9934-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_8a46fe73-45f9-48a6-b7b5-7f571298b5c3_SESS_88277293-7807-4a9d-8a3b-4bada1cecf0b_TOSC_19a84c46-c65e-4ebe-8c27-eb08ae7efc66_PLY_','2021-04-09 12:54:09','2021-04-09 14:52:03','0d2569c0-9934-11eb-9377-226cec7cb58a.ply','2021-04-09 14:54:09','SYNCED','0d2569c0-9934-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.48.1.2\",\"modelMatrix\":\"0.59023,-0.765353,0.25664,0,0.807235,0.559606,-0.187649,0,-1.02197e-8,0.317925,0.948116,0,-2.34991,-32.3245,-13.1775,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0d258076-72b3-11eb-8b86-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d258076-72b3-11eb-8b86-226cec7cb58a.ply','PLY','PATIENT_48038a91-56dd-4701-a85c-dd609735ad55_ACT_2e1fa45b-9441-4f5b-995d-aa2017b395c0_SESS_36d7edf2-2691-4b60-b2d3-1ac51a909565_BOSC_aaae5b75-aa74-40a5-8566-5c0c338d4448_PLY_','2021-02-19 13:06:11','2021-02-19 14:02:33','0d258076-72b3-11eb-8b86-226cec7cb58a.ply','2021-02-19 14:06:11','SYNCED','0d258076-72b3-11eb-8b86-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.50.1.2\",\"modelMatrix\":\"-0.991111,-0.131056,0.0228899,0,0.13304,-0.976331,0.170524,0,6.76331e-10,0.172053,0.985088,0,-18.2314,9.25422,-21.0383,1\",\"title\":\"Mandibule PLY\"}'),(2,'0d28a65a-9934-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d28a65a-9934-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_8a46fe73-45f9-48a6-b7b5-7f571298b5c3_SESS_88277293-7807-4a9d-8a3b-4bada1cecf0b_TOSC_d6b5c1d9-66bd-48a8-b3c6-24cb224dcec4_PLY_','2021-04-09 12:57:24','2021-04-09 14:55:00','0d28a65a-9934-11eb-9377-226cec7cb58a.ply','2021-04-09 14:57:24','SYNCED','0d28a65a-9934-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.48.1.3\",\"modelMatrix\":\"0.512302,-0.821432,0.250591,0,0.858806,0.490007,-0.149485,0,2.54752e-9,0.291791,0.956482,0,-6.59381,-35.8611,-15.3815,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0d293407-72b3-11eb-8b86-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d293407-72b3-11eb-8b86-226cec7cb58a.ply','PLY','PATIENT_48038a91-56dd-4701-a85c-dd609735ad55_ACT_2e1fa45b-9441-4f5b-995d-aa2017b395c0_SESS_36d7edf2-2691-4b60-b2d3-1ac51a909565_TOSC_5240e1e1-2370-4e41-bbbf-53ee5ca1f379_PLY_','2021-02-19 13:06:11','2021-02-19 13:57:37','0d293407-72b3-11eb-8b86-226cec7cb58a.ply','2021-02-19 14:06:11','SYNCED','0d293407-72b3-11eb-8b86-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.50.1.3\",\"modelMatrix\":\"0.642401,-0.697245,0.318073,0,0.766369,0.584459,-0.266622,0,1.6004e-8,0.415039,0.909804,0,1.41961,-31.8309,-14.9455,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0d2b78de-9934-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d2b78de-9934-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_8a46fe73-45f9-48a6-b7b5-7f571298b5c3_SESS_88277293-7807-4a9d-8a3b-4bada1cecf0b_BOSC_8a613359-a7fc-487e-8874-ffbe824311ba_SNAPS_','2021-04-09 13:03:00','2021-04-09 15:02:58','0d2b78de-9934-11eb-9377-226cec7cb58a.png','2021-04-09 15:03:00','SYNCED','0d2b78de-9934-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.48.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0d2c87ca-9482-4e4b-b974-10e379a56e3f','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d2c87ca-9482-4e4b-b974-10e379a56e3f.ply','PLY','PATIENT_bc50bff3-dacb-4f7a-a7c8-b971782c6d1d_ACT_be5de36f-b43d-47f3-b178-801c7822bb7d_SESS_df767eeb-30cd-456e-91c0-aa5269ac29d4_TOSC_5f0e526c-a0b7-4b79-a15f-cda97cb49eb9_PLY_','2021-08-19 22:27:19','2019-11-27 12:29:07','0d2c87ca-9482-4e4b-b974-10e379a56e3f.ply','2021-08-20 00:27:19','SYNCED','0d2c87ca-9482-4e4b-b974-10e379a56e3f',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 212.1.1.1\",\"modelMatrix\":\"0.476896,-0.839712,0.259721,0,0.87896,0.455601,-0.140916,0,1.05962e-8,0.295486,0.955347,0,-3.63681,-30.6605,-19.4772,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0d2e98c2-9934-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d2e98c2-9934-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_8a46fe73-45f9-48a6-b7b5-7f571298b5c3_SESS_88277293-7807-4a9d-8a3b-4bada1cecf0b_BOSC_b20dacbd-b7c4-4984-aeef-074c2ccb9756_PLY_','2021-04-09 13:03:00','2021-04-09 15:00:40','0d2e98c2-9934-11eb-9377-226cec7cb58a.ply','2021-04-09 15:03:00','SYNCED','0d2e98c2-9934-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.48.1.2\",\"modelMatrix\":\"-0.920534,-0.370382,0.124236,0,0.390663,-0.872745,0.292743,0,-1.05396e-8,0.318014,0.948086,0,-27.791,-0.874682,-16.2831,1\",\"title\":\"Mandibule PLY\"}'),(2,'0d2edb5b-72b3-11eb-8b86-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d2edb5b-72b3-11eb-8b86-226cec7cb58a.ply','PLY','PATIENT_48038a91-56dd-4701-a85c-dd609735ad55_ACT_2e1fa45b-9441-4f5b-995d-aa2017b395c0_SESS_36d7edf2-2691-4b60-b2d3-1ac51a909565_BOSC_9e4ad6c1-b899-431d-8a2d-4f688a5ab760_PLY_','2021-02-19 13:06:08','2021-02-19 14:05:27','0d2edb5b-72b3-11eb-8b86-226cec7cb58a.ply','2021-02-19 14:06:08','SYNCED','0d2edb5b-72b3-11eb-8b86-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.50.1.3\",\"modelMatrix\":\"-0.973012,-0.226457,0.0443328,0,0.230756,-0.954886,0.186935,0,-2.90689e-9,0.19212,0.981371,0,-20.0698,11.3782,-21.382,1\",\"title\":\"Mandibule PLY\"}'),(2,'0d2f70e0-895d-4ce1-b2b4-6c936a9732c2','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d2f70e0-895d-4ce1-b2b4-6c936a9732c2.ply','PLY','PATIENT_ecb1e656-6c20-4925-bf8f-2e973f1c74ab_ACT_010e13be-d502-44d8-acdc-aceeda22983d_SESS_718f3908-d310-40fd-a105-62e984134bfd_BOSC_0cfed85f-5e49-4bfa-8e31-acd1743c8d4e_PLY_','2021-09-20 09:03:45','2021-09-20 11:03:43','0d2f70e0-895d-4ce1-b2b4-6c936a9732c2.ply','2021-09-20 11:03:45','SYNCED','0d2f70e0-895d-4ce1-b2b4-6c936a9732c2',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.397.1.1.2\",\"modelMatrix\":\"-0.918871,-0.380708,0.103626,0,0.394559,-0.886613,0.24133,0,2.79825e-9,0.262637,0.964895,0,-22.631,12.6116,-16.5238,1\",\"title\":\"Mandibule PLY\"}'),(2,'0d3056a3-1793-445f-b54b-0cef492bf5b0','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d3056a3-1793-445f-b54b-0cef492bf5b0.ply','PLY','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_875a1e66-4203-4e71-88bf-db0512ab80f6_SESS_7f1064b6-9587-413e-9479-70a1b3fd3a59_BOSC_14de9ac8-8c68-4e57-ac56-e3dbb6a01a02_PLY_','2021-04-28 09:07:15','2021-04-28 11:07:13','0d3056a3-1793-445f-b54b-0cef492bf5b0.ply','2021-04-28 11:07:15','SYNCED','0d3056a3-1793-445f-b54b-0cef492bf5b0',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.122.1.3\",\"modelMatrix\":\"0.00169248,-0.986339,0.16472,0,0.999999,0.00166937,-0.000278787,0,-2.81344e-13,0.16472,0.98634,0,-4.63141,-26.8024,-25.6661,1\",\"title\":\"Mandibule PLY\"}'),(2,'0d33ac48-9934-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d33ac48-9934-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_8a46fe73-45f9-48a6-b7b5-7f571298b5c3_SESS_88277293-7807-4a9d-8a3b-4bada1cecf0b_TOSC_8a42ef25-37c3-44c4-8977-6fcb00475ea5_SNAPS_','2021-04-09 13:03:59','2021-04-09 14:47:48','0d33ac48-9934-11eb-9377-226cec7cb58a.png','2021-04-09 15:03:59','SYNCED','0d33ac48-9934-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.48.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0d33d603-72b3-11eb-8b86-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d33d603-72b3-11eb-8b86-226cec7cb58a.png','SNAPS','PATIENT_48038a91-56dd-4701-a85c-dd609735ad55_ACT_2e1fa45b-9441-4f5b-995d-aa2017b395c0_SESS_36d7edf2-2691-4b60-b2d3-1ac51a909565_BOSC_aaae5b75-aa74-40a5-8566-5c0c338d4448_SNAPS_','2021-02-19 13:06:11','2021-02-19 14:02:33','0d33d603-72b3-11eb-8b86-226cec7cb58a.png','2021-02-19 14:06:11','SYNCED','0d33d603-72b3-11eb-8b86-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.50.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0d35f2bb-c3c6-4d9e-bf3d-e7e88cdfb990','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d35f2bb-c3c6-4d9e-bf3d-e7e88cdfb990.png','SNAPS','PATIENT_30765aaa-988b-458f-959e-fbd2fc248a07_ACT_471af662-830c-42e4-8c98-afee3e090c1a_SESS_58e9df52-f32b-4dd4-a89e-2ca95cee2f79_BOSC_a9b3f0b7-e404-4dcb-984f-82eccc7543b7_SNAPS_','2021-09-15 09:16:46','2021-09-15 11:16:41','0d35f2bb-c3c6-4d9e-bf3d-e7e88cdfb990.png','2021-09-15 11:16:46','SYNCED','0d35f2bb-c3c6-4d9e-bf3d-e7e88cdfb990',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.386.1.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0d38283b-72b3-11eb-8b86-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d38283b-72b3-11eb-8b86-226cec7cb58a.png','SNAPS','PATIENT_48038a91-56dd-4701-a85c-dd609735ad55_ACT_2e1fa45b-9441-4f5b-995d-aa2017b395c0_SESS_36d7edf2-2691-4b60-b2d3-1ac51a909565_TOSC_ec46dc97-c1b9-4d11-8c71-c6c4c58bcfb4_SNAPS_','2021-02-19 13:06:10','2021-02-19 13:55:11','0d38283b-72b3-11eb-8b86-226cec7cb58a.png','2021-02-19 14:06:10','SYNCED','0d38283b-72b3-11eb-8b86-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.50.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0d38bd49-36eb-4dcb-9f65-5afe4750db4c','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d38bd49-36eb-4dcb-9f65-5afe4750db4c.stl','STL','PATIENT_e51cf9a2-03cb-4e48-928a-2755186e1db6_ACT_000dfdf1-07e2-4cb4-9351-56d36d0f2b2f_SESS_bcaa9cd4-a73e-45a0-aa14-14571985bf99_TOSC_4898a0f1-e758-4945-8096-35453addad4f_STL_','2022-02-01 11:47:32','2019-07-19 16:11:04','0d38bd49-36eb-4dcb-9f65-5afe4750db4c.stl','2022-02-01 12:47:32','SYNCED','0d38bd49-36eb-4dcb-9f65-5afe4750db4c',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 102.1.1.1\",\"modelMatrix\":\"0.604138,-0.726749,0.326884,0,0.796879,0.55097,-0.247821,0,1.17685e-8,0.410205,0.911993,0,4.5742,-36.6945,-23.86,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'0d39dbf2-9fc7-42d5-b54b-dc58bbde0d4e','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d39dbf2-9fc7-42d5-b54b-dc58bbde0d4e.png','SNAPS','PATIENT_68ccc647-d7af-43af-b066-4950901b78bd_ACT_1bfc9ae5-42fb-4b3d-8e54-a2c849ae3d96_SESS_10597265-5639-48a6-9f49-5b6f9e85d80e_BOSC_a7acb7b8-ed11-4b6f-9278-8182955e6081_SNAPS_','2022-02-01 11:47:33','2019-09-04 10:47:41','0d39dbf2-9fc7-42d5-b54b-dc58bbde0d4e.png','2022-02-01 12:47:33','SYNCED','0d39dbf2-9fc7-42d5-b54b-dc58bbde0d4e',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 144.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0d3e9755-72b3-11eb-8b86-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d3e9755-72b3-11eb-8b86-226cec7cb58a.png','SNAPS','PATIENT_48038a91-56dd-4701-a85c-dd609735ad55_ACT_2e1fa45b-9441-4f5b-995d-aa2017b395c0_SESS_36d7edf2-2691-4b60-b2d3-1ac51a909565_BOSC_0f3a7132-dfda-4967-937d-975bc9578197_SNAPS_','2021-02-19 13:06:11','2021-02-19 14:00:05','0d3e9755-72b3-11eb-8b86-226cec7cb58a.png','2021-02-19 14:06:11','SYNCED','0d3e9755-72b3-11eb-8b86-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.50.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0d414294-2aff-4813-b102-a6fec4e09826','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d414294-2aff-4813-b102-a6fec4e09826.png','SNAPS','PATIENT_5b3365d0-2ad4-4d78-9c7c-89ff37d5905d_ACT_ee6f943a-7cab-46d0-b223-fd379650024c_SESS_9f9fe29b-f6ed-4a4c-b9f0-7e6258af0943_TOSC_f8f5d6b9-e7ea-40f1-bf86-52f61b243725_SNAPS_','2020-12-08 17:27:12','2020-06-19 11:01:32','0d414294-2aff-4813-b102-a6fec4e09826.png','2020-12-08 18:27:12','SYNCED','0d414294-2aff-4813-b102-a6fec4e09826',0,NULL,'','','{\"displayTitle\":\"Maxillaire 32.2.1.1.12\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0d42f8ae-4e76-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d42f8ae-4e76-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_9d457cf7-2ac5-41fa-ac28-5cc81ee6178a_SESS_234f0eb8-1a1c-45f0-a535-9f2becf0b609_BOSC_dacd7773-dda3-4729-9529-ee2868c579f7_SNAPS_','2020-12-16 10:52:37','2020-02-12 10:10:18','0d42f8ae-4e76-11ea-947d-226cec7cb58a.png','2020-12-16 11:52:37','SYNCED','0d42f8ae-4e76-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0d44a1ab-4e76-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d44a1ab-4e76-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_9d457cf7-2ac5-41fa-ac28-5cc81ee6178a_SESS_234f0eb8-1a1c-45f0-a535-9f2becf0b609_BOSC_dacd7773-dda3-4729-9529-ee2868c579f7_PLY_','2020-12-16 10:52:38','2020-02-12 10:10:18','0d44a1ab-4e76-11ea-947d-226cec7cb58a.ply','2020-12-16 11:52:38','SYNCED','0d44a1ab-4e76-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 84.1.1.1.1\",\"modelMatrix\":\"-0.908043,0.405854,-0.103631,0,-0.418876,-0.879815,0.224653,0,3.82351e-9,0.247403,0.968913,0,-9.2401,22.4077,-15.7005,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0d46ab82-4e76-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d46ab82-4e76-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_9d457cf7-2ac5-41fa-ac28-5cc81ee6178a_SESS_234f0eb8-1a1c-45f0-a535-9f2becf0b609_TOSC_3ae568a6-3131-4cb5-b9ba-74b41651eee5_PLY_','2020-12-16 10:52:38','2020-02-12 11:28:29','0d46ab82-4e76-11ea-947d-226cec7cb58a.ply','2020-12-16 11:52:38','SYNCED','0d46ab82-4e76-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.2\",\"modelMatrix\":\"0.820175,-0.538746,0.192524,0,0.572113,0.772341,-0.276,0,1.42698e-8,0.336514,0.941679,0,6.48031,-31.5564,-17.9281,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0d483fc8-4e76-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d483fc8-4e76-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_ad656f6e-606c-4bea-bd0a-946815fc0836_ACT_9d457cf7-2ac5-41fa-ac28-5cc81ee6178a_SESS_234f0eb8-1a1c-45f0-a535-9f2becf0b609_TOSC_3ae568a6-3131-4cb5-b9ba-74b41651eee5_SNAPS_','2020-12-16 10:52:38','2020-02-12 11:28:29','0d483fc8-4e76-11ea-947d-226cec7cb58a.png','2020-12-16 11:52:38','SYNCED','0d483fc8-4e76-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 84.1.1.1.2\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0d4872cb-d741-433a-970a-013e69a8a6fd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d4872cb-d741-433a-970a-013e69a8a6fd.ply','PLY','PATIENT_a1640bab-46fa-4eed-8e6a-cdfd4aef486a_ACT_ebfbc058-3452-4bfb-b1ab-5e934163bb6d_SESS_af40f930-4869-41d3-adc2-971caf2ed1dc_BOSC_059ac983-fcf3-4641-9fa9-9edd8dba96f6_PLY_','2021-03-17 12:14:31','2021-03-17 13:09:37','0d4872cb-d741-433a-970a-013e69a8a6fd.ply','2021-03-17 13:14:31','SYNCED','0d4872cb-d741-433a-970a-013e69a8a6fd',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.90.1.1\",\"modelMatrix\":\"-0.915757,-0.395499,0.0704957,0,0.401732,-0.901547,0.160697,0,-4.01857e-9,0.175479,0.984483,0,-26.207,7.22177,-13.9148,1\",\"title\":\"Mandibule PLY\"}'),(2,'0d4c0fb4-8d78-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d4c0fb4-8d78-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_d9f6c411-0321-4272-b402-b516867f1fda_ACT_47cfed5c-08e1-41c5-93ff-ff0e772c0daa_SESS_57444529-e756-4af9-90da-3778291a5ec4_BOSC_b1c63000-aa2b-42dd-a3c2-4a51464b6cf4_SNAPS_','2021-03-25 14:40:21','2021-03-25 15:39:59','0d4c0fb4-8d78-11eb-9377-226cec7cb58a.png','2021-03-25 15:40:21','SYNCED','0d4c0fb4-8d78-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.122.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0d508091-8d78-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d508091-8d78-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_d9f6c411-0321-4272-b402-b516867f1fda_ACT_47cfed5c-08e1-41c5-93ff-ff0e772c0daa_SESS_57444529-e756-4af9-90da-3778291a5ec4_TOSC_ea3b87f8-2056-422a-b1b4-88e4419b6c96_SNAPS_','2021-03-25 14:40:22','2021-03-25 15:15:10','0d508091-8d78-11eb-9377-226cec7cb58a.png','2021-03-25 15:40:22','SYNCED','0d508091-8d78-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.122.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0d54c51e-6c4d-4334-99b0-34c2ecdfe5f1','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d54c51e-6c4d-4334-99b0-34c2ecdfe5f1.ply','PLY','PATIENT_ad96d2f7-b54a-42c5-92d8-f2091d8b69d7_ACT_49ae6d20-8b36-477b-9284-1d843860f993_SESS_8414a55f-2681-4546-a350-d22fa70319fb_TOSC_71663bc5-adb0-460f-b655-ffcc0ae82fd6_PLY_','2021-01-25 08:54:05','2021-01-25 09:33:08','0d54c51e-6c4d-4334-99b0-34c2ecdfe5f1.ply','2021-01-25 09:54:05','SYNCED','0d54c51e-6c4d-4334-99b0-34c2ecdfe5f1',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.17.1.1\",\"modelMatrix\":\"0.330127,-0.907211,0.260739,0,0.943937,0.317282,-0.0911892,0,5.69205e-9,0.276225,0.961093,0,1.3718,-27.7283,-19.5586,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0d562ba3-8d78-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d562ba3-8d78-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_d9f6c411-0321-4272-b402-b516867f1fda_ACT_47cfed5c-08e1-41c5-93ff-ff0e772c0daa_SESS_57444529-e756-4af9-90da-3778291a5ec4_TOSC_ea3b87f8-2056-422a-b1b4-88e4419b6c96_PLY_','2021-03-25 14:40:22','2021-03-25 15:15:10','0d562ba3-8d78-11eb-9377-226cec7cb58a.ply','2021-03-25 15:40:22','SYNCED','0d562ba3-8d78-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.122.1.1\",\"modelMatrix\":\"0.588934,-0.748391,0.305069,0,0.808181,0.545364,-0.222309,0,5.21189e-9,0.377477,0.926019,0,2.30443,-30.9981,-16.8054,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0d5834af-8d78-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d5834af-8d78-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_d9f6c411-0321-4272-b402-b516867f1fda_ACT_47cfed5c-08e1-41c5-93ff-ff0e772c0daa_SESS_57444529-e756-4af9-90da-3778291a5ec4_BOSC_567fe46e-c5f5-47e0-9ce9-119ba3b34514_PLY_','2021-03-25 14:40:22','2021-03-25 15:28:09','0d5834af-8d78-11eb-9377-226cec7cb58a.ply','2021-03-25 15:40:22','SYNCED','0d5834af-8d78-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.122.1.1\",\"modelMatrix\":\"0.635546,-0.753972,0.166154,0,0.772063,0.620654,-0.136775,0,2.49673e-9,0.215208,0.976568,0,2.64344,-24.1719,-30.3639,1\",\"title\":\"Mandibule PLY\"}'),(2,'0d586026-c9cd-47b7-a6db-d9da43a5cca0','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d586026-c9cd-47b7-a6db-d9da43a5cca0.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_fd0bdb2f-2db9-4f06-bf93-a57aa8ce8899_SESS_13ee09be-048a-4261-b4bc-5b538cb77095_TOSC_532d6103-c519-43b8-9191-56258bed0631_SNAPS_','2021-05-06 08:54:11','2021-05-06 10:54:09','0d586026-c9cd-47b7-a6db-d9da43a5cca0.png','2021-05-06 10:54:11','SYNCED','011c1cf4-c86d-45a1-880b-d3f612380ddf',1,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.140.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0d5aedb9-8d78-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d5aedb9-8d78-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_d9f6c411-0321-4272-b402-b516867f1fda_ACT_47cfed5c-08e1-41c5-93ff-ff0e772c0daa_SESS_57444529-e756-4af9-90da-3778291a5ec4_TOSC_2d9ff961-ee52-4e0e-a61a-0d137678a1a1_SNAPS_','2021-03-25 14:40:21','2021-03-25 15:20:41','0d5aedb9-8d78-11eb-9377-226cec7cb58a.png','2021-03-25 15:40:21','SYNCED','0d5aedb9-8d78-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.122.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0d5d01ae-8d78-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d5d01ae-8d78-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_d9f6c411-0321-4272-b402-b516867f1fda_ACT_47cfed5c-08e1-41c5-93ff-ff0e772c0daa_SESS_57444529-e756-4af9-90da-3778291a5ec4_BOSC_7108e63c-03b5-4492-94d3-d74cc70d963a_SNAPS_','2021-03-25 14:40:21','2021-03-25 15:37:47','0d5d01ae-8d78-11eb-9377-226cec7cb58a.png','2021-03-25 15:40:21','SYNCED','0d5d01ae-8d78-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.122.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0d5dbf86-47ff-47a1-a38f-5cd36955e21f','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d5dbf86-47ff-47a1-a38f-5cd36955e21f.ply','PLY','PATIENT_bfff99cf-e91f-4eed-bb3a-06bece8eaf9f_ACT_e05ca76e-09b0-4832-915f-5d8f769e2ea5_SESS_540861f8-5ba9-4984-8617-509dd1da3f0e_BOSC_07294597-d031-46fe-b79f-0c2df83c25af_PLY_','2020-12-23 09:08:12','2019-12-18 14:14:40','0d5dbf86-47ff-47a1-a38f-5cd36955e21f.ply','2020-12-23 10:08:12','SYNCED','0d5dbf86-47ff-47a1-a38f-5cd36955e21f',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 20.1.267.1.1.1\",\"modelMatrix\":\"0.56392,-0.825448,0.0250934,0,0.82583,0.563659,-0.0171351,0,-7.50406e-10,0.0303857,0.999538,0,-6.37233,-22.0449,-23.1277,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0d5f4b46-8d78-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d5f4b46-8d78-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_d9f6c411-0321-4272-b402-b516867f1fda_ACT_47cfed5c-08e1-41c5-93ff-ff0e772c0daa_SESS_57444529-e756-4af9-90da-3778291a5ec4_BOSC_7108e63c-03b5-4492-94d3-d74cc70d963a_PLY_','2021-03-25 14:40:23','2021-03-25 15:37:47','0d5f4b46-8d78-11eb-9377-226cec7cb58a.ply','2021-03-25 15:40:23','SYNCED','0d5f4b46-8d78-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.122.1.2\",\"modelMatrix\":\"-0.920588,-0.389019,0.0343823,0,0.390535,-0.917013,0.0810477,0,-1.4865e-9,0.0880391,0.996117,0,-21.2596,4.0317,-19.3147,1\",\"title\":\"Mandibule PLY\"}'),(2,'0d6260f5-8d78-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d6260f5-8d78-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_d9f6c411-0321-4272-b402-b516867f1fda_ACT_47cfed5c-08e1-41c5-93ff-ff0e772c0daa_SESS_57444529-e756-4af9-90da-3778291a5ec4_BOSC_567fe46e-c5f5-47e0-9ce9-119ba3b34514_SNAPS_','2021-03-25 14:40:22','2021-03-25 15:28:09','0d6260f5-8d78-11eb-9377-226cec7cb58a.png','2021-03-25 15:40:22','SYNCED','0d6260f5-8d78-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.122.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0d643a2a-8d78-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d643a2a-8d78-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_d9f6c411-0321-4272-b402-b516867f1fda_ACT_47cfed5c-08e1-41c5-93ff-ff0e772c0daa_SESS_57444529-e756-4af9-90da-3778291a5ec4_TOSC_2d9ff961-ee52-4e0e-a61a-0d137678a1a1_PLY_','2021-03-25 14:40:19','2021-03-25 15:20:41','0d643a2a-8d78-11eb-9377-226cec7cb58a.ply','2021-03-25 15:40:19','SYNCED','0d643a2a-8d78-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.122.1.2\",\"modelMatrix\":\"0.648607,-0.691043,0.319011,0,0.761123,0.588887,-0.271852,0,5.65364e-9,0.419131,0.907926,0,7.24526,-34.059,-21.1526,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0d65ef2c-8d78-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d65ef2c-8d78-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_d9f6c411-0321-4272-b402-b516867f1fda_ACT_47cfed5c-08e1-41c5-93ff-ff0e772c0daa_SESS_57444529-e756-4af9-90da-3778291a5ec4_TOSC_067839b0-9605-4f16-ac5c-496d4d9010a1_PLY_','2021-03-25 14:40:22','2021-03-25 15:25:59','0d65ef2c-8d78-11eb-9377-226cec7cb58a.ply','2021-03-25 15:40:22','SYNCED','0d65ef2c-8d78-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.122.1.3\",\"modelMatrix\":\"0.814818,-0.490334,0.309264,0,0.579717,0.689186,-0.434684,0,-3.81763e-9,0.533474,0.845816,0,10.7019,-35.2458,-17.884,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0d6767b2-8d78-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d6767b2-8d78-11eb-9377-226cec7cb58a.png','SNAPS','PATIENT_d9f6c411-0321-4272-b402-b516867f1fda_ACT_47cfed5c-08e1-41c5-93ff-ff0e772c0daa_SESS_57444529-e756-4af9-90da-3778291a5ec4_TOSC_067839b0-9605-4f16-ac5c-496d4d9010a1_SNAPS_','2021-03-25 14:40:21','2021-03-25 15:25:59','0d6767b2-8d78-11eb-9377-226cec7cb58a.png','2021-03-25 15:40:21','SYNCED','0d6767b2-8d78-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.122.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0d68e2a4-8d78-11eb-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d68e2a4-8d78-11eb-9377-226cec7cb58a.ply','PLY','PATIENT_d9f6c411-0321-4272-b402-b516867f1fda_ACT_47cfed5c-08e1-41c5-93ff-ff0e772c0daa_SESS_57444529-e756-4af9-90da-3778291a5ec4_BOSC_b1c63000-aa2b-42dd-a3c2-4a51464b6cf4_PLY_','2021-03-25 14:40:21','2021-03-25 15:39:59','0d68e2a4-8d78-11eb-9377-226cec7cb58a.ply','2021-03-25 15:40:21','SYNCED','0d68e2a4-8d78-11eb-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.122.1.3\",\"modelMatrix\":\"-0.957492,-0.270625,0.0998523,0,0.288459,-0.898297,0.331443,0,2.61794e-9,0.346158,0.938176,0,-25.3065,6.80019,-18.6343,1\",\"title\":\"Mandibule PLY\"}'),(2,'0d727f2b-a671-4088-a91a-d3e6b99c41e7','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d727f2b-a671-4088-a91a-d3e6b99c41e7.ply','PLY','PATIENT_5a9944f4-654e-4e01-a708-7497ff33665b_ACT_82811e8c-cd38-40ac-9c4c-5312b62ceb9b_SESS_897a08cc-9c18-41d8-9e53-87ad8fe1f2f7_BOSC_d0663c12-251f-40e5-b131-7001a36ff9dd_PLY_','2021-03-29 12:52:31','2021-03-29 14:52:13','0d727f2b-a671-4088-a91a-d3e6b99c41e7.ply','2021-03-29 14:52:31','SYNCED','0d727f2b-a671-4088-a91a-d3e6b99c41e7',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.12.1.3\",\"modelMatrix\":\"-0.944291,-0.327658,0.0308846,0,0.32911,-0.940124,0.0886149,0,1.30675e-9,0.0938427,0.995587,0,-14.254,12.2905,-23.1954,1\",\"title\":\"Mandibule PLY\"}'),(2,'0d759f25-1039-44a8-b7f3-b41cdeff1800','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d759f25-1039-44a8-b7f3-b41cdeff1800.png','SNAPS','PATIENT_0522c88e-62a7-475a-893a-cde27ba3fa42_ACT_be785228-0c33-4320-9598-cbd20dfecbcc_SESS_b66b2c5f-01c4-42c3-a420-73134933934d_BOSC_e36b2e6b-9160-4cf4-90d5-7033154fa205_SNAPS_','2021-03-23 10:02:23','2021-03-23 10:55:41','0d759f25-1039-44a8-b7f3-b41cdeff1800.png','2021-03-23 11:02:23','SYNCED','0d759f25-1039-44a8-b7f3-b41cdeff1800',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.103.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0d76c4e9-7b2b-485b-ab09-63922ad37338','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d76c4e9-7b2b-485b-ab09-63922ad37338.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_54ef530e-fe95-453d-b6ca-fcf4e17dfdf6_SESS_1e5ae9d8-b0b0-4c65-992b-0f2fdad9ac99_BOSC_4533333a-73d6-43bb-8bdb-f2e9dc9a28f3_SNAPS_','2021-04-27 09:46:06','2021-04-27 11:46:03','0d76c4e9-7b2b-485b-ab09-63922ad37338.png','2021-04-27 11:46:06','SYNCED','0d76c4e9-7b2b-485b-ab09-63922ad37338',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.113.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0d84a2bf-7667-4183-9475-6f4997c42acb','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d84a2bf-7667-4183-9475-6f4997c42acb.zip','ZIP','PATIENT_8c33a35d-55aa-40a5-b547-1ce34223d053_ACT_14a18b73-9cb7-4d14-a69a-f71e0a316c16_SESS_aef76ead-c4ff-48ca-9f5f-ac9ca36a1096_TOSC_ae122337-cb43-4e0b-9d8c-c4de149e2ae0_ZIP_','2022-03-31 07:44:51','2022-03-31 09:44:47','0d84a2bf-7667-4183-9475-6f4997c42acb.zip','2022-03-31 09:44:51','SYNCED','0d84a2bf-7667-4183-9475-6f4997c42acb',0,NULL,'','','{\"displayTitle\":\"Maxillaire 19.4.48.1.1\",\"modelMatrix\":\"0.526056,-0.828078,0.193786,0,0.85045,0.512217,-0.119869,0,-2.28597e-09,0.227863,0.973693,0,-4.47624,-34.6888,-14.2237,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'0d9782fb-6c9e-4ed2-96ef-0406fc2605d0','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d9782fb-6c9e-4ed2-96ef-0406fc2605d0.ply','PLY','PATIENT_b9c60833-03cc-4842-8403-95f28716d322_ACT_df542486-b7c1-494f-b480-9858c2859c62_SESS_344a7203-1cfa-4cc9-9e4d-99d317027314_TOSC_42dde97a-3e8e-45b1-bf8c-a2f88d4f7e64_PLY_','2020-12-16 11:08:27','2020-01-15 14:03:36','0d9782fb-6c9e-4ed2-96ef-0406fc2605d0.ply','2020-12-16 12:08:27','SYNCED','0d9782fb-6c9e-4ed2-96ef-0406fc2605d0',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 283.1.1.1.1\",\"modelMatrix\":\"0.240146,-0.922754,0.301422,0,0.970737,0.228276,-0.0745675,0,-1.77078e-9,0.310509,0.95057,0,-9.59377,-36.6954,-16.5549,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0d9f1486-a2e3-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d9f1486-a2e3-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_3f00b0a8-6ea9-4cb3-8a3c-6ca3c492e30a_ACT_aa8c9e80-a350-499c-af49-e74b1d5e8f5a_SESS_aa320683-814c-4fb9-bf2f-98d908e2eef2_TOSC_b8907c0d-eb88-4b68-950c-174cb3b6f98f_PLY_','2022-03-04 13:40:24','2019-07-10 11:23:35','0d9f1486-a2e3-11e9-a33b-226cec7cb58a.ply','2022-03-04 14:40:24','SYNCED','0d9f1486-a2e3-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 24.1.1.1\",\"modelMatrix\":\"0.989387,-0.142183,0.0299455,0,0.145302,0.968148,-0.203904,0,-1.1672e-9,0.206091,0.978533,0,-30.1603,-20.7354,-14.3758,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0d9f6559-6c84-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d9f6559-6c84-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_091298b7-bb6a-4d73-8330-9e1ffb78a173_ACT_a680ea13-c867-4308-a6a0-d698651bfb1f_SESS_0a88b7a3-7330-4b69-af74-1277b49a6cce_TOSC_2a240179-fca4-4e12-a0d0-584ca169137a_SNAPS_','2022-01-03 10:40:02','2022-01-03 11:39:57','0d9f6559-6c84-11ec-9377-226cec7cb58a.png','2022-01-03 11:40:02','SYNCED','0d9f6559-6c84-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.167.3.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0d9fd477-a2e3-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0d9fd477-a2e3-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_3f00b0a8-6ea9-4cb3-8a3c-6ca3c492e30a_ACT_aa8c9e80-a350-499c-af49-e74b1d5e8f5a_SESS_aa320683-814c-4fb9-bf2f-98d908e2eef2_BOSC_aaac2579-3560-4ef2-a4c0-c80d89c272d9_SNAPS_','2022-03-04 13:40:25','2019-07-10 11:26:17','0d9fd477-a2e3-11e9-a33b-226cec7cb58a.png','2022-03-04 14:40:25','SYNCED','0d9fd477-a2e3-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 24.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0da16d6c-a2e3-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0da16d6c-a2e3-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_3f00b0a8-6ea9-4cb3-8a3c-6ca3c492e30a_ACT_aa8c9e80-a350-499c-af49-e74b1d5e8f5a_SESS_aa320683-814c-4fb9-bf2f-98d908e2eef2_TOSC_b8907c0d-eb88-4b68-950c-174cb3b6f98f_STL_','2022-03-04 13:40:25','2019-07-10 11:23:35','0da16d6c-a2e3-11e9-a33b-226cec7cb58a.stl','2022-03-04 14:40:25','SYNCED','0da16d6c-a2e3-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 24.1.1.1\",\"modelMatrix\":\"0.989387,-0.142183,0.0299455,0,0.145302,0.968148,-0.203904,0,-1.1672e-9,0.206091,0.978533,0,-30.1603,-20.7354,-14.3758,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'0da1d5ce-4c88-4dd2-80d5-984b58ef8df2','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0da1d5ce-4c88-4dd2-80d5-984b58ef8df2.png','SNAPS','PATIENT_b3711377-709c-429d-b08e-e681c7c3e606_ACT_7d922001-fb72-45c7-90c1-56e5de670ee0_SESS_7a27facc-239d-4726-a86a-fe5b8c469bbd_BOSC_85505077-b1db-41b4-b930-f1d906312aec_SNAPS_','2021-03-12 10:51:08','2021-03-12 11:50:40','0da1d5ce-4c88-4dd2-80d5-984b58ef8df2.png','2021-03-12 11:51:08','SYNCED','0da1d5ce-4c88-4dd2-80d5-984b58ef8df2',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.4.74.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0da31c2f-a2e3-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0da31c2f-a2e3-11e9-a33b-226cec7cb58a.stl','STL','PATIENT_3f00b0a8-6ea9-4cb3-8a3c-6ca3c492e30a_ACT_aa8c9e80-a350-499c-af49-e74b1d5e8f5a_SESS_aa320683-814c-4fb9-bf2f-98d908e2eef2_BOSC_aaac2579-3560-4ef2-a4c0-c80d89c272d9_STL_','2022-03-04 13:40:25','2019-07-10 11:26:17','0da31c2f-a2e3-11e9-a33b-226cec7cb58a.stl','2022-03-04 14:40:25','SYNCED','0da31c2f-a2e3-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 24.1.1.1\",\"modelMatrix\":\"-0.73338,-0.658398,0.16931,0,0.679819,-0.710271,0.18265,0,-9.67868e-9,0.249052,0.96849,0,13.1017,28.833,-17.587,1\",\"title\":\"MANDIBULE STL\"}'),(2,'0da4b30a-572b-458e-8348-c8c3cdb28d1f','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0da4b30a-572b-458e-8348-c8c3cdb28d1f.zip','ZIP','PATIENT_091298b7-bb6a-4d73-8330-9e1ffb78a173_ACT_882ac909-1de5-40f3-a561-bd180bccb533_SESS_45560b36-916f-4b33-89a9-82459536ff5b_BOSC_d57fcb6d-97ad-4964-a6f0-55ea8da21ef6_ZIP_','2022-01-04 16:31:12','2022-01-04 17:31:10','0da4b30a-572b-458e-8348-c8c3cdb28d1f.zip','2022-01-04 17:31:12','SYNCED','0da4b30a-572b-458e-8348-c8c3cdb28d1f',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.167.6.1.3\",\"modelMatrix\":\"-0.976844,-0.189581,0.0991665,0,0.213951,-0.865578,0.452768,0,8.65686e-10,0.463501,0.886096,0,-27.6137,6.54585,-18.4697,1\",\"title\":\"Mandibule ZIP\"}'),(2,'0da4b31a-a2e3-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0da4b31a-a2e3-11e9-a33b-226cec7cb58a.png','SNAPS','PATIENT_3f00b0a8-6ea9-4cb3-8a3c-6ca3c492e30a_ACT_aa8c9e80-a350-499c-af49-e74b1d5e8f5a_SESS_aa320683-814c-4fb9-bf2f-98d908e2eef2_TOSC_b8907c0d-eb88-4b68-950c-174cb3b6f98f_SNAPS_','2022-03-04 13:40:25','2019-07-10 11:23:35','0da4b31a-a2e3-11e9-a33b-226cec7cb58a.png','2022-03-04 14:40:25','SYNCED','0da4b31a-a2e3-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 24.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0da5075a-6c84-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0da5075a-6c84-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_091298b7-bb6a-4d73-8330-9e1ffb78a173_ACT_a680ea13-c867-4308-a6a0-d698651bfb1f_SESS_0a88b7a3-7330-4b69-af74-1277b49a6cce_BOSC_a941e3aa-e4cf-465a-bc88-a775229f5479_SNAPS_','2022-01-03 10:54:06','2022-01-03 11:53:59','0da5075a-6c84-11ec-9377-226cec7cb58a.png','2022-01-03 11:54:06','SYNCED','0da5075a-6c84-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.167.3.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0da55d90-a2e3-11e9-a33b-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0da55d90-a2e3-11e9-a33b-226cec7cb58a.ply','PLY','PATIENT_3f00b0a8-6ea9-4cb3-8a3c-6ca3c492e30a_ACT_aa8c9e80-a350-499c-af49-e74b1d5e8f5a_SESS_aa320683-814c-4fb9-bf2f-98d908e2eef2_BOSC_aaac2579-3560-4ef2-a4c0-c80d89c272d9_PLY_','2022-03-04 13:40:25','2019-07-10 11:26:17','0da55d90-a2e3-11e9-a33b-226cec7cb58a.ply','2022-03-04 14:40:25','SYNCED','0da55d90-a2e3-11e9-a33b-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 24.1.1.1\",\"modelMatrix\":\"-0.73338,-0.658398,0.16931,0,0.679819,-0.710271,0.18265,0,-9.67868e-9,0.249052,0.96849,0,13.1017,28.833,-17.587,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0da6301a-e976-4718-96d2-92815a88d9b7','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0da6301a-e976-4718-96d2-92815a88d9b7.png','SNAPS','PATIENT_8a7af7e9-9415-4cc6-b6d7-27441f26e70d_ACT_3fd60465-563d-46c3-bd52-7f68d8c51532_SESS_9af36735-7dab-4aa1-843a-5117d8357962_TOSC_beea0a43-0cb7-4e3d-9d8d-df49a009473d_SNAPS_','2021-03-23 11:04:28','2021-03-23 11:46:20','0da6301a-e976-4718-96d2-92815a88d9b7.png','2021-03-23 12:04:28','SYNCED','0da6301a-e976-4718-96d2-92815a88d9b7',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.105.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0da97ae5-8c29-47d1-b476-1dc819c2ad5a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0da97ae5-8c29-47d1-b476-1dc819c2ad5a.png','SNAPS','PATIENT_6023972b-e8b9-49bf-9549-4359624cbf73_ACT_d0e3cbf3-3c30-45f2-a815-a498ea7935eb_SESS_498b8e88-42c8-4a38-bb1f-31e9e8b89a70_BOSC_f4ee1bd8-10c0-4055-b2b1-6cde530699a9_SNAPS_','2021-12-30 18:03:27','2019-10-10 14:40:38','0da97ae5-8c29-47d1-b476-1dc819c2ad5a.png','2021-12-30 19:03:27','SYNCED','0da97ae5-8c29-47d1-b476-1dc819c2ad5a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 185.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0daa39d2-7337-444c-8114-ac2e2da8ce62','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0daa39d2-7337-444c-8114-ac2e2da8ce62.png','SNAPS','PATIENT_844a56d4-ce1d-4576-b80b-3cfdfcd828b1_ACT_e588887c-fab5-4e45-a0ce-eb3bca087d46_SESS_4cc4088c-9112-45cf-aa68-7e78035a3d99_TOSC_cd50cb8e-a9a0-4ae0-a1c9-bd8d6e87eef3_SNAPS_','2021-03-26 13:22:16','2021-03-26 14:06:36','0daa39d2-7337-444c-8114-ac2e2da8ce62.png','2021-03-26 14:22:16','SYNCED','0daa39d2-7337-444c-8114-ac2e2da8ce62',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.3.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0dacc327-6c84-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0dacc327-6c84-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_091298b7-bb6a-4d73-8330-9e1ffb78a173_ACT_a680ea13-c867-4308-a6a0-d698651bfb1f_SESS_0a88b7a3-7330-4b69-af74-1277b49a6cce_BOSC_5e5e6660-95b5-435f-89e2-2c622f20d3bf_ZIP_','2022-01-03 10:57:20','2022-01-03 11:57:17','0dacc327-6c84-11ec-9377-226cec7cb58a.zip','2022-01-03 11:57:20','SYNCED','0dacc327-6c84-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.167.3.1.3\",\"modelMatrix\":\"-0.848176,-0.505106,0.159577,0,0.529714,-0.808774,0.255514,0,7.44849e-9,0.301251,0.953545,0,-18.4565,-3.66933,-27.8301,1\",\"title\":\"Mandibule ZIP\"}'),(2,'0db0848e-6c84-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0db0848e-6c84-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_091298b7-bb6a-4d73-8330-9e1ffb78a173_ACT_a680ea13-c867-4308-a6a0-d698651bfb1f_SESS_0a88b7a3-7330-4b69-af74-1277b49a6cce_BOSC_474cd570-ed3e-4d12-844d-619f6a69311f_ZIP_','2022-01-03 10:42:33','2022-01-03 11:42:31','0db0848e-6c84-11ec-9377-226cec7cb58a.zip','2022-01-03 11:42:33','SYNCED','0db0848e-6c84-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.167.3.1.1\",\"modelMatrix\":\"-0.901618,-0.410586,0.136033,0,0.432534,-0.855867,0.28356,0,5.97204e-9,0.314502,0.949257,0,-21.269,-0.0430619,-18.0928,1\",\"title\":\"Mandibule ZIP\"}'),(2,'0db1079f-d9ed-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0db1079f-d9ed-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_f8f4fd0f-dc97-4b11-9286-86eaf67fb5cb_ACT_bf86aebf-fadb-4a91-a6f6-11f29cebf495_SESS_18d45998-bb23-48fc-abf3-f17f12f8d8b6_BOSC_58e6b3bf-fd55-48a6-bf83-601c93c68e71_PLY_','2022-02-01 11:47:34','2019-09-18 10:18:55','0db1079f-d9ed-11e9-947d-226cec7cb58a.ply','2022-02-01 12:47:34','SYNCED','0db1079f-d9ed-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 150.1.1.1\",\"modelMatrix\":\"0.715123,-0.659481,0.2317,0,0.698999,0.674693,-0.237045,0,2.63167e-9,0.331474,0.943464,0,2.21702,-30.8157,-25.6092,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0db275bb-d9ed-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0db275bb-d9ed-11e9-947d-226cec7cb58a.stl','STL','PATIENT_f8f4fd0f-dc97-4b11-9286-86eaf67fb5cb_ACT_bf86aebf-fadb-4a91-a6f6-11f29cebf495_SESS_18d45998-bb23-48fc-abf3-f17f12f8d8b6_BOSC_58e6b3bf-fd55-48a6-bf83-601c93c68e71_STL_','2022-02-01 11:47:34','2019-09-18 10:18:55','0db275bb-d9ed-11e9-947d-226cec7cb58a.stl','2022-02-01 12:47:34','SYNCED','0db275bb-d9ed-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 150.1.1.1\",\"modelMatrix\":\"0.715123,-0.659481,0.2317,0,0.698999,0.674693,-0.237045,0,2.63167e-9,0.331474,0.943464,0,2.21702,-30.8157,-25.6092,1\",\"title\":\"MANDIBULE STL\"}'),(2,'0db31d27-a3af-4ec5-a653-fd6c15e341b3','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0db31d27-a3af-4ec5-a653-fd6c15e341b3.stl','STL','PATIENT_f6a9d20f-4172-4d39-ba1f-4f41db70ecf7_ACT_fd08bf2b-a80c-4955-aae7-db4757ea760f_SESS_835f8695-828f-44c2-b917-01ed20fcf20f_BOSC_9587fc84-7571-48b4-ae98-413ef6e5f2f5_STL_','2022-02-01 11:47:37','2019-07-30 13:42:54','0db31d27-a3af-4ec5-a653-fd6c15e341b3.stl','2022-02-01 12:47:37','SYNCED','0db31d27-a3af-4ec5-a653-fd6c15e341b3',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 117.1.1.1\",\"modelMatrix\":\"-0.986844,-0.157745,0.0354338,0,0.161676,-0.962851,0.216282,0,3.75321e-9,0.219166,0.975688,0,-20.0397,10.0574,-26.2799,1\",\"title\":\"MANDIBULE STL\"}'),(2,'0db3b350-d9ed-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0db3b350-d9ed-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_f8f4fd0f-dc97-4b11-9286-86eaf67fb5cb_ACT_bf86aebf-fadb-4a91-a6f6-11f29cebf495_SESS_18d45998-bb23-48fc-abf3-f17f12f8d8b6_TOSC_7d394ecf-2eb2-4a7e-8d73-1c89607dd7e7_SNAPS_','2022-02-01 11:47:37','2019-09-18 10:14:22','0db3b350-d9ed-11e9-947d-226cec7cb58a.png','2022-02-01 12:47:37','SYNCED','0db3b350-d9ed-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 150.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0db3f4b9-6282-418a-9f23-608226cfa936','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0db3f4b9-6282-418a-9f23-608226cfa936.ply','PLY','PATIENT_df2eeadd-f92f-4837-9d06-8003b62898b8_ACT_41c458ba-26b5-45af-82c6-dc1d9ea54a57_SESS_d2915c3c-c86f-43cd-9b66-7a8e7598be93_TOSC_ca914dd6-399a-4673-a49a-ac7b2e8396d7_PLY_','2022-02-01 11:47:37','2019-09-02 11:46:47','0db3f4b9-6282-418a-9f23-608226cfa936.ply','2022-02-01 12:47:37','SYNCED','0db3f4b9-6282-418a-9f23-608226cfa936',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 138.1.1.1\",\"modelMatrix\":\"0.70981,-0.626528,0.32192,0,0.704394,0.631346,-0.324395,0,2.07846e-8,0.457018,0.889458,0,4.46835,-37.3103,-20.8687,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0db50b16-d9ed-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0db50b16-d9ed-11e9-947d-226cec7cb58a.png','SNAPS','PATIENT_f8f4fd0f-dc97-4b11-9286-86eaf67fb5cb_ACT_bf86aebf-fadb-4a91-a6f6-11f29cebf495_SESS_18d45998-bb23-48fc-abf3-f17f12f8d8b6_BOSC_58e6b3bf-fd55-48a6-bf83-601c93c68e71_SNAPS_','2022-02-01 11:47:37','2019-09-18 10:18:55','0db50b16-d9ed-11e9-947d-226cec7cb58a.png','2022-02-01 12:47:37','SYNCED','0db50b16-d9ed-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 150.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0db5b52b-5d92-4b6b-bf5a-42b14a2b4fd3','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0db5b52b-5d92-4b6b-bf5a-42b14a2b4fd3.stl','STL','PATIENT_9ba806a1-0d9a-46a5-8143-6e968c07c4dd_ACT_bc4ea83b-5ee8-442e-84a0-72e1000837c7_SESS_44ecada7-6aaf-4e06-ac38-4207e5d32862_TOSC_3f31c016-6a97-47d5-ba87-11e40b101724_STL_','2022-02-01 11:47:38','2019-07-12 08:09:03','0db5b52b-5d92-4b6b-bf5a-42b14a2b4fd3.stl','2022-02-01 12:47:38','SYNCED','0db5b52b-5d92-4b6b-bf5a-42b14a2b4fd3',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 49.1.1.1\",\"modelMatrix\":\"0.696866,-0.704819,0.132693,0,0.717201,0.684836,-0.12893,0,1.6403e-9,0.185014,0.982736,0,0.381334,-25.5514,-14.578,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'0db73d69-6c84-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0db73d69-6c84-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_091298b7-bb6a-4d73-8330-9e1ffb78a173_ACT_a680ea13-c867-4308-a6a0-d698651bfb1f_SESS_0a88b7a3-7330-4b69-af74-1277b49a6cce_TOSC_dabd5896-0bfb-45fe-aa64-a0d42fe36937_ZIP_','2022-01-03 10:29:23','2022-01-03 11:29:17','0db73d69-6c84-11ec-9377-226cec7cb58a.zip','2022-01-03 11:29:23','SYNCED','0db73d69-6c84-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.167.3.1.1\",\"modelMatrix\":\"0.743223,-0.617022,0.258659,0,0.669044,0.685432,-0.287337,0,1.06287e-8,0.38661,0.922243,0,9.5696,-32.6795,-15.8166,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'0db7f073-d9ed-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0db7f073-d9ed-11e9-947d-226cec7cb58a.ply','PLY','PATIENT_f8f4fd0f-dc97-4b11-9286-86eaf67fb5cb_ACT_bf86aebf-fadb-4a91-a6f6-11f29cebf495_SESS_18d45998-bb23-48fc-abf3-f17f12f8d8b6_TOSC_7d394ecf-2eb2-4a7e-8d73-1c89607dd7e7_PLY_','2022-02-01 11:47:38','2019-09-18 10:14:22','0db7f073-d9ed-11e9-947d-226cec7cb58a.ply','2022-02-01 12:47:38','SYNCED','0db7f073-d9ed-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 150.1.1.1\",\"modelMatrix\":\"0.640582,-0.695144,0.326236,0,0.76789,0.579897,-0.27215,0,-6.93149e-9,0.424848,0.905265,0,1.75343,-38.714,-25.9257,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0db95088-d9ed-11e9-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0db95088-d9ed-11e9-947d-226cec7cb58a.stl','STL','PATIENT_f8f4fd0f-dc97-4b11-9286-86eaf67fb5cb_ACT_bf86aebf-fadb-4a91-a6f6-11f29cebf495_SESS_18d45998-bb23-48fc-abf3-f17f12f8d8b6_TOSC_7d394ecf-2eb2-4a7e-8d73-1c89607dd7e7_STL_','2022-02-01 11:47:38','2019-09-18 10:14:22','0db95088-d9ed-11e9-947d-226cec7cb58a.stl','2022-02-01 12:47:38','SYNCED','0db95088-d9ed-11e9-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 150.1.1.1\",\"modelMatrix\":\"0.640582,-0.695144,0.326236,0,0.76789,0.579897,-0.27215,0,-6.93149e-9,0.424848,0.905265,0,1.75343,-38.714,-25.9257,1\",\"title\":\"MAXILLAIRE STL\"}'),(2,'0dbb9fed-2332-40ad-b017-1e71b53d5934','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0dbb9fed-2332-40ad-b017-1e71b53d5934.stl','STL','PATIENT_1fff6898-79c5-4b7a-8ae6-ae2af9a8cbe4_ACT_c988658e-e313-4d11-9672-2c295b7584a6_SESS_db3f12ec-05bf-4d4c-a595-6a4620d49fae_BOSC_4cdf0532-b607-4368-b371-5c49dafc661d_STL_','2022-02-01 11:47:38','2019-09-23 16:42:05','0dbb9fed-2332-40ad-b017-1e71b53d5934.stl','2022-02-01 12:47:38','SYNCED','0dbb9fed-2332-40ad-b017-1e71b53d5934',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 162.1.1.1\",\"modelMatrix\":\"0.611688,0.790406,-0.0331098,0,-0.791099,0.611152,-0.0256009,0,-1.92415e-9,0.0418529,0.999124,0,26.9592,4.88247,-19.4352,1\",\"title\":\"MANDIBULE STL\"}'),(2,'0dbc7ecd-6c84-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0dbc7ecd-6c84-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_091298b7-bb6a-4d73-8330-9e1ffb78a173_ACT_a680ea13-c867-4308-a6a0-d698651bfb1f_SESS_0a88b7a3-7330-4b69-af74-1277b49a6cce_TOSC_dabd5896-0bfb-45fe-aa64-a0d42fe36937_SNAPS_','2022-01-03 10:29:23','2022-01-03 11:29:16','0dbc7ecd-6c84-11ec-9377-226cec7cb58a.png','2022-01-03 11:29:23','SYNCED','0dbc7ecd-6c84-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.167.3.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0dbe0302-d00f-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0dbe0302-d00f-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_3ba502e6-1fd1-40ed-8e72-2db58e8c52bb_ACT_137ba08e-edfd-4201-98c3-5e41aacff6e2_SESS_3c7c4647-9e18-468c-90e5-756bbfe32557_BOSC_cd5e050b-4490-43ec-829f-464baec77175_PLY_','2020-12-07 12:01:33','2020-07-27 15:37:44','0dbe0302-d00f-11ea-947d-226cec7cb58a.ply','2020-12-07 13:01:33','SYNCED','0dbe0302-d00f-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.22.1.1\",\"modelMatrix\":\"-0.819108,-0.558425,0.131243,0,0.57364,-0.797381,0.187404,0,-3.68395e-9,0.22879,0.973476,0,-24.0856,3.32265,-15.9909,1\",\"title\":\"Mandibule PLY\"}'),(2,'0dc09751-d00f-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0dc09751-d00f-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_3ba502e6-1fd1-40ed-8e72-2db58e8c52bb_ACT_137ba08e-edfd-4201-98c3-5e41aacff6e2_SESS_3c7c4647-9e18-468c-90e5-756bbfe32557_TOSC_64615640-5eb1-4123-a6c7-f44425335a86_PLY_','2020-12-07 12:01:34','2020-07-27 15:42:10','0dc09751-d00f-11ea-947d-226cec7cb58a.ply','2020-12-07 13:01:34','SYNCED','0dc09751-d00f-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.22.1.3\",\"modelMatrix\":\"0.484811,-0.827049,0.284514,0,0.874619,0.458442,-0.15771,0,-2.72899e-9,0.325301,0.945611,0,-6.35752,-33.0258,-15.3509,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0dc32fd6-d00f-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0dc32fd6-d00f-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_3ba502e6-1fd1-40ed-8e72-2db58e8c52bb_ACT_137ba08e-edfd-4201-98c3-5e41aacff6e2_SESS_3c7c4647-9e18-468c-90e5-756bbfe32557_BOSC_cd5e050b-4490-43ec-829f-464baec77175_SNAPS_','2020-12-07 12:01:34','2020-07-27 15:37:44','0dc32fd6-d00f-11ea-947d-226cec7cb58a.png','2020-12-07 13:01:34','SYNCED','0dc32fd6-d00f-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.1.22.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0dc3abdc-6c84-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0dc3abdc-6c84-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_091298b7-bb6a-4d73-8330-9e1ffb78a173_ACT_a680ea13-c867-4308-a6a0-d698651bfb1f_SESS_0a88b7a3-7330-4b69-af74-1277b49a6cce_BOSC_474cd570-ed3e-4d12-844d-619f6a69311f_SNAPS_','2022-01-03 10:42:34','2022-01-03 11:42:29','0dc3abdc-6c84-11ec-9377-226cec7cb58a.png','2022-01-03 11:42:34','SYNCED','0dc3abdc-6c84-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.167.3.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0dc50f06-d00f-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0dc50f06-d00f-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_3ba502e6-1fd1-40ed-8e72-2db58e8c52bb_ACT_137ba08e-edfd-4201-98c3-5e41aacff6e2_SESS_3c7c4647-9e18-468c-90e5-756bbfe32557_TOSC_64615640-5eb1-4123-a6c7-f44425335a86_SNAPS_','2020-12-07 12:01:34','2020-07-27 15:42:10','0dc50f06-d00f-11ea-947d-226cec7cb58a.png','2020-12-07 13:01:34','SYNCED','0dc50f06-d00f-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.1.22.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0dc58314-7119-47fc-99fd-8e40a8b12fbf','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0dc58314-7119-47fc-99fd-8e40a8b12fbf.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_7e5aa64e-d017-4a70-970a-fe68db3e7c38_SESS_b9ea5d03-2206-42ef-8da3-4d72a97c7b00_BOSC_cc993d46-686b-4244-889d-69a641b44cc5_SNAPS_','2021-08-31 08:23:42','2021-08-31 10:23:41','0dc58314-7119-47fc-99fd-8e40a8b12fbf.png','2021-08-31 10:23:42','SYNCED','0dc58314-7119-47fc-99fd-8e40a8b12fbf',0,NULL,'','','{\"displayTitle\":\"Mandibule 22.285.189.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0dc830c2-6c84-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0dc830c2-6c84-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_091298b7-bb6a-4d73-8330-9e1ffb78a173_ACT_a680ea13-c867-4308-a6a0-d698651bfb1f_SESS_0a88b7a3-7330-4b69-af74-1277b49a6cce_BOSC_5e5e6660-95b5-435f-89e2-2c622f20d3bf_SNAPS_','2022-01-03 10:57:20','2022-01-03 11:57:15','0dc830c2-6c84-11ec-9377-226cec7cb58a.png','2022-01-03 11:57:20','SYNCED','0dc830c2-6c84-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.167.3.1.3\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0dc99769-b95d-4e31-9c31-1b6f7a989ffd','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0dc99769-b95d-4e31-9c31-1b6f7a989ffd.ply','PLY','PATIENT_bd95859b-c1b1-42d0-857a-6a4fd6c66ed0_ACT_6f160f49-fe13-4288-b351-06a08f50674a_SESS_469d5057-c593-4598-a884-03ebd097449b_TOSC_8bee82a5-1d67-4c58-818e-5d9fb4c8c830_PLY_','2020-12-02 10:32:44','2020-11-16 10:58:08','0dc99769-b95d-4e31-9c31-1b6f7a989ffd.ply','2020-12-02 11:32:44','SYNCED','0dc99769-b95d-4e31-9c31-1b6f7a989ffd',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.36.23.1.1\",\"modelMatrix\":\"0.63888,-0.722915,0.263108,0,0.769307,0.600354,-0.218501,0,-2.09293e-8,0.342007,0.939697,0,2.68969,-27.0881,-17.3771,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0dcccf6f-6c84-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0dcccf6f-6c84-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_091298b7-bb6a-4d73-8330-9e1ffb78a173_ACT_a680ea13-c867-4308-a6a0-d698651bfb1f_SESS_0a88b7a3-7330-4b69-af74-1277b49a6cce_TOSC_2608f712-1715-4f5c-a6aa-631160f5f590_ZIP_','2022-01-03 10:36:55','2022-01-03 11:36:52','0dcccf6f-6c84-11ec-9377-226cec7cb58a.zip','2022-01-03 11:36:55','SYNCED','0dcccf6f-6c84-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.167.3.1.2\",\"modelMatrix\":\"0.549512,-0.806933,0.216552,0,0.835486,0.530733,-0.14243,0,7.32308e-9,0.259193,0.965826,0,-4.01938,-37.6652,-15.8632,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'0dd17c7c-6c84-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0dd17c7c-6c84-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_091298b7-bb6a-4d73-8330-9e1ffb78a173_ACT_a680ea13-c867-4308-a6a0-d698651bfb1f_SESS_0a88b7a3-7330-4b69-af74-1277b49a6cce_BOSC_a941e3aa-e4cf-465a-bc88-a775229f5479_ZIP_','2022-01-03 10:54:06','2022-01-03 11:54:00','0dd17c7c-6c84-11ec-9377-226cec7cb58a.zip','2022-01-03 11:54:06','SYNCED','0dd17c7c-6c84-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 1.167.3.1.2\",\"modelMatrix\":\"-0.940462,-0.321024,0.111687,0,0.339898,-0.888241,0.309026,0,5.16176e-9,0.32859,0.944473,0,-25.0679,1.71468,-16.2157,1\",\"title\":\"Mandibule ZIP\"}'),(2,'0dd59c25-6c84-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0dd59c25-6c84-11ec-9377-226cec7cb58a.zip','ZIP','PATIENT_091298b7-bb6a-4d73-8330-9e1ffb78a173_ACT_a680ea13-c867-4308-a6a0-d698651bfb1f_SESS_0a88b7a3-7330-4b69-af74-1277b49a6cce_TOSC_2a240179-fca4-4e12-a0d0-584ca169137a_ZIP_','2022-01-03 10:40:01','2022-01-03 11:39:59','0dd59c25-6c84-11ec-9377-226cec7cb58a.zip','2022-01-03 11:40:01','SYNCED','0dd59c25-6c84-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.167.3.1.3\",\"modelMatrix\":\"0.816227,-0.516203,0.259437,0,0.577731,0.729299,-0.366537,0,-6.76401e-9,0.449062,0.8935,0,10.301,-36.4282,-12.5322,1\",\"title\":\"Maxillaire ZIP\"}'),(2,'0dd6ccc7-1a97-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0dd6ccc7-1a97-11eb-94ee-226cec7cb58a.png','SNAPS','PATIENT_2e0a8247-f698-45b5-87fe-8b1e7c952f36_ACT_a433fe53-88db-42f4-8f67-6c6d2488c283_SESS_cfc8f487-d196-4456-8530-e036a0501e0b_BOSC_951e2bbd-dd8c-49b1-99da-a46aaf4f0b7e_SNAPS_','2020-12-02 10:32:44','2020-10-30 10:59:30','0dd6ccc7-1a97-11eb-94ee-226cec7cb58a.png','2020-12-02 11:32:44','SYNCED','0dd6ccc7-1a97-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.35.12.1.1\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0dd6e85e-1b20-407e-b7bb-7616279f3be5','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0dd6e85e-1b20-407e-b7bb-7616279f3be5.ply','PLY','PATIENT_4887c403-6684-431d-9efd-4230d74f9f6e_ACT_b67be1ff-ec7d-4035-9281-b8e4b218da86_SESS_1c9989e2-d42d-4cab-80e3-b783c63d8a22_BOSC_018e2213-672e-4d3a-b803-426a6ae54b82_PLY_','2021-12-30 18:03:29','2019-10-10 14:24:13','0dd6e85e-1b20-407e-b7bb-7616279f3be5.ply','2021-12-30 19:03:29','SYNCED','0dd6e85e-1b20-407e-b7bb-7616279f3be5',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 184.1.1.1\",\"modelMatrix\":\"0.966458,-0.256743,0.00650652,0,0.256826,0.966148,-0.0244846,0,-2.09839e-10,0.0253344,0.999679,0,9.6621,-23.4411,-23.1822,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0dd7de3f-1a97-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0dd7de3f-1a97-11eb-94ee-226cec7cb58a.ply','PLY','PATIENT_2e0a8247-f698-45b5-87fe-8b1e7c952f36_ACT_a433fe53-88db-42f4-8f67-6c6d2488c283_SESS_cfc8f487-d196-4456-8530-e036a0501e0b_BOSC_951e2bbd-dd8c-49b1-99da-a46aaf4f0b7e_PLY_','2020-12-02 10:32:44','2020-10-30 10:59:30','0dd7de3f-1a97-11eb-94ee-226cec7cb58a.ply','2020-12-02 11:32:44','SYNCED','0dd7de3f-1a97-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Mandibule 216.35.12.1.1\",\"modelMatrix\":\"-0.886539,-0.45159,0.100579,0,0.462655,-0.865336,0.19273,0,-2.16491e-9,0.217396,0.976083,0,-20.7419,7.06822,-17.4796,1\",\"title\":\"Mandibule PLY\"}'),(2,'0dd8e11e-1a97-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0dd8e11e-1a97-11eb-94ee-226cec7cb58a.png','SNAPS','PATIENT_2e0a8247-f698-45b5-87fe-8b1e7c952f36_ACT_a433fe53-88db-42f4-8f67-6c6d2488c283_SESS_cfc8f487-d196-4456-8530-e036a0501e0b_TOSC_0f74bc4c-51ff-4903-8d4f-a4fcb80593af_SNAPS_','2020-12-02 10:32:44','2020-10-30 10:52:20','0dd8e11e-1a97-11eb-94ee-226cec7cb58a.png','2020-12-02 11:32:44','SYNCED','0dd8e11e-1a97-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.35.12.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0dd9cac1-1a97-11eb-94ee-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0dd9cac1-1a97-11eb-94ee-226cec7cb58a.ply','PLY','PATIENT_2e0a8247-f698-45b5-87fe-8b1e7c952f36_ACT_a433fe53-88db-42f4-8f67-6c6d2488c283_SESS_cfc8f487-d196-4456-8530-e036a0501e0b_TOSC_0f74bc4c-51ff-4903-8d4f-a4fcb80593af_PLY_','2020-12-02 10:32:44','2020-10-30 10:52:20','0dd9cac1-1a97-11eb-94ee-226cec7cb58a.ply','2020-12-02 11:32:44','SYNCED','0dd9cac1-1a97-11eb-94ee-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.35.12.1.1\",\"modelMatrix\":\"0.563209,-0.787186,0.251265,0,0.826314,0.53654,-0.17126,0,1.39769e-8,0.304079,0.952647,0,-2.88985,-32.174,-15.6929,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0ddb46fe-6c84-11ec-9377-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0ddb46fe-6c84-11ec-9377-226cec7cb58a.png','SNAPS','PATIENT_091298b7-bb6a-4d73-8330-9e1ffb78a173_ACT_a680ea13-c867-4308-a6a0-d698651bfb1f_SESS_0a88b7a3-7330-4b69-af74-1277b49a6cce_TOSC_2608f712-1715-4f5c-a6aa-631160f5f590_SNAPS_','2022-01-03 10:36:55','2022-01-03 11:36:51','0ddb46fe-6c84-11ec-9377-226cec7cb58a.png','2022-01-03 11:36:55','SYNCED','0ddb46fe-6c84-11ec-9377-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"Maxillaire 1.167.3.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0ddc3db4-f55f-48fb-bc9f-43ba0c4dbe02','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0ddc3db4-f55f-48fb-bc9f-43ba0c4dbe02.png','SNAPS','PATIENT_0b5de579-3f91-4581-addb-73887c84b27a_ACT_11101b3c-2101-42ce-97c5-aec79796db62_SESS_0855b14f-76dd-4f90-a794-b6e424964bfb_BOSC_135cda03-b49f-42f5-ad0e-df63245cf7d6_SNAPS_','2021-04-07 12:43:02','2021-04-07 14:43:00','0ddc3db4-f55f-48fb-bc9f-43ba0c4dbe02.png','2021-04-07 14:43:02','SYNCED','0ddc3db4-f55f-48fb-bc9f-43ba0c4dbe02',0,NULL,'','','{\"displayTitle\":\"Mandibule 19.3.16.1.2\",\"title\":\"Mandibule SNAPSHOT\"}'),(2,'0de730a2-37dc-4f05-8843-39b891ee9994','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0de730a2-37dc-4f05-8843-39b891ee9994.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_e899bc89-3270-4f29-85e6-a160d0d9d996_SESS_f3aa85b1-36a4-4c08-abe2-f44efd5e960f_TOSC_34e4cf9c-4de8-43b8-8f9a-5fc48c8bb1be_SNAPS_','2021-04-27 13:14:05','2021-04-27 15:14:00','0de730a2-37dc-4f05-8843-39b891ee9994.png','2021-04-27 15:14:05','SYNCED','0de730a2-37dc-4f05-8843-39b891ee9994',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.285.117.1.3\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0ded1866-ccf4-4adf-bca5-316b66343669','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0ded1866-ccf4-4adf-bca5-316b66343669.png','SNAPS','PATIENT_5330dd1f-3329-4ca9-b4fc-f22e9e796047_ACT_92f17ffb-bcaa-4227-bb23-49cd86e54dcb_SESS_73bdae7a-93a5-4cad-8b83-0a6a0814956f_TOSC_9750d5bb-c807-4c86-b82c-14ec1bf843b2_SNAPS_','2020-12-10 10:17:29','2020-12-10 10:58:49','0ded1866-ccf4-4adf-bca5-316b66343669.png','2020-12-10 11:17:29','SYNCED','0ded1866-ccf4-4adf-bca5-316b66343669',0,NULL,'','','{\"displayTitle\":\"Maxillaire 216.36.28.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}'),(2,'0dee422a-37de-4350-b7e8-7f4352faf457','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0dee422a-37de-4350-b7e8-7f4352faf457.ply','PLY','PATIENT_e065ef95-3928-430d-bee5-6cc04ce694eb_ACT_4d118306-492d-4727-87bf-74a9d19317de_SESS_62f1a275-1afa-4623-aeec-92fbff22729b_TOSC_c75a0671-327e-4e83-8374-3546f307a74a_PLY_','2020-12-07 12:01:34','2020-08-19 11:03:09','0dee422a-37de-4350-b7e8-7f4352faf457.ply','2020-12-07 13:01:34','SYNCED','0dee422a-37de-4350-b7e8-7f4352faf457',0,NULL,'','','{\"displayTitle\":\"Maxillaire 61.1.6.1.1\",\"modelMatrix\":\"0.743932,-0.626469,0.2326,0,0.668256,0.697412,-0.25894,0,9.46462e-9,0.34807,0.937468,0,11.0968,-38.3249,-16.1761,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0df27ac7-219b-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0df27ac7-219b-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_d9860777-a354-46c2-bb39-b2f150617cc7_ACT_007fc3da-8408-4668-b268-90b0cc4e0512_SESS_e5c0ff5f-1b35-473b-bb5b-6a699181486e_BOSC_e2acb957-0e34-46cc-88b6-368e2a1956df_PLY_','2020-12-23 09:08:17','2019-12-18 14:32:59','0df27ac7-219b-11ea-947d-226cec7cb58a.ply','2020-12-23 10:08:17','SYNCED','0df27ac7-219b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 21.1.268.1.1.1\",\"modelMatrix\":\"-0.223239,0.966774,-0.124547,0,-0.974764,-0.221409,0.0285235,0,-3.13958e-10,0.127771,0.991804,0,11.8882,16.7578,-23.1337,1\",\"title\":\"MANDIBULE PLY\"}'),(2,'0df3e066-219b-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0df3e066-219b-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_d9860777-a354-46c2-bb39-b2f150617cc7_ACT_007fc3da-8408-4668-b268-90b0cc4e0512_SESS_e5c0ff5f-1b35-473b-bb5b-6a699181486e_TOSC_74751b16-e67c-476c-874e-887f4154a58b_SNAPS_','2020-12-23 09:08:18','2019-12-18 14:28:39','0df3e066-219b-11ea-947d-226cec7cb58a.png','2020-12-23 10:08:18','SYNCED','0df3e066-219b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 21.1.268.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}'),(2,'0df54426-219b-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0df54426-219b-11ea-947d-226cec7cb58a.ply','PLY','PATIENT_d9860777-a354-46c2-bb39-b2f150617cc7_ACT_007fc3da-8408-4668-b268-90b0cc4e0512_SESS_e5c0ff5f-1b35-473b-bb5b-6a699181486e_TOSC_74751b16-e67c-476c-874e-887f4154a58b_PLY_','2020-12-23 09:08:18','2019-12-18 14:28:39','0df54426-219b-11ea-947d-226cec7cb58a.ply','2020-12-23 10:08:18','SYNCED','0df54426-219b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MAXILLAIRE 21.1.268.1.1.1\",\"modelMatrix\":\"0.156134,-0.943399,0.292611,0,0.987736,0.149126,-0.0462539,0,2.00489e-10,0.296244,0.955112,0,-13.7304,-31.3358,-15.5915,1\",\"title\":\"MAXILLAIRE PLY\"}'),(2,'0df67462-219b-11ea-947d-226cec7cb58a','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0df67462-219b-11ea-947d-226cec7cb58a.png','SNAPS','PATIENT_d9860777-a354-46c2-bb39-b2f150617cc7_ACT_007fc3da-8408-4668-b268-90b0cc4e0512_SESS_e5c0ff5f-1b35-473b-bb5b-6a699181486e_BOSC_e2acb957-0e34-46cc-88b6-368e2a1956df_SNAPS_','2020-12-23 09:08:18','2019-12-18 14:32:59','0df67462-219b-11ea-947d-226cec7cb58a.png','2020-12-23 10:08:18','SYNCED','0df67462-219b-11ea-947d-226cec7cb58a',0,NULL,'','','{\"displayTitle\":\"MANDIBULE 21.1.268.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}'),(2,'0dfc3aac-9604-4486-85f4-78354a9ac6e8','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0dfc3aac-9604-4486-85f4-78354a9ac6e8.ply','PLY','PATIENT_70c21a68-0fb8-4c41-aaa8-1f113915d411_ACT_7a7a64b9-8758-48cf-be7d-a5d9c006959f_SESS_a89a9293-a5b7-4d7a-93d7-582bf612fd14_TOSC_43e2a752-8127-4215-8328-c6684a7000ec_PLY_','2021-02-19 09:54:18','2021-02-19 10:33:18','0dfc3aac-9604-4486-85f4-78354a9ac6e8.ply','2021-02-19 10:54:18','SYNCED','0dfc3aac-9604-4486-85f4-78354a9ac6e8',0,NULL,'','','{\"displayTitle\":\"Maxillaire 22.4.49.1.2\",\"modelMatrix\":\"0.409847,-0.893014,0.185881,0,0.912154,0.401246,-0.0835193,0,3.75326e-9,0.203782,0.979016,0,-5.8882,-25.8756,-30.3903,1\",\"title\":\"Maxillaire PLY\"}'),(2,'0e054e1e-8212-456a-951a-d37d62b7d0ba','/var/.data/2022/bf19c334-c71b-4e23-9ce0-73ddec5fe103/discussion_a16198e0-da2f-45fe-97fb-93531b35cedb/0e054e1e-8212-456a-951a-d37d62b7d0ba.png','SNAPS','PATIENT_4e70164b-f81a-4b47-ab32-8092bdc20518_ACT_a8f22c3