-- MySQL dump 10.13  Distrib 8.0.28, for Linux (x86_64)
--
-- Host: localhost    Database: condor_patient_local
-- ------------------------------------------------------
-- Server version	8.0.28-0ubuntu0.20.04.3

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `AddressInfo`
--

DROP TABLE IF EXISTS `AddressInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AddressInfo` (
  `id` varchar(36) NOT NULL,
  `line_0` varchar(255) DEFAULT NULL,
  `line_1` varchar(255) DEFAULT NULL,
  `line_2` varchar(255) DEFAULT NULL,
  `detail` varchar(255) DEFAULT NULL,
  `cityName` varchar(255) DEFAULT NULL,
  `cityState` varchar(255) DEFAULT NULL,
  `cityZip` varchar(25) DEFAULT NULL,
  `countryName` varchar(255) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AddressInfo`
--

LOCK TABLES `AddressInfo` WRITE;
/*!40000 ALTER TABLE `AddressInfo` DISABLE KEYS */;
INSERT INTO `AddressInfo` VALUES ('0048e574-a71a-48c8-b0ae-cd25ad393832','','','',NULL,'','','','',NULL,NULL,'2022-03-31 10:08:27'),('05198e19-8a83-443e-a550-41a2585c9129','','','',NULL,'','','','',NULL,NULL,'2020-11-23 20:30:27'),('09e3cdd1-7bde-4878-b768-eeb5c9741ec6','','','',NULL,'','','','',NULL,NULL,'2020-11-23 20:30:27'),('27bf871f-da55-41b0-b97d-459f0bc52e18','','','',NULL,'','','','',NULL,NULL,'2020-11-23 20:30:27'),('2ab7394e-71b6-4c6c-9ac6-010471414b12','','','',NULL,'','','','',NULL,NULL,'2020-11-23 20:30:27'),('4a80c625-cc75-45e5-80fa-b144f91aaaeb','','','',NULL,'','','','',NULL,NULL,'2020-11-23 20:30:27'),('5c3ec428-da27-4b31-99fd-150541336715','','','',NULL,'','','','',NULL,NULL,'2020-11-23 20:30:27'),('69ed49df-6a3e-47d0-8897-889f9f47e572','','','',NULL,'','','','',NULL,NULL,'2020-11-23 20:30:27'),('6dd7ea1e-5563-4ba9-91bd-5f87ef994dcd','','','',NULL,'','','','',NULL,NULL,'2020-11-23 20:30:27'),('8177ac6b-58de-4c61-a181-412a112e3197','','','',NULL,'','','','',NULL,NULL,'2020-11-23 20:30:27'),('887a0f81-7eb8-4185-8213-a203a96837a0','','','',NULL,'','','','',NULL,NULL,'2020-11-23 20:30:27'),('9edf1713-c86b-4aa3-ac50-4e07f11417ed','','','',NULL,'','','','',NULL,NULL,'2022-04-05 09:18:15'),('b83b20cc-c669-4add-be9d-83158a100f30','','','',NULL,'','','','',NULL,NULL,'2020-11-23 20:30:27'),('c4d500ff-e87b-4d44-9099-6e14599c6820','','','',NULL,'','','','',NULL,NULL,'2020-11-23 20:30:27'),('c7ee110c-5135-4f6e-8363-c165b78994ca','','','',NULL,'','','','',NULL,NULL,'2022-03-31 10:08:27'),('ddac58cf-4ca2-47aa-b6a3-5ba8dc9998ff','','','',NULL,'','','','',NULL,NULL,'2020-11-23 20:30:27'),('e07e7eb9-a850-4b77-8671-066c4ae3d5d9','','','',NULL,'','','','',NULL,NULL,'2022-04-05 08:18:20'),('e347c48b-734e-4f24-8af3-affa5d294f14','','','',NULL,'','','','',NULL,NULL,'2022-04-05 08:18:20');
/*!40000 ALTER TABLE `AddressInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `DownloadRequest`
--

DROP TABLE IF EXISTS `DownloadRequest`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DownloadRequest` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `patientID` char(36) NOT NULL,
  `createdAt` datetime NOT NULL,
  `sentAt` datetime DEFAULT NULL,
  `token` char(40) DEFAULT NULL,
  `locale` char(5) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_DownloadRequest_Patient` (`patientID`),
  CONSTRAINT `fk_DownloadRequest_Patient` FOREIGN KEY (`patientID`) REFERENCES `Patient` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DownloadRequest`
--

LOCK TABLES `DownloadRequest` WRITE;
/*!40000 ALTER TABLE `DownloadRequest` DISABLE KEYS */;
/*!40000 ALTER TABLE `DownloadRequest` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `EmergencyContact`
--

DROP TABLE IF EXISTS `EmergencyContact`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `EmergencyContact` (
  `id` varchar(36) NOT NULL,
  `personInfoID` varchar(36) DEFAULT NULL,
  `phoneInfoID` varchar(36) DEFAULT NULL,
  `addressInfoID` varchar(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_EmergencyContact_AddressInfo` (`addressInfoID`),
  KEY `fk_EmergencyContact_PersonInfo` (`personInfoID`),
  KEY `fk_EmergencyContact_PhoneInfo` (`phoneInfoID`),
  CONSTRAINT `fk_EmergencyContact_AddressInfo` FOREIGN KEY (`addressInfoID`) REFERENCES `AddressInfo` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_EmergencyContact_PersonInfo` FOREIGN KEY (`personInfoID`) REFERENCES `PersonInfo` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_EmergencyContact_PhoneInfo` FOREIGN KEY (`phoneInfoID`) REFERENCES `PhoneInfo` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `EmergencyContact`
--

LOCK TABLES `EmergencyContact` WRITE;
/*!40000 ALTER TABLE `EmergencyContact` DISABLE KEYS */;
INSERT INTO `EmergencyContact` VALUES ('0406896a-2bd3-4d4c-9cdf-966d48afe314','cc198ecb-e84a-4987-9bdf-74b0a293772b','43538f61-1c21-4041-ba68-70de8be99041','6dd7ea1e-5563-4ba9-91bd-5f87ef994dcd',NULL,NULL,'2020-11-23 20:30:27'),('04c19fe9-da20-4892-a686-92f9cee9aa45','6d9a09a1-275a-4945-b573-36dc268dd45c','96fe6f37-f2c3-4097-828b-218b8a3934ab','ddac58cf-4ca2-47aa-b6a3-5ba8dc9998ff',NULL,NULL,'2020-11-23 20:30:27'),('2778e28b-c00b-4b95-a002-9ea7b6e6eb66','eab57af5-c8ac-4a8f-b214-4d4e09e56ac9','810916ef-bc9c-4c74-bff6-2631ce9c275f','09e3cdd1-7bde-4878-b768-eeb5c9741ec6',NULL,NULL,'2020-11-23 20:30:27'),('354f982c-259f-490a-9920-bb686f68e243','05e26e72-1f3e-439d-a15f-b05c43e07b2a','77783e07-d004-469b-b1fc-00470809c585','0048e574-a71a-48c8-b0ae-cd25ad393832',NULL,NULL,'2022-03-31 10:08:27'),('36a2ebc1-c9f8-41ee-9a2e-dadc6ae9af25','fb1feed1-46d1-4401-95fe-3ff178164f1a','a3cc1f1a-9d04-4fe3-9215-cae48f75535f','c4d500ff-e87b-4d44-9099-6e14599c6820',NULL,NULL,'2020-11-23 20:30:27'),('3c513808-097c-4ed4-9918-ea8c714002aa','dcc20268-7483-4728-a9a5-7d1aeae81f66','32bb3f26-1f0b-4d0d-bb32-a06a0dcde843','5c3ec428-da27-4b31-99fd-150541336715',NULL,NULL,'2020-11-23 20:30:27'),('784deec6-0923-4a8a-b399-8eefb6733b67','3bb6f23f-fafd-457e-9130-e42adb630c88','96a35f4a-c18b-45c3-ab46-3449fce9a466','e07e7eb9-a850-4b77-8671-066c4ae3d5d9',NULL,NULL,'2022-04-05 08:18:20'),('ac4a2020-5e0c-4ff8-a8c3-8f85bf3941b9','da7bb693-e18d-46bc-aea1-4bb0a6c16336','368a32e1-e3e0-4dfe-b1f1-6a69895bfe43','05198e19-8a83-443e-a550-41a2585c9129',NULL,NULL,'2020-11-23 20:30:27'),('c8526fdf-7ff4-48a4-89b5-e14884ba4b83','b6e069d3-a8af-4fa5-8d39-32f6b51dfd1d','e2ab861e-5233-4b82-913f-f62e63da9160','8177ac6b-58de-4c61-a181-412a112e3197',NULL,NULL,'2020-11-23 20:30:27');
/*!40000 ALTER TABLE `EmergencyContact` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `EmergencyContact_AFTER_DELETE` AFTER DELETE ON `EmergencyContact` FOR EACH ROW BEGIN
	DELETE FROM PersonInfo 	WHERE id = OLD.personInfoID;
	DELETE FROM AddressInfo	WHERE id = OLD.addressInfoID;
	DELETE FROM PhoneInfo   WHERE id = OLD.phoneInfoID;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `Patient`
--

DROP TABLE IF EXISTS `Patient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Patient` (
  `id` varchar(36) NOT NULL,
  `globalDisplayID` mediumint unsigned DEFAULT NULL,
  `displayID` mediumint unsigned DEFAULT NULL,
  `socialSecurity` varchar(255) DEFAULT NULL,
  `allergies` varchar(255) DEFAULT NULL,
  `personInfoID` varchar(36) DEFAULT NULL,
  `phoneInfoID` varchar(36) DEFAULT NULL,
  `addressInfoID` varchar(36) DEFAULT NULL,
  `emergencyContactID` varchar(36) DEFAULT NULL,
  `practitionerID` varchar(36) DEFAULT NULL,
  `comments` text,
  `privateComments` text,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_Patient_AddressInfo` (`addressInfoID`),
  KEY `fk_Patient_EmergencyContact` (`emergencyContactID`),
  KEY `fk_Patient_PersonInfo` (`personInfoID`),
  KEY `fk_Patient_PhoneInfo` (`phoneInfoID`),
  KEY `fk_Patient_Practitioner` (`practitionerID`),
  CONSTRAINT `fk_Patient_AddressInfo` FOREIGN KEY (`addressInfoID`) REFERENCES `AddressInfo` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Patient_EmergencyContact` FOREIGN KEY (`emergencyContactID`) REFERENCES `EmergencyContact` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Patient_PersonInfo` FOREIGN KEY (`personInfoID`) REFERENCES `PersonInfo` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Patient_PhoneInfo` FOREIGN KEY (`phoneInfoID`) REFERENCES `PhoneInfo` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Patient_Practitioner` FOREIGN KEY (`practitionerID`) REFERENCES `Practitioner` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Patient`
--

LOCK TABLES `Patient` WRITE;
/*!40000 ALTER TABLE `Patient` DISABLE KEYS */;
INSERT INTO `Patient` VALUES ('0cc4ef86-2202-4a20-b6c2-a4a99611d672',88,2,'','','09f2bc00-c293-4f84-9da4-324cc3000252','6ae34c21-5c09-481c-b7bf-d5f78d3634fc','b83b20cc-c669-4add-be9d-83158a100f30','0406896a-2bd3-4d4c-9cdf-966d48afe314','dbe5c7cd-d15d-47bb-bb8d-49143aeccba7','','',NULL,NULL,NULL,'2020-11-23 21:30:26','2020-11-23 20:30:26','2020-06-26 15:32:20'),('286e820b-c75e-4ab1-a5c5-0a716fb62e78',95,1,'','','2b0ce43c-7779-4b0f-a446-001942a029fd','a27ed5c0-a1fd-4256-a6ae-1231269fafc6','887a0f81-7eb8-4185-8213-a203a96837a0','ac4a2020-5e0c-4ff8-a8c3-8f85bf3941b9','34e53b09-8430-4100-84d7-a96a2cd148c5','','',NULL,NULL,NULL,'2020-11-23 21:30:26','2020-11-23 20:30:26','2020-02-18 10:58:36'),('30695c57-b893-4c06-be26-eb761ef06616',1,102,'','','7aaf615e-8f13-4f7b-afe5-c3b4ad62dc5f','43817876-5dac-44a3-8825-122cce03381c','2ab7394e-71b6-4c6c-9ac6-010471414b12','2778e28b-c00b-4b95-a002-9ea7b6e6eb66','4e1798dd-727e-4f60-a59c-82112f82640d','','',NULL,NULL,NULL,'2020-11-23 21:30:26','2020-11-23 20:30:26','2020-10-27 17:08:10'),('4ddddcc8-b2a0-446f-933f-caa8be0ea01f',216,1,'','','01344b75-49da-4edb-bc23-937ffe0727aa','ad980d56-6742-4f14-8c69-293f5092ee11','69ed49df-6a3e-47d0-8897-889f9f47e572','c8526fdf-7ff4-48a4-89b5-e14884ba4b83','de3cd5e5-cdad-4ee9-9d49-d2c8ad0985a8','','',NULL,NULL,NULL,'2020-11-23 21:30:26','2020-11-23 20:30:26','2020-05-20 11:19:53'),('50411908-995c-4509-9e4d-47723232060a',61,7,'','','474d4c0c-d4df-4372-a446-e723e1135579','26cbcb7d-4865-4cfd-9d2b-26356f8eb72b','27bf871f-da55-41b0-b97d-459f0bc52e18','04c19fe9-da20-4892-a686-92f9cee9aa45','a4f1091c-9387-4f9f-ad38-adec673a4dd5','','',NULL,NULL,NULL,'2020-11-23 21:30:26','2020-11-23 20:30:26','2020-10-13 16:52:44'),('55452abe-c899-4508-a6ad-a6862da81096',32,1,'','','c638881b-e2ab-4d2a-b23d-1203ce2e56ce','c3d52a09-9117-4c5e-a89b-692d06b5ba33','9edf1713-c86b-4aa3-ac50-4e07f11417ed','36a2ebc1-c9f8-41ee-9a2e-dadc6ae9af25','41485be4-ff80-41bd-aa81-fbbd3f74f061','','',NULL,NULL,NULL,'2022-04-05 11:18:15','2022-04-05 09:18:15','2022-04-05 11:18:15'),('5b3365d0-2ad4-4d78-9c7c-89ff37d5905d',32,2,'','','ea003f63-a428-4e3b-aef8-07d2df4bf4c9','bc3bbf92-20b4-487d-8337-6be51f6ca3e7','4a80c625-cc75-45e5-80fa-b144f91aaaeb','3c513808-097c-4ed4-9918-ea8c714002aa','f197d640-4bdc-4959-89e8-5dc9487d4878','','',NULL,NULL,NULL,'2020-11-23 21:30:26','2020-11-23 20:30:26','2020-06-19 08:51:56'),('73b2fec8-e730-4e3a-b806-9461f222222e',456,3,'','','8a2ee592-b868-4e04-9d45-49faa2a0ac68','9a32f42a-aab3-4bd0-bf3d-b5c226ac1c1b','c7ee110c-5135-4f6e-8363-c165b78994ca','354f982c-259f-490a-9920-bb686f68e243','2fd193fd-92c5-4254-b9de-3782e058b7e3','','',NULL,NULL,NULL,'2022-03-31 12:08:27','2022-03-31 10:08:27','2022-03-31 12:08:27'),('d4923384-c197-410d-990a-1fa1d8bbbaa1',456,103,'','','d1167c85-56bf-4fd6-829f-16992693f39e','5e2cf781-a7f9-4114-a897-b394b2dc8dab','e347c48b-734e-4f24-8af3-affa5d294f14','784deec6-0923-4a8a-b399-8eefb6733b67','39313d8e-70d2-4843-bb9c-93f70b1afa81','','',NULL,NULL,'2022-04-05 10:23:08',NULL,'2022-04-05 08:23:08','2022-04-05 10:18:20');
/*!40000 ALTER TABLE `Patient` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `Patient_AFTER_DELETE` AFTER DELETE ON `Patient` FOR EACH ROW BEGIN
	DELETE FROM PersonInfo  	 WHERE id = OLD.personInfoID;
	DELETE FROM AddressInfo 	 WHERE id = OLD.addressInfoID;
	DELETE FROM PhoneInfo   	 WHERE id = OLD.phoneInfoID;
	DELETE FROM EmergencyContact     WHERE id = OLD.emergencyContactID;
	DELETE FROM Practitioner 	 WHERE id = OLD.practitionerID;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `PatientCredentials`
--

DROP TABLE IF EXISTS `PatientCredentials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PatientCredentials` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `patientID` char(36) NOT NULL,
  `accessCode` varchar(128) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `un_AccessCode` (`accessCode`),
  KEY `fk_PatientCredentials_Patient` (`patientID`),
  CONSTRAINT `fk_PatientCredentials_Patient` FOREIGN KEY (`patientID`) REFERENCES `Patient` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PatientCredentials`
--

LOCK TABLES `PatientCredentials` WRITE;
/*!40000 ALTER TABLE `PatientCredentials` DISABLE KEYS */;
/*!40000 ALTER TABLE `PatientCredentials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PatientToken`
--

DROP TABLE IF EXISTS `PatientToken`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PatientToken` (
  `id` char(36) NOT NULL,
  `created` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `token` char(41) NOT NULL,
  `patientCredentialsId` mediumint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `un_Token` (`token`),
  KEY `fk_PatientToken_PatientCredentials` (`patientCredentialsId`),
  CONSTRAINT `fk_PatientToken_PatientCredentials` FOREIGN KEY (`patientCredentialsId`) REFERENCES `PatientCredentials` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PatientToken`
--

LOCK TABLES `PatientToken` WRITE;
/*!40000 ALTER TABLE `PatientToken` DISABLE KEYS */;
/*!40000 ALTER TABLE `PatientToken` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PersonInfo`
--

DROP TABLE IF EXISTS `PersonInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PersonInfo` (
  `id` varchar(36) NOT NULL,
  `firstName` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `sex` enum('M','F') DEFAULT NULL,
  `birthDate` date DEFAULT NULL,
  `salutation` varchar(45) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `picturePath` varchar(255) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PersonInfo`
--

LOCK TABLES `PersonInfo` WRITE;
/*!40000 ALTER TABLE `PersonInfo` DISABLE KEYS */;
INSERT INTO `PersonInfo` VALUES ('01344b75-49da-4edb-bc23-937ffe0727aa','ffff','ff','','','2000-09-08','','','',NULL,NULL,'2020-11-23 20:30:27'),('05e26e72-1f3e-439d-a15f-b05c43e07b2a','','','','',NULL,'','','',NULL,NULL,'2022-03-31 10:08:27'),('09f2bc00-c293-4f84-9da4-324cc3000252','k','h','','M','1999-09-09','','','',NULL,NULL,'2020-11-23 20:30:27'),('2b0ce43c-7779-4b0f-a446-001942a029fd','FF','GG','','F','2000-08-09','','','',NULL,NULL,'2020-11-23 20:30:27'),('3bb6f23f-fafd-457e-9130-e42adb630c88','NO_FIRSTNAME','NO_LASTNAME','','',NULL,'','','',NULL,NULL,'2022-04-05 08:18:20'),('474d4c0c-d4df-4372-a446-e723e1135579','jhg','hg','','M','1988-02-12','','','',NULL,NULL,'2020-11-23 20:30:27'),('6d9a09a1-275a-4945-b573-36dc268dd45c','','','','',NULL,'','','',NULL,NULL,'2020-11-23 20:30:27'),('7aaf615e-8f13-4f7b-afe5-c3b4ad62dc5f','occ','occlusion','','F','1985-03-14','','','',NULL,NULL,'2020-11-23 20:30:27'),('8a2ee592-b868-4e04-9d45-49faa2a0ac68','synchro','test sabine','','F','2022-03-31','','','',NULL,NULL,'2022-03-31 10:08:27'),('b6e069d3-a8af-4fa5-8d39-32f6b51dfd1d','','','','',NULL,'','','',NULL,NULL,'2020-11-23 20:30:27'),('c638881b-e2ab-4d2a-b23d-1203ce2e56ce','sm','Test 10 scan ','','F','1985-03-14','','','',NULL,NULL,'2020-11-23 20:30:27'),('cc198ecb-e84a-4987-9bdf-74b0a293772b','','','','',NULL,'','','',NULL,NULL,'2020-11-23 20:30:27'),('d1167c85-56bf-4fd6-829f-16992693f39e','NO_FIRSTNAME','NO_LASTNAME','','',NULL,'','','',NULL,NULL,'2022-04-05 08:18:20'),('da7bb693-e18d-46bc-aea1-4bb0a6c16336','','','','',NULL,'','','',NULL,NULL,'2020-11-23 20:30:27'),('dcc20268-7483-4728-a9a5-7d1aeae81f66','','','','',NULL,'','','',NULL,NULL,'2020-11-23 20:30:27'),('ea003f63-a428-4e3b-aef8-07d2df4bf4c9','aw','TEST 10 SCAN','','M','1984-04-05','','','',NULL,NULL,'2020-11-23 20:30:27'),('eab57af5-c8ac-4a8f-b214-4d4e09e56ac9','','','','',NULL,'','','',NULL,NULL,'2020-11-23 20:30:27'),('fb1feed1-46d1-4401-95fe-3ff178164f1a','','','','',NULL,'','','',NULL,NULL,'2020-11-23 20:30:27');
/*!40000 ALTER TABLE `PersonInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PhoneInfo`
--

DROP TABLE IF EXISTS `PhoneInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PhoneInfo` (
  `id` varchar(36) NOT NULL,
  `mainPhone` varchar(45) DEFAULT NULL,
  `cellular` varchar(45) DEFAULT NULL,
  `fax` varchar(45) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PhoneInfo`
--

LOCK TABLES `PhoneInfo` WRITE;
/*!40000 ALTER TABLE `PhoneInfo` DISABLE KEYS */;
INSERT INTO `PhoneInfo` VALUES ('26cbcb7d-4865-4cfd-9d2b-26356f8eb72b','','','',NULL,NULL,'2020-11-23 20:30:27'),('32bb3f26-1f0b-4d0d-bb32-a06a0dcde843','','','',NULL,NULL,'2020-11-23 20:30:27'),('368a32e1-e3e0-4dfe-b1f1-6a69895bfe43','','','',NULL,NULL,'2020-11-23 20:30:27'),('3f094ca9-5afd-4823-ba3e-5820596bd071','','','',NULL,NULL,'2020-11-23 20:30:27'),('3fff95ef-07ad-4d23-9b46-f4230aa58ef7','','','',NULL,NULL,'2020-11-23 20:30:27'),('43538f61-1c21-4041-ba68-70de8be99041','','','',NULL,NULL,'2020-11-23 20:30:27'),('43817876-5dac-44a3-8825-122cce03381c','','','',NULL,NULL,'2020-11-23 20:30:27'),('5e2cf781-a7f9-4114-a897-b394b2dc8dab','','','',NULL,NULL,'2022-04-05 08:18:20'),('6ae34c21-5c09-481c-b7bf-d5f78d3634fc','','','',NULL,NULL,'2020-11-23 20:30:27'),('71907416-c4ce-4b53-bb40-dd6781db27f4','','','',NULL,NULL,'2020-11-23 20:30:27'),('77783e07-d004-469b-b1fc-00470809c585','','','',NULL,NULL,'2022-03-31 10:08:27'),('810916ef-bc9c-4c74-bff6-2631ce9c275f','','','',NULL,NULL,'2020-11-23 20:30:27'),('96a35f4a-c18b-45c3-ab46-3449fce9a466','','','',NULL,NULL,'2022-04-05 08:18:20'),('96fe6f37-f2c3-4097-828b-218b8a3934ab','','','',NULL,NULL,'2020-11-23 20:30:27'),('9a32f42a-aab3-4bd0-bf3d-b5c226ac1c1b','','','',NULL,NULL,'2022-03-31 10:08:27'),('a27ed5c0-a1fd-4256-a6ae-1231269fafc6','','','',NULL,NULL,'2020-11-23 20:30:27'),('a3cc1f1a-9d04-4fe3-9215-cae48f75535f','','','',NULL,NULL,'2020-11-23 20:30:27'),('ad980d56-6742-4f14-8c69-293f5092ee11','','','',NULL,NULL,'2020-11-23 20:30:27'),('bc3bbf92-20b4-487d-8337-6be51f6ca3e7','','','',NULL,NULL,'2020-11-23 20:30:27'),('beb4573e-247f-45e0-ab2d-37dcdb45c94b','','','',NULL,NULL,'2020-11-23 20:30:27'),('c218fe94-fd39-4150-a163-f6bde2e96a85','','','',NULL,NULL,'2020-11-23 20:30:27'),('c3d52a09-9117-4c5e-a89b-692d06b5ba33','','','',NULL,NULL,'2020-11-23 20:30:27'),('cfd9354b-f0db-46ab-8db1-74340fc3b2d4','','','',NULL,NULL,'2020-11-23 20:30:27'),('d584dbd4-b806-4ad8-a694-8a1ecaaac500','','','',NULL,NULL,'2020-11-23 20:30:27'),('d7a98385-d6ee-47b5-bcab-80f97c305c2b','','','',NULL,NULL,'2022-04-05 08:18:20'),('e2ab861e-5233-4b82-913f-f62e63da9160','','','',NULL,NULL,'2020-11-23 20:30:27'),('e563b214-8590-44c7-b282-bf2553f6d858','','','',NULL,NULL,'2022-03-31 10:08:27');
/*!40000 ALTER TABLE `PhoneInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Practitioner`
--

DROP TABLE IF EXISTS `Practitioner`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Practitioner` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `phoneInfoID` varchar(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_Practitioner_PhoneInfo` (`phoneInfoID`),
  CONSTRAINT `fk_Practitioner_PhoneInfo` FOREIGN KEY (`phoneInfoID`) REFERENCES `PhoneInfo` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Practitioner`
--

LOCK TABLES `Practitioner` WRITE;
/*!40000 ALTER TABLE `Practitioner` DISABLE KEYS */;
INSERT INTO `Practitioner` VALUES ('2fd193fd-92c5-4254-b9de-3782e058b7e3','','e563b214-8590-44c7-b282-bf2553f6d858',NULL,NULL,'2022-03-31 10:08:27'),('34e53b09-8430-4100-84d7-a96a2cd148c5','','3f094ca9-5afd-4823-ba3e-5820596bd071',NULL,NULL,'2020-11-23 20:30:28'),('39313d8e-70d2-4843-bb9c-93f70b1afa81','','d7a98385-d6ee-47b5-bcab-80f97c305c2b',NULL,NULL,'2022-04-05 08:18:20'),('41485be4-ff80-41bd-aa81-fbbd3f74f061','','c218fe94-fd39-4150-a163-f6bde2e96a85',NULL,NULL,'2020-11-23 20:30:28'),('4e1798dd-727e-4f60-a59c-82112f82640d','','3fff95ef-07ad-4d23-9b46-f4230aa58ef7',NULL,NULL,'2020-11-23 20:30:28'),('a4f1091c-9387-4f9f-ad38-adec673a4dd5','','cfd9354b-f0db-46ab-8db1-74340fc3b2d4',NULL,NULL,'2020-11-23 20:30:28'),('dbe5c7cd-d15d-47bb-bb8d-49143aeccba7','','beb4573e-247f-45e0-ab2d-37dcdb45c94b',NULL,NULL,'2020-11-23 20:30:28'),('de3cd5e5-cdad-4ee9-9d49-d2c8ad0985a8','','71907416-c4ce-4b53-bb40-dd6781db27f4',NULL,NULL,'2020-11-23 20:30:28'),('f197d640-4bdc-4959-89e8-5dc9487d4878','','d584dbd4-b806-4ad8-a694-8a1ecaaac500',NULL,NULL,'2020-11-23 20:30:28');
/*!40000 ALTER TABLE `Practitioner` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `Practitioner_AFTER_DELETE` AFTER DELETE ON `Practitioner` FOR EACH ROW BEGIN
	DELETE FROM PhoneInfo WHERE id = OLD.phoneInfoID;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `__db_version__`
--

DROP TABLE IF EXISTS `__db_version__`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `__db_version__` (
  `id` int NOT NULL AUTO_INCREMENT,
  `version_major` int NOT NULL DEFAULT '0',
  `version_minor` int NOT NULL DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `migration_file` varchar(1024) DEFAULT NULL,
  `commit` varchar(255) DEFAULT NULL,
  `version_core` varchar(255) DEFAULT NULL,
  `version_IHM` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `__db_version__`
--

LOCK TABLES `__db_version__` WRITE;
/*!40000 ALTER TABLE `__db_version__` DISABLE KEYS */;
INSERT INTO `__db_version__` VALUES (1,1,0,'v1.0','migration_initial_patient_cleanup_local','','4.2.0','2.1.1'),(2,1,1,'v1.1','migration_add_version_and_patient_credentials','','4.2.0','2.1.1'),(3,1,2,'v1.2','migration_add_patient_download_request','','4.2.0','2.1.1'),(4,1,3,'v1.3','migration_patient_trigger_local','','4.3.0','2.2.2');
/*!40000 ALTER TABLE `__db_version__` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping routines for database 'condor_patient_local'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2022-04-07 14:38:28
