-- MySQL dump 10.13  Distrib 8.0.29, for Linux (x86_64)
--
-- Host: localhost    Database: condor_patient_local
-- ------------------------------------------------------
-- Server version	8.0.29-0ubuntu0.20.04.3

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `AddressInfo`
--

DROP TABLE IF EXISTS `AddressInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AddressInfo` (
  `id` varchar(36) NOT NULL,
  `line_0` varchar(255) DEFAULT NULL,
  `line_1` varchar(255) DEFAULT NULL,
  `line_2` varchar(255) DEFAULT NULL,
  `detail` varchar(255) DEFAULT NULL,
  `cityName` varchar(255) DEFAULT NULL,
  `cityState` varchar(255) DEFAULT NULL,
  `cityZip` varchar(25) DEFAULT NULL,
  `countryName` varchar(255) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AddressInfo`
--

LOCK TABLES `AddressInfo` WRITE;
/*!40000 ALTER TABLE `AddressInfo` DISABLE KEYS */;
INSERT INTO `AddressInfo` VALUES ('08830310-b7e1-445c-894e-afe2e40a8298','','','',NULL,'','','','',NULL,NULL,'2021-02-01 19:10:06'),('0ecb6f72-44ff-4cb1-b912-bf611dbae5c2','','','',NULL,'','','','',NULL,NULL,'2022-06-10 18:22:14'),('1a85a454-019b-4907-9bbb-d2b019042051','','','',NULL,'','','','',NULL,NULL,'2021-03-19 09:23:31'),('2ad6ce99-46a6-4f49-bb0c-3ea41176730a','','','',NULL,'','','','',NULL,NULL,'2021-04-25 09:19:18'),('2c46db85-53fe-444e-abf4-ac2595bcc169','','','',NULL,'','','','',NULL,NULL,'2021-11-22 11:10:37'),('2cb1e181-0838-40cb-9e9f-43e42266aa45','','','',NULL,'','','','',NULL,NULL,'2021-10-12 12:26:30'),('2eb0319f-190f-4ba8-a6c8-8ba9f7b6804f','','','',NULL,'','','','',NULL,NULL,'2021-11-23 10:56:59'),('43eb15ef-f23e-496d-8635-eb3bfbe7b9cc','','','',NULL,'','','','',NULL,NULL,'2022-06-10 17:54:38'),('597f4fd6-b4e7-47ee-8a04-fe9069196ee7','','','',NULL,'','','','',NULL,NULL,'2021-09-27 11:56:30'),('6308188f-fa15-42e0-88b1-847509b5fb25','','','',NULL,'','','','',NULL,NULL,'2022-09-19 08:46:03'),('662-10','','','',NULL,'','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-11','','','',NULL,'','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-12','','','',NULL,'','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-13','','','',NULL,'','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-14','','','',NULL,'','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-15','','','',NULL,'','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-16','','','',NULL,'','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-17','','','',NULL,'','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-18','','','',NULL,'','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-19','','','',NULL,'','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-2','','','',NULL,'','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-20','','','',NULL,'','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-21','','','',NULL,'','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-22','','','',NULL,'','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-23','','','',NULL,'','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-24','','','',NULL,'','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-25','','','',NULL,'','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-3','','','',NULL,'','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-4','','','',NULL,'','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-5','','','',NULL,'','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-6','','','',NULL,'','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-7','','','',NULL,'','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-8','','','',NULL,'','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-9','','','',NULL,'','','','',NULL,NULL,'2020-12-15 14:15:32'),('66cc3a6f-85eb-4b2f-962a-34fe6cec6585','','','',NULL,'','','','',NULL,NULL,'2021-02-01 19:10:06'),('6a4ef0a7-f784-479f-b49a-bc019c00e00b','','','',NULL,'','','','',NULL,NULL,'2021-02-16 09:47:56'),('6eeb4f2c-23b9-46be-afd3-d46e47eb8c31','','','',NULL,'','','','',NULL,NULL,'2022-09-19 08:46:03'),('7087d4ab-538a-4994-a7c0-b4ec888f397a','','','',NULL,'','','','',NULL,NULL,'2020-12-29 10:57:39'),('7b31b0db-165f-4d8b-bf29-263b616ee22d','','','',NULL,'','','','',NULL,NULL,'2021-11-23 10:56:59'),('8cf988ec-cefc-41c1-850d-fd6016f2ce8e','','','',NULL,'','','','',NULL,NULL,'2020-12-29 10:57:39'),('8f2f4f1f-03db-4900-bd62-42f20c430490','','','',NULL,'','','','',NULL,NULL,'2021-04-25 09:19:18'),('a3c73fa7-bc23-4cda-9551-04ffb7ebfefe','','','',NULL,'','','','',NULL,NULL,'2022-06-10 18:22:14'),('a85b905b-10b3-4b25-82c4-c47cfb274547','','','',NULL,'','','','',NULL,NULL,'2021-02-16 09:47:56'),('a999e5d7-c7c0-4999-9dbb-df73d7ddb0c6','','','',NULL,'','','','',NULL,NULL,'2022-02-08 10:58:12'),('aa7a3b7a-51d9-4370-a5b8-750741de5ff7','','','',NULL,'','','','',NULL,NULL,'2021-09-27 11:56:30'),('ae195cb7-5752-40bd-83f0-a3b0722f4c10','','','',NULL,'','','','',NULL,NULL,'2021-11-22 11:10:37'),('b6957f1b-5fa5-46b6-867e-86fa3f61116a','','','',NULL,'','','','',NULL,NULL,'2022-02-08 10:58:12'),('bc9d7074-3978-4166-b576-9a9cd0e819d3','','','',NULL,'','','','',NULL,NULL,'2021-02-27 08:56:36'),('bfc83ab3-ddb1-4f0d-b58e-d022342b25ad','','','',NULL,'','','','',NULL,NULL,'2022-03-11 08:54:43'),('cb898509-89ca-47cd-b2c2-a2005deb054f','','','',NULL,'','','','',NULL,NULL,'2022-01-11 11:05:22'),('d7b16842-3783-4c26-90ff-bc813ca3021a','','','',NULL,'','','','',NULL,NULL,'2022-01-11 11:05:22'),('deabdf9f-f9ed-4280-8e8e-75f0db35b699','','','',NULL,'','','','',NULL,NULL,'2022-03-11 08:54:43'),('e4ba8364-a734-4368-b81e-570feab238ae','','','',NULL,'','','','',NULL,NULL,'2021-10-12 12:26:30'),('eb026410-6b2b-4f7a-a32b-99dbfb829744','','','',NULL,'','','','',NULL,NULL,'2021-02-27 08:56:36'),('f5d305d4-bd9c-460c-ac91-be5e8f163005','','','',NULL,'','','','',NULL,NULL,'2021-03-19 09:23:31'),('f8b68f0e-2d89-443c-b733-d728e3b5da3d','','','',NULL,'','','','',NULL,NULL,'2022-06-10 17:54:38');
/*!40000 ALTER TABLE `AddressInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `DownloadRequest`
--

DROP TABLE IF EXISTS `DownloadRequest`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `DownloadRequest` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `patientID` char(36) NOT NULL,
  `createdAt` datetime NOT NULL,
  `sentAt` datetime DEFAULT NULL,
  `token` char(40) DEFAULT NULL,
  `locale` char(5) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_DownloadRequest_Patient` (`patientID`),
  CONSTRAINT `fk_DownloadRequest_Patient` FOREIGN KEY (`patientID`) REFERENCES `Patient` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `DownloadRequest`
--

LOCK TABLES `DownloadRequest` WRITE;
/*!40000 ALTER TABLE `DownloadRequest` DISABLE KEYS */;
/*!40000 ALTER TABLE `DownloadRequest` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `EmergencyContact`
--

DROP TABLE IF EXISTS `EmergencyContact`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `EmergencyContact` (
  `id` varchar(36) NOT NULL,
  `personInfoID` varchar(36) DEFAULT NULL,
  `phoneInfoID` varchar(36) DEFAULT NULL,
  `addressInfoID` varchar(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_EmergencyContact_AddressInfo` (`addressInfoID`),
  KEY `fk_EmergencyContact_PersonInfo` (`personInfoID`),
  KEY `fk_EmergencyContact_PhoneInfo` (`phoneInfoID`),
  CONSTRAINT `fk_EmergencyContact_AddressInfo` FOREIGN KEY (`addressInfoID`) REFERENCES `AddressInfo` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_EmergencyContact_PersonInfo` FOREIGN KEY (`personInfoID`) REFERENCES `PersonInfo` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_EmergencyContact_PhoneInfo` FOREIGN KEY (`phoneInfoID`) REFERENCES `PhoneInfo` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `EmergencyContact`
--

LOCK TABLES `EmergencyContact` WRITE;
/*!40000 ALTER TABLE `EmergencyContact` DISABLE KEYS */;
INSERT INTO `EmergencyContact` VALUES ('0106f309-138c-4673-a20f-634dabeaf949','602e4428-7478-46d8-ae79-97ce16d55683','1a86aadf-398c-497b-978e-579f0e4f1e47','66cc3a6f-85eb-4b2f-962a-34fe6cec6585',NULL,NULL,'2021-02-01 19:10:06'),('0a456190-6dbb-4fb8-aceb-6e078c77ac2f','c21efed1-0307-4610-bb60-0fea266428f2','6c3ec017-5c32-4814-bdbb-d0c5564fdc2d','1a85a454-019b-4907-9bbb-d2b019042051',NULL,NULL,'2021-03-19 09:23:31'),('0a5959a8-0c43-40b6-b0a2-59a20e719af9','491996a7-7df1-4b73-b001-d27d102c8852','28ace1e9-d2d0-4ccf-896a-98dc38e00af5','43eb15ef-f23e-496d-8635-eb3bfbe7b9cc',NULL,NULL,'2022-06-10 17:54:38'),('60cde676-a2b8-472f-b1ce-e0ae60c20866','536d76aa-5a6f-4362-915e-aadb7b6822f1','aff236f4-148f-4052-876e-80ac11f72f64','8f2f4f1f-03db-4900-bd62-42f20c430490',NULL,NULL,'2021-04-25 09:19:18'),('662-1','662-3','662-3','662-3',NULL,NULL,'2020-12-15 14:15:32'),('662-10','662-21','662-30','662-21',NULL,NULL,'2020-12-15 14:15:32'),('662-11','662-23','662-33','662-23',NULL,NULL,'2020-12-15 14:15:32'),('662-12','662-25','662-36','662-25',NULL,NULL,'2020-12-15 14:15:32'),('662-2','662-5','662-6','662-5',NULL,NULL,'2020-12-15 14:15:32'),('662-3','662-7','662-9','662-7',NULL,NULL,'2020-12-15 14:15:32'),('662-4','662-9','662-12','662-9',NULL,NULL,'2020-12-15 14:15:32'),('662-5','662-11','662-15','662-11',NULL,NULL,'2020-12-15 14:15:32'),('662-6','662-13','662-18','662-13',NULL,NULL,'2020-12-15 14:15:32'),('662-7','662-15','662-21','662-15',NULL,NULL,'2020-12-15 14:15:32'),('662-8','662-17','662-24','662-17',NULL,NULL,'2020-12-15 14:15:32'),('662-9','662-19','662-27','662-19',NULL,NULL,'2020-12-15 14:15:32'),('686d8122-7bd9-461a-a48a-db3bff06e55c','72cfe154-a1be-47c1-8a56-a0739670a488','5047754e-dd61-4db0-b0df-5084952acc8c','2eb0319f-190f-4ba8-a6c8-8ba9f7b6804f',NULL,NULL,'2021-11-23 10:56:59'),('692efa43-c92d-4895-83ce-97f8d5625eef','e6903ca1-55bf-44e4-961f-5a04e77f3e65','2c45f2dd-1e97-4dac-b623-7bcb3bc871ce','bfc83ab3-ddb1-4f0d-b58e-d022342b25ad',NULL,NULL,'2022-03-11 08:54:43'),('70487067-7563-44f4-8664-cb84380801a4','4d51e3c5-8333-427d-9836-d26bc014cc00','3ad942b0-cc93-4402-b6ef-da88acf373b9','eb026410-6b2b-4f7a-a32b-99dbfb829744',NULL,NULL,'2021-02-27 08:56:36'),('73500c33-602a-4aed-ab2d-154360cb3b98','4831a15e-fe2e-46d5-8290-4c5fed593dfd','c7c6b73e-0b1b-4c40-89d4-a3b7c39f58a0','a85b905b-10b3-4b25-82c4-c47cfb274547',NULL,NULL,'2021-02-16 09:47:56'),('7dd84df0-c33f-40e7-a9a2-b29a7d396deb','13805b12-280f-4ef5-9be6-c5a845b0d3bf','1dd151a9-89ec-4159-9dac-6802ca0661d6','b6957f1b-5fa5-46b6-867e-86fa3f61116a',NULL,NULL,'2022-02-08 10:58:12'),('8df31c57-20fb-4da1-b07a-1895dbb463e4','5c359494-eab1-4434-9992-e712e8869be6','d76b357d-eba8-4d8e-a142-4a7b93cdca0f','2cb1e181-0838-40cb-9e9f-43e42266aa45',NULL,NULL,'2021-10-12 12:26:30'),('960dbdda-e370-41c6-a1b9-6425409413b9','609bea93-2b9e-4e77-b56e-72c9d9e0133c','affa2a49-e1db-42e0-adf7-73d8f667dd62','8cf988ec-cefc-41c1-850d-fd6016f2ce8e',NULL,NULL,'2020-12-29 10:57:39'),('a002fdba-7145-4091-815a-efda25516080','686a6614-1803-4a4d-988c-4d01925dc38b','931c9a36-d47a-4f1c-9b66-11ca60ee3ffe','cb898509-89ca-47cd-b2c2-a2005deb054f',NULL,NULL,'2022-01-11 11:05:22'),('ca101b08-6ed5-4b8c-b0c9-a4051bd017cc','3da750ec-3680-4bc2-b730-b0f3e10aa97d','c636cc0e-8a76-486f-b497-75d67f89173d','aa7a3b7a-51d9-4370-a5b8-750741de5ff7',NULL,NULL,'2021-09-27 11:56:28'),('cf44c407-0821-4a1f-b767-a4f7f10e3ab5','fe0253f3-ff28-4e1b-bc37-a784075ef730','14ddd105-9c81-490d-be65-97e308325c38','6308188f-fa15-42e0-88b1-847509b5fb25',NULL,NULL,'2022-09-19 08:46:03'),('e5b5fa4c-cc03-4dc7-9e42-f2ea994b0b3e','21802d4f-be77-4d8e-ac19-24929a4dc6ce','0ab907c5-d456-4c1f-acfb-2844d7e9b27c','0ecb6f72-44ff-4cb1-b912-bf611dbae5c2',NULL,NULL,'2022-06-10 18:22:14'),('ee5560e3-7cb8-43d2-b7a9-784af14f94a5','c979e5be-8e8a-491a-894d-6e42c2cafcc7','3879c293-2d09-4d4b-a359-843a9cbb29fd','ae195cb7-5752-40bd-83f0-a3b0722f4c10',NULL,NULL,'2021-11-22 11:10:37');
/*!40000 ALTER TABLE `EmergencyContact` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `EmergencyContact_AFTER_DELETE` AFTER DELETE ON `EmergencyContact` FOR EACH ROW BEGIN
	DELETE FROM PersonInfo 	WHERE id = OLD.personInfoID;
	DELETE FROM AddressInfo	WHERE id = OLD.addressInfoID;
	DELETE FROM PhoneInfo   WHERE id = OLD.phoneInfoID;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `Patient`
--

DROP TABLE IF EXISTS `Patient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Patient` (
  `id` varchar(36) NOT NULL,
  `globalDisplayID` mediumint unsigned DEFAULT NULL,
  `displayID` mediumint unsigned DEFAULT NULL,
  `socialSecurity` varchar(255) DEFAULT NULL,
  `allergies` varchar(255) DEFAULT NULL,
  `personInfoID` varchar(36) DEFAULT NULL,
  `phoneInfoID` varchar(36) DEFAULT NULL,
  `addressInfoID` varchar(36) DEFAULT NULL,
  `emergencyContactID` varchar(36) DEFAULT NULL,
  `practitionerID` varchar(36) DEFAULT NULL,
  `comments` text,
  `privateComments` text,
  `createdByID` char(36) DEFAULT NULL,
  `updatedByID` char(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastModified` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_Patient_AddressInfo` (`addressInfoID`),
  KEY `fk_Patient_EmergencyContact` (`emergencyContactID`),
  KEY `fk_Patient_PersonInfo` (`personInfoID`),
  KEY `fk_Patient_PhoneInfo` (`phoneInfoID`),
  KEY `fk_Patient_Practitioner` (`practitionerID`),
  CONSTRAINT `fk_Patient_AddressInfo` FOREIGN KEY (`addressInfoID`) REFERENCES `AddressInfo` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Patient_EmergencyContact` FOREIGN KEY (`emergencyContactID`) REFERENCES `EmergencyContact` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Patient_PersonInfo` FOREIGN KEY (`personInfoID`) REFERENCES `PersonInfo` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Patient_PhoneInfo` FOREIGN KEY (`phoneInfoID`) REFERENCES `PhoneInfo` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_Patient_Practitioner` FOREIGN KEY (`practitionerID`) REFERENCES `Practitioner` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Patient`
--

LOCK TABLES `Patient` WRITE;
/*!40000 ALTER TABLE `Patient` DISABLE KEYS */;
INSERT INTO `Patient` VALUES ('03ec19f1-9f11-4710-a0cd-c5d7739e40d7',1,16,'','','29f75cbf-e603-43c8-a6ed-b367213fd5b8','23653613-33b6-4102-8ea5-1b176c12d540','bc9d7074-3978-4166-b576-9a9cd0e819d3','70487067-7563-44f4-8664-cb84380801a4','8504c193-bd0c-4496-a3b3-c6655ff2d8b1','','',NULL,NULL,NULL,'2021-02-27 09:56:37','2021-02-27 08:56:37','2021-02-27 09:56:36'),('1af643c4-44fe-4ccb-b545-dbc90b47633b',1,7,'','','662-14','662-20','662-14','662-7','662-7','','',NULL,NULL,NULL,'2020-12-29 11:58:33','2020-12-29 10:58:33','2020-04-16 07:13:51'),('1ff3b081-8f07-4144-87ef-af0810d5c312',1,24,'','','b37bfe88-4ce9-4b59-a7b4-f19412df408e','5934d235-40c4-452e-892d-9f764b34d1ad','a999e5d7-c7c0-4999-9dbb-df73d7ddb0c6','7dd84df0-c33f-40e7-a9a2-b29a7d396deb','92a9c1ac-cf27-401d-ba88-c8cd90bdf05b','','',NULL,NULL,NULL,'2022-02-08 11:58:13','2022-02-08 10:58:13','2022-02-08 11:58:12'),('2b4f07b1-1d58-42a2-9e72-3461efd5a2d9',1,5,'','','662-10','662-14','662-10','662-5','662-5','','',NULL,NULL,NULL,'2020-12-29 11:58:29','2020-12-29 10:58:29','2020-04-12 08:09:52'),('35970bab-04c1-443b-9e5c-c6a127ec7a47',1,3,'','','662-6','662-8','662-6','662-3','662-3','','',NULL,NULL,'2020-04-09 09:12:22',NULL,'2020-12-15 14:15:32','2020-04-08 12:31:53'),('3c7b9483-14ba-422a-b943-e347249b6653',1,1,'','','662-2','662-2','662-2','662-1','662-1','','',NULL,NULL,'2020-04-06 11:11:19','2020-04-06 11:11:19','2020-12-15 14:15:32','2020-04-06 09:37:03'),('3d722760-3820-40e4-81e1-60e722c0cb01',1,28,'','','8064b63f-d534-4b4b-a711-a721ea53ff13','d79211ae-2bbf-4686-a94f-98c299fea2a8','6eeb4f2c-23b9-46be-afd3-d46e47eb8c31','cf44c407-0821-4a1f-b767-a4f7f10e3ab5','9ccd3902-d9a5-4f74-9a5b-c4e136bce888','','',NULL,NULL,NULL,'2022-09-19 10:46:03','2022-09-19 08:46:03','2022-09-19 10:46:03'),('406a8572-4b0f-480a-ad2e-daf5530143b6',1,2,'','','662-4','662-5','662-4','662-2','662-2','','',NULL,NULL,NULL,'2020-12-29 11:58:31','2020-12-29 10:58:31','2020-04-06 11:12:36'),('4b9236e1-8988-4a19-97af-cd44133ee27b',1,26,'','','8853d433-da8d-4692-9698-2e76d3215a67','9c38c668-9a38-4c69-81ca-02ecb951d6f0','f8b68f0e-2d89-443c-b733-d728e3b5da3d','0a5959a8-0c43-40b6-b0a2-59a20e719af9','9920860c-8b2b-4b3b-8772-6cd4843c65e4','','',NULL,NULL,NULL,'2022-06-27 21:27:05','2022-06-27 19:27:05','2022-06-10 19:54:38'),('507b1d43-2b21-4296-a969-0a1223d5706d',1,18,'','','65aff8ee-2474-4ffe-8b72-ccd3684f3a05','b7775a12-a8b2-4478-8adb-50bb60291a41','2ad6ce99-46a6-4f49-bb0c-3ea41176730a','60cde676-a2b8-472f-b1ce-e0ae60c20866','bf2775ca-12b9-4796-aa16-b9525c589ce0','','',NULL,NULL,NULL,'2021-04-25 11:28:20','2021-04-25 09:28:20','2021-04-25 11:19:18'),('53c591be-aea6-491f-bc06-740bd7d9f780',1,27,'','','457ca255-dfd0-41cb-a1f0-bbb30c5cccf8','3249a4f0-9740-4302-93aa-1b5e5acab94c','a3c73fa7-bc23-4cda-9551-04ffb7ebfefe','e5b5fa4c-cc03-4dc7-9e42-f2ea994b0b3e','04760de2-b309-4ce7-bd5b-e4e5349732fa','','',NULL,NULL,'2022-06-10 20:22:21',NULL,'2022-06-10 18:22:21','2022-06-10 20:22:14'),('555b020e-3e4a-4263-bf03-9f8db80cc843',1,12,'','','662-24','662-35','662-24','662-12','662-12','','',NULL,NULL,'2020-09-09 19:45:44','2020-09-09 19:45:44','2020-12-15 14:15:32','2020-09-09 19:35:27'),('5587321c-4405-49dc-90d5-8810cc776c6d',1,20,'','','2f5972dd-c176-4608-9776-e979510411d5','995dd29b-186f-43e2-bae1-976cbac897ca','e4ba8364-a734-4368-b81e-570feab238ae','8df31c57-20fb-4da1-b07a-1895dbb463e4','d9eb00e7-eb2a-453d-8e28-0a8459046074','','',NULL,NULL,NULL,'2021-10-12 14:26:30','2021-10-12 12:26:30','2021-10-12 14:26:30'),('5cd08749-129b-49e3-85b9-abee157177a4',1,13,'','','9bd2c709-4529-4570-8404-c4783c4099aa','bbedaf59-9fb4-4d04-922f-a5eb3f69a248','7087d4ab-538a-4994-a7c0-b4ec888f397a','960dbdda-e370-41c6-a1b9-6425409413b9','dac56b85-f171-4255-b156-cfb071da6212','','',NULL,NULL,NULL,'2020-12-29 11:57:39','2020-12-29 10:57:39','2020-12-29 11:57:39'),('5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda',1,6,'','','662-12','662-17','662-12','662-6','662-6','','',NULL,NULL,NULL,'2020-12-29 11:58:33','2020-12-29 10:58:33','2020-04-10 07:52:24'),('615ede1a-dba9-4251-9e9e-6cbbd3041fdc',1,15,'','','d5b31a82-d210-4790-a612-f67742754f8c','82ac22f3-38ba-40a5-aaf7-25d130962606','6a4ef0a7-f784-479f-b49a-bc019c00e00b','73500c33-602a-4aed-ab2d-154360cb3b98','e6e9db87-0cb9-4862-97f8-cf155646050d','','',NULL,NULL,NULL,'2021-02-16 10:47:56','2021-02-16 09:47:56','2021-02-16 10:47:56'),('665b40ce-9690-4944-b007-4a96c1f5d57d',1,25,'','','b654effd-d966-4803-9a63-0a1cc0f57f60','b55aee6c-e4b7-4380-bad4-472d6703ac8b','deabdf9f-f9ed-4280-8e8e-75f0db35b699','692efa43-c92d-4895-83ce-97f8d5625eef','d31357ea-6989-454a-a3c3-c4eed77e2073','','',NULL,NULL,NULL,'2022-03-11 09:54:43','2022-03-11 08:54:43','2022-03-11 09:54:43'),('94ac368a-c8ad-482d-91b4-26c8db10596d',1,11,'','','662-22','662-32','662-22','662-11','662-11','','',NULL,NULL,NULL,'2020-12-29 11:58:31','2020-12-29 10:58:31','2020-07-08 18:05:24'),('9977cfd4-497a-4153-ade7-6e67fc8f1938',1,17,'','','c9060893-1c34-425a-ab83-e13b8bcf1342','98ccb186-3c00-4ac6-ad58-68654e0a8163','f5d305d4-bd9c-460c-ac91-be5e8f163005','0a456190-6dbb-4fb8-aceb-6e078c77ac2f','af39d32b-757c-48c9-978e-f6288a6ab7dd','','',NULL,NULL,'2021-04-25 11:18:18','2021-04-25 11:18:18','2021-04-25 09:18:18','2021-03-19 10:23:31'),('ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07',1,22,'','','80ce8493-55c9-4464-b14b-af6f9035d9bb','1b4bf73a-5cb0-4526-92fc-b22a1e9ba960','7b31b0db-165f-4d8b-bf29-263b616ee22d','686d8122-7bd9-461a-a48a-db3bff06e55c','b8d3481c-1a20-4203-a9d5-fcdfbb13f959','','',NULL,NULL,NULL,'2021-11-23 11:56:59','2021-11-23 10:56:59','2021-11-23 11:56:59'),('b8f0b748-12f3-4798-9d93-1a7a89f0e0e1',1,10,'','','662-20','662-29','662-20','662-10','662-10','','',NULL,NULL,NULL,'2020-12-29 11:58:28','2020-12-29 10:58:28','2020-04-30 19:08:49'),('d257a7d0-47c8-46ca-9ff9-36e466d2dff8',1,21,'','','192d2022-38ee-4868-92f6-0dd8c115e3b3','754c6536-bb59-4db9-9464-181b2581f8e4','2c46db85-53fe-444e-abf4-ac2595bcc169','ee5560e3-7cb8-43d2-b7a9-784af14f94a5','3cb4f1a6-781a-4846-939d-ea1207e8c4c9','','',NULL,NULL,NULL,'2021-11-22 12:10:38','2021-11-22 11:10:38','2021-11-22 12:10:38'),('d41de280-8cf3-4e57-893e-cc7a010bc864',1,9,'','','662-18','662-26','662-18','662-9','662-9','','',NULL,NULL,NULL,'2020-12-29 11:58:34','2020-12-29 10:58:34','2020-04-18 08:57:05'),('d485e5a2-11e0-4863-b612-22d245d07d04',1,8,'','','662-16','662-23','662-16','662-8','662-8','','',NULL,NULL,'2020-04-17 07:55:14','2020-04-17 07:55:14','2020-12-15 14:15:32','2020-04-17 07:55:09'),('e27b6130-520e-4c5b-8e6b-5e82a8c5a273',1,23,'','','aa0efb26-8902-4ee3-a7c9-e73dd70b7429','ee1466d0-4d15-4786-9909-826e6fa27e8a','d7b16842-3783-4c26-90ff-bc813ca3021a','a002fdba-7145-4091-815a-efda25516080','e788e0e4-6468-455e-a91e-44beaceff226','','',NULL,NULL,NULL,'2022-01-11 12:05:23','2022-01-11 11:05:23','2022-01-11 12:05:23'),('f15cb858-4f0b-44ec-a017-5e662039ba19',1,14,'','','1d8a07a9-db25-4aa0-833e-3d0f381db543','a80a5876-7ca7-46a3-9262-bd75f5320b77','08830310-b7e1-445c-894e-afe2e40a8298','0106f309-138c-4673-a20f-634dabeaf949','9fee991a-26a6-4626-9dbf-16ddb3b2c144','','',NULL,NULL,NULL,'2021-02-01 20:10:06','2021-02-01 19:10:06','2021-02-01 20:10:06'),('f61dd82a-2e03-48b9-8ab4-0840b811de63',1,4,'','','662-8','662-11','662-8','662-4','662-4','','',NULL,NULL,'2020-04-10 07:53:51','2020-04-10 07:53:51','2020-12-15 14:15:32','2020-04-09 09:16:11'),('fee63978-1be9-4cfc-a80c-44dc3616eb33',1,19,'','','dd2e5edb-a5ce-4189-9f6c-a398232b184d','1475faa9-2139-47de-9f48-5d927671f184','597f4fd6-b4e7-47ee-8a04-fe9069196ee7','ca101b08-6ed5-4b8c-b0c9-a4051bd017cc','5e75c8a0-cc7e-4699-b518-7062a58a0b29','','',NULL,NULL,NULL,'2021-09-27 13:56:30','2021-09-27 11:56:30','2021-09-27 13:56:28');
/*!40000 ALTER TABLE `Patient` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `Patient_AFTER_DELETE` AFTER DELETE ON `Patient` FOR EACH ROW BEGIN
	DELETE FROM PersonInfo  	 WHERE id = OLD.personInfoID;
	DELETE FROM AddressInfo 	 WHERE id = OLD.addressInfoID;
	DELETE FROM PhoneInfo   	 WHERE id = OLD.phoneInfoID;
	DELETE FROM EmergencyContact     WHERE id = OLD.emergencyContactID;
	DELETE FROM Practitioner 	 WHERE id = OLD.practitionerID;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `PatientCredentials`
--

DROP TABLE IF EXISTS `PatientCredentials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PatientCredentials` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `patientID` char(36) NOT NULL,
  `accessCode` varchar(128) NOT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `un_AccessCode` (`accessCode`),
  KEY `fk_PatientCredentials_Patient` (`patientID`),
  CONSTRAINT `fk_PatientCredentials_Patient` FOREIGN KEY (`patientID`) REFERENCES `Patient` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PatientCredentials`
--

LOCK TABLES `PatientCredentials` WRITE;
/*!40000 ALTER TABLE `PatientCredentials` DISABLE KEYS */;
/*!40000 ALTER TABLE `PatientCredentials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PatientToken`
--

DROP TABLE IF EXISTS `PatientToken`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PatientToken` (
  `id` char(36) NOT NULL,
  `created` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `token` char(41) NOT NULL,
  `patientCredentialsId` mediumint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `un_Token` (`token`),
  KEY `fk_PatientToken_PatientCredentials` (`patientCredentialsId`),
  CONSTRAINT `fk_PatientToken_PatientCredentials` FOREIGN KEY (`patientCredentialsId`) REFERENCES `PatientCredentials` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PatientToken`
--

LOCK TABLES `PatientToken` WRITE;
/*!40000 ALTER TABLE `PatientToken` DISABLE KEYS */;
/*!40000 ALTER TABLE `PatientToken` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PersonInfo`
--

DROP TABLE IF EXISTS `PersonInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PersonInfo` (
  `id` varchar(36) NOT NULL,
  `firstName` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `sex` enum('M','F') DEFAULT NULL,
  `birthDate` date DEFAULT NULL,
  `salutation` varchar(45) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `picturePath` varchar(255) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PersonInfo`
--

LOCK TABLES `PersonInfo` WRITE;
/*!40000 ALTER TABLE `PersonInfo` DISABLE KEYS */;
INSERT INTO `PersonInfo` VALUES ('13805b12-280f-4ef5-9be6-c5a845b0d3bf','','','','',NULL,'','','',NULL,NULL,'2022-02-08 10:58:12'),('192d2022-38ee-4868-92f6-0dd8c115e3b3','Anaïs','LACOMBE','','F','1990-07-13','','','',NULL,NULL,'2021-11-22 11:10:38'),('1d8a07a9-db25-4aa0-833e-3d0f381db543','Benjamin','RIVES','','M','1999-07-21','','','',NULL,NULL,'2021-02-01 19:10:06'),('21802d4f-be77-4d8e-ac19-24929a4dc6ce','','','','',NULL,'','','',NULL,NULL,'2022-06-10 18:22:14'),('29f75cbf-e603-43c8-a6ed-b367213fd5b8','Yohan','LE PARC','','M','2007-01-16','','','',NULL,NULL,'2021-02-27 08:56:36'),('2f5972dd-c176-4608-9776-e979510411d5','Michèle','ESPOSITO','','F','1954-12-03','','','',NULL,NULL,'2021-10-12 12:26:30'),('3da750ec-3680-4bc2-b730-b0f3e10aa97d','','','','',NULL,'','','',NULL,NULL,'2021-09-27 11:56:28'),('457ca255-dfd0-41cb-a1f0-bbb30c5cccf8','','','','',NULL,'','','',NULL,NULL,'2022-06-10 18:22:14'),('4831a15e-fe2e-46d5-8290-4c5fed593dfd','','','','',NULL,'','','',NULL,NULL,'2021-02-16 09:47:56'),('491996a7-7df1-4b73-b001-d27d102c8852','','','','',NULL,'','','',NULL,NULL,'2022-06-10 17:54:38'),('4d51e3c5-8333-427d-9836-d26bc014cc00','','','','',NULL,'','','',NULL,NULL,'2021-02-27 08:56:36'),('536d76aa-5a6f-4362-915e-aadb7b6822f1','','','','',NULL,'','','',NULL,NULL,'2021-04-25 09:19:18'),('5c359494-eab1-4434-9992-e712e8869be6','','','','',NULL,'','','',NULL,NULL,'2021-10-12 12:26:30'),('602e4428-7478-46d8-ae79-97ce16d55683','','','','',NULL,'','','',NULL,NULL,'2021-02-01 19:10:06'),('609bea93-2b9e-4e77-b56e-72c9d9e0133c','','','','',NULL,'','','',NULL,NULL,'2020-12-29 10:57:39'),('65aff8ee-2474-4ffe-8b72-ccd3684f3a05','test','test','','F','2021-04-25','','','',NULL,NULL,'2021-04-25 09:19:19'),('662-10','Lou Cia','BLASCO','','F','2015-02-04','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-11','','','','',NULL,'','','',NULL,NULL,'2020-12-15 14:15:32'),('662-12','Chantal','BATAILLE','','F','1960-10-17','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-13','','','','',NULL,'','','',NULL,NULL,'2020-12-15 14:15:32'),('662-14','Christelle','SENTENAC','','F','1975-02-04','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-15','','','','',NULL,'','','',NULL,NULL,'2020-12-15 14:15:32'),('662-16','','','','',NULL,'','','',NULL,NULL,'2020-12-15 14:15:32'),('662-17','','','','',NULL,'','','',NULL,NULL,'2020-12-15 14:15:32'),('662-18','Fiorella','GAY','','F','1960-12-11','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-19','','','','',NULL,'','','',NULL,NULL,'2020-12-15 14:15:32'),('662-2','','','','',NULL,'','','',NULL,NULL,'2020-12-15 14:15:32'),('662-20','Johann','WALTER','','M','1979-06-09','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-21','','','','',NULL,'','','',NULL,NULL,'2020-12-15 14:15:32'),('662-22','Kais','REBIAI','','M','2010-09-07','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-23','','','','',NULL,'','','',NULL,NULL,'2020-12-15 14:15:32'),('662-24','KAIS','REBIAI','','','2010-09-07','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-25','','','','',NULL,'','','',NULL,NULL,'2020-12-15 14:15:32'),('662-3','','','','',NULL,'','','',NULL,NULL,'2020-12-15 14:15:32'),('662-4','Philippe','BATAILLE','','M','1957-02-04','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-5','','','','',NULL,'','','',NULL,NULL,'2020-12-15 14:15:32'),('662-6','','','','',NULL,'','','',NULL,NULL,'2020-12-15 14:15:32'),('662-7','','','','',NULL,'','','',NULL,NULL,'2020-12-15 14:15:32'),('662-8','Christelle','SENTENAC','','F','1975-08-18','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-9','','','','',NULL,'','','',NULL,NULL,'2020-12-15 14:15:32'),('686a6614-1803-4a4d-988c-4d01925dc38b','','','','',NULL,'','','',NULL,NULL,'2022-01-11 11:05:22'),('72cfe154-a1be-47c1-8a56-a0739670a488','','','','',NULL,'','','',NULL,NULL,'2021-11-23 10:56:59'),('8064b63f-d534-4b4b-a711-a721ea53ff13','Danielle','LAFFONT MALLET','','F','1955-08-05','','','',NULL,NULL,'2022-09-19 08:46:03'),('80ce8493-55c9-4464-b14b-af6f9035d9bb','Nathalie','DAUGREILH','','F','1964-02-23','','','',NULL,NULL,'2021-11-23 10:56:59'),('8853d433-da8d-4692-9698-2e76d3215a67','Ida','MORIN','','F','1977-05-21','','','',NULL,NULL,'2022-06-10 17:54:38'),('9bd2c709-4529-4570-8404-c4783c4099aa','Ninon','MARTY','','F','1999-07-27','','','',NULL,NULL,'2020-12-29 10:57:39'),('aa0efb26-8902-4ee3-a7c9-e73dd70b7429','Carla','GARCIA','','F','1977-12-12','','','',NULL,NULL,'2022-01-11 11:05:23'),('b37bfe88-4ce9-4b59-a7b4-f19412df408e','Delphine','AMARDEIL','','F','1977-07-31','','','',NULL,NULL,'2022-02-08 10:58:12'),('b654effd-d966-4803-9a63-0a1cc0f57f60','Marie-Josée','GUEGAIN','','F','1963-09-28','','','',NULL,NULL,'2022-03-11 08:54:43'),('c21efed1-0307-4610-bb60-0fea266428f2','','','','',NULL,'','','',NULL,NULL,'2021-03-19 09:23:31'),('c9060893-1c34-425a-ab83-e13b8bcf1342','','','','',NULL,'','','',NULL,NULL,'2021-03-19 09:23:31'),('c979e5be-8e8a-491a-894d-6e42c2cafcc7','','','','',NULL,'','','',NULL,NULL,'2021-11-22 11:10:37'),('d5b31a82-d210-4790-a612-f67742754f8c','Quitterie','DOUENCE','','F','1991-09-02','','','',NULL,NULL,'2021-02-16 09:47:56'),('dd2e5edb-a5ce-4189-9f6c-a398232b184d','Gisèle','AVERSENQ','','F','1962-02-02','','','',NULL,NULL,'2021-09-27 11:56:30'),('e6903ca1-55bf-44e4-961f-5a04e77f3e65','','','','',NULL,'','','',NULL,NULL,'2022-03-11 08:54:43'),('fe0253f3-ff28-4e1b-bc37-a784075ef730','','','','',NULL,'','','',NULL,NULL,'2022-09-19 08:46:03');
/*!40000 ALTER TABLE `PersonInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PhoneInfo`
--

DROP TABLE IF EXISTS `PhoneInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PhoneInfo` (
  `id` varchar(36) NOT NULL,
  `mainPhone` varchar(45) DEFAULT NULL,
  `cellular` varchar(45) DEFAULT NULL,
  `fax` varchar(45) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PhoneInfo`
--

LOCK TABLES `PhoneInfo` WRITE;
/*!40000 ALTER TABLE `PhoneInfo` DISABLE KEYS */;
INSERT INTO `PhoneInfo` VALUES ('0ab907c5-d456-4c1f-acfb-2844d7e9b27c','','','',NULL,NULL,'2022-06-10 18:22:14'),('1475faa9-2139-47de-9f48-5d927671f184','','','',NULL,NULL,'2021-09-27 11:56:28'),('14c43b2e-3dcf-4588-8456-03fa7d1c49c5','','','',NULL,NULL,'2021-03-19 09:23:31'),('14ddd105-9c81-490d-be65-97e308325c38','','','',NULL,NULL,'2022-09-19 08:46:03'),('1a86aadf-398c-497b-978e-579f0e4f1e47','','','',NULL,NULL,'2021-02-01 19:10:06'),('1b4bf73a-5cb0-4526-92fc-b22a1e9ba960','','','',NULL,NULL,'2021-11-23 10:56:59'),('1cc9bade-2a9b-4c1d-8346-71e399a1b895','','','',NULL,NULL,'2021-10-12 12:26:30'),('1dd151a9-89ec-4159-9dac-6802ca0661d6','','','',NULL,NULL,'2022-02-08 10:58:12'),('23653613-33b6-4102-8ea5-1b176c12d540','','','',NULL,NULL,'2021-02-27 08:56:36'),('28ace1e9-d2d0-4ccf-896a-98dc38e00af5','','','',NULL,NULL,'2022-06-10 17:54:38'),('2c45f2dd-1e97-4dac-b623-7bcb3bc871ce','','','',NULL,NULL,'2022-03-11 08:54:43'),('30432fa6-12e0-42c4-bc4d-cdc68d07276e','','','',NULL,NULL,'2021-02-01 19:10:06'),('3249a4f0-9740-4302-93aa-1b5e5acab94c','','','',NULL,NULL,'2022-06-10 18:22:14'),('3879c293-2d09-4d4b-a359-843a9cbb29fd','','','',NULL,NULL,'2021-11-22 11:10:37'),('398d595a-68a2-43d5-8644-5a6e94b4af11','','','',NULL,NULL,'2022-06-10 17:54:38'),('3ad942b0-cc93-4402-b6ef-da88acf373b9','','','',NULL,NULL,'2021-02-27 08:56:36'),('46869704-bd1b-4a02-a234-0a37c8090d97','','','',NULL,NULL,'2021-11-22 11:10:37'),('503ee7cf-d130-451a-ba7b-312cec8edcc9','','','',NULL,NULL,'2022-03-11 08:54:43'),('5047754e-dd61-4db0-b0df-5084952acc8c','','','',NULL,NULL,'2021-11-23 10:56:59'),('5934d235-40c4-452e-892d-9f764b34d1ad','','','',NULL,NULL,'2022-02-08 10:58:12'),('5a5d53b1-a3af-48fa-b5f5-1a8e258e8246','','','',NULL,NULL,'2021-02-16 09:47:56'),('5c3a2cb6-74f8-4fa8-8234-4a881aa46535','','','',NULL,NULL,'2021-04-25 09:19:18'),('662-10','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-11','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-12','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-13','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-14','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-15','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-16','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-17','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-18','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-19','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-2','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-20','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-21','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-22','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-23','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-24','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-25','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-26','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-27','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-28','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-29','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-3','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-30','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-31','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-32','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-33','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-34','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-35','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-36','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-37','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-4','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-5','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-6','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-7','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-8','','','',NULL,NULL,'2020-12-15 14:15:32'),('662-9','','','',NULL,NULL,'2020-12-15 14:15:32'),('69bf58fd-24db-4cd3-876d-e449afe94c9d','','','',NULL,NULL,'2021-02-27 08:56:36'),('6c3ec017-5c32-4814-bdbb-d0c5564fdc2d','','','',NULL,NULL,'2021-03-19 09:23:31'),('6d8e615f-c685-463d-ba92-463407ac09d5','','','',NULL,NULL,'2022-01-11 11:05:22'),('6e981231-7cd2-4a70-af07-f12f29c86d6e','','','',NULL,NULL,'2020-12-29 10:57:39'),('7299f9b7-9048-4e28-adda-87ae1bfec596','','','',NULL,NULL,'2021-09-27 11:56:28'),('754c6536-bb59-4db9-9464-181b2581f8e4','','','',NULL,NULL,'2021-11-22 11:10:37'),('763820c9-f395-4884-8489-e2664058e492','','','',NULL,NULL,'2021-11-23 10:56:59'),('77d23d0a-fbf9-42f7-808d-043b4479f314','','','',NULL,NULL,'2022-06-10 18:22:14'),('81de4bf5-393c-4da3-aad8-e0d41e7ee56d','','','',NULL,NULL,'2022-02-08 10:58:12'),('82ac22f3-38ba-40a5-aaf7-25d130962606','','','',NULL,NULL,'2021-02-16 09:47:56'),('931c9a36-d47a-4f1c-9b66-11ca60ee3ffe','','','',NULL,NULL,'2022-01-11 11:05:22'),('98ccb186-3c00-4ac6-ad58-68654e0a8163','','','',NULL,NULL,'2021-03-19 09:23:31'),('995dd29b-186f-43e2-bae1-976cbac897ca','','','',NULL,NULL,'2021-10-12 12:26:30'),('9c38c668-9a38-4c69-81ca-02ecb951d6f0','','','',NULL,NULL,'2022-06-10 17:54:38'),('a80a5876-7ca7-46a3-9262-bd75f5320b77','','','',NULL,NULL,'2021-02-01 19:10:06'),('aff236f4-148f-4052-876e-80ac11f72f64','','','',NULL,NULL,'2021-04-25 09:19:18'),('affa2a49-e1db-42e0-adf7-73d8f667dd62','','','',NULL,NULL,'2020-12-29 10:57:39'),('b55aee6c-e4b7-4380-bad4-472d6703ac8b','','','',NULL,NULL,'2022-03-11 08:54:43'),('b58641c3-f599-400c-8e70-95d55487923c','','','',NULL,NULL,'2022-09-19 08:46:03'),('b7775a12-a8b2-4478-8adb-50bb60291a41','','','',NULL,NULL,'2021-04-25 09:19:18'),('bbedaf59-9fb4-4d04-922f-a5eb3f69a248','','','',NULL,NULL,'2020-12-29 10:57:39'),('c636cc0e-8a76-486f-b497-75d67f89173d','','','',NULL,NULL,'2021-09-27 11:56:28'),('c7c6b73e-0b1b-4c40-89d4-a3b7c39f58a0','','','',NULL,NULL,'2021-02-16 09:47:56'),('d76b357d-eba8-4d8e-a142-4a7b93cdca0f','','','',NULL,NULL,'2021-10-12 12:26:30'),('d79211ae-2bbf-4686-a94f-98c299fea2a8','','','',NULL,NULL,'2022-09-19 08:46:03'),('ee1466d0-4d15-4786-9909-826e6fa27e8a','','','',NULL,NULL,'2022-01-11 11:05:22');
/*!40000 ALTER TABLE `PhoneInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Practitioner`
--

DROP TABLE IF EXISTS `Practitioner`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Practitioner` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `phoneInfoID` varchar(36) DEFAULT NULL,
  `deletedAt` datetime DEFAULT NULL,
  `lastSynced` datetime DEFAULT NULL,
  `lastUpdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_Practitioner_PhoneInfo` (`phoneInfoID`),
  CONSTRAINT `fk_Practitioner_PhoneInfo` FOREIGN KEY (`phoneInfoID`) REFERENCES `PhoneInfo` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Practitioner`
--

LOCK TABLES `Practitioner` WRITE;
/*!40000 ALTER TABLE `Practitioner` DISABLE KEYS */;
INSERT INTO `Practitioner` VALUES ('04760de2-b309-4ce7-bd5b-e4e5349732fa','','77d23d0a-fbf9-42f7-808d-043b4479f314',NULL,NULL,'2022-06-10 18:22:14'),('3cb4f1a6-781a-4846-939d-ea1207e8c4c9','','46869704-bd1b-4a02-a234-0a37c8090d97',NULL,NULL,'2021-11-22 11:10:37'),('5e75c8a0-cc7e-4699-b518-7062a58a0b29','','7299f9b7-9048-4e28-adda-87ae1bfec596',NULL,NULL,'2021-09-27 11:56:28'),('662-1','','662-4',NULL,NULL,'2020-12-15 14:15:32'),('662-10','','662-31',NULL,NULL,'2020-12-15 14:15:32'),('662-11','','662-34',NULL,NULL,'2020-12-15 14:15:32'),('662-12','','662-37',NULL,NULL,'2020-12-15 14:15:32'),('662-2','','662-7',NULL,NULL,'2020-12-15 14:15:32'),('662-3','','662-10',NULL,NULL,'2020-12-15 14:15:32'),('662-4','','662-13',NULL,NULL,'2020-12-15 14:15:32'),('662-5','','662-16',NULL,NULL,'2020-12-15 14:15:32'),('662-6','','662-19',NULL,NULL,'2020-12-15 14:15:32'),('662-7','','662-22',NULL,NULL,'2020-12-15 14:15:32'),('662-8','','662-25',NULL,NULL,'2020-12-15 14:15:32'),('662-9','','662-28',NULL,NULL,'2020-12-15 14:15:32'),('8504c193-bd0c-4496-a3b3-c6655ff2d8b1','','69bf58fd-24db-4cd3-876d-e449afe94c9d',NULL,NULL,'2021-02-27 08:56:36'),('92a9c1ac-cf27-401d-ba88-c8cd90bdf05b','','81de4bf5-393c-4da3-aad8-e0d41e7ee56d',NULL,NULL,'2022-02-08 10:58:12'),('9920860c-8b2b-4b3b-8772-6cd4843c65e4','','398d595a-68a2-43d5-8644-5a6e94b4af11',NULL,NULL,'2022-06-10 17:54:38'),('9ccd3902-d9a5-4f74-9a5b-c4e136bce888','','b58641c3-f599-400c-8e70-95d55487923c',NULL,NULL,'2022-09-19 08:46:03'),('9fee991a-26a6-4626-9dbf-16ddb3b2c144','','30432fa6-12e0-42c4-bc4d-cdc68d07276e',NULL,NULL,'2021-02-01 19:10:06'),('af39d32b-757c-48c9-978e-f6288a6ab7dd','','14c43b2e-3dcf-4588-8456-03fa7d1c49c5',NULL,NULL,'2021-03-19 09:23:31'),('b8d3481c-1a20-4203-a9d5-fcdfbb13f959','','763820c9-f395-4884-8489-e2664058e492',NULL,NULL,'2021-11-23 10:56:59'),('bf2775ca-12b9-4796-aa16-b9525c589ce0','','5c3a2cb6-74f8-4fa8-8234-4a881aa46535',NULL,NULL,'2021-04-25 09:19:18'),('d31357ea-6989-454a-a3c3-c4eed77e2073','','503ee7cf-d130-451a-ba7b-312cec8edcc9',NULL,NULL,'2022-03-11 08:54:43'),('d9eb00e7-eb2a-453d-8e28-0a8459046074','','1cc9bade-2a9b-4c1d-8346-71e399a1b895',NULL,NULL,'2021-10-12 12:26:30'),('dac56b85-f171-4255-b156-cfb071da6212','','6e981231-7cd2-4a70-af07-f12f29c86d6e',NULL,NULL,'2020-12-29 10:57:39'),('e6e9db87-0cb9-4862-97f8-cf155646050d','','5a5d53b1-a3af-48fa-b5f5-1a8e258e8246',NULL,NULL,'2021-02-16 09:47:56'),('e788e0e4-6468-455e-a91e-44beaceff226','','6d8e615f-c685-463d-ba92-463407ac09d5',NULL,NULL,'2022-01-11 11:05:22');
/*!40000 ALTER TABLE `Practitioner` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb3 */ ;
/*!50003 SET character_set_results = utf8mb3 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `Practitioner_AFTER_DELETE` AFTER DELETE ON `Practitioner` FOR EACH ROW BEGIN
	DELETE FROM PhoneInfo WHERE id = OLD.phoneInfoID;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `__db_version__`
--

DROP TABLE IF EXISTS `__db_version__`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `__db_version__` (
  `id` int NOT NULL AUTO_INCREMENT,
  `version_major` int NOT NULL DEFAULT '0',
  `version_minor` int NOT NULL DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `migration_file` varchar(1024) DEFAULT NULL,
  `commit` varchar(255) DEFAULT NULL,
  `version_core` varchar(255) DEFAULT NULL,
  `version_IHM` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `__db_version__`
--

LOCK TABLES `__db_version__` WRITE;
/*!40000 ALTER TABLE `__db_version__` DISABLE KEYS */;
INSERT INTO `__db_version__` VALUES (1,1,0,'v1.0','migration_initial_patient_cleanup_local','','4.2.0','2.1.1'),(2,1,1,'v1.1','migration_add_version_and_patient_credentials','','4.2.0','2.1.1'),(3,1,2,'v1.2','migration_add_patient_download_request','','4.2.0','2.1.1'),(4,1,3,'v1.3','migration_patient_trigger_local','','4.3.0','2.2.2');
/*!40000 ALTER TABLE `__db_version__` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping routines for database 'condor_patient_local'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-01-11 13:51:05
