-- MySQL dump 10.13  Distrib 8.0.29, for Linux (x86_64)
--
-- Host: localhost    Database: wow_application
-- ------------------------------------------------------
-- Server version	8.0.29-0ubuntu0.20.04.3

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `Act`
--

DROP TABLE IF EXISTS `Act`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Act` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `patientId` varchar(36) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `displayId` mediumint unsigned DEFAULT NULL,
  `workflow` enum('FREE','WORKFLOW_1','WORKFLOW_2','WORKFLOW_3') NOT NULL DEFAULT 'FREE',
  `comments` text,
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastAccessed` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `patientId` (`patientId`),
  CONSTRAINT `Act_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Act_ibfk_2` FOREIGN KEY (`patientId`) REFERENCES `wow_patient`.`Patient` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Act`
--

LOCK TABLES `Act` WRITE;
/*!40000 ALTER TABLE `Act` DISABLE KEYS */;
INSERT INTO `Act` VALUES ('0c1ed331-8df6-482e-8dd1-508d9b190c49',662,'fee63978-1be9-4cfc-a80c-44dc3616eb33','27/09/21',1,'FREE','',0,'2021-09-27 13:54:26.000',NULL,'2021-09-27 13:56:34.000','2021-09-27 13:56:51.000','2023-06-13 12:02:06.060','2023-06-13 14:02:06.060'),('100a15d0-4590-4544-9331-365a087a5b57',662,'406a8572-4b0f-480a-ad2e-daf5530143b6','bouchm',5,'FREE','',0,'2023-06-13 14:02:05.791',NULL,'2020-04-29 14:25:45.000','2020-04-29 14:50:36.000','2023-06-13 12:02:05.913','2023-06-13 14:02:05.913'),('129a6c33-3cca-43ab-b97a-56d0e82a546f',662,'fee63978-1be9-4cfc-a80c-44dc3616eb33','02/11/22',3,'FREE','',0,'2022-11-02 13:54:20.000',NULL,'2022-11-02 18:39:29.000','2022-11-02 13:56:17.000','2023-06-13 12:02:06.116','2023-06-13 14:02:06.116'),('1716bd86-ee5e-4929-9e79-3beba5199c80',662,'4b9236e1-8988-4a19-97af-cd44133ee27b','10/06/22',1,'FREE','',0,'2022-06-27 21:26:48.000',NULL,'2022-06-10 19:55:01.000','2022-06-10 19:55:01.000','2023-06-13 12:02:06.085','2023-06-13 14:02:06.085'),('1b1f827a-e4fa-4f16-8fd1-8cbdaa85c91e',662,'3d722760-3820-40e4-81e1-60e722c0cb01','empreinte',1,'FREE','',0,'2022-09-19 10:52:05.000',NULL,'2022-09-19 14:31:38.000','2022-09-19 15:19:17.000','2022-09-19 13:19:18.000','2022-09-19 15:19:18.000'),('1ce80886-d3f3-42d8-872a-a2eba69d0005',662,'1af643c4-44fe-4ccb-b545-dbc90b47633b','mand',2,'FREE','',0,'2023-06-13 14:02:05.791','2020-04-16 10:41:22.000','2020-04-16 07:18:40.000','2020-04-16 10:40:40.000','2023-06-13 12:02:05.836','2023-06-13 14:02:05.836'),('270ecdfc-09e3-11ee-b558-229278a3c906',662,'e27b6130-520e-4c5b-8e6b-5e82a8c5a273','Acte SmilersLab',5,'FREE','',0,'2023-06-13 14:09:31.257','2023-06-13 14:09:40.309','2023-06-13 14:09:31.361','2023-06-13 14:09:40.309','2023-06-13 12:09:40.310','2023-06-13 14:09:40.320'),('2a050d02-7424-4099-b1d0-2d7da678e690',662,'d257a7d0-47c8-46ca-9ff9-36e466d2dff8','14/12/22',5,'FREE','',0,'2022-11-04 13:31:18.000',NULL,'2022-12-14 17:38:25.000','2022-12-14 17:39:33.000','2022-12-14 16:39:33.000','2022-12-14 17:39:33.000'),('2c78d514-95bd-4529-b0a1-babfb83849b1',662,'d257a7d0-47c8-46ca-9ff9-36e466d2dff8','11/01/2023',7,'FREE','',0,'2023-01-11 12:11:32.000',NULL,'2023-01-11 13:02:10.000','2023-01-11 13:45:24.000','2023-01-11 12:45:25.000','2023-01-11 13:45:25.000'),('2e7abd17-bdd5-4ead-9751-b6d90fb9e0ea',662,'507b1d43-2b21-4296-a969-0a1223d5706d','empreinte',1,'FREE','',0,'2023-06-13 14:02:05.793',NULL,'2021-04-25 11:19:29.000','2021-04-25 11:28:19.000','2023-06-13 12:02:06.044','2023-06-13 14:02:06.044'),('3d2141bb-462c-4334-b177-d17d136574ae',662,'d257a7d0-47c8-46ca-9ff9-36e466d2dff8','22/11/21',1,'FREE','',0,'2021-11-22 12:11:00.000',NULL,'2021-11-22 12:11:00.000','2021-11-22 12:51:17.000','2021-11-22 11:51:18.000','2021-11-22 12:51:18.000'),('3eede325-0afb-43f5-9277-e22c18f8f927',662,'5587321c-4405-49dc-90d5-8810cc776c6d','06/08/22',2,'FREE','',0,'2022-08-06 13:43:31.000',NULL,'2022-08-06 13:43:31.000','2022-08-06 13:59:25.000','2022-08-06 11:59:26.000','2022-08-06 13:59:26.000'),('47a8d99f-668b-4bb6-b3bf-7bff221d397f',662,'1af643c4-44fe-4ccb-b545-dbc90b47633b','16/04/20',3,'FREE','',0,'2023-06-13 14:02:05.791','2020-04-16 10:43:17.000','2020-04-16 10:42:09.000','2020-04-16 10:42:21.000','2023-06-13 12:02:05.846','2023-06-13 14:02:05.846'),('586a7c87-5d8a-440f-a654-c452dc908844',662,'fee63978-1be9-4cfc-a80c-44dc3616eb33','21/03/23',4,'FREE','',0,'2023-03-21 12:06:40.000',NULL,'2023-03-21 12:33:01.000','2023-03-21 12:28:13.000','2023-03-21 11:33:02.000','2023-03-21 12:33:02.000'),('647287de-fb34-4f94-83ef-40f59da2edb3',662,'d485e5a2-11e0-4863-b612-22d245d07d04','',1,'FREE','',0,'2023-06-13 14:02:05.791','2020-04-17 07:55:14.000','2020-04-17 07:55:09.000','2020-04-17 07:55:09.000','2023-06-13 12:02:05.866','2023-06-13 14:02:05.866'),('64834083-3320-4687-9710-c2be0d9c7198',662,'b8f0b748-12f3-4798-9d93-1a7a89f0e0e1','ATM',1,'FREE','',0,'2023-06-13 14:02:05.791',NULL,'2020-05-04 12:02:55.000','2020-05-04 12:01:03.000','2023-06-13 12:02:05.921','2023-06-13 14:02:05.921'),('72b7a457-e38f-4535-8eba-6c98b43e5e55',662,'f15cb858-4f0b-44ec-a017-5e662039ba19','08/06/21',2,'FREE','',0,'2023-06-13 14:02:05.793',NULL,'2021-06-08 20:40:48.000','2021-06-08 20:57:52.000','2023-06-13 12:02:06.052','2023-06-13 14:02:06.052'),('72c58d79-1141-4c63-b343-909886db5520',662,'406a8572-4b0f-480a-ad2e-daf5530143b6','2 vb',4,'FREE','',0,'2023-06-13 14:02:05.791','2020-04-27 16:49:47.000','2020-04-27 16:14:03.000','2020-04-27 16:48:57.000','2023-06-13 12:02:05.905','2023-06-13 14:02:05.905'),('73abb1bd-08d2-44e7-866f-eeb3e4b59703',662,'3c7b9483-14ba-422a-b943-e347249b6653','',1,'FREE','',0,'2023-06-13 14:02:05.790','2020-04-06 11:11:19.000','2020-04-06 09:37:03.000','2020-04-06 09:37:03.000','2023-06-13 12:02:05.798','2023-06-13 14:02:05.798'),('76dcd1f0-f6c7-480f-b07b-441679345d70',662,'615ede1a-dba9-4251-9e9e-6cbbd3041fdc','16/02/21',1,'FREE','',0,'2023-06-13 14:02:05.792',NULL,'2021-02-16 10:48:19.000','2021-02-16 13:05:30.000','2023-06-13 12:02:06.026','2023-06-13 14:02:06.026'),('7813c59a-91e7-4c2c-8027-bcc3c35c797c',662,'406a8572-4b0f-480a-ad2e-daf5530143b6','BATAILLE 1',1,'FREE','',0,'2023-06-13 14:02:05.790',NULL,'2020-04-13 07:57:25.000','2020-04-08 08:51:36.000','2023-06-13 12:02:05.808','2023-06-13 14:02:05.808'),('7841125a-11dd-4b66-9179-cd371ea2f0f7',662,'e27b6130-520e-4c5b-8e6b-5e82a8c5a273','11/01/22',1,'FREE','',0,'2022-01-11 12:05:43.000',NULL,'2023-04-12 11:00:20.000','2022-01-11 12:41:54.000','2023-06-13 12:02:06.186','2023-06-13 14:02:06.186'),('78fbbe11-e1a5-4c10-b6e3-4f00df178dc6',662,'1af643c4-44fe-4ccb-b545-dbc90b47633b','max',1,'FREE','',0,'2023-06-13 14:02:05.790','2020-04-16 07:18:36.000','2020-04-16 07:18:21.000','2020-04-16 07:16:43.000','2023-06-13 12:02:05.826','2023-06-13 14:02:05.826'),('7e359a5f-1756-4ec7-8657-3e5940ae489d',662,'5587321c-4405-49dc-90d5-8810cc776c6d','12/10/21',1,'FREE','',0,'2021-10-12 14:26:10.000',NULL,'2021-10-12 14:26:37.000','2021-10-12 14:26:57.000','2023-06-13 12:02:06.068','2023-06-13 14:02:06.068'),('7f8fbc5c-3db7-4ee3-adcd-e76fc6f390b8',662,'35970bab-04c1-443b-9e5c-c6a127ec7a47','',1,'FREE','',0,'2020-04-08 12:31:53.000','2020-04-09 09:12:22.000','2020-04-08 12:31:53.000','2020-04-08 12:31:53.000','2020-04-09 07:12:22.000',NULL),('801b987d-e335-4276-8bc6-1fa57b553716',662,'2b4f07b1-1d58-42a2-9e72-3461efd5a2d9','2',2,'FREE','',0,'2023-06-13 14:02:05.792',NULL,'2020-07-13 19:50:35.000','2020-07-13 19:51:13.000','2023-06-13 12:02:05.952','2023-06-13 14:02:05.952'),('83306c87-ca0d-4ed2-b376-4227f586001f',662,'5cd08749-129b-49e3-85b9-abee157177a4','1',1,'FREE','',0,'2023-06-13 14:02:05.792',NULL,'2020-12-29 11:49:58.000','2020-12-29 11:41:50.000','2023-06-13 12:02:05.972','2023-06-13 14:02:05.972'),('848b25bd-90a8-4105-871d-f9326fe94c7b',662,'d257a7d0-47c8-46ca-9ff9-36e466d2dff8','21/12/22',6,'FREE','',0,'2022-12-21 11:45:05.000',NULL,'2022-12-21 11:45:05.000','2022-12-21 12:15:13.000','2022-12-21 11:15:15.000','2022-12-21 12:15:15.000'),('87965ef8-01eb-4830-8e8b-8b99ece62cf1',662,'d257a7d0-47c8-46ca-9ff9-36e466d2dff8','27/06/22',2,'FREE','',0,'2022-06-27 21:26:48.000',NULL,'2022-06-27 21:27:12.000','2022-06-27 21:28:36.000','2023-06-13 12:02:06.096','2023-06-13 14:02:06.096'),('8f3d7d42-f6ad-4e48-8951-08222c212e7e',662,'d257a7d0-47c8-46ca-9ff9-36e466d2dff8','04/11/22',4,'FREE','',0,'2022-11-04 12:12:28.000',NULL,'2022-12-21 11:14:42.000','2022-11-04 13:30:46.000','2022-12-21 10:14:55.000','2022-12-21 11:14:55.000'),('8f87b136-cb98-4706-b7d4-51059e1afa06',662,'665b40ce-9690-4944-b007-4a96c1f5d57d','11/03/22',1,'FREE','',0,'2022-03-11 09:55:04.000',NULL,'2022-03-11 11:19:13.000','2022-03-11 11:16:26.000','2022-03-11 10:19:15.000','2022-03-11 11:19:15.000'),('934f20d2-7444-4367-89e2-61c3bf4bee57',662,'2b4f07b1-1d58-42a2-9e72-3461efd5a2d9','1',1,'FREE','',0,'2023-06-13 14:02:05.792',NULL,'2020-07-13 19:48:56.000','2020-07-13 19:49:36.000','2023-06-13 12:02:05.944','2023-06-13 14:02:05.944'),('949fe730-88fa-4ec2-852e-dd0772ee3ee0',662,'fee63978-1be9-4cfc-a80c-44dc3616eb33','28/06/22',2,'FREE','',0,'2022-06-28 20:03:39.000',NULL,'2022-06-28 20:03:39.000','2022-06-28 20:40:18.000','2022-06-28 18:40:19.000','2022-06-28 20:40:19.000'),('98ada573-d902-11ed-9278-00d86184ce0e',662,'d257a7d0-47c8-46ca-9ff9-36e466d2dff8','Acte Smilers',9,'FREE','',0,'2023-04-12 09:21:09.000','2023-04-12 09:21:39.000','2023-04-12 09:21:09.000','2023-04-12 09:21:09.000','2023-06-13 12:02:06.164','2023-06-13 14:02:06.164'),('a62b9800-d910-11ed-b558-229278a3c906',662,'e27b6130-520e-4c5b-8e6b-5e82a8c5a273','Acte Gouttière',2,'FREE','',0,'2023-04-12 11:01:44.000',NULL,'2023-06-13 14:46:32.071','2023-04-12 11:01:44.000','2023-06-13 12:46:32.071','2023-06-13 14:46:32.087'),('a6ab7edf-6040-4f1a-b898-a1120a854927',662,'1af643c4-44fe-4ccb-b545-dbc90b47633b','16/04/20',4,'FREE','',0,'2023-06-13 14:02:05.791',NULL,'2020-04-16 11:32:34.000','2020-04-16 11:35:43.000','2023-06-13 12:02:05.856','2023-06-13 14:02:05.856'),('a7b0f1ae-ce37-4faf-9b3c-e5fab6996549',662,'406a8572-4b0f-480a-ad2e-daf5530143b6','bouhm',6,'FREE','',0,'2023-06-13 14:02:05.792',NULL,'2020-05-21 07:47:54.000','2020-05-21 08:13:15.000','2023-06-13 12:02:05.928','2023-06-13 14:02:05.928'),('acce421f-f39c-414a-a216-6f01af8c33c4',662,'53c591be-aea6-491f-bc06-740bd7d9f780','',1,'FREE','',0,'2022-06-10 20:22:14.000','2022-06-10 20:22:21.000','2022-06-10 20:22:14.000','2022-06-10 20:22:14.000','2022-06-10 18:22:21.000',NULL),('adf717e5-dc3f-47f0-9f8a-d13e0438f5cd',662,'9977cfd4-497a-4153-ade7-6e67fc8f1938','',1,'FREE','',0,'2021-03-19 10:23:31.000','2021-04-25 11:18:14.000','2021-03-19 10:23:31.000','2021-03-19 10:23:31.000','2021-04-25 09:18:14.000',NULL),('b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c',662,'5cd08749-129b-49e3-85b9-abee157177a4','29/12/20',4,'FREE','',0,'2023-06-13 14:02:05.792',NULL,'2020-12-30 07:12:44.000','2020-12-29 12:09:26.000','2023-06-13 12:02:05.993','2023-06-13 14:02:05.993'),('b498bdf4-2e5b-497a-8bfe-b65edabac3bc',662,'ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07','23/11/21',1,'FREE','',0,'2021-11-23 11:57:21.000',NULL,'2021-11-23 12:15:57.000','2021-11-23 12:24:09.000','2021-11-23 11:24:10.000','2021-11-23 12:24:10.000'),('bb2e4d25-46eb-48d2-80af-41639e464a04',662,'5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda','1',1,'FREE','',0,'2023-06-13 14:02:05.791',NULL,'2020-04-17 07:55:22.000','2020-04-17 11:21:05.000','2023-06-13 12:02:05.876','2023-06-13 14:02:05.876'),('bc967a6b-ad1a-4a59-aab8-92332e4217b0',662,'2b4f07b1-1d58-42a2-9e72-3461efd5a2d9','13/07/20',3,'FREE','',0,'2023-06-13 14:02:05.792',NULL,'2020-07-13 19:51:52.000','2020-07-13 19:47:48.000','2023-06-13 12:02:05.962','2023-06-13 14:02:05.962'),('c42cadf5-5f0e-439e-9aab-087940794316',662,'5cd08749-129b-49e3-85b9-abee157177a4','29/12/20',2,'FREE','',0,'2020-12-29 08:32:55.000','2020-12-29 08:36:41.000','2020-12-29 08:36:23.000','2020-12-29 08:34:38.000','2020-12-29 07:36:41.000',NULL),('c47ee4d9-c646-4836-8152-fc2ded70b4fe',662,'f15cb858-4f0b-44ec-a017-5e662039ba19','01/02/21',1,'FREE','',0,'2023-06-13 14:02:05.792',NULL,'2021-02-01 20:29:20.000','2021-02-01 21:24:09.000','2023-06-13 12:02:06.014','2023-06-13 14:02:06.014'),('c584a5e1-b7d4-4486-abbc-954717a6fe55',662,'555b020e-3e4a-4263-bf03-9f8db80cc843','empreintes',1,'FREE','',0,'2023-06-13 14:02:05.794','2023-04-12 06:40:03.000','2020-09-09 19:35:42.000','2020-09-09 19:43:59.000','2023-06-13 12:02:06.144','2023-06-13 14:02:06.144'),('c59a2f65-79fe-44cd-8377-e39aa0a44171',662,'d41de280-8cf3-4e57-893e-cc7a010bc864','18/04/20',1,'FREE','',0,'2023-06-13 14:02:05.791',NULL,'2020-04-18 08:57:39.000','2020-04-18 09:37:59.000','2023-06-13 12:02:05.887','2023-06-13 14:02:05.887'),('c61cdb9c-543c-4809-952c-b65656e1f96f',662,'94ac368a-c8ad-482d-91b4-26c8db10596d','empreinte',1,'FREE','',0,'2023-06-13 14:02:05.792',NULL,'2020-07-08 18:05:41.000','2020-07-08 19:59:48.000','2023-06-13 12:02:05.936','2023-06-13 14:02:05.936'),('c983b946-e304-49a8-99c8-24eaca67b9ce',662,'d257a7d0-47c8-46ca-9ff9-36e466d2dff8','11/04/23',8,'FREE','',0,'2023-04-11 19:34:32.000',NULL,'2023-04-12 10:00:00.000','2023-04-11 20:49:14.000','2023-06-13 12:02:06.175','2023-06-13 14:02:06.175'),('cb9d8495-b4dd-423f-a624-7cff70e4db55',662,'406a8572-4b0f-480a-ad2e-daf5530143b6','BATAILLE 2',2,'FREE','',0,'2023-06-13 14:02:05.790','2020-04-14 11:25:03.000','2020-04-13 07:58:19.000','2020-04-13 07:59:28.000','2023-06-13 12:02:05.816','2023-06-13 14:02:05.816'),('cf8f7620-09e1-11ee-b558-229278a3c906',662,'e27b6130-520e-4c5b-8e6b-5e82a8c5a273','Acte SmilersLab',4,'FREE','',0,'2023-06-13 13:59:54.964','2023-06-13 14:00:42.566','2023-06-13 13:59:55.036','2023-06-13 14:00:42.567','2023-06-13 12:00:42.568','2023-06-13 14:00:42.578'),('d458682a-423b-43fe-a4b0-97d586104341',662,'f61dd82a-2e03-48b9-8ab4-0840b811de63','09/04/20',1,'FREE','',0,'2023-06-13 14:02:05.795','2023-04-12 06:40:03.000','2020-04-09 09:16:47.000','2020-04-09 11:05:43.000','2023-06-13 12:02:06.154','2023-06-13 14:02:06.154'),('e43c8099-0862-42c3-9ad2-1efef27b83ba',662,'d257a7d0-47c8-46ca-9ff9-36e466d2dff8','14/09/22',3,'FREE','',0,'2022-09-14 12:00:27.000',NULL,'2022-09-14 12:00:27.000','2022-09-14 12:24:53.000','2022-09-14 10:24:54.000','2022-09-14 12:24:54.000'),('e516e5ef-09e0-11ee-b558-229278a3c906',662,'e27b6130-520e-4c5b-8e6b-5e82a8c5a273','Acte SmilersLab',3,'FREE','',0,'2023-06-13 13:53:21.000','2023-06-13 14:01:00.000','2023-06-13 14:00:53.000','2023-06-13 13:53:21.000','2023-06-13 12:02:06.732','2023-06-13 14:02:06.732'),('ec084612-67a2-4430-ae15-7fe0edeaca64',662,'406a8572-4b0f-480a-ad2e-daf5530143b6','3',3,'FREE','',0,'2023-06-13 14:02:05.791','2020-04-27 16:49:26.000','2020-04-14 11:25:05.000','2020-04-14 11:26:30.000','2023-06-13 12:02:05.897','2023-06-13 14:02:05.897'),('f474819e-9470-4612-8275-2ceb25b5522f',662,'03ec19f1-9f11-4710-a0cd-c5d7739e40d7','SMILERS',1,'FREE','',0,'2023-06-13 14:02:05.793',NULL,'2021-02-27 09:56:53.000','2021-02-27 10:59:19.000','2023-06-13 12:02:06.036','2023-06-13 14:02:06.036'),('f60bef39-641f-45a5-835c-4e84590668e4',662,'5cd08749-129b-49e3-85b9-abee157177a4','A',3,'FREE','',0,'2023-06-13 14:02:05.792',NULL,'2020-12-29 08:43:21.000','2020-12-29 08:48:30.000','2023-06-13 12:02:05.984','2023-06-13 14:02:05.984');
/*!40000 ALTER TABLE `Act` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AddressInfo`
--

DROP TABLE IF EXISTS `AddressInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AddressInfo` (
  `uuid` varchar(36) NOT NULL,
  `line0` varchar(255) DEFAULT NULL,
  `line1` varchar(255) DEFAULT NULL,
  `line2` varchar(255) DEFAULT NULL,
  `detail` varchar(255) DEFAULT NULL,
  `cityName` varchar(255) DEFAULT NULL,
  `cityState` varchar(255) DEFAULT NULL,
  `cityZip` varchar(255) DEFAULT NULL,
  `countryName` varchar(255) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AddressInfo`
--

LOCK TABLES `AddressInfo` WRITE;
/*!40000 ALTER TABLE `AddressInfo` DISABLE KEYS */;
INSERT INTO `AddressInfo` VALUES ('00000001-0000-0000-0000-000000000001','Labege','','',NULL,'Labege','','31670','France','2022-06-27 19:16:28.000',NULL),('00000002-0000-0000-0000-000000000001','137 rue garance','','',NULL,'LABEGE','','31670','France','2022-06-27 19:16:28.000',NULL),('00000003-0000-0000-0000-000000000001','137 rue Garance','','',NULL,'Labège','','31670','France','2022-06-27 19:16:28.000',NULL),('00000005-0000-0000-0000-000000000001','','','',NULL,'HOENHEIM','','','France','2022-03-31 17:40:19.000','2023-06-13 14:02:16.703'),('00000006-0000-0000-0000-000000000001','','','',NULL,'Marseille','','','France','2022-03-31 17:40:19.000','2023-06-13 14:02:16.628'),('00000007-0000-0000-0000-000000000001','','','',NULL,'MERIGNAC','','','France','2022-03-31 17:40:19.000','2023-06-13 14:02:16.600'),('00000008-0000-0000-0000-000000000001','','','',NULL,'MERIGNAC','','','France','2022-03-31 17:40:19.000','2023-06-13 14:02:16.571'),('00000009-0000-0000-0000-000000000001','','','',NULL,'Villiers Sur Marne','','','France','2022-03-31 17:40:19.000','2023-06-13 14:02:16.543'),('00000059-0000-0000-0000-000000000001','','','',NULL,'LE TEIL','','','France','2022-06-27 19:16:28.000',NULL),('00000155-0000-0000-0000-000000000001','','','',NULL,'ECOUFLANT','','','France','2022-06-27 19:16:28.000',NULL),('00000172-0000-0000-0000-000000000001','4 Chemin Couralis','','',NULL,'LAROIN','','64110','France','2022-06-27 19:16:28.000',NULL),('00000193-0000-0000-0000-000000000001','','','',NULL,'VIRIAT ','','','France','2022-06-27 19:16:28.000',NULL),('00000224-0000-0000-0000-000000000001','','','',NULL,'CUGNAUX','','','France','2022-06-27 19:16:28.000',NULL),('00000317-0000-0000-0000-000000000001','','','',NULL,'LONGWY','','','France','2022-06-27 19:16:28.000',NULL),('00000339-0000-0000-0000-000000000001','','','',NULL,'Paris','','','France','2022-06-27 19:16:28.000',NULL),('00000355-0000-0000-0000-000000000001','','','',NULL,'Parma','','','Italia','2022-06-27 19:16:28.000',NULL),('00000662-0000-0000-0000-000000000001','48 route d\'Eaunes','','',NULL,'MURET','','31600','France','2022-03-31 17:40:19.000','2023-04-12 06:40:02.641'),('00000663-0000-0000-0000-000000000001','','','',NULL,'Bruguieres ','','','France','2022-03-31 17:40:19.000','2023-06-13 14:02:16.651'),('00000689-0000-0000-0000-000000000001','','','',NULL,'CHAMBERY','','','France','2022-03-31 17:40:19.000','2023-06-13 14:02:16.676'),('74f9692b-a496-48ca-9002-1aa1e9b3b2e6','','','',NULL,'MURET','','','','2022-09-19 13:16:49.000','2023-06-13 14:02:16.727');
/*!40000 ALTER TABLE `AddressInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Assistant`
--

DROP TABLE IF EXISTS `Assistant`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Assistant` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `credentialsId` varchar(36) DEFAULT NULL,
  `personInfoId` varchar(36) NOT NULL,
  `phoneInfoId` varchar(36) NOT NULL,
  `addressInfoId` varchar(36) NOT NULL,
  `officeId` varchar(36) DEFAULT NULL,
  `patientRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'READ_ONLY',
  `actRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'NOTHING',
  `discussionRight` enum('READ_WRITE','READ_ONLY','NOTHING') DEFAULT 'NOTHING',
  `tempPassword` varchar(32) DEFAULT NULL,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `credentialsId` (`credentialsId`),
  KEY `personInfoId` (`personInfoId`),
  KEY `phoneInfoId` (`phoneInfoId`),
  KEY `addressInfoId` (`addressInfoId`),
  KEY `officeId` (`officeId`),
  CONSTRAINT `Assistant_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_2` FOREIGN KEY (`credentialsId`) REFERENCES `Credentials` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_3` FOREIGN KEY (`personInfoId`) REFERENCES `PersonInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_4` FOREIGN KEY (`phoneInfoId`) REFERENCES `PhoneInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_5` FOREIGN KEY (`addressInfoId`) REFERENCES `AddressInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Assistant_ibfk_6` FOREIGN KEY (`officeId`) REFERENCES `Office` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Assistant`
--

LOCK TABLES `Assistant` WRITE;
/*!40000 ALTER TABLE `Assistant` DISABLE KEYS */;
/*!40000 ALTER TABLE `Assistant` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CircleOrder`
--

DROP TABLE IF EXISTS `CircleOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CircleOrder` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `actId` varchar(36) NOT NULL,
  `title` varchar(64) DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `createdById` varchar(36) DEFAULT NULL,
  `updatedById` varchar(36) DEFAULT NULL,
  `displayId` mediumint unsigned DEFAULT NULL,
  `json` text NOT NULL,
  `metadata` text NOT NULL,
  `status` enum('NOT_SENT','WAITING_WOW_API','SENDING_WOW_API','SENDING_CIRCLE_API','SENT','CANCELLED','DELIVERY') NOT NULL DEFAULT 'NOT_SENT',
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `actId` (`actId`),
  CONSTRAINT `CircleOrder_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `CircleOrder_ibfk_2` FOREIGN KEY (`actId`) REFERENCES `Act` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CircleOrder`
--

LOCK TABLES `CircleOrder` WRITE;
/*!40000 ALTER TABLE `CircleOrder` DISABLE KEYS */;
/*!40000 ALTER TABLE `CircleOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CircleOrderFile`
--

DROP TABLE IF EXISTS `CircleOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `CircleOrderFile` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('FORM','SCAN') NOT NULL,
  PRIMARY KEY (`orderId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `CircleOrderFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `CircleOrderFile_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `CircleOrder` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `CircleOrderFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CircleOrderFile`
--

LOCK TABLES `CircleOrderFile` WRITE;
/*!40000 ALTER TABLE `CircleOrderFile` DISABLE KEYS */;
/*!40000 ALTER TABLE `CircleOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Config`
--

DROP TABLE IF EXISTS `Config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Config` (
  `id` mediumint unsigned NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `fullRetrieve` tinyint(1) DEFAULT '0',
  `syncEnabled` tinyint(1) DEFAULT '1',
  `showOcclusionScan` tinyint(1) DEFAULT '1',
  `showOpenStlWarning` tinyint(1) DEFAULT '1',
  `showMarginLinesWarning` tinyint(1) DEFAULT '1',
  `showDeleteConfirmation` tinyint(1) DEFAULT '1',
  `showSyncInfo` tinyint(1) DEFAULT '1',
  `downloadAtFullRetrieve` tinyint(1) DEFAULT '1',
  `lagSound` tinyint(1) DEFAULT '0',
  `lostSound` tinyint(1) DEFAULT '0',
  `emailNotifications` tinyint(1) DEFAULT '1',
  `logout` mediumint DEFAULT '10',
  `language` varchar(2) DEFAULT NULL,
  `diagnosticMode` tinyint(1) DEFAULT '0',
  `repairMode` tinyint(1) DEFAULT '0',
  `flipMaxillaryH` tinyint(1) DEFAULT '0',
  `flipMaxillaryV` tinyint(1) DEFAULT '0',
  `flipMandibleH` tinyint(1) DEFAULT '0',
  `flipMandibleV` tinyint(1) DEFAULT '0',
  `showFlipPopupMaxillary` tinyint(1) DEFAULT '1',
  `showFlipPopupMandible` tinyint(1) DEFAULT '1',
  `enableUserSharing` tinyint(1) DEFAULT '0',
  `lostTrackingRectangle` tinyint(1) DEFAULT '1',
  `showAllPatients` tinyint(1) DEFAULT '0',
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  PRIMARY KEY (`id`,`ownerId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Config`
--

LOCK TABLES `Config` WRITE;
/*!40000 ALTER TABLE `Config` DISABLE KEYS */;
INSERT INTO `Config` VALUES (1,1,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2019-12-19 14:24:12.000','2019-12-19 14:24:12.000','2019-12-19 13:24:12.000'),(1,2,0,1,1,1,1,1,1,1,0,0,1,999,'fr',0,0,0,0,0,0,1,1,0,1,0,'2020-01-07 14:47:16.000','2020-01-07 14:47:16.000','2020-01-07 13:47:16.000'),(1,3,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2019-09-17 15:34:06.000','2019-12-15 22:02:47.000','2019-12-15 21:02:47.000'),(1,5,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2019-07-02 11:04:44.000','2023-06-13 14:02:16.703','2019-12-15 21:02:47.000'),(1,6,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2019-07-02 11:05:21.000','2023-06-13 14:02:16.628','2019-12-15 21:02:47.000'),(1,7,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2019-07-02 11:06:14.000','2023-06-13 14:02:16.600','2019-12-15 21:02:47.000'),(1,8,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2019-07-02 11:06:33.000','2023-06-13 14:02:16.571','2019-12-15 21:02:47.000'),(1,9,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2019-07-02 11:07:02.000','2023-06-13 14:02:16.543','2019-12-15 21:02:47.000'),(1,59,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2019-07-17 14:12:08.000','2019-12-15 22:02:47.000','2019-12-15 21:02:47.000'),(1,155,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2019-07-31 12:21:56.000','2019-12-15 22:02:47.000','2019-12-15 21:02:47.000'),(1,172,0,1,1,1,1,1,1,1,0,0,1,999,'fr',0,0,0,0,0,0,1,1,0,1,0,'2020-01-21 18:29:27.000','2020-01-21 18:29:28.000','2020-01-21 17:29:28.000'),(1,193,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2019-09-02 18:53:02.000','2019-12-15 22:02:47.000','2019-12-15 21:02:47.000'),(1,224,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2019-09-09 15:29:44.000','2019-12-15 22:02:47.000','2019-12-15 21:02:47.000'),(1,317,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2019-10-07 14:44:35.000','2019-12-15 22:02:47.000','2019-12-15 21:02:47.000'),(1,339,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2019-10-11 20:04:31.000','2019-12-15 22:02:47.000','2019-12-15 21:02:47.000'),(1,355,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2019-10-19 13:58:38.000','2019-12-15 22:02:47.000','2019-12-15 21:02:47.000'),(1,662,0,1,1,1,1,1,1,0,0,1,1,900,'FR',0,0,0,0,0,0,1,1,0,1,1,'2020-04-30 20:24:47.000','2023-04-12 06:40:02.641','2023-04-11 19:04:11.976'),(1,663,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2020-04-08 08:55:11.000','2023-06-13 14:02:16.651','2020-04-08 06:55:11.000'),(1,689,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2020-06-02 12:32:01.000','2023-06-13 14:02:16.676','2020-06-02 10:32:01.000'),(1,1081,0,1,1,1,1,1,1,1,0,0,1,10,'fr',0,0,0,0,0,0,1,1,0,1,0,'2022-09-19 14:34:53.000','2023-06-13 14:02:16.727','2022-09-19 12:34:53.000');
/*!40000 ALTER TABLE `Config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Contact`
--

DROP TABLE IF EXISTS `Contact`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Contact` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `professionalId` mediumint unsigned NOT NULL COMMENT 'Le professionnel contact',
  `officeId` varchar(36) DEFAULT NULL,
  `status` enum('INVITATIONSENT','INVITATIONRECEIVED','ACCEPTED','REJECTED') NOT NULL DEFAULT 'INVITATIONSENT',
  `comments` text,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `uniqueContactPro` (`ownerId`,`professionalId`),
  KEY `professionalId` (`professionalId`),
  KEY `officeId` (`officeId`),
  CONSTRAINT `Contact_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Contact_ibfk_2` FOREIGN KEY (`professionalId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Contact_ibfk_3` FOREIGN KEY (`officeId`) REFERENCES `Office` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Contact`
--

LOCK TABLES `Contact` WRITE;
/*!40000 ALTER TABLE `Contact` DISABLE KEYS */;
INSERT INTO `Contact` VALUES ('08ea1d0b-73cb-4462-acdd-d58c09bde03a',662,662,NULL,'ACCEPTED','',NULL,'2020-04-06 09:36:52.000','2023-04-12 04:40:02.641','2023-04-12 06:40:02.641'),('0c639fb7-3c3a-493f-ac8c-2bd4fb7c8ede',662,1081,NULL,'INVITATIONSENT','',NULL,'2022-09-19 14:34:53.000','2023-06-13 12:02:16.727','2023-06-13 14:02:16.727'),('1418b81b-952d-4c95-a6be-d74e9dce3146',2,5,NULL,'ACCEPTED','',NULL,'2019-07-08 15:47:14.000','2019-08-12 09:04:05.000','2019-08-12 11:04:05.000'),('25312481-3ad2-4523-ae5f-0b5303fca7f1',662,689,NULL,'ACCEPTED','',NULL,'2020-12-30 07:12:31.000','2023-06-13 12:02:16.676','2023-06-13 14:02:16.676'),('28f7e34e-d2d9-411c-8ab3-d5ade71bf7cf',2,6,NULL,'ACCEPTED','',NULL,'2019-07-08 15:47:14.000','2019-07-26 04:43:50.000','2019-07-26 06:43:50.000'),('2f722c41-58c2-4478-b02d-c48fd0fa5d6c',662,9,NULL,'ACCEPTED','',NULL,'2020-04-06 09:36:53.000','2023-06-13 12:02:16.543','2023-06-13 14:02:16.543'),('31ecedea-a5d4-4c31-91a1-431f8ab24ce7',2,7,NULL,'ACCEPTED','',NULL,'2019-07-10 08:55:28.000','2019-07-22 15:07:13.000','2019-07-22 17:07:13.000'),('46be3f53-48f5-43f2-8612-6bde541a8563',2,3,NULL,'ACCEPTED','',NULL,'2019-07-03 09:49:55.000','2019-09-17 13:34:04.000','2019-09-17 15:34:04.000'),('58cd65c8-f596-48dc-a3e8-edf285a261d0',2,355,NULL,'INVITATIONSENT','',NULL,'2019-10-23 12:30:07.000','2019-10-23 10:56:54.000','2019-10-23 12:56:54.000'),('70af36cd-7b25-483d-a13d-311fcb081aea',662,8,NULL,'ACCEPTED','',NULL,'2020-04-06 09:36:53.000','2023-06-13 12:02:16.571','2023-06-13 14:02:16.571'),('7266b8b5-fa50-44b6-aafc-875a2432ec00',662,7,NULL,'ACCEPTED','',NULL,'2020-04-06 09:36:53.000','2023-06-13 12:02:16.600','2023-06-13 14:02:16.600'),('845121ab-bd3d-460f-8459-afc674d99362',2,8,NULL,'ACCEPTED','',NULL,'2019-07-08 15:47:14.000','2019-07-22 17:36:25.000','2019-07-22 19:36:25.000'),('86ff285b-3d22-4bde-a3bd-201d6972c514',662,6,NULL,'ACCEPTED','',NULL,'2020-04-06 09:36:53.000','2023-06-13 12:02:16.628','2023-06-13 14:02:16.628'),('93ad4d00-b810-418e-ab4f-5f38046486cd',2,1,NULL,'ACCEPTED','',NULL,'2019-11-25 11:21:43.000','2020-01-22 16:08:26.000','2020-01-22 17:08:26.000'),('9648ff49-e522-44ba-9b8f-93895ee57d2b',2,224,NULL,'ACCEPTED','',NULL,'2019-09-09 15:53:45.000','2019-09-09 13:53:45.000','2019-09-09 15:53:45.000'),('99c73d5d-e50b-4a8e-a4b4-60fd2150b020',2,317,NULL,'ACCEPTED','',NULL,'2019-12-09 11:58:51.000','2019-12-09 10:58:51.000','2019-12-09 11:58:51.000'),('a6c317c0-5772-4c0a-9fa8-0cef815f4fad',2,193,NULL,'ACCEPTED','',NULL,'2019-09-30 10:43:33.000','2019-09-30 08:43:33.000','2019-09-30 10:43:33.000'),('b07c194e-1421-4e3a-bffb-a6509be6f7e4',662,5,NULL,'ACCEPTED','',NULL,'2020-04-06 09:36:53.000','2023-06-13 12:02:16.703','2023-06-13 14:02:16.703'),('b26a32ea-ad6e-4f46-ae5d-f2f4a2af39ad',2,155,NULL,'ACCEPTED','',NULL,'2019-08-27 15:24:41.000','2019-08-27 13:24:41.000','2019-08-27 15:24:41.000'),('c571c887-8c1f-4576-a747-36c26c3f6338',2,172,NULL,'ACCEPTED','',NULL,'2019-12-17 15:10:34.000','2020-01-22 16:49:56.000','2020-01-22 17:49:56.000'),('d07578fc-3c54-49d7-a3eb-b581d2107f68',2,2,NULL,'ACCEPTED','',NULL,'2019-07-01 08:54:35.000','2020-01-22 14:33:10.000','2020-01-22 15:33:10.000'),('e65a3983-26d3-437e-9f3a-9ec54fa23fbe',662,663,NULL,'ACCEPTED','',NULL,'2020-04-10 09:16:28.000','2023-06-13 12:02:16.651','2023-06-13 14:02:16.651'),('e72f7319-b4e1-4049-aa99-f124db5c5af8',2,9,NULL,'ACCEPTED','',NULL,'2019-07-08 15:47:14.000','2019-08-20 15:18:44.000','2019-08-20 17:18:44.000'),('f4ec0f13-701b-4afa-bdc6-8759982358c2',2,339,NULL,'ACCEPTED','',NULL,'2019-10-15 10:41:49.000','2019-10-15 08:41:49.000','2019-10-15 10:41:49.000'),('fb3b468c-a371-4911-b472-a2869911ccef',2,59,NULL,'ACCEPTED','',NULL,'2019-09-05 17:20:56.000','2019-09-05 15:29:34.000','2019-09-05 17:29:34.000');
/*!40000 ALTER TABLE `Contact` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ContactNotification`
--

DROP TABLE IF EXISTS `ContactNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ContactNotification` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `contactId` varchar(36) DEFAULT NULL,
  `rescueDisplayName` varchar(50) DEFAULT NULL,
  `event` enum('RECEIVED','RECEIVED_TO_ACCEPTED','RECEIVED_TO_REJECTED','SENT_TO_ACCEPTED','SENT_TO_REJECTED','ACTIVATION_TIMEOUT') NOT NULL DEFAULT 'RECEIVED',
  `unread` tinyint(1) NOT NULL DEFAULT '1',
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `contactId` (`contactId`),
  CONSTRAINT `ContactNotification_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ContactNotification_ibfk_2` FOREIGN KEY (`contactId`) REFERENCES `Contact` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ContactNotification`
--

LOCK TABLES `ContactNotification` WRITE;
/*!40000 ALTER TABLE `ContactNotification` DISABLE KEYS */;
INSERT INTO `ContactNotification` VALUES ('7894234c-8756-40e0-aefc-a23645fa004c',662,'e65a3983-26d3-437e-9f3a-9ec54fa23fbe','Michael Maylin','SENT_TO_ACCEPTED',0,'2020-04-10 09:16:28.000',NULL,'2020-04-10 07:17:21.000','2020-04-10 09:17:21.000');
/*!40000 ALTER TABLE `ContactNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Credentials`
--

DROP TABLE IF EXISTS `Credentials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Credentials` (
  `uuid` varchar(36) NOT NULL,
  `login` varchar(255) NOT NULL,
  `password` varchar(100) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `login` (`login`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Credentials`
--

LOCK TABLES `Credentials` WRITE;
/*!40000 ALTER TABLE `Credentials` DISABLE KEYS */;
INSERT INTO `Credentials` VALUES ('00000002-0000-0000-0000-000000000001','sophie.m','944f83211d57ccc35f56487a20808104fd1c61ea84a6e818659c8edc5e10aca0','2022-06-27 19:16:26.000',NULL),('00000005-0000-0000-0000-000000000001','dentalbiotech',NULL,'2023-06-13 12:02:16.690','2023-06-13 14:02:16.703'),('00000006-0000-0000-0000-000000000001','laboratoirephilip',NULL,'2023-06-13 12:02:16.615','2023-06-13 14:02:16.628'),('00000007-0000-0000-0000-000000000001','Dentalcub',NULL,'2023-06-13 12:02:16.587','2023-06-13 14:02:16.600'),('00000008-0000-0000-0000-000000000001','LABEL DENT ',NULL,'2023-06-13 12:02:16.556','2023-06-13 14:02:16.571'),('00000009-0000-0000-0000-000000000001','condor lda',NULL,'2023-06-13 12:02:16.531','2023-06-13 14:02:16.543'),('00000662-0000-0000-0000-000000000001','phb','617fbb6cd3fa99524528df431a7e9dee0a14caa8a5718008c0f2852635f9e992','2023-03-21 11:32:48.000','2023-04-12 06:40:02.641'),('00000663-0000-0000-0000-000000000001','Lab31',NULL,'2023-06-13 12:02:16.642','2023-06-13 14:02:16.651'),('00000689-0000-0000-0000-000000000001','AXE ORTHO',NULL,'2023-06-13 12:02:16.666','2023-06-13 14:02:16.676'),('2cba8536-4bb8-45c7-b6c0-41ffc0484e0b','coralieb31@orange.fr',NULL,'2023-06-13 12:02:16.715','2023-06-13 14:02:16.727');
/*!40000 ALTER TABLE `Credentials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Discussion`
--

DROP TABLE IF EXISTS `Discussion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Discussion` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `selfImplied` tinyint(1) NOT NULL DEFAULT '0',
  `officeId` varchar(36) DEFAULT NULL,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`,`ownerId`),
  KEY `ownerId` (`ownerId`),
  KEY `officeId` (`officeId`),
  CONSTRAINT `Discussion_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Discussion_ibfk_2` FOREIGN KEY (`officeId`) REFERENCES `Office` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Discussion`
--

LOCK TABLES `Discussion` WRITE;
/*!40000 ALTER TABLE `Discussion` DISABLE KEYS */;
INSERT INTO `Discussion` VALUES ('2b95263d-2fff-42df-8b92-6a30e3bdc543',662,0,NULL,NULL,'2022-09-19 15:19:17.000','2023-04-12 04:41:32.611','2023-04-12 06:41:32.611'),('2b95263d-2fff-42df-8b92-6a30e3bdc543',1081,0,NULL,NULL,'2022-09-19 15:19:17.000','2022-09-19 13:19:17.000',NULL),('3bb3ca53-cf49-4698-9658-df729e5c5f9e',1,0,NULL,NULL,'2020-01-23 09:02:16.000','2020-01-23 08:02:16.000',NULL),('3bb3ca53-cf49-4698-9658-df729e5c5f9e',2,0,NULL,NULL,'2019-11-25 11:23:31.000','2019-12-19 13:24:07.000','2019-12-19 14:24:07.000'),('521142fd-7283-4541-aa70-733ace90c112',2,0,NULL,NULL,'2019-09-04 15:44:10.000','2019-09-04 13:44:49.000','2019-09-04 15:44:49.000'),('521142fd-7283-4541-aa70-733ace90c112',3,0,NULL,NULL,'2020-01-23 09:02:16.000','2020-01-23 08:02:16.000',NULL),('5cde9543-ba84-400d-ae2b-8c834d912266',2,0,NULL,NULL,'2019-12-17 15:11:56.000','2020-01-21 17:25:17.000','2020-01-21 18:25:17.000'),('5cde9543-ba84-400d-ae2b-8c834d912266',172,0,NULL,NULL,'2020-01-23 09:02:16.000','2020-01-23 08:02:16.000',NULL),('6885f3a8-c779-49e9-87ed-5d4c70e2ca06',2,0,NULL,NULL,'2019-09-30 11:17:48.000','2019-09-30 15:16:23.000','2019-09-30 17:16:23.000'),('6885f3a8-c779-49e9-87ed-5d4c70e2ca06',193,0,NULL,NULL,'2020-01-23 09:02:16.000','2020-01-23 08:02:16.000',NULL),('a16198e0-da2f-45fe-97fb-93531b35cedb',2,1,NULL,NULL,'2019-07-01 17:37:26.000','2020-01-22 14:33:40.000','2020-01-22 15:33:40.000'),('a18a6dc8-e71f-45cb-a7ad-b53500079bd4',2,0,NULL,NULL,'2019-09-09 16:10:00.000','2019-09-12 14:13:26.000','2019-09-12 16:13:26.000'),('a18a6dc8-e71f-45cb-a7ad-b53500079bd4',224,0,NULL,NULL,'2020-01-23 09:02:16.000','2020-01-23 08:02:16.000',NULL),('ac9d94b7-3541-4923-a2a8-fe429c22fbab',662,0,NULL,NULL,'2020-04-10 09:20:47.000','2023-06-13 12:02:19.582','2023-06-13 14:02:19.582'),('ac9d94b7-3541-4923-a2a8-fe429c22fbab',663,0,NULL,NULL,'2020-04-10 09:20:48.000','2020-04-10 07:20:48.000',NULL),('be6e41b9-9ce8-4980-9ce7-be4b4450d1b3',2,0,NULL,NULL,'2019-09-05 17:30:24.000','2019-09-05 15:31:16.000','2019-09-05 17:31:16.000'),('be6e41b9-9ce8-4980-9ce7-be4b4450d1b3',59,0,NULL,NULL,'2020-01-23 09:02:16.000','2020-01-23 08:02:16.000',NULL),('c2d723cd-09e1-11ee-b558-229278a3c906',662,0,NULL,NULL,'2023-06-13 13:59:33.624','2023-06-13 11:59:37.268','2023-06-13 13:59:37.268'),('c2d723cd-09e1-11ee-b558-229278a3c906',689,0,NULL,NULL,'2023-06-13 13:59:33.624','2023-06-13 11:59:33.624',NULL),('cf6d3b31-bab1-473f-a635-3b2ab68a1bfa',662,1,NULL,NULL,'2020-04-12 08:17:04.000','2023-06-13 11:50:48.672','2023-06-13 13:50:48.672'),('fe55386a-3ec2-4d00-bb80-02e0aec5e82f',2,0,NULL,NULL,'2019-08-27 15:25:58.000','2019-09-03 08:19:11.000','2019-09-03 10:19:11.000'),('fe55386a-3ec2-4d00-bb80-02e0aec5e82f',155,0,NULL,NULL,'2020-01-23 09:02:16.000','2020-01-23 08:02:16.000',NULL);
/*!40000 ALTER TABLE `Discussion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `File`
--

DROP TABLE IF EXISTS `File`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `File` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `path` text,
  `tag` text,
  `originalName` text NOT NULL,
  `originalId` varchar(36) NOT NULL,
  `metadata` text,
  `type` enum('BIN','JSON','PDF','PLY','STL','PNG','XYZ','ZIP') NOT NULL,
  `version` mediumint unsigned DEFAULT '0',
  `status` enum('CREATED','UPDATED','SYNCED','ERROR') DEFAULT 'CREATED',
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `version` (`originalId`,`version`),
  CONSTRAINT `File_ibfk_1` FOREIGN KEY (`originalId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `File`
--

LOCK TABLES `File` WRITE;
/*!40000 ALTER TABLE `File` DISABLE KEYS */;
INSERT INTO `File` VALUES ('03c11f7d-c2ac-42f2-8983-927ccff14074',662,'/var/.data/2021/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_a90158f7-0d39-4b9d-984b-57de06099c65/21_w1_o1_maxillaire_snapshot_1.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_TOSC_a90158f7-0d39-4b9d-984b-57de06099c65_SNAPS','21_w1_o1_maxillaire_snapshot_1.png','2d1d8d21-ec2c-485d-98af-375a4d8263d6','{\"displayTitle\":\"Maxillaire 1.21.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2021-11-22 12:25:53.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.075'),('04758fa4-84c5-4d84-a8c3-6b431275e3cd',662,'/var/.data/2020/662/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_a18ca6df-d765-4c6a-be28-13abd1c350af/scan_919caf8c-919a-49cc-bf39-68486f2f5991/6_w1_o2_mordu_anterieur_snapshot_0.png','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_a18ca6df-d765-4c6a-be28-13abd1c350af_FRSC_919caf8c-919a-49cc-bf39-68486f2f5991_SNAPS','6_w1_o2_mordu_anterieur_snapshot_0.png','04758fa4-84c5-4d84-a8c3-6b431275e3cd','{\"displayTitle\":\"Mordu anterieur 1.6.1.2.1\",\"title\":\"MORDU_ANTERIEUR SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-17 11:19:52.000','2023-06-13 12:02:10.350','2023-06-13 14:02:10.350'),('048d66fa-42fe-4d07-8e9c-1a8a30ce1fb4',662,'/var/.data/2021/662/03ec19f1-9f11-4710-a0cd-c5d7739e40d7/session_f474819e-9470-4612-8275-2ceb25b5522f/occlusion_484ae4d8-329f-49b5-8d83-312a8a92ff22/scan_57e7671e-1671-4ee9-96a0-650a56963aa8/16_w1_o1_mordu_anterieur_scan_file_0.ply','PATIENT_03ec19f1-9f11-4710-a0cd-c5d7739e40d7_ACT_f474819e-9470-4612-8275-2ceb25b5522f_SESS_484ae4d8-329f-49b5-8d83-312a8a92ff22_FRSC_57e7671e-1671-4ee9-96a0-650a56963aa8_MODEL','16_w1_o1_mordu_anterieur_scan_file_0.ply','048d66fa-42fe-4d07-8e9c-1a8a30ce1fb4','{\"displayTitle\":\"Mordu anterieur 1.16.1.1.1\",\"modelMatrix\":\"0.759878,0.0402714,0.654032,0,0.0273178,1.00051,-0.0364692,0,-0.65159,0.0088182,0.755605,0,12.4166,-4.86003,-30.4056,1\",\"title\":\"Mordu anterieur PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-02-27 10:58:59.000','2023-06-13 12:02:09.923','2023-06-13 14:02:09.923'),('04955796-a392-49c6-b40d-fba48ef36844',662,'/var/.data/2022/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_87965ef8-01eb-4830-8e8b-8b99ece62cf1/occlusion_dce9ce0f-0933-4c98-af84-59e2b6395f8f/scan_bd51414b-f96e-4903-a2e2-44fb3189decd/21_w2_o1_mandibule_scan_file_2.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_87965ef8-01eb-4830-8e8b-8b99ece62cf1_SESS_dce9ce0f-0933-4c98-af84-59e2b6395f8f_BOSC_bd51414b-f96e-4903-a2e2-44fb3189decd_MODEL','21_w2_o1_mandibule_scan_file_2.zip','1f29b918-27fd-422b-b4dd-da18687d0871','{\"displayTitle\":\"Mandibule 1.21.2.1.1\",\"modelMatrix\":\"-0.937572,-0.337894,0.0823816,0,0.347791,-0.91089,0.222083,0,5.10791e-09,0.236871,0.971541,0,8.50708,12.7259,-21.225,1\",\"title\":\"Mandibule ZIP\"}','ZIP',2,'SYNCED',0,NULL,'2022-06-27 20:56:02.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.086'),('0518a0de-5961-461c-b3cf-2ee702ed7107',662,'','PATIENT_94ac368a-c8ad-482d-91b4-26c8db10596d_ACT_c61cdb9c-543c-4809-952c-b65656e1f96f_SESS_53a17fdc-5de8-45aa-a9cb-ebea4886f6ff_TOSC_6445b6e3-0c4a-44d3-84e8-7f315911b8ee_MODEL','','0518a0de-5961-461c-b3cf-2ee702ed7107','{\"displayTitle\":\"MAXILLAIRE 1.11.1.1.2\",\"modelMatrix\":\"0.93271,-0.345352,0.103846,0,0.360627,0.893202,-0.268583,0,-7.74521e-9,0.28796,0.957642,0,-10.9791,-23.8504,-21.6868,1\",\"title\":\"MAXILLAIRE PLY\"}','PLY',0,'CREATED',0,'2020-07-08 19:59:48.000','2020-07-08 19:54:05.000','2023-04-11 19:02:23.476',NULL),('05260ab4-d913-11ed-b558-229278a3c906',662,'/var/.data/2023/662/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_a62b9800-d910-11ed-b558-229278a3c906/occlusion_a62ebb05-d910-11ed-b558-229278a3c906/scan_aaa22dcc-d910-11ed-b558-229278a3c906/05260ab4-d913-11ed-b558-229278a3c906.zip','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_a62b9800-d910-11ed-b558-229278a3c906_SESS_a62ebb05-d910-11ed-b558-229278a3c906_TOSC_aaa22dcc-d910-11ed-b558-229278a3c906_MODEL','05260ab4-d913-11ed-b558-229278a3c906.zip','366f07b3-d912-11ed-b558-229278a3c906','{\"displayTitle\":\"Maxillaire 1.23.2.1.1\",\"modelMatrix\":\"-0.920903,0.384571,-0.0635844,0,-0.389792,-0.908568,0.150221,0,-1.05744e-09,0.163124,0.986605,0,2.43462,-4.94471,-8.10744,1\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2023-06-13 13:47:30.000','2023-06-13 11:59:36.483','2023-06-13 13:59:36.483'),('0527500a-d913-11ed-b558-229278a3c906',662,'/var/.data/2023/662/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_a62b9800-d910-11ed-b558-229278a3c906/occlusion_a62ebb05-d910-11ed-b558-229278a3c906/scan_aaa22dcc-d910-11ed-b558-229278a3c906/0527500a-d913-11ed-b558-229278a3c906.png','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_a62b9800-d910-11ed-b558-229278a3c906_SESS_a62ebb05-d910-11ed-b558-229278a3c906_TOSC_aaa22dcc-d910-11ed-b558-229278a3c906_SNAPS','0527500a-d913-11ed-b558-229278a3c906.png','366f3933-d912-11ed-b558-229278a3c906','{\"displayTitle\":\"Maxillaire 1.23.2.1.1 Snapshot\"}','PNG',1,'SYNCED',0,NULL,'2023-06-13 13:47:30.000','2023-06-13 11:59:36.502','2023-06-13 13:59:36.502'),('06da4522-e34d-40fd-b96f-ca51c40618cc',662,'/var/.data/2023/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_2c78d514-95bd-4529-b0a1-babfb83849b1/occlusion_983c39b6-656b-4bf2-bf43-da1625adb861/scan_209f3c55-7380-4efa-8e6c-dfe8c99792a6/21_w7_o1_mandibule_scan_file_5.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_2c78d514-95bd-4529-b0a1-babfb83849b1_SESS_983c39b6-656b-4bf2-bf43-da1625adb861_BOSC_209f3c55-7380-4efa-8e6c-dfe8c99792a6_MODEL','21_w7_o1_mandibule_scan_file_5.zip','097b9793-f270-498e-9cfe-cf6bc2963744','{\"displayTitle\":\"Mandibule 1.21.7.1.1\",\"modelMatrix\":\"0.945306,0.320976,-0.0580515,0,-0.326184,0.930215,-0.168238,0,-4.4664e-09,0.177972,0.984036,0,-19.5184,-20.4309,-20.5509,1\",\"title\":\"Mandibule ZIP\"}','ZIP',5,'SYNCED',0,NULL,'2023-01-11 12:58:29.000','2023-06-13 12:02:15.035','2023-06-13 14:02:15.035'),('06e08af9-0736-40b6-93e5-bdffccb8ea44',662,'/var/.data/2022/662/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_949fe730-88fa-4ec2-852e-dd0772ee3ee0/occlusion_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d/scan_1c6adc05-0655-4ad6-bcc9-27b0ef578ded/19_w2_o1_maxillaire_snapshot_4.png','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_949fe730-88fa-4ec2-852e-dd0772ee3ee0_SESS_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d_TOSC_1c6adc05-0655-4ad6-bcc9-27b0ef578ded_SNAPS','19_w2_o1_maxillaire_snapshot_4.png','d40f4bba-69b0-4cc6-b541-e69c16b2b3d5','{\"displayTitle\":\"Maxillaire 1.19.2.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',4,'SYNCED',0,NULL,'2022-06-28 20:39:39.000','2023-06-13 12:02:13.404','2023-06-13 14:02:13.404'),('07615b33-5390-4fe1-9fbb-9ec7cbd64d40',662,'/var/.data/2022/662/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_7841125a-11dd-4b66-9179-cd371ea2f0f7/occlusion_12115366-8eb9-470b-a097-5d28bb5fdf38/scan_793e84ce-b088-458d-82f5-33fab1f5e7de/23_w1_o1_maxillaire_scan_file_1.zip','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_TOSC_793e84ce-b088-458d-82f5-33fab1f5e7de_MODEL','23_w1_o1_maxillaire_scan_file_1.zip','b03f52b8-54fa-4f11-9899-22d57d5b6ebc','{\"displayTitle\":\"Maxillaire 1.23.1.1.1\",\"modelMatrix\":\"-0.991214,-0.131706,0.0122187,0,0.132271,-0.986975,0.091564,0,1.89443e-11,0.0923757,0.995724,0,20.0589,-14.9599,-19.872,1\",\"title\":\"Maxillaire ZIP\"}','ZIP',1,'SYNCED',0,NULL,'2022-01-11 12:23:20.000','2023-06-13 12:02:13.052','2023-06-13 14:02:13.052'),('0890ccd8-08ca-4b8f-8bea-3e38e4c1e0a0',662,'/var/.data/2020/662/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_bdf42f40-5a7a-435b-a5e0-eb33efefbc97/scan_2bf301a3-b61c-4ddd-b6a2-4924c804d5f8/6_w1_o1_mordu_posterieur_gauche_scan_file_0.ply','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_bdf42f40-5a7a-435b-a5e0-eb33efefbc97_LESC_2bf301a3-b61c-4ddd-b6a2-4924c804d5f8_MODEL','6_w1_o1_mordu_posterieur_gauche_scan_file_0.ply','0890ccd8-08ca-4b8f-8bea-3e38e4c1e0a0','{\"displayTitle\":\"Mordu posterieur gauche 1.6.1.1.3\",\"modelMatrix\":\"-0.993229,-0.0971881,-0.0599364,0,0.108709,-0.966401,-0.232048,0,-0.0414211,-0.237961,0.970874,0,-7.33842,7.95332,-24.3761,1\",\"title\":\"MORDU_POSTERIEUR_GAUCHE PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-10 11:51:26.000','2023-06-13 12:02:10.143','2023-06-13 14:02:10.143'),('097b9793-f270-498e-9cfe-cf6bc2963744',662,'/var/.data/2023/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_2c78d514-95bd-4529-b0a1-babfb83849b1/occlusion_983c39b6-656b-4bf2-bf43-da1625adb861/scan_209f3c55-7380-4efa-8e6c-dfe8c99792a6/21_w7_o1_mandibule_scan_file_0.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_2c78d514-95bd-4529-b0a1-babfb83849b1_SESS_983c39b6-656b-4bf2-bf43-da1625adb861_BOSC_209f3c55-7380-4efa-8e6c-dfe8c99792a6_MODEL','21_w7_o1_mandibule_scan_file_0.zip','097b9793-f270-498e-9cfe-cf6bc2963744','{\"displayTitle\":\"Mandibule 1.21.7.1.1\",\"modelMatrix\":\"0.998737,-0.0493703,0.00928815,0,0.0502364,0.981519,-0.184655,0,-8.30368e-10,0.184889,0.982759,0,-24.228,-12.6955,-21.6513,1\",\"title\":\"Mandibule ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2023-01-11 12:21:45.000','2023-06-13 12:02:15.025','2023-06-13 14:02:15.025'),('0a02b656-9179-4cbd-ae14-079f4f933517',662,'/var/.data/2021/662/5587321c-4405-49dc-90d5-8810cc776c6d/session_7e359a5f-1756-4ec7-8657-3e5940ae489d/occlusion_b29b47d4-35f8-427d-9cd7-a393e48be2cf/scan_a6d52fce-2e61-4375-bf6d-a36f9b3eb72f/20_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_LESC_a6d52fce-2e61-4375-bf6d-a36f9b3eb72f_MODEL','20_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','0a02b656-9179-4cbd-ae14-079f4f933517','{\"displayTitle\":\"Mordu posterieur gauche 1.20.1.1.1\",\"modelMatrix\":\"-0.977596,0.0140003,0.205991,0,-0.0046974,-0.995393,0.111045,0,0.210767,0.0965222,0.972336,0,6.11013,-4.18404,-18.0488,1\",\"title\":\"Mordu posterieur gauche ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2021-10-12 12:42:39.000','2023-06-13 12:02:12.684','2023-06-13 14:02:12.684'),('0abfe6c8-8321-4681-9ffd-944418ed370c',662,'','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_LESC_6ce1c2d0-1849-4a2a-bfd9-05247b74c2d7_SNAPS','7_w2_o2_mordu_posterieur_gauche_snapshot_0.png','0abfe6c8-8321-4681-9ffd-944418ed370c','{\"displayTitle\":\"MORDU_POSTERIEUR_GAUCHE 1.7.2.2.1\",\"title\":\"MORDU_POSTERIEUR_GAUCHE SNAPSHOT\"}','PNG',0,'SYNCED',0,'2023-04-12 06:40:08.000','2020-04-15 07:39:22.000','2023-06-13 12:02:15.259','2023-06-13 14:02:15.259'),('0b4e8e31-bd54-4394-8ebc-2c2d30d84197',662,'/var/.data/2021/662/03ec19f1-9f11-4710-a0cd-c5d7739e40d7/session_f474819e-9470-4612-8275-2ceb25b5522f/occlusion_484ae4d8-329f-49b5-8d83-312a8a92ff22/scan_d9ec0349-f28e-41d6-822f-e76c8c001da9/16_w1_o1_maxillaire_scan_file_0.ply','PATIENT_03ec19f1-9f11-4710-a0cd-c5d7739e40d7_ACT_f474819e-9470-4612-8275-2ceb25b5522f_SESS_484ae4d8-329f-49b5-8d83-312a8a92ff22_TOSC_d9ec0349-f28e-41d6-822f-e76c8c001da9_MODEL','16_w1_o1_maxillaire_scan_file_0.ply','0b4e8e31-bd54-4394-8ebc-2c2d30d84197','{\"displayTitle\":\"Maxillaire 1.16.1.1.1\",\"modelMatrix\":\"-0.986529,0.151424,-0.0618949,0,-0.163586,-0.913188,0.373267,0,-2.59407e-9,0.378363,0.925657,0,6.69957,-22.8624,-18.3363,1\",\"title\":\"Maxillaire PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-02-27 10:22:30.000','2023-06-13 12:02:09.821','2023-06-13 14:02:09.821'),('0be70fda-d903-11ed-9ced-0050569a5229',662,'/var/.data/2023/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/0be70fda-d903-11ed-9ced-0050569a5229.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_c983b946-e304-49a8-99c8-24eaca67b9ce_SESS_9e007066-06fd-4fa1-a49a-f1165de95f83_TOSC_76ece440-81ad-42c8-ab91-f99fa29e2a83_MODEL','21_w8_o1_maxillaire_scan_file_1.zip','0be70fda-d903-11ed-9ced-0050569a5229','{\"displayTitle\":\"Maxillaire 1.21.8.1.1\",\"modelMatrix\":\"0.818642,0.55047,-0.163732,0,-0.574305,0.784667,-0.233391,0,-1.3908e-08,0.285096,0.958499,0,-17.5299,-5.99357,-22.031,1\",\"title\":\"Maxillaire ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2023-04-12 06:40:25.000','2023-04-12 07:24:24.636','2023-04-12 09:24:24.636'),('0be9955a-d903-11ed-9ced-0050569a5229',662,'/var/.data/2023/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/0be9955a-d903-11ed-9ced-0050569a5229.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_c983b946-e304-49a8-99c8-24eaca67b9ce_SESS_9e007066-06fd-4fa1-a49a-f1165de95f83_TOSC_76ece440-81ad-42c8-ab91-f99fa29e2a83_SNAPS','21_w8_o1_maxillaire_snapshot_1.png','0be9955a-d903-11ed-9ced-0050569a5229','{\"displayTitle\":\"Maxillaire 1.21.8.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2023-04-12 06:40:30.000','2023-04-12 07:24:24.645','2023-04-12 09:24:24.645'),('0cac8ddd-0fbb-4d05-98b1-9dbfe53318c8',662,'/var/.data/2023/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_2c78d514-95bd-4529-b0a1-babfb83849b1/occlusion_983c39b6-656b-4bf2-bf43-da1625adb861/scan_209f3c55-7380-4efa-8e6c-dfe8c99792a6/21_w7_o1_mandibule_snapshot_1.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_2c78d514-95bd-4529-b0a1-babfb83849b1_SESS_983c39b6-656b-4bf2-bf43-da1625adb861_BOSC_209f3c55-7380-4efa-8e6c-dfe8c99792a6_SNAPS','21_w7_o1_mandibule_snapshot_1.png','252b180c-565f-4f14-af48-a16cebbead9e','{\"displayTitle\":\"Mandibule 1.21.7.1.1\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2023-01-11 12:25:55.000','2023-06-13 12:02:15.051','2023-06-13 14:02:15.051'),('0cbb67d8-7a5d-43de-a85a-8ad3ddf2e2cb',662,'/var/.data/2022/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_8f3d7d42-f6ad-4e48-8951-08222c212e7e/occlusion_5bd97219-8b9e-46f5-ab9b-87ded07aa8a2/scan_2a466f6b-3960-4b1b-bb27-def76229cccc/21_w4_o1_mandibule_snapshot_0.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_8f3d7d42-f6ad-4e48-8951-08222c212e7e_SESS_5bd97219-8b9e-46f5-ab9b-87ded07aa8a2_BOSC_2a466f6b-3960-4b1b-bb27-def76229cccc_SNAPS','21_w4_o1_mandibule_snapshot_0.png','0cbb67d8-7a5d-43de-a85a-8ad3ddf2e2cb','{\"displayTitle\":\"Mandibule 1.21.4.1.1\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-11-04 12:27:19.000','2023-06-13 12:02:14.920','2023-06-13 14:02:14.920'),('0d5d836c-d915-11ed-b558-229278a3c906',662,'/var/.data/2023/662/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_a62b9800-d910-11ed-b558-229278a3c906/occlusion_a62ebb05-d910-11ed-b558-229278a3c906/scan_deeedce8-d914-11ed-b558-229278a3c906/0d5d836c-d915-11ed-b558-229278a3c906.zip','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_a62b9800-d910-11ed-b558-229278a3c906_SESS_a62ebb05-d910-11ed-b558-229278a3c906_RISC_deeedce8-d914-11ed-b558-229278a3c906_MODEL','0d5d836c-d915-11ed-b558-229278a3c906.zip','0d5d836c-d915-11ed-b558-229278a3c906','{\"displayTitle\":\"Mordu droit 1.23.2.1.1\",\"modelMatrix\":\"0.993338,-0.0622882,0.106441,0,0.0446223,0.997223,0.0514067,0,-0.10703,-0.0428296,0.992993,0,5.55484,0.444466,-17.1083,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-06-13 13:47:31.000','2023-06-13 11:59:36.517','2023-06-13 13:59:36.517'),('0d5d9857-d915-11ed-b558-229278a3c906',662,'/var/.data/2023/662/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_a62b9800-d910-11ed-b558-229278a3c906/occlusion_a62ebb05-d910-11ed-b558-229278a3c906/scan_deeedce8-d914-11ed-b558-229278a3c906/0d5d9857-d915-11ed-b558-229278a3c906.png','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_a62b9800-d910-11ed-b558-229278a3c906_SESS_a62ebb05-d910-11ed-b558-229278a3c906_RISC_deeedce8-d914-11ed-b558-229278a3c906_SNAPS','0d5d9857-d915-11ed-b558-229278a3c906.png','0d5d9857-d915-11ed-b558-229278a3c906','{\"displayTitle\":\"Mordu droit 1.23.2.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-06-13 13:47:31.000','2023-06-13 11:59:36.532','2023-06-13 13:59:36.532'),('0e855e55-dc7f-4eaf-91bd-933232cae95e',662,'/var/.data/2021/662/5587321c-4405-49dc-90d5-8810cc776c6d/session_7e359a5f-1756-4ec7-8657-3e5940ae489d/occlusion_b29b47d4-35f8-427d-9cd7-a393e48be2cf/scan_00f07cdc-1834-4ae1-a9fa-47699828c094/20_w1_o1_mordu_posterieur_droit_scan_file_0.zip','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_RISC_00f07cdc-1834-4ae1-a9fa-47699828c094_MODEL','20_w1_o1_mordu_posterieur_droit_scan_file_0.zip','0e855e55-dc7f-4eaf-91bd-933232cae95e','{\"displayTitle\":\"Mordu posterieur droit 1.20.1.1.1\",\"modelMatrix\":\"0.977044,0.023574,0.212257,0,-0.0393808,0.997586,0.0676487,0,-0.209382,-0.0658891,0.974905,0,3.82768,-0.972126,-16.0009,1\",\"title\":\"Mordu posterieur droit ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2021-10-12 12:40:26.000','2023-06-13 12:02:12.644','2023-06-13 14:02:12.644'),('0f7ff11f-44bc-45a5-bfc7-a7ac0da258f5',662,'/var/.data/2021/662/f15cb858-4f0b-44ec-a017-5e662039ba19/session_72b7a457-e38f-4535-8eba-6c98b43e5e55/occlusion_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c/scan_437ef945-eb42-4841-9b20-34804bd5cfd6/14_w2_o1_mandibule_scan_file_1.ply','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_72b7a457-e38f-4535-8eba-6c98b43e5e55_SESS_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c_BOSC_437ef945-eb42-4841-9b20-34804bd5cfd6_MODEL','14_w2_o1_mandibule_scan_file_1.ply','ff42f199-4210-43da-bfae-3dc172610fff','{\"displayTitle\":\"Mandibule 1.14.2.1.2\",\"modelMatrix\":\"-0.381739,0.817021,-0.432148,0,-0.92427,-0.337443,0.178484,0,-6.90106e-11,0.467556,0.883963,0,3.91985,-9.2919,-16.9777,1\",\"title\":\"Mandibule PLY\"}','PLY',1,'SYNCED',0,NULL,'2021-06-08 20:46:38.000','2023-06-13 12:02:12.287','2023-06-13 14:02:12.287'),('0fd33c57-ea90-4557-bed0-d59a4b5f2c80',662,'','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_PROST_083f4c03-5580-45f2-9229-c3b06c40bbe2_FORM','7_w2_odf_prost_file_0.pdf','0fd33c57-ea90-4557-bed0-d59a4b5f2c80','{\"displayTitle\":\"ODF 1.7.2.1 ODF\",\"title\":\"Odf PDF\"}','PDF',0,'SYNCED',0,'2023-04-12 06:40:09.000','2020-04-15 08:27:54.000','2023-06-13 12:02:17.642','2023-06-13 14:02:17.642'),('102a1df9-b0fe-46c3-b1b6-edddfb8c021b',662,'/var/.data/2021/662/615ede1a-dba9-4251-9e9e-6cbbd3041fdc/session_76dcd1f0-f6c7-480f-b07b-441679345d70/occlusion_c6fffa68-cc65-471a-a58e-135ebe4d0772/scan_ae899af8-7040-48c9-a9b2-6ebc255ac7c9/15_w1_o1_maxillaire_snapshot_0.png','PATIENT_615ede1a-dba9-4251-9e9e-6cbbd3041fdc_ACT_76dcd1f0-f6c7-480f-b07b-441679345d70_SESS_c6fffa68-cc65-471a-a58e-135ebe4d0772_TOSC_ae899af8-7040-48c9-a9b2-6ebc255ac7c9_SNAPS','15_w1_o1_maxillaire_snapshot_0.png','102a1df9-b0fe-46c3-b1b6-edddfb8c021b','{\"displayTitle\":\"Maxillaire 1.15.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-02-16 12:19:19.000','2023-06-13 12:02:09.683','2023-06-13 14:02:09.683'),('102c6dfe-d914-11ed-b558-229278a3c906',662,'/var/.data/2023/662/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_a62b9800-d910-11ed-b558-229278a3c906/occlusion_a62ebb05-d910-11ed-b558-229278a3c906/scan_1ff82da8-d913-11ed-b558-229278a3c906/102c6dfe-d914-11ed-b558-229278a3c906.zip','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_a62b9800-d910-11ed-b558-229278a3c906_SESS_a62ebb05-d910-11ed-b558-229278a3c906_BOSC_1ff82da8-d913-11ed-b558-229278a3c906_MODEL','102c6dfe-d914-11ed-b558-229278a3c906.zip','102c6dfe-d914-11ed-b558-229278a3c906','{\"displayTitle\":\"Mandibule 1.23.2.1.1\",\"modelMatrix\":\"0.991569,0.0927323,-0.0905062,0,-0.129579,0.709611,-0.692576,0,-4.15557e-09,0.698465,0.715644,0,-0.0329298,-22.1604,-17.1531,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-06-13 13:47:33.000','2023-06-13 11:59:36.549','2023-06-13 13:59:36.549'),('102db5a2-d914-11ed-b558-229278a3c906',662,'/var/.data/2023/662/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_a62b9800-d910-11ed-b558-229278a3c906/occlusion_a62ebb05-d910-11ed-b558-229278a3c906/scan_1ff82da8-d913-11ed-b558-229278a3c906/102db5a2-d914-11ed-b558-229278a3c906.png','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_a62b9800-d910-11ed-b558-229278a3c906_SESS_a62ebb05-d910-11ed-b558-229278a3c906_BOSC_1ff82da8-d913-11ed-b558-229278a3c906_SNAPS','102db5a2-d914-11ed-b558-229278a3c906.png','102db5a2-d914-11ed-b558-229278a3c906','{\"displayTitle\":\"Mandibule 1.23.2.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-06-13 13:47:34.000','2023-06-13 11:59:36.583','2023-06-13 13:59:36.583'),('110bfb15-3589-48ab-bb80-e339d042b64d',662,'/var/.data/2022/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_e43c8099-0862-42c3-9ad2-1efef27b83ba/occlusion_09f15124-6bba-4565-bfe4-efb3c6c3a17d/scan_3a315f7b-8cf2-4d0c-bf92-fecb623fe530/21_w3_o1_maxillaire_scan_file_0.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_e43c8099-0862-42c3-9ad2-1efef27b83ba_SESS_09f15124-6bba-4565-bfe4-efb3c6c3a17d_TOSC_3a315f7b-8cf2-4d0c-bf92-fecb623fe530_MODEL','21_w3_o1_maxillaire_scan_file_0.zip','110bfb15-3589-48ab-bb80-e339d042b64d','{\"displayTitle\":\"Maxillaire 1.21.3.1.1\",\"modelMatrix\":\"0.7863,0.612786,-0.0789043,0,-0.617845,0.779862,-0.100417,0,-2.25538e-09,0.127709,0.991812,0,-23.6196,-16.0226,-21.1675,1\",\"title\":\"Maxillaire ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-09-14 12:19:53.000','2023-06-13 12:02:13.538','2023-06-13 14:02:13.538'),('118f4b39-1c4d-49d5-9470-979ae78a94eb',662,'/var/.data/2020/662/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/occlusion_b87f1382-55d4-4e52-b63a-6f387df18b16/scan_a26f0d58-ca46-4921-a9e1-9c39b7f89783/13_w4_o1_maxillaire_snapshot_1.png','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_SESS_b87f1382-55d4-4e52-b63a-6f387df18b16_TOSC_a26f0d58-ca46-4921-a9e1-9c39b7f89783_SNAPS','13_w4_o1_maxillaire_snapshot_1.png','24c23cdd-d323-4623-8a9d-2d3e14f3b937','{\"displayTitle\":\"Maxillaire 1.13.4.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2020-12-29 11:05:41.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.084'),('11dc5cec-d45b-455d-8577-dcf502967a94',662,'','PATIENT_f61dd82a-2e03-48b9-8ab4-0840b811de63_ACT_d458682a-423b-43fe-a4b0-97d586104341_SESS_4af4bd2d-76e3-4905-99fd-191c4cc669fa_TOSC_f2b8c151-b863-4411-b17a-b987ca58ee6f_SNAPS','4_w1_o1_maxillaire_snapshot_0.png','11dc5cec-d45b-455d-8577-dcf502967a94','{\"displayTitle\":\"MAXILLAIRE 1.4.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}','PNG',0,'SYNCED',0,'2023-04-12 06:40:09.000','2020-04-09 10:56:37.000','2023-06-13 12:02:15.591','2023-06-13 14:02:15.591'),('127e55bb-48e6-421e-ab6a-05b0763a843e',662,'','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_BOSC_d2372948-816f-4d58-a2bf-288bc0e7b539_MODEL','7_w2_o2_mandibule_scan_file_0.ply','127e55bb-48e6-421e-ab6a-05b0763a843e','{\"displayTitle\":\"MANDIBULE 1.7.2.2.1\",\"modelMatrix\":\"0.562893,-0.81608,0.131019,0,0.82653,0.555776,-0.0892277,0,-4.59721e-11,0.158516,0.987356,0,6.06834,14.8211,-40.9787,1\",\"title\":\"MANDIBULE PLY\"}','PLY',0,'SYNCED',0,'2023-04-12 06:40:17.000','2020-04-15 07:13:11.000','2023-06-13 12:02:15.523','2023-06-13 14:02:15.523'),('13991d0c-102a-4df8-aaad-f5f422edc6be',662,'/var/.data/2021/662/ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07/session_b498bdf4-2e5b-497a-8bfe-b65edabac3bc/occlusion_31210683-bc06-4b84-83d9-ce60f32308e4/scan_98e7c216-5bb9-4127-9497-834796980370/22_w1_o1_maxillaire_scan_file_0.zip','PATIENT_ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07_ACT_b498bdf4-2e5b-497a-8bfe-b65edabac3bc_SESS_31210683-bc06-4b84-83d9-ce60f32308e4_TOSC_98e7c216-5bb9-4127-9497-834796980370_MODEL','22_w1_o1_maxillaire_scan_file_0.zip','13991d0c-102a-4df8-aaad-f5f422edc6be','{\"displayTitle\":\"Maxillaire 1.22.1.1.1\",\"modelMatrix\":\"-0.984254,0.164681,-0.0642138,0,-0.176758,-0.917007,0.357567,0,1.66597e-9,0.363287,0.931677,0,24.4804,-16.7011,-23.2991,1\",\"title\":\"Maxillaire ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2021-11-23 12:08:22.000','2023-06-13 12:02:12.939','2023-06-13 14:02:12.939'),('13fa1125-c9d0-498d-bc50-68dc9f4f1beb',662,'/var/.data/2021/662/f15cb858-4f0b-44ec-a017-5e662039ba19/session_72b7a457-e38f-4535-8eba-6c98b43e5e55/occlusion_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c/scan_be9a4ba5-715b-4547-a31d-66621ec7b17f/14_w2_o1_maxillaire_snapshot_0.png','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_72b7a457-e38f-4535-8eba-6c98b43e5e55_SESS_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c_TOSC_be9a4ba5-715b-4547-a31d-66621ec7b17f_SNAPS','14_w2_o1_maxillaire_snapshot_0.png','13fa1125-c9d0-498d-bc50-68dc9f4f1beb','{\"displayTitle\":\"Maxillaire 1.14.2.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-06-08 20:11:20.000','2023-06-13 12:02:12.209','2023-06-13 14:02:12.209'),('144ce692-0397-4de4-aa07-e50e85b5a553',662,'/var/.data/2020/662/2b4f07b1-1d58-42a2-9e72-3461efd5a2d9/session_bc967a6b-ad1a-4a59-aab8-92332e4217b0/occlusion_f2e73640-aebd-4bb1-9b02-c0504556ac5a/scan_e7efed59-e33c-4194-94c1-3507350dcfb5/5_w3_o1_maxillaire_snapshot_2.png','PATIENT_2b4f07b1-1d58-42a2-9e72-3461efd5a2d9_ACT_bc967a6b-ad1a-4a59-aab8-92332e4217b0_SESS_f2e73640-aebd-4bb1-9b02-c0504556ac5a_TOSC_e7efed59-e33c-4194-94c1-3507350dcfb5_SNAPS','5_w3_o1_maxillaire_snapshot_2.png','b94c36ee-0e86-44b0-a152-b92997bdab17','{\"displayTitle\":\"Maxillaire 1.5.3.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',2,'SYNCED',0,NULL,'2020-07-13 19:39:11.000','2023-04-12 04:40:12.116','2023-04-12 06:40:12.116'),('14c0bac1-16fe-41ce-863b-85ffd35f41e9',662,'/var/.data/2022/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_848b25bd-90a8-4105-871d-f9326fe94c7b/occlusion_ba7da56a-5a10-4378-a887-8e98aa892a3c/scan_b002027b-930d-4b96-a687-453aeea5659e/21_w6_o1_maxillaire_snapshot_0.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_848b25bd-90a8-4105-871d-f9326fe94c7b_SESS_ba7da56a-5a10-4378-a887-8e98aa892a3c_TOSC_b002027b-930d-4b96-a687-453aeea5659e_SNAPS','21_w6_o1_maxillaire_snapshot_0.png','14c0bac1-16fe-41ce-863b-85ffd35f41e9','{\"displayTitle\":\"Maxillaire 1.21.6.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-12-21 12:09:24.000','2023-06-13 12:02:15.000','2023-06-13 14:02:15.000'),('156e5ba4-51dd-4631-932f-c91d8a7edef9',662,'/var/.data/2021/662/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_643b3b5a-e991-4dbf-95c8-2fd609f83a8b/14_w1_o1_maxillaire_snapshot_5.png','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_TOSC_643b3b5a-e991-4dbf-95c8-2fd609f83a8b_SNAPS','14_w1_o1_maxillaire_snapshot_5.png','3d7bd9ef-9d44-4365-af74-4d2a31f8f2fb','{\"displayTitle\":\"Maxillaire 1.14.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',5,'SYNCED',0,NULL,'2021-02-01 20:52:02.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.098'),('160153e9-3248-4a6b-b0ff-a10c2c1acfc9',662,'/var/.data/2022/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_87965ef8-01eb-4830-8e8b-8b99ece62cf1/occlusion_dce9ce0f-0933-4c98-af84-59e2b6395f8f/scan_bd51414b-f96e-4903-a2e2-44fb3189decd/21_w2_o1_mandibule_snapshot_0.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_87965ef8-01eb-4830-8e8b-8b99ece62cf1_SESS_dce9ce0f-0933-4c98-af84-59e2b6395f8f_BOSC_bd51414b-f96e-4903-a2e2-44fb3189decd_SNAPS','21_w2_o1_mandibule_snapshot_0.png','160153e9-3248-4a6b-b0ff-a10c2c1acfc9','{\"displayTitle\":\"Mandibule SNAPSHOT\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-06-27 20:48:28.000','2023-06-13 12:02:13.353','2023-06-13 14:02:13.353'),('169331da-dbab-454e-828b-67287bb2feb7',662,'/var/.data/2020/662/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/occlusion_d402edb5-8449-46a8-862f-a1cd1ee21cf6/scan_b5005e42-2d4d-41b0-91d5-667275f3a9cc/10_w1_o1_mordu_posterieur_droit_snapshot_0.png','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_SESS_d402edb5-8449-46a8-862f-a1cd1ee21cf6_RISC_b5005e42-2d4d-41b0-91d5-667275f3a9cc_SNAPS','10_w1_o1_mordu_posterieur_droit_snapshot_0.png','169331da-dbab-454e-828b-67287bb2feb7','{\"displayTitle\":\"Mordu posterieur droit 1.10.1.1.1\",\"title\":\"MORDU_POSTERIEUR_DROIT SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-30 20:00:05.000','2023-06-13 12:02:12.490','2023-06-13 14:02:12.490'),('1712177a-2d33-429e-81ed-e58b3ec65c4d',662,'/var/.data/2021/662/ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07/session_b498bdf4-2e5b-497a-8bfe-b65edabac3bc/occlusion_31210683-bc06-4b84-83d9-ce60f32308e4/scan_c1232582-95fc-48dc-a9ee-826c0cbad106/22_w1_o1_mordu_posterieur_droit_snapshot_0.png','PATIENT_ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07_ACT_b498bdf4-2e5b-497a-8bfe-b65edabac3bc_SESS_31210683-bc06-4b84-83d9-ce60f32308e4_RISC_c1232582-95fc-48dc-a9ee-826c0cbad106_SNAPS','22_w1_o1_mordu_posterieur_droit_snapshot_0.png','1712177a-2d33-429e-81ed-e58b3ec65c4d','{\"displayTitle\":\"Mordu posterieur droit 1.22.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-11-23 12:18:01.000','2023-06-13 12:02:12.982','2023-06-13 14:02:12.982'),('176a7141-81b2-436e-bbb3-00ec6028c71b',662,'/var/.data/2022/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_8f3d7d42-f6ad-4e48-8951-08222c212e7e/occlusion_5bd97219-8b9e-46f5-ab9b-87ded07aa8a2/scan_2a466f6b-3960-4b1b-bb27-def76229cccc/21_w4_o1_mandibule_scan_file_0.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_8f3d7d42-f6ad-4e48-8951-08222c212e7e_SESS_5bd97219-8b9e-46f5-ab9b-87ded07aa8a2_BOSC_2a466f6b-3960-4b1b-bb27-def76229cccc_MODEL','21_w4_o1_mandibule_scan_file_0.zip','176a7141-81b2-436e-bbb3-00ec6028c71b','{\"displayTitle\":\"Mandibule 1.21.4.1.1\",\"modelMatrix\":\"-0.618598,0.77386,-0.135934,0,-0.785708,-0.609269,0.107022,0,-1.06395e-08,0.173008,0.98492,0,16.5648,-9.9754,-16.8903,1\",\"title\":\"Mandibule ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-11-04 12:27:21.000','2023-06-13 12:02:14.903','2023-06-13 14:02:14.903'),('185c4f85-4987-4fa1-9ca4-3c6b9e0373b7',662,'/var/.data/2022/662/665b40ce-9690-4944-b007-4a96c1f5d57d/session_8f87b136-cb98-4706-b7d4-51059e1afa06/occlusion_5f895907-3eed-4aa7-995a-f7e1c9661a0a/scan_26a765d3-8b92-4861-984a-bd9c8040209b/25_w1_o1_mandibule_scan_file_1.zip','PATIENT_665b40ce-9690-4944-b007-4a96c1f5d57d_ACT_8f87b136-cb98-4706-b7d4-51059e1afa06_SESS_5f895907-3eed-4aa7-995a-f7e1c9661a0a_BOSC_26a765d3-8b92-4861-984a-bd9c8040209b_MODEL','25_w1_o1_mandibule_scan_file_1.zip','be04859c-f9ff-4a11-96c0-99dd77c8c98f','{\"displayTitle\":\"Mandibule 1.25.1.1.1\",\"modelMatrix\":\"-0.0602949,0.978867,-0.195407,0,-0.998181,-0.0591282,0.0118035,0,4.93874e-10,0.195763,0.980651,0,13.6002,-10.7847,-19.7425,1\",\"title\":\"Mandibule ZIP\"}','ZIP',1,'SYNCED',0,NULL,'2022-03-11 10:31:25.000','2023-06-13 12:02:13.205','2023-06-13 14:02:13.205'),('1920fbbf-3535-420d-92a8-85d1ffb87094',662,'/var/.data/2020/662/406a8572-4b0f-480a-ad2e-daf5530143b6/session_100a15d0-4590-4544-9331-365a087a5b57/occlusion_348477f7-c7a9-4bb3-8b28-3da592902286/scan_12f64013-f8aa-44bb-91e8-38c23737152b/2_w5_o1_maxillaire_scan_file_0.ply','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_100a15d0-4590-4544-9331-365a087a5b57_SESS_348477f7-c7a9-4bb3-8b28-3da592902286_TOSC_12f64013-f8aa-44bb-91e8-38c23737152b_MODEL','2_w5_o1_maxillaire_scan_file_0.ply','1920fbbf-3535-420d-92a8-85d1ffb87094','{\"displayTitle\":\"Maxillaire 1.2.5.1.1\",\"modelMatrix\":\"0.998398,-0.0537142,0.01778,0,0.0565804,0.947822,-0.31374,0,8.28453e-10,0.314244,0.949342,0,-18.4283,-39.02,-23.5398,1\",\"title\":\"MAXILLAIRE PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-29 14:50:36.000','2023-06-13 12:02:10.369','2023-06-13 14:02:10.369'),('1ab759da-dceb-48e2-83be-326054416d3c',662,'/var/.data/2022/662/3d722760-3820-40e4-81e1-60e722c0cb01/session_1b1f827a-e4fa-4f16-8fd1-8cbdaa85c91e/order_7a0fe58a-64da-4011-982b-3db6bd950242/28_w1_autre_prost_file_1ab759da-dceb-48e2-83be-326054416d3c_0.pdf','PATIENT_3d722760-3820-40e4-81e1-60e722c0cb01_ACT_1b1f827a-e4fa-4f16-8fd1-8cbdaa85c91e_PROST_7a0fe58a-64da-4011-982b-3db6bd950242_FORM','28_w1_autre_prost_file_1ab759da-dceb-48e2-83be-326054416d3c_0.pdf','1ab759da-dceb-48e2-83be-326054416d3c','{\"displayTitle\":\"COMMANDE 1.28.1.1 AUTRE FICHE DE PROTHESE\",\"title\":\"Autre PDF\"}','PDF',0,'SYNCED',0,NULL,'2022-09-19 15:19:17.000','2023-04-12 04:41:30.579','2023-04-12 06:41:30.579'),('1b9e7359-42f9-45c8-9ddf-605c192e8a57',662,'/var/.data/2020/662/2b4f07b1-1d58-42a2-9e72-3461efd5a2d9/session_801b987d-e335-4276-8bc6-1fa57b553716/occlusion_1a616ac1-2ca3-4d23-ae5e-349558c26c37/scan_7fad3bba-f2b2-41ce-849b-756d995c0414/5_w2_o1_maxillaire_snapshot_0.png','PATIENT_2b4f07b1-1d58-42a2-9e72-3461efd5a2d9_ACT_801b987d-e335-4276-8bc6-1fa57b553716_SESS_1a616ac1-2ca3-4d23-ae5e-349558c26c37_TOSC_7fad3bba-f2b2-41ce-849b-756d995c0414_SNAPS','5_w2_o1_maxillaire_snapshot_0.png','1b9e7359-42f9-45c8-9ddf-605c192e8a57','{\"displayTitle\":\"Maxillaire 1.5.2.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-11 07:49:58.000','2023-06-13 12:02:10.453','2023-06-13 14:02:10.453'),('1cc559c6-7d48-11ea-947d-226cec7cb58a',662,'/var/.data/2020/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/1cc559c6-7d48-11ea-947d-226cec7cb58a.png','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_ec084612-67a2-4430-ae15-7fe0edeaca64_SESS_78636467-a73b-4270-8bc5-35a2664dec9d_BOSC_7f9aec2d-6246-4413-842d-78d2e0bddb1e_SNAPS','2_w3_o1_mandibule_snapshot_0.png','1cc559c6-7d48-11ea-947d-226cec7cb58a','{\"displayTitle\":\"MANDIBULE 1.2.3.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-12 07:48:40.000','2023-06-13 12:02:21.862','2023-06-13 14:02:21.862'),('1cc71f0a-7d48-11ea-947d-226cec7cb58a',662,'/var/.data/2020/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/1cc71f0a-7d48-11ea-947d-226cec7cb58a.ply','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_ec084612-67a2-4430-ae15-7fe0edeaca64_SESS_78636467-a73b-4270-8bc5-35a2664dec9d_BOSC_7f9aec2d-6246-4413-842d-78d2e0bddb1e_MODEL','2_w3_o1_mandibule_scan_file_0.ply','1cc71f0a-7d48-11ea-947d-226cec7cb58a','{\"displayTitle\":\"MANDIBULE 1.2.3.1.1\",\"modelMatrix\":\"0.752992,0.641783,-0.145319,0,-0.65803,0.7344,-0.166291,0,-1.17478e-9,0.22084,0.97531,0,-15.7633,9.54111,-26.582,1\",\"title\":\"MANDIBULE PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-12 07:48:40.000','2023-06-13 12:02:21.870','2023-06-13 14:02:21.870'),('1cf0bff8-7d48-11ea-947d-226cec7cb58a',662,'/var/.data/2020/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/1cf0bff8-7d48-11ea-947d-226cec7cb58a.png','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_ec084612-67a2-4430-ae15-7fe0edeaca64_SESS_78636467-a73b-4270-8bc5-35a2664dec9d_BOSC_7f9aec2d-6246-4413-842d-78d2e0bddb1e_SNAPS','2_w3_o1_mandibule_snapshot_0.png','1cf0bff8-7d48-11ea-947d-226cec7cb58a','{\"displayTitle\":\"MANDIBULE 1.2.3.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-12 07:48:40.000','2023-06-13 12:02:21.808','2023-06-13 14:02:21.808'),('1cf2d4d9-7d48-11ea-947d-226cec7cb58a',662,'/var/.data/2020/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/1cf2d4d9-7d48-11ea-947d-226cec7cb58a.ply','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_ec084612-67a2-4430-ae15-7fe0edeaca64_SESS_78636467-a73b-4270-8bc5-35a2664dec9d_BOSC_7f9aec2d-6246-4413-842d-78d2e0bddb1e_MODEL','2_w3_o1_mandibule_scan_file_0.ply','1cf2d4d9-7d48-11ea-947d-226cec7cb58a','{\"displayTitle\":\"MANDIBULE 1.2.3.1.1\",\"modelMatrix\":\"0.752992,0.641783,-0.145319,0,-0.65803,0.7344,-0.166291,0,-1.17478e-9,0.22084,0.97531,0,-15.7633,9.54111,-26.582,1\",\"title\":\"MANDIBULE PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-12 07:48:40.000','2023-06-13 12:02:21.820','2023-06-13 14:02:21.820'),('1d20464f-7d48-11ea-947d-226cec7cb58a',662,'/var/.data/2020/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/1d20464f-7d48-11ea-947d-226cec7cb58a.pdf','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_ec084612-67a2-4430-ae15-7fe0edeaca64_PROST_fce8aef9-22f3-446a-bd23-7f6a283417dc_FORM','2_w3_autre_prost_file_0.pdf','1d20464f-7d48-11ea-947d-226cec7cb58a','{\"displayTitle\":\"AUTRE FICHE PROTHÉTIQUE 1.2.3.1 AUTRE FICHE PROTHÉTIQUE\",\"title\":\"Autre PDF\"}','PDF',0,'SYNCED',0,NULL,'2020-04-12 08:28:40.000','2023-06-13 12:02:21.839','2023-06-13 14:02:21.839'),('1e115805-b191-4113-972e-a4489d95599a',662,'/var/.data/2021/662/03ec19f1-9f11-4710-a0cd-c5d7739e40d7/session_f474819e-9470-4612-8275-2ceb25b5522f/occlusion_484ae4d8-329f-49b5-8d83-312a8a92ff22/scan_d4c7f3c5-155d-41ef-8665-852e89c5e017/16_w1_o1_mordu_posterieur_droit_snapshot_0.png','PATIENT_03ec19f1-9f11-4710-a0cd-c5d7739e40d7_ACT_f474819e-9470-4612-8275-2ceb25b5522f_SESS_484ae4d8-329f-49b5-8d83-312a8a92ff22_RISC_d4c7f3c5-155d-41ef-8665-852e89c5e017_SNAPS','16_w1_o1_mordu_posterieur_droit_snapshot_0.png','1e115805-b191-4113-972e-a4489d95599a','{\"displayTitle\":\"Mordu posterieur droit 1.16.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-02-27 10:48:13.000','2023-06-13 12:02:09.862','2023-06-13 14:02:09.862'),('1e3c210c-a983-4276-916c-6c49b0e64e1d',662,'/var/.data/2020/662/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/occlusion_d402edb5-8449-46a8-862f-a1cd1ee21cf6/scan_87a0a17a-c973-40c2-9d84-2392b0d62afb/10_w1_o1_maxillaire_snapshot_1.png','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_SESS_d402edb5-8449-46a8-862f-a1cd1ee21cf6_TOSC_87a0a17a-c973-40c2-9d84-2392b0d62afb_SNAPS','10_w1_o1_maxillaire_snapshot_1.png','477bef20-19c4-472b-89d8-912285f5e534','{\"displayTitle\":\"Maxillaire 1.10.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2020-04-30 19:37:47.000','2023-06-13 12:02:12.398','2023-06-13 14:02:12.398'),('1e41852a-1d94-44eb-90f9-b06c401ee8b7',662,'/var/.data/2022/662/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_129a6c33-3cca-43ab-b97a-56d0e82a546f/occlusion_b5b4db66-f433-46fb-b794-d632b8fe8e1d/scan_ed495283-b756-4052-ba8b-5fe9f9b1f8be/19_w3_o1_maxillaire_scan_file_1.zip','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_129a6c33-3cca-43ab-b97a-56d0e82a546f_SESS_b5b4db66-f433-46fb-b794-d632b8fe8e1d_TOSC_ed495283-b756-4052-ba8b-5fe9f9b1f8be_MODEL','19_w3_o1_maxillaire_scan_file_1.zip','53ebdc66-a057-4dc0-8a89-3e9bc7e5d11d','{\"displayTitle\":\"Maxillaire 1.19.3.1.1\",\"modelMatrix\":\"0.997618,-0.0632367,0.0275495,0,0.0689772,0.914593,-0.398449,0,-2.86851e-09,0.3994,0.916777,0,-21.303,5.53173,-20.191,1\",\"title\":\"Maxillaire ZIP\"}','ZIP',1,'SYNCED',0,NULL,'2022-11-02 12:30:09.000','2023-06-13 12:02:13.633','2023-06-13 14:02:13.633'),('1e553911-8121-11ed-a752-9ec33d03e6dd',662,'/var/.data/2022/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/1e553911-8121-11ed-a752-9ec33d03e6dd.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_848b25bd-90a8-4105-871d-f9326fe94c7b_SESS_ba7da56a-5a10-4378-a887-8e98aa892a3c_TOSC_b002027b-930d-4b96-a687-453aeea5659e_MODEL','21_w6_o1_maxillaire_scan_file_1.zip','1e553911-8121-11ed-a752-9ec33d03e6dd','{\"displayTitle\":\"Maxillaire 1.21.6.1.1\",\"modelMatrix\":\"-0.98152,0.181469,-0.0607201,0,-0.191358,-0.930797,0.311448,0,-2.35099e-09,0.317312,0.948321,0,15.3508,-15.1772,-24.8569,1\",\"title\":\"Maxillaire ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-12-21 12:14:32.000','2023-06-13 12:02:23.464','2023-06-13 14:02:23.464'),('1e57cf4d-8121-11ed-a752-9ec33d03e6dd',662,'/var/.data/2022/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/1e57cf4d-8121-11ed-a752-9ec33d03e6dd.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_848b25bd-90a8-4105-871d-f9326fe94c7b_SESS_ba7da56a-5a10-4378-a887-8e98aa892a3c_TOSC_b002027b-930d-4b96-a687-453aeea5659e_SNAPS','21_w6_o1_maxillaire_snapshot_1.png','1e57cf4d-8121-11ed-a752-9ec33d03e6dd','{\"displayTitle\":\"Maxillaire 1.21.6.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-12-21 12:14:30.000','2023-06-13 12:02:23.481','2023-06-13 14:02:23.481'),('1e81852e-fdc6-4523-9e33-47494d60d953',662,'/var/.data/2020/662/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/occlusion_d402edb5-8449-46a8-862f-a1cd1ee21cf6/scan_a93c6a8f-0c96-47ae-bc72-75a725946a5a/10_w1_o1_mordu_anterieur_snapshot_0.png','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_SESS_d402edb5-8449-46a8-862f-a1cd1ee21cf6_FRSC_a93c6a8f-0c96-47ae-bc72-75a725946a5a_SNAPS','10_w1_o1_mordu_anterieur_snapshot_0.png','1e81852e-fdc6-4523-9e33-47494d60d953','{\"displayTitle\":\"Mordu anterieur 1.10.1.1.1\",\"title\":\"MORDU_ANTERIEUR SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-30 20:08:26.000','2023-06-13 12:02:12.425','2023-06-13 14:02:12.425'),('1e84d5d4-6768-4dde-a7cf-ca40a6d4261e',662,'/var/.data/2021/662/03ec19f1-9f11-4710-a0cd-c5d7739e40d7/session_f474819e-9470-4612-8275-2ceb25b5522f/occlusion_484ae4d8-329f-49b5-8d83-312a8a92ff22/scan_19627cd9-e6e6-4c6f-9a62-46d708ca49bc/16_w1_o1_mandibule_scan_file_0.ply','PATIENT_03ec19f1-9f11-4710-a0cd-c5d7739e40d7_ACT_f474819e-9470-4612-8275-2ceb25b5522f_SESS_484ae4d8-329f-49b5-8d83-312a8a92ff22_BOSC_19627cd9-e6e6-4c6f-9a62-46d708ca49bc_MODEL','16_w1_o1_mandibule_scan_file_0.ply','1e84d5d4-6768-4dde-a7cf-ca40a6d4261e','{\"displayTitle\":\"Mandibule 1.16.1.1.1\",\"modelMatrix\":\"-0.991646,-0.117448,0.053323,0,0.128986,-0.902943,0.409947,0,-2.46916e-9,0.413401,0.910549,0,13.5221,0.587114,-23.5741,1\",\"title\":\"Mandibule PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-02-27 10:43:29.000','2023-06-13 12:02:09.842','2023-06-13 14:02:09.842'),('1f02ce0a-9100-460e-987f-c2b91eda5ac1',662,'/var/.data/2020/662/2b4f07b1-1d58-42a2-9e72-3461efd5a2d9/session_934f20d2-7444-4367-89e2-61c3bf4bee57/occlusion_ada38401-e257-4f32-8319-c7a394ce4463/scan_375f8fb7-d198-4281-9948-bba81b98e824/5_w1_o1_maxillaire_snapshot_0.png','PATIENT_2b4f07b1-1d58-42a2-9e72-3461efd5a2d9_ACT_934f20d2-7444-4367-89e2-61c3bf4bee57_SESS_ada38401-e257-4f32-8319-c7a394ce4463_TOSC_375f8fb7-d198-4281-9948-bba81b98e824_SNAPS','5_w1_o1_maxillaire_snapshot_0.png','1f02ce0a-9100-460e-987f-c2b91eda5ac1','{\"displayTitle\":\"Maxillaire 1.5.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-10 07:44:49.000','2023-06-13 12:02:10.409','2023-06-13 14:02:10.409'),('1f154183-a975-4dfa-b4eb-fea963eb0d6c',662,'/var/.data/2022/662/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_7841125a-11dd-4b66-9179-cd371ea2f0f7/occlusion_12115366-8eb9-470b-a097-5d28bb5fdf38/scan_f0b63e95-26e8-4213-a935-ca2c37ab36ba/23_w1_o1_mandibule_snapshot_0.png','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_BOSC_f0b63e95-26e8-4213-a935-ca2c37ab36ba_SNAPS','23_w1_o1_mandibule_snapshot_0.png','1f154183-a975-4dfa-b4eb-fea963eb0d6c','{\"displayTitle\":\"Mandibule 1.23.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-01-11 12:31:09.000','2023-06-13 12:02:13.096','2023-06-13 14:02:13.096'),('1f29b918-27fd-422b-b4dd-da18687d0871',662,'/var/.data/2022/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_87965ef8-01eb-4830-8e8b-8b99ece62cf1/occlusion_dce9ce0f-0933-4c98-af84-59e2b6395f8f/scan_bd51414b-f96e-4903-a2e2-44fb3189decd/21_w2_o1_mandibule_scan_file_0.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_87965ef8-01eb-4830-8e8b-8b99ece62cf1_SESS_dce9ce0f-0933-4c98-af84-59e2b6395f8f_BOSC_bd51414b-f96e-4903-a2e2-44fb3189decd_MODEL','21_w2_o1_mandibule_scan_file_0.zip','1f29b918-27fd-422b-b4dd-da18687d0871','{\"displayTitle\":\"Mandibule 1.21.2.1.1\",\"modelMatrix\":\"-0.986862,-0.158046,0.0335479,0,0.161567,-0.965353,0.204912,0,1.94036e-09,0.207641,0.978205,0,11.2897,10.9357,-20.1333,1\",\"title\":\"Mandibule ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-06-27 20:48:30.000','2023-06-13 12:02:13.325','2023-06-13 14:02:13.325'),('1f608503-4867-4253-a143-dd200e0ebe0a',662,'/var/.data/2020/662/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/occlusion_d402edb5-8449-46a8-862f-a1cd1ee21cf6/scan_d52d9ce0-7fed-491c-a385-929e22fb07d5/10_w1_o1_mordu_posterieur_gauche_scan_file_0.ply','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_SESS_d402edb5-8449-46a8-862f-a1cd1ee21cf6_LESC_d52d9ce0-7fed-491c-a385-929e22fb07d5_MODEL','10_w1_o1_mordu_posterieur_gauche_scan_file_0.ply','1f608503-4867-4253-a143-dd200e0ebe0a','{\"displayTitle\":\"Mordu posterieur gauche 1.10.1.1.1\",\"modelMatrix\":\"-0.946697,-0.190841,0.259987,0,0.159057,-0.974311,-0.155988,0,0.280262,-0.120492,0.953019,0,-6.4606,0.717943,-18.6733,1\",\"title\":\"MORDU_POSTERIEUR_GAUCHE PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-30 20:05:04.000','2023-06-13 12:02:12.370','2023-06-13 14:02:12.370'),('1f629ca9-f822-4a93-aecc-1e8473c82dd5',662,'/var/.data/2020/662/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/order_03969eb4-0bb5-4cae-92e8-5cf65689757e/10_w1_autre_prost_file_0.pdf','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_PROST_03969eb4-0bb5-4cae-92e8-5cf65689757e_FORM','10_w1_autre_prost_file_0.pdf','1f629ca9-f822-4a93-aecc-1e8473c82dd5','{\"displayTitle\":\"AUTRE FICHE PROTHÉTIQUE 1.10.1.2 AUTRE FICHE PROTHÉTIQUE\",\"title\":\"Autre PDF\"}','PDF',0,'SYNCED',0,NULL,'2020-05-01 08:23:30.000','2023-06-13 12:02:17.762','2023-06-13 14:02:17.762'),('1f92b4ea-73e7-423b-8d75-46b280f139d9',662,'/var/.data/2021/662/f15cb858-4f0b-44ec-a017-5e662039ba19/session_72b7a457-e38f-4535-8eba-6c98b43e5e55/occlusion_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c/scan_437ef945-eb42-4841-9b20-34804bd5cfd6/14_w2_o1_mandibule_snapshot_0.png','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_72b7a457-e38f-4535-8eba-6c98b43e5e55_SESS_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c_BOSC_437ef945-eb42-4841-9b20-34804bd5cfd6_SNAPS','14_w2_o1_mandibule_snapshot_0.png','1f92b4ea-73e7-423b-8d75-46b280f139d9','{\"displayTitle\":\"Mandibule 1.14.2.1.2\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-06-08 20:38:08.000','2023-06-13 12:02:12.297','2023-06-13 14:02:12.297'),('1fe4acd9-cda1-4289-bd11-70fec38115e5',662,'/var/.data/2021/662/f15cb858-4f0b-44ec-a017-5e662039ba19/session_72b7a457-e38f-4535-8eba-6c98b43e5e55/occlusion_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c/scan_44b8a221-3707-430b-bc84-cacca7bf7d8a/14_w2_o1_mordu_posterieur_gauche_scan_file_0.ply','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_72b7a457-e38f-4535-8eba-6c98b43e5e55_SESS_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c_LESC_44b8a221-3707-430b-bc84-cacca7bf7d8a_MODEL','14_w2_o1_mordu_posterieur_gauche_scan_file_0.ply','1fe4acd9-cda1-4289-bd11-70fec38115e5','{\"displayTitle\":\"Mordu posterieur gauche 1.14.2.1.1\",\"modelMatrix\":\"-0.941444,-0.248278,0.234058,0,0.235207,-0.968666,-0.0644604,0,0.241612,-0.0086103,0.970092,0,-7.55676,1.35799,-18.282,1\",\"title\":\"Mordu posterieur gauche PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-06-08 20:51:49.000','2023-06-13 12:02:12.334','2023-06-13 14:02:12.334'),('20195b26-5345-4f9f-bbd5-4e2ac9fd972d',662,'/var/.data/2021/662/5587321c-4405-49dc-90d5-8810cc776c6d/session_7e359a5f-1756-4ec7-8657-3e5940ae489d/occlusion_b29b47d4-35f8-427d-9cd7-a393e48be2cf/scan_881d38cc-cf89-4329-8456-b90f8c997725/20_w1_o1_mordu_anterieur_snapshot_0.png','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_FRSC_881d38cc-cf89-4329-8456-b90f8c997725_SNAPS','20_w1_o1_mordu_anterieur_snapshot_0.png','20195b26-5345-4f9f-bbd5-4e2ac9fd972d','{\"displayTitle\":\"Mordu anterieur 1.20.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-10-12 12:44:16.000','2023-06-13 12:02:12.664','2023-06-13 14:02:12.664'),('20926382-91ae-11ed-a752-9ec33d03e6dd',662,'/var/.data/2023/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/20926382-91ae-11ed-a752-9ec33d03e6dd.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_2c78d514-95bd-4529-b0a1-babfb83849b1_SESS_983c39b6-656b-4bf2-bf43-da1625adb861_BOSC_209f3c55-7380-4efa-8e6c-dfe8c99792a6_MODEL','21_w7_o1_mandibule_scan_file_5.zip','20926382-91ae-11ed-a752-9ec33d03e6dd','{\"displayTitle\":\"Mandibule 1.21.7.1.1\",\"modelMatrix\":\"0.945306,0.320976,-0.0580515,0,-0.326184,0.930215,-0.168238,0,-4.4664e-09,0.177972,0.984036,0,-19.5184,-20.4309,-20.5509,1\",\"title\":\"Mandibule ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2023-01-11 12:58:29.000','2023-06-13 12:02:23.435','2023-06-13 14:02:23.435'),('209476bb-91ae-11ed-a752-9ec33d03e6dd',662,'/var/.data/2023/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/209476bb-91ae-11ed-a752-9ec33d03e6dd.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_2c78d514-95bd-4529-b0a1-babfb83849b1_SESS_983c39b6-656b-4bf2-bf43-da1625adb861_BOSC_209f3c55-7380-4efa-8e6c-dfe8c99792a6_SNAPS','21_w7_o1_mandibule_snapshot_5.png','209476bb-91ae-11ed-a752-9ec33d03e6dd','{\"displayTitle\":\"Mandibule 1.21.7.1.1\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2023-01-11 12:58:26.000','2023-06-13 12:02:23.444','2023-06-13 14:02:23.444'),('2129ad39-4745-4e82-a5b8-dcf7933c6ae7',662,'','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_RISC_d3a42d3d-3d98-457b-bb64-4119091b03f9_MODEL','7_w2_o2_mordu_posterieur_droit_scan_file_0.ply','2129ad39-4745-4e82-a5b8-dcf7933c6ae7','{\"displayTitle\":\"MORDU_POSTERIEUR_DROIT 1.7.2.2.1\",\"modelMatrix\":\"0.996436,-0.0417849,0.0747689,0,0.0270536,0.952167,0.302573,0,-0.0805792,-0.302841,0.950213,0,-13.0357,5.641,-33.0669,1\",\"title\":\"MORDU_POSTERIEUR_DROIT PLY\"}','PLY',0,'SYNCED',0,'2023-04-12 06:40:15.000','2020-04-15 07:37:21.000','2023-06-13 12:02:15.565','2023-06-13 14:02:15.565'),('214a04d1-1997-4654-8226-87b79966583e',662,'/var/.data/2021/662/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_79548cb6-a61f-44cb-b6f7-cab7698f7465/14_w1_o1_mordu_posterieur_droit_snapshot_1.png','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_RISC_79548cb6-a61f-44cb-b6f7-cab7698f7465_SNAPS','14_w1_o1_mordu_posterieur_droit_snapshot_1.png','5c991e5c-3b6f-409c-839c-1ed086c26caf','{\"displayTitle\":\"Mordu posterieur droit 1.14.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2021-02-01 21:15:42.000','2023-06-13 12:02:09.595','2023-06-13 14:02:09.595'),('222a29ad-e959-403d-b53b-f17d1e53bc93',662,'/var/.data/2022/662/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_949fe730-88fa-4ec2-852e-dd0772ee3ee0/occlusion_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d/scan_1c6adc05-0655-4ad6-bcc9-27b0ef578ded/19_w2_o1_maxillaire_scan_file_3.zip','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_949fe730-88fa-4ec2-852e-dd0772ee3ee0_SESS_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d_TOSC_1c6adc05-0655-4ad6-bcc9-27b0ef578ded_MODEL','19_w2_o1_maxillaire_scan_file_3.zip','a1bc9da2-af83-43c3-8210-759800158585','{\"displayTitle\":\"Maxillaire 1.19.2.1.1\",\"modelMatrix\":\"-0.949742,0.301409,-0.0845116,0,-0.313033,-0.914475,0.256409,0,5.32806e-10,0.269977,0.962867,0,9.73869,-14.5525,-27.4476,1\",\"title\":\"Maxillaire ZIP\"}','ZIP',3,'SYNCED',0,NULL,'2022-06-28 20:34:09.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.085'),('229d55f2-d907-49a9-ae4c-c2359e8ce810',662,'/var/.data/2020/662/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/occlusion_b87f1382-55d4-4e52-b63a-6f387df18b16/scan_ecd2beec-0c29-40e2-ab95-64009c33fa40/13_w4_o1_mordu_posterieur_droit_scan_file_0.ply','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_SESS_b87f1382-55d4-4e52-b63a-6f387df18b16_RISC_ecd2beec-0c29-40e2-ab95-64009c33fa40_MODEL','13_w4_o1_mordu_posterieur_droit_scan_file_0.ply','229d55f2-d907-49a9-ae4c-c2359e8ce810','{\"displayTitle\":\"Mordu posterieur droit 1.13.4.1.1\",\"modelMatrix\":\"0.898262,-0.0473058,0.435366,0,0.0416943,0.998418,-0.00872949,0,-0.437779,0.0343256,0.900219,0,1.69242,5.98523,-22.1624,1\",\"title\":\"Mordu posterieur droit PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-12-29 11:30:30.000','2023-06-13 12:02:10.553','2023-06-13 14:02:10.553'),('22b17811-0494-42ee-a82c-e9e5fe8e4ae4',662,'/var/.data/2020/662/2b4f07b1-1d58-42a2-9e72-3461efd5a2d9/session_bc967a6b-ad1a-4a59-aab8-92332e4217b0/order_b1c50855-9551-467e-94d9-915a6218ec1b/5_w3_gouttiere_prost_file_0.pdf','PATIENT_2b4f07b1-1d58-42a2-9e72-3461efd5a2d9_ACT_bc967a6b-ad1a-4a59-aab8-92332e4217b0_PROST_b1c50855-9551-467e-94d9-915a6218ec1b_FORM','5_w3_gouttiere_prost_file_0.pdf','22b17811-0494-42ee-a82c-e9e5fe8e4ae4','{\"displayTitle\":\"GOUTTIÈRE 1.5.3.1 GOUTTIÈRE\",\"title\":\"Gouttiere PDF\"}','PDF',0,'SYNCED',0,NULL,'2020-07-13 19:47:48.000','2023-04-12 04:40:16.083','2023-04-12 06:40:16.083'),('23066de9-fbda-436c-bd8b-dacb5721c390',662,'/var/.data/2021/662/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_e6c99474-f6f6-447f-bcaa-d4c791811e18/14_w1_o1_mandibule_scan_file_0.ply','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_BOSC_e6c99474-f6f6-447f-bcaa-d4c791811e18_MODEL','14_w1_o1_mandibule_scan_file_0.ply','23066de9-fbda-436c-bd8b-dacb5721c390','{\"displayTitle\":\"Mandibule 1.14.1.1.2\",\"modelMatrix\":\"-0.518382,0.847389,-0.114947,0,-0.855149,-0.513677,0.0696797,0,-3.29347e-9,0.134418,0.990925,0,9.65563,-5.82988,-22.2463,1\",\"title\":\"Mandibule PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-02-01 21:09:31.000','2023-06-13 12:02:09.566','2023-06-13 14:02:09.566'),('23251874-b8f3-48b3-b209-0b434edd5db0',662,'/var/.data/2020/662/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/occlusion_b87f1382-55d4-4e52-b63a-6f387df18b16/scan_a26f0d58-ca46-4921-a9e1-9c39b7f89783/13_w4_o1_maxillaire_scan_file_0.ply','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_SESS_b87f1382-55d4-4e52-b63a-6f387df18b16_TOSC_a26f0d58-ca46-4921-a9e1-9c39b7f89783_MODEL','13_w4_o1_maxillaire_scan_file_0.ply','23251874-b8f3-48b3-b209-0b434edd5db0','{\"displayTitle\":\"Maxillaire PLY\",\"modelMatrix\":\"-0.750188,0.653787,-0.0989001,0,-0.661225,-0.741749,0.112206,0,-7.67185e-9,0.149571,0.988751,0,10.4824,-1.97924,-22.9424,1\",\"title\":\"Maxillaire PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-12-29 11:00:28.000','2023-06-13 12:02:09.504','2023-06-13 14:02:09.504'),('2367f698-7e4f-4e60-b31f-752903f8cd34',662,'/var/.data/2022/662/665b40ce-9690-4944-b007-4a96c1f5d57d/session_8f87b136-cb98-4706-b7d4-51059e1afa06/occlusion_5f895907-3eed-4aa7-995a-f7e1c9661a0a/scan_802e2d49-5b37-47b7-b8e9-4fb4bff1f62f/25_w1_o1_maxillaire_snapshot_0.png','PATIENT_665b40ce-9690-4944-b007-4a96c1f5d57d_ACT_8f87b136-cb98-4706-b7d4-51059e1afa06_SESS_5f895907-3eed-4aa7-995a-f7e1c9661a0a_TOSC_802e2d49-5b37-47b7-b8e9-4fb4bff1f62f_SNAPS','25_w1_o1_maxillaire_snapshot_0.png','2367f698-7e4f-4e60-b31f-752903f8cd34','{\"displayTitle\":\"Maxillaire 1.25.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-03-11 11:13:45.000','2023-06-13 12:02:13.252','2023-06-13 14:02:13.252'),('245640ab-9c9d-4467-bd40-a48ae0ff49d0',662,'','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_FRSC_0c8af1cb-8054-4a35-9cfe-449c19dbe59b_SNAPS','7_w2_o2_mordu_anterieur_snapshot_0.png','245640ab-9c9d-4467-bd40-a48ae0ff49d0','{\"displayTitle\":\"MORDU_ANTERIEUR 1.7.2.2.2\",\"title\":\"MORDU_ANTERIEUR SNAPSHOT\"}','PNG',0,'SYNCED',0,'2023-04-12 06:40:16.000','2020-04-16 07:10:44.000','2023-06-13 12:02:15.123','2023-06-13 14:02:15.123'),('24c23cdd-d323-4623-8a9d-2d3e14f3b937',662,'/var/.data/2020/662/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/occlusion_b87f1382-55d4-4e52-b63a-6f387df18b16/scan_a26f0d58-ca46-4921-a9e1-9c39b7f89783/13_w4_o1_maxillaire_snapshot_0.png','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_SESS_b87f1382-55d4-4e52-b63a-6f387df18b16_TOSC_a26f0d58-ca46-4921-a9e1-9c39b7f89783_SNAPS','13_w4_o1_maxillaire_snapshot_0.png','24c23cdd-d323-4623-8a9d-2d3e14f3b937','{\"displayTitle\":\"Maxillaire SNAPSHOT\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-12-29 11:00:28.000','2023-06-13 12:02:09.479','2023-06-13 14:02:09.479'),('252b180c-565f-4f14-af48-a16cebbead9e',662,'/var/.data/2023/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_2c78d514-95bd-4529-b0a1-babfb83849b1/occlusion_983c39b6-656b-4bf2-bf43-da1625adb861/scan_209f3c55-7380-4efa-8e6c-dfe8c99792a6/21_w7_o1_mandibule_snapshot_0.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_2c78d514-95bd-4529-b0a1-babfb83849b1_SESS_983c39b6-656b-4bf2-bf43-da1625adb861_BOSC_209f3c55-7380-4efa-8e6c-dfe8c99792a6_SNAPS','21_w7_o1_mandibule_snapshot_0.png','252b180c-565f-4f14-af48-a16cebbead9e','{\"displayTitle\":\"Mandibule 1.21.7.1.1\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2023-01-11 12:21:43.000','2023-06-13 12:02:15.044','2023-06-13 14:02:15.044'),('2554e0bc-d621-46e3-90e6-f7d7f2085b98',662,'/var/.data/2020/662/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_bdf42f40-5a7a-435b-a5e0-eb33efefbc97/scan_de216c91-485b-4dac-9e7c-b89075739521/6_w1_o1_mandibule_scan_file_0.ply','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_bdf42f40-5a7a-435b-a5e0-eb33efefbc97_BOSC_de216c91-485b-4dac-9e7c-b89075739521_MODEL','6_w1_o1_mandibule_scan_file_0.ply','2554e0bc-d621-46e3-90e6-f7d7f2085b98','{\"displayTitle\":\"Mandibule 1.6.1.1.1\",\"modelMatrix\":\"-0.37781,-0.890063,0.255044,0,0.925883,-0.363193,0.104072,0,5.24379e-10,0.275461,0.961312,0,-11.6328,2.9902,-23.8552,1\",\"title\":\"MANDIBULE PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-10 11:13:08.000','2023-06-13 12:02:10.184','2023-06-13 14:02:10.184'),('25d2e57a-b759-4ab8-a633-7725e7375d70',662,'/var/.data/2021/662/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_0c1ed331-8df6-482e-8dd1-508d9b190c49/occlusion_6c6bb813-840d-454a-ab1d-9232434a4500/scan_ef79558a-21cf-4117-a0b7-ba0adf40f7dc/19_w1_o1_mordu_anterieur_scan_file_0.ply','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_FRSC_ef79558a-21cf-4117-a0b7-ba0adf40f7dc_MODEL','19_w1_o1_mordu_anterieur_scan_file_0.ply','25d2e57a-b759-4ab8-a633-7725e7375d70','{\"displayTitle\":\"Mordu anterieur 1.19.1.1.1\",\"modelMatrix\":\"0.84619,0.0571101,0.515766,0,-0.00658361,0.991989,-0.141669,0,-0.533379,0.115223,0.845157,0,-3.68638,-6.26512,-27.8081,1\",\"title\":\"Mordu anterieur PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-09-27 12:49:22.000','2023-06-13 12:02:12.548','2023-06-13 14:02:12.548'),('2607735b-f648-4b52-882f-e91b883da1be',662,'/var/.data/2021/662/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_0c1ed331-8df6-482e-8dd1-508d9b190c49/occlusion_6c6bb813-840d-454a-ab1d-9232434a4500/scan_99a6d55d-de66-49eb-a717-49cb2587fbef/19_w1_o1_mordu_posterieur_droit_snapshot_0.png','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_RISC_99a6d55d-de66-49eb-a717-49cb2587fbef_SNAPS','19_w1_o1_mordu_posterieur_droit_snapshot_0.png','2607735b-f648-4b52-882f-e91b883da1be','{\"displayTitle\":\"Mordu posterieur droit 1.19.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-09-27 12:45:21.000','2023-06-13 12:02:12.509','2023-06-13 14:02:12.509'),('2632ca9d-afe6-4104-a347-d590758abfc0',662,'/var/.data/2020/662/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_bdf42f40-5a7a-435b-a5e0-eb33efefbc97/scan_de216c91-485b-4dac-9e7c-b89075739521/6_w1_o1_mandibule_snapshot_0.png','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_bdf42f40-5a7a-435b-a5e0-eb33efefbc97_BOSC_de216c91-485b-4dac-9e7c-b89075739521_SNAPS','6_w1_o1_mandibule_snapshot_0.png','2632ca9d-afe6-4104-a347-d590758abfc0','{\"displayTitle\":\"Mandibule 1.6.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-10 11:13:08.000','2023-06-13 12:02:10.192','2023-06-13 14:02:10.192'),('26c13801-12d8-430d-ae6c-429cbe801e77',662,'/var/.data/2021/662/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_643b3b5a-e991-4dbf-95c8-2fd609f83a8b/14_w1_o1_maxillaire_snapshot_3.png','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_TOSC_643b3b5a-e991-4dbf-95c8-2fd609f83a8b_SNAPS','14_w1_o1_maxillaire_snapshot_3.png','3d7bd9ef-9d44-4365-af74-4d2a31f8f2fb','{\"displayTitle\":\"Maxillaire 1.14.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',3,'SYNCED',0,NULL,'2021-02-01 20:41:18.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.098'),('27755e68-98ae-4662-a39e-c3ea4ba3cdd4',662,'','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_PROST_118a8411-96d0-412f-a2fd-6e990b04bf34_FORM','7_w2_odf_prost_file_0.pdf','27755e68-98ae-4662-a39e-c3ea4ba3cdd4','{\"displayTitle\":\"ODF 1.7.2.2 ODF\",\"title\":\"Odf PDF\"}','PDF',0,'SYNCED',0,'2023-04-12 06:40:16.000','2020-04-15 08:51:44.000','2023-06-13 12:02:17.668','2023-06-13 14:02:17.668'),('29be6b15-58e7-42cd-824d-34b15f20be76',662,'','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_72b7a457-e38f-4535-8eba-6c98b43e5e55_SESS_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c_BOSC_34f5d93d-6a1f-4f94-ab20-4105c2cce30a_MODEL','14_w2_o1_mandibule_scan_file_0.ply','29be6b15-58e7-42cd-824d-34b15f20be76','{\"displayTitle\":\"Mandibule 1.14.2.1.1\",\"modelMatrix\":\"-0.315513,0.844692,-0.432375,0,-0.948921,-0.280857,0.143763,0,-6.33774e-10,0.455649,0.89016,0,3.51554,-8.30009,-16.7888,1\",\"title\":\"Mandibule PLY\"}','PLY',0,'SYNCED',0,'2023-04-12 06:40:16.000','2021-06-08 20:30:59.000','2023-06-13 12:02:12.249','2023-06-13 14:02:12.249'),('29d00f37-e846-46c5-bfea-08ec3e95b455',662,'/var/.data/2020/662/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_a18ca6df-d765-4c6a-be28-13abd1c350af/computedocclusion_a18ca6df-d765-4c6a-be28-13amigraoccl/6_w1_o2_maxillaire_occlusion_occ_file_0.ply','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_a18ca6df-d765-4c6a-be28-13abd1c350af_OCC_a18ca6df-d765-4c6a-be28-13amigraoccl_TOPLY','6_w1_o2_maxillaire_occlusion_occ_file_0.ply','29d00f37-e846-46c5-bfea-08ec3e95b455','{\"displayTitle\":\"Maxillaire Occlusion 1.6.1.2.1\",\"referenceScanID\":\"1.6.1.2.1\",\"title\":\"Maxillaire Occlusion PLY\",\"occlusionMatrix\":\"0.93844,0.137255,-0.317003,0,-0.245241,0.911002,-0.331559,0,0.243283,0.388891,0.888582,0,-19.6758,-3.12346,-22.8806,1\"}','PLY',0,'SYNCED',0,NULL,'2020-04-17 11:21:05.000','2023-06-13 12:02:16.197','2023-06-13 14:02:16.197'),('2a17666e-f40f-403e-88af-a4cfaf6332ec',662,'/var/.data/2021/662/03ec19f1-9f11-4710-a0cd-c5d7739e40d7/session_f474819e-9470-4612-8275-2ceb25b5522f/occlusion_484ae4d8-329f-49b5-8d83-312a8a92ff22/scan_d9ec0349-f28e-41d6-822f-e76c8c001da9/16_w1_o1_maxillaire_snapshot_0.png','PATIENT_03ec19f1-9f11-4710-a0cd-c5d7739e40d7_ACT_f474819e-9470-4612-8275-2ceb25b5522f_SESS_484ae4d8-329f-49b5-8d83-312a8a92ff22_TOSC_d9ec0349-f28e-41d6-822f-e76c8c001da9_SNAPS','16_w1_o1_maxillaire_snapshot_0.png','2a17666e-f40f-403e-88af-a4cfaf6332ec','{\"displayTitle\":\"Maxillaire 1.16.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-02-27 10:22:30.000','2023-06-13 12:02:09.829','2023-06-13 14:02:09.829'),('2a2002a5-6321-4c63-938e-7276412e6a28',662,'','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_BOSC_d2372948-816f-4d58-a2bf-288bc0e7b539_MODEL','7_w2_o2_mandibule_scan_file_1.ply','127e55bb-48e6-421e-ab6a-05b0763a843e','{\"displayTitle\":\"MANDIBULE 1.7.2.2.1\",\"modelMatrix\":\"0.798862,-0.59756,0.0688607,0,0.601515,0.79361,-0.0914527,0,-4.38586e-9,0.114479,0.993426,0,-2.73294,17.6652,-41.351,1\",\"title\":\"MANDIBULE PLY\"}','PLY',1,'SYNCED',0,'2023-04-12 06:40:17.000','2020-04-15 07:19:54.000','2023-06-13 12:02:15.530','2023-06-13 14:02:15.530'),('2aa2008a-2609-41f7-99c6-d3b7a4560466',662,'/var/.data/2020/662/406a8572-4b0f-480a-ad2e-daf5530143b6/session_a7b0f1ae-ce37-4faf-9b3c-e5fab6996549/occlusion_254f3fc9-4782-4658-bb34-f2ca1c9b6382/scan_e5fd24c7-49a8-4dbc-9356-3b96970d2515/2_w6_o1_maxillaire_snapshot_0.png','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_a7b0f1ae-ce37-4faf-9b3c-e5fab6996549_SESS_254f3fc9-4782-4658-bb34-f2ca1c9b6382_TOSC_e5fd24c7-49a8-4dbc-9356-3b96970d2515_SNAPS','2_w6_o1_maxillaire_snapshot_0.png','2aa2008a-2609-41f7-99c6-d3b7a4560466','{\"displayTitle\":\"Maxillaire 1.2.6.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-05-21 08:00:21.000','2023-06-13 12:02:10.391','2023-06-13 14:02:10.391'),('2b6d557d-ea43-42a5-bd7d-859d5a90f1a6',662,'/var/.data/2020/662/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/occlusion_b87f1382-55d4-4e52-b63a-6f387df18b16/scan_4a2eec76-a5f3-44f0-b389-4734998fa2d3/13_w4_o1_mandibule_scan_file_0.ply','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_SESS_b87f1382-55d4-4e52-b63a-6f387df18b16_BOSC_4a2eec76-a5f3-44f0-b389-4734998fa2d3_MODEL','13_w4_o1_mandibule_scan_file_0.ply','2b6d557d-ea43-42a5-bd7d-859d5a90f1a6','{\"displayTitle\":\"Mandibule PLY\",\"modelMatrix\":\"-0.96542,-0.259936,0.019913,0,0.260698,-0.9626,0.073742,0,-2.70615e-10,0.0763833,0.997078,0,9.74495,12.7263,-20.8261,1\",\"title\":\"Mandibule PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-12-29 11:20:13.000','2023-06-13 12:02:12.172','2023-06-13 14:02:12.172'),('2cff0ba7-eee7-4c7f-99af-34c690eb3868',662,'/var/.data/2022/662/5587321c-4405-49dc-90d5-8810cc776c6d/session_3eede325-0afb-43f5-9277-e22c18f8f927/occlusion_f72f6016-0f75-4789-9924-1bc9aa64c2f1/scan_254d7cff-f2aa-4d41-8b1c-7b0bdd6386ff/20_w2_o1_mandibule_scan_file_0.zip','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_3eede325-0afb-43f5-9277-e22c18f8f927_SESS_f72f6016-0f75-4789-9924-1bc9aa64c2f1_BOSC_254d7cff-f2aa-4d41-8b1c-7b0bdd6386ff_MODEL','20_w2_o1_mandibule_scan_file_0.zip','2cff0ba7-eee7-4c7f-99af-34c690eb3868','{\"displayTitle\":\"Mandibule 1.20.2.1.1\",\"modelMatrix\":\"0.909705,0.387142,-0.150193,0,-0.415255,0.848117,-0.329031,0,9.51155e-09,0.36169,0.932299,0,-8.74595,-28.9367,-15.18,1\",\"title\":\"Mandibule ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-08-06 13:56:38.000','2023-06-13 12:02:13.486','2023-06-13 14:02:13.486'),('2d1d8d21-ec2c-485d-98af-375a4d8263d6',662,'/var/.data/2021/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_a90158f7-0d39-4b9d-984b-57de06099c65/21_w1_o1_maxillaire_snapshot_0.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_TOSC_a90158f7-0d39-4b9d-984b-57de06099c65_SNAPS','21_w1_o1_maxillaire_snapshot_0.png','2d1d8d21-ec2c-485d-98af-375a4d8263d6','{\"displayTitle\":\"Maxillaire 1.21.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-11-22 12:21:50.000','2023-06-13 12:02:12.797','2023-06-13 14:02:12.797'),('2ec9cc68-72e4-4237-9254-2374d936f630',662,'/var/.data/2020/662/1af643c4-44fe-4ccb-b545-dbc90b47633b/session_a6ab7edf-6040-4f1a-b898-a1120a854927/occlusion_e06b73d5-45f7-4906-ba73-560d66ac56af/scan_470d4798-40ea-4ce5-a574-22fcf013d82d/7_w4_o1_mordu_posterieur_droit_scan_file_0.ply','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_a6ab7edf-6040-4f1a-b898-a1120a854927_SESS_e06b73d5-45f7-4906-ba73-560d66ac56af_RISC_470d4798-40ea-4ce5-a574-22fcf013d82d_MODEL','7_w4_o1_mordu_posterieur_droit_scan_file_0.ply','2ec9cc68-72e4-4237-9254-2374d936f630','{\"displayTitle\":\"Mordu posterieur droit 1.7.4.1.1\",\"modelMatrix\":\"0.949504,-0.049291,0.270682,0,-0.0206689,0.968059,0.244397,0,-0.316154,-0.246141,0.932125,0,-12.5432,4.45695,-30.6874,1\",\"title\":\"MORDU_POSTERIEUR_DROIT PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-16 11:17:28.000','2023-06-13 12:02:10.063','2023-06-13 14:02:10.063'),('2fe7a2a7-6a20-4d12-ba81-6c46af5e0703',662,'/var/.data/2021/662/f15cb858-4f0b-44ec-a017-5e662039ba19/session_72b7a457-e38f-4535-8eba-6c98b43e5e55/occlusion_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c/scan_be9a4ba5-715b-4547-a31d-66621ec7b17f/14_w2_o1_maxillaire_scan_file_1.ply','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_72b7a457-e38f-4535-8eba-6c98b43e5e55_SESS_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c_TOSC_be9a4ba5-715b-4547-a31d-66621ec7b17f_MODEL','14_w2_o1_maxillaire_scan_file_1.ply','5498794c-1fcc-48dd-b50e-b57ca5d157ab','{\"displayTitle\":\"Maxillaire 1.14.2.1.1\",\"modelMatrix\":\"0.983577,0.180375,-0.006406,0,-0.180488,0.982957,-0.0349097,0,6.65026e-11,0.0354926,0.99937,0,-10.8448,5.00032,-24.3455,1\",\"title\":\"Maxillaire PLY\"}','PLY',1,'SYNCED',0,NULL,'2021-06-08 20:16:28.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.087'),('307db8a0-4cc4-49dc-9aca-9a7072712805',662,'/var/.data/2023/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_2c78d514-95bd-4529-b0a1-babfb83849b1/occlusion_983c39b6-656b-4bf2-bf43-da1625adb861/scan_209f3c55-7380-4efa-8e6c-dfe8c99792a6/21_w7_o1_mandibule_snapshot_3.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_2c78d514-95bd-4529-b0a1-babfb83849b1_SESS_983c39b6-656b-4bf2-bf43-da1625adb861_BOSC_209f3c55-7380-4efa-8e6c-dfe8c99792a6_SNAPS','21_w7_o1_mandibule_snapshot_3.png','252b180c-565f-4f14-af48-a16cebbead9e','{\"displayTitle\":\"Mandibule 1.21.7.1.1\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',3,'SYNCED',0,NULL,'2023-01-11 12:37:39.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.072'),('30e96914-828b-4376-9eeb-077529a3422d',662,'/var/.data/2022/662/665b40ce-9690-4944-b007-4a96c1f5d57d/session_8f87b136-cb98-4706-b7d4-51059e1afa06/occlusion_5f895907-3eed-4aa7-995a-f7e1c9661a0a/computedocclusion_c4999e75-8b1c-4a31-8e80-9b9cba9b57fd/25_w1_o1_maxillaire_occlusion_occ_file_0.zip','PATIENT_665b40ce-9690-4944-b007-4a96c1f5d57d_ACT_8f87b136-cb98-4706-b7d4-51059e1afa06_SESS_5f895907-3eed-4aa7-995a-f7e1c9661a0a_OCC_c4999e75-8b1c-4a31-8e80-9b9cba9b57fd_TOPLY','25_w1_o1_maxillaire_occlusion_occ_file_0.zip','30e96914-828b-4376-9eeb-077529a3422d','{\"displayTitle\":\"Maxillaire 1.25.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.25.1.1.1\",\"title\":\"Maxillaire 1.25.1.1.1 Occlusion 1\",\"occlusionMatrix\":\"0.210037,-0.637651,-0.741141,0,0.977663,0.130667,0.164645,0,-0.00814373,-0.759166,0.650853,0,-18.7522,26.2293,-6.90273,1\"}','ZIP',0,'SYNCED',0,NULL,'2022-03-11 11:16:26.000','2023-06-13 12:02:16.291','2023-06-13 14:02:16.291'),('31421697-5459-439e-919b-169d051646f5',662,'/var/.data/2020/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/31421697-5459-439e-919b-169d051646f5.ply','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_cb9d8495-b4dd-423f-a624-7cff70e4db55_SESS_c9d37315-5f17-421c-8afb-302fa9b0bebe_BOSC_6fafe104-bdc1-41a6-9977-b1bbb351a329_MODEL','2_w2_o1_mandibule_scan_file_1.ply','3e41d066-f22f-4b6c-bc5b-438bc17b2d84','{\"displayTitle\":\"MANDIBULE 1.2.2.1.1\",\"modelMatrix\":\"0.998917,-0.046407,0.00327279,0,0.0465222,0.996442,-0.0702729,0,2.41777e-10,0.070349,0.997522,0,-15.4826,-27.7313,-45.5726,1\",\"title\":\"MANDIBULE PLY\"}','PLY',1,'SYNCED',0,'2023-04-12 06:40:18.000','2020-04-07 06:42:41.000','2023-06-13 12:02:15.295','2023-06-13 14:02:15.295'),('31b407a6-51a1-4581-a381-00a2955c6d4d',662,'/var/.data/2021/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_a90158f7-0d39-4b9d-984b-57de06099c65/21_w1_o1_maxillaire_scan_file_1.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_TOSC_a90158f7-0d39-4b9d-984b-57de06099c65_MODEL','21_w1_o1_maxillaire_scan_file_1.zip','8396da09-c9ea-476d-ab69-648f06ec6534','{\"displayTitle\":\"Maxillaire 1.21.1.1.1\",\"modelMatrix\":\"0.807465,0.588049,-0.0468876,0,-0.589915,0.804911,-0.0641789,0,-7.03104e-10,0.079482,0.996836,0,-19.0887,-4.61348,-20.8885,1\",\"title\":\"Maxillaire ZIP\"}','ZIP',1,'SYNCED',0,NULL,'2021-11-22 12:25:56.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.070'),('330dc645-80dc-4734-bc6a-ba2a87b5f495',662,'/var/.data/2021/662/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_0c1ed331-8df6-482e-8dd1-508d9b190c49/occlusion_6c6bb813-840d-454a-ab1d-9232434a4500/scan_50e1896b-8565-4257-9a61-2a685fff8165/19_w1_o1_mandibule_snapshot_1.png','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_BOSC_50e1896b-8565-4257-9a61-2a685fff8165_SNAPS','19_w1_o1_mandibule_snapshot_1.png','d455a946-5407-4abb-8fdb-711fb0adfe7c','{\"displayTitle\":\"Mandibule 1.19.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2021-09-27 12:43:41.000','2023-06-13 12:02:12.615','2023-06-13 14:02:12.615'),('35704ab9-18dc-4d80-81f3-5f50e93033c6',662,'/var/.data/2020/662/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_a18ca6df-d765-4c6a-be28-13abd1c350af/scan_cb1d5d31-89cd-4ab4-bada-dc6b2235cac5/6_w1_o2_maxillaire_snapshot_0.png','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_a18ca6df-d765-4c6a-be28-13abd1c350af_TOSC_cb1d5d31-89cd-4ab4-bada-dc6b2235cac5_SNAPS','6_w1_o2_maxillaire_snapshot_0.png','35704ab9-18dc-4d80-81f3-5f50e93033c6','{\"displayTitle\":\"MAXILLAIRE 1.6.1.2.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-17 10:58:56.000','2023-06-13 12:02:10.258','2023-06-13 14:02:10.258'),('35b24728-8070-11ea-947d-226cec7cb58a',662,'/var/.data/2020/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/35b24728-8070-11ea-947d-226cec7cb58a.m','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_bdf42f40-5a7a-435b-a5e0-eb33efefbc97_BOMA__MATRX_','35b24728-8070-11ea-947d-226cec7cb58a.m','35b24728-8070-11ea-947d-226cec7cb58a','{\"displayTitle\":\"Matrice Transfo. Mandibule 1.6.1.1\",\"title\":\"Matrice Transfo. Mandibule MATRIX\"}','BIN',0,'SYNCED',0,NULL,'2020-04-10 11:52:17.000','2023-04-11 19:02:23.080','2020-12-29 11:57:44.000'),('35b42350-8070-11ea-947d-226cec7cb58a',662,'/var/.data/2020/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/35b42350-8070-11ea-947d-226cec7cb58a.ply','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_bdf42f40-5a7a-435b-a5e0-eb33efefbc97_BOPLY__PLY_','35b42350-8070-11ea-947d-226cec7cb58a.ply','35b42350-8070-11ea-947d-226cec7cb58a','{\"displayTitle\":\"Mandibule Occlusion 1.6.1.1.1\",\"referenceScanID\":\"1.6.1.1.1\",\"title\":\"Mandibule Occlusion PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-10 11:52:17.000','2023-04-11 19:02:23.080','2023-04-12 06:40:02.055'),('35b5d98f-8070-11ea-947d-226cec7cb58a',662,'/var/.data/2020/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/35b5d98f-8070-11ea-947d-226cec7cb58a.png','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_bdf42f40-5a7a-435b-a5e0-eb33efefbc97_SNAPO__SNAPS_','35b5d98f-8070-11ea-947d-226cec7cb58a.png','35b5d98f-8070-11ea-947d-226cec7cb58a','{\"displayTitle\":\"Snapshot 1.6.1.1\",\"title\":\"Snapshot SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-10 11:52:17.000','2023-04-11 19:02:23.080','2023-04-12 06:40:02.055'),('35b772cc-8070-11ea-947d-226cec7cb58a',662,'/var/.data/2020/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/35b772cc-8070-11ea-947d-226cec7cb58a.m','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_bdf42f40-5a7a-435b-a5e0-eb33efefbc97_TOMA__MATRX_','35b772cc-8070-11ea-947d-226cec7cb58a.m','35b772cc-8070-11ea-947d-226cec7cb58a','{\"displayTitle\":\"Matrice Transfo. Maxillaire 1.6.1.1\",\"title\":\"Matrice Transfo. Maxillaire MATRIX\"}','BIN',0,'SYNCED',0,NULL,'2020-04-10 11:52:17.000','2023-04-11 19:02:23.080','2020-12-29 11:57:45.000'),('35b92b48-8070-11ea-947d-226cec7cb58a',662,'/var/.data/2020/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/35b92b48-8070-11ea-947d-226cec7cb58a.ply','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_bdf42f40-5a7a-435b-a5e0-eb33efefbc97_TOPLY__PLY_','35b92b48-8070-11ea-947d-226cec7cb58a.ply','35b92b48-8070-11ea-947d-226cec7cb58a','{\"displayTitle\":\"Maxillaire Occlusion 1.6.1.1.1\",\"referenceScanID\":\"1.6.1.1.1\",\"title\":\"Maxillaire Occlusion PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-10 11:52:17.000','2023-04-11 19:02:23.080','2023-04-12 06:40:02.055'),('35bad668-8070-11ea-947d-226cec7cb58a',662,'/var/.data/2020/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/35bad668-8070-11ea-947d-226cec7cb58a.pdf','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_PROST_50b326be-6726-493a-a2ce-6f1153dc9927_FORM','6_w1_autre_prost_file_0.pdf','35bad668-8070-11ea-947d-226cec7cb58a','{\"displayTitle\":\"AUTRE FICHE PROTHÉTIQUE 1.6.1.1 AUTRE FICHE PROTHÉTIQUE\",\"title\":\"Autre PDF\"}','PDF',0,'SYNCED',0,NULL,'2020-04-17 07:56:49.000','2023-06-13 12:02:22.278','2023-06-13 14:02:22.278'),('364852fb-413f-4160-99e2-dfbc1733ad1a',662,'/var/.data/2020/662/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_bdf42f40-5a7a-435b-a5e0-eb33efefbc97/scan_d1ad6baa-b3e6-4e10-bd69-140c7abc8f4e/6_w1_o1_mordu_anterieur_scan_file_0.ply','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_bdf42f40-5a7a-435b-a5e0-eb33efefbc97_FRSC_d1ad6baa-b3e6-4e10-bd69-140c7abc8f4e_MODEL','6_w1_o1_mordu_anterieur_scan_file_0.ply','364852fb-413f-4160-99e2-dfbc1733ad1a','{\"displayTitle\":\"Mordu anterieur 1.6.1.1.1\",\"modelMatrix\":\"0.929175,-0.0763218,0.365789,0,0.119438,0.973751,-0.180215,0,-0.351164,0.216695,0.913103,0,9.0576,-4.92457,-30.9488,1\",\"title\":\"MORDU_ANTERIEUR PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-10 11:49:59.000','2023-06-13 12:02:10.122','2023-06-13 14:02:10.122'),('366f07b3-d912-11ed-b558-229278a3c906',662,'/var/.data/2023/662/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_a62b9800-d910-11ed-b558-229278a3c906/occlusion_a62ebb05-d910-11ed-b558-229278a3c906/scan_aaa22dcc-d910-11ed-b558-229278a3c906/366f07b3-d912-11ed-b558-229278a3c906.zip','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_a62b9800-d910-11ed-b558-229278a3c906_SESS_a62ebb05-d910-11ed-b558-229278a3c906_TOSC_aaa22dcc-d910-11ed-b558-229278a3c906_MODEL','366f07b3-d912-11ed-b558-229278a3c906.zip','366f07b3-d912-11ed-b558-229278a3c906','{\"displayTitle\":\"Maxillaire 1.23.2.1.1\",\"modelMatrix\":\"-0.680645,-0.685904,0.257406,0,0.732613,-0.637249,0.239147,0,-6.43048e-10,0.351353,0.936243,0,4.40529,-2.23623,-8.47968,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-06-13 13:47:29.000','2023-06-13 11:59:36.471','2023-06-13 13:59:36.471'),('366f3933-d912-11ed-b558-229278a3c906',662,'/var/.data/2023/662/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_a62b9800-d910-11ed-b558-229278a3c906/occlusion_a62ebb05-d910-11ed-b558-229278a3c906/scan_aaa22dcc-d910-11ed-b558-229278a3c906/366f3933-d912-11ed-b558-229278a3c906.png','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_a62b9800-d910-11ed-b558-229278a3c906_SESS_a62ebb05-d910-11ed-b558-229278a3c906_TOSC_aaa22dcc-d910-11ed-b558-229278a3c906_SNAPS','366f3933-d912-11ed-b558-229278a3c906.png','366f3933-d912-11ed-b558-229278a3c906','{\"displayTitle\":\"Maxillaire 1.23.2.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-06-13 13:47:30.000','2023-06-13 11:59:36.493','2023-06-13 13:59:36.493'),('372c807f-a172-495b-9111-e2a86808505c',662,'/var/.data/2020/662/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/occlusion_d402edb5-8449-46a8-862f-a1cd1ee21cf6/scan_87a0a17a-c973-40c2-9d84-2392b0d62afb/10_w1_o1_maxillaire_scan_file_0.ply','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_SESS_d402edb5-8449-46a8-862f-a1cd1ee21cf6_TOSC_87a0a17a-c973-40c2-9d84-2392b0d62afb_MODEL','10_w1_o1_maxillaire_scan_file_0.ply','372c807f-a172-495b-9111-e2a86808505c','{\"displayTitle\":\"MAXILLAIRE 1.10.1.1.1\",\"modelMatrix\":\"0.985264,-0.169747,0.0209871,0,0.171039,0.977819,-0.120895,0,1.34619e-9,0.122703,0.992443,0,-22.8348,-1.6456,-24.8597,1\",\"title\":\"MAXILLAIRE PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-30 19:25:29.000','2023-06-13 12:02:12.407','2023-06-13 14:02:12.407'),('386b43f6-0c1a-484d-9092-8962d1eb3835',662,'','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_cb9d8495-b4dd-423f-a624-7cff70e4db55_SESS_c9d37315-5f17-421c-8afb-302fa9b0bebe_BOSC_6fafe104-bdc1-41a6-9977-b1bbb351a329_SNAPS','2_w2_o1_mandibule_snapshot_0.png','386b43f6-0c1a-484d-9092-8962d1eb3835','{\"displayTitle\":\"MANDIBULE 1.2.2.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}','PNG',0,'SYNCED',0,'2023-04-12 06:40:57.000','2020-04-06 12:33:56.000','2023-06-13 12:02:15.304','2023-06-13 14:02:15.304'),('38709a56-7ee2-11ea-947d-226cec7cb58a',662,'/var/.data/2020/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/38709a56-7ee2-11ea-947d-226cec7cb58a.png','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_LESC_6ce1c2d0-1849-4a2a-bfd9-05247b74c2d7_SNAPS','7_w2_o2_mordu_posterieur_gauche_snapshot_0.png','38709a56-7ee2-11ea-947d-226cec7cb58a','{\"displayTitle\":\"MORDU_POSTERIEUR_GAUCHE 1.7.2.2.1\",\"title\":\"MORDU_POSTERIEUR_GAUCHE SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-15 07:39:22.000','2023-06-13 12:02:21.966','2023-06-13 14:02:21.966'),('38724456-7ee2-11ea-947d-226cec7cb58a',662,'/var/.data/2020/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/38724456-7ee2-11ea-947d-226cec7cb58a.pdf','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_PROST_083f4c03-5580-45f2-9229-c3b06c40bbe2_FORM','7_w2_odf_prost_file_0.pdf','38724456-7ee2-11ea-947d-226cec7cb58a','{\"displayTitle\":\"ODF 1.7.2.1 ODF\",\"title\":\"Odf PDF\"}','PDF',0,'SYNCED',0,NULL,'2020-04-15 08:27:54.000','2023-06-13 12:02:21.975','2023-06-13 14:02:21.975'),('38756f28-7ee2-11ea-947d-226cec7cb58a',662,'/var/.data/2020/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/38756f28-7ee2-11ea-947d-226cec7cb58a.ply','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_RISC_d3a42d3d-3d98-457b-bb64-4119091b03f9_MODEL','7_w2_o2_mordu_posterieur_droit_scan_file_0.ply','38756f28-7ee2-11ea-947d-226cec7cb58a','{\"displayTitle\":\"MORDU_POSTERIEUR_DROIT 1.7.2.2.1\",\"modelMatrix\":\"0.996436,-0.0417849,0.0747689,0,0.0270536,0.952167,0.302573,0,-0.0805792,-0.302841,0.950213,0,-13.0357,5.641,-33.0669,1\",\"title\":\"MORDU_POSTERIEUR_DROIT PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-15 07:37:21.000','2023-06-13 12:02:21.983','2023-06-13 14:02:21.983'),('387709c6-7ee2-11ea-947d-226cec7cb58a',662,'/var/.data/2020/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/387709c6-7ee2-11ea-947d-226cec7cb58a.ply','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_BOSC_d2372948-816f-4d58-a2bf-288bc0e7b539_MODEL','7_w2_o2_mandibule_scan_file_1.ply','387709c6-7ee2-11ea-947d-226cec7cb58a','{\"displayTitle\":\"MANDIBULE 1.7.2.2.1\",\"modelMatrix\":\"0.798862,-0.59756,0.0688607,0,0.601515,0.79361,-0.0914527,0,-4.38586e-9,0.114479,0.993426,0,-2.73294,17.6652,-41.351,1\",\"title\":\"MANDIBULE PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-15 07:19:54.000','2023-06-13 12:02:21.992','2023-06-13 14:02:21.992'),('3878b044-7ee2-11ea-947d-226cec7cb58a',662,'/var/.data/2020/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/3878b044-7ee2-11ea-947d-226cec7cb58a.png','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_TOSC_778a761c-339e-4143-a807-735b174d9714_SNAPS','7_w2_o2_maxillaire_snapshot_1.png','3878b044-7ee2-11ea-947d-226cec7cb58a','{\"displayTitle\":\"MAXILLAIRE 1.7.2.2.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-15 07:35:08.000','2023-06-13 12:02:22.002','2023-06-13 14:02:22.002'),('387a5afb-7ee2-11ea-947d-226cec7cb58a',662,'/var/.data/2020/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/387a5afb-7ee2-11ea-947d-226cec7cb58a.png','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_BOSC_d2372948-816f-4d58-a2bf-288bc0e7b539_SNAPS','7_w2_o2_mandibule_snapshot_1.png','387a5afb-7ee2-11ea-947d-226cec7cb58a','{\"displayTitle\":\"MANDIBULE 1.7.2.2.1\",\"title\":\"MANDIBULE SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-15 07:19:54.000','2023-06-13 12:02:22.010','2023-06-13 14:02:22.010'),('387be67d-7ee2-11ea-947d-226cec7cb58a',662,'/var/.data/2020/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/387be67d-7ee2-11ea-947d-226cec7cb58a.ply','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_TOSC_778a761c-339e-4143-a807-735b174d9714_MODEL','7_w2_o2_maxillaire_scan_file_1.ply','387be67d-7ee2-11ea-947d-226cec7cb58a','{\"displayTitle\":\"MAXILLAIRE 1.7.2.2.1\",\"modelMatrix\":\"0.665193,0.645471,-0.375347,0,-0.746672,0.575036,-0.334388,0,2.20888e-8,0.502693,0.864465,0,-12.1421,-33.8974,-48.3616,1\",\"title\":\"MAXILLAIRE PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-15 07:35:08.000','2023-06-13 12:02:22.020','2023-06-13 14:02:22.020'),('387eea3c-7ee2-11ea-947d-226cec7cb58a',662,'/var/.data/2020/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/387eea3c-7ee2-11ea-947d-226cec7cb58a.png','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_FRSC_ca33a9ff-b86a-4e97-8674-1bd7adc92759_SNAPS','7_w2_o2_mordu_anterieur_snapshot_0.png','387eea3c-7ee2-11ea-947d-226cec7cb58a','{\"displayTitle\":\"MORDU_ANTERIEUR 1.7.2.2.1\",\"title\":\"MORDU_ANTERIEUR SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-15 07:43:36.000','2023-06-13 12:02:22.028','2023-06-13 14:02:22.028'),('388324cf-7ee2-11ea-947d-226cec7cb58a',662,'/var/.data/2020/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/388324cf-7ee2-11ea-947d-226cec7cb58a.ply','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_FRSC_ca33a9ff-b86a-4e97-8674-1bd7adc92759_MODEL','7_w2_o2_mordu_anterieur_scan_file_0.ply','388324cf-7ee2-11ea-947d-226cec7cb58a','{\"displayTitle\":\"MORDU_ANTERIEUR 1.7.2.2.1\",\"modelMatrix\":\"0.716923,0.0202956,0.693353,0,-0.0337042,0.999997,-0.0100568,0,-0.69663,0.000757645,0.720556,0,12.2181,4.16901,-40.9229,1\",\"title\":\"MORDU_ANTERIEUR PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-15 07:43:36.000','2023-06-13 12:02:22.037','2023-06-13 14:02:22.037'),('3884bf44-7ee2-11ea-947d-226cec7cb58a',662,'/var/.data/2020/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/3884bf44-7ee2-11ea-947d-226cec7cb58a.ply','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_LESC_6ce1c2d0-1849-4a2a-bfd9-05247b74c2d7_MODEL','7_w2_o2_mordu_posterieur_gauche_scan_file_0.ply','3884bf44-7ee2-11ea-947d-226cec7cb58a','{\"displayTitle\":\"MORDU_POSTERIEUR_GAUCHE 1.7.2.2.1\",\"modelMatrix\":\"-0.999903,-0.00806038,0.0111619,0,0.0083222,-0.994448,-0.103366,0,0.0112516,-0.104947,0.994583,0,16.7147,8.54514,-27.4379,1\",\"title\":\"MORDU_POSTERIEUR_GAUCHE PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-15 07:39:22.000','2023-06-13 12:02:22.045','2023-06-13 14:02:22.045'),('3886abd6-7ee2-11ea-947d-226cec7cb58a',662,'/var/.data/2020/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/3886abd6-7ee2-11ea-947d-226cec7cb58a.png','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_RISC_d3a42d3d-3d98-457b-bb64-4119091b03f9_SNAPS','7_w2_o2_mordu_posterieur_droit_snapshot_0.png','3886abd6-7ee2-11ea-947d-226cec7cb58a','{\"displayTitle\":\"MORDU_POSTERIEUR_DROIT 1.7.2.2.1\",\"title\":\"MORDU_POSTERIEUR_DROIT SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-15 07:37:21.000','2023-06-13 12:02:22.056','2023-06-13 14:02:22.056'),('38ff0511-8c8a-4f8b-a2a4-13c26e804b9d',662,'','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_LESC_c6bba495-6d1a-4da8-bb1f-852a1b1e5924_MODEL','7_w2_o2_mordu_posterieur_gauche_scan_file_0.ply','38ff0511-8c8a-4f8b-a2a4-13c26e804b9d','{\"displayTitle\":\"MORDU_POSTERIEUR_GAUCHE 1.7.2.2.2\",\"modelMatrix\":\"-0.999653,-0.0333276,-0.0042182,0,0.0270346,-0.970849,-0.23484,0,0.00244308,-0.237468,0.972029,0,1.83306,6.25688,-28.1939,1\",\"title\":\"MORDU_POSTERIEUR_GAUCHE PLY\"}','PLY',0,'SYNCED',0,'2023-04-12 06:40:21.000','2020-04-16 07:07:50.000','2023-06-13 12:02:15.473','2023-06-13 14:02:15.473'),('3a8a47b1-96a0-4e8f-a7fa-d5c2f74f3677',662,'','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_TOSC_778a761c-339e-4143-a807-735b174d9714_SNAPS','7_w2_o2_maxillaire_snapshot_1.png','7935777d-a278-4364-9439-322233eba142','{\"displayTitle\":\"MAXILLAIRE 1.7.2.2.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}','PNG',1,'SYNCED',0,'2023-04-12 06:40:21.000','2020-04-15 07:35:08.000','2023-06-13 12:02:15.410','2023-06-13 14:02:15.410'),('3aa92b1f-240d-45e1-a722-e8da98368f3a',662,'/var/.data/2021/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97/21_w1_o1_mandibule_scan_file_0.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_BOSC_f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97_MODEL','21_w1_o1_mandibule_scan_file_0.zip','3aa92b1f-240d-45e1-a722-e8da98368f3a','{\"displayTitle\":\"Mandibule 1.21.1.1.1\",\"modelMatrix\":\"0.960232,0.261348,-0.0982449,0,-0.279204,0.898822,-0.337882,0,2.72772e-9,0.351875,0.936047,0,6.31415,-5.24631,-21.8923,1\",\"title\":\"Mandibule ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2021-11-22 12:30:44.000','2023-06-13 12:02:12.919','2023-06-13 14:02:12.919'),('3b5b5fb9-a2cd-4386-9406-17bd2384e1ae',662,'/var/.data/2021/662/5587321c-4405-49dc-90d5-8810cc776c6d/session_7e359a5f-1756-4ec7-8657-3e5940ae489d/occlusion_b29b47d4-35f8-427d-9cd7-a393e48be2cf/scan_42b09cf6-e30d-4d35-a17d-d8e8b4564638/20_w1_o1_maxillaire_scan_file_0.zip','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_TOSC_42b09cf6-e30d-4d35-a17d-d8e8b4564638_MODEL','20_w1_o1_maxillaire_scan_file_0.zip','3b5b5fb9-a2cd-4386-9406-17bd2384e1ae','{\"displayTitle\":\"Maxillaire 1.20.1.1.1\",\"modelMatrix\":\"0.248108,0.928852,-0.275093,0,-0.968732,0.237894,-0.0704559,0,-9.18486e-10,0.283972,0.958832,0,-6.47131,-21.9142,-22.0048,1\",\"title\":\"Maxillaire ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2021-10-12 12:33:04.000','2023-06-13 12:02:12.704','2023-06-13 14:02:12.704'),('3b6f0d95-5183-43aa-8816-815a96e7e143',662,'/var/.data/2023/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_c983b946-e304-49a8-99c8-24eaca67b9ce/occlusion_9e007066-06fd-4fa1-a49a-f1165de95f83/scan_76ece440-81ad-42c8-ab91-f99fa29e2a83/21_w8_o1_maxillaire_scan_file_1.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_c983b946-e304-49a8-99c8-24eaca67b9ce_SESS_9e007066-06fd-4fa1-a49a-f1165de95f83_TOSC_76ece440-81ad-42c8-ab91-f99fa29e2a83_MODEL','21_w8_o1_maxillaire_scan_file_1.zip','ae0e9352-37bf-4a60-8c33-459deae4ddb5','{\"displayTitle\":\"Maxillaire 1.21.8.1.1\",\"modelMatrix\":\"0.818642,0.55047,-0.163732,0,-0.574305,0.784667,-0.233391,0,-1.3908e-08,0.285096,0.958499,0,-17.5299,-5.99357,-22.031,1\",\"title\":\"Maxillaire ZIP\"}','ZIP',1,'SYNCED',0,NULL,'2023-04-12 06:40:25.000','2023-04-12 07:24:18.989','2023-04-12 09:24:18.989'),('3c573ce9-f6b2-4667-9726-f5aed56d3325',662,'/var/.data/2020/662/2b4f07b1-1d58-42a2-9e72-3461efd5a2d9/session_934f20d2-7444-4367-89e2-61c3bf4bee57/order_eb120496-ad30-4640-856b-fbdd1139c529/5_w1_odf_prost_file_0.pdf','PATIENT_2b4f07b1-1d58-42a2-9e72-3461efd5a2d9_ACT_934f20d2-7444-4367-89e2-61c3bf4bee57_PROST_eb120496-ad30-4640-856b-fbdd1139c529_FORM','5_w1_odf_prost_file_0.pdf','3c573ce9-f6b2-4667-9726-f5aed56d3325','{\"displayTitle\":\"ODF 1.5.1.3 ODF\",\"title\":\"Odf PDF\"}','PDF',0,'SYNCED',0,NULL,'2020-04-10 09:20:47.000','2023-06-13 12:02:17.581','2023-06-13 14:02:17.581'),('3d2bee32-9787-46dd-b6a9-cba9de226dfb',662,'/var/.data/2020/662/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/occlusion_d402edb5-8449-46a8-862f-a1cd1ee21cf6/scan_b7931623-9b21-4440-a950-16565249bf9a/10_w1_o1_mandibule_snapshot_1.png','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_SESS_d402edb5-8449-46a8-862f-a1cd1ee21cf6_BOSC_b7931623-9b21-4440-a950-16565249bf9a_SNAPS','10_w1_o1_mandibule_snapshot_1.png','f3f82ebd-8318-469e-9bdd-ff76223b9c1c','{\"displayTitle\":\"MANDIBULE 1.10.1.1.2\",\"title\":\"MANDIBULE SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2020-04-30 19:51:54.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.069'),('3d775751-11c5-4dcb-bf34-a85c2baf0191',662,'/var/.data/2020/662/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/occlusion_b87f1382-55d4-4e52-b63a-6f387df18b16/scan_4a2eec76-a5f3-44f0-b389-4734998fa2d3/13_w4_o1_mandibule_scan_file_1.ply','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_SESS_b87f1382-55d4-4e52-b63a-6f387df18b16_BOSC_4a2eec76-a5f3-44f0-b389-4734998fa2d3_MODEL','13_w4_o1_mandibule_scan_file_1.ply','2b6d557d-ea43-42a5-bd7d-859d5a90f1a6','{\"displayTitle\":\"Mandibule 1.13.4.1.1\",\"modelMatrix\":\"-0.927385,0.371641,-0.0428907,0,-0.374108,-0.92127,0.106323,0,-4.21377e-10,0.114648,0.993406,0,17.4534,2.88749,-20.5368,1\",\"title\":\"Mandibule PLY\"}','PLY',1,'SYNCED',0,NULL,'2020-12-29 11:24:49.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.063'),('3d7bd9ef-9d44-4365-af74-4d2a31f8f2fb',662,'/var/.data/2021/662/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_643b3b5a-e991-4dbf-95c8-2fd609f83a8b/14_w1_o1_maxillaire_snapshot_0.png','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_TOSC_643b3b5a-e991-4dbf-95c8-2fd609f83a8b_SNAPS','14_w1_o1_maxillaire_snapshot_0.png','3d7bd9ef-9d44-4365-af74-4d2a31f8f2fb','{\"displayTitle\":\"Maxillaire 1.14.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-02-01 20:20:58.000','2023-06-13 12:02:09.546','2023-06-13 14:02:09.546'),('3dc10c2a-bbf8-496d-bcfb-198ad6609e7b',662,'/var/.data/2020/662/d41de280-8cf3-4e57-893e-cc7a010bc864/session_c59a2f65-79fe-44cd-8377-e39aa0a44171/occlusion_daf632b1-2c49-42c8-8899-0a0b2448bc3a/scan_55058b25-acc2-43c3-b9d2-b8bb64bfcbb9/9_w1_o1_mordu_posterieur_droit_scan_file_0.ply','PATIENT_d41de280-8cf3-4e57-893e-cc7a010bc864_ACT_c59a2f65-79fe-44cd-8377-e39aa0a44171_SESS_daf632b1-2c49-42c8-8899-0a0b2448bc3a_RISC_55058b25-acc2-43c3-b9d2-b8bb64bfcbb9_MODEL','9_w1_o1_mordu_posterieur_droit_scan_file_0.ply','3dc10c2a-bbf8-496d-bcfb-198ad6609e7b','{\"displayTitle\":\"Mordu posterieur droit 1.9.1.1.1\",\"modelMatrix\":\"0.9697,-0.169154,0.177375,0,0.140935,0.97496,0.170056,0,-0.199574,-0.144436,0.969352,0,-10.321,0.513719,-39.3692,1\",\"title\":\"MORDU_POSTERIEUR_DROIT PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-18 09:33:54.000','2023-06-13 12:02:10.609','2023-06-13 14:02:10.609'),('3ddb3953-cee7-44fd-b8e2-76afee946647',662,'/var/.data/2021/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97/21_w1_o1_mandibule_snapshot_3.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_BOSC_f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97_SNAPS','21_w1_o1_mandibule_snapshot_3.png','5dfbe9b8-c587-4311-b392-743be40fdd10','{\"displayTitle\":\"Mandibule 1.21.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',3,'SYNCED',0,NULL,'2021-11-22 12:41:03.000','2023-06-13 12:02:12.911','2023-06-13 14:02:12.911'),('3e41d066-f22f-4b6c-bc5b-438bc17b2d84',662,'','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_cb9d8495-b4dd-423f-a624-7cff70e4db55_SESS_c9d37315-5f17-421c-8afb-302fa9b0bebe_BOSC_6fafe104-bdc1-41a6-9977-b1bbb351a329_MODEL','2_w2_o1_mandibule_scan_file_0.ply','3e41d066-f22f-4b6c-bc5b-438bc17b2d84','{\"displayTitle\":\"MANDIBULE 1.2.2.1.1\",\"modelMatrix\":\"0.400065,-0.911137,0.0988782,0,0.916487,0.39773,-0.0431623,0,5.34897e-10,0.107888,0.994163,0,-28.4581,-3.18447,-47.2893,1\",\"title\":\"MANDIBULE PLY\"}','PLY',0,'SYNCED',0,'2023-04-12 06:40:18.000','2020-04-06 12:33:56.000','2023-06-13 12:02:15.287','2023-06-13 14:02:15.287'),('3f126af5-ce2b-4e13-8fc8-9811ab5d462c',662,'','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_BOSC_d2372948-816f-4d58-a2bf-288bc0e7b539_SNAPS','7_w2_o2_mandibule_snapshot_1.png','98a2c194-b406-4930-b901-3f1b520fc329','{\"displayTitle\":\"MANDIBULE 1.7.2.2.1\",\"title\":\"MANDIBULE SNAPSHOT\"}','PNG',1,'SYNCED',0,'2023-04-12 06:40:26.000','2020-04-15 07:19:54.000','2023-06-13 12:02:15.547','2023-06-13 14:02:15.547'),('3f34dab9-eda8-40de-be81-a094dee55a47',662,'/var/.data/2021/662/615ede1a-dba9-4251-9e9e-6cbbd3041fdc/session_76dcd1f0-f6c7-480f-b07b-441679345d70/occlusion_c6fffa68-cc65-471a-a58e-135ebe4d0772/scan_e6e5d8c5-2d8c-48d0-9708-e3256202d385/15_w1_o1_mandibule_scan_file_1.ply','PATIENT_615ede1a-dba9-4251-9e9e-6cbbd3041fdc_ACT_76dcd1f0-f6c7-480f-b07b-441679345d70_SESS_c6fffa68-cc65-471a-a58e-135ebe4d0772_BOSC_e6e5d8c5-2d8c-48d0-9708-e3256202d385_MODEL','15_w1_o1_mandibule_scan_file_1.ply','6e9feeb8-6d42-4237-b134-51d979397898','{\"displayTitle\":\"Mandibule 1.15.1.1.1\",\"modelMatrix\":\"-0.93029,0.344241,-0.126722,0,-0.366825,-0.873016,0.321375,0,1.11868e-10,0.345457,0.938435,0,10.3349,-0.483709,-14.2397,1\",\"title\":\"Mandibule PLY\"}','PLY',1,'SYNCED',0,NULL,'2021-02-16 12:48:00.000','2023-06-13 12:02:09.713','2023-06-13 14:02:09.713'),('3f3f465f-157f-11ed-a752-9ec33d03e6dd',662,'/var/.data/2022/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/3f3f465f-157f-11ed-a752-9ec33d03e6dd.zip','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_3eede325-0afb-43f5-9277-e22c18f8f927_SESS_f72f6016-0f75-4789-9924-1bc9aa64c2f1_BOSC_254d7cff-f2aa-4d41-8b1c-7b0bdd6386ff_MODEL','20_w2_o1_mandibule_scan_file_0.zip','3f3f465f-157f-11ed-a752-9ec33d03e6dd','{\"displayTitle\":\"Mandibule 1.20.2.1.1\",\"modelMatrix\":\"0.909705,0.387142,-0.150193,0,-0.415255,0.848117,-0.329031,0,9.51155e-09,0.36169,0.932299,0,-8.74595,-28.9367,-15.18,1\",\"title\":\"Mandibule ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-08-06 13:56:38.000','2023-06-13 12:02:23.143','2023-06-13 14:02:23.143'),('3f421d14-157f-11ed-a752-9ec33d03e6dd',662,'/var/.data/2022/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/3f421d14-157f-11ed-a752-9ec33d03e6dd.png','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_3eede325-0afb-43f5-9277-e22c18f8f927_SESS_f72f6016-0f75-4789-9924-1bc9aa64c2f1_BOSC_254d7cff-f2aa-4d41-8b1c-7b0bdd6386ff_SNAPS','20_w2_o1_mandibule_snapshot_0.png','3f421d14-157f-11ed-a752-9ec33d03e6dd','{\"displayTitle\":\"Mandibule 1.20.2.1.1\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-08-06 13:56:36.000','2023-06-13 12:02:23.152','2023-06-13 14:02:23.152'),('3f9ce1c8-3470-43c5-8e52-0294b7082120',662,'/var/.data/2021/662/f15cb858-4f0b-44ec-a017-5e662039ba19/session_72b7a457-e38f-4535-8eba-6c98b43e5e55/occlusion_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c/scan_18365744-4019-43e1-933f-9fa52db1a30d/14_w2_o1_mordu_anterieur_scan_file_0.ply','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_72b7a457-e38f-4535-8eba-6c98b43e5e55_SESS_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c_FRSC_18365744-4019-43e1-933f-9fa52db1a30d_MODEL','14_w2_o1_mordu_anterieur_scan_file_0.ply','3f9ce1c8-3470-43c5-8e52-0294b7082120','{\"displayTitle\":\"Mordu anterieur 1.14.2.1.1\",\"modelMatrix\":\"0.818033,-0.00455161,0.571846,0,0.124413,0.969323,-0.221421,0,-0.562015,0.247702,0.790218,0,4.13126,-6.94909,-27.5385,1\",\"title\":\"Mordu anterieur PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-06-08 20:56:53.000','2023-06-13 12:02:12.353','2023-06-13 14:02:12.353'),('3ff0f96a-5e61-4469-a401-383ca0d260ac',662,'/var/.data/2021/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_3d3ae697-dc08-4ce2-8b32-4f79891607c2/21_w1_o1_mordu_anterieur_snapshot_0.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_FRSC_3d3ae697-dc08-4ce2-8b32-4f79891607c2_SNAPS','21_w1_o1_mordu_anterieur_snapshot_0.png','3ff0f96a-5e61-4469-a401-383ca0d260ac','{\"displayTitle\":\"Mordu anterieur 1.21.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-11-22 12:49:42.000','2023-06-13 12:02:12.838','2023-06-13 14:02:12.838'),('40bc13d8-af5e-436f-825b-372a9ad37b03',662,'/var/.data/2021/662/03ec19f1-9f11-4710-a0cd-c5d7739e40d7/session_f474819e-9470-4612-8275-2ceb25b5522f/occlusion_484ae4d8-329f-49b5-8d83-312a8a92ff22/scan_f766f1dd-53ad-45fc-8f7b-a61d47dfe500/16_w1_o1_mordu_posterieur_gauche_scan_file_0.ply','PATIENT_03ec19f1-9f11-4710-a0cd-c5d7739e40d7_ACT_f474819e-9470-4612-8275-2ceb25b5522f_SESS_484ae4d8-329f-49b5-8d83-312a8a92ff22_LESC_f766f1dd-53ad-45fc-8f7b-a61d47dfe500_MODEL','16_w1_o1_mordu_posterieur_gauche_scan_file_0.ply','40bc13d8-af5e-436f-825b-372a9ad37b03','{\"displayTitle\":\"Mordu posterieur gauche 1.16.1.1.1\",\"modelMatrix\":\"-0.848269,-0.0934247,0.521312,0,0.2652,-0.889836,0.34217,0,0.461243,0.449468,0.781819,0,-4.04483,-9.96195,-25.9001,1\",\"title\":\"Mordu posterieur gauche PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-02-27 10:52:46.000','2023-06-13 12:02:09.883','2023-06-13 14:02:09.883'),('40c9dd9e-b85c-4ed6-a37e-81b5b8e9124d',662,'/var/.data/2020/662/1af643c4-44fe-4ccb-b545-dbc90b47633b/session_a6ab7edf-6040-4f1a-b898-a1120a854927/occlusion_e06b73d5-45f7-4906-ba73-560d66ac56af/scan_e9134dab-33d6-42e4-8779-ab502b18266c/7_w4_o1_maxillaire_scan_file_0.ply','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_a6ab7edf-6040-4f1a-b898-a1120a854927_SESS_e06b73d5-45f7-4906-ba73-560d66ac56af_TOSC_e9134dab-33d6-42e4-8779-ab502b18266c_MODEL','7_w4_o1_maxillaire_scan_file_0.ply','40c9dd9e-b85c-4ed6-a37e-81b5b8e9124d','{\"displayTitle\":\"MAXILLAIRE 1.7.4.1.1\",\"modelMatrix\":\"0.991392,0.126509,-0.0337273,0,-0.130927,0.957933,-0.255386,0,1.47727e-9,0.257603,0.966251,0,-10.2666,-17.593,-25.4967,1\",\"title\":\"MAXILLAIRE PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-16 10:54:36.000','2023-06-13 12:02:10.024','2023-06-13 14:02:10.024'),('41f1c7ba-1d8c-47b9-8ed9-11f004bb7681',662,'/var/.data/2022/662/3d722760-3820-40e4-81e1-60e722c0cb01/session_1b1f827a-e4fa-4f16-8fd1-8cbdaa85c91e/occlusion_20b31e3a-565c-49b0-b2ff-0dae86b25c76/scan_3e1d8e57-feae-45d6-80f0-9d0be041ff7a/28_w1_o1_maxillaire_scan_file_0.zip','PATIENT_3d722760-3820-40e4-81e1-60e722c0cb01_ACT_1b1f827a-e4fa-4f16-8fd1-8cbdaa85c91e_SESS_20b31e3a-565c-49b0-b2ff-0dae86b25c76_TOSC_3e1d8e57-feae-45d6-80f0-9d0be041ff7a_MODEL','28_w1_o1_maxillaire_scan_file_0.zip','41f1c7ba-1d8c-47b9-8ed9-11f004bb7681','{\"displayTitle\":\"Maxillaire 1.28.1.1.1\",\"modelMatrix\":\"0.474246,0.405495,-0.78145,0,-0.880392,0.21843,-0.420948,0,2.39322e-08,0.887616,0.460584,0,-13.5016,-38.9817,-5.28171,1\",\"title\":\"Maxillaire ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-09-19 11:48:35.000','2023-04-12 04:41:30.596','2023-04-12 06:41:30.596'),('4210a84b-05e7-47b1-9d77-62e41dc0e731',662,'/var/.data/2022/662/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_129a6c33-3cca-43ab-b97a-56d0e82a546f/occlusion_b5b4db66-f433-46fb-b794-d632b8fe8e1d/scan_99102b35-9ad0-4017-b70e-fa08e5c36102/19_w3_o1_mordu_posterieur_droit_snapshot_0.png','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_129a6c33-3cca-43ab-b97a-56d0e82a546f_SESS_b5b4db66-f433-46fb-b794-d632b8fe8e1d_RISC_99102b35-9ad0-4017-b70e-fa08e5c36102_SNAPS','19_w3_o1_mordu_posterieur_droit_snapshot_0.png','4210a84b-05e7-47b1-9d77-62e41dc0e731','{\"displayTitle\":\"Mordu posterieur droit 1.19.3.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-11-02 12:34:10.000','2023-06-13 12:02:13.604','2023-06-13 14:02:13.604'),('42d780c5-37b5-433e-890f-3c005cb69701',662,'/var/.data/2020/662/2b4f07b1-1d58-42a2-9e72-3461efd5a2d9/session_bc967a6b-ad1a-4a59-aab8-92332e4217b0/occlusion_f2e73640-aebd-4bb1-9b02-c0504556ac5a/scan_e7efed59-e33c-4194-94c1-3507350dcfb5/5_w3_o1_maxillaire_scan_file_0.ply','PATIENT_2b4f07b1-1d58-42a2-9e72-3461efd5a2d9_ACT_bc967a6b-ad1a-4a59-aab8-92332e4217b0_SESS_f2e73640-aebd-4bb1-9b02-c0504556ac5a_TOSC_e7efed59-e33c-4194-94c1-3507350dcfb5_MODEL','5_w3_o1_maxillaire_scan_file_0.ply','42d780c5-37b5-433e-890f-3c005cb69701','{\"displayTitle\":\"Maxillaire 1.5.3.1.1\",\"modelMatrix\":\"-0.890132,-0.441513,0.112835,0,0.455703,-0.862414,0.220401,0,1.25595e-9,0.247605,0.968861,0,15.4523,-7.52574,-24.5518,1\",\"title\":\"Maxillaire PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-07-13 19:18:53.000','2023-04-12 04:41:22.128','2023-04-12 06:41:22.128'),('430388c7-9e1e-4f20-b931-839cea08cfe1',662,'/var/.data/2021/662/615ede1a-dba9-4251-9e9e-6cbbd3041fdc/session_76dcd1f0-f6c7-480f-b07b-441679345d70/occlusion_c6fffa68-cc65-471a-a58e-135ebe4d0772/scan_c99bbff9-5630-49d7-9300-4dabfa5e74c8/15_w1_o1_mordu_posterieur_droit_snapshot_0.png','PATIENT_615ede1a-dba9-4251-9e9e-6cbbd3041fdc_ACT_76dcd1f0-f6c7-480f-b07b-441679345d70_SESS_c6fffa68-cc65-471a-a58e-135ebe4d0772_RISC_c99bbff9-5630-49d7-9300-4dabfa5e74c8_SNAPS','15_w1_o1_mordu_posterieur_droit_snapshot_0.png','430388c7-9e1e-4f20-b931-839cea08cfe1','{\"displayTitle\":\"Mordu posterieur droit 1.15.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-02-16 12:53:05.000','2023-06-13 12:02:09.743','2023-06-13 14:02:09.743'),('43236ddb-b178-4cc2-bc90-90f78d3f3694',662,'/var/.data/2020/662/1af643c4-44fe-4ccb-b545-dbc90b47633b/session_a6ab7edf-6040-4f1a-b898-a1120a854927/occlusion_e06b73d5-45f7-4906-ba73-560d66ac56af/scan_10c9626c-901e-4a0e-8f05-62042bf69c04/7_w4_o1_mandibule_snapshot_0.png','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_a6ab7edf-6040-4f1a-b898-a1120a854927_SESS_e06b73d5-45f7-4906-ba73-560d66ac56af_BOSC_10c9626c-901e-4a0e-8f05-62042bf69c04_SNAPS','7_w4_o1_mandibule_snapshot_0.png','43236ddb-b178-4cc2-bc90-90f78d3f3694','{\"displayTitle\":\"Mandibule 1.7.4.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-16 11:14:29.000','2023-06-13 12:02:10.003','2023-06-13 14:02:10.003'),('436f05c6-b083-492e-bd94-ce39d9a91136',662,'/var/.data/2020/662/2b4f07b1-1d58-42a2-9e72-3461efd5a2d9/session_801b987d-e335-4276-8bc6-1fa57b553716/occlusion_1a616ac1-2ca3-4d23-ae5e-349558c26c37/scan_7fad3bba-f2b2-41ce-849b-756d995c0414/5_w2_o1_maxillaire_scan_file_0.ply','PATIENT_2b4f07b1-1d58-42a2-9e72-3461efd5a2d9_ACT_801b987d-e335-4276-8bc6-1fa57b553716_SESS_1a616ac1-2ca3-4d23-ae5e-349558c26c37_TOSC_7fad3bba-f2b2-41ce-849b-756d995c0414_MODEL','5_w2_o1_maxillaire_scan_file_0.ply','436f05c6-b083-492e-bd94-ce39d9a91136','{\"displayTitle\":\"Maxillaire 1.5.2.1.1\",\"modelMatrix\":\"-0.882441,0.381231,-0.275609,0,-0.470423,-0.715131,0.517,0,1.77231e-9,0.585875,0.810401,0,-8.72731,-27.9562,-11.891,1\",\"title\":\"MAXILLAIRE PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-11 07:49:58.000','2023-06-13 12:02:10.462','2023-06-13 14:02:10.462'),('449406e4-68d2-4fa1-9032-2e72795a7ec2',662,'/var/.data/2020/662/1af643c4-44fe-4ccb-b545-dbc90b47633b/session_a6ab7edf-6040-4f1a-b898-a1120a854927/occlusion_e06b73d5-45f7-4906-ba73-560d66ac56af/scan_e9134dab-33d6-42e4-8779-ab502b18266c/7_w4_o1_maxillaire_snapshot_0.png','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_a6ab7edf-6040-4f1a-b898-a1120a854927_SESS_e06b73d5-45f7-4906-ba73-560d66ac56af_TOSC_e9134dab-33d6-42e4-8779-ab502b18266c_SNAPS','7_w4_o1_maxillaire_snapshot_0.png','449406e4-68d2-4fa1-9032-2e72795a7ec2','{\"displayTitle\":\"MAXILLAIRE 1.7.4.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-16 10:54:36.000','2023-06-13 12:02:10.032','2023-06-13 14:02:10.032'),('4582b122-e1ac-4901-8817-e05e3192fc42',662,'/var/.data/2020/662/1af643c4-44fe-4ccb-b545-dbc90b47633b/session_a6ab7edf-6040-4f1a-b898-a1120a854927/occlusion_e06b73d5-45f7-4906-ba73-560d66ac56af/scan_cd4cde89-86e9-4257-92b6-869e9aa8d1f6/7_w4_o1_mordu_anterieur_scan_file_0.ply','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_a6ab7edf-6040-4f1a-b898-a1120a854927_SESS_e06b73d5-45f7-4906-ba73-560d66ac56af_FRSC_cd4cde89-86e9-4257-92b6-869e9aa8d1f6_MODEL','7_w4_o1_mordu_anterieur_scan_file_0.ply','4582b122-e1ac-4901-8817-e05e3192fc42','{\"displayTitle\":\"Mordu anterieur 1.7.4.1.1\",\"modelMatrix\":\"0.808151,-0.0132398,0.595057,0,0.158105,0.942098,-0.249001,0,-0.570111,0.340119,0.764367,0,3.24729,-9.01808,-30.8629,1\",\"title\":\"MORDU_ANTERIEUR PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-16 11:35:43.000','2023-06-13 12:02:10.102','2023-06-13 14:02:10.102'),('45a66afe-8bb2-49b4-b3fc-982c845cf2f2',662,'/var/.data/2021/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_c00beb59-a67d-4566-801a-0081588c2a04/21_w1_o1_mordu_posterieur_droit_scan_file_0.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_RISC_c00beb59-a67d-4566-801a-0081588c2a04_MODEL','21_w1_o1_mordu_posterieur_droit_scan_file_0.zip','45a66afe-8bb2-49b4-b3fc-982c845cf2f2','{\"displayTitle\":\"Mordu posterieur droit 1.21.1.1.1\",\"modelMatrix\":\"0.99877,0.016182,0.0457803,0,-0.0192084,0.999424,-0.0289803,0,-0.0459172,0.0302338,0.998533,0,13.1616,-3.71206,-20.732,1\",\"title\":\"Mordu posterieur droit ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2021-11-22 12:45:00.000','2023-06-13 12:02:12.819','2023-06-13 14:02:12.819'),('45a97d29-279f-4720-856d-2ef701665f93',662,'/var/.data/2021/662/ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07/session_b498bdf4-2e5b-497a-8bfe-b65edabac3bc/occlusion_31210683-bc06-4b84-83d9-ce60f32308e4/scan_e8ff012c-af85-450f-ba33-bd61c15846e9/22_w1_o1_mandibule_scan_file_0.zip','PATIENT_ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07_ACT_b498bdf4-2e5b-497a-8bfe-b65edabac3bc_SESS_31210683-bc06-4b84-83d9-ce60f32308e4_BOSC_e8ff012c-af85-450f-ba33-bd61c15846e9_MODEL','22_w1_o1_mandibule_scan_file_0.zip','45a97d29-279f-4720-856d-2ef701665f93','{\"displayTitle\":\"Mandibule 1.22.1.1.1\",\"modelMatrix\":\"0.297612,0.931799,-0.207792,0,-0.954687,0.290477,-0.0647764,0,1.12315e-11,0.217654,0.976026,0,11.0234,-21.5208,-16.5828,1\",\"title\":\"Mandibule ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2021-11-23 12:14:25.000','2023-06-13 12:02:12.958','2023-06-13 14:02:12.958'),('472a6b31-d305-463f-a0b2-2abeb6fa2c3e',662,'/var/.data/2022/662/665b40ce-9690-4944-b007-4a96c1f5d57d/session_8f87b136-cb98-4706-b7d4-51059e1afa06/occlusion_5f895907-3eed-4aa7-995a-f7e1c9661a0a/scan_802e2d49-5b37-47b7-b8e9-4fb4bff1f62f/25_w1_o1_maxillaire_scan_file_0.zip','PATIENT_665b40ce-9690-4944-b007-4a96c1f5d57d_ACT_8f87b136-cb98-4706-b7d4-51059e1afa06_SESS_5f895907-3eed-4aa7-995a-f7e1c9661a0a_TOSC_802e2d49-5b37-47b7-b8e9-4fb4bff1f62f_MODEL','25_w1_o1_maxillaire_scan_file_0.zip','472a6b31-d305-463f-a0b2-2abeb6fa2c3e','{\"displayTitle\":\"Maxillaire 1.25.1.1.1\",\"modelMatrix\":\"0.0832976,0.961401,-0.262239,0,-0.996525,0.0803617,-0.0219201,0,-1.95466e-09,0.263154,0.964754,0,14.2701,-23.5702,-21.6079,1\",\"title\":\"Maxillaire ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-03-11 11:13:47.000','2023-06-13 12:02:13.269','2023-06-13 14:02:13.269'),('4743873a-96f6-412f-91c5-a4b27c7d6847',662,'/var/.data/2022/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_87965ef8-01eb-4830-8e8b-8b99ece62cf1/occlusion_dce9ce0f-0933-4c98-af84-59e2b6395f8f/scan_bd51414b-f96e-4903-a2e2-44fb3189decd/21_w2_o1_mandibule_snapshot_3.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_87965ef8-01eb-4830-8e8b-8b99ece62cf1_SESS_dce9ce0f-0933-4c98-af84-59e2b6395f8f_BOSC_bd51414b-f96e-4903-a2e2-44fb3189decd_SNAPS','21_w2_o1_mandibule_snapshot_3.png','160153e9-3248-4a6b-b0ff-a10c2c1acfc9','{\"displayTitle\":\"Mandibule 1.21.2.1.1\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',3,'SYNCED',0,NULL,'2022-06-27 20:58:56.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.104'),('477bef20-19c4-472b-89d8-912285f5e534',662,'/var/.data/2020/662/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/occlusion_d402edb5-8449-46a8-862f-a1cd1ee21cf6/scan_87a0a17a-c973-40c2-9d84-2392b0d62afb/10_w1_o1_maxillaire_snapshot_0.png','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_SESS_d402edb5-8449-46a8-862f-a1cd1ee21cf6_TOSC_87a0a17a-c973-40c2-9d84-2392b0d62afb_SNAPS','10_w1_o1_maxillaire_snapshot_0.png','477bef20-19c4-472b-89d8-912285f5e534','{\"displayTitle\":\"MAXILLAIRE 1.10.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-30 19:25:29.000','2023-06-13 12:02:12.390','2023-06-13 14:02:12.390'),('4782af06-5171-4020-833c-143c6a151469',662,'/var/.data/2023/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_c983b946-e304-49a8-99c8-24eaca67b9ce/occlusion_9e007066-06fd-4fa1-a49a-f1165de95f83/scan_76ece440-81ad-42c8-ab91-f99fa29e2a83/21_w8_o1_maxillaire_snapshot_1.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_c983b946-e304-49a8-99c8-24eaca67b9ce_SESS_9e007066-06fd-4fa1-a49a-f1165de95f83_TOSC_76ece440-81ad-42c8-ab91-f99fa29e2a83_SNAPS','21_w8_o1_maxillaire_snapshot_1.png','a952743c-a21c-4952-8c29-3ac0e894560a','{\"displayTitle\":\"Maxillaire 1.21.8.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2023-04-12 06:40:30.000','2023-04-12 07:24:19.021','2023-04-12 09:24:19.021'),('48632fc1-3269-4a7f-bdaa-980e30af0358',662,'','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_TOSC_778a761c-339e-4143-a807-735b174d9714_MODEL','7_w2_o2_maxillaire_scan_file_1.ply','e54a3aaa-1b5e-4e05-b9aa-30359687e6de','{\"displayTitle\":\"MAXILLAIRE 1.7.2.2.1\",\"modelMatrix\":\"0.665193,0.645471,-0.375347,0,-0.746672,0.575036,-0.334388,0,2.20888e-8,0.502693,0.864465,0,-12.1421,-33.8974,-48.3616,1\",\"title\":\"MAXILLAIRE PLY\"}','PLY',1,'SYNCED',0,'2023-04-12 06:40:30.000','2020-04-15 07:35:08.000','2023-06-13 12:02:15.428','2023-06-13 14:02:15.428'),('49635be4-dbea-497c-82e1-206399739c31',662,'/var/.data/2021/662/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_0c1ed331-8df6-482e-8dd1-508d9b190c49/occlusion_6c6bb813-840d-454a-ab1d-9232434a4500/scan_50e1896b-8565-4257-9a61-2a685fff8165/19_w1_o1_mandibule_scan_file_1.ply','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_BOSC_50e1896b-8565-4257-9a61-2a685fff8165_MODEL','19_w1_o1_mandibule_scan_file_1.ply','ac2e051b-dd4c-4fc1-be89-d406c5ab9a69','{\"displayTitle\":\"Mandibule 1.19.1.1.1\",\"modelMatrix\":\"0.258681,-0.958527,0.119627,0,0.965963,0.25669,-0.0320357,0,1.9715e-9,0.123842,0.992302,0,-20.8805,2.28408,-23.0637,1\",\"title\":\"Mandibule PLY\"}','PLY',1,'SYNCED',0,NULL,'2021-09-27 12:43:41.000','2023-06-13 12:02:12.632','2023-06-13 14:02:12.632'),('49c43140-7062-4b44-a49e-83c262304d61',662,'/var/.data/2020/662/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/occlusion_d402edb5-8449-46a8-862f-a1cd1ee21cf6/scan_b7931623-9b21-4440-a950-16565249bf9a/10_w1_o1_mandibule_scan_file_2.ply','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_SESS_d402edb5-8449-46a8-862f-a1cd1ee21cf6_BOSC_b7931623-9b21-4440-a950-16565249bf9a_MODEL','10_w1_o1_mandibule_scan_file_2.ply','6008312e-ba22-4c98-a696-7500991d7069','{\"displayTitle\":\"MANDIBULE 1.10.1.1.2\",\"modelMatrix\":\"-0.989861,-0.136915,0.037811,0,0.14204,-0.954145,0.263501,0,-1.96253e-9,0.2662,0.963918,0,19.8396,4.83983,-21.5585,1\",\"title\":\"MANDIBULE PLY\"}','PLY',2,'SYNCED',0,NULL,'2020-04-30 19:54:51.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.091'),('4a35756e-57f1-4f26-a7da-64af3396fbad',662,'/var/.data/2022/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_e43c8099-0862-42c3-9ad2-1efef27b83ba/occlusion_09f15124-6bba-4565-bfe4-efb3c6c3a17d/scan_3a315f7b-8cf2-4d0c-bf92-fecb623fe530/21_w3_o1_maxillaire_snapshot_1.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_e43c8099-0862-42c3-9ad2-1efef27b83ba_SESS_09f15124-6bba-4565-bfe4-efb3c6c3a17d_TOSC_3a315f7b-8cf2-4d0c-bf92-fecb623fe530_SNAPS','21_w3_o1_maxillaire_snapshot_1.png','6bc59c6e-9179-4d61-91a6-7cfb0da22a7a','{\"displayTitle\":\"Maxillaire 1.21.3.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2022-09-14 12:23:53.000','2023-06-13 12:02:13.525','2023-06-13 14:02:13.525'),('4a84b07a-6e20-4dea-85d3-199cb3adf0f5',662,'/var/.data/2021/662/ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07/session_b498bdf4-2e5b-497a-8bfe-b65edabac3bc/occlusion_31210683-bc06-4b84-83d9-ce60f32308e4/scan_e8ff012c-af85-450f-ba33-bd61c15846e9/22_w1_o1_mandibule_snapshot_0.png','PATIENT_ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07_ACT_b498bdf4-2e5b-497a-8bfe-b65edabac3bc_SESS_31210683-bc06-4b84-83d9-ce60f32308e4_BOSC_e8ff012c-af85-450f-ba33-bd61c15846e9_SNAPS','22_w1_o1_mandibule_snapshot_0.png','4a84b07a-6e20-4dea-85d3-199cb3adf0f5','{\"displayTitle\":\"Mandibule 1.22.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-11-23 12:14:24.000','2023-06-13 12:02:12.970','2023-06-13 14:02:12.970'),('4acfe34d-f60d-43a0-bed4-9a53302e03f0',662,'/var/.data/2020/662/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_bdf42f40-5a7a-435b-a5e0-eb33efefbc97/scan_2d566d37-f38f-4b79-ac8f-48009ae22310/6_w1_o1_maxillaire_snapshot_0.png','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_bdf42f40-5a7a-435b-a5e0-eb33efefbc97_TOSC_2d566d37-f38f-4b79-ac8f-48009ae22310_SNAPS','6_w1_o1_maxillaire_snapshot_0.png','4acfe34d-f60d-43a0-bed4-9a53302e03f0','{\"displayTitle\":\"Maxillaire 1.6.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-10 11:37:04.000','2023-06-13 12:02:10.202','2023-06-13 14:02:10.202'),('4b136eb3-b01e-4166-a154-4539e20f9fea',662,'/var/.data/2020/662/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/occlusion_b87f1382-55d4-4e52-b63a-6f387df18b16/scan_4a2eec76-a5f3-44f0-b389-4734998fa2d3/13_w4_o1_mandibule_scan_file_2.ply','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_SESS_b87f1382-55d4-4e52-b63a-6f387df18b16_BOSC_4a2eec76-a5f3-44f0-b389-4734998fa2d3_MODEL','13_w4_o1_mandibule_scan_file_2.ply','2b6d557d-ea43-42a5-bd7d-859d5a90f1a6','{\"displayTitle\":\"Mandibule 1.13.4.1.1\",\"modelMatrix\":\"-0.820938,0.563368,-0.0931513,0,-0.571017,-0.809941,0.133921,0,-6.12112e-9,0.163132,0.986604,0,19.1304,-2.19336,-20.055,1\",\"title\":\"Mandibule PLY\"}','PLY',2,'SYNCED',0,NULL,'2020-12-29 11:28:31.000','2023-06-13 12:02:12.180','2023-06-13 14:02:12.180'),('4b797e84-44dc-4df1-9b19-d421afa9bb08',662,'/var/.data/2020/662/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/occlusion_b87f1382-55d4-4e52-b63a-6f387df18b16/scan_876f775b-e8a0-4b7f-bea0-0c93a7041d17/13_w4_o1_mordu_posterieur_gauche_snapshot_0.png','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_SESS_b87f1382-55d4-4e52-b63a-6f387df18b16_LESC_876f775b-e8a0-4b7f-bea0-0c93a7041d17_SNAPS','13_w4_o1_mordu_posterieur_gauche_snapshot_0.png','4b797e84-44dc-4df1-9b19-d421afa9bb08','{\"displayTitle\":\"Mordu posterieur gauche 1.13.4.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-12-29 11:33:10.000','2023-06-13 12:02:10.513','2023-06-13 14:02:10.513'),('4df1d6c0-6d77-4547-ae20-f797167f57b2',662,'/var/.data/2021/662/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_643b3b5a-e991-4dbf-95c8-2fd609f83a8b/14_w1_o1_maxillaire_scan_file_6.ply','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_TOSC_643b3b5a-e991-4dbf-95c8-2fd609f83a8b_MODEL','14_w1_o1_maxillaire_scan_file_6.ply','e720e2f6-8dce-43f4-a5d6-bf8c09037947','{\"displayTitle\":\"Maxillaire 1.14.1.1.1\",\"modelMatrix\":\"-0.972671,0.219774,-0.0749072,0,-0.232189,-0.920663,0.313796,0,-1.00838e-8,0.322613,0.946531,0,3.12521,-22.9729,-20.4758,1\",\"title\":\"Maxillaire PLY\"}','PLY',6,'SYNCED',0,NULL,'2021-02-01 20:56:49.000','2023-06-13 12:02:09.537','2023-06-13 14:02:09.537'),('4e355e83-f72e-471f-a217-6dc5ae2fd8aa',662,'/var/.data/2021/662/03ec19f1-9f11-4710-a0cd-c5d7739e40d7/session_f474819e-9470-4612-8275-2ceb25b5522f/occlusion_484ae4d8-329f-49b5-8d83-312a8a92ff22/scan_0d792709-57f3-49e1-963c-d2dc35a59d12/16_w1_o1_mordu_posterieur_gauche_scan_file_0.ply','PATIENT_03ec19f1-9f11-4710-a0cd-c5d7739e40d7_ACT_f474819e-9470-4612-8275-2ceb25b5522f_SESS_484ae4d8-329f-49b5-8d83-312a8a92ff22_LESC_0d792709-57f3-49e1-963c-d2dc35a59d12_MODEL','16_w1_o1_mordu_posterieur_gauche_scan_file_0.ply','4e355e83-f72e-471f-a217-6dc5ae2fd8aa','{\"displayTitle\":\"Mordu posterieur gauche 1.16.1.1.1\",\"modelMatrix\":\"-0.858745,-0.116475,0.502467,0,0.27595,-0.892272,0.327566,0,0.434036,0.438434,0.800166,0,-3.20598,-9.41496,-26.1205,1\",\"title\":\"Mordu posterieur gauche PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-02-27 10:55:29.000','2023-06-13 12:02:09.903','2023-06-13 14:02:09.903'),('4ec9ee9c-a56b-483d-ba09-9dc992d7e79c',662,'','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_ec084612-67a2-4430-ae15-7fe0edeaca64_SESS_2ed4960a-e6fa-46de-a306-32385df3346c_BOSC_45b21304-1129-40a2-b60e-d72a2bf96e72_SNAPS','2_w3_o2_mandibule_snapshot_1.png','7d1b5372-e89a-471e-8230-71dba1f47677','{\"displayTitle\":\"MANDIBULE 1.2.3.2.1\",\"title\":\"MANDIBULE SNAPSHOT\"}','PNG',1,'SYNCED',0,'2023-04-12 06:40:33.000','2020-04-12 08:05:48.000','2023-06-13 12:02:15.164','2023-06-13 14:02:15.164'),('4f638684-087b-42a0-916a-a8adc0c1eeea',662,'/var/.data/2021/662/5587321c-4405-49dc-90d5-8810cc776c6d/session_7e359a5f-1756-4ec7-8657-3e5940ae489d/occlusion_b29b47d4-35f8-427d-9cd7-a393e48be2cf/scan_42b09cf6-e30d-4d35-a17d-d8e8b4564638/20_w1_o1_maxillaire_scan_file_1.zip','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_TOSC_42b09cf6-e30d-4d35-a17d-d8e8b4564638_MODEL','20_w1_o1_maxillaire_scan_file_1.zip','3b5b5fb9-a2cd-4386-9406-17bd2384e1ae','{\"displayTitle\":\"Maxillaire 1.20.1.1.1\",\"modelMatrix\":\"0.322976,0.912912,-0.249555,0,-0.946407,0.311546,-0.0851648,0,4.13598e-9,0.263687,0.964608,0,-7.27814,-21.2146,-22.2509,1\",\"title\":\"Maxillaire ZIP\"}','ZIP',1,'SYNCED',0,NULL,'2021-10-12 12:37:46.000','2023-06-13 12:02:12.712','2023-06-13 14:02:12.712'),('506aaec6-4b3a-4a00-9e18-ddc95eb010f4',662,'/var/.data/2021/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_9716867f-e0a3-478a-a498-1e84ae803044/21_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_LESC_9716867f-e0a3-478a-a498-1e84ae803044_MODEL','21_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','506aaec6-4b3a-4a00-9e18-ddc95eb010f4','{\"displayTitle\":\"Mordu posterieur gauche 1.21.1.1.1\",\"modelMatrix\":\"-0.979327,-0.19794,-0.0323168,0,0.199218,-0.909497,-0.368149,0,0.0360368,-0.365565,0.929242,0,-7.63668,9.57847,-19.1431,1\",\"title\":\"Mordu posterieur gauche ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2021-11-22 12:45:44.000','2023-06-13 12:02:12.859','2023-06-13 14:02:12.859'),('517e0273-72a1-4e4d-8815-d303a233a31d',662,'/var/.data/2020/662/1af643c4-44fe-4ccb-b545-dbc90b47633b/session_a6ab7edf-6040-4f1a-b898-a1120a854927/occlusion_e06b73d5-45f7-4906-ba73-560d66ac56af/scan_e9134dab-33d6-42e4-8779-ab502b18266c/7_w4_o1_maxillaire_snapshot_2.png','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_a6ab7edf-6040-4f1a-b898-a1120a854927_SESS_e06b73d5-45f7-4906-ba73-560d66ac56af_TOSC_e9134dab-33d6-42e4-8779-ab502b18266c_SNAPS','7_w4_o1_maxillaire_snapshot_2.png','449406e4-68d2-4fa1-9032-2e72795a7ec2','{\"displayTitle\":\"Maxillaire 1.7.4.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}','PNG',2,'SYNCED',0,NULL,'2020-04-16 11:05:55.000','2023-06-13 12:02:10.042','2023-06-13 14:02:10.042'),('51c81dd7-f872-4092-9a17-d9b3821ed7c8',662,'/var/.data/2020/662/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/occlusion_d402edb5-8449-46a8-862f-a1cd1ee21cf6/scan_b5005e42-2d4d-41b0-91d5-667275f3a9cc/10_w1_o1_mordu_posterieur_droit_scan_file_0.ply','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_SESS_d402edb5-8449-46a8-862f-a1cd1ee21cf6_RISC_b5005e42-2d4d-41b0-91d5-667275f3a9cc_MODEL','10_w1_o1_mordu_posterieur_droit_scan_file_0.ply','51c81dd7-f872-4092-9a17-d9b3821ed7c8','{\"displayTitle\":\"Mordu posterieur droit 1.10.1.1.1\",\"modelMatrix\":\"0.970166,-0.0451177,0.236343,0,0.0599288,0.995192,-0.0709438,0,-0.234978,0.087108,0.969085,0,-4.85849,-3.4382,-21.1955,1\",\"title\":\"MORDU_POSTERIEUR_DROIT PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-30 20:00:05.000','2023-06-13 12:02:12.498','2023-06-13 14:02:12.498'),('520242d1-a563-40d8-b43b-1c26fd0f28ff',662,'/var/.data/2023/662/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_586a7c87-5d8a-440f-a654-c452dc908844/occlusion_d70cc224-5e0d-4b47-9270-d8e23a25b566/scan_0e5656e0-946b-41b2-935b-ea820746e5a9/19_w4_o1_maxillaire_snapshot_1.png','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_586a7c87-5d8a-440f-a654-c452dc908844_SESS_d70cc224-5e0d-4b47-9270-d8e23a25b566_TOSC_0e5656e0-946b-41b2-935b-ea820746e5a9_SNAPS','19_w4_o1_maxillaire_snapshot_1.png','bad6504a-4f54-4dc9-83e3-02475160f717','{\"displayTitle\":\"Maxillaire 1.19.4.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2023-03-21 12:27:26.000','2023-04-12 04:40:36.513','2023-04-12 06:40:36.513'),('520d0710-d923-46c1-a1dd-f05370a3a5ea',662,'/var/.data/2021/662/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_79548cb6-a61f-44cb-b6f7-cab7698f7465/14_w1_o1_mordu_posterieur_droit_scan_file_0.ply','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_RISC_79548cb6-a61f-44cb-b6f7-cab7698f7465_MODEL','14_w1_o1_mordu_posterieur_droit_scan_file_0.ply','520d0710-d923-46c1-a1dd-f05370a3a5ea','{\"displayTitle\":\"Mordu posterieur droit 1.14.1.1.1\",\"modelMatrix\":\"0.998532,-0.0354503,-0.0422502,0,0.0245382,0.980179,-0.193733,0,0.048334,0.194944,0.980148,0,10.0643,-4.18965,-19.1418,1\",\"title\":\"Mordu posterieur droit PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-02-01 21:12:36.000','2023-06-13 12:02:09.604','2023-06-13 14:02:09.604'),('536f2d6d-667c-4e47-bf9c-c77be612a54a',662,'/var/.data/2020/662/406a8572-4b0f-480a-ad2e-daf5530143b6/session_100a15d0-4590-4544-9331-365a087a5b57/occlusion_348477f7-c7a9-4bb3-8b28-3da592902286/scan_12f64013-f8aa-44bb-91e8-38c23737152b/2_w5_o1_maxillaire_snapshot_0.png','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_100a15d0-4590-4544-9331-365a087a5b57_SESS_348477f7-c7a9-4bb3-8b28-3da592902286_TOSC_12f64013-f8aa-44bb-91e8-38c23737152b_SNAPS','2_w5_o1_maxillaire_snapshot_0.png','536f2d6d-667c-4e47-bf9c-c77be612a54a','{\"displayTitle\":\"Maxillaire 1.2.5.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-29 14:50:36.000','2023-06-13 12:02:10.378','2023-06-13 14:02:10.378'),('53ebdc66-a057-4dc0-8a89-3e9bc7e5d11d',662,'/var/.data/2022/662/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_129a6c33-3cca-43ab-b97a-56d0e82a546f/occlusion_b5b4db66-f433-46fb-b794-d632b8fe8e1d/scan_ed495283-b756-4052-ba8b-5fe9f9b1f8be/19_w3_o1_maxillaire_scan_file_0.zip','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_129a6c33-3cca-43ab-b97a-56d0e82a546f_SESS_b5b4db66-f433-46fb-b794-d632b8fe8e1d_TOSC_ed495283-b756-4052-ba8b-5fe9f9b1f8be_MODEL','19_w3_o1_maxillaire_scan_file_0.zip','53ebdc66-a057-4dc0-8a89-3e9bc7e5d11d','{\"displayTitle\":\"Maxillaire 1.19.3.1.1\",\"modelMatrix\":\"0.999961,0.00799696,-0.00365457,0,-0.00879246,0.90949,-0.415632,0,-1.43557e-10,0.415648,0.909525,0,-23.2937,3.70277,-19.5102,1\",\"title\":\"Maxillaire ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-11-02 12:26:50.000','2023-06-13 12:02:13.625','2023-06-13 14:02:13.625'),('5498794c-1fcc-48dd-b50e-b57ca5d157ab',662,'/var/.data/2021/662/f15cb858-4f0b-44ec-a017-5e662039ba19/session_72b7a457-e38f-4535-8eba-6c98b43e5e55/occlusion_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c/scan_be9a4ba5-715b-4547-a31d-66621ec7b17f/14_w2_o1_maxillaire_scan_file_0.ply','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_72b7a457-e38f-4535-8eba-6c98b43e5e55_SESS_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c_TOSC_be9a4ba5-715b-4547-a31d-66621ec7b17f_MODEL','14_w2_o1_maxillaire_scan_file_0.ply','5498794c-1fcc-48dd-b50e-b57ca5d157ab','{\"displayTitle\":\"Maxillaire 1.14.2.1.1\",\"modelMatrix\":\"0.745896,0.665976,-0.010717,0,-0.666062,0.7458,-0.0120016,0,-8.36857e-11,0.0160902,0.99987,0,-12.7515,-0.602183,-24.4728,1\",\"title\":\"Maxillaire PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-06-08 20:11:20.000','2023-06-13 12:02:12.226','2023-06-13 14:02:12.226'),('55cd923a-d543-4e42-8f4a-de07877d1b09',662,'/var/.data/2021/662/5587321c-4405-49dc-90d5-8810cc776c6d/session_7e359a5f-1756-4ec7-8657-3e5940ae489d/occlusion_b29b47d4-35f8-427d-9cd7-a393e48be2cf/scan_a6d52fce-2e61-4375-bf6d-a36f9b3eb72f/20_w1_o1_mordu_posterieur_gauche_snapshot_0.png','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_LESC_a6d52fce-2e61-4375-bf6d-a36f9b3eb72f_SNAPS','20_w1_o1_mordu_posterieur_gauche_snapshot_0.png','55cd923a-d543-4e42-8f4a-de07877d1b09','{\"displayTitle\":\"Mordu posterieur gauche 1.20.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-10-12 12:42:38.000','2023-06-13 12:02:12.692','2023-06-13 14:02:12.692'),('569cf3b9-ec78-4231-a836-d4fe2c1273c0',662,'/var/.data/2021/662/f15cb858-4f0b-44ec-a017-5e662039ba19/session_72b7a457-e38f-4535-8eba-6c98b43e5e55/occlusion_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c/scan_437ef945-eb42-4841-9b20-34804bd5cfd6/14_w2_o1_mandibule_snapshot_1.png','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_72b7a457-e38f-4535-8eba-6c98b43e5e55_SESS_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c_BOSC_437ef945-eb42-4841-9b20-34804bd5cfd6_SNAPS','14_w2_o1_mandibule_snapshot_1.png','1f92b4ea-73e7-423b-8d75-46b280f139d9','{\"displayTitle\":\"Mandibule 1.14.2.1.2\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2021-06-08 20:46:38.000','2023-06-13 12:02:12.304','2023-06-13 14:02:12.304'),('587c45f4-d25d-4cad-8934-761b77e11986',662,'/var/.data/2021/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_c00beb59-a67d-4566-801a-0081588c2a04/21_w1_o1_mordu_posterieur_droit_snapshot_0.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_RISC_c00beb59-a67d-4566-801a-0081588c2a04_SNAPS','21_w1_o1_mordu_posterieur_droit_snapshot_0.png','587c45f4-d25d-4cad-8934-761b77e11986','{\"displayTitle\":\"Mordu posterieur droit 1.21.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-11-22 12:44:59.000','2023-06-13 12:02:12.828','2023-06-13 14:02:12.828'),('58f5907e-16f5-4910-b9e6-81046fdd76df',662,'/var/.data/2020/662/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_a18ca6df-d765-4c6a-be28-13abd1c350af/scan_cb1d5d31-89cd-4ab4-bada-dc6b2235cac5/6_w1_o2_maxillaire_scan_file_0.ply','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_a18ca6df-d765-4c6a-be28-13abd1c350af_TOSC_cb1d5d31-89cd-4ab4-bada-dc6b2235cac5_MODEL','6_w1_o2_maxillaire_scan_file_0.ply','58f5907e-16f5-4910-b9e6-81046fdd76df','{\"displayTitle\":\"MAXILLAIRE 1.6.1.2.1\",\"modelMatrix\":\"-0.709561,0.699017,-0.0888712,0,-0.704644,-0.703895,0.0894914,0,-3.09832e-9,0.126122,0.992015,0,3.11906,-19.7171,-26.8926,1\",\"title\":\"MAXILLAIRE PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-17 10:58:56.000','2023-06-13 12:02:10.274','2023-06-13 14:02:10.274'),('59ebc4a1-1711-4a3b-ac06-f55565453d6a',662,'/var/.data/2021/662/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_643b3b5a-e991-4dbf-95c8-2fd609f83a8b/14_w1_o1_maxillaire_snapshot_2.png','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_TOSC_643b3b5a-e991-4dbf-95c8-2fd609f83a8b_SNAPS','14_w1_o1_maxillaire_snapshot_2.png','3d7bd9ef-9d44-4365-af74-4d2a31f8f2fb','{\"displayTitle\":\"Maxillaire 1.14.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',2,'SYNCED',0,NULL,'2021-02-01 20:35:28.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.098'),('59f86cb7-d0b5-456d-bb86-a5a83efb559d',662,'','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_RISC_76f39717-6f88-4e19-800c-f827a697a4d6_SNAPS','7_w2_o2_mordu_posterieur_droit_snapshot_0.png','59f86cb7-d0b5-456d-bb86-a5a83efb559d','{\"displayTitle\":\"MORDU_POSTERIEUR_DROIT 1.7.2.2.2\",\"title\":\"MORDU_POSTERIEUR_DROIT SNAPSHOT\"}','PNG',0,'SYNCED',0,'2023-04-12 06:40:56.000','2020-04-16 07:05:20.000','2023-06-13 12:02:15.342','2023-06-13 14:02:15.342'),('5b5466a1-e0a0-4b4b-8dd8-e9f815b047c0',662,'/var/.data/2021/662/615ede1a-dba9-4251-9e9e-6cbbd3041fdc/session_76dcd1f0-f6c7-480f-b07b-441679345d70/occlusion_c6fffa68-cc65-471a-a58e-135ebe4d0772/scan_7a39120e-2f79-4c3e-af4d-af72e8ca8062/15_w1_o1_mordu_posterieur_gauche_snapshot_1.png','PATIENT_615ede1a-dba9-4251-9e9e-6cbbd3041fdc_ACT_76dcd1f0-f6c7-480f-b07b-441679345d70_SESS_c6fffa68-cc65-471a-a58e-135ebe4d0772_LESC_7a39120e-2f79-4c3e-af4d-af72e8ca8062_SNAPS','15_w1_o1_mordu_posterieur_gauche_snapshot_1.png','9fa4fa76-ae1b-496c-bc61-9c8652c7f3d6','{\"displayTitle\":\"Mordu posterieur gauche 1.15.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2021-02-16 13:00:22.000','2023-06-13 12:02:09.771','2023-06-13 14:02:09.771'),('5ba33ea9-efd2-4c3f-b859-372b495c2e78',662,'/var/.data/2021/662/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_643b3b5a-e991-4dbf-95c8-2fd609f83a8b/14_w1_o1_maxillaire_scan_file_2.ply','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_TOSC_643b3b5a-e991-4dbf-95c8-2fd609f83a8b_MODEL','14_w1_o1_maxillaire_scan_file_2.ply','e720e2f6-8dce-43f4-a5d6-bf8c09037947','{\"displayTitle\":\"Maxillaire 1.14.1.1.1\",\"modelMatrix\":\"-0.999994,-0.00324516,0.000993101,0,0.00339371,-0.95622,0.292628,0,-1.80461e-11,0.29263,0.956226,0,6.1197,-20.7159,-21.6008,1\",\"title\":\"Maxillaire PLY\"}','PLY',2,'SYNCED',0,NULL,'2021-02-01 20:35:28.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.063'),('5bdd9b13-0942-46d1-92ac-4b22472007ae',662,'','PATIENT_d41de280-8cf3-4e57-893e-cc7a010bc864_ACT_c59a2f65-79fe-44cd-8377-e39aa0a44171_SESS_daf632b1-2c49-42c8-8899-0a0b2448bc3a_TOSC_fbfa4372-1faf-4a14-9f4e-70b7b375da7d_MODEL','9_w1_o1_maxillaire_scan_file_0.ply','5bdd9b13-0942-46d1-92ac-4b22472007ae','{\"displayTitle\":\"MAXILLAIRE 1.9.1.1.1\",\"modelMatrix\":\"0.222517,0.971298,-0.0840585,0,-0.974929,0.221688,-0.0191854,0,-1.29821e-9,0.0862201,0.996276,0,-1.81183,-1.13461,-10.0849,1\",\"title\":\"MAXILLAIRE PLY\"}','PLY',0,'SYNCED',0,'2023-04-12 06:40:48.000','2020-04-18 09:18:30.000','2023-06-13 12:02:09.963','2023-06-13 14:02:09.963'),('5c2ae31f-cf6e-42c8-9d38-6f41e1e8db02',662,'/var/.data/2022/662/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_7841125a-11dd-4b66-9179-cd371ea2f0f7/occlusion_12115366-8eb9-470b-a097-5d28bb5fdf38/scan_d675acff-ab7f-4d65-b55c-558379a8b3d0/23_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_LESC_d675acff-ab7f-4d65-b55c-558379a8b3d0_MODEL','23_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','5c2ae31f-cf6e-42c8-9d38-6f41e1e8db02','{\"displayTitle\":\"Mordu posterieur gauche 1.23.1.1.1\",\"modelMatrix\":\"-0.920954,-0.163259,0.356869,0,0.137547,-0.986573,-0.0612914,0,0.364705,-0.0162589,0.932237,0,3.48454,4.97084,-20.3055,1\",\"title\":\"Mordu posterieur gauche ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-01-11 12:39:02.000','2023-06-13 12:02:13.165','2023-06-13 14:02:13.165'),('5c922725-b41b-4e38-a244-6a9a320d291e',662,'/var/.data/2020/662/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_bdf42f40-5a7a-435b-a5e0-eb33efefbc97/computedocclusion_bdf42f40-5a7a-435b-a5e0-eb3migraoccl/6_w1_o1_mandibule_occlusion_occ_file_0.ply','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_bdf42f40-5a7a-435b-a5e0-eb33efefbc97_OCC_bdf42f40-5a7a-435b-a5e0-eb3migraoccl_BOPLY','6_w1_o1_mandibule_occlusion_occ_file_0.ply','5c922725-b41b-4e38-a244-6a9a320d291e','{\"displayTitle\":\"Mandibule Occlusion 1.6.1.1.1\",\"referenceScanID\":\"1.6.1.1.1\",\"title\":\"Mandibule Occlusion PLY\",\"occlusionMatrix\":\"0.830092,0.401191,-0.387304,0,0.546599,-0.722916,0.422655,0,-0.110423,-0.562536,-0.819369,0,-9.45899,18.1191,11.5445,1\"}','PLY',0,'SYNCED',0,NULL,'2020-04-10 11:52:17.000','2023-06-13 12:02:16.237','2023-06-13 14:02:16.237'),('5c991e5c-3b6f-409c-839c-1ed086c26caf',662,'/var/.data/2021/662/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_79548cb6-a61f-44cb-b6f7-cab7698f7465/14_w1_o1_mordu_posterieur_droit_snapshot_0.png','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_RISC_79548cb6-a61f-44cb-b6f7-cab7698f7465_SNAPS','14_w1_o1_mordu_posterieur_droit_snapshot_0.png','5c991e5c-3b6f-409c-839c-1ed086c26caf','{\"displayTitle\":\"Mordu posterieur droit 1.14.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-02-01 21:12:36.000','2023-06-13 12:02:09.587','2023-06-13 14:02:09.587'),('5d47b05f-f650-11ec-a752-9ec33d03e6dd',662,'/var/.data/2022/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/5d47b05f-f650-11ec-a752-9ec33d03e6dd.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_87965ef8-01eb-4830-8e8b-8b99ece62cf1_SESS_dce9ce0f-0933-4c98-af84-59e2b6395f8f_BOSC_bd51414b-f96e-4903-a2e2-44fb3189decd_MODEL','21_w2_o1_mandibule_scan_file_4.zip','5d47b05f-f650-11ec-a752-9ec33d03e6dd','{\"displayTitle\":\"Mandibule 1.21.2.1.1\",\"modelMatrix\":\"-0.976298,-0.210823,0.0489521,0,0.216432,-0.950998,0.220817,0,-2.3765e-10,0.226178,0.974086,0,10.9881,11.8679,-20.8564,1\",\"title\":\"Mandibule ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-06-27 21:02:22.000','2023-06-13 12:02:23.172','2023-06-13 14:02:23.172'),('5d497163-f650-11ec-a752-9ec33d03e6dd',662,'/var/.data/2022/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/5d497163-f650-11ec-a752-9ec33d03e6dd.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_87965ef8-01eb-4830-8e8b-8b99ece62cf1_SESS_dce9ce0f-0933-4c98-af84-59e2b6395f8f_BOSC_bd51414b-f96e-4903-a2e2-44fb3189decd_SNAPS','21_w2_o1_mandibule_snapshot_4.png','5d497163-f650-11ec-a752-9ec33d03e6dd','{\"displayTitle\":\"Mandibule 1.21.2.1.1\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-06-27 21:02:19.000','2023-06-13 12:02:23.180','2023-06-13 14:02:23.180'),('5dfbe9b8-c587-4311-b392-743be40fdd10',662,'/var/.data/2021/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97/21_w1_o1_mandibule_snapshot_0.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_BOSC_f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97_SNAPS','21_w1_o1_mandibule_snapshot_0.png','5dfbe9b8-c587-4311-b392-743be40fdd10','{\"displayTitle\":\"Mandibule 1.21.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-11-22 12:30:44.000','2023-06-13 12:02:12.902','2023-06-13 14:02:12.902'),('5e1416aa-d0a4-4f50-98c6-8e1f1e6d994d',662,'/var/.data/2020/662/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_a18ca6df-d765-4c6a-be28-13abd1c350af/scan_919caf8c-919a-49cc-bf39-68486f2f5991/6_w1_o2_mordu_anterieur_scan_file_0.ply','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_a18ca6df-d765-4c6a-be28-13abd1c350af_FRSC_919caf8c-919a-49cc-bf39-68486f2f5991_MODEL','6_w1_o2_mordu_anterieur_scan_file_0.ply','5e1416aa-d0a4-4f50-98c6-8e1f1e6d994d','{\"displayTitle\":\"Mordu anterieur 1.6.1.2.1\",\"modelMatrix\":\"0.803599,0.0994624,0.586898,0,0.1055,0.957479,-0.233274,0,-0.586133,0.275977,0.776954,0,9.98439,-10.4134,-31.4327,1\",\"title\":\"MORDU_ANTERIEUR PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-17 11:19:52.000','2023-06-13 12:02:10.359','2023-06-13 14:02:10.359'),('5f33a727-5198-4fcf-af3d-ae94e86da222',662,'/var/.data/2022/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_87965ef8-01eb-4830-8e8b-8b99ece62cf1/occlusion_dce9ce0f-0933-4c98-af84-59e2b6395f8f/scan_bd51414b-f96e-4903-a2e2-44fb3189decd/21_w2_o1_mandibule_scan_file_1.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_87965ef8-01eb-4830-8e8b-8b99ece62cf1_SESS_dce9ce0f-0933-4c98-af84-59e2b6395f8f_BOSC_bd51414b-f96e-4903-a2e2-44fb3189decd_MODEL','21_w2_o1_mandibule_scan_file_1.zip','1f29b918-27fd-422b-b4dd-da18687d0871','{\"displayTitle\":\"Mandibule 1.21.2.1.1\",\"modelMatrix\":\"-0.916906,-0.389784,0.0857374,0,0.399102,-0.895499,0.196975,0,-4.7885e-09,0.214826,0.976652,0,7.49013,13.7993,-21.0213,1\",\"title\":\"Mandibule ZIP\"}','ZIP',1,'SYNCED',0,NULL,'2022-06-27 20:53:20.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.086'),('5f516c96-8333-49f5-8c71-3a7e8878488c',662,'/var/.data/2021/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_9716867f-e0a3-478a-a498-1e84ae803044/21_w1_o1_mordu_posterieur_gauche_scan_file_1.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_LESC_9716867f-e0a3-478a-a498-1e84ae803044_MODEL','21_w1_o1_mordu_posterieur_gauche_scan_file_1.zip','506aaec6-4b3a-4a00-9e18-ddc95eb010f4','{\"displayTitle\":\"Mordu posterieur gauche 1.21.1.1.1\",\"modelMatrix\":\"-0.947449,-0.317073,-0.0557049,0,0.311962,-0.870195,-0.378767,0,0.070887,-0.377135,0.923815,0,-13.1535,4.28606,-27.5789,1\",\"title\":\"Mordu posterieur gauche ZIP\"}','ZIP',1,'SYNCED',0,NULL,'2021-11-22 12:47:34.000','2023-06-13 12:02:12.867','2023-06-13 14:02:12.867'),('5fe946a4-d7b1-4c37-a75f-cda8a073daf9',662,'/var/.data/2020/662/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/occlusion_b87f1382-55d4-4e52-b63a-6f387df18b16/scan_a26f0d58-ca46-4921-a9e1-9c39b7f89783/13_w4_o1_maxillaire_scan_file_1.ply','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_SESS_b87f1382-55d4-4e52-b63a-6f387df18b16_TOSC_a26f0d58-ca46-4921-a9e1-9c39b7f89783_MODEL','13_w4_o1_maxillaire_scan_file_1.ply','23251874-b8f3-48b3-b209-0b434edd5db0','{\"displayTitle\":\"Maxillaire 1.13.4.1.1\",\"modelMatrix\":\"-0.89024,0.444444,-0.0997069,0,-0.455491,-0.86865,0.194873,0,1.75316e-9,0.2189,0.975747,0,10.9035,-11.3815,-23.882,1\",\"title\":\"Maxillaire PLY\"}','PLY',1,'SYNCED',0,NULL,'2020-12-29 11:05:41.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.087'),('6008312e-ba22-4c98-a696-7500991d7069',662,'/var/.data/2020/662/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/occlusion_d402edb5-8449-46a8-862f-a1cd1ee21cf6/scan_b7931623-9b21-4440-a950-16565249bf9a/10_w1_o1_mandibule_scan_file_0.ply','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_SESS_d402edb5-8449-46a8-862f-a1cd1ee21cf6_BOSC_b7931623-9b21-4440-a950-16565249bf9a_MODEL','10_w1_o1_mandibule_scan_file_0.ply','6008312e-ba22-4c98-a696-7500991d7069','{\"displayTitle\":\"MANDIBULE 1.10.1.1.2\",\"modelMatrix\":\"-0.991072,-0.129381,0.0321926,0,0.133326,-0.961748,0.239303,0,-1.16605e-10,0.241458,0.970411,0,20.8935,7.05365,-21.3854,1\",\"title\":\"MANDIBULE PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-30 19:47:40.000','2023-06-13 12:02:12.468','2023-06-13 14:02:12.468'),('6026647a-901e-4a90-bd11-8ec6d1883285',662,'/var/.data/2021/662/03ec19f1-9f11-4710-a0cd-c5d7739e40d7/session_f474819e-9470-4612-8275-2ceb25b5522f/occlusion_484ae4d8-329f-49b5-8d83-312a8a92ff22/scan_57e7671e-1671-4ee9-96a0-650a56963aa8/16_w1_o1_mordu_anterieur_snapshot_0.png','PATIENT_03ec19f1-9f11-4710-a0cd-c5d7739e40d7_ACT_f474819e-9470-4612-8275-2ceb25b5522f_SESS_484ae4d8-329f-49b5-8d83-312a8a92ff22_FRSC_57e7671e-1671-4ee9-96a0-650a56963aa8_SNAPS','16_w1_o1_mordu_anterieur_snapshot_0.png','6026647a-901e-4a90-bd11-8ec6d1883285','{\"displayTitle\":\"Mordu anterieur 1.16.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-02-27 10:58:59.000','2023-06-13 12:02:09.932','2023-06-13 14:02:09.932'),('60418949-4776-4ecc-898e-ee8453d29ba9',662,'/var/.data/2022/662/665b40ce-9690-4944-b007-4a96c1f5d57d/session_8f87b136-cb98-4706-b7d4-51059e1afa06/occlusion_5f895907-3eed-4aa7-995a-f7e1c9661a0a/scan_26a765d3-8b92-4861-984a-bd9c8040209b/25_w1_o1_mandibule_snapshot_1.png','PATIENT_665b40ce-9690-4944-b007-4a96c1f5d57d_ACT_8f87b136-cb98-4706-b7d4-51059e1afa06_SESS_5f895907-3eed-4aa7-995a-f7e1c9661a0a_BOSC_26a765d3-8b92-4861-984a-bd9c8040209b_SNAPS','25_w1_o1_mandibule_snapshot_1.png','7f09064b-ad1e-4cc1-9d0b-40bde9e22dff','{\"displayTitle\":\"Mandibule 1.25.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2022-03-11 10:31:23.000','2023-06-13 12:02:13.232','2023-06-13 14:02:13.232'),('60447943-1739-4e3f-aced-0eb015c274a2',662,'','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_cb9d8495-b4dd-423f-a624-7cff70e4db55_PROST_fb151d98-0604-45ed-8599-26fa11975b19_FORM','2_w2_odf_prost_file_0.pdf','60447943-1739-4e3f-aced-0eb015c274a2','{\"displayTitle\":\"ODF 1.2.2.2 ODF\",\"title\":\"Odf PDF\"}','PDF',0,'SYNCED',0,'2023-04-12 06:40:37.000','2020-04-13 07:59:28.000','2023-06-13 12:02:17.624','2023-06-13 14:02:17.624'),('60a7c19d-824d-4fdf-a109-f3df643a3f1a',662,'/var/.data/2020/662/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/occlusion_d402edb5-8449-46a8-862f-a1cd1ee21cf6/scan_b7931623-9b21-4440-a950-16565249bf9a/10_w1_o1_mandibule_snapshot_3.png','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_SESS_d402edb5-8449-46a8-862f-a1cd1ee21cf6_BOSC_b7931623-9b21-4440-a950-16565249bf9a_SNAPS','10_w1_o1_mandibule_snapshot_3.png','f3f82ebd-8318-469e-9bdd-ff76223b9c1c','{\"displayTitle\":\"Mandibule 1.10.1.1.2\",\"title\":\"MANDIBULE SNAPSHOT\"}','PNG',3,'SYNCED',0,NULL,'2020-04-30 19:57:58.000','2023-06-13 12:02:12.457','2023-06-13 14:02:12.457'),('60b6e24d-83ab-4528-953e-a72aae732f49',662,'/var/.data/2021/662/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_643b3b5a-e991-4dbf-95c8-2fd609f83a8b/14_w1_o1_maxillaire_snapshot_1.png','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_TOSC_643b3b5a-e991-4dbf-95c8-2fd609f83a8b_SNAPS','14_w1_o1_maxillaire_snapshot_1.png','3d7bd9ef-9d44-4365-af74-4d2a31f8f2fb','{\"displayTitle\":\"Maxillaire 1.14.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2021-02-01 20:28:14.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.098'),('621b6179-82c4-4d83-a1ec-4b5eb2545a81',662,'/var/.data/2020/662/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_bdf42f40-5a7a-435b-a5e0-eb33efefbc97/scan_57cfef6d-c27e-45fa-81d7-e63b4f8c4429/6_w1_o1_mordu_posterieur_droit_scan_file_0.ply','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_bdf42f40-5a7a-435b-a5e0-eb33efefbc97_RISC_57cfef6d-c27e-45fa-81d7-e63b4f8c4429_MODEL','6_w1_o1_mordu_posterieur_droit_scan_file_0.ply','621b6179-82c4-4d83-a1ec-4b5eb2545a81','{\"displayTitle\":\"Mordu posterieur droit 1.6.1.1.1\",\"modelMatrix\":\"0.967684,-0.0911958,0.233449,0,0.119228,0.989884,-0.0860305,0,-0.222268,0.108839,0.968556,0,1.09016,-1.33091,-18.513,1\",\"title\":\"MORDU_POSTERIEUR_DROIT PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-10 11:41:52.000','2023-06-13 12:02:10.162','2023-06-13 14:02:10.162'),('632bdd11-c86e-438a-af78-cfcc9f793d03',662,'/var/.data/2021/662/f15cb858-4f0b-44ec-a017-5e662039ba19/session_72b7a457-e38f-4535-8eba-6c98b43e5e55/occlusion_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c/scan_be9a4ba5-715b-4547-a31d-66621ec7b17f/14_w2_o1_maxillaire_snapshot_2.png','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_72b7a457-e38f-4535-8eba-6c98b43e5e55_SESS_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c_TOSC_be9a4ba5-715b-4547-a31d-66621ec7b17f_SNAPS','14_w2_o1_maxillaire_snapshot_2.png','13fa1125-c9d0-498d-bc50-68dc9f4f1beb','{\"displayTitle\":\"Maxillaire 1.14.2.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',2,'SYNCED',0,NULL,'2021-06-08 20:19:55.000','2023-06-13 12:02:12.216','2023-06-13 14:02:12.216'),('6420c2d7-bcdf-4e2e-9ee7-e90e3b7b7045',662,'/var/.data/2021/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_a90158f7-0d39-4b9d-984b-57de06099c65/21_w1_o1_maxillaire_scan_file_2.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_TOSC_a90158f7-0d39-4b9d-984b-57de06099c65_MODEL','21_w1_o1_maxillaire_scan_file_2.zip','8396da09-c9ea-476d-ab69-648f06ec6534','{\"displayTitle\":\"Maxillaire 1.21.1.1.1\",\"modelMatrix\":\"0.637136,0.767927,-0.0659177,0,-0.770751,0.634802,-0.0544904,0,4.04895e-9,0.0855239,0.996336,0,-16.373,-8.74215,-20.4029,1\",\"title\":\"Maxillaire ZIP\"}','ZIP',2,'SYNCED',0,NULL,'2021-11-22 12:28:58.000','2023-06-13 12:02:12.788','2023-06-13 14:02:12.788'),('648cf438-b183-47f5-a0f7-c8a3e2e416c8',662,'/var/.data/2021/662/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_7a480eb2-a7b4-4ec5-b628-ef6c2043dd7a/14_w1_o1_mordu_posterieur_gauche_snapshot_0.png','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_LESC_7a480eb2-a7b4-4ec5-b628-ef6c2043dd7a_SNAPS','14_w1_o1_mordu_posterieur_gauche_snapshot_0.png','648cf438-b183-47f5-a0f7-c8a3e2e416c8','{\"displayTitle\":\"Mordu posterieur gauche 1.14.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-02-01 21:19:45.000','2023-06-13 12:02:09.623','2023-06-13 14:02:09.623'),('6558fea4-267a-4a73-8416-579630e68249',662,'/var/.data/2022/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_2a050d02-7424-4099-b1d0-2d7da678e690/occlusion_a5bc2d6f-0248-466f-a10b-08f5391fd12f/scan_d2cd260d-4191-4884-80e3-7ced9fa0f8ce/21_w5_o1_maxillaire_scan_file_0.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_2a050d02-7424-4099-b1d0-2d7da678e690_SESS_a5bc2d6f-0248-466f-a10b-08f5391fd12f_TOSC_d2cd260d-4191-4884-80e3-7ced9fa0f8ce_MODEL','21_w5_o1_maxillaire_scan_file_0.zip','6558fea4-267a-4a73-8416-579630e68249','{\"displayTitle\":\"Maxillaire 1.21.5.1.2\",\"modelMatrix\":\"0.831457,0.551906,-0.0638702,0,-0.55559,0.825944,-0.0955836,0,2.47096e-09,0.114959,0.99337,0,-27.5141,-15.8126,-25.61,1\",\"title\":\"Maxillaire ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-11-04 13:42:02.000','2023-06-13 12:02:14.941','2023-06-13 14:02:14.941'),('6578f0f2-99f0-4b42-b32d-3bfc8a7b4697',662,'/var/.data/2020/662/1af643c4-44fe-4ccb-b545-dbc90b47633b/session_a6ab7edf-6040-4f1a-b898-a1120a854927/occlusion_e06b73d5-45f7-4906-ba73-560d66ac56af/scan_e9134dab-33d6-42e4-8779-ab502b18266c/7_w4_o1_maxillaire_scan_file_1.ply','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_a6ab7edf-6040-4f1a-b898-a1120a854927_SESS_e06b73d5-45f7-4906-ba73-560d66ac56af_TOSC_e9134dab-33d6-42e4-8779-ab502b18266c_MODEL','7_w4_o1_maxillaire_scan_file_1.ply','40c9dd9e-b85c-4ed6-a37e-81b5b8e9124d','{\"displayTitle\":\"MAXILLAIRE 1.7.4.1.1\",\"modelMatrix\":\"0.819541,0.559981,-0.121547,0,-0.57302,0.800892,-0.173838,0,-7.97328e-9,0.212116,0.977244,0,-6.25362,-22.098,-27.5473,1\",\"title\":\"MAXILLAIRE PLY\"}','PLY',1,'SYNCED',0,NULL,'2020-04-16 11:01:03.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.075'),('65867250-5b1d-4a93-b4d9-d00468a4d2fa',662,'/var/.data/2021/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97/21_w1_o1_mandibule_scan_file_2.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_BOSC_f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97_MODEL','21_w1_o1_mandibule_scan_file_2.zip','3aa92b1f-240d-45e1-a722-e8da98368f3a','{\"displayTitle\":\"Mandibule 1.21.1.1.1\",\"modelMatrix\":\"-0.99017,-0.134891,0.0369673,0,0.139865,-0.954959,0.261709,0,1.04452e-9,0.264307,0.964438,0,19.475,8.78369,-21.2441,1\",\"title\":\"Mandibule ZIP\"}','ZIP',2,'SYNCED',0,NULL,'2021-11-22 12:38:44.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.093'),('664cb06d-0960-4f9e-9c04-b9080d0ba7c2',662,'/var/.data/2020/662/d41de280-8cf3-4e57-893e-cc7a010bc864/session_c59a2f65-79fe-44cd-8377-e39aa0a44171/occlusion_daf632b1-2c49-42c8-8899-0a0b2448bc3a/scan_13e9c4af-5ddc-4a12-ae1b-2b802c735c3f/9_w1_o1_mordu_anterieur_snapshot_0.png','PATIENT_d41de280-8cf3-4e57-893e-cc7a010bc864_ACT_c59a2f65-79fe-44cd-8377-e39aa0a44171_SESS_daf632b1-2c49-42c8-8899-0a0b2448bc3a_FRSC_13e9c4af-5ddc-4a12-ae1b-2b802c735c3f_SNAPS','9_w1_o1_mordu_anterieur_snapshot_0.png','664cb06d-0960-4f9e-9c04-b9080d0ba7c2','{\"displayTitle\":\"Mordu anterieur 1.9.1.1.1\",\"title\":\"MORDU_ANTERIEUR SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-18 09:37:59.000','2023-06-13 12:02:10.494','2023-06-13 14:02:10.494'),('675a601d-d389-403d-858d-555ff6166630',662,'/var/.data/2020/662/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_bdf42f40-5a7a-435b-a5e0-eb33efefbc97/computedocclusion_bdf42f40-5a7a-435b-a5e0-eb3migraoccl/6_w1_o1_snapshot_occ_file_0.png','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_bdf42f40-5a7a-435b-a5e0-eb33efefbc97_OCC_bdf42f40-5a7a-435b-a5e0-eb3migraoccl_SNAPO','6_w1_o1_snapshot_occ_file_0.png','675a601d-d389-403d-858d-555ff6166630','{\"displayTitle\":\"Snapshot 1.6.1.1\",\"title\":\"Snapshot SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-10 11:52:17.000','2023-06-13 12:02:16.245','2023-06-13 14:02:16.245'),('6771d7ca-3bca-47bd-a554-166ba1db633b',662,'/var/.data/2023/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_2c78d514-95bd-4529-b0a1-babfb83849b1/occlusion_983c39b6-656b-4bf2-bf43-da1625adb861/scan_209f3c55-7380-4efa-8e6c-dfe8c99792a6/21_w7_o1_mandibule_scan_file_3.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_2c78d514-95bd-4529-b0a1-babfb83849b1_SESS_983c39b6-656b-4bf2-bf43-da1625adb861_BOSC_209f3c55-7380-4efa-8e6c-dfe8c99792a6_MODEL','21_w7_o1_mandibule_scan_file_3.zip','097b9793-f270-498e-9cfe-cf6bc2963744','{\"displayTitle\":\"Mandibule 1.21.7.1.1\",\"modelMatrix\":\"0.999992,0.00405771,-0.0006493,0,-0.00410933,0.98743,-0.158005,0,-4.66471e-11,0.158006,0.987438,0,-23.6056,-12.6921,-21.8912,1\",\"title\":\"Mandibule ZIP\"}','ZIP',3,'SYNCED',0,NULL,'2023-01-11 12:37:42.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.044'),('68061e27-8872-4682-9ba9-a57f6a95d8d3',662,'/var/.data/2021/662/03ec19f1-9f11-4710-a0cd-c5d7739e40d7/session_f474819e-9470-4612-8275-2ceb25b5522f/occlusion_484ae4d8-329f-49b5-8d83-312a8a92ff22/scan_19627cd9-e6e6-4c6f-9a62-46d708ca49bc/16_w1_o1_mandibule_snapshot_0.png','PATIENT_03ec19f1-9f11-4710-a0cd-c5d7739e40d7_ACT_f474819e-9470-4612-8275-2ceb25b5522f_SESS_484ae4d8-329f-49b5-8d83-312a8a92ff22_BOSC_19627cd9-e6e6-4c6f-9a62-46d708ca49bc_SNAPS','16_w1_o1_mandibule_snapshot_0.png','68061e27-8872-4682-9ba9-a57f6a95d8d3','{\"displayTitle\":\"Mandibule 1.16.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-02-27 10:43:29.000','2023-06-13 12:02:09.850','2023-06-13 14:02:09.850'),('687b8177-c7c5-42f4-8937-a0b8e331f674',662,'/var/.data/2020/662/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_a18ca6df-d765-4c6a-be28-13abd1c350af/scan_37ff1278-3dd1-470a-8159-e763f6626f5d/6_w1_o2_mandibule_snapshot_1.png','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_a18ca6df-d765-4c6a-be28-13abd1c350af_BOSC_37ff1278-3dd1-470a-8159-e763f6626f5d_SNAPS','6_w1_o2_mandibule_snapshot_1.png','f297816f-db2c-4167-bd60-28d3e93bb7c9','{\"displayTitle\":\"Mandibule 1.6.1.2.1\",\"title\":\"MANDIBULE SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2020-04-17 11:12:10.000','2023-06-13 12:02:10.230','2023-06-13 14:02:10.230'),('689b438f-3633-4981-b669-5e49a97a5c95',662,'/var/.data/2022/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_848b25bd-90a8-4105-871d-f9326fe94c7b/occlusion_ba7da56a-5a10-4378-a887-8e98aa892a3c/scan_b002027b-930d-4b96-a687-453aeea5659e/21_w6_o1_maxillaire_scan_file_1.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_848b25bd-90a8-4105-871d-f9326fe94c7b_SESS_ba7da56a-5a10-4378-a887-8e98aa892a3c_TOSC_b002027b-930d-4b96-a687-453aeea5659e_MODEL','21_w6_o1_maxillaire_scan_file_1.zip','fad00b24-cf95-4da0-aa56-8c7af1870289','{\"displayTitle\":\"Maxillaire 1.21.6.1.1\",\"modelMatrix\":\"-0.98152,0.181469,-0.0607201,0,-0.191358,-0.930797,0.311448,0,-2.35099e-09,0.317312,0.948321,0,15.3508,-15.1772,-24.8569,1\",\"title\":\"Maxillaire ZIP\"}','ZIP',1,'SYNCED',0,NULL,'2022-12-21 12:14:32.000','2023-06-13 12:02:14.990','2023-06-13 14:02:14.990'),('6918be85-b74b-4069-b2b3-914477ca77ad',662,'/var/.data/2022/662/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_7841125a-11dd-4b66-9179-cd371ea2f0f7/occlusion_12115366-8eb9-470b-a097-5d28bb5fdf38/scan_f0b63e95-26e8-4213-a935-ca2c37ab36ba/23_w1_o1_mandibule_scan_file_1.zip','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_BOSC_f0b63e95-26e8-4213-a935-ca2c37ab36ba_MODEL','23_w1_o1_mandibule_scan_file_1.zip','d2ffe250-09d3-47fd-af00-7d6cc98742d8','{\"displayTitle\":\"Mandibule 1.23.1.1.1\",\"modelMatrix\":\"-0.841721,0.469057,-0.267377,0,-0.539912,-0.731259,0.41684,0,-1.10031e-8,0.495224,0.868765,0,14.7201,-8.7337,-18.0275,1\",\"title\":\"Mandibule ZIP\"}','ZIP',1,'SYNCED',0,NULL,'2022-01-11 12:35:42.000','2023-06-13 12:02:13.088','2023-06-13 14:02:13.088'),('6ad36229-9d4a-4773-85c5-492f1965bc80',662,'/var/.data/2021/662/5587321c-4405-49dc-90d5-8810cc776c6d/session_7e359a5f-1756-4ec7-8657-3e5940ae489d/occlusion_b29b47d4-35f8-427d-9cd7-a393e48be2cf/scan_453abb20-3827-4f8b-b57f-c656c72ebf11/20_w1_o1_mandibule_snapshot_0.png','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_BOSC_453abb20-3827-4f8b-b57f-c656c72ebf11_SNAPS','20_w1_o1_mandibule_snapshot_0.png','6ad36229-9d4a-4773-85c5-492f1965bc80','{\"displayTitle\":\"Mandibule SNAPSHOT\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-10-12 12:22:48.000','2023-06-13 12:02:12.740','2023-06-13 14:02:12.740'),('6b4f036d-deed-43fa-b8c0-889e20bb7692',662,'/var/.data/2022/662/665b40ce-9690-4944-b007-4a96c1f5d57d/session_8f87b136-cb98-4706-b7d4-51059e1afa06/occlusion_5f895907-3eed-4aa7-995a-f7e1c9661a0a/computedocclusion_c4999e75-8b1c-4a31-8e80-9b9cba9b57fd/25_w1_o1_mandibule_occlusion_occ_file_0.zip','PATIENT_665b40ce-9690-4944-b007-4a96c1f5d57d_ACT_8f87b136-cb98-4706-b7d4-51059e1afa06_SESS_5f895907-3eed-4aa7-995a-f7e1c9661a0a_OCC_c4999e75-8b1c-4a31-8e80-9b9cba9b57fd_BOPLY','25_w1_o1_mandibule_occlusion_occ_file_0.zip','6b4f036d-deed-43fa-b8c0-889e20bb7692','{\"displayTitle\":\"Mandibule 1.25.1.1.1 Occlusion 1\",\"referenceScanID\":\"1.25.1.1.1\",\"title\":\"Mandibule 1.25.1.1.1 Occlusion 1\",\"occlusionMatrix\":\"-0.40893,-0.765788,-0.496349,0,-0.910264,0.30363,0.281498,0,-0.0648592,0.566919,-0.821227,0,17.4771,-5.86145,14.482,1\"}','ZIP',0,'SYNCED',0,NULL,'2022-03-11 11:16:26.000','2023-06-13 12:02:16.300','2023-06-13 14:02:16.300'),('6bc59c6e-9179-4d61-91a6-7cfb0da22a7a',662,'/var/.data/2022/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_e43c8099-0862-42c3-9ad2-1efef27b83ba/occlusion_09f15124-6bba-4565-bfe4-efb3c6c3a17d/scan_3a315f7b-8cf2-4d0c-bf92-fecb623fe530/21_w3_o1_maxillaire_snapshot_0.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_e43c8099-0862-42c3-9ad2-1efef27b83ba_SESS_09f15124-6bba-4565-bfe4-efb3c6c3a17d_TOSC_3a315f7b-8cf2-4d0c-bf92-fecb623fe530_SNAPS','21_w3_o1_maxillaire_snapshot_0.png','6bc59c6e-9179-4d61-91a6-7cfb0da22a7a','{\"displayTitle\":\"Maxillaire 1.21.3.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-09-14 12:19:51.000','2023-06-13 12:02:13.515','2023-06-13 14:02:13.515'),('6bd04ecb-23d6-4510-a353-c2b68dba5457',662,'/var/.data/2020/662/d41de280-8cf3-4e57-893e-cc7a010bc864/session_c59a2f65-79fe-44cd-8377-e39aa0a44171/occlusion_daf632b1-2c49-42c8-8899-0a0b2448bc3a/scan_0a606279-3c91-4220-b876-e620d1bf52f6/9_w1_o1_mandibule_snapshot_0.png','PATIENT_d41de280-8cf3-4e57-893e-cc7a010bc864_ACT_c59a2f65-79fe-44cd-8377-e39aa0a44171_SESS_daf632b1-2c49-42c8-8899-0a0b2448bc3a_BOSC_0a606279-3c91-4220-b876-e620d1bf52f6_SNAPS','9_w1_o1_mandibule_snapshot_0.png','6bd04ecb-23d6-4510-a353-c2b68dba5457','{\"displayTitle\":\"Mandibule 1.9.1.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-18 09:32:12.000','2023-06-13 12:02:10.591','2023-06-13 14:02:10.591'),('6e406955-1a72-4b3a-8063-b460b758c328',662,'/var/.data/2020/662/d41de280-8cf3-4e57-893e-cc7a010bc864/session_c59a2f65-79fe-44cd-8377-e39aa0a44171/occlusion_daf632b1-2c49-42c8-8899-0a0b2448bc3a/scan_13e9c4af-5ddc-4a12-ae1b-2b802c735c3f/9_w1_o1_mordu_anterieur_scan_file_0.ply','PATIENT_d41de280-8cf3-4e57-893e-cc7a010bc864_ACT_c59a2f65-79fe-44cd-8377-e39aa0a44171_SESS_daf632b1-2c49-42c8-8899-0a0b2448bc3a_FRSC_13e9c4af-5ddc-4a12-ae1b-2b802c735c3f_MODEL','9_w1_o1_mordu_anterieur_scan_file_0.ply','6e406955-1a72-4b3a-8063-b460b758c328','{\"displayTitle\":\"Mordu anterieur 1.9.1.1.1\",\"modelMatrix\":\"0.837632,0.229018,0.500227,0,-0.0839393,0.934442,-0.320111,0,-0.541135,0.278075,0.805595,0,1.32498,-11.4951,-31.7428,1\",\"title\":\"MORDU_ANTERIEUR PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-18 09:37:59.000','2023-06-13 12:02:10.503','2023-06-13 14:02:10.503'),('6e7d5030-f9a6-4e4d-baf7-7a0f3c335bfc',662,'/var/.data/2021/662/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_ccd3f4f6-f303-4b20-b967-d41121f2e36b/14_w1_o1_mordu_anterieur_snapshot_0.png','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_FRSC_ccd3f4f6-f303-4b20-b967-d41121f2e36b_SNAPS','14_w1_o1_mordu_anterieur_snapshot_0.png','6e7d5030-f9a6-4e4d-baf7-7a0f3c335bfc','{\"displayTitle\":\"Mordu anterieur 1.14.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-02-01 21:22:33.000','2023-06-13 12:02:09.642','2023-06-13 14:02:09.642'),('6e9feeb8-6d42-4237-b134-51d979397898',662,'/var/.data/2021/662/615ede1a-dba9-4251-9e9e-6cbbd3041fdc/session_76dcd1f0-f6c7-480f-b07b-441679345d70/occlusion_c6fffa68-cc65-471a-a58e-135ebe4d0772/scan_e6e5d8c5-2d8c-48d0-9708-e3256202d385/15_w1_o1_mandibule_scan_file_0.ply','PATIENT_615ede1a-dba9-4251-9e9e-6cbbd3041fdc_ACT_76dcd1f0-f6c7-480f-b07b-441679345d70_SESS_c6fffa68-cc65-471a-a58e-135ebe4d0772_BOSC_e6e5d8c5-2d8c-48d0-9708-e3256202d385_MODEL','15_w1_o1_mandibule_scan_file_0.ply','6e9feeb8-6d42-4237-b134-51d979397898','{\"displayTitle\":\"Mandibule 1.15.1.1.1\",\"modelMatrix\":\"-0.941155,0.320097,-0.10847,0,-0.337976,-0.891367,0.302054,0,-5.37293e-9,0.32094,0.947099,0,10.178,0.290729,-14.518,1\",\"title\":\"Mandibule PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-02-16 12:40:32.000','2023-06-13 12:02:09.704','2023-06-13 14:02:09.704'),('6ea3e979-830a-4dd4-81e2-3d30db702b9c',662,'/var/.data/2022/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_8f3d7d42-f6ad-4e48-8951-08222c212e7e/occlusion_5bd97219-8b9e-46f5-ab9b-87ded07aa8a2/scan_2a466f6b-3960-4b1b-bb27-def76229cccc/21_w4_o1_mandibule_scan_file_1.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_8f3d7d42-f6ad-4e48-8951-08222c212e7e_SESS_5bd97219-8b9e-46f5-ab9b-87ded07aa8a2_BOSC_2a466f6b-3960-4b1b-bb27-def76229cccc_MODEL','21_w4_o1_mandibule_scan_file_1.zip','176a7141-81b2-436e-bbb3-00ec6028c71b','{\"displayTitle\":\"Mandibule 1.21.4.1.1\",\"modelMatrix\":\"-0.869846,0.486339,-0.0827174,0,-0.493324,-0.857531,0.14585,0,-1.01608e-11,0.167674,0.985843,0,18.5559,-1.85864,-18.3689,1\",\"title\":\"Mandibule ZIP\"}','ZIP',1,'SYNCED',0,NULL,'2022-11-04 12:31:51.000','2023-06-13 12:02:14.911','2023-06-13 14:02:14.911'),('6eeaf574-0aa0-4bc8-95c8-5d198f212e39',662,'/var/.data/2021/662/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_643b3b5a-e991-4dbf-95c8-2fd609f83a8b/14_w1_o1_maxillaire_scan_file_5.ply','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_TOSC_643b3b5a-e991-4dbf-95c8-2fd609f83a8b_MODEL','14_w1_o1_maxillaire_scan_file_5.ply','e720e2f6-8dce-43f4-a5d6-bf8c09037947','{\"displayTitle\":\"Maxillaire 1.14.1.1.1\",\"modelMatrix\":\"-0.957476,0.269833,-0.102129,0,-0.288514,-0.895482,0.338929,0,4.52228e-9,0.353982,0.935252,0,2.72857,-24.1516,-19.567,1\",\"title\":\"Maxillaire PLY\"}','PLY',5,'SYNCED',0,NULL,'2021-02-01 20:52:02.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.064'),('6f2ff317-b1e7-4c11-b0dd-c5b359491513',662,'/var/.data/2020/662/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_bdf42f40-5a7a-435b-a5e0-eb33efefbc97/scan_57cfef6d-c27e-45fa-81d7-e63b4f8c4429/6_w1_o1_mordu_posterieur_droit_snapshot_0.png','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_bdf42f40-5a7a-435b-a5e0-eb33efefbc97_RISC_57cfef6d-c27e-45fa-81d7-e63b4f8c4429_SNAPS','6_w1_o1_mordu_posterieur_droit_snapshot_0.png','6f2ff317-b1e7-4c11-b0dd-c5b359491513','{\"displayTitle\":\"Mordu posterieur droit 1.6.1.1.1\",\"title\":\"MORDU_POSTERIEUR_DROIT SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-10 11:41:52.000','2023-06-13 12:02:10.171','2023-06-13 14:02:10.171'),('6f481e07-43c0-494b-8d4f-279772780eec',662,'/var/.data/2022/662/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_129a6c33-3cca-43ab-b97a-56d0e82a546f/occlusion_b5b4db66-f433-46fb-b794-d632b8fe8e1d/scan_e9aaa539-6e84-47bc-9c50-2c8797de82a4/19_w3_o1_mordu_posterieur_gauche_scan_file_0.zip','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_129a6c33-3cca-43ab-b97a-56d0e82a546f_SESS_b5b4db66-f433-46fb-b794-d632b8fe8e1d_LESC_e9aaa539-6e84-47bc-9c50-2c8797de82a4_MODEL','19_w3_o1_mordu_posterieur_gauche_scan_file_0.zip','6f481e07-43c0-494b-8d4f-279772780eec','{\"displayTitle\":\"Mordu posterieur gauche 1.19.3.1.1\",\"modelMatrix\":\"-0.983417,-0.121012,0.138821,0,0.133349,-0.98274,0.127701,0,0.12304,0.140097,0.982062,0,-8.04084,2.09214,-18.4869,1\",\"title\":\"Mordu posterieur gauche ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-11-02 12:34:58.000','2023-06-13 12:02:13.562','2023-06-13 14:02:13.562'),('6fa55f91-2e1f-436b-b276-b2726e9125b4',662,'/var/.data/2022/662/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_7841125a-11dd-4b66-9179-cd371ea2f0f7/occlusion_12115366-8eb9-470b-a097-5d28bb5fdf38/scan_5a4f6b62-6381-4a1e-bbef-61746f2722d3/23_w1_o1_mordu_anterieur_scan_file_0.zip','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_FRSC_5a4f6b62-6381-4a1e-bbef-61746f2722d3_MODEL','23_w1_o1_mordu_anterieur_scan_file_0.zip','6fa55f91-2e1f-436b-b276-b2726e9125b4','{\"displayTitle\":\"Mordu anterieur 1.23.1.1.1\",\"modelMatrix\":\"0.84365,0.210589,0.497423,0,-0.180758,0.976383,-0.0219815,0,-0.506998,-0.0651306,0.867814,0,7.25809,0.136189,-25.0684,1\",\"title\":\"Mordu anterieur ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-01-11 12:41:15.000','2023-06-13 12:02:13.135','2023-06-13 14:02:13.135'),('6fe553ac-625b-4942-ad10-01bbe5250717',662,'/var/.data/2023/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_2c78d514-95bd-4529-b0a1-babfb83849b1/occlusion_983c39b6-656b-4bf2-bf43-da1625adb861/scan_209f3c55-7380-4efa-8e6c-dfe8c99792a6/21_w7_o1_mandibule_snapshot_5.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_2c78d514-95bd-4529-b0a1-babfb83849b1_SESS_983c39b6-656b-4bf2-bf43-da1625adb861_BOSC_209f3c55-7380-4efa-8e6c-dfe8c99792a6_SNAPS','21_w7_o1_mandibule_snapshot_5.png','252b180c-565f-4f14-af48-a16cebbead9e','{\"displayTitle\":\"Mandibule 1.21.7.1.1\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',5,'SYNCED',0,NULL,'2023-01-11 12:58:26.000','2023-06-13 12:02:15.063','2023-06-13 14:02:15.063'),('729f8772-5a1d-40db-b918-270cc340ba8e',662,'/var/.data/2020/662/1af643c4-44fe-4ccb-b545-dbc90b47633b/session_a6ab7edf-6040-4f1a-b898-a1120a854927/occlusion_e06b73d5-45f7-4906-ba73-560d66ac56af/scan_e9134dab-33d6-42e4-8779-ab502b18266c/7_w4_o1_maxillaire_snapshot_1.png','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_a6ab7edf-6040-4f1a-b898-a1120a854927_SESS_e06b73d5-45f7-4906-ba73-560d66ac56af_TOSC_e9134dab-33d6-42e4-8779-ab502b18266c_SNAPS','7_w4_o1_maxillaire_snapshot_1.png','449406e4-68d2-4fa1-9032-2e72795a7ec2','{\"displayTitle\":\"MAXILLAIRE 1.7.4.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2020-04-16 11:01:03.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.065'),('72c86a01-5d0c-47ea-8964-b3832ab6a43f',662,'/var/.data/2020/662/1af643c4-44fe-4ccb-b545-dbc90b47633b/session_a6ab7edf-6040-4f1a-b898-a1120a854927/occlusion_e06b73d5-45f7-4906-ba73-560d66ac56af/scan_8a4f0a25-fae8-4564-8f4a-63f4168b2915/7_w4_o1_mordu_posterieur_gauche_scan_file_0.ply','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_a6ab7edf-6040-4f1a-b898-a1120a854927_SESS_e06b73d5-45f7-4906-ba73-560d66ac56af_LESC_8a4f0a25-fae8-4564-8f4a-63f4168b2915_MODEL','7_w4_o1_mordu_posterieur_gauche_scan_file_0.ply','72c86a01-5d0c-47ea-8964-b3832ab6a43f','{\"displayTitle\":\"Mordu posterieur gauche 1.7.4.1.1\",\"modelMatrix\":\"-0.992023,-0.120871,0.0498108,0,0.101981,-0.962967,-0.242479,0,0.0742317,-0.241114,0.968899,0,4.47227,3.75609,-28.3252,1\",\"title\":\"MORDU_POSTERIEUR_GAUCHE PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-16 11:20:50.000','2023-06-13 12:02:10.083','2023-06-13 14:02:10.083'),('73466738-f8a5-4b0e-a6af-9c63c2e802e6',662,'/var/.data/2021/662/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_0c1ed331-8df6-482e-8dd1-508d9b190c49/occlusion_6c6bb813-840d-454a-ab1d-9232434a4500/scan_d7c4d383-83f9-4275-bbcc-567a47d4a450/19_w1_o1_mordu_posterieur_gauche_snapshot_0.png','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_LESC_d7c4d383-83f9-4275-bbcc-567a47d4a450_SNAPS','19_w1_o1_mordu_posterieur_gauche_snapshot_0.png','73466738-f8a5-4b0e-a6af-9c63c2e802e6','{\"displayTitle\":\"Mordu posterieur gauche 1.19.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-09-27 12:46:45.000','2023-06-13 12:02:12.526','2023-06-13 14:02:12.526'),('75fe196b-5c35-11ed-a752-9ec33d03e6dd',662,'/var/.data/2022/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/75fe196b-5c35-11ed-a752-9ec33d03e6dd.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_8f3d7d42-f6ad-4e48-8951-08222c212e7e_SESS_5bd97219-8b9e-46f5-ab9b-87ded07aa8a2_BOSC_2a466f6b-3960-4b1b-bb27-def76229cccc_MODEL','21_w4_o1_mandibule_scan_file_1.zip','75fe196b-5c35-11ed-a752-9ec33d03e6dd','{\"displayTitle\":\"Mandibule 1.21.4.1.1\",\"modelMatrix\":\"-0.869846,0.486339,-0.0827174,0,-0.493324,-0.857531,0.14585,0,-1.01608e-11,0.167674,0.985843,0,18.5559,-1.85864,-18.3689,1\",\"title\":\"Mandibule ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-11-04 12:31:51.000','2023-06-13 12:02:23.367','2023-06-13 14:02:23.367'),('760044a3-5c35-11ed-a752-9ec33d03e6dd',662,'/var/.data/2022/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/760044a3-5c35-11ed-a752-9ec33d03e6dd.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_8f3d7d42-f6ad-4e48-8951-08222c212e7e_SESS_5bd97219-8b9e-46f5-ab9b-87ded07aa8a2_FRSC_b24d4ab4-dba3-4be5-8ba3-7eee381f40ec_SNAPS','21_w4_o1_mordu_anterieur_snapshot_0.png','760044a3-5c35-11ed-a752-9ec33d03e6dd','{\"displayTitle\":\"Mordu anterieur 1.21.4.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-11-04 12:34:43.000','2023-06-13 12:02:23.375','2023-06-13 14:02:23.375'),('7601ed6f-5c35-11ed-a752-9ec33d03e6dd',662,'/var/.data/2022/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/7601ed6f-5c35-11ed-a752-9ec33d03e6dd.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_8f3d7d42-f6ad-4e48-8951-08222c212e7e_SESS_5bd97219-8b9e-46f5-ab9b-87ded07aa8a2_FRSC_b24d4ab4-dba3-4be5-8ba3-7eee381f40ec_MODEL','21_w4_o1_mordu_anterieur_scan_file_0.zip','7601ed6f-5c35-11ed-a752-9ec33d03e6dd','{\"displayTitle\":\"Mordu anterieur 1.21.4.1.1\",\"modelMatrix\":\"0.851612,-0.0875762,0.519248,0,0.0198226,0.992855,0.0821935,0,-0.523851,-0.0914267,0.851687,0,-1.52728,6.0236,-29.6291,1\",\"title\":\"Mordu anterieur ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-11-04 12:34:44.000','2023-06-13 12:02:23.384','2023-06-13 14:02:23.384'),('76038e2c-5c35-11ed-a752-9ec33d03e6dd',662,'/var/.data/2022/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/76038e2c-5c35-11ed-a752-9ec33d03e6dd.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_8f3d7d42-f6ad-4e48-8951-08222c212e7e_SESS_5bd97219-8b9e-46f5-ab9b-87ded07aa8a2_BOSC_2a466f6b-3960-4b1b-bb27-def76229cccc_SNAPS','21_w4_o1_mandibule_snapshot_1.png','76038e2c-5c35-11ed-a752-9ec33d03e6dd','{\"displayTitle\":\"Mandibule 1.21.4.1.1\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-11-04 12:31:49.000','2023-06-13 12:02:23.393','2023-06-13 14:02:23.393'),('78194fe5-5ac7-4c4a-ba44-b374602235d5',662,'','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_a7b0f1ae-ce37-4faf-9b3c-e5fab6996549_SESS_254f3fc9-4782-4658-bb34-f2ca1c9b6382_BOSC_4caeed6a-b015-4556-8794-2c3a00fea341_SNAPS','2_w6_o1_mandibule_snapshot_0.png','78194fe5-5ac7-4c4a-ba44-b374602235d5','{\"displayTitle\":\"MANDIBULE 1.2.6.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}','PNG',0,'SYNCED',0,'2023-04-12 06:40:44.000','2020-05-21 08:03:19.000','2023-06-13 12:02:09.944','2023-06-13 14:02:09.944'),('78aec42f-0ec9-4ca8-b05e-324d3b955b86',662,'/var/.data/2021/662/03ec19f1-9f11-4710-a0cd-c5d7739e40d7/session_f474819e-9470-4612-8275-2ceb25b5522f/occlusion_484ae4d8-329f-49b5-8d83-312a8a92ff22/scan_d4c7f3c5-155d-41ef-8665-852e89c5e017/16_w1_o1_mordu_posterieur_droit_scan_file_0.ply','PATIENT_03ec19f1-9f11-4710-a0cd-c5d7739e40d7_ACT_f474819e-9470-4612-8275-2ceb25b5522f_SESS_484ae4d8-329f-49b5-8d83-312a8a92ff22_RISC_d4c7f3c5-155d-41ef-8665-852e89c5e017_MODEL','16_w1_o1_mordu_posterieur_droit_scan_file_0.ply','78aec42f-0ec9-4ca8-b05e-324d3b955b86','{\"displayTitle\":\"Mordu posterieur droit 1.16.1.1.1\",\"modelMatrix\":\"0.986563,-0.164722,-0.0244541,0,0.163417,0.974992,0.143113,0,-0.00273904,-0.149274,0.989419,0,-4.97646,-0.624993,-20.3173,1\",\"title\":\"Mordu posterieur droit PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-02-27 10:48:13.000','2023-06-13 12:02:09.870','2023-06-13 14:02:09.870'),('78fdec7c-2a35-41bb-8492-82f1c776d061',662,'/var/.data/2022/662/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_949fe730-88fa-4ec2-852e-dd0772ee3ee0/occlusion_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d/scan_1c6adc05-0655-4ad6-bcc9-27b0ef578ded/19_w2_o1_maxillaire_snapshot_3.png','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_949fe730-88fa-4ec2-852e-dd0772ee3ee0_SESS_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d_TOSC_1c6adc05-0655-4ad6-bcc9-27b0ef578ded_SNAPS','19_w2_o1_maxillaire_snapshot_3.png','d40f4bba-69b0-4cc6-b541-e69c16b2b3d5','{\"displayTitle\":\"Maxillaire 1.19.2.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',3,'SYNCED',0,NULL,'2022-06-28 20:34:07.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.045'),('791a0795-78ad-4b6e-a31b-bdc257f06704',662,'/var/.data/2021/662/5587321c-4405-49dc-90d5-8810cc776c6d/session_7e359a5f-1756-4ec7-8657-3e5940ae489d/occlusion_b29b47d4-35f8-427d-9cd7-a393e48be2cf/scan_00f07cdc-1834-4ae1-a9fa-47699828c094/20_w1_o1_mordu_posterieur_droit_snapshot_0.png','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_RISC_00f07cdc-1834-4ae1-a9fa-47699828c094_SNAPS','20_w1_o1_mordu_posterieur_droit_snapshot_0.png','791a0795-78ad-4b6e-a31b-bdc257f06704','{\"displayTitle\":\"Mordu posterieur droit 1.20.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-10-12 12:40:25.000','2023-06-13 12:02:12.652','2023-06-13 14:02:12.652'),('7935777d-a278-4364-9439-322233eba142',662,'','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_TOSC_778a761c-339e-4143-a807-735b174d9714_SNAPS','7_w2_o2_maxillaire_snapshot_0.png','7935777d-a278-4364-9439-322233eba142','{\"displayTitle\":\"MAXILLAIRE 1.7.2.2.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}','PNG',0,'SYNCED',0,'2023-04-12 06:40:21.000','2020-04-15 07:29:30.000','2023-06-13 12:02:15.399','2023-06-13 14:02:15.399'),('79ba2d1d-77b5-4b68-a71f-efb6c2b2b49d',662,'/var/.data/2020/662/1af643c4-44fe-4ccb-b545-dbc90b47633b/session_a6ab7edf-6040-4f1a-b898-a1120a854927/occlusion_e06b73d5-45f7-4906-ba73-560d66ac56af/scan_8a4f0a25-fae8-4564-8f4a-63f4168b2915/7_w4_o1_mordu_posterieur_gauche_snapshot_0.png','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_a6ab7edf-6040-4f1a-b898-a1120a854927_SESS_e06b73d5-45f7-4906-ba73-560d66ac56af_LESC_8a4f0a25-fae8-4564-8f4a-63f4168b2915_SNAPS','7_w4_o1_mordu_posterieur_gauche_snapshot_0.png','79ba2d1d-77b5-4b68-a71f-efb6c2b2b49d','{\"displayTitle\":\"Mordu posterieur gauche 1.7.4.1.1\",\"title\":\"MORDU_POSTERIEUR_GAUCHE SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-16 11:20:50.000','2023-06-13 12:02:10.092','2023-06-13 14:02:10.092'),('79cf9af7-3005-4b44-854c-ba038cba5f4b',662,'/var/.data/2020/662/1af643c4-44fe-4ccb-b545-dbc90b47633b/session_a6ab7edf-6040-4f1a-b898-a1120a854927/occlusion_e06b73d5-45f7-4906-ba73-560d66ac56af/scan_10c9626c-901e-4a0e-8f05-62042bf69c04/7_w4_o1_mandibule_scan_file_0.ply','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_a6ab7edf-6040-4f1a-b898-a1120a854927_SESS_e06b73d5-45f7-4906-ba73-560d66ac56af_BOSC_10c9626c-901e-4a0e-8f05-62042bf69c04_MODEL','7_w4_o1_mandibule_scan_file_0.ply','79cf9af7-3005-4b44-854c-ba038cba5f4b','{\"displayTitle\":\"Mandibule 1.7.4.1.1\",\"modelMatrix\":\"-0.347109,0.935335,-0.0682968,0,-0.937825,-0.346188,0.0252781,0,-3.27669e-10,0.0728247,0.997345,0,16.5074,-4.63486,-25.5661,1\",\"title\":\"MANDIBULE PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-16 11:14:29.000','2023-06-13 12:02:10.011','2023-06-13 14:02:10.011'),('79d52980-5104-4ca5-9286-27c93d8a0261',662,'/var/.data/2021/662/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_643b3b5a-e991-4dbf-95c8-2fd609f83a8b/14_w1_o1_maxillaire_scan_file_4.ply','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_TOSC_643b3b5a-e991-4dbf-95c8-2fd609f83a8b_MODEL','14_w1_o1_maxillaire_scan_file_4.ply','e720e2f6-8dce-43f4-a5d6-bf8c09037947','{\"displayTitle\":\"Maxillaire 1.14.1.1.1\",\"modelMatrix\":\"-0.986605,0.156151,-0.0471856,0,-0.163125,-0.944428,0.285387,0,3.69232e-10,0.289261,0.95725,0,4.81018,-21.3265,-21.1512,1\",\"title\":\"Maxillaire PLY\"}','PLY',4,'SYNCED',0,NULL,'2021-02-01 20:46:11.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.064'),('7a4d7123-69ae-4260-adf1-9661ad22cb0f',662,'/var/.data/2021/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_a90158f7-0d39-4b9d-984b-57de06099c65/21_w1_o1_maxillaire_snapshot_2.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_TOSC_a90158f7-0d39-4b9d-984b-57de06099c65_SNAPS','21_w1_o1_maxillaire_snapshot_2.png','2d1d8d21-ec2c-485d-98af-375a4d8263d6','{\"displayTitle\":\"Maxillaire 1.21.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',2,'SYNCED',0,NULL,'2021-11-22 12:28:55.000','2023-06-13 12:02:12.807','2023-06-13 14:02:12.807'),('7b9836aa-2cf6-485a-b0d3-39d73de4bc8b',662,'/var/.data/2021/662/5587321c-4405-49dc-90d5-8810cc776c6d/session_7e359a5f-1756-4ec7-8657-3e5940ae489d/occlusion_b29b47d4-35f8-427d-9cd7-a393e48be2cf/scan_453abb20-3827-4f8b-b57f-c656c72ebf11/20_w1_o1_mandibule_snapshot_1.png','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_BOSC_453abb20-3827-4f8b-b57f-c656c72ebf11_SNAPS','20_w1_o1_mandibule_snapshot_1.png','6ad36229-9d4a-4773-85c5-492f1965bc80','{\"displayTitle\":\"Mandibule 1.20.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2021-10-12 12:26:33.000','2023-06-13 12:02:12.748','2023-06-13 14:02:12.748'),('7cace217-66b4-4147-97f5-c8c1a7dfe1cd',662,'/var/.data/2022/662/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_129a6c33-3cca-43ab-b97a-56d0e82a546f/occlusion_b5b4db66-f433-46fb-b794-d632b8fe8e1d/scan_5a59f382-4b59-4867-8640-021d20bdcd59/19_w3_o1_mordu_anterieur_snapshot_0.png','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_129a6c33-3cca-43ab-b97a-56d0e82a546f_SESS_b5b4db66-f433-46fb-b794-d632b8fe8e1d_FRSC_5a59f382-4b59-4867-8640-021d20bdcd59_SNAPS','19_w3_o1_mordu_anterieur_snapshot_0.png','7cace217-66b4-4147-97f5-c8c1a7dfe1cd','{\"displayTitle\":\"Mordu anterieur 1.19.3.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-11-02 12:36:21.000','2023-06-13 12:02:13.583','2023-06-13 14:02:13.583'),('7d1b5372-e89a-471e-8230-71dba1f47677',662,'','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_ec084612-67a2-4430-ae15-7fe0edeaca64_SESS_2ed4960a-e6fa-46de-a306-32385df3346c_BOSC_45b21304-1129-40a2-b60e-d72a2bf96e72_SNAPS','2_w3_o2_mandibule_snapshot_0.png','7d1b5372-e89a-471e-8230-71dba1f47677','{\"displayTitle\":\"Mandibule Occlusion 1.2.3.2\",\"title\":\"MANDIBULE SNAPSHOT\"}','PNG',0,'SYNCED',0,'2023-04-12 06:40:33.000','2020-04-12 07:51:14.000','2023-06-13 12:02:15.155','2023-06-13 14:02:15.155'),('7df036ea-5778-484f-b08f-26823b06d4e2',662,'','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_78fbbe11-e1a5-4c10-b6e3-4f00df178dc6_SESS_f7b71416-57aa-4d3d-a2e5-0e6c1519f6e8_TOSC_5a5e6904-4736-4443-bbd0-be73066af8c3_SNAPS','7_w1_o1_maxillaire_snapshot_0.png','7df036ea-5778-484f-b08f-26823b06d4e2','{\"displayTitle\":\"MAXILLAIRE 1.7.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}','PNG',0,'SYNCED',0,'2023-04-12 06:40:46.000','2020-04-14 12:10:33.000','2023-06-13 12:02:15.231','2023-06-13 14:02:15.231'),('7ee48377-0cc2-4cf4-8d72-837e258ca29f',662,'/var/.data/2022/662/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_949fe730-88fa-4ec2-852e-dd0772ee3ee0/occlusion_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d/scan_1c6adc05-0655-4ad6-bcc9-27b0ef578ded/19_w2_o1_maxillaire_scan_file_2.zip','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_949fe730-88fa-4ec2-852e-dd0772ee3ee0_SESS_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d_TOSC_1c6adc05-0655-4ad6-bcc9-27b0ef578ded_MODEL','19_w2_o1_maxillaire_scan_file_2.zip','a1bc9da2-af83-43c3-8210-759800158585','{\"displayTitle\":\"Maxillaire 1.19.2.1.1\",\"modelMatrix\":\"-0.952153,0.293973,-0.0835736,0,-0.305622,-0.915862,0.260371,0,1.23643e-08,0.273455,0.961885,0,9.90796,-14.6588,-27.5009,1\",\"title\":\"Maxillaire ZIP\"}','ZIP',2,'SYNCED',0,NULL,'2022-06-28 20:27:42.000','2023-06-13 12:02:13.432','2023-06-13 14:02:13.432'),('7f09064b-ad1e-4cc1-9d0b-40bde9e22dff',662,'/var/.data/2022/662/665b40ce-9690-4944-b007-4a96c1f5d57d/session_8f87b136-cb98-4706-b7d4-51059e1afa06/occlusion_5f895907-3eed-4aa7-995a-f7e1c9661a0a/scan_26a765d3-8b92-4861-984a-bd9c8040209b/25_w1_o1_mandibule_snapshot_0.png','PATIENT_665b40ce-9690-4944-b007-4a96c1f5d57d_ACT_8f87b136-cb98-4706-b7d4-51059e1afa06_SESS_5f895907-3eed-4aa7-995a-f7e1c9661a0a_BOSC_26a765d3-8b92-4861-984a-bd9c8040209b_SNAPS','25_w1_o1_mandibule_snapshot_0.png','7f09064b-ad1e-4cc1-9d0b-40bde9e22dff','{\"displayTitle\":\"Mandibule 1.25.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-03-11 10:26:59.000','2023-06-13 12:02:13.220','2023-06-13 14:02:13.220'),('7f4bb473-7bb6-4ba8-a767-c1e722ce5c1b',662,'/var/.data/2020/662/1af643c4-44fe-4ccb-b545-dbc90b47633b/session_a6ab7edf-6040-4f1a-b898-a1120a854927/occlusion_e06b73d5-45f7-4906-ba73-560d66ac56af/scan_e9134dab-33d6-42e4-8779-ab502b18266c/7_w4_o1_maxillaire_scan_file_2.ply','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_a6ab7edf-6040-4f1a-b898-a1120a854927_SESS_e06b73d5-45f7-4906-ba73-560d66ac56af_TOSC_e9134dab-33d6-42e4-8779-ab502b18266c_MODEL','7_w4_o1_maxillaire_scan_file_2.ply','40c9dd9e-b85c-4ed6-a37e-81b5b8e9124d','{\"displayTitle\":\"Maxillaire 1.7.4.1.1\",\"modelMatrix\":\"0.903402,0.420292,-0.0849745,0,-0.428796,0.885485,-0.179027,0,2.8877e-9,0.19817,0.980168,0,-9.11848,-20.5173,-28.0428,1\",\"title\":\"MAXILLAIRE PLY\"}','PLY',2,'SYNCED',0,NULL,'2020-04-16 11:05:55.000','2023-06-13 12:02:10.051','2023-06-13 14:02:10.051'),('7fbf5bd8-6de6-46b1-bd50-c2480472006d',662,'/var/.data/2022/662/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_129a6c33-3cca-43ab-b97a-56d0e82a546f/occlusion_b5b4db66-f433-46fb-b794-d632b8fe8e1d/scan_ed495283-b756-4052-ba8b-5fe9f9b1f8be/19_w3_o1_maxillaire_snapshot_0.png','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_129a6c33-3cca-43ab-b97a-56d0e82a546f_SESS_b5b4db66-f433-46fb-b794-d632b8fe8e1d_TOSC_ed495283-b756-4052-ba8b-5fe9f9b1f8be_SNAPS','19_w3_o1_maxillaire_snapshot_0.png','7fbf5bd8-6de6-46b1-bd50-c2480472006d','{\"displayTitle\":\"Maxillaire SNAPSHOT\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-11-02 12:26:48.000','2023-06-13 12:02:13.642','2023-06-13 14:02:13.642'),('80e2978d-ccbf-46b3-90aa-49fde4694d47',662,'','PATIENT_d41de280-8cf3-4e57-893e-cc7a010bc864_ACT_c59a2f65-79fe-44cd-8377-e39aa0a44171_SESS_daf632b1-2c49-42c8-8899-0a0b2448bc3a_TOSC_fbfa4372-1faf-4a14-9f4e-70b7b375da7d_SNAPS','9_w1_o1_maxillaire_snapshot_1.png','9946c86d-7b6b-4bd2-8dae-8b982fbd7cfc','{\"displayTitle\":\"MAXILLAIRE 1.9.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}','PNG',1,'SYNCED',0,'2023-04-12 06:40:47.000','2020-04-18 09:19:43.000','2023-06-13 12:02:09.981','2023-06-13 14:02:09.981'),('818647ce-e09a-4e46-8ad9-2029a89b0d0f',662,'/var/.data/2021/662/615ede1a-dba9-4251-9e9e-6cbbd3041fdc/session_76dcd1f0-f6c7-480f-b07b-441679345d70/occlusion_c6fffa68-cc65-471a-a58e-135ebe4d0772/scan_7a39120e-2f79-4c3e-af4d-af72e8ca8062/15_w1_o1_mordu_posterieur_gauche_scan_file_1.ply','PATIENT_615ede1a-dba9-4251-9e9e-6cbbd3041fdc_ACT_76dcd1f0-f6c7-480f-b07b-441679345d70_SESS_c6fffa68-cc65-471a-a58e-135ebe4d0772_LESC_7a39120e-2f79-4c3e-af4d-af72e8ca8062_MODEL','15_w1_o1_mordu_posterieur_gauche_scan_file_1.ply','c14c7ae3-1390-4203-93ce-6ba836086c35','{\"displayTitle\":\"Mordu posterieur gauche 1.15.1.1.1\",\"modelMatrix\":\"-0.894751,0.0195259,0.435756,0,0.137292,-0.919419,0.369524,0,0.425737,0.393608,0.82082,0,0.624099,-11.8831,-21.6542,1\",\"title\":\"Mordu posterieur gauche PLY\"}','PLY',1,'SYNCED',0,NULL,'2021-02-16 13:00:22.000','2023-06-13 12:02:09.789','2023-06-13 14:02:09.789'),('81bbb529-1a14-4e29-b842-b84cbac8d014',662,'/var/.data/2022/662/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_7841125a-11dd-4b66-9179-cd371ea2f0f7/occlusion_12115366-8eb9-470b-a097-5d28bb5fdf38/scan_793e84ce-b088-458d-82f5-33fab1f5e7de/23_w1_o1_maxillaire_snapshot_0.png','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_TOSC_793e84ce-b088-458d-82f5-33fab1f5e7de_SNAPS','23_w1_o1_maxillaire_snapshot_0.png','81bbb529-1a14-4e29-b842-b84cbac8d014','{\"displayTitle\":\"Maxillaire 1.23.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-01-11 12:16:28.000','2023-06-13 12:02:13.061','2023-06-13 14:02:13.061'),('81e806ef-052e-4347-928a-d06d1d3a299b',662,'/var/.data/2022/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_87965ef8-01eb-4830-8e8b-8b99ece62cf1/occlusion_dce9ce0f-0933-4c98-af84-59e2b6395f8f/scan_bd51414b-f96e-4903-a2e2-44fb3189decd/21_w2_o1_mandibule_scan_file_3.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_87965ef8-01eb-4830-8e8b-8b99ece62cf1_SESS_dce9ce0f-0933-4c98-af84-59e2b6395f8f_BOSC_bd51414b-f96e-4903-a2e2-44fb3189decd_MODEL','21_w2_o1_mandibule_scan_file_3.zip','1f29b918-27fd-422b-b4dd-da18687d0871','{\"displayTitle\":\"Mandibule 1.21.2.1.1\",\"modelMatrix\":\"-0.922045,-0.375022,0.0958724,0,0.387082,-0.893316,0.228372,0,-6.769e-09,0.247679,0.968842,0,7.94719,13.1252,-21.4687,1\",\"title\":\"Mandibule ZIP\"}','ZIP',3,'SYNCED',0,NULL,'2022-06-27 20:58:59.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.086'),('8248bc2e-a7bc-4a4e-9fc9-f2326990454c',662,'/var/.data/2021/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97/21_w1_o1_mandibule_snapshot_1.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_BOSC_f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97_SNAPS','21_w1_o1_mandibule_snapshot_1.png','5dfbe9b8-c587-4311-b392-743be40fdd10','{\"displayTitle\":\"Mandibule 1.21.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2021-11-22 12:31:30.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.058'),('82997513-4864-4e01-8853-7053a2892d95',662,'/var/.data/2021/662/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_e6c99474-f6f6-447f-bcaa-d4c791811e18/14_w1_o1_mandibule_snapshot_0.png','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_BOSC_e6c99474-f6f6-447f-bcaa-d4c791811e18_SNAPS','14_w1_o1_mandibule_snapshot_0.png','82997513-4864-4e01-8853-7053a2892d95','{\"displayTitle\":\"Mandibule 1.14.1.1.2\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-02-01 21:09:31.000','2023-06-13 12:02:09.575','2023-06-13 14:02:09.575'),('83547739-e794-48fb-befb-bed604c04b8f',662,'/var/.data/2022/662/665b40ce-9690-4944-b007-4a96c1f5d57d/session_8f87b136-cb98-4706-b7d4-51059e1afa06/occlusion_5f895907-3eed-4aa7-995a-f7e1c9661a0a/computedocclusion_c4999e75-8b1c-4a31-8e80-9b9cba9b57fd/25_w1_o1_snapshot_occ_file_0.png','PATIENT_665b40ce-9690-4944-b007-4a96c1f5d57d_ACT_8f87b136-cb98-4706-b7d4-51059e1afa06_SESS_5f895907-3eed-4aa7-995a-f7e1c9661a0a_OCC_c4999e75-8b1c-4a31-8e80-9b9cba9b57fd_SNAPO','25_w1_o1_snapshot_occ_file_0.png','83547739-e794-48fb-befb-bed604c04b8f','{\"displayTitle\":\"Snapshot SNAPSHOT\",\"title\":\"Snapshot SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-03-11 11:16:26.000','2023-06-13 12:02:16.314','2023-06-13 14:02:16.314'),('8369f19c-559c-4a43-8a44-d476973e5f8f',662,'/var/.data/2020/662/1af643c4-44fe-4ccb-b545-dbc90b47633b/session_a6ab7edf-6040-4f1a-b898-a1120a854927/occlusion_e06b73d5-45f7-4906-ba73-560d66ac56af/scan_470d4798-40ea-4ce5-a574-22fcf013d82d/7_w4_o1_mordu_posterieur_droit_snapshot_0.png','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_a6ab7edf-6040-4f1a-b898-a1120a854927_SESS_e06b73d5-45f7-4906-ba73-560d66ac56af_RISC_470d4798-40ea-4ce5-a574-22fcf013d82d_SNAPS','7_w4_o1_mordu_posterieur_droit_snapshot_0.png','8369f19c-559c-4a43-8a44-d476973e5f8f','{\"displayTitle\":\"Mordu posterieur droit 1.7.4.1.1\",\"title\":\"MORDU_POSTERIEUR_DROIT SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-16 11:17:28.000','2023-06-13 12:02:10.072','2023-06-13 14:02:10.072'),('8396da09-c9ea-476d-ab69-648f06ec6534',662,'/var/.data/2021/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_a90158f7-0d39-4b9d-984b-57de06099c65/21_w1_o1_maxillaire_scan_file_0.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_TOSC_a90158f7-0d39-4b9d-984b-57de06099c65_MODEL','21_w1_o1_maxillaire_scan_file_0.zip','8396da09-c9ea-476d-ab69-648f06ec6534','{\"displayTitle\":\"Maxillaire 1.21.1.1.1\",\"modelMatrix\":\"0.898596,0.438246,-0.021589,0,-0.438778,0.897507,-0.0442131,0,-1.83541e-9,0.0492025,0.998789,0,-18.1719,-0.152005,-20.9375,1\",\"title\":\"Maxillaire ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2021-11-22 12:21:52.000','2023-06-13 12:02:12.779','2023-06-13 14:02:12.779'),('83dce64b-81ec-4022-b7e5-8a738bbab39f',662,'/var/.data/2020/662/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_a18ca6df-d765-4c6a-be28-13abd1c350af/scan_37ff1278-3dd1-470a-8159-e763f6626f5d/6_w1_o2_mandibule_scan_file_0.ply','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_a18ca6df-d765-4c6a-be28-13abd1c350af_BOSC_37ff1278-3dd1-470a-8159-e763f6626f5d_MODEL','6_w1_o2_mandibule_scan_file_0.ply','83dce64b-81ec-4022-b7e5-8a738bbab39f','{\"displayTitle\":\"MANDIBULE 1.6.1.2.1\",\"modelMatrix\":\"-0.993772,-0.101479,0.0460255,0,0.111428,-0.905037,0.410478,0,1.09577e-9,0.41305,0.910708,0,7.14214,1.18332,-21.7576,1\",\"title\":\"MANDIBULE PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-17 11:09:28.000','2023-06-13 12:02:10.239','2023-06-13 14:02:10.239'),('83eddd4d-fe65-43b9-a14f-3293e715be11',662,'','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_72c58d79-1141-4c63-b343-909886db5520_SESS_8d012545-b857-4595-a69d-1a2b1c750e13_TOSC_527c942e-3aa0-4028-b02a-8b3f137657be_SNAPS','2_w4_o1_maxillaire_snapshot_0.png','83eddd4d-fe65-43b9-a14f-3293e715be11','{\"displayTitle\":\"MAXILLAIRE 1.2.4.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}','PNG',0,'SYNCED',0,'2023-04-12 06:40:47.000','2020-04-27 16:19:06.000','2023-06-13 12:02:15.202','2023-06-13 14:02:15.202'),('8426a670-f967-440b-bcde-e3796c4a5da6',662,'/var/.data/2023/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_2c78d514-95bd-4529-b0a1-babfb83849b1/occlusion_983c39b6-656b-4bf2-bf43-da1625adb861/scan_209f3c55-7380-4efa-8e6c-dfe8c99792a6/21_w7_o1_mandibule_snapshot_4.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_2c78d514-95bd-4529-b0a1-babfb83849b1_SESS_983c39b6-656b-4bf2-bf43-da1625adb861_BOSC_209f3c55-7380-4efa-8e6c-dfe8c99792a6_SNAPS','21_w7_o1_mandibule_snapshot_4.png','252b180c-565f-4f14-af48-a16cebbead9e','{\"displayTitle\":\"Mandibule 1.21.7.1.1\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',4,'SYNCED',0,NULL,'2023-01-11 12:52:36.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.073'),('84c96eac-549e-4c1d-a701-896474d66a31',662,'/var/.data/2021/662/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_0c1ed331-8df6-482e-8dd1-508d9b190c49/occlusion_6c6bb813-840d-454a-ab1d-9232434a4500/scan_019e5bd1-9330-4e70-8035-2fda343b0231/19_w1_o1_maxillaire_scan_file_1.ply','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_TOSC_019e5bd1-9330-4e70-8035-2fda343b0231_MODEL','19_w1_o1_maxillaire_scan_file_1.ply','b328d68a-733b-46ed-9a1a-20aefc9f9b17','{\"displayTitle\":\"Maxillaire 1.19.1.1.1\",\"modelMatrix\":\"-0.899911,0.426922,-0.0888736,0,-0.436074,-0.881023,0.183405,0,5.95796e-9,0.203804,0.979012,0,12.9304,-14.3828,-20.7725,1\",\"title\":\"Maxillaire PLY\"}','PLY',1,'SYNCED',0,NULL,'2021-09-27 12:26:06.000','2023-06-13 12:02:12.576','2023-06-13 14:02:12.576'),('850a1a2e-2e87-4cda-8ec5-a2dcd149731d',662,'/var/.data/2022/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_8f3d7d42-f6ad-4e48-8951-08222c212e7e/occlusion_5bd97219-8b9e-46f5-ab9b-87ded07aa8a2/scan_b24d4ab4-dba3-4be5-8ba3-7eee381f40ec/21_w4_o1_mordu_anterieur_snapshot_0.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_8f3d7d42-f6ad-4e48-8951-08222c212e7e_SESS_5bd97219-8b9e-46f5-ab9b-87ded07aa8a2_FRSC_b24d4ab4-dba3-4be5-8ba3-7eee381f40ec_SNAPS','21_w4_o1_mordu_anterieur_snapshot_0.png','850a1a2e-2e87-4cda-8ec5-a2dcd149731d','{\"displayTitle\":\"Mordu anterieur 1.21.4.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-11-04 12:34:43.000','2023-06-13 12:02:14.871','2023-06-13 14:02:14.871'),('85dade24-9cc8-4e62-afe5-2da409796449',662,'','PATIENT_d41de280-8cf3-4e57-893e-cc7a010bc864_ACT_c59a2f65-79fe-44cd-8377-e39aa0a44171_SESS_daf632b1-2c49-42c8-8899-0a0b2448bc3a_TOSC_fbfa4372-1faf-4a14-9f4e-70b7b375da7d_MODEL','9_w1_o1_maxillaire_scan_file_1.ply','5bdd9b13-0942-46d1-92ac-4b22472007ae','{\"displayTitle\":\"MAXILLAIRE 1.9.1.1.1\",\"modelMatrix\":\"0.0384415,0.981792,-0.18603,0,-0.999261,0.0377694,-0.00715657,0,3.061e-10,0.186168,0.982518,0,-1.61933,-2.53699,-9.84203,1\",\"title\":\"MAXILLAIRE PLY\"}','PLY',1,'SYNCED',0,'2023-04-12 06:40:48.000','2020-04-18 09:19:43.000','2023-06-13 12:02:09.991','2023-06-13 14:02:09.991'),('88b2c3fc-981f-4818-aa0f-2cbbbc6a3b31',662,'/var/.data/2020/662/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/occlusion_d402edb5-8449-46a8-862f-a1cd1ee21cf6/scan_b7931623-9b21-4440-a950-16565249bf9a/10_w1_o1_mandibule_snapshot_2.png','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_SESS_d402edb5-8449-46a8-862f-a1cd1ee21cf6_BOSC_b7931623-9b21-4440-a950-16565249bf9a_SNAPS','10_w1_o1_mandibule_snapshot_2.png','f3f82ebd-8318-469e-9bdd-ff76223b9c1c','{\"displayTitle\":\"MANDIBULE 1.10.1.1.2\",\"title\":\"MANDIBULE SNAPSHOT\"}','PNG',2,'SYNCED',0,NULL,'2020-04-30 19:54:51.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.069'),('8c1eb1f1-d914-11ed-b558-229278a3c906',662,'/var/.data/2023/662/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_a62b9800-d910-11ed-b558-229278a3c906/occlusion_a62ebb05-d910-11ed-b558-229278a3c906/scan_1ff82da8-d913-11ed-b558-229278a3c906/8c1eb1f1-d914-11ed-b558-229278a3c906.zip','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_a62b9800-d910-11ed-b558-229278a3c906_SESS_a62ebb05-d910-11ed-b558-229278a3c906_BOSC_1ff82da8-d913-11ed-b558-229278a3c906_MODEL','8c1eb1f1-d914-11ed-b558-229278a3c906.zip','102c6dfe-d914-11ed-b558-229278a3c906','{\"displayTitle\":\"Mandibule 1.23.2.1.1\",\"modelMatrix\":\"0.989413,0.108036,-0.0969004,0,-0.145126,0.73655,-0.66063,0,1.2428e-09,0.667699,0.744431,0,0.0336216,-20.8304,-17.9532,1\",\"scanBodies\":[]}','ZIP',1,'SYNCED',0,NULL,'2023-06-13 13:47:34.000','2023-06-13 11:59:36.563','2023-06-13 13:59:36.563'),('8c1ec753-d914-11ed-b558-229278a3c906',662,'/var/.data/2023/662/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_a62b9800-d910-11ed-b558-229278a3c906/occlusion_a62ebb05-d910-11ed-b558-229278a3c906/scan_1ff82da8-d913-11ed-b558-229278a3c906/8c1ec753-d914-11ed-b558-229278a3c906.png','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_a62b9800-d910-11ed-b558-229278a3c906_SESS_a62ebb05-d910-11ed-b558-229278a3c906_BOSC_1ff82da8-d913-11ed-b558-229278a3c906_SNAPS','8c1ec753-d914-11ed-b558-229278a3c906.png','102db5a2-d914-11ed-b558-229278a3c906','{\"displayTitle\":\"Mandibule 1.23.2.1.1 Snapshot\"}','PNG',1,'SYNCED',0,NULL,'2023-06-13 13:47:35.000','2023-06-13 11:59:36.596','2023-06-13 13:59:36.596'),('8ccfb1b3-7ee5-11ea-947d-226cec7cb58a',662,'/var/.data/2020/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8ccfb1b3-7ee5-11ea-947d-226cec7cb58a.png','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_LESC_6ce1c2d0-1849-4a2a-bfd9-05247b74c2d7_SNAPS','7_w2_o2_mordu_posterieur_gauche_snapshot_0.png','8ccfb1b3-7ee5-11ea-947d-226cec7cb58a','{\"displayTitle\":\"MORDU_POSTERIEUR_GAUCHE 1.7.2.2.1\",\"title\":\"MORDU_POSTERIEUR_GAUCHE SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-15 07:39:22.000','2023-06-13 12:02:22.107','2023-06-13 14:02:22.107'),('8cd19241-7ee5-11ea-947d-226cec7cb58a',662,'/var/.data/2020/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8cd19241-7ee5-11ea-947d-226cec7cb58a.ply','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_RISC_d3a42d3d-3d98-457b-bb64-4119091b03f9_MODEL','7_w2_o2_mordu_posterieur_droit_scan_file_0.ply','8cd19241-7ee5-11ea-947d-226cec7cb58a','{\"displayTitle\":\"MORDU_POSTERIEUR_DROIT 1.7.2.2.1\",\"modelMatrix\":\"0.996436,-0.0417849,0.0747689,0,0.0270536,0.952167,0.302573,0,-0.0805792,-0.302841,0.950213,0,-13.0357,5.641,-33.0669,1\",\"title\":\"MORDU_POSTERIEUR_DROIT PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-15 07:37:21.000','2023-06-13 12:02:22.115','2023-06-13 14:02:22.115'),('8cd31395-7ee5-11ea-947d-226cec7cb58a',662,'/var/.data/2020/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8cd31395-7ee5-11ea-947d-226cec7cb58a.pdf','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_PROST_118a8411-96d0-412f-a2fd-6e990b04bf34_FORM','7_w2_odf_prost_file_0.pdf','8cd31395-7ee5-11ea-947d-226cec7cb58a','{\"displayTitle\":\"ODF 1.7.2.2 ODF\",\"title\":\"Odf PDF\"}','PDF',0,'SYNCED',0,NULL,'2020-04-15 08:51:44.000','2023-06-13 12:02:22.124','2023-06-13 14:02:22.124'),('8cd499d6-7ee5-11ea-947d-226cec7cb58a',662,'/var/.data/2020/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8cd499d6-7ee5-11ea-947d-226cec7cb58a.ply','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_BOSC_d2372948-816f-4d58-a2bf-288bc0e7b539_MODEL','7_w2_o2_mandibule_scan_file_1.ply','8cd499d6-7ee5-11ea-947d-226cec7cb58a','{\"displayTitle\":\"MANDIBULE 1.7.2.2.1\",\"modelMatrix\":\"0.798862,-0.59756,0.0688607,0,0.601515,0.79361,-0.0914527,0,-4.38586e-9,0.114479,0.993426,0,-2.73294,17.6652,-41.351,1\",\"title\":\"MANDIBULE PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-15 07:19:54.000','2023-06-13 12:02:22.131','2023-06-13 14:02:22.131'),('8cd690e5-7ee5-11ea-947d-226cec7cb58a',662,'/var/.data/2020/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8cd690e5-7ee5-11ea-947d-226cec7cb58a.png','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_TOSC_778a761c-339e-4143-a807-735b174d9714_SNAPS','7_w2_o2_maxillaire_snapshot_1.png','8cd690e5-7ee5-11ea-947d-226cec7cb58a','{\"displayTitle\":\"MAXILLAIRE 1.7.2.2.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-15 07:35:08.000','2023-06-13 12:02:22.144','2023-06-13 14:02:22.144'),('8cd829cd-7ee5-11ea-947d-226cec7cb58a',662,'/var/.data/2020/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8cd829cd-7ee5-11ea-947d-226cec7cb58a.png','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_BOSC_d2372948-816f-4d58-a2bf-288bc0e7b539_SNAPS','7_w2_o2_mandibule_snapshot_1.png','8cd829cd-7ee5-11ea-947d-226cec7cb58a','{\"displayTitle\":\"MANDIBULE 1.7.2.2.1\",\"title\":\"MANDIBULE SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-15 07:19:54.000','2023-06-13 12:02:22.158','2023-06-13 14:02:22.158'),('8cda0313-7ee5-11ea-947d-226cec7cb58a',662,'/var/.data/2020/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8cda0313-7ee5-11ea-947d-226cec7cb58a.ply','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_TOSC_778a761c-339e-4143-a807-735b174d9714_MODEL','7_w2_o2_maxillaire_scan_file_1.ply','8cda0313-7ee5-11ea-947d-226cec7cb58a','{\"displayTitle\":\"MAXILLAIRE 1.7.2.2.1\",\"modelMatrix\":\"0.665193,0.645471,-0.375347,0,-0.746672,0.575036,-0.334388,0,2.20888e-8,0.502693,0.864465,0,-12.1421,-33.8974,-48.3616,1\",\"title\":\"MAXILLAIRE PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-15 07:35:08.000','2023-06-13 12:02:22.171','2023-06-13 14:02:22.171'),('8cdbafa2-7ee5-11ea-947d-226cec7cb58a',662,'/var/.data/2020/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8cdbafa2-7ee5-11ea-947d-226cec7cb58a.png','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_FRSC_ca33a9ff-b86a-4e97-8674-1bd7adc92759_SNAPS','7_w2_o2_mordu_anterieur_snapshot_0.png','8cdbafa2-7ee5-11ea-947d-226cec7cb58a','{\"displayTitle\":\"MORDU_ANTERIEUR 1.7.2.2.1\",\"title\":\"MORDU_ANTERIEUR SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-15 07:43:36.000','2023-06-13 12:02:22.185','2023-06-13 14:02:22.185'),('8cdd4be9-7ee5-11ea-947d-226cec7cb58a',662,'/var/.data/2020/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8cdd4be9-7ee5-11ea-947d-226cec7cb58a.ply','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_FRSC_ca33a9ff-b86a-4e97-8674-1bd7adc92759_MODEL','7_w2_o2_mordu_anterieur_scan_file_0.ply','8cdd4be9-7ee5-11ea-947d-226cec7cb58a','{\"displayTitle\":\"MORDU_ANTERIEUR 1.7.2.2.1\",\"modelMatrix\":\"0.716923,0.0202956,0.693353,0,-0.0337042,0.999997,-0.0100568,0,-0.69663,0.000757645,0.720556,0,12.2181,4.16901,-40.9229,1\",\"title\":\"MORDU_ANTERIEUR PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-15 07:43:36.000','2023-06-13 12:02:22.198','2023-06-13 14:02:22.198'),('8cdf1358-7ee5-11ea-947d-226cec7cb58a',662,'/var/.data/2020/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8cdf1358-7ee5-11ea-947d-226cec7cb58a.ply','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_LESC_6ce1c2d0-1849-4a2a-bfd9-05247b74c2d7_MODEL','7_w2_o2_mordu_posterieur_gauche_scan_file_0.ply','8cdf1358-7ee5-11ea-947d-226cec7cb58a','{\"displayTitle\":\"MORDU_POSTERIEUR_GAUCHE 1.7.2.2.1\",\"modelMatrix\":\"-0.999903,-0.00806038,0.0111619,0,0.0083222,-0.994448,-0.103366,0,0.0112516,-0.104947,0.994583,0,16.7147,8.54514,-27.4379,1\",\"title\":\"MORDU_POSTERIEUR_GAUCHE PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-15 07:39:22.000','2023-06-13 12:02:22.211','2023-06-13 14:02:22.211'),('8ce28649-7ee5-11ea-947d-226cec7cb58a',662,'/var/.data/2020/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8ce28649-7ee5-11ea-947d-226cec7cb58a.png','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_RISC_d3a42d3d-3d98-457b-bb64-4119091b03f9_SNAPS','7_w2_o2_mordu_posterieur_droit_snapshot_0.png','8ce28649-7ee5-11ea-947d-226cec7cb58a','{\"displayTitle\":\"MORDU_POSTERIEUR_DROIT 1.7.2.2.1\",\"title\":\"MORDU_POSTERIEUR_DROIT SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-15 07:37:21.000','2023-06-13 12:02:22.224','2023-06-13 14:02:22.224'),('8d582d54-5f1f-4ac9-ac0e-a9aa41cc41e1',662,'/var/.data/2020/662/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/occlusion_d402edb5-8449-46a8-862f-a1cd1ee21cf6/scan_a93c6a8f-0c96-47ae-bc72-75a725946a5a/10_w1_o1_mordu_anterieur_scan_file_0.ply','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_SESS_d402edb5-8449-46a8-862f-a1cd1ee21cf6_FRSC_a93c6a8f-0c96-47ae-bc72-75a725946a5a_MODEL','10_w1_o1_mordu_anterieur_scan_file_0.ply','8d582d54-5f1f-4ac9-ac0e-a9aa41cc41e1','{\"displayTitle\":\"Mordu anterieur 1.10.1.1.1\",\"modelMatrix\":\"0.823669,-0.0469585,0.555588,0,0.0882294,0.995963,-0.0501525,0,-0.560319,0.0775828,0.83011,0,5.64793,3.00105,-25.0468,1\",\"title\":\"MORDU_ANTERIEUR PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-30 20:08:26.000','2023-06-13 12:02:12.434','2023-06-13 14:02:12.434'),('8ea06518-4b8a-11ec-9377-226cec7cb58a',662,'/var/.data/2021/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8ea06518-4b8a-11ec-9377-226cec7cb58a.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_BOSC_f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97_SNAPS','21_w1_o1_mandibule_snapshot_3.png','8ea06518-4b8a-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Mandibule 1.21.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-11-22 12:41:03.000','2023-06-13 12:02:22.717','2023-06-13 14:02:22.717'),('8ea38ac2-4b8a-11ec-9377-226cec7cb58a',662,'/var/.data/2021/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8ea38ac2-4b8a-11ec-9377-226cec7cb58a.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_FRSC_3d3ae697-dc08-4ce2-8b32-4f79891607c2_SNAPS','21_w1_o1_mordu_anterieur_snapshot_0.png','8ea38ac2-4b8a-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Mordu anterieur 1.21.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-11-22 12:49:42.000','2023-06-13 12:02:22.726','2023-06-13 14:02:22.726'),('8ea64d2c-4b8a-11ec-9377-226cec7cb58a',662,'/var/.data/2021/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8ea64d2c-4b8a-11ec-9377-226cec7cb58a.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_RISC_c00beb59-a67d-4566-801a-0081588c2a04_MODEL','21_w1_o1_mordu_posterieur_droit_scan_file_0.zip','8ea64d2c-4b8a-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Mordu posterieur droit 1.21.1.1.1\",\"modelMatrix\":\"0.99877,0.016182,0.0457803,0,-0.0192084,0.999424,-0.0289803,0,-0.0459172,0.0302338,0.998533,0,13.1616,-3.71206,-20.732,1\",\"title\":\"Mordu posterieur droit ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2021-11-22 12:45:00.000','2023-06-13 12:02:22.736','2023-06-13 14:02:22.736'),('8ea9bac9-4b8a-11ec-9377-226cec7cb58a',662,'/var/.data/2021/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8ea9bac9-4b8a-11ec-9377-226cec7cb58a.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_RISC_c00beb59-a67d-4566-801a-0081588c2a04_SNAPS','21_w1_o1_mordu_posterieur_droit_snapshot_0.png','8ea9bac9-4b8a-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Mordu posterieur droit 1.21.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-11-22 12:44:59.000','2023-06-13 12:02:22.745','2023-06-13 14:02:22.745'),('8eaccb00-4b8a-11ec-9377-226cec7cb58a',662,'/var/.data/2021/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8eaccb00-4b8a-11ec-9377-226cec7cb58a.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_LESC_9716867f-e0a3-478a-a498-1e84ae803044_MODEL','21_w1_o1_mordu_posterieur_gauche_scan_file_1.zip','8eaccb00-4b8a-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Mordu posterieur gauche 1.21.1.1.1\",\"modelMatrix\":\"-0.947449,-0.317073,-0.0557049,0,0.311962,-0.870195,-0.378767,0,0.070887,-0.377135,0.923815,0,-13.1535,4.28606,-27.5789,1\",\"title\":\"Mordu posterieur gauche ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2021-11-22 12:47:34.000','2023-06-13 12:02:22.752','2023-06-13 14:02:22.752'),('8eb12471-4b8a-11ec-9377-226cec7cb58a',662,'/var/.data/2021/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8eb12471-4b8a-11ec-9377-226cec7cb58a.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_TOSC_a90158f7-0d39-4b9d-984b-57de06099c65_MODEL','21_w1_o1_maxillaire_scan_file_2.zip','8eb12471-4b8a-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Maxillaire 1.21.1.1.1\",\"modelMatrix\":\"0.637136,0.767927,-0.0659177,0,-0.770751,0.634802,-0.0544904,0,4.04895e-9,0.0855239,0.996336,0,-16.373,-8.74215,-20.4029,1\",\"title\":\"Maxillaire ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2021-11-22 12:28:58.000','2023-06-13 12:02:22.761','2023-06-13 14:02:22.761'),('8eb7bfec-4b8a-11ec-9377-226cec7cb58a',662,'/var/.data/2021/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8eb7bfec-4b8a-11ec-9377-226cec7cb58a.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_TOSC_a90158f7-0d39-4b9d-984b-57de06099c65_SNAPS','21_w1_o1_maxillaire_snapshot_2.png','8eb7bfec-4b8a-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Maxillaire 1.21.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-11-22 12:28:55.000','2023-06-13 12:02:22.771','2023-06-13 14:02:22.771'),('8ebeca38-4b8a-11ec-9377-226cec7cb58a',662,'/var/.data/2021/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8ebeca38-4b8a-11ec-9377-226cec7cb58a.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_BOSC_f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97_MODEL','21_w1_o1_mandibule_scan_file_3.zip','8ebeca38-4b8a-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Mandibule 1.21.1.1.1\",\"modelMatrix\":\"-0.991383,-0.127699,0.029203,0,0.130996,-0.966434,0.22101,0,-2.82267e-9,0.222931,0.974834,0,20.0716,9.99111,-20.7432,1\",\"title\":\"Mandibule ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2021-11-22 12:41:06.000','2023-06-13 12:02:22.780','2023-06-13 14:02:22.780'),('8ec375cf-4b8a-11ec-9377-226cec7cb58a',662,'/var/.data/2021/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8ec375cf-4b8a-11ec-9377-226cec7cb58a.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_FRSC_3d3ae697-dc08-4ce2-8b32-4f79891607c2_MODEL','21_w1_o1_mordu_anterieur_scan_file_0.zip','8ec375cf-4b8a-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Mordu anterieur 1.21.1.1.1\",\"modelMatrix\":\"0.856881,0.0586008,0.514973,0,-0.0462075,0.997315,0.0174852,0,-0.514443,-0.0544124,0.857029,0,-1.9678,-1.04274,-24.7967,1\",\"title\":\"Mordu anterieur ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2021-11-22 12:49:43.000','2023-06-13 12:02:22.788','2023-06-13 14:02:22.788'),('8ec747f5-4b8a-11ec-9377-226cec7cb58a',662,'/var/.data/2021/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/8ec747f5-4b8a-11ec-9377-226cec7cb58a.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_LESC_9716867f-e0a3-478a-a498-1e84ae803044_SNAPS','21_w1_o1_mordu_posterieur_gauche_snapshot_1.png','8ec747f5-4b8a-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Mordu posterieur gauche 1.21.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-11-22 12:47:33.000','2023-06-13 12:02:22.797','2023-06-13 14:02:22.797'),('8efdb9b3-fe9f-4a5f-9abb-7f53985624a7',662,'/var/.data/2020/662/d41de280-8cf3-4e57-893e-cc7a010bc864/session_c59a2f65-79fe-44cd-8377-e39aa0a44171/occlusion_daf632b1-2c49-42c8-8899-0a0b2448bc3a/scan_16cf8664-2af0-446a-ac6d-ef0e40edb71d/9_w1_o1_mordu_posterieur_gauche_snapshot_0.png','PATIENT_d41de280-8cf3-4e57-893e-cc7a010bc864_ACT_c59a2f65-79fe-44cd-8377-e39aa0a44171_SESS_daf632b1-2c49-42c8-8899-0a0b2448bc3a_LESC_16cf8664-2af0-446a-ac6d-ef0e40edb71d_SNAPS','9_w1_o1_mordu_posterieur_gauche_snapshot_0.png','8efdb9b3-fe9f-4a5f-9abb-7f53985624a7','{\"displayTitle\":\"Mordu posterieur gauche 1.9.1.1.1\",\"title\":\"MORDU_POSTERIEUR_GAUCHE SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-18 09:35:44.000','2023-06-13 12:02:10.570','2023-06-13 14:02:10.570'),('8f73cc76-d204-47ee-bcfc-5610371e2032',662,'/var/.data/2021/662/f15cb858-4f0b-44ec-a017-5e662039ba19/session_72b7a457-e38f-4535-8eba-6c98b43e5e55/occlusion_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c/scan_41b8d05c-738b-4161-9f86-27222b61ad66/14_w2_o1_mordu_posterieur_droit_snapshot_0.png','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_72b7a457-e38f-4535-8eba-6c98b43e5e55_SESS_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c_RISC_41b8d05c-738b-4161-9f86-27222b61ad66_SNAPS','14_w2_o1_mordu_posterieur_droit_snapshot_0.png','8f73cc76-d204-47ee-bcfc-5610371e2032','{\"displayTitle\":\"Mordu posterieur droit 1.14.2.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-06-08 20:48:52.000','2023-06-13 12:02:12.315','2023-06-13 14:02:12.315'),('8fd1dd53-2969-4c23-9998-f92a590629ae',662,'','PATIENT_94ac368a-c8ad-482d-91b4-26c8db10596d_ACT_c61cdb9c-543c-4809-952c-b65656e1f96f_SESS_53a17fdc-5de8-45aa-a9cb-ebea4886f6ff_TOSC_6445b6e3-0c4a-44d3-84e8-7f315911b8ee_SNAPS','','8fd1dd53-2969-4c23-9998-f92a590629ae','{\"displayTitle\":\"MAXILLAIRE 1.11.1.1.2\",\"title\":\"MAXILLAIRE SNAPSHOT\"}','PNG',0,'CREATED',0,'2020-07-08 19:59:48.000','2020-07-08 19:54:05.000','2023-04-11 19:02:23.476',NULL),('90d34496-4e10-41d5-b77c-75826f81327e',662,'/var/.data/2022/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_848b25bd-90a8-4105-871d-f9326fe94c7b/occlusion_ba7da56a-5a10-4378-a887-8e98aa892a3c/scan_b002027b-930d-4b96-a687-453aeea5659e/21_w6_o1_maxillaire_snapshot_1.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_848b25bd-90a8-4105-871d-f9326fe94c7b_SESS_ba7da56a-5a10-4378-a887-8e98aa892a3c_TOSC_b002027b-930d-4b96-a687-453aeea5659e_SNAPS','21_w6_o1_maxillaire_snapshot_1.png','14c0bac1-16fe-41ce-863b-85ffd35f41e9','{\"displayTitle\":\"Maxillaire 1.21.6.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2022-12-21 12:14:30.000','2023-06-13 12:02:15.009','2023-06-13 14:02:15.009'),('9186d766-694f-4445-926a-80ace9fd1660',662,'/var/.data/2020/662/d41de280-8cf3-4e57-893e-cc7a010bc864/session_c59a2f65-79fe-44cd-8377-e39aa0a44171/occlusion_daf632b1-2c49-42c8-8899-0a0b2448bc3a/scan_55058b25-acc2-43c3-b9d2-b8bb64bfcbb9/9_w1_o1_mordu_posterieur_droit_snapshot_0.png','PATIENT_d41de280-8cf3-4e57-893e-cc7a010bc864_ACT_c59a2f65-79fe-44cd-8377-e39aa0a44171_SESS_daf632b1-2c49-42c8-8899-0a0b2448bc3a_RISC_55058b25-acc2-43c3-b9d2-b8bb64bfcbb9_SNAPS','9_w1_o1_mordu_posterieur_droit_snapshot_0.png','9186d766-694f-4445-926a-80ace9fd1660','{\"displayTitle\":\"Mordu posterieur droit 1.9.1.1.1\",\"title\":\"MORDU_POSTERIEUR_DROIT SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-18 09:33:54.000','2023-06-13 12:02:10.618','2023-06-13 14:02:10.618'),('9210c2bb-cc5b-4ccf-a432-8adf915d5673',662,'/var/.data/2022/662/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_7841125a-11dd-4b66-9179-cd371ea2f0f7/occlusion_12115366-8eb9-470b-a097-5d28bb5fdf38/scan_6ce24fb2-7744-476b-a643-7e304d3ac013/23_w1_o1_mordu_posterieur_droit_snapshot_0.png','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_RISC_6ce24fb2-7744-476b-a643-7e304d3ac013_SNAPS','23_w1_o1_mordu_posterieur_droit_snapshot_0.png','9210c2bb-cc5b-4ccf-a432-8adf915d5673','{\"displayTitle\":\"Mordu posterieur droit 1.23.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-01-11 12:37:27.000','2023-06-13 12:02:13.115','2023-06-13 14:02:13.115'),('92288f55-8447-4e52-a1c2-2de9d12cad77',662,'/var/.data/2021/662/f15cb858-4f0b-44ec-a017-5e662039ba19/session_72b7a457-e38f-4535-8eba-6c98b43e5e55/occlusion_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c/scan_44b8a221-3707-430b-bc84-cacca7bf7d8a/14_w2_o1_mordu_posterieur_gauche_snapshot_0.png','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_72b7a457-e38f-4535-8eba-6c98b43e5e55_SESS_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c_LESC_44b8a221-3707-430b-bc84-cacca7bf7d8a_SNAPS','14_w2_o1_mordu_posterieur_gauche_snapshot_0.png','92288f55-8447-4e52-a1c2-2de9d12cad77','{\"displayTitle\":\"Mordu posterieur gauche 1.14.2.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-06-08 20:51:49.000','2023-06-13 12:02:12.343','2023-06-13 14:02:12.343'),('9319bd6a-6e7d-4505-8090-e4e10e3caec0',662,'/var/.data/2020/662/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/occlusion_d402edb5-8449-46a8-862f-a1cd1ee21cf6/scan_d52d9ce0-7fed-491c-a385-929e22fb07d5/10_w1_o1_mordu_posterieur_gauche_snapshot_0.png','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_SESS_d402edb5-8449-46a8-862f-a1cd1ee21cf6_LESC_d52d9ce0-7fed-491c-a385-929e22fb07d5_SNAPS','10_w1_o1_mordu_posterieur_gauche_snapshot_0.png','9319bd6a-6e7d-4505-8090-e4e10e3caec0','{\"displayTitle\":\"Mordu posterieur gauche 1.10.1.1.1\",\"title\":\"MORDU_POSTERIEUR_GAUCHE SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-30 20:05:04.000','2023-06-13 12:02:12.379','2023-06-13 14:02:12.379'),('931bf3dd-fe07-4981-8ede-599f357c3c60',662,'/var/.data/2020/662/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_a18ca6df-d765-4c6a-be28-13abd1c350af/computedocclusion_a18ca6df-d765-4c6a-be28-13amigraoccl/6_w1_o2_mandibule_occlusion_occ_file_0.ply','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_a18ca6df-d765-4c6a-be28-13abd1c350af_OCC_a18ca6df-d765-4c6a-be28-13amigraoccl_BOPLY','6_w1_o2_mandibule_occlusion_occ_file_0.ply','931bf3dd-fe07-4981-8ede-599f357c3c60','{\"displayTitle\":\"Mandibule Occlusion 1.6.1.2.1\",\"referenceScanID\":\"1.6.1.2.1\",\"title\":\"Mandibule Occlusion PLY\",\"occlusionMatrix\":\"0.90573,0.239385,-0.349817,0,0.241288,-0.969688,-0.0388191,0,-0.348498,-0.0492465,-0.936026,0,-6.3335,6.42073,19.1308,1\"}','PLY',0,'SYNCED',0,NULL,'2020-04-17 11:21:05.000','2023-06-13 12:02:16.205','2023-06-13 14:02:16.205'),('933a6e93-9da3-4626-98e1-48aa28a06daa',662,'','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_cb9d8495-b4dd-423f-a624-7cff70e4db55_SESS_2b934532-4b04-4025-8e7f-894c9c01b184_BOSC_0b6ec729-5c4e-4869-9d67-6377923ed207_MODEL','2_w2_o3_mandibule_scan_file_0.ply','933a6e93-9da3-4626-98e1-48aa28a06daa','{\"displayTitle\":\"MANDIBULE 1.2.2.3.1\",\"modelMatrix\":\"0.951587,0.289796,-0.102471,0,-0.307379,0.897153,-0.31723,0,4.98457e-10,0.333369,0.942796,0,1.62001,-0.765988,-48.5403,1\",\"title\":\"MANDIBULE PLY\"}','PLY',0,'SYNCED',0,'2023-04-12 06:40:53.000','2020-04-07 07:26:12.000','2023-06-13 12:02:15.090','2023-06-13 14:02:15.090'),('9429af5d-f1d9-425d-ba09-d7d1907096ac',662,'/var/.data/2020/662/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_bdf42f40-5a7a-435b-a5e0-eb33efefbc97/scan_2d566d37-f38f-4b79-ac8f-48009ae22310/6_w1_o1_maxillaire_scan_file_0.ply','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_bdf42f40-5a7a-435b-a5e0-eb33efefbc97_TOSC_2d566d37-f38f-4b79-ac8f-48009ae22310_MODEL','6_w1_o1_maxillaire_scan_file_0.ply','9429af5d-f1d9-425d-ba09-d7d1907096ac','{\"displayTitle\":\"Maxillaire 1.6.1.1.1\",\"modelMatrix\":\"-0.854329,0.507958,-0.109998,0,-0.519732,-0.834976,0.180814,0,-6.21247e-9,0.211644,0.977347,0,1.97723,-16.173,-24.2697,1\",\"title\":\"MAXILLAIRE PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-10 11:37:04.000','2023-06-13 12:02:10.210','2023-06-13 14:02:10.210'),('94c77f29-2b59-11ec-9377-226cec7cb58a',662,'/var/.data/2021/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/94c77f29-2b59-11ec-9377-226cec7cb58a.zip','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_LESC_a6d52fce-2e61-4375-bf6d-a36f9b3eb72f_MODEL','20_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','94c77f29-2b59-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Mordu posterieur gauche 1.20.1.1.1\",\"modelMatrix\":\"-0.977596,0.0140003,0.205991,0,-0.0046974,-0.995393,0.111045,0,0.210767,0.0965222,0.972336,0,6.11013,-4.18404,-18.0488,1\",\"title\":\"Mordu posterieur gauche ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2021-10-12 12:42:39.000','2023-06-13 12:02:22.593','2023-06-13 14:02:22.593'),('94cb30f9-2b59-11ec-9377-226cec7cb58a',662,'/var/.data/2021/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/94cb30f9-2b59-11ec-9377-226cec7cb58a.zip','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_RISC_00f07cdc-1834-4ae1-a9fa-47699828c094_MODEL','20_w1_o1_mordu_posterieur_droit_scan_file_0.zip','94cb30f9-2b59-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Mordu posterieur droit 1.20.1.1.1\",\"modelMatrix\":\"0.977044,0.023574,0.212257,0,-0.0393808,0.997586,0.0676487,0,-0.209382,-0.0658891,0.974905,0,3.82768,-0.972126,-16.0009,1\",\"title\":\"Mordu posterieur droit ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2021-10-12 12:40:26.000','2023-06-13 12:02:22.600','2023-06-13 14:02:22.600'),('94ce93c7-2b59-11ec-9377-226cec7cb58a',662,'/var/.data/2021/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/94ce93c7-2b59-11ec-9377-226cec7cb58a.png','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_FRSC_881d38cc-cf89-4329-8456-b90f8c997725_SNAPS','20_w1_o1_mordu_anterieur_snapshot_0.png','94ce93c7-2b59-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Mordu anterieur 1.20.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-10-12 12:44:16.000','2023-06-13 12:02:22.607','2023-06-13 14:02:22.607'),('94dbef5a-271e-457d-ba7b-ace1dbe05081',662,'/var/.data/2022/662/665b40ce-9690-4944-b007-4a96c1f5d57d/session_8f87b136-cb98-4706-b7d4-51059e1afa06/occlusion_5f895907-3eed-4aa7-995a-f7e1c9661a0a/scan_d04345c3-df70-4e2a-b197-cc37138e6700/25_w1_o1_mordu_anterieur_scan_file_0.zip','PATIENT_665b40ce-9690-4944-b007-4a96c1f5d57d_ACT_8f87b136-cb98-4706-b7d4-51059e1afa06_SESS_5f895907-3eed-4aa7-995a-f7e1c9661a0a_FRSC_d04345c3-df70-4e2a-b197-cc37138e6700_MODEL','25_w1_o1_mordu_anterieur_scan_file_0.zip','94dbef5a-271e-457d-ba7b-ace1dbe05081','{\"displayTitle\":\"Mordu anterieur 1.25.1.1.1\",\"modelMatrix\":\"0.90456,0.0244497,0.402976,0,-0.0988614,0.985826,0.138036,0,-0.415543,-0.166161,0.905105,0,-2.22653,5.62446,-26.7955,1\",\"title\":\"Mordu anterieur ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-03-11 11:15:50.000','2023-06-13 12:02:13.289','2023-06-13 14:02:13.289'),('94e9a15c-2b59-11ec-9377-226cec7cb58a',662,'/var/.data/2021/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/94e9a15c-2b59-11ec-9377-226cec7cb58a.zip','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_TOSC_42b09cf6-e30d-4d35-a17d-d8e8b4564638_MODEL','20_w1_o1_maxillaire_scan_file_1.zip','94e9a15c-2b59-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Maxillaire 1.20.1.1.1\",\"modelMatrix\":\"0.322976,0.912912,-0.249555,0,-0.946407,0.311546,-0.0851648,0,4.13598e-9,0.263687,0.964608,0,-7.27814,-21.2146,-22.2509,1\",\"title\":\"Maxillaire ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2021-10-12 12:37:46.000','2023-06-13 12:02:22.615','2023-06-13 14:02:22.615'),('94eeedbf-2b59-11ec-9377-226cec7cb58a',662,'/var/.data/2021/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/94eeedbf-2b59-11ec-9377-226cec7cb58a.png','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_LESC_a6d52fce-2e61-4375-bf6d-a36f9b3eb72f_SNAPS','20_w1_o1_mordu_posterieur_gauche_snapshot_0.png','94eeedbf-2b59-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Mordu posterieur gauche 1.20.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-10-12 12:42:38.000','2023-06-13 12:02:22.624','2023-06-13 14:02:22.624'),('94fc41f3-2b59-11ec-9377-226cec7cb58a',662,'/var/.data/2021/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/94fc41f3-2b59-11ec-9377-226cec7cb58a.png','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_RISC_00f07cdc-1834-4ae1-a9fa-47699828c094_SNAPS','20_w1_o1_mordu_posterieur_droit_snapshot_0.png','94fc41f3-2b59-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Mordu posterieur droit 1.20.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-10-12 12:40:25.000','2023-06-13 12:02:22.632','2023-06-13 14:02:22.632'),('94ffa87d-2b59-11ec-9377-226cec7cb58a',662,'/var/.data/2021/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/94ffa87d-2b59-11ec-9377-226cec7cb58a.png','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_BOSC_453abb20-3827-4f8b-b57f-c656c72ebf11_SNAPS','20_w1_o1_mandibule_snapshot_1.png','94ffa87d-2b59-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Mandibule 1.20.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-10-12 12:26:33.000','2023-06-13 12:02:22.641','2023-06-13 14:02:22.641'),('9511cb22-2b59-11ec-9377-226cec7cb58a',662,'/var/.data/2021/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/9511cb22-2b59-11ec-9377-226cec7cb58a.zip','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_FRSC_881d38cc-cf89-4329-8456-b90f8c997725_MODEL','20_w1_o1_mordu_anterieur_scan_file_0.zip','9511cb22-2b59-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Mordu anterieur 1.20.1.1.1\",\"modelMatrix\":\"0.7186,-0.0747595,0.698393,0,0.0913484,0.998565,-0.0222422,0,-0.689689,0.026612,0.717523,0,6.32349,-0.987183,-29.4038,1\",\"title\":\"Mordu anterieur ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2021-10-12 12:44:17.000','2023-06-13 12:02:22.649','2023-06-13 14:02:22.649'),('9514c875-2b59-11ec-9377-226cec7cb58a',662,'/var/.data/2021/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/9514c875-2b59-11ec-9377-226cec7cb58a.zip','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_BOSC_453abb20-3827-4f8b-b57f-c656c72ebf11_MODEL','20_w1_o1_mandibule_scan_file_1.zip','9514c875-2b59-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Mandibule 1.20.1.1.1\",\"modelMatrix\":\"0.993602,-0.104869,0.0419241,0,0.112939,0.922608,-0.368835,0,-7.12355e-11,0.37121,0.928549,0,-21.8303,-22.816,-15.4889,1\",\"title\":\"Mandibule ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2021-10-12 12:26:35.000','2023-06-13 12:02:22.658','2023-06-13 14:02:22.658'),('95181c09-2b59-11ec-9377-226cec7cb58a',662,'/var/.data/2021/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/95181c09-2b59-11ec-9377-226cec7cb58a.png','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_TOSC_42b09cf6-e30d-4d35-a17d-d8e8b4564638_SNAPS','20_w1_o1_maxillaire_snapshot_1.png','95181c09-2b59-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Maxillaire 1.20.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-10-12 12:37:44.000','2023-06-13 12:02:22.668','2023-06-13 14:02:22.668'),('9533b2b7-5385-4d5f-8858-b01c1c030817',662,'/var/.data/2020/662/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/order_6ff5b097-d5bb-4902-981f-b53e6fa85604/10_w1_autre_prost_file_0.pdf','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_PROST_6ff5b097-d5bb-4902-981f-b53e6fa85604_FORM','10_w1_autre_prost_file_0.pdf','9533b2b7-5385-4d5f-8858-b01c1c030817','{\"displayTitle\":\"AUTRE FICHE PROTHÉTIQUE 1.10.1.1 AUTRE FICHE PROTHÉTIQUE\",\"title\":\"Autre PDF\"}','PDF',0,'SYNCED',0,NULL,'2020-04-30 20:27:47.000','2023-06-13 12:02:17.728','2023-06-13 14:02:17.728'),('95ab2e1b-4b91-4bb5-965e-8086f8805dc7',662,'/var/.data/2020/662/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/order_63706c26-d501-4c56-bdc2-ab2c76f6d988/10_w1_autre_prost_file_0.pdf','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_PROST_63706c26-d501-4c56-bdc2-ab2c76f6d988_FORM','10_w1_autre_prost_file_0.pdf','95ab2e1b-4b91-4bb5-965e-8086f8805dc7','{\"displayTitle\":\"AUTRE FICHE PROTHÉTIQUE 1.10.1.3 AUTRE FICHE PROTHÉTIQUE\",\"title\":\"Autre PDF\"}','PDF',0,'SYNCED',0,NULL,'2020-05-01 08:31:26.000','2023-06-13 12:02:17.803','2023-06-13 14:02:17.803'),('9617b0df-e829-47cd-8110-fabb587a690d',662,'/var/.data/2021/662/5587321c-4405-49dc-90d5-8810cc776c6d/session_7e359a5f-1756-4ec7-8657-3e5940ae489d/occlusion_b29b47d4-35f8-427d-9cd7-a393e48be2cf/scan_881d38cc-cf89-4329-8456-b90f8c997725/20_w1_o1_mordu_anterieur_scan_file_0.zip','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_FRSC_881d38cc-cf89-4329-8456-b90f8c997725_MODEL','20_w1_o1_mordu_anterieur_scan_file_0.zip','9617b0df-e829-47cd-8110-fabb587a690d','{\"displayTitle\":\"Mordu anterieur 1.20.1.1.1\",\"modelMatrix\":\"0.7186,-0.0747595,0.698393,0,0.0913484,0.998565,-0.0222422,0,-0.689689,0.026612,0.717523,0,6.32349,-0.987183,-29.4038,1\",\"title\":\"Mordu anterieur ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2021-10-12 12:44:17.000','2023-06-13 12:02:12.673','2023-06-13 14:02:12.673'),('963a8acf-cdb2-41d5-b187-9a7c885ac2a0',662,'/var/.data/2021/662/ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07/session_b498bdf4-2e5b-497a-8bfe-b65edabac3bc/occlusion_31210683-bc06-4b84-83d9-ce60f32308e4/scan_1e8824f7-3c76-4fe0-bd8c-f865f725dab2/22_w1_o1_mordu_anterieur_scan_file_0.zip','PATIENT_ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07_ACT_b498bdf4-2e5b-497a-8bfe-b65edabac3bc_SESS_31210683-bc06-4b84-83d9-ce60f32308e4_FRSC_1e8824f7-3c76-4fe0-bd8c-f865f725dab2_MODEL','22_w1_o1_mordu_anterieur_scan_file_0.zip','963a8acf-cdb2-41d5-b187-9a7c885ac2a0','{\"displayTitle\":\"Mordu anterieur 1.22.1.1.1\",\"modelMatrix\":\"0.725913,-0.0652903,0.681352,0,-0.0436065,0.981927,0.168419,0,-0.687258,-0.181082,0.712365,0,10.2372,3.44717,-27.8986,1\",\"title\":\"Mordu anterieur ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2021-11-23 12:23:17.000','2023-06-13 12:02:13.021','2023-06-13 14:02:13.021'),('96c2eb83-88a2-4de9-b439-f00924861267',662,'','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_RISC_76f39717-6f88-4e19-800c-f827a697a4d6_SNAPS','7_w2_o2_mordu_posterieur_droit_snapshot_1.png','59f86cb7-d0b5-456d-bb86-a5a83efb559d','{\"displayTitle\":\"MORDU_POSTERIEUR_DROIT 1.7.2.2.2\",\"title\":\"MORDU_POSTERIEUR_DROIT SNAPSHOT\"}','PNG',1,'SYNCED',0,'2023-04-12 06:40:56.000','2020-04-16 07:21:49.000','2023-06-13 12:02:15.351','2023-06-13 14:02:15.351'),('97939bfa-2cd3-4695-a8de-c1359ed5322d',662,'/var/.data/2021/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97/21_w1_o1_mandibule_scan_file_1.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_BOSC_f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97_MODEL','21_w1_o1_mandibule_scan_file_1.zip','3aa92b1f-240d-45e1-a722-e8da98368f3a','{\"displayTitle\":\"Mandibule 1.21.1.1.1\",\"modelMatrix\":\"0.987343,0.148109,-0.0567189,0,-0.158598,0.922045,-0.3531,0,-6.4352e-9,0.357626,0.933865,0,6.81045,-6.30601,-21.6536,1\",\"title\":\"Mandibule ZIP\"}','ZIP',1,'SYNCED',0,NULL,'2021-11-22 12:31:31.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.093'),('97fdea91-3417-11ed-a752-9ec33d03e6dd',662,'/var/.data/2022/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/97fdea91-3417-11ed-a752-9ec33d03e6dd.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_e43c8099-0862-42c3-9ad2-1efef27b83ba_SESS_09f15124-6bba-4565-bfe4-efb3c6c3a17d_TOSC_3a315f7b-8cf2-4d0c-bf92-fecb623fe530_SNAPS','21_w3_o1_maxillaire_snapshot_1.png','97fdea91-3417-11ed-a752-9ec33d03e6dd','{\"displayTitle\":\"Maxillaire 1.21.3.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-09-14 12:23:53.000','2023-06-13 12:02:23.109','2023-06-13 14:02:23.109'),('97ff66d6-3417-11ed-a752-9ec33d03e6dd',662,'/var/.data/2022/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/97ff66d6-3417-11ed-a752-9ec33d03e6dd.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_e43c8099-0862-42c3-9ad2-1efef27b83ba_SESS_09f15124-6bba-4565-bfe4-efb3c6c3a17d_TOSC_3a315f7b-8cf2-4d0c-bf92-fecb623fe530_MODEL','21_w3_o1_maxillaire_scan_file_1.zip','97ff66d6-3417-11ed-a752-9ec33d03e6dd','{\"displayTitle\":\"Maxillaire 1.21.3.1.1\",\"modelMatrix\":\"0.804251,0.588743,-0.0810022,0,-0.594289,0.796746,-0.10962,0,9.77465e-10,0.136301,0.990668,0,-23.7315,-16.3663,-21.3795,1\",\"title\":\"Maxillaire ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-09-14 12:23:55.000','2023-06-13 12:02:23.118','2023-06-13 14:02:23.118'),('98a2c194-b406-4930-b901-3f1b520fc329',662,'','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_BOSC_d2372948-816f-4d58-a2bf-288bc0e7b539_SNAPS','7_w2_o2_mandibule_snapshot_0.png','98a2c194-b406-4930-b901-3f1b520fc329','{\"displayTitle\":\"MANDIBULE 1.7.2.2.1\",\"title\":\"MANDIBULE SNAPSHOT\"}','PNG',0,'SYNCED',0,'2023-04-12 06:40:26.000','2020-04-15 07:13:11.000','2023-06-13 12:02:15.540','2023-06-13 14:02:15.540'),('98c10ee7-5736-4c52-8f1e-248cda79d235',662,'/var/.data/2021/662/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_79548cb6-a61f-44cb-b6f7-cab7698f7465/14_w1_o1_mordu_posterieur_droit_scan_file_1.ply','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_RISC_79548cb6-a61f-44cb-b6f7-cab7698f7465_MODEL','14_w1_o1_mordu_posterieur_droit_scan_file_1.ply','520d0710-d923-46c1-a1dd-f05370a3a5ea','{\"displayTitle\":\"Mordu posterieur droit 1.14.1.1.1\",\"modelMatrix\":\"0.99813,-0.0235655,0.0527488,0,0.0384935,0.985506,-0.157052,0,-0.0479116,0.168417,0.986232,0,6.32685,-2.3003,-17.7869,1\",\"title\":\"Mordu posterieur droit PLY\"}','PLY',1,'SYNCED',0,NULL,'2021-02-01 21:15:42.000','2023-06-13 12:02:09.611','2023-06-13 14:02:09.611'),('9946c86d-7b6b-4bd2-8dae-8b982fbd7cfc',662,'','PATIENT_d41de280-8cf3-4e57-893e-cc7a010bc864_ACT_c59a2f65-79fe-44cd-8377-e39aa0a44171_SESS_daf632b1-2c49-42c8-8899-0a0b2448bc3a_TOSC_fbfa4372-1faf-4a14-9f4e-70b7b375da7d_SNAPS','9_w1_o1_maxillaire_snapshot_0.png','9946c86d-7b6b-4bd2-8dae-8b982fbd7cfc','{\"displayTitle\":\"MAXILLAIRE 1.9.1.1.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}','PNG',0,'SYNCED',0,'2023-04-12 06:40:46.000','2020-04-18 09:18:30.000','2023-06-13 12:02:09.972','2023-06-13 14:02:09.972'),('9b87eb98-b2ac-4d29-83ea-5125f3d83710',662,'/var/.data/2021/662/ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07/session_b498bdf4-2e5b-497a-8bfe-b65edabac3bc/occlusion_31210683-bc06-4b84-83d9-ce60f32308e4/scan_98e7c216-5bb9-4127-9497-834796980370/22_w1_o1_maxillaire_snapshot_0.png','PATIENT_ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07_ACT_b498bdf4-2e5b-497a-8bfe-b65edabac3bc_SESS_31210683-bc06-4b84-83d9-ce60f32308e4_TOSC_98e7c216-5bb9-4127-9497-834796980370_SNAPS','22_w1_o1_maxillaire_snapshot_0.png','9b87eb98-b2ac-4d29-83ea-5125f3d83710','{\"displayTitle\":\"Maxillaire 1.22.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-11-23 12:08:21.000','2023-06-13 12:02:12.948','2023-06-13 14:02:12.948'),('9c755cdf-e1f1-49e0-9dcf-708a856d1b81',662,'/var/.data/2020/662/d41de280-8cf3-4e57-893e-cc7a010bc864/session_c59a2f65-79fe-44cd-8377-e39aa0a44171/occlusion_daf632b1-2c49-42c8-8899-0a0b2448bc3a/scan_16cf8664-2af0-446a-ac6d-ef0e40edb71d/9_w1_o1_mordu_posterieur_gauche_scan_file_0.ply','PATIENT_d41de280-8cf3-4e57-893e-cc7a010bc864_ACT_c59a2f65-79fe-44cd-8377-e39aa0a44171_SESS_daf632b1-2c49-42c8-8899-0a0b2448bc3a_LESC_16cf8664-2af0-446a-ac6d-ef0e40edb71d_MODEL','9_w1_o1_mordu_posterieur_gauche_scan_file_0.ply','9c755cdf-e1f1-49e0-9dcf-708a856d1b81','{\"displayTitle\":\"Mordu posterieur gauche 1.9.1.1.1\",\"modelMatrix\":\"-0.998681,-0.0207537,0.0468898,0,0.0210913,-0.997412,0.067392,0,0.0469286,0.0689054,0.996625,0,5.92553,-7.23372,-30.3577,1\",\"title\":\"MORDU_POSTERIEUR_GAUCHE PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-18 09:35:44.000','2023-06-13 12:02:10.579','2023-06-13 14:02:10.579'),('9cd5b1c8-ef15-449d-97a1-bdf6947abe78',662,'/var/.data/2020/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/9cd5b1c8-ef15-449d-97a1-bdf6947abe78.png','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_cb9d8495-b4dd-423f-a624-7cff70e4db55_SESS_c9d37315-5f17-421c-8afb-302fa9b0bebe_BOSC_6fafe104-bdc1-41a6-9977-b1bbb351a329_SNAPS','2_w2_o1_mandibule_snapshot_1.png','386b43f6-0c1a-484d-9092-8962d1eb3835','{\"displayTitle\":\"MANDIBULE 1.2.2.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}','PNG',1,'SYNCED',0,'2023-04-12 06:40:57.000','2020-04-07 06:42:41.000','2023-06-13 12:02:15.312','2023-06-13 14:02:15.312'),('9d114e81-9c84-452b-9722-47ddb78d35e5',662,'/var/.data/2020/662/2b4f07b1-1d58-42a2-9e72-3461efd5a2d9/session_bc967a6b-ad1a-4a59-aab8-92332e4217b0/occlusion_f2e73640-aebd-4bb1-9b02-c0504556ac5a/scan_e7efed59-e33c-4194-94c1-3507350dcfb5/5_w3_o1_maxillaire_snapshot_1.png','PATIENT_2b4f07b1-1d58-42a2-9e72-3461efd5a2d9_ACT_bc967a6b-ad1a-4a59-aab8-92332e4217b0_SESS_f2e73640-aebd-4bb1-9b02-c0504556ac5a_TOSC_e7efed59-e33c-4194-94c1-3507350dcfb5_SNAPS','5_w3_o1_maxillaire_snapshot_1.png','b94c36ee-0e86-44b0-a152-b92997bdab17','{\"displayTitle\":\"Maxillaire 1.5.3.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2020-07-13 19:32:07.000','2023-06-13 12:02:10.431','2023-06-13 14:02:10.431'),('9d5d6282-185b-45e3-8902-11f6f83c2991',662,'','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_ec084612-67a2-4430-ae15-7fe0edeaca64_SESS_78636467-a73b-4270-8bc5-35a2664dec9d_BOSC_7f9aec2d-6246-4413-842d-78d2e0bddb1e_SNAPS','2_w3_o1_mandibule_snapshot_0.png','9d5d6282-185b-45e3-8902-11f6f83c2991','{\"displayTitle\":\"MANDIBULE 1.2.3.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}','PNG',0,'SYNCED',0,'2023-04-12 06:40:57.000','2020-04-12 07:48:40.000','2023-06-13 12:02:15.449','2023-06-13 14:02:15.449'),('9d65d7e8-dc55-4823-9aae-6c5190aae7da',662,'/var/.data/2020/662/406a8572-4b0f-480a-ad2e-daf5530143b6/session_a7b0f1ae-ce37-4faf-9b3c-e5fab6996549/occlusion_254f3fc9-4782-4658-bb34-f2ca1c9b6382/scan_e5fd24c7-49a8-4dbc-9356-3b96970d2515/2_w6_o1_maxillaire_scan_file_0.ply','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_a7b0f1ae-ce37-4faf-9b3c-e5fab6996549_SESS_254f3fc9-4782-4658-bb34-f2ca1c9b6382_TOSC_e5fd24c7-49a8-4dbc-9356-3b96970d2515_MODEL','2_w6_o1_maxillaire_scan_file_0.ply','9d65d7e8-dc55-4823-9aae-6c5190aae7da','{\"displayTitle\":\"Maxillaire 1.2.6.1.1\",\"modelMatrix\":\"-0.902375,0.403092,-0.152434,0,-0.430952,-0.844039,0.319184,0,6.90148e-9,0.353715,0.935353,0,17.7056,-10.8652,-31.3865,1\",\"title\":\"MAXILLAIRE PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-05-21 08:00:21.000','2023-06-13 12:02:10.399','2023-06-13 14:02:10.399'),('9fa4fa76-ae1b-496c-bc61-9c8652c7f3d6',662,'/var/.data/2021/662/615ede1a-dba9-4251-9e9e-6cbbd3041fdc/session_76dcd1f0-f6c7-480f-b07b-441679345d70/occlusion_c6fffa68-cc65-471a-a58e-135ebe4d0772/scan_7a39120e-2f79-4c3e-af4d-af72e8ca8062/15_w1_o1_mordu_posterieur_gauche_snapshot_0.png','PATIENT_615ede1a-dba9-4251-9e9e-6cbbd3041fdc_ACT_76dcd1f0-f6c7-480f-b07b-441679345d70_SESS_c6fffa68-cc65-471a-a58e-135ebe4d0772_LESC_7a39120e-2f79-4c3e-af4d-af72e8ca8062_SNAPS','15_w1_o1_mordu_posterieur_gauche_snapshot_0.png','9fa4fa76-ae1b-496c-bc61-9c8652c7f3d6','{\"displayTitle\":\"Mordu posterieur gauche 1.15.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-02-16 12:57:03.000','2023-06-13 12:02:09.763','2023-06-13 14:02:09.763'),('a017e06b-1e5e-408c-9423-28e5f5e8e405',662,'/var/.data/2020/662/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/occlusion_b87f1382-55d4-4e52-b63a-6f387df18b16/scan_a26f0d58-ca46-4921-a9e1-9c39b7f89783/13_w4_o1_maxillaire_snapshot_2.png','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_SESS_b87f1382-55d4-4e52-b63a-6f387df18b16_TOSC_a26f0d58-ca46-4921-a9e1-9c39b7f89783_SNAPS','13_w4_o1_maxillaire_snapshot_2.png','24c23cdd-d323-4623-8a9d-2d3e14f3b937','{\"displayTitle\":\"Maxillaire 1.13.4.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',2,'SYNCED',0,NULL,'2020-12-29 11:13:13.000','2023-06-13 12:02:09.496','2023-06-13 14:02:09.496'),('a06c28ec-9f81-44b6-b11e-a5e06d983e4a',662,'/var/.data/2020/662/406a8572-4b0f-480a-ad2e-daf5530143b6/session_a7b0f1ae-ce37-4faf-9b3c-e5fab6996549/occlusion_254f3fc9-4782-4658-bb34-f2ca1c9b6382/scan_107f2922-62ee-42d9-8e35-69d71587db0b/2_w6_o1_mandibule_snapshot_0.png','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_a7b0f1ae-ce37-4faf-9b3c-e5fab6996549_SESS_254f3fc9-4782-4658-bb34-f2ca1c9b6382_BOSC_107f2922-62ee-42d9-8e35-69d71587db0b_SNAPS','2_w6_o1_mandibule_snapshot_0.png','a06c28ec-9f81-44b6-b11e-a5e06d983e4a','{\"displayTitle\":\"Mandibule 1.2.6.1.2\",\"title\":\"MANDIBULE SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-05-21 08:13:15.000','2023-06-13 12:02:10.474','2023-06-13 14:02:10.474'),('a196ba15-5ebd-46d8-b6fa-0325918797ac',662,'/var/.data/2021/662/f15cb858-4f0b-44ec-a017-5e662039ba19/session_72b7a457-e38f-4535-8eba-6c98b43e5e55/occlusion_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c/scan_41b8d05c-738b-4161-9f86-27222b61ad66/14_w2_o1_mordu_posterieur_droit_scan_file_0.ply','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_72b7a457-e38f-4535-8eba-6c98b43e5e55_SESS_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c_RISC_41b8d05c-738b-4161-9f86-27222b61ad66_MODEL','14_w2_o1_mordu_posterieur_droit_scan_file_0.ply','a196ba15-5ebd-46d8-b6fa-0325918797ac','{\"displayTitle\":\"Mordu posterieur droit 1.14.2.1.1\",\"modelMatrix\":\"0.963334,-0.197211,0.185499,0,0.215878,0.966781,-0.127615,0,-0.159544,0.16278,0.974333,0,12.3445,-6.93427,-15.1056,1\",\"title\":\"Mordu posterieur droit PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-06-08 20:48:52.000','2023-06-13 12:02:12.323','2023-06-13 14:02:12.323'),('a1bc9da2-af83-43c3-8210-759800158585',662,'/var/.data/2022/662/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_949fe730-88fa-4ec2-852e-dd0772ee3ee0/occlusion_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d/scan_1c6adc05-0655-4ad6-bcc9-27b0ef578ded/19_w2_o1_maxillaire_scan_file_0.zip','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_949fe730-88fa-4ec2-852e-dd0772ee3ee0_SESS_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d_TOSC_1c6adc05-0655-4ad6-bcc9-27b0ef578ded_MODEL','19_w2_o1_maxillaire_scan_file_0.zip','a1bc9da2-af83-43c3-8210-759800158585','{\"displayTitle\":\"Maxillaire 1.19.2.1.1\",\"modelMatrix\":\"-0.971523,0.228207,-0.0637541,0,-0.236945,-0.935695,0.261405,0,-3.89171e-10,0.269067,0.963122,0,10.1318,-13.6766,-27.7474,1\",\"title\":\"Maxillaire ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-06-28 20:20:24.000','2023-06-13 12:02:13.418','2023-06-13 14:02:13.418'),('a2156f23-da3f-4a2a-97f3-76ea6c877521',662,'','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_FRSC_ca33a9ff-b86a-4e97-8674-1bd7adc92759_SNAPS','7_w2_o2_mordu_anterieur_snapshot_0.png','a2156f23-da3f-4a2a-97f3-76ea6c877521','{\"displayTitle\":\"MORDU_ANTERIEUR 1.7.2.2.1\",\"title\":\"MORDU_ANTERIEUR SNAPSHOT\"}','PNG',0,'SYNCED',0,'2023-04-12 06:40:59.000','2020-04-15 07:43:36.000','2023-06-13 12:02:15.497','2023-06-13 14:02:15.497'),('a3243928-a351-4ca9-b9b0-be959eab0b25',662,'/var/.data/2020/662/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/occlusion_b87f1382-55d4-4e52-b63a-6f387df18b16/scan_4a2eec76-a5f3-44f0-b389-4734998fa2d3/13_w4_o1_mandibule_snapshot_1.png','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_SESS_b87f1382-55d4-4e52-b63a-6f387df18b16_BOSC_4a2eec76-a5f3-44f0-b389-4734998fa2d3_SNAPS','13_w4_o1_mandibule_snapshot_1.png','e8f06fb1-375a-41c0-9a27-d0ee2593900c','{\"displayTitle\":\"Mandibule 1.13.4.1.1\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2020-12-29 11:24:49.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.095'),('a3ae3378-e8e9-495e-9dc6-8a3be2a9a968',662,'/var/.data/2022/662/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_7841125a-11dd-4b66-9179-cd371ea2f0f7/occlusion_12115366-8eb9-470b-a097-5d28bb5fdf38/scan_793e84ce-b088-458d-82f5-33fab1f5e7de/23_w1_o1_maxillaire_snapshot_1.png','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_TOSC_793e84ce-b088-458d-82f5-33fab1f5e7de_SNAPS','23_w1_o1_maxillaire_snapshot_1.png','81bbb529-1a14-4e29-b842-b84cbac8d014','{\"displayTitle\":\"Maxillaire 1.23.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2022-01-11 12:23:17.000','2023-06-13 12:02:13.068','2023-06-13 14:02:13.068'),('a3d56e52-a954-4894-b840-be0425c42658',662,'/var/.data/2021/662/ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07/session_b498bdf4-2e5b-497a-8bfe-b65edabac3bc/occlusion_31210683-bc06-4b84-83d9-ce60f32308e4/scan_0f18aace-5cf2-4d46-b56f-f8dc123e1f91/22_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','PATIENT_ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07_ACT_b498bdf4-2e5b-497a-8bfe-b65edabac3bc_SESS_31210683-bc06-4b84-83d9-ce60f32308e4_LESC_0f18aace-5cf2-4d46-b56f-f8dc123e1f91_MODEL','22_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','a3d56e52-a954-4894-b840-be0425c42658','{\"displayTitle\":\"Mordu posterieur gauche 1.22.1.1.2\",\"modelMatrix\":\"-0.987423,-0.1162,0.110526,0,0.107197,-0.992212,-0.0556946,0,0.116253,-0.0450283,0.992314,0,-8.57688,0.410708,-18.9216,1\",\"title\":\"Mordu posterieur gauche ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2021-11-23 12:21:30.000','2023-06-13 12:02:13.002','2023-06-13 14:02:13.002'),('a41e073f-d40b-4f4f-924e-2afd61ac4f8c',662,'','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_ec084612-67a2-4430-ae15-7fe0edeaca64_SESS_2ed4960a-e6fa-46de-a306-32385df3346c_BOSC_45b21304-1129-40a2-b60e-d72a2bf96e72_MODEL','2_w3_o2_mandibule_scan_file_0.ply','a41e073f-d40b-4f4f-924e-2afd61ac4f8c','{\"displayTitle\":\"Mandibule Occlusion 1.2.3.2\",\"modelMatrix\":\"0.681905,-0.663539,0.307768,0,0.73144,0.618603,-0.286925,0,3.97899e-9,0.420769,0.907168,0,8.44157,-16.5785,-24.6748,1\",\"title\":\"MANDIBULE PLY\"}','PLY',0,'SYNCED',0,'2023-04-12 06:41:27.000','2020-04-12 07:51:14.000','2023-06-13 12:02:15.173','2023-06-13 14:02:15.173'),('a483fb03-0adb-4387-9099-c9c2567855e7',662,'','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_FRSC_ca33a9ff-b86a-4e97-8674-1bd7adc92759_MODEL','7_w2_o2_mordu_anterieur_scan_file_0.ply','a483fb03-0adb-4387-9099-c9c2567855e7','{\"displayTitle\":\"MORDU_ANTERIEUR 1.7.2.2.1\",\"modelMatrix\":\"0.716923,0.0202956,0.693353,0,-0.0337042,0.999997,-0.0100568,0,-0.69663,0.000757645,0.720556,0,12.2181,4.16901,-40.9229,1\",\"title\":\"MORDU_ANTERIEUR PLY\"}','PLY',0,'SYNCED',0,'2023-04-12 06:40:59.000','2020-04-15 07:43:36.000','2023-06-13 12:02:15.504','2023-06-13 14:02:15.504'),('a4f0f4fa-9346-4a75-a1dd-e95c83dc5e6b',662,'/var/.data/2022/662/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_949fe730-88fa-4ec2-852e-dd0772ee3ee0/occlusion_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d/scan_1c6adc05-0655-4ad6-bcc9-27b0ef578ded/19_w2_o1_maxillaire_scan_file_4.zip','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_949fe730-88fa-4ec2-852e-dd0772ee3ee0_SESS_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d_TOSC_1c6adc05-0655-4ad6-bcc9-27b0ef578ded_MODEL','19_w2_o1_maxillaire_scan_file_4.zip','a1bc9da2-af83-43c3-8210-759800158585','{\"displayTitle\":\"Maxillaire 1.19.2.1.1\",\"modelMatrix\":\"-0.913445,0.391574,-0.110853,0,-0.406963,-0.878905,0.248813,0,-2.04414e-09,0.27239,0.962187,0,9.22638,-15.1189,-27.0834,1\",\"title\":\"Maxillaire ZIP\"}','ZIP',4,'SYNCED',0,NULL,'2022-06-28 20:39:41.000','2023-06-13 12:02:13.452','2023-06-13 14:02:13.452'),('a54c4788-74a1-482e-bbc8-b46aeb6ca424',662,'','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_FRSC_0c8af1cb-8054-4a35-9cfe-449c19dbe59b_MODEL','7_w2_o2_mordu_anterieur_scan_file_0.ply','a54c4788-74a1-482e-bbc8-b46aeb6ca424','{\"displayTitle\":\"MORDU_ANTERIEUR 1.7.2.2.2\",\"modelMatrix\":\"0.861884,0.00906517,0.502349,0,0.0701613,0.983085,-0.141231,0,-0.50252,0.185157,0.8534,0,-0.835727,-2.50445,-37.3935,1\",\"title\":\"MORDU_ANTERIEUR PLY\"}','PLY',0,'SYNCED',0,'2023-04-12 06:41:00.000','2020-04-16 07:10:44.000','2023-06-13 12:02:15.131','2023-06-13 14:02:15.131'),('a5903ca6-45db-41cc-a262-19592ff5f2e4',662,'','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_LESC_6ce1c2d0-1849-4a2a-bfd9-05247b74c2d7_MODEL','7_w2_o2_mordu_posterieur_gauche_scan_file_0.ply','a5903ca6-45db-41cc-a262-19592ff5f2e4','{\"displayTitle\":\"MORDU_POSTERIEUR_GAUCHE 1.7.2.2.1\",\"modelMatrix\":\"-0.999903,-0.00806038,0.0111619,0,0.0083222,-0.994448,-0.103366,0,0.0112516,-0.104947,0.994583,0,16.7147,8.54514,-27.4379,1\",\"title\":\"MORDU_POSTERIEUR_GAUCHE PLY\"}','PLY',0,'SYNCED',0,'2023-04-12 06:41:00.000','2020-04-15 07:39:22.000','2023-06-13 12:02:15.268','2023-06-13 14:02:15.268'),('a60e34f6-4db6-4236-9d5a-1741dd2ed622',662,'/var/.data/2021/662/5587321c-4405-49dc-90d5-8810cc776c6d/session_7e359a5f-1756-4ec7-8657-3e5940ae489d/occlusion_b29b47d4-35f8-427d-9cd7-a393e48be2cf/scan_42b09cf6-e30d-4d35-a17d-d8e8b4564638/20_w1_o1_maxillaire_snapshot_0.png','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_TOSC_42b09cf6-e30d-4d35-a17d-d8e8b4564638_SNAPS','20_w1_o1_maxillaire_snapshot_0.png','a60e34f6-4db6-4236-9d5a-1741dd2ed622','{\"displayTitle\":\"Maxillaire SNAPSHOT\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-10-12 12:33:03.000','2023-06-13 12:02:12.720','2023-06-13 14:02:12.720'),('a6c49c5b-a994-457c-80d2-6cd69b636979',662,'/var/.data/2022/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_87965ef8-01eb-4830-8e8b-8b99ece62cf1/occlusion_dce9ce0f-0933-4c98-af84-59e2b6395f8f/scan_bd51414b-f96e-4903-a2e2-44fb3189decd/21_w2_o1_mandibule_scan_file_4.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_87965ef8-01eb-4830-8e8b-8b99ece62cf1_SESS_dce9ce0f-0933-4c98-af84-59e2b6395f8f_BOSC_bd51414b-f96e-4903-a2e2-44fb3189decd_MODEL','21_w2_o1_mandibule_scan_file_4.zip','1f29b918-27fd-422b-b4dd-da18687d0871','{\"displayTitle\":\"Mandibule 1.21.2.1.1\",\"modelMatrix\":\"-0.976298,-0.210823,0.0489521,0,0.216432,-0.950998,0.220817,0,-2.3765e-10,0.226178,0.974086,0,10.9881,11.8679,-20.8564,1\",\"title\":\"Mandibule ZIP\"}','ZIP',4,'SYNCED',0,NULL,'2022-06-27 21:02:22.000','2023-06-13 12:02:13.338','2023-06-13 14:02:13.338'),('a6fbdae8-d901-11ed-9278-00d86184ce0e',662,'/var/.data/2023/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_c983b946-e304-49a8-99c8-24eaca67b9ce/occlusion_9e007066-06fd-4fa1-a49a-f1165de95f83/scan_a6fbb2c0-d901-11ed-9278-00d86184ce0e/a6fbdae8-d901-11ed-9278-00d86184ce0e.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_c983b946-e304-49a8-99c8-24eaca67b9ce_SESS_9e007066-06fd-4fa1-a49a-f1165de95f83_TOSC_a6fbb2c0-d901-11ed-9278-00d86184ce0e_MODEL','a6fbdae8-d901-11ed-9278-00d86184ce0e.zip','a6fbdae8-d901-11ed-9278-00d86184ce0e','{\"displayTitle\":\"Maxillaire 1.21.8.1.2\",\"modelMatrix\":\"0.818642,0.55047,-0.163732,0,-0.574305,0.784667,-0.233391,0,-1.3908e-08,0.285096,0.958499,0,-17.5299,-5.99357,-22.031,1\",\"title\":\"Maxillaire ZIP\"}','ZIP',0,'SYNCED',0,'2023-04-12 09:15:07.657','2023-04-12 09:14:23.807','2023-04-12 07:15:07.661','2023-04-12 09:15:07.683'),('a70ac522-d901-11ed-9278-00d86184ce0e',662,'/var/.data/2023/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_c983b946-e304-49a8-99c8-24eaca67b9ce/occlusion_9e007066-06fd-4fa1-a49a-f1165de95f83/scan_a6fbb2c0-d901-11ed-9278-00d86184ce0e/a70ac522-d901-11ed-9278-00d86184ce0e.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_c983b946-e304-49a8-99c8-24eaca67b9ce_SESS_9e007066-06fd-4fa1-a49a-f1165de95f83_TOSC_a6fbb2c0-d901-11ed-9278-00d86184ce0e_SNAPS','a70ac522-d901-11ed-9278-00d86184ce0e.png','a70ac522-d901-11ed-9278-00d86184ce0e','{\"displayTitle\":\"Maxillaire 1.21.8.1.2 Snapshot\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',0,'SYNCED',0,'2023-04-12 09:15:07.657','2023-04-12 09:14:23.904','2023-04-12 07:15:07.664','2023-04-12 09:15:07.684'),('a7593039-4dcb-45a6-891b-98f0c4c5c835',662,'','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_RISC_76f39717-6f88-4e19-800c-f827a697a4d6_MODEL','7_w2_o2_mordu_posterieur_droit_scan_file_0.ply','a7593039-4dcb-45a6-891b-98f0c4c5c835','{\"displayTitle\":\"MORDU_POSTERIEUR_DROIT 1.7.2.2.2\",\"modelMatrix\":\"0.987807,-0.119242,0.0940675,0,0.0902673,0.894617,0.433219,0,-0.129248,-0.431163,0.896574,0,-8.30435,20.916,-28.957,1\",\"title\":\"MORDU_POSTERIEUR_DROIT PLY\"}','PLY',0,'SYNCED',0,'2023-04-12 06:41:03.000','2020-04-16 07:05:20.000','2023-06-13 12:02:15.360','2023-06-13 14:02:15.360'),('a76fbd10-38f6-45b2-bcd6-4235bebb7cc8',662,'/var/.data/2022/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_2a050d02-7424-4099-b1d0-2d7da678e690/occlusion_a5bc2d6f-0248-466f-a10b-08f5391fd12f/scan_d2cd260d-4191-4884-80e3-7ced9fa0f8ce/21_w5_o1_maxillaire_snapshot_0.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_2a050d02-7424-4099-b1d0-2d7da678e690_SESS_a5bc2d6f-0248-466f-a10b-08f5391fd12f_TOSC_d2cd260d-4191-4884-80e3-7ced9fa0f8ce_SNAPS','21_w5_o1_maxillaire_snapshot_0.png','a76fbd10-38f6-45b2-bcd6-4235bebb7cc8','{\"displayTitle\":\"Maxillaire 1.21.5.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-11-04 13:42:01.000','2023-06-13 12:02:14.958','2023-06-13 14:02:14.958'),('a8de488b-e4b1-4234-b30c-cb7d68338c86',662,'/var/.data/2023/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_2c78d514-95bd-4529-b0a1-babfb83849b1/occlusion_983c39b6-656b-4bf2-bf43-da1625adb861/scan_209f3c55-7380-4efa-8e6c-dfe8c99792a6/21_w7_o1_mandibule_scan_file_1.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_2c78d514-95bd-4529-b0a1-babfb83849b1_SESS_983c39b6-656b-4bf2-bf43-da1625adb861_BOSC_209f3c55-7380-4efa-8e6c-dfe8c99792a6_MODEL','21_w7_o1_mandibule_scan_file_1.zip','097b9793-f270-498e-9cfe-cf6bc2963744','{\"displayTitle\":\"Mandibule 1.21.7.1.1\",\"modelMatrix\":\"0.963295,-0.264852,0.0437776,0,0.268446,0.950399,-0.157092,0,4.83621e-10,0.163078,0.986613,0,-23.7054,-4.481,-22.7414,1\",\"title\":\"Mandibule ZIP\"}','ZIP',1,'SYNCED',0,NULL,'2023-01-11 12:25:57.000','2023-06-13 12:02:15.073','2023-06-13 14:02:15.073'),('a952743c-a21c-4952-8c29-3ac0e894560a',662,'/var/.data/2023/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_c983b946-e304-49a8-99c8-24eaca67b9ce/occlusion_9e007066-06fd-4fa1-a49a-f1165de95f83/scan_76ece440-81ad-42c8-ab91-f99fa29e2a83/21_w8_o1_maxillaire_snapshot_0.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_c983b946-e304-49a8-99c8-24eaca67b9ce_SESS_9e007066-06fd-4fa1-a49a-f1165de95f83_TOSC_76ece440-81ad-42c8-ab91-f99fa29e2a83_SNAPS','21_w8_o1_maxillaire_snapshot_0.png','a952743c-a21c-4952-8c29-3ac0e894560a','{\"displayTitle\":\"Maxillaire SNAPSHOT\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2023-04-12 06:40:30.000','2023-04-12 07:24:19.006','2023-04-12 09:24:19.006'),('a97b41cc-c47f-42ff-aed9-3b6ec8803714',662,'/var/.data/2021/662/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_0c1ed331-8df6-482e-8dd1-508d9b190c49/occlusion_6c6bb813-840d-454a-ab1d-9232434a4500/scan_ef79558a-21cf-4117-a0b7-ba0adf40f7dc/19_w1_o1_mordu_anterieur_snapshot_0.png','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_FRSC_ef79558a-21cf-4117-a0b7-ba0adf40f7dc_SNAPS','19_w1_o1_mordu_anterieur_snapshot_0.png','a97b41cc-c47f-42ff-aed9-3b6ec8803714','{\"displayTitle\":\"Mordu anterieur 1.19.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-09-27 12:49:22.000','2023-06-13 12:02:12.556','2023-06-13 14:02:12.556'),('ab2de538-1cbb-481f-a82e-899f47da34b7',662,'/var/.data/2023/662/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_586a7c87-5d8a-440f-a654-c452dc908844/occlusion_d70cc224-5e0d-4b47-9270-d8e23a25b566/scan_0e5656e0-946b-41b2-935b-ea820746e5a9/19_w4_o1_maxillaire_scan_file_1.zip','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_586a7c87-5d8a-440f-a654-c452dc908844_SESS_d70cc224-5e0d-4b47-9270-d8e23a25b566_TOSC_0e5656e0-946b-41b2-935b-ea820746e5a9_MODEL','19_w4_o1_maxillaire_scan_file_1.zip','dab48b34-de4a-4877-be2f-a21e13908dff','{\"displayTitle\":\"Maxillaire 1.19.4.1.1\",\"modelMatrix\":\"-0.635437,0.697716,-0.330774,0,-0.772152,-0.57418,0.272209,0,5.70047e-10,0.42838,0.903599,0,7.99987,-37.8812,-17.5689,1\",\"title\":\"Maxillaire ZIP\"}','ZIP',1,'SYNCED',0,NULL,'2023-03-21 12:27:29.000','2023-04-12 04:41:02.424','2023-04-12 06:41:02.424'),('ab47d04c-6ad7-430c-ae85-9231a2efc7b9',662,'/var/.data/2021/662/f15cb858-4f0b-44ec-a017-5e662039ba19/session_72b7a457-e38f-4535-8eba-6c98b43e5e55/occlusion_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c/scan_be9a4ba5-715b-4547-a31d-66621ec7b17f/14_w2_o1_maxillaire_scan_file_2.ply','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_72b7a457-e38f-4535-8eba-6c98b43e5e55_SESS_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c_TOSC_be9a4ba5-715b-4547-a31d-66621ec7b17f_MODEL','14_w2_o1_maxillaire_scan_file_2.ply','5498794c-1fcc-48dd-b50e-b57ca5d157ab','{\"displayTitle\":\"Maxillaire 1.14.2.1.1\",\"modelMatrix\":\"0.85642,0.513914,-0.0493714,0,-0.51628,0.852495,-0.0818987,0,1.43126e-9,0.0956291,0.995417,0,-12.3191,-0.719613,-24.1087,1\",\"title\":\"Maxillaire PLY\"}','PLY',2,'SYNCED',0,NULL,'2021-06-08 20:19:55.000','2023-06-13 12:02:12.235','2023-06-13 14:02:12.235'),('ac0adbda-ae71-490a-947a-f9bfe33db7e8',662,'/var/.data/2020/662/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/occlusion_b87f1382-55d4-4e52-b63a-6f387df18b16/scan_a26f0d58-ca46-4921-a9e1-9c39b7f89783/13_w4_o1_maxillaire_scan_file_2.ply','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_SESS_b87f1382-55d4-4e52-b63a-6f387df18b16_TOSC_a26f0d58-ca46-4921-a9e1-9c39b7f89783_MODEL','13_w4_o1_maxillaire_scan_file_2.ply','23251874-b8f3-48b3-b209-0b434edd5db0','{\"displayTitle\":\"Maxillaire 1.13.4.1.1\",\"modelMatrix\":\"-0.919068,0.381547,-0.0986675,0,-0.394098,-0.889798,0.2301,0,-5.85267e-10,0.250363,0.968152,0,8.93558,-12.3446,-23.835,1\",\"title\":\"Maxillaire PLY\"}','PLY',2,'SYNCED',0,NULL,'2020-12-29 11:13:13.000','2023-06-13 12:02:09.512','2023-06-13 14:02:09.512'),('ac2e051b-dd4c-4fc1-be89-d406c5ab9a69',662,'/var/.data/2021/662/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_0c1ed331-8df6-482e-8dd1-508d9b190c49/occlusion_6c6bb813-840d-454a-ab1d-9232434a4500/scan_50e1896b-8565-4257-9a61-2a685fff8165/19_w1_o1_mandibule_scan_file_0.ply','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_BOSC_50e1896b-8565-4257-9a61-2a685fff8165_MODEL','19_w1_o1_mandibule_scan_file_0.ply','ac2e051b-dd4c-4fc1-be89-d406c5ab9a69','{\"displayTitle\":\"Mandibule PLY\",\"modelMatrix\":\"-0.887508,-0.460253,0.0222794,0,0.460792,-0.88647,0.0429112,0,5.65161e-10,0.0483502,0.99883,0,0.904253,19.5081,-23.603,1\",\"title\":\"Mandibule PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-09-27 12:37:45.000','2023-06-13 12:02:12.625','2023-06-13 14:02:12.625'),('ae0e9352-37bf-4a60-8c33-459deae4ddb5',662,'/var/.data/2023/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_c983b946-e304-49a8-99c8-24eaca67b9ce/occlusion_9e007066-06fd-4fa1-a49a-f1165de95f83/scan_76ece440-81ad-42c8-ab91-f99fa29e2a83/21_w8_o1_maxillaire_scan_file_0.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_c983b946-e304-49a8-99c8-24eaca67b9ce_SESS_9e007066-06fd-4fa1-a49a-f1165de95f83_TOSC_76ece440-81ad-42c8-ab91-f99fa29e2a83_MODEL','21_w8_o1_maxillaire_scan_file_0.zip','ae0e9352-37bf-4a60-8c33-459deae4ddb5','{\"displayTitle\":\"Maxillaire 1.21.8.1.1\",\"modelMatrix\":\"0.845476,0.511004,-0.155065,0,-0.534013,0.809047,-0.245507,0,1.45766e-08,0.290377,0.956912,0,-18.6921,-5.51179,-22.04,1\",\"title\":\"Maxillaire ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2023-04-12 06:40:23.000','2023-04-12 07:24:18.970','2023-04-12 09:24:18.970'),('af631cfa-13bc-4662-b2af-845b9dc8652b',662,'','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_RISC_76f39717-6f88-4e19-800c-f827a697a4d6_MODEL','7_w2_o2_mordu_posterieur_droit_scan_file_1.ply','a7593039-4dcb-45a6-891b-98f0c4c5c835','{\"displayTitle\":\"MORDU_POSTERIEUR_DROIT 1.7.2.2.2\",\"modelMatrix\":\"0.980716,-0.152567,0.119179,0,0.0907904,0.853265,0.508003,0,-0.174303,-0.498996,0.853257,0,-10.7174,24.6254,-28.5612,1\",\"title\":\"MORDU_POSTERIEUR_DROIT PLY\"}','PLY',1,'SYNCED',0,'2023-04-12 06:41:03.000','2020-04-16 07:21:49.000','2023-06-13 12:02:15.369','2023-06-13 14:02:15.369'),('affc6c02-1fc4-49c7-9730-6f5e1f2e9f8e',662,'/var/.data/2021/662/615ede1a-dba9-4251-9e9e-6cbbd3041fdc/session_76dcd1f0-f6c7-480f-b07b-441679345d70/occlusion_c6fffa68-cc65-471a-a58e-135ebe4d0772/scan_44ccf5f6-834d-4090-88dc-399b19fed47e/15_w1_o1_mordu_anterieur_snapshot_0.png','PATIENT_615ede1a-dba9-4251-9e9e-6cbbd3041fdc_ACT_76dcd1f0-f6c7-480f-b07b-441679345d70_SESS_c6fffa68-cc65-471a-a58e-135ebe4d0772_FRSC_44ccf5f6-834d-4090-88dc-399b19fed47e_SNAPS','15_w1_o1_mordu_anterieur_snapshot_0.png','affc6c02-1fc4-49c7-9730-6f5e1f2e9f8e','{\"displayTitle\":\"Mordu anterieur 1.15.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-02-16 13:05:08.000','2023-06-13 12:02:09.799','2023-06-13 14:02:09.799'),('b01eb471-5baa-4958-b2c6-736eab81754a',662,'/var/.data/2022/662/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_7841125a-11dd-4b66-9179-cd371ea2f0f7/occlusion_12115366-8eb9-470b-a097-5d28bb5fdf38/scan_d675acff-ab7f-4d65-b55c-558379a8b3d0/23_w1_o1_mordu_posterieur_gauche_snapshot_0.png','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_LESC_d675acff-ab7f-4d65-b55c-558379a8b3d0_SNAPS','23_w1_o1_mordu_posterieur_gauche_snapshot_0.png','b01eb471-5baa-4958-b2c6-736eab81754a','{\"displayTitle\":\"Mordu posterieur gauche 1.23.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-01-11 12:39:01.000','2023-06-13 12:02:13.178','2023-06-13 14:02:13.178'),('b03f52b8-54fa-4f11-9899-22d57d5b6ebc',662,'/var/.data/2022/662/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_7841125a-11dd-4b66-9179-cd371ea2f0f7/occlusion_12115366-8eb9-470b-a097-5d28bb5fdf38/scan_793e84ce-b088-458d-82f5-33fab1f5e7de/23_w1_o1_maxillaire_scan_file_0.zip','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_TOSC_793e84ce-b088-458d-82f5-33fab1f5e7de_MODEL','23_w1_o1_maxillaire_scan_file_0.zip','b03f52b8-54fa-4f11-9899-22d57d5b6ebc','{\"displayTitle\":\"Maxillaire 1.23.1.1.1\",\"modelMatrix\":\"-0.953812,-0.298383,0.0347982,0,0.300405,-0.947391,0.110487,0,2.52777e-9,0.115838,0.993268,0,21.6348,-11.7028,-20.1752,1\",\"title\":\"Maxillaire ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-01-11 12:16:30.000','2023-06-13 12:02:13.044','2023-06-13 14:02:13.044'),('b181e5ae-02f0-4845-a5ba-d30139f8d8a1',662,'','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_a7b0f1ae-ce37-4faf-9b3c-e5fab6996549_SESS_254f3fc9-4782-4658-bb34-f2ca1c9b6382_BOSC_4caeed6a-b015-4556-8794-2c3a00fea341_MODEL','2_w6_o1_mandibule_scan_file_0.ply','b181e5ae-02f0-4845-a5ba-d30139f8d8a1','{\"displayTitle\":\"MANDIBULE 1.2.6.1.1\",\"modelMatrix\":\"0.998987,-0.0441045,0.00891383,0,0.0449963,0.979189,-0.197901,0,-7.82441e-10,0.198102,0.980182,0,5.58069,-5.15897,-36.8754,1\",\"title\":\"MANDIBULE PLY\"}','PLY',0,'SYNCED',0,'2023-04-12 06:41:03.000','2020-05-21 08:03:19.000','2023-06-13 12:02:09.952','2023-06-13 14:02:09.952'),('b19b3b70-d194-4a56-8a06-dc3cf2fb8e6a',662,'/var/.data/2022/662/665b40ce-9690-4944-b007-4a96c1f5d57d/session_8f87b136-cb98-4706-b7d4-51059e1afa06/occlusion_5f895907-3eed-4aa7-995a-f7e1c9661a0a/scan_d04345c3-df70-4e2a-b197-cc37138e6700/25_w1_o1_mordu_anterieur_snapshot_0.png','PATIENT_665b40ce-9690-4944-b007-4a96c1f5d57d_ACT_8f87b136-cb98-4706-b7d4-51059e1afa06_SESS_5f895907-3eed-4aa7-995a-f7e1c9661a0a_FRSC_d04345c3-df70-4e2a-b197-cc37138e6700_SNAPS','25_w1_o1_mordu_anterieur_snapshot_0.png','b19b3b70-d194-4a56-8a06-dc3cf2fb8e6a','{\"displayTitle\":\"Mordu anterieur 1.25.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-03-11 11:15:49.000','2023-06-13 12:02:13.302','2023-06-13 14:02:13.302'),('b25a25e2-610a-466d-a4d8-7518a09b9a78',662,'/var/.data/2020/662/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_bdf42f40-5a7a-435b-a5e0-eb33efefbc97/computedocclusion_bdf42f40-5a7a-435b-a5e0-eb3migraoccl/6_w1_o1_maxillaire_occlusion_occ_file_0.ply','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_bdf42f40-5a7a-435b-a5e0-eb33efefbc97_OCC_bdf42f40-5a7a-435b-a5e0-eb3migraoccl_TOPLY','6_w1_o1_maxillaire_occlusion_occ_file_0.ply','b25a25e2-610a-466d-a4d8-7518a09b9a78','{\"displayTitle\":\"Maxillaire Occlusion 1.6.1.1.1\",\"referenceScanID\":\"1.6.1.1.1\",\"title\":\"Maxillaire Occlusion PLY\",\"occlusionMatrix\":\"0.899016,0.413029,-0.145522,0,-0.43749,0.861748,-0.256891,0,0.0192998,0.294614,0.955421,0,-10.1863,-1.6257,-25.2748,1\"}','PLY',0,'SYNCED',0,NULL,'2020-04-10 11:52:17.000','2023-06-13 12:02:16.253','2023-06-13 14:02:16.253'),('b328d68a-733b-46ed-9a1a-20aefc9f9b17',662,'/var/.data/2021/662/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_0c1ed331-8df6-482e-8dd1-508d9b190c49/occlusion_6c6bb813-840d-454a-ab1d-9232434a4500/scan_019e5bd1-9330-4e70-8035-2fda343b0231/19_w1_o1_maxillaire_scan_file_0.ply','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_TOSC_019e5bd1-9330-4e70-8035-2fda343b0231_MODEL','19_w1_o1_maxillaire_scan_file_0.ply','b328d68a-733b-46ed-9a1a-20aefc9f9b17','{\"displayTitle\":\"Maxillaire PLY\",\"modelMatrix\":\"-0.546245,0.828408,-0.123919,0,-0.837625,-0.540234,0.0808121,0,4.41513e-9,0.147941,0.988996,0,5.73056,-17.7586,-20.5485,1\",\"title\":\"Maxillaire PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-09-27 12:22:21.000','2023-06-13 12:02:12.567','2023-06-13 14:02:12.567'),('b50704aa-49f1-4444-8df4-4ec2e9e99b38',662,'/var/.data/2022/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_2a050d02-7424-4099-b1d0-2d7da678e690/occlusion_a5bc2d6f-0248-466f-a10b-08f5391fd12f/scan_d2cd260d-4191-4884-80e3-7ced9fa0f8ce/21_w5_o1_maxillaire_scan_file_1.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_2a050d02-7424-4099-b1d0-2d7da678e690_SESS_a5bc2d6f-0248-466f-a10b-08f5391fd12f_TOSC_d2cd260d-4191-4884-80e3-7ced9fa0f8ce_MODEL','21_w5_o1_maxillaire_scan_file_1.zip','6558fea4-267a-4a73-8416-579630e68249','{\"displayTitle\":\"Maxillaire 1.21.5.1.2\",\"modelMatrix\":\"0.821161,0.567307,-0.0621114,0,-0.570697,0.816283,-0.0893705,0,-4.83e-10,0.108834,0.99406,0,-27.6919,-16.2166,-25.6025,1\",\"title\":\"Maxillaire ZIP\"}','ZIP',1,'SYNCED',0,NULL,'2022-11-04 13:46:23.000','2023-06-13 12:02:14.949','2023-06-13 14:02:14.949'),('b51adc6b-e313-4ada-a607-3b0cd408c55b',662,'','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_BOSC_e99b1c89-977c-4836-9719-ad6d9a6f6aae_SNAPS','14_w1_o1_mandibule_snapshot_0.png','b51adc6b-e313-4ada-a607-3b0cd408c55b','{\"displayTitle\":\"Mandibule 1.14.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',0,'SYNCED',0,'2023-04-12 06:41:04.000','2021-02-01 21:04:33.000','2023-06-13 12:02:09.662','2023-06-13 14:02:09.662'),('b58b7bd8-eb47-4d54-9228-ce3a9e6486fd',662,'/var/.data/2020/662/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_a18ca6df-d765-4c6a-be28-13abd1c350af/computedocclusion_a18ca6df-d765-4c6a-be28-13amigraoccl/6_w1_o2_snapshot_occ_file_0.png','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_a18ca6df-d765-4c6a-be28-13abd1c350af_OCC_a18ca6df-d765-4c6a-be28-13amigraoccl_SNAPO','6_w1_o2_snapshot_occ_file_0.png','b58b7bd8-eb47-4d54-9228-ce3a9e6486fd','{\"displayTitle\":\"Snapshot 1.6.1.2\",\"title\":\"Snapshot SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-17 11:21:05.000','2023-06-13 12:02:16.213','2023-06-13 14:02:16.213'),('b61e5533-433b-40e2-a91d-c157692b02c0',662,'/var/.data/2021/662/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_0c1ed331-8df6-482e-8dd1-508d9b190c49/occlusion_6c6bb813-840d-454a-ab1d-9232434a4500/scan_019e5bd1-9330-4e70-8035-2fda343b0231/19_w1_o1_maxillaire_snapshot_0.png','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_TOSC_019e5bd1-9330-4e70-8035-2fda343b0231_SNAPS','19_w1_o1_maxillaire_snapshot_0.png','b61e5533-433b-40e2-a91d-c157692b02c0','{\"displayTitle\":\"Maxillaire SNAPSHOT\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-09-27 12:22:21.000','2023-06-13 12:02:12.584','2023-06-13 14:02:12.584'),('b6432038-01b6-4f88-8506-0a2a5906d721',662,'/var/.data/2021/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97/21_w1_o1_mandibule_snapshot_2.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_BOSC_f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97_SNAPS','21_w1_o1_mandibule_snapshot_2.png','5dfbe9b8-c587-4311-b392-743be40fdd10','{\"displayTitle\":\"Mandibule 1.21.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',2,'SYNCED',0,NULL,'2021-11-22 12:38:42.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.058'),('b6b42cf7-31c1-49e1-b1d1-c607c7ba299b',662,'/var/.data/2022/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_8f3d7d42-f6ad-4e48-8951-08222c212e7e/occlusion_5bd97219-8b9e-46f5-ab9b-87ded07aa8a2/scan_b24d4ab4-dba3-4be5-8ba3-7eee381f40ec/21_w4_o1_mordu_anterieur_scan_file_0.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_8f3d7d42-f6ad-4e48-8951-08222c212e7e_SESS_5bd97219-8b9e-46f5-ab9b-87ded07aa8a2_FRSC_b24d4ab4-dba3-4be5-8ba3-7eee381f40ec_MODEL','21_w4_o1_mordu_anterieur_scan_file_0.zip','b6b42cf7-31c1-49e1-b1d1-c607c7ba299b','{\"displayTitle\":\"Mordu anterieur 1.21.4.1.1\",\"modelMatrix\":\"0.851612,-0.0875762,0.519248,0,0.0198226,0.992855,0.0821935,0,-0.523851,-0.0914267,0.851687,0,-1.52728,6.0236,-29.6291,1\",\"title\":\"Mordu anterieur ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-11-04 12:34:44.000','2023-06-13 12:02:14.891','2023-06-13 14:02:14.891'),('b6f09e06-083f-4c19-ae6f-63af10340898',662,'/var/.data/2020/662/d41de280-8cf3-4e57-893e-cc7a010bc864/session_c59a2f65-79fe-44cd-8377-e39aa0a44171/occlusion_daf632b1-2c49-42c8-8899-0a0b2448bc3a/scan_b289ff52-6765-45a7-b1e2-fe7161ba809f/9_w1_o1_maxillaire_scan_file_0.ply','PATIENT_d41de280-8cf3-4e57-893e-cc7a010bc864_ACT_c59a2f65-79fe-44cd-8377-e39aa0a44171_SESS_daf632b1-2c49-42c8-8899-0a0b2448bc3a_TOSC_b289ff52-6765-45a7-b1e2-fe7161ba809f_MODEL','9_w1_o1_maxillaire_scan_file_0.ply','b6f09e06-083f-4c19-ae6f-63af10340898','{\"displayTitle\":\"Maxillaire 1.9.1.1.2\",\"modelMatrix\":\"-0.653538,0.751011,-0.0941833,0,-0.756894,-0.648458,0.0813222,0,-2.55223e-9,0.124434,0.992228,0,-12.3055,-22.9777,-35.5141,1\",\"title\":\"MAXILLAIRE PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-18 09:26:03.000','2023-06-13 12:02:10.535','2023-06-13 14:02:10.535'),('b75b602f-a893-4dd9-8bbf-6b4b00421c4a',662,'/var/.data/2021/662/615ede1a-dba9-4251-9e9e-6cbbd3041fdc/session_76dcd1f0-f6c7-480f-b07b-441679345d70/occlusion_c6fffa68-cc65-471a-a58e-135ebe4d0772/scan_44ccf5f6-834d-4090-88dc-399b19fed47e/15_w1_o1_mordu_anterieur_scan_file_0.ply','PATIENT_615ede1a-dba9-4251-9e9e-6cbbd3041fdc_ACT_76dcd1f0-f6c7-480f-b07b-441679345d70_SESS_c6fffa68-cc65-471a-a58e-135ebe4d0772_FRSC_44ccf5f6-834d-4090-88dc-399b19fed47e_MODEL','15_w1_o1_mordu_anterieur_scan_file_0.ply','b75b602f-a893-4dd9-8bbf-6b4b00421c4a','{\"displayTitle\":\"Mordu anterieur 1.15.1.1.1\",\"modelMatrix\":\"0.799,0.00329587,0.59269,0,0.103938,0.98246,-0.151533,0,-0.592407,0.186535,0.791122,0,9.17633,-7.75173,-25.8679,1\",\"title\":\"Mordu anterieur PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-02-16 13:05:08.000','2023-06-13 12:02:09.809','2023-06-13 14:02:09.809'),('b7e23c05-dca2-450c-8296-062f60712c4b',662,'','PATIENT_f61dd82a-2e03-48b9-8ab4-0840b811de63_ACT_d458682a-423b-43fe-a4b0-97d586104341_SESS_4af4bd2d-76e3-4905-99fd-191c4cc669fa_TOSC_f2b8c151-b863-4411-b17a-b987ca58ee6f_MODEL','4_w1_o1_maxillaire_scan_file_0.ply','b7e23c05-dca2-450c-8296-062f60712c4b','{\"displayTitle\":\"MAXILLAIRE 1.4.1.1.1\",\"modelMatrix\":\"-0.134659,0.929533,-0.34327,0,-0.990892,-0.126321,0.0466494,0,-2.43563e-9,0.346426,0.938077,0,19.7387,-10.2152,-39.8572,1\",\"title\":\"MAXILLAIRE PLY\"}','PLY',0,'SYNCED',0,'2023-04-12 06:41:05.000','2020-04-09 10:56:37.000','2023-06-13 12:02:15.600','2023-06-13 14:02:15.600'),('b9175f0f-b250-4ae3-b56c-51f5a10c10db',662,'/var/.data/2020/662/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/occlusion_b87f1382-55d4-4e52-b63a-6f387df18b16/scan_534cca35-8182-4f61-aa57-03bad8172eac/13_w4_o1_mordu_anterieur_snapshot_0.png','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_SESS_b87f1382-55d4-4e52-b63a-6f387df18b16_FRSC_534cca35-8182-4f61-aa57-03bad8172eac_SNAPS','13_w4_o1_mordu_anterieur_snapshot_0.png','b9175f0f-b250-4ae3-b56c-51f5a10c10db','{\"displayTitle\":\"Mordu anterieur SNAPSHOT\",\"title\":\"Mordu anterieur SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-12-29 11:35:15.000','2023-06-13 12:02:12.140','2023-06-13 14:02:12.140'),('b94c36ee-0e86-44b0-a152-b92997bdab17',662,'/var/.data/2020/662/2b4f07b1-1d58-42a2-9e72-3461efd5a2d9/session_bc967a6b-ad1a-4a59-aab8-92332e4217b0/occlusion_f2e73640-aebd-4bb1-9b02-c0504556ac5a/scan_e7efed59-e33c-4194-94c1-3507350dcfb5/5_w3_o1_maxillaire_snapshot_0.png','PATIENT_2b4f07b1-1d58-42a2-9e72-3461efd5a2d9_ACT_bc967a6b-ad1a-4a59-aab8-92332e4217b0_SESS_f2e73640-aebd-4bb1-9b02-c0504556ac5a_TOSC_e7efed59-e33c-4194-94c1-3507350dcfb5_SNAPS','5_w3_o1_maxillaire_snapshot_0.png','b94c36ee-0e86-44b0-a152-b92997bdab17','{\"displayTitle\":\"Maxillaire 1.5.3.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-07-13 19:18:53.000','2023-04-12 04:40:12.094','2023-04-12 06:40:12.094'),('b9d391dc-72d3-11ec-9377-226cec7cb58a',662,'/var/.data/2022/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/b9d391dc-72d3-11ec-9377-226cec7cb58a.zip','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_TOSC_793e84ce-b088-458d-82f5-33fab1f5e7de_MODEL','23_w1_o1_maxillaire_scan_file_1.zip','b9d391dc-72d3-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Maxillaire 1.23.1.1.1\",\"modelMatrix\":\"-0.991214,-0.131706,0.0122187,0,0.132271,-0.986975,0.091564,0,1.89443e-11,0.0923757,0.995724,0,20.0589,-14.9599,-19.872,1\",\"title\":\"Maxillaire ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-01-11 12:23:20.000','2023-06-13 12:02:22.965','2023-06-13 14:02:22.965'),('b9d5de8c-72d3-11ec-9377-226cec7cb58a',662,'/var/.data/2022/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/b9d5de8c-72d3-11ec-9377-226cec7cb58a.zip','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_LESC_d675acff-ab7f-4d65-b55c-558379a8b3d0_MODEL','23_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','b9d5de8c-72d3-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Mordu posterieur gauche 1.23.1.1.1\",\"modelMatrix\":\"-0.920954,-0.163259,0.356869,0,0.137547,-0.986573,-0.0612914,0,0.364705,-0.0162589,0.932237,0,3.48454,4.97084,-20.3055,1\",\"title\":\"Mordu posterieur gauche ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-01-11 12:39:02.000','2023-06-13 12:02:22.974','2023-06-13 14:02:22.974'),('b9d854a5-72d3-11ec-9377-226cec7cb58a',662,'/var/.data/2022/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/b9d854a5-72d3-11ec-9377-226cec7cb58a.zip','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_BOSC_f0b63e95-26e8-4213-a935-ca2c37ab36ba_MODEL','23_w1_o1_mandibule_scan_file_1.zip','b9d854a5-72d3-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Mandibule 1.23.1.1.1\",\"modelMatrix\":\"-0.841721,0.469057,-0.267377,0,-0.539912,-0.731259,0.41684,0,-1.10031e-8,0.495224,0.868765,0,14.7201,-8.7337,-18.0275,1\",\"title\":\"Mandibule ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-01-11 12:35:42.000','2023-06-13 12:02:22.984','2023-06-13 14:02:22.984'),('b9da69b7-72d3-11ec-9377-226cec7cb58a',662,'/var/.data/2022/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/b9da69b7-72d3-11ec-9377-226cec7cb58a.zip','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_FRSC_5a4f6b62-6381-4a1e-bbef-61746f2722d3_MODEL','23_w1_o1_mordu_anterieur_scan_file_0.zip','b9da69b7-72d3-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Mordu anterieur 1.23.1.1.1\",\"modelMatrix\":\"0.84365,0.210589,0.497423,0,-0.180758,0.976383,-0.0219815,0,-0.506998,-0.0651306,0.867814,0,7.25809,0.136189,-25.0684,1\",\"title\":\"Mordu anterieur ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-01-11 12:41:15.000','2023-06-13 12:02:22.993','2023-06-13 14:02:22.993'),('b9dc2b5e-72d3-11ec-9377-226cec7cb58a',662,'/var/.data/2022/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/b9dc2b5e-72d3-11ec-9377-226cec7cb58a.png','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_RISC_6ce24fb2-7744-476b-a643-7e304d3ac013_SNAPS','23_w1_o1_mordu_posterieur_droit_snapshot_0.png','b9dc2b5e-72d3-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Mordu posterieur droit 1.23.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-01-11 12:37:27.000','2023-06-13 12:02:23.002','2023-06-13 14:02:23.002'),('b9de0e95-72d3-11ec-9377-226cec7cb58a',662,'/var/.data/2022/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/b9de0e95-72d3-11ec-9377-226cec7cb58a.png','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_TOSC_793e84ce-b088-458d-82f5-33fab1f5e7de_SNAPS','23_w1_o1_maxillaire_snapshot_1.png','b9de0e95-72d3-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Maxillaire 1.23.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-01-11 12:23:17.000','2023-06-13 12:02:23.011','2023-06-13 14:02:23.011'),('b9e0e714-72d3-11ec-9377-226cec7cb58a',662,'/var/.data/2022/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/b9e0e714-72d3-11ec-9377-226cec7cb58a.png','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_LESC_d675acff-ab7f-4d65-b55c-558379a8b3d0_SNAPS','23_w1_o1_mordu_posterieur_gauche_snapshot_0.png','b9e0e714-72d3-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Mordu posterieur gauche 1.23.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-01-11 12:39:01.000','2023-06-13 12:02:23.021','2023-06-13 14:02:23.021'),('b9e39911-72d3-11ec-9377-226cec7cb58a',662,'/var/.data/2022/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/b9e39911-72d3-11ec-9377-226cec7cb58a.zip','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_RISC_6ce24fb2-7744-476b-a643-7e304d3ac013_MODEL','23_w1_o1_mordu_posterieur_droit_scan_file_0.zip','b9e39911-72d3-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Mordu posterieur droit 1.23.1.1.1\",\"modelMatrix\":\"0.966505,-0.0822368,0.245802,0,0.0419504,0.990708,0.125232,0,-0.253409,-0.108826,0.961197,0,7.85892,3.99641,-19.3154,1\",\"title\":\"Mordu posterieur droit ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-01-11 12:37:28.000','2023-06-13 12:02:23.028','2023-06-13 14:02:23.028'),('b9e5d1e0-72d3-11ec-9377-226cec7cb58a',662,'/var/.data/2022/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/b9e5d1e0-72d3-11ec-9377-226cec7cb58a.png','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_BOSC_f0b63e95-26e8-4213-a935-ca2c37ab36ba_SNAPS','23_w1_o1_mandibule_snapshot_1.png','b9e5d1e0-72d3-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Mandibule 1.23.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-01-11 12:35:39.000','2023-06-13 12:02:23.038','2023-06-13 14:02:23.038'),('b9e83025-72d3-11ec-9377-226cec7cb58a',662,'/var/.data/2022/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/b9e83025-72d3-11ec-9377-226cec7cb58a.png','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_FRSC_5a4f6b62-6381-4a1e-bbef-61746f2722d3_SNAPS','23_w1_o1_mordu_anterieur_snapshot_0.png','b9e83025-72d3-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Mordu anterieur 1.23.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-01-11 12:41:14.000','2023-06-13 12:02:23.047','2023-06-13 14:02:23.047'),('ba881d4e-efc8-45fe-90c8-248f552f9196',662,'/var/.data/2020/662/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/occlusion_b87f1382-55d4-4e52-b63a-6f387df18b16/scan_534cca35-8182-4f61-aa57-03bad8172eac/13_w4_o1_mordu_anterieur_scan_file_0.ply','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_SESS_b87f1382-55d4-4e52-b63a-6f387df18b16_FRSC_534cca35-8182-4f61-aa57-03bad8172eac_MODEL','13_w4_o1_mordu_anterieur_scan_file_0.ply','ba881d4e-efc8-45fe-90c8-248f552f9196','{\"displayTitle\":\"Mordu anterieur PLY\",\"modelMatrix\":\"0.574059,0.0227079,0.817806,0,0.165534,0.968138,-0.156835,0,-0.8024,0.251034,0.553742,0,15.1214,-11.3775,-31.1289,1\",\"title\":\"Mordu anterieur PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-12-29 11:35:15.000','2023-06-13 12:02:12.123','2023-06-13 14:02:12.123'),('bad6504a-4f54-4dc9-83e3-02475160f717',662,'/var/.data/2023/662/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_586a7c87-5d8a-440f-a654-c452dc908844/occlusion_d70cc224-5e0d-4b47-9270-d8e23a25b566/scan_0e5656e0-946b-41b2-935b-ea820746e5a9/19_w4_o1_maxillaire_snapshot_0.png','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_586a7c87-5d8a-440f-a654-c452dc908844_SESS_d70cc224-5e0d-4b47-9270-d8e23a25b566_TOSC_0e5656e0-946b-41b2-935b-ea820746e5a9_SNAPS','19_w4_o1_maxillaire_snapshot_0.png','bad6504a-4f54-4dc9-83e3-02475160f717','{\"displayTitle\":\"Maxillaire 1.19.4.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2023-03-21 12:21:48.000','2023-04-12 04:40:36.505','2023-04-12 06:40:36.505'),('bafe042a-2298-470c-8d08-071e0f4e388e',662,'/var/.data/2022/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_e43c8099-0862-42c3-9ad2-1efef27b83ba/occlusion_09f15124-6bba-4565-bfe4-efb3c6c3a17d/scan_3a315f7b-8cf2-4d0c-bf92-fecb623fe530/21_w3_o1_maxillaire_scan_file_1.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_e43c8099-0862-42c3-9ad2-1efef27b83ba_SESS_09f15124-6bba-4565-bfe4-efb3c6c3a17d_TOSC_3a315f7b-8cf2-4d0c-bf92-fecb623fe530_MODEL','21_w3_o1_maxillaire_scan_file_1.zip','110bfb15-3589-48ab-bb80-e339d042b64d','{\"displayTitle\":\"Maxillaire 1.21.3.1.1\",\"modelMatrix\":\"0.804251,0.588743,-0.0810022,0,-0.594289,0.796746,-0.10962,0,9.77465e-10,0.136301,0.990668,0,-23.7315,-16.3663,-21.3795,1\",\"title\":\"Maxillaire ZIP\"}','ZIP',1,'SYNCED',0,NULL,'2022-09-14 12:23:55.000','2023-06-13 12:02:13.547','2023-06-13 14:02:13.547'),('bb2755e4-36de-4604-9ee9-d2711661ea1d',662,'/var/.data/2020/662/2b4f07b1-1d58-42a2-9e72-3461efd5a2d9/session_934f20d2-7444-4367-89e2-61c3bf4bee57/occlusion_ada38401-e257-4f32-8319-c7a394ce4463/scan_375f8fb7-d198-4281-9948-bba81b98e824/5_w1_o1_maxillaire_scan_file_0.ply','PATIENT_2b4f07b1-1d58-42a2-9e72-3461efd5a2d9_ACT_934f20d2-7444-4367-89e2-61c3bf4bee57_SESS_ada38401-e257-4f32-8319-c7a394ce4463_TOSC_375f8fb7-d198-4281-9948-bba81b98e824_MODEL','5_w1_o1_maxillaire_scan_file_0.ply','bb2755e4-36de-4604-9ee9-d2711661ea1d','{\"displayTitle\":\"Maxillaire 1.5.1.1.1\",\"modelMatrix\":\"-0.41714,0.872868,-0.253172,0,-0.908842,-0.400629,0.116201,0,-1.83889e-9,0.278565,0.960417,0,12.2781,-19.5045,-13.578,1\",\"title\":\"MAXILLAIRE PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-10 07:44:49.000','2023-06-13 12:02:10.415','2023-06-13 14:02:10.415'),('bc10348b-1c26-48ee-bc8f-6fa5ac933a14',662,'/var/.data/2020/662/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/occlusion_d402edb5-8449-46a8-862f-a1cd1ee21cf6/scan_b7931623-9b21-4440-a950-16565249bf9a/10_w1_o1_mandibule_scan_file_3.ply','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_SESS_d402edb5-8449-46a8-862f-a1cd1ee21cf6_BOSC_b7931623-9b21-4440-a950-16565249bf9a_MODEL','10_w1_o1_mandibule_scan_file_3.ply','6008312e-ba22-4c98-a696-7500991d7069','{\"displayTitle\":\"Mandibule 1.10.1.1.2\",\"modelMatrix\":\"-0.956255,-0.280294,0.0837418,0,0.292536,-0.916237,0.273739,0,-9.38627e-11,0.286261,0.958152,0,18.7257,7.55089,-22.8578,1\",\"title\":\"MANDIBULE PLY\"}','PLY',3,'SYNCED',0,NULL,'2020-04-30 19:57:58.000','2023-06-13 12:02:12.476','2023-06-13 14:02:12.476'),('bcb2c331-8297-48c9-9ba7-66e21108faf8',662,'/var/.data/2022/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_87965ef8-01eb-4830-8e8b-8b99ece62cf1/occlusion_dce9ce0f-0933-4c98-af84-59e2b6395f8f/scan_bd51414b-f96e-4903-a2e2-44fb3189decd/21_w2_o1_mandibule_snapshot_2.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_87965ef8-01eb-4830-8e8b-8b99ece62cf1_SESS_dce9ce0f-0933-4c98-af84-59e2b6395f8f_BOSC_bd51414b-f96e-4903-a2e2-44fb3189decd_SNAPS','21_w2_o1_mandibule_snapshot_2.png','160153e9-3248-4a6b-b0ff-a10c2c1acfc9','{\"displayTitle\":\"Mandibule 1.21.2.1.1\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',2,'SYNCED',0,NULL,'2022-06-27 20:55:59.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.103'),('be04859c-f9ff-4a11-96c0-99dd77c8c98f',662,'/var/.data/2022/662/665b40ce-9690-4944-b007-4a96c1f5d57d/session_8f87b136-cb98-4706-b7d4-51059e1afa06/occlusion_5f895907-3eed-4aa7-995a-f7e1c9661a0a/scan_26a765d3-8b92-4861-984a-bd9c8040209b/25_w1_o1_mandibule_scan_file_0.zip','PATIENT_665b40ce-9690-4944-b007-4a96c1f5d57d_ACT_8f87b136-cb98-4706-b7d4-51059e1afa06_SESS_5f895907-3eed-4aa7-995a-f7e1c9661a0a_BOSC_26a765d3-8b92-4861-984a-bd9c8040209b_MODEL','25_w1_o1_mandibule_scan_file_0.zip','be04859c-f9ff-4a11-96c0-99dd77c8c98f','{\"displayTitle\":\"Mandibule 1.25.1.1.1\",\"modelMatrix\":\"0.159059,0.963402,-0.215769,0,-0.987269,0.155214,-0.0347625,0,2.24982e-09,0.218551,0.975826,0,4.02306,-13.4981,-17.988,1\",\"title\":\"Mandibule ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-03-11 10:27:01.000','2023-06-13 12:02:13.195','2023-06-13 14:02:13.195'),('bfbd4222-08f2-4237-9b3e-e482e6111a20',662,'/var/.data/2020/662/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_a18ca6df-d765-4c6a-be28-13abd1c350af/scan_37ff1278-3dd1-470a-8159-e763f6626f5d/6_w1_o2_mandibule_scan_file_1.ply','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_a18ca6df-d765-4c6a-be28-13abd1c350af_BOSC_37ff1278-3dd1-470a-8159-e763f6626f5d_MODEL','6_w1_o2_mandibule_scan_file_1.ply','83dce64b-81ec-4022-b7e5-8a738bbab39f','{\"displayTitle\":\"Mandibule 1.6.1.2.1\",\"modelMatrix\":\"-0.998147,-0.0551013,0.0258045,0,0.0608443,-0.903934,0.423322,0,6.8637e-10,0.424108,0.905612,0,7.9408,0.976609,-21.7447,1\",\"title\":\"MANDIBULE PLY\"}','PLY',1,'SYNCED',0,NULL,'2020-04-17 11:12:10.000','2023-06-13 12:02:10.246','2023-06-13 14:02:10.246'),('c063b377-02e8-4830-bf3f-414b4e6325ca',662,'/var/.data/2022/662/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_129a6c33-3cca-43ab-b97a-56d0e82a546f/occlusion_b5b4db66-f433-46fb-b794-d632b8fe8e1d/scan_e9aaa539-6e84-47bc-9c50-2c8797de82a4/19_w3_o1_mordu_posterieur_gauche_snapshot_0.png','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_129a6c33-3cca-43ab-b97a-56d0e82a546f_SESS_b5b4db66-f433-46fb-b794-d632b8fe8e1d_LESC_e9aaa539-6e84-47bc-9c50-2c8797de82a4_SNAPS','19_w3_o1_mordu_posterieur_gauche_snapshot_0.png','c063b377-02e8-4830-bf3f-414b4e6325ca','{\"displayTitle\":\"Mordu posterieur gauche 1.19.3.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-11-02 12:34:58.000','2023-06-13 12:02:13.571','2023-06-13 14:02:13.571'),('c0a56411-85d4-412b-84cc-45a71dee710a',662,'','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_72b7a457-e38f-4535-8eba-6c98b43e5e55_SESS_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c_BOSC_34f5d93d-6a1f-4f94-ab20-4105c2cce30a_SNAPS','14_w2_o1_mandibule_snapshot_0.png','c0a56411-85d4-412b-84cc-45a71dee710a','{\"displayTitle\":\"Mandibule 1.14.2.1.1\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',0,'SYNCED',0,'2023-04-12 06:41:08.000','2021-06-08 20:30:59.000','2023-06-13 12:02:12.266','2023-06-13 14:02:12.266'),('c0c1a357-1f5c-443a-ac07-9cc3a45a7853',662,'/var/.data/2020/662/2b4f07b1-1d58-42a2-9e72-3461efd5a2d9/session_bc967a6b-ad1a-4a59-aab8-92332e4217b0/occlusion_f2e73640-aebd-4bb1-9b02-c0504556ac5a/scan_e7efed59-e33c-4194-94c1-3507350dcfb5/5_w3_o1_maxillaire_scan_file_1.ply','PATIENT_2b4f07b1-1d58-42a2-9e72-3461efd5a2d9_ACT_bc967a6b-ad1a-4a59-aab8-92332e4217b0_SESS_f2e73640-aebd-4bb1-9b02-c0504556ac5a_TOSC_e7efed59-e33c-4194-94c1-3507350dcfb5_MODEL','5_w3_o1_maxillaire_scan_file_1.ply','42d780c5-37b5-433e-890f-3c005cb69701','{\"displayTitle\":\"Maxillaire 1.5.3.1.1\",\"modelMatrix\":\"-0.916377,-0.389552,0.092209,0,0.400316,-0.891736,0.211079,0,-7.53626e-10,0.23034,0.97311,0,9.09543,-8.03835,-24.7107,1\",\"title\":\"Maxillaire PLY\"}','PLY',1,'SYNCED',0,NULL,'2020-07-13 19:32:07.000','2023-06-13 12:02:10.441','2023-06-13 14:02:10.441'),('c14c7ae3-1390-4203-93ce-6ba836086c35',662,'/var/.data/2021/662/615ede1a-dba9-4251-9e9e-6cbbd3041fdc/session_76dcd1f0-f6c7-480f-b07b-441679345d70/occlusion_c6fffa68-cc65-471a-a58e-135ebe4d0772/scan_7a39120e-2f79-4c3e-af4d-af72e8ca8062/15_w1_o1_mordu_posterieur_gauche_scan_file_0.ply','PATIENT_615ede1a-dba9-4251-9e9e-6cbbd3041fdc_ACT_76dcd1f0-f6c7-480f-b07b-441679345d70_SESS_c6fffa68-cc65-471a-a58e-135ebe4d0772_LESC_7a39120e-2f79-4c3e-af4d-af72e8ca8062_MODEL','15_w1_o1_mordu_posterieur_gauche_scan_file_0.ply','c14c7ae3-1390-4203-93ce-6ba836086c35','{\"displayTitle\":\"Mordu posterieur gauche 1.15.1.1.1\",\"modelMatrix\":\"-0.869109,0.0327334,0.490122,0,0.187716,-0.888168,0.417206,0,0.457865,0.458605,0.765337,0,-0.754163,-13.2867,-19.8251,1\",\"title\":\"Mordu posterieur gauche PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-02-16 12:57:03.000','2023-06-13 12:02:09.780','2023-06-13 14:02:09.780'),('c19a9e26-b162-4808-8d10-9d6a38e24e98',662,'/var/.data/2021/662/ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07/session_b498bdf4-2e5b-497a-8bfe-b65edabac3bc/occlusion_31210683-bc06-4b84-83d9-ce60f32308e4/scan_c1232582-95fc-48dc-a9ee-826c0cbad106/22_w1_o1_mordu_posterieur_droit_scan_file_0.zip','PATIENT_ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07_ACT_b498bdf4-2e5b-497a-8bfe-b65edabac3bc_SESS_31210683-bc06-4b84-83d9-ce60f32308e4_RISC_c1232582-95fc-48dc-a9ee-826c0cbad106_MODEL','22_w1_o1_mordu_posterieur_droit_scan_file_0.zip','c19a9e26-b162-4808-8d10-9d6a38e24e98','{\"displayTitle\":\"Mordu posterieur droit 1.22.1.1.1\",\"modelMatrix\":\"0.999595,-0.0218982,0.0166849,0,0.0161573,0.944762,0.325391,0,-0.0234339,-0.327034,0.945435,0,10.0522,9.09217,-24.9856,1\",\"title\":\"Mordu posterieur droit ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2021-11-23 12:18:02.000','2023-06-13 12:02:12.991','2023-06-13 14:02:12.991'),('c2475b5d-1f8a-11ec-9377-226cec7cb58a',662,'/var/.data/2021/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/c2475b5d-1f8a-11ec-9377-226cec7cb58a.ply','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_FRSC_ef79558a-21cf-4117-a0b7-ba0adf40f7dc_MODEL','19_w1_o1_mordu_anterieur_scan_file_0.ply','c2475b5d-1f8a-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Mordu anterieur 1.19.1.1.1\",\"modelMatrix\":\"0.84619,0.0571101,0.515766,0,-0.00658361,0.991989,-0.141669,0,-0.533379,0.115223,0.845157,0,-3.68638,-6.26512,-27.8081,1\",\"title\":\"Mordu anterieur PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-09-27 12:49:22.000','2023-06-13 12:02:22.433','2023-06-13 14:02:22.433'),('c24a06b2-1f8a-11ec-9377-226cec7cb58a',662,'/var/.data/2021/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/c24a06b2-1f8a-11ec-9377-226cec7cb58a.png','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_RISC_99a6d55d-de66-49eb-a717-49cb2587fbef_SNAPS','19_w1_o1_mordu_posterieur_droit_snapshot_0.png','c24a06b2-1f8a-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Mordu posterieur droit 1.19.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-09-27 12:45:21.000','2023-06-13 12:02:22.445','2023-06-13 14:02:22.445'),('c24da80c-1f8a-11ec-9377-226cec7cb58a',662,'/var/.data/2021/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/c24da80c-1f8a-11ec-9377-226cec7cb58a.png','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_BOSC_50e1896b-8565-4257-9a61-2a685fff8165_SNAPS','19_w1_o1_mandibule_snapshot_1.png','c24da80c-1f8a-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Mandibule 1.19.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-09-27 12:43:41.000','2023-06-13 12:02:22.462','2023-06-13 14:02:22.462'),('c2503be7-1f8a-11ec-9377-226cec7cb58a',662,'/var/.data/2021/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/c2503be7-1f8a-11ec-9377-226cec7cb58a.ply','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_BOSC_50e1896b-8565-4257-9a61-2a685fff8165_MODEL','19_w1_o1_mandibule_scan_file_1.ply','c2503be7-1f8a-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Mandibule 1.19.1.1.1\",\"modelMatrix\":\"0.258681,-0.958527,0.119627,0,0.965963,0.25669,-0.0320357,0,1.9715e-9,0.123842,0.992302,0,-20.8805,2.28408,-23.0637,1\",\"title\":\"Mandibule PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-09-27 12:43:41.000','2023-06-13 12:02:22.474','2023-06-13 14:02:22.474'),('c25432d6-1f8a-11ec-9377-226cec7cb58a',662,'/var/.data/2021/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/c25432d6-1f8a-11ec-9377-226cec7cb58a.png','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_LESC_d7c4d383-83f9-4275-bbcc-567a47d4a450_SNAPS','19_w1_o1_mordu_posterieur_gauche_snapshot_0.png','c25432d6-1f8a-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Mordu posterieur gauche 1.19.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-09-27 12:46:45.000','2023-06-13 12:02:22.488','2023-06-13 14:02:22.488'),('c2574ae3-1f8a-11ec-9377-226cec7cb58a',662,'/var/.data/2021/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/c2574ae3-1f8a-11ec-9377-226cec7cb58a.ply','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_TOSC_019e5bd1-9330-4e70-8035-2fda343b0231_MODEL','19_w1_o1_maxillaire_scan_file_1.ply','c2574ae3-1f8a-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Maxillaire 1.19.1.1.1\",\"modelMatrix\":\"-0.899911,0.426922,-0.0888736,0,-0.436074,-0.881023,0.183405,0,5.95796e-9,0.203804,0.979012,0,12.9304,-14.3828,-20.7725,1\",\"title\":\"Maxillaire PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-09-27 12:26:06.000','2023-06-13 12:02:22.501','2023-06-13 14:02:22.501'),('c25a1819-1f8a-11ec-9377-226cec7cb58a',662,'/var/.data/2021/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/c25a1819-1f8a-11ec-9377-226cec7cb58a.png','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_FRSC_ef79558a-21cf-4117-a0b7-ba0adf40f7dc_SNAPS','19_w1_o1_mordu_anterieur_snapshot_0.png','c25a1819-1f8a-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Mordu anterieur 1.19.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-09-27 12:49:22.000','2023-06-13 12:02:22.514','2023-06-13 14:02:22.514'),('c25cb650-1f8a-11ec-9377-226cec7cb58a',662,'/var/.data/2021/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/c25cb650-1f8a-11ec-9377-226cec7cb58a.png','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_TOSC_019e5bd1-9330-4e70-8035-2fda343b0231_SNAPS','19_w1_o1_maxillaire_snapshot_1.png','c25cb650-1f8a-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Maxillaire 1.19.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-09-27 12:26:06.000','2023-06-13 12:02:22.525','2023-06-13 14:02:22.525'),('c25f3035-1f8a-11ec-9377-226cec7cb58a',662,'/var/.data/2021/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/c25f3035-1f8a-11ec-9377-226cec7cb58a.ply','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_LESC_d7c4d383-83f9-4275-bbcc-567a47d4a450_MODEL','19_w1_o1_mordu_posterieur_gauche_scan_file_0.ply','c25f3035-1f8a-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Mordu posterieur gauche 1.19.1.1.1\",\"modelMatrix\":\"-0.976818,-0.173343,0.122598,0,0.179187,-0.982871,0.0414572,0,0.117191,0.0625849,0.991598,0,10.7409,1.26499,-20.9619,1\",\"title\":\"Mordu posterieur gauche PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-09-27 12:46:45.000','2023-06-13 12:02:22.532','2023-06-13 14:02:22.532'),('c2617b6f-1f8a-11ec-9377-226cec7cb58a',662,'/var/.data/2021/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/c2617b6f-1f8a-11ec-9377-226cec7cb58a.ply','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_RISC_99a6d55d-de66-49eb-a717-49cb2587fbef_MODEL','19_w1_o1_mordu_posterieur_droit_scan_file_0.ply','c2617b6f-1f8a-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Mordu posterieur droit 1.19.1.1.1\",\"modelMatrix\":\"0.976921,-0.211633,0.0384051,0,0.194578,0.946537,0.256535,0,-0.0881502,-0.243475,0.965774,0,0.602866,9.96784,-20.2879,1\",\"title\":\"Mordu posterieur droit PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-09-27 12:45:21.000','2023-06-13 12:02:22.541','2023-06-13 14:02:22.541'),('c26fa07f-09e1-11ee-b558-229278a3c906',662,'/var/.data/2023/662/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_a62b9800-d910-11ed-b558-229278a3c906/order_a6308d4d-d910-11ed-b558-229278a3c906/c26fa07f-09e1-11ee-b558-229278a3c906.pdf','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_a62b9800-d910-11ed-b558-229278a3c906_PROST_a6308d4d-d910-11ed-b558-229278a3c906_FORM','c26fa07f-09e1-11ee-b558-229278a3c906.pdf','c26fa07f-09e1-11ee-b558-229278a3c906','{\"displayTitle\":\"Commande 1.23.2.1 Gouttière\",\"title\":\"Gouttière\"}','PDF',0,'SYNCED',0,NULL,'2023-06-13 13:59:34.000','2023-06-13 11:59:36.611','2023-06-13 13:59:36.611'),('c444e909-d341-4283-88a4-d2ec58f55e8a',662,'','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_72c58d79-1141-4c63-b343-909886db5520_SESS_8d012545-b857-4595-a69d-1a2b1c750e13_TOSC_527c942e-3aa0-4028-b02a-8b3f137657be_MODEL','2_w4_o1_maxillaire_scan_file_0.ply','c444e909-d341-4283-88a4-d2ec58f55e8a','{\"displayTitle\":\"MAXILLAIRE 1.2.4.1.1\",\"modelMatrix\":\"-0.999956,-0.00913465,0.00222633,0,0.00940205,-0.971517,0.236782,0,-3.94949e-11,0.236792,0.97156,0,-26.8946,-7.79802,-38.0736,1\",\"title\":\"MAXILLAIRE PLY\"}','PLY',0,'SYNCED',0,'2023-04-12 06:41:10.000','2020-04-27 16:19:06.000','2023-06-13 12:02:15.211','2023-06-13 14:02:15.211'),('c44f8f8f-6ba9-4ae3-85ba-cffa8f6b3e13',662,'/var/.data/2022/662/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_949fe730-88fa-4ec2-852e-dd0772ee3ee0/occlusion_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d/scan_1c6adc05-0655-4ad6-bcc9-27b0ef578ded/19_w2_o1_maxillaire_snapshot_1.png','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_949fe730-88fa-4ec2-852e-dd0772ee3ee0_SESS_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d_TOSC_1c6adc05-0655-4ad6-bcc9-27b0ef578ded_SNAPS','19_w2_o1_maxillaire_snapshot_1.png','d40f4bba-69b0-4cc6-b541-e69c16b2b3d5','{\"displayTitle\":\"Maxillaire 1.19.2.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2022-06-28 20:24:10.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.045'),('c7871ca0-e84a-4880-b74b-ef641334860e',662,'/var/.data/2020/662/5cd08749-129b-49e3-85b9-abee157177a4/session_f60bef39-641f-45a5-835c-4e84590668e4/occlusion_bb711dc3-11c1-44a8-96df-a5fb875eade5/scan_eece5ace-2081-4f39-859f-68495bd82499/13_w3_o1_maxillaire_scan_file_0.ply','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_f60bef39-641f-45a5-835c-4e84590668e4_SESS_bb711dc3-11c1-44a8-96df-a5fb875eade5_TOSC_eece5ace-2081-4f39-859f-68495bd82499_MODEL','13_w3_o1_maxillaire_scan_file_0.ply','c7871ca0-e84a-4880-b74b-ef641334860e','{\"displayTitle\":\"Maxillaire 1.13.3.1.1\",\"modelMatrix\":\"0.677729,0.733645,-0.0494808,0,-0.735312,0.676193,-0.0456059,0,1.00789e-9,0.0672922,0.997733,0,-3.21678,29.3121,-17.9244,1\",\"title\":\"Maxillaire PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-12-29 08:48:30.000','2023-06-13 12:02:10.631','2023-06-13 14:02:10.631'),('c8503263-9efa-47b8-8764-2bb09be6a1cb',662,'/var/.data/2021/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97/21_w1_o1_mandibule_scan_file_3.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_BOSC_f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97_MODEL','21_w1_o1_mandibule_scan_file_3.zip','3aa92b1f-240d-45e1-a722-e8da98368f3a','{\"displayTitle\":\"Mandibule 1.21.1.1.1\",\"modelMatrix\":\"-0.991383,-0.127699,0.029203,0,0.130996,-0.966434,0.22101,0,-2.82267e-9,0.222931,0.974834,0,20.0716,9.99111,-20.7432,1\",\"title\":\"Mandibule ZIP\"}','ZIP',3,'SYNCED',0,NULL,'2021-11-22 12:41:06.000','2023-06-13 12:02:12.928','2023-06-13 14:02:12.928'),('c9051630-ef52-45e0-bf72-eef2676192c8',662,'/var/.data/2022/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_8f3d7d42-f6ad-4e48-8951-08222c212e7e/occlusion_5bd97219-8b9e-46f5-ab9b-87ded07aa8a2/scan_2a466f6b-3960-4b1b-bb27-def76229cccc/21_w4_o1_mandibule_snapshot_1.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_8f3d7d42-f6ad-4e48-8951-08222c212e7e_SESS_5bd97219-8b9e-46f5-ab9b-87ded07aa8a2_BOSC_2a466f6b-3960-4b1b-bb27-def76229cccc_SNAPS','21_w4_o1_mandibule_snapshot_1.png','0cbb67d8-7a5d-43de-a85a-8ad3ddf2e2cb','{\"displayTitle\":\"Mandibule 1.21.4.1.1\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2022-11-04 12:31:49.000','2023-06-13 12:02:14.928','2023-06-13 14:02:14.928'),('c96624b7-bb0a-400c-b02e-bdfd89bdac9e',662,'/var/.data/2020/662/d41de280-8cf3-4e57-893e-cc7a010bc864/session_c59a2f65-79fe-44cd-8377-e39aa0a44171/occlusion_daf632b1-2c49-42c8-8899-0a0b2448bc3a/scan_b289ff52-6765-45a7-b1e2-fe7161ba809f/9_w1_o1_maxillaire_snapshot_0.png','PATIENT_d41de280-8cf3-4e57-893e-cc7a010bc864_ACT_c59a2f65-79fe-44cd-8377-e39aa0a44171_SESS_daf632b1-2c49-42c8-8899-0a0b2448bc3a_TOSC_b289ff52-6765-45a7-b1e2-fe7161ba809f_SNAPS','9_w1_o1_maxillaire_snapshot_0.png','c96624b7-bb0a-400c-b02e-bdfd89bdac9e','{\"displayTitle\":\"Maxillaire 1.9.1.1.2\",\"title\":\"MAXILLAIRE SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-18 09:26:03.000','2023-06-13 12:02:10.544','2023-06-13 14:02:10.544'),('ca0a9826-3f91-4aaf-984b-889d4cff43a5',662,'/var/.data/2021/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_9716867f-e0a3-478a-a498-1e84ae803044/21_w1_o1_mordu_posterieur_gauche_snapshot_0.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_LESC_9716867f-e0a3-478a-a498-1e84ae803044_SNAPS','21_w1_o1_mordu_posterieur_gauche_snapshot_0.png','ca0a9826-3f91-4aaf-984b-889d4cff43a5','{\"displayTitle\":\"Mordu posterieur gauche 1.21.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-11-22 12:45:44.000','2023-06-13 12:02:12.876','2023-06-13 14:02:12.876'),('ca42217b-f484-48a1-bff2-3b72dc4f7f2f',662,'/var/.data/2021/662/03ec19f1-9f11-4710-a0cd-c5d7739e40d7/session_f474819e-9470-4612-8275-2ceb25b5522f/occlusion_484ae4d8-329f-49b5-8d83-312a8a92ff22/scan_f766f1dd-53ad-45fc-8f7b-a61d47dfe500/16_w1_o1_mordu_posterieur_gauche_snapshot_0.png','PATIENT_03ec19f1-9f11-4710-a0cd-c5d7739e40d7_ACT_f474819e-9470-4612-8275-2ceb25b5522f_SESS_484ae4d8-329f-49b5-8d83-312a8a92ff22_LESC_f766f1dd-53ad-45fc-8f7b-a61d47dfe500_SNAPS','16_w1_o1_mordu_posterieur_gauche_snapshot_0.png','ca42217b-f484-48a1-bff2-3b72dc4f7f2f','{\"displayTitle\":\"Mordu posterieur gauche 1.16.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-02-27 10:52:46.000','2023-06-13 12:02:09.892','2023-06-13 14:02:09.892'),('ca78a19d-bcad-4ceb-b844-f2badf2ebc09',662,'/var/.data/2021/662/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_643b3b5a-e991-4dbf-95c8-2fd609f83a8b/14_w1_o1_maxillaire_scan_file_1.ply','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_TOSC_643b3b5a-e991-4dbf-95c8-2fd609f83a8b_MODEL','14_w1_o1_maxillaire_scan_file_1.ply','e720e2f6-8dce-43f4-a5d6-bf8c09037947','{\"displayTitle\":\"Maxillaire 1.14.1.1.1\",\"modelMatrix\":\"-0.999973,-0.0069625,0.00254487,0,0.00741301,-0.939201,0.343289,0,-1.7763e-10,0.343298,0.939226,0,5.24999,-21.177,-20.3298,1\",\"title\":\"Maxillaire PLY\"}','PLY',1,'SYNCED',0,NULL,'2021-02-01 20:28:14.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.063'),('cb85cf03-baff-4dcf-bc65-cf1a9c7b9e84',662,'/var/.data/2021/662/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_643b3b5a-e991-4dbf-95c8-2fd609f83a8b/14_w1_o1_maxillaire_snapshot_4.png','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_TOSC_643b3b5a-e991-4dbf-95c8-2fd609f83a8b_SNAPS','14_w1_o1_maxillaire_snapshot_4.png','3d7bd9ef-9d44-4365-af74-4d2a31f8f2fb','{\"displayTitle\":\"Maxillaire 1.14.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',4,'SYNCED',0,NULL,'2021-02-01 20:46:11.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.098'),('cc3c0e89-9cd8-4432-9607-044314bb9633',662,'/var/.data/2020/662/1af643c4-44fe-4ccb-b545-dbc90b47633b/session_a6ab7edf-6040-4f1a-b898-a1120a854927/occlusion_e06b73d5-45f7-4906-ba73-560d66ac56af/scan_cd4cde89-86e9-4257-92b6-869e9aa8d1f6/7_w4_o1_mordu_anterieur_snapshot_0.png','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_a6ab7edf-6040-4f1a-b898-a1120a854927_SESS_e06b73d5-45f7-4906-ba73-560d66ac56af_FRSC_cd4cde89-86e9-4257-92b6-869e9aa8d1f6_SNAPS','7_w4_o1_mordu_anterieur_snapshot_0.png','cc3c0e89-9cd8-4432-9607-044314bb9633','{\"displayTitle\":\"Mordu anterieur 1.7.4.1.1\",\"title\":\"MORDU_ANTERIEUR SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-16 11:35:43.000','2023-06-13 12:02:10.110','2023-06-13 14:02:10.110'),('cce7b291-ae52-44af-bd7e-fe49b16c09c7',662,'/var/.data/2020/662/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_a18ca6df-d765-4c6a-be28-13abd1c350af/scan_65315958-b964-4f7e-a111-9c7695d8092b/6_w1_o2_mordu_posterieur_droit_scan_file_0.ply','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_a18ca6df-d765-4c6a-be28-13abd1c350af_RISC_65315958-b964-4f7e-a111-9c7695d8092b_MODEL','6_w1_o2_mordu_posterieur_droit_scan_file_0.ply','cce7b291-ae52-44af-bd7e-fe49b16c09c7','{\"displayTitle\":\"Mordu posterieur droit 1.6.1.2.1\",\"modelMatrix\":\"0.907571,-0.0262625,0.416813,0,-0.0451124,0.987321,0.148865,0,-0.417488,-0.156638,0.896735,0,1.58524,4.50253,-20.5933,1\",\"title\":\"MORDU_POSTERIEUR_DROIT PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-17 11:14:14.000','2023-06-13 12:02:10.329','2023-06-13 14:02:10.329'),('ce7041b4-86ce-4167-b150-b49d4f0008a6',662,'/var/.data/2022/662/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_7841125a-11dd-4b66-9179-cd371ea2f0f7/occlusion_12115366-8eb9-470b-a097-5d28bb5fdf38/scan_6ce24fb2-7744-476b-a643-7e304d3ac013/23_w1_o1_mordu_posterieur_droit_scan_file_0.zip','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_RISC_6ce24fb2-7744-476b-a643-7e304d3ac013_MODEL','23_w1_o1_mordu_posterieur_droit_scan_file_0.zip','ce7041b4-86ce-4167-b150-b49d4f0008a6','{\"displayTitle\":\"Mordu posterieur droit 1.23.1.1.1\",\"modelMatrix\":\"0.966505,-0.0822368,0.245802,0,0.0419504,0.990708,0.125232,0,-0.253409,-0.108826,0.961197,0,7.85892,3.99641,-19.3154,1\",\"title\":\"Mordu posterieur droit ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-01-11 12:37:28.000','2023-06-13 12:02:13.125','2023-06-13 14:02:13.125'),('cf189c0a-4444-4e39-9766-e4e47582f98c',662,'/var/.data/2020/662/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_bdf42f40-5a7a-435b-a5e0-eb33efefbc97/scan_2bf301a3-b61c-4ddd-b6a2-4924c804d5f8/6_w1_o1_mordu_posterieur_gauche_snapshot_0.png','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_bdf42f40-5a7a-435b-a5e0-eb33efefbc97_LESC_2bf301a3-b61c-4ddd-b6a2-4924c804d5f8_SNAPS','6_w1_o1_mordu_posterieur_gauche_snapshot_0.png','cf189c0a-4444-4e39-9766-e4e47582f98c','{\"displayTitle\":\"Mordu posterieur gauche 1.6.1.1.3\",\"title\":\"MORDU_POSTERIEUR_GAUCHE SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-10 11:51:26.000','2023-06-13 12:02:10.152','2023-06-13 14:02:10.152'),('cfce77ff-b3ac-4f31-ba2d-7ffffd711fef',662,'/var/.data/2020/662/5cd08749-129b-49e3-85b9-abee157177a4/session_f60bef39-641f-45a5-835c-4e84590668e4/occlusion_bb711dc3-11c1-44a8-96df-a5fb875eade5/scan_eece5ace-2081-4f39-859f-68495bd82499/13_w3_o1_maxillaire_snapshot_0.png','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_f60bef39-641f-45a5-835c-4e84590668e4_SESS_bb711dc3-11c1-44a8-96df-a5fb875eade5_TOSC_eece5ace-2081-4f39-859f-68495bd82499_SNAPS','13_w3_o1_maxillaire_snapshot_0.png','cfce77ff-b3ac-4f31-ba2d-7ffffd711fef','{\"displayTitle\":\"Maxillaire 1.13.3.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-12-29 08:48:30.000','2023-06-13 12:02:10.640','2023-06-13 14:02:10.640'),('d0155fb7-667e-4f4e-be6a-1eacb81ecb13',662,'/var/.data/2021/662/615ede1a-dba9-4251-9e9e-6cbbd3041fdc/session_76dcd1f0-f6c7-480f-b07b-441679345d70/occlusion_c6fffa68-cc65-471a-a58e-135ebe4d0772/scan_e6e5d8c5-2d8c-48d0-9708-e3256202d385/15_w1_o1_mandibule_snapshot_0.png','PATIENT_615ede1a-dba9-4251-9e9e-6cbbd3041fdc_ACT_76dcd1f0-f6c7-480f-b07b-441679345d70_SESS_c6fffa68-cc65-471a-a58e-135ebe4d0772_BOSC_e6e5d8c5-2d8c-48d0-9708-e3256202d385_SNAPS','15_w1_o1_mandibule_snapshot_0.png','d0155fb7-667e-4f4e-be6a-1eacb81ecb13','{\"displayTitle\":\"Mandibule 1.15.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-02-16 12:40:32.000','2023-06-13 12:02:09.721','2023-06-13 14:02:09.721'),('d1e9dead-d755-4b41-9105-4b6355694989',662,'/var/.data/2021/662/f15cb858-4f0b-44ec-a017-5e662039ba19/session_72b7a457-e38f-4535-8eba-6c98b43e5e55/occlusion_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c/scan_18365744-4019-43e1-933f-9fa52db1a30d/14_w2_o1_mordu_anterieur_snapshot_0.png','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_72b7a457-e38f-4535-8eba-6c98b43e5e55_SESS_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c_FRSC_18365744-4019-43e1-933f-9fa52db1a30d_SNAPS','14_w2_o1_mordu_anterieur_snapshot_0.png','d1e9dead-d755-4b41-9105-4b6355694989','{\"displayTitle\":\"Mordu anterieur 1.14.2.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-06-08 20:56:53.000','2023-06-13 12:02:12.360','2023-06-13 14:02:12.360'),('d2a7b476-1ed0-4870-8219-9863d50e401c',662,'/var/.data/2023/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_2c78d514-95bd-4529-b0a1-babfb83849b1/occlusion_983c39b6-656b-4bf2-bf43-da1625adb861/scan_209f3c55-7380-4efa-8e6c-dfe8c99792a6/21_w7_o1_mandibule_scan_file_4.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_2c78d514-95bd-4529-b0a1-babfb83849b1_SESS_983c39b6-656b-4bf2-bf43-da1625adb861_BOSC_209f3c55-7380-4efa-8e6c-dfe8c99792a6_MODEL','21_w7_o1_mandibule_scan_file_4.zip','097b9793-f270-498e-9cfe-cf6bc2963744','{\"displayTitle\":\"Mandibule 1.21.7.1.1\",\"modelMatrix\":\"0.982862,0.182458,-0.0262986,0,-0.184344,0.972809,-0.140216,0,-3.46081e-09,0.142661,0.989772,0,-21.336,-16.0061,-21.4679,1\",\"title\":\"Mandibule ZIP\"}','ZIP',4,'SYNCED',0,NULL,'2023-01-11 12:52:39.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.044'),('d2cb8acf-0a31-40f9-932c-a089f44c1a4b',662,'/var/.data/2023/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_2c78d514-95bd-4529-b0a1-babfb83849b1/occlusion_983c39b6-656b-4bf2-bf43-da1625adb861/scan_209f3c55-7380-4efa-8e6c-dfe8c99792a6/21_w7_o1_mandibule_scan_file_2.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_2c78d514-95bd-4529-b0a1-babfb83849b1_SESS_983c39b6-656b-4bf2-bf43-da1625adb861_BOSC_209f3c55-7380-4efa-8e6c-dfe8c99792a6_MODEL','21_w7_o1_mandibule_scan_file_2.zip','097b9793-f270-498e-9cfe-cf6bc2963744','{\"displayTitle\":\"Mandibule 1.21.7.1.1\",\"modelMatrix\":\"0.996915,-0.0774397,0.0127846,0,0.0784879,0.983601,-0.162383,0,-5.56742e-10,0.162886,0.986645,0,-24.0989,-9.70303,-22.4041,1\",\"title\":\"Mandibule ZIP\"}','ZIP',2,'SYNCED',0,NULL,'2023-01-11 12:34:06.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.044'),('d2ffe250-09d3-47fd-af00-7d6cc98742d8',662,'/var/.data/2022/662/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_7841125a-11dd-4b66-9179-cd371ea2f0f7/occlusion_12115366-8eb9-470b-a097-5d28bb5fdf38/scan_f0b63e95-26e8-4213-a935-ca2c37ab36ba/23_w1_o1_mandibule_scan_file_0.zip','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_BOSC_f0b63e95-26e8-4213-a935-ca2c37ab36ba_MODEL','23_w1_o1_mandibule_scan_file_0.zip','d2ffe250-09d3-47fd-af00-7d6cc98742d8','{\"displayTitle\":\"Mandibule 1.23.1.1.1\",\"modelMatrix\":\"-0.909786,0.3568,-0.212092,0,-0.415077,-0.78205,0.464874,0,-7.94157e-9,0.510971,0.859598,0,13.5709,-9.02815,-18.5425,1\",\"title\":\"Mandibule ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-01-11 12:31:11.000','2023-06-13 12:02:13.079','2023-06-13 14:02:13.079'),('d3e47b22-64d4-4936-a2f6-a2a11b01fdf2',662,'/var/.data/2021/662/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_ccd3f4f6-f303-4b20-b967-d41121f2e36b/14_w1_o1_mordu_anterieur_scan_file_0.ply','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_FRSC_ccd3f4f6-f303-4b20-b967-d41121f2e36b_MODEL','14_w1_o1_mordu_anterieur_scan_file_0.ply','d3e47b22-64d4-4936-a2f6-a2a11b01fdf2','{\"displayTitle\":\"Mordu anterieur 1.14.1.1.1\",\"modelMatrix\":\"0.800279,0.121062,0.587925,0,0.017273,0.972761,-0.210082,0,-0.599407,0.199022,0.78148,0,1.77421,-7.79839,-28.7594,1\",\"title\":\"Mordu anterieur PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-02-01 21:22:33.000','2023-06-13 12:02:09.651','2023-06-13 14:02:09.651'),('d40f4bba-69b0-4cc6-b541-e69c16b2b3d5',662,'/var/.data/2022/662/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_949fe730-88fa-4ec2-852e-dd0772ee3ee0/occlusion_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d/scan_1c6adc05-0655-4ad6-bcc9-27b0ef578ded/19_w2_o1_maxillaire_snapshot_0.png','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_949fe730-88fa-4ec2-852e-dd0772ee3ee0_SESS_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d_TOSC_1c6adc05-0655-4ad6-bcc9-27b0ef578ded_SNAPS','19_w2_o1_maxillaire_snapshot_0.png','d40f4bba-69b0-4cc6-b541-e69c16b2b3d5','{\"displayTitle\":\"Maxillaire 1.19.2.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-06-28 20:20:22.000','2023-06-13 12:02:13.387','2023-06-13 14:02:13.387'),('d455a946-5407-4abb-8fdb-711fb0adfe7c',662,'/var/.data/2021/662/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_0c1ed331-8df6-482e-8dd1-508d9b190c49/occlusion_6c6bb813-840d-454a-ab1d-9232434a4500/scan_50e1896b-8565-4257-9a61-2a685fff8165/19_w1_o1_mandibule_snapshot_0.png','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_BOSC_50e1896b-8565-4257-9a61-2a685fff8165_SNAPS','19_w1_o1_mandibule_snapshot_0.png','d455a946-5407-4abb-8fdb-711fb0adfe7c','{\"displayTitle\":\"Mandibule SNAPSHOT\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-09-27 12:37:45.000','2023-06-13 12:02:12.608','2023-06-13 14:02:12.608'),('d47ef10b-7c9f-4fd9-8617-329e21bbfa35',662,'/var/.data/2020/662/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/occlusion_b87f1382-55d4-4e52-b63a-6f387df18b16/scan_876f775b-e8a0-4b7f-bea0-0c93a7041d17/13_w4_o1_mordu_posterieur_gauche_scan_file_0.ply','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_SESS_b87f1382-55d4-4e52-b63a-6f387df18b16_LESC_876f775b-e8a0-4b7f-bea0-0c93a7041d17_MODEL','13_w4_o1_mordu_posterieur_gauche_scan_file_0.ply','d47ef10b-7c9f-4fd9-8617-329e21bbfa35','{\"displayTitle\":\"Mordu posterieur gauche 1.13.4.1.1\",\"modelMatrix\":\"-0.989849,0.00288431,0.139374,0,0.0124051,-0.999231,0.0385922,0,0.141934,0.0402796,0.989493,0,1.43521,3.27328,-19.9916,1\",\"title\":\"Mordu posterieur gauche PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-12-29 11:33:10.000','2023-06-13 12:02:10.522','2023-06-13 14:02:10.522'),('d5ddb4c9-b9d4-4dbd-91ab-8ba108c565e0',662,'/var/.data/2022/662/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_7841125a-11dd-4b66-9179-cd371ea2f0f7/occlusion_12115366-8eb9-470b-a097-5d28bb5fdf38/scan_f0b63e95-26e8-4213-a935-ca2c37ab36ba/23_w1_o1_mandibule_snapshot_1.png','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_BOSC_f0b63e95-26e8-4213-a935-ca2c37ab36ba_SNAPS','23_w1_o1_mandibule_snapshot_1.png','1f154183-a975-4dfa-b4eb-fea963eb0d6c','{\"displayTitle\":\"Mandibule 1.23.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2022-01-11 12:35:39.000','2023-06-13 12:02:13.105','2023-06-13 14:02:13.105'),('d5df3022-2abe-4d54-a53d-63cb7ad80b02',662,'/var/.data/2021/662/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_0c1ed331-8df6-482e-8dd1-508d9b190c49/occlusion_6c6bb813-840d-454a-ab1d-9232434a4500/scan_019e5bd1-9330-4e70-8035-2fda343b0231/19_w1_o1_maxillaire_snapshot_1.png','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_TOSC_019e5bd1-9330-4e70-8035-2fda343b0231_SNAPS','19_w1_o1_maxillaire_snapshot_1.png','b61e5533-433b-40e2-a91d-c157692b02c0','{\"displayTitle\":\"Maxillaire 1.19.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2021-09-27 12:26:06.000','2023-06-13 12:02:12.596','2023-06-13 14:02:12.596'),('d7178627-cef8-4d56-87be-5ce753175b9f',662,'/var/.data/2021/662/615ede1a-dba9-4251-9e9e-6cbbd3041fdc/session_76dcd1f0-f6c7-480f-b07b-441679345d70/occlusion_c6fffa68-cc65-471a-a58e-135ebe4d0772/scan_c99bbff9-5630-49d7-9300-4dabfa5e74c8/15_w1_o1_mordu_posterieur_droit_scan_file_0.ply','PATIENT_615ede1a-dba9-4251-9e9e-6cbbd3041fdc_ACT_76dcd1f0-f6c7-480f-b07b-441679345d70_SESS_c6fffa68-cc65-471a-a58e-135ebe4d0772_RISC_c99bbff9-5630-49d7-9300-4dabfa5e74c8_MODEL','15_w1_o1_mordu_posterieur_droit_scan_file_0.ply','d7178627-cef8-4d56-87be-5ce753175b9f','{\"displayTitle\":\"Mordu posterieur droit 1.15.1.1.1\",\"modelMatrix\":\"0.987337,-0.119112,0.109788,0,0.0884693,0.965911,0.235065,0,-0.131706,-0.229995,0.965796,0,7.31577,5.21565,-24.3729,1\",\"title\":\"Mordu posterieur droit PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-02-16 12:53:05.000','2023-06-13 12:02:09.751','2023-06-13 14:02:09.751'),('d7875c8c-cb63-4940-9761-68ef1c238665',662,'/var/.data/2020/662/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/occlusion_b87f1382-55d4-4e52-b63a-6f387df18b16/scan_4a2eec76-a5f3-44f0-b389-4734998fa2d3/13_w4_o1_mandibule_snapshot_2.png','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_SESS_b87f1382-55d4-4e52-b63a-6f387df18b16_BOSC_4a2eec76-a5f3-44f0-b389-4734998fa2d3_SNAPS','13_w4_o1_mandibule_snapshot_2.png','e8f06fb1-375a-41c0-9a27-d0ee2593900c','{\"displayTitle\":\"Mandibule 1.13.4.1.1\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',2,'SYNCED',0,NULL,'2020-12-29 11:28:31.000','2023-06-13 12:02:12.197','2023-06-13 14:02:12.197'),('d82bb8e8-709c-4148-9290-d8b05ce3f7e6',662,'/var/.data/2022/662/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_129a6c33-3cca-43ab-b97a-56d0e82a546f/occlusion_b5b4db66-f433-46fb-b794-d632b8fe8e1d/scan_99102b35-9ad0-4017-b70e-fa08e5c36102/19_w3_o1_mordu_posterieur_droit_scan_file_0.zip','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_129a6c33-3cca-43ab-b97a-56d0e82a546f_SESS_b5b4db66-f433-46fb-b794-d632b8fe8e1d_RISC_99102b35-9ad0-4017-b70e-fa08e5c36102_MODEL','19_w3_o1_mordu_posterieur_droit_scan_file_0.zip','d82bb8e8-709c-4148-9290-d8b05ce3f7e6','{\"displayTitle\":\"Mordu posterieur droit 1.19.3.1.1\",\"modelMatrix\":\"0.990577,0.063814,0.120048,0,-0.0634761,0.997187,-0.0428834,0,-0.121464,0.0398795,0.991852,0,-6.34989,1.53472,-18.1401,1\",\"title\":\"Mordu posterieur droit ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-11-02 12:34:10.000','2023-06-13 12:02:13.613','2023-06-13 14:02:13.613'),('dab48b34-de4a-4877-be2f-a21e13908dff',662,'/var/.data/2023/662/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_586a7c87-5d8a-440f-a654-c452dc908844/occlusion_d70cc224-5e0d-4b47-9270-d8e23a25b566/scan_0e5656e0-946b-41b2-935b-ea820746e5a9/19_w4_o1_maxillaire_scan_file_0.zip','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_586a7c87-5d8a-440f-a654-c452dc908844_SESS_d70cc224-5e0d-4b47-9270-d8e23a25b566_TOSC_0e5656e0-946b-41b2-935b-ea820746e5a9_MODEL','19_w4_o1_maxillaire_scan_file_0.zip','dab48b34-de4a-4877-be2f-a21e13908dff','{\"displayTitle\":\"Maxillaire 1.19.4.1.1\",\"modelMatrix\":\"-0.621447,0.718186,-0.31307,0,-0.783456,-0.569674,0.248331,0,-8.99901e-09,0.399601,0.916689,0,10.6751,-34.2765,-17.4579,1\",\"title\":\"Maxillaire ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2023-03-21 12:21:50.000','2023-04-12 04:41:02.411','2023-04-12 06:41:02.411'),('dc68fc0d-d914-11ed-b558-229278a3c906',662,'/var/.data/2023/662/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_a62b9800-d910-11ed-b558-229278a3c906/occlusion_a62ebb05-d910-11ed-b558-229278a3c906/scan_993cf4b8-d914-11ed-b558-229278a3c906/dc68fc0d-d914-11ed-b558-229278a3c906.zip','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_a62b9800-d910-11ed-b558-229278a3c906_SESS_a62ebb05-d910-11ed-b558-229278a3c906_LESC_993cf4b8-d914-11ed-b558-229278a3c906_MODEL','dc68fc0d-d914-11ed-b558-229278a3c906.zip','dc68fc0d-d914-11ed-b558-229278a3c906','{\"displayTitle\":\"Mordu gauche 1.23.2.1.1\",\"modelMatrix\":\"-0.987549,-0.135082,-0.0822573,0,0.135718,-0.990541,-0.00556661,0,-0.0795673,-0.0257998,0.996638,0,-3.26982,-0.409935,-25.2165,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-06-13 13:47:35.000','2023-06-13 11:59:36.628','2023-06-13 13:59:36.628'),('dc690efd-d914-11ed-b558-229278a3c906',662,'/var/.data/2023/662/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_a62b9800-d910-11ed-b558-229278a3c906/occlusion_a62ebb05-d910-11ed-b558-229278a3c906/scan_993cf4b8-d914-11ed-b558-229278a3c906/dc690efd-d914-11ed-b558-229278a3c906.png','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_a62b9800-d910-11ed-b558-229278a3c906_SESS_a62ebb05-d910-11ed-b558-229278a3c906_LESC_993cf4b8-d914-11ed-b558-229278a3c906_SNAPS','dc690efd-d914-11ed-b558-229278a3c906.png','dc690efd-d914-11ed-b558-229278a3c906','{\"displayTitle\":\"Mordu gauche 1.23.2.1.1 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-06-13 13:47:35.000','2023-06-13 11:59:36.645','2023-06-13 13:59:36.645'),('dc97d683-1aa5-4aba-bf5c-a43b36478d90',662,'/var/.data/2022/662/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_129a6c33-3cca-43ab-b97a-56d0e82a546f/occlusion_b5b4db66-f433-46fb-b794-d632b8fe8e1d/scan_5a59f382-4b59-4867-8640-021d20bdcd59/19_w3_o1_mordu_anterieur_scan_file_0.zip','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_129a6c33-3cca-43ab-b97a-56d0e82a546f_SESS_b5b4db66-f433-46fb-b794-d632b8fe8e1d_FRSC_5a59f382-4b59-4867-8640-021d20bdcd59_MODEL','19_w3_o1_mordu_anterieur_scan_file_0.zip','dc97d683-1aa5-4aba-bf5c-a43b36478d90','{\"displayTitle\":\"Mordu anterieur 1.19.3.1.1\",\"modelMatrix\":\"0.78556,0.0689669,0.617195,0,-0.0519632,0.992749,0.0772647,0,-0.622253,-0.130203,0.783238,0,16.0725,3.3683,-20.068,1\",\"title\":\"Mordu anterieur ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-11-02 12:36:21.000','2023-06-13 12:02:13.593','2023-06-13 14:02:13.593'),('dd19221a-2e2b-4f03-9062-62bb291352d2',662,'/var/.data/2022/662/3d722760-3820-40e4-81e1-60e722c0cb01/session_1b1f827a-e4fa-4f16-8fd1-8cbdaa85c91e/occlusion_20b31e3a-565c-49b0-b2ff-0dae86b25c76/scan_3e1d8e57-feae-45d6-80f0-9d0be041ff7a/28_w1_o1_maxillaire_snapshot_0.png','PATIENT_3d722760-3820-40e4-81e1-60e722c0cb01_ACT_1b1f827a-e4fa-4f16-8fd1-8cbdaa85c91e_SESS_20b31e3a-565c-49b0-b2ff-0dae86b25c76_TOSC_3e1d8e57-feae-45d6-80f0-9d0be041ff7a_SNAPS','28_w1_o1_maxillaire_snapshot_0.png','dd19221a-2e2b-4f03-9062-62bb291352d2','{\"displayTitle\":\"Maxillaire 1.28.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-09-19 11:48:30.000','2023-04-12 04:41:30.614','2023-04-12 06:41:30.614'),('dd1d9407-c7db-11ed-9ced-0050569a5229',662,'/var/.data/2023/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/dd1d9407-c7db-11ed-9ced-0050569a5229.png','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_586a7c87-5d8a-440f-a654-c452dc908844_SESS_d70cc224-5e0d-4b47-9270-d8e23a25b566_TOSC_0e5656e0-946b-41b2-935b-ea820746e5a9_SNAPS','19_w4_o1_maxillaire_snapshot_1.png','dd1d9407-c7db-11ed-9ced-0050569a5229','{\"displayTitle\":\"Maxillaire 1.19.4.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2023-03-21 12:27:26.000','2023-04-12 04:41:15.558','2023-04-12 06:41:15.558'),('dd202b6b-c7db-11ed-9ced-0050569a5229',662,'/var/.data/2023/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/dd202b6b-c7db-11ed-9ced-0050569a5229.zip','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_586a7c87-5d8a-440f-a654-c452dc908844_SESS_d70cc224-5e0d-4b47-9270-d8e23a25b566_TOSC_0e5656e0-946b-41b2-935b-ea820746e5a9_MODEL','19_w4_o1_maxillaire_scan_file_1.zip','dd202b6b-c7db-11ed-9ced-0050569a5229','{\"displayTitle\":\"Maxillaire 1.19.4.1.1\",\"modelMatrix\":\"-0.635437,0.697716,-0.330774,0,-0.772152,-0.57418,0.272209,0,5.70047e-10,0.42838,0.903599,0,7.99987,-37.8812,-17.5689,1\",\"title\":\"Maxillaire ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2023-03-21 12:27:29.000','2023-04-12 04:41:15.575','2023-04-12 06:41:15.575'),('dd29f41a-cbb1-45d7-8979-1d16d4db487c',662,'/var/.data/2021/662/5587321c-4405-49dc-90d5-8810cc776c6d/session_7e359a5f-1756-4ec7-8657-3e5940ae489d/occlusion_b29b47d4-35f8-427d-9cd7-a393e48be2cf/scan_453abb20-3827-4f8b-b57f-c656c72ebf11/20_w1_o1_mandibule_scan_file_1.zip','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_BOSC_453abb20-3827-4f8b-b57f-c656c72ebf11_MODEL','20_w1_o1_mandibule_scan_file_1.zip','ede17ed3-0dee-42d5-86a9-2728608363fe','{\"displayTitle\":\"Mandibule 1.20.1.1.1\",\"modelMatrix\":\"0.993602,-0.104869,0.0419241,0,0.112939,0.922608,-0.368835,0,-7.12355e-11,0.37121,0.928549,0,-21.8303,-22.816,-15.4889,1\",\"title\":\"Mandibule ZIP\"}','ZIP',1,'SYNCED',0,NULL,'2021-10-12 12:26:35.000','2023-06-13 12:02:12.765','2023-06-13 14:02:12.765'),('dd45b218-e893-4bfa-a2dc-cfdb060bbcbc',662,'/var/.data/2023/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_2c78d514-95bd-4529-b0a1-babfb83849b1/occlusion_983c39b6-656b-4bf2-bf43-da1625adb861/scan_209f3c55-7380-4efa-8e6c-dfe8c99792a6/21_w7_o1_mandibule_snapshot_2.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_2c78d514-95bd-4529-b0a1-babfb83849b1_SESS_983c39b6-656b-4bf2-bf43-da1625adb861_BOSC_209f3c55-7380-4efa-8e6c-dfe8c99792a6_SNAPS','21_w7_o1_mandibule_snapshot_2.png','252b180c-565f-4f14-af48-a16cebbead9e','{\"displayTitle\":\"Mandibule 1.21.7.1.1\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',2,'SYNCED',0,NULL,'2023-01-11 12:34:03.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.072'),('de0c426e-a321-49cc-9a15-8f590e95c146',662,'/var/.data/2020/662/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_bdf42f40-5a7a-435b-a5e0-eb33efefbc97/scan_d1ad6baa-b3e6-4e10-bd69-140c7abc8f4e/6_w1_o1_mordu_anterieur_snapshot_0.png','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_bdf42f40-5a7a-435b-a5e0-eb33efefbc97_FRSC_d1ad6baa-b3e6-4e10-bd69-140c7abc8f4e_SNAPS','6_w1_o1_mordu_anterieur_snapshot_0.png','de0c426e-a321-49cc-9a15-8f590e95c146','{\"displayTitle\":\"Mordu anterieur 1.6.1.1.1\",\"title\":\"MORDU_ANTERIEUR SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-10 11:49:59.000','2023-06-13 12:02:10.130','2023-06-13 14:02:10.130'),('de0cdea6-9c25-4adc-b642-788b56270d11',662,'/var/.data/2020/662/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_a18ca6df-d765-4c6a-be28-13abd1c350af/scan_cb1d5d31-89cd-4ab4-bada-dc6b2235cac5/6_w1_o2_maxillaire_snapshot_1.png','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_a18ca6df-d765-4c6a-be28-13abd1c350af_TOSC_cb1d5d31-89cd-4ab4-bada-dc6b2235cac5_SNAPS','6_w1_o2_maxillaire_snapshot_1.png','35704ab9-18dc-4d80-81f3-5f50e93033c6','{\"displayTitle\":\"Maxillaire 1.6.1.2.1\",\"title\":\"MAXILLAIRE SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2020-04-17 11:04:13.000','2023-06-13 12:02:10.266','2023-06-13 14:02:10.266'),('def017c4-f711-11ec-a752-9ec33d03e6dd',662,'/var/.data/2022/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/def017c4-f711-11ec-a752-9ec33d03e6dd.png','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_949fe730-88fa-4ec2-852e-dd0772ee3ee0_SESS_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d_TOSC_1c6adc05-0655-4ad6-bcc9-27b0ef578ded_SNAPS','19_w2_o1_maxillaire_snapshot_4.png','def017c4-f711-11ec-a752-9ec33d03e6dd','{\"displayTitle\":\"Maxillaire 1.19.2.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-06-28 20:39:39.000','2023-06-13 12:02:23.200','2023-06-13 14:02:23.200'),('def1623b-f711-11ec-a752-9ec33d03e6dd',662,'/var/.data/2022/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/def1623b-f711-11ec-a752-9ec33d03e6dd.zip','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_949fe730-88fa-4ec2-852e-dd0772ee3ee0_SESS_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d_TOSC_1c6adc05-0655-4ad6-bcc9-27b0ef578ded_MODEL','19_w2_o1_maxillaire_scan_file_4.zip','def1623b-f711-11ec-a752-9ec33d03e6dd','{\"displayTitle\":\"Maxillaire 1.19.2.1.1\",\"modelMatrix\":\"-0.913445,0.391574,-0.110853,0,-0.406963,-0.878905,0.248813,0,-2.04414e-09,0.27239,0.962187,0,9.22638,-15.1189,-27.0834,1\",\"title\":\"Maxillaire ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-06-28 20:39:41.000','2023-06-13 12:02:23.208','2023-06-13 14:02:23.208'),('e0880d3b-5ad5-11ed-a752-9ec33d03e6dd',662,'/var/.data/2022/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/e0880d3b-5ad5-11ed-a752-9ec33d03e6dd.zip','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_129a6c33-3cca-43ab-b97a-56d0e82a546f_SESS_b5b4db66-f433-46fb-b794-d632b8fe8e1d_TOSC_ed495283-b756-4052-ba8b-5fe9f9b1f8be_MODEL','19_w3_o1_maxillaire_scan_file_1.zip','e0880d3b-5ad5-11ed-a752-9ec33d03e6dd','{\"displayTitle\":\"Maxillaire 1.19.3.1.1\",\"modelMatrix\":\"0.997618,-0.0632367,0.0275495,0,0.0689772,0.914593,-0.398449,0,-2.86851e-09,0.3994,0.916777,0,-21.303,5.53173,-20.191,1\",\"title\":\"Maxillaire ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-11-02 12:30:09.000','2023-06-13 12:02:23.252','2023-06-13 14:02:23.252'),('e0898270-5ad5-11ed-a752-9ec33d03e6dd',662,'/var/.data/2022/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/e0898270-5ad5-11ed-a752-9ec33d03e6dd.png','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_129a6c33-3cca-43ab-b97a-56d0e82a546f_SESS_b5b4db66-f433-46fb-b794-d632b8fe8e1d_RISC_99102b35-9ad0-4017-b70e-fa08e5c36102_SNAPS','19_w3_o1_mordu_posterieur_droit_snapshot_0.png','e0898270-5ad5-11ed-a752-9ec33d03e6dd','{\"displayTitle\":\"Mordu posterieur droit 1.19.3.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-11-02 12:34:10.000','2023-06-13 12:02:23.261','2023-06-13 14:02:23.261'),('e08b1d8c-5ad5-11ed-a752-9ec33d03e6dd',662,'/var/.data/2022/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/e08b1d8c-5ad5-11ed-a752-9ec33d03e6dd.zip','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_129a6c33-3cca-43ab-b97a-56d0e82a546f_SESS_b5b4db66-f433-46fb-b794-d632b8fe8e1d_LESC_e9aaa539-6e84-47bc-9c50-2c8797de82a4_MODEL','19_w3_o1_mordu_posterieur_gauche_scan_file_0.zip','e08b1d8c-5ad5-11ed-a752-9ec33d03e6dd','{\"displayTitle\":\"Mordu posterieur gauche 1.19.3.1.1\",\"modelMatrix\":\"-0.983417,-0.121012,0.138821,0,0.133349,-0.98274,0.127701,0,0.12304,0.140097,0.982062,0,-8.04084,2.09214,-18.4869,1\",\"title\":\"Mordu posterieur gauche ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-11-02 12:34:58.000','2023-06-13 12:02:23.271','2023-06-13 14:02:23.271'),('e08c98f8-5ad5-11ed-a752-9ec33d03e6dd',662,'/var/.data/2022/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/e08c98f8-5ad5-11ed-a752-9ec33d03e6dd.png','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_129a6c33-3cca-43ab-b97a-56d0e82a546f_SESS_b5b4db66-f433-46fb-b794-d632b8fe8e1d_FRSC_5a59f382-4b59-4867-8640-021d20bdcd59_SNAPS','19_w3_o1_mordu_anterieur_snapshot_0.png','e08c98f8-5ad5-11ed-a752-9ec33d03e6dd','{\"displayTitle\":\"Mordu anterieur 1.19.3.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-11-02 12:36:21.000','2023-06-13 12:02:23.288','2023-06-13 14:02:23.288'),('e08dfb34-5ad5-11ed-a752-9ec33d03e6dd',662,'/var/.data/2022/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/e08dfb34-5ad5-11ed-a752-9ec33d03e6dd.png','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_129a6c33-3cca-43ab-b97a-56d0e82a546f_SESS_b5b4db66-f433-46fb-b794-d632b8fe8e1d_LESC_e9aaa539-6e84-47bc-9c50-2c8797de82a4_SNAPS','19_w3_o1_mordu_posterieur_gauche_snapshot_0.png','e08dfb34-5ad5-11ed-a752-9ec33d03e6dd','{\"displayTitle\":\"Mordu posterieur gauche 1.19.3.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-11-02 12:34:58.000','2023-06-13 12:02:23.299','2023-06-13 14:02:23.299'),('e08f638b-5ad5-11ed-a752-9ec33d03e6dd',662,'/var/.data/2022/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/e08f638b-5ad5-11ed-a752-9ec33d03e6dd.zip','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_129a6c33-3cca-43ab-b97a-56d0e82a546f_SESS_b5b4db66-f433-46fb-b794-d632b8fe8e1d_RISC_99102b35-9ad0-4017-b70e-fa08e5c36102_MODEL','19_w3_o1_mordu_posterieur_droit_scan_file_0.zip','e08f638b-5ad5-11ed-a752-9ec33d03e6dd','{\"displayTitle\":\"Mordu posterieur droit 1.19.3.1.1\",\"modelMatrix\":\"0.990577,0.063814,0.120048,0,-0.0634761,0.997187,-0.0428834,0,-0.121464,0.0398795,0.991852,0,-6.34989,1.53472,-18.1401,1\",\"title\":\"Mordu posterieur droit ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-11-02 12:34:10.000','2023-06-13 12:02:23.308','2023-06-13 14:02:23.308'),('e0909d5b-5ad5-11ed-a752-9ec33d03e6dd',662,'/var/.data/2022/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/e0909d5b-5ad5-11ed-a752-9ec33d03e6dd.zip','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_129a6c33-3cca-43ab-b97a-56d0e82a546f_SESS_b5b4db66-f433-46fb-b794-d632b8fe8e1d_FRSC_5a59f382-4b59-4867-8640-021d20bdcd59_MODEL','19_w3_o1_mordu_anterieur_scan_file_0.zip','e0909d5b-5ad5-11ed-a752-9ec33d03e6dd','{\"displayTitle\":\"Mordu anterieur 1.19.3.1.1\",\"modelMatrix\":\"0.78556,0.0689669,0.617195,0,-0.0519632,0.992749,0.0772647,0,-0.622253,-0.130203,0.783238,0,16.0725,3.3683,-20.068,1\",\"title\":\"Mordu anterieur ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-11-02 12:36:21.000','2023-06-13 12:02:23.318','2023-06-13 14:02:23.318'),('e0920e08-5ad5-11ed-a752-9ec33d03e6dd',662,'/var/.data/2022/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/e0920e08-5ad5-11ed-a752-9ec33d03e6dd.png','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_129a6c33-3cca-43ab-b97a-56d0e82a546f_SESS_b5b4db66-f433-46fb-b794-d632b8fe8e1d_TOSC_ed495283-b756-4052-ba8b-5fe9f9b1f8be_SNAPS','19_w3_o1_maxillaire_snapshot_1.png','e0920e08-5ad5-11ed-a752-9ec33d03e6dd','{\"displayTitle\":\"Maxillaire 1.19.3.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-11-02 12:30:06.000','2023-06-13 12:02:23.327','2023-06-13 14:02:23.327'),('e0c2841d-b460-4eda-9548-18bb8a59d908',662,'/var/.data/2022/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_2a050d02-7424-4099-b1d0-2d7da678e690/occlusion_a5bc2d6f-0248-466f-a10b-08f5391fd12f/scan_d2cd260d-4191-4884-80e3-7ced9fa0f8ce/21_w5_o1_maxillaire_snapshot_1.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_2a050d02-7424-4099-b1d0-2d7da678e690_SESS_a5bc2d6f-0248-466f-a10b-08f5391fd12f_TOSC_d2cd260d-4191-4884-80e3-7ced9fa0f8ce_SNAPS','21_w5_o1_maxillaire_snapshot_1.png','a76fbd10-38f6-45b2-bcd6-4235bebb7cc8','{\"displayTitle\":\"Maxillaire 1.21.5.1.2\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2022-11-04 13:46:21.000','2023-06-13 12:02:14.967','2023-06-13 14:02:14.967'),('e1692a67-2979-4399-b4dc-65a1c7e9c4b8',662,'/var/.data/2021/662/615ede1a-dba9-4251-9e9e-6cbbd3041fdc/session_76dcd1f0-f6c7-480f-b07b-441679345d70/occlusion_c6fffa68-cc65-471a-a58e-135ebe4d0772/scan_ae899af8-7040-48c9-a9b2-6ebc255ac7c9/15_w1_o1_maxillaire_scan_file_0.ply','PATIENT_615ede1a-dba9-4251-9e9e-6cbbd3041fdc_ACT_76dcd1f0-f6c7-480f-b07b-441679345d70_SESS_c6fffa68-cc65-471a-a58e-135ebe4d0772_TOSC_ae899af8-7040-48c9-a9b2-6ebc255ac7c9_MODEL','15_w1_o1_maxillaire_scan_file_0.ply','e1692a67-2979-4399-b4dc-65a1c7e9c4b8','{\"displayTitle\":\"Maxillaire 1.15.1.1.1\",\"modelMatrix\":\"-0.725898,-0.666889,0.168318,0,0.687803,-0.703826,0.177641,0,-2.52568e-9,0.244719,0.969594,0,16.8234,-0.758748,-27.4469,1\",\"title\":\"Maxillaire PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-02-16 12:19:19.000','2023-06-13 12:02:09.691','2023-06-13 14:02:09.691'),('e18ed074-c432-415e-b63e-3b73dcb95e72',662,'/var/.data/2020/662/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/order_50b326be-6726-493a-a2ce-6f1153dc9927/6_w1_autre_prost_file_0.pdf','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_PROST_50b326be-6726-493a-a2ce-6f1153dc9927_FORM','6_w1_autre_prost_file_0.pdf','e18ed074-c432-415e-b63e-3b73dcb95e72','{\"displayTitle\":\"AUTRE FICHE PROTHÉTIQUE 1.6.1.1 AUTRE FICHE PROTHÉTIQUE\",\"title\":\"Autre PDF\"}','PDF',0,'SYNCED',0,NULL,'2020-04-17 07:56:49.000','2023-06-13 12:02:17.695','2023-06-13 14:02:17.695'),('e1c42d91-d915-11ed-b558-229278a3c906',662,'/var/.data/2023/662/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_a62b9800-d910-11ed-b558-229278a3c906/occlusion_a62ebb05-d910-11ed-b558-229278a3c906/scan_ac6f0be1-d915-11ed-b558-229278a3c906/e1c42d91-d915-11ed-b558-229278a3c906.zip','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_a62b9800-d910-11ed-b558-229278a3c906_SESS_a62ebb05-d910-11ed-b558-229278a3c906_RISC_ac6f0be1-d915-11ed-b558-229278a3c906_MODEL','e1c42d91-d915-11ed-b558-229278a3c906.zip','e1c42d91-d915-11ed-b558-229278a3c906','{\"displayTitle\":\"Mordu droit 1.23.2.1.2\",\"modelMatrix\":\"0.666541,-0.263023,0.715834,0,0.242999,0.961252,0.0441293,0,-0.705038,0.109357,0.700329,0,16.2342,6.6631,-22.7236,1\",\"scanBodies\":[]}','ZIP',0,'SYNCED',0,NULL,'2023-06-13 13:47:36.000','2023-06-13 11:59:36.660','2023-06-13 13:59:36.660'),('e1c443e6-d915-11ed-b558-229278a3c906',662,'/var/.data/2023/662/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_a62b9800-d910-11ed-b558-229278a3c906/occlusion_a62ebb05-d910-11ed-b558-229278a3c906/scan_ac6f0be1-d915-11ed-b558-229278a3c906/e1c443e6-d915-11ed-b558-229278a3c906.png','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_a62b9800-d910-11ed-b558-229278a3c906_SESS_a62ebb05-d910-11ed-b558-229278a3c906_RISC_ac6f0be1-d915-11ed-b558-229278a3c906_SNAPS','e1c443e6-d915-11ed-b558-229278a3c906.png','e1c443e6-d915-11ed-b558-229278a3c906','{\"displayTitle\":\"Mordu droit 1.23.2.1.2 Snapshot\"}','PNG',0,'SYNCED',0,NULL,'2023-06-13 13:47:36.000','2023-06-13 11:59:36.676','2023-06-13 13:59:36.676'),('e22ce6e5-78b3-470f-8eac-fc2668ff13bc',662,'/var/.data/2022/662/5587321c-4405-49dc-90d5-8810cc776c6d/session_3eede325-0afb-43f5-9277-e22c18f8f927/occlusion_f72f6016-0f75-4789-9924-1bc9aa64c2f1/scan_254d7cff-f2aa-4d41-8b1c-7b0bdd6386ff/20_w2_o1_mandibule_snapshot_0.png','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_3eede325-0afb-43f5-9277-e22c18f8f927_SESS_f72f6016-0f75-4789-9924-1bc9aa64c2f1_BOSC_254d7cff-f2aa-4d41-8b1c-7b0bdd6386ff_SNAPS','20_w2_o1_mandibule_snapshot_0.png','e22ce6e5-78b3-470f-8eac-fc2668ff13bc','{\"displayTitle\":\"Mandibule 1.20.2.1.1\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-08-06 13:56:36.000','2023-06-13 12:02:13.498','2023-06-13 14:02:13.498'),('e22d8b26-814a-456b-850f-82860b769634',662,'/var/.data/2020/662/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_a18ca6df-d765-4c6a-be28-13abd1c350af/scan_d36d186b-d0da-4aea-af1a-4613f67b2fa0/6_w1_o2_mordu_posterieur_gauche_scan_file_0.ply','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_a18ca6df-d765-4c6a-be28-13abd1c350af_LESC_d36d186b-d0da-4aea-af1a-4613f67b2fa0_MODEL','6_w1_o2_mordu_posterieur_gauche_scan_file_0.ply','e22d8b26-814a-456b-850f-82860b769634','{\"displayTitle\":\"Mordu posterieur gauche 1.6.1.2.1\",\"modelMatrix\":\"-0.976498,-0.184814,0.106105,0,0.17864,-0.979328,-0.095944,0,0.120669,-0.0826865,0.989745,0,-6.4813,-0.817089,-19.9051,1\",\"title\":\"MORDU_POSTERIEUR_GAUCHE PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-17 11:17:41.000','2023-06-13 12:02:10.299','2023-06-13 14:02:10.299'),('e2e61121-2865-452b-a685-13a4ecd0974b',662,'/var/.data/2021/662/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_643b3b5a-e991-4dbf-95c8-2fd609f83a8b/14_w1_o1_maxillaire_snapshot_6.png','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_TOSC_643b3b5a-e991-4dbf-95c8-2fd609f83a8b_SNAPS','14_w1_o1_maxillaire_snapshot_6.png','3d7bd9ef-9d44-4365-af74-4d2a31f8f2fb','{\"displayTitle\":\"Maxillaire 1.14.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',6,'SYNCED',0,NULL,'2021-02-01 20:56:49.000','2023-06-13 12:02:09.556','2023-06-13 14:02:09.556'),('e31677ad-6acd-445e-8577-f3c741a13dc2',662,'/var/.data/2021/662/ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07/session_b498bdf4-2e5b-497a-8bfe-b65edabac3bc/occlusion_31210683-bc06-4b84-83d9-ce60f32308e4/scan_0f18aace-5cf2-4d46-b56f-f8dc123e1f91/22_w1_o1_mordu_posterieur_gauche_snapshot_0.png','PATIENT_ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07_ACT_b498bdf4-2e5b-497a-8bfe-b65edabac3bc_SESS_31210683-bc06-4b84-83d9-ce60f32308e4_LESC_0f18aace-5cf2-4d46-b56f-f8dc123e1f91_SNAPS','22_w1_o1_mordu_posterieur_gauche_snapshot_0.png','e31677ad-6acd-445e-8577-f3c741a13dc2','{\"displayTitle\":\"Mordu posterieur gauche 1.22.1.1.2\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-11-23 12:21:30.000','2023-06-13 12:02:13.012','2023-06-13 14:02:13.012'),('e3dcb444-172f-4ae1-a2bc-7ff3b7c8eb26',662,'/var/.data/2021/662/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_7a480eb2-a7b4-4ec5-b628-ef6c2043dd7a/14_w1_o1_mordu_posterieur_gauche_scan_file_0.ply','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_LESC_7a480eb2-a7b4-4ec5-b628-ef6c2043dd7a_MODEL','14_w1_o1_mordu_posterieur_gauche_scan_file_0.ply','e3dcb444-172f-4ae1-a2bc-7ff3b7c8eb26','{\"displayTitle\":\"Mordu posterieur gauche 1.14.1.1.1\",\"modelMatrix\":\"-0.985289,-0.131765,0.118009,0,0.131279,-0.988844,0.0497781,0,0.109691,0.0700508,0.991776,0,-5.9124,-3.58406,-17.0319,1\",\"title\":\"Mordu posterieur gauche PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-02-01 21:19:45.000','2023-06-13 12:02:09.632','2023-06-13 14:02:09.632'),('e54a3aaa-1b5e-4e05-b9aa-30359687e6de',662,'','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_TOSC_778a761c-339e-4143-a807-735b174d9714_MODEL','7_w2_o2_maxillaire_scan_file_0.ply','e54a3aaa-1b5e-4e05-b9aa-30359687e6de','{\"displayTitle\":\"MAXILLAIRE 1.7.2.2.1\",\"modelMatrix\":\"0.678937,0.648365,-0.344482,0,-0.734197,0.599565,-0.318554,0,1.26562e-8,0.469196,0.883094,0,-12.3592,-32.095,-49.6187,1\",\"title\":\"MAXILLAIRE PLY\"}','PLY',0,'SYNCED',0,'2023-04-12 06:40:30.000','2020-04-15 07:29:30.000','2023-06-13 12:02:15.420','2023-06-13 14:02:15.420'),('e695a41c-b645-425c-85e6-65b449ddbb04',662,'/var/.data/2020/662/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/occlusion_b87f1382-55d4-4e52-b63a-6f387df18b16/scan_534cca35-8182-4f61-aa57-03bad8172eac/13_w4_o1_mordu_anterieur_scan_file_1.ply','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_SESS_b87f1382-55d4-4e52-b63a-6f387df18b16_FRSC_534cca35-8182-4f61-aa57-03bad8172eac_MODEL','13_w4_o1_mordu_anterieur_scan_file_1.ply','ba881d4e-efc8-45fe-90c8-248f552f9196','{\"displayTitle\":\"Mordu anterieur 1.13.4.1.1\",\"modelMatrix\":\"0.73505,0.0413959,0.670351,0,0.0805396,0.979844,-0.202859,0,-0.673691,0.199099,0.714379,0,8.76336,-10.2617,-32.2954,1\",\"title\":\"Mordu anterieur PLY\"}','PLY',1,'SYNCED',0,NULL,'2020-12-29 11:37:09.000','2023-06-13 12:02:12.132','2023-06-13 14:02:12.132'),('e720e2f6-8dce-43f4-a5d6-bf8c09037947',662,'/var/.data/2021/662/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_643b3b5a-e991-4dbf-95c8-2fd609f83a8b/14_w1_o1_maxillaire_scan_file_0.ply','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_TOSC_643b3b5a-e991-4dbf-95c8-2fd609f83a8b_MODEL','14_w1_o1_maxillaire_scan_file_0.ply','e720e2f6-8dce-43f4-a5d6-bf8c09037947','{\"displayTitle\":\"Maxillaire 1.14.1.1.1\",\"modelMatrix\":\"-0.941249,-0.322812,0.0992107,0,0.337713,-0.899717,0.276513,0,2.03629e-9,0.293772,0.955875,0,6.80818,-15.7657,-21.6458,1\",\"title\":\"Maxillaire PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-02-01 20:20:58.000','2023-06-13 12:02:09.527','2023-06-13 14:02:09.527'),('e8f06fb1-375a-41c0-9a27-d0ee2593900c',662,'/var/.data/2020/662/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/occlusion_b87f1382-55d4-4e52-b63a-6f387df18b16/scan_4a2eec76-a5f3-44f0-b389-4734998fa2d3/13_w4_o1_mandibule_snapshot_0.png','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_SESS_b87f1382-55d4-4e52-b63a-6f387df18b16_BOSC_4a2eec76-a5f3-44f0-b389-4734998fa2d3_SNAPS','13_w4_o1_mandibule_snapshot_0.png','e8f06fb1-375a-41c0-9a27-d0ee2593900c','{\"displayTitle\":\"Mandibule SNAPSHOT\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-12-29 11:20:13.000','2023-06-13 12:02:12.189','2023-06-13 14:02:12.189'),('e94bbc94-0540-4634-816e-4a842ced15fa',662,'/var/.data/2020/662/2b4f07b1-1d58-42a2-9e72-3461efd5a2d9/session_bc967a6b-ad1a-4a59-aab8-92332e4217b0/occlusion_f2e73640-aebd-4bb1-9b02-c0504556ac5a/scan_e7efed59-e33c-4194-94c1-3507350dcfb5/5_w3_o1_maxillaire_scan_file_2.ply','PATIENT_2b4f07b1-1d58-42a2-9e72-3461efd5a2d9_ACT_bc967a6b-ad1a-4a59-aab8-92332e4217b0_SESS_f2e73640-aebd-4bb1-9b02-c0504556ac5a_TOSC_e7efed59-e33c-4194-94c1-3507350dcfb5_MODEL','5_w3_o1_maxillaire_scan_file_2.ply','42d780c5-37b5-433e-890f-3c005cb69701','{\"displayTitle\":\"Maxillaire 1.5.3.1.1\",\"modelMatrix\":\"-0.833771,-0.538581,0.121476,0,0.552111,-0.813339,0.183447,0,1.70644e-10,0.220021,0.975495,0,10.0785,-7.67299,-25.1653,1\",\"title\":\"Maxillaire PLY\"}','PLY',2,'SYNCED',0,NULL,'2020-07-13 19:39:11.000','2023-04-12 04:41:22.144','2023-04-12 06:41:22.144'),('e969b9cf-a941-4745-a2cb-e1ed64d3332e',662,'/var/.data/2022/662/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_949fe730-88fa-4ec2-852e-dd0772ee3ee0/occlusion_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d/scan_1c6adc05-0655-4ad6-bcc9-27b0ef578ded/19_w2_o1_maxillaire_snapshot_2.png','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_949fe730-88fa-4ec2-852e-dd0772ee3ee0_SESS_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d_TOSC_1c6adc05-0655-4ad6-bcc9-27b0ef578ded_SNAPS','19_w2_o1_maxillaire_snapshot_2.png','d40f4bba-69b0-4cc6-b541-e69c16b2b3d5','{\"displayTitle\":\"Maxillaire 1.19.2.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',2,'SYNCED',0,NULL,'2022-06-28 20:27:39.000','2023-06-13 12:02:13.467','2023-06-13 14:02:13.467'),('eaabd852-7d4b-11ea-947d-226cec7cb58a',662,'/var/.data/2020/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/eaabd852-7d4b-11ea-947d-226cec7cb58a.ply','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_cb9d8495-b4dd-423f-a624-7cff70e4db55_SESS_c9d37315-5f17-421c-8afb-302fa9b0bebe_BOSC_6fafe104-bdc1-41a6-9977-b1bbb351a329_MODEL','2_w2_o1_mandibule_scan_file_1.ply','eaabd852-7d4b-11ea-947d-226cec7cb58a','{\"displayTitle\":\"MANDIBULE 1.2.2.1.1\",\"modelMatrix\":\"0.998917,-0.046407,0.00327279,0,0.0465222,0.996442,-0.0702729,0,2.41777e-10,0.070349,0.997522,0,-15.4826,-27.7313,-45.5726,1\",\"title\":\"MANDIBULE PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-07 06:42:41.000','2023-06-13 12:02:21.899','2023-06-13 14:02:21.899'),('eaadb843-7d4b-11ea-947d-226cec7cb58a',662,'/var/.data/2020/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/eaadb843-7d4b-11ea-947d-226cec7cb58a.pdf','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_cb9d8495-b4dd-423f-a624-7cff70e4db55_PROST_fb151d98-0604-45ed-8599-26fa11975b19_FORM','2_w2_odf_prost_file_0.pdf','eaadb843-7d4b-11ea-947d-226cec7cb58a','{\"displayTitle\":\"ODF 1.2.2.2 ODF\",\"title\":\"Odf PDF\"}','PDF',0,'SYNCED',0,NULL,'2020-04-13 07:59:28.000','2023-06-13 12:02:21.909','2023-06-13 14:02:21.909'),('eab0f62d-7d4b-11ea-947d-226cec7cb58a',662,'/var/.data/2020/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/eab0f62d-7d4b-11ea-947d-226cec7cb58a.png','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_cb9d8495-b4dd-423f-a624-7cff70e4db55_SESS_c9d37315-5f17-421c-8afb-302fa9b0bebe_BOSC_6fafe104-bdc1-41a6-9977-b1bbb351a329_SNAPS','2_w2_o1_mandibule_snapshot_1.png','eab0f62d-7d4b-11ea-947d-226cec7cb58a','{\"displayTitle\":\"MANDIBULE 1.2.2.1.1\",\"title\":\"MANDIBULE SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-07 06:42:41.000','2023-06-13 12:02:21.916','2023-06-13 14:02:21.916'),('ebcf2fdf-8f60-4590-bf41-6c7e360d6441',662,'','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_ec084612-67a2-4430-ae15-7fe0edeaca64_PROST_fce8aef9-22f3-446a-bd23-7f6a283417dc_FORM','2_w3_autre_prost_file_0.pdf','ebcf2fdf-8f60-4590-bf41-6c7e360d6441','{\"displayTitle\":\"AUTRE FICHE PROTHÉTIQUE 1.2.3.1 AUTRE FICHE PROTHÉTIQUE\",\"title\":\"Autre PDF\"}','PDF',0,'SYNCED',0,'2023-04-12 06:41:21.000','2020-04-12 08:28:40.000','2023-06-13 12:02:17.609','2023-06-13 14:02:17.609'),('ebf4cbaa-94a5-42c6-aad4-4f61d8ad16b8',662,'/var/.data/2021/662/ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07/session_b498bdf4-2e5b-497a-8bfe-b65edabac3bc/occlusion_31210683-bc06-4b84-83d9-ce60f32308e4/scan_1e8824f7-3c76-4fe0-bd8c-f865f725dab2/22_w1_o1_mordu_anterieur_snapshot_0.png','PATIENT_ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07_ACT_b498bdf4-2e5b-497a-8bfe-b65edabac3bc_SESS_31210683-bc06-4b84-83d9-ce60f32308e4_FRSC_1e8824f7-3c76-4fe0-bd8c-f865f725dab2_SNAPS','22_w1_o1_mordu_anterieur_snapshot_0.png','ebf4cbaa-94a5-42c6-aad4-4f61d8ad16b8','{\"displayTitle\":\"Mordu anterieur 1.22.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-11-23 12:23:17.000','2023-06-13 12:02:13.030','2023-06-13 14:02:13.030'),('ed40ce9a-6d1f-4cfd-a3e2-f58cba946869',662,'/var/.data/2021/662/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_0c1ed331-8df6-482e-8dd1-508d9b190c49/occlusion_6c6bb813-840d-454a-ab1d-9232434a4500/scan_d7c4d383-83f9-4275-bbcc-567a47d4a450/19_w1_o1_mordu_posterieur_gauche_scan_file_0.ply','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_LESC_d7c4d383-83f9-4275-bbcc-567a47d4a450_MODEL','19_w1_o1_mordu_posterieur_gauche_scan_file_0.ply','ed40ce9a-6d1f-4cfd-a3e2-f58cba946869','{\"displayTitle\":\"Mordu posterieur gauche 1.19.1.1.1\",\"modelMatrix\":\"-0.976818,-0.173343,0.122598,0,0.179187,-0.982871,0.0414572,0,0.117191,0.0625849,0.991598,0,10.7409,1.26499,-20.9619,1\",\"title\":\"Mordu posterieur gauche PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-09-27 12:46:45.000','2023-06-13 12:02:12.534','2023-06-13 14:02:12.534'),('ede17ed3-0dee-42d5-86a9-2728608363fe',662,'/var/.data/2021/662/5587321c-4405-49dc-90d5-8810cc776c6d/session_7e359a5f-1756-4ec7-8657-3e5940ae489d/occlusion_b29b47d4-35f8-427d-9cd7-a393e48be2cf/scan_453abb20-3827-4f8b-b57f-c656c72ebf11/20_w1_o1_mandibule_scan_file_0.zip','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_BOSC_453abb20-3827-4f8b-b57f-c656c72ebf11_MODEL','20_w1_o1_mandibule_scan_file_0.zip','ede17ed3-0dee-42d5-86a9-2728608363fe','{\"displayTitle\":\"Mandibule 1.20.1.1.1\",\"modelMatrix\":\"0.997701,-0.0634158,0.0238806,0,0.0677632,0.933694,-0.351603,0,7.81016e-10,0.352413,0.935845,0,-21.1355,-22.8904,-15.5515,1\",\"title\":\"Mandibule ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2021-10-12 12:22:49.000','2023-06-13 12:02:12.757','2023-06-13 14:02:12.757'),('ee74d731-2b8a-426e-a645-bad9ae685308',662,'/var/.data/2020/662/406a8572-4b0f-480a-ad2e-daf5530143b6/session_a7b0f1ae-ce37-4faf-9b3c-e5fab6996549/occlusion_254f3fc9-4782-4658-bb34-f2ca1c9b6382/scan_107f2922-62ee-42d9-8e35-69d71587db0b/2_w6_o1_mandibule_scan_file_0.ply','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_a7b0f1ae-ce37-4faf-9b3c-e5fab6996549_SESS_254f3fc9-4782-4658-bb34-f2ca1c9b6382_BOSC_107f2922-62ee-42d9-8e35-69d71587db0b_MODEL','2_w6_o1_mandibule_scan_file_0.ply','ee74d731-2b8a-426e-a645-bad9ae685308','{\"displayTitle\":\"Mandibule 1.2.6.1.2\",\"modelMatrix\":\"-0.23508,0.970841,-0.0469621,0,-0.971976,-0.234806,0.0113582,0,-1.81653e-10,0.0483161,0.998832,0,12.0001,-16.6608,-34.952,1\",\"title\":\"MANDIBULE PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-05-21 08:13:15.000','2023-06-13 12:02:10.483','2023-06-13 14:02:10.483'),('eee409c6-39bb-43e6-9a2d-c17ecc88cf08',662,'/var/.data/2020/662/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/occlusion_d402edb5-8449-46a8-862f-a1cd1ee21cf6/scan_b7931623-9b21-4440-a950-16565249bf9a/10_w1_o1_mandibule_scan_file_1.ply','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_SESS_d402edb5-8449-46a8-862f-a1cd1ee21cf6_BOSC_b7931623-9b21-4440-a950-16565249bf9a_MODEL','10_w1_o1_mandibule_scan_file_1.ply','6008312e-ba22-4c98-a696-7500991d7069','{\"displayTitle\":\"MANDIBULE 1.10.1.1.2\",\"modelMatrix\":\"-0.973472,-0.219251,0.0654214,0,0.228804,-0.932831,0.278343,0,-2.24986e-9,0.285928,0.958251,0,19.0474,6.13443,-22.4812,1\",\"title\":\"MANDIBULE PLY\"}','PLY',1,'SYNCED',0,NULL,'2020-04-30 19:51:54.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.090'),('f06e433d-c712-4081-adba-9051f0c10c4e',662,'/var/.data/2022/662/e27b6130-520e-4c5b-8e6b-5e82a8c5a273/session_7841125a-11dd-4b66-9179-cd371ea2f0f7/occlusion_12115366-8eb9-470b-a097-5d28bb5fdf38/scan_5a4f6b62-6381-4a1e-bbef-61746f2722d3/23_w1_o1_mordu_anterieur_snapshot_0.png','PATIENT_e27b6130-520e-4c5b-8e6b-5e82a8c5a273_ACT_7841125a-11dd-4b66-9179-cd371ea2f0f7_SESS_12115366-8eb9-470b-a097-5d28bb5fdf38_FRSC_5a4f6b62-6381-4a1e-bbef-61746f2722d3_SNAPS','23_w1_o1_mordu_anterieur_snapshot_0.png','f06e433d-c712-4081-adba-9051f0c10c4e','{\"displayTitle\":\"Mordu anterieur 1.23.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2022-01-11 12:41:14.000','2023-06-13 12:02:13.150','2023-06-13 14:02:13.150'),('f0df34cd-4382-481e-9fcb-ed767063a228',662,'','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_78fbbe11-e1a5-4c10-b6e3-4f00df178dc6_SESS_f7b71416-57aa-4d3d-a2e5-0e6c1519f6e8_TOSC_5a5e6904-4736-4443-bbd0-be73066af8c3_MODEL','7_w1_o1_maxillaire_scan_file_0.ply','f0df34cd-4382-481e-9fcb-ed767063a228','{\"displayTitle\":\"MAXILLAIRE 1.7.1.1.1\",\"modelMatrix\":\"0.688058,0.664151,-0.292369,0,-0.725655,0.62974,-0.277221,0,1.42262e-8,0.402904,0.915242,0,-16.8969,-29.4119,-29.5299,1\",\"title\":\"MAXILLAIRE PLY\"}','PLY',0,'SYNCED',0,'2023-04-12 06:41:22.000','2020-04-14 12:10:33.000','2023-06-13 12:02:15.240','2023-06-13 14:02:15.240'),('f0fe7a67-1ca7-4da6-b4e1-681dc8f0e6b1',662,'/var/.data/2022/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_87965ef8-01eb-4830-8e8b-8b99ece62cf1/occlusion_dce9ce0f-0933-4c98-af84-59e2b6395f8f/scan_bd51414b-f96e-4903-a2e2-44fb3189decd/21_w2_o1_mandibule_snapshot_1.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_87965ef8-01eb-4830-8e8b-8b99ece62cf1_SESS_dce9ce0f-0933-4c98-af84-59e2b6395f8f_BOSC_bd51414b-f96e-4903-a2e2-44fb3189decd_SNAPS','21_w2_o1_mandibule_snapshot_1.png','160153e9-3248-4a6b-b0ff-a10c2c1acfc9','{\"displayTitle\":\"Mandibule 1.21.2.1.1\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2022-06-27 20:53:18.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.103'),('f16b178b-9a0f-4a7d-b4da-8d23ef7b4db3',662,'/var/.data/2021/662/03ec19f1-9f11-4710-a0cd-c5d7739e40d7/session_f474819e-9470-4612-8275-2ceb25b5522f/occlusion_484ae4d8-329f-49b5-8d83-312a8a92ff22/scan_0d792709-57f3-49e1-963c-d2dc35a59d12/16_w1_o1_mordu_posterieur_gauche_snapshot_0.png','PATIENT_03ec19f1-9f11-4710-a0cd-c5d7739e40d7_ACT_f474819e-9470-4612-8275-2ceb25b5522f_SESS_484ae4d8-329f-49b5-8d83-312a8a92ff22_LESC_0d792709-57f3-49e1-963c-d2dc35a59d12_SNAPS','16_w1_o1_mordu_posterieur_gauche_snapshot_0.png','f16b178b-9a0f-4a7d-b4da-8d23ef7b4db3','{\"displayTitle\":\"Mordu posterieur gauche 1.16.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-02-27 10:55:29.000','2023-06-13 12:02:09.912','2023-06-13 14:02:09.912'),('f1ef3944-d73f-4a49-8e28-c4619cb61202',662,'/var/.data/2021/662/5587321c-4405-49dc-90d5-8810cc776c6d/session_7e359a5f-1756-4ec7-8657-3e5940ae489d/occlusion_b29b47d4-35f8-427d-9cd7-a393e48be2cf/scan_42b09cf6-e30d-4d35-a17d-d8e8b4564638/20_w1_o1_maxillaire_snapshot_1.png','PATIENT_5587321c-4405-49dc-90d5-8810cc776c6d_ACT_7e359a5f-1756-4ec7-8657-3e5940ae489d_SESS_b29b47d4-35f8-427d-9cd7-a393e48be2cf_TOSC_42b09cf6-e30d-4d35-a17d-d8e8b4564638_SNAPS','20_w1_o1_maxillaire_snapshot_1.png','a60e34f6-4db6-4236-9d5a-1741dd2ed622','{\"displayTitle\":\"Maxillaire 1.20.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2021-10-12 12:37:44.000','2023-06-13 12:02:12.728','2023-06-13 14:02:12.728'),('f24be2c4-4c4f-11ec-9377-226cec7cb58a',662,'/var/.data/2021/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/f24be2c4-4c4f-11ec-9377-226cec7cb58a.zip','PATIENT_ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07_ACT_b498bdf4-2e5b-497a-8bfe-b65edabac3bc_SESS_31210683-bc06-4b84-83d9-ce60f32308e4_TOSC_98e7c216-5bb9-4127-9497-834796980370_MODEL','22_w1_o1_maxillaire_scan_file_0.zip','f24be2c4-4c4f-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Maxillaire 1.22.1.1.1\",\"modelMatrix\":\"-0.984254,0.164681,-0.0642138,0,-0.176758,-0.917007,0.357567,0,1.66597e-9,0.363287,0.931677,0,24.4804,-16.7011,-23.2991,1\",\"title\":\"Maxillaire ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2021-11-23 12:08:22.000','2023-06-13 12:02:22.856','2023-06-13 14:02:22.856'),('f26a7348-4c4f-11ec-9377-226cec7cb58a',662,'/var/.data/2021/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/f26a7348-4c4f-11ec-9377-226cec7cb58a.png','PATIENT_ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07_ACT_b498bdf4-2e5b-497a-8bfe-b65edabac3bc_SESS_31210683-bc06-4b84-83d9-ce60f32308e4_RISC_c1232582-95fc-48dc-a9ee-826c0cbad106_SNAPS','22_w1_o1_mordu_posterieur_droit_snapshot_0.png','f26a7348-4c4f-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Mordu posterieur droit 1.22.1.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-11-23 12:18:01.000','2023-06-13 12:02:22.874','2023-06-13 14:02:22.874'),('f26e9ce0-4c4f-11ec-9377-226cec7cb58a',662,'/var/.data/2021/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/f26e9ce0-4c4f-11ec-9377-226cec7cb58a.zip','PATIENT_ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07_ACT_b498bdf4-2e5b-497a-8bfe-b65edabac3bc_SESS_31210683-bc06-4b84-83d9-ce60f32308e4_BOSC_e8ff012c-af85-450f-ba33-bd61c15846e9_MODEL','22_w1_o1_mandibule_scan_file_0.zip','f26e9ce0-4c4f-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Mandibule 1.22.1.1.1\",\"modelMatrix\":\"0.297612,0.931799,-0.207792,0,-0.954687,0.290477,-0.0647764,0,1.12315e-11,0.217654,0.976026,0,11.0234,-21.5208,-16.5828,1\",\"title\":\"Mandibule ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2021-11-23 12:14:25.000','2023-06-13 12:02:22.884','2023-06-13 14:02:22.884'),('f271870f-4c4f-11ec-9377-226cec7cb58a',662,'/var/.data/2021/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/f271870f-4c4f-11ec-9377-226cec7cb58a.png','PATIENT_ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07_ACT_b498bdf4-2e5b-497a-8bfe-b65edabac3bc_SESS_31210683-bc06-4b84-83d9-ce60f32308e4_BOSC_e8ff012c-af85-450f-ba33-bd61c15846e9_SNAPS','22_w1_o1_mandibule_snapshot_0.png','f271870f-4c4f-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Mandibule 1.22.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-11-23 12:14:24.000','2023-06-13 12:02:22.893','2023-06-13 14:02:22.893'),('f2745c07-4c4f-11ec-9377-226cec7cb58a',662,'/var/.data/2021/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/f2745c07-4c4f-11ec-9377-226cec7cb58a.zip','PATIENT_ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07_ACT_b498bdf4-2e5b-497a-8bfe-b65edabac3bc_SESS_31210683-bc06-4b84-83d9-ce60f32308e4_FRSC_1e8824f7-3c76-4fe0-bd8c-f865f725dab2_MODEL','22_w1_o1_mordu_anterieur_scan_file_0.zip','f2745c07-4c4f-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Mordu anterieur 1.22.1.1.1\",\"modelMatrix\":\"0.725913,-0.0652903,0.681352,0,-0.0436065,0.981927,0.168419,0,-0.687258,-0.181082,0.712365,0,10.2372,3.44717,-27.8986,1\",\"title\":\"Mordu anterieur ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2021-11-23 12:23:17.000','2023-06-13 12:02:22.900','2023-06-13 14:02:22.900'),('f2781fff-4c4f-11ec-9377-226cec7cb58a',662,'/var/.data/2021/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/f2781fff-4c4f-11ec-9377-226cec7cb58a.png','PATIENT_ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07_ACT_b498bdf4-2e5b-497a-8bfe-b65edabac3bc_SESS_31210683-bc06-4b84-83d9-ce60f32308e4_TOSC_98e7c216-5bb9-4127-9497-834796980370_SNAPS','22_w1_o1_maxillaire_snapshot_0.png','f2781fff-4c4f-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Maxillaire 1.22.1.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-11-23 12:08:21.000','2023-06-13 12:02:22.907','2023-06-13 14:02:22.907'),('f27b8845-4c4f-11ec-9377-226cec7cb58a',662,'/var/.data/2021/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/f27b8845-4c4f-11ec-9377-226cec7cb58a.zip','PATIENT_ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07_ACT_b498bdf4-2e5b-497a-8bfe-b65edabac3bc_SESS_31210683-bc06-4b84-83d9-ce60f32308e4_LESC_0f18aace-5cf2-4d46-b56f-f8dc123e1f91_MODEL','22_w1_o1_mordu_posterieur_gauche_scan_file_0.zip','f27b8845-4c4f-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Mordu posterieur gauche 1.22.1.1.2\",\"modelMatrix\":\"-0.987423,-0.1162,0.110526,0,0.107197,-0.992212,-0.0556946,0,0.116253,-0.0450283,0.992314,0,-8.57688,0.410708,-18.9216,1\",\"title\":\"Mordu posterieur gauche ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2021-11-23 12:21:30.000','2023-06-13 12:02:22.917','2023-06-13 14:02:22.917'),('f27e89e8-4c4f-11ec-9377-226cec7cb58a',662,'/var/.data/2021/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/f27e89e8-4c4f-11ec-9377-226cec7cb58a.zip','PATIENT_ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07_ACT_b498bdf4-2e5b-497a-8bfe-b65edabac3bc_SESS_31210683-bc06-4b84-83d9-ce60f32308e4_RISC_c1232582-95fc-48dc-a9ee-826c0cbad106_MODEL','22_w1_o1_mordu_posterieur_droit_scan_file_0.zip','f27e89e8-4c4f-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Mordu posterieur droit 1.22.1.1.1\",\"modelMatrix\":\"0.999595,-0.0218982,0.0166849,0,0.0161573,0.944762,0.325391,0,-0.0234339,-0.327034,0.945435,0,10.0522,9.09217,-24.9856,1\",\"title\":\"Mordu posterieur droit ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2021-11-23 12:18:02.000','2023-06-13 12:02:22.924','2023-06-13 14:02:22.924'),('f28192d9-4c4f-11ec-9377-226cec7cb58a',662,'/var/.data/2021/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/f28192d9-4c4f-11ec-9377-226cec7cb58a.png','PATIENT_ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07_ACT_b498bdf4-2e5b-497a-8bfe-b65edabac3bc_SESS_31210683-bc06-4b84-83d9-ce60f32308e4_LESC_0f18aace-5cf2-4d46-b56f-f8dc123e1f91_SNAPS','22_w1_o1_mordu_posterieur_gauche_snapshot_0.png','f28192d9-4c4f-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Mordu posterieur gauche 1.22.1.1.2\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-11-23 12:21:30.000','2023-06-13 12:02:22.932','2023-06-13 14:02:22.932'),('f28655e5-4c4f-11ec-9377-226cec7cb58a',662,'/var/.data/2021/662/discussion_cf6d3b31-bab1-473f-a635-3b2ab68a1bfa/f28655e5-4c4f-11ec-9377-226cec7cb58a.png','PATIENT_ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07_ACT_b498bdf4-2e5b-497a-8bfe-b65edabac3bc_SESS_31210683-bc06-4b84-83d9-ce60f32308e4_FRSC_1e8824f7-3c76-4fe0-bd8c-f865f725dab2_SNAPS','22_w1_o1_mordu_anterieur_snapshot_0.png','f28655e5-4c4f-11ec-9377-226cec7cb58a','{\"displayTitle\":\"Mordu anterieur 1.22.1.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2021-11-23 12:23:17.000','2023-06-13 12:02:22.940','2023-06-13 14:02:22.940'),('f297816f-db2c-4167-bd60-28d3e93bb7c9',662,'/var/.data/2020/662/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_a18ca6df-d765-4c6a-be28-13abd1c350af/scan_37ff1278-3dd1-470a-8159-e763f6626f5d/6_w1_o2_mandibule_snapshot_0.png','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_a18ca6df-d765-4c6a-be28-13abd1c350af_BOSC_37ff1278-3dd1-470a-8159-e763f6626f5d_SNAPS','6_w1_o2_mandibule_snapshot_0.png','f297816f-db2c-4167-bd60-28d3e93bb7c9','{\"displayTitle\":\"MANDIBULE 1.6.1.2.1\",\"title\":\"MANDIBULE SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-17 11:09:28.000','2023-06-13 12:02:10.222','2023-06-13 14:02:10.222'),('f2e3b9c2-4d8e-490a-8051-fed4332bc376',662,'/var/.data/2021/662/f15cb858-4f0b-44ec-a017-5e662039ba19/session_c47ee4d9-c646-4836-8152-fc2ded70b4fe/occlusion_1ec1f707-d702-496a-b2f0-e55b08c06dcb/scan_643b3b5a-e991-4dbf-95c8-2fd609f83a8b/14_w1_o1_maxillaire_scan_file_3.ply','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_TOSC_643b3b5a-e991-4dbf-95c8-2fd609f83a8b_MODEL','14_w1_o1_maxillaire_scan_file_3.ply','e720e2f6-8dce-43f4-a5d6-bf8c09037947','{\"displayTitle\":\"Maxillaire 1.14.1.1.1\",\"modelMatrix\":\"-0.993605,0.108329,-0.0318515,0,-0.112915,-0.953254,0.280281,0,-2.27643e-10,0.282085,0.959389,0,5.50927,-20.8387,-21.3776,1\",\"title\":\"Maxillaire PLY\"}','PLY',3,'SYNCED',0,NULL,'2021-02-01 20:41:18.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.063'),('f3030b14-8ec9-4a85-a2ac-04d14a2a6ab4',662,'/var/.data/2020/662/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/occlusion_b87f1382-55d4-4e52-b63a-6f387df18b16/scan_ecd2beec-0c29-40e2-ab95-64009c33fa40/13_w4_o1_mordu_posterieur_droit_snapshot_0.png','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_SESS_b87f1382-55d4-4e52-b63a-6f387df18b16_RISC_ecd2beec-0c29-40e2-ab95-64009c33fa40_SNAPS','13_w4_o1_mordu_posterieur_droit_snapshot_0.png','f3030b14-8ec9-4a85-a2ac-04d14a2a6ab4','{\"displayTitle\":\"Mordu posterieur droit 1.13.4.1.1\",\"title\":\"Mordu posterieur droit SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-12-29 11:30:30.000','2023-06-13 12:02:10.559','2023-06-13 14:02:10.559'),('f3d5a2ce-9a80-4c06-a1b4-85bce5e716ea',662,'/var/.data/2022/662/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_129a6c33-3cca-43ab-b97a-56d0e82a546f/occlusion_b5b4db66-f433-46fb-b794-d632b8fe8e1d/scan_ed495283-b756-4052-ba8b-5fe9f9b1f8be/19_w3_o1_maxillaire_snapshot_1.png','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_129a6c33-3cca-43ab-b97a-56d0e82a546f_SESS_b5b4db66-f433-46fb-b794-d632b8fe8e1d_TOSC_ed495283-b756-4052-ba8b-5fe9f9b1f8be_SNAPS','19_w3_o1_maxillaire_snapshot_1.png','7fbf5bd8-6de6-46b1-bd50-c2480472006d','{\"displayTitle\":\"Maxillaire 1.19.3.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2022-11-02 12:30:06.000','2023-06-13 12:02:13.652','2023-06-13 14:02:13.652'),('f3f82ebd-8318-469e-9bdd-ff76223b9c1c',662,'/var/.data/2020/662/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/occlusion_d402edb5-8449-46a8-862f-a1cd1ee21cf6/scan_b7931623-9b21-4440-a950-16565249bf9a/10_w1_o1_mandibule_snapshot_0.png','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_SESS_d402edb5-8449-46a8-862f-a1cd1ee21cf6_BOSC_b7931623-9b21-4440-a950-16565249bf9a_SNAPS','10_w1_o1_mandibule_snapshot_0.png','f3f82ebd-8318-469e-9bdd-ff76223b9c1c','{\"displayTitle\":\"MANDIBULE 1.10.1.1.2\",\"title\":\"MANDIBULE SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-30 19:47:40.000','2023-06-13 12:02:12.449','2023-06-13 14:02:12.449'),('f500b4e0-bd2d-4992-901f-526fc78912cf',662,'/var/.data/2021/662/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_0c1ed331-8df6-482e-8dd1-508d9b190c49/occlusion_6c6bb813-840d-454a-ab1d-9232434a4500/scan_99a6d55d-de66-49eb-a717-49cb2587fbef/19_w1_o1_mordu_posterieur_droit_scan_file_0.ply','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_0c1ed331-8df6-482e-8dd1-508d9b190c49_SESS_6c6bb813-840d-454a-ab1d-9232434a4500_RISC_99a6d55d-de66-49eb-a717-49cb2587fbef_MODEL','19_w1_o1_mordu_posterieur_droit_scan_file_0.ply','f500b4e0-bd2d-4992-901f-526fc78912cf','{\"displayTitle\":\"Mordu posterieur droit 1.19.1.1.1\",\"modelMatrix\":\"0.976921,-0.211633,0.0384051,0,0.194578,0.946537,0.256535,0,-0.0881502,-0.243475,0.965774,0,0.602866,9.96784,-20.2879,1\",\"title\":\"Mordu posterieur droit PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-09-27 12:45:21.000','2023-06-13 12:02:12.516','2023-06-13 14:02:12.516'),('f574474f-dc28-462d-9251-b23591ca9bcb',662,'','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_RISC_d3a42d3d-3d98-457b-bb64-4119091b03f9_SNAPS','7_w2_o2_mordu_posterieur_droit_snapshot_0.png','f574474f-dc28-462d-9251-b23591ca9bcb','{\"displayTitle\":\"MORDU_POSTERIEUR_DROIT 1.7.2.2.1\",\"title\":\"MORDU_POSTERIEUR_DROIT SNAPSHOT\"}','PNG',0,'SYNCED',0,'2023-04-12 06:41:24.000','2020-04-15 07:37:21.000','2023-06-13 12:02:15.571','2023-06-13 14:02:15.571'),('f6615787-bb2f-4f28-b265-517b66795996',662,'','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_ec084612-67a2-4430-ae15-7fe0edeaca64_SESS_78636467-a73b-4270-8bc5-35a2664dec9d_BOSC_7f9aec2d-6246-4413-842d-78d2e0bddb1e_MODEL','2_w3_o1_mandibule_scan_file_0.ply','f6615787-bb2f-4f28-b265-517b66795996','{\"displayTitle\":\"MANDIBULE 1.2.3.1.1\",\"modelMatrix\":\"0.752992,0.641783,-0.145319,0,-0.65803,0.7344,-0.166291,0,-1.17478e-9,0.22084,0.97531,0,-15.7633,9.54111,-26.582,1\",\"title\":\"MANDIBULE PLY\"}','PLY',0,'SYNCED',0,'2023-04-12 06:41:25.000','2020-04-12 07:48:40.000','2023-06-13 12:02:15.455','2023-06-13 14:02:15.455'),('f69344e1-d52d-49da-acc5-b714cb86225d',662,'/var/.data/2020/662/b8f0b748-12f3-4798-9d93-1a7a89f0e0e1/session_64834083-3320-4687-9710-c2be0d9c7198/occlusion_d402edb5-8449-46a8-862f-a1cd1ee21cf6/scan_87a0a17a-c973-40c2-9d84-2392b0d62afb/10_w1_o1_maxillaire_scan_file_1.ply','PATIENT_b8f0b748-12f3-4798-9d93-1a7a89f0e0e1_ACT_64834083-3320-4687-9710-c2be0d9c7198_SESS_d402edb5-8449-46a8-862f-a1cd1ee21cf6_TOSC_87a0a17a-c973-40c2-9d84-2392b0d62afb_MODEL','10_w1_o1_maxillaire_scan_file_1.ply','372c807f-a172-495b-9111-e2a86808505c','{\"displayTitle\":\"Maxillaire 1.10.1.1.1\",\"modelMatrix\":\"0.998986,0.0447079,-0.005222,0,-0.0450118,0.992241,-0.115896,0,1.60927e-10,0.116014,0.993248,0,-23.3678,-6.40166,-24.3302,1\",\"title\":\"MAXILLAIRE PLY\"}','PLY',1,'SYNCED',0,NULL,'2020-04-30 19:37:47.000','2023-06-13 12:02:12.416','2023-06-13 14:02:12.416'),('f7cc8435-546b-4daa-9414-7a8a0728e9e6',662,'/var/.data/2022/662/fee63978-1be9-4cfc-a80c-44dc3616eb33/session_949fe730-88fa-4ec2-852e-dd0772ee3ee0/occlusion_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d/scan_1c6adc05-0655-4ad6-bcc9-27b0ef578ded/19_w2_o1_maxillaire_scan_file_1.zip','PATIENT_fee63978-1be9-4cfc-a80c-44dc3616eb33_ACT_949fe730-88fa-4ec2-852e-dd0772ee3ee0_SESS_ed8b4bd5-0a61-4563-b6a4-6ec124bc388d_TOSC_1c6adc05-0655-4ad6-bcc9-27b0ef578ded_MODEL','19_w2_o1_maxillaire_scan_file_1.zip','a1bc9da2-af83-43c3-8210-759800158585','{\"displayTitle\":\"Maxillaire 1.19.2.1.1\",\"modelMatrix\":\"-0.926293,0.359611,-0.112521,0,-0.376804,-0.884028,0.27661,0,4.89442e-09,0.29862,0.954372,0,9.35794,-15.8998,-26.896,1\",\"title\":\"Maxillaire ZIP\"}','ZIP',1,'SYNCED',0,NULL,'2022-06-28 20:24:13.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.085'),('f7e28eea-71d1-4771-8eaa-cbc7fd8fd17a',662,'','PATIENT_1af643c4-44fe-4ccb-b545-dbc90b47633b_ACT_1ce80886-d3f3-42d8-872a-a2eba69d0005_SESS_bef02815-bbf7-4520-882b-2396474f4bb3_LESC_c6bba495-6d1a-4da8-bb1f-852a1b1e5924_SNAPS','7_w2_o2_mordu_posterieur_gauche_snapshot_0.png','f7e28eea-71d1-4771-8eaa-cbc7fd8fd17a','{\"displayTitle\":\"MORDU_POSTERIEUR_GAUCHE 1.7.2.2.2\",\"title\":\"MORDU_POSTERIEUR_GAUCHE SNAPSHOT\"}','PNG',0,'SYNCED',0,'2023-04-12 06:41:25.000','2020-04-16 07:07:50.000','2023-06-13 12:02:15.480','2023-06-13 14:02:15.480'),('f867279f-0907-4a6e-84d2-9c1b54bb4caf',662,'/var/.data/2020/662/d41de280-8cf3-4e57-893e-cc7a010bc864/session_c59a2f65-79fe-44cd-8377-e39aa0a44171/occlusion_daf632b1-2c49-42c8-8899-0a0b2448bc3a/scan_0a606279-3c91-4220-b876-e620d1bf52f6/9_w1_o1_mandibule_scan_file_0.ply','PATIENT_d41de280-8cf3-4e57-893e-cc7a010bc864_ACT_c59a2f65-79fe-44cd-8377-e39aa0a44171_SESS_daf632b1-2c49-42c8-8899-0a0b2448bc3a_BOSC_0a606279-3c91-4220-b876-e620d1bf52f6_MODEL','9_w1_o1_mandibule_scan_file_0.ply','f867279f-0907-4a6e-84d2-9c1b54bb4caf','{\"displayTitle\":\"Mandibule 1.9.1.1.1\",\"modelMatrix\":\"0.996683,0.0795741,-0.0170367,0,-0.0813774,0.974597,-0.208659,0,-1.93374e-10,0.209354,0.97784,0,11.216,15.8367,-24.1806,1\",\"title\":\"MANDIBULE PLY\"}','PLY',0,'SYNCED',0,NULL,'2020-04-18 09:32:12.000','2023-06-13 12:02:10.599','2023-06-13 14:02:10.599'),('f880f49e-bb57-430d-8212-dcb8e015569f',662,'/var/.data/2021/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_3d3ae697-dc08-4ce2-8b32-4f79891607c2/21_w1_o1_mordu_anterieur_scan_file_0.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_FRSC_3d3ae697-dc08-4ce2-8b32-4f79891607c2_MODEL','21_w1_o1_mordu_anterieur_scan_file_0.zip','f880f49e-bb57-430d-8212-dcb8e015569f','{\"displayTitle\":\"Mordu anterieur 1.21.1.1.1\",\"modelMatrix\":\"0.856881,0.0586008,0.514973,0,-0.0462075,0.997315,0.0174852,0,-0.514443,-0.0544124,0.857029,0,-1.9678,-1.04274,-24.7967,1\",\"title\":\"Mordu anterieur ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2021-11-22 12:49:43.000','2023-06-13 12:02:12.846','2023-06-13 14:02:12.846'),('f8d60891-9893-425b-9839-c04fdf0d0cd5',662,'/var/.data/2021/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_3d2141bb-462c-4334-b177-d17d136574ae/occlusion_52372fba-991e-4b09-abce-2195e775fd19/scan_9716867f-e0a3-478a-a498-1e84ae803044/21_w1_o1_mordu_posterieur_gauche_snapshot_1.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_3d2141bb-462c-4334-b177-d17d136574ae_SESS_52372fba-991e-4b09-abce-2195e775fd19_LESC_9716867f-e0a3-478a-a498-1e84ae803044_SNAPS','21_w1_o1_mordu_posterieur_gauche_snapshot_1.png','ca0a9826-3f91-4aaf-984b-889d4cff43a5','{\"displayTitle\":\"Mordu posterieur gauche 1.21.1.1.1\",\"title\":\"Mordu posterieur gauche SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2021-11-22 12:47:33.000','2023-06-13 12:02:12.888','2023-06-13 14:02:12.888'),('f9419645-8fbf-4bf1-99ba-df5bd8485ab2',662,'/var/.data/2022/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_87965ef8-01eb-4830-8e8b-8b99ece62cf1/occlusion_dce9ce0f-0933-4c98-af84-59e2b6395f8f/scan_bd51414b-f96e-4903-a2e2-44fb3189decd/21_w2_o1_mandibule_snapshot_4.png','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_87965ef8-01eb-4830-8e8b-8b99ece62cf1_SESS_dce9ce0f-0933-4c98-af84-59e2b6395f8f_BOSC_bd51414b-f96e-4903-a2e2-44fb3189decd_SNAPS','21_w2_o1_mandibule_snapshot_4.png','160153e9-3248-4a6b-b0ff-a10c2c1acfc9','{\"displayTitle\":\"Mandibule 1.21.2.1.1\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',4,'SYNCED',0,NULL,'2022-06-27 21:02:19.000','2023-06-13 12:02:13.366','2023-06-13 14:02:13.366'),('f967ed2c-cc61-428f-8d34-99152f99ce47',662,'/var/.data/2021/662/f15cb858-4f0b-44ec-a017-5e662039ba19/session_72b7a457-e38f-4535-8eba-6c98b43e5e55/occlusion_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c/scan_be9a4ba5-715b-4547-a31d-66621ec7b17f/14_w2_o1_maxillaire_snapshot_1.png','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_72b7a457-e38f-4535-8eba-6c98b43e5e55_SESS_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c_TOSC_be9a4ba5-715b-4547-a31d-66621ec7b17f_SNAPS','14_w2_o1_maxillaire_snapshot_1.png','13fa1125-c9d0-498d-bc50-68dc9f4f1beb','{\"displayTitle\":\"Maxillaire 1.14.2.1.1\",\"title\":\"Maxillaire SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2021-06-08 20:16:28.000','2023-04-11 19:02:23.476','2023-04-12 06:40:02.069'),('faa7f2df-9772-4aef-b228-35b51fb8134d',662,'','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_c47ee4d9-c646-4836-8152-fc2ded70b4fe_SESS_1ec1f707-d702-496a-b2f0-e55b08c06dcb_BOSC_e99b1c89-977c-4836-9719-ad6d9a6f6aae_MODEL','14_w1_o1_mandibule_scan_file_0.ply','faa7f2df-9772-4aef-b228-35b51fb8134d','{\"displayTitle\":\"Mandibule 1.14.1.1.1\",\"modelMatrix\":\"-0.593133,0.801857,-0.0722353,0,-0.805104,-0.590741,0.0532169,0,-9.08667e-10,0.0897216,0.995967,0,7.82346,-3.37671,-22.4736,1\",\"title\":\"Mandibule PLY\"}','PLY',0,'SYNCED',0,'2023-04-12 06:41:26.000','2021-02-01 21:04:33.000','2023-06-13 12:02:09.671','2023-06-13 14:02:09.671'),('fad00b24-cf95-4da0-aa56-8c7af1870289',662,'/var/.data/2022/662/d257a7d0-47c8-46ca-9ff9-36e466d2dff8/session_848b25bd-90a8-4105-871d-f9326fe94c7b/occlusion_ba7da56a-5a10-4378-a887-8e98aa892a3c/scan_b002027b-930d-4b96-a687-453aeea5659e/21_w6_o1_maxillaire_scan_file_0.zip','PATIENT_d257a7d0-47c8-46ca-9ff9-36e466d2dff8_ACT_848b25bd-90a8-4105-871d-f9326fe94c7b_SESS_ba7da56a-5a10-4378-a887-8e98aa892a3c_TOSC_b002027b-930d-4b96-a687-453aeea5659e_MODEL','21_w6_o1_maxillaire_scan_file_0.zip','fad00b24-cf95-4da0-aa56-8c7af1870289','{\"displayTitle\":\"Maxillaire 1.21.6.1.1\",\"modelMatrix\":\"-0.993498,0.107491,-0.0375098,0,-0.113848,-0.938026,0.327331,0,3.21676e-09,0.329473,0.944165,0,15.3118,-13.6134,-24.5266,1\",\"title\":\"Maxillaire ZIP\"}','ZIP',0,'SYNCED',0,NULL,'2022-12-21 12:09:25.000','2023-06-13 12:02:14.980','2023-06-13 14:02:14.980'),('fb86258d-e165-4e8e-a22f-d60bf23a6d59',662,'/var/.data/2020/662/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_a18ca6df-d765-4c6a-be28-13abd1c350af/scan_d36d186b-d0da-4aea-af1a-4613f67b2fa0/6_w1_o2_mordu_posterieur_gauche_snapshot_0.png','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_a18ca6df-d765-4c6a-be28-13abd1c350af_LESC_d36d186b-d0da-4aea-af1a-4613f67b2fa0_SNAPS','6_w1_o2_mordu_posterieur_gauche_snapshot_0.png','fb86258d-e165-4e8e-a22f-d60bf23a6d59','{\"displayTitle\":\"Mordu posterieur gauche 1.6.1.2.1\",\"title\":\"MORDU_POSTERIEUR_GAUCHE SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-17 11:17:41.000','2023-06-13 12:02:10.313','2023-06-13 14:02:10.313'),('fd2b02c7-bcd5-4774-9809-1da5d2dd2ad0',662,'','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_cb9d8495-b4dd-423f-a624-7cff70e4db55_SESS_2b934532-4b04-4025-8e7f-894c9c01b184_BOSC_0b6ec729-5c4e-4869-9d67-6377923ed207_SNAPS','2_w2_o3_mandibule_snapshot_0.png','fd2b02c7-bcd5-4774-9809-1da5d2dd2ad0','{\"displayTitle\":\"MANDIBULE 1.2.2.3.1\",\"title\":\"MANDIBULE SNAPSHOT\"}','PNG',0,'SYNCED',0,'2023-04-12 06:41:27.000','2020-04-07 07:26:12.000','2023-06-13 12:02:15.098','2023-06-13 14:02:15.098'),('fe5b0b87-b40b-40f8-a762-d9fc8f4a87a6',662,'/var/.data/2021/662/615ede1a-dba9-4251-9e9e-6cbbd3041fdc/session_76dcd1f0-f6c7-480f-b07b-441679345d70/occlusion_c6fffa68-cc65-471a-a58e-135ebe4d0772/scan_e6e5d8c5-2d8c-48d0-9708-e3256202d385/15_w1_o1_mandibule_snapshot_1.png','PATIENT_615ede1a-dba9-4251-9e9e-6cbbd3041fdc_ACT_76dcd1f0-f6c7-480f-b07b-441679345d70_SESS_c6fffa68-cc65-471a-a58e-135ebe4d0772_BOSC_e6e5d8c5-2d8c-48d0-9708-e3256202d385_SNAPS','15_w1_o1_mandibule_snapshot_1.png','d0155fb7-667e-4f4e-be6a-1eacb81ecb13','{\"displayTitle\":\"Mandibule 1.15.1.1.1\",\"title\":\"Mandibule SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2021-02-16 12:48:00.000','2023-06-13 12:02:09.729','2023-06-13 14:02:09.729'),('fe6fbf6c-0ee6-4b36-8e65-ca271a0819f0',662,'','PATIENT_406a8572-4b0f-480a-ad2e-daf5530143b6_ACT_ec084612-67a2-4430-ae15-7fe0edeaca64_SESS_2ed4960a-e6fa-46de-a306-32385df3346c_BOSC_45b21304-1129-40a2-b60e-d72a2bf96e72_MODEL','2_w3_o2_mandibule_scan_file_1.ply','a41e073f-d40b-4f4f-924e-2afd61ac4f8c','{\"displayTitle\":\"MANDIBULE 1.2.3.2.1\",\"modelMatrix\":\"0.999942,0.00945957,-0.00509127,0,-0.0107426,0.880511,-0.473904,0,2.56906e-10,0.473931,0.880562,0,-6.69436,17.075,-28.4147,1\",\"title\":\"MANDIBULE PLY\"}','PLY',1,'SYNCED',0,'2023-04-12 06:41:27.000','2020-04-12 08:05:48.000','2023-06-13 12:02:15.180','2023-06-13 14:02:15.180'),('ff1d5097-67d0-49a8-b7ee-d5cbee5bd5df',662,'/var/.data/2020/662/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_a18ca6df-d765-4c6a-be28-13abd1c350af/scan_65315958-b964-4f7e-a111-9c7695d8092b/6_w1_o2_mordu_posterieur_droit_snapshot_0.png','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_a18ca6df-d765-4c6a-be28-13abd1c350af_RISC_65315958-b964-4f7e-a111-9c7695d8092b_SNAPS','6_w1_o2_mordu_posterieur_droit_snapshot_0.png','ff1d5097-67d0-49a8-b7ee-d5cbee5bd5df','{\"displayTitle\":\"Mordu posterieur droit 1.6.1.2.1\",\"title\":\"MORDU_POSTERIEUR_DROIT SNAPSHOT\"}','PNG',0,'SYNCED',0,NULL,'2020-04-17 11:14:14.000','2023-06-13 12:02:10.337','2023-06-13 14:02:10.337'),('ff42f199-4210-43da-bfae-3dc172610fff',662,'/var/.data/2021/662/f15cb858-4f0b-44ec-a017-5e662039ba19/session_72b7a457-e38f-4535-8eba-6c98b43e5e55/occlusion_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c/scan_437ef945-eb42-4841-9b20-34804bd5cfd6/14_w2_o1_mandibule_scan_file_0.ply','PATIENT_f15cb858-4f0b-44ec-a017-5e662039ba19_ACT_72b7a457-e38f-4535-8eba-6c98b43e5e55_SESS_16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c_BOSC_437ef945-eb42-4841-9b20-34804bd5cfd6_MODEL','14_w2_o1_mandibule_scan_file_0.ply','ff42f199-4210-43da-bfae-3dc172610fff','{\"displayTitle\":\"Mandibule 1.14.2.1.2\",\"modelMatrix\":\"-0.310914,0.867126,-0.389134,0,-0.950438,-0.28366,0.127296,0,-1.1002e-9,0.409426,0.912343,0,3.56376,-7.70516,-17.4893,1\",\"title\":\"Mandibule PLY\"}','PLY',0,'SYNCED',0,NULL,'2021-06-08 20:38:08.000','2023-06-13 12:02:12.280','2023-06-13 14:02:12.280'),('ff9a5767-77f0-4ea4-80de-642c5142026c',662,'/var/.data/2020/662/5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda/session_bb2e4d25-46eb-48d2-80af-41639e464a04/occlusion_a18ca6df-d765-4c6a-be28-13abd1c350af/scan_cb1d5d31-89cd-4ab4-bada-dc6b2235cac5/6_w1_o2_maxillaire_scan_file_1.ply','PATIENT_5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda_ACT_bb2e4d25-46eb-48d2-80af-41639e464a04_SESS_a18ca6df-d765-4c6a-be28-13abd1c350af_TOSC_cb1d5d31-89cd-4ab4-bada-dc6b2235cac5_MODEL','6_w1_o2_maxillaire_scan_file_1.ply','58f5907e-16f5-4910-b9e6-81046fdd76df','{\"displayTitle\":\"Maxillaire 1.6.1.2.1\",\"modelMatrix\":\"-0.489558,0.864252,-0.115762,0,-0.871971,-0.485224,0.0649935,0,1.46347e-9,0.13276,0.991148,0,-1.52736,-20.4441,-26.9671,1\",\"title\":\"MAXILLAIRE PLY\"}','PLY',1,'SYNCED',0,NULL,'2020-04-17 11:04:13.000','2023-06-13 12:02:10.287','2023-06-13 14:02:10.287'),('ffd40c66-bdac-4ae5-8460-6b5fe127d9e0',662,'/var/.data/2020/662/5cd08749-129b-49e3-85b9-abee157177a4/session_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c/occlusion_b87f1382-55d4-4e52-b63a-6f387df18b16/scan_534cca35-8182-4f61-aa57-03bad8172eac/13_w4_o1_mordu_anterieur_snapshot_1.png','PATIENT_5cd08749-129b-49e3-85b9-abee157177a4_ACT_b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c_SESS_b87f1382-55d4-4e52-b63a-6f387df18b16_FRSC_534cca35-8182-4f61-aa57-03bad8172eac_SNAPS','13_w4_o1_mordu_anterieur_snapshot_1.png','b9175f0f-b250-4ae3-b56c-51f5a10c10db','{\"displayTitle\":\"Mordu anterieur 1.13.4.1.1\",\"title\":\"Mordu anterieur SNAPSHOT\"}','PNG',1,'SYNCED',0,NULL,'2020-12-29 11:37:09.000','2023-06-13 12:02:12.151','2023-06-13 14:02:12.151');
/*!40000 ALTER TABLE `File` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `MessageStatus`
--

DROP TABLE IF EXISTS `MessageStatus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `MessageStatus` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `sentMessageId` varchar(36) NOT NULL,
  `contactId` varchar(36) NOT NULL,
  `status` enum('UNDELIVERED','DELIVERED','TRANSMITTED') NOT NULL DEFAULT 'UNDELIVERED',
  `bcc` tinyint(1) NOT NULL DEFAULT '0',
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  PRIMARY KEY (`sentMessageId`,`contactId`),
  KEY `ownerId` (`ownerId`),
  KEY `contactId` (`contactId`),
  CONSTRAINT `MessageStatus_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `MessageStatus_ibfk_2` FOREIGN KEY (`sentMessageId`) REFERENCES `SentMessage` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `MessageStatus_ibfk_3` FOREIGN KEY (`contactId`) REFERENCES `Contact` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `MessageStatus`
--

LOCK TABLES `MessageStatus` WRITE;
/*!40000 ALTER TABLE `MessageStatus` DISABLE KEYS */;
INSERT INTO `MessageStatus` VALUES (662,'0044629b-c48a-4f47-95b1-f178384b2b25','08ea1d0b-73cb-4462-acdd-d58c09bde03a','TRANSMITTED',0,'2022-11-02 17:43:36.000'),(662,'092ae2c6-d903-11ed-9278-00d86184ce0e','08ea1d0b-73cb-4462-acdd-d58c09bde03a','DELIVERED',0,'2023-04-12 07:24:24.409'),(662,'0fc3bc59-0e74-46f1-9d1b-4edee6fffcc3','08ea1d0b-73cb-4462-acdd-d58c09bde03a','DELIVERED',0,'2022-06-27 19:35:56.000'),(662,'18cb70e0-eb87-4a95-b5d9-b5e39616e0e8','e65a3983-26d3-437e-9f3a-9ec54fa23fbe','TRANSMITTED',0,'2020-04-30 18:44:40.000'),(662,'23ab56bc-8ef1-4eb4-92c0-3f4eb41aa456','08ea1d0b-73cb-4462-acdd-d58c09bde03a','TRANSMITTED',0,'2021-09-27 12:02:21.000'),(662,'2ac5c4e8-2400-4099-bdff-66744db946c7','08ea1d0b-73cb-4462-acdd-d58c09bde03a','TRANSMITTED',0,'2021-10-12 12:40:31.000'),(662,'2d372f67-16da-4c22-a951-9f22b14b8a00','e65a3983-26d3-437e-9f3a-9ec54fa23fbe','DELIVERED',0,'2020-05-01 06:23:31.000'),(662,'41ad7d4a-f203-41dd-a78f-61f850f52110','e65a3983-26d3-437e-9f3a-9ec54fa23fbe','DELIVERED',0,'2020-05-01 06:31:27.000'),(662,'465925b7-af46-4fc1-9b89-8f9ef2a8753b','e65a3983-26d3-437e-9f3a-9ec54fa23fbe','TRANSMITTED',0,'2020-04-10 07:27:05.000'),(662,'5c3a887b-5354-4dce-a930-c0bf04c73c86','08ea1d0b-73cb-4462-acdd-d58c09bde03a','TRANSMITTED',0,'2020-04-15 06:51:48.000'),(662,'5d7fb378-e627-43df-a59e-10bf6266bc54','08ea1d0b-73cb-4462-acdd-d58c09bde03a','DELIVERED',0,'2021-11-22 11:51:41.000'),(662,'5ec46a14-9328-4345-bf9e-2a103a14fd9f','e65a3983-26d3-437e-9f3a-9ec54fa23fbe','TRANSMITTED',0,'2020-04-30 18:44:40.000'),(662,'6a667e6c-44c0-4842-8b31-ab3873ddf15b','08ea1d0b-73cb-4462-acdd-d58c09bde03a','TRANSMITTED',0,'2020-04-17 05:56:52.000'),(662,'76a19cfc-ee2e-426f-b476-ac85c20f660d','08ea1d0b-73cb-4462-acdd-d58c09bde03a','DELIVERED',0,'2020-04-13 05:32:16.000'),(662,'7fb08821-81d8-4569-9f19-ef8022fea368','08ea1d0b-73cb-4462-acdd-d58c09bde03a','TRANSMITTED',0,'2022-08-06 11:59:41.000'),(662,'8aa64af3-968d-45f4-b276-c5dbd500e07a','e65a3983-26d3-437e-9f3a-9ec54fa23fbe','DELIVERED',0,'2020-07-13 17:47:50.000'),(662,'9243b91d-921e-40a3-a88d-f1a14409a45a','08ea1d0b-73cb-4462-acdd-d58c09bde03a','TRANSMITTED',0,'2021-11-23 11:24:44.000'),(662,'928854eb-377d-4b8b-8ea6-eeb3057a66b9','0c639fb7-3c3a-493f-ac8c-2bd4fb7c8ede','DELIVERED',0,'2023-04-12 04:41:30.486'),(662,'92b54835-b001-4b26-a4eb-900f8c7ebd11','08ea1d0b-73cb-4462-acdd-d58c09bde03a','TRANSMITTED',0,'2020-04-15 06:27:59.000'),(662,'93c345d1-454a-42fa-bfa7-8d68827d23f5','08ea1d0b-73cb-4462-acdd-d58c09bde03a','DELIVERED',0,'2023-03-21 11:31:05.000'),(662,'9c5638bd-fe4f-41c6-a7a7-5c3c908a9555','08ea1d0b-73cb-4462-acdd-d58c09bde03a','TRANSMITTED',0,'2020-04-13 05:32:16.000'),(662,'9c8474e3-ae2e-4f02-af12-ee8d56ae6406','08ea1d0b-73cb-4462-acdd-d58c09bde03a','TRANSMITTED',0,'2022-06-28 18:41:11.000'),(662,'b43015be-893c-4d0c-8657-1cd6c0eadc67','08ea1d0b-73cb-4462-acdd-d58c09bde03a','TRANSMITTED',0,'2020-04-13 05:32:17.000'),(662,'b77a9c9d-2d03-4860-b7b9-86e311c509ed','08ea1d0b-73cb-4462-acdd-d58c09bde03a','TRANSMITTED',0,'2022-09-14 10:25:51.000'),(662,'bac96ac3-3fbd-4776-96d5-a1fcf7139710','08ea1d0b-73cb-4462-acdd-d58c09bde03a','TRANSMITTED',0,'2023-01-11 12:47:52.000'),(662,'c13ba56c-2431-4f83-a199-a713f2029337','08ea1d0b-73cb-4462-acdd-d58c09bde03a','TRANSMITTED',0,'2022-12-21 11:18:10.000'),(662,'c2d88917-09e1-11ee-b558-229278a3c906','25312481-3ad2-4523-ae5f-0b5303fca7f1','DELIVERED',0,'2023-06-13 11:59:35.711'),(662,'d3010d97-e435-4fa5-9054-e4add927b37f','08ea1d0b-73cb-4462-acdd-d58c09bde03a','TRANSMITTED',0,'2022-11-04 11:40:23.000'),(662,'de057ea0-5a8b-4969-8ceb-44a19644bb0d','08ea1d0b-73cb-4462-acdd-d58c09bde03a','TRANSMITTED',0,'2020-04-13 05:59:31.000'),(662,'f0e9fe66-4717-4100-b61c-0cac7c9b76c3','08ea1d0b-73cb-4462-acdd-d58c09bde03a','TRANSMITTED',0,'2022-01-11 11:43:43.000');
/*!40000 ALTER TABLE `MessageStatus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Occlusion`
--

DROP TABLE IF EXISTS `Occlusion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Occlusion` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `sessionId` varchar(36) DEFAULT NULL,
  `occlusionType` enum('UNKNOWN','HEMI_ARCADE_POSTERIEUR_DROIT','HEMI_ARCADE_POSTERIEUR_GAUCHE','HEMI_ARCADE_ANTERIEUR','ARCADE_COMPLETE_ANTERIEUR','ARCADE_COMPLETE') DEFAULT 'UNKNOWN',
  `displayId` mediumint unsigned DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `comments` text,
  `topScanId` varchar(36) DEFAULT NULL,
  `bottomScanId` varchar(36) DEFAULT NULL,
  `anteriorBiteScanId` varchar(36) DEFAULT NULL,
  `rightBiteScanId` varchar(36) DEFAULT NULL,
  `leftBiteScanId` varchar(36) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `sessionId` (`sessionId`),
  KEY `topScanId` (`topScanId`),
  KEY `bottomScanId` (`bottomScanId`),
  KEY `anteriorBiteScanId` (`anteriorBiteScanId`),
  KEY `rightBiteScanId` (`rightBiteScanId`),
  KEY `leftBiteScanId` (`leftBiteScanId`),
  CONSTRAINT `Occlusion_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_2` FOREIGN KEY (`sessionId`) REFERENCES `Session` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_3` FOREIGN KEY (`topScanId`) REFERENCES `Scan` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_4` FOREIGN KEY (`bottomScanId`) REFERENCES `Scan` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_5` FOREIGN KEY (`anteriorBiteScanId`) REFERENCES `Scan` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_6` FOREIGN KEY (`rightBiteScanId`) REFERENCES `Scan` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Occlusion_ibfk_7` FOREIGN KEY (`leftBiteScanId`) REFERENCES `Scan` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Occlusion`
--

LOCK TABLES `Occlusion` WRITE;
/*!40000 ALTER TABLE `Occlusion` DISABLE KEYS */;
INSERT INTO `Occlusion` VALUES ('a18ca6df-d765-4c6a-be28-13amigraoccl',662,'a18ca6df-d765-4c6a-be28-13abd1c350af','UNKNOWN',1,0,'','cb1d5d31-89cd-4ab4-bada-dc6b2235cac5','37ff1278-3dd1-470a-8159-e763f6626f5d',NULL,NULL,NULL,'2020-11-23 21:19:36.000',NULL,'2020-11-23 21:19:36.000','2023-06-13 12:02:16.221','2023-06-13 14:02:16.221'),('bdf42f40-5a7a-435b-a5e0-eb3migraoccl',662,'bdf42f40-5a7a-435b-a5e0-eb33efefbc97','UNKNOWN',1,0,'','2d566d37-f38f-4b79-ac8f-48009ae22310','de216c91-485b-4dac-9e7c-b89075739521',NULL,NULL,NULL,'2020-11-23 21:19:36.000',NULL,'2020-11-23 21:19:36.000','2023-06-13 12:02:16.261','2023-06-13 14:02:16.261'),('c4999e75-8b1c-4a31-8e80-9b9cba9b57fd',662,'5f895907-3eed-4aa7-995a-f7e1c9661a0a','HEMI_ARCADE_ANTERIEUR',1,0,'','802e2d49-5b37-47b7-b8e9-4fb4bff1f62f','26a765d3-8b92-4861-984a-bd9c8040209b','d04345c3-df70-4e2a-b197-cc37138e6700',NULL,NULL,'2022-06-27 21:32:30.000',NULL,'2022-03-11 11:16:26.000','2023-06-13 12:02:16.328','2023-06-13 14:02:16.328');
/*!40000 ALTER TABLE `Occlusion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `OcclusionFile`
--

DROP TABLE IF EXISTS `OcclusionFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `OcclusionFile` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `occlusionId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('RESULT','MANDIBLE','MAXILLARY','MANDIBLE_SB','MAXILLARY_SB','MANDIBLE_PRE','MAXILLARY_PRE','LIFI','LIFIMETA','SNAPSHOT','SCREENSHOT') DEFAULT 'RESULT',
  PRIMARY KEY (`occlusionId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `OcclusionFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `OcclusionFile_ibfk_2` FOREIGN KEY (`occlusionId`) REFERENCES `Occlusion` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `OcclusionFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `OcclusionFile`
--

LOCK TABLES `OcclusionFile` WRITE;
/*!40000 ALTER TABLE `OcclusionFile` DISABLE KEYS */;
INSERT INTO `OcclusionFile` VALUES (662,'a18ca6df-d765-4c6a-be28-13amigraoccl','29d00f37-e846-46c5-bfea-08ec3e95b455','MAXILLARY'),(662,'a18ca6df-d765-4c6a-be28-13amigraoccl','931bf3dd-fe07-4981-8ede-599f357c3c60','MANDIBLE'),(662,'a18ca6df-d765-4c6a-be28-13amigraoccl','b58b7bd8-eb47-4d54-9228-ce3a9e6486fd','SNAPSHOT'),(662,'bdf42f40-5a7a-435b-a5e0-eb3migraoccl','5c922725-b41b-4e38-a244-6a9a320d291e','MANDIBLE'),(662,'bdf42f40-5a7a-435b-a5e0-eb3migraoccl','675a601d-d389-403d-858d-555ff6166630','SNAPSHOT'),(662,'bdf42f40-5a7a-435b-a5e0-eb3migraoccl','b25a25e2-610a-466d-a4d8-7518a09b9a78','MAXILLARY'),(662,'c4999e75-8b1c-4a31-8e80-9b9cba9b57fd','30e96914-828b-4376-9eeb-077529a3422d','MAXILLARY'),(662,'c4999e75-8b1c-4a31-8e80-9b9cba9b57fd','6b4f036d-deed-43fa-b8c0-889e20bb7692','MANDIBLE'),(662,'c4999e75-8b1c-4a31-8e80-9b9cba9b57fd','83547739-e794-48fb-befb-bed604c04b8f','SNAPSHOT');
/*!40000 ALTER TABLE `OcclusionFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Office`
--

DROP TABLE IF EXISTS `Office`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Office` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `mainPhone` varchar(45) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `cityName` varchar(255) DEFAULT NULL,
  `cityZip` varchar(25) DEFAULT NULL,
  `address` text,
  `country` varchar(75) DEFAULT NULL,
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  CONSTRAINT `Office_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Office`
--

LOCK TABLES `Office` WRITE;
/*!40000 ALTER TABLE `Office` DISABLE KEYS */;
INSERT INTO `Office` VALUES ('07a4901a-a73e-414b-bafe-ff42d883049b',3,'542138759','Condor','','Labège','31670','137 rue Garance','France',NULL,'2019-07-01 14:13:31.000','2019-07-01 12:13:31.000','2019-07-01 14:13:31.000'),('12faf4c9-95d6-4c4f-b641-481c29111d9a',7,'0664864059','DENTAL CUB','','MERIGNAC','33700','10 av jean mazaryck,','France',NULL,'2019-07-09 11:35:13.000','2019-07-09 09:35:13.000','2019-07-09 11:35:13.000'),('179ab10a-4b77-4b31-a7c1-386f7e9d1cef',224,'0660850205','Cabinet (default)','','LABEGE','','RUE GARANCE','France',NULL,'2019-09-09 15:36:36.000','2019-09-09 13:36:36.000','2019-09-09 15:36:36.000'),('2b013106-e8d3-47fc-acc7-88af8cd33ced',1081,'0673917531','','','MURET','','','France',NULL,'2022-09-19 14:34:53.000','2022-09-19 13:16:49.000','2022-09-19 15:16:49.000'),('3d7661f6-e77c-493d-9c2d-45d83cac165e',355,'+390521221362','GIANLUCA DALLATANA','www.uniontech.it','Parma','43122','Rocco Bormioli, 5/A','Italia',NULL,'2019-10-23 12:56:54.000','2019-10-23 10:56:54.000','2019-10-23 12:56:54.000'),('544e3fb2-5e62-472f-b606-7185054c1396',9,'0149698526','Laboratoire LDA','www.laboratoirelda.com','Villiers Sur Marne','94350','1 rue de la fraternité','France',NULL,'2019-07-02 11:36:03.000','2019-07-02 09:36:03.000','2019-07-02 11:36:03.000'),('55f46aac-286b-487d-9bd0-18edca00c470',662,'0561569557','BATAILLE Philippe','','MURET','31600','48 route d\'Eaunes','France',NULL,'2020-04-06 09:36:52.000','2020-04-06 07:36:52.000','2020-04-06 09:36:52.000'),('5d22dd41-4a03-4813-a2a3-86598c1101c0',172,'0559830648','SELARL du Dr Franck LE BOURHIS','','LAROIN','64110','4 Chemin Couralis','France',NULL,'2019-01-21 17:43:09.000','2019-08-19 15:44:04.000','2019-08-19 17:44:04.000'),('5e42d964-fa5c-4aac-b7ee-0cf0d98d7666',339,'0659598581','Cabinet (default)','','Paris','','','France',NULL,'2019-10-11 20:04:31.000','2019-10-15 08:41:09.000','2019-10-15 10:41:09.000'),('60100516-06c3-4737-a33b-8fba3b71bd66',155,'0241437031','LEMOUEL SAS','www.laboratoire-lemouel.fr','ECOUFLANT','49000','22 BOULEVARD DE L INDUSTRIE, ZI ECOUFLANT','France',NULL,'2019-08-27 14:26:48.000','2019-08-27 12:26:48.000','2019-08-27 14:26:48.000'),('8c4a7314-8b79-4f22-aeba-b48e799bb261',317,'0382254814','Cabinet (default)','','LONGWY','','','France',NULL,'2019-10-07 14:44:35.000','2019-12-09 10:58:34.000','2019-12-09 11:58:34.000'),('a1984274-1ad9-41d4-b536-d4407f8fca00',6,'0491776127','Cabinet (default)','','Marseille','','','France',NULL,'2019-07-02 11:05:21.000','2019-07-07 04:24:25.000','2019-07-07 06:24:25.000'),('ac14fa6c-ded0-4127-8d99-c18fee62921e',59,'0475490647','Cabinet (default)','','LE TEIL','','','France',NULL,'2019-07-17 14:12:08.000','2019-09-05 15:19:00.000','2019-09-05 17:19:00.000'),('b9db0008-e73d-4e5a-ac76-2c93df3250ae',689,'04 79 26 15 66','Cabinet (default)','','CHAMBERY','73000','1 Place de la Libération','France',NULL,'2020-11-03 08:32:27.000','2020-11-03 07:32:27.000','2020-11-03 08:32:27.000'),('bf407538-bec8-49af-b04a-68926a6b1a6e',1,'123322332','Labege','','Labege','31670','Labege','France',NULL,'2019-06-28 18:00:23.000','2019-06-28 16:00:23.000','2019-06-28 18:00:23.000'),('c54ab53e-cc43-42dd-a0f6-824b6dc657ad',8,'0664143389','LABEL DENT','','MERIGNAC','','10 AV JAN MASARYK','France',NULL,'2019-07-22 16:59:15.000','2019-07-22 14:59:15.000','2019-07-22 16:59:15.000'),('dc905db3-c0a3-44b2-a0f3-f3c08fdd6bb7',193,'0663713747','Cabinet (default)','','VIRIAT ','','','France',NULL,'2019-09-02 18:53:02.000','2019-09-05 19:11:53.000','2019-09-05 21:11:53.000'),('e3435e0c-2009-491c-a29a-a7e0848b2dda',663,'0624725921','Laboratoire maylin ','','Bruguieres','31150','23 rue de la plaine','France',NULL,'2020-04-09 15:10:42.000','2020-04-09 13:10:42.000','2020-04-09 15:10:42.000'),('e563f7db-c71c-416d-a74d-2b979f6eade2',5,'0388334408','LABORATOIRE DENTAL BIOTECH','https://laboratoire-labeldent.fr/','WOLFISHEIM','67202','5 impasse Joffre','France',NULL,'2021-04-21 14:26:48.000','2021-04-21 12:26:48.000','2021-04-21 14:26:48.000'),('f841d3b8-276b-4ad1-859c-ba7e25ffe059',2,'056139839','condor','','LABEGE','31670','137 rue garance','France',NULL,'2019-07-01 08:54:35.000','2019-07-01 06:54:35.000','2019-07-01 08:54:35.000');
/*!40000 ALTER TABLE `Office` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PersonInfo`
--

DROP TABLE IF EXISTS `PersonInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PersonInfo` (
  `uuid` varchar(36) NOT NULL,
  `firstname` varchar(64) NOT NULL,
  `lastname` varchar(64) NOT NULL,
  `email` varchar(255) NOT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PersonInfo`
--

LOCK TABLES `PersonInfo` WRITE;
/*!40000 ALTER TABLE `PersonInfo` DISABLE KEYS */;
INSERT INTO `PersonInfo` VALUES ('00000001-0000-0000-0000-000000000001','labege','julien','si@condorscan.pro','2022-06-27 19:16:27.000',NULL),('00000002-0000-0000-0000-000000000001','Sophie','MOURIGAL','sophie.mourigal@condorscan.pro','2022-06-27 19:16:27.000',NULL),('00000003-0000-0000-0000-000000000001','Thomas','Besson','thomas.besson@condorscan.pro','2022-06-27 19:16:27.000',NULL),('00000005-0000-0000-0000-000000000001','Dental Biotech Strasbourg','Laboratoire','cfao@dentalbiotech.fr','2022-03-31 17:40:19.000','2023-06-13 14:02:16.703'),('00000006-0000-0000-0000-000000000001','Gilles','Philip','laboratoirephilip@yahoo.fr','2022-03-31 17:40:19.000','2023-06-13 14:02:16.628'),('00000007-0000-0000-0000-000000000001','DENTAL CUB','LABORATOIRE','cfao@dentalcub.fr','2022-03-31 17:40:19.000','2023-06-13 14:02:16.600'),('00000008-0000-0000-0000-000000000001','LABEL DENT','LABORATOIRE','label.dent@orange.fr','2022-03-31 17:40:19.000','2023-06-13 14:02:16.571'),('00000009-0000-0000-0000-000000000001','Laboratoire','LDA','cfao@laboratoirelda.com','2022-03-31 17:40:19.000','2023-06-13 14:02:16.543'),('00000059-0000-0000-0000-000000000001','RIEUX  ','LABORATOIRE','laboratoire-rieux@orange.fr','2022-06-27 19:16:27.000',NULL),('00000155-0000-0000-0000-000000000001','LEMOUEL','LABORATOIRE','lemouel@aol.com','2022-06-27 19:16:27.000',NULL),('00000172-0000-0000-0000-000000000001','Franck','Dr LE BOURHIS','francklebourhis@gmail.com','2022-06-27 19:16:27.000',NULL),('00000193-0000-0000-0000-000000000001','ADT Prothèses Dentaires','Laboratoire ','taponard.sebastien@yahoo.fr','2022-06-27 19:16:27.000',NULL),('00000224-0000-0000-0000-000000000001','Muriel','LIMONDIN','muriel.limondin@condorscan.pro','2022-06-27 19:16:27.000',NULL),('00000317-0000-0000-0000-000000000001','Herblot & Moreau','Laboratoire ','contact@ldhm.fr','2022-06-27 19:16:27.000',NULL),('00000339-0000-0000-0000-000000000001','Léopold','Lanne','prod@3dcelo.com','2022-06-27 19:16:27.000',NULL),('00000355-0000-0000-0000-000000000001','GIANLUCA','DALLATANA','gianluca@uniontech.it','2022-06-27 19:16:27.000',NULL),('00000662-0000-0000-0000-000000000001','Philippe','BATAILLE','cabinetdestomatologie31@orange.fr','2022-03-31 17:40:19.000','2023-04-12 06:40:02.641'),('00000663-0000-0000-0000-000000000001','Michael','Maylin','laboratoire.maylin@yahoo.com','2022-03-31 17:40:19.000','2023-06-13 14:02:16.651'),('00000689-0000-0000-0000-000000000001','BY AXE ORTHO','SMILERS LAB','axe-ortho@outlook.fr','2022-03-31 17:40:19.000','2023-06-13 14:02:16.676'),('aacb2e20-4041-4658-8525-2f30dcbc9706','Coralie','BATAILLE','coralieb31@orange.fr','2022-09-19 13:16:49.000','2023-06-13 14:02:16.727');
/*!40000 ALTER TABLE `PersonInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PhoneInfo`
--

DROP TABLE IF EXISTS `PhoneInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `PhoneInfo` (
  `uuid` varchar(36) NOT NULL,
  `phone` varchar(45) DEFAULT NULL,
  `cellular` varchar(45) DEFAULT NULL,
  `fax` varchar(45) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PhoneInfo`
--

LOCK TABLES `PhoneInfo` WRITE;
/*!40000 ALTER TABLE `PhoneInfo` DISABLE KEYS */;
INSERT INTO `PhoneInfo` VALUES ('00000001-0000-0000-0000-000000000001','123322332','','','2022-06-27 19:16:27.000',NULL),('00000002-0000-0000-0000-000000000001','056139839','','','2022-06-27 19:16:27.000',NULL),('00000003-0000-0000-0000-000000000001','542138759','','','2022-06-27 19:16:27.000',NULL),('00000005-0000-0000-0000-000000000001','0388334408','','','2022-03-31 17:40:19.000','2023-06-13 14:02:16.703'),('00000006-0000-0000-0000-000000000001','0491776127','','','2022-03-31 17:40:19.000','2023-06-13 14:02:16.628'),('00000007-0000-0000-0000-000000000001','0664864059','','','2022-03-31 17:40:19.000','2023-06-13 14:02:16.600'),('00000008-0000-0000-0000-000000000001','0664143389','','','2022-03-31 17:40:19.000','2023-06-13 14:02:16.571'),('00000009-0000-0000-0000-000000000001','0149698526','','','2022-03-31 17:40:19.000','2023-06-13 14:02:16.543'),('00000059-0000-0000-0000-000000000001','0475490647','','','2022-06-27 19:16:27.000',NULL),('00000155-0000-0000-0000-000000000001','0241437031','','','2022-06-27 19:16:27.000',NULL),('00000172-0000-0000-0000-000000000001','0559830648','','','2022-06-27 19:16:27.000',NULL),('00000193-0000-0000-0000-000000000001','0663713747','','','2022-06-27 19:16:27.000',NULL),('00000224-0000-0000-0000-000000000001','0660850205','','','2022-06-27 19:16:27.000',NULL),('00000317-0000-0000-0000-000000000001','0382254814','','','2022-06-27 19:16:27.000',NULL),('00000339-0000-0000-0000-000000000001','0659598581','','','2022-06-27 19:16:27.000',NULL),('00000355-0000-0000-0000-000000000001','+390521221362','','','2022-06-27 19:16:27.000',NULL),('00000662-0000-0000-0000-000000000001','0561569557','','','2022-03-31 17:40:19.000','2023-04-12 06:40:02.641'),('00000663-0000-0000-0000-000000000001','0624725921','','','2022-03-31 17:40:19.000','2023-06-13 14:02:16.651'),('00000689-0000-0000-0000-000000000001','04 79 26 15 66','','','2022-03-31 17:40:19.000','2023-06-13 14:02:16.676'),('2e722761-91aa-4131-8304-268be5a0ae90','0673917531','','','2022-09-19 13:16:49.000','2023-06-13 14:02:16.727');
/*!40000 ALTER TABLE `PhoneInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Professional`
--

DROP TABLE IF EXISTS `Professional`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Professional` (
  `uuid` varchar(36) NOT NULL,
  `id` mediumint unsigned NOT NULL,
  `credentialsId` varchar(36) DEFAULT NULL,
  `personInfoId` varchar(36) NOT NULL,
  `phoneInfoId` varchar(36) NOT NULL,
  `addressInfoId` varchar(36) NOT NULL,
  `configId` mediumint unsigned DEFAULT NULL,
  `syncInfoId` mediumint unsigned DEFAULT NULL,
  `surgeryName` varchar(255) DEFAULT NULL,
  `comments` text,
  `type` enum('UNDEFINED','PROTHESIST','DENTIST','DEMO','OTHER') NOT NULL DEFAULT 'UNDEFINED',
  `limitedContactId` varchar(36) DEFAULT NULL,
  `directoryVisible` tinyint(1) NOT NULL DEFAULT '1',
  `statusGalaxy` tinyint(1) DEFAULT '0',
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  UNIQUE KEY `personInfoId` (`personInfoId`),
  UNIQUE KEY `phoneInfoId` (`phoneInfoId`),
  UNIQUE KEY `addressInfoId` (`addressInfoId`),
  UNIQUE KEY `credentialsId` (`credentialsId`),
  KEY `syncInfoId` (`syncInfoId`,`id`),
  KEY `configId` (`configId`,`id`),
  CONSTRAINT `Professional_ibfk_1` FOREIGN KEY (`credentialsId`) REFERENCES `Credentials` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_2` FOREIGN KEY (`personInfoId`) REFERENCES `PersonInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_3` FOREIGN KEY (`phoneInfoId`) REFERENCES `PhoneInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_4` FOREIGN KEY (`addressInfoId`) REFERENCES `AddressInfo` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_5` FOREIGN KEY (`syncInfoId`, `id`) REFERENCES `SyncInfo` (`id`, `ownerId`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Professional_ibfk_6` FOREIGN KEY (`configId`, `id`) REFERENCES `Config` (`id`, `ownerId`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Professional`
--

LOCK TABLES `Professional` WRITE;
/*!40000 ALTER TABLE `Professional` DISABLE KEYS */;
INSERT INTO `Professional` VALUES ('11644397-36f2-491f-aabf-b61c5414e0a5',1,NULL,'00000001-0000-0000-0000-000000000001','00000001-0000-0000-0000-000000000001','00000001-0000-0000-0000-000000000001',1,1,'','','DENTIST',NULL,1,0,NULL,'2019-12-19 14:57:22.000','2022-06-27 19:16:28.000','2020-01-22 17:08:26.000'),('bf19c334-c71b-4e23-9ce0-73ddec5fe103',2,'00000002-0000-0000-0000-000000000001','00000002-0000-0000-0000-000000000001','00000002-0000-0000-0000-000000000001','00000002-0000-0000-0000-000000000001',1,1,'','','DENTIST',NULL,1,0,NULL,'2020-01-23 09:02:14.000','2022-06-27 19:16:28.000','2020-01-23 09:02:15.000'),('7655b09e-027b-49c5-9b6c-832c6e41cee8',3,NULL,'00000003-0000-0000-0000-000000000001','00000003-0000-0000-0000-000000000001','00000003-0000-0000-0000-000000000001',1,1,'','','DENTIST',NULL,1,0,NULL,'2019-09-17 15:34:03.000','2022-06-27 19:16:28.000','2019-09-17 15:34:04.000'),('35997e6a-79be-404d-8b2c-46fa78f0f219',5,'00000005-0000-0000-0000-000000000001','00000005-0000-0000-0000-000000000001','00000005-0000-0000-0000-000000000001','00000005-0000-0000-0000-000000000001',1,1,'','','OTHER',NULL,1,0,NULL,'2020-02-21 15:56:57.000','2023-06-13 12:02:16.691','2023-06-13 14:02:16.703'),('372fe703-e954-4df2-a079-51315f137deb',6,'00000006-0000-0000-0000-000000000001','00000006-0000-0000-0000-000000000001','00000006-0000-0000-0000-000000000001','00000006-0000-0000-0000-000000000001',1,1,'','','OTHER',NULL,1,0,NULL,'2019-07-02 11:05:21.000','2023-06-13 12:02:16.615','2023-06-13 14:02:16.628'),('14d1a5e5-e2aa-42ab-9b88-6ff9da357d9b',7,'00000007-0000-0000-0000-000000000001','00000007-0000-0000-0000-000000000001','00000007-0000-0000-0000-000000000001','00000007-0000-0000-0000-000000000001',1,1,'','','OTHER',NULL,1,0,NULL,'2019-07-22 17:07:13.000','2023-06-13 12:02:16.588','2023-06-13 14:02:16.600'),('48539f38-473c-4be5-b635-3fb0fd42b27e',8,'00000008-0000-0000-0000-000000000001','00000008-0000-0000-0000-000000000001','00000008-0000-0000-0000-000000000001','00000008-0000-0000-0000-000000000001',1,1,'','','OTHER',NULL,1,0,NULL,'2019-07-22 19:36:25.000','2023-06-13 12:02:16.557','2023-06-13 14:02:16.571'),('1dab4f0e-ae37-4417-a649-d2a1322d368a',9,'00000009-0000-0000-0000-000000000001','00000009-0000-0000-0000-000000000001','00000009-0000-0000-0000-000000000001','00000009-0000-0000-0000-000000000001',1,1,'','','OTHER',NULL,1,0,NULL,'2019-07-11 10:05:09.000','2023-06-13 12:02:16.532','2023-06-13 14:02:16.543'),('023166d9-f822-4bb1-96cb-6fa7d892bf0b',59,NULL,'00000059-0000-0000-0000-000000000001','00000059-0000-0000-0000-000000000001','00000059-0000-0000-0000-000000000001',1,1,'','','DENTIST',NULL,1,0,NULL,'2019-07-17 14:12:08.000','2022-06-27 19:16:28.000','2019-09-05 17:29:34.000'),('1bf8fcdd-496d-4839-ba78-f2b29eda6b93',155,NULL,'00000155-0000-0000-0000-000000000001','00000155-0000-0000-0000-000000000001','00000155-0000-0000-0000-000000000001',1,1,'','','DENTIST',NULL,1,0,NULL,'2019-08-27 14:27:01.000','2022-06-27 19:16:28.000','2019-08-27 14:27:01.000'),('36701f7c-94a7-4ef6-a635-25b6dc5e0f86',172,NULL,'00000172-0000-0000-0000-000000000001','00000172-0000-0000-0000-000000000001','00000172-0000-0000-0000-000000000001',1,1,'','','DENTIST',NULL,1,0,NULL,'2020-01-22 17:49:55.000','2022-06-27 19:16:28.000','2020-01-22 17:49:56.000'),('eba81f34-ad3a-4498-b307-4af657800052',193,NULL,'00000193-0000-0000-0000-000000000001','00000193-0000-0000-0000-000000000001','00000193-0000-0000-0000-000000000001',1,1,'','','DENTIST',NULL,1,0,NULL,'2019-09-02 18:53:02.000','2022-06-27 19:16:28.000','2019-09-25 11:58:51.000'),('765081bc-b5ad-428e-bfa7-7edfee9d51a1',224,NULL,'00000224-0000-0000-0000-000000000001','00000224-0000-0000-0000-000000000001','00000224-0000-0000-0000-000000000001',1,1,'','','DENTIST',NULL,1,0,NULL,'2019-09-09 15:29:44.000','2022-06-27 19:16:28.000','2019-09-09 15:36:10.000'),('5fceb3e9-78c3-4c50-b1e1-6c0da17eb225',317,NULL,'00000317-0000-0000-0000-000000000001','00000317-0000-0000-0000-000000000001','00000317-0000-0000-0000-000000000001',1,1,'','','DENTIST',NULL,1,0,NULL,'2019-10-07 14:44:35.000','2022-06-27 19:16:28.000','2019-12-09 11:58:44.000'),('4d0904f5-35be-427c-8aa8-ded12c7970cb',339,NULL,'00000339-0000-0000-0000-000000000001','00000339-0000-0000-0000-000000000001','00000339-0000-0000-0000-000000000001',1,1,'','','DENTIST',NULL,1,0,NULL,'2019-10-11 20:04:31.000','2022-06-27 19:16:28.000','2019-10-15 10:41:17.000'),('e8b64997-f348-44d2-82fc-581fc0df922d',355,NULL,'00000355-0000-0000-0000-000000000001','00000355-0000-0000-0000-000000000001','00000355-0000-0000-0000-000000000001',1,1,'','','DENTIST',NULL,1,0,NULL,'2019-10-23 12:56:25.000','2022-06-27 19:16:28.000','2019-10-23 12:56:25.000'),('045f19a4-7d35-457a-85ae-94b33b89a0d2',662,'00000662-0000-0000-0000-000000000001','00000662-0000-0000-0000-000000000001','00000662-0000-0000-0000-000000000001','00000662-0000-0000-0000-000000000001',1,1,'','','DENTIST',NULL,1,0,NULL,'2023-04-11 20:00:22.000','2023-04-12 04:40:02.641','2023-04-12 06:40:02.641'),('62a0cd5b-b912-47da-9e1d-68364c1eaf71',663,'00000663-0000-0000-0000-000000000001','00000663-0000-0000-0000-000000000001','00000663-0000-0000-0000-000000000001','00000663-0000-0000-0000-000000000001',1,1,'','','PROTHESIST',NULL,1,0,NULL,'2020-04-09 15:10:00.000','2023-06-13 12:02:16.642','2023-06-13 14:02:16.651'),('464a0019-6c2e-403e-b0a5-f1b453741d76',689,'00000689-0000-0000-0000-000000000001','00000689-0000-0000-0000-000000000001','00000689-0000-0000-0000-000000000001','00000689-0000-0000-0000-000000000001',1,1,'','','PROTHESIST',NULL,1,0,NULL,'2020-11-03 08:29:54.000','2023-06-13 12:02:16.666','2023-06-13 14:02:16.676'),('bc46fc6a-ab20-4d4f-becb-ce8c04b6ca22',1081,'2cba8536-4bb8-45c7-b6c0-41ffc0484e0b','aacb2e20-4041-4658-8525-2f30dcbc9706','2e722761-91aa-4131-8304-268be5a0ae90','74f9692b-a496-48ca-9002-1aa1e9b3b2e6',1,1,'','','DENTIST',NULL,1,0,NULL,'2022-09-19 14:34:53.000','2023-06-13 12:02:16.716','2023-06-13 14:02:16.727');
/*!40000 ALTER TABLE `Professional` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProfessionalEnvInfos`
--

DROP TABLE IF EXISTS `ProfessionalEnvInfos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProfessionalEnvInfos` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `accessCode` varchar(45) DEFAULT NULL,
  `status` enum('CREATED','CONFIRMED','BLOCKED') NOT NULL DEFAULT 'CREATED',
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`ownerId`),
  CONSTRAINT `ProfessionalEnvInfos_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProfessionalEnvInfos`
--

LOCK TABLES `ProfessionalEnvInfos` WRITE;
/*!40000 ALTER TABLE `ProfessionalEnvInfos` DISABLE KEYS */;
INSERT INTO `ProfessionalEnvInfos` VALUES (1,NULL,'CONFIRMED','2022-06-27 19:16:28.000',NULL),(2,NULL,'CONFIRMED','2022-06-27 19:16:28.000',NULL),(3,NULL,'CONFIRMED','2022-06-27 19:16:28.000',NULL),(5,NULL,'CONFIRMED','2022-06-27 19:16:28.000','2022-06-27 21:16:28.000'),(6,NULL,'CONFIRMED','2022-06-27 19:16:28.000','2022-06-27 21:16:28.000'),(7,NULL,'CONFIRMED','2022-06-27 19:16:28.000','2022-06-27 21:16:28.000'),(8,NULL,'CONFIRMED','2022-06-27 19:16:28.000','2022-06-27 21:16:28.000'),(9,NULL,'CONFIRMED','2022-06-27 19:16:28.000','2022-06-27 21:16:28.000'),(59,NULL,'CONFIRMED','2022-06-27 19:16:28.000',NULL),(155,NULL,'CONFIRMED','2022-06-27 19:16:28.000',NULL),(172,NULL,'CONFIRMED','2022-06-27 19:16:28.000',NULL),(193,NULL,'CONFIRMED','2022-06-27 19:16:28.000',NULL),(224,NULL,'CONFIRMED','2022-06-27 19:16:28.000',NULL),(317,NULL,'CONFIRMED','2022-06-27 19:16:28.000',NULL),(339,NULL,'CONFIRMED','2022-06-27 19:16:28.000',NULL),(355,NULL,'CONFIRMED','2022-06-27 19:16:28.000',NULL),(662,NULL,'CONFIRMED','2022-06-27 19:16:28.000',NULL),(663,NULL,'CONFIRMED','2022-06-27 19:16:28.000','2022-06-27 21:16:28.000'),(689,NULL,'CONFIRMED','2022-06-27 19:16:28.000','2022-06-27 21:16:28.000'),(1081,NULL,'CONFIRMED','2022-09-19 13:16:59.000','2022-09-19 15:16:59.000');
/*!40000 ALTER TABLE `ProfessionalEnvInfos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProfessionalPatient`
--

DROP TABLE IF EXISTS `ProfessionalPatient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProfessionalPatient` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `patientId` varchar(36) NOT NULL,
  `officeId` varchar(36) DEFAULT NULL,
  `enablePatientSharing` tinyint(1) DEFAULT '0',
  `pinned` tinyint(1) NOT NULL DEFAULT '0',
  `theme` enum('NONE','ADULT','BOY','GIRL','BABY') DEFAULT 'NONE',
  PRIMARY KEY (`ownerId`,`patientId`),
  KEY `patientId` (`patientId`),
  KEY `officeId` (`officeId`),
  CONSTRAINT `ProfessionalPatient_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ProfessionalPatient_ibfk_2` FOREIGN KEY (`patientId`) REFERENCES `wow_patient`.`Patient` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ProfessionalPatient_ibfk_3` FOREIGN KEY (`officeId`) REFERENCES `Office` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProfessionalPatient`
--

LOCK TABLES `ProfessionalPatient` WRITE;
/*!40000 ALTER TABLE `ProfessionalPatient` DISABLE KEYS */;
INSERT INTO `ProfessionalPatient` VALUES (662,'03ec19f1-9f11-4710-a0cd-c5d7739e40d7','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(662,'1af643c4-44fe-4ccb-b545-dbc90b47633b','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(662,'1ff3b081-8f07-4144-87ef-af0810d5c312','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(662,'2b4f07b1-1d58-42a2-9e72-3461efd5a2d9','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(662,'35970bab-04c1-443b-9e5c-c6a127ec7a47','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(662,'3c7b9483-14ba-422a-b943-e347249b6653','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(662,'3d722760-3820-40e4-81e1-60e722c0cb01','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(662,'406a8572-4b0f-480a-ad2e-daf5530143b6','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(662,'4b9236e1-8988-4a19-97af-cd44133ee27b','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(662,'507b1d43-2b21-4296-a969-0a1223d5706d','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(662,'53c591be-aea6-491f-bc06-740bd7d9f780','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(662,'555b020e-3e4a-4263-bf03-9f8db80cc843','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(662,'5587321c-4405-49dc-90d5-8810cc776c6d','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(662,'5cd08749-129b-49e3-85b9-abee157177a4','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(662,'5fb17ffd-fd67-4cd3-9621-f35ffe4cfcda','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(662,'615ede1a-dba9-4251-9e9e-6cbbd3041fdc','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(662,'665b40ce-9690-4944-b007-4a96c1f5d57d','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(662,'94ac368a-c8ad-482d-91b4-26c8db10596d','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(662,'9977cfd4-497a-4153-ade7-6e67fc8f1938','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(662,'ae18b7e3-4cc0-4d00-81f9-c94a4a9fca07','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(662,'b8f0b748-12f3-4798-9d93-1a7a89f0e0e1','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(662,'d257a7d0-47c8-46ca-9ff9-36e466d2dff8','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'ADULT'),(662,'d41de280-8cf3-4e57-893e-cc7a010bc864','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(662,'d485e5a2-11e0-4863-b612-22d245d07d04','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(662,'e27b6130-520e-4c5b-8e6b-5e82a8c5a273','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'ADULT'),(662,'f15cb858-4f0b-44ec-a017-5e662039ba19','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(662,'f61dd82a-2e03-48b9-8ab4-0840b811de63','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'NONE'),(662,'fee63978-1be9-4cfc-a80c-44dc3616eb33','55f46aac-286b-487d-9bd0-18edca00c470',0,0,'ADULT');
/*!40000 ALTER TABLE `ProfessionalPatient` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrder`
--

DROP TABLE IF EXISTS `ProstheticOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticOrder` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `actId` varchar(36) NOT NULL,
  `title` varchar(64) DEFAULT NULL,
  `status` enum('NOT_SENT','SENT','DATE_VALIDATED','DATE_EDITED','VALIDATED','CANCELLED','DELIVERY') NOT NULL DEFAULT 'NOT_SENT',
  `unread` tinyint(1) DEFAULT '0',
  `currentDeliveryDate` datetime(3) DEFAULT NULL,
  `previousDeliveryDate` datetime(3) DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `displayId` mediumint unsigned DEFAULT NULL,
  `createdById` varchar(36) DEFAULT NULL,
  `updatedById` varchar(36) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `actId` (`actId`),
  CONSTRAINT `ProstheticOrder_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrder_ibfk_2` FOREIGN KEY (`actId`) REFERENCES `Act` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrder`
--

LOCK TABLES `ProstheticOrder` WRITE;
/*!40000 ALTER TABLE `ProstheticOrder` DISABLE KEYS */;
INSERT INTO `ProstheticOrder` VALUES ('03969eb4-0bb5-4cae-92e8-5cf65689757e',662,'64834083-3320-4687-9710-c2be0d9c7198','AUTRE FICHE PROTHÉTIQUE','SENT',0,'2020-05-09 12:00:00.000',NULL,0,2,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-05-01 08:19:50.000',NULL,'2020-05-01 08:23:30.000','2020-05-01 06:23:32.000','2020-05-01 08:23:32.000'),('083f4c03-5580-45f2-9229-c3b06c40bbe2',662,'1ce80886-d3f3-42d8-872a-a2eba69d0005','ODF','SENT',0,'2020-04-16 00:00:01.000',NULL,0,1,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-15 08:27:24.000',NULL,'2020-04-15 08:27:54.000','2020-04-15 06:27:56.000','2020-04-15 08:27:56.000'),('118a8411-96d0-412f-a2fd-6e990b04bf34',662,'1ce80886-d3f3-42d8-872a-a2eba69d0005','ODF','SENT',0,'2020-04-16 00:00:01.000',NULL,0,2,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-15 08:51:12.000',NULL,'2020-04-15 08:51:44.000','2020-04-15 06:51:46.000','2020-04-15 08:51:46.000'),('27140079-09e3-11ee-b558-229278a3c906',662,'270ecdfc-09e3-11ee-b558-229278a3c906','Commande n° 1.23.5.1','NOT_SENT',1,NULL,NULL,1,1,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2023-06-13 14:09:31.291','2023-06-13 14:09:40.268','2023-06-13 14:09:40.268','2023-06-13 12:09:40.269',NULL),('50b326be-6726-493a-a2ce-6f1153dc9927',662,'bb2e4d25-46eb-48d2-80af-41639e464a04','AUTRE FICHE PROTHÉTIQUE','SENT',0,'2020-04-18 00:00:01.000',NULL,0,1,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-17 07:56:10.000',NULL,'2020-04-17 07:56:49.000','2020-04-17 05:56:51.000','2020-04-17 07:56:51.000'),('5d81ea77-9474-4056-9631-6c7167b6f3eb',662,'b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c','GOUTTIÈRE','NOT_SENT',0,'2020-12-29 11:43:30.000',NULL,1,1,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-12-29 11:43:30.000','2020-12-29 12:05:52.000','2020-12-29 11:43:30.000','2023-04-11 19:02:23.542',NULL),('63706c26-d501-4c56-bdc2-ab2c76f6d988',662,'64834083-3320-4687-9710-c2be0d9c7198','AUTRE FICHE PROTHÉTIQUE','DATE_VALIDATED',0,'2020-05-09 12:00:00.000',NULL,0,3,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-05-01 08:26:01.000',NULL,'2020-05-02 21:58:19.000','2020-05-02 19:58:19.000','2020-05-02 21:58:19.000'),('6ff5b097-d5bb-4902-981f-b53e6fa85604',662,'64834083-3320-4687-9710-c2be0d9c7198','AUTRE FICHE PROTHÉTIQUE','SENT',0,'2020-05-09 12:00:00.000',NULL,0,1,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-30 20:26:09.000',NULL,'2020-04-30 20:27:47.000','2020-04-30 18:27:49.000','2020-04-30 20:27:49.000'),('7a0fe58a-64da-4011-982b-3db6bd950242',662,'1b1f827a-e4fa-4f16-8fd1-8cbdaa85c91e','COMMANDE','NOT_SENT',1,'2022-09-20 00:00:00.000',NULL,0,1,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2022-09-19 15:18:37.000',NULL,'2022-09-19 15:19:17.000','2023-04-11 19:02:23.534',NULL),('7a51b084-d261-4bda-a936-18d73b32440e',662,'934f20d2-7444-4367-89e2-61c3bf4bee57','AMOVIBLE SUR IMPLANT','NOT_SENT',0,'2020-04-10 09:18:38.000',NULL,1,2,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-10 09:18:38.000','2020-04-10 09:18:47.000','2020-04-10 09:18:38.000','2023-04-11 19:02:23.542',NULL),('9c995fb9-8c4e-4ea3-8f7b-5798259bca98',662,'cb9d8495-b4dd-423f-a624-7cff70e4db55','AUTRE FICHE PROTHÉTIQUE','NOT_SENT',0,'2020-04-13 07:58:36.000',NULL,1,1,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-13 07:58:36.000','2020-04-13 07:58:44.000','2020-04-13 07:58:36.000','2023-04-11 19:02:23.542',NULL),('a6308d4d-d910-11ed-b558-229278a3c906',662,'a62b9800-d910-11ed-b558-229278a3c906','Commande n° 1.23.2.1','SENT',0,'2023-06-30 00:00:00.000',NULL,0,1,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2023-04-12 11:01:44.000',NULL,'2023-06-13 13:59:33.000','2023-06-13 11:59:36.701','2023-06-13 13:59:36.701'),('b1c50855-9551-467e-94d9-915a6218ec1b',662,'bc967a6b-ad1a-4a59-aab8-92332e4217b0','GOUTTIÈRE','DATE_VALIDATED',0,'2020-07-27 12:00:00.000',NULL,0,1,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-07-13 19:42:35.000',NULL,'2020-07-15 23:04:22.000','2020-07-15 21:04:22.000','2020-07-15 23:04:22.000'),('cf94d0c8-09e1-11ee-b558-229278a3c906',662,'cf8f7620-09e1-11ee-b558-229278a3c906','Commande n° 1.23.4.1','NOT_SENT',1,NULL,NULL,1,1,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2023-06-13 13:59:54.999','2023-06-13 14:00:42.530','2023-06-13 14:00:42.531','2023-06-13 12:00:42.532',NULL),('d75864c1-5365-47a3-9907-f9bee7a8fe94',662,'934f20d2-7444-4367-89e2-61c3bf4bee57','AMOVIBLE','NOT_SENT',0,'2020-04-10 09:18:12.000',NULL,1,1,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-10 09:18:12.000','2020-04-10 09:21:02.000','2020-04-10 09:18:23.000','2023-04-11 19:02:23.542',NULL),('e51ac82a-09e0-11ee-b558-229278a3c906',662,'e516e5ef-09e0-11ee-b558-229278a3c906','Commande n° 1.23.3.1','NOT_SENT',1,NULL,NULL,1,1,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2023-06-13 13:53:21.612','2023-06-13 13:53:54.017','2023-06-13 13:53:54.018','2023-06-13 11:53:54.018',NULL),('eb120496-ad30-4640-856b-fbdd1139c529',662,'934f20d2-7444-4367-89e2-61c3bf4bee57','ODF','DATE_VALIDATED',0,'2020-04-11 00:00:01.000',NULL,0,3,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-10 09:19:11.000',NULL,'2020-04-10 09:29:08.000','2020-04-10 07:29:08.000','2020-04-10 09:29:08.000'),('fb151d98-0604-45ed-8599-26fa11975b19',662,'cb9d8495-b4dd-423f-a624-7cff70e4db55','ODF','SENT',0,'2020-04-14 00:00:01.000',NULL,0,2,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-13 07:58:48.000',NULL,'2020-04-13 07:59:28.000','2020-04-13 05:59:30.000','2020-04-13 07:59:30.000'),('fce8aef9-22f3-446a-bd23-7f6a283417dc',662,'ec084612-67a2-4430-ae15-7fe0edeaca64','AUTRE FICHE PROTHÉTIQUE','DATE_VALIDATED',0,'2020-04-13 00:00:01.000',NULL,0,1,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-12 08:27:54.000',NULL,'2020-04-13 07:39:16.000','2020-04-13 05:39:16.000','2020-04-13 07:39:16.000');
/*!40000 ALTER TABLE `ProstheticOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrderFile`
--

DROP TABLE IF EXISTS `ProstheticOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticOrderFile` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('FORM','SCAN') NOT NULL,
  PRIMARY KEY (`orderId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `ProstheticOrderFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrderFile_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `ProstheticOrder` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrderFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrderFile`
--

LOCK TABLES `ProstheticOrderFile` WRITE;
/*!40000 ALTER TABLE `ProstheticOrderFile` DISABLE KEYS */;
INSERT INTO `ProstheticOrderFile` VALUES (662,'03969eb4-0bb5-4cae-92e8-5cf65689757e','169331da-dbab-454e-828b-67287bb2feb7','SCAN'),(662,'03969eb4-0bb5-4cae-92e8-5cf65689757e','1e3c210c-a983-4276-916c-6c49b0e64e1d','SCAN'),(662,'03969eb4-0bb5-4cae-92e8-5cf65689757e','1e81852e-fdc6-4523-9e33-47494d60d953','SCAN'),(662,'03969eb4-0bb5-4cae-92e8-5cf65689757e','1f608503-4867-4253-a143-dd200e0ebe0a','SCAN'),(662,'03969eb4-0bb5-4cae-92e8-5cf65689757e','1f629ca9-f822-4a93-aecc-1e8473c82dd5','FORM'),(662,'03969eb4-0bb5-4cae-92e8-5cf65689757e','51c81dd7-f872-4092-9a17-d9b3821ed7c8','SCAN'),(662,'03969eb4-0bb5-4cae-92e8-5cf65689757e','60a7c19d-824d-4fdf-a109-f3df643a3f1a','SCAN'),(662,'03969eb4-0bb5-4cae-92e8-5cf65689757e','8d582d54-5f1f-4ac9-ac0e-a9aa41cc41e1','SCAN'),(662,'03969eb4-0bb5-4cae-92e8-5cf65689757e','bc10348b-1c26-48ee-bc8f-6fa5ac933a14','SCAN'),(662,'03969eb4-0bb5-4cae-92e8-5cf65689757e','f69344e1-d52d-49da-acc5-b714cb86225d','SCAN'),(662,'083f4c03-5580-45f2-9229-c3b06c40bbe2','0abfe6c8-8321-4681-9ffd-944418ed370c','SCAN'),(662,'083f4c03-5580-45f2-9229-c3b06c40bbe2','0fd33c57-ea90-4557-bed0-d59a4b5f2c80','FORM'),(662,'083f4c03-5580-45f2-9229-c3b06c40bbe2','2129ad39-4745-4e82-a5b8-dcf7933c6ae7','SCAN'),(662,'083f4c03-5580-45f2-9229-c3b06c40bbe2','2a2002a5-6321-4c63-938e-7276412e6a28','SCAN'),(662,'083f4c03-5580-45f2-9229-c3b06c40bbe2','3a8a47b1-96a0-4e8f-a7fa-d5c2f74f3677','SCAN'),(662,'083f4c03-5580-45f2-9229-c3b06c40bbe2','3f126af5-ce2b-4e13-8fc8-9811ab5d462c','SCAN'),(662,'083f4c03-5580-45f2-9229-c3b06c40bbe2','48632fc1-3269-4a7f-bdaa-980e30af0358','SCAN'),(662,'083f4c03-5580-45f2-9229-c3b06c40bbe2','a2156f23-da3f-4a2a-97f3-76ea6c877521','SCAN'),(662,'083f4c03-5580-45f2-9229-c3b06c40bbe2','a483fb03-0adb-4387-9099-c9c2567855e7','SCAN'),(662,'083f4c03-5580-45f2-9229-c3b06c40bbe2','a5903ca6-45db-41cc-a262-19592ff5f2e4','SCAN'),(662,'083f4c03-5580-45f2-9229-c3b06c40bbe2','f574474f-dc28-462d-9251-b23591ca9bcb','SCAN'),(662,'118a8411-96d0-412f-a2fd-6e990b04bf34','0abfe6c8-8321-4681-9ffd-944418ed370c','SCAN'),(662,'118a8411-96d0-412f-a2fd-6e990b04bf34','2129ad39-4745-4e82-a5b8-dcf7933c6ae7','SCAN'),(662,'118a8411-96d0-412f-a2fd-6e990b04bf34','27755e68-98ae-4662-a39e-c3ea4ba3cdd4','FORM'),(662,'118a8411-96d0-412f-a2fd-6e990b04bf34','2a2002a5-6321-4c63-938e-7276412e6a28','SCAN'),(662,'118a8411-96d0-412f-a2fd-6e990b04bf34','3a8a47b1-96a0-4e8f-a7fa-d5c2f74f3677','SCAN'),(662,'118a8411-96d0-412f-a2fd-6e990b04bf34','3f126af5-ce2b-4e13-8fc8-9811ab5d462c','SCAN'),(662,'118a8411-96d0-412f-a2fd-6e990b04bf34','48632fc1-3269-4a7f-bdaa-980e30af0358','SCAN'),(662,'118a8411-96d0-412f-a2fd-6e990b04bf34','a2156f23-da3f-4a2a-97f3-76ea6c877521','SCAN'),(662,'118a8411-96d0-412f-a2fd-6e990b04bf34','a483fb03-0adb-4387-9099-c9c2567855e7','SCAN'),(662,'118a8411-96d0-412f-a2fd-6e990b04bf34','a5903ca6-45db-41cc-a262-19592ff5f2e4','SCAN'),(662,'118a8411-96d0-412f-a2fd-6e990b04bf34','f574474f-dc28-462d-9251-b23591ca9bcb','SCAN'),(662,'50b326be-6726-493a-a2ce-6f1153dc9927','5c922725-b41b-4e38-a244-6a9a320d291e','SCAN'),(662,'50b326be-6726-493a-a2ce-6f1153dc9927','675a601d-d389-403d-858d-555ff6166630','SCAN'),(662,'50b326be-6726-493a-a2ce-6f1153dc9927','b25a25e2-610a-466d-a4d8-7518a09b9a78','SCAN'),(662,'50b326be-6726-493a-a2ce-6f1153dc9927','e18ed074-c432-415e-b63e-3b73dcb95e72','FORM'),(662,'63706c26-d501-4c56-bdc2-ab2c76f6d988','169331da-dbab-454e-828b-67287bb2feb7','SCAN'),(662,'63706c26-d501-4c56-bdc2-ab2c76f6d988','1e3c210c-a983-4276-916c-6c49b0e64e1d','SCAN'),(662,'63706c26-d501-4c56-bdc2-ab2c76f6d988','1e81852e-fdc6-4523-9e33-47494d60d953','SCAN'),(662,'63706c26-d501-4c56-bdc2-ab2c76f6d988','1f608503-4867-4253-a143-dd200e0ebe0a','SCAN'),(662,'63706c26-d501-4c56-bdc2-ab2c76f6d988','51c81dd7-f872-4092-9a17-d9b3821ed7c8','SCAN'),(662,'63706c26-d501-4c56-bdc2-ab2c76f6d988','60a7c19d-824d-4fdf-a109-f3df643a3f1a','SCAN'),(662,'63706c26-d501-4c56-bdc2-ab2c76f6d988','8d582d54-5f1f-4ac9-ac0e-a9aa41cc41e1','SCAN'),(662,'63706c26-d501-4c56-bdc2-ab2c76f6d988','9319bd6a-6e7d-4505-8090-e4e10e3caec0','SCAN'),(662,'63706c26-d501-4c56-bdc2-ab2c76f6d988','95ab2e1b-4b91-4bb5-965e-8086f8805dc7','FORM'),(662,'63706c26-d501-4c56-bdc2-ab2c76f6d988','bc10348b-1c26-48ee-bc8f-6fa5ac933a14','SCAN'),(662,'63706c26-d501-4c56-bdc2-ab2c76f6d988','f69344e1-d52d-49da-acc5-b714cb86225d','SCAN'),(662,'6ff5b097-d5bb-4902-981f-b53e6fa85604','169331da-dbab-454e-828b-67287bb2feb7','SCAN'),(662,'6ff5b097-d5bb-4902-981f-b53e6fa85604','1e3c210c-a983-4276-916c-6c49b0e64e1d','SCAN'),(662,'6ff5b097-d5bb-4902-981f-b53e6fa85604','1e81852e-fdc6-4523-9e33-47494d60d953','SCAN'),(662,'6ff5b097-d5bb-4902-981f-b53e6fa85604','1f608503-4867-4253-a143-dd200e0ebe0a','SCAN'),(662,'6ff5b097-d5bb-4902-981f-b53e6fa85604','51c81dd7-f872-4092-9a17-d9b3821ed7c8','SCAN'),(662,'6ff5b097-d5bb-4902-981f-b53e6fa85604','60a7c19d-824d-4fdf-a109-f3df643a3f1a','SCAN'),(662,'6ff5b097-d5bb-4902-981f-b53e6fa85604','8d582d54-5f1f-4ac9-ac0e-a9aa41cc41e1','SCAN'),(662,'6ff5b097-d5bb-4902-981f-b53e6fa85604','9319bd6a-6e7d-4505-8090-e4e10e3caec0','SCAN'),(662,'6ff5b097-d5bb-4902-981f-b53e6fa85604','9533b2b7-5385-4d5f-8858-b01c1c030817','FORM'),(662,'6ff5b097-d5bb-4902-981f-b53e6fa85604','bc10348b-1c26-48ee-bc8f-6fa5ac933a14','SCAN'),(662,'6ff5b097-d5bb-4902-981f-b53e6fa85604','f69344e1-d52d-49da-acc5-b714cb86225d','SCAN'),(662,'7a0fe58a-64da-4011-982b-3db6bd950242','1ab759da-dceb-48e2-83be-326054416d3c','FORM'),(662,'7a0fe58a-64da-4011-982b-3db6bd950242','41f1c7ba-1d8c-47b9-8ed9-11f004bb7681','SCAN'),(662,'a6308d4d-d910-11ed-b558-229278a3c906','05260ab4-d913-11ed-b558-229278a3c906','SCAN'),(662,'a6308d4d-d910-11ed-b558-229278a3c906','0527500a-d913-11ed-b558-229278a3c906','SCAN'),(662,'a6308d4d-d910-11ed-b558-229278a3c906','0d5d836c-d915-11ed-b558-229278a3c906','SCAN'),(662,'a6308d4d-d910-11ed-b558-229278a3c906','0d5d9857-d915-11ed-b558-229278a3c906','SCAN'),(662,'a6308d4d-d910-11ed-b558-229278a3c906','8c1eb1f1-d914-11ed-b558-229278a3c906','SCAN'),(662,'a6308d4d-d910-11ed-b558-229278a3c906','8c1ec753-d914-11ed-b558-229278a3c906','SCAN'),(662,'a6308d4d-d910-11ed-b558-229278a3c906','c26fa07f-09e1-11ee-b558-229278a3c906','FORM'),(662,'a6308d4d-d910-11ed-b558-229278a3c906','dc68fc0d-d914-11ed-b558-229278a3c906','SCAN'),(662,'a6308d4d-d910-11ed-b558-229278a3c906','dc690efd-d914-11ed-b558-229278a3c906','SCAN'),(662,'a6308d4d-d910-11ed-b558-229278a3c906','e1c42d91-d915-11ed-b558-229278a3c906','SCAN'),(662,'a6308d4d-d910-11ed-b558-229278a3c906','e1c443e6-d915-11ed-b558-229278a3c906','SCAN'),(662,'b1c50855-9551-467e-94d9-915a6218ec1b','144ce692-0397-4de4-aa07-e50e85b5a553','SCAN'),(662,'b1c50855-9551-467e-94d9-915a6218ec1b','22b17811-0494-42ee-a82c-e9e5fe8e4ae4','FORM'),(662,'b1c50855-9551-467e-94d9-915a6218ec1b','e94bbc94-0540-4634-816e-4a842ced15fa','SCAN'),(662,'eb120496-ad30-4640-856b-fbdd1139c529','1f02ce0a-9100-460e-987f-c2b91eda5ac1','SCAN'),(662,'eb120496-ad30-4640-856b-fbdd1139c529','3c573ce9-f6b2-4667-9726-f5aed56d3325','FORM'),(662,'eb120496-ad30-4640-856b-fbdd1139c529','bb2755e4-36de-4604-9ee9-d2711661ea1d','SCAN'),(662,'fb151d98-0604-45ed-8599-26fa11975b19','31421697-5459-439e-919b-169d051646f5','SCAN'),(662,'fb151d98-0604-45ed-8599-26fa11975b19','60447943-1739-4e3f-aced-0eb015c274a2','FORM'),(662,'fb151d98-0604-45ed-8599-26fa11975b19','9cd5b1c8-ef15-449d-97a1-bdf6947abe78','SCAN'),(662,'fce8aef9-22f3-446a-bd23-7f6a283417dc','ebcf2fdf-8f60-4590-bf41-6c7e360d6441','FORM');
/*!40000 ALTER TABLE `ProstheticOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticOrderRecipient`
--

DROP TABLE IF EXISTS `ProstheticOrderRecipient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticOrderRecipient` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `recipientId` varchar(36) NOT NULL,
  PRIMARY KEY (`orderId`,`recipientId`),
  KEY `ownerId` (`ownerId`),
  KEY `recipientId` (`recipientId`),
  CONSTRAINT `ProstheticOrderRecipient_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrderRecipient_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `ProstheticOrder` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ProstheticOrderRecipient_ibfk_3` FOREIGN KEY (`recipientId`) REFERENCES `Contact` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticOrderRecipient`
--

LOCK TABLES `ProstheticOrderRecipient` WRITE;
/*!40000 ALTER TABLE `ProstheticOrderRecipient` DISABLE KEYS */;
INSERT INTO `ProstheticOrderRecipient` VALUES (662,'03969eb4-0bb5-4cae-92e8-5cf65689757e','e65a3983-26d3-437e-9f3a-9ec54fa23fbe'),(662,'083f4c03-5580-45f2-9229-c3b06c40bbe2','08ea1d0b-73cb-4462-acdd-d58c09bde03a'),(662,'118a8411-96d0-412f-a2fd-6e990b04bf34','08ea1d0b-73cb-4462-acdd-d58c09bde03a'),(662,'50b326be-6726-493a-a2ce-6f1153dc9927','08ea1d0b-73cb-4462-acdd-d58c09bde03a'),(662,'63706c26-d501-4c56-bdc2-ab2c76f6d988','e65a3983-26d3-437e-9f3a-9ec54fa23fbe'),(662,'6ff5b097-d5bb-4902-981f-b53e6fa85604','e65a3983-26d3-437e-9f3a-9ec54fa23fbe'),(662,'7a0fe58a-64da-4011-982b-3db6bd950242','0c639fb7-3c3a-493f-ac8c-2bd4fb7c8ede'),(662,'a6308d4d-d910-11ed-b558-229278a3c906','25312481-3ad2-4523-ae5f-0b5303fca7f1'),(662,'b1c50855-9551-467e-94d9-915a6218ec1b','e65a3983-26d3-437e-9f3a-9ec54fa23fbe'),(662,'eb120496-ad30-4640-856b-fbdd1139c529','e65a3983-26d3-437e-9f3a-9ec54fa23fbe'),(662,'fb151d98-0604-45ed-8599-26fa11975b19','08ea1d0b-73cb-4462-acdd-d58c09bde03a'),(662,'fce8aef9-22f3-446a-bd23-7f6a283417dc','08ea1d0b-73cb-4462-acdd-d58c09bde03a');
/*!40000 ALTER TABLE `ProstheticOrderRecipient` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ProstheticSheet`
--

DROP TABLE IF EXISTS `ProstheticSheet`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ProstheticSheet` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `json` text NOT NULL,
  `pdfFileId` varchar(36) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `orderId` (`orderId`),
  KEY `pdfFileId` (`pdfFileId`),
  CONSTRAINT `ProstheticSheet_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ProstheticSheet_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `ProstheticOrder` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ProstheticSheet_ibfk_3` FOREIGN KEY (`pdfFileId`) REFERENCES `File` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProstheticSheet`
--

LOCK TABLES `ProstheticSheet` WRITE;
/*!40000 ALTER TABLE `ProstheticSheet` DISABLE KEYS */;
INSERT INTO `ProstheticSheet` VALUES ('03969eb4-0bb5-4cae-92e8-5cf65689757e',662,'03969eb4-0bb5-4cae-92e8-5cf65689757e','{\"v1\": {\"type\": 12, \"comment\": \"\", \"language\": \"fr_FR\", \"sheetTitle\": \"AUTRE FICHE DE PROTHESE\"}, \"v2\": {\"type\": 12, \"comment\": \"\", \"language\": \"fr_FR\", \"sheetTitle\": \"AUTRE FICHE DE PROTHESE\", \"usePrePreparation\": false}}','1f629ca9-f822-4a93-aecc-1e8473c82dd5','2020-05-01 08:19:50.000',NULL,'2020-05-01 08:23:30.000','2023-04-11 19:02:24.693','2020-05-01 08:23:32.000'),('083f4c03-5580-45f2-9229-c3b06c40bbe2',662,'083f4c03-5580-45f2-9229-c3b06c40bbe2','{\"v1\": {\"type\": 11, \"comment\": \"test\", \"language\": \"fr_FR\", \"sheetTitle\": \"ODF\"}, \"v2\": {\"type\": 11, \"comment\": \"test\", \"language\": \"fr_FR\", \"sheetTitle\": \"ODF\"}}','0fd33c57-ea90-4557-bed0-d59a4b5f2c80','2020-04-15 08:27:24.000',NULL,'2020-04-15 08:27:54.000','2023-04-11 19:02:24.693','2020-04-15 08:27:56.000'),('118a8411-96d0-412f-a2fd-6e990b04bf34',662,'118a8411-96d0-412f-a2fd-6e990b04bf34','{\"v1\": {\"type\": 11, \"comment\": \"test 2\", \"language\": \"fr_FR\", \"sheetTitle\": \"ODF\"}, \"v2\": {\"type\": 11, \"comment\": \"test 2\", \"language\": \"fr_FR\", \"sheetTitle\": \"ODF\"}}','27755e68-98ae-4662-a39e-c3ea4ba3cdd4','2020-04-15 08:51:12.000',NULL,'2020-04-15 08:51:44.000','2023-04-11 19:02:24.693','2020-04-15 08:51:46.000'),('2714644e-09e3-11ee-b558-229278a3c906',662,'27140079-09e3-11ee-b558-229278a3c906','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"Gouttière SmilersLab\",\n        \"subType\": 0,\n        \"type\": 10,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-06-13 14:09:31.254','2023-06-13 14:09:40.268','2023-06-13 14:09:31.294','2023-06-13 12:09:40.271',NULL),('50b326be-6726-493a-a2ce-6f1153dc9927',662,'50b326be-6726-493a-a2ce-6f1153dc9927','{\"v1\": {\"type\": 12, \"comment\": \"test\", \"language\": \"fr_FR\", \"sheetTitle\": \"AUTRE FICHE PROTHÉTIQUE\"}, \"v2\": {\"type\": 12, \"comment\": \"test\", \"language\": \"fr_FR\", \"sheetTitle\": \"AUTRE FICHE PROTHÉTIQUE\", \"usePrePreparation\": false}}','e18ed074-c432-415e-b63e-3b73dcb95e72','2020-04-17 07:56:10.000',NULL,'2020-04-17 07:56:49.000','2023-04-11 19:02:24.693','2020-04-17 07:56:51.000'),('5d81ea77-9474-4056-9631-6c7167b6f3eb',662,'5d81ea77-9474-4056-9631-6c7167b6f3eb','{\"v1\": {\"type\": 10, \"comment\": \"\", \"subType\": 0, \"language\": \"fr_FR\", \"sheetTitle\": \"GOUTTIÈRE\"}, \"v2\": {\"type\": 10, \"comment\": \"\", \"subType\": 0, \"language\": \"fr_FR\", \"sheetTitle\": \"GOUTTIÈRE\", \"usePrePreparation\": false}}',NULL,'2020-12-29 11:43:30.000','2020-12-29 12:05:52.000','2020-12-29 11:43:30.000','2023-04-11 19:02:24.693',NULL),('63706c26-d501-4c56-bdc2-ab2c76f6d988',662,'63706c26-d501-4c56-bdc2-ab2c76f6d988','{\"v1\": {\"type\": 12, \"comment\": \"ATM\\n\", \"language\": \"fr_FR\", \"sheetTitle\": \"AUTRE FICHE PROTHÉTIQUE\"}, \"v2\": {\"type\": 12, \"comment\": \"ATM\\n\", \"language\": \"fr_FR\", \"sheetTitle\": \"AUTRE FICHE PROTHÉTIQUE\", \"usePrePreparation\": false}}','95ab2e1b-4b91-4bb5-965e-8086f8805dc7','2020-05-01 08:26:01.000',NULL,'2020-05-02 21:58:19.000','2023-04-11 19:02:24.693','2020-05-02 21:58:19.000'),('6d3106b1-a5e8-4ecd-a2b1-a72c5fc2a380',662,'7a0fe58a-64da-4011-982b-3db6bd950242','{\"v1\": {\"type\": 12, \"comment\": \"Aucun\", \"language\": \"fr_FR\", \"sheetTitle\": \"AUTRE FICHE DE PROTHESE\"}, \"v2\": {\"type\": 12, \"comment\": \"Aucun\", \"language\": \"fr_FR\", \"sheetTitle\": \"AUTRE FICHE DE PROTHESE\", \"usePrePreparation\": false}}','1ab759da-dceb-48e2-83be-326054416d3c','2022-09-19 15:18:45.000',NULL,'2022-09-19 15:18:45.000','2023-04-11 19:02:24.693',NULL),('6ff5b097-d5bb-4902-981f-b53e6fa85604',662,'6ff5b097-d5bb-4902-981f-b53e6fa85604','{\"v1\": {\"type\": 12, \"comment\": \"\", \"language\": \"fr_FR\", \"sheetTitle\": \"AUTRE FICHE DE PROTHESE\"}, \"v2\": {\"type\": 12, \"comment\": \"\", \"language\": \"fr_FR\", \"sheetTitle\": \"AUTRE FICHE DE PROTHESE\", \"usePrePreparation\": false}}','9533b2b7-5385-4d5f-8858-b01c1c030817','2020-04-30 20:26:09.000',NULL,'2020-04-30 20:27:47.000','2023-04-11 19:02:24.693','2020-04-30 20:27:49.000'),('7a51b084-d261-4bda-a936-18d73b32440e',662,'7a51b084-d261-4bda-a936-18d73b32440e','{\"v1\": {\"type\": 8, \"comment\": \"\", \"language\": \"fr_FR\", \"sheetTitle\": \"AMOVIBLE SUR IMPLANT\", \"subElements\": [{\"comment\": \"\", \"refImplant\": \"\", \"selectedTeeth\": [], \"chassisMaterial\": 0, \"removableArcade\": 0, \"prostheticMaterial\": 0, \"specificTintSubElement\": \"\"}], \"generalTintElement\": \"\", \"amovibleProstheticStep\": 0}, \"v2\": {\"type\": 8, \"comment\": \"\", \"language\": \"fr_FR\", \"sheetTitle\": \"AMOVIBLE SUR IMPLANT\"}}',NULL,'2020-04-10 09:18:38.000','2020-04-10 09:18:47.000','2020-04-10 09:18:38.000','2023-04-11 19:02:24.693',NULL),('9c995fb9-8c4e-4ea3-8f7b-5798259bca98',662,'9c995fb9-8c4e-4ea3-8f7b-5798259bca98','{\"v1\": {\"type\": 12, \"comment\": \"\", \"language\": \"fr_FR\", \"sheetTitle\": \"AUTRE FICHE PROTHÉTIQUE\"}, \"v2\": {\"type\": 12, \"comment\": \"\", \"language\": \"fr_FR\", \"sheetTitle\": \"AUTRE FICHE PROTHÉTIQUE\", \"usePrePreparation\": false}}',NULL,'2020-04-13 07:58:36.000','2020-04-13 07:58:44.000','2020-04-13 07:58:36.000','2023-04-11 19:02:24.693',NULL),('a630e9f6-d910-11ed-b558-229278a3c906',662,'a6308d4d-d910-11ed-b558-229278a3c906','{\n    \"v2\": {\n        \"comment\": \"smilers\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28,\n            38,\n            37,\n            36,\n            35,\n            34,\n            33,\n            32,\n            31,\n            41,\n            42,\n            43,\n            44,\n            45,\n            46,\n            47,\n            48\n        ],\n        \"sheetTitle\": \"Gouttière\",\n        \"subType\": 6,\n        \"type\": 10,\n        \"usePrePreparation\": false\n    }\n}\n','c26fa07f-09e1-11ee-b558-229278a3c906','2023-04-12 11:01:28.000',NULL,'2023-06-13 13:59:34.000','2023-06-13 11:59:36.715','2023-06-13 13:59:36.701'),('b1c50855-9551-467e-94d9-915a6218ec1b',662,'b1c50855-9551-467e-94d9-915a6218ec1b','{\"v1\": {\"type\": 12, \"comment\": \"\", \"language\": \"fr_FR\", \"sheetTitle\": \"AUTRE FICHE DE PROTHESE\"}, \"v2\": {\"type\": 12, \"comment\": \"\", \"language\": \"fr_FR\", \"sheetTitle\": \"AUTRE FICHE DE PROTHESE\", \"usePrePreparation\": false}}','22b17811-0494-42ee-a82c-e9e5fe8e4ae4','2020-07-13 19:42:35.000',NULL,'2020-07-15 23:04:22.000','2023-04-11 19:02:24.693','2020-07-15 23:04:22.000'),('cf952678-09e1-11ee-b558-229278a3c906',662,'cf94d0c8-09e1-11ee-b558-229278a3c906','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"Gouttière SmilersLab\",\n        \"subType\": 0,\n        \"type\": 10,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-06-13 13:59:54.961','2023-06-13 14:00:42.530','2023-06-13 13:59:55.001','2023-06-13 12:00:42.533',NULL),('d75864c1-5365-47a3-9907-f9bee7a8fe94',662,'d75864c1-5365-47a3-9907-f9bee7a8fe94','{\"v1\": {\"type\": 7, \"comment\": \"\", \"crochet\": 0, \"subType\": 2, \"language\": \"fr_FR\", \"sheetTitle\": \"AMOVIBLE\", \"selectedTeeth\": [], \"chassisMaterial\": 0, \"removableArcade\": 0, \"generalTintElement\": \"\", \"prostheticMaterial\": 0, \"amovibleProstheticStep\": 0}, \"v2\": {\"type\": 7, \"comment\": \"\", \"language\": \"fr_FR\", \"sheetTitle\": \"AMOVIBLE\", \"specificTint\": \"\", \"selectedTeeth\": [], \"usePrePreparation\": false, \"prostheticMaterial\": 0, \"prostheticContactPoint\": 1}}',NULL,'2020-04-10 09:18:12.000','2020-04-10 09:21:02.000','2020-04-10 09:18:23.000','2023-04-11 19:02:24.693',NULL),('e51b1dfc-09e0-11ee-b558-229278a3c906',662,'e51ac82a-09e0-11ee-b558-229278a3c906','{\n    \"v2\": {\n        \"comment\": \"\",\n        \"language\": \"fr_FR\",\n        \"selectedTeeth\": [\n            18,\n            17,\n            16,\n            15,\n            14,\n            13,\n            12,\n            11,\n            21,\n            22,\n            23,\n            24,\n            25,\n            26,\n            27,\n            28\n        ],\n        \"sheetTitle\": \"Gouttière SmilersLab\",\n        \"subType\": 0,\n        \"type\": 10,\n        \"usePrePreparation\": false\n    }\n}\n',NULL,'2023-06-13 13:53:21.584','2023-06-13 13:53:54.017','2023-06-13 13:53:21.615','2023-06-13 11:53:54.018',NULL),('eb120496-ad30-4640-856b-fbdd1139c529',662,'eb120496-ad30-4640-856b-fbdd1139c529','{\"v1\": {\"type\": 11, \"comment\": \"Test\", \"language\": \"fr_FR\", \"sheetTitle\": \"ODF\"}, \"v2\": {\"type\": 11, \"comment\": \"Test\", \"language\": \"fr_FR\", \"sheetTitle\": \"ODF\"}}','3c573ce9-f6b2-4667-9726-f5aed56d3325','2020-04-10 09:19:11.000',NULL,'2020-04-10 09:29:08.000','2023-04-11 19:02:24.693','2020-04-10 09:29:08.000'),('fb151d98-0604-45ed-8599-26fa11975b19',662,'fb151d98-0604-45ed-8599-26fa11975b19','{\"v1\": {\"type\": 11, \"comment\": \"Test 2\", \"language\": \"fr_FR\", \"sheetTitle\": \"ODF\"}, \"v2\": {\"type\": 11, \"comment\": \"Test 2\", \"language\": \"fr_FR\", \"sheetTitle\": \"ODF\"}}','60447943-1739-4e3f-aced-0eb015c274a2','2020-04-13 07:58:48.000',NULL,'2020-04-13 07:59:28.000','2023-04-11 19:02:24.693','2020-04-13 07:59:30.000'),('fce8aef9-22f3-446a-bd23-7f6a283417dc',662,'fce8aef9-22f3-446a-bd23-7f6a283417dc','{\"v1\": {\"type\": 12, \"comment\": \"Test\", \"language\": \"fr_FR\", \"sheetTitle\": \"AUTRE FICHE PROTHÉTIQUE\"}, \"v2\": {\"type\": 12, \"comment\": \"Test\", \"language\": \"fr_FR\", \"sheetTitle\": \"AUTRE FICHE PROTHÉTIQUE\", \"usePrePreparation\": false}}','ebcf2fdf-8f60-4590-bf41-6c7e360d6441','2020-04-12 08:27:54.000',NULL,'2020-04-13 07:39:16.000','2023-04-11 19:02:24.693','2020-04-13 07:39:16.000');
/*!40000 ALTER TABLE `ProstheticSheet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ReceivedAttachment`
--

DROP TABLE IF EXISTS `ReceivedAttachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ReceivedAttachment` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `receivedMessageId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  PRIMARY KEY (`receivedMessageId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `ReceivedAttachment_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ReceivedAttachment_ibfk_2` FOREIGN KEY (`receivedMessageId`) REFERENCES `ReceivedMessage` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ReceivedAttachment_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ReceivedAttachment`
--

LOCK TABLES `ReceivedAttachment` WRITE;
/*!40000 ALTER TABLE `ReceivedAttachment` DISABLE KEYS */;
INSERT INTO `ReceivedAttachment` VALUES (662,'0be3b4a9-d903-11ed-9ced-0050569a5229','0be70fda-d903-11ed-9ced-0050569a5229'),(662,'0be3b4a9-d903-11ed-9ced-0050569a5229','0be9955a-d903-11ed-9ced-0050569a5229'),(662,'1cc1a348-7d48-11ea-947d-226cec7cb58a','1cc559c6-7d48-11ea-947d-226cec7cb58a'),(662,'1cc1a348-7d48-11ea-947d-226cec7cb58a','1cc71f0a-7d48-11ea-947d-226cec7cb58a'),(662,'1ced8cbe-7d48-11ea-947d-226cec7cb58a','1cf0bff8-7d48-11ea-947d-226cec7cb58a'),(662,'1ced8cbe-7d48-11ea-947d-226cec7cb58a','1cf2d4d9-7d48-11ea-947d-226cec7cb58a'),(662,'1d1ad35b-7d48-11ea-947d-226cec7cb58a','1d20464f-7d48-11ea-947d-226cec7cb58a'),(662,'1e334837-8121-11ed-a752-9ec33d03e6dd','1e553911-8121-11ed-a752-9ec33d03e6dd'),(662,'1e334837-8121-11ed-a752-9ec33d03e6dd','1e57cf4d-8121-11ed-a752-9ec33d03e6dd'),(662,'208fe542-91ae-11ed-a752-9ec33d03e6dd','20926382-91ae-11ed-a752-9ec33d03e6dd'),(662,'208fe542-91ae-11ed-a752-9ec33d03e6dd','209476bb-91ae-11ed-a752-9ec33d03e6dd'),(662,'35a9ff3d-8070-11ea-947d-226cec7cb58a','35b24728-8070-11ea-947d-226cec7cb58a'),(662,'35a9ff3d-8070-11ea-947d-226cec7cb58a','35b42350-8070-11ea-947d-226cec7cb58a'),(662,'35a9ff3d-8070-11ea-947d-226cec7cb58a','35b5d98f-8070-11ea-947d-226cec7cb58a'),(662,'35a9ff3d-8070-11ea-947d-226cec7cb58a','35b772cc-8070-11ea-947d-226cec7cb58a'),(662,'35a9ff3d-8070-11ea-947d-226cec7cb58a','35b92b48-8070-11ea-947d-226cec7cb58a'),(662,'35a9ff3d-8070-11ea-947d-226cec7cb58a','35bad668-8070-11ea-947d-226cec7cb58a'),(662,'386ccd51-7ee2-11ea-947d-226cec7cb58a','38709a56-7ee2-11ea-947d-226cec7cb58a'),(662,'386ccd51-7ee2-11ea-947d-226cec7cb58a','38724456-7ee2-11ea-947d-226cec7cb58a'),(662,'386ccd51-7ee2-11ea-947d-226cec7cb58a','38756f28-7ee2-11ea-947d-226cec7cb58a'),(662,'386ccd51-7ee2-11ea-947d-226cec7cb58a','387709c6-7ee2-11ea-947d-226cec7cb58a'),(662,'386ccd51-7ee2-11ea-947d-226cec7cb58a','3878b044-7ee2-11ea-947d-226cec7cb58a'),(662,'386ccd51-7ee2-11ea-947d-226cec7cb58a','387a5afb-7ee2-11ea-947d-226cec7cb58a'),(662,'386ccd51-7ee2-11ea-947d-226cec7cb58a','387be67d-7ee2-11ea-947d-226cec7cb58a'),(662,'386ccd51-7ee2-11ea-947d-226cec7cb58a','387eea3c-7ee2-11ea-947d-226cec7cb58a'),(662,'386ccd51-7ee2-11ea-947d-226cec7cb58a','388324cf-7ee2-11ea-947d-226cec7cb58a'),(662,'386ccd51-7ee2-11ea-947d-226cec7cb58a','3884bf44-7ee2-11ea-947d-226cec7cb58a'),(662,'386ccd51-7ee2-11ea-947d-226cec7cb58a','3886abd6-7ee2-11ea-947d-226cec7cb58a'),(662,'3f38add5-157f-11ed-a752-9ec33d03e6dd','3f3f465f-157f-11ed-a752-9ec33d03e6dd'),(662,'3f38add5-157f-11ed-a752-9ec33d03e6dd','3f421d14-157f-11ed-a752-9ec33d03e6dd'),(662,'5d45f086-f650-11ec-a752-9ec33d03e6dd','5d47b05f-f650-11ec-a752-9ec33d03e6dd'),(662,'5d45f086-f650-11ec-a752-9ec33d03e6dd','5d497163-f650-11ec-a752-9ec33d03e6dd'),(662,'75fb40f5-5c35-11ed-a752-9ec33d03e6dd','75fe196b-5c35-11ed-a752-9ec33d03e6dd'),(662,'75fb40f5-5c35-11ed-a752-9ec33d03e6dd','760044a3-5c35-11ed-a752-9ec33d03e6dd'),(662,'75fb40f5-5c35-11ed-a752-9ec33d03e6dd','7601ed6f-5c35-11ed-a752-9ec33d03e6dd'),(662,'75fb40f5-5c35-11ed-a752-9ec33d03e6dd','76038e2c-5c35-11ed-a752-9ec33d03e6dd'),(662,'8ccc441e-7ee5-11ea-947d-226cec7cb58a','8ccfb1b3-7ee5-11ea-947d-226cec7cb58a'),(662,'8ccc441e-7ee5-11ea-947d-226cec7cb58a','8cd19241-7ee5-11ea-947d-226cec7cb58a'),(662,'8ccc441e-7ee5-11ea-947d-226cec7cb58a','8cd31395-7ee5-11ea-947d-226cec7cb58a'),(662,'8ccc441e-7ee5-11ea-947d-226cec7cb58a','8cd499d6-7ee5-11ea-947d-226cec7cb58a'),(662,'8ccc441e-7ee5-11ea-947d-226cec7cb58a','8cd690e5-7ee5-11ea-947d-226cec7cb58a'),(662,'8ccc441e-7ee5-11ea-947d-226cec7cb58a','8cd829cd-7ee5-11ea-947d-226cec7cb58a'),(662,'8ccc441e-7ee5-11ea-947d-226cec7cb58a','8cda0313-7ee5-11ea-947d-226cec7cb58a'),(662,'8ccc441e-7ee5-11ea-947d-226cec7cb58a','8cdbafa2-7ee5-11ea-947d-226cec7cb58a'),(662,'8ccc441e-7ee5-11ea-947d-226cec7cb58a','8cdd4be9-7ee5-11ea-947d-226cec7cb58a'),(662,'8ccc441e-7ee5-11ea-947d-226cec7cb58a','8cdf1358-7ee5-11ea-947d-226cec7cb58a'),(662,'8ccc441e-7ee5-11ea-947d-226cec7cb58a','8ce28649-7ee5-11ea-947d-226cec7cb58a'),(662,'8e9bdad1-4b8a-11ec-9377-226cec7cb58a','8ea06518-4b8a-11ec-9377-226cec7cb58a'),(662,'8e9bdad1-4b8a-11ec-9377-226cec7cb58a','8ea38ac2-4b8a-11ec-9377-226cec7cb58a'),(662,'8e9bdad1-4b8a-11ec-9377-226cec7cb58a','8ea64d2c-4b8a-11ec-9377-226cec7cb58a'),(662,'8e9bdad1-4b8a-11ec-9377-226cec7cb58a','8ea9bac9-4b8a-11ec-9377-226cec7cb58a'),(662,'8e9bdad1-4b8a-11ec-9377-226cec7cb58a','8eaccb00-4b8a-11ec-9377-226cec7cb58a'),(662,'8e9bdad1-4b8a-11ec-9377-226cec7cb58a','8eb12471-4b8a-11ec-9377-226cec7cb58a'),(662,'8e9bdad1-4b8a-11ec-9377-226cec7cb58a','8eb7bfec-4b8a-11ec-9377-226cec7cb58a'),(662,'8e9bdad1-4b8a-11ec-9377-226cec7cb58a','8ebeca38-4b8a-11ec-9377-226cec7cb58a'),(662,'8e9bdad1-4b8a-11ec-9377-226cec7cb58a','8ec375cf-4b8a-11ec-9377-226cec7cb58a'),(662,'8e9bdad1-4b8a-11ec-9377-226cec7cb58a','8ec747f5-4b8a-11ec-9377-226cec7cb58a'),(662,'94c1b3cf-2b59-11ec-9377-226cec7cb58a','94c77f29-2b59-11ec-9377-226cec7cb58a'),(662,'94c1b3cf-2b59-11ec-9377-226cec7cb58a','94cb30f9-2b59-11ec-9377-226cec7cb58a'),(662,'94c1b3cf-2b59-11ec-9377-226cec7cb58a','94ce93c7-2b59-11ec-9377-226cec7cb58a'),(662,'94c1b3cf-2b59-11ec-9377-226cec7cb58a','94e9a15c-2b59-11ec-9377-226cec7cb58a'),(662,'94c1b3cf-2b59-11ec-9377-226cec7cb58a','94eeedbf-2b59-11ec-9377-226cec7cb58a'),(662,'94c1b3cf-2b59-11ec-9377-226cec7cb58a','94fc41f3-2b59-11ec-9377-226cec7cb58a'),(662,'94c1b3cf-2b59-11ec-9377-226cec7cb58a','94ffa87d-2b59-11ec-9377-226cec7cb58a'),(662,'94c1b3cf-2b59-11ec-9377-226cec7cb58a','9511cb22-2b59-11ec-9377-226cec7cb58a'),(662,'94c1b3cf-2b59-11ec-9377-226cec7cb58a','9514c875-2b59-11ec-9377-226cec7cb58a'),(662,'94c1b3cf-2b59-11ec-9377-226cec7cb58a','95181c09-2b59-11ec-9377-226cec7cb58a'),(662,'97fbb232-3417-11ed-a752-9ec33d03e6dd','97fdea91-3417-11ed-a752-9ec33d03e6dd'),(662,'97fbb232-3417-11ed-a752-9ec33d03e6dd','97ff66d6-3417-11ed-a752-9ec33d03e6dd'),(662,'b9c564a0-72d3-11ec-9377-226cec7cb58a','b9d391dc-72d3-11ec-9377-226cec7cb58a'),(662,'b9c564a0-72d3-11ec-9377-226cec7cb58a','b9d5de8c-72d3-11ec-9377-226cec7cb58a'),(662,'b9c564a0-72d3-11ec-9377-226cec7cb58a','b9d854a5-72d3-11ec-9377-226cec7cb58a'),(662,'b9c564a0-72d3-11ec-9377-226cec7cb58a','b9da69b7-72d3-11ec-9377-226cec7cb58a'),(662,'b9c564a0-72d3-11ec-9377-226cec7cb58a','b9dc2b5e-72d3-11ec-9377-226cec7cb58a'),(662,'b9c564a0-72d3-11ec-9377-226cec7cb58a','b9de0e95-72d3-11ec-9377-226cec7cb58a'),(662,'b9c564a0-72d3-11ec-9377-226cec7cb58a','b9e0e714-72d3-11ec-9377-226cec7cb58a'),(662,'b9c564a0-72d3-11ec-9377-226cec7cb58a','b9e39911-72d3-11ec-9377-226cec7cb58a'),(662,'b9c564a0-72d3-11ec-9377-226cec7cb58a','b9e5d1e0-72d3-11ec-9377-226cec7cb58a'),(662,'b9c564a0-72d3-11ec-9377-226cec7cb58a','b9e83025-72d3-11ec-9377-226cec7cb58a'),(662,'c242f1ff-1f8a-11ec-9377-226cec7cb58a','c2475b5d-1f8a-11ec-9377-226cec7cb58a'),(662,'c242f1ff-1f8a-11ec-9377-226cec7cb58a','c24a06b2-1f8a-11ec-9377-226cec7cb58a'),(662,'c242f1ff-1f8a-11ec-9377-226cec7cb58a','c24da80c-1f8a-11ec-9377-226cec7cb58a'),(662,'c242f1ff-1f8a-11ec-9377-226cec7cb58a','c2503be7-1f8a-11ec-9377-226cec7cb58a'),(662,'c242f1ff-1f8a-11ec-9377-226cec7cb58a','c25432d6-1f8a-11ec-9377-226cec7cb58a'),(662,'c242f1ff-1f8a-11ec-9377-226cec7cb58a','c2574ae3-1f8a-11ec-9377-226cec7cb58a'),(662,'c242f1ff-1f8a-11ec-9377-226cec7cb58a','c25a1819-1f8a-11ec-9377-226cec7cb58a'),(662,'c242f1ff-1f8a-11ec-9377-226cec7cb58a','c25cb650-1f8a-11ec-9377-226cec7cb58a'),(662,'c242f1ff-1f8a-11ec-9377-226cec7cb58a','c25f3035-1f8a-11ec-9377-226cec7cb58a'),(662,'c242f1ff-1f8a-11ec-9377-226cec7cb58a','c2617b6f-1f8a-11ec-9377-226cec7cb58a'),(662,'dd1a3f6f-c7db-11ed-9ced-0050569a5229','dd1d9407-c7db-11ed-9ced-0050569a5229'),(662,'dd1a3f6f-c7db-11ed-9ced-0050569a5229','dd202b6b-c7db-11ed-9ced-0050569a5229'),(662,'deed6e05-f711-11ec-a752-9ec33d03e6dd','def017c4-f711-11ec-a752-9ec33d03e6dd'),(662,'deed6e05-f711-11ec-a752-9ec33d03e6dd','def1623b-f711-11ec-a752-9ec33d03e6dd'),(662,'e0860c80-5ad5-11ed-a752-9ec33d03e6dd','e0880d3b-5ad5-11ed-a752-9ec33d03e6dd'),(662,'e0860c80-5ad5-11ed-a752-9ec33d03e6dd','e0898270-5ad5-11ed-a752-9ec33d03e6dd'),(662,'e0860c80-5ad5-11ed-a752-9ec33d03e6dd','e08b1d8c-5ad5-11ed-a752-9ec33d03e6dd'),(662,'e0860c80-5ad5-11ed-a752-9ec33d03e6dd','e08c98f8-5ad5-11ed-a752-9ec33d03e6dd'),(662,'e0860c80-5ad5-11ed-a752-9ec33d03e6dd','e08dfb34-5ad5-11ed-a752-9ec33d03e6dd'),(662,'e0860c80-5ad5-11ed-a752-9ec33d03e6dd','e08f638b-5ad5-11ed-a752-9ec33d03e6dd'),(662,'e0860c80-5ad5-11ed-a752-9ec33d03e6dd','e0909d5b-5ad5-11ed-a752-9ec33d03e6dd'),(662,'e0860c80-5ad5-11ed-a752-9ec33d03e6dd','e0920e08-5ad5-11ed-a752-9ec33d03e6dd'),(662,'eaa8869e-7d4b-11ea-947d-226cec7cb58a','eaabd852-7d4b-11ea-947d-226cec7cb58a'),(662,'eaa8869e-7d4b-11ea-947d-226cec7cb58a','eaadb843-7d4b-11ea-947d-226cec7cb58a'),(662,'eaa8869e-7d4b-11ea-947d-226cec7cb58a','eab0f62d-7d4b-11ea-947d-226cec7cb58a'),(662,'f1fba7b8-4c4f-11ec-9377-226cec7cb58a','f24be2c4-4c4f-11ec-9377-226cec7cb58a'),(662,'f1fba7b8-4c4f-11ec-9377-226cec7cb58a','f26a7348-4c4f-11ec-9377-226cec7cb58a'),(662,'f1fba7b8-4c4f-11ec-9377-226cec7cb58a','f26e9ce0-4c4f-11ec-9377-226cec7cb58a'),(662,'f1fba7b8-4c4f-11ec-9377-226cec7cb58a','f271870f-4c4f-11ec-9377-226cec7cb58a'),(662,'f1fba7b8-4c4f-11ec-9377-226cec7cb58a','f2745c07-4c4f-11ec-9377-226cec7cb58a'),(662,'f1fba7b8-4c4f-11ec-9377-226cec7cb58a','f2781fff-4c4f-11ec-9377-226cec7cb58a'),(662,'f1fba7b8-4c4f-11ec-9377-226cec7cb58a','f27b8845-4c4f-11ec-9377-226cec7cb58a'),(662,'f1fba7b8-4c4f-11ec-9377-226cec7cb58a','f27e89e8-4c4f-11ec-9377-226cec7cb58a'),(662,'f1fba7b8-4c4f-11ec-9377-226cec7cb58a','f28192d9-4c4f-11ec-9377-226cec7cb58a'),(662,'f1fba7b8-4c4f-11ec-9377-226cec7cb58a','f28655e5-4c4f-11ec-9377-226cec7cb58a');
/*!40000 ALTER TABLE `ReceivedAttachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ReceivedMessage`
--

DROP TABLE IF EXISTS `ReceivedMessage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ReceivedMessage` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `messageTransmitted` tinyint(1) NOT NULL DEFAULT '0',
  `messageSubject` varchar(45) NOT NULL,
  `body` text,
  `fromId` mediumint unsigned NOT NULL,
  `originMessageId` varchar(36) DEFAULT NULL,
  `discussionId` varchar(36) NOT NULL,
  `readStatus` enum('READ','UNREAD') DEFAULT 'UNREAD',
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `fromId` (`fromId`),
  KEY `discussionId` (`discussionId`,`ownerId`),
  CONSTRAINT `ReceivedMessage_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ReceivedMessage_ibfk_2` FOREIGN KEY (`fromId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ReceivedMessage_ibfk_3` FOREIGN KEY (`discussionId`, `ownerId`) REFERENCES `Discussion` (`uuid`, `ownerId`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ReceivedMessage`
--

LOCK TABLES `ReceivedMessage` WRITE;
/*!40000 ALTER TABLE `ReceivedMessage` DISABLE KEYS */;
INSERT INTO `ReceivedMessage` VALUES ('0be3b4a9-d903-11ed-9ced-0050569a5229',662,1,'#','Commande n° 1.21.8.S1',662,'092ae2c6-d903-11ed-9278-00d86184ce0e','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','READ','2023-04-12 09:24:25.000',NULL,'2023-04-12 09:24:24.000','2023-06-13 11:50:47.607','2023-06-13 13:50:47.615'),('1cc1a348-7d48-11ea-947d-226cec7cb58a',662,1,'#','#',662,'9c5638bd-fe4f-41c6-a7a7-5c3c908a9555','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','READ','2020-04-12 08:29:35.000',NULL,'2020-04-12 08:29:34.000','2023-06-13 12:02:21.878','2023-06-13 14:02:21.878'),('1ced8cbe-7d48-11ea-947d-226cec7cb58a',662,1,'#','Test',662,'76a19cfc-ee2e-426f-b476-ac85c20f660d','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','READ','2020-04-12 08:17:05.000',NULL,'2020-04-12 08:17:04.000','2023-06-13 12:02:21.827','2023-06-13 14:02:21.827'),('1d1ad35b-7d48-11ea-947d-226cec7cb58a',662,1,'#','Commande n° 1.2.3.1',662,'b43015be-893c-4d0c-8657-1cd6c0eadc67','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','READ','2020-04-12 08:28:42.000',NULL,'2020-04-12 08:28:41.000','2023-06-13 12:02:21.850','2023-06-13 14:02:21.850'),('1e334837-8121-11ed-a752-9ec33d03e6dd',662,1,'#','SMILERS n° 1.21.6.S1',662,'c13ba56c-2431-4f83-a199-a713f2029337','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','READ','2022-12-21 12:18:09.000',NULL,'2022-12-21 12:18:08.000','2023-06-13 12:02:23.491','2023-06-13 14:02:23.491'),('208fe542-91ae-11ed-a752-9ec33d03e6dd',662,1,'#','SMILERS n° 1.21.7.S1',662,'bac96ac3-3fbd-4776-96d5-a1fcf7139710','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','READ','2023-01-11 13:47:50.000',NULL,'2023-01-11 13:47:49.000','2023-06-13 12:02:23.451','2023-06-13 14:02:23.451'),('35a9ff3d-8070-11ea-947d-226cec7cb58a',662,1,'#','Commande n° 1.6.1.1',662,'6a667e6c-44c0-4842-8b31-ab3873ddf15b','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','READ','2020-04-17 07:56:50.000',NULL,'2020-04-17 07:56:49.000','2023-06-13 12:02:22.293','2023-06-13 14:02:22.293'),('386ccd51-7ee2-11ea-947d-226cec7cb58a',662,1,'#','Commande n° 1.7.2.1',662,'92b54835-b001-4b26-a4eb-900f8c7ebd11','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','READ','2020-04-15 08:27:55.000',NULL,'2020-04-15 08:27:54.000','2023-06-13 12:02:22.064','2023-06-13 14:02:22.064'),('3f38add5-157f-11ed-a752-9ec33d03e6dd',662,1,'#','SMILERS n° 1.20.2.S1',662,'7fb08821-81d8-4569-9f19-ef8022fea368','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','READ','2022-08-06 13:59:37.000',NULL,'2022-08-06 13:59:36.000','2023-06-13 12:02:23.159','2023-06-13 14:02:23.159'),('5d45f086-f650-11ec-a752-9ec33d03e6dd',662,1,'#','SMILERS n° 1.21.2.S1',662,'0fc3bc59-0e74-46f1-9d1b-4edee6fffcc3','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','READ','2022-06-27 21:35:57.000',NULL,'2022-06-27 21:35:56.000','2023-06-13 12:02:23.188','2023-06-13 14:02:23.188'),('75fb40f5-5c35-11ed-a752-9ec33d03e6dd',662,1,'#','SMILERS n° 1.21.4.S1',662,'d3010d97-e435-4fa5-9054-e4add927b37f','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','READ','2022-11-04 12:40:19.000',NULL,'2022-11-04 12:40:18.000','2023-06-13 12:02:23.401','2023-06-13 14:02:23.401'),('8ccc441e-7ee5-11ea-947d-226cec7cb58a',662,1,'#','Commande n° 1.7.2.2',662,'5c3a887b-5354-4dce-a930-c0bf04c73c86','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','READ','2020-04-15 08:51:45.000',NULL,'2020-04-15 08:51:44.000','2023-06-13 12:02:22.241','2023-06-13 14:02:22.241'),('8e9bdad1-4b8a-11ec-9377-226cec7cb58a',662,1,'#','SMILERS n° 1.21.1.S1',662,'5d7fb378-e627-43df-a59e-10bf6266bc54','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','READ','2021-11-22 12:51:41.000',NULL,'2021-11-22 12:51:40.000','2023-06-13 12:02:22.804','2023-06-13 14:02:22.804'),('94c1b3cf-2b59-11ec-9377-226cec7cb58a',662,1,'#','SMILERS n° 1.20.1.S1',662,'2ac5c4e8-2400-4099-bdff-66744db946c7','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','READ','2021-10-12 14:40:29.000',NULL,'2021-10-12 14:40:28.000','2023-06-13 12:02:22.676','2023-06-13 14:02:22.676'),('97fbb232-3417-11ed-a752-9ec33d03e6dd',662,1,'#','SMILERS n° 1.21.3.S1',662,'b77a9c9d-2d03-4860-b7b9-86e311c509ed','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','READ','2022-09-14 12:25:45.000',NULL,'2022-09-14 12:25:44.000','2023-06-13 12:02:23.127','2023-06-13 14:02:23.127'),('b9c564a0-72d3-11ec-9377-226cec7cb58a',662,1,'#','SMILERS n° 1.23.1.S1',662,'f0e9fe66-4717-4100-b61c-0cac7c9b76c3','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','READ','2022-01-11 12:43:42.000',NULL,'2022-01-11 12:43:41.000','2023-06-13 12:02:23.056','2023-06-13 14:02:23.056'),('c242f1ff-1f8a-11ec-9377-226cec7cb58a',662,1,'#','SMILERS n° 1.19.1.S1',662,'23ab56bc-8ef1-4eb4-92c0-3f4eb41aa456','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','READ','2021-09-27 14:02:16.000',NULL,'2021-09-27 14:02:15.000','2023-06-13 12:02:22.548','2023-06-13 14:02:22.548'),('dd1a3f6f-c7db-11ed-9ced-0050569a5229',662,1,'#','SMILERS n° 1.19.4.S1',662,'93c345d1-454a-42fa-bfa7-8d68827d23f5','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','READ','2023-03-21 12:31:05.000',NULL,'2023-03-21 12:31:04.000','2023-04-12 04:41:32.793','2023-04-12 06:41:32.793'),('deed6e05-f711-11ec-a752-9ec33d03e6dd',662,1,'#','SMILERS n° 1.19.2.S1',662,'9c8474e3-ae2e-4f02-af12-ee8d56ae6406','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','READ','2022-06-28 20:41:06.000',NULL,'2022-06-28 20:41:05.000','2023-06-13 12:02:23.216','2023-06-13 14:02:23.216'),('e0860c80-5ad5-11ed-a752-9ec33d03e6dd',662,1,'#','SMILERS n° 1.19.3.S1',662,'0044629b-c48a-4f47-95b1-f178384b2b25','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','READ','2022-11-02 18:43:35.000',NULL,'2022-11-02 18:43:34.000','2023-06-13 12:02:23.336','2023-06-13 14:02:23.336'),('eaa8869e-7d4b-11ea-947d-226cec7cb58a',662,1,'#','Commande n° 1.2.2.2',662,'de057ea0-5a8b-4969-8ceb-44a19644bb0d','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','READ','2020-04-13 07:59:29.000',NULL,'2020-04-13 07:59:28.000','2023-06-13 12:02:21.925','2023-06-13 14:02:21.925'),('f1fba7b8-4c4f-11ec-9377-226cec7cb58a',662,1,'#','SMILERS n° 1.22.1.S1',662,'9243b91d-921e-40a3-a88d-f1a14409a45a','cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','READ','2021-11-23 12:24:38.000',NULL,'2021-11-23 12:24:37.000','2023-06-13 12:02:22.949','2023-06-13 14:02:22.949');
/*!40000 ALTER TABLE `ReceivedMessage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Scan`
--

DROP TABLE IF EXISTS `Scan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Scan` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL,
  `sessionId` varchar(36) NOT NULL,
  `type` enum('MAXILLAIRE','MANDIBULE','MORDU_ANTERIEUR','MORDU_POSTERIEUR_GAUCHE','MORDU_POSTERIEUR_DROIT') NOT NULL,
  `label` enum('PRE_PREPARATION','SCAN','SCANBODY') NOT NULL DEFAULT 'SCAN',
  `validated` tinyint(1) NOT NULL DEFAULT '0',
  `status` enum('IN_PROGRESS','NONE') NOT NULL DEFAULT 'IN_PROGRESS',
  `displayId` mediumint unsigned DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `comments` text,
  `createdById` varchar(36) DEFAULT NULL,
  `updatedById` varchar(36) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `sessionId` (`sessionId`),
  CONSTRAINT `Scan_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Scan_ibfk_2` FOREIGN KEY (`sessionId`) REFERENCES `Session` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Scan`
--

LOCK TABLES `Scan` WRITE;
/*!40000 ALTER TABLE `Scan` DISABLE KEYS */;
INSERT INTO `Scan` VALUES ('005e76e3-5a05-4d7a-b0cf-6c2c7adcc1a9',662,'296c061e-734b-4936-8af7-1f80653eff11','MANDIBULE','SCAN',1,'IN_PROGRESS',5,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-06 11:40:52.000','2020-04-06 11:41:19.000','2020-04-06 11:40:52.000','2020-12-15 14:15:36.000',NULL),('00f07cdc-1834-4ae1-a9fa-47699828c094',662,'b29b47d4-35f8-427d-9cd7-a393e48be2cf','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-10-12 12:38:33.000',NULL,'2021-10-12 12:40:26.000','2021-10-12 12:34:20.000','2021-10-12 14:34:20.000'),('0198b882-42bb-4c93-b173-3f7c572c22b5',662,'296c061e-734b-4936-8af7-1f80653eff11','MANDIBULE','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-06 11:18:45.000','2020-04-06 11:29:27.000','2020-04-06 11:18:45.000','2020-12-15 14:15:36.000',NULL),('019e5bd1-9330-4e70-8035-2fda343b0231',662,'6c6bb813-840d-454a-ab1d-9232434a4500','MAXILLAIRE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-09-27 12:10:35.000',NULL,'2021-09-27 12:26:09.000','2021-09-27 12:02:02.000','2021-09-27 14:02:02.000'),('066779ab-556d-4237-bd2a-be49882d249c',662,'88170486-b19f-4c31-a435-e67fd24917e9','MAXILLAIRE','SCAN',1,'NONE',2,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-12-29 08:34:35.000','2020-12-29 08:34:38.000','2020-12-29 08:34:35.000','2020-12-29 07:34:38.000',NULL),('085eb227-c20a-4e2d-8f5e-3267070c23a2',662,'becee89b-0c0c-4888-bd78-43480d883b03','MAXILLAIRE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-12-21 18:20:19.000','2020-12-21 18:20:42.000','2020-12-21 18:20:19.000','2020-12-21 17:20:42.000',NULL),('0a4e2bba-8cdb-4c4c-8a8d-a6f2b7de0f40',662,'bdf42f40-5a7a-435b-a5e0-eb33efefbc97','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-10 11:42:02.000','2020-04-10 11:47:08.000','2020-04-10 11:42:02.000','2020-12-15 14:15:36.000',NULL),('0a606279-3c91-4220-b876-e620d1bf52f6',662,'daf632b1-2c49-42c8-8899-0a0b2448bc3a','MANDIBULE','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-18 09:32:13.000',NULL,'2020-04-18 09:32:13.000','2021-06-08 17:43:37.000','2021-06-08 19:43:37.000'),('0b6ec729-5c4e-4869-9d67-6377923ed207',662,'2b934532-4b04-4025-8e7f-894c9c01b184','MANDIBULE','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-07 07:26:14.000','2023-04-12 06:41:28.000','2020-04-07 07:26:14.000','2023-06-13 12:02:15.112','2023-06-13 14:02:15.112'),('0c8af1cb-8054-4a35-9cfe-449c19dbe59b',662,'bef02815-bbf7-4520-882b-2396474f4bb3','MORDU_ANTERIEUR','SCAN',1,'IN_PROGRESS',2,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-16 07:10:45.000','2023-04-12 06:41:28.000','2020-04-16 07:10:45.000','2023-06-13 12:02:15.143','2023-06-13 14:02:15.143'),('0d792709-57f3-49e1-963c-d2dc35a59d12',662,'484ae4d8-329f-49b5-8d83-312a8a92ff22','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-02-27 10:53:23.000',NULL,'2021-02-27 10:55:30.000','2021-02-27 09:59:00.000','2021-02-27 10:59:00.000'),('0e5656e0-946b-41b2-935b-ea820746e5a9',662,'d70cc224-5e0d-4b47-9270-d8e23a25b566','MAXILLAIRE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2023-03-21 12:12:00.000',NULL,'2023-03-21 12:27:29.000','2023-03-21 11:30:59.000','2023-03-21 12:30:59.000'),('0f18aace-5cf2-4d46-b56f-f8dc123e1f91',662,'31210683-bc06-4b84-83d9-ce60f32308e4','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',2,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-11-23 12:19:47.000',NULL,'2021-11-23 12:21:30.000','2021-11-23 11:23:20.000','2021-11-23 12:23:20.000'),('107f2922-62ee-42d9-8e35-69d71587db0b',662,'254f3fc9-4782-4658-bb34-f2ca1c9b6382','MANDIBULE','SCAN',1,'IN_PROGRESS',2,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-05-21 08:13:17.000',NULL,'2020-05-21 08:13:17.000','2021-03-19 09:24:46.000','2021-03-19 10:24:46.000'),('10c9626c-901e-4a0e-8f05-62042bf69c04',662,'e06b73d5-45f7-4906-ba73-560d66ac56af','MANDIBULE','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-16 11:14:30.000',NULL,'2020-04-16 11:14:30.000','2021-03-19 09:22:16.000','2021-03-19 10:22:16.000'),('12f64013-f8aa-44bb-91e8-38c23737152b',662,'348477f7-c7a9-4bb3-8b28-3da592902286','MAXILLAIRE','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-29 14:50:37.000',NULL,'2020-04-29 14:50:37.000','2021-03-19 09:22:24.000','2021-03-19 10:22:24.000'),('13e9c4af-5ddc-4a12-ae1b-2b802c735c3f',662,'daf632b1-2c49-42c8-8899-0a0b2448bc3a','MORDU_ANTERIEUR','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-18 09:37:59.000',NULL,'2020-04-18 09:37:59.000','2021-06-08 17:43:35.000','2021-06-08 19:43:35.000'),('16cf8664-2af0-446a-ac6d-ef0e40edb71d',662,'daf632b1-2c49-42c8-8899-0a0b2448bc3a','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-18 09:35:44.000',NULL,'2020-04-18 09:35:44.000','2021-06-08 17:43:36.000','2021-06-08 19:43:36.000'),('18365744-4019-43e1-933f-9fa52db1a30d',662,'16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c','MORDU_ANTERIEUR','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-06-08 20:51:55.000',NULL,'2021-06-08 20:56:54.000','2021-06-08 18:57:43.000','2021-06-08 20:57:43.000'),('19627cd9-e6e6-4c6f-9a62-46d708ca49bc',662,'484ae4d8-329f-49b5-8d83-312a8a92ff22','MANDIBULE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-02-27 10:27:21.000',NULL,'2021-02-27 10:43:31.000','2021-02-27 09:48:14.000','2021-02-27 10:48:14.000'),('1bb0385c-ad64-4ddb-af9d-970d6d0e6217',662,'d402edb5-8449-46a8-862f-a1cd1ee21cf6','MANDIBULE','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-30 19:38:11.000','2020-04-30 19:40:01.000','2020-04-30 19:38:11.000','2020-12-15 14:15:36.000',NULL),('1c636d2a-ce13-48c7-976b-fa1f3cae798f',662,'296c061e-734b-4936-8af7-1f80653eff11','MANDIBULE','SCAN',1,'IN_PROGRESS',6,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-06 11:41:34.000','2021-03-19 10:22:13.000','2020-04-06 11:41:34.000','2021-03-19 09:22:13.000','2021-03-19 10:22:13.000'),('1c6adc05-0655-4ad6-bcc9-27b0ef578ded',662,'ed8b4bd5-0a61-4563-b6a4-6ec124bc388d','MAXILLAIRE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2022-06-28 20:03:47.000',NULL,'2022-06-28 20:39:41.000','2022-06-28 18:40:57.000','2022-06-28 20:40:57.000'),('1e8824f7-3c76-4fe0-bd8c-f865f725dab2',662,'31210683-bc06-4b84-83d9-ce60f32308e4','MORDU_ANTERIEUR','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-11-23 12:21:40.000',NULL,'2021-11-23 12:23:17.000','2021-11-23 11:24:17.000','2021-11-23 12:24:17.000'),('1ff82da8-d913-11ed-b558-229278a3c906',662,'a62ebb05-d910-11ed-b558-229278a3c906','MANDIBULE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2023-04-12 11:19:28.000',NULL,'2023-04-12 11:29:41.000','2023-06-13 12:02:15.632','2023-06-13 14:02:15.632'),('209f3c55-7380-4efa-8e6c-dfe8c99792a6',662,'983c39b6-656b-4bf2-bf43-da1625adb861','MANDIBULE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2023-01-11 12:12:57.000',NULL,'2023-01-11 12:58:29.000','2023-01-11 12:47:44.000','2023-01-11 13:47:44.000'),('254d7cff-f2aa-4d41-8b1c-7b0bdd6386ff',662,'f72f6016-0f75-4789-9924-1bc9aa64c2f1','MANDIBULE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2022-08-06 13:47:10.000',NULL,'2022-08-06 13:56:38.000','2022-08-06 11:58:03.000','2022-08-06 13:58:03.000'),('26a765d3-8b92-4861-984a-bd9c8040209b',662,'5f895907-3eed-4aa7-995a-f7e1c9661a0a','MANDIBULE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2022-03-11 10:14:03.000',NULL,'2022-03-11 10:31:25.000','2022-03-11 09:32:40.000','2022-03-11 10:32:40.000'),('2a466f6b-3960-4b1b-bb27-def76229cccc',662,'5bd97219-8b9e-46f5-ab9b-87ded07aa8a2','MANDIBULE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2022-11-04 12:14:24.000',NULL,'2022-11-04 12:31:51.000','2022-11-04 11:40:15.000','2022-11-04 12:40:15.000'),('2ab117e1-acf7-41d0-8ec8-d7f769012bf5',662,'96e43a62-294d-4726-8ccf-ea4ec6e66267','MAXILLAIRE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-04-25 11:19:36.000','2021-04-25 11:28:19.000','2021-04-25 11:19:36.000','2021-04-25 09:28:19.000',NULL),('2bf301a3-b61c-4ddd-b6a2-4924c804d5f8',662,'bdf42f40-5a7a-435b-a5e0-eb33efefbc97','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'IN_PROGRESS',3,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-10 11:51:27.000',NULL,'2020-04-10 11:51:27.000','2021-03-19 09:22:19.000','2021-03-19 10:22:19.000'),('2d566d37-f38f-4b79-ac8f-48009ae22310',662,'bdf42f40-5a7a-435b-a5e0-eb33efefbc97','MAXILLAIRE','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-10 11:37:06.000',NULL,'2020-04-10 11:37:06.000','2021-03-19 09:22:20.000','2021-03-19 10:22:20.000'),('2e1e941f-909d-4203-8cb9-80d5f146fca1',662,'c9d37315-5f17-421c-8afb-302fa9b0bebe','MANDIBULE','SCAN',1,'IN_PROGRESS',3,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-07 07:05:43.000','2020-04-07 07:05:47.000','2020-04-07 07:05:43.000','2020-12-15 14:15:36.000',NULL),('34f5d93d-6a1f-4f94-ab20-4105c2cce30a',662,'16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c','MANDIBULE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-06-08 20:20:25.000','2021-06-08 20:41:12.000','2021-06-08 20:31:01.000','2021-06-08 18:41:12.000','2021-06-08 20:41:12.000'),('375f8fb7-d198-4281-9948-bba81b98e824',662,'ada38401-e257-4f32-8319-c7a394ce4463','MAXILLAIRE','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-10 07:44:51.000',NULL,'2020-04-10 07:44:51.000','2021-03-19 09:22:30.000','2021-03-19 10:22:30.000'),('37ff1278-3dd1-470a-8159-e763f6626f5d',662,'a18ca6df-d765-4c6a-be28-13abd1c350af','MANDIBULE','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-17 11:12:11.000',NULL,'2020-04-17 11:12:11.000','2021-03-19 09:22:22.000','2021-03-19 10:22:22.000'),('380086c3-2ecb-4345-b6d0-f476fb97c3f9',662,'296c061e-734b-4936-8af7-1f80653eff11','MANDIBULE','SCAN',1,'IN_PROGRESS',4,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-06 11:32:40.000','2020-04-06 11:35:12.000','2020-04-06 11:32:40.000','2020-12-15 14:15:36.000',NULL),('3a315f7b-8cf2-4d0c-bf92-fecb623fe530',662,'09f15124-6bba-4565-bfe4-efb3c6c3a17d','MAXILLAIRE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2022-09-14 12:11:22.000',NULL,'2022-09-14 12:23:55.000','2022-09-14 10:25:38.000','2022-09-14 12:25:38.000'),('3d3ae697-dc08-4ce2-8b32-4f79891607c2',662,'52372fba-991e-4b09-abce-2195e775fd19','MORDU_ANTERIEUR','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-11-22 12:47:39.000',NULL,'2021-11-22 12:49:43.000','2021-11-22 11:51:37.000','2021-11-22 12:51:37.000'),('3e1d8e57-feae-45d6-80f0-9d0be041ff7a',662,'20b31e3a-565c-49b0-b2ff-0dae86b25c76','MAXILLAIRE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2022-09-19 10:52:16.000',NULL,'2022-09-19 11:48:35.000','2022-09-19 09:55:17.000','2022-09-19 11:55:17.000'),('41b8d05c-738b-4161-9f86-27222b61ad66',662,'16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-06-08 20:47:04.000',NULL,'2021-06-08 20:48:52.000','2021-06-08 18:49:16.000','2021-06-08 20:49:16.000'),('42b09cf6-e30d-4d35-a17d-d8e8b4564638',662,'b29b47d4-35f8-427d-9cd7-a393e48be2cf','MAXILLAIRE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-10-12 12:26:42.000',NULL,'2021-10-12 12:37:46.000','2021-10-12 12:40:06.000','2021-10-12 14:40:06.000'),('437ef945-eb42-4841-9b20-34804bd5cfd6',662,'16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c','MANDIBULE','SCAN',1,'NONE',2,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-06-08 20:31:23.000',NULL,'2021-06-08 20:46:42.000','2021-06-08 18:48:54.000','2021-06-08 20:48:54.000'),('4447c001-b4b0-486d-bbde-a9eae11f083f',662,'bdf42f40-5a7a-435b-a5e0-eb33efefbc97','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'IN_PROGRESS',2,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-10 11:47:36.000','2020-04-10 11:47:44.000','2020-04-10 11:47:36.000','2020-12-15 14:15:36.000',NULL),('44b8a221-3707-430b-bc84-cacca7bf7d8a',662,'16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-06-08 20:49:32.000',NULL,'2021-06-08 20:51:49.000','2021-06-08 18:56:55.000','2021-06-08 20:56:55.000'),('44ccf5f6-834d-4090-88dc-399b19fed47e',662,'c6fffa68-cc65-471a-a58e-135ebe4d0772','MORDU_ANTERIEUR','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-02-16 13:00:27.000',NULL,'2021-02-16 13:05:09.000','2021-02-16 12:05:37.000','2021-02-16 13:05:37.000'),('453abb20-3827-4f8b-b57f-c656c72ebf11',662,'b29b47d4-35f8-427d-9cd7-a393e48be2cf','MANDIBULE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-10-12 12:15:50.000',NULL,'2021-10-12 12:26:35.000','2021-10-12 12:40:26.000','2021-10-12 14:40:26.000'),('45b21304-1129-40a2-b60e-d72a2bf96e72',662,'2ed4960a-e6fa-46de-a306-32385df3346c','MANDIBULE','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-12 08:05:51.000','2023-04-12 06:41:28.000','2020-04-12 08:05:51.000','2023-06-13 12:02:15.190','2023-06-13 14:02:15.190'),('470d4798-40ea-4ce5-a574-22fcf013d82d',662,'e06b73d5-45f7-4906-ba73-560d66ac56af','MORDU_POSTERIEUR_DROIT','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-16 11:17:29.000',NULL,'2020-04-16 11:17:29.000','2021-03-19 09:22:17.000','2021-03-19 10:22:17.000'),('4a2eec76-a5f3-44f0-b389-4734998fa2d3',662,'b87f1382-55d4-4e52-b63a-6f387df18b16','MANDIBULE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-12-29 11:13:49.000',NULL,'2020-12-29 11:28:33.000','2021-06-08 17:45:19.000','2021-06-08 19:45:19.000'),('4c0a0af6-4d22-42cf-a5ab-c6eb058dec60',662,'c9d37315-5f17-421c-8afb-302fa9b0bebe','MANDIBULE','SCAN',1,'IN_PROGRESS',8,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-07 07:11:31.000','2020-04-07 07:11:35.000','2020-04-07 07:11:31.000','2020-12-15 14:15:36.000',NULL),('4caeed6a-b015-4556-8794-2c3a00fea341',662,'254f3fc9-4782-4658-bb34-f2ca1c9b6382','MANDIBULE','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-05-21 08:03:20.000','2021-03-19 10:22:13.000','2020-05-21 08:03:20.000','2021-03-19 09:22:13.000','2021-03-19 10:22:13.000'),('50e1896b-8565-4257-9a61-2a685fff8165',662,'6c6bb813-840d-454a-ab1d-9232434a4500','MANDIBULE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-09-27 12:26:20.000',NULL,'2021-09-27 12:43:43.000','2021-09-27 12:02:12.000','2021-09-27 14:02:12.000'),('527c942e-3aa0-4028-b02a-8b3f137657be',662,'8d012545-b857-4595-a69d-1a2b1c750e13','MAXILLAIRE','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-27 16:19:07.000','2023-04-12 06:41:28.000','2020-04-27 16:19:07.000','2023-06-13 12:02:15.220','2023-06-13 14:02:15.220'),('534cca35-8182-4f61-aa57-03bad8172eac',662,'b87f1382-55d4-4e52-b63a-6f387df18b16','MORDU_ANTERIEUR','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-12-29 11:33:17.000',NULL,'2020-12-29 11:37:09.000','2021-06-08 17:45:18.000','2021-06-08 19:45:18.000'),('55058b25-acc2-43c3-b9d2-b8bb64bfcbb9',662,'daf632b1-2c49-42c8-8899-0a0b2448bc3a','MORDU_POSTERIEUR_DROIT','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-18 09:33:55.000',NULL,'2020-04-18 09:33:55.000','2021-06-08 17:43:37.000','2021-06-08 19:43:37.000'),('57cfef6d-c27e-45fa-81d7-e63b4f8c4429',662,'bdf42f40-5a7a-435b-a5e0-eb33efefbc97','MORDU_POSTERIEUR_DROIT','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-10 11:41:52.000',NULL,'2020-04-10 11:41:52.000','2021-03-19 09:22:19.000','2021-03-19 10:22:19.000'),('57e7671e-1671-4ee9-96a0-650a56963aa8',662,'484ae4d8-329f-49b5-8d83-312a8a92ff22','MORDU_ANTERIEUR','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-02-27 10:55:32.000',NULL,'2021-02-27 10:59:00.000','2021-02-27 09:59:48.000','2021-02-27 10:59:48.000'),('5a4f6b62-6381-4a1e-bbef-61746f2722d3',662,'12115366-8eb9-470b-a097-5d28bb5fdf38','MORDU_ANTERIEUR','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2022-01-11 12:39:06.000',NULL,'2022-01-11 12:41:15.000','2022-01-11 11:43:37.000','2022-01-11 12:43:37.000'),('5a59f382-4b59-4867-8640-021d20bdcd59',662,'b5b4db66-f433-46fb-b794-d632b8fe8e1d','MORDU_ANTERIEUR','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2022-11-02 12:35:04.000',NULL,'2022-11-02 12:36:21.000','2022-11-02 14:09:59.000','2022-11-02 15:09:59.000'),('5a5e6904-4736-4443-bbd0-be73066af8c3',662,'f7b71416-57aa-4d3d-a2e5-0e6c1519f6e8','MAXILLAIRE','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-14 12:10:37.000','2023-04-12 06:41:29.000','2020-04-14 12:10:37.000','2023-06-13 12:02:15.248','2023-06-13 14:02:15.248'),('643b3b5a-e991-4dbf-95c8-2fd609f83a8b',662,'1ec1f707-d702-496a-b2f0-e55b08c06dcb','MAXILLAIRE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-02-01 20:11:38.000',NULL,'2021-02-01 20:56:52.000','2021-02-01 20:04:35.000','2021-02-01 21:04:35.000'),('6445b6e3-0c4a-44d3-84e8-7f315911b8ee',662,'53a17fdc-5de8-45aa-a9cb-ebea4886f6ff','MAXILLAIRE','SCAN',1,'IN_PROGRESS',2,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-07-08 19:54:07.000','2020-07-08 19:59:48.000','2020-07-08 19:54:07.000','2020-12-15 14:15:36.000',NULL),('65315958-b964-4f7e-a111-9c7695d8092b',662,'a18ca6df-d765-4c6a-be28-13abd1c350af','MORDU_POSTERIEUR_DROIT','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-17 11:14:15.000',NULL,'2020-04-17 11:14:15.000','2021-03-19 09:22:23.000','2021-03-19 10:22:23.000'),('68be6188-9e82-4de8-af30-5a19b2224813',662,'c9d37315-5f17-421c-8afb-302fa9b0bebe','MANDIBULE','SCAN',1,'IN_PROGRESS',7,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-07 07:11:24.000','2020-04-07 07:11:29.000','2020-04-07 07:11:24.000','2020-12-15 14:15:36.000',NULL),('6ce1c2d0-1849-4a2a-bfd9-05247b74c2d7',662,'bef02815-bbf7-4520-882b-2396474f4bb3','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-15 07:39:22.000','2023-04-12 06:41:29.000','2020-04-15 07:39:22.000','2023-06-13 12:02:15.275','2023-06-13 14:02:15.275'),('6ce24fb2-7744-476b-a643-7e304d3ac013',662,'12115366-8eb9-470b-a097-5d28bb5fdf38','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2022-01-11 12:35:51.000',NULL,'2022-01-11 12:37:28.000','2022-01-11 11:42:19.000','2022-01-11 12:42:19.000'),('6fafe104-bdc1-41a6-9977-b1bbb351a329',662,'c9d37315-5f17-421c-8afb-302fa9b0bebe','MANDIBULE','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-07 06:42:43.000','2023-04-12 06:41:29.000','2020-04-07 06:42:43.000','2023-06-13 12:02:15.318','2023-06-13 14:02:15.318'),('76ece440-81ad-42c8-ab91-f99fa29e2a83',662,'9e007066-06fd-4fa1-a49a-f1165de95f83','MAXILLAIRE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2023-04-11 20:33:25.000',NULL,'2023-04-11 20:49:14.000','2023-06-13 12:02:15.331','2023-06-13 14:02:15.331'),('76f39717-6f88-4e19-800c-f827a697a4d6',662,'bef02815-bbf7-4520-882b-2396474f4bb3','MORDU_POSTERIEUR_DROIT','SCAN',1,'IN_PROGRESS',2,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-16 07:21:50.000','2023-04-12 06:41:29.000','2020-04-16 07:21:50.000','2023-06-13 12:02:15.376','2023-06-13 14:02:15.376'),('778a761c-339e-4143-a807-735b174d9714',662,'bef02815-bbf7-4520-882b-2396474f4bb3','MAXILLAIRE','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-15 07:35:10.000','2023-04-12 06:41:29.000','2020-04-15 07:35:10.000','2023-06-13 12:02:15.438','2023-06-13 14:02:15.438'),('793e84ce-b088-458d-82f5-33fab1f5e7de',662,'12115366-8eb9-470b-a097-5d28bb5fdf38','MAXILLAIRE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2022-01-11 12:07:16.000',NULL,'2022-01-11 12:23:20.000','2022-01-11 11:31:13.000','2022-01-11 12:31:13.000'),('79548cb6-a61f-44cb-b6f7-cab7698f7465',662,'1ec1f707-d702-496a-b2f0-e55b08c06dcb','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-02-01 21:09:48.000',NULL,'2021-02-01 21:15:43.000','2021-02-01 20:19:46.000','2021-02-01 21:19:46.000'),('7a39120e-2f79-4c3e-af4d-af72e8ca8062',662,'c6fffa68-cc65-471a-a58e-135ebe4d0772','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-02-16 12:53:10.000',NULL,'2021-02-16 13:00:23.000','2021-02-16 12:05:09.000','2021-02-16 13:05:09.000'),('7a480eb2-a7b4-4ec5-b628-ef6c2043dd7a',662,'1ec1f707-d702-496a-b2f0-e55b08c06dcb','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-02-01 21:15:51.000',NULL,'2021-02-01 21:19:46.000','2021-02-01 20:22:34.000','2021-02-01 21:22:34.000'),('7f9aec2d-6246-4413-842d-78d2e0bddb1e',662,'78636467-a73b-4270-8bc5-35a2664dec9d','MANDIBULE','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-12 07:48:43.000','2023-04-12 06:41:29.000','2020-04-12 07:48:43.000','2023-06-13 12:02:15.463','2023-06-13 14:02:15.463'),('7fad3bba-f2b2-41ce-849b-756d995c0414',662,'1a616ac1-2ca3-4d23-ae5e-349558c26c37','MAXILLAIRE','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-11 07:50:01.000',NULL,'2020-04-11 07:50:01.000','2021-03-19 09:22:31.000','2021-03-19 10:22:31.000'),('802e2d49-5b37-47b7-b8e9-4fb4bff1f62f',662,'5f895907-3eed-4aa7-995a-f7e1c9661a0a','MAXILLAIRE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2022-03-11 10:45:22.000',NULL,'2022-03-11 11:13:47.000','2022-03-11 10:17:45.000','2022-03-11 11:17:45.000'),('83a48470-7c96-4c50-a665-60e895c2708c',662,'31210683-bc06-4b84-83d9-ce60f32308e4','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-11-23 12:18:10.000','2021-11-23 12:19:10.000','2021-11-23 12:18:10.000','2021-11-23 11:19:10.000',NULL),('84f6bd13-de48-43a0-9b1a-5d9c62048a82',662,'86af9a1e-ac57-479e-b67e-5429fbdf4230','MAXILLAIRE','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-09-09 19:35:53.000','2020-09-09 19:43:59.000','2020-09-09 19:35:53.000','2020-12-15 14:15:36.000',NULL),('876f775b-e8a0-4b7f-bea0-0c93a7041d17',662,'b87f1382-55d4-4e52-b63a-6f387df18b16','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-12-29 11:30:34.000',NULL,'2020-12-29 11:33:11.000','2021-06-08 17:43:35.000','2021-06-08 19:43:35.000'),('87a0a17a-c973-40c2-9d84-2392b0d62afb',662,'d402edb5-8449-46a8-862f-a1cd1ee21cf6','MAXILLAIRE','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-30 19:37:49.000',NULL,'2020-04-30 19:37:49.000','2021-09-27 11:56:30.000','2021-09-27 13:56:30.000'),('881d38cc-cf89-4329-8456-b90f8c997725',662,'b29b47d4-35f8-427d-9cd7-a393e48be2cf','MORDU_ANTERIEUR','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-10-12 12:42:48.000',NULL,'2021-10-12 12:44:17.000','2021-10-12 12:35:19.000','2021-10-12 14:35:19.000'),('89d67cc7-cbc8-46c7-a451-75d445a9af91',662,'c17a41dd-a1dc-4b45-8bc4-cdaf9f8a6853','MAXILLAIRE','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-11 08:43:43.000','2020-04-11 09:01:22.000','2020-04-11 08:43:43.000','2020-12-15 14:15:36.000',NULL),('8a4f0a25-fae8-4564-8f4a-63f4168b2915',662,'e06b73d5-45f7-4906-ba73-560d66ac56af','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-16 11:20:50.000',NULL,'2020-04-16 11:20:50.000','2021-03-19 09:22:17.000','2021-03-19 10:22:17.000'),('8cfba4c1-10f6-4525-a96d-8ea257cabbed',662,'c17a41dd-a1dc-4b45-8bc4-cdaf9f8a6853','MAXILLAIRE','SCAN',1,'IN_PROGRESS',2,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-11 09:26:06.000','2020-04-11 10:15:29.000','2020-04-11 09:26:06.000','2020-12-15 14:15:36.000',NULL),('8ebe4133-539c-4684-9bfe-8633ad859097',662,'a5bc2d6f-0248-466f-a10b-08f5391fd12f','MAXILLAIRE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2022-11-04 13:31:22.000','2022-11-04 13:33:21.000','2022-11-04 13:31:22.000','2022-11-04 12:33:21.000',NULL),('919caf8c-919a-49cc-bf39-68486f2f5991',662,'a18ca6df-d765-4c6a-be28-13abd1c350af','MORDU_ANTERIEUR','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-17 11:19:52.000',NULL,'2020-04-17 11:19:52.000','2021-03-19 09:22:23.000','2021-03-19 10:22:23.000'),('9716867f-e0a3-478a-a498-1e84ae803044',662,'52372fba-991e-4b09-abce-2195e775fd19','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-11-22 12:45:07.000',NULL,'2021-11-22 12:47:34.000','2021-11-22 11:51:37.000','2021-11-22 12:51:37.000'),('98da8603-40b1-4492-92be-85b42b506cf9',662,'88170486-b19f-4c31-a435-e67fd24917e9','MAXILLAIRE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-12-29 08:33:15.000','2020-12-29 08:34:04.000','2020-12-29 08:33:15.000','2020-12-29 07:34:04.000',NULL),('98e7c216-5bb9-4127-9497-834796980370',662,'31210683-bc06-4b84-83d9-ce60f32308e4','MAXILLAIRE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-11-23 12:01:35.000',NULL,'2021-11-23 12:08:22.000','2021-11-23 11:14:26.000','2021-11-23 12:14:26.000'),('99102b35-9ad0-4017-b70e-fa08e5c36102',662,'b5b4db66-f433-46fb-b794-d632b8fe8e1d','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2022-11-02 12:33:01.000',NULL,'2022-11-02 12:34:10.000','2022-11-02 14:09:59.000','2022-11-02 15:09:59.000'),('993cf4b8-d914-11ed-b558-229278a3c906',662,'a62ebb05-d910-11ed-b558-229278a3c906','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2023-04-12 11:30:01.000',NULL,'2023-04-12 11:31:54.000','2023-06-13 12:02:15.644','2023-06-13 14:02:15.644'),('99a6d55d-de66-49eb-a717-49cb2587fbef',662,'6c6bb813-840d-454a-ab1d-9232434a4500','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-09-27 12:43:59.000',NULL,'2021-09-27 12:45:21.000','2021-09-27 11:57:53.000','2021-09-27 13:57:53.000'),('a26f0d58-ca46-4921-a9e1-9c39b7f89783',662,'b87f1382-55d4-4e52-b63a-6f387df18b16','MAXILLAIRE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-12-29 10:54:22.000',NULL,'2020-12-29 11:13:14.000','2020-12-30 06:12:48.000','2020-12-30 07:12:48.000'),('a6d52fce-2e61-4375-bf6d-a36f9b3eb72f',662,'b29b47d4-35f8-427d-9cd7-a393e48be2cf','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-10-12 12:40:31.000',NULL,'2021-10-12 12:42:39.000','2021-10-12 12:35:19.000','2021-10-12 14:35:19.000'),('a6db2dce-0918-4800-9732-7014e565533f',662,'c9d37315-5f17-421c-8afb-302fa9b0bebe','MANDIBULE','SCAN',1,'IN_PROGRESS',4,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-07 07:05:52.000','2020-04-07 07:05:58.000','2020-04-07 07:05:52.000','2020-12-15 14:15:36.000',NULL),('a6fbb2c0-d901-11ed-9278-00d86184ce0e',662,'9e007066-06fd-4fa1-a49a-f1165de95f83','MAXILLAIRE','SCAN',1,'NONE',2,0,'{\"referenceScanId\":\"76ece440-81ad-42c8-ab91-f99fa29e2a83\"}','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2023-04-12 09:14:23.000','2023-04-12 09:15:08.000','2023-04-12 09:14:23.000','2023-06-13 12:02:15.619','2023-06-13 14:02:15.619'),('a81e23d9-b3eb-48dd-8b7d-7b781fe29163',662,'296c061e-734b-4936-8af7-1f80653eff11','MANDIBULE','SCAN',1,'IN_PROGRESS',3,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-06 11:30:10.000','2020-04-06 11:30:41.000','2020-04-06 11:30:10.000','2020-12-15 14:15:36.000',NULL),('a90158f7-0d39-4b9d-984b-57de06099c65',662,'52372fba-991e-4b09-abce-2195e775fd19','MAXILLAIRE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-11-22 12:11:06.000',NULL,'2021-11-22 12:28:58.000','2021-11-22 11:31:31.000','2021-11-22 12:31:31.000'),('a93c6a8f-0c96-47ae-bc72-75a725946a5a',662,'d402edb5-8449-46a8-862f-a1cd1ee21cf6','MORDU_ANTERIEUR','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-30 20:08:27.000',NULL,'2020-04-30 20:08:27.000','2021-09-27 11:56:31.000','2021-09-27 13:56:31.000'),('aaa22dcc-d910-11ed-b558-229278a3c906',662,'a62ebb05-d910-11ed-b558-229278a3c906','MAXILLAIRE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2023-04-12 11:01:52.000',NULL,'2023-04-12 11:18:46.000','2023-06-13 12:02:15.657','2023-06-13 14:02:15.657'),('ac6f0be1-d915-11ed-b558-229278a3c906',662,'a62ebb05-d910-11ed-b558-229278a3c906','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',2,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2023-04-12 11:37:42.000',NULL,'2023-04-12 11:39:12.000','2023-06-13 12:02:15.669','2023-06-13 14:02:15.669'),('ae5d20f8-815e-44c9-8e8e-a1894419791d',662,'3d8aaee3-2fbd-43cd-8404-58e3f043e115','MANDIBULE','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-08 08:50:36.000','2020-04-08 08:51:36.000','2020-04-08 08:50:36.000','2020-12-15 14:15:36.000',NULL),('ae899af8-7040-48c9-a9b2-6ebc255ac7c9',662,'c6fffa68-cc65-471a-a58e-135ebe4d0772','MAXILLAIRE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-02-16 12:05:06.000',NULL,'2021-02-16 12:19:21.000','2021-02-16 11:40:35.000','2021-02-16 12:40:35.000'),('b002027b-930d-4b96-a687-453aeea5659e',662,'ba7da56a-5a10-4378-a887-8e98aa892a3c','MAXILLAIRE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2022-12-21 12:01:15.000',NULL,'2022-12-21 12:14:32.000','2022-12-21 11:18:01.000','2022-12-21 12:18:01.000'),('b24d4ab4-dba3-4be5-8ba3-7eee381f40ec',662,'5bd97219-8b9e-46f5-ab9b-87ded07aa8a2','MORDU_ANTERIEUR','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2022-11-04 12:32:48.000',NULL,'2022-11-04 12:34:44.000','2022-11-04 11:39:03.000','2022-11-04 12:39:03.000'),('b289ff52-6765-45a7-b1e2-fe7161ba809f',662,'daf632b1-2c49-42c8-8899-0a0b2448bc3a','MAXILLAIRE','SCAN',1,'IN_PROGRESS',2,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-18 09:26:04.000',NULL,'2020-04-18 09:26:04.000','2021-06-08 17:43:35.000','2021-06-08 19:43:35.000'),('b5005e42-2d4d-41b0-91d5-667275f3a9cc',662,'d402edb5-8449-46a8-862f-a1cd1ee21cf6','MORDU_POSTERIEUR_DROIT','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-30 20:00:05.000',NULL,'2020-04-30 20:00:05.000','2021-09-27 11:56:32.000','2021-09-27 13:56:32.000'),('b7931623-9b21-4440-a950-16565249bf9a',662,'d402edb5-8449-46a8-862f-a1cd1ee21cf6','MANDIBULE','SCAN',1,'IN_PROGRESS',2,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-30 19:58:00.000',NULL,'2020-04-30 19:58:00.000','2021-09-27 11:56:31.000','2021-09-27 13:56:31.000'),('bd51414b-f96e-4903-a2e2-44fb3189decd',662,'dce9ce0f-0933-4c98-af84-59e2b6395f8f','MANDIBULE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2022-06-27 20:35:29.000',NULL,'2022-06-27 21:02:22.000','2022-06-27 19:35:48.000','2022-06-27 21:35:48.000'),('be9a4ba5-715b-4547-a31d-66621ec7b17f',662,'16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c','MAXILLAIRE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-06-08 19:57:28.000',NULL,'2021-06-08 20:19:58.000','2021-06-08 18:31:03.000','2021-06-08 20:31:03.000'),('c00beb59-a67d-4566-801a-0081588c2a04',662,'52372fba-991e-4b09-abce-2195e775fd19','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-11-22 12:43:48.000',NULL,'2021-11-22 12:45:00.000','2021-11-22 11:49:45.000','2021-11-22 12:49:45.000'),('c1232582-95fc-48dc-a9ee-826c0cbad106',662,'31210683-bc06-4b84-83d9-ce60f32308e4','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-11-23 12:16:09.000',NULL,'2021-11-23 12:18:02.000','2021-11-23 11:19:11.000','2021-11-23 12:19:11.000'),('c6bba495-6d1a-4da8-bb1f-852a1b1e5924',662,'bef02815-bbf7-4520-882b-2396474f4bb3','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'IN_PROGRESS',2,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-16 07:07:51.000','2023-04-12 06:41:29.000','2020-04-16 07:07:51.000','2023-06-13 12:02:15.486','2023-06-13 14:02:15.486'),('c99bbff9-5630-49d7-9300-4dabfa5e74c8',662,'c6fffa68-cc65-471a-a58e-135ebe4d0772','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-02-16 12:48:12.000',NULL,'2021-02-16 12:53:06.000','2021-02-16 11:57:05.000','2021-02-16 12:57:05.000'),('ca33a9ff-b86a-4e97-8674-1bd7adc92759',662,'bef02815-bbf7-4520-882b-2396474f4bb3','MORDU_ANTERIEUR','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-15 07:43:37.000','2023-04-12 06:41:29.000','2020-04-15 07:43:37.000','2023-06-13 12:02:15.510','2023-06-13 14:02:15.510'),('cb1d5d31-89cd-4ab4-bada-dc6b2235cac5',662,'a18ca6df-d765-4c6a-be28-13abd1c350af','MAXILLAIRE','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-17 11:04:14.000',NULL,'2020-04-17 11:04:14.000','2021-03-19 09:22:22.000','2021-03-19 10:22:22.000'),('ccd3f4f6-f303-4b20-b967-d41121f2e36b',662,'1ec1f707-d702-496a-b2f0-e55b08c06dcb','MORDU_ANTERIEUR','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-02-01 21:19:50.000',NULL,'2021-02-01 21:22:34.000','2021-02-01 20:23:07.000','2021-02-01 21:23:07.000'),('cd4cde89-86e9-4257-92b6-869e9aa8d1f6',662,'e06b73d5-45f7-4906-ba73-560d66ac56af','MORDU_ANTERIEUR','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-16 11:35:44.000',NULL,'2020-04-16 11:35:44.000','2021-03-19 09:22:18.000','2021-03-19 10:22:18.000'),('ce9c2874-6b23-435d-8371-00e8de8a835b',662,'983c39b6-656b-4bf2-bf43-da1625adb861','MANDIBULE','SCAN',1,'NONE',2,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2023-01-11 12:41:48.000','2023-01-11 12:41:52.000','2023-01-11 12:41:48.000','2023-01-11 11:41:52.000',NULL),('d04345c3-df70-4e2a-b197-cc37138e6700',662,'5f895907-3eed-4aa7-995a-f7e1c9661a0a','MORDU_ANTERIEUR','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2022-03-11 11:14:05.000',NULL,'2022-03-11 11:15:50.000','2022-03-11 10:17:45.000','2022-03-11 11:17:45.000'),('d1ad6baa-b3e6-4e10-bd69-140c7abc8f4e',662,'bdf42f40-5a7a-435b-a5e0-eb33efefbc97','MORDU_ANTERIEUR','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-10 11:49:59.000',NULL,'2020-04-10 11:49:59.000','2021-03-19 09:22:18.000','2021-03-19 10:22:18.000'),('d2372948-816f-4d58-a2bf-288bc0e7b539',662,'bef02815-bbf7-4520-882b-2396474f4bb3','MANDIBULE','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-15 07:19:58.000','2023-04-12 06:41:29.000','2020-04-15 07:19:58.000','2023-06-13 12:02:15.554','2023-06-13 14:02:15.554'),('d2c2a39a-6597-4bf0-ad99-7534d9696320',662,'31210683-bc06-4b84-83d9-ce60f32308e4','MAXILLAIRE','SCAN',1,'NONE',2,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-11-23 12:09:38.000','2021-11-23 12:09:44.000','2021-11-23 12:09:38.000','2021-11-23 11:09:44.000',NULL),('d2cd260d-4191-4884-80e3-7ced9fa0f8ce',662,'a5bc2d6f-0248-466f-a10b-08f5391fd12f','MAXILLAIRE','SCAN',1,'NONE',2,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2022-11-04 13:33:29.000',NULL,'2022-11-04 13:46:23.000','2022-12-14 14:06:02.000','2022-12-14 15:06:02.000'),('d36d186b-d0da-4aea-af1a-4613f67b2fa0',662,'a18ca6df-d765-4c6a-be28-13abd1c350af','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-17 11:17:42.000',NULL,'2020-04-17 11:17:42.000','2021-03-19 09:22:22.000','2021-03-19 10:22:22.000'),('d3a42d3d-3d98-457b-bb64-4119091b03f9',662,'bef02815-bbf7-4520-882b-2396474f4bb3','MORDU_POSTERIEUR_DROIT','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-15 07:37:21.000','2023-04-12 06:41:29.000','2020-04-15 07:37:21.000','2023-06-13 12:02:15.579','2023-06-13 14:02:15.579'),('d4c7f3c5-155d-41ef-8665-852e89c5e017',662,'484ae4d8-329f-49b5-8d83-312a8a92ff22','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-02-27 10:43:57.000',NULL,'2021-02-27 10:48:13.000','2021-02-27 09:52:47.000','2021-02-27 10:52:47.000'),('d52d9ce0-7fed-491c-a385-929e22fb07d5',662,'d402edb5-8449-46a8-862f-a1cd1ee21cf6','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-30 20:05:04.000',NULL,'2020-04-30 20:05:04.000','2021-09-27 11:56:29.000','2021-09-27 13:56:29.000'),('d5bd2f05-2874-4b0b-abaa-e6dbef3854b8',662,'296c061e-734b-4936-8af7-1f80653eff11','MANDIBULE','SCAN',1,'IN_PROGRESS',2,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-06 11:29:32.000','2020-04-06 11:29:45.000','2020-04-06 11:29:32.000','2020-12-15 14:15:36.000',NULL),('d675acff-ab7f-4d65-b55c-558379a8b3d0',662,'12115366-8eb9-470b-a097-5d28bb5fdf38','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2022-01-11 12:37:31.000',NULL,'2022-01-11 12:39:02.000','2022-01-11 11:43:38.000','2022-01-11 12:43:38.000'),('d7c4d383-83f9-4275-bbcc-567a47d4a450',662,'6c6bb813-840d-454a-ab1d-9232434a4500','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-09-27 12:45:24.000',NULL,'2021-09-27 12:46:45.000','2021-09-27 12:00:42.000','2021-09-27 14:00:42.000'),('d9e4705b-ee94-487e-8ebd-6ebbbc7fbd38',662,'296c061e-734b-4936-8af7-1f80653eff11','MAXILLAIRE','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-06 11:13:18.000','2020-04-06 11:17:46.000','2020-04-06 11:13:18.000','2020-12-15 14:15:36.000',NULL),('d9ec0349-f28e-41d6-822f-e76c8c001da9',662,'484ae4d8-329f-49b5-8d83-312a8a92ff22','MAXILLAIRE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-02-27 10:07:51.000',NULL,'2021-02-27 10:22:32.000','2021-02-27 09:23:44.000','2021-02-27 10:23:44.000'),('db8db471-34d4-4eab-b8bf-677fc98cde60',662,'296c061e-734b-4936-8af7-1f80653eff11','MAXILLAIRE','SCAN',1,'IN_PROGRESS',2,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-06 11:18:31.000','2020-04-06 11:18:40.000','2020-04-06 11:18:31.000','2020-12-15 14:15:36.000',NULL),('de216c91-485b-4dac-9e7c-b89075739521',662,'bdf42f40-5a7a-435b-a5e0-eb33efefbc97','MANDIBULE','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-10 11:13:09.000',NULL,'2020-04-10 11:13:09.000','2021-03-19 09:22:19.000','2021-03-19 10:22:19.000'),('deeedce8-d914-11ed-b558-229278a3c906',662,'a62ebb05-d910-11ed-b558-229278a3c906','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2023-04-12 11:31:58.000',NULL,'2023-04-12 11:33:16.000','2023-06-13 12:02:15.680','2023-06-13 14:02:15.680'),('e25b4a1f-bcd7-4165-997c-34c38a8a567f',662,'c9d37315-5f17-421c-8afb-302fa9b0bebe','MANDIBULE','SCAN',1,'IN_PROGRESS',5,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-07 07:06:36.000','2020-04-07 07:06:44.000','2020-04-07 07:06:36.000','2020-12-15 14:15:36.000',NULL),('e5fd24c7-49a8-4dbc-9356-3b96970d2515',662,'254f3fc9-4782-4658-bb34-f2ca1c9b6382','MAXILLAIRE','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-05-21 08:00:24.000',NULL,'2020-05-21 08:00:24.000','2021-03-19 09:22:25.000','2021-03-19 10:22:25.000'),('e6c99474-f6f6-447f-bcaa-d4c791811e18',662,'1ec1f707-d702-496a-b2f0-e55b08c06dcb','MANDIBULE','SCAN',1,'NONE',2,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-02-01 21:04:48.000',NULL,'2021-02-01 21:09:33.000','2021-02-01 20:12:37.000','2021-02-01 21:12:37.000'),('e6e5d8c5-2d8c-48d0-9708-e3256202d385',662,'c6fffa68-cc65-471a-a58e-135ebe4d0772','MANDIBULE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-02-16 12:19:51.000',NULL,'2021-02-16 12:48:04.000','2021-02-16 11:53:07.000','2021-02-16 12:53:07.000'),('e7efed59-e33c-4194-94c1-3507350dcfb5',662,'f2e73640-aebd-4bb1-9b02-c0504556ac5a','MAXILLAIRE','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-07-13 19:39:12.000',NULL,'2020-07-13 19:39:12.000','2021-03-19 09:22:30.000','2021-03-19 10:22:30.000'),('e8ff012c-af85-450f-ba33-bd61c15846e9',662,'31210683-bc06-4b84-83d9-ce60f32308e4','MANDIBULE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-11-23 12:09:50.000',NULL,'2021-11-23 12:14:25.000','2021-11-23 11:18:03.000','2021-11-23 12:18:03.000'),('e9134dab-33d6-42e4-8779-ab502b18266c',662,'e06b73d5-45f7-4906-ba73-560d66ac56af','MAXILLAIRE','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-16 11:05:58.000',NULL,'2020-04-16 11:05:58.000','2021-03-19 09:22:16.000','2021-03-19 10:22:16.000'),('e99b1c89-977c-4836-9719-ad6d9a6f6aae',662,'1ec1f707-d702-496a-b2f0-e55b08c06dcb','MANDIBULE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-02-01 20:57:09.000','2021-02-01 21:23:38.000','2021-02-01 21:04:34.000','2021-02-01 20:23:38.000','2021-02-01 21:23:38.000'),('e9aaa539-6e84-47bc-9c50-2c8797de82a4',662,'b5b4db66-f433-46fb-b794-d632b8fe8e1d','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2022-11-02 12:34:17.000',NULL,'2022-11-02 12:34:58.000','2022-11-02 14:09:57.000','2022-11-02 15:09:57.000'),('eca23073-2ad8-4f4f-95cb-36be4ed4b064',662,'c9d37315-5f17-421c-8afb-302fa9b0bebe','MANDIBULE','SCAN',1,'IN_PROGRESS',6,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-07 07:06:47.000','2020-04-07 07:06:52.000','2020-04-07 07:06:47.000','2020-12-15 14:15:36.000',NULL),('ecd2beec-0c29-40e2-ab95-64009c33fa40',662,'b87f1382-55d4-4e52-b63a-6f387df18b16','MORDU_POSTERIEUR_DROIT','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-12-29 11:28:43.000',NULL,'2020-12-29 11:30:30.000','2021-06-08 17:43:35.000','2021-06-08 19:43:35.000'),('ed495283-b756-4052-ba8b-5fe9f9b1f8be',662,'b5b4db66-f433-46fb-b794-d632b8fe8e1d','MAXILLAIRE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2022-11-02 12:11:51.000',NULL,'2022-11-02 12:30:09.000','2022-11-02 17:43:21.000','2022-11-02 18:43:21.000'),('eece5ace-2081-4f39-859f-68495bd82499',662,'bb711dc3-11c1-44a8-96df-a5fb875eade5','MAXILLAIRE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-12-29 08:43:27.000',NULL,'2020-12-29 08:48:31.000','2021-06-08 17:45:17.000','2021-06-08 19:45:17.000'),('ef79558a-21cf-4117-a0b7-ba0adf40f7dc',662,'6c6bb813-840d-454a-ab1d-9232434a4500','MORDU_ANTERIEUR','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-09-27 12:46:55.000',NULL,'2021-09-27 12:49:23.000','2021-09-27 12:00:42.000','2021-09-27 14:00:42.000'),('f0b63e95-26e8-4213-a935-ca2c37ab36ba',662,'12115366-8eb9-470b-a097-5d28bb5fdf38','MANDIBULE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2022-01-11 12:23:26.000',NULL,'2022-01-11 12:35:42.000','2022-01-11 11:39:03.000','2022-01-11 12:39:03.000'),('f2b8c151-b863-4411-b17a-b987ca58ee6f',662,'4af4bd2d-76e3-4905-99fd-191c4cc669fa','MAXILLAIRE','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-09 10:56:43.000','2023-04-12 06:41:30.000','2020-04-09 10:56:43.000','2023-06-13 12:02:15.607','2023-06-13 14:02:15.607'),('f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97',662,'52372fba-991e-4b09-abce-2195e775fd19','MANDIBULE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-11-22 12:29:17.000',NULL,'2021-11-22 12:41:06.000','2021-11-22 11:51:37.000','2021-11-22 12:51:37.000'),('f66e82ce-4142-4af6-af28-6234363afd4c',662,'c9d37315-5f17-421c-8afb-302fa9b0bebe','MANDIBULE','SCAN',1,'IN_PROGRESS',2,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-07 07:05:08.000','2020-04-07 07:05:14.000','2020-04-07 07:05:08.000','2020-12-15 14:15:36.000',NULL),('f766f1dd-53ad-45fc-8f7b-a61d47dfe500',662,'484ae4d8-329f-49b5-8d83-312a8a92ff22','MORDU_POSTERIEUR_GAUCHE','SCAN',1,'NONE',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2021-02-27 10:48:25.000',NULL,'2021-02-27 10:52:47.000','2021-02-27 09:55:31.000','2021-02-27 10:55:31.000'),('fbfa4372-1faf-4a14-9f4e-70b7b375da7d',662,'daf632b1-2c49-42c8-8899-0a0b2448bc3a','MAXILLAIRE','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-04-18 09:19:43.000','2021-03-19 10:22:13.000','2020-04-18 09:19:43.000','2021-03-19 09:22:13.000','2021-03-19 10:22:13.000'),('ffc31e24-32ca-4c9e-a392-25252e853fcf',662,'53a17fdc-5de8-45aa-a9cb-ebea4886f6ff','MAXILLAIRE','SCAN',1,'IN_PROGRESS',1,0,'','045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2','2020-07-08 19:38:20.000','2020-07-08 19:43:23.000','2020-07-08 19:38:20.000','2020-12-15 14:15:36.000',NULL);
/*!40000 ALTER TABLE `Scan` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ScanFile`
--

DROP TABLE IF EXISTS `ScanFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ScanFile` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `scanId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('MODEL','SNAPSHOT','SCREENSHOT','LIFI','LIFIMETA') NOT NULL,
  PRIMARY KEY (`scanId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `ScanFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `ScanFile_ibfk_2` FOREIGN KEY (`scanId`) REFERENCES `Scan` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ScanFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ScanFile`
--

LOCK TABLES `ScanFile` WRITE;
/*!40000 ALTER TABLE `ScanFile` DISABLE KEYS */;
INSERT INTO `ScanFile` VALUES (662,'00f07cdc-1834-4ae1-a9fa-47699828c094','0e855e55-dc7f-4eaf-91bd-933232cae95e','MODEL'),(662,'00f07cdc-1834-4ae1-a9fa-47699828c094','791a0795-78ad-4b6e-a31b-bdc257f06704','SNAPSHOT'),(662,'019e5bd1-9330-4e70-8035-2fda343b0231','84c96eac-549e-4c1d-a701-896474d66a31','MODEL'),(662,'019e5bd1-9330-4e70-8035-2fda343b0231','b328d68a-733b-46ed-9a1a-20aefc9f9b17','MODEL'),(662,'019e5bd1-9330-4e70-8035-2fda343b0231','b61e5533-433b-40e2-a91d-c157692b02c0','SNAPSHOT'),(662,'019e5bd1-9330-4e70-8035-2fda343b0231','d5df3022-2abe-4d54-a53d-63cb7ad80b02','SNAPSHOT'),(662,'0a606279-3c91-4220-b876-e620d1bf52f6','6bd04ecb-23d6-4510-a353-c2b68dba5457','SNAPSHOT'),(662,'0a606279-3c91-4220-b876-e620d1bf52f6','f867279f-0907-4a6e-84d2-9c1b54bb4caf','MODEL'),(662,'0b6ec729-5c4e-4869-9d67-6377923ed207','933a6e93-9da3-4626-98e1-48aa28a06daa','MODEL'),(662,'0b6ec729-5c4e-4869-9d67-6377923ed207','fd2b02c7-bcd5-4774-9809-1da5d2dd2ad0','SNAPSHOT'),(662,'0c8af1cb-8054-4a35-9cfe-449c19dbe59b','245640ab-9c9d-4467-bd40-a48ae0ff49d0','SNAPSHOT'),(662,'0c8af1cb-8054-4a35-9cfe-449c19dbe59b','a54c4788-74a1-482e-bbc8-b46aeb6ca424','MODEL'),(662,'0d792709-57f3-49e1-963c-d2dc35a59d12','4e355e83-f72e-471f-a217-6dc5ae2fd8aa','MODEL'),(662,'0d792709-57f3-49e1-963c-d2dc35a59d12','f16b178b-9a0f-4a7d-b4da-8d23ef7b4db3','SNAPSHOT'),(662,'0e5656e0-946b-41b2-935b-ea820746e5a9','520242d1-a563-40d8-b43b-1c26fd0f28ff','SNAPSHOT'),(662,'0e5656e0-946b-41b2-935b-ea820746e5a9','ab2de538-1cbb-481f-a82e-899f47da34b7','MODEL'),(662,'0e5656e0-946b-41b2-935b-ea820746e5a9','bad6504a-4f54-4dc9-83e3-02475160f717','SNAPSHOT'),(662,'0e5656e0-946b-41b2-935b-ea820746e5a9','dab48b34-de4a-4877-be2f-a21e13908dff','MODEL'),(662,'0f18aace-5cf2-4d46-b56f-f8dc123e1f91','a3d56e52-a954-4894-b840-be0425c42658','MODEL'),(662,'0f18aace-5cf2-4d46-b56f-f8dc123e1f91','e31677ad-6acd-445e-8577-f3c741a13dc2','SNAPSHOT'),(662,'107f2922-62ee-42d9-8e35-69d71587db0b','a06c28ec-9f81-44b6-b11e-a5e06d983e4a','SNAPSHOT'),(662,'107f2922-62ee-42d9-8e35-69d71587db0b','ee74d731-2b8a-426e-a645-bad9ae685308','MODEL'),(662,'10c9626c-901e-4a0e-8f05-62042bf69c04','43236ddb-b178-4cc2-bc90-90f78d3f3694','SNAPSHOT'),(662,'10c9626c-901e-4a0e-8f05-62042bf69c04','79cf9af7-3005-4b44-854c-ba038cba5f4b','MODEL'),(662,'12f64013-f8aa-44bb-91e8-38c23737152b','1920fbbf-3535-420d-92a8-85d1ffb87094','MODEL'),(662,'12f64013-f8aa-44bb-91e8-38c23737152b','536f2d6d-667c-4e47-bf9c-c77be612a54a','SNAPSHOT'),(662,'13e9c4af-5ddc-4a12-ae1b-2b802c735c3f','664cb06d-0960-4f9e-9c04-b9080d0ba7c2','SNAPSHOT'),(662,'13e9c4af-5ddc-4a12-ae1b-2b802c735c3f','6e406955-1a72-4b3a-8063-b460b758c328','MODEL'),(662,'16cf8664-2af0-446a-ac6d-ef0e40edb71d','8efdb9b3-fe9f-4a5f-9abb-7f53985624a7','SNAPSHOT'),(662,'16cf8664-2af0-446a-ac6d-ef0e40edb71d','9c755cdf-e1f1-49e0-9dcf-708a856d1b81','MODEL'),(662,'18365744-4019-43e1-933f-9fa52db1a30d','3f9ce1c8-3470-43c5-8e52-0294b7082120','MODEL'),(662,'18365744-4019-43e1-933f-9fa52db1a30d','d1e9dead-d755-4b41-9105-4b6355694989','SNAPSHOT'),(662,'19627cd9-e6e6-4c6f-9a62-46d708ca49bc','1e84d5d4-6768-4dde-a7cf-ca40a6d4261e','MODEL'),(662,'19627cd9-e6e6-4c6f-9a62-46d708ca49bc','68061e27-8872-4682-9ba9-a57f6a95d8d3','SNAPSHOT'),(662,'1c6adc05-0655-4ad6-bcc9-27b0ef578ded','06e08af9-0736-40b6-93e5-bdffccb8ea44','SNAPSHOT'),(662,'1c6adc05-0655-4ad6-bcc9-27b0ef578ded','222a29ad-e959-403d-b53b-f17d1e53bc93','MODEL'),(662,'1c6adc05-0655-4ad6-bcc9-27b0ef578ded','78fdec7c-2a35-41bb-8492-82f1c776d061','SNAPSHOT'),(662,'1c6adc05-0655-4ad6-bcc9-27b0ef578ded','7ee48377-0cc2-4cf4-8d72-837e258ca29f','MODEL'),(662,'1c6adc05-0655-4ad6-bcc9-27b0ef578ded','a1bc9da2-af83-43c3-8210-759800158585','MODEL'),(662,'1c6adc05-0655-4ad6-bcc9-27b0ef578ded','a4f0f4fa-9346-4a75-a1dd-e95c83dc5e6b','MODEL'),(662,'1c6adc05-0655-4ad6-bcc9-27b0ef578ded','c44f8f8f-6ba9-4ae3-85ba-cffa8f6b3e13','SNAPSHOT'),(662,'1c6adc05-0655-4ad6-bcc9-27b0ef578ded','d40f4bba-69b0-4cc6-b541-e69c16b2b3d5','SNAPSHOT'),(662,'1c6adc05-0655-4ad6-bcc9-27b0ef578ded','e969b9cf-a941-4745-a2cb-e1ed64d3332e','SNAPSHOT'),(662,'1c6adc05-0655-4ad6-bcc9-27b0ef578ded','f7cc8435-546b-4daa-9414-7a8a0728e9e6','MODEL'),(662,'1e8824f7-3c76-4fe0-bd8c-f865f725dab2','963a8acf-cdb2-41d5-b187-9a7c885ac2a0','MODEL'),(662,'1e8824f7-3c76-4fe0-bd8c-f865f725dab2','ebf4cbaa-94a5-42c6-aad4-4f61d8ad16b8','SNAPSHOT'),(662,'1ff82da8-d913-11ed-b558-229278a3c906','102c6dfe-d914-11ed-b558-229278a3c906','MODEL'),(662,'1ff82da8-d913-11ed-b558-229278a3c906','102db5a2-d914-11ed-b558-229278a3c906','SNAPSHOT'),(662,'1ff82da8-d913-11ed-b558-229278a3c906','8c1eb1f1-d914-11ed-b558-229278a3c906','MODEL'),(662,'1ff82da8-d913-11ed-b558-229278a3c906','8c1ec753-d914-11ed-b558-229278a3c906','SNAPSHOT'),(662,'209f3c55-7380-4efa-8e6c-dfe8c99792a6','06da4522-e34d-40fd-b96f-ca51c40618cc','MODEL'),(662,'209f3c55-7380-4efa-8e6c-dfe8c99792a6','097b9793-f270-498e-9cfe-cf6bc2963744','MODEL'),(662,'209f3c55-7380-4efa-8e6c-dfe8c99792a6','0cac8ddd-0fbb-4d05-98b1-9dbfe53318c8','SNAPSHOT'),(662,'209f3c55-7380-4efa-8e6c-dfe8c99792a6','252b180c-565f-4f14-af48-a16cebbead9e','SNAPSHOT'),(662,'209f3c55-7380-4efa-8e6c-dfe8c99792a6','307db8a0-4cc4-49dc-9aca-9a7072712805','SNAPSHOT'),(662,'209f3c55-7380-4efa-8e6c-dfe8c99792a6','6771d7ca-3bca-47bd-a554-166ba1db633b','MODEL'),(662,'209f3c55-7380-4efa-8e6c-dfe8c99792a6','6fe553ac-625b-4942-ad10-01bbe5250717','SNAPSHOT'),(662,'209f3c55-7380-4efa-8e6c-dfe8c99792a6','8426a670-f967-440b-bcde-e3796c4a5da6','SNAPSHOT'),(662,'209f3c55-7380-4efa-8e6c-dfe8c99792a6','a8de488b-e4b1-4234-b30c-cb7d68338c86','MODEL'),(662,'209f3c55-7380-4efa-8e6c-dfe8c99792a6','d2a7b476-1ed0-4870-8219-9863d50e401c','MODEL'),(662,'209f3c55-7380-4efa-8e6c-dfe8c99792a6','d2cb8acf-0a31-40f9-932c-a089f44c1a4b','MODEL'),(662,'209f3c55-7380-4efa-8e6c-dfe8c99792a6','dd45b218-e893-4bfa-a2dc-cfdb060bbcbc','SNAPSHOT'),(662,'254d7cff-f2aa-4d41-8b1c-7b0bdd6386ff','2cff0ba7-eee7-4c7f-99af-34c690eb3868','MODEL'),(662,'254d7cff-f2aa-4d41-8b1c-7b0bdd6386ff','e22ce6e5-78b3-470f-8eac-fc2668ff13bc','SNAPSHOT'),(662,'26a765d3-8b92-4861-984a-bd9c8040209b','185c4f85-4987-4fa1-9ca4-3c6b9e0373b7','MODEL'),(662,'26a765d3-8b92-4861-984a-bd9c8040209b','60418949-4776-4ecc-898e-ee8453d29ba9','SNAPSHOT'),(662,'26a765d3-8b92-4861-984a-bd9c8040209b','7f09064b-ad1e-4cc1-9d0b-40bde9e22dff','SNAPSHOT'),(662,'26a765d3-8b92-4861-984a-bd9c8040209b','be04859c-f9ff-4a11-96c0-99dd77c8c98f','MODEL'),(662,'2a466f6b-3960-4b1b-bb27-def76229cccc','0cbb67d8-7a5d-43de-a85a-8ad3ddf2e2cb','SNAPSHOT'),(662,'2a466f6b-3960-4b1b-bb27-def76229cccc','176a7141-81b2-436e-bbb3-00ec6028c71b','MODEL'),(662,'2a466f6b-3960-4b1b-bb27-def76229cccc','6ea3e979-830a-4dd4-81e2-3d30db702b9c','MODEL'),(662,'2a466f6b-3960-4b1b-bb27-def76229cccc','c9051630-ef52-45e0-bf72-eef2676192c8','SNAPSHOT'),(662,'2bf301a3-b61c-4ddd-b6a2-4924c804d5f8','0890ccd8-08ca-4b8f-8bea-3e38e4c1e0a0','MODEL'),(662,'2bf301a3-b61c-4ddd-b6a2-4924c804d5f8','cf189c0a-4444-4e39-9766-e4e47582f98c','SNAPSHOT'),(662,'2d566d37-f38f-4b79-ac8f-48009ae22310','4acfe34d-f60d-43a0-bed4-9a53302e03f0','SNAPSHOT'),(662,'2d566d37-f38f-4b79-ac8f-48009ae22310','9429af5d-f1d9-425d-ba09-d7d1907096ac','MODEL'),(662,'34f5d93d-6a1f-4f94-ab20-4105c2cce30a','29be6b15-58e7-42cd-824d-34b15f20be76','MODEL'),(662,'34f5d93d-6a1f-4f94-ab20-4105c2cce30a','c0a56411-85d4-412b-84cc-45a71dee710a','SNAPSHOT'),(662,'375f8fb7-d198-4281-9948-bba81b98e824','1f02ce0a-9100-460e-987f-c2b91eda5ac1','SNAPSHOT'),(662,'375f8fb7-d198-4281-9948-bba81b98e824','bb2755e4-36de-4604-9ee9-d2711661ea1d','MODEL'),(662,'37ff1278-3dd1-470a-8159-e763f6626f5d','687b8177-c7c5-42f4-8937-a0b8e331f674','SNAPSHOT'),(662,'37ff1278-3dd1-470a-8159-e763f6626f5d','83dce64b-81ec-4022-b7e5-8a738bbab39f','MODEL'),(662,'37ff1278-3dd1-470a-8159-e763f6626f5d','bfbd4222-08f2-4237-9b3e-e482e6111a20','MODEL'),(662,'37ff1278-3dd1-470a-8159-e763f6626f5d','f297816f-db2c-4167-bd60-28d3e93bb7c9','SNAPSHOT'),(662,'3a315f7b-8cf2-4d0c-bf92-fecb623fe530','110bfb15-3589-48ab-bb80-e339d042b64d','MODEL'),(662,'3a315f7b-8cf2-4d0c-bf92-fecb623fe530','4a35756e-57f1-4f26-a7da-64af3396fbad','SNAPSHOT'),(662,'3a315f7b-8cf2-4d0c-bf92-fecb623fe530','6bc59c6e-9179-4d61-91a6-7cfb0da22a7a','SNAPSHOT'),(662,'3a315f7b-8cf2-4d0c-bf92-fecb623fe530','bafe042a-2298-470c-8d08-071e0f4e388e','MODEL'),(662,'3d3ae697-dc08-4ce2-8b32-4f79891607c2','3ff0f96a-5e61-4469-a401-383ca0d260ac','SNAPSHOT'),(662,'3d3ae697-dc08-4ce2-8b32-4f79891607c2','f880f49e-bb57-430d-8212-dcb8e015569f','MODEL'),(662,'3e1d8e57-feae-45d6-80f0-9d0be041ff7a','41f1c7ba-1d8c-47b9-8ed9-11f004bb7681','MODEL'),(662,'3e1d8e57-feae-45d6-80f0-9d0be041ff7a','dd19221a-2e2b-4f03-9062-62bb291352d2','SNAPSHOT'),(662,'41b8d05c-738b-4161-9f86-27222b61ad66','8f73cc76-d204-47ee-bcfc-5610371e2032','SNAPSHOT'),(662,'41b8d05c-738b-4161-9f86-27222b61ad66','a196ba15-5ebd-46d8-b6fa-0325918797ac','MODEL'),(662,'42b09cf6-e30d-4d35-a17d-d8e8b4564638','3b5b5fb9-a2cd-4386-9406-17bd2384e1ae','MODEL'),(662,'42b09cf6-e30d-4d35-a17d-d8e8b4564638','4f638684-087b-42a0-916a-a8adc0c1eeea','MODEL'),(662,'42b09cf6-e30d-4d35-a17d-d8e8b4564638','a60e34f6-4db6-4236-9d5a-1741dd2ed622','SNAPSHOT'),(662,'42b09cf6-e30d-4d35-a17d-d8e8b4564638','f1ef3944-d73f-4a49-8e28-c4619cb61202','SNAPSHOT'),(662,'437ef945-eb42-4841-9b20-34804bd5cfd6','0f7ff11f-44bc-45a5-bfc7-a7ac0da258f5','MODEL'),(662,'437ef945-eb42-4841-9b20-34804bd5cfd6','1f92b4ea-73e7-423b-8d75-46b280f139d9','SNAPSHOT'),(662,'437ef945-eb42-4841-9b20-34804bd5cfd6','569cf3b9-ec78-4231-a836-d4fe2c1273c0','SNAPSHOT'),(662,'437ef945-eb42-4841-9b20-34804bd5cfd6','ff42f199-4210-43da-bfae-3dc172610fff','MODEL'),(662,'44b8a221-3707-430b-bc84-cacca7bf7d8a','1fe4acd9-cda1-4289-bd11-70fec38115e5','MODEL'),(662,'44b8a221-3707-430b-bc84-cacca7bf7d8a','92288f55-8447-4e52-a1c2-2de9d12cad77','SNAPSHOT'),(662,'44ccf5f6-834d-4090-88dc-399b19fed47e','affc6c02-1fc4-49c7-9730-6f5e1f2e9f8e','SNAPSHOT'),(662,'44ccf5f6-834d-4090-88dc-399b19fed47e','b75b602f-a893-4dd9-8bbf-6b4b00421c4a','MODEL'),(662,'453abb20-3827-4f8b-b57f-c656c72ebf11','6ad36229-9d4a-4773-85c5-492f1965bc80','SNAPSHOT'),(662,'453abb20-3827-4f8b-b57f-c656c72ebf11','7b9836aa-2cf6-485a-b0d3-39d73de4bc8b','SNAPSHOT'),(662,'453abb20-3827-4f8b-b57f-c656c72ebf11','dd29f41a-cbb1-45d7-8979-1d16d4db487c','MODEL'),(662,'453abb20-3827-4f8b-b57f-c656c72ebf11','ede17ed3-0dee-42d5-86a9-2728608363fe','MODEL'),(662,'45b21304-1129-40a2-b60e-d72a2bf96e72','4ec9ee9c-a56b-483d-ba09-9dc992d7e79c','SNAPSHOT'),(662,'45b21304-1129-40a2-b60e-d72a2bf96e72','7d1b5372-e89a-471e-8230-71dba1f47677','SNAPSHOT'),(662,'45b21304-1129-40a2-b60e-d72a2bf96e72','a41e073f-d40b-4f4f-924e-2afd61ac4f8c','MODEL'),(662,'45b21304-1129-40a2-b60e-d72a2bf96e72','fe6fbf6c-0ee6-4b36-8e65-ca271a0819f0','MODEL'),(662,'470d4798-40ea-4ce5-a574-22fcf013d82d','2ec9cc68-72e4-4237-9254-2374d936f630','MODEL'),(662,'470d4798-40ea-4ce5-a574-22fcf013d82d','8369f19c-559c-4a43-8a44-d476973e5f8f','SNAPSHOT'),(662,'4a2eec76-a5f3-44f0-b389-4734998fa2d3','2b6d557d-ea43-42a5-bd7d-859d5a90f1a6','MODEL'),(662,'4a2eec76-a5f3-44f0-b389-4734998fa2d3','3d775751-11c5-4dcb-bf34-a85c2baf0191','MODEL'),(662,'4a2eec76-a5f3-44f0-b389-4734998fa2d3','4b136eb3-b01e-4166-a154-4539e20f9fea','MODEL'),(662,'4a2eec76-a5f3-44f0-b389-4734998fa2d3','a3243928-a351-4ca9-b9b0-be959eab0b25','SNAPSHOT'),(662,'4a2eec76-a5f3-44f0-b389-4734998fa2d3','d7875c8c-cb63-4940-9761-68ef1c238665','SNAPSHOT'),(662,'4a2eec76-a5f3-44f0-b389-4734998fa2d3','e8f06fb1-375a-41c0-9a27-d0ee2593900c','SNAPSHOT'),(662,'4caeed6a-b015-4556-8794-2c3a00fea341','78194fe5-5ac7-4c4a-ba44-b374602235d5','SNAPSHOT'),(662,'4caeed6a-b015-4556-8794-2c3a00fea341','b181e5ae-02f0-4845-a5ba-d30139f8d8a1','MODEL'),(662,'50e1896b-8565-4257-9a61-2a685fff8165','330dc645-80dc-4734-bc6a-ba2a87b5f495','SNAPSHOT'),(662,'50e1896b-8565-4257-9a61-2a685fff8165','49635be4-dbea-497c-82e1-206399739c31','MODEL'),(662,'50e1896b-8565-4257-9a61-2a685fff8165','ac2e051b-dd4c-4fc1-be89-d406c5ab9a69','MODEL'),(662,'50e1896b-8565-4257-9a61-2a685fff8165','d455a946-5407-4abb-8fdb-711fb0adfe7c','SNAPSHOT'),(662,'527c942e-3aa0-4028-b02a-8b3f137657be','83eddd4d-fe65-43b9-a14f-3293e715be11','SNAPSHOT'),(662,'527c942e-3aa0-4028-b02a-8b3f137657be','c444e909-d341-4283-88a4-d2ec58f55e8a','MODEL'),(662,'534cca35-8182-4f61-aa57-03bad8172eac','b9175f0f-b250-4ae3-b56c-51f5a10c10db','SNAPSHOT'),(662,'534cca35-8182-4f61-aa57-03bad8172eac','ba881d4e-efc8-45fe-90c8-248f552f9196','MODEL'),(662,'534cca35-8182-4f61-aa57-03bad8172eac','e695a41c-b645-425c-85e6-65b449ddbb04','MODEL'),(662,'534cca35-8182-4f61-aa57-03bad8172eac','ffd40c66-bdac-4ae5-8460-6b5fe127d9e0','SNAPSHOT'),(662,'55058b25-acc2-43c3-b9d2-b8bb64bfcbb9','3dc10c2a-bbf8-496d-bcfb-198ad6609e7b','MODEL'),(662,'55058b25-acc2-43c3-b9d2-b8bb64bfcbb9','9186d766-694f-4445-926a-80ace9fd1660','SNAPSHOT'),(662,'57cfef6d-c27e-45fa-81d7-e63b4f8c4429','621b6179-82c4-4d83-a1ec-4b5eb2545a81','MODEL'),(662,'57cfef6d-c27e-45fa-81d7-e63b4f8c4429','6f2ff317-b1e7-4c11-b0dd-c5b359491513','SNAPSHOT'),(662,'57e7671e-1671-4ee9-96a0-650a56963aa8','048d66fa-42fe-4d07-8e9c-1a8a30ce1fb4','MODEL'),(662,'57e7671e-1671-4ee9-96a0-650a56963aa8','6026647a-901e-4a90-bd11-8ec6d1883285','SNAPSHOT'),(662,'5a4f6b62-6381-4a1e-bbef-61746f2722d3','6fa55f91-2e1f-436b-b276-b2726e9125b4','MODEL'),(662,'5a4f6b62-6381-4a1e-bbef-61746f2722d3','f06e433d-c712-4081-adba-9051f0c10c4e','SNAPSHOT'),(662,'5a59f382-4b59-4867-8640-021d20bdcd59','7cace217-66b4-4147-97f5-c8c1a7dfe1cd','SNAPSHOT'),(662,'5a59f382-4b59-4867-8640-021d20bdcd59','dc97d683-1aa5-4aba-bf5c-a43b36478d90','MODEL'),(662,'5a5e6904-4736-4443-bbd0-be73066af8c3','7df036ea-5778-484f-b08f-26823b06d4e2','SNAPSHOT'),(662,'5a5e6904-4736-4443-bbd0-be73066af8c3','f0df34cd-4382-481e-9fcb-ed767063a228','MODEL'),(662,'643b3b5a-e991-4dbf-95c8-2fd609f83a8b','156e5ba4-51dd-4631-932f-c91d8a7edef9','SNAPSHOT'),(662,'643b3b5a-e991-4dbf-95c8-2fd609f83a8b','26c13801-12d8-430d-ae6c-429cbe801e77','SNAPSHOT'),(662,'643b3b5a-e991-4dbf-95c8-2fd609f83a8b','3d7bd9ef-9d44-4365-af74-4d2a31f8f2fb','SNAPSHOT'),(662,'643b3b5a-e991-4dbf-95c8-2fd609f83a8b','4df1d6c0-6d77-4547-ae20-f797167f57b2','MODEL'),(662,'643b3b5a-e991-4dbf-95c8-2fd609f83a8b','59ebc4a1-1711-4a3b-ac06-f55565453d6a','SNAPSHOT'),(662,'643b3b5a-e991-4dbf-95c8-2fd609f83a8b','5ba33ea9-efd2-4c3f-b859-372b495c2e78','MODEL'),(662,'643b3b5a-e991-4dbf-95c8-2fd609f83a8b','60b6e24d-83ab-4528-953e-a72aae732f49','SNAPSHOT'),(662,'643b3b5a-e991-4dbf-95c8-2fd609f83a8b','6eeaf574-0aa0-4bc8-95c8-5d198f212e39','MODEL'),(662,'643b3b5a-e991-4dbf-95c8-2fd609f83a8b','79d52980-5104-4ca5-9286-27c93d8a0261','MODEL'),(662,'643b3b5a-e991-4dbf-95c8-2fd609f83a8b','ca78a19d-bcad-4ceb-b844-f2badf2ebc09','MODEL'),(662,'643b3b5a-e991-4dbf-95c8-2fd609f83a8b','cb85cf03-baff-4dcf-bc65-cf1a9c7b9e84','SNAPSHOT'),(662,'643b3b5a-e991-4dbf-95c8-2fd609f83a8b','e2e61121-2865-452b-a685-13a4ecd0974b','SNAPSHOT'),(662,'643b3b5a-e991-4dbf-95c8-2fd609f83a8b','e720e2f6-8dce-43f4-a5d6-bf8c09037947','MODEL'),(662,'643b3b5a-e991-4dbf-95c8-2fd609f83a8b','f2e3b9c2-4d8e-490a-8051-fed4332bc376','MODEL'),(662,'6445b6e3-0c4a-44d3-84e8-7f315911b8ee','0518a0de-5961-461c-b3cf-2ee702ed7107','MODEL'),(662,'6445b6e3-0c4a-44d3-84e8-7f315911b8ee','8fd1dd53-2969-4c23-9998-f92a590629ae','SNAPSHOT'),(662,'65315958-b964-4f7e-a111-9c7695d8092b','cce7b291-ae52-44af-bd7e-fe49b16c09c7','MODEL'),(662,'65315958-b964-4f7e-a111-9c7695d8092b','ff1d5097-67d0-49a8-b7ee-d5cbee5bd5df','SNAPSHOT'),(662,'6ce1c2d0-1849-4a2a-bfd9-05247b74c2d7','0abfe6c8-8321-4681-9ffd-944418ed370c','SNAPSHOT'),(662,'6ce1c2d0-1849-4a2a-bfd9-05247b74c2d7','a5903ca6-45db-41cc-a262-19592ff5f2e4','MODEL'),(662,'6ce24fb2-7744-476b-a643-7e304d3ac013','9210c2bb-cc5b-4ccf-a432-8adf915d5673','SNAPSHOT'),(662,'6ce24fb2-7744-476b-a643-7e304d3ac013','ce7041b4-86ce-4167-b150-b49d4f0008a6','MODEL'),(662,'6fafe104-bdc1-41a6-9977-b1bbb351a329','31421697-5459-439e-919b-169d051646f5','MODEL'),(662,'6fafe104-bdc1-41a6-9977-b1bbb351a329','386b43f6-0c1a-484d-9092-8962d1eb3835','SNAPSHOT'),(662,'6fafe104-bdc1-41a6-9977-b1bbb351a329','3e41d066-f22f-4b6c-bc5b-438bc17b2d84','MODEL'),(662,'6fafe104-bdc1-41a6-9977-b1bbb351a329','9cd5b1c8-ef15-449d-97a1-bdf6947abe78','SNAPSHOT'),(662,'76ece440-81ad-42c8-ab91-f99fa29e2a83','3b6f0d95-5183-43aa-8816-815a96e7e143','MODEL'),(662,'76ece440-81ad-42c8-ab91-f99fa29e2a83','4782af06-5171-4020-833c-143c6a151469','SNAPSHOT'),(662,'76ece440-81ad-42c8-ab91-f99fa29e2a83','a952743c-a21c-4952-8c29-3ac0e894560a','SNAPSHOT'),(662,'76ece440-81ad-42c8-ab91-f99fa29e2a83','ae0e9352-37bf-4a60-8c33-459deae4ddb5','MODEL'),(662,'76f39717-6f88-4e19-800c-f827a697a4d6','59f86cb7-d0b5-456d-bb86-a5a83efb559d','SNAPSHOT'),(662,'76f39717-6f88-4e19-800c-f827a697a4d6','96c2eb83-88a2-4de9-b439-f00924861267','SNAPSHOT'),(662,'76f39717-6f88-4e19-800c-f827a697a4d6','a7593039-4dcb-45a6-891b-98f0c4c5c835','MODEL'),(662,'76f39717-6f88-4e19-800c-f827a697a4d6','af631cfa-13bc-4662-b2af-845b9dc8652b','MODEL'),(662,'778a761c-339e-4143-a807-735b174d9714','3a8a47b1-96a0-4e8f-a7fa-d5c2f74f3677','SNAPSHOT'),(662,'778a761c-339e-4143-a807-735b174d9714','48632fc1-3269-4a7f-bdaa-980e30af0358','MODEL'),(662,'778a761c-339e-4143-a807-735b174d9714','7935777d-a278-4364-9439-322233eba142','SNAPSHOT'),(662,'778a761c-339e-4143-a807-735b174d9714','e54a3aaa-1b5e-4e05-b9aa-30359687e6de','MODEL'),(662,'793e84ce-b088-458d-82f5-33fab1f5e7de','07615b33-5390-4fe1-9fbb-9ec7cbd64d40','MODEL'),(662,'793e84ce-b088-458d-82f5-33fab1f5e7de','81bbb529-1a14-4e29-b842-b84cbac8d014','SNAPSHOT'),(662,'793e84ce-b088-458d-82f5-33fab1f5e7de','a3ae3378-e8e9-495e-9dc6-8a3be2a9a968','SNAPSHOT'),(662,'793e84ce-b088-458d-82f5-33fab1f5e7de','b03f52b8-54fa-4f11-9899-22d57d5b6ebc','MODEL'),(662,'79548cb6-a61f-44cb-b6f7-cab7698f7465','214a04d1-1997-4654-8226-87b79966583e','SNAPSHOT'),(662,'79548cb6-a61f-44cb-b6f7-cab7698f7465','520d0710-d923-46c1-a1dd-f05370a3a5ea','MODEL'),(662,'79548cb6-a61f-44cb-b6f7-cab7698f7465','5c991e5c-3b6f-409c-839c-1ed086c26caf','SNAPSHOT'),(662,'79548cb6-a61f-44cb-b6f7-cab7698f7465','98c10ee7-5736-4c52-8f1e-248cda79d235','MODEL'),(662,'7a39120e-2f79-4c3e-af4d-af72e8ca8062','5b5466a1-e0a0-4b4b-8dd8-e9f815b047c0','SNAPSHOT'),(662,'7a39120e-2f79-4c3e-af4d-af72e8ca8062','818647ce-e09a-4e46-8ad9-2029a89b0d0f','MODEL'),(662,'7a39120e-2f79-4c3e-af4d-af72e8ca8062','9fa4fa76-ae1b-496c-bc61-9c8652c7f3d6','SNAPSHOT'),(662,'7a39120e-2f79-4c3e-af4d-af72e8ca8062','c14c7ae3-1390-4203-93ce-6ba836086c35','MODEL'),(662,'7a480eb2-a7b4-4ec5-b628-ef6c2043dd7a','648cf438-b183-47f5-a0f7-c8a3e2e416c8','SNAPSHOT'),(662,'7a480eb2-a7b4-4ec5-b628-ef6c2043dd7a','e3dcb444-172f-4ae1-a2bc-7ff3b7c8eb26','MODEL'),(662,'7f9aec2d-6246-4413-842d-78d2e0bddb1e','9d5d6282-185b-45e3-8902-11f6f83c2991','SNAPSHOT'),(662,'7f9aec2d-6246-4413-842d-78d2e0bddb1e','f6615787-bb2f-4f28-b265-517b66795996','MODEL'),(662,'7fad3bba-f2b2-41ce-849b-756d995c0414','1b9e7359-42f9-45c8-9ddf-605c192e8a57','SNAPSHOT'),(662,'7fad3bba-f2b2-41ce-849b-756d995c0414','436f05c6-b083-492e-bd94-ce39d9a91136','MODEL'),(662,'802e2d49-5b37-47b7-b8e9-4fb4bff1f62f','2367f698-7e4f-4e60-b31f-752903f8cd34','SNAPSHOT'),(662,'802e2d49-5b37-47b7-b8e9-4fb4bff1f62f','472a6b31-d305-463f-a0b2-2abeb6fa2c3e','MODEL'),(662,'876f775b-e8a0-4b7f-bea0-0c93a7041d17','4b797e84-44dc-4df1-9b19-d421afa9bb08','SNAPSHOT'),(662,'876f775b-e8a0-4b7f-bea0-0c93a7041d17','d47ef10b-7c9f-4fd9-8617-329e21bbfa35','MODEL'),(662,'87a0a17a-c973-40c2-9d84-2392b0d62afb','1e3c210c-a983-4276-916c-6c49b0e64e1d','SNAPSHOT'),(662,'87a0a17a-c973-40c2-9d84-2392b0d62afb','372c807f-a172-495b-9111-e2a86808505c','MODEL'),(662,'87a0a17a-c973-40c2-9d84-2392b0d62afb','477bef20-19c4-472b-89d8-912285f5e534','SNAPSHOT'),(662,'87a0a17a-c973-40c2-9d84-2392b0d62afb','f69344e1-d52d-49da-acc5-b714cb86225d','MODEL'),(662,'881d38cc-cf89-4329-8456-b90f8c997725','20195b26-5345-4f9f-bbd5-4e2ac9fd972d','SNAPSHOT'),(662,'881d38cc-cf89-4329-8456-b90f8c997725','9617b0df-e829-47cd-8110-fabb587a690d','MODEL'),(662,'8a4f0a25-fae8-4564-8f4a-63f4168b2915','72c86a01-5d0c-47ea-8964-b3832ab6a43f','MODEL'),(662,'8a4f0a25-fae8-4564-8f4a-63f4168b2915','79ba2d1d-77b5-4b68-a71f-efb6c2b2b49d','SNAPSHOT'),(662,'919caf8c-919a-49cc-bf39-68486f2f5991','04758fa4-84c5-4d84-a8c3-6b431275e3cd','SNAPSHOT'),(662,'919caf8c-919a-49cc-bf39-68486f2f5991','5e1416aa-d0a4-4f50-98c6-8e1f1e6d994d','MODEL'),(662,'9716867f-e0a3-478a-a498-1e84ae803044','506aaec6-4b3a-4a00-9e18-ddc95eb010f4','MODEL'),(662,'9716867f-e0a3-478a-a498-1e84ae803044','5f516c96-8333-49f5-8c71-3a7e8878488c','MODEL'),(662,'9716867f-e0a3-478a-a498-1e84ae803044','ca0a9826-3f91-4aaf-984b-889d4cff43a5','SNAPSHOT'),(662,'9716867f-e0a3-478a-a498-1e84ae803044','f8d60891-9893-425b-9839-c04fdf0d0cd5','SNAPSHOT'),(662,'98e7c216-5bb9-4127-9497-834796980370','13991d0c-102a-4df8-aaad-f5f422edc6be','MODEL'),(662,'98e7c216-5bb9-4127-9497-834796980370','9b87eb98-b2ac-4d29-83ea-5125f3d83710','SNAPSHOT'),(662,'99102b35-9ad0-4017-b70e-fa08e5c36102','4210a84b-05e7-47b1-9d77-62e41dc0e731','SNAPSHOT'),(662,'99102b35-9ad0-4017-b70e-fa08e5c36102','d82bb8e8-709c-4148-9290-d8b05ce3f7e6','MODEL'),(662,'993cf4b8-d914-11ed-b558-229278a3c906','dc68fc0d-d914-11ed-b558-229278a3c906','MODEL'),(662,'993cf4b8-d914-11ed-b558-229278a3c906','dc690efd-d914-11ed-b558-229278a3c906','SNAPSHOT'),(662,'99a6d55d-de66-49eb-a717-49cb2587fbef','2607735b-f648-4b52-882f-e91b883da1be','SNAPSHOT'),(662,'99a6d55d-de66-49eb-a717-49cb2587fbef','f500b4e0-bd2d-4992-901f-526fc78912cf','MODEL'),(662,'a26f0d58-ca46-4921-a9e1-9c39b7f89783','118f4b39-1c4d-49d5-9470-979ae78a94eb','SNAPSHOT'),(662,'a26f0d58-ca46-4921-a9e1-9c39b7f89783','23251874-b8f3-48b3-b209-0b434edd5db0','MODEL'),(662,'a26f0d58-ca46-4921-a9e1-9c39b7f89783','24c23cdd-d323-4623-8a9d-2d3e14f3b937','SNAPSHOT'),(662,'a26f0d58-ca46-4921-a9e1-9c39b7f89783','5fe946a4-d7b1-4c37-a75f-cda8a073daf9','MODEL'),(662,'a26f0d58-ca46-4921-a9e1-9c39b7f89783','a017e06b-1e5e-408c-9423-28e5f5e8e405','SNAPSHOT'),(662,'a26f0d58-ca46-4921-a9e1-9c39b7f89783','ac0adbda-ae71-490a-947a-f9bfe33db7e8','MODEL'),(662,'a6d52fce-2e61-4375-bf6d-a36f9b3eb72f','0a02b656-9179-4cbd-ae14-079f4f933517','MODEL'),(662,'a6d52fce-2e61-4375-bf6d-a36f9b3eb72f','55cd923a-d543-4e42-8f4a-de07877d1b09','SNAPSHOT'),(662,'a6fbb2c0-d901-11ed-9278-00d86184ce0e','a6fbdae8-d901-11ed-9278-00d86184ce0e','MODEL'),(662,'a6fbb2c0-d901-11ed-9278-00d86184ce0e','a70ac522-d901-11ed-9278-00d86184ce0e','SNAPSHOT'),(662,'a90158f7-0d39-4b9d-984b-57de06099c65','03c11f7d-c2ac-42f2-8983-927ccff14074','SNAPSHOT'),(662,'a90158f7-0d39-4b9d-984b-57de06099c65','2d1d8d21-ec2c-485d-98af-375a4d8263d6','SNAPSHOT'),(662,'a90158f7-0d39-4b9d-984b-57de06099c65','31b407a6-51a1-4581-a381-00a2955c6d4d','MODEL'),(662,'a90158f7-0d39-4b9d-984b-57de06099c65','6420c2d7-bcdf-4e2e-9ee7-e90e3b7b7045','MODEL'),(662,'a90158f7-0d39-4b9d-984b-57de06099c65','7a4d7123-69ae-4260-adf1-9661ad22cb0f','SNAPSHOT'),(662,'a90158f7-0d39-4b9d-984b-57de06099c65','8396da09-c9ea-476d-ab69-648f06ec6534','MODEL'),(662,'a93c6a8f-0c96-47ae-bc72-75a725946a5a','1e81852e-fdc6-4523-9e33-47494d60d953','SNAPSHOT'),(662,'a93c6a8f-0c96-47ae-bc72-75a725946a5a','8d582d54-5f1f-4ac9-ac0e-a9aa41cc41e1','MODEL'),(662,'aaa22dcc-d910-11ed-b558-229278a3c906','05260ab4-d913-11ed-b558-229278a3c906','MODEL'),(662,'aaa22dcc-d910-11ed-b558-229278a3c906','0527500a-d913-11ed-b558-229278a3c906','SNAPSHOT'),(662,'aaa22dcc-d910-11ed-b558-229278a3c906','366f07b3-d912-11ed-b558-229278a3c906','MODEL'),(662,'aaa22dcc-d910-11ed-b558-229278a3c906','366f3933-d912-11ed-b558-229278a3c906','SNAPSHOT'),(662,'ac6f0be1-d915-11ed-b558-229278a3c906','e1c42d91-d915-11ed-b558-229278a3c906','MODEL'),(662,'ac6f0be1-d915-11ed-b558-229278a3c906','e1c443e6-d915-11ed-b558-229278a3c906','SNAPSHOT'),(662,'ae899af8-7040-48c9-a9b2-6ebc255ac7c9','102a1df9-b0fe-46c3-b1b6-edddfb8c021b','SNAPSHOT'),(662,'ae899af8-7040-48c9-a9b2-6ebc255ac7c9','e1692a67-2979-4399-b4dc-65a1c7e9c4b8','MODEL'),(662,'b002027b-930d-4b96-a687-453aeea5659e','14c0bac1-16fe-41ce-863b-85ffd35f41e9','SNAPSHOT'),(662,'b002027b-930d-4b96-a687-453aeea5659e','689b438f-3633-4981-b669-5e49a97a5c95','MODEL'),(662,'b002027b-930d-4b96-a687-453aeea5659e','90d34496-4e10-41d5-b77c-75826f81327e','SNAPSHOT'),(662,'b002027b-930d-4b96-a687-453aeea5659e','fad00b24-cf95-4da0-aa56-8c7af1870289','MODEL'),(662,'b24d4ab4-dba3-4be5-8ba3-7eee381f40ec','850a1a2e-2e87-4cda-8ec5-a2dcd149731d','SNAPSHOT'),(662,'b24d4ab4-dba3-4be5-8ba3-7eee381f40ec','b6b42cf7-31c1-49e1-b1d1-c607c7ba299b','MODEL'),(662,'b289ff52-6765-45a7-b1e2-fe7161ba809f','b6f09e06-083f-4c19-ae6f-63af10340898','MODEL'),(662,'b289ff52-6765-45a7-b1e2-fe7161ba809f','c96624b7-bb0a-400c-b02e-bdfd89bdac9e','SNAPSHOT'),(662,'b5005e42-2d4d-41b0-91d5-667275f3a9cc','169331da-dbab-454e-828b-67287bb2feb7','SNAPSHOT'),(662,'b5005e42-2d4d-41b0-91d5-667275f3a9cc','51c81dd7-f872-4092-9a17-d9b3821ed7c8','MODEL'),(662,'b7931623-9b21-4440-a950-16565249bf9a','3d2bee32-9787-46dd-b6a9-cba9de226dfb','SNAPSHOT'),(662,'b7931623-9b21-4440-a950-16565249bf9a','49c43140-7062-4b44-a49e-83c262304d61','MODEL'),(662,'b7931623-9b21-4440-a950-16565249bf9a','6008312e-ba22-4c98-a696-7500991d7069','MODEL'),(662,'b7931623-9b21-4440-a950-16565249bf9a','60a7c19d-824d-4fdf-a109-f3df643a3f1a','SNAPSHOT'),(662,'b7931623-9b21-4440-a950-16565249bf9a','88b2c3fc-981f-4818-aa0f-2cbbbc6a3b31','SNAPSHOT'),(662,'b7931623-9b21-4440-a950-16565249bf9a','bc10348b-1c26-48ee-bc8f-6fa5ac933a14','MODEL'),(662,'b7931623-9b21-4440-a950-16565249bf9a','eee409c6-39bb-43e6-9a2d-c17ecc88cf08','MODEL'),(662,'b7931623-9b21-4440-a950-16565249bf9a','f3f82ebd-8318-469e-9bdd-ff76223b9c1c','SNAPSHOT'),(662,'bd51414b-f96e-4903-a2e2-44fb3189decd','04955796-a392-49c6-b40d-fba48ef36844','MODEL'),(662,'bd51414b-f96e-4903-a2e2-44fb3189decd','160153e9-3248-4a6b-b0ff-a10c2c1acfc9','SNAPSHOT'),(662,'bd51414b-f96e-4903-a2e2-44fb3189decd','1f29b918-27fd-422b-b4dd-da18687d0871','MODEL'),(662,'bd51414b-f96e-4903-a2e2-44fb3189decd','4743873a-96f6-412f-91c5-a4b27c7d6847','SNAPSHOT'),(662,'bd51414b-f96e-4903-a2e2-44fb3189decd','5f33a727-5198-4fcf-af3d-ae94e86da222','MODEL'),(662,'bd51414b-f96e-4903-a2e2-44fb3189decd','81e806ef-052e-4347-928a-d06d1d3a299b','MODEL'),(662,'bd51414b-f96e-4903-a2e2-44fb3189decd','a6c49c5b-a994-457c-80d2-6cd69b636979','MODEL'),(662,'bd51414b-f96e-4903-a2e2-44fb3189decd','bcb2c331-8297-48c9-9ba7-66e21108faf8','SNAPSHOT'),(662,'bd51414b-f96e-4903-a2e2-44fb3189decd','f0fe7a67-1ca7-4da6-b4e1-681dc8f0e6b1','SNAPSHOT'),(662,'bd51414b-f96e-4903-a2e2-44fb3189decd','f9419645-8fbf-4bf1-99ba-df5bd8485ab2','SNAPSHOT'),(662,'be9a4ba5-715b-4547-a31d-66621ec7b17f','13fa1125-c9d0-498d-bc50-68dc9f4f1beb','SNAPSHOT'),(662,'be9a4ba5-715b-4547-a31d-66621ec7b17f','2fe7a2a7-6a20-4d12-ba81-6c46af5e0703','MODEL'),(662,'be9a4ba5-715b-4547-a31d-66621ec7b17f','5498794c-1fcc-48dd-b50e-b57ca5d157ab','MODEL'),(662,'be9a4ba5-715b-4547-a31d-66621ec7b17f','632bdd11-c86e-438a-af78-cfcc9f793d03','SNAPSHOT'),(662,'be9a4ba5-715b-4547-a31d-66621ec7b17f','ab47d04c-6ad7-430c-ae85-9231a2efc7b9','MODEL'),(662,'be9a4ba5-715b-4547-a31d-66621ec7b17f','f967ed2c-cc61-428f-8d34-99152f99ce47','SNAPSHOT'),(662,'c00beb59-a67d-4566-801a-0081588c2a04','45a66afe-8bb2-49b4-b3fc-982c845cf2f2','MODEL'),(662,'c00beb59-a67d-4566-801a-0081588c2a04','587c45f4-d25d-4cad-8934-761b77e11986','SNAPSHOT'),(662,'c1232582-95fc-48dc-a9ee-826c0cbad106','1712177a-2d33-429e-81ed-e58b3ec65c4d','SNAPSHOT'),(662,'c1232582-95fc-48dc-a9ee-826c0cbad106','c19a9e26-b162-4808-8d10-9d6a38e24e98','MODEL'),(662,'c6bba495-6d1a-4da8-bb1f-852a1b1e5924','38ff0511-8c8a-4f8b-a2a4-13c26e804b9d','MODEL'),(662,'c6bba495-6d1a-4da8-bb1f-852a1b1e5924','f7e28eea-71d1-4771-8eaa-cbc7fd8fd17a','SNAPSHOT'),(662,'c99bbff9-5630-49d7-9300-4dabfa5e74c8','430388c7-9e1e-4f20-b931-839cea08cfe1','SNAPSHOT'),(662,'c99bbff9-5630-49d7-9300-4dabfa5e74c8','d7178627-cef8-4d56-87be-5ce753175b9f','MODEL'),(662,'ca33a9ff-b86a-4e97-8674-1bd7adc92759','a2156f23-da3f-4a2a-97f3-76ea6c877521','SNAPSHOT'),(662,'ca33a9ff-b86a-4e97-8674-1bd7adc92759','a483fb03-0adb-4387-9099-c9c2567855e7','MODEL'),(662,'cb1d5d31-89cd-4ab4-bada-dc6b2235cac5','35704ab9-18dc-4d80-81f3-5f50e93033c6','SNAPSHOT'),(662,'cb1d5d31-89cd-4ab4-bada-dc6b2235cac5','58f5907e-16f5-4910-b9e6-81046fdd76df','MODEL'),(662,'cb1d5d31-89cd-4ab4-bada-dc6b2235cac5','de0cdea6-9c25-4adc-b642-788b56270d11','SNAPSHOT'),(662,'cb1d5d31-89cd-4ab4-bada-dc6b2235cac5','ff9a5767-77f0-4ea4-80de-642c5142026c','MODEL'),(662,'ccd3f4f6-f303-4b20-b967-d41121f2e36b','6e7d5030-f9a6-4e4d-baf7-7a0f3c335bfc','SNAPSHOT'),(662,'ccd3f4f6-f303-4b20-b967-d41121f2e36b','d3e47b22-64d4-4936-a2f6-a2a11b01fdf2','MODEL'),(662,'cd4cde89-86e9-4257-92b6-869e9aa8d1f6','4582b122-e1ac-4901-8817-e05e3192fc42','MODEL'),(662,'cd4cde89-86e9-4257-92b6-869e9aa8d1f6','cc3c0e89-9cd8-4432-9607-044314bb9633','SNAPSHOT'),(662,'d04345c3-df70-4e2a-b197-cc37138e6700','94dbef5a-271e-457d-ba7b-ace1dbe05081','MODEL'),(662,'d04345c3-df70-4e2a-b197-cc37138e6700','b19b3b70-d194-4a56-8a06-dc3cf2fb8e6a','SNAPSHOT'),(662,'d1ad6baa-b3e6-4e10-bd69-140c7abc8f4e','364852fb-413f-4160-99e2-dfbc1733ad1a','MODEL'),(662,'d1ad6baa-b3e6-4e10-bd69-140c7abc8f4e','de0c426e-a321-49cc-9a15-8f590e95c146','SNAPSHOT'),(662,'d2372948-816f-4d58-a2bf-288bc0e7b539','127e55bb-48e6-421e-ab6a-05b0763a843e','MODEL'),(662,'d2372948-816f-4d58-a2bf-288bc0e7b539','2a2002a5-6321-4c63-938e-7276412e6a28','MODEL'),(662,'d2372948-816f-4d58-a2bf-288bc0e7b539','3f126af5-ce2b-4e13-8fc8-9811ab5d462c','SNAPSHOT'),(662,'d2372948-816f-4d58-a2bf-288bc0e7b539','98a2c194-b406-4930-b901-3f1b520fc329','SNAPSHOT'),(662,'d2cd260d-4191-4884-80e3-7ced9fa0f8ce','6558fea4-267a-4a73-8416-579630e68249','MODEL'),(662,'d2cd260d-4191-4884-80e3-7ced9fa0f8ce','a76fbd10-38f6-45b2-bcd6-4235bebb7cc8','SNAPSHOT'),(662,'d2cd260d-4191-4884-80e3-7ced9fa0f8ce','b50704aa-49f1-4444-8df4-4ec2e9e99b38','MODEL'),(662,'d2cd260d-4191-4884-80e3-7ced9fa0f8ce','e0c2841d-b460-4eda-9548-18bb8a59d908','SNAPSHOT'),(662,'d36d186b-d0da-4aea-af1a-4613f67b2fa0','e22d8b26-814a-456b-850f-82860b769634','MODEL'),(662,'d36d186b-d0da-4aea-af1a-4613f67b2fa0','fb86258d-e165-4e8e-a22f-d60bf23a6d59','SNAPSHOT'),(662,'d3a42d3d-3d98-457b-bb64-4119091b03f9','2129ad39-4745-4e82-a5b8-dcf7933c6ae7','MODEL'),(662,'d3a42d3d-3d98-457b-bb64-4119091b03f9','f574474f-dc28-462d-9251-b23591ca9bcb','SNAPSHOT'),(662,'d4c7f3c5-155d-41ef-8665-852e89c5e017','1e115805-b191-4113-972e-a4489d95599a','SNAPSHOT'),(662,'d4c7f3c5-155d-41ef-8665-852e89c5e017','78aec42f-0ec9-4ca8-b05e-324d3b955b86','MODEL'),(662,'d52d9ce0-7fed-491c-a385-929e22fb07d5','1f608503-4867-4253-a143-dd200e0ebe0a','MODEL'),(662,'d52d9ce0-7fed-491c-a385-929e22fb07d5','9319bd6a-6e7d-4505-8090-e4e10e3caec0','SNAPSHOT'),(662,'d675acff-ab7f-4d65-b55c-558379a8b3d0','5c2ae31f-cf6e-42c8-9d38-6f41e1e8db02','MODEL'),(662,'d675acff-ab7f-4d65-b55c-558379a8b3d0','b01eb471-5baa-4958-b2c6-736eab81754a','SNAPSHOT'),(662,'d7c4d383-83f9-4275-bbcc-567a47d4a450','73466738-f8a5-4b0e-a6af-9c63c2e802e6','SNAPSHOT'),(662,'d7c4d383-83f9-4275-bbcc-567a47d4a450','ed40ce9a-6d1f-4cfd-a3e2-f58cba946869','MODEL'),(662,'d9ec0349-f28e-41d6-822f-e76c8c001da9','0b4e8e31-bd54-4394-8ebc-2c2d30d84197','MODEL'),(662,'d9ec0349-f28e-41d6-822f-e76c8c001da9','2a17666e-f40f-403e-88af-a4cfaf6332ec','SNAPSHOT'),(662,'de216c91-485b-4dac-9e7c-b89075739521','2554e0bc-d621-46e3-90e6-f7d7f2085b98','MODEL'),(662,'de216c91-485b-4dac-9e7c-b89075739521','2632ca9d-afe6-4104-a347-d590758abfc0','SNAPSHOT'),(662,'deeedce8-d914-11ed-b558-229278a3c906','0d5d836c-d915-11ed-b558-229278a3c906','MODEL'),(662,'deeedce8-d914-11ed-b558-229278a3c906','0d5d9857-d915-11ed-b558-229278a3c906','SNAPSHOT'),(662,'e5fd24c7-49a8-4dbc-9356-3b96970d2515','2aa2008a-2609-41f7-99c6-d3b7a4560466','SNAPSHOT'),(662,'e5fd24c7-49a8-4dbc-9356-3b96970d2515','9d65d7e8-dc55-4823-9aae-6c5190aae7da','MODEL'),(662,'e6c99474-f6f6-447f-bcaa-d4c791811e18','23066de9-fbda-436c-bd8b-dacb5721c390','MODEL'),(662,'e6c99474-f6f6-447f-bcaa-d4c791811e18','82997513-4864-4e01-8853-7053a2892d95','SNAPSHOT'),(662,'e6e5d8c5-2d8c-48d0-9708-e3256202d385','3f34dab9-eda8-40de-be81-a094dee55a47','MODEL'),(662,'e6e5d8c5-2d8c-48d0-9708-e3256202d385','6e9feeb8-6d42-4237-b134-51d979397898','MODEL'),(662,'e6e5d8c5-2d8c-48d0-9708-e3256202d385','d0155fb7-667e-4f4e-be6a-1eacb81ecb13','SNAPSHOT'),(662,'e6e5d8c5-2d8c-48d0-9708-e3256202d385','fe5b0b87-b40b-40f8-a762-d9fc8f4a87a6','SNAPSHOT'),(662,'e7efed59-e33c-4194-94c1-3507350dcfb5','144ce692-0397-4de4-aa07-e50e85b5a553','SNAPSHOT'),(662,'e7efed59-e33c-4194-94c1-3507350dcfb5','42d780c5-37b5-433e-890f-3c005cb69701','MODEL'),(662,'e7efed59-e33c-4194-94c1-3507350dcfb5','9d114e81-9c84-452b-9722-47ddb78d35e5','SNAPSHOT'),(662,'e7efed59-e33c-4194-94c1-3507350dcfb5','b94c36ee-0e86-44b0-a152-b92997bdab17','SNAPSHOT'),(662,'e7efed59-e33c-4194-94c1-3507350dcfb5','c0c1a357-1f5c-443a-ac07-9cc3a45a7853','MODEL'),(662,'e7efed59-e33c-4194-94c1-3507350dcfb5','e94bbc94-0540-4634-816e-4a842ced15fa','MODEL'),(662,'e8ff012c-af85-450f-ba33-bd61c15846e9','45a97d29-279f-4720-856d-2ef701665f93','MODEL'),(662,'e8ff012c-af85-450f-ba33-bd61c15846e9','4a84b07a-6e20-4dea-85d3-199cb3adf0f5','SNAPSHOT'),(662,'e9134dab-33d6-42e4-8779-ab502b18266c','40c9dd9e-b85c-4ed6-a37e-81b5b8e9124d','MODEL'),(662,'e9134dab-33d6-42e4-8779-ab502b18266c','449406e4-68d2-4fa1-9032-2e72795a7ec2','SNAPSHOT'),(662,'e9134dab-33d6-42e4-8779-ab502b18266c','517e0273-72a1-4e4d-8815-d303a233a31d','SNAPSHOT'),(662,'e9134dab-33d6-42e4-8779-ab502b18266c','6578f0f2-99f0-4b42-b32d-3bfc8a7b4697','MODEL'),(662,'e9134dab-33d6-42e4-8779-ab502b18266c','729f8772-5a1d-40db-b918-270cc340ba8e','SNAPSHOT'),(662,'e9134dab-33d6-42e4-8779-ab502b18266c','7f4bb473-7bb6-4ba8-a767-c1e722ce5c1b','MODEL'),(662,'e99b1c89-977c-4836-9719-ad6d9a6f6aae','b51adc6b-e313-4ada-a607-3b0cd408c55b','SNAPSHOT'),(662,'e99b1c89-977c-4836-9719-ad6d9a6f6aae','faa7f2df-9772-4aef-b228-35b51fb8134d','MODEL'),(662,'e9aaa539-6e84-47bc-9c50-2c8797de82a4','6f481e07-43c0-494b-8d4f-279772780eec','MODEL'),(662,'e9aaa539-6e84-47bc-9c50-2c8797de82a4','c063b377-02e8-4830-bf3f-414b4e6325ca','SNAPSHOT'),(662,'ecd2beec-0c29-40e2-ab95-64009c33fa40','229d55f2-d907-49a9-ae4c-c2359e8ce810','MODEL'),(662,'ecd2beec-0c29-40e2-ab95-64009c33fa40','f3030b14-8ec9-4a85-a2ac-04d14a2a6ab4','SNAPSHOT'),(662,'ed495283-b756-4052-ba8b-5fe9f9b1f8be','1e41852a-1d94-44eb-90f9-b06c401ee8b7','MODEL'),(662,'ed495283-b756-4052-ba8b-5fe9f9b1f8be','53ebdc66-a057-4dc0-8a89-3e9bc7e5d11d','MODEL'),(662,'ed495283-b756-4052-ba8b-5fe9f9b1f8be','7fbf5bd8-6de6-46b1-bd50-c2480472006d','SNAPSHOT'),(662,'ed495283-b756-4052-ba8b-5fe9f9b1f8be','f3d5a2ce-9a80-4c06-a1b4-85bce5e716ea','SNAPSHOT'),(662,'eece5ace-2081-4f39-859f-68495bd82499','c7871ca0-e84a-4880-b74b-ef641334860e','MODEL'),(662,'eece5ace-2081-4f39-859f-68495bd82499','cfce77ff-b3ac-4f31-ba2d-7ffffd711fef','SNAPSHOT'),(662,'ef79558a-21cf-4117-a0b7-ba0adf40f7dc','25d2e57a-b759-4ab8-a633-7725e7375d70','MODEL'),(662,'ef79558a-21cf-4117-a0b7-ba0adf40f7dc','a97b41cc-c47f-42ff-aed9-3b6ec8803714','SNAPSHOT'),(662,'f0b63e95-26e8-4213-a935-ca2c37ab36ba','1f154183-a975-4dfa-b4eb-fea963eb0d6c','SNAPSHOT'),(662,'f0b63e95-26e8-4213-a935-ca2c37ab36ba','6918be85-b74b-4069-b2b3-914477ca77ad','MODEL'),(662,'f0b63e95-26e8-4213-a935-ca2c37ab36ba','d2ffe250-09d3-47fd-af00-7d6cc98742d8','MODEL'),(662,'f0b63e95-26e8-4213-a935-ca2c37ab36ba','d5ddb4c9-b9d4-4dbd-91ab-8ba108c565e0','SNAPSHOT'),(662,'f2b8c151-b863-4411-b17a-b987ca58ee6f','11dc5cec-d45b-455d-8577-dcf502967a94','SNAPSHOT'),(662,'f2b8c151-b863-4411-b17a-b987ca58ee6f','b7e23c05-dca2-450c-8296-062f60712c4b','MODEL'),(662,'f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97','3aa92b1f-240d-45e1-a722-e8da98368f3a','MODEL'),(662,'f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97','3ddb3953-cee7-44fd-b8e2-76afee946647','SNAPSHOT'),(662,'f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97','5dfbe9b8-c587-4311-b392-743be40fdd10','SNAPSHOT'),(662,'f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97','65867250-5b1d-4a93-b4d9-d00468a4d2fa','MODEL'),(662,'f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97','8248bc2e-a7bc-4a4e-9fc9-f2326990454c','SNAPSHOT'),(662,'f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97','97939bfa-2cd3-4695-a8de-c1359ed5322d','MODEL'),(662,'f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97','b6432038-01b6-4f88-8506-0a2a5906d721','SNAPSHOT'),(662,'f3cfd6c2-7c52-4adb-b83c-3a9bfcfb5c97','c8503263-9efa-47b8-8764-2bb09be6a1cb','MODEL'),(662,'f766f1dd-53ad-45fc-8f7b-a61d47dfe500','40bc13d8-af5e-436f-825b-372a9ad37b03','MODEL'),(662,'f766f1dd-53ad-45fc-8f7b-a61d47dfe500','ca42217b-f484-48a1-bff2-3b72dc4f7f2f','SNAPSHOT'),(662,'fbfa4372-1faf-4a14-9f4e-70b7b375da7d','5bdd9b13-0942-46d1-92ac-4b22472007ae','MODEL'),(662,'fbfa4372-1faf-4a14-9f4e-70b7b375da7d','80e2978d-ccbf-46b3-90aa-49fde4694d47','SNAPSHOT'),(662,'fbfa4372-1faf-4a14-9f4e-70b7b375da7d','85dade24-9cc8-4e62-afe5-2da409796449','MODEL'),(662,'fbfa4372-1faf-4a14-9f4e-70b7b375da7d','9946c86d-7b6b-4bd2-8dae-8b982fbd7cfc','SNAPSHOT');
/*!40000 ALTER TABLE `ScanFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SentAttachment`
--

DROP TABLE IF EXISTS `SentAttachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SentAttachment` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `sentMessageId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  PRIMARY KEY (`sentMessageId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `SentAttachment_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `SentAttachment_ibfk_2` FOREIGN KEY (`sentMessageId`) REFERENCES `SentMessage` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `SentAttachment_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SentAttachment`
--

LOCK TABLES `SentAttachment` WRITE;
/*!40000 ALTER TABLE `SentAttachment` DISABLE KEYS */;
INSERT INTO `SentAttachment` VALUES (662,'0044629b-c48a-4f47-95b1-f178384b2b25','1e41852a-1d94-44eb-90f9-b06c401ee8b7'),(662,'0044629b-c48a-4f47-95b1-f178384b2b25','4210a84b-05e7-47b1-9d77-62e41dc0e731'),(662,'0044629b-c48a-4f47-95b1-f178384b2b25','6f481e07-43c0-494b-8d4f-279772780eec'),(662,'0044629b-c48a-4f47-95b1-f178384b2b25','7cace217-66b4-4147-97f5-c8c1a7dfe1cd'),(662,'0044629b-c48a-4f47-95b1-f178384b2b25','c063b377-02e8-4830-bf3f-414b4e6325ca'),(662,'0044629b-c48a-4f47-95b1-f178384b2b25','d82bb8e8-709c-4148-9290-d8b05ce3f7e6'),(662,'0044629b-c48a-4f47-95b1-f178384b2b25','dc97d683-1aa5-4aba-bf5c-a43b36478d90'),(662,'0044629b-c48a-4f47-95b1-f178384b2b25','f3d5a2ce-9a80-4c06-a1b4-85bce5e716ea'),(662,'092ae2c6-d903-11ed-9278-00d86184ce0e','3b6f0d95-5183-43aa-8816-815a96e7e143'),(662,'092ae2c6-d903-11ed-9278-00d86184ce0e','4782af06-5171-4020-833c-143c6a151469'),(662,'0fc3bc59-0e74-46f1-9d1b-4edee6fffcc3','a6c49c5b-a994-457c-80d2-6cd69b636979'),(662,'0fc3bc59-0e74-46f1-9d1b-4edee6fffcc3','f9419645-8fbf-4bf1-99ba-df5bd8485ab2'),(662,'18cb70e0-eb87-4a95-b5d9-b5e39616e0e8','169331da-dbab-454e-828b-67287bb2feb7'),(662,'18cb70e0-eb87-4a95-b5d9-b5e39616e0e8','1e3c210c-a983-4276-916c-6c49b0e64e1d'),(662,'18cb70e0-eb87-4a95-b5d9-b5e39616e0e8','1e81852e-fdc6-4523-9e33-47494d60d953'),(662,'18cb70e0-eb87-4a95-b5d9-b5e39616e0e8','1f608503-4867-4253-a143-dd200e0ebe0a'),(662,'18cb70e0-eb87-4a95-b5d9-b5e39616e0e8','51c81dd7-f872-4092-9a17-d9b3821ed7c8'),(662,'18cb70e0-eb87-4a95-b5d9-b5e39616e0e8','60a7c19d-824d-4fdf-a109-f3df643a3f1a'),(662,'18cb70e0-eb87-4a95-b5d9-b5e39616e0e8','8d582d54-5f1f-4ac9-ac0e-a9aa41cc41e1'),(662,'18cb70e0-eb87-4a95-b5d9-b5e39616e0e8','9319bd6a-6e7d-4505-8090-e4e10e3caec0'),(662,'18cb70e0-eb87-4a95-b5d9-b5e39616e0e8','bc10348b-1c26-48ee-bc8f-6fa5ac933a14'),(662,'18cb70e0-eb87-4a95-b5d9-b5e39616e0e8','f69344e1-d52d-49da-acc5-b714cb86225d'),(662,'23ab56bc-8ef1-4eb4-92c0-3f4eb41aa456','25d2e57a-b759-4ab8-a633-7725e7375d70'),(662,'23ab56bc-8ef1-4eb4-92c0-3f4eb41aa456','2607735b-f648-4b52-882f-e91b883da1be'),(662,'23ab56bc-8ef1-4eb4-92c0-3f4eb41aa456','330dc645-80dc-4734-bc6a-ba2a87b5f495'),(662,'23ab56bc-8ef1-4eb4-92c0-3f4eb41aa456','49635be4-dbea-497c-82e1-206399739c31'),(662,'23ab56bc-8ef1-4eb4-92c0-3f4eb41aa456','73466738-f8a5-4b0e-a6af-9c63c2e802e6'),(662,'23ab56bc-8ef1-4eb4-92c0-3f4eb41aa456','84c96eac-549e-4c1d-a701-896474d66a31'),(662,'23ab56bc-8ef1-4eb4-92c0-3f4eb41aa456','a97b41cc-c47f-42ff-aed9-3b6ec8803714'),(662,'23ab56bc-8ef1-4eb4-92c0-3f4eb41aa456','d5df3022-2abe-4d54-a53d-63cb7ad80b02'),(662,'23ab56bc-8ef1-4eb4-92c0-3f4eb41aa456','ed40ce9a-6d1f-4cfd-a3e2-f58cba946869'),(662,'23ab56bc-8ef1-4eb4-92c0-3f4eb41aa456','f500b4e0-bd2d-4992-901f-526fc78912cf'),(662,'2ac5c4e8-2400-4099-bdff-66744db946c7','0a02b656-9179-4cbd-ae14-079f4f933517'),(662,'2ac5c4e8-2400-4099-bdff-66744db946c7','0e855e55-dc7f-4eaf-91bd-933232cae95e'),(662,'2ac5c4e8-2400-4099-bdff-66744db946c7','20195b26-5345-4f9f-bbd5-4e2ac9fd972d'),(662,'2ac5c4e8-2400-4099-bdff-66744db946c7','4f638684-087b-42a0-916a-a8adc0c1eeea'),(662,'2ac5c4e8-2400-4099-bdff-66744db946c7','55cd923a-d543-4e42-8f4a-de07877d1b09'),(662,'2ac5c4e8-2400-4099-bdff-66744db946c7','791a0795-78ad-4b6e-a31b-bdc257f06704'),(662,'2ac5c4e8-2400-4099-bdff-66744db946c7','7b9836aa-2cf6-485a-b0d3-39d73de4bc8b'),(662,'2ac5c4e8-2400-4099-bdff-66744db946c7','9617b0df-e829-47cd-8110-fabb587a690d'),(662,'2ac5c4e8-2400-4099-bdff-66744db946c7','dd29f41a-cbb1-45d7-8979-1d16d4db487c'),(662,'2ac5c4e8-2400-4099-bdff-66744db946c7','f1ef3944-d73f-4a49-8e28-c4619cb61202'),(662,'2d372f67-16da-4c22-a951-9f22b14b8a00','169331da-dbab-454e-828b-67287bb2feb7'),(662,'2d372f67-16da-4c22-a951-9f22b14b8a00','1e3c210c-a983-4276-916c-6c49b0e64e1d'),(662,'2d372f67-16da-4c22-a951-9f22b14b8a00','1e81852e-fdc6-4523-9e33-47494d60d953'),(662,'2d372f67-16da-4c22-a951-9f22b14b8a00','1f608503-4867-4253-a143-dd200e0ebe0a'),(662,'2d372f67-16da-4c22-a951-9f22b14b8a00','1f629ca9-f822-4a93-aecc-1e8473c82dd5'),(662,'2d372f67-16da-4c22-a951-9f22b14b8a00','51c81dd7-f872-4092-9a17-d9b3821ed7c8'),(662,'2d372f67-16da-4c22-a951-9f22b14b8a00','60a7c19d-824d-4fdf-a109-f3df643a3f1a'),(662,'2d372f67-16da-4c22-a951-9f22b14b8a00','8d582d54-5f1f-4ac9-ac0e-a9aa41cc41e1'),(662,'2d372f67-16da-4c22-a951-9f22b14b8a00','bc10348b-1c26-48ee-bc8f-6fa5ac933a14'),(662,'2d372f67-16da-4c22-a951-9f22b14b8a00','f69344e1-d52d-49da-acc5-b714cb86225d'),(662,'41ad7d4a-f203-41dd-a78f-61f850f52110','169331da-dbab-454e-828b-67287bb2feb7'),(662,'41ad7d4a-f203-41dd-a78f-61f850f52110','1e3c210c-a983-4276-916c-6c49b0e64e1d'),(662,'41ad7d4a-f203-41dd-a78f-61f850f52110','1e81852e-fdc6-4523-9e33-47494d60d953'),(662,'41ad7d4a-f203-41dd-a78f-61f850f52110','1f608503-4867-4253-a143-dd200e0ebe0a'),(662,'41ad7d4a-f203-41dd-a78f-61f850f52110','51c81dd7-f872-4092-9a17-d9b3821ed7c8'),(662,'41ad7d4a-f203-41dd-a78f-61f850f52110','60a7c19d-824d-4fdf-a109-f3df643a3f1a'),(662,'41ad7d4a-f203-41dd-a78f-61f850f52110','8d582d54-5f1f-4ac9-ac0e-a9aa41cc41e1'),(662,'41ad7d4a-f203-41dd-a78f-61f850f52110','9319bd6a-6e7d-4505-8090-e4e10e3caec0'),(662,'41ad7d4a-f203-41dd-a78f-61f850f52110','95ab2e1b-4b91-4bb5-965e-8086f8805dc7'),(662,'41ad7d4a-f203-41dd-a78f-61f850f52110','bc10348b-1c26-48ee-bc8f-6fa5ac933a14'),(662,'41ad7d4a-f203-41dd-a78f-61f850f52110','f69344e1-d52d-49da-acc5-b714cb86225d'),(662,'465925b7-af46-4fc1-9b89-8f9ef2a8753b','1f02ce0a-9100-460e-987f-c2b91eda5ac1'),(662,'465925b7-af46-4fc1-9b89-8f9ef2a8753b','3c573ce9-f6b2-4667-9726-f5aed56d3325'),(662,'465925b7-af46-4fc1-9b89-8f9ef2a8753b','bb2755e4-36de-4604-9ee9-d2711661ea1d'),(662,'5c3a887b-5354-4dce-a930-c0bf04c73c86','0abfe6c8-8321-4681-9ffd-944418ed370c'),(662,'5c3a887b-5354-4dce-a930-c0bf04c73c86','2129ad39-4745-4e82-a5b8-dcf7933c6ae7'),(662,'5c3a887b-5354-4dce-a930-c0bf04c73c86','27755e68-98ae-4662-a39e-c3ea4ba3cdd4'),(662,'5c3a887b-5354-4dce-a930-c0bf04c73c86','2a2002a5-6321-4c63-938e-7276412e6a28'),(662,'5c3a887b-5354-4dce-a930-c0bf04c73c86','3a8a47b1-96a0-4e8f-a7fa-d5c2f74f3677'),(662,'5c3a887b-5354-4dce-a930-c0bf04c73c86','3f126af5-ce2b-4e13-8fc8-9811ab5d462c'),(662,'5c3a887b-5354-4dce-a930-c0bf04c73c86','48632fc1-3269-4a7f-bdaa-980e30af0358'),(662,'5c3a887b-5354-4dce-a930-c0bf04c73c86','a2156f23-da3f-4a2a-97f3-76ea6c877521'),(662,'5c3a887b-5354-4dce-a930-c0bf04c73c86','a483fb03-0adb-4387-9099-c9c2567855e7'),(662,'5c3a887b-5354-4dce-a930-c0bf04c73c86','a5903ca6-45db-41cc-a262-19592ff5f2e4'),(662,'5c3a887b-5354-4dce-a930-c0bf04c73c86','f574474f-dc28-462d-9251-b23591ca9bcb'),(662,'5d7fb378-e627-43df-a59e-10bf6266bc54','3ddb3953-cee7-44fd-b8e2-76afee946647'),(662,'5d7fb378-e627-43df-a59e-10bf6266bc54','3ff0f96a-5e61-4469-a401-383ca0d260ac'),(662,'5d7fb378-e627-43df-a59e-10bf6266bc54','45a66afe-8bb2-49b4-b3fc-982c845cf2f2'),(662,'5d7fb378-e627-43df-a59e-10bf6266bc54','587c45f4-d25d-4cad-8934-761b77e11986'),(662,'5d7fb378-e627-43df-a59e-10bf6266bc54','5f516c96-8333-49f5-8c71-3a7e8878488c'),(662,'5d7fb378-e627-43df-a59e-10bf6266bc54','6420c2d7-bcdf-4e2e-9ee7-e90e3b7b7045'),(662,'5d7fb378-e627-43df-a59e-10bf6266bc54','7a4d7123-69ae-4260-adf1-9661ad22cb0f'),(662,'5d7fb378-e627-43df-a59e-10bf6266bc54','c8503263-9efa-47b8-8764-2bb09be6a1cb'),(662,'5d7fb378-e627-43df-a59e-10bf6266bc54','f880f49e-bb57-430d-8212-dcb8e015569f'),(662,'5d7fb378-e627-43df-a59e-10bf6266bc54','f8d60891-9893-425b-9839-c04fdf0d0cd5'),(662,'5ec46a14-9328-4345-bf9e-2a103a14fd9f','169331da-dbab-454e-828b-67287bb2feb7'),(662,'5ec46a14-9328-4345-bf9e-2a103a14fd9f','1e3c210c-a983-4276-916c-6c49b0e64e1d'),(662,'5ec46a14-9328-4345-bf9e-2a103a14fd9f','1e81852e-fdc6-4523-9e33-47494d60d953'),(662,'5ec46a14-9328-4345-bf9e-2a103a14fd9f','1f608503-4867-4253-a143-dd200e0ebe0a'),(662,'5ec46a14-9328-4345-bf9e-2a103a14fd9f','51c81dd7-f872-4092-9a17-d9b3821ed7c8'),(662,'5ec46a14-9328-4345-bf9e-2a103a14fd9f','60a7c19d-824d-4fdf-a109-f3df643a3f1a'),(662,'5ec46a14-9328-4345-bf9e-2a103a14fd9f','8d582d54-5f1f-4ac9-ac0e-a9aa41cc41e1'),(662,'5ec46a14-9328-4345-bf9e-2a103a14fd9f','9319bd6a-6e7d-4505-8090-e4e10e3caec0'),(662,'5ec46a14-9328-4345-bf9e-2a103a14fd9f','9533b2b7-5385-4d5f-8858-b01c1c030817'),(662,'5ec46a14-9328-4345-bf9e-2a103a14fd9f','bc10348b-1c26-48ee-bc8f-6fa5ac933a14'),(662,'5ec46a14-9328-4345-bf9e-2a103a14fd9f','f69344e1-d52d-49da-acc5-b714cb86225d'),(662,'6a667e6c-44c0-4842-8b31-ab3873ddf15b','5c922725-b41b-4e38-a244-6a9a320d291e'),(662,'6a667e6c-44c0-4842-8b31-ab3873ddf15b','675a601d-d389-403d-858d-555ff6166630'),(662,'6a667e6c-44c0-4842-8b31-ab3873ddf15b','b25a25e2-610a-466d-a4d8-7518a09b9a78'),(662,'6a667e6c-44c0-4842-8b31-ab3873ddf15b','e18ed074-c432-415e-b63e-3b73dcb95e72'),(662,'76a19cfc-ee2e-426f-b476-ac85c20f660d','9d5d6282-185b-45e3-8902-11f6f83c2991'),(662,'76a19cfc-ee2e-426f-b476-ac85c20f660d','f6615787-bb2f-4f28-b265-517b66795996'),(662,'7fb08821-81d8-4569-9f19-ef8022fea368','2cff0ba7-eee7-4c7f-99af-34c690eb3868'),(662,'7fb08821-81d8-4569-9f19-ef8022fea368','e22ce6e5-78b3-470f-8eac-fc2668ff13bc'),(662,'8aa64af3-968d-45f4-b276-c5dbd500e07a','144ce692-0397-4de4-aa07-e50e85b5a553'),(662,'8aa64af3-968d-45f4-b276-c5dbd500e07a','22b17811-0494-42ee-a82c-e9e5fe8e4ae4'),(662,'8aa64af3-968d-45f4-b276-c5dbd500e07a','e94bbc94-0540-4634-816e-4a842ced15fa'),(662,'9243b91d-921e-40a3-a88d-f1a14409a45a','13991d0c-102a-4df8-aaad-f5f422edc6be'),(662,'9243b91d-921e-40a3-a88d-f1a14409a45a','1712177a-2d33-429e-81ed-e58b3ec65c4d'),(662,'9243b91d-921e-40a3-a88d-f1a14409a45a','45a97d29-279f-4720-856d-2ef701665f93'),(662,'9243b91d-921e-40a3-a88d-f1a14409a45a','4a84b07a-6e20-4dea-85d3-199cb3adf0f5'),(662,'9243b91d-921e-40a3-a88d-f1a14409a45a','963a8acf-cdb2-41d5-b187-9a7c885ac2a0'),(662,'9243b91d-921e-40a3-a88d-f1a14409a45a','9b87eb98-b2ac-4d29-83ea-5125f3d83710'),(662,'9243b91d-921e-40a3-a88d-f1a14409a45a','a3d56e52-a954-4894-b840-be0425c42658'),(662,'9243b91d-921e-40a3-a88d-f1a14409a45a','c19a9e26-b162-4808-8d10-9d6a38e24e98'),(662,'9243b91d-921e-40a3-a88d-f1a14409a45a','e31677ad-6acd-445e-8577-f3c741a13dc2'),(662,'9243b91d-921e-40a3-a88d-f1a14409a45a','ebf4cbaa-94a5-42c6-aad4-4f61d8ad16b8'),(662,'928854eb-377d-4b8b-8ea6-eeb3057a66b9','1ab759da-dceb-48e2-83be-326054416d3c'),(662,'928854eb-377d-4b8b-8ea6-eeb3057a66b9','41f1c7ba-1d8c-47b9-8ed9-11f004bb7681'),(662,'928854eb-377d-4b8b-8ea6-eeb3057a66b9','dd19221a-2e2b-4f03-9062-62bb291352d2'),(662,'92b54835-b001-4b26-a4eb-900f8c7ebd11','0abfe6c8-8321-4681-9ffd-944418ed370c'),(662,'92b54835-b001-4b26-a4eb-900f8c7ebd11','0fd33c57-ea90-4557-bed0-d59a4b5f2c80'),(662,'92b54835-b001-4b26-a4eb-900f8c7ebd11','2129ad39-4745-4e82-a5b8-dcf7933c6ae7'),(662,'92b54835-b001-4b26-a4eb-900f8c7ebd11','2a2002a5-6321-4c63-938e-7276412e6a28'),(662,'92b54835-b001-4b26-a4eb-900f8c7ebd11','3a8a47b1-96a0-4e8f-a7fa-d5c2f74f3677'),(662,'92b54835-b001-4b26-a4eb-900f8c7ebd11','3f126af5-ce2b-4e13-8fc8-9811ab5d462c'),(662,'92b54835-b001-4b26-a4eb-900f8c7ebd11','48632fc1-3269-4a7f-bdaa-980e30af0358'),(662,'92b54835-b001-4b26-a4eb-900f8c7ebd11','a2156f23-da3f-4a2a-97f3-76ea6c877521'),(662,'92b54835-b001-4b26-a4eb-900f8c7ebd11','a483fb03-0adb-4387-9099-c9c2567855e7'),(662,'92b54835-b001-4b26-a4eb-900f8c7ebd11','a5903ca6-45db-41cc-a262-19592ff5f2e4'),(662,'92b54835-b001-4b26-a4eb-900f8c7ebd11','f574474f-dc28-462d-9251-b23591ca9bcb'),(662,'93c345d1-454a-42fa-bfa7-8d68827d23f5','520242d1-a563-40d8-b43b-1c26fd0f28ff'),(662,'93c345d1-454a-42fa-bfa7-8d68827d23f5','ab2de538-1cbb-481f-a82e-899f47da34b7'),(662,'9c5638bd-fe4f-41c6-a7a7-5c3c908a9555','9d5d6282-185b-45e3-8902-11f6f83c2991'),(662,'9c5638bd-fe4f-41c6-a7a7-5c3c908a9555','f6615787-bb2f-4f28-b265-517b66795996'),(662,'9c8474e3-ae2e-4f02-af12-ee8d56ae6406','06e08af9-0736-40b6-93e5-bdffccb8ea44'),(662,'9c8474e3-ae2e-4f02-af12-ee8d56ae6406','a4f0f4fa-9346-4a75-a1dd-e95c83dc5e6b'),(662,'b43015be-893c-4d0c-8657-1cd6c0eadc67','ebcf2fdf-8f60-4590-bf41-6c7e360d6441'),(662,'b77a9c9d-2d03-4860-b7b9-86e311c509ed','4a35756e-57f1-4f26-a7da-64af3396fbad'),(662,'b77a9c9d-2d03-4860-b7b9-86e311c509ed','bafe042a-2298-470c-8d08-071e0f4e388e'),(662,'bac96ac3-3fbd-4776-96d5-a1fcf7139710','06da4522-e34d-40fd-b96f-ca51c40618cc'),(662,'bac96ac3-3fbd-4776-96d5-a1fcf7139710','6fe553ac-625b-4942-ad10-01bbe5250717'),(662,'c13ba56c-2431-4f83-a199-a713f2029337','689b438f-3633-4981-b669-5e49a97a5c95'),(662,'c13ba56c-2431-4f83-a199-a713f2029337','90d34496-4e10-41d5-b77c-75826f81327e'),(662,'c2d88917-09e1-11ee-b558-229278a3c906','05260ab4-d913-11ed-b558-229278a3c906'),(662,'c2d88917-09e1-11ee-b558-229278a3c906','0527500a-d913-11ed-b558-229278a3c906'),(662,'c2d88917-09e1-11ee-b558-229278a3c906','0d5d836c-d915-11ed-b558-229278a3c906'),(662,'c2d88917-09e1-11ee-b558-229278a3c906','0d5d9857-d915-11ed-b558-229278a3c906'),(662,'c2d88917-09e1-11ee-b558-229278a3c906','8c1eb1f1-d914-11ed-b558-229278a3c906'),(662,'c2d88917-09e1-11ee-b558-229278a3c906','8c1ec753-d914-11ed-b558-229278a3c906'),(662,'c2d88917-09e1-11ee-b558-229278a3c906','c26fa07f-09e1-11ee-b558-229278a3c906'),(662,'c2d88917-09e1-11ee-b558-229278a3c906','dc68fc0d-d914-11ed-b558-229278a3c906'),(662,'c2d88917-09e1-11ee-b558-229278a3c906','dc690efd-d914-11ed-b558-229278a3c906'),(662,'c2d88917-09e1-11ee-b558-229278a3c906','e1c42d91-d915-11ed-b558-229278a3c906'),(662,'c2d88917-09e1-11ee-b558-229278a3c906','e1c443e6-d915-11ed-b558-229278a3c906'),(662,'d3010d97-e435-4fa5-9054-e4add927b37f','6ea3e979-830a-4dd4-81e2-3d30db702b9c'),(662,'d3010d97-e435-4fa5-9054-e4add927b37f','850a1a2e-2e87-4cda-8ec5-a2dcd149731d'),(662,'d3010d97-e435-4fa5-9054-e4add927b37f','b6b42cf7-31c1-49e1-b1d1-c607c7ba299b'),(662,'d3010d97-e435-4fa5-9054-e4add927b37f','c9051630-ef52-45e0-bf72-eef2676192c8'),(662,'de057ea0-5a8b-4969-8ceb-44a19644bb0d','31421697-5459-439e-919b-169d051646f5'),(662,'de057ea0-5a8b-4969-8ceb-44a19644bb0d','60447943-1739-4e3f-aced-0eb015c274a2'),(662,'de057ea0-5a8b-4969-8ceb-44a19644bb0d','9cd5b1c8-ef15-449d-97a1-bdf6947abe78'),(662,'f0e9fe66-4717-4100-b61c-0cac7c9b76c3','07615b33-5390-4fe1-9fbb-9ec7cbd64d40'),(662,'f0e9fe66-4717-4100-b61c-0cac7c9b76c3','5c2ae31f-cf6e-42c8-9d38-6f41e1e8db02'),(662,'f0e9fe66-4717-4100-b61c-0cac7c9b76c3','6918be85-b74b-4069-b2b3-914477ca77ad'),(662,'f0e9fe66-4717-4100-b61c-0cac7c9b76c3','6fa55f91-2e1f-436b-b276-b2726e9125b4'),(662,'f0e9fe66-4717-4100-b61c-0cac7c9b76c3','9210c2bb-cc5b-4ccf-a432-8adf915d5673'),(662,'f0e9fe66-4717-4100-b61c-0cac7c9b76c3','a3ae3378-e8e9-495e-9dc6-8a3be2a9a968'),(662,'f0e9fe66-4717-4100-b61c-0cac7c9b76c3','b01eb471-5baa-4958-b2c6-736eab81754a'),(662,'f0e9fe66-4717-4100-b61c-0cac7c9b76c3','ce7041b4-86ce-4167-b150-b49d4f0008a6'),(662,'f0e9fe66-4717-4100-b61c-0cac7c9b76c3','d5ddb4c9-b9d4-4dbd-91ab-8ba108c565e0'),(662,'f0e9fe66-4717-4100-b61c-0cac7c9b76c3','f06e433d-c712-4081-adba-9051f0c10c4e');
/*!40000 ALTER TABLE `SentAttachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SentMessage`
--

DROP TABLE IF EXISTS `SentMessage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SentMessage` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `discussionId` varchar(36) NOT NULL,
  `subject` varchar(45) NOT NULL,
  `body` text,
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `discussionId` (`discussionId`,`ownerId`),
  CONSTRAINT `SentMessage_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `SentMessage_ibfk_2` FOREIGN KEY (`discussionId`, `ownerId`) REFERENCES `Discussion` (`uuid`, `ownerId`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SentMessage`
--

LOCK TABLES `SentMessage` WRITE;
/*!40000 ALTER TABLE `SentMessage` DISABLE KEYS */;
INSERT INTO `SentMessage` VALUES ('0044629b-c48a-4f47-95b1-f178384b2b25',662,'cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','#','SMILERS n° 1.19.3.S1','2022-11-02 18:43:34.000',NULL,'2022-11-02 18:43:34.000','2023-06-13 12:02:23.237','2023-06-13 14:02:23.237'),('092ae2c6-d903-11ed-9278-00d86184ce0e',662,'cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','#','Commande n° 1.21.8.S1','2023-04-12 09:24:24.000',NULL,'2023-04-12 09:24:24.000','2023-04-12 07:24:24.620','2023-04-12 09:24:24.620'),('0fc3bc59-0e74-46f1-9d1b-4edee6fffcc3',662,'cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','#','SMILERS n° 1.21.2.S1','2022-06-27 21:35:56.000',NULL,'2022-06-27 21:35:56.000','2022-06-27 19:35:56.000','2022-06-27 21:35:56.000'),('18cb70e0-eb87-4a95-b5d9-b5e39616e0e8',662,'ac9d94b7-3541-4923-a2a8-fe429c22fbab','#','#','2020-04-30 20:26:55.000',NULL,'2020-04-30 20:26:55.000','2020-04-30 18:44:40.000','2020-04-30 20:44:40.000'),('23ab56bc-8ef1-4eb4-92c0-3f4eb41aa456',662,'cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','#','SMILERS n° 1.19.1.S1','2021-09-27 14:02:15.000',NULL,'2021-09-27 14:02:15.000','2021-09-27 12:02:21.000','2021-09-27 14:02:21.000'),('2ac5c4e8-2400-4099-bdff-66744db946c7',662,'cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','#','SMILERS n° 1.20.1.S1','2021-10-12 14:40:28.000',NULL,'2021-10-12 14:40:28.000','2023-06-13 12:02:22.576','2023-06-13 14:02:22.576'),('2d372f67-16da-4c22-a951-9f22b14b8a00',662,'ac9d94b7-3541-4923-a2a8-fe429c22fbab','#','Commande n° 1.10.1.2','2020-05-01 08:23:30.000',NULL,'2020-05-01 08:23:30.000','2020-05-01 06:23:31.000','2020-05-01 08:23:31.000'),('41ad7d4a-f203-41dd-a78f-61f850f52110',662,'ac9d94b7-3541-4923-a2a8-fe429c22fbab','#','Commande n° 1.10.1.3','2020-05-01 08:31:26.000',NULL,'2020-05-01 08:31:26.000','2020-05-01 06:31:27.000','2020-05-01 08:31:27.000'),('465925b7-af46-4fc1-9b89-8f9ef2a8753b',662,'ac9d94b7-3541-4923-a2a8-fe429c22fbab','#','Commande n° 1.5.1.3','2020-04-10 09:20:48.000',NULL,'2020-04-10 09:20:48.000','2020-04-10 07:27:05.000','2020-04-10 09:27:05.000'),('5c3a887b-5354-4dce-a930-c0bf04c73c86',662,'cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','#','Commande n° 1.7.2.2','2020-04-15 08:51:44.000',NULL,'2020-04-15 08:51:44.000','2023-06-13 12:02:22.090','2023-06-13 14:02:22.090'),('5d7fb378-e627-43df-a59e-10bf6266bc54',662,'cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','#','SMILERS n° 1.21.1.S1','2021-11-22 12:51:40.000',NULL,'2021-11-22 12:51:40.000','2021-11-22 11:51:41.000','2021-11-22 12:51:41.000'),('5ec46a14-9328-4345-bf9e-2a103a14fd9f',662,'ac9d94b7-3541-4923-a2a8-fe429c22fbab','#','Commande n° 1.10.1.1','2020-04-30 20:27:47.000',NULL,'2020-04-30 20:27:47.000','2020-04-30 18:44:40.000','2020-04-30 20:44:40.000'),('6a667e6c-44c0-4842-8b31-ab3873ddf15b',662,'cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','#','Commande n° 1.6.1.1','2020-04-17 07:56:49.000',NULL,'2020-04-17 07:56:49.000','2023-06-13 12:02:22.261','2023-06-13 14:02:22.261'),('76a19cfc-ee2e-426f-b476-ac85c20f660d',662,'cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','#','Test','2020-04-12 08:17:04.000',NULL,'2020-04-12 08:17:04.000','2020-04-13 05:32:16.000','2020-04-13 07:32:16.000'),('7fb08821-81d8-4569-9f19-ef8022fea368',662,'cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','#','SMILERS n° 1.20.2.S1','2022-08-06 13:59:36.000',NULL,'2022-08-06 13:59:36.000','2022-08-06 11:59:41.000','2022-08-06 13:59:41.000'),('8aa64af3-968d-45f4-b276-c5dbd500e07a',662,'ac9d94b7-3541-4923-a2a8-fe429c22fbab','#','Commande n° 1.5.3.1','2020-07-13 19:47:49.000',NULL,'2020-07-13 19:47:49.000','2020-07-13 17:47:50.000','2020-07-13 19:47:50.000'),('9243b91d-921e-40a3-a88d-f1a14409a45a',662,'cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','#','SMILERS n° 1.22.1.S1','2021-11-23 12:24:37.000',NULL,'2021-11-23 12:24:37.000','2021-11-23 11:24:44.000','2021-11-23 12:24:44.000'),('928854eb-377d-4b8b-8ea6-eeb3057a66b9',662,'2b95263d-2fff-42df-8b92-6a30e3bdc543','#','Commande n° 1.28.1.1','2023-04-12 06:41:30.000',NULL,'2023-04-12 06:41:30.000','2023-04-12 04:41:30.634','2023-04-12 06:41:30.634'),('92b54835-b001-4b26-a4eb-900f8c7ebd11',662,'cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','#','Commande n° 1.7.2.1','2020-04-15 08:27:54.000',NULL,'2020-04-15 08:27:54.000','2023-06-13 12:02:21.950','2023-06-13 14:02:21.950'),('93c345d1-454a-42fa-bfa7-8d68827d23f5',662,'cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','#','SMILERS n° 1.19.4.S1','2023-03-21 12:31:04.000',NULL,'2023-03-21 12:31:04.000','2023-03-21 11:31:05.000','2023-03-21 12:31:05.000'),('9c5638bd-fe4f-41c6-a7a7-5c3c908a9555',662,'cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','#','#','2020-04-12 08:29:34.000',NULL,'2020-04-12 08:29:34.000','2020-04-13 05:32:16.000','2020-04-13 07:32:16.000'),('9c8474e3-ae2e-4f02-af12-ee8d56ae6406',662,'cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','#','SMILERS n° 1.19.2.S1','2022-06-28 20:41:05.000',NULL,'2022-06-28 20:41:05.000','2022-06-28 18:41:11.000','2022-06-28 20:41:11.000'),('b43015be-893c-4d0c-8657-1cd6c0eadc67',662,'cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','#','Commande n° 1.2.3.1','2020-04-12 08:28:41.000',NULL,'2020-04-12 08:28:41.000','2020-04-13 05:32:17.000','2020-04-13 07:32:17.000'),('b77a9c9d-2d03-4860-b7b9-86e311c509ed',662,'cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','#','SMILERS n° 1.21.3.S1','2022-09-14 12:25:44.000',NULL,'2022-09-14 12:25:44.000','2022-09-14 10:25:51.000','2022-09-14 12:25:51.000'),('bac96ac3-3fbd-4776-96d5-a1fcf7139710',662,'cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','#','SMILERS n° 1.21.7.S1','2023-01-11 13:47:49.000',NULL,'2023-01-11 13:47:49.000','2023-01-11 12:47:52.000','2023-01-11 13:47:52.000'),('c13ba56c-2431-4f83-a199-a713f2029337',662,'cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','#','SMILERS n° 1.21.6.S1','2022-12-21 12:18:08.000',NULL,'2022-12-21 12:18:08.000','2022-12-21 11:18:10.000','2022-12-21 12:18:10.000'),('c2d88917-09e1-11ee-b558-229278a3c906',662,'c2d723cd-09e1-11ee-b558-229278a3c906','#','Commande n° 1.23.2.1','2023-06-13 13:59:35.000',NULL,'2023-06-13 13:59:35.000','2023-06-13 11:59:37.548','2023-06-13 13:59:37.548'),('d3010d97-e435-4fa5-9054-e4add927b37f',662,'cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','#','SMILERS n° 1.21.4.S1','2022-11-04 12:40:18.000',NULL,'2022-11-04 12:40:18.000','2023-06-13 12:02:23.353','2023-06-13 14:02:23.353'),('de057ea0-5a8b-4969-8ceb-44a19644bb0d',662,'cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','#','Commande n° 1.2.2.2','2020-04-13 07:59:28.000',NULL,'2020-04-13 07:59:28.000','2020-04-13 05:59:31.000','2020-04-13 07:59:31.000'),('f0e9fe66-4717-4100-b61c-0cac7c9b76c3',662,'cf6d3b31-bab1-473f-a635-3b2ab68a1bfa','#','SMILERS n° 1.23.1.S1','2022-01-11 12:43:41.000',NULL,'2022-01-11 12:43:41.000','2022-01-11 11:43:43.000','2022-01-11 12:43:43.000');
/*!40000 ALTER TABLE `SentMessage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SentOrderNotification`
--

DROP TABLE IF EXISTS `SentOrderNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SentOrderNotification` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `recipientId` varchar(36) DEFAULT NULL,
  `rescueData` text,
  `deliveryDate` datetime(3) DEFAULT NULL,
  `event` enum('EDITED','VALIDATED','CANCELLED') NOT NULL DEFAULT 'EDITED',
  `unread` tinyint(1) NOT NULL DEFAULT '1',
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `orderId` (`orderId`),
  KEY `recipientId` (`recipientId`),
  CONSTRAINT `SentOrderNotification_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `SentOrderNotification_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `ProstheticOrder` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `SentOrderNotification_ibfk_3` FOREIGN KEY (`recipientId`) REFERENCES `Contact` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SentOrderNotification`
--

LOCK TABLES `SentOrderNotification` WRITE;
/*!40000 ALTER TABLE `SentOrderNotification` DISABLE KEYS */;
INSERT INTO `SentOrderNotification` VALUES ('686c25a2-2a5b-4d43-a61f-c19e145c6e63',662,'63706c26-d501-4c56-bdc2-ab2c76f6d988','e65a3983-26d3-437e-9f3a-9ec54fa23fbe','{\"recipientDisplayName\":\"Michael Maylin\",\"patientDisplayID\":\"1.10\",\"orderTitle\":\"AUTRE FICHE PROTH\\u00c9TIQUE\",\"sheetType\":\"OTHER\"}','2020-05-09 12:00:00.000','VALIDATED',0,'2020-05-02 21:58:19.000',NULL,'2023-04-12 04:41:32.976','2023-04-12 06:41:32.976'),('84483bc1-ebfc-4b69-b772-670a1a24ceda',662,'b1c50855-9551-467e-94d9-915a6218ec1b','e65a3983-26d3-437e-9f3a-9ec54fa23fbe','{\"recipientDisplayName\":\"Michael Maylin\",\"patientDisplayID\":\"1.5\",\"orderTitle\":\"GOUTTI\\u00c8RE\",\"sheetType\":\"GOUTTIERE\"}','2020-07-27 12:00:00.000','VALIDATED',0,'2020-07-15 23:04:22.000',NULL,'2020-09-09 17:44:24.000','2020-09-09 19:44:24.000'),('f507cf26-e77b-403d-a779-ec8aa5a6f114',662,'eb120496-ad30-4640-856b-fbdd1139c529','e65a3983-26d3-437e-9f3a-9ec54fa23fbe','{\"recipientDisplayName\":\"Michael Maylin\",\"patientDisplayID\":\"1.5\",\"orderTitle\":\"ODF\",\"sheetType\":\"ODF\"}','2020-04-11 00:00:01.000','VALIDATED',0,'2020-04-10 09:29:08.000',NULL,'2020-04-12 05:51:30.000','2020-04-12 07:51:30.000');
/*!40000 ALTER TABLE `SentOrderNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Session`
--

DROP TABLE IF EXISTS `Session`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Session` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL,
  `actId` varchar(36) NOT NULL,
  `displayId` mediumint unsigned DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `comments` text,
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `actId` (`actId`),
  CONSTRAINT `Session_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `Session_ibfk_2` FOREIGN KEY (`actId`) REFERENCES `Act` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Session`
--

LOCK TABLES `Session` WRITE;
/*!40000 ALTER TABLE `Session` DISABLE KEYS */;
INSERT INTO `Session` VALUES ('02bb64b6-8c8d-4a83-8015-e492bca9eef9',662,'72c58d79-1141-4c63-b343-909886db5520',2,0,'Sous dossier 2','2020-04-27 16:48:57.000','2023-04-12 06:40:03.000','2020-04-27 16:48:57.000','2023-06-13 12:02:08.104','2023-06-13 14:02:08.104'),('05d9d2c1-1f20-4354-a592-64635302fe66',662,'2a050d02-7424-4099-b1d0-2d7da678e690',5,0,'Sous dossier 5','2022-12-14 17:39:21.000',NULL,'2022-12-14 17:39:20.000','2023-06-13 12:02:08.032','2023-06-13 14:02:08.032'),('06abdb47-7e29-4e95-9502-9d46516a1b3e',662,'87965ef8-01eb-4830-8e8b-8b99ece62cf1',2,0,'Sous dossier 2','2022-06-27 21:27:19.000',NULL,'2022-06-27 21:27:18.000','2023-06-13 12:02:07.359','2023-06-13 14:02:07.359'),('09f15124-6bba-4565-bfe4-efb3c6c3a17d',662,'e43c8099-0862-42c3-9ad2-1efef27b83ba',1,0,'Sous dossier 1','2022-09-14 12:00:30.000',NULL,'2022-09-14 12:23:55.000','2023-06-13 12:02:07.384','2023-06-13 14:02:07.384'),('0c7a1791-2e32-4203-90d5-5b8c008be303',662,'47a8d99f-668b-4bb6-b3bf-7bff221d397f',2,0,'Sous dossier 2','2020-04-16 10:42:19.000','2023-04-12 06:40:03.000','2020-04-16 10:42:18.000','2023-06-13 12:02:08.112','2023-06-13 14:02:08.112'),('0e9f7103-7fec-4143-b69a-773b4bf0d88e',662,'ec084612-67a2-4430-ae15-7fe0edeaca64',5,0,'Sous dossier 5','2020-04-14 11:25:15.000','2023-04-12 06:40:03.000','2020-04-14 11:25:14.000','2023-06-13 12:02:08.121','2023-06-13 14:02:08.121'),('10ddc224-efea-4e4a-8b51-1a76343500fb',662,'ec084612-67a2-4430-ae15-7fe0edeaca64',4,0,'Sous dossier 4','2020-04-13 07:32:15.000','2023-04-12 06:40:03.000','2020-04-12 08:26:54.000','2023-06-13 12:02:08.128','2023-06-13 14:02:08.128'),('12115366-8eb9-470b-a097-5d28bb5fdf38',662,'7841125a-11dd-4b66-9179-cd371ea2f0f7',1,0,'Sous dossier 1','2022-01-11 12:05:44.000',NULL,'2022-01-11 12:41:15.000','2023-06-13 12:02:07.327','2023-06-13 14:02:07.327'),('138fb819-9955-48f9-b4d4-5cd401004cf3',662,'64834083-3320-4687-9710-c2be0d9c7198',4,0,'Sous dossier 4','2020-04-30 20:26:01.000',NULL,'2020-04-30 20:26:01.000','2023-06-13 12:02:07.105','2023-06-13 14:02:07.105'),('16aaa3c4-a2c1-4311-9284-3a3e3bcb1e8c',662,'72b7a457-e38f-4535-8eba-6c98b43e5e55',1,0,'Sous dossier 1','2021-06-08 19:49:48.000',NULL,'2021-06-08 20:56:54.000','2023-06-13 12:02:07.287','2023-06-13 14:02:07.287'),('1a616ac1-2ca3-4d23-ae5e-349558c26c37',662,'801b987d-e335-4276-8bc6-1fa57b553716',1,0,'Sous dossier 1','2020-04-11 07:23:52.000',NULL,'2020-07-13 19:51:37.000','2023-06-13 12:02:07.185','2023-06-13 14:02:07.185'),('1ec1f707-d702-496a-b2f0-e55b08c06dcb',662,'c47ee4d9-c646-4836-8152-fc2ded70b4fe',1,0,'Sous dossier 1','2021-02-01 20:10:36.000',NULL,'2021-02-01 21:23:41.000','2023-06-13 12:02:07.252','2023-06-13 14:02:07.252'),('20a5abad-ea33-4348-bb3a-69c66c38759b',662,'acce421f-f39c-414a-a216-6f01af8c33c4',1,0,'Sous dossier 1','2022-06-10 20:22:14.000','2022-06-27 21:12:46.000','2022-06-10 20:22:14.000','2022-06-27 19:12:46.000',NULL),('20b31e3a-565c-49b0-b2ff-0dae86b25c76',662,'1b1f827a-e4fa-4f16-8fd1-8cbdaa85c91e',1,0,'Sous dossier 1','2022-09-19 10:52:10.000',NULL,'2022-09-19 11:48:35.000','2023-06-13 12:02:07.392','2023-06-13 14:02:07.392'),('24774ba0-9e7c-4a7b-acdb-bb756c33e9af',662,'801b987d-e335-4276-8bc6-1fa57b553716',4,0,'Sous dossier 4','2020-07-13 19:50:52.000',NULL,'2020-07-13 19:50:51.000','2023-06-13 12:02:07.160','2023-06-13 14:02:07.160'),('24a336d6-8f49-456f-8160-b0e6ecc31cbd',662,'b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c',2,0,'Sous dossier 2','2020-12-29 11:57:42.000',NULL,'2020-12-29 11:48:10.000','2023-06-13 12:02:07.204','2023-06-13 14:02:07.204'),('254f3fc9-4782-4658-bb34-f2ca1c9b6382',662,'a7b0f1ae-ce37-4faf-9b3c-e5fab6996549',1,0,'Sous dossier 1','2020-05-21 07:47:55.000',NULL,'2020-05-21 08:13:17.000','2023-06-13 12:02:07.120','2023-06-13 14:02:07.120'),('27120228-09e3-11ee-b558-229278a3c906',662,'270ecdfc-09e3-11ee-b558-229278a3c906',1,0,'','2023-06-13 14:09:31.278','2023-06-13 14:09:40.295','2023-06-13 14:09:31.281','2023-06-13 12:09:40.296','2023-06-13 14:09:40.307'),('296c061e-734b-4936-8af7-1f80653eff11',662,'7813c59a-91e7-4c2c-8027-bcc3c35c797c',1,0,'Sous dossier 1','2020-04-06 11:13:10.000',NULL,'2020-04-08 08:50:09.000','2023-06-13 12:02:07.008','2023-06-13 14:02:07.008'),('2ac47a50-77d4-4d5e-8baf-71e2882b89bc',662,'2a050d02-7424-4099-b1d0-2d7da678e690',4,0,'Sous dossier 4','2022-12-14 17:39:03.000',NULL,'2022-12-14 17:39:01.000','2023-06-13 12:02:08.025','2023-06-13 14:02:08.025'),('2b934532-4b04-4025-8e7f-894c9c01b184',662,'cb9d8495-b4dd-423f-a624-7cff70e4db55',3,0,'Sous dossier 3','2020-04-07 07:10:59.000','2023-04-12 06:40:03.000','2020-04-07 10:19:43.000','2023-06-13 12:02:08.137','2023-06-13 14:02:08.137'),('2ed4960a-e6fa-46de-a306-32385df3346c',662,'ec084612-67a2-4430-ae15-7fe0edeaca64',2,0,'Sous dossier 2','2020-04-13 07:32:15.000','2023-04-12 06:40:03.000','2020-04-14 11:25:42.000','2023-06-13 12:02:08.145','2023-06-13 14:02:08.145'),('31210683-bc06-4b84-83d9-ce60f32308e4',662,'b498bdf4-2e5b-497a-8bfe-b65edabac3bc',1,0,'Sous dossier 1','2021-11-23 11:57:24.000',NULL,'2021-11-23 12:23:17.000','2023-06-13 12:02:07.319','2023-06-13 14:02:07.319'),('348477f7-c7a9-4bb3-8b28-3da592902286',662,'100a15d0-4590-4544-9331-365a087a5b57',1,0,'Sous dossier 1','2020-04-29 14:25:46.000',NULL,'2020-04-29 14:50:37.000','2023-06-13 12:02:07.080','2023-06-13 14:02:07.080'),('37da7c96-1d18-41f2-aa42-58d6c1c09fa8',662,'1ce80886-d3f3-42d8-872a-a2eba69d0005',4,0,'Sous dossier 4','2020-04-16 10:40:41.000','2023-04-12 06:40:04.000','2020-04-16 10:40:40.000','2023-06-13 12:02:08.153','2023-06-13 14:02:08.153'),('3d8aaee3-2fbd-43cd-8404-58e3f043e115',662,'7813c59a-91e7-4c2c-8027-bcc3c35c797c',3,0,'Sous dossier 3','2020-04-08 08:50:18.000',NULL,'2020-04-08 08:51:36.000','2023-06-13 12:02:07.020','2023-06-13 14:02:07.020'),('3dc7ad32-46c5-4609-9e85-6caf219fd0e4',662,'2a050d02-7424-4099-b1d0-2d7da678e690',3,0,'Sous dossier 3','2022-12-14 15:05:03.000',NULL,'2022-12-14 15:05:01.000','2023-06-13 12:02:08.016','2023-06-13 14:02:08.016'),('3f054759-67f1-4946-baff-769847612456',662,'2a050d02-7424-4099-b1d0-2d7da678e690',7,0,'Sous dossier 7','2022-12-14 17:39:33.000',NULL,'2022-12-14 17:39:32.000','2023-06-13 12:02:08.049','2023-06-13 14:02:08.049'),('45c9a361-1434-40a0-be6c-21b8daa71eb4',662,'64834083-3320-4687-9710-c2be0d9c7198',3,0,'Sous dossier 3','2020-04-30 20:26:00.000',NULL,'2020-04-30 20:26:00.000','2023-06-13 12:02:07.096','2023-06-13 14:02:07.096'),('470b4b2e-2db4-4a3d-8ea0-949ea7220994',662,'cb9d8495-b4dd-423f-a624-7cff70e4db55',2,0,'Sous dossier 2','2020-04-07 07:05:32.000','2020-04-07 07:11:56.000','2020-04-07 07:05:32.000','2023-06-13 12:02:06.992','2023-06-13 14:02:06.992'),('484ae4d8-329f-49b5-8d83-312a8a92ff22',662,'f474819e-9470-4612-8275-2ceb25b5522f',1,0,'Sous dossier 1','2021-02-27 09:56:56.000',NULL,'2021-02-27 10:59:00.000','2023-06-13 12:02:07.269','2023-06-13 14:02:07.269'),('4af4bd2d-76e3-4905-99fd-191c4cc669fa',662,'d458682a-423b-43fe-a4b0-97d586104341',1,0,'Sous dossier 1','2020-04-09 09:16:48.000','2023-04-12 06:40:04.000','2020-04-09 11:05:50.000','2023-06-13 12:02:08.161','2023-06-13 14:02:08.161'),('4b27d300-e0f9-4687-9c78-cf06a8ed4fd5',662,'47a8d99f-668b-4bb6-b3bf-7bff221d397f',3,0,'Sous dossier 3','2020-04-16 10:42:22.000','2023-04-12 06:40:04.000','2020-04-16 10:42:21.000','2023-06-13 12:02:08.169','2023-06-13 14:02:08.169'),('4e3d8e8e-3904-46c2-af39-ee76eb907fdf',662,'8f3d7d42-f6ad-4e48-8951-08222c212e7e',3,0,'Sous dossier 3','2022-12-14 14:59:44.000',NULL,'2022-11-04 13:30:41.000','2023-06-13 12:02:07.981','2023-06-13 14:02:07.981'),('4e5ca0c8-d316-48f6-9ca8-3570b053c100',662,'8f3d7d42-f6ad-4e48-8951-08222c212e7e',4,0,'Sous dossier 4','2022-12-14 14:59:45.000',NULL,'2022-11-04 13:30:46.000','2023-06-13 12:02:07.990','2023-06-13 14:02:07.990'),('52372fba-991e-4b09-abce-2195e775fd19',662,'3d2141bb-462c-4334-b177-d17d136574ae',1,0,'Sous dossier 1','2021-11-22 12:11:02.000',NULL,'2021-11-22 12:49:43.000','2023-06-13 12:02:07.311','2023-06-13 14:02:07.311'),('53a17fdc-5de8-45aa-a9cb-ebea4886f6ff',662,'c61cdb9c-543c-4809-952c-b65656e1f96f',1,0,'Sous dossier 1','2020-07-13 19:07:32.000',NULL,'2020-07-08 19:59:48.000','2023-06-13 12:02:07.129','2023-06-13 14:02:07.129'),('5780d440-00be-4c16-85e3-e49c262c4329',662,'934f20d2-7444-4367-89e2-61c3bf4bee57',2,0,'Sous dossier 2','2020-07-13 19:49:36.000',NULL,'2020-07-13 19:49:36.000','2023-06-13 12:02:07.145','2023-06-13 14:02:07.145'),('5bd97219-8b9e-46f5-ab9b-87ded07aa8a2',662,'8f3d7d42-f6ad-4e48-8951-08222c212e7e',1,0,'Sous dossier 1','2022-11-04 12:37:12.000',NULL,'2022-11-04 12:34:44.000','2023-06-13 12:02:07.964','2023-06-13 14:02:07.964'),('5f895907-3eed-4aa7-995a-f7e1c9661a0a',662,'8f87b136-cb98-4706-b7d4-51059e1afa06',1,0,'Sous dossier 1','2022-03-11 09:55:06.000',NULL,'2022-03-11 11:16:26.000','2023-06-13 12:02:07.335','2023-06-13 14:02:07.335'),('6c6bb813-840d-454a-ab1d-9232434a4500',662,'0c1ed331-8df6-482e-8dd1-508d9b190c49',1,0,'Sous dossier 1','2021-09-27 13:56:28.000',NULL,'2021-09-27 12:50:13.000','2023-06-13 12:02:07.297','2023-06-13 14:02:07.297'),('78636467-a73b-4270-8bc5-35a2664dec9d',662,'ec084612-67a2-4430-ae15-7fe0edeaca64',1,0,'Sous dossier 1','2020-04-12 08:05:53.000','2023-04-12 06:40:04.000','2020-04-14 11:25:35.000','2023-06-13 12:02:08.177','2023-06-13 14:02:08.177'),('7c0ac6ee-9ee9-4b2e-982d-7e55a2e8b52a',662,'1ce80886-d3f3-42d8-872a-a2eba69d0005',3,0,'Sous dossier 3','2020-04-15 07:13:14.000','2023-04-12 06:40:04.000','2020-04-15 07:13:13.000','2023-06-13 12:02:08.185','2023-06-13 14:02:08.185'),('844c8213-74c4-4586-a8b8-1a0166bbd2f2',662,'78fbbe11-e1a5-4c10-b6e3-4f00df178dc6',2,0,'Sous dossier 2','2020-04-16 07:16:44.000','2023-04-12 06:40:04.000','2020-04-16 07:16:43.000','2023-06-13 12:02:08.196','2023-06-13 14:02:08.196'),('86af9a1e-ac57-479e-b67e-5429fbdf4230',662,'c584a5e1-b7d4-4486-abbc-954717a6fe55',1,0,'Sous dossier 1','2020-09-09 19:35:44.000','2023-04-12 06:40:04.000','2020-09-09 19:43:59.000','2023-06-13 12:02:08.204','2023-06-13 14:02:08.204'),('86e2a9c2-c972-477a-9078-284c53a1371f',662,'2c78d514-95bd-4529-b0a1-babfb83849b1',2,0,'Sous dossier 2','2023-01-11 12:43:10.000','2023-01-11 12:46:56.000','2023-01-11 12:43:10.000','2023-01-11 11:46:56.000',NULL),('87507617-fa26-4710-be71-46af136406a7',662,'b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c',3,0,'Sous dossier 3','2020-12-29 11:57:42.000',NULL,'2020-12-29 11:50:26.000','2023-06-13 12:02:07.212','2023-06-13 14:02:07.212'),('88170486-b19f-4c31-a435-e67fd24917e9',662,'c42cadf5-5f0e-439e-9aab-087940794316',1,0,'Sous dossier 1','2020-12-29 08:32:55.000','2020-12-30 07:52:28.000','2020-12-29 08:34:38.000','2020-12-30 06:52:28.000',NULL),('8d012545-b857-4595-a69d-1a2b1c750e13',662,'72c58d79-1141-4c63-b343-909886db5520',1,0,'Sous dossier 1','2020-04-27 16:14:06.000','2023-04-12 06:40:05.000','2020-04-27 16:48:49.000','2023-06-13 12:02:08.215','2023-06-13 14:02:08.215'),('8f1f6878-100c-4a92-9c6a-ff59dc6f939d',662,'64834083-3320-4687-9710-c2be0d9c7198',2,0,'Sous dossier 2','2020-04-30 20:24:56.000',NULL,'2020-04-30 20:24:56.000','2023-06-13 12:02:07.089','2023-06-13 14:02:07.089'),('93eafd8d-603b-44ec-9e98-f87abc4e3bd8',662,'2c78d514-95bd-4529-b0a1-babfb83849b1',3,0,'Sous dossier 3','2023-01-11 13:42:17.000',NULL,'2023-01-11 12:59:12.000','2023-06-13 12:02:08.077','2023-06-13 14:02:08.077'),('949aa0c7-aadb-440d-bb4c-c18dbb342fe6',662,'934f20d2-7444-4367-89e2-61c3bf4bee57',3,0,'Sous dossier 3','2020-07-13 19:49:37.000',NULL,'2020-07-13 19:49:36.000','2023-06-13 12:02:07.152','2023-06-13 14:02:07.152'),('96e43a62-294d-4726-8ccf-ea4ec6e66267',662,'2e7abd17-bdd5-4ead-9751-b6d90fb9e0ea',1,0,'Sous dossier 1','2021-06-08 19:43:34.000',NULL,'2021-04-25 11:28:19.000','2023-06-13 12:02:07.277','2023-06-13 14:02:07.277'),('983c39b6-656b-4bf2-bf43-da1625adb861',662,'2c78d514-95bd-4529-b0a1-babfb83849b1',1,0,'Sous dossier 1','2023-01-11 12:11:37.000',NULL,'2023-01-11 12:58:29.000','2023-06-13 12:02:08.086','2023-06-13 14:02:08.086'),('98b0c97c-d902-11ed-9278-00d86184ce0e',662,'98ada573-d902-11ed-9278-00d86184ce0e',1,0,'','2023-04-12 09:21:09.000','2023-04-12 09:21:39.000','2023-04-12 09:21:09.326','2023-06-13 12:02:08.317','2023-06-13 14:02:08.317'),('990c202c-5ab6-480a-85f6-63e46eba8c67',662,'ec084612-67a2-4430-ae15-7fe0edeaca64',3,0,'Sous dossier 3','2020-04-12 08:10:12.000','2023-04-12 06:40:05.000','2020-04-12 08:07:55.000','2023-06-13 12:02:08.225','2023-06-13 14:02:08.225'),('9e007066-06fd-4fa1-a49a-f1165de95f83',662,'c983b946-e304-49a8-99c8-24eaca67b9ce',1,0,'Sous dossier 1','2023-04-11 19:34:32.000',NULL,'2023-04-11 20:49:14.000','2023-06-13 12:02:08.233','2023-06-13 14:02:08.233'),('9e543e2b-2acf-48cd-8b05-91154a50192e',662,'73abb1bd-08d2-44e7-866f-eeb3e4b59703',1,0,'Sous dossier 1','2020-04-06 09:37:05.000','2023-04-12 06:40:05.000','2020-04-06 09:37:03.000','2023-06-13 12:02:08.241','2023-06-13 14:02:08.241'),('a18ca6df-d765-4c6a-be28-13abd1c350af',662,'bb2e4d25-46eb-48d2-80af-41639e464a04',2,0,'Sous dossier 2','2020-04-17 10:50:07.000',NULL,'2020-04-17 11:21:05.000','2023-06-13 12:02:07.061','2023-06-13 14:02:07.061'),('a5b53be0-2545-4313-88b5-fccc26f75f7d',662,'2a050d02-7424-4099-b1d0-2d7da678e690',8,0,'Sous dossier 8','2022-12-14 17:39:34.000',NULL,'2022-12-14 17:39:33.000','2023-06-13 12:02:08.060','2023-06-13 14:02:08.060'),('a5bc2d6f-0248-466f-a10b-08f5391fd12f',662,'2a050d02-7424-4099-b1d0-2d7da678e690',1,0,'Sous dossier 1','2022-12-14 14:59:54.000',NULL,'2022-11-04 13:46:23.000','2023-06-13 12:02:08.008','2023-06-13 14:02:08.008'),('a62ebb05-d910-11ed-b558-229278a3c906',662,'a62b9800-d910-11ed-b558-229278a3c906',1,0,'','2023-04-12 11:01:44.000',NULL,'2023-04-12 11:01:44.917','2023-06-13 12:02:08.326','2023-06-13 14:02:08.326'),('a647b404-de82-4017-b5d6-c98df78e9640',662,'ec084612-67a2-4430-ae15-7fe0edeaca64',6,0,'Sous dossier 6','2020-04-14 11:26:30.000','2023-04-12 06:40:05.000','2020-04-14 11:26:30.000','2023-06-13 12:02:08.249','2023-06-13 14:02:08.249'),('ada38401-e257-4f32-8319-c7a394ce4463',662,'934f20d2-7444-4367-89e2-61c3bf4bee57',1,0,'Sous dossier 1','2020-04-10 07:27:57.000',NULL,'2020-07-13 19:48:57.000','2023-06-13 12:02:07.136','2023-06-13 14:02:07.136'),('b29b47d4-35f8-427d-9cd7-a393e48be2cf',662,'7e359a5f-1756-4ec7-8657-3e5940ae489d',1,0,'Sous dossier 1','2021-10-12 14:26:31.000',NULL,'2021-10-12 12:44:17.000','2023-06-13 12:02:07.304','2023-06-13 14:02:07.304'),('b5b4db66-f433-46fb-b794-d632b8fe8e1d',662,'129a6c33-3cca-43ab-b97a-56d0e82a546f',1,0,'Sous dossier 1','2022-11-02 13:55:41.000',NULL,'2022-11-02 12:36:21.000','2023-06-13 12:02:07.400','2023-06-13 14:02:07.400'),('b87f1382-55d4-4e52-b63a-6f387df18b16',662,'b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c',1,0,'Sous dossier 1','2020-12-29 11:57:41.000',NULL,'2020-12-30 07:12:46.000','2023-06-13 12:02:07.245','2023-06-13 14:02:07.245'),('ba7da56a-5a10-4378-a887-8e98aa892a3c',662,'848b25bd-90a8-4105-871d-f9326fe94c7b',1,0,'Sous dossier 1','2022-12-21 11:45:17.000',NULL,'2022-12-21 12:14:32.000','2023-06-13 12:02:08.069','2023-06-13 14:02:08.069'),('bb711dc3-11c1-44a8-96df-a5fb875eade5',662,'f60bef39-641f-45a5-835c-4e84590668e4',1,0,'Sous dossier 1','2020-12-29 11:57:43.000',NULL,'2020-12-29 08:48:53.000','2023-06-13 12:02:07.220','2023-06-13 14:02:07.220'),('bb93f779-b9ac-49e3-b8d2-1de80d351081',662,'2a050d02-7424-4099-b1d0-2d7da678e690',6,0,'Sous dossier 6','2022-12-14 17:39:30.000',NULL,'2022-12-14 17:39:25.000','2023-06-13 12:02:08.041','2023-06-13 14:02:08.041'),('bc9ac093-048f-4390-9ef4-2e651b3cefeb',662,'2a050d02-7424-4099-b1d0-2d7da678e690',2,0,'Sous dossier 2','2022-12-14 14:59:53.000',NULL,'2022-11-04 16:18:20.000','2023-06-13 12:02:07.998','2023-06-13 14:02:07.998'),('bdf42f40-5a7a-435b-a5e0-eb33efefbc97',662,'bb2e4d25-46eb-48d2-80af-41639e464a04',1,0,'Sous dossier 1','2020-04-10 07:52:36.000',NULL,'2020-04-17 07:55:26.000','2023-06-13 12:02:07.053','2023-06-13 14:02:07.053'),('becee89b-0c0c-4888-bd78-43480d883b03',662,'83306c87-ca0d-4ed2-b376-4227f586001f',1,0,'Sous dossier 1','2020-12-29 11:57:44.000',NULL,'2020-12-21 18:19:59.000','2023-06-13 12:02:07.236','2023-06-13 14:02:07.236'),('bef02815-bbf7-4520-882b-2396474f4bb3',662,'1ce80886-d3f3-42d8-872a-a2eba69d0005',2,0,'Sous dossier 2','2020-04-15 06:59:54.000','2023-04-12 06:40:05.000','2020-04-16 10:40:45.000','2023-06-13 12:02:08.257','2023-06-13 14:02:08.257'),('c17a41dd-a1dc-4b45-8bc4-cdaf9f8a6853',662,'801b987d-e335-4276-8bc6-1fa57b553716',2,0,'Sous dossier 2','2020-04-11 08:43:30.000',NULL,'2020-04-11 10:15:29.000','2023-06-13 12:02:07.036','2023-06-13 14:02:07.036'),('c4b27870-75ff-4ef2-93ab-393cd5837ed3',662,'adf717e5-dc3f-47f0-9f8a-d13e0438f5cd',1,0,'Sous dossier 1','2021-03-19 10:23:31.000','2021-06-08 21:07:30.000','2021-03-19 10:23:31.000','2021-06-08 19:07:30.000',NULL),('c68cb967-9ffa-4a4d-ad01-fe12edf11b36',662,'c42cadf5-5f0e-439e-9aab-087940794316',2,0,'Sous dossier 2','2020-12-29 08:34:29.000','2020-12-30 07:52:28.000','2020-12-29 08:34:29.000','2020-12-30 06:52:28.000',NULL),('c6fffa68-cc65-471a-a58e-135ebe4d0772',662,'76dcd1f0-f6c7-480f-b07b-441679345d70',1,0,'Sous dossier 1','2021-02-16 10:48:21.000',NULL,'2021-02-16 13:05:09.000','2023-06-13 12:02:07.261','2023-06-13 14:02:07.261'),('c9d37315-5f17-421c-8afb-302fa9b0bebe',662,'cb9d8495-b4dd-423f-a624-7cff70e4db55',1,0,'Sous dossier 1','2020-04-06 12:22:59.000','2023-04-12 06:40:05.000','2020-04-13 07:58:19.000','2023-06-13 12:02:08.267','2023-06-13 14:02:08.267'),('ca0b761f-76f8-412a-85e4-b91ec62f9ded',662,'647287de-fb34-4f94-83ef-40f59da2edb3',1,0,'Sous dossier 1','2020-04-17 07:55:10.000','2023-04-12 06:40:05.000','2020-04-17 07:55:09.000','2023-06-13 12:02:08.276','2023-06-13 14:02:08.276'),('cd63d5a9-bc90-411d-8bf3-f3f492cddf36',662,'1716bd86-ee5e-4929-9e79-3beba5199c80',1,0,'Sous dossier 1','2022-06-27 21:27:06.000',NULL,'2022-06-10 19:55:01.000','2023-06-13 12:02:07.343','2023-06-13 14:02:07.343'),('ce2ea9d2-a701-4f31-a83d-aaab5b7b6895',662,'801b987d-e335-4276-8bc6-1fa57b553716',5,0,'Sous dossier 5','2020-07-13 19:51:04.000',NULL,'2020-07-13 19:51:04.000','2023-06-13 12:02:07.169','2023-06-13 14:02:07.169'),('cf92c789-09e1-11ee-b558-229278a3c906',662,'cf8f7620-09e1-11ee-b558-229278a3c906',1,0,'','2023-06-13 13:59:54.986','2023-06-13 14:00:42.555','2023-06-13 13:59:54.989','2023-06-13 12:00:42.556','2023-06-13 14:00:42.566'),('d057169e-3160-48a5-a239-2d74b9ded8c6',662,'7813c59a-91e7-4c2c-8027-bcc3c35c797c',2,0,'Sous dossier 2','2020-04-08 08:49:31.000',NULL,'2020-04-08 08:49:30.000','2023-06-13 12:02:07.000','2023-06-13 14:02:07.000'),('d38b11ef-8ce0-42fe-8739-7f1a8c61e862',662,'7f8fbc5c-3db7-4ee3-adcd-e76fc6f390b8',1,0,'Sous dossier 1','2020-04-08 12:31:53.000','2020-04-09 11:07:42.000','2020-04-08 12:31:53.000','2020-04-09 09:07:42.000',NULL),('d402edb5-8449-46a8-862f-a1cd1ee21cf6',662,'64834083-3320-4687-9710-c2be0d9c7198',1,0,'Sous dossier 1','2020-04-30 19:09:01.000',NULL,'2020-05-04 12:02:57.000','2023-06-13 12:02:07.112','2023-06-13 14:02:07.112'),('d70cc224-5e0d-4b47-9270-d8e23a25b566',662,'586a7c87-5d8a-440f-a654-c452dc908844',1,0,'Sous dossier 1','2023-03-21 12:06:43.000',NULL,'2023-03-21 12:27:29.000','2023-06-13 12:02:08.096','2023-06-13 14:02:08.096'),('daf632b1-2c49-42c8-8899-0a0b2448bc3a',662,'c59a2f65-79fe-44cd-8377-e39aa0a44171',1,0,'Sous dossier 1','2020-04-18 08:57:40.000',NULL,'2020-04-18 09:39:12.000','2023-06-13 12:02:07.070','2023-06-13 14:02:07.070'),('dce9ce0f-0933-4c98-af84-59e2b6395f8f',662,'87965ef8-01eb-4830-8e8b-8b99ece62cf1',1,0,'Sous dossier 1','2022-06-27 21:27:08.000',NULL,'2022-06-27 21:02:22.000','2023-06-13 12:02:07.351','2023-06-13 14:02:07.351'),('dde78398-923b-407f-a04f-d7062b72c788',662,'1ce80886-d3f3-42d8-872a-a2eba69d0005',1,0,'Sous dossier 1','2020-04-15 06:59:51.000','2023-04-12 06:40:05.000','2020-04-15 06:59:48.000','2023-06-13 12:02:08.284','2023-06-13 14:02:08.284'),('e06b73d5-45f7-4906-ba73-560d66ac56af',662,'a6ab7edf-6040-4f1a-b898-a1120a854927',1,0,'Sous dossier 1','2020-04-16 10:43:49.000',NULL,'2020-04-16 11:39:24.000','2023-06-13 12:02:07.045','2023-06-13 14:02:07.045'),('e518dfde-09e0-11ee-b558-229278a3c906',662,'e516e5ef-09e0-11ee-b558-229278a3c906',1,0,'','2023-06-13 13:53:21.600','2023-06-13 14:00:59.583','2023-06-13 13:53:21.602','2023-06-13 12:00:59.584','2023-06-13 14:00:59.604'),('e5a14b69-613a-4be3-a5e8-9e99eeedae26',662,'8f3d7d42-f6ad-4e48-8951-08222c212e7e',2,0,'Sous dossier 2','2022-12-14 14:59:42.000',NULL,'2022-11-04 13:30:38.000','2023-06-13 12:02:07.972','2023-06-13 14:02:07.972'),('ecdac05b-a55a-4b8a-9452-075fcd73eb50',662,'801b987d-e335-4276-8bc6-1fa57b553716',6,0,'Sous dossier 6','2020-07-13 19:51:13.000',NULL,'2020-07-13 19:51:13.000','2023-06-13 12:02:07.176','2023-06-13 14:02:07.176'),('ed8b4bd5-0a61-4563-b6a4-6ec124bc388d',662,'949fe730-88fa-4ec2-852e-dd0772ee3ee0',1,0,'Sous dossier 1','2022-06-28 20:03:42.000',NULL,'2022-06-28 20:39:41.000','2023-06-13 12:02:07.368','2023-06-13 14:02:07.368'),('f2e73640-aebd-4bb1-9b02-c0504556ac5a',662,'bc967a6b-ad1a-4a59-aab8-92332e4217b0',1,0,'Sous dossier 1','2020-07-13 19:10:06.000',NULL,'2020-07-13 19:51:52.000','2023-06-13 12:02:07.193','2023-06-13 14:02:07.193'),('f31eb3e4-3910-400c-aa4c-5340aa0ac4c5',662,'801b987d-e335-4276-8bc6-1fa57b553716',3,0,'Sous dossier 3','2020-04-11 09:02:08.000',NULL,'2020-04-11 09:02:07.000','2023-06-13 12:02:07.028','2023-06-13 14:02:07.028'),('f502edbf-c31f-430b-8550-5888e894e4b4',662,'47a8d99f-668b-4bb6-b3bf-7bff221d397f',1,0,'Sous dossier 1','2020-04-16 10:42:10.000','2023-04-12 06:40:05.000','2020-04-16 10:42:09.000','2023-06-13 12:02:08.292','2023-06-13 14:02:08.292'),('f72f6016-0f75-4789-9924-1bc9aa64c2f1',662,'3eede325-0afb-43f5-9277-e22c18f8f927',1,0,'Sous dossier 1','2022-08-06 13:43:33.000',NULL,'2022-08-06 13:56:38.000','2023-06-13 12:02:07.376','2023-06-13 14:02:07.376'),('f7b71416-57aa-4d3d-a2e5-0e6c1519f6e8',662,'78fbbe11-e1a5-4c10-b6e3-4f00df178dc6',1,0,'Sous dossier 1','2020-04-14 11:34:35.000','2023-04-12 06:40:05.000','2020-04-16 07:16:48.000','2023-06-13 12:02:08.300','2023-06-13 14:02:08.300'),('fd5f5d3b-c6e8-429a-bc31-3b24a7c2bba9',662,'d458682a-423b-43fe-a4b0-97d586104341',2,0,'Sous dossier 2','2020-04-09 11:05:44.000','2023-04-12 06:40:05.000','2020-04-09 11:05:43.000','2023-06-13 12:02:08.309','2023-06-13 14:02:08.309'),('fe8d1101-8c36-4d12-83c2-62848cf6c520',662,'83306c87-ca0d-4ed2-b376-4227f586001f',2,0,'Sous dossier 2','2020-12-29 11:57:43.000',NULL,'2020-12-29 11:41:50.000','2023-06-13 12:02:07.228','2023-06-13 14:02:07.228');
/*!40000 ALTER TABLE `Session` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SmilersOrder`
--

DROP TABLE IF EXISTS `SmilersOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SmilersOrder` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `actId` varchar(36) NOT NULL,
  `title` varchar(64) DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `createdById` varchar(36) DEFAULT NULL,
  `updatedById` varchar(36) DEFAULT NULL,
  `displayId` mediumint unsigned DEFAULT NULL,
  `json` text NOT NULL,
  `metadata` text NOT NULL,
  `status` enum('NOT_SENT','WAITING_WOW_API','SENDING_WOW_API','SENDING_SMILERS_API','SENT','CANCELLED','DELIVERY') NOT NULL DEFAULT 'NOT_SENT',
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastModified` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  KEY `actId` (`actId`),
  CONSTRAINT `SmilersOrder_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `SmilersOrder_ibfk_2` FOREIGN KEY (`actId`) REFERENCES `Act` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SmilersOrder`
--

LOCK TABLES `SmilersOrder` WRITE;
/*!40000 ALTER TABLE `SmilersOrder` DISABLE KEYS */;
INSERT INTO `SmilersOrder` VALUES ('0014546a-ad2d-4f74-9a83-8a7a0cf1af7a',662,'848b25bd-90a8-4105-871d-f9326fe94c7b','SMILERS ORDER',0,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'{\"caseId\":\"1.21.6.S1\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19900713\",\"patientFirstName\":\"Anaïs\",\"patientLastName\":\"LACOMBE\"}','{\"Maxillaire 1.21.6.1.1\":\"689b438f-3633-4981-b669-5e49a97a5c95\"}','SENT','2022-12-21 12:15:13.000',NULL,'2022-12-21 12:15:13.000','2022-12-21 11:18:00.000','2022-12-21 12:18:00.000'),('06c913e1-07d1-4a41-90a1-07f408f59737',662,'3eede325-0afb-43f5-9277-e22c18f8f927','SMILERS ORDER',0,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'{\"caseId\":\"1.20.2.S1\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19541203\",\"patientFirstName\":\"Michèle\",\"patientLastName\":\"ESPOSITO\"}','{\"Mandibule 1.20.2.1.1\":\"2cff0ba7-eee7-4c7f-99af-34c690eb3868\"}','SENT','2022-08-06 13:59:25.000',NULL,'2022-08-06 13:59:25.000','2022-08-06 11:59:32.000','2022-08-06 13:59:32.000'),('1995f588-2757-42b8-8f51-c2e41e0ebe8f',662,'b498bdf4-2e5b-497a-8bfe-b65edabac3bc','SMILERS ORDER',0,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'{\"caseId\":\"1.22.1.S1\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19640223\",\"patientFirstName\":\"Nathalie\",\"patientLastName\":\"DAUGREILH\"}','{\"Mandibule 1.22.1.1.1\":\"45a97d29-279f-4720-856d-2ef701665f93\",\"Maxillaire 1.22.1.1.1\":\"13991d0c-102a-4df8-aaad-f5f422edc6be\",\"Mordu anterieur 1.22.1.1.1\":\"963a8acf-cdb2-41d5-b187-9a7c885ac2a0\",\"Mordu posterieur droit 1.22.1.1.1\":\"c19a9e26-b162-4808-8d10-9d6a38e24e98\",\"Mordu posterieur gauche 1.22.1.1.2\":\"a3d56e52-a954-4894-b840-be0425c42658\"}','SENT','2021-11-23 12:24:09.000',NULL,'2021-11-23 12:24:09.000','2021-11-23 11:24:34.000','2021-11-23 12:24:34.000'),('23e375bd-b901-4423-96cd-1e2b8ffc55cd',662,'b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c','SMILERS ORDER',0,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',4,'{\"caseId\":\"1.13.4.S4\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19990727\",\"patientFirstName\":\"Ninon\",\"patientLastName\":\"MARTY\"}','{\"Mandibule 1.13.4.1.1\":\"4b136eb3-b01e-4166-a154-4539e20f9fea\",\"Maxillaire 1.13.4.1.1\":\"ac0adbda-ae71-490a-947a-f9bfe33db7e8\",\"Mordu anterieur\":\"534cca35-8182-4f61-aa57-03bad8172eac\",\"Mordu posterieur droit\":\"ecd2beec-0c29-40e2-ab95-64009c33fa40\",\"Mordu posterieur gauche\":\"876f775b-e8a0-4b7f-bea0-0c93a7041d17\"}','SENT','2020-12-29 12:09:26.000',NULL,'2020-12-29 12:09:26.000','2020-12-29 11:14:59.000','2020-12-29 12:14:59.000'),('25ef7afa-d8ec-11ed-8a5a-00d86184ce0e',662,'c983b946-e304-49a8-99c8-24eaca67b9ce','Commande n° 1.21.8.S1',0,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'{\"caseId\":\"1.21.8.S1\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19900713\",\"patientFirstName\":\"Anaïs\",\"patientLastName\":\"LACOMBE\"}','{\"Maxillaire 1.21.8.1.1\":\"4782af06-5171-4020-833c-143c6a151469\"}','SENT','2023-04-12 06:40:27.000',NULL,'2023-04-12 09:24:17.000','2023-04-12 07:24:24.258','2023-04-12 09:24:24.258'),('2a5500be-4ce4-4028-839b-141af843989f',662,'0c1ed331-8df6-482e-8dd1-508d9b190c49','SMILERS ORDER',0,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'{\"caseId\":\"1.19.1.S1\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19620202\",\"patientFirstName\":\"Gisèle\",\"patientLastName\":\"AVERSENQ\"}','{\"Mandibule 1.19.1.1.1\":\"49635be4-dbea-497c-82e1-206399739c31\",\"Maxillaire 1.19.1.1.1\":\"84c96eac-549e-4c1d-a701-896474d66a31\",\"Mordu anterieur 1.19.1.1.1\":\"25d2e57a-b759-4ab8-a633-7725e7375d70\",\"Mordu posterieur droit 1.19.1.1.1\":\"f500b4e0-bd2d-4992-901f-526fc78912cf\",\"Mordu posterieur gauche 1.19.1.1.1\":\"ed40ce9a-6d1f-4cfd-a3e2-f58cba946869\"}','SENT','2021-09-27 13:56:51.000',NULL,'2021-09-27 13:56:51.000','2021-09-27 12:02:12.000','2021-09-27 14:02:12.000'),('326b48e4-9182-4dc4-9e91-44104a1a8ff1',662,'7e359a5f-1756-4ec7-8657-3e5940ae489d','SMILERS ORDER',0,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'{\"caseId\":\"1.20.1.S1\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19541203\",\"patientFirstName\":\"Michèle\",\"patientLastName\":\"ESPOSITO\"}','{\"Mandibule 1.20.1.1.1\":\"dd29f41a-cbb1-45d7-8979-1d16d4db487c\",\"Maxillaire 1.20.1.1.1\":\"4f638684-087b-42a0-916a-a8adc0c1eeea\",\"Mordu anterieur 1.20.1.1.1\":\"9617b0df-e829-47cd-8110-fabb587a690d\",\"Mordu posterieur droit 1.20.1.1.1\":\"0e855e55-dc7f-4eaf-91bd-933232cae95e\",\"Mordu posterieur gauche 1.20.1.1.1\":\"0a02b656-9179-4cbd-ae14-079f4f933517\"}','SENT','2021-10-12 14:26:57.000',NULL,'2021-10-12 14:26:57.000','2021-10-12 12:40:25.000','2021-10-12 14:40:25.000'),('4dd9cb8a-22ca-48ed-943c-f8227a82fd43',662,'e43c8099-0862-42c3-9ad2-1efef27b83ba','SMILERS ORDER',0,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'{\"caseId\":\"1.21.3.S1\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19900713\",\"patientFirstName\":\"Anaïs\",\"patientLastName\":\"LACOMBE\"}','{\"Maxillaire 1.21.3.1.1\":\"bafe042a-2298-470c-8d08-071e0f4e388e\"}','SENT','2022-09-14 12:24:53.000',NULL,'2022-09-14 12:24:53.000','2022-09-14 10:25:38.000','2022-09-14 12:25:38.000'),('510986a4-1523-4c17-84f5-900361edbf32',662,'c47ee4d9-c646-4836-8152-fc2ded70b4fe','SMILERS ORDER',0,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'{\"caseId\":\"1.14.1.S1\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19990721\",\"patientFirstName\":\"Benjamin\",\"patientLastName\":\"RIVES\"}','{\"Mandibule 1.14.1.1.2\":\"23066de9-fbda-436c-bd8b-dacb5721c390\",\"Maxillaire 1.14.1.1.1\":\"4df1d6c0-6d77-4547-ae20-f797167f57b2\",\"Mordu anterieur\":\"ccd3f4f6-f303-4b20-b967-d41121f2e36b\",\"Mordu posterieur droit\":\"79548cb6-a61f-44cb-b6f7-cab7698f7465\",\"Mordu posterieur gauche\":\"7a480eb2-a7b4-4ec5-b628-ef6c2043dd7a\"}','SENT','2021-02-01 21:24:09.000',NULL,'2021-02-01 21:24:09.000','2021-02-01 20:24:24.000','2021-02-01 21:24:24.000'),('5dd87306-77a2-44aa-9d31-280dd9c9a0df',662,'87965ef8-01eb-4830-8e8b-8b99ece62cf1','SMILERS ORDER',0,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'{\"caseId\":\"1.21.2.S1\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19900713\",\"patientFirstName\":\"Anaïs\",\"patientLastName\":\"LACOMBE\"}','{\"Mandibule 1.21.2.1.1\":\"a6c49c5b-a994-457c-80d2-6cd69b636979\"}','SENT','2022-06-27 21:28:36.000',NULL,'2022-06-27 21:28:36.000','2022-06-27 19:35:51.000','2022-06-27 21:35:51.000'),('6115b844-b299-4810-9483-4074715ac8c2',662,'b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c','SMILERS ORDER',0,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',3,'{\"caseId\":\"1.13.4.S3\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19990727\",\"patientFirstName\":\"Ninon\",\"patientLastName\":\"MARTY\"}','{\"Mandibule 1.13.4.1.1\":\"4b136eb3-b01e-4166-a154-4539e20f9fea\",\"Maxillaire 1.13.4.1.1\":\"ac0adbda-ae71-490a-947a-f9bfe33db7e8\",\"Mordu anterieur\":\"534cca35-8182-4f61-aa57-03bad8172eac\",\"Mordu posterieur droit\":\"ecd2beec-0c29-40e2-ab95-64009c33fa40\",\"Mordu posterieur gauche\":\"876f775b-e8a0-4b7f-bea0-0c93a7041d17\"}','SENT','2020-12-29 12:06:52.000',NULL,'2020-12-29 12:06:52.000','2020-12-29 11:15:15.000','2020-12-29 12:15:15.000'),('6e963009-b46f-494d-a5d4-b162c5918103',662,'72b7a457-e38f-4535-8eba-6c98b43e5e55','SMILERS ORDER',0,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'{\"caseId\":\"1.14.2.S1\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19990721\",\"patientFirstName\":\"Benjamin\",\"patientLastName\":\"RIVES\"}','{\"Mandibule 1.14.2.1.2\":\"0f7ff11f-44bc-45a5-bfc7-a7ac0da258f5\",\"Maxillaire 1.14.2.1.1\":\"ab47d04c-6ad7-430c-ae85-9231a2efc7b9\",\"Mordu anterieur\":\"18365744-4019-43e1-933f-9fa52db1a30d\",\"Mordu posterieur droit\":\"41b8d05c-738b-4161-9f86-27222b61ad66\",\"Mordu posterieur gauche\":\"44b8a221-3707-430b-bc84-cacca7bf7d8a\"}','SENT','2021-06-08 20:57:52.000',NULL,'2021-06-08 20:57:52.000','2021-06-08 18:58:38.000','2021-06-08 20:58:38.000'),('802bd1e1-3362-4d30-9362-8bdbbb6482d2',662,'76dcd1f0-f6c7-480f-b07b-441679345d70','SMILERS ORDER',0,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'{\"caseId\":\"1.15.1.S1\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19910902\",\"patientFirstName\":\"Quitterie\",\"patientLastName\":\"DOUENCE\"}','{\"Mandibule 1.15.1.1.1\":\"3f34dab9-eda8-40de-be81-a094dee55a47\",\"Maxillaire 1.15.1.1.1\":\"e1692a67-2979-4399-b4dc-65a1c7e9c4b8\",\"Mordu anterieur\":\"44ccf5f6-834d-4090-88dc-399b19fed47e\",\"Mordu posterieur droit\":\"c99bbff9-5630-49d7-9300-4dabfa5e74c8\",\"Mordu posterieur gauche\":\"7a39120e-2f79-4c3e-af4d-af72e8ca8062\"}','SENT','2021-02-16 13:05:30.000',NULL,'2021-02-16 13:05:30.000','2021-02-16 12:05:52.000','2021-02-16 13:05:52.000'),('888cf7fa-b086-4bbe-8352-4b347b1fbf70',662,'586a7c87-5d8a-440f-a654-c452dc908844','SMILERS ORDER',0,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'{\"caseId\":\"1.19.4.S1\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19620202\",\"patientFirstName\":\"Gisèle\",\"patientLastName\":\"AVERSENQ\"}','{\"Maxillaire 1.19.4.1.1\":\"ab2de538-1cbb-481f-a82e-899f47da34b7\"}','SENT','2023-03-21 12:28:13.000',NULL,'2023-03-21 12:28:13.000','2023-03-21 11:30:59.000','2023-03-21 12:30:59.000'),('97b0ec8c-0f87-4226-bd8d-caffe14e5dd7',662,'129a6c33-3cca-43ab-b97a-56d0e82a546f','SMILERS ORDER',0,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'{\"caseId\":\"1.19.3.S1\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19620202\",\"patientFirstName\":\"Gisèle\",\"patientLastName\":\"AVERSENQ\"}','{\"Maxillaire 1.19.3.1.1\":\"1e41852a-1d94-44eb-90f9-b06c401ee8b7\",\"Mordu anterieur 1.19.3.1.1\":\"dc97d683-1aa5-4aba-bf5c-a43b36478d90\",\"Mordu posterieur droit 1.19.3.1.1\":\"d82bb8e8-709c-4148-9290-d8b05ce3f7e6\",\"Mordu posterieur gauche 1.19.3.1.1\":\"6f481e07-43c0-494b-8d4f-279772780eec\"}','SENT','2022-11-02 13:56:17.000',NULL,'2022-11-02 13:56:17.000','2022-11-02 17:43:29.000','2022-11-02 18:43:29.000'),('98b2c081-d902-11ed-9278-00d86184ce0e',662,'98ada573-d902-11ed-9278-00d86184ce0e','Commande n° 1.21.9.S1',1,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'{\"caseId\":\"1.21.9.S1\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19900713\",\"patientFirstName\":\"Anaïs\",\"patientLastName\":\"LACOMBE\"}','','NOT_SENT','2023-04-12 09:21:09.336','2023-04-12 09:21:38.883','2023-04-12 09:21:38.883','2023-04-12 07:21:38.883',NULL),('a5b8e66e-54fa-4915-91c4-4ae875c9f3ba',662,'b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c','SMILERS ORDER',0,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'{\"caseId\":\"1.13.4.S1\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19990727\",\"patientFirstName\":\"Ninon\",\"patientLastName\":\"MARTY\"}','{\"Mandibule 1.13.4.1.1\":\"4b136eb3-b01e-4166-a154-4539e20f9fea\",\"Maxillaire 1.13.4.1.1\":\"ac0adbda-ae71-490a-947a-f9bfe33db7e8\",\"Mordu anterieur\":\"534cca35-8182-4f61-aa57-03bad8172eac\",\"Mordu posterieur droit\":\"ecd2beec-0c29-40e2-ab95-64009c33fa40\",\"Mordu posterieur gauche\":\"876f775b-e8a0-4b7f-bea0-0c93a7041d17\"}','SENT','2020-12-29 12:01:43.000',NULL,'2020-12-29 12:01:43.000','2020-12-29 11:14:44.000','2020-12-29 12:14:44.000'),('b1ca2262-cd6f-4c35-984a-071491ef1682',662,'949fe730-88fa-4ec2-852e-dd0772ee3ee0','SMILERS ORDER',0,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'{\"caseId\":\"1.19.2.S1\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19620202\",\"patientFirstName\":\"Gisèle\",\"patientLastName\":\"AVERSENQ\"}','{\"Maxillaire 1.19.2.1.1\":\"a4f0f4fa-9346-4a75-a1dd-e95c83dc5e6b\"}','SENT','2022-06-28 20:40:18.000',NULL,'2022-06-28 20:40:18.000','2022-06-28 18:41:00.000','2022-06-28 20:41:00.000'),('bc0a9e7a-61d4-416f-99e7-00ae8838c1af',662,'3d2141bb-462c-4334-b177-d17d136574ae','SMILERS ORDER',0,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'{\"caseId\":\"1.21.1.S1\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19900713\",\"patientFirstName\":\"Anaïs\",\"patientLastName\":\"LACOMBE\"}','{\"Mandibule 1.21.1.1.1\":\"c8503263-9efa-47b8-8764-2bb09be6a1cb\",\"Maxillaire 1.21.1.1.1\":\"6420c2d7-bcdf-4e2e-9ee7-e90e3b7b7045\",\"Mordu anterieur 1.21.1.1.1\":\"f880f49e-bb57-430d-8212-dcb8e015569f\",\"Mordu posterieur droit 1.21.1.1.1\":\"45a66afe-8bb2-49b4-b3fc-982c845cf2f2\",\"Mordu posterieur gauche 1.21.1.1.1\":\"5f516c96-8333-49f5-8c71-3a7e8878488c\"}','SENT','2021-11-22 12:51:17.000',NULL,'2021-11-22 12:51:17.000','2021-11-22 11:51:37.000','2021-11-22 12:51:37.000'),('d151be06-8a97-48d0-9abe-2095c6c410c7',662,'8f3d7d42-f6ad-4e48-8951-08222c212e7e','SMILERS ORDER',0,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'{\"caseId\":\"1.21.4.S1\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19900713\",\"patientFirstName\":\"Anaïs\",\"patientLastName\":\"LACOMBE\"}','{\"Mandibule 1.21.4.1.1\":\"6ea3e979-830a-4dd4-81e2-3d30db702b9c\",\"Mordu anterieur 1.21.4.1.1\":\"b6b42cf7-31c1-49e1-b1d1-c607c7ba299b\"}','SENT','2022-11-04 12:37:20.000',NULL,'2022-11-04 12:37:20.000','2022-11-04 11:40:15.000','2022-11-04 12:40:15.000'),('ddf3aa86-53ab-4afd-90b7-ff5de6dbb17e',662,'2c78d514-95bd-4529-b0a1-babfb83849b1','SMILERS ORDER',0,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'{\"caseId\":\"1.21.7.S1\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19900713\",\"patientFirstName\":\"Anaïs\",\"patientLastName\":\"LACOMBE\"}','{\"Mandibule 1.21.7.1.1\":\"06da4522-e34d-40fd-b96f-ca51c40618cc\"}','SENT','2023-01-11 13:45:24.000',NULL,'2023-01-11 13:45:24.000','2023-01-11 12:47:48.000','2023-01-11 13:47:48.000'),('e3644629-0e9d-4455-b760-495a260e47fe',662,'f474819e-9470-4612-8275-2ceb25b5522f','SMILERS ORDER',0,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'{\"caseId\":\"1.16.1.S1\",\"dentistId\":\"5337\",\"patientBirthDate\":\"20070116\",\"patientFirstName\":\"Yohan\",\"patientLastName\":\"LE PARC\"}','{\"Mandibule 1.16.1.1.1\":\"1e84d5d4-6768-4dde-a7cf-ca40a6d4261e\",\"Maxillaire 1.16.1.1.1\":\"0b4e8e31-bd54-4394-8ebc-2c2d30d84197\",\"Mordu anterieur\":\"57e7671e-1671-4ee9-96a0-650a56963aa8\",\"Mordu posterieur droit\":\"d4c7f3c5-155d-41ef-8665-852e89c5e017\",\"Mordu posterieur gauche\":\"0d792709-57f3-49e1-963c-d2dc35a59d12\"}','SENT','2021-02-27 10:59:19.000',NULL,'2021-02-27 10:59:19.000','2021-02-27 10:00:04.000','2021-02-27 11:00:04.000'),('fc4bdff0-7d08-4454-8d7e-962c91470073',662,'7841125a-11dd-4b66-9179-cd371ea2f0f7','SMILERS ORDER',0,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',1,'{\"caseId\":\"1.23.1.S1\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19771212\",\"patientFirstName\":\"Carla\",\"patientLastName\":\"GARCIA\"}','{\"Mandibule 1.23.1.1.1\":\"6918be85-b74b-4069-b2b3-914477ca77ad\",\"Maxillaire 1.23.1.1.1\":\"07615b33-5390-4fe1-9fbb-9ec7cbd64d40\",\"Mordu anterieur 1.23.1.1.1\":\"6fa55f91-2e1f-436b-b276-b2726e9125b4\",\"Mordu posterieur droit 1.23.1.1.1\":\"ce7041b4-86ce-4167-b150-b49d4f0008a6\",\"Mordu posterieur gauche 1.23.1.1.1\":\"5c2ae31f-cf6e-42c8-9d38-6f41e1e8db02\"}','SENT','2022-01-11 12:41:54.000',NULL,'2022-01-11 12:41:54.000','2022-01-11 11:43:37.000','2022-01-11 12:43:37.000'),('fe4b95cf-3dfa-42d2-830b-1ff35aa1c81a',662,'b3e2b1fd-44c8-4dec-8a78-4d6ecb9e7f8c','SMILERS ORDER',0,'045f19a4-7d35-457a-85ae-94b33b89a0d2','045f19a4-7d35-457a-85ae-94b33b89a0d2',2,'{\"caseId\":\"1.13.4.S2\",\"dentistId\":\"5337\",\"patientBirthDate\":\"19990727\",\"patientFirstName\":\"Ninon\",\"patientLastName\":\"MARTY\"}','{\"Mandibule 1.13.4.1.1\":\"4b136eb3-b01e-4166-a154-4539e20f9fea\",\"Maxillaire 1.13.4.1.1\":\"ac0adbda-ae71-490a-947a-f9bfe33db7e8\",\"Mordu anterieur\":\"534cca35-8182-4f61-aa57-03bad8172eac\",\"Mordu posterieur droit\":\"ecd2beec-0c29-40e2-ab95-64009c33fa40\",\"Mordu posterieur gauche\":\"876f775b-e8a0-4b7f-bea0-0c93a7041d17\"}','SENT','2020-12-29 12:02:05.000',NULL,'2020-12-29 12:02:05.000','2020-12-29 11:15:30.000','2020-12-29 12:15:30.000');
/*!40000 ALTER TABLE `SmilersOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SmilersOrderFile`
--

DROP TABLE IF EXISTS `SmilersOrderFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SmilersOrderFile` (
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `orderId` varchar(36) NOT NULL,
  `fileId` varchar(36) NOT NULL,
  `type` enum('FORM','SCAN') NOT NULL,
  PRIMARY KEY (`orderId`,`fileId`),
  KEY `ownerId` (`ownerId`),
  KEY `fileId` (`fileId`),
  CONSTRAINT `SmilersOrderFile_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `SmilersOrderFile_ibfk_2` FOREIGN KEY (`orderId`) REFERENCES `SmilersOrder` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `SmilersOrderFile_ibfk_3` FOREIGN KEY (`fileId`) REFERENCES `File` (`uuid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SmilersOrderFile`
--

LOCK TABLES `SmilersOrderFile` WRITE;
/*!40000 ALTER TABLE `SmilersOrderFile` DISABLE KEYS */;
INSERT INTO `SmilersOrderFile` VALUES (662,'0014546a-ad2d-4f74-9a83-8a7a0cf1af7a','689b438f-3633-4981-b669-5e49a97a5c95','SCAN'),(662,'06c913e1-07d1-4a41-90a1-07f408f59737','2cff0ba7-eee7-4c7f-99af-34c690eb3868','SCAN'),(662,'1995f588-2757-42b8-8f51-c2e41e0ebe8f','13991d0c-102a-4df8-aaad-f5f422edc6be','SCAN'),(662,'1995f588-2757-42b8-8f51-c2e41e0ebe8f','45a97d29-279f-4720-856d-2ef701665f93','SCAN'),(662,'1995f588-2757-42b8-8f51-c2e41e0ebe8f','963a8acf-cdb2-41d5-b187-9a7c885ac2a0','SCAN'),(662,'1995f588-2757-42b8-8f51-c2e41e0ebe8f','a3d56e52-a954-4894-b840-be0425c42658','SCAN'),(662,'1995f588-2757-42b8-8f51-c2e41e0ebe8f','c19a9e26-b162-4808-8d10-9d6a38e24e98','SCAN'),(662,'23e375bd-b901-4423-96cd-1e2b8ffc55cd','229d55f2-d907-49a9-ae4c-c2359e8ce810','SCAN'),(662,'23e375bd-b901-4423-96cd-1e2b8ffc55cd','4b136eb3-b01e-4166-a154-4539e20f9fea','SCAN'),(662,'23e375bd-b901-4423-96cd-1e2b8ffc55cd','ac0adbda-ae71-490a-947a-f9bfe33db7e8','SCAN'),(662,'23e375bd-b901-4423-96cd-1e2b8ffc55cd','d47ef10b-7c9f-4fd9-8617-329e21bbfa35','SCAN'),(662,'23e375bd-b901-4423-96cd-1e2b8ffc55cd','e695a41c-b645-425c-85e6-65b449ddbb04','SCAN'),(662,'25ef7afa-d8ec-11ed-8a5a-00d86184ce0e','3b6f0d95-5183-43aa-8816-815a96e7e143','SCAN'),(662,'25ef7afa-d8ec-11ed-8a5a-00d86184ce0e','4782af06-5171-4020-833c-143c6a151469','SCAN'),(662,'2a5500be-4ce4-4028-839b-141af843989f','25d2e57a-b759-4ab8-a633-7725e7375d70','SCAN'),(662,'2a5500be-4ce4-4028-839b-141af843989f','49635be4-dbea-497c-82e1-206399739c31','SCAN'),(662,'2a5500be-4ce4-4028-839b-141af843989f','84c96eac-549e-4c1d-a701-896474d66a31','SCAN'),(662,'2a5500be-4ce4-4028-839b-141af843989f','ed40ce9a-6d1f-4cfd-a3e2-f58cba946869','SCAN'),(662,'2a5500be-4ce4-4028-839b-141af843989f','f500b4e0-bd2d-4992-901f-526fc78912cf','SCAN'),(662,'326b48e4-9182-4dc4-9e91-44104a1a8ff1','0a02b656-9179-4cbd-ae14-079f4f933517','SCAN'),(662,'326b48e4-9182-4dc4-9e91-44104a1a8ff1','0e855e55-dc7f-4eaf-91bd-933232cae95e','SCAN'),(662,'326b48e4-9182-4dc4-9e91-44104a1a8ff1','4f638684-087b-42a0-916a-a8adc0c1eeea','SCAN'),(662,'326b48e4-9182-4dc4-9e91-44104a1a8ff1','9617b0df-e829-47cd-8110-fabb587a690d','SCAN'),(662,'326b48e4-9182-4dc4-9e91-44104a1a8ff1','dd29f41a-cbb1-45d7-8979-1d16d4db487c','SCAN'),(662,'4dd9cb8a-22ca-48ed-943c-f8227a82fd43','bafe042a-2298-470c-8d08-071e0f4e388e','SCAN'),(662,'510986a4-1523-4c17-84f5-900361edbf32','23066de9-fbda-436c-bd8b-dacb5721c390','SCAN'),(662,'510986a4-1523-4c17-84f5-900361edbf32','4df1d6c0-6d77-4547-ae20-f797167f57b2','SCAN'),(662,'510986a4-1523-4c17-84f5-900361edbf32','98c10ee7-5736-4c52-8f1e-248cda79d235','SCAN'),(662,'510986a4-1523-4c17-84f5-900361edbf32','d3e47b22-64d4-4936-a2f6-a2a11b01fdf2','SCAN'),(662,'510986a4-1523-4c17-84f5-900361edbf32','e3dcb444-172f-4ae1-a2bc-7ff3b7c8eb26','SCAN'),(662,'5dd87306-77a2-44aa-9d31-280dd9c9a0df','a6c49c5b-a994-457c-80d2-6cd69b636979','SCAN'),(662,'6115b844-b299-4810-9483-4074715ac8c2','229d55f2-d907-49a9-ae4c-c2359e8ce810','SCAN'),(662,'6115b844-b299-4810-9483-4074715ac8c2','4b136eb3-b01e-4166-a154-4539e20f9fea','SCAN'),(662,'6115b844-b299-4810-9483-4074715ac8c2','ac0adbda-ae71-490a-947a-f9bfe33db7e8','SCAN'),(662,'6115b844-b299-4810-9483-4074715ac8c2','d47ef10b-7c9f-4fd9-8617-329e21bbfa35','SCAN'),(662,'6115b844-b299-4810-9483-4074715ac8c2','e695a41c-b645-425c-85e6-65b449ddbb04','SCAN'),(662,'6e963009-b46f-494d-a5d4-b162c5918103','0f7ff11f-44bc-45a5-bfc7-a7ac0da258f5','SCAN'),(662,'6e963009-b46f-494d-a5d4-b162c5918103','1fe4acd9-cda1-4289-bd11-70fec38115e5','SCAN'),(662,'6e963009-b46f-494d-a5d4-b162c5918103','3f9ce1c8-3470-43c5-8e52-0294b7082120','SCAN'),(662,'6e963009-b46f-494d-a5d4-b162c5918103','a196ba15-5ebd-46d8-b6fa-0325918797ac','SCAN'),(662,'6e963009-b46f-494d-a5d4-b162c5918103','ab47d04c-6ad7-430c-ae85-9231a2efc7b9','SCAN'),(662,'802bd1e1-3362-4d30-9362-8bdbbb6482d2','3f34dab9-eda8-40de-be81-a094dee55a47','SCAN'),(662,'802bd1e1-3362-4d30-9362-8bdbbb6482d2','818647ce-e09a-4e46-8ad9-2029a89b0d0f','SCAN'),(662,'802bd1e1-3362-4d30-9362-8bdbbb6482d2','b75b602f-a893-4dd9-8bbf-6b4b00421c4a','SCAN'),(662,'802bd1e1-3362-4d30-9362-8bdbbb6482d2','d7178627-cef8-4d56-87be-5ce753175b9f','SCAN'),(662,'802bd1e1-3362-4d30-9362-8bdbbb6482d2','e1692a67-2979-4399-b4dc-65a1c7e9c4b8','SCAN'),(662,'888cf7fa-b086-4bbe-8352-4b347b1fbf70','ab2de538-1cbb-481f-a82e-899f47da34b7','SCAN'),(662,'97b0ec8c-0f87-4226-bd8d-caffe14e5dd7','1e41852a-1d94-44eb-90f9-b06c401ee8b7','SCAN'),(662,'97b0ec8c-0f87-4226-bd8d-caffe14e5dd7','6f481e07-43c0-494b-8d4f-279772780eec','SCAN'),(662,'97b0ec8c-0f87-4226-bd8d-caffe14e5dd7','d82bb8e8-709c-4148-9290-d8b05ce3f7e6','SCAN'),(662,'97b0ec8c-0f87-4226-bd8d-caffe14e5dd7','dc97d683-1aa5-4aba-bf5c-a43b36478d90','SCAN'),(662,'a5b8e66e-54fa-4915-91c4-4ae875c9f3ba','229d55f2-d907-49a9-ae4c-c2359e8ce810','SCAN'),(662,'a5b8e66e-54fa-4915-91c4-4ae875c9f3ba','4b136eb3-b01e-4166-a154-4539e20f9fea','SCAN'),(662,'a5b8e66e-54fa-4915-91c4-4ae875c9f3ba','ac0adbda-ae71-490a-947a-f9bfe33db7e8','SCAN'),(662,'a5b8e66e-54fa-4915-91c4-4ae875c9f3ba','d47ef10b-7c9f-4fd9-8617-329e21bbfa35','SCAN'),(662,'a5b8e66e-54fa-4915-91c4-4ae875c9f3ba','e695a41c-b645-425c-85e6-65b449ddbb04','SCAN'),(662,'b1ca2262-cd6f-4c35-984a-071491ef1682','a4f0f4fa-9346-4a75-a1dd-e95c83dc5e6b','SCAN'),(662,'bc0a9e7a-61d4-416f-99e7-00ae8838c1af','45a66afe-8bb2-49b4-b3fc-982c845cf2f2','SCAN'),(662,'bc0a9e7a-61d4-416f-99e7-00ae8838c1af','5f516c96-8333-49f5-8c71-3a7e8878488c','SCAN'),(662,'bc0a9e7a-61d4-416f-99e7-00ae8838c1af','6420c2d7-bcdf-4e2e-9ee7-e90e3b7b7045','SCAN'),(662,'bc0a9e7a-61d4-416f-99e7-00ae8838c1af','c8503263-9efa-47b8-8764-2bb09be6a1cb','SCAN'),(662,'bc0a9e7a-61d4-416f-99e7-00ae8838c1af','f880f49e-bb57-430d-8212-dcb8e015569f','SCAN'),(662,'d151be06-8a97-48d0-9abe-2095c6c410c7','6ea3e979-830a-4dd4-81e2-3d30db702b9c','SCAN'),(662,'d151be06-8a97-48d0-9abe-2095c6c410c7','b6b42cf7-31c1-49e1-b1d1-c607c7ba299b','SCAN'),(662,'ddf3aa86-53ab-4afd-90b7-ff5de6dbb17e','06da4522-e34d-40fd-b96f-ca51c40618cc','SCAN'),(662,'e3644629-0e9d-4455-b760-495a260e47fe','048d66fa-42fe-4d07-8e9c-1a8a30ce1fb4','SCAN'),(662,'e3644629-0e9d-4455-b760-495a260e47fe','0b4e8e31-bd54-4394-8ebc-2c2d30d84197','SCAN'),(662,'e3644629-0e9d-4455-b760-495a260e47fe','1e84d5d4-6768-4dde-a7cf-ca40a6d4261e','SCAN'),(662,'e3644629-0e9d-4455-b760-495a260e47fe','4e355e83-f72e-471f-a217-6dc5ae2fd8aa','SCAN'),(662,'e3644629-0e9d-4455-b760-495a260e47fe','78aec42f-0ec9-4ca8-b05e-324d3b955b86','SCAN'),(662,'fc4bdff0-7d08-4454-8d7e-962c91470073','07615b33-5390-4fe1-9fbb-9ec7cbd64d40','SCAN'),(662,'fc4bdff0-7d08-4454-8d7e-962c91470073','5c2ae31f-cf6e-42c8-9d38-6f41e1e8db02','SCAN'),(662,'fc4bdff0-7d08-4454-8d7e-962c91470073','6918be85-b74b-4069-b2b3-914477ca77ad','SCAN'),(662,'fc4bdff0-7d08-4454-8d7e-962c91470073','6fa55f91-2e1f-436b-b276-b2726e9125b4','SCAN'),(662,'fc4bdff0-7d08-4454-8d7e-962c91470073','ce7041b4-86ce-4167-b150-b49d4f0008a6','SCAN'),(662,'fe4b95cf-3dfa-42d2-830b-1ff35aa1c81a','229d55f2-d907-49a9-ae4c-c2359e8ce810','SCAN'),(662,'fe4b95cf-3dfa-42d2-830b-1ff35aa1c81a','4b136eb3-b01e-4166-a154-4539e20f9fea','SCAN'),(662,'fe4b95cf-3dfa-42d2-830b-1ff35aa1c81a','ac0adbda-ae71-490a-947a-f9bfe33db7e8','SCAN'),(662,'fe4b95cf-3dfa-42d2-830b-1ff35aa1c81a','d47ef10b-7c9f-4fd9-8617-329e21bbfa35','SCAN'),(662,'fe4b95cf-3dfa-42d2-830b-1ff35aa1c81a','e695a41c-b645-425c-85e6-65b449ddbb04','SCAN');
/*!40000 ALTER TABLE `SmilersOrderFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SyncInfo`
--

DROP TABLE IF EXISTS `SyncInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SyncInfo` (
  `id` mediumint unsigned NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `patientsLastRetrieved` datetime(3) DEFAULT NULL,
  `actsLastRetrieved` datetime(3) DEFAULT NULL,
  `sessionsLastRetrieved` datetime(3) DEFAULT NULL,
  `scansLastRetrieved` datetime(3) DEFAULT NULL,
  `ordersLastRetrieved` datetime(3) DEFAULT NULL,
  `assistantsLastRetrieved` datetime(3) DEFAULT NULL,
  `contactsLastRetrieved` datetime(3) DEFAULT NULL,
  `discussionsLastRetrieved` datetime(3) DEFAULT NULL,
  `messagesLastRetrieved` datetime(3) DEFAULT NULL,
  `notificationsLastRetrieved` datetime(3) DEFAULT NULL,
  `occlusionsLastRetrieved` datetime(3) DEFAULT NULL,
  `circleordersLastRetrieved` datetime(3) DEFAULT NULL,
  `smilersordersLastRetrieved` datetime(3) DEFAULT NULL,
  `prostheticSheetsLastRetrieved` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  PRIMARY KEY (`id`,`ownerId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SyncInfo`
--

LOCK TABLES `SyncInfo` WRITE;
/*!40000 ALTER TABLE `SyncInfo` DISABLE KEYS */;
INSERT INTO `SyncInfo` VALUES (1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-11 19:02:22.753'),(1,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-11 19:02:22.753'),(1,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-11 19:02:22.753'),(1,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-11 19:02:22.753'),(1,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-11 19:02:22.753'),(1,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-11 19:02:22.753'),(1,8,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-11 19:02:22.753'),(1,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-11 19:02:22.753'),(1,59,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-11 19:02:22.753'),(1,155,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-11 19:02:22.753'),(1,172,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-11 19:02:22.753'),(1,193,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-11 19:02:22.753'),(1,224,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-11 19:02:22.753'),(1,317,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-11 19:02:22.753'),(1,339,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-11 19:02:22.753'),(1,355,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-11 19:02:22.753'),(1,662,'2023-06-13 14:02:05.314','2023-06-13 14:02:06.741','2023-06-13 14:02:08.326','2023-06-13 14:02:15.680','2020-07-15 23:04:22.000',NULL,'2023-06-13 14:02:16.727','2023-06-13 14:02:19.582','2023-03-21 12:31:05.000','2020-09-09 19:44:24.000','2023-06-13 14:02:16.328',NULL,'2023-03-21 12:30:59.000',NULL,'2023-06-13 12:02:24.793'),(1,663,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-11 19:02:22.753'),(1,689,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-11 19:02:22.753'),(1,1081,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-04-11 19:02:22.753');
/*!40000 ALTER TABLE `SyncInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SystemNotification`
--

DROP TABLE IF EXISTS `SystemNotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SystemNotification` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `event` enum('NO_CONNECTION_FOR_X_DAYS') NOT NULL DEFAULT 'NO_CONNECTION_FOR_X_DAYS',
  `unread` tinyint(1) NOT NULL DEFAULT '1',
  `createdAt` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `deletedAt` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `lastSynced` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`uuid`),
  KEY `ownerId` (`ownerId`),
  CONSTRAINT `SystemNotification_ibfk_1` FOREIGN KEY (`ownerId`) REFERENCES `Professional` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SystemNotification`
--

LOCK TABLES `SystemNotification` WRITE;
/*!40000 ALTER TABLE `SystemNotification` DISABLE KEYS */;
/*!40000 ALTER TABLE `SystemNotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Token`
--

DROP TABLE IF EXISTS `Token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Token` (
  `uuid` varchar(36) NOT NULL,
  `ownerId` mediumint unsigned NOT NULL COMMENT 'Le professionnel propriétaire des informations',
  `credentialsId` varchar(36) DEFAULT NULL,
  `token` char(200) NOT NULL,
  `context` char(40) DEFAULT NULL,
  `device` char(255) DEFAULT NULL,
  `created` datetime(3) DEFAULT NULL,
  `lastUpdated` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `token` (`token`),
  KEY `credentialsId` (`credentialsId`),
  CONSTRAINT `Token_ibfk_1` FOREIGN KEY (`credentialsId`) REFERENCES `Credentials` (`uuid`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Token`
--

LOCK TABLES `Token` WRITE;
/*!40000 ALTER TABLE `Token` DISABLE KEYS */;
INSERT INTO `Token` VALUES ('0adc3097-9098-41b5-bb77-426ccb4f4039',662,'00000662-0000-0000-0000-000000000001','ed23a57aeb2c64227421f94a3674e6fe54424874',NULL,NULL,NULL,'2023-03-21 11:32:48.000'),('12272e54-09e0-11ee-b558-229278a3c906',662,'00000662-0000-0000-0000-000000000001','8f8b2838c9415831e0c1d4508851d8fdabf3fa53','software','CondorScan','2023-06-13 13:47:27.694','2023-06-13 11:47:27.694'),('1641e172-d8ec-11ed-8a5a-00d86184ce0e',662,'00000662-0000-0000-0000-000000000001','8ec0f873b7643b3795bf95343c0831ae87154198','software','CondorScan','2023-04-12 06:40:01.565','2023-04-12 04:40:01.565'),('58a9e4e4-5a8b-40d0-952b-97a278077d42',2,'00000002-0000-0000-0000-000000000001','0a7778dd1ccffbb17517648f767cbdb242965e81',NULL,NULL,NULL,'2022-06-27 19:16:26.000'),('6f7d18ff-09e7-11ee-b558-229278a3c906',662,'00000662-0000-0000-0000-000000000001','319b3adef342c93eafbfbe5d132766de8977c384','software','CondorScan','2023-06-13 14:40:10.763','2023-06-13 12:40:10.763'),('a46d755c-d900-11ed-9278-00d86184ce0e',662,'00000662-0000-0000-0000-000000000001','2023c50885d8b53073750a2e78988b1d618b1134','software','CondorScan','2023-04-12 09:07:10.021','2023-04-12 07:07:10.021'),('c1c229e2-09e7-11ee-b558-229278a3c906',662,'00000662-0000-0000-0000-000000000001','811adec0b16c49e32862d21c1dd34dcd279cbcdb','software','CondorScan','2023-06-13 14:42:28.788','2023-06-13 12:42:28.788');
/*!40000 ALTER TABLE `Token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `__db_version__`
--

DROP TABLE IF EXISTS `__db_version__`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `__db_version__` (
  `id` int NOT NULL AUTO_INCREMENT,
  `versionMajor` int NOT NULL,
  `versionMinor` int NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `migrationFile` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `__db_version__`
--

LOCK TABLES `__db_version__` WRITE;
/*!40000 ALTER TABLE `__db_version__` DISABLE KEYS */;
INSERT INTO `__db_version__` VALUES (1,1,0,'v1.0','migration_wow_application_1.0_create_wow_application_from_condor'),(2,1,1,'v1.1','migration_wow_application_1.1_occlusion_pap'),(3,1,2,'v1.2','migration_wow_application_1.2_occlusion_pre_preparation'),(4,1,3,'v1.3','migration_wow_application_1.3_occlusion_rework'),(5,1,4,'v1.4','migration_wow_application_1.4_scan_label'),(6,1,5,'v1.5','migration_wow_application_1.5_order_delivery'),(7,1,6,'v1.6','migration_wow_application_1.6_sheet_json'),(8,1,7,'v1.7','migration_wow_application_1.7_config_patient_list');
/*!40000 ALTER TABLE `__db_version__` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping routines for database 'wow_application'
--
/*!50003 DROP FUNCTION IF EXISTS `fileMetadataToLabel` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `fileMetadataToLabel`(metadata TEXT) RETURNS text CHARSET utf8mb4
    NO SQL
BEGIN
    IF metadata LIKE '%scanBodies%' THEN RETURN 'SCANBODY'; END IF;

    RETURN 'SCAN';
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldTagToNewTag` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldTagToNewTag`(oldType TEXT, oldTag TEXT) RETURNS text CHARSET utf8mb4
    NO SQL
BEGIN
    IF oldTag LIKE '%_PROST_%' THEN
        RETURN oldTagToNewTagForOrderFile(oldType, oldTag);
    END IF;

    IF oldTag LIKE '%_OCC_%' THEN
        RETURN oldTagToNewTagForOcclusionFile(oldType, oldTag);
    END IF;

    IF oldTag LIKE '%SC_%' THEN
        RETURN oldTagToNewTagForScanFile(oldType, oldTag);
    END IF;

    RETURN oldTag;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldTagToNewTagForOcclusionFile` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldTagToNewTagForOcclusionFile`(oldType TEXT, oldTag TEXT) RETURNS text CHARSET utf8mb4
    NO SQL
BEGIN
    IF oldType = 'SNAPS' THEN RETURN REPLACE(oldTag, '__SNAPS_', ''); END IF;

    IF oldType = 'PLY' THEN RETURN REPLACE(oldTag, '__PLY_', ''); END IF;

    IF oldType = 'ZIP' THEN RETURN REPLACE(oldTag, '__ZIP_', ''); END IF;

    IF oldType = 'MATRX' THEN RETURN REPLACE(oldTag, '__MATRX_', ''); END IF;

    IF oldType = 'LIFIM' THEN RETURN REPLACE(oldTag, '_LIFIM_', ''); END IF;

    IF oldType = 'LIFI' THEN RETURN REPLACE(oldTag, '_LIFI_', ''); END IF;

    

    RETURN oldTag;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldTagToNewTagForOrderFile` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldTagToNewTagForOrderFile`(newOrOldType TEXT, newOrOldTag TEXT) RETURNS text CHARSET utf8mb4
    NO SQL
BEGIN
    IF newOrOldType = 'PDF' THEN RETURN REPLACE(newOrOldTag, 'PDF_', 'FORM'); END IF;

    RETURN newOrOldTag;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldTagToNewTagForScanFile` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldTagToNewTagForScanFile`(oldType TEXT, oldTag TEXT) RETURNS text CHARSET utf8mb4
    NO SQL
BEGIN
    IF oldType = 'SNAPS' THEN RETURN TRIM(TRAILING '_' from oldTag); END IF;

    IF oldType = 'PLY' THEN RETURN REPLACE(oldTag, 'PLY_', 'MODEL'); END IF;
    IF oldType = 'ZIP' THEN RETURN REPLACE(oldTag, 'ZIP_', 'MODEL'); END IF;

    IF oldType = 'LIFIM' THEN RETURN TRIM(TRAILING '_' from oldTag); END IF;

    IF oldType = 'LIFI' THEN RETURN TRIM(TRAILING '_' from oldTag); END IF;

    IF oldType = 'SCREENS' THEN RETURN TRIM(TRAILING '_' from oldTag); END IF;

    RETURN oldTag;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewFileType` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewFileType`(oldType TEXT) RETURNS text CHARSET utf8mb4
    NO SQL
BEGIN
    IF oldType = 'SNAPS' THEN RETURN 'PNG'; END IF;

    IF oldType = 'PLY' THEN RETURN 'PLY'; END IF;

    IF oldType = 'ZIP' THEN RETURN 'ZIP'; END IF;

    IF oldType = 'PDF' THEN RETURN 'PDF'; END IF;

    IF oldType = 'JSON' THEN RETURN 'JSON'; END IF;

    IF oldType = 'STL' THEN RETURN 'STL'; END IF;

    IF oldType = 'MATRX' THEN RETURN 'BIN'; END IF;

    IF oldType = 'LIFIM' THEN RETURN 'BIN'; END IF;

    IF oldType = 'LIFI' THEN RETURN 'XYZ'; END IF;

    IF oldType = 'CONTACT' THEN RETURN 'PLY'; END IF;

    IF oldType = 'SCREENS' THEN RETURN 'PNG'; END IF;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewOcclusionFileType` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewOcclusionFileType`(oldType TEXT) RETURNS text CHARSET utf8mb4
    NO SQL
BEGIN
    IF oldType = 'OCCLUSION_RESULT' THEN RETURN 'RESULT'; END IF;

    IF oldType = 'MANDIBULE_PLY' THEN RETURN 'MANDIBLE'; END IF;

    IF oldType = 'MAXILLAIRE_PLY' THEN RETURN 'MAXILLARY'; END IF;

    IF oldType = 'MANDIBULE_MATRIX' THEN RETURN 'MANDIBLE_MATRIX'; END IF;

    IF oldType = 'MAXILLAIRE_MATRIX' THEN RETURN 'MAXILLARY_MATRIX'; END IF;

    IF oldType = 'LIFIMETA' THEN RETURN 'LIFIMETA'; END IF;

    IF oldType = 'LIFI' THEN RETURN 'LIFI'; END IF;

    IF oldType = 'SNAPSHOT' THEN RETURN 'SNAPSHOT'; END IF;

    IF oldType = 'SCREENSHOT' THEN RETURN 'SCREENSHOT'; END IF;

    
    IF oldType = 'LEFT_BITE' THEN RETURN 'RESULT'; END IF;
    IF oldType = 'RIGHT_BITE' THEN RETURN 'RESULT'; END IF;
    IF oldType = 'ANTERIOR_BITE' THEN RETURN 'RESULT'; END IF;

    RETURN oldType;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewProstheticContactPoint` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewProstheticContactPoint`(old TEXT) RETURNS int
    NO SQL
BEGIN
    IF old = '2' THEN RETURN 0; END IF;
    IF old = '3' THEN RETURN 1; END IF;
    IF old = '4' THEN RETURN 2; END IF;
    RETURN 1;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewProstheticCrownOrBridgeSubType` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewProstheticCrownOrBridgeSubType`(old TEXT) RETURNS int
    NO SQL
BEGIN
    IF old = '1' THEN RETURN 0; END IF;
    IF old = '2' THEN RETURN 1; END IF;
    IF old = '3' THEN RETURN 2; END IF;
    RETURN 0;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewProstheticGouttiereSubType` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewProstheticGouttiereSubType`(old TEXT) RETURNS int
    NO SQL
BEGIN
    IF old = '1' THEN RETURN 1; END IF;
    IF old = '2' THEN RETURN 2; END IF;
    IF old = '3' THEN RETURN 3; END IF;
    IF old = '4' THEN RETURN 0; END IF;
    IF old = '5' THEN RETURN 4; END IF;
    IF old = '6' THEN RETURN 5; END IF;
    IF old = '7' THEN RETURN 6; END IF;
    RETURN 0;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewProstheticImplantCrownSubType` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewProstheticImplantCrownSubType`(old TEXT) RETURNS int
    NO SQL
BEGIN
    IF old = '1' THEN RETURN 0; END IF;
    IF old = '2' THEN RETURN 1; END IF;
    IF old = '3' THEN RETURN 0; END IF;
    IF old = '4' THEN RETURN 1; END IF;
    RETURN 2;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldToNewProstheticInlayOnlaySubType` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldToNewProstheticInlayOnlaySubType`(old TEXT) RETURNS int
    NO SQL
BEGIN
    IF old = '1' THEN RETURN 0; END IF;
    IF old = '2' THEN RETURN 1; END IF;
    RETURN 2;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldTypeToNewOcclusionFileType` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldTypeToNewOcclusionFileType`(oldOcclusionFileType TEXT, oldTag TEXT, oldType TEXT) RETURNS text CHARSET utf8mb4
    NO SQL
BEGIN
    IF oldOcclusionFileType = 'OCCLUSION_RESULT' THEN
        IF oldType = 'SNAPS' THEN RETURN 'SNAPSHOT'; END IF;

        IF oldType = 'SCREENS' THEN RETURN 'SCREENSHOT'; END IF;

        IF oldType = 'MATRX' THEN
            IF oldTag LIKE '%TOMA%' THEN RETURN 'MAXILLAIRE_MATRIX'; END IF;
            RETURN 'MANDIBULE_MATRIX'; 
        END IF;

        IF oldType = 'PLY' THEN
            IF oldTag LIKE '%TOPLY%' THEN RETURN 'MAXILLAIRE_PLY'; END IF;
            RETURN 'MANDIBULE_PLY'; 
        END IF;

        IF oldType = 'ZIP' THEN
            IF oldTag LIKE '%TOPLY%' THEN RETURN 'MAXILLAIRE_PLY'; END IF;
            RETURN 'MANDIBULE_PLY'; 
        END IF;

        IF oldType = 'LIFIM' THEN RETURN 'LIFIMETA'; END IF;

        IF oldType = 'LIFI' THEN RETURN 'LIFI'; END IF;
    END IF;

    RETURN oldOcclusionFileType;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldTypeToNewOrderFileType` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldTypeToNewOrderFileType`(oldType TEXT) RETURNS text CHARSET utf8mb4
    NO SQL
BEGIN
    IF oldType = 'PDF' THEN RETURN 'FORM'; END IF;

    RETURN 'SCAN';
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `oldTypeToNewScanFileType` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `oldTypeToNewScanFileType`(oldType TEXT) RETURNS text CHARSET utf8mb4
    NO SQL
BEGIN
    IF oldType = 'SNAPS' THEN RETURN 'SNAPSHOT'; END IF;

    IF oldType = 'PLY' THEN RETURN 'MODEL'; END IF;

    IF oldType = 'ZIP' THEN RETURN 'MODEL'; END IF;

    IF oldType = 'LIFIM' THEN RETURN 'LIFIMETA'; END IF;

    IF oldType = 'LIFI' THEN RETURN 'LIFI'; END IF;

    IF oldType = 'SCREENS' THEN RETURN 'SCREENSHOT'; END IF;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `scanMetadataToLabel` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `scanMetadataToLabel`(metadata TEXT) RETURNS text CHARSET utf8mb4
    NO SQL
BEGIN
    IF metadata LIKE '%"isPrePreparation":true%' THEN RETURN 'PRE_PREPARATION'; END IF;

    RETURN 'SCAN';
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `scanTypeFromFileTag` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `scanTypeFromFileTag`(tag TEXT) RETURNS text CHARSET utf8mb4
    NO SQL
BEGIN
    IF tag LIKE '%_TOSC_%' THEN
        RETURN 'MAXILLAIRE';
    END IF;

    IF tag LIKE '%_BOSC_%' THEN
        RETURN 'MANDIBULE';
    END IF;

    IF tag LIKE '%_LESC_%' THEN
        RETURN 'MORDU_POSTERIEUR_GAUCHE';
    END IF;

    IF tag LIKE '%_RISC_%' THEN
        RETURN 'MORDU_POSTERIEUR_DROIT';
    END IF;

    IF tag LIKE '%_FRSC_%' THEN
        RETURN 'MORDU_ANTERIEUR';
    END IF;

    RETURN '';
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-06-13 14:54:20
